﻿USE sofia;
DROP TABLE IF EXISTS sofia.lifNT2_vpl;
CREATE TABLE lifNT2_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lifNT2_vpl WRITE;
INSERT INTO lifNT2_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ये़सु ख्रिस्‍ते़न्‌ अब्राहामरे़ कुस्‍साः हे़क्‍क्‍याङ् दाउद हाङ्‌ङिल्‍ले़ कुस्‍साः वये़रो॥ कङ्‌ग खुने़ॽ कुधाःक्‍हाॽरे़ खुनिॽ मिङ्‌स्रारो– ");
INSERT INTO lifNT2_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","अब्राहामरे़ कुस्‍साः इसहाक वये़, इसहाकरे़ कुस्‍साः याकुब वये़, याकुबरे़ कुस्‍साःहाॽ यहुदा हे़क्‍क्‍याङ् खुने़ॽ कुम्‍भुॽ कुन्‍साॽसि मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","हे़क्‍क्‍याङ् यहुदाःल्‍ले़ कुस्‍साःहाॽ पेरेज नु जिराह वये़त्‍छि (खे़ङ्‌हाॽरे़ खुन्‍छिॽ माःल्‍ले़ कुमिङ् तामार वये़), फारे़सरे़ कुस्‍साः हे़स्रोन वये़, हे़स्रोनरे़ कुस्‍साः आराम वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","हे़क्‍क्‍याङ् आरामरे़ कुस्‍साः अम्‍मिनादाब वये़, अम्‍मिनादाबरे़ कुस्‍साः नहसोन वये़, नहसोनरे़ कुस्‍साः सल्‍मोन वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","हे़क्‍क्‍याङ् सल्‍मोनरे़ कुस्‍साः बोअज वये़ (बोअजरे़ कुम्‍मारे़ कुमिङ् राहाब वये़), बोअजरे़ कुस्‍साः ओबेद वये़ (खे़ल्‍ले़ कुम्‍मारे़ कुमिङ् रुथ वये़), ओबेदरे़ कुस्‍साः यिसै वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","हे़क्‍क्‍याङ् यिसैरे़ कुस्‍साः दाउद हाङ्‌ङिन्‌वये़॥ दाउद हाङ्‌ङिल्‍ले़ कुस्‍साः सोलोमन वये़ (सोलोमनरे़ कुम्‍मा बेत्सेबाःन् उरियाहरे़ कुमेःत् वये़रो॥) ");
INSERT INTO lifNT2_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","हे़क्‍क्‍याङ् सोलोमनरे़ कुस्‍साः रहोबाम वये़, रहोबामरे़ कुस्‍साः अबिया वये़, अबियारे़ कुस्‍साः आसा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","हे़क्‍क्‍याङ् आसारे़ कुस्‍साः यहोसापात वये़, यहोसापातरे़ कुस्‍साः यहोराम वये़, यहोरामरे़ कुस्‍साः उज्‍जियाह वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","हे़क्‍क्‍याङ् उज्‍जियाहरे़ कुस्‍साः योताम वये़, योतामरे़ कुस्‍साः आहाज वये़, आहाजरे़ कुस्‍साः हिजकिया वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","हे़क्‍क्‍याङ् हिजकियारे़ कुस्‍साः मनस्‍से वये़, मनस्‍सेरे़ कुस्‍साः अम्‍मोन वये़, अम्‍मोनरे़ कुस्‍साः योसियाह वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","हे़क्‍क्‍याङ् योसियाहरे़ कुस्‍साःहाॽ यकोनियास नु कुन्‍साॽसि मे़वये़रो (खे़ङ्‌हाॽग इस्राइलिहाॽ बे़बिलोन लाजेॽओ मे़दे़म्‍सु मे़देॽरुसिआङ् मे़गत्तुसिबा ये़म्‍मो सामे़वाःन्‍छिङ्‌ङाङ्‌मे़वये़रो)॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","बे़बिलोःन्‍नो मे़देॽरुसिआङ् याङ्‌सि यकोनियासरे़ कुस्‍साः सालतिएल वये़, हे़क्‍क्‍याङ् सालतिएलरे़ कुस्‍साः यरुबाबेल वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","हे़क्‍क्‍याङ् यरुबाबे़लरे़ कुस्‍साः अबिउद वये़, अबिउदरे़ कुस्‍साः एलियाकिम वये़, एलियाकिमरे़ कुस्‍साः आजोर वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","हे़क्‍क्‍याङ् आजोररे़ कुस्‍साः सादोक वये़, सादोकरे़ कुस्‍साः आखिम वये़, आखिमरे़ कुस्‍साः एलिउद वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","हे़क्‍क्‍याङ् एलिउदरे़ कुस्‍साः एलाजार वये़, एलाजाररे़ कुस्‍साः मत्तान वये़, मत्तानरे़ कुस्‍साः याकुब वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","हे़क्‍क्‍याङ् याकुबरे़ कुस्‍साः युसुफ वये़॥ युसुफे़न् मरियमरे़ कुये़म्‍बाॽ वये़, हे़क्‍क्‍याङ् हाबा कन् मरियम्‍मिन्‍लाम् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त मे़प्‍मनाबा ये़सुःन् सावाःन्‍छिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","अक्‍खेलॽरिक् अब्राहामलाम् दाउद हाङ् थारिक् थिक्-लि (१४) थाःक् मे़वये़, हे़क्‍क्‍याङ् दाउद हाङ्‌लाम् बे़बिलोन लाजेॽओ मे़दे़म्‍सु मे़देॽरुसिआङ् मे़गत्तुसिबा ये़म् थारिक् थिक्-लि (१४) थाःक् मे़वये़, हे़क्‍क्‍याङ् बे़बिलोःन्‍नो पुङ्‌लाधाबा मे़जोगुसिआङ् मे़देॽरुसिबा ये़म्‍माङ्‌धो निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌सावाःन्‍छिङ्‌बा ये़म् थारिक् थिक्-लि (१४) थाःक् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","आल्‍ल ये़सु ख्रिस्‍तरे़ कुसावाःन्‍छिङ्‌मान् अक्‍खेलॽरिक् पोःक्‍खे़रो–कुम्‍मा मरियमरे़ कुमेःक्‍खिम् पोःङ्‌मा पाःन्‍निन् युसुफे़न्‍नु पुॽरे़आङ् वये़, कर खुन्‍छिॽ मेःक्‍खिम् पोःङ्‌मानुःल्‍ले़ तगिए खुने़ॽ सेसेमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍लाम् मे़न्‍छुक्‍मा पोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","खुने़ॽनु कुमेःक्‍खिम् पाःन् के़बुॽबा युसुफे़ङ्‌ग साम्‌योनिबा मना वये़बाल्‍ले़ चोगुल्‍ले़ कुजाःत्‍थि मे़बेःक्‍ने़न्‍ल फाॽआङ् खे़ल्‍ले़ स्‍वाःत्ताङ् नाॽमा निङ्‌वाॽ चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","कर हे़क्‍के इःत्तुर वये़ल्‍ले़ से़प्‍माङ्‌मो यहवे दाङ्‌बाल्‍ले़ कुमाङ्‌लाइङ्‌बान् ओसेःन्‍धाक्‍सिङ्‌ङाङ्‌अक्‍खे मे़त्तुरो, “दाउदरे़ कुमुॽइदाङ्‌सा युसुप्‍फे, खे़ने़ॽ मरियम्‍मिन् मेःक्‍खिम् चोःक्‍माआङ् हिम्‍मो ताःप्‍मा मे़गिसे़न्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ खुने़ॽओबा अङे़ःक्‌वाःन् सेसेमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍लाम्‍बा हाङ्‌सिङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","खुने़ॽ ये़म्‍बित्‍छाॽसाःधिक् कत्तुॽ, हे़क्‍क्‍याङ् खे़ल्‍ले़ कुमिङ्‌ङिन् ये़सु वाःत्ते़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ कुमनाहाॽ खुनिॽ लायोलाम् ताङ्‌से़ःप्‍तुसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पालाम् यहवे दाङ्‌बाल्‍ले़ उन्‍छेःन् अक्‍खेलॽरिक् पाःत्तुआङ् वये़बा पाःन्‍निन् के़त्‍ल फाॽआङ् कन् के़रे़क् पाःन्‍हाॽ पोःक्‍खे़बारो– ");
INSERT INTO lifNT2_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“सिसादिङ् मे़न्‍छियाॽइन् मे़न्‍छुक्‍मा पोःङ्‌ङाङ् ये़म्‍बित्‍छाॽसाःधिक् कत्तुॽ, हे़क्‍क्‍याङ् खे़न् इम्‍मानुएल मे़मे़त्तुॽरो॥ ‘इम्‍मानुएल’ फाॽइङ्‌ग ‘निङ्‌वाॽफुमाङ्‌ङिन् आनिॽनु वाॽ’ पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","आल्‍ल युसुफे़न् से़प्‍माङ्‌मोलाम् सोरे़आङ् यहवे दाङ्‌बाल्‍ले़ कुमाङ्‌लाइङ्‌बाल्‍ले़ मे़त्तुबा कुइसिःक्‍के मरियम्‍मिन् मेःक्‍खिम् मे़त्तु, हे़क्‍क्‍याङ् कुहिम्‍मो तारुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","कर मरियम्‍मिन् मे़न्‍छुक्‍मा वये़र थारिक् खुन्‍छिॽ सोरिक् मे़इप्‍से़त्‍छिन्‍लो॥ याङ्‌सि मरियम्‍मिल्‍ले़ साः कत्तुआङ् युसुफरे़ खे़न् अङे़ःक्‌वाःन् ये़सु मिङ् वाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","आल्‍ल ये़सुःन् यहुदिया थुम्‍मोबा बे़थलेहे़म पाङ्‌जुम्‍मो सावाःन्‍छिङ्‌बा ये़म्‍मो हे़रोद हाङ्‌ङिल्‍ले़ खे़प्‍मो हाङ् चोगुर वये़रो॥ ये़सुःन् सावाःन्‍छिङ्‌ङाङ् नाम्‍गे़न् पिसाङ्‌बा लाजेॽलाम् सिक्‍कुम्‍निबा खागे़इक्‍पाहाॽ यरुसले़म्‍मो मे़द्‌ये़, हे़क्‍क्‍याङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","अक्‍खेलॽरिक् पाःन् सेःन्‍मे़दोसु, “यहुदिहाॽरे़ खुनिॽ हाङ् के़बोःङ्‌बाआङ् सागे़वाःन्‍छिङ्‌बान् आत्तो वाॽबे? आनिगे़ नाम्‍गे़न् पिसाङ् कुसावाःन्‍छिङ्‌माल्‍ले़न् मिक्‍सेःन् के़बिबा खेःम्‍सिक्‍किन् निःसुम्‍बे़आङ् खुने़ॽ कुसेवा चोःक्‍से़ त्‍ये़ॽइगे़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","हे़रोद हाङ्‌ङिल्‍ले़ कन् पाःन्‍निन् खे़प्‍सुआङ् कुनिङ्‌वाॽबाल्‍ले़ साॽरिक् ये़ःक्‍खु, हे़क्‍केलॽरिक्‍के खुने़ॽनुए यरुसले़म्‍मोबा के़रे़क् मनाहाॽआङ् खुनिॽ निङ्‌वाॽबाल्‍ले़ साॽरिक् ये़ःक्‍खुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","हे़रोद हाङ्‌ङिल्‍ले़ के़रे़क् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ उःत्तुसिआङ् कन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त मे़प्‍मनाबान् आत्तो सावाःन्‍छिङ्‌मा के़बोःङ्‌बा वाॽबे लॽरिक् सेःन्‍दोसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “यहुदिया थुम्‍मोबा बे़थलेहे़म्‍मो खुने़ॽ सावाःन्‍छिङ्‌मा के़बोःङ्‌बा वाॽरो॥ थेआङ्‌भे़ल्‍ले़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाल्‍ले़ अक्‍खेलॽरिक् साप्‍तुआङ् पत्– ");
INSERT INTO lifNT2_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘यहुदिया थुम्‍मोबा बे़थलेहे़म्‍मे, खे़ने़ॽग यहुदियाबा पाङ्‌जुम्‍हाॽओ साॽरिक् के़ये़क्‍पा के़जोःक्‍लो, थेआङ्‌भे़ल्‍ले़ खे़ने़ॽ के़बाङ्‌जुम्‍लाम् हाङ्‌युक्‍पाधिक् ताःरो, खुने़ॽग मे़ल्‍लुक्‍कम्‍बा कुइसिःक् पोःङ्‌ङाङ् आमना इस्राइलिहाॽ कम्‍ब्राङ् के़मे़प्‍पा पोःङ्‌लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","हे़रोद हाङ्‌ङिल्‍ले़ खे़न् सिक्‍कुम्‍निबा खागे़इक्‍पाहाॽ स्‍वाःत्ताङ् उःत्तुसि हे़क्‍क्‍याङ् खे़ङ्‌हाॽलाम् खेःम्‍सिक्‍पान् थाःम्‍सिङ्‌बा कुजे़क् ये़म्‍मिन् निङ्‌वाॽ खोःसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ अक्‍खे मे़त्तुसिर बे़थलेहे़म्‍मो पाङ्‌घुदेःसुसि, “पेगे़म्‍मे़ॽआङ् अङे़ःक्‌वाःन् कोःत्ते़म्‍मे़ॽ॥ खे़न् अङे़ःक्‌वाःन् के़घोःसुम्‍ने़ फाॽग्र फे़रे़म्‍मे़ॽआङ् इङ्‌गाॽ आमे़त्ते़म्‍मे़ॽओ॥ इङ्‌गाॽआङ् खुने़ॽ सेवा मे़त्तुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","हे़रोद हाङ्‌ङिल्‍ले़ पाःत्तुबा पाःन्‍निन् मे़घे़प्‍सुआङ् खे़ङ्‌हाॽ मे़धासिङ्‌लो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खे़न् खेःम्‍सिक्‍पान् याम्‍मो मे़निःसु हे़क्‍क्‍याङ् खुनिॽ तगि तगि पेआङ् अङे़ःक्‌वा वये़बा हिम्‌कुदोःप्‍मा के़रे़आङ् फन्‍छिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","खे़ङ्‌हाॽरे़ खे़न् खेःम्‍सिक्‍पान् याम्‍मो मे़निःसुआङ् साॽरिक् मे़सःत्ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","हिम् सिगाङ् मे़लाःस्‍से़ल्‍ले़ अङे़ःक्‌वाःन् नु कुम्‍मा मरियम्‍मिन् मे़निःसुसिरो॥ खे़ङ्‌हाॽरे़ साम्‍बोःन्‍नाङ् अङे़ःक्‌वाःन् सेवा मे़मे़त्तु, हे़क्‍क्‍याङ् सुःक्‌वाःन्‌मे़भाःक्‍खुआङ् साम्‍म्‍याङ्, थिक् परिक्‍पा इमे़ल्‍लुङ्‌बा साङ्‌सिङ् नु कुनाम् के़नुॽबा मुर्रहाॽ मे़दोःन्‍दु मे़बिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","हे़क्‍क्‍याङ् से़प्‍माङ्‌मो माङ्‌लाइङ्‌बाल्‍ले़ खे़ङ्‌हाॽ हे़रोद हाङ्‌ङिल्‍लो मे़नुःक्‍खे़म् मे़बेगे़म्‍मिन्‍ने़ॽओ लॽरिक् साम्‍दिङ् पिरुसिबाल्‍ले़ खे़ङ्‌हाॽ वेॽलाम् आबाङे लाजेॽओ मे़नुःक्‍खे़ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","खे़न् सिक्‍कुम्‍निबा खागे़इक्‍पाहाॽ मे़बे हे़क्‍क्‍याङ् यहवे दाङ्‌बाल्‍ले़ कुमाङ्‌लाइङ्‌बाधिक् युसुफरे़ कुसे़प्‍माङ्‌मो थाःन्‍छिङ्‌ङाङ् अक्‍खे मे़त्तु, “पोगे़ॽआङ् अङे़ःक्‌वाःन् नु कुम्‍माःन् तेॽरे़से़ॽआङ् मिस्र लाजेॽओ खे़त्‍छिङ् पेगे़ॽ, हे़क्‍क्‍याङ् इङ्‌गाॽ मे़म्‍मे़त्ते थारिक् खे़ने़ॽ खे़प्‍मोए वये़ॽओ, थेआङ्‌भे़ल्‍ले़ हे़रोद हाङ्‌ङिल्‍ले़ अङे़ःक्‌वाःन् से़प्‍मा फाॽआङ् कोःत्तुर वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","बा खे़न् से़न्‍दिक्‍सा युसुफरे़ अङे़ःक्‌वाःन् नु कुम्‍माःन् तेॽरुसिआङ् मिस्रओ खे़त्‍छिङ् पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","हे़रोद हाङ्‌ङिन् मे़न्‍छिःए थारिक् खुने़ॽ खे़प्‍मोए याःक्‍ते़रो॥ हे़क्‍केलॽरिक् यहवे दाङ्‌बाल्‍ले़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पालाम् इङ्‌गाॽ आस्‍साःन् मिस्रलाम् लाःक्‍कात् उःत्तुङ्‌लो लॽरिक्‌उन्‍छेःन् पाःत्तुबान् के़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","आल्‍ल हे़रोद हाङ्‌ङिल्‍ले़ सिक्‍कुम्‍निबा खागे़इक्‍पाहाॽरे़ हे़क्‍केलॽरिक् खुने़ॽ इङ्‌मे़ले़क्‍तुआङ् वेॽ लाम् मे़बेबा निङ्‌वाॽ खोःसुआङ् साॽरिक् कुसिक् पोगे़रो॥ खे़ल्‍ले़ चोगुल्‍ले़ थक्‍सुबाहाॽ पाङ्‌घुसिआङ् बे़थलेहे़म नु खे़न् खिरिबा तङ्‌बे ने़त्‍छिआङ् योबा ये़म्‍बित्‍छाॽ अङे़ःक्‌वा साःहाॽ के़रे़क् से़प्‍पाङ्‌घुसिरो॥ थेआङ्‌भे़ल्‍ले़ खे़न् सिक्‍कुम्‍निबा खागे़इक्‍पाहाॽलाम् खेःम्‍सिक्‍पान् तङ्‌बे ने़त्‍छिआङ्धो तगि थाःम्‍सिङ्‌बा निङ्‌वाॽ खोःसुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","खे़ङ्‌ग यर्मिया माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाल्‍ले़ अक्‍खेलॽरिक् उन्‍छेःन् पाःत्तुबा माङ्‌निङ्‌वाॽपाःन्‍निन् के़रे़बारो– ");
INSERT INTO lifNT2_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“के़हाःप्‍मा के़भिःक्‍मा नु मेरिङ् के़धक्‍मा यम्‍बा इक्‍लाःन् रामा पाङ्‌जुम्‍मो खे़म्‍दे़त्‍लो, राहे़लरे़ कुस्‍साःहाॽ हाःप्‍तुसिॽरो॥ खे़ङ्‌ग हाङ्‌हाङ् मे़त्‍छिङ्‌मा मे़दे़न्‍ने़न्‍लो, थेआङ्‌भे़ल्‍ले़ कुस्‍साःहाॽ के़रे़क् मे़स्‍ये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","आल्‍ल हे़रोद हाङ्‌ङिन् स्‍ये़आङ् मिस्र लाजेॽओ युसुफे़न्‍नु यहवे दाङ्‌बाल्‍ले़ कुमाङ्‌लाइङ्‌बान् कुसे़प्‍माङ्‌मो थाःन्‍छिङ्‌ङाङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","मे़त्तु, “पोगे़ॽआङ् अङे़ःक्‌वाःन् नु कुम्‍माःन् इस्राइल लाजेॽओ तेॽरे़से़ॽओ, थेआङ्‌भे़ल्‍ले़ अङे़ःक्‌वाःन् से़प्‍मा के़गोःप्‍पे़न्‌स्‍ये़आङ् होःप्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","खे़ल्‍ले़ चोगुल्‍ले़ युसुफरे़ अङे़ःक्‌वाःन् नु कुम्‍माःन् इस्राइल लाजेॽओ तेॽरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","कर हे़रोद हाङ्‌ङिन् स्‍ये़आङ् खुने़ॽ कुले़क्‌वा कुस्‍साः अर्खिलाउसरे़ यहुदिया थुम्‍मो हाङ् चोगुर वाॽ के़लॽबान् युसुफरे़ निङ्‌वाॽ खोःसुआङ् खुने़ॽ खे़प्‍मो पेःक्‍मा किःसे़॥ हे़क्‍क्‍याङ् माङ्‌लाइङ्‌बाल्‍ले़ याम्‍मो से़प्‍माङ्‌मो साम्‍दिङ् पिरुबाल्‍ले़ चोगुल्‍ले़ खुने़ॽ गालिल थुम्‍मो पेआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","नासरत पाङ्‌जुम्‍मो वाॽमा हेःक्‍ते़रो॥ कङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ थुक्‍तुबाङ्‌ग नासरि मे़मे़त्तु” लॽरिक् मे़बाःत्तुबा पाःन्‍निन् के़रे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","खे़न् ये़म्‍मो बप्‍तिस्‍मा के़बिबा युहुन्‍ना मे़प्‍मनाबा मनाःन् यहुदिया थुम्‍मोबा एःक्‍सादे़न्‍नो अक्‍खेलॽरिक् इङ्‌भन् चोगुर त्‍ये़, ");
INSERT INTO lifNT2_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“खिनिॽ लायोलाम् हिन्‍दे़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिन् निःत्ताङ्‌ङे त्‍ये़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","खुने़ॽ कुयाःम्‍बेओ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ अक्‍खेलॽरिक् पाःत्तुआङ् वाॽरो, “खुने़ॽ एःक्‍सादे़न्‍नो अक्‍खेलॽरिक् के़अःक्‍पा इक्‍लारो, ‘दाङ्‌बाल्‍ले़ कुमाराम्‍मिन् यारिप् चोगे़म्‍मे़ॽआङ् कुलाम्‍हाॽ तोःन्‍दोःन्‌चोगे़म्‍मे़ॽ!’” ");
INSERT INTO lifNT2_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","आल्‍ल युहुन्‍नाःल्‍ले़ उमेरे़ कुमुरिक्‍लाम् थाक्‍मनाबा तेःत्तिन् चाक्‍खुआङ् से़होबा फॽइ युप्‍सुरो॥ खुने़ॽ कुजामाङ्‌ग निःङ्‌घुःक्‌वा नु ताम्‍भुङ् सक्‌वाघु वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","यरुसले़म ये़क्‌यक्‍लाम् नु यहुदिया थुम् हे़क्‍क्‍याङ् यर्दन यङ्‌घङ् खिरिबा के़रे़क् थुम्‍हाॽओलाम् मनाहाॽ कुदुम्‍से़ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","मे़द्‌ये़आङ् इङ्‌गाॽ लायोबाआरो मे़बाःत्तुर यर्दन यङ्‌घङ्‌ङो खुने़ॽलाम् बप्‍तिस्‍मा मे़बोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","कर यरिक् फरिसिहाॽ नु सदुकिहाॽ बप्‍तिस्‍मा पोःङ्‌से़ खुने़ॽओ मे़द्‌ये़र मे़बत्‍छे़बा निःसुसिआङ् अक्‍खे मे़त्तुसिर फे़ःक्‍तुसि, “असेःक्‍सासे, खिनिॽ कन् के़दाःबार के़बप्‍पा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुघुम्‍दिङ्‌लाम् खे़त्‍छिङ्‌ङे़म्‍मे़ॽ फाॽआङ् हाःत्‍ले़ के़मे़त्तिबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","लायोलाम् के़हिन्‍दिबा पाःन्‍निन् ओसेःन्‍दाङ् चोःक्‍से़ नुःबा याःम्‍बक् चोगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","आनिगे़ग अब्राहामरे़ कुस्‍साःसिगे़, खे़ल्‍ले़ चोगुल्‍ले़ खुम्‍दिङ्‌लाम् खे़त्‍छिङ्‌मा सुक्‍तिगे़ॽ फाॽआङ् निङ्‌वाॽ मे़इःत्ते़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ग कन् लुङ्‌हाॽआङ् अब्राहामरे़ कुस्‍साः चोःक्‍मा सुक्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","आल्‍लोसा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुघासे़न्‍निल्‍ले़ तःन्‍दिङ्‌ग सिङ्‌बुङ्‌मो खा चुक्‍मा इःत्ते़आङ् वाॽ॥ नुःबा सिङ्‌सेॽ मे़न्‍धोःक्‍मनाबा सिङ्‌बुङ्‌हाॽ के़रे़क् ताङ्‌माआङ् मिओ लाप्‍फुमा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","लायोलाम् के़हिन्‍दिआङ् इङ्‌गाॽग च्‍वाःत्तिल्‍ले़ बप्‍तिस्‍मा पिनिङ्‌लो, कर आएगाङ् के़दाःबे़ङ्‌ग इङ्‌गाॽनुःल्‍ले़आङ् मुक्‍साम्‍साबा चोःक्‍लो॥ खुने़ॽ कुलाङ्‌सुःप्‍हाॽ इङ्‌गाॽ योःक् कुइसिःक् पङ्‌माआङ् मे़लाॽआन्‍लो॥ खुने़ॽ सेसेमाङ् नु मिःल्‍ले़ बप्‍तिस्‍मा के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","कुभॽएःत्तिल्‍ले़ सिःन् आःम्‍मा फाॽआङ् खुने़ॽ यारिप् वाॽ, हे़क्‍क्‍याङ् खुने़ॽ तुगुर सुप्‍सुआङ्‌सिःन् चाधोःक्‍लाओ चिक्‍खुॽ हे़क्‍क्‍याङ् कुहक्‍हाॽ आप्‍फाल्‍ले़आङ् मे़न्‍छिःमनाबा मिओ हाःन्‍दुदेःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","खे़न् ये़म्‍मो ये़सुःन् गालिल थुम्‍मोलाम् यर्दन यङ्‌घङ्‌ङो बप्‍तिस्‍मा पोःङ्‌से़ युहुन्‍नारो त्‍ये़रो, ");
INSERT INTO lifNT2_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","कर युहुन्‍नारे़ अत्तुर खुने़ॽ अक्‍खे मे़त्तु, “इङ्‌गाॽने़ खे़ने़ॽनु बप्‍तिस्‍मा पोःङ्‌मा के़बोःङ्‌बा, आक्‍खेलॽरिक् खे़ने़ॽ इङ्‌गाॽओ के़द्‌ये़बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ये़सुरे़ नोगप् पिरु, “आल्‍लोरे़ लागि अक्‍खेए पोःङ्‌लरो, अक्‍खेलॽरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़रे़क् निङ्‌वाॽ चोगुबा पाःन्‍निन् के़त्‍लरो॥” हे़क्‍क्‍याङ् युहुन्‍नाःन् ते़न्‍दे़आङ् खुने़ॽ बप्‍तिस्‍मा पिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ये़सुःन् बप्‍तिस्‍मा पोःक्‍खे़आङ् च्‍वाःत्तोलाम् लाःक्‍कात् लःन्‍दे़नुमे़ःन्‍ने ताङ्‌साक्‍पे़न्‌हरे़आङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसेसेमाङ्‌ङिन् पुत्तुःक्‍के हे़क्‍के खुने़ॽ कुसम्‍दाङ् ये़ःर पत्‍छे़बा निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","हे़क्‍क्‍याङ् साङ्‌ग्राम्‍पेदाङ्‌लाम् अक्‍खेलॽरिक् इक्‍लाधिक् त्‍ये़, “कन् आमिःम् आस्‍साःरो, इङ्‌गाॽ खुने़ॽनु साॽरिक् सःत्ताङ्‌ङाङ् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","हे़क्‍क्‍याङ् सेसेमाङ्‌ङिल्‍ले़ ये़सुःन् माफे़न्‍साम्‍लाम् कुनिङ्‌वाॽ साॽसे़ एःक्‍सादे़न्‍नो तेॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","खे़प्‍मो खुने़ॽ लिबोःङ्‌(४०) से़न्‍दिक् नु ले़न्‍दिक् थारिक् थेआङ् मे़जने़न्‍नाङ् साॽरिक् कुसे़त्‍लाःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","हे़क्‍क्‍याङ् माफे़न्‍साम्‍मिन् खे़प्‍मो त्‍ये़आङ् खुने़ॽ अक्‍खे मे़त्तुर कुनिङ्‌वाॽ साॽरु, “खे़ने़ॽ निङ्‌वाॽफुसाःने़ फाॽग्र कन् लुङ्‌हाॽ खरे़ःङ् पोःक्‍खे़ॽ फाॽआङ् मे़त्ते़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","कर ये़सुरे़ नोगप् पिरु, “हे़क्‍के मे़जोःक्‍कान्, थेआङ्‌भे़ल्‍ले़ साम्‌योसाप्‍लाओ मोसारे़ अक्‍खेलॽरिक् साप्‍तुआङ् पत्, ‘मे़न्‍छाम् याप्‍मिःङ्‌ग कुजाःल्‍ले़रक् मे़हिङ्‌ने़न्‌, कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाःत्तुबा के़रे़क् पाःन्‍निल्‍ले़ हिङ्‌॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","हे़क्‍क्‍याङ् माफे़न्‍साम्‍मिल्‍ले़ खुने़ॽ यरुसले़म्‍मो तेॽरुआङ् माङ्‌हिम्‍मोबा के़रे़क्‍नुःल्‍ले़ केःम्‍बा चम्‍जम्‍बा ते़न्‍नो ये़प्‍सुआङ् मे़त्तु ");
INSERT INTO lifNT2_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“खे़ने़ॽ से़क्‍खाए निङ्‌वाॽफुसाःने़ फाॽग्र पिन्‍दे़ थ्‍ये़ॽ, थेआङ्‌भे़ल्‍ले़ साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् पत्, ‘निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमाङ्‌लाइङ्‌बाहाॽ खे़ने़ॽ के़लागि इङ्‌जाःङ् पिरुसिआङ् खे़ने़ॽ थाःङ्धाःङ्‌ङे खुनिॽ हुक्‍को के़म्‍दाःक्‍काङ् के़लाङ्‌ङिन् लुङ्‌ङो मे़धाम्‍सिङ्‌ङिन्‍लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ये़सुरे़ नोगप् पिरु, “कर साम्‌योसाप्‍लाओ याम्‍मो अक्‍खेलॽरिक्‍काङ् साप्‍ते़आङ् पत्, ‘दाङ्‌बा के़निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिङ्‌वाॽ मे़साॽरे़न्‍ने़ॽ॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","हे़क्‍क्‍याङ् माफे़न्‍साम्‍मिल्‍ले़ खुने़ॽ साॽरिक् चम्‍जम्‍बा कोःक्‍माओ तेॽरुआङ् इक्‍सादिङ् खाम्‍बेःक्‍मोबा के़रे़क् हाङ्‌जुम्‍हाॽ हे़क्‍क्‍याङ् खे़प्‍मोबा पयम्‌यम्‍बा नु नुःब्‌नुःबा पाःन्‍हाॽ ओसेःन्‍धाक्‍तुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","मे़त्तु, “खे़ने़ॽ साम्‍बोःन् के़भन्‍छिङ्‌ङाङ् इङ्‌गाॽ सेवा के़मे़त्ताने़ फाॽग्र कङ्‌हाॽ के़रे़क् पिने़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ये़सुरे़ खे़न् मे़त्तु, “सैताने, कप्‍मोलाम् पेगे़ॽ, थेआङ्‌भे़ल्‍ले़ साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् पत्, ‘खे़ने़ॽ दाङ्‌बा के़निङ्‌वाॽफुमाङ्‌ङिन्‍लक् सेवा मे़त्ते़ॽ हे़क्‍क्‍याङ् खुने़ॽइन्‍लक् कुसेवा चोगे़ॽओ॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","हे़क्‍क्‍याङ् माफे़न्‍साम्‍मिल्‍ले़ ये़सुःन् ले़रुधआङ्‌माङ्‌लाइङ्‌बाहाॽ मे़द्‌ये़ हे़क्‍क्‍याङ् खुने़ॽ कम्‍ब्राङ् मे़मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","आल्‍ल ये़सुरे़ युहुन्‍नाःन् पुङ्‌लाहिम्‍मो मे़साक्‍तुआङ् याक्‌के़लॽबा खे़प्‍सुआङ् खुने़ॽ गालिल थुम्‍मो नुःक्‍खे़ पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","खुने़ॽ नासरत पाङ्‌जुम्‍मिन् ले़रुआङ् कपर्नहुम पाङ्‌जुम्‍मो वाॽसे़ पेरो॥ खे़ङ्‌ग गालिल वरक्‍किल्‍ले़ कुबेसाङ् नाप्‍तालि नु जबुलुन थुम्‍मो ने़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ अक्‍खेलॽरिक् पाःत्तुबा पाःन्‍निन् के़रे़बारो– ");
INSERT INTO lifNT2_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“यर्दन यङ्‌घङ्‌ङिल्‍ले़ नाधाःम्‍बिबा गालिल वरक्‍किल्‍ले़ कुबेसाङ्‌बा नाप्‍तालि नु जबुलुन के़युङ्‌बा याप्‍मिसे, गालिल थुम्‍मो के़वाॽबा थिम्‍मे़न्‍दङ् सुवाङ्से, ");
INSERT INTO lifNT2_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","खादाम्‍मो के़वाॽबा मनाहाॽरे़ पयम् यम्‍बा ओःत्तिःन् मे़निःसुरो॥ सिःमे़ल्‍ले़न् खामाक्‍माओ के़वाॽबाहाॽरे़ खुनिॽ लुम्‍मो ओःत्तिधिक् ओःत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","खे़न् ये़म्‍माङ्धो ये़सुरे़ अक्‍खे पाःत्तुर इङ्‌भोःमा हेःक्‍तु, “लायोलाम् हिन्‍दे़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिन् निःत्ताङ्‌ङे त्‍ये़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","थिक् ये़न् ये़सुःन् गालिल वरक्‍किल्‍ले़ कुयाओ लाङ्‌घेगे़र वये़ल्‍ले़ पत्रुस मे़प्‍मनाबा सिमोने़न् नु कुन्‍साॽ आन्‍द्रियासे़न् निःसुसि॥ खे़ङ्‌हाॽ वरक्‍को योःङ् ले़प्‍ते़त्‍छुर यागे़त्‍छि, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ योःङ् के़ले़प्‍पा वये़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ आएगाङ् थाने़त्‍छे़ॽओ, खिन्‍छिॽ ङा के़दे़म्‍सु के़दाःत्‍छुबा कुइसिःक् इङ्‌गाॽओ मना के़दाःप्‍पा चोःक्‍ने़त्‍छिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","खिमो खे़ङ्‌हाॽरे़ खुन्‍छिॽ योःङ्‌ङिन् ने़स्‍से़त्‍छु थ्‍ये़से़त्‍छुआङ् खुने़ॽनु पेसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","खे़प्‍मोलाम् मिसाक् नानाक् पेःल्‍ले़ ये़सुरे़ जब्‍दियारे़ कुस्‍साः याकुब नु खे़ल्‍ले़ कुन्‍साॽ युहुन्‍नाःन् निःसुसि॥ खे़ङ्‌हाॽ खुन्‍छिॽ पाःन्‍नु खःङ्‌बेओ योःङ् ले़म्‍दे़त्‍छुर यागे़त्‍छि॥ ये़सुरे़ खे़ङ्‌हाॽ उःत्तुसिनुमे़ःन्‍ने ");
INSERT INTO lifNT2_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","खःङ्‌बेन् नु खुन्‍छिॽ पाःन् ले़रे़त्‍छु थ्‍ये़से़त्‍छुआङ् ये़सुःन्‍नु पेसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ये़सुरे़ यहुदि चुम्‍लुङ्‌हिम्‍हाॽओ निसाम् हुॽरुसिर निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़ कुयाःम्‍बेओ सुनाइङ् से़ःसु, हे़क्‍क्‍याङ् के़रे़क् परिक्‍ले़न् तुक्‍मा यॽमालाम् के़दुक्‍पाहाॽ वेःन्‍दुसिर गालिल थुम्‍मो खाराक् ताक्‍कन्‍दे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ये़सुरे़ कुयाःम्‍बेओ इङ्‌घङ्‌ङिन् सिरिया लाजेॽ खाराक् से़ःरे़, हे़क्‍क्‍याङ् यरिक् परिक्‍ले़न् तुक्‍माल्‍ले़ तरुसिबा मनाहाॽ, के़दुक्‍पाहाॽ, फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुसिबाहाॽ, हे़क्‍क्‍याङ् थप्‍मा के़मःबाहाॽ नु के़दुक्‍पा के़यॽबाहाॽ खुने़ॽओ मे़दारुसिआङ् खे़ङ्‌हाॽ के़रे़क् नुसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","हे़क्‍क्‍याङ् गालिल थुम्, थिबोःङ् पाङ्‌जुम्‍मिल्‍ले़न्‌थुम्, यरुसले़म, यहुदिया नु यर्दन यङ्‌घङ् नाधाःम्‍बिबा थुम्‍मोलाम् के़दाःबा यरिक् मनाहाॽरे़ खुने़ॽ मे़दिम्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","आल्‍ल ये़सुरे़ यरिक् मनाहाॽ निःसुसिआङ् कोःक्‍माओ थाःङ् पेआङ् युङ्‌सिङ्, हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽआङ् खे़त्‍थो मे़बेआङ् कुघिरि मे़युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","हे़क्‍क्‍याङ् खुने़ॽ अक्‍खेलॽरिक् खे़ङ्‌हाॽ हुॽमा हेःक्‍तुसि– ");
INSERT INTO lifNT2_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“के़रे़क् पाःन्‍नो निङ्‌वाॽफुमाङ्‌ङिन् चाहाबा के़जोःक्‍पाहाॽ मुॽइसाबासिरो, थेआङ्‌भे़ल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिन् खे़ङ्‌हाॽरे़न्‍नेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","मेरिङ् के़धक्‍पाहाॽ मुॽइसाबासिरो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ हाङ्‌हाङ् मे़त्‍छिङ्‌मान् मे़घोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","चुङ्‌जिगे़न् नःम्‍नःम्‍बा मनाहाॽ मुॽइसाबासिरो, थेआङ्‌भे़ल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मान् खे़ङ्‌हाॽरे़न्‍नेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","हे़क्‍क्‍याङ् साम्‌योनिबा याःम्‍बक् चोःक्‍माओ स्‍याङ्‌मे़न्‍दाङ् के़बप्‍पाहाॽ मुॽइसाबासिरो, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिङ्‌वाॽ हे़क्‍के चोःक्‍मा खे़ङ्‌हाॽ फाॽरुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","वेॽ मनाहाॽ लुङ्‌माॽ के़दुक्‍पाहाॽ मुॽइसाबासिरो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ लुङ्‌माॽ मे़दुक्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","सिक्‍लुङ्‌मो सेसे के़वाॽबाहाॽ मुॽइसाबासिरो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ निङ्‌वाॽफुमाङ्‌ङिन् मे़निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","नादङ् के़जोःक्‍पाहाॽ मुॽइसाबासिरो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽग निङ्‌वाॽफुसाः मे़बोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","साम्‌योनिबा याःम्‍बक् मे़जोगुल्‍ले़ मनाहाॽरे़ तुक्‍खे मे़जाःत्तुसिबाहाॽ मुॽइसाबासिरो, थेआङ्‌भे़ल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग खे़ङ्‌हाॽरे़न्‍नेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","इङ्‌गाॽ चोगुङ्‌ङिल्‍ले़ मनाहाॽरे़ खिनिॽ किनाःन्‍दि के़म्‍बिरिॽ, तुक्‍खे के़म्‍जाःत्तिआङ् खिनिॽ तक्‍ले़ङ्‌वाओ फोत्‍याबा फे़न् पाःन्‍हाॽ मे़बाःत्तुल्‍ले़ मुॽइसाबा के़बोःक्‍खिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","खे़न् ये़म्‍मो पसःत् सःत्ते़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌ङो खिनिॽ थुम्‍घोःन् यम्‍बा चोःक्‍लो॥ उन्‍छेःन्‍स्‍मा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽआङ् मनाहाॽरे़ बा हे़क्‍केए मे़मे़त्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","खिनिॽग इक्‍सादिङ् खाम्‍बेःक्‍माओबा युम्‍निङ्‌लो, कर युम्‍मिल्‍ले़ कुलिम्‍मे़न् माःबेःक्‍ने़ फाॽग्र याम्‍मो के़लिम्‍बा चोःक्‍मा सुक्‍मे़दे़त्‍ने़न्‍लो॥ खे़ल्‍ले़ कुयाःम्‍बक् थेआङ् होःप्‍लो, कर खे़ङ्‌ग लाप्‍फुमा पोःङ्‌ङाङ् मनाहाॽरे़ मे़दोॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","खिनिॽग इक्‍सादिङ् खाम्‍बेःक्‍मोबा ओःत्तिनिङ्‌लो॥ कोःक्‍माओबा ये़क्‌यक्‍किन् थेःल्‍ले़आङ् इःप्‍मा मे़सुक्‍तुन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","आत्तिल्‍ले़आङ् सेमिःन् हाःन्‍दुआङ् नइमाल्‍ले़ मे़सुःप्‍तुन्, कर हिम् सिगाङ्‌बा के़रे़क् मनाहाॽ खानिःमा मे़सुक्‍ल फाॽआङ् थो सेमि युङ्‌दे़न्‍नो युक्‍खुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","हे़क्‍केलॽरिक् सेमिःन् ओःप्‍पा हे़क्‍केए खिनिॽ के़जोगुम्‍बा सुयाःम्‍बक्‍हाॽ मनाहाॽ ओसेःन्‍धाक्‍ते़म्‍सिम्‍मे़ॽओ, हे़क्‍क्‍याङ् साङ्‌ग्राम्‍पेदाङ्‌बा खिनिॽ निङ्‌वाॽफुपाःल्‍ले़ कुनारा मे़भोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","इङ्‌गाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ मोसाःन् पिरुबा साम्‌योथिम्‍मिन् नु माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ मे़बाःत्तुबा पाःन्‍निन् कुसुम् मे़न्‍दम्‍नाबा चोःक्‍से़ त्‍याङ्‌बा फाॽआङ् मे़इःत्ते़म्‍मिन्‍ने़ॽओ॥ इङ्‌गाॽग कुसुम्‌मे़न्‍दम्‍नाबा चोःक्‍से़ मे़ःन्, कर खे़ङ्‌हाॽ कुलिङ्‌धो के़त्‍छे़ने़ त्‍याङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","से़क्‍खाए इङ्‌गाॽ मे़त्‍निङ्, इक्‍सादिङ् खाम्‍बेःक्‍मान् नु ताङ्‌साक्‍पे़न्‌माःमा पेःक्‍मानुःल्‍ले़ तगि साम्‌योथिम्‍मो के़बप्‍पा के़रे़क् पाःन्‍निन् मे़ङ्‌गे़त्ते थारिक् खे़प्‍मोबा के़रे़क्‍नुःल्‍ले़ चुक्‍सा पाःन्‍धिक्‍काङ् मे़माःने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","हाःत्‍ले़ कन् इङ्‌जाःङ्‌हाॽओबा चुक्‍सा पाःन्‍धिक् फेःन्‍दुआङ् वेहाॽ बा हे़क्‍के चोःक्‍मा हुॽरुसिॽ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो खे़न् चुक्‍सा पोःङ्‌लो, कर हाःत्‍ले़ कन् इङ्‌जाःङ्‌हाॽ इःत्तु-नाःत्तुआङ् वेॽहाॽ हे़क्‍के चोःक्‍मा हुॽरुसिॽ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो खे़न् पयम् यम्‍बा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","कर खे़प्‍से़म्‍मे़ॽओ, फरिसिहाॽ हे़क्‍क्‍याङ्‌साम्‌योथिम्‍साम्‍बाहाॽनुःल्‍ले़आङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुइङ्‌जाःङ्‌हाॽ खिनिॽ नुःरिक्‍काङ् के़न्‍इःत्तुम्‍मिन् के़न्‍नाःत्तुम्‍मिन्‍ने़ फाॽग्र से़क्‍खासाङ् खिनिॽ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो के़न्‍लासिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","आल्‍ल, “उन्‍छेःन् मोसारे़ कुसाम्‌यो इङ्‌जाःङ्‌ङिल्‍ले़ अक्‍खे पाःत्तुबान् खिनिॽ के़घे़प्‍सुम्‍माङ् के़वयिॽ, ‘मना मे़से़रे़न्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ मना के़से़प्‍पाल्‍ले़ खुम्‍दिङ् खोःसुॽरो,’ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","कर इङ्‌गाॽ मे़त्‍निङ्, हाःत् कुन्‍साॽइन्‍नु कुयाःक् ले़ॽ, खे़ल्‍ले़ खुम्‍दिङ् खोःसुॽरो॥ याम्‍मो हाःत्‍ले़ कुन्‍साॽइन् ‘अदङ्’ मे़त्तुॽ, खे़ङ्‌ग के़रे़क्‍नुःल्‍ले़ यम्‍बा यहुदि खासे़न्‍लोःम्‍बाहाॽरे़ खुनिॽ तगि मे़ये़प्‍सुॽ, कर हाःत्‍ले़ कुन्‍साॽइन् साक्‍मुरा मे़त्तुॽ, खे़ङ्‌ग खे़मायङ्‌सङ्‌ङोबा मिओ पेःक्‍मा सुक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","हे़क्‍केःल्‍ले़ खे़ने़ॽ माङ्‌हिम्‍मोबा ले़त्तिङ्‌तोःम्‍मादे़न्‍नो ले़त्तिङ्‌ङिन् तोःम्‍मानुःल्‍ले़ तगि खे़ने़ॽनु के़न्‍देःङ्‌बाल्‍ले़ कुनिङ्‌वाॽ तुगे़आङ् वाॽबा के़निङ्‌वाॽ सुम्‍मो ताने़ फाॽग्र ");
INSERT INTO lifNT2_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","के़ले़त्तिङ्‌ङिन् ले़त्तिङ्‌तोःम्‍मादे़न्‍निल्‍ले़ कुबेसाङ् ने़स्‍से़ थ्‍ये़ॽआङ् के़रे़क्‍नुःल्‍ले़ तगि के़न्‍देःङ्‌बाल्‍लो पेगे़ॽआङ् नादङ् चोगे़त्‍छे़ॽओ॥ हे़क्‍क्‍याङ्‌लक् त्‍ये़ॽआङ् के़ले़त्तिङ्‌ङिन् तोःन्‍दे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","आप्‍तिक् के़गुःप्‍पाल्‍ले़ खे़ने़ॽ खासे़न्‍दे़न्‍नो तेॽमानुःल्‍ले़ तगि खुने़ॽनु नादङ् चोगे़ॽओ, मे़ःन्‍ने़ फाॽग्र खे़ने़ॽ खासे़न्‍लोःम्‍बाल्‍लो के़देॽआङ् खासे़न्‍लोःम्‍बाल्‍ले़ तिलिङ्‌गाहाॽरो हुक्‍के़सुप्, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ पुङ्‌लाहिम्‍मो के़म्‍साक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","इङ्‌गाॽ से़क्‍खाए मे़त्‍ने़ॽ, खे़प्‍मो साम्‍बाःन्‌याङ् के़रे़क् मे़न्‍हुङ्‌ङे थारिक् खे़प्‍मोए के़याक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","आल्‍ल, “खिनिॽ मोसारे़ कुसाम्‌यो इङ्‌जाःङ्‌ङिल्‍ले़ अक्‍खे पाःत्तुबा के़घे़प्‍सुम्‍माङ् के़वयि, ‘खे़ने़ॽ चाराम्‍मा याःम्‍बक् मे़जोगे़न्‍ने़ॽओ’ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","कर इङ्‌गाॽ मे़त्‍निङ् आत्तिल्‍ले़ फे़न् निङ्‌वाॽ इःत्तुर मे़न्‍छुमाॽइन् ओमे़त्तुॽ, खे़ल्‍ले़ग तगिए खे़न् मे़न्‍छुमाॽइन्‍नु कुनिङ्‌वाॽबो चाराम्‍मा याःम्‍बक् चोगुदेःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","खे़ने़ॽ चुप्‍साङ् के़मिक्‍किल्‍ले़ लायो चोःक्‍मा के़बाङ्‌ने़ फाॽग्र लःत्ते़ॽआङ् लाप्‍फुःसे़ॽओ॥ के़रे़क् नासिङ्‌गे़न् थक्‍किन् खे़मायङ्‌सङ्‌ङो लाप्‍फुमानुःल्‍ले़ मिक्‍थिक् मे़ःन्‍ने वाॽमाए नुःबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","हे़क्‍क्‍याङ् चुप्‍साङ् हुक्‍किल्‍ले़ लायो चोःक्‍मा के़बाङ्‌ने़ फाॽग्र खे़न्‍नाङ् खक्‍ते़ॽआङ् लाप्‍फुःसे़ॽओ॥ के़रे़क् नासिङ्‌गे़न् थक्‍किन् खे़मायङ्‌सङ्‌ङो लाप्‍फुमानुःल्‍ले़ हुक्‍थिक् मे़ःन्‍ने वाॽमाए नुःबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“याम्‍मो मोसारे़ कुसाम्‌यो इङ्‌जाःङ्‌ङिल्‍ले़ अक्‍खे पाःत्तुआङ् वाॽ, ‘आत्तिल्‍ले़ मेलिङ्‌गे़न् कुमेःत्तिन् नाॽरु, खे़ल्‍ले़ नाॽने़बारो फाॽआङ् साप्‍ला साप्‍मा पिमा पोःङ्‌॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","कर इङ्‌गाॽ खिनिॽ मे़त्‍निङ्, हाःत्‍ले़ वेॽहाॽनु चाराम्‍मा याःम्‍बक् मे़न्‍जोःक्‍के के़वाॽमा मेलिङ्‌गे़न् कुमेःत्तिन् नाॽरुॽ खे़ल्‍ले़ खे़न् कुमेःत्तिन् चाराम्‍मा याःम्‍बक् के़जोःक्‍मा चोगुॽरो॥ हे़क्‍क्‍याङ् आत्तिल्‍ले़ खे़न् मे़न्‍छुमाॽइन्‍नु मेःक्‍खिम् चोगुॽ खे़ल्‍ले़आङ् चाराम्‍मा याःम्‍बक् चोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“याम्‍मो खिनिॽ मोसारे़ कुसाम्‌यो इङ्‌जाःङ्‌ङिल्‍ले़ अक्‍खे पाःत्तुबा के़घे़प्‍सुम्‍माङ् के़वयिॽ, ‘खिनिॽ के़जोगुम्‍बा माङ्‌हे़क्‍किन्‌मे़भेःन्‍दे़म्‍मे़न्‍ने़ॽ, कर यहवे दाङ्‌बान्‍नु के़जोगुम्‍बा माङ्‌हे़क्‍किन्‌के़गे़त्तुम्‍लए पोःङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","कर इङ्‌गाॽ खिनिॽ मे़त्‍निङ्, आप्‍फाल्‍ले़आङ् माङ्‌मे़हे़क्‍कासिम्‍मे़न्‍ने़ॽ॥ हे़क्‍केलॽरिक् साङ्‌ग्राम्‍पेदाङ्‌ङिल्‍ले़ कुमिङ्‌ङोआङ् मे़ःन्, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌ग निङ्‌वाॽफुमाङ् युक्‍नारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","हे़क्‍क्‍याङ् इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुमिङ्‌ङोआङ् माङ्‌मे़हे़क्‍कासिम्‍मे़न्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌ग खुने़ॽ कुलाङ् तोॽभेःत्‍लो॥ हे़क्‍केलॽरिक्‍के यरुसले़म्‍मिल्‍ले़ कुमिङ्‌ङोआङ् माङ्‌मे़हे़क्‍कासिम्‍मे़न्‍ने़ॽ, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌ग पयम् यम्‍बा हाङ्‌ङिल्‍ले़ कुये़क्‌यक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","हे़क्‍केलॽरिक्‍के खिनिॽ थे़गेःक्‍पाल्‍ले़न् माङ्‌मे़हे़क्‍कासिम्‍मे़न्‍ने़ॽ, थेआङ्‌भे़ल्‍ले़ खिनिॽ थे़गेःक्‍इधिक्‍काङ् फःगे़लॽबा इग्र माक्‍के़लॽबा चोःक्‍मा के़न्‍छुक्‍तुम्‍मिल्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","खिनिॽ पाःन्‍निङ्‌ग ‘ओ’ ने़ फाॽग्र ‘ओ’ पाःत्ते़म्‍मे़ॽ, ‘मे़ःन्’ ने़ फाॽग्र ‘मे़ःन्’ पाःत्ते़म्‍मे़ॽ॥ खे़न्‍नाङ्‌धोबाङ्‌ग माफे़न्‍साम्‍लाम् के़दाःबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“मोसारे़ कुसाम्‌यो इङ्‌जाःङ्‌ङिल्‍ले़ ‘मिक्‍किल्‍ले़ कुले़क्‌वा मिक्, हे़क्‍क्‍याङ् हाबोॽबाल्‍ले़ कुले़क्‌वा हाबोॽबा’ लॽरिक् पाःत्तुबान् के़घे़प्‍सुम्‍माङ् के़वयिॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","कर इङ्‌गाॽ खिनिॽ मे़त्‍निङ्, मनाहाॽरे़ ताप्‍फे़ःल्‍लिक् के़म्‍मे़त्तिल्‍ले़ खे़ङ्‌हाॽ ताप्‍फे़ःल्‍लिक् मे़मे़त्ते़म्‍सिम्‍मे़न्‍ने़ॽ॥ आत्तिल्‍ले़ चुप्‍साङ् ले़प्‍माङ्‌बा के़ने़दे़ङ्‌बान् के़ले़ङ् के़बिॽ, खे़न् वेॽस्‍मान्‍नाङ् तोःन्‍दे़ पिरे़ॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","हे़क्‍क्‍याङ् आत्तिल्‍ले़ के़जाङ्‌मा तेःत्तिन् नाप्‍मारे़ लागि खासे़न्‍दे़न्‍नो के़देॽ, खे़न् के़घाम्‍मा के़लोमाहाॽआङ् पिरे़देःसे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","थक्‍सुबाल्‍ले़ खे़ने़ॽ के़न्‍दे़न्‍ने़न्‍छाङ् किलोमितर थिक् थारिक् कुगक्‍किन् कुःप्‍मा तेॽमा के़गोःत्‍ने़ फाॽग्र खे़न्‍नु किलोमितर ने़त्‍छि थारिक् पेगे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","के़नाःक्‍पाहाॽ खे़ने़ॽ पिरे़से़ॽ, आत्तिल्‍ले़ थे़त्‍ला के़नाःक् खे़न् पिरे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“मोसारे़ कुसाम्‌यो इङ्‌जाःङ्‌ङिल्‍ले़ के़बाङ्‌भेॽसाबाहाॽ लुङ्‌माॽ तुक्‍ते़से़ॽआङ् के़निङ्‌मिहाॽ चिःत्ते़से़ॽ लॽरिक् पाःत्तुबा के़घे़प्‍सुम्‍माङ् के़वयिॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","कर इङ्‌गाॽ खिनिॽ मे़त्‍निङ्, निङ्‌मिहाॽ लुङ्‌माॽ तुक्‍ते़म्‍सिम्‍मे़ॽआङ् खिनिॽ ताप्‍फे़ःल्‍लिक्‌के़मे़प्‍पाहाॽ तुवा चोगे़म् पिरे़म्‍सिम्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","हे़क्‍केलॽरिक् साङ्‌ग्राम्‍पेदाङ्‌ङोबा खिनिॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुस्‍साः के़बोःक्‍खिॽरो॥ थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ग नुःबा नु ताप्‍फे़ःम्‍बा सम्‍दाङ् नाम्से़ःक् पाङ्‌घुआङ् साम्‌योनिबाहाॽ नु लायोबाहाॽओ पाङ्‌गे़न्‍दिङ् वाहिःत्‌थाःमा पाङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","खिनिॽ लुङ्‌माॽ के़दुक्‍पाहाॽरक् लुङ्‌माॽ के़दुक्‍तुम्‍सिम्‍ने़ फाॽग्र खिनिॽ थे हाङ्‌से़म्‍मिन् के़घोःसुम्‍माङ्‌बे? हे़क्‍तङ्‌बा याःम्‍बक्‍किङ्‌ग एःङ्‌याङ् के़भोःङ्‌बाहाॽरे़आङ् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","फुॽनुसाॽहाॽनुरक् खिनिॽ सेवा के़मःइने़ फाॽग्र वेॽहाॽनुःल्‍ले़ थे यम्‍बा याःम्‍बक् के़जोगुम्‍माङ्बे? खे़ङ्‌ग निङ्‌वाॽफुमाङ्‌ङिन् कुसिङ् मे़न्‍निःप्‍मनाबाहाॽरे़आङ् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽ साङ्‌ग्राम्‍पेदाङ्‌ङोबा पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिन् के़रे़क् पाःन्‍नो कुलिङ्‌धो के़गे़प्‍पा चोःक्‍पा कुइसिःक् खिनिॽआङ् हे़क्‍तङ्‌बा पोःङ्‌माए पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ये़सुरे़ याम्‍मो मे़त्तुसि, “सिङ्‌सिङ् ये़क्‌ये़क् लॽरे़म्‍मे़ॽओ, खिनिॽ के़जोगुम्‍बा साम्‌योनिबा याःम्‍बक्‍हाॽ मनाहाॽरे़ मे़निःसुआङ् खिनिॽ नारा मे़भोःसुर फाॽआङ् मना तगि मे़जोगे़म्‍मिन्‍ने़ॽओ॥ हे़क्‍के के़जोगुम्‍ने़ फाॽग्र साङ्‌ग्राम्‍पेदाङ्‌ङोबा पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌लाम् थेआङ् के़ङ्‌घोःसुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","हे़क्‍केलॽरिक् मे़ङ्‌गप्‍मनाबाहाॽ कुजा के़बिरुसिल्‍ले़ वेॽहाॽरे़ मे़घे़प्‍सुर मे़निःसुर फाॽआङ् मुक्‍ला मे़मुक्‍खे़न्‍ने़ॽओ॥ कुनिङ्‌वाॽ के़जिःप्‍पाहाॽरे़ यहुदि चुम्‍लुङ्‌हिम्‍मो नु लाम्‍लाम्‍मो मनाहाॽरे़ मे़निःसुआङ् खुनिॽ नारा मे़भोःसुर फाॽआङ् हे़क्‍के मे़जोगुॽ॥ इङ्‌गाॽ से़क्‍खाए मे़त्‍ने़ॽ, खे़ङ्‌हाॽरे़ खुनिॽ हाङ्‌से़म्‍मिङ्‌ग तगिसा मे़घोःसु मे़सुरुआङ् मे़वाॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","कर खे़ने़ॽ मे़ङ्‌गप्‍मनाबाहाॽ के़बिरुसिल्‍ले़ वेॽहाॽरे़ मे़न्‍निए पिरे़से़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","हे़क्‍केलॽरिक् के़बिरुसिबा पाःन्‍निन् स्‍वाःत्ताङ् पोःङ्‌लरो॥ हे़क्‍क्‍याङ्‌लक् स्‍वाःत्ताङ् के़जोगुबा पाःन् के़निःबा पानुदिङ् के़म्‍बारे़ हाङ्‌से़म् के़बिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“हे़क्‍क्‍याङ् खिनिॽ तुवा के़जोगुम्‍मिल्‍ले़ कुनिङ्‌वाॽ के़जिःप्‍पाहाॽ कुइसिःक् मे़जोगे़म्‍मिन्‍ने़ॽओ॥ खे़ङ्‌हाॽरे़ग मनाहाॽरे़ मे़निःसुर फाॽआङ् यहुदि चुम्‍लुङ्‌हिम्‍मो नु लाम्‍लाम्‍मो ये़प्‍माआङ् तुवा चोःक्‍मा खुनिॽ सिराॽ थाङ्‌लो॥ इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खे़ङ्‌हाॽरे़ खुनिॽ याःम्‍बक्‍किल्‍ले़न् हाङ्‌से़म्‍मिन् तगिए मे़घोःसु मे़सुरुआङ् मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","कर खे़ने़ॽ तुवा के़जोगुल्‍ले़ के़हिम्‍लक्‍सिङ्‌सिगाङ् लाःसे़ॽआङ् लाम्‍धेःप्‍पान्‌सुबे़ॽ, हे़क्‍क्‍याङ् निःमे़न्‍दे़प्‍मनाबा पानुदिङ् के़म्‍बानु एःक् तुवा चोगे़ॽओ॥ हे़क्‍क्‍याङ् स्‍वाःत्ताङ् चोःक्‍मनाबा याःम्‍बक् के़निःबा पानुदिङ् के़म्‍बारे़ हाङ्‌से़म् के़बिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","हे़क्‍क्‍याङ् तुवा के़जोगिल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिन् कुसिङ् मे़न्‍निःप्‍मनाबाहाॽ हे़क्‍के मनाहाॽरे़ मे़घे़प्‍सुर मुनुनु मे़लॽरे़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ग यरिक् मे़बाःत्तिल्‍ले़रक् माङ्‌ङिल्‍ले़ खुनिॽ तुवाःन् खे़प्‍सुॽ फाॽआङ् मे़इःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","कर खिनिॽ खे़ङ्‌हाॽ हे़क्‍के मे़जोगे़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ नाःक्‍मानुःल्‍ले़ तगिए साङ्‌ग्राम्‍बा पानुदिङ् खिनिॽ पाःल्‍ले़ के़ङ्‌गत्तुम्‍मिन्‍बान् निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","खे़ल्‍ले़ चोगुल्‍ले़ अक्‍खेलॽरिक् तुवा चोगे़म्‍मे़ॽओ– ‘साङ्‌ग्राम्‍पेदाङ्‌ङो के़वाॽबा आनिगे़ पानुदिङ् पाए, मनाहाॽरे़ के़मिङ्‌ङिन् सेसे मे़इःत्तुर मिङ्‌सो इङ्‌धाःङ् के़म्‍बिररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","के़हाङ्‌जुम्‍मिन् ताररो, हे़क्‍क्‍याङ् साङ्‌ग्राम्‍पेदाङ्‌ङो हे़क्‍के इक्‍सादिङ् खाम्‍बेःक्‍मोआङ् के़निङ्‌वाॽ कुइसिःक्‍के मे़जोगुररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","हे़क्‍क्‍याङ् थिक्‌याःन्‍धक्‍पा कुजाःन् आबिरे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","आनिगे़ तक्‍ले़ङ्‌वाओ लायो के़जोःक्‍पाहाॽ ले़प्‍मि पिरुम्‍सिम्‍बे़बा हे़क्‍केए आनिगे़ चोगुम्‍बे़बा लायोःन् ले़प्‍मि आबिरे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","हङ्‌साॽमो आन्‍धाःसे़न्‍ने़ॽओ, कर माफे़न्‍साम्‍लाम् आसे़ःप्‍ते़ॽओ॥ ((थेआङ्‌भे़ल्‍ले़ हाङ्‌जुम्, मुक्‍साम् नु मिमिदिङ्‌ङिन् सदादिङ् खे़ने़ॽइन्‍नेरो॥))’ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","थेआङ्‌भे़ल्‍ले़ खिनिॽ तक्‍ले़ङ्‌वाओ लायो के़जोःक्‍पाहाॽ ले़प्‍मि के़बिरुम्‍सिम्‍ने़ फाॽग्र साङ्‌ग्राम्‍पेदाङ्‌ङो के़वाॽबा खिनिॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़आङ् ले़प्‍मि के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","कर खिनिॽ तक्‍ले़ङ्‌वाओ लायो के़जोःक्‍पाहाॽ ले़प्‍मि के़म्‍बिरुम्‍सिम्‍मिन्‍ने़ फाॽग्र खिनिॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़आङ् खिनिॽ लायोःन् ले़प्‍मि के़म्‍बिरिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“हे़क्‍क्‍याङ् खिनिॽ चाःने़त् के़युङ्‌ङिल्‍ले़ निङ्‌वाॽ के़जिःप्‍पाहाॽ कुइसिःक् खिनिॽ ना मे़माक्‍ते़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ चाःने़त् मे़युङ्‌ङिल्‍ले़ वेॽ मनाहाॽरे़ निङ्‌वाॽ मे़घोःसुर फाॽआङ् खुनिॽ नाराःन् मे़गिःन्‍दुर मे़युङ्‌लो॥ इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खे़ङ्‌हाॽरे़ग खुनिॽ हाङ्‌से़म्‍मिन् के़रे़क् मे़घोःसु मे़सुरुआङ् मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","कर खे़ने़ॽ चाःने़त् के़युङ्‌ङिल्‍ले़ खे़ने़ॽ के़धे़गेःक्‍पो निःङ्‌गेॽ हुःत्ते़ॽआङ् के़नाराःन् वाहप्‍ते़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","हे़क्‍केलॽरिक् खे़ने़ॽ चाःने़त् के़युङ्‌बान् वेॽ मनाहाॽरे़ निङ्‌वाॽ मे़ङ्‌घोःसुन्‍लरो, कर निःमे़न्‍दे़प्‍मनाबा पानुदिङ् के़म्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़रक् निःसुररो॥ हे़क्‍के के़जोगुल्‍ले़ स्‍वाःत्ताङ् चोःक्‍मनाबा के़निःबा पानुदिङ् के़म्‍बारे़ हाङ्‌से़म् के़बिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“इक्‍सादिङ् खाम्‍बेःक्‍मो याङ्‌साकुन्‍धे मे़लुप्‍से़न्‍ने़ॽओ॥ खे़प्‍मोग थक्‍पाहाॽरे़ मे़जःॽ, हिङ्‌धोःक्‍किल्‍ले़ यःन्‍दुॽ, हे़क्‍क्‍याङ् खुःन्‍द्रिक्‍पाहाॽरे़ मे़घुःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","कर साङ्‌ग्राम्‍पेदाङ्‌ङो याङ्‌साकुन्‍धे लुप्‍से़म्‍मे़ॽओ॥ खे़प्‍मोग थक्‍पाहाॽरे़ मे़न्‍जने़न्, हिङ्‌धोःक्‍किल्‍ले़आङ् मे़यःत्‍छुन्, हे़क्‍क्‍याङ् खुःन्‍द्रिक्‍पाहाॽरे़आङ् मे़न्‍घुःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","थेआङ्‌भे़ल्‍ले़ आत्तो खिनिॽ याङ्‌साकुन्‍धेःन् वाॽ, खे़प्‍मोए खिनिॽ निङ्‌वाॽइन्‍नाङ्‌पेःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","मिक्‍किङ्‌ग नासिङ्‌गे़न् थक्‍कोबा सेमिरो, खे़ल्‍ले़ चोगुल्‍ले़ के़मिक्‍किन् नुॽने़ फाॽग्र, के़रे़क् नासिङ्‌गे़न् के़धक्‍किन् ओःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","कर खे़ने़ॽ के़मिक्‍किन् फे़न्‍ने़ फाॽग्र के़रे़क् नासिङ्‌गे़न् के़धक्‍किन् खादाम्‍मो वाॽरो॥ खे़ल्‍ले़ चोगुल्‍ले़ खे़ने़ॽओबा से़न्‍दाङ्‌गे़न् ओःत्तिःन्‍ने खादाम्‍ने़ फाॽग्र खे़न् खादाम्‍मान् आक्‍खे़न् साॽरिक् पोःङ्‌बिला॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","आत्तिल्‍ले़आङ् ने़प्‍फु दाङ्‌बाहाॽ सेवा चोःक्‍मासि मे़सुक्‍तुन्‍सिन्‍लो॥ खे़ल्‍ले़ थिक्‍किन् नुःरिक् मे़त्तुॽआङ् वेॽस्‍मान् चिःत्तुॽरो, मे़ःङ्‌ग्र थिक्‍किन् इङ्‌धाःङ् पिरुआङ् वेॽस्‍मान् इङ्‌धाःङ् मे़बिरुन्‍लो॥ खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिन् नु याङ्‌साकुन्‍धेःन् सोसोरिक् सेवा चोःक्‍मा के़न्‍छुक्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“खे़ल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽ खिनिॽ मे़त्‍निङ्, कन् ने़त्तिगे़न् हिङ्‌मन्‍नो थेःन् चामा थुङ्‌माबे फाॽआङ् निङ्‌वाॽ इःत्‍छिङ्‌मो मे़ध्‍ये़म्‍मिन्‍ने़ॽओ, हे़क्‍केलॽरिक्‍के कन् नासिङ्‌गे़न् थक्‍कोआङ् थेःन् चाङ्‌मा वाःप्‍माबे फाॽआङ् निङ्‌वाॽ इःत्‍छिङ्‌मो मे़ध्‍ये़म्‍मिन्‍ने़ॽओ॥ ने़त्तिगे़न् हिङ्‌मन्‍निन् चामा थुङ्‌मानुःल्‍ले़ हे़क्‍क्‍याङ् नासिङ्‌गे़न् थक्‍किन् चाङ्‌मा वाःप्‍मानुःल्‍ले़ नुःबा मे़जोःक्‍ने़न्बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","पुसाहाॽ ओमे़त्ते़म्‍सिम्‍मे़ॽ, खे़ङ्‌हाॽरे़ चा मे़न्‍देःसुन् मे़न्‍छुप्‍सुन् हे़क्‍क्‍याङ् याङ्‌मे़ङ्‌घोःत्तुन्‍छाङ्‌साङ्‌ग्राम्‍पेदाङ्‌बा खिनिॽ पाःल्‍ले़ खे़ङ्‌हाॽ चामा पिरुसिरो॥ हे़क्‍केःल्‍ले़ खिनिॽ खे़ङ्‌हाॽनुःल्‍ले़आङ् इमे़ल्‍लुङ्‌बा के़न्‍जोगिम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","निङ्‌साम्‍मो के़ध्‍ये़ॽइआङ्‌खिनिॽ हिङ्‌मन्‍नो कुमुक्‍थिक् फोःमा के़न्‍छुक्‍तुम्‍मिन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","हे़क्‍केःल्‍ले़ थे़माःन्‌चाङ्‌मा वाःप्‍माबे फाॽआङ् थेआङ् निङ्‌साम्‍मो के़ध्‍ये़ॽइबाबे? ताम्‍भुङ्‌मो के़लिङ्‌बा फुङ्‌ङिन् ओमे़त्ते़म्‍मे़ॽ, खे़ङ्‌हाॽ याःम्‍बक् मे़न्‍जोःक्‍ने़न्‌खिःआङ् मे़न्‍लःन्‍ने़न्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","कर इङ्‌गाॽ मे़त्‍निङ्, सोलोमन हाङ्‌ङिन् मिङ्‌सोधाःङ्‌सोओ मुक्‍ते़आङ् वये़साङ् खे़न् यारिक्‍काङ् नुःबा तेःत् मे़जाक्‍सिङ्‌ङिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","नसाःन् के़सुःम्‍बासे, आइन् के़लिङ्‌बाआङ् ताःन्‍दिक् मिओ लाप्‍फुमा के़बोःङ्‌बा याःन् फुङ्‌हाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़न् यारिक् नुःबा चोगुसिल्‍ले़ खे़न्‍नुःल्‍ले़ नुःरिक्‍काङ् तेःत् खिनिॽ के़न्‍जाःक्‍तिम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","खे़ल्‍ले़ चोगुल्‍ले़ थेःन् चामा थुङ्‌मा बे, थेःन् चाङ्‌मा वाःप्‍माबे फाॽआङ् निङ्‌वाॽ इःत्‍छिङ्‌मो मे़ध्‍ये़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","थेआङ्‌भे़ल्‍ले़ थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽइन्‌बा खे़न् पाःन्‍हाॽओ पत्‍लो, कर साङ्‌ग्राम्‍पेदाङ्‌ङोबा खिनिॽ पानुदिङ् पाःल्‍ले़ कन् के़रे़क् पाःन्‍हाॽ चाहाबा के़जोगिॽ फाॽआङ् निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","कर के़रे़क्‍नुःल्‍ले़ तगि निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुहाङ्‌जुम् नु कुसाम्‌योनिमान् कोःत्ते़म्‍मे़ॽ हे़क्‍क्‍याङ् कन् के़रे़क् पाःन्‍हाॽ खुने़ॽ के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","खे़ल्‍ले़ चोगुल्‍ले़ ताःन्‍दिक् थे पोःङ् फाॽआङ् निङ्‌वाॽ इःत्‍छिङ्‌मो मे़ध्‍ये़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ ताःन्‍दिक्‍पा तुक्‍खेःन् ताःन्‍दिक्‍के पोःङ्, हे़क्‍क्‍याङ् आइन्‍बा तुक्‍खेःन् आइन्‍छा यरिक् पोःक्‍खे़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ये़सुरे़ याम्‍मो पाःत्तु, “मनाहाॽ पाःन् मे़धिक्‍ते़म्‍सिम्‍मे़न्‍ने़ॽ, हे़क्‍केलॽरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽआङ् पाःन् के़न्‍धिक्‍तिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","वेॽहाॽ पाःन् के़धिक्‍तुम्‍सिम्‍बा हे़क्‍केए निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽआङ् पाःन् के़धिक्‍तिॽरो॥ आक्‍खेलॽरिक् वेॽहाॽ के़मे़त्तुम्‍सिम्, बा हे़क्‍केलॽरिक्‍के निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽआङ् के़मे़त्तिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","आबाङे मिक्‍को सिङ्‌घङ्‌मे़न्‍निःमनाबाल्‍ले़ आक्‍खेलॽरिक् के़न्‍साॽरे़ कुमिक्‍कोबा साप्‍सेःक्‍किन् के़निःसुबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","आबाङे मिक्‍को सिङ्‌घङ्‌मे़न्‍निःमनाबाल्‍ले़ आक्‍खेलॽरिक् के़न्‍साॽइन् के़मिक्‍कोबा साप्‍सेःक्‍किन् लःत्तुङ्‌पिने़ फाॽआङ्‌मे़प्‍मा के़सुक्‍तुबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","कुनिङ्‌वाॽ के़जिःप्‍पाए, के़रे़क्‍नुःल्‍ले़ तगि आबाङे के़मिक्‍कोबा सिङ्‌घङ्‌ङिन् लःत्ते़देःसे़ॽओ, हे़क्‍क्‍याङ्‌लक् के़न्‍साॽरे़ कुमिक्‍कोबा साप्‍सेःक्‍किन् नुःरिक् के़निःसुआङ् लःप्‍मा के़सुक्‍तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","सेसे चिगःक्‌वाःन् ख्‍याबाहाॽ मे़बिरे़म्‍सिम्‍मिन्‍ने़ॽ, मे़ःन्‍ने़ फाॽग्र खे़ङ्‌हाॽ हिल्‍लिक्‌मे़हिसिङ् हे़क्‍क्‍याङ् के़म्‍भत्तिॽआङ् के़म्‍हाॽरिरो॥ हे़क्‍क्‍याङ् फाक्‍हाॽरे़ खुनिॽ तगि ते़क्‍सेःक्‍किन् मे़से़से़म्‍मिन्‍ने़ॽओ, खे़ङ्‌हाॽरे़ मे़दोॽरु मे़लाःक्‍तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“नाःक्‍ते़म्‍मे़ॽ, हे़क्‍क्‍याङ् खिनिॽ के़म्‍बिरिॽ॥ कोःत्ते़म्‍मे़ॽ, हे़क्‍क्‍याङ् खिनिॽ के़घोःसुम्॥ लाम्‍धेःप्‍पो पेगे़म्‍मे़ॽआङ् खक्‌खक्‌मे़त्ते़म्‍मे़ॽ हे़क्‍क्‍याङ् खिनिॽ लागि हन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","थेआङ्‌भे़ल्‍ले़ के़नाःक्‍पाहाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पिरुसिॽ, के़गोःप्‍पाहाॽरे़ मे़घोःसुॽ, हे़क्‍क्‍याङ् लाम्‍धेःप्‍पो के़बेःक्‍पाआङ् खक्‌खक्‌के़मे़प्‍पाहाॽ खुने़ॽ लाम्‍धेःप्‍पे़न्‌हन्‍दु पिरुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","आत्तिल्‍ले़ कुस्‍साःन् कुजा नाःक्‍किल्‍ले़ लुङ्‌ङिन् पिरुबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","इग्र ङासाःन् नाःक्‍तुल्‍ले़ असेःक्‍पे़न्‌पिरुबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","खिनिॽ निङ्‌वाॽ के़भे़ॽबा के़जोगिसाङ् खिनिॽ साःहाॽरे़ मे़नाःक्‍तुल्‍ले़ नुःबा पाःन्‍हाॽ पिमा के़ले़स्‍सुम्‍ने़ फाॽग्र, खे़न्‍नुःल्‍ले़आङ् यरिक् खिनिॽ साङ्‌ग्राम्‍पेदाङ्‌ङोबा पानुदिङ् पाःल्‍ले़ खुने़ॽ के़नाःक्‍पाहाॽ नुःबा पाःन्‍हाॽ पिरुसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“के़रे़क् पाःन्‍नो मनाहाॽरे़ आक्‍खेलॽरिक् खिनिॽ के़म्‍मे़त्ति के़म्‍इःत्तिबा निङ्‌वाॽ के़जोगुम्, हे़क्‍केलॽरिक्‍के खिनिॽआङ् खे़ङ्‌हाॽ इःत्ते़म्‍सिम्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ कन् थिम्‍मो मोसारे़ साप्‍तुबा साम्‌योथिम् नु माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ मे़बाःत्तुबा पाःन्‍निन् के़त्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“चिभिःप्‍फिःप्‍पा लाःप्‍मादे़न्‍नोलाम् निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःसे़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ यम्‍बा लाःप्‍मादे़न् नु ताम्‍दाम्‍बा लाम्‍मिल्‍ले़ग मे़क्‍माओ के़देॽरिॽरो॥ खे़न्‍लाम्‍बा यरिक् मनाहाॽ मे़लाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","कर चुक्‍सा लाःप्‍मादे़न् नु चिभिःप्‍फिःप्‍पा लाम्‍मिल्‍ले़ग मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍नो के़देॽरिॽरो॥ खे़न् के़घोःबाहाॽग मिसाक्‍लक् मे़बोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“इङ्‌ले़क्‍पा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽनु सिङ्‌सिङ् ये़क्‌ये़क् लॽरे़म्‍मे़ॽओ, खे़ङ्‌हाॽग लाःक्‍कात्‍लाम् मे़ल्‍लुक् कुइसिःक् मे़ले़ङ्‌सिङ्‌ङाङ् खिनिॽओ मे़दारो, कर सिगाङ्‌ग खे़ङ्‌हाॽ किप्‍मा के़घुःबा पराबासिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","खे़ङ्‌हाॽरे़ मे़जोगुबा खुनिॽ याःम्‍बक्‍कोलाम् खे़ङ्‌हाॽ कुसिङ् के़निःत्तुम्‍सिम्‍लो॥ थेआङ्‌भे़ल्‍ले़ मनाहाॽरे़ तिङ्‌ग्रेःक् पोःक्‍लाओलाम् चे़ल्‍ले़क्‍सेॽ नु सिध्राःक्‍पोलाम् पःत्‍छेॽइन् मे़न्‍दुबुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","हे़क्‍केलॽरिक्‍के के़रे़क् नुःबा सिङ्‌बुङ्‌ङो नुःबाए सिङ्‌सेॽइन् थोःक्‍लो, हे़क्‍क्‍याङ् ताप्‍फे़ःम्‍बा सिङ्‌बुङ्‌ङो ताप्‍फे़ःम्‍बाए सिङ्‌सेॽइन् थोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","हे़क्‍क्‍याङ् नुःबा सिङ्‌बुङ्‌ङो ताप्‍फे़ःम्‍बा सिङ्‌सेॽइन् मे़धोःक्‍ने़न्‍लो, हे़क्‍क्‍याङ् ताप्‍फे़ःम्‍बा सिङ्‌बुङ्‌ङो नुःबा सिङ्‌सेॽइन् मे़धोःक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","हे़क्‍केलॽरिक् नुःबा सिङ्‌सेॽ मे़न्‍धोःक्‍मना के़रे़क् सिङ्‌बुङ्‌हाॽ ताङ्‌माआङ् मिओ लाप्‍फुमा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ मे़जोगुबा खुनिॽ याःम्‍बक्‍कोलाम् इङ्‌ले़क्‍पा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ कुसिङ् के़निःत्तुम्‍सिम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","आल्‍ल “‘आदाङ्‌बे, आदाङ्‌बे’, लॽरिक् याप्‍मि के़मे़प्‍पाहाॽ के़रे़क् साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो मे़न्‍लाःत्‍ने़न्‍लो, कर साङ्‌ग्राम्‍पेदाङ्‌ङो के़वाॽबा पानुदिङ् आम्‍बारे़ कुनिङ्‌वाॽ हे़क्‍के के़जोःक्‍पाहाॽरक् मे़लाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","खासे़न् ये़न्‍नो यरिक् मनाहाॽ मे़दाआङ् अक्‍खे मे़मे़त्तारो, ‘आदाङ्‌बे, आदाङ्‌बे, खे़ने़ॽ के़मिङ्‌ङो माङ्‌निङ्‌वाॽपाःन् पारिगे़रो, हे़क्‍क्‍याङ् खे़ने़ॽ के़मिङ्‌ङो फे़न्‍साम्‍हाॽ नाःत्तुम् लःत्तुम्‍सिम्‍बे़आङ् निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ चोगुम्‍बे़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","कर खे़न् ये़म्‍मो खे़ङ्‌हाॽ इङ्‌गाॽ अक्‍खे मे़त्तुङ्‌सिङ्, ‘खिनिॽग आप्‍फाल्‍ले़आङ् कुसिङ् निःत्‍निङ्‌बा होःप्‍लो॥ खिनिॽ पानुदिङ् आम्‍बारे़ कुनिङ्‌वाॽ हे़क्‍के मे़न्‍जोःक्‍के फे़न् याःम्‍बक् के़जोःक्‍पासे, कप्‍मोलाम् पेगे़म्‍मे़ॽ!’” ");
INSERT INTO lifNT2_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","आल्‍ल “खे़ल्‍ले़ चोगुल्‍ले़ पेलिगे़न् आबाःन्‍जाक् के़घे़म्‍बाआङ् हे़क्‍के के़जोःक्‍पे़ङ्‌ग पयम् यम्‍बा लुङ्‌सम्‍दाङ् हिम्‍पाङ्‌यक् के़ने़बाआङ् हिम् के़जोःक्‍पा सिक्‍कुम्‍बा मना कुइसिःक् चोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","हे़क्‍क्‍याङ् पाङ्‌गे़न्‍दिङ् वाहित् थ्‍ये़आङ्‌, यङ्‌घङ्‌ङिन् कुक्‍खे़ ये़, हे़क्‍क्‍याङ् किप्‍मा के़घुःबा सुरित् केजङ् हुःरे़आङ् खे़न् हिम्‍मिन् हिप्‍तुसाङ् मे़जोःन्‍दे़न्‍लो, थेआङ्‌भे़ल्‍ले़ खे़न् हिम्‍मिल्‍ले़न् हिम्‍पाङ्‌यक्‍किङ्‌ग पयम् यम्‍बा लुङ् सम्‍दाङ् ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","कर पेलिगे़न् आबाःन्‍जाक्‍किन् के़घे़म्‍बाआङ् हे़क्‍के मे़न्‍जोःक्‍मनाबाङ्‌ग ये़ःङ्‌घाओ हिम्‍पाङ्‌यक् के़ने़बाआङ् हिम् के़जोःक्‍पा अदङ् मना कुइसिःक् चोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","पाङ्‌गे़न्‍दिङ् वाहित् थ्‍ये़आङ्‌, यङ्‌घङ्‌ङिन् कुक्‍खे़ ये़, हे़क्‍क्‍याङ् किप्‍मा के़घुःबा सुरित् केजङ् हुःरे़आङ् खे़न् हिम्‍मिन् हिप्‍तुल्‍ले़ यरे़बेरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ये़सुरे़ कन् के़रे़क् पाःन्‍हाॽ पाःत्तु सुरु, हे़क्‍क्‍याङ् कुनिसाम् के़घे़म्‍बा यरिक् मनाहाॽरे़ खुनिॽ निङ्‌वाॽ मये़रो, ");
INSERT INTO lifNT2_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","थेआङ्‌भे़ल्‍ले़ खुने़ॽग साम्‌योथिम्‍साम्‍बाहाॽ कुइसिःक् मे़ःन्, कर युक् के़गप्‍पा कुइसिःक् हुॽरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ये़सुःन्‌कोःक्‍माओलाम् यो थ्‍ये़ःल्‍ले़ यरिक् मनाहाॽरे़ खुने़ॽ मे़दिम्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","हक्‍चघत् खे़प्‍मो लोगेॽ तुक्‍माल्‍ले़ तरुबा मनाधिक् कुदगि थुङ्‌बोहजॽ युङ्‌सिङ्‌ङाङ् खे़ल्‍ले़ अक्‍खे मे़त्तु, “आदाङ्‌बे, खे़ने़ॽ निङ्‌वाॽ के़जोगुने़ फाॽग्र इङ्‌गाॽ वेःम्‍मा के़सुक्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ये़सुरे़ कुहुक्‍किन् सन्‍छुर खे़न् मनाःन् सुःसुआङ् अक्‍खे मे़त्तु, “इङ्‌गाॽ निङ्‌वाॽ चोगुङ्‌लो॥ खे़ने़ॽ नुरे़ॽओ!” खिमो खे़न् मनाःन् लोगेॽ तुक्‍मालाम् नुःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मे़त्तु, “आत्तिन् मनाःन्‍नाङ् कन् पाःन्‍निन् मे़मे़त्ते़न्‍ने़ॽओ, कर माङ्‌हिम्‍मो पेगे़ॽआङ् नुःराङ्‌लो फाॽआङ् निङ्‌वाॽफुसाम्‍बाल्‍लो ओसेःन्‍धाक्‍सिङ्‌ङे़ॽओ, हे़क्‍क्‍याङ् मोसारे़ कुसाम्‌योथिम्‍मो साप्‍ते़बा कुइसिःक् सिदुङ्‌जभा चोगे़ॽओ॥ हे़क्‍केलॽरिक् के़रे़क् मनाहाॽरे़ खे़ने़ॽ के़नुरे़बान् मे़निःसुररो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","हे़क्‍क्‍याङ् ये़सुःन् कपर्नहुम पाङ्‌जुम्‍मो के़रे़र पत्‍छे़ल्‍ले़ रोमि थक्‍तुम्‍बाधिक् खुने़ॽओ त्‍ये़आङ् अक्‍खे मे़त्तुर कुभाॽ नाःक्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“दाङ्‌बे, इङ्‌गाॽ आसेवारोबान् हिम्‍मो पोःक्‍मा युङ्‌मा मे़न्‍छुक्‍के थारिक् तुक्‍काङ् ने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ये़सुरे़ खे़न् मे़त्तु, “इङ्‌गाॽ पेःक्‍काआङ् नुसुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","कर थक्‍तुम्‍बाल्‍ले़ नोगप् पिरु “दाङ्‌बे, खे़ने़ॽ आहिम्‍मो लाङ्‌दाःक्‍मा इङ्‌गाॽ मे़लाॽआन्‍लो॥ खे़ने़ॽ नुॽर फाॽआङ् के़बाःत्तुसाङ् आसेवारोबान् नुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽआङ् आधुङ्‌धोबा सुहाङ्‌युक्‍पाहाॽरे़ खुनिॽ युक्‍को के़वाॽबा मनाआरो, हे़क्‍क्‍याङ् इङ्‌गाॽआङ् आयुक्‍को थक्‍सुबाहाॽ मे़वाॽरो॥ इङ्‌गाॽ थक्‍सुबान् ‘पेगे़ॽ’ मे़त्तुङ्‌ङिल्‍ले़ पेःक्, वेॽस्‍मान् ‘फे़रे़ॽ’ मे़त्तुङ्‌ङिल्‍ले़ फे़न्, हे़क्‍क्‍याङ् आसेवारोबान् ‘खे़न् चोगे़ॽ’ मे़त्तुङ्‌ङिल्‍ले़ खे़ल्‍ले़ चोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ये़सुरे़ कन् खे़प्‍सुल्‍ले़ कुनिङ्‌वाॽ मये़र खुने़ॽ कुएगाङ् कुएगाङ् के़दिम्‍बाहाॽ अक्‍खे मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, अक्‍तङ्‌बा यम्‍बा नसाःन् के़गप्‍पा मनाःङ्‌ग इस्राइलोआङ् इङ्‌गाॽ मे़ङ्‌घोए वाॽआरो! ");
INSERT INTO lifNT2_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","खिनिॽ से़क्‍खाए मे़त्‍निङ्‌लो, के़रे़क् पिसाङ्‌बा लाजेॽलाम् यरिक् मनाहाॽ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो मे़दाआङ् साभाङ्‌जा चासे़ खिनिॽ थाःक्‍थे़बा अब्राहाम, इसहाक, हे़क्‍क्‍याङ् याकुबे़न्‍नु सोरिक् मे़युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","कर साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो वाॽमा फाॽआङ् मे़सेगे़बा इस्राइलिहाॽग खे़प्‍मोलाम् लाःक्‍कात् खामाक् लुम्‍बाःत्तो लाप्‍मे़भुॽरो॥ खे़प्‍मोग हाःप्‍मा नु हाबोॽ ये़ःङ्‌मान्‍लक् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् थक्‍तुम्‍बे़न् मे़त्तु, “पेगे़ॽओ, नसाःन् के़जोगुबा हे़क्‍केए पोःङ्‌लो॥” हे़क्‍क्‍याङ् खे़न् कुसेवारोबान् बा खे़न् ये़म्‍मोए नुःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","हे़क्‍क्‍याङ् ये़सुःन् पत्रुसरे़ कुहिम्‍मो त्‍ये़ःल्‍ले़ खे़प्‍मो पत्रुसरे़ कुन्‍नोःप्‍मे़न् तुङ्‌ङिल्‍ले़ तरुआङ् ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ये़सुरे़ खे़ल्‍ले़ कुहुक्‍को सुःसुल्‍ले़सा तुङ्‌ङिल्‍ले़ ले़रुरो, हे़क्‍क्‍याङ् खे़न् पोगे़आङ् तरे तोमा हेःक्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","हे़क्‍क्‍याङ् युःन्‍छिक् पोःक्‍खे़आङ् यरिक् फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुसिबा मनाहाॽ खुने़ॽओ मे़दारुसि, हे़क्‍क्‍याङ् खुने़ॽ पाःन्‍जाक्‍किल्‍ले़ खे़न् फे़न्‍साम्‍हाॽ के़रे़क् नाःत्तु लःत्तुसिआङ् के़रे़क् के़दुक्‍पाहाॽ नुसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ अक्‍खेलॽरिक् पाःत्तुबान् के़त्‍ल फाॽआङ् अक्‍खे पोःक्‍खे़बारो– “खुने़ॽ आबाङे आनिॽ तुक्‍खेहाॽ याङ्‌सिङ्‌लो, हे़क्‍क्‍याङ् आनिॽ तुक्‍मा यॽमाहाॽ कुयु तेॽरुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","आल्‍ल ये़सुरे़ यरिक् मनाहाॽ कुगब्रिङ् निःसुसिल्‍ले़ कुहुॽसाम्‍बाहाॽ वरक्‍किल्‍ले़ नाहाङ्‌दाङ् पेगे़म्‍मे़ॽ मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","खे़ङ्‌हाॽरे़ पेःक्‍मा यारिप् मे़जोगुर मे़यागे़ल्‍ले़ साम्‌योथिम्‍साम्‍बाधिक् फे़रे़आङ् मे़त्तु, “सिक्‍साम्‍बे, खे़ने़ॽ आत्ति के़बेःक्‍साङ् खे़ने़ॽनु पेःक्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ये़सुरे़ नोगप् पिरु, “किधिबाहाॽरे़ लुङ्‌घुरि मे़गत्तुॽ, पुसाहाॽरे़ हाप् मे़गत्तुॽ, कर इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़ग थे़गेःक् नाःम्‍मा ते़न्‍नाङ् मे़गत्तान्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","वेॽस्‍मा हुॽसाम्‍बाधिक्‍ले़ खुने़ॽ मे़त्तु, “आदाङ्‌बे, तगि इङ्‌गाॽ के़सिःबा आम्‍बाःन् इप्‍पुङ्‌ङो चिङ्‌से़ पेःक्‍मा पाङ्‌घाङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","कर ये़सुरे़ खे़न् मे़त्तु, “इङ्‌गाॽ तिम्‍दाङ्‌ङे़ॽओ, हे़क्‍क्‍याङ् हाराॽ याम्‍साम्‍मो के़सिःबा मनाहाॽरे़ खुनिॽ आबाङे चेहाॽ इप्‍पुङ्‌ङो मे़जिक्‍खुसिररो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","हे़क्‍क्‍याङ् ये़सुःन् पोगे़आङ् कुहुॽसाम्‍बाहाॽनु खःङ्‌बेओ लाःसे़आङ् वरक्‍किल्‍ले़ नाधाःम्‍बि मे़धासिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","हक्‍चघत् वरक्‍को किप्‍मा के़घुःबा सुरित्‌के़जजङ्‌ङिन् हुःमा हेःक्‍ते़आङ् वाभे़ल्‍ले़ङ्‌ङिल्‍ले़ खःङ्‌बेन् वे़त्‍ले़क्‌तिम्‍से़रो॥ कर ये़सुःङ्‌ग इप्‍से़आङ् ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","कुहुॽसाम्‍बाहाॽ मे़बेआङ् खुने़ॽ अक्‍खे मे़मे़त्तुर मे़भोःक्‍खु, “आदाङ्‌बे, याप्‍मि ताङ्‌से़ःप्‍ते़ॽओ! आनिगे़ग हुम्‍मा सिःमा इःत्तिगे़रो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “नसाःन् के़सुःम्‍बासे, थेआङ् अक्‍खेलॽरिक् के़गिःसिबाबे?” हे़क्‍क्‍याङ् खुने़ॽ पोगे़आङ् सुरित्‌केजङ्‌ङिन् नु वाभे़ल्‍ले़ङ्‌ङिन् फे़ःक्‍तु, हे़क्‍क्‍याङ् के़रे़क् चिजि ये़म्‌ये़म् पोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ मये़र सेःन्‍मे़दोःसिङ् “खुने़ॽग आक्‍तङ्‌बा मनाःन्बे? खुने़ॽ कुइङ्‌जाःङ्‌ङिन् वाभेल्‍ले़ङ्‌नु सुरित्‌केजङ्‌ङिल्‍ले़आङ् खे़प्‍सुङ्‌ग!” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","हे़क्‍क्‍याङ् खुने़ॽ वरक्‍किल्‍ले़ नाहाङ्‌दाङ् गदरिनि लाजेॽओ के़रे़, हे़क्‍केःल्‍ले़ खे़प्‍मो इप्‍पुङ्‌दे़न्‍लाम् फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुसिबा ने़प्‍फु मनाहाॽ कुदुम्‍से़ फे़रे़त्‍छि॥ खे़ङ्‌हाॽ कम्‍म्‍याक् साॽरिक् किप्‍मा के़घुःबा चोगे़त्‍छि आत्तिन्‍नाङ् खे़न् ते़न्‍नो पोःङ्‌मार लाङ्‌घेःक्‍मा मे़न्‍छुक्‍ते़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","खे़ङ्‌हाॽ अक्‍खेलॽरिक् अःक्‍ते़त्‍छि, “निङ्‌वाॽफुसाःए, खे़ने़ॽ आन्‍छिगे़नु थे के़गोःत्तुबाबे? खासे़न् ये़म्‍मिन्‍ने मे़न्‍दाए आन्‍छिगे़ तुक्‍खे चाःत्‍छे़ कप्‍मो के़द्‌ये़बाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","खे़प्‍मोलाम् मिसाक् नानाक् यरिक् फाक्‍हाॽ चामे़रामे़र मे़ये़बे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","खे़न् फे़न्‍साम्‍हाॽरे़ ये़सुःन् याप्‍मि लाःक्‍कात् के़लःप्‍पाने़ फाॽग्र खे़न् फाक्‍हाॽओ लाःप्‍मा आबाङ्‌घे़ॽओ लॽरिक् पेलि मे़भाक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “पेगे़म्‍मे़ॽ!” खे़ल्‍ले़ चोगुल्‍ले़ खे़न् ने़प्‍फु मनाहाॽलाम् खे़ङ्‌हाॽ मे़लःन्‍दे़ मे़बेआङ् फाक्‍हाॽओ मे़लाःसे़॥ हे़क्‍क्‍याङ् खे़न् फाक्‍हाॽ सङ्‌माङ्‌ङे सङ्‌माङ् मे़लोःक्‍ते़र याक्‍पे़ओनु मक्‍मे़ध्‍ये़आङ् वरक्‍को मे़हुमे़ मे़स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","खे़न् फाक् के़गम्‍बाहाॽ निःत्ताङ्‌बा पाङ्‌जुम्‍मो मे़बेआङ् फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुसिबा ने़प्‍फु मनाहाॽरो पोःक्‍खे़बा के़रे़क् पाःन्‍हाॽ मे़जे़क्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","हे़क्‍क्‍याङ् पाङ्‌जुम्‍मोबा यरिक् मनाहाॽ ये़सुरो मे़द्‌ये़, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ये़सुःन् आनिगे़ थुम्‍मोलाम् लःन्‍दे़ पेगे़ॽ फाॽआङ् पेलि मे़भाक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","हे़क्‍क्‍याङ् ये़सुःन् खःङ्‌बेओ लाःसे़आङ् नाहाङ्‌दाङ्‌बा आबाङे कुबाङ्भेॽओ के़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","खे़प्‍मो कुभा मनाहाॽरे़ लङ्‌ले़ःङ्‌वा मनाधिक् कुने़त्‍नाःन्‍नुए खुने़ॽओ मे़दारुरो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खे़न् लङ्‌ले़ःङ्‌वाःन् वेःप्‍मा सुक् के़लॽबा नसाःन् मे़गत्तुबा ये़सुरे़ निःसुआङ् मे़त्तु, “आस्‍साःए, हाङ्‌हाङ् लॽरे़ॽओ, खे़ने़ॽ के़लायोहाॽ ले़प्‍मि पोःक्‍खे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","हे़क्‍केःल्‍ले़ खे़प्‍मो के़वाॽबा कुभा साम्‌योथिम्‍साम्‍बाहाॽ अक्‍खे मे़मे़त्‍छिङ्, “कन् मनाःल्‍ले़ग निङ्‌वाॽफुमाङ् कुइसिःक् लायो ले़प्‍मि के़बिबा ले़ङ्‌सिङ्‌ङाङ् माङ्‌चे़ॽया पाःन्‍निन्‍ने़ पाःत्तुर पत्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽइन्‌निःसुआङ् अक्‍खे मे़त्तुसि, “थेआङ् हे़क्‍केलॽरिक् फे़न् निङ्‌वाॽ के़इःत्तुम्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","‘के़लायोहाॽ ले़प्‍मि पोःक्‍खे़’, मे़प्‍मा उसुरु चोःक्‍पि, इ ‘पोगे़ॽआङ् थासिङ्‌ङे़ॽ’ मे़प्‍मा उसुरु चोःक्‍पि? ");
INSERT INTO lifNT2_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मो लायोहाॽ ले़प्‍मि पिमा युक् कत्तुङ् लॽरिक् ओसेःन्‍धाक्‍निङ्‌लो॥” हे़क्‍केःल्‍ले़ ये़सुरे़ खे़न् लङ्‌ले़ःङ्‌वाःन् मे़त्तु, “पोगे़ॽ, के़ने़त्‍नाःन् याङ्‌सिङ्‌ङे़ॽआङ् के़हिम्‍मो थासिङ्‌ङे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","हे़क्‍क्‍याङ् खे़न् पोगे़आङ् कुहिम्‍मो थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","मनाहाॽरे़ कन् मे़निःसुआङ् साॽरिक् खुनिॽ निङ्‌वाॽ मये़रो॥ हे़क्‍क्‍याङ् मे़न्‍छाम् याप्‍मिःन् अक्‍तङ्‌बा मुक्‍साम् के़बिबा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा मे़भोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ये़सुःन् खे़प्‍मोलाम् पेर पत्‍छे़ल्‍ले़ मत्ति मे़प्‍मनाबा मनाःन् एःङ्‌याङ् फोःङ्‌मा ते़न्‍नो युङे़बा निःसुआङ् मे़त्तु, “इङ्‌गाॽ तिम्‍दाङ्‌ङे़ॽओ॥” खे़न् मुत्‍थ्रिक् पोगे़आङ् खुने़ॽनु थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","खे़न् युःन्‍छिक् ये़सुःन् नु कुहुॽसाम्‍बाहाॽ मत्तिरे़ कुहिम्‍मो चाजासे़ मे़युङ्‌सिङ्‌ङिल्‍ले़ एःङ्‌याङ् के़भोःङ्‌बा यरिक् मनाहाॽ नु वेॽ “लायोबाहाॽ” मे़द्‌ये़आङ् खे़ङ्‌हाॽनु सोरिक् चाजासे़ मे़युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","हे़क्‍केःल्‍ले़ कुभा फरिसिहाॽरे़ खे़न् मे़निःसुआङ् कुहुॽसाम्‍बाहाॽ मे़मे़त्तुसि, “थेआङ् खिनिॽ सिक्‍साम्‍बान् एःङ्‌याङ् के़भोःङ्‌बाहाॽ हे़क्‍क्‍याङ् वेॽ लायोबाहाॽनु सोरिक् चाजाबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ये़सुरे़ कन् खे़प्‍सुआङ् मे़त्तुसि, “सिदाॽसाम्‍बे़ङ्‌ग मे़न्‍दुक्‍मनाहाॽरे़ लागि मे़ःन्, कर के़दुक्‍पाहाॽरे़ लागिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","साम्‌योसाप्‍लाओ यहवे दाङ्‌बाल्‍ले़ इङ्‌गाॽग सिदुङ्‌जभा चाहाबा मे़जोःक्‍कान्, कर वेॽहाॽ लुङ्‌माॽ तुक्‍ते़म्‍सिम्‍मे़ॽ के़लॽबा निङ्‌वाॽ कत्तुङ्‌लो, लॽरिक् पाःत्तुबा कन् पाःन्‍निल्‍ले़ कुबेःन् हुॽआसिम्‍मे़ॽओ॥ इङ्‌गाॽग साम्‌योनिबाहाॽरे़ लागि मे़ःन्, कर लायोबाहाॽ लायोलाम् मे़नुःङ्‌ङाङ्‌ताङ्‌मे़से़ःप्‍ल फाॽआङ् त्‍याङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","हे़क्‍क्‍याङ् थिक्‍ले़ङ् बप्‍तिस्‍मा के़बिबा युहुन्‍नारे़ कुहुॽसाम्‍बाहाॽ मे़द्‌ये़आङ् ये़सुःन् सेःन्‍मे़दोसु, “आनिगे़ नु फरिसिहाॽ चाःने़त्तो ए़त्‍ले़ङ् युङिगे़ॽ कर थेआङ् के़हुॽसाम्‍बाहाॽ चाःने़त्तो मे़न्‌युङ्‌ने़न्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “मेःक्‍खिम्‍साबे़न् कुन्‍जुम्‍हाॽनु वाॽर थारिक् खुने़ॽ कुन्‍जुम्‍हाॽ चाःने़त्तो मे़युङ्‌ङाङ् मेरिङ् मे़धक्‍पि? कर खे़ङ्‌हाॽलाम् मेःक्‍खिम्‍साबे़न् साक्‍के़ल्‍ले़क् मे़दे़म्‍सुआङ् मे़देॽरुल्‍ले़रक्‌खे़ङ्‌हाॽ चाःने़त्तो मे़युङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","आत्तिल्‍ले़आङ् कुसङ् चिरिक्‍किल्‍ले़ कुद्रे़क्‌चाङ्‌ङिन् मे़ले़म्‍दुन्‍लो, ले़म्‍दुने़ फाॽग्र खे़न् किङ्‌ङाङ् आल्‍लसाङ् यम्‍बा थे़ःक्‍खुदेःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","आत्तिल्‍ले़आङ् कुसङ् चे़ल्‍ले़क्‍सेॽ थिःन् कुद्रे़क्‌से़होबा सुःक्‌वाओ मे़युक्‍खुन्, कर युक्‍खुने़ फाॽग्र कुसङ् चे़ल्‍ले़क्‍सेॽ थिःल्‍ले़ कुद्रे़क्‌से़होबा सुःक्‌वाःन्‌थे़ःक्‍खुदेःसुॽरो, हे़क्‍क्‍याङ् थिःन् वे़त् पेःक्‍काङ् चासोःक्‍लो॥ कर कुसङ् चे़ल्‍ले़क्‍सेॽ थिःन्‌कुसङ् से़होबा सुःक्‌वाओ याक्‍मा पोःङ्‌, हे़क्‍केःल्‍ले़ चे़ल्‍ले़क्‍सेॽ थिःन् नु से़होबा सुःक्‌वाःन्‌ने़प्‍माङ् ताङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ये़सुरे़ हे़क्‍के पाःत्तुर पत्‍छे़ल्‍ले़ सुहाङ्‌युक्‍पाधिक् कुदगि थुङ्‌बोहजॽ युङ्‌सिङ्‌ल अक्‍खे पाःत्तु, “आदाङ्‌बे, आस्‍साः चुक्‍मे़न् खारक् स्‍ये़रो, कर खे़ने़ॽ फे़रे़ॽआङ् कुसम्‍दाङ् के़हुक्‍किन् ने़स्‍से़ पिरे़ॽ, हे़क्‍क्‍याङ् खे़न् हिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ये़सुःन् पोगे़आङ् खे़न्‍नु थासिङ्, हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽआङ् खुने़ॽ कुएगाङ् मे़धासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","बा खे़न् ये़म्‍मो तङ्‌बे थिक्-ने़त्ताङ्‌धो (१२) माक्‍खिॽ वयुःमाल्‍ले़ तरुमा मे़न्‍छुमाॽधिक् ये़सुरे़ कुएगाङ् त्‍ये़आङ् कुदेःत्तिल्‍ले़ कुयाःन्‌सुःसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ कुनिङ्‌वाॽओ खुने़ॽ कुदेःत्तिल्‍ले़ कुयाःन्‍लक् सुःसुङ्‌साङ् इङ्‌गाॽ वेःत्तारो के़लॽबा इःत्तुआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ये़सुःन् हिल्‍लिक्‌हिसिङ्‌ङिल्‍ले़ खे़न् मे़न्‍छुमाॽइन् निःसुआङ् मे़त्तु, “मामुए, हाङ्‌हाङ् लॽरे़ॽओ, नसाःन् के़जोगुबाल्‍ले़ चोगुल्‍ले़ खे़ने़ॽ के़वेःत्ते़रो॥” हे़क्‍क्‍याङ् खे़न् मे़न्‍छुमाॽइन् हाबा खे़न् ये़म्‍मो वेःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","हे़क्‍क्‍याङ् ये़सुःन् खे़न् लाम्‍लोःबाल्‍ले़ कुहिम्‍मो के़रे़ल्‍ले़ खे़प्‍मो चे लुप्‍मा ये़म्‍मो मे़प्‍फ्रामा के़मुःप्‍पाहाॽ नु मेरिङ् के़धक्‍पा यरिक् मनाहाॽ निःसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “पेगे़म्‍मे़ॽओ, कन् चुक्‍मे़ङ्‌ग मे़न्‍छिःए वाॽ इप्‍से़आङ्‌लक् ने़रो”, कर खे़ङ्‌हाॽरे़ खुने़ॽ मे़एःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","खे़न् मनाहाॽ खे़प्‍मोनु मे़लःत्तुसिआङ् ये़सुःन् सिगाङ् लाःसे़ हे़क्‍क्‍याङ् खे़न् चुक्‍मे़ल्‍ले़ कुहुक्‍किन् ते़म्‍सुल्‍ले़ खे़न् चुक्‍मे़न् मुत्‍थ्रिक् पोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","कन् इङ्‌घङ्‌ङिन् खे़न् थुम्‍मो के़रे़क् पिसाङ् से़ःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ये़सुःन् खे़प्‍मोलाम् पेर पत्‍छे़ल्‍ले़ ने़प्‍फु मिक्‍फःम्‍बाहाॽरे़ खुने़ॽ कुएगाङ् कुएगाङ् तिम्‍दे़त्‍छुर अक्‍खेलॽरिक् अःक्‍ते़त्‍छि, “दाउदरे़ कुस्‍साःए, आन्‍छिगे़ लुङ्‌माॽ आदुक्‍ते़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","हे़क्‍क्‍याङ् ये़सुःन् लाःसे़बा हिम्‍मो पेसिल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “खिन्‍छिॽ मिक् निःमा के़सुक्‍सुर चोःक्‍मा सुक्‍तुङ् फाॽआङ् नसाःन् के़जोःक्‍सुबि?” चोःक्‍सुगे़ॽरो, आदाङ्‌बे फाॽआङ् नोगप् पिरे़त्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽरे़ खुन्‍छिॽ मिक्‍हाॽ सुःसु पिरुसिर मे़त्तुसि, “खिन्‍छिॽ नसाःन् के़जोगे़त्‍छुबा कुइसिःक्‍के पोःङ्‌लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","खे़ङ्‌हाॽ मिक् निःमा के़सुक्‍पा पोःक्‍खे़त्‍छि॥ ये़सुरे़ खे़ङ्‌हाॽ “कन् पाःन्‍निल्‍ले़ कुयाःम्‍बेओ आत्तिल्‍ले़आङ् निङ्‌वाॽ मे़घोःसुन्‍लरो” मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","कर खे़ङ्‌हाॽ पेसिआङ् खे़न् थुम्‍मो के़रे़क् पिसाङ् खुने़ॽ कुयाःम्‍बेओ इङ्‌घङ् से़ःसे़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ लःन्‍दे़त्‍छिर पत्‍छे़त्‍छिल्‍ले़ कुभा मनाहाॽरे़ फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबाल्‍ले़ चोगुल्‍ले़ पाःप्‍मा मे़न्‍छुक्‍मनाबा मनाधिक् ये़सुरो मे़दारु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","हे़क्‍क्‍याङ् खे़न् फे़न्‍साम्‍मिन् ये़सुरे़ नाःत्तु लःत्तु हे़क्‍क्‍याङ् खे़न् मनाःन् पाःप्‍मा हेःक्‍ते़रो॥ खे़न् मे़निःसुआङ् खे़न् मनाहाॽरे़ साॽरिक् खुनिॽ निङ्‌वाॽ मये़र अक्‍खे मे़बाःत्तु, “इस्राइल लाजेॽ खाराक् अक्‍तङ्‌बा निङ्‌वाॽ के़माबा पाःङ्‌ग आप्‍फाल्‍ले़आङ् मे़न्‍निए वयिगे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","कर फरिसिहाॽरे़ मे़बाःत्तु, “कन् मनाःल्‍ले़ग फे़न्‍साम्‍हाॽरे़ खुनिॽ हाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍लाम् फे़न्‍साम्‍हाॽ नाःत्तु लःत्तुसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ये़सुःन् यहुदि चुम्‍लुङ्‌हिम्‍हाॽओ हुॽरुसिर निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़ कुयाःम्‍बेओ सुनाइङ् से़ःसुर के़रे़क् परिक्‍ले़न् के़दुक्‍पा के़यॽबाहाॽ वेःन्‍दुसिर ये़क्‌यक् नु पाङ्‌भेॽहाॽओ लाम्‍दिःक् चोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ये़सुरे़ यरिक् मनाहाॽ निःसुसिल्‍ले़ कुलुङ्‌माॽ स्‍याःत् लॽरे़, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽग मे़ल्‍लुक्‍कम्‍बा मे़ःन्‍नेबा मे़ल्‍लुक् हे़क्‍के लाम् के़बोःप्‍पाआङ् तुक्‍खे के़जाबा कुइसिःक् मे़जोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “सुम्‍मा के़बोःङ्‌बा चाःन् यरिक् ने़ःॽ, कर चा के़सुम्‍बा याःलिक्हाॽ मे़सुःन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","हे़क्‍केःल्‍ले़ सुम्‍मा के़बोःङ्‌बा चाःल्‍ले़ कुन्‍दाङ्‌बान् यरिक् याःलिक्हाॽ चा सुम्‍से़ पाङ्‌घुसिर फाॽआङ् खिनिॽ तुवा चोगे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","हे़क्‍क्‍याङ् ये़सुरे़ थिक्-ने़त् (१२) कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् फे़न्‍साम्‍हाॽ नाःप्‍मा लःप्‍मा नु के़रे़क् परिक्‍ले़न् के़दुक्‍पा के़यॽबाहाॽ वेःम्‍मा युक् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","खे़न् थिक्-ने़त् सेःक्‌युक्‍मिबाहाॽरे़ खुनिॽ मिङ्‌ग अक्‍तङ्‌बा चोःक्– सिमोन (खुने़ॽ पत्रुसआङ् मे़मे़त्तु), आन्‍द्रियास (पत्रुसरे़ कुन्‍साॽ), याकुब (जब्‍दियारे़ कुस्‍साः), युहुन्‍ना (याकुबरे़ कुन्‍साॽ), ");
INSERT INTO lifNT2_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","फिलिप, बारथोलोमाइ, थोमा, मत्ति (एःङ्‌याङ् के़भोःङ्‌बा), याकुब (अल्‍फायसरे़ कुस्‍साः), थे़दियस हे़क्‍क्‍याङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","सिमोन (खुने़ॽ “हाङ्‌बिफ्‍युङ् के़जोःक्‍पा” मे़मे़त्तु॥ खे़न् फाॽइन् हाङ्‌बिफ्‍युङ् के़जोःक्‍पा वये़), हे़क्‍क्‍याङ् यहुदा इस्‍करियोत (खुने़ॽ ये़सुरे़ कुनसाःन् के़ले़ङ्‌बा पोःक्‍खे़रो)॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ये़सुरे़ कन् थिक्-ने़त् सेःक्‌युक्‍मिबाहाॽ अक्‍खे मे़त्तुसिर पाङ्‌घुसिरो– “थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरो मे़बेगे़म्‍मिन्‍ने़ॽओ, हे़क्‍क्‍याङ् सामरिहाॽरे़ खुनिॽ पाङ्‌जुम्‍हाॽओ मे़बेगे़म्‍मिन्‍ने़ॽओ, ");
INSERT INTO lifNT2_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","कर लाम् के़बोःप्‍पा मे़ल्‍लुक् हे़क्‍तङ्‌बा इस्राइलबा मनाहाॽरो पेगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","खिनिॽ के़बेगिल्‍ले़ कन् सुनाइङ्‌ङिन् से़ःसे़म्‍मे़ॽओ–‘साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिन् निःत्ताङ्‌ङे वाॽ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","के़दुक्‍पाहाॽ नुसे़म्‍सिम्‍मे़ॽ, के़सिःबाहाॽ कुहिङ्‌वे़त् चोगे़म्‍सिम्‍मे़ॽ, लोगेॽ तुक्‍माल्‍ले़ याङ्‌घुसिबाहाॽ नुसे़म्‍सिम्‍मे़ॽ, फे़न्‍साम्‍हाॽ नाःत्ते़म्‍लःत्ते़म्‍सिम्‍मे़ॽ॥ आम्‍भा के़घोःसुम्, आम्‍भाए पिरे़म्‍सिम्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","याङ् मे़ःन्‍ने खिनिॽ पेगे़म्‍मे़ॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","हे़क्‍क्‍याङ् सुःक्‌वा, ले़क्‍सिङ्‌मा चाङ् नु लाङ्‌सुःप्, हे़क्‍क्‍याङ् तक्‍काःत् थेआङ् मे़याङ्‌ङासिम्‍मे़न्‍ने़ॽओ॥ थेआङ्‌भे़ल्‍ले़ याःम्‍बक् के़जोःक्‍पाल्‍ले़ खुने़ॽ चाहाबा के़जोःक्‍पा पाःन्‍हाॽ खोःमाए पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","खिनिॽ के़बेगिबा पाङ्‌जुम् पाङ्‌भेॽहाॽओ सुम्‍बोधाबा मनाःन् कोःत्ते़म्‍मे़ॽआङ् खे़प्‍मोलाम् के़न्‍लःन्‍दिन्‌के़म्‍बेगिन्‍ल थारिक् कुहिम्‍मोए याःक्‍ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","खे़न् हिम्‍मो के़लाःस्‍सिल्‍ले़ मनाहाॽनु ‘सनारुङ् के़घोःसुम्‍निरो’ लॽरिक् सेवा मये़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","खे़न् हिम्‍सयङ्‌ङिन् खिनिॽ सनारुङ् खोःमा के़लाॽबा चोःक्‍ने़ फाॽग्र खिनिॽ सनारुङ्‌ङिन् खे़प्‍मो याःक्‍लाःत्‍लरो॥ कर के़लाॽबा मे़जोःक्‍ने़न्‍ने़ फाॽग्र खिनिॽ सनारुङ्‌ङिन् खिनिॽओए नुःङ्‌लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","आत्तिल्‍ले़ खिनिॽ लाङ्‌दाःक्‍मा के़म्‍बिरिन्‍नाङ् खिनिॽ पाःन्‍नाङ् मे़घे़प्‍सुन्, खे़न् हिम् इग्र पाङ्‌जुम्‍मोलाम् खिनिॽ के़बेगिल्‍ले़ खिनिॽ लाङ्‌ङो के़घिप्‍पा खाम् हिःक्‍किन् बा खे़प्‍मोए थाप्‍से़म्‍ध्‍ये़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्‌लो, ताःन्‍दि खासे़न् ये़न्‍नोग खे़न् पाङ्‌जुम्‍मिल्‍ले़ कुदुक्‍खेःन्‍नुःल्‍ले़ सदोम नु गमोराबा पाङ्‌जुम्‍हाॽओ के़दाःबा तुक्‍खेःन् थम्‍मा सुक्‍के़दे़प्‍पा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“खे़प्‍से़म्‍मे़ॽओ! मे़ल्‍लुक्‍हाॽ पराबाहाॽरे़ खुनिॽ लुम्‍मो पाङ्‌मनाबा कुइसिःक् पाङ्‌निङ्‌लो॥ हे़क्‍केःल्‍ले़ खिनिॽ असेःक्‍पा हे़क्‍के चाचाःप्‍पा नु पुत्तुःक्‍के हे़क्‍के कुदोःप्‍मा पोःक्‍खे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","मनाहाॽनु सिङ्‌सिङ् ये़क्‌ये़क् लॽरे़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ खासे़न् लोःम्‍मा हिम्‍मो खिनिॽ के़म्‍देॽरिॽ, यहुदि चुम्‍लुङ्‌हिम्‍मो ते़ःम्‍भुक् के़म्‍बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","खिनिॽ याप्‍मि नसाःन् के़जोगिबाल्‍ले़ चोगुल्‍ले़ सुहाङ्‌गे़म्‍बाहाॽ नु हाङ्‌हाॽरे़ खुनिॽ तगि के़म्‍देॽरिॽ॥ खे़न् ये़म्‍मो खे़ङ्‌हाॽ नु के़रे़क् थिम्‍मे़न्‍दङ्‌सुवाङ्‌हाॽ इङ्‌गाॽ आयाःम्‍बेओ मे़प्‍मासि सुये़म् के़घोःसुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","कर खिनिॽ के़म्‍दे़म्‍सिल्‍ले़ से़ःप्‍सिङ्‌मारे़ लागि आल्‍ल थे़मा पाःप्‍मा, आक्‍खेलॽरिक् पाःप्‍माबे फाॽआङ् निङ्‌साम्‍मो मे़ध्‍ये़म्‍मिन्‍ने़ॽओ॥ खे़न् ये़म्‍मोग खिनिॽ पाःप्‍मा के़बोःङ्‌बा पाःन्‍निन् बा खे़न् ये़म्‍मोए के़घोःसुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","थेआङ्‌भे़ल्‍ले़ खिनिॽ आबाङे के़म्‍बारिन् कर खिनिॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसेसेमाङ्‌ङिन् खिनिॽलाम्‍बा पाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","फुॽनुसाॽहाॽ आबाङे फुॽनुसाॽहाॽरे़ खुनिॽ तक्‍ले़ङ्‌वाओ मे़बोःक्‍काङ् इङ्‌मे़ले़क्‍तुसि हे़क्‍क्‍याङ् से़प्‍मा मे़बाङ्‌घुसिरो॥ हे़क्‍केलॽरिक् पा-माहाॽ साःहाॽरे़, हे़क्‍क्‍याङ् साःहाॽ पा-माहाॽरे़ खुनिॽ तक्‍ले़ङ्‌वाओ मे़बोःक्‍काङ् से़प्‍मा मे़बाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","खिनिॽ याप्‍मि नसाःन् के़जोगिबाल्‍ले़ चोगुल्‍ले़ के़रे़क् मनाहाॽरे़ के़म्‍जिःत्तिॽरो, कर आत्तिल्‍ले़ कुनुप्‍मो थारिक् थरुॽ, खे़ल्‍ले़ए से़न्‍लप् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","खिनिॽ थिक्‍ते़न्‍नो तुक्‍खे के़म्‍जाःत्तिल्‍ले़ वेॽस्‍मा ते़न्‍नो खे़त्‍छिङ्‌ङे़म्‍मे़ॽओ॥ इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, इङ्‌गाॽ मे़न्‍छाम्‍साःन् नुःङ्‌ङा युःआल्‍ले़ खिनिॽ कन् इस्राइलस्‍मा के़रे़क् ये़क्‌यक्‍हाॽओ सुनाइङ् से़ःमा याःम्‍बक् मे़न्‍छुःत्ते के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","हुॽसाम्‍बे़न् कुसिक्‍साम्‍बान्‍नुःल्‍ले़ यम्‍बा, हे़क्‍क्‍याङ् सेवारोबे़न् कुन्‍दाङ्‌बान्‍नुःल्‍ले़ यम्‍बा मे़ःन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","हुॽसाम्‍बे़न् कुसिक्‍साम्‍बे़न्‌कुइसिःक् हे़क्‍क्‍याङ् सेवारोबे़न् कुन्‍दाङ्‌बे़न्‌कुइसिःक् पोःङ्‌माए पोःङ्‌लो॥ हे़क्‍केलॽरिक् इङ्‌गाॽ हिम्‍दाङ्‌बान्‍ने खे़ङ्‌हाॽरे़ फे़न्‍साम्‍हाॽरे़ खुनिॽ हाङ् बालजिबुल मे़मे़त्ताङ्‌ङिल्‍ले़ आहिम्‍सयङ्‌बाहाॽग खे़न्‍नुःल्‍ले़आङ् साॽरिक् फे़न् मिङ्‌हाॽ मे़वाःत्तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽनु मे़गिसे़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ मे़धाःप्‍ने़न्‍ल फाॽआङ् ते़प्‍ते़आङ्‌के़वाॽबा पाःन् इग्र कुसिङ् निःत्‍मे़दे़त्‍ने़न्‍ल फाॽआङ् माॽरे़आङ् के़वाॽबा पाःन् थेआङ् होःप्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","इङ्‌गाॽ आल्‍लो खागे़माक्‍पाओ मे़त्‍निङ्‌बा पाःन्‍निन् खागे़ओःप्‍पाओ मे़त्ते़म्‍सिम्‍मे़ॽ, खिनिॽ स्‍वाःत्ताङ् मे़त्‍निङ्‌बा पाःन्‍निन् के़रे़क् मनाहाॽरे़ मे़घे़प्‍सुर फाॽआङ् हिम् सम्‍दाङ्‌लाम् यम्‍बा इक्‍लाओ इङ्‌भन् चोगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","नासिङ्‌गे़न् थक्‍किन् के़से़प्‍पाहाॽनु खिनिॽ मे़गिसे़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ खिनिॽ याम्‍साम्‍मिन् से़प्‍मा मे़न्‍छुक्‍तुन्‍लो॥ कर नासिङ्‌गे़न् थक्‍किन् नु याम्‍साम्‍मिन् ने़प्‍माङ् खे़मायङ्‌सङ्‌ङो मे़ङ्‌मा के़सुक्‍पा निङ्‌वाॽफुमाङ्‌ङिन्‍नु किःसे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ने़त्‍छि चुजुक्‍सा पुहाॽरे़ याङ्‌धिक् मे़ले़क्‍ने़न्‍बि? हे़क्‍केसाङ् खिनिॽ पानुदिङ् पा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिङ्‌वाॽ मे़ःन्‍ने लत्‍थिक्‍काङ् खाम्‍मो मक् मे़धाने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","हे़क्‍केलॽरिक् खिनिॽ थे़गेःक्‍कोबा के़रे़क् थे़गेःक्‍इहाॽ खुने़ॽ निःरुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","खे़ल्‍ले़ चोगुल्‍ले़ मे़गिसे़म्‍मिन्‍ने़ॽ॥ खिनिॽग यरिक् चुजुक्‍सा पुहाॽनुःल्‍ले़आङ् इमे़ल्‍लुङ्‌बा के़जोगिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","हाःत्‍ले़ मना तगि ये़सुःन् नसाःन् चोगुङ् लॽरिक् पाःत्तुॽ, साङ्‌ग्राम्‍पेदाङ्‌ङो के़वाॽबा आम्‍बारे़ कुदगि इङ्‌गाॽआङ् खे़न् ताःक्‍तुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","हाःत्‍ले़ इङ्‌गाॽ मना तगि नाॽआ, साङ्‌ग्राम्‍पेदाङ्‌ङो के़वाॽबा आम्‍बारे़ कुदगि इङ्‌गाॽआङ् खे़न् नाॽरुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“इङ्‌गाॽ इक्‍सादिङ् खाम्‍बेःक्‍मो सनारुङ् ताःत्‍छे़ त्‍याङ्‌बा फाॽआङ् मे़इःत्ते़म्‍मिन्‍ने़ॽ॥ इङ्‌गाॽ सनारुङ् ताःत्‍छे़ग मे़ःन्, कर तुक्‍खे ताःत्‍छे़ त्‍याङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","थेआङ्‌भे़ल्‍ले़ पाःल्‍ले़ कुदक्‍ले़ङ्‌वाओ ये़म्‍बित्‍छाॽसाःन्, माःल्‍ले़ कुदक्‍ले़ङ्‌वाओ मे़न्‍छुमाॽसाःन्, हे़क्‍क्‍याङ् नोःप्‍माल्‍ले़ कुदक्‍ले़ङ्‌वाओ पाङ्‌लिमान् फोःङ्‌से़ त्‍याङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","मनाःल्‍ले़ कुनिङ्‌मिहाॽग आबाङे कुहिम्‍सयङ्‌हाॽए मे़बोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","कुम्‍बा कुम्‍मासि इङ्‌गाॽनुःल्‍ले़आङ् यरिक् लुङ्‌माॽ के़दुक्‍पे़न्‌आहुॽसाम्‍बा पोःङ्‌मा मे़लाॽरुन्‍लो॥ हे़क्‍केलॽरिक्‍के कुस्‍साः कुएहाॽ इङ्‌गाॽनुःल्‍ले़आङ् यरिक् लुङ्‌माॽ के़दुक्‍पे़न्‌आहुॽसाम्‍बा पोःङ्‌मा मे़लाॽरुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","हे़क्‍क्‍याङ् आत्तिल्‍ले़ कुसिलाम्‍साक्‍मा सिङ्‌ङिन् आबाङे पक्‍खुआङ् इङ्‌गाॽनु लाङ्‌मे़घेःक्‍ने़न् खे़न् आहुॽसाम्‍बा पोःङ्‌मा मे़लाॽरुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","आत्तिल्‍ले़ ने़त्तिगे़न् कुहिङ्‌मन्‍निन् आबाङे हिङ्‌मा कोःत्तुॽ खे़ल्‍ले़ खे़न् मासुॽरो, कर आत्तिल्‍ले़ ने़त्तिगे़न् कुहिङ्‌मन्‍निन् आलागि मासुॽ, खे़ल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“आत्तिल्‍ले़ खिनिॽ लाङ्‌गे़दाःक्‍तिॽ, खे़ल्‍ले़ इङ्‌गाॽआङ् लाङ्‌दाःक्‍कारो, हे़क्‍क्‍याङ् आत्तिल्‍ले़ इङ्‌गाॽ लाङ्‌दाःक्‍का, खे़ल्‍ले़ इङ्‌गाॽ याप्‍मि के़बाङ्‌बे़न्‍नाङ् लाङ्‌दाःक्‍तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","आत्तिल्‍ले़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्‌लाङ्‌दाःक्‍तुॽ, खे़ल्‍ले़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़ल्‍ले़न् थुम्‍घोःन् खोःसुॽरो॥ हे़क्‍क्‍याङ् आत्तिल्‍ले़ साम्‌योनिबा याप्‍मिःन् लाङ्‌दाःक्‍तुॽ, खे़ल्‍ले़ साम्‌योनिबाल्‍ले़न् थुम्‍घोःन् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","आत्तिल्‍ले़ इङ्‌गाॽओ नसाःन् के़जोःक्‍पाहाॽओ के़रे़क्‍नुःल्‍ले़ चुक्‍साधिक्‍किन् आहुॽसाम्‍बा फाॽआङ् फङ्‌नाधिक् च्‍वाःत् पिरुॽ, खे़ल्‍ले़ से़क्‍खाए थुम्‍घोःन् खोःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ये़सुरे़ थिक्-ने़त् कुहुॽसाम्‍बाहाॽ हे़क्‍केलॽरिक् इङ्‌जाःङ् पिरु सुरुसिआङ् खे़प्‍मोलाम् खुने़ॽ गालिल खिरिबा पाङ्‌जुम् हे़ङ्‌घाःत्ति निसाम् हुॽसे़ नु सुनाइङ् से़ःसे़ थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","खे़न् ये़म्‍मो पुङ्‌लाहिम्‍मो साक्‍ते़आङ् यागे़बा बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरे़ चोगुबा याःम्‍बक्‍हाॽ खे़प्‍सुआङ् कुहुॽसाम्‍बाहाॽ ये़सुरो पाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","खे़ङ्‌हाॽ मे़बेआङ् ये़सुःन् सेःन्‍मे़दोसु, “के़दाःबार के़बप्‍पा ख्रिस्‍ते़न्‌बा खे़ने़ॽएने़बि, इ वेॽस्‍मान् हाङ्‌घुम्‍बे़बाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ये़सुरे़ नोगप् पिरुसि, “नुःक्‍खे़म् पेगे़म्‍मे़ॽआङ् के़निःसुम्‍बा नु के़घे़प्‍सुम्‍बा पाःन्‍हाॽ युहुन्‍नाःन् मे़त्ते़म्‍मे़ॽओ– ");
INSERT INTO lifNT2_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","मिक्‍फःम्‍बाहाॽरे़ निःमा मे़सुक्‍तुॽ, लाङ्‌सक्‍पाहाॽ लाङ्‌मे़घेःक्, लोगेॽ तुक्‍माल्‍ले़ तरुसिबाहाॽ मे़नुॽ, नाधाक्‍पाहाॽरे़ खे़म्‍मा मे़सुक्‍तुॽ, के़सिःबाहाॽ कुहिङ्‌वे़त् मे़बोःङ्, हे़क्‍क्‍याङ् याङ्‌गे़साॽबाहाॽरे़ सुनाइङ् मे़घे़प्‍सुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","इङ्‌गाॽ याप्‍मि चप्‍चि मे़न्‍जोःक्‍मना मनाःन् मुॽइसाबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ कुहुॽसाम्‍बाहाॽ मे़बेर मे़बत्‍छे़ल्‍ले़ ये़सुरे़ खे़प्‍मो के़वाॽबा मनाहाॽ युहुन्‍नारे़ कुयाःम्‍बेओ अक्‍खे मे़त्तुसि, “ये़ःङ्‌घादे़न्‍नो थेःन् ओमत्‍छे़ के़बेगिबाबे? सुरित् केजङ्‌ङिल्‍ले़ वाःन्‍जो-वाःन्‍जो लॽरिक् वाःन्‍दुबा थिङ्‌ने़त् हे़क्‍तङ्‌बा मनाःन्बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","मे़ःन्‍ने़ फाॽग्र थेःन् ओमत्‍छे़ के़बेगिबाबे? नुःब्‌नुःबा चाङ्‌देःत् के़जाङ्‌बा मनाःन्बि? मे़ःन्, हे़क्‍तङ्‌बा मनाःङ्‌ग हाङ्‌हिम्‍मोरक् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","हे़क्‍केःल्‍ले़ थेःन् ओमत्‍छे़ खिनिॽ के़बेगि? माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पान्बि? ओरो, से़क्‍खाए इङ्‌गाॽ मे़त्‍निङ्, खुने़ॽग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पानुःल्‍ले़आङ् यम्‍बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","साम्‌योसाप्‍लाओ युहुन्‍नारे़ कुयाःम्‍बेओ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ अक्‍खेलॽरिक् पाःत्तुआङ् पत्, ‘इङ्‌गाॽ आइङ्‌साबान् के़लाम्‍मिन् यारिप् चोःक्‍से़ खे़ने़ॽनुःल्‍ले़ तगि पाङ्‌घुङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, बप्‍तिस्‍मा के़बिबा युहुन्‍नाःन्‍नुःल्‍ले़ वेॽ यम्‍बा हाःत्ताङ् सामे़न्‌वाःन्‍छिङ्‌ङे वाॽरो॥ हे़क्‍केसाङ् साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो चुबे़त्‍छिक्‍लक् के़ये़क्‍पा मनाःन् खुने़ॽनुःल्‍ले़ यम्‍बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","युहुन्‍नारे़ इङ्‌भन् चोःक्‍मा हेःक्‍तुआङ्धो आइन् थारिक् साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिन् लुबुबुना तगि पोःर पत्, हे़क्‍क्‍याङ् कुदक्‍ले़ङ्‌वाओ के़बोःक्‍पाहाॽरे़ साके़ल्‍ले़क्‍काङ् अप्‍मा तम्‍सिन् मे़जोगुर मे़बत्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","युहुन्‍नारे़ कुये़म्‍मो थारिक् मोसारे़ साप्‍तुबा साम्‌योथिम्‍मिल्‍ले़ हे़क्‍क्‍याङ् के़रे़क् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ ताःन्‍दि के़दाःबार के़बप्‍पा निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़ कुयाःम्‍बेओए मे़बाःत्तुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","हे़क्‍क्‍याङ् खिनिॽ नसाःन् चोःक्‍मा के़दे़न्‍दिॽने़ फाॽग्र खे़ङ्‌हाॽरे़ ताः लॽरिक् मे़बाःत्तुबा एलियाःङ्‌ग युहुन्‍नाःन्‍नेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","नुःरिक्‍काङ् खे़प्‍से़म्‍मे़ॽआङ् कुसिङ्‌निःत्ते़म्‍मे़ॽओ! ");
INSERT INTO lifNT2_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","कोये़म्‍बा कन् मनाहाॽ थेःन्‍नु तङ्‌घुङ्‌सिङ्‌बाबे? कन् मनाहाॽग पाङ्‌जुम्‍मो के़वाॽबा हिन्‍जाॽहाॽ कुइसिःक् मे़जोःक्, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ वेॽ हिन्‍जाॽहाॽ अक्‍खे मे़मे़त्तुसिॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘खिनिॽ लागि आनिगे़ के हिप्‍मना, कर खिनिॽ के़न्‍लाःक्‍खिन्, हे़क्‍क्‍याङ् आनिगे़ मेरिङ् थक्‍मना, कर खिनिॽ के़न्‍हाबिन्॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","हे़क्‍केलॽरिक् बप्‍तिस्‍मा के़बिबा युहुन्‍नाःङ्‌ग मे़न्‍जा मे़न्‍धुङ्‌ङे त्‍ये़साङ् खिनिॽ खे़ङ्‌ग फे़न्‍साम्‍मिल्‍ले़ युक्‍तुआङ् वाॽ लॽरिक् के़मे़त्तुम्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","इङ्‌गाॽ मे़न्‍छाम्‍साःङ्‌ग चाङ्‌ल थुङुङ्‌ल त्‍याङ्, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ अक्‍खे मे़बाःत्तु, ‘खे़ङ्‌ग तःक् थे़ःक्‍के नु थिःमसाङ्‌लो, एःङ्‌याङ् के़भोःङ्‌बाहाॽ नु लायोबाहाॽरे़ खुनिॽ चुम्‍लो॥’ कर निङ्‌वाॽफु सिक्‍कुम्‍दिङ् निङ्‌वाॽइङ्‌ग कुयाःम्‍बक्‍कोलाम् खे़न् निस्‍से चोःक् फाॽआङ् निःदे़त्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","हे़क्‍क्‍याङ् ये़सुरे़ तगि यरिक्‍तङ्‌बा निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ चोगुबा ये़क्‌यक्‍हाॽ फे़ःक्‍मा हेःक्‍तुसि, थेआङ्‌भे़ल्‍ले़ खे़प्‍मोबा मनाहाॽ खुनिॽ लायोलाम् मे़न्‍हिन्‍दे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“खोराजिन नु बे़थसेदा पाङ्‌जुम्‍मोबा मनासे, चिःत्ते़आङ्‌लक् स्‍ये़रो! खिनिॽ पाङ्‌जुम्‍मो पोःक्‍खे़बा निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ खुनिॽ ये़क्‌यक् तायर नु सिदोन्‍नो पोःक्‍खे़आङ् वये़ल्‍ले़ग उन्‍छोःन्‍छा खे़प्‍मोबा मनाहाॽ लायोलाम् मे़हिन्‍दे़बारो फाॽआङ् सगितेःत् मे़जाक्‍सिङ्‌ङाङ् खाप्‍पु मे़जुःत्‍छिङ्‌बामे़न्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","कर इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खासे़न् ये़न्‍नोग खिनिॽ तुक्‍खेन्‍नुःल्‍ले़ तायर नु सिदोनबा मनाहाॽरे़ खुनिॽ तुक्‍खेःन् थम्‍मा सुक्‍के़दे़प्‍पा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","हे़क्‍क्‍याङ् खिनिॽ कपर्नहुम पाङ्‌जुम्‍मोबा मनासे, साङ्‌ग्राम्‍पेदाङ् थारिक् पेगिगे़ॽ के़लॽरिबि? मे़ःन्‍लो! खिनिॽग खे़मायङ्‌सङ्‌थारिक् के़ध्‍ये़ॽइरो॥ थेआङ्‌भे़ल्‍ले़ खिनिॽ पाङ्‌जुम्‍मो चोगे़बा हे़क्‍तङ्‌बा निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ सदोम ये़क्‌यक्‍को चोगे़आङ् वये़ल्‍ले़ग खे़न् ये़क्‌यक्‍किङ्‌ग आइन् थारिक् ने़स्‍से़बामे़न्! ");
INSERT INTO lifNT2_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","कर इङ्‌गाॽ मे़त्‍निङ्, खासे़न्‍निल्‍ले़ ये़न्‍नोग खे़ने़ॽनुःल्‍ले़ सादोमरे़ कुदुक्‍खेःन् थम्‍मा सुक्‍के़दे़प्‍पा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","खे़न् ये़म्‍मो ये़सुरे़ तुवा चोगु, “आम्‍बे, साङ्‌ग्राम्‍पेदाङ् नु इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ दाङ्‌बाए, इङ्‌गाॽ नोगे़न् पिने़, थेआङ्‌भे़ल्‍ले़ खे़ने़ॽग सिक्‍कुम्‍साबाहाॽ हे़क्‍क्‍याङ् चाःप्‍पाहाॽनु के़माॽरुबा पाःन्‍निन् हिन्‍जाॽ हे़क्‍तङ्‌बाहाॽ ओसेःन्‍गे़धाक्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","आम्‍बे, बा अक्‍खे चोःक्‍माए खे़ने़ॽ के़सिराॽ थाङे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","हे़क्‍क्‍याङ् ये़सुरे़ मनाहाॽ मे़त्तुसि, “आम्‍बारे़ के़रे़क् पाःन्‍हाॽ पिराङ्‌ङाङ् वाॽरो॥ कुस्‍साःन् कुम्‍बारे़रक् कुसिङ् निःत्तुॽ, वेॽहाॽरे़ कुसिङ् मे़न्‍निःत्तुन्‍लो॥ हे़क्‍क्‍याङ् पानुदिङ् पाःन् कुसिङ् मे़निःत्तुर फाॽआङ् कुस्‍साःल्‍ले़ ओसेःन्‍धाक्‍तुसिबा मनाहाॽरे़रक् कुसिङ् मे़निःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","के़रे़क् के़लिःप्‍पा कक्‍किल्‍ले़ के़गे़ःप्‍तिबा नु के़नाःबासे, इङ्‌गाॽओ त्‍ये़म्‍मे़ॽओ, इङ्‌गाॽ नाःम्‍सिङ्‌मा पिनिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","इङ्‌गाॽ आजिघे़ःप्‍पिन् कुये़म्‍मे़ॽआङ् इङ्‌गाॽनु हुॽआसिम्‍मे़ॽओ॥ थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽग लुम्‍लुम्‍बा नु चुङ्‌जिगे़म्‍बा चोःक्‍कारो, हे़क्‍क्‍याङ् खिनिॽ याम्‍साम्‍मिल्‍ले़ नाःम्‍सिङ्‌मा खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आजिघे़ःप्‍पिन् उसुरुबा नु कुःमा पाङ्‌निङ्‌बा आगक्‍किन् याङ्‌याङ्‌बा चोःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","थिक्‍ले़ङ् ये़सुःन् नु कुहुॽसाम्‍बाहाॽ नाःम्‍सिङ्‌ये़न्‍नो प्‍याङ्‌सिगे़न् इक्‍ताप्‍लुम्‍मोनु मे़बेर मे़बत्‍छे़ल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ खुनिॽ से़त्‍लाःक्‍ते़आङ् सिःदाप्‍माहाॽ मे़दुबुआङ् मे़नुगुर चामा मे़हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","कुभा फरिसिहाॽरे़ खे़न् मे़निःसुआङ् ये़सुःन् मे़मे़त्तु, “ओमे़त्ते़ॽ, नाःम्‍सिङ्‌ये़न्‍नो याःम्‍बक् चोःक्‍मा मे़नुॽने़न्, कर के़हुॽसाम्‍बाहाॽरे़ग मे़जोगुङ्‌ग!” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “मे़ःम्‍बे़! दाउद हाङ्‌ङिन् नु कुमनाहाॽरे़ खुनिॽ से़त्‍लाःक्‍ते़ल्‍ले़ मे़जोगुबा पाःन्‍निन् साम्‌योसाप्‍लाओ मे़न्‍निःत्ते के़वयिॽबि? ");
INSERT INTO lifNT2_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","दाउद हाङ्‌ङिन् निङ्‌वाॽफु साःङ्‌गाहिम्‍मो लाःसे़आङ् खुने़ॽ नु कुन्‍जुम्‍हाॽरे़ निङ्‌वाॽफुमाङ्‌ङिन् तोःम्‍मनाबा सेसे खरे़ःङ्‌ङिन् मे़जरो॥ खे़ङ्‌ग साम्‌योथिम् कुइसिःक् निङ्‌वाॽफुसाम्‍बाहाॽरे़रक् चामा के़नुॽबा वये़, कर वेॽहाॽरे़ चामा मे़न्‍नुॽमनाबा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","याम्‍मो मोसारे़ साप्‍तुबा साम्‌योथिम्‍मिन् मे़न्‍निःत्ते के़वयिॽबि? साम्‌योथिम्‍मिल्‍ले़ याःम्‍बक् चोःक्‍मा मे़नुॽने़न् पाःत्तुसाङ् निङ्‌वाॽफुसाम्‍बाहाॽरे़आङ् नाःम्‍सिङ्‌ये़न्‍नो माङ्‌हिम्‍मो याःम्‍बक् मे़जोगु, करसाङ् आप्‍तिक् मे़ःन्‍नेबा मे़बोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","इङ्‌गाॽ से़क्‍खा मे़त्‍निङ्, माङ्‌हिम्‍मिन्‍नुःल्‍ले़आङ् यम्‍बान् कप्‍मो वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ इङ्‌गाॽ सिदुङ्‌जभाःन् चाहाबा मे़जोःक्‍कान् कर मनाहाॽ लुङ्‌माॽ तुक्‍ते़म्‍सिम्‍मे़ॽ फाॽआङ् निङ्‌वाॽ चोगुङ् लॽरिक् साम्‌योसाप्‍लाओ पाःत्तुबा पाःन्‍निन् के़निःसुम्‍माङ् के़वयिल्‍ले़ग फोत्‍या मे़ःन्‍नेबा मनाहाॽ आप्‍तिक् के़न्‍गुःत्तुम्‍सिम्‍मे़न्‍बा वये़ मे़न्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ मे़न्‍छाम्‍साःङ्‌ग नाःम्‍सिङ्‌ये़न्‍निल्‍ले़न्‍नाङ् कुन्‍दाङ्‌बाआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ये़सुःन् खे़प्‍मोलाम् पेआङ् यहुदि चुम्‍लुङ्‌हिम्‍मो लाःसे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","खे़प्‍मो कुहुक् के़सम्‍बा मनाधिक् वये़॥ हे़क्‍क्‍याङ् खे़प्‍मो कुभा यहुदिहाॽरे़ ये़सुःन् आप्‍तिक्‌कुःप्‍मा फाॽआङ् मे़सुगुर मे़वये़आङ् सेःन्‍मे़दोसु, “नाःम्‍सिङ्‌ये़न्‍नो मनाहाॽ वेःम्‍मासि साम्‌योथिम्‍मिल्‍ले़ आबिॽबि मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ मे़ल्‍लुक्‍किन् नाःम्‍सिङ्‌ये़न्‍नो केःम्‍बा लुम्‍बाःत्तो मक्‍थाःल्‍ले़ के़न्‍उःक्‍खुम् के़न्‍लःत्तुम्‍मिन्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","मे़न्‍छाम् याप्‍मिःङ्‌ग मे़ल्‍लुक्‍किन्‍नुःल्‍ले़ इमे़ल्‍लुङ्‌बा मे़जोःक्‍ने़न्बि? नाःम्‍सिङ्‌ये़न्‍नो नुःबा याःम्‍बक् चोःक्‍मा साम्‌योथिम्‍मिल्‍ले़ आबिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मनाःन् मे़त्तु, “के़हुक्‍किन् सन्‍छे़ॽ॥” खे़ल्‍ले़ कुहुक्‍किन् सन्‍छुल्‍ले़ खिमो वेःत्ते़आङ् वेॽस्‍मा कुहुक्‍किन् हे़क्‍केए नुःबा पोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","कर फरिसिहाॽ यहुदि चुम्‍लुङ्‌हिम्‍मोलाम् मे़लःन्‍दे़ मे़बेआङ् ये़सुःन् आक्‍खेआङ् से़प्‍माबे फाॽआङ् पाःन् मे़दङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ये़सुरे़ खे़न् चे़म्‍भन् मे़जोगुबान् निङ्‌वाॽ खोःसुआङ् खुने़ॽ खे़प्‍मोलाम् पेरो॥ यरिक् मनाहाॽरे़ खुने़ॽ मे़दिम्‍दु हे़क्‍क्‍याङ् खे़न् के़दुक्‍पा के़यॽबाहाॽ के़रे़क् वेःन्‍दुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","कर ये़सुरे़ खे़ङ्‌हाॽ खुने़ॽ कुयाःम्‍बेओ थेआङ् मे़म्‍बाःत्तुन्‍ल फाॽआङ् के़साक्‍पा इङ्‌जाःङ् पिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","कङ्‌ग ये़सुरे़ कुयाःम्‍बेओ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुबाःन्‍निन् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ अक्‍खेलॽरिक् साप्‍तुबान् के़रे़बारो– ");
INSERT INTO lifNT2_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“इङ्‌गाॽ सेगुङ्‌बा नु लुङ्‌माॽ तुक्‍तुङ्‌बा आसेवारोबान् कप्‍मो वाॽरो॥ खुने़ॽनु इङ्‌गाॽ सःत्ताङ्‌ङाङ् वाॽआरो॥ कुसम्‍दाङ् आसेसेमाङ्‌ङिन् ने़स्‍सुङ्‌पिरुङ् हे़क्‍क्‍याङ् थिम्‍मे़न्‍दङ्‌सुवाङ्‌हाॽ खासे़न्‌रे़न्‌इङ्‌भन् चोगुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","खुने़ॽग मे़घेःने़न् मे़अःक्‍ने़न् हे़क्‍क्‍याङ् लाम्‍लाम्‍मो खुने़ॽ पाःप्‍पाआङ् खे़म्‍मे़दे़त्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","खासे़न्‍निन् कुलिङ्‌धो मे़ङ्‌गे़त्ते थारिक् खुने़ॽग वाःन्‍जोजोबा थिङ्‌ने़ःत्तिन्‍नाङ् मे़से़क्‍खुन्, हे़क्‍क्‍याङ् सिदोॽदोॽबा सेमिन्‍नाङ् मे़से़रुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","खुने़ॽ कुमिङ्‌ङो के़रे़क् थिम्‍मे़न्‍दङ्‌सुवाङ्‌हाॽरे़ निङ्‌साङ् मे़जोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","खे़ङ्‌हाॽरे़ फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबाल्‍ले़ चोगुल्‍ले़ मिक्‍फःम्‍बा नु पाःप्‍मा मे़न्‍छुक्‍मनाबा मनाधिक् ये़सुरो मे़दारु, हे़क्‍क्‍याङ् खुने़ॽ वेःन्‍दुआङ् खे़न् पाःप्‍मा नु खानिःमा के़सुक्‍पा पोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","के़रे़क् मनाहाॽरे़ खुनिॽ निङ्‌वाॽ मये़र मे़बाःत्तु, “कङ्‌ग के़दाःबार के़बप्‍पा दाउद हाङ्‌ङिल्‍ले़ कुस्‍साः से़न्‍लप् के़बिबा हाङ्‌ङिन् मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","कर फरिसिहाॽरे़ खे़न् मे़घे़प्‍सुल्‍ले़ अक्‍खे मे़बाःत्तु, “फे़न्‍साम्‍हाॽरे़ खुनिॽ हाङ् बालजिबुलरे़ कुमुक्‍साम्‍लाम्‌रक्‌कन् मनाःल्‍ले़ फे़न्‍साम्‍हाॽ नाःत्तु लःत्तुसिबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽइन्‌निःसुआङ् अक्‍खे मे़त्तुसि, “आप्‍फेःक् लुम्‍मो के़घेबा के़धक्‍पाआङ् के़से़म्‍बा के़रे़क् हाङ्‌जुम्‍हाॽ मे़मे़क्‍लो॥ हे़क्‍क्‍याङ् आप्‍फेःक् लुम्‍मो के़घेबा के़धक्‍पाआङ् के़से़म्‍बा ये़क्‌यक् नु हिम्‍सयङ्‌हाॽरे़ मे़न्‍धःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","माफे़न्‍साम्‍मिल्‍ले़ आप्‍फेःक् फे़न्‍साम्‍हाॽ नाःत्तुसिआङ् आबाङे कुहाङ्‌जुम्‍मिल्‍ले़ कुदक्‍ले़ङ्‌वाओ पोःक्‍ने़ फाॽग्र आक्‍खेआङ् कुहाङ्‌जुम्‍मिल्‍ले़ थरुबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","हे़क्‍क्‍याङ् बालजिबुल माफे़न्‍साम्‍मिल्‍ले़ कुमुक्‍साम्‍लाम् इङ्‌गाॽ फे़न्‍साम्‍हाॽ नाःत्तुङ् लःत्तुङ्‌सिङ्‌ने़ फाॽग्र खिनिॽ मनाहाॽरे़ आत्तिन् मुक्‍साम्‍लाम् फे़न्‍साम्‍हाॽ मे़नाःत्तु मे़लःत्तुसिबे? खे़ङ्‌हाॽरे़ मे़जोगुबा याःम्‍बक्‍किल्‍ले़ए खिनिॽ पिर्बेःम्‍बो के़ध्‍ये़ॽइआङ् के़वयिॽ फाॽआङ् ओसेःन्‍आम्‍धाक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","कर इङ्‌गाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसेसेमाङ्‌लाम् फे़न्‍साम्‍हाॽ नाःत्तुङ् लःत्तुङ्‌सिङ्‌लो, खे़ल्‍ले़ चोगुल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् खिनिॽ लुम्‍मो त्‍ये़ चुरे़आङ् वाॽ फाॽआङ् कुसिङ् निःत्ते़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“याम्‍मो खे़प्‍से़म्‍मे़ॽओ, के़धुम्‍बा मनाःल्‍ले़ कुहिम्‍मो लाःप्‍माआङ् खे़ल्‍ले़ कुजिगःक्‌वाहाॽ नाप्‍मादेॽमानुःल्‍ले़ तगि खे़न् के़धुम्‍बा मनाःन् इघेःङ्‌माए पोःङ्‌लो॥ हे़क्‍क्‍याङ्‌लक् कुहिम्‍मो लाःप्‍माआङ् चिगःक्‌वाहाॽ लःप्‍मादेॽमा सुक्‍ते़त्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“आत्तिन् इङ्‌गाॽनु थिक्‍हुप्‍पो होःप्‌खे़न् आदक्‍ले़ङ्‌वाओ वाॽ, हाःत्‍ले़ इङ्‌गाॽनु मे़सुप्‍सुन् खे़ल्‍ले़ से़ःसुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“खे़ल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽ खिनिॽ मे़त्‍निङ्, मे़न्‍छाम् याप्‍मिरे़ चोःक्‍मनाबा के़रे़क् लायो नु निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ पाःप्‍मनाबा माङ्‌चे़ॽया पाःन्‍निल्‍ले़न् ले़प्‍मि खोःमा सुक्‍ते़त्, कर सेसेमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ पाःप्‍मनाबा माङ्‌चे़ॽया पाःन्‍निल्‍ले़न् ले़प्‍मि आप्‍फाल्‍ले़आङ् खोमे़दे़त्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","आत्तिन् मनाःल्‍ले़ मे़न्‍छाम्‍साःल्‍ले़ कुदक्‍ले़ङ्‌वाओ पाःत्तुॽ, खे़ल्‍ले़ ले़प्‍मि खोःसुॽ, कर सेसेमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ के़बाःप्‍पाल्‍ले़ कन् ये़म्‍मो हे़क्‍क्‍याङ् के़दाःबा ये़म्‍मोआङ् ले़प्‍मि मे़घोःसुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","नुःबा सिङ्‌बुङ्‌ङो नुःबाए सिङ्‌सेॽ थोःक्‍लो, ताप्‍फे़ःम्‍बा सिङ्‌बुङ्‌ङो ताप्‍फे़ःम्‍बाए सिङ्‌सेॽ थोःक्‍लो॥ सिङ्‌बुङ्‌माङ्‌ग सिङ्‌सेॽलाम्‍मे कुसिङ् निःत्ते़त्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","असेःक्‍पासे, कुनिङ्‌वाॽ के़जिःप्‍पा के़जोगिॽ, हे़क्‍केःल्‍ले़ आक्‍खेलॽरिक् नुःबा पाःन् पाःप्‍मा के़सुक्‍तिबे? थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽबो के़याक्‍पा पाःन्‍हाॽए मुराःल्‍ले़ पाःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","नुःबा मनाःल्‍ले़ कुनिङ्‌वाॽबो के़याक्‍पा नुःबा पाःन्‍हाॽलाम्‍मे पाःत्तुॽरो, हे़क्‍क्‍याङ् कुनिङ्‌वाॽ के़जिःप्‍पा मनाःल्‍ले़ कुनिङ्‌वाॽबो के़याक्‍पा ताप्‍फे़ःम्‍बा पाःन्‍हाॽलाम्‍मे पाःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","इङ्‌गाॽ मे़त्‍निङ्, खासे़न् ये़न्‍नो मनाहाॽरे़ मे़बाःत्तुबा के़रे़क् हने़बा पाःन् सुत्‍लाहाॽरे़न् चिदङ् पिमा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","थेआङ्‌भे़ल्‍ले़ खिनिॽ के़बाःत्तुम्‍बा पाःन् सुत्‍लाहाॽरे़ए खिनिॽ साम्‌योनिबा इग्र लायोबा के़बोःक्‍खिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","हे़क्‍क्‍याङ् कुभा साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिहाॽ मे़दङ्‌सिङ् हे़क्‍क्‍याङ् ये़सुरो मे़द्‌ये़आङ् मे़मे़त्तु, “सिक्‍साम्‍बे, खे़ने़ॽ के़जोगुबा निङ्‌वाॽ के़माबा मिक्‍सेःन्‍धिक्‌आनिगे़ ओमे़प्‍मा निङ्‌वाॽ चोगुम्‍बे़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “कन्‌ये़म्‍मोबा कुॽइगे़भे़ॽबा नु लायोबा मनाहाॽरे़ निङ्‌वाॽ के़माबा मिक्‍सेःन्‍हाॽ ओमे़प्‍मा मे़गोःत्तुॽ, कर खे़ङ्‌हाॽरे़ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा योनारे़ कुमिक्‍सेःन्‍नाङ्‌धो वेॽ मिक्‍सेःन् थेआङ् ओमे़प्‍मा मे़ङ्‌घोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","थेआङ्‌भे़ल्‍ले़ योनाःङ्‌ग यम्‍बा ङाःल्‍ले़ लरुआङ् कुसाप्‍पोःक्‍पो से़न्‍दिक् ले़न्‍दिक् सुम्‌ये़न् थारिक् यागे़॥ हे़क्‍केलॽरिक्‍के इङ्‌गाॽ मे़न्‍छाम्‍साःन्‍नाङ् इक्‍सादिङ् खाम्‍बेःक्‍मा सिगाङ् सुम्‍से़न् नु सुम्‌ये़न् थारिक् याःक्‍कारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","निनबे ये़क्‌यक्‍स्‍मा मनाहाॽ कोये़म्‍बा मनाहाॽनु खासे़न् ये़न्‍नो मे़ये़प्‍पाङ् कङ्‌हाॽ आप्‍तिक् मे़गुःत्तुसिॽरो॥ थेआङ्‌भे़ल्‍ले़ योनारे़ पाःत्तुबा पाःन्‍नो खे़ङ्‌हाॽरे़ नसाःन् मे़जोगुआङ् खुनिॽ लायोलाम् मे़हिन्‍दे़रो, कर कप्‍मोग योनाःन्‍नुःल्‍ले़आङ् यम्‍बाधिक् वाॽसाङ् खिनिॽ लायोलाम् के़न्‍हिन्‍दिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","लाङ्‌गे़त् पिसाङ्‌बा सिवा लाजेॽस्‍मा हाङ्‌मान् खासे़न् ये़न्‍नो ये़म्‍सिङ्‌ङाङ् कन् ये़म्‍बा मनाहाॽरे़ खुनिॽ तक्‍ले़ङ्‌वाओ पोःक्‍काङ् पाःन्‍धिक्‍तुसिॽरो॥ थेआङ्‌भे़ल्‍ले़ खुने़ॽ सोलोमन हाङ्‌ङिल्‍ले़न् सिक्‍कुम्‍दिङ् खाहुन् खे़म्‍से़ साॽरिक् माःङ्‌घाबा लाजेॽलाम् त्‍ये़आङ् वये़रो॥ कप्‍मो सोलोमन हाङ्‌ङिन्‍नुःल्‍ले़ यम्‍बान्‌वाॽसाङ् के़न्‍घे़प्‍सुम्‍मिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“फे़न्‍साम्‍मिन् मनाओलाम् लःन् पेःक्‍किल्‍ले़ नाःम्‍सिङ्‌ते़न् कोःत्‍छे़ से़ङ्‌से़ङ्‌बा ते़न् हे़ङ्‌घाःत्ति पेःक्‍लो, कर खे़ल्‍ले़ आत्तान्‍नाङ् मे़घोःसुन्‍नाङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","अक्‍खे मे़त्‍छिङ्‌लो, ‘इङ्‌गाॽ ले़रुङ्‌बा मनाःल्‍लोए नुःङ्‌ङा पेःक्‍कारो॥’ हे़क्‍क्‍याङ् खे़न् खे़प्‍मो नुःङ् ताःल्‍ले़ तगि यागे़बा ते़न्‍निन् कुघाले़म्, मे़दुगुबा नु नुःबा मे़जोगुबा निःसुॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","हे़क्‍क्‍याङ् खे़न् पेःक्‍काङ् आप्‍फेःक्‍नुःल्‍ले़आङ् साॽरिक् कुॽइ के़भे़ॽबा वेॽ नुसि फे़न्‍साम्‍हाॽ तारुसिआङ् खे़ङ्‌हाॽ सिगाङ् मे़लाःत्ताङ् मे़युङ्‌सिङ्‌लो॥ खे़न् मनाःल्‍ले़ कुयाक्‍नाम्‍मिन् तगिबानुःल्‍ले़आङ्‌ताप्‍फे़ःम्‍बा पोःङ्‌लो॥ कन् ये़म्‍मोबा कुॽइ के़भे़ॽबा मनाहाॽरे़ खुनिॽ याक्‍नाम्‍मिन्‍नाङ् बा हे़क्‍तङ्‌बाए पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ये़सुःन् मनाहाॽनु पारे़र यागे़ल्‍ले़ कुम्‍मा नु कुन्‍साॽसि खुने़ॽनु ताॽजे़ङ्‌मा निङ्‌वाॽ मे़जोगुआङ् लाःक्‍कात् मे़ये़बे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","मनाधिक् पेआङ् खुने़ॽ मे़त्तु, “आदाङ्‌बे, के़म्‍मा नु के़न्‍साॽसि खे़ने़ॽनु ताॽजे़ङ्‌मा फाॽआङ् लाःक्‍कात् के़म्‍हाङ्‌ल मे़ये़प्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ये़सुरे़ खे़न् नोगप् पिरु, “आम्‍मा नु आन्‍साॽसि हाःत्‍छिबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","कुहुॽसाम्‍बाहाॽ सोःक्‍तुसिर खे़न् मनाःन् मे़त्तु, “ओमे़त्ते़से़ॽ, कप्‍मो आम्‍मा नु आन्‍साॽसि मे़युङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","थेआङ्‌भे़ल्‍ले़ आत्तिन्‍हाॽरे़ साङ्‌ग्राम्‍पेदाङ्‌बा आम्‍बारे़ कुनिङ्‌वाॽ हे़क्‍के मे़जोगुॽ, खे़ङ्‌हाॽए आम्‍मा नु आन्‍साॽसिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","बा खे़न् ये़न्‍नो ये़सुःन् हिम्‍मोलाम् पेआङ् गालिल वरक्‍किल्‍ले़ कुयाओ युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","खे़प्‍मो यरिक् मनाहाॽ मे़जुप्‍से़, हे़क्‍केःल्‍ले़ खुने़ॽ खःङ्‌बेओ लाःसे़आङ् युङ्‌सिङ्‌, कर मनाहाॽ लाःक्‍कात् वरक्‍किल्‍ले़ कुयाओ मे़ये़बे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","हे़क्‍क्‍याङ् ये़सुरे़ अक्‍खेलॽरिक् यरिक् पाःन्‍हाॽ खे़दाॽओ मे़त्तुसि, “लत्‍छा याःन्‍के़मःबाधिक् याॽरिःम्‍बा ले़प्‍से़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","खे़ल्‍ले़ याॽरिःम्‍बे़न् ले़प्‍तुल्‍ले़ कुभा याॽरिःम्‍बे़न् लाम्‍मो मक्‍थ्‍ये़, हे़क्‍क्‍याङ् पुहाॽ मे़द्‌ये़आङ् मे़ज मे़देःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","हे़क्‍क्‍याङ् कुभा याॽरिःम्‍बे़न् लुङ्‌घे़रे़क्‍को चुक्‍ते़रो॥ खे़ङ्‌हाॽ लिङ्‌माग लिङे़, कर यरिक् खाम् मे़ने़स्‍से़न्‍नाङ् कुस्‍साःप्‍पिन् खाम् सिगाङ्‌धारिक् मे़लाःसे़न्‍बाल्‍ले़ चोगुल्‍ले़ कुदाःन्‍दिक्‍मा नाम् से़ःरे़ल्‍ले़ नाम्‍मिल्‍ले़ से़ःक्‍तुआङ् के़रे़क् हेरे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","कुभा याॽरिःम्‍बाङ्‌ग तिङ्‌ग्रेःक्‍पाल्‍ले़ कुसेॽ के़ने़बा ते़न्‍नो चुक्‍ते़आङ् सोसोरिक् लिङे़ल्‍ले़ तिङ्‌ग्रेःक्‍पाल्‍ले़ खे़न् सुःप्‍तु से़रुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","कुभा याॽरिःम्‍बे़ङ्‌ग नुःबा खाम्‍मो चुक्‍ते़रो॥ खे़ङ्‌हाॽओ किप्‍थिक् ले़ङ् (१००), तुक्‍पोःङ्‌ले़ङ् (६०) नु सुम्‍बोःङ् ले़ङ् (३०) थारिक् कुजाॽ पत्‍छे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","खे़म्‍मा ने़क्‍खोॽ के़गप्‍पाहाॽरे़ कन् पाःन्‍निन् नुःरिक् खे़प्‍से़म्‍मे़ॽआङ् कुसिङ्‌निःत्ते़म्‍मे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ मे़द्‌ये़आङ् ये़सुःन् सेःन्‍मे़दोसु, “आदाङ्‌बे, थेआङ् कन्‍हाॽनु खे़दाॽओरक् के़बाःप्‍पाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “थेआङ्‌भे़ल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिल्‍ले़न् सिगाङ्‌बा पाःन्‍हाॽ खिनिॽरक् कुसिङ्‌निःप्‍मा के़घोःसुम्‍माङ् के़वयिॽरो, कर खे़ङ्‌हाॽरे़ग मे़ङ्‌घोए मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","यरिक् के़गप्‍पाल्‍ले़ आल्‍लसाङ् यरिक् खोःसुॽ, हे़क्‍क्‍याङ् खे़ल्‍ले़न् यरिक् पोःङ्‌लो॥ कर हाःत्‍ले़ मे़गत्तुन्, खे़ल्‍ले़ कत्तुबान्‍नाङ् मे़नाप्‍तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","खे़ल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽ खे़ङ्‌हाॽनु खे़दाॽओ पाःत्तारो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ ओमे़मे़त्तुसाङ् मे़न्‍निःसुन्‍लो, मे़घे़प्‍सुसाङ् कुसिङ् मे़न्‍निःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ अक्‍खेलॽरिक् पाःत्तुबान् कन् मनाहाॽओ के़रे़बारो– ‘खिनिॽ के़घे़प्‍सुम्‍साङ् कुसिङ् के़न्‍निःत्तुम्‍मिन्, ओगे़मे़त्तुम्‍साङ् के़न्‍निःसुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","थेआङ्‌भे़ल्‍ले़ कन् मनाहाॽरे़ खुनिॽ खासिङ्‌ङिन्‌के़धुङ्‌बा पोःक्‍खे़आङ् वाॽ॥ खे़ङ्‌हाॽरे़ खुनिॽ ने़क्‍खोॽबान् थाक्‍ते़आङ् वाॽ, हे़क्‍क्‍याङ् खुनिॽ मिक्‍किन् इम्‌मे़मे़त्तुआङ् वाॽ॥ मे़ःन्‍ने़ फाॽग्र खे़ङ्‌हाॽरे़ खुनिॽ ने़क्‍खोॽबाल्‍ले़ मे़घे़प्‍सुबा नु मिक्‍किल्‍ले़ मे़निःसुबामे़न्‌, हे़क्‍क्‍याङ् खुनिॽ सिक्‍लुङ्‌माओ कुसिङ् मे़निःत्तुआङ् इङ्‌गाॽ ले़प्‍माङ् मे़नुःक्‍खे़बामे़न्‌, हे़क्‍क्‍याङ् इङ्‌गाॽ खे़ङ्‌हाॽ वेःन्‍दुङ्‌सिङ्‌मे़न्‌फाॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाःत्तुरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","कर खिनिॽग मुॽइसाबानिङ्‌लो, थेआङ्‌भे़ल्‍ले़ खिनिॽ मिक्‍किल्‍ले़ निःसुॽ, हे़क्‍क्‍याङ् ने़क्‍खोॽबाल्‍ले़ खे़प्‍सुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, यरिक् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ नु साम्‌योनिबा मनाहाॽरे़ खिनिॽ के़निःसुम्‍बा के़घे़प्‍सुम्‍बा पाःन्‍हाॽ निःमा नु खे़म्‍मा साॽरिक् निङ्‌वाॽ मे़जोगुआङ् वये़, कर निःमा नु खे़म्‍मा मे़ङ्‌घोःसुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“आल्‍ल याॽरिःम्‍बा के़ले़प्‍पाल्‍ले़न् खे़दाॽइल्‍ले़ कुबेःन् खे़प्‍से़म्‍मे़ॽओ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","आत्तिल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍बा पाःन्‍निन् खे़प्‍सुआङ् कुसिङ्‌मे़निःत्तुन्, खे़न् मनाःङ्‌ग लाम्‍मो के़जुक्‍पा याॽरिःम्‍बा कुइसिःक् चोःक्॥ माफे़न्‍साम्‍मिन् ताआङ् खे़ल्‍ले़ कुनिङ्‌वाॽओ के़याक्‍पा पाःन्‍जाक्‍किन् लःत्तु तेॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","लुङ्‌घे़रे़क्‍को के़जुक्‍पा याॽरिःम्‍बे़ङ्‌ग पाःन्‍जाक्‍किन् के़सःप्‍पार के़दाःक्‍पा मना कुइसिःक् चोःक्, ");
INSERT INTO lifNT2_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","कर ताङ्‌बा कुस्‍साःप्‌के़बप्‍पा कुबुङ्‌मान् हे़क्‍के खे़ल्‍ले़ सप्‍फारक् थरुरो॥ हे़क्‍क्‍याङ् पाःन्‍जाक्‍किन् नसाःन् चोगुबाल्‍ले़ के़साक्‍पा पाःन् नु तुक्‍खेःन् तानुमे़ःन्‍ने हाराए नसाःन्‍निन् ले़रुदेःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","तिङ्‌ग्रेःक्‍पाल्‍ले़ कुसेॽ के़ने़बादे़न्‍नो के़जुक्‍पा याॽरिःम्‍बे़ङ्‌ग पाःन्‍जाक् के़घे़म्‍बा मना कुइसिःक् चोःक्, कर खे़ल्‍ले़ कन्‌हिङ्‌मन्‍नोबा थेःन् चामा थुङ्‌मा नु याङ्‌साकुन्‍धेसाबा आक्‍खेआङ् पोःङ्‌मा के़लॽबा निङ्‌वाॽइल्‍ले़ पाःन्‍जाक्‍किन् सुःप्‍तुदेःसुॽ, हे़क्‍क्‍याङ् खे़ल्‍ले़ कुजाॽ मे़भत्‍छुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","हे़क्‍क्‍याङ् नुःबा खाम्‍मो के़जुक्‍पा याॽरिःम्‍बे़ङ्‌ग पाःन्‍जाक्‍किन् के़घे़म्‍बाआङ् कुसिङ्‌के़निःप्‍पा मना कुइसिःक् चोःक्‍लो, हे़क्‍क्‍याङ् खे़ल्‍ले़ किप्‍थिक्, तुक्‍पोःङ्‌नु सुम्‍बोःङ् ले़ङ् थारिक् कुजाॽ फत्‍छुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ये़सुरे़ वेॽस्‍मा खे़दाॽइन् खे़ङ्‌हाॽ मे़त्तुसि, “साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग अक्‍तङ्‌बा चोःक्‍लो–लत्‍छा मनाधिक्‍ले़ प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो नुःबा याॽरिःम्‍बान् ले़प्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","कर से़न्‍दिक् के़रे़क् मे़इप्‍से़आङ् मे़ने़स्‍से़ल्‍ले़ कुनिङ्‌मिःन् त्‍ये़आङ् खे़न् मासि ले़प्‍मनाबाओ माले़ःन्‍दो याॽरिःम्‍बान् ले़प्‍तुधआङ् पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","हे़क्‍क्‍याङ् मासिःन् कुजाॽ थोःक्‍मा हेःक्‍ते़ल्‍ले़ माले़ःन्‍दोहाॽआङ् निःधाबे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","हे़क्‍क्‍याङ् सेवारोबाहाॽ लाजेॽ दाङ्‌बाल्‍लो मे़द्‌ये़आङ् सेःन्‍मे़दोसु, ‘आदाङ्‌बे, खे़ने़ॽग प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो मासि याॽरिःम्‍बारक् के़ले़प्‍तुआङ् ने़स्‍से़ मे़ःम्‍बि, कर आक्‍खेआङ् माले़ःन्‍दोःन्‍नाङ् लिङे़बे?’ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","खुने़ॽ नोगप् पिरुसि, ‘खे़ङ्‌ग निङ्‌मिःल्‍ले़ हे़क्‍के चोगुबारो॥’ सेवारोबाहाॽरे़ खुने़ॽ याम्‍मो सेःन्‍मे़दोसु, ‘खे़न् माले़ःन्‍दोहाॽ आःक्‍खुम्‍देःसुम्‍बे़ लॽरिक् निङ्‌वाॽ के़इःत्तुबि?’ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","लाजेॽ दाङ्‌बाल्‍ले़ मे़त्तुसि, ‘हे़क्‍के मे़जोगे़म्‍मिन्‍ने़ॽओ, माले़ःन्‍दोःन् के़आःक्‍खुम्‍मिल्‍ले़ मासिःन्‍नाङ् के़आःक्‍खुम् के़से़रुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","चासुम्‍मा ये़म् थारिक् ने़प्‍माङ् सोसोरिक् पोसिर॥ हे़क्‍क्‍याङ् खे़न् ये़म्‍मो चागे़सुम्‍बाहाॽ के़रे़क्नु तगि माले़ःन्‍दोहाॽ आःक्‍खे़म्‍मे़ॽआङ् इभुत्ते़म्‍मे़ॽ हे़क्‍क्‍याङ् मिओ लाप्‍फुःसे़म्‍मे़ॽ हे़क्‍क्‍याङ् मासिःन् सुप्‍से़म्‍मे़ॽआङ् चायाङ्‌माओ याःक्‍ते़म्‍मे़ॽ फाॽआङ् इङ्‌जाःङ् पिरुङ्‌सिङ्‌लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","हे़क्‍क्‍याङ् ये़सुरे़ याम्‍मो वेॽ खे़दाॽधिक् मे़त्तुसि, “साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग यःङ्‌गेॽ याॽरिःम्‍बान् कुइसिःक् चोःक्‍लो॥ मनाधिक्‍ले़ खे़न् यःङ्‌गेॽ याॽरिःम्‍बान् तेॽरुआङ् इक्‍ताप्‍पो ले़प्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","के़रे़क् याॽरिःम्‍बाओ के़रे़क्‍नुःल्‍ले़ चुक्‍सा चोःक्‍साङ् खे़न् पोःआङ् प्‍याङ्‌सिगे़न् इक्‍ताप्‍पोबा वेॽ नुधि-साक्‍चिॽनुःल्‍ले़ यम्‍बा कुबुङ् पोःङ्‌लो॥ हे़क्‍क्‍याङ् पुसाहाॽ मे़दाआङ् कुबोराःक्‍को हाप् मे़जोगुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ये़सुरे़ आल्‍लसाङ् वेॽस्‍मा खे़दाॽइन् खे़ङ्‌हाॽ मे़त्तुसि, “साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग फे़ॽरुम्‍मो याक्‍मनाबा खरे़ःङ् के़भङ्‌बा सिदाॽइन् हे़क्‍तङ्‌बा चोःक्‍लो॥ थिक् मे़न्‍छुमाॽइल्‍ले़ खप्प्‍याओ यरिक् फे़ॽरुम्‍मो मिसाक् सिदाॽइन् याक्‍तु, हे़क्‍क्‍याङ् सॽरु युक्‍खुआङ् मे़न्‌युप्‍पे थारिक् सुःप्‍तु युक्‍खुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","कन् के़रे़क् पाःन्‍हाॽ ये़सुरे़ मनाहाॽ खे़दाॽओ मे़त्तुसिरो, से़क्‍खाःल्‍ले़ खुने़ॽ पारे़ल्‍ले़ खे़दाॽओरक् पारे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","हे़क्‍केःल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुबाःन्‍निन् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाल्‍ले़ अक्‍खेलॽरिक् पाःत्तुबान् के़रे़बारो– “इङ्‌गाॽ खे़दाॽओरक् पाःत्तारो, हे़क्‍क्‍याङ् इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़न् नावागे़न् चइःत् ने़स्‍से़आङ्धोबा सिबिॽ पाःन्‍हाॽ पाःत्तुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","हे़क्‍क्‍याङ् खे़न् मनाहाॽ ले़रुधसिआङ् ये़सुःन् हिम्‍मो पे॥ कुहुॽसाम्‍बाहाॽ खुने़ॽओ मे़द्‌ये़आङ् “प्‍याङ्‌सिओबा माले़ःन्‍दोरे़न् खे़दाॽइल्‍ले़ कुबेःन् पोआधक्‍ते़ॽ” फाॽआङ् मे़मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ये़सुरे़ नोगप् पिरुसि, “प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो नुःबा याॽरिःम्‍बा के़ले़प्‍पाङ्‌ग इङ्‌गाॽ मे़न्‍छाम्‍साःआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","प्‍याङ्‌सिगे़न् इःक्‍ताप्‍पिङ्‌ग इक्‍सादिङ् खाम्‍बेःक्‍मान्‍लो, हे़क्‍क्‍याङ् खे़न् नुःबा याॽरिःम्‍बाहाॽग निङ्‌वाॽफु हाङ्‌जुम्‍बा मनासिरो॥ माले़ःन्‍दोहाॽग माफे़न्‍साम्‍मिल्‍ले़ कुमनासिरो, ");
INSERT INTO lifNT2_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","हे़क्‍क्‍याङ् माले़ःन्‍दो याॽरिःम्‍बा के़ले़प्‍पा निङ्‌मिःङ्‌ग माफे़न्‍साम्‍मिन्‍लो॥ चासुम्‍मा ये़म्‍मिङ्‌ग कन् इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुनुप्‍मान्‍लो, हे़क्‍क्‍याङ् चागे़सुम्‍बाहाॽग माङ्‌लाइङ्‌बासिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“हे़क्‍क्‍याङ् खे़न् माले़ःन्‍दोहाॽ मे़सुप्‍सुआङ् मिओ लाप्‍मे़भुसुबा कुइसिःक्‍के इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुनुप्‍मान् पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़ आमाङ्‌लाइङ्‌बाहाॽ पाङ्‌घुङ्‌सिङ् हे़क्‍क्‍याङ् के़रे़क् लायो चोःक्‍मा के़बाङ्‌बाहाॽ नु फे़न् याःम्‍बक् के़जोःक्‍पाहाॽ आहाङ्‌जुम्‍मोलाम् मे़सुप्‍सुसिॽआङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","यम्‍बा मिहाप्‍पो लाप्‍मे़भुसुसिॽरो॥ खे़प्‍मो आत्तात्तान्‍ने तुक्‍खेःल्‍ले़ हाःप्‍मान् नु हाबोॽ ये़ःङ्‌मान् पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","हे़क्‍क्‍याङ् साम्‌योनिबाहाॽ खुनिॽ निङ्‌वाॽफुपाःल्‍ले़ कुहाङ्‌जुम्‍मो नाम् कुइसिःक् मे़ले़क्‍लो॥ नुःरिक्‍काङ् खे़प्‍से़म्‍मे़ॽआङ् कुसिङ्‌निःत्ते़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","याम्‍मो “साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो चिङ्‌मनाबा यरिक् याङ्‌भुःन् कुइसिःक् चोःक्‍लो॥ मनाधिक्‍ले़ खे़न् याङ्‌भुःन् खोःसुआङ् याम्‍मो चिक्‍खुरो, हे़क्‍क्‍याङ् खे़न् सःत्‍ल पेःक्‍काङ् खुने़ॽ कत्तुबा के़रे़क् चिगःक्‌वाहाॽ सङ्‌घुआङ् खे़न् प्‍याङ्‌सिगे़न् इक्‍ताप्‍पिन् इङुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“याम्‍मो साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग अक्‍तङ्‌बा चोःक्–लत्‍छा नुःब्‌नुःबा ते़क्‍सेःक् के़गोःप्‍पा ले़ङ्‌हङ्‌बाल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","साॽरिक् इमे़ल्‍लुङ्‌बा ते़क्‍सेःक्‍किन् खोःसु, हे़क्‍क्‍याङ् पेआङ् खे़ल्‍ले़ कत्तुबा के़रे़क् कुजिगःक्‌वाहाॽ सङ्‌घुआङ् खे़न् ते़क्‍सेःक्‍किन् इङुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“याम्‍मो, साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिन् यम्‍बा योःङ् कुइसिःक् चोःक्‍लो॥ खे़न् योःङ्‌ङिन् वरक्‍को मे़ले़प्‍तुल्‍ले़ खे़प्‍मो के़रे़क् परिक्‍ले़न् ङाहाॽ मे़धाःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","हे़क्‍क्‍याङ् खे़न् योःङ्‌ङो कुले़म् ङाहाॽ मे़धाआङ् योःङ् के़ले़प्‍पाहाॽरे़ लाःक्‍कात् मे़उःक्‍खु मे़लःत्तु, हे़क्‍क्‍याङ् मे़युङ्‌सिङ्‌ङाङ् नुःबा ङाहाॽ ङा याङ्‌माओ मे़याक्‍तुसि, कर ताप्‍फे़ःम्‍बा ङाहाॽ याम्‍मो च्‍वाःत्तो लाप्‍मे़भुसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुनुप्‍मोआङ् बा हे़क्‍केए पोःङ्‌लो॥ माङ्‌लाइङ्‌बाहाॽ मे़दाआङ् साम्‌योनिबाहाॽओलाम् फोत्‍याबा मनाहाॽ वेॽ मे़से़न्‍दुसिॽआङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","खे़ङ्‌हाॽ यम्‍बा मिहाप्‍पो लाप्‍मे़भुसुसिॽरो॥ खे़प्‍मो आत्तात्तान्‍ने तुक्‍खेःल्‍ले़ हाःप्‍मान् नु हाबोॽ ये़ःङ्‌मान् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “कन् पाःन्‍हाॽ कुसिङ्‌के़निःत्तुम्‍बि?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “आनिगे़ कुसिङ् निःत्तुम्‍बे़रो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","खुने़ॽ मे़त्तुसि, “साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो हुॽसाम्‍बा के़बोःङ्‌बा के़रे़क् साम्‌योथिम्‍साम्‍बाहाॽग हिम्‍दाङ्‌बा कुइसिःक् मे़जोःक्‍लो॥ खे़ङ्‌हाॽरे़ खुनिॽ सन्‍दोःक्‍लाम् कुसङ् नु के़यःप्‍पा के़ये़क्‍पा इमे़ल्‍लुङ्‌बा चिगःक्‌वाहाॽ मे़लःत्तुसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ये़सुरे़ कन् खे़दाॽहाॽ पाःत्तु सुरुआङ् खे़प्‍मोलाम् पेआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","आबाङे कुबाङ्भेॽओ त्‍ये़रो॥ खे़प्‍मोबा यहुदि चुम्‍लुङ्‌हिम्‍मो मनाहाॽ हुॽमा हेःक्‍तुसिल्‍ले़ मनाहाॽरे़ कुनिसाम्‍मिन् मे़घे़प्‍सुआङ् खुनिॽ निङ्‌वाॽ मये़र अक्‍खे मे़बाःत्तु, “कन् मनाःल्‍ले़ अक्‍तङ्‌बा सिक्‍कुम् निङ्‌वाॽ नु निङ्‌वाॽ के़माबा याःम्‍बक् चोःक्‍मा मुक्‍साम् आत्तोलाम् खोःसुबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","मे़ःम्‍बे़, कङ्‌ग सिङ् के़गाम्‍बाल्‍ले़ कुस्‍साःन्‌मे़ःम्‍बि? कल्‍ले़ कुम्‍मारे़ कुमिङ् मरियम हे़क्‍क्‍याङ् कुन्‍साॽसिग याकुब, युसुफ, सिमोन नु यहुदासि मे़ःन्‍छिबि? ");
INSERT INTO lifNT2_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","खे़ल्‍ले़ कुन्‍साॽ मे़न्‍छुमाहाॽ आनिॽनुएसे़ मे़वाॽबा॥ हे़क्‍केःल्‍ले़ कन् मनाःल्‍ले़ आत्तोलाम् कन् पाःन्‍हाॽ खोःसुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","हे़क्‍के मे़बाःत्तुर खे़ङ्‌हाॽरे़ खुने़ॽ नामे़न्‍छाॽरुन्‍लो॥ कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़ङ्‌ग के़रे़क् ते़न्‍नो मिङ्‌सो इङ्‌धाःङ् मे़बिरु, कर आप्‍फेःक् कुहिम्‍मो नु कुबाङ्‌भेॽओरक् इङ्‌धाःङ् मे़म्‍बिरुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ खुनिॽ नसाःन् होःप्‍ते़बाल्‍ले़ चोगुल्‍ले़ खे़प्‍मो यरिक् निङ्‌वाॽ के़माबा याःम्‍बक् मे़जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","खे़न् ये़म्‍मो गालिल थुम्‍मोबा सुहाङ्‌गे़म्‍बा हे़रोद एन्‍तिपासरे़ ये़सुरे़ चोगुबा याःम्‍बक्‍किल्‍ले़ कुयाःम्‍बेओ खे़प्‍सु, ");
INSERT INTO lifNT2_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","हे़क्‍क्‍याङ् कुसेवारोबाहाॽ अक्‍खे मे़त्तुसि, “कङ्‌ग से़क्‍खासाङ् से़प्‍पाङ्‌घुङ्‌सिङ्‌बा बप्‍तिस्‍मा के़बिबा युहुन्‍नाःन्‍नेरो, खुने़ॽ याम्‍मो हिङे़बाल्‍ले़ चोगुल्‍ले़ मुक्‍साम्‍लाम्‍बा निङ्‌वाॽ के़माबा याःम्‍बक् चोगुर वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","आल्‍ल उन्‍छोःन्‍छा हे़रोदरे़ आबाङे कुन्‍साॽ फिलिपरे़ कुमेःत् हे़रोदियासे़न्‌मेःत्‌कत्तुआङ् वये़॥ हे़क्‍केःल्‍ले़ युहुन्‍नारे़ खुने़ॽ ए़त्‍ले़ङ् “खे़न् आबाङे के़न्‍साॽरे़ कुमेःत्तिन् खे़ने़ॽ मेःत् कप्‍मा मे़नुॽने़न्” मे़त्तुआङ् वये़रो॥ खे़ल्‍ले़ चोगुल्‍ले़ हे़रोदरे़ युहुन्‍नाःन् पुङ्‌लाहिम्‍मो साक्‍तुआङ्‌वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","हे़रोदरे़ युहुन्‍नाःन् से़प्‍मा निङ्‌वाॽ चोगु कर मनाहाॽनु किःसे़आङ् वये़ थेआङ्‌भे़ल्‍ले़ मनाहाॽरे़ग युहुन्‍नाःन् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा फाॽआङ् नसाःन् मे़जोगुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","कर हे़रोदरे़ कुसावाःन्‍छिङ्‌मा ससःत्‍सराङ्‌ङो हे़रोदियासरे़ कुस्‍साः मे़न्‍छुमाॽइन् हे़रोदे़न नु तरेबाहाॽरे़ खुनिॽ तगि नुःरिक् लाःक्‍खे़आङ् हे़रोदरे़ साॽरिक् कुनिङ्‌वाॽ त्‍ये़बाल्‍ले़ चोगुल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","खे़ने़ॽ थे के़नाःक्‍तुसाङ् पिने़रो लॽरिक् माङ्‌हे़क्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","कुम्‍मारे़ हुःस्‍सुआङ् खे़न् चुक्‍मे़ल्‍ले़ अक्‍खे पाःत्तु, “बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ कुधे़गेःक्‍पे़न्‌चे़त्‍थ्‍याओ पिराङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","खे़न् पाःन्‍निन् खे़प्‍सुआङ् हे़रोदे़न कुनिङ्‌वाॽ तुगे़, कर खे़प्‍मो के़वाॽबा तरेबाहाॽरे़ खुनिॽ तगि खुने़ॽ चोगुबा माङ्‌हे़क्‍किन्‌के़प्‍मा पोःक्‍खे़ के़लॽबा निङ्‌वाॽ चोगुआङ् चुक्‍मे़ल्‍ले़ नाःक्‍तुबान् के़त्ते़म्‌पिरे़म्‍मे़ॽ फाॽआङ् इङ्‌जाःङ् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","खे़ल्‍ले़ चोगुल्‍ले़ पुङ्‌लाहिम्‍मो के़याक्‍पा युहुन्‍नारे़ कुधे़गेःक्‍पे़न्‌खक्‍पाङ्‌घुसिआङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","कुधे़गेःक्‍पे़न्‌मे़दारुआङ् खे़न् चुक्‍मे़न् चे़त्‍थ्‍याओ मे़बिरु, हे़क्‍क्‍याङ् खे़ल्‍ले़ खे़न् कुम्‍मारो तेॽरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","खे़न् एगाङ् युहुन्‍नारे़ कुहुॽसाम्‍बाहाॽ मे़द्‌ये़आङ् कुधक्‍किन् मे़देॽरुआङ् मे़लुप्‍तु॥ हे़क्‍क्‍याङ् मे़बेआङ् कन् पाःन्‍निन् ये़सुःन् मे़मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ये़सुरे़ युहुन्‍नारे़ कुयाःम्‍बेओ खे़प्‍सुआङ् खःङ्‌बेओलाम् खुने़ॽरक् एःक्‍सादे़न्‍नो पे॥ कर यरिक् मनाहाॽरे़ ये़सुःन् पेबा पाःन्‍निन् मे़घे़प्‍सुआङ् खुनिॽ पाङ्‌जुम्‍लाम् खुने़ॽ पेबा ले़प्‍माङ् लाङ्‌मे़घेगे़र कुएगाङ् मे़धासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ये़सुःन् खःङ्‌बेओलाम् लःन्‍दे़ल्‍ले़ यरिक् मनाहाॽ निःसुसिआङ् लुङ्‌माॽ तुक्‍तुसि, हे़क्‍क्‍याङ् खे़प्‍मो के़वाॽबा खे़न् के़दुक्‍पा के़यॽबाहाॽ वेःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","हे़क्‍क्‍याङ् युःन्‍छिक् पोःक्‍खे़र पत्‍छे़ल्‍ले़ कुहुॽसाम्‍बाहाॽ खुने़ॽओ मे़द्‌ये़आङ् मे़मे़त्तु, “आदाङ्‌बे, कङ्‌हाॽ पाङ्‌घे़देःसे़से़ॽओ, थेआङ्‌भे़ल्‍ले़ कन् एःक्‍सादे़न्‍नो थेआङ् इङ्‌मा चामा खोमे़दे़त्‍ने़न्‍लो, याम्‍मो नाम्‍ध्‍ये़बेरो॥ हाराॽ खिरिबा पाङ्‌भेॽहाॽओ मे़बेःक्‍काङ् चामा थुङ्‌मा मे़इङु मे़जररो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “कन्‍हाॽ पाङ्‌मासि मे़ःन्‍लो॥ खिनिॽए कङ्‌हाॽ कुजा पिरे़म्‍सिम्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “आनिगे़ग ङासि खरे़ःङ्‌हाॽ नु ने़त्‍छि ङाहाॽरक् कत्तुम्‍बे़ङ्‌ग!” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खे़न् खरे़ःङ्‌ङिन् नु ने़त्‍छि ङाहाॽ कत्‍ना इङ्‌गाॽओ फे़त्ते़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","हे़क्‍क्‍याङ् ये़सुरे़ मनाहाॽ याःन् सम्‍दाङ् युङ्‌मा पाङ्‌घुसिआङ् ङासि खरे़ःङ्‌ङिन् नु ने़त्‍छि ङाहाॽ पक्‍खुआङ् साङ्‌ग्राम्‍पेदाङ् ले़प्‍माङ् थो ओमये़र निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरुआङ् खरे़ःङ्‌हाॽ खे़ःक्‍खु॥ हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ पिरुसिआङ् कुहुॽसाम्‍बाहाॽरे़ खे़न् मनाहाॽ मे़हाःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","खे़न् मनाहाॽरे़ खाघा मे़जआङ् कुहुॽसाम्‍बाहाॽरे़ कुजि के़नम्‍बाहाॽ मे़सुप्‍सुल्‍ले़ थिक्-ने़त् (१२) नइमा योरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","खे़न् के़जाबाहाॽओग मे़न्‍छुमाहाॽ नु हिन्‍जाॽबित्‍छाहाॽ मे़न्‍निःत्‍छिङ्‌ङे ये़म्‍बित्‍छाॽहाॽरक् हे़न्‍छिङ् ङासि (५०००) यारिक् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","खे़न् एगाङ् ये़सुरे़ मनाहाॽ पाङ्‌घुसिर पत्‍छे़ल्‍ले़ कुहुॽसाम्‍बाहाॽ खःङ्‌बेओ लाःस्‍से़म्‍मे़ॽ हे़क्‍क्‍याङ् इङ्‌गाॽनुःल्‍ले़ तगि नाहाङ्‌दाङ् पेगे़म्‍मे़ॽ मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","हे़क्‍क्‍याङ् खुने़ॽ के़रे़क् मनाहाॽ पाङ्‌घुदेःसुसिआङ्‌तुवा चोःक्‍से़ थो कोःक्‍माओ पेरो॥ खादामे़ल्‍ले़ खे़प्‍मो खुने़ॽरक् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","खे़न् ये़म्‍मो कुहुॽसाम्‍बाहाॽ खःङ्‌बेलाम् वरक्‍किल्‍ले़ कुयाओनु माःङ्‌घा मे़गे़रे़आङ् मे़वये़ल्‍ले़ खुनिॽ तक्‍ले़प्‍माङ्‌नु सुरित् केजङ्‌ङिन् हुःरे़आङ् वाभे़ल्‍ले़ङ्‌ङिल्‍ले़ खःङ्‌बेन् साॽरिक् वाःन्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","इङ्‌वा काःमानुःल्‍ले़ तगि ये़सुःन् च्‍वाःत् सम्‍दाङ् लाङ्‌घेगे़र हुॽसाम्‍बाहाॽ मे़वये़बा खःङ्‌बेओ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","खे़ङ्‌हाॽरे़ खुने़ॽ च्‍वाःत् सम्‍दाङ् लाङ्‌घेगे़र पत्‍छे़बा मे़निःसुआङ्‌“कङ्‌ग सिसाम्‍लो!” लॽरिक्‌साॽरिक् मे़गिसे़आङ्‌मे़भिःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","कर ये़सुरे़ खे़ङ्‌हाॽ खिमो मे़त्तुसि, “मे़गिसे़म्‍मिन्‍ने़ॽ! इङ्‌गाॽ ये़सुआ॥ हाङ्‌हाङ् लॽरे़म्‍मे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","हे़क्‍केःल्‍ले़ पत्रुसरे़ मे़त्तु, “दाङ्‌बे, से़क्‍खा खे़ने़ॽएने़ फाॽग्र इङ्‌गाॽआङ् च्‍वाःत् सम्‍दाङ् लाङ्‌घेगे़र फे़रे़ॽ मे़त्ताङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ये़सुरे़ मे़त्तु, “फे़रे़ॽ”॥ हे़क्‍केःल्‍ले़ पत्रुसे़न्‍नाङ् च्‍वाःत्तो लाङ्‌घेगे़र ये़सुःन् वये़बा ले़प्‍माङ् थासिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","कर पेर पत्‍छे़ल्‍ले़ खे़ल्‍ले़ यम्‍बा सुरित् केजङ् नु वाभे़ल्‍ले़ङ्‌ङिन् निःसुआङ् किःसे़॥ हे़क्‍क्‍याङ् खे़न् च्‍वाःत्तो हुम्‍मा हेःक्‍ते़ल्‍ले़ “आदाङ्‌बे, ताङ्‌से़ःप्‍ताङ्‌ङे़ॽओ” लॽरिक् अःक्‍ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","खिमो ये़सुरे़ कुहुक्‍को ते़म्‍सुर मे़त्तु, “नसाःन् के़सुःम्‍बाए, थेआङ् चप्‍चि के़जोगुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","हे़क्‍क्‍याङ् खुन्‍छिॽ खःङ्‌बेओ लाःसे़त्‍छिआङ् सुरित् केजङ्‌ङिन् हुःमा चक् लॽरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ सेवा मे़जोगु, “दाङ्‌बे, खे़ने़ॽग से़क्‍खाए निङ्‌वाॽफुसाःने़रो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","खे़ङ्‌हाॽ नाधाःम्‍बिबा गने़सरे़त ते़न्‍नो मे़गे़रे़आङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","खे़प्‍मोबा मनाहाॽरे़ ये़सुःन् कुसिङ् मे़निःत्तुआङ् खुने़ॽ त्‍ये़बा इङ्‌घङ्‌ङिन् खे़न् खिरिबा ते़न्‍नो से़ःरे़॥ हे़क्‍क्‍याङ् मनाहाॽरे़ यरिक् के़दुक्‍पा के़यॽबाहाॽ ये़सुरो मे़दारुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ के़देःत्तिल्‍ले़ कुसुक्‍पे़न्‍लक्‍साङ्‌सुःमा आबिरे़ॽओ फाॽआङ् खुने़ॽ पेलि मे़भाक्‍तु, हे़क्‍क्‍याङ् खुने़ॽ के़सुबाहाॽ के़रे़क् मे़वेःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","हे़क्‍क्‍याङ् कुभा फरिसिहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ यरुसले़म ये़क्‌यक्‍लाम् मे़द्‌ये़आङ् ये़सुःन् सेःन्‍मे़दोसु, ");
INSERT INTO lifNT2_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“थेआङ् के़हुॽसाम्‍बाहाॽरे़ आनिॽ पाधे़बाहाॽरे़ मे़जोगु मे़युरुबा थिम्‍मिन् मे़न्‍इःत्तुन्‌मे़न्‍नाःत्तुन्बाबे? खे़ङ्‌हाॽरे़ चामानुःल्‍ले़ तगि चोःक्‍थिम् कुइसिःक् हुक् वामे़न्‍हप्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ये़सुरे़ नोगप् पिरुसि, “खिनिॽआङ् पाधे़बाहाॽरे़ मे़जोगु मे़युरुबा थिम्‍मिन् इःप्‍मा नाःप्‍मा फाॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुइङ्‌जाःङ्‌ङिन् थेआङ् के़भेःन्‍दुम्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाःत्तुॽ, ‘के़म्‍बा के़म्‍मासि मिङ्‌सो इङ्‌धाःङ् पिरे़से़ॽ’ हे़क्‍क्‍याङ् ‘आत्तिल्‍ले़ कुम्‍बा कुम्‍मासि साङ्‌ग्रा मे़त्तुसिॽ, खे़ङ्‌ग से़प्‍माए पोःङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","कर आत्तिल्‍ले़ कुम्‍बा कुम्‍मासि इङ्‌गाॽलाम् खिन्‍छिॽ खोःमा के़बोःङ्‌बा कुभाॽइन्, निङ्‌वाॽफुमाङ्‌ङिन् पिरुङ्‌सुरुङ्‌ङाङ् वाॽ लॽरिक् पाःत्तुॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","खे़ल्‍ले़ आबाङे कुम्‍बा कुम्‍मासि कुभाॽ पिमासिआङ्‌मिङ्‌सो इङ्‌धाःङ् पिमासि मे़बोःङ्‌ने़न्‌लॽरिक् खिनिॽ के़बाःत्तुम्‍माङ्‌आप्‍फेःक् खिनिॽ चोःक्‍थिम्‍मिल्‍ले़ निङ्‌वाॽफु पाःन्‍जाक्‍किन् थेना-धेबा के़जोगुम्‍माङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","खिनिॽ निङ्‌वाॽ के़जिःप्‍पासे, खिनिॽ याःम्‍बेओ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुबाःन्‍निन् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ साप्‍तुबाङ्‌ग से़क्‍खाए लाॽरुरो, ");
INSERT INTO lifNT2_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘कन् मनाहाॽरे़ग खुनिॽ मुराःल्‍ले़रक् मिङ्‌सो इङ्‌धाःङ् मे़बिआरो, कर खुनिॽ निङ्‌वाॽइन्‌इङ्‌गाॽ ले़प्‍माङ् होःप्‍लो, ");
INSERT INTO lifNT2_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","कङ्‌हाॽरे़ हने़ए सेवा मे़जोःक्‍का, कर मे़हुॽरुसिबा निसाम्‍मिङ्‌ग मे़न्‍छाम् याप्‍मिरे़ आप्‍फेःक् मे़जोगुबा थिम्‌रक्‍लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ये़सुरे़ मनाहाॽ उःत्तुसिआङ् मे़त्तुसि, “आबाःन्‍निन् खे़प्‍से़म्‍मे़ॽआङ् कुसिङ्‌निःत्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","मनाःल्‍ले़ कुमुराओलाम् के़लाःप्‍पा चाःल्‍ले़ खुने़ॽ आसुत्‍थो मे़जोगुन्, कर कुमुराओलाम् के़लःम्‍बा पाःन्‍निल्‍ले़ खुने़ॽ आसुत्‍थो चोगुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","हे़क्‍क्‍याङ् हुॽसाम्‍बाहाॽ खुने़ॽओ मे़द्‌ये़आङ् मे़मे़त्तु, “खे़ने़ॽ के़बाःत्तुबा पाःन्‍निल्‍ले़ फरिसिहाॽ लक्‍तुसिबा निङ्‌वाॽ के़घोःसुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ये़सुरे़ नोगप् पिरुसि, “साङ्‌ग्राम्‍पेदाङ्‌ङोबा पानुदिङ् आम्‍बारे़ मे़लेःत्तुन्‍बा के़रे़क् सिङ्‌बुङ्‌हाॽ खुनिॽ साःप्‍पोनुए मे़आःक्‍खुॽरो, ");
INSERT INTO lifNT2_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ खुनिॽ पाःन्‍निन् मे़घे़प्‍से़म्‍मिन्‍ने़ॽओ॥ खे़ङ्‌हाॽग मिक्‍फःम्‍बा लाम्‍लोःबासिरो॥ मिक्‍फःम्‍बाल्‍ले़ मिक्‍फःम्‍बे़न् लाम्‍लोसुने़ फाॽग्र ने़प्‍माङ् लुम्‍बाःत्तो के़ङ्‌सि लाःत्‍छिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","पत्रुसरे़ मे़त्तु, “कन् खे़दाॽओ के़मे़त्तुसिबा पाःन्‍निल्‍ले़ कुबेःन् याप्‍मि आजे़क्‍ते़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आल्‍लसाङ् खिनिॽ निङ्‌वाॽ पाःक्‍पि? ");
INSERT INTO lifNT2_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","मुराओलाम् के़लाःप्‍पे़ङ्‌ग साप्‍पोःक्‍को पेःक्‍काङ् लाःक्‍कात् लःन्‍बेःक् फाॽआङ् कुसिङ्‌के़न्‍निःत्तुम्‍मिन्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","कर मना मुराओलाम् लाःक्‍कात् के़लःम्‍बा पाःन्‍निङ्‌ग सिक्‍लुङ्‌मालाम् लःन्‍लो॥ खे़ल्‍ले़ए मनाःङ्‌ग आसुत्‍थो चोगुरो, ");
INSERT INTO lifNT2_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","थेआङ्‌भे़ल्‍ले़ फे़न् निङ्‌वाॽ इःप्‍मा, मना से़प्‍मा, चाराम्‍मा याःम्‍बक्, याम्‍बोःप्‍मा, खुःम्‍मा, फोत्‍याबा तोःन्‍दि पिमा, माङ्‌चे़ॽया पाःन्‍हाॽ निङ्‌वाॽबोलाम् लःन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","कन् पाःन्‍हाॽरे़ग मनाःन् आसुत्‍थो चोगुरो॥ कर हुक् वामे़न्‍हप्‍पे चःल्‍ले़ खे़न् आसुत्‍थो मे़बोःङ्‌ङिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","हे़क्‍क्‍याङ् ये़सुःन् गालिललाम् इस्राइल लाःक्‍कात्‍पा तायर नु सिदोन ये़क्‌यक् खिरिबा थुम्‍हाॽओ पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","खे़प्‍मोबा कनानि सुवाङ्‌स्‍मा मे़न्‍छुमाॽधिक् खुने़ॽओ त्‍ये़आङ् अक्‍खे मे़त्तुर पेलि फाक्‍तु, “दाउदरे़ कुस्‍साः आदाङ्‌बे, लुङ्‌माॽ तुक्‍ताङ्‌ङे़ॽओ! आस्‍साः चुक्‍मे़न् फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुआङ् साॽरिक् तुक्‍खे चाःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","कर ये़सुरे़ खे़न् थेआङ् नोगप् मे़बिरुन्॥ हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽरे़ अक्‍खे मे़मे़त्तुर खुने़ॽनु पेलि मे़भाक्‍तु, “आदाङ्‌बे, खे़न् पाङ्‌घे़देःसे़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ ए़त्‍ले़ङ् पेलि फाक्‍तुआङ्‌आनिगे़ निङ्‌धे़न्‍दुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","हे़क्‍केःल्‍ले़ खे़न् मे़त्तु, “इङ्‌गाॽग इस्राइलस्‍मा के़माबा मे़ल्‍लुक्‍हाॽरे़ लागिरक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाङ्‌घाङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","खे़न् मे़न्‍छुमाॽइल्‍ले़ थुङ्‌बोहजॽ युङ्‌सिङ्‌ल अक्‍खे मे़त्तु, “आदाङ्‌बे, इङ्‌गाॽ कुभाॽ पिराङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ये़सुरे़ मे़त्तु, “हिन्‍जाॽबित्‍छाहाॽरे़ खुनिॽ खरे़ःङ्‌ङिन् नाप्‍मासिआङ्‌कोःत्‍चोहाॽ पिमासि नुःबा मे़ःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","खे़ल्‍ले़ मे़त्तु, “से़क्‍खाएरो आदाङ्‌बे, कर कोःत्‍चोहाॽरे़आङ् खुनिॽ दाङ्‌बाल्‍ले़ चामादे़न्‍नोलाम् मक्‍के़धाःबा कुजिहाॽ मे़जरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ये़सुरे़ खे़न् मे़न्‍छुमाॽइन् नोगप् पिरु, “खे़ने़ॽग से़क्‍खाए यम्‍बा नसाःन् के़गप्‍मा मे़न्‍छुमाॽने़न्‍ने़रो! खे़ने़ॽ के़नाःक्‍तुबे़न् के़घोःसुॽरो॥” हे़क्‍क्‍याङ् बा खे़न् ये़म्‍मो खे़न् मे़न्‍छुमाॽइल्‍ले़ कुस्‍साः चुक्‍मे़न् नुःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ये़सुःन् खे़न् ते़न्‍नोलाम् गालिल वरक्‍किल्‍ले़ कुयाओ पोःक्‍खे़र नुःक्‍खे़ पे, हे़क्‍क्‍याङ् कोःक्‍माओ थो पेआङ् खे़प्‍मो युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","खे़प्‍मो यरिक् मनाहाॽरे़ लाङ्‌सक्‍पाहाॽ, मिक्‍फःम्‍बाहाॽ, लाङ् हुक् फे़त्‍के़लाॽबाहाॽ, खुनिॽ पाःन् मे़न्‍लःम्‍मनाबाहाॽ नु वेॽ यरिक् के़दुक्‍पा के़यॽबाहाॽ मे़दारुसिआङ् कुलाङ्‌बुङ्‌मो मे़युक्‍खुसिरो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ के़रे़क् ये़सुरे़ नुसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","खे़न् मनाहाॽरे़ पाःप्‍मा मे़न्‍छुक्‍मनाबाहाॽ मे़बारे़बा, लाङ् हुक् फे़त्‍के़लाॽबाहाॽ मे़नुरे़बा, लाङ्‌सक्‍पाहाॽ लाङ्‌मे़घेगे़बा नु मिक्‍फःम्‍बाहाॽरे़ निःमा मे़सुक्‍तुबा मे़निःसुआङ् खुनिॽ निङ्‌वाॽ मये़र इस्राइलस्‍मा निङ्‌वाॽफुमाङ्‌ङिन् कुनारा मे़भोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ये़सुरे़ कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् मे़त्तुसि, “इङ्‌गाॽ कन् मनाहाॽ आलुङ्‌माॽ मे़दुक्‍लो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽग सुम्‌ये़न्‍नाङ्‌धो इङ्‌गाॽनुए मे़वाॽ, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ चामा थुङ्‌मा थेआङ् मे़ङ्‌गत्तुन्‍लो॥ खे़ङ्‌हाॽ बा हे़क्‍के साक्‍मे़न्‍जा पाङ्‌मासि आनिङ्‌वाॽ होःप्‍लो, मे़ःन्‍ने़ फाॽग्र मे़बेःक्‍ल मे़बत्तिल्‍ले़सा साक्‍लाम्‍बत्तुसिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","हे़क्‍केःल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ मे़मे़त्तु, “अक्‍तङ्‌बा एःक्‍सादे़न्‍नो कम्‍म्‍याक् यरिक् मनाहाॽ चाःप्‍मासिरे़ लागि खरे़ःङ्‌ङिन् आत्तान्‍नु खोःमा सुक्‍ते़प्‍पाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “आक्‍खे़म्‍म्‍याक् खरे़ःङ् के़गत्तुम्‍बे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “नुसि खरे़ःङ् नु चुजुक्‍सा कुभा ङारक् कत्तुम्‍बे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मनाहाॽ खाम्‍बाङ्‌ङो युङ्‌पाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","खे़न् नुसि खरे़ःङ्‌ङिन् नु ङाःन्‌खप्‍सुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरुर खे़ःक्‍खु, हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ पिरुसिआङ् मनाहाॽ मे़हाःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","हे़क्‍क्‍याङ् खे़न् के़रे़क् मनाहाॽरे़ खाघा मे़ज॥ हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽरे़ कुजि के़नम्‍बे़न् मे़सुप्‍सुल्‍ले़ नुसि नइमा योरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","खे़न् के़जाबाहाॽओग मे़न्‍छुमाहाॽ नु हिन्‍जाॽबित्‍छाहाॽ मे़न्‍निःत्‍छिङ्‌ङे ये़म्‍बित्‍छाॽहाॽरक् हे़न्‍छिङ् लिसि (४०००) यारिक् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ये़सुरे़ खे़न् मनाहाॽ पाङ्‌घुदेःसुसि, हे़क्‍क्‍याङ् खःङ्‌बेओ लाःसे़आङ् मगादान् पाङ्‌जुम् खिरिबा ते़न्‍नो पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","कुभा फरिसिहाॽ नु सदुकिहाॽ मे़द्‌ये़आङ् “साङ्‌ग्राम्‍पेदाङ्‌लाम् के़ये़बा फाॽआङ् निङ्‌वाॽ के़माबा मिक्‍सेःन्‍धिक्‌याप्‍मि ओसेःन्‍आधाक्‍ते़ॽ” मे़मे़त्तुर ये़सुरे़ कुनिङ्‌वाॽ मे़साॽरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","हे़क्‍केःल्‍ले़ ये़सुरे़ नोगप् पिरुसि, “युःन्‍छिक् ताङ्‌साक्‍पे़न्‌हे़ःत् लॽइल्‍ले़ ताःन्‍दिक् नाम्से़ःक् लॽरिक् के़बाःत्तुम्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","हे़क्‍क्‍याङ् तानाम् ताङ्‌साक्‍पे़न्‌मुदःप्‍पिल्‍ले़ आइन् वाहित् थाःसुॽ, सुरित् केजङ्‌ङिन् हुःॽ लॽरिक् के़बाःत्तुम्॥ अक्‍खेलॽरिक् ताङ्‌साक्‍पे़न्‌ओगे़मे़त्तुम्‍माङ् वाये़म्‍मिन् नुःबा नु ताप्‍फे़ःम्‍बा चोःक् फाॽआङ् के़से़न्‍दुम्‍मिल्‍ले़ आक्‍खेलॽरिक् कन् ये़म्‍मो के़दाःबा मिक्‍सेःन्‍हाॽ कुसिङ् के़न्‍निःत्तुम्‍मिन्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","कन्‌ये़म्‍मोबा कुइगे़भे़ॽबा नु लायोबा मनाहाॽरे़ निङ्‌वाॽ के़माबा मिक्‍सेःन्‍हाॽ ओमे़प्‍मा मे़गोःत्तुॽ, कर खे़ङ्‌हाॽरे़ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा योनारे़ कुमिक्‍सेःन्‍नाङ्‌धो वेॽ मिक्‍सेःन् थेआङ् मे़ङ्‌घोःसुन्‍लो॥” हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ पक्‍थसिआङ् खे़प्‍मोलाम् थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","याङ्‌सि हुॽसाम्‍बाहाॽ वरक्‍किल्‍ले़ नाधाःम्‍बि मे़गे़रे़ल्‍ले़ खे़ङ्‌हाॽरे़ खरे़ःङ् याङ्‌सिङ्‌मा निङ्‌वाॽ मे़भेःत्‍छुबान् निङ्‌वाॽ मे़घोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “फरिसिहाॽ नु सदुकिहाॽरे़ खुनिॽ खरे़ःङ् के़भङ्‌बा सिदाॽलाम् सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","खे़ङ्‌हाॽरे़ खरे़ःङ्‌ङिन् आम्‍भे़त्तुम्‍मिन्‍नाङ् आनिॽ अक्‍खे आमे़त्ते़बारो फाॽआङ् खुनिॽ लुम्‍मो पाःन् मे़धक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽनिङ्‌वाॽओबा पाःन्‍निन् कुसिङ्‌निःत्तुआङ् मे़त्तुसि, “नसाःन् के़सुःम्‍बासे, खिनिॽ लुम्‍मो खरे़ःङ् होःप्‌फाॽआङ् थेआङ् पाःन् के़धक्‍तिबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","खिनिॽ आल्‍लसाङ् कुसिङ् के़न्‍निःत्तुम्‍मिन्‍बि? हे़न्‍छिङ् ङासि (५०००) मनाहाॽरे़ ङासि खरे़ःङ् मे़जआङ् कुजि के़नम्‍बान्‌के़सुप्‍सुम्‍मिल्‍ले़ आक्‍खे़न् नइमा योरे़, खे़न् निङ्‌वाॽ के़भेःत्‍छुम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","याम्‍मो हे़न्‍छिङ् लिसि (४०००) मनाहाॽरे़ नुसि खरे़ःङ् मे़ज हे़क्‍क्‍याङ् आक्‍खे़म्‍म्‍याक् कुजि के़नम्‍बाहाॽ खिनिॽ के़सुप्‍सुम्, खे़न्‍नाङ् खिनिॽ निङ्‌वाॽ के़भेःत्‍छुम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","खरे़ःङ्‌ङिल्‍ले़ कुयाःम्‍बेओ इङ्‌गाॽ मे़त्‍निङ्‌बा मे़ःन् फाॽआङ् आल्‍लसाङ् कुसिङ्‌के़न्‍निःत्तुम्‍मिन्‍बि? कर फरिसिहाॽ नु सदुकिहाॽरे़ खुनिॽ खरे़ःङ् के़भङ्‌बा सिदाॽलाम् सिङ्‌सिङ् लॽरे़म्‍मे़ॽ फाॽआङ्‌ने़ हे़क्‍के मे़त्‍निङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","हे़क्‍क्‍याङ्‌लक् खे़ङ्‌हाॽरे़ खरे़ःङ् के़भङ्‌बा सिदाॽलाम् सिङ्‌सिङ् लॽरे़म्‍मे़ॽ मे़त्तुसिबा मे़ःन्, कर फरिसिहाॽ नु सदुकिहाॽरे़ खुनिॽ निसाम्‍मिल्‍ले़ कुदक्‍ले़ङ्‌वाओ पाःत्तुबा फाॽआङ् कुसिङ् मे़निःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ये़सुःन् सिजरिया फिलिप्‍पि थुम्‍मो त्‍ये़ःल्‍ले़ कुहुॽसाम्‍बाहाॽ सेःन्‍दोसुसि, “मनाहाॽरे़ मे़न्‍छाम्‍साःन् हाःत् फाॽआङ् मे़बाःत्तुॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “कुभारे़ बप्‍तिस्‍मा के़बिबा युहुन्‍ना, वेॽहाॽरे़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलिया, हे़क्‍क्‍याङ् आल्‍लसाङ् वेॽहाॽरे़ग यर्मिया मे़ःन्‍छाङ् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽओ लत्‍छाने़रो फाॽआङ् मे़बाःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “कर खिनिॽग, इङ्‌गाॽ हाःत्‍आ फाॽआङ् याप्‍मि के़मे़त्तिॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","सिमोन पत्रुसरे़ नोगप् पिरु, “खे़ने़ॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त, आजुनि निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुस्‍साःने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ये़सुरे़ खे़न् मे़त्तु, “योनारे़ कुस्‍साः सिमोने, खे़ने़ॽग मुॽइसाबाने़रो थेआङ्‌भे़ल्‍ले़ कङ्‌ग मे़न्‍छाम् याप्‍मिहाॽरे़ ओसेःन्‍दाङ् के़म्‍जोगे़बा मे़ःन्, कर साङ्‌ग्राम्‍पेदाङ्‌ङोबा पानुदिङ् आम्‍बारे़ खे़ने़ॽ ओसेःन्‍दाङ् के़जोगे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","से़क्‍खा पाःन् खे़ने़ॽ मे़त्‍ने़ॽ, खे़ने़ॽ पत्रुसने़रो (पत्रुस फाॽइन् लुङ्‌लो), हे़क्‍क्‍याङ् कन् पयम् यम्‍बा लुङ्‌सम्‍दाङ् इङ्‌गाॽ आसेसेहुप्‍लक्‍किन् चोगुङ्‌लो॥ हे़क्‍क्‍याङ् कन् आसेसेहुप्‍लक्‍किन् सिःमे़ल्‍ले़न् मुक्‍साम्‍मिल्‍ले़ नाःम्‍मा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","खे़ने़ॽग साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिल्‍ले़न्‌तिमिक्‍हाॽ पिने़रो॥ इक्‍सादिङ् खाम्‍बेःक्‍मो के़साक्‍तुबान्‌साङ्‌ग्राम्‍पेदाङ्‌ङोआङ् साक्‍लो, हे़क्‍क्‍याङ् इक्‍सादिङ् खाम्‍बेःक्‍मो के़हन्‍दुबान्‌साङ्‌ग्राम्‍पेदाङ्‌ङो हन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ इङ्‌गाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दाङ्‌बा ख्रिस्‍तआ फाॽआङ् आत्तिन्‍हाॽआङ् मे़जे़क्‍ते़म्‍सिम्‍मे़न्‍ने़ॽओ लॽरिक् के़साक्‍पा इङ्‌जाःङ् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","खे़न् ये़म्‍माङ्धो ये़सुरे़ कुहुॽसाम्‍बाहाॽ खुने़ॽ यरुसले़म्‍मो पेःक्‍माए पोःङ्, हे़क्‍क्‍याङ् खे़प्‍मो यहुदि तुम्‍लाम्‍लोःबाहाॽ, तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽओलाम् यरिक् पाःन्‍नो तुक्‍खे चामाए पोःङ् हे़क्‍क्‍याङ् खुने़ॽ सिःमाए पोःङ्‌ङाङ् याम्‍मो सुम् ये़न् एगाङ् सिःमे़न्‍लाम् याम्‍मो हिङ्‌मा पोःङ् के़लॽबा पाःन्‍निन् चे़क्‍मा हेःक्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","कर पत्रुसरे़ खुने़ॽ थिक्‍ले़प्‍माङ् तेॽरुआङ् फे़ःक्‍तु, “आदाङ्‌बे, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ अक्‍खे पोःङ्‌मा मे़बाङ्‌घुन्‍लो, अक्‍तङ्‌बा पाःङ्‌ग खे़ने़ॽनु आप्‍फाल्‍ले़आङ् मे़बोःङ्‌ने़ल्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ये़सुःन् पत्रुस ले़प्‍माङ् हिसिङ्‌ङाङ् मे़त्तु, “माफे़न्‍साम्‍मे, खे़ने़ॽ इङ्‌गाॽलाम् माःङ्‌घा पेगे़ॽ! खे़ने़ॽ के़घःआरो॥ खे़ने़ॽग निङ्‌वाॽफुमाङ् कुइसिःक् मे़ःन्, कर मे़न्‍छाम् याप्‍मि कुइसिःक्‍लक् निङ्‌वाॽ के़इःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “आत्तिल्‍ले़ इङ्‌गाॽ तिम्‍मा निङ्‌वाॽ चोगुॽ, हाराॽ खे़ल्‍ले़ इङ्‌गाॽरक् चाङ्‌थुङुङ् के़लॽबा कुनिङ्‌वाॽइन्‌से़रुआङ् कुसिलाम्‍साक्‍मा सिङ्‌ङिन् पक्‍खुआङ् इङ्‌गाॽ तिम्‍माररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","थेआङ्‌भे़ल्‍ले़ आत्तिल्‍ले़ कुहिङ्‌मन्‍निन् ताङ्‌से़ःप्‍तुङ् लॽरिक् निङ्‌वाॽ चोगुॽ, खे़ल्‍ले़ खे़न्‍नाङ् मासुॽ, कर आत्तिल्‍ले़ कुहिङ्‌मन्‍निन् आलागि मासुॽ, खे़ल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","मे़न्‍छाम् याप्‍मिःल्‍ले़ के़रे़क् इक्‍सादिङ् खाम्‍बेःक्‍मान् खुने़ॽइन् चोगुआङ् मे़न्‍नुप्‍मनाबा कुहिङ्‌मन्‍निन् मासुल्‍ले़ नुःबा पोःङ्‌बि? थेआङ्‌भे़ल्‍ले़ मे़न्‍छाम् याप्‍मिःल्‍ले़ मे़न्‍नुप्‍मनाबा कुहिङ्‌मन्‍निन् याङ्‌ना खोःमारे़ लागि थेःल्‍ले़आङ् ले़क्‍मा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ मे़न्‍छाम्‍साःन् पानुदिङ् आम्‍बारे़ कुमिमिदिङ्‌ङो कुमाङ्‌लाइङ्‌बाहाॽनु युःआल्‍ले़ के़रे़क् मे़न्‍छाम् याप्‍मिहाॽरे़ मे़जोगुबा याःम्‍बक्‍किल्‍ले़न् लाॽरुबा थुम्‍घोःन् पिरुङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, इङ्‌गाॽ मे़न्‍छाम्‍साःन् आहाङ्‌जुम्‍मो हाङ् चोःक्‍से़ युःआबा मे़न्‍निए थारिक् कप्‍मो के़ये़प्‍पाहाॽओ कुभाग मे़न्‍छिःने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","हे़क्‍के मे़त्तुसिबा तुक्‍सि (६) ये़न् एगाङ् ये़सुरे़ पत्रुस, याकुब नु कुन्‍साॽ युहुन्‍नाःन् खुने़ॽनु थो केःम्‍बा कोःक्‍माओ तेॽरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","खे़ङ्‌हाॽरे़ ओमे़मे़त्तुर मे़बत्‍छे़ल्‍ले़ए ये़सुरे़ कुनाइबेःक्‌ले़ङ्‌सिङ्‌ल पे, हे़क्‍क्‍याङ् कुनाराःन् नाम्‍मिन् कुइसिःक् ले़क्‍ते़ हे़क्‍क्‍याङ् कुदेःत्तिन्‍नाङ् मिक्‍किन् चे़मुर ओःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","हक्‍चघत् खे़प्‍मो माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा मोसाःन् नु एलियाःन्‍नाङ् थाःम्‍ने़त्‍छिआङ् ये़सुःन्‍नु ताॽजे़क्‍खे़त्‍छि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","पत्रुसरे़ ये़सुःन् मे़त्तु, “दाङ्‌बे, आनिॽ कप्‍मोए वाॽमा नुःबा पोःङ्‌लो॥ खे़ने़ॽ निङ्‌वाॽ के़जोगुने़ फाॽग्र सुम्‍सि याक्‍साहाॽ चोगुङ्, थिक् खे़ने़ॽइन् हे़क्‍क्‍याङ् मोसाःन् नु एलियारे़ खुन्‍छिॽ लागिआङ् थिक् थिक् चोगुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","अक्‍खेलॽरिक् खुने़ॽ पारे़र पत्‍छे़ल्‍ले़ए फः लॽरिक् के़ओःप्‍पा खाप्‍मिःत्तिल्‍ले़ चिदे़प् ते़प्‍तुसिआङ् खाप्‍मिःत्तोलाम् अक्‍तङ्‌बा इक्‍ला मे़घे़प्‍सु, “कन्‌आमिःम् आस्‍साःरो, खुने़ॽनु इङ्‌गाॽ सःत्ताङ्‌ङाङ् वाॽआरो॥ खुने़ॽ पाःत्तुबा पाःन्‍निन् खे़प्‍से़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","हुॽसाम्‍बाहाॽरे़ कन् मे़घे़प्‍सुल्‍ले़ साॽरिक् मे़गिसे़आङ् खाम्‍मो साम्‍बोःन् हबत्‌मे़भन्‍छिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","कर ये़सुःन् खे़प्‍मो त्‍ये़आङ् खे़ङ्‌हाॽ सुस्‍सुसिर मे़त्तुसि, “पोगे़म्‍मे़ॽ, मे़गिसे़म्‍मिन्‍ने़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ओमे़मे़त्तुल्‍ले़ खे़प्‍मो ये़सुःन्‍लक्‌वये़ कर वेॽ हाःत्ताङ् होःप्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","खे़ङ्‌हाॽ कोःक्‍मालाम् यो मे़ध्‍ये़र मे़बत्‍छे़ल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ इङ्‌जाःङ् पिरुसि, “इङ्‌गाॽ मे़न्‍छाम्‍साःन् सिःमे़न्‍लाम् याम्‍मो मे़न्‍हिङ्‌ङे थारिक् कन् के़निःसुम्‍बा पाःन्‍हाॽ आत्तिन्‍नाङ् मे़जे़क्‍ते़म्‍मिन्‍ने़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","खे़ङ्‌हाॽरे़ ये़सुःन् सेःन्‍मे़दोसु, “थेआङ् साम्‌योथिम्‍साम्‍बाहाॽरे़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌ताःमानुःल्‍ले़ तगि एलियाःङ्‌ग युःमाए पोःङ् फाॽआङ् मे़बाःत्तुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ये़सुरे़ नोगप् पिरुसि, “से़क्‍खाएरो, एलियाःङ्‌ग युःॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरे़ कुदाःमान् के़रे़क् यारिप् चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","कर इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, एलियाःन् त्‍ये़ चुरे़आङ् वाॽ, कर मनाहाॽरे़ कुसिङ् मे़न्‍निःत्तुन्‍नाङ् खे़ङ्‌हाॽरे़ खुने़ॽ निङ्‌वाॽ थाप्‍थाप् मे़मे़त्तुआङ् मे़वाॽरो॥ हे़क्‍केलॽरिक् मे़न्‍छाम्‍साःन्‍नाङ् खुनिॽ हुक्‍को थाआङ् तुक्‍खे चारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","हे़क्‍क्‍याङ्‌लक् ये़सुरे़ बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ कुयाःम्‍बेओ मे़त्तुसिबा फाॽआङ् हुॽसाम्‍बाहाॽरे़ कुसिङ्‌मे़निःत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","हे़क्‍क्‍याङ् ये़सुःन् नु कुहुॽसाम्‍बाहाॽ याम्‍मो यरिक् मनाहाॽ मे़वये़बा ते़न्‍नो मे़गे़रे़ल्‍ले़ खे़प्‍मो मनाधिक् ये़सुरो त्‍ये़आङ् कुदगि थुङ्‌बोहजॽ युङ्‌सिङ्‌ल ");
INSERT INTO lifNT2_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","पाःत्तु, “आदाङ्‌बे, आस्‍साःन् लुङ्‌माॽ तुक्‍ते़ॽओ॥ थेआङ्‌भे़ल्‍ले़ खे़न्‍निन् थप्‍मामःमे़ल्‍ले़ याङ्‌घुआङ् वाॽ हे़क्‍क्‍याङ् साॽरिक् तुक्‍खे चारो॥ ए़त्‍ले़ङ् खे़न् च्‍वाःत्तो नु मिओ थाःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","खे़न् के़हुॽसाम्‍बाहाॽरो मे़वेःन्‍दुर फाॽआङ् तारुङ्, कर खे़ङ्‌हाॽरे़ वेःम्‍मा मे़न्‍छुक्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ये़सुरे़ मे़त्तुसि, “नसाःन् के़होःप्‍पा नु ताक्‍के़भे़ॽबा मनासे, आप्‍फाल्‍ले़ थारिक् इङ्‌गाॽ खिनिॽनु वाॽआबाबे? आप्‍फाल्‍ले़ थारिक् नासि थःत्‍निङ्‌बाबे? खे़न् चुक्‍पे़न् कत्‍ना फे़त्ते़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ये़सुरे़ खे़न् फे़न्‍साम्‍मिन् फे़ःक्‍तुआङ् खे़न् चुक्‍पे़ल्‍लोलाम्‌लःन्‍दे़ पेरो॥ बा खे़न् ये़म्‍मोए खे़न् चुक्‍पे़न् वेःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","याङ्‌सि हुॽसाम्‍बाहाॽ स्‍वाःत्ताङ् ये़सुरो मे़द्‌ये़आङ् सेःन्‍मे़दोसु, “थेआङ्‌आनिगे़ खे़न् फे़न्‍साम्‍मिन् नाःप्‍मा लःप्‍मा मे़सुक्‍तुम्‍बे़न्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ये़सुरे़ मे़त्तुसि, “थेआङ्‌भे़ल्‍ले़ खिनिॽ नसाःन्‍निन् सुःन्‍लो॥ इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खिनिॽ नसाःन्‍निन् यःङ्‌गेॽ याॽरिःम्‍बाधिक् याःत्‍छाङ् कन् कोःक्‍मान् ‘खे़प्‍मोलाम् खे़त्‍छिङ्‌ङे़ॽ’ के़मे़त्तुम्‍मिल्‍ले़, खे़न् खे़त्‍छिङ् पेःक्‍लो॥ हे़क्‍क्‍याङ् खिनिॽलाम्‍बा पोःङ्‌मा मे़न्‍छुक्‍मना थेआङ् होःप्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","((कर अक्‍तङ्‌बा फे़न्‍साम्‍मिङ्‌ग तुवा नु चाःने़त् मे़ःन्‍ने लःप्‍मा सुक्‍मे़दे़त्‍ने़न्‍लो॥)) ");
INSERT INTO lifNT2_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","हे़क्‍क्‍याङ् ये़सुःन् नु कुहुॽसाम्‍बाहाॽ गालिल थुम्‍मो मे़द्‌ये़ल्‍ले़ खुने़ॽ अक्‍खे मे़त्तुसि, “आल्‍ल मे़न्‍छाम्‍साःन् इङ्‌मे़ले़क्‍तुॽआङ् मनाहाॽरो हुक् मे़सुप्‍तुॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुने़ॽ मे़से़रुॽ, कर सुम् ये़न् एगाङ् सिःमे़न्‍लाम् याम्‍मो कुहिङ्‌वे़त् पोःङ्‌लो॥” कन् पाःन्‍निन् मे़घे़प्‍सुआङ् कुहुॽसाम्‍बाहाॽरे़ खुनिॽ योःम् पुॽरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","याङ्‌सि ये़सुःन् नु कुहुॽसाम्‍बाहाॽ कपर्नहुम्‍मो मे़द्‌ये़, हे़क्‍क्‍याङ्‌माङ्‌हिम् एःङ्‌याङ् के़भोःङ्‌बाहाॽआङ्‌पत्रुसरो मे़द्‌ये़आङ् सेःन्‍मे़दोसु, “के़सिक्‍साम्‍बाल्‍ले़ माङ्‌हिम् एःङ्‌याङ् मे़हुङुन्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","खे़ल्‍ले़ नोगप् पिरु, “थेआङ् मे़हुङुन्‍बे? हुङुॽरो॥” हे़क्‍क्‍याङ् पत्रुसे़न् हिम्‍मो लाःसे़नामे़ःन्‍ने़ ये़सुरे़ सेःन्‍दोसु, “सिमोने, थे निङ्‌वाॽ के़इःत्तुबे? इक्‍सादिङ् खाम्‍बेःक्‍मोबा हाङ्‌हाॽरे़ एःङ्‌याङ् आत्तिल्‍लोलाम् मे़भोःक्‍खुबे? खुनिॽ आबाङे मनालाम्‍बा मे़भोःक्‍खुबि, इ वेॽ लाजेॽबा मनालाम् मे़भोःक्‍खुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","पत्रुसरे़ नोगप् पिरु, “वेॽ लाजेॽबा मनालाम् मे़भोःक्‍खुरो॥” ये़सुरे़ मे़त्तु, “हे़क्‍केने़ फाॽग्र खुनिॽ आबाङे मनाहाॽरे़ हुङ्‌मा मे़बोःङ्‌ने़ल्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","हे़क्‍केसाङ् आनिॽनु खे़ङ्‌हाॽरे़ खुनिॽ सिक् मे़बोःक्‍ने़न्‍ल फाॽआङ् गालिल वरक्‍को पेगे़ॽआङ् खेःङ् तेसे़ॽओ॥ के़रे़क्‍नुःल्‍ले़ तगि के़दे़म्‍सुबा ङाःल्‍ले़ कुमुराओ याङ्‌इत्‍छिधिक् के़घोःसुॽरो॥ खे़न् तेॽरे़ॽआङ् आन्‍छिॽ माङ्‌हिम् एःङ्‌याङ्‌ङिन् हुङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","खे़न् ये़म्‍मो हुॽसाम्‍बाहाॽ ये़सुरो मे़द्‌ये़आङ् सेःन्‍मे़दोसु, “दाङ्‌बे साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो के़रे़क्‍नुःल्‍ले़ यम्‍बान्‌हाःप्‍पे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ये़सुरे़ खे़प्‍मो हिन्‍जाॽधिक् उःत्तुआङ् खुनिॽ लुम्‍मो ये़प्‍सुर ");
INSERT INTO lifNT2_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खिनिॽ निङ्‌वाॽइन्‌के़ले़क्‍खुम्‍माङ् कन् हिन्‍जाॽइन् कुइसिःक् खिनिॽ के़म्‍बोःक्‍खिन्‍ने़ फाॽग्र आप्‍फाल्‍ले़आङ् साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो लाःप्‍मा के़न्‍छुक्‍तिन्‍लो, ");
INSERT INTO lifNT2_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","खे़ल्‍ले़ चोगुल्‍ले़ आत्तिन्‌आप्‍फेःक् चुङ्‌जिगे़न् नःम्‍सिङ्‌ङाङ् कन् हिन्‍जाॽइन् हे़क्‍के पोःङ् खे़न्‍ने साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो यम्‍बा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","हे़क्‍क्‍याङ् आत्तिल्‍ले़ आमिङ्‌ङो अक्‍तङ्‌बा चुक्‍सा हिन्‍जाॽइन् लाङ्‌दाःक्‍तुॽ, खे़ल्‍ले़ इङ्‌गाॽ लाङ्‌दाःक्‍कारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","कर आत्तिल्‍ले़ इङ्‌गाॽ याप्‍मि नसाःन् के़जोःक्‍पा चुक्‍सा हिन्‍जाॽथिक् लायो चोःक्‍मा पाङ्‌घुॽ, खे़ल्‍ले़ कुनिःङ्‌मो लुम्‍सुम्‍मिन् इघेःङ्‌माआङ् वरक्‍को लाप्‍फुमाल्‍ले़ए नुःबा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","कन् इक्‍सादिङ् खाम्‍बेःक्‍मान् चिःत्ते़आङ्‌लक् स्‍ये़रो, थेआङ्‌भे़ल्‍ले़ मे़न्‍छाम् याप्‍मिहाॽ लायो चोःक्‍मा के़बाङ्‌बा पाःन्‍हाॽ कप्‍मो यरिक् वाॽरो॥ अक्‍तङ्‌बा पाःन्‍हाॽग ताःएरो, कर वेॽहाॽ लायोओ के़धाःबा मनाःङ्‌ग चिःत्ते़आङ्‌लक् स्‍ये़रो! ");
INSERT INTO lifNT2_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","खे़ने़ॽ के़लाङ् के़हुक्‍किल्‍ले़ लायो चोःक्‍मा के़बाङ्‌ने़ फाॽग्र खक्‍ते़ॽआङ् लाप्‍फुसे़ॽ॥ लाङ्-हुक् ने़प्‍माङ्‌नु आप्‍फाल्‍ले़आङ् मे़न्‍छिःमना मि के़दिःप्‍पा खे़मायङ्‌सङ्‌ङो पेःक्‍मानुःल्‍ले़ लाङ्धिक्‌नु हुक्‍थिक् मे़ःन्‍ने मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःमाए नुःबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","खे़ने़ॽ के़मिक्‍किल्‍ले़ लायो चोःक्‍मा के़बाङ्‌ने़ फाॽग्र यगे़लःत्ते़ॽआङ् लाप्‍फुसे़ॽओ॥ ने़त्‍छि मिक्‍नु आप्‍फाल्‍ले़आङ् मे़न्‍छिःमना खे़मायङ्‌सङ्‌बा मिओ पेःक्‍मानुःल्‍ले़ मिक्‍थिक्‍नु मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःमाए नुःबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ, कन् चुक्‍पा चुक्‍पाहाॽ कुनामे़न्‍छाॽ मे़जोगे़म्‍सिम्‍मिन्‍ने़ॽओ॥ इङ्‌गाॽ से़क्‍खा पाःन् मे़त्‍निङ्, कङ्‌हाॽ कम्‍ब्राङ् के़मे़प्‍पा खुनिॽ माङ्‌लाइङ्‌बाहाॽ सदादिङ् साङ्‌ग्राम्‍पेदाङ्‌ङो पानुदिङ् आम्‍बारे़ कुदगि मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","((थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ मे़न्‍छाम्‍साःङ्‌ग के़माबाहाॽ ताङ्‌से़ःप्‍से़ त्‍याङ्‌बारो॥))” ");
INSERT INTO lifNT2_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“आल्‍ल, किप्‍थिक् (१००) मे़ल्‍लुक् के़गप्‍पाल्‍ले़ कुमे़ल्‍लुक्‍थिक् माःल्‍ले़ थे चोगुॽ? खे़ल्‍ले़ खे़न् फाङ्‌-फाङ् (९९) मे़ल्‍लुक्‍हाॽ चाराम्‍मादे़न्‍नो ले़रुधसिआङ् खे़न् के़माबा मे़ल्‍लुक्‍किल्‍ले़ कुगोःत्‍छे़ मे़बेःक्‍किन्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","खे़ल्‍ले़ खे़न् के़माबा मे़ल्‍लुक्‍किन् खोःसुल्‍ले़ से़क्‍खाए खे़न् मे़म्‍माए फाङ्‌-फाङ् (९९) मे़ल्‍लुक्‍हाॽ कत्तुसिबानुःल्‍ले़आङ् साॽरिक् सःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","हे़क्‍केलॽरिक्‍के साङ्‌ग्राम्‍पेदाङ्‌ङो के़वाॽबा खिनिॽ पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़आङ् कन् चुक्‍पाहाॽओ थिक्‍काङ् मे़माःने़न्‍ल के़लॽबा कुनिङ्‌वाॽ वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","नसानिबाधिक्‍ले़ खे़ने़ॽ के़दक्‍ले़ङ्‌वाओ लायो चोगुॽने़ फाॽग्र खे़ने़ॽरक् खे़ल्‍लो पेगे़ॽआङ् कुलायोःन् ओसेःन्‍धाक्‍ते़ॽओ॥ खे़ल्‍ले़ के़बाःन्‍निन् खे़प्‍सुने़ फाॽग्र खे़न् नसानिबाल्‍ले़ कुनिङ्‌वाॽ के़दोःन्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","कर खे़ने़ॽ के़बाःन्‍निन् मे़घे़प्‍सुन्‍ने़ फाॽग्र खे़ने़ॽनु वेॽ थिक्‍पा इग्र ने़प्‍फु तेॽरे़से़ॽआङ् याम्‍मो पेगे़ॽ, थेआङ्‌भे़ल्‍ले़ साम्‌योसाप्‍लाःल्‍ले़ पाःत्तुबा कुइसिःक्, ‘ने़प्‍फु इग्र सुम्‍सि तोःन्‍दिहाॽरे़ खुनिॽ तगि के़रे़क् पाःन्‍हाॽरे़न् निःन्‍धो चोःक्‍मा पोःङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","खे़ल्‍ले़ आल्‍लसाङ् खे़ङ्‌हाॽ खे़म्‍मा नाॽरुसिने़ फाॽग्र सेसेहुप्‍लक्‍को कन् पाःन्‍निन् तारे़म्‍मे़ॽओ॥ हे़क्‍क्‍याङ् सेसेहुप्‍लक्‍किल्‍ले़ पाःत्तुबा पाःन्‍निन्‍नाङ् नाॽरुने़ फाॽग्र खे़ङ्‌ग थिम्‍मे़न्‍दङ् सुवाङ् नु एःङ्‌याङ् के़भोःङ्‌बा ताप्‍फे़ःम्‍बा मना कुइसिःक् इःत्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, इक्‍सादिङ् खाम्‍बेःक्‍मो के़साक्‍तुबान्‌साङ्‌ग्राम्‍पेदाङ्‌ङोआङ् साक्‍लो, हे़क्‍केलॽरिक्‍के इक्‍सादिङ् खाम्‍बेःक्‍मो के़हन्‍दुबान्‌साङ्‌ग्राम्‍पेदाङ्‌ङो हन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","याम्‍मो इङ्‌गाॽ अक्‍खेआङ् मे़त्‍निङ्, खिनिॽओ ने़प्‍फु मनाहाॽ निङ्‌वाॽबो थिक्‍हुप् के़बोःङ्‌सिने़ फाॽग्र थे के़नाःक्‍सुसाङ् साङ्‌ग्राम्‍पेदाङ्‌ङोबा पानुदिङ् आम्‍बारे़ खे़न् के़जोःक्‍सि के़बिसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","थेआङ्‌भे़ल्‍ले़ ने़प्‍फु इग्र सुम्‍भु मनाहाॽ इङ्‌गाॽ आमिङ्‌ङो मे़जुम्‍मिल्‍ले़, इङ्‌गाॽ खुनिॽ लुम्‍मो वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","हे़क्‍क्‍याङ् पत्रुसे़न् ये़सुरो फे़रे़आङ् सेःन्‍दोसु, “आदाङ्‌बे, इङ्‌गाॽ आदक्‍ले़ङ्‌ङो लायो के़जोःक्‍पार के़ने़बान् आक्‍खे़न्‍ले़ङ् ले़प्‍मि पिरुङ्‌बाबे? नुसि ले़ङ् थारिक्‍पि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ये़सुरे़ नोगप् पिरु, “नुसि (७) ले़ङ्‌रक् मे़ःन्, कर नुसिआङ्‌नुबोःङ्‌ले़ङ् (७०) थारिक् ले़प्‍मि के़बिरुर पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","थेआङ्‌भे़ल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग लत्‍छा हाङ्‌धिक्‍ले़ कुसेवारोबाहाॽरे़ मे़देॽरुबा साम्‍म्‍याङ्-याङ्‌इत्‍छिःन्‌फोःङ्‌मा याःम्‍बक् चोगुबान्‍नु तङ्‌मा सुक्‍ते़त्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","खे़न् हाङ्‌ङिल्‍ले़ सिङ्‌नाःत्तिन् फोःङ्‌मा हेःक्‍तुल्‍ले़ थिबोःङ् हे़न्‍छिङ् (१०,०००) साम्‍म्‍याङ् याङ्‌इत्‍छि सिङ्‌नाःत् फोःङ्‌मा के़बोःङ्‌बा मनाःन् खुने़ॽओ मे़दारु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","खे़ल्‍ले़ खे़न् साम्‍म्‍याङ् याङ्‌इत्‍छिःन्‌हुङ्‌मा मे़सुक्‍तुम्‍बाल्‍ले़ चोगुल्‍ले़ मेलिङ्‌गे़न् कुमेःत्, कुस्‍साःहाॽ हे़क्‍क्‍याङ् खे़ल्‍ले़ कत्तुबा के़रे़क् चिगःक्‌वाहाॽ सङ्‌घे़म्‍मे़ॽआङ् फोःङ्‌मा के़बोःङ्‌बा याङ्‌ङिन् फोःक्‍खे़म्‍मे़ॽ लॽरिक् हाङ्‌ङिल्‍ले़ इङ्‌जाःङ् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","कर खे़न् सेवारोबान् हाङ्‌ङिल्‍ले़ कुदगि थुङ्‌बोहजॽ युङ्‌सिङ्‌ङाङ् पेलि फाक्‍तु, ‘आदाङ्‌बे, इङ्‌गाॽ नासि थःत्ताङ्‌ङे़ॽआङ्‌कुभा ये़म् थारिक् हाङ्‌घाङ्‌ङे़ॽओ! इङ्‌गाॽ के़याङ्‌ङिन् के़रे़क् हुङुङ् पिने़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","हाङ्‌ङिल्‍ले़ खे़न् लुङ्‌माॽ तुक्‍तुआङ् के़रे़क् हुङ्‌मा के़बोःङ्‌बा याङ्‌ङिन् ले़प्‍मि पिरुआङ् पाङ्‌घुदेःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","हे़क्‍क्‍याङ् खे़न् सेवारोबान् लाःक्‍कात् लःन्‍दे़ल्‍ले़ किप्‍थिक् युप्‍पा याङ्‌इत्‍छि कुसिङ्‌नाःत् के़बप्‍पा कुन्‍जुम् सेवारोबान् तुमु॥ हे़क्‍क्‍याङ् खे़ल्‍ले़ खे़न् कुन्‍जुम् सेवारोबान् फत्तुर कुसित्‍लाःन् यॽरुआङ् अक्‍खे मे़त्तु, ‘इङ्‌गाॽओनु के़देॽरुबा सिङ्‌नाःत्तिन् आल्‍लोसा हुङे़ॽ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","खे़ल्‍ले़ थुङ्‌बोहजॽ युङ्‌सिङ्‌ङाङ् पेलि फाक्‍तुर मे़त्तु, ‘चुम्‍मे, इङ्‌गाॽ नासि थःत्ताङ्‌ङे़ॽआङ्‌कुभा ये़म् थारिक् हाङ्‌घाङ्‌ङे़ॽओ! इङ्‌गाॽ के़याङ्‌ङिन् के़रे़क् हुङुङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","कर खे़ल्‍ले़ मे़दे़न्‍दे़न्‍नाङ् खे़न् हुङ्‌मा के़बोःङ्‌बा याङ्‌ङिन् मे़न्‍हुङ्‌ङे थारिक् पुङ्‌लाहिम्‍मो याक्‍ल फाॽआङ् साक्‍मा पाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","वेॽ सेवारोबाहाॽरे़ कन् पाःन्‍निन् मे़निःसुआङ् खुनिॽ साॽरिक् निङ्‌वाॽ तुगे़॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़बेआङ् कन् के़रे़क् पाःन्‍हाॽ हाङ्‌ङिन् मे़जे़क्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","हाङ्‌ङिल्‍ले़आङ् खे़न् तगिस्‍मा सेवारोबान् उःत्तुआङ् मे़त्तु, ‘खे़ने़ॽग ताक्‍के़भे़ॽबा सेवारोबाने़रो! खे़ने़ॽ पेलि के़भाक्‍ताङ्‌बाल्‍ले़ के़रे़क् के़सिङ्‌नाःत्तिन् ले़प्‍मि पिने़आङ् वयाङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","कर खे़ने़ॽ लुङ्‌माॽ तुक्‍ने़बा कुइसिःक्‍के खे़ने़ॽआङ् के़न्‍जुम् सेवारोबान् लुङ्‌माॽ तुक्‍मा मे़बोःङ्‌ने़म्‍बि?’ ");
INSERT INTO lifNT2_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","हे़क्‍क्‍याङ् हाङ्‌ङिल्‍ले़ साॽरिक् कुसिक्‍किन् पोगे़आङ् खे़न् सेवारोबे़न् सिङ्‌नाःत्तिन् मे़न्‍हुङ्‌ङे थारिक् तुक्‍खे मे़जाःत्तुर फाॽआङ् पुङ्‌लाधाबाल्‍लो हुक् सुप्‍तुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ये़सुरे़ कुनुप्‍मो कुहुॽसाम्‍बाहाॽ अक्‍खेलॽरिक् मे़त्तुसि, “खिनिॽ तक्‍ले़ङ्‌वाओ लायो के़जोःक्‍पाहाॽ सिक्‍लुङ्‌मोनुए ले़प्‍मि के़म्‍बिरुम्‍सिम्‍मिन्‍ने़ फाॽग्र साङ्‌ग्राम्‍पेदाङ्‌ङोबा आम्‍बारे़आङ् बा हे़क्‍केए के़मे़त्तिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ये़सुरे़ कन् पाःन्‍हाॽ पाःत्तु सुरुआङ् गालिल थुम्‍मोलाम् यर्दन यङ्‌घङ्‌ङिल्‍ले़ नाधाःम्‍बिबा यहुदिया थुम्‍मो पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","यरिक् मनाहाॽरे़ खुने़ॽ मे़दिम्‍दु, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ वेःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","कुभा फरिसिहाॽ मे़द्‌ये़आङ् खुने़ॽ कुनिङ्‌वाॽ साॽमा फाॽआङ् पाःन् मे़गे़सु, “थेआङ् याःम्‍बक् मे़म्‍भेःन्‍ने मनाःल्‍ले़ कुमेःत्तिन् नाॽमा साम्‌योथिम्‍मिल्‍ले़ पिरुबि मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ये़सुरे़ मे़त्तुसि, “मे़ःम्‍बे़! साम्‌योसाप्‍लाओ के़बप्‍पा पाःन्‍निन् खिनिॽ मे़न्‍निःत्ते के़वयिॽबि? चइःत्‍दाङ्‌बाल्‍ले़ कुहेःक्‍सिङ्‌मोए ‘खे़ङ्‌हाॽ ये़म्‍बित्‍छाॽ नु मे़न्‍छुमाॽ चोगुसिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","हे़क्‍क्‍याङ् ‘खे़ल्‍ले़ चोगुल्‍ले़ ये़म्‍बित्‍छाॽइल्‍ले़ कुम्‍बा नु कुम्‍मासि ले़रुसिआङ् कुमेःत्तिन्‍नु तङ्‌लो, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ लत्‍छा थक् पोःङ्‌सिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","आल्‍ल खे़ङ्‌हाॽग ने़प्‍फुसि मे़ःन्, कर लत्‍छा थक्‍सिरो॥ खे़ल्‍ले़ चोगुल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ लत्‍छा थक् चोगुसिबाहाॽ मे़न्‍छाम् याप्‍मिरे़ से़म्‍मासि मे़नुॽने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","खे़ङ्‌हाॽरे़ सेःन्‍मे़दोसु, “हे़क्‍केने़ फाॽग्र थेआङ् मोसाःल्‍ले़ ‘ये़म्‍बित्‍छाॽइल्‍ले़ कुमेःत्तिन् इङ्‌गाॽ नाॽने़बारो फाॽआङ् साप्‍ला साप्‍तुआङ् पाङ्‌मादेःमा सुक्‍तुॽ’ लॽरिक् साप्‍तुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ये़सुरे़ नोगप् पिरुसि, “खिनिॽ पाःन् मे़ङ्‌घे़म्‍मनाबा के़जोगिबाल्‍ले़ चोगुल्‍ले़ मोसारे़ खिनिॽ मेःत्‍हाॽ नाॽमा के़सुक्‍तुम्‍सिम् फाॽआङ् साप्‍तुबारो॥ कर कुहेःक्‍सिङ्‌मोग अक्‍तङ्‌बा होःप्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","इङ्‌गाॽ मे़त्‍निङ्, आत्तिन् ये़म्‍बित्‍छाॽइल्‍ले़ कुमेःत्तिन् वेॽहाॽनु मे़न्‍लाम्‍मे नाॽरुआङ् वेॽ मे़न्‍छुमाॽइन्‍नु मेःक्‍खिम् चोगु, खे़ल्‍ले़आङ् चाराम्‍मा याःम्‍बक्‍के चोगुॽरो॥” ((हे़क्‍क्‍याङ् आत्तिल्‍ले़ खे़न् नाॽरुमा मे़न्‍छुमाॽइन्‍नु मेःक्‍खिम् चोगुॽ खे़ल्‍ले़आङ् याम्‍बोःप्‍मा याःम्‍बक्‍के चोगुॽरो॥)) ");
INSERT INTO lifNT2_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","हे़क्‍केःल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ मे़मे़त्तु, “मेःत् ये़म्‍बाॽ लुम्‍मो बा हे़क्‍केरक् पोःङ्‌ने़ फाॽग्र मेःक्‍खिम् मे़न्‍जोःक्‍माए नुःबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ये़सुरे़ नोगप् पिरुसि, “के़रे़क्‍ले़ग कन् पाःन्‍हाॽ ताःक्‍मा मे़न्‍छुक्‍तुन्, कर आत्तिल्‍ले़ निङ्‌वाॽफुमाङ्‌लाम् खोःसुॽ, खे़ल्‍ले़रक् ताःक्‍मा सुक्‍तुॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","मेःक्‍खिम् मे़न्‍जोःक्‍मना यरिक् पन्‌ये़म्‍हाॽ वाॽरो॥ कुभाग सावाःन्‍छिङ्‌मानुधोए सिङ्‌गारु मे़वाॽरो, वेॽहाॽ मनाहाॽरे़ सिङ्‌गारु मे़जोगुसि, हे़क्‍क्‍याङ् कुभाग साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो माङ्‌सेवा याःम्‍बक् चोःक्‍मा फाॽआङ् मेःक्‍खिम् मे़न्‍जोःक्‍ने़न्‍लो॥ आत्तिल्‍ले़ ताःक्‍मा सुक्‍तुॽ हाराॽ खे़ल्‍ले़ए ताःक्‍तुर॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","थिक् ये़न् ये़सुरे़ हुक् ने़स्‍सुआङ् तुवा चोगु पिरुसिर फाॽआङ् मनाहाॽरे़ हिन्‍जाॽबित्‍छाहाॽ मे़दारुसि॥ कर कुहुॽसाम्‍बाहाॽरे़ खे़न् हिन्‍जाॽबित्‍छा के़दाःप्‍पाहाॽ मे़भे़ःक्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “हिन्‍जाॽबित्‍छाहाॽ इङ्‌गाॽओ ताःमा फाःक्‍ते़म्‍सिम्‍मे़ॽओ, खे़ङ्‌हाॽ मे़साक्‍ते़म्‍सिम्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग कन् हिन्‍जाॽबित्‍छा हे़क्‍तङ्‌बाहाॽरे़न्‍नेरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ सम्‍दाङ् हुक् ने़स्‍सुर मुॽइसाम् पिरुसिआङ् खे़प्‍मोलाम् थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","आल्‍ल मनाधिक् ये़सुरो फे़रे़आङ् सेःन्‍दोसु, “सिक्‍साम्‍बे, आक्‍तङ्‌बा नुःबा याःम्‍बक् चोगुङ्‌ङिल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुङ्‌बे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ये़सुरे़ नोगप् पिरु, “नुःबा याःम्‍बक्‍किल्‍ले़ कुयाःम्‍बेओ थेआङ् सेःन्‍गे़दोआबाबे? के़नुॽबाग निङ्‌वाॽफुमाङ्‌ङिन्‍लक् वाॽरो॥ कर खे़ने़ॽ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःमा निङ्‌वाॽ के़जोगुने़ फाॽग्र साम्‌योथिम् इङ्‌जाःङ्‌हाॽ इःत्ते़ नाःत्ते़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","खे़न् मनाःल्‍ले़ सेःन्‍दोसु, “आत्तिन् साम्‌योइङ्‌जाःङ्‌ङिन्‌इःत्तुङ् नाःत्तुङ्‌बाबे?” हे़क्‍क्‍याङ् ये़सुरे़ मे़त्तु, “मना से़प्‍मा मे़नुॽने़न्, चाराम्‍मा याःम्‍बक् चोःक्‍मा मे़नुॽने़न्, खुःम्‍मा मे़नुॽने़न्, इङ्‌ले़क् पाःप्‍मा मे़नुॽने़न्, ");
INSERT INTO lifNT2_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","के़म्‍बा के़म्‍मासि इङ्‌धाःङ् पिरे़से़ॽ॥ हे़क्‍क्‍याङ् आप्‍फेःक् लुङ्‌माॽ के़दुक्‍सिङ्‌बा कुइसिःक्‍के के़बाङ्‌भेॽसाबाहाॽआङ्‌लुङ्‌माॽ तुक्‍ते़से़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","खे़न् थाङ्‌बे़न्‍निल्‍ले़ मे़त्तु, “कन्‍हाॽ के़रे़क् इःत्तुङ्-नाःत्तुङ्‌ङाङ्‌ङे वाॽआरो॥ आल्‍लसाङ् याम्‍मो थे चोःक्‍माओ सुःन्‍दाङ्‌बे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ये़सुरे़ मे़त्तु, “खे़ने़ॽ से़क्‍खाए कुलिङ्‌धो के़प्‍मा निङ्‌वाॽ के़जोगुने़ फाॽग्र पेगे़ॽआङ् के़गत्तुबान्‌के़रे़क् सङ्‌घे़देःसे़ॽ हे़क्‍क्‍याङ् याङ्‌गे़साॽबाहाॽ पिरे़से़ॽओ॥ हे़क्‍केलॽरिक् साङ्‌ग्राम्‍पेदाङ्‌ङो याङ्‌साकुन्‍धे के़घोःसुॽरो॥ हे़क्‍क्‍याङ् फे़रे़ॽआङ् इङ्‌गाॽ तिम्‍दाङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","खे़न् थाङ्‌बे़न्‍निल्‍ले़ कन् पाःन्‍निन् खे़प्‍सुआङ् कुनिङ्‌वाॽ तुगे़र खे़प्‍मोलाम् पेरो, थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ग यरिक् याङ्‌साकुन्‍धे कत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, याङ्‌साकुन्‍धेसाबाहाॽ साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मो लाःप्‍मा साॽरिक् साक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","याम्‍मोआङ् खिनिॽ मे़त्‍निङ्, याङ्‌साकुन्‍धेसाबे़न् निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःप्‍मानुःल्‍ले़ उमेःन् सम्‍मेःत्तिल्‍ले़ कुहङ्‌ङो लाःप्‍मा उसुरु पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","हे़क्‍क्‍याङ् हुॽसाम्‍बाहाॽरे़ कन् मे़घे़प्‍सुआङ् साॽरिक् खुनिॽ निङ्‌वाॽ मये़र सेःन्‍मे़दोसु, “हे़क्‍केःल्‍ले़ हाःत् ताङ्‌से़ःप्‍मा सुक्‍पाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ये़सुरे़ खे़ङ्‌हाॽ ओमे़त्तुसिर मे़त्तुसि, “मे़न्‍छाम् याप्‍मिरे़ लागि कन् पोःङ्‌मा मे़न्‍छुक्‍मनाबा चोःक्‍साङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़रे़क् पाःन्‍हाॽ चोःक्‍मा सुक्‍तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","पत्रुसरे़ नोगप् पिरु, “दाङ्‌बे, आनिगे़ग के़रे़क् पाःन्‍हाॽ ले़रुम्‍बे़, हे़क्‍क्‍याङ् खे़ने़ॽ तिम्‍मासिगे़आङ् वयिगे़रो॥ आनिगे़ग थे खोःसुम्‍बे़बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, इङ्‌गाॽ मे़न्‍छाम्‍साःन् के़दाःबा कुसङ् हाङ्‌जुम्‍मो मिमिदिङ्‌गे़न् हाङ्‌युक्‍नाओ युङ्‌ङारो॥ खे़न् ये़म्‍मो खिनिॽ इङ्‌गाॽ याप्‍मि के़दिम्‍बाहाॽआङ् थिक्-ने़त् (१२) हाङ्‌युक्‍नाओ के़युङिआङ् इस्राइलबा थिक्-ने़त् सुवाङ्‌हाॽ सम्‍दाङ् हाङ् के़जोगिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","आत्तिल्‍ले़ आलागि हिम्‍धाःङ्‌हाॽ, प्‍याङ्‌सिगे़न् इक्‍ताप्‍हाॽ, ने़ॽनुसाॽहाॽ, फुॽनुसाॽहाॽ, पाः माहाॽ, इग्र हिन्‍जाॽबित्‍छाहाॽ ले़रुसिआङ् वाॽ, खे़ल्‍ले़ग किप्‍थिक् (१००) ले़ङ्‌नुःल्‍ले़आङ्‌यरिक् खोःसुॽ, हे़क्‍क्‍याङ् मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","कर आल्‍लो तगि के़वाॽबा यरिक् मनाहाॽ एगाङ् मे़बोःङ्‌लो, हे़क्‍क्‍याङ् आल्‍लो एगाङ् के़वाॽबा यरिक् मनाहाॽ तगाङ् मे़बोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग अक्‍तङ्‌बा चोःक्–लत्‍छा चे़ल्‍ले़क्‍सेॽ इक्‍ताप्‍दाङ्‌बान् थिक् तानाम्‍सा कुइक्‍ताप्‍पो याःम्‍बक् के़जोःक्‍पा याःलिक्‌साङ्‌से़ॽ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","खे़ल्‍ले़ मनाहाॽ थिक्‌ये़न्‍बा नाम्‌याक्‍किङ्‌ग युप्‍पायाङ्‌धिक् पिमा पाःन् तङ्‌घुआङ् कुइक्‍ताप्‍पो याःम्‍बक् चोःक् पाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","तानाम्‍बा कुमुक् फाङ्‌सि (९) मुक्‍ते़र पत्‍छे़ल्‍ले़ खुने़ॽ पाङ्‌जुम्‍मो पेःल्‍ले़ कुभा मनाहाॽ पाङ्‌जुम्‍हाःत्ति थेआङ् मे़न्‍जोःक्‍के मे़वये़बा निःसुसिआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","मे़त्तुसि, ‘खिनिॽआङ् पेगे़म्‍मे़ॽआङ् आजे़ल्‍ले़क्‍सेॽ इक्‍को याःम्‍बक् चोगे़म्‍मे़ॽओ॥ खिनिॽ खोःमा के़याॽरिबा याङ्‌ङिन् पिनिङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","हे़क्‍केलॽरिक् खे़ङ्‌हाॽ याःम्‍बक् चोःक्‍से़ मे़बे॥ खुने़ॽ ले़न्‍दिक् कुमुक् थिक्-ने़त् (१२) हे़क्‍क्‍याङ् याम्‍मो कुमुक् सुम्‍सि (३) मुक्‍ते़र पत्‍छे़ल्‍ले़ लाःक्‍कात् पेःल्‍ले़ मनाहाॽ तुमुसिआङ् बा हे़क्‍केए मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","याङ्‌सि कुमुक् ङासि (५) मुक्‍ते़र पत्‍छे़ल्‍ले़ खुने़ॽ पाङ्‌जुम्‍मो पेःल्‍ले़ मनाहाॽ थेआङ् मे़न्‍जोःक्‍के मे़वये़ मे़गत्ते़बा याम्‍मो निःसुसिआङ् सेःन्‍दोसुसि, ‘आइन् थेआङ् खिनिॽ नाम्‍धाधा याःम्‍बक् के़न्‍जोगिन्‍बाबे?’ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, ‘थेःन् चोःक्‍माबे, आनिगे़ आत्तिल्‍ले़आङ् याःलिक् याप्‍मि मे़साङिगे़न्‍लो॥’ खे़ल्‍ले़ खे़ङ्‌हाॽ मे़त्तुसि, ‘हे़क्‍केने़ फाॽग्र खिनिॽआङ् पेगे़म्‍मे़ॽआङ् आजे़ल्‍ले़क्‍सेॽ इक्‍को याःम्‍बक् चोगे़म्‍मे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","हे़क्‍क्‍याङ् युःन्‍छिक् पोःक्‍खे़ल्‍ले़ खे़न् चे़ल्‍ले़क्‍सेॽ इक्‍दाङ्‌बाल्‍ले़ खे़न् याःलिक् के़भम्‍बान् उःत्तुआङ् मे़त्तु, ‘के़रे़क्‌याःलिक्‍हाॽ उःत्ते़से़ॽआङ् के़रे़क्‍नुःल्‍ले़ एगाङ् याःम्‍बक्‍को के़भन्‍छिङ्‌बाहाॽओलाम् के़रे़क्‍नुःल्‍ले़ तगि याःम्‍बक्‍को के़भन्‍छिङ्‌बाहाॽरे़ खुनिॽ नाम्‌याक्‍किन् हाःत्ते़से़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","हे़क्‍क्‍याङ् खे़न् याःलिक् के़भम्‍बाल्‍ले़ कुमुक् ङासि मुक्‍ते़ल्‍ले़ याःम्‍बक्‍को के़भन्‍छिङ्‌बा याःलिक्‍हाॽ उःत्तुसिआङ् युप्‍पायाङ् थिक् थिक् के़रे़क् नाम्‌याक् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","हे़क्‍केलॽरिक् के़रे़क्‍नुःल्‍ले़ तगि याःम्‍बक्‍को के़भन्‍छिङ्‌बाहाॽरे़ग खे़न् मे़निःसुआङ् आनिगे़ यरिक् खोःसुम्‍बाबिला लॽरिक् मे़इःत्तु, कर खे़ङ्‌हाॽरे़आङ् युप्‍पायाङ् थिक्‍लक् मे़घोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ खुनिॽ नाम्‌याक् मे़दाःक्‍तुआङ् चे़ल्‍ले़क्‍सेॽ दाङ्‌बान्‍नु लुङ्‌हाःप्‍मा मे़हेःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","खे़न् मनाहाॽरे़ खुने़ॽ मे़मे़त्तु, ‘कन् एगाङ् के़साङुसिबाहाॽरे़ग कुमुक् थिक्‍लक् याःम्‍बक् मे़जोगु॥ आनिगे़ ले़न्‍दिक् खाराक् नाम्‍से़ःक्‍माओ याःम्‍बक् चोगुम्‍बे़साङ् खे़ङ्‌हाॽनु कुदङ्‌बा याप्‍मि के़जोगे़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","कर खे़न् मनाःल्‍ले़ खे़ङ्‌हाॽओ थिक्‍किन् नोगप् पिरु, ‘लाजे, इङ्‌गाॽ खे़ने़ॽ निङ्‌घुम् मे़म्‍मे़त्ते वाॽआरो॥ खे़ने़ॽ युप्‍पायाङ्‌धिक्‍को याःम्‍बक् चोःक्‍मा के़दे़न्‍दे़बाबि मे़ःम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","के़नाम्‌याक्‍किन् ताःक्‍ते़ॽआङ् पेगे़ॽओ॥ इङ्‌गाॽग एगाङ् साङ्‌मनाबान्‍नाङ् खे़ने़ॽ पिने़बा यारिक्‍के पिमा निङ्‌वाॽ चोगुङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","इङ्‌गाॽ आनिङ्‌वाॽ हे़क्‍के मनाहाॽ आयाङ्‌ङिन् पिमासि युक् मे़गत्तान्बि? इङ्‌गाॽ आनिङ्‌वाॽ यम्‍बा चोगुङ्‌ङिल्‍ले़ थेआङ् के़सिक् पोःक्‍पाबे?’ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","अक्‍खेलॽरिक् आल्‍लो तगि के़वाॽबाहाॽ एगाङ् मे़बोःङ्‌लो, हे़क्‍क्‍याङ् आल्‍लो एगाङ् के़वाॽबाहाॽ तगाङ् मे़बोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","आल्‍ल ये़सुःन् यरुसले़म थो पेर पत्‍छे़ल्‍ले़ थिक्-ने़त् (१२) कुहुॽसाम्‍बाहाॽ थिक्‍ले़प्‍माङ् तेॽरुसिआङ् अक्‍खे मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ओमे़त्ते़म्‍मे़ॽ, आनिॽ यरुसले़म थो आबेःक्‍ल आबत्‍लो॥ खे़प्‍मो तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ खुनिॽ हुक्‍को मे़न्‍छाम्‍साःन् इङ्‌मे़ले़क्‍तुआङ् हुक्‍मे़सुप्‍तुॽरो॥ खे़ङ्‌हाॽरे़ खुने़ॽ सिःमे़ल्‍ले़न् खुम्‍दिङ् मे़बिरुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ किनाःन्‍दि मे़बिरुर, ते़ःम्‍भुक् मे़याक्‍तुर, सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् मे़भोःन्‍दु मे़से़रुर फाॽआङ् हुक्‍मे़सुप्‍तुॽरो॥ हे़क्‍क्‍याङ् सुम् ये़न् एगाङ् सिःमे़न्‍लाम् याम्‍मो हिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","हे़क्‍क्‍याङ् जब्‍दियारे़ कुस्‍साः याकुब नु युहुन्‍नारे़ खुन्‍छिॽ माःन्‌कुस्‍साःहाॽनु त्‍ये़आङ् थुङ्‌बोहजॽ युङ्‌सिङ्‌ल ये़सुःन् पेलि फाक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ये़सुरे़ खे़न् सेःन्‍दोसु, “थे़मा चोगुङ् पिने़र फाॽआङ् पेलि के़भाक्‍काबे?” खे़ल्‍ले़ नोगप् पिरु, “के़हाङ्‌जुम्‍मो कन् ने़प्‍फु आस्‍साःहाॽ के़जुप्‍साङ् नु के़भे़न्‍छाङ् ले़प्‍माङ् युङ्‌मा पाङ्‌घे़से़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिन्‍छिॽ थेःन् के़नाःक्‍सुर के़बत्‍छिॽ खे़न् कुसिङ् के़न्‍निःत्‍छुन्॥ इङ्‌गाॽ थुङुङ्‌बा तुक्‍खेवा खोर्याओ थुङ्‌मा के़सुक्‍सुबि?” खे़ङ्‌हाॽरे़ नोगप् पिरे़त्‍छु, “सुक्‍सुगे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिन्‍छिॽ से़क्‍खाए इङ्‌गाॽ थुङुङ्‌बा खोर्याओ के़धुङ्‌सुॽ, करसाङ् आभे़न्‍छाङ् नु आजुप्‍साङ् ले़प्‍माङ् युङ्‌मा के़सुक्‍सिॽ पाःप्‍मा युक् मे़गत्तान्‍लो॥ खे़न् ते़न्‍हाॽग पानुदिङ् आम्‍बारे़ आत्तिन्‍हाॽ पिमासि फाॽआङ् यारिप् चोगुआङ् वाॽ, बा खे़ङ्‌हाॽरक् युङ्‌मा मे़घोःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","हे़क्‍क्‍याङ् वेॽ थिबोःङ् (१०) हुॽसाम्‍बाहाॽरे़ कन् मे़घे़प्‍सुआङ् याकुब हे़क्‍क्‍याङ् युहुन्‍नाःन्‍नु खुन्‍छिॽ सिक् पोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","कर ये़सुरे़ खे़ङ्‌हाॽ उःत्तुसिआङ् मे़त्तुसि, “थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ खुनिॽ हाङ्‌हाॽरे़ग मनाहाॽ खुनिॽ निङ्‌वाॽ पाःप्‍पाःत्‌मे़मे़त्तुसिॽ, हे़क्‍क्‍याङ् सुहाङ्‌युक्‍पाहाॽरे़आङ् खुनिॽ फोःसाङ्‌बाहाॽ साक्‍के़ले़क्‍काङ्‌युक् मे़जोगुसिबाग खिनिॽ के़निःसुम्‍माङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","कर खिनिॽ लुम्‍मोग हे़क्‍के पोःङ्‌मा मे़नुॽने़न्‍लो॥ खिनिॽ लुम्‍मोग आत्तिल्‍ले़ लाम्‍लोःबा पोःङ्‌मा निङ्‌वाॽ चोगुॽ खे़न् हाराॽ खिनिॽ सेवारोबा पोःङ्‌लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","हे़क्‍क्‍याङ् हाःत्‍ले़ के़रे़क्‍नुःल्‍ले़ तगाङ् पोःङ्‌मा निङ्‌वाॽ चोगुॽ, हाराॽ खे़न् खिनिॽ योःक् पोःङ्‌लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","हे़क्‍केलॽरिक् इङ्‌गाॽ मे़न्‍छाम्‍साःन् सेवा मे़जोःक्‍कार फाॽआङ् मे़ःन्, कर सेवा चोःक्‍से़ त्‍याङ्‌बारो॥ हे़क्‍क्‍याङ् यरिक् मनाहाॽ लायोलाम् थे़ॽमासिआङ्‌ताङ्‌से़ःप्‍मासि फाॽआङ् इङ्‌गाॽ आहिङ्‌मन्‍निन् पिसे़ त्‍याङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ये़सुःन् नु कुहुॽसाम्‍बाहाॽ ये़रिहो ये़क्‌यक्‍कोलाम् मे़बेर मे़बत्‍छे़ल्‍ले़ यरिक् मनाहाॽ खुने़ॽनु मे़धासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","खे़प्‍मो मे़बेर मे़बत्‍छे़बा लाम्‍मो ने़प्‍फु मिक्‍फःम्‍बाहाॽ युङे़त्‍छि॥ खे़ङ्‌हाॽरे़ ये़सुःन् खे़प्‍मोलाम् पेःक्‍ल पत् के़लॽबा निङ्‌वाॽ खोःसे़त्‍छुआङ् अःक्‍ते़त्‍छि, “दाङ्‌बे, दाउदरे़ कुस्‍साःए, आन्‍छिगे़ लुङ्‌माॽ आदुक्‍ते़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","खे़न् मनाहाॽरे़ खे़ङ्‌हाॽ मे़भे़ःक्‍तुसिर स्‍वाःत् युङ्‌मा मे़बाङ्‌घुसि, कर खे़ङ्‌हाॽ आल्‍लसाङ् साॽरिक् अःक्‍ते़त्‍छिरो, “दाङ्‌बे, दाउदरे़ कुस्‍साःए, आन्‍छिगे़ लुङ्‌माॽ आदुक्‍ते़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ये़सुरे़ ये़म्‍सिङ्‌ङाङ् खे़ङ्‌हाॽ सेःन्‍दोसुसि, “इङ्‌गाॽ थे़मा चोगुङ् पिने़त्‍छिङ्‌बा खिन्‍छिॽ निङ्‌वाॽ के़जोःक्‍सुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","खे़ङ्‌हाॽरे़ नोगप् पिरे़त्‍छु, “दाङ्‌बे, आन्‍छिगे़ निःमा के़सुक्‍पा आजोगे़त्‍छे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ये़सुरे़ खे़ङ्‌हाॽ लुङ्‌माॽ तुक्‍तुसिआङ् खुन्‍छिॽ मिक्‍हाॽ सुःसु पिरुसि, हे़क्‍क्‍याङ् खिमो खे़ङ्‌हाॽ निःमा के़सुक्‍पा पोःक्‍खे़त्‍छिआङ् खुने़ॽ कुएगाङ् कुएगाङ् खे़ङ्‌हाॽ थाने़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ये़सुःन् नु कुहुॽसाम्‍बाहाॽ यरुसले़म मे़बेर मे़बत्‍छे़ल्‍ले़ यरुसले़म निःत्ताङ्‌बा जैतुन कोःक्‍माल्‍ले़ कुबेसाङ्‌बा बे़थफागे पाङ्‌भेॽ निःत्ताङ् मे़गे़रे़, हे़क्‍क्‍याङ् ये़सुरे़ ने़प्‍फु कुहुॽसाम्‍बाहाॽ अक्‍खे मे़त्तुसिर पाङ्‌घुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“खिन्‍छिॽ तगाङ्‌बा पाङ्‌भेॽओ पेसे़ॽ, खे़प्‍मो के़लाःत्‍छिल्‍ले़सा इमे़घेःक्‍खुमा अदङ्‌माःल्‍ले़ कुबेसाङ् कुस्‍साःन् ये़प्‍पा के़दुम्‍सुॽ॥ खे़न् ले़रे़त्‍छे़ॽआङ् इङ्‌गाॽओ तारे़त्‍छे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","मनाहाॽरे़ थेआङ् कन् अदङ्‌साःन् के़ले़त्‍छुबाबे फाॽआङ् सेःन्‍गे़म्‍लाप्‍सिने़ फाॽग्र कङ्‌हाॽ आनिगे़ दाङ्‌बे़न् चाहाबा चोगे़आङ् वाॽ, हाराए खुने़ॽ याङ्‌ना नुःक्‍तुसिॽ फाॽआङ् मे़त्ते़छे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","कङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाल्‍ले़ अक्‍खे पाःत्तुबान् के़त्‍ल फाॽआङ् पोःक्‍खे़बारो– ");
INSERT INTO lifNT2_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“यरुसले़मस्‍मा मनाहाॽ मे़त्ते़से़ॽ, खिनिॽ पयम्‌हाङ्‌ङिन् खिनिॽओ तार पत्‌, खुने़ॽग चुङ्‌जिगे़न् नःम्‍सिङ्‌ङाङ् अदङ्‌साःन् युक्‍तुआङ् ताः, खुने़ॽग अदङ्‌साःन्‍ने युक्‍तुआङ् तार पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","खे़न् ने़प्‍फु हुॽसाम्‍बाहाॽरे़ ये़सुरे़ पाःत्तुबा हे़क्‍के चोगे़त्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","खे़ङ्‌हाॽरे़ अदङ्‌साःन् नु अदङ्‌माःन् तारे़त्‍छुआङ् खे़ङ्‌हाॽ सम्‍दाङ् खुनिॽ तेःत्‍हाॽ मे़ने़स्‍सु हे़क्‍क्‍याङ् ये़सुरे़ अदङ्‌साःन् युक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","हे़क्‍क्‍याङ् खे़प्‍मो यरिक् मनाहाॽरे़ ये़सुरे़ कुदगि कुदगि लाम्‍मो खुनिॽ तेःत्‍हाॽ मे़भे़सु, हे़क्‍क्‍याङ् वेॽहाॽरे़ चुजुक्‍सा सिङ् पोराःक्‍हाॽ मे़जे़प्‍तुआङ् लाम्‍मो मे़भे़सुर खुने़ॽ लाङ्‌दाःक्‍मा मे़बिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","खुने़ॽ कुदगि नु कुएगाङ् के़बप्‍पा यरिक् मनाहाॽरे़ मे़अःक्‍ते़र अक्‍खे मे़बाःत्तु, “दाउदरे़ कुस्‍साःल्‍ले़ कुनारा पोःररो! यहवे दाङ्‌बाल्‍ले़ कुमिङ्‌ङो के़दाःबान् मुॽइसाबा पोःङ्‌लरो! साङ्‌ग्राम्‍पेदाङ्‌ङो निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा पोःररो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ये़सुःन्‌यरुसले़म ये़क्‌यक्‍को लाःसे़ल्‍ले़ यम्‍बा हयङ्‌किल्‍लिङ्‌पोःक्‍खे़आङ् मनाहाॽरे़ अक्‍खेलॽरिक् सेःन्‍लाप्‍मा मे़हेःक्‍तु, “कङ्‌ग हाःत्‍निबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","मनालुम्‍मोलाम् कुभारे़ नोगप् मे़बिरुसि, “कङ्‌ग गालिलस्‍मा नासरतलाम् के़दाःबा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा ये़सुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ये़सुःन् माङ्‌हिम्‍मो पेआङ् खे़प्‍मो चिगःक्‌वा के़सङ्‌बा के़इङ्‌बाहाॽ नाःप्‍मा लःप्‍मा हेःक्‍तुसि॥ याङ् के़ले़क्‍पाहाॽरे़ खुनिॽ याङ्‌ले़क्‍मा साप्‍ने़त्तिन् नु पुत्तुःक्‍के के़सङ्‌बाहाॽरे़ खुनिॽ युक्‍नाःन् ले़क्‍खुबिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ये़सुरे़ खे़ङ्‌हाॽ अक्‍खे मे़त्तुसि, “साम्‌योसाप्‍लाओ साप्‍ते़आङ् पत्, ‘इङ्‌गाॽ आहिम्‍मिङ्‌ग तुवा चोःक्‍मा हिम् पोःङ्,’ कर खिनिॽग फाःन्‍दाहाॽ चिङ्‌सिङ्‌मा ते़न् के़जोगुम्‍माङ् के़वयिॽरो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ये़सुःन् माङ्‌हिम्‍मो वये़ल्‍ले़ मिक्‍फःम्‍बाहाॽ नु लाङ्‌सक्‍पाहाॽ मे़द्‌ये़ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ के़रे़क् नुसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","कर तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ खुने़ॽ चोगुबा निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ मे़निःसु हे़क्‍क्‍याङ् हिन्‍जाॽबित्‍छाहाॽरे़आङ् माङ्‌हिम्‍मो दाउदरे़ कुस्‍साःल्‍ले़ कुनारा पोःर लॽरिक् मे़अःक्‍ते़बा मे़घे़प्‍सुल्‍ले़ खे़ङ्‌हाॽरे़ खुनिॽ सिक् पोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","खे़ङ्‌हाॽरे़ खुने़ॽ मे़मे़त्तु, “कन्‍हाॽरे़ थे मे़बाःत्तुर मे़बत् के़ङ्‌घे़प्‍सुन्बि?” ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खे़प्‍सुङ्‌बे़, कर साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् के़बप्‍पे़न्‌खिनिॽ मे़न्‍निःत्ते के़वयिॽबि? ‘हिन्‍जाॽबित्‍छाहाॽ नु नुगे़धुङ्‌बाहाॽलाम् खुने़ॽ के़नारा फोःमा पाङ्‌घुसि’” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ ले़रुधसिआङ् ये़क्‌यक्‍लाम् बे़थानि पाङ्‌जुम्‍मो पेआङ् याङ्‌धोःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","कुदाःन्‍दिक् तानाम्‍सा ये़सुःन् कुहुॽसाम्‍बाहाॽनु ये़क्‌यक्‍को नुःक्‍खे़आङ् पेर पत्‍छे़ल्‍ले़ कुसे़त्‍लाःक्‍ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","लाम्‍मिल्‍ले़ कुबेसाङ् पःत्‍छेॽबुङ्‌मान् निःसुआङ् कुबेसाङ् पे, हे़क्‍क्‍याङ् ओमे़त्तुल्‍ले़ कुभे़क्‌वारक् पत्‍छे़ कर कुजाॽ मे़बत्‍छे़न्‍लो॥ हे़क्‍केःल्‍ले़ ये़सुरे़ खे़न् पःत्‍छेॽबुङ्‌मान् मे़त्तु, “आल्‍लआङ्‌धो आप्‍फाल्‍ले़आङ् के़जाॽ मे़धोःक्‍ने़न्‍लरो॥” हे़क्‍क्‍याङ् खे़न् पःत्‍छेॽबुङ्‌मान् खिमो इले़मे़ स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","हुॽसाम्‍बाहाॽरे़ खे़न् मे़निःसुआङ् खुनिॽ निङ्‌वाॽ मये़र मे़बारे़, “आक्‍खे़न् हाराने़ कन् पःत्‍छेॽबुङ्‌मान् इले़मे़ स्‍ये़बाबे!” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खिनिॽ चप्‍चि मे़न्‍जोःक्‍के नसाःन् के़जोगुम्‍ने़ फाॽग्र कन् पःत्‍छेॽबुङ्‌मान् इङ्‌गाॽ चोगुङ्‌बा कुइसिःक् खिनिॽआङ् चोःक्‍मा के़सुक्‍तुम्, हे़क्‍क्‍याङ् खे़म्‍म्‍याक्‍लक् मे़ःन्, कर ‘कन् कोःक्‍मान् हाॽयाक्‌आगे़ॽआङ् वाहङ्‌ङो लाप्‍फुसिङ्‌ङे़ॽ’ के़मे़त्तुम्‍मिल्‍ले़ खे़न् के़त्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","खिनिॽ तुवाओ के़नाःक्‍तुम्‍बा पाःन्‍निन् खोःसुम्‍बे़ॽ फाॽआङ् नसाःन् के़जोगुम्‍ने़ फाॽग्र निङ्‌वाॽफुमाङ्‌लाम् के़घोःसुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ये़सुःन् माङ्‌हिम्‍मो के़रे़आङ् मनाहाॽ निसाम् हुॽमा हेःक्‍तुसिल्‍ले़ तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु वेॽ यहुदि तुम्‍लाम्‍लोःबाहाॽ खे़प्‍मो मे़द्‌ये़आङ् खुने़ॽ सेःन्‍मे़दोसु, “खे़ने़ॽ थे़मा युक्‍किल्‍ले़ अक्‍तङ्‌बा याःम्‍बक्‍हाॽ के़जोगुर के़वाॽ? कन् युक्‍किन् हाःत्‍ले़ के़बिरे़?” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽआङ् लत्‍छा सेःन्‍लाप्‍थिक् सेःन्‍दोःनिङ्‌लो॥ इङ्‌गाॽ याप्‍मि नोगप् के़बिरिॽने़ फाॽग्र इङ्‌गाॽआङ् थे़मा युक्‍किल्‍ले़ याःम्‍बक् चोगुङ् खे़न् मे़त्‍निङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","युहुन्‍नारे़ बप्‍तिस्‍मा पिमा कुयुक्‍किन् आत्तोलाम् त्‍ये़बाबे? निङ्‌वाॽफुमाङ्‌लाम् त्‍ये़बाबि, इ मनालाम्बि?” खे़ङ्‌हाॽरे़ खुनिॽ लुम्‍मो पाःन् मे़धक्‍ते़र अक्‍खे मे़मे़त्‍छिङ्, “आल्‍ल आनिॽ ‘निङ्‌वाॽफुमाङ्‌लाम्’ आमे़त्तुम्‍ने़ फाॽग्र, थेआङ् नसाःन् के़न्‍जोगुम्‍मिन् फाॽआङ् सेःन्‍आलाप्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","कर ‘मनाहाॽलाम्’ आबाःत्तुम्‍ने़ फाॽग्र मनाहाॽ आनिॽ तक्‍ले़ङ्‌वाओ मे़बोःक्‍पि फाॽआङ् आगिरो, थेआङ्‌भे़ल्‍ले़ कन् मनाहाॽरे़ युहुन्‍नाःन् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा फाॽआङ् मे़इःत्तुआङ् मे़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ ये़सुःन् मे़मे़त्तु, “आनिगे़ मे़निःसुम्‍बे़न्‍लो॥” हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “हे़क्‍केने़ फाॽग्र थे़मा युक्‍किल्‍ले़ अक्‍तङ्‌बा याःम्‍बक्‍हाॽ चोगुङ् खे़न् इङ्‌गाॽआङ् मे़मे़त्‍निङ्‌ङिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","याम्‍मो ये़सुरे़ खे़न् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि लाम्‍लोःबाहाॽ मे़त्तुसि, “खिनिॽ खे़दाॽधिक् मे़त्‍निङ्, हे़क्‍क्‍याङ् खे़ल्‍ले़ कुयाःम्‍बेओ थे के़इःत्तुम् आमे़त्ते़म्‍मे़ॽओ॥ लत्‍छा मनाधिक् वये़, खे़ल्‍ले़ ने़प्‍फु कुस्‍साः ये़म्‍बित्‍छाॽहाॽ वये़त्‍छि॥ खे़न् मनाःन् कुस्‍साः तुम्‍बाल्‍लो पेआङ् मे़त्तु, ‘आस्‍साःए, पेगे़ॽआङ् चे़ल्‍ले़क्‍सेॽ इक्‍को याःम्‍बक् चोगे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","खे़न् कुस्‍साःल्‍ले़ तगिग ‘मे़जोःक्‍कान्‍लो’ मे़त्तु, कर याङ्‌सि कुनिङ्‌वाॽ नुःक्‍खे़, हे़क्‍क्‍याङ्‌पेआङ् याःम्‍बक् चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","हे़क्‍क्‍याङ् कुम्‍बाःन् कुस्‍साः फोॽबाल्‍लो पेआङ् बा हे़क्‍केए मे़त्तु॥ खे़न् कुस्‍साः फोॽबाल्‍ले़आङ्, ‘पोःङ् आदाङ्‌बे, पेःक्‍कारो’ मे़त्तु, कर खे़न् याःम्‍बक्‍को मे़बेने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","आल्‍ल खे़न् ने़प्‍फुओ आत्तिल्‍ले़ खुन्‍छिॽ पाःल्‍ले़ कुनिङ्‌वाॽ हे़क्‍के चोगे़त्‍छुबे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “तुम्‍बाल्‍ले़रो॥” ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, निङ्‌वाॽफुहाङ्‌जुम्‍मो एःङ्‌याङ् के़भोःङ्‌बाहाॽ नु के़त्‍निमाहाॽ खिनिॽनुःल्‍ले़आङ् तगि मे़लाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","थेआङ्‌भे़ल्‍ले़ बप्‍तिस्‍मा के़बिबा युहुन्‍नाःन् खिनिॽ साम्‌योनिबा लाम् ओसेःन्‍धाक्‍से़ त्‍ये़बारो, हे़क्‍केसाङ् खुने़ॽ सम्‍दाङ् खिनिॽ नसाःन् के़न्‍जोगुम्‍मिन्‍लो॥ कर एःङ्‌याङ् के़भोःङ्‌बाहाॽ नु के़त्‍निमाहाॽरे़ खुने़ॽ नसाःन् मे़जोगुआङ् मे़वाॽरो॥ खे़न् के़निःसुम्‍साङ् खिनिॽ लायोलाम् के़न्‍हिन्‍दिन्‍नाङ् खुने़ॽ नसाःन्‍नाङ्‌के़न्‍जोगुम्‍मिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ये़सुरे़ याम्‍मो खे़ङ्‌हाॽ मे़त्तुसि, “वेॽस्‍मा खे़दाॽधिक् खे़प्‍से़म्‍मे़ॽओ॥ थिक्‍ले़ङ् यम्‍बा लाजेॽदाङ्‌बाधिक् वये़, खे़ल्‍ले़ लत्‍छा इक्‍को चे़ल्‍ले़क्‍सेॽ लेःत्तुआङ् कुघिरि लुङ्‌धाक् से़त्तुर फाङु, हे़क्‍क्‍याङ् कुलुम्‍मो लुम्‍बाःत् तयुआङ् खे़प्‍मो चे़ल्‍ले़क्‍सेॽ एःम्‍मा ते़न्धिक्‌चोगु॥ इक् कोमा याक्‍साधिक्‍काङ् चोगु, हे़क्‍क्‍याङ् खे़न् चे़ल्‍ले़क्‍सेॽ इक्‍किन् कुभ्रे़ःङ् लक् खोःमारे़ लागि इक्‍मसाबाहाॽ पिरुसिआङ् खुने़ॽ लाम्‍दिःक् चोःक्‍से़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","चे़ल्‍ले़क्‍सेॽ तुप्‍मा ये़म् त्‍ये़ःल्‍ले़ कुलक् लाःसे़ कुसेवारोबाहाॽ इक्‍मःबाहाॽरो पाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","खे़न् इक्‍मःबाहाॽरे़ कुसेवारोबाहाॽ मे़दे़म्‍सुसि हे़क्‍क्‍याङ् थिक्‍सिगेःक्‍पान् मे़हिप्‍तु, निसिगेःक्‍पान् मे़से़रुआङ् सुम्‍सिगेःक्‍पान् लुङ्‌ङिल्‍ले़ मे़बःत्तु मे़से़रुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","हे़क्‍क्‍याङ् खे़ल्‍ले़ तगिनुःल्‍ले़आङ् यरिक् कुसेवारोबाहाॽ पाङ्‌घुसि, कर खे़न् इक्‍मःबाहाॽरे़ खे़ङ्‌हाॽआङ् बा हे़क्‍केए मे़मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","हे़क्‍क्‍याङ् कुनुप्‍मो खे़न् इक्‍के़ल्‍ले़ कुन्‍दाङ्‌बाल्‍ले़ आल्‍ल कन् लुङ्‌माॽ तुक्‍तुङ्‌बा आस्‍साःन् पाङ्‌घुङ्‌ङिल्‍ले़ग से़क्‍खासाङ् कुना मे़साॽरुबिला फाॽआङ् इःत्तुआङ् कुस्‍साःन् पाङ्‌घु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","कर खे़ङ्‌हाॽरे़ कुस्‍साःन् मे़निःसुआङ् अक्‍खे मे़मे़त्‍छिङ्, ‘कङ्‌ग कुम्‍बारे़ कुलक् के़घोःबारो, कन्‌से़रुम्‍माङ् कुलाजेॽ सिङ्‌बुङ्‌हाॽ आनिॽ हुक्‍काप्‍पासिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","हे़क्‍केलॽरिक् खे़ङ्‌हाॽरे़ खुने़ॽ मे़दे़म्‍सुआङ् चे़ल्‍ले़क्‍सेॽ इक्‍कोलाम् लाःक्‍कात् मे़लःत्तुआङ् मे़से़रुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “आल्‍ल चे़ल्‍ले़क्‍सेॽ इक्‍के़ल्‍ले़ कुन्‍दाङ्‌बान् ताआङ् खे़न् इक्‍मःबाहाॽ आक्‍खे मे़त्तुसिॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","खे़न् तुम्‌यक्‌याबाहाॽ नु यहुदि लाम्‍लोःबाहाॽरे़ खुने़ॽ नोगप् मे़बिरु, “खुने़ॽ ताआङ् खे़न् ताक्‍के़भे़ॽबा मनाहाॽ से़क्‍खासाङ् साॽरिक् तुक्‍खे चाःत्तुसिर से़रुसिॽरो॥ हे़क्‍क्‍याङ् चे़ल्‍ले़क्‍सेॽ इक्‍किन् कुभ्रे़ःङ् लक् खोःमारे़ लागि वेॽ इक्‍मःबाहाॽ पिरुसिआङ् खे़ङ्‌हाॽरे़ चे़ल्‍ले़क्‍सेॽ तुम्‍मिल्‍ले़ कुलक्‍किन्‌मे़बिरुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ साम्‌योसाप्‍लाओ मे़न्‍निःत्ते के़वयिबि? ‘लुङ्‌गाम्‍बाहाॽरे़ मे़नाॽरुबा लुङ्‌ङिन् के़रे़क्‍नुःल्‍ले़ के़ये़क्‍पा कुम्‍मा लुङ् पोःक्‍खे़आङ् वाॽरो॥ कङ्‌ग यहवे दाङ्‌बाल्‍ले़ए चोगुबारो, हे़क्‍क्‍याङ् कन् आनिॽ निःमो निङ्‌वाॽ के़माबा चोःक्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽ मे़त्‍निङ्, खिनिॽओलाम् निङ्‌वाॽफुहाङ्‌जुम्‍मिन् नाप्‍पाङ् खे़न्‍निन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिङ्‌वाॽ हे़क्‍के के़जोःक्‍पा मनाहाॽ पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","‘आत्तिन्‍हाॽ खे़न् लुङ् सम्‍दाङ् मक्‍मे़धाःॽ, खे़ङ्‌हाॽ मे़भक् मे़सिःरो॥ हे़क्‍क्‍याङ् आत्तिन्‍हाॽ सम्‍दाङ् खे़न् लुङ्‌ङिन् मक्‍थाःॽ, खे़ङ्‌हाॽ मे़भे़क् मे़सिःरो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","हे़क्‍क्‍याङ् खे़प्‍मो तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु फरिसिहाॽरे़ कन् खे़दाॽइन् मे़घे़प्‍सुआङ् कङ्‌ग आनिगे़ याःम्‍बेओए ये़सुरे़ पाःत्तुर पत् फाॽआङ् निङ्‌वाॽ मे़घोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","खे़ङ्‌हाॽरे़ खुने़ॽ ते़म्‍मा निङ्‌वाॽ मे़जोगु, कर मनाहाॽ मे़गिरुसि थेआङ्‌भे़ल्‍ले़ मनाहाॽरे़ ये़सुःङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा फाॽआङ् मे़इःत्तुआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ये़सुरे़ खे़न् यहुदि लाम्‍लोःबाहाॽ याम्‍मो खे़दाॽहाॽओ अक्‍खे मे़त्तुसि– ");
INSERT INTO lifNT2_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग लत्‍छा हाङ्‌धिक्‍ले़ कुस्‍साःल्‍ले़ कुमेःक्‍खिम्‍मिल्‍ले़न्‌साभाङ्‌जा से़ःसुबा खे़दाॽ कुइसिःक् चोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","मेःक्‍खिम् साभाङ्‌जारे़न् चामुक् थिमुक्‍किन् यारिप् पोःक्‍खे़आङ् खे़न् हाङ्‌ङिल्‍ले़ उःत्‍छिङ् के़घोःबाहाॽ साभाङ्‌जाओ ताःप्‍मासि कुसेवारोबाहाॽ पाङ्‌घुसि, कर खे़ङ्‌हाॽ ताःमा मे़न्‍दे़न्‍दे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","हे़क्‍केःल्‍ले़ खे़न् हाङ्‌ङिल्‍ले़ कुभा कुसेवारोबाहाॽ अक्‍खे मे़त्तुसिर पाङ्‌घुसि, ‘खे़न् उःत्‍छिङ् के़घोःबाहाॽ अक्‍खे मे़त्ते़म्‍सिम्‍मे़ॽ, इङ्‌गाॽ मेःक्‍खिम् साभाङ्‌जाःन्‌यारिप् चोगुङ्‌ङाङ् वाॽआ॥ लुप्‍मनाबा थक्‍साहाॽ से़रुङ्‌सिङ्‌ङाङ् के़रे़क् चामा थुङ्‌मान् यारिप् पोःक्‍खे़आङ् वाॽ, मेःक्‍खिम् साभाङ्‌जाओ त्‍ये़म्‍मे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","कर खे़ङ्‌हाॽरे़ खे़म्‍घे़म् मे़न्‍लाप्‍तुन्‍नाङ् कुभाग प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो याःम्‍बक् चोःक्‍से़ मे़बे, कुभा ले़ङ्‌हङ् चोःक्‍से़ मे़बे, ");
INSERT INTO lifNT2_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","कुभारे़ग कुसेवारोबाहाॽ मे़दे़म्‍सुसिआङ् ताप्‍फे़ःल्‍लिक् मे़मे़त्तुसिआङ् मे़से़रुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","खे़न् हाङ्‌ङिल्‍ले़ साॽरिक् कुसिक् पोगे़॥ खुने़ॽ थक्‍सुबाहाॽ पाङ्‌घुसिआङ् खे़न् मना के़से़प्‍पाहाॽ के़रे़क् से़प्‍मा पाङ्‌घुसि, हे़क्‍क्‍याङ् खुनिॽ ये़क्‌यक्‍किन् फुत्‍लुम् हाःन्‍दुदेःसु पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","हे़क्‍क्‍याङ् हाङ्‌ङिल्‍ले़ कुसेवारोबाहाॽ मे़त्तुसि, ‘मेःक्‍खिम् साभाङ्‌जाःन्‌यारिप् पोःक्‍खे़आङ् वाॽ, कर खे़प्‍मो उःत्‍छिङ् के़घोःबाहाॽ ताःमा सुम्‍बोधाबा मे़न्‍जोःक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","हे़क्‍केःल्‍ले़ ये़क्‌यक्‍कोबा लाम् लाम्‍मो पेगे़म्‍मे़ॽआङ् के़दुमुम्‍सिम्‍बा के़रे़क् मनाहाॽ उःत्ते़म्‌तारे़म्‍सिम्‍मे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","खे़ल्‍ले़ चोगुल्‍ले़ सेवारोबाहाॽ ये़क्‌यक्‍को मे़बेआङ् लाम् लाम्‍मो मे़दुमुसिबा के़रे़क् नुःबा नु ताप्‍फे़ःम्‍बा मनाहाॽ मेःक्‍खिम् साभाङ्‌जाओ मे़उःत्तु मे़दारुसिआङ् खे़प्‍मोबा युक्‍नाहाॽ मे़धिम्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","कर हाङ्‌ङिन् तरे तुम्‍से़ सिगाङ् लाःसे़ल्‍ले़ खे़प्‍मो नुःबा तेःत् मे़न्‍जाङ्‌मनाबा मनाधिक् निःसुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","सेःन्‍दोसु, ‘चुम्‍मे, खे़ने़ॽ आक्‍खेलॽरिक् मेःक्‍खिम् साभाङ्‌जाओ, मेःक्‍खिम्‍मो चाङ्‌मनाबा नुःबा तेःत् मे़ःन्‍ने के़लाःसे़बे?’ खे़न् मनाःल्‍ले़ थेआङ् पाःप्‍मा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","हे़क्‍क्‍याङ् हाङ्‌ङिल्‍ले़ सेवारोबाहाॽ मे़त्तुसि, ‘कन् मनाःन् ते़म्‍से़म्‍मे़ॽआङ् कुलाङ् कुहुक्‍हाॽ इघेःक्‍खे़म्‍मे़ॽ हे़क्‍क्‍याङ् लाःक्‍कात् खादाम्‍मो लाप्‍फुःसे़म्‍मे़ॽओ॥ खे़प्‍मो हाःप्‍मान् नु साॽरिक् तुक्‍खेःल्‍ले़ हाबोॽ ये़ःङ्‌मान् पोःङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","थेआङ्‌भे़ल्‍ले़ उःत्‍छिङ्‌मा के़घोःबाहाॽ यरिक् मे़वाॽ, कर सेःक्‍सिङ्‌मा के़घोःबाहाॽ कुभारक् मे़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","हे़क्‍क्‍याङ् फरिसिहाॽ सोरिक् मे़जुप्‍से़आङ् ये़सुःन् आक्‍खेलॽरिक् पाःन्‍नो थाःमाबे फाॽआङ् सुक्‍मा मे़हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","फरिसिहाॽरे़ खुनिॽ हुॽसाम्‍बाहाॽ हे़रोद हाङ्‌ङिल्‍ले़ कुमनाहाॽनु ये़सुरो मे़बाङ्‌घुसि॥ खे़ङ्‌हाॽरे़ ये़सुःन् सेःन्‍मे़दोसु, “सिक्‍साम्‍बे, खे़ने़ॽग से़क्‍खा पाःन्‍लक् के़बाःप्‍पे़न्‌आनिगे़ निःसुम्‍बे़रो॥ हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुलाम्‍मिन् से़क्‍खाए के़हुॽरुसिरो॥ खे़ने़ॽ मनाहाॽरे़ खुनिॽ पाःन्‍नो के़म्‍बत्‍ने़न्, हे़क्‍क्‍याङ् मनाआङ्‌के़न्‍छे़न्‍दुन्‍छिन्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","हे़क्‍केःल्‍ले़ कन्‌पाःन्‍निन् आमे़त्ते़ॽरोमि पयम् हाङ् सिजरे़न् एःङ्‌याङ् हुङ्‌मा आनिॽ साम्‌योथिम्‍मिल्‍ले़ आबिॽबि आम्‍बिने़न्बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","कर ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ फे़न् निङ्‌वाॽइन्‌निङ्‌वाॽ खोःसुआङ् मे़त्तुसि, “खिनिॽ निङ्‌वाॽ के़जिःप्‍पासे, थेआङ् अक्‍खेलॽरिक् इङ्‌गाॽ पाःन्‍नो ते़म्‍मा निङ्‌वाॽ के़इःत्तुम्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","एःङ्‌याङ् हुङ्‌मा के़बोःङ्‌बा रोमि याङ्‌इत्‍छिःन्‌कत्‍ना फे़त्ते़म्‍मे़ॽ॥” खे़ङ्‌हाॽरे़ खुने़ॽओ याङ्‌इत्‍छिःन्‌मे़दारुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “कप्‍मो हाःत्‍ले़ कुइत्‍छाप् नु कुबाःन्‍साप् पप्‍पे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “सिजरे़ल्‍ले़न्‌पत्‍लो॥” हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “सिजरले़ कुबाःन्‍हाॽ सिजरे़न् पिरे़म्‍मे़ॽ, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुबाःन्‍हाॽ निङ्‌वाॽफुमाङ्‌ङिन्‍ने पिरे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","खे़ङ्‌हाॽरे़ कन् नोगप्‍पिन् मे़घे़प्‍सुआङ् खुनिॽ निङ्‌वाॽ मये़रो॥ खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ खे़प्‍मोए मे़ले़रुमे़धःआङ् मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","बा खे़न् ये़न्‍नो सिःमे़न्‍लाम् याम्‍मो हिङ्‌मन् होःप्‌लॽरिक् नसाःन् के़जोःक्‍पा सदुकिहाॽ ये़सुरो मे़द्‌ये़आङ् सेःन्‍मे़दोसु, ");
INSERT INTO lifNT2_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“सिक्‍साम्‍बे, मोसारे़ साम्‌योथिम्‍मो अक्‍खेलॽरिक् साप्‍तुआङ् पत्, ‘आत्तिल्‍ले़ कुम्‍भुॽइन् कुस्‍साः कुए मे़न्‌वाॽए सिःॽ, खे़ल्‍ले़ कुन्‍साॽरे़ मेमेदुमा कुन्‍ने़ॽद्रेःन्‍नु मेःक्‍खिम् चोःक्‍माए पोःङ्॥ हे़क्‍क्‍याङ् कुम्‍भुॽरे़ कुलागि सागप्‍मा पोःङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","आल्‍ल नुसि फुॽनुसाॽहाॽ मे़वये़॥ तुम्‍बाल्‍ले़ मेःक्‍खिम् चोगुआङ् कुस्‍साः कुए मे़न्‌वाॽए स्‍ये़, हे़क्‍क्‍याङ् कुमेःत्तिन्‍नु कुन्‍साॽरे़ मेःक्‍खिम् चोगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","हे़क्‍केलॽरिक् सरुम्‍बा, याङ्‌सरुम्‍बा नु फोॽबा थारिक्‍ले़ खे़न् मेमेदुमान्‍नु मेःक्‍खिम् मे़जोगु, कर तुम्‍बान् हे़क्‍केए खुनिॽ सा-ए मे़न्‌वाॽए मे़स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","आल्‍ल कुनुप्‍मो खे़न् मे़न्‍छुमाॽइन्‍नाङ् स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","आल्‍ल खे़ङ्‌हाॽ सिःमे़न्‍लाम् याम्‍मो मे़हिङ्‌ङिल्‍ले़ खे़न् आत्तिल्‍ले़ कुमेःत् पोःङ्‌बाबे? थेआङ्‌भे़ल्‍ले़ खे़न् मे़न्‍छुमाॽइन्‍नु नुसि फुॽनुसाॽ के़रे़क्‍ले़ मेःक्‍खिम् मे़जोगुआङ् मे़वये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ये़सुरे़ नोगप् पिरुसि, “खिनिॽग पिर्बेःम्‍बो के़ध्‍ये़ॽइआङ् के़वयिॽरो, थेआङ्‌भे़ल्‍ले़ साम्‌योसाप्‍लाःन् कुसिङ् मे़न्‍निःत्ते के़वयि, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍मिन्‍नाङ् कुसिङ् मे़न्‍निःत्ते के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","थेआङ्‌भे़ल्‍ले़ सिःमे़न्‍लाम् याम्‍मो मे़हिङ्‌ङिल्‍ले़ग मनाहाॽ मेःक्‍खिम् मे़न्‍जोःक्‍ने़न्‍लो, कर खे़ङ्‌हाॽग साङ्‌ग्राम्‍पेदाङ्‌ङोबा माङ्‌लाइङ्‌बा कुइसिःक्‍ने़ मे़बोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","कर सिःमे़न्‍लाम् याम्‍मो हिङ्‌माल्‍ले़ कुयाःम्‍बेओग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् पाःत्तुबान् मे़न्‍निःत्ते के़वयिॽबि? ");
INSERT INTO lifNT2_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘इङ्‌गाॽग अब्राहाम, इसहाक नु याकुबरे़ खुनिॽ निङ्‌वाॽफुमाङ्‌आरो॥’ खे़ल्‍ले़ चोगुल्‍ले़ खुने़ॽग कुसिवे़त्‍हाॽरे़न् मे़ःन्, कर कुहिङ्‌वे़त्‍हाॽरे़ खुनिॽ निङ्‌वाॽफुमाङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","खे़न् के़जुम्‍बा मनाहाॽरे़ कन् पाःन्‍निन् मे़घे़प्‍सुल्‍ले़ कुनिसाम्‍मो खुनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ये़सुरे़ सदुकिहाॽरे़ खुनिॽ मुराःन् सुबु पिरुसि के़लॽबा पाःन्‍निन् फरिसिहाॽरे़ मे़घे़प्‍सु हे़क्‍क्‍याङ् इङ्‌मे़दङ्‌सिङ्‌ङाङ् ये़सुरो मे़द्‌ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","खे़ङ्‌हाॽओ साम्‌योसाप्‍ला साॽरिक् के़ले़बाधिक्‍ले़ ये़सुःन् अक्‍खेलॽरिक् कुनिङ्‌वाॽ साॽरुर सेःन्‍लाप्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“सिक्‍साम्‍बे, साम्‌योथिम्‍मो इःप्‍मा नाःप्‍माए के़बोःङ्‌बा के़रे़क्‍नुःल्‍ले़ यम्‍बा इङ्‌जाःङ्‌ङिन् आत्तिङ्‌ग?” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ये़सुरे़ नोगप् पिरु, “‘के़न्‍दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन् के़रे़क् के़सिक्‍लुङ्‌माल्‍ले़, के़रे़क् के़सक्‍मासाम्‍मिल्‍ले़, हे़क्‍क्‍याङ् के़रे़क् के़निङ्‌वाॽइल्‍ले़ मिःम्‍जि मे़त्ते़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","कङ्‌ग थिक्‍सिगेःक्‍पा नु के़रे़क्‍नुःल्‍ले़ के़ये़क्‍पा इङ्‌जाःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","हे़क्‍केलॽरिक् निसिगेःक्‍पा के़ये़क्‍पा इङ्‌जाःङ्‌ङिङ्‌ग बा कन्‍लो, ‘आप्‍फेःक्‌लुङ्‌माॽ के़दुक्‍सिङ्‌बा कुइसिःक्‍के के़बाङ्‌भेॽसाबाहाॽआङ्‌लुङ्‌माॽ तुक्‍ते़से़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","के़रे़क् साम्‌योथिम् नु माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ खुनिॽ निसाम्‍मिन् कन् ने़त्‍छि इङ्‌जाःङ्‌लाम् त्‍ये़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","हे़क्‍क्‍याङ् फरिसिहाॽ थिक्‍दे़न्‍नो सोरिक् मे़जुप्‍से़आङ् मे़वये़ल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरे़ कुयाःम्‍बेओ खिनिॽ थे के़इःत्तुम्‍बे? खुने़ॽ हाःत्‍ले़ कुस्‍साः फाॽआङ् खिनिॽ निङ्‌वाॽ के़इःत्तुम्‍बे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “खुने़ॽग दाउद हाङ्‌ङिल्‍ले़ कुस्‍साःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो सेःन्‍दोसुसि, “हे़क्‍केने़ फाॽग्र सेसेमाङ्‌लाम् दाउदरे़ आक्‍खेलॽरिक् आदाङ्‌बे फाॽआङ्‌मे़त्तुबाबे? थेआङ्‌भे़ल्‍ले़ दाउद हाङ्‌ङिल्‍ले़ निङ्‌वाॽफुसाम्‍लो सुम्‍मो पाःत्तु, ");
INSERT INTO lifNT2_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘यहवे दाङ्‌बाल्‍ले़ इङ्‌गाॽ आन्‍दाङ्‌बान् अक्‍खे मे़त्तु, के़निङ्‌मिहाॽ के़युक्‍को इङ्‌गाॽ मे़न्‍दाःत्‍छिङ्‌ङे थारिक् आजुप्‍साङ् ले़प्‍माङ् खे़ने़ॽ युङे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","दाउद हाङ्‌ङिल्‍ले़ए खुने़ॽ आदाङ्‌बे लॽरिक् मे़त्तुने़ फाॽग्र आक्‍खेलॽरिक् ख्रिस्‍ते़न्‌दाउदरे़ कुस्‍साः पोःङ्‌बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","आत्तिन्‍हाॽरे़आङ्‌पाःन्सुत्‍लाधिक् नोगप् पिमा मे़न्‍छुक्‍तुन्, हे़क्‍क्‍याङ् खे़न् ये़न्‍नाङ्‌धो आत्तिन्‍हाॽरे़आङ्‌खुने़ॽ पाःन् सेःन्‍दोःमा आःन्‍छिङ्‌माआङ्‌मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","हे़क्‍क्‍याङ् ये़सुरे़ खे़प्‍मो के़जुम्‍बा मनाहाॽ नु कुहुॽसाम्‍बाहाॽ अक्‍खे मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिहाॽरे़ मोसारे़ साप्‍तुबा साम्‌योथिम्‍मिन्‌पोधक्‍मा युक् मे़गत्तुॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ के़म्‍मे़त्ति के़म्‍हुॽरिबा पाःन्‍निन् खिनिॽ इःप्‍मा नाःप्‍मा पोःङ्, कर खे़ङ्‌हाॽरे़ मे़जोगुबा हे़क्‍के मे़जोगे़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ मे़बाःत्तुबा पाःन्‍हाॽ कुइसिःक्‍ग आबाङेआङ् मे़न्‍जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","खे़ङ्‌हाॽरे़ग के़लिःप्‍पा कक्‌हे़क्‍तङ्‌बा के़साक्‍पा थिम्‍हाॽ मे़जोगुआङ् मनाहाॽ मे़गुःत्तुसिॽ, कर कक् याङ्‌याङ् लॽर फाॽआङ् आबाङे हुक्‍चोधिक्‍किल्‍ले़आङ् मे़न्‍छुस्‍सुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","खे़ङ्‌हाॽरे़ग नुःबा पाःन्‍हाॽ मनाहाॽ ओसेःन्‍धाक्‍मासि फाॽआङ्‌लक् मे़जोगुरो–खे़ङ्‌हाॽरे़ साम्‌योथिम् इङ्‌जाःङ् साप्‍मा याक्‍मनाबा माक्‍पे़न्‍छाप्‍हाॽ यम्‍ब्‌यम्‍बा मे़जोगुआङ् हुक्‍को नु तोवाबो मे़भत्‍छुॽ, हे़क्‍क्‍याङ् चाङ् तेःत्तो केःम्‍ब्‌केःम्‍बा पोरोःक्‌वाहाॽ मे़भत्‍छुॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","खे़ङ्‌हाॽ साभाङ्‌जा नु यहुदि चुम्‍लुङ्‌हिम्‍मोबा तुम्‍म्‍याङ्‌हाङ् युक्‍नाहाॽओ युङ्‌मा खुनिॽ सिराॽ थाङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","हे़क्‍क्‍याङ् पाङ्‌जुम्‍मो मनाहाॽरे़ सेवा मे़मे़त्तुसिबा नु सिक्‍साम्‍बे लॽरिक् मे़मे़त्तुसिबा खुनिॽ सिराॽ थाङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","कर खिनिॽग आत्तिन्‍हाॽरे़आङ्‌सिक्‍साम्‍बे लॽरिक् के़मे़म्‍मे़त्तिन्‍लरो, थेआङ्‌भे़ल्‍ले़ खिनिॽग थिक्‍लक् सिक्‍साम्‍बान् के़गत्तुम्‍लो, हे़क्‍क्‍याङ् खिनिॽ के़रे़क्‍क फुॽनुसाॽ नु ने़ॽनुसाॽ हे़क्‍केनिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","इक्‍सादिङ् खाम्‍बेःक्‍मो ‘पाःए’ लॽरिक् वेॽ आत्तिन्‍हाॽआङ् मे़मे़त्ते़म्‍सिम्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ खिनिॽग थिक्‍लक् निङ्‌वाॽफुपाः के़गत्तुम्‍लो, खुने़ॽग साङ्‌ग्राम्‍पेदाङ्‌ङो वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","आत्तिन्‍हाॽरे़आङ्‌‘सिक्‍साम्‍बे’ लॽरिक् के़मे़म्‍मे़त्तिन्‍लरो थेआङ्‌भे़ल्‍ले़ खिनिॽग थिक्‍लक् सिक्‍साम्‍बान् के़गत्तुम्‍लो, खुने़ॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","खिनिॽ लुम्‍मो के़रे़क्‍नुःल्‍ले़ के़ये़क्‍पा मनाःन् हाराॽ खे़न् खिनिॽ सेवारोबा पोःङ्‌मा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","आत्तिल्‍ले़ यम्‍बा ले़ङ्‌सिङ्‌मा कोःत्तुॽ, खे़ङ्‌ग चुक्‍सा पोःङ्‌लो, हे़क्‍क्‍याङ् आत्तिन् चुक्‍सा ले़ङ्‌सिङ् खे़ङ्‌ग यम्‍बा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","खिनिॽ कुनिङ्‌वाॽ के़जिःप्‍पा साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिसे, के़जिःत्ति के़स्‍ये़ॽइरो! साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिल्‍ले़ कुलाम्‍मिन् वेॽ मनाहाॽरे़ लागि के़साक्‍तुम्‍माङ् के़वयिॽरो, हे़क्‍क्‍याङ् आबाङेआङ् खे़प्‍मो खिनिॽ के़न्‍लासिन् हे़क्‍क्‍याङ् लाःप्‍मा के़गोःप्‍पा वेॽ मनाहाॽआङ् लाःप्‍मा के़म्‍बाङ्‌घुम्‍सिम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","((खिनिॽ कुनिङ्‌वाॽ के़जिःप्‍पा साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिसे, के़जिःत्ति के़स्‍ये़ॽइरो! खिनिॽग मेमेदुमाहाॽ इङ्‌गे़ले़क्‍तुम्‍सिम्‍माङ्‌खुनिॽ हिम्‍धाःङ्‌हाॽ के़नाप्‍तुम्‍सिम्‌, कर नुःबा ओसेःन्‍धाक्‍सिङ्‌मारे़ लागि केःम्‍ब्‌केःम्‍बा तुवा के़जोगुम्॥ खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽ खुम्‍दिङ्‌ङिङ्‌ग से़क्‍खासाङ् साॽरिक् किप्‍मा के़घुःबा पोःङ्‌लो॥)) ");
INSERT INTO lifNT2_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","खिनिॽ कुनिङ्‌वाॽ के़जिःप्‍पा साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिसे, के़जिःत्ति के़स्‍ये़ॽइरो! खिनिॽग थिक् मनाःन् यहुदि साम्‌योओ ताःप्‍मा फाॽआङ् लाजेॽ नु वाहङ् खाराक् लाम्‍दिःक् के़जोगिरो, हे़क्‍क्‍याङ् खे़न् मनाःन् यहुदि साम्‌योओ के़दाःरुम्‍माङ्‌ग खे़न् खिनिॽनुःल्‍ले़आङ् साॽरिक् खे़मायङ्‌सङ्‌ङो खुम्‍दिङ् के़घोःबा के़जोगुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","खिनिॽ मिक्‍फःम्‍बा लाम्‍लोःबासे, के़जिःत्ति के़स्‍ये़ॽइरो! आत्तिन्‌माङ्‌हिम्‍मिल्‍ले़ कुमिङ्‌ङो माङ्‌हे़क्‍सिङ् खे़ङ्‌ग थेआङ् मे़ःन्‍लो, कर आत्तिन्‌माङ्‌हिम्‍मोबा साम्‍म्‍याङ्‌ङिल्‍ले़ कुमिङ्‌ङो माङ्‌हे़क्‍सिङ् खे़न् कुबाःन्‍निल्‍ले़ खेःङ्‌सिङ्‌लो लॽरिक् खिनिॽ के़बाःत्तुम्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","खिनिॽ मिक्‍फःम्‍बा अदङ्‌से! साम्‍म्‍याङ्‌ङिन् यम्‍बाबि साम्‍म्‍याङ्‌ङिन् सेसे के़जोःक्‍पा माङ्‌हिम्‍मिन् यम्‍बाबि? ");
INSERT INTO lifNT2_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","खिनिॽ अक्‍खेलॽरिक्‍काङ् के़बाःत्तुम्, ‘आत्तिन्‌ले़त्तिङ्‌तोःम्‍मादे़न्‍निल्‍ले़न् माङ्‌हे़क्‍सिङ् खे़न् थेआङ् मे़ःन्‍लो, कर आत्तिन्‌ले़त्तिङ्‌तोःम्‍मादे़न्‍नोबा चोफाॽले़न् माङ्‌हे़क्‍सिङ् खे़न् कुबाःन्‍निल्‍ले़ खेःङ्‌सिङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","खिनिॽ मिक्‍फःम्‍बा मनासे, चोफाॽइन् यम्‍बा बि चोफाॽइन् सेसे के़जोःक्‍पा ले़त्तिङ्‌तोःम्‍मादे़न्‍निन् यम्‍बाबि? ");
INSERT INTO lifNT2_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","खे़ल्‍ले़ चोगुल्‍ले़ आत्तिन्‌ले़त्तिङ्‌तोःम्‍मादे़न्‍निल्‍ले़न् माङ्‌हे़क्‍सिङ् खे़न्‌खे़प्‍मो के़रे़क् के़ने़बाल्‍ले़न्‍नाङ् माङ्‌हे़क्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","हे़क्‍क्‍याङ् आत्तिन्‌माङ्‌हिम्‍मिल्‍ले़न् माङ्‌हे़क्‍सिङ् खे़ङ्‌ग खे़प्‍मो के़वाॽबाल्‍ले़न्‍नाङ् माङ्‌हे़क्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","आत्तिन्‌साङ्‌ग्राम्‍पेदाङ्‌ङिल्‍ले़न् माङ्‌हे़क्‍सिङ् खे़ङ्‌ग निङ्‌वाॽफु युक्‍ना नु खे़प्‍मो के़युङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़न्‍नाङ् माङ्‌हे़क्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","खिनिॽ कुनिङ्‌वाॽ के़जिःप्‍पा साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिसे, के़जिःत्ति के़स्‍ये़ॽइरो! खिनिॽ इक्‍ताप्‍पोलाम् नाम्‍सुना, सःप्‍फा नु हिम्‍चे़म्‍भे़न् हे़क्‍तङ्‌बा मारुक्‍हाॽरे़न्‍नाङ् थिबोःङ्‌लक् निङ्‌वाॽफुमाङ्‌ङिन् के़बिरुम्, कर नुःरिक्‍काङ् खासे़न् के़न्‍जोगुम्‍सिम्‍मिन्, वेॽ मनाहाॽ लुङ्‌माॽ के़न्‍दुक्‍तुम्‍सिम्‍मिन्‌, हे़क्‍क्‍याङ् नसाःन् के़न्‍जोगुम्‍मिन्‍लो॥ कन् नाःप्‍माए के़बोःङ्‌बा साम्‌योथिम्‍बा पाःन्‍हाॽ के़न्‍नाःत्तुम्‍मिन्‍लो॥ खिनिॽग थिबोःङ्‌लक् निङ्‌वाॽफुमाङ्‌ङिन् के़बिरुम्‍मिल्‍ले़ कन् नुःरिक्‍काङ् खासे़न् चोःक्‍मा, वेॽ मनाहाॽ लुङ्‌माॽ तुक्‍मासि नु नसाःन् चोःक्‍मा के़लॽबा साम्‌योथिम्‍मोबा नाःप्‍माए के़बोःङ्‌बा पाःन्‍हाॽआङ् चोगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","खिनिॽ मिक्‍फःम्‍बा लाम्‍लोःबासे, खिनिॽ सिक्‍चाहाॽ के़साःक्‍तुम् के़लःत्तुम्‍सिम्, कर उमेःन् के़लरुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","खिनिॽ कुनिङ्‌वाॽ के़जिःप्‍पा साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिसे, के़जिःत्ति के़स्‍ये़ॽइरो! खिनिॽग खोर्याःन् नु चे़त्‍थ्‍याःन्‌लाःक्‍कात्‍लक् वागे़हप्‍तुम्, कर सिगाङ्‌ग इङ्‌गाॽरक् चाङ् थुङुङ् के़लॽबा निङ्‌वाॽ चोःक्‍मान्‌नु मनाहाॽ के़नाप्‍तुम् के़दाःरुम्‍सिबा पाःन्‍हाॽरे़ के़दिम्‍सिआङ्‌के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","मिक्‍फःम्‍बा फरिसिसे, के़रे़क्‍नुःल्‍ले़ तगि खोर्याःन् कुसिगाङ् वाहप्‍ते़म्‍मे़ॽ, हे़क्‍केलॽरिक् लाःक्‍कात्ताङ् सेसे पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","खिनिॽ कुनिङ्‌वाॽ के़जिःप्‍पा साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिसे, के़जिःत्ति के़स्‍ये़ॽइरो! खिनिॽग चुनि खाम्‍मिल्‍ले़ ले़ङ्‌मनाबा इःप्‍पुङ् कुइसिःक् के़जोगिॽरो, थेआङ्‌भे़ल्‍ले़ खे़न् ओमे़प्‍माल्‍ले़ लाःक्‍कात्‍लाम् नुःबा थाःप्‍साङ् सिगाङ्‌ग के़सिःबा मनाःल्‍ले़ कुये़प् नु के़जिःम्‍बा पाःन्‍निल्‍ले़ कुधिम् चोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","हे़क्‍केलॽरिक् खिनिॽ मनाहाॽनु लाःक्‍कात्‍लाम् साम्‌योनिबा के़धाबिसाङ् सिगाङ्‌ग निङ्‌वाॽ के़जिःप्‍पा नु ताप्‍फे़ःम्‍बा के़जोगिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","खिनिॽ कुनिङ्‌वाॽ के़जिःप्‍पा साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिसे, के़जिःत्ति के़स्‍ये़ॽइरो! खिनिॽ सुधे़बा ताक्‍थे़बाहाॽरे़ मे़से़रुसिबा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ खुनिॽ इप्‍पुङ्‌ङिन् के़जोगुम्, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ मे़लुःन्‍दुसिबा साम्‌योनिबा मनाहाॽरे़ खुनिॽ इप्‍पुङ्‌ङिन् के़साःक्‍तुम् के़जोगुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","हे़क्‍क्‍याङ् के़बाःत्तुम्, ‘आनिगे़ सुधे़बा ताक्‍थे़बाहाॽरे़ खुनिॽ ये़म्‍मो आनिगे़ वयिगे़ल्‍ले़ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ से़प्‍मासि चुम् मे़मे़त्तुम्‍सिम्‍बे़म्‍बा वये़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","हे़क्‍केलॽरिक् के़बाःत्तुम्‍मिल्‍ले़ खिनिॽ आबाङे आनिगे़ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ के़से़प्‍पाहाॽरे़ खुनिॽ थाःक्‍मे़न्‍छाॽसिगे़ फाॽआङ् तोःन्‍दि के़बिरुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","हे़क्‍केलॽरिक् खिनिॽ थाःक्‍थे़बाहाॽरे़ मे़हेःक्‍तुबा लायोःन् खिनिॽ के़त्ते़म्‌सुरे़म्‍मे़ॽओ! ");
INSERT INTO lifNT2_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","असेःक्‍पासे, खिनिॽ ताङ्‌बु असेःक्‍किल्‍ले़ कुस्‍साःसे, आक्‍खेलॽरिक् खे़मायङ्‌सङ्‌ङोबा खुम्‍दिङ्‌लाम् के़बिन्‍दिबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","हे़क्‍केःल्‍ले़ नुःरिक्‍काङ् खे़प्‍से़म्‍मे़ॽओ, ताःन्‍दि खिनिॽओ इङ्‌गाॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ, सिक्‍कुम्‍साबा मनाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ पाङ्‌घुङ्‌सिङ्‌लो॥ खे़ङ्‌हाॽओ कुभा खिनिॽ के़से़रुम्‍सिम्, कुभा सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् के़भोःन्‍दुम्‍सिम्, हे़क्‍क्‍याङ् कुभाग यहुदि चुम्‍लुङ्‌हिम्‍मो ते़ःम्‍भुक् के़याक्‍तुम्‍सिम्‍माङ् ये़क्‌यक् थप्‍मा निङ्‌घुम् के़मे़त्तुम्‍सिम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","हे़क्‍केलॽरिक् कन् इक्‍सादिङ् खाम्‍बेःक्‍मो मे़से़रुसिबा के़रे़क् साम्‌योनिबा मनाहाॽ हाबिले़न्‍नाङ्‌धो माङ्‌हिम् नु ले़त्तिङ्‌तोःम्‍मादे़न् लुम्‍मो के़से़रुम्‍बा बेरेक्‍याहले़ कुस्‍साः जकरिया थारिक्‍पा खुनिॽ माक्‍खिॽइल्‍ले़ खिनिॽ के़दे़त्तिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, कन् के़रे़क् पाःन्‍निल्‍ले़न्‌आप्‍तिक्‍किन् कन् ये़म्‍मोबा मनाहाॽ सम्‍दाङ् थाःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“यरुसले़म्‍मोबा मनासे, यरुसले़म्‍मोबा मनासे, खिनिॽग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ के़से़रुम्‍सिम्, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽओ पाङ्‌घुसिबा इङ्‌साबाहाॽ लुङ्‌ङिल्‍ले़ के़बःत्तुम्‍सिम्‍लो॥ आक्‍खे़न् ले़ङ् खिनिॽ मुॽइदाङ्‌साहाॽ वामाःप्‍माल्‍ले़ वाज्‍याःक्‍हाॽ कुप्‍तुसिबा कुइसिःक् खिनिॽ साःहाॽ सुम्‍मासि निङ्‌वाॽ चोगुङ्, कर खिनिॽ के़न्‍दे़न्‍दिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ओमे़त्ते़म्‍मे़ॽओ, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽ हिम्‍मिन् मना मे़ःन्‍ने लाम्‍धेःप् चिए़त्‌ए़त्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","थेआङ्‌भे़ल्‍ले़ खिनिॽ से़क्‍खाए मे़त्‍निङ्, ‘दाङ्‌बाल्‍ले़ कुमिङ्‌ङो के़दाःबान् मुॽइसाबारो’ लॽरिक् के़म्‍बाःत्तुम्‍मिन्‍ल थारिक् याम्‍मो याप्‍मि के़न्‍निःसिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ये़सुःन् माङ्‌हिम्‍मोलाम् पेर पत्‍छे़ल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ माङ्‌हिम्‍मिल्‍ले़न् नुःब्‌नुःबा हिम्‍हाॽ खुने़ॽ ओसेःन्‍धाक्‍मा फाॽआङ् कुबेसाङ् मे़द्‌ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “कन् के़निःसुम्‍बा हिम्‍हाॽरे़ कुयाःम्‍बेओ से़क्‍खा पाःन् मे़त्‍निङ्, थिक् लुङ्‌सम्‍दाङ् वेॽ लुङ्‌धिक्‍काङ् मे़न्‍ने़ए थारिक् कङ्‌हाॽ के़रे़क् मे़यः मे़बेःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","याङ्‌सि ये़सुःन् जैतुन कोःक्‍माओ वये़ल्‍ले़ कुहुॽसाम्‍बाहाॽ मे़द्‌ये़आङ् स्‍वाःत्ताङ् सेःन्‍मे़दोसु, “दाङ्‌बे, कन् पाःन्‍हाॽ आप्‍फाल्‍ले़ पोःङ्‌बाबे? खे़ने़ॽ के़युःमा ये़म्‍मिन् नु कन् इक्‍सादिङ् खाम्‍बेःक्‍मोबा ये़म्‍मिल्‍ले़ कुनुप्‍मा मिक्‍सेःन्‍निन् आमे़त्ते़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ, आत्तिल्‍ले़आङ् खिनिॽ इङ्‌गे़न्‍ले़क्‍तिन्‍लरो, ");
INSERT INTO lifNT2_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","थेआङ्‌भे़ल्‍ले़ यरिक् मनाहाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌इङ्‌गाॽएरो लॽरिक् मे़बाःत्तुर इङ्‌गाॽ आमिङ्‌ङो मे़दारो, हे़क्‍क्‍याङ् यरिक् मनाहाॽ इङ्‌मे़ले़क्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","खिनिॽग थङ् नु थङ्‌हाॽरे़न् हयङ्‌किल्‍लिङ्‌हाॽ के़घे़प्‍सुम्, कर खिनिॽ निङ्‌वाॽ मे़मये़म्‍मिन्‍ने़ॽओ॥ कङ्‌हाॽग पोःङ्‌माए पोःङ्, कर बा खे़न् ये़म्‍मोएग इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुनुप्‍मान् मे़दाने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","मे़न्‍छाम् सुवाङ्‌हाॽ नु लाजेॽहाॽ लुम्‍मो थङ् पोःक्, यरिक् ते़न्‍नो यम्‍बा साक् पोःक् हे़क्‍क्‍याङ् लुप्‍लि थाङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","कङ्‌ग के़दाःबार के़बप्‍पा किप्‍मा के़घुःबा तुक्‍खेहाॽरे़ कुहेःक्‍सिङ्‌मारक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","हे़क्‍क्‍याङ् खिनिॽग मनाहाॽरे़ के़म्‍दे़म्‍सिआङ् तुक्‍खे के़म्‍जाःत्तिॽ, हे़क्‍क्‍याङ् के़म्‍से़रिॽरो॥ खिनिॽ याप्‍मि नसाःन् के़जोगिबाल्‍ले़ चोगुल्‍ले़ के़रे़क् मे़न्‍छाम् सुवाङ्‌हाॽरे़ के़म्‍जिःत्तिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","खे़न् ये़म्‍मो यरिक् मनाहाॽ नसाःन्‍लाम् मे़नुःङ्‌ङाङ्‌इङ्‌मे़ले़क्‍सिङ्‌ङाङ् मे़जिःत्‍छिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","हे़क्‍केलॽरिक् इङ्‌ले़क्‍पा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ मे़लःन् मे़दाआङ् यरिक् मनाहाॽ इङ्‌मे़ले़क्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ताप्‍फे़ःम्‍बा पाःन्‍हाॽ पोःर पेःक्‍पाल्‍ले़ चोगुल्‍ले़ यरिक् मनाहाॽरे़ से़क्‍खा निङ्‌वाॽओनु लुङ्‌माॽ तुक्‍सिङ्‌मा मे़ले़रुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","कर आत्तिल्‍ले़ कुनुप्‍मो थारिक् थरुॽ, खे़ल्‍ले़ए से़न्‍लप् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","हे़क्‍क्‍याङ् मे़न्‍छाम् सुवाङ्‌हाॽरे़ मे़घे़प्‍सुर फाॽआङ् निङ्‌वाॽफुहाङ्‌जुम्‍ले़न् सुनाइङ्‌ङिन् इक्‍सादिङ् खाम्‍बेःक्‍को खाराक् इङ्‌भोःॽ, हे़क्‍क्‍याङ् कुनुप्‍मान् ताःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा दानिएलरे़ पाःत्तुबा सिक्‍के़ले़ःङ्‌बान् माङ्‌हिम्‍मोबा सेसे दे़न्‍नो ये़प्‍पा के़निःसुम्‍लो॥” (हाराॽ के़निःप्‍पाहाॽरे़ कन् पाःन्‍निन् कुसिङ् मे़निःत्तुररो!) ");
INSERT INTO lifNT2_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“खे़न् ये़म्‍मो यहुदियाबा मनाहाॽ कोःक्‍मा फाङ्‌जङ् हे़ङ्‌घाःत्ति मे़घे़त्‍छिङ् मे़बेःक्‍लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","खे़न् ये़म्‍मो हिम् सम्‍दाङ् के़वाॽबा मनाःन् चिगःक्‌वा लाःसे़ हिम् सिगाङ् मे़लाःत्‍ने़न्‍ल॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो के़वाॽबान् हाराॽ कुसुङ्‌घेःक्‌वा लाःसे़ कुहिम्‍मो मे़नुःङ्‌ने़न्‌मे़बेःक्‍ने़न्‍लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","कन् ये़म्‍मिङ्‌ग मे़न्‍छुक्‍मा नु सावामाहाॽरे़ लागि आक्‍खे़न् किप्‍मा के़घुःबा पोःङ्‌ङि! ");
INSERT INTO lifNT2_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","चुङ्‌वाःम्‍मा ये़म्‍मो नु नाःम्‍सिङ्‌ये़न्‍नो खिनिॽ खे़त्‍छिङ्‌मा मे़बोःङ्‌ने़न्‍ल फाॽआङ् तुवा चोगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","थेआङ्‌भे़ल्‍ले़ खे़न् ये़म्‍मो अक्‍तङ्‌बा किप्‍मा के़घुःबा तुक्‍खेःन् ताःरो॥ अक्‍तङ्‌बा तुक्‍खेःङ्‌ग इक्‍सादिङ् खाम्‍बेःक्‍मान् नावागे़न् चइःत् ने़स्‍से़आङ्धो आल्‍लो थारिक् मे़म्‍बोःङ्‌ङे वाॽ, हे़क्‍क्‍याङ् ताःन्‍दि याम्‍मो आप्‍फाल्‍ले़आङ् मे़बोःङ्‌ने़ल्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़न् ये़न्‍हाॽ ताङ्‌सा मे़जोगुन्‍निल्‍ले़ग आत्तिन् मनाहाॽआङ् हिङ्‌मा मे़न्‍छुक्‍ते़न्‍बारो॥ कर खुने़ॽ सेगुसिबाहाॽ मे़हिङ्‌ल फाॽआङ् खे़न् ये़न्‍हाॽ ताङ्‌सा पोःक्‍खे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","हे़क्‍क्‍याङ् खे़न् ये़म्‍मो मनाहाॽरे़ ‘ओमे़त्ते़म्‍मे़ॽ, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌कप्‍मो वाॽ’ इग्र ‘खुने़ॽ खे़प्‍मो वाॽ’ लॽरिक् मे़बाःत्तुर मे़दाःल्‍ले़ नसाःन् मे़जोगे़म्‍सिम्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","थेआङ्‌भे़ल्‍ले़ इङ्‌ले़क्‍पा ख्रिस्‍तहाॽ नु इङ्‌ले़क्‍पा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ मे़लःन् मे़दाआङ् पयम् यम्‍बा मिक्‍सेःन् नु निङ्‌वाॽ के़माबा पाःन्‍हाॽ मे़जोगुआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेगुसिबा मनाहाॽआङ् खुनिॽ सुक्‍सुक् इङ्‌मे़ले़क्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ओमे़त्ते़म्‍मे़ॽ, कन् पाःन्‍हाॽ पोःङ्‌मानुःल्‍ले़ तगिए खिनिॽ मे़त्‍निङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","खे़ल्‍ले़ चोगुल्‍ले़ मनाहाॽरे़ ‘ओमे़त्ते़म्‍मे़ॽ, ख्रिस्‍ते़ङ्‌ग ये़ःङ्‌घादे़न्‍नो वाॽ’ के़म्‍मे़त्तिग्र, ओमे़त्‍छे़ खे़प्‍मो मे़बेगे़म्‍मिन्‍ने़ॽओ, इग्र ‘ओमे़त्ते़म्‍मे़ॽ, खुने़ॽ कप्‍मो सिगाङ्‌बा याक्‍फाङ्‌ङो वाॽ’ के़म्‍मे़त्तिसाङ् खे़ङ्‌हाॽरे़ खुनिॽ पाःन्‍निन् नसाःन् मे़जोगे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","थेआङ्‌भे़ल्‍ले़ मे़न्‍छाम्‍साःल्‍ले़ कुयुःमाङ्‌ग साःम्‍भे ले़क्‍किल्‍ले़ के़रे़क् ताङ्‌साक्‍पे़न्‌थोॽरुबा कुइसिःक्‍के पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","आत्तो सिनुःन् ने़ॽ, खे़प्‍मोए किदाबाहाॽआङ् मे़जुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“खे़न् किप्‍मा के़घुःबा तुक्‍खेःन् एगाङ् खिमो ‘नाम्‍मिन् खामाक्‍लो, लाबाल्‍ले़ ओःत्ति मे़बिरुन्‍लो, ताङ्‌साक्‍पोबा खेःम्‍सिक्‍पाहाॽ मक्मे़धाःरो, हे़क्‍क्‍याङ् ताङ्‌साक्‍पोबा मुक्‍साम्‍हाॽ मे़यङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","हे़क्‍क्‍याङ् खे़न् ये़म्‍मो ताङ्‌साक्‍पो मे़न्‍छाम्‍साःल्‍ले़ कुयुःमाल्‍ले़न् मिक्‍सेःन्‍निन् थाःप्‍पाङ् इक्‍सादिङ् खाम्‍बेःक्‍मोबा के़रे़क् मे़न्‍छाम् सुवाङ्‌हाॽ मेरिङ् मे़धक्‍लो॥ खे़ङ्‌हाॽरे़ मे़न्‍छाम्‍साःन् ताङ्‌साक्‍पो मुक्‍साम् हे़क्‍क्‍याङ् पयम् मिमिदिङ्‌ङिन्‍नु खाप्‍मिःत्तो युःर पप्‍पा मे़निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","हे़क्‍क्‍याङ् खुने़ॽ सेगुसिबा मनाहाॽ सुम्‍से़ के़रे़क् पिसाङ्‌लाम् ताङ्‌साक्‍पाल्‍ले़ खोःप्‍तुबा नु इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ ताःक्‍तुबाओ थुत्तुरिःप्‍पाल्‍ले़न् पयम् इक्‍लानु कुमाङ्‌लाइङ्‌बाहाॽ इक्‍सादिङ् खाम्‍बेःक्‍मो पाङ्‌घु युःसुसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“आल्‍ल पःत्‍छेॽबुङ्‌मोलाम् कन् पाःन्‍निन् कुसिङ् निःत्ते़म्‍मे़ॽओ, खे़ल्‍ले़ कुबोराःक्‍हाॽलाम्‍बा कुसङ् कुनःक्‍हाॽ लःम्‍मा हेःक्‍किल्‍ले़ हाङ्‌वाःम्‍मा ये़म्‍मिन् निःत्ताङ् त्‍ये़रो फाॽआङ् कुसिङ्‌के़निःत्तुम्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","हे़क्‍केलॽरिक्‍के इङ्‌गाॽ पाःत्तुङ्‌बा कन् के़रे़क् पाःन्‍हाॽ के़त्‍ल पेःक्‍पा के़निःसुम्‍मिल्‍ले़ मे़न्‍छाम्‍साःल्‍ले़ कुयुःमान् निःत्ताङ्‌ङे वाॽ फाॽआङ् कुसिङ्‌के़निःत्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, कन् के़रे़क् पाःन्‍हाॽ मे़म्‍बोःङ्‌ङे थारिक् कन् मे़न्‍छाम् थाःक्‍हाॽ मे़न्‍छिःने़न्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ताङ्‌साक्‍पे़न्‌नु खाम्‍बेःक्‍मान् ले़क्‍काङ् पेःक्, कर इङ्‌गाॽ आबाःन्‍जाक्‍हाॽ आप्‍फाल्‍ले़आङ् मे़ले़क्‍ने़न् मे़बेःक्‍ने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“आल्‍ल खे़न् ये़म् नु ये़न्‍हाॽ आप्‍फाल्‍ले़ पोःङ् फाॽआङ् आत्तिल्‍ले़आङ् मे़निःसुन्॥ साङ्‌ग्राम्‍पेदाङ्‌बा माङ्‌लाइङ्‌बा नु निङ्‌वाॽफुसाःल्‍ले़आङ् मे़निःसुन्‍लो, कर पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़रक् निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","हे़क्‍क्‍याङ् मे़न्‍छाम्‍साःन् नुःङ् युःल्‍ले़ नुहारे़ कुये़म् हे़क्‍केए पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","नुहाःन्‌वालाधाओ लाःसे़बा ये़म्‍मो थारिक्‍के मनाहाॽ मे़जर मे़धुङुर हे़क्‍क्‍याङ् मेःक्‍खिम् मे़जोगुर मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","हे़क्‍क्‍याङ् वादोःक्‍मा थाङे़आङ् निःम्‍मा सिःमानुःल्‍ले़ तगि थे पोःङ् के़लॽबान् खे़ङ्‌हाॽरे़ थेआङ् निङ्‌वाॽ मे़ङ्‌गत्तुन्‍लो॥ बा हे़क्‍केलॽरिक्‍के मे़न्‍छाम्‍साःल्‍ले़ कुयुःमान्‍नाङ् पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","खे़न् ये़म्‍मो ने़प्‍फु मनाहाॽ प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो याःम्‍बक् चोःक्‍सुर याक्‍सिल्‍ले़ थिक्‍किन् तेॽ, वेॽस्‍मान् वाॽ लाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","हे़क्‍क्‍याङ् ने़प्‍फु मे़न्‍छुमाहाॽ लुङ्‌सुम्‍मो याॽ युःत्‍नु युङ्‌सिल्‍ले़ थिक्‍किन् तेॽ, वेॽस्‍मान् युङ्‌लाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽआङ् आप्‍फाल्‍ले़साङ् यारिप् पोःक्‍खे़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ खिनिॽ दाङ्‌बान् आप्‍फाल्‍ले़ युःबे के़लॽबान् खिनिॽ निङ्‌वाॽ के़ङ्‌गत्तुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","हिम्‍दाङ्‌बाल्‍ले़ खुःन्‍द्रिक्‍पे़न् आत्तिन् ये़म्‍मो ताः के़लॽबान् निङ्‌वाॽ खोःसुने़ फाॽग्र खे़ल्‍ले़ मे़न्‍इम्‍मे हिम्‍मिन् कोसुआङ् खे़न् खुःन्‍द्रिक्‍पे़न् खुःप्‍मा मे़बाङ्‌घुन् के़लॽबा पाःन्‍निन् कुसिङ् निःत्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽआङ् आप्‍फाल्‍ले़साङ् यारिप् वये़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ मे़न्‍छाम्‍साःन् युः फाॽआङ् मे़न्‍इःत्ते के़वयिल्‍ले़ खुने़ॽ युःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“आत्तिन् सेवारोबान् नसाःन्‍साबा नु सिक्‍कुम्‍साबा चोःक्, खे़न्‍निन् हिम्‍दाङ्‌बाल्‍ले़ कुहिम्‍धाःङ्‌हाॽ ओमे़प्‍मा युक् पिरुआङ् खे़ल्‍ले़ वेॽ सेवारोबाहाॽ ये़म्‌ये़म्‍मो चामा-थुङ्‌मा पिरुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","खे़न् हिम्‍दाङ्‌बान् नुःङ् ताःल्‍ले़ खे़न् सेवारोबाल्‍ले़ बा हे़क्‍केए चोगुर वाॽबा तुमुने़ फाॽग्र खे़न् थुम्‍घो पिरुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खे़न् हिम्‍दाङ्‌बाल्‍ले़ खे़न् सेवारोबान् के़रे़क् कुयाङ्‌साकुन्‍धे सम्‍दाङ् युक् पिरुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","कर खे़न् ताक्‍के़भे़ॽबा सेवारोबाल्‍ले़ कुनिङ्‌वाॽबो आन्‍दाङ्‌बान् माःङ्‌घा पेआङ् वाॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","हारा मे़दाने़न् लॽआङ् कुन्‍जुम् सेवारोबाहाॽ हिप्‍तुसिआङ् थिःमसाङ्‌हाॽनु चामा-थुङ्‌मा हेःक्‍तुॽने़ फाॽग्र ");
INSERT INTO lifNT2_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","खे़ल्‍ले़ कुन्‍दाङ्‌बान् ताः लॽरिक् निङ्‌वाॽ मे़इःत्तुन्‍बा ये़म्‍मो कुन्‍दाङ्‌बान् ताःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","हे़क्‍क्‍याङ् कुन्‍दाङ्‌बाल्‍ले़ खे़न् साॽरिक् ते़ःम्‍भुक् याक्‍तुआङ् कुनिङ्‌वाॽ के़जिःप्‍पाहाॽनु सोरिक् खुम्‍दिङ् पिरुॽरो॥ खे़प्‍मोग हाःप्‍मान् नु साॽरिक् तुक्‍खेःल्‍ले़ हाबोॽ ये़ःङ्‌मान् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","ये़सुरे़ याम्‍मो पाःत्तु, “साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग अक्‍तङ्‌बा चोःक्–ते़न्‍धाम्‍गे़न् मेःक्‍खिम्‍ले़न्‌नालिसाङ्‌ङिन् लाम्‍लक्‍से़ सेमि के़बङ्‌माआङ् के़बेःक्‍मा थिबोःङ् सिसागे़न्‌मे़न्‍छियाॽहाॽ मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","खे़ङ्‌हाॽओ ङासि कुनिसिःक् के़होःप्‍मा नु ङासि सिक्‍कुम्‍सामा मे़न्‍छियाॽहाॽ मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","खे़न् कुनिसिःक् के़होःप्‍मा मे़न्‍छियाॽहाॽरे़ सेमिःङ्‌ग मे़देॽरु कर निःङ्‌गेःन् मे़न्‌याङ्‌सिङ्‌ङिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","कर खे़न् ङासि सिक्‍कुम्‍सामा मे़न्‍छियाॽहाॽरे़ग सेमिःन् नु निःङ्‌गेःन् कार्‍योमाहाॽओ मे़याङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","हे़क्‍क्‍याङ् ते़न्‍धाम्‍गे़न् मेःक्‍खिम्‍ले़न्‌नालिसाङ्‌ङिन् सुःसे़आङ् हारा मे़द्‌ये़ने़न्‍निल्‍ले़ग खे़ङ्‌हाॽ इत्‍थोॽवा लोःमा मे़हेःक्‍ते़आङ् मे़इप्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","से़त्‍लुम्‍भक्‍ते़ल्‍ले़ ते़न्‍धाम्‍गे़न् नालिसाङ्‌ङिन् खा त्‍ये़रो, कुदुम्‍से़ लःन्‍दे़म्‍मे़ॽओ लॽरिक् पाःप्‍मनाबा इक्‍लाःन् मे़घे़प्‍सु, ");
INSERT INTO lifNT2_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","हे़क्‍क्‍याङ् खे़न् सिसागे़न् मे़न्‍छियाॽहाॽ मे़बोगे़आङ् खुनिॽ सेमिःन् मे़हाःन्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","खे़न् कुनिसिःक् के़होःप्‍माहाॽरे़ सिक्‍कुम्‍सामा मे़न्‍छियाॽहाॽ मे़मे़त्तुसि, ‘आनिगे़आङ् कुभा निःङ्‌गेॽ आबिरे़ॽना, आनिगे़ सेमिःङ्‌ग सिःमा इःत्ते़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","खे़न् सिक्‍कुम्‍सामा मे़न्‍छियाॽहाॽरे़ नोगप् मे़बिरुसि, ‘मे़ःन्‍लो, आनिॽ के़रे़क् के़दे़क्‍पा निःङ्‌गेॽग मे़गत्तुम्‍बे़न्‍लो॥ निःङ्‌गेॽ के़सङ्‌बाहाॽरो खिनिॽ पेगे़म्‍मे़ॽआङ् इङे़म्‍मे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","कर खे़ङ्‌हाॽ निःङ्‌गेॽ इङ्‌से़ मे़बेर मे़बत्‍छे़ल्‍ले़ए ते़न्‍धाम्‍गे़न् मेःक्‍खिम्‌रे़ नालिसाङ्‌ङिन् के़रे़ त्‍ये़रो॥ हे़क्‍क्‍याङ् खे़न् यारिप् के़बोःङ्‌मा सिसागे़न् मे़न्‍छियाॽहाॽ खुने़ॽनु मेःक्‍खिम् साभाङ्‌जाओ मे़लाःसे़आङ् लाम्‍धेःप्‍पे़न्‌सुबे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","याङ्‌सि खे़न् कुनिसिःक् के़होःप्‍मा सिसागे़न् मे़न्‍छियाॽहाॽ मे़गे़रे़ मे़द्‌ये़आङ् अक्‍खेलॽरिक् मे़अःक्‍ते़, ‘दाङ्‌बे, दाङ्‌बे, आनिगे़ लागिआङ् लाम्‍धेःप्‍पे़न्‌हन्‍दे़ आबिरे़ॽना!’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","कर खे़न् नालिसाङ्‌ङिल्‍ले़ नोगप् पिरुसि, ‘इङ्‌गाॽ से़क्‍खासाङ् कुसिङ् मे़निःत्‍निङ्‌ङिन्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","खे़ल्‍ले़ चोगुल्‍ले़ सिङ्‌सिङ् ये़क्‌ये़क्‍काङ्‌यारिप् वये़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आयुःमा ये़म्‍मिन् के़न्‍निःसुम्‍मिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","ये़सुरे़ याम्‍मो मे़त्तुसि, “साङ्‌ग्राम्‍पेदाङ्‌बा हाङ्‌जुम्‍मिङ्‌ग अक्‍तङ्‌बा चोःक्–माःङ्‌घा लाम्‍दिःक्‍को के़बेःक्‍पार के़बप्‍पा मनाधिक् वये़॥ खे़ल्‍ले़ कुसेवारोबाहाॽ उःत्तुसिआङ् कुयाङ्‌ङिन् फोःमा फाॽआङ् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","खे़ल्‍ले़ थिक्‍किन् हे़न्‍छिङ् ङासि (५०००) साम्‍म्‍याङ् याङ्‌इत्‍छि, वेॽस्‍मान् हे़न्‍छिङ् ने़त्‍छि (२०००) साम्‍म्‍याङ् याङ्‌इत्‍छि, हे़क्‍क्‍याङ् सुम्‍सिगेःक्‍पे़न्‌हे़न्‍छिङ् थिक् (१०००) साम्‍म्‍याङ् याङ्‌इत्‍छिःन्‌याङ् के़ःमा मे़ले़स्‍सुबा कुइसिःक् पिरुसिरो॥ हे़क्‍क्‍याङ् खे़न् माःङ्‌घा लाम्‍दिःक्‍को पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","खे़न् हे़न्‍छिङ् ङासि साम्‍म्‍याङ् याङ्‌इत्‍छि के़घोःबा सेवारोबान् खिमो पेआङ् खे़न् याङ्‌ङिन् के़ःसुआङ् वेॽ हे़न्‍छिङ् ङासि साम्‍म्‍याङ् याङ्‌इत्‍छि थगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","हे़क्‍केलॽरिक्‍के हे़न्‍छिङ् ने़त्‍छि साम्‍म्‍याङ् याङ्‌इत्‍छि के़घोबे़ल्‍ले़आङ् वेॽ हे़न्‍छिङ् ने़त्‍छि साम्‍म्‍याङ् याङ्‌इत्‍छि थगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","कर हे़न्‍छिङ् थिक्‍लक् साम्‍म्‍याङ् याङ्‌इत्‍छि के़घोःबा सेवारोबाङ्‌ग पेआङ् खाम्‍मिन् तयुआङ्‌कुन्‍दाङ्‌बाल्‍ले़ कुयाङ्‌ङिन् खे़प्‍मो लुप्‍तु ने़स्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","यरिक् ये़म् एगाङ् खुनिॽ दाङ्‌बान् नुःक्‍खे़ त्‍ये़आङ् कुसेवारोबाहाॽ कुयाङ्‌ङिल्‍ले़न् खाराःत् नाःक्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","खे़न् हे़न्‍छिङ् ङासि साम्‍म्‍याङ् याङ्‌इत्‍छि के़घोःबा सेवारोबे़ल्‍ले़ वेॽ हे़न्‍छिङ् ङासि साम्‍म्‍याङ् याङ्‌इत्‍छि तारुआङ् अक्‍खे मे़त्तु, ‘आदाङ्‌बे, हे़न्‍छिङ् ङासि साम्‍म्‍याङ् याङ्‌इत्‍छि के़बिराङ्‌ङाङ् वये़, कर ओमे़त्ते़ॽओ, इङ्‌गाॽ वेॽ हे़न्‍छिङ् ङासि थगुङ् पिने़आङ् वाॽरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","कुन्‍दाङ्‌बाल्‍ले़ खे़न् मे़त्तु, ‘नुःबा नु निङ्‌वाॽइरे़ खोःप्‍तुबा सेवारोबाए, नुःबा के़जोगुरो! खे़ने़ॽग मिसाक् याङ्‌ङो नसाःन्‍साबा के़बोःक्‍खे़, आल्‍ल यरिक् पाःन्‍नो युक् पिने़रो॥ आल्‍ल आनिॽ सोरिक् सःत्तिरो!’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","हे़क्‍क्‍याङ् हे़न्‍छिङ् ने़त्‍छि साम्‍म्‍याङ् याङ्‌इत्‍छि के़घोःबा कुसेवारोबाल्‍ले़ मे़त्तु, ‘आदाङ्‌बे, खे़ने़ॽग इङ्‌गाॽ हे़न्‍छिङ् ने़त्‍छि साम्‍म्‍याङ् याङ्‌इत्‍छि के़बिराङ्‌ङाङ् वये़, कर ओमे़त्ते़ॽओ, इङ्‌गाॽ वेॽ हे़न्‍छिङ् ने़त्‍छि थगुङ् पिने़आङ् वाॽरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","कुन्‍दाङ्‌बाल्‍ले़ खे़न् मे़त्तु, ‘नुःबा नु निङ्‌वाॽइरे़ खोःप्‍तुबा सेवारोबाए, नुःबा के़जोगुरो! खे़ने़ॽग मिसाक् याङ्‌ङो नसाःन्‍साबा के़बोःक्‍खे़, आल्‍ल यरिक् पाःन्‍नो युक् पिने़रो॥ आल्‍ल आनिॽ सोरिक् सःत्तिरो!’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","आल्‍ल हे़न्‍छिङ् थिक् साम्‍म्‍याङ् याङ्‌इत्‍छि के़घोःबा सेवारोबाल्‍ले़आङ् मे़त्तु, ‘आदाङ्‌बे, खे़ने़ॽग के़जिःप्‍पा के़जोःक् फाॽआङ् निःसुङ्‌ङाङ् वयाङ्‌लो॥ खे़ने़ॽ आत्तो चा के़न्‍देःसुन् खे़प्‍मो खे़ने़ॽ चा के़सुप्‍सुॽरो, आत्तो चा के़न्‍छे़सुन् खे़प्‍मोए चा के़भुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","खे़ल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽ किःसाङ्‌ङाङ् के़याङ्‌ङिन् तेॽरुङ्‌ङाङ् खाम्‍मो चिक्‍खुङ्॥ ओमे़त्ते़ॽ, खे़ने़ॽ के़याङ्‌ङिन् खा कप्‍मो वाॽरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","खे़ल्‍ले़ कुन्‍दाङ्‌बाल्‍ले़ खे़न् नोगप् पिरु, ‘खे़ने़ॽ ताक्‍के़भे़ॽबा नु कुले़म्‍गे़युबा सेवारोबाए! खे़ने़ॽग इङ्‌गाॽ आत्तो चा मे़देःआन् खे़प्‍मो चा सुप्‍सुङ्, आत्तो चा मे़से़ःसुङ्‌ङिन् खे़प्‍मो चा फुक्‍खुङ् फाॽआङ् के़निःसुआङ्‌ङे के़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","हे़क्‍केःल्‍ले़ आयाङ्‌ङिन् के़देॽरुआङ् सिङ्‌नाःत् के़गे़बाहाॽरो के़युक्‍खुल्‍ले़ पोःक्‍खे़बारो॥ हे़क्‍के के़जोगुल्‍ले़ इङ्‌गाॽ नुःक्‍खाङ् त्‍याङ्‌ङिल्‍ले़ आयाङ्‌ङिल्‍ले़ कुस्‍साःग खोःसुङ्‌बा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","कन् सेवारोबाल्‍ले़ कत्तुबा याङ्‌ङिन् नाप्‍ते़म्‍मे़ॽआङ् थिबोःङ् हे़न्‍छिङ् साम्‍म्‍याङ् याङ्‌इत्‍छि के़गप्‍पे़न्‌पिरे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","थेआङ्‌भे़ल्‍ले़ के़गप्‍पाल्‍ले़ आल्‍लसाङ् यरिक् खोःसुआङ् खे़ल्‍ले़न् यरिक् पोःङ्‌लो॥ कर हाःत्‍ले़ मे़गत्तुन्, खे़ल्‍ले़ कत्तुबान्‍नाङ् नाप्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","आल्‍ल खे़न् इनाःम्‍बा सेवारोबान् लाःक्‍कात् खादाम्‍मो लाप्‍फुःसे़म्‍मे़ॽ॥ खे़प्‍मो हाःप्‍मान् नु साॽरिक् तुक्‍खेःल्‍ले़ हाबोॽ ये़ःङ्‌मान् पोःङ्‌लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“मे़न्‍छाम्‍साःन् कुमिमिदिङ्‌ङो के़रे़क् कुमाङ्‌लाइङ्‌बाहाॽनु युःल्‍ले़ खुने़ॽ मिमिदिङ्‌गे़न् कुहाङ्‌युक्‍नाओ युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","इक्‍सादिङ् खाम्‍बेःक्‍मोबा के़रे़क् मे़न्‍छाम् सुवाङ्‌हाॽ खुने़ॽ कुदगि मे़जुम्‍लो॥ हे़क्‍क्‍याङ् मे़ल्‍लुक्‍कम्‍बाल्‍ले़ मे़ल्‍लुक्‍हाॽ मे़न्‍दाक्‍हाॽलाम् से़न्‍दुसिबा कुइसिःक् मनाहाॽ से़न्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","कुजुप्‍साङ् ले़प्‍माङ् मे़ल्‍लुक्‍हाॽ नु कुभे़न्‍छाङ् ले़प्‍माङ् मे़न्‍दाक्‍हाॽ से़न्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","हे़क्‍क्‍याङ् हाङ्‌ङिल्‍ले़ कुजुप्‍साङ् ले़प्‍माङ्‌बाहाॽ मे़त्तुसि, ‘पानुदिङ् आम्‍बारे़ मुॽइसाम् पिरुसिबासे, त्‍ये़म्‍मे़ॽओ, नावागे़न्‌चइःत् ने़स्‍से़आङ्धो खिनिॽ लागि यारिप् चोःक्‍मनाबा हाङ्‌जुम्‍मिन् युक्‍ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आसे़त्‍लाःक्‍ते़आङ् वयाङ्‌ङिल्‍ले़ इङ्‌गाॽ कुजा याप्‍मि आगे़बिरि, आवामिःसे़आङ् वयाङ्‌ङिल्‍ले़ च्‍वाःत् याप्‍मि आगे़बिरि, इङ्‌गाॽ वाॽमा ते़न् मे़ःन्‍ने लाम्‍दिःक्‍पा पोःक्‍खाङ्‌ङाङ् वयाङ्‌ङिल्‍ले़ खिनिॽ हिम्‍मो याप्‍मि आगे़देॽरिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","हे़क्‍क्‍याङ् इङ्‌गाॽ तेःप्‍फुङ् मे़ःन्‍ने वयाङ्‌ङिल्‍ले़ तेःत् याप्‍मि आगे़बिरि, इङ्‌गाॽ तुगाङ्‌ङाङ् वयाङ्‌ङिल्‍ले़ याप्‍मि कम्‍ब्राङ् आगे़मे़त्ति, हे़क्‍क्‍याङ् पुङ्‌लाहिम्‍मो मे़साक्‍ताङ्‌ङाङ् यागाङ्‌ङिल्‍ले़ याप्‍मि आगे़साॽरिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","हे़क्‍क्‍याङ् खे़न् साम्‌योनिबाहाॽरे़ खुने़ॽ नोगप् मे़बिरु, ‘दाङ्‌बे, आप्‍फाल्‍ले़ खे़ने़ॽ साक्‍मे़न्‍जा निःआसिगे़आङ् कुजा पिआसिगे़बे? के़वामिःसे़बा निःआसिगे़आङ् च्‍वाःत् थुङ्‌मा पिॽआसिगे़बे? ");
INSERT INTO lifNT2_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","हिम्‍धाःङ् मे़ःन्‍ने लाम्‍दिःक्‍पा के़बोःक्‍खे़बा निःआसिगे़आङ् हिम्‍मो तेॽआसिगे़बे? आप्‍फाल्‍ले़ तेःत् मे़ःन्‍ने निःआसिगे़आङ् तेःत् पिॽआसिगे़बे? ");
INSERT INTO lifNT2_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","आप्‍फाल्‍ले़ खे़ने़ॽ के़दुगे़बा नु पुङ्‌लाहिम्‍मो के़यागे़बा निःआसिगे़आङ् साॽआसिगे़बे?’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","हे़क्‍क्‍याङ् हाङ्‌ङिल्‍ले़ खे़ङ्‌हाॽ मे़त्तुसि ‘इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, कङ्‌हाॽओ के़वाॽबा आम्‍भुॽ आन्‍साॽसिओ लत्‍छा चुक्‍पाधिक् च्‍या के़मे़त्तुम्, खे़न् इङ्‌गाॽए याप्‍मि आगे़मे़त्तिबारो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","हे़क्‍क्‍याङ् हाङ्‌ङिल्‍ले़ कुभे़न्‍छाङ् ले़प्‍माङ्‌बाहाॽ मे़त्तुसि, ‘खिनिॽ निङ्‌वाॽफु साक्‍मुराःल्‍ले़ के़दे़त्तिबासे, खिनिॽ इङ्‌गाॽओलाम् पेगे़म्‍मे़ॽओ॥ खिनिॽग माफे़न्‍साम्‍मिन् नु खुने़ॽ कुमाङ्‌लाइङ्‌बाहाॽ केःप्‍मासि फाॽआङ् यारिप् चोगुबा आप्‍फाल्‍ले़आङ् मे़न्‍छिःमना मि के़दिःप्‍पा खे़मायङ्‌सङ्‌ङो पेगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आसे़त्‍लाःक्‍ते़आङ् वयाङ्‌ङिल्‍ले़ इङ्‌गाॽ कुजा याप्‍मि आगे़म्‍बिरिन्, आवामिःसे़आङ् वयाङ्‌ङिल्‍ले़ च्‍वाःत् थुङ्‌मा याप्‍मि आगे़म्‍बिरिन्, ");
INSERT INTO lifNT2_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","इङ्‌गाॽ वाॽमा ते़न् मे़ःन्‍ने लाम्‍दिःक्‍पा पोःक्‍खाङ्‌ङाङ् वयाङ्‌ङिल्‍ले़ खिनिॽ हिम्‍मो याप्‍मि आगे़न्‍देॽरिन्, इङ्‌गाॽ तेःप्‍फुङ्‌मे़ःन्‍ने वयाङ्‌ङिल्‍ले़ तेःत् याप्‍मि आगे़म्‍बिरिन्, हे़क्‍क्‍याङ् इङ्‌गाॽ तुगाङ् हे़क्‍क्‍याङ् पुङ्‌लाहिम्‍मो साक्‍ताङ्‌ङाङ् यागाङ्‌ङिल्‍ले़ याप्‍मि आगे़न्‍छाॽरिन्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़आङ् नोगप् मे़बिरु, ‘दाङ्‌बे, आप्‍फाल्‍ले़ आनिगे़ खे़ने़ॽ के़से़त्‍लाःक्‍ते़बा नु के़वामिःसे़बा हे़क्‍क्‍याङ् वाॽमा ते़न् मे़ःन्‍ने नु तेःप्‍फुङ् चाहाबा के़जोगे़बा, के़दुगे़बा नु पुङ्‌लाहिम्‍मो के़यागे़बा निःसुम्‍बे़आङ् कुभाॽ मे़बिआसिगे़न्बे?’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","खे़न् ये़म्‍मो खुने़ॽ नोगप् पिरुसि, ‘इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, कन् आम्‍भुॽ आन्‍साॽसिओ आत्तिन् लत्‍छा चुक्‍साधिक् हे़क्‍के के़म्‍मे़त्तुम्‍मिन्, खे़न् इङ्‌गाॽए याप्‍मि आगे़म्‍मे़त्तिम्‍बारो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","हे़क्‍क्‍याङ् खे़ङ्‌हाॽग मे़न्‍नुप्‍मनाबा खुम्‍दिङ्‌ङो मे़बेःक्‍लो, कर साम्‌योनिबाहाॽग मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍नो मे़बेःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ये़सुरे़ कन् के़रे़क् पाःन्‍हाॽ पाःत्तु सुरुआङ् खुने़ॽ कुहुॽसाम्‍बाहाॽ अक्‍खे मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मिन् ताःमा निये़न्‍लक् वाॽबाग खिनिॽ के़निःसुम्‍मेरो, हे़क्‍क्‍याङ् मे़न्‍छाम्‍साःन् सिलाम्‍साक्‍मा सिङ्‌ङो फोःन्‍छे़ हुक्‍मे़सुप्‍तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","खे़न् ये़म्‍मो तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽ मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुहिम्‍मो मे़जुप्‍से़॥ खे़ल्‍ले़ कुमिङ्‌ग कैयाफास वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ये़सुःन् आक्‍खेलॽरिक् स्‍वाःत्ताङ् ते़म्‍माआङ् से़प्‍माबे फाॽआङ् चे़म्‍भन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","कर खे़ङ्‌हाॽरे़ मे़बाःत्तु, “कन् तङ्‌नाम्‍मोग आनिॽ हे़क्‍के चोःक्‍मा मे़नुॽने़न्‍लो, मे़ःन्‍ने़ फाॽग्र कन् मनाहाॽरे़ हयङ्‌किल्‍लिङ् मे़जोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","खे़न् ये़म्‍मो ये़सुःन् बे़थानि पाङ्‌भेॽओ लोगेॽ तुक्‍मालाम् के़वेःप्‍पा सिमोनरे़ कुहिम्‍मो वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","हे़क्‍क्‍याङ् चाजानु युङे़ल्‍ले़ मे़न्‍छुमाॽधिक् इमे़ल्‍लुङ्‌बा फुङ्‌नाम्‌के़याक्‍पा ले़म्‍भालुङ् पर्यामानु त्‍ये़आङ् ये़सुरे़ कुधे़गेःक्‍पो हुक्‍खुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","खे़न् मे़निःसुआङ् कुहुॽसाम्‍बाहाॽरे़ खुनिॽ सिक् पोगे़आङ् अक्‍खे मे़बाःत्तु, “थेआङ् कन् फुङ्‌नाम्‍मिन् चासोःक्‍खुबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","कङ्‌ग यरिक् याङ्‌ङो सङ्‌माआङ् याङ्‌गे़साॽबाहाॽ पिःमनासिल्‍ले़ पोःक्‍खे़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ये़सुरे़ कन् निङ्‌वाॽ खोःसुआङ् खे़ङ्‌हाॽ नोगप् पिरुसि, “थेआङ् कन् मे़न्‍छुमाॽइन् तुक्‍खे के़जाःत्तुम्‍बाबे? खे़ल्‍ले़ग आलागि नुःबा चोगुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","याङ्‌गे़साॽबाहाॽग सदादिङ् खिनिॽनु मे़वाॽरो॥ कर इङ्‌गाॽग सदादिङ् खिनिॽनु मे़वाॽआन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","खे़ल्‍ले़ नासिङ्‌गे़न् आधक्‍को फुङ्‌नाम्‍मिन् हुक्‍खुआङ् आलुप्‍माल्‍ले़न् यारिप् चोगुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, इक्‍सादिङ् खाम्‍बेःक्‍मो आत्तिसाङ् सुनाइङ् इङ्‌भोःल्‍ले़, खे़प्‍मो कन् मे़न्‍छुमाॽइल्‍ले़ चोगुबा कुयाःम्‍बक्‍किन् मनाहाॽरे़ मे़जे़क्‍खुआङ् निङ्‌वाॽ मे़इःत्तुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","हे़क्‍क्‍याङ् थिक्-ने़त् कुहुॽसाम्‍बाहाॽओ यहुदा इस्‍करियोत मे़प्‍मनाबे़न् तुम्निङ्‌वाॽफुसाम्‍बाहाॽरो पेआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","मे़त्तसि, “ये़सुःन् के़दे़म्‍सुम्‍ल फाॽआङ् खिनिॽ हुक्‍को थाःसुङ् पिनिङ्‌ङिल्‍ले़ इङ्‌गाॽ थे याप्‍मि आगे़बिरिबे?” हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ सुम्‍बोःङ् (३०) युप्‍पायाङ् खे़न् मे़बिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","खे़न् ये़म्‍माङ्धो यहुदाःल्‍ले़ ये़सुःन् इङ्‌ले़क्‍मा फाॽआङ् सुये़म् कोःप्‍मा हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","आल्‍ल सिदाॽ मे़न्‍भःन्‍नेबा खरे़ःङ् चामा तङ्‌नाम्‍मिल्‍ले़ थिक्‍सिगेःक्‍पा ये़न्‍नो ये़सुरे़ कुहुॽसाम्‍बाहाॽ खुने़ॽओ मे़द्‌ये़आङ् सेःन्‍मे़दोसु, “दाङ्‌बे, यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‌रे़न्‌ चामा थुङ्‌मा आत्तो यारिप् चोःक्‍मा के़लॽबा निङ्‌वाॽ के़इःत्तुआङ् वाॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ ये़क्‌यक्‍को पेगे़म्‍मे़ॽ, खे़प्‍मो लत्‍छा मनाधिक् के़दुमुम्॥ खे़न् अक्‍खे मे़त्ते़म्‍मे़ॽ, ‘दाङ्‌बाल्‍ले़ अक्‍खे पाःत्तुआङ् वाॽ, इङ्‌गाॽ आये़म्‍मिन् निःत्ताङ्‌ङे त्‍ये़आङ् वाॽरो, खे़ल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽ खे़ने़ॽ के़हिम्‍मो आहुॽसाम्‍बाहाॽनु यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‌रे़न्‌ससाङ्‌स्रोःत् चोगुम्‍बे़ॽरो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","हे़क्‍केःल्‍ले़ हुॽसाम्‍बाहाॽरे़ ये़सुरे़ पाःत्तुबा कुइसिःक्‍के यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‌रे़न्‌चामा थुङ्‌मान्‌यारिप् चोगे़त्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","हे़क्‍क्‍याङ् युःन्‍छिक् ये़सुःन् थिक्-ने़त् कुहुॽसाम्‍बाहाॽनु सोरिक् चामा ते़न्‍नो युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","हे़क्‍क्‍याङ् मे़जर मे़युङे़ल्‍ले़ अक्‍खे मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खिनिॽओ थिक्‍किल्‍ले़ इङ्‌गाॽ इङ्‌ले़क्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽ साॽरिक् निङ्‌साम्‍मो मे़ध्‍ये़आङ्‌के़रे़क्‍ले़ खुने़ॽ सेःन्‍दोःमा मे़हेःक्‍तु, “दाङ्‌बे, के़बाःत्तुबा मनाःन् इङ्‌गाॽबि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “आल्‍लो इङ्‌गाॽनु सोरिक् के़जाबार के़युङ्‌बाधिक्‍किल्‍ले़ इङ्‌गाॽ इङ्‌ले़क्‍कारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","मे़न्‍छाम्‍साःङ्‌ग साम्‌योसाप्‍लाओ साप्‍ते़बा कुइसिःक्‍के सिःमाए पोःङ्‌लो॥ कर मे़न्‍छाम्‍साःन् इङ्‌गे़ले़क्‍पे़ङ्‌ग चिःत्ते़ स्‍ये़रो! खे़ङ्‌ग सामे़वाःन्‍छिङ्‌ङिन्‍निल्‍ले़ नुरे़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","हे़क्‍क्‍याङ् से़क्‍खाओ खुने़ॽ इङ्‌ले़क् के़मे़प्‍पा यहुदाःल्‍ले़आङ् सेःन्‍दोसु, “सिक्‍साम्‍बे, के़बाःत्तुबा मनाःन् इङ्‌गाॽएबि?” ये़सुरे़ नोगप् पिरु, “खे़ने़ॽ आबाङे के़बाःत्तुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","खे़ङ्‌हाॽरे़ मे़जर मे़युङे़ल्‍ले़ ये़सुरे़ खरे़ःङ्‌ङिन् खप्‍सुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरु, हे़क्‍क्‍याङ् खे़ःक्‍खुआङ् कुहुॽसाम्‍बाहाॽ अक्‍खे मे़त्तुसिर पिरुसि, “कन् ताःक्‍ते़म्‍मे़ॽआङ् चे़म्‍मे़ॽओ, कङ्‌ग नासिङ्‌गे़न् आधक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","हे़क्‍क्‍याङ् चल्‍लङ्‌ना खोर्याःन् पक्‍खुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरु, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ अक्‍खे मे़त्तुसिर पिरुसि, “खिनिॽ के़रे़क्‍ले़ कन् थुङे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","कन् निङ्‌वाॽफुमाङ्‌ङिन्‍नु चोःक्‍मनाबा कुसङ् माङ्‌हुप्‍ले़न्‌आमाक्‍खिॽरो॥ कन् यरिक् मनाहाॽरे़ खुनिॽ लायोःन् ले़प्‍मि पोःङ्‌ल फाॽआङ् वादेःन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","इङ्‌गाॽ मे़त्‍निङ्, आइन्‍नाङ्‌धो पानुदिङ् आम्‍बारे़ कुहाङ्‌जुम्‍मो खिनिॽनु कुसङ् चे़ल्‍ले़क्‍सेॽ थिःन् मे़न्‍धुङ्‌ङे थारिक् याम्‍मो चे़ल्‍ले़क्‍सेॽ थिःन् मे़धुङ्‌ङान्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ माङ्‌सेवा साम्‍लो साम्‍मे़लोरे़आङ् जैतुन कोःक्‍माओ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","खे़प्‍मो ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आइन् से़न्‍दिक्‍सा खिनिॽ के़रे़क्‍ले़ इङ्‌गाॽ याप्‍मि के़ले़रिॽआङ् के़बिगिॽरो॥ थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ साम्‌योसाप्‍लाओ अक्‍खे पाःत्तुआङ् पत्, ‘इङ्‌गाॽ मे़ल्‍लुक्‍कम्‍बान् हिप्‍तुङ्, हे़क्‍क्‍याङ् के़रे़क् मे़ल्‍लुक्‍हाॽ के़रे़क् पिसाङ् मे़से़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","कर इङ्‌गाॽ कुसिवे़त्‍लाम् कुहिङ्‌वे़त् पोःङ्‌ङाआङ् खिनिॽनुःल्‍ले़ तगि गालिल थुम्‍मो पेःक्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","पत्रुसरे़ नोगप् पिरु, “के़रे़क्‍ले़ खे़ने़ॽ के़म्‍ले़त् के़म्‍धाःसाङ् इङ्‌गाॽग आप्‍फाल्‍ले़आङ् मे़ले़त्‍ने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ये़सुरे़ मे़त्तु, “पत्रुसे, से़क्‍खाए मे़त्‍ने़ॽ, आक्‍खो से़न्‍दिक् इङ्‌वा काःमानुःल्‍ले़ तगिए, खुने़ॽ कुसिङ् मे़निःत्तुङ्‌ङिन् के़बाःत्तुर खे़ने़ॽ सुम्‍ले़ङ् के़नाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","कर पत्रुसरे़ हादिङ् थक्‍ते़र मे़त्तु, “मे़ःन्‍लो, इङ्‌गाॽग खे़ने़ॽनु सिःमा पोःङ्‌साङ् आप्‍फाल्‍ले़आङ् मे़नाॽने़न्‍लो॥” वेॽ हुॽसाम्‍बाहाॽरे़आङ् बा हे़क्‍केए मे़बाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","हे़क्‍क्‍याङ् ये़सुःन् कुहुॽसाम्‍बाहाॽनु गे़तसमनि मे़प्‍मनाबा जैतुन सिङ्‌लाओ पे, हे़क्‍क्‍याङ् खुने़ॽ खे़ङ्‌हाॽ अक्‍खे मे़त्तुसि, “इङ्‌गाॽ खे़प्‍मो तुवा चोगुङ्‌ङिल्‍ले़ खिनिॽ कप्‍मो युङे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ये़सुरे़ पत्रुसे़न् नु जब्‍दियारे़ ने़प्‍फु कुस्‍साःहाॽ खुने़ॽनु तेॽरुसि, हे़क्‍क्‍याङ् खुने़ॽ साॽरिक् मिङ्‌वारे़ कुधिम्नु निङ्‌साम्‍मो थ्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ अक्‍खे मे़त्तुसि, “इङ्‌गाॽग मिङ्‌वारे़ योःन्‍दाङ्‌ङाङ् सिःमालिङ्‌धो थारिक् के़राङ्‌ङाङ् वाॽआरो॥ कप्‍मो चाङ्‌जाङ्‌ङाङ् युङे़म्‍मे़ॽर याप्‍मि चुम् आमे़त्ते़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","खुने़ॽ याम्‍मो मिसाक् नानाक् पेआङ् खाम्‍मो साम्‍बोःन् फन्‍छिङ्‌ङाङ्‌अक्‍खेलॽरिक् तुवा चोगे़रो, “पानुदिङ् आम्‍बे, पोःङ्‌मा सुक्‍ने़ फाॽग्र, कन् इनोगे़न् तुक्‍खेरे़न् खोर्याःन् इङ्‌गाॽओलाम् खे़त्ते़देःसे़ॽओ॥ हे़क्‍केसाङ् आनिङ्‌वाॽ हे़क्‍केग मे़ःन्, कर के़निङ्‌वाॽ हे़क्‍केए पोःङ्‌लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","हे़क्‍क्‍याङ् खुने़ॽ नुःक्‍खे़ फे़रे़ल्‍ले़ कुहुॽसाम्‍बाहाॽ मे़इप्‍से़आङ् मे़ने़स्‍से़बा तुमुसि॥ ये़सुरे़ पत्रुसे़न् मे़त्तु, “खिनिॽ कुमुक्‍थिक्‍काङ् इङ्‌गाॽनु चाङ्‌जाङ्‌ङाङ् युङ्‌मा के़न्‍छुक्‍तिन्बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","हङ्‌साॽमाओ मे़ध्‍ये़ॽइगे़न्‍ल फाॽआङ् निङ्‌वाॽ चाङ्‌जाङ्‌ङाङ् तुवा चोगे़म्‍मे़ॽओ॥ खिनिॽ निङ्‌वाॽइल्‍ले़ नुःरिक्‍काङ् चोःक्‍मा के़गोःत्तुम्, कर खिनिॽ नासिङ्‌गे़न् थक्‍किङ्‌ग मे़धुम्‍मिन्‍बाल्‍ले़ चोगुल्‍ले़ के़न्‍छुक्‍तुम्‍मिल्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","खुने़ॽ याम्‍मो पेआङ् तुवा चोगु, “पानुदिङ् आम्‍बौ, इङ्‌गाॽ कन् इनोगे़न् तुक्‍खेरे़न् खोर्याःन् मे़न्‍धुङ्‌ङे मे़बोःङ्‌ङिन्‍ने़ फाॽग्र खे़ने़ॽ के़निङ्‌वाॽ कुइसिःक्‍के पोःङ्‌लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","खुने़ॽ नुःक्‍खे़ फे़रे़ल्‍ले़ याम्‍मो कुहुॽसाम्‍बाहाॽ मे़इप्‍से़आङ् मे़ने़स्‍से़बा तुमुसि, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ मिक्‌युःमाल्‍ले़ साॽरिक् तरुसिआङ् मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","खे़ल्‍ले़ चोगुल्‍ले़ खुने़ॽ खे़ङ्‌हाॽ ले़रुधसिआङ् याम्‍मो तुवा चोःक्‍से़ पेआङ् तगि हे़क्‍के तुवा चोगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","हे़क्‍क्‍याङ् खुने़ॽ नुःक्‍खे़ फे़रे़आङ् कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “खिनिॽ आल्‍लसाङ् के़नासिङ्‌ङिआङ् के़इप्‍सिआङ् के़ने़स्‍सिबि? ओमे़त्ते़म्‍मे़ॽ, इङ्‌गाॽ मे़न्‍छाम्‍साःन् लायोबाहाॽरे़ खुनिॽ हुक्‍को थाःमा ये़म्‍मिन् त्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","पोगे़म्‍मे़ॽ, कप्‍मोलाम् पिगि! ओमे़त्ते़म्‍मे़ॽ, इङ्‌गाॽ याप्‍मि इङ्‌गे़ले़क्‍पे़न्‌खा फे़न्‍ल पत्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ये़सुःन् हे़क्‍केलॽरिक् पारे़र पत्‍छे़ल्‍ले़ थिक्-ने़त् कुहुॽसाम्‍बाहाॽओबा यहुदा मे़प्‍मनाबे़न् खे़प्‍मो के़रे़ त्‍ये़॥ खुने़ॽनु तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽरे़ मे़बाङ्‌घुसिबा ताभे नु तक्‍काःत् के़गप्‍पा यरिक् मनाहाॽआङ् मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","आल्‍ल ये़सुःन् इङ्‌गे़ले़क्‍पे़ल्‍ले़ आत्तिन् मनाःन् इङ्‌गाॽ चुप् मे़त्तुङ्, खे़न् ते़म्‍से़म्‍मे़ॽ लॽरिक् मिक्‍सेःन् पिरुसिआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","खिमो यहुदाःन् ये़सुरो पेआङ् “आसेवारो, सिक्‍साम्‍बे” मे़त्तुर चुप् मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़न् मे़त्तु, “चुम्‍मे, खे़ने़ॽ थे चोःक्‍से़ के़द्‌ये़बा खे़न् हारा चोगे़ॽओ॥” हे़क्‍क्‍याङ् वेॽ मनाहाॽरे़ ये़सुःन् हुक् मे़याक्‍तुआङ्‌मे़दे़म्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ये़सुःन्‍नु के़वाॽबाहाॽओ थिक्‍ले़ ताभेःन् तरप् फिःक्‍खुआङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुसेवारोबान् चे़प्‍तुल्‍ले़ कुने़क्‍खोॽबान् पे़त्तु थाःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ये़सुरे़ खे़न् मे़त्तु, “के़दाभेःन् फे़सिःप्‍पो याक्‍ते़ॽ, थेआङ्‌भे़ल्‍ले़ आत्तिल्‍ले़ ताभेःन् ओगप् चोगुॽ, खे़न् ताभेलाम्‍मे सिःॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","इङ्‌गाॽ पानुदिङ् आम्‍बाःन् नाःक्‍तुङ्‌ङिल्‍ले़ माङ्‌लाइङ्‌बाहाॽरे़न् थिक्-ने़त् तुरानुःल्‍ले़ यरिक् इङ्‌गाॽ याप्‍मि ताङ्‌से़ःप्‍से़ खिमो मे़बाङ्‌घुन्‍सिन्बि? ");
INSERT INTO lifNT2_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","कर हे़क्‍केलॽरिक् नाःक्‍तुङ्‌ङिल्‍ले़ साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् पोःङ्‌माए पोःङ् लॽरिक् साप्‍ते़बान् आक्‍खेआङ् के़प्‍पाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","हे़क्‍क्‍याङ् ये़सुरे़ कुदे़म्‍से़ के़दाःबा मनाहाॽ मे़त्तुसि, “इङ्‌गाॽ हाङ्‌बिफ्‍युङ् के़जोःक्‍पाआबि? थेआङ् इङ्‌गाॽ आदे़म्‍से़ ताभेनु तक्‍काःत्‍नु के़द्‌ये़ॽइबे? इङ्‌गाॽग थिक्‌याःन्‍धक्‍सा माङ्‌हिम् लक्‍खुम्‍मो निसाम् हुॽइसे़ वयाङ्‌बा हे़क्‍केसाङ् याप्‍मि के़न्‍दे़म्‍सिन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","कर कङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ मे़साप्‍तुबान् के़त्‍ल फाॽआङ् पोःक्‍खे़बारो॥” हे़क्‍क्‍याङ् के़रे़क् कुहुॽसाम्‍बाहाॽरे़ पक्‍मे़धःआङ् मे़घे़त्‍छिङ् मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","हे़क्‍क्‍याङ् ये़सुःन् के़दे़म्‍बाहाॽरे़ खुने़ॽ मानिङ्‌वाॽफुसाम्‍बा कैयाफासरे़ कुहिम्‍मो मे़देॽरु॥ खे़प्‍मो साम्‌योथिम्‍साम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽ मे़जुप्‍से़आङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","कर पत्रुसरे़ग ये़सुःन् नु खे़न् मनाहाॽ मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुलक्‍खुम्‍मो थारिक् माःङ्‌घालाम् तिम्‍दुसिरो॥ हे़क्‍क्‍याङ् आल्‍ल ये़सुःन् थे मे़मे़त्तुइला लॽरिक् ओमे़त्‍छे़ सिगाङ् लाःसे़आङ् सेवारोबाहाॽनु युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","आल्‍ल तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि ये़जुम्‍भोरे़न् के़रे़क् पासिङ्‌पादाङ्‌लाहाॽरे़ ये़सुःन् सिःमे़ल्‍ले़न् खुम्‍दिङ् पिमा फाॽआङ् खुने़ॽ कुदक्‍ले़ङ्‌वाओबा आप्‍तिक्‍हाॽ मे़गोःत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","खे़प्‍मो यरिक् फोत्‍याबा आप्‍तिक् के़गुःप्‍पाहाॽ मे़लःन्‍दे़, कर खे़ङ्‌हाॽरे़ थेआङ् तसि मे़ङ्‌घोःसुन्॥ कुनुप्‍मो ने़प्‍फु मना लःन्‍दे़त्‍छिआङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","पाःत्ते़त्‍छु, “कन् मनाःल्‍ले़ निङ्‌वाॽफु माङ्‌हिम्‍मिन् यःमा सुक्‍तुङ्, हे़क्‍क्‍याङ् सुम्‌ये़न्‍नो याम्‍मो चोःक्‍मा सुक्‍तुङ्‌लो लॽरिक् पाःत्तुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","हे़क्‍क्‍याङ् मानिङ्‌वाॽफुसाम्‍बान् पोगे़आङ् ये़सुःन् सेःन्‍दोसु, “कन् मनाहाॽरे़ के़दक्‍ले़ङ्‌वाओ पिरे़त्‍छुबा तोःन्‍दिल्‍ले़ कुयाःम्‍बेओ थेआङ् खे़ने़ॽ नोगप् के़म्‍बिरुन्‍छिन्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","कर ये़सुःन् मे़म्‍बाःत्ते ये़बे़॥ हे़क्‍केःल्‍ले़ मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ मे़त्तु, “आजुनि निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमिङ्‌ङो खे़ने़ॽ इङ्‌जाःङ् पिने़, से़क्‍खाए आमे़त्ते़ॽ, खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा निङ्‌वाॽफुसाःने़बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","हे़क्‍केःल्‍ले़ ये़सुरे़ नोगप् पिरु, “ओरो, खे़ने़ॽ आबाङे हे़क्‍के के़बाःत्तुॽरो॥ कर इङ्‌गाॽ मे़त्‍निङ्, ताःन्‍दि इङ्‌गाॽ मे़न्‍छाम्‍साःन् मुक्‍साम्‍दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुजुप्‍साङ् ले़प्‍माङ् युङ्‌ङाॽबा नु साङ्‌ग्राम्‍पेदाङ्‌ङोनु खाप्‍मिःत्तो युःआबा के़निःसुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","हे़क्‍क्‍याङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुसाक्‍के़न् ओसेःन्‍धाक्‍तुसिर आबाङे कुदेःत्तिन् थे़ःक्‍खुआङ्‌अक्‍खे पाःत्तु, “कल्‍ले़ग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पाःन्‌पाःत्तुरो! आल्‍ल आनिॽ वेॽ तोःन्‍दिहाॽ थेआङ् चाहाबा आजोगे़बे? कल्‍ले़ग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पाःन्‌पाःत्तुबान् खिनिॽ के़घे़प्‍सुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","कन् पाःन्‍नो खिनिॽ थे के़बाःत्तुम्?” खुने़ॽ सिःमाए पोःङ्‌फाॽआङ् खे़ङ्‌हाॽरे़ नोगप् मे़बिरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ये़सुःन् कुनाराओ थे़त् मे़धोःक्‍तुर हुक्‍पुत्तिल्‍ले़ मे़लक्‍तु॥ हे़क्‍क्‍याङ् कुभारे़ग कुने़दे़ङ्‌बान् मे़ले़क्‍खुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","अक्‍खे मे़बाःत्तु, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते, ल आल्‍ल माङ्‌निङ्‌वाॽपाःन् पारे़ॽ! खे़ने़ॽ हाःत्‍ले़ के़हिप्‍ते़?” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","आल्‍ल पत्रुसे़न् लाःक्‍कात् लक्‍खुम्‍मो युङे़ल्‍ले़ खे़प्‍मो सेवारोमा चुक्‍माधिक् फे़रे़आङ् मे़त्तु, “खे़ने़ॽआङ् गालिलस्‍मा ये़सुःन्‍नुए के़वये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","कर पत्रुसरे़ के़रे़क्‍ले़ खुनिॽ तगि खे़न् पाःन्‍निन् नाॽरुर मे़त्तु, “खे़ने़ॽ के़बाःत्तुबान् कुसिङ् मे़न्‍निःप्‍पे़न्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","हे़क्‍क्‍याङ् खुने़ॽ लक्‍खुम्‍मोलाम् ताःक्‍हन् ले़प्‍माङ् पे॥ खे़प्‍मो वेॽस्‍मा सेवारोमा चुक्‍मे़ल्‍ले़ खुने़ॽ निःसुआङ् वेॽ मनाहाॽ मे़त्तुसि, “कन् मनाःन्‍नाङ् नासरतस्‍मा ये़सुःन्‍नुए वये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","पत्रुसरे़ माङ्‌हे़क्‍सिङ्‌ल याम्‍मो खे़न् पाःन्‍निन् अक्‍खेलॽरिक् नाॽरु, “से़क्‍खासाङ् इङ्‌गाॽग कन् मनाःन् कुसिङ् मे़निःत्तुङ्‌ङिन्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","सप्‍फाआङ् खे़प्‍मो के़ये़प्‍पा मनाहाॽ पत्रुसरो मे़बेआङ् मे़मे़त्तु, “से़क्‍खासाङ् खुने़ॽ कुहुॽसाम्‍बाहाॽओ खे़ने़ॽआङ् लत्‍थिक्‌ने़रो, थेआङ्‌भे़ल्‍ले़ के़बाःन्‌इक्‍लाःन् गालिलस्‍मा कुइसिःक् चोःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","हे़क्‍केःल्‍ले़ पत्रुसरे़ याम्‍मो माङ्‌हे़क्‍सिङ्‌ल पाःत्तु, “से़क्‍खासाङ् कन् मनाःन् इङ्‌गाॽ कुसिङ् निःत्तुङ्‌ङाङ् वाॽआने़ फाॽग्र इङ्‌गाॽ सिःआर॥” हे़क्‍के पाःत्तुनामे़ःन्‍ने इङ्‌वाःन् काःसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","हे़क्‍केःल्‍ले़ पत्रुसरे़ खिमो ये़सुरे़ इङ्‌वा काःमानुःल्‍ले़ तगि खे़ने़ॽ सुम्‍ले़ङ् के़नाॽआ लॽरिक् पाःत्तुबा पाःन्‍निन् कुनिङ्‌वाॽ सुम् लॽरे़॥ हे़क्‍क्‍याङ् पत्रुसे़न् लक्‍खुम्‍मोनु लःन्‍दे़ पेआङ् उःक्‍काङ्-उःक् हाबे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","कुनाम्‍दाःप्‍मा खाओःत्ते़र पत्‍छे़ल्‍ले़सा तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽरे़ आक्‍खेलॽरिक् ये़सुरे़ सिःमे़ल्‍ले़न् खुम्‍दिङ् खोःसुर याःम्‍माबे फाॽआङ् निङ्‌सेःक् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ये़सुःन् इमे़घेःक्‍खु हे़क्‍क्‍याङ् रोमि सुहाङ्‌गे़म्‍बा पिलातसरो मे़देॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","हे़क्‍क्‍याङ् खुने़ॽ इङ्‌गे़ले़क्‍पा यहुदाःल्‍ले़ ये़सुःन् सिःमे़ल्‍ले़न् खुम्‍दिङ् मे़बिरु के़लॽबा पाःन्‍निन् निःसुआङ् साॽरिक् कुनिङ्‌वाॽ लोःरे़, खे़ल्‍ले़ चोगुल्‍ले़ खे़न् सुम्‍बोःङ् युप्‍पायाङ्‌ङिन् तेॽरुआङ् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽ अक्‍खे मे़त्तुसिर नुःक्‍तु पिरुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“इङ्‌गाॽग लायो चोगुङ्‌ङाङ् वाॽआरो, थेआङ्‌भे़ल्‍ले़ आप्‍फाल्‍ले़आङ् फे़न् याःम्‍बक् मे़न्‍जोःक्‍के के़वाॽबा मनाःन् इङ्‌ले़क्‍तुङ्‌लो॥” हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “आनिगे़ थेआङ् चोगुम्‍बे़बा होःप्‍लो॥ खे़ङ्‌ग खे़ने़ॽ आबाङे के़जोगुबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","खे़न् खे़प्‍सुआङ् यहुदाःल्‍ले़ खे़न् युप्‍पायाङ्‌ङिन् माङ्‌हिम्‍मो लाप्‍फुसुध, हे़क्‍क्‍याङ् लःन्‍दे़ पेआङ् आबाङे फोःन्‍छिङ् स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ खे़न् युप्‍पायाङ्‌ङिन् मे़घप्‍सुआङ् मे़बाःत्तु, “कङ्‌ग मना से़त्‍छे़ पिमनाबा याङ्‌लो, हे़क्‍केःल्‍ले़ माङ्‌हिम् याङ्‌भुङ्‌माओ केःप्‍मा साम्‌योथिम्‍मिल्‍ले़ आम्‍बिने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ कोःम्‍भलेरे़ कुइक्‍ताप्‍पिन् ताक्‍कन्‍निबाहाॽ मे़सिःल्‍ले़ लुप्‍मासि फाॽआङ् इङ्‌मा निःन्‍धो मे़जोगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","खे़ल्‍ले़ चोगुल्‍ले़ आइन् थारिक्‍साङ् खे़न् इक्‍ताप्‍पिन् माक्‍खिॽरे़ इङ्‌मनाबा इक्‍ताप् लॽरिक् मे़मे़त्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","कङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यर्मियाःल्‍ले़ अक्‍खेलॽरिक् पाःत्तुबान् के़रे़बारो– “इस्राइलिहाॽरे़ मे़हे़न्‍दुबा कुमे़ल्‍लुङ् सुम्‍बोःङ् युप्‍पायाङ् मे़दाःक्‍तुरो, ");
INSERT INTO lifNT2_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","हे़क्‍क्‍याङ् दाङ्‌बे़ल्‍ले़ ओःन्‍धाक्‍ताङ्‌बा कुइसिःक् खे़ङ्‌हाॽरे़ कोःम्‍भलेरे़ कुइक्‍ताप्‍पिन् मे़इङुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","आल्‍ल ये़सुःन् रोमि सुहाङ्‌गे़म्‍बा पिलातसरे़ कुदगि ये़बे़ल्‍ले़ सुहाङ्‌गे़म्बे़ल्‍ले़ खुने़ॽ सेःन्‍दोसु, “से़क्‍खा खे़ने़ॽ यहुदि हाङ्‌ने़बि?” ये़सुरे़ नोगप् पिरु, “खे़ङ्‌ग खे़ने़ॽए के़बाःत्तुर के़बत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","कर ये़सुरे़ कुदक्‍ले़ङ्‌वाओ तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽरे़ आप्‍तिक् मे़गुःत्तुल्‍ले़ खुने़ॽ मे़म्‍बाःत्ते ये़बे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","हे़क्‍केःल्‍ले़ पिलातसरे़ सेःन्‍दोसु, “खे़ने़ॽ के़दक्‍ले़ङ्‌वाओ के़म्‍गुःत्ते़बा आप्‍तिक्‍किन् के़ङ्‌घे़प्‍सुन्बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","कर ये़सुःन् पाःन्‍धिक्‍काङ् मे़म्‍बाःत्ते ये़बे़, हे़क्‍केःल्‍ले़ सुहाङ्‌गे़म्‍बाल्‍ले़ साॽरिक् कुनिङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","आल्‍ल यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मो लत्‍छा साक्‍पा के़धाःबा मनाःन् मनाहाॽरे़ ले़रे़ आबिरे़ॽ फाॽआङ् पेलि मे़भाक्‍तुल्‍ले़ सुहाङ्‌गे़म्‍बाल्‍ले़ ले़प्‍मा थिम् कत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","खे़न् ये़म्‍मो बरब्‍बास मे़प्‍मनाबा के़इङ्‌बा कुॽइगे़भे़ॽबान् पुङ्‌लाहिम्‍मो साक्‍ते़आङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","खे़ल्‍ले़ चोगुल्‍ले़ मनाहाॽ मे़जुप्‍से़आङ् मे़वये़ल्‍ले़ पिलातसरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “आत्तिन्‌ले़रुङ् पिनिङ् फाॽआङ् निङ्‌वाॽ के़इःत्तुम्‍माङ् के़वयिॽबे? बरब्‍बासे़न बि इ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त मे़प्‍मनाबा ये़सुःन् ले़रुङ् पिनिङ्‌बाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","थेआङ्‌भे़ल्‍ले़ यहुदि लाम्‍लोःबाहाॽरे़ ये़सुःन् नामे़हे़त्तुआङ् खुने़ॽओ हुक्‍मे़सुप्‍तुबा पाःन्‍निन् कुसिङ्‌निःत्तुआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","पिलातसे़न् खासे़न् युक्‍नाओ युङे़ल्‍ले़ए मेलिङ्‌गे़न् कुमेःत्तिल्‍ले़ अक्‍खे पाःत्तुर इङ्‌घङ् हाक्‍तु, “खे़न् साम्‌योनिबा मनाःन् थेआङ् मे़मे़त्ते़न्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ आन्‍दे़ से़न्‍दिक् खे़न् मनाःल्‍ले़ चोगुल्‍ले़ साॽरिक् ताप्‍फे़ःम्‍बा से़प्‍माङ् माक्‍तुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","कर तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽरे़ बरब्‍बासे़न ले़प्‍मा पाङ्‌मा हे़क्‍क्‍याङ् ये़सुःन् सिःमे़ल्‍ले़न् खुम्‍दिङ् पिमा पाङ्‌मा पोःङ् लॽरिक् मनाहाॽ मे़हुसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","सुहाङ्‌गे़म्‍बाल्‍ले़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “खे़न् ने़प्‍फुओ आत्तिन् ले़रुङ् पिनिङ् फाॽआङ् खिनिॽ निङ्‌वाॽ के़जोगुम्‍माङ् के़वयिॽबे?” मनाहाॽरे़ मे़मे़त्तु, “बरब्‍बासे़न ले़रे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","पिलातसरे़ सेःन्‍दोसुसि, “हे़क्‍केने़ फाॽग्र निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त मे़प्‍मनाबा ये़सुःन् थे मे़त्तुङ्‌बाबे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःन्‍दे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","हे़क्‍केःल्‍ले़ पिलातसरे़ याम्‍मो सेःन्‍दोसुसि, “थेआङ्बे? खे़ल्‍ले़ थे याःम्‍बक् फेःन्‍दुआङ् वाॽबे?” कर खे़ङ्‌हाॽ आल्‍लसाङ् साॽरिक् मे़अःक्‍ते़, “खे़न् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःन्‍दे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","आल्‍ल पिलातसरे़ थेआङ् चोःक्‍मा सुक्‍मे़न्‍दे़प्‍मनाबा नु याम्‍मो हयङ्‌किल्‍लिङ् के़बोःङ्‌बा निःसुआङ् कन् पाःन्‍नो खुने़ॽ कुहुक् होःप्‌लॽरिक् ओसेःन्‍धाक्‍से़ कुहुक्‍हाॽ वाहप्‍तुर खे़ङ्‌हाॽ मे़त्तुसि, “कन् याःम्‍बक् मे़न्‍भेःन्‍ने के़वाॽबा मनाःल्‍ले़ कुसिःमे़न्‍नो इङ्‌गाॽ आलक् होःप्‍लो॥ अक्‍खे के़जोःक्‍पाहाॽग बा खिनिॽनिङ्‌लो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","हे़क्‍केःल्‍ले़ के़रे़क् मनाहाॽरे़ मे़मे़त्तु, “कन् पाःन्‍निल्‍ले़न् तन्‍छ्रुङ्‌ङिन् आनिगे़ नु आनिगे़ मुॽइदाङ्‌सा सम्‍दाङ् थाःररो!” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","हे़क्‍क्‍याङ् पिलातसरे़ बरब्‍बासे़न ले़रु पिरुसि, कर ये़सुःन् ते़ःम्‍भुक् याक्‍मा पाङ्‌घुसिआङ् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःम्‍मा फाॽआङ् रोमि थक्‍सुबाहाॽ हुक्‍सुप्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","हे़क्‍क्‍याङ् सुहाङ्‌गे़म्‍बाल्‍ले़ कुधक्‍सुबाहाॽरे़ ये़सुःन् खुनिॽ तुरा यक्‍को मे़देॽरुआङ् खे़प्‍मो तुराबा के़रे़क् थक्‍सुबाहाॽ कुघिरि मे़जुप्‍से़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","खे़ङ्‌हाॽरे़ कुदेःत्तिन् मे़भे़न्‍दु मे़बिरुआङ् परान्‍ला हाङ्‌देःत्तिन् मे़जाक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","हे़क्‍क्‍याङ् तिङ्‌ग्रेःक्‍किल्‍ले़न् तिचः मे़भयुआङ् कुधे़गेःक्‍पो मे़घुःक्‍तु॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ तक्‍काःत्तिन् कुजुप्‍साङ् हुक्‍को मे़भत्‍छुआङ् कुदगि थुङ्‌बोहजॽ मे़युङ्‌सिङ्‌ल अक्‍खेलॽरिक् किनाःन्‍दि मे़बिरु, “यहुदि हाङ्‌ङे, तियाहा!” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","खे़ङ्‌हाॽरे़ खुने़ॽ थ्‍ये़त् मे़धोःक्‍तुआङ् तक्‍काःत्तिल्‍ले़ कुधे़गेःक्‍पो ए़त्‍ले़ङ् मे़घाक्‍खु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","हे़क्‍केलॽरिक् खे़ङ्‌हाॽरे़ ये़सुःन् किनाःन्‍दि मे़बिरु मे़सुरुआङ् खे़न् हाङ्‌देःत्तिन् मे़भे़न्‍दुआङ् कुदेःत्तिन् मे़जाक्‍तु॥ हे़क्‍क्‍याङ् खे़न् थक्‍सुबाहाॽरे़ खुने़ॽ सिलाम्‍साक्‍मा सिङ्‌ङो फोःन्‍छे़ मे़देॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","खे़ङ्‌हाॽ मे़बेर मे़बत्‍छे़ल्‍ले़ साइरेनि ये़क्‌यक्‍लाम् के़दाःबा सिमोन मे़प्‍मनाबा मनाःन् मे़दुमुआङ् ये़सुरे़ कुसिलाम्‍साक्‍मा सिङ्‌ङिन् साक्‍के़ल्‍ले़क् पङ्‌मा मे़बाङ्‌घु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","खे़ङ्‌हाॽ गलगथा मे़प्‍मनाबा कोःक्‍माओ मे़गे़रे़ (गलगथा फाॽइङ्‌ग मिक्‍खोःक्‍पा पोःङ्‌लो)॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","खे़प्‍मो खे़ङ्‌हाॽरे़ ये़सुःन् के़घिःक्‍पा सिदाॽ फुप्‍मनाबा चे़ल्‍ले़क्‍सेॽ थिःन् मे़धुङ्‌घु, कर ये़सुरे़ खे़न् साॽरुआङ् थुङ्‌मा मे़दे़न्‍दे़न्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","खे़ङ्‌हाॽरे़ खुने़ॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् मे़भोःन्‍दुआङ् कुदेःत्‍हाॽ हाःत्‍छिङ्‌मा फाॽआङ् तॽयाःन्‍सोःन् मे़गे़सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","खे़ङ्‌हाॽरे़ खे़प्‍मो सिलाम्‍साक्‍मा सिङ्‌ङिल्‍ले़ कुबुङ्‌मो मे़युङे़र खुने़ॽ मे़गोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","हे़क्‍क्‍याङ् ये़सुरे़ कुधे़गेःक् सम्‍दाङ् कुआप्‍तिक् सक्‍किन् मे़घिप्‍सुआङ् पत्‍छे़, खे़प्‍मो “कङ्‌ग यहुदिहाॽरे़ खुनिॽ हाङ् ये़सुरो” लॽरिक् मे़साप्‍तुआङ् पत्‍छे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","खुने़ॽनुए कुभे़न्‍छाङ् नु कुजुप्‍साङ्‌बा सिलाम्‍साक्‍मा सिङ्‌हाॽ सम्‍दाङ् ने़प्‍फु फाःन्‍दाहाॽ थक्‍सुबाहाॽरे़ मे़भोःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","खे़प्‍मोलाम् लाङ्‌गे़घेःक्‍पा मनाहाॽरे़आङ् खुनिॽ थे़गेःक्‍पे़न्‌मे़हिक्‍खुर अक्‍खेलॽरिक् खुने़ॽ किनाःन्‍दि मे़बिरु, ");
INSERT INTO lifNT2_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“खे़ने़ॽ माङ्‌हिम्‍मिन् के़यःबाआङ् सुम्‌ये़न्‍नो के़जोःक्‍पे, खे़ने़ॽ निङ्‌वाॽफुसाःने़ फाॽग्र सिलाम्‍साक्‍मा सिङ्‌ङोलाम् यो थ्‍ये़ॽआङ् आबाङे ताङ्‌से़ःप्‍सिङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","हे़क्‍केलॽरिक्‍के तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ हे़क्‍क्‍याङ् यहुदि तुम्‍लाम्‍लोःबाहाॽरे़आङ् खुने़ॽ किनाःन्‍दि मे़बिरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","खे़ङ्‌हाॽरे़ मे़बाःत्तु, “खे़ल्‍ले़ग वेॽहाॽ ताङ्‌से़ःप्‍तुसि, कर आबाङे ताङ्‌से़ःप्‍सिङ्‌मा मे़सुक्‍ते़न्‍लो॥ खुने़ॽग इस्राइलस्‍मा हाङ्‌मु! हाराॽ खुने़ॽ सिलाम्‍साक्‍मा सिङ्‌ङोलाम् यो थाःर, हे़क्‍क्‍याङ् आनिगे़ खुने़ॽ नसाःन् चोगुम्‍बे़ॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","खे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिन् नसाःन् चोगुॽ॥ हाराॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ निङ्‌वाॽ चोगुॽने़ फाॽग्र खे़न् खे़प्‍मोलाम् आल्‍लो से़ःप्‍तुररो, थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ग इङ्‌गाॽ निङ्‌वाॽफुसाःआ लॽरिक् पाःत्तुआङ् वये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","बा हे़क्‍केलॽरिक्‍के खुने़ॽनु सिलाम्‍साक्‍मा सिङ्‌ङो मे़भोःन्‍दुसिबा फाःन्‍दाहाॽरे़आङ् खुने़ॽ किनाःन्‍दि पिरे़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","हे़क्‍क्‍याङ् ले़न्‍दिक् कुमुक् थिक्-ने़त्ताङ्‌धो कुमुक् सुम्‍सि थारिक् खादाम्‍माल्‍ले़ खे़न् लाजेॽइन्‌सिदे़प् ते़प्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","कुमुक् सुम्‍सि मुक्‍ते़र पत्‍छे़ल्‍ले़ ये़सुःन् अक्‍खेलॽरिक् यम्‍बा इक्‍लाओ अःक्‍ते़, “एलि, एलि लामा सबखथानि?” (खे़न् फाॽइङ्‌ग “आनिङ्‌वाॽफुमाङ्‌ङे, आनिङ्‌वाॽफुमाङ्‌ङे, थेआङ् के़ले़राङ् के़देःसाङ्बे?” पोःङ्‌लो॥) ");
INSERT INTO lifNT2_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","खे़प्‍मो के़ये़प्‍पा कुभारे़ खे़न् मे़घे़प्‍सुआङ् अक्‍खे मे़बाःत्तु, “खे़ल्‍ले़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलियाःन् उःत्तुर पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","खे़ङ्‌हाॽओ लत्‍छा मनाधिक् खिमो लोःक्‍ते़र पेआङ् खिगाक्‍माःन् के़सुःप्‍पा चे़ल्‍ले़क्‍सेॽ थिओ निःप्‍सु हे़क्‍क्‍याङ् तक्‍काःत्तिल्‍ले़ कुसम्‍मो फत्‍छु हे़क्‍क्‍याङ् ये़सुरे़ पिःत्तु थुङुर फाॽआङ् कुमुराओ थुप्‍तु पिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","कुभारे़ मे़बाःत्तु, “सप्‍फारो, एलियाःन् साङ्‌ग्राम्‍पेदाङ्‌लाम् युःआङ् खे़न् ताङ्‌से़ःप्‍तुॽबि मे़ःम्‍बि ओमे़त्तुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","हे़क्‍क्‍याङ् ये़सुःन् याम्‍मो यम्‍बा इक्‍लाओ अःक्‍ते़, हे़क्‍क्‍याङ् कुसक्‍मा पेआङ् स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","बा खे़न् ये़म्‍मो माङ्‌हिम्‍मोबा फोःन्‍दाःन् थोलाम् यो कुबुङ्‌मो थारिक् खे़ल्‍ले़क् ते़ःक्‍खे़॥ इक्‍सादिङ् खाम्‍बेःक्‍मान् साॽरिक् थुरुप्‍लुप् यक्‍खे़, पयम् लुङ्‌हाॽ पःक्‍खे़, ");
INSERT INTO lifNT2_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","इप्‍पुङ्‌हाॽ मे़हरे़आङ् उन्‍छेःन् के़सिःबाआङ् के़वाॽबा यरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमनाहाॽ ने़त्तिगे़न् हिङ्‌मन्‍नो कुहिङ्‌वे़त् मे़बोःक्‍खे़आङ् मे़बोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","खे़ङ्‌हाॽ इप्‍पुङ्‌हाॽलाम् लाःक्‍कात् मे़लःन्‍दे़ हे़क्‍क्‍याङ् ये़सुःन् सिःमे़न्‍लाम् याम्‍मो हिङे़आङ् याङ्‌सि खे़ङ्‌हाॽ सेसे ये़क्‌यक्‍को मे़बेआङ् यरिक् मनाहाॽरो निःमे़धाबे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","खे़प्‍मो रोमि थक्‍तुम्‍बान् नु वेॽहाॽरे़ ये़सुःन् मे़गोःसुर मे़युङे़॥ खे़ङ्‌हाॽरे़ लुप्‍लि थाङे़बा नु खे़प्‍मो पोःक्‍खे़बा पाःन्‍हाॽ मे़निःसुआङ् साॽरिक् मे़गिसे़र मे़अःक्‍ते़, “से़क्‍खासाङ् कन् मनाःन् निङ्‌वाॽफुसाःए वये़रे़त्‍छ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","खे़प्‍मो यरिक् मे़न्‍छुमाहाॽ माःङ्‌घालाम् ओमइ मे़ये़बे़॥ खे़ङ्‌हाॽरे़ग ये़सुःन् गालिललाम्‍मे कुसेवा चोःक्‍से़ मे़दिम्‍दुर मे़द्‌ये़आङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","खे़प्‍मो के़वाॽमाहाॽओ मरियम मग्‍दलिनि, याकुब नु युसुफरे़ कुम्‍मा मरियम, हे़क्‍क्‍याङ् जब्‍दियारे़ कुमेःत् (याकुब नु युहुन्‍नारे़ कुम्‍मा) मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","हे़क्‍क्‍याङ् युःन्‍छिक् पोःक्‍खे़र पत्‍छे़ल्‍ले़ आरिमाथिया पाङ्‌जुम्‍बा युसुफ मे़प्‍मनाबा याङ्‌साकुन्‍धेसाबा मनाःन् त्‍ये़॥ खुने़ॽआङ् ये़सुरे़ कुहुॽसाम्‍बा पोःक्‍खे़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","खे़न् पिलातसरो पेआङ् ये़सुरे़ कुधक्‍किन् नाःक्‍तु, हे़क्‍क्‍याङ् पिलातसरे़आङ् खे़न् मे़बिरुर फाॽआङ् थक्‍सुबाहाॽ इङ्‌जाःङ् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ये़सुरे़ कुधक्‍किन् युसुफरे़ तेॽरुआङ् नुःबा चेदेःत्तिल्‍ले़ कित्तु, ");
INSERT INTO lifNT2_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","हे़क्‍क्‍याङ् आबाङे कुलागि लुङ्‌ङो खोःम्‍मनाबा कुसङ् इप्‍पुङ्‌ङो ने़स्‍सुरो॥ हे़क्‍क्‍याङ् इप्‍पुङ्‌ङिल्‍ले़ कुमुराओ लाःक्‍कात्‍लाम् यम्‍बा लुङ्‌ङिल्‍ले़ थेःक्‍तुधःआङ् नुःक्‍खे़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","मरियम मग्‍दलिनिःन् नु वेॽस्‍मा मरियम्‍मिल्‍ले़ खे़न् निःत्ताङ्‌नुए ओमे़त्ते़त्‍छुर युङे़त्‍छि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","हे़क्‍क्‍याङ् कुदाःन्‍दिक्‍मा यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‌रे़न्‌थिक्‍सिगेःक्‍पा ये़न्‍नो, तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु फरिसिहाॽ पिलातसरो मे़बेआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","अक्‍खे मे़मे़त्तु, “आदाङ्‌बे, खे़न् इङ्‌ले़क्‍पे़न्‌कुहिङ्‌वे़त् वये़ल्‍ले़ ‘इङ्‌गाॽ सिःआबा सुम्‌ये़न्‍नो याम्‍मो कुहिङ्‌वे़त् पोःङ्‌ङारो’ लॽरिक् पाःत्तुबा पाःन्‍निन् निङ्‌वाॽ इःप्‍मनारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","खे़ल्‍ले़ चोगुल्‍ले़ आदाङ्‌बारे़ सुम्‌ये़न् थारिक् सिङ्‌सिङ्‌ङाङ् कुइप्‍पुङ्‌ङिन् कोमा पाङ्‌घे़से़ॽओ॥ मे़ःन्‍ने़ फाॽग्र कुहुॽसाम्‍बाहाॽ से़न्‍दिक् मे़दाआङ् कुधक्‍किन् मे़घुःत्तु मे़देॽरुॽ, हे़क्‍क्‍याङ् ‘सिःमे़न्‍लाम् कुहिङ्‌वे़त् पोःक्‍खे़आङ् वाॽ’ लॽरिक् मनाहाॽ मे़मे़त्तुसिॽरो॥ कन् पाःन्‍निङ्‌ग तगिस्‍मा इङ्‌ले़क्‍किन्‍नुःल्‍ले़आङ् साॽरिक् ताप्‍फे़ःम्‍बा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","हे़क्‍केःल्‍ले़ पिलातसरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इःप्‍पुङ् के़गोःबा थक्‍सुबाहाॽ तेॽरे़म्‍सिम्‍मे़ॽआङ् खिनिॽ सुक्‍सुक् खे़न् इप्‍पुङ्‌ङिन् कोसे़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽ मे़बेआङ् इप्‍पुङ्‌ङिल्‍ले़ कुमुराओबा लुङ्‌ङो एःप्‍साप् मे़युक्‍तुआङ् मनाहाॽरे़ मे़न्‍हन्‍दुन्‍ल फाॽआङ् थक्‍सुबाहाॽ खे़प्‍मो कोमा मे़बाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","नाःम्‍सिङ्‌ये़न्‍निल्‍ले़ कुदाःन्‍दिक्‍मो, ते़ने़बा ये़न्‍नो खाओःत्ते़र पत्‍छे़ल्‍ले़ मरियम मग्‍दलिनिःन् नु वेॽस्‍मा मरियम्‍मिन् ये़सुःन् मे़ने़स्‍सुबा इप्‍पुङ्‌ङिन् ओमे़त्‍छे़ पेसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","हक्‍चघत् साॽरिक् किप्‍मा के़घुःबा लुप्‍लि थाङे़, थेआङ्‌भे़ल्‍ले़ यहवे दाङ्‌बाल्‍ले़ कुमाङ्‌लाइङ्‌बाधिक् साङ्‌ग्राम्‍पेदाङ्‌लाम् यो थ्‍ये़आङ् इप्‍पुङ्‌ङिल्‍ले़ कुमुराओ के़ये़प्‍पा खे़न् यम्‍बा लुङ्‌ङिन् थिक् ले़प्‍माङ् इसुआङ् खे़न् सम्‍दाङ् युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","खे़ल्‍ले़ कुनाराःन् साःम्‍भे कुइसिःक् ले़क्‍ते़, हे़क्‍क्‍याङ् कुदेःत्‍हाॽ नाःङ्‌कुइसिःक् फः लॽरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","खे़न् इःप्‍पुङ् के़गोःबा थक्‍सुबाहाॽ किःमाल्‍ले़ मे़यक्‍खे़र हर्गुप् मे़जोःन्‍दे़आङ् कुसिवे़त् मना कुइसिःक् मे़बोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","हे़क्‍क्‍याङ् माङ्‌लाइङ्‌बाल्‍ले़ खे़न् मे़न्‍छुमाहाॽ मे़त्तुसि, “मे़गिसे़त्‍छे़न्‍ने़ॽओ, खिन्‍छिॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् मे़भोःन्‍दुबा ये़सुःन् के़गोःत्‍छुबा पाःन्‍निन् कुसिङ् निःत्तुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","खुने़ॽग कप्‍मो होःप्‍लो, खुने़ॽ पाःत्तुबा कुइसिःक्‍के कुसिवे़त्‍लाम् कुहिङ्‌वे़त् पोःक्‍खे़आङ् वाॽरो॥ फे़रे़त्‍छे़ॽआङ् कुधक्‍किन् ने़स्‍से़बा ते़न्‍निन् ओमे़त्ते़त्‍छे़ना॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","हे़क्‍क्‍याङ् हारा पेगे़त्‍छे़ॽआङ् कुहुॽसाम्‍बाहाॽ अक्‍खे मे़त्ते़छे़ॽओ, ‘खुने़ॽग कुसिवे़त्‍लाम् कुहिङ्‌वे़त् पोःक्‍खे़आङ् वाॽरो, हे़क्‍क्‍याङ् खे़ङ्‌हाॽनुःल्‍ले़ तगि गालिलओ पेःक्‍ल पत्‍लो॥ खुने़ॽ खे़प्‍मोए खिनिॽ के़दुमुम्‍लो॥’ ओमे़त्ते़त्‍छे़ॽओ, कन् पाःन्‍निन् खिन्‍छिॽ मे़त्‍ने़त्‍छिङ्‌ङाङ् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","हे़क्‍केःल्‍ले़ खे़न् मे़न्‍छुमाहाॽ किःसे़त्‍छिसाङ् ओमुलॽरे़त्‍छिर ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़वये़बा ते़न्‍नो खे़न् पाःन्‍निन् मे़त्‍छे़ इप्‍पुङ्‌लाम् चात्ते़त्‍छिर पेसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","हक्‍चघत् ये़सुरे़ खे़ङ्‌हाॽ तुमुसिआङ् “सेवारो” मे़त्तुसि, हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽ ये़सुरो त्‍ये़त्‍छिआङ् कुलाङ्‌हाॽ ते़म्‍से़त्‍छुर सेवा चोगे़त्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिन्‍छिॽ मे़गिसे़त्‍छे़न्‍ने़ॽओ, पेगे़त्‍छे़ॽआङ् आन्‍साॽसि गालिलओ के़बेगिमु मे़त्ते़छे़से़ॽओ, खे़ङ्‌हाॽरे़ इङ्‌गाॽ खे़त्‍थोए मे़दुम्‍माॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","खे़न् मे़न्‍छुमाहाॽ ये़क्‌यक्‍को नुःक्‍खे़त्‍छि पेसे़त्‍छिल्‍ले़ कुभा थक्‍सुबाहाॽ मे़बेआङ् पोःक्‍खे़बा के़रे़क् हिन्‍दोःक्‍किन् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ मे़जे़क्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","हे़क्‍केःल्‍ले़ तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽ मे़जुप्‍से़आङ् इङ्‌मे़दङ्‌घु, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ थक्‍सुबाहाॽ यरिक् याङ् मे़बिरुसिर ");
INSERT INTO lifNT2_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","अक्‍खे मे़मे़त्तुसि, “आनिगे़ से़न्‍दिक् इप्‍सिगे़आङ् ने़स्‍सिगे़ल्‍ले़ ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़द्‌ये़आङ् कुधक्‍किन् मे़घुःत्तुआङ् मे़देॽरुरो लॽरिक् खिनिॽ के़बाःत्तुम्‍ल पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","कन् पाःन्‍निन् सुहाङ्‌गे़म्‍बाल्‍ले़ खे़प्‍सुने़ फाॽग्र खुने़ॽ कुनिङ्‌वाॽ तासुम्‍बे़आङ् खिनिॽ नाङ्‌ङासिगे़ॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","हे़क्‍केःल्‍ले़ थक्‍सुबाहाॽरे़ यरिक् याङ् मे़दाःक्‍तुआङ् खे़ङ्‌हाॽ मे़मे़त्तुसिबा कुइसिःक्‍के खे़ङ्‌हाॽरे़ मे़बाःत्तुरो॥ खे़ल्‍ले़ चोगुल्‍ले़ कन् पाःन्‍निङ्‌ग से़ःरे़आङ् आइन् थारिक्‍साङ् यहुदिहाॽरे़ मे़बाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","हे़क्‍क्‍याङ् थिक्-थिक् (११) कुहुॽसाम्‍बाहाॽ ये़सुरे़ पेगे़म्‍मे़ॽओ लॽरिक् मे़त्तुसिबा गालिलओबा कोःक्‍माओ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","खे़ङ्‌हाॽरे़ खे़प्‍मो ये़सुःन् मे़निःसुआङ् सेवा मे़जोगु, कर कुभारे़ग चप्‍चि मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","हे़क्‍क्‍याङ् ये़सुःन् खे़ङ्‌हाॽओ त्‍ये़आङ् मे़त्तुसि, “साङ्‌ग्राम्‍पेदाङ् नु इक्‍सादिङ् खाम्‍बेःक्‍मोबा के़रे़क् युक्‍किन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ इङ्‌गाॽ पिराङ्‌ङाङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","खे़ल्‍ले़ चोगुल्‍ले़ पेगे़म्‍मे़ॽआङ् के़रे़क् मे़न्‍छाम् सुवाङ्‌हाॽ हुॽसाम्‍बा चोगे़म्‍सिम्‍मे़ॽओ॥ पानुदिङ् पाः, आबुदिङ् साः, हे़क्‍क्‍याङ् सेसेमाङ्‌ङिल्‍ले़ कुमिङ्‌ङो बप्‍तिस्‍मा पिरे़म्‍सिम्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","इङ्‌गाॽ इङ्‌जाःङ् पिनिङ्‌बा के़रे़क् पाःन्‍हाॽ इःप्‍मा नाःप्‍मा हुॽरे़म्‍सिम्‍मे़ॽओ॥ ओमे़त्ते़म्‍मे़ॽओ, इङ्‌गाॽग इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुनुप्‍मो थारिक्‍के खिनिॽनु सदादिङ् वाॽआरो॥”");
INSERT INTO lifNT2_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","कङ्‌ग निङ्‌वाॽफुसाः ये़सु ख्रिस्‍तरे़ कुसुनाइङ्‌ङिल्‍ले़ कुहेःक्‍सिङ्‌मारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ अक्‍खेलॽरिक् साप्‍तुआङ् पत्, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाःत्तु, ‘खे़ने़ॽ के़लाम्‍मिन् यारिप् चोगुर फाॽआङ् इङ्‌गाॽ आइङ्‌साबे़न् के़दगि पाङ्‌घुङ् युःसुङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","खुने़ॽ एःक्‍सादे़न्‍नो अक्‍खेलॽरिक् के़अःक्‍पा इक्‍लारो, ‘दाङ्‌बाल्‍ले़ कुमाराम्‍मिन् यारिप् चोगे़म्‍मे़ॽआङ् कुलाम्‍हाॽ तोःन्‍दोःन्‌चोगे़म्‍मे़ॽ!’” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ साप्‍तुबा कुइसिःक् बप्‍तिस्‍मा के़बिबा युहुन्‍नाःन् एःक्‍सादे़न्‍नो त्‍ये़आङ्‌लायोलाम् हिन्‍दे़म्‍मे़ॽआङ् बप्‍तिस्‍मा पोःक्‍खे़म्‍मे़ॽ, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽ लायोःन् ले़प्‍मि के़बिरिॽ लॽरिक् इङ्‌भन् चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","यहुदिया थुम्‌नु यरुसले़म ये़क्‌यक्‍लाम् यरिक् मनाहाॽ खुने़ॽओ मे़द्‌ये़आङ् इङ्‌गाॽ लायोबाआरो मे़बाःत्तुर यर्दन यङ्‌घङ्‌ङो खुने़ॽलाम् बप्‍तिस्‍मा मे़बोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","आल्‍ल युहुन्‍नाःङ्‌ग उमे़ःल्‍ले़ कुमुरिक्‍लाम् थाक्‍मनाबा तेःत् के़जाङ्‌बा नु से़होबा फॽइ के़युम्‍बा चोगे़॥ हे़क्‍क्‍याङ् खुने़ॽग निःङ्‌घुःक्‌वा नु ताम्‍भुङ् सक्‌वाघु के़जाबा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","युहुन्‍नाःल्‍ले़ अक्‍खे पाःत्तुर इङ्‌भोःसु, “इङ्‌गाॽ आएगाङ् इङ्‌गाॽनुःल्‍ले़आङ् मुक्‍साम्‍साबान्‌ताःरो॥ इङ्‌गाॽग योःक् कुइसिःक् कुलाङ्‌सुःप्‌नाम्‍हाॽ फाःङ्‌माआङ् मे़लाॽआन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","इङ्‌गाॽग खिनिॽ च्‍वाःत्तिल्‍ले़ बप्‍तिस्‍मा पिनिङ्‌ल पत्ता, कर खुने़ॽग सेसेमाङ्‌ङिल्‍ले़ बप्‍तिस्‍मा के़बिरिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","खे़न् ये़म्‍मो ये़सुःन् गालिल थुम्‍मोबा नासरतलाम् त्‍ये़आङ् युहुन्‍नालाम् यर्दन यङ्‌घङ्‌ङो बप्‍तिस्‍मा पोःक्‍खे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","खुने़ॽ च्‍वाःत्तोलाम् लःन्‍दे़नुमे़ःन्‍ने ताङ्‌साक्‍पे़न्‌हरे़आङ् सेसेमाङ्‌ङिन् पुत्तुःक्‍के हे़क्‍के खुने़ॽ कुसम्‍दाङ् ये़ःर पत्‍छे़बा निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","हे़क्‍क्‍याङ् साङ्‌ग्राम्‍पेदाङ्‌लाम् इक्‍लाधिक् त्‍ये़, “खे़ने़ॽ आमिःम् आस्‍साःने़रो, खे़ने़ॽनु इङ्‌गाॽ साॽरिक् सःत्ताङ्‌ङाङ् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","खिमो सेसेमाङ्‌ङिल्‍ले़ खुने़ॽ एःक्‍सादे़न्‍नो पेःक्‍माए पोःङ् फाॽआङ् तेॽरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","खुने़ॽ खे़प्‍मो लिबोःङ्‌(४०) ये़न् थारिक् वये़ल्‍ले़ माफे़न्‍साम् सैतानिल्‍ले़ खुने़ॽ फे़न् याःम्‍बक् चोःक्‍पाङ्‌मा फाॽआङ् कुनिङ्‌वाॽ साॽरु॥ खे़प्‍मो खुने़ॽ ताम्‍भुङ्‌थक्‍साहाॽनु वये़, हे़क्‍क्‍याङ् माङ्‌लाइङ्‌बाहाॽरे़ खुने़ॽ कम्‍ब्राङ् मे़मे़त्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","आल्‍ल युहुन्‍नाःन् पुङ्‌लाहिम्‍मो मे़साक्‍तुआङ् यागे़ल्‍ले़ ये़सुःन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसुनाइङ्‌ङिन् इङ्‌भन् से़ःसुर गालिल थुम्‍मो त्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","खुने़ॽ अक्‍खे पाःत्तुर इङ्‌भन् से़ःसु, “कन् सुये़म्‍मिन् त्‍ये़आङ् वाॽ, निङ्‌वाॽफुहाङ्‌जुम्‍मिन् निःत्ताङ्‌ङे वाॽरो, हे़क्‍केःल्‍ले़ खिनिॽ लायोलाम् हिन्‍दे़म्‍मे़ॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसुनाइङ्‌ङिन् नसाःन् चोगे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","हे़क्‍क्‍याङ् ये़सुःन् गालिल वरक्‍किल्‍ले़ कुयाओ पेर पत्‍छे़ल्‍ले़ सिमोन नु कुन्‍साॽ आन्‍द्रियासे़न् योःङ् ले़प्‍ते़त्‍छुर यागे़त्‍छिबा तुमुसि॥ खे़ङ्‌हाॽ ने़प्‍माङ् योःङ् के़ले़प्‍पा वये़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिन्‍छिॽ इङ्‌गाॽ आएगाङ् थाने़त्‍छे़ॽओ, खिन्‍छिॽ ङा के़दे़म्‍सु के़दाःत्‍छुबा कुइसिःक् इङ्‌गाॽओ मना के़दाःप्‍पा चोःक्‍ने़त्‍छिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खिमो योःङ्‌ङिन् ने़स्‍से़त्‍छुथे़ःसुआङ् ये़सुःन् के़नाःप्‍पा पोःङ्‌से़ कुएःक् कुएःक् थाने़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","खुने़ॽ मिसाक् नानाक् पेर पत्‍छे़ल्‍ले़ जब्‍दिरे़ कुस्‍साः याकुबे़न् नु कुन्‍साॽ युहुन्‍नाःन्‍नाङ् खुन्‍छिॽ खःङ्‌बेओ योःङ्‌ङिन् ले़म्‍दे़त्‍छुर यागे़त्‍छिबा निःसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","खुने़ॽ खे़ङ्‌हाॽआङ् उःत्तुसिआङ् खिमो खुन्‍छिॽ पाः जब्‍दि हे़क्‍क्‍याङ् मे़साङुसिबा याःलिक्‍हाॽ खःङ्‌बेओ पक्‍थे़त्‍छुआङ् ये़सुरे़ कुएगाङ् थाःने़त्‍छि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ये़सुःन् नु खे़ङ्‌हाॽ कपर्नहुम पाङ्‌जुम्‍मो मे़बे॥ नाःम्‍सिङ्‌ये़न्‍नो ये़सुःन् यहुदि चुम्‍लुङ्‌हिम्‍मो पेआङ् हुॽमा हेःक्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","खुने़ॽ कुनिसाम्‍मिन् मे़घे़प्‍सुआङ् खे़प्‍मोबा मनाहाॽरे़ साॽरिक् खुनिॽ निङ्‌वाॽ मये़, थेआङ्‌भे़ल्‍ले़ खुने़ॽ साम्‌योथिम्‍साम्‍बाहाॽ कुइसिःक् मे़ःन्, कर युक् के़गप्‍पा कुइसिःक् हुॽरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ये़सुरे़ खे़न् यहुदि चुम्‍लुङ्‌हिम्‍मो हुॽमा हेःक्‍तुसिल्‍ले़ फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबा मनाधिक् अःक्‍ते़र पारे़, ");
INSERT INTO lifNT2_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“नासरतबा ये़सुए, खे़ने़ॽ आनिगे़नु थे के़गोःत्तुबाबे? खे़ने़ॽ आनिगे़ मे़ङ्‌से़ के़द्‌ये़बाबि? खे़ने़ॽ हाःत्‍ने़बे फाॽआङ् निःसुम्‍बे़रो–खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़बाङ्‌घे़बा सेसे कुमनाने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ये़सुरे़ खे़न् फे़न्‍साम्‍मिन् फे़ःक्‍तु, “स्‍वाःत्! खे़न् मनाःन् ले़रे़ॽआङ् पेगे़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","हे़क्‍क्‍याङ् खे़न् फे़न्‍साम्‍मिल्‍ले़ खे़न् मनाःन् पिर्धाप् थाप्‍सुधआङ् यम्‍बा इक्‍लाओ फिःक्‍ते़र ले़रुधःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","खे़ॽयो के़जुम्‍बाआङ् के़वाॽबा मनाहाॽरे़ खुनिॽ निङ्‌वाॽ मये़र अक्‍खे मे़लॽरे़, “कङ्‌ग आक्‍तङ्‌बा निसाम्बे? खुने़ॽग फे़न्‍साम्‍हाॽ इङ्‌जाःङ् पिरुसिआङ् खे़ङ्‌हाॽरे़आङ् मे़घे़प्‍सुरो॥ आक्‍तङ्‌बा युक्‍किन्‍ने कत्तुबे!” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","खुने़ॽ कुमिङ्‌सो इङ्‌धाःङ्‌ङिन् के़रे़क् गालिल थुम्‍मो से़ःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","हे़क्‍क्‍याङ् ये़सुःन् नु खुने़ॽ के़नाःप्‍पाहाॽ यहुदि चुम्‍लुङ्‌हिम्‍लाम् मे़लःन्‍दे़आङ् सिमोन नु आन्‍द्रियासरे़ खुन्‍छिॽ हिम्‍मो मे़बेरो॥ युहुन्‍नाःन् नु याकुबे़न्‍नाङ् खे़ङ्‌हाॽनुए पेसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","खे़प्‍मो सिमोनरे़ कुन्‍नोःप्‍मे़न् कुदुङ् त्‍ये़आङ् थाःसुआङ् ने़स्‍से़॥ खे़ङ्‌हाॽरे़ खिमो खे़न् पाःन्‍निन् ये़सुःन् मे़मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ये़सुःन् कुबेसाङ् पेआङ् कुहुक्‍को ते़म्‍सुआङ् फोःक्‍खु॥ खिमो खे़न् वेःत्ते़आङ् खुने़ॽ खे़ङ्‌हाॽ सेवा चोःक्‍मा हेःक्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","नाम्‍धे़आङ् खे़न् युःन्‍छिक् यरिक् के़दुक्‍पाहाॽ नु फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुसिबा मनाहाॽ ये़सुरो मे़दारुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","खे़न् पाङ्‌जुम्‍मोबा यरिक् मनाहाॽ खे़न् हिम्‍मो मे़जुप्‍से़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ये़सुरे़ वेॽ वेॽ परिक्‍पा तुक्‍माल्‍ले़ तरुसिबा मनाहाॽ वेःन्‍दुसिर यरिक् फे़न्‍साम्‍हाॽ नाःत्तुलःत्तुसिरो॥ खुने़ॽ फे़न्‍साम्‍हाॽ पाःप्‍मा मे़बाङ्‌घुन्‍सिन्, थेआङ्‌भे़ल्‍ले़ खुने़ॽ हाःत् फाॽआङ् कुसिङ् मे़निःत्तुआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","कुदाःन्‍दिक् खाओःप्‍मानुःल्‍ले़ तगि ये़सुःन् एःक्‍सादे़न्‍नो पेआङ् तुवा चोगे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","याङ्‌सि सिमोन नु कुन्‍देःङ्‌बाहाॽ खुने़ॽ कुगोःत्‍छे़ मे़बे॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","खुने़ॽ मे़दुमुआङ् मे़मे़त्तु, “आदाङ्‌बे, के़रे़क् मनाहाॽरे़ खे़ने़ॽ के़म्‍गोःत्‍ल मे़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","हे़क्‍क्‍याङ् ये़सुरे़ नोगप् पिरुसि, “आनिॽ कन् खिरिबा वेॽस्‍मा पाङ्‌भेॽहाॽओ पेगि॥ इङ्‌गाॽ खे़प्‍मोआङ् सुनाइङ् से़ःमा पोःङ्॥ हाबा खे़ल्‍ले़ लागि इङ्‌गाॽ त्‍याङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","हे़क्‍क्‍याङ् ये़सुरे़ गालिल थुम्‍मो खाराक् लाङ्‌घेगे़र खे़ङ्‌घाःत्तिबा यहुदि चुम्‍लुङ्‌हिम्‍मो सुनाइङ् से़ःसुआङ् फे़न्‍साम्‍हाॽ नाःत्तु लःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","थिक् लोगेॽ तुक्‍माल्‍ले़ तरुबा मनाःन् ये़सुरो त्‍ये़आङ् थुङ्‌बोहजॽ युङ्‌सिङ्‌ङाङ् पेलि फाक्‍तु, “आदाङ्‌बे, खे़ने़ॽ निङ्‌वाॽ के़जोगुने़ फाॽग्र इङ्‌गाॽ वेःम्‍मा के़सुक्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ये़सुरे़ लुङ्‌माॽ तुक्‍तुर कुहुक्‍किल्‍ले़ सुःसुआङ् मे़त्तु, “इङ्‌गाॽ निङ्‌वाॽ चोगुङ्, खे़ने़ॽ नुरे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","खिमो खे़न् मनाःन् लोगेॽ तुक्‍मोलाम् नुःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ये़सुरे़ खे़न् मनाःन्, “खे़ने़ॽ के़नुरे़बा पाःन्‍निन् आत्तिन्‍नाङ् मे़मे़त्ते़न्‍ने़ॽओ, ");
INSERT INTO lifNT2_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","कर पेगे़ॽआङ् निङ्‌वाॽफुसाम्‍बाल्‍लो ओसेःन्‍धाक्‍सिङ्‌ङे़ॽ, हे़क्‍क्‍याङ् खे़ने़ॽ नुःराङ् फाॽआङ् मनाहाॽ ओसेःन्‍धाक्‍मासिरे़ लागि मोसारे़ इङ्‌जाःङ् चोगुबा हे़क्‍के सिदुङ्‌जभा चोगे़ॽओ” मे़त्तुर पाङ्‌घुदेःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","कर खुने़ॽ पेआङ् नुःरे़बा पाःन्‍निन् के़रे़क् मनाहाॽ चे़क्‍तुसि॥ खे़ल्‍ले़ चोगुल्‍ले़ ये़सुःन् पाङ्‌जुम्‍मो मनाहाॽरे़ मे़निःसुर ताःमा मे़सुक्‍ते़न्‍लो॥ हे़क्‍क्‍याङ् खुने़ॽ लाःक्‍कात् एःक्‍सादे़न्‍नो वये़आङ् खे़प्‍मोए काक् पिसाङ्‌लाम् यरिक् मनाहाॽ मे़द्‌ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","थिक्‌ये़न् निये़न् एगाङ् ये़सुःन् कपर्नहुम पाङ्‌जुम्‍मो नुःक्‍खे़ त्‍ये़॥ हे़क्‍क्‍याङ् खुने़ॽ हिम्‍मो वाॽ के़लॽबा इङ्‌घङ्‌ङिन् से़ःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","यरिक् मनाहाॽ खे़न् हिम्‍मो हत्‍मे़न्‍हत् लाम्‍धेःप्‍पुङ्‌नु लक्‍खुम्‍मो थारिक् मे़जुप्‍से़आङ् ये़सुरे़ खे़ङ्‌हाॽ सुनाइङ् इङ्‌भन् चोगुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","हे़क्‍क्‍याङ् खे़प्‍मो लिसि मनाहाॽरे़ लङ्‌ले़ःङ्‌वा मनाधिक् मे़गुयुआङ् मे़दारु, ");
INSERT INTO lifNT2_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","कर खे़न् हिम्‍मो यरिक् मनाहाॽरे़ सधे़क्‌मे़धिम्‍सुआङ् मे़युङे़बाल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खे़न् लङ्‌ले़ःङ्‌वाःन् ये़सुरे़ कुदगि तेॽमा मे़न्‍छुक्‍तुन्॥ हे़क्‍केःल्‍ले़ खे़न् मनाहाॽरे़ थो खाम्‍बुओ मे़लाःसे़आङ् खाम्‍बुःन् मे़हन्‍दु॥ हे़क्‍क्‍याङ् खे़न् लङ्‌ले़ःङ्‌वाःन् कुने़त्‍नाःन्‍नुए ये़सुरे़ कुदगि यो मे़धाःसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","खे़ङ्‌हाॽरे़ खे़न् के़दुक्‍पे़न्‌वेःप्‍मा सुक् के़लॽबा नसाःन् मे़गत्तुबा ये़सुरे़ निःसुआङ् लङ्‌ले़ःङ्‌वाःन् मे़त्तु, “आस्‍साःए, खे़ने़ॽ के़लायोहाॽ ले़प्‍मि पोःक्‍खे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","आल्‍ल खे़प्‍मो के़युङ्‌बा साम्‌योथिम्‍साम्‍बाहाॽ निङ्‌वाॽ मे़इःत्‍छिङ्, ");
INSERT INTO lifNT2_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“मे़ःन्, कन् मनाःल्‍ले़ग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पाःन्‍ने पाःत्तुॽरो! निङ्‌वाॽफुमाङ्‌ङिन्‍नुःल्‍ले़ वेॽ हाःत्‍ले़आङ् मे़न्‍छाम्‍गे़न् याप्‍मिरे़न् लायोःन् ले़प्‍मि पिमा मे़सुक्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽबो थे मे़इःत्तुर मे़युङ् के़लॽबान्‌निःसुआङ् खे़ङ्‌हाॽ मे़त्तुसि, “थेआङ् हे़क्‍केलॽरिक् खिनिॽ के़इःत्तुम्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","कन् लङ्‌ले़ःङ्‌वाःन्‌‘के़लायोहाॽ ले़प्‍मि पोःक्‍खे़’ मे़प्‍मा उसुरु चोःक्‍पि? इ ‘पोगे़ॽआङ् के़ने़त्‍नाःन् खप्‍से़ॽआङ् थासिङ्‌ङे़ॽ’ मे़प्‍मा उसुरु चोःक्‍पि? ");
INSERT INTO lifNT2_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","कर इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मो लायोहाॽ ले़प्‍मि पिमा युक् कत्तुङ् फाॽआङ् ओसेःन्‍धाक्‍निङ्‌लो॥” हे़क्‍केःल्‍ले़ ये़सुरे़ खे़न् लङ्‌ले़ःङ्‌वाःन् मे़त्तु, ");
INSERT INTO lifNT2_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“आल्‍ल पोगे़ॽ! के़ने़त्‍नाःन् याङ्‌सिङ्‌ङे़ॽआङ् के़हिम्‍मो थासिङ्‌ङे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","खिमो खे़न् मुत्‍थ्रिक् पोगे़आङ् कुने़त्‍नाःन् याङ्‌सिङ्‌हे़क्‍क्‍याङ् मनाहाॽरे़ खुनिॽ तगिए लःन्‍दे़ पेरो॥ खे़न् मनाहाॽरे़ मे़निःसुआङ् साॽरिक् खुनिॽ निङ्‌वाॽ मये़॥ निङ्‌वाॽफुमाङ्‌ङिन् अक्‍खे मे़मे़त्तुर कुनारा मे़भोःसु, “अक्‍तङ्‌बाग आनिगे़ आप्‍फाल्‍ले़आङ् मे़न्‍निए वयिगे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","याम्‍मो ये़सुःन् वरक्‍किल्‍ले़ कुयाओ पे॥ यरिक् मनाहाॽरे़ खुने़ॽ मे़दिम्‍दुआङ् ये़सुरे़ खे़ङ्‌हाॽ खाहुन् हुॽरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","हे़क्‍क्‍याङ् ये़सुःन् पेर पत्‍छे़ल्‍ले़ अल्‍फायसरे़ कुस्‍साः ले़बिःन् एःङ्‌याङ् फोःङ्‌मा ते़न्‍नो युङे़बा निःसुआङ् मे़त्तु, “इङ्‌गाॽ तिम्‍दाङ्‌ङे़ॽओ॥” खे़न् मुत्‍थ्रिक् पोगे़आङ् खुने़ॽनु थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","याङ्‌सि ले़बिःल्‍ले़ कुहिम्‍मो ये़सुःन्‍नु कुहुॽसाम्‍बाहाॽ चाजासे़ उःत्तुसि, यरिक् एःङ्‌याङ् के़भोःङ्‌बाहाॽ नु वेॽस्‍मा लायोबाहाॽ ये़सुःन्‍नु सोरिक् चामे़जर मे़युङे़ (थेआङ्‌भे़ल्‍ले़ खे़न् हे़क्‍तङ्‌बा यरिक् मनाहाॽरे़ ये़सुःन् मे़दिम्‍दुर मे़वये़)॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","हे़क्‍केःल्‍ले़ खे़प्‍मो फरिसि लुप्‍पोबा साम्‌योथिम्‍साम्‍बाहाॽ मे़द्‌ये़आङ् ये़सुःन् एःङ्‌याङ् के़भोःङ्‌बाहाॽ हे़क्‍क्‍याङ् लायोबाहाॽनु सोरिक् चाजानु युङे़बा मे़निःसुआङ् याम्‍मो खे़ङ्‌हाॽरे़ ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़मे़त्तुसि, “एःङ्‌याङ् के़भोःङ्‌बाहाॽ हे़क्‍क्‍याङ् लायोबाहाॽनु खुने़ॽ थेआङ् चाजाबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ पाःन्‍निन् खे़प्‍सुआङ् नोगप् पिरुसि, “सिदाॽसाम्‍बे़ङ्‌ग मे़न्‍दुक्‍मनाहाॽरे़ लागि मे़ःन्, कर के़दुक्‍पाहाॽरे़ लागिरो॥ खे़न् हे़क्‍के इङ्‌गाॽआङ् साम्‌योनिबाहाॽरे़ लागि मे़ःन्, कर लायोबाहाॽ लायोलाम् मे़नुःङ्‌ङाङ्‌ताङ्‌मे़से़ःप्‍ल फाॽआङ् त्‍याङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","आल्‍ल बप्‍तिस्‍मा के़बिबा युहुन्‍ना नु फरिसिहाॽरे़ खुनिॽ हुॽसाम्‍बाहाॽ चाःने़त्तो मे़युङे़आङ् मे़वये़॥ थिक्‌ये़न् मनाहाॽ मे़द्‌ये़आङ् ये़सुःन् सेःन्‍मे़लाप्‍तु, “फरिसिहाॽ नु बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ खुनिॽ हुॽसाम्‍बाहाॽग चाःने़त्तो मे़युङ्, कर खे़ने़ॽ के़हुॽसाम्‍बाहाॽ थेआङ् चाःने़त्तो मे़न्‌युङ्‌ने़न्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “मेःक्‍खिम्‍साबे़न् कुन्‍जुम्‍हाॽनु वाॽर थारिक् खे़ङ्‌हाॽ चाःने़त्तो मे़युङ् फाॽआङ् के़इःत्तुम्‍बि? मे़ःन्‍लो, मेःक्‍खिम्‍साबे़न् वाॽर थारिक् खे़ङ्‌हाॽ आप्‍फाल्‍ले़आङ् चाःने़त्तो मे़न्‌युङ्‌ने़न्, ");
INSERT INTO lifNT2_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","कर खे़ङ्‌हाॽलाम् मेःक्‍खिम्‍साबे़न् साक्‍के़ल्‍ले़क् मे़दे़म्‍सुआङ् मे़देॽरुल्‍ले़ खे़ङ्‌हाॽ चाःने़त्तो मे़युङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","आत्तिल्‍ले़आङ् कुसङ् चिरिक्‍किल्‍ले़ कुद्रे़क्‌चाङ्‌ङिन् मे़ले़म्‍दुन्‍लो, ले़म्‍दुने़ फाॽग्र खे़न् किङ्‌ङाङ् आल्‍लसाङ् यम्‍बा थे़ःक्‍खुदेःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","आत्तिल्‍ले़आङ् कुसङ् चे़ल्‍ले़क्‍सेॽ थिःन् कुद्रे़क्‌से़होबा सुःक्‌वाओ मे़युक्‍खुन्॥ युक्‍खुने़ फाॽग्र कुसङ् चे़ल्‍ले़क्‍सेॽ थिःल्‍ले़ कुद्रे़क्‌से़होबा सुःक्‌वाःन्‌थे़ःक्‍खुदेःसुॽरो॥ हे़क्‍क्‍याङ् थिःन् वे़त् पेःक्‍काङ् ने़प्‍माङ् चासोःक्‍लो॥ कर कुसङ् चे़ल्‍ले़क्‍सेॽ थिःन् कुसङ् से़होबा सुःक्‌वाओए याक्‍मा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","थिक्‍ले़ङ् नाःम्‍सिङ्‌मा ये़न्‍नो ये़सुःन् नु कुहुॽसाम्‍बाहाॽ प्‍याङ्‌सिगे़न् इक्‍ताप्‍लुम्‍मोनु मे़बेर मे़बत्‍छे़ल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ नुक्‍मा चामा फाॽआङ् सिःदाप्‍माहाॽ तुप्‍मा मे़हेःक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","हे़क्‍केःल्‍ले़ फरिसिहाॽरे़ खुने़ॽ मे़मे़त्तु, “ओमे़त्ते़ॽ, थेआङ् नाःम्‍सिङ्‌ये़न्‍नो चोःक्‍मा मे़न्‍नुॽमनाबा याःम्‍बक्‍किन् मे़जोगुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “साम्‌योसाप्‍लाःन् खिनिॽ मे़न्‍निःत्ते के़वयिॽबि? दाउद हाङ्‌ङिन् नु कुमनाहाॽरे़ खुनिॽ से़त्‍लाःक्‍ते़ल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","दाउदे़न् निङ्‌वाॽफु साःङ्‌गाहिम्‍मो लाःसे़आङ् निङ्‌वाॽफुमाङ्‌ङो तोःम्‍मनाबा सेसे खरे़ःङ्‌ङिन् चआङ् याम्‍मो कुमनाहाॽआङ् पिरुसि (खे़न् ये़म्‍मो अबियाथारे़न् मानिङ्‌वाॽफुसाम्‍बा वये़)॥ खे़ङ्‌ग आनिॽ साम्‌योथिम् कुइसिःक् निङ्‌वाॽफुसाम्‍बाहाॽरे़रक् चामा के़नुॽबा वये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","हे़क्‍क्‍याङ् ये़सुरे़ अक्‍खे पाःत्तुर पाःन् नुप्‍सु, “नाःम्‍सिङ् ये़न्‍निन् मे़न्‍छाम्‍गे़न् याप्‍मि नुॽमा तामारे़ लागि चोगे़बारो, कर कन् मे़न्‍छाम्‍गे़न् याप्‍मिःन् नाःम्‍सिङ्‌ये़न्‍निल्‍ले़ लागि चोगे़बा मे़ःन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","हे़क्‍केःल्‍ले़ इङ्‌गाॽ मे़न्‍छाम्‍साःङ्‌ग नाःम्‍सिङ्‌ये़न्‍निल्‍ले़न्‍नाङ् कुन्‍दाङ्‌बाआॽरो” ");
INSERT INTO lifNT2_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ये़सुःन् याम्‍मो यहुदि चुम्‍लुङ्‌हिम्‍मो पे॥ खे़प्‍मो लत्‍छा कुहुक् के़हेबा मनाधिक् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","नाःम्‍सिङ्‌ये़न्‍नो खे़न् मनाःन् ये़सुरे़ वेःन्‍दुॽने़ फाॽग्र खुने़ॽ फोत्‍या कुःप्‍मा फाॽआङ् मनाहाॽरे़ ये़सुःन् मे़सुगुर मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ये़सुरे़ खे़न् कुहुक् के़हेबा मनाःन् मे़त्तु, “फे़रे़ॽआङ्‌के़रे़क्‍ले़ खुनिॽ तगि ये़बे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “नाःम्‍सिङ् ये़न्‍नो नुःबा नु ताप्‍फे़ःम्‍बा याःम्‍बक्‍को, आत्तिन् चोःक्‍मा नुःबाबे? हिङ्‌मन् ताङ्‌से़ःप्‍माबि मे़ङ्‌माबि?” कर खे़न् मनाहाॽ मे़म्‍बाःत्ते स्‍वाःत् मे़युङे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ चिःप्‍मान् निःसुआङ् खुने़ॽ कुनिङ्‌वाॽ तुगे़आङ् साॽरिक् कुसिक् पोगे़रो॥ हे़क्‍क्‍याङ् खे़न् मनाःन् मे़त्तु, “के़हुक्‍किन् सन्‍छे़ॽ॥” हे़क्‍क्‍याङ् खे़ल्‍ले़ कुहुक्‍किन् सन्‍छुल्‍ले़ खिमो वेःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","हे़क्‍क्‍याङ् फरिसिहाॽ यहुदि चुम्‍लुङ्‌हिम्‍मोलाम् मे़लःन्‍दे़ मे़बेआङ् हे़रोद हाङ्‌ङिल्‍ले़ कुमनाहाॽनु ये़सुःन् आक्‍खेआङ् से़प्‍माबे फाॽआङ् पाःन् मे़दङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","हे़क्‍क्‍याङ् ये़सुःन् कुहुॽसाम्‍बाहाॽनु वरक्‍किल्‍ले़ कुयाओ पेःल्‍ले़ खे़प्‍मो गालिल थुम्‍मोलाम् यरिक् मनाहाॽरे़ खुने़ॽ मे़दिम्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","खुने़ॽ चोगुबा याःम्‍बक्‍हाॽ मे़घे़प्‍सुआङ् यरिक् मनाहाॽ यहुदिया, यरुसले़म, इदुमिया, यर्दन नाधाःम्‍बिबा लाजेॽओनु, हे़क्‍क्‍याङ् तायर नु सिदोन ये़क्‌यक् खिरिलाम्‌कुओमे़त्‍छे़ मे़द्‌ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","हे़क्‍क्‍याङ् खुने़ॽ यरिक् मनाहाॽरे़ मे़न्‍लाःक्‍तुन्‍ल मे़न्‍दोॽरुन्‍ल फाॽआङ् कुहुॽसाम्‍बाहाॽ खःङ्‌बेधिक् कुलागि यारिप् चोःक्‍मा पाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","खुने़ॽ यरिक् मनाहाॽ नुसुसिबाल्‍ले़ चोगुल्‍ले़ खुने़ॽ कुसुःसे़ मनाहाॽ मे़जन्‍छिङ्‌ल मे़बोःरे़ मे़धाङे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","हे़क्‍क्‍याङ् फे़न्‍साम्‍हाॽरे़ याङ्‌घुसिबा मनाहाॽरे़ खुने़ॽ मे़निःसुल्‍ले़ खे़ङ्‌हाॽ मे़धाम्‍सिङ्‌ल मे़भिःक्‍ते़र अक्‍खेलॽरिक् मे़बारे़, “खे़ने़ॽग निङ्‌वाॽफुसाःने़रो!” ");
INSERT INTO lifNT2_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","कर ये़सुरे़ खे़ङ्‌हाॽ खुने़ॽ कुयाःम्‍बेओ थेआङ् मे़म्‍बाःत्तुन्‍ल फाॽआङ् के़साक्‍पा इङ्‌जाःङ् पिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","हे़क्‍क्‍याङ् ये़सुःन् कोःक्‍माओ पेर पत्‍छे़ल्‍ले़ कुनिङ्‌वाॽबाल्‍ले़ चसिबा कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् खे़ङ्‌हाॽआङ् खुने़ॽनुए मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","हे़क्‍क्‍याङ् खुने़ॽनु मे़वाॽर हे़क्‍क्‍याङ्‌सुनाइङ् मे़से़ःसुर फाॽआङ् थिक्-ने़त् (१२) हुॽसाम्‍बाहाॽ सेगुसिआङ् खे़ङ्‌हाॽ सेःक्‌युक्‍मिबा फाॽआङ् मे़त्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ फे़न्‍साम् नाःप्‍मा लःप्‍मा युक् पिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ये़सुरे़ सेगुसिबा थिक्-ने़त् कुहुॽसाम्‍बाहाॽरे़ खुनिॽ मिङ्‌हाॽ कन्‍लो–सिमोन (खुने़ॽ पत्रुस लॽरिक् मिङ् वाःत्तु), ");
INSERT INTO lifNT2_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","जब्‍दियारे़ कुस्‍साःहाॽ याकुब नु युहुन्‍ना (ये़सुरे़ खे़ङ्‌हाॽ बोअनरगे़स लॽरिक् मिङ् वाःत्तुसि, खे़ल्‍ले़ कुबेइङ्‌ग “ताङ्‌साक् के़लोःङ्‌बाल्‍ले़ कुस्‍साःहाॽ” पोःङ्‌लो), ");
INSERT INTO lifNT2_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","हे़क्‍क्‍याङ् आन्‍द्रियास, फिलिप, बारथोलोमाइ, मत्ति, थोमा, अल्‍फायसरे़ कुस्‍साः याकुब, थे़दियस, सिमोन (हाङ्‌बिफ्‍युङ् के़जोःक्‍पा), ");
INSERT INTO lifNT2_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","हे़क्‍क्‍याङ् यहुदा इस्‍करियोतिन्‌(ताःन्‍दि खे़ल्‍ले़ ये़सुःन् इङ्‌ले़क्‍तु)॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","हे़क्‍क्‍याङ् ये़सुःन् हिम्‍मो लाःसे़आङ् खे़प्‍मो यरिक् मनाहाॽ मे़जुप्‍से़बाल्‍ले़ चोगुल्‍ले़ खुने़ॽ नु कुहुॽसाम्‍बाहाॽरे़ चाजामा ये़म्‍मिन्‍ने मे़ङ्‌घोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","कुभा मनाहाॽ अक्‍खे मे़मे़त्‍छिङ्, “मे़ःम्‍बे़, आइन् खुने़ॽग नाक्‍खे़बे बि थेनिबे?” हे़क्‍केःल्‍ले़ कुहिम्‍सयङ्‌रे़ खे़न् मे़घे़प्‍सुआङ् खुने़ॽ खे़प्‍मोलाम् उःप्‍मा तेॽमा फाॽआङ् मे़द्‌ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","यरुसले़मलाम् के़दाःबा साम्‌योथिम्‍साम्‍बाहाॽरे़ अक्‍खे मे़बाःत्तु, “खुने़ॽग बालजिबुल माफे़न्‍साम्‍मिल्‍ले़ याङ्‌घुआङ् वाॽ॥ खुने़ॽ फे़न्‍साम्‍हाॽरे़ खुनिॽ हाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍लाम् फे़न्‍साम्‍हाॽ नाःत्तुॽ लःत्तुसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ उःत्तुसिआङ् खे़दाॽओ मे़त्तुसि, “आक्‍खेलॽरिक् माफे़न्‍साम्‍मिन् आबाङे नाःत्‍छिङ्बे? ");
INSERT INTO lifNT2_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","आप्‍फेःक् लुम्‍मो के़घेबा के़धक्‍पाआङ् के़से़म्‍बा हाङ्‌जुम्‍मिल्‍ले़ मे़धरुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","हे़क्‍क्‍याङ् आप्‍फेःक् लुम्‍मो के़घेबा के़धक्‍पाआङ् के़से़म्‍बा हिम्‍सयङ्‌ङिल्‍ले़ मे़धरुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","माफे़न्‍साम्‍मिन्‍नाङ् आबाङे तक्‍ले़ङ्‌वाओ पोःक्‍ने़ फाॽग्र खे़ल्‍ले़आङ् मे़धरुन्‍नाङ् नुप्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","के़धुम्‍बा मनाःल्‍ले़ कुहिम्‍मो लाःप्‍माआङ् खे़ल्‍ले़ कुजिगःक्‌वाहाॽ नाप्‍मादेॽमानुःल्‍ले़ तगि खे़न् के़धुम्‍बा मनाःन् इघेःङ्‌माए पोःङ्‌लो॥ हे़क्‍क्‍याङ्‌लक् कुहिम्‍मो लाःप्‍माआङ् चिगःक्‌वाहाॽ लःप्‍मादेॽमा सुक्‍ते़त्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, मे़न्‍छाम् याप्‍मिहाॽरे़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ मे़बाःत्तुबा के़रे़क् माङ्‌चे़ॽया पाःन् नु मे़जोगुबा के़रे़क् लायोहाॽरे़न् ले़प्‍मि खोःमा मे़सुक्‍तुरो, ");
INSERT INTO lifNT2_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","कर सेसेमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पाःन् के़बाःप्‍पाहाॽरे़ आप्‍फाल्‍ले़आङ् ले़प्‍मि मे़ङ्‌घोःसुन्‍लो, थेआङ्‌भे़ल्‍ले़ कङ्‌ग ले़प्‍मि मे़म्‍बोःङ्‌मनाबा लायोरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(ये़सुरे़ फे़न्‍साम्‍मिन् कत्तु लॽरिक् खे़ङ्‌हाॽरे़ मे़बाःत्तुआङ् मे़वये़बाल्‍ले़ चोगुल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ हे़क्‍के मे़त्तुसिबारो॥) ");
INSERT INTO lifNT2_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","याङ्‌सि ये़सुरे़ कुम्‍मा नु कुन्‍साॽसि खुने़ॽ वये़बा हिम्‍मो मे़द्‌ये़आङ् लाःक्‍कात् कुउःत्‍छे़ मनाहाॽ मे़बाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","हे़क्‍क्‍याङ् कुगब्रिङ् के़युङ्‌बा मनाहाॽरे़ खुने़ॽ मे़मे़त्तु, “के़म्‍मा नु के़न्‍साॽसि लाःक्‍कात् मे़द्‌ये़आङ् खे़ने़ॽ के़म्‍हाङ्‌ल मे़ये़प्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “आम्‍मा नु आन्‍साॽसि हाःत्‍छिबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","खुने़ॽ खे़प्‍मो कुगब्रिङ् के़युङ्‌बा मनाहाॽ ओमे़त्तुसिर याम्‍मो पाःत्तु, “कप्‍मो आम्‍मा नु आन्‍साॽसि मे़युङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","आत्तिन्‍हाॽरे़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिङ्‌वाॽ हे़क्‍के मे़जोगुॽ खे़ङ्‌हाॽए आम्‍मा नु आन्‍साॽसिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","याङ्‌सि याम्‍मो ये़सुरे़ गालिल वरक्‍किल्‍ले़ कुयाओ निसाम् हुॽमा हेःक्‍तुसिरो॥ खे़प्‍मो यरिक् मनाहाॽ मे़जुप्‍से़, हे़क्‍केःल्‍ले़ खुने़ॽ खःङ्‌बेओ लाःसे़आङ् युङ्‌सिङ्‌, कर मनाहाॽ लाःक्‍कात् वरक्‍किल्‍ले़ कुयाओ मे़ये़बे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","हे़क्‍क्‍याङ् ये़सुरे़ अक्‍खेलॽरिक् यरिक् पाःन्‍हाॽ खे़दाॽओ हुॽरुसि– ");
INSERT INTO lifNT2_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“खे़प्‍से़म्‍मे़ॽओ! लत्‍छा याःन्‍के़मःबाधिक् याॽरिःम्‍बा ले़प्‍से़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","खे़ल्‍ले़ याॽरिःम्‍बे़न् ले़प्‍तुल्‍ले़ कुभा याॽरिःम्‍बे़न् लाम्‍मो मक्‍थ्‍ये़, हे़क्‍क्‍याङ् पुहाॽ मे़द्‌ये़आङ् मे़जमे़देःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","हे़क्‍क्‍याङ् कुभा याॽरिःम्‍बे़न् लुङ्‌घे़रे़क्‍को चुक्‍ते़रो॥ खे़ङ्‌हाॽ लिङ्‌माग लिङे़, कर यरिक् खाम् मे़ने़स्‍से़न्‍नाङ् कुसाःप्‍पिन् खाम् सिगाङ्‌धारिक् मे़लाःसे़न्‍बाल्‍ले़ चोगुल्‍ले़ कुदाःन्‍दिक्‍मा नाम् से़ःरे़ल्‍ले़ नाम्‍मिल्‍ले़ ये़म्‍दुआङ् काक् हेरे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","हे़क्‍क्‍याङ् कुभा याॽरिःम्‍बाङ्‌ग तिङ्‌ग्रेःक्‍पाल्‍ले़ कुसेॽ के़ने़बा ते़न्‍नो चुक्‍ते़आङ् सोसोरिक् लिङे़ल्‍ले़ तिङ्‌ग्रेःक्‍पाल्‍ले़ खे़न् सुःप्‍तुदेःसुआङ् कुजाॽ थोःक्‍मा मे़सुक्‍ते़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","वेॽ याॽरिःम्‍बे़न् नुःबा खाम्‍मो चुक्‍ते़॥ हे़क्‍क्‍याङ् लिङे़आङ् खे़ङ्‌हाॽरे़ सुम्‍बोःङ् ले़ङ् (३०), तुक्‍पोःङ्‌ले़ङ् (६०) हे़क्‍क्‍याङ् किप्‍थिक् ले़ङ् (१००) थारिक् कुजाॽ पत्‍छे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खे़म्‍मा ने़क्‍खोॽ के़गप्‍पाहाॽरे़ कन् पाःन्‍निन् नुःरिक् खे़प्‍से़म्‍मे़ॽआङ् कुसिङ्‌निःत्ते़म्‍मे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","हे़क्‍क्‍याङ् ये़सुःन् एःक्‍लेःक्‌वये़ल्‍ले़ थिक्-ने़त् (१२) हुॽसाम्‍बाहाॽ नु वेॽ हुॽसाम्‍बाहाॽरे़ “कन् खे़दाॽइल्‍ले़ कुबेःन् थे़माबे?” फाॽआङ् सेःन्‍मे़दोसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़न् सिगाङ्‌बा पाःन्‍हाॽ कुसिङ् निःप्‍मा के़घोःसुम्‍माङ् के़वयिॽ, कर वेॽ मनाहाॽरे़ग खे़दाॽओरक् खे़म्‍मा मे़घोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","खे़ल्‍ले़ चोगुल्‍ले़ अक्‍खे साप्‍ते़आङ् पत्, ‘खे़ङ्‌हाॽरे़ ओमे़मे़त्तु, ए़त्‍ले़ङ् ओमे़मे़त्तुसाङ् मे़न्‍निःसुन्॥ खे़ङ्‌हाॽरे़ ए़त्‍ले़ङ् मे़घे़प्‍सुसाङ् कुसिङ् मे़न्‍निःत्तुन्॥ मे़ःन्‍ने़ फाॽग्र खे़ङ्‌हाॽग लायोलाम् मे़नुःङ् मे़दाआङ् लायोलाम् ले़प्‍मि मे़घोःसुॽबारो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “कन् खे़दाॽइन्‍ने कुसिङ् के़न्‍निःत्तुम्‍मिन्‍ने़ फाॽग्र, वेॽ खे़दाॽहाॽ आक्‍खेलॽरिक् कुसिङ् के़निःत्तुम्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","याॽरिःम्‍बा के़ले़प्‍पाल्‍ले़ निङ्‌वाॽफु पाःन्‍जाक्‍किन् से़ःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","कुभा मनाहाॽ लाम्‍मो के़जुक्‍पा याॽरिःम्‍बा कुइसिःक् मे़जोःक्‍लो॥ खे़ङ्‌हाॽरे़ पाःन्‍जाक् मे़घे़प्‍सुनुमे़ःन्‍ने माफे़न्‍साम्‍मिन् ताआङ् पाःन्‍जाक्‍किन् खुनिॽ निङ्‌वाॽबोलाम् लःत्तु तेॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","वेॽ मनाहाॽ लुङ्‌घे़रे़क्‍को के़जुक्‍पा याॽरिःम्‍बा कुइसिःक् मे़जोःक्‍लो॥ पाःन्‍जाक् मे़घे़प्‍सुल्‍ले़ मे़सःत्‍ल मे़घे़प्‍सुॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","कर ताङ्‌बा कुसाःप् के़बप्‍पा कुबुङ्‌मान् हे़क्‍के खे़ङ्‌हाॽ सप्‍फारक् मे़बत्‍लो, कर पाःन्‍जाक्‍किन्‌नसाःन् मे़जोगुबाल्‍ले़ चोगुल्‍ले़ के़साक्‍पा पाःन् नु तुक्‍खेःन् तानुमे़ःन्‍ने हाराए नसाःन्‍निन् मे़ले़रु मे़देःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","वेॽहाॽ तिङ्‌ग्रेःक्‍पालाओ के़जुक्‍पा याॽरिःम्‍बा कुइसिःक् मे़जोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","खे़ङ्‌हाॽरे़ पाःन्‍जाक् खे़म्‍माग मे़घे़प्‍सुॽ, कर कन्‌हिङ्‌मन्‍नो थेःन् चामा थुङ्‌मा, याङ्‌साकुन्‍धेसाबा आक्‍खेआङ् पोःङ्‌मा हे़क्‍तङ्‌बा वेॽ फे़न् निङ्‌वाॽइल्‍ले़ पाःन्‍जाक्‍किन् सुःप्‍तुदेःसुॽरो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ याम्‍मो कुजाॽ मे़म्‍भत्‍छुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","कर वेॽ मनाहाॽ नुःबा खाम्‍मो के़जुक्‍पा याॽरिःम्‍बा कुइसिःक् मे़जोःक्‍लो॥ खे़ङ्‌हाॽरे़ पाःन्‍जाक्‍किन् मे़घे़प्‍सुआङ् निङ्‌वाॽओ मे़दाःक्‍तु, हे़क्‍क्‍याङ् सुम्‍बोःङ् (३०) ले़ङ्, तुक्‍पोःङ्‌(६०) ले़ङ् हे़क्‍क्‍याङ् किप्‍थिक् (१००) ले़ङ् थारिक् कुजाॽ मे़भत्‍छुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","आल्‍ल ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ सेमिःन् ने़त्‍ना सिगाङ् के़युक्‍खुम्बि? इ नइमाल्‍ले़ के़सुःप्‍तुम् के़युक्‍खुम्बि? हाःत्‍ले़आङ् हे़क्‍केग मे़जोगुन्‍लो, कर सेमिःन् चम्‍जम्‍बा ते़न्‍नो थो युक्‍खुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","हे़क्‍केःल्‍ले़ सिगाङ्‌बा पाःन्‍निन् के़रे़क्‍ले़ मे़निःसु, हे़क्‍क्‍याङ् चिङ्‌नाबा पाःन्‍निन् ओसेःन्‍दाङ् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खे़म्‍मा ने़क्‍खोॽ के़गप्‍पाहाॽरे़ कन् पाःन्‍निन् नुःरिक्‍काङ् खे़प्‍से़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","खुने़ॽ याम्‍मो मे़त्तुसि, “सिङ्‌सिङ्‌ङाङ् खे़प्‍से़म्‍मे़ॽओ! आक्‍तङ्‌बा कुसिःक्‍माल्‍ले़ के़सिःक्‍तुम्‍सिम्, आम्‍भा खे़न् कुसिःक्‍माल्‍ले़ खिनिॽआङ् के़म्‍सिःक्‍तिॽ, खे़न्‍नुःल्‍ले़ यरिक्‍काङ् खिनिॽ के़म्‍सिःक्‍ति के़म्‍बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","यरिक् के़गप्‍पाल्‍ले़ आल्‍लसाङ् यरिक् खोःसुॽ, कर हाःत्‍ले़ मे़गत्तुन्, खे़ल्‍ले़ कत्तुबान्‍नाङ् मे़नाप्‍तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ये़सुरे़ याम्‍मो पाःत्तु, “निङ्‌वाॽफुहाङ्‌जुम्‍मिन् अक्‍तङ्‌बा चोःक्–मनाधिक्ले़ याॽरिःम्‍बान् इक्‍ताप्‍पो ले़प्‍तुॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","हे़क्‍क्‍याङ् ये़म् ले़क्‍ल पेःक्‍किल्‍ले़, खुने़ॽ खे़न् याॽरिःम्‍बान् आक्‍खेलॽरिक् लिङ्‌फाॽआङ् कुसिङ् मे़निःत्तुन्‍छाङ् खे़न् याॽरिःम्‍बान् लिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","आबाङे खाम्‍बेःक्‍मो पोगुगे़न् कुजाःन् लिङ्‌, खाम्‍बेःक्‍माल्‍ले़ए कुजाॽ थोःक्‍ल याःन्‍दुॽ, तगि कुनःक्‌थाङ्‌हे़क्‍क्‍याङ् पोआङ्‌कुजाॽ थोःक्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","पोगुगे़न् कुजाःन् तुम्‍माङ् खे़न् मनाःन्‌कात्‍च्‍याःन् याङ्‌सिङ्‌ङाङ् चा सुम्‍से़ इक्‍ताप्‍पो लाःत्, थेआङ्‌भे़ल्‍ले़ चासुम्‍मा ये़म्‍मिन् त्‍ये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ये़सुरे़ याम्‍मो पाःत्तु, “निङ्‌वाॽफुहाङ्‌जुम्‍मिन् थेःन्‍नु तङ्‌माबे? आक्‍खेलॽरिक् कुबि पिमाआङ् पोधक् चोःक्‍माबे? ");
INSERT INTO lifNT2_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","कङ्‌ग खाम्‍मो ले़प्‍मनाबा यःङ्‌गेॽ याॽरिःम्‍बान् कुइसिःक् चोःक्‍लो॥ इक्‍सा खाम्‍बेःक्‍कोबा याॽरिःम्‍बाहाॽओ खे़न् के़रे़क्‍नुःल्‍ले़ चुक्‍साङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","इक्‍ताप्‍पो वेॽ नुधि-साक्‍चिॽनुःल्‍ले़ यम्‍बा पोःङ्‌ङाङ् कुबोराःक्‍हाॽओ पुहाॽरे़आङ् हाप् मे़जोगुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ये़सुरे़ अक्‍तङ्‌बा खे़दाॽओ मनाहाॽरे़ पाःन्‍जाक् कुसिङ् निःप्‍मा मे़सुक्‍तुर थारिक् हुॽरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","खुने़ॽ पारे़ल्‍ले़ खे़दाॽओरक् पारे़, कर कुहुॽसाम्‍बाहाॽनु एःक् मे़वये़ल्‍ले़ खे़दाॽइल्‍ले़ कुबेःन् हन्‍दु पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","खे़न् से़न्‍दिक् ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “वरक्‍किल्‍ले़ नाहाङ्‌दाङ् पेगि॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","हे़क्‍केलॽरिक् यरिक् मनाहाॽनु मे़से़न्‍दे़आङ् खुने़ॽ बा खे़न् खःङ्‌बेओनु नाहाङ्‌दाङ् मे़देॽरुरो॥ खे़प्‍मो वेॽ खःङ्‌बेहाॽआङ् मे़ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","हक्‍चघत् यम्‍बा सुरित्‌केजङ् हुःमा हेःक्‍ते़आङ् वाभे़ल्‍ले़ङ्‌ङिन् खःङ्‌बेओ लाःसे़आङ् खा खःङ्‌बेइन्‍ने तिम्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ये़सुःन् खःङ्‌बेल्‍ले़ कुएःक् ले़प्‍माङ् ताक्‍खोःङ्‌धिक्‌कोःक्‍सिङ्‌ङाङ् इप्‍से़आङ् ने़स्‍से़॥ कुहुॽसाम्‍बाहाॽरे़ मे़भोःक्‍खुर अक्‍खे मे़मे़त्तु, “सिक्‍साम्‍बे, आनिगे़ हुम्‍मा सिःमा इःत्तिगे़रो! थेआङ् स्‍वाःत् के़ने़बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ये़सुःन् पोगे़आङ् सुरित्‌केजङ्‌ङिन् “मे़न्‍हुःए़ॽ” मे़त्तुआङ् फे़ःक्‍तु, हे़क्‍क्‍याङ् वाभे़ल्‍ले़ङ्‌ङिन् “चिजि ये़म्‌ये़म् लॽरे़ॽ” मे़त्तु, सुरित्‌केजङ्‌ङिन् चिजि ये़म्‌ये़म् लॽरे़आङ्, वाभे़ल्‍ले़ङ्‌ङिन्‍नाङ् चिजि ये़म्‌ये़म् पोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ सेःन्‍लाप्‍तुसि, “थेआङ् खिनिॽ के़गिःसि के़स्‍ये़ॽइबा? आल्‍लसाङ् याप्‍मि नसाःन् के़न्‍जोगिन्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","कर खे़ङ्‌हाॽ साॽरिक् मे़गिसे़आङ् अक्‍खे मे़मे़त्‍छिङ्, “आक्‍खेलॽरिक् खुने़ॽ पाःत्तुबा पाःन्‍निन् सुरित्‌केजङ्‌ङिन्‌नु वाभे़ल्‍ले़ङ्‌ङिल्‍ले़आङ् खे़प्‍सुबाबे? कन् मनाःङ्‌ग हाःप्‍पे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ये़सुःन् नु कुहुॽसाम्‍बाहाॽ वरक्‍किल्‍ले़ नाहाङ्‌दाङ् गेरासेनस लाजेॽओ मे़गे़रे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ये़सुःन् खःङ्‌बेओनु लाःक्‍कात् लःन्‍दे़नुमे़ःन्‍ने फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबा मनाधिक् इप्‍पुङ्‌दे़न्‍नोलाम् खुने़ॽ कुदुम्‍से़ त्‍ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","खे़न् मनाःन् इप्‍पुङ्‌दे़न्‍हाॽओ वये़गत्ते़॥ हाःत्‍ले़आङ् खे़न् फे़न्‍थक्‍क्रङ्‌ङिल्‍ले़आङ् इघेःङ्‌मा मे़सुक्‍तुन्, ");
INSERT INTO lifNT2_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","थेआङ्‌भे़ल्‍ले़ मनाहाॽरे़ यरिक्‍ले़ङ् कुहुक् कुलाङ्‌ङो इमे़घेःक्‍खु मे़भत्‍छु मे़बिरुबा फे़न्‍थक्‍क्रङ्‌हाॽ नु फे़न्‍हुक्‍पाःङ्‌गिहाॽ फुॽरुआङ् वये़रो॥ आत्तिल्‍ले़आङ् खे़न् मनाःन् युक्‍को कप्‍मा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","खे़न् इप्‍पुङ्‌दे़न्‍नो नु कोःक्‍मा फाङ्‌जङ्‌घाःत्तिरक् से़न्‍दिक् ले़न्‍दिक् अःक्‍ते़र फिःक्‍ते़र लुङ्‌ङिल्‍ले़ खे़ःन्‍छिङ्‌ल वये़गत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","हे़क्‍क्‍याङ् खे़ल्‍ले़ ये़सुःन् माःङ्‌घालाम्‍मे निःसुआङ् लोःक्‍ते़र फे़रे़आङ् मिङ्‌सो इङ्‌धाःङ् पिरुर कुलाङ्‌जक्‍को थुङ्‌बोहजॽ युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","खे़ल्‍ले़ यम्‍बा इक्‍लाओ अःक्‍ते़र ये़सुःन् मे़त्तु, “के़रे़क्‍नुःल्‍ले़ पयम् यम्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुस्‍साः ये़सुए, खे़ने़ॽ इङ्‌गाॽनु थे के़गोःत्तुबाबे? इङ्‌गाॽ तुक्‍खे मे़जाःत्ताङ्‌ङिन्‍ने़ॽ फाॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमिङ्‌ङो पेलि फाक्‍ने़ॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(थेआङ्‌भे़ल्‍ले़ तगि ये़सुरे़ खे़न् फे़न्‍साम्‍मिन् खे़ने़ॽ खे़न् मनाओलाम् लाःक्‍कात् लःन्‍दे़ पेगे़ॽ फाॽआङ् मे़त्तुआङ् वये़रो॥) ");
INSERT INTO lifNT2_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् सेःन्‍दोसु, “के़मिङ् थे़माबे?” हे़क्‍क्‍याङ् खे़ल्‍ले़ नोगप् पिरु, “इङ्‌गाॽ आमिङ् तुरारो, थेआङ्‌भे़ल्‍ले़ कन् मनाओ आनिगे़ यरिक् यागिगे़॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","हे़क्‍क्‍याङ् खे़ल्‍ले़ ये़सुःन् पेलि फाक्‍तु, “कन् थुम्‍मोलाम् आनिगे़ आम्‍बाङ्‌घे़न्‍ने़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","आल्‍ल खे़न् कोःक्‍माओ यरिक् फाक्‍हाॽ चामे़रामे़र मे़ये़बे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","हे़क्‍क्‍याङ् खे़न् फे़न्‍साम्‍हाॽरे़ ये़सुःन् पेलि मे़भाक्‍तु, “आनिगे़ खे़न् फाक्‍हाॽओ लाःप्‍मा आबाङ्‌घे़ॽओ॥ आनिगे़ खे़ङ्‌हाॽओ लाःसिगे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","हे़क्‍क्‍याङ् ये़सुरे़आङ् खे़ङ्‌हाॽ लाःप्‍मा पाङ्‌घुसिआङ् फे़न्‍साम्‍हाॽ खे़न् मनाओलाम् मे़लःन्‍दे़ मे़बेआङ् फाक्‍हाॽओ मे़लाःसे़॥ खे़न् हे़न्‍छिङ् ने़त्‍छि यारिक् फाक्‍हाॽ सङ्‌माङ्‌ङे सङ्‌माङ् मे़लोःक्‍ते़र याक्‍पे़ओनु मक्‍मे़ध्‍ये़आङ् वरक्‍को मे़हुमे़ मे़स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","खे़प्‍मो फाक् के़गम्‍बाहाॽआङ् मे़वये़॥ खे़ङ्‌हाॽ मे़लोःक्‍ते़र मे़बेआङ् पाङ्‌जुम्‍मो नु खे़न् खिरिबा पाङ्‌भेॽहाॽओ कन् पाःन्‍निन् मे़से़ःसु॥ हे़क्‍क्‍याङ् मनाहाॽ थेःन्‍ने़ पोःक्‍खे़बे फाॽआङ् ओमे़त्‍छे़ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","16","ये़सुःन् वये़बा ते़न्‍नो मे़द्‌ये़रो॥ खे़प्‍मो खे़ङ्‌हाॽरे़ तगि फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबा मनाःन् वेःत्ते़आङ् नुःरिक्‍काङ् तेःत् चाक्‍खुआङ् युङे़बा मे़निःसु॥ हे़क्‍क्‍याङ् खे़न् मनाःन् नु फाक्‍हाॽ थे मे़बोःक्‍खे़ फाॽआङ् के़निःबा मनाहाॽरे़ मे़जे़क्‍तुसि॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ साॽरिक् मे़गिसे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ ये़सुःन् आनिगे़ थुम्‍मोलाम् लःन्‍दे़ पेगे़ॽ फाॽआङ् पेलि मे़भाक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ये़सुःन् खःङ्‌बेओ लाःसे़र पत्‍छे़ल्‍ले़ तगि फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबा मनाःन् ये़सुरे़ कुबेसाङ् त्‍ये़आङ्, आदाङ्‌बे, इङ्‌गाॽआङ् खे़ने़ॽनुए तेॽराङ्‌ङे़ॽओ फाॽआङ् पेलि फाक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","कर ये़सुरे़ मे़दे़न्‍दे़न्‍ल अक्‍खे मे़त्तु, “खे़ने़ॽ नुःक्‍खे़ पेगे़ॽआङ् के़हिम्‍सयङ् नु के़बाङ्‌भेॽसाबाहाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़लागि चोगुबा यम्‍बा याःम्‍बक्‍किन् नु लुङ्‌माॽ के़दुक्‍ते़बा पाःन्‍निन् चे़क्‍ते़से़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","हे़क्‍क्‍याङ् खे़न् मनाःन्‍नाङ् खे़प्‍मोलाम् नुःक्‍खे़ पेआङ् थिबोःङ् पाङ्‌जुम्‍मिल्‍ले़न्‌थुम्‍मो खाराक्‌ये़सुरे़ चोगुबा यम्‍बा पाःन्‍निन् इङ्‌भन् से़ःसुरो॥ हे़क्‍क्‍याङ् मनाहाॽरे़ खे़न् मे़घे़प्‍सुआङ् खुनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ये़सुःन् खःङ्‌बेओ लाःसे़आङ् वरक्‍किल्‍ले़ नाहाङ्‌दाङ् नुःक्‍खे़ पेआङ् वरक्‍किल्‍ले़ कुयाओ यरिक् मनाहाॽ कुगब्रिङ् मे़जुप्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","पाङ्‌तिबा यहुदि चुम्‍लुङ्‌हिम्‍मोबा लाम्‍लोःबा याइरस मे़प्‍मनाबा मनाःन् त्‍ये़ हे़क्‍क्‍याङ् ये़सुरे़ कुलाङ्‌जक्‍को हबत्‌फन्‍छिङ्‌ल ");
INSERT INTO lifNT2_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","अक्‍खेलॽरिक् पेलि फाक्‍तु, “आदाङ्‌बे, इङ्‌गाॽ आस्‍साः चुक्‍मे़न् सिःमा लिङ्‌धोओ के़रे़आङ् ने़रो॥ खे़न् वेःत्ताङ् हिङ्‌ल फाॽआङ् खे़ने़ॽ फे़रे़ॽआङ् के़हुक्‍किन् कुसम्‍दाङ् ने़स्‍से़ पिरे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","हे़क्‍क्‍याङ् ये़सुःन् खे़न्‍नु थासिङ्, हे़क्‍क्‍याङ् यरिक् मनाहाॽरे़ खुने़ॽ चिभिःत् मे़भिःत्तुर मे़दिम्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","खे़प्‍मो तङ्‌बे थिक्-ने़त्ताङ्‌धो (१२) माक्‍खिॽ वयुःमाल्‍ले़ तरुमा मे़न्‍छुमाॽधिक् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","खुने़ॽ यरिक् सिदाॽसाम्‍बाहाॽरो सिदाॽ मे़त्‍छिङ्‌से़ पेआङ् खुने़ॽ कत्तुबा के़रे़क् याङ्‌साकुन्‍धेहाॽ माःन्‍दुसाङ्, खे़न् वेःप्‍माल्‍ले़ कुले़क्‌वा खे़न्‍नुःल्‍ले़आङ् साॽरिक् तुगे़बेआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","खे़ल्‍ले़ ये़सुरे़ कुयाःम्‍बेओ खे़प्‍सुआङ् वये़॥ हे़क्‍क्‍याङ् खे़न् मे़न्‍छुमाॽइल्‍ले़ मनाहाॽरे़ खुनिॽ एगाङ्‌लाम् त्‍ये़आङ् ये़सुरे़ कुदेःत्तिन् सुःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","29","थेआङ्‌भे़ल्‍ले़ खुने़ॽ कुदेःत्तिन्‍लक्‌सुःसुङ्‌साङ् इङ्‌गाॽ वेःत्ता लॽरिक् कुनिङ्‌वाॽओ इःत्‍छिङ्‌॥ हे़क्‍क्‍याङ् ये़सुरे़ कुदेःत्तिन् सुःसुनुमे़ःन्‍ने कुधक्‍को माक्‍खिॽ वयुःमान् चिबे़आङ् चाङ्‌जाङ् लॽरे़बा निङ्‌वाॽ खोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","खिमो ये़सुरे़ कुधक्‍कोनु मुक्‍साम् लःन्‍दे़बा निङ्‌वाॽ खोःसुआङ् खिरि हिसिङ्‌ङाङ् मनाहाॽ ओमे़त्तुसिर मे़त्तुसि, “हाःत्‍ले़ इङ्‌गाॽ आदेःत्तिन् सुःसुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ये़सुरे़ कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ मे़मे़त्तु, “आदाङ्‌बे, अक्‍खेलॽरिक् मनाहाॽरे़ के़म्‍जन्‍ल के़म्‍भिःत्‍ल मे़बत्, हे़क्‍केःल्‍ले़ आक्‍खेलॽरिक् हाःत्‍ले़ सुःसाङ्‌बे फाॽआङ्‌के़बाःत्तुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","कर ये़सुरे़ खुने़ॽ के़सुमे़न् ओमे़त्‍छे़ खिरि ओमये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","खे़न् मे़न्‍छुमाॽइल्‍ले़ नासिङ्‌गे़न् कुधक्‍को पोःक्‍खे़बा पाःन्‍निन् निङ्‌वाॽ इःत्तुआङ् कुगिःमाल्‍ले़ यक्‍खे़र ये़सुरे़ कुलाङ्‌जक्‍को हबत्‌फन्‍छिङ्‌ल ये़सुःन् के़रे़क् पाःन्‍निन् चे़क्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","हे़क्‍क्‍याङ् ये़सुरे़ मे़त्तु, “मामुए, नसाःन् के़जोगुबाल्‍ले़ चोगुल्‍ले़ खे़ने़ॽ के़वेःत्ते़रो॥ खे़ने़ॽ के़वेःत्ते़आङ् के़वाॽरो, नुःरिक्‍काङ् पेगे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ये़सुःन् पारे़र पत्‍छे़ल्‍ले़ खे़न् लाम्‍लोःबा याइरसरे़ कुहिम्‍मोलाम् इङ्‌साबाहाॽ मे़द्‌ये़आङ् मे़मे़त्तु, “आदाङ्‌बे, के़स्‍साःङ्‌ग स्‍ये़रो॥ आल्‍ल सिक्‍साम्‍बे़न् थेआङ् तुक्‍खे चाःप्‍माबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","कर ये़सुरे़ खे़न् खे़म्‍खे़म्‍माङ् मे़न्‍लाप्‍पे याइरसे़न् मे़त्तु, “खे़ने़ॽ मे़गिसे़न्‍ने़ॽओ, नसाःन्‍लक् चोगे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","हे़क्‍क्‍याङ् ये़सुरे़ पत्रुस, याकुब नु कुन्‍साॽ युहुन्‍नाःन्‍लक् खुने़ॽनु पेःक्‍मा पाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","खे़ङ्‌हाॽ याइरसरे़ कुहिम्‍मो मे़गे़रे़ल्‍ले़ मनाहाॽ हयङ्‌किल्‍लिङ् नु मेरिङ् थक्‍नु मे़हाबे़र मे़यागे़बा ये़सुरे़ निःसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","हे़क्‍क्‍याङ् खुने़ॽ हिम् सिगाङ् लाःसे़आङ् खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ थेआङ् हयङ्‌किल्‍लिङ् नु मेरिङ् थक्‍नु के़हाबिबाबे? चुक्‍मे़ङ्‌ग मे़न्‍छिःए वाॽ, इप्‍से़आङ्‌लक् ने़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","खे़ङ्‌हाॽरे़ खुने़ॽ मे़एःत्तु, कर ये़सुरे़ खे़ङ्‌हाॽ के़रे़क् लाःक्‍कात् लःत्तुसिआङ् चुक्‍मे़ल्‍ले़ कुम्‍बा कुम्‍मा हे़क्‍क्‍याङ् खुने़ॽनु के़वाॽबा कुहुॽसाम्‍बाहाॽ चुक्‍मे़न् ने़स्‍से़बा ते़न्‍नो तेॽरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","हे़क्‍क्‍याङ् खे़न् चुक्‍मे़ल्‍ले़ कुहुक्‍को ते़म्‍सुआङ् “तलिता कुमि” मे़त्तु, खे़ल्‍ले़ कुबेःङ्‌ग “चुक्‍मे, पोगे़ॽओ!” पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","खिमो खे़न् चुक्‍मे़न् मुत्‍थ्रिक् पोगे़आङ् लाङ्‌घेगे़॥ (खे़न् तङ्‌बे थिक्-ने़त् (१२) के़रे़आङ् वये़॥) खे़ङ्‌हाॽ के़रे़क्‍ले़ खुनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ कन् पाःन्‍निन् आत्तिन्‍नाङ्‌मे़मे़त्ते़म्‍मिन्‍ने़ॽ फाॽआङ् के़साक्‍पा इङ्‌जाःङ् पिरुसि॥ हे़क्‍क्‍याङ् खे़न् चुक्‍मे़न् थे़माइ चामा पिरे़म्‍मे़ॽ फाॽआङ् मे़त्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ये़सुःन् खे़प्‍मोलाम् पेआङ् कुहुॽसाम्‍बाहाॽनु आबाङे कुबाङ्भेॽओ त्‍ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","हे़क्‍क्‍याङ् नाःम्‍सिङ्‌ये़न्‍नो ये़सुःन् यहुदि चुम्‍लुङ्‌हिम्‍मो पेआङ् हुॽमा हेःक्‍तुसि॥ खे़प्‍मो यरिक् मनाहाॽरे़ खुने़ॽ कुनिसाम्‍मिन् मे़घे़प्‍सुआङ् खुनिॽ निङ्‌वाॽ मये़आङ् अक्‍खे मे़बाःत्तु, “कन् मनाःल्‍ले़ अक्‍तङ्‌बा पाःन्‍निन् आत्तो खोःसुबे? आक्‍खेलॽरिक् सिक्‍कुम् निङ्‌वाॽ नु निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ चोगुबे! ");
INSERT INTO lifNT2_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","कङ्‌ग मरियम‌रे़ कुस्‍साः सिङ् के़गाम्‍बे़न् मे़ःम्‍बि? कङ्‌ग याकुब, युसुफ, यहुदा नु सिमोनसिरे़ खुनिॽ फुॽने मे़ःम्‍बि? कल्‍ले़ कुन्‍साॽ मे़न्‍छुमाहाॽग आनिॽनुएसे़ मे़वाॽबा॥” हे़क्‍केःल्‍ले़ खे़न् मनाहाॽरे़ खुने़ॽ नामे़न्‍छाॽरुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़ङ्‌ग कुबाङ्‌भेॽसाबाहाॽ, कुगाॽइसोधोःक्‍हाॽ नु कुहिम्‍सयङ्‌हाॽरे़ इङ्‌धाःङ् मे़म्‍बिरुन्‍लो॥ कर वेॽ ते़न्‍नोरक् खुने़ॽ कुबाःन्‍निन् मे़घे़प्‍सुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","खे़प्‍मोबा मनाहाॽरे़ खुनिॽ नसाःन् होःप्‍ते़बाल्‍ले़ चोगुल्‍ले़ ये़सुरे़ निङ्‌वाॽ के़माबा याःम्‍बक् चोःक्‍मा मे़सुक्‍तुन्, कर थिक्-ने़त्‍छि के़दुक्‍पाहाॽ सम्‍दाङ्‌लक् कुहुक् ने़स्‍सु पिरुसिआङ् वेःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ नसाःन्‍निन् होःप्‍ते़बा निःसुआङ् कुनिङ्‌वाॽ मये़॥ हे़क्‍क्‍याङ् ये़सुरे़ पाङ्‌भेॽहाॽओ हुॽरुसिर पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","थिक्-ने़त् (१२) कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् फे़न्‍साम्‍हाॽ नाःप्‍मा लःप्‍मा युक् पिरुसि॥ हे़क्‍क्‍याङ् सुनाइङ् इङ्‌भन् से़ःसे़ ने़त्‍ने़त्‍छि पाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","हे़क्‍क्‍याङ् अक्‍खेलॽरिक् इङ्‌जाःङ् पिरुसि, “खिनिॽ लाम्‍दिःक्‍को के़बेगिल्‍ले़ तक्‍काःत्‍लक्‌याङ्‌ङासिम्‍मे़ॽ, खे़न्‍नाङ्धो वेॽ चामा चा, सुःक्‌वा नु याङ् थेआङ् मे़देॽरे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","लाङ्‌सुःप्‍पिन् चाक्‍खे़म्‍मे़ॽ, कर वेॽ ले़क्‍सिङ्‌मा चाङ्‌मे़बक्‍खे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","खिनिॽ के़बेगिल्‍ले़ आत्तिन् हिम्‍मो लाङ्‌दाःक्‍मा के़म्‍बिरिॽ, खे़न् पाङ्‌भेॽओलाम् मे़म्‍बेःक्‍के थारिक् बा खे़न् हिम्‍मोए वये़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","हे़क्‍क्‍याङ् आत्तिन् लाजेॽओ खिनिॽ लाम् के़मे़न्‍दाःक्‍तिन् हे़क्‍क्‍याङ् खिनिॽ पाःन्‍नाङ् मे़ङ्‌घे़प्‍सुन्, खे़न् लाजेॽइन्‌के़ले़रुम्‍माङ्‌के़बिगिल्‍ले़ खिनिॽ लाङ्‌ङो के़घिप्‍पा खाम् हिःक्‍किन् थाप्‍से़म् थाॽरे़म्‍सिम्‍मे़ॽ कङ्‌ग खुनिॽ तक्‍ले़ङ्‌वाओ के़बोःङ्‌बा मिक्‍सेःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़बेआङ् मनाहाॽओ खिनिॽ लायोलाम् हिन्‍दे़म्‍मे़ॽ फाॽआङ् इङ्‌भन् से़ःमा मे़हेःक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","खे़ङ्‌हाॽरे़ मनाहाॽलाम् फे़न्‍साम्‍हाॽ मे़लःत्तुसि॥ हे़क्‍क्‍याङ् यरिक्‌के़दुक्‍पाहाॽ निःङ्‌गेॽ मे़हुःत्तु मे़बिरुसि, हे़क्‍क्‍याङ्‌मे़वेःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","आल्‍ल ये़सुरे़ कुमिङ्‌सो-कुधाःङ्‌सो के़रे़क् पिसाङ् से़ःरे़, हे़क्‍क्‍याङ् ये़सुरे़ कुयाःम्‍बेओ हे़रोद हाङ्‌ङिल्‍ले़आङ् खे़प्‍सुरो॥ कुभारे़ मे़बाःत्तु, “बप्‍तिस्‍मा के़बिबा युहुन्‍नाःन् याम्‍मो हिङे़बाल्‍ले़ चोगुल्‍ले़ खुने़ॽ मुक्‍साम्‍लाम्‍बा निङ्‌वाॽ के़माबा याःम्‍बक् चोगुर वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","कर वेॽहाॽरे़ मे़बाःत्तु, “कङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलियाःन्‍लो॥” वेॽहाॽरे़ मे़बाःत्तु, “उन्‍छोःन्‍बा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽओ खुने़ॽआङ् थिक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","कर हे़रोद हाङ्‌ङिल्‍ले़ कन् खे़प्‍सुआङ् अक्‍खे पाःत्तु, “कङ्‌ग बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍लो॥ इङ्‌गाॽ खुने़ॽ कुनिःङ्‌मान्‌खक् पाङ्‌घुङ्‌सिङ्‌ङाङ्‌वये़, कर याम्‍मो कुसिवे़त्‍लाम् कुहिङ्‌वे़त् पोःक्‍खे़रो!” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","हे़रोद हाङ्‌ङिल्‍ले़ आबाङे कुन्‍साॽ फिलिपरे़ कुमेःत् हे़रोदियासे़न् मेःत्‌कत्तुआङ् वये़॥ हे़क्‍क्‍याङ् हे़रोदियासरे़ कुनिङ्‌वाॽ ताःमा फाॽआङ् बप्‍तिस्‍मा के़बिबा युहुन्‍नाःन् ते़म्‍माआङ् पुङ्‌लाहिम्‍मो साक्‍मा इङ्‌जाःङ् पिरुसिआङ् वये़, थेआङ्‌भे़ल्‍ले़ युहुन्‍नारे़ खुने़ॽ ए़त्‍ले़ङ् “खे़न् आबाङे के़न्‍साॽरे़ कुमेःत्तिन् मेःत् कप्‍मा मे़नुॽने़न्” मे़त्तुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","हे़रोदियासरे़ युहुन्‍नाःन्‍नु कुसिक् पोगे़आङ् खे़न् से़प्‍मा निङ्‌वाॽ चोगुआङ् वये़साङ् खुने़ॽ से़प्‍मा मे़न्‍छुक्‍के वये़, ");
INSERT INTO lifNT2_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","थेआङ्‌भे़ल्‍ले़ हे़रोद हाङ्‌ङिल्‍ले़ युहुन्‍नाःन् साम्‌योनिबा नु सेसेबा मना फाॽआङ् कुसिङ् निःत्तुआङ् वये़, खे़ल्‍ले़ चोगुल्‍ले़ खुने़ॽ ताङ्‌से़ःप्‍तुआङ् वये़रो॥ युहुन्‍नारे़ कुबाःन्‍निन् खुने़ॽ खे़प्‍सुल्‍ले़ साॽरिक् किःसे़आङ्‌वये़साङ् सःत्ते़र खे़प्‍सुरए वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","आल्‍ल यम्‍बा सुये़म् त्‍ये़॥ हे़रोद हाङ्‌ङिल्‍ले़ कुसावाःन्‍छिङ्‌मा ससःत्‍सराङ्‌ङो गालिल थुम्‍मोबा पयम्‌यम्‍बा सुहाङ्‌युक्‍पाहाॽ, तिलिङ्‌गाहाॽरे़ खुनिॽ थक्‍तुम्‍बाहाॽ नु मिङ्‌सोदाङ्‌बा तुम्‍म्‍याहाङ्‌हाॽ तरे उःत्तुसिआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","हे़रोदियासरे़ आबाङे कुस्‍साः मे़न्‍छुमाॽइन् खे़प्‍मो त्‍ये़आङ् लाःक्‍खे़, हे़क्‍क्‍याङ् हे़रोद हाङ्‌ङिन् नु खे़प्‍मो के़दाःबा के़रे़क् तरेबाहाॽरे़ खुनिॽ निङ्‌वाॽ तासु पिरुसिल्‍ले़ हाङ्‌ङिल्‍ले़ खे़न् मे़त्तु, “खे़ने़ॽ थे के़नाःक्‍कासाङ् इङ्‌गाॽ पिने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","खे़ल्‍ले़ माङ्‌हे़क्‍सिङ्‌ल मे़त्तु, “खे़ने़ॽ थे के़नाःक्‍का इङ्‌गाॽ पिने़॥ आहाङ्‌जुम्‍मिन् कुभ्रे़ःङ् के़नाःक्‍तुसाङ् पिने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","खे़न् चुक्‍मे़न् कुम्‍मारो पेआङ् सेःन्‍दोसु, “आल्‍ल थे नाःक्‍तुङ्‌बाबे?” हे़क्‍केःल्‍ले़ कुम्‍मारे़ मे़त्तु, “बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ कुधे़गेःक्‍किन्‌नाःक्‍ते़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","खिमो खे़न् चुक्‍मे़न्‍नाङ् पेआङ् मे़त्तु, “बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ कुधे़गेःक्‍किन्‌आल्‍लोसा चे़त्‍थ्‍याओ पिराङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","हे़क्‍केःल्‍ले़ हे़रोद हाङ्‌ङिन् साॽरिक् कुनिङ्‌वाॽ तुगे़साङ् खे़प्‍मो के़वाॽबा तरेबाहाॽरे़ खुनिॽ तगि खुने़ॽ चोगुबा माङ्‌हे़क्‍किन्‌के़प्‍माए के़लॽबा निङ्‌वाॽ चोगुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","खे़प्‍मो के़ये़प्‍पा हाङ्‌तिलिङ्‌गाःन् पेगे़ॽआङ् युहुन्‍नारे़ कुधे़गेःक्‍किन्‌फे़त्ते़ॽ फाॽआङ् इङ्‌जाःङ् पिरु॥ खे़न् खिमो पुङ्‌लाहिम्‍मो पेआङ् युहुन्‍नारे़ कुधे़गेःक्‍किन्‌खक्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","हे़क्‍क्‍याङ् चे़त्‍थ्‍याओ फे़त्तुआङ् खे़न् चुक्‍मे़न् पिरु॥ चुक्‍मे़ल्‍ले़ खे़न् तेॽरुआङ् कुम्‍मा पिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","युहुन्‍नाःल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ कन् मे़घे़प्‍सुआङ् मे़द्‌ये़, हे़क्‍क्‍याङ् कुधक्‍किन् मे़देॽरुआङ् इप्‍पुङ्‌ङो मे़लुप्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","तगि ये़सुरे़ इङ्‌भन् चोःक्‍से़ पाङ्‌घुसिबा सेःक्‌युक्‍मिबाहाॽरे़ मे़जोगुबा याःम्‍बक् नु मे़हुॽरुसिबा पाःन्‍हाॽ मे़नुःक्‍खे़ मे़द्‌ये़आङ् ये़सुःन् मे़जे़क्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","हे़क्‍क्‍याङ् ये़सुरे़ आल्‍ल एःक्‍सादे़न्‍नो पिगिआङ् सप्‍फासिक् नाःम्‍मासि फाॽआङ् खे़ङ्‌हाॽ मे़त्तुसि, थेआङ्‌भे़ल्‍ले़ के़दाःबा के़बेःक्‍पा मनाहाॽरे़ मे़जोगुल्‍ले़ खुनिॽ चामा ये़म्‍माङ् मे़ङ्‌घोए मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","हे़क्‍केःल्‍ले़ ये़सुःन् नु कुहुॽसाम्‍बाहाॽ खःङ्‌बेओ स्‍वाःत्ताङ् मे़लाःसे़आङ् एःक्‍सादे़न्‍नो मे़बे॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","कर यरिक् मनाहाॽरे़ खे़ङ्‌हाॽ मे़बेर मे़बत्‍छे़बा मे़निःसुसिआङ् कुसिङ् मे़निःत्तुसि, हे़क्‍क्‍याङ् के़रे़क् पाङ्‌जुम्‍मोलाम् मे़लोःक्‍ते़र मे़बे, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़बेबा ते़न्‍नो खे़ङ्‌हाॽनुःल्‍ले़ तगि खे़प्‍मो मे़गे़रे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","हे़क्‍क्‍याङ् ये़सुःन् खःङ्‌बेओलाम् लःन्‍दे़ल्‍ले़ यरिक् मनाहाॽ निःसुसिआङ् कुलुङ्‌माॽ मे़दुगे़, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ मे़ल्‍लुक्‍कम्‍बा मे़ःन्‍नेबा मे़ल्‍लुक्‍हाॽ हे़क्‍के मे़लॽरे़॥ हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ यरिक् निसाम् हुॽरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","नाम्‍ध्‍ये़र पत्‍छे़ल्‍ले़ कुहुॽसाम्‍बाहाॽ खे़प्‍मो मे़द्‌ये़आङ् ये़सुःन् मे़मे़त्तु, “आदाङ्‌बे, कङ्‌हाॽ पाङ्‌घे़देःसे़से़ॽओ, थेआङ्‌भे़ल्‍ले़ कन् एःक्‍सादे़न्‍नो थेआङ् इङ्‌मा चामा खोःमे़दे़त्‍ने़न्‍लो, याम्‍मो नाम्‍माङ् थ्‍ये़बेरो॥ हाराॽ खिरिबा हिम्‍हाॽ नु पाङ्‌भेॽहाॽओ मे़बेःक्‍काङ् चामा थुङ्‌मा मे़इङु मे़जररो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽए कङ्‌हाॽ कुजा पिरे़म्‍सिम्‍मे़ॽओ” खे़ङ्‌हाॽरे़ ये़सुःन् याम्‍मो मे़मे़त्तु, “आदाङ्‌बे, किप्‌ने़त्‍छि (२००) याङ्‌ङिल्‍ले़ इङ्‌मनाबा खरे़ःङ्‌ङिल्‍ले़आङ् कङ्‌हाॽ मे़योरुन्‍छिन्‍लो॥ आक्‍खेलॽरिक् पिमा सुक्‍मे़दे़प्‍पे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ आक्‍खे़म्‍म्‍याक् खरे़ःङ् के़गत्तुम्, पेगे़म्‍मे़ॽआङ् ओमे़त्ते़म्‍मे़ॽ!” हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ओमे़मे़त्तु, हे़क्‍क्‍याङ् मे़भे़रे़आङ् मे़मे़त्तु, “आदाङ्‌बे, आनिगे़ग ङासि (५) खरे़ःङ् नु ने़त्‍छि (२) ङारक् कत्तुम्‍बे़॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","खे़न् मनाहाॽ याःन् के़युङ्‌बा खाम्‍मो थे़ःक्‍पे़त्ताङ्‌युङ्‌मा पाङ्‌घे़म्‍सिम्‍मे़ॽ फाॽआङ् ये़सुरे़ इङ्‌जाःङ् पिरुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽ किप्‌थिक् (१००) नु ङाबोःङ्‌(५०) लॽरिक् मे़हासिङ्‌ङाङ् थे़ःक्‍पे़त्‌मे़बे़न्‍छिङ्‌ङाङ्‌मे़युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ये़सुरे़ खे़न् ङासि (५) खरे़ःङ् नु ने़त्‍छि (२) ङाहाॽ याङ्‌सिङ्‌ङाङ् साङ्‌ग्राम्‍पेदाङ् ले़प्‍माङ् ओमे़त्तुर निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरुर खरे़ःङ्‌हाॽ खे़ःक्‍खु॥ हे़क्‍क्‍याङ् खे़न् मनाहाॽ मे़हाःत्तुसिर फाॽआङ् कुहुॽसाम्‍बाहाॽ पिरुसि॥ खे़न् ने़त्‍छि ङाहाॽआङ् खे़ःक्‍खुआङ् मनाहाॽ मे़हाःत्तुसिर फाॽआङ् कुहुॽसाम्‍बाहाॽ पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","खे़ङ्‌हाॽरे़ खाघा मे़जरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽरे़ खे़न् खरे़ःङ् नु ङाहाॽरे़ कुजि के़नम्‍बाहाॽ मे़सुप्‍सुल्‍ले़ थिक्-ने़त् (१२) नइमा योरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","खे़न् खरे़ःङ् के़जाबाहाॽ हे़न्‍छिङ् ङासि (५०००) ये़म्‍बित्‍छाॽहाॽरक् मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ये़सुरे़ मनाहाॽ पाङ्‌घुसिनामे़ःन्‍ने खःङ्‌बेओ लाःसे़म्‍मे़ॽआङ् वरक्‍किल्‍ले़ नाहाङ्‌दाङ् बे़थसेदाओ इङ्‌गाॽनुःल्‍ले़ तगि पेगे़म्‍मे़ॽ फाॽआङ् कुहुॽसाम्‍बाहाॽ मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","हे़क्‍क्‍याङ् खे़प्‍मोलाम् तुवा चोःक्‍से़ थो कोःक्‍माओ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","आल्‍ल खादामे़ल्‍ले़ खःङ्‌बेन् वरक्‍किल्‍ले़ कुलुम्‍मो वये़, हे़क्‍क्‍याङ् वरक्‍किल्‍ले़ कुयाओ ये़सुःङ्‌ग एःक् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","कुहुॽसाम्‍बाहाॽरे़ सुरित् केजङ्‌ङिन् खुनिॽ तक्‍ले़प्‍माङ्‌नु हुःरे़बाल्‍ले़ खःङ्‌बेन् वरक्‍को तगि तेॽमा के़साक्‍पा मे़दुमुआङ् मे़यागे़बा ये़सुरे़ निःसुसि॥ हे़क्‍केःल्‍ले़ इङ्‌वा काःमानुःल्‍ले़ तगि ये़सुःन् वरक्‍को लाङ्‌घेगे़र पेरो॥ हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ मे़यागे़बा खःङ्‌बेन् लाम्‍बाक्‍मा इःत्तुल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","खे़ङ्‌हाॽरे़ खुने़ॽ लाङ्‌घेगे़बा मे़निःसुआङ् कङ्‌ग सिसाम्‍ने फाॽआङ् साॽरिक् मे़गिसे़र मे़अःक्‍ते़॥ खिमो ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “मे़गिसे़म्‍मिन्‍ने़ॽ! इङ्‌गाॽ ये़सुआ॥ हाङ्‌हाङ् लॽरे़म्‍मे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","हे़क्‍क्‍याङ् ये़सुःन् खःङ्‌बेओ लाःसे़आङ् सुरित् केजङ्‌ङिन् हुःमा चक् लॽरे़॥ कुहुॽसाम्‍बाहाॽरे़ साॽरिक् खुनिॽ निङ्‌वाॽ मये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","खे़ङ्‌हाॽरे़ खरे़ःङ्‌ङिल्‍ले़ यरिक् मनाहाॽ ते़क्‍तुसिबा निङ्‌वाॽ के़माबा याःम्‍बक्‍किन् कुसिङ् मे़न्‍निःत्ते मे़वये़, थेआङ्‌भे़ल्‍ले़ खुनिॽ निङ्‌वाॽ के़धुङ्‌बा चोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","54","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ वरक्‍किल्‍ले़ नाधाःम्‍बि मे़गाःक्‍तुआङ् गने़सरे़त्तो मे़गे़रे़आङ् खःङ्‌बेन् इमे़घेःक्‍खु॥ ये़सुःन् खःङ्‌बेलाम् लःन्‍दे़नुमे़ःन्‍ने खे़प्‍मोबा मनाहाॽ के़रे़क्‍ले़ खुने़ॽ कुसिङ् मे़निःत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ खिरिबा ते़न्‍नो मे़लोःक्‍ते़र मे़बेआङ् के़दुक्‍पा के़यॽबाहाॽ ये़सुःन् वये़बा ते़न्‍नोए खुनिॽ ने़त्‍नाःन्‍नुए मे़दारुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","पाङ्‌भेॽ पाङ्‌जुम् ये़क्‌यक्‍को खुने़ॽ आत्तान् पेसाङ् के़दुक्‍पा के़यॽबाहाॽ कुलाम्‍मो मे़ने़स्‍सुसिरो॥ हे़क्‍क्‍याङ् ये़सुरे़ कुदेःत्तिल्‍ले़ कुसुक्‍पे़न्‍लक्‍साङ्‌सुःमा फाॽआङ् के़दुक्‍पाहाॽरे़ पेलि मे़भाक्‍तु, हे़क्‍क्‍याङ् खुने़ॽ के़सुबाहाॽ के़रे़क् मे़वेःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","थिक्‌ये़न् यरुसले़म ये़क्‌यक्‍लाम् कुभा फरिसिहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ ये़सुरो मे़द्‌ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","खे़ङ्‌हाॽरे़ ये़सुरे़ कुभा कुहुॽसाम्‍बाहाॽरे़ यहुदिहाॽरे़ खुनिॽ वाहप्‍सिङ्‌मा चोःक्‍थिम् कुइसिःक् हुक् वामे़न्‍हप्‍पे चा मे़जबा मे़निःसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(फरिसिहाॽ नु काक् यहुदिहाॽरे़ खुनिॽ पाधे़बाहाॽरे़ खुनिॽ साक्‍थिम् कुइसिःक् वामे़न्‍हप्‍सिङ्‌ङे चा मे़न्‍जने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","खे़ङ्‌हाॽरे़ पाङ्‌जुम्‍लाम् हिम्‍मो मे़दाःल्‍ले़ वाहप्‍सिङ्‌मा नु सेसेसाङ्‌साङ् चोःक्‍मा थिम् मे़न्‍जोःक्‍के मे़न्‍जने़न्॥ खे़ङ्‌हाॽरे़ फङ्‌नाहाॽ, चे़त्‍थ्‍याहाॽ, खप्‍प्‍याहाॽ वाहप्‍मा सुत्‍थो चोःक्‍मा वेॽ थिम्‍हाॽआङ् मे़गत्तुरो॥) ");
INSERT INTO lifNT2_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","हे़क्‍केःल्‍ले़ फरिसिहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ ये़सुःन् सेःन्‍मे़लाप्‍तु, “के़हुॽसाम्‍बाहाॽरे़ग सुत्‍थो चोःक्‍मा थिम् मे़न्‍जोःक्‍के चा मे़जबा आनिगे़ निःमना॥ थेआङ् के़हुॽसाम्‍बाहाॽरे़ आनिॽ पाधे़बाहाॽरे़ मे़जोगु मे़युरुबा थिम्‍मिन् मे़न्‍इःत्तुन्‌मे़न्‍नाःत्तुन्बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ निङ्‌वाॽ के़जिःप्‍पाहाॽरे़ खिनिॽ याःम्‍बेओ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुबाःन्‍निन् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ साप्‍तुबाङ्‌ग से़क्‍खाए लाॽरुरो, ‘कन् मनाहाॽरे़ग खुनिॽ मुराःल्‍ले़रक् मिङ्‌सो इङ्‌धाःङ् मे़बिआरो, कर खुनिॽ निङ्‌वाॽइन्‌इङ्‌गाॽ ले़प्‍माङ् होःप्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","कङ्‌हाॽरे़ हने़ सेवा मे़जोःक्‍का, कर मे़हुॽरुसिबा निसाम्‍मिङ्‌ग मे़न्‍छाम् याप्‍मिरे़ आप्‍फेःक् मे़जोगुबा थिम्‌रक्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","खिनिॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुइङ्‌जाःङ्‌ङिन् के़नाॽरुम्‍माङ् मे़न्‍छाम्‍गे़न् याप्‍मिहाॽरे़ खुनिॽ चोःक्‍थिम्‍मिन् के़इःत्तुम् के़नाःत्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","खिनिॽ पाधे़बाहाॽरे़ मे़जोगु मे़युरुबा थिम्‍मिन् इःप्‍मा नाःप्‍मा साॽरिक् चाःप्‍पा के़जोगिॽआङ्‌निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुइङ्‌जाःङ्‌ङिन् के़नाॽरुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","कुबिओ मोसाःल्‍ले़ पाःत्तुआङ् वाॽ, ‘के़म्‍बा के़म्‍मासि मिङ्‌सो इङ्‌धाःङ् पिरे़से़ॽ’ हे़क्‍क्‍याङ् ‘आत्तिल्‍ले़ कुम्‍बा कुम्‍मासि साङ्‌ग्रा मे़त्तुसि, खे़ङ्‌ग से़प्‍माए पोःङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","कर खिनिॽ फरिसिहाॽरे़ याप्‍मिहाॽ, ‘च्‍या इङ्‌गाॽलाम् कुभाॽ के़घोःसुम्, खे़न् निङ्‌वाॽफुमाङ्‌ङिन् कुर्बान् पिमनाबारो’ लॽरिक् खुनिॽ पा-माहाॽ हे़क्‍के मे़प्‍मासि नुःबारो फाॽआङ् के़मे़त्तुम्‍सिम्‍लो (कुर्बान् फाॽइन् निङ्‌वाॽफुमाङ्‌ङो तोःम्‍नाबा हुक्‍सोयाङ्‌लो)॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","हे़क्‍केलॽरिक् खे़न्‌कुम्‍बा कुम्‍मासि कुभाॽ पिमा खिनिॽ के़म्‍बाङ्‌घुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","अक्‍खेलॽरिक् खिनिॽ के़बोःङ्‌बा के़युःबा चोःक्‍थिम्‍हाॽ के़इःत्तुम् के़नाःत्तुम्‍माङ् निङ्‌वाॽफु पाःन्‍जाक्‍किन् के़ले़रुम् के़देःसुम्‍लो॥ बा हे़क्‍तङ्‌बा याःम्‍बक्‍हाॽरक् खिनिॽ के़जोगुम्॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ये़सुरे़ मनाहाॽ याम्‍मो उःत्तुसिआङ् मे़त्तुसि, “खिनिॽ के़रे़क्‍ले़ इङ्‌गाॽ आबाःन्‍निन् खे़प्‍से़म्‍मे़ॽआङ् कुसिङ् निःत्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","लाःक्‍कात्‍लाम् मना सिगाङ् के़लाःप्‍पा पाःन्‍निल्‍ले़ मनाःन् आसुत्‍थो मे़जोगुन्‍लो, कर निङ्‌वाॽओलाम् लाःक्‍कात् के़लःम्‍बा पाःन्‍निल्‍ले़ए मनाःन् आसुत्‍थो चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","((ने़क्‍खोॽ के़बप्‍पाहाॽरे़ नुःरिक्‍काङ् खे़प्‍से़म्‍मे़ॽओ॥”)) ");
INSERT INTO lifNT2_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","खे़न् मनाहाॽ पक्‍थसिआङ् ये़सुःन् हिम् सिगाङ् लाःसे़ हे़क्‍क्‍याङ् खे़प्‍मो कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ कन् खे़दाॽइल्‍ले़ कुबेःन् थे़माबे फाॽआङ् सेःन्‍मे़दोसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आल्‍लसाङ् खिनिॽ निङ्‌वाॽ पाःक्‍लो! मना सिगाङ् के़लाःप्‍पा चाःमनाबा कुजाःल्‍ले़ खे़न् आसुत्‍थो मे़जोगुन् के़लॽबा के़न्‍निःसुम्‍मिन्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","कङ्‌ग सिक्‍लुङ्‌माओ मे़बेःक्‍ने़न्, कर कन् साप्‍पोःक्‍को लाःत्ताङ् लाःक्‍कात् लःम्‍बेःक्‍लो॥” (अक्‍खेलॽरिक् ये़सुरे़ काक् चाःमनाबा चाहाॽ सुत्‍थो चोःक् फाॽआङ् पाःत्तुरो॥) ");
INSERT INTO lifNT2_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","हे़क्‍क्‍याङ् याम्‍मो खुने़ॽ पाःत्तु, “सिक्‍लुङ्‌मोलाम् के़लःम्‍बा पाःन्‍निल्‍ले़ खुने़ॽ आसुत्‍थो चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","थेआङ्‌भे़ल्‍ले़ मे़न्‍छाम्‍गे़न् याप्‍मि निङ्‌वाॽ सिगाङ्‌लाम् फे़न् निङ्‌वाॽ, याम्‍बोःप्‍मा, खुःम्‍मा, मना से़प्‍मा, चाराम्‍मा याःम्‍बक्, खिःम्‍मा, ताप्‍फे़ःम्‍बा निङ्‌वाॽ चोःक्‍मा, इङ्‌ले़क् चोःक्‍मा, चे़ल्‍ले़क्‍ले़क्‌लॽमा, नाहे़म्‍मा, चे़ॽया इङ्‌दो पाःप्‍मा, आङ्‌दिङ् लॽमा, अदङ् पाःन् चोःक्‍मा, हे़क्‍तङ्‌बा फे़न् पाःन्‍हाॽ लःन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","अक्‍तङ्‌बा फे़न् पाःन्‍हाॽ सिगाङ्‌लाम् लाःक्‍कात् लःन्‍नाङ् मनाःन् आसुत्‍थो चोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ये़सुःन् खे़न् ते़न्‍नोलाम् तायर नु सिदोन ये़क्‌यक् खिरिबा थुम्‍हाॽओ पेरो॥ हे़क्‍क्‍याङ् खुने़ॽ थिक् हिम्‍मो लाःसे़, थेआङ्‌भे़ल्‍ले़ खुने़ॽ खे़प्‍मो त्‍ये़बा आत्तिन्‍हाॽरे़आङ् निङ्‌वाॽ मे़ङ्‌घोःसुन्‍ल के़लॽबा इःत्तुआङ् वये़॥ कर खुने़ॽ चिङ्‌सिङ्‌मा मे़सुक्‍ते़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","कर कुस्‍साःन् फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुआङ् के़वाॽमा मे़न्‍छुमाॽइल्‍ले़ खुने़ॽ त्‍ये़बा पाःन्‍निन् खे़प्‍सुनामे़ःन्‍ने ये़सुरो त्‍ये़आङ् कुलाङ्‌जक्‍पो थुङ्‌बोहजॽ युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","खे़न् मे़न्‍छुमाःन् सिरिया लाजेॽस्‍मा सुरोफोनिसिया थुम्‍मो सागे़वाःन्‍छिङ्‌मा थिम्‍मे़न्‍दङ् सुवाङ्‌स्‍मा वये़॥ खे़ल्‍ले़ आस्‍साः चुक्‍मे़ल्‍लोलाम् फे़न्‍साम्‍हाॽ लःत्ताङ् पिराङ्‌ङे़ॽना फाॽआङ् खुने़ॽ पेलि फाक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ये़सुरे़ खे़न् मे़न्‍छुमाॽइन् मे़त्तु, “हिन्‍जाॽबित्‍छाहाॽरे़ खरे़ःङ्‌ङिन् खाघा मे़जर पोःङ्॥ हिन्‍जाॽबित्‍छाहाॽरे़ खुनिॽ खरे़ःङ्‌ङिन् नाप्‍मासिआङ्‌कोःत्‍चोहाॽ पिमासि नुःबा मे़ःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","हे़क्‍केःल्‍ले़ खे़न् मे़न्‍छुमाॽइल्‍ले़ नोगप् पिरु, “से़क्‍खाएरो आदाङ्‌बे, कर कोःत्‍चोहाॽरे़आङ् हिन्‍जाॽबित्‍छाहाॽरे़ खुनिॽ चामादे़न्‍नोलाम् मक्‍के़धाःबा कुजिहाॽ मे़जरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ये़सुरे़ खे़न् मे़न्‍छुमाॽइन् मे़त्तु, “खे़ने़ॽ नुःबा नसाःन् कुधिम्‍बा नोगप् के़बिराङ्‌बाल्‍ले़ चोगुल्‍ले़ के़हिम्‍मो पेगे़ॽ, के़स्‍साः चुक्‍मे़ल्‍लोलाम् फे़न्‍साम्‍मिन् लःन्‍दे़ पेआङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","खे़न् मे़न्‍छुमाॽइन् कुहिम्‍मो नुःक्‍खे़ पेआङ् कुस्‍साःन् नुःरिक्‍काङ् कुने़त्‍नाओ इप्‍से़आङ् ने़स्‍से़बा तुमु, थेआङ्‌भे़ल्‍ले़ फे़न्‍साम्‍हाॽरे़ खे़न् मे़ले़रु मे़धःआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ये़सुःन् तायरलाम् सिदोन पोःक्‍खे़र पेआङ् खुने़ॽ गालिल वरक् नु थिबोःङ् पाङ्‌जुम्‍मिल्‍ले़न्‌थुम्‍मो पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","खे़प्‍मो मनाहाॽरे़ नाधाक्‍पा नु कुबाःन् मे़न्‍लःम्‍मनाबा मनाधिक् मे़दारुआङ् ये़सुरे़ कुहुक्‍किन् कुसम्‍दाङ् ने़स्‍सुनि फाॽआङ् पेलि मे़भाक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","34","ये़सुरे़ खे़न् मनाहाॽलाम् माःङ्‌घा तेॽरुआङ् कुने़क्‍खोॽबो हुक्‍चोःन् केःत्तु, हे़क्‍क्‍याङ् हुक्‍को थ्‍याःत् थोःक्‍तुआङ् कुले़सोःप्‍पिन् सुःसु हे़क्‍क्‍याङ् ताङ्‌साक्‍पे़न्‌ले़प्‍माङ् ओमये़आङ् सक्‍मा सोःन्‍छिङ्‌ल “इफ्फाथा” मे़त्तुरो॥ खे़न् फाॽइन् “हन्‍छिङ्‌ङे़ॽ” पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","खिमो खे़न् मनाःन् ने़क्‍खोॽ खे़म्‍मा के़सुक्‍पा नु पाःप्‍मा के़सुक्‍पा पोःक्‍खे़आङ् नुःरिक् पाःप्‍मा हेःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मनाहाॽ कन् पाःन्‍निन् हाःत्ताङ् मे़प्‍मासि मे़ःन् फाॽआङ् इङ्‌जाःङ् पिरुसिरो॥ कर आक्‍खे़न् मे़प्‍मासि मे़ःन्‍लो मे़त्तुसिसाङ् कन् इङ्‌भन्‍निन् मे़से़ःसुर मे़देॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","खे़ङ्‌हाॽरे़ साॽरिक् खुनिॽ निङ्‌वाॽ मये़र अक्‍खे मे़बाःत्तुरो, “खुने़ॽग काक् पाःन्‍हाॽ साॽरिक् नुःबा चोगुआङ् वाॽरो! अक्‍खेलॽरिक् नाधाक्‍पाहाॽ नु पाःप्‍मा मे़न्‍छुक्‍मनाबाहाॽआङ् नुसुसिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","खे़न् ये़म्‍मो यरिक् मनाहाॽ याम्‍मो ये़सुःन् वये़बा ते़न्‍नो मे़जुप्‍से़॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽनु चामा थुङ्‌मा थेआङ् होःप्‍ते़॥ खुने़ॽ कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“कन् मनाहाॽ इङ्‌गाॽ आलुङ्‌माॽ मे़दुक्‍लो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽग सुम्‌ये़न्‍नाङ्‌धो इङ्‌गाॽनुए मे़वाॽ, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ चामा थुङ्‌मा थेआङ् मे़ङ्‌गत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","इङ्‌गाॽ खे़ङ्‌हाॽ हिम्‍मो बा अक्‍खेए पाङ्‌घुङ्‌देःसुङ्‌सिङ्‌ने़ फाॽग्र मे़बेःक्‍ल मे़बत्तिल्‍ले़सा साक्‍किल्‍ले़ साक्‍लाम्‍बत्तुसिॽ, थेआङ्‌भे़ल्‍ले़ कुभाग साॽरिक् माःङ्‌घा माःङ्‌घालाम् मे़द्‌ये़आङ् मे़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","हे़क्‍केःल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ मे़मे़त्तु, “कन् एःक्‍सादे़न्‍नो आक्‍खेलॽरिक् कम्‍म्‍याक् यरिक् मनाहाॽ खरे़ःङ्‌ङिल्‍ले़ खाःप्‍मासिबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “खिनिॽ आक्‍खे़म्‍म्‍याक् खरे़ःङ् के़गत्तुम्‍बे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “आनिगे़ग नुसि खरे़ःङ्‌लक् कत्तुम्‍बे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़न् मनाहाॽ खाम्‍बाङ्‌ङो युङे़म्‍मे़ॽ मे़त्तुसि॥ हे़क्‍क्‍याङ् खे़न् नुसि खरे़ःङ्‌ङिन् खप्‍सुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरुर खे़ःक्‍खु, हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ पिरुसिआङ् मनाहाॽ मे़हाःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","खे़ङ्‌हाॽरे़ थिक्-ने़त्‍छि चुजुक्‍सा ङाआङ् मे़गत्तु॥ खे़न्‍नाङ् ये़सुरे़ निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरुआङ् हाःत्ते़म्‍सिम्‍मे़ॽ फाॽआङ् कुहुॽसाम्‍बाहाॽ पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","हे़क्‍क्‍याङ् खे़न् मनाहाॽरे़ खाघा मे़ज॥ हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽरे़ खे़न् कुजि के़नम्‍बाहाॽ मे़सुप्‍सुल्‍ले़ नुसि नइमा योरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","खे़न् के़जाबाहाॽ हे़न्‍छिङ् लिसि (४०००) यारिक्‌मे़वये़॥ हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मनाहाॽ पाङ्‌घुदेःसुसिआङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","खुने़ॽ कुहुॽसाम्‍बाहाॽनु खःङ्‌बेओ लाःसे़आङ् नाहाङ्‌दाङ् दलमनुथा पाङ्‌जुम् खिरिबा ते़न्‍नो पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","कुभा फरिसिहाॽ खे़प्‍मो मे़जुप्‍से़आङ् ये़सुःन्‍नु पाःन्‍धक्‍मा मे़हेःक्‍ते़॥ खे़ङ्‌हाॽरे़ “साङ्‌ग्राम्‍पेदाङ्‌लाम् के़ये़बा फाॽआङ् निङ्‌वाॽ के़माबा मिक्‍सेःन्‍धिक्‌याप्‍मि ओसेःन्‍आधाक्‍ते़ॽओ” मे़मे़त्तुर ये़सुरे़ कुनिङ्‌वाॽ मे़साॽरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","हे़क्‍केःल्‍ले़ ये़सुःन् केःम्‍बा सक्‍मा सोःन्‍छिङ्‌ल पारे़, “थेआङ् कन् ये़म्‍मोबा मनाहाॽरे़ निङ्‌वाॽ के़माबा मिक्‍सेःन् ओमे़प्‍मा मे़गोःत्तुबाबे? कर इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, कन् मनाहाॽरे़ खे़न् हे़क्‍तङ्‌बा मिक्‍सेःन् ओमे़प्‍मा मे़ङ्‌घोःसुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ ले़रुसिआङ् दलमनुथालाम् कुहुॽसाम्‍बाहाॽनु याम्‍मो खःङ्‌बेओ लाःसे़आङ् नाधाःम्‍बि थासिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","कुहुॽसाम्‍बाहाॽरे़ चामा थुङ्‌मा कुजाहाॽ याङ्‌सिङ्‌मा निङ्‌वाॽ मे़भेःत्‍छुरो॥ खे़ङ्‌हाॽरे़ खरे़ःङ्‌धिक्‍लक् खःङ्‌बेओ मे़गत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ये़सुरे़ खे़ङ्‌हाॽ साम्‍दिङ् पिरुसि, “हे़रोद हाङ्‌ङिन् नु फरिसिहाॽरे़ खुनिॽ खरे़ःङ् के़भङ्‌बा सिदाॽलाम् सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","खे़ङ्‌हाॽरे़ आनिॽ खरे़ःङ्‌ङिन् आङ्‌गत्तुम्‍मिन्‍नाङ् हे़क्‍के आमे़त्ते़बारो फाॽआङ् पाःन्‍धक्‍मा मे़हेःक्‍ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ये़सुरे़ कन् पाःन्‍निन् कुसिङ् निःत्तुआङ् मे़त्तुसि, “खिनिॽ लुम्‍मो खरे़ःङ् होःप्‌फाॽआङ् थेआङ् पाःन् के़धक्‍तिबा? खिनिॽ आल्‍लसाङ् पाःन् कुसिङ् के़न्‍निःत्तिन्‍नाङ्‌खासिङ् के़न्‍निःत्तिन्‍बि? आल्‍लसाङ् खिनिॽ निङ्‌वाॽ थुङ्‌बि? ");
INSERT INTO lifNT2_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ओमे़प्‍मा मिक् के़गत्तुम्‍साङ् के़न्‍निःसुम्‍मिन्‍बि? खे़म्‍मा ने़क्‍खोॽ के़गत्तुम्‍साङ् के़ङ्‌घे़प्‍सुम्‍मिन्‍बि? खिनिॽ निङ्‌वाॽ मे़याक्‍ने़न्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","इङ्‌गाॽ ङासि खरे़ःङ्‌ङिल्‍ले़ हे़न्‍छिङ् ङासि (५०००) मनाहाॽ चाःत्तुङ्‌सिङ्‌ङिल्‍ले़ कुजि के़नम्‍बाहाॽ आक्‍खे़न् नइमा के़भुक्‍खुम्‍बे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “थिक्‌-ने़त्” (१२)॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“हे़क्‍क्‍याङ् नुसि खरे़ःङ्‌ङिल्‍ले़ हे़न्‍छिङ् लिसि (४०००) मनाहाॽ चाःत्तुङ्‌सिङ्‌ङिल्‍ले़ आक्‍खे़न् नइमा कुजि के़नम्‍बाहाॽ के़भुक्‍खुम्‍बे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “नुसि” (७)॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आल्‍लसाङ् कुसिङ् निःप्‍मा के़न्‍छुक्‍तुम्‍मिन्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ये़सुःन् नु कुहुॽसाम्‍बाहाॽ बे़थसेदाओ मे़गे़रे़॥ खे़प्‍मो मनाहाॽरे़ मिक्‍फःम्‍बाधिक् ये़सुरो मे़दारुआङ् “खे़ल्‍ले़ कुसम्‍दाङ् के़हुक्‍किन् ने़स्‍से़ॽआङ् खानिःमा के़सुक्‍पा चोगे़ॽओ” फाॽआङ् पेलि मे़भाक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मिक्‍फःम्‍बे़न् कुहुक्‍को ते़म्‍सुआङ् पाङ्‌भेॽओलाम् लाःक्‍कात् तेॽरु, हे़क्‍क्‍याङ् कुध्‍याःत्तिन् कुमिक्‍को फत्‍छुर कुहुक्‍किन् ने़स्‍सुबिरुआङ् सेःन्‍दोसु, “आल्‍लो खानिःमा के़सुक्‍तुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","हे़क्‍क्‍याङ् खे़ल्‍ले़ खिरि ओमये़र पाःत्तु, “आल्‍लो खानिःमा सुक्‍तुङ्, कर मनाहाॽग सिङ्‌बुङ् हे़क्‍केने़ निःमे़धाःप्‍पाङ्‌लाङ्‌मे़घेःक्‍पा निःसुङ्‌सिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ये़सुरे़ याम्‍मो कुमिक् सम्‍दाङ् हुक् ने़स्‍सुबिरुआङ् खे़न् अदक्‍तक्‍काङ् ओमये़, हे़क्‍क्‍याङ् नुःरिक्‍काङ् निःमा के़सुक्‍पा पोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ये़सुरे़ खे़न् मनाःन् अक्‍खे मे़त्तुर कुहिम्‍सयङ्‌ङो पाङ्‌घुदेःसु, “खे़ने़ॽ पाङ्‌भेॽओ मे़न्‍लाःत्ते के़हिम्‍मो नुःक्‍खे़ पेगे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","हे़क्‍क्‍याङ् ये़सुःन्‌नु कुहुॽसाम्‍बाहाॽ सिजरिया फिलिप्‍पि थुम्‍मोबा पाङ्‌भेॽहाॽओ मे़बे॥ मे़बेर मे़बत्‍छे़ल्‍ले़ कुहुॽसाम्‍बाहाॽ अक्‍खेलॽरिक् सेःन्‍दोसुसि, “इङ्‌गाॽ हाःत्‍आ फाॽआङ् मनाहाॽरे़ मे़बाःत्तुॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","हे़क्‍केःल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ नोगप् मे़बिरु, “कुभारे़ खे़ने़ॽ बप्‍तिस्‍मा के़बिबा युहुन्‍ना नु वेॽहाॽरे़ग एलिया फाॽआङ् मे़बाःत्तुॽ॥ कुभारे़ग वेॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽओ लत्‍छाने़रो फाॽआङ् मे़बाःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो सेःन्‍दोसुसि, “कर खिनिॽग, इङ्‌गाॽ हाःत्‍आ फाॽआङ् याप्‍मि के़मे़त्तिॽबे?” पत्रुसरे़ नोगप् पिरु, “खे़ने़ॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तने़ॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ आयाःम्‍बेओ कन् पाःन्‍निन् आत्तिन्‍हाॽआङ् मे़मे़त्ते़म्‍सिम्‍मे़न्‍ने़ॽ फाॽआङ् इङ्‌जाःङ् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","32","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ अक्‍खे पाःत्तुर हुॽमा हेःक्‍तुसि, इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़ यरिक् तुक्‍खेहाॽ तुम्‍मा पोःङ्, हे़क्‍क्‍याङ् यहुदि तुम्‍लाम्‍लोःबाहाॽरे़, तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़, हे़क्‍क्‍याङ् साम्‌योथिम्‍साम्‍बाहाॽरे़ मे़नाॽआ, हे़क्‍क्‍याङ् मे़से़त्ताआङ्‌याम्‍मो सुम् ये़न् एगाङ् सिःमे़न्‍लाम् याम्‍मो हिङ्‌ङा के़लॽबा पाःन्‍निन् कुनिङ्‌वाॽ हन्‍दुआङ् चे़क्‍तुसिरो॥ हे़क्‍केःल्‍ले़ पत्रुसरे़ खुने़ॽ थिक्‍ले़प्‍माङ् तेॽरुआङ् फे़ःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","हे़क्‍क्‍याङ् खुने़ॽ खिरि हिसिङ्‌ङाङ् कुहुॽसाम्‍बाहाॽ ओमे़त्तुसिर पत्रुसे़न् फे़ःक्‍तु, “माफे़न्‍साम्‍मे, खे़ने़ॽ इङ्‌गाॽलाम् माःङ्‌घा पेगे़ॽ॥ खे़ने़ॽग निङ्‌वाॽफुमाङ् कुइसिःक् मे़ःन्, कर मे़न्‍छाम् याप्‍मि कुइसिःक्‍लक् निङ्‌वाॽ के़इःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","हे़क्‍क्‍याङ् ये़सुरे़ यरिक् मनाहाॽ नु कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् अक्‍खे मे़त्तुसि, “आत्तिल्‍ले़ इङ्‌गाॽ तिम्‍मा निङ्‌वाॽ चोगुॽ, हाराॽ खे़ल्‍ले़ इङ्‌गाॽरक् चाङ्‌थुङ्‌ङुङ् के़लॽबा कुनिङ्‌वाॽइन्‌से़रुआङ् सिलाम्‍साक्‍मा कुसिङ्‌ङिन् पक्‍खुआङ् इङ्‌गाॽ तिम्‍माररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","थेआङ्‌भे़ल्‍ले़ आत्तिल्‍ले़ कुहिङ्‌मन्‍निन् ताङ्‌से़ःप्‍तुङ् लॽरिक् निङ्‌वाॽ चोगुॽ, खे़ल्‍ले़ खे़न्‍नाङ् मासुॽ, कर आत्तिल्‍ले़ कुहिङ्‌मन्‍निन् आलागि नु सुनाइङ्‌ङिल्‍ले़ कुलागि मासुॽ, खे़ल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","मे़न्‍छाम् याप्‍मिःल्‍ले़ काक् इक्‍सादिङ् खाम्‍बेःक्‍मान् खुने़ॽइन् चोगुसाङ् मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍निन् मासुल्‍ले़ नुःबा पोःङ्‌बि? ");
INSERT INTO lifNT2_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","मे़न्‍छाम् याप्‍मिःल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍निन् याङ्‌ना खोःमारे़ लागि थेःल्‍ले़आङ् नुःक्‍मा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","कन्‌कुॽइगे़भे़ॽबा नु लायोबा ये़म्‍मो आत्तिन् मनाःन् इङ्‌गाॽनु हे़क्‍क्‍याङ् आबाःन्‍जाक्‍किन्‍नु सिरिङ् मःॽ, इङ्‌गाॽ मे़न्‍छाम्‍साःन्‍नाङ् आम्‍बारे़ कुमिमिदिङ्‌ङो सेसे माङ्‌लाइङ्‌बाहाॽनु युःआल्‍ले़ खे़न्‍नु सिरिङ् मःआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, कप्‍मो के़ये़प्‍पा कुभा मनाहाॽ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् मुक्‍साम्‍नु युःबा मे़न्‍निए थारिक् मे़न्‍छिःने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","तुक्‍सि (६) ये़न् एगाङ् ये़सुरे़ पत्रुस, याकुब नु युहुन्‍नाःन् थो केःम्‍बा कोःक्‍माओ तेॽरुसि॥ खे़प्‍मो हाःत्ताङ् मे़होःप्‍ते़॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ओमे़मे़त्तुर मे़बत्‍छे़ल्‍ले़ए ये़सुरे़ कुनाइबेःक्‌ले़ङ्‌सिङ्‌ल पेआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","कुदेःत्‍हाॽ मिक्‍किन् चे़मुर थारिक् फुत्‍त्रिःङ्‌ग्‍याःप्‍पा पोःक्‍खे़, खे़म्‍म्‍याक् साॽरिक् फः लॽर थारिक् इक्‍सादिङ् खाम्‍बेःक्‍मो हाःत्‍ले़आङ् चाङ्‌ङिन् वाहप्‍मा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","हे़क्‍क्‍याङ् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलियाःन् नु मोसाःन् थाःम्‍ने़त्‍छिआङ् ये़सुःन्‍नु ताॽजे़क्‍खे़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","पत्रुसरे़ ये़सुःन् मे़त्तु, “सिक्‍साम्‍बे, आनिॽग कप्‍मोए आवाॽइल्‍ले़ नुःबा पोःङ्‌लो॥ आनिगे़ कप्‍मो सुम्‍सि याक्‍साहाॽ चोगुम्‍बे़बि? थिक् खे़ने़ॽइन् हे़क्‍क्‍याङ् मोसाःन् नु एलियारे़ खुन्‍छिॽ लागिआङ् थिक् थिक् चोगुम्‍बे़रो!” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","पत्रुसरे़ थे पाःप्‍माबे फाॽआङ् कुनिङ्‌वाॽइल्‍ले़ थेआङ् मे़धाप्‍तुन्, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ साॽरिक् मे़गिसे़आङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","हे़क्‍क्‍याङ् खाप्‍मिःत्तिल्‍ले़ चिदे़प् ते़प्‍तुसिआङ् खाप्‍मिःत्तोलाम् अक्‍तङ्‌बा इक्‍ला मे़घे़प्‍सु, “कन् आमिःम् आस्‍साःरो॥ खुने़ॽ पाःत्तुबा पाःन्‍निन् खे़प्‍से़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","खे़ङ्‌हाॽ खिरि ओमे़मःये़ल्‍ले़ ये़सुःन्‍लक् वये़, वेॽ हाःत्ताङ् मे़होःप्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","खे़ङ्‌हाॽ कोःक्‍मालाम् यो मे़ध्‍ये़र मे़बत्‍छे़ल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ कन् के़निःसुम्‍बा पाःन्‍निन् इङ्‌गाॽ मे़न्‍छाम्‍साःन् सिःमे़न्‍लाम् याम्‍मो मे़न्‍हिङ्‌ङे थारिक् हाःत्ताङ् मे़जे़क्‍ते़म्‍मे़न्‍ने़ॽ फाॽआङ् इङ्‌जाःङ् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","खे़ङ्‌हाॽरे़आङ् कन् पाःन्‍निन् खुनिॽ लुम्‍मोए मे़युक्‍खु॥ खे़ङ्‌हाॽ कन् सिःमे़न्‍लाम् हिङ्‌मा फाॽइन् थे़माने़बे फाॽआङ् पाःन् मे़धक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुने़ॽ सेःन्‍मे़दोसु, “थेआङ् साम्‌योथिम्‍साम्‍बाहाॽरे़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌ताःमानुःल्‍ले़ तगि एलियाःङ्‌ग युःमाए पोःङ् फाॽआङ् मे़बाःत्तुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","हे़क्‍केःल्‍ले़ ये़सुरे़ अक्‍खे मे़त्तुसि, “से़क्‍खाएरो, एलियाःङ्‌ग युःॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरे़ कुदाःमान् के़रे़क् यारिप् चोगुॽरो॥ आक्‍खेलॽरिक् मे़न्‍छाम्‍साःन् तुक्‍खे चामाए पोःङ्, हे़क्‍क्‍याङ् खुने़ॽ मनाहाॽरे़ मे़नाॽरु के़लॽबा साप्‍ते़आङ् मे़बत्‍ने़न्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","कर एलियाःन् त्‍ये़ चुरे़आङ् वाॽ, हे़क्‍क्‍याङ् कुयाःम्‍बेओ साप्‍ते़आङ् पप्‍पा हे़क्‍के खे़ङ्‌हाॽरे़ खुने़ॽ निङ्‌वाॽ थाप्‍थाप् मे़मे़त्तुआङ् मे़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ वेॽ हुॽसाम्‍बाहाॽ मे़वये़बा ते़न्‍नो मे़गे़रे़ल्‍ले़ खे़प्‍मो यरिक् मनाहाॽ मे़जुप्‍से़आङ् मे़वये़॥ खे़प्‍मो कुहुॽसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ पाःन्‍धक्‍नु मे़यागे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ये़सुःन् ये़बा मे़निःसुआङ् खे़प्‍मो के़वाॽबा के़रे़क् मनाहाॽ साॽरिक् हाःप्‍मे़ले़क्‍ते़आङ् मे़लोःक्‍ते़र ये़सुःन् सेवा मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ये़सुरे़ कुहुॽसाम्‍बाहाॽ सेःन्‍दोसुसि, “खे़ङ्‌हाॽनु थे़मा पाःन् के़धक्‍तिबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","हे़क्‍क्‍याङ् खे़न् मनाहाॽओ थिक्‍ले़ पाःत्तु, “सिक्‍साम्‍बे, आस्‍साःन् कप्‍मो तारुङ्‌ङाङ् वाॽआ, थेआङ्‌भे़ल्‍ले़ फे़न्‍साम्‍मिल्‍ले़ तरुआङ् कुबाःन्‍नाङ् मये़बेआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","फे़न्‍साम्‍मिल्‍ले़ फत्तुल्‍ले़ खे़न् खाम्‍मो थाम्‍सिङ्‌ङाङ् कुध्‍याःत्तिन् फुजुःक्-फुजुःक् लःन्‍नाङ् कुहाबोॽबान् इसिक्‍खुॽ, हे़क्‍क्‍याङ् खाक्‍तुॽरो॥ के़हुॽसाम्‍बाहाॽ ‘खे़न् फे़न्‍साम्‍मिन् आस्‍साःल्‍लोलाम् नाःत्ते़म् आबिरे़म्‍मे़ॽ’ मे़त्तुङ्‌सिङ्, कर मे़न्‍छुक्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “नसाःन् के़होःप्‍पासे, आप्‍फाल्‍ले़ थारिक् इङ्‌गाॽ खिनिॽनु वाॽआर नासि थःत्‍निङ्‌बाबे? खे़न् चुक्‍पे़न् कत्‍ना फे़त्ते़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","खे़न् चुक्‍पे़न् ये़सुरो मे़दारु, हे़क्‍क्‍याङ् फे़न्‍साम्‍मिल्‍ले़ ये़सुःन् निःसुआङ् खे़न् चुक्‍पे़न् खाम्‍मो पिर्धाप् थाप्‍सु, हे़क्‍क्‍याङ् खे़न् चुक्‍पे़न् कुध्‍याःत्तिन् फुजुःक्-फुजुःक् लःन्‍दे़र होःत्‍छिङ्‌मा हेःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ये़सुरे़ खे़न् चुक्‍पे़ल्‍ले़ कुम्‍बाःन् सेःन्‍दोसु, “कन् चुक्‍पे़न् आप्‍फाल्‍ले़आङ्धो अक्‍खे पोःक्‍खे़बाबे?” खे़ल्‍ले़ नोगप् पिरु, “कन् अङे़ःक्‌वा वये़आङ्धोए अक्‍खे पोःक्‍खे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","कन् फे़न्‍साम्‍मिल्‍ले़ यरिक् ले़ङ् से़प्‍मा कोःत्तुल्‍ले़ चुक्‍पे़न् मिओ नु च्‍वाःत्तो से़प्‍मा फाॽआङ् लाप्‍फुसु याक्‍तुरो॥ आदाङ्‌बे, लुङ्‌माॽ आदुक्‍ते़ॽओ, के़सुक्‍तुने़ फाॽग्र आभाॽरे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ये़सुरे़ खे़न् मे़त्तु, “‘के़सुक्‍तुने़ फाॽग्र’ फाॽआङ् थेआङ् के़बाःत्तुबाबे? नसाःन् के़जोःक्‍पाल्‍ले़ कुलागिग थेसाङ् पोःङ्‌मा सुक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","हे़क्‍केःल्‍ले़ खे़न् चुक्‍पे़ल्‍ले़ कुम्‍बारे़ खिमो यम्‍बा इक्‍लाओ मे़त्तु, “आदाङ्‌बे, इङ्‌गाॽ नसाःन् चोगुङ्, कर आल्‍लसाङ् यरिक् नसाःन् चोःक्‍मा फाॽराङ्‌ङे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","हे़क्‍क्‍याङ् ये़सुरे़ यरिक् मनाहाॽ खे़प्‍मो मे़लोःक्‍ते़र मे़भे़रे़बा निःसुसिआङ् खे़न् फे़न्‍साम्‍मिन् फे़ःक्‍तु, “नाधाक्‍पा नु कुबाःन् मे़न्‍लःम्‍नाबा फे़न्‍साम्‍मे, खे़न् चुक्‍पे़ल्‍लोलाम्‌लःन्‍दे़ पेगे़ॽआङ् आप्‍फाल्‍ले़आङ् याम्‍मो मे़लाःसे़न्‍ने़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","खे़न् फे़न्‍साम्‍मिन् फिःक्‍ते़र खे़न् साॽरिक् थाप्‍सुधआङ् लःन्‍दे़ पेरो॥ खे़न् चुक्‍पे़न् खाक्‍तुआङ् के़सिःबा कुइसिःक् पोःक्‍खे़आङ् ने़स्‍से़॥ हे़क्‍केःल्‍ले़ कुभारे़ग खे़ङ्‌ग स्‍ये़ फाॽआङ् मे़बाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","कर ये़सुरे़ खे़ल्‍ले़ कुहुक्‍कोलाम् ते़म्‍सुर फोःक्‍खुआङ् ये़प्‍सु, हे़क्‍क्‍याङ् खे़न् ये़म्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ये़सुःन् हिम्‍मो लाःसे़आङ् कुहुॽसाम्‍बाहाॽरे़ स्‍वाःत्ताङ् सेःन्‍मे़दोसु, “थेआङ्‌आनिगे़ खे़न् फे़न्‍साम्‍मिन् नाःप्‍मा लःप्‍मा मे़सुक्‍तुम्‍बे़न्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ये़सुरे़ नोगप् पिरुसि, “अक्‍तङ्‌बाङ्‌ग तुवाःल्‍ले़रक् नाःप्‍मा लःप्‍मा सुक्‍ते़त्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","हे़क्‍क्‍याङ् ये़सुःन् नु कुहुॽसाम्‍बाहाॽरे़ खे़न् ते़न्‍निन् पक्‍मे़धःआङ् गालिल मे़लस्‍सुर मे़बे॥ खुनिॽ आत्तो मे़वाॽ फाॽआङ् वेॽहाॽरे़ निङ्‌वाॽ मे़ङ्‌घोःसुन्‍ल के़लॽबा ये़सुरे़ निङ्‌वाॽ इःत्तुआङ् वये़रो, ");
INSERT INTO lifNT2_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","थेआङ्‌भे़ल्‍ले़ खुने़ॽ कुहुॽसाम्‍बाहाॽ हुॽरुसिर वये़॥ खे़ङ्‌हाॽ अक्‍खे मे़त्तुसि, “आल्‍ल मे़न्‍छाम्‍साःन् इङ्‌मे़ले़क्‍त्तुॽ हे़क्‍क्‍याङ् मनाहाॽरो हुक् मे़सुप्‍तु मे़बिरुॽआङ् खे़ङ्‌हाॽरे़ खुने़ॽ मे़से़रुॽ, कर सुम्‌ये़न् एगाङ् सिःमे़न्‍लाम् याम्‍मो कुहिङ्‌वे़त् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","कर कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ पाःत्तुबा पाःन्‍निन् कुसिङ् मे़न्‍निःत्तुन्, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ याम्‍मो सेःन्‍दोःमाआङ् मे़गिसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","खे़ङ्‌हाॽ कपर्नहुम्‍मो मे़द्‌ये़आङ् खे़प्‍मोबा हिम्‍मो मे़वये़ल्‍ले़ ये़सुरे़ कुहुॽसाम्‍बाहाॽ सेःन्‍दोसुसि, “आन्‍दे़ःन् लाम्‍मो खिनिॽ थे़माःन्‌पाःन् के़धक्‍तिर के़वयिबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","कर खे़ङ्‌हाॽ मे़म्‍बारे़न्, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ आनिॽओ के़रे़क्‍नुःल्‍ले़ यम्‍बान्‌हाःप्‍पे फाॽआङ् पाःन्मे़धक्‍ते़आङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ये़सुःन् युङ्‌सिङ्‌ङाङ् थिक्-ने़त् (१२) कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् मे़त्तुसि, “हाःत्‍ले़ तगि पोःङ्‌मा निङ्‌वाॽ चोगुॽ, खे़न् के़रे़क्‍नुःल्‍ले़ एगाङ् पोःङ्‌माआङ् के़रे़क्‍ले़ खुनिॽ सेवारोबा पोःङ्‌मा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","हे़क्‍क्‍याङ् ये़सुरे़ खे़प्‍मो हिन्‍जाॽधिक् खुनिॽ लुम्‍मो ये़प्‍सु, हे़क्‍क्‍याङ् कुभक्‍तुङ्‌ङो युक्‍खुर मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“आत्तिल्‍ले़ आमिङ्‌ङो अक्‍तङ्‌बा चुक्‍सा हिन्‍जाॽइन् लाङ्‌दाःक्‍तुॽ, खे़ल्‍ले़ इङ्‌गाॽ लाङ्‌दाःक्‍कारो॥ इङ्‌गाॽ याप्‍मि लाङ्‌गे़दाःक्‍पाल्‍ले़ इङ्‌गाॽ याप्‍मि के़बाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन्‍नाङ् लाङ्‌दाःक्‍तुॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","कुहुॽसाम्‍बाहाॽओ थिक्‍पा युहुन्‍ना मे़प्‍मनाबाल्‍ले़ खुने़ॽ मे़त्तु, “सिक्‍साम्‍बे, आनिगे़ लत्‍छा मनाधिक्‍ले़ के़मिङ्‌ङो फे़न्‍साम्‍हाॽ नाःत्तुसिर पत्‍छे़बा निःसुम्‍बे़॥ हे़क्‍क्‍याङ् आनिगे़ खे़न् ‘हे़क्‍के मे़जोगे़न्‍ने़ॽ’ मे़त्तुम्‍बे़, थेआङ्‌भे़ल्‍ले़ खे़न् आनिॽनु सोरिक् लाङ्‌मे़घेःक्‍ने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खे़न् हे़क्‍के चोःक्‍मा मे़साक्‍ते़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ हाःत्‍ले़ इङ्‌गाॽ आमिङ्‌ङो निङ्‌वाॽ के़माबा याःम्‍बक् चोगुॽ, खे़न् आदक्‍ले़ङ्‌वाओ हारा मे़बोःक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","आत्तिन् आनिॽ तक्‍ले़ङ्‌वाओ होःप्‌, खे़न् आनिॽ ले़प्‍माङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आत्तिल्‍ले़ खिनिॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरे़ कुमना फाॽआङ् फङ्‌नाधिक् च्‍वाःत् के़बिरिॽ, खे़ल्‍ले़ से़क्‍खासाङ् थुम्‍घोःन् खोःसुॽएरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“हे़क्‍क्‍याङ् आत्तिल्‍ले़ इङ्‌गाॽ याप्‍मि नसाःन् के़जोःक्‍पा चुक्‍सा हिन्‍जाॽधिक् लायो चोःक्‍मा पाङ्‌घुॽ, खे़ल्‍ले़ कुनिःङ्‌मो लुम्‍सुम्‍मिन् फोःम्‍माआङ् वरक्‍को लाप्‍फुमाल्‍ले़ए नुःबा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","खे़ने़ॽ के़हुक्‍किल्‍ले़ लायो चोःक्‍मा के़बाङ्‌ने़ फाॽग्र खक्‍ते़देःसे़ॽओ॥ ने़त्‍छि हुक्‍नु आप्‍फाल्‍ले़आङ् मे़न्‍छिःमना मि के़दिःप्‍पा खे़मायङ्‌सङ्‌ङो पेःक्‍मानुःल्‍ले़ग हुक्‍थिक् मे़ःन्‍ने मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःमाए नुःबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","((खे़मायङ्‌सङ्‌ङोग फेॽबाःत् नु मिःन्‌मे़सिःने़न्‍लो॥)) ");
INSERT INTO lifNT2_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","के़लाङ्‌ङिल्‍ले़ लायो चोःक्‍मा के़बाङ्‌ने़ फाॽग्र खक्‍ते़देःसे़ॽ॥ ने़त्‍छि लाङ्‌नु खे़मायङ्‌सङ्‌ङो पेःक्‍मानुःल्‍ले़ग लाङ्धिक्‌मे़ःन्‍ने मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःमाए नुःबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","((खे़मायङ्‌सङ्‌ङोग फेॽबाःत् नु मिःन्‌मे़सिःने़न्‍लो॥)) ");
INSERT INTO lifNT2_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","के़मिक्‍किल्‍ले़ लायो चोःक्‍मा के़बाङ्‌ने़ फाॽग्र यगे़लःत्ते़ॽ॥ ने़त्‍छि मिक्‍किन्‍नु खे़मायङ्‌सङ्‌ङो पेःक्‍मानुःल्‍ले़ग मिक्‍थिक्‍नु निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःप्‍मा नुःबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","खे़मायङ्‌सङ्‌ङोग फेॽबाःत् नु मिःन्‌मे़सिःने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","युम्‍मिल्‍ले़ सिदुङ्‌जभाःन् सुत्‍थो चोगुबा हे़क्‍केए मिःल्‍ले़ के़रे़क् मनाहाॽ सुत्‍थो चोगुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","युम्‍मिन् नुःबा चोःक्, कर युम्‍मिल्‍ले़ कुलिम्‍मे़न् माःने़ फाॽग्र आक्‍खेआङ् खे़न् के़लिम्‍बा के़जोगुम्‍बे? खिनिॽ हिङ्‌मन्‍नो युम्‍मिन् कत्ते़म्‍मे़ॽआङ् के़रे़क्‍नु सनारुङ्‌ङो वये़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ये़सुरे़ खे़न् ते़न्‍निन् ले़रुआङ् यर्दन यङ्‌घङ्‌ङिल्‍ले़ नाधाःम्‍बिबा यहुदिया थुम्‍मो पे॥ खे़प्‍मोआङ् यरिक् मनाहाॽरे़ खुने़ॽ मे़दिम्‍दु॥ हे़क्‍क्‍याङ् ये़सुरे़ कुये़प्‍ले़क् कुइसिःक् खे़न् मनाहाॽ हुॽमा हेःक्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","खे़प्‍मो कुभा फरिसिहाॽ मे़द्‌ये़आङ् खुने़ॽ कुनिङ्‌वाॽ साॽमा फाॽआङ् पाःन् मे़गे़सु, “आदाङ्‌बा सिक्‍साम्‍बे, ये़म्‍बित्‍छाॽइल्‍ले़ कुमेःत्तिन् नाॽमा साम्‌योथिम्‍मिल्‍ले़ पिरुबि मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ये़सुरे़ खे़ङ्‌हाॽ याङ्‌ना सेःन्‍दोसुसि, “मोसारे़ खिनिॽ आक्‍तङ्‌बा इङ्‌जाःङ् के़बिरिआङ् के़वयिॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “मोसाःल्‍ले़ ये़म्‍बित्‍छाॽइल्‍ले़ कुमेःत्तिन् इङ्‌गाॽ नाॽने़बारो फाॽआङ् साप्‍ला साप्‍तुआङ् पाङ्‌मादेःमा सुक्‍तुॽ लॽरिक् साप्‍तुआङ् पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खे़ङ्‌ग खिनिॽ पाःन् मे़ङ्‌घे़म्‍मनाबा के़जोगिबाल्‍ले़ चोगुल्‍ले़ हे़क्‍केलॽरिक् मोसारे़ खे़न् साम्‌योथिम्‍मिन् के़साप्‍ति के़बिरिबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","कर कुहेःक्‍सिङ्‌मोए निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ नावागे़न् चइःत् ने़स्‍सुल्‍ले़ ‘ये़म्‍बित्‍छाॽ नु मे़न्‍छुमाॽ चोगुसिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","‘खे़ल्‍ले़ चोगुल्‍ले़ ये़म्‍बित्‍छाॽइल्‍ले़ कुम्‍बा नु कुम्‍मासि ले़रुसिआङ् कुमेःत्तिन्‍नु तङ्‌लो, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ लत्‍छा थक् पोःङ्‌सिरो॥ आल्‍ल खे़ङ्‌हाॽग ने़प्‍फुसि मे़ःन्, कर लत्‍छा थक्‍सिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","खे़ल्‍ले़ चोगुल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ लत्‍छा थक् चोगुसिबाहाॽ मे़न्‍छाम् याप्‍मिरे़ से़म्‍मासि मे़नुॽने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","हे़क्‍क्‍याङ् याङ्‌सि खे़ङ्‌हाॽ हिम्‍मो मे़वये़ल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ ये़सुःन् कन् पाःन्‍निल्‍ले़ कुबेःन् थे़माबे फाॽआङ् याम्‍मो सेःन्‍मे़दोसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आत्तिन् ये़म्‍बित्‍छाॽइल्‍ले़ कुमेःत्तिन् नाॽरुआङ् वेॽस्‍मा मे़न्‍छुमाॽइन्‍नु मेःक्‍खिम् चोगुॽ, खे़ल्‍ले़ तगिस्‍मा कुमेःत्तिल्‍ले़ कुदक्‍ले़ङ्‌वाओ वेॽ मे़न्‍छुमाॽइन्‍नु चाराम्‍मा याःम्‍बक् चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","हे़क्‍क्‍याङ् आत्तिन् मे़न्‍छुमाॽइल्‍ले़ कुये़म्‍बाॽइन्‌नाॽरुआङ् वेॽ ये़म्‍बित्‍छाॽइन्‍नु मेःक्‍खिम् चोगुॽ, खे़ल्‍ले़आङ् तगिस्‍मा कुये़म्‍बाःल्‍ले़ कुदक्‍ले़ङ्‌वाओ वेॽ ये़म्‍बित्‍छाॽइन्‍नु चाराम्‍मा याःम्‍बक् चोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","हे़क्‍क्‍याङ् ये़सुरे़ हुक् ने़स्‍सुआङ् मुॽइसाम् पिरुसिर फाॽआङ् मनाहाॽरे़ हिन्‍जाॽबित्‍छाहाॽ मे़दारुसि॥ कर कुहुॽसाम्‍बाहाॽरे़ खे़न् के़दाःप्‍पाहाॽ मे़भे़ःक्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् निःसुआङ् कुयाःक् ले़ॽरे़र खे़ङ्‌हाॽ मे़त्तुसि, “हाराॽ हिन्‍जाॽबित्‍छाहाॽ इङ्‌गाॽओ ताःमा फाःक्‍ते़म्‍सिम्‍मे़ॽओ, खे़ङ्‌हाॽ मे़साक्‍ते़म्‍सिम्‍मिन्‍ने़ॽ, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍मिङ्‌ग कन् हिन्‍जाॽबित्‍छा हे़क्‍तङ्‌बाहाॽरे़न्‍नेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, हाःत्‍ले़ हिन्‍जाॽ हे़क्‍के कुदोःप्‍मा निङ्‌वाॽइल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् मे़दाःक्‍तुन्, खे़न् खे़प्‍मो लाःप्‍मा मे़घोःने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् हिन्‍जाॽबित्‍छाहाॽ कुभक्‍तुङ्‌ङो युक्‍खुसिआङ्‌खुनिॽ सम्‍दाङ् हुक् ने़स्‍सुर मुॽइसाम् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","हे़क्‍क्‍याङ् ये़सुःन् लाम्‍दिःक्‍को पेर पत्‍छे़ल्‍ले़ मनाधिक् लोःक्‍ते़ फे़रे़आङ् कुदगि थुङ्‌बोहजॽ युङ्‌सिङ्‌ङाङ् मे़त्तु, “के़नुॽबा सिक्‍साम्‍बाए, आक्‍तङ्‌बा नुःबा याःम्‍बक् चोगुङ्‌ङिल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुङ्‌बे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़न् मे़त्तु, “थेआङ् इङ्‌गाॽ के़नुॽबा के़मे़त्ताबे? के़नुॽबाग निङ्‌वाॽफुमाङ्‌ङिन्‍लक् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","खे़ने़ॽ साम्‌योथिम् इङ्‌जाःङ्‌हाॽ के़ले़स्‍सुॽ–मना से़प्‍मा मे़नुॽने़न्, चाराम्‍मा याःम्‍बक् चोःक्‍मा मे़नुॽने़न्, खुःम्‍मा मे़नुॽने़न्, इङ्‌ले़क् पाःप्‍मा मे़नुॽने़न्, मनाहाॽ खुम्‍मासि मे़नुॽने़न्, हे़क्‍क्‍याङ् पा-मा इङ्‌धाःङ् पिमासिए पोःङ्॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","खे़न् मनाःल्‍ले़ मे़त्तु, “सिक्‍साम्‍बे, कन् के़रे़क् साम्‌योथिम् इङ्‌जाःङ्‌हाॽग इङ्‌गाॽ हिन्‍जाॽ वयाङ्‌ङाङ्धोए इःत्तुङ् नाःत्तुङ्ल वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ये़सुरे़ खे़न् मनाःन् ओमे़त्तुआङ् लुङ्‌माॽ तुक्‍तुर मे़त्तु, “आल्‍लसाङ् खे़ने़ॽ याःम्‍बक्‍थिक्‌चोःक्‍मा के़गत्तुॽरो॥ पेगे़ॽआङ् के़गत्तुबान्‌के़रे़क् सङ्‌घे़देःसे़ॽ हे़क्‍क्‍याङ् याङ्‌गे़साॽबाहाॽ पिरे़से़ॽओ॥ हे़क्‍केलॽरिक् साङ्‌ग्राम्‍पेदाङ्‌ङो याङ्‌साकुन्‍धे के़घोःसुॽरो॥ हे़क्‍क्‍याङ् फे़रे़ॽआङ् इङ्‌गाॽ तिम्‍दाङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","हे़क्‍क्‍याङ् खे़न् मनाःल्‍ले़ कुनाःन् किःन्‍दुआङ् कुनिङ्‌वाॽ तुगे़र खे़प्‍मोलाम् पे, थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ग यरिक् याङ्‌साकुन्‍धे कत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ये़सुरे़ खिरि ओमये़र कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “याङ्‌साकुन्‍धेसाबाहाॽग निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःप्‍मा साॽरिक् साक्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","कुबाःन्‍निन्‌मे़घे़प्‍सुआङ् कुहुॽसाम्‍बाहाॽरे़ साॽरिक् खुनिॽ निङ्‌वाॽ मये़, कर ये़सुरे़ याम्‍मो खे़ङ्‌हाॽ मे़त्तुसि, “चुक्‍पासे, निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःप्‍मा से़क्‍खाए साक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","याङ्‌साकुन्‍धेसाबे़न् निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःप्‍मानुःल्‍ले़ उमेःन् सम्‍मेःत्तिल्‍ले़ कुहङ्‌ङो लाःप्‍मा उसुरु पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ साॽरिक् खुनिॽ निङ्‌वाॽ मये़आङ् अक्‍खे मे़मे़त्‍छिङ्, “हे़क्‍केःल्‍ले़ हाःत् ताङ्‌से़ःप्‍मा सुक्‍पाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ये़सुरे़ खे़ङ्‌हाॽ ओमे़त्तुसिर मे़त्तुसि, “खे़प्‍से़म्‍मे़ॽ, मे़न्‍छाम् याप्‍मिरे़ लागिग कन् सुक्‍मे़न्‍दे़प्‍मना चोःक्‍साङ्, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुलागिग मे़साक्‍ने़न्‍लो॥ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़रे़क् पाःन्‍हाॽ चोःक्‍मा सुक्‍तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","हे़क्‍क्‍याङ् पत्रुसरे़ मे़त्तु, “आदाङ्‌बे, आनिगे़ग के़रे़क् पाःन्‍हाॽ ले़रुम्‍बे़, हे़क्‍क्‍याङ् खे़ने़ॽ तिम्‍मासिगे़आङ् वयिगे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","हे़क्‍क्‍याङ् ये़सुरे़ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आत्तिल्‍ले़ आलागि नु सुनाइङ्‌ले़ लागि हिम्‍धाःङ्‌हाॽ, प्‍याङ्‌सिगे़न् इक्‍ताप्‍हाॽ, ने़ॽनुसाॽहाॽ, फुॽनुसाॽहाॽ, पाः माहाॽ, इग्र हिन्‍जाॽबित्‍छाहाॽ ले़रुसिआङ् वाॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","खे़ल्‍ले़ से़क्‍खाए कन् ये़म्‍मो मनालाम्‍बा तुक्‍खे चामानु सोसोरिक् हिम्‍धाःङ्‌हाॽ, प्‍याङ्‌सिगे़न् इक्‍ताप्‍हाॽ, फुॽनुसाॽ, ने़ॽनुसाॽ, माहाॽ हे़क्‍क्‍याङ् हिन्‍जाॽबित्‍छाहाॽ किप्‍थिक् (१००) ले़ङ्‌नुःल्‍ले़आङ्‌यरिक् खोःसुॽरो॥ हे़क्‍क्‍याङ् के़दाःबा ये़म्‍मो मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","कर आल्‍लो तगि के़वाॽबा यरिक् मनाहाॽ एगाङ् मे़बोःङ्‌लो, हे़क्‍क्‍याङ् आल्‍लो एगाङ् के़वाॽबा यरिक् मनाहाॽ तगाङ् मे़बोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","खे़ङ्‌हाॽ यरुसले़म थो मे़बेःल्‍ले़ ये़सुःन् कुहुॽसाम्‍बाहाॽनुःल्‍ले़ तगाङ् पत्‍छे़॥ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ मये़, हे़क्‍क्‍याङ् एगाङ् के़दिम्‍बाहाॽआङ् मे़गिसे़रो॥ हे़क्‍क्‍याङ् ये़सुरे़ थिक्-ने़त् (१२) कुहुॽसाम्‍बाहाॽ थिक्‍ले़प्‍माङ् तेॽरुसिआङ् आल्‍ल पोःङ्‌मा इःत्ते़बा पाःन्‍निल्‍ले़ कुयाःम्‍बेओ अक्‍खेलॽरिक् मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“आल्‍ल आनिॽ यरुसले़म आगे़त्ताङ् खे़प्‍मो तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ खुनिॽ हुक्‍को मे़न्‍छाम्‍साःन् इङ्‌मे़ले़क्‍तुआङ् हुक्‍मे़सुप्‍तुॽरो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुने़ॽ सिःमे़ल्‍ले़न् खुम्‍दिङ् मे़बिरुआङ् थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ खुनिॽ हुक्‍को मे़बिरुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","खे़ङ्‌हाॽरे़ खुने़ॽ किनाःन्‍दि मे़बिरु, थ्‍याःत् मे़धोःक्‍तुॽ, मे़हिप्‍तुॽ, ते़ःम्‍भुक् मे़बिरुॽ, हे़क्‍क्‍याङ् मे़से़रुॽरो॥ कर खुने़ॽ सुम् ये़न् एगाङ् सिःमे़न्‍लाम् याम्‍मो हिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","हे़क्‍क्‍याङ् जब्‍दियारे़ कुस्‍साः याकुब नु युहुन्‍नाःल्‍ले़ ये़सुःन् मे़त्ते़छु, “आदाङ्‌बा सिक्‍साम्‍बे, आन्‍छिगे़ पाःत्‍छुगे़बा पाःन्‍निन् आन्‍छिगे़ लागि चोगे़ॽओ के़लॽबा निङ्‌वाॽ कत्‍छुगे़ॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “खिन्‍छिॽ इङ्‌गाॽ थे़मा चोगुङ् पिने़त्‍छिङ्‌ल फाॽआङ् निङ्‌वाॽ के़जोःक्‍सुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","खे़ङ्‌हाॽरे़ नोगप् पिरे़त्‍छु, “खे़ने़ॽ मिमिदिङ्‌गे़न् के़हाङ्‌जुम्‍मो के़युङ्‌ङिल्‍ले़, के़जुप्‍साङ् नु के़भे़न्‍छाङ् ले़प्‍माङ् आन्‍छिगे़ युङ्‌मा याप्‍मि पाङ्‌घे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिन्‍छिॽ थेःन् के़नाःक्‍सुर के़बत्‍छिॽ खे़न् कुसिङ् के़न्‍निःत्‍छुन्॥ इङ्‌गाॽ थुङुङ्‌बा तुक्‍खेवा खोर्याओ थुङ्‌मा के़सुक्‍सुबि? हे़क्‍क्‍याङ् इङ्‌गाॽ पोःङ्‌ङाबा बप्‍तिस्‍मान् खिन्‍छिॽ पोःङ्‌मा के़सुक्‍सुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","खे़ङ्‌हाॽरे़ नोगप् पिरे़त्‍छु, “सुक्‍सुगे़ॽ॥” ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिन्‍छिॽ से़क्‍खाए इङ्‌गाॽ थुङुङ्‌बा खोर्याओ के़धुङ्‌सुॽआङ् इङ्‌गाॽ पोःङ्‌ङाबा बप्‍तिस्‍मान्‍नाङ् खिन्‍छिॽ के़बोःङ्‌सिॽ, ");
INSERT INTO lifNT2_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","करसाङ् आभे़न्‍छाङ् नु आजुप्‍साङ् ले़प्‍माङ् युङ्‌मा के़सुक्‍सिॽ पाःप्‍मा युक् मे़गत्तान्‍लो॥ खे़न् ते़न्‍हाॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ आत्तिन्‍हाॽ पिमासि फाॽआङ् यारिप् चोगुआङ् वाॽ, बा खे़ङ्‌हाॽरक् युङ्‌मा मे़घोःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","हे़क्‍क्‍याङ् वेॽ थिबोःङ् (१०) हुॽसाम्‍बाहाॽरे़ कन् मे़घे़प्‍सुआङ् याकुब हे़क्‍क्‍याङ् युहुन्‍नाःन्‍नु खुन्‍छिॽ सिक् पोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","हे़क्‍केःल्‍ले़ ये़सुरे़ काक् उःत्तुसिआङ् मे़त्तुसि, “थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ खुनिॽ हाङ्‌हाॽरे़ग मनाहाॽ पाःप्‍पाःत्‌मे़मे़त्तुसिबा हे़क्‍क्‍याङ् खुनिॽ सुहाङ्‌युक्‍पाहाॽरे़आङ् खुनिॽ फोःसाङ्‌बाहाॽ मे़युक्‍तुसिबाग खिनिॽ के़निःसुम्‍माङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","कर खिनिॽ लुम्‍मोग हे़क्‍के पोःङ्‌मा मे़नुॽने़न्‍लो॥ खिनिॽ लुम्‍मोग आत्तिल्‍ले़ लाम्‍लोःबा पोःङ्‌मा निङ्‌वाॽ चोगुॽ खे़न् हाराॽ खिनिॽ सेवारोबा पोःङ्‌लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","हे़क्‍क्‍याङ् हाःत्‍ले़ के़रे़क्‍नुःल्‍ले़ तगाङ् पोःङ्‌मा निङ्‌वाॽ चोगुॽ, खे़न् के़रे़क्‍ले़ खुनिॽ योःक् पोःङ्‌लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ मे़न्‍छाम्‍साःन् सेवा मे़बिआर फाॽआङ् मे़ःन्, कर सेवा पिसे़ त्‍याङ्‌बारो॥ हे़क्‍क्‍याङ् यरिक् मनाहाॽ लायोलाम् थे़ॽमासिआङ्‌ताङ्‌से़ःप्‍मासि फाॽआङ् इङ्‌गाॽ आहिङ्‌मन्‍निन् पिसे़ त्‍याङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ ये़रिहो ये़क्‌यक्‍को मे़द्‌ये़॥ याङ्‌सि ये़सुःन् नु कुहुॽसाम्‍बाहाॽ यरिक् मनाहाॽनु ये़क्‌यक्‍लाम् मे़बेर मे़बत्‍छे़ल्‍ले़ तिमैरे़ कुस्‍साः बर्तिमाइ मे़प्‍मनाबा चागे़नाःक्‍पा मिक्‍फःम्‍बे़न् लाम्‍मिल्‍ले़ कुयाओ युङे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","नासरतबा ये़सुःन् पेःक्‍ल पत् के़लॽबा खे़ल्‍ले़ खे़प्‍सुआङ् अःक्‍मा हेःक्‍ते़, “दाउदरे़ कुस्‍साः ये़सुए, इङ्‌गाॽ लुङ्‌माॽ तुक्‍ताङ्‌ङे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","यरिक् मनाहाॽरे़ खे़न् स्‍वाःत् युङे़ॽ फाॽआङ् मे़भे़ःक्‍तु॥ कर खे़न् आल्‍लसाङ् साॽरिक् अःक्‍ते़, “दाउदरे़ कुस्‍साःए, इङ्‌गाॽ लुङ्‌माॽ तुक्‍ताङ्‌ङे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ये़सुरे़ खे़न् अःक्‍ते़बा खे़प्‍सुल्‍ले़ ये़म्‍सिङ्‌ङाङ् खे़ङ्‌हाॽ मे़त्तुसि, “खे़न् कत्‍ना फे़त्ते़म्‍मे़ॽ॥” हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़बेआङ् खे़न् मिक्‍फःम्‍बे़न् मे़मे़त्तु, “हौ, सःत्ते़ॽओ! सिक्‍साम्‍बे़ल्‍ले़ के़उःत्ते़आङ् वाॽरो॥ खे़ने़ॽ पोगे़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","खे़ल्‍ले़ कुसुङ्‌घेःक्‌वाःन् थिक्‍ले़प्‍माङ् लाप्‍फुसुआङ् मुत्‍थ्रिक् पोगे़आङ् ये़सुरो पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ये़सुरे़ खे़न् सेःन्‍दोसु, “इङ्‌गाॽ थे़मा चोगुङ् पिने़बा निङ्‌वाॽ के़जोगुबे?” खे़ल्‍ले़ मे़त्तु, “सिक्‍साम्‍बे, इङ्‌गाॽ निःमा के़सुक्‍पा पोःङ्‌ङार॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मे़त्तु, “पेगे़ॽ! खे़ने़ॽ के़नसाःन्‍निल्‍ले़ निःमा के़सुक्‍पा के़जोगे़आङ् के़वाॽरो॥” खिमो खे़न् निःमा के़सुक्‍पा पोःक्‍खे़आङ् सःत्ते़र ये़सुरे़ कुएगाङ् कुएगाङ् थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ये़सुःन् नु कुहुॽसाम्‍बाहाॽ यरुसले़म मे़बेर मे़बत्‍छे़ल्‍ले़ यरुसले़म निःत्ताङ्‌बा जैतुन कोःक्‍माल्‍ले़ कुबेसाङ्‌बा बे़थफागे नु बे़थानि मे़प्‍मनाबा पाङ्‌जुम् निःत्ताङ् मे़गे़रे़, हे़क्‍क्‍याङ् ये़सुरे़ ने़प्‍फु कुहुॽसाम्‍बाहाॽ अक्‍खे मे़त्तुसिर पाङ्‌घुसि, ");
INSERT INTO lifNT2_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“खिन्‍छिॽ तगाङ्‌बा पाङ्‌भेॽओ पेसे़ॽ॥ खे़प्‍मो के़लाःत्‍छिल्‍ले़सा आप्‍फाल्‍ले़आङ् मे़न्‌युक्‍के के़वाॽबा अदङ्‌साधिक् इमे़घेःक्‍खुआङ् ये़प्‍पा के़दुम्‍सुॽ॥ खे़न् ले़रे़त्‍छे़ॽआङ् कत्‍ना फे़त्ते़त्‍छे़ॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","मनाहाॽरे़ थेआङ् कन् अदङ्‌साःन् के़ले़त्‍छुबाबे फाॽआङ् सेःन्‍गे़म्‍लाप्‍सिने़ फाॽग्र कन् आनिगे़ दाङ्‌बान् चाहाबा चोगे़आङ् वाॽ हे़क्‍क्‍याङ् हाराए खुने़ॽ याङ्‌ना नुःक्‍तुॽरो मे़त्ते़छे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ पेसिल्‍ले़ से़क्‍खाए लत्‍छा हिम्‍बेसाङ् अदङ्‌साःन् इमे़घेःक्‍खुआङ् लाम्‍मो ये़बे़बा निःसे़त्‍छु, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ले़रे़त्‍छुर पत्‍छे़त्‍छिल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","खे़प्‍मो के़ये़प्‍पा कुभा मनाहाॽरे़ सेःन्‍मे़दोसुसि, “कन् अदङ्‌साःन् थेआङ् के़ले़त्‍छुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","खे़ङ्‌हाॽरे़ ये़सुरे़ मे़त्तुसिबा हे़क्‍केए नोगप् पिरे़त्‍छुआङ् खे़न् मनाहाॽरे़ पेःक्‍मा मे़बाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","खे़ङ्‌हाॽरे़ खे़न् अदङ्‌साःन् ये़सुरो तारे़त्‍छुआङ् कुहुॽसाम्‍बाहाॽरे़ खुनिॽ तेःत्‍हाॽ खे़न् अदङ्‌साःल्‍ले़ कुएःक्‍को मे़ने़स्‍सु, हे़क्‍क्‍याङ् ये़सुरे़ खे़न् युक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","यरिक् मनाहाॽरे़ खुनिॽ तेःत्‍हाॽ लाम्‍मो मे़भे़सु॥ कुभारे़ग खे़न् खिरिलाम्‌कुभे़क्‌वानुबा सिङ् पोराःक्‍हाॽ मे़जे़प्‍तुआङ् लाम्‍मो मे़भे़सुर खुने़ॽ लाङ्‌दाःक्‍मा मे़बिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","खुने़ॽ कुदगि नु कुएगाङ् के़बप्‍पा यरिक् मनाहाॽरे़ मे़अःक्‍ते़र अक्‍खे मे़बाःत्तु, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा पोःररो! यहवे दाङ्‌बाल्‍ले़ कुमिङ्‌ङो के़दाःबान् मुॽइसाबा पोःङ्‌लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","आनिॽ थाःक्‍थे़बा दाउद हाङ्‌ङिल्‍ले़न् के़दाःबा हाङ्‌जुम्‍मिन् मुॽइसाम्‍मिल्‍ले़ कुधिम् पोःङ्‌लरो! साङ्‌ग्राम्‍पेदाङ्‌ङो निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा पोःररो!” ");
INSERT INTO lifNT2_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","हे़क्‍केलॽरिक् ये़सुःन् यरुसले़म्‍मो पेआङ् माङ्‌हिम्‍मो लाःसे़॥ हे़क्‍क्‍याङ् खुने़ॽ खे़प्‍मो खिरि ताक्‍कन्‍दे़र के़रे़क् ओमे़त्तुसि, कर नाम्‍धे़ पेआङ् वये़बाल्‍ले़ चोगुल्‍ले़ याम्‍मो थिक्-ने़त् (१२) कुहुॽसाम्‍बाहाॽनु बे़थानि पाङ्‌जुम्‍मो नुःक्‍खे़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","हे़क्‍क्‍याङ् कुदाःन्‍दिक् तानाम्‍सा बे़थानिलाम् यरुसले़म मे़बेर मे़बत्‍छे़ल्‍ले़ ये़सुरे़ कुसे़त्‍लाःक्‍ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","माःङ्‌घालाम् पःत्‍छेॽबुङ्‌मान् सरित् यारिक् निःसुआङ् कुजाॽ थोःक्‍ते़आङ् पत्पि फाॽआङ् खे़प्‍मो पेआङ् ओमे़त्तुल्‍ले़ कुभे़क्‌वारक् पत्‍छे़ कर कुजाॽ मे़बत्‍छे़न्‌, थेआङ्‌भे़ल्‍ले़ पःत्‍छेॽ थोःक्‍मा ये़म् मे़न्‍दाए वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ये़सुरे़ खे़न् पःत्‍छेॽबुङ्‌मान् मे़त्तु, “आल्‍लआङ्‌धो आप्‍फाल्‍ले़आङ् के़जाॽ मे़धोःक्‍ने़न्‍लरो॥” कन् पाःत्तुबा पाःन्‍निन् कुहुॽसाम्‍बाहाॽरे़आङ् मे़घे़प्‍सु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","हे़क्‍क्‍याङ् यरुसले़म मे़गे़रे़आङ् ये़सुःन् माङ्‌हिम्‍मो पे, हे़क्‍क्‍याङ् खे़प्‍मो चिगःक्‌वा के़सङ्‌बा के़इङ्‌बाहाॽ नाःप्‍मा लःप्‍मा हेःक्‍तुसि॥ याङ् के़ले़क्‍पाहाॽरे़ खुनिॽ याङ्‌ले़क्‍मा साप्‍ने़त्तिन् नु पुत्तुःक्‍के के़सङ्‌बाहाॽरे़ खुनिॽ युक्‍नाःन् ले़क्‍खुबिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","हे़क्‍क्‍याङ् कन् माङ्‌हिम् लक्‍खुम्‍मो लाङ्‌घेःक्‍मार चिगःक्‌वा तेॽमा ताःप्‍मा साक्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़त्तुसि, “साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् पत्, ‘इङ्‌गाॽ आहिम्‍मिङ्‌ग के़रे़क् मे़न्‍छाम् सुवाङ्‌हाॽरे़न् तुवा चोःक्‍मा हिम् पोःङ्,’ कर खिनिॽग फाःन्‍दाहाॽ चिङ्‌सिङ्‌मा ते़न् के़जोगुम्‍माङ् के़वयिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","खे़प्‍मो तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ कन् मे़घे़प्‍सुआङ् ये़सुःन् आक्‍खेलॽरिक् से़प्‍माबे फाॽआङ् लाम् कोःप्‍मा मे़हेःक्‍तु॥ कर खे़ङ्‌हाॽ मे़गिसे़, थेआङ्‌भे़ल्‍ले़ कुनिसाम्‍मिन् मे़घे़प्‍सुल्‍ले़ के़रे़क् मनाहाॽरे़ साॽरिक् खुनिॽ निङ्‌वाॽ मये़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","हे़क्‍क्‍याङ् नाम्‍धे़आङ् ये़सुःन् नु कुहुॽसाम्‍बाहाॽ यरुसले़म्‍लाम् मे़लःन्‍दे़ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","कुनाम्‍दाःप्‍मा खे़न् लाम्‍मो मे़बेःल्‍ले़ मिःप्‍माबा पःत्‍छेॽबुङ्‌मान् कुबुङ्‌मोनुए हेरे़आङ् स्‍ये़बा मे़निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ये़सुरे़ पाःत्तुबान् पत्रुसरे़ निङ्‌वाॽ इःत्तुर खुने़ॽ मे़त्तु, “सिक्‍साम्‍बे, ओमे़त्ते़ॽ! खे़न् साङ्‌ग्रा के़मे़त्तुबा पःत्‍छेॽबुङ्‌माङ्‌ग इले़मे़आङ् स्‍ये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","ये़सुरे़ मे़त्तुसि, “निङ्‌वाॽफुमाङ्‌ङिन्‌नसाःन् चोगे़म्‍मे़ॽ! इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, हाःत्‍ले़ निङ्‌वाॽओ चप्‍चि मे़न्‍जोःक्‍के, कन् कोःक्‍मान् हाॽयाक्‌आगे़ॽआङ् वाहङ्‌ङो लाप्‍फुसिङ्‌ङे़ॽ फाॽआङ् निङ्‌वाॽओ नसाःन् चोगुआङ् पाःत्तुॽ, खे़ङ्‌ग कुलागि पोःङ्‌ङेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽ तुवा के़जोगुम्‍मिल्‍ले़ के़नाःक्‍तुम्‍बा पाःन्‍निन् खोःसुम्‍बे़ॽ फाॽआङ् नसाःन् चोगे़म्‍मे़ॽ, हे़क्‍क्‍याङ् खे़न् निङ्‌वाॽफुमाङ्‌लाम् के़घोःसुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","हे़क्‍क्‍याङ् खिनिॽ तुवा के़जोगुम्‍मिल्‍ले़ आत्तिन् मनाःल्‍ले़ कुदक्‍ले़ङ्‌वाओ खिनिॽ निङ्‌वाॽ तुगे़आङ् वाॽ, खे़न्‍निन् ले़प्‍मि पिरे़म्‍मे़ॽओ॥ हे़क्‍केलॽरिक् साङ्‌ग्राम्‍पेदाङ्‌ङो के़वाॽबा खिनिॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़आङ् खिनिॽ लायोःन् ले़प्‍मि के़बिरिॽरो॥ ((कर खिनिॽ ले़प्‍मि के़म्‍बिरुम्‍मिन्‍ने़ फाॽग्र साङ्‌ग्राम्‍पेदाङ्‌ङो के़वाॽबा खिनिॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़आङ् खिनिॽ लायोःन् ले़प्‍मि के़म्‍बिरिन्‍लो॥))” ");
INSERT INTO lifNT2_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","खे़ङ्‌हाॽ याम्‍मो यरुसले़म्‍मो मे़द्‌ये़॥ ये़सुःन् माङ्‌हिम् लक्‍खुम्‍मो ताक्‍कन्‍नु वये़ल्‍ले़ खे़प्‍मो तुम्निङ्‌वाॽफुसाम्‍बाहाॽ, साम्‌योथिम्‍साम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽ मे़द्‌ये़आङ् ");
INSERT INTO lifNT2_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","सेःन्‍मे़दोसु, “खे़ने़ॽ थे़मा युक्‍किल्‍ले़ अक्‍तङ्‌बा याःम्‍बक्‍हाॽ के़जोगुर के़वाॽ? कन् युक्‍किन् हाःत्‍ले़ के़बिरे़?” ");
INSERT INTO lifNT2_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽआङ् लत्‍छा सेःन्‍लाप्‍थिक् सेःन्‍दोःनिङ्‌लो॥ याप्‍मि नोगप् आबिरे़म्‍मे़ॽओ, हे़क्‍क्‍याङ्‌लक् थे़मा युक्‍किल्‍ले़ इङ्‌गाॽ याःम्‍बक् चोगुङ्, खिनिॽ मे़त्‍निङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","युहुन्‍नारे़ बप्‍तिस्‍मा पिमा कुयुक्‍किन् आत्तोलाम् त्‍ये़बाबे? निङ्‌वाॽफुमाङ्‌लाम् त्‍ये़बाबि, इ मनालाम्बि? याप्‍मि आमे़त्ते़म्‍मे़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","खे़ङ्‌हाॽरे़ खुनिॽ लुम्‍मो पाःन् मे़धक्‍ते़र अक्‍खे मे़मे़त्‍छिङ्, “आल्‍ल आनिॽ ‘निङ्‌वाॽफुमाङ्‌लाम्’ आमे़त्तुम्‍ने़ फाॽग्र, थेआङ् नसाःन् के़न्‍जोगुम्‍मिन् फाॽआङ् सेःन्‍आलाप्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","कर ‘मनाहाॽलाम्‍लो’ आमे़त्तुम्‍ने़ फाॽग्र, मनाहाॽ आनिॽ तक्‍ले़ङ्‌वाओ मे़बोःक्, थेआङ्‌भे़ल्‍ले़ मनाहाॽरे़ युहुन्‍नाःन् से़क्‍खाए माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा फाॽआङ् मे़इःत्तुआङ् मे़वाॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ ये़सुःन् मे़मे़त्तु, “आनिगे़ मे़निःसुम्‍बे़न्‍लो॥” हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “हे़क्‍केने़ फाॽग्र थे़मा युक्‍किल्‍ले़ अक्‍तङ्‌बा याःम्‍बक्‍हाॽ चोगुङ् खे़न् इङ्‌गाॽआङ् मे़मे़त्‍निङ्‌ङिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ये़सुःन् खे़ङ्‌हाॽनु खे़दाॽओ अक्‍खेलॽरिक् पारे़, “उन्‍छेःन् मनाधिक्‍ले़ लत्‍छा इक्‍को चे़ल्‍ले़क्‍सेॽ लेःत्तुआङ् कुघिरि लुङ्‌धाक् से़त्तुआङ् फाङु, हे़क्‍क्‍याङ् कुलुम्‍मो लुम्‍बाःत् तयुआङ् खे़प्‍मो चे़ल्‍ले़क्‍सेॽ एःम्‍मा ते़न्धिक्‌चोगु॥ इक् कोमा याक्‍साधिक्‍काङ् चोगु, हे़क्‍क्‍याङ् खे़न् चे़ल्‍ले़क्‍सेॽ इक्‍किन् कुभ्रे़ःङ् लक् खोःमारे़ लागि इक्‍मसाबाहाॽ पिरुसिआङ् खुने़ॽ लाम्‍दिःक् चोःक्‍से़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","हे़क्‍क्‍याङ् चे़ल्‍ले़क्‍सेॽ तुप्‍मा ये़म् त्‍ये़ःल्‍ले़ कुलक् लाःसे़ कुसेवारोबाधिक्‌इक्‍मःबाहाॽरो पाङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","कर खे़न् इक्‍मसाबाहाॽरे़ खुने़ॽग मे़हिप्‍तुआङ् थेआङ् मे़म्‍बिए हाबा मे़बाङ्‌घु मे़देःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","याम्‍मो खे़न् इक्‍के़ल्‍ले़ कुन्‍दाङ्‌बाल्‍ले़ वेॽस्‍मा सेवारोबान् पाङ्‌घु॥ खे़न्‍नाङ् कुधे़गेःक्‍पो मे़घाक्‍खुर कुजाःत्‍थि मे़देःसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","याम्‍मो वेॽस्‍मा सेवारोबान् पाङ्‌घु, हे़क्‍क्‍याङ् खे़ङ्‌ग मे़हिप्‍तुआङ् मे़से़रुरो॥ हे़क्‍केलॽरिक् खुने़ॽ वेॽ वेॽ यरिक् सेवारोबाहाॽ पाङ्‌घुसिल्‍ले़ कुभा मे़हिप्‍तुसि, कुभा मे़से़रुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","खे़न् इक्‍के़ल्‍ले़ कुन्‍दाङ्‌बाल्‍ले़ लुङ्‌माॽ तुक्‍तुबा लत्‍थिक्‍लक् कुस्‍साः वये़॥ आल्‍ल कन् आस्‍साःन् पाङ्‌घुङ्‌ङिल्‍ले़ग से़क्‍खासाङ् कुना मे़साॽरुबिला फाॽआङ् इःत्तुआङ् के़रे़क्‍नुःल्‍ले़ एगाङ् पाङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","कर खे़न् इक्‍मसाबाहाॽ अक्‍खे मे़मे़त्‍छिङ्, ‘कङ्‌ग कुम्‍बारे़ कुलक् के़घोःबारो, कन्‌से़रुम्‍माङ् कुलाजेॽ सिङ्‌बुङ्‌हाॽ आनिॽ हुक्‍काप्‍पासिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","हे़क्‍क्‍याङ् कुस्‍साःन्‍नाङ् मे़हिप्‍तु मे़से़रुआङ् चे़ल्‍ले़क्‍सेॽ इक्‍कोलाम् लाःक्‍कात् लाप्‍मे़भुसुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","हे़क्‍केःल्‍ले़ ये़सुरे़ सेःन्‍लाप्‍तुसि, “आल्‍ल खे़न् चे़ल्‍ले़क्‍सेॽ इक्‍के़ल्‍ले़ कुन्‍दाङ्‌बान् ताआङ् खे़ङ्‌हाॽ आक्‍खे मे़त्तुसिॽबे? से़क्‍खासाङ् खुने़ॽ के़रे़क् से़रुसिआङ् खे़न् चे़ल्‍ले़क्‍सेॽ इक्‍किन् वेॽ मनाहाॽ पिरुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","कन्‌साम्‌योसाप्‍लाओ के़बप्‍पा पाःन्‍निन् मे़न्‍निःत्ते के़वयिॽबि? ‘लुङ्‌गाम्‍बाहाॽरे़ मे़नाॽरुबा लुङ्‌ङिन् काक्‍नुःल्‍ले़ के़ये़क्‍पा कुम्‍मा लुङ् पोःक्‍खे़आङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","कङ्‌ग यहवे दाङ्‌बाल्‍ले़ए चोगुबारो, हे़क्‍क्‍याङ् कन् आनिॽ निःमो निङ्‌वाॽ के़माबा चोःक्‍लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","खे़ङ्‌हाॽरे़ ये़सुःन् ते़म्‍मा निङ्‌वाॽ मे़जोगु, थेआङ्‌भे़ल्‍ले़ ये़सुरे़ पाःत्तुबा खे़दाॽओ खे़ङ्‌हाॽ कुॽइके़भे़म्‍बा इक्‍मसाबाहाॽनु तङ्‌घुसिबान्‌खे़ङ्‌हाॽरे़ निङ्‌वाॽ मे़घोःसु॥ कर खे़ङ्‌हाॽरे़ मनाहाॽ मे़गिरुसिआङ् खुने़ॽ मे़ले़रुआङ् मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","खे़ल्‍ले़ कुएगाङ् कुभा यहुदि लाम्‍लोःबाहाॽरे़ पाःन्‍नो ते़म्‍माआङ् ये़सुःन् आप्‍तिक् कुःप्‍मा फाॽआङ् कुभा फरिसिहाॽ नु हे़रोद हाङ्‌ङिल्‍ले़ कुमनाहाॽ मे़बाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","खे़ङ्‌हाॽ मे़द्‌ये़आङ् सेःन्‍मे़दोसु, “सिक्‍साम्‍बे, खे़ने़ॽग से़क्‍खा पाःन्‍लक् के़बाःत्‍लो॥ खे़ने़ॽग मनाहाॽरे़ खुनिॽ पाःन्‍नोआङ् के़म्‍बत्‍ने़न्, हे़क्‍क्‍याङ् आत्तिन् मनाहाॽआङ् के़न्‍छे़न्‍दुन्‍छिन्‌॥ खे़ने़ॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुलाम्‍मिन् से़क्‍खाए के़हुॽरुसिरो॥ हे़क्‍केःल्‍ले़ कन्‌पाःन्‍निन् आमे़त्ते़ॽ–रोमि पयम् हाङ् सिजरे़न् एःङ्‌याङ् हुङ्‌मा आनिॽ साम्‌योथिम्‍मिल्‍ले़ आबिॽबि आम्‍बिने़न्बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ चिःप्‍मान् निःसुआङ् सेःन्‍दोसुसि, “थेआङ् खिनिॽ अक्‍खेलॽरिक् इङ्‌गाॽ पाःन्‍नो ते़म्‍मा निङ्‌वाॽ के़इःत्तुम्‍बाबे? याङ्‌इत्‍छिःन्‌फे़त्ते़म्‍मे़ॽ, इङ्‌गाॽ ओमे़त्तुङ् साॽरुङ्॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","खे़ङ्‌हाॽरे़ मे़भे़त्तुआङ् ये़सुरे़ खे़न् ओमे़त्तुआङ् सेःन्‍दोसुसि, “कन् याङ्‌इत्‍छिओ हाःत्‍ले़ कुइत्‍छाप् नु कुबाःन्‍साप् पप्‍पे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “सिजरे़ल्‍ले़न्‌पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “हे़क्‍केःल्‍ले़ सिजरले़ कुबाःन्‍हाॽ सिजरे़न् पिरे़म्‍मे़ॽ, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुबाःन्‍हाॽ निङ्‌वाॽफुमाङ्‌ङिन्‍ने पिरे़म्‍मे़ॽओ॥” हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ साॽरिक् खुनिॽ निङ्‌वाॽ मये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","खे़प्‍मो सिःमे़न्‍लाम् याम्‍मो हिङ्‌मन् होःप्‌लॽरिक् नसाःन् के़जोःक्‍पा सदुकिहाॽ मे़द्‌ये़आङ् ");
INSERT INTO lifNT2_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","सेःन्‍मे़दोसु, “सिक्‍साम्‍बे, मोसारे़ग अक्‍खेलॽरिक् साप्‍तु आबिरे़आङ् पत्‌–‘आत्तिल्‍ले़ कुम्‍भुॽइन् कुस्‍साः कुए मे़न्‌वाॽए सिःॽ, खे़ल्‍ले़ कुन्‍साॽरे़ मेमेदुमा कुन्‍ने़ॽद्रेःन्‍नु मेःक्‍खिम् चोःक्‍माए पोःङ्॥ हे़क्‍क्‍याङ् कुम्‍भुॽरे़ कुलागि सागप्‍मा पोःङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","आल्‍ल नुसि फुॽनुसाॽहाॽ मे़वये़॥ तुम्‍बाल्‍ले़ मेःक्‍खिम् चोगुआङ् कुस्‍साः कुए मे़न्‌वाॽए स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","हे़क्‍क्‍याङ् सरुम्‍बे़ल्‍ले़आङ् मेमेदुमा कुन्‍ने़ॽद्रेःन्‍नु मेःक्‍खिम् चोगु, कर खे़न्‍नाङ् कुस्‍साः मे़न्‌वाॽए स्‍ये़॥ हे़क्‍क्‍याङ् याङ्‌सरुम्‍बे़ल्‍ले़आङ् खे़न् मेमेदुमा कुन्‍ने़ॽद्रेःन्‍नु मेःक्‍खिम् चोगु, खे़न्‍नाङ् कुस्‍साः मे़न्‌वाॽए स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","नुसि फुॽनुसाॽहाॽरे़ मेःक्‍खिम् मे़जोगुसाङ् खुनिॽ सामे़न्‌वाॽए के़रे़क् मे़स्‍ये़॥ कुनुप्‍मो खे़न् मे़न्‍छुमाॽइन्‍नाङ् स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","आल्‍ल खे़ङ्‌हाॽ सिःमे़न्‍लाम् याम्‍मो मे़हिङ्‌ङिल्‍ले़ आत्तिल्‍ले़ कुमेःत् पोःङ्‌बाबे? खे़न्‍नुग नुसिए फुॽनुसाॽहाॽरे़ मेःक्‍खिम् मे़जोगुआङ् मे़वये़॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽग पिर्बेःम्‍बा के़ज्‍ये़ॽइआङ् के़वयिॽरो, थेआङ्‌भे़ल्‍ले़ साम्‌योसाप्‍लाःन् कुसिङ् मे़न्‍निःत्ते के़वयि, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍मिन्‍नाङ् कुसिङ् मे़न्‍निःत्ते के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","थेआङ्‌भे़ल्‍ले़ सिःमे़न्‍लाम् याम्‍मो मे़हिङ्‌ङिल्‍ले़ग मनाहाॽ मेःक्‍खिम् मे़न्‍जोःक्‍ने़न्‍लो, कर खे़ङ्‌हाॽग साङ्‌ग्राम्‍पेदाङ्‌ङोबा माङ्‌लाइङ्‌बा कुइसिःक्‍ने़ मे़बोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","आल्‍ल सिःमे़न्‍लाम् याम्‍मो के़हिङ्‌बाहाॽरे़ खुनिॽ मे़न्‍नो खिनिॽ मोसारे़ कुसाप्‍पन्‍निन् मे़न्‍निःत्ते के़वयिॽबि? खे़प्‍मो मि के़दिःप्‍पा पोःक्‍लालाम्‌निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ अक्‍खे पाःत्तुआङ् पत्, ‘इङ्‌गाॽग अब्राहाम, इसहाक नु याकुबरे़ खुनिॽ निङ्‌वाॽफुमाङ्‌आरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","खे़ल्‍ले़ चोगुल्‍ले़ खुने़ॽग कुसिवे़त्‍हाॽरे़न् मे़ःन्, कर कुहिङ्‌वे़त्‍हाॽरे़ खुनिॽ निङ्‌वाॽफुमाङ्‌लो॥ खिनिॽग साॽरिक्‍के पिर्बेःम्‍बा के़ज्‍ये़इआङ् के़वयिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","खे़प्‍मोबा साम्‌योथिम्‍साम्‍बाधिक्‍ले़ पाःन् मे़धक्‍ते़बा खे़प्‍सुसि॥ खे़ल्‍ले़ ये़सुरे़ साॽरिक् निङ्‌वाॽ के़दाःबा नोगप् पिरुसिबा निङ्‌वाॽ खोःसुआङ् ये़सुःन् सेःन्‍दोसु, “सिक्‍साम्‍बे, इःप्‍मा नाःप्‍माए के़बोःङ्‌बा के़रे़क्‍नुःल्‍ले़ यम्‍बा साम्‌योथिम् इङ्‌जाःङ्‌ङिन् आत्तिङ्‌ग?” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ये़सुरे़ नोगप् पिरु, “के़रे़क्‍नुःल्‍ले़ यम्‍बा नाःप्‍माए के़बोःङ्‌बा इङ्‌जाःङ्‌ङिन् कन्‍लो–‘इस्राइलिसे, खे़प्‍से़म्‍मे़ॽओ! आनिॽ दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन्, थिक्‍लक् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","के़न्‍दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन् खे़ने़ॽ के़रे़क् के़सिक्‍लुङ्‌माल्‍ले़ के़रे़क् के़सक्‍मासाम्‍मिल्‍ले़, के़रे़क् के़निङ्‌वाॽइल्‍ले़, के़रे़क् के़धुम्‍मिल्‍ले़ मिःम्‍जि मे़त्ते़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","निसिगेःक्‍पा इङ्‌जाःङ्‌ङिन् कन्‍लो–‘आप्‍फेःक्‌लुङ्‌माॽ के़दुक्‍सिङ्‌बा कुइसिःक्‍के के़बाङ्‌भेॽसाबाहाॽआङ्‌लुङ्‌माॽ तुक्‍ते़से़ॽओ॥’ कन्‍हाॽनुःल्‍ले़ यम्‍बा वेॽ इङ्‌जाःङ्‌ङिङ्‌ग थेआङ् होःप्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","खे़न् मनाःल्‍ले़ ये़सुःन् नोगप् पिरु, “सिक्‍साम्‍बे से़क्‍खाए के़बाःत्तुरो॥ आनिॽ दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन्‍लक् दाङ्‌बारो॥ वेॽ माङ् मे़होःप्‍लो फाॽआङ् साॽरिक् के़दङ्‌बा के़बाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","हे़क्‍क्‍याङ् खुने़ॽ के़रे़क् सिक्‍लुङ्‌माल्‍ले़, के़रे़क् निङ्‌वाॽइल्‍ले़, के़रे़क् थुम्‍मिल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिन् मिःम्‍जि मे़प्‍मा नु पाङ्‌भेॽसाबाहाॽ आबाङे हे़क्‍के लुङ्‌माॽ तुक्‍मासिग, के़रे़क् मिधिङ्‌मनाआङ्‌तोःम्‍मनाबा सिदुङ्‌जभा नु वेॽ सिदुङ्‌जभा चोःक्‍मानुःल्‍ले़आङ् यम्‍बा इङ्‌जाःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","खे़ल्‍ले़ सिङ्‌सिङ्‌ङाङ् नोगप् पिरुबा निःसुआङ् ये़सुरे़ खे़न् मे़त्तु, “खे़ने़ॽ निङ्‌वाॽफुहाङ्‌जुम्‍लाम्‍बा माःङ्‌घा के़होःप्लो॥ हे़क्‍क्‍याङ् खे़न् ये़न्‍नाङ्‌धो आत्तिन्‍हाॽरे़आङ्‌खुने़ॽ पाःन् सेःन्‍दोःमा आःन्‍छिङ्‌माआङ्‌मे़न्‍छुक्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ये़सुरे़ माङ्‌हिम् लक्‍खुम्‍मो हुॽरुसिर वये़ल्‍ले़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “आक्‍खेलॽरिक् साम्‌योथिम्‍साम्‍बाहाॽरे़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌दाउद हाङ्‌ङिल्‍ले़ कुस्‍साःरो फाॽआङ् मे़बाःत्तुबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","दाउद हाङ्‌ङिल्‍ले़ सेसेमाङ्‌लाम् अक्‍खे पाःत्तुआङ् वाॽ, ‘यहवे दाङ्‌बाल्‍ले़ इङ्‌गाॽ आन्‍दाङ्‌बान् अक्‍खे मे़त्तु, के़निङ्‌मिहाॽ के़युक्‍को इङ्‌गाॽ मे़न्‍दाःत्‍छिङ्‌ङे थारिक् आजुप्‍साङ् ले़प्‍माङ् खे़ने़ॽ युङे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","दाउद हाङ्‌ङिल्‍ले़ए खुने़ॽ आदाङ्‌बे मे़त्तुल्‍ले़ आक्‍खेलॽरिक् ख्रिस्‍ते़न्‌दाउदरे़ कुस्‍साः पोःङ्‌बाबे?” यरिक् मनाहाॽरे़ खुने़ॽ कुनिसाम्‍मिन् खुनिॽ सिराॽ थाङे़र मे़घे़प्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","अक्‍खेलॽरिक् ये़सुरे़ मे़त्तुसि, “साम्‌योथिम्‍साम्‍बाहाॽनु सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ! खे़ङ्‌हाॽ केःम्‍बा केःम्‍बा लगेप् मे़जाक्‍खुआङ् नानुगत्‍ना लाङ्‌मे़घेःक्‍लो, हे़क्‍क्‍याङ् पाङ्‌जुम् लुम्‍मो सेवा मे़मे़त्तिगे़र के़लॽबा निङ्‌वाॽ मे़जोगुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","यहुदि चुम्‍लुङ्‌हिम्‍मो नु साभाङ्‌जाओ तुम्‍म्‍याङ्‌हाङ् युक्‍नाहाॽओ युङ्‌मा खुनिॽ सिराॽ थाङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","खे़ङ्‌हाॽरे़ मेमेदुमाहाॽ इङ्‌मे़ले़क्‍तुसिआङ्‌खुनिॽ हिम्‍धाःङ्‌हाॽ मे़नाप्‍तुसिॽ, कर नुःबा ओसेःन्‍धाक्‍सिङ्‌मारे़ लागि केःम्‍बा केःम्‍बा तुवा मे़जोगुॽ॥ खे़ङ्‌हाॽरे़ग से़क्‍खाए के़साक्‍पा खुम्‍दिङ् मे़घोःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ये़सुःन् माङ्‌हिम्‍मो हुक्‍सोयाङ् तोःम्‍मादे़न्‍निल्‍ले़ कुबेसाङ् हुक्‍सोयाङ् के़याक्‍पाहाॽ ओमे़त्तुसिर युङे़रो॥ खे़प्‍मो यरिक् याङ्‌साकुन्‍धेसाबाहाॽ मे़द्‌ये़आङ् यरिक् याङ्‌हाॽ मे़याक्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","कर खे़प्‍मो याङ्‌गे़साॽमा मेमेदुमाधिक् त्‍ये़आङ् याङ् ने़त्‍छि याक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ये़सुरे़ कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आइन् कन् याङ्‌गे़साॽमा मेमेदुमाल्‍ले़ वेॽहाॽनुःल्‍ले़ यरिक् हुक्‍सोयाङ् याक्‍तुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","थेआङ्‌भे़ल्‍ले़ कन् याङ्‌साकुन्‍धेसाबाहाॽरे़ग खुनिॽ के़योबाआङ्‌के़नम्‍बा याङ्‌हाॽए मे़याक्‍तु, कर कन्‌याङ्‌गे़साॽमा मेमेदुमाल्‍ले़ग खुने़ॽ कुयाङ्‌साॽमो कत्तुबा काक् चामा थुङ्‌मोलाम् याक्‍तुआङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ये़सुःन् माङ्‌हिम्‍मोलाम् लःन्‍दे़र पत्‍छे़ल्‍ले़ कुहुॽसाम्‍बाधिक्‍ले़ मे़त्तु, “आदाङ्‌बा सिक्‍साम्‍बे, आक्‍खे़न् यम्यम्‍बा लुङ्‌हाॽ नु निङ्‌वाॽ के़माबा हिम्‍हाॽने़बे, ओमे़त्ते़ॽना!” ");
INSERT INTO lifNT2_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ये़सुरे़ नोगप् पिरु, “कन् के़निःसुम्‍बा हिम्‍हाॽ थिक् लुङ्‌सम्‍दाङ् वेॽ लुङ्‌धिक्‍काङ् मे़न्‍ने़ए काक् मे़यः मे़बेःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","हे़क्‍क्‍याङ् ये़सुःन् माङ्‌हिम्‍मिल्‍ले़ नाधाःम्‍बि जैतुन कोःक्‍माओ वये़ल्‍ले़ कुहुॽसाम्‍बाहाॽ पत्रुस, याकुब, युहुन्‍ना नु आन्‍द्रियासरे़ स्‍वाःत्ताङ् खुने़ॽ अक्‍खेलॽरिक् सेःन्‍मे़दोसु, ");
INSERT INTO lifNT2_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“सिक्‍साम्‍बे, कन् के़रे़क् पाःन्‍हाॽ आप्‍फाल्‍ले़ पोःङ्‌बाबे? कन् पोःङ्‌मानुःल्‍ले़ तगि थे मिक्‍सेःन् पोःङ्‌बे? याप्‍मि आमे़त्ते़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ, आत्तिल्‍ले़आङ् खिनिॽ इङ्‌गे़न्‍ले़क्‍तिन्‍लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","यरिक् मनाहाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌इङ्‌गाॽएरो लॽरिक् मे़बाःत्तुर आमिङ्‌ङो मे़दारो, हे़क्‍क्‍याङ् यरिक् मनाहाॽ इङ्‌मे़ले़क्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","हे़क्‍क्‍याङ् खिनिॽ थङ् नु थङ्‌हाॽरे़न् हयङ्‌किल्‍लिङ्‌हाॽ के़घे़प्‍सुम्, कर निङ्‌वाॽ मे़मये़म्‍मिन्‍ने़ॽओ॥ कङ्‌हाॽग पोःङ्‌माए पोःङ्, कर बा खे़न् ये़म्‍मोएग इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुनुप्‍मान् मे़दाने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","मे़न्‍छाम् सुवाङ्‌हाॽ नु लाजेॽहाॽ लुम्‍मो थङ् पोःक्, यरिक् लाजेॽओ लुप्‍लि थाङ्, हे़क्‍क्‍याङ् साक् पोःक्लो॥ कङ्‌ग के़दाःबार के़बप्‍पा किप्‍मा के़घुःबा तुक्‍खेहाॽरे़न् कुहेःक्‍सिङ्‌मारक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","खिनिॽग सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ॥ खिनिॽ याप्‍मि नसाःन् के़जोगिबाल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ के़म्‍दे़म्‍सिॽआङ् ये़जुम्‍भोहाॽओ के़म्‍देॽरिॽ, हे़क्‍क्‍याङ् यहुदि चुम्‍लुङ्‌हिम्‍मो ते़ःम्‍भुक् के़म्‍बिरिॽरो॥ कङ्‌ग सुहाङ्‌गे़म्‍बाहाॽ नु हाङ्‌हाॽरे़ खुनिॽ तगि आयाःम्‍बेओ पाःप्‍मा खिनिॽ के़घोःसुम्‍बा सुये़म्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","कर कुनुप्‍मा ये़म्‍मिन्‍नुःल्‍ले़ तगि काक् मे़न्‍छाम् सुवाङ्‌हाॽओ सुनाइङ् से़ःरए पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","हे़क्‍क्‍याङ् खिनिॽ के़म्‍दे़म्‍सिॽआङ् खासे़न्‍दे़न्‍नो खासे़न् लोःन्‍छे़ के़म्‍देॽरिल्‍ले़ से़ःप्‍सिङ्‌मारे़ लागि थे़मा पाःप्‍माबे फाॽआङ् तगिसा निङ्‌साम्‍मो मे़ध्‍ये़म्‍मिन्‍ने़ॽओ॥ खे़न् ये़म्‍मो पाःप्‍मा के़बोःङ्‌बा पाःन् सेसेमाङ्‌ङिल्‍ले़ के़बिरिॽरो, थेआङ्‌भे़ल्‍ले़ के़बाःप्‍पे़ङ्‌ग खिनिॽ मे़ःन्‍लो, कर सेसेमाङ्‌ङिन्‍नेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","फुॽनुसाॽहाॽ आबाङे फुॽनुसाॽहाॽरे़ खुनिॽ तक्‍ले़ङ्‌वाओ मे़बोःक्, हे़क्‍क्‍याङ् इङ्‌मे़ले़क्‍तुसिआङ्‌से़प्‍मा मे़बाङ्‌घुसिरो॥ हे़क्‍केलॽरिक् पा-माहाॽ साःहाॽरे़, हे़क्‍क्‍याङ् साःहाॽ पा-माहाॽरे़ खुनिॽ तक्‍ले़ङ्‌वाओ मे़बोःक्‍काङ् से़प्‍मा मे़बाङ्‌घुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","खिनिॽ याप्‍मि नसाःन् के़जोगिबाल्‍ले़ चोगुल्‍ले़ के़रे़क् मनाहाॽरे़ के़म्‍जिःत्तिॽ, कर आत्तिल्‍ले़ कुनुप्‍मो थारिक् थरुॽ, खे़ल्‍ले़ए से़न्‍लप् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","हे़क्‍क्‍याङ् सिक्‍के़ले़ःङ्‌बान् वाॽमा मे़न्‍नुॽमनाबा ते़न्‍नो ये़प्‍पा के़निःसुम्‍मिल्‍ले़ यहुदियाबा मनाहाॽ कोःक्‍मा फाङ्‌जङ् हे़ङ्‌घाःत्ति मे़घे़त्‍छिङ् मे़बेःक्‍लरो॥ कन् पाःन्‍निन् साप्‍ला के़निःप्‍पाहाॽरे़ कुसिङ् निःत्ते़म्‍मे़ॽओ! ");
INSERT INTO lifNT2_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","हे़क्‍क्‍याङ् खे़न् ये़म्‍मो हिम् सम्‍दाङ् के़वाॽबा मनाःन् चिगःक्‌वा लाःसे़ हिम् सिगाङ् मे़लाःत्‍ने़न्‍लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो के़वाॽबान् हाराॽ कुसुङ्‌घेःक्‌वा लाःसे़ कुहिम्‍मो मे़नुःङ्‌ने़न्‌मे़बेःक्‍ने़न्‍लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","18","खे़न् ये़न्‍हाॽग मे़न्‍छुक्‍मा के़वाॽमा नु सावामाहाॽरे़ लागि साॽरिक् किप्‍मा के़घुःबा पोःङ्‌लो! चुङ्‌वाःम्‍मा ये़म्‍मो खिनिॽ खे़त्‍छिङ्‌मा मे़बोःङ्‌ने़न्‍ल फाॽआङ् तुवा चोगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मान् नावागे़न् चइःत् ने़स्‍सुआङ्‌धो अक्‍तङ्‌बा किप्‍मा के़घुःबा तुक्‍खेःङ्‌ग आप्‍फाल्‍ले़आङ् मे़म्‍बोःङ्‌ङे वाॽ, हे़क्‍क्‍याङ् याम्‍मो आप्‍फाल्‍ले़आङ् मे़बोःङ्‌ने़ल्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","हे़क्‍क्‍याङ् दाङ्‌बाल्‍ले़ कन् ये़न्‍हाॽ ताङ्‌सा मे़जोगुन्‍निल्‍ले़ग आत्तिन्‍नाङ् हिङ्‌मा मे़सुक्‍ने़न्, कर खुने़ॽ सेगुसिबाहाॽ मे़हिङ्‌ल फाॽआङ् कन् ये़न्‍हाॽ ताङ्‌सा चोगुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","हे़क्‍क्‍याङ् खे़न् ये़म्‍मो मनाहाॽरे़, ओमे़त्ते़म्‍मे़ॽ, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌कप्‍मो वाॽ इग्र खुने़ॽ खे़प्‍मो वाॽरो लॽरिक् मे़बाःत्तुर मे़दाःल्‍ले़ नसाःन् मे़जोगे़म्‍सिम्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","थेआङ्‌भे़ल्‍ले़ इङ्‌ले़क्‍पा ख्रिस्‍तहाॽ नु इङ्‌ले़क्‍पा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ मे़लःन् मे़दाआङ् मिक्‍सेःन् नु निङ्‌वाॽ के़माबा पाःन्‍हाॽ मे़जोगुआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेगुसिबा मनाहाॽआङ् खुनिॽ सुक्‍सुक् इङ्‌मे़ले़क्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","हे़क्‍केःल्‍ले़ खिनिॽ सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ॥ कन् पाःन्‍हाॽ पोःङ्‌मानुःल्‍ले़ तगिए खिनिॽ मे़त्‍निङ्‌ङाङ् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“खे़न् किप्‍मा के़घुःबा तुक्‍खेःन् एगाङ् ‘नाम्‍मिल्‍ले़ ओःत्ति मे़बिरुन्‍नाङ्‌खामाक्‍लो, लाबाल्‍ले़ ओःत्ति मे़बिरुन्‍लो, ");
INSERT INTO lifNT2_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ताङ्‌साक्‍पोबा खेःम्‍सिक्‍पाहाॽ मक्मे़धाःरो, हे़क्‍क्‍याङ् ताङ्‌साक्‍पोबा मुक्‍साम्‍हाॽ मे़यङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","हे़क्‍क्‍याङ् मे़न्‍छाम्‍साःन् खाप्‍मिःत्तो यम्‍बा मुक्‍साम् हे़क्‍क्‍याङ् मिमिदिङ्‌ङिन्‍नु युःर पप्‍पा मे़न्‍छाम् याप्‍मिहाॽरे़ मे़निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","हे़क्‍क्‍याङ् खुने़ॽ सेगुसिबा मनाहाॽ सुम्‍से़ काक् पिसाङ्‌लाम् ताङ्‌साक्‍पाल्‍ले़ खोःप्‍तुबा नु इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ ताःक्‍तुबाओ कुमाङ्‌लाइङ्‌बाहाॽ इक्‍सादिङ् खाम्‍बेःक्‍मो पाङ्‌घु युःसुसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“आल्‍ल पःत्‍छेॽबुङ्‌मोलाम् कन् पाःन्‍निन् कुसिङ् निःत्ते़म्‍मे़ॽओ–खे़ल्‍ले़ कुबोराःक्‍हाॽलाम्‍बा कुनःक्‌लःम्‍मा हेःक्‍किल्‍ले़ हाङ्‌वाःम्‍मा ये़म्‍मिन् निःत्ताङ् त्‍ये़रो फाॽआङ् कुसिङ्‌के़निःत्तुम्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","हे़क्‍केलॽरिक्‍के इङ्‌गाॽ पाःत्तुङ्‌बा कन् काक् पाःन्‍हाॽ के़त्‍ल पेःक्‍पा के़निःसुम्‍मिल्‍ले़ मे़न्‍छाम्‍साःल्‍ले़ कुयुःमान् निःत्ताङ्‌ङे वाॽ फाॽआङ् कुसिङ्‌के़निःत्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, कन् के़रे़क् पाःन्‍हाॽ मे़म्‍बोःङ्‌ङे थारिक् कन् मे़न्‍छाम् थाःक्‍हाॽ मे़न्‍छिःने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ताङ्‌साक्‍पान् नु खाम्‍बेःक्‍मान् ले़क्‍काङ् पेःक्, कर इङ्‌गाॽ आबाःन्‍जाक्‍हाॽ आप्‍फाल्‍ले़आङ् मे़ले़क्‍ने़न् मे़बेःक्‍ने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“आल्‍ल खे़न् ये़म् नु ये़न्‍हाॽ आप्‍फाल्‍ले़ पोःङ् फाॽआङ् आत्तिल्‍ले़आङ् मे़निःसुन्॥ साङ्‌ग्राम्‍पेदाङ्‌बा माङ्‌लाइङ्‌बा नु निङ्‌वाॽफुसाःल्‍ले़आङ् मे़निःसुन्‍लो, कर पानुदिङ् पाःल्‍ले़रक् निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","हे़क्‍केःल्‍ले़ सिङ्‌सिङ् ये़क्‌ये़क् लॽरे़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ कन् ये़न्‍निन् आप्‍फाल्‍ले़ ताः फाॽआङ् खिनिॽ के़न्‍निःसुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","कन् पाःन्‍निङ्‌ग थिक् माःङ्‌घा लाम्‍दिःक् चोःक्‍से़ के़बेःक्‍पा मना कुइसिःक् चोःक्‍लो॥ खे़ल्‍ले़ काक् कुसेवारोबाहाॽ खुनिॽ चोःक्‍मा के़बोःङ्‌बा याःम्‍बक्‍हाॽ ओसेःन्‍धाक्‍तुसिआङ् कुहिम्‍धाःङ्‌हाॽ खुनिॽ हुक्‍को पिरुसिॽ, हे़क्‍क्‍याङ् थिक् हिम् के़गोःबा सेवारोबान् हिम् कोमा पाङ्‌घुआङ् खुने़ॽ लाम्‍दिःक्‍को पेःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","हे़क्‍केलॽरिक् खिनिॽआङ् आप्‍फाल्‍ले़साङ् यारिप् पोःक्‍खे़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ हिम्‍दाङ्‌बान् युःन्‍छिक् ताबि, से़त्‍लुम्‍भक्‍किल्‍ले़ ताःबि, इङ्‌वा काःल्‍ले़ ताबि इ खाओःत्तिल्‍ले़ ताःबि? आप्‍फाल्‍ले़ नुःङ् ताः के़लॽबान् खिनिॽ के़न्‍निःसुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","खुने़ॽ हक्‍चघत् ताःल्‍ले़ खिनिॽ के़इप्‍सिआङ् के़ने़स्‍सिबा के़न्‍दुमिन्‍निरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","खे़ल्‍ले़ चोगुल्‍ले़, खिनिॽ मे़त्‍निङ्‌बा हे़क्‍केए के़रे़क् मनाहाॽ सिङ्‌सिङ् लॽरे़म्‍मे़ॽ फाॽआङ् मे़त्तुङ्‌सिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","आल्‍ल यहुदि चोःक्‌युम्‍भो तङ्‌नाम् नु सिदाॽ मे़म्‍भःन्‍नेबा खरे़ःङ् चामा ये़न् ताःमा निये़न्‍लक् वये़॥ तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ ये़सुःन् आक्‍खेलॽरिक् स्‍वाःत्ताङ् ते़म्‍माआङ् से़प्‍माबे फाॽआङ् लाम् मे़गोःत्तुर मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","कर खे़ङ्‌हाॽरे़ मे़बाःत्तु, “कन् तङ्‌नाम्‍मोग आनिॽ हे़क्‍के चोःक्‍मा मे़नुॽने़न्‍लो, मे़ःन्‍ने़ फाॽग्र कन् मनाहाॽरे़ हयङ्‌किल्‍लिङ् मे़जोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","खे़न् ये़म्‍मो ये़सुःन् बे़थानि पाङ्‌भेॽओ लोगेॽ तुक्‍मालाम् के़वेःप्‍पा सिमोनरे़ कुहिम्‍मो वये़रो॥ हे़क्‍क्‍याङ् चाजानु युङे़ल्‍ले़ मे़न्‍छुमाॽधिक् इमे़ल्‍लुङ्‌बा पाङ्‌बोःक् फुङ्‌नाम्‌निःङ्‌गेॽ के़याक्‍पा ले़म्‍भालुङ् पर्यामानु त्‍ये़आङ् पर्यामाल्‍ले़ कुसुःप्‍मे़न् फुन्‍दुआङ् खे़न् फुङ्‌नाम्‍मिन्‌ये़सुरे़ कुधे़गेःक्‍पो हुक्‍खुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","कर खे़ॽयो के़वाॽबा कुभा मनाहाॽरे़ साॽरिक् खुनिॽ सिक् पोगे़आङ् अक्‍खे मे़मे़त्‍छिङ्, “कन् थेआङ् चासोःक्‌पाङ्‌मनाबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","कङ्‌ग किप्‌सुम्‍सि (३००) युप्‍पायाङ्‌ङो सङ्‌माआङ् खे़न् याङ्‌ङिन् याङ्‌गे़साॽबाहाॽ पिमनासिल्‍ले़ पोःक्‍खे़बा॥” हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खे़न् मे़न्‍छुमाॽइन् मे़भे़ःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “थेआङ् खे़न् के़भे़ःक्‍तुम्‍बाबे? खे़न् तुक्‍खे मे़जाःत्ते़म्‍मिन्‍ने़ॽओ! खे़ल्‍ले़ग आलागि नुःबा चोगुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","याङ्‌गे़साॽबाहाॽग खिनिॽनुए सदादिङ् मे़वाॽरो॥ हे़क्‍क्‍याङ् आप्‍फाल्‍ले़साङ् कम्‍ब्राङ् मे़प्‍मा के़सुक्‍तुम्‍सिम्‍लो, कर इङ्‌गाॽग सदादिङ् खिनिॽनु मे़वाॽआन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","खे़ल्‍ले़ इङ्‌गाॽ नासिङ्‌गे़न् आधक्‍किन् लुप्‍मारे़ लागि तगिए आधे़गेःक्‍पो फुङ्‌नाम्‌हुःत्तुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, इक्‍सादिङ् खाम्‍बेःक्‍मो आत्तिसाङ् सुनाइङ् इङ्‌भोःल्‍ले़, खे़प्‍मो कन् मे़न्‍छुमाॽइल्‍ले़ चोगुबा कुयाःम्‍बक्‍किन् मनाहाॽरे़ मे़जे़क्‍खुआङ् निङ्‌वाॽ मे़इःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","हे़क्‍क्‍याङ् थिक्-ने़त् कुहुॽसाम्‍बाहाॽओ यहुदा इस्‍करियोत मे़प्‍मनाबे़न् तुम्निङ्‌वाॽफुसाम्‍बाहाॽरो ये़सुःन् इङ्‌ले़क्‍तुङ् फाॽआङ् पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","खे़ङ्‌हाॽरे़ कन् पाःन्‍निन् मे़घे़प्‍सुआङ् साॽरिक् मे़सःत्ते़र यहुदाःन् याङ् पिआसिगे़ फाॽआङ् माङ्‌मे़हे़क्‍तु॥ खे़न् ये़म्‍माङ्धो यहुदाःल्‍ले़ ये़सुःन् इङ्‌ले़क्‍मा फाॽआङ् सुये़म् कोःप्‍मा हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","हे़क्‍क्‍याङ् सिदाॽ मे़न्‍भःन्‍नेबा खरे़ःङ् चामा तङ्‌नाम्‍मिल्‍ले़ थिक्‍सिगेःक्‍पा ये़न्‍नो चोःक्‌युम्‍भो तङ्‌नाम्‍मिल्‍ले़न्‌मे़ल्‍लुक्‍साःन् सिदुङ्‌जभा चोःक्‍मा थिम् वये़॥ ये़सुरे़ कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ सेःन्‍मे़दोसु, “आदाङ्‌बे, आनिॽ आत्तो पेःक्‍माआङ् यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मिल्‍ले़न्‌साभाङ्‌जाःन्‌यारिप् चोःक्‍मा के़लॽबा निङ्‌वाॽ के़गत्तुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","14","हे़क्‍केःल्‍ले़ ये़सुरे़ ने़प्‍फु कुहुॽसाम्‍बाहाॽ अक्‍खे मे़त्तुसिर यरुसले़म्‍मो पाङ्‌घुसि, “खिन्‍छिॽ ये़क्‌यक्‍को के़लाःत्‍छिर के़बत्‍छिल्‍ले़ च्‍वाःत् कुःन्‍दा के़बङ्‌बा मनाधिक्‍ले़ के़दुम्‍सिॽ॥ खे़न् लाःप्‍पा हिम्‍मो थारिक् तिम्‍दे़त्‍छे़ॽ॥ हे़क्‍क्‍याङ् हिम्‍दाङ्‌बान् मे़त्ते़त्‍छे़ॽ, ‘आनिगे़ सिक्‍साम्‍बाल्‍ले़ खे़ने़ॽ अक्‍खे के़मे़त्ते़आङ् के़वाॽरो, तरे युङ्‌मा याक्‍फाङ्‌ङिन् आत्तो ने़बे? खे़प्‍मो इङ्‌गाॽ आहुॽसाम्‍बाहाॽनु यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मिल्‍ले़न्‌साभाङ्‌जाःन्‌चाङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","हे़क्‍क्‍याङ् खे़ल्‍ले़ खिन्‍छिॽ थोःस्‍मा खाम्‍लोओ यारिप् चोःक्‍मनाबा लत्‍छा यम्‍बा याक्‍फाङ्‌ङिन् ओसेःन्‍गे़धाक्‍सिॽ॥ खे़प्‍मोए आनिॽ साभाङ्‌जाःन्‌यारिप् चोगे़त्‍छे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","हे़क्‍क्‍याङ् खे़न् ने़प्‍फु कुहुॽसाम्‍बाहाॽ पेगे़त्‍छिल्‍ले़ ये़सुरे़ पाःत्तुबा हे़क्‍केए तुमे़त्‍छुआङ् खे़ङ्‌हाॽरे़ यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मिल्‍ले़न्‌साभाङ्‌जाःन्‌यारिप् चोगे़त्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","खे़न् युःन्‍छिक् ये़सुःन् नु थिक्-ने़त् कुहुॽसाम्‍बाहाॽ खे़प्‍मो मे़द्‌ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ चामा ते़न्‍नो मे़जर मे़युङे़ल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ अक्‍खे मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, इङ्‌गाॽनु के़जाबार के़युङ्‌बा खिनिॽओ थिक्‍किल्‍ले़ इङ्‌गाॽ इङ्‌ले़क्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽ साॽरिक् निङ्‌साम्‍मो मे़ध्‍ये़आङ्‌के़रे़क्‍ले़ खुने़ॽ सेःन्‍दोःमा मे़हेःक्‍तु, “दाङ्‌बे, के़बाःत्तुबा मनाःन् इङ्‌गाॽआबि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ थिक्-ने़त्तो आल्‍लो इङ्‌गाॽनु सोरिक् के़जाबार के़युङ्‌बाधिक्‍किल्‍ले़ इङ्‌गाॽ इङ्‌ले़क्‍कारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","मे़न्‍छाम्‍साःङ्‌ग साम्‌योसाप्‍लाओ साप्‍ते़बा कुइसिःक्‍के सिःमाए पोःङ्‌लो॥ कर मे़न्‍छाम्‍साःन् इङ्‌गे़ले़क्‍पे़ङ्‌ग चिःत्ते़ स्‍ये़रो! खे़ङ्‌ग सामे़वाःन्‍छिङ्‌ङिन्‍निल्‍ले़ए नुरे़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","खे़ङ्‌हाॽरे़ मे़जर मे़युङे़ल्‍ले़ ये़सुरे़ खरे़ःङ्‌ङिन् खप्‍सुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरु, हे़क्‍क्‍याङ् खे़ःक्‍खुआङ् कुहुॽसाम्‍बाहाॽ पिरुसिर अक्‍खे मे़त्तुसि, “कन् ताःक्‍ते़म्‍मे़ॽओ, कन् इङ्‌गाॽ नासिङ्‌गे़न् आधक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","हे़क्‍क्‍याङ् चल्‍लङ्‌ना खोर्याःन् पक्‍खुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरु, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ पिरुसिआङ् के़रे़क्‍ले़ मे़धुङुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो मे़त्तुसि, “कन् निङ्‌वाॽफुमाङ्‌ङिन्‍नु चोःक्‍मनाबा कुसङ् माङ्‌हुप्‍ले़न्‌आमाक्‍खिॽरो॥ कन् यरिक् मनाहाॽरे़ खुनिॽ लायोःन् वाहप्‍मा फाॽआङ् वादेःन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आइन्‍नाङ्‌धो निङ्‌वाॽफुहाङ्‌जुम्‍मो कुसङ् चे़ल्‍ले़क्‍सेॽ थिःन् मे़न्‍धुङ्‌ङे थारिक् याम्‍मो चे़ल्‍ले़क्‍सेॽ थिःन् मे़धुङ्‌ङान्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ माङ्‌सेवा साम्‍लोधिक् साम्‍मे़लोःरे़आङ् जैतुन कोःक्‍माओ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","खे़प्‍मो ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ के़रे़क्‍ले़ इङ्‌गाॽ याप्‍मि के़ले़रिॽआङ् के़बिगिॽ, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ साम्‌योसाप्‍लाओ अक्‍खे पाःत्तुआङ् पत्, ‘इङ्‌गाॽ मे़ल्‍लुक्‍कम्‍बान् हिप्‍तुङ्, हे़क्‍क्‍याङ् के़रे़क् मे़ल्‍लुक्‍हाॽ के़रे़क् पिसाङ् मे़से़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","कर इङ्‌गाॽ सिःमे़न्‍लाम्‌याम्‍मो हिङ्‌ङाआङ् खिनिॽनुःल्‍ले़ तगि गालिल थुम्‍मो पेःक्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","पत्रुसरे़ ये़सुःन् मे़त्तु, “के़रे़क्‍ले़ खे़ने़ॽ के़म्‍ले़त् के़म्‍धाःसाङ् इङ्‌गाॽग आप्‍फाल्‍ले़आङ् मे़ले़त्‍ने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ये़सुरे़ खे़न् मे़त्तु, “इङ्‌गाॽ से़क्‍खाए मे़त्‍ने़ॽ, आक्‍खो से़न्‍दिक् निले़ङ् इङ्‌वा काःमानुःल्‍ले़ तगिए, खुने़ॽ कुसिङ्‌मे़निःत्तुङ्‌ङिन् के़बाःत्तुर खे़ने़ॽ सुम्‍ले़ङ् के़नाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","कर पत्रुसरे़ हादिङ् थक्‍ते़र मे़त्तु, “मे़ःन्‍लो, इङ्‌गाॽग खे़ने़ॽनु सिःमा पोःङ्‌साङ् आप्‍फाल्‍ले़आङ् मे़नाॽने़न्‍लो॥” वेॽ हुॽसाम्‍बाहाॽरे़आङ् बा हे़क्‍केए मे़बाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ गे़तसमनि मे़प्‍मनाबा जैतुन सिङ्‌लाओ मे़बे॥ ये़सुरे़ कुहुॽसाम्‍बाहाॽ अक्‍खे मे़त्तुसि, “तुवा चोगुङ्‌ङिल्‍ले़ खिनिॽ कप्‍मो युङे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","हे़क्‍क्‍याङ् खुने़ॽ पत्रुस, याकुब, नु युहुन्‍नासि तेॽरुसि॥ खुने़ॽ साॽरिक् कुनिङ्‌वाॽ तुगे़आङ् निङ्‌साम्‍मो थ्‍ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽग मिङ्‌वारे़ योःन्‍दाङ्‌ङाङ् सिःमालिङ्‌धो थारिक् के़राङ्‌ङाङ् वाॽआरो॥ खिनिॽ कप्‍मो चाङ्‌जाङ्‌ङाङ् युङे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","खुने़ॽ मिसाक् नानाक् पेआङ् साम्‍बोःन् फन्‍छिङ्‌ल तुवा चोगु, “पोःङ्‌ने़ फाॽग्र कन् इनोगे़न् तुक्‍खेःन् आसम्‍दाङ् मे़दाने़न्‍ल॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","पानुदिङ् आम्‍बौ, खे़ने़ॽ के़लागिग काक् पोःङ्‌मा सुक्॥ कन् इनोगे़न् तुक्‍खेरे़न् खोर्याःन् इङ्‌गाॽओलाम् खे़त्ते़देःसे़ॽओ, कर हे़क्‍केसाङ् आनिङ्‌वाॽ हे़क्‍केग मे़ःन्, कर के़निङ्‌वाॽ हे़क्‍केए पोःङ्‌लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","हे़क्‍क्‍याङ् खुने़ॽ नुःक्‍खे़ल्‍ले़ खे़न् सुम्‍ब्राङ् कुहुॽसाम्‍बाहाॽग मे़इप्‍से़आङ् मे़ने़स्‍से़बा तुमुसि॥ हे़क्‍क्‍याङ् पत्रुसे़न् मे़त्तु, “सिमोने, थेआङ् के़इप्‍से़बा? कुमुक्‍थिक्‍काङ् चाङ्‌जाङ्‌ङाङ् युङ्‌मा के़न्‍छुक्‍तुन्बि? ");
INSERT INTO lifNT2_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","हङ्‌साॽमाओ मे़ध्‍ये़ॽइगे़न्‍ल फाॽआङ् निङ्‌वाॽ चाङ्‌जाङ्‌ङाङ् तुवा चोगे़म्‍मे़ॽओ॥ खिनिॽ निङ्‌वाॽइल्‍ले़ नुःरिक्‍काङ् चोःक्‍मा के़गोःत्तुम्, कर खिनिॽ नासिङ्‌गे़न् थक्‍किङ्‌ग मे़धुम्‍मिन्‍बाल्‍ले़ चोगुल्‍ले़ के़न्‍छुक्‍तुम्‍मिल्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","याम्‍मो खुने़ॽ पेआङ् आन्‍दे़ःन् हे़क्‍के पाःत्तुर तुवा चोगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","खुने़ॽ नुःक्‍खे़ फे़रे़ल्‍ले़ याम्‍मो कुहुॽसाम्‍बाहाॽ मे़इप्‍से़आङ् मे़ने़स्‍से़बा तुमुसि, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ मिक्‌युःमाल्‍ले़ साॽरिक् तरुसिआङ् मे़वये़॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ आक्‍खे पाःप्‍माबे फाॽआङ् थेआङ् निङ्‌वाॽ मे़ङ्‌गत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","हे़क्‍क्‍याङ् खुने़ॽ सुम्‍ले़ङ्‌ङो नुःक्‍खे़ फे़रे़आङ् कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “खिनिॽ आल्‍लसाङ् के़नासिआङ् के़इप्‍सिआङ् के़ने़स्‍सिबि? आल्‍ल पोःक्‍खे़रो! ओमे़त्ते़म्‍मे़ॽ, इङ्‌गाॽ मे़न्‍छाम्‍साःन् लायोबाहाॽरे़ खुनिॽ हुक्‍को थाःमा ये़म्‍मिन् त्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","पोगे़म्‍मे़ॽ, कप्‍मोलाम् पिगि! ओमे़त्ते़म्‍मे़ॽ, इङ्‌गाॽ याप्‍मि इङ्‌गे़ले़क्‍पे़न्‌खा फे़न्‍ल पत्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","हे़क्‍केलॽरिक् खुने़ॽ पारे़र पत्‍छे़ल्‍ले़सा थिक्-ने़त् कुहुॽसाम्‍बाहाॽओबा यहुदा मे़प्‍मनाबे़न् खे़प्‍मो के़रे़ त्‍ये़॥ खुने़ॽनु तुम्निङ्‌वाॽफुसाम्‍बाहाॽ, साम्‌योथिम्‍साम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽरे़ मे़बाङ्‌घुसिबा ताभे नु तक्‍काःत् के़गप्‍पा यरिक् मनाहाॽआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","आल्‍ल ये़सुःन् इङ्‌गे़ले़क्‍पे़ल्‍ले़ आत्तिन् मनाःन् इङ्‌गाॽ चुप् मे़त्तुङ्, खे़न् ते़म्‍से़म्‍मे़ॽआङ् तेॽरे़म्‍मे़ॽ लॽरिक् मिक्‍सेःन् पिरुसिआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","यहुदाःन् के़रे़नुमे़ःन्‍ने ये़सुरो पेआङ् “सिक्‍साम्‍बे” मे़त्तुर चुप् मे़त्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","हे़क्‍क्‍याङ् वेॽ मनाहाॽरे़ ये़सुःन् हुक् मे़याक्‍तुआङ्‌मे़दे़म्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","खे़प्‍मो के़ये़प्‍पाहाॽओ थिक्‍किल्‍ले़ ताभेःन् तरप् फिःक्‍खुआङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुसेवारोबान् चे़प्‍तुल्‍ले़ कुने़क्‍खोॽबान् पे़त्तु थाःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ हाङ्‌बिफ्‍युङ् के़जोःक्‍पाआबि? थेआङ् इङ्‌गाॽ आदे़म्‍से़ ताभे हे़क्‍क्‍याङ् तक्‍काःत्‍नु के़द्‌ये़ॽइबे? ");
INSERT INTO lifNT2_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","इङ्‌गाॽग थिक्‌याःन्‍धक्‍सा माङ्‌हिम् लक्‍खुम्‍मो निसाम् हुॽइसे़ वयाङ्‌बा हे़क्‍केसाङ् याप्‍मि के़न्‍दे़म्‍सिन्, कर साम्‌योसाप्‍लाओ के़बप्‍पे़न्‌के़त्‍ल फाॽआङ् अक्‍खे पोःक्‍खे़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","हे़क्‍क्‍याङ् के़रे़क् कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ पक्‍मे़धःआङ् मे़घे़त्‍छिङ् मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","खे़प्‍मो थिक् नालिङ्‌गे़न् थाङ्‌बे़न्‍निल्‍ले़ सुङ्‌घेःक्‌वाःन् हे़म्‍सिङ्‌ङे़आङ् ये़सुरे़ कुएःक् कुएःक् तिःक्‍तुर वये़॥ खे़न् मनासुम्‍हाॽरे़ खे़न् ते़म्‍मा मे़गोःत्तुल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","सुङ्‌घेःक्‌वाःन् पक्‍थःआङ् ले़क्‍चाबे़धिःक् लोःक्‍ते़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ये़सुःन् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुहिम्‍मो मे़देॽरु॥ खे़प्‍मो तुम्निङ्‌वाॽफुसाम्‍बाहाॽ, यहुदि तुम्‍लाम्‍लोःबाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ मे़जुप्‍से़आङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","पत्रुसे़ल्‍ले़आङ् माःङ्‌घालाम् ये़सुःन् तिम्‍दुर मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुलक्‍खुम्‍मो थारिक् के़रे़॥ खे़प्‍मो सेवारोबाहाॽनु मिजाॽनु युङे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","आल्‍ल तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि ये़जुम्‍भोरे़न् काक् पासिङ्‌पादाङ्‌लाहाॽरे़ ये़सुःन् सिःमे़ल्‍ले़न् खुम्‍दिङ् पिमा फाॽआङ् खुने़ॽ कुदक्‍ले़ङ्‌वाओ फोत्‍याबा आप्‍तिक्‍हाॽ मे़गोःत्तु, कर थेआङ् मे़ङ्‌घोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","यरिक् फोत्‍याबा आप्‍तिक् के़गुःप्‍पाहाॽ ये़सुरे़ कुदक्‍ले़ङ्‌वाओ मे़बारे़, कर खुनिॽ पाःन् मे़दङे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","हे़क्‍क्‍याङ् कुभा मनाहाॽरे़ मे़बोगे़आङ् ये़सुरे़ कुदक्‍ले़ङ्‌वाओ अक्‍खेलॽरिक् इङ्‌ले़क् पाःन् मे़बाःत्तु, ");
INSERT INTO lifNT2_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“आनिगे़ ये़सुरे़ अक्‍खे पाःत्तुबा खे़प्‍सुम्‍बे़रो, ‘कन् मनाहाॽरे़ मे़जोगुबा माङ्‌हिम्‍मिन् यस्‍सुङ्‌ङाङ् सुम्‌ये़न् एगाङ्, मनाहाॽरे़ मे़म्‍भाॽए, वेॽ माङ्‌हिम्‍मिन् चोगुङ्‌लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","हे़क्‍केसाङ् खे़ङ्‌हाॽरे़ ये़सुरे़ कुमे़न्‍नो इङ्‌ले़क् मे़बाःत्तुबा पाःन्‍निन् मे़दङे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","हे़क्‍केःल्‍ले़ मानिङ्‌वाॽफुसाम्‍बान् के़रे़क्‍ले़ खुनिॽ तगि पोगे़आङ् ये़सुःन् सेःन्‍दोसु, “कन् मनाहाॽरे़ के़दक्‍ले़ङ्‌वाओ पिरे़त्‍छुबा तोःन्‍दिल्‍ले़ कुयाःम्‍बेओ थेआङ् खे़ने़ॽ नोगप् के़म्‍बिरुन्‍छिन्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","कर ये़सुरे़ थेआङ् नोगप् मे़म्‍बिसिङ्‌ङे स्‍वाःत् ये़बे़॥ याम्‍मो मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ सेःन्‍दोसु, “खे़ने़ॽ मुॽइसाम्‍दाङ्‌बा निङ्‌वाॽफुसाः ख्रिस्‍तने़बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “ओरो, इङ्‌गाॽआरो! कर इङ्‌गाॽ मे़त्‍निङ्, इङ्‌गाॽ मे़न्‍छाम्‍साःन् मुक्‍साम्‍दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुजुप्‍साङ् ले़प्‍माङ् युङ्‌ङाबा नु साङ्‌ग्राम्‍पेदाङ्‌ङोनु खाप्‍मिःत्तो युःआबा के़निःसुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","हे़क्‍क्‍याङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुसाक्‍के़न् ओसेःन्‍धाक्‍तुसिर आबाङे कुदेःत्तिन् थे़ःक्‍खुआङ्‌अक्‍खे पाःत्तु, “आल्‍ल आनिॽ वेॽ तोःन्‍दिहाॽ थेआङ् चाहाबा आजोगे़बे? ");
INSERT INTO lifNT2_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","कल्‍ले़ग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पाःन्‌पाःत्तुबान् खिनिॽ के़घे़प्‍सुम्‍लो॥ आल्‍ल थे़मा के़इःत्तुम्‍बे?” खे़प्‍मो के़वाॽबा मनाहाॽरे़ खुने़ॽ सिःमे़ल्‍ले़ खुम्‍दिङ् खोःमाए पोःङ् फाॽआङ् मे़मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","हे़क्‍क्‍याङ् कुभारे़ खुने़ॽ थ्‍याःत् मे़धोःक्‍खुआङ् कुभारे़ कुमिक्‍के़न् मे़दे़प्‍तुआङ् खुनिॽ हुक्‍पुत्तिल्‍ले़ मे़लक्‍तुर “माङ्‌निङ्‌वाॽपाःन् पारे़ॽ, हाःत्‍ले़ के़हिप्‍ते़बे?” मे़मे़त्तु॥ हे़क्‍क्‍याङ् खुने़ॽ के़गोःबा थक्‍सुबाहाॽरे़ मे़देॽरुआङ् मे़हिप्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","पत्रुसे़न् यो लक्‍खुम्‍मो वये़ल्‍ले़ मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुसेवारोमा चुक्‍माधिक् खे़प्‍मो त्‍ये़आङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","पत्रुसे़न् मिजाॽनु युङे़बा निःसुआङ् कुबेसाङ् पेआङ् नुःरिक् ओमे़त्तुर मे़त्तु, “खे़ने़ॽग नासरि ये़सुःन्‍नु के़वये़ मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","कर पत्रुसरे़ खे़न् नाॽरुर मे़त्तु, “इङ्‌गाॽ खुने़ॽ कुसिङ्‌मे़निःत्तुङ्‌ङिन्‍लो! खे़ने़ॽ थे के़बाःत्तुबा इ?” हे़क्‍क्‍याङ् खुने़ॽ लाःक्‍कात् पेःक्‍मा लाम्‍धेःप् ले़प्‍माङ् चत्‍छिङ्‌॥ हे़क्‍क्‍याङ् बा खे़न् ये़म्‍मो इङ्‌वा काःसे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","हे़क्‍क्‍याङ् खे़न् सेवारोमा चुक्‍मे़न् याम्‍मो त्‍ये़आङ् खे़प्‍मो पत्रुसे़न् निःसुआङ् कुघिरि के़ये़प्‍पा मनाहाॽ मे़त्तुसि, “कन् मनाःङ्‌ग ये़सुरे़ कुहुॽसाम्‍बाहाॽओ थिक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","कर पत्रुसरे़ याम्‍मो नाॽरु॥ याङ्‌सि खे़प्‍मो के़वाॽबा मनाहाॽरे़ खुने़ॽ मे़निःसुआङ् मे़मे़त्तु, “से़क्‍खासाङ् खे़ङ्‌हाॽओ खे़ने़ॽ थिक्‍ने़रो, थेआङ्‌भे़ल्‍ले़ खे़ने़ॽआङ् गालिललाम् के़द्‌ये़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","हे़क्‍केःल्‍ले़ पत्रुसरे़ माङ्‌हे़क्‍सिङ्‌ल अक्‍खे मे़त्तुसि, “कन् मनाःन् हाःत् इ फाॽआङ् मे़निःसुङ्‌ङिन्‍लो! खिनिॽ थे़मा के़बाःत्तुम्‍बा इ?” ");
INSERT INTO lifNT2_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","खिमो इङ्‌वाःन् निसिगेःक् ले़ङ् काःसे़रो॥ हे़क्‍क्‍याङ् पत्रुसरे़ “निले़ङ् इङ्‌वा काःमानुःल्‍ले़ तगि खे़ने़ॽ सुम्‍ले़ङ् के़नाॽआरो” फाॽआङ् ये़सुरे़ मे़त्तुबा पाःन्‍निन् निङ्‌वाॽ इःत्तुआङ् साॽरिक् हाबे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","कुनाम्‍दाःप्‍मा खाओःत्ते़र पत्‍छे़ल्‍ले़सा तुम्निङ्‌वाॽफुसाम्‍बाहाॽ, यहुदि तुम्‍लाम्‍लोःबाहाॽ, साम्‌योथिम्‍साम्‍बाहाॽ नु काक् यक्‍चुम्‍भोबा मनाहाॽ चुम्‍लुङ् मे़जोगे़॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ये़सुःन् इमे़घेःक्‍खु हे़क्‍क्‍याङ् रोमि सुहाङ्‌गे़म्‍बा पिलातसरो मे़देॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","पिलातसरे़ ये़सुःन् अक्‍खे मे़त्तुर सेःन्‍दोसु, “से़क्‍खा खे़ने़ॽ यहुदि हाङ्‌ने़बि?” ये़सुरे़ नोगप् पिरु, “खे़ङ्‌ग खे़ने़ॽए के़बाःत्तुर के़बत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ ये़सुःन् यरिक् पाःन्‍नो आप्‍तिक् मे़गुःत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","हे़क्‍केःल्‍ले़ पिलातसरे़ याम्‍मो सेःन्‍दोसु, “ओमे़त्ते़ॽ, कम्‍म्‍याक् यरिक् आप्‍तिक् के़म्‍गुःत्ते़आङ् वाॽरो॥ खे़ने़ॽ थेआङ् के़म्‍बाःत्‍ने़न्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","कर ये़सुरे़ थेआङ् नोगप् मे़बिरुन्‍निल्‍ले़ पिलातसरे़ कुनिङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","आल्‍ल यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मो लत्‍छा साक्‍पा के़धाःबा मनाःन् मनाहाॽरे़ ले़रे़ आबिरे़ॽ फाॽआङ् पेलि मे़भाक्‍तुल्‍ले़ सुहाङ्‌गे़म्‍बाल्‍ले़ ले़प्‍मा थिम् कत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","खे़न् ये़म्‍मो बरब्‍बास मे़प्‍मनाबा साक्‍पा के़धाःबाधिक् वये़॥ खे़ल्‍ले़ हाङ्‌बिफ्‍युङ् पोःक्‍खे़ल्‍ले़ हयङ्‌ते़ङ्‌धङ्‌ङो वेॽ मनाहाॽनु तङ्‌सिङ्‌ङाङ् यरिक् मनाहाॽ से़रुसिआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","हे़क्‍क्‍याङ् यरिक् मनाहाॽ पिलातसरो मे़द्‌ये़आङ् सदादिङ् के़जोगुबा हे़क्‍के चोगे़ आबिरे़ॽ फाॽआङ् पेलि मे़भाक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","पिलातसरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “यहुदि हाङ्‌ङिन् ले़रुङ् पिनिङ्‌बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","थेआङ्‌भे़ल्‍ले़ तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ ये़सुःन्‌नामे़हे़त्तुआङ् खुने़ॽओ हुक्‍मे़सुप्‍तुबा पाःन्‍निन् कुसिङ्‌निःत्तुआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","कर तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ मनाहाॽ ये़सुरे़ कुले़क्‌वाओ बरब्‍बासे़न्‍ने ले़रे़ आबिरे़ॽओ फाॽआङ् मे़हुसुसिआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","पिलातसरे़ खे़ङ्‌हाॽ याम्‍मो सेःन्‍दोसुसि, “यहुदि हाङ् के़मे़त्तुम्‍बा मनाःन् इङ्‌गाॽ थे मे़त्तुङ्‌बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","कर खे़ङ्‌हाॽ याम्‍मो मे़अःक्‍ते़, “खे़न् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःम्‍माए पोःङ्॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","पिलातसरे़ याम्‍मो मे़त्तुसि, “थेआङ्बे? खे़ल्‍ले़ थे याःम्‍बक् फेःन्‍दुआङ् वाॽबे?” कर खे़ङ्‌हाॽ आल्‍लसाङ् साॽरिक् मे़अःक्‍ते़, “खे़न् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःन्‍दे़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","पिलातसरे़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ ताःमा पिमासि फाॽआङ् बरब्‍बासे़न ले़रु पिरुसि, कर ये़सुःन् ते़ःम्‍भुक् याक् पाङ्‌घुसिआङ् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःम्‍मा फाॽआङ् रोमि थक्‍सुबाहाॽ हुक्‍सुप्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","हे़क्‍क्‍याङ् सुहाङ्‌गे़म्‍बाल्‍ले़ कुधक्‍सुबाहाॽरे़ ये़सुःन् खुनिॽ तुरा यक्‍को मे़देॽरुआङ् खे़प्‍मो तुराबा काक् थक्‍सुबाहाॽ कुघिरि मे़जुप्‍से़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","हे़क्‍क्‍याङ् खुने़ॽ कुदेःत्तिन् मे़भे़न्‍दु मे़बिरुआङ् परान्‍ला हाङ्‌देःत्तिन् मे़जाक्‍तु, तिङ्‌ग्रेःक् तिचः मे़भयुआङ् मे़घुःक्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","हे़क्‍क्‍याङ् खुने़ॽ “यहुदि हाङ्‌ङे, तियाहा!” मे़मे़त्तुर सेवा मे़मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","हे़क्‍क्‍याङ् ए़त्‍ले़ङ् तक्‍काःत्तिल्‍ले़ कुधे़गेःक्‍पे़न्‌मे़घाक्‍खुर, थ्‍याःत् मे़धोःक्‍खु, हे़क्‍क्‍याङ् खुने़ॽ कुदगि मे़बेआङ् थुङ्‌बोहजॽ मे़युङ्‌सिङ्‌ल सेवा मे़मे़त्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","अक्‍खेलॽरिक् किनाःन्‍दि मे़बिरु मे़सुरुआङ् खे़न् परान्‍ला तेःत्तिन् मे़भे़न्‍दुआङ् कुदेःत्तिन् मे़जाक्‍तु॥ हे़क्‍क्‍याङ् खे़न् थक्‍सुबाहाॽरे़ खुने़ॽ सिलाम्‍साक्‍मा सिङ्‌ङो फोःन्‍छे़ मे़देॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","खे़न् ये़म्‍मो अले़क्‍जे़न्‍दर नु रुफसरे़ खुन्‍छिॽ पाः सिमोन मे़प्‍मनाबा साइरेनि ये़क्‌यक्‍को के़युङ्‌बे़न् पाङ्‌भेॽलाम् फे़रे़र पत्‍छे़बा थक्‍सुबाहाॽरे़ मे़दुमुआङ् ये़सुरे़ कुसिलाम्‍साक्‍मा सिङ्‌ङिन् साक्‍के़ल्‍ले़क् पङ्‌मा मे़बाङ्‌घु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","खे़ङ्‌हाॽरे़ गलगथा मे़प्‍मनाबा कोःक्‍माओ मे़देॽरु (गलगथा फाॽइङ्‌ग मिक्‍खोःक्‍पा पोःङ्‌लो)॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","हे़क्‍क्‍याङ् मुर्र मे़प्‍मनाबा सिदाॽ फुप्‍मनाबा चे़क्‍ले़क्‍सेॽ थिःन् मे़धुङ्‌घु, कर ये़सुरे़ मे़धुङुन्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","हे़क्‍क्‍याङ् खुने़ॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् मे़भोःन्‍दु, हे़क्‍क्‍याङ् कुदेःत्‍हाॽ हाःत्‍छिङ्‌मा फाॽआङ् खे़ङ्‌हाॽरे़ तॽयाःन्‍सोःन् मे़गे़सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","खे़ङ्‌हाॽरे़ खुने़ॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् मे़भोःन्‍दुल्‍ले़ तानाम्‍बा कुमुक् फाङ्‌सि (९) मुक्‍ते़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","हे़क्‍क्‍याङ् ये़सुरे़ कुधे़गेःक् सम्‍दाङ् यहुदिहाॽरे़ खुनिॽ हाङ् लॽरिक् आप्‍तिक् सक्‍किन् मे़साप्‍तुआङ् मे़भत्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","खुने़ॽनुए कुभे़न्‍छाङ् नु कुजुप्‍साङ्‌बा सिलाम्‍साक्‍मा सिङ्‌हाॽ सम्‍दाङ् ने़प्‍फु फाःन्‍दाहाॽ थक्‍सुबाहाॽरे़ मे़भोःन्‍दुसिरो॥ ((अक्‍खेलॽरिक् “खुने़ॽ पाःन् के़भेःम्‍बाहाॽनु सोरिक् मे़जोगु” लॽरिक् साम्‌योसाप्‍लाओ साप्‍ते़आङ् के़बप्‍पा पाःन्‍निन् के़रे़रो॥)) ");
INSERT INTO lifNT2_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","खे़प्‍मोलाम् लाङ्‌गे़घेःक्‍पा मनाहाॽरे़आङ् खुनिॽ थे़गेःक्‍पे़न्‌मे़हिक्‍खुर अक्‍खेलॽरिक् खुने़ॽ किनाःन्‍दि मे़बिरु, “खे़ने़ॽग माङ्‌हिम्‍मिन् के़यःबाआङ् सुम्‌ये़न्‍नो के़जोःक्‍पे, ");
INSERT INTO lifNT2_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","खे़ने़ॽ सिलाम्‍साक्‍मा सिङ्‌ङोलाम् यो थ्‍ये़ॽआङ् आबाङे से़ःप्‍सिङ्‌ङे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","हे़क्‍केलॽरिक्‍के तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़आङ् खुने़ॽ किनाःन्‍दि मे़बिरुर अक्‍खे मे़बाःत्तु, “खे़ल्‍ले़ वेॽ मनाहाॽग ताङ्‌से़ःप्‍तुसि, कर खुने़ॽ आबाङेग से़ःप्‍सिङ्‌मा मे़सुक्‍सिङ्‌ङिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","खुने़ॽ से़क्‍खाए इस्राइलस्‍मा हाङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तने़ फाॽग्र, हाराॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ्‌नु यो थाःर, हे़क्‍क्‍याङ् खे़न् निःसुम्‍बे़आङ् नसाःन् चोगुम्‍बे़ॽरो॥” खुने़ॽनुए मे़भोःन्‍दुसिबा खे़न् फाःन्‍दाहाॽरे़आङ् खुने़ॽ किनाःन्‍दि पिरे़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","हे़क्‍क्‍याङ् ले़न्‍दिक् कुमुक् थिक्-ने़त्ताङ्‌धो कुमुक् सुम्‍सि थारिक् खादाम्‍माल्‍ले़ खे़न् लाजेॽइन्‌सिदे़प् ते़प्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","कुमुक् सुम्‍सि मुक्‍ते़र पत्‍छे़ल्‍ले़ ये़सुःन् अक्‍खेलॽरिक् यम्‍बा इक्‍लाओ अःक्‍ते़, “एलोइ, एलोइ, लामा सबखथानि?” खे़न् फाॽइङ्‌ग “आनिङ्‌वाॽफुमाङ्‌ङे, आनिङ्‌वाॽफुमाङ्‌ङे, थेआङ् के़ले़राङ् के़देःसाङ्बे?” पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","खे़प्‍मो के़ये़प्‍पा कुभारे़ खे़न् मे़घे़प्‍सुआङ् अक्‍खे मे़बाःत्तु, “खे़ल्‍ले़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलियाःन् उःत्तुर पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","खे़ङ्‌हाॽओ लत्‍छा मनाधिक् खिमो लोःक्‍ते़र पेआङ् खिगाक्‍माःन् के़सुःप्‍पा चे़ल्‍ले़क्‍सेॽ थिःओ निःप्‍सु हे़क्‍क्‍याङ् तक्‍काःत्तिल्‍ले़ कुसम्‍मो फत्‍छु हे़क्‍क्‍याङ् ये़सुरे़ पिःत्तु थुङुर फाॽआङ् कुमुराओ थुप्‍तु पिरुआङ् अक्‍खे पाःत्तु, “लु ओमे़त्तुम् साॽरुम्! एलियाःन् युःआङ् खुने़ॽ थाःसुॽबि मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","हे़क्‍क्‍याङ् ये़सुःन् याम्‍मो यम्‍बा इक्‍लाओ अःक्‍ते़आङ्‌कुसक्‍मा पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","खिमो माङ्‌हिम्‍मोबा फोःन्‍दाःन् थोनु यो थारिक् खे़ल्‍ले़क् ते़ःक्‍खे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ये़सुःन् मे़भोःन्‍दुबा सिलाम्‍साक्‍मा सिङ् तगि के़ये़प्‍पा रोमि थक्‍तुम्‍बाल्‍ले़ अक्‍खेलॽरिक् खुने़ॽ स्‍ये़बान्‌ओमे़त्तुर पाःत्तु, “से़क्‍खासाङ् कन् मनाःन् निङ्‌वाॽफुसाःए वये़रे़त्‍छ॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","खे़प्‍मो माःङ्‌घालाम् कुभा मे़न्‍छुमाहाॽ ओमइ मे़ये़बे़॥ खे़ङ्‌हाॽओ मरियम मग्‍दलिनि, चुक्‍पा याकुब नु युसुफरे़ खुन्‍छिॽ मा मरियम नु सालोमिसि मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ये़सुःन् गालिलओ वये़ल्‍ले़ खे़ङ्‌हाॽरे़ ये़सुःन् मे़दिःक्‍तुर कुभाॽ मे़बिरुर मे़वये़॥ खे़प्‍मो यरुसले़म थारिक् ये़सुःन्‍नु के़दाःबा वेॽ मे़न्‍छुमाहाॽआङ् यरिक् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","आल्‍ल युःन्‍छिक् पोःक्‍खे़ल्‍ले़ आरिमाथिया पाङ्‌जुम्‍बा युसुफे़न् खे़प्‍मो त्‍ये़॥ खुने़ॽ यहुदि ये़जुम्‍भोरे़ मिङ्‌सो इङ्‌धाःङ्‌साबा पासिङ्‌पादाङ्‌ला नु निङ्‌वाॽफुहाङ्‌जुम् के़हाङ्‌बाआङ् के़वाॽबा वये़रो॥ खे़न् यारिप् चोःक्‍मा ये़म्‌वये़ (नाःम्‍सिङ्‌ये़न्‍निन् कुदाःन्‍दिक्‍मा वये़)॥ हे़क्‍केःल्‍ले़ खे़न् आःन्‍छिङ्‌ङाङ् पिलातसरो पे हे़क्‍क्‍याङ् ये़सुरे़ कुधक्‍किन् नाःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","पिलातसरे़ ये़सुःन् आन्‍दे़ःन्‍छा स्‍ये़बा खे़प्‍सुआङ् कुनिङ्‌वाॽ मये़॥ हे़क्‍क्‍याङ् खे़ल्‍ले़ खे़न् थक्‍तुम्‍बान् उःत्तुआङ् ये़सुःन् आन्‍दे़ःन्‍छा स्‍ये़बाबि मे़ःम्‍बि फाॽआङ् सेःन्‍दोसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","खे़ल्‍ले़ थक्‍तुम्‍बे़ल्‍लोलाम् ये़सुःन् आन्‍दे़ःन्‍छा स्‍ये़बा पाःन्‍निन् खे़प्‍सुआङ् युसुफे़न् ये़सुरे़ कुधक्‍किन् तेॽमा पाङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","हे़क्‍केःल्‍ले़ युसुफरे़ नुःबा चे तेःत्तिन् इङु, हे़क्‍क्‍याङ् ये़सुरे़ कुधक्‍किन् सिलाम्‍साक्‍मा सिङ्‌ङोनु थाःसुआङ् खे़न् तेःत्तिल्‍ले़ कित्तुआङ् लुङ्‌ङो खोःम्‍मनाबा इप्‍पुङ्‌ङो ने़स्‍सुरो॥ हे़क्‍क्‍याङ् इप्‍पुङ्‌ङिल्‍ले़ कुमुराओ लाःक्‍कात्‍लाम् यम्‍बा लुङ्‌ङिन् इसुधःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","मरियम मग्‍दलिनि नु युसुफरे़ कुम्‍मा मरियमरे़ ये़सुरे़ कुधक्‍किन् मे़ने़स्‍सुबा ते़न्‍निन् मिक्‍सेःन् मे़त्ते़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","आल्‍ल नाःम्‍सिङ्‌मा ये़न् काःक्‍तुआङ् मरियम मग्‍दलिनि, याकुबरे़ कुम्‍मा मरियम नु सालोमिसिरे़ मुर्रःन् ये़सुरे़ कुधक्‍को हुःप्‍मा फाॽआङ् मे़इङु॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","हे़क्‍क्‍याङ् ते़ने़बा ये़न्‍नो खाओःत्ते़र पत्‍छे़ल्‍ले़ खे़ङ्‌हाॽ ये़सुःन् मे़ने़स्‍सुबा इप्‍पुङ्‌ङो मे़धाःसिङ्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","हे़क्‍क्‍याङ् लाम्‍मो मे़बेर मे़बत्‍छे़ल्‍ले़ खे़ङ्‌हाॽ अक्‍खे मे़मे़त्‍छिङ्, “आनिॽ लागि खे़न् इप्‍पुङ्‌ङिल्‍ले़ कुमुराओ मे़ये़प्‍सुबा यम्‍बा लुङ्‌ङिन् हाःत्‍ले़ आइन्‍आबिबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ खे़प्‍मो मे़गे़रे़आङ् ओमे़मे़त्तुल्‍ले़ इप्‍पुङ्‌ङिल्‍ले़ कुमुराओ के़ये़प्‍पा लुङ्‌ङिन् थिक्‍ले़प्‍माङ् मे़इसुआङ् ने़स्‍से़बा मे़निःसु॥ खे़न् लुङ्‌ङिन् साॽरिक् यम्‍बा चोगे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","खे़ङ्‌हाॽ सिगाङ् मे़लाःस्‍से़ल्‍ले़ खे़प्‍मो फःदाङ्‌बा तेःत् के़जाङ्‌बा नालिङ्‌गे़न् थाङ्‌बे़न्‍धिक् चुप्‍साङ् ले़प्‍माङ् ये़बे़बा मे़निःसुआङ् खुनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","खे़ल्‍ले़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ निङ्‌वाॽ मे़मये़म्‍मिन्‍ने़ॽओ! खिनिॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् मे़भोःन्‍दुबा नासरतबा ये़सुःन् के़गोःत्तुम्‍बा मे़ःम्‍बि? खुने़ॽग कप्‍मो होःप्‍लो! खुने़ॽग सिःमे़न्‍लाम् याम्‍मो हिङे़, मे़ःन्‍ने़ फाॽग्र खुने़ॽ मे़ने़स्‍सुबादे़न्‍निन् ओमे़त्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","खिनिॽ पेगे़म्‍मे़ॽआङ् कुहुॽसाम्‍बाहाॽ नु पत्रुसे़न् कन् इङ्‌घङ्‌ङिन् पिरे़म्‍सिम्‍मे़ॽ, ‘खुने़ॽ तगि के़मे़त्तिबा हे़क्‍केए खिनिॽनुःल्‍ले़ तगि गालिलओ पेःक्‍लो, हे़क्‍क्‍याङ् खे़त्‍थोए खुने़ॽ के़दुमुम्‍लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ इप्‍पुङ्‌लाम् लाःक्‍कात् मे़लःन्‍दे़आङ् मे़लोःक्‍ते़, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ साॽरिक् मे़गिसे़आङ् मे़वये़रो॥ खे़ङ्‌हाॽरे़ हाःत्ताङ् थेआङ् मे़म्‍मे़त्तुन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","((आल्‍ल ते़ने़बा ये़न्‍नो खाओःत्ते़र पत्‍छे़ल्‍ले़ ये़सुःन् सिःमे़न्‍लाम् याम्‍मो हिङे़आङ् मरियम मग्‍दलिनिरो ओसेःन्‍धाक्‍सिङ्‌लो॥ खे़ल्‍लोलाम् नुसि फे़न्‍साम्‍हाॽ ये़सुरे़ नाःत्तु लःत्तुसिआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","मरियम मग्‍दलिनिःन् पेआङ् ये़सुःन् तुमुबा पाःन्‍निन् कुहुॽसाम्‍बाहाॽ मे़त्तुसि॥ खे़ङ्‌हाॽ मेरिङ् थक्‍नु मे़हाबे़र मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","खे़ङ्‌हाॽरे़ ये़सुःन् सिःमे़न्‍लाम् याम्‍मो हिङे़बा नु खे़ल्‍ले़ निःसुबा पाःन्‍निन् मे़घे़प्‍सुसाङ् नसाःन् मे़न्‍जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","खे़ङ्‌हाॽओ ने़प्‍फु हुॽसाम्‍बाहाॽ पाङ्‌भेॽओ पेगे़त्‍छिर पत्‍छे़त्‍छिल्‍ले़ ये़सुःन् कुसिङ्‌निःप्‍मे़न्‍दे़प्‍मना पोःक्‍खे़आङ् खे़ङ्‌हाॽओ ओसेःन्‍धाक्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ ने़प्‍माङ् नुःक्‍खे़त्‍छिआङ् खुन्‍छिॽ निःसे़त्‍छुबा पाःन्‍निन् वेॽहाॽ चे़क्‍ते़त्‍छु, कर खे़ङ्‌हाॽरे़ नसाःन् मे़न्‍जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","याङ्‌सि थिक्-थिक् (११) हुॽसाम्‍बाहाॽरे़ मे़जर मे़युङे़ल्‍ले़ ये़सुःन् खे़प्‍मो ओसेःन्‍धाक्‍सिङ्‌॥ हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ फे़ःक्‍तुसि, थेआङ्‌भे़ल्‍ले़ खुनिॽ नसाःन् सुःम्‍मान् नु निङ्‌वाॽ थुङ्‌माल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ सिःमे़न्‍लाम् याम्‍मो हिङे़बा के़निःबाहाॽरे़ खुनिॽ पाःन्‍निन् नसाःन् मे़न्‍जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आल्‍ल खिनिॽ काक् इक्‍सादिङ् खाम्‍बेःक्‍मो पेगे़म्‍मे़ॽआङ् के़रे़क् मे़न्‍छाम्‍गे़न् याप्‍मिहाॽ कन् सुनाइङ्‌ङिन् इङ्‌भोःसे़म्‍सिम्‍मे़ॽओ! ");
INSERT INTO lifNT2_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","हे़क्‍क्‍याङ् नसाःन् के़जोःक्‍पा नु बप्‍तिस्‍मा के़बोःङ्‌बाल्‍ले़ से़न्‍लप् खोःसुॽ, कर नसाःन् मे़न्‍जोःक्‍मनाबाल्‍ले़ खासे़न्‍नो थाआङ् खुम्‍दिङ् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","नसाःन् के़जोःक्‍पाहाॽ कन् मिक्‍सेःन्‍निल्‍ले़ काप्‍तुसिरो–खे़ङ्‌हाॽरे़ इङ्‌गाॽ आमिङ्‌ङो फे़न्‍साम्‍हाॽ मे़नाःत्तुसिॽ, हे़क्‍क्‍याङ् कुसङ् पाःन्‍दाङ्‌हाॽ मे़बाःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ असेःक्‍पाहाॽ मे़दे़म्‍सुसिॽ, निङ् के़याक्‍पा च्‍या मे़धुङुसाङ् थेआङ् हम् मे़म्‍बोःङ्‌ङिन्‍लो॥ हे़क्‍क्‍याङ् के़दुक्‍पा के़यॽबाहाॽ सम्‍दाङ् हुक् मे़ने़स्‍सु मे़बिरुसिल्‍ले़ खे़ङ्‌हाॽ मे़वेःत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","हे़क्‍क्‍याङ् दाङ्‌बा ये़सुरे़ हे़क्‍के पाःत्तु सुरुआङ् खुने़ॽ थाःङ्‌धाःङ् साङ्‌ग्राम्‍पेदाङ् ले़प्‍माङ् थो पक्‍खे़र पेआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुजुप्‍साङ् ले़प्‍माङ् युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽरे़ काक् पिसाङ् मे़बेआङ् सुनाइङ् मे़से़ःसुरो॥ दाङ्‌बाल्‍ले़आङ् खुनिॽलाम् याःम्‍बक् चोगुर यरिक् निङ्‌वाॽ के़माबा मिक्‍सेःन्‍निल्‍ले़ सुनाइङ्‌ङिन् से़क्‍खारो फाॽआङ् ओसेःन्‍दाङ् चोगुरो॥))");
INSERT INTO lifNT2_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","आदाङ्‌बा तुम्‍म्‍याङ्‌हाङ् थियोफिलसे, यरिक् मनाहाॽरे़ आनिगे़ लुम्‍मो ये़सुरे़ कुयाःम्‍बेओ पोःक्‍खे़बा हिन्‍दोःक्‍किल्‍ले़ पोधक्‍किन् मे़साप्‍तुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","खे़न् हिन्‍दोःक्‍हाॽग कुहेःक्‍सिङ्‌माआङ्धो आबाङे मिक्‍किल्‍ले़ के़निःबाहाॽ नु बा कल्‍ले़ कुयाःम्‍बेओ सुनाइङ् के़से़बाहाॽरे़ आनिगे़ मे़जे़क्‍तिगे़आङ्‌वाॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","हे़क्‍केःल्‍ले़ आनिगे़ लुम्‍मो पोःक्‍खे़बा के़रे़क् पाःन्‍हाॽ कोःम्‍भो चोगुङ्‌ङाङ् वाॽआ हे़क्‍क्‍याङ् खे़ने़ॽ के़लागि साप्‍मा नुःबा पोःङ् के़लॽबान् इङ्‌गाॽआङ् इःत्तुङ्‌लो, हे़क्‍केःल्‍ले़ खे़ने़ॽ के़हुॽसिङ्‌बा काक् पाःन्‍हाॽ से़क्‍खाए लॽरिक् कुसिङ् के़निःत्तुर फाॽआङ् थे़प्‍पे़त् साप्‍तुङ् पिने़आङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","यहुदियास्‍मा हे़रोद हाङ्‌ङिल्‍ले़ कुये़म्‍मो अबिया निङ्‌वाॽफुसाम्‍बाल्‍ले़ कुधाःक्‍को लत्‍छा जकरिया मे़प्‍मनाबा निङ्‌वाॽफुसाम्‍बाधिक् वये़॥ खे़ल्‍ले़ मेलिङ्‌गे़न् कुमेःत् इलिसिबाःन्‍नाङ् हारुनरे़ कुमुॽइदाङ्‌सा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","खे़ङ्‌हाॽ ने़प्‍माङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिःमाओ साम्‌योनिबा वये़त्‍छिआङ् नुःरिक्‍काङ् साम्‌योथिम् के़इःप्‍पा के़नाःप्‍पा नु यहवे दाङ्‌बाल्‍ले़ के़रे़क् कुइङ्‌जाःङ् के़घे़म्‍बा वये़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","कर खे़ङ्‌हाॽरे़ खुन्‍छिॽ सा-ए मे़होःप्‍ते़, थेआङ्‌भे़ल्‍ले़ इलिसिबारे़ कुसामुॽइ खक्‍सिङ्‌ङाङ् वये़, हे़क्‍क्‍याङ् ने़प्‍माङ् काप्‍पोबा काप्‍मोमा तुम्‍से़त्‍छिआङ् वये़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","थिक्‍ले़ङ् जकरियारे़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदगि निङ्‌वाॽफुसाम्‍बा पोःङ्‌माआङ् सेवा चोःक्‍मा लक् खोःसु, थेआङ्‌भे़ल्‍ले़ कन् खुने़ॽ वये़बा लक्‍किल्‍ले़न् सेवा चोःक्‍मा ये़म् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","निङ्‌वाॽफुसाम्‍बा थिम् कुइसिःक् यहवे दाङ्‌बाल्‍ले़ कुमाङ्‌हिम्‍मो पेःक्‍माआङ् साङ्‌सिङ् हाःम्‍मा लक्‌रे़ लागि निङ्‌वाॽफुसाम्‍बाहाॽरे़ तॽयाःन्‍सोःन्‌मे़गे़ःसुल्‍ले़ खुने़ॽ खोःसुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","हे़क्‍क्‍याङ् साङ्‌सिङ् हाःन्‍दुल्‍ले़ लाःक्‍कात् यरिक् मनाहाॽ सेवा चोःक्‍से़ मे़जुप्‍से़आङ् तुवा चोःक्‍नु मे़ये़बे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","हे़क्‍क्‍याङ् साङ्‌सिङ् हाःम्‍मादे़न्‍निल्‍ले़ चुप्‍साङ् ले़प्‍माङ् माङ्‌लाइङ्‌बाधिक् ओःन्‍धाक्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","हे़क्‍केःल्‍ले़ जकरियारे़ कुयङ्‌मा के़रे़आङ् कुगिःमाल्‍ले़ युम्‍सुङ्‌मा पोःक्‍खे़, ");
INSERT INTO lifNT2_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","कर खे़न् माङ्‌लाइङ्‌बाल्‍ले़ खुने़ॽ मे़त्तु, “मे़गिसे़न्‍ने़ॽओ जकरियाए! आल्‍लो खे़ने़ॽ के़जोगुबा तुवाःन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़प्‍सुआङ् वाॽरो॥ आल्‍ल मेलिङ्‌गे़न् के़मेःत् इलिसिबारे़ ये़म्‍बित्‍छाॽसाःधिक् के़गत् के़बिॽरो॥ खे़न् अङे़ःक्‌वाःन् युहुन्‍ना मिङ् वाःत्ते़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","खे़ने़ॽ के़सःत्ताङ् ये़ये़ के़लॽरो॥ हे़क्‍क्‍याङ् अङे़ःक्‌वा साःगे़वाःन्‍छिङ्‌बा पोःङ्‌बाल्‍ले़ चोगुल्‍ले़ यरिक् मनाहाॽआङ् मे़सःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","थेआङ्‌भे़ल्‍ले़ खुने़ॽ दाङ्‌बाल्‍ले़ कुनिःमाओ यम्‍बा पोःङ्‌लो॥ खुने़ॽ चे़ल्‍ले़क्‍सेॽ थिः नु वेॽ आममबा थुङ्‌मा मे़नुॽने़न्‍लो॥ हे़क्‍क्‍याङ् सावाःन्‍छिङ्‌ङाङ्‌धोए सेसेमाङ्‌ङिल्‍ले़ कुधिम् पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","खुने़ॽग यरिक् इस्राइलिहाॽ खुनिॽ निङ्‌वाॽफुमाङ् दाङ्‌बाओ नुःक्‍तु तारुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","खुने़ॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलियाःन् कुइसिःक् थुम् नु मुक्‍साम्‍मिल्‍ले़ कुधिम् पोःङ्‌ङाङ् दाङ्‌बाल्‍ले़ कुलागि मनाहाॽ यारिप् चोःक्‍मासि फाॽआङ् दाङ्‌बारे़ कुदगि पेःक्‍लो॥ खुने़ॽ पाःहाॽरे़ खुनिॽ निङ्‌वाॽइन्‌साःहाॽ ले़प्‍माङ्, हे़क्‍क्‍याङ् लायोबाहाॽरे़ खुनिॽ निङ्‌वाॽइन्‌साम्‌योनिबाहाॽरे़ खुनिॽ सिक्‍कुम्‍दिङ् निङ्‌वाॽओ नुःक्‍तुसिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","हे़क्‍क्‍याङ् जकरियारे़ माङ्‌लाइङ्‌बान् सेःन्‍दोसु, “आक्‍खेआङ् कन् कुसिङ्‌निःत्तुङ्‌बाबे? इङ्‌गाॽआङ् काप्‍पोबा तुम्‍साङ्‌ङाङ् वाॽआ॥ हे़क्‍क्‍याङ् आमेःत्तिन्‍नाङ् काप्‍मो तुम्‍से़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","खुने़ॽ मे़त्तु, “इङ्‌गाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदगि के़ये़प्‍पा गाब्रिएल माङ्‌लाइङ्‌बाॽआरो॥ खे़ने़ॽओ कन् सुनाइङ्‌ङिन् ताःप्‍मारे़ लागि निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ इङ्‌गाॽ पाङ्‌घाङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","कन् पाःत्तुङ्‌बा माङ्‌हे़क्‍किन्‌कुये़म्‍मो के़त्‍लो, कर खे़ने़ॽ नसाःन् के़न्‍जोगुम्‍बाल्‍ले़ चोगुल्‍ले़ के़स्‍साःन् सामे़न्‌वाःन्‍छिङ्‌ङे थारिक् के़बाःन् मे़लःन्‍ने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","हे़क्‍केलॽरिक् माङ्‌हिम् लाःक्‍कात् के़ये़प्‍पा मनाहाॽरे़ थेआङ् जकरियाःन् सुःसे़बे फाॽआङ् खुनिॽ निङ्‌वाॽ मये़र मे़हाङ्‌घुर मे़ये़बे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","हे़क्‍क्‍याङ् जकरियाःन् लाःक्‍कात् लःन्‍दे़, कर खुने़ॽ पाःप्‍माए मे़सुक्‍ते़न्‍लो, हे़क्‍केःल्‍ले़ हुक्‍चाःल्‍किल्‍ले़ मिक्‍सेःन् चोगुर पारे़, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खे़ल्‍ले़ माङ्‌हिम् सिगाङ् सुफोःन् निःसुबिला लॽरिक् निङ्‌वाॽ मे़इःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","हे़क्‍क्‍याङ् जकरियाःल्‍ले़ माङ्‌सेवा याःम्‍बक् चोःक्‍मा कुये़म् चुरे़आङ् खुने़ॽ कुहिम्‍मो नुःक्‍खे़ पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","याङ्‌सि मेलिङ्‌गे़न् कुमेःत्तिन् मे़न्‍छुक्‍मा पोःक्‍खे़आङ् ला ङासि थारिक् हिम्‍मोए याःक्‍ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","खे़ल्‍ले़ पाःत्तु, “दाङ्‌बाल्‍ले़ इङ्‌गाॽ लुङ्‌माॽ तुक्‍ताङ्‌ङाङ् वाॽआ, थेआङ्‌भे़ल्‍ले़ साःमे़ङ्‌गप्‍मनामा लॽरिक् ताप्‍फे़ःम्‍बा आमिङ्‌ङिन् खे़त्तुदेःसु पिराङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","हे़क्‍क्‍याङ् इलिसिबाःन् मे़न्‍छुक्‍मा पोःक्‍खे़बा ला तुक्‍सि के़रे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमाङ्‌लाइङ्‌बा गाब्रिएले़न् गालिल थुम्‍मोबा नासरत पाङ्‌जुम्‍मो पाङ्‌घुरो॥ खे़न् मरियम मे़प्‍मनामा सिसादिङ् मे़न्‍छुमाओ पे॥ खे़न् सिसादिङ् मे़न्‍छुमाॽइल्‍ले़ कुमेःक्‍खिम् पाःन्‍निन् दाउदरे़ कुधाःक् युसुफ मे़प्‍मनाबा मनाःन्‍नु पुॽरे़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","खे़न् माङ्‌लाइङ्‌बाल्‍ले़ मे़त्तु, “आसेवारो, खे़ने़ॽग दाङ्‌बाल्‍ले़ साॽरिक् कुसिराॽ के़धाङे़आङ् के़वाॽरो॥ खुने़ॽ खे़ने़ॽनु वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","मरियम्‍मिन् साॽरिक् कुनिङ्‌वाॽ मये़आङ् आक्‍तङ्‌बा परिक्‍ले़न् सेवा इ फाॽआङ् निङ्‌वाॽ इःत्‍छिङ्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","हे़क्‍क्‍याङ् माङ्‌लाइङ्‌बाल्‍ले़ खुने़ॽ मे़त्तु, “मरियम्‍मे, मे़गिसे़न्‍ने़ॽओ! निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़ने़ॽग साॽरिक् कुसिराॽ के़धाङे़आङ् के़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","आल्‍ल खे़ने़ॽ ये़म्‍बित्‍छाॽसाःधिक् के़गत्तुॽ॥ खे़ल्‍ले़ कुमिङ् ये़सु वाःत्ते़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","खुने़ॽ पयम् यम्‍बा पोःङ्‌ङाङ् के़रे़क्‍नुःल्‍ले़ पयम् यम्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुस्‍साः फाॽआङ् मे़मे़त्तुॽरो॥ दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽ कुधाःक्‍थे़बा दाउदरे़ हाङ् चोगुबा हे़क्‍के हाङ् चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","हे़क्‍क्‍याङ् खुने़ॽ इस्राइल सम्‍दाङ् सदादिङ् हाङ् चोगुॽरो॥ खुने़ॽ कुहाङ्‌जुम्‍मिन् आप्‍फाल्‍ले़आङ् मे़नुप्‍ने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","मरियम्‍मिल्‍ले़ माङ्‌लाइङ्‌बान् सेःन्‍दोसु, “कन् आक्‍खेलॽरिक् पोःङ्‌बाबे? इङ्‌गाॽग सिसागे़न् मे़न्‍छियाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","माङ्‌लाइङ्‌बाल्‍ले़ नोगप् पिरु, “सेसेमाङ्‌ङिन् के़सम्‍दाङ् ताआङ् के़रे़क्‍नुःल्‍ले़ पयम् यम्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍मिल्‍ले़ के़घुःक्‍लो, हे़क्‍केलॽरिक् खे़ने़ॽओलाम् सागे़वाःन्‍छिङ्‌बाङ्‌ग निङ्‌वाॽफुसाः मे़मे़त्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","खे़प्‍से़ॽओ, खे़ने़ॽ के़गाॽइ इलिसिबाःन् खुने़ॽ कुगाप्‍मो तुम्‍मो मे़न्‍छुक्‍मा पोःक्‍खे़आङ् वाॽ॥ आल्‍लो मनाहाॽरे़ खुने़ॽ साःमे़ङ्‌गप्‍मनामा मे़मे़त्तुसाङ् मे़न्‍छुक्‍मा पोःक्‍खे़बा ला तुक्‍सि के़रे़आङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","खे़ल्‍ले़ चोगुल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ चोःक्‍मा मे़सुक्‍तुम्‍बा याःम्‍बक् थेआङ् होःप्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","मरियमरे़ नोगप् पिरु, “इङ्‌गाॽग दाङ्‌बाल्‍ले़ कुसेवारोमाआरो॥ खे़ने़ॽ के़बाःत्तुबा हे़क्‍केए के़त्‍लरो॥” हे़क्‍क्‍याङ् माङ्‌लाइङ्‌बे़न् पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","याङ्‌सि मरियम्‍मिन्‍नाङ् यहुदिया थुम्‍मोबा कोःक्‍माओ के़ने़बा पाङ्‌जुम्‍मो थासिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","खे़प्‍मो जकरियारे़ कुहिम्‍मो के़रे़आङ् इलिसिबाःन् सेवा मे़त्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","इलिसिबारे़ मरियम्‍मिन् सेवा मये़बा खे़प्‍सुनामे़ःन्‍ने कुसाप्‍पोःक्‍को के़याक्‍पा अङे़ःक्‌वाःन् मुन्‍जिङ् लॽरे़रो॥ इलिसिबाःन् सेसेमाङ्‌ङिल्‍ले़ कुधिम् पोःक्‍खे़, ");
INSERT INTO lifNT2_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","हे़क्‍क्‍याङ् यम्‍बा इक्‍लाओ पारे़, “खे़ने़ॽग मे़न्‍छुमाहाॽओ के़रे़क्‍नुःल्‍ले़ मुॽइसामाने़रो, हे़क्‍क्‍याङ् खे़ने़ॽ सागे़वाःन्‍दुबा अङे़ःक्‌वाःङ्‌ग मुॽइसाबा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","हे़क्‍क्‍याङ् इङ्‌गाॽ आदाङ्‌बाल्‍ले़ कुम्‍माए आदुम्‍से़ ताःमा कन् आक्‍तङ्‌बा मिङ्‌सो इङ्‌धाःङ्‌ने़ इङ्‌गाॽ खोःसुङ्‌बे? ");
INSERT INTO lifNT2_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","खे़ने़ॽ सेवा के़मे़त्ताङ्‌बा पाःन्‍निन् खे़प्‍सुङ्‌नुमे़ःन्‍ने इङ्‌गाॽ आसाप्‍पोःक्‍पो के़याक्‍पा अङे़ःक्‌वाःन् सःत्ते़र मुन्‍जिङ् लॽरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","खे़ने़ॽग के़रे़क्‍नुःल्‍ले़ मुॽइसामाने़रो, थेआङ्‌भे़ल्‍ले़ दाङ्‌बाल्‍ले़ खे़ने़ॽ के़हिङ्‌मन्‍नो पोःङ् पाःत्तुबा पाःन्‍हाॽ कुना के़साॽरुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","हे़क्‍क्‍याङ् मरियमरे़ पाःत्तु, “इङ्‌गाॽ आसिक्‍लुङ्‌मोलाम्‍मे दाङ्‌बाल्‍ले़ कुनारा फोःसुङ्‌लो, ");
INSERT INTO lifNT2_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","हे़क्‍क्‍याङ् इङ्‌गाॽ आसे़न्‍लप्‍दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन्‍नु साॽरिक् सःत्ताङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ हे़क्‍तङ्‌मा चुङ्‌जिगे़न् कुसेवारोमान् निङ्‌वाॽ इःत्ताङ्‌ङाङ् वाॽआरो॥ आल्‍लआङ्धो थाःक्‍थाःक्‍को इङ्‌गाॽ मुॽइसामा फाॽआङ् मे़मे़त्तारो, ");
INSERT INTO lifNT2_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","थेआङ्‌भे़ल्‍ले़ मुक्‍साम्‍दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ यम्‍लाबा याःम्‍बक्‍हाॽ इङ्‌गाॽ चोगाङ् पिराङ्‌ङाङ् वाॽआरो॥ खुने़ॽ कुमिङ्‌ङिङ्‌ग सेसे चोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","हे़क्‍क्‍याङ् खुने़ॽ मिङ्‌सो इङ्‌धाःङ् के़बिबाहाॽ के़रे़क् थाःक्‍थाःक्‍को खुने़ॽ कुलुङ्‌गुम्‍मिन् ओसेःन्‍धाक्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","खुने़ॽ मुक्‍साम्‍बा कुहुक्‍हाॽरे़ याःम्‍बक् चोगुआङ् वाॽ, हे़क्‍क्‍याङ् आङ्‌दिङ् के़लॽबाहाॽ के़रे़क् इदिवदिॽ चोगुसिआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","हे़क्‍क्‍याङ् खुने़ॽ हाङ् के़जोःक्‍पाहाॽ खुनिॽ हाङ् युक्‍नाओलाम् यो थाःसुसिआङ् वाॽ, कर चुङ्‌जिगे़म्‍बाहाॽ थाःङ्‌धाःङ् फोःक्‍खुसिआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","हे़क्‍क्‍याङ् खुने़ॽ साक्‍किल्‍ले़ तरुसिबाहाॽ नुःबा चिगःक्‌वाहाॽ पिरुसिआङ् वाॽ, कर याङ्‌साकुन्‍धेसाबाहाॽ कुघाले़म् पाङ्‌घुसिआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","खुने़ॽ अब्राहाम नु कुमुॽइदाङ्‌साहाॽ सदादिङ् लुङ्‌माॽ तुक्‍मासि निङ्‌वाॽ इःत्तुआङ् वाॽरो॥ खुने़ॽ आनिगे़ थाःक्‍हाॽ मे़त्तुसिबा हे़क्‍के कुसेवारोबा इस्राइले़न् कुभाॽ पिरुआङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","मरियम्‍मिन् ला सुम्‍सि थारिक् इलिसिबाःन्‍नु वये़, हे़क्‍क्‍याङ् कुहिम्‍मो नुःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","हे़क्‍क्‍याङ् इलिसिबारे़ कुसावाःम्‍मा ये़म् त्‍ये़आङ् ये़म्‍बित्‍छाॽसाःधिक् सावाःन्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","हे़क्‍क्‍याङ् खुने़ॽ कुहिम्‍बेसाङ्‌बाहाॽ नु कुगाॽइबाहाॽरे़ कन् दाङ्‌बाल्‍ले़ खुने़ॽ लुङ्‌माॽ तुक्‍तुबा पाःन्‍निन् मे़घे़प्‍सुआङ् खे़ङ्‌हाॽ खुने़ॽनु मे़सःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","हे़क्‍क्‍याङ् अङे़ःक्‌वासाःन् ये़त्‍छि (८) ये़न्‍नो हर्दो मे़हे़गु मे़बिरुबा थिम्‍मो मे़द्‌ये़आङ् खुने़ॽ कुमिङ्‌ङिन्‍नाङ् कुम्‍बारे़ कुमिङ् कुइसिःक् जकरिया मिङ् वाःप्‍मा मे़इःत्तुआङ् मे़वये़, ");
INSERT INTO lifNT2_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","कर कुम्‍मारे़ मे़त्तुसि “मे़ःन्‍लो! कल्‍ले़ कुमिङ्‌ग युहुन्‍ना वाःप्‍मा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","खे़ङ्‌हाॽरे़ कुम्‍माःन् मे़मे़त्तु, “खे़ने़ॽ के़गाॽइहाॽओ अक्‍तङ्‌बा मिङ् के़वाःप्‍पा मनाहाॽ मे़होःप्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ जकरियाःन् हुक्‍चाःल्‍किःल्‍ले़ सेःन्‍मे़दोसु, “कल्‍ले़ कुमिङ् थे वाःप्‍मा निङ्‌वाॽ के़जोगुआङ् के़वाॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","खे़ल्‍ले़ साप्‍मा सामाःन् नाःक्‍तुसिआङ् कल्‍ले़ कुमिङ् युहुन्‍ना लॽरिक् साप्‍तु पिरुसि॥ हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","खिमो खे़न् पाःप्‍मा हेःक्‍ते़आङ् खे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःमा हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","खे़ङ्‌हाॽरे़ खुनिॽ हिम्‍बेसाङ्‌बाहाॽ खुनिॽ निङ्‌वाॽ मये़र मे़गिसे़रो॥ यहुदियास्‍मा काक् कोःक्‍मा फाङ्‌जङ्‌बा पाङ्‌भेॽ खाराक् कन् पाःन्‍निन् से़ःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","हे़क्‍क्‍याङ् कन् पाःन्‍निन् के़घे़म्‍बा के़रे़क्‍ले़ खुनिॽ निङ्‌वाॽ मये़आङ् खे़ङ्‌हाॽरे़ अक्‍खे मे़बाःत्तु, “आल्‍ल कन् अङे़ःक्‌वाःन् ताःन्‍दि थे पोःङ्‌बाइरो?” थेआङ्‌भे़ल्‍ले़ दाङ्‌बाल्‍ले़ कुहुक्‍किन् खे़न् अङे़ःक्‌वाःल्‍ले़ कुसम्‍दाङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","युहुन्‍नारे़ कुम्‍बा जकरियाःन् सेसेमाङ्‌ङिल्‍ले़ थुक्‍तुआङ् माङ्‌निङ्‌वाॽपाःन् पारे़, ");
INSERT INTO lifNT2_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“इस्राइलिहाॽरे़ खुनिॽ दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःसुम्‍लो, थेआङ्‌भे़ल्‍ले़ खुने़ॽ कुमनाहाॽ कम्‍ब्राङ् मे़त्तुसिआङ् चोःक्‌युम्‍भो पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","खुने़ॽ कुसेवारोबा दाउदरे़ कुहिम्‍सयङ्‌लाम् याप्‍मि से़न्‍लप् के़बिबा मुक्‍के़गुबा से़न्‍लप्‍दाङ्‌बाधिक् फोःक्‍खुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","आनिॽ निङ्‌मिहाॽ नु याप्‍मि के़जिःप्‍पाहाॽरे़ खुनिॽ हुक्‍कोलाम् ताङ्‌आसे़ःप्‍लो के़लॽबा पाःन्‍निन् यरिक् तङ्‌बे तगि सेसे माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ मे़बाःत्तुआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","आनिॽ थाःक्‍थे़बाहाॽ लुङ्‌गुम् ओसेःन्‍धाक्‍मासि फाॽआङ् माङ्‌हुप्‍पिन् निङ्‌वाॽ इःत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","खे़न् माङ्‌हुप्‍पिन् खुने़ॽ आनिॽ थाःक्‍थे़बा अब्राहाम्‍मिन्‍नु माङ्‌हे़क् चोगुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","कन् माङ्‌हे़क्‍किन्‌आनिॽ निङ्‌मिहाॽरे़ खुनिॽ हुक्‍कोलाम् ताङ्‌से़ःप्‍मा आघोःसुम्‍ल, हे़क्‍क्‍याङ् मे़ङ्‌गिए मे़न्‌यङ्‌ङे आनिॽ हिङ्‌मन् खाराक् सेसे नु साम्‌योनिबा पोःङ्‌माआङ् खुने़ॽ कुसेवा चोःक्‍मा आसुक्‍तुम्‍ल फाॽआङ् पोःक्‍खे़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“आस्‍साःए, खे़ने़ॽ के़रे़क्‍नुःल्‍ले़ पयम् यम्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़न् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा के़म्‍मे़त्‍लो॥ थेआङ्‌भे़ल्‍ले़ खे़ने़ॽ दाङ्‌बाल्‍ले़ कुदगि लाम् यारिप् चोःक्‍से़ के़बेःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","हे़क्‍क्‍याङ् कुमनाहाॽ लायोलाम् ले़प्‍मि नु से़न्‍लप्‌रे़ सिक्‍कुम्‍दिङ् निङ्‌वाॽ ओसे़ःन्‍गे़धाक्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ चुङ्‌जिगे़न् कुलुङ्‌गुम्‍मिल्‍ले़ चोगुल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌लाम् नाम्‍साङ्‌ङिन् आनिॽओ चुक्‍मा इःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","हे़क्‍क्‍याङ् खादाम्‍मा नु सिःमे़ल्‍ले़न्‌साम्‍म्रिःप्‍पो के़वाॽबाहाॽओ खे़न् नाम्‍साङ्‌ङिन् ओःत्‍लो, हे़क्‍क्‍याङ् आनिॽ लाङ्‌भोःन् सनारुङ् लाम्‍मो तोःन्‍छिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","हे़क्‍क्‍याङ् अङे़ःक्‌वा युहुन्‍नाःन् पोःरे़र याम्‍साम्‍मो के़धुम्‍बा पोःक्‍खे़र पेआङ् सेसेमाङ्‌ङिल्‍ले़ कुधिम् पोःक्‍खे़आङ् खुने़ॽ इस्राइलिहाॽओ ओसेःन्‍मे़न्‍धाक्‍सिङ्‌ङे थारिक् एःक्‍सादे़न्‍नोए वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","खे़न् ये़म्‍मो रोमि पयम् हाङ् अगस्‍तसे़ल्‍ले़ के़रे़क् रोमि हाङ्‌जुम्‍मो याम्‍नाःत्‍निःत् चोःक्‍मा फाॽआङ् इङ्‌दत् पिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","कन् थिक्‍सिगेःक्‍पा याम्‍नाःत्‍निःत् मे़जोगुल्‍ले़ सिरिया थुम्‍मोबा सुहाङ्‌गे़म्‍बा कुरेनियस वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","के़रे़क् मनाहाॽ याम्‍नाःत्‍निःत्तो मिङ् साप्‍से़ आबाङे पाङ्‌जुम्‍मो मे़बे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","हे़क्‍केःल्‍ले़ युसुफे़न्‍नाङ् गालिल थुम्‍मोबा नासरत पाङ्‌भेॽओलाम् यहुदियास्‍मा दाउदरे़ कुबाङ्‌जुम् बे़थलेहे़म्‍मो मिङ् साप्‍से़ थासिङ्, थेआङ्‌भे़ल्‍ले़ खुने़ॽ दाउद हाङ्‌ङिल्‍ले़ कुमुॽइदाङ्‌सा वये़॥ खुने़ॽ कुमेःक्‍खिम् पाःन् के़बुॽमाआङ् के़वाॽमा मरियम्‍मिन्‍नु पे॥ खे़न् ये़म्‍मो खुने़ॽ मे़न्‍छुक्‍मा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ खे़प्‍मो वये़त्‍छिल्‍ले़ मरियम‌रे़ कुसागप्‍मा ये़म् त्‍ये़आङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","सादुङ्‌ङिल्‍ले़ तरु, हे़क्‍क्‍याङ् तुम्‍बा ये़म्‍बित्‍छाॽसाःन् सावाःन्‍दुआङ् खे़न् अङे़ःक्‌वाःन् तेःत्तिल्‍ले़ सुङुआङ् वाघोःङ्‌ङो ने़स्‍सु, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ चे़याङ्‌धोःक्‍को याङ्‌धोःक्‍मा मे़घोःसे़त्‍छुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","खे़न् ये़म्‍मो लाःक्‍कात् चौरिओ कुभा मे़ल्‍लुक्‍कम्‍बाहाॽ खुनिॽ मे़ल्‍लुक्‍हाॽ मे़गोःस्‍सुसिर से़न्‍दिक् मे़युङे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","खे़प्‍मो दाङ्‌बाल्‍ले़ कुमाङ्‌लाइङ्‌बाधिक् ओसेःन्‍धाक्‍सिङ्‌, हे़क्‍क्‍याङ् दाङ्‌बाल्‍ले़ कुमिमिदिङ्‌ङिन् से़न्‍दाङ्‌गे़न् ओःत्ति कुइसिःक् खुनिॽ खिरि ले़क्‍ते़रो॥ खे़ङ्‌हाॽ साॽरिक् मे़गिसे़, ");
INSERT INTO lifNT2_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","कर माङ्‌लाइङ्‌बाल्‍ले़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ मे़गिसे़म्‍मिन्‍ने़ॽओ! काक् मनाहाॽ साॽरिक् मे़सःत्‍ल फाॽआङ् इङ्‌गाॽ खिनिॽ लागि सुनाइङ् तारुङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","थेआङ्‌भे़ल्‍ले़ आइन् दाउदरे़ कुबाङ्‌जुम्‍मो से़न्‍लप्‍दाङ्‌बान् सावाःन्‍छिङ्‌ङाङ्‌वाॽ॥ खुने़ॽए निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त दाङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","अङे़ःक्‌वाःन् तेःत्तिल्‍ले़ मे़सुङुआङ् वाघोःङ्‌ङो मे़इप्‍तुआङ् ने़बा के़निःसुम्‍लो॥ खिनिॽ लागि बा खे़न्‍निन्‍ने़ मिक्‍सेःन् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","खे़प्‍मो हक्‍चघत् यरिक् माङ्‌लाइङ्‌बाहाॽ मे़धाःम्‍सिङ्‌ङाङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा मे़भोःसुर अक्‍खे मे़बाःत्तु, ");
INSERT INTO lifNT2_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“साङ्‌ग्राम्‍पेदाङ्‌ङोबा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमिमिदिङ् पोःङ्‌ल, हे़क्‍क्‍याङ् इक्‍सादिङ् खाम्‍बेःक्‍मो लुङ्‌माॽ तुक्‍तुसिबा मनाहाॽरे़ सनारुङ् मे़घोःसुररो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","हे़क्‍क्‍याङ् खे़न् माङ्‌लाइङ्‌बाहाॽ याङ्‌धो साङ्‌ग्राम्‍पेदाङ्‌ङो मे़नुःक्‍खे़ मे़बे, हे़क्‍क्‍याङ् खे़न् मे़ल्‍लुक्‍कम्‍बाहाॽ अक्‍खे मे़मे़त्‍छिङ्, “आल्‍ल आनिॽ माङ्‌लाइङ्‌बाहाॽरे़ आम्‍मे़त्ते़बा हे़क्‍के बे़थलेहे़म्‍मो के़बोःङ्‌बा पाःन्‍निन् पेगिआङ् ओमे़त्तुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ हारा मे़जात्ते़र बे़थलेहे़म्‍मो मे़बे॥ खे़प्‍मो युसुफ नु मरियम हे़क्‍क्‍याङ् वाघोःङ्‌ङो मे़इप्‍तुआङ् ने़स्‍से़बा अङे़ःक्‌वाःन् मे़दुमुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ कन् मे़निःसुआङ् खे़ङ्‌हाॽ अङे़ःक्‌वाःल्‍ले़ कुयाःम्‍बेओ माङ्‌लाइङ्‌बाहाॽरे़ मे़मे़त्तुसिबा पाःन्‍निन् मे़जे़क्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","मे़ल्‍लुक्‍कम्‍बाहाॽरे़ मे़बाःत्तुबा पाःन्‍निन् मनाहाॽरे़ मे़घे़प्‍सुआङ् खुनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","कर मरियम्‍मिल्‍ले़ कन् के़रे़क् पाःन्‍हाॽ कुनिङ्‌वाॽ सिगाङ् युक्‍खुआङ् निङ्‌वाॽ इःत्‍छिङ्‌ल वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","हे़क्‍क्‍याङ् खे़न् मे़ल्‍लुक् कम्‍बाहाॽरे़ माङ्‌लाइङ्‌बाल्‍ले़ पाःत्तुबा कुइसिःक् पोःक्‍खे़बा मे़निःसुआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमिमिदिङ् मे़जोगुर कुनारा मे़भोःसुर मे़नुःक्‍खे़ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ये़त्‍छि ये़न् के़रे़ल्‍ले़ अङे़ःक्‌वाःन् हर्दो मे़हे़गु मे़बिरुआङ् ये़सु मिङ् मे़वाःत्तुरो॥ खे़न् मिङ्‌ङिन् खुने़ॽ हाङ्‌सिङ्‌मानुःल्‍ले़ तगिए माङ्‌लाइङ्‌बाल्‍ले़ पिरुसिआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","आल्‍ल मोसारे़ साप्‍तुबा साम्‌योथिम् साप्‍लाःल्‍ले़ पाःत्तुबा कुइसिःक् याङ्‌दाङ् फोःङ्‌मा ये़न् त्‍ये़आङ् युसुफ नु मरियमरे़ यरुसले़म्‍मो अङे़ःक्‌वाःन् दाङ्‌बाल्‍लो तोःम्‍मा फाॽआङ् तारे़त्‍छु ");
INSERT INTO lifNT2_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","थेआङ्‌भे़ल्‍ले़ यहवे दाङ्‌बाल्‍ले़ कुसाम्‌योथिम्‍मो तुम्‍बासाहाॽ के़रे़क् दाङ्‌बाओ सेसे लॽरिक् तोःम्‍मासिए पोःङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","हे़क्‍क्‍याङ् यहवे दाङ्‌बाल्‍ले़ कुसाम्‌योथिम् कुइसिःक् कुगाप्‍थिक् पुत्तुःक्‍के इग्र ने़त्‍छि पेरवासाहाॽ सिदुङ्‌जभा चोःक्‍मा फाॽआङ् माङ्‌हिम्‍मो तारे़त्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","आल्‍ल यरुसले़म्‍मो सिमियोन मे़प्‍मनाबा मनाधिक् वये़॥ खे़न् साम्‌योनिबा नु निङ्‌वाॽफुसाम्‍बा वये़॥ खे़ल्‍ले़ इस्राइलिहाॽरे़ खुनिॽ मिक्‌वा के़दुःक्‍पे़न्‌हाङ्‌घुर वये़आङ् सेसेमाङ्‌ङिल्‍ले़ कुधिम् थिम्‍सुआङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","इस्राइलिहाॽरे़ खुनिॽ से़न्‍लप्‍दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌के़निःसुआङ्‌लक् के़मासिङ्लो लॽरिक् सेसेमाङ्‌ङिल्‍ले़ ओसेःन्‍धाक्‍तुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","सेसेमाङ्‌ङिल्‍ले़ लाम्‍लोसुआङ् खुने़ॽ माङ्‌हिम्‍मो तेॽरु॥ खे़प्‍मो युसुफ नु मरियमरे़ साम्‌योथिम् कुइसिःक् अङे़ःक्‌वा ये़सुःन् तोःम्‍मा फाॽआङ् तारे़त्‍छुल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","सिमियोनरे़ कुहुक्‍को अङे़ःक्‌वाःन् पक्‍खुआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःसुर अक्‍खे पाःत्तु, ");
INSERT INTO lifNT2_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“मुक्‍साम्‍दाङ्‌बा आदाङ्‌बाए, आल्‍ल खे़ने़ॽ के़मे़त्ताङ्‌बा कुइसिःक् इङ्‌गाॽ के़सेवारोबान् सनारुङ्‌ङो सिःआनिरो, ");
INSERT INTO lifNT2_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","थेआङ्‌भे़ल्‍ले़ खे़ने़ॽ के़रे़क् मनाहाॽरे़ खुनिॽ तगि यारिप् के़जोगुबा के़से़न्‍लप्‍पिन् इङ्‌गाॽ आबाङे आमिक्‍किल्‍ले़ निःसुङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","खुने़ॽ थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ लागि ओःत्ति ओसेःन्‍गे़धाक्‍पा हे़क्‍क्‍याङ् खुने़ॽग के़रे़क् इस्राइलिहाॽरे़ खुनिॽ मिमिदिङ् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","अङे़ःक्‌वाःल्‍ले़ कुमे़न्‍नो कुम्‍बा कुम्‍मासिरे़ कन् पाःन्‍निन् खे़प्‍से़त्‍छुआङ् साॽरिक् खुन्‍छिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","हे़क्‍क्‍याङ् सिमियोनरे़ खे़ङ्‌हाॽ मुॽइसाम् थाःसु पिरुसिर मरियम्‍मिन् मे़त्तु, “कन् अङे़ःक्‌वाःन् इस्राइल्‍बा यरिक् मनाहाॽरे़ खुनिॽ पोगे़ङ्‌मा नु सबप्‍मारे़न् मिक्‍सेःन् पोःङ्‌ल फाॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेगुआङ् वाॽ, हे़क्‍क्‍याङ् यरिक् मनाहाॽ कुदक्‍ले़ङ्‌वाओ मे़बाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","हे़क्‍केःल्‍ले़ खुनिॽ निङ्‌वाॽ सिगाङ्‌बा पाःन्‍हाॽ थाःप्‍लो॥ हे़क्‍क्‍याङ् तुक्‍खेरे़ खागे़सुक्‍पा ताभेःल्‍ले़ कुइसिःक् के़लुङ्‌माॽइन् लस्‍सुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","हे़क्‍क्‍याङ् खे़प्‍मो आसेर सुवाङ्‌बा फनुए़लरे़ कुस्‍साः हन्‍ना मे़प्‍मनामा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍मा साम्‌योनिमा नु सेवारोमाधिक् वये़॥ खे़न् कुमेःक्‍खिम् पोःक्‍खे़आङ् नुसि (७) तङ्‌बे थारिक् कुये़म्‍बाःन्‍नु सोरिक् वये़त्‍छि हे़क्‍क्‍याङ् कुये़म्‍बाॽइन्‌मासिङ्‌ङाङ् मेमेदुमा पोःक्‍खे़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","खुने़ॽ तङ्‌बे ये़त्‌-लि (८४) के़गे़प्‍मा काप्‍मोमा वये़रो॥ खे़ल्‍ले़ माङ्‌हिम्‍मिन् आप्‍फाल्‍ले़आङ् मे़ल्‍ले़त्ते से़न्‍दिक् ले़न्‍दिक् चाःने़त् युङे़र तुवा चोगे़र निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसेवा चोगुर वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","खे़न् ये़म्‍मो खे़प्‍मो त्‍ये़आङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरुर इस्राइलिहाॽरे़ खुनिॽ चोःक्‌युम्‍भो के़हाङ्‌बा मनाहाॽ अङे़ःक्‌वाःल्‍ले़ कुमे़न्‍नो मे़त्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","दाङ्‌बाल्‍ले़ साम्‌योथिम् साप्‍लाओ पाःत्तुबा कुइसिःक् मरियम नु युसुफरे़ चोगे़त्‍छुआङ् खे़ङ्‌हाॽ आबाङे पाङ्‌भेॽ गालिल थुम्‍बा नासरत पाङ्‌जुम्‍मो नुःक्‍खे़त्‍छि पेसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","खे़प्‍मो अङे़ःक्‌वाःन् पोःरे़र पेआङ् के़धुम्‍बा पोःक्‍खे़रो॥ खुने़ॽ सिक्‍कुम्‍दिङ् निङ्‌वाॽरे़ कुधिम् वये़, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमुॽइसाम्‍मिन् खुने़ॽ सम्‍दाङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","तङ्‌बे थप्‍मा ये़सुरे़ कुम्‍बा कुम्‍मासि यरुसले़म्‍मो यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मो पेःक्‍मा थिम् कत्ते़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","हे़क्‍क्‍याङ् ये़सुःन् थिक्-ने़त् (१२) तङ्‌बे के़रे़ल्‍ले़ खे़ङ्‌हाॽ याम्‍मो तङ्‌नाम्‍मो मे़बे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","खे़न् तङ्‌नाम्‍मिन् पेआङ् खे़ङ्‌हाॽ हिम्‍मो नुःङ्‌मा मे़हेःक्‍ते़, कर ये़सुःन् यरुसले़म्‍मोए वये़लारे़॥ कन् पाःन्‍निन् ये़सुरे़ कुम्‍बा कुम्‍मासिरे़ निङ्‌वाॽ मे़घोःसे़त्‍छुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","खे़ङ्‌हाॽरे़ तगि के़बेःक्‍पा लाम्‍दिःक्‍साबाहाॽनु पेबिला फाॽआङ् इःत्ते़त्‍छु॥ थिक् ये़न्‍बा लाम्‍दिःक् मे़जोगे़आङ् खुन्‍छिॽ काॽइ सोॽधोःक् नु तेःङ्‌जुम्‍हाॽओ ये़सुःन् कोःप्‍मा हेःक्‍ते़त्‍छु, ");
INSERT INTO lifNT2_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","कर मे़दुमे़त्‍छुन्‍नाङ् ने़प्‍माङ् कुगोःत्‍छे़ यरुसले़म्‍मो नुःक्‍खे़त्‍छि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","सुम् ये़न्‍नो ये़सुःन् माङ्‌हिम्‍मो यहुदि सिक्‍साम्‍बाहाॽ खे़प्‍सुसिर पाःन् सेःन्‍दोसुसिर युङे़बा तुमे़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","खुने़ॽ कुइःत्‍छिङ्‌साम् नु पिरुसिबा नोगप् के़घे़म्‍बा मनाहाॽरे़ साॽरिक् खुनिॽ निङ्‌वाॽ मये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","हे़क्‍क्‍याङ् कुम्‍बा कुम्‍मासिरे़ खुने़ॽ निःसे़त्‍छुआङ् खुन्‍छिॽ निङ्‌वाॽ मये़॥ कुम्‍मारे़ खुने़ॽ मे़त्तु, “आस्‍साःए, खे़ने़ॽ थेआङ् अक्‍खे याप्‍मि के़जोगे़बाबे? आन्‍छिगे़ निङ्‌साम्‍मो थ्‍ये़सिगे़आङ् कोःत्‍ने़त्‍छिगे़ मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ये़सुरे़ सेःन्‍दोसुसि, “पानुदिङ्‌आम्‍बौ आम्‍मौ, थेआङ् याप्‍मि के़गोःत्‍छिबाबे? इङ्‌गाॽ पानुदिङ् आम्‍बारे़ कुहिम्‍मो वाॽमा पोःङ् फाॽआङ् खिन्‍छिॽ के़न्‍निःसे़त्‍छुन्बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","कर कन् पाःन्‍निन् खे़ङ्‌हाॽरे़ कुसिङ् मे़निःत्ते़त्‍छुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","हे़क्‍क्‍याङ् खुने़ॽ कुम्‍बा कुम्‍मासिनु नासरतओ पे॥ खुने़ॽग कुम्‍बा कुम्‍मासिरे़ खुन्‍छिॽ पाःन् के़घे़म्‍बा वये़॥ कुम्‍मारे़ कन् के़रे़क् पाःन्‍हाॽ कुनिङ्‌वाॽ सिगाङ् युक्‍खुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","अक्‍खेलॽरिक् ये़सुःन् सिक्‍कुम्‍दिङ् निङ्‌वाॽ नु नासिङ्‌गे़न् थक्‍को निङ्‌वाॽफुमाङ् हे़क्‍क्‍याङ् मे़न्‍छाम् याप्‍मिरे़ खुनिॽ लुङ्‌गुम्‍मो पोःरे़र पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","आल्‍ल रोमि पयम् हाङ् तिबेरियसे़ल्‍ले़ हाङ् चोगुबा तङ्‌बे थिक्-ङा (१५) के़रे़आङ् वये़ल्‍ले़ पन्‍तियस पिलातसे़न् यहुदियाबा सुहाङ्‌गे़म्‍बा वये़॥ खे़न् ये़म्‍मो हे़रोदे़न गालिलस्‍मा सुहाङ्‌गे़म्‍बा, कुन्‍साॽ फिलिप्‍पे़न्‌इतुरिया नु त्राकोनितिस थुम्‍मोबा सुहाङ्‌गे़म्‍बा, हे़क्‍क्‍याङ् लिसानियासे़न् एबिलेनि थुम्‍मोबा सुहाङ्‌गे़म्‍बा मे़वये़, ");
INSERT INTO lifNT2_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","हे़क्‍क्‍याङ् हन्‍नासे़न् नु कैयाफासे़न् मानिङ्‌वाॽफुसाम्‍बा वये़त्‍छि॥ खे़न् ये़म्‍मो एःक्‍सादे़न्‍नो जकरियारे़ कुस्‍साः युहुन्‍नाःल्‍लो निङ्‌वाॽफु पाःन्‍जाक्‍किन् त्‍ये़आङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","खुने़ॽ यर्दन यङ्‌घङ् खिरिबा लाजेॽओ खाराक् लाम्‍दिःक् चोगे़र लायोलाम् हिन्‍दे़म्‍मे़ॽआङ् बप्‍तिस्‍मा पोःक्‍खे़म्‍मे़ॽ, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽ लायोःन् ले़प्‍मि के़बिरिॽ लॽरिक् इङ्‌भन् चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","हे़क्‍केलॽरिक् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ कुसाप्‍पन्‍नो युहुन्‍नारे़ कुयाःम्‍बेओ साप्‍ते़आङ् पत्, “खुने़ॽ एःक्‍सादे़न्‍नो अक्‍खेलॽरिक् के़अःक्‍पा इक्‍लारो, ‘दाङ्‌बाल्‍ले़ कुमाराम्‍मिन् यारिप् चोगे़म्‍मे़ॽआङ् कुलाम्‍हाॽ तोःन्‍दोःन्‌चोगे़म्‍मे़ॽ! ");
INSERT INTO lifNT2_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","के़रे़क् ने़वालाहाॽ लुप्‍सिङ्‌ल, कोःक्‍मा फाङ्‌जङ्‌हाॽ तङ्‌ङाङ् ते़ःम्‍बे पोःङ्‌ल हे़क्‍क्‍याङ् इःलाम्‍हाॽ तोःन्‍छिङ्‌ल ताप्‍फे़ःम्‍बा लाम्‍हाॽ नुःबा पोःङ्‌ल॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","हे़क्‍केलॽरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पिरुसिबा कुसे़न्‍लप्‍पिन् के़रे़क् मे़न्‍छाम्‍गे़न् याप्‍मिहाॽरे़ मे़निःसुॽरो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","मनाहाॽ युहुन्‍नालाम् बप्‍तिस्‍मा पोःङ्‌से़ खे़ॽयो मे़द्‌ये़॥ युहुन्‍नारे़ खे़ङ्‌हाॽ अक्‍खे मे़त्तुसिर फे़ःक्‍तुसि, “असेःक्‍सासे, खिनिॽ कन् के़दाःबार के़बप्‍पा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुघुम्‍दिङ्‌लाम् खे़त्‍छिङ्‌ङे़म्‍मे़ॽ फाॽआङ् हाःत्‍ले़ के़मे़त्तिबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","लायोलाम् के़हिन्‍दिबा पाःन्‍निन् ओसेःन्‍दाङ् चोःक्‍से़ नुःबा याःम्‍बक् चोगे़म्‍मे़ॽओ॥ आनिगे़ग अब्राहामरे़ कुस्‍साःसिगे़, खे़ल्‍ले़ चोगुल्‍ले़ खुम्‍दिङ्‌लाम् खे़त्‍छिङ्‌मा सुक्‍तिगे़ॽ फाॽआङ् निङ्‌वाॽ मे़इःत्ते़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ग कन् लुङ्‌हाॽआङ् अब्राहामरे़ कुस्‍साः चोःक्‍मा सुक्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","आल्‍लोसा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुघासे़न्‍निल्‍ले़ तःन्‍दिङ्‌ग सिङ्‌बुङ्‌मो खा चुक्‍मा इःत्ते़आङ् वाॽ॥ नुःबा सिङ्‌सेॽ मे़न्‍धोःक्‍मनाबा सिङ्‌बुङ्‌हाॽ के़रे़क् ताङ्‌माआङ् मिओ लाप्‍फुमा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","मनाहाॽरे़ खुने़ॽ सेःन्‍मे़दोसु, “हे़क्‍केग्र आल्‍लो आनिगे़ थे चोगुम्‍बे़बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","युहुन्‍नारे़ नोगप् पिरुसि, “हाःत्‍ले़ ने़त्‍छि चाङ् कत्तुॽ, खे़ल्‍ले़ मे़ङ्‌गप्‍मनाबान् लत्‍छा पिरुर, हे़क्‍क्‍याङ् हाःत्‍ले़ चामा कत्तुॽ, खे़ल्‍ले़ चामा मे़ङ्‌गप्‍मनाबान्‍नु हाःसु चर॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","हे़क्‍क्‍याङ् एःङ्‌याङ् के़भोःङ्‌बाहाॽआङ् खे़ॽयो बप्‍तिस्‍मा पोःङ्‌से़ मे़द्‌ये़आङ् युहुन्‍नाःन् सेःन्‍मे़दोसु, “सिक्‍साम्‍बे, आल्‍ल आनिगे़ग थे चोगुम्‍बे़बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","युहुन्‍नारे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ रोमि थिम्‍मो साप्‍ते़आङ् के़बप्‍पाआङ्‌धो मनाहाॽलाम् यरिक् एःङयाङ्‌मे़भोःक्‍खे़म्‍मिन्‍ने़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","हे़क्‍क्‍याङ् थक्‍सुबाहाॽआङ् खे़ॽयो मे़द्‌ये़आङ् “आनिगे़ग?” फाॽआङ् सेःन्‍मे़दोसुरो॥ खे़ङ्‌हाॽ युहुन्‍नारे़ अक्‍खे मे़त्तुसि, “खिनिॽआङ् वेॽ मनाहाॽलाम् साक्‍के़ल्‍ले़क् नु इङ्‌ले़क्‍लाम्‌याङ् मे़भोःक्‍खे़म्‍मिन्‍ने़ॽ, कर के़घोःसुम्‍बा फाॽयाङ्‌ङो खिनिॽ निङ्‌वाॽ तासे़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","हे़क्‍क्‍याङ् मनाहाॽरे़ खुनिॽ निङ्‌वाॽबो ताः लॽरिक् मे़हाङ्‌घुर निङ्‌साङ् मे़जोगुबा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़ङ्‌ग बा कन् मे़ःम्‍बि फाॽआङ् खुनिॽ निङ्‌वाॽबो मे़मे़त्‍छिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","युहुन्‍नारे़ खे़ङ्‌हाॽ के़रे़क् नोगप् पिरुसि, “इङ्‌गाॽग खिनिॽ च्‍वाःत्तिल्‍ले़ बप्‍तिस्‍मा पिनिङ्, कर इङ्‌गाॽनुःल्‍ले़ मुक्‍साम्‍साबाधिक् तार पत्॥ इङ्‌गाॽग योःक् कुइसिःक् कुलाङ्‌सुःप्‌नाम्‍हाॽ फाःङ्‌माआङ् मे़लाॽआन्‍लो॥ खुने़ॽग सेसेमाङ् नु मिःल्‍ले़ बप्‍तिस्‍मा के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","कुभॽएःत्तिल्‍ले़ सिःन् आःम्‍मा फाॽआङ् खुने़ॽ यारिप् वाॽ, हे़क्‍क्‍याङ् खुने़ॽ तुगुर सुप्‍सुआङ्‌सिःन् चाधोःक्‍लाओ चिक्‍खुॽ हे़क्‍क्‍याङ् कुहक्‍हाॽ आप्‍फाल्‍ले़आङ् मे़न्‍छिःमनाबा मिओ हाःन्‍दुदेःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","हे़क्‍केलॽरिक् खुने़ॽ यरिक् परिक्‍ले़न् सिक्‍कुम्‍दिङ् खाहुन्‍हाॽ पिरुसिर सुनाइङ् इङ्‌भन् से़ःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","कर युहुन्‍नारे़ सुहाङ्‌गे़म्‍बा हे़रोदे़न फे़ःक्‍तु, थेआङ्‌भे़ल्‍ले़ खुने़ॽ कुअङे़ःक्‍मा हे़रोदियासे़न् मेःक्‍खिम् मे़त्तुआङ् वये़, हे़क्‍क्‍याङ् वेॽ यरिक् फे़न् याःम्‍बक्‍हाॽआङ् चोगुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","हे़रोदरे़ युहुन्‍नाःन् पुङ्‌लाहिम्‍मो साक्‍तुआङ्‌आल्‍लसाङ् यरिक् फे़न् याःम्‍बक्‍किन् योॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","थिक्‌ये़न् काक् मनाहाॽ बप्‍तिस्‍मा मे़बोःक्‍खे़ल्‍ले़ ये़सुःन्‍नाङ् बप्‍तिस्‍मा पोःक्‍खे़॥ हे़क्‍क्‍याङ् खुने़ॽ तुवा चोगुर पत्‍छे़ल्‍ले़ ताङ्‌साक्‍पे़न्‌हरे़आङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","सेसेमाङ्‌ङिन् पुत्तुःक्‍के हे़क्‍के ये़आङ् खुने़ॽ कुसम्‍दाङ् चुक्‍ते़, हे़क्‍क्‍याङ् साङ्‌ग्राम्‍पेदाङ्‌ङोलाम् इक्‍लाधिक् ये़, “खे़ने़ॽ इङ्‌गाॽ आमिःम् आस्‍साःने़रो॥ खे़ने़ॽनु इङ्‌गाॽ साॽरिक् सःत्ताङ्‌ङाङ् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","आल्‍ल ये़सुरे़ माङ्‌सेवा याःम्‍बक् चोःक्‍मा हेःक्‍तुल्‍ले़ खुने़ॽ तङ्‌बे सुम्‍बोःङ् (३०) के़रे़आङ् वये़॥ खुने़ॽ मे़न्‍छाम् याप्‍मिहाॽरे़ मे़इःत्तुबा कुइसिःक् युसुफरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","युसुफे़न् हे़लिरे़ कुस्‍साः, हे़लिःन् मतातरे़ कुस्‍साः, माताते़न् ले़बिरे़ कुस्‍साः, ले़बिःन् मे़ल्‍चिरे़ कुस्‍साः, मे़ल्‍चिःन् जन्‍नैरे़ कुस्‍साः, जन्‍नैःन् युसुफरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","युसुफे़न् मत्ताथियासरे़ कुस्‍साः, मत्ताथियासे़न्‌आमोसरे़ कुस्‍साः, आमोसे़न् नाहुमरे़ कुस्‍साः, नाहुम्‍मिन् इस्‍लिरे़ कुस्‍साः, इस्‍लिःन् नग्‍गाइरे़ कुस्‍साः, ");
INSERT INTO lifNT2_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","नग्‍गाइन् माथरे़ कुस्‍साः, माथे़न् मत्ताथियासरे़ कुस्‍साः, मत्ताथियासे़न्‌सेमैनरे़ कुस्‍साः, सेमैने़न् योसे़खरे़ कुस्‍साः, योसे़खे़न् योदारे़ कुस्‍साः वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","योदाःन् योआनरे़ कुस्‍साः, योआने़न् रेसारे़ कुस्‍साः, रेसाःन् यरुबाबे़लरे़ कुस्‍साः, यरुबाबे़ल्‍ले़न् सालतिएलरे़ कुस्‍साः, साल्‍तिएल्‍ले़न् नेरिरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","हे़क्‍क्‍याङ् नेरिःन् मे़ल्‍किरे़ कुस्‍साः, मल्‍किःन् अद्दिरे़ कुस्‍साः, अद्दिःन् कोसामरे़ कुस्‍साः, कोसाम्‍मिन् एलमातमरे़ कुस्‍साः, एलमातम्‍मिन् एरे़ल्‍ले़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","हे़क्‍क्‍याङ् एरे़न् यहोसुरे़ कुस्‍साः, यहोसुःन् एलिएजरले़ कुस्‍साः, एलिएजरे़न् योरिम्‌रे़ कुस्‍साः, योरिम्‍मिन् मातातरे़ कुस्‍साः, माताते़न् ले़बिरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","हे़क्‍क्‍याङ् ले़बिःन् सिमियोनरे़ कुस्‍साः, सिमियोने़न् यहुदाःल्‍ले़ कुस्‍साः, यहुदाःन् युसुफरे़ कुस्‍साः, युसुफे़न् योनामरे़ कुस्‍साः, योनाम्‍मिन्‌एलियाकिमरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","एलियाकिम्‍मिन् मलेआरे़ कुस्‍साः, मलेआःन् मिन्‍नारे़ कुस्‍साः, मिन्‍नाःन् मत्ताथारे़ कुस्‍साः, मत्ताथाःन् नातानरे़ कुस्‍साः, नाताने़न् दाउदरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","हे़क्‍क्‍याङ् दाउदे़न् यिसैरे़ कुस्‍साः, यिसैःन् ओबेदरे़ कुस्‍साः, ओबेदे़न् बोअजरे़ कुस्‍साः, बोअजे़न् सल्‍मोनरे़ कुस्‍साः, साल्‍मोने़न् नहसोनरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","नहसोने़न् अम्‍मिनादाबरे़ कुस्‍साः, अम्‍मिनादाबे़न् आरामरे़ कुस्‍साः, आराम्‍मिन् हे़स्रोनरे़ कुस्‍साः, हे़स्रोने़न् पेरेजरे़ कुस्‍साः, पे़रे़जे़न् यहुदाःल्‍ले़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","यहुदाःन् याकुबरे़ कुस्‍साः, याकुबे़न् इसहाकरे़ कुस्‍साः, इसहाक्‍किन् अब्राहामरे़ कुस्‍साः, अब्राहाम्‍मिन् तेरहरे़ कुस्‍साः, तेरहःन् नाहोरले़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","हे़क्‍क्‍याङ् नाहोरे़न् सरुगरे़ कुस्‍साः, सरुग्‍गे़न् रउरे़ कुस्‍साः, रउःन् पेलेगरे़ कुस्‍साः, पेले़गे़न् एबे़ररे़ कुस्‍साः, एबे़रे़न् से़लहरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","हे़क्‍क्‍याङ् से़लहःन् कैनानरे़ कुस्‍साः, कैनाने़न् आर्पक्‍छदरे़ कुस्‍साः, आर्पक्‍छदे़न् से़मरे़ कुस्‍साः, से़म्‍मिन् नुहारे़ कुस्‍साः, नुहाःन्‌ले़मे़खरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","हे़क्‍क्‍याङ् ले़मे़क्‍खे़न् मतुसेलहरे़ कुस्‍साः, मतुसेलहःन् हनोकरे़ कुस्‍साः, हनोक्‍के़न् ये़रे़दरे़ कुस्‍साः, ये़रे़दे़न्‌महलाले़लरे़ कुस्‍साः, महलाले़न्‌कैनानरे़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","केनाने़न् एनोसरे़ कुस्‍साः, एनोसे़न् सेतरे़ कुस्‍साः, सेते़न् आदमरे़ कुस्‍साः, आदम्‍मिन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुस्‍साः वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ये़सुःन् सेसेमाङ्‌ङिल्‍ले़ थुक्‍तुआङ् यर्दन यङ्‌घङ्‌लाम् पे, हे़क्‍क्‍याङ् सेसेमाङ्‌ङिल्‍ले़ एःक्‍सादे़न्‍नो लाम्‍लोसुआङ् तेॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","खे़प्‍मो लिबोःङ्‌ये़न् (४०) थारिक् वये़ल्‍ले़ माफे़न्‍साम्‍मिल्‍ले़ खुने़ॽ लायो चोःक्‍पाङ्‌मा फाॽआङ् कुनिङ्‌वाॽ साॽरु॥ खे़न् ये़म् खाराक् खुने़ॽ थेआङ् मे़जने़न्, हे़क्‍क्‍याङ् खे़न् एगाङ् कुसे़त्‍लाःक्‍ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","खे़प्‍मो माफे़न्‍साम्‍मिन् त्‍ये़आङ् मे़त्तु, “खे़ने़ॽ निङ्‌वाॽफुसाःने़ फाॽग्र कन् लुङ्‌ङिन् खरे़ःङ् पोःक्‍खे़ॽ फाॽआङ् मे़त्ते़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ये़सुरे़ खे़न् मे़त्तु, “हे़क्‍के मे़जोःक्‍कान्, थेआङ्‌भे़ल्‍ले़ साम्‌योसाप्‍लाओ मोसारे़ अक्‍खेलॽरिक् साप्‍तुआङ् पत्, ‘मे़न्‍छाम् याप्‍मिःङ्‌ग कुजाःल्‍ले़रक् मे़हिङ्‌ने़न्‌॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","हे़क्‍क्‍याङ् माफे़न्‍साम्‍मिल्‍ले़ खुने़ॽ थाःङ् कोःक्‍माल्‍ले़ कुसम्‍मो तेॽरुआङ् मिक्‍चिराप्‍पो इक्‍सादिङ् खाम्‍बेःक्‍मोबा के़रे़क् हाङ्‌जुम्‍हाॽ ओसेःन्‍धाक्‍तुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","मे़त्तु, “कन् याङ्‌साकुन्‍धेहाॽ नु के़रे़क् युक्‍हाॽ इङ्‌गाॽ पिमा सुक्‍ने़ॽरो, थेआङ्‌भे़ल्‍ले़ कन् सम्‍दाङ् युक् खोःसुङ्‌ङाङ् वाॽआ, हे़क्‍क्‍याङ् आसिराॽ के़धाङ्‌बे़न् आत्तिन्‍छाङ् पिमा सुक्‍तुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","खे़ने़ॽ साम्‍बोःन् के़भन्‍छिङ्‌ङाङ् सेवा के़मे़त्ताने़ फाॽग्र के़रे़क् खे़ने़ॽइन् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ये़सुरे़ खुने़ॽ मे़त्तु, “साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् पत्, ‘खे़ने़ॽ दाङ्‌बा के़निङ्‌वाॽफुमाङ्‌ङिन्‍लक् सेवा चोगे़ॽ हे़क्‍क्‍याङ् खुने़ॽइन्‍लक् माङ्‌सेवा याःम्‍बक् चोगे़ॽओ॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","हे़क्‍क्‍याङ् माफे़न्‍साम्‍मिल्‍ले़ खुने़ॽ यरुसले़म्‍मो तेॽरुआङ् माङ्‌हिम्‍मोबा काक्‍नुःल्‍ले़ केःम्‍बा चम्‍जम्‍बा ते़न्‍नो ये़प्‍सुआङ् मे़त्तु, “खे़ने़ॽ से़क्‍खाए निङ्‌वाॽफुसाःने़ फाॽग्र, कप्‍मोलाम् यो पिन्‍दे़ थ्‍ये़ॽ, ");
INSERT INTO lifNT2_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","थेआङ्‌भे़ल्‍ले़ साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् पत्, ‘निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमाङ्‌लाइङ्‌बाहाॽ इङ्‌जाःङ् पिरुसिआङ् खे़ङ्‌हाॽरे़ खे़ने़ॽ कम्‍ब्राङ् के़म्‍मे़त्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","हे़क्‍क्‍याङ् ‘खे़ङ्‌हाॽरे़ खे़ने़ॽ थाःङ् थाःङ्‌ङे खुनिॽ हुक्‍को के़म्‍दाःक्‍काङ् खे़ने़ॽ के़लाङ्‌ङिन् लुङ्‌ङो मे़धाम्‍सिङ्‌ङिन्‍लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ये़सुरे़ नोगप् पिरु, “कर साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् पत्, ‘दाङ्‌बा के़निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिङ्‌वाॽ मे़साॽरे़न्‍ने़ॽओ॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","हे़क्‍क्‍याङ् माफे़न्‍साम्‍मिल्‍ले़ कुनिङ्‌वाॽ साॽरु सुरुआङ् सप्‍फारे़ लागि याम्‍मो सुये़म् मे़ङ्‌घोए थारिक् खुने़ॽ ले़रुधआङ् पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","सेसेमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍मिल्‍ले़ कुधिम् पोःक्‍खे़आङ् ये़सुःन् गालिल थुम्‍मो नुःक्‍खे़॥ खुने़ॽ खे़प्‍मो त्‍ये़बा इङ्‌घङ्‌ङिन् खिरिबा काक् लाजेॽओ से़ःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","हे़क्‍क्‍याङ् खुने़ॽ खे़न् थुम्‍मोबा यहुदि चुम्‍लुङ्‌हिम्‍हाॽओ पेर हुॽरुसिल्‍ले़ के़रे़क्‍ले़ कुनारा मे़भोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","हे़क्‍क्‍याङ् ये़सुःन् पोःरे़आङ् थाङ्‌बे़न् के़रे़बा नासरत पाङ्‌जुम्‍मो त्‍ये़॥ खुने़ॽ कुये़प्‍ले़क् कुइसिःक् नाःम्‍सिङ्‌ये़न्‍नो यहुदि चुम्‍लुङ्‌हिम्‍मो पेआङ् साम्‌योसाप्‍लाःन् निःप्‍मा फाॽआङ् ये़म्‍सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","खे़प्‍मो के़वाॽबा साम्‌योसाप्‍ला के़गप्‍पाहाॽरे़ खुने़ॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ साप्‍तुबा साम्‌योसाप्‍लाःल्‍ले़ कुगित्‍नाःन् मे़बिरु, हे़क्‍क्‍याङ् खुने़ॽ खे़न् फाःक्‍खुआङ् अक्‍खेलॽरिक् के़बप्‍पे़न्‌खोःसुआङ् निःरु– ");
INSERT INTO lifNT2_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","“दाङ्‌बाल्‍ले़ कुसेसेमाङ्‌ङिन् इङ्‌गाॽ आसम्‍दाङ् वाॽ, थेआङ्‌भे़ल्‍ले़ याङ्‌गे़साॽबाहाॽ सुनाइङ् इङ्‌भन् चोःक्‍से़ माङ्‌धोःक्‍ना पिराङ्‌ङाङ् वाॽआरो॥ खुने़ॽ साक्‍पा के़धाःबाहाॽ चोःक्‌युम्‍भोरे़न् इङ्‌भन् चोःक्‍से़, मिक्‍फःम्‍बाहाॽरे़ खुनिॽ मिक्‍साःन् वेःम्‍मा इङ्‌भन् चोःक्‍से़, हे़क्‍क्‍याङ् एप्‍ले़क्‍खे़ओ के़वाॽबाहाॽ चोःक्‌युम्‍भो पिसे़ नु दाङ्‌बाल्‍ले़ कुलुङ्‌गुम्‍मिल्‍ले़ तङ्‌बेल्‍ले़न् इङ्‌भन् चोःक्‍से़ इङ्‌गाॽ पाङ्‌घाङ्‌ङाङ् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","हे़क्‍क्‍याङ् खुने़ॽ खे़न् साम्‌योसाप्‍लाःन् सुबुआङ् खे़प्‍मो के़ये़प्‍पे़न्‌पिरु, हे़क्‍क्‍याङ् खुने़ॽ युङ्‌सिङ्॥ हे़क्‍क्‍याङ् के़रे़क्‍ले़ खुने़ॽ ओमे़मे़त्तुल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","खे़ङ्‌हाॽ अक्‍खे मे़त्तुसि, “आइन् कन् के़घे़प्‍सुम्‍मिल्‍ले़ साम्‌योसाप्‍लाओ के़बप्‍पा पाःन्‍हाॽ खिनिॽओ के़रे़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","हे़क्‍क्‍याङ् खुने़ॽ पाःत्तुबा कुघे़म् के़नुॽबा पाःन्‍हाॽ मे़घे़प्‍सुआङ् के़रे़क्‍ले़ कुनारा मे़भोःसु, हे़क्‍क्‍याङ् खुनिॽ निङ्‌वाॽ मये़र अक्‍खे मे़मे़त्‍छिङ्, “कङ्‌ग युसुफरे़ कुस्‍साः मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “निस्‍सेसाङ् खिनिॽ कन् खे़दाॽइन् इङ्‌गाॽ आमे़न्‍नो के़बाःत्तुम्‍बिला, ‘सिदाॽसाम्‍बे, तगि खे़ने़ॽ नुसिङ्‌ङे़ॽओ॥’ हे़क्‍केलॽरिक् कपर्नहुम्‍मो के़जोगुबा आनिगे़ खे़प्‍सुम्‍बे़बा हे़क्‍केए कन् के़बाङ्‌जुम्‍मोआङ् चोगे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","कर खुने़ॽ मे़त्तुसि, इङ्‌गाॽ मे़त्‍निङ्, आत्तिन् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्‍नाङ् कुबाङ्‌भेॽसाबाहाॽरे़ मे़न्‍दाःक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","से़क्‍खाए माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलियाःल्‍ले़ कुये़म्‍मो इस्राइलओ यरिक् मेमेदुमाहाॽ मे़वये़॥ खे़न् ये़म्‍मो ताङ्‌साक्‍पे़न्‌तङ्‌बे सुम्‍सिआङ् कुभ्रे़ःङ् थारिक् सुप्‍सिङ्‌ङाङ् पाङ्‌गे़न्‍दिङ् वाहिःत्‌मे़ध्‍ये़ने़न्‍नाङ् खे़न् लाजेॽओ किप्‍मा के़घुःबा यम्‍बा साक् पोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","खे़प्‍मो यरिक् मेमेदुमाहाॽ मे़वये़साङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ एलियाःन् इस्राइलओ मे़ःन्, कर सिदोन थुम्‍मोबा सारफत पाङ्‌जुम्‍मोबा मेमेदुमाल्‍लोरक् पाङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","हे़क्‍केलॽरिक् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलिसाःल्‍ले़आङ् इस्राइलओ यरिक् लोगेॽरे़ तरुसिबा मनाहाॽ मे़वये़साङ् आत्तिन्‍नाङ् मे़नुसुन्, कर सिरियास्‍मा नामाने़न्‍लक् नुसुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","कन् पाःन्‍निन् मे़घे़प्‍सुआङ् यहुदि चुम्‍लुङ्‌हिम्‍मो के़वाॽबा के़रे़क् मनाहाॽरे़ खुनिॽ सिक् पोगे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","खे़ङ्‌हाॽ मे़बोगे़आङ् ये़सुःन् मे़दे़म्‍सुआङ् पाङ्‌जुम् लाःक्‍कात् मे़उःक्‍खु मे़लःत्तु॥ हे़क्‍क्‍याङ् पाङ्‌जुम्‍मिल्‍ले़ कुबेसाङ्‌बा याक्‍केःक्‍कोलाम् लाप्‍फुमा थाःमा फाॽआङ् मनाहाॽरे़ मे़देॽरु, ");
INSERT INTO lifNT2_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","कर मनालुम्‍मोलाम् खुने़ॽ फिःन्‍छिङ्‌ङाङ् लःन्‍दे़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","हे़क्‍क्‍याङ् खुने़ॽ गालिल थुम्‍मोबा कपर्नहुम पाङ्‌जुम्‍मो पेआङ् नाःम्‍सिङ्‌ये़न्‍नो खे़प्‍मोबा यहुदि चुम्‍लुङ्‌हिम्‍मो मनाहाॽ हुॽमा हेःक्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","खुने़ॽ कुनिसाम्‍मिन् मे़घे़प्‍सुआङ् खे़प्‍मोबा मनाहाॽरे़ साॽरिक् खुनिॽ निङ्‌वाॽ मये़, थेआङ्‌भे़ल्‍ले़ ये़सुःन् युक् के़गप्‍पा कुइसिःक् पारे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","खे़प्‍मो यहुदि चुम्‍लुङ्‌हिम्‍मो फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबा मनाधिक् वये़॥ खे़ल्‍ले़ यम्‍बा इक्‍लाओ अःक्‍ते़र अक्‍खे पाःत्तु, ");
INSERT INTO lifNT2_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“नासरतबा ये़सुए, खे़ने़ॽ आनिगे़नु थे के़गोःत्तुबाबे? खे़ने़ॽ आनिगे़ मे़ङ्‌से़ के़द्‌ये़बाबि? खे़ने़ॽ हाःत्‍ने़बे फाॽआङ् निःसुम्‍बे़रो–खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़बाङ्‌घे़बा सेसे कुमनाने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ये़सुरे़ खे़न् फे़न्‍साम्‍मिन् फे़ःक्‍तु, “स्‍वाःत्! खे़न् मनाःन् ले़रे़ॽआङ् पेगे़ॽ!” हे़क्‍क्‍याङ् खे़न् फे़न्‍साम्‍मिल्‍ले़ खे़न् मनाःन् खुनिॽ तगिए पिर्धाप् थाप्‍सुआङ् मे़ङ्‌घाःन्‍ने ले़रुधःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","हे़क्‍क्‍याङ् काक् मनाहाॽरे़ खुनिॽ निङ्‌वाॽ मये़आङ् अक्‍खे मे़मे़त्‍छिङ्, “कङ्‌ग आक्‍तङ्‌बा निसाम्बे? कन् मनाःल्‍ले़ग युक् नु मुक्‍साम्‍मिल्‍ले़ फे़न्‍साम्‍हाॽ इङ्‌जाःङ् पिरुसिल्‍ले़ मे़लःन् मे़बेःक्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","कन् इङ्‌घङ्‌ङिन् खे़न् थुम्‍मो के़रे़क् पिसाङ् से़ःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","हे़क्‍क्‍याङ् ये़सुःन् यहुदि चुम्‍लुङ्‌हिम्‍मोलाम् सिमोनरे़ कुहिम्‍मो पे॥ सिमोनरे़ कुन्‍नोःप्‍मे़न् तुङ्‌ङिल्‍ले़ तरुआङ् ने़स्‍से़, हे़क्‍क्‍याङ् मनाहाॽरे़ खे़ल्‍ले़ कुमे़न्‍नो ये़सुःन् मे़मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ये़सुःन् के़दुक्‍माल्‍ले़ कुने़त्‍नाःल्‍ले़ कुबेसाङ् पेआङ् खे़न् तुङ् तुक्‍मान् फे़ःक्‍तु, हे़क्‍क्‍याङ् खिमो सिमोनरे़ कुन्‍नोःप्‍मे़न् नुरे़आङ् खे़ङ्‌हाॽ तरे तोःसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","हे़क्‍क्‍याङ् नाम्‍ध्‍ये़आङ् मनाहाॽरे़ यरिक् परिक्‍पा तुक्‍माल्‍ले़ तरुसिबा मनाहाॽ ये़सुओ मे़दारुसि॥ ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ सम्‍दाङ् हुक् ने़स्‍सुबिरुसिआङ् नुसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","हे़क्‍क्‍याङ् फे़न्‍साम्‍हाॽग अक्‍खे मे़बाःत्तुर मे़लःन्‍दे़ मे़बेरो, “खे़ने़ॽग निङ्‌वाॽफुसाःने़रो॥” कर ये़सुरे़ खे़ङ्‌हाॽ फे़ःक्‍तुसिर पाःप्‍मा मे़बाङ्‌घुन्‍सिन्, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽए निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरो फाॽआङ् मे़निःसुआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","हे़क्‍क्‍याङ् तानाम्‍सा ये़सुःन् एःक्‍सादे़न्‍नो पे, कर मनाहाॽरे़ खुने़ॽ आत्तो वाॽबे फाॽआङ् मे़गोःत्तु॥ खुने़ॽ मे़दुमुआङ् खुनिॽनुए वाॽर फाॽआङ् साक्‍मा मे़गोःत्तुरो, ");
INSERT INTO lifNT2_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽग कन् निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़न् सुनाइङ्‌ङिन् वेॽस्‍मा पाङ्‌जुम्‍हाॽओआङ् इङ्‌भोःमाए पोःङ्‌लो॥ इङ्‌गाॽग बा खे़ल्‍ले़ लागिए निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाङ्‌घाङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","हे़क्‍केःल्‍ले़ ये़सुरे़ यहुदिया थुम्‍मोबा यहुदि चुम्‍लुङ्‌हिम्‍हाॽओ पेआङ् सुनाइङ् से़ःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","थिक् ये़न् ये़सुःन् गने़सरे़त वाहङ्‌ङिल्‍ले़ कुयाओ सुनाइङ् से़ःसुर ये़बे़ल्‍ले़ खे़प्‍मो मनाहाॽ निङ्‌वाॽफु पाःन्‍जाक्‍किन् खे़म्‍से़ मे़द्‌ये़आङ् खुने़ॽ चिबुःत् मे़बन्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","खे़प्‍मो कुयाओ ने़त्‍छि खःङ्‌बेहाॽ ये़सुरे़ निःसुसि, कर कुबेसाङ् योःङ्‌गे़ले़प्‍पाहाॽ खुनिॽ योःङ् वाहप्‍नु मे़यागे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ये़सुःन् सिमोनरे़ कुघःङ्‌बेओ लाःसे़आङ् मिसाक् कुदिःम्‍बे केःम्‍बाओ तेॽबाङ्‌घु, हे़क्‍क्‍याङ् खे़प्‍मो युङ्‌सिङ्‌ङाङ् मनाहाॽ हुॽरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","खुने़ॽ पाःप्‍मा सुरुआङ् सिमोने़न् मे़त्तु, “खःङ्‌बेन् ना कुदिःम्‍बे केःम्‍बाओ तेॽरे़आङ् योःङ्‌ङिन् ले़प्‍ते़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","हे़क्‍केःल्‍ले़ सिमोनरे़ नोगप् पिरु, “आदाङ्‌बे, आनिगे़ग नाम्‍दाःत्ताःत् योःङ् ले़प्‍मनासाङ् ङाधिक्‍काङ् मे़याङ्‌घुम्‍बे़न्‍लो, हे़क्‍केसाङ् खे़ने़ॽ के़बाःत्तुबा हे़क्‍के ले़प्‍तुङ्‌साॽरुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","हे़क्‍क्‍याङ् खुने़ॽ पाःत्तुबा हे़क्‍के योःङ्‌ङिन् ले़प्‍तुल्‍ले़ यरिक् ङाहाॽ मे़ध्‍ये़आङ् योःङ्‌ङिन्‍ने ते़ःङ्‌मा इःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ वेॽ खुनिॽ तेःङ्‌जुम्‍हाॽ वेॽ खःङ्‌बेन् फे़त्ते़म्‍मे़ॽआङ् आभाॽरे़म्‍मे़ॽओ लॽरिक् हुक्‍चाःल्‍किःल्‍ले़ मे़उःत्तुसि॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़भे़रे़आङ् ने़प्‍माङ् खःङ्‌बेहाॽ ङाःल्‍ले़ तिम्‍से़आङ् निःम्‍मा इःत्ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","सिमोन पत्रुसरे़ कन् निःसुआङ् ये़सुरे़ कुदगि थुङ्‌बोहजॽ युङ्‌सिङ्‌ङाङ् मे़त्तु, “आदाङ्‌बे, इङ्‌गाॽग साॽरिक् लायोबा मनाआरो, खे़ने़ॽनु वाॽमा मे़लाॽआन्‍लो, ले़राङ् थ्‍याङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","थेआङ्‌भे़ल्‍ले़ सिमोन नु कुन्‍जुम्‍हाॽरे़ मे़धासुसिबा ङाहाॽ मे़इःत्तुआङ् साॽरिक् खुनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","सिमोनरे़ कुन्‍जुम् जब्‍दियारे़ कुस्‍साःहाॽ याकुब नु युहुन्‍नासिरे़आङ् खुन्‍छिॽ निङ्‌वाॽ मये़॥ ये़सुरे़ सिमोने़न् मे़त्तु, “खे़ने़ॽ मे़गिसे़न्‍ने़ॽ, ङा के़दे़म्‍सुबा हे़क्‍केए आल्‍लआङ्‌धो निङ्‌वाॽफुहाङ्‌जुम्‍मो मना के़दे़म्‍बा के़दाःप्‍पा के़बोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खःङ्‌बेहाॽ कुयाओ मे़देॽरुसि, हे़क्‍क्‍याङ् के़रे़क् मे़ले़रु मे़धःआङ् ये़सुःन् मे़नाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","थिक् ये़न् ये़सुःन् लत्‍छा पाङ्‌जुम्‍मो वये़ल्‍ले़ लोगेॽरे़ तरुबा मनाधिक् खे़प्‍मो त्‍ये़॥ खे़ल्‍ले़ ये़सुःन् निःसुआङ् कुदगि साम्‍बोःन् फन्‍छिङ्‌ल पेलि फाक्‍तु, “आदाङ्‌बे, खे़ने़ॽ निङ्‌वाॽ के़जोगुने़ फाॽग्र लोगेॽलाम् वेःम्‍मा के़सुक्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ये़सुरे़आङ् कुहुक्‍किन् सन्‍छुआङ् सुःसुर खे़न् मनाःन् अक्‍खे मे़त्तु, “इङ्‌गाॽ के़नुॽर फाॽआङ् निङ्‌वाॽ चोगुङ्‌लो॥” हे़क्‍क्‍याङ् खिमो खे़न् लोगेॽरे़ तरुबा मनाःन् नुःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मनाःन् मे़त्तु, “कन् पाःन्‍निन् हाःत्ताङ् मे़मे़त्ते़न्‍ने़ॽ, कर निङ्‌वाॽफुसाम्‍बाल्‍ले़ के़साॽर फाॽआङ् ओसेःन्‍धाक्‍सिङ्‌ङे़ॽ, हे़क्‍क्‍याङ् मोसारे़ कुसाम्‌योथिम् कुइसिःक् मनाहाॽ नुःराङ् फाॽआङ् ओसेःन्‍धाक्‍मासिरे़ लागि सिदुङ्‌जभा चोगे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","करसाङ् कन् पाःन्‍निन् काक् पिसाङ् से़ःरे़आङ् ये़सुरे़ कुबाःन् खे़म्‍से़ नु खुनिॽ तुक्‍मा यॽमालाम् नुसिङ्‌से़ यरिक् मनाहाॽ ये़सुओ मे़द्‌ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","कर ये़सुःन् ए़त्‍ले़ङ् मनालुम्‍मोलाम् से़न्‍छिङ्‌ङाङ् तुवा चोःक्‍से़ एःक्‍सादे़न्‍नो पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","थिक् ये़न् ये़सुःन् मनाहाॽ खाहुन् हुॽरुसिर युङे़ल्‍ले़ खे़प्‍मो गालिल नु यहुदियास्‍मा यरिक् पाङ्‌जुम्‍मोलाम् हे़क्‍क्‍याङ् यरुसले़मलाम् फरिसिहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽआङ् मे़द्‌ये़आङ् खाहुन् मे़घे़प्‍सुर मे़युङे़॥ ये़सुरे़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ वेःम्‍मा कुमुक्‍साम्‍मिन् कत्तुआङ् वये़, ");
INSERT INTO lifNT2_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","हे़क्‍क्‍याङ् कुभा मनाहाॽरे़ लङ्‌ले़ःङ्‌वा मनाःन् कुने़त्‍नाःन्‍नुए खे़प्‍मो मे़दारुआङ् ये़सुरे़ कुदगि तेॽमाआङ् ने़मा के़लॽबा निङ्‌वाॽ मे़जोगु, ");
INSERT INTO lifNT2_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","कर खे़प्‍मो ये़सुःन् वये़बा हिम्‍मो यरिक् मनाहाॽरे़ सधे़क्‌मे़धिम्‍सुआङ् मे़युङे़बाल्‍ले़ चोगुल्‍ले़ सिगाङ् तेॽमा मे़न्‍छुक्‍तुन्॥ हे़क्‍केःल्‍ले़ थो खाम्‍बुओ मे़लाःसे़आङ् खाम्‍बुःन् मे़हन्‍दु॥ हे़क्‍क्‍याङ् लङ्‌ले़ःङ्वाःन् कुने़त्‍नानुए मनाहाॽरे़ खुनिॽ लुम्‍मो ये़सुरे़ कुदगि यो मे़होसु मे़धासुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ नसाःन्‍निन् निःसुआङ् खे़न् लङ्‌ले़ःङ्‌वा मनाःन् मे़त्तु, “खे़ने़ॽ के़लायोहाॽ ले़प्‍मि पोःक्‍खे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","हे़क्‍केःल्‍ले़ खे़प्‍मो फरिसिहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ खुनिॽ निङ्‌वाॽबो अक्‍खेलॽरिक् मे़इःत्तु, “कन् मनाःन् हाःप्‍पे? अक्‍खेलॽरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पाःन्‌के़बाःप्‍पा कन् मनाःन् हाःप्‍पे? लायोलाम् ले़प्‍मि पिमाग निङ्‌वाॽफुमाङ्‌ङिन्‍नुःल्‍ले़ वेॽ हाःत्‍ले़आङ् मे़सुक्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽबो थे़मा मे़इःत्तुर मे़युङ् के़लॽबान् ये़सुरे़ निःसुआङ् मे़त्तुसि, “खिनिॽ अक्‍तङ्‌बा थेआङ् के़इःत्तुम्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","कन् लङ्‌ले़ःङ्‌वाःन् ‘के़लायोहाॽ ले़प्‍मि पोःक्‍खे़’ मे़प्‍मा उसुरु चोःक्‍पि? इ ‘पोगे़ॽआङ् के़ने़त्‍नाःन् खप्‍से़ॽआङ् थासिङ्‌ङे़ॽ’ मे़प्‍मा उसुरु चोःक्? ");
INSERT INTO lifNT2_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","कर इक्‍सादिङ् खाम्‍बेःक्‍मो मे़न्‍छाम्‍साःल्‍ले़ लायो ले़प्‍मि पिमा युक् कत्तुॽ फाॽआङ् खिनिॽ कुसिङ् निःत्ते़म्‍मे़ॽओ,” हे़क्‍क्‍याङ् ये़सुरे़ खे़न् लङ्‌ले़ःङ्‌वा मनाःन् मे़त्तु, “खे़ने़ॽ पोगे़ॽआङ् के़ने़त्‍नाःन् याङ्‌सिङ्‌ङे़ॽआङ् के़हिम्‍मो थासिङ्‌ङे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","खिमो खे़न् खुनिॽ तगिए मुत्‍थ्रिक् पोगे़आङ् कुने़त्‍नाःन् याङ्‌सिङ्‌हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःसुर कुहिम्‍मो थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","के़रे़क्‍ले़ खुनिॽ साॽरिक् निङ्‌वाॽ मये़आङ् निङ्‌वाॽफुमाङ्‌ङिन् इङ्‌धाःङ् मे़बिरुर मे़बाःत्तु, “अक्‍तङ्‌बाग आनिगे़ आप्‍फाल्‍ले़आङ् मे़न्‍निए वयिगे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","याङ्‌सि ये़सुःन् खे़प्‍मोलाम् लःन्‍दे़ पेआङ् एःङ्‌याङ् के़भोःङ्‌बा ले़बि मिङ् के़वाःप्‍पा मनाःन् एःङ्‌याङ् फोःङ्‌मा ते़न्‍नो युङे़बा निःसुआङ् मे़त्तु, “इङ्‌गाॽ तिम्‍दाङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","हे़क्‍क्‍याङ् खे़न्‍नाङ् मुत्‍थ्रिक् पोगे़आङ् के़रे़क् पाःन्‍हाॽ ले़रुधआङ् खुने़ॽनु थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","याङ्‌सि ये़सुरे़ कुलागि ले़बिःल्‍ले़ कुहिम्‍मो यम्‍बा चामुक् थिमुक् से़ःसु॥ खे़प्‍मो यरिक् एःङ्‌याङ् के़भोःङ्‌बाहाॽ नु वेॽ तरेबाहाॽ मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","खे़प्‍मो फरिसिहाॽ नु खुनिॽ साम्‌योथिम्‍साम्‍बाहाॽ मे़द्‌ये़आङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ मने़ मे़धिक्‍ते़र अक्‍खे मे़मे़त्तुसि, “एःङ्‌याङ् के़भोःङ्‌बाहाॽ हे़क्‍क्‍याङ् लायोबाहाॽनु थेआङ् खिनिॽ के़दङ्‌ङासिआङ् चा के़जाम्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “सिदाॽसाम्‍बे़ङ्‌ग मे़न्‍दुक्‍मनाहाॽरे़ लागि मे़ःन्, कर के़दुक्‍पाहाॽरे़ लागिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","हे़क्‍केलॽरिक्‍के इङ्‌गाॽआङ् साम्‌योनिबाहाॽ मे़ःन्, कर लायोबाहाॽ लायोलाम् मे़हिन्‍ल फाॽआङ् उःत्‍छे़ त्‍याङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","कुभारे़ खुने़ॽ मे़मे़त्तु, “युहुन्‍नारे़ कुहुॽसाम्‍बाहाॽग ए़त्‍ले़ङ् चाःने़त्तो नु तुवा चोःक्‍कि मे़युङ्‌, फरिसिहाॽरे़ खुनिॽ हुॽसाम्‍बाहाॽआङ् हे़क्‍के मे़जोःक्, कर खे़ने़ॽ के़हुॽसाम्‍बाहाॽग चाःने़त्तोआङ् मे़न्‌युङ्‌ने़न्, मे़जर मे़धुङुर मे़वाॽइङ्‌ग!” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “मेःक्‍खिम्‍साबे़न् कुन्‍जुम्‍हाॽनु वाॽर थारिक् खे़ङ्‌हाॽ चाःने़त्तो मे़युङ्‌बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","कर खे़ङ्‌हाॽलाम् मेःक्‍खिम्‍साबे़न् साक्‍के़ल्‍ले़क् मे़दे़म्‍सुआङ् मे़देॽरुल्‍ले़ खे़ङ्‌हाॽ चाःने़त्तो मे़युङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","हे़क्‍क्‍याङ् याम्‍मो खुने़ॽ कन् खे़दाॽइन् खे़ङ्‌हाॽ मे़त्तुसि, “हाःत्‍ले़आङ् कुसङ् चाङ्‌ङिन् थे़ःक्‍खुआङ्‌कुद्रे़क्‌चाङ्‌ङिन् मे़ले़म्‍दुन्, ले़म्‍दुने़ फाॽग्र कुसङ् चाङ्‌ङिन् ते़ःङ्‌बेःक्‍लो, हे़क्‍क्‍याङ् कुसङ् चाङ्‌ङिल्‍ले़ कुद्रे़क्‌चाङ्‌ङिन् मे़घे़म्‍दुन्‍नाङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","हे़क्‍केलॽरिक् आत्तिल्‍ले़आङ् कुसङ् चे़ल्‍ले़क्‍सेॽ थिःन् कुद्रे़क्‌से़होबा सुःक्‌वाओ मे़युक्‍खुन्॥ युक्‍खुने़ फाॽग्र कुसङ् चे़ल्‍ले़क्‍सेॽ थिःल्‍ले़ कुद्रे़क्‌से़होबा सुःक्‌वाःन्‌थे़ःक्‍खुदेःसुॽरो॥ हे़क्‍क्‍याङ् थिःन् वे़त् पेःक्‍काङ् चासोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","कर कुसङ् चे़ल्‍ले़क्‍सेॽ थिःन् कुसङ् से़होबा सुःक्‌वाओए याक्‍मा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","हे़क्‍क्‍याङ् आत्तिल्‍ले़आङ् के़दुम्‍बा चे़ल्‍ले़क्‍सेॽ थिःन् थुङुआङ् कुसङ् चे़ल्‍ले़क्‍सेॽ थिःन् थुङ्‌मा निङ्‌वाॽ मे़जोगुन्‍लो, थेआङ्‌भे़ल्‍ले़ अक्‍खे पाःत्तु, ‘के़दुम्‍बा चे़ल्‍ले़क्‍सेॽ थिःन्‍ने कुजा नुॽरो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","थिक् नाःम्‍सिङ्‌ये़न्‍नो ये़सुःन् नु कुहुॽसाम्‍बाहाॽ प्‍याङ्‌सिगे़न् इक्‍ताप्‍लुम्‍मोनु मे़बेर मे़बत्‍छे़ल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ चासम्‍मिन् मे़दुबुआङ् हुक्‍को मे़नुगुर चामा मे़हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","हे़क्‍केःल्‍ले़ कुभा फरिसिहाॽरे़ खे़ङ्‌हाॽ सेःन्‍मे़दोसुसि, “थेआङ् नाःम्‍सिङ्‌ये़न्‍नो चोःक्‍मा मे़न्‍नुॽमनाबा याःम्‍बक्‍किन् के़जोगुम्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ साम्‌योसाप्‍लाःन् मे़न्‍निःत्ते के़वयिबि? थिक्‍ले़ङ् दाउद नु कुमनाहाॽरे़ खुनिॽ से़त्‍लाःक्‍ते़ल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","खुने़ॽ निङ्‌वाॽफु साःङ्‌गाहिम्‍मो लाःसे़आङ् निङ्‌वाॽफुमाङ्‌ङिन् तोःम्‍मनाबा सेसे खरे़ःङ्‌ङिन् चआङ् कुमनाहाॽआङ् पिरुसि॥ खे़ङ्‌ग आनिॽ साम्‌योथिम् कुइसिःक् निङ्‌वाॽफुसाम्‍बाहाॽरे़रक् चामा के़नुॽबा वये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो मे़त्तुसि, “इङ्‌गाॽ मे़न्‍छाम्‍साःङ्‌ग नाःम्‍सिङ्‌ये़न्‍निल्‍ले़न्‍नाङ् कुन्‍दाङ्‌बाआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","वेॽस्‍मा थिक् नाःम्‍सिङ्‌ये़न्‍नो खुने़ॽ यहुदि चुम्‍लुङ्‌हिम्‍मो पेआङ् हुॽरुसिर यागे़॥ खे़प्‍मो चुप्‍साङ् कुहुक् के़हेबा मनाधिक् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","आल्‍ल कुभा फरिसिहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ ये़सुरे़ खे़न् मनाःन् नाःम्‍सिङ्‌ये़न्‍नो वेःन्‍दुल्‍ले़ आप्‍तिक् कुःप्‍मा फाॽआङ् खे़प्‍मो मे़सुगुआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","कर ये़सुरे़ खुनिॽ निङ्‌वाॽ मे़इःत्तुबा पाःन्‍निन् निङ्‌वाॽ खोःसुआङ् खे़न् कुहुक् के़हेबा मनाःन् मे़त्तु, “फे़रे़ॽआङ्‌के़रे़क्‍ले़ खुनिॽ तगि ये़बे़ॽ॥” खे़न्‍नाङ् फे़रे़आङ् खे़प्‍मो ये़बे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽआङ् पाःन्‍धिक् सेःन्‍दोःनिङ्‌लो–नाःम्‍सिङ् ये़न्‍नो नुःबा नु ताप्‍फे़ःम्‍बा याःम्‍बक्‍को, साम्‌योथिम्‍मिल्‍ले़ आत्तिन् चोःक्‍मा आबिॽबे? हिङ्‌मन् से़ःप्‍माबि मे़ङ्‌माबि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","खुने़ॽ खिरि ओमे़त्तुसि हे़क्‍क्‍याङ् खे़न् कुहुक् के़हेबा मनाःन् मे़त्तु, “के़हुक्‍किन् सन्‍छे़ॽ॥” हे़क्‍क्‍याङ् खे़ल्‍ले़ कुहुक्‍किन् सन्‍छुल्‍ले़ खिमो वेःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","कर खे़प्‍मो के़वाॽबा फरिसिहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ साॽरिक् खुनिॽ सिक् पोगे़आङ् कन् ये़सुःन् थे मे़प्‍माबे फाॽआङ् पाःन् थक्‍मा मे़हेःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","थिक् ये़न् ये़सुःन् कोःक्‍माओ तुवा चोःक्‍से़ पेआङ् नाम्‍दाःत्ताःत् निङ्‌वाॽफुमाङ्‌ङो तुवा चोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","हे़क्‍क्‍याङ् खाओःत्ते़आङ् ये़सुरे़ काक् कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् खे़ङ्‌हाॽओलाम् थिक्-ने़त् (१२) कुहुॽसाम्‍बाहाॽ सेगुसि॥ खे़ङ्‌हाॽ सेःक्‌युक्‍मिबासि मे़त्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","खे़ङ्‌हाॽओ सिमोन (खुने़ॽ पत्रुस लॽरिक् मिङ् वाःत्तु), हे़क्‍क्‍याङ् खे़ल्‍ले़ कुन्‍साॽ आन्‍द्रियास, याकुब, युहुन्‍ना, फिलिप, बारथोलोमाइ, ");
INSERT INTO lifNT2_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","मत्ति, थोमा अल्‍फायसरे़ कुस्‍साः याकुब, सिमोन (खुने़ॽ हाङ्‌बिफ्‍युङ् के़जोःक्‍पा जिलति मे़प्‍मनाबा वये़), ");
INSERT INTO lifNT2_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","याकुबरे़ कुस्‍साः यहुदा वये़, हे़क्‍क्‍याङ् यहुदा इस्‍करियोति वये़, खे़न् ताःन्‍दि नसाःन् के़ले़ङ्‌बा पोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","हे़क्‍क्‍याङ् खुने़ॽ खे़ङ्‌हाॽनु यो थ्‍ये़आङ् ने़ने़बा ते़न्‍नो ये़म्‍सिङ्‌लो॥ खे़प्‍मो यरिक् कुहुॽसाम्‍बाहाॽ नु काक् यहुदिया थुम्, यरुसले़म, हे़क्‍क्‍याङ् वरक्‍किल्‍ले़ कुयाओ के़ने़बा तायर नु सिदोन ये़क्‌यक्‍कोलाम् यरिक् मनाहाॽ मे़द्‌ये़आङ् मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","खे़ङ्‌हाॽ खुने़ॽ कुघे़म्‍से़ नु खुनिॽ तुक्‍मा यॽमालाम् वेःत्‍छे़ मे़द्‌ये़आङ् मे़वये़॥ खे़प्‍मो फे़न्‍साम्‍मिल्‍ले़ तुक्‍खे चाःत्तुसिबा मनाहाॽआङ् मे़वेःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","खे़ङ्‌हाॽरे़ ये़सुःन् सुःमा मे़गोःत्तु थेआङ्‌भे़ल्‍ले़ के़वेःम्‍बा मुक्‍साम् खुने़ॽओलाम् लःन्‍दे़र पत्‍छे़, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ के़रे़क् वेःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ये़सुरे़ कुहुॽसाम्‍बाहाॽ ओमे़त्तुसिर मे़त्तुसि, “याङ्‌के़साॽबासे, खिनिॽ मुॽइसाबानिङ्‌लो, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् खिनिॽइन्‍ने़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","आल्‍ल साक्‍किल्‍ले़ तरुसिबासे, खिनिॽ मुॽइसाबानिङ्‌लो, थेआङ्‌भे़ल्‍ले़ ताःन्‍दि खिनिॽ के़घासिआङ् खिनिॽ निङ्‌सम्‍लो॥ आल्‍लो मेरिङ् थक्‍नु के़हाःप्‍पासे, खिनिॽ मुॽइसाबानिङ्‌लो, थेआङ्‌भे़ल्‍ले़ खिनिॽ के़एरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","मे़न्‍छाम्‍साःल्‍ले़ चोगुल्‍ले़ मनाहाॽरे़ के़म्‍जिःत्तिॽबा, के़म्‍नाॽरिबा हे़क्‍क्‍याङ् खिनिॽ नामे़धासुआङ् ताप्‍फे़ःल्‍लिक् के़म्‍मे़त्तिबाहाॽ मुॽइसाबानिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","खे़न् ये़म्‍मो सःत्ते़म्‍मे़ॽओ, ओमु लॽरे़म्‍मे़ॽआङ् लाःक्‍खे़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ खिनिॽ थुम्‍घोःन् साङ्‌ग्राम्‍पेदाङ्‌ङो पयम् यम्‍बा चोःक्‍लो॥ खुनिॽ थाःक्‍थे़बाहाॽरे़आङ् उन्‍छोःन्‍बा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ हाबा हे़क्‍केए मे़मे़त्तुसिआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","कर आल्‍लो याङ्‌साकुन्‍धेसाबासे, चिःत्ताङ्‌लक् स्‍ये़रो, थेआङ्‌भे़ल्‍ले़ खिनिॽ सःप्‍मान् नु निङ्‌वाॽ ताःमान् खिनिॽ हिङ्‌मन्‍नोए के़घोःसुम्‍माङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","आल्‍लो के़घाबाआङ् के़वाॽबासे, चिःत्ताङ्‌लक् स्‍ये़रो, थेआङ्‌भे़ल्‍ले़ खिनिॽ साक्‍मे़न्‍जा के़बोःक्‍खिॽरो॥ आल्‍लो के़एःप्‍पार के़वाॽबासे, चिःत्ताङ्‌लक् स्‍ये़रो, थेआङ्‌भे़ल्‍ले़ खिनिॽ मेरिङ् थक्‍नु के़हाबिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","आल्‍लो मनाहाॽरे़ नुःरिक् मे़मे़त्तुसिबासे, चिःत्ताङ्‌लक् स्‍ये़रो, थेआङ्‌भे़ल्‍ले़ खुनिॽ थाःक्‍थे़बाहाॽरे़आङ् इङ्‌ले़क्‍पा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ बा हे़क्‍केए मे़मे़त्तुसिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“कर इङ्‌गाॽ आबाःन् के़घे़म्‍बासे, खिनिॽ निङ्‌मिहाॽ लुङ्‌माॽ तुक्‍ते़म्‍सिम्‍मे़ॽओ॥ याप्‍मि के़जिःप्‍पाहाॽ नुःरिक् मे़त्ते़म्‍सिम्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","खिनिॽ साङ्‌ग्रा के़मे़प्‍पाहाॽ मुॽइसाम् थासे़म् पिरे़म्‍सिम्‍मे़ॽओ॥ खिनिॽ ताप्‍फे़ःल्‍लिक् के़मे़प्‍पाहाॽ तुवा चोगे़म् पिरे़म्‍सिम्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","हाःत्‍ले़ के़ने़दे़ङ्‌बान् के़ले़ङ् के़बिॽ, खे़ने़ॽ वेॽ ले़प्‍माङ्‌बा के़ने़दे़ङ्‌बान्‍नाङ् खे़न् तोःन्‍दे़ पिरे़ॽ॥ हाःत्‍ले़ साक्‍के़ल्‍ले़क् के़सुङ्‌घेःक्‌वाःन् के़नाप्‍पाङ्‌तेॽरुॽ, खे़न्‍निन् के़जाङ्‌मा तेःत्तिन्‍नाङ् पिरे़देःसे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","हे़क्‍क्‍याङ् के़नाःक्‍पाहाॽ पिरे़से़ॽओ॥ हे़क्‍क्‍याङ् के़जिगःक्‌वाहाॽ के़देॽबाहाॽ याम्‍मो याङ्‌ना मे़नाःक्‍ते़से़न्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","हे़क्‍क्‍याङ् वेॽ मनाहाॽरे़ आक्‍खे के़म्‍मे़त्तिबा निङ्‌वाॽ के़इःत्तुम्, खिनिॽआङ् बा हे़क्‍के मे़त्ते़म्‍सिम्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","खिनिॽ लुङ्‌माॽ के़दुक्‍पाहाॽरक् लुङ्‌माॽ के़दुक्‍तुम्‍सिम्‍ने़ फाॽग्र खिनिॽ थे यम्‍बा याःम्‍बक् के़जोगुम्‍माङ्बे? खे़ङ्‌ग लायोबाहाॽरे़आङ् बा हे़क्‍के मे़जोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","हे़क्‍क्‍याङ् खिनिॽ नुःरिक् के़मे़प्‍पाहाॽरक् नुःरिक् के़मे़त्तुम्‍सिम्‍ने़ फाॽग्र थे यम्‍बा याःम्‍बक् के़जोगुम्‍माङ्बे! खे़ङ्‌ग लायोबाहाॽरे़आङ् बा हे़क्‍के मे़मे़त्तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","हे़क्‍क्‍याङ् खिनिॽ याम्‍मो मे़नुःक्‍तुर फाॽआङ् मनाहाॽ थे़ॽला के़बिरुम्‍सिम्‍ने़ फाॽग्र थे यम्‍बा याःम्‍बक् के़जोगुम्‍माङ्बे! खे़ङ्‌ग लायोबाहाॽरे़आङ् बा हे़क्‍के मे़जोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","कर खिनिॽ निङ्‌मिहाॽ लुङ्‌माॽ तुक्‍ते़म्‍सिम्‍मे़ॽ, खे़ङ्‌हाॽ नुःरिक् मे़त्ते़म्‍सिम्‍मे़ॽ, हे़क्‍क्‍याङ् मे़नुःक्‍तुर फाॽआङ् मे़न्‍इःत्ते थे़ॽला पिरे़म्‍सिम्‍मे़ॽ, हे़क्‍केःल्‍ले़ खिनिॽ थुम्‍घोःन् यरिक् पोःङ्‌लो॥ हे़क्‍क्‍याङ् खिनिॽ के़रे़क्‍नुःल्‍ले़ पयम् यम्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुस्‍साः के़बोःक्‍खिॽरो, थेआङ्‌भे़ल्‍ले़ खुने़ॽग ताप्‍फे़ःम्‍बा मनाहाॽ नु फोत्‍याबा मनाहाॽआङ् लुङ्‌माॽ तुक्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","खिनिॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिन् याप्‍मि लुङ्‌माॽ के़दुक्‍पा चोःक्, खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽआङ् मनाहाॽ लुङ्‌माॽ तुक्‍ते़म्‍सिम्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“मनाहाॽ पाःन् मे़धिक्‍ते़म्‍सिम्‍मे़न्‍ने़ॽ, हे़क्‍केलॽरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽआङ् पाःन् के़न्‍धिक्‍तिन्‍लो॥ मनाहाॽ चे़ॽया इङ्‌दो मे़मे़त्ते़म्‍सिम्‍मे़न्‍ने़ॽओ, हे़क्‍केलॽरिक् खिनिॽआङ् चे़ॽया इङ्‌दो के़मे़म्‍मे़त्तिन्‍लरो॥ मनाहाॽ ले़प्‍मि पिरे़म्‍सिम्‍मे़ॽओ, हे़क्‍केलॽरिक् खिनिॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ ले़प्‍मि के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","मनाहाॽ पिरे़म्‍सिम्‍मे़ॽ हे़क्‍क्‍याङ् खिनिॽआङ् के़म्‍बिरिॽरो॥ नुःरिक् सिःक्‍ते़म्‍मे़ॽ नुःरिक् थे़क्‍ते़म्‍मे़ॽर नुःरिक् मुन्‍दे़म्‍मे़ॽर कुधिम् पोःङ्‌ङाङ् कुवे़त्‌वे़त्‌मनाहाॽ सिःक्‍ते़म् पिरे़म्‍सिम्‍मे़ॽ, बा हे़क्‍केलॽरिक्‍के खिनिॽआङ् के़म्‍बिरिॽरो॥ खिनिॽ आक्‍खेलॽरिक् के़सिःक्‍तुम्‌के़बिरुम्‍सिम्‌, बा हे़क्‍केलॽरिक् खिनिॽआङ् के़म्‍सिःक्‍ति के़म्‍बिरिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","हे़क्‍क्‍याङ् ये़सुरे़ कन् खे़दाॽइन् खे़ङ्‌हाॽ मे़त्तुसि, “मिक्‍फःम्‍बाल्‍ले़ वेॽ मिक्‍फःम्‍बे़न् लाम्‍लोमा मे़सुक्‍तुन्‍लो, लाम्‍लोसुने़ फाॽग्र ने़प्‍माङ् लुम्‍बाःत्तो के़ङ्‌सि लाःत्‍छिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","हुॽसाम्‍बे़न् कुसिक्‍साम्‍बे़न्‍नुःल्‍ले़ यम्‍बा मे़ःन्‍लो॥ कर खुने़ॽ नुःरिक् हुॽसिङ् सुःत्‍छिङ्‌ङाङ् खुने़ॽ कुसिक्‍साम्‍बे़न्‌कुइसिःक् पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","आबाङे थक्‍को साःङ्‌वे़त् चाराम्‍बा मे़न्‍निःमनाबाल्‍ले़ आक्‍खेलॽरिक् के़न्‍साॽरे़ कुधक्‍कोबा वाम्‍सिक्‍किन् के़निःसुबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","खे़ने़ॽ आबाङे के़धक्‍को साःङ्‌वे़त् चाराम्‍बा के़न्‍निःसुन्‍निल्‍ले़ आक्‍खेलॽरिक् के़न्‍साॽइन् के़धक्‍कोबा वाम्‍सिक्‍किन् खे़क्‍खुङ् पिने़ लॽरिक् मे़प्‍मा के़सुक्‍तुबे? कुनिङ्‌वाॽ के़जिःप्‍पाए, के़रे़क्‍नुःल्‍ले़ तगि आबाङे के़धक्‍कोबा साःङ्‌वे़त्तिन् नाःत्ते़देःसे़ॽओ, हे़क्‍क्‍याङ्‌लक् के़न्‍साॽरे़ कुधक्‍कोबा वाम्‍सिक्‍किन् उसुरु के़निःसुआङ् खे़ङ्‌मा के़सुक्‍तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","आत्तिन् नुःबा सिङ्‌बुङ्‌ङोआङ्‌ताप्‍फे़ःम्‍बा सिङ्‌सेॽ मे़धोःक्‍ने़न्‍लो, हे़क्‍केलॽरिक् आत्तिन् ताप्‍फे़ःम्‍बा सिङ्‌बुङ्‌ङोआङ्‌नुःबा सिङ्‌सेॽ मे़धोःक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","खे़न् सिङ्‌बुङ्‌हाॽग सिङ्‌सेहाॽ ओमे़प्‍माआङ्‌साङ् कुसिङ् निःत्‍मे़दे़त्‍लो॥ आप्‍फाल्‍ले़आङ् तिङ्‌ग्रेःक् पोःक्‍लाओलाम् मनाहाॽरे़ पःत्‍छेॽइन् मे़न्‍दुबुन्‍लो॥ हे़क्‍केलॽरिक् तिङ्‌वासेक् पोःक्‍लाओलाम् चे़ल्‍ले़क्‍सेॽइन्‌मे़न्‍छुप्‍सुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","नुःबा मनाःल्‍ले़ कुनिङ्‌वाॽ सिगाङ् के़याक्‍पा नुःबा पाःन्‍नोलाम् नुःबा याःम्‍बक् चोगुॽरो॥ हे़क्‍केलॽरिक्‍के ताप्‍फे़ःम्‍बा मनाःल्‍ले़आङ् कुनिङ्‌वाॽ सिगाङ् के़याक्‍पा ताप्‍फे़ःम्‍बा पाःन्‍नोलाम् फे़न् याःम्‍बक् चोगुॽरो॥ हे़क्‍क्‍याङ् निङ्‌वाॽ सिगाङ् के़याक्‍पा पाःन्‍हाॽए मनाहाॽरे़ खुनिॽ मुरालाम् मे़बाःत्तु मे़लःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“इङ्‌गाॽ पाःत्तुङ्‌बा पाःन् कुइसिःक् के़न्‍जोगुम्‍मिन्‍निल्‍ले़, थेआङ् इङ्‌गाॽ ‘आदाङ्‌बे, आदाङ्‌बे,’ याप्‍मि के़मे़त्तिॽबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","इङ्‌गाॽ आबाःन् के़घे़म्‍बाआङ् कुइसिःक् के़जोःक्‍पा मनाःन् आक्‍तङ्‌बा चोःक् फाॽआङ् मे़त्‍निङ्‌लो– ");
INSERT INTO lifNT2_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","खे़न् नुःबा पाङ्‌यक्‍को हिम् के़जोःक्‍पा मना कुइसिःक्‍लो॥ खे़ल्‍ले़ हिम् चोःक्‍मा फाॽआङ् यो खाम् सिगाङ्‌बा यम्‍बा लुङ्‌ङिन् मे़न्‌याङ्‌ङे थारिक् तयु॥ हे़क्‍क्‍याङ् यम्‍बा लुङ्‌सम्‍दाङ् पाङ्‌यक् नेम्‍भो ने़स्‍सुआङ् लुङ्‌धाक् से़त्तुर हिम् चोगुॽ॥ हे़क्‍क्‍याङ् यम्‍बा वाहिप्‍मान् थ्‍ये़आङ् वाकुक्‍से़ ये़आङ् च्‍वाःत्तिल्‍ले़ खे़न् हिम्‍मिन् लक्‍तु, कर थेआङ् मे़बोःक्‍खे़न्, थेआङ्‌भे़ल्‍ले़ खे़न् हिम्‍मिल्‍ले़न् नुःरिक्‍काङ् पाङ्‌यक् युक्‍खुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","हे़क्‍क्‍याङ् आबाःन् के़घे़म्‍बाआङ् पाःत्तुङ्‌बा पाःन् कुइसिःक् मे़न्‍जोःक्‍मनाबा मनाःन् आक्‍तङ्‌बा चोःक् फाॽआङ् मे़त्‍निङ्‌लो–खे़ल्‍ले़आङ् हिम् चोःक्‍मा फाॽआङ् पाङ्‌यक् तयु, कर नुःबा पाङ्‌यक् नेम्‍भो मे़न्‍ने़ए लुङ्‌धाक् से़त्तुआङ् हिम् चोगु॥ हे़क्‍क्‍याङ् यम्‍बा वाहिप्‍मान् थ्‍ये़, वाकुक्‍खु ये़आङ् च्‍वाःत्तिल्‍ले़ खे़न् हिम्‍मिन् लक्‍तु, हे़क्‍क्‍याङ् लुःन्‍दुदेःसुरो॥ हे़क्‍क्‍याङ् खे़न् हिम्‍मिन् चोःन्‍दे़बेआङ् यम्‍बा मे़म्‍भै पोःक्‍खे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","हे़क्‍क्‍याङ् ये़सुरे़ मनाहाॽ के़रे़क् सिवादिङ् खाहुन्‍हाॽ मे़त्तु सुरुसिआङ् खुने़ॽ कपर्नहुम पाङ्‌जुम्‍मो लाःसे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","खे़प्‍मोबा रोमि थक्‍तुम्‍बाल्‍ले़ के़रे़क्‍नुःल्‍ले़ कुनिङ्‌वाॽइरे़ खोःप्‍तुबा कुयोःक्‍पे़न् तुगे़आङ् सिःमालिङ्‌धोओ के़रे़आङ् ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","खे़न् थक्‍तुम्‍बाल्‍ले़ ये़सुःन् पाङ्‌जुम्‍मो त्‍ये़आङ् वाॽ के़लॽबा खे़प्‍सुआङ् हाराॽ फे़न्‍नाङ् कुयोःक्‍पे़न् वेःन्‍दुर फाॽआङ् यहुदि तुम्‍लाम्‍लोःबाहाॽ ये़सुरे़ कुलाःसे़ पाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","खे़ङ्‌हाॽआङ् ये़सुरो मे़द्‌ये़आङ् अक्‍खे मे़मे़त्तुर पेलि मे़भाक्‍तु, “आदाङ्‌बे, खे़न् थक्‍तुम्‍बे़न् खे़ने़ॽलाम् कुभाॽ खोःमा लाॽरुरो, ");
INSERT INTO lifNT2_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ आनिॽ यहुदि सुवाङ्‌हाॽ साॽरिक् लुङ्‌माॽ आदुक्‌॥ हे़क्‍क्‍याङ् आनिॽ लागि यहुदि चुम्‍लुङ्‌हिम्‍धिक् आजोगे़ आबिरे़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","हे़क्‍क्‍याङ् ये़सुःन् खे़ङ्‌हाॽनु थासिङ्॥ खे़ङ्‌हाॽ खे़न् थक्‍तुम्‍बाल्‍ले़ कुहिम्‍मो के़प्‍मानुःल्‍ले़ तगि खे़न् थक्‍तुम्‍बाल्‍ले़ अक्‍खे पाःत्तुआङ् कुन्‍जुम्‍हाॽ पाङ्‌घुसि, “आदाङ्‌बे, तुक्‍खे मे़जे़न्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ खे़ने़ॽ आहिम्‍मो लाङ्‌दाःक्‍मा मे़लाॽआन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","हे़क्‍केलॽरिक् इङ्‌गाॽ आबाङेआङ् खे़ने़ॽओ ताःमा मे़लाॽआन्‍लो॥ खे़ने़ॽ पाःन् सुत्‍लाधिक्‍लक् के़बाःत्तुसाङ् आयोःक्‍पे़न् वेःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽआङ् आधुङ्‌धोबा सुहाङ्‌युक्‍पाहाॽरे़ खुनिॽ युक्‍को के़वाॽबा मनाआरो, हे़क्‍क्‍याङ् इङ्‌गाॽआङ् आयुक्‍को थक्‍सुबाहाॽ मे़वाॽरो॥ इङ्‌गाॽ थक्‍सुबाधिक्‍किन्‌‘पेगे़ॽ’ मे़त्तुङ्‌ङिल्‍ले़ पेःक्, हे़क्‍क्‍याङ् वेॽ थक्‍सुबान् ‘फे़रे़ॽ’ मे़त्तुङ्‌ङिल्‍ले़ फे़न्॥ हे़क्‍केलॽरिक्‍के आयोःक्‍पे़न् ‘कन् चोगे़ॽ’ मे़त्तुङ्‌ङिल्‍ले़ चोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ये़सुरे़ कन् खे़प्‍सुआङ् साॽरिक् कुनिङ्‌वाॽ मये़आङ् खिरि हिसिङ्‌ङाङ् खुने़ॽ के़दिम्‍बाहाॽ मे़त्तुसि, “अक्‍तङ्‌बा यम्‍बा नसाःन् के़गप्‍पा मनाःङ्‌ग इस्राइलओआङ् इङ्‌गाॽ मे़ङ्‌घोए वाॽआरो! ");
INSERT INTO lifNT2_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","हे़क्‍क्‍याङ् थक्‍तुम्‍बाल्‍ले़ पाङ्‌घुसिबा मनाहाॽ मे़नुःक्‍खे़आङ् हिम्‍मो मे़गे़रे़ल्‍ले़ खे़न् योःक्‍पे़न् वेःत्ते़आङ् युङे़बा मे़दुमुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","हे़क्‍क्‍याङ् कुभा ये़न् एगाङ् ये़सुःन् नाइन् पाङ्‌जुम्‍मो पे॥ खुने़ॽनुए कुहुॽसाम्‍बाहाॽ नु यरिक् मनाहाॽआङ् मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","खुने़ॽ पाङ्‌जुम्‍मोबा यम्‍बा ताःक्‍हन्‍नो के़रे़ल्‍ले़ मेमेदुमाधिक्‍ले़ लत्‍छारक् के़वाॽबा कुस्‍साः ये़म्‍बित्‍छाॽइन् स्‍ये़आङ् कुजेधाःप्‍पिन् पाङ्‌जुम्‍मोबा मनाहाॽरे़ मे़भे़त्तुर मे़बत्‍छे़बा तुमु॥ खे़न् मेमेदुमान्‍नु यरिक् मनाहाॽ मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ये़सुरे़ खे़न् मेमेदुमान् ओमे़त्तुल्‍ले़ कुलुङ्‌माॽ सियोःन्‌योःन्‍दे़आङ् खे़ने़ॽ मे़हाबे़न्‍ने़ॽओ मे़त्तुर आःन्‍छिङ्‌मा पिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","हे़क्‍क्‍याङ् पेआङ् चेधाःप्‍पिन् सुःसुल्‍ले़ खे़न् चेधाःप् के़बङ्‌बाहाॽ मे़ये़म्‍सिङ्॥ ये़सुरे़ मे़त्तु, “लाजे, पोगे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","हे़क्‍क्‍याङ् खे़न् के़सिःबा थाङ्‌बे़न्‍निन्‍नाङ् पोगे़आङ् पाःप्‍मा हेःक्‍ते़॥ हे़क्‍क्‍याङ् ये़सुरे़ खे़न् कुम्‍मा हुक्‍सुप्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","हे़क्‍क्‍याङ् मनाहाॽ के़रे़क् मे़गिसे़आङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा मे़भोःसुर अक्‍खे मे़बाःत्तु, “आनिॽ लुम्‍मोआङ् यम्‍बा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्‌वाॽरो॥” हे़क्‍क्‍याङ् याम्‍मो खे़ङ्‌हाॽरे़ मे़बाःत्तु, “निङ्‌वाॽफुमाङ्‌ङिन् कुमनाहाॽ कुभाॽ पिसे़ नु कम्‍ब्राङ् मे़त्‍छे़ ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","हे़क्‍क्‍याङ् कन् हिन्‍दोःक्‍किन् के़रे़क् पिसाङ् यहुदिया नु खे़न् खिरिबा थुम्‍मो से़ःरे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़आङ् कुहुॽसाम्‍बाहाॽरोलाम् कन् पाःन्‍निन् खे़प्‍सु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","हे़क्‍क्‍याङ् ने़प्‍फु कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् दाङ्‌बाल्‍लो कन् इङ्‌घङ्‌ङिन् हाङुदेःसु–“आल्‍ल के़दाःबा ख्रिस्‍ते़न्‌बा खे़ने़ॽएबि? इ आनिगे़ वेॽस्‍मान् हाङ्‌घुम्‍बे़बाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","हे़क्‍क्‍याङ् खे़न् इङ्‌साबाहाॽआङ् ये़सुरो पेसे़त्‍छिआङ् मे़त्ते़छु, “बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ अक्‍खे पाःत्तुआङ् याप्‍मि पाङ्‌घे़त्‍छिगे़आङ् वाॽसिगे़रो, ‘आल्‍ल के़दाःबा ख्रिस्‍ते़न्‌बा खे़ने़ॽएबि, इ आनिगे़ वेॽस्‍मान् हाङ्‌घुम्‍बे़बाबि?’” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","हे़क्‍क्‍याङ् हाबा खे़न् ये़म्‍मो ये़सुरे़ के़दुक्‍पा के़यॽबाहाॽ नु फे़न्‍साम्‍मिल्‍ले़ तरुसिबाहाॽ नुसुसि हे़क्‍क्‍याङ् यरिक् मिक्‍फःम्‍बाहाॽआङ् खानिःमा के़सुक्‍पा चोगुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","हे़क्‍क्‍याङ् ये़सुरे़ युहुन्‍नालाम् के़दाःबाहाॽ मे़त्तुसि, “पेसे़त्‍छे़ॽआङ् कन् के़निःसे़त्‍छु, के़घे़प्‍से़त्‍छुबा पाःन्‍निन् युहुन्‍नाःन् मे़त्ते़छे़ॽ–अक्‍खेलॽरिक् मिक्‍फःम्‍बाहाॽरे़ निःमा मे़सुक्‍तुॽ, हे़क्‍क्‍याङ् लाङ्‌सक्‍पाहाॽ लाङ्‌मे़घेःक्, लोगेॽरे़ तरुसिबाहाॽ मे़वेःत्‌, हे़क्‍क्‍याङ् नाधे़क्‍क्रे़ङ्‌हाॽरे़ मे़घे़प्‍सु, के़सिःबाहाॽ याम्‍मो मे़हिङ्, हे़क्‍क्‍याङ् याङ्‌गे़साॽबाहाॽरे़ सुनाइङ्‌ङिन् मे़घे़प्‍सुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","हे़क्‍क्‍याङ् इङ्‌गाॽनु कुनिङ्‌वाॽ मे़न्‍दुक्‍मनाबाआङ् याप्‍मि चप्‍चि मे़न्‍जोःक्‍मनाबान् मुॽइसाबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","हे़क्‍क्‍याङ् युहुन्‍नारे़ कुइङ्‌साबाहाॽ पेसे़त्‍छिआङ् ये़सुरे़ खे़न् मनाहाॽ युहुन्‍नारे़ कुमे़न्‍नो मे़त्तुसि, “खिनिॽ एःक्‍सादे़न्‍नो थे़मा ओमे़त्‍छे़ के़बेगिबा? सुरित्‍माल्‍ले़ वाःन्‍दुबा थिङ्‌ने़ःत्ते़न्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","नुःबा चाङ् तेःत् के़जाङ्‌बा मनाःन् ओमे़त्‍छे़ लाःक्‍कात् के़बेगिबि? हे़क्‍तङ्‌बाहाॽ नु हाङ्‌हाङ् लॽरिक् के़युङ्‌बाहाॽग हाङ्‌हिम्‍मोरक् मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","थे़मा ओमे़त्‍छे़ के़बिगिबा? माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्बि? से़क्‍खाःल्‍ले़ इङ्‌गाॽ मे़त्‍निङ्, माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्‍नुःल्‍ले़ यम्‍बा मनाःन् के़निःसुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ कुमे़न्‍नो, साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् पत्, “इङ्‌गाॽ आइङ्‌साबे़न् के़लागि लाम् यारिप् चोःक्‍से़ खे़ने़ॽनुःल्‍ले़ तगि पाङ्‌घुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","हे़क्‍क्‍याङ् के़रे़क् मे़न्‍छाम् याप्‍मिलुम्‍मो बप्‍तिस्‍मा के़बिबा युहुन्‍नाःन्‍नुःल्‍ले़ यम्‍बा हाःत्ताङ् होःप्‍लो॥ हे़क्‍केसाङ् निङ्‌वाॽफुहाङ्‌जुम्‍मो काक्‍नु चुक्‍पे़न् युहुन्‍नाःन्‍नुःल्‍ले़ यम्‍बा चोःक् फाॽआङ् मे़त्‍निङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","अक्‍खेलॽरिक् के़रे़क् मनाहाॽरे़ हे़क्‍क्‍याङ् एःङ्‌याङ् के़भोःङ्‌बाहाॽरे़आङ् ये़सुरे़ कुबाःन्‍निन् मे़घे़प्‍सुआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुलाम्‍मिन् नुःबा फाॽआङ् ते़न्‍दिङ् मे़जोगु, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ युहुन्‍नालाम् बप्‍तिस्‍मा मे़जोःक्‍सिङ्‌ङाङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","कर फरिसिहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ खुनिॽ लागि निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिङ्‌सेःक्‍किन् मे़नाॽरु, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ युहुन्‍नालाम् बप्‍तिस्‍मा मे़न्‍जोःक्‍सिङ्‌ङिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ये़सुरे़ याम्‍मो पाःत्तु, “आल्‍ल कन् ये़म्‍मोबा मनाहाॽ आक्‍तङ्‌बा मे़जोःक् फाॽआङ् थे़माःन्‍नु तङ्‌घुङ्‌सिङ्‌बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","खे़ङ्‌हाॽग पाङ्‌जुम्‍मो के़वाॽबा हिन्‍जाॽबित्‍छा कुइसिःक् मे़जोःक्‍लो॥ खे़ङ्‌हाॽ अक्‍खेलॽरिक् मे़मे़त्‍छिङ्, ‘आनिगे़ मुॽफ्रामा हिप्‍मना, कर खिनिॽ के़न्‍लाःक्‍खिन्॥ आनिगे़ मेरिङ् थक्‍मना, कर खिनिॽ के़न्‍हाबिन्॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","थेआङ्‌भे़ल्‍ले़ बप्‍तिस्‍मा के़बिबा युहुन्‍नाःन् तःक्‍ने़त्तो युङे़र आममबान् मे़न्‍धुङ्‌ङे त्‍ये़, कर ‘खे़ल्‍ले़ फे़न्‍साम् कत्तुॽ’ के़मे़त्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","मे़न्‍छाम्‍साःन् चर थुङुर त्‍ये़, हे़क्‍क्‍याङ् ‘खे़न् तःक्‍थे़ःक्‍के़हाॽ, थिःमसाङ्‌हाॽ, एःङ्‌याङ् के़भोःङ्‌बाहाॽ नु लायोबाहाॽरे़ खुनिॽ तेःङ्‌बारो’ के़मे़त्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","निङ्‌वाॽफु सिक्‍कुम्‍दिङ् निङ्‌वाॽइन्‌ते़न्‍दिङ् के़जोःक्‍पाआङ् के़इःप्‍पा के़नाःप्‍पाहाॽरे़ खे़न् निस्‍से चोःक् फाॽआङ् ओसेःन्‍आम्‍धाक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","फरिसिधिक्‍ले़ ये़सुःन् युःन्‍छिक् चाजासे़ उःत्तु, हे़क्‍क्‍याङ् खुने़ॽ कुहिम्‍मो पेआङ् चाजासे़ युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","खे़न् पाङ्‌जुम्‍मो के़त्‍निमा याःम्‍बक् के़जोःक्‍मा मे़न्‍छुमाॽधिक् वये़॥ खे़न् मे़न्‍छुमाॽइल्‍ले़ ये़सुःन् फरिसिःल्‍ले़ कुहिम्‍मो चाजासे़ त्‍ये़आङ् वाॽ के़लॽबा खे़प्‍सुआङ् खे़ल्‍ले़ इमे़ल्‍लुङ्‌बा पर्यामाधिक्‌कुले़म् फुङ्‌नाम्‌याङ्‌सिङे़आङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ये़सुरे़ कुएगाङ् ले़प्‍माङ् त्‍ये़आङ्‌हाबे़र ये़सुरे़ कुलाङ्‌ङो कुमिक्‌वाःल्‍ले़ वारक्‍खुरो॥ हे़क्‍क्‍याङ् कुधे़गेःक्‍इःल्‍ले़ तुगुआङ् हेःसुर कुलाङ्‌ङिन् चुप् मे़त्तुआङ् खे़न् फुङ्‌नाम्‍मिन् हुःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","हे़क्‍केःल्‍ले़ खे़न् फरिसिःल्‍ले़ निःसुआङ् निङ्‌वाॽ इःत्‍छिङ्‌, “कन् मनाःन् से़क्‍खाए माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा वये़ल्‍ले़ग खुने़ॽ के़सुमा मे़न्‍छुमाॽइन् हाःप्‍पे फाॽआङ् कुसिङ्‌निःत्तुबामे़न्‌, थेआङ्‌भे़ल्‍ले़ खे़न् से़क्‍खाए लायो के़जोःक्‍माएरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ये़सुरे़ खे़न् फरिसिःन् मे़त्तु, “सिमोने, इङ्‌गाॽ खे़ने़ॽनु लत्‍छा पाःन्‍धिक् पाःप्‍मा कत्तुङ्‌लो॥” सिमोनरे़आङ् नोगप् पिरु, “सिक्‍साम्‍बे, मे़त्ताङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ये़सुरे़ मे़त्तु, “थिक् ते़न्‍नो ने़प्‍फु मनाहाॽ वये़त्‍छि॥ खे़ङ्‌हाॽरे़ सिङ्‌नाःत् याङ् के़गे़बाल्‍लोलाम् लत्‍छारे़ ङागिप् (५०) युप्‍पायाङ् नु वेॽस्‍माल्‍ले़ कुगिप् ङासि (५००) युप्‍पायाङ् तेॽरे़त्‍छुआङ् वये़त्‍छि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","कर खे़न् ने़प्‍माङ्‌ले़ हुङ्‌मा मे़न्‍छुक्‍के वये़त्‍छि॥ खे़न् सिङ्‌नाःत् याङ् के़गे़बाल्‍ले़ ने़प्‍माङ्‌ले़ खुन्‍छिॽ सिङ्‌नाःत्तिन् ले़रु पिरुसि॥ हे़क्‍केःल्‍ले़ आत्तिल्‍ले़ खे़न् सिङ्‌नाःत् याङ् ले़प्‍मि के़बिबान् यरिक् लुङ्‌माॽ तुक्‍तुबिला?” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","सिमोनरे़ नोगप् पिरु, “इङ्‌गाॽ आनिङ्‌वाॽओ खे़न् यरिक् सिङ्‌नाःत् ले़प्‍मि के़घोःबान्‍ने यरिक् लुङ्‌माॽ तुक्‍तुबिलारो॥” ये़सुरे़ मे़त्तु, “खे़ने़ॽ से़क्‍खाए के़बाःत्तुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","हे़क्‍क्‍याङ् ये़सुःन् खे़न् मे़न्‍छुमाॽइन् ले़प्‍माङ् हिसिङ्‌ङाङ् सिमोन्‍निन् मे़त्तु, “सिमोने, इङ्‌गाॽ खे़ने़ॽ के़हिम्‍मो त्‍याङ्‌ङिल्‍ले़ लाङ् वाहप्‍मा च्‍वाःत् के़म्‍बिराङ्‌ङिन्, कर कन् मे़न्‍छुमाॽइल्‍ले़ आलाङ्‌ङिन् कुमिक्‌वाःल्‍ले़ वाहप्‍तुआङ् कुधे़गेःक्‍इःल्‍ले़ तुगुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","खे़ने़ॽ इङ्‌गाॽ चुप् के़मे़त्ताङ्‌ल सेवा के़म्‍मे़त्ताङ्‌ङिन्, कर कन् मे़न्‍छुमाॽइल्‍ले़ इङ्‌गाॽ त्‍याङ्‌ङाङ्धोए आलाङ्‌ङो चुप् मे़त्तुर वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","हे़क्‍क्‍याङ् खे़ने़ॽ आधे़गेःक्‍पो निःङ्‌गे़ॽ के़न्‍हुःत्ताङ्‌ङिन्‌के़म्‍बिराङ्‌ङिन्, कर कन् मे़न्‍छुमाॽइल्‍ले़ आलाङ्‌ङो फुङ्‌नाम्‍मिन् हुःत्ताङ् पिराङ्‌ङाङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","कन् मे़न्‍छुमाॽइल्‍ले़ साॽरिक् लुङ्‌माॽ तुक्‍ताङ्‌बाल्‍ले़ यरिक् लायोलाम् ले़प्‍मि खोःसुॽ के़लॽबा ओसेःन्‍आधाक्‍लो॥ खे़न् चुःत्‍छिक् लायोलाम् ले़प्‍मि के़घोःबाल्‍ले़ सुःल्‍लिक्‍लक् लुङ्‌माॽ तुक्‍तुसिॽ फाॽआङ् मे़त्‍ने़ॽरो” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मे़न्‍छुमाॽइन् मे़त्तु, “खे़ने़ॽ के़लायोलाम् ले़प्‍मि के़घोःसुआङ् के़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","हे़क्‍केःल्‍ले़ खुने़ॽनु चा के़जाबार के़युङ्‌बा वेॽ मनाहाॽ लायोलाम् ले़प्‍मि के़बिबा कन् याप्‍मिःन् हाःप्‍पे फाॽआङ् मे़मे़त्‍छिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","कर ये़सुरे़ खे़न् मे़न्‍छुमाॽइन् मे़त्तु, “खे़ने़ॽ के़नसाःन्‍निल्‍ले़ ताङ्‌गे़से़ःप्‍ते़आङ् के़वाॽरो॥ नुःरिक्‍काङ् पेगे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","खे़न् एगाङ् ये़सुःन् निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़ कुयाःम्‍बेओ सुनाइङ् से़ःसुर ये़क्‌यक् नु पाङ्‌भेॽहाॽओ लाम्‍दिःक् चोगे़॥ खुने़ॽनु थिक्-ने़त् कुहुॽसाम्‍बाहाॽ मे़वये़, ");
INSERT INTO lifNT2_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","हे़क्‍क्‍याङ् फे़न्‍साम्‍हाॽ नु तुक्‍मा यॽमालाम् वेःन्‍दुसिमा कुभा मे़न्‍छुमाहाॽआङ् मे़वये़॥ खे़ङ्‌हाॽओ ये़सुरे़ मग्‍दलिनि मे़प्‍मनामा मरियमओलाम् नुसि फे़न्‍साम्‍हाॽ लःत्तुसिआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","हे़क्‍क्‍याङ् हे़रोदरे़ कुघारात् के़युङ्‌बा चुजासरे़ कुमेःत् योआन्‍ना, सुजना, नु यरिक् मे़न्‍छुमाहाॽरे़ खुनिॽ याङ्‌साकुन्‍धेःल्‍ले़ ये़सुःन् नु कुहुॽसाम्‍बाहाॽ कुभाॽ मे़बिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","थिक् ये़न् यरिक् ये़क्‌यक्‍कोलाम् यरिक् मनाहाॽ ये़सुओ मे़द्‌ये़॥ हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ कन् खे़दाॽइन् मे़त्तुसि– ");
INSERT INTO lifNT2_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“लत्‍छा याःन्‍के़मःबाधिक् याॽरिःम्‍बा ले़प्‍से़ पेरो॥ खे़ल्‍ले़ याॽरिःम्‍बे़न् ले़प्‍तुल्‍ले़ कुभा याॽरिःम्‍बे़न् लाम्‍मो मक्‍थ्‍ये़आङ् मनाहाॽरे़ मे़दोॽरु, हे़क्‍क्‍याङ् पुहाॽ मे़द्‌ये़आङ् मे़घप्‍सु मे़जरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","हे़क्‍क्‍याङ् कुभा याॽरिःम्‍बे़न् लुङ्‌घाराक्‍को चुक्‍ते़, हे़क्‍क्‍याङ् खे़न् लिङ्‌माग लिङे़, कर नाम्‍मिल्‍ले़ हेरे़बे, थेआङ्‌भे़ल्‍ले़ के़से़ःम्‍बा खाम् मे़ने़स्‍से़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","हे़क्‍क्‍याङ् कुभा याॽरिःम्‍बे़न् तिङ्‌ग्रेःक् के़लिङ्‌बा खाम्‍मो चुक्‍ते़, तिङ्‌ग्रेःक्‍किन् नु याॽरिःम्‍बान् सोसोरिक् लिङे़, कर तिङ्‌ग्रेःक्‍हाॽरे़ खे़न् सुःप्‍तु से़रुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","हे़क्‍क्‍याङ् कुभा याॽरिःम्‍बे़न् नुःबा खाम्‍मो चुक्‍ते़आङ् लिङे़, हे़क्‍क्‍याङ् कुजाॽइ कुजाॽ थोःक्‍ते़॥ खे़न् याॽरिःम्‍बाल्‍ले़ किप्‍थिक् ले़ङ्‌ङाङ्धो कुजाॽ थोःक्‍ते़रो॥” ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खे़म्‍मा ने़क्‍खोॽ के़गप्‍पाहाॽरे़ कन् पाःन्‍निन् नुःरिक् खे़प्‍से़म्‍मे़ॽआङ् कुसिङ्‌निःत्ते़म्‍मे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","कुहुॽसाम्‍बाहाॽरे़ ये़सुःन् सेःन्‍मे़दोसु, “कन् खे़दाॽइल्‍ले़ कुबेःन् थे़माबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़न्‌सिगाङ्‌बा पाःन्‍हाॽ खिनिॽरक् कुसिङ्‌निःप्‍मा के़घोःसुम्‍माङ् के़वयिॽरो, कर वेॽ मनाहाॽनु इङ्‌गाॽ खे़दाॽओरक् पाःत्तारो॥ हे़क्‍केःल्‍ले़ ‘कङ्‌हाॽरे़ ओमे़मे़त्तुसाङ् मे़न्‍निःसुन्, मे़घे़प्‍सुसाङ् कुसिङ् मे़न्‍निःत्तुन्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","कन् खे़दाॽइल्‍ले़ कुबेःन् अक्‍तङ्‌बा चोःक्–याॽरिःम्‍बा फाॽइन् निङ्‌वाॽफु पाःन्‍जाक्‍किन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","हे़क्‍क्‍याङ् लाम्‍मो मक्‍के़धाःबा याॽरिःम्‍बाहाॽ पाःन्‍जाक् के़घे़म्‍बा मनासिरो॥ माफे़न्‍साम्‍मिन् ताआङ् खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽओलाम् पाःन्‍जाक्‍किन् लःत्तु तेॽरु॥ हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ नसाःन् चोःक्‍मा मे़ङ्‌घोःसुन्‍नाङ् से़न्‍लप् खोःमा मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","हे़क्‍क्‍याङ् लुङ्‌घाराक्‍को मक्‍के़धाःबा याॽरिःम्‍बाहाॽग पाःन्‍जाक्‍किन् के़घे़म्‍बाआङ् के़सःप्‍पार के़दाःक्‍पासिरो, कर खे़ङ्‌हाॽरे़ नसाःन् मे़जोगु मे़गत्तुबान्‌तुक्‍खे लाक्‍खे ताःल्‍ले़ मे़ले़रु मे़देःसु, थेआङ्‌भे़ल्‍ले़ पाःन्‍जाक्‍किन् खुनिॽ लुङ्‌माॽ सिगाङ् मे़ङ्‌गे़त्ते वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","हे़क्‍क्‍याङ् तिङ्‌ग्रेःक् के़लिङ्‌बा खाम्‍मो के़जुक्‍पा याॽरिःम्‍बाहाॽग पाःन्‍जाक् के़घे़म्‍बा मनाहाॽ कुइसिःक् मे़जोःक्, कर निङ्‌साम्, याङ्‌साकुन्‍धे नु कन् हिङ्‌मन्‍बा याम्‍दादाबा पाःन्‍निल्‍ले़ खे़ङ्‌हाॽ सुःप्‍तुसिआङ् खे़ङ्‌हाॽरे़ कुजाॽ फम्‍मा मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","कर नुःबा खाम्‍मो मक्‍के़धाःबा याॽरिःम्‍बाहाॽग नुःबा नु सेसे निङ्‌वाॽ के़गप्‍पा मनाहाॽ कुइसिःक् मे़जोःक्‌॥ खे़ङ्‌हाॽरे़ पाःन्‍जाक्‍किन् मे़घे़प्‍सुर निङ्‌वाॽओ मे़युक्‍खु हे़क्‍क्‍याङ् नासि मे़धःत्तुआङ् कुजाॽ मे़भत्‍छुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“हाःत्‍ले़आङ् सेमिःन् हाःन्‍दुआङ् खप्‍प्‍या सिगाङ् मे़युक्‍खुन् हे़क्‍क्‍याङ् ने़त्‍ना सिगाङ्‌ङाङ् मे़युक्‍खुन्, कर के़दाःबाहाॽरे़ मे़निःसुर फाॽआङ् थो चन्‍जम्‍बा ते़न्‍नो युक्‍खुॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","आल्‍ल मे़न्‍धाःप्‍मनाबा काक्‌चिगःक्‌वाहाॽ ओःत्तिओ निमे़धाःप् हे़क्‍क्‍याङ् सिबिॽबा पाःन्‍हाॽ के़रे़क् कुसिङ् निःत्ते़त्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","हे़क्‍केःल्‍ले़ के़घे़प्‍सुम्‍बा पाःन्‍निन् निङ्‌वाॽओ नुःरिक्‍काङ् युक्‍खे़म्‍मे़ॽओ॥ इङ्‌गाॽ आनिसाम्‍मिन् ते़न्‍दिङ् के़जोःक्‍पाहाॽरे़ग आल्‍लसाङ् यरिक् कुसिङ्‌निःप्‍मान्‌मे़घोःसुरो, कर आनिसाम्‍मिन् मे़ङ्‌घे़म्‍मनाबाहाॽरे़ कत्तुम्‍बे़ फाॽआङ् मे़इःत्तुबान्‍नाङ्‌मे़नाप्‍तुसिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","आल्‍ल ये़सुरे़ कुम्‍मा नु कुन्‍साॽसि कुदुम्‍से़ मे़द्‌ये़आङ् मे़वये़, कर यरिक् मनाहाॽरे़ मे़जोगुल्‍ले़ कुबेसाङ् पेःक्‍मा मे़न्‍छुक्‍ते़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","हे़क्‍केःल्‍ले़ लत्‍छा मनाधिक्‍ले़ के़म्‍मा नु के़न्‍साॽसि के़दुम्‍से़ मे़द्‌ये़आङ् लाःक्‍कात् के़म्‍हाङ्‌ल मे़ये़प्‍लो लॽरिक् ये़सुःन् मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","कर ये़सुरे़ नोगप् पिरुसि, “निङ्‌वाॽफु पाःन्‍जाक् के़घे़म्‍बाहाॽ हे़क्‍क्‍याङ् खे़न् कुइसिःक् के़जोःक्‍पाहाॽ के़रे़क् इङ्‌गाॽ आम्‍मा नु आन्‍साॽसिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","थिक्‌ये़न् ये़सुःन् कुहुॽसाम्‍बाहाॽनु खःङ्‌बेओ लाःसे़आङ् वरक्‍किल्‍ले़ नाहाङ्‌दाङ् पिगि मे़त्तुसि, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़धासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","खे़ङ्‌हाॽ मे़बेर मे़बत्‍छे़ल्‍ले़ ये़सुःन् इप्‍से़॥ हक्‍चघत् वरक्‍को यम्‍बा सुरित्‌केजङ् हुःमा हेःक्‍ते़आङ् वाभे़ल्‍ले़ङ्‌ङिन् खःङ्‌बेओ लाःसे़आङ् खा खःङ्‌बेन्‍ने़ तिम्‍से़आङ् के़साक्‍पो मे़ध्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","कुहुॽसाम्‍बाहाॽ मे़बेआङ् ये़सुःन् मे़भोःक्‍खुर अक्‍खे मे़मे़त्तु, “आदाङ्‌बे, आदाङ्‌बे, आनिगे़ग हुम्‍मा सिःमा इःत्तिगे़रो॥” हे़क्‍क्‍याङ् ये़सुःन् पोगे़आङ् खे़न् सुरित्‌केजङ्‌ङिन् नु वाभे़ल्‍ले़ङ्‌ङिन्‌फे़ःक्‍तु॥ हे़क्‍क्‍याङ् सुरित्‌केजङ्‌ङिन् हुःमा चक्‍थासु हे़क्‍क्‍याङ् वाभे़ल्‍ले़ङ्‌ङिन्‍नाङ् चिजि ये़म्‌ये़म् लॽरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “खिनिॽ नसाःन्‍निन् आत्तो वाॽबे?” हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ मे़गिसे़र खुनिॽ यङ्‌मा के़रे़आङ् निङ्‌वाॽ मये़र अक्‍खे मे़मे़त्‍छिङ्, “मे़ःन् कङ्‌ग आक्‍तङ्‌बा मनाने़बे? खुने़ॽ इङ्‌जाःङ् पिरुसिल्‍ले़ सुरित्‌केजङ्‌ङिन् नु वाभे़ल्‍ले़ङ्‌ङिल्‍ले़आङ् खे़प्‍सुङ्‌ग!” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ गालिल वरक्‍किल्‍ले़ नाहाङ्‌दाङ्‌बा गेरासेनस लाजेॽओ मे़गे़रे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","खे़ङ्‌हाॽ खे़प्‍मो मे़गे़रे़आङ् ये़सुःन् खःङ्‌बेओलाम् लाःक्‍कात् लःन्‍दे़नुमे़ःन्‍ने पाङ्‌जुम्‍लाम् के़भे़म्‍बा फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबा मनाधिक् खे़प्‍मो तुमु॥ खे़न् मनाःन् यरिक् ये़म्‍माङ्धो हिम्‍मो मे़न्‌वाॽए तेःत्फुङ्‌ङाङ् मे़न्‍जाङ्‌ङे इप्‍पुङ्‌दे़न्हाॽओरक् वये़गत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","खे़ल्‍ले़ ये़सुःन् निःसुआङ् ये़सुरे़ कुलाङ्‌जक्‍को पिर्धाप् थाम्‍सिङ्‌ल यम्‍बा इक्‍लाओ अःक्‍ते़र अक्‍खे मे़त्तु, “के़रे़क्‍नुःल्‍ले़ पयम् यम्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुस्‍साः ये़सुए, खे़ने़ॽ इङ्‌गाॽनु थे के़गोःत्तुबाबे? इङ्‌गाॽ तुक्‍खे मे़जाःत्ताङ्‌ङिन्‍ने़ॽ फाॽआङ् पेलि फाक्‍ने़ॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","थेआङ्‌भे़ल्‍ले़ ये़सुरे़ खे़न् फे़न्‍साम्‍मिन् खे़न् मनाओलाम् आन्‍दे़ःन्‍छा लाःक्‍कात् लःन्‍दे़ॽ फाॽआङ् इङ्‌जाःङ् पिरुआङ् वये़॥ खे़न् मनाःन् यरिक्‍ले़ङ् खे़न् फे़न्‍साम्‍मिल्‍ले़ तुक्‍खे चाःत्तुआङ् वये़॥ मनाहाॽरे़ यरिक्‍ले़ङ् कुहुक् कुलाङ्‌ङो इमे़घेःक्‍खुआङ् के़बप्‍पा फे़न्‍जेॽ थक्‍क्रङ्‌हाॽ फुॽरुआङ् फे़न्‍साम्‍हाॽरे़ एःक्‍सादे़न्‍नो साक्‍के़ल्‍ले़क् मे़देॽरुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ये़सुरे़ खे़न् सेःन्‍दोसु, “के़मिङ् थे़माबे?” खे़ल्‍ले़ आमिङ् तुरारो लॽरिक् नोगप् पिरु॥ थेआङ्‌भे़ल्‍ले़ यरिक् फे़न्‍साम्‍हाॽ खे़न् मनाओ मे़लाःसे़आङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ये़सुःन् आनिगे़ कुद्रोःम् मे़ःन्‍नेबा लुम्‍बाःत्तो याप्‍मि आम्‍बाङ्‌घे़न्‍ने़ॽ फाॽआङ् पेलि मे़भाक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","आल्‍ल खे़न् कोःक्‍माओ यरिक् फाक्‍हाॽ चामे़रामे़र मे़ये़बे़॥ हे़क्‍केःल्‍ले़ खे़न् फे़न्‍साम्‍हाॽरे़ आनिगे़ खे़न् फाक्‍हाॽओ लाःप्‍मा आबाङ्‌घे़ॽ लॽरिक् ये़सुःन् पेलि मे़भाक्‍तु॥ हे़क्‍क्‍याङ् ये़सुरे़आङ् लाःप्‍मा पाङ्‌घुसिआङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","खे़न् मनाओलाम् मे़लःन्‍दे़ मे़बेआङ् खे़ङ्‌हाॽ फाक्‍हाॽओ मे़लाःसे़॥ हे़क्‍क्‍याङ् खे़न् फाक्‍हाॽ सङ्‌माङ्‌ङे सङ्‌माङ् मे़लोःक्‍ते़र याक्‍पे़ओनु मक्‍मे़ध्‍ये़आङ् वरक्‍को मे़हुमे़ मे़स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","हे़क्‍क्‍याङ् फाक् के़गम्‍बाहाॽरे़ कन् पोःक्‍खे़बा पाःन्‍निन् मे़निःसुआङ् खिमो मे़लोःक्‍ते़र मे़बेआङ् पाङ्‌जुम्‍मो नु खे़न् खिरिबा पाङ्‌भेॽहाॽओ कन् इङ्‌घङ्‌ङिन् मे़से़ःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","हे़क्‍क्‍याङ् मनाहाॽ थे़मानि पोःक्‍खे़बे फाॽआङ् ओमे़त्‍छे़ खे़प्‍मो मे़द्‌ये़॥ खे़ङ्‌हाॽरे़ माफे़न्‍साम्‍मिल्‍ले़ तरुबा मनाःन् नुरे़आङ् तेःत् चाक्‍सिङ्‌ङाङ् कुनिङ्‌वाॽ सेःरे़आङ् ये़सुरे़ कुलाङ्‌जक्‍पो युङे़बा मे़निःसुआङ् खे़ङ्‌हाॽ के़रे़क् मे़गिसे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","हे़क्‍क्‍याङ् खे़न् हिन्‍दोःक् के़निःबाहाॽरे़ खे़प्‍मो के़दाःबा मनाहाॽ आक्‍खेलॽरिक् तगि फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबा कन् मनाःन् वेःत्ते़बे फाॽआङ् मे़जे़क्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","हे़क्‍केःल्‍ले़ गेरासेनस लाजेॽओबा मनाहाॽरे़ ये़सुःन् कप्‍मोलाम् पेगे़ॽओ फाॽआङ् पेलि मे़भाक्‍तु, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ साॽरिक् मे़गिसे़आङ् मे़वये़॥ हे़क्‍केःल्‍ले़ ये़सुःन् पेःक्‍मा फाॽआङ् खःङ्‌बेओ लाःसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","फे़न्‍साम्‍हाॽरे़ मे़ले़रुबा खे़न् मनाःन् खे़ॽयो त्‍ये़आङ् ये़सुःन् आदाङ्‌बे, इङ्‌गाॽआङ् खे़ने़ॽनुए तेॽराङ्‌ङे़ॽओ फाॽआङ् पेलि फाक्‍तु, कर ये़सुरे़ अक्‍खे मे़त्तुर नुःक्‍तुदेःसु, ");
INSERT INTO lifNT2_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“खे़ने़ॽ के़हिम्‍मो पेगे़ॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़ने़ॽ के़लागि चोगु के़बिरे़बा पाःन्‍निल्‍ले़ कुयाःम्‍बेओ इङ्‌घङ् से़ःसे़ॽओ॥” हे़क्‍क्‍याङ् खे़न् मनाःन् पेआङ् ये़सुरे़ खुने़ॽ कुलागि चोगुबा काक् पाःन्‍निन् काक् पाङ्‌जुम्‍मो से़ःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","हे़क्‍क्‍याङ् ये़सुःन् याम्‍मो वरक्‍किल्‍ले़ नाहाङ्‌दाङ् के़रे़ल्‍ले़ खे़प्‍मो यरिक् मनाहाॽरे़ खुने़ॽ लाङ्‌दाःक्‍मा मे़बिरु, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ मे़हाङ्‌घुर मे़युङे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","हे़क्‍क्‍याङ् याइरस मिङ् के़वाःप्‍पा मनाधिक् खे़प्‍मो त्‍ये़॥ खुने़ॽ पाङ्‌तिबा यहुदि चुम्‍लुङ्‌हिम्‍मोबा सुहाङ्‌युक्‍पा वये़॥ खे़ल्‍ले़ ये़सुरे़ कुलाङ्‌जक्‍को हबत्‌फन्‍छिङ्‌ल आहिम्‍मो फे़रे़ॽओ फाॽआङ् पेलि फाक्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","थेआङ्‌भे़ल्‍ले़ तङ्‌बे थिक्-ने़त् (१२) के़गे़प्‍मा थिक्‍लक् कुस्‍साः मे़न्‍छुमाॽइन् सिःमा लिङ्‌धोओ के़रे़आङ् ने़स्‍से़॥ हे़क्‍क्‍याङ् ये़सुःन् खे़न्‍नुए थासिङ्॥ हे़क्‍क्‍याङ् पेर पत्‍छे़ल्‍ले़ यरिक् मनाहाॽरे़ खुने़ॽ चिबुःत् मे़बुःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","खे़प्‍मो तङ्‌बे थिक्-ने़त्ताङ्‌धो (१२) आत्तिल्‍ले़आङ् वेःम्‍मा मे़न्‍छुक्‍तुम्‍मा माक्‍खिॽ वयुःमाल्‍ले़ तरुमा मे़न्‍छुमाॽधिक् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","खे़न् ये़सुरे़ कुएगाङ् त्‍ये़आङ् कुदेःत्तिल्‍ले़ कुयाःन्‌सुःसुनुमे़ःन्‍ने माक्‍खिॽ वयुःमान् चिबे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ये़सुरे़ सेःन्‍दोसुसि, “इङ्‌गाॽ हाःत्‍ले़ सुःसाङ्‌बे?” हे़क्‍क्‍याङ् के़रे़क्‍ले़ इङ्‌गाॽ मे़ःन् लॽरिक् मे़बाःत्तुआङ् पत्रुसरे़ मे़त्तु, “आदाङ्‌बे, अक्‍खेलॽरिक् के़रे़क् पिसाङ्‌लाम् मनाहाॽरे़ चिभिःत् के़म्‍भिःत्ते़आङ् के़म्‍एःप्‍ल मे़बत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","कर ये़सुरे़ नोगप् पिरु, “इङ्‌गाॽ हाःत्‍ले़इग सुःसाङ्लो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आधक्‍कोनु मुक्‍साम् लःन्‍दे़बा निङ्‌वाॽ खोःसुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","खे़न् मे़न्‍छुमाॽइल्‍ले़आङ् इङ्‌गाॽ चिङ्‌सिङ्‌मा मे़सुक्‍कान् के़लॽबा निङ्‌वाॽ खोःसुआङ् कुगिःमाल्‍ले़ यक्‍खे़र ये़सुरे़ कुलाङ्‌जक्‍को हबत्‌फन्‍छिङ्‌लो॥ खे़ल्‍ले़ के़रे़क् मनाहाॽरे़ खुनिॽ तगिए खुने़ॽ सुःसुल्‍ले़ आक्‍खेलॽरिक्‌खिमो वेःत्ते़बा पाःन्‍निन् ये़सुःन् चे़क्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ये़सुरे़ खे़न् मे़न्‍छुमाॽइन् मे़त्तु, “मामुए, खे़ने़ॽ नसाःन् के़जोगुबाल्‍ले़ चोगुल्‍ले़ के़वेःत्ते़आङ् के़वाॽरो॥ आल्‍ल नुःरिक्‍काङ् पेगे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","अक्‍खेलॽरिक् पारे़र पत्‍छे़ल्‍ले़ खे़न् लाम्‍लोःबा याइरसरे़ कुहिम्‍मोलाम् मनाधिक् त्‍ये़आङ् मे़त्तु, “आदाङ्‌बे, के़स्‍साःङ्‌ग स्‍ये़रो, आल्‍ल सिक्‍साम्‍बे़न् तुक्‍खे चाःत्तुम् मे़ःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","कर ये़सुरे़ खे़न् खे़प्‍सुआङ् याइरसे़न् मे़त्तु, “खे़ने़ॽ मे़गिसे़न्‍ने़ॽओ, नसाःन्‍लक् चोगे़ॽ॥ खुने़ॽ वेःत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","हे़क्‍क्‍याङ् ये़सुःन् याइरसरे़ कुहिम्‍मो के़रे़आङ् पत्रुस, याकुब नु युहुन्‍नाःन् हे़क्‍क्‍याङ् खे़न् चुक्‍माल्‍ले़ कुम्‍बा कुम्‍मासिनुःल्‍ले़ वेॽ आत्तिन्‍नाङ् खे़न् चुक्‍मे़न् ने़स्‍से़बा ते़न्‍नो पेःक्‍मा मे़बाङ्‌घुन्‍सिन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","खे़प्‍मो मनाहाॽ मे़हाबे़र, मेरिङ् थक्‍नु मे़युङे़॥ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ मे़हाबे़म्‍मिन्‍ने़ॽ, खुने़ॽ मे़न्‍छिॽए वाॽ, इप्‍से़आङ्‌लक् ने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ ये़सुःन् मे़एःत्तु, थेआङ्‌भे़ल्‍ले़ खे़न् चुक्‍मे़न् स्‍ये़बा मे़निःसुआङ् मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ये़सुरे़ खे़न् चुक्‍मे़न् कुहुक्‍को ते़म्‍सुआङ् “मामुए, पोगे़ॽओ” मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","खिमो साःङ्‌गुगे़न् कुसक्‍मा नुःक्‍खे़ त्‍ये़आङ् मुत्‍थ्रिक् पोगे़आङ् युङ्‌सिङ्॥ ये़सुरे़ खे़ङ्‌हाॽ “खे़न् थे़माइ चामा पिरे़म्‍मे़ॽ” मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","कुम्‍बा कुम्‍मासिरे़ खुन्‍छिॽ निङ्‌वाॽ मये़, कर ये़सुरे़ खे़ङ्‌हाॽ कन् पाःन्‍निन् हाःत्ताङ् मे़मे़त्ते़म्‍मिन्‍ने़ॽ फाॽआङ् इङ्‌जाःङ् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","आल्‍ल ये़सुरे़ थिक् ने़त् (१२) कुहुॽसाम्‍बाहाॽ कुबेसाङ् उःत्तुसिआङ् के़रे़क् फे़न्‍साम्‍हाॽ नाःप्‍मा लःप्‍मा नु के़दुक्‍पाहाॽ वेःम्‍मा मुक्‍साम् नु युक् पिरुसिआङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","खे़ङ्‌हाॽ निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़ कुयाःम्‍बेओबा सुनाइङ् से़ःसे़ नु के़दुक्‍पाहाॽ वेःन्‍छे़ पाङ्‌घुदेःसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ अक्‍खे मे़त्तुसि, “खिनिॽ लाम्‍दिःक्‍को के़बेगिल्‍ले़ तक्‍काःत्, सुःक्‌वा, चामा चा, याङ्, हे़क्‍क्‍याङ् वेॽ ले़क्‍सिङ्‌मा चाङ् थेआङ् मे़याङ्‌ङासिम्‍मे़न्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","खिनिॽ आत्तिन् हिम्‍मो लाङ्‌दाःक्‍मा के़म्‍बिरिॽ, खे़न् पाङ्‌जुम्‍मिन् मे़ल्‍ले़त्ते थारिक् खे़न् हिम्‍मोए याःक्‍ते़म्‍मे़ॽ, ");
INSERT INTO lifNT2_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","कर मनाहाॽरे़ खिनिॽ लाङ्‌दाःक्‍मा के़मे़म्‍बिरिन्‍ने़ फाॽग्र खे़न् पाङ्‌जुम्‍मिन् के़ले़रुम्‍मिल्‍ले़ खिनिॽ लाङ्‌ङो के़घिप्‍पा खाम् हिःक्‍किन् थाप्‍से़म् थ्‍ये़म्‍मे़ॽ॥ कङ्‌ग खुनिॽ तक्‍ले़ङ्‌वाओ के़बोःङ्‌बा मिक्‍सेःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ पाङ्‌भेॽ पाङ्‌भेॽओ मे़बेआङ् सुनाइङ् मे़से़ःसुआङ् के़दुक्‍पा के़यॽबाहाॽ मे़वेःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","आल्‍ल गालिल थुम्‍मोबा सुहाङ्‌गे़म्‍बा हे़रोद एन्‍तिपासरे़ कन् के़रे़क् पोःक्‍खे़बा पाःन्‍हाॽ खे़प्‍सुआङ् खुने़ॽ कुनिङ्‌वाॽ मये़, थेआङ्‌भे़ल्‍ले़ कुभारे़ “बप्‍तिस्‍मा के़बिबा युहुन्‍नाःन् याम्‍मो हिङे़आङ् वाॽरो” मे़बाःत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","वेॽहाॽरे़ “माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलियाःन् याम्‍मो लःन्‍दे़आङ् वाॽ” मे़बाःत्तु, हे़क्‍क्‍याङ् आल्‍लसाङ् वेॽ मनाहाॽरे़ “उन्‍छोःन्‍बा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाधिक्‌याम्‍मो हिङे़आङ् वाॽ” मे़बाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","हे़क्‍केःल्‍ले़ हे़रोदरे़ पाःत्तु, “बप्‍तिस्‍मा के़बिबा युहुन्‍नाःङ्‌ग कुनिःङ्‌मान्‌खक् पाङ्‌घुङ्‌सिङ्‌ङाङ् वये़, कर आक्‍खेलॽरिक् याम्‍मो हिङे़बे? इङ्‌गाॽ कन् थेःन्‍ने़ खे़प्‍सुङ्‌बे?” हे़क्‍क्‍याङ् खुने़ॽए ओमे़प्‍मा निङ्‌वाॽ चोगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","हे़क्‍क्‍याङ् सेःक्‌युक्‍मिबाहाॽ मे़नुःक्‍खे़ मे़द्‌ये़आङ् खे़ङ्‌हाॽरे़ मे़जोगुबा याःम्‍बक्‍हाॽ ये़सुःन् मे़जे़क्‍तु॥ हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ बे़थसेदा पाङ्‌जुम् ले़प्‍माङ् स्‍वाःत्ताङ् तेॽरुसिआङ् पे, ");
INSERT INTO lifNT2_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","कर यरिक् मनाहाॽरे़ खे़न् निङ्‌वाॽ मे़घोःसुआङ् खे़ङ्‌हाॽरे़ खुनिॽ एगाङ् एगाङ् मे़धासिङ्॥ ये़सुरे़ खे़ङ्‌हाॽ के़रे़क् लाङ्‌दाःक्‍मा पिरुसिआङ् निङ्‌वाॽफुहाङ्‌जुम्‍बा पाःन्‍हाॽ चे़क्‍तुसि, हे़क्‍क्‍याङ् के़दुक्‍पा के़यॽबाहाॽ वेःन्‍दुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","हे़क्‍क्‍याङ् नाम्‍ध्‍ये़र पत्‍छे़ल्‍ले़ थिक् ने़त् कुहुॽसाम्‍बाहाॽ मे़द्‌ये़आङ् मे़मे़त्तु, “आदाङ्‌बा सिक्‍साम्‍बे, कन् मनाहाॽ पाङ्‌घे़देःसे़से़ॽओ॥ हे़क्‍क्‍याङ् खे़न् खिरिबा पाङ्‌जुम्‍मो मे़बेःक्‍काङ् चामा थुङ्‌मा नु याङ्‌धोःक्‍मारे़न्‌तङ्‌गाम् मे़जोगुररो, थेआङ्‌भे़ल्‍ले़ आनिॽग एःक्‍सादे़न्‍नो आवाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽए कङ्‌हाॽ कुजा पिरे़म्‍सिम्‍मे़ॽओ” कर खे़ङ्‌हाॽरे़ मे़बाःत्तु, “आनिगे़ग ङासि खरे़ःङ् नु ने़त्‍छि ङारक् कत्तुम्‍बे़रो॥ वेॽ थेआङ् होःप्॥ वेॽ खरे़ःङ् मे़न्‍इङ्‌ङे कन् मनाहाॽ आक्‍खेलॽरिक् योमासिबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(खे़प्‍मो हे़न्‍छिङ् ङासि (५०००) यारिक् ये़म्‍बित्‍छाॽहाॽ मे़वये़रो॥) ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “खे़ङ्‌हाॽ ङागिप्‌रे़न्‌(५०) लुप्‍पो थे़ःक्‍पे़त्ताङ्‌युङ्‌मा पाङ्‌घे़म्‍सिम्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽरे़ बा हे़क्‍केलॽरिक् के़रे़क् मनाहाॽ मे़युक्‍खुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ये़सुरे़ ङासि खरे़ःङ्‌हाॽ नु ने़त्‍छि ङाहाॽ पक्‍खुआङ् थो साङ्‌ग्राम्‍पेदाङ् ले़प्‍माङ् ओमये़र निङ्‌वॽफुमाङ्‌ङिन् नोगे़न् पिरुआङ् खे़न् खरे़ःङ्‌हाॽ नु ङाहाॽ खे़ःक्‍खुआङ् कुहुॽसाम्‍बाहाॽ खे़न् मनाहाॽ मे़हाःत्तुसिर फाॽआङ् पिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खाघा मे़जआङ् मे़नन्‍छुबा कुजिहाॽ मे़सुप्‍सुल्‍ले़ थिक्-ने़त् (१२) नइमा योरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","थिक् ये़न् ये़सुःन् एःक्‍सादे़न्‍नो तुवा चोःक्‍नु वये़ल्‍ले़ कुहुॽसाम्‍बाहाॽ खे़प्‍मो मे़द्‌ये़॥ ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “इङ्‌गाॽ हाःत्‍आबे फाॽआङ् मनाहाॽरे़ मे़बाःत्तुॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","हे़क्‍केःल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ नोगप् मे़बिरु, “कुभारे़ खे़ने़ॽ बप्‍तिस्‍मा के़बिबा युहुन्‍ना नु वेॽहाॽरे़ग एलिया फाॽआङ् के़म्‍मे़त्‍लो॥ कुभारे़ग उन्‍छोःन्‍बा वेॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाधिक्‌सिःमे़न्‍लाम् याम्‍मो हिङे़आङ् वाॽ फाॽआङ् के़म्‍मे़त्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो सेःन्‍दोसुसि, “कर खिनिॽग, इङ्‌गाॽ हाःत्‍आबे फाॽआङ् याप्‍मि के़मे़त्तिॽबे?” पत्रुसरे़ नोगप् पिरु, “खे़ने़ॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तने़ॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ये़सुरे़ खे़ङ्‌हाॽ कन् पाःन्‍निन् आत्तिन्‍हाॽआङ् मे़मे़त्ते़म्‍सिम्‍मे़न्‍ने़ॽ फाॽआङ् इङ्‌जाःङ् पिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़ यरिक् तुक्‍खेहाॽ तुम्‍मा पोःङ्॥ हे़क्‍क्‍याङ् यहुदि तुम्‍लाम्‍लोःबाहाॽरे़, तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ मे़नाॽआ, हे़क्‍क्‍याङ् मे़से़त्ताआङ्‌सुम् ये़न् एगाङ् सिःमे़न्‍लाम् याम्‍मो हिङ्‌ङारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो मे़त्तुसि, “आत्तिल्‍ले़ इङ्‌गाॽ तिम्‍मा निङ्‌वाॽ चोगुॽ, हाराॽ खे़ल्‍ले़ इङ्‌गाॽरक् चाङ्‌थुङुङ् के़लॽबा कुनिङ्‌वाॽइन्‌से़रुआङ् थिक्‌याःन्‍धक् सिलाम्‍साक्‍मा कुसिङ्‌ङिन् पक्‍खुआङ् इङ्‌गाॽ तिम्‍माररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","थेआङ्‌भे़ल्‍ले़ आत्तिल्‍ले़ कुहिङ्‌मन्‍निन् ताङ्‌से़ःप्‍तुङ् लॽरिक् निङ्‌वाॽ चोगुॽ, खे़ल्‍ले़ खे़न्‍नाङ् मासुॽ, कर आत्तिल्‍ले़ कुहिङ्‌मन्‍निन् आलागि मासुॽ, खे़ल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","मे़न्‍छाम् याप्‍मिःल्‍ले़ काक् इक्‍सादिङ् खाम्‍बेःक्‍मान् खुने़ॽइन् चोगुसाङ् कुहिङ्‌मन्‍निन् माःसुने़ फाॽग्र नुःबा पोःङ्‌बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","आत्तिन् मनाःन् इङ्‌गाॽनु हे़क्‍क्‍याङ् आबाःन्‍जाक्‍किन्‍नु सिरिङ् मःॽ, इङ्‌गाॽ मे़न्‍छाम्‍साःन्‍नाङ् आमिमिदिङ्‌नु, आम्‍बारे़ कुमिमिदिङ्‌नु हे़क्‍क्‍याङ् सेसे माङ्‌लाइङ्‌बाहाॽरे़ खुनिॽ मिमिदिङ्‌नु युःआल्‍ले़ खे़न्‍निन् आमना पाःप्‍मा सिरिङ् मःआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, कप्‍मो के़ये़प्‍पा कुभा मनाहाॽरे़ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् युःबा मे़न्‍निए थारिक् मे़न्‍छिःने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","खे़न् पाःन्‍निन् पाःत्तुबा ये़त्‍छि (८) ये़न् एगाङ् ये़सुरे़ पत्रुस, युहुन्‍ना नु याकुबे़न् तेॽरुसिआङ् कोःक्‍माओ थो तुवा चोःक्‍से़ पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","खुने़ॽ तुवा चोःक्‍नु पत्‍छे़ल्‍ले़ कुनाराःन् ले़क्‍सिङ्‌ल पेआङ् खुने़ॽ कुदेःत्‍हाॽ मिक् के़जे़म्‍बा फःगे़लॽबा पोःक्‍खे़र ले़क्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","हे़क्‍क्‍याङ् खे़प्‍मो ने़प्‍फु मनाहाॽ साङ्‌ग्राम्‍गे़न्‌ओःत्तिबा मिमिदिङ्‌ङो थाःम्‍ने़त्‍छिआङ् ये़सुःन्‍नु ताॽजे़क्‍खे़त्‍छि॥ खे़ङ्‌हाॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलियाःन् नु मोसाःन् वये़त्‍छिरो॥ खे़ङ्‌हाॽरे़ ये़सुरे़ कुसिःमे़न् नु यरुसले़म्‍मो चोःक्‍मा सुःप्‍मा इःत्ते़बा याःम्‍बक्‍किल्‍ले़ कुयाःम्‍बेओ ताॽमे़जे़क्‍खे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","पत्रुस नु कुन्‍जुम्‍हाॽ मे़इप्‍से़आङ् मे़ने़स्‍से़, कर खे़ङ्‌हाॽ तादाप् लॽरिक् मे़सोरे़ल्‍ले़ ये़सुरे़ कुमिमिदिङ्‌ङिन् हे़क्‍क्‍याङ् खे़न् ने़प्‍फु मनाहाॽ खुने़ॽनु ये़बे़त्‍छिबा मे़निःसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","हे़क्‍क्‍याङ् खे़न् मनाहाॽरे़ ये़सुःन् पक्‍थ्‍ये़सुआङ्‌पेसिर पत्‍छे़त्‍छिल्‍ले़ पत्रुसरे़ ये़सुःन् मे़त्तु, “सिक्‍साम्‍बे, आनिॽग कप्‍मोए आवाॽइल्‍ले़ नुःबा पोःङ्‌लो॥ आनिगे़ कप्‍मो सुम्‍सि याक्‍साहाॽ चोगुम्‍बे़ॽ, थिक् खे़ने़ॽइन् हे़क्‍क्‍याङ् मोसाःन् नु एलियारे़ खुन्‍छिॽ लागिआङ् थिक् थिक् चोगुम्‍बे़ॽरो!” (कर खुने़ॽ थेःन् पाःत्तुङ्‌बे फाॽआङ् थेआङ् कुनिङ्‌वाॽ मे़यागे़न्॥) ");
INSERT INTO lifNT2_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","खुने़ॽ पारे़र पत्‍छे़ल्‍ले़सा खे़प्‍मो खाप्‍मिःत्तिल्‍ले़ खे़ङ्‌हाॽ ते़प्‍तुसि, हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽ साॽरिक् मे़गिसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","खाप्‍मिःत्तोलाम् इक्‍लाधिक् त्‍ये़, “कन् आस्‍साःरो, खुने़ॽए सेगुङ्‌ङाङ् वाॽआरो! खुने़ॽ पाःत्तुबा पाःन्‍निन् खे़प्‍से़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","खे़न् इक्‍लाःन् पारे़ चुरे़आङ् खे़प्‍मो ये़सुःन्‍लक् मे़निःसुरो॥ हुॽसाम्‍बाहाॽरे़ कन् पाःन्‍निन् खुनिॽ निङ्‌वाॽ सिगाङ् मे़युक्‍खुआङ् खे़न् ये़म्‍मो आत्तिन्‍हाॽआङ् मे़म्‍मे़त्तुन्‍छिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","कुदाःन्‍दिक्‍मा खे़ङ्‌हाॽ कोःक्‍माओनु यो मे़ध्‍ये़, हे़क्‍क्‍याङ् यरिक् मनाहाॽरे़ मे़दुमुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","खे़न् मनाहाॽओ थिक्‍ले़ कुस्‍साः चुक्‍पे़न् फे़त्तुआङ् यम्‍बा इक्‍लाओ अःक्‍ते़र मे़त्तु, “सिक्‍साम्‍बे, इङ्‌गाॽ आस्‍साःन् ओमे़त्ताङ् पिराङ्‌ङे़ॽ फाॽआङ् पेलि फाक्‍ने़ॽरो॥ कन् लत्‍थिक्‍लक् आस्‍साःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ए़त्‍ले़ङ् फे़न्‍साम्‍मिल्‍ले़ फत्तु, तुक्‍खे चाःत्तुआङ् खाम्‍मो पिर्धाप् थाप्‍सु, हे़क्‍क्‍याङ् सल्‍लिक् सन्‍छिङ्‌लो॥ हे़क्‍क्‍याङ् कुमुराओलाम् कुध्‍याःत् लःत्तुरो॥ फे़न्‍साम्‍मिल्‍ले़ सप्‍फा सप्‍फारक् ले़रुआङ् खुने़ॽग मे़ङ्‌मा इःत्तुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","इङ्‌गाॽ के़हुॽसाम्‍बाहाॽ कन् फे़न्‍साम्‍मिन् आस्‍साःल्‍लोलाम् नाःत्ते़म् आबिरे़म्‍मे़ॽ फाॽआङ् पेलि फाक्‍तुङ्‌सिङ्, कर मे़न्‍छुक्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","हे़क्‍केःल्‍ले़ ये़सुरे़ नोगप् पिरु, “नसाःन् के़होःप्‍पा नु ताक्‍के़भे़ॽबा मनासे, आप्‍फाल्‍ले़ थारिक् इङ्‌गाॽ खिनिॽनु वाॽआआङ् नासि थःत्‍निङ्‌बाबे? खे़न् चुक्‍पे़न् कत्‍ना फे़त्ते़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","हे़क्‍क्‍याङ् खे़न् चुक्‍पे़न् ये़सुःन् ले़प्‍माङ् पेर पत्‍छे़ल्‍ले़ फे़न्‍साम्‍मिल्‍ले़ फत्तुआङ् पिर्धाप् थाप्‍सु, कर ये़सुरे़ खे़न् फे़न्‍साम्‍मिन् खे़न् चुक्‍पे़ल्‍लोलाम्‌लःन्‍दे़ पेगे़ॽ फाॽआङ् इङ्‌जाःङ् पिरु हे़क्‍क्‍याङ् खे़न् चुक्‍पे़न् वेःन्‍दुआङ् कुम्‍बा पिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ यम्‍बा कुमुक्‍साम्‍मिन् मे़निःसुआङ् के़रे़क् मनाहाॽरे़ खुनिॽ निङ्‌वाॽ मये़॥ ये़सुरे़ चोगुबा के़रे़क् याःम्‍बक्‍को मनाहाॽरे़ खुनिॽ निङ्‌वाॽ मये़ल्‍ले़ ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“आबाःन्‍निन् खे़प्‍से़म्‍मे़ॽओ-आल्‍ल मे़न्‍छाम्‍साःन् इङ्‌मे़ले़क्‍त्तुॽ हे़क्‍क्‍याङ् मनाहाॽरे़ खुनिॽ हुक्‍को हुक् मे़सुप्‍तु मे़बिरुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","कर ये़सुरे़ पाःत्तुबा पाःन्‍निन् कुसिङ् मे़न्‍निःत्तुन्, थेआङ्‌भे़ल्‍ले़ खे़न् पाःन्‍निन् खुनिॽओलाम् माॽरे़आङ् वये़॥ खे़ङ्‌हाॽरे़ याम्‍मो सेःन्‍दोःमाआङ् मे़गिसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ आनिॽओ के़रे़क्‍नुःल्‍ले़ यम्‍बा हाःप्‍पे फाॽआङ् पाःन् मे़धक्‍ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","कर ये़सुरे़ खुनिॽ निङ्‌वाॽइन्‌निःसुआङ् चुक्‍पा हिन्‍जाॽधिक् फे़त्तुआङ् खुनिॽ तगि ये़प्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “आत्तिल्‍ले़ आमिङ्‌ङो अक्‍तङ्‌बा चुक्‍सा हिन्‍जाॽइन् लाङ्‌दाःक्‍तुॽ, खे़ल्‍ले़ इङ्‌गाॽ लाङ्‌दाःक्‍कारो॥ इङ्‌गाॽ याप्‍मि लाङ्‌गे़दाःक्‍पाल्‍ले़ इङ्‌गाॽ याप्‍मि के़बाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन्‍नाङ् लाङ्‌दाःक्‍तुॽ॥ आत्तिन् खिनिॽओ के़रे़क्‍नुःल्‍ले़ चुक्‍सा चोःक्, खे़न्‍ने के़रे़क्‍नुःल्‍ले़ यम्‍बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","हे़क्‍क्‍याङ् युहुन्‍नाःल्‍ले़ खुने़ॽ मे़त्तु, “आदाङ्‌बा सिक्‍साम्‍बे, आनिगे़ लत्‍छा मनाधिक्‍ले़ खे़ने़ॽ के़मिङ्‌ङो फे़न्‍साम्‍हाॽ नाःत्तु लःत्तुसिर पत्‍छे़बा निःसुम्‍बे़आङ् आनिगे़ खे़न् हे़क्‍के चोःक्‍मा मे़बाङ्‌घुम्‍बे़न्‍लो, थेआङ्‌भे़ल्‍ले़ खे़न् आनिगे़नु थिक् हुप्‍पो मे़वाॽने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ये़सुरे़ खे़न् नोगप् पिरु, “खे़न् हे़क्‍के चोःक्‍मा मे़साक्‍ते़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ हाःत् खिनिॽ तक्‍ले़ङ्‌वाओ होःप्‌, खे़न् खिनिॽ ले़प्‍माङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","हे़क्‍क्‍याङ् खुने़ॽ साङ्‌ग्राम्‍पेदाङ्‌ङो कुबेःक्‍मा ये़म् त्‍ये़र पत्‍छे़बाल्‍ले़ खुने़ॽ यरुसले़म ले़प्‍माङ् पेःक्‍मा निङ्‌वाॽ चोगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","खुने़ॽ इङ्‌साबाहाॽ तगि पाङ्‌घुसिरो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽआङ् सामरिहाॽरे़ खुनिॽ पाङ्‌भेॽओ चामा थुङ्‌मा नु से़न्‍दिक् याङ्‌धोःक्‍से़ मे़बे, ");
INSERT INTO lifNT2_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","कर सामरिहाॽरे़ खुने़ॽ लाङ्‌दाःक्‍मा मे़म्‍बिरुन्, थेआङ्‌भे़ल्‍ले़ खुने़ॽ यरुसले़म ले़प्‍माङ् पेर पत्‍छे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","हे़क्‍केःल्‍ले़ खे़न् निःसे़त्‍छुआङ् कुहुॽसाम्‍बाहाॽ याकुब नु युहुन्‍नारे़ ये़सुःन् सेःन्‍दोःसे़त्‍छु, “आदाङ्‌बे, आनिगे़ साङ्‌ग्राम्‍पेदाङ्‌लाम् मिराःक् थाःसुम्‍बे़आङ् कन् पाङ्‌भेॽइन् खाप्‍पु थ्‍यःङ् चोगुम्‍बे़ॽ के़लॽबा निङ्‌वाॽ के़जोगुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","कर ये़सुरे़ हिसिङ्‌ङाङ् फे़ःक्‍तुसिर ((अक्‍खे मे़त्तुसि, “खिनिॽ आक्‍तङ्‌बा याम्‍साम् के़गत्तुम् फाॽआङ् के़न्‍निःसुम्‍मिन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","हे़क्‍केलॽरिक् मे़न्‍छाम्‍साःन् हिङ्‌मन् मे़ङ्‌से़ मे़ःन्, कर ताङ्‌से़ःप्‍से़ त्‍ये़बारो॥”)) हे़क्‍क्‍याङ् खे़ङ्‌हाॽ वेॽस्‍मा पाङ्‌भेॽओ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","हे़क्‍क्‍याङ् लाम्‍मो लाङ्‌मे़घेगे़र मे़बत्‍छे़ल्‍ले़ मनाधिक् त्‍ये़आङ् मे़त्तु, “सिक्‍साम्‍बे, खे़ने़ॽ आत्ति के़बेःक्‍साङ् खे़ने़ॽनु पेःक्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","कर ये़सुरे़ नोगप् पिरु, “किदिःप्‍पाहाॽरे़ लुङ्‌घुरि मे़गत्तुॽ, पुसाहाॽरे़ हाप् मे़गत्तुॽ, कर इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़ग थे़गेःक् ने़मा ते़न्‍नाङ् मे़गत्तान्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","हे़क्‍क्‍याङ् ये़सुरे़ वेॽस्‍मा मनाःन् मे़त्तु, ‘इङ्‌गाॽ तिम्‍दाङ्‌ङे़ॽओ॥’” कर खे़न् मनाःल्‍ले़ नोगप् पिरु, “आदाङ्‌बे, तगि इङ्‌गाॽ के़सिःबा आम्‍बाःन् इप्‍पुङ्‌ङो चिङ्‌से़ पेःक्‍मा पाङ्‌घाङ्‌ङे़ॽओ” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ये़सुरे़ खे़न् मे़त्तु, “हाराॽ याम्‍साम्‍मो के़सिःबा मनाहाॽरे़ खुनिॽ आबाङे चेहाॽ इप्‍पुङ्‌ङो मे़जिक्‍खुसिर, कर खे़ने़ॽ निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़ कुयाःम्‍बेओ इङ्‌भन् से़ःसे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","हे़क्‍क्‍याङ् वेॽस्‍मा मनाःन् त्‍ये़आङ् ये़सुःन् मे़त्तु, “आदाङ्‌बे, इङ्‌गाॽ खे़ने़ॽ नाःत्‍ने़ॽरो, कर के़रे़क्‍नुःल्‍ले़ तगि इङ्‌गाॽ आहिम्‍सयङ्‌हाॽनु से़म्‍मुॽइ चोःक्‍से़ पाङ्‌घाङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","कर ये़सुरे़ खे़न् नोगप् पिरु, “हाःत्‍ले़ कुहुक्‍किन् के़क्‍चुओ फत्‍छुआङ् एगाङ् ओमे़त्तु, खे़न् निङ्‌वाॽफुहाङ्‌जुम्‍मो माङ्‌सेवा याःम्‍बक् चोःक्‍मा मे़लाॽरुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","खे़न् एगाङ् दाङ्‌बारे़ वेॽ नु-ने़त् (७२) मनाहाॽ सेगुसिआङ् पेर पत्‍छे़बा पाङ्‌जुम्‍हाॽ नु पाङ्‌भेॽहाॽओ ने़प्‍फु ने़प्‍फु लॽरिक् इङ्‌भन् से़ःसे़ पाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ अक्‍खे मे़त्तुसि, “सुम्‍मा के़बोःङ्‌बा चाःन् यरिक् ने़ःॽ, कर चा के़सुम्‍बा याःलिक्‍हाॽ मे़सुःन्‍लो॥ हे़क्‍केःल्‍ले़ सुम्‍मा के़बोःङ्‌बा चाःल्‍ले़ कुन्‍दाङ्‌बान् यरिक् याःलिक्हाॽ चा सुम्‍से़ पाङ्‌घुसिर फाॽआङ् खिनिॽ तुवा चोगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","मे़ल्‍लुक्‍साःहाॽ पराबाहाॽरे़ खुनिॽ लुम्‍मो पाङ्‌मनाबा कुइसिःक् इङ्‌गाॽ पाङ्‌निङ्‌लो॥ आल्‍ल पेगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","खिनिॽ लाम्‍दिःक्‍को साब्रिहाॽ, सुःक्‌वाहाॽ हे़क्‍क्‍याङ् लाङ्‌सुःप्‍हाॽ थेआङ् मे़याङ्‌ङासिम्‍मे़न्‍ने़ॽओ, हे़क्‍क्‍याङ् लाम्‍मो मनाहाॽनु सेवा मये़म्‍मे़ॽर मे़हम्‍सिङ्‌ङे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","खिनिॽ आत्तिन् हिम्‍मो के़लाःस्‍सि के़रे़क्‍नुःल्‍ले़ तगि कन् हिम्‍मो हाराॽ सनारुङ् तानिरो लॽरिक् पाःत्ते़म्‍मे़ॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","खे़न् हिम्‍मो सनारुङ् खोःमा लाॽरुबा मना वाॽने़ फाॽग्र खिनिॽ सनारुङ्‌ङिन् खे़प्‍मो वाॽ लाःत्‍लो, कर हे़क्‍तङ्‌बा मनाःन् होःप्‍ने़ फाॽग्र खिनिॽ सनारुङ्‌ङिन् खिनिॽओए याङ्‌ना नुःङ् ताःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","आत्तिन् हिम्‍मो खिनिॽ के़वयिॽ, बा खे़प्‍मोए वये़म्‍मे़ॽआङ् खिनिॽ के़म्‍बिरिबा चामा थुङ्‌माहाॽ चे़म्‍मे़ॽ थुङे़म्‍मे़ॽ, थेआङ्‌भे़ल्‍ले़ याःलिक्‍किन् नाम्‌याक् खोःमा लाॽरुरो॥ खिनिॽ हिम् थप्‍मे ताक्‍मे़गन्‍दे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","खिनिॽ आत्तिन् पाङ्‌जुम्‍मो के़लाःस्‍सिल्‍ले़ लाङ्‌दाःक्‍मा के़म्‍बिरिॽ हे़क्‍क्‍याङ् खिनिॽ के़म्‍दोःन्‍दिॽ के़म्‍बिरिबा चाहाॽ चे़म्‍मे़ॽ, ");
INSERT INTO lifNT2_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","के़दुक्‍पा के़यॽबाहाॽ वेःन्‍दे़म्‍सिम्‍मे़ॽआङ् अक्‍खे मे़त्ते़म्‍सिम्‍मे़ॽ, ‘निङ्‌वाॽफुहाङ्‌जुम्‍मिन् खिनिॽ निःत्ताङ् त्‍ये़आङ् वाॽरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","कर आत्तिन् पाङ्‌जुम्‍मो खिनिॽ लाङ्‌दाःक्‍मा के़मे़म्‍बिरिन्, खे़न् पाङ्‌जुम्‍हाॽओबा लाम् हे़ङ्‌घाःत्ति लःन्‍दे़म्‍मे़ॽआङ् खे़ङ्‌हाॽ अक्‍खे मे़त्ते़म्‍सिम्‍मे़ॽ, ");
INSERT INTO lifNT2_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘आनिगे़ लाङ्‌ङो खिप्‍तुआङ्‌के़बप्‍पा खिनिॽ पाङ्‌जुम्‍मोबा खाम्हिःक्‍हाॽ खिनिॽ तक्‍ले़ङ्‌वाओ आनिगे़ थाप्‍सुम्‍बे़रो॥ हे़क्‍केसाङ् निङ्‌वाॽफुहाङ्‌जुम्‍मिन् खिनिॽ निःत्ताङ् त्‍ये़आङ् वाॽ के़लॽबा कुसिङ् निःत्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","खासे़न् ये़न्‍नो खे़न् पाङ्‌जुम्‍मिल्‍ले़ कुदुक्‍खेःङ्‌ग सादोमरे़ कुदुक्‍खेःन्‍नुःल्‍ले़आङ् के़साक्‍पा पोःङ् फाॽआङ् मे़त्‍निङ्‌लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“खोराजिन नु बे़थसेदा पाङ्‌जुम्‍मोबा मनासे, चिःत्ते़आङ्‌लक् स्‍ये़रो! खिनिॽ पाङ्‌जुम्‍मो पोःक्‍खे़बा निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ ताक्‍के़भे़ॽबाहाॽरे़ खुनिॽ ये़क्‌यक् तायर नु सिदोन्‍नो पोःक्‍खे़आङ् वये़ल्‍ले़ग उन्‍छोःन्‍छा खे़प्‍मोबा मनाहाॽ लायोलाम् हिन्‍दिगे़ फाॽआङ् सगि तेःत् मे़जाक्‍सिङ्‌ङाङ् खाप्‍पु मे़जुःत्‍छिङ्‌बामे़न्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","कर खासे़न् ये़न्‍नोग खिनिॽ तुक्‍खेनुःल्‍ले़ तायर नु सिदोनबा मनाहाॽरे़ खुनिॽ तुक्‍खेःन् थम्‍मा सुक्‍के़दे़प्‍पा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","हे़क्‍क्‍याङ् खिनिॽ कपर्नहुम पाङ्‌जुम्‍मोबा मनासे, साङ्‌ग्राम्‍पेदाङ् थारिक् पेगिगे़ॽ के़लॽरिबि? मे़ःन्‍लो! खिनिॽग खे़मायङ्‌सङ्‌थारिक् के़ध्‍ये़ॽइरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","आत्तिल्‍ले़ खिनिॽ पाःन् खे़प्‍सुॽ, खे़ल्‍ले़ आबाःन्‍निन्‍नाङ् खे़प्‍सुॽ॥ आत्तिल्‍ले़ के़नाॽरिॽ, खे़ल्‍ले़ इङ्‌गाॽआङ् नाॽआरो॥ हे़क्‍क्‍याङ् आत्तिल्‍ले़ इङ्‌गाॽ नाॽआ, खे़ल्‍ले़ याप्‍मि के़बाङ्‌बे़न्‍नाङ् नाॽरुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","नु-ने़त् (७२) हुॽसाम्‍बाहाॽ मे़सःत्ते़र मे़द्‌ये़आङ् ये़सुःन् मे़मे़त्तु, “आदाङ्‌बे, खे़ने़ॽ के़मिङ्‌ङोग फे़न्‍साम्‍हाॽ आनिगे़ युक्‍को मे़द्‌ये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “माफे़न्‍साम्‍मिन् साःम्‍भे ले़क्‍ते़बा कुइसिःक् साङ्‌ग्राम्‍पेदाङ्‌लाम् मक्‍थ्‍ये़र पत्‍छे़बा इङ्‌गाॽ निःसुङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","निङ्‌मिःल्‍ले़ कुमुक्‍साम् सम्‍दाङ् इङ्‌गाॽ युक् पिनिङ्‌ङाङ् वाॽ, हे़क्‍क्‍याङ् असेःक्‍पाहाॽ सम्‍दाङ् खिनिॽ लाङ्‌के़घेगिॽ, ताङ्‌साङ्‌खे़बक्‍हाॽ के़दोॽरुम्‍सिम्, कर थेआङ् के़मे़म्‍मे़त्तिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","हे़क्‍केसाङ् फे़न्‍साम्‍हाॽ खिनिॽ युक्‍को मे़वाॽ फाॽआङ् मे़ःन्, कर साङ्‌ग्राम्‍पेदाङ्‌ङो खिनिॽ मिङ् साप्‍ते़आङ् पप्‍पाल्‍ले़ चोगुल्‍ले़ सःत्ते़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","खे़न् ये़म्‍मो ये़सुःन् सेसेमाङ्‌ङिल्‍ले़ कुधिम् पोःक्‍खे़आङ् सःत्ते़र पारे़, “आम्‍बे, साङ्‌ग्राम्‍पेदाङ् नु इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुन्‍दाङ्‌बाए, इङ्‌गाॽ नोगे़न् पिने़, थेआङ्‌भे़ल्‍ले़ खे़ने़ॽग सिक्‍कुम्‍साबाहाॽ हे़क्‍क्‍याङ् चाःप्‍पाहाॽनु के़माॽरुबा पाःन्‍निन् हिन्‍जाॽ हे़क्‍तङ्‌बाहाॽ ओसेःन्‍गे़धाक्‍तुसिरो॥ आम्‍बे, बा अक्‍खे चोःक्‍माए खे़ने़ॽ के़सिराॽ थाङे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“आम्‍बारे़ काक् पाःन्‍हाॽ पिराङ्‌ङाङ् वाॽरो॥ कुस्‍साःन् हाःप्‍पे फाॽआङ् कुम्‍बारे़रक् कुसिङ् निःत्तुॽ, वेॽहाॽरे़ कुसिङ् मे़न्‍निःत्तुन्‍लो॥ हे़क्‍क्‍याङ् पानुदिङ् पाःन् हाःप्‍पे फाॽआङ् कुसिङ् मे़निःत्तुर फाॽआङ् कुस्‍साःल्‍ले़ ओसेःन्‍धाक्‍तुसिबा मनाहाॽरे़रक् कुसिङ् मे़निःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","हे़क्‍क्‍याङ् खुने़ॽ कुहुॽसाम्‍बाहाॽ ले़प्‍माङ् हिसिङ्‌ङाङ् स्‍वाःत्ताङ् मे़त्तुसि, “खिनिॽग मुॽइसाबानिङ्‌लो, थेआङ्‌भे़ल्‍ले़ खिनिॽ मिक्‍किल्‍ले़ कन्‌पाःन्‍हाॽ निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, यरिक् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ नु हाङ्‌हाॽरे़ खिनिॽ के़निःसुम्‍बा के़घे़प्‍सुम्‍बा पाःन्‍हाॽ निःमा नु खे़म्‍मा साॽरिक् निङ्‌वाॽ मे़जोगुआङ् वये़, कर मे़ङ्‌घोःसुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","थिक् ये़न् साम्‌योथिम्‍साम्‍बाधिक् ये़म्‍सिङ्‌ङाङ् ये़सुःन् पाःन्‍नो थाःमा फाॽआङ् सेःन्‍दोसु, “सिक्‍साम्‍बे, इङ्‌गाॽ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःमा थे चोःक्‍मा पोःङ्‌बे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","हे़क्‍क्‍याङ् ये़सुरे़आङ् खे़न् सेःन्‍दोसु, “मोसारे़ साप्‍तुबा साम्‌योथिम् साप्‍लाओ थे साप्‍ते़आङ् पत्? खे़न् आक्‍खेलॽरिक् कुसिङ् के़निःत्तुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","खे़ल्‍ले़ नोगप् पिरु, “‘खे़ने़ॽ के़न्‍दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन् के़रे़क् के़सिक्‍लुङ्‌माल्‍ले़, के़रे़क् के़सक्‍मासाम्‍मिल्‍ले़, के़रे़क् के़धुम्‍मिल्‍ले़ हे़क्‍क्‍याङ् के़रे़क् के़निङ्‌वाॽइल्‍ले़, मिःम्‍जि मे़त्ते़ॽ,’ हे़क्‍क्‍याङ् ‘आप्‍फेःक्‌लुङ्‌माॽ के़दुक्‍सिङ्‌बा कुइसिःक्‍के के़हिम्‍बेसाङ्‌बाहाॽआङ्‌लुङ्‌माॽ तुक्‍ते़से़ॽओ॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़न् मे़त्तु, “खे़ने़ॽ के़दङ्‌बा नोगप् के़बिरुरो॥ हे़क्‍क्‍याङ् बा हे़क्‍के चोगे़ॽआङ् मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍निन् के़घोःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","कर खे़ल्‍ले़ साम्‌योनिबा थाःम्‍सिङ्‌मा निङ्‌वाॽ इःत्तुआङ् नुःबा ले़ङ्‌सिङ्‌ल सेःन्‍दोसु, “इङ्‌गाॽ आहिम्‍बेसाङ्‌बाहाॽ हाःत्‍छिबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ये़सुरे़ खे़न् नोगप् पिरुआङ् मे़त्तु, “थिक्‌ये़न् लत्‍छा मनाःन् यरुसले़मलाम् यो ये़रिहोओ पेर पत्‍छे़ल्‍ले़ फाःन्‍दाहाॽरे़ मे़याङ्‌घुआङ् कुदेःत्‍हाॽ मे़भे़न्‍दु मे़बिरुआङ् सिःमालिङ्‌धो के़रे़र हाम्‍ब्रे़क् मे़हिप्‍तुआङ् लाम्‍मो लाप्‍मे़भुसु मे़ध॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","हाबा खे़न् लाम्‍मोलाम् निङ्‌वाॽफुसाम्‍बाधिक् ये़ःर पत्‍छे़॥ खे़ल्‍ले़ खे़न् मनाःन् निःसुसाङ् मे़न्‍निःमना ले़ङ्‌सिङ्‌ङाङ् लाम् कबुधआङ्‌पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","हे़क्‍क्‍याङ् हाबा खे़न् लाम्‍मो माङ्‌हिम्‍मो के़भाॽबा ले़बिधिक्‍काङ् ये़ःर पत्‍छे़ खे़ल्‍ले़आङ् खे़न् मनाःन् निःसुसाङ् मे़न्‍निःमना ले़ङ्‌सिङ्‌ङाङ् लाम् कबुधआङ्‌पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","कर सामरियास्‍मा मनाधिक् हाबा खे़न् लाम्‍मोलाम् पेरबत्‍छे़ल्‍ले़ खे़न् मनाःन् निःसुआङ् लुङ्‌माॽ तुक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","खे़न् सामरिःन् पेआङ् काःन्‍दे़बा कुयाङ्‌घेःक्‍को सिदाॽइन् हुःत्तु पिरुआङ् तेःत् चिरिक्‍हाॽरे़ इभुत्तु पिरु, हे़क्‍क्‍याङ् कुअदङ् सम्‍दाङ् युक्‍खुआङ् चे़याङ्‌धोःक्‍को तेॽरुआङ् नुःरिक्‍काङ् कम्‍ब्राङ् मे़त्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","कुदाःन्‍दिक्‍मा खे़न् सामारिःल्‍ले़ चे़याङ्‌धोःक् दाङ्‌बान् ने़त्‍छि युप्‍पायाङ् पिरुआङ् मे़त्तु, ‘कन् मनाःन् नुःरिक्‍काङ् कम्‍ब्राङ् मे़त्ते़ॽओ, इङ्‌गाॽ नुःङ्‌ङा ताआल्‍ले़ कन्‍नाङ्धो के़लाःप्‍पा याङ्‌ङिन् हुङुङ् पिने़रो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् सेःन्‍लाप्‍तु, “कन् सुम्‍सि मनाहाॽओ आत्तिन् मनाःन् फाःन्‍दाहाॽरे़ मे़याङ्‌घुबाल्‍ले़न् के़नुॽबा कुहिम्‍बेसाङ्‌बा पोःक्‍खे़ फाॽआङ् के़इःत्तुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","खे़न् साम्‌योथिम्‍साम्‍बाल्‍ले़ नोगप् पिरु, “खुने़ॽ कम्‍ब्राङ् के़मे़प्‍पे़न्‍लो॥” हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मे़त्तु, “पेगे़ॽआङ् खे़ने़ॽआङ् बा हे़क्‍केए चोगे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","आल्‍ल ये़सुःन् नु कुहुॽसाम्‍बाहाॽ मे़बेर मे़बत्‍छे़ल्‍ले़ थिक् पाङ्‌भेॽओ मे़गे़रे़आङ् खे़प्‍मो मार्था मे़प्‍मनामाल्‍ले़ कुहिम्‍मो लाङ्‌दाःक्‍मा पिरुसिआङ् खे़ङ्‌हाॽ कुहिम्‍मो मे़बे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","हे़क्‍क्‍याङ् मार्थारे़ कुन्‍साॽ मरियम मे़प्‍मनामान्‌वये़॥ खुने़ॽ दाङ्‌बाल्‍ले़ कुलाङ्‌जक्‍पो युङ्‌सिङ्‌ङाङ् ये़सुरे़ पाःत्तुबा सिक्‍कुम्‍दिङ् खाहुन्‍हाॽ खे़प्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","कर मार्थारे़ तरे तोमा यरिक् याःम्‍बक् चोःक्‍मा के़बोःङ्‌बा पोःक्‍खे़बाल्‍ले़ कुसक्‍मा हुॽरु हे़क्‍क्‍याङ् पेआङ् दाङ्‌बान् मे़त्तु, “आदाङ्‌बे, याप्‍मि कम्‍ब्राङ् के़म्‍मे़त्तान्‍बि? इङ्‌गाॽ आन्‍साॽरे़ग कॽयो याःम्‍बक् चोःक्‍मा मे़भाॽआन्‍बे़॥ इङ्‌गाॽ याःम्‍बक्‍को हाराॽ फाॽआनि फाॽआङ् मे़त्ताङ् पिराङ्‌ङे़ॽना॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","कर ये़सुरे़ मे़त्तु, “मार्थाए, खे़ने़ॽग यरिक् पाःन्‍हाॽओ निङ्‌वाॽ के़बिरुआङ् आबाङे तुक्‍खे के़जाःत्‍छिङ्‌ङाङ् के़वाॽरो, ");
INSERT INTO lifNT2_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","कर के़ये़क्‍पा लक् थिक्‍लक् वाॽरो, हे़क्‍क्‍याङ् मरियमरे़ग खे़न् नुःबा लक्‍किन्‌सेगुआङ् वाॽरो॥ खुने़ॽनु खे़न् लक्‍किन् नाप्‍मा सुक्‍मे़दे़त्‍ने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","थिक् ये़न् ये़सुःन् थिक् ते़न्‍नो तुवा चोगे़र युङे़॥ खुने़ॽ तुवा चोगु सुरुल्‍ले़ कुहुॽसाम्‍बाधिक् खे़ॽयो त्‍ये़आङ् मे़त्तु, “युहुन्‍नारे़ कुहुॽसाम्‍बाहाॽ तुवा चोःक्‍मा हुॽरुसिबा हे़क्‍केए आदाङ्‌बारे़ आनिगे़आङ् तुवा चोःक्‍मा आहुॽरे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ तुवा के़जोगुम्‍मिल्‍ले़ अक्‍खे पाःत्ते़म्‍मे़ॽ, आनिगे़ पाःए, मनाहाॽरे़ के़मिङ्‌ङिन् सेसे मे़इःत्तुर मिङ्‌सो इङ्‌धाःङ् के़म्‍बिररो॥ के़हाङ्‌जुम्‍मिन् ताररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","हे़क्‍क्‍याङ् थिक्‌याःन्‍धक्‍पा कुजाःन् आबिरे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","आनिगे़ लायोलाम् ले़प्‍मि आबिरे़ॽओ॥ हे़क्‍केलॽरिक्‍के आनिगे़आङ् आनिगे़ तक्‍ले़ङ्‌वाओ लायो के़जोःक्‍पाहाॽ के़रे़क् ले़प्‍मि पिरुम्‍सिम्‍बे़ॽरो॥ हे़क्‍क्‍याङ् निङ्‌वाॽसाॽमाओ आन्‍धाःसे़न्‍ने़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो मे़त्तुसि, “आल्‍ल खे़ने़ॽ थिक् से़न्‍दिक् से़त्‍लुम्‍भक्‍किल्‍ले़ तेःङ्‌बाल्‍लो के़बेःक्‍काङ् अक्‍खे के़मे़त्तु, ‘तेःङ्‌बे इङ्‌गाॽ सुम्‍सि खरे़ःङ्‌धिक् थे़ॽला पिराङ्‌ङे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","थेआङ्‌भे़ल्‍ले़ माःङ्‌घानु आन्‍जुम्‍धिक् त्‍ये़आङ् वाॽ॥ खुने़ॽ पिमारे़ लागि चामा थुङ्‌मा इङ्‌गाॽ थेआङ् मे़गत्तान्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","हे़क्‍केःल्‍ले़ हिम् सिगाङ्‌लाम् खे़ल्‍ले़ नोगप् के़बिॽ, ‘इङ्‌गाॽ तुक्‍खे मे़जाःत्ताङ्‌ङिन्‍ने़ॽओ! आन्‍दे़ःन्‍छा लाम्‍धेःप्‍पे़न्‌ए़त्ते़आङ्‌पत्, हे़क्‍क्‍याङ् याम्‍मो हिन्‍जाॽबित्‍छाहाॽआङ् इङ्‌गाॽनुए ने़त्‍नाओ मे़ने़॥ इङ्‌गाॽ पोःक्‍माआङ् खे़ने़ॽ थे़माआङ् पिमा मे़सुक्‍ने़न्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","कर खे़प्‍से़म्‍मे़ॽ, खे़न् आबाङे कुन्‍देःङ्‌बासाङ् खुने़ॽ पोःक्‍काङ् थेआङ् मे़बिरुन्‍लो, कर खुने़ॽ कुना मे़धाने़न्‍ल फाॽआङ् पोःक्‍काङ् चाहाबा चोःक्‍पा यारिक्‍के खे़न् पिरुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","हे़क्‍केःल्‍ले़ इङ्‌गाॽ मे़त्‍निङ्‌लो–नाःक्‍ते़म्‍मे़ॽ, हे़क्‍क्‍याङ् खिनिॽ के़म्‍बिरिॽरो, कोःत्ते़म्‍मे़ॽ, हे़क्‍क्‍याङ् खिनिॽ के़घोःसुम्‍लो, लाम्‍धेःप्‍पे़न्‌खक्‌खक्‌मे़त्ते़म्‍मे़ॽ, हे़क्‍क्‍याङ् खिनिॽ लागि लाम्‍धेःप्‍पे़न्‌हन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","थेआङ्‌भे़ल्‍ले़ हाःत्‍ले़ नाःक्‍तुॽ, खे़ल्‍ले़ खोःसुॽ, हे़क्‍क्‍याङ् हाःत्‍ले़ कोःत्तुॽ, खे़ल्‍ले़ याङ्‌घुॽ, हे़क्‍क्‍याङ् हाःत्‍ले़ लाम्‍धेःप्‍पे़न्‌खक्‌खक्‌मे़त्तुॽ, खे़ल्‍ले़ कुलागि लाम्‍धेःप्‍पे़न्‌हन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","खिनिॽओ आत्तिन् पाःल्‍ले़ कुस्‍साःन् ङा नाःक्‍किल्‍ले़ असेःक्‍पे़न्‌पिरुबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","हे़क्‍क्‍याङ् वाधिःन् नाःक्‍किल्‍ले़ ताङ्‌साक्‍खे़बक्‍पे़न्‌पिरुबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","खिनिॽ फे़न् निङ्‌वाॽ के़गत्तुम्‍साङ् आबाङे साःहाॽ नुःबा चिगःक्‌वाहाॽ पिमासि के़ले़स्‍सुम्‍मिल्‍ले़, खिनिॽ साङ्‌ग्राम्‍पेदाङ्‌ङोबा पाःल्‍ले़आङ् सेसेमाङ्‌ङिन् खिनिॽ के़नाःक्‍तुम्‍मिल्‍ले़ से़क्‍खासाङ् के़बिरिॽएरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","थिक्‌ये़न् ये़सुरे़ थिक् कुबाःन् मे़न्‍लःम्‍मनाबा के़बा मनालाम् फे़न्‍साम्‍मिन् नाःत्तु लःत्तुर पत्‍छे़॥ खे़न् फे़न्‍साम्‍मिन् नाःत्तुदेःसुआङ् खे़न् मनाःन् पाःप्‍मा हेःक्‍ते़॥ हे़क्‍क्‍याङ् मनाहाॽरे़ खुनिॽ निङ्‌वाॽ मये़, ");
INSERT INTO lifNT2_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","कर कुभारे़ मे़मे़त्तु, “कल्‍ले़ग फे़न्‍साम्‍हाॽरे़ खुनिॽ हाङ् बालजिबुलरे़ कुमुक्‍साम्‍मिल्‍ले़ फे़न्‍साम्‍हाॽ नाःत्तु लःत्तुसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","हे़क्‍क्‍याङ् वेॽहाॽरे़ खुने़ॽ “साङ्‌ग्राम्‍पेदाङ्‌लाम् के़ये़बा फाॽआङ् निङ्‌वाॽ के़माबा मिक्‍सेःन्‍धिक्‌याप्‍मि ओसेःन्‍आधाक्‍ते़ॽओ” मे़मे़त्तुर ये़सुरे़ कुनिङ्‌वाॽ मे़साॽरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","कर ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽइन्‌निःसुआङ् अक्‍खे मे़त्तुसि, “आप्‍फेःक् लुम्‍मो के़घेबा के़धक्‍पाआङ् के़से़म्‍बा के़रे़क् हाङ्‌जुम्‍हाॽ मे़मे़क्‍लो॥ हे़क्‍क्‍याङ् आप्‍फेःक् लुम्‍मो के़घेबा के़धक्‍पाआङ् के़से़म्‍बा हिम्सयङ्‌हाॽआङ्‌मे़मे़क्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","हे़क्‍क्‍याङ् माफे़न्‍साम्‍मिन् आबाङे कुहाङ्‌जुम्‍मिल्‍ले़ कुदक्‍ले़ङ्‌वाओ पोःक्‍ने़ फाॽग्र आक्‍खेआङ् कुहाङ्‌जुम्‍मिल्‍ले़ थरुबे? कर इङ्‌गाॽ बालजिबुलरे़ कुमुक्‍साम्‍मिल्‍ले़ फे़न्‍साम्‍हाॽ नाःत्तुङ् लःत्तुङ्‌सिङ् फाॽआङ् खिनिॽ के़बाःत्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","इङ्‌गाॽ बालजिबुललाम् फे़न्‍साम्‍हाॽ लःत्तुङ्‌सिङ्‌ने़ फाॽग्र खिनिॽ साःहाॽरे़ थे़माःल्‍ले़ कुमुक्‍साम्‍लाम् मे़लःत्तुसिबे? खे़ङ्‌हाॽरे़ मे़जोगुबा याःम्‍बक्‍किल्‍ले़ए खिनिॽ पिर्बेःम्‍बो के़ध्‍ये़ॽइआङ् के़वयिॽ फाॽआङ् ओसेःन्‍आधाक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","कर इङ्‌गाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍लाम् फे़न्‍साम्‍हाॽ नाःत्तुङ् लःत्तुङ्‌सिङ्‌लो, खे़ल्‍ले़ चोगुल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् खिनिॽ लुम्‍मो त्‍ये़ चुरे़आङ् वाॽ फाॽआङ् कुसिङ् निःत्ते़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“लत्‍छा के़धुम्‍बा मनाःल्‍ले़ फे़जा-फे़युम्‍हाॽ काप्‍सिङ्‌ङाङ् कुहिम्‍मिन् कोसुल्‍ले़ कुजिगःक्‌वाहाॽ से़ःप्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","कर खुने़ॽनुःल्‍ले़ के़धुम्‍बा मनाःन् ताःआङ् खुने़ॽ नाःन्‍दुॽ, हे़क्‍क्‍याङ् से़ःप्‍मा सुक्‍का लॽरिक् इःत्तुबा फे़जा-फे़युम्‍हाॽ नु कुजिगःक्‌वाहाॽ नाप्‍तुदेॽरुआङ्‌कुमनाहाॽनु हास्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","हाःत् इङ्‌गाॽ ले़प्‍माङ् होःप्‌, खे़न् आदक्‍ले़ङ्‌वाओ वाॽ॥ हाःत्‍ले़ इङ्‌गाॽनु मे़सुप्‍सुन्, खे़ल्‍ले़ से़ःसुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“फे़न्‍साम्‍मिन् मनाओलाम् लःन् पेःक्‍किल्‍ले़ नाःम्‍सिङ्‌ते़न् कोःत्‍छे़ से़ङ्‌से़ङ्‌बा ते़न् हे़ङ्‌घाःत्ति पेःक्‍लो, कर खे़ल्‍ले़ आत्तान्‍नाङ् मे़घोःसुन्‍नाङ्‌अक्‍खे मे़त्‍छिङ्‌, ‘इङ्‌गाॽ ले़रुङ्‌बा मनाःल्‍लोए नुःङ्‌ङा पेःक्‍कारो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","हे़क्‍क्‍याङ् खे़न् खे़प्‍मो नुःङ् ताःल्‍ले़ तगि यागे़बा ते़न्‍निन् मे़दुगुआङ् नुःबा मे़जोगुबा निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","हे़क्‍क्‍याङ् खे़न् पेःक्‍काङ् आप्‍फेःक्‍नुःल्‍ले़आङ् साॽरिक् कुॽइ के़भे़ॽबा वेॽ नुसि फे़न्‍साम्‍हाॽ तारुसिआङ् खे़ङ्‌हाॽ सिगाङ् मे़लाःत्ताङ् मे़युङ्‌सिङ्‌लो॥ खे़न् मनाःल्‍ले़ कुयाक्‍नाम्‍मिन् तगिबानुःल्‍ले़आङ्‌ताप्‍फे़ःम्‍बा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","खुने़ॽ पारे़र पत्‍छे़ल्‍ले़ खे़प्‍मो मनालुम्‍मोलाम् थिक् मे़न्‍छुमाॽइन् यम्‍बा इक्‍लाओ पारे़, “खुने़ॽ सागे़वाःम्‍मान् हे़क्‍क्‍याङ्‌नुगे़धुक्‍माङ्‌ग मुॽइसामारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","कर ये़सुरे़ पाःत्तु, “हे़क्‍केग मे़ःन्, कर निङ्‌वाॽफु पाःन्‍जाक्‍किन् के़घे़म्‍बा नु के़इःप्‍पा के़नाःप्‍पाहाॽए मुॽइसाबासिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","मनाहाॽ खे़प्‍मो यरिक् मे़बोःरे़र मे़बेःल्‍ले़ ये़सुरे़ याम्‍मो मे़त्तुसि, “कन्‌ये़म्‍मोबा मनाहाॽ कुॽइगे़भे़ॽबासिरो॥ कङ्‌हाॽरे़ निङ्‌वाॽ के़माबा मिक्‍सेःन् मे़गोःत्तुॽ, कर माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा योनारे़ कुमिक्‍सेःन्‍नाङ्‌धो वेॽ मिक्‍सेःन् मे़ङ्‌घोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","आक्‍खेलॽरिक् योनाःन् निनबे ये़क्‌यक्‍पा मनाहाॽरे़ लागि मिक्‍सेःन् पोःक्‍खे़आङ् वये़, खे़न् हे़क्‍केए मे़न्‍छाम्‍साःन्‍नाङ् कन् थाःक्‍किल्‍ले़ लागि मिक्‍सेःन् पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","लाङ्‌गे़त् पिसाङ्‌बा सिवा लाजेॽस्‍मा हाङ्‌मान् खासे़न् ये़न्‍नो ये़म्‍सिङ्‌ङाङ् कन् ये़म्‍मोबा मनाहाॽरे़ खुनिॽ तक्‍ले़ङ्‌वाओ पोःक्‍काङ् पाःन्‍धिक्‍तुसिॽरो, थेआङ्‌भे़ल्‍ले़ खुने़ॽ सोलोमन हाङ्‌ङिल्‍ले़न् सिक्‍कुम्‍दिङ् खाहुन् खे़म्‍से़ साॽरिक् माःङ्‌घाबा लाजेॽलाम् त्‍ये़आङ् वये़रो॥ कप्‍मो सोलोमन हाङ्‌ङिन्‍नुःल्‍ले़ पयम् यम्‍बान् वाॽसाङ् के़ङ्‌घे़प्‍सुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","निनबेओ के़वाॽबा मनाहाॽरे़आङ् कन्‌थाःक्‍हाॽ खासे़न् ये़न्‍नो पाःन्‍मे़धिक्‍तुसिॽरो, थेआङ्‌भे़ल्‍ले़ योनारे़ इङ्‌भन् से़ःसुल्‍ले़ खे़ङ्‌हाॽ खुनिॽ लायोलाम् मे़हिन्‍दे़आङ् मे़वये़, कर कप्‍मो योनाःन्‍नुःल्‍ले़आङ् पयम् यम्‍बान् वाॽसाङ् खिनिॽ के़न्‍हिन्‍दिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“आत्तिल्‍ले़आङ् सेमिःन् हाःन्‍दुआङ् नइमाल्‍ले़ मे़सुःप्‍तुन् हे़क्‍क्‍याङ् मे़जिक्‍खुन्‍नाङ्, कर हिम् सिगाङ् के़लाःप्‍पाहाॽरे़ मे़निःसुर फाॽआङ् चम्‍जम्‍बा ते़न्‍नो युक्‍खुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","खे़ने़ॽ के़मिक्‍किन् नासिङ्‌गे़न् के़धक्‍कोबा सेमिरो॥ खे़ने़ॽ के़मिक्‍कन्‌नुॽने़ फाॽग्र, काक् नासिङ्‌गे़न् के़धक्‍किन् ओःत्‍लो॥ कर के़मिक्‍कन्‌फे़न्‍ने़ फाॽग्र, काक् नासिङ्‌गे़न् के़धक्‍किन् खादाम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽओबा ओःत्तिःन् खादाम्‍माल्‍ले़ मे़सुःप्‍तुन्‍ल फाॽआङ् सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","खे़ने़ॽ के़निङ्‌वाॽसाम्‍मिन् ओःत्तिल्‍ले़ कुधिम् वाॽआङ् खादाम्‍मान् होःप्‍ने़ फाॽग्र, सेमिःल्‍ले़ थोॽरुबा हे़क्‍केए खे़ने़ॽ के़निङ्‌वाॽसाम्‍मिन्‍नाङ् ओःत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ये़सुरे़ पाःप्‍मा सुरुल्‍ले़ खे़प्‍मो फरिसिधिक् त्‍ये़आङ् खुने़ॽ चाजासे़ उःत्तुरो॥ हे़क्‍केःल्‍ले़ ये़सुःन् कुहिम्‍मो पेआङ् चाजासे़ युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","चामानुःल्‍ले़ तगि ये़सुरे़ कुहुक्‍किन् चोःक्‍थिम् कुइसिःक् वामे़हप्‍तुम्‍बा निःसुल्‍ले़, खे़न् फरिसिःल्‍ले़ कुनिङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","दाङ्‌बाल्‍ले़ खे़न् मे़त्तु, “खिनिॽ फरिसिहाॽरे़ खोर्याःन् नु चे़त्‍थ्‍याःन्‌लाःक्‍कात्‍लक् वागे़हप्‍तुम्, कर खिनिॽ सिगाङ्‌ग मनाहाॽ के़नाप्‍तुम् के़दाःरुम्‍सिबा पाःन्‍हाॽ नु ताप्‍फे़ःम्‍बा पाःन्‍निल्‍ले़ के़दिम्‍सिआङ्‌के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","अदङ्‌से, लाःक्‍कात् के़जोःक्‍पाल्‍ले़ सिगाङ्‌बान्‍नाङ्‌चोगुबा मे़ःम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","कर के़घिःप्‍सिर के़गत्तुम्‍बा पाःन्‍हाॽ याङ्‌गे़साॽबाहाॽ पिरे़म्‍देःसे़म्‍सिम्‍मे़ॽ, हे़क्‍केःल्‍ले़ खिनिॽ सुत्‍थोए के़बोःक्‍खिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","कर के़जिःत्ति के़स्‍ये़ॽइरो फरिसिसे, थेआङ्‌भे़ल्‍ले़ खिनिॽग चुजुक्‍सा मारुक्‍किल्‍ले़न् थिबोःङ्‌लक् निङ्‌वाॽफुमाङ्‌ङिन् के़बिरुम्, कर निङ्‌वाॽफुमाङ्‌ङिन् मिःम्‍जि के़म्‍मे़त्तुम्‍मिन्, हे़क्‍क्‍याङ् वेॽहाॽआङ् नुःरिक्‍काङ् खासे़न् के़न्‍लोःन्‍दुम्‍सिम्‍मिन्‍लो॥ खिनिॽ तगिस्‍मान् के़जोगुम्‍मिल्‍ले़ एगाङ्‌स्‍मान्‍नाङ् के़जोगुम्‍मिल्‍ले़ पोःक्‍खे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","फरिसिसे, के़जिःत्ति के़स्‍ये़ॽइरो! खिनिॽग यहुदि चुम्‍लुङ्‌हिम्‍मो तुम्‍म्‍याङ्‌हाङ् युक्‍नाहाॽओ युङ्‌मा खिनिॽ सिराॽ थाङ्‌लो, हे़क्‍क्‍याङ् पाङ्‌जुम्‍हाःत्ति मनाहाॽरे़ सेवा मे़मे़त्तिगे़र के़लॽरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","के़जिःत्ति के़स्‍ये़ॽइरो! खिनिॽग सुत्‍लुङ्‌मे़ःन्‍नेबा इःप्‍पुङ् हे़क्‍के के़लरिॽरो॥ मनाहाॽरे़ निङ्‌वाॽए मे़ङ्‌घोए खे़न् इःप्‍पुङ् सम्‍दाङ् लाङ्‌मे़घेःक्‍काङ्‌आसुत्‍थो मे़बोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","खे़प्‍मो थिक् साम्‌योथिम्‍साम्‍बाल्‍ले़ खुने़ॽ मे़त्तु, “सिक्‍साम्‍बे, खे़ने़ॽ अक्‍खेलॽरिक् के़बाःत्तिल्‍ले़ग आनिगे़आङ् चाःत्‍थिरक् के़देःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","कर ये़सुरे़ नोगप् पिरु, खिनिॽ साम्‌योथिम्‍साम्‍बाहाॽआङ् के़जिःत्तिरो, थेआङ्‌भे़ल्‍ले़ खिनिॽग के़लिःप्‍पा कक्‌हे़क्‍तङ्‌बा के़साक्‍पा थिम्‍हाॽ के़जोगुम्‍माङ् मनाहाॽ के़गुःत्तुम्‍सिम्, कर खिनिॽग कक् याङ्‌याङ् लॽर फाॽआङ् आबाङे हुक्‍चोधिक्‍किल्‍ले़आङ् खे़न् के़न्छुसुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","के़जिःत्ति के़स्‍ये़ॽइरो, थेआङ्‌भे़ल्‍ले़ खिनिॽ पाधे़बाहाॽरे़ मे़से़रुसिबा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़न् इप्‍पुङ्‌ङिन् के़जोगुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","खिनिॽग खिनिॽ पाधे़बाहाॽरे़ खुनिॽ याःम्‍बक्‍किन्‍नु ते़न्‍दिङ् के़जोगुम्‍लो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ मे़से़रुसि, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुनिॽ इप्‍पुङ्‌ङिन् खिनिॽ के़जोगुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","खे़ल्‍ले़ चोगुल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़न् सिक्‍कुम्‍दिङ् कुनिङ्‌वाॽइल्‍ले़ अक्‍खे पाःत्तुआङ् पत्, ‘खिनिॽओ इङ्‌गाॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ नु सेःक्‌युक्‍मिबाहाॽ पाङ्‌घुङ्‌सिङ्, कर खिनिॽ कुभा के़से़रुम्‍सिम्, कुभा निङ्‌घुम् के़मे़त्तुम्‍सिम्॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","हे़क्‍केःल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़न् नावागे़न् चइःत् ने़स्‍से़आङ्धो के़रे़क् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ के़से़प्‍पाहाॽरे़ खोःमा के़बोःङ्‌बा खुम्‍दिङ्‌ङिन् कन् थाःक्‍हाॽरे़ मे़घोःसुॽरो– ");
INSERT INTO lifNT2_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","मे़से़रुबा हाबिलरे़ कुमाक्‍खिॽआङ्‌धो ले़त्तिङ्‌तोःम्‍मादे़न् नु माङ्‌हिम्‍मिल्‍ले़ कुलुम्‍मो मे़से़रुबा जकरियारे़ कुमाक्‍खिॽ थारिक्‍पा खुम्‍दिङ्‌ङिन् कन् थाःक्‍हाॽरे़ मे़घोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","खिनिॽ साम्‌योथिम्‍साम्‍बासे, खिनिॽ के़जिःत्ति के़स्‍ये़ॽइरो, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिन् कुसिङ् निःप्‍मा ने़हिनिङ्‌वाॽ हम्‍मा तिमिक्‍किन् के़देॽरुम्‍साङ्‌खिनिॽ आबाङेग के़न्‍लासिन्‍लो॥ हे़क्‍क्‍याङ् निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःप्‍मा के़गोःप्‍पा वेॽ मनाहाॽआङ् लाःप्‍मा के़म्‍बाङ्‌घुम्‍सिम्‍मिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","हे़क्‍क्‍याङ् खुने़ॽ खे़ॽयोलाम् पेआङ् साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिहाॽरे़ खुने़ॽ कुदक्‍ले़ङ्‌वाओ पाःप्‍मा मे़हेःक्‍तुरो॥ खे़न् ये़म्‍माङ्धो खुने़ॽ ताप्‍फे़ःल्‍लिक् मे़मे़त्तुर यरिक् सेःन्‍दोहाॽ सेःन्‍मे़दोसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","हे़क्‍क्‍याङ् खुने़ॽ कुबाःन्‍नो ते़म्‍मा फाॽआङ् खे़ङ्‌हाॽरे़ इङ् तङ्‌मा मे़हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","खे़प्‍मो निःत्‍मे़न्‍दे़त्ते हे़न्‍छिङ्‌ङाङ्धो मनाहाॽ चिए़त्‌चिए़त्‌मे़ए़त्‍छिङ्‌ल मे़जुप्‍से़॥ हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ अक्‍खेलॽरिक् मे़त्तुसि, “फरिसिहाॽरे़ खुनिॽ खरे़ःङ् के़भङ्‌बा सिदाॽलाम् सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ! खे़न् सिदाॽ फाॽइन् खुनिॽ निङ्‌वाॽ चिःप्‍मान्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","मे़धाःप्‍ने़न्‍ल फाॽआङ् ते़प्‍ते़आङ्‌के़वाॽबा पाःन् इग्र कुसिङ् निःत्‍मे़दे़त्‍ने़न्‍ल फाॽआङ् माॽरे़आङ् के़वाॽबा पाःन् थेआङ् होःप्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","खे़ने़ॽ खागे़माक्‍पाओ के़बाःत्तुबा पाःन्‍निन् खागे़ओःप्‍पाओ इङ्‌भन् चोःक्‍लो॥ हे़क्‍क्‍याङ् स्‍वाःत्ताङ् हिम् सिगाङ् के़बाःत्तुबा पाःन्‍हाॽ हिम् सम्‍दाङ्‌लाम् यम्‍बा इक्‍लाओ इङ्‌भन् चोःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“आन्‍जुम्‍से, हाःत्‍ले़ खिनिॽ नासिङ्‌गे़न् थक्‍किन्‍लक् से़प्‍माआङ्धो थेआङ् चोःक्‍मा मे़सुक्‍तुन्, खे़न्‍नु मे़गिसे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","कर हाःत्‍नु किःमा पोःङ् के़लॽबा पाःन्‍निन् इङ्‌गाॽ मे़त्‍निङ्‌लो–हाःत्‍ले़ नासिङ्‌गे़न् थक्‍किन् से़रुआङ् खे़मायङ्‌सङ्‌ङो लाप्‍फुमा सुक्‍तुॽ, खुने़ॽनुए किःसे़म्‍मे़ॽओ! ");
INSERT INTO lifNT2_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ङासि चुजुक्‍सा पुहाॽरे़ याङ्‌ने़त्‍छि मे़ले़क्‍ने़न्‍बि? हे़क्‍केसाङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़ङ्‌हाॽ आत्तिन्‍नाङ् निङ्‌वाॽ मे़भेःत्‍छुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","खिनिॽ थे़गेःक्‍कोबा काक् थे़गेःक्‍इहाॽ खुने़ॽ निःरुआङ् वाॽरो॥ हे़क्‍केःल्‍ले़ मे़गिसे़म्‍मिन्‍ने़ॽओ! खिनिॽग यरिक् चुजुक्‍सा पुहाॽनुःल्‍ले़आङ् इमे़ल्‍लुङ्‌बा के़जोगिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“आल्‍ल खे़प्‍से़म्‍मे़ॽओ, हाःत्‍ले़ मना तगि ये़सुःन् नसाःन् चोगुङ् लॽरिक् पाःत्तुॽ, इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़आङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमाङ्‌लाइङ्‌बाहाॽरे़ खुनिॽ तगि खे़न् ताःक्‍तुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","कर हाःत्‍ले़ मनाहाॽरे़ खुनिॽ तगि इङ्‌गाॽ नाॽआ, इङ्‌गाॽआङ् खे़न् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमाङ्‌लाइङ्‌बाहाॽरे़ खुनिॽ तगि नाॽरुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","हे़क्‍क्‍याङ् हाःत्‍ले़ मे़न्‍छाम्‍साःल्‍ले़ कुदक्‍ले़ङ्‌वाओ फे़न् पाःन्‍हाॽ पाःत्तुॽ, खे़ल्‍ले़ ले़प्‍मि खोःमा सुक्‍तुॽ, कर सेसेमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पाःन्‌पाःत्तुबा पाःन्‍निल्‍ले़न् ले़प्‍मि मे़घोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","मनाहाॽरे़ खिनिॽ यहुदि चुम्‍लुङ्‌हिम्‍मो हे़क्‍क्‍याङ् सुहाङ्‌युक्‍पाहाॽ नु हाङ्‌हाॽरे़ खुनिॽ तगि खासे़न् लोःम्‍मारे़ लागि के़म्‍देॽरिल्‍ले़, से़ःप्‍सिङ्‌मारे़ लागि थे़मा पाःप्‍माबे फाॽआङ् निङ्‌साम्‍मो मे़ध्‍ये़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","हाबा खे़न् ये़म्‍मो थे पाःप्‍मा पोःङ् फाॽआङ् सेसेमाङ्‌ङिल्‍ले़ खिनिॽ के़हुॽरिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","हे़क्‍क्‍याङ् खे़न् मनालुम्‍मोलाम् थिक् मनाःल्‍ले़ ये़सुःन् मे़त्तु, “सिक्‍साम्‍बे, आम्‍भुॽरे़ याङ्‌साकुन्‍धेओबा इङ्‌गाॽ आलक्‍किन् पिआर फाॽआङ् मे़त्ताङ् पिराङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ये़सुरे़ खे़न् नोगप् पिरु, “लुङ्‌ङाए, हाःत्‍ले़ इङ्‌गाॽ खिन्‍छिॽ लुम्‍मो याङ्‌साकुन्‍धे के़हाबा के़बिबा चोगाङ् इग्र खासे़न्‍लोःम्‍बा चोगाङ्‌बे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","हे़क्‍क्‍याङ् ये़सुरे़ याम्‍मो खे़ङ्‌हाॽ मे़त्तुसि, “काक् खिःम्‌यक् चोःक्‍मोलाम् सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ॥ थेआङ्‌भे़ल्‍ले़ मनाःल्‍ले़ कत्तुबा मुल्‍लुक् याङ्‌साकुन्‍धेओ खुने़ॽ से़क्‍खाबा कुहिङ्‌मन्‍निन् मे़वाॽने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ खे़दाॽओ मे़त्तुसि, “थिक् याङ्‌साकुन्‍धेसाबा मनाःल्‍ले़ यरिक् पोगुगे़न् कुजाहाॽ सुप्‍सुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","हे़क्‍क्‍याङ् खे़ल्‍ले़ अक्‍खेलॽरिक् निङ्‌वाॽ इःत्तु, ‘आल्‍ल इङ्‌गाॽ थे चोगुङ्‌बे? कन् चाहाॽ युङ्‌मादे़न्‍ने होःप्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","हे़क्‍क्‍याङ् अक्‍खेलॽरिक् इःत्तु, ‘आल्‍ल इङ्‌गाॽ अक्‍खे चोगुङ्–उन्‍छोःन्‍बा चा युङ्‌दे़न्‍हाॽ यःसुङ्‌ङाङ् कुसङ् यम्‍बा चा युङ्‌दे़न्‍हाॽ चोगुङ्‌सिङ्॥ हे़क्‍क्‍याङ् काक् चाहाॽ नु आजिगःक्‌वाहाॽ खे़प्‍मो युक्‍खुङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","हे़क्‍क्‍याङ् इङ्‌गाॽ आबाङे अक्‍खे मे़त्‍छिङ्‌ङा, तेःङ्‌बे, यरिक् तङ्‌बे थारिक् के़योबा चा नु चिगःक्‌वाहाॽ सुप्‍सुङ्‌सिङ्‌ङाङ् वाॽआरो॥ आल्‍ल कुसानुःरिक् युङे़ॽ, चे़ॽ, थुङे़ॽआङ् सःत्ते़ॽओ!’ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़न् मे़त्तु, ‘कुनिङ्‌वाॽ के़बाःक्‍पे, आइन् से़न्‍दिक्‍सा खे़ने़ॽ के़हिङ्‌मन्‍निन् नुप्‍पाङ् खे़ने़ॽ के़सिःरो॥ हे़क्‍केःल्‍ले़ खे़ने़ॽ के़लुप्‍सुबा याङ्‌साकुन्‍धेहाॽ हाःत्‍ले़न् पोःङ्‌बाबे?’” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","हे़क्‍क्‍याङ् ये़सुरे़ मे़त्तु, “आबाङे लागिरक् याङ्‌साकुन्‍धेहाॽ के़लुम्‍बाआङ् निङ्‌वाॽफुमाङ् ले़प्‍माङ् याङ्‌साकुन्‍धेसाबा मे़म्‍बोःङ्‌मनाबे़न्‍नाङ् बा हे़क्‍केए पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “हे़क्‍केःल्‍ले़ खे़प्‍से़म्‍मे़ॽओ, खिनिॽ हिङ्‌मन्‍नो थे चामा नु नासिङ्‌गे़न् थक्‍को थे चाङ्‌मा वाःप्‍मा फाॽआङ् निङ्‌साम् मे़जोगे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","थेआङ्‌भे़ल्‍ले़ ने़त्तिगे़न् हिङ्‌मन्‍निन् चामा थुङ्‌मानुःल्‍ले़ यम्‍बारो॥ हे़क्‍क्‍याङ् नासिङ्‌गे़न् थक्‍किन् चाङ्‌मा वाःप्‍मानुःल्‍ले़आङ् यम्‍बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","आःक्‌वाहाॽ ओमे़त्ते़म्‍सिम्‍मे़ॽओ–खे़ङ्‌हाॽरे़ चा मे़न्‍देःसुन् मे़न्‍छुप्‍सुन्, चायुङ्‌दे़न्‍नोआङ् याङ्‌मे़ङ्‌घोःत्तुन्॥ हे़क्‍केसाङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ चाःत्तुसिॽ हिङ्‌घुसिॽरो॥ खिनिॽग पुहाॽनुःल्‍ले़आङ् आक्‍खे़न् इमे़ल्‍लुङ्‌साबा के़जोगिॽ के़लॽबा निङ्‌वाॽ इःत्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","निङ्‌साम्‍मो के़ध्‍ये़ॽइआङ्‌खिनिॽ हिङ्‌मन्‍नो कुमुक्‍थिक्‍काङ् फोःमा के़न्‍छुक्‍तुम्‍मिन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","अक्‍तङ्‌बा चुक्‍सा याःम्‍बक्‍काङ् चोःक्‍मा के़न्‍छुक्‍तुम्‍मिन्‍निल्‍ले़ थेआङ् खिनिॽ निङ्‌वाॽबाल्‍ले़ के़ये़ःक्‍खिबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","आल्‍ल लि-लि फुङ्‌ङिन् पोःबान्‌ओमे़त्ते़म्‍मे़ॽओ, खे़ङ्‌हाॽरे़ खिः मे़न्‍देःसुन् खिःआङ् मे़न्‍लःन्‍ने़न्, हे़क्‍केसाङ् खे़ङ्‌हाॽ सोलोमन हाङ्‌ङिल्‍ले़ कुनुॽमा कुदाःमाओ कन् लि-लि फुङ्‌ङिन्‌यारिक्‍काङ्‌नुःबा तेःत् मे़जाक्‍सिङ्‌ङिन्‍लो! ");
INSERT INTO lifNT2_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","आइन् ताःन्‍दिक् मिओ लाप्‍के़भुसिङ्‌बा प्‍याङ्‌सिगे़न् इक्‍ताप्‍पोबा सुङ्‌फुङ्‌हाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ हे़क्‍केलॽरिक् तेःत् चाक्‍तुसिल्‍ले़ खिनिॽ तेःत् के़न्‍जाक्‍तिन्‍बि? नसाःन् के़सुःम्‍बासे! ");
INSERT INTO lifNT2_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","चामा थुङ्‌माओरक् खिनिॽ निङ्‌वाॽ मे़बिरे़म्‍मिन्‍ने़ॽओ! खे़ल्‍ले़ लागिग निङ्‌साम्‍मोआङ् मे़ध्‍ये़म्‍मिन्‍ने़ॽओ, ");
INSERT INTO lifNT2_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","थेआङ्‌भे़ल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मोबा काक् सुवाङ्‌हाॽरे़आङ् बा हे़क्‍के मे़इःत्तुॽरो, कर साङ्‌ग्राम्‍पेदाङ्‌बा खिनिॽ पाःल्‍ले़ कन्‌के़रे़क् पाःन्‍हाॽ खिनिॽ चाहाबा के़जोगिबान्‌निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","कर खुने़ॽ कुहाङ्‌जुम्‍मिन्‍लक् कोःत्ते़म्‍मे़ॽ, हे़क्‍क्‍याङ् काक् कन् चिगःक्‌वाहाॽ खिनिॽ के़म्‍बिरिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“चुक्‍सा मे़ल्‍लुक् सुम्‍से, मे़गिसे़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌बा खिनिॽ पाःल्‍ले़ कुहाङ्‌जुम्‍मिन् पिमा कुसिराॽ थाङे़आङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","खिनिॽ के़गत्तुम्‍बा चिगःक्‌वाहाॽ सङ्‌घे़म्‍मे़ॽआङ् याङ्‌गे़साॽबाहाॽ पिरे़म्‍देःसे़म्‍सिम्‍मे़ॽओ॥ हे़क्‍केलॽरिक् आप्‍फाल्‍ले़आङ् मे़न्‍दे़ःङ्‌मना, मे़न्‍हङ्‌मनाबा सुःक्‌वाओ आप्‍फाल्‍ले़आङ् मे़म्‍मे़क्‍मनाबा साङ्‌ग्राम्‍पेदाङ्‌ङोबा याङ्‌साकुन्‍धेहाॽरे़ थिम्‍से़म्‍सिम्‍मे़ॽओ॥ खे़प्‍मो के़घुःम्‍बाहाॽरे़आङ् मे़न्‍घुःत्तुन्, हे़क्‍क्‍याङ् कुबुःल्‍ले़आङ् मे़जने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","थेआङ्‌भे़ल्‍ले़ आत्तो खे़ने़ॽ याङ्‌साकुन्‍धेहाॽ के़युक्‍खुॽ, खे़प्‍मोए खे़ने़ॽ के़निङ्‌वाॽबे़न् पेःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“खिनिॽ फॽइःन् नुःरिक्‍काङ् युप्‍से़म्‍मे़ॽ, हे़क्‍क्‍याङ् खिनिॽ सेमिःन् हाःन्‍दे़म्‍मे़ॽआङ्‌युक्‍खे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","हे़क्‍क्‍याङ् निङ्‌वाॽ इरे़ चसिबा सेवारोबाहाॽ हे़क्‍के खिनिॽ पोःक्‍खे़म्‍मे़ॽओ॥ खुनिॽ दाङ्‌बान् मेःक्‍खिम् साभाङ्‌जा चासे़ पेःक्‍काङ् नुःङ् ताःल्‍ले़ खिमो लाम्‍धेःप्‍पे़न्‌हम्‍मा फाॽआङ् खे़ङ्‌हाॽ मे़न्‍इम्‍मे बा मे़युङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","हे़क्‍क्‍याङ् दाङ्‌बान् नुःङ् ताःइल्‍ले़, मे़न्‍इम्‍मे खुने़ॽ के़हाङ्‌बार के़युङ्‌बा सेवारोबाहाॽरे़ मुॽइसाम् मे़घोःसुॽ, थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ आबाङे यारिप् चोःक्‍सिङ्‌ङाङ् सेवारोबाहाॽ चामादे़न्‍नो युक्‍खुसिॽ हे़क्‍क्‍याङ् चामा थुङ्‌माहाॽ थाबु पिरुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","हे़क्‍क्‍याङ् खे़न् हिम्‍दाङ्‌बे़न् से़त्‍लुम्‍भक् खिरि तासाङ् खे़ङ्‌हाॽ मे़न्‍इम्‍मे मे़युङ्‌बा तुमुसिॽरो॥ हे़क्‍केःल्‍ले़ से़क्‍खाए मे़त्‍निङ्, खे़न् कुसेवारोबाहाॽग मुॽइसाबासिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","हिम्‍दाङ्‌बाल्‍ले़ खुःन्‍द्रिक्‍पे़न् खुःन्‍छे़ ताः के़लॽबा ये़म्‍मिन् निङ्‌वाॽ खोःसुने़ फाॽग्र से़क्‍खासाङ् खुःप्‍मा मे़बाङ्‌घुन् के़लॽबा पाःन्‍निन् कुसिङ् निःत्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","खिनिॽआङ् आप्‍फाल्‍ले़साङ् यारिप् वये़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ मे़न्‍छाम्‍साःन् युः फाॽआङ् मे़न्‍इःत्ते के़वयिल्‍ले़ खुने़ॽ युःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","पत्रुसरे़ सेःन्‍दोसु, “आदाङ्‌बे, कन् खे़दाॽइन् आनिगे़ लागि के़बाःत्तुबाबि, इ वेॽ के़रे़क्‍ले़ लागिआङ् के़बाःत्तुबाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","दाङ्‌बाल्‍ले़ मे़त्तुसि, आत्तिन् सेवारोबान् नसाःन्‍साबा नु सिक्‍कुम्‍साबा चोःक्, खे़न्‍निन् हिम्‍दाङ्‌बाल्‍ले़ कुहिम्‍धाःङ्‌हाॽ ओमे़प्‍मा युक् पिरुॽ हे़क्‍क्‍याङ् खे़ल्‍ले़ वेॽ सेवारोबाहाॽ ये़म्‌ये़म्‍मो चामा थुङ्‌मा पिरुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","खे़न् हिम्‍दाङ्‌बान् नुःङ् ताःल्‍ले़ खे़न् सेवारोबाल्‍ले़ बा हे़क्‍केए चोगुर वाॽबा तुमुने़ फाॽग्र खे़न् थुम्‍घो पिरुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खे़न् हिम्‍दाङ्‌बाल्‍ले़ खे़न् सेवारोबान् के़रे़क् कुयाङ्‌साकुन्‍धे सम्‍दाङ् युक् पिरुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","कर आत्तिन् सेवारोबाल्‍ले़ खुने़ॽ कुनिङ्‌वाॽबो इङ्‌गाॽ आन्‍दाङ्‌बान् हारा मे़दाने़न् लॽरिक् इःत्तुर चः थुङुॽ, हे़क्‍क्‍याङ् मःसिङ्‌ङाङ् वेॽ सेवारोबा नु सेवारोमाहाॽ हिप्‍तुसिॽ लःप्‍सुसिॽर वाॽइल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","मे़न्‍इःत्तेबा नु निङ्‌वाॽ मे़ङ्‌घोएबा ये़न्‍नो हिम्‍दाङ्‌बे़न् हिम्‍मो नुःङ् ताआङ् खे़न् साॽरिक् ते़ःम्‍भुक् याक्‍तुॽ॥ हे़क्‍क्‍याङ् नसाःन् मे़न्‍जोःक्‍मनाबाहाॽनु सोरिक् खुम्‍दिङ् पिरुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“हे़क्‍क्‍याङ् आत्तिन् सेवारोबाल्‍ले़ खुने़ॽ कुन्‍दाङ्‌बाल्‍ले़ कुनिङ्‌वाॽइन्‌निःसुसाङ् खे़न् कुइसिःक् यारिप् मे़म्‍बोःङ्‌ङे कुन्‍दाङ्‌बाल्‍ले़ कुनिङ्‌वाॽ हे़क्‍के मे़जोगुन्‍निल्‍ले़ खे़ल्‍ले़ साॽरिक् ते़ःम्‍भुक् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","कर हाःत्‍ले़ कुन्‍दाङ्‌बाल्‍ले़ कुनिङ्‌वाॽइन्‌मे़निःसुन्‍नाङ् ते़ःम्‍भुक् चामा याःम्‍बक् चोगुॽ, खे़ल्‍ले़ मिसाक्‍लक् ते़ःम्‍भुक् चरो॥ हाःत्‍ले़ यरिक् खोःसुॽ, खे़ल्‍लोलाम् यरिक्‍के नाःक्‍लो, हे़क्‍क्‍याङ् हाःत्‍ले़ यरिक् लक्‍पे़न्‌खोःसुॽ खे़ल्‍लोलाम्‍माङ्‌यरिक्‍के नाःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“इङ्‌गाॽ इक्‍सादिङ् खाम्‍बेःक्‍मो मि केःत्‍छे़ त्‍याङ्‌बारो, कर तगिसा मि लाःसे़ल्‍ले़ नुःबा पोःक्‍खे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","इङ्‌गाॽआङ् इनोगे़न् तुक्‍खेःल्‍ले़न् बप्‍तिस्‍मा पोःङ्‌मा कत्तुङ्‌लो॥ खे़न् मे़न्‍जुःत्ते थारिक् आसक्‍मा हुॽसिङ्‌ङाङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","इङ्‌गाॽ इक्‍सादिङ् खाम्‍बेःक्‍मो सनारुङ् ताःत्‍छे़ त्‍याङ्बा फाॽआङ् के़इःत्तुबि? मे़ःन्‍लो! इङ्‌गाॽग मनाहाॽ से़म्‍मासि फाॽआङ् त्‍याङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","आल्‍लआङ्धो ङासि मना के़वाॽबा हिम्सयङ्‌ङो सुम्‍भुरे़ तक्‍ले़ङ्‌वाओ ने़प्‍फु, हे़क्‍क्‍याङ् खे़न् ने़प्‍फुरे़ खुन्‍छिॽ तक्‍ले़ङ्‌वाओ सुम्‍भु मे़बोःक्‍काङ् खे़ङ्‌हाॽ मे़से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","कुम्‍बाःन् कुस्‍साःल्‍ले़ कुदक्‍ले़ङ्‌वाओ पोःक्, हे़क्‍केलॽरिक्‍के कुस्‍साःन् कुम्‍बारे़ कुदक्‍ले़ङ्‌वाओ, हे़क्‍क्‍याङ् कुम्‍माःन् कुस्‍साः मे़न्‍छुमाॽइल्‍ले़ कुदक्‍ले़ङ्‌वाओ, हे़क्‍क्‍याङ् कुस्‍साः मे़न्‍छुमाॽइन् कुम्‍मारे़ कुदक्‍ले़ङ्‌वाओ पोःक्‍लो॥ हे़क्‍क्‍याङ् नोःप्‍मे़न् कुम्‍बाङ्‌लिःल्‍ले़ कुदक्‍ले़ङ्‌वाओ, हे़क्‍क्‍याङ् पाङ्‌लिमे़न्‌कुन्‍नोःप्‍माल्‍ले़ कुदक्‍ले़ङ्‌वाओ पोःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","हे़क्‍क्‍याङ् खुने़ॽ याम्‍मो यरिक् मनाहाॽ मे़त्तुसि, “नाम्‍धा पिसाङ् खाप्‍मिःप्‍पान् के़निःसुम्‍मिल्‍ले़ आल्‍लोसा वाहित् थाःॽ फाॽआङ् के़बाःत्तुम्, हे़क्‍क्‍याङ् हे़क्‍केलॽरिक् वाहित् थाःॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","लाङ्‌गे़न्‍बा सुरित् केजङ्‌ङिन् हुःल्‍ले़ आल्‍ल साॽरिक् हाङ्‌वा लॽरिक् के़बाःत्तुम्, हे़क्‍क्‍याङ् हे़क्‍केए पोःङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","खिनिॽ कुनिङ्‌वाॽ के़जिःप्‍पासे, अक्‍खेलॽरिक् इक्‍सादिङ् खाम्‍बेःक्‍मो नु तरःङ्‌दिङ्‌ताङ्‌साङ्‌ङोबा पाःन्‍निन् ओगे़मे़त्तुम्‍माङ् ताःन्‍दिक् के़बोःङ्‌बा पाःन्‍निन् के़बाःत्तुम्, कर कन् ये़म्‍मो के़दाःबा मिक्‍सेःन्‍हाॽ थेआङ् कुसिङ् के़न्‍निःत्तुम्‍मिन्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“खिनिॽ इङ्‌गाॽ चोगुङ्‌बा याःम्‍बक्‍किन् नुःबा बि मे़ःम्‍बि फाॽआङ् थेआङ् आबाङे के़न्‍छे़न्‍दुम्‍मिन्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","खे़ने़ॽ आप्‍तिक् के़गुःप्‍पे़न्‍नु खासे़न्‍हिम्‍मो के़बेःक्‍किल्‍ले़, लाम्‍मोसा फोत्‍या के़गुःप्‍पे़न्‍नु नादङ् चोगे़ॽओ॥ मे़ःन्‍ने़ फाॽग्र खे़ल्‍ले़ खे़ने़ॽ खासे़न्‍लोःम्‍बाल्‍लो के़देॽआङ् खे़न् खासे़न्‍लोःम्‍बाल्‍ले़ तिलिङ्‌गाहाॽरो हुक्‍के़सुप् हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ पुङ्‌लाहिम्‍मो के़म्‍धे़क्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","हे़क्‍क्‍याङ् हुङ्‌मा के़बोःङ्‌बा काक्‌साम्‍बाःन् याङ् मे़न्‍हुङ्‌ङे थारिक् खे़प्‍मोए के़याक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","खे़न् ये़न्‍नो खे़प्‍मो के़वाॽबा कुभा मनाहाॽरे़ ये़सुःन् मे़मे़त्तु, “अक्‍खेलॽरिक् गालिलिहाॽ सिदुङ्‌जभा चोःक्‍कि मे़यागे़ल्‍ले़ रोमि सुहाङ्‌गे़म्‍बा पिलातसरे़ खे़न् सिदुङ्‌जभा के़जोःक्‍पाहाॽ से़प्‍मा पाङ्‌घुसिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “हे़क्‍के पोःक्‍खे़ फाॽले़ खे़न्‌गालिलिहाॽ साॽरिक् लायोबा मे़जोगे़ फाॽआङ् के़इःत्तुम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","मे़ःन्‍लो! खिनिॽआङ् खिनिॽ लायोलाम् के़न्‍हिन्‍दिन्‍ने़ फाॽग्र बा हे़क्‍केए के़बोःक्‍खिॽआङ् के़मे़गिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","हे़क्‍क्‍याङ् सिलोआम जङ्‌हिम्‍मिल्‍ले़ के़ःप्‍तु से़रुसिबा थिक्-ये़त् (१८) मनाहाॽ यरुसले़म्‍मो काक्‍नुःल्‍ले़ साॽरिक् लायोबा मे़जोगे़ फाॽआङ् के़इःत्तुम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","मे़ःन्‍लो! खिनिॽआङ् खिनिॽ लायोलाम् के़न्‍हिन्‍दिन्‍ने़ फाॽग्र बा हे़क्‍केए के़बोःक्‍खिॽआङ् के़मे़गिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ खे़दाॽओ मे़त्तुसि, “थिक् मनाःल्‍ले़ पःत्‍छेॽबुङ्‌माधिक् लेःत्तु॥ खुने़ॽ पःत्‍छेॽबुङ्‌मो कुजाॽ कोःत्‍छे़ त्‍ये़, कर मे़घोःसुन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","खे़ल्‍ले़ इक्‍के़गोःबान् उःत्तुआङ् मे़त्तु, ‘इङ्‌गाॽ तङ्‌बे सुम्‍सिआङ्धो कन् पःत्‍छेॽबुङ्‌मो कुजाॽइन् ओमे़त्तुङ्‌ल वाॽआ, हे़क्‍केसाङ् इङ्‌गाॽ मे़ङ्‌घोःबान्‍लो॥ आल्‍ल कन् ताङे़ॽआङ् से़रे़ॽ॥ थेआङ् खाम्‍मिन् आम्‍भा चासोःक्‍खुबाबे॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","खे़न् इक्‍के़गोःबाल्‍ले़ मे़त्तु, ‘आदाङ्‌बे, आइलाम्‍बा पःत्‍छेॽबुङ्‌मान् ले़राङ् पिराङ्‌ङे़ॽआङ् इङ्‌गाॽ कुघिरि तःयुङ्‌ङाङ् मल याक्‍तुङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","हे़क्‍क्‍याङ् आन्‍ने़म्‍माॽ कुजाॽ थोःक्‍ते़ने़ फाॽग्र नुःबा पोःक्‍खे़, मे़धोःक्‍ते़न्‍ने़ फाॽग्र ताङे़देःसे़ॽओ॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","हे़क्‍क्‍याङ् थिक् नाःम्‍सिङ्‌ये़न्‍नो ये़सुरे़ यहुदि चुम्‍लुङ्‌हिम्‍मो निसाम् हुॽरुसिर यागे़ल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","खे़प्‍मो तङ्‌बे थिक्-ये़त्ताङ्धो (१८) उधुक्‍के फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुआङ् कुएःक् उःक्‍खुॽ के़लॽमा मे़न्‍छुमाॽधिक् वये़॥ खे़ल्‍ले़ कुएःक् सल्‍लिक् सम्‍मा मे़सुक्‍तुन्‍नाङ्‌वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ये़सुरे़ खे़न् मे़न्‍छुमाॽइन् निःसुआङ् उःत्तुआङ् मे़त्तु, “आल्‍लो उधुक्‍के फे़न्‍साम्‍मिल्‍ले़ खे़ने़ॽ के़ले़रे़ के़ध्‍ये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","हे़क्‍क्‍याङ् खे़न् उःक्‍खुॽबा कुएःक्‍को हुक्‍किन् ने़स्‍सु पिरु॥ खिमो खे़न् मे़न्‍छुमाॽइन् नुरे़आङ् कुएःक्‍किन् सल्‍लिक् सन्‍छुआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","कर नाःम्‍सिङ्‌ये़न्‍नो ये़सुरे़ खे़न् मे़न्‍छुमाॽइन् नुसुबाल्‍ले़ चोगुल्‍ले़ यहुदि चुम्‍लुङ्‌हिम्‍मोबा लाम्‍लोःबान् कुसाक्‍के़न् पोगे़आङ् खे़प्‍मो मनाहाॽ मे़त्तुसि, “ये़त्‍नाम्‍धिक्‍को तुक्‍सि (६) ये़न् थारिक् याःम्‍बक् चोःक्‍मा सुक्‍ते़त्॥ हे़क्‍केःल्‍ले़ नाःम्‍सिङ्‌ये़न्‍नो मे़ःन्, कर वेॽ ये़न्‍हाॽओ नुसिङ्‌से़ त्‍ये़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ कुनिङ्‌वाॽ के़जिःप्‍पासे, नाःम्‍सिङ्‌ये़न्‍नो खिनिॽ थाःङ्‌ङोलाम् पित्‍हाॽ इग्र अदङ्‌हाॽ के़ले़रुम्‍सिम्‍माङ् च्‍वाःत् थुङ्‌से़ के़देॽरुम्‍सिम्‍बि मे़ःम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","कन् अब्राहामरे़ कुहिम्सयङ्‌बा मे़न्‍छुमाॽइन् तङ्‌बे थिक्‌-ये़त्ताङ्धो (१८) माफे़न्‍साम्‍मिल्‍ले़ थुःन्‍दुआङ् वये़॥ कन् नाःम्‍सिङ्‌ये़न्‍नो खे़न् माफे़न्‍साम्‍मिल्‍ले़ कुइघेःङ्‌ङोलाम् ले़प्‍मा नुःबाबि मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ये़सुरे़ हे़क्‍के पाःत्तुल्‍ले़ कुदक्‍ले़ङ्‌वाओ के़बाःप्‍पाहाॽ के़रे़क् मे़नुःन्‍दे़रो॥ कर मनाहाॽ ये़सुरे़ चोगुबा निङ्‌वाॽ के़माबा पाःन्‍निल्‍ले़ चोगुल्‍ले़ मे़सःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “निङ्‌वाॽफुहाङ्‌जुम्‍मिन् आक्‍तङ्‌बा चोःक् फाॽआङ् थे़माःन्‍नु तङ्‌घुङ्‌बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","कङ्‌ग यःङ्‌गेॽ याॽरिःम्‍बा हे़क्‍के चोःक्‍लो॥ खे़न् इक्‍ताप्‍पो ले़प्‍माआङ् लिङ्‌हे़क्‍क्‍याङ्‌सिङ्‌बुङ् हे़क्‍के यम्‍बा पोःङ्‌लो॥ हे़क्‍क्‍याङ् कुबोराःक्‍को पुसाहाॽरे़ हाप् मे़जोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो सेःन्‍दोसुसि, “निङ्‌वाॽफुहाङ्‌जुम्‍मिन् इङ्‌गाॽ थे़माःन्‍नु तङ्‌घुङ्‌बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","कङ्‌ग फे़ॽरुम्‍मो याक्‍मनाबा सिदाॽ हे़क्‍दङ्‌बा चोःक्‍लो॥ थिक् मे़न्‍छुमाॽइल्‍ले़ यरिक् फे़ॽरुम्‍मो मिसाक् सिदाॽइन् याक्‍तु हे़क्‍क्‍याङ् सिदाॽइल्‍ले़ मे़न्‌युक्‍के थारिक् सॽरु युक्‍खुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","हे़क्‍क्‍याङ् ये़सुःन् यरुसले़म पेर पत्‍छे़ल्‍ले़ लाम्‍मो के़ने़बा पाङ्‌जुम्‍हाॽओ निसाम्‍हाॽ हुॽरुसिर पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","कुभारे़ खुने़ॽ सेःन्‍मे़दोसु, “दाङ्‌बे, सुःल्‍लिक् मनाहाॽरे़रक् से़न्‍लप् मे़घोःसुॽबि?” ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, ");
INSERT INTO lifNT2_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“चिभिःत्‍फिःप्‍पा लाम्‍धेःप्‍पोलाम् निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःप्‍मा तम्‍सिन् चोगे़म्‍मे़ॽओ॥ यरिक् मनाहाॽरे़ तम्‍सिन् मे़जोगुॽ, कर लाःप्‍मा मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","हे़क्‍क्‍याङ् हिम्‍दाङ्‌बाल्‍ले़ लाम्‍धेःप्‍पे़न्‌सुबुॽ॥ हे़क्‍केःल्‍ले़ खिनिॽ लाःक्‍कात्‍लाम् लाम्‍धेःप्‍पे़न्‌के़हिप्‍तुम्‍ल के़मे़त्तुम्, ‘आनिगे़ लागिआङ् लाम्‍धेःप्‍पे़न्‌हन्‍दे़ आबिरे़ना!’ कर खुने़ॽ अक्‍खेलॽरिक् नोगप् के़बिरिॽ, ‘खिनिॽ आत्तोलाम् के़द्‌ये़ॽइबे? इङ्‌गाॽ कुसिङ् मे़निःत्‍निङ्‌ङिन्‍लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","हे़क्‍केःल्‍ले़ खिनिॽ याम्‍मो के़बाःत्तुम्, “आनिगे़ग खे़ने़ॽनुए सोरिक् युङ्‌मनाआङ् चाःमना थुङ्‌मनारो, खे़ने़ॽग आनिगे़ लाम्‍मो निसाम् के़हुॽरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","कर खुने़ॽ नोगप् के़बिरिॽ, ‘से़क्‍खाए इङ्‌गाॽ कुसिङ् मे़निःत्‍निङ्‌ङिन्‍लो, आत्तोलाम् के़द्‌ये़ॽइबाबे? ताक्‍के़भे़ॽबासे, कप्‍मोलाम् पेगे़म्‍मे़ॽओ!’ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","हे़क्‍केःल्‍ले़ खिनिॽ अब्राहाम, इसहाक, याकुब, नु माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ निङ्‌वाॽफुहाङ्‌जुम्‍मो मे़युङ्‌बा के़निःसुम्‍सिम्, कर आबाङेग लाःक्‍कात् लाप्‍के़म्‍भुसिआङ् के़हाबिर के़भिःक्‍तिर ये़त्तुक्‍खेःल्‍ले़ हाबोॽबान् के़ये़ःक्‍खुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","काक् पिसाङ्‌लाम् नु काक् लाजेॽलाम् मनाहाॽ निङ्‌वाॽफुहाङ्‌जुम्‍मो मे़दाआङ् साभाङ्‌जा चासे़ मे़युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","खे़प्‍मो आल्‍लो यम्‍लाबा मनाहाॽ ताःन्‍दि चुक्‍सा मे़बोःङ्, हे़क्‍क्‍याङ् चुक्‍सा मनाहाॽ यम्‍लाबा मे़बोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","बा खे़न् ये़म्‍मो खे़ॽयो कुभा फरिसिहाॽ मे़द्‌ये़आङ् ये़सुःन् मे़मे़त्तु, “खे़ने़ॽ कप्‍मोलाम् हारा लःन्‍दे़ पेगे़ॽओ, थेआङ्‌भे़ल्‍ले़ हे़रोद हाङ्‌ङिल्‍ले़ खे़ने़ॽ से़प्‍मा निङ्‌वाॽ चोगुआङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “पेगे़म्‍मे़ॽआङ् खे़न् किदिःप्‍पान् अक्‍खे मे़त्ते़म्‍मे़ॽओ–‘आइन् नु ताःन्‍दिक् इङ्‌गाॽ फे़न्‍साम्‍हाॽ नाःत्तुङ् लःत्तुङ्‌सिङ्‌ङाङ् मनाहाॽ नुसुङ्‌सिङ् हे़क्‍क्‍याङ् सुम्‍सिगेःक्‍पा ये़न्‍नो इङ्‌गाॽ आयाःम्‍बक्‍किन् सुरुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","कर इङ्‌गाॽ आइन्, ताःन्‍दिक् नु आत्‍छे़न्‍दाःन् खे़त्‍थोए पेःक्‍कार पत्ता, थेआङ्‌भे़ल्‍ले़ यरुसले़म लाःक्‍कात् वेॽ दे़न्‍नो माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ से़प्‍मासि मे़नुॽने़न्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","यरुसले़म्‍मोबा मनासे, यरुसले़म्‍मोबा मनासे, खिनिॽग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ के़से़रुम्‍सिम्, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽओ पाङ्‌घुसिबा इङ्‌साबाहाॽ लुङ्‌ङिल्‍ले़ के़बःत्तुम्‍सिम्‍लो॥ आक्‍खे़न् ले़ङ् खिनिॽ मुॽइदाङ्‌साहाॽ वामाःप्‍माल्‍ले़ वाज्‍याःक्‍हाॽ कुप्‍तुसिबा कुइसिःक् खिनिॽ साःहाॽ सुम्‍मासि निङ्‌वाॽ चोगुङ्, कर खिनिॽ के़न्‍दे़न्‍दिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ओमे़त्ते़म्‍मे़ॽओ, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़हिम्‍मिन्‌लाम्‍धेःप् चिए़त्‌ए़त्तुॽरो॥ थेआङ्‌भे़ल्‍ले़ खिनिॽ से़क्‍खाए मे़त्‍निङ्, ‘दाङ्‌बाल्‍ले़ कुमिङ्‌ङो के़दाःबान् मुॽइसाबारो’ लॽरिक् के़म्‍बाःत्तुम्‍मिन्‍ल थारिक् याम्‍मो याप्‍मि के़न्‍निःसिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","थिक् नाःम्‍सिङ्‌ये़न्‍नो ये़सुःन् लत्‍छा फरिसि लाम्‍लोःबाल्‍ले़ कुहिम्‍मो चाजासे़ पे॥ खे़प्‍मो मनाहाॽरे़ खुने़ॽ मे़धोःप्‍सुआङ् मे़वये़, ");
INSERT INTO lifNT2_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","थेआङ्‌भे़ल्‍ले़ खुने़ॽ कुदगि कुलाङ् कुहुक् हःप्‍सुबा मनाधिक् त्‍ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","हे़क्‍क्‍याङ् ये़सुरे़ साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिहाॽ सेःन्‍दोसुसि, “नाःम्‍सिङ्‌ये़न्‍नो के़दुक्‍पा मनाहाॽ वेःम्‍मासि नुॽबि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","कर खे़ङ्‌हाॽरे़ थेआङ् नोगप् मे़म्‍बिरुन्॥ हे़क्‍केःल्‍ले़ ये़सुरे़ खे़न् मनाःन्‌सम्‍दाङ् कुहुक् ने़स्‍सुर नुसुआङ् पाङ्‌घुदेःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “नाःम्‍सिङ्‌ये़न्‍नो खिनिॽ साः इग्र पित्‍थिक्‌केःम्‍बा लुम्‍बाःत्तो मक्‍था लाःत्तिल्‍ले़ खिनिॽ खिमो लाःक्‍कात् के़उःक्‍खुम् के़लःत्तुम्‍बि मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","कर खे़ङ्‌हाॽरे़ थेआङ् नोगप् पिमा मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ये़सुरे़ खे़न् साभाङ्‌जाओ उःप्‍मनाबा मनाहाॽरे़ तुम्‍म्‍याङ्‌हाङ् युक्‍नाहाॽ मे़सेगुर मे़युङे़बा निःसुआङ् खे़ङ्‌हाॽ कन् खे़दाॽइन् मे़त्तुसि– ");
INSERT INTO lifNT2_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“खिनिॽ मेःक्‍खिम् साभाङ्‌जाओ तरे के़म्‍उःत्तिने़ फाॽग्र तुम्‍म्‍याङ्‌हाङ् युक्‍नाओ मे़युङे़म्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ खिनिॽनुःल्‍ले़आङ् मिङ्‌सोदाङ्‌बा मनाःन् तरे उःत्ते़आङ् वाॽने़ फाॽग्र ");
INSERT INTO lifNT2_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","खे़न् हिम्‍दाङ्‌बान् ताआङ् ‘खे़ने़ॽ कन् युक्‍नाःन् खुने़ॽ ले़रे़बिरे़ॽआङ् यो खाम्‍लोओ युङे़ॽओ’ के़मे़त्‍ने़ फाॽग्र के़नाधारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","खे़ल्‍ले़ कुले़क्‌वा तरे के़म्‍उःत्‍ने़ फाॽग्र खे़ने़ॽ यो खाम्‍लोओ युङ्‌सिङ्‌ङे़ॽओ॥ हे़क्‍केलॽरिक् हिम्‍दाङ्‌बे़न् ताआङ् ‘मे़ःन् आदाङ्‌बे, खे़ने़ॽ थो तुम्‍म्‍याङ्‌हाङ् युक्‍नाओ युङे़ॽओ’ के़मे़त्‍ने़ फाॽग्र खे़ॽयो खिरि के़वाॽबा तरेबाहाॽरे़ खुनिॽ तगि खे़ने़ॽ के़मिङ्‌सो पोःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","थेआङ्‌भे़ल्‍ले़ हाःत् यम्‍बा ले़ङ्‌सिङ् खे़न् चुङ्‌जिगे़न्‍साः पोःङ्‌लो, हे़क्‍क्‍याङ् हाःत् चुङ्‌जिगे़न्‍साः ले़ङ्‌सिङ् खे़न् यम्‍लाबा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","हे़क्‍क्‍याङ् ये़सुरे़ हिम्‍दाङ्‌बान् अक्‍खे मे़त्तु, “खे़ने़ॽ अक्‍खेलॽरिक् चामुक् थिमुक् के़से़ःसुल्‍ले़ के़न्‍जुम्‍हाॽ, के़म्‍भुॽ के़न्‍साॽहाॽ, के़गाॽइ सोधोःक्‍हाॽ नु याङ्‌साकुन्‍धे के़गप्‍पा पाङ्‌भेॽसाबाहाॽ मे़उःत्ते़से़न्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़आङ् खे़ने़ॽ के़म्‍उःत्ताङ् चामुक् थिमुक् के़म्‍बिर याङ्‌ना के़म्‍नुःक् के़म्‍बिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","कर खे़ने़ॽ चामुक् थिमुक् के़से़ःसुल्‍ले़ याङ्‌गे़साॽबाहाॽ, के़दुक्‍पाहाॽ, लाङ्‌सक्‍पाहाॽ नु मिक्‍फःम्‍बाहाॽ उःत्ते़से़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","हे़क्‍के के़जोगुल्‍ले़ खे़ने़ॽ मुॽइसाम् के़घोःसुॽ, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ थेआङ् मे़न्‍गत्तुन्‍नाङ् खे़न् याङ्‌ना हुङ्‌मा मे़न्‍छुक्‍तुन्‍लो॥ कर साम्‌योनिबा मनाहाॽ सिःमे़न्‍लाम् याम्‍मो मे़हिङ्‌ङिल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़ने़ॽ काक् नुःक्‍तु के़बिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","खुने़ॽनुए सोरिक् के़युङ्‌बा थिक्‍किल्‍ले़ कन् पाःन्‍निन् खे़प्‍सुआङ् पाःत्तु, “निङ्‌वाॽफुहाङ्‌जुम्‍बा चामुक् थिमुक्‍को चा के़जाबाहाॽग मुॽइसाबासिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ये़सुरे़ खे़न् मे़त्तु, “थिक् मनाःल्‍ले़ यम्‍बा साभाङ्‌जा से़ःमा निङ्‌वाॽ चोगुआङ् यरिक् तरेहाॽ उःत्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","हे़क्‍क्‍याङ् काक् यारिप् पोःक्‍खे़आङ् कुसेवारोबाधिक्‍किन् चामा थुङ्‌मा यारिप् पोःक्‍खे़, आल्‍ल त्‍ये़म्‍मे़ॽओ फाॽआङ् तरे उःत्‍छे़ पाङ्‌घुदेःसुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","कर खे़न् मनाहाॽ साभाङ्‌जाओ मे़म्‍बेःक्‍मना मेलाम्‍सिङ्लो॥ थिक्‍सिगेःक्‍पाल्‍ले़ मे़त्तु, “इङ्‌गाॽ प्‍याङ्‌सिगे़न् इक्‍ताप् इङुङ्‌ङाङ् वाॽआ, हे़क्‍क्‍याङ् खे़न् ओमे़त्‍छे़ पेःक्‍मा पोःङ्, हे़क्‍केःल्‍ले़ साभाङ्‌जाओ ताःमा मे़सुक्‍कान्‍लो॥ ले़प्‍मि पिराङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","वेॽ मनाःल्‍ले़ मे़त्तु, “इङ्‌गाॽ कुगाप् ङासि पित्‍पाहाॽ इङुङ्‌सिङ्‌ङाङ् वाॽआ॥ खे़ङ्‌हाॽ थोःङ्‌मा साॽमासि पोःङ्, हे़क्‍केःल्‍ले़ इङ्‌गाॽ साभाङ्‌जाओ ताःमा मे़सुक्‍कान्‍लो॥ ले़प्‍मि आबिरे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","हे़क्‍क्‍याङ् आल्‍लसाङ् वेॽ मनाःल्‍ले़ अक्‍खे मे़त्तु, “इङ्‌गाॽग खारक् मेःक्‍खिम् चोगुङ्‌ङाङ् वाॽआ, हे़क्‍केःल्‍ले़ साभाङ्‌जाओ ताःमा मे़सुक्‍कान्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","हे़क्‍क्‍याङ् सेवारोबाल्‍ले़ पेआङ् कुन्‍दाङ्‌बान् बा हे़क्‍के खे़न् पाःन्‍निन् मे़त्तु॥ हे़क्‍केःल्‍ले़ खे़न् मनाःल्‍ले़ साॽरिक् कुसिक् पोगे़आङ् खे़न् कुसेवारोबान् मे़त्तु, ‘हारा पेगे़ॽआङ् पाङ्‌जुम्‍मोबा लाम् लाम् के़वाॽबा याङ्‌गे़साॽबाहाॽ, के़दुक्‍पाहाॽ, लाङ्‌सक्‍पाहाॽ नु मिक्‍फःम्‍बाहाॽ उःत्ते़ तारे़से़ॽ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","हे़क्‍क्‍याङ् खे़न् सेवारोबान्‍नाङ् पेआङ् बा हे़क्‍के चोगुआङ् नुःक्‍खे़ त्‍ये़आङ् मे़त्तु, ‘आदाङ्‌बे, खे़ने़ॽ के़बाःत्तुबा हे़क्‍केए इङ्‌गाॽ चोगुङ्, आल्‍लसाङ् यरिक् युङ्‌मा ते़न्‍हाॽ ने़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","हे़क्‍केःल्‍ले़ कुन्‍दाङ्‌बाल्‍ले़ खे़न् मे़त्तु, ‘हे़क्‍केने़ फाॽग्र खे़ने़ॽ पाङ्‌भेॽओ पेगे़ॽआङ् लाम् लाम्‍मो के़वाॽबा मनाहाॽ हारा साभाङ्‌जाओ मे़दारए पोःङ् फाॽआङ् उःत्ते़ तारे़से़ॽओ॥ हे़क्‍केलॽरिक् कन् आहिम्‍मिन् सधे़क्‌तिम्‍लरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","उःप्‍मनाबा तरेबा आत्तिल्‍ले़आङ् इङ्‌गाॽ से़ःसुङ्‌बा साभाङ्‌जाओ चामा मे़घोःसुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","थिक्‍ले़ङ् यरिक् यरिक् मनाहाॽरे़ ये़सुरे़ कुएःक् कुएःक् मे़नाःत्तुर मे़वये़ल्‍ले़ खुने़ॽ खिरि हिसिङ्‌ङाङ् मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“इङ्‌गाॽ याप्‍मि के़दिम्‍बाल्‍ले़ कुम्‍मा-कुम्‍बासि, कुमेःत्-कुस्‍साःहाॽ, कुम्‍भुॽ कुन्‍साॽसि, कुन्‍ने़ॽ कुन्‍साॽसि, हे़क्‍क्‍याङ् कुहिङ्‌मन्‍निन् इङ्‌गाॽनुःल्‍ले़आङ् साॽरिक् मिःम्‍जि मे़त्तुने़ फाॽग्र खे़ङ्‌ग इङ्‌गाॽ आहुॽसाम्‍बा पोःङ्‌मा मे़सुक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","हे़क्‍क्‍याङ् खे़ने़ॽ के़सिलाम्‍साक्‍मा सिङ्‌ङिन् आबाङे के़बङ्‌सिङ्‌ङाङ् इङ्‌गाॽ के़न्‍दिम्‍मान्‍ने़ फाॽग्र आहुॽसाम्‍बा पोःङ्‌मा के़न्‍छुक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","आल्‍ल निङ्‌वाॽ इःत्ते़म्‍मे़ॽ, खिनिॽओ थिक्‍किल्‍ले़ यम्‍बा चङ्‌हिम् चोःक्‍मा निङ्‌वाॽ चोगुल्‍ले़, चोःक्‍मानुःल्‍ले़ तगि खे़न् सुःप्‍माल्‍ले़ आक्‍खे़न् याङ्‌साकुन्‍धे चाहाबा चोःक् लॽरिक् निङ्‌सेःक् चोगुबि मे़ःम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","30","मे़ःन्‍ने़ फाॽग्र हिम् पाङ्‌यक् ने़माग सुक्‍तु, कर खे़न् चोःक्‍मा सुःप्‍मा मे़सुक्‍तुन्‍लो॥ हे़क्‍क्‍याङ् कन् के़निःबा के़घे़म्‍बा मनाहाॽरे़ खे़न् अक्‍खे मे़मे़त्तुर किनाःन्‍दि मे़बिरुरो, ‘खे़ने़ॽ हेःक्‍माग के़हेःक्‍तु, कर सुःप्‍मा के़न्‍छुक्‍तुन्‍लो!’ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","आल्‍ल लत्‍छा थिबोःङ् हे़न्‍छिङ् (१०,०००) थक्‍सुबा के़गप्‍पा हाङ्‌ङिल्‍ले़ वेॽस्‍मा निबोःङ् हे़न्‍छिङ् (२०,०००) थक्‍सुबा के़गप्‍पा हाङ्‌ङिन्‍नु थङ् चोःक्‍से़ पेःक्‍मानुःल्‍ले़ तगि खे़ल्‍ले़ युङ्‌सिङ्‌ङाङ् खे़न् वेॽस्‍मा हाङ्‌ङिन् नाःम्‍मा सुक्‍तु बि मे़ःम्‍बि फाॽआङ् नुःरिक्‍काङ् निङ्‌वाॽ इःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","खे़ल्‍ले़ खे़न् हाङ्‌ङिन् नाःम्‍मा मे़सुक्‍तुन्‍बा निःन्‍धो चोगुने़ फाॽग्र खे़ल्‍ले़ खे़न् हाङ्‌ङिन् लाम्‍मो थङ् चोःक्‍से़ फे़न्‍ल पत्तिल्‍ले़सा हाङ्‌लाइङ्‌बान् पाङ्‌घुआङ् नादङ् चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","हे़क्‍केलॽरिक्‍के खे़ने़ॽ के़गत्तुबा काक् पाःन्‍हाॽ के़न्‍ले़रुन्‍ने़ फाॽग्र इङ्‌गाॽ आहुॽसाम्‍बा पोःङ्‌मा के़न्‍छुक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","युम्‍मिङ्‌ग नुःबाए चोःक्, कर युम्‍मिल्‍ले़ कुलिम्‍मे़न् माःबेःक्‍ने़ फाॽग्र याम्‍मो के़लिम्‍बा चोःक्‍मा सुक्‍मे़दे़त्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","हे़क्‍क्‍याङ् खे़ङ्‌ग इक्‍ताप्‍पो मःल्‍लाङ् मे़बोःङ्‌ने़न् मनाहाॽरे़ बा हे़क्‍केए लाप्‍मे़भुसु मे़देःसुरो॥ हे़क्‍क्‍याङ् आबाःन्‍निन् नुःरिक्‍काङ् खे़प्‍से़म्‍मे़ॽआङ् कुसिङ्‌निःत्ते़म्‍मे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","थिक्‌ये़न् यरिक् एःङ्‌याङ् के़भोःङ्‌बाहाॽ नु वेॽ लायोबाहाॽ ये़सुरे़ कुबाःन् खे़म्‍से़ खुने़ॽ कुघिरि मे़जुप्‍से़ल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","फरिसिहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ कानाक्‍नाक् मे़लॽरे़र अक्‍खे मे़बाःत्तु, “कन् मनाःल्‍ले़ग लायोबाहाॽआङ् ताःक्‍तुसिआङ् सोरिक् युङ्‌ङाङ् चाजारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ खे़दाॽधिक् मे़त्तुसि– ");
INSERT INTO lifNT2_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“खिनिॽओ किप्‍थिक् (१००) मे़ल्‍लुक्‍हाॽ के़गप्‍पा मनाःल्‍ले़ लत्‍छाःन् मासुल्‍ले़ फाङ्‌-फाङ् (९९) मे़ल्‍लुक्‍हाॽ चाराम्‍मादे़न्‍नो ले़रुधसिआङ् खे़न् के़माबे़न् मे़ङ्‌घोए थारिक् मे़गोःत्तुन्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","खुने़ॽ खे़न् के़माबा मे़ल्‍लुक्‍किन् खोःसुआङ् कुभक्‍ताङ्‌ङो पक्‍खुर सःत्‍ल नुःङ् ताःरो॥ हे़क्‍क्‍याङ् कुन्‍देःङ् कुन्‍जुम्‍हाॽ नु कुबाङ्‌भेॽसाबाहाॽ अक्‍खे मे़त्तुसिरो, ‘हौ! आल्‍ल आनिॽ सःत्तिरो, थेआङ्‌भे़ल्‍ले़ के़माबा आमे़ल्‍लुक्‍किन् याम्‍मो खोःसुङ्‌ङाङ् वाॽआरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","खे़प्‍से़म्‍मे़ॽओ, हे़क्‍केलॽरिक्‍के साङ्‌ग्राम्‍पेदाङ्‌ङो लायोलाम् हिम्‍मा मे़म्‍बोःङ्‌मनाबा फाङ्‌-फाङ् (९९) साम्‌योनिबाहाॽनुःल्‍ले़आङ् लायोलाम् के़हिम्‍बा लायोबाधिक्‍किल्‍ले़ लागि यम्‍बा सःप्‍मान् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ये़सुरे़ खे़ङ्‌हाॽ वेॽस्‍मा खे़दाॽधिक् मे़त्तुसि, “आल्‍ल थिबोःङ् युप्‍पा याङ्‌इत्‍छि के़गप्‍मा मे़न्‍छुमाॽधिक्‍ले़ याङ्‌धिक् मासुल्‍ले़ खे़ल्‍ले़ सेमि हाःन्‍दुआङ् खे़न् याङ्‌इत्‍छिःन्‌मे़ङ्‌घोए थारिक् हिम्‍मिन् तुगुर मे़गोःत्तुम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","हे़क्‍क्‍याङ् खे़ल्‍ले़ खोःसुआङ् कुन्‍देःङ् कुन्‍जुम्‍हाॽ, कुबाङ्‌भेॽसाबाहाॽ उःत्तुसिआङ् अक्‍खे मे़त्तुसि, ‘आल्‍ल आनिॽ सःत्तिरो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ मासुङ्‌बा आयाङ्‌इत्‍छिःन्‌इङ्‌गाॽ खोःसुङ्‌ङाङ् वाॽआरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","खे़प्‍से़म्‍मे़ॽओ, हे़क्‍केलॽरिक्‍के थिक् लायोलाम् के़हिम्‍बाल्‍ले़ लागि निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमाङ्‌लाइङ्‌बाहाॽआङ् मे़सःत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","हे़क्‍क्‍याङ् ये़सुरे़ याम्‍मो वेॽस्‍मा खे़दाॽआङ् मे़त्तुसि, “उन्‍छेःन् ने़प्‍फु ये़म्‍बित्‍छाॽसा के़गप्‍पा लत्‍छा मनाधिक् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","हे़क्‍क्‍याङ् थिक्‌ये़न् फोॽबाल्‍ले़ कुम्‍बाःन् अक्‍खे मे़त्तु, ‘आम्‍बे, इङ्‌गाॽ के़याङ्‌साकुन्‍धेःन्‌फःक्‍खे़आङ्‌आलक्‍को के़धाःबान्‌पिराङ्‌ङे़ॽओ॥’ हे़क्‍क्‍याङ् खे़न् मनाःल्‍ले़आङ् कुयाङ्‌साकुन्‍धेःन्‌खे़ङ्‌हाॽ हाःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","थिक्‌ये़न् निये़न् एगाङ् कुस्‍साः फोॽबाल्‍ले़ कुलक्‍को के़धाःबा याङ्‌साकुन्‍धेहाॽ के़रे़क् कक् मे़त्‍छिङ्‌ङाङ् माःङ्‌घा लाजेॽओ पेरो॥ खे़प्‍मो खे़ल्‍ले़ कुयाङ्‌साकुन्‍धेहाॽ हने़ ए़ःत्‍ले़ले़ लॽमा नु चामा थुङ्‌माओ चः माःन्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","हे़क्‍क्‍याङ् खुने़ॽ कुयाङ्‌साकुन्‍धेहाॽ माःन्‍दुआङ् वये़ल्‍ले़ खे़प्‍मो यम्‍बा साक् थ्‍ये़आङ् खे़ल्‍ले़ चामा थुङ्‌मा थेआङ् मे़घोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","हे़क्‍केःल्‍ले़ खुने़ॽ हाबा खे़न् लाजेॽओबा थिक् मनाःल्‍लो याःम्‍बक् चोःक्‍से़ पेआङ् खे़न् मनाःल्‍ले़ खुने़ॽ फाक्‍चा पिमा याःम्‍बक्‍को फत्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","हे़क्‍क्‍याङ् खे़न् आत्तिल्‍ले़आङ् चामा थुङ्‌मा मे़म्‍बिरुन्‍निल्‍ले़ खे़ल्‍ले़ फाक्‍चाःन् चामा निङ्‌वाॽ चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","हे़क्‍क्‍याङ् खुने़ॽ कुनिङ्‌वाॽ सेःरे़आङ् अक्‍खेलॽरिक् इःत्‍छिङ्‌, ‘आम्‍बारे़ कुहिम्‍मोग कुसेवारोबाहाॽरे़ खाघा मे़ज मे़धुङुर मे़नन्‍छुॽ, कर इङ्‌गाॽग कप्‍मो साक्‍किल्‍ले़ सिःमा इःत्ताङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","इङ्‌गाॽ आल्‍लो आम्‍बारे़ कुहिम्‍मोए नुःङ्‌ङा पेःक्‍काआङ् मे़त्तुङ्, आम्‍बे, साङ्‌ग्राम्‍पेदाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन् नु के़दक्‍ले़ङ्‌वाओ इङ्‌गाॽ लायो चोगुङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","आल्‍ल इङ्‌गाॽ के़स्‍साःआ पाःप्‍माआङ् मे़लाॽआन्‍लो॥ खे़ने़ॽ के़सेवारोबा कुइसिःक् के़हिम्‍मो कत्ताङ्‌ङे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","हे़क्‍क्‍याङ् खे़न् मुत्‍थ्रिक् पोगे़आङ् कुम्‍बारो नुःक्‍खे़ पे॥ खे़न् फे़रे़र पत्‍छे़बा माःङ्‌घालाम्‍नुए कुम्‍बारे़ निःसुआङ् मिःम्‍जिरे़ कुलुङ्‌माॽ कुधिम् पोःक्‍खे़, हे़क्‍क्‍याङ् लोःक्‍ते़र पेआङ् खे़न् हे़प्‍प्रे़क् हे़प्‍तुआङ् चुप् मे़त्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","कुस्‍साः फोॽबे़ल्‍ले़ कुम्‍बा मे़त्तु, ‘आम्‍बे, साङ्‌ग्राम्‍पेदाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिन् नु के़दक्‍ले़ङ्‌वाओ इङ्‌गाॽ लायो चोगुङ्‌ङाङ् वाॽआरो॥ आल्‍ल इङ्‌गाॽ के़स्‍साःआ पाःप्‍माआङ् मे़लाॽआन्‍लो॥ खे़ने़ॽ के़सेवारोबा कुइसिःक् के़हिम्‍मो कत्ताङ्‌ङे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","कर कुम्‍बारे़ खे़प्‍मो के़वाॽबा कुसेवारोबाहाॽ मे़त्तुसि, ‘हारा पेगे़म्‍मे़ॽआङ् कन् आस्‍साः फोॽबान् काक्‍नुःल्‍ले़ नुःबा तेःत्तिन् फे़त्ते़म्‍मे़ॽआङ् चाक्‍ते़म्‍मे़ॽ, कुहुक्‍चोओ स्‍वागे़प् वाःत्ते़म्‍मे़ॽ, हे़क्‍क्‍याङ् कुलाङ्‌ङो लाङ्‌सुःप् चाक्‍ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","हे़क्‍क्‍याङ् थाःङ्‌ङो चालुप्‍मनाबा थक्‍साधिक् फे़त्ते़म्‍मे़ॽआङ् से़रे़म्‍मे़ॽ, हे़क्‍क्‍याङ् चामुक् थिमुक् यारिप् चोगुम्‍माङ् सःत्तिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","थेआङ्‌भे़ल्‍ले़ कन् आस्‍साःन् स्‍ये़आङ् वये़, कर याम्‍मो हिङे़॥ खुने़ॽ मये़आङ् वये़, कर याम्‍मो इङ्‌गाॽ खोःसुङ्‌ङाङ् वाॽआरो॥’ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ यम्‍बा साभाङ्‌जा से़ःमा मे़हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","आल्‍ल खे़न् ये़म्‍मो कुस्‍साः तुम्‍बे़न् प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो याःम्‍बक् चोःक्नु यागे़॥ खे़न् आक्‍खो नुःक्‍खे़आङ् हिम्‍बेसाङ् के़रे़ल्‍ले़ हिम्‍मो मुक्‍लाहाॽ मुक्‍ते़बा नु मनाहाॽ मे़लाःक्‍खे़बा खे़प्‍सुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","हे़क्‍क्‍याङ् खुने़ॽ कन् थे पोःङ्‌ल पत्पे? फाॽआङ् खे़प्‍मो के़वाॽबा सेवारोबान् सेःन्‍दोसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","हे़क्‍क्‍याङ् खे़न् सेवारोबाल्‍ले़आङ् नोगप् पिरु, ‘खे़ने़ॽ के़न्‍साॽ फोॽबे़न् थेआङ् मे़म्‍बोःङ्‌ङे नुःरिक्‍काङ्‌नुःक्‍खे़ त्‍ये़आङ्‌वाॽ, खे़ल्‍ले़ चोगुल्‍ले़ के़म्‍बारे़ चालुप्‍मनाबा थक्‍साधिक् से़प्‍मा पाङ्‌घुसिआङ् कप्‍मो चामुक् थिमुक् से़ःसुबारो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","कर खुने़ॽ कुयाःक्‍ले़ॽरे़आङ् हिम् सिगाङ् लाःप्‍माए मे़दे़न्‍दे़न्‍लो॥ हे़क्‍केःल्‍ले़ कुम्‍बा लाःक्‍कात् लःन्‍दे़आङ् खे़न् हिम् सिगाङ् पित्‍छि फाॽआङ् ले़मु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","हे़क्‍केःल्‍ले़ खे़न् कुस्‍साः तुम्‍बाल्‍ले़ कुम्‍बा अक्‍खे मे़त्तु, ‘ओमे़त्ते़ॽ, इङ्‌गाॽ कम्‍भे़रिक् तङ्‌बे थारिक् खे़ने़ॽ के़सेवा चोगुङ्, के़बाःत्तुबा पाःन् आप्‍फाल्‍ले़आङ् इङ्‌गाॽ मे़न्‍अप्‍पे़न्‌, हे़क्‍केसाङ् खे़ने़ॽ आन्‍देःङ् आन्‍जुम्‍हाॽनु चामुक् थिमुक् चोगुङ्‌नि फाॽआङ् मे़न्‍दाक्‍साधिक्‍काङ् के़म्‍बिराङ्‌ङिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","कर कन् के़स्‍साःल्‍ले़ खे़ने़ॽ के़याङ्‌साकुन्‍धेहाॽ के़त्‍निमाहाॽनु ए़ःत्‍ले़ले़ लॽमाओ के़रे़क् माःन्‍दु॥ कर खुने़ॽ नुःक्‍खे़ त्‍ये़ःल्‍ले़ खे़ने़ॽ चालुप्‍मनाबा थक्‍साधिक् के़से़रुआङ् चामुक् थिमुक् के़से़ःसुरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","हे़क्‍केःल्‍ले़ कुम्‍बारे़ कुस्‍साःन् मे़त्तु, ‘आमिःम् आस्‍साःए, खे़ने़ॽग सदादिङ् इङ्‌गाॽनुए के़वाॽरो, हे़क्‍क्‍याङ् इङ्‌गाॽ कत्तुङ्‌बा काक् आयाङ्‌साकुन्‍धेहाॽ खे़ने़ॽइन्‍नेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","कर के़न्‍साॽ नुःक्‍खे़ त्‍ये़बाओ आनिॽ सःप्‍मा पोःङ्‌लो॥ थेआङ्‌भे़ल्‍ले़ खुने़ॽ स्‍ये़आङ् वये़, याम्‍मो हिङे़आङ् वाॽ॥ खुने़ॽ मये़बेआङ् वये़, कर याम्‍मो आनिॽ आघोःसुम्‍माङ् आवाॽरो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ये़सुरे़ कुहुॽसाम्‍बाहाॽ कन् खे़दाॽइन्‍नाङ् मे़त्तुसि, “याङ्‌साकुन्‍धेसाबा मनाधिक् वये़॥ खे़ल्‍ले़ कुहिम् कुधाःङ् ओमे़प्‍मा खाराःत् के़युङ्‌बाधिक् कत्तु॥ कर हाराए मनाहाॽरे़ खे़ल्‍ले़ कुन्‍दाङ्‌बान् कन् खाराःत् के़युङ्‌बाल्‍ले़ के़याङ्‌साकुन्‍धेहाॽ पिर्बेःन् चोगुर पत् लॽरिक् चे़ॽया पाःन् मे़जे़क्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","हे़क्‍क्‍याङ् कुन्‍दाङ्‌बाल्‍ले़ खे़न् खाराःत् के़युङ्‌बान् उःत्तुआङ् मे़त्तु, ‘खे़ने़ॽ के़याःम्‍बेओ फे़न् पाःन्‍हाॽ खे़प्‍सुङ्‌ल पत्तारो॥ खे़ने़ॽ के़युक्‍खुबा खाराःत्तिन् काक् ओसेःन्‍धाक्‍ताङ्‌ङे़ॽ, थेआङ्‌भे़ल्‍ले़ आल्‍लआङ्‌धो खे़ने़ॽ खाराःत् युङ्‌मा याःम्‍बक्‍किन् के़ङ्‌घोःसुन्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","हे़क्‍क्‍याङ् खे़न् खाराःत् के़युङ्‌बाल्‍ले़ कुनिङ्‌वाॽबो आबाङे अक्‍खे मे़त्‍छिङ्‌, ‘आल्‍ल इङ्‌गाॽ कन् खाराःत् युङ्‌मा याःम्‍बक्‍कोलाम् लःत्तादेःआल्‍ले़ थे चोगुङ्‌बाबे? इङ्‌गाॽ याःन्‍मःमाआङ् मे़सुक्‍कान्, चानाःक्‍मा चामाआङ् नुःन्‍नाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","कर कन् खाराःत् युङ्‌मा याःम्‍बक्‍कोलाम् लःत्ताल्‍ले़ आक्‍खेलॽरिक् मनाहाॽरे़ खुनिॽ हिम्‍मो मे़उःत्ता मे़दाःक्‍कार फाॽआङ् चोःक्‍मासि के़लॽबा पाःन्‍निन् इङ्‌गाॽ निःन्‍धो चोगुङ्‌ङाङ् वाॽआ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","हे़क्‍केःल्‍ले़ खे़ल्‍ले़ कुन्‍दाङ्‌बे़ल्‍ले़ कुसिङ्‌नाःत् के़बप्‍पा मनाहाॽ थिक् थिक् लॽरिक् उःत्तुसि, हे़क्‍क्‍याङ् थिक्‍सिगेःक्‍पे़न्‌सेःन्‍दोसु, ‘खे़ने़ॽ आक्‍खे़म्‍म्‍याक् आन्‍दाङ्‌बाल्‍ले़ कुसिङ्‌नाःत् के़बप्‍पे?’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","खे़न् मनाःल्‍ले़ ‘इङ्‌गाॽ कुगिप् ये़त्‍छि (८००) फोलक् निःङ्‌गेॽ पत्तारो’ मे़त्तु॥ खे़न् खाराःत् के़युङ्‌बाल्‍ले़ खे़न् मे़त्तु, ‘के़दे़म्‍सक्‍किन् कत्‍ना फे़त्ते़ॽ! हारा, कुगिप् ये़त्‍छिरे़ कुले़क्‌वा कुगिप् लिसि (४००) फोलक् लॽरिक् साप्‍ते़ॽ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","खे़न् खाराःत् के़युङ्‌बाल्‍ले़ वेॽस्‍मा मनाःन् सेःन्‍दोसु, ‘खे़ने़ॽ आक्‍खे़म्‍म्‍याक् सिङ्‌नाःत् के़बत्?’ खे़ल्‍ले़ नोगप् पिरु, ‘इङ्‌गाॽग फोलक् हे़न्‍छिङ् (१०००) सिः सिङ्‌नाःत् हुङ्‌मा कत्तुङ्‌लो॥’ हे़क्‍क्‍याङ् खे़न् मनाःल्‍ले़ खे़न् मे़त्तु, ‘खे़ने़ॽ के़दे़म्‍सक्‍को हारा हे़न्‍छिङ्‌धिक्‍ले़ कुले़क्‌वा कुगिप् ये़त्‍छि (८००) साप्‍ते़ॽ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","हे़क्‍केलॽरिक् कुन्‍दाङ्‌बाल्‍ले़ खे़न् ताप्‍फे़ःम्‍बा खाराःत् के़युङ्‌बाल्‍ले़ इस्‍वाबा कुयाःम्‍बक्‍किन् निःसुआङ् कुनारा फोःसुरो॥ हे़क्‍केलॽरिक्‍के कन् इक्‍सादिङ् खाम्‍बेःक्‍मोबाहाॽ से़न्‍दाङ्‌गे़न् ओःत्तिःल्‍ले़ कुस्‍साःहाॽनुःल्‍ले़ चाःप्‍पा मे़जोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","हे़क्‍क्‍याङ् खिनिॽ मे़त्‍निङ्‌लो, कन् इक्‍सादिङ् खाम्‍बेःक्‍मोबा याङ्‌साकुन्‍धेरे़ तेःङ्‌जुम् चोगे़म्‍सिम्‍मे़ॽओ॥ हे़क्‍केलॽरिक् कन् याङ्‌साकुन्‍धेःन् माःत्तिल्‍ले़ खे़ङ्‌हाॽरे़ खिनिॽ मे़न्‍नुप्‍मनाबा हिम्‍मो लाम्‍दाःक्‍मा के़म्‍बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","हे़क्‍क्‍याङ् आत्तिन् मनाःन् चुक्‍सा पाःन्‍नो लक्‍पे़न्‍साबा चोःक्, खे़ल्‍ले़ यम्‍बा पाःन्‍नो लक्‍पे़न्‌खोःसुॽरो॥ हे़क्‍क्‍याङ् आत्तिन् मनाःन् चुक्‍सा पाःन्‍नो नसाःन्‍साबा मे़जोःक्‍ने़न्, खे़न् यम्‍बा पाःन्‍नोआङ् नसाःन्‍साबा मे़बोःङ्‌ने़ल्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","आत्तिन् मनाःन् इक्‍सादिङ् खाम्‍बेःक्‍मोबा याङ्‌साकुन्‍धेओए नसाःन्‍साबा मे़बोःङ्‌ने़न्, खे़न् हाःत्‍ले़ से़क्‍खास्‍मा याङ्‌साकुन्‍धेओ लक्‍पे़न्‌पिरुबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","खिनिॽ वेॽ मनाहाॽरे़ खुनिॽ चिगःक्‌वाओए नसाःन्‍साबा के़म्‍बोःक्‍खिन्‍ने़ फाॽग्र, खिनिॽ आबाङेइन्‍नाङ्‌हाःत्‍ले़ के़बिरिॽबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","आत्तिन् सेवारोबाल्‍ले़आङ् ने़प्‍फु दाङ्‌बाहाॽरे़न् थिक्‍ले़ङ्‌मो सेवा चोःक्‍मा मे़सुक्‍तुन्‍लो॥ खे़ल्‍ले़ थिक्‍किन् चिःत्तुआङ् वेॽस्‍मान् मिःम्‍जि मे़त्तुॽ इग्र थिक्‍किन् इङ्‌धाःङ्‌पिरुआङ् वेॽस्‍मान् हिनाःम् मे़त्तुरो॥ खिनिॽ निङ्‌वाॽफुमाङ्‌ङिन् नु याङ्‌साकुन्‍धेःन् थिक्‍ले़ङ्‌मो सेवा चोःक्‍मा के़न्‍छुक्‍तुम्‍मिल्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","खे़प्‍मो फरिसिहाॽरे़ ये़सुरे़ कुबाःन्‍निन् मे़घे़प्‍सुआङ् किनाःन्‍दि मे़बिरु, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ खिःम्‌यक्‍पा मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽग सदादिङ् लाःक्‍कात्‍लक् नुःबा थाःम्‍सिङ्‌मा निङ्‌वाॽ के़जोगुम्, कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽ सिक्‍लुङ्‌मोबा पाःन्‍निन् निःसुॽरो॥ आत्तिन् पाःन्‍निन् मे़न्‍छाम्‍गे़न् याप्‍मिरे़ खुनिॽ निःमाओ यम्‍लाबा चोःक्, खे़न् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिःमाओ सिक्‍के़ले़ःङ्‌बा चोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","हे़क्‍क्‍याङ् बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ कुये़म् थारिक् मोसारे़ कुसाम्‌योथिम् नु माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ खुनिॽ इङ्‌जाःङ्‌हाॽ इङ्‌भन् पोःक्‍खे़, कर निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़न् सुनाइङ्‌ङिन्‌से़ःरे़आङ्धो मे़न्‍छाम्‍गे़न् याप्‍मिहाॽ निङ्‌वाॽफुहाङ्‌जुम्‍मो साक्‍के़ल्‍ले़क् लाःप्‍मा मे़गोःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","इक्‍सादिङ् खाम्‍बेःक्‍मान् नु ताङ्‌साक्‍पे़न्‌ले़क्‍मा पेःक्‍मा उसुरु चोःक्‍पिला, कर साम्‌योथिम् साप्‍लाओ के़बप्‍पा चुक्‍सा कुसाप्‍थिक्‍काङ् मे़माःने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","हाःत्‍ले़ कुमेःत्तिन् नाॽरुआङ् वेॽ मे़न्‍छुमाॽइन्‍नु मेःक्‍खिम् चोगुॽ, खे़ल्‍ले़ चाराम्‍मा याःम्‍बक् चोगुॽरो॥ हे़क्‍क्‍याङ् आत्तिन् मनाःल्‍ले़ कुये़म्‍बाःल्‍ले़ नाॽरुमा मे़न्‍छुमाॽइन्‍नु मेःक्‍खिम् चोगुॽ, खे़ल्‍ले़आङ् चाराम्‍मा याःम्‍बक् चोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ये़सुरे़ याम्‍मो मे़त्तुसि, “उन्‍छेःन् थिक्‍ले़ङ् याङ्‌साकुन्‍धेसाबाधिक् वये़॥ खे़ल्‍ले़ परान्‍ला तेःत् चाक्‍खुर थिक्‌याःन्‍धक् चामुक् थिमुक् चर वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","मनाहाॽरे़ लाजरस मे़प्‍मनाबा याङ्‌घेःक् इसेःङ्‌बा याङ्‌गे़साॽबा मनाःन् मे़दारुआङ् कुलाम्‍धेःप्‍पो मे़युक्‍खुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","खे़ल्‍ले़ चामादे़न्‍नोलाम् मक्‍के़धाःबा कुजिहाॽ चामाआङ् खाःत्‍छिङ्‌मा निङ्‌साङ् चोगुआङ् वये़रो॥ कोःत्‍चोहाॽरे़आङ् कुयाङ्‌घेःक्‍किन् मे़लागु मे़बिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","खे़न् याङ्‌के़साॽबा लाजरसे़न् स्‍ये़आङ् माङ्‌लाइङ्‌बाहाॽरे़ खुने़ॽ मे़बक्‍खु मे़देॽरुआङ् अब्राहामरे़ कुबेसाङ् मे़युक्‍खु॥ खे़न् याङ्‌साकुन्‍धेसाबे़न्‍नाङ् स्‍ये़आङ् मे़लुप्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","हे़क्‍क्‍याङ् खे़न् खे़मायङ्‌सङ्‌ङो पेआङ् साॽरिक् तुक्‍खे च्‍ये़॥ खे़न् माःङ्‌घा ओमये़ल्‍ले़ लाजरसे़न् अब्राहामरे़ कुभक्‍तुङ्‌ङो युङे़बा निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","हे़क्‍क्‍याङ् खे़न् याङ्‌साकुन्‍धेसाबाल्‍ले़ अःक्‍ते़र मे़त्तु, ‘पानुदिङ् आम्‍बे, इङ्‌गाॽ लुङ्‌माॽ तुक्‍ताङ्‌ङे़ॽआङ् लाजरसे़न् कॽयो पाङ्‌घे़ युःसे़ॽओ॥ कुहुक्‍चोःन् च्‍वाःत्तो निःप्‍सुआङ् आल्‍सोःप्‍पाल्‍ले़ कुसम्‍मो थाःसु पिआनिरो, थेआङ्‌भे़ल्‍ले़ कन् मिराःक्‍को इङ्‌गाॽ साॽरिक् तुक्‍खे चाआर याःक्‍कारो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","कर अब्राहाम्‍मिल्‍ले़ खुने़ॽ मे़त्तु, ‘आस्‍साःए, निङ्‌वाॽ इःत्ते़ साॽरे़, खे़ने़ॽ इक्‍सादिङ् खाम्‍बेःक्‍मो के़वये़ल्‍ले़ सुक्‍खेवाओ के़वये़, हे़क्‍क्‍याङ् कन् लाजरसे़न् तुक्‍खेवाओए वये़, कर आल्‍लो खुने़ॽ सुक्‍खेवाओ वाॽ, खे़ने़ॽ तुक्‍खे के़जर के़याक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","खे़न्‍नुःल्‍ले़आङ् खिनिॽ के़वयिबादे़न्‍नो आनिगे़ युःमा मे़सुक्‍तुम्‍बान्, हे़क्‍क्‍याङ् खिनिॽआङ् आनिगे़ वयिगे़बादे़न्‍नो थाङ्‌मा के़न्‍छुक्‍तुम्‍मिन्‍ल फाॽआङ् आनिॽ लुम्‍मो कुद्रोःम् मे़ःन्‍नेबा लुम्‍बाःत् ने़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","हे़क्‍केःल्‍ले़ खे़ल्‍ले़ पाःत्तु, ‘आम्‍बे, हे़क्‍केने़ फाॽग्र खे़न् आम्‍बारे़ कुहिम्‍मो पाङ्‌घे़ आबिरे़ॽओ फाॽआङ् पेलि फाक्‍ने़ॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","खे़प्‍मो ङासि आम्‍भुॽ आन्‍साॽसि मे़वाॽ, हाराॽ खे़ङ्‌हाॽ कन् तुक्‍खेवादे़न्‍नो मे़न्‍दाःने़न्‍ल फाॽआङ् साम्‍दिङ् पिरुसिनिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","कर अब्राहामरे़ खे़न् नोगप् पिरु, ‘खे़ङ्‌हाॽरे़ मोसा नु माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़न् साप्‍पन्‍हाॽ मे़गत्तुॽ, हाराॽ खे़न् मे़घे़प्‍सुनिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","कर खे़ल्‍ले़ नोगप् पिरु, ‘हे़क्‍के मे़ःन् आम्‍बे, कुभा मनाहाॽ के़सिःबोलाम् कुहिङ्‌वे़त् मे़बोःङ्‌ङाङ् मे़बेःक्‍ने़ फाॽग्र खे़ङ्‌हाॽरे़ नसाःन् मे़जोगुआङ् खुनिॽ लायोलाम् मे़हिन्‍नाङ् मे़हिङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","कर अब्राहामरे़ खे़न् नोगप् पिरु, ‘मोसा नु माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ खुनिॽ साप्‍पन्‍हाॽ मे़घे़प्‍सुआङ् नसाःन् मे़न्‍जोगुन्‍ने़ फाॽग्र, कुभा मनाहाॽ के़सिःबोलाम् कुहिङ्‌वे़त् मे़बोःङ्‌ङाङ् मे़बेःक्‍साङ् नसाःन् मे़न्‍जोगुन्‍लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “लायोओ के़धाःबा पाःन्‍हाॽ ताःएरो, कर खे़न् पाःन्‍हाॽ के़दाःप्‍पा मनाहाॽग मे़जिःत्ते़ मे़स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","कन् चुक्‍सा हिन्‍जाॽधिक् लायो चोःक्‍मा के़बाङ्‌बाङ्‌ग कुनिःङ्‌मो लुम्‍सुम्‍मिन् फोःम्‍माआङ् वरक्‍को लाप्‍फुमाल्‍ले़ए नुःबा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ! के़न्‍साॽरे़ खे़ने़ॽ के़दक्‍ले़ङ्‌वाओ लायो चोगुने़ फाॽग्र खे़न् फे़ःक्‍ते़ॽ, हे़क्‍क्‍याङ् कुलायोलाम् हिन्‍छिङ्‌ने़ फाॽग्र ले़प्‍मि पिरे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","हे़क्‍क्‍याङ् खुने़ॽ थिक् ये़न्‍नो नुसि ले़ङ् के़दक्‍ले़ङ्‌वाओ लायो चोगुआङ् नुसिले़ङ्‌ङे इङ्‌गाॽ हिन्‍दाङ्‌फाॽआङ् पाःत्तुॽने़ फाॽग्र ले़प्‍मि पिरे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","सेःक्‌युक्‍मिबाहाॽरे़ दाङ्‌बा ये़सुःन् मे़मे़त्तु, “आदाङ्‌बे, आनिगे़ नसाःन्‍निन् फोःसे़ आबिरे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","हे़क्‍केःल्‍ले़ दाङ्‌बाल्‍ले़ मे़त्तुसि, “खिनिॽ नसाःन्‍निन् यःङ्‌गेॽ याॽरिःम्‍बाधिक् याःत्‍छाङ् कन् खःक्‍सेॽबुङ्‌मान् ‘हाॽयाक्‌आगे़ॽआङ् वाहङ्‌ङो लाप्‍फुसिङ्‌ङे़ॽ’ के़मे़त्तुम्‍ने़ फाॽग्र खे़ल्‍ले़ के़मे़त्तुम्‍बा कुइसिःक् चोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“खिनिॽओ हाःत्‍ले़ के़क्‍चु के़धोःङ्‌बा सेवारोबान् इग्र मे़ल्‍लुक् चागे़राम्‍बे़न् याःम्‍बक्‍कोलाम् नुःङ् ताःल्‍ले़ ‘हाराॽ फे़रे़ॽआङ् चाजासे़ युङ्‌सिङ्‌ङे़ॽ’” के़मे़त्तुम्‍बे? ");
INSERT INTO lifNT2_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","खे़ल्‍ले़ कुले़क्‌वा “चामा थुङ्‌मा यारिप् चोगे़ॽ हे़क्‍क्‍याङ् फॽइ युप्‍सिङ्‌ङे़ॽआङ् इङ्‌गाॽ चामा थुङ्‌मा मे़न्‍छुःत्ते थारिक् हाङ्‌घाङ्‌ङे़ॽ हे़क्‍क्‍याङ्‌लक् खे़ने़ॽ चे़ॽ के़म्‍मे़त्तुम्‍मिम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","कुसेवारोबाल्‍ले़ नुःरिक् याःम्‍बक् चोगु फाॽआङ् कुन्‍दाङ्‌बाल्‍ले़ कुसेवारोबान् ओबे़ नुःरिक् सेवा के़मे़त्ताङ्‌लो फाॽआङ् मे़त्तुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","“खिनिॽआङ् मे़प्‍मनाबा याःम्‍बक् के़जोगुम् के़सुरुम्‍ने़ फाॽग्र अक्‍खे पाःत्ते़म्‍मे़ॽ, ‘आनिगे़ग कुसुम् मे़न्‍दम्‍मनाबा के़सेवारोबासिगे़रो॥ आनिगे़ग के़बाःत्तुबा हे़क्‍केरक् चोगुम्‍बे़आङ् वयिगे़रो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","हे़क्‍क्‍याङ् ये़सुःन् यरुसले़म्‍मो पेर पत्‍छे़ल्‍ले़ गालिल नु सामरियारे़ कुलुम्‍मो पोःक्‍खे़र पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","हे़क्‍क्‍याङ् थिक् पाङ्‌भेॽ कुबेसाङ् के़रे़ल्‍ले़ खे़प्‍मो थिबोःङ् लोगेॽ तुक्‍माल्‍ले़ याङ्‌घुसिबाहाॽ तुमुसि॥ खे़ङ्‌हाॽ माःङ्‌घा मे़ये़म्‍सिङ्‌ङाङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","यम्‍बा इक्‍लाओ मे़अःक्‍ते़, “दाङ्‌बा ये़सुए, आनिगे़ लुङ्‌माॽ आदुक्‍ते़ॽआङ् आनुःसे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ये़सुरे़आङ् खे़ङ्‌हाॽ ओमे़त्तुसिर मे़त्तुसि, “पेगे़म्‍मे़ॽआङ् निङ्‌वाॽफुसाम्‍बाहाॽरो ओसेःन्‍धाक्‍कासिम्‍मे़ॽओ॥” हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़बेर मे़बत्‍छे़ल्‍ले़सा लोगेॽ तुक्‍मोलाम् मे़नुःरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","हे़क्‍क्‍याङ् थिक् के़दुक्‍पाल्‍ले़ खुने़ॽ नुःरे़बा निङ्‌वाॽ खोःसुआङ् यम्‍बा इक्‍लाओ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःसुर नुःक्‍खे़ त्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","खे़न् ये़सुरे़ कुलाङ्‌जक्‍पो साम्‍बोःन् फन्‍छिङ्‌ल नोगे़न् पिरुरो॥ खे़ङ्‌ग सामरि सुवाङ्‌स्‍मा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ये़सुरे़ पाःत्तु, “कन् तुक्‍मोलाम् के़वेःप्‍पाहाॽग थिबोःङ्‌ने़ (१०) मे़वये़, कर वेॽ फाङ्‌सिहाॽ (९) आत्तान् मे़बेबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","आक्‍खेआङ् कन् लत्‍छा थिम्‍मे़न्‍दङ् मनाःन्‍लक् निङ्‌वाॽफुमाङ्‌ङिन् मिमिदिङ् पिसे़ नुःक्‍खे़ त्‍ये़बे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ये़सुरे़ खे़न् मे़त्तु, “पोगे़ॽआङ् पेगे़ॽओ॥ के़नसाःन्‍निल्‍ले़ खे़ने़ॽ के़नुःसे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","थिक् ये़न् फरिसिहाॽरे़ ये़सुःन् सेःन्‍मे़दोसु, “निङ्‌वाॽफुहाङ्‌जुम्‍मिन् आप्‍फाल्‍ले़ ताःबे?” ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “निङ्‌वाॽफुहाङ्‌जुम्‍मिन् निःमनाबा मिक्‍सेःन्‍नु मे़दाने़न्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","हाःत्‍ले़आङ् ‘खे़न् खे़त्‍ना वाॽ, कत्‍ना वाॽ’ फाॽआङ् पाःप्‍मा मे़सुक्‍तुन्॥ ओमे़त्ते़म्‍मे़ॽ, निङ्‌वाॽफुहाङ्‌जुम्‍मिङ्‌ग खिनिॽ लुम्‍मोए वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “आल्‍ल अक्‍तङ्‌बा ये़म्‍मिन् ताःर पत्‍लो, खे़न् ये़म्‍मोग मे़न्‍छाम्‍साःन् कुये़न्‍नो हे़क्‍केए खिनिॽ ओमे़प्‍मा निङ्‌वाॽ के़जोगुम्, कर के़ङ्‌घोःसुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","मनाहाॽरे़ खुने़ॽ खे़त्‍ना वाॽ, खुने़ॽ कत्‍ना वाॽ लॽरिक् के़म्‍मे़त्तिल्‍ले़ खुने़ॽ कुओमे़त्‍छे़ मे़बेगे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","थेआङ्‌भे़ल्‍ले़ मे़न्‍छाम्‍साःल्‍ले़ कुये़म्‍मिङ्‌ग साःम्‍भे ले़क्‍किल्‍ले़ ताङ्‌साक्‍पाल्‍ले़ थिक् कुयाओनु वेॽस्‍मा कुयाओ थारिक् थोॽरुबा कुइसिःक् के़रे़क्‍ले़ मे़निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","कर काक्‍नु तगि मे़न्‍छाम्‍साःन् साॽरिक् तुक्‍खे चाःॽ, हे़क्‍क्‍याङ् कन् ये़म्‍मोबा मनाहाॽरे़ खुने़ॽ मे़नाॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","हे़क्‍क्‍याङ् मे़न्‍छाम्‍साःन् नुःङ् युःल्‍ले़ नुहारे़ कुये़म् हे़क्‍केए पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","नुहाःन्‌वालाधाओ लाःसे़आङ् इक्‍सादिङ् खाम्‍बेःक्‍मो यम्‍बा वादोःक्‍मा थाङे़आङ् काक् मे़न्‍छाम्‍गे़न् याप्‍मिहाॽ मे़निःबे़ मे़स्‍ये़, कर खुने़ॽ वालाधाओ लाःसे़बा ये़न् थारिक् मनाहाॽ मे़जर मे़धुङुर हे़क्‍क्‍याङ् मेःक्‍खिम् मे़जोगुर मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","हे़क्‍क्‍याङ् लुते़ल्‍ले़ कुये़म्‍मोआङ् हे़क्‍केए पोःक्‍खे़॥ मनाहाॽरे़ मे़जर मे़धुङुर मे़वये़, खे़ङ्‌हाॽ चिगःक्‌वा सङ्-इङ्‌नु, इक् मःनु, हिम्‍धाःङ् चोःक्‍नु मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","कर लुतरे़ सदोम ये़क्‌यक्‍किन्‌ले़रुआङ् पेःल्‍ले़ ताङ्‌साक्‍पोलाम् मिराःक् नु थाबुःन् थ्‍ये़आङ् काक् मनाहाॽ मे़क्‍खुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","हे़क्‍केलॽरिक्‍के मनाहाॽ यारिप्‌मे़बोःङ्‌ङे मे़वाॽइल्‍ले़ मे़न्‍छाम्‍साःन् ओसेःन्‍दाङ्‌पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","खे़न् ये़म्‍मो हिम् सम्‍दाङ् के़वाॽबा मनाःन् चिगःक्‌वा लाःसे़ हिम् सिगाङ् मे़लाःत्‍ने़न्‍ल, हे़क्‍क्‍याङ् प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो के़वाॽबा मनाःन् चिगःक्‌वा लाःसे़ हिम्‍मो मे़नुःङ्‌ने़न्‌मे़बेःक्‍ने़न्‍लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","लुतरे़ कुमेःत्तिन् युम् सित्‍लाङ् पोःक्‍खे़बा पाःन्‍निन् निङ्‌वाॽ इःत्ते़म्‍मे़ॽओ! ");
INSERT INTO lifNT2_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","हाःत्‍ले़ कुहिङ्‌मन्‍निन् से़ःप्‍तुङ्‌लॽ, खे़ल्‍ले़ खे़न्‍नाङ् मासुॽरो, कर हाःत्‍ले़ कुहिङ्‌मन्‍निन् मासुॽ, खे़ल्‍ले़ से़ःप्‍तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","खे़न् से़न्‍दिक् ने़प्‍फु मनाहाॽ सोरिक् ने़सिॽ, थिक्‍किन् तेॽ, वेॽस्‍मान् ने़ लाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","हे़क्‍क्‍याङ् ने़प्‍फु मे़न्‍छुमाहाॽ लुङ्‌सुम्‍मो याॽयुःत्‍नु युङ्‌सिल्‍ले़ थिक्‍किन् तेॽ, वेॽस्‍मान् युङ्‌लाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","((ने़प्‍फु मनाहाॽ प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो याःम्‍बक् चोःक्‍सिर याक्‍सिॽ, थिक्‍किन् तेॽ, वेॽस्‍मान्‌वाॽ लाःत्‍लो॥))” ");
INSERT INTO lifNT2_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽरे़ ये़सुःन् मे़मे़त्तु, “आदाङ्‌बे, कन् आत्तो पोःङ्‌बाबे?” ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “किदाबाहाॽ मे़जुम्‍मिल्‍ले़ खे़प्‍मो सिनुःन्‌ने़ के़लॽबा पाःन्‍निन्‌कुसिङ्‌निःप्‍मनाबा हे़क्‍के, कन्‌मिक्‍सेःन्‍हाॽ पोःङ्‌ङिल्‍ले़ कुनुप्‍मा ये़म्‍मिन्‌निःत्ताङ्‌वाॽ फाॽआङ्‌के़निःसुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","हे़क्‍क्‍याङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ चक्‍मे़ल्‍लॽए तुवा चोःक्‍मा पोःङ्, आप्‍फाल्‍ले़आङ् निङ्‌वाॽ सोःम्‍मा मे़नुॽने़न् लॽरिक् हुॽमासि फाॽआङ् लत्‍छा खे़दाॽ मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“थिक् ये़क्‌यक्‍को लत्‍थिक् निङ्‌वाॽफुमाङ्‌नु मे़ङ्‌गिःमनाबा, आत्तिन् मनाःन्‍नाङ् इङ्‌धाःङ् मे़म्‍बिमनाबा खासे़न्‍लोःम्‍बाधिक् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","हे़क्‍क्‍याङ् हाबा खे़न् ये़क्‌यक्‍को मेमेदुमा‌धिक्‍काङ्‌वये़॥ खे़न् ए़त्‍ले़ङ् खासे़न्‍लोःम्‍बाल्‍लो त्‍ये़र आप्‍तिक् याप्‍मि के़गुःप्‍पाल्‍ले़ कुदक्‍ले़ङ्‌वाओ खासे़न् लोःन्‍दाङ् पिराङ्‌ङे़ॽ फाॽआङ् मे़त्तुर वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","हे़क्‍केःल्‍ले़ तगिग खे़न् खासे़न्‍लोःम्‍बाल्‍ले़ कोजाक् मे़मे़त्तुन्, कर याङ्‌सि अक्‍खेलॽरिक् कुनिङ्‌वाॽओ इःत्‍छिङ्‌, ‘इङ्‌गाॽग निङ्‌वाॽफुमाङ्‌ङिन्‍नुआङ् मे़गिआन्, आत्तिन् मनाहाॽआङ् इङ्‌धाःङ् मे़बिरुङ्‌सिङ्‌ङिन्, ");
INSERT INTO lifNT2_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","कर कन् मेमेदुमान्‌खासे़न् मे़लोःन्‍दुङ्‌ङिन् मे़बिरुङ्‌ङिन्‍ने़ फाॽग्र ए़त्‍ले़ङ् साॽरिक् तुक्‍खे चाःत्ताआङ् से़त्ताबा पोःक्‍खे़॥ आल्‍ल खे़न् खासे़न् लोःम्‍मा पिमा पोःक्‍खे़रो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","दाङ्‌बाल्‍ले़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “खे़न् ताप्‍फे़ःम्‍बा खासे़न्‍लोःम्‍बाल्‍ले़ पाःत्तुबा पाःन्‍निन् खे़प्‍से़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेगुसिबा कुमनाहाॽ से़न्‍दिक् ले़न्‍दिक् मे़हाःप्‍ल तुवा चोःक्‍कि पेलि मे़भाक्‍किल्‍ले़, खुने़ॽ से़क्‍खासाङ् कुमनाहाॽ खासे़न् मे़लोःन्‍दुन् मे़बिरुन्‍सिन्‍नाङ्‌खुने़ॽ खे़ङ्‌हाॽ खे़म्‍घे़म्‍लक् लाप्‍तुसिॽबि? ");
INSERT INTO lifNT2_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","हे़क्‍के मे़ःन्‍लो, कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमनाहाॽ हाराए खासे़न् लोःन्‍दुबिरुसिॽरो॥ कर मे़न्‍छाम्‍साःन् इक्‍सादिङ् खाम्‍बेःक्‍मो ताःल्‍ले़ कप्‍मो नसाःन् के़जोःक्‍पाहाॽ तुमुसिॽबि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","हे़क्‍क्‍याङ् ये़सुरे़ इङ्‌गाॽरक् साम्‌योनिबा के़लॽबाआङ् वेॽ मनाहाॽ हिनाःम् के़मे़प्‍पा मनाहाॽ कन् खे़दाॽइन् मे़त्तुसि– ");
INSERT INTO lifNT2_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ने़प्‍फु मनाहाॽ माङ्‌हिम्‍मो तुवा चोःक्‍से़ पेसि॥ खे़ङ्‌हाॽओ लत्‍थिक्‍किन्‌फरिसि नु वेॽस्‍मान् एःङ्‌याङ् के़भोःङ्‌बा वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","खे़न् फरिसिःन् एःक् ये़म्‍सिङ्‌ङाङ् तुवा चोगु, ‘निङ्‌वाॽफुमाङ्‌ङे, इङ्‌गाॽ नोगे़न् पिने़रो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ वेॽस्‍मा मनाहाॽ हे़क्‍के, साक्‍के़ल्‍ले़क्‍काङ् याङ् के़भोःङ्‌बा, मना ताप्‍फे़ःल्‍लिक् के़मे़प्‍पा, चाराम्‍मा याःम्‍बक् के़जोःक्‍पा, हे़क्‍क्‍याङ् कन् एःङ्‌याङ् के़भोःङ्‌बा हे़क्‍के इङ्‌गाॽ मे़जोःक्‍कान्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","इङ्‌गाॽ ये़त्‍नाम्‍ले़ निले़ङ् चाःने़त्तो युङ्‌ङाॽ, हे़क्‍क्‍याङ् इङ्‌गाॽ खोःसुङ्‌बा थगुङ्‌बा के़रे़क्‍ले़न् थिबोःङ्‌लक् पिने़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","कर खे़न् एःङ्‌याङ् के़भोःङ्‌बे़ङ्‌ग माःङ्‌घा ये़म्‍सिङ्‌ङाङ् साङ्‌ग्राम्‍पेदाङ् ले़प्‍माङ्‌ङाङ् ओमे़म्‍मए कुसङ्‌बे़न् हिप्‍तुर हाबे़र अक्‍खे पाःत्तु, ‘निङ्‌वाॽफुमाङ्‌ङे, इङ्‌गाॽ लुङ्‌माॽ तुक्‍ताङ्‌ङे़ॽओ, इङ्‌गाॽग लायोबाआरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ओमे़त्ते़म्‍मे़ॽओ, कन् एःङ्‌याङ् के़भोःङ्‌बे़ङ्‌ग फरिसिःन्‍नुःल्‍ले़ साम्‌योनिबा पोःक्‍खे़आङ् कुहिम्‍मो पेरो॥ थेआङ्‌भे़ल्‍ले़ आत्तिन् मनाःन् थाःङ्‌धाःङ् यम्‍बा ले़ङ्‌सिङ्, खे़न् चुङ्‌जिगे़न् पोःङ्‌लो॥ आत्तिन् चुङ्‌जिगे़न् ले़ङ्‌सिङ् खे़न्‍निन् यम्‍बलाबा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","आल्‍ल खे़प्‍मो मनाहाॽरे़ हिन्‍जाॽबित्‍छाहाॽआङ् हाराॽ खुनिॽ सम्‍दाङ् ये़सुरे़ हुक् ने़स्‍सुआङ् मुॽइसाम् पिरुसिर फाॽआङ् मे़दारुसि, कर कुहुॽसाम्‍बाहाॽरे़ खे़न् मे़निःसुआङ् खे़न् के़दाःप्‍पाहाॽ मे़भे़ःक्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","कर ये़सुरे़ खे़ङ्‌हाॽ उःत्तुसिआङ् मे़त्तुसि, “कन् हिन्‍जाॽबित्‍छाहाॽ इङ्‌गाॽओ ताःमा फाःक्‍ते़म्‍सिम्‍मे़ॽओ, खे़ङ्‌हाॽ मे़साक्‍ते़म्‍सिम्‍मिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍मिङ्‌ग कन् हिन्‍जाॽबित्‍छा हे़क्‍तङ्‌बाहाॽरे़न्‍नेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, हाःत्‍ले़ हिन्‍जाॽबित्‍छाहाॽ हे़क्‍के कुदोःप्‍मा निङ्‌वाॽइल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् मे़दाःक्‍तुन्, खे़न् खे़प्‍मो लाःप्‍मा मे़घोःने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","खे़प्‍मो सुहाङ्‌युक्‍पाधिक् त्‍ये़आङ् ये़सुःन् सेःन्‍दोसु, “के़नुॽबा सिक्‍साम्‍बे, आक्‍तङ्‌बा नुःबा याःम्‍बक् चोगुङ्‌ङिल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुङ्‌बे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ये़सुरे़ खे़न् नोगप् पिरु, “थेआङ् इङ्‌गाॽ के़नुॽबा के़मे़त्ताबे? के़नुॽबाग निङ्‌वाॽफुमाङ्‌ङिन्‍लक् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","खे़ने़ॽ साम्‌योथिम् इङ्‌जाःङ्‌हाॽ के़ले़स्‍सुआङ् के़वाॽ–‘याप्‍मि से़प्‍मा मे़नुॽने़न्, चाराम्‍मा याःम्‍बक् चोःक्‍मा मे़नुॽने़न्, खुःम्‍मा मे़नुॽने़न्, इङ्‌ले़क् पाःप्‍मा मे़नुॽने़न्, हे़क्‍क्‍याङ् पा-मा इङ्‌धाःङ् पिमासिए पोःङ्॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","खे़न् मनाःल्‍ले़ नोगप् पिरु, “सिक्‍साम्‍बे, कन् के़रे़क् साम्‌योथिम् इङ्‌जाःङ्‌हाॽग इङ्‌गाॽ हिन्‍जाॽ वयाङ्‌ङाङ्धोए इःत्तुङ् नाःत्तुङ्ल वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ये़सुरे़ खे़न् खे़प्‍सुआङ् मे़त्तु, “आल्‍लसाङ् खे़ने़ॽ याःम्‍बक्‍थिक्‌चोःक्‍मा के़गत्तुॽरो॥ खे़ने़ॽ के़गत्तुबान्‌के़रे़क् सङ्‌घे़देःसे़ॽ हे़क्‍क्‍याङ् याङ्‌गे़साॽबाहाॽ पिरे़से़ॽओ॥ हे़क्‍केलॽरिक् साङ्‌ग्राम्‍पेदाङ्‌ङो याङ्‌साकुन्‍धे के़घोःसुॽरो॥ हे़क्‍क्‍याङ् फे़रे़ॽआङ् इङ्‌गाॽ तिम्‍दाङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","कर खुने़ॽ खे़न् पाःन्‍निन् खे़प्‍सुल्‍ले़ साॽरिक् कुनिङ्‌वाॽ तुगे़, थेआङ्‌भे़ल्‍ले़ खुने़ॽग आत्तात्तान्‍ने याङ्‌साकुन्‍धेसाबा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ये़सुरे़ खे़न् ओमे़त्तुआङ् पाःत्तु, “याङ्‌साकुन्‍धेसाबाहाॽग निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःप्‍मा साॽरिक् साक्‍लो! ");
INSERT INTO lifNT2_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","से़क्‍खाए याङ्‌साकुन्‍धेसाबे़न् निङ्‌वाॽफुहाङ्‌जुम्‍मो लाःप्‍मानुःल्‍ले़ उमेःन् सम्‍मेःत्तिल्‍ले़ कुहङ्‌ङो लाःप्‍मा उसुरु चोःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","कन् पाःन् के़घे़म्‍बाहाॽरे़ खुने़ॽ सेःन्‍मे़दोसु, “हे़क्‍केःल्‍ले़ हाःत् ताङ्‌से़ःप्‍मा सुक्‍पाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “मे़न्‍छाम् याप्‍मिरे़ लागि सुक्‍मे़न्‍दे़प्‍मनाबा पाःन्‍हाॽग, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सुक्‍तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","हे़क्‍केःल्‍ले़ पत्रुसरे़ पाःत्तु, “आनिगे़ हिम्‍धाःङ् ले़रुम्‍बे़आङ्‌खे़ने़ॽ तिम्‍मासिगे़आङ् वयिगे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, निङ्‌वाॽफुहाङ्‌जुम्‌रे़ लागि हिम्‍धाःङ्, मेःत्, फुॽनुसाॽहाॽ, मा-बाहाॽ, इग्र हिन्‍जाॽबित्‍छाहाॽ के़ले़प्‍पाहाॽरे़ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","कन् हिङ्‌मन्‍नो खे़न्‍नुःल्‍ले़आङ् यरिक् मे़घोःसुॽ, हे़क्‍क्‍याङ् के़दाःबा ये़म्‍मो मे़न्‍नुप्‍मनाबा हिङ्‌मन् मे़घोःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ये़सुरे़ थिक्-ने़त् (१२) कुहुॽसाम्‍बाहाॽ थिक्‍ले़प्‍माङ् तेॽरुसिआङ् मे़त्तुसि, “आल्‍ल खे़प्‍से़म्‍मे़ॽओ, आनिॽग यरुसले़म थो आबेःक्‍ल आबत्‍लो॥ खे़प्‍मो उन्‍छेःन्‍बा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ मे़न्‍छाम्‍साःल्‍ले़ कुयाःम्‍बेओ मे़साप्‍तुबा के़रे़क् पाःन्‍निन् के़त्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","खुने़ॽ मे़दे़म्‍सुआङ् थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ खुनिॽ हुक्‍को मे़बिरुॽ, हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुने़ॽ किनाःन्‍दि मे़बिरुॽ, कुनामे़धासुॽ, थ्‍याःत् मे़धोःक्‍तुॽ, ताप्‍फे़ःल्‍लिक् मे़मे़त्तुॽ, हे़क्‍क्‍याङ् खुने़ॽ ते़ःम्‍भुक् मे़याक्‍तुआङ्‌मे़से़रुॽ, ");
INSERT INTO lifNT2_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","हे़क्‍केसाङ् सुम् ये़न् एगाङ् खुने़ॽ सिःमे़न्‍लाम् याम्‍मो हिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","कर खे़ङ्‌हाॽरे़ कन् पाःन्‍निन् थेआङ् कुसिङ् मे़न्‍निःत्तुन्, थेआङ्‌भे़ल्‍ले़ कन् पाःन्‍निल्‍ले़ कुबेःन् खे़ङ्‌हाॽरोलाम् माॽरे़आङ् वये़रो॥ खे़ल्‍ले़ चोगुल्‍ले़ कन् पाःन्‍निन् खुनिॽ निङ्‌वाॽ सिगाङ् मे़बेने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ये़सुःन् ये़रिहो ये़क्‌यक्‍किल्‍ले़ कुबेसाङ् के़रे़ल्‍ले़ खे़प्‍मो मिक्‍फःम्‍बाधिक् चानाःक्‍कि लाम्‍मिल्‍ले़ कुबेसाङ् युङे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","खे़ल्‍ले़ कुबेसाङ्‌नु मनाहाॽ मे़बेःक्‍ल मे़बत् के़लॽबा निङ्‌वाॽ खोःसुआङ् थेःन्‍ने़ पोःङ्‌ल पप्‍पे फाॽआङ् मनाहाॽ सेःन्‍दोसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","खे़ङ्‌हाॽरे़ खे़न् नोगप् मे़बिरु, “नासरतस्‍मा ये़सुःन् पेःक्‍ल पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","खे़ल्‍ले़ अःक्‍ते़र अक्‍खे पाःत्तु, “दाउदरे़ कुस्‍साः ये़सुए, इङ्‌गाॽ लुङ्‌माॽ तुक्‍ताङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","हे़क्‍केःल्‍ले़ खे़न् लाम्‍लो के़बेःक्‍पा मनाहाॽरे़ “स्‍वाःत्‌युङे़ॽ” मे़मे़त्तुर खे़न् मे़भे़ःक्‍तु, कर खे़ल्‍ले़ आल्‍लसाङ् साॽरिक् “दाउदरे़ कुस्‍साःए, इङ्‌गाॽ लुङ्‌माॽ तुक्‍ताङ्‌ङे़ॽओ” पाःत्तुर अःक्‍ते़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ये़सुःन् खे़प्‍मो ये़म्‍सिङ्‌ङाङ् खे़न् चागे़नाःक्‍पे़न् कुबेसाङ् मे़दारुनि फाॽआङ् इङ्‌जाःङ् पिरुसि॥ हे़क्‍क्‍याङ् खे़न्‍नाङ् ये़सुरे़ कुबेसाङ् त्‍ये़आङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ये़सुरे़ खे़न् सेःन्‍दोसु, “इङ्‌गाॽ खे़ने़ॽ थे़मा चोगुङ् पिने़ फाॽआङ् निङ्‌वाॽ के़इःत्तुबे?” खे़ल्‍ले़ नोगप् पिरु, “आदाङ्‌बे, इङ्‌गाॽ निःमा के़सुक्‍पा पोःङ्‌ङार॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ये़सुरे़ खे़न् मे़त्तु, “खे़ने़ॽ निःमा के़सुक्‍पा पोःक्‍खे़ॽओ, थेआङ्‌भे़ल्‍ले़ खे़ने़ॽ के़नसाःन्‍निल्‍ले़ के़नुसे़आङ् के़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","खिमो खे़न् निःमा के़सुक्‍पा पोःक्‍खे़आङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरुर ये़सुरे़ कुएगाङ् थासिङ्‌लो॥ मनाहाॽरे़आङ् खे़न् मे़निःसुआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा मे़भोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ये़सुःन् ये़रिहो ये़क्‌यक्‍लाम् पोःक्‍खे़र पेर पत्‍छे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","खे़न् ये़क्‌यक्‍को जक्‍कै मिङ् के़वाःप्‍पा याङ्‌साकुन्‍धेसाबा तुम्‍एःङ्‌याङ् के़भोःङ्‌बाधिक् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ये़सुःन् पेर पत्‍छे़ल्‍ले़ खुने़ॽआङ् ओमे़प्‍मा निङ्‌वाॽ चोगुआङ् ये़सुरे़ कुओमे़त्‍छे़ पे, कर ताङ्‌सा चोगे़बाल्‍ले़ मनाहाॽरे़ खुने़ॽ मे़धेःक्‍तुआङ् निःमा मे़सुक्‍तुन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","हे़क्‍केःल्‍ले़ खुने़ॽ तगि पेआङ् ये़सुरे़ कुओमे़त्‍छे़ लाम्‍मिल्‍ले़ कुबेसाङ्‌बा पःत्‍छेॽबुङ्‌मो लाःसे़आङ् युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ये़सुःन् खे़प्‍मो के़रे़ल्‍ले़ थो ओमये़आङ् मे़त्तु, “जक्‍कैए, खे़ने़ॽ हारा थ्‍ये़ॽओ॥ आइन् इङ्‌गाॽ के़हिम्‍मो ने़आबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","हे़क्‍केःल्‍ले़ जक्‍कैन्‌यो थ्‍ये़आङ् कुसिराॽ पधाङ्थाङे़र ये़सुःन् कुहिम्‍मो लाङ्‌दाःक्‍मा पिरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","खे़प्‍मो के़वाॽबा मनाहाॽरे़ ये़सुःन् लायोबाल्‍ले़ कुहिम्‍मो याङ्‌धोःक्‍से़ पेरो फाॽआङ् कानाक्‍नाक् मे़लॽरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","याङ्‌सि जक्‍कैःन् ये़म्‍सिङ्‌ङाङ् दाङ्‌बान् अक्‍खे मे़त्तु, “इङ्‌गाॽ कत्तुङ्‌बा याङ्‌साकुन्‍धेःन् कुभ्रे़ःङ् याङ्‌गे़साॽबाहाॽ हाःत्तुङ्‌सिङ्‌लो॥ हे़क्‍क्‍याङ् आत्तिन्‍हाॽ इङ्‌ले़क् मे़त्तुङ्‌सिङ्‌ङाङ् यरिक् याङ् फोःक्‍खुङ्‌सिङ्‌ङाङ् वाॽआ, खे़ङ्‌हाॽ इङ्‌गाॽ लिसि ले़ङ् थारिक् नुःक्‍तुङ् पिरुङ्‌सिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","हे़क्‍केःल्‍ले़ ये़सुरे़ पाःत्तु, “आइन् कन् हिम्‍सयङ्‌ङिल्‍ले़ से़न्‍लप् खोःसुआङ् वाॽरो, थेआङ्‌भे़ल्‍ले़ जक्‍कैःन्‍नाङ् अब्राहामरे़न्‍ने कुमुॽइदाङ्‌सारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","मे़न्‍छाम्‍साःन् लायोओ के़माबाहाॽ कोःप्‍मा नु हिङ्‌मासि फाॽआङ् त्‍ये़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","कन् पाःन्‍निन् मे़घे़प्‍सुआङ् ये़सुरे़ वेॽस्‍मा खे़दाॽधिक् मे़त्तुसि, थेआङ्‌भे़ल्‍ले़ खुनिॽ यरुसले़म निःत्ताङ् मे़गे़रे़आङ् मे़वये़, हे़क्‍क्‍याङ् कुभारे़ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् खिमो ताः फाॽआङ् मे़इःत्तुआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“हाङ्‌गे़म्‍बासाःधिक्‌माःङ्‌घा लाजेॽओ हाङ् चोःक्‍मा युक् खोःमा फाॽआङ् लाम्‍दिःक् चोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","खुने़ॽ पेःक्‍मानुःल्‍ले़ तगि थिबोःङ् कुसेवारोबाहाॽ उःत्तुसिआङ् लत्‍छा लत्‍छा साम्‍म्‍याङ् याङ् पिरुसिर अक्‍खे मे़त्तुसि, ‘इङ्‌गाॽ मे़न्‍नुःङ् मे़न्‍दाए थारिक् कल्‍ले़ ले़ङ्‌हङ् चोगे़म्‍मे़ॽओ॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","कर कुयक्‌युङ्‌बाहाॽरे़ खुने़ॽ मे़जिःत्तुआङ् कुएगाङ् कुएगाङ् “कन् मनाःल्‍ले़ आनिगे़ सम्‍दाङ् हाङ् चोगुबा सिराॽ मे़धाङ्‌ङिन्‍लो” मे़बाःत्तुर इङ्‌साबाहाॽ मे़बाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","हे़क्‍क्‍याङ् खे़ल्‍ले़ हाङ्‌युक् खोःसुआङ् नुःक्‍खे़ त्‍ये़रो॥ आल्‍ल खुने़ॽ याङ् पिरुसिबा कुसेवारोबाहाॽ उःत्तुसिआङ् ले़ङ्‌हङ् के़जोगुम्‍माङ् आक्‍खे़म्‍म्‍याक् याङ् के़धगुम् फाॽआङ् सेःन्‍दोसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","थिक्‍सिगेःक्‍पा सेवारोबाल्‍ले़ मे़त्तु, “आदाङ्‌बे, इङ्‌गाॽ के़याङ्‌धिक्‍किल्‍ले़ वेॽ थिबोःङ् याङ् थगुङ्‌ङाङ्‌वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","हे़क्‍क्‍याङ् खे़ल्‍ले़ मे़त्तु, “नुःरे़रो आसेवारोबे, साॽरिक् नुःबा के़जोगुरो! खे़ने़ॽ थिबोःङ् ये़क्‌यक् सम्‍दाङ् सुहाङ्‌गे़म्‍बा के़बोःङ्‌लो, थेआङ्‌भे़ल्‍ले़ चुक्‍सा पाःन्‍नो नसाःन्‍साबा के़बोःक्‍खे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","हे़क्‍क्‍याङ् निसिगेःक्‍पा सेवारोबाल्‍ले़ मे़त्तु, “आदाङ्‌बे, इङ्‌गाॽ के़याङ्‌धिक्‍किल्‍ले़ वेॽ ङासि याङ् थगुङ्‌ङाङ्‌वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","हे़क्‍क्‍याङ् खे़न् मे़त्तु, “खे़ने़ॽआङ् ङासि ये़क्‌यक् सम्‍दाङ् सुहाङ्‌गे़म्‍बा के़बोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","हे़क्‍क्‍याङ् सुम्‍सिगेःक्‍पा सेवारोबाल्‍ले़ मे़त्तु, “आदाङ्‌बे, के़याङ्‌धिक्‍किन्‌बा कप्‍मो वाॽरो, के़याङ्‌ङिन् इङ्‌गाॽ तेःत्तो सुङुङ्‌चिक्‍खुङ्‌ङाङ् कत्तुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","खे़ने़ॽनु इङ्‌गाॽ किसाङ्‌लो, थेआङ्‌भे़ल्‍ले़ खे़ने़ॽ के़जिःप्‍पा के़जोःक्॥ खे़ने़ॽ के़म्‍बिरुन्‍सिन्‍बान् के़नाःक्‍तुसिॽ, के़न्‍देःसुम्‍बान् के़सुप्‍सुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","हे़क्‍केःल्‍ले़ हाङ्‌ङिल्‍ले़ खे़न् सेवारोबान् मे़त्तु, “खे़ने़ॽ ताक्‍के़भे़ॽबा सेवारोबे! आल्‍ल बा खे़ने़ॽ के़बाःन्‍नोलाम् आप्‍तिक् कुःत्‍ने़ॽरो॥ इङ्‌गाॽ थे मे़बिरुङ्‌ङिन् बा खे़न् नाःक्‍तुङ्, थे़मा मे़देःसुङ्‌ङिन् खे़न् सुप्‍सुङ् फाॽआङ् खे़ने़ॽए निङ्‌वाॽ के़गत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","हे़क्‍केःल्‍ले़ खे़न् आयाङ्‌ङिन् थेआङ् सिङ्‌नाःत् के़गे़बाहाॽरो के़न्‌युक्‍खुन्? इङ्‌गाॽ त्‍याङ्‌ङिल्‍ले़ आयाङ्‌ङिल्‍ले़ कुस्‍साग खोःसुङ्‌बा वये़॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","खे़न् हाङ्‌ङिल्‍ले़ खे़प्‍मो के़ये़प्‍पाहाॽ मे़त्तुसि, “खे़ल्‍ले़ कत्तुबा याङ्‌इत्‍छिःन्‌नाप्‍ते़म्‍मे़ॽआङ् थिबोःङ् याङ्‌इत्‍छि के़गप्‍पे़न्‌पिरे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुने़ॽ मे़मे़त्तु, “आदाङ्‌बे, खे़ल्‍ले़ग आन्‍दे़ःन्‍छा थिबोःङ् याङ् कत्तुङ्‌ग!” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","हे़क्‍केःल्‍ले़ हाङ्‌ङिल्‍ले़ नोगप् पिरुसि, “खे़प्‍से़म्‍मे़ॽओ, के़गप्‍पाल्‍ले़ आल्‍लसाङ् यरिक् खोःसुॽरो, कर हाःत्‍ले़ मे़गत्तुन्, खे़ल्‍ले़ कत्तुबान्‍नाङ् नाप्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","आल्‍ल इङ्‌गाॽ खुनिॽ सम्‍दाङ् हाङ् चोगुङ्‌नि फाॽआङ् खुनिॽ सिराॽ मे़न्‍धाङ्‌मनाबा आनिङ्‌मिहाॽ कप्‍मो तारे़म्‍सिम्‍मे़ॽआङ् इङ्‌गाॽ आदगिए से़रे़म्‍सिम्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","हे़क्‍क्‍याङ् ये़सुरे़ हे़क्‍के पाःत्तु सुरुआङ् यरुसले़म ले़प्‍माङ् कुहुॽसाम्‍बाहाॽरे़ खुनिॽ तगि तगि थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","हे़क्‍क्‍याङ् खुने़ॽ बे़थफागे नु बे़थानि पाङ्‌जुम्‍हाॽरे़ निःत्ताङ् के़रे़ल्‍ले़ जैतुन कोःक्‍माओ ने़प्‍फु कुहुॽसाम्‍बाहाॽ उःत्तुसिआङ् अक्‍खे मे़त्तुसिर पाङ्‌घुसि, ");
INSERT INTO lifNT2_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“खिन्‍छिॽ तगाङ्‌बा पाङ्‌भेॽओ पेसे़ॽ॥ खे़प्‍मो के़लाःत्‍छिल्‍ले़ आप्‍फाल्‍ले़आङ् मे़न्‌युक्‍के के़वाॽबा अदङ्‌साधिक् इमे़घेःक्‍खुआङ् ये़प्‍पा के़दुम्‍सुॽ॥ खे़न् ले़रे़त्‍छे़ॽआङ् कत्‍ना फे़त्ते़त्‍छे़ॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","मनाहाॽरे़ थेआङ् कन् अदङ्‌साःन् के़ले़त्‍छुबाबे फाॽआङ् सेःन्‍गे़म्‍लाप्‍सिने़ फाॽग्र कङ्‌ग दाङ्‌बान् चाहाबा चोगे़आङ् वाॽ फाॽआङ् मे़त्ते़से़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ पेसिल्‍ले़ ये़सुरे़ पाःत्तुबा हे़क्‍के से़क्‍खाए अदङ्‌साःन् निःसे़त्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खे़न् ले़रे़त्‍छुर पत्‍छे़त्‍छिल्‍ले़ खे़प्‍मो कुन्‍दाङ्‌बाहाॽ मे़द्‌ये़आङ् सेःन्‍मे़दोसुसि, “थेआङ् कन् अदङ्‌साःन् के़ले़त्‍छुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ नोगप् पिरे़त्‍छु, “कङ्‌ग दाङ्‌बान् चाहाबा चोगे़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खे़न् अदङ्‌साःन् ये़सुरो तारे़त्‍छुआङ् अदङ्‌साःल्‍ले़ कुएःक्‍को खुनिॽ तेःत्‍हाॽ मे़भे़सु, हे़क्‍क्‍याङ् ये़सुःन् खे़न् सम्‍दाङ् मे़युक्‍खुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","खे़न् युक्‍तुआङ् पेःल्‍ले़ मनाहाॽरे़ खुनिॽ तेःत्‍हाॽ लाम्‍मो मे़भे़सुर खुने़ॽ लाङ्‌दाःक्‍मा मे़बिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","हे़क्‍क्‍याङ् ये़सुःन् जैतुन कोःक्‍माओलाम् सङ्‌माङ् थाःमा के़बोःङ्‌बा ते़न्‍नो के़प्‍मा इःत्ते़आङ् वये़ल्‍ले़ यरिक् कुहुॽसाम्‍बाहाॽरे़ निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ मे़निःसुबान्‌मे़इःत्तुआङ् मे़सःत्ते़र यम्‍बा इक्‍लाओ अक्‍खेलॽरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःमा मे़हेःक्‍तु– ");
INSERT INTO lifNT2_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“यहवे दाङ्‌बाल्‍ले़ कुमिङ्‌ङो के़दाःबा हाङ्‌ङिन् मुॽइसाबा पोःङ्‌लरो॥ साङ्‌ग्राम्‍पेदाङ्‌ङो सनारुङ् पोःङ्‌लरो, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमिमिदिङ् पोःङ्‌लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","कर खे़प्‍मो मनालुम्‍मो के़वाॽबा कुभा फरिसिहाॽरे़ ये़सुःन् मे़मे़त्तु, “सिक्‍साम्‍बे, खे़ने़ॽ के़हुॽसाम्‍बाहाॽ हे़क्‍के मे़बाःत्ते़म्‍मिन्‍ने़ॽ फाॽआङ् फे़ःक्‍ते़से़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खे़प्‍से़म्‍मे़ॽओ, खे़ङ्‌हाॽ स्‍वाःत् मे़युङ्‌ङिल्‍ले़ग कन् लुङ्‌हाॽआङ् मे़सःत्ताङ् मे़बाःत् मे़लःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","कर ये़सुःन् यरुसले़म ये़क्‌यक्‍किल्‍ले़ कुबेसाङ् के़रे़ल्‍ले़ खे़न् ये़क्‌यक्‍किन् ओमे़त्तुआङ् हाबे़, हे़क्‍क्‍याङ्‌अक्‍खे पाःत्तु, ");
INSERT INTO lifNT2_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“आल्‍ल खिनिॽग सनारुङ् खोःमा माराम्‍मिन् कुसिङ् के़निःत्तुम्‍मिल्‍ले़ पोःक्‍खे़बारो, कर कन् के़रे़क्‍ग के़मिक्‍साओलाम् थेःक्‍सिङ्‌बेआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","आल्‍ल के़निङ्‌मिहाॽरे़ खे़ने़ॽ काक् पिसाङ्‌लाम् के़म्‍गप्‍पाङ् खिरि के़म्‍धेःक्‍काङ् चिहुॽ के़म्‍हुॽबा ये़म् तार पत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","खे़ने़ॽ के़म्‌य के़म्‍लुःन्‍नाङ् के़स्‍साःहाॽनु खाम्‍मो के़म्‍दङ्‌लो॥ थिक् लुङ् सम्‍दाङ् वेॽ लुङ्‌ङिन्‍ने पक्‍मे़न्‍धने़न्, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिन् खे़ने़ॽ के़से़ःप्‍से़ ये़बा सुये़म्‍मिन् के़नाॽरुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","46","हे़क्‍क्‍याङ् ये़सुःन् माङ्‌हिम्‍मो लाःसे़आङ् खे़प्‍मो ले़ङ्‌हङ्‌बाहाॽ अक्‍खे मे़त्तुसिर नाःप्‍मा लःप्‍मा हेःक्‍तुसि, “साम्‌योसाप्‍लाओ साप्‍ते़आङ् पत्, ‘इङ्‌गाॽ आहिम्‍मिङ्‌ग तुवा चोःक्‍मा हिम् पोःङ्,’ कर खिनिॽग फाःन्‍दाहाॽ चिङ्‌सिङ्‌मा ते़न् के़जोगुम्‍माङ् के़वयिॽरो!” ");
INSERT INTO lifNT2_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","हे़क्‍क्‍याङ् खुने़ॽ थिक्‌याःन्‍धक् माङ्‌हिम्‍मो निसाम् हुॽरुसिरो॥ कर तुम्निङ्‌वाॽफुसाम्‍बाहाॽ, साम्‌योथिम्‍साम्‍बाहाॽ नु लाम्‍लोःबाहाॽरे़ खुने़ॽ से़प्‍मा निङ्‌वाॽ मे़जोगु, ");
INSERT INTO lifNT2_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","कर आप्‍तिक् कुःप्‍मा पाःन् थेआङ् खे़ङ्‌हाॽरे़ मे़ङ्‌घोःसुन्, थेआङ्‌भे़ल्‍ले़ मनाहाॽरे़ग खुने़ॽ हुॽरुसिबा निसाम्‍हाॽ खुनिॽ सिराॽ थाङे़र मे़घे़प्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","थिक् ये़न् ये़सुरे़ माङ्‌हिम्‍मो निसाम् हुॽरुसिर सुनाइङ् इङ्‌भन् चोगुर यागे़॥ खे़प्‍मो तुम्निङ्‌वाॽफुसाम्‍बाहाॽ, साम्‌योथिम्‍साम्‍बाहाॽ हे़क्‍क्‍याङ् यहुदि तुम्‍लाम्‍लोःबाहाॽ मे़द्‌ये़आङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","खे़ङ्‌हाॽरे़ खुने़ॽ अक्‍खे मे़मे़त्तुर सेःन्‍मे़दोसु, “खे़ने़ॽ थे़मा युक्‍किल्‍ले़ अक्‍तङ्‌बा याःम्‍बक्‍हाॽ के़जोगुर के़वाॽ? कन् युक्‍किन् हाःत्‍ले़ के़बिरे़? आमे़त्ते़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ये़सुरे़आङ् खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽआङ् लत्‍छा सेःन्‍लाप्‍थिक् सेःन्‍दोःनिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","युहुन्‍नारे़ बप्‍तिस्‍मा पिमा कुयुक्‍किन् आत्तोलाम् त्‍ये़बाबे? निङ्‌वाॽफुमाङ्‌लाम् त्‍ये़बाबि, इ मनालाम्बि? आमे़त्ते़म्‍मे़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","खे़ङ्‌हाॽ खुनिॽ लुम्‍मो पाःन् मे़धक्‍ते़र अक्‍खे मे़मे़त्‍छिङ्, “आल्‍ल आनिॽ ‘निङ्‌वाॽफुमाङ्‌लाम्’ आमे़त्तुम्‍ने़ फाॽग्र, थेआङ् नसाःन् के़न्‍जोगुम्‍मिन् फाॽआङ् सेःन्‍आलाप्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","कर ‘मनाहाॽलाम्‌’ आमे़त्तुम्‍ने़ फाॽग्र, मनाहाॽरे़ आनिॽ लुङ्‌ङिल्‍ले़ आम्‍बःत्, थेआङ्‌भे़ल्‍ले़ मनाहाॽरे़ युहुन्‍नाःङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा फाॽआङ् निस्‍सेए मे़इःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ ये़सुःन् मे़मे़त्तु, “आनिगे़ मे़निःसुम्‍बे़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “हे़क्‍केने़ फाॽग्र थे़मा युक्‍किल्‍ले़ अक्‍तङ्‌बा याःम्‍बक्‍हाॽ चोगुङ् खे़न् इङ्‌गाॽआङ् मे़मे़त्‍निङ्‌ङिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ये़सुरे़ मनाहाॽ कन् खे़दाॽइन् मे़त्तुसि, “उन्‍छेःन् मनाधिक्‍ले़ लत्‍छा इक्‍को चे़ल्‍ले़क्‍सेॽ लेःत्तुआङ् कुभ्रे़ःङ् लक्‍को खे़न् चे़ल्‍ले़क्‍सेॽ इक्‍किन् इक्‍मसाबाहाॽ पिरुसिआङ् खुने़ॽ यरिक् ये़म् थारिक् वेॽ लाजेॽओ पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","हे़क्‍क्‍याङ् चे़ल्‍ले़क्‍सेॽ तुप्‍मा ये़म् त्‍ये़ःल्‍ले़ कुलक् लाःसे़ कुसेवारोबाधिक्‌इक्‍मःबाहाॽरो पाङ्‌घुरो॥ कर खे़न् इक्‍मसाबाहाॽरे़ खुने़ॽग मे़हिप्‍तुआङ् थेआङ् मे़म्‍बिए हाबा मे़बाङ्‌घु मे़देःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","हे़क्‍क्‍याङ् याम्‍मो निसिगेःक्‍पा सेवारोबान् लक् ताःक्‍से़ पाङ्‌घु, कर खे़न्‍नाङ् खे़न् इक्‍मसाबाहाॽरे़ मे़हिप्‍तुर कुजाःत्‍थि मे़देःसुआङ् कुघाले़म् मे़बाङ्‌घु मे़देःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","याम्‍मो आल्‍लसाङ् सुम्‍सिगेःक्‍पा कुसेवारोबान् लक् ताःक्‍से़ पाङ्‌घु, कर खे़न्‍नाङ् खे़न् इक्‍मसाबाहाॽरे़ मे़घाःन्‍दुआङ् मे़नाःत्तु मे़देःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","आल्‍ल चे़ल्‍ले़क्‍सेॽ इक्‍के़ल्‍ले़ कुन्‍दाङ्‌बान् निङ्‌वाॽ इःत्‍छिङ्‌, ‘इङ्‌गाॽ थे चोगुङ्‌बाबे? आल्‍ल इङ्‌गाॽ लुङ्‌माॽ तुक्‍तुङ्‌बा आस्‍साःन् पाङ्‌घुङ्‌॥ खुने़ॽ मे़निःसुआङ्‌ग कुना मे़साॽरुबिला॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","कर खे़न् इक्‍मसाबाहाॽरे़ खे़न् कुस्‍साःन् मे़निःसुआङ् इङ्‌मे़दङ्‌घु, ‘कन्‌कुम्‍बारे़ कुलक् के़घोःबारो, कन्‌से़रुम्‍माङ् कुलाजेॽ सिङ्‌बुङ्‌हाॽ आनिॽ हुक्‍काप्‍पासिरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खे़न् कुस्‍साःन् चे़ल्‍ले़क्‍सेॽ इक्‍कोलाम् लाःक्‍कात् मे़लःत्तु मे़देॽरुआङ् मे़से़रुरो॥” ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “आल्‍ल चे़ल्‍ले़क्‍सेॽ इक्‍के़ल्‍ले़ कुन्‍दाङ्‌बाल्‍ले़ खे़न् इक्‍मसाबाहाॽ आक्‍खे मे़त्तुसिॽबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","खुने़ॽ ताआङ् खे़ङ्‌हाॽ के़रे़क् से़रुसिआङ् खे़न् चे़ल्‍ले़क्‍सेॽ इक्‍किन् वेॽ मनाहाॽ पिरुसिॽरो॥” मनाहाॽरे़ खे़न् मे़घे़प्‍सुआङ् मे़बाःत्तु, “आप्‍फाल्‍ले़आङ् अक्‍खे मे़बोःङ्‌ङिल्‍लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ये़सुरे़ खे़ङ्‌हाॽ अदक्‍तक्‍काङ् ओमे़त्तुसिर याम्‍मो सेःन्‍दोसुसि, “हे़क्‍केने़ फाॽग्र कन् साम्‌योसाप्‍लाओ साप्‍ते़बान् थे़माबे? ‘लुङ् के़गाम्‍बाहाॽरे़ मे़नाॽरुबा लुङ्‌ङिन् कुम्‍मालुङ् पोःक्‍खे़आङ् वाॽरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","आत्तिन्‍हाॽ खे़न् लुङ् सम्‍दाङ् मक्‍मे़धाः, खे़ङ्‌हाॽ मे़भक् मे़सिःरो॥ हे़क्‍क्‍याङ् आत्तिन् सम्‍दाङ् खे़न् लुङ्‌ङिन् मक्‍था, खे़न् फे़क् सिःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","साम्‌योथिम्‍साम्‍बाहाॽ नु तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ ये़सुःन् बा खे़प्‍मोए ते़म्‍मा निङ्‌वाॽ मे़जोगु, थेआङ्‌भे़ल्‍ले़ ये़सुरे़ पाःत्तुबा खे़दाॽओ फे़न् इक्‍मसाबाहाॽनु तङ्‌घुसिबान्‌खे़ङ्‌हाॽरे़ निङ्‌वाॽ मे़घोःसु, कर मनाहाॽ मे़गिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ ये़सुःन् ते़म्‍मा फाॽआङ् सुये़म् कोःप्‍मा मे़हेःक्‍तु॥ खे़ङ्‌हाॽरे़ मनाहाॽ याङ् मे़बिरुसिआङ् साम्‌योनिबा मे़ले़ङ्‌सिङ्‌ङाङ् ये़सुरे़ कुधोःम्‍से़ मे़बाङ्‌घुसि॥ खे़ङ्‌हाॽरे़ कुबाःन्‍नो ते़म्‍माआङ् रोमि युक्‍साबाहाॽ नु सुहाङ्‌गे़म्‍बाहाॽ पिमासि के़लॽबा निङ्‌वाॽ मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","खे़ङ्‌हाॽरे़ ये़सुःन् कुबाःन्‍नो थाःमा फाॽआङ् सेःन्‍मे़दोसु, “सिक्‍साम्‍बे, से़क्‍खासाङ् खे़ने़ॽग कुदोःप्‍मा पाःन्‍लक् के़बाःत्तुॽ, हे़क्‍क्‍याङ् कुदोःप्‍मारक्‌के़हुॽरुसिॽ॥ खे़ने़ॽग आत्तिन् मनाहाॽआङ् के़न्‍छे़न्‍दुन्‍छिन्, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुलाम्‍मिन् से़क्‍खाए के़हुॽरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","हे़क्‍केःल्‍ले़ कन्‌पाःन्‍निन् आमे़त्ते़ॽ–रोमि पयम् हाङ् सिजरे़न् एःङ्‌याङ् हुङ्‌मा आनिॽ साम्‌योथिम्‍मिल्‍ले़ आबिॽबि आम्‍बिने़न्बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ये़सुरे़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ चिःप्‍मान् निःसुआङ् खे़ङ्‌हाॽ नोगप् पिरुसि, ");
INSERT INTO lifNT2_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“इङ्‌गाॽ याङ्‌इत्‍छिःन्‌ओसेःन्‍आधाक्‍ते़म्‍मे़ॽ॥ कप्‍मो हाःत्‍ले़ कुइत्‍छाप् नु कुबाःन्‍साप् पप्‍पे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “सिजरे़ल्‍ले़न्‌पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ये़सुरे़ मे़त्तुसि, “हे़क्‍केने़ फाॽग्र सिजरले़ कुबाःन्‍हाॽ सिजरे़न् पिरे़म्‍मे़ॽ, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुबाःन्‍हाॽ निङ्‌वाॽफुमाङ्‌ङिन्‍ने पिरे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","मना तगि खे़ङ्‌हाॽरे़ खुने़ॽ कुबाःन्‍नो ते़म्‍मा मे़न्‍छुक्‍तुन्‌॥ ये़सुरे़ पिरुसिबा नोगप्‍पिल्‍ले़ खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ मये़आङ् स्‍वाःत् मे़युङे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","हे़क्‍क्‍याङ् सिःमे़न्‍लाम् याम्‍मो हिङ्‌मन् होःप्‌लॽरिक् नसाःन् के़जोःक्‍पा कुभा सदुकिहाॽ ये़सुरो मे़द्‌ये़आङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","सेःन्‍मे़दोसु, “सिक्‍साम्‍बे, मोसारे़ग अक्‍खेलॽरिक् साप्‍तु आबिरे़आङ् पत्‌–‘आत्तिल्‍ले़ कुम्‍भुॽइन् कुस्‍साः कुए मे़न्‌वाॽए सिःॽ, खे़ल्‍ले़ कुन्‍साॽरे़ मेमेदुमा कुन्‍ने़ॽद्रेमान्‍नु मेःक्‍खिम् चोःक्‍माए पोःङ्॥ हे़क्‍क्‍याङ् कुम्‍भुॽरे़ कुलागि सागप्‍मा पोःङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","आल्‍ल नुसि फुॽनुसाॽहाॽ मे़वये़॥ तुम्‍बाल्‍ले़ मेःक्‍खिम् चोगुआङ् कुस्‍साः कुए मे़न्‌वाॽए स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","हे़क्‍केलॽरिक् सरुम्‍बान् नु याङ्‌सरुम्‍बाल्‍ले़आङ् खुन्‍छिॽ ने़ॽद्रेमान्‍नु मेःक्‍खिम् चोगे़त्‍छु, हे़क्‍क्‍याङ् खुन्‍छिॽ हे़क्‍केए के़रे़क् नुसि फुॽनुसाॽहाॽरे़ खुनिॽ ने़ॽद्रेमान्‍नु मेःक्‍खिम् मे़जोगुआङ् सामे़न्‌वाॽए मे़स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","के़रे़क्‍नुःल्‍ले़ एगाङ् खे़ङ्‌हाॽरे़ खुनिॽ ने़ॽद्रेमान्‍नाङ् स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","आल्‍ल खे़ङ्‌हाॽ सिःमे़न्‍लाम् याम्‍मो मे़हिङ्‌ङिल्‍ले़ आत्तिल्‍ले़ कुमेःत् पोःङ्‌बाबे? खे़न्‍नुग नुसि फुॽनुसाॽहाॽरे़ए मेःक्‍खिम् मे़जोगुआङ् मे़वये़॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “कन् इक्‍सादिङ् खाम्‍बेःक्‍मोबा मनाहाॽ कप्‍मोरक् मेःक्‍खिम् मे़जोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","कर ताःन्‍दि के़दाःबा ये़म्‍मोग हे़क्‍के मे़बोःङ्‌ने़ल्‍लो, थेआङ्‌भे़ल्‍ले़ सिःमे़न्‍लाम् याम्‍मो हिङ्‌मा लाॽरुसिबा मनाहाॽ मेःक्‍खिम् मे़न्‍जोःक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","खे़ङ्‌हाॽग याम्‍मो मे़न्‍छिःने़न्, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ माङ्‌लाइङ्‌बा कुइसिःक् मे़बोःङ्‌लो॥ खे़ङ्‌हाॽ सिःमे़न्‍लाम् याम्‍मो मे़हिङे़बाल्‍ले़ चोगुल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुस्‍साःसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","हे़क्‍केलॽरिक् के़सिःबाहाॽ मे़हिङ् के़लॽबा पाःन्‍निन् मि के़दिःप्‍पा पोःक्‍लाओबा हिन्‍दोःक्‍को मोसारे़ ओसेःन्‍आधाक्‍लो॥ मोसारे़ अब्राहाम, इसहाक नु याकुबरे़ खुनिॽ निङ्‌वाॽफुमाङ्‌ङिन् यहवे दाङ्‌बाए लॽरिक् पाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","खे़ल्‍ले़ चोगुल्‍ले़ खुने़ॽग कुसिवे़त्‍हाॽरे़न् मे़ःन्, कर कुहिङ्‌वे़त्‍हाॽरे़ खुनिॽ निङ्‌वाॽफुमाङ्‌लो, थेआङ्‌भे़ल्‍ले़ खुने़ॽ कुलागिग के़रे़क् कुहिङ्‌वे़त्ते मे़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","हे़क्‍क्‍याङ् कुभा साम्‌योथिम्‍साम्‍बाहाॽरे़ खुने़ॽ मे़मे़त्तु, “सिक्‍साम्‍बे, खे़ने़ॽग साॽरिक् नुःरिक्‍काङ् याप्‍मि के़मे़त्ते़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","हे़क्‍क्‍याङ् आत्तिन्‍हाॽरे़आङ्‌खुने़ॽ पाःन् सेःन्‍दोःमा आःन्‍छिङ्‌माआङ्‌मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आक्‍खेलॽरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌दाउद हाङ्‌ङिल्‍ले़ कुस्‍साःरो फाॽआङ् मे़मे़त्तुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुसाम्‍लो सुम्‍मो दाउदरे़ आबाङे अक्‍खे पाःत्तुआङ् पत्, “यहवे दाङ्‌बाल्‍ले़ इङ्‌गाॽ आदाङ्‌बान् अक्‍खे मे़त्तु, ‘के़निङ्‌मिहाॽ के़युक्‍को इङ्‌गाॽ मे़न्‍दाःत्‍छिङ्‌ङे थारिक् आजुप्‍साङ् ले़प्‍माङ् खे़ने़ॽ युङे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","दाउद हाङ्‌ङिल्‍ले़ए खुने़ॽ आदाङ्‌बे लॽरिक् मे़त्तुने़ फाॽग्र आक्‍खेलॽरिक् ख्रिस्‍ते़न्‌दाउदरे़ कुस्‍साः पोःङ्‌बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","हे़क्‍क्‍याङ् के़रे़क् मनाहाॽरे़ मे़घे़प्‍सुर कुहुॽसाम्‍बाहाॽ अक्‍खे मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“साम्‌योथिम्‍साम्‍बाहाॽनु सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ! खे़ङ्‌हाॽ केःम्‍ब्‌केःम्‍बा लगेप् मे़जाक्‍खुआङ् नानुगत्‍ना लाङ्‌मे़घेःक्‍लो, हे़क्‍क्‍याङ् पाङ्‌जुम् लुम्‍मो सेवा मे़मे़त्तिगे़र के़लॽबा निङ्‌वाॽ मे़जोगुआङ् यहुदि चुम्‍लुङ्‌हिम्‍मो नु साभाङ्‌जाओ तुम्‍म्‍याङ्‌हाङ् युक्‍नाहाॽओ युङ्‌मा खुनिॽ सिराॽ थाङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","खे़ङ्‌हाॽरे़ मेमेदुमाहाॽ इङ्‌मे़ले़क्‍तुसिआङ्‌खुनिॽ हिम्‍धाःङ्‌हाॽ मे़लरुरो, कर नुःबा ओसेःन्‍धाक्‍सिङ्‌मारे़ लागि केःम्‍ब्‌केःम्‍बा तुवा मे़जोगुॽ॥ खे़ङ्‌हाॽरे़ग से़क्‍खाए साक्‍ल खुम्‍दिङ् मे़घोःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ये़सुरे़ माङ्‌हिम्‍मो हुक्‍सोयाङ् तोःम्‍मादे़न्‍नो याङ्‌साकुन्‍धेसाबाहाॽरे़ खुनिॽ हुक्‍सोयाङ्‌ङिन् मे़गेःत्तुर मे़बत्‍छे़बान् ओमे़त्तुसिर युङे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","खे़प्‍मो लत्‍छा याङ्‌गे़साॽमा मेमेदुमाधिक्‍ले़ याङ् ने़त्‍छि केःत्तुबा निःसुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","पाःत्तु, “से़क्‍खाए कन् याङ्‌गे़साॽमा मेमेदुमाल्‍ले़ वेॽहाॽनुःल्‍ले़ यरिक् हुक्‍सोयाङ् केःत्तुआङ् वाॽरो, ");
INSERT INTO lifNT2_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","थेआङ्‌भे़ल्‍ले़ कन् याङ्‌साकुन्‍धेसाबाहाॽरे़ग खुनिॽ के़योबाआङ्‌के़नम्‍बा याङ्‌हाॽए मे़याक्‍तु, कर याङ्‌गे़साॽमा मेमेदुमाल्‍ले़ग खुने़ॽ कुयाङ्‌साॽमो कत्तुबा चामा थुङ्‌मालाम् याक्‍तुआङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","हे़क्‍क्‍याङ् कुभा हुॽसाम्‍बाहाॽरे़ माङ्‌हिम्‍मिल्‍ले़ कुयाःम्‍बेओ खे़न् नुःब्‌नुःबा लुङ्‌हाॽ नु मनाहाॽरे़ निङ्‌वाॽफुमाङ्‌ङो मे़दोःन्‍दुबा के़घे़म्‍बा के़लाॽबा पाःन्‍हाॽरे़ कुयाःम्‍बेओ मे़बाःत्तुरो॥ हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“खिनिॽ आल्‍लो के़निःसुम्‍बान् थिक् लुङ्‌सम्‍दाङ् वेॽ लुङ्‌धिक्‍काङ् मे़न्‍ने़ए यःमा ये़म् तार पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ये़सुःन् सेःन्‍मे़दोसु, “सिक्‍साम्‍बे, कन् आप्‍फाल्‍ले़ पोःङ्‌बाबे? कन् पोःङ्‌मानुःल्‍ले़ तगि थे मिक्‍सेःन् पोःङ्‌बे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ, आत्तिल्‍ले़आङ् खिनिॽ इङ्‌गे़न्‍ले़क्‍तिल्‍लरो, थेआङ्‌भे़ल्‍ले़ यरिक् मनाहाॽ इङ्‌गाॽ आमिङ्‌ङो निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌इङ्‌गाॽएरो, हे़क्‍क्‍याङ् आल्‍लो ये़म्‍मिन् त्‍ये़आङ् वाॽ फाॽआङ् मे़बाःत्तुॽ, कर खे़ङ्‌हाॽरे़ खुनिॽ पाःन्‍निन् मे़घे़प्‍से़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","हे़क्‍क्‍याङ् खिनिॽ थङ्‌हाॽ नु के़जिहाॽरे़ कुयाःम्‍बेओ के़घे़प्‍सुम्, कर निङ्‌वाॽ मे़मये़म्‍मिन्‍ने़ॽओ॥ कङ्‌हाॽग पोःङ्‌माए पोःङ्, कर बा खे़न् ये़म्‍मोएग इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुनुप्‍मान् मे़दाने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “मे़न्‍छाम् सुवाङ्‌हाॽ नु लाजेॽहाॽ लुम्‍मो थङ् पोःक्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","हे़क्‍क्‍याङ् यरिक् ते़न्‍नो पयम् यम्‍बा लुप्‍लि थाङ्, यम्‍बा साक् पोःक् हे़क्‍क्‍याङ् यम्‍बा मिन्‍देॽहाॽ पोःक्‍काङ् किप्‍मा के़घुःबा नु निङ्‌वाॽ के़माबा मिक्‍सेःन्‍हाॽ ताङ्‌साक्‍पो मे़धाःप्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","कन् पोःङ्‌मानुःल्‍ले़ तगिग खिनिॽ हुक् के़म्‌याक्‍तिआङ् निङ्‌घुम् के़म्‍मे़त्तिॽरो॥ हे़क्‍क्‍याङ् यहुदि चुम्‍लुङ्‌हिम्‍मो खासे़न् के़म्‍लोःन्‍दिआङ् पुङ्‌लाहिम्‍मो के़म्‍धे़क्‍तिॽरो॥ आमिङ्‌ङिल्‍ले़ चोगुल्‍ले़ हाङ्‌हाॽ नु सुहाङ्‌गे़म्‍बाहाॽरे़ खुनिॽ तगि के़म्‌ये़प्‍सिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","कङ्‌ग इङ्‌गाॽ आयाःम्‍बेओ पाःप्‍मा के़घोःसुम्‍बा सुये़म्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","हे़क्‍क्‍याङ् खिनिॽ से़ःप्‍सिङ्‌मारे़ लागि थे़मा पाःप्‍माबे फाॽआङ् तगिसा निङ्‌साम्‍मो मे़ध्‍ये़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ खिनिॽ पाःप्‍मा के़बोःङ्‌बा सुत्‍लाहाॽ नु सिक्‍कुम्‍दिङ् निङ्‌वाॽ पिनिङ्‌लो॥ हे़क्‍केःल्‍ले़ आत्तिन्‍नाङ् खिनिॽ बिफ्‍युङ्‌हाॽरे़ अप्‍मा नु पाःन्‍धक्‍मा मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","खिनिॽ पा-माहाॽ, फुॽनुसाॽहाॽ, काॽइ सोॽधोःक्‍हाॽ नु तेःङ्‌जुम्‍हाॽरे़ इङ्‌गे़म्‍ले़क्‍तिआङ्‌ते़म्‍मा के़म्‍बाङ्‌घिॽरो॥ खे़ङ्‌हाॽरे़ खिनिॽ कुभाग के़म्‍से़रिॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","खिनिॽ याप्‍मि नसाःन् के़जोगिबाल्‍ले़ के़रे़क् मनाहाॽरे़ खिनिॽ के़म्‍जिःत्तिॽ, ");
INSERT INTO lifNT2_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","हे़क्‍केसाङ् खिनिॽ थे़गेःक्‍इधिक्‍काङ् मक्‍मे़धाने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","खिनिॽ कन् के़रे़क् पाःन्‍हाॽ के़धरुम्‍मिल्‍ले़ए खिनिॽ हिङ्‌मन्‍निन्‌ताङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","आल्‍ल यरुसले़म्‍मिन् निङ्‌मि थक्‍सुबाहाॽरे़ मे़गबुबा के़निःसुम्‍मिल्‍ले़ आल्‍ल कुमे़क्‍मान् निःत्ताङ्‌ङे वाॽ फाॽआङ् कुसिङ् निःत्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","हे़क्‍क्‍याङ् यहुदियाबा मनाहाॽ कोःक्‍मा फाङ्‌जङ् हे़ङ्‌घाःत्ति मे़घे़त्‍छिङ् मे़बेःक्‍ल, ये़क्‌यक्‍को के़वाॽबाहाॽ लाःक्‍कात् मे़घे़त्‍छिङ् मे़बेःक्‍ल, हे़क्‍क्‍याङ् पाङ्‌भेॽओ के़युङ्‌बाहाॽ याम्‍मो ये़क्‌यक्‍को मे़न्‍दाने़न्‍लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","थेआङ्‌भे़ल्‍ले़ साम्‌यो साप्‍लाओ कन् साप्‍ते़आङ् पप्‍पा पाःन्‍निन् के़त्‍ल फाॽआङ् कङ्‌ग खुम्‍दिङ्ले़न्‌ये़न्‍हाॽ पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","कन् ये़म्‍मिङ्‌ग मे़न्‍छुक्‍मा के़वाॽमा नु सावामाहाॽरे़ लागि आक्‍खे़न् किप्‍मा के़घुःबा पोःङ्‌ङि! इक्‍सादिङ्‌खाम्‍बेःक्‍मो यम्‍बा तुक्‍खे थाःरो, हे़क्‍क्‍याङ्‌निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुघुम्‍दिङ्‌ङिन् कन्‌मनाहाॽओ चुक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","खे़ङ्‌हाॽ ताभेःल्‍ले़ मे़जे़प्‍तु मे़से़रुसिॽ हे़क्‍क्‍याङ् यरिक् लाजेॽओ पुङ्‌लाधाबा मे़बोःङ्‌ङाङ् मे़बेःक्‍लो॥ थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ खुनिॽ ये़म् मे़ङ्‌गे़त्ते थारिक् खे़ङ्‌हाॽरे़ यरुसले़म्‍मिन् मे़दोॽरु मे़सॽरुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“हे़क्‍क्‍याङ् नाम्, लाबा नु खेःम्‍सिक्‍हाॽओ यम्‍बा मिक्‍सेःन्‍हाॽ मे़धाःप्‍लो॥ हे़क्‍क्‍याङ् वाहङ्‌ङिल्‍ले़ कुसःक्‍मान् नु यम्‍ब्‌यम्‍बा वाभे़ल्‍ले़ङ्‌ङिल्‍ले़ चोगुल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मोबा मे़न्‍छाम् सुवाङ्‌हाॽ साॽरिक् किःमाओ नु निङ्‌साम्‍मो मे़धाःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","आल्‍ल इक्‍सादिङ् खाम्‍बेःक्‍मो के़दाःबार के़बप्‍पा इनोगे़न् तुक्‍खेःन् मे़इःत्तुआङ् मनाहाॽ खुनिॽ साम् मिक्‍किल्‍ले़ पक्‍थसि, थेआङ्‌भे़ल्‍ले़ ताङ्‌साक्‍पोबा मुक्‍साम्‍हाॽ नु खेःम्‍सिक्‍हाॽ मे़यङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","हे़क्‍क्‍याङ् मे़न्‍छाम्‍साःन् खाप्‍मिःत्तो यम्‍बा मुक्‍साम् हे़क्‍क्‍याङ् मिमिदिङ्‌नु युःर पप्‍पा मे़न्‍छाम् याप्‍मिहाॽरे़ मे़निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","आल्‍ल कन् के़रे़क् पोःङ्‌ङिल्‍ले़ खिनिॽ थे़गेःक्‍पे़न्‌फोःक्‍खे़म्‍मे़ॽआङ् थाःङ् ओमये़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ खिनिॽ से़न्‍लप्‍पिन् निःत्ताङ् तार पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ कन् खे़दाॽइन् मे़त्तुसि, “आल्‍ल पःत्‍छेॽबुङ्‌मान् नु वेॽ सिङ्‌बुङ्‌हाॽ ओमे़त्ते़म्‍मे़ॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","आल्‍ल कुसङ् कुभे़क्‌वा लःन्‍निल्‍ले़ हाङ्‌वाःम्‍मा ये़म्‍मिन् निःत्ताङ् तार पत् फाॽआङ् खिनिॽ कुसिङ्‌के़निःत्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","हे़क्‍केलॽरिक्‍के इङ्‌गाॽ पाःत्तुङ्‌बा कन् काक् पाःन्‍हाॽ के़त्‍ल पेःक्‍पा के़निःसुम्‍मिल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् निःत्ताङ् वाॽ फाॽआङ् कुसिङ्‌के़निःत्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, कन् के़रे़क् पाःन्‍हाॽ मे़म्‍बोःङ्‌ङे थारिक् कन् मे़न्‍छाम् थाःक्‍हाॽ मे़न्‍छिःने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ताङ्‌साक्‍पान् नु खाम्‍बेःक्‍मान् ले़क्‍काङ् पेःक्, कर इङ्‌गाॽ आबाःन्‍जाक्‍हाॽ आप्‍फाल्‍ले़आङ् मे़ले़क्‍ने़न् मे़बेःक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","खिनिॽ याम्‍दादा सुक्‍खेवा नु चामा थुङ्‌मा हे़क्‍क्‍याङ् कन् हिङ्‌मन्‍ले़न् निङ्‌साम् चोःक्‍मो सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ, मे़ःन्‍ने़ फाॽग्र हक्‍चघत् थक्‍सा पुसा इजोओ मे़धाःबा हे़क्‍के कन् ये़न्‍हाॽओ खिनिॽआङ् के़ध्‍ये़ॽइरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","थेआङ्‌भे़ल्‍ले़ कन् इक्‍सादिङ् खाम्‍बेःक्‍मो के़वाॽबा मनाहाॽनुआङ् हे़क्‍केलॽरिक्‍के पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","के़रे़क् ये़म्‍मो आप्‍फाल्‍ले़साङ् कन् के़दाःबा पाःन्‍नोलाम् खे़त्‍छिङ्‌मा पेःक्‍मा मुक्‍साम् के़घोःसुम्‍ल हे़क्‍क्‍याङ् मे़न्‍छाम्‍साःल्‍ले़ कुदगि ये़प्‍मा के़सुक्‍पा के़बोःक्‍खिर फाॽआङ् सिङ्‌सिङ् लॽरे़म्‍मे़ॽर तुवा चोगे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","हे़क्‍क्‍याङ् ये़सुरे़ थिक्‌याःन्‍धक् माङ्‌हिम्‍मो हुॽरुसिर वये़, कर से़न्‍दिक् याङ्‌धोःक्‍से़ जैतुन कोःक्‍माओ पेर वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","हे़क्‍क्‍याङ् तानाम्‍सा माङ्‌हिम्‍मो खुने़ॽ कुबाःन्‍जाक् खे़म्‍से़ मनाहाॽ मे़द्‌ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","आल्‍ल सिदाॽ मे़म्‍भःन्‍नेबा खरे़ःङ्‌ङिल्‍ले़ तङ्‌नाम्‍मिन् निःत्ताङ् त्‍ये़र पत्‍छे़॥ खे़न् यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍माङ् मे़मे़त्तुॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","हे़क्‍क्‍याङ् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽरे़ ये़सुःन् से़प्‍मा सुये़म् मे़गोःत्तुर मे़वये़, कर मनाहाॽरे़ हयङ्‌किल्‍लिङ् मे़जोगुॽ फाॽआङ् मे़गिसे़बाल्‍ले़ चोगुल्‍ले़ स्‍वाःत्ताङ् से़प्‍मा निङ्‌वाॽ मे़जोगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","हे़क्‍क्‍याङ् माफे़न्‍साम्‍मिन् थिक्-ने़त् (१२) हुॽसाम्‍बाहाॽओ यहुदा इस्‍करियोत मे़प्‍मनाबाल्‍ले़ कुनिङ्‌वाॽओ लाःसे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","हे़क्‍क्‍याङ् खुने़ॽ तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु माङ्‌हिम् के़गोःबाहाॽरे़ खुनिॽ थक्‍तुम्‍बाहाॽरो पेआङ् ये़सुःन् खिनिॽ हुक्‍को थाःमा सुक्‍तुङ् फाॽआङ् चे़क्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ साॽरिक् मे़सःत्ते़र हे़क्‍के के़जोगुल्‍ले़ खे़ने़ॽ याङ् पिआसिगे़ॽरो लॽरिक् मे़मे़त्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","खुने़ॽआङ् खे़न् पाःन्‍नो ते़न्‍दे़आङ् मनाहाॽ मे़होःप्‍पिल्‍ले़ इङ्‌ले़क्‍माआङ्‌ते़म्‍मा पाङ्‌मासि फाॽआङ् सुये़म् कोःप्‍मा हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","हे़क्‍क्‍याङ् सिदाॽ मे़न्‍भःन्‍नेबा खरे़ःङ् चामा तङ्‌नाम्‍मिल्‍ले़ थिक्‍सिगेःक्‍पा ये़न्‍नो चोःक्‌युम्‍भो तङ्‌नाम्‌रे़न्‌मे़ल्‍लुक्‍साःन् सिदुङ्‌जभा चोःक्‍मा थिम् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","हे़क्‍केःल्‍ले़ ये़सुरे़ पत्रुस नु युहुन्‍नाःन् अक्‍खे मे़त्तुसिर पाङ्‌घुसि, “खिन्‍छिॽ पेगे़त्‍छे़ॽआङ् आनिॽ लागि यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‌रे़न्‌चामा थुङ्‌मा यारिप् चोगे़त्‍छे़ॽओ॥ हे़क्‍केलॽरिक्‍के आनिॽ सोरिक् चाम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ सेःन्‍दोःसे़त्‍छु, “हे़क्‍केःल्‍ले़ आत्तान् पेःक्‍माआङ् यारिप् चोःक्‍माबे?” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “आल्‍ल ओमे़त्ते़त्‍छे़ॽओ, खिन्‍छिॽ ये़क्‌यक्‍को के़लाःत्‍छिर के़बत्‍छिल्‍ले़ च्‍वाःत् कुःन्‍दा के़बङ्‌बा मनाधिक्‍ले़ के़दुम्‍सिॽ॥ खे़न् लाःप्‍पा हिम्‍मो थारिक् तिम्‍दे़त्‍छे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","हे़क्‍क्‍याङ् हिम्‍दाङ्‌बान् मे़त्ते़छे़ॽ, “आनिगे़ सिक्‍साम्‍बाल्‍ले़ खे़ने़ॽ अक्‍खे के़मे़त्ते़आङ् के़वाॽरो, ‘तरे युङ्‌मा याक्‍फाङ्‌ङिन् आत्तो ने़बे? खे़प्‍मो इङ्‌गाॽ आहुॽसाम्‍बाहाॽनु यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‌रे़न्‌चामा थुङ्‌मान्‌चाङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","हे़क्‍क्‍याङ् खे़ल्‍ले़ खिन्‍छिॽ थोःस्‍मा खाम्‍लोओ यारिप् चोःक्‍मनाबा लत्‍छा यम्‍बा याक्‍फाङ्‌ङिन् ओसेःन्‍गे़धाक्‍सिॽ॥ खे़प्‍मोए आनिॽ चामा थुङ्‌मान्‌यारिप् चोगे़त्‍छे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ पेसे़त्‍छिल्‍ले़ ये़सुरे़ पाःत्तुबा हे़क्‍केए तुमे़त्‍छुआङ् खे़ङ्‌हाॽरे़ यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‌रे़न्‌चामा थुङ्‌मान्‌यारिप् चोगे़त्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","आल्‍ल चाजामा ये़म् पोःक्‍खे़आङ् ये़सुःन् कुसेःक्‌युक्‍मिबाहाॽनु चामा ते़न्‍नो युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ तुक्‍खे चामानुःल्‍ले़ तगि कन् यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍बा साभाङ्‌जाःन्‌खिनिॽनु सोरिक् चामा साॽरिक् निङ्‌वाॽ चोगुङ्‌ङाङ् वयाङ्, ");
INSERT INTO lifNT2_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुहाङ्‌जुम्‍मो कन् आजाम्‍ल आबप्‍पा चोःक्‌युम्‍भो तङ्‌नाम्‍बा साभाङ्‌जाःल्‍ले़ कुबेःन् मे़ङ्‌गे़त्ते थारिक् इङ्‌गाॽ याम्‍मो मे़जाआन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","हे़क्‍क्‍याङ् ये़सुरे़ चल्‍लङ्‌ना खोर्याःन् खप्‍सुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरुर अक्‍खे पाःत्तु, “कन् ताःक्‍ते़म्‍मे़ॽआङ् खिनिॽ लुम्‍मो हाःत्तासिम्‍मे़र चे़म्‍मे़ थुङे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","खिनिॽ से़क्‍खाए मे़त्‍निङ्, निङ्‌वाॽफुहाङ्‌जुम्‍मिन् याम्‍मो मे़न्‍दाए थारिक् चे़ल्‍ले़क्‍सेॽ थिःन् इङ्‌गाॽ याम्‍मो मे़धुङ्‌ङान्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","हे़क्‍क्‍याङ् खुने़ॽ खरे़ःङ्‌ङिन् खप्‍सुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरु हे़क्‍क्‍याङ् खे़ःक्‍खुआङ् कुहुॽसाम्‍बाहाॽ पिरुसिर अक्‍खे मे़त्तुसि, “कन् खिनिॽ लागि पिरे़बा आधक्‍लो॥ इङ्‌गाॽ आनिङ्‌वाॽसोओ अक्‍खे चोगे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","बा हे़क्‍केलॽरिक्‍के मे़ज मे़सुरुआङ् चल्‍लङ्‌ना खोर्याःन् ये़सुरे़ पक्‍खुर अक्‍खे मे़त्तुसि, “कन् खिनिॽ लागि आमाक्‍खिॽइन्‌वदेःन्‍दे़आङ्‌निःन्‍धो पोःक्‍खे़बा कुसङ् माङ्‌हुप्‍पिन्लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","कर ओमे़त्ते़म्‍मे़ॽ! इङ्‌गाॽ याप्‍मि इङ्‌गे़ले़क्‍पान्‌बा कन् चामा ते़न्‍नो इङ्‌गाॽनुए चर युङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","आल्‍ल निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ निङ्‌वाॽ चोगुबा कुइसिःक्‍के मे़न्‍छाम्‍साःङ्‌ग सिःमाए पोःङ्‌लो, कर खुने़ॽ इङ्‌गे़ले़क्‍पे़ङ्‌ग चिःत्ते़ स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","खे़ङ्‌हाॽरे़ आनिॽ लुम्‍मो अक्‍तङ्‌बा याःम्‍बक् हाःत्‍ले़ चोगुॽबिला लॽरिक् सेःन्‍दोःसिङ्‌मा मे़हेःक्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽरे़ के़रे़क्‍नुःल्‍ले़ यम्‍बा हाःत्‍निबे फाॽआङ् पाःन्‍धक्‍मा मे़हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “कन् थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ खुनिॽ हाङ्‌हाॽरे़ मनाहाॽ पाःप्‍पाःत्‌मे़मे़त्तुसि हे़क्‍क्‍याङ् खुनिॽ युक्‍साबाहाॽरे़ आनिगे़ मनाहाॽरे़ खुनिॽ तेःङ्‌सिगे़ फाॽआङ् मे़मे़त्‍छिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","कर खिनिॽओग अक्‍खे मे़बोःङ्‌ने़ल्‍लो॥ खिनिॽओग आत्तिन् यम्‍बा चोःक्, खे़न् चुक्‍सा पोःङ्‌मा पोःङ् हे़क्‍क्‍याङ् लाम्‍लोःबान् सेवारोबे़न् हे़क्‍के पोःङ्‌मा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","आल्‍ल चाजामादे़न्‍नो के़युङ्‌बे़न् नु सेवा के़जोःक्‍पे़न्‌आत्तिन् यम्‍बाबे? खे़न् चाजामादे़न्‍नो के़युङ्‌बे़न् यम्‍बा मे़ःम्‍बि? कर खिनिॽओग इङ्‌गाॽ सेवा के़जोःक्‍पा हे़क्‍के वाॽआ फाॽआङ् मे़त्‍निङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","खिनिॽग चक्‍मे़ल्‍लॽए इङ्‌गाॽ आदुक्‍खेओ तेःङ् याप्‍मि के़मे़त्तिआङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","पानुदिङ् आम्‍बारे़ इङ्‌गाॽ हाङ् चोःक्‍मा युक् पिराङ्‌बा हे़क्‍केए खिनिॽआङ् पिनिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","खिनिॽ आहाङ्‌जुम्‍मो इङ्‌गाॽनुए सोरिक् के़युङिॽआङ् के़जाम् के़धुङुम्‍लो॥ हे़क्‍क्‍याङ् हाङ्‌युक्‍नाओ के़युङिआङ् इस्राइलबा थिक्-ने़त् सुवाङ्‌हाॽ सम्‍दाङ् हाङ् के़जोगिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ये़सुरे़ मे़त्तु, “सिमोने, सिमोने, खे़प्‍से़ॽओ! इक्‍मसाबाल्‍ले़ चाःन्‍नु कुहःक्‍किन् से़म्‍मारे़ लागि ए़प्‍तुआङ् से़न्‍दुबा कुइसिःक् माफे़न्‍साम्‍मिल्‍ले़आङ् खिनिॽ नसाःन्‍निन् ले़ङ्‌मा फाॽआङ् इङ्‌जाःङ् नाःक्‍तुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","कर इङ्‌गाॽ खे़ने़ॽ के़नसाःन्‍निन् मे़ले़ङ्‌ने़न्‍ल फाॽआङ् तुवा चोगुङ् पिने़आङ् वाॽआरो॥ खे़ने़ॽ याम्‍मो नसाःन्‍नो के़धुम्‍बा पोःक्‍खे़आङ् के़म्‍भुॽ के़न्‍साॽसिआङ् खुनिॽ नसाःन्‍नो के़धुम्‍बा चोगे़से़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","सिमोनरे़ नोगप् पिरु, “आदाङ्‌बे, इङ्‌गाॽग खे़ने़ॽनु पुङ्‌लाहिम्‍मो थारिक्‍लक् मे़ःन्, कर सिःमा पोःङ्‌साङ् यारिप् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","कर ये़सुरे़ खे़न् मे़त्तु, “पत्रुसे, इङ्‌गाॽ पाःन्‍धिक् मे़त्‍ने़ॽरो, आइन् से़न्‍दिक् इङ्‌वा काःमानुःल्‍ले़ तगि खुने़ॽ कुसिङ्‌मे़निःत्तुङ्‌ङिन् के़बाःत्तुर सुम्‍ले़ङ् के़नाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ खिनिॽ सुनाइङ् इङ्‌भन् चोःक्‍से़ सुःक्‌वा, साब्रि नु लाङ्‌सुःप् थेआङ् मे़ःन्‍ने पाङ्‌निङ्‌ङिल्‍ले़ खिनिॽ के़साक्‍पो के़ध्‍ये़ॽइबि?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “मे़ध्‍ये़ॽइगे़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “कर आल्‍लो खिनिॽ सुःक्‌वा साब्रिहाॽ याङ्‌सिङ्‌ङे़म्‍मे़ॽओ हे़क्‍क्‍याङ् ताभेःन् मे़ङ्‌गप्‍मनाबाल्‍ले़ हाराॽ कुसुङ्‌घे़ॽवाःन् सङ्‌घुआङ् लत्‍थिक् ताभेधिक्‍काङ् इङुररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","अक्‍खेलॽरिक् साम्‌योसाप्‍लाओ साप्‍ते़आङ् पत्, ‘खुने़ॽग हाङ्‌बिफ्‍युङ्‌बाहाॽनु मे़दङ्‌घुरो॥’ कन् पाःन्‍निन् नु माङ्‌निङ्‌वाॽपाःन्‍नो इङ्‌गाॽ आमे़न्‍नो साप्‍ते़आङ् पप्‍पा पाःन्‍हाॽ के़रे़क् इङ्‌गाॽओ के़त्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “आदाङ्‌बे, आनिगे़ ने़त्‍छि ताभे कत्तुम्‍बे़रो॥” ये़सुरे़ मे़त्तुसि, “हे़क्‍केने़ फाॽग्र खे़म्‍म्‍याक्‍काङ् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","हे़क्‍क्‍याङ् ये़सुःन् थोःस्‍मा याक्‍फाङ्‌ङोनु लःन्‍दे़आङ् सदादिङ् हे़क्‍के जैतुन कोःक्‍माओ पेःल्‍ले़ कुहुॽसाम्‍बाहाॽआङ् खुने़ॽनुए सोरिक् मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","खे़प्‍मो ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “हङ्‌साॽमाओ मे़ध्‍ये़ॽइगे़न्‍ल फाॽआङ् तुवा चोगे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","हे़क्‍क्‍याङ् खुने़ॽ मिसाक् नानाक् पेआङ् थुङ्‌बोहजॽ युङ्‌सिङ्‌ङाङ् अक्‍खेलॽरिक् तुवा चोगु, ");
INSERT INTO lifNT2_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“पानुदिङ् आम्‍बे, खे़ने़ॽ निङ्‌वाॽ के़जोगुने़ फाॽग्र कन् इनोगे़न् तुक्‍खेरे़न् खोर्याःन् इङ्‌गाॽओलाम् खे़त्ते़देःसे़ॽओ॥ हे़क्‍केसाङ् इङ्‌गाॽ आनिङ्‌वाॽ हे़क्‍केग मे़ःन्, कर के़निङ्‌वाॽ हे़क्‍केए पोःङ्‌लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","((हे़क्‍क्‍याङ् खे़प्‍मो माङ्‌लाइङ्‌बाधिक् साङ्‌ग्राम्‍पेदाङ्‌लाम् थाःम्‍सिङ्‌ङाङ् खुने़ॽ कुभाॽ पिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","हे़क्‍क्‍याङ् खुने़ॽ निङ्‌साम्‍गे़न् निङ्‌वाॽरे़ नायो पोःक्‍खे़आङ् साॽरिक् निङ्‌वाॽ पिरुआङ् तुवा चोगु, हे़क्‍क्‍याङ् खुने़ॽ कुहाःम्‍ब्रिक्‌वाःन् यम्‍ब्‌यम्‍बा माक्‍खिॽ ते़प्‍पक्‌वा कुइसिःक् खाम्‍मो मक्‍थ्‍ये़रो॥)) ");
INSERT INTO lifNT2_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ये़सुःन् तुवाओलाम् पोगे़आङ् कुहुॽसाम्‍बाहाॽ मे़युङे़बा ते़न्‍नो पे॥ खे़ङ्‌हाॽ के़रे़क् मिङ्‌वाःल्‍ले़ मे़नाःसे़आङ् मे़इप्‍से़बा तुमुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","खे़ङ्‌हाॽ फोःक्‍खुसिर अक्‍खे मे़त्तुसि, “थेआङ् के़इप्‍सिर के़ने़स्‍सिबाबे? पोगे़म्‍मे़ॽआङ् हङ्‌साॽमो मे़ध्‍ये़ॽइगे़न्‍ल फाॽआङ् तुवा चोगे़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","कर ये़सुरे़ हे़क्‍के पाःत्तुर पत्‍छे़ल्‍ले़सा, थिक्-ने़त् कुहुॽसाम्‍बाहाॽओबा लत्‍छा यहुदा मे़प्‍मनाबे़ल्‍ले़ मनाहाॽ लाम्‍लोसुसिर खे़प्‍मो तारुसि॥ हे़क्‍क्‍याङ् ये़सुःन् चुप् मे़प्‍माआङ् सेवा मे़त्‍छे़ कुबेसाङ् पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","कर ये़सुरे़ खे़न् मे़त्तु, “यहुदाए, अक्‍खेलॽरिक् इङ्‌गाॽ मे़न्‍छाम्‍साःन् चुप् के़मे़त्ताआङ् खे़ने़ॽ इङ्‌गे़ले़क्‍काबाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","हे़क्‍क्‍याङ् आल्‍ल खे़प्‍मो थे पोःङ् के़लॽबा निङ्‌वाॽ मे़इःत्तुआङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ मे़मे़त्तु, “आदाङ्‌बे, आल्‍लो आनिगे़ ताभेःल्‍ले़ कङ्‌हाॽ चे़प्‍त्तुम्‍सिम्‍बे़ॽबि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","हे़क्‍क्‍याङ् खे़ङ्‌हाॽओ थिक्‍किल्‍ले़ग ताभेःन् तरप् फिःक्‍खुआङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुसेवारोबाल्‍ले़ कुजुप्‍साङ् ले़प्‍माङ्‌बा कुने़क्‍खोॽबान् पे़त्तु थाःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आल्‍ल नाॽरे़म्‍मे़ॽओ॥” हे़क्‍क्‍याङ् खे़ल्‍ले़ कुने़क्‍खोॽबान् सुःसुआङ् नुसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","हे़क्‍क्‍याङ् ये़सुरे़ खुने़ॽ कुदे़म्‍से़ के़दाःबा तुम्निङ्‌वाॽफुसाम्‍बाहाॽ, माङ्‌हिम् के़गोःबाहाॽरे़ खुनिॽ थक्‍तुम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽ अक्‍खे मे़त्तुसि, “इङ्‌गाॽ हाङ्‌बिफ्‍युङ् के़जोःक्‍पाआबि? थेआङ् इङ्‌गाॽ आदे़म्‍से़ ताभेनु तक्‍काःत्‍नु के़द्‌ये़ॽइबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","इङ्‌गाॽग थिक्‌याःन्‍धक्‍सा माङ्‌हिम् लक्‍खुम्‍मो निसाम् हुॽइसे़ वयाङ्‌बा हे़क्‍केसाङ् याप्‍मि के़न्‍दे़म्‍सिन्, कर खादाम्‍मा मुक्‍साम्‍मिल्‍ले़ युक्‍तुल्‍ले़ए खिनिॽ याःम्‍बक् चोःक्‍मा ये़म् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुने़ॽ मे़दे़म्‍सुआङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुहिम्‍मो मे़दारु॥ पत्रुसे़न्‍नाङ् माःङ्‌घालाम् खे़ङ्‌हाॽ तिम्‍दुसिर खे़प्‍मो त्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","खे़ङ्‌हाॽरे़ लक्‍खुम्‍लुम्‍मो मि मे़दुप्‍तुआङ् मिजाॽनु मे़युङे़ल्‍ले़ पत्रुसे़न्‍नाङ् खुनिॽ लुम्‍मो पेआङ् युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","हे़क्‍क्‍याङ् खे़प्‍मो सेवारोमा चुक्‍माधिक्‍ले़ खुने़ॽ खागे़ओःप्‍पाओ युङे़ल्‍ले़ नुःरिक् ओमे़त्तुआङ् अक्‍खे पाःत्तु, “कन् मनाःन्‍नाङ् ये़सुःन्‍नुए वये़बा हे़क्‍के लॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","कर पत्रुसरे़ खे़न् नाॽरुर मे़त्तु, “कन् मे़न्‍छुमाॽइल्‍ले़ थेःन्‍ने़ पाःत्तुबे? इङ्‌गाॽ खुने़ॽ कुसिङ् मे़निःत्तुङ्‌ङिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","सप्‍फा एगाङ् वेॽस्‍मा थिक्‍ले़ खुने़ॽ निःसुआङ् मे़त्तु, “खे़ने़ॽग खे़ङ्‌हाॽनुए के़वये़रो॥” कर पत्रुसरे़ पाःत्तु, “मे़ःन्‍लो, इङ्‌गाॽग मे़वयाङ्‌ङिन्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","याङ्‌सि कुमुक् थिक् एगाङ् कुभाधिक्‍ले़ खुने़ॽ निःसुआङ् अक्‍खे पाःत्तु, “से़क्‍खासाङ् खुने़ॽग ये़सुःन्‍नुए वये़रो, थेआङ्‌भे़ल्‍ले़ खुने़ॽ गालिललाम् के़दाःबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","कर पत्रुसरे़ पाःत्तु, “मे़ःम्‍बे़ हौ! थे़मानि के़बाःत्तुबे? इङ्‌गाॽग खुने़ॽ कुसिङ् मे़निःत्तान्‍लो॥” खिमो खुने़ॽ पारे़र पत्‍छे़ल्‍ले़सा इङ्‌वाःन् काःसे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ये़सुरे़ खिरि हिसिङ्‌ङाङ् पत्रुसे़न् ओमे़त्तु॥ हे़क्‍क्‍याङ् दाङ्‌बाल्‍ले़, “आइन् इङ्‌वा काःमानुःल्‍ले़ तगि खे़ने़ॽ सुम्‍ले़ङ् के़नाॽआरो” पाःत्तुबा पाःन्‍निन् पत्रुसरे़ कुनिङ्‌वाॽ सुम् लॽरे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","हे़क्‍क्‍याङ् पत्रुसे़न् लक्‍खुम्‍मोनु लःन्‍दे़पेआङ् उःक्‍काङ्-उःक् हाबे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","आल्‍ल ये़सुःन् के़गोःबा थक्‍सुबाहाॽरे़ खुने़ॽ किनाःन्‍दि पिमा मे़हेःक्‍तुर मे़हिप्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","कुमिक्‍किन् तेःत्तिल्‍ले़ मे़दे़प्‍तुर मे़हिप्‍तुआङ् खुने़ॽ सेःन्‍मे़दोसु, “खे़ने़ॽ हाःत्‍ले़ के़हिप्‍ते़बे? माङ्‌निङ्‌वाॽपाःन् पाःत्ते़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ किनाःन्‍दि मे़बिरुर वेॽस्‍मा यरिक् ताप्‍फे़ःम्‍बा पाःन्‍हाॽ ये़सुरे़ कुदक्‍ले़ङ्‌वाओ मे़बाःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","हे़क्‍क्‍याङ् खाओःत्ते़आङ् यहुदि तुम्‍लाम्‍लोःबाहाॽ, तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ मे़जुप्‍से़॥ हे़क्‍क्‍याङ् ये़सुःन् ये़जुम्‍भोओ मे़देॽरुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","खे़ङ्‌हाॽरे़ मे़मे़त्तु, “खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तने़न्‍बि? याप्‍मि आमे़त्ते़ॽ॥ कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, ‘इङ्‌गाॽ पाःत्तुङ्‌साङ् याप्‍मि नसाःन् के़न्‍जोगिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","हे़क्‍क्‍याङ् इङ्‌गाॽ सेःन्‍दोःनिङ्‌साङ् नोगप् याप्‍मि के़म्‍बिरिन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","कर आल्‍लोआङ्‌धो इङ्‌गाॽ मे़न्‍छाम्‍साःन् मुक्‍साम्‍दाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुजुप्‍साङ् ले़प्‍माङ् युङ्‌लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुने़ॽ सेःन्‍मे़दोसु, “खे़ने़ॽए निङ्‌वाॽफुसाःने़बि?” हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ के़बाःत्तुम्‍बान् से़क्‍खारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ मे़बाःत्तु, “आल्‍ल आनिॽ वेॽ मनाहाॽरे़ खुनिॽ तोःन्‍दि थेआङ् चाहाबा आजोगे़बे? खुने़ॽ कुमुरालाम्‍बाए आनिॽ खा आघे़प्‍सुम्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ये़जुम्‍भोबा के़रे़क् मनाहाॽ मे़बोगे़आङ् ये़सुःन् रोमि सुहाङ्‌गे़म्‍बा पिलातसरो मे़दारुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","फोत्‍या कुःप्‍मा मे़हेःक्‍तु, “आनिगे़ कन् मनाःल्‍ले़ कन् सुवाङ्‌हाॽ इङ्‌गाॽए निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त हाङ्‌आ मे़त्तुसिर पयम् हाङ् सिजरे़न् एःङ्‌याङ् पिमा मे़ःन् फाॽआङ् हुसुसिबा तुमुम्‍बे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","हे़क्‍क्‍याङ् पिलातसरे़ ये़सुःन् सेःन्‍दोसु, “से़क्‍खा खे़ने़ॽ यहुदि हाङ्‌ने़बि?” ये़सुरे़ खे़न् नोगप् पिरु, “खे़ङ्‌ग खे़ने़ॽए के़बाःत्तुर के़बत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","हे़क्‍क्‍याङ् पिलातसरे़ तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु खे़न् मनाहाॽ मे़त्तुसि, “इङ्‌गाॽग कन् मनाःल्‍ले़ थेआङ् फे़न् याःम्‍बक् चोगुबा मे़ङ्‌घोःबान्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","कर खे़ङ्‌हाॽरे़ याम्‍मो ये़सुःन् अक्‍खे मे़मे़त्तुर आप्‍तिक् मे़गुःत्तु, “कन् मनाःल्‍ले़ कुनिसाम्‍मिल्‍ले़ कन् के़रे़क् मनाहाॽ के़रे़क् यहुदिया नु गालिललाम् कप्‍मो थारिक् हाङ्‌बिफ्‍युङ् चोःक्‍मा हुसुसिर वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","हे़क्‍क्‍याङ् पिलातसरे़ खे़न् खे़प्‍सुआङ् कन् मनाःन् गालिलस्‍माबि? फाॽआङ् सेःन्‍दोसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","पिलातसरे़ कन् पाःन्‍निन् हे़रोद हाङ्‌ङिल्‍ले़ कुलाजेॽओबा के़लॽबा निङ्‌वाॽ खोःसुआङ् ये़सुःन् हे़रोद हाङ्‌ङिल्‍लोए पाङ्‌घुदेःसुरो॥ खे़न् ये़म्‍मो हे़रोदे़न यरुसले़म्‍मो वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","हे़रोदरे़ ये़सुःन् निःसुआङ् साॽरिक् सःत्ते़, थेआङ्‌भे़ल्‍ले़ खुने़ॽ चोगुबा पाःन्‍निन् खे़प्‍सुआङ् तगिआङ्धो तुम्‍मा निङ्‌वाॽ चोगुआङ् वये़॥ आल्‍ल खुने़ॽ कुदगि ये़सुरे़ निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ चोगुबा ओमे़प्‍मा कुसिराॽ थाङे़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","हे़रोदरे़ खुने़ॽ यरिक् पाःन्‍हाॽ सेःन्‍दोसु, कर ये़सुरे़ थेआङ् नोगप् मे़बिरुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","हे़क्‍क्‍याङ् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ मे़बोगे़आङ् खुने़ॽ ये़क्‍कप् फोत्‍या कुःप्‍मा मे़हेःक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","हे़रोदे़न नु कुधक्‍सुबाहाॽरे़ ये़सुःन् किनाःन्‍दि मे़बिरुर कुजाःत्‍थि मे़देःसु, हे़क्‍क्‍याङ् परान्‍ला हाङ्‌तेःत्तिन् मे़जाक्‍तु मे़बिरुआङ् याङ्‌ना पिलातसरो मे़बाङ्‌घु मे़देःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","बा खे़न् ये़न्‍नाङ्‌धो हे़रोद हाङ्‌ङिन् नु पिलातसे़न् याम्‍मो तङे़त्‍छिरो॥ खे़न्‍नुःल्‍ले़ तगि खुन्‍छिॽ ने़प्‍माङ् निङ्‌मि वये़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","हे़क्‍क्‍याङ् पिलातसरे़ तुम्निङ्‌वाॽफुसाम्‍बाहाॽ, यहुदि लाम्‍लोःबाहाॽ नु मनाहाॽ उःत्तुसिआङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ कन् हाङ्‌बिफ्‍युङ् के़जोःक्‍पा फाॽआङ् फोत्‍या के़गुःत्तुम्‍माङ् के़दारुम्‍बा मनाःन् खिनिॽ तगिए इङ्‌गाॽ यरिक् पाःन् सेःन्‍दोसुङ्, कर इङ्‌गाॽ थेआङ् याःम्‍बक् फेःन्‍दुबा मे़ङ्‌घोःबान्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","हे़क्‍क्‍याङ् हे़रोद हाङ्‌ङिल्‍ले़आङ् थेआङ् मे़घोःसुन्‍नाङ्‌याङ्‌ना इङ्‌गाॽओ नुःक्‍तु फे़न्‍छुआङ् वाॽरो॥ ओमे़त्ते़म्‍मे़ॽ, कल्‍ले़ सिःमे़ल्‍ले़ खुम्‍दिङ् खोःमा के़बोःङ्‌बा याःम्‍बक् थे़माआङ् मे़न्‍जोःक्‍के वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","हे़क्‍केःल्‍ले़ इङ्‌गाॽ खुने़ॽ ते़ःम्‍भुक् याक् पाङ्‌घुङ्‌सिङ्‌ङाङ् ले़रुङ्‌देःसुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","((आल्‍ल तङ्‌नाम्‍मो पुङ्‌लाहिम्‍मो साक्‍पा के़धाःबाधिक् ले़प्‍मा थिम् वये़रो॥)) ");
INSERT INTO lifNT2_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","कर खे़ङ्‌हाॽ थिक्‍हुप् मे़बोःक्‍खे़आङ् मे़अःक्‍ते़, “कन् मनाःन् खुम्‍दिङ् पिरे़ॽआङ् आनिगे़ लागि बरब्‍बासे़न ले़रे़ आबिरे़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(खे़न् मनाःन् ये़क्‌यक्‍को हाङ्‌बिफ्‍युङ् चोगुबा नु मना से़रुसिबा आप्‍तिक्‍को पुङ्‌लाहिम्‍मो साक्‍पा थ्‍ये़आङ् यागे़रो॥) ");
INSERT INTO lifNT2_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","पिलातसरे़ ये़सुःन् ले़प्‍मा निङ्‌वाॽ चोगुर खे़ङ्‌हाॽ याम्‍मो ताॽजे़क्‍तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","कर खे़ङ्‌हाॽ मे़अःक्‍ते़, “खे़न् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःन्‍दे़ॽ! सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःन्‍दे़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","हे़क्‍क्‍याङ् सुम्‍ले़ङ्‌ङो पिलातसरे़ खे़ङ्‌हाॽ याम्‍मो मे़त्तुसि, “थेआङ्बे? खे़ल्‍ले़ थे याःम्‍बक् फेःन्‍दुआङ् वाॽबे? खुने़ॽ सिःमे़ल्‍ले़ खुम्‍दिङ् खोःमा याःम्‍बक् चोगुबा इङ्‌गाॽ मे़ङ्‌घोःबान्‍लो, हे़क्‍केःल्‍ले़ खुने़ॽ ते़ःम्‍भुक् याक्पाङ्‌घुङ्‌सिङ्‌ङाङ् ले़रुङ्‌देःसुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","कर खे़ङ्‌हाॽ अयाक् मे़ल्‍लॽए यम्‍बा इक्‍लाओ मे़अःक्‍ते़, “सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःन्‍दे़ॽ॥” खे़ङ्‌हाॽ थिक्‍हुप् मे़बोःक्‍खे़आङ् साॽरिक् मे़अःक्‍ते़बाल्‍ले़ खुनिॽ पाःन्‍निन् के़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ मे़बाःत्तुबा पाःन्‍निन् कुइसिःक् पिलातसरे़ खुम्‍दिङ् पिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","खुने़ॽ खे़न् ये़क्‌यक्‍को हाङ्‌बिफ्‍युङ् चोःक्‍मा नु मना से़प्‍मा आप्‍तिक्‍को पुङ्‌लाहिम्‍मो साक्‍पा के़धाबे़न् ले़प्‍मा पाङ्‌घुसि, कर ये़सुःन् खे़ङ्‌हाॽरे़ मे़इःत्तुबा हे़क्‍के मे़जोगुर फाॽआङ् ले़रु पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","हे़क्‍क्‍याङ् थक्‍सुबाहाॽरे़ खुने़ॽ लाःक्‍कात् मे़लःत्तु मे़देॽरुआङ् खे़ङ्‌हाॽरे़ पाङ्‌भेॽओनु के़भे़म्‍बार के़बप्‍पा सिमोन मे़प्‍मनाबा साइरेनि ये़क्‌यक्‍को के़युङ्‌बे़न् मे़दे़म्‍सु, हे़क्‍क्‍याङ् ये़सुरे़ कुसिलाम्‍साक्‍मा सिङ्‌ङिन् पङ्‌माआङ् ये़सुःन् तिम्‍मा मे़बाङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","हे़क्‍क्‍याङ् खे़प्‍मो यरिक् मनाहाॽरे़ खुने़ॽ मे़दिम्‍दुरो॥ खे़प्‍मो के़हाःप्‍मार मेरिङ् के़धक्‍मा मे़न्‍छुमाहाॽआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","कर ये़सुरे़ खिरि हिसिङ्‌ङाङ् खे़ङ्‌हाॽ मे़त्तुसि, “यरुसले़म्‍मिल्‍ले़ कुस्‍साः मे़न्‍छुमाॽसे, खिनिॽ आलागि मे़हाबे़म्‍मिन्‍ने़ॽ, कर खिनिॽ आबाङे लागि नु खिनिॽ साःहाॽरे़ लागि हाबे़म्‍मे़ॽओ, ");
INSERT INTO lifNT2_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","थेआङ्‌भे़ल्‍ले़ मनाहाॽरे़ आप्‍फाल्‍ले़आङ् साःमे़ङ्‌गप्‍मनामाहाॽ हे़क्‍क्‍याङ् अङे़ःक्‌वा नुमे़न्‍धुक्‍नामाहाॽ मुइॽसामासिरो लॽरिक् पाःप्‍मा ये़म् तार पत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","खे़न् ये़म्‍मो मनाहाॽरे़ नाङ्‌जङ्‌हाॽ आनिगे़ सम्‍दाङ् मक्‍थ्‍ये़ॽओ! हे़क्‍क्‍याङ् कोःक्‍माहाॽ याप्‍मि आलुप्‍ते़ओ! फाॽआङ् मे़मे़त्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","थेआङ्‌भे़ल्‍ले़ सरिःत्‍क्याःप्‍पा कुहिङ्‌वे़त् सिङ्‌ङिन्‍ने अक्‍खे मे़मे़त्तुल्‍ले़, के़हेबा सिङ्‌ङिङ्‌ग आक्‍खे मे़मे़त्तुइरो?” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","खुने़ॽनुए ने़प्‍फु कुभाङ्‌के़भेःम्‍बाहाॽआङ् सिःमे़ल्‍ले़ खुम्‍दिङ् पिमासि फाॽआङ् मे़देॽरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","खे़ङ्‌हाॽ मिक्‍खोःक्‍पा मे़प्‍मनाबा कोःक्‍माओ मे़गे़रे़आङ् ये़सुःन् सिलाम्‍साक्‍मा सिङ्‌सम्‍दाङ् मे़भोःन्‍दुरो॥ खे़न् ने़प्‍फु कुभाङ्‌के़भेःम्‍बाहाॽ ये़सुरे़ कुजुप्‍साङ् नु कुभे़न्‍छाङ्‌बा सिलाम्‍साक्‍मा सिङ्‌हाॽ सम्‍दाङ् मे़भोःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","हे़क्‍क्‍याङ् ये़सुरे़ पाःत्तु, “पानुदिङ् आम्‍बौ, कङ्‌हाॽ ले़प्‍मि पिरे़से़ॽओ, थेआङ्‌भे़ल्‍ले़ कङ्‌हाॽरे़ थे़मा मे़जोगुर मे़बत् थेआङ् मे़न्‍निःसुन्‍लो॥” हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ ये़सुरे़ कुदेःत्‍हाॽ हाःत्‍छिङ्‌मा फाॽआङ् तॽयाःन्‍सोःन् मे़गे़सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","माःङ्‌घालाम् मनाहाॽ ओमे़मये़र मे़ये़बे़, कर यहुदि लाम्‍लोःबाहाॽरे़ खुने़ॽ किनाःन्‍दि मे़बिरुर अक्‍खे मे़मे़त्तु, “खे़ल्‍ले़ वेॽ मनाहाॽग से़ःप्‍तुसि, आल्‍ल निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तने़ फाॽग्र आबाङे से़ःप्‍सिङ्‌ल!” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","हे़क्‍क्‍याङ् थक्‍सुबाहाॽरे़ मे़धाङे़आङ् किनाःन्‍दि मे़बिरु हे़क्‍क्‍याङ् के़सुःप्‍पा चे़ल्‍ले़क्‍सेॽ थिःन् मे़धुङ्‌घुर ");
INSERT INTO lifNT2_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","मे़मे़त्तु, “खे़ने़ॽ यहुदि हाङ्‌ने़ फाॽग्र आबाङे से़ःप्‍सिङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","हे़क्‍क्‍याङ् ये़सुरे़ कुधे़गेःक् सम्‍दाङ् कङ्‌ग यहुदिहाॽरे़ खुनिॽ हाङ्लो लॽरिक् आप्‍तिक् सक्‍किन् मे़साप्‍तुआङ् मे़भत्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","खे़प्‍मो सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् मे़भोःन्‍दुबा कुभाङ्‌के़भेःम्‍बाधिक्‍ले़ खुने़ॽ पाःन्‍निल्‍ले़ लक्‍तुर अक्‍खे मे़त्तु, “खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तने़ मे़ःम्‍बि? खे़ने़ॽ से़ःप्‍सिङ्‌ङे़ॽआङ् आन्‍छिगे़आङ् याप्‍मि आसे़ःप्‍ते़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","कर वेॽस्‍मा कुभाङ्‌के़भेःम्‍बाल्‍ले़ खे़न् फे़ःक्‍तुर अक्‍खे मे़त्तु, “खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिन् के़ङ्‌गिरुन्‍बि? आनिॽ सुम्‍ब्राङ्‌ङे़ लत्‍छा परिक्‍पा खुम्‍दिङ्‌ङो आध्‍ये़आङ् आवाॽ, ");
INSERT INTO lifNT2_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","च्‍यासाङ् आन्‍छिॽग आजोगे़त्‍छुबा याःम्‍बक् कुइसिःक् सिःमे़ल्‍ले़ खुम्‍दिङ् आघोःसे़त्‍छुबारो, कर खुने़ॽग थेआङ् फे़न् याःम्‍बक् मे़न्‍जोःक्‍के वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","हे़क्‍क्‍याङ् खुने़ॽ ये़सुःन् मे़त्तु, “ये़सुए, खे़ने़ॽ के़हाङ्‌जुम्‍मो के़युःल्‍ले़ इङ्‌गाॽआङ् निङ्‌वाॽ इःत्ताङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ये़सुरे़ खुने़ॽ मे़त्तु, “इङ्‌गाॽ खे़ने़ॽ मे़त्‍ने़ॽ, से़क्‍खाए खे़ने़ॽ आइन्‍छा साङ्‌ग्राम्‍पेदाङ्‌ङो इङ्‌गाॽनु सोरिक् के़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","आल्‍ल कुमुक् थिक्-ने़त् (१२) खिरि पोःक्‍खे़आङ् वये़ल्‍ले़ नाम्‍मिन् मे़ओःत्ते़न्‍नाङ्‌कुमुक् सुम्‍सि थारिक् खादाम्‍माल्‍ले़ खे़न् लाजेॽइन्‌सिदे़प् ते़प्‍तुरो॥ हे़क्‍क्‍याङ् माङ्‌हिम्‍मो फोःम्‍मनाबा फोःन्‍दाःन् थोनु यो थारिक् कुलुम्‍मो ते़रे़ॽ ते़ःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ये़सुःन् यम्‍बा इक्‍लाओ अःक्‍ते़र अक्‍खे पाःत्तु, “पानुदिङ् आम्‍बे, इङ्‌गाॽ आयाम्‍साम्‍मिन् हुक्‍सुप्‍ने़ॽरो॥” हे़क्‍क्‍याङ् खुने़ॽ कुसक्‍मा पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","हे़क्‍क्‍याङ् खे़प्‍मो के़ये़प्‍पा रोमि थक्‍तुम्‍बाल्‍ले़ कन् हिन्‍दोःक्‍हाॽ निःसुआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःसुर अक्‍खे पाःत्तु, “से़क्‍खासाङ् कन् मनाःन् साम्‌योनिबा वये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","हे़क्‍क्‍याङ् खे़प्‍मो कन् हिन्‍दोःक् ओमे़त्‍छे़ के़जुम्‍बाआङ् के़वाॽबाहाॽरे़ कन् मे़निःसुआङ् खुनिॽ सङ्‌बेन् मे़हिप्‍तुर मेरिङ् थक्‍नु हिम्‍मो मे़नुःक्‍खे़ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","हे़क्‍क्‍याङ् ये़सुरे़ काक् कुन्‍देःङ्‌-कुन्‍जुम्‍हाॽ नु खुने़ॽ गालिललाम् के़दिम्‍मार के़दाःमा मे़न्‍छुमाहाॽरे़ माःङ्‌घालाम् कन् हिन्‍दोःक्‍किन् ओमे़मे़त्तुर मे़ये़बे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","आल्‍ल आरिमाथिया पाङ्‌जुम्‍बा युसुफ मे़प्‍मनाबा मनाधिक् वये़॥ खे़न् यहुदि ये़जुम्‍भोबा पासिङ्पादाङ्‌लाआङ् वये़रो॥ खुने़ॽ निङ्‌वाॽफुहाङ्‌जुम्‍मिन् के़हाङ्‌बा नुःबा नु साम्‌योनिबा मना चोगे़, हे़क्‍केःल्‍ले़ खुने़ॽ कन् याःम्‍बक्‍को थेआङ् ते़न्‍दिङ् मे़म्‍बिए वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","खुने़ॽ पिलातसरो पेआङ् ये़सुरे़ कुधक्‍किन् नाःक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","हे़क्‍क्‍याङ् खुने़ॽ ये़सुरे़ कुधक्‍किन् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ्‌लाम् थाःसुआङ् नुःबा चेदेःत्तिल्‍ले़ कित्तुआङ् खोःम्‍मनाबा लुङ् इप्‍पुङ्‌ङो ने़स्‍सुरो॥ खे़न् इप्‍पुङ्‌ङो तगि आत्तिन्‍नाङ् मे़न्‍ने़ए वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","आल्‍ल कन् नाःम्‍सिङ्‌ये़न् यारिप् चोःक्‍मा ये़न् वये़ हे़क्‍क्‍याङ् नाःम्‍सिङ्‌ये़न् ताःमा इःत्ते़आङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","हे़क्‍क्‍याङ् गालिललाम् खुने़ॽनु सोरिक् के़दाःमा मे़न्‍छुमाहाॽरे़ युसुफे़न् मे़दिम्‍दुर ये़सुरे़ कुधक्‍किन् मे़ने़स्‍सुबा इप्‍पुङ्‌ङिन् मे़निःसुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","खे़ङ्‌हाॽ हिम्‍मो मे़नुःक्‍खे़ मे़बेआङ् ये़सुरे़ कुधक्‍को हुःप्‍मा फाॽआङ् मारुक् नु सिदाॽहाॽ यारिप् मे़जोगुरो॥ हे़क्‍क्‍याङ् कन् साम्‌यो इङ्‌जाःङ्‌ङिन् कुइसिःक् नाःम्‍सिङ्‌ये़न्‍नो खे़ङ्‌हाॽ मे़नाःम्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ते़ने़बा ये़न्‍नो खाओःत्ते़र पत्‍छे़ल्‍ले़ खे़न् मे़न्‍छुमाहाॽरे़ ये़सुरे़ कुधक्‍को हुःप्‍मा फाॽआङ् यारिप् मे़जोगुबा मारुक् नु सिदाॽहाॽ मे़याङ्‌सिङ्‌ङाङ् इप्‍पुङ्‌दे़न्‍नो मे़बे॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","खे़ङ्‌हाॽरे़ इप्‍पुङ्‌ङिल्‍ले़ कुमुराओ मे़ये़प्‍सुबा यम्‍बा लुङ्‌ङिन् थिक्‍ले़प्‍माङ् मे़इसुआङ् ने़स्‍से़बा मे़निःसु, ");
INSERT INTO lifNT2_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","कर खे़ङ्‌हाॽ सिगाङ् मे़लाःस्‍से़ल्‍ले़ दाङ्‌बा ये़सुरे़ कुधक्‍किन् मे़ङ्‌घोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","खे़ङ्‌हाॽ खे़प्‍मो खुनिॽ निङ्‌वाॽ मये़र मे़ये़बे़ल्‍ले़ खुन्‍छिॽ पेसाङ् मिक्‍किन्‍ने के़जे़म्‍बा फसुःत्‍क्‍याःप्‍पा तेःत् के़जाङ्‌बा ने़प्‍फु मनाहाॽ ये़बे़त्‍छिबा मे़निःसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","खे़ङ्‌हाॽ खुनिॽ यङ्‌मा के़रे़आङ् खाम्‍मो साम्‍बोःन् हबत्‌मे़बोःक्‍खे़ल्‍ले़ खे़ङ्‌हाॽरे़ खे़न् मे़न्‍छुमाहाॽ थेआङ् खिनिॽ कुहिङ्‌वे़त् मनाःन् कुसिवे़त् मनालुम्‍मो के़गोःत्तुम्‍बाबे फाॽआङ्‌सेःन्‍मे़दोसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","“खुने़ॽग कप्‍मो होःप्‍लो! खुने़ॽग याम्‍मो हिङे़आङ् वाॽरो॥ गालिलओ खिनिॽनु वये़ल्‍ले़ खुने़ॽ पाःत्तुबा पाःन्‍निन् निङ्‌वाॽ इःत्ते़म्‍मे़ॽओ– ");
INSERT INTO lifNT2_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘मे़न्‍छाम्‍साःन् लायोबा मनाहाॽरे़ खुनिॽ हुक्‍को इङ्‌मे़ले़क्‍तुॽआङ् खुने़ॽ सिलाम्‍साक्‍मा सिङ्‌सम्‍दाङ् मे़भोःन्‍दु मे़से़रुॽ, कर सुम्‍सिगेःक्‍पा ये़न्‍नो याम्‍मो हिङ्‌लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ कन् ये़सुरे़ कुबाःन्‍निन् निङ्‌वाॽ मे़इःत्तुर ");
INSERT INTO lifNT2_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","इप्‍पुङ्‌लाम् मे़नुःक्‍खे़आङ् थिक्-थिक् (११) कुहुॽसाम्‍बाहाॽ नु वेॽ मनाहाॽ के़रे़क् मे़जे़क्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","आल्‍ल खे़न् मे़न्‍छुमाहाॽग मरियम मग्‍दलिनि, योआन्‍ना, याकुबरे़ कुम्‍मा मरियम हे़क्‍क्‍याङ् वेॽ मे़न्‍छुमाहाॽआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","कर खे़ङ्‌हाॽरे़ खे़न् मे़न्‍छुमाहाॽरे़ खुनिॽ पाःन्‍निन् नामे़न्‍छाॽरुन्॥ कङ्‌ग मे़न्‌वाॽमना पाःन्‍लक् फाॽआङ् मे़इःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","कर पत्रुसे़न् मुत्‍थ्रिक् पोगे़आङ् इप्‍पुङ्‌ङो लोःक्‍ते़र पे॥ खे़प्‍मो अःक्‍खुम् फन्‍छिङ्‌ङाङ् ओमे़त्तुल्‍ले़ग खे़प्‍मो फःगे़लॽबा चेदेःत्तिन्‌से़ःरे़आङ् ने़स्‍से़बा निःसु॥ खुने़ॽग थेःन्‍ने़ पोःक्‍खे़बे फाॽआङ् साॽरिक् कुनिङ्‌वाॽ मये़र नुःक्‍खे़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","आल्‍ल बा खे़न् ये़म्‍मो ये़सुरे़ ने़प्‍फु कुहुॽसाम्‍बाहाॽ यरुसले़म्‍लाम् थिक्-थिक् (११) किलोमितर माःङ्‌घा इम्‍माउस पाङ्‌भेॽबा लाम्‍मो ");
INSERT INTO lifNT2_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","खे़ङ्‌हाॽरे़ आइन् पोःक्‍खे़बा हिन्‍दोःक्‍किल्‍ले़ कुयाःम्‍बेओ ताॽजे़क्‍खे़त्‍छिर पेसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","खे़ङ्‌हाॽ हे़क्‍केलॽरिक् ताॽजे़क्‍खे़सिल्‍ले़ खे़प्‍मो ये़सुःन् त्‍ये़आङ् खे़ङ्‌हाॽनु सोरिक् लाङ्‌घेःक्‍मा हेःक्‍ते़, ");
INSERT INTO lifNT2_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","कर खे़ङ्‌हाॽरे़ खुने़ॽ कुसिङ् मे़निःत्‍छुन्‍ल फाॽआङ् खुन्‍छिॽ मिक्‍किन् थेःक्‍तु पिरुसिआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “मे़ःम्‍बे़, खिन्‍छिॽ थे़मा पाःन्‍निन्‍ने़ के़जे़ङ्‌सुर लाङ्‌गे़घेःक्‍सिबे?” हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽ खुन्‍छिॽ मिङ्‌वा कुधिम् थप्‍पे़त् ये़बे़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","खे़ङ्‌हाॽओ क्‍लिओपास मे़प्‍मनाबा थिक्‍ले़ खुने़ॽ सेःन्‍दोसु, “मे़ःम्‍बे़, खे़ने़ॽ यरुसले़म्‍मो के़न्‌युङ्‌ने़न्‍बि? आइन् ताःन्‍दिक् खे़प्‍मो पोःक्‍खे़बा पाःन्‍निन् खे़ने़ॽ निङ्‌वाॽ के़ङ्‌घोःसुन्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ये़सुरे़ मे़त्तुसि, “मे़ःम्‍बे़, थे़मा पाःन्‍निन्‍बे?” खे़ङ्‌हाॽरे़ नोगप् पिरे़त्‍छु, “नासरतबा ये़सुरे़ कुयाःम्‍बेओआ, खुने़ॽग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा वये़, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिन् नु मे़न्‍छाम्‍गे़न् याप्‍मि लुम्‍मो खुने़ॽ पेलिगे़न् पाःन्‍जाक्‍को नु याःम्‍बक्‍को मुक्‍साम्‍साबा चोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु आनिगे़ हाङ्‌युक्‍पाहाॽरे़ खुने़ॽग सिःमे़ल्‍ले़न् खुम्‍दिङ् मे़बिरुर फाॽआङ् थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽ हुक्‍मे़सुप्‍तुसि, हे़क्‍क्‍याङ् खुने़ॽ सिलाम्‍साक्‍मा सिङ्‌सम्‍दाङ् मे़भोःन्‍दुरो, ");
INSERT INTO lifNT2_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","कर खुने़ॽ इस्राइलिहाॽ चोःक्‌युम्‍भो के़बिबा मना फाॽआङ् आनिगे़ग कुलाम् ओमे़त्तुम्‍बे़आङ् वयिगे़रो॥ खे़न्‍नाङ्धो आल्‍लो कन् हिन्‍दोःक् पोःक्‍खे़बा सुम् ये़न् के़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","आनिगे़ लुम्‍मो कुभा मे़न्‍छुमाहाॽरे़ आनिगे़ निङ्‌वाॽ मे़मासुरो॥ आइन् तानाम्‍सा खे़ङ्‌हाॽ इप्‍पुङ्‌ङो मे़बे, कर खे़ङ्‌हाॽरे़ ये़सुरे़ कुधक्‍किन् खे़प्‍मो मे़ङ्‌घोःसुन्॥ खे़ङ्‌हाॽ मे़नुःक्‍खे़ मे़द्‌ये़आङ् खे़ङ्‌हाॽरे़ माङ्‌लाइङ्‌बाहाॽ मे़निःसुसिबा पाःन्‍निन् नु खे़न् माङ्‌लाइङ्‌बाहाॽरे़ खुने़ॽग कुहिङ्‌वे़त् पोःक्‍खे़आङ् हिङे़रो फाॽआङ् पाःत्ते़त्‍छुबा पाःन्‍निन् मे़जे़क्‍तिगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","हे़क्‍क्‍याङ् आनिगे़ कुभा तेःङ्‌जुम्‍हाॽ इप्‍पुङ्‌दे़न्‍नो मे़बेःल्‍ले़ खे़न् मे़न्‍छुमाहाॽरे़ मे़बाःत्तुबा हे़क्‍केए खे़प्‍मो मे़निःसु, कर खे़ङ्‌हाॽरे़आङ् ये़सुःन् मे़न्‍निःसुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिन्‍छिॽ निङ्‌वाॽइन्‌आक्‍खे़न् साॽरिक् थुङ्‌बाबे! हे़क्‍क्‍याङ् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ मे़बाःत्तुबा पाःन्‍निन् नसाःन् चोःक्‍मा आक्‍खे़न् खिनिॽ निङ्‌वाॽ पाःक्‍पाबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌तुक्‍खे चामाआङ् कुमिमिदिङ्‌ङो पेःक्‍मा के़बोःङ्‌बा वये़ बि मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ आबाङे कुयाःम्‍बेओ मोसारे़ कुसाप्‍पन्‍हाॽ हे़क्‍क्‍याङ् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ खुनिॽ साप्‍पन्‍नो थारिक् कुबेःन् पोधक् चोगु पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़बेर मे़बत्‍छे़बा पाङ्‌भेॽइल्‍ले़ कुबेसाङ् मे़गे़रे़आङ् ये़सुःन् मिसाक् माःङ्‌घा के़बेःक्‍पा लाम्‍सिङ्‌लो, ");
INSERT INTO lifNT2_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","कर खे़ङ्‌हाॽरे़ खुने़ॽ अक्‍खे मे़त्ते़छुर पेलि फाक्‍ते़त्‍छु, “खे़ने़ॽ आन्‍छिगे़नुए आइन् से़न्‍दिक् याङ्‌धोःक्‍ते़ॽओ, थेआङ्‌भे़ल्‍ले़ आल्‍लो नाम्‍ध्‍ये़आङ् खादाम्‍ल पत्‍लो॥” हे़क्‍केःल्‍ले़ खुने़ॽ खे़ङ्‌हाॽनु याङ्‌धोःक्‍से़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","हे़क्‍क्‍याङ् खुने़ॽ चामादे़न्‍नो युङ्‌सिङ्‌ङिल्‍ले़ खरे़ःङ्‌ङिन् खप्‍सु हे़क्‍क्‍याङ् नोगे़न् पिरुआङ् फुॽरुर खे़ङ्‌हाॽ पिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुन्‍छिॽ मिक्‍किन् हरे़आङ् खुने़ॽ कुसिङ् निःत्ते़त्‍छु, कर खे़प्‍मोए खुन्‍छिॽ तगिलाम् खुने़ॽ आलाप्‌पोःक्‍खे़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ अक्‍खे मे़त्‍ने़त्‍छि, “मे़ःम्‍बे़, लाम्‍मो आनिॽ ताॽआजे़क्‍खे़र आभे़रे़र आबत्‍छे़ल्‍ले़ खुने़ॽ साम्‌योसाप्‍लाःन् पोधक् आजोगे़त्‍छि आबिरे़त्‍छिल्‍ले़ आन्‍छिॽ सिक् पसम्‍समे़आङ् वये़बि मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","हे़क्‍क्‍याङ् खिमो ने़प्‍माङ् बा खे़न् ये़म्‍मो पोगे़त्‍छिआङ् यरुसले़म ले़प्‍माङ् थाने़त्‍छिरो॥ खे़प्‍मो थिक्-थिक् (११) हुॽसाम्‍बाहाॽ नु वेॽहाॽ सोरिक् मे़युङे़बा तुमे़त्‍छुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुन्‍छिॽ मे़मे़त्तुसि, “दाङ्‌बान् से़क्‍खाए स्‍ये़आङ् याम्‍मो हिङे़रो, हे़क्‍क्‍याङ् सिमोने़ल्‍लो ओसेःन्‍धाक्‍सिङ्‌बाएरो!” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ अक्‍खेलॽरिक् लाम्‍मो ये़सुःन् तुमे़त्‍छुआङ् पोःक्‍खे़बा पाःन्‍निन् नु चाजामा ये़म्‍मो खुने़ॽ खरे़ःङ्‌ङिन् फुॽरुल्‍ले़ कुसिङ् निःत्ते़त्‍छुबान्‌के़रे़क् चे़क्‍खे़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","हे़क्‍क्‍याङ् आल्‍लसाङ् मे़बारे़र मे़बत्‍छे़ल्‍ले़ ये़सुःन् आबाङे खुनिॽ लुम्‍मो थाःम्‍सिङ्‌ङाङ् मे़त्तुसि, “खिनिॽ सनारुङ् के़घोःसुम्‍लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","हे़क्‍क्‍याङ् के़रे़क्‍ले़ खुनिॽ निङ्‌वाॽ मये़आङ् साॽरिक् मे़गिसे़॥ खे़ङ्‌हाॽरे़ग आल्‍ल सिःसाम्‍मिन्‍ने़ आनिःसुम् फाॽआङ् मे़इःत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “थेआङ् खिनिॽ यङ्‌मा के़रे़बा? हे़क्‍क्‍याङ् खिनिॽ निङ्‌वाॽबो थेआङ् चप्‍चि के़जोगुम्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","आहुक् आलाङ्‌हाॽ ओमे़त्ते़म्‍मे़ॽ! से़क्‍खाए कङ्‌ग इङ्‌गाॽएरो॥ इङ्‌गाॽ आसुःसे़म्‍मे़ॽआङ् ओआमे़त्ते़म्‍मे़ॽ! सिःसाम्‍मिल्‍ले़न्‌इङ्‌गाॽ कत्तुङ्‌बा हे़क्‍के ने़क्‍सा नु ये़प् होःप्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","हे़क्‍के मे़त्तुसिर खुने़ॽ कुलाङ् कुहुक्‍हाॽ ओसेःन्‍धाक्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","खे़ङ्‌हाॽरे़ खुनिॽ सिक् पसम्‍समे़आङ् कन् पाःन्‍निन् से़क्‍खाबि मे़ःम्‍बि फाॽआङ् हःन्‍दा मे़ले़क्‍ते़आङ् मे़ये़बे़रो॥ हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ चामा कुजाधिक् के़गत्तुम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","खे़ङ्‌हाॽरे़ ओॽमनाबा कुले़प्‍थिक् ङा मे़बिरुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ये़सुरे़ खुनिॽ तगाङ्‌ङे़ खे़न् ताःक्‍तुआङ् चदेःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","हे़क्‍क्‍याङ् खुने़ॽ अक्‍खे पाःत्तु, “इङ्‌गाॽ खिनिॽनु वयाङ्‌ङिल्‍ले़साए मोसारे़ साप्‍तुबा साम्‌योथिम् साप्‍लाओ, माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ खुनिॽ साप्‍पन्‍हाॽओ नु साम्‍लो सुम् साप्‍पन्‍नो इङ्‌गाॽ आयाःम्‍बेओ साप्‍ते़बा के़रे़क् पाःन्‍हाॽ के़त्‍लो फाॽआङ् मे़त्‍निङ्‌ङाङ् वयाङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽरे़ साम्‌योसाप्‍लाःन् कुसिङ् मे़निःत्तुर फाॽआङ् खुनिॽ निङ्‌वाॽ हन्‍दुबिरुसिआङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","खे़ङ्‌हाॽ अक्‍खे मे़त्तुसि, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़ङ्‌ग तुक्‍खे चामाए पोःङ्, हे़क्‍क्‍याङ् सिःमाआङ् सुम् ये़न्‍नो याम्‍मो हिङ्‌माए पोःङ् फाॽआङ् साप्‍ते़आङ् पत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","हे़क्‍क्‍याङ् खुने़ॽ कुमिङ्‌ङो लायोलाम् हिन्‍छिङ्‌मा नु ले़प्‍मिरे़न् सुनाइङ्‌ङिन् यरुसले़म्‍मो हेःक्‍माआङ्‌के़रे़क् मे़न्‍छाम् सुवाङ्‌हाॽओ इङ्‌भोःमाए पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","हे़क्‍क्‍याङ् खिनिॽ के़रे़क् कन् पाःन्‍निल्‍ले़न् हिन्‍धोःक्‍मिबा के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","आल्‍ल खे़प्‍से़म्‍मे़ॽओ, इङ्‌गाॽ पानुदिङ् आम्‍बारे़ चोगुबा माङ्‌हे़क्‍किन्‌खिनिॽओ पाङ्‌घुङ् युःसुङ्‌लो, कर निङ्‌वाॽफुमाङ्‌लाम् मुक्‍साम्‍मिल्‍ले़ कुधिम् मे़म्‍बोःङ्‌ङे थारिक् बा कन् ये़क्‌यक्‍कोए वये़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽ बे़थानि थारिक् तेॽरुसिआङ् कुहुक्‍हाॽ थाःङ् फोःक्‍खुर खे़ङ्‌हाॽ मुॽइसाम् थाःसु पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","खे़ङ्‌हाॽ मुॽइसाम् थाःसु पिरुसिर पत्‍छे़ल्‍ले़ खुने़ॽ थाःङ्‌धाःङ् साङ्‌ग्राम्‍पेदाङ् ले़प्‍माङ् पक्‍खे़र पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽ साॽरिक् खुनिॽ सिक् समे़र खुने़ॽ सेवा मे़जोगुआङ् यरुसले़म्‍मो मे़नुःक्‍खे़ मे़बे, ");
INSERT INTO lifNT2_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","हे़क्‍क्‍याङ् चक्‍मे़ल्‍लॽए माङ्‌हिम्‍मो निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा मे़भोःसुर मे़वये़रो॥");
INSERT INTO lifNT2_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","तोलिङ्‌सोमुओ इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़न् नावागे़न् चइःत् ने़मानुःल्‍ले़ तगिए, निङ्‌वाॽफु पाःन्‍जाक्‍किन् वये़रो॥ निङ्‌वाॽफु पाःन्‍जाक्‍किन् निङ्‌वाॽफुमाङ्‌ङिन्‍नु वये़ हे़क्‍क्‍याङ् खुने़ॽग निङ्‌वाॽफुमाङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","खुने़ॽग तोलिङ्‌सोमुओ निङ्‌वाॽफुमाङ्‌ङिन्‍नु वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","खुने़ॽलाम्‍मे नावागे़न् चइःत्तोबा काक् पाःन्‍हाॽ पोःक्‍खे़बारो॥ हे़क्‍क्‍याङ् कन् के़बोःङ्‌बाहाॽओ खुने़ॽ मे़ःन्‍ने थेधिक्‍काङ्‌मे़बोःक्‍खे़न्॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ने़त्तिगे़न् हिङ्‌मन्‍निन् खुने़ॽनु वये़रो॥ हे़क्‍क्‍याङ् खे़न् ने़त्तिगे़न् हिङ्‌मन्‍निल्‍ले़ काक् मे़न्‍छाम् याप्‍मिहाॽ से़न्‍दाङ्‌गे़न् ओःत्ति पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","खे़न् से़न्‍दाङ्‌गे़न् ओःत्तिःङ्‌ग माक्‍चिगे़न् खादाम्‍मो ओःत्‍लो, कर माक्‍चिगे़न् खादाम्‍माल्‍ले़ आप्‍फाल्‍ले़आङ् से़न्‍दाङ्‌गे़न् ओःत्तिःन् मे़न्‍नाःन्‍ने वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाङ्‌घुबा मनाधिक् वये़॥ खे़ल्‍ले़ कुमिङ्‌ङिङ्‌ग युहुन्‍ना वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","काक् मे़न्‍छाम्‍गे़न् याप्‍मिहाॽरे़ खे़न् से़न्‍दाङ्‌गे़न् ओःत्तिःन् नसाःन् मे़जोगुर फाॽआङ् खे़न् ओःत्तिःल्‍ले़ कुयाःम्‍बेओ तोःन्‍दि पिसे़ खुने़ॽ त्‍ये़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","युहुन्‍नाःन् आबाङेग से़न्‍दाङ्‌गे़न् ओःत्ति मे़वये़न्, खुने़ॽग से़न्‍दाङ्‌गे़न् ओःत्तिःल्‍ले़ कुयाःम्‍बेओ मनाहाॽ मे़त्‍छे़रक् त्‍ये़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","के़रे़क् मे़न्‍छाम् सुवाङ्‌हाॽ ओःत्ति के़बिबा खे़न् से़क्‍खादिङ् से़न्‍दाङ्‌गे़न् ओःत्तिःन् इक्‍सादिङ् खाम्‍बेःक्‍मो के़दाःबा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","खुने़ॽ इक्‍सादिङ् खाम्‍बेःक्‍मो वये़ हे़क्‍क्‍याङ् खुने़ॽए इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़न् नावागे़न् चइःत् ने़स्‍सुसाङ् खे़प्‍मो त्‍ये़ःल्‍ले़ खे़ल्‍ले़ कुसिङ् मे़निःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","अक्‍खेलॽरिक् खुने़ॽ आबाङे कुमनाहाॽओ त्‍ये़साङ् खे़ङ्‌हाॽरे़ खुने़ॽ मे़न्‍दाःक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","कर खुने़ॽ नसाःन् के़जोःक्‍पाहाॽ नु निङ्‌वाॽओ के़दाःक्‍पाहाॽ के़रे़क् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमुॽइदाङ्‌साः पोःङ्‌मा युक् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","खे़ङ्‌हाॽग मा-बालाम् सामे़वाःन्‍छिङ्‌बा नु मे़न्‍छाम् निङ्‌वाॽलाम्‍बा सा-ए मे़बोःक्‍खे़बा मे़ःन्, कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़ङ्‌हाॽ आबाङे कुस्‍साः चोगुसिबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","निङ्‌वाॽफु पाःन्‍जाक्‍किन् नासिङ्‌गे़न् थक्‍लादिङ् पोःक्‍खे़आङ् इक्‍सादिङ् खाम्‍बेःक्‍मो आनिॽ लुम्‍मो वये़रो॥ खुने़ॽग लुङ्‌गुम् नु से़क्‍खाःल्‍ले़ कुधिम् चोगे़आङ् कुमिमिदिङ्‌ङिन् आनिःसुम्‍माङ् आवाॽरो॥ खे़न् मिमिदिङ्‌ङिन् पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌लाम् के़दाःबा थिक्‍लक् कुस्‍साःल्‍ले़न् हे़क्‍तङ्‌बा चोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","युहुन्‍नाःल्‍ले़ खुने़ॽ कुयाःम्‍बेओ मनाहाॽ यम्‍बा इक्‍लाःल्‍ले़ अक्‍खे मे़त्तुसि, “इङ्‌गाॽ खुने़ॽ कुयाःम्‍बेओ अक्‍खेलॽरिक् पाःत्तुङ्‌ङाङ् वये़, ‘आएगाङ् के़दाःबाङ्‌ग इङ्‌गाॽनुःल्‍ले़ पयम् यम्‍बारो, थेआङ्‌भे़ल्‍ले़ खुने़ॽ इङ्‌गाॽनुःल्‍ले़आङ् तगिसा वये़रो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","खुने़ॽ कुलुङ्‌गुम् कुधिम्‍लाम् हाङ्‌वासाम्‍मे हाङ्‌वासाम् आघोःसुम्‍माङ् आवाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ साम्‌योथिम्‍मिन् मोसालाम्‍बा आबिरे़, कर लुङ्‌गुम्‍मिन् नु से़क्‍खाःङ्‌ग ये़सु ख्रिस्‍तलाम्‍बाए त्‍ये़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","निङ्‌वाॽफुमाङ्‌ङिङ्‌ग आत्तिल्‍ले़आङ् आप्‍फाल्‍ले़आङ् मे़न्‍निए वाॽरो, कर पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिन्‍नु सोरिक् के़वाॽबा थिक्‍लक् कुस्‍साःल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिन् ओसेःन्‍दाङ् चोगुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","यरुसले़म्‍बा यहुदि लाम्‍लोःबाहाॽरे़ निङ्‌वाॽफुसाम्‍बाहाॽ नु माङ्‌हिम्‍मो सेवा के़जोःक्‍पा ले़बिहाॽ युहुन्‍नाओ खे़ने़ॽ हाःत्‍ने़न्‍बे? लॽरिक् सेःन्‍दोःसे़ मे़बाङ्‌सुसिल्‍ले़ युहुन्‍नाःल्‍ले़ कुदोःन्‍दिन् अक्‍तङ्‌बा चोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","युहुन्‍नाःल्‍ले़ इङ्‌गाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त मे़ःन्‍नारो लॽरिक् कुदोःप्‍मा नोगप् पिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ सेःन्‍मे़दोसु, “हे़क्‍केने़ फाॽग्र खे़ने़ॽ हाःत्‍ने़बे? खे़ने़ॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा एलियाःन्‍ने़न्‍बि?” युहुन्‍नारे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ मे़ःन्‍नाॽरो॥” खे़ङ्‌हाॽरे़ याम्‍मो सेःन्‍मे़दोसु, “खे़ने़ॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाने़बि?” इङ्‌गाॽ मे़ःन्‍नाॽरो लॽरिक् याम्‍मो मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ याम्‍मो सेःन्‍मे़दोसु, “हे़क्‍केने़ फाॽग्र खे़ने़ॽ हाःत्‍ने़बे? आनिगे़ याप्‍मि के़बाङ्‌बाहाॽ थे नोगप् पिरुम्‍सिम्‍बे़बाबे? खे़ने़ॽ हाःत्‍ने़बे फाॽआङ् से़क्‍खा याप्‍मि आमे़त्ते़ॽओ?” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","युहुन्‍नारे़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ कुबाःन् सुत्‍लाओ खे़ङ्‌हाॽ नोगप् पिरुसि, “इङ्‌गाॽग दाङ्‌बाल्‍ले़ कुलाम्‍मिन् तोःन्‍दोःन्‌चोगे़म्‍मे़ॽ लॽरिक् एःक्‍सादे़न्‍नो के़अःक्‍पा इक्‍लाआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","हे़क्‍क्‍याङ् यहुदिहाॽरे़ मे़बाङ्‌घुसिबा खे़न् फरिसिहाॽरे़ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़सेःन्‍दे़बा ख्रिस्‍त, एलिया हे़क्‍क्‍याङ् आनिगे़ हाङ्‌घुम्‍बे़बा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्‍नाङ् मे़ःन्‍ने़ फाॽग्र थेआङ् बप्‍तिस्‍मा के़बिरुसिबाबे लॽरिक् सेःन्‍मे़दोसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","हे़क्‍केःल्‍ले़ युहुन्‍नारे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “इङ्‌गाॽग च्‍वाःत्तिल्‍ले़ बप्‍तिस्‍मा पिरुङ्‌सिङ्‌लो, कर खिनिॽ लुम्‍मो कुसिङ् के़न्‍निःत्तुम्‍मिन्‍बा मनाधिक् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","इङ्‌गाॽ आएगाङ् के़दाःबाङ्‌ग खुने़ॽएरो॥ इङ्‌गाॽग योःक् कुइसिःक् कुलाङ्‌सुःप्‌नाम्‍हाॽ फाःङ्‌माआङ् मे़लाॽआन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","कन् पाःन्‍निङ्‌ग यर्दन यङ्‌घङ्‌ङिल्‍ले़ नाधाःम्‍बिबा बे़थानि पाङ्‌भेॽओ पोःक्‍खे़आङ् वये़, खे़प्‍मोए युहुन्‍नाःल्‍ले़ बप्‍तिस्‍मा पिरुसिर यागे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","कुदाःन्‍दिक्‍मा युहुन्‍नाःल्‍ले़ ये़सुःन् खुने़ॽ ले़प्‍माङ् फे़रे़र पत्‍छे़बा निःसुआङ् अक्‍खे पाःत्तु, “ओमे़त्ते़म्‍मे़ॽ, इक्‍सादिङ् खाम्‍बेःक्‍मोबा लायो लासोःत्‍हाॽ के़गुबाआङ् के़देॽबा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमे़ल्‍लुक्‍साःन् खा फे़न्‍ल पत्‍लो! ");
INSERT INTO lifNT2_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","आएगाङ् के़दाःबाङ्‌ग इङ्‌गाॽनुःल्‍ले़ पयम् यम्‍बारो, थेआङ्‌भे़ल्‍ले़ खुने़ॽ इङ्‌गाॽनुःल्‍ले़आङ् तगिसा वये़रो लॽरिक् इङ्‌गाॽ खुने़ॽ कुयाःम्‍बेओए पाःत्तुङ्‌ङाङ् वये़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","तगिग इङ्‌गाॽ आबाङेआङ् खुने़ॽ कुसिङ् मे़न्‍निःत्ते वयाङ् कर खुने़ॽ इस्राइल लाजेॽओ ओसेःन्‍धाक्‍सिङ्‌ल फाॽआङ् च्‍वाःत्तो बप्‍तिस्‍मा पिरुङ्‌सिङ्‌ल त्‍याङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","हे़क्‍क्‍याङ् युहुन्‍नाःल्‍ले़ याम्‍मो पाःत्तु, “इङ्‌गाॽ सेसेमाङ्‌ङिन् साङ्‌ग्राम्‍पेदाङ्‌ङोलाम् पुत्तुःक्‍के हे़क्‍के खुने़ॽओ चुक्‍ते़आङ् युङे़बा निःसुङ्‌लो ");
INSERT INTO lifNT2_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","खुने़ॽए ख्रिस्‍तरो फाॽआङ् कुसिङ् मे़न्‍निःप्‍पे़न्‍लो, कर च्‍वाःत्तो बप्‍तिस्‍मा पिसे़ याप्‍मि के़बाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ आत्तिन् सम्‍दाङ् सेसेमाङ्‌ङिन् युःआङ् चुक्‍पा के़निःसुॽ, खे़ने़ॽ के़हाङ्‌घुबाङ्‌ग खुने़ॽएरो, हे़क्‍क्‍याङ् खुने़ॽए सेसेमाङ्‌ङिल्‍ले़ बप्‍तिस्‍मा पिरुसिॽ फाॽआङ् मे़त्ताङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","हे़क्‍क्‍याङ् कन् पाःन्‍हाॽ ये़सुओ पोःक्‍खे़बा निःसुङ्‌ङाङ् खुने़ॽए निङ्‌वाॽफुमाङ्‌ङिल्‍ले कुस्‍साः फाॽआङ् कुसिङ् निःत्तुङ्‌ङाङ् मनाहाॽ तोःन्‍दि पिरुङ्‌सिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","कुदाःन्‍दिक्‍मा याम्‍मो युहुन्‍नाःन् ने़प्‍फु कुहुॽसाम्‍बाहाॽनु खे़प्‍मो वये़ल्‍ले़, ");
INSERT INTO lifNT2_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ये़सुःन् खुनिॽ पेसाङ्‌लाम् पेर पत्‍छे़बा निःसुआङ् युहुन्‍नाःल्‍ले़ खुने़ॽ ओमे़त्तुर अक्‍खे पाःत्तु, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमे़ल्‍लुक्‍साःन् ओमे़त्ते़म्‍मे़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","युहुन्‍नाःल्‍ले़ हे़क्‍के पाःत्तुबा कुहुॽसाम्‍बाहाॽरे़ खे़प्‍से़त्‍छुआङ् ये़सुःन् तिम्‍दे़सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ये़सुःन् एगाङ् हिसिङ्‌ङिल्‍ले़ खे़ङ्‌हाॽ कुएगाङ् फे़रे़त्‍छिबा निःसुसिआङ् सेःन्‍दोसुसि, “खिन्‍छिॽ थे़माःन् के़गोःत्‍छुर के़वाॽसिबाबे?” खे़ङ्‌हाॽरे़ नोगप् पिरे़त्‍छु, “रब्‍बि (खे़न् फाॽइङ्‌ग ‘सिक्‍साम्‍बे’ पोःङ्‌लो) खे़ने़ॽ आत्तो के़याःक्‍पे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “फे़रे़त्‍छे़ॽआङ् ओमे़त्ते़त्‍छे़ॽ॥” हे़क्‍क्‍याङ् खे़ङ्‌हाॽ कुमुक् लिसि (४) मुक्‍ते़आङ् वये़ल्‍ले़ पेसिआङ् खे़ङ्‌हाॽरे़ ये़सुःन् युङे़बा ते़न्‍निन् ओमे़त्ते़त्‍छु॥ खे़ङ्‌हाॽ खे़न् ये़न् ये़सुःन्‍नुए याःक्‍ते़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","खे़न् ने़प्‍फुहाॽओ थिक्‍किङ्‌ग सिमोन पत्रुसरे़ कुन्‍साॽ आन्‍द्रियासे़न् वये़रो॥ खुने़ॽग बप्‍तिस्‍मा के़बिबा युहुन्‍नाःल्‍ले़ पाःत्तुबा के़घे़म्‍बा नु ये़सुःन्‍नु लाङ्‌गे़घेःक्‍पा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","अन्‍द्रियासरे़ काक्‍नु तगि कुम्‍भुॽ सिमोने़न्‌तुमुआङ् मे़त्तु, “आन्‍छिगे़ मसिह मे़प्‍मनाबा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌तुमे़त्‍छुगे़रो” (ग्रिक पाःन्‍दाङ्‌ङो “‘ख्रिस्‍त’ पोःङ्, हिब्रु पाःन्‍दाङ्‌ङो ‘मसिह’” पोःङ्‌लो)॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","हे़क्‍क्‍याङ् अन्‍द्रियासरे़ सिमोने़न् ये़सुरो तारुल्‍ले़ ये़सुरे़ नुःरिक् ओमे़त्तुर अक्‍खे मे़त्तु, “खे़ने़ॽग युहुन्‍नाःल्‍ले़ कुस्‍साः सिमोन्‍ने़रो, हे़क्‍क्‍याङ् खे़ने़ॽग के़फास लॽरिक् के़म्‍मे़त्‍लो” (खे़न् फाॽइङ्‌ग “पत्रुस” पोःङ्)॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","हे़क्‍क्‍याङ् कुदाःन्‍दिक्‍मा ये़सुरे़ गालिल थुम्‍मो पेःक्‍मा निङ्‌वाॽ चोगु॥ खुने़ॽ फिलिप्‍पे़न् तुमुआङ् अक्‍खे मे़त्तु, “इङ्‌गाॽ तिम्‍दाङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","आल्‍ल फिलिप्‍पे़ङ्‌ग, आन्‍द्रियास नु पत्रुसरे़ खुन्‍छिॽ बे़थसेदा पाङ्‌जुम् के़युङ्‌बा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिपरे़ नाथाने़ल्‍ले़न् तुमुआङ् मे़त्तु, “आनिगे़ग मोसा नु माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़आङ् साम्‌योसाप्‍लाओ मे़साप्‍तुआङ् के़बप्‍पा युसुफरे़ कुस्‍साः नासरतबा ये़सुःन् तुमुम्‍बे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","हे़क्‍केःल्‍ले़ नाथाने़लरे़ कुनिङ्‌वाॽ मये़र पाःत्तु, “मे़ःम्‍बे़! नासरतलाम् नुःबा पाःन्‍हाॽ ताबि हौ?” हे़क्‍केःल्‍ले़ फिलिपरे़ मे़त्तु, “खे़ने़ॽ आबाङे फे़रे़ॽआङ् ओमे़त्ते़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ये़सुरे़ नाथाने़ल्‍ले़न् निःत्ताङ् फे़रे़र पत्‍छे़बा निःसुआङ् मे़त्तु, “ओमे़त्ते़म्‍मे़ॽओ, से़क्‍खाबा इस्राइलिःन् फे़न्‍ल पत्‍लो॥ खुने़ॽ कुनिङ्‌वाॽबो थेआङ् ताप्‍फे़ःम्‍बा होःप्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","हे़क्‍केःल्‍ले़ नाथाने़लरे़ सेःन्‍दोसु, “मे़ःम्बे़, खे़ने़ॽ आक्‍खेलॽरिक् इङ्‌गाॽ कुसिङ् के़निःत्ताङ्‌बे?” ये़सुरे़ नोगप् पिरु, “फिलिपरे़ मे़न्‍उःत्ते के़वये़ल्‍ले़सा खे़ने़ॽग पःत्‍छेॽ बुङ्‌मो के़वये़बा निःने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नाथाने़लरे़ नोगप् पिरु, “सिक्‍साम्‍बे, खे़ने़ॽग निङ्‌वाॽफुसाःने़रो, खे़ने़ॽग इस्राइलबा हाङ्‌ने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ये़सुरे़ खे़न् मे़त्तु, “मे़ःम्‍बे़! खे़ने़ॽ पःत्‍छेॽ बुङ्‌मो के़वये़बा निःने़ लॽरिक् मे़त्‍ने़बाल्‍ले़ चोगुल्‍ले़सा नसाःन् के़जोगुबाबि? कर कन्‍नुःल्‍ले़आङ् यम्‍बा पाःन्‍हाॽ के़निःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","खुने़ॽ आल्‍लसाङ् योॽरुर पाःत्तु, “खे़ने़ॽ से़क्‍खाए मे़त्‍ने़ॽ, साङ्‌ग्राम्‍पेदाङ्‌ङिन् हन्‍नाङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमाङ्‌लाइङ्‌बाहाॽ मे़न्‍छाम्‍साःओ मे़युबा नु थाःङ् मे़बेःक्‍पा के़निःसुसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","हे़क्‍क्‍याङ् निये़न् एगाङ् गालिल थुम्‍मोबा काना पाङ्‌जुम्‍मो ते़न्‍धाम्‍गे़न् मेःक्‍खिम्‍मो ये़सुरे़ कुम्‍मा मरियम्‍मिन् तरे वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ये़सुःन् नु कुहुॽसाम्‍बाहाॽआङ् मे़उःत्तुसिआङ् खे़प्‍मो मे़बेआङ् मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","खे़न् ते़न्‍धाम्‍गे़न् मेःक्‍खिम्‍मो चे़ल्‍ले़क्‍सेॽ थिःन् माःरे़ल्‍ले़ ये़सुरे़ कुम्‍मा पेआङ् ये़सुःन् मे़त्तु, “आल्‍ल खे़ङ्‌हाॽरे़ चे़ल्‍ले़क्‍सेॽ थिःन् मिःसाक्‍काङ् मे़ङ्‌गत्तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","हे़क्‍केःल्‍ले़ ये़सुरे़ नोगप् पिरु, “आम्‍मौ, थेआङ् कन् पाःन्‍निन् इङ्‌गाॽ के़मे़त्ताबाबे? थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आयाःम्‍बक् चोःक्‍मा ये़म्‍मिन् आल्‍ल थारिक् मे़न्‍दाए वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","कर कुम्‍मा पेआङ् खे़प्‍मोबा सेवारोबाहाॽ मे़त्तुसि, “खुने़ॽ पाःत्तुबा हे़क्‍केए चोगे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","खे़प्‍मो यहुदि सेसे चोःक्‍सिङ्‌मा थिम्‍मो ओगप् चोःक्‍मनाबा च्‍वाःत् याङ्‌मा तुक्‍सि (६) यम्‍बा खोःम्‍मनाबा लुङ् कुःन्‍दाहाॽ मे़युङे़॥ खे़न् थिक्‍को सुम्‍बोःङ् (३०) पाथि थारिक् च्‍वाःत् के़हप्‍पा चोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ये़सुरे़ खे़न् सेवारोबाहाॽ मे़त्तुसि, “कन् कुःन्‍दाहाॽ च्‍वाःत्तिल्‍ले़ कुले़म् थिम्‍से़म्‍सिम्‍मे़ॽ॥” हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़आङ् कुःन्‍दाहाॽ कुले़ःम् कुले़ःम् मे़धिम्‍सुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “कन् मिसाक् पागे़म्‍मे़ॽआङ् मेःक्‍खिम्‍मो चामुक् थिमुक् ओगे़मे़प्‍पे़न्‌पिरे़म्‍मे़ॽओ,” हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़आङ् खुने़ॽ पाःत्तुबा कुइसिःक् मे़जोगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","हे़क्‍क्‍याङ् खे़न् मेःक्‍खिम्‍मोबा चामुक् थिमुक् ओगे़मे़प्‍पाल्‍ले़ च्‍वाःत्‍लाम् के़बोःङ्‌बा चे़ल्‍ले़क्‍सेॽ थिःन् साॽरु॥ खे़न् आत्तोलाम् त्‍ये़बा खे़ल्‍ले़ थेआङ् मे़निःसुन्‍लो, कर खे़न् च्‍वाःत् के़भाःप्‍पा सेवारोबाहाॽरे़रक् मे़निःसुरो॥ खे़ल्‍ले़ मेःक्‍खिम्‍साबान् थिक्‍ले़प्‍माङ् उःत्तु तेॽरुआङ् मे़त्तु, ");
INSERT INTO lifNT2_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“वेॽ मनाहाॽरे़ग काक्‍नुःल्‍ले़ तगि कुजा के़नुॽबा चे़ल्‍ले़क्‍सेॽ थिःन् मे़हासुॽ, हे़क्‍क्‍याङ्‌मनाहाॽरे़ यरिक् मे़धुङुआङ् मयुसिॽ हे़क्‍क्‍याङ्‌लक् वाजेरेबा चे़ल्‍ले़क्‍सेॽ थिःन् मे़हासुरो कर खे़ने़ॽग आल्‍लो थारिक् कुजा के़नुॽबा चे़ल्‍ले़क्‍सेॽ थिःन्‍ने के़दाङ्‌घुआङ् के़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ये़सुरे़ काक्‍नुःल्‍ले़ तगिबा कन् निङ्‌वाॽ के़माबा मिक्‍सेःन्‍निन् गालिल थुम्‍मोबा काना पाङ्‌जुम्‍मो चोगु॥ हे़क्‍केलॽरिक् कुमिमिदिङ्‌ङिन् ओसेःन्‍दाङ् चोगुआङ् कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ नसाःन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","खे़न् कानाबा मेःक्‍खिम् एगाङ् खुने़ॽ कुम्‍मा कुन्‍साॽसि हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽनु कपर्नहुम पाङ्‌जुम्‍मो पे, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ खे़प्‍मो कुभा ये़न् मे़याःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","कन् यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मिन् निःत्ताङ् त्‍ये़र पत्‍छे़ल्‍ले़ ये़सुःन् थो यरुसले़म्‍मो पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","हे़क्‍क्‍याङ् माङ्‌हिम्‍मो ले़ङ्‌हङ्‌बाहाॽरे़ पित्‍हाॽ, मे़ल्‍लुक्‍हाॽ, पुत्तुःक्‍केहाॽ सिदुङ्‌जभा के़जोःक्‍पाहाॽरो मे़सङ्‌घुबा नु खे़प्‍मो याङ् के़ले़क्‍पाहाॽआङ् याङ् ले़क्‍नु मे़युङे़बा खुने़ॽ निःसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ये़सुरे़ इदाःक्‍किल्‍ले़न् ते़ःम्‍भुक् चोगुआङ् खे़न् के़रे़क् मे़ल्‍लुक्‍हाॽ नु पित्‍हाॽ माङ्‌हिम्‍लाम् लाःक्‍कात् नाःत्तुदेःसुसिआङ् याङ् के़ले़क्‍पाहाॽरे़ खुनिॽ याङ्‌इत्‍छिहाॽआङ् से़ःसु पिरुसिर खुनिॽ साप्‍ने़त्‍हाॽआङ् ले़क्‍खु पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् पुत्तुःक्‍के के़सङ्‌बाहाॽ मे़त्तुसि, “कङ्‌हाॽ तेॽरे़म्‍सिम्‍मे़ॽआङ् लाःक्‍कात् लःन्‍दे़म् पेगे़म्‍मे़ॽ! खिनिॽ थेआङ् आम्‍बारे़ कुहिम्‍मिन् सङ्‌इङ्‌दे़न् के़जोगुम्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽरे़ के़हिम्‍मिल्‍ले़ लागि मिःम्‍जिःल्‍ले़ इङ्‌गाॽ थुक्‍कारो लॽरिक् साम्‌योसाप्‍लाओ के़बप्‍पे़न्‌निङ्‌वाॽ मे़इःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","हे़क्‍केःल्‍ले़ कुभा यहुदि लाम्‍लोःबाहाॽरे़ खुने़ॽ सेःन्‍मे़दोसु “थे़मा युक्‍किल्‍ले़ खे़ने़ॽ अक्‍खे के़जोगुबाबे? कन् युक्‍किन् निङ्‌वाॽफुमाङ्‌लाम्ने़ फाॽग्र निङ्‌वाॽ के़माबा मिक्‍सेःन् याप्‍मि ओसेःन्‍आधाक्‍ते़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","हे़क्‍केःल्‍ले़ ये़सुरे़ नोगप् पिरुसि, “पोःङ्, कन् माङ्‌हिम्‍मिन् यःसे़म्‍मे़ॽ हे़क्‍क्‍याङ् इङ्‌गाॽ सुम्‌ये़न्‍नो याम्‍मो चोगुङ्॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","यहुदिहाॽरे़ खुने़ॽ मे़मे़त्तु, “आक्‍खेमु? कन् माङ्‌हिम्‍मिन् तङ्‌बे लि-तुक्‍कोरक् (४६) चोःक्‍मा चुरे़ल्‍ले़ खे़ने़ॽ सुम्‌ये़न्‍नोए के़जोगुॽमु!” ");
INSERT INTO lifNT2_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","कर ये़सुरे़ पाःत्तुबा माङ्‌हिम्‍मिङ्‌ग आबाङे कुधक्‍किल्‍ले़ कुयाःम्‍बेओ पाःत्तुआङ् वये़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ताःन्‍दि खुने़ॽ सिःमे़न्‍लाम् कुहिङ्‌वे़त् पोःक्‍खे़आङ्‌लक् खुने़ॽ पाःत्तुबा खे़न् पाःन्‍निन् कुहुॽसाम्‍बाहाॽरे़ निङ्‌वाॽ मे़इःत्तु, हे़क्‍क्‍याङ् ये़सुरे़ पाःत्तुआङ् वये़बा पाःन्‍जाक्‍हाॽ नु साम्‌योसाप्‍लाःन् नसाःन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","खुने़ॽ यरुसले़म्‍मो वये़ल्‍ले़ यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मो चोगुबा निङ्‌वाॽ के़माबा याःम्‍बक्‍किन् यरिक् मनाहाॽरे़ मे़निःसुआङ् खुने़ॽ नसाःन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","कर ये़सुरे़ खे़ङ्‌हाॽ ताःक्‍पो मे़जोगुन्‍सिन्‌, थेआङ्‌भे़ल्‍ले़ काक् मनाहाॽ आक्‍तङ्‌बा मे़जोःक् फाॽआङ् कुसिङ् निःत्तुसिआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","आत्तिल्‍ले़आङ् मनाहाॽरे़ खुनिॽ याःम्‍बेओ खुने़ॽ मे़प्‍मा मे़बोःक्‍खे़न्‍लो, थेआङ्‌भे़ल्‍ले़ मनाहाॽ आक्‍तङ्‌बा मे़जोःक् फाॽआङ् खुने़ॽ निःसुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","आल्‍ल निकोदेमस मे़प्‍मनाबा लत्‍छा फरिसिधिक्‌वये़, खे़ङ्‌ग यहुदि ये़जुम्‍भोरे़न् पासिङ्पादाङ्‌लाआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","थिक् से़न्‍दिक् खे़न् ये़सुरे़ कुदुम्‍से़ पेआङ् मे़त्तु, “सिक्‍साम्‍बे, खे़ने़ॽग निङ्‌वाॽफुमाङ्‌लाम्‍मे के़द्‌ये़बारो फाॽआङ् आनिगे़ कुसिङ् निःत्तुम्‍बे़रो॥ थेआङ्‌भे़ल्‍ले़ खे़ने़ॽ के़जोगुबा निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽग आत्तिन् मनाःल्‍ले़आङ् खुने़ॽनु निङ्‌वाॽफुमाङ्‌ङिन् मे़वाॽने़न्‍निल्‍ले़ग हे़क्‍के चोःक्‍मा मे़सुक्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ये़सुरे़ खे़न् मे़त्तु, “इङ्‌गाॽ से़क्‍खाए मे़त्‍ने़ॽ, याम्‍मो सामे़न्‌वाःन्‍छिङ्‌ङे थारिक् आत्तिल्‍ले़आङ् निङ्‌वाॽफुहाङ्‌जुम्‍मिन् निःमा मे़सुक्‍तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","हे़क्‍केःल्‍ले़ निकोदेमसरे़ कुनिङ्‌वाॽ मये़र सेःन्‍दोसु, “मे़ःम्‍बे़, आक्‍खेलॽरिक् खदाक्‍मि याप्‍मिःन् याम्‍मो सावाःन्‍छिङ्‌बे? खे़न् से़क्‍खाए कुम्‍मारे़ कुसाप्‍पोःक् सिगाङ् याम्‍मो लाःत्ताङ् सावाःन्‍छिङ्‌मा सुक्‍पि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ये़सुरे़ नोगप् पिरु, “इङ्‌गाॽ से़क्‍खाए मे़त्‍ने़ॽ, च्‍वाःत् नु सेसेमाङ्‌लाम्‍बा सामे़न्‌वाःन्‍छिङ्‌ङे थारिक् निङ्‌वाॽफुहाङ्‌जुम्‍मो आत्तिन्‍नाङ् लाःप्‍मा मे़सुक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","नासिङ्‌गे़न् थक्‍लाम्‍बाग नासिङ्‌गे़न् थक्‍किन्‍ने सावाःन्‍छिङ्‌हे़क्‍क्‍याङ् सेसेमाङ्‌लाम् याम्‍साम्‍मिन् कुसङ्‌ङाङ् सावाःन्‍छिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","हे़क्‍केःल्‍ले़ ‘खे़ने़ॽ याम्‍मो सागे़वाःन्‍छिङ्‌लए पोःङ्’ मे़त्‍ने़ल्‍ले़ के़निङ्‌वाॽ मे़मये़न्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","सुरित्‌केजङ्‌ङिन् आत्तान्‍साङ् हुःमा सुक्‍लो॥ खे़ने़ॽ सुरित्‌केजङ्‌ङिन् हुःबा के़घे़प्‍सुॽ, कर आत्तोलाम् ताः हे़क्‍क्‍याङ् आत्तो पेःक् खे़न् खे़ने़ॽ पाःप्‍मा के़न्‍छुक्‍तुन्‍लो॥ हे़क्‍केलॽरिक्‍के सेसेमाङ्‌लाम्‍बा सावाःन्‍छिङ्‌मा पाःन्‍निन्‍नाङ् पोधक्‍मा सुक्‍मे़दे़त्‍ने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","हे़क्‍केःल्‍ले़ निकोदेमसरे़ सेःन्‍दोसु, “हे़क्‍केने़ फाॽग्र खे़न् आक्‍खेलॽरिक् पोःङ्‌मा सुक्‍पे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","हे़क्‍क्‍याङ् ये़सुरे़ नोगप् पिरु, “खे़ने़ॽग इस्राइलबा सिक्‍साम्‍बाने़ हे़क्‍केसाङ् कन् पाःन्‍हाॽ कुसिङ् के़न्‍निःत्तुम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","इङ्‌गाॽ से़क्‍खाए खे़ने़ॽ मे़त्‍ने़ॽरो॥ आनिगे़ निःसुम्‍बे़ ले़स्‍सुम्‍बे़बा पाःन्‍हाॽए खिनिॽ मे़त्तासिगे़ॽ, करसाङ् आनिगे़ पाःत्तुम्‍बे़बा पाःन्‍निन् खिनिॽ नसाःन् के़न्‍जोगुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","इङ्‌गाॽ इक्‍सादिङ् खाम्‍बेःक्‍मोबा पाःन्‍हाॽ खिनिॽ मे़त्‍निङ् हे़क्‍केसाङ् नसाःन् चोःक्‍मा के़न्‍छुक्‍तुम्‍मिन्॥ हे़क्‍केःल्‍ले़ साङ्‌ग्राम्‍पेदाङ्‌ङोबा पाःन्‍हाॽ मे़त्‍निङ्‌ङिल्‍ले़ आक्‍खेलॽरिक् नसाःन् चोःक्‍मा के़सुक्‍तुम्‍बे? ");
INSERT INTO lifNT2_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","साङ्‌ग्राम्‍पेदाङ्‌लाम् के़युःबा इङ्‌गाॽ मे़न्‍छाम्‍साःन्‍नुःल्‍ले़ वेॽ आत्तिन्‍नाङ् साङ्‌ग्राम्‍पेदाङ्‌ङो थाःङ् मे़म्‍बेःक्‍के वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","इस्राइलिहाॽ ये़ःङ्‌घादे़न्‍नो लाम्‍दिःक् मे़जोगे़ल्‍ले़ मोसारे़ पित्तोलि असेःक्‍पे़न्‌पक्‍खुबा कुइसिःक्‍के मे़न्‍छाम्‍साःन्‍नाङ् पङ्‌लए पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","हे़क्‍केलॽरिक् खुने़ॽओ नसाःन् के़जोःक्‍पा के़रे़क्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् मे़घोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मोबा मे़न्‍छाम् याप्‍मिहाॽ साॽरिक् लुङ्‌माॽ तुक्‍तुसिबाल्‍ले़ चोगुल्‍ले़ खुने़ॽ थिक्‍लक् कुस्‍साःन् पाङ्‌घु युःसुरो, हे़क्‍केलॽरिक् खुने़ॽ नसाःन् के़जोःक्‍पाहाॽग मे़म्‍मे़क्‍ने़न्, कर खे़ङ्‌हाॽरे़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् मे़घोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मो कुस्‍साःन् मे़न्‍छाम् याप्‍मिहाॽ आप्‍तिक् कुःप्‍मासि फाॽआङ् पाङ्‌घुबा मे़ःन्‍लो कर खे़ङ्‌हाॽ ताङ्‌से़ःप्‍तुसिर फाॽआङ् पाङ्‌घुबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","खुने़ॽओ नसाःन् के़जोःक्‍पाहाॽरे़ग खुम्‍दिङ् मे़ङ्‌घोःसुन्‍लो कर खुने़ॽओ नसाःन् मे़न्‍जोःक्‍मनाहाॽरे़ङ्‌ग तगिए खासे़न् पोःक्‍खे़ चुरे़आङ् वाॽरो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ थिक्‍लक् कुस्‍साःओ नसाःन् मे़न्‍जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","खुनिॽ खासे़न्‍निन् बा कन्‍लो, साङ्‌ग्राम्‍पेदाङ्‌लाम् से़न्‍दाङ्‌गे़न् ओःत्तिःन् ये़ कर खे़ङ्‌हाॽरे़ खुनिॽ याःम्‍बक्‍किन् ताप्‍फे़ःम्‍बा चोगे़बाल्‍ले़ खे़ङ्‌हाॽरे़ ओःत्तिन्‍नुःल्‍ले़ खादाम्‍मान्‍ने खुनिॽ सिराॽ थाङे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","फे़न् याःम्‍बक् के़जोःक्‍पा के़रे़क्‍ले़ ओःत्तिःन् मे़जिःत्तुॽरो हे़क्‍क्‍याङ् खुनिॽ फे़न् याःम्‍बक्‍किन् निधाःप् फाॽआङ् मे़गिआङ् से़न्‍दाङ्‌गे़न् ओःत्तिओ मे़न्‍दाःने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","कर आत्तिन्‍हाॽ से़क्‍खाओ लाङ्‌मे़घेःक् खे़ङ्‌हाॽरे़ खुनिॽ याःम्‍बक्‍किन् निङ्‌वाॽफुमाङ्‌ङो मे़जोगुआङ् वाॽ के़लॽबान् नुःरिक्‍काङ् निधाःप्‍ल फाॽआङ् खे़ङ्‌हाॽ ओःत्तिओ मे़दारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","खे़न् एगाङ् ये़सुःन् नु कुहुॽसाम्‍बाहाॽ यरुसले़मलाम्‍बा यहुदिया थुम् कब्रिङ्‌बा लाजेॽओ मे़बेआङ् खे़प्‍मो खुने़ॽ खे़ङ्‌हाॽनु वये़ल्‍ले़ बप्‍तिस्‍मा पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","खे़न् ये़म्‍मो युहुन्‍नाःन् सालिम् पाङ्‌जुम्‍मिल्‍ले़ कुबेसाङ् एनोन मे़प्‍मनाबा ते़न्‍नो बप्‍तिस्‍मा पिरुसिर यागे़ थेआङ्‌भे़ल्‍ले़ खे़प्‍मो यरिक् च्‍वाःत् ने़स्‍से़आङ् मनाहाॽ बप्‍तिस्‍मा पोःङ्‌से़ खे़प्‍मो मे़द्‌ये़र मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(कन् बप्‍तिस्‍मा पिमा याःम्‍बक्‍किङ्‌ग युहुन्‍नाःन् पुङ्‌लाहिम्‍मो साक्‍मानुःल्‍ले़ तगिबा पाःन् वये़रो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","युहुन्‍नाःल्‍ले़ कुभा कुहुॽसाम्‍बाहाॽ यहुदिधिक्‍नु सेसे चोःक्‍सिङ्‌मा थिम्‍मिल्‍ले़ कुयाःम्‍बेओ पाःन्‍धङ् पोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","युहुन्‍नारे़ कुहुॽसाम्‍बाहाॽ मे़द्‌ये़आङ् खुने़ॽ मे़मे़त्तु, “सिक्‍साम्‍बे, यर्दन यङ्‌घङ्‌ङिल्‍ले़ नाधाःम्‍बि खे़ने़ॽनु के़वाॽबाल्‍ले़ कुयाःम्‍बेओ खे़ने़ॽ तोःन्‍दि के़बिरुबा मनाःल्‍ले़ बप्‍तिस्‍मा पिरुसिर याक्‍लो॥ आनिॽओ के़रे़क् मनाहाॽ तामारे़ कुले़क्‌वा खुने़ॽओ मे़बेःक्‍ल मे़बत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","युहुन्‍नारे़ खे़न् नोगप् पिरु, “साङ्‌ग्राम्‍पेदाङ्‌लाम् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ मे़म्‍बिएग मनाःल्‍ले़ थे़माआङ् खोःमा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","इङ्‌गाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त मे़ःन्‍नाॽरो कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽनुःल्‍ले तगि पाङ्‌घाङ्‌बारक् फाॽआङ् पाःत्तुङ्‌बा पाःन्‍निन् खिनिॽए तोःन्‍दि पिमा के़सुक्‍तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","सिसामेःत्तिङ्‌ग नालिसाङ्‌ङिल्‍ले़न्‍नेरो॥ नालिसाङ्‌ङिन् आत्तो वाॽ, खे़प्‍मोए सिसामेःत्तिन् पेःक्‍लो॥ नालिसाङ्‌ङिन् कुन्‍देःङ्‌बाल्‍ले़ हाङ्‌घुआङ् खुने़ॽ कुबाःन् खे़प्‍सुॽ हे़क्‍क्‍याङ् खुने़ॽ ताःल्‍ले़ सःत्‍लो॥ इङ्‌गाॽआङ् हे़क्‍केलॽरिक् सःत्तारो हे़क्‍क्‍याङ् आल्‍ल आसःप्‍मे़न् कुलिङ्‌धो के़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ख्रिस्‍तरे़ कुमिङ्‌सो इङ्‌धाःङ् हाराॽ पोःर पेःक्‍लरो, इङ्‌गाॽग चुक्‍पा पोःङ्‌माए पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","साङ्‌ग्राम्‍पेदाङ्‌लाम् के़युःबान्‍नुःल्‍ले़ यम्‍बाग आत्तिन्‍नाङ् होःप्‍लो॥ इक्‍सादिङ् खाम्‍बेःक्‍मोलाम्‍बा के़बोःङ्‌बाङ्‌ग खाम्‍बेःक्‍मोबाएरो हे़क्‍क्‍याङ् खे़ल्‍ले़ग खाम्‍बेःक्‍मोबा पाःन्‍निन्‍लक् पाःत्तुॽ, कर साङ्‌ग्राम्‍पेदाङ्‌लाम् के़युःबान्‍ने के़रे़क्‍नुःल्‍ले़ यम्‍बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","खुने़ॽग निःसुबा नु खे़प्‍सुबा पाःन्‍हाॽए पाःत्तुॽ, कर आत्तिल्‍ले़आङ् खुने़ॽ कुबाःन्‍निन् नसाःन् मे़जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","आत्तिल्‍ले़ खुने़ॽ नसाःन् चोगुॽ, खे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिन् से़क्‍खा चोःक् फाॽआङ् पर्माङ्‌गि पिरुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","थेआङ्‌भे़ल्‍ले़ खुने़ॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाङ्‌घुबारो॥ खे़ल्‍ले़ निङ्‌वाॽफुपाःन्‍लक् पाःत्तुॽरो, थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़न् सेसेमाङ्‌ङिल्‍ले़ कुधिम् थिम्‍सुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","पानुदिङ् पाःल्‍ले़ आबाङे कुस्‍साःन् लुङ्‌माॽ तुक्‍तुॽ, हे़क्‍क्‍याङ् काक् पाःन्‍हाॽ कुहुक्‍को पिरुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","निङ्‌वाॽफुसाःन् नसाःन् के़जोःक्‍पा के़रे़क्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् मे़घोःसुॽरो॥ आबुगे़न् कुस्‍साःन् नसाःन् मे़न्‍जोःक्‍मनाबाहाॽरे़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् आप्‍फाल्‍ले़आङ् मे़ङ्‌घोःसुन्‍लो, कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसाक्‍के़न्‍निन् खे़ङ्‌हाॽ सम्‍दाङ् चुक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ये़सुरे़ युहुन्‍नाःन्‍नुःल्‍ले़आङ् यरिक् हुॽसाम्‍बाहाॽ चोगुसिआङ् बप्‍तिस्‍मा पिरुसिर याक् के़लॽबा पाःन्‍निन् फरिसिहाॽरे़ मे़घे़प्‍सु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(हे़क्‍केसाङ् ये़सुरे़ग मे़ःन्, कर कुहुॽसाम्‍बाहाॽरे़रक् बप्‍तिस्‍मा मे़बिरुसिर मे़यागे़रो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ये़सुरे़ कन् पाःन्‍निन् निङ्‌वाॽ खोःसुआङ् खुने़ॽ यहुदिया थुमलाम् गालिल थुम् ले़प्‍माङ् याम्‍मो नुःक्‍खे़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","आल्‍ल खुने़ॽ सामरिया थुम्‍लाम् पोःङ्‌माआङ् पेःक्‍मा के़बोःङ्‌बा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","हे़क्‍केलॽरिक् खुने़ॽ याकुबरे़ कुस्‍साः युसुफे़न् पिरुबा लाजेॽइल्‍ले़ कुबेसाङ् सुखार मे़प्‍मनाबा सामरिया पाङ्‌भेॽओ के़रे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","खे़प्‍मो याकुबरे़ तयुबा वाबाक्‍किन् ने़स्‍से़॥ खुने़ॽ लाम्‍दिःक्‍कोलाम् नास्‍से़आङ् ले़न्‍दिक् खे़न् वाबाक्‍किल्‍ले़ कुबेसाङ् युङ्‌सिङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","सप्‍फाआङ् सामरियाबा मे़न्‍छुमाॽधिक् च्‍वाःत् फाःत्‍छे़ खे़प्‍मो त्‍ये़ःल्‍ले़ ये़सुरे़ खे़न् मे़त्तु, “च्‍वाःत्‍छिक् थुङ्‌मा पिराङ्‌ङे़ना॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","खे़प्‍मोग ये़सुःन्‍लक् वये़, थेआङ्‌भे़ल्‍ले़ कुहुॽसाम्‍बाहाॽ चामा थुङ्‌मा इङ्‌से़ पाङ्‌जुम्‍मो मे़बेआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","खे़न् सामरि मे़न्‍छुमाॽइल्‍ले़ ये़सुःन् सेःन्‍दोसु, “खे़ने़ॽ यहुदिने़, इङ्‌गाॽग सामरि मे़न्‍छुमाॽआ, हे़क्‍केःल्‍ले़ आक्‍खेलॽरिक् च्‍वाःत् थुङ्‌मा इङ्‌गाॽ के़नाःक्‍काबाबे?” (थेआङ्‌भे़ल्‍ले़ खे़न् ये़म्‍मो यहुदिहाॽ नु सामरिलुम्‍मो तङ्‌जुम् होःप्‍ते़रो)॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ये़सुरे़ खे़न् नोगप् पिरु, “खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमुॽइसाम्‍मिन् नु खे़ने़ॽ च्‍वाःत् के़नाःक्‍पे़न्‌हाःप्‍पे फाॽआङ् कुसिङ् के़निःत्तुआङ् के़वये़ल्‍ले़ग ने़त्तिगे़न् हिङ्‌मन् के़बिबा च्‍वाःत्तिन् याङ्‌ना के़नाःक्‍तुआङ् खे़न् हिङ्‌मन्‍ले़न् च्‍वाःत्तिन् के़बिरे़बामे़न्॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","हे़क्‍केःल्‍ले़ खे़न् मे़न्‍छुमाॽइल्‍ले़ सेःन्‍दोसु, “आदाङ्‌बे, खे़ने़ॽग च्‍वाःत् पाःक्‍मे़न् नु इदाःक्‍किन्‍नाङ् के़ङ्‌गत्तुन्, वाबाक्‍किन्‍नाङ् केःम्, हे़क्‍केःल्‍ले़ आत्तिनु कन् ने़त्तिगे़न् हिङ्‌मन् के़बिबा च्‍वाःत्तिन् ताःप्‍मा के़सुक्‍तुबे? ");
INSERT INTO lifNT2_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","हे़क्‍केःल्‍ले़ खे़ने़ॽग आनिगे़ ताक्‍थे़बा याकुबे़न्‍नुःल्‍ले़आङ् यम्‍बाने़बि? खुने़ॽए कन् वाबाक्‍किन् आनिगे़ पिरिगे़आङ् वाॽरो, बा कप्‍मोलाम्‍बाए खुने़ॽ नु कुस्‍साःहाॽरे़ हे़क्‍क्‍याङ् खुनिॽ थक्‍सालुप्‍हाॽरे़आङ् च्‍वाःत् मे़धुङुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","हे़क्‍केःल्‍ले़ ये़सुरे़ नोगप् पिरु, “कन् वाबाक्‍कोलाम् च्‍वाःत् के़धुङ्‌बाहाॽग याम्‍मो खुनिॽ वामिःक्‍लो, ");
INSERT INTO lifNT2_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","कर इङ्‌गाॽ पिरुङ्‌बा च्‍वाःत् के़धुङ्‌बान् आप्‍फाल्‍ले़आङ् कुवामे़मिःक्‍ने़न्॥ इङ्‌गाॽ पिरुङ्‌बा च्‍वाःत्तिन् मे़न्‍नुप्‍मनाबा हिङ्‌मन् के़बिबा सदादिङ् के़बुम्‍बा वाबुन् हे़क्‍के खुने़ॽओ पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","खे़न् मे़न्‍छुमाॽइल्‍ले़ ये़सुःन् मे़त्तु, “आदाङ्‌बे, इङ्‌गाॽआङ् खे़न् च्‍वाःत्तिन् पिराङ्‌ङे़ॽओ, हे़क्‍केलॽरिक् इङ्‌गाॽ आवामे़मिःक्‍ने़न्‍ल हे़क्‍क्‍याङ् ए़त्‍ले़ङ् इङ्‌गाॽ च्‍वाःत् फाःत्‍छे़ कप्‍मो ताःमा मे़बोःङ्‌ने़न्‍लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ये़सुरे़ खे़न् मे़न्‍छुमाॽइन् मे़त्तु, “पेगे़ॽआङ् के़ये़म्‍बाॽइन् कप्‍मो उःत्ते़ तारे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","खे़न् मे़न्‍छुमाॽइल्‍ले़ नोगप् पिरु, “इङ्‌गाॽ आये़म्‍बाॽ होःप्‍लो॥” हे़क्‍केःल्‍ले़ ये़सुरे़ मे़त्तु, “इङ्‌गाॽ आये़म्‍बाॽ होःप्‍लो लॽरिक् खे़ने़ॽ से़क्‍खाए के़बाःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","से़क्‍खाए उन्‍छेःन्‍छा ङासि के़ये़म्‍बाॽ मे़बोःक्‍खे़ मे़जुरे़आङ् वाॽ॥ आल्‍लो आत्तिन् मनाःन्‍नु खे़ने़ॽ के़वाॽ खे़न्‍नाङ् से़क्‍खाःल्‍ले़ के़ये़म्‍बाॽ मे़ःन्‍लो॥ हे़क्‍केलॽरिक् इङ्‌गाॽ आये़म्‍बाॽ होःप्‍लो के़बाःत्तुबान् से़क्‍खाएरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","खे़न् मे़न्‍छुमाॽइल्‍ले़ ये़सुःन् मे़त्तु, “आदाङ्‌बे, खे़ने़ॽग से़क्‍खाए माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाने़ फाॽआङ् कुसिङ् निःत्‍ने़ॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","आनिगे़ सामरि ताक्‍थे़बाहाॽरे कप्‍मो गेरिजिम कोःक्‍माओए सेवा मे़जोगु, कर खिनिॽ यहुदिहाॽरे़ सेवा चोःक्‍मा ते़न्‍निङ्‌ग यरुसले़म्‍लक् फाॽआङ् के़बाःत्तुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ये़सुरे़ नोगप् पिरु, “आल्‍ल सुये़म्‍मिन् तार पत्‍लो लॽरिक् इङ्‌गाॽ मे़त्‍ने़बा पाःन्‍निन्‌नसाःन् चोगे़ॽओ॥ खे़न् ये़म्‍मो पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिन् सेवा चोःक्‍से़ खिनिॽ कन् कोःक्‍माओ इग्र यरुसले़म्‍मो, आत्तोआङ् के़म्‍बेगिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","खिनिॽ सामरिहाॽरे़ कुसिङ् के़न्‍निःत्तुम्‍मिन् हाबा खे़न् सेवा के़जोगुम्, कर आनिगे़ यहुदिहाॽरे़ कुसिङ्‌निःत्तुम्‍बे़बान् सेवा चोगुम्‍बे़ॽ, थेआङ्‌भे़ल्‍ले़ यहुदिहाॽलाम्‍मे से़न्‍लप्‍पिन् ताःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","कर पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिन् से़क्‍खा नु सेसेमाङ्‌लाम् सेवा चोःक्‍मा ये़म्‍मिन् तार पत्॥ हे़क्‍क्‍याङ् खे़न् ये़म्‍मिन् आल्‍लोसा त्‍ये़ चुरे़आङ् वाॽरो॥ हे़क्‍तङ्‌बा कुजे़क् सेवा के़जोःक्‍पाहाॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कोःत्तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","निङ्‌वाॽफुमाङ्‌ङिङ्‌ग याम्‍साम्‍लो हे़क्‍क्‍याङ् खुने़ॽ सेवा के़जोःक्‍पाहाॽरे़ग से़क्‍खाःल्‍ले़ सेसेमाङ्‌लाम् सेवा चोःक्‍मा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","खे़न् मे़न्‍छुमाॽइल्‍ले़ मे़त्तु, “मसिहःन्‌ ताः फाॽआङ् इङ्‌गाॽ निःसुङ्‌लो, (खुने़ॽए ख्रिस्‍त मे़मे़त्तुॽरो) खुने़ॽ ताःल्‍ले़ कन् काक् पाःन्‍हाॽ याप्‍मि पोधक् चोगु पिरिगे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ये़सुरे़ खे़न् नोगप् पिरु, “खे़ने़ॽनु ताॽके़जे़ङ्‌बान्‍ने खुने़ॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","बा खे़न् ये़म्‍मो ये़सुरे़ कुहुॽसाम्‍बाहाॽ खे़प्‍मो मे़गे़रे़ मे़द्‌ये़॥ खुने़ॽ खे़न् मे़न्‍छुमाॽइन्‍नु ताॽजे़ङ्‌नु युङे़बा मे़निःसुआङ् खुनिॽ निङ्‌वाॽ मये़रो॥ हे़क्‍केसाङ् खे़ङ्‌हाॽरे़ खे़ने़ॽ थेःन् चाहाबा के़जोगे़बे? इग्र थेआङ् खे़न्‍नु ताॽके़जे़ङ्‌बाबे फाॽआङ् सेःन्‍मे़न्‍दोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","हे़क्‍क्‍याङ् खे़न् मे़न्‍छुमाॽइल्‍ले़ च्‍वाःत् कुःन्‍दाःन् खे़प्‍मोए युक्‍खुधआङ् पाङ्‌जुम्‍मो नुःक्‍खे़ पे हे़क्‍क्‍याङ् काक् पाङ्‌जुम्‍साबाहाॽ अक्‍खे मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ओमे़त्ते़म्‍मे़ॽ, मनाधिक्‍ले़ इङ्‌गाॽ चोगुङ्‌बा काक् आयाःम्‍बक्‍हाॽरे़ कुयाःम्‍बेओ मे़त्ताङ्‌लो॥ फे़रे़म्‍मे़ॽआङ् ओमे़त्ते़म्‍मे़ॽओ॥ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त मे़प्‍मनाबान् खुने़ॽएग मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","हे़क्‍क्‍याङ् खे़न् मनाहाॽ पाङ्‌जुम्‍मोलाम् मे़लःन्‍दे़आङ् ये़सुःन् वये़बा ते़न्‍नो मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","आल्‍ल हुॽसाम्‍बाहाॽरे़ ये़सुःन् “‘सिक्‍साम्‍बे, चा चे़ॽओ’” फाॽआङ् पेलि मे़भाक्‍तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ कत्तुङ्‌बा आजामा चाःल्‍ले़ कुयाःम्‍बेओ खिनिॽ थेआङ् कुसिङ् के़न्‍निःत्तुम्‍मिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","हे़क्‍केःल्‍ले़ ये़सुरे़ कुहुॽसाम्‍बाहाॽ अक्‍खेलॽरिक् आबाङे सेःन्‍मे़दोःसिङ्, “मे़ःम्‍बे़, खुने़ॽ हाःत्‍ले़ कुजा हुॽरुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ याप्‍मि के़बाङ्‌बाल्‍ले़ कुनिङ्‌वाॽ हे़क्‍के चोःक्‍मा नु कुयाःम्‍बक् चोःक्‍मा सुःप्‍मान्‍ने इङ्‌गाॽ आजामा चारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","खिनिॽ अक्‍खेलॽरिक् के़बाःत्तुम्, ‘आल्‍ल ला लिसि एगाङ् चासुम्‍मा ये़म्‍मिन् ताःरो॥’ कर इङ्‌गाॽ मे़त्‍निङ्, ‘खिनिॽ मिक् हन्‍दे़म्‍मे़ॽआङ् ओमःये़म्‍मे़ॽ, काक् प्‍याङ्‌सिगे़न् इक्‍ताप्‍पो चा तुम्‍से़आङ् चासुम्‍मा ये़म्‍मिन् त्‍ये़ चुरे़आङ् वाॽरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","हे़क्‍क्‍याङ् के़सुम्‍बाल्‍ले़ खुने़ॽ कुनाम्‌याक् खोःसुरो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍ले़ लागि पोगुगे़न् कुजाःन् मे़सुप्‍सुरो॥ हे़क्‍केलॽरिक् याॽरिःम्‍बा के़हेॽबा नु चा के़सुम्‍बा ने़प्‍माङ् सःत्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","हे़क्‍केलॽरिक् ‘थिक्‍किल्‍ले़ याॽरिःम्‍बान् हेॽरु वेॽस्‍माल्‍ले़ चा सुप्‍सुॽ’ पाःप्‍मनाबान् से़क्‍खाएरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","इङ्‌गाॽआङ् खिनिॽ चा के़न्‍हेॽरुम्‍मिन्‍बो पोगुगे़न् कुजा सुम्‍से़ पाङ्‌निङ्‌ङाङ् वाॽआरो॥ वेॽहाॽरे़ याम्‍बुधिक् मे़जोगुआङ् वाॽरो हे़क्‍क्‍याङ् खुनिॽ याम्‍बुधिक्‍ले़न् इन्‍धाःङ्‌ङिन् खिनिॽ के़घोःसुम्‍माङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","खे़न् मे़न्‍छुमाॽइल्‍ले़ इङ्‌गाॽ चोगुङ्‌बा काक् आयाःम्‍बक्‍हाॽ खुने़ॽ चे़क्‍ताङ्‌लो लॽरिक् पाःत्तुबाल्‍ले़ चोगुल्‍ले़ खे़न् पाङ्‌जुम्‍लाम् के़दाःबा यरिक् सामरिहाॽरे़ ये़सुःन् नसाःन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","सामरिहाॽ खुने़ॽ कुदुम्‍से़ मे़द्‌ये़आङ् आनिगे़नु थिक्‌ये़न् निये़न् थारिक् याःक्‍ते़ॽ फाॽआङ् पेलि मे़भाक्‍तु हे़क्‍क्‍याङ् ये़सुःन् खे़प्‍मो निये़न् थारिक् याःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","हे़क्‍क्‍याङ् खुने़ॽ पाःत्तुबा पाःन्‍निन् मे़घे़प्‍सुआङ् आल्‍लसाङ् यरिक् नसानिबा मे़बोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","खे़ङ्‌हाॽरे़ खे़न् मे़न्‍छुमाॽइन् अक्‍खे मे़मे़त्तु, “खे़ने़ॽ के़बाःत्तुबा पाःन्‍हाॽ खे़म्‍मनाबाल्‍ले़रक् ये़सुःन् नसाःन् चोःक्‍मनाबा मे़ःन्, कर आल्‍लोग आनिगे़ आबाङे खुने़ॽ कुबाःन्‍हाॽ खे़प्‍सुम्‍बा हे़क्‍क्‍याङ् कन् मनाःङ्‌ग से़क्‍खासाङ् इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़न् से़न्‍लप्‍दाङ्‌बा फाॽआङ् आनिगे़ कुसिङ् निःत्तुम्‍बे़बाल्‍ले़ चोगुल्‍ले़ नसाःन् चोःक्‍मनाबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","हे़क्‍क्‍याङ् ये़सुःन् निये़न् एगाङ् आबाङे कुलाजेॽ गालिल थुम् ले़प्‍माङ् थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(आल्‍ल ये़सुरे़ आबाङे अक्‍खेलॽरिक् तगि पाःत्तुआङ् वये़ “माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्‌खुने़ॽ आबाङे कुबाङ्भेॽओ मिङ्‌सो इङ्‌धाःङ् मे़म्‍बिरुन्‍लो॥”) ");
INSERT INTO lifNT2_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ये़सुःन् गालिल के़रे़ल्‍ले़ खे़प्‍मोबा मनाहाॽरे़ लाङ्‌दाःक्‍मा मे़बिरुरो थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ यरुसले़म्‍मो यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मो मे़बेआङ् मे़वये़ल्‍ले़ ये़सुरे़ चोगुबा निङ्‌वाॽ के़माबा मिक्‍सेःन्‍हाॽ खे़ङ्‌हाॽरे़ मे़निःसुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","खुने़ॽ याम्‍मो गालिलबा काना पाङ्‌जुम्‍मो पे॥ खे़प्‍मो खुने़ॽ च्‍वाःत्तिन् चे़ल्‍ले़क्‍सेॽ थिः चोगुआङ् वये़रो॥ हे़क्‍क्‍याङ् खे़प्‍मोबा लत्‍छा सुहाङ्‌युक्‍पाल्‍ले़ कुस्‍साःन् कपर्नहुम पाङ्‌जुम्‍मो साॽरिक् तुगे़आङ् ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","खे़ल्‍ले़ ये़सुःन् यहुदियालाम् गालिलओ के़रे़ त्‍ये़ के़लॽबा खे़प्‍सुआङ् खे़प्‍मो कुदुम्‍से़ पे॥ खे़ल्‍ले़ ये़सुःन् तुमु हे़क्‍क्‍याङ् कपर्नहुम्‍मो ये़ॽआङ् सिःमालिङ्‌धो के़गे़प्‍पाआङ् के़ने़बा आस्‍साःन् वेःन्‍दे़ॽ फाॽआङ् पेलि फाक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ये़सुरे़ खे़न् सुहाङ्‌युक्‍पे़न्‌मे़त्तु, “खिनिॽ मिक्‍सेःन् नु निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ मे़न्‍निए थारिक् आप्‍फाल्‍ले़आङ् नसाःन् के़न्‍जोगुम्‍मिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","खे़न् सुहाङ्‌युक्‍पाल्‍ले़ मे़त्तु, “आदाङ्‌बे, इङ्‌गाॽ आस्‍साःन् मे़न्‍छिःएसा ये़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ये़सुरे़ खे़न् मे़त्तु, “पेगे़ॽओ, के़स्‍साःन् हिङ्‌लो॥” हे़क्‍क्‍याङ् खे़ल्‍ले़आङ् ये़सुरे़ कुबाःन्‍निन्‌नसाःन् चोगुआङ् थासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","लाम्‍मो खे़न् पेर पत्‍छे़ल्‍ले़ कुभा कुसेवारोबाहाॽरे़ मे़दुमुआङ् “‘के़स्‍साःन् वेःत्ते़रो’” मे़मे़त्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","हे़क्‍क्‍याङ् आत्तिन् ये़म्‍मो वेःत्ते़बे फाॽआङ् खे़ङ्‌हाॽ सेःन्‍दोसुसिल्‍ले़ खे़ङ्‌हाॽरे़ अक्‍खेलॽरिक् नोगप् मे़बिरु, “मिःप्‍मा कुमुक् थिक् मुक्‍ते़आङ् वये़ल्‍ले़ तुक्‍माल्‍ले़ ले़रुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","हे़क्‍केःल्‍ले़ के़दुक्‍पाल्‍ले़ कुम्‍बारे़ मिःप्‍मा के़स्‍साःन् हिङ्‌लो लॽरिक् ये़सुरे़ पाःत्तुबा ये़म्‍मोए के़दुक्‍पे़न्‌वेःत्ते़बा निङ्‌वाॽ खोःसुरो॥ हे़क्‍क्‍याङ् खुने़ॽ नु कुहिम्‍मो के़वाॽबा के़रे़क्‍ले़ ये़सुःन् नसाःन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","कङ्‌ग ये़सुःन् यहुदियालाम् गालिलओ त्‍ये़आङ् चोगुबा निसिगेःक्‍पा निङ्‌वाॽ के़माबा याःम्‍बक् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","खे़न् एगाङ् ये़सुःन् यहुदि तङ्‌नाम्‌रे़ लागि थो यरुसले़म ये़क्‌यक्‍को पे॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","आल्‍ल यरुसले़म्‍मो मे़ल्‍लुक् लाम्‍धेःप्‍पाल्‍ले़ कुबेसाङ् ङासि सित्‍लाङ्‌हाॽरे़ कब्रिङ् कबुबा हिब्रु पाःन्‍नो बे़थस्‍दा मे़प्‍मनाबा वाबाक्‍थिक् ने़ःॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","खे़प्‍मो यरिक् के़दुक्‍पा मनाहाॽ–मिक्‍फःम्‍बा, लाङ्‌सक्‍पा नु लङ्‌ले़ःङ्‌वा मनाहाॽ मे़ने़स्‍से़रो॥ ((खे़ङ्‌हाॽरे़ छिम्‍लिङ् छिम्‍लिङ् लॽरिक् के़मुम्‍बा च्‍वाःत्तिन् मे़हाङ्‌घुआङ् मे़ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","थेआङ्‌भे़ल्‍ले़ दाङ्‌बाल्‍ले़ कुमाङ्‌लाइङ्‌बान् कुभा ये़न्‍नो ताआङ् च्‍वाःत्तिन् मुन्‍दुल्‍ले़ के़रे़क्‍नुःल्‍ले़ तगि च्‍वाःत्तो के़लाःप्‍पे़न्‌आक्‍तङ्‌बा तुक्‍मा यॽमा कत्तुसाङ् वेःत्ते़रो॥)) ");
INSERT INTO lifNT2_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","खे़प्‍मो के़ने़बा थिक् के़दुक्‍पा मनाःङ्‌ग सुम्‌ये़त् (३८) तङ्‌बेआङ्धो ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ये़सुरे़ खे़न् मनाःन् खे़प्‍मो ने़स्‍से़बा निःसु हे़क्‍क्‍याङ् यरिक् तङ्‌बेआङ्धो तुक्‍काङ् ने़रो के़लॽबा निङ्‌वाॽ खोःसुआङ् सेःन्‍दोसु, “खे़ने़ॽ वेःप्‍मा के़सिराॽ थाङ्‌बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","खे़न् के़दुक्‍पाल्‍ले़ नोगप् पिरु, “ओरो, आदाङ्‌बे, कर खे़न् वाबाक्‍कोबा च्‍वाःत्तिन् छिम्‍लिङ् छिम्‍लिङ् लॽरिक् मुन्‍निल्‍ले़ खे़प्‍मो याप्‍मि के़गेःप्‍पा हाःत्ताङ् होःप्‍लो॥ इङ्‌गाॽ खे़प्‍मो लाःप्‍मा तम्‍सिन् चोगुङ्‌ल पत्ताल्‍ले़सा वेॽहाॽ इङ्‌गाॽनुःल्‍ले़ तगि मे़लाःत् मे़बेःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ये़सुरे़ खे़न् मे़त्तु, “पोगे़ॽ! हे़क्‍क्‍याङ् के़ने़त्‍नाःन् याङ्‌सिङ्‌ङे़ॽआङ् थासिङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","खिमो खे़न् मनाःन् वेःत्ते़आङ् कुने़त्‍नाःन् याङ्‌सिङ्‌ङाङ् थासिङ्‌लो॥ आल्‍ल कन् निङ्‌वाॽ के़माबा पाःन्‍निङ्‌ग नाःम्‍सिङ्‌ये़न्‍नो पोःक्‍खे़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","खे़ल्‍ले़ चोगुल्‍ले़ यहुदिहाॽरे़ खे़न् के़वेःप्‍पा मनाःन् “खे़ने़ॽ नाःम्‍सिङ्‌ये़न्‍नो के़ने़त्‍नाःन् पङ्‌मा साम्‌योथिम्‍मिल्‍ले़ के़म्‍बिने़न्‍लो” मे़मे़त्तुर मे़अत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","कर खे़ल्‍ले़ नोगप् पिरुसि, “इङ्‌गाॽ याप्‍मि के़वेःम्‍बा मनाःल्‍ले़ए ‘के़ने़त्‍नाःन् याङ्‌सिङ्‌ङे़ॽआङ् थासिङ्‌ङे़ॽ’ मे़त्ताङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ आत्तिन् मनाःल्‍ले़ “खे़ने़ॽ के़ने़त्‍नाःन् याङ्‌सिङ्‌ङे़ॽआङ् थासिङ्‌ङे़ॽ” के़मे़त्ते़ लॽरिक् खे़न् सेःन्‍मे़दोसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","खे़न् मनाःल्‍ले़ खुने़ॽ के़वेःम्‍बान् कुसिङ् मे़निःत्तुन्‍लो, थेआङ्‌भे़ल्‍ले़ खे़प्‍मोबा मनालुम्‍मो ये़सुःन् इःम्‍सिङ् पेआङ् होःप्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","याङ्‌सि ये़सुरे़ खे़न् मनाःन् माङ्‌हिम्‍मो तुमुआङ् मे़त्तु, “ओमे़त्ते़ॽ, खे़ने़ॽ के़नुरे़आङ् के़वाॽरो॥ आल्‍लआङ्‌धो लायो मे़जोगे़न्‍ने़ॽओ, मे़ःन्‍ने़ फाॽग्र कन्‍नुःल्‍ले़आङ् यरिक् ताप्‍फे़ःम्‍बा पाःन्‍हाॽ खे़ने़ॽ के़दुमुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","खे़न् मनाःन् पेआङ् इङ्‌गाॽ के़वेःम्‍बाङ्‌ग ये़सुःन्‍नेरे़त्‍छ फाॽआङ् यहुदि लाम्‍लोःबाहाॽ मे़त्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","हे़क्‍केःल्‍ले़ यहुदिहाॽरे़ नाःम्‍सिङ्‌ये़न्‍निल्‍ले़न् साम्‌योथिम्‍मिन् फेःन्‍दु फाॽआङ् ये़सुःन् साॽरिक् तुक्‍खे चाःप्‍मा मे़हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ आम्‍बारे़ए आल्‍लो थारिक् याःम्‍बक् चोगुर वाॽ, हे़क्‍केःल्‍ले़ इङ्‌गाॽआङ् चोगुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","खुने़ॽग नाःम्‍सिङ्‌ये़न्‍नो याःम्‍बक् चोःक्‍मा मे़न्‍नुॽमना साम्‌योथिम्‍मिन्‍लक् मे़नाॽरुन् कर निङ्‌वाॽफुमाङ्‌ङिन्‍ने “आम्‍बारो” पाःत्तुआङ् खुने़ॽ निङ्‌वाॽफुमाङ्‌ङिन्‍नु कुदङ्‌बा चोःक्‍सिङ् हे़क्‍केःल्‍ले़ यहुदि लाम्‍लोःबाहाॽरे़ आक्‍खेलॽरिक्‍साङ् खुने़ॽ से़प्‍मा पोःङ् लॽरिक् तम्‍सिन् मे़जोगु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ये़सुरे़ खे़ङ्‌हाॽ अक्‍तङ्‌बा नोगप् पिरुसि, “से़क्‍खाए मे़त्‍निङ्‌लो, कुस्‍साःल्‍ले़ आबाङेग थेआङ् चोःक्‍मा मे़सुक्‍तुन्, कर खुने़ॽग पानुदिङ् कुम्‍बारे़ चोगुबा पाःन्‍हाॽ निःसुबा कुइसिःक्‍लक् चोःक्‍मा सुक्‍तुॽरो, थेआङ्‌भे़ल्‍ले़ पानुदिङ् पाःल्‍ले़ थे चोगुॽ बा खे़न्‍ने कुस्‍साःल्‍ले़आङ् चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","थेआङ्‌भे़ल्‍ले़ पानुदिङ् पाःल्‍ले़ कुस्‍साःन् लुङ्‌माॽ तुक्‍तुआङ् खुने़ॽ चोगुबा काक् याःम्‍बक्‍किन् ओसेःन्‍धाक्‍तुॽरो॥ हे़क्‍क्‍याङ् कन् मनाःन् वेःत्ते़बान्‍नुःल्‍ले़आङ् पयम्‌यम्‍बा याःम्‍बक्‍हाॽ आबुगे़न् कुस्‍साःन् ओसेःन्‍धाक्‍तुबा के़निःसुम्‍मिल्‍ले़ खिनिॽ निङ्‌वाॽ मारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","थेआङ्‌भे़ल्‍ले़ पानुदिङ् पाःल्‍ले़ के़सिःबाहाॽ याम्‍मो हिङ्‌घुसिआङ् मे़न्‍नुप्‍मनाबा हिङ्‌मन् पिरुसिबा कुइसिःक्‍के कुस्‍साःल्‍ले़आङ् निङ्‌वाॽ चोगुसिबा मनाहाॽ ने़त्तिगे़न् हिङ्‌मन् पिरुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","खे़न्‍नुःल्‍ले़आङ् यरिक् पानुदिङ् पाःल्‍ले़ हाःत्ताङ् आबाङे खासे़न् मे़जोगुन्, कर काक् खासे़न् चोःक्‍मा युक्‍किन् कुस्‍साःन् पिरुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","खे़ल्‍ले़ चोगुल्‍ले़ काक् मनाहाॽरे़ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिन् इङ्‌धाःङ् मे़बिरुबा कुइसिःक्‍के कुस्‍साःन्‍नाङ् मे़बिरुररो॥ कर आबुगे़न् कुस्‍साःन् इङ्‌धाःङ् मे़म्‍बिमनाबाल्‍ले़ग कुस्‍साः के़बाङ्‌बा पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिन्‍नाङ् इङ्‌धाःङ् मे़बिरुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आत्तिल्‍ले़ पेलिगे़न् आबाःन्‍जाक्‍किन् खे़प्‍सुआङ् इङ्‌गाॽ याप्‍मि के़बाङ्‌बान् नसाःन् चोगुॽ, खे़ल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुआङ् वाॽ, हे़क्‍क्‍याङ् खे़ल्‍ले़ खुम्‍दिङ् मे़घोःसुन्, कर खे़ङ्‌ग तगिसा सिःमे़न्‍लाम् मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍नो चत्‍छिङ् पेआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आल्‍ल ये़म्‍मिन् तार पत्‍लो, के़सिःबाहाॽरे़ निङ्‌वाॽफुसाःल्‍ले़ कुइक्‍लाःन् मे़घे़प्‍सुॽ हे़क्‍क्‍याङ् कुइक्‍लाःन् के़घे़म्‍बाहाॽ मे़हिङ्‌लो हे़क्‍क्‍याङ् से़क्‍खाए खे़न् ये़म्‍मिङ्‌ग आल्‍लोएरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","थेआङ्‌भे़ल्‍ले़ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिन् काक् ने़त्तिगे़न् हिङ्‌मन्‍निल्‍ले़ कुबुन्‍लो, हे़क्‍केलॽरिक्‍के कुस्‍साःन्‍नाङ् मे़न्‍नुप्‍मनाबा हिङ्‌मन् के़बिबा चोगुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽ काक् मे़न्‍छाम् सुवाङ् सम्‍दाङ् खासे़न् चोःक्‍मा फाॽआङ् युक् पिरुआङ् वाॽ, थेआङ्‌भे़ल्‍ले़ खुने़ॽग मे़न्‍छाम्‍साःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“खिनिॽ निङ्‌वाॽ मे़मये़म्‍मिन्‍ने़ॽ, से़क्‍खाए अक्‍तङ्‌बा ये़म् तार पत्, खे़न् ये़म्‍मोग इप्‍पुङ्‌ङोबा काक् कुसिवे़त्‍हाॽरे़ निङ्‌वाॽफुसाःल्‍ले़ कुइक्‍लाःन् मे़घे़प्‍सुआङ् ");
INSERT INTO lifNT2_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","खे़ङ्‌हाॽ सिःमे़न्‍लाम् याम्‍मो मे़हिङ्‌–नुःबा याःम्‍बक् के़जोःक्‍पाहाॽरे़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् मे़घोःसुॽ, कर फे़न् याःम्‍बक् के़जोःक्‍पा के़रे़क्‍ले़ खुम्‍दिङ् मे़घोःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","इङ्‌गाॽ आबाङेग थेआङ् चोःक्‍मा मे़सुक्‍कान्‍लो, कर इङ्‌गाॽ खे़प्‍सुङ्‌बा कुइसिःक्‍लक् खासे़न् चोगुङ्‌लो, हे़क्‍क्‍याङ् इङ्‌गाॽ चोगुङ्‌बा खासे़न्‍निन् साम्‌योनिबा चोःक्‍लो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आबाङे आनिङ्‌वाॽइल्‍ले़ थाप्‍तुबा थेआङ् मे़जोःक्‍कान्, कर याप्‍मि के़बाङ्‌बाल्‍ले़ कुनिङ्‌वाॽ कुइसिःक्‍लक् चोगुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“इङ्‌गाॽ आयाःम्‍बेओ आबाङे तोःन्‍दि पिरुङ्‌ने़ फाॽग्र इङ्‌गाॽ आदोःन्‍दिन्‌से़क्‍खा मे़बोःङ्‌ने़ल्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","कर इङ्‌गाॽ आयाःम्‍बेओ तोःन्‍दि के़बिबाङ्‌ग वेॽधिक् वाॽरो॥ हे़क्‍क्‍याङ् खुने़ॽ कुदोःन्‍दिङ्‌ग से़क्‍खा चोःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","से़क्‍खाए खिनिॽ बप्‍तिस्‍मा के़बिबा युहुन्‍नारो कुबाःन् खे़म्‍से़ के़बाङ्‌घुम्‍सिम् हे़क्‍क्‍याङ् से़क्‍खाःल्‍ले़ कुयाःम्‍बेओ खुने़ॽ तोःन्‍दि पिरुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","इङ्‌गाॽ आयाःम्‍बेओ मे़न्‍छाम् याप्‍मिहाॽरे़न् तोःन्‍दि चाहाबा मे़जोःक्‍कान्‍लो, कर कन् काक् पाःन्‍हाॽग खिनिॽ से़न्‍लप् के़घोःसुम्‍ल फाॽआङ् मे़त्‍निङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","युहुन्‍नाःङ्‌ग सेमि कुइसिःक् के़दिःप्‍पा नु ओःत्ति के़बिबा वये़ हे़क्‍क्‍याङ् सप्‍फाधिक्‍साङ् खुने़ॽ कुओःत्तिःन् खिनिॽ सिराॽ थाङे़रो, ");
INSERT INTO lifNT2_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","कर इङ्‌गाॽ आयाःम्‍बेओ युहुन्‍नाःल्‍ले़ कुदोःन्‍दिन्‍नुःल्‍ले़आङ् यम्‍बा तोःन्‍दि वाॽ, खे़ङ्‌ग चोगुङ्‌ल वाॽआबा आम्‍बारे़ चोःक्‍मा सुःप्‍मा फाॽआङ् पिराङ्‌बा याःम्‍बक्‍किल्‍ले़ए पानुदिङ् आम्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाङ्‌घाङ्‌बा फाॽआङ् तोःन्‍दि के़बिरिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","हे़क्‍क्‍याङ् याप्‍मि के़बाङ्‌बा पानुदिङ् पाःल्‍ले़ इङ्‌गाॽ आयाःम्‍बेओ तोःन्‍दि पिरुआङ् वाॽरो॥ खिनिॽ आप्‍फाल्‍ले़आङ् कुबाःन् मे़ङ्‌घे़म्‍मे नु खुने़ॽ मे़न्‍निए के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","खुने़ॽ पाःत्तुबा कुबाःन्‍जाक्‍किन् खिनिॽओ मे़वाॽने़न्‍लो थेआङ्‌भे़ल्‍ले़ खुने़ॽ पाङ्‌घुबा मनाःन् खिनिॽ नसाःन् के़न्‍जोगुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","खिनिॽग साम्‌योसाप्‍लाःन् नुःरिक्‍काङ् के़निःरुम्‍लो थेआङ्‌भे़ल्‍ले़ खे़प्‍मोलाम् मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःसुम्‍बे़ फाॽआङ् निङ्‌वाॽ के़इःत्तुम्, कर खे़न् साम्‌योसाप्‍लाःल्‍ले़ए इङ्‌गाॽ आयाःम्‍बेओ तोःन्‍दि के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","हे़क्‍केसाङ् खिनिॽ इङ्‌गाॽओ ताःमाआङ् मे़न्‍नुप्‍मनाबा हिङ्‌मन् खोःमा निङ्‌वाॽ के़न्‍जोगुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“इङ्‌गाॽग मे़न्‍छाम् याप्‍मिरे़ आनारा मे़भोःसुर मे़लॽआन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","कर खिनिॽ आक्‍तङ्‌बा के़जोगिॽ फाॽआङ् कुसिङ् निःत्‍निङ्‌लो॥ खिनिॽ निङ्‌वाॽओलाम् निङ्‌वाॽफुमाङ्‌ङिन् मिःम्‍जि के़म्‍मे़त्तुम्‍मिन्‍बान् इङ्‌गाॽ निःसुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","इङ्‌गाॽ पानुदिङ् आम्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ युक् पिराङ्‌ङाङ् पाङ्‌घाङ्‌साङ् याप्‍मि लाङ्‌गे़न्‍दाःक्‍तिन्‍लो कर वेॽहाॽ हाःत्‍ले़आङ् युक् मे़म्‍बिए आबाङे खुनिॽ युक्‍को के़दाःबाहाॽ खिनिॽ लाङ्‌गे़दाःक्‍तुम्‍सिम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","खिनिॽ आबाङे मिङ्‌सो इङ्‌धाःङ् के़बिआसि, कर थिक्‍लक् निङ्‌वाॽफुमाङ्‌लाम् के़दाःबा मिङ्‌सो इङ्‌धाःङ्‌ङिङ्‌ग के़ङ्‌गोःत्तुम्‍मिन्, हे़क्‍केःल्‍ले़ आक्‍खेलॽरिक् खिनिॽ याप्‍मि नसाःन् चोःक्‍मा के़सुक्‍तिबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“हे़क्‍केसाङ् इङ्‌गाॽ पानुदिङ् पाःल्‍ले़ कुदगि आप्‍तिक् मे़गुःत्‍निङ्‌ङिन्‍लो, कर खिनिॽ निङ्‌साङ् के़जोगुम्‍बा मोसारे़ कुसाम्‌योथिम्‍मिल्‍ले़ए खिनिॽ आप्‍तिक् के़गुःत्तिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","से़क्‍खाए मोसाःन् नसाःन् के़जोगुम्‍मिल्‍ले़ग इङ्‌गाॽ याप्‍मि नसाःन् के़जोगिबारो, थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ आयाःम्‍बेओ साप्‍तुआङ् पत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","कर खिनिॽ मोसारे़ साप्‍तुबा पाःन्‍नोए नसाःन् के़न्‍जोगुम्‍मिन्‍निल्‍ले़ आक्‍खेलॽरिक् इङ्‌गाॽ याप्‍मि नसाःन् के़जोगिॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","याङ्‌सि ये़सुःन् गालिल वारक्‍किल्‍ले़ नाधाःम्‍बि पे॥ (खे़ङ्‌ग तिबेरियस वारक्‍काङ् मे़मे़त्तुरो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","यरिक् मनाहाॽरे़ खुने़ॽ मे़दिम्‍दु, थेआङ्‌भे़ल्‍ले़ खुने़ॽ के़दुक्‍पाहाॽ वेःन्‍दुसिबा निङ्‌वाॽ के़माबा मिक्‍सेःन्‍हाॽ मे़निःसुआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ये़सुःन् थो कोःक्‍माओ पे हे़क्‍क्‍याङ् कुहुॽसाम्‍बाहाॽनु युङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","खे़न् ये़म्‍मो यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मिन् निःत्ताङ्‌ङे त्‍ये़ चुरे़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","हे़क्‍क्‍याङ् मनाहाॽ खुने़ॽओ मे़धाङे़र मे़बत्‍छे़बा ये़सुरे़ निःसुसिआङ् फिलिप्‍पे़न् सेःन्‍दोसु, “आल्‍ल आत्तिनु खरे़ःङ्‌ङिन् आइङुम्‍माङ् कन् मनाहाॽ आजाःत्तुम्‍सिम्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","खुने़ॽ फिलिप्‍पे़न् कुनिङ्‌वाॽ साॽमा फाॽआङ् अक्‍खेलॽरिक् मे़त्तुबारो, थेआङ्‌भे़ल्‍ले़ ये़सुरे़ थे चोगुङ् के़लॽबान् तगिसा कुनिङ्‌वाॽओ वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिपरे़ नोगप् पिरु, “आदाङ्‌बे, आनिॽग किप्‌ने़त्‍छि (२००) याङ्‌ले़ खरे़ःङ् आइङुम्‍माङ् कन् मनाहाॽग च्‍यॽ च्‍यॽरक् आबिरुम्‍सिम्‍साङ् आन्‌योसुम्‍सिम्‍मिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","हे़क्‍क्‍याङ् ये़सुरे़ वेॽस्‍मा कुहुॽसाम्‍बा सिमोन पत्रुसरे़ कुन्‍साॽ आन्‍द्रियासे़ल्‍ले़ अक्‍खे पाःत्तुरो, ");
INSERT INTO lifNT2_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“कप्‍मो चुक्‍पाधिक्‍ले़ ङासि हःक्‍सिः खरे़ःङ् नु ने़त्‍छि ङासा कत्तुॽ, कर कम्‍म्‍याक् यरिक् मनाहाॽ आक्‍खेलॽरिक् योमासिबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ये़सुरे़ कुहुॽसाम्‍बाहाॽ अक्‍खेलॽरिक् मुरा मे़त्तुसि, “के़रे़क् मनाहाॽ युङ् पाङ्‌घे़म्‍सिम्‍मे़ॽओ॥” हे़क्‍क्‍याङ् खे़ङ्‌हाॽ यरिक् याःन् के़युङ्‌बा ने़ने़बा ते़न्‍नो युङ्‌मे़बाङ्‌घुसि॥ हे़क्‍क्‍याङ् खे़प्‍मो मे़न्‍छुमाॽ हिन्‍जाॽबित्‍छाहाॽ मे़न्‍निःत्‍छिङ्‌ङे ये़म्‍बित्‍छाॽहाॽरक् हे़न्‍छिङ् ङासि (५०००) यारिक् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ये़सुरे़ खे़न् खरे़ःङ्‌ङिन् खप्‍सुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् पिरु हे़क्‍क्‍याङ् खे़न् मनाहाॽ हाःत्तुसि॥ हे़क्‍क्‍याङ् ङासाःन्‍नाङ् बा हे़क्‍केलॽरिक्‍के खुनिॽ योयो हाःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","खे़न् काक् मनाहाॽरे़ खाघा मे़जआङ् ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “काक् कुजि के़नम्‍बाहाॽ सुप्‍से़म्‍मे़ॽओ, कुजिथिक्‍काङ् चामे़सोःक्‍ने़न्‍लरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","हे़क्‍क्‍याङ् खे़न् ङासि हःक्‍सिः खरे़ःङ्‌हाॽ मनाहाॽरे़ मे़जआङ् कुजि के़नम्‍बा खरे़ःङ्‌हाॽ मे़सुप्‍सुल्‍ले़ग थिक्-ने़त् नइमाने़ तिम्‍से़! ");
INSERT INTO lifNT2_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","हे़क्‍क्‍याङ् मनाहाॽरे़ खुने़ॽ चोगुबा निङ्‌वाॽ के़माबा मिक्‍सेःन्‍निन् मे़निःसुआङ् अक्‍खे मे़बाःत्तु, “इक्‍सादिङ् खाम्‍बेःक्‍मो ताः लॽरिक् निङ्‌साङ् चोःक्‍मनाबा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाङ्‌ग से़क्‍खासाङ् खुने़ॽएरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","मनाहाॽरे़ साक्‍के़ल्‍ले़क्‍काङ् खुनिॽ हाङ् चोःक्‍मा निङ्‌वाॽ मे़जोगुआङ् वाॽ के़लॽबान् ये़सुरे़ निङ्‌वाॽ खोःसुआङ् खुने़ॽ ए़क्‍लेःक्‌थो कोःक्‍माओ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","हे़क्‍क्‍याङ् युःन्‍छिक् पोःक्‍खे़आङ् कुहुॽसाम्‍बाहाॽ खे़न् कोःक्‍माओलाम् यो मे़ध्‍ये़आङ् वरक्‍किल्‍ले़ कुयाओ ये़सुःन् मे़हाङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","कर खादामे़साङ् खुने़ॽ खे़प्‍मो मे़ये़ने़न्‍बाल्‍ले़ चोगुल्‍ले़ कुहुॽसाम्‍बाहाॽ खःङ्‌बेओ मे़लाःसे़आङ् नाहाङ्‌दाङ् कपर्नहुम पाङ्‌जुम् ले़प्‍माङ् मे़धासिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","खे़ङ्‌हाॽ मे़बेर मे़बत्‍छे़ल्‍ले़ वरक्‍को किप्‍मा के़घुःबा सुरित् केजङ्‌ङिन् हुःमा हेःक्‍ते़आङ् वाभे़ल्‍ले़ङ्‌ङिन् पोगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","खे़ङ्‌हाॽ ङासि-तुक्‍सि (५-६) किलोमितर मे़बेआङ् मे़वये़ल्‍ले़ खे़ङ्‌हाॽरे़ हक्‍चघत् ये़सुःन् च्‍वाःत्तो लाङ्‌घेगे़र खुनिॽ पेसाङ् फे़रे़र पत्‍छे़बा मे़निःसुआङ् खे़ङ्‌हाॽ साॽरिक् मे़गिसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ ये़सुआ, मे़गिसे़म्‍मिन्‍ने़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","हे़क्‍केःल्‍ले़ कुहुॽसाम्‍बाहाॽ मे़सःत्ते़र खुने़ॽ खःङ्‌बेओ मे़युक्‍खुरो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़बेर मे़बत्‍छे़बा ते़न्‍नो खिमो खुनिॽ खःङ्‌बेन् के़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","हे़क्‍क्‍याङ् वरक्‍किल्‍ले़ नाधाःम्‍बि के़वाॽबा मनाहाॽरे़ थिक्‍लक् खःङ्‌बेन् ने़स्‍से़बा मे़निःसु हे़क्‍क्‍याङ् ये़सुःन् खःङ्‌बेओ कुहुॽसाम्‍बाहाॽनु मे़लाःसे़म्‍बा कर खुने़ॽ कुहुॽसाम्‍बाहाॽरक् मे़बेबा पाःन्‍निन् कुदाःन्‍दिक्‍मारक् कुसिङ् मे़निःत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","हे़क्‍क्‍याङ् दाङ्‌बाल्‍ले़ नोगे़न् पिरुआङ् मनाहाॽरे़ यरिक् खरे़ःङ्‌हाॽ मे़जबा ते़न्‍निल्‍ले़ कुबेसाङ् तिबेरियस ये़क्‌यक्‍कोनु कुभा खःङ्‌बेहाॽ खे़प्‍मो मे़गे़रे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ये़सुःन् नु कुहुॽसाम्‍बाहाॽ खे़प्‍मो मे़होःप् के़लॽबा निङ्‌वाॽ मे़घोःसुआङ् याम्‍मो खे़न् मनाहाॽ खे़न् खःङ्‌बेहाॽओ मे़लाःसे़आङ् नाहाङ्‌दाङ् कपर्नहुम्‍मो ये़सुरे़ कुगोःत्‍छे़ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","खे़ङ्‌हाॽ वरक्‍किल्‍ले़ नाधाःम्‍बि मे़गे़रे़ल्‍ले़ ये़सुःन् मे़दुमुआङ् सेःन्‍मे़दोसु “सिक्‍साम्‍बे, खे़ने़ॽ आप्‍फाल्‍ले़ कप्‍मो के़भे़रे़बे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, से़क्‍खाए मे़त्‍निङ्, खिनिॽ निङ्‌वाॽ के़माबा मिक्‍सेःन्‍निन् के़निःसुम्‍माङ् मे़ःन्, कर खाघा खरे़ःङ्‌ङिन् के़जाम्‍माङ्‌ने़ याप्‍मि के़गोःत्तिबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","खिनिॽ चागे़सोःक्‍पाआङ् के़बेःक्‍पा कुजारे़ लागि याःम्‍बक् मे़जोगे़म्‍मिन्‍ने़ॽ, कर इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़ पिनिङ्‌बा मे़न्‍नुप्‍मनाबा हिङ्‌मन् थारिक् के़धःप्‍पा कुजाओ निङ्‌वाॽ पिरे़म्‍मे़ॽ, थेआङ्‌भे़ल्‍ले़ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ बा हे़क्‍के चोःक्‍से़ए इङ्‌गाॽ युक् पिराङ्‌ङाङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ सेःन्‍मे़दोसु, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ आनिगे़ थे चोगुम्‍बे़बा निङ्‌वाॽ इःत्तुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुयाःम्‍बक्‍किङ्‌ग खुने़ॽ पाङ्‌घुबा मनाःन् नसाःन् के़जोगुम्‍ल फाॽआङ् निङ्‌वाॽ चोगुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ सेःन्‍मे़दोसु, “आक्‍तङ्‌बा निङ्‌वाॽ के़माबा मिक्‍सेःन् के़जोगुआङ् आनिगे़ नसाःन् चोःक्‍कासिगे़बाबे? आनिगे़ लागि खे़ने़ॽ थे के़जोगुबे? ");
INSERT INTO lifNT2_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","आनिगे़ सुधे़बा ताक्‍थे़बाहाॽरे़ग ये़ःङ्‌घादे़न्‍नो मन्‍नाःन्‌मे़ज॥ साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् पत्, ‘निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़ङ्‌हाॽ साङ्‌ग्राम्‍पेदाङ्‌लाम् खरे़ःङ्‌ङिन् चामा पिरुसिरो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ये़सुरे़ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, मोसारे़ खिनिॽ के़बिरिबा खरे़ःङ्‌ङिङ्‌ग साङ्‌ग्राम्‍पेदाङ्‌बा मे़ःन्, कर साङ्‌ग्राम्‍पेदाङ्‌लाम् खे़न् से़क्‍खाबा खरे़ःङ्‌ङिन् पानुदिङ् आम्‍बारे़ने़ के़बिरिबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ से़क्‍खाबा कुघरे़ःङ्‌ङिङ्‌ग साङ्‌ग्राम्‍पेदाङ्‌लाम् के़युःबाआङ् मे़न्‍छाम् याप्‍मिहाॽ ने़त्तिगे़न् हिङ्‌मन् के़बिबान्‍नेरो” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","खे़ङ्‌हाॽरे़ मे़मे़त्तु, “आदाङ्‌बे, खे़न् खरे़ःङ्‌ङिन् सदादिङ् याप्‍मि आबिरे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाबा हिङ्‌मन् के़बिबा खरे़ःङ्‌आरो, इङ्‌गाॽओ के़दाःबान् याम्‍मो आप्‍फाल्‍ले़आङ् कुसे़त्‍मे़लाःक्‍ने़न्, हे़क्‍क्‍याङ् इङ्‌गाॽ याप्‍मि नसाःन् के़जोःक्‍पे़न्‌याम्‍मो आप्‍फाल्‍ले़आङ् कुवामे़मिःक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","कर इङ्‌गाॽ याप्‍मि आगे़निःसिसाङ् नसाःन् आगे़न्‍जोगिन् फाॽआङ् से़क्‍खाए मे़त्‍निङ्‌ङाङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","पानुदिङ् पाःल्‍ले़ पिआबाहाॽ के़रे़क् इङ्‌गाॽओ मे़दाःॽ, हे़क्‍क्‍याङ् आत्तिन् इङ्‌गाॽओ ताः खे़न् आप्‍फाल्‍ले़आङ् मे़ले़रुङ्‌ङिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","इङ्‌गाॽग इक्‍सादिङ् खाम्‍बेःक्‍मो साङ्‌ग्राम्‍पेदाङ्‌लाम् आनिङ्‌वाॽ हे़क्‍के चोःक्‍से़ मे़न्‍दाबे़न्‍लो कर पानुदिङ् आम्‍बारे़ कुनिङ्‌वाॽ कुइसिःक् चोःक्‍से़ पाङ्‌घाङ्‌ङाङ् त्‍याङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","हे़क्‍क्‍याङ् याप्‍मि के़बाङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ इङ्‌गाॽ पिराङ्‌बा लत्‍थिक्‍काङ् मे़म्‍माए कत्तुङ्‌सिङ्‌ल हे़क्‍क्‍याङ् कुनुप्‍मा ये़न्‍नो कुहिङ्‌वे़त् चोगुङ्‌सिङ्‌ल के़लॽबा खुने़ॽ कुनिङ्‌वाॽ वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","थेआङ्‌भे़ल्‍ले़ कुस्‍साःन् के़निःबाआङ् नसाःन् के़जोःक्‍पा के़रे़क्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् मे़घोःसुर के़लॽबा पानुदिङ् आम्‍बारे़ कुनिङ्‌वाॽ वाॽरो॥ हे़क्‍क्‍याङ् कुनुप्‍मा ये़न्‍नो खे़ङ्‌हाॽ कुहिङ्‌वे़त् चोगुङ्‌सिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","हे़क्‍क्‍याङ् यहुदिहाॽरे़ “‘ये़सुरे़ इङ्‌गाॽ साङ्‌ग्राम्‍पेदाङ्‌लाम् के़युःबा खरे़ःङ्‌आ’” पाःत्तुबा पाःन्‍नो खुनिॽ निङ्‌वाॽ मे़द्‌ये़ने़न्‍नाङ् मुनुक्‍नुक् लॽमा मे़हेःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","खे़ङ्‌हाॽ अक्‍खे मे़मे़त्‍छिङ्, “कन् युसुफरे़ कुस्‍साः ये़सुःन् मे़ःम्‍बि? कल्‍ले़ कुम्‍बा कुम्‍मासि आनिॽ कुसिङ् आन्‍निःत्तुम्‍सिम्‍मिम्‍बि? हे़क्‍केःल्‍ले़ आक्‍खेआङ् खे़ल्‍ले़ ‘इङ्‌गाॽ साङ्‌ग्राम्‍पेदाङ्‌लाम् त्‍याङ्‌बा’ पाःप्‍मा सुक्‍तुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","कर ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ मुनुक्‍नुक् मे़लॽरे़म्‍मिन्‍ने़ॽ, ");
INSERT INTO lifNT2_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ याप्‍मि के़बाङ्‌बा पानुदिङ् पाःल्‍ले़ मनाहाॽ इङ्‌गाॽओ ताःमा निङ्‌वाॽ मे़बिरुन्‍सिन्‍ल थारिक् आत्तिन्‍नाङ् इङ्‌गाॽओ ताःमा मे़न्‍छुक्‍ने़न्‍लो॥ खे़ङ्‌हाॽ मे़दाने़ फाॽग्र इङ्‌गाॽ कुनुप्‍मा ये़न्‍नो कुहिङ्‌वे़त् चोगुङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ खुनिॽ साप्‍पन्‍नो अक्‍खेलॽरिक् मे़साप्‍तुआङ् पत्, ‘खे़ङ्‌हाॽग के़रे़क् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ हुॽरुसिबा मे़बोःङ्‌लो॥’ पानुदिङ् पाःल्‍ले़ कुबाःन् के़घे़म्‍बाहाॽ नु खुने़ॽलाम्‍बा के़हुॽसिङ्‌बाहाॽ के़रे़क् इङ्‌गाॽओ मे़दारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","आत्तिल्‍ले़आङ् पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिन् मे़न्‍निए वाॽरो, कर निङ्‌वाॽफुमाङ्‌लाम् के़दाःबाल्‍ले़रक् निःसुआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, इङ्‌गाॽ नसाःन् के़जोःक्‍पे़न्‍नु मे़न्‍नुप्‍मनाबा हिङ्‌मन् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","इङ्‌गाॽए से़क्‍खाबा हिङ्‌मन् के़बिबा खरे़ःङ्‌आरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","खिनिॽ सुधे़बा ताक्‍थे़बाहाॽरे़ ये़ःङ्‌घादे़न्‍नो मन्‍ना मे़जसाङ् मे़स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","कर साङ्‌ग्राम्‍पेदाङ्‌लाम् के़युःबा खरे़ःङ्‌ङिन् कप्‍मो वाॽरो, आत्तिन् मनाःल्‍ले़ कन् चः खे़न् मे़सिःने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","इङ्‌गाॽए खे़न् साङ्‌ग्राम्‍पेदाङ्‌लाम् के़युःबा मे़न्‍नुप्‍मनाबा हिङ्‌मन् के़बिबा खरे़ःङ्‌आरो॥ हाःत्‍ले़ कन् खरे़ःङ्‌ङिन् चःॽ खे़ङ्‌ग सदादिङ् हिङ्‌लो॥ कन् खरे़ःङ्‌ङिङ्‌ग नासिङ्‌गे़न् आधक्‍किन्‍नेरो॥ इक्‍सादिङ् खाम्‍बेःक्‍मोबा मे़न्‍छाम् याप्‍मिहाॽ मे़हिङ्‌ल फाॽआङ् कन्‍निन्‌पिरुङ्‌सिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","हे़क्‍क्‍याङ् खे़प्‍मो के़वाॽबा यहुदिहाॽरे़ कन् पाःन्‍निन् मे़घे़प्‍सुआङ् खुनिॽ लुम्‍मो “कन् मनाःल्‍ले़ आक्‍खेलॽरिक्‍काङ् नासिङ्‌गे़न् कुधक्‍किन् चामा फाॽआङ् पिमा आसुक्‍पाबे?” मे़बाःत्तुर पाःन्‍धङ् चोःक्‍मा मे़हेःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, मे़न्‍छाम्‍साःल्‍ले़ कुधक्‍किन् मे़न्‍जाए नु कुमाक्‍खिॽइन् मे़न्‍धुङ्‌ङे थारिक् खिनिॽओ मे़न्‍नुप्‍मनाबा हिङ्‌मन् मे़वाॽने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","कर इङ्‌गाॽ आधक्‍किन् के़जाबा नु आमाक्‍खिॽ के़धुङ्‌बाल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍निन् कत्तुॽरो॥ हे़क्‍क्‍याङ् खे़न् कुनुप्‍मा ये़न्‍नो इङ्‌गाॽ कुहिङ्‌वे़त् चोगुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आधक्‍किन् हे़क्‍क्‍याङ् आमाक्‍खिॽइन्‌से़क्‍खाबा चामा थुङ्‌मा चारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","इङ्‌गाॽ आधक्‍किन् के़जाबान्‌नु आमाक्‍खिॽ के़धुङ्‌बान् इङ्‌गाॽओ वाॽ हे़क्‍क्‍याङ् इङ्‌गाॽ खुने़ॽओ वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","हिङ्‌मन्‍दाङ्‌बा पानुदिङ् पाःल्‍ले़ इङ्‌गाॽ पाङ्‌घाङ् हे़क्‍क्‍याङ् खुने़ॽ चोगुल्‍ले़ हिङ्‌ङाबा कुइसिःक् इङ्‌गाॽ आधक्‍किन् के़जाबान्‍नाङ् इङ्‌गाॽ चोगुङ्‌ङिल्‍ले़ हिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","कन् आधक्‍किन्‍ने साङ्‌ग्राम्‍पेदाङ्‌लाम् के़युःबा खरे़ःङ्‌लो॥ खिनिॽ सुधे़बा ताक्‍थे़बाहाॽरे़ मन्‍नाःन् मे़जआङ् मे़स्‍ये़ कर कन् खरे़ःङ्‌ङिन् के़जाःबाङ्‌ग सदादिङ् हिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ये़सुरे़ कन् पाःन्‍निन् कपर्नहुम्‍मोबा यहुदि चुम्‍लुङ्‌हिम्‍मो हुॽरुसिल्‍ले़ पाःत्तुबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","कन् पाःन्‍निन् मे़घे़प्‍सुआङ् यरिक् हुॽसाम्‍बाहाॽरे़ अक्‍खे मे़बाःत्तु, “कन् पाःन्‍निङ्‌ग के़साक्‍पा निसाम्‍लो॥ कन् हाःत्‍ले़ नाःप्‍मा सुक्‍तुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ये़सुरे़ कुहुॽसाम्‍बाहाॽ मुनुक्‍नुक् मे़लॽरे़बा निङ्‌वाॽ खोःसुआङ् खे़ङ्‌हाॽ मे़त्तुसि, “कल्‍ले़ खिनिॽ निङ्‌वाॽ खःसुबि? ");
INSERT INTO lifNT2_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","मे़न्‍छाम्‍साःन् तगि आत्ति वये़ खे़प्‍मोए याम्‍मो नुःङ् पेःक्‍पा खिनिॽ के़निःसुम्‍मिल्‍ले़ आक्‍खे के़बाःत्तुम्‍बे? ");
INSERT INTO lifNT2_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","सेसेमाङ्‌ङिल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍निन् आबिॽरो, कर मे़न्‍छाम् थुम्‍मिल्‍ले़ थेआङ् चोःक्‍मा मे़सुक्‍तुन्‍लो॥ इङ्‌गाॽ मे़त्‍निङ्‌बा पाःन्‍जाक्‍हाॽ याम्‍साम् नु हिङ्‌मन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","कर खिनिॽओ कुभारे़ इङ्‌गाॽ नसाःन् आगे़न्‍जोगिन्॥” (थेआङ्‌भे़ल्‍ले़ ये़सुरे़ कुहेःक्‍सिङ्‌मोनुए आत्तिन्‍हाॽरे़ खुने़ॽ नसाःन् मे़न्‍जोगुन् हे़क्‍क्‍याङ् हाःत्‍ले़ खुने़ॽ इङ्‌ले़क्‍तुॽ के़लॽबान् निःसुआङ् वये़रो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","हे़क्‍क्‍याङ् खुने़ॽ मे़त्तुसि, “खे़ल्‍ले़ चोगुल्‍ले़ए मे़न्‍छाम् याप्‍मिहाॽ पानुदिङ् पाःल्‍ले़ मे़म्‍बिए थारिक् इङ्‌गाॽओ ताःमा मे़न्‍छुक्‍ने़न्‍लो लॽरिक् पाःत्तुङ्‌बा पाःन्‍निल्‍ले़ कुबेःन् बा खे़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","कन् ये़म्‍माङ्धो यरिक् कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ पक्‍मे़धःआङ् मे़बेरो हे़क्‍क्‍याङ् खुने़ॽनु याम्‍मो लाङ्‌मे़ङ्‌घेःगे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","हे़क्‍क्‍याङ् ये़सुरे़ थिक्-ने़त् (१२) कुहुॽसाम्‍बाहाॽ ले़प्‍माङ् हिसिङ्‌ङाङ् मे़त्तुसि, “खिनिॽआङ् याप्‍मि आगे़ले़रिॽआङ् के़बेगिबाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","सिमोन पत्रुसरे़ नोगप् पिरु, “आदाङ्‌बे, हाःत्‍लो पेगिगे़बाबे? खे़ने़ॽरक् मे़न्‍नुप्‍मनाबा हिङ्‌मन् के़बिबा पाःन्‍जाक्‍किन् के़गत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","खे़ने़ॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़बाङ्‌घे़बा सेसे कुमनाःन्‍ने़ॽ फाॽआङ् आनिगे़ निःसुम्‍बे़ हे़क्‍क्‍याङ् नसाःन् चोगुम्‍बे़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","हे़क्‍क्‍याङ् ये़सुरे़ मे़त्तुसि, “इङ्‌गाॽ खिनिॽ थिक्-ने़त्‍हाॽ सेःक्‍निङ्‌ङाङ् वाॽआरो, कर खिनिॽओ थिक्‍किन् माफे़न्‍साम् पोःक्‍खे़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(ये़सुरे़ थिक्-ने़त् हुॽसाम्‍बाहाॽओ थिक् सिमोन इस्‍करियोतरे़ कुस्‍साः यहुदा इस्‍करियोतरे़ कुयाःम्‍बेओ पाःत्तुआङ् वये़॥ खे़ल्‍ले़ ताःन्‍दि खुने़ॽ इङ्‌ले़क्‍तुॽरो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","खे़न् एगाङ् ये़सुःन् गालिल थुम् खिरिबा पाङ्‌भेॽहाॽओ ताक्‍कन्‍दे़र वये़रो॥ खुने़ॽग यहुदिया थुम्‍लाम् माःङ्‌घाए वाॽमा निङ्‌वाॽ चोगु, थेआङ्‌भे़ल्‍ले़ यहुदि लाम्‍लोःबाहाॽरे़ खुने़ॽ से़प्‍मा फाॽआङ् मे़सुगुर मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","कर यहुदिहाॽरे़ खुनिॽ साःङ्‌गाहिम् तङ्‌नाम्‍मिन् ताःमा इःत्ते़ल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","कुन्‍साॽसिरे़ ये़सुःन् अक्‍खे मे़मे़त्तु, “खे़ने़ॽ कन् ते़न्‍निन् ले़रे़ॽआङ् यहुदियाओ पेगे़ॽओ, खे़ल्‍ले़ चोगुल्‍ले़ खे़प्‍मो खे़ने़ॽ के़जोगुबा निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ वेॽ के़हुॽसाम्‍बाहाॽरे़आङ्‌मे़निःसुररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","आत्तिन् मनाःल्‍ले़ कुमिङ्‌सो कुधाःङ्‌सो फोःमा निङ्‌वाॽ चोगुॽ, खे़न् चिङ्‌सिङ्‌मा मे़नुॽने़न्‍लो॥ हे़क्‍केलॽरिक् खे़ने़ॽआङ् निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ के़जोगुर के़वाॽने़ फाॽग्र इक्‍सादिङ् खाम्‍बेःक्‍मो ओसेःन्‍धाक्‍सिङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","थेआङ्‌भे़ल्‍ले़ आबाङे कुन्‍साॽसिरे़आङ् खुने़ॽ नामे़न्‍छाॽरुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ये़सुरे़ नोगप् पिरुसि, “इङ्‌गाॽ आये़म्‍मिन् मे़न्‍दाए वाॽरो॥ खिनिॽग आप्‍फाल्‍ले़साङ् पेःक्‍मा के़सुक्‍तिॽरो, ");
INSERT INTO lifNT2_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","इक्‍सादिङ् खाम्‍बेःक्‍मोबाहाॽरे़ खिनिॽ चिःप्‍मा के़मे़न्‍छुक्‍तिन्‍लो, कर खे़ङ्‌हाॽरे़ मे़जोगुबा याःम्‍बक्‍हाॽ ताप्‍फे़ःम्‍बा चोःक् मे़त्तुङ्‌सिङ्‌बाल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽ मे़जिःत्तारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","तङ्‌नाम्‍मो खिनिॽ थो यरुसले़म्‍मो पेगे़म्‍मे़ॽओ॥ इङ्‌गाॽ आल्‍लो मे़बेःक्‍कान्, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आये़म्‍मिन् मे़न्‍दाए वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ये़सुरे़ अक्‍खे पाःत्तुर गालिलओए वये़ लारे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","कर ये़सुरे़ कुन्‍साॽसि तङ्‌नाम्‍मो मे़बे हे़क्‍क्‍याङ् ये़सुःन्‍नाङ् आत्तिन् मनाहाॽरे़आङ् मे़न्‍निए स्‍वाःत्ताङ् यरुसले़म्‍मो पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","आल्‍ल तङ्‌नाम्‍मो यहुदि लाम्‍लोःबाहाॽरे़ खुने़ॽ मे़गोःत्तुर अक्‍खे मे़बाःत्तु, “कन् मनाःन् आत्तान् पेबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","यरिक् मनाहाॽरे़ ये़सुरे़ कुयाःम्‍बेओ स्‍वाःत्ताङ् मे़जे़क्‍खु॥ कुभारे़ मे़बाःत्तु, “खुने़ॽग नुःबा मनारो” कर वेॽहाॽरे़ मे़बाःत्तु, “मे़ःन्, खे़ल्‍ले़ग मनाहाॽ इङ्‌ले़क्‍तुसिर वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","कर यहुदि लाम्‍लोःबाहाॽ मे़गिरुसिबाल्‍ले़ चोगुल्‍ले़ आत्तिन्‍हाॽआङ् मनाहाॽरे़ मे़घे़प्‍सुर ये़सुरे़ कुयाःम्‍बेओ मे़म्‍बारे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","हे़क्‍क्‍याङ् तङ्‌नाम्‍मिल्‍ले़ कुलुम्‍मो ये़सुःन् माङ्‌हिम्‍मो थो पेआङ् मनाहाॽ निसाम् हुॽमा हेःक्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","यहुदि लाम्‍लोःबाहाॽरे़ खुने़ॽ कुनिसाम्‍मिन् मे़घे़प्‍सुआङ् खुनिॽ निङ्‌वाॽ मये़र अक्‍खेलॽरिक् मे़बाःत्तु, “कन् मनाःल्‍ले़ मे़न्‍हुॽसिङ्‌ङे आक्‍खेलॽरिक् आनिॽ हे़क्‍के कन् निसाम्‍मिन् ले़स्‍सुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “इङ्‌गाॽ आनिसाम्‍मिङ्‌ग आबाङे इङ्‌गाॽइन् मे़ःन्‍लो, कर कङ्‌ग इङ्‌गाॽ याप्‍मि के़बाङ्‌बा निङ्‌वाॽफुमाङ्‌लाम् त्‍ये़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","आत्तिन् मनाःल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिङ्‌वाॽ हे़क्‍के चोःक्‍मा निङ्‌वाॽ चोगुॽ, खे़ल्‍ले़ इङ्‌गाॽ आनिसाम्‍मिन् निङ्‌वाॽफुमाङ्‌लाम्‍बा त्‍ये़बाबि इङ्‌गाॽ आबाङे पाःत्तुङ्‌बाबि फाॽआङ् कुसिङ् निःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","आबाङे युक्‍कोलाम्‌के़बाःप्‍पाहाॽरे़ग आबाङे मिङ्‌सो इङ्‌धाःङ् मे़गोःत्तुॽरो, कर आत्तिल्‍ले़ खुने़ॽ के़बाङ्‌बान् मिङ्‌सो इङ्‌धाःङ् पिमा निङ्‌वाॽ चोगुॽ, खे़ल्‍ले़ से़क्‍खा पाःन् पाःत्तुॽरो॥ हे़क्‍क्‍याङ् खुने़ॽओ थेआङ् इङ्‌ले़क्‍पा पाःन् होःप्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","मोसारे़ खिनिॽ साम्‌योथिम् के़बिरि, कर खिनिॽ आत्तिन्‍हाॽरे़आङ् के़न्‍इःत्तुम्‍मिन् के़न्‍नाःत्तुम्‍मिन्॥ हे़क्‍केःल्‍ले़ थेआङ् खिनिॽ याप्‍मि से़प्‍मा के़गोःत्तिबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","खे़न् मनाहाॽरे़ खुने़ॽ नोगप् मे़बिरु, “खे़ने़ॽग फे़न्‍साम्‍मिल्‍ले़ के़याङ्‌घे़आङ् के़वाॽरो! हाःत्‍ले़ खे़ने़ॽ से़प्‍मा के़गोःत्ते़बे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “इङ्‌गाॽग लत्‍छा मनाधिक् नाःम्‍सिङ्‌मा ये़न्‍नो नुसुङ्‌ङिल्‍ले़ खिनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","कर खिनिॽआङ् मोसारे़ के़बिरिबा हर्दो हे़क्‍मा साम्‌योथिम्‍मिन् के़नाःत्तुम् के़इःत्तुम्‍माङ् नाःम्‍सिङ्‌ये़न्‍नोए खिनिॽ साःहाॽरे़न् हर्दो के़हे़गुम् के़बिरुम्‍सिम्‍मिल्‍ले़ खिनिॽआङ् साम्‌योथिम्‍मिन् के़भेःन्‍दुम्‍लो॥ (से़क्‍खाःल्‍ले़ कन् हर्दो हे़क्‍मा साम्‌योथिम्‍मिङ्‌ग मोसालाम् मे़ःन्, कर कङ्‌ग अब्राहाम्‍लाम् पोःक्‍खे़ ये़बारो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","आल्‍ल मोसारे़ कुसाम्‌योथिम्‍मिन् मे़बेःन्‍ने़न्‍ल फाॽआङ् नाःम्‍सिङ्‌ये़न्‍नो खिनिॽ साःहाॽरे़न् हर्दो हे़क्‍मा याःम्‍बक् के़जोगुम्‍ने़ फाॽग्र, इङ्‌गाॽ कन् मनाःन् नाःम्‍सिङ्‌मा ये़न्‍नो नुसुङ्‌ङिल्‍ले़ थेआङ् इङ्‌गाॽनु खिनिॽ याःक्‍ले़ॽबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","मना ओमे़प्‍मासिआङ्‌मे़ःन् कर से़क्‍खाओ खासे़न् लोःन्‍दे़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","खे़न् ये़म्‍मो यरुसले़म के़युङ्‌बा कुभा मनाहाॽ अक्‍खे मे़मे़त्‍छिङ्, “मे़ःम्‍बे़, से़प्‍मा मे़गोःत्तुर मे़वाॽबा मनाःन् बा कन् मे़ःम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","कर कङ्‌ग मनाहाॽरे़ मे़घे़प्‍सुरए पाःत्‍ल वाॽरो॥ हे़क्‍केसाङ् खे़ङ्‌हाॽरे़ थेआङ् मे़म्‍मे़त्तुन्‍लो॥ मे़ःम्‍बे़, आनिॽ लाम्‍लोःबाहाॽरे़ खुने़ॽए निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त फाॽआङ् कुसिङ् मे़निःत्तुबि? ");
INSERT INTO lifNT2_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","कन् मनाःन् आत्तोलाम् त्‍ये़ के़लॽबा आनिॽ आनिःसुम्‍लो॥ कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌ताःल्‍ले़ग खुने़ॽ थाःम्‍सिङ्‌लक्‍लो, खुने़ॽ आत्तोलाम् ताः के़लॽबा आत्तिल्‍ले़आङ् मे़निःसुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ये़सुरे़ माङ्‌हिम्‍मो हुॽरुसिर पत्‍छे़ल्‍ले़ यम्‍बा इक्‍लाओ अक्‍खेलॽरिक् पारे़, “ओरो, खिनिॽ इङ्‌गाॽ कुसिङ् याप्‍मि के़निःत्तिॽ हे़क्‍क्‍याङ् आत्तोलाम् त्‍याङ्‌बा खे़न्‍नाङ् खिनिॽ के़निःसुम्, कर इङ्‌गाॽ आबाङे त्‍याङ्‌बा मे़ःन्‍लो॥ इङ्‌गाॽ याप्‍मि के़बाङ्‌बाङ्‌ग से़क्‍खाए चोःक् हे़क्‍क्‍याङ् खुने़ॽग खिनिॽ कुसिङ् के़न्‍निःत्तुम्‍मिन्‍लो, ");
INSERT INTO lifNT2_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","कर इङ्‌गाॽग खुने़ॽ कुसिङ् निःत्तुङ्‌लो, थेआङ्‌भे़ल्‍ले़ खुने़ॽलाम्‍बा त्‍याङ्‌बा हे़क्‍क्‍याङ् खुने़ॽ पाङ्‌घाङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ये़सुरे़ अक्‍खेलॽरिक् पाःत्तुल्‍ले़ मनाहाॽरे़ खुने़ॽ ते़म्‍मा मे़गोःत्तु, कर आत्तिन्‍हाॽरे़आङ् खुने़ॽ मे़न्‍छुस्‍सुन्‍लो, थेआङ्‌भे़ल्‍ले़ खुने़ॽ कुये़म्‍मिन् मे़ङ्‌गे़त्ते वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","हे़क्‍केसाङ् यरिक् मनाहाॽरे़ खुने़ॽ नसाःन् मे़जोगुरो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ अक्‍खे मे़बाःत्तु, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌ताःल्‍ले़ कन् मनाःन्‍नुःल्‍ले़आङ् यरिक् निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ चोगुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","मनाहाॽ ये़सुरे़ कुयाःम्‍बेओ स्‍वाःत्ताङ् खुस्‍खुस् लॽरिक् मे़बारे़बा फरिसिहाॽरे़ मे़घे़प्‍सुरो हे़क्‍क्‍याङ् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु फरिसिहाॽरे़ माङ्‌हिम्‍मोबा तिलिङ्‌गाहाॽ खुने़ॽ कुदे़म्‍से़ मे़बाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","कर ये़सुरे़ मे़त्तुसि, “इङ्‌गाॽग खिनिॽनु सप्‍फारक् कप्‍मो वाॽआरो हे़क्‍क्‍याङ् याप्‍मि के़बाङ्‌बाल्‍लो नुःङ्‌ङा पेःक्‍कारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","खिनिॽ याप्‍मि के़गोःत्तिॽ कर याप्‍मि के़ङ्‌घोःसिन्‍लो हे़क्‍क्‍याङ् इङ्‌गाॽ पेःक्‍काबा ते़न्‍नोआङ् के़प्‍मा के़न्‍छुक्‍तिल्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","यहुदि लाम्‍लोःबाहाॽ सेःन्‍मे़लाप्‍सिङ्, “मे़ःम्‍बे़, खुने़ॽ आत्तो पेःक्‍मा निङ्‌वाॽ चोगुर वाॽआङ् आनिॽ तुम्‍मा आन्‍छुक्‍तुम्‍मिन्‍बाबे? खुने़ॽ वेॽ लाजेॽओ के़युङ्‌बा आनिॽ मनाहाॽरो पेःक्‍काङ् थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽ हुॽरुसिबाबि? ");
INSERT INTO lifNT2_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","खिनिॽ याप्‍मि के़गोःत्तिॽ कर याप्‍मि के़न्‍दुमिन् हे़क्‍क्‍याङ् आत्तान् पेःक्‍का खे़न् ते़न्‍नोआङ् के़प्‍मा के़न्‍छुक्‍तुम्‍मिल्‍लो लॽरिक् थे पाःत्तुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","हे़क्‍क्‍याङ् तङ्‌नाम्‌रे़ कुनुप्‍मा नु के़ये़क्‍पा ये़न्‍नो ये़सुःन् ये़म्‍सिङ्‌ङाङ् यम्‍बा इक्‍लाओ मनाहाॽ अक्‍खेलॽरिक् मे़त्तुसिरो, “खिनिॽ लुम्‍मो कुवागे़मिःबाल्‍ले़ इङ्‌गाॽओ ताआङ् थुङुररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","साम्‌योसाप्‍लाःल्‍ले़ पाःत्तुबा कुइसिःक् इङ्‌गाॽ याप्‍मि नसाःन् के़जोःक्‍पाल्‍ले़ कुसिगाङ्‌लाम् हिङ्‌मन् के़बिबा च्‍वाःत्तिन् यङ्‌घङ् कुइसिःक् पुन्‍लःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","कङ्‌ग ये़सुरे़ सेसेमाङ्‌ङिल्‍ले़ कुयाःम्‍बेओ पाःत्तुबारो॥ थेआङ्‌भे़ल्‍ले़ खुने़ॽओ नसाःन् के़जोःक्‍पाहाॽरे़ सेसेमाङ्‌ङिन् मे़घोःसुबा पोःक्‍खे़आङ् वये़रो॥ सेसेमाङ्‌ङिन् खे़न् ये़म् थारिक् मे़म्‍बाङ्‌ङे वये़रो, थेआङ्‌भे़ल्‍ले़ ये़सुःन् साङ्‌ग्राम्‍पेदाङ्‌ङो मे़न्‍नुःङ् मे़म्‍बेःक्‍के वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","हे़क्‍क्‍याङ् कन् मे़घे़प्‍सुआङ् मनाहाॽरे़ अक्‍खे मे़बाःत्तु, “से़क्‍खासाङ् कन् मनाःङ्‌ग ताः लॽरिक् इःप्‍मनाबा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्‍नेरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","वेॽहाॽरे़ मे़बाःत्तु “खुने़ॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरो॥” कर आल्‍लसाङ् वेॽहाॽरे़ अक्‍खेलॽरिक् मे़बाःत्तु, “कङ्‌ग पोःङ्‌माए मे़सुक्‍ने़न्‍लो, थेआङ्‌भे़ल्‍ले़ ख्रिस्‍ते़ङ्‌ग गालिल थुम्‍मोलाम्‌मे़दाने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","साम्‌योसाप्‍लाओ तोःन्‍दोःन्‍नाङ् साप्‍ते़आङ् पत्‍लो, ‘निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़ङ्‌ग दाउद हाङ्‌ङिल्‍ले़ कुहिम्‍सयङ्‌लाम् हे़क्‍क्‍याङ् दाउद हाङ् वये़बा बे़थलेहे़म पाङ्‌जुम्‍मो सावाःन्‍छिङ्‌लो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","अक्‍खेलॽरिक् ये़सुरे़ कुयाःम्‍बेओ मनाहाॽरे़ खुनिॽ निङ्‌वाॽ मे़दङे़न्‍नाङ्‌मे़से़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","कुभारे़ खुने़ॽ ते़म्‍मा मे़गोःत्तु, कर आत्तिन्‍हाॽरे़आङ्‌खुने़ॽ हुक् मे़न्‌याक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","हे़क्‍क्‍याङ् खुने़ॽ कुदे़म्‍से़ के़दाःबा माङ्‌हिम्‍मोबा तिलिङ्‌गाहाॽ, तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु फरिसिहाॽरो आम्‍भा मे़नुःक्‍खे़ मे़बेरो॥ खे़ङ्‌हाॽरे़ माङ्‌हिम्‍मोबा तिलिङ्‌गाहाॽ सेःन्‍मे़दोसुसि “थेआङ् खुने़ॽ के़न्‍दे़म्‍सुम्‍मिन् के़न्‍दारुमिम्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","खे़ङ्‌हाॽरे़ नोगप् मे़बिरुसि, “आत्तिन्‍नाङ् खे़न् मनाःन् हे़क्‍के पारे़बाग मे़ङ्‌घे़म्‍मे वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","हे़क्‍केःल्‍ले़ फरिसिहाॽरे़ खे़ङ्‌हाॽ मे़मे़त्तुसि, “मे़ःम्‍बे़, खिनिॽआङ् खे़ल्‍ले़ कुइङ्‌ले़क्‍को के़ध्‍ये़ॽइबि थे़माबे? ");
INSERT INTO lifNT2_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","आनिॽ लाम्‍लोःबा नु फरिसिहाॽरे़ खुने़ॽओ नसाःन् मे़जोगुआङ् वाॽबि? ");
INSERT INTO lifNT2_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","आत्तिल्‍ले़आङ् मे़न्‍जोःक्‍के वाॽ॥ कन् साम्‌योथिम्‍मिल्‍ले़ कुयाःम्‍बेओ थेआङ् मे़ल्‍ले़मनाबा मनाहाॽरे़रक् मे़जोगुआङ् वाॽरो॥ कन् मनाहाॽग निङ्‌वाॽफु साङ्‌ग्रारे़ ते़त्तुसिआङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","तगि थिक् से़न्‍दिक् ये़सुरे़ कुदुम्‍से़ के़बेःक्‍पा निकोदेमस मे़प्‍मनाबा खुनिॽ लुम्‍मोबा थिक् फरिसि लाम्‍लोःबान् पारे़रो, ");
INSERT INTO lifNT2_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“मे़ःम्‍बे़, खे़न् मनाःल्‍ले़ थे चोगुर वाॽ के़लॽबान् नुःरिक्‍काङ् कुसिङ् मे़न्‍निःत्ते आप्‍तिक् कुःप्‍मा आनिॽ साम्‌योथिम्‍मिल्‍ले़ आबिॽबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “खे़ने़ॽआङ् गालिललाम्‍मे के़द्‌ये़बाबि? खे़ने़ॽ आबाङे साम्‌योसाप्‍लाःन् निःरे़ साॽरे़, गालिललाम्‍बाग आप्‍फाल्‍ले़आङ् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्‌मे़दाने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","((हे़क्‍क्‍याङ् मनाहाॽ आबाङे हिम्हिम् मे़नुःक्‍खे़ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","कर ये़सुःन् जैतुन कोःक्‍माओ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","हे़क्‍क्‍याङ् कुदाःन्‍दिक्‍मा खाओःत्ते़नुमे़ःन्‍ने खुने़ॽ माङ्‌हिम्‍मो त्‍ये़॥ हे़क्‍क्‍याङ् खे़प्‍मो मनाहाॽ चुम्‍मा मे़हेःक्‍ते़आङ् खुने़ॽ युङ्‌सिङ्‌ङाङ् खे़ङ्‌हाॽ निसाम् हुॽमा हेःक्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","हे़क्‍क्‍याङ् साम्‌योथिम्‍साम्‍बाहाॽ नु फरिसिहाॽरे़ चाराम्‍मा याःम्‍बक् चोगुर पत्‍छे़ल्‍ले़ मे़दे़म्‍सुमा मे़न्‍छुमाॽधिक् खे़प्‍मो मे़दारुआङ् मनालुप्‍हाॽरे़ खुनिॽ तगि मे़ये़प्‍सु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","खे़ङ्‌हाॽरे़ ये़सुःन् सेःन्‍मे़दोसु, “सिक्‍साम्‍बे, कन् मे़न्‍छुमाॽइन् चाराम्‍मा याःम्‍बक् चोगे़र पत्‍छे़ल्‍ले़ए मे़दे़म्‍सुआङ् तारुम्‍बे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","साम्‌योथिम् साप्‍लाओ मोसाःल्‍ले़ग अक्‍तङ्‌मा मे़न्‍छुमाॽइन् लुङ्‌ङिल्‍ले़ ले़प्‍मा से़प्‍मा फाॽआङ् इङ्‌जाःङ् पिरिगे़आङ् वाॽरो, कर खे़ने़ॽग थे याप्‍मि के़मे़प्‍पे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","खे़ङ्‌हाॽरे़ खुने़ॽ पाःन्‍नो थाःमाआङ् कुदक्‍ले़ङ्‌वाओबा पाःन्‍निन् खोःमा फाॽआङ् कन् सेःन्‍मे़दोसुआङ् वये़, कर ये़सुःन् थुःङ्‌सिङ्‌ङाङ् खाम्‍बाङ्‌ङो थेधेइ कुहुक्‍चोःल्‍ले़ साप्‍तुर युङे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","खे़ङ्‌हाॽरे़ ए़त्‍ले़ङ् सेःन्‍मे़दोसुबाल्‍ले़ चोगुल्‍ले़ खुने़ॽ पोगे़आङ् खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽओ आल्‍लो थारिक् लायो मे़न्‍जोःक्‍के के़वाॽबा हाःत् वाॽ? हाराॽ बा खे़ल्‍ले़ए के़रे़क्‍नुःल्‍ले़ तगि कन् मे़न्‍छुमाॽइन् लुङ्‌ङिल्‍ले़ ले़प्‍तुररो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","खुने़ॽ याम्‍मो अःक्‍खुम् फन्‍छिङ्‌ङाङ् खाम्‍बाङ्‌ङो साप्‍मा हेःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","कन् पाःन्‍निन् मे़घे़प्‍सुआङ् के़रे़क्‍नुःल्‍ले़ तगि तुम्‍भाक्‍सा हे़क्‍क्‍याङ् खे़न्‍नाङ् योबाहाॽ थिक् थिक् लॽरिक् पेःक्‍मा मे़हेःक्‍ते़रो॥ हे़क्‍क्‍याङ् खे़प्‍मो ये़सुःन् नु खे़न् मे़न्‍छुमाॽइन्‍लक् याःक्‍ते़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","हे़क्‍क्‍याङ् ये़सुःन् पोगे़आङ् खे़न् सेःन्‍दोसु “मामुए, खे़ने़ॽ पाःन् के़धिक्‍पाहाॽ आत्ति मे़बेबे? हाःत्‍ले़आङ् खे़ने़ॽ पाःन् के़न्‍धिक्‍ते़न्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","खे़न् मे़न्‍छुमाॽइल्‍ले़ नोगप् पिरु, “होःप्‍लो, आदाङ्‌बे!” हे़क्‍केःल्‍ले़ ये़सुरे़आङ् मे़त्तु, “इङ्‌गाॽआङ् मे़धिक्‍ने़न्‍लो॥ पेगे़ॽओ, कर याम्‍मो आप्‍फाल्‍ले़आङ् लायो मे़जोगे़न्‍ने़ॽओ॥”)) ");
INSERT INTO lifNT2_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","हे़क्‍क्‍याङ् ये़सुरे़ याम्‍मो मनाहाॽ मे़त्तुसि, “इङ्‌गाॽ इक्‍सादिङ् खाम्‍बेःक्‍मोबा ओःत्तिआरो॥ हाःत्‍ले़ इङ्‌गाॽ नसाःन् चोःक्‍का खे़न्‍नु हिङ्‌मन् के़बिबा ओःत्तिःन् वाॽ हे़क्‍क्‍याङ् आप्‍फाल्‍ले़आङ् खे़न् खादाम्‍मो लाङ्‌घेःक्‍मा मे़बोःङ्‌ने़ल्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","फरिसिहाॽरे़ खुने़ॽ मे़मे़त्तु, “खे़ने़ॽग आबाङे के़याःम्‍बेओ के़बाःत्तुॽरो हे़क्‍क्‍याङ् के़बाःत्तुबा पाःन्‍हाॽग से़क्‍खा मे़ःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ आबाःन्‍हाॽ आबाङे पाःत्तुङ्‌साङ् खे़न् से़क्‍खाएरो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आत्तोलाम् त्‍याङ्‌ङाङ् आत्तान् पेःक्‍कार पत्ता खे़न् नुःरिक्‍काङ् निःसुङ्‌लो कर खिनिॽग इङ्‌गाॽ आत्तोलाम् त्‍याङ्‌बा हे़क्‍क्‍याङ् आत्तो पेःक्‍कार पत्ता खे़न् थेआङ् के़न्‍निःसुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","खिनिॽग मे़न्‍छाम् थिम् कुइसिःक्‍के खासे़न् के़लोःन्‍दिॽरो, कर इङ्‌गाॽग आत्तिल्‍ले़न्‍नाङ् खासे़न् मे़जोगुङ्‌ङिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","कर इङ्‌गाॽ खासे़न् चोगुङ्‌ने़ फाॽग्र आघासे़न्‍निन् से़क्‍खाए पोःङ्‌लो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽरक् होःप्‍पारो॥ इङ्‌गाॽनुग याप्‍मि के़बाङ्‌बा पानुदिङ् आम्‍बाआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","खिनिॽ साम्‌योथिम्‍मो ने़प्‍फु मनाहाॽरे़ थिक् पाःन्‍नो तङ्‌सिआङ् तोःन्‍दि पिसुने़ फाॽग्र खे़न् तोःन्‍दिन् से़क्‍खाए पोःङ्‌लो लॽरिक् साप्‍ते़आङ् पत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","इङ्‌गाॽ आयाःम्‍बेओ तोःन्‍दि पिरुङ्‌लो, हे़क्‍क्‍याङ् याप्‍मि के़बाङ्‌बा पानुदिङ् आम्‍बारे़आङ् आयाःम्‍बेओ तोःन्‍दि पिरुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","खे़ङ्‌हाॽरे़ खुने़ॽ सेःन्‍मे़दोसु, “खे़ने़ॽ के़बाःत्तुर के़ने़बा पानुदिङ् के़म्‍बाग आत्तो वाॽबे?” ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽग इङ्‌गाॽ याप्‍मि कुसिङ् के़न्‍निःत्तिन् हे़क्‍क्‍याङ् पानुदिङ् आम्‍बाआङ् कुसिङ् के़न्‍निःत्तुम्‍मिन्‍लो॥ इङ्‌गाॽ याप्‍मि कुसिङ् के़निःत्तिल्‍ले़ग आम्‍बाआङ् कुसिङ् के़निःत्तुम्‍बामे़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ये़सुरे़ कन् पाःन्‍हाॽ माङ्‌हिम्‍मो हुक्‍सोयाङ् याक्‍मनाबादे़न्‍निल्‍ले़ कुबेसाङ् निसाम् हुॽरुसिर पत्‍छे़ल्‍ले़ पाःत्तुबारो, कर खुने़ॽग आत्तिन्‍हाॽरे़आङ् मे़न्‍दे़म्‍सुन्‍लो थेआङ्‌भे़ल्‍ले़ खुने़ॽ कुये़म् मे़न्‍दाए वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","याङ्‌सि ये़सुरे़ याम्‍मो खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽग पेःक्‍काआङ् खिनिॽ याप्‍मि के़गोःत्तिॽरो॥ हे़क्‍क्‍याङ् खिनिॽ आबाङे लायोओ के़स्‍ये़ॽइरो॥ इङ्‌गाॽ पेःक्‍काबा तेन्‍नो खिनिॽ ताःमा के़न्‍छुक्‍तिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","हे़क्‍केःल्‍ले़ यहुदि लाम्‍लोःबाहाॽ सेःन्‍मे़दोःसिङ्, “ये़सुःन् आबाङे से़त्‍छिङ्‌बाबि? खे़ल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽ पेःक्‍काबा तेन्‍नो ताःमा के़न्‍छुक्‍तिन्‍लो फाॽआङ् पाःत्तुबाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","खुने़ॽ याम्‍मो मे़त्तुसि, “खिनिॽग बा कॽयोबानिङ्‌लो, कर इङ्‌गाॽ थोलाम्‍बाआरो॥ खिनिॽग इक्‍सादिङ् खाम्‍बेःक्‍मोबानिङ्‌लो कर इङ्‌गाॽग मे़ःन्‍नाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽ आबाङे लायोहाॽओ के़स्‍ये़ॽइरो फाॽआङ् मे़त्‍निङ्‌बारो॥ इङ्‌गाॽ हाःत्‍आ फाॽआङ् मे़त्‍निङ्‌बान् खिनिॽ नसाःन् के़न्‍जोगुम्‍मिन्‍निल्‍ले़ग खिनिॽ से़क्‍खाए आबाङे लायोहाॽओ के़स्‍ये़ॽइ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","खे़ङ्‌हाॽरे़ सेःन्‍मे़दोसु, “हे़क्‍केःल्‍ले़ खे़ने़ॽ हाःत्‍ने़बे?” ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “इङ्‌गाॽ हाःत्‍आ फाॽआङ् तगिनुए मे़त्‍निङ्‌ल वाॽआबान्‍ने खुने़ॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","इङ्‌गाॽग खिनिॽ तक्‍ले़ङ्‌वाओ यरिक् पाःप्‍मा नु खिनिॽ फे़ःक्‍मा पाःन् कत्तुङ्‌लो॥ कर इङ्‌गाॽ याप्‍मि के़बाङ्‌बान् से़क्‍खाए चोःक्‍लो हे़क्‍क्‍याङ् खुने़ॽलाम् खे़प्‍सुङ्‌बा पाःन्‍निन्‍लक् इक्‍सादिङ् खाम्‍बेःक्‍मोबाहाॽ मे़त्तुङ्‌सिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ये़सुरे़ पानुदिङ् कुम्‍बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुयाःम्‍बेओ पाःत्तुबा फाॽआङ् खे़ङ्‌हाॽरे़ कुसिङ् मे़न्‍निःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","खे़ल्‍ले़ चोगुल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ मे़न्‍छाम्‍साःन् थाःङ् के़बक्‍खुम्‍मिल्‍ले़ इङ्‌गाॽ हाःत्‍आ फाॽआङ् निङ्‌वाॽ के़घोःसुम्‍लो हे़क्‍क्‍याङ् इङ्‌गाॽ आबाङे मे़बाःत्तान् कर इङ्‌गाॽ पानुदिङ् पाःल्‍ले़ हुॽराङ्‌बा पाःन्‍लक् पाःत्ता फाॽआङ् निङ्‌वाॽ के़घोःसुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","इङ्‌गाॽ याप्‍मि के़बाङ्‌बाङ्‌ग सदादिङ् इङ्‌गाॽनु वाॽरो॥ खुने़ॽग आप्‍फाल्‍ले़आङ् इङ्‌गाॽ एःक् मे़ल्‍ले़त्ते वाॽरो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ सदादिङ् कुनिङ्‌वाॽ के़दाःबा याःम्‍बक् चोगुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","खुने़ॽ अक्‍खेलॽरिक् पाःत्तुल्‍ले़ यरिक् मनाहाॽरे़ खुने़ॽओ नसाःन् मे़जोगुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ये़सुरे़ खुने़ॽओ नसाःन् के़जोःक्‍पा यहुदिहाॽ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, इङ्‌गाॽ पाःत्तुङ्‌बा पाःन्‍हाॽओ चक्‍मे़ल्‍लॽए के़बत्‍छिॽने़ फाॽग्र से़क्‍खाए आहुॽसाम्‍बा के़बोःक्‍खिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","हे़क्‍क्‍याङ् से़क्‍खाःन् कुसिङ् के़निःत्तुम्‍माङ् से़क्‍खाःल्‍ले़ चोःक्‌युम्‍भो के़बिरिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","खे़ङ्‌हाॽरे़ खुने़ॽ नोगप् मे़बिरु, “आनिगे़ग अब्राहामरे़ कुमुॽइदाङ्‌सासिगे़रो॥ हे़क्‍क्‍याङ् आप्‍फाल्‍ले़आङ् आत्तिल्‍ले़न्‍नाङ् कुयोःक्‍पा मे़म्‍बोःङ्‌ङे वयिगे़रो॥ हे़क्‍केःल्‍ले़ आक्‍खेलॽरिक् चोःक्‌युम्‍भो के़घोःसुम् लॽरिक् याप्‍मि के़मे़प्‍पाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्‌लो, हाःत्‍ले़ लायो चोगुॽ, खे़ङ्‌ग लायोरे़ कुयोःक्‍पा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","आल्‍ल योःक्‍पाङ्‌ग सदादिङ् हिम्सयङ्‌ङोबा मे़ःन्‍लो, कर साःङ्‌ग सदादिङ् हिम्‍सयङ्‌ङोबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","खे़ल्‍ले़ चोगुल्‍ले़ निङ्‌वाॽफुसाःल्‍ले़ चोःक्‌युम्‍भो के़जोगिने़ फाॽग्र से़क्‍खाए खिनिॽ चोःक्‌युम्‍भो के़बोःक्‍खिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","खिनिॽग अब्राहामरे़ कुमुॽइदाङ्‌सानिङ् फाॽआङ् निःसुङ्‌लो, हे़क्‍केसाङ् याप्‍मि से़प्‍मा के़गोःत्तिॽरो थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ हुॽनिङ्‌बा निसाम्‍मिन् खिनिॽ निङ्‌वाॽओ युङ्‌मा के़न्‍दे़न्‍दिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","इङ्‌गाॽग पानुदिङ् आम्‍बानु वयाङ्‌ङिल्‍ले़ निःसुङ्‌बा पाःन्‍हाॽए पाःत्तुङ्‌लो, कर खिनिॽग खिनिॽ पाःलाम् के़घे़प्‍सुम्‍बान्‍लक् के़जोगुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","खे़ङ्‌हाॽरे़ खुने़ॽ नोगप् मे़बिरु, “आनिगे़ पानुदिङ् पाःङ्‌ग अब्राहाम्‍मिन्‍नेरो॥” हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ अब्राहामरे़ कुस्‍साः के़वयिल्‍ले़ग अब्राहामरे़ चोगुबा कुइसिःक्‍के के़जोगुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","इङ्‌गाॽग निङ्‌वाॽफुमाङ्‌लाम् खे़प्‍सुङ्‌बा से़क्‍खाःन्‍ने खिनिॽ मे़त्‍निङ्‌लो, कर खिनिॽग याप्‍मि से़प्‍मा के़गोःत्तिॽरो॥ अब्राहामरे़ग हे़क्‍के मे़जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","खिनिॽ आबाङे पाःल्‍ले़ चोगुबा याःम्‍बक्‍हाॽए खिनिॽ के़जोगुम्‍ल के़वयिॽरो॥” खे़ङ्‌हाॽरे़ खुने़ॽ मे़मे़त्तु, “आनिगे़ खोॽसासिगे़ग मे़ःन्‍लो! निङ्‌वाॽफुमाङ्‌ङिन्‍ने आनिगे़ पानुदिङ् पाःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “से़क्‍खाए निङ्‌वाॽफुमाङ्‌ङिन् खिनिॽ पा वये़ल्‍ले़ग इङ्‌गाॽ याप्‍मि मिःम्‍जि के़मे़त्तिमे़न्, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽग निङ्‌वाॽफुमाङ्‌लाम् त्‍याङ्‌बारो, इङ्‌गाॽ आबाङे त्‍याङ्‌बा मे़ःन्‍लो कर खुने़ॽ इङ्‌गाॽ पाङ्‌घाङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","इङ्‌गाॽ पाःत्तुङ्‌बा पाःन्‍निन् थेआङ् कुसिङ् के़न्‍निःत्तुम्‍मिम्‍बाबे? थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आबाःन्‍जाक्‍किन् खे़म्‍मा के़न्‍छुक्‍तुम्‍मिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","खिनिॽ पाःङ्‌ग माफे़न्‍साम्‍लो हे़क्‍क्‍याङ् खुने़ॽ हे़क्‍केए चोःक्‍मा खिनिॽ सिराॽ थाङ्‌लो॥ खे़ङ्‌ग तोलिङ्‌सोमुआङ्धोए मे़न्‍छाम् याप्‍मि के़से़प्‍पा वये़॥ खे़ल्‍ले़ से़क्‍खाःन् चिःत्तुॽरो, थेआङ्‌भे़ल्‍ले़ से़क्‍खाःन् खुने़ॽओ होःप्‍लो॥ खुने़ॽ ताप्‍फे़ःम्‍बा कुसुत्‍नाःन् कुइसिःक्‍के इङ्‌ले़क् पाःत्‍लो, थेआङ्‌भे़ल्‍ले़ खुने़ॽग इङ्‌ले़क् के़बाःप्‍पा हे़क्‍क्‍याङ् इङ्‌ले़क्‍के पाःन्‍हाॽरे़ कुम्‍बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","इङ्‌गाॽ से़क्‍खाःन् मे़त्‍निङ्‌साङ् खिनिॽ नसाःन् के़न्‍जोगुम्‍मिन्‍लो! ");
INSERT INTO lifNT2_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","खिनिॽओ आत्तिल्‍ले़ इङ्‌गाॽ लायोबा मे़प्‍मा सुक्‍काबे? इङ्‌गाॽ से़क्‍खा पाःन् मे़त्‍निङ्‌साङ् थेआङ् खिनिॽ नसाःन् के़न्‍जोगुम्‍मिम्‍बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमनाहाॽरे़ खुने़ॽ पाःत्तुबा पाःन्‍निन् मे़घे़प्‍सुॽरो॥ खिनिॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमना मे़ःन्‍निङ्‌लो, खे़ल्‍ले़ चोगुल्‍ले़ए खिनिॽ कुबाःन्‍निन् के़ङ्‌घे़प्‍सुम्‍मिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","यहुदिहाॽरे़ ये़सुःन् नोगप् मे़बिरु, “खे़ने़ॽ सामरि सुवाङ्‌बाने़ हे़क्‍क्‍याङ् खे़ने़ॽ फे़न्‍साम्‍मिल्‍ले़ के़दरे़आङ् वाॽ फाॽआङ् आनिगे़ पाःत्तुम्‍बे़बा पाःन्‍निन् से़क्‍खाएरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽग फे़न्‍साम्‍मिल्‍ले़ मे़न्‌याङ्‌ङे वाॽआरो॥ इङ्‌गाॽ पानुदिङ् आम्‍बाःन् मिङ्‌सो इङ्‌धाःङ् पिरुङ्, कर खिनिॽग इङ्‌गाॽ इङ्‌धाःङ् याप्‍मि के़म्‍बिरिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","इङ्‌गाॽग आप्‍फेःक् आमिमिदिङ्‌ङिन् मे़गोःत्तुङ्‌ङिन्, कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ आमिमिदिङ्‌ङिन् कोःत्तुॽ, हे़क्‍क्‍याङ् खुने़ॽए खासे़न्‍लोःम्‍बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आत्तिल्‍ले़ आनिसाम्‍मिन् इःत्तु नाःत्तुॽ, खे़न् आप्‍फाल्‍ले़आङ् मे़सिःने़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","हे़क्‍केःल्‍ले़ यहुदिहाॽरे़ खुने़ॽ मे़मे़त्तु, “आल्‍ल खे़ने़ॽ से़क्‍खाए फे़न्‍साम्‍मिल्‍ले़ के़याङ्‌घे़आङ् के़वाॽ के़लॽबान् कुसिङ् निःत्तुम्‍बे़रो॥ थेआङ्‌भे़ल्‍ले़ अब्राहाम्‍मिन् नु माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽ काक् मे़स्‍ये़ मे़घे़रे़, कर खे़ने़ॽ, आत्तिल्‍ले़ इङ्‌गाॽ आनिसाम्‍मिन् इःत्तु नाःत्तुॽ, खे़न् आप्‍फाल्‍ले़आङ् मे़सिःने़न्‍लो लॽरिक् के़बाःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","खे़ने़ॽ आनिगे़ सुधे़बा ताक्‍थे़बा अब्राहाम्‍मिन्‍नुःल्‍ले़आङ् यम्‍बाने़बि? खुने़ॽग स्‍ये़ हे़क्‍क्‍याङ् काक् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽआङ् मे़स्‍ये़रो॥ खे़ने़ॽग आबाङे हाःत्‍आ के़लॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ये़सुरे़ नोगप् पिरुसि, “इङ्‌गाॽ आबाङे चम्‍सिङ्‌ङाने़ फाॽग्र खे़ङ्‌ग थेआङ् मे़ःन्‍लो, कर खिनिॽ आनिगे़ निङ्‌वाॽफुमाङ् के़मे़त्तुम्‍बा पानुदिङ् आम्‍बारे़ए इङ्‌गाॽ आमिमिदिङ् चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","खिनिॽग खुने़ॽ कुसिङ् के़न्‍निःत्तुम्‍मिन्‍छाङ् इङ्‌गाॽ खुने़ॽ कुसिङ् निःत्तुङ्‌लो॥ इङ्‌गाॽ खुने़ॽ कुसिङ् मे़निःत्तुङ्‌ङिन् लॽरिक् पाःत्तुङ्‌ने़ फाॽग्र खिनिॽ हे़क्‍केए इङ्‌गाॽ इङ्‌ले़क्‍के पोःङ्‌ङारो, कर इङ्‌गाॽ खुने़ॽ कुसिङ् निःत्तुङ्‌ङाङ् कुबाःन्‍जाक्‍किन् इःत्तुङ् नाःत्तुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","खिनिॽ सुधे़बा ताक्‍थे़बा अब्राहामरे़आङ् कन् आदाःमा ये़म्‍मिन् ओमे़प्‍मा फाॽआङ् साॽरिक् कुसिक् समे़आङ् वये़॥ हे़क्‍क्‍याङ् खे़न् ये़न्‍निन् निःसुआङ् सःत्ते़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","यहुदिहाॽरे़ खुने़ॽ मे़मे़त्तु, “खे़ने़ॽग तङ्‌बे ङागिप्‍पाङ् (५०) मे़ङ्‌गे़त्ते के़वाॽ हे़क्‍केःल्‍ले़ आक्‍खेलॽरिक् अब्राहाम्‍मिन् के़निःसुआङ् के़वाॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “हे़क्‍केःल्‍ले़ इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्‌लो, अब्राहाम्‍मिन् सावाःन्‍छिङ्‌मानुःल्‍ले़ तगिआङ्धोए इङ्‌गाॽ वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","हे़क्‍के पाःत्तुल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ ले़प्‍मा से़प्‍मा फाॽआङ् लुङ् मे़घप्‍सु, कर ये़सुःन् चिङ्‌सिङ्‌ङाङ् माङ्‌हिम् लक्‍खुम्‍मोलाम् स्‍वाःत्ताङ् लःन्‍दे़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ये़सुःन् लाङ्‌घेगे़र वये़ल्‍ले़ सावाःन्‍छिङ्‌ङाङ्‌धोएबा मिक्‍फःम्‍बा मनाधिक् निःसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","कुहुॽसाम्‍बाहाॽरे़ ये़सुःन् सेःन्‍मे़दोसु, “सिक्‍साम्‍बे, थेआङ् कन् सावाःन्‍छिङ्‌ङिल्‍ले़सा मिक्‍फःम्‍बा पोःक्‍खे़बाबे? कन् मनाःल्‍ले़ आबाङे कुलायोःल्‍ले़ चोगुल्‍ले़बि, इ कुम्‍बा कुम्‍मासिरे़ खुन्‍छिॽ लायोःल्‍ले़ चोगुल्‍ले़बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ये़सुरे़ नोगप् पिरुसि “कङ्‌ग आबाङे कुलायोःन् नु कुम्‍बा कुम्‍मासिरे़ खुन्‍छिॽ लायोःल्‍ले़ चोगुल्‍ले़आङ् मे़ःन्, कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍मिन् खुने़ॽओ निधाःप्‍ल फाॽआङ् अक्‍खे पोःक्‍खे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ले़न्‍दिक्‍सा इङ्‌गाॽ याप्‍मि के़बाङ्‌बाल्‍ले़ कुयाःम्‍बक्‍किन् आनिॽ चोःक्‍मा पोःङ्‌लो॥ से़न्‍दिक् पोःङ्‌ङाङ्‌ग हाःत्ताङ् याःम्‍बक् चोःक्‍मा मे़सुक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","इक्‍सादिङ् खाम्‍बेःक्‍मो वाॽआर थारिक् इङ्‌गाॽ इक्‍सादिङ् खाम्‍बेःक्‍मोबा ओःत्तिआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","अक्‍खे पाःत्तुर खुने़ॽ खाम्‍मो थ्‍याःत् थोःक्‍तु हे़क्‍क्‍याङ् खाम्‍मिन् कुध्‍याःत्तो सॽरुआङ् खे़न् मिक्‍फःम्‍बाल्‍ले़ कुमिक्‍को फत्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","हे़क्‍क्‍याङ् खे़न् मिक्‍फःम्‍बान् मे़त्तु, “पेगे़ॽआङ् सिलोआम वाबाक्‍को के़मिक्‍किन् वाहप्‍ते़ॽओ” (हिब्रु पाःन्‍नो सिलोआम फाॽइङ्‌ग “पाङ्‌मनाबा” पोःङ्‌लो)॥ खे़ल्‍ले़ चोगुल्‍ले़ खे़न् मनाःन् पेआङ् कुमिक्‍किन् वाहप्‍तु हे़क्‍क्‍याङ् खागे़निःबा पोःक्‍खे़आङ् कुहिम्‍मो पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","खे़ल्‍ले़ कुबाङ्‌भेॽसाबाहाॽ नु खे़ल्‍ले़ चानाःक्‍तुबा के़निःबा मनाहाॽरे़ मे़बाःत्तु, “मे़ःम्‍बे़! कन् बा खे़न् चा के़नाःक्‍पार के़युङ्‌बान् मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","कुभारे़ मे़बाःत्तु, “ओबे़॥” वेॽहाॽरे़ मे़बाःत्तु, “मे़ःन्, कङ्‌ग खे़न् हे़क्‍केरक् निधाःप्‍पे़॥” कर खे़न् मनाःल्‍ले़ “खे़न् मनाःन् बा इङ्‌गाॽएरो” मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","खे़ङ्‌हाॽरे़ सेःन्‍मे़दोसु, “आक्‍खेलॽरिक् खे़ने़ॽ खानिःमा के़सुक्‍पा के़बोःक्‍खे़बे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽ नोगप् पिरुसि, “ये़सु मे़मे़त्तुबा मनाःल्‍ले़ आमिक्‍को खाम्‍ले़क्‌वाःन् फत्‍छाङ् पिराङ् हे़क्‍क्‍याङ् ‘सिलोआम‍वाबाक्‍को पेगे़ॽआङ् के़मिक्‍किन् वाहप्‍ते़ॽ’ मे़त्ताङ्॥ खे़ल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽआङ् पेगाङ्‌ङाङ् खे़न् आमिक्‍को फत्‍छाङ् पिराङ्‌बा खाम्‍ले़क्‌वाःन् वाहप्‍तुङ्‌ङिल्‍ले़ निःमा सुक्‍तुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","खे़ङ्‌हाॽरे़ याम्‍मो सेःन्‍मे़दोसु, “खे़न् मनाःन् आत्तो वाॽ?” खुने़ॽ नोगप् पिरुसि, “इङ्‌गाॽ मे़निआन्‍लो”॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","हे़क्‍केःल्‍ले़ मनाहाॽरे़ खे़न् खानिःमा के़सुक्‍पा के़बोःङ्‌बा मिक्‍फःम्‍बान् फरिसिहाॽरो मे़देॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","आल्‍ल ये़सुरे़ सॽरुबा खाम्‍मिल्‍ले़ खे़न् मिक्‍फःम्‍बान् खानिःमा के़सुक्‍पा चोगुबा ये़न्‍निङ्‌ग नाःम्‍सिङ्‌ये़न् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","खे़ल्‍ले़ चोगुल्‍ले़ खे़न् मनाःन् आक्‍खेलॽरिक् खानिःमा के़सुक्‍पा के़बोःक्‍खे़बे फाॽआङ् फरिसिहाॽरे़ सेःन्‍मे़दोसु॥ हे़क्‍केःल्‍ले़ खे़ल्‍ले़ नोगप् पिरुसि, “ये़सु मे़प्‍मनाबा मनाःल्‍ले़ खाम्‍ले़क्‌वाःन् आमिक्‍को फत्‍छु पिराङ् हे़क्‍क्‍याङ् इङ्‌गाॽ खे़न् खाम्‍ले़क्‌वाःन् वाहप्‍तुङ्‌ङिल्‍ले़ खानिःमा के़सुक्‍पा पोःक्‍खाङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","कुभा फरिसिहाॽरे़ अक्‍खे मे़बाःत्तु, “कन् ये़सु मे़प्‍मनाबाङ्‌ग निङ्‌वाॽफुमाङ्‌लाम् त्‍ये़बा मे़ःन्‍लो, थेआङ्‌भे़ल्‍ले़ खुने़ॽ नाःम्‍सिङ्‌ये़न्‍नो याःम्‍बक् चोःक्॥” कर वेॽहाॽरे़ मे़बाःत्तु, “हे़क्‍केःल्‍ले़ लायोबा मनाःल्‍ले़ आक्‍खेलॽरिक् निङ्‌वाॽ के़माबा याःम्‍बक् चोःक्‍मा सुक्‍तुबे?” हे़क्‍केलॽरिक् खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ मे़दङे़न्‍नाङ्‌मे़से़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","हे़क्‍केःल्‍ले़ खुने़ॽ आल्‍लसाङ् याम्‍मो सेःन्‍मे़दोसु, “ये़सुरे़ खे़ने़ॽ निःमा के़सुक्‍पा के़जोगे़आङ् के़वाॽ, हे़क्‍केःल्‍ले़ खुने़ॽ कुयाःम्‍बेओ खे़ने़ॽ थे के़बाःत्तुबे?” खे़ल्‍ले़ नोगप् पिरुसि, “खुने़ॽग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","यहुदि लाम्‍लोःबाहाॽरे़ आल्‍लसाङ् खे़न् मिक्‍फःम्‍बान् सावाःन्‍छिङ्‌ङाङ्धोए मिक्‍फःम्‍बा वये़ फाॽआङ् नसाःन् चोःक्‍मा मे़न्‍छुक्‍तुन्‍लो॥ खे़ल्‍ले़ चोगुल्‍ले़ खे़ल्‍ले़ कुम्‍मा कुम्‍बासि मे़उःत्तुसिआङ् सेःन्‍मे़दोसुसि, ");
INSERT INTO lifNT2_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","“कन् मिक्‍फःम्‍बान् खिन्‍छिॽ साःबि? हे़क्‍क्‍याङ् कन् सावाःन्‍छिङ्‌ङाङ्धोए मिक्‍फःम्‍बा वये़बि? कन् आक्‍खेलॽरिक् आल्‍लो खानिःमा के़सुक्‍पा पोःक्‍खे़बे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","खे़ल्‍ले़ कुम्‍मा कुम्‍बासिरे़ नोगप् पिरे़त्‍छुसि, “कन् से़क्‍खाए आन्‍छिगे़ साःरो हे़क्‍क्‍याङ् कन् सावाःन्‍छिङ्‌ङिल्‍ले़साए मिक्‍फःम्‍बा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","कर खुने़ॽ आक्‍खेलॽरिक् खानिःमा के़सुक्‍पा पोःक्‍खे़, हाःत्‍ले़ खुने़ॽ हे़क्‍के चोगुपिरु, आन्‍छिगे़ थेआङ् मे़निःसुगे़न्‍लो॥ खे़न् थाङ्‌बे़न् के़रे़आङ् वाॽ, आबाङे पाःप्‍मा सुक्‍तुॽरो॥ खुने़ॽए सेःन्‍लाप्‍ते़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","खे़ल्‍ले़ कुम्‍मा कुम्‍बासिरे़ थेआङ् हे़क्‍के पाःत्ते़त्‍छुभे़ल्‍ले़ यहुदि लाम्‍लोःबाहाॽनु खुन्‍छिॽ किःसे़त्‍छिआङ् वये़त्‍छिरो॥ थेआङ्‌भे़ल्‍ले़ यहुदि लाम्‍लोःबाहाॽरे़ आत्तिल्‍ले़ ये़सुःन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍त फाॽआङ् नसाःन् चोगुॽ खे़न् मनाःन् यहुदि चुम्‍लुङ्‌हिम्‍मोलाम् लःप्‍मादेःमा पोःङ् फाॽआङ् मुरा मे़दङ्‌घुआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","खे़ल्‍ले़ चोगुल्‍ले़ कुम्‍मा कुम्‍बासिरे़ खे़न् थाङ्‌बे़न् के़रे़आङ् वाॽ, खुने़ॽए सेःन्‍लाप्‍ते़म्‍मे़ॽओ फाॽआङ् पाःत्ते़त्‍छुबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खे़न् खानिःमा के़सुक्‍पा के़बोःङ्‌बा मिक्‍फःम्‍बान् याम्‍मो मे़उःत्तुआङ् मे़मे़त्तु, “खे़ने़ॽ से़क्‍खा पाःन् पाःत्ता फाॽआङ् निङ्‌वाॽफुमाङ्‌ङो माङ्‌हे़क्‍सिङ्‌ङे़ॽओ॥ खे़न् ये़सु मे़प्‍मनाबा मनाःङ्‌ग से़क्‍खासाङ् लायोबाएरो फाॽआङ् आनिगे़ निःसुम्‍बे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","खे़ल्‍ले़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खुने़ॽग लायोबाबि मे़ःम्‍बि इङ्‌गाॽ थेआङ् मे़निआन्‍लो, कर इङ्‌गाॽ लत्‍थिक् पाःन् निःसुङ्॥ इङ्‌गाॽ मिक्‍फःम्‍बा वयाङ्, कर आल्‍लो खानिःमा सुक्‍तुङ्‌लो!” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ खे़न् याम्‍मो सेःन्‍मे़दोसु, “खे़ल्‍ले़ खे़ने़ॽ थे के़जोगे़आङ् खानिःमा के़सुक्‍पा के़बोःक्‍खे़बे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","खे़ल्‍ले़ नोगप् पिरुसि, “इङ्‌गाॽ आन्‍दे़ःन्‍छा मे़त्‍निङ्‌बा कर खिनिॽ के़ङ्‌घे़प्‍सुम्‍मिन्॥ थेआङ् याम्‍मो खे़म्‍मा के़गोःत्तुम्‍बाबे? खिनिॽआङ् खुने़ॽ कुहुॽसाम्‍बा पोःङ्‌मा निङ्‌वाॽ के़जोगुम्‍माङ् के़वयिॽबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ कुना मे़धाःसुर मे़मे़त्तु, “खे़ने़ॽए खे़ल्‍ले़ कुहुॽसाम्‍बाने़रो, कर आनिगे़ग मोसारे़ कुहुॽसाम्‍बासिगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","निङ्‌वाॽफुमाङ्‌ङिन् मोसाःन्‍नु पारे़बा पाःन्‍नो आनिगे़ निङ्‌वाॽ निःन्‍धोओ वयिगे़रो, कर कन् मनाःङ्‌ग आत्तोलाम् त्‍ये़बाबे फाॽआङ् आनिगे़ थेआङ् मे़निःसुम्‍बे़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","खे़न् मनाःल्‍ले़ नोगप् पिरुसि, “कङ्‌ग साॽरिक्‍के निङ्‌वाॽ के़माबा पाःन् पोःक्‍खे़रो! खुने़ॽ आत्तोलाम् त्‍ये़बा फाॽआङ् खिनिॽ के़न्‍निःसुम्‍मिन्‍लो, कर कन् मनाःल्‍ले़ इङ्‌गाॽ खानिःमा के़सुक्‍पा चोगाङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ लायोबाहाॽरे़ खुनिॽ पाःन्‍निन् मे़घे़प्‍सुन् के़लॽबान् आनिॽ आनिःसुम्॥ खुने़ॽ सेसे सेवा के़जोःक्‍पाहाॽ नु कुनिङ्‌वाॽ हे़क्‍के के़जोःक्‍पाहाॽरे़ खुनिॽ पाःन्‍लक् खे़प्‍सुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","नावागे़न् चइःत् ने़स्‍से़आङ्धो आल्‍लो थारिक् आत्तिन् मनाःल्‍ले़आङ् मिक्‍फःम्‍बा सागे़वाःन्‍छिङ्‌बान् निःमा के़सुक्‍पा चोगुबाङ्‌ग आत्तिल्‍ले़आङ् मे़ङ्‌घे़म्‍मे वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","कन् मनाःन् निङ्‌वाॽफुमाङ्‌लाम् त्‍ये़बा मे़ःन्‍निल्‍ले़ग अक्‍तङ्‌बा याःम्‍बक् थेआङ् चोःक्‍मा मे़सुक्‍तुम्‍बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","खे़ङ्‌हाॽरे़ खे़न् मे़मे़त्तु, “खे़ने़ॽग सागे़वाःन्‍छिङ्‌ङाङ्धो लायोओए के़वाॽरो! खे़ने़ॽ आनिगे़ हुॽमा याप्‍मि के़गोःप्‍पि?” हे़क्‍के मे़मे़त्तुर खे़न् यहुदि चुम्‍लुङ्‌हिम्‍मोनु लाःक्‍कात् मे़जन्‍दु मे़लःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ये़सुरे़ खे़न् मिक्‍फःम्‍बान् यहुदि चुम्‍लुङ्‌हिम्‍मोलाम् लाःक्‍कात् मे़जन्‍दु मे़लःत्तु के़लॽबा खे़प्‍सु॥ हे़क्‍क्‍याङ् खे़न्‍निन् तुमुआङ् सेःन्‍दोसु, “खे़ने़ॽ मे़न्‍छाम्‍साःन्‌ नसाःन् के़जोगुॽबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","हे़क्‍केःल्‍ले़ खे़न् मनाःल्‍ले़ नोगप् पिरु, “आदाङ्‌बे, खुने़ॽ हाःत्‍निबे? ओसेःन्‍धाक्‍ताङ्‌ङे़ॽना, हे़क्‍केलॽरिक् इङ्‌गाॽआङ् नसाःन् चोःक्‍मा सुक्‍तुङ्‌ल॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ये़सुरे़ खे़न् नोगप् पिरु, “खे़ने़ॽ के़निःसुआङ्‌ङे के़वाॽरो॥ खे़ने़ॽनु के़बाःप्‍पार के़बप्‍पे़न्‍ने खुने़ॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","खे़न् मनाःल्‍ले़ पाःत्तु, “आदाङ्‌बे, खे़ने़ॽ नसाःन् चोःक्‍ने़ॽरो॥” हे़क्‍क्‍याङ् खे़ल्‍ले़ ये़सुःन् थुङ्‌बोहजॽआङ् सेवा मे़त्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ये़सुरे़ पाःत्तु, “मिक्‍फःम्‍बाहाॽ निःमा के़सुक्‍पा मे़बोःङ्‌ल हे़क्‍क्‍याङ् आनिगे़ निःसुम्‍बे़ के़लॽबा मनाहाॽ मिक्‍फःम्‍बा मे़बोःङ्‌ल फाॽआङ् इक्‍सा खाम्‍बेःक्‍मो खासे़न् चोःक्‍से़ इङ्‌गाॽ त्‍याङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","हे़क्‍केःल्‍ले़ खुने़ॽनु के़वाॽबा कुभा फरिसिहाॽरे़ खे़न् मे़घे़प्‍सुआङ् खुने़ॽ मे़मे़त्तु, “खे़ने़ॽ आनिगे़आङ् मिक्‍फःम्‍बा चोगिगे़ फाॽआङ् याप्‍मि के़मे़प्‍पाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ मिक्‍फःम्‍बा के़जोगिल्‍ले़ग खिनिॽनु लायोःन् होःप्‍ते़बारो, कर आनिगे़ निःसुम्‍बे़ लॽरिक् के़बाःत्तुम्‍बाल्‍ले़ चोगुल्‍ले़ खिनिॽ लायोओए के़वयिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ये़सुरे़ पाःत्तु, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आत्तिन् मनाःन् लाम्‍धेःप्‍पोलाम् मे़ल्‍लुक्‍खरओ मे़लाःत्‍ने़न् कर वेॽ ले़प्‍माङ्‌नु लाःत् खे़ङ्‌ग खुःन्‍द्रिक्‍पा नु फाःन्‍दारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","थेआङ्‌भे़ल्‍ले़ मे़ल्‍लुक्‍कम्‍बाङ्‌ग लाम्‍धेःप्‍पोलाम् लाःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","लाम्‍धेःप् के़गोःबाल्‍ले़ खुने़ॽ कुलागि लाम्‍धेःप्‍पे़न्‌हन्‍दु पिरु हे़क्‍क्‍याङ् मे़ल्‍लुक्‍हाॽरे़आङ् खुने़ॽ कुइक्‍लाःन् कुसिङ् मे़निःत्तुॽरो॥ हे़क्‍क्‍याङ् खे़ल्‍ले़ कुमे़ल्‍लुक्‍हाॽ खुनिॽ मिङ्‌ङोनु उःत्तुसिआङ् लाःक्‍कात् लाम्‍लोसुसिॽआङ् तेॽरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","हे़क्‍केलॽरिक् खुने़ॽ कुमे़ल्‍लुक्‍हाॽ लाःक्‍कात् लःत्तुसिॽआङ् तगि तगि लाङ्‌घेःक्‍ल लाम्‍लोसुसिॽरो॥ हे़क्‍क्‍याङ् खे़न् मे़ल्‍लुक्‍हाॽरे़ खुने़ॽ मे़दिम्‍दुॽ थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ कुइक्‍लाःन् कुसिङ् मे़निःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","कर कुसिङ् मे़न्‍निःत्तुम्‍बाङ्‌ग खे़ङ्‌हाॽरे़ मे़न्‍दिम्‍दुन्, कर मे़लोःक् मे़बेःक्‍लो, थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ कुइक्‍लाःन् खे़ङ्‌हाॽरे़ कुसिङ् मे़न्‍निःत्तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","अक्‍खेलॽरिक् ये़सुरे़ कन् पाःन्‍निन् खे़दाॽओ मे़त्तुसिआङ् वये़, कर ये़सुरे़ थे पाःप्‍मा निङ्‌वाॽ चोगुबा खे़न् पाःन्‍निल्‍ले़ कुबेःन् खे़ङ्‌हाॽरे़ कुसिङ् मे़न्‍निःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","खे़ल्‍ले़ चोगुल्‍ले़ याम्‍मो ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्‌लो, इङ्‌गाॽए मे़ल्‍लुक्‍हाॽरे़ लागि लाम्‍धेःप्‍पाआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","इङ्‌गाॽनुःल्‍ले़ तगि के़दाःबाहाॽ के़रे़क् खुःन्‍द्रिक्‍पा नु फाःन्‍दासिरो, कर मे़ल्‍लुक्‍हाॽरे़ खे़ङ्‌हाॽरे़ खुनिॽ पाःन् मे़ङ्‌घे़प्‍सुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","इङ्‌गाॽए लाम्‍धेःप्‍पाआरो, इङ्‌गाॽलाम् सिगाङ् के़लाःप्‍पाहाॽ ताङ्‌मे़से़ःप्‍लो॥ खे़न् सिगाङ् लाःप्‍मा नु लाःक्‍कात् पेःक्‍मा सुक्‍लो हे़क्‍क्‍याङ् खे़ल्‍ले़ चाराम्‍दे़न् खोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","खुःन्‍द्रिक्‍पाङ्‌ग खुःत्‍छे़, से़त्‍छे़ नु मे़ङ्‌से़रक् ताःरो, कर इङ्‌गाॽग मनाहाॽरे़ से़क्‍खाबा हिङ्‌मन्‍निन् मे़घोःसुर, हे़क्‍क्‍याङ् खे़न्‍नाङ् आत्तात्तान्‍ने यरिक् मे़घोःसुर फाॽआङ् त्‍याङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","इङ्‌गाॽ के़नुॽबा मे़ल्‍लुक्‍कम्‍बाआरो॥ के़नुॽबा मे़ल्‍लुक्‍कम्‍बाङ्‌ग कुमे़ल्‍लुक्‍हाॽरे़लागि सिःमाए पोःङ्‌साङ् मे़गिने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","कर याङ्‌ङो याःलिक्‌साङ्‌मनाबा मनाःङ्‌ग से़क्‍खाबा मे़ल्‍लुक्‍कम्‍बा नु मे़ल्‍लुक्‍दाङ्‌बा मे़ःन्‍लो॥ खे़ल्‍ले़ पराबान् फे़न्‍ल पप्‍पा निःसुल्‍ले़ मे़ल्‍लुक्‍हाॽ ले़रुधसिआङ् खे़त्‍छिङ् पेःक्‍लो हे़क्‍क्‍याङ् पराबान् ताआङ् मे़ल्‍लुक्‍हाॽ फत्तुसिॽआङ् से़ःसुदेःसुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","खे़न् मनाःन् याङ्‌ङो याःलिक्‌साङ्‌मनाबाआङ्‌लक् वाॽबाल्‍ले़ चोगुल्‍ले़ मे़ल्‍लुक्‍हाॽ नुःरिक्‍काङ् ओमे़मे़त्तुन्‍छिन् कर ले़रुधसिआङ् खे़त्‍छिङ् पेःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","इङ्‌गाॽ के़नुॽबा मे़ल्‍लुक्‍कम्‍बाआरो॥ इङ्‌गाॽ आमे़ल्‍लुक्‍हाॽ कुसिङ् निःत्तुङ्‌सिङ् हे़क्‍क्‍याङ् पानुदिङ् आम्‍बारे़ कुसिङ् निःत्ताबा हे़क्‍केए आमे़ल्‍लुक्‍हाॽरे़ इङ्‌गाॽआङ् कुसिङ् मे़निःत्तारो–इङ्‌गाॽआङ् खुने़ॽ कुसिङ् निःत्तुङ्, हे़क्‍क्‍याङ् आमे़ल्‍लुक्‍हाॽरे़ लागि सिःमाआङ् यारिप् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","इङ्‌गाॽ वेॽ मे़ल्‍लुक्‍हाॽआङ् कत्तुङ्‌सिङ्॥ खे़ङ्‌हाॽग कन् लुप्‍पोबा मे़ःन्‍छिरो कर खे़ङ्‌हाॽआङ् इङ्‌गाॽ लत्‍छा लुप्‍पो ताःप्‍मासि पोःङ्‌लो॥ खे़ङ्‌हाॽरे़ इङ्‌गाॽ आइक्‍लाःन् मे़घे़प्‍सुॽआङ् खे़ङ्‌हाॽ थिक् लुप् मे़बोःङ् हे़क्‍क्‍याङ् मे़ल्‍लुक्‍कम्‍बान्‍नाङ्‌लत्‍छारक्‌पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","पानुदिङ् पाःल्‍ले़ इङ्‌गाॽ लुङ्‌माॽ तुक्‍कारो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ आहिङ्‌मन्‍निन् याम्‍मो याङ्‌ना खोःमा फाॽआङ् कन् आहिङ्‌मन्‍निन् खुने़ॽ पिरुङ्‌देःसुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","आत्तिल्‍ले़आङ् ने़त्तिगे़न् आहिङ्‌मन्‍निन् इङ्‌गाॽओलाम् तेॽमा मे़सुक्‍तुन्‍लो, कर कङ्‌ग इङ्‌गाॽ आबाङे आसिराॽ थाङ्‌धाङ् पिमा सुक्‍तुङ्‌लो॥ ने़त्तिगे़न् आहिङ्‌मन्‍निन् आबाङे पिमा नु याम्‍मो याङ्‌ना खोःमा युक् कत्तुङ्‌लो॥ इङ्‌गाॽ पानुदिङ् आम्‍बारे़ अक्‍खे चोःक्‍मा इङ्‌जाःङ् पिराङ्‌ङाङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ये़सुरे़ पाःत्तुबा कन् पाःन्‍निल्‍ले़ चोगुल्‍ले़ यहुदिहाॽ याम्‍मोआङ् खुनिॽ निङ्‌वाॽ मे़दङे़न्‍नाङ्‌मे़से़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","यरिक्‍ले़ अक्‍खे मे़बाःत्तु, “कङ्‌ग से़क्‍खासाङ् फे़न्‍साम्‍मिल्‍ले़ युक्‍तुआङ् नाक्‍खे़ पेआङ् वाॽरो! अक्‍तङ्‌बा मनाःल्‍ले़ कुबाःन्‍निन् थेआङ् खे़म्‍माबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","कर वेॽहाॽरे़ मे़बाःत्तु, “फे़न्‍साम्‍मिल्‍ले़ युक्‍तुबा मनाःन् अक्‍खेलॽरिक् मे़बाःत्‍ने़न्‍लो॥ फे़न्‍साम्‍मिल्‍ले़ याङ्‌घुबाल्‍ले़ मिक्‍फःम्‍बाल्‍ले़ कुमिक्‍किन् हम्‍मा सुक्‍तुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","हे़क्‍क्‍याङ् यरुसले़म्‍मो माङ्‌हिम्‌तोःम्‍मा तङ्‌नाम्‌रे़न्‌ ये़म् वये़, कङ्‌ग चुङ्‌वाःम्‍मा लाओ वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","हे़क्‍क्‍याङ् खे़प्‍मो ये़सुःन् माङ्‌हिम् लक्‍खुम् खिरि सोलोमनरे़ कुआःम्‍भो मे़प्‍मनाबा ते़न्‍नो लाङ्‌घेःक्‍कि वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","खुने़ॽ कुघिरि यहुदिहाॽ मे़जुप्‍से़आङ् मे़मे़त्तु, “खे़ने़ॽ आप्‍फाल्‍ले़ थारिक् पिर्बेःम्‍बो याप्‍मि के़गप्‍पाबे? खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़सेःन्‍दे़बा ख्रिस्‍तने़ फाॽग्र कुदोःप्‍माङ् पाःत्ते़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ये़सुरे़ नोगप् पिरुसि, “इङ्‌गाॽग तगिसा खिनिॽ मे़त्‍निङ्‌ङाङ् वाॽआरो॥ कर खिनिॽग नसाःन् आगे़न्‍जोगिन्‍लो॥ पानुदिङ् आम्‍बारे़ कुयुक्‍कोलाम् चोगुङ्‌बा निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽरे़ए इङ्‌गाॽ हाःत्‍आ फाॽआङ् ओसेःन्‍गे़धाक्‍तिॽ, ");
INSERT INTO lifNT2_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","कर खिनिॽ नसाःन् के़न्‍जोगुम्‍मिन्‍लो थेआङ्‌भे़ल्‍ले़ खिनिॽग आमे़ल्‍लुक् मे़ःन्‍निङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","इङ्‌गाॽ आमे़ल्‍लुक्‍हाॽरे़ग आइक्‍लाःन् कुसिङ् मे़निःत्तुॽरो, हे़क्‍क्‍याङ् इङ्‌गाॽआङ् खे़ङ्‌हाॽ कुसिङ् निःत्तुङ्‌सिङ्‌ङाङ् खे़ङ्‌हाॽरे़ग इङ्‌गाॽ मे़दिम्‍मारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","खे़ङ्‌हाॽ इङ्‌गाॽ मे़न्‍नुप्‍मनाबा हिङ्‌मन् पिरुङ्‌सिङ् हे़क्‍क्‍याङ् खे़ङ्‌हाॽ आप्‍फाल्‍ले़आङ् मे़म्‍मे़क्‍ने़न्॥ हे़क्‍क्‍याङ् आत्तिल्‍ले़आङ् खे़ङ्‌हाॽ आहुक्‍कोलाम् नाप्‍मा तेॽमा मे़सुक्‍तुन्‍लो, ");
INSERT INTO lifNT2_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","थेआङ्‌भे़ल्‍ले़ पानुदिङ् आम्‍बारे़ खे़ङ्‌हाॽ इङ्‌गाॽ पिराङ्‌ङाङ् वाॽ हे़क्‍क्‍याङ् खुने़ॽ काक्‍नुःल्‍ले़ पयम् यम्‍बा चोःक्‍लो॥ खे़ङ्‌हाॽ आम्‍बारे़ कुहुक्‍कोलाम् आत्तिल्‍ले़आङ् नाप्‍मा तेॽमा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","पानुदिङ् आम्‍बा नु इङ्‌गाॽ लत्‍छासिगे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","हे़क्‍केःल्‍ले़ याम्‍मो यहुदिहाॽरे़ ये़सुःन् ले़प्‍मा से़प्‍मा फाॽआङ् लुङ्‌ङिन् मे़घप्‍सु, ");
INSERT INTO lifNT2_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","कर ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽग पानुदिङ् आम्‍बालाम् यरिक् नुःबा याःम्‍बक्‍हाॽ चोगुङ् पिनिङ्, हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽओ आत्तिन् याःम्‍बक्‍किल्‍ले़ चोगुल्‍ले़ लुङ्‌ङिल्‍ले़ ले़प्‍मा आगे़गोःत्तिबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहुदिहाॽरे़ नोगप् मे़बिरु, “खे़ने़ॽ के़जोगुबा नुःबा याःम्‍बक्‍किल्‍ले़ चोगुल्‍ले़ग मे़ःन्‍लो, कर खे़ने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पाःन् के़बारे़बाल्‍ले़ चोगुल्‍ले़ लुङ्‌ङिल्‍ले़ ले़प्‍मा कोःत्तासिगे़बारो॥ थेआङ्‌भे़ल्‍ले़ खे़ने़ॽग मे़न्‍छाम् याप्‍मिने़रक्‌, कर निङ्‌वाॽफुमाङ्‌आ लॽरिक् के़बाःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “खिनिॽ आबाङे साम्‌योथिम् साप्‍लाओ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ मे़न्‍छाम् याप्‍मिहाॽ खिनिॽ माङ्‌निङ्‌लो लॽरिक् मे़त्तुसिबा साप्‍ते़आङ् पत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","हे़क्‍क्‍याङ् साम्‌योसाप्‍लाःन् ले़ङ्‌मा सुक्‍मे़दे़त्‍ने़न्‍बान् के़निःसुम्‍लो॥ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ आत्तिन्‍हाॽ पाःन्‍जाक् पिरुसि खे़ङ्‌हाॽ खिनिॽ माङ्‌निङ्‌लो लॽरिक् मे़त्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","हे़क्‍केःल्‍ले़ पानुदिङ् पाःल्‍ले़ सेसे चोगुआङ् इक्‍सादिङ् खाम्‍बेःक्‍मो पाङ्‌घुबा मनाःल्‍ले़ इङ्‌गाॽ निङ्‌वाॽफुसाःआ लॽरिक् पाःत्तुल्‍ले़ आक्‍खेलॽरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पाःन् के़बाःत्तु फाॽआङ् याप्‍मि के़धिक्‍तिबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","इङ्‌गाॽ पानुदिङ् आम्‍बारे़ चोःक् पाङ्‌ङाबा याःम्‍बक्‍किन् मे़जोःक्‍कान्‍ने़ फाॽग्र याप्‍मि नसाःन् आन्‍जोगे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","कर इङ्‌गाॽ खे़न् याःम्‍बक्‍किन् चोगुङ्‌ने़ फाॽग्र इङ्‌गाॽओ नसाःन् के़न्‍जोगुम्‍मिन्‍छाङ् कन् चोगुङ्‌बा याःम्‍बक्‍हाॽओग नसाःन् चोगे़म्‍मे़ॽओ॥ हे़क्‍केलॽरिक् पानुदिङ् पाःन् इङ्‌गाॽओ वाॽ हे़क्‍क्‍याङ् इङ्‌गाॽ खुने़ॽओ वाॽआ के़लॽबा पाःन्‍निन् कुसिङ् के़निःत्तुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","खे़ङ्‌हाॽरे़ खुने़ॽ याम्‍मो ते़म्‍मा मे़गोःत्तु कर खुने़ॽ फिःन्‍छिङ् पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","हे़क्‍क्‍याङ् ये़सुःन् यर्दन यङ्‌घङ्‌ङिल्‍ले़ नाधाःम्‍बि तगि युहुन्‍नारे़ बप्‍तिस्‍मा पिरुसिबा ते़न्‍नो पे॥ खुने़ॽ खे़प्‍मोए याःक्‍ते़ल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","यरिक् मनाहाॽ खुने़ॽओ मे़द्‌ये़रो॥ खे़ङ्‌हाॽरे़ मे़बाःत्तु, “युहुन्‍नारे़ निङ्‌वाॽ के़माबा याःम्‍बक् मे़जोगुन्‍छाङ् कन् मनाःल्‍ले़ कुयाःम्‍बेओ पाःत्तुबा के़रे़क् पाःन्‍हाॽ से़क्‍खाएरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","हे़क्‍क्‍याङ् खे़प्‍मो यरिक् मनाहाॽरे़ ये़सुःन् नसाःन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","आल्‍ल बे़थानि पाङ्‌भेॽओ लाजरस मे़प्‍मनाबा लत्‍छा मनाःन् साॽरिक् तुगे़आङ् ने़स्‍से़॥ खे़ल्‍ले़ कुन्‍जेलिमाहाॽ मरियम नु मार्था मे़प्‍मनामा वये़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","बा कन् मरियम्‍मिल्‍ले़ ताःन्‍दि दाङ्‌बाल्‍ले़ कुलाङ्‌ङो फुङ्‌नाम्‌निःङ्‌गेःन् हुक्‍खुआङ् कुधे़गेःक्‍किल्‍ले़ तुगुआङ् वये़रो॥ खे़ल्‍ले़ कुन्‍साॽ लाजरसे़न् तुगे़आङ् ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","खे़न् कुन्‍जेलिमाहाॽरे़ ये़सुःन् अक्‍तङ्‌बा इङ्‌घङ् हाक्‍ते़त्‍छु, “दाङ्‌बे, लुङ्‌माॽ के़दुक्‍तुबा के़न्‍जुम्‍मिन् साॽरिक् तुक्‍काङ् ने़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ये़सुरे़ कन् इङ्‌घङ्‌ङिन् खे़प्‍सुआङ् अक्‍खे पाःत्तु, “खुने़ॽग कन् तुक्‍माल्‍ले़ मे़सिःने़न्‍लो॥ कङ्‌ग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमिमिदिङ्‌ले़ लागि पोःक्‍खे़बारो॥ कन्‍लाम्‍बा निङ्‌वाॽफुसाःल्‍ले़ कुमिङ्‌सो कुधाःङ्‌सो पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ये़सुरे़ मार्था, खे़ल्‍ले़ कुन्‍साॽ मरियम नु लाजरस लुङ्‌माॽ तुक्‍तुसिआङ् वये़साङ् ");
INSERT INTO lifNT2_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","लाजरसे़न् तुक्‍काङ् ने़ के़लॽबा इङ्‌घङ्‌ङिन् खे़प्‍सुआङ्‌साङ्‌खुने़ॽ निये़न् थारिक् वये़बा ते़न्‍नोए याःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","हे़क्‍क्‍याङ् खुने़ॽ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “आल्‍ल आनिॽ याम्‍मो यहुदिया थुम्‍मो नुःक्‍खि पिगिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","कर खे़ङ्‌हाॽरे़ खुने़ॽ मे़मे़त्तु, “सिक्‍साम्‍बे, खे़त्‍थोग यहुदिहाॽरे़ कुभा ये़न् तगि लुङ्‌ङिल्‍ले़ ले़प्‍मा से़प्‍मा के़म्‍गोःत्ते़आङ्‌वये़, हे़क्‍केसाङ् खे़ने़ॽ याम्‍मो खे़त्‍थोए पेःक्‍मा निङ्‌वाॽ के़जोगुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ये़सुरे़ नोगप् पिरुसि, “थिक् ले़न्‍दिक्‍को कुमुक् थिक्‌-ने़त् (१२) मे़बोःङ्‌ने़न्‍बि? आत्तिन् मनाःन् ले़न्‍दिक् लाङ्‌घेःक् खे़ल्‍ले़ कुलाङ्‌ङिन् मे़दोःक्‍ने़न्‍लो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌ग इक्‍सादिङ् खाम्‍बेःक्‍मोबा खाओःप्‍माओ मिक्‌निःरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","कर आत्तिन् मनाःन् से़न्‍दिक् लाङ्‌घेःक् खे़ल्‍ले़ कुलाङ् तोःक्‍लो, थेआङ्‌भे़ल्‍ले़ खादाम्‍मो खे़ल्‍ले़ थोॽसिङ्‌मा ओःत्तिःन्‌मे़गत्तुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","अक्‍खे पाःत्तु सुरुआङ् ये़सुरे़ याम्‍मो खे़ङ्‌हाॽ मे़त्तुसि, “आनिॽ चुम् लाजरसे़न् मुरुक् खुरुक् इप्‍से़आङ् ने़रो, कर खुने़ॽ कुभोःङ्‌से़ पेःक्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","हे़क्‍केःल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ खुने़ॽ मे़मे़त्तु, “आदाङ्‌बे, खुने़ॽ इप्‍से़आङ्‌लक् ने़ने़ फाॽग्र पोःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ये़सुरे़ खे़ङ्‌हाॽ लाजरसरे़ कुसिःमे़न्‍निल्‍ले़ कुयाःम्‍बेओ मे़त्तुसिआङ् वये़, कर कुहुॽसाम्‍बाहाॽरे़ लाजरसे़न् इप्‍से़आङ्‌लक् ने़ःॽ लॽरिक् निङ्‌वाॽ मे़इःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","हे़क्‍केःल्‍ले़ ये़सुरे़ खे़ङ्‌हाॽ कुदोःप्‍माए मे़त्तुसि, “लाजरसे़ङ्‌ग स्‍ये़रो, ");
INSERT INTO lifNT2_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","कर आल्‍लसाङ् खिनिॽ यरिक् याप्‍मि नसाःन् आगे़जोगिर फाॽआङ् इङ्‌गाॽ खे़त्‍ना होःप्‍ताङ्‌बान्‍ने खिनिॽ लागि नुःबा पोःक्‍खे़रो॥ आल्‍ल खुने़ॽ कुसाॽसे़ पेगिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","हे़क्‍क्‍याङ् दिदिमस मे़प्‍मनाबा थोमाःल्‍ले़ वेॽ कुन्‍जुम् हुॽसाम्‍बाहाॽ मे़त्तुसि, “आनिॽआङ् दाङ्‌बान्‍नुए पेगिआङ् खुने़ॽनुए स्‍ये़ॽइरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","खे़ङ्‌हाॽ बे़थानिओ मे़गे़रे़ल्‍ले़ लाजरसे़न् खाम्‍मो मे़जिक्‍खुबाङ्‌ग लिसि ये़न् के़रे़ के़लॽबान् ये़सुरे़ निङ्‌वाॽ खोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बे़थानिग यरुसले़म्‍लाम् किलोमितर सुम्‍सि यारिक् माःक्‍खे़, ");
INSERT INTO lifNT2_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","हे़क्‍क्‍याङ् यरिक् यहुदिहाॽ मार्था नु मरियमरे़ खुन्‍छिॽ सङ्‌वाबान् स्‍ये़बाओ खुन्‍छिॽ आःन्‍छिङ्‌मा पिसे़ खे़प्‍मो मे़द्‌ये़आङ् मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","मार्थारे़ ये़सुःन् फे़न्‍ल पत् के़लॽबा खे़प्‍सुआङ् लाम्‍देःङ् थारिक् कुदुम्‍से़ पेरो, कर मरियम्‍मिन् हिम्‍मोए याःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","मार्थारे़ ये़सुःन् मे़त्तु, “दाङ्‌बे, खे़ने़ॽ कप्‍मो के़वये़ल्‍ले़ग आन्‍साॽ मे़स्‍ये़ने़म्‍बामे़न्! ");
INSERT INTO lifNT2_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","कर आल्‍लो थे के़नाःक्‍तुसाङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़बिॽ के़लॽबान् इङ्‌गाॽ कुसिङ् निःत्तुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ये़सुरे़ मार्थाःन् मे़त्तु, “खे़ने़ॽ के़न्‍साॽग याम्‍मो सिःमे़न्‍लाम् हिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","हे़क्‍केःल्‍ले़ मार्थारे़ नोगप् पिरु, “ओरो आदाङ्‌बे, कुनुप्‍मा ये़न्‍नो सिःमे़न्‍लाम् हिङ्‌मन्‍नो खुने़ॽ याम्‍मो हिङ्‌फाॽआङ् कुसिङ् निःत्तुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ये़सुरे़ खे़न् मे़त्तु, “इङ्‌गाॽग के़सिःबाहाॽ याम्‍मो हिङ्‌मन् के़बिबा नु मे़न्‍नुप्‍मनाबा हिङ्‌मन् के़बिबाआरो॥ आत्तिल्‍ले़ इङ्‌गाॽ नसाःन् चोःक्‍का खे़ङ्‌ग सिःसाङ् याम्‍मो हिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","हे़क्‍क्‍याङ् इङ्‌गाॽओ नसाःन् के़जोःक्‍पाआङ् के़हिङ्‌बाङ्‌ग आप्‍फाल्‍ले़आङ् मे़सिःने़न्‍लो॥ इङ्‌गाॽ पाःत्तुङ्‌बा कन् आबाःन्‍निन् नसाःन् के़जोगुबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","मार्थारे़ नोगप् पिरु “ओरो आदाङ्‌बे, खे़ने़ॽग इक्‍सादिङ् खाम्‍बेःक्‍मो युःमा के़बोःङ्‌बा निङ्‌वाॽफुसाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ के़सेःन्‍दे़बा ख्रिस्‍तने़ फाॽआङ् इङ्‌गाॽ नसाःन् चोगुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","हे़क्‍क्‍याङ् खुने़ॽ अक्‍खे पाःत्तु सुरुआङ् याम्‍मो हिम्‍मो नुःक्‍खे़ पेआङ् मरियम्‍मिन् मेरिङ् के़धक्‍पाहाॽलाम् थिक्‍ले़प्‍माङ् स्‍वाःत् उःत्तु तेॽरुआङ् मे़त्तु, “सिक्‍साम्‍बाङ्‌ग कप्‍मो वाॽ हे़क्‍क्‍याङ् खुने़ॽ खे़ने़ॽ के़उःत्ते़आङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","मरियमरे़ कन् पाःन्‍निन् खे़प्‍सुनुमे़ःन्‍ने मुत्‍थ्रिक् पोगे़आङ् ये़सुरे़ कुदुम्‍से़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","खे़न् ये़म् थारिक् ये़सुःङ्‌ग पाङ्‌भेॽओ मे़ङ्‌गे़त्ते वये़, कर खुने़ॽग मार्थारे़ तुमुबा ते़न्‍नोए वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","आःन्‍छिङ्‌मा पिसे़ हिम्‍मो के़दाःबा यहुदिहाॽरे़ मरियम्‍मिन् हे़क्‍केलॽरिक् मुत्‍थ्रिक् पोगे़आङ् पेबा मे़निःसुआङ् से़क्‍खासाङ् खुने़ॽ कुन्‍साॽरे़ कुइप्‍पुङ्‌ङो मेरिङ् थक्‍से़ पेबाबिला फाॽआङ् निङ्‌वाॽ मे़इःत्तुआङ् खे़ङ्‌हाॽरे़ खुने़ॽ मे़दिम्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","मरियम्‍मिन् ये़सुःन् वये़बादे़न्‍नो के़रे़आङ् थुङ्‌बोहजॽआङ् मे़त्तु, “आदाङ्‌बे, खे़ने़ॽ कप्‍मो के़वये़ल्‍ले़ग आन्‍साॽ मे़स्‍ये़ने़म्‍बामे़न्॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ये़सुरे़ मरियम्‍मिन् हे़क्‍क्‍याङ् खुने़ॽनु के़वाॽबा यहुदिहाॽआङ् मेरिङ् मे़धक्‍ते़बा निःसुसिल्‍ले़ कुसाॽइ यगे़आङ् कुयोःम् पुॽरे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ सेःन्‍दोसुसि, “खुने़ॽ आत्तो के़ने़स्‍सुम्‍माङ् ने़बे?” खे़ङ्‌हाॽरे़ मे़मे़त्तु, “दाङ्‌बे, फे़रे़ॽआङ् ओमे़त्ते़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ये़सुःन् हाबे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","हे़क्‍केःल्‍ले़ यहुदिहाॽरे़ मे़बाःत्तु, “ओमे़त्ते़म्‍मे़ॽ खुने़ॽग लाजरसे़न् आक्‍खे़न् साॽरिक् लुङ्‌माॽ तुक्‍तुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","कर कुभारे़ मे़बाःत्तु, “मे़ःम्‍बे़, मिक्‍फःम्‍बान् निःमा के़सुक्‍पा के़जोःक्‍पाङ्‌ग बा खुने़ॽ मे़ःम्‍बि? थेआङ् कन् लाजरसे़न् सिःमालाम्‌हिङ्‌मा मे़सुक्‍तुम्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","याम्‍मोआङ् ये़सुःन् साॽरिक् कुयोःम् पुॽरे़आङ् इप्‍पुङ्‌ङिल्‍ले़ कुबेसाङ् पे॥ खे़न् इप्‍पुङ्‌ङिल्‍ले़ कुमुराओ यम्‍बा लुङ्‌ङिन् मे़ये़प्‍सुबा फुक्‍कु वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “कन् लुङ्‌ङिन् थिक्‍ले़प्‍माङ् इःसे़म्‍मे़ॽ॥” कर लाजरसरे़ कुन्‍ने़ॽ मार्थारे़ मे़त्तु, “दाङ्‌बे, खुने़ॽग खाम्‍मो चिङ्‌मनाबा लिसि ये़न् के़रे़मारे़रो, आल्‍लग नाम्‍सुबिलारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","हे़क्‍केःल्‍ले़ ये़सुरे़ मे़त्तु, “नसाःन् के़जोगुने़ फाॽग्र निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पयम् यम्‍बा कुमुक्‍साम्‍मिन् के़निःसुॽ फाॽआङ् तगिसा मे़त्‍ने़आङ् वये़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ इप्‍पुङ्‌ङिल्‍ले़ कुमुराओबा लुङ्‌ङिन् थिक्‍ले़प्‍माङ् मे़इसु॥ हे़क्‍क्‍याङ् ये़सुरे़ थाःङ् ओमे़त्तुर पाःत्तु, “पानुदिङ् आम्‍बे, खे़ने़ॽ आबेलिःन् के़घे़प्‍सुबाओ नोगे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","खे़ने़ॽग सदादिङ् आबेलिःन् के़घे़प्‍सुॽ के़लॽबा इङ्‌गाॽ निःसुङ्‌लो, कर इङ्‌गाॽ कप्‍मो आघिरि के़ये़प्‍पा मनाहाॽरे़ खे़ने़ॽ याप्‍मि के़बाङ्‌घे़बा पाःन्‍निन् नसाःन् मे़जोगुर फाॽआङ् कन् पाःन्‍निन् पाःत्तुङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ये़सुरे़ अक्‍खे पाःत्तुर यम्‍बा इक्‍लाओ उःत्तु, “लाजरस्‍से, लाःक्‍कात् लःन्‍दे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","के़सिःबा लाजरसे़न् लाःक्‍कात् लःन्‍दे़, खुने़ॽ कुलाङ् नु कुहुक्‍हाॽ चेदेःत्तिल्‍ले़ कुभाक् कुभाक् मे़गित्तुआङ् पत्‍छे़ हे़क्‍क्‍याङ् कुनाराःन्‍नाङ् चिरिक्‍किल्‍ले़ मे़दे़प्‍तुआङ् पत्‍छे़रो॥ ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “चेदेःत्तिन् फाःक्‍खे़म् पिरे़म्‍मे़ॽआङ् पेःक्‍ल याःन्‍दे़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","खे़ल्‍ले़ चोगुल्‍ले़ खे़प्‍मो मरियमरे़ कुदुम्‍से़ के़दाःबाआङ् के़वाॽबा यरिक् यहुदिहाॽरे़ कन् पाःन्‍निन् मे़निःसुआङ् ये़सुःन् नसाःन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","कर कुभा मनाहाॽग फरिसिहाॽओ मे़बेआङ् ये़सुरे़ चोगुबा पाःन्‍हाॽ मे़जे़क्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","हे़क्‍क्‍याङ् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु फरिसिहाॽरे़ पाःन्‍धक्‍से़ यहुदि ये़जुम्‍भो युङ्‌मा मे़उःत्तुसि॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ आल्‍ल आनिॽ थे आजोगुम्‍बाबे? लॽरिक् सेःन्‍मे़दोसुसि॥ कन् मनाःल्‍ले़ग यरिक् निङ्‌वाॽ के़माबा मिक्‍सेःन्‍हाॽ चोगुर वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","बा अक्‍खे ले़प्‍माने़ फाॽग्र काक् मनाहाॽरे़ खुने़ॽ नसाःन् मे़जोगुॽआङ् मे़दिम्‍दुॽ॥ हे़क्‍क्‍याङ् रोमि थक्‍सुबाहाॽ मे़दाआङ् माङ्‌हिम्‍मिन् नु आनिॽ सुवाङ्‌हाॽ मे़मे़क्‍खुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","हे़क्‍क्‍याङ् खे़न् तङ्‌बेबा मानिङ्‌वाॽफुसाम्‍बा कैयाफासरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ थेआङ् कुसिङ् के़न्‍निःत्तुम्‍मिन्‍लो! ");
INSERT INTO lifNT2_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","काक् आनिॽ लाजेॽइन्‌मे़क्‍मानुःल्‍ले़ कन् लत्‍छा मनाःन् काक् मनाहाॽरे़ खुनिॽ ले़क्‌वा सिःल्‍ले़ खिनिॽ लागि नुःबा पोःङ् के़लॽबा पाःन्‍निन् कुसिङ्‌निःत्ते़म्‍मे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","खुने़ॽ कन् आबाङे पाःत्तुबा मे़ःन्‍लो, कर खुने़ॽग खे़न् तङ्‌बेबा मानिङ्‌वाॽफुसाम्‍बा पोःक्‍खे़बाल्‍ले़ चोगुल्‍ले़ ये़सुःन् लाजेॽरे़ लागि सिःमा पोःङ् फाॽआङ् माङ्‌निङ्‌वाॽपाःन् पाःत्तुबारो, ");
INSERT INTO lifNT2_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","हे़क्‍क्‍याङ् यहुदिहाॽरे़ खुनिॽ लागिरक् मे़ःन्, कर वेॽ लाजेॽहाॽओ काक् के़से़बाआङ् के़वाॽबा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमनाहाॽ सोरिक् ताःप्‍मासिआङ् थिक्‍हुप् चोःक्‍मासि फाॽआङ् कन् माङ्‌निङ्‌वाॽपाःन्‍निन् खे़ल्‍ले़ पाःत्तुबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","हे़क्‍केःल्‍ले़ खे़न् ये़न्‍नाङ्‌धो खे़ङ्‌हाॽरे़ ये़सुःन् से़प्‍मा फाॽआङ् चे़म्‍भन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","खे़ल्‍ले़ चोगुल्‍ले़ ये़सुरे़ यहुदि लुम्‍मो मनाहाॽरे़ मे़निःसुर वाॽमा पेःक्‍मा ले़रुरो॥ खे़ल्‍ले़ कुले़क्‌वा खुने़ॽग ये़ःङ्‌घादे़न् पेसाङ्‌बा एफ्राइम मे़प्‍मनाबा पाङ्‌भेॽओ पेआङ् कुहुॽसाम्‍बाहाॽनु खे़प्‍मोए याःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","आल्‍ल यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मिन् ताःमा इःत्ते़आङ् वये़ल्‍ले़ पाङ्‌भेॽहाॽओलाम् यरिक् मनाहाॽ खे़न् चोःक्‌युम्‍भो तङ्‌नाम् तगि सुत्‍थो चोःक्‍सिङ्‌मा साक्‍थिम् कुइसिःक् सुत्‍थो चोःक्‍सिङ्‌से़ यरुसले़म्‍मो मे़बे॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","खे़न् मनाहाॽरे़ ये़सुःन् मे़गोःत्तु हे़क्‍क्‍याङ् खे़ङ्‌हाॽ माङ्‌हिम् लक्‍खुम्‍मो मे़ये़बे़ल्‍ले़ अक्‍खे मे़मे़त्‍छिङ्, “खुने़ॽ कन् तङ्‌नाम्‍मो ताः फाॽआङ् के़इःत्तुम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","कर तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु फरिसिहाॽरे़ ये़सुःन् ते़म्‍मा सुक्‍ते़त्‍ल फाॽआङ् खुने़ॽ के़निःसुम्‍ने़ फाॽग्र याप्‍मि आमे़त्ते़म्‍मे़ॽओ लॽरिक् मनाहाॽ इङ्‌जाःङ् मे़बिरुसिआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ये़सुःन् यहुदि चोःक्‌युम्‍भो तङ्‌नाम् ताःमानुःल्‍ले़ तुक्‍सि ये़न् तगि लाजरसरे़ कुबाङ्‌भेॽ बे़थानि त्‍ये़रो॥ बा खे़न् लाजरसे़न् सिःमे़न्‍लाम् ये़सुरे़ कुहिङ्‌वे़त् चोगुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","खे़ङ्‌हाॽरे़ खे़न् युःन्‍छिक् ये़सुःन् कुमिङ्‌सो इङ्‌धाःङ्‌ले़ लागि चा मे़मे़त्तुरो॥ मार्थारे़ खे़ङ्‌हाॽ चा मे़त्तुसिल्‍ले़ चा के़जाबाहाॽओ खुने़ॽनु सोरिक् लाजरसे़न्‍नाङ् चामा ते़न्‍नो युङे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","खे़न् ये़म्‍मो मरियम्‍मिल्‍ले़ इमे़ल्‍लुङ्‌बा पाङ्‌बोःक् फुङ्‌नाम्‍मिल्‍ले़न्‌चुक्‍सा पर्‍यामाधिक् तारुआङ् ये़सुरे़ कुलाङ्‌ङो हुःत्तु, हे़क्‍क्‍याङ् ये़सुरे़ कुलाङ्‌ङिन् कुधे़गेःक्‍इःल्‍ले़ तुगुरो॥ खे़न् कुनाम् के़नुॽबा फुङ्‌नाम्‍मिल्‍ले़ हिम्‍मिन् याक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","कर कुहुॽसाम्‍बाहाॽओ ताःन्‍दि ये़सुःन् इङ्‌गे़ले़क्‍पा यहुदा इस्‍करियोतिःल्‍ले़ अत्तुर पाःत्तु, ");
INSERT INTO lifNT2_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“थिक्‍पारे़ तङ्‌बेधिक् थारिक्‍पा नाम्‌याक् याॽरुबा कन् इमे़ल्‍लुङ्‌बा फुङ्‌नाम्‍मिङ्‌ग सङ्‌माआङ् खे़न् याङ्‌ङिन् याङ्‌गे़साॽबाहाॽ पिमासिल्‍ले़ नुःबा मे़बोःक्‍खे़म्‍बाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","खे़ल्‍ले़ से़क्‍खाए याङ्‌गे़साॽबाहाॽ लुङ्‌माॽ तुक्‍तुसिआङ् हे़क्‍के पाःत्तुबा मे़ःन्‍लो, कर खे़ङ्‌ग के़घुःम्‍बा वये़, हे़क्‍क्‍याङ् याङ् याङ्‌मा सुःक्‌वा के़युङ्‌बा वये़आङ् ए़त्‍ले़ङ् खे़प्‍मोलाम् याङ्‌ङिन् खुःत्तुर वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ये़सुरे़ मे़त्तुसि, “कन् मे़न्‍छुमाॽइन् तुक्‍खे मे़जाःत्ते़म्‍मिन्‍ने़ॽओ! खे़ल्‍ले़ग इङ्‌गाॽ आलुप्‍मा ये़न्‌रे़ लागि कन् फुङ्‌नाम्‍मिन् हुःत्तु पिराङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","याङ्‌गे़साॽबाहाॽग सदादिङ् खिनिॽनु मे़वाॽ, कर इङ्‌गाॽग सदादिङ् खिनिॽनु मे़वाॽआन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","खे़न् ये़म्‍मो यरिक् यहुदिहाॽरे़ ये़सुःन् बे़थानिओ वाॽ के़लॽबा मे़घे़प्‍सुआङ् खे़प्‍मो खुने़ॽ कुओमे़त्‍छे़रक् मे़ःन्, कर सिःमे़न्‍लाम् कुहिङ्‌वे़त् चोगुबा लाजरसे़न्‍नाङ् ओमे़त्‍छे़ खे़प्‍मो मे़द्‌ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","खे़ल्‍ले़ चोगुल्‍ले़ तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ लाजरसे़न्‍नाङ् से़प्‍मा निङ्‌वाॽ मे़जोगु, ");
INSERT INTO lifNT2_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","थेआङ्‌भे़ल्‍ले़ लाजरसे़ल्‍ले़ चोगुल्‍ले़ यहुदि लाम्‍लोःबाहाॽलाम् यरिक् मनाहाॽ मे़से़न्‍दे़ मे़बेआङ् ये़सुःन् नसाःन् मे़जोगुआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","कुदाःन्‍दिक् तङ्‌नाम्‍मो के़जुम्‍बा यरिक् मनाहाॽरे़ ये़सुःन् यरुसले़म्‍मो थाङ्‌ल पत् के़लॽबा पाःन्‍निन् मे़घे़प्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽ खे़बक्‍सिङ् पोराःक्‍हाॽ मे़याङ्‌सिङ्‌ङाङ् खुने़ॽ कुदुम्‍से़ लाम्‍देःङ् थारिक् मे़बेरो॥ अक्‍खेलॽरिक् खे़ङ्‌हाॽ मे़अःक्‍ते़, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा पोःररो! यहवे दाङ्‌बाल्‍ले़ कुमिङ्‌ङो के़दाःबान् मुॽइसाबा पोःङ्‌लरो॥ इस्राइलस्‍मा हाङ्‌ङिन् मुॽइसाबारो!” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","आल्‍ल साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् साप्‍ते़आङ् पप्‍पा कुइसिःक् ये़सुरे़ अदङ्‌साधिक् खोःसुआङ् युक्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“सियोनरे़ कुस्‍साःए, मे़गिसे़न्‍ने़ॽओ! ओमे़त्ते़ॽ, खे़ने़ॽ के़हाङ्‌ङिङ्‌ग अदङ्‌साःन् युक्‍तुआङ् खे़ने़ॽओ फे़न्‍ल पत्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","तगिग कुहुॽसाम्‍बाहाॽरे़ कन् माङ्‌निङ्‌वाॽपाःन्‍निन् के़रे़बा थेआङ् कुसिङ् मे़न्‍निःत्तुन्‍लो॥ कर याङ्‌सि ये़सुःन् साङ्‌ग्राम्‍पेदाङ्‌ङो नुःक्‍खे़ पेआङ्‌लक् साम्‌योसाप्‍लाओ खुने़ॽ कुयाःम्‍बेओ साप्‍ते़बा नु खुने़ॽ कुदुम्‍से़ लाम्‍देःङ् थारिक् मे़बेबा पाःन्‍निल्‍ले़ कुबेःन् कुसिङ् मे़निःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","आल्‍ल ये़सुरे़ लाजरसे़न् इप्‍पुङ्‌लाम् लाःक्‍कात् उःत्तुआङ् के़सिःबालाम् कुहिङ्‌वे़त् चोगुबा के़निःबा मनाहाॽरे़ खे़न् काक् पाःन्‍निन् चक्‍मे़ल्‍लॽए इङ्‌मे़भोःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","खुने़ॽ अक्‍तङ्‌बा निङ्‌वाॽ के़माबा याःम्‍बक् चोगुआङ् वाॽरो लॽरिक् मे़घे़प्‍सुबाल्‍ले़ चोगुल्‍ले़ यरिक् मनाहाॽ खुने़ॽ कुदुम्‍से़ मे़बेआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","हे़क्‍केःल्‍ले़ फरिसिहाॽ अक्‍खे मे़मे़त्‍छिङ्, “आल्‍ल आनिॽग थे़माआङ् चोःक्‍मा आन्‍छुक्‍तुम्‍मिन्‍लो॥ काक् इक्‍सादिङ् खाम्‍बेःक्‍मोबाहाॽरे़ए खुने़ॽ मे़दिम्‍दुआङ् मे़वाॽरो!” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","आल्‍ल यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मो सेवा चोःक्‍से़ के़दाःबाहाॽओ कुभा ग्रिक सुवाङ्‌हाॽआङ् यरुसले़म्‍मो मे़धाङे़आङ् मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","खे़ङ्‌हाॽ गालिलबा बे़थसेदा पाङ्‌जुम्‍बा फिलिपरो मे़बेआङ् पेलि मे़भाक्‍तु, “आदाङ्‌बे, आनिगे़ग ये़सुःन् तुम्‍मा निङ्‌वाॽ चोगुम्‍बे़आङ् वयिगे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","हे़क्‍क्‍याङ् फिलिप्‍पे़न् पेआङ् आन्‍द्रियासे़न् मे़त्तु, हे़क्‍क्‍याङ् फिलिप्‍पे़न् नु अन्‍द्रियासे़न् पेसिआङ् ये़सुःन् चे़क्‍ते़त्‍छु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ये़सुरे़ पाःत्तु, “मे़न्‍छाम्‍साःल्‍ले़ कुमिमिदिङ् पोःङ्‌मा ये़म् त्‍ये़आङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, याॽरिःम्‍बान् खाम्‍मो मक्‍थाआङ् मे़न्‍छिःए थारिक् खे़ङ्‌ग थिक्‍लक् ने़रो॥ कर खे़न् सिःने़ फाॽग्र खे़न्‍लाम् यरिक् पोगुगे़न् कुजाॽ थोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","आत्तिल्‍ले़ ने़त्तिगे़न् कुहिङ्‌मन्‍निन् लुङ्‌माॽ तुक्‍तुॽ, खे़ल्‍ले़ मासुॽरो, कर आत्तिल्‍ले़ कन् इक्‍सादिङ् खाम्‍बेःक्‍मो ने़त्तिगे़न् कुहिङ्‌मन्‍निन् थेआङ् मे़इःत्तुन्, खे़ल्‍ले़ मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍निन् से़ःप्‍तु युक्‍खुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","आत्तिल्‍ले़ इङ्‌गाॽ सेवा चोःक्‍का खे़ल्‍ले़ इङ्‌गाॽ तिम्‍माए पोःङ्, हे़क्‍केःल्‍ले़ इङ्‌गाॽ आत्तो वाॽआ, इङ्‌गाॽ आसेवारोबान्‍नाङ् खे़प्‍मोए वाॽरो॥ आत्तिल्‍ले़ सेवा चोःक्‍का खे़ङ्‌ग पानुदिङ् आम्‍बारे़ मिङ्‌सो इङ्‌धाःङ् पिरुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“इङ्‌गाॽ आनिङ्‌वाॽइन्‌साॽरिक् तुक्‍खे च्‍ये़आङ् वाॽ, हे़क्‍केःल्‍ले़ इङ्‌गाॽ थे पाःत्तुङ्‌बाबे? पानुदिङ् आम्‍बौ, कन् इनोगे़न् तुक्‍खेलाम् ताङ्‌से़ःप्‍ताङ्‌ङे़ॽ फाॽआङ् पेलि फाक्‍ने़ॽबि लॽआ, करसाङ् पेलि मे़भाक्‍ने़न्‍लो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽग इक्‍सादिङ् खाम्‍बेःक्‍मो तुक्‍खे चासे़ए त्‍याङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","खे़ल्‍ले़ चोगुल्‍ले़ पानुदिङ् आम्‍बौ, खे़ने़ॽ आबाङे मिमिदिङ् मे़त्‍छिङ्‌ङे़ॽओ॥” हे़क्‍क्‍याङ् साङ्‌ग्राम्‍पेदाङ्‌ङोलाम् इक्‍लाधिक् त्‍ये़, “इङ्‌गाॽ तगिसा आमिमिदिङ्‌ङिन् ओसेःन्‍दाङ् चोगुङ्‌ङाङ् वाॽआरो हे़क्‍क्‍याङ् याम्‍मोआङ् ओसेःन्‍दाङ् चोगुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","खे़प्‍मो के़वाॽबा मनाहाॽरे़ खे़न् इक्‍लाःन् मे़घे़प्‍सुआङ् अक्‍खे मे़मे़त्‍छिङ्, कङ्‌ग ताङ्‌साक्‍पे़न्‌उःक्‍ते़बारो, कर वेॽहाॽरे़ मे़बाःत्तु, “माङ्‌लाइङ्‌बे़न् ये़सुःन्‍नु पारे़बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ये़सुरे़ खे़न् मनाहाॽ मे़त्तुसि, “कन् इक्‍लाःङ्‌ग इङ्‌गाॽ आलागि मे़ःन्, कर खिनिॽ लागि त्‍ये़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","आल्‍ल कन् इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुघासे़न् पोःङ्‌मा ये़म् त्‍ये़आङ् वाॽरो, आल्‍ल इक्‍सादिङ् खाम्‍बेःक्‍मो हाङ्‌युक् के़जोःक्‍पाङ्‌ग लाःक्‍कात् लाप्‍फुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","कर इङ्‌गाॽग इक्‍सादिङ् खाम्‍बेःक्‍मोलाम् थाःङ् पङ्‌सिङ्‌ङाल्‍ले़ काक् मे़न्‍छाम्‍गे़न् याप्‍मिहाॽ इङ्‌गाॽ ले़प्‍माङ् उःक्‍खुङ्‌सिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","खुने़ॽ आक्‍तङ्‌बा सिःमे़न्‍नो पेःक्‍ल पत् के़लॽबान् ओसेःन्‍धाक्‍से़ ये़सुरे़ पाःत्तुबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","खे़न् मनाहाॽरे़ ये़सुःन् मे़मे़त्तु, “आनिगे़ग साम्‌योथिम् साप्‍लाओ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़न्‌सदादिङ् वाॽ लॽरिक् खे़म्‍मनारो, कर खे़ने़ॽग आक्‍खेआङ् मे़न्‍छाम्‍साःन् थाःङ् पङ्‌सिङ् लॽरिक् के़बाःत्तुबाबे? कन् मे़न्‍छाम्‍साःङ्‌ग हाःप्‍पे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “सप्‍फारे़ लागिरक् ओःत्तिःन् खिनिॽनु वाॽरो॥ खादाम्‍मान् तार पत्, हे़क्‍केःल्‍ले़ ओःत्तिःन् खिनिॽनु वाॽरए लाङ्‌घेगे़म्‍मे़ॽओ॥ खादाम्‍मो लाङ्‌गे़घेःक्‍पा मनाःल्‍ले़ आत्तो पेःक्‍ल पत् के़लॽबान् थेआङ् निङ्‌वाॽ मे़घोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ओःत्तिःन् खिनिॽनु वाॽरए खे़न् नसाःन् चोगे़म्‍मे़ॽ, हे़क्‍केःल्‍ले़ खिनिॽ ओःत्तिःल्‍ले़ कुस्‍साः के़बोःक्‍खिॽरो॥” खुने़ॽ कन् पाःन्‍निन् पाःत्तु सुरुआङ् खे़प्‍मोलाम् थासिङ् हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ मे़न्‍निए इःम्‍सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ये़सुरे़ यरिक् मनाहाॽरे़ खुनिॽ तगि कम्‍म्‍याक् यरिक् निङ्‌वाॽ के़माबा मिक्‍सेःन्‍हाॽ चोगुसाङ् खे़ङ्‌हाॽरे़ खुने़ॽ नसाःन् मे़न्‍जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","कङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा यसैयाःल्‍ले़ अक्‍खे पाःत्तुबान् के़रे़बारो– “यहवे दाङ्‌बे, हाःत्‍ले़ आनिगे़ इङ्‌घङ्‌ङिन् नसाःन् चोगुबे? हे़क्‍क्‍याङ् यहवे दाङ्‌बाल्‍ले़ कुमुक्‍साम्‍मिन् आत्तिन् ओसेःन्‍दाङ् चोगुबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","खे़ङ्‌हाॽरे़ थेआङ् नसाःन् चोःक्‍मा मे़न्‍छुक्‍तुन् फाॽआङ् यसैयाःल्‍ले़ अक्‍खेआङ् पाःत्तुआङ् वाॽरो– ");
INSERT INTO lifNT2_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“यहवे दाङ्‌बाल्‍ले़ खे़ङ्‌हाॽ मिक्‍फःम्‍बा चोगुसि हे़क्‍क्‍याङ् खुनिॽ निङ्‌वाॽइन्‌के़धुङ्‌बा चोगु पिरुसि, खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खानिःमा मे़न्‍छुक्‍तुन्, कुसिङ्‌निःप्‍मा मे़न्‍छुक्‍तुन्॥ मे़ःन्‍ने़ फाॽग्र खे़ङ्‌हाॽ यहवे दाङ्‌बाल्‍लो मे़नुःक्‍खे़आङ् खुने़ॽ वेःन्‍दुसिबामे़न्॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यसैयाःल्‍ले़ तगिसा ये़सुरे़ कुमिमिदिङ्‌ङिन् निःसुआङ् खुने़ॽ कुयाःम्‍बेओ अक्‍खेलॽरिक् पाःत्तुबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","हे़क्‍केसाङ् खे़न् ये़म्‍मो यरिक् यहुदि लाम्‍लोःबाहाॽरे़ ये़सुःन् नसाःन् मे़जोगु॥ करसाङ् खे़ङ्‌हाॽरे़ मना तगि कन् पाःन्‍निन् पाःप्‍मा मे़न्‍दे़न्‍दे़न्‍लो, थेआङ्‌भे़ल्‍ले़ फरिसिहाॽरे़ यहुदि चुम्‍लुङ्‌हिम्‍लाम् लाःक्‍कात् आम्‍लःत् आम्‍दे फाॽआङ् खे़ङ्‌हाॽ मे़गिसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","थेआङ्‌भे़ल्‍ले़ खे़न् यहुदि लाम्‍लोःबाहाॽरे़ निङ्‌वाॽफुमाङ्‌लाम् चम्‍सिङ्‌मान्‍नुःल्‍ले़ मे़न्‍छाम् याप्‍मिलाम् चम्‍सिङ्‌मान्‍ने खुनिॽ सिराॽ थाङे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","हे़क्‍क्‍याङ् ये़सुरे़ यम्‍बा इक्‍लाओ पाःत्तु, “आत्तिल्‍ले़ इङ्‌गाॽ नसाःन् चोःक्‍का खे़ल्‍ले़ इङ्‌गाॽरक् मे़ःन्, कर याप्‍मि के़बाङ्‌बान्‍नाङ् नसाःन् चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","हे़क्‍क्‍याङ् इङ्‌गाॽ के़निःबाल्‍ले़ इङ्‌गाॽ याप्‍मि के़बाङ्‌बान् निःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","इङ्‌गाॽग इक्‍सादिङ् खाम्‍बेःक्‍मो ओःत्ति हे़क्‍के त्‍याङ्‌ङाङ् वाॽआरो, हे़क्‍केःल्‍ले़ इङ्‌गाॽ नसाःन् के़जोःक्‍पाहाॽ आत्तिन्‍नाङ् खादाम्‍मो वाॽमा मे़बोःङ्‌ने़ल्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","आत्तिन् मनाःल्‍ले़ इङ्‌गाॽ पाःत्तुङ्‌बा आबाःन्‍जाक्‍हाॽ खे़प्‍सुॽ कर मे़इःत्तुन् मे़नाःत्तुन्, खे़न् खासे़न् मे़जोगुङ्‌ङिन्, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ मे़न्‍छाम् याप्‍मिहाॽ खासे़न् चोःक्‍से़ मे़ःन्, कर ताङ्‌से़ःप्‍से़ त्‍याङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","इङ्‌गाॽ के़नाॽबाहाॽ नु आबाःन् मे़ङ्‌घे़म्‍मनाबाहाॽरे़ खुनिॽ खासे़न्लोःम्‍बाङ्‌ग वेॽ वाॽरो॥ इङ्‌गाॽ पाःत्तुङ्‌बा पाःन्‍हाॽरे़ए कुनुप्‍मा ये़न्‍नो खे़ङ्‌हाॽ खासे़न् लोःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽग आबाङे थेआङ् मे़म्‍बाःप्‍पे़न्‍लो, कर याप्‍मि के़बाङ्‌बा पानुदिङ् पाःल्‍ले़ पाःप्‍मा पाङ्‌घाङ्‌बा पाःन्‍हाॽए इङ्‌गाॽ पाःत्तुङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","खुने़ॽ कुइङ्‌जाःङ्‌ङिल्‍ले़ मे़न्‍छाम् सुवाङ्‌हाॽ मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍निन् पिरुसिरो फाॽआङ् इङ्‌गाॽ निःसुङ्‌लो॥ खे़ल्‍ले़ चोगुल्‍ले़ पानुदिङ् पाःल्‍ले़ पाःत्ते़ॽ फाॽआङ् मे़त्ताङ्‌बा पाःन्‍हाॽरक् पाःत्तुङ्‌ङाङ् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","आल्‍ल यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‌रे़न्‌थिक्‌ये़न् तगि ये़सुरे़ कन् इक्‍सादिङ् खाम्‍बेःक्‍मान् ले़प्‍माआङ् पानुदिङ् पाःल्‍लो पेःक्‍मा ये़म् त्‍ये़ के़लॽबा पाःन्‍निन् निःसुरो॥ खुने़ॽ इक्‍सादिङ् खाम्‍बेःक्‍मो कुहुॽसाम्‍बाहाॽ लुङ्‌माॽ तुक्‍तुसिआङ् वये़ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ कुनुप्‍मो थारिक्‍के साॽरिक् लुङ्‌माॽ तुक्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","आल्‍ल युःन्‍छिक् चाजामा ये़म् पोःक्‍खे़आङ् वये़ल्‍ले़ सिमोनरे़ कुस्‍साः यहुदा इस्‍करियोतिःल्‍ले़ ये़सुःन् इङ्‌ले़क्‍तुर फाॽआङ् माफे़न्‍साम्‍मिल्‍ले़ तगिसा कुनिङ्‌वाॽइन्‌फे़त्‍लाःन्‍दु पिरुआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","पानुदिङ् पाःल्‍ले़ खुने़ॽ काक् सम्‍दाङ् युक् पिरुआङ् वाॽ हे़क्‍क्‍याङ् खुने़ॽ निङ्‌वाॽफुमाङ्‌लाम्‍मे त्‍ये़बा नु खुने़ॽओए नुःङ्‌ल पत् के़लॽबान् ये़सुरे़ कुसिङ् निःत्तुआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","हे़क्‍क्‍याङ् खुने़ॽ चाजामादे़न्‍नोलाम् पोगे़आङ् कुसुङ्‌घेःक्‌वाःन् फे़न्‍दुआङ् याम्दुःक्‍माल्‍ले़ कित्‍लिक् कित्‍छिङ्, ");
INSERT INTO lifNT2_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","हे़क्‍केलॽरिक्‍के च्‍वाःत्तिन् खप्प्‍याओ हुक्‍खुआङ् कुहुॽसाम्‍बाहाॽरे़ खुनिॽ लाङ्‌हाॽ वाहप्‍मा हेःक्‍तु हे़क्‍क्‍याङ् कित्‍छिङ्‌बा याम्‍दुःक्‍माल्‍ले़ तुगु पिरुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","खुने़ॽ सिमोन पत्रुसरे़ कुलाङ् वाहप्‍से़ फे़रे़ल्‍ले़ खे़ल्‍ले़ मे़त्तु, “दाङ्‌बे, खे़ने़ॽ आलाङ्‌ङिन् वागे़हप्‍तुबाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ये़सुरे़ नोगप् पिरु, “आल्‍लो इङ्‌गाॽ थे चोगुङ्‌ल पत्ता के़लॽबान् कुसिङ् के़न्‍निःत्तुन्‍लो कर ताःन्‍दिग कुसिङ् के़निःत्तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पत्रुसरे़ मे़त्तु, “खे़ने़ॽग आप्‍फाल्‍ले़आङ् आलाङ्‌हाॽ वाहप्‍मा मे़नुॽने़न्‍लो!” ये़सुरे़ नोगप् पिरु, “इङ्‌गाॽ के़लाङ्‌हाॽ वामे़हप्‍तुङ्‌ङिन्‍ने़ फाॽग्र खे़ने़ॽ इङ्‌गाॽनु लक् के़ङ्‌घोःसुन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","हे़क्‍केःल्‍ले़ सिमोन पत्रुसरे़ नोगप् पिरु, “हे़क्‍केने़ फाॽग्र आलाङ्‌हाॽरक् मे़ःन्, कर आहुक्‍हाॽ नु आधे़गेःक्‍किन्‍नाङ् वाहप्‍ताङ् पिराङ्‌ङे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ये़सुरे़ नोगप् पिरु, “वागे़रुम्‍सिङ्‌बा मनाःङ्‌ग सेसे पोःङ्‌मारे़ लागि कुलाङ्‌हाॽरक् वाहप्‍मा पोःङ्‌लो, थेआङ्‌भे़ल्‍ले़ नासिङ्‌गे़न् कुधक्‍किङ्‌ग सेसेए चोःक्‍लो, हे़क्‍केःल्‍ले़ खिनिॽग सेसेए के़जोगिसाङ् खिनिॽ के़रे़क् सेसे के़होःप्‍तिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","थेआङ्‌भे़ल्‍ले़ खुने़ॽ हाःत्‍ले़ इङ्‌ले़क्‍तुॽ के़लॽबान् कुसिङ् निःत्तुआङ् वये़रो, खे़ल्‍ले़ चोगुल्‍ले़ ये़सुरे़ खिनिॽ के़रे़क् सेसे के़होःप्‍तिॽ लॽरिक् मे़त्तुसिबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ये़सुरे़ खुनिॽ लाङ्‌हाॽ वाहप्‍तु पिरुसिआङ् कुजाङ्‌ङिन् चाक्‍सिङ् हे़क्‍क्‍याङ् युङ्‌सिङ्‌लो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ सेःन्‍दोसुसि, “खिनिॽ लागि इङ्‌गाॽ थे चोगुङ्‌बा फाॽआङ् कुसिङ् के़निःत्तुम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","खिनिॽ दाङ्‌बा नु सिक्‍साम्‍बा लॽरिक् याप्‍मि के़मे़त्तिॽ॥ खे़न् से़क्‍खाए के़बाःत्तुम्, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽग बा खे़न्‍नारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","आल्‍ल इङ्‌गाॽ खिनिॽ दाङ्‌बा नु सिक्‍साम्‍बाआसाङ् खिनिॽ लाङ्‌हाॽ वाहप्‍तुङ् पिनिङ्, खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽआङ् सेवारोबा कुइसिःक् लाङ् वाहप्‍मा पिसिङ्‌मा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","इङ्‌गाॽ चोगुङ्‌बा कुइसिःक्‍के खिनिॽ के़जोगुम्‍ल फाॽआङ् कन् कुबिःन् युक्‍खुङ् पिनिङ्‌ङाङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, सेवारोबान् कुन्‍दाङ्‌बान्‍नुःल्‍ले़ यम्‍बा मे़ःन्‍लो, हे़क्‍क्‍याङ् इङ्‌साबान्‍नाङ् खुने़ॽ के़बाङ्‌बान्‍नुःल्‍ले़ यम्‍बा मे़ःन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","आल्‍ल कन् पाःन्‍हाॽग कुसिङ् के़निःत्तुम्‍माङ् के़वयिॽ, हे़क्‍क्‍याङ् कङ्‌हाॽ के़जोगुम्‍ने़ फाॽग्र मुॽइसाबा के़बोःक्‍खिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“इङ्‌गाॽ खिनिॽ के़रे़क्‍ले़ लागिग पाःत्तुङ्‌बा मे़ःन्‍लो॥ इङ्‌गाॽ सेःक्‍निङ्‌बाहाॽग नुःरिक्‍काङ् कुसिङ् निःत्‍निङ्‌लो॥ कर इङ्‌गाॽनु सोरिक् चागे़जाबान्‍ने इङ्‌गाॽ आदक्‍ले़ङ्‌वाओ पोगे़रो फाॽआङ् साम्‌योसाप्‍लाःल्‍ले़ पाःत्तुबान् के़त्‍लए पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","कन् पाःन्‍हाॽग पोःङ्‌मानुःल्‍ले़ तगिए खिनिॽ मे़त्‍निङ्‌ङाङ् वाॽआरो॥ हे़क्‍केःल्‍ले़ कन् पाःन्‍हाॽ के़त्तिल्‍ले़ इङ्‌गाॽ ख्रिस्‍तआ फाॽआङ् नसाःन् के़जोगुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आत्तिल्‍ले़ इङ्‌गाॽ पाङ्‌घुङ्‌सिङ्‌बाहाॽ लाङ्‌दाःक्‍तुसिॽ, खे़ल्‍ले़ इङ्‌गाॽ लाङ्‌दाःक्‍कारो, हे़क्‍क्‍याङ् आत्तिल्‍ले़ इङ्‌गाॽ लाङ्‌दाःक्‍का, खे़ल्‍ले़ इङ्‌गाॽ याप्‍मि के़बाङ्‌बे़न् लाङ्‌दाःक्‍तुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ये़सुरे़ खे़न् पाःन्‍हाॽ पाःत्तु सुरुआङ् कुयोःम् पुॽरे़र अक्‍खेलॽरिक् इङ्‌भोःसुसि, “इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खिनिॽओ थिक्‍किल्‍ले़ इङ्‌गाॽ इङ्‌ले़क्‍कारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","हे़क्‍केःल्‍ले़ कुहुॽसाम्‍बाहाॽरे़ हाःत्‍ले़ कुयाःम्‍बेओ पाःत्तुबाइ लॽरिक् खुनिॽ निङ्‌वाॽ मये़र ओमे़मे़त्‍छिङ्‌॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","खे़ङ्‌हाॽओ ये़सुरे़ साॽरिक् लुङ्‌माॽ तुक्‍तुबा कुहुॽसाम्‍बाधिक् कुबेसाङ् खे़ःम्‍सिङ्‌ङाङ् युङे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","सिमोन पत्रुसरे़ खे़न् हुॽसाम्‍बान् खुने़ॽ हाःप्‍पे फाॽआङ् सेःन्‍दोःसे़ॽ लॽरिक् हुक्‍चाःल्‍किःल्‍ले़ मिक्‍सेःन् पिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","हे़क्‍केःल्‍ले़ खे़न् हुॽसाम्‍बाल्‍ले़ ये़सुओ खे़ःम्‍सिङ्‌ल सेःन्‍दोसु, “दाङ्‌बे खे़ङ्‌ग हाःत्‍ने़बे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ये़सुरे़ नोगप् पिरुसि, “इङ्‌गाॽ कन् खरे़ःङ्‌ङिल्‍ले़ कुघे़ःङ्‌ङिन् खोर्याओ निःप्‍सुङ्‌ङाङ् पिरुङ्‌बा मनाःन्‍ने़रो॥” हे़क्‍क्‍याङ् ये़सुरे़ खरे़ःङ्‌ङिल्‍ले़ कुघे़ःङ्‌ङिन् निःप्‍सुआङ् सिमोनरे़ कुस्‍साः यहुदा इस्‍करियोते़न् पिरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","यहुदाःल्‍ले़ खे़न् ताःक्‍तुनामे़ःन्‍ने माफे़न्‍साम्‍मिल्‍ले़ खे़न् युक्‍तुरो॥ हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मे़त्तु, “खे़ने़ॽ थे़मा चोःक्‍मा निङ्‌वाॽ के़जोगुआङ् वाॽ, खे़न् हाराए चोगे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","कर खे़प्‍मो चाजाइ के़युङ्‌बाहाॽरे़ ये़सुरे़ हे़क्‍के मे़त्तुबा पाःन्‍निन् थेआङ् कुसिङ् मे़न्‍निःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","यहुदाःङ्‌ग याङ् याङ्‌मा सुःक्‌वा के़गुबा वये़बाल्‍ले़ साभाङ्‌जाओ चाहाबा के़जोःक्‍पा चिगःक्‌वाहाॽ इङ्‌मा इग्र याङ्‌गे़साॽबाहाॽ कुजा हाःप्‍मासि फाॽआङ् ये़सुरे़ मे़त्तुबाबिला लॽरिक् कुभारे़ निङ्‌वाॽ मे़इःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","खरे़ःङ्‌ङिन् चनुमे़ःन्‍ने यहुदाःन् मुत्‍थ्रिक् पोगे़आङ् खामाक्‍लुम्‍मो लःन्‍दे़ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","यहुदाःन् लाःक्‍कात् लःन्‍दे़ पेआङ् ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आल्‍ल इङ्‌गाॽ मे़न्‍छाम्‍साःल्‍ले़ आमिमिदिङ् पोःङ्‌मा ये़म्‍मिन् त्‍ये़आङ् वाॽरो हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिन् खुने़ॽओ मिमिदिङ् पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","निङ्‌वाॽफुमाङ्‌ङिन् कुस्‍साःओ मिमिदिङ् पोःङ्‌ने़ फाॽग्र निङ्‌वाॽफुसाःल्‍ले़ कुमिमिदिङ् चोगुॽ, खे़न्‍नाङ् हाराए मिमिदिङ् चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","आमिःम् आस्‍साःसे, इङ्‌गाॽग खिनिॽनु सप्‍फारक् वाॽआरो हे़क्‍क्‍याङ् खिनिॽ याप्‍मि के़गोःत्तिॽ कर यहुदि लाम्‍लोःबाहाॽ मे़त्तुङ्‌सिङ्‌बा कुइसिःक्‍के खिनिॽआङ् मे़त्‍निङ्, ‘इङ्‌गाॽ आत्तान् पेःक्‍का खे़प्‍मो ताःमा के़न्‍छुक्‍तिन्॥’ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","खे़ल्‍ले़ चोगुल्‍ले़ आल्‍ल खिनिॽ लुङ्‌माॽ तुक्‍कासिम्‍मे़ॽ फाॽआङ् इङ्‌गाॽ कुसङ् इङ्‌जाःङ् पिनिङ्‌लो॥ खिनिॽ इङ्‌गाॽ लुङ्‌माॽ तुक्‍निङ्‌बा कुइसिःक्‍के लुङ्‌माॽ तुक्‍कासिम्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","खिनिॽ लुङ्‌माॽ के़दुक्‍कासिने़ फाॽग्र खे़न्‍लाम्‍मे काक् मे़न्‍छाम् याप्‍मिहाॽरे़ खिनिॽ आहुॽसाम्‍बानिङ् फाॽआङ् कुसिङ् के़म्‍निःत्तिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","सिमोन पत्रुसरे़ खुने़ॽ सेःन्‍दोसु, “दाङ्‌बे, खे़ने़ॽ आत्तान् के़बेःक्‍पाबे?” ये़सुरे़ नोगप् पिरु, “इङ्‌गाॽ आत्तान् पेःक्‍कार पत्ता आल्‍लो तिम्‍मा के़न्‍छुक्‍कान्‍लो, कर याङ्‌सिग इङ्‌गाॽ के़दिम्‍माॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पत्रुसरे़ सेःन्‍दोसु, “दाङ्‌बे, थेआङ् आल्‍लो तिम्‍मा मे़सुक्‍ने़न्बे? खे़ने़ॽ के़लागि इङ्‌गाॽ आल्‍लो सिःमासाङ् यारिप् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","हे़क्‍केःल्‍ले़ ये़सुरे़ नोगप् पिरु, “खे़ने़ॽ से़क्‍खाए इङ्‌गाॽ आलागि सिःमा यारिप् के़वाॽबि? इङ्‌गाॽ से़क्‍खा मे़त्‍ने़ॽ, इङ्‌वा काःमानुःल्‍ले़ तगिए खुने़ॽ कुसिङ्‌मे़निःत्तुङ्‌ङिन् के़बाःत्तुर सुम्‍ले़ङ् के़नाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ये़सुरे़ याम्‍मो कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “खिनिॽ निङ्‌साम्‍मो मे़ध्‍ये़म्‍मिन्‍ने़ॽओ, कर निङ्‌वाॽफुमाङ्‌ङिन् नसाःन् चोगे़म्‍मे़ॽओ, हे़क्‍केलॽरिक् इङ्‌गाॽआङ् याप्‍मि नसाःन् आजोगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","पानुदिङ् आम्‍बारे़ कुहिम्‍मोग यरिक् याक्‍फाङ्‌हाॽ मे़ने़ हे़क्‍क्‍याङ् इङ्‌गाॽ खिनिॽ लागि युङ्‌दे़न् यारिप् चोःक्‍से़ पेःक्‍कार पत्तारो॥ खे़न् होःप्‍ते़ल्‍ले़ग इङ्‌गाॽ हे़क्‍के मे़मे़त्‍निङ्‌ङिम्‍बा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","हे़क्‍क्‍याङ् इङ्‌गाॽ पेःक्‍काआङ् खिनिॽ लागि युङ्‌दे़न् यारिप् चोगुङ्‌ङाङ् याम्‍मो युःआ हे़क्‍क्‍याङ् खिनिॽआङ् तेॽनिङ्‌लो॥ हे़क्‍केलॽरिक् इङ्‌गाॽ आत्ति वाॽआ खे़प्‍मो खिनिॽआङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","इङ्‌गाॽ पेःक्‍कार पत्ताबा लाम्‍मिङ्‌ग खिनिॽ कुसिङ् के़निःत्तुम्‍माङ् के़वयिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमारे़ खुने़ॽ मे़त्तु, “दाङ्‌बे, खे़ने़ॽ आत्तान् के़बेःक्‍ल के़बत् खे़न् आनिगे़ मे़निःसुम्‍बे़न्, हे़क्‍केःल्‍ले़ आनिगे़ खे़न् लाम्‍मिन् आक्‍खेलॽरिक् कुसिङ् निःत्तुम्‍बे़बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ये़सुरे़ नोगप् पिरु, “लाम्, से़क्‍खा नु मे़न्‍नुप्‍मनाबा हिङ्‌मन् इङ्‌गाॽएरो॥ आत्तिन्‍नाङ् इङ्‌गाॽ मे़ःन्‍नेग पानुदिङ् पाःल्‍लो के़प्‍मा मे़सुक्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","खिनिॽ से़क्‍खाए याप्‍मि कुसिङ् के़निःत्तिआङ् के़वयिॽने़ फाॽग्र पानुदिङ् आम्‍बाआङ् कुसिङ् के़निःत्तुम्‍लो॥ आल्‍लाङ्धो खुने़ॽ कुसिङ् के़निःत्तुम्‍लो, थेआङ्‌भे़ल्‍ले़ खुने़ॽ के़निःसुम्‍माङ् के़वयिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिपरे़ पाःत्तु, “दाङ्‌बे, पानुदिङ् पाःन् याप्‍मि ओसेःन्‍आधाक्‍ते़ॽओ हे़क्‍क्‍याङ् आनिगे़ निङ्‌वाॽ ताःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ये़सुरे़ नोगप् पिरु, “मे़ःम्‍बे़ फिलिप्‍पे, इङ्‌गाॽग आल्‍लो थारिक् खिनिॽनु सोरिक् वयाङ्‌साङ् इङ्‌गाॽ याप्‍मि कुसिङ् के़न्‍निःत्तान्‍बि? हाःत्‍ले़ इङ्‌गाॽ निसाङ्‌ङाङ् वाॽ, खे़ल्‍ले़ग पानुदिङ् पाःन्‍नाङ् निःसुआङ् वाॽरो॥ हे़क्‍केःल्‍ले़ आक्‍खेलॽरिक् पानुदिङ् पाःन् ओसेःन्‍आधाक्‍ते़ॽ लॽरिक् के़बाःत्तुबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","इङ्‌गाॽ पानुदिङ् पाःओ वाॽआ, हे़क्‍क्‍याङ् पानुदिङ् पाःन् इङ्‌गाॽओ वाॽ फाॽआङ् नसाःन् के़न्‍जोगुन्‍बि? इङ्‌गाॽ पाःत्तुङ्‌बा पाःन्‍जाक्‍हाॽग आबाङे इङ्‌गाॽइन् मे़ःन्‍लो, कर इङ्‌गाॽओ के़वाॽबा पानुदिङ् पाःल्‍ले़ए इङ्‌गाॽओलाम् कुयाःम्‍बक्‍हाॽ चोगुबारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","इङ्‌गाॽ पानुदिङ् पाःओ हे़क्‍क्‍याङ् पानुदिङ् पाःन् इङ्‌गाॽओ वाॽ लॽरिक् पाःत्तुङ्‌बा पाःन्‍निन् नसाःन् चोगे़म्‍मे़ॽओ, मे़ःन्‍ने़ फाॽग्र इङ्‌गाॽ चोगुङ्‌बा निङ्‌वाॽ के़माबा याःम्‍बक्‍किल्‍ले़ चोगुल्‍ले़ नसाःन् चोगे़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, हाःत्‍ले़ इङ्‌गाॽ नसाःन् चोःक्‍का, खे़ल्‍ले़ग इङ्‌गाॽ चोगुङ्‌बान्‍नुःल्‍ले़आङ् पयम् यम्‍बा याःम्‍बक्‍हाॽ चोगुॽरो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ पानुदिङ् पाःल्‍लो पेःक्‍कार पत्तारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","खिनिॽ आमिङ्‌ङो थे के़नाःक्‍तुम्‍साङ् पानुदिङ् पाःल्‍ले़ कुमिङ्‌सो कुधाःङ्‌सो कुस्‍साःओलाम् ओसेःन्‍दाङ् पोःङ्‌ल फाॽआङ् इङ्‌गाॽ खे़न् चोगुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","इङ्‌गाॽ आमिङ्‌ङो थेःन् के़नाःक्‍तुम्‍साङ् खे़न् इङ्‌गाॽ चोगुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“इङ्‌गाॽ याप्‍मि मिःम्‍जि के़मे़त्तिॽने़ फाॽग्र आइङ्‌जाःङ्‌हाॽ के़इःत्तुम् के़नाःत्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","इङ्‌गाॽ पानुदिङ् पाःन्‍नु पेलिगे़न् तुवा चोगुङ्‌लो, हे़क्‍क्‍याङ् खुने़ॽग खिनिॽनु सदादिङ् वाॽर फाॽआङ् वेॽ कुभाॽ के़बिबाधिक् के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","खुने़ॽग काक् से़क्‍खाओ लाम्‍गे़लोःबा सेसेमाङ्‌लो॥ कन् इक्‍सादिङ् खाम्‍बेःक्‍मोबा मनाहाॽरे़ खुने़ॽ खोःमा मे़न्‍छुक्‍तुन्‍लो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ मे़न्‍निःसुन्‍नाङ् कुसिङ्‌ङाङ् मे़न्‍निःत्तुन्‍लो॥ कर खिनिॽग खुने़ॽ कुसिङ् के़निःत्तुम्‍लो, थेआङ्‌भे़ल्‍ले़ आल्‍लो खुने़ॽ खिनिॽनु सोरिक् वाॽ हे़क्‍क्‍याङ् के़दाःबा ये़म्‍मोआङ् खिनिॽ हिङ्‌मन्‍नो वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","इङ्‌गाॽग खिनिॽ ये़त्‍छाबा कुइसिःक् पक्‍मे़धानिङ्‌ङिन्‍लो॥ इङ्‌गाॽ खिनिॽओ युःआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","सप्‍फा एगाङ्‌ङाङ्‌ग इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ इङ्‌गाॽ मे़निआन्‍लो, कर खिनिॽग याप्‍मि के़निःसिॽरो॥ इङ्‌गाॽ हिङ्‌ङा, खे़ल्‍ले़ चोगुल्‍ले़ खिनिॽआङ् के़हिङिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","खे़न् ये़न्‍नो इङ्‌गाॽ पानुदिङ् आम्‍बाओ वाॽआ, हे़क्‍क्‍याङ् खिनिॽ इङ्‌गाॽओ के़वयिॽआङ् इङ्‌गाॽ खिनिॽओ वाॽआबा पाःन्‍निन् कुसिङ् के़निःत्तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","हाःत्‍ले़ इङ्‌गाॽ आइङ्‌जाःङ्‌हाॽ खे़प्‍सुआङ् इःत्तु नाःत्तुॽ, इङ्‌गाॽ याप्‍मि लुङ्‌माॽ के़दुक्‍पे़ङ्‌ग बा खे़न्‍नेरो॥ हाःत्‍ले़ इङ्‌गाॽ लुङ्‌माॽ तुक्‍का खे़ङ्‌ग पानुदिङ् आम्‍बारे़ लुङ्‌माॽ तुक्‍तुॽ, हे़क्‍क्‍याङ् इङ्‌गाॽआङ् लुङ्‌माॽ तुक्‍तुङ्‌ङाङ् खे़ल्‍लो ओसेःन्‍धाक्‍सिङ्‌ङारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","हे़क्‍क्‍याङ् यहुदाःल्‍ले़ (यहुदा इस्‍करियोतिङ्‌ग मे़ःन्‍लो) मे़त्तु, “कर दाङ्‌बे, वेॽ यरिक् मनाहाॽनुग ओसेःन्‍गे़न्‍धाक्‍सिङ्‌ङिन् कर आनिगे़नुरक् थेआङ् ओसेःन्‍धाक्‍सिङ्‌मा निङ्‌वाॽ के़जोगुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ये़सुरे़ नोगप् पिरु, “हाःत्‍ले़ इङ्‌गाॽ मिःम्‍जि मे़त्ता, खे़ल्‍ले़ग इङ्‌गाॽ आनिसाम्‍मिन् इःत्तु नाःत्तुॽरो॥ पानुदिङ् आम्‍बारे़ खे़न् मिःम्‍जि मे़त्तुॽ हे़क्‍क्‍याङ् आन्‍छिगे़ ताःसिगे़आङ् खे़न्‍नु वाॽसिगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","हाःत्‍ले़ इङ्‌गाॽ मिःम्‍जि मे़मे़त्तान्, खे़ल्‍ले़ इङ्‌गाॽ आनिसाम्‍मिन् मे़इःत्तुन् मे़नाःत्तुन्‍लो॥ कन् के़घे़प्‍सुम्‍बा आबाःन्‍जाक्‍किङ्‌ग आबाङे इङ्‌गाॽइन् मे़ःन्‍लो, कर याप्‍मि के़बाङ्‌बा पानुदिङ् पाःल्‍ले़न्‍ने़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","कन् काक् पाःन्‍हाॽ इङ्‌गाॽ खिनिॽनु वाॽआल्‍ले़सा मे़त्‍निङ्‌ङाङ् वाॽआरो ");
INSERT INTO lifNT2_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","कर पानुदिङ् पाःल्‍ले़ आमिङ्‌ङो पाङ्‌मा इःत्तुबा कुभाॽ के़बिबा सेसेमाङ्‌ङिल्‍ले़ काक् पाःन्‍हाॽ के़हुॽरिआङ् इङ्‌गाॽ मे़त्‍निङ्‌बा पाःन्‍हाॽ निङ्‌वाॽसोओ तारु के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","इङ्‌गाॽ सनारुङ्‌ङिन् खिनिॽनु पक्‍थाङ्‌लो, आसनारुङ्‌ङिन् खिनिॽ पिनिङ्‌लो॥ कङ्‌ग इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ के़बिरिबा हे़क्‍केग मे़बिनिङ्‌ङिन्‍लो॥ खिनिॽ निङ्‌साम्‍मो मे़ध्‍ये़म्‍मिन्‍ने़ॽ हे़क्‍क्‍याङ् मे़गिसे़म्‍मिन्‍ने़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","इङ्‌गाॽ पेःक्‍कार पत्ता हे़क्‍क्‍याङ् याम्‍मो खिनिॽओ नुःङ्‌ङा ताआबान् के़घे़प्‍सुम्‍माङ् के़वयिॽरो॥ इङ्‌गाॽ से़क्‍खाए याप्‍मि मिःम्‍जि के़मे़त्तिॽने़ फाॽग्र इङ्‌गाॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङो नुःङ्‌ङा पेःक्‍काल्‍ले़ खिनिॽग के़सःत्तिॽरो, थेआङ्‌भे़ल्‍ले़ खुने़ॽग इङ्‌गाॽनुःल्‍ले़आङ् पयम् यम्‍बा चोःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","कन् पाःन्‍हाॽ के़त्तिल्‍ले़ नसाःन् याप्‍मि आगे़जोगिर फाॽआङ् कन् पाःन्‍हाॽ पोःङ्‌मानुःल्‍ले़ तगि खिनिॽ आल्‍लोसा मे़त्‍निङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","आल्‍ल खिनिॽनु यरिक् मे़बाःत्तान्, थेआङ्‌भे़ल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मोबा हाङ्‌युक् के़जोःक्‍पान् फे़न्‍ल पत्‍लो॥ आसम्‍दाङ् खे़ल्‍ले़ थेआङ् मुक्‍साम् मे़गत्तुन्‍लो, ");
INSERT INTO lifNT2_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","कर इक्‍सादिङ् खाम्‍बेःक्‍मोबा के़रे़क्‍ले़ पानुदिङ् पाःन् लुङ्‌माॽ तुक्‍तुङ्‌बान् मे़निःसुर फाॽआङ् इङ्‌गाॽ पानुदिङ् आम्‍बारे़ पिराङ्‌बा इङ्‌जाःङ्‌हाॽ कुइसिःक् चोगुङ्‌लो॥ आल्‍ल कप्‍मोलाम् पेगिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ये़सुरे़ याम्‍मो कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “इङ्‌गाॽग से़क्‍खास्‍मा चे़ल्‍ले़क्‍सेॽइल्‍ले़ कुबुङ्‌आरो॥ हे़क्‍क्‍याङ् पानुदिङ् आम्‍बाग इक्‍मःबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","इङ्‌गाॽओ कुजाॽ मे़न्‍धोःक्‍मनाबा काक् पोराःक्‍हाॽग चे़प्‍तुदेःसुॽ हे़क्‍क्‍याङ् कुजाॽ के़धोःक्‍पाहाॽआङ् आल्‍लसाङ् यरिक् कुजाॽ थोःक्‍ल फाॽआङ् कुबोराःक्‍हाॽ चे़प्‍तुआङ् साःक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","पोराःक्‍हाॽ चे़प्‍माआङ् साःक्‍मनाबा चे़ल्‍ले़क्‍सेॽइल्‍ले़ कुबुङ् कुइसिःक् इङ्‌गाॽ पाःत्तुङ्‌बा पेलिगे़न् पाःन्‍जाक्‍किल्‍ले़ तगिसा खिनिॽ सेसे के़बोःक्‍खिआङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","इङ्‌गाॽओ वये़म्‍मे़ॽ हे़क्‍क्‍याङ् इङ्‌गाॽ खिनिॽओ वाॽआरो॥ सिङ् पोराःक्‍किन् चे़प्‍माआङ् कुबुङ्‌मोलाम् से़म्‍माने़ फाॽग्र खे़ॽयो कुजाॽ थोःक्‍मा मे़सुक्‍ने़न्‍लो, हे़क्‍केलॽरिक् खिनिॽआङ् इङ्‌गाॽओ मे़न्‌वाॽए कुजाॽ फम्‍मा के़न्‍छुक्‍तुम्‍मिल्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","इङ्‌गाॽग चे़ल्‍ले़क्‍सेॽइल्‍ले़ कुबुङ्‌आरो हे़क्‍क्‍याङ् खिनिॽग आबोराःक्‍निङ्‌लो॥ खिनिॽ इङ्‌गाॽओ के़वयिॽआङ् इङ्‌गाॽ खिनिॽओ वाॽआने़ फाॽग्र आल्‍लसाङ् यरिक् कुजाॽ फम्‍मा के़सुक्‍तुम्‍लो, कर इङ्‌गाॽओ मे़न्‌वाॽए थेआङ् चोःक्‍मा के़न्‍छुक्‍तुम्‍मिल्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","इङ्‌गाॽओ मे़न्‌वाॽमनाबाङ्‌ग चे़प्‍माआङ् लाप्‍फुमनाबा के़हेबाआङ् के़सिःबा सिङ् पोराःक् कुइसिःक् पोःङ्‌लो॥ खे़ङ्‌ग मनाहाॽरे़ मे़घप्‍सुआङ् मिओ मे़हाःन्‍दुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","खिनिॽ इङ्‌गाॽओ हे़क्‍क्‍याङ् आबाःन्‍जाक्‍किन् खिनिॽओ वाॽने़ फाॽग्र खिनिॽ सिराॽ के़धाङ्‌बा पाःन्‍हाॽ थे के़नाःक्‍तुम्‍साङ् खिनिॽ के़घोःसुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","यरिक् कुजाॽ के़भत्‍छुम्‍ने़ फाॽग्र पानुदिङ् आम्‍बारे़ कुमिमिदिङ् के़जोगुम्‍माङ् खिनिॽ से़क्‍खास्‍मा आहुॽसाम्‍बा के़बोःक्‍खिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","पानुदिङ् पाःल्‍ले़ लुङ्‌माॽ तुक्‍ताङ्‌बा कुइसिःक् खिनिॽआङ् लुङ्‌माॽ तुक्‍निङ्‌ङाङ् वाॽआरो॥ खिनिॽ चक्‍मे़ल्‍लॽए आमिःम्‍जिओ वये़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","पानुदिङ् आम्‍बारे़ कुइङ्‌जाःङ्‌ङिन् इःत्तुङ् नाःत्तुङ्‌ङाङ् इङ्‌गाॽ कुमिःम्‍जिओ वाॽआबा कुइसिःक् इङ्‌गाॽ आइङ्‌जाःङ्‌ङिन् के़इःत्तुम् के़नाःत्तुम्‍ने़ फाॽग्र आमिःम्‍जिओ के़वयिबा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","आसिक् सम्‍बा कुइसिःक्‍के खिनिॽआङ् सिक् पसम्‍सम्‍ल फाॽआङ् कन् पाःन्‍हाॽ मे़त्‍निङ्‌बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","आल्‍ल इङ्‌गाॽ लुङ्‌माॽ तुक्‍निङ्‌बा कुइसिःक् खिनिॽआङ् लुङ्‌माॽ तुक्‍कासिम्‍मे़ॽ फाॽआङ् इङ्‌जाःङ् पिनिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","चुम्‍मिल्‍ले़ कुलागि हिङ्‌मन् पिमान्‍ने यम्‍बा मिःम्‍जिरो, कन्‍नुःल्‍ले़ यम्‍बा मिःम्‍जि वेॽ होःप्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","खिनिॽ पिनिङ्‌बा आइङ्‌जाःङ्‌ङिन् के़इःत्तुम् के़नाःत्तुम्‍ने़ फाॽग्र आन्‍जुम् के़बोःक्‍खिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","आल्‍लाङ्धो इङ्‌गाॽ सेवारोबा मे़मे़त्‍निङ्‌ङिन्‍लो, थेआङ्‌भे़ल्‍ले़ कुन्‍दाङ्‌बाल्‍ले़ चोःक्‍मा इःत्तुबा पाःन्‍हाॽ सेवारोबाल्‍ले़ मे़निःसुन्‍लो॥ कर खिनिॽग आन्‍जुम्‍निङ् फाॽआङ् मे़त्‍निङ्‌ङाङ् वाॽआरो, थेआङ्‌भे़ल्‍ले़ पानुदिङ् आम्‍बारे़ मे़त्ताङ्‌बा काक् पाःन्‍हाॽ खिनिॽ मे़त्‍निङ्‌ङाङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","खिनिॽ याप्‍मि के़न्‍छेगिन् कर इङ्‌गाॽ खिनिॽ सेःक्‍निङ्‌, हे़क्‍क्‍याङ्‌पेगे़म्‍मे़ॽआङ् सदादिङ् के़बप्‍पा कुजाॽ फत्‍छे़म्‍मे़ॽ फाॽआङ् सेःक्‌युक् चोःक्‍निङ्‌ङाङ् वाॽआरो॥ आमिङ्‌ङो थे के़नाःक्‍तुम्‍साङ् पानुदिङ् आम्‍बारे़ के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","खिनिॽ लुङ्‌माॽ तुक्‍कासिम्‍मे़ॽ फाॽआङ् इङ्‌जाःङ् पिनिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“कन् इक्‍सादिङ् खाम्‍बेःक्‍मोबाहाॽरे़ के़म्‍जिःत्तिल्‍ले़ खे़न्‍नु तगि इङ्‌गाॽ मे़जिःत्ताङ्‌बा पाःन्‍निन् निङ्‌वाॽ इःत्ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","खिनिॽ कन् इक्‍सादिङ् खाम्‍बेःक्‍मोबा के़वयिल्‍ले़ग आबाङे खुनिॽ मना हे़क्‍केए लुङ्‌माॽ के़म्‍दुक्‍तिॽमे़न्, कर खिनिॽग इक्‍सादिङ् खाम्‍बेःक्‍मोबा मे़ःन्‍निङ्‌लो॥ खिनिॽग इक्‍सादिङ् खाम्‍बेःक्‍मोलाम् इङ्‌गाॽ सेःक्‍निङ्‌ङाङ् वाॽआरो, खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खिनिॽ के़म्‍जिःत्तिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","इङ्‌गाॽ मे़त्‍निङ्‌बा आबाःन्‍हाॽ निङ्‌वाॽ इःत्ते़म्‍मे़ॽओ ‘सेवारोबान् कुन्‍दाङ्‌बान्‍नुःल्‍ले़ यम्‍बा मे़ःन्‍लो॥’ खे़ङ्‌हाॽरे़ इङ्‌गाॽए तुक्‍खे मे़जाःत्ताङ्‌ङिल्‍ले़ खिनिॽआङ् तुक्‍खे के़म्‍जाःत्तिॽरो॥ खे़ङ्‌हाॽरे़ इङ्‌गाॽ आनिसाम्‍मिन् मे़इःत्तु मे़नाःत्तुआङ् वये़ल्‍ले़ग खिनिॽ निसाम्‍मिन्‍नाङ् मे़इःत्तु मे़नाःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","खिनिॽग इङ्‌गाॽइन् के़बोःक्‍खिआङ् के़वयिबाल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ इङ्‌गाॽ मे़मे़त्ताङ्‌बा कुइसिःक्‍के खिनिॽ के़म्‍मे़त्तिॽरो॥ थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ग इङ्‌गाॽ याप्‍मि के़बाङ्‌बान् कुसिङ् मे़न्‍निःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","इङ्‌गाॽ त्‍याङ्‌ङाङ् खे़ङ्‌हाॽ लायोरे़ कुयाःम्‍बेओ मे़म्‍मे़त्‍छिङ्‌बान्‍निल्‍ले़ग लायोरे़न् आप्‍तिक् मे़ङ्‌घोःसुम्‍बारो॥ कर आल्‍लग खे़ङ्‌हाॽरे़ लायो मे़न्‍जोःक्‍मनाबा लाम्‍सिङ्‌मा मे़ङ्‌घोःसुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","आत्तिल्‍ले़ इङ्‌गाॽ चिःत्ता, खे़ल्‍ले़ पानुदिङ् आम्‍बाआङ् चिःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","इङ्‌गाॽ वेॽहाॽरे़ चोःक्‍मा मे़न्‍छुक्‍तुन्‍बा याःम्‍बक् चोगुङ्॥ खे़ङ्‌हाॽरे़ खे़न् पाःन्‍हाॽ मे़न्‍निःसुन्‍निल्‍ले़ग खे़ङ्‌हाॽ लायोरे़ आप्‍तिक् के़घोःबा मे़म्‍बोःक्‍खे़म्‍बा वये़रो॥ कर खे़ङ्‌हाॽरे़ग निङ्‌वाॽ के़माबा मिक्‍सेःन् मे़निःसुआङ् मे़वाॽसाङ् पानुदिङ् आम्‍बा नु इङ्‌गाॽ ने़प्‍माङ् मे़जिःत्ते़त्‍छिगे़आङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","कर कङ्‌ग खे़ङ्‌हाॽरे़ थेनाधे मे़जिःत्ताङ्‌बारो लॽरिक् साम्‌योसाप्‍लाओ साप्‍ते़आङ् के़बप्‍पे़न्‌के़रे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","आल्‍ल पानुदिङ् पाःलाम् कुभाॽ के़बिबा सेसेमाङ्‌ङिन् खिनिॽओ पाङ्‌घुङ्‌लो॥ खुने़ॽग पानुदिङ् पाःलाम्‍बा के़युःबा से़क्‍खाओ लाम्‍गे़लोःबा सेसेमाङ्‌लो, खुने़ॽए इङ्‌गाॽ आयाःम्‍बेओ तोःन्‍दि के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","हे़क्‍क्‍याङ् खिनिॽआङ् इङ्‌गाॽ आयाःम्‍बेओ तोःन्‍दि के़बिरुम्‍लए पोःङ्‌लो थेआङ्‌भे़ल्‍ले़ खिनिॽग इङ्‌गाॽनु कुहेःक्‍सिङ्‌माआङ्धोए के़वयिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","ये़सुरे़ आल्‍लसाङ्‌मे़त्तुसि, “याप्‍मि नसाःन् चोःक्‍मा के़न्‍ले़रुम्‍मिन्‍ल फाॽआङ् तगिसा कन् पाःन्‍हाॽ मे़त्‍निङ्‌ल पत्तारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","खिनिॽ यहुदि चुम्‍लुङ्‌हिम्‍मोलाम् के़म्‍लःत्ति के़म्‍देःसिॽ॥ हे़क्‍क्‍याङ् अक्‍तङ्‌बा ये़म्‍माङ् तार पत्, मनाहाॽरे़ खिनिॽ के़म्‍से़रिल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिन् सेवा चोगुम्‍बार पत्‍छिगे़ लॽरिक् मे़इःत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","खे़ङ्‌हाॽरे़ पानुदिङ् पाःन् इग्र इङ्‌गाॽ याप्‍मि कुसिङ् मे़न्‍निःत्तान्‍बाल्‍ले़ चोगुल्‍ले़ खिनिॽ हे़क्‍के के़म्‍मे़त्तिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","कन् पाःन्‍हाॽ ताःन्‍दि खिनिॽओ के़त्तिल्‍ले़ इङ्‌गाॽ साम्‍दिङ् पिनिङ्‌बा पाःन्‍निन् खिनिॽ निङ्‌वाॽ के़इःत्तुम्‍ल फाॽआङ् अक्‍खे मे़त्‍निङ्‌ङाङ् वाॽआरो॥ तगिग कन् पाःन्‍हाॽ मे़मे़त्‍निङ्‌ङिन्‍लो थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽग खिनिॽनुए वयाङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“कर आल्‍ल इङ्‌गाॽ याप्‍मि के़बाङ्‌बाल्‍लो नुःङ्‌ङा पेःक्‍कार पत्ता हे़क्‍केसाङ् खिनिॽ आत्तिल्‍ले़आङ् आत्तान् के़बेःक्‍ल के़बप्‍पे फाॽआङ् इङ्‌गाॽ याप्‍मि सेःन्‍गे़न्‍दोःसिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","इङ्‌गाॽ हे़क्‍के पाःत्तुङ्‌बाल्‍ले़ खिनिॽ निङ्‌साम्‍मो के़ध्‍ये़ॽइआङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","कर इङ्‌गाॽ से़क्‍खाःन् मे़त्‍निङ्, इङ्‌गाॽग पेःक्‍काबान्‍ने खिनिॽ लागि नुःबा पोःङ्‌लो, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ मे़बेःक्‍कान्‍ने़ फाॽग्र कुभाॽ के़बिबा सेसेमाङ्‌ङिन् खिनिॽओ मे़युने़न्‍लो, कर इङ्‌गाॽ पेःक्‍काआङ् खुने़ॽ खिनिॽओ पाङ्‌घुङ् युःसुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","खुने़ॽ युःआङ् इक्‍सादिङ् खाम्‍बेःक्‍मोबा मे़न्‍छाम्‍गे़न् याप्‍मिहाॽरे़ खुनिॽ लायोरे़ कुयाःम्‍बेओ, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसाम्‌योनिमान् हे़क्‍क्‍याङ् कुघासे़न्‍निल्‍ले़ कुयाःम्‍बेओ पिर्बेःन् मे़इःत्तुबा पाःन्‍निन् ओसेःन्‍धाक्‍तुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","खे़ङ्‌हाॽरे़ इङ्‌गाॽ नसाःन् मे़न्‍जोःक्‍कान्‍बान्‍ने इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़न् लायोरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","इङ्‌गाॽ पानुदिङ् पाःल्‍लो पेःक्‍काबाल्‍ले़ साम्‌योनिबा के़बोःक्‍खिरो, हे़क्‍क्‍याङ्‌धो खिनिॽ याप्‍मि के़न्‍निःसिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","हे़क्‍क्‍याङ् कन् इक्‍सादिङ् खाम्‍बेःक्‍मोबा हाङ्‌युक् के़जोःक्‍पाल्‍ले़ कुघासे़न् पोःक्‍खे़आङ् वाॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","हे़क्‍क्‍याङ् इङ्‌गाॽग आल्‍लो खिनिॽ कुसिङ् के़निःत्तुम्‍बान्‍नुःल्‍ले़आङ् यरिक् पाःप्‍मा के़बोःङ्‌बा पाःन्‍हाॽ कत्तुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","कर से़क्‍खाओ लाम्‍गे़लोःबा सेसेमाङ्‌ङिन् युःआङ् काक् से़क्‍खाओ लाम्‍गे़लोःसिॽ हे़क्‍क्‍याङ् खुने़ॽग आबाङे कुबाःन्‍हाॽ थेआङ् मे़बाःत्तुन्‍लो, कर खे़प्‍सुबा पाःन्‍हाॽरक् खिनिॽ के़मे़त्तिॽ हे़क्‍क्‍याङ् ताःन्‍दि के़बोःङ्‌बा पाःन्‍हाॽ के़मे़त्तिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","खुने़ॽग आबाःन्‍हाॽ इङ्‌गाॽलाम् खोःसुआङ् खिनिॽ के़मे़त्तिल्‍ले़ आमिमिदिङ् चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","काक् पानुदिङ् पाःल्‍ले़ कुबाःन्‍हाॽ इङ्‌गाॽइन्‍लो, खे़ल्‍ले़ चोगुल्‍ले़ सेसेमाङ्‌ङिल्‍ले़ इङ्‌गाॽलाम्‍मे पाःन्‍हाॽ तेॽरुआङ् खिनिॽ के़मे़त्तिॽरो फाॽआङ् पाःत्तुङ्‌बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","ये़सुरे़ कुहुॽसाम्‍बाहाॽ मे़त्तुसि, “सप्‍फाआङ् इङ्‌गाॽ याप्‍मि के़न्‍निःसिन्‍लो, कर याङ्‌सि सप्‍फाआङ्‌ग याम्‍मो याप्‍मि के़निःसिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","हे़क्‍केःल्‍ले़ कुहुॽसाम्‍बाहाॽ अक्‍खे मे़मे़त्‍छिङ्, “आनिॽ दाङ्‌बाल्‍ले़ सप्‍फाआङ् इङ्‌गाॽ याप्‍मि आगे़न्‍निःसिन् कर याङ्‌सि सप्‍फाआङ् याम्‍मो याप्‍मि के़निःसिॽरो लॽरिक् थे़मा पाःत्तुबाबे? पानुदिङ् पाःल्‍लो पेःक्‍कार पत्ता लॽरिक् थे पाःत्तुबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","याङ्‌सि सप्‍फाआङ् लॽरिक् खुने़ॽ थे पाःत्तुबाइ? आनिॽ थेआङ् कुसिङ् आन्‍निःत्तुम्‍मिन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ये़सुरे़ कुहुॽसाम्‍बाहाॽरे़ कुभा पाःन् सेःन्‍दोःमा निङ्‌वाॽ मे़जोगुआङ् वाॽ लॽरिक् निङ्‌वाॽ खोःसुआङ् खे़ङ्‌हाॽ मे़त्तुसि, “सप्‍फाआङ् इङ्‌गाॽ याप्‍मि के़न्‍निःसिन्‍लो, कर याङ्‌सि सप्‍फाआङ् याम्‍मो याप्‍मि के़निःसिॽरो लॽरिक् पाःत्तुङ्‌बाओ खिनिॽ सेःन्‍गे़दोःआसिर के़बत्‍छिबि? ");
INSERT INTO lifNT2_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, खिनिॽ के़हाबिॽ, मेरिङ् के़धक्‍तिॽ, कर इक्‍सादिङ् खाम्‍बेःक्‍मोबाहाॽग मे़सःत्‍लो॥ खिनिॽ मेरिङ् के़धक्‍तिॽ, कर खिनिॽ मेरिङ् थक्‍माङ्‌ग सःप्‍माओ ले़ङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","खे़न् ये़म्‍मिङ्‌ग सावाःन्‍दुङ्‌ङिल्‍ले़ याङ्‌घुबा मे़न्‍छुमाॽइन् कुइसिःक् पोःङ्‌लो॥ कुस्‍साःन् सावाःन्‍दु सुरुआङ् काक् सावाःन्‍दुङ्‌ङिन् निङ्‌वाॽ फेःत्‍छुॽरो, थेआङ्‌भे़ल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मो अङे़ःक्‌वाधिक् सावाःन्‍दुबाओ सःत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","खिनिॽ लागिआङ् बा हे़क्‍के पोःङ्–आल्‍लोग मेरिङ् के़धक्‍तिॽ, कर इङ्‌गाॽ याम्‍मो खिनिॽ तुम्‍से़ ताआल्‍ले़ खिनिॽ के़सःत्तिॽरो हे़क्‍क्‍याङ् आत्तिल्‍ले़आङ् खिनिॽ सःप्‍मान् नाप्‍माआङ् तेॽमा के़न्‍छुक्‍तिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","खे़न् ये़न्‍नो खिनिॽ थेआङ् याप्‍मि सेःन्‍गे़न्‍दोःसिन्‍लो॥ इङ्‌गाॽ से़क्‍खाए मे़त्‍निङ्, आमिङ्‌ङो थे के़नाःक्‍तुम्‍साङ् पानुदिङ् आम्‍बारे़ के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","आल्‍लो थारिक् अक्‍खेलॽरिक् आमिङ्‌ङो थेआङ् मे़न्‍नाःक्‍के के़वयिॽरो॥ खिनिॽ नाःक्‍ते़म्‍मे़ॽ हे़क्‍क्‍याङ् के़घोःसुम्‍माङ् के़सःत्तिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","आल्‍लोग इङ्‌गाॽ पाःम्‍फ्रे़म्‍मो पाःत्तार वाॽआसाङ् ताःन्‍दि के़दाःबा ये़म्‍मोग अक्‍खेलॽरिक् मे़बाःत्तान्‍लो, कर आम्‍बारे़ कुयाःम्‍बेओ कुदोःप्‍माए मे़त्‍निङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","खे़न् ये़म्‍मो खिनिॽए इङ्‌गाॽ आमिङ्‌ङो के़नाःक्‍तुम्‍लो॥ इङ्‌गाॽ खिनिॽ लागि पानुदिङ् पाःन् नाःक्‍तुङ् पिनिङ् फाॽआङ् मे़बाःत्तान्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","इङ्‌गाॽ निङ्‌वाॽफुमाङ्‌लाम् त्‍याङ्‌बान् खिनिॽ नसाःन् के़जोगुम् हे़क्‍क्‍याङ् याप्‍मि मिःम्‍जि के़मे़त्तिबाल्‍ले़ चोगुल्‍ले़ पानुदिङ् पाःल्‍ले़ आबाङे खिनिॽ लुङ्‌माॽ के़दुक्‍तिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","इङ्‌गाॽ निङ्‌वाॽफुमाङ्‌लाम् इक्‍सादिङ् खाम्‍बेःक्‍मो त्‍याङ्‌बारो॥ आल्‍लोग इङ्‌गाॽ याम्‍मो इक्‍सादिङ् खाम्‍बेःक्‍मान् ले़रुङ्‌ङाङ् पानुदिङ् पाःल्‍लो नुःङ्‌ङा पेःक्‍कार पत्तारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","हे़क्‍क्‍याङ् ये़सुःन् कुहुॽसाम्‍बाहाॽरे़ मे़मे़त्तु, “आल्‍लोग खे़ने़ॽ पाःन्‍फ्रे़म्‍मिन् ओगप् मे़न्‍जोःक्‍के कुदोःप्‍मो के़बाःत्‍ल के़बत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","आल्‍लो खे़ने़ॽ काक् पाःन्‍हाॽ के़निःसु फाॽआङ् आनिगे़ कुसिङ्‌निःत्तुम्‍बारो॥ आत्तिल्‍ले़आङ् थेआङ् सेःन्‍दोःमा मे़बोःङ्‌ने़न्, थेआङ्‌भे़ल्‍ले़ सेःन्‍दोःमानुःल्‍ले़ तगि खे़ने़ॽ के़निःसुॽरो॥ बा कन् पाःन्‍नो खे़ने़ॽ निङ्‌वाॽफुमाङ्‌लाम् के़द्‌ये़बा फाॽआङ् आनिगे़ नसाःन् चोगुम्‍बारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ये़सुरे़ खे़ङ्‌हाॽ नोगप् पिरुसि, “ए़, खिनिॽ से़क्‍खाए आल्‍लो नसाःन् के़जोगुम्‍बि? ");
INSERT INTO lifNT2_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","कर आल्‍ल खिनिॽ काक् से़ःमाआङ् आबाङे हिम्हिम् पेःक्‍मा ये़म् तार पत्‍लो॥ हे़क्‍क्‍याङ् खे़न् ये़म्‍मिङ्‌ग त्‍ये़ चुरे़आङ् वाॽरो॥ आल्‍ल खिनिॽ के़रे़क्‍ले़ याप्‍मि के़ले़रिआङ् के़बिगिॽरो हे़क्‍केसाङ् इङ्‌गाॽ एःक् होःप्‍पारो, कर इङ्‌गाॽनु आम्‍बाआङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","इङ्‌गाॽओ खिनिॽ सनारुङ् के़घोःसुम्‍लरो फाॽआङ् कन् के़रे़क् पाःन्‍हाॽ मे़त्‍निङ्‌ङाङ् वाॽआरो॥ कन् इक्‍सादिङ् खाम्‍बेःक्‍मो यरिक् इनोगे़न् तुक्‍खेहाॽ के़दुमुम्‍लो॥ कर हाङ्‌हाङ् लॽरे़म्‍मे़ॽओ, थेआङ्‌भे़ल्‍ले़ इङ्‌गाॽ कन् इक्‍सादिङ् खाम्‍बेःक्‍मान् नाःन्‍दुङ्‌ङाङ् वाॽआरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ये़सुरे़ कन् पाःन्‍हाॽ पाःत्तु सुरुआङ् साङ्‌ग्राम्‍पेदाङ् ले़प्‍माङ् ओमये़र तुवा चोगु, “पानुदिङ् आम्‍बे, आल्‍ल ये़म् पोःक्‍खे़रो, के़स्‍साःल्‍ले़ खे़ने़ॽ के़मिमिदिङ् चोगुर फाॽआङ् खुने़ॽ कुमिमिदिङ् चोगे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","खे़ने़ॽ के़स्‍साःन् के़बिरुबा मनाहाॽ मे़न्‍नुप्‍मनाबा हिङ्‌मन् पिरुसिर फाॽआङ् इक्‍सादिङ् खाम्‍बेःक्‍मोबा काक् मे़न्‍छाम् सुवाङ् सम्‍दाङ् खुने़ॽ युक् के़बिरुआङ् के़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","खे़ङ्‌हाॽरे़ से़क्‍खागे़न् निङ्‌वाॽफुमाङ्‌ङिन् खे़ने़ॽरक् फाॽआङ् कुसिङ् मे़निःत्तुर हे़क्‍क्‍याङ् खे़ने़ॽ के़बाङ्‌घुबा ये़सु ख्रिस्‍ते़न्‌कुसिङ् मे़निःत्तुर बा खे़न्‍ने मे़न्‍नुप्‍मनाबा हिङ्‌मन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","खे़ने़ॽ चोःक्‍मा के़बाङ्‌घाङ्‌बा काक् पाःन्‍हाॽ चोगुङ्‌सुरुङ्‌, हे़क्‍क्‍याङ् इङ्‌गाॽ इक्‍सादिङ् खाम्‍बेःक्‍मो के़मिमिदिङ् चोगुङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","पानुदिङ् आम्‍बे, इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ तोलिङ्‌सोमु पोःङ्‌मानुःल्‍ले़ तगिआङ्धो खे़ने़ॽनु वयाङ्‌ङिल्‍ले़ इङ्‌गाॽ कत्तुङ्‌बा मिमिदिङ्‌ङिल्‍ले़ खे़ने़ॽ के़दगि आमिङ्‌सो इङ्‌धाःङ् चोगे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","कन् इक्‍सादिङ् खाम्‍बेःक्‍मोलाम् इङ्‌गाॽ के़बिराङ्‌बा मनाहाॽ खे़ने़ॽ के़याःम्‍बेओ मे़त्तुङ्‌सिङ्‌ङाङ् वाॽआरो॥ खे़ङ्‌हाॽग सदादिङ् खे़ने़ॽइन्‍ने मे़वये़॥ खे़न् के़बिराङ्‌बा मनाहाॽरे़ खे़ने़ॽ के़बाःन्‍जाक्‍किन् मे़इःत्तु मे़नाःत्तुआङ् मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","आल्‍ल खे़ङ्‌हाॽरे़ इङ्‌गाॽ के़बिराङ्‌बा काक् पाःन्‍हाॽ खे़ने़ॽलाम्‍बाए त्‍ये़बा फाॽआङ् मे़निःसुआङ् मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","खे़ने़ॽ के़बिराङ्‌बा काक् पाःन्‍हाॽ खे़ङ्‌हाॽ पिरुङ्‌सिङ्‌ङाङ् मे़वाॽ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़आङ् मे़दाःक्‍तुआङ् मे़वाॽरो॥ खे़ङ्‌हाॽरे़ इङ्‌गाॽ खे़ने़ॽलाम् त्‍याङ्‌बा फाॽआङ् से़क्‍खाए मे़निःसुआङ् मे़वाॽ हे़क्‍क्‍याङ् इङ्‌गाॽ के़बाङ्‌घाङ्‌बान् नसाःन् मे़जोगुआङ् मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","खे़ङ्‌हाॽरे़ लागि इङ्‌गाॽ तुवा चोःक्‍का, कर इक्‍सादिङ् खाम्‍बेःक्‍मोबा के़रे़क् मनाहाॽरे़ लागिग मे़जोःक्‍कान्‍लो॥ खे़ने़ॽ के़बिराङ्‌बाहाॽरे़ खुनिॽ लागिरक् तुवा चोःक्‍का, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽग के़मनासिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","इङ्‌गाॽ कत्तुङ्‌सिङ्‌बा काक् मनाहाॽग खे़ने़ॽइन्‍छिरो हे़क्‍क्‍याङ् खे़ने़ॽ के़गत्तुसिबा मनाहाॽग इङ्‌गाॽइन्‍छिरो॥ खे़ङ्‌हाॽओ आमिमिदिङ् पोःक्‍खे़आङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","आल्‍ल कन् इक्‍सादिङ् खाम्‍बेःक्‍मोलाम् खे़ने़ॽओ थो थाङ्‌ङार पत्तारो॥ इङ्‌गाॽ इक्‍सादिङ् खाम्‍बेःक्‍मो मे़वाॽआन्, कर खे़ङ्‌हाॽग कप्‍मोए मे़वाॽरो॥ हे़क्‍केःल्‍ले़ सेसे पानुदिङ् आम्‍बे, खे़ङ्‌हाॽग के़बिराङ्‌बा मुक्‍साम्‍गे़न् के़मिङ्‌ङो कम्‍ब्राङ् मे़त्ते़से़ॽओ॥ हे़क्‍केलॽरिक् आन्‍छिॽ थिक् आवाॽसिबा कुइसिःक्‍के खे़ङ्‌हाॽआङ् थिक्‍हुप् मे़बोःङ्‌लरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","इङ्‌गाॽ कप्‍मो वयाङ्‌ल थारिक् खे़न् मिङ्‌ङिल्‍ले़न् मुक्‍साम्‍मो काक् कम्‍ब्राङ् मे़त्तुङ्‌सिङ्‌लो॥ खे़न् मे़क्‍मा के़बोःङ्‌बान्‍नाङ् थो वेॽ आत्तिन्‍नाङ् मे़माःसुङ्‌ङिन्, कर काक् ताङ्‌से़ःप्‍तुङ्‌सिङ्‌लो॥ खे़ङ्‌ग साम्‌योसाप्‍लाःन् के़त्‍ल फाॽआङ् हे़क्‍के पोःक्‍खे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","आल्‍ल इङ्‌गाॽ खे़ने़ॽओ थाङ्‌ङार पत्तारो॥ इङ्‌गाॽ कत्तुङ्‌बा आयाम्‍नाःम्‍मिन् खे़ङ्‌हाॽरे़आङ् मे़घोःसुर फाॽआङ् इक्‍सादिङ् खाम्‍बेःक्‍मो वाॽआल्‍ले़ कन् पाःन्‍हाॽ पाःत्तुङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","खे़ङ्‌हाॽ पेलिगे़न् के़बाःन्‍जाक्‍हाॽ पिरुङ्‌सिङ्‌ङाङ् मे़वाॽरो॥ इङ्‌गाॽ कुइसिःक्‍के खे़ङ्‌हाॽआङ् इक्‍सादिङ् खाम्‍बेःक्‍मोबा मे़ःन्‍छिबाल्‍ले़ चोगुल्‍ले़ इक्‍सादिङ् खाम्‍बेःक्‍मोबाहाॽरे़ खे़ङ्‌हाॽ मे़जिःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","खे़ङ्‌हाॽ इक्‍सादिङ् खाम्‍बेःक्‍मोलाम् तेॽरे़से़ॽ फाॽआङ् पेलिगे़न् तुवा मे़जोःक्‍कान्, कर कुॽइगे़भे़ॽबा माफे़न्‍साम्‍मोलाम् खे़ङ्‌हाॽ ताङ्‌से़ःप्‍ते़से़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","इङ्‌गाॽ कुइसिःक् खे़ङ्‌हाॽआङ् इक्‍सादिङ् खाम्‍बेःक्‍मोबा मे़ःन्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","खे़ङ्‌हाॽ से़क्‍खाःल्‍ले़ सेसे साङ्‌साङ् चोगे़से़ॽओ॥ खे़ने़ॽ पेलिगे़न् के़बाःन्‍जाक्‍किङ्‌ग से़क्‍खारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","इक्‍सादिङ् खाम्‍बेःक्‍मो इङ्‌गाॽ के़बाङ्‌घाङ्‌बा कुइसिःक्‍के इङ्‌गाॽआङ् खे़ङ्‌हाॽ इक्‍सादिङ् खाम्‍बेःक्‍मो पाङ्‌घुङ्‌सिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","खे़ङ्‌हाॽ से़क्‍खाए सेसे साङ्‌साङ् मे़बोःङ्‌ल फाॽआङ् इङ्‌गाॽ खे़ङ्‌हाॽरे़ खुनिॽ लागि सेसे साङ्‌साङ् चोःक्‍सिङ्‌ङारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","इङ्‌गाॽग खे़ङ्‌हाॽरे़ खुनिॽ लागिरक् मे़ःन्, कर खे़ङ्‌हाॽरे़ इङ्‌भन् मे़जोगुबालाम् इङ्‌गाॽओ नसाःन् के़जोःक्‍पाहाॽरे़ खुनिॽ लागिआङ् तुवा चोःक्‍कारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","पानुदिङ् आम्‍बे, खे़ङ्‌हाॽ काक् थिक्‍हुप् मे़बोःङ्‌ल फाॽआङ् तुवा चोःक्‍कारो॥ इङ्‌गाॽ खे़ने़ॽओ हे़क्‍क्‍याङ् खे़ने़ॽ इङ्‌गाॽओ के़वाॽबा कुइसिःक् खे़ङ्‌हाॽआङ् आन्‍छिॽओ मे़वाॽररो॥ हे़क्‍क्‍याङ् इक्‍सादिङ् खाम्‍बेःक्‍मोबा मनाहाॽरे़ इङ्‌गाॽ के़बाङ्‌घाङ्‌बा फाॽआङ् नसाःन् मे़जोगुररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","आन्‍छिॽ कुइसिःक् खे़ङ्‌हाॽ थिक्‍हुप् मे़बोःङ्‌ल फाॽआङ् खे़ने़ॽ के़बिराङ्‌बा मिमिदिङ्‌ङिन् खे़ङ्‌हाॽ पिरुङ्‌सिङ्‌ङाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","इङ्‌गाॽ खे़ङ्‌हाॽनु थिक्‍हुप् वाॽआबा कुइसिःक् हे़क्‍क्‍याङ् खे़ने़ॽ इङ्‌गाॽनु थिक्‍हुप् के़वाॽबा कुइसिःक् खे़ङ्‌हाॽ कुजे़क् थिक्‍हुप्‍पो मे़दाररो॥ हे़क्‍क्‍याङ् इक्‍सादिङ् खाम्‍बेःक्‍मोबा मनाहाॽरे़ इङ्‌गाॽ के़बाङ्‌घाङ्‌बा नु लुङ्‌माॽ के़दुक्‍ताङ्‌बा कुइसिःक्‍के खे़ङ्‌हाॽ लुङ्‌माॽ के़दुक्‍तुसिबान् कुसिङ् मे़निःत्तुररो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","पानुदिङ् आम्‍बे, इङ्‌गाॽ के़बिराङ्‌बाहाॽ इङ्‌गाॽनुए सोरिक् मे़वाॽर के़लॽबा निङ्‌वाॽ चोगुङ्‌लो॥ हे़क्‍केलॽरिक् खे़ङ्‌हाॽरे़ इङ्‌गाॽ के़बिराङ्‌बा मिमिदिङ्‌ङिन् मे़निःसुॽरो॥ खे़ने़ॽ इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ नावागे़न् चइःत् ने़मानुःल्‍ले़ तगिए इङ्‌गाॽ लुङ्‌माॽ के़दुक्‍ताङ्‌बाल्‍ले़ चोगुल्‍ले़ खे़न् मिमिदिङ्‌ङिन् के़बिराङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","साम्‌योनिबा आम्‍बे, इक्‍सादिङ् खाम्‍बेःक्‍मोबा मनाहाॽरे़ खे़ने़ॽ कुसिङ् के़मे़न्‍निःत्‍ने़न्‍छाङ् इङ्‌गाॽ कुसिङ् निःत्‍ने़ॽ हे़क्‍क्‍याङ् इङ्‌गाॽ के़बाङ्‌घाङ्‌बा पाःन्‍निन् कङ्‌हाॽरे़ कुसिङ् मे़निःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","इङ्‌गाॽ लुङ्‌माॽ के़दुक्‍ताङ्‌बा लुङ्‌माॽ तुक्‍मे़न्‌खुनिॽनुआङ्‌वाॽर हे़क्‍क्‍याङ् इङ्‌गाॽआङ् खे़ङ्‌हाॽओ वाॽआर फाॽआङ् खे़ने़ॽ के़याःम्‍बेओ कङ्‌हाॽ मे़त्तुङ्‌सिङ्‌ङाङ् वाॽआ हे़क्‍क्‍याङ् आल्‍लसाङ् याम्‍मो मे़त्तुङ्‌सिङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ये़सुरे़ अक्‍खेलॽरिक् तुवा चोगु सुरुआङ् कुहुॽसाम्‍बाहाॽनु किद्रोन मे़प्‍मनाबा हङ्‌हङ्वाःल्‍ले़ नाधाःम्‍बि पेरो॥ खे़प्‍मो जैतुन सिङ्‌ला थिक् ने़स्‍से़ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ खे़प्‍मो मे़लाःसे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","खुने़ॽ इङ्‌ले़क् के़मे़प्‍पा यहुदाःल्‍ले़आङ् खे़न् ते़न्‍निन् निःसुआङ् वये़, थेआङ्‌भे़ल्‍ले़ ये़सुरे़ कुहुॽसाम्‍बाहाॽ यरिक्‍ले़ङ् खे़प्‍मो तुमुसिआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","खे़ल्‍ले़ चोगुल्‍ले़ यहुदाःल्‍ले़ कुभा रोमि थक्‍सुबाहाॽ हे़क्‍क्‍याङ् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु फरिसिहाॽरे़ मे़बाङ्‌घुसिबा माङ्‌हिम् के़गोःबा तिलिङ्‌गाहाॽ खे़न् जैतुन सिङ्‌लाओ लाम्‍लोसुसिआङ् तारुसिरो॥ खे़ङ्‌हाॽरे़ तियालो, सेमि नु फे़जुम् फे़याहाॽ मे़गत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ये़सुरे़ आल्‍ल खुने़ॽनु थे पोःङ् के़लॽबान् काक् निःसुआङ् खुने़ॽ तगि पेआङ् खे़ङ्‌हाॽ सेःन्‍दोसुसि, “खिनिॽ हाःत् के़गोःत्तुम्‍बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “नासरतबा ये़सुःन्॥” ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खे़ङ्‌ग इङ्‌गाॽएरो॥” खे़न् ये़म्‍मो खुने़ॽ इङ्‌ले़क् के़मे़प्‍पा यहुदाःन्‍नाङ् खे़ङ्‌हाॽनु सोरिक् ये़बे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ये़सुरे़ खे़ङ्‌हाॽ “खे़ङ्‌ग इङ्‌गाॽएरो” मे़त्तुसिल्‍ले़ खे़ङ्‌हाॽ एगाङ् मे़जत्‍छिङ्‌ल ले़राङ्‌काक्‍पे़त् खाम्‍मो मे़ले़क्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","याम्‍मो ये़सुरे़ खे़ङ्‌हाॽ सेःन्‍दोसुसि, “खिनिॽ हाःत् के़गोःत्तुम्‍बाबे?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “नासरतस्‍मा ये़सुःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ये़सुरे़ नोगप् पिरुसि, “इङ्‌गाॽआरो फाॽआङ् मे़त्‍निङ्‌लो॥ खिनिॽ के़गोःत्तुम्‍बा मनाःङ्‌ग इङ्‌गाॽने़ फाॽग्र कङ्‌हाॽग पेःक्‍मा पाङ्‌घे़म्‍सिम्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","के़बिराङ्‌बाहाॽओ थिक्‍काङ् मे़माःसुङ्‌ङिन्‍लो लॽरिक् ये़सुरे़ आबाङे पाःत्तुबा पाःन्‍निन् के़त्‍ल फाॽआङ् कन् अक्‍खे पोःक्‍खे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","हे़क्‍क्‍याङ् सिमोन पत्रुसरे़ ताभेःन् तरप् फिःक्‍खुआङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुसेवारोबा माल्‍खस मे़प्‍मनाबाल्‍ले़ कुजुप्‍साङ् ले़प्‍माङ्‌बा कुने़क्‍खोॽबान् पे़त्तु थाःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ये़सुरे़ पत्रुसे़न् मे़त्तु, “के़दाभेःन् फे़सिःप्‍पो याक्‍ते़ॽ! पानुदिङ् आम्‍बारे़ इङ्‌गाॽ पिआबा इनोगे़न् तुक्‍खेवा खोर्याओलाम् थुङुङ्‌लए पोःङ्॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","हे़क्‍केलॽरिक् थक्‍तुम्‍बा नु थक्‍सुबाहाॽरे़ हे़क्‍क्‍याङ् माङ्‌हिम्‍मोबा तिलिङ्‌गाहाॽरे़ ये़सुःन् मे़दे़म्‍सुआङ् इमे़घेःक्‍खु, ");
INSERT INTO lifNT2_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","हे़क्‍क्‍याङ् खे़न् तङ्‌बेबा मानिङ्‌वाॽफुसाम्‍बा कैयाफासरे़ कुन्‍नोःप्‍पा हन्‍नासरे़ कुहिम्‍मो मे़देॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","बा कन् कैयाफासरे़ए काक् मनाहाॽरे़ खुनिॽ ले़क्‌वा थिक् मनाःन् सिःमाए नुःबा पोःङ् लॽरिक् यहुदिहाॽ मे़त्तुसिआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","सिमोन पत्रुस नु वेॽ कुहुॽसाम्‍बाधिक्‍ले़ ये़सुःन् तिम्‍दे़त्‍छुरो॥ खे़न् वेॽ हुॽसाम्‍बाल्‍ले़ मानिङ्‌वाॽफुसाम्‍बान् कुसिङ् निःत्तुआङ् वये़बाल्‍ले़ चोगुल्‍ले़ ये़सुःन् तिम्‍दुर मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुलक्‍खुम्‍मो थारिक् के़रे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","कर पत्रुसरे़ लाःक्‍कात् खुने़ॽ हाङ्‌घुर ये़बे़॥ खे़न् मानिङ्‌वाॽफुसाम्‍बान् कुसिङ् के़निःप्‍पा हुॽसाम्‍बान् सिगाङ्‌लाम् नुःक्‍खे़ फे़रे़आङ् लाम्‍धेःप् के़गोःमा सेवारोमान् मे़त्तुआङ् पत्रुसे़न् सिगाङ् तेॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","खे़न् सेवारोमाल्‍ले़ पत्रुसे़न् मे़त्तु, “खे़ने़ॽआङ् खे़न् मनाःल्‍ले़ कुहुॽसाम्‍बाहाॽओ थिक् मे़ःन्‍ने़बि?” पत्रुसरे़ नोगप् पिरु, “इङ्‌गाॽ मे़ःन्‍नाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","साॽरिक् चुङ्‌जिःक्‍ते़बाल्‍ले़ चोगुल्‍ले़ सेवारोबाहाॽ नु माङ्‌हिम् के़गोःबा तिलिङ्‌गाहाॽरे़ मि मे़दुप्‍तुआङ् खिरि मिजाॽनु मे़ये़बे़रो॥ पत्रुसे़न्‍नाङ् खुनिॽ पेसाङ् मिजाॽनु ये़बे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","आल्‍ल हिम्‍सिगाङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ ये़सुःन् खुने़ॽ कुहुॽसाम्‍बाहाॽ नु कुनिसाम्‍मिल्‍ले़ कुयाःम्‍बेओ सेःन्‍दोसुर यागे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ये़सुरे़ नोगप् पिरु, “इङ्‌गाॽग काक्‍ले़ मे़घे़प्‍सुरए पाःराङ्‌लो, इङ्‌गाॽग काक् यहुदिहाॽ मे़जुम्‍बा यहुदि चुम्‍लुङ्‌हिम्‍मो नु माङ्‌हिम्‍मो मनाहाॽ सदादिङ् हुॽरुङ्‌सिङ्‌ल वाॽरो॥ इङ्‌गाॽ स्‍वाःत्ताङ् थेआङ् मे़म्‍बाःप्‍पे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","हे़क्‍केःल्‍ले़ थेआङ् अक्‍खेलॽरिक् याप्‍मि सेःन्‍गे़दोःसिबे? इङ्‌गाॽ पाःत्तुङ्‌बा के़घे़म्‍बाहाॽए सेःन्‍दोःसे़म्‍सिम्‍मे़ॽओ थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ इङ्‌गाॽ पाःत्तुङ्‌बा पाःन्‍हाॽ से़क्‍खाए मे़घे़प्‍सुआङ् मे़वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ये़सुरे़ हे़क्‍के पाःत्तुल्‍ले़ खे़प्‍मो निःत्ताङ् के़ये़प्‍पा सुहाङ्‌युक्‍पाधिक्‍ले़ ये़सुरे़ कुने़दे़ङ्‌बान् ले़क्‍खुआङ् मे़त्तु, “अक्‍खेलॽरिक् मानिङ्‌वाॽफुसाम्‍बान्‍नु मुरा के़दोःबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ये़सुरे़ नोगप् पिरु, “इङ्‌गाॽ पाःन् फेःन्‍दुङ्‌ने़ फाॽग्र पाःत्ते़ॽ॥ कर इङ्‌गाॽ से़क्‍खा पाःन् पाःत्तुङ्‌ङाङ् वाॽआने़ फाॽग्र थेआङ् के़हिप्‍पाबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","हे़क्‍क्‍याङ् हन्‍नासरे़ ये़सुःन् इमे़घेःक्‍खुबान् मे़म्‍भाःङ्‌ङे मानिङ्‌वाॽफुसाम्‍बा कैयाफासरो पाङ्‌घुदेःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","सिमोन पत्रुसे़न् मिजाॽनु ये़बे़ल्‍ले़ कुभारे़ सेःन्‍मे़दोसु, “खे़ने़ॽआङ् खे़ल्‍ले़ कुहुॽसाम्‍बाहाॽओ थिक् मे़ःन्‍ने़बि?” पत्रुसरे़ खे़न् पाःन्‍निन् नाॽरुर मे़त्तु, “इङ्‌गाॽ मे़ःन्‍नाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","पत्रुसरे़ ने़क्‍खोॽबान् पे़त्तु थाःसुबा मनाःल्‍ले़ कुगाॽइ मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ वेॽस्‍मा कुसेवारोबाधिक्‍काङ् खे़प्‍मो ये़बे़॥ खे़ल्‍ले़ पत्रुसे़न् मे़त्तु, “खे़ने़ॽ जैतुन सिङ्‌लाओ ये़सुःन्‍नु के़वये़बा निःने़बा मे़ःम्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","पत्रुसरे़ याम्‍मो मे़ःन्‍लो लॽरिक् पाःत्तुल्‍ले़ बा खे़न् ये़म्‍मोए इङ्‌वा काःसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","यहुदि लाम्‍लोःबाहाॽरे़ ये़सुःन् तानाम्‍सा कैयाफासरे़ कुहिम्‍मोलाम् रोमि सुहाङ्‌गे़म्‍बाल्‍ले़ कुहाङ्‌हिम्‍मो मे़देॽरु॥ कर साम्‌योथिम् कुइसिःक् आसुत्‍थो आबोःङ्‌ङाङ् यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍बा चा चामा खोःमे़दे़त्‍ने़न् फाॽआङ् खे़ङ्‌हाॽ हिम् सिगाङ् मे़न्‍लाःसे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","हे़क्‍केःल्‍ले़ सुहाङ्‌गे़म्‍बा पिलातसरे़ लाःक्‍कात् लःन्‍दे़आङ् मे़त्तुसि, “कन् मनाःल्‍ले़ कुदक्‍ले़ङ्‌वाओ थे आप्‍तिक् के़दाःरुम्‍माङ् के़वयिॽबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “कन् मनाःल्‍ले़ याःम्‍बक् मे़म्‍भेःन्‍ने वये़ल्‍ले़ग खे़ने़ॽओ मे़दारुम्‍बे़न् मे़न्॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","हे़क्‍केःल्‍ले़ पिलातसरे़ खे़ङ्‌हाॽ मे़त्तुसि, “कन् मनाःन् तेॽरे़म्‍मे़ॽआङ् खिनिॽ साम्‌योथिम् कुइसिःक् खासे़न् लोःन्‍दे़म्‍मे़ॽ॥” हे़क्‍केःल्‍ले़ यहुदि लाम्‍लोःबाहाॽरे़ खुने़ॽ मे़मे़त्तु, “आनिगे़ग आत्तिन् मनाःन्‍नाङ् सिःमे़ल्‍ले़न् खुम्‍दिङ् पिमा युक् मे़गत्तुम्‍बे़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","कङ्‌ग ये़सुरे़ खुने़ॽ आक्‍तङ्‌बा सिःमे़ल्‍ले़ सिः लॽरिक् पाःत्तुबा पाःन्‍निन् के़त्‍ल फाॽआङ् अक्‍खे पोःक्‍खे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","पिलातसे़न् याम्‍मो हाङ्‌हिम् सिगाङ् लाःसे़आङ् ये़सुःन् उःत्तुआङ् सेःन्‍दोसु, “से़क्‍खा खे़ने़ॽ यहुदि हाङ्‌ने़बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ये़सुरे़ नोगप् पिरु, “खे़ने़ॽ कन् पाःन्‍निन् आबाङे के़निङ्‌वाॽइल्‍ले़ के़बाःत्तुबाबि, इ वेॽ मनाहाॽरे़ इङ्‌गाॽ आयाःम्‍बेओ के़म्‍मे़त्ते़बाबि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातसरे़ नोगप् पिरु, “इङ्‌गाॽ यहुदिआबि? आबाङे के़याप्‍मिहाॽ नु तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ खे़ने़ॽ हुक्‍मे़सुप्‍ताङ्‌ङाङ् वाॽ॥ खे़ने़ॽ थे याःम्‍बक् के़भेःन्‍दु?” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ये़सुरे़ मे़त्तु, “इङ्‌गाॽ आहाङ्‌जुम्‍मिङ्‌ग कन् इक्‍सादिङ् खाम्‍बेःक्‍मोबा मे़ःन्‍लो॥ कप्‍मोबा वये़ल्‍ले़ग इङ्‌गाॽ आसेवारोबाहाॽरे़ इङ्‌गाॽ याप्‍मि ते़म्‍मा मे़ङ्‌घोःआन्‍ल फाॽआङ् यहुदिहाॽनु थङ् मे़जोगुबामे़न्‌, कर आहाङ्‌जुम्‍मिन् कप्‍मोबा मे़ःन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पिलातसरे़ मे़त्तु, “हे़क्‍केने़ फाॽग्र खे़ने़ॽ हाङ्‌ने़बि?” ये़सुरे़ नोगप् पिरु, “इङ्‌गाॽ हाङ्‌आ फाॽआङ् खे़ने़ॽए के़बाःत्तुॽरो॥ कन्‌इक्‍सादिङ् खाम्‍बेःक्‍मो से़क्‍खाःल्‍ले़न् तोःन्‍दि पिसे़ इङ्‌गाॽ सावाःन्‍छिङाङ्बारो॥ से़क्‍खाओ के़बप्‍पाहाॽरे़ इङ्‌गाॽ आबाःन्‍निन् मे़घे़प्‍सुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातसरे़ सेःन्‍दोसु, “से़क्‍खाःङ्‌ग थे़माःन्बे?” खे़ल्‍ले़ हे़क्‍के पाःत्तुर लाःक्‍कात् लःन्‍दे़आङ् यहुदिहाॽ अक्‍खे मे़त्तुसि, “कन् मनाःल्‍ले़ कुदक्‍ले़ङ्‌वाओ थेआङ् आप्‍तिक् मे़ङ्‌घोःबान्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","कर यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मो खिनिॽ लागि पुङ्‌लाहिम्‍मो साक्‍पा के़धाःबाधिक् ले़रुङ् पिनिङ्‌बा थिम् के़गत्तुम्, हे़क्‍केःल्‍ले़ यहुदि हाङ्‌ङिन् ले़रुङ् पिनिङ्‌बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","खे़ङ्‌हाॽरे़ मे़अःक्‍ते़र मे़मे़त्तु, “मे़ःन्! खे़न् मे़ःन्! बरब्‍बासे़न ले़रे़ आबिरे़ॽ!” (आल्‍ल बरब्‍बासे़ङ्‌ग हाङ्‌बिफ्‍युङ्‌बा वये़रो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","हे़क्‍क्‍याङ् पिलातसरे़ ये़सुःन् साॽरिक् ते़ःम्‍भुक् याक्‍पाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","थक्‍सुबाहाॽरे़ तिङ्‌ग्रेःक्‍ले़न् तिचः मे़भयुआङ् ये़सुःन् मे़घुःक्‍तु॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुने़ॽ परान्‍ला हाङ्‌तेःत्तिन् मे़जाक्‍तुर ");
INSERT INTO lifNT2_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","कुदगि मे़बेआङ् ए़त्‍ले़ङ् यहुदि हाङ्‌ङे, तियाहा! लॽरिक् मे़मे़त्तुर कुने़दे़ङ्‌बान् मे़ले़क्‍खु मे़बिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","पिलातसे़न् याम्‍मो लाःक्‍कात् लःन्‍दे़आङ् यहुदिहाॽ मे़त्तुसि, “कन् मनाओ इङ्‌गाॽ थेआङ् आप्‍तिक् मे़ङ्‌घोःबान्‍बा पाःन्‍निन् खिनिॽ कुसिङ् के़निःत्तुम्‍ल फाॽआङ् इङ्‌गाॽ लाःक्‍कात् लःत्तुङ्‌ल पत्तारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","हे़क्‍क्‍याङ् तिङ्‌ग्रेःक् तिचःन् मे़घुःक्‍तुबा नु परान्‍ला हाङ्‌तेःत्तिन् मे़जाक्‍तुबा ये़सुःन् लाःक्‍कात् मे़लःत्तुरो॥ हे़क्‍क्‍याङ् पिलातसरे़ मे़त्तुसि, “खा, कन् मनाःन् ओमे़त्ते़म्‍मे़ॽ!” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु माङ्‌हिम् के़गोःबा तिलिङ्‌गाहाॽरे़ खुने़ॽ मे़निःसुनामे़ःन्‍ने “सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् खे़न् फोःन्‍दे़ॽओ, सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् खे़न् फोःन्‍दे़ॽओ” लॽरिक् अःक्‍मा मे़हेःक्‍ते़रो॥ हे़क्‍केःल्‍ले़ पिलातसरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽए कन् मनाःन् तेॽरे़म्‍मे़ॽआङ् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःन्‍दे़म्‍मे़ॽओ, कर इङ्‌गाॽग खे़ल्‍ले़ कुदक्‍ले़ङ्‌वाओ थेआङ् आप्‍तिक् मे़ङ्‌घोःबान्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","कर खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “आनिगे़ कत्तुम्‍बे़बा साम्‌योथिम् कुइसिःक्‍ग खे़न् सिःमाए पोःङ्‌लो, थेआङ्‌भे़ल्‍ले़ खे़ल्‍ले़ आबाङे निङ्‌वाॽफुसाःआ फाॽआङ् मे़त्‍छिङ्‌ङाङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","पिलातसरे़ खे़न् पाःन्‍निन् खे़प्‍सुआङ् आल्‍लसाङ् साॽरिक् किःसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","खुने़ॽ याम्‍मो हाङ्‌हिम् सिगाङ् लाःसे़आङ् ये़सुःन् सेःन्‍दोसु, “खे़ने़ॽ आत्तोलाम् के़द्‌ये़बाबे?” कर ये़सुरे़ थेआङ् नोगप् मे़बिरुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","पिलातसरे़ ये़सुःन् मे़त्तु, “इङ्‌गाॽनु थेआङ् के़म्‍बाःत्‍ने़म्‍बा? खे़ने़ॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःम्‍मा नु ले़प्‍मादेःमा युक् कत्तुङ्‌बान् कुसिङ् के़न्‍निःत्तुन्‍बि?” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ये़सुरे़ नोगप् पिरु, “निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खे़ने़ॽ के़म्‍बिरे़न्‍निल्‍ले़ग इङ्‌गाॽ सम्‍दाङ् युक् के़ङ्‌गत्तुन्‍बारो॥ कर इङ्‌गाॽ खे़ने़ॽओ याप्‍मि हुक् के़सुप्‍पाल्‍ले़ कन्‍नुःल्‍ले़आङ् यम्‍बा लायोरे़न् आप्‍तिक् खोःसुॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","हे़क्‍केःल्‍ले़ग पिलातसरे़ ये़सुःन् ले़प्‍मादेःमा निङ्‌वाॽ चोगु, कर यहुदिहाॽरे़ चक्‍मे़ल्‍लॽए अक्‍खे मे़बाःत्तुर मे़अःक्‍ते़रो, “कन् मनाःन् के़ले़रु के़देःसुने़ फाॽग्र खे़ने़ॽग सिजरले़ कुन्‍देःङ्‌बा के़म्‍बोःङ्‌ने़न्‍लो॥ आत्तिल्‍ले़ आबाङे हाङ् पोःङ्‌मा निङ्‌वाॽ चोगुॽ खे़न् सिजरले़ कुदक्‍ले़ङ्‌वाओ पोःक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","पिलातसरे़ खे़न् खे़प्‍सुआङ् ये़सुःन् लाःक्‍कात् लःत्तु, हे़क्‍क्‍याङ्‌खुने़ॽ लुङ् फे़ःमनाबा खासे़न् युक्‍नाओ युङ्‌सिङ्‌लो॥ (खे़न् ते़न्‍निन् हिब्रु पाःन्‍नो गब्‍बथा मे़मे़त्तुरो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","हे़क्‍क्‍याङ् कङ्‌ग यहुदि चोःक्‌युम्‍भो तङ्‌नाम्‍मिल्‍ले़ थिक् ये़न् तगि ले़न्‍दिक् पोःक्‍खे़र पत्‍छे़॥ पिलातसरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ हाङ्‌ङिन् कप्‍मो वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","हे़क्‍केःल्‍ले़ यहुदिहाॽ साॽरिक् मे़अःक्‍ते़र मे़मे़त्तु, “खे़न् तेॽरे़ॽआङ् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःन्‍दे़ॽ!” हे़क्‍केःल्‍ले़ पिलातसरे़ सेःन्‍दोसुसि, “खिनिॽ हाङ्‌ङिन् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःन्‍दुङ्‌बाबि?” तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ नोगप् मे़बिरु, “आनिगे़ हाङ्‌ङिङ्‌ग सिजरे़न्‍लक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","हे़क्‍केःल्‍ले़ पिलातसरे़ ये़सुःन् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् मे़भोःन्‍दुर फाॽआङ् हुक्‍सुप्‍तुसिरो॥ खे़ल्‍ले़ चोगुल्‍ले़ थक्‍सुबाहाॽरे़ ये़सुःन् खे़प्‍मोलाम् मे़देॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","खे़ङ्‌हाॽरे़ ये़सुःन् कुसिलाम्‍साक्‍मा सिङ्‌ङिन् मे़गुःत्तुआङ् मिक्‍खोःक्‍पा कोःक्‍माओ मे़देॽरुरो॥ (खे़न् कोःक्‍मान् हिब्रु पाःन्‍नो गलगथा मे़मे़त्तुरो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","खे़प्‍मो ये़सुःन् सिलाम्‍साक्‍मा सिङ्‌ङो मे़भोःन्‍दु॥ खुने़ॽ कुजुप्‍साङ् नु कुभे़न्‍छाङ्‌बा सिलाम्‍साक्‍मा सिङ्‌हाॽ सम्‍दाङ् ने़प्‍फु मनाहाॽआङ् मे़भोःन्‍दुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातसरे़ नासरतबा ये़सु यहुदि हाङ् लॽरिक् के़बप्‍पा आप्‍तिक् सक्‍किन् साप्‍तुआङ् सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फम्‍मा पाङ्‌घुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","खे़न् यरिक् यहुदिहाॽरे़ मे़निःरुरो, थेआङ्‌भे़ल्‍ले़ खे़न् ते़न्‍निन् ये़क्‌यक्‍किल्‍ले़ कुबेसाङ्‌ङे ने़स्‍से़ हे़क्‍क्‍याङ् खे़ङ्‌ग हिब्रु, ल्‍यातिन नु ग्रिक पाःन्‍दाङ्‌ङो साप्‍ते़आङ् पत्‍छे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","यहुदिहाॽरे़ खुनिॽ तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ पिलातसे़न् अक्‍खे मे़मे़त्तुर मे़अत्तुरो, “खे़न् यहुदिहाॽरे़ खुनिॽ हाङ् लॽरिक् मे़साप्‍ते़न्‍ने़ॽओ, कर कन् मनाःल्‍ले़ यहुदिहाॽरे़ खुनिॽ हाङ्‌आ लॽरिक् पाःत्तुरो लॽरिक् साप्‍ते़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","कर पिलातसरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ च्‍या साप्‍तुङ्, खे़न् साप्‍तुङ् साप्‍तुङ्॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","थक्‍सुबाहाॽरे़ ये़सुःन् मे़भोःन्‍दु मे़सुरुआङ् खुने़ॽ कुदेःत्‍हाॽ लिसि लक्‍को मे़हाःत्‍छिङ्‌लो॥ कर कुलगेःत्तिन् कुदुम्‍बे मे़ःन्‍नेबा सर्धक् फःमनाबा चोगे़, ");
INSERT INTO lifNT2_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽ अक्‍खे मे़मे़त्‍छिङ्, “कङ्‌ग आनिॽ थे़ःक्‍खुम् मे़ःन्‍लो, कर तॽयाःन्‍सोःन्‌के़ःसुम्‍लो॥ आत्तिल्‍ले़ कुलक्‍को थाः, हाराॽ खे़ल्‍ले़ए खे़न् तेॽरुनिरो॥” कन् पाःन्‍निङ्‌ग साम्‌योसाप्‍लाओ अक्‍खेलॽरिक् खे़ङ्‌हाॽरे़ इङ्‌गाॽ आजाङ्‌हाॽ मे़हाःत्‍छिङ्‌लो, हे़क्‍क्‍याङ् आदेःत्तिन् तॽयानःन्सोःन् मे़गे़सुॽरो लॽरिक् साप्‍ते़आङ् के़बप्‍पे़न्‌के़रे़बारो॥ हे़क्‍केलॽरिक् थक्‍सुबाहाॽरे़आङ् बा हे़क्‍केए मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ये़सुःन् सिलाम्‍साक्‍मा सिङ्‌ङो मे़भोःन्‍दुबाल्‍ले़ कुबेसाङ् कुम्‍मा, कुन्‍छुमाॽ, क्‍लोपासरे़ कुमेःत् मरियम, हे़क्‍क्‍याङ् मरियम मग्‍दलिनिसि मे़ये़बे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ये़सुरे़ कुम्‍मा हे़क्‍क्‍याङ्‌लुङ्‌माॽ तुक्‍तुबा कुहुॽसाम्‍बान्‍नाङ् खे़प्‍मो निःत्ताङ् ये़बे़त्‍छिबा निःसुसिल्‍ले़ कुम्‍मा मे़त्तु, “खुने़ॽग के़स्‍साःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","हे़क्‍क्‍याङ् खे़न् हुॽसाम्‍बान् मे़त्तु, “खुने़ॽग थामे़न्‍दिङ्‌के़म्‍मारो॥” खे़न् ये़म्‍माङ्धोग खे़न् हुॽसाम्‍बाल्‍ले़ मरियम्‍मिन् कुहिम्‍मो तेॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","याङ्‌सि ये़सुरे़ काक् पाःन्‍हाॽ पोःक्‍खे़ चुरे़बा निःसुआङ् साम्‌योसाप्‍लाओ साप्‍ते़बान् के़त्‍ल फाॽआङ् पाःत्तु, “इङ्‌गाॽ आवामिःसे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","खे़प्‍मो के़सुःप्‍पा चे़ल्‍ले़क्‍सेॽ थिः के़याक्‍पा पर्‍यामाधिक् युङे़॥ हे़क्‍केःल्‍ले़ थक्‍सुबाहाॽरे़ खिगाक्‍माःन् चे़ल्‍ले़क्‍सेॽ थिओ मे़निःप्‍सुआङ् हिसप् सिङ्‌ङिल्‍ले़ कुबोराःक्‍को मे़भत्‍छु हे़क्‍क्‍याङ् ये़सुरे़ कुमुराओ खे़न् मे़धुप्‍तु मे़बिरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ये़सुरे़ खे़न् पिःत्तुआङ् पाःत्तु, “आल्‍ल चुरे़रो॥” हे़क्‍के पाःत्तुर कुधे़गेःक्‍पे़न्‌तर्घुॽ थाःसु हे़क्‍क्‍याङ् कुसक्‍मान्‌ले़रुदेःसुआङ्‌स्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","कङ्‌ग तङ्‌बेबा के़रे़क्‍नुःल्‍ले़ सेसेबा हे़क्‍क्‍याङ् यम्‍बा नाःम्‍सिङ्‌ये़न्‍निन्‍नुःल्‍ले़ थिक् ये़न् तगि वये़रो॥ यहुदिहाॽरे़ नाःम्‍सिङ्‌ये़न्‍नो सिलाम्‍साक्‍मा सिङ्‌सम्‍दाङ् चेहाॽ मे़बप्‍पा खुनिॽ सिराॽ मे़धाङ्‌ङिन्‍बाल्‍ले़ चोगुल्‍ले़ हारा मे़सिःर फाॽआङ् खुनिॽ लाङ्‌हाॽ मे़ए़क्‍खुआङ् मे़धाःसुसिर फाॽआङ् पिलातसे़न् पेलि मे़भाक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","खे़ल्‍ले़ चोगुल्‍ले़ थक्‍सुबाहाॽ मे़बेआङ् ये़सुःन्‍नु मे़भोःन्‍दुसिबा मनाहाॽरे़ खुन्‍छिॽ लाङ्‌हाॽ मे़ए़क्‍खुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","कर खे़ङ्‌हाॽ ये़सुरो मे़भे़रे़ल्‍ले़ ये़सुःङ्‌ग तगिए स्‍ये़बा मे़निःसुआङ् खुने़ॽ कुलाङ्‌हाॽ मे़न्‍ए़क्‍खुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","हे़क्‍केसाङ् थिक् थक्‍सुबाल्‍ले़ ये़सुरे़ कुले़म्‍भेःप्‍मो लाःक्‍किल्‍ले़ थुबुल्‍ले़ खिमो खे़प्‍मोलाम् माक्‍खिॽ नु च्‍वाःत् लःन्‍दे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","खिनिॽआङ् नसाःन् के़जोगुम्‍ल फाॽआङ् खे़न् पोःक्‍खे़बा पाःन् के़निःबाल्‍ले़ कन् पाःन्‍हाॽ पाःत्तुबारो॥ हे़क्‍क्‍याङ् खुने़ॽ पाःत्तुबा पाःन्‍हाॽग से़क्‍खाएरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","“खुने़ॽ कुये़ःप्‍पाहाॽ लत्‍थिक्‍काङ् मे़ए़क्‍ने़न्‍लो” लॽरिक् साप्‍ते़आङ् पप्‍पा साम्‌योसाप्‍लाःन् के़त्‍ल फाॽआङ् अक्‍खे पोःक्‍खे़बारो, ");
INSERT INTO lifNT2_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","हे़क्‍क्‍याङ् वेॽ ते़न्‍नो साम्‌योसाप्‍लाओ अक्‍खेआङ् साप्‍ते़आङ् पत्‍लो, “के़धुप्‍पाहाॽरे़ आबाङे मे़धुबुबान् ओमे़मे़त्तुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","खे़न् एगाङ् आरिमाथिया पाङ्‌जुम्‍बा युसुफे़न् पिलातसरो पेआङ् ये़सुरे़ कुधक्‍किन् नाःक्‍तु॥ खुने़ॽ यहुदिहाॽ किरुसिबाल्‍ले़ चोगुल्‍ले़ स्‍वाःत्ताङ् ये़सुरे़ कुहुॽसाम्‍बा पोःक्‍खे़आङ् वये़रो॥ पिलातसरे़ इङ्‌दत् पिरुआङ् खे़ल्‍ले़ ये़सुरे़ कुधक्‍किन् थाःसुआङ् तेॽरु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","तगि से़न्‍दिक् ये़सुरे़ कुदुम्‍से़ के़दाःबा निकोदेमसरे़ युसुफे़न् तेःङ् मे़त्तुआङ् वये़॥ निकोदेमसरे़ मुर्र नु खाम्‍दोलि फःम्‍मनाबा कुनाम्‍गे़नुॽबा सुम्‍सुम् (३३) किलो मारुक्‍किन् तारुआङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","खे़ङ्‌हाॽरे़ ये़सुरे़ कुधक्‍किन् तेॽरे़त्‍छुआङ् यहुदि चे लुप्‍मा थिम् कुइसिःक् मारुक्‍किन् हुःत्ते़त्‍छुआङ् नुःबा चेदेःत्तिल्‍ले़ कित्ते़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","आल्‍ल ये़सुःन् सिलाम्‍साक्‍मा सिङ्‌ङो मे़भोःन्‍दुबा ते़न्‍नो फुङ्‌इक् थिक् ने़स्‍से़॥ खे़न् फुङ्‌इक्‍को आल्‍लो थारिक् मना मे़न्‍ने़ए के़वाॽबा इप्‍पुङ्‌धिक् ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","कङ्‌ग नाःम्‍सिङ्‌ये़न्‍निल्‍ले़न् यारिप् चोःक्‍मा ये़न् वये़बाल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खे़न् इप्‍पुङ्‌ङिन् निःत्ताङ् ने़स्‍से़बाल्‍ले़ चोगुल्‍ले़ ये़सुरे़ कुधक्‍किन् तेॽरे़त्‍छुआङ् ने़स्‍से़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","आल्‍ल ते़ने़बा ये़न्‍नो खामे़न्‍ओःत्ते वये़ल्‍ले़सा मरियम मग्‍दलिनिःन् इप्‍पुङ्‌ङो पेरो॥ खे़न् इप्‍पुङ्‌ङिल्‍ले़ कुमुराओ मे़ये़प्‍सुबा यम्‍बा लुङ्‌ङिन् थिक्‍ले़प्‍माङ् मे़इसुआङ् ने़स्‍से़बा निःसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","हे़क्‍क्‍याङ् खे़न् लोःक्‍ते़र सिमोन पत्रुस नु ये़सुरे़ लुङ्‌माॽ तुक्‍तुबा वेॽस्‍मा हुॽसाम्‍बाल्‍लो पेआङ् मे़त्तुसि, “खे़ङ्‌हाॽरे़ दाङ्‌बाल्‍ले़ कुधक्‍किन् इप्‍पुङ्‌ङोलाम् मे़देॽरुआङ् होःप्‍लो! आत्तान् मे़ने़स्‍सुआङ् ने़ःॽ आनिगे़ मे़निःसुम्‍बान्‍लो!” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","पत्रुस नु खे़न् वेॽ हुॽसाम्‍बान् इःप्‍पुङ् ले़प्‍माङ् थाःने़त्‍छि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","खे़न् ने़प्‍माङ् लोःक्‍ते़त्‍छि, कर खे़न् वेॽ हुॽसाम्‍बाल्‍ले़ पत्रुसे़न् लाम्‍बाक्‍तुआङ् इप्‍पुङ्‌ङो तगि के़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","खे़न् अःक्‍खुम् फन्‍छिङ्‌ङाङ् सिगाङ् ओमे़त्तुल्‍ले़ चेदेःत्तिन्‌खे़प्‍मो ने़स्‍से़बा निःसु, कर सिगाङ्‌ग मे़लाःसे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","कुएःक् कुएःक् सिमोन पत्रुसे़न् खे़प्‍मो के़रे़आङ् सिगाङ् लाःसे़॥ खे़ल्‍ले़ चेदेःत्तिन्‌नु ");
INSERT INTO lifNT2_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ये़सुरे़ कुनारा मे़दे़प्‍तुबा तेःत्तिन् खे़प्‍मो ने़स्‍से़बा निःसु॥ खे़न् नादे़प्‍मा तेःत्तिन् चेदेःत्तिल्‍ले़ कुबेसाङ् मे़भाक्‍तुआङ्‌ने़स्‍से़बा निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","हे़क्‍क्‍याङ् तगि इप्‍पुङ्‌ङो के़गे़प्‍पा हुॽसाम्‍बे़न्‍नाङ् सिगाङ् लाःसे़॥ खे़ल्‍ले़ खे़न् निःसुआङ् नसाःन् चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(खे़ङ्‌हाॽरे़ आल्‍लसाङ् ये़सुःन् सिःमे़न्‍लाम् हिङ्‌लॽरिक् साम्‌योसाप्‍लाओ के़बप्‍पे़न्‌कुसिङ् मे़न्‍निःत्ते मे़वये़रो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","हे़क्‍क्‍याङ् खे़न् हुॽसाम्‍बाहाॽ ने़प्‍माङ् हिम्‍मो नुःक्‍खे़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","कर मरियम्‍मिन् इःप्‍पुङ् लाःक्‍कात् हाबे़र ये़बे़रो॥ खे़न् हाबे़र अःक्‍खुम् फन्‍छिङ्‌ङाङ् इःप्‍पुङ् सिगाङ् ओमे़त्तुल्‍ले़, ");
INSERT INTO lifNT2_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","फःगे़लॽबा तेःत् के़जाङ्‌बा ने़प्‍फु माङ्‌लाइङ्‌बाहाॽ ये़सुरे़ कुधक् मे़ने़स्‍सुआङ् ने़स्‍से़बा ते़न्‍नो थिक्‍किन् कुधे़गेःक् ले़प्‍माङ् नु वे़स्‍मान्‌कुलाङ् ले़प्‍माङ् युङे़त्‍छिबा निःसुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","खे़न् माङ्‌लाइङ्‌बाहाॽरे़ खुने़ॽ सेःन्‍दोःसे़त्‍छु, “खे़ने़ॽ थेआङ् के़हाःप्‍पाबे?” खे़ल्‍ले़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ आदाङ्‌बाल्‍ले़ कुधक्‍किन् कप्‍मोलाम् खे़ङ्‌हाॽरे़ मे़देॽरुरो हे़क्‍क्‍याङ् आत्तान् मे़ने़स्‍सुआङ् ने़इ इङ्‌गाॽ मे़निआन्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","हे़क्‍के पाःत्तुर मरियम्‍मिन् खिरि हिसिङ्‌ङिल्‍ले़ ये़सुःन् खे़प्‍मो ये़बे़बा निःसु, कर खुने़ॽ ये़सुःन्‍नेरो फाॽआङ् कुसिङ् निःप्‍मा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ये़सुरे़ खे़न् मे़त्तु, “मामुए, खे़ने़ॽ थेआङ् के़हाःप्‍पाबे? हाःत् के़गोःत्तुबाबे?” मरियमरे़ खुने़ॽग फुङ्‌इक् के़गोःबाबिला लॽरिक् निङ्‌वाॽ इःत्तुआङ् मे़त्तु, “आदाङ्‌बे, दाङ्‌बाल्‍ले़ कुधक्‍किन् कप्‍मोलाम् के़देॽरुआङ् वाॽने़ फाॽग्र आत्तान् के़ने़स्‍सुआङ् ने़ःॽ इङ्‌गाॽ मे़त्ताङ्‌ङे़ॽना, हे़क्‍क्‍याङ् कुधक्‍किन् इङ्‌गाॽ तेॽरुङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ये़सुरे़ खे़न् मे़त्तु, “मरियम्‍मे!” खुने़ॽ ये़सुःन्‌ले़प्‍माङ् हिसिङ्‌ङाङ् “रब्‍बोनि!” मे़त्तुरो॥ (खे़न् फाॽइङ्‌ग हिब्रु पाःन्‍नो “सिक्‍साम्‍बे” पोःङ्‌लो॥) ");
INSERT INTO lifNT2_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ये़सुरे़ खे़न् मे़त्तु “इङ्‌गाॽ मे़दे़म्‍साङ्‌ङिन्‍ने़ॽओ, थेआङ्‌भे़ल्‍ले़ आल्‍लो थारिक् इङ्‌गाॽ पानुदिङ् पाःल्‍लो मे़म्‍बेःक्‍के वाॽआरो॥ कर पेगे़ॽआङ् आन्‍साॽसि अक्‍खे मे़त्ते़से़ॽओ, ‘इङ्‌गाॽ पानुदिङ् आम्‍बा नु खिनिॽ पानुदिङ् पाः हे़क्‍क्‍याङ् इङ्‌गाॽ आनिङ्‌वाॽफुमाङ् नु खिनिॽ निङ्‌वाॽफुमाङ्‌ङो नुःङ्‌ङा पेःक्‍कार पत्तारो॥’” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मग्‍दलिनिःन् पेआङ् हुॽसाम्‍बाहाॽ, “इङ्‌गाॽ दाङ्‌बान् निःसुङ्‌ङाङ् वाॽरो” मे़त्तुसिआङ् ये़सुरे़ पाःत्तुबा पाःन्‍हाॽ खे़ङ्‌हाॽ चे़क्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","बा खे़न् ते़ने़बाल्‍ले़ युःन्‍छिक् हुॽसाम्‍बाहाॽरे़ यहुदिहाॽ मे़गिरुसिआङ् हिम्‍सिगाङ् मे़सुम्‍सिङ्‌, हे़क्‍क्‍याङ्‌लाम्‍धेःप्‍पे़न्‌मे़ए़त्तुआङ् मे़युङे़ल्‍ले़ ये़सुःन् खुनिॽ लुम्‍मो थाःम्‍सिङ्‌ल अक्‍खे मे़त्तुसि, “सनारुङ् के़घोःसुम्‍लरो!” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","हे़क्‍के पाःत्तु सुरुआङ् खुने़ॽ कुहुक्‍हाॽ नु कुले़म्‍भेःप्‍मान् ओसेःन्‍धाक्‍तुसि॥ दाङ्‌बान् मे़निःसुबाल्‍ले़ हुॽसाम्‍बाहाॽ साॽरिक् मे़सःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ये़सुरे़ खे़ङ्‌हाॽ याम्‍मो मे़त्तुसि, “सनारुङ् के़घोःसुम्‍लरो! पानुदिङ् पाःल्‍ले़ इङ्‌गाॽ पाङ्‌घाङ्‌बा कुइसिःक् खिनिॽआङ् इङ्‌गाॽ पाङ्‌निङ्‌ल पत्तारो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","हे़क्‍क्‍याङ् ये़सुरे़ खे़ङ्‌हाॽओ साङ्‌गुगे़न्‌सक्‍माःल्‍ले़ मुःत्तुसिर अक्‍खे मे़त्तुसि, “सेसेमाङ्‌ङिन् ताःक्‍ते़म्‍मे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","मनाहाॽरे़ खुनिॽ लायोःन् ले़प्‍मि के़बिरुम्‍सिम्‍ने़ फाॽग्र खे़ङ्‌हाॽरे़ खुनिॽ लायोःन् ले़प्‍मि पोःङ्‌लो, कर मनाहाॽरे़ खुनिॽ लायोःन् ले़प्‍मि के़म्‍बिरुम्‍सिम्‍मिन्‍ने़ फाॽग्र खे़ङ्‌हाॽरे़ खुनिॽ लायोःन् ले़प्‍मि मे़बोःङ्‌ने़ल्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","आल्‍ल ये़सुःन् खुनिॽ लुम्‍मो त्‍ये़ःल्‍ले़ थिक्-ने़त् हुॽसाम्‍बाहाॽओ थिक् दिदिमस मे़प्‍मनाबा थोमाःन् खे़प्‍मो होःप्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","हे़क्‍केःल्‍ले़ वेॽ हुॽसाम्‍बाहाॽरे़ थोमाःन् अक्‍खे मे़मे़त्तु, “आनिगे़ग दाङ्‌बान् निःसुम्‍बे़रो!” कर थोमाःल्‍ले़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽ कुहुक्‍को मे़धे़प्‍तुबा फे़न्‍तिङ्‌ङिल्‍ले़ कुयोःक्‍किन् मे़न्‍निए नु खे़प्‍मो आहुक्‍चोःन् मे़ङ्‌गेःत्ते हे़क्‍क्‍याङ् कुले़म्‍भेःप्‍मो लाःक्‍किल्‍ले़ मे़धुबुबाओ आहुक्‍किन् मे़ङ्‌गेःत्तेग नसाःन् मे़जोःक्‍कान्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ये़त्‍छि ये़न् एगाङ् हुॽसाम्‍बाहाॽ याम्‍मो हिम् सिगाङ् मे़जुप्‍से़आङ् मे़युङे़॥ कन्‌ये़म्‍मो थोमाःन्‍नाङ्‌वये़, लाम्‍धेःप्‍पे़न्‌सिगाङ्‌लाम् मे़सुबुआङ् पत्‍छे़साङ् खुनिॽ लुम्‍मोए ये़सुःन् थाःम्‍सिङ्‌ल, “सनारुङ् के़घोःसुम्‍लरो” मे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","हे़क्‍क्‍याङ् थोमाःन् मे़त्तु, “थोमाए, के़हुक्‍चोःन् कॽयो याक्‍ते़ॽ, आहुक्‍हाॽ ओमे़त्ते़ॽ॥ खे़ने़ॽ के़हुक्‍किन् आले़म्‍भेःप्‍मो लाःक्‍किल्‍ले़ मे़धुबुबा कुयोःक्‍को केःत्ते़ॽओ॥ खे़ने़ॽ चप्‍चि मे़जोगे़न्‍ने़ॽ, कर नसाःन् चोगे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","थोमाःल्‍ले़ मे़त्तु, “खे़ने़ॽग आदाङ्‌बा नु आनिङ्‌वाॽफुमाङ्‌ने़रो” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","हे़क्‍क्‍याङ् ये़सुरे़ खे़न् मे़त्तु, “खे़ने़ॽग इङ्‌गाॽ के़निःसाङ्‌ङाङ्‌लक् नसाःन् के़जोगाङ्‌लो, कर इङ्‌गाॽ याप्‍मि मे़न्‍निए नसाःन् के़जोःक्‍पाहाॽग मुॽइसाबासिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ये़सुरे़ कन् साप्‍पन्‍नो साप्‍ते़आङ् के़बप्‍पान्‍नुःल्‍ले़आङ् यरिक् निङ्‌वाॽ के़माबा मिक्‍सेःन्‍हाॽ कुहुॽसाम्‍बाहाॽरे़ खुनिॽ तगि चोगुआङ् वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","कर कप्‍मोग ये़सुःन्‍ने निङ्‌वाॽफुसाः, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरो लॽरिक् नसाःन् के़जोगुम्‍ल फाॽआङ् साप्‍ते़आङ् पप्‍पारो॥ हे़क्‍केलॽरिक् नसाःन् के़जोःक्‍पाहाॽरे़ मे़न्‍नुप्‍मनाबा हिङ्‌मन् मे़घोःसुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","याङ्‌सि ये़सुःन् याम्‍मो कुहुॽसाम्‍बाहाॽओ तिबेरियस वरक्‍किल्‍ले़ कुबेसाङ् अक्‍खेलॽरिक् ओसेःन्‍धाक्‍सिङ्‌लो– ");
INSERT INTO lifNT2_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","खे़प्‍मो सिमोन पत्रुस, दिदिमस मे़प्‍मनाबा थोमा, जब्‍दियारे़ ने़प्‍फु कुस्‍साःहाॽ, गालिलबा काना पाङ्‌जुम्‍बा नाथाने़ल हे़क्‍क्‍याङ् वेॽ ने़प्‍फु हुॽसाम्‍बाहाॽ सोरिक् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","सिमोन पत्रुसरे़ खे़ङ्‌हाॽ मे़त्तुसि, “इङ्‌गाॽग ङा ते़म्‍से़ पेःक्‍कारो॥” खे़ङ्‌हाॽरे़, “आनिगे़आङ् खे़ने़ॽनुए पेगिगे़ॽरो” मे़मे़त्तु॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ खःङ्‌बेओ मे़लाःसे़आङ् योःङ् ले़प्‍से़ मे़बे, कर खे़न् से़न्‍दिक् नाम्‍दाःत्ताःत् थेआङ् ते़म्‍मा मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","खाओःत्ते़र पत्‍छे़ल्‍ले़ ये़सुःन् वरक्‍किल्‍ले़ कुबेसाङ् ये़बे़, कर खे़ङ्‌हाॽरे़ खुने़ॽ ये़सुःन्‍नेरो फाॽआङ् कुसिङ् निःप्‍मा मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “चुम्‍से, खिनिॽ ङा के़दे़म्‍सुम्‍माङ् वाॽबि?” खे़ङ्‌हाॽरे़ नोगप् मे़बिरु, “होःप्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","याम्‍मो ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “खिनिॽ खःङ्‌बेल्‍ले़ चुप्‍साङ् ले़प्‍माङ् योःङ्‌ङिन् ले़प्‍ते़म्‍मे़ॽआङ् खे़प्‍मो खिनिॽ ङा के़धाःसुम्‍लो॥” खे़ङ्‌हाॽरे़ खुने़ॽ पाःत्तुबा कुइसिःक्‍के योःङ्‌ङिन् मे़ले़प्‍तुल्‍ले़ साॽरिक् यरिक् ङा मे़ध्‍ये़आङ् खे़ङ्‌हाॽरे़ योःङ्‌ङिन् उःङ्‌माए मे़न्‍छुक्‍तुन्॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ये़सुरे़ लुङ्‌माॽ तुक्‍तुबा कुहुॽसाम्‍बाल्‍ले़ सिमोन पत्रुसे़न् मे़त्तु, “खुने़ॽग दाङ्‌बान्‍नेरो!” सिमोन पत्रुसरे़ खे़न् खे़प्‍सुनामे़ःन्‍ने तेःत्तिल्‍ले़ कित्‍लिक्‌कित्‍छिङ्‌, थेआङ्‌भे़ल्‍ले़ खुने़ॽ खे़न् फे़न्‍दुआङ् वये़॥ हे़क्‍क्‍याङ् च्‍वाःत्तो पिन्‍दे़ लाःसे़आङ् वाजागे़र कुयाओ पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","वेॽ हुॽसाम्‍बाहाॽ ङाःल्‍ले़ के़दिम्‍बा योःङ्‌ङिन् खःङ्‌बेओलाम् मे़उःक्‍खुर कुयाओ मे़भे़रे़॥ खे़ङ्‌ग कुयालाम् खे़म्‍म्‍याक् मे़माःक्‍खे़न्, कर कुगिप् ने़त्‍छि (२००) हुक्‍सिक् थारिक्‍लक् ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","खे़ङ्‌हाॽ कुयाओ मे़गे़रे़ल्‍ले़ मिघाःङ्‌ङो ओॽमनाबा ङाहाॽ नु खरे़ःङ्‌हाॽ मे़निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आल्‍लो खारक् के़दे़म्‍सुम्‍बाओलाम् कुभा ङाहाॽ फे़त्ते़म्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","सिमोन पत्रुसे़न् खःङ्‌बेओ लाःसे़आङ् ङाःल्‍ले़ के़दिम्‍बा योःङ्‌ङिन् कुयाओ उःक्‍खु लःत्तु॥ खे़प्‍मो यम्‌यम्‍बा किप्‍थिक्‍काङ् ङा-सुम् (१५३) ङाहाॽ मे़यागे़॥ हे़क्‍केसाङ् योःङ्‌ङिन् मे़दे़ःक्‍खे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “फे़रे़म्‍मे़ॽआङ् चे़म्‍मे़ॽओ॥” कर खे़प्‍मो आत्तिन् कुहुॽसाम्‍बान्‍नाङ् खे़ने़ॽ हाःत्‍ने़न्‍बे लॽरिक् सेःन्‍दोःमा मे़न्‍आःन्‍छिङ्‌ङिन्‍लो, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ दाङ्‌बान्‍नेरो फाॽआङ् निङ्‌वाॽ मे़गत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ये़सुरे़ खरे़ःङ्‌ङिन् खप्‍सुआङ् खे़ङ्‌हाॽ पिरुसिरो॥ हे़क्‍केलॽरिक्‍के ङाहाॽआङ् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ये़सुःन् सिःमे़न्‍लाम् हिङे़आङ् कुहुॽसाम्‍बाहाॽरो ओसेःन्‍धाक्‍सिङ्‌बा कन् सुम्‍ले़ङ् पोःक्‍खे़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","खे़ङ्‌हाॽरे़ मे़ज मे़सुरुआङ् सिमोन पत्रुसे़न् ये़सुरे़ मे़त्तु “युहुन्‍नारे़ कुस्‍साः सिमोने, कङ्‌हाॽरे़ मिःम्‍जि मे़मे़त्ताबानुःल्‍ले़आङ् यरिक् खे़ने़ॽ मिःम्‍जि के़मे़त्ताबि?” खे़ल्‍ले़ नोगप् पिरु, “ओरो, आदाङ्‌बे, इङ्‌गाॽ से़क्‍खाए मिःम्‍जि मे़त्‍ने़ॽबान् खे़ने़ॽ के़निःसुॽरो॥” ये़सुरे़ मे़त्तु, “आमे़ल्‍लुक्‍साःहाॽ चालाम्‍से़से़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ये़सुरे़ पत्रुसे़न् याम्‍मो सेःन्‍दोसु, “युहुन्‍नारे़ कुस्‍साः सिमोने, इङ्‌गाॽ मिःम्‍जि के़मे़त्ताबि?” खे़ल्‍ले़ नोगप् पिरु, “ओरो, आदाङ्‌बे, इङ्‌गाॽ से़क्‍खाए मिःम्‍जि मे़त्‍ने़ॽबान् खे़ने़ॽ के़निःसुॽरो॥” ये़सुरे़ मे़त्तु, “आमे़ल्‍लुक्‍हाॽ कमे़से़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","हे़क्‍क्‍याङ् याम्‍मो ये़सुरे़ सुम्‍ले़ङ्‌ङो पत्रुसे़न् सेःन्‍दोसु, “युहुन्‍नारे़ कुस्‍साः सिमोने, इङ्‌गाॽ मिःम्‍जि के़मे़त्ताबि?” अक्‍खेलॽरिक् ये़सुरे़ सुम्‍ले़ङ् थारिक् “इङ्‌गाॽ मिःम्‍जि के़मे़त्ताबि” लॽरिक् सेःन्‍दोसुबाओ पत्रुसरे़ कुनिङ्‌वाॽ तुगे़र मे़त्तु, “ओरो, आदाङ्‌बे, खे़ने़ॽग काक् पाःन्‍हाॽ के़निःसुॽरो॥ इङ्‌गाॽ से़क्‍खाए खे़ने़ॽ मिःम्‍जि मे़त्‍ने़बान् खे़ने़ॽ के़निःसुॽरो॥” ये़सुरे़ खे़न् मे़त्तु, “आमे़ल्‍लुक्‍हाॽ चालाम्‍से़से़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","इङ्‌गाॽ से़क्‍खाए मे़त्‍ने़ॽ, थाङ्‌बे़न् के़वये़ल्‍ले़ आबाङे फॽइ के़युप्‍सिङ्‌ङाङ् आत्तान् पेःक्‍मा निङ्‌वाॽ के़जोगु खे़प्‍मोए के़बेरो, कर काप्‍पोबा के़दुम्‍माङ्‌ग के़हुक्‍हाॽ के़सन्‍छुॽ, हे़क्‍क्‍याङ्‌फॽइ के़म्‌युप्‍पाङ् आत्तान् पेःक्‍मा के़सिराॽ मे़धाङ्‌ने़न् खे़प्‍मो के़म्‍देॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ये़सुरे़ अक्‍खे मे़त्तुर पत्रुसे़न् के़दाःबा ये़म्‍मो आत्तिन् परिक्‍ले़न् सिःमे़न्‍लाम् निङ्‌वाॽफुमाङ्‌ङिन् मिमिदिङ् चोगुॽ फाॽआङ् ओसेःन्‍धाक्‍तुआङ् वये़रो॥ हे़क्‍क्‍याङ् दाङ्‌बाल्‍ले़ पत्रुसे़न् मे़त्तु, “इङ्‌गाॽ तिःक्‍ताङ्‌ङे़ॽओ!” ");
INSERT INTO lifNT2_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पत्रुसे़न् हिल्‍लिक्‌हिसिङ्‌ङिल्‍ले़ ये़सुरे़ लुङ्‌माॽ तुक्‍तुबा कुहुॽसाम्‍बे़ल्‍ले़ तिम्‍दुबा निःसुरो॥ (साभाङ्‌जा मे़जःल्‍ले़ बा खे़न् हुॽसाम्‍बाल्‍ले़ ये़सुरे़ कुबेसाङ् नाःम्‍सिङ्‌ल युङे़ल्‍ले़ दाङ्‌बे, हाःत्‍ले़ इङ्‌गे़ले़क्‍पे लॽरिक् सेःन्‍दोसुआङ् वये़रो) ");
INSERT INTO lifNT2_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","पत्रुसरे़ खे़न् निःसुआङ् दाङ्‌बान् सेःन्‍दोसु, “दाङ्‌बे, खुने़ॽ कुयाःम्‍बेओ थे पोःङ्‌बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ये़सुरे़ नोगप् पिरु, “इङ्‌गाॽ नुःङ्‌ङार थारिक् खुने़ॽ हिङ्‌ङाङ् वाॽर पाःप्‍मा निङ्‌वाॽ चोगुङ्‌ङिल्‍ले़ खे़ने़ॽ थे़मा पोःङ्‌बे? इङ्‌गाॽ तिःक्‍ताङ्‌ङे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","खे़ल्‍ले़ चोगुल्‍ले़ हुॽसाम्‍बाहाॽरे़ खुनिॽ लुम्‍मो कन् हुॽसाम्‍बाङ्‌ग मे़सिःने़न्‍लो लॽरिक् इङ् से़ःरे़रो॥ कर दाङ्‌बाल्‍ले़ग हे़क्‍के पाःत्तुबा होःप्‍ते़रो॥ खुने़ॽग अक्‍खेरक् पाःत्तुआङ् वये़रो, “इङ्‌गाॽ नुःङ्‌ङार थारिक् खुने़ॽ हिङ्‌ङाङ् वाॽर पाःत्तुङ्‌ङिल्‍ले़ खे़ने़ॽ थे़मा पोःक्‍खे़बे?” ");
INSERT INTO lifNT2_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","बा खे़न् कुहुॽसाम्‍बाल्‍ले़ कन् पाःन्‍हाॽरे़न् तोःन्‍दि पिरुआङ् साप्‍तुबारो॥ खुने़ॽ कुबाःन्‍हाॽग से़क्‍खाएरो फाॽआङ् आनिगे़ निःसुम्‍बे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ये़सुरे़ वेॽ यरिक् याःम्‍बक्‍हाॽआङ् चोगु॥ खे़ङ्‌हाॽ थे़प्‍पे़त्ताङ् साप्‍माल्‍ले़ग खे़न् साप्‍पन्‍हाॽ कन् इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़आङ् मे़हत्तुन्‌लॽरिक् इःत्तुङ्‌लो॥");
INSERT INTO lifNT2_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","आमिःम् थियोफिलसे, इङ्‌गाॽ तगिबा आसाप्‍पन्‍नो ये़सुरे इङ्‌जाःङ् पिरुसिआङ् साङ्‌ग्राम्‍पेदाङ्‌ङो मे़न्‍देॽए थारिक् खुने़ॽ चोगुबा याःम्‍बक्‍हाॽ नु हुॽरुसिबा काक् पाःन्‍हाॽ साप्‍तुङ् पिने़आङ् पत्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ये़सुःन् तुक्‍खे च्‍ये़आङ् स्‍ये़, हे़क्‍क्‍याङ् सिःमे़न्‍लाम् याम्‍मो हिङे़आङ् लिबोःङ्‌(४०) ये़न् थारिक् खुने़ॽ से़क्‍खाए कुहिङ्‌वे़त् पोःक्‍खे़बा पाःन्‍निन् ओसेःन्‍धाक्‍सिङ्‌मा फाॽआङ् ए़त्‍ले़ङ् ओसेःन्‍धाक्‍सिङ्‌, हे़क्‍क्‍याङ् निङ्‌वाॽफुहाङ्‌जुम्‍मिल्‍ले़ कुयाःम्‍बेओ चे़क्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","थिक्‍ले़ङ् खुने़ॽ खे़ङ्‌हाॽनु चर युङे़ल्‍ले़ अक्‍खे मे़त्तुसि, “यरुसले़म ले़रे़म्‍मे़ॽआङ् आल्‍लोसा मे़बेगे़म्‍मिन्‍ने़ॽओ, कर साङ्‌ग्राम्‍पेदाङ्‌ङोबा पानुदिङ् आम्‍बारे़ सेसेमाङ् पिनिङ् लॽरिक् चोगुबा माङ्‌हे़क्‍किन्‌हाङ्‌घे़म्‍मे़ॽ॥ कङ्‌ग तगि मे़त्‍निङ्‌बा के़घे़प्‍सुम्‍माङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","युहुन्‍नारे़ग च्‍वाःत्तिल्‍ले़ बप्‍तिस्‍मा के़बिरि, कर कुभा ये़न् एगाङ् सेसेमाङ्‌लाम् बप्‍तिस्‍मा के़बोःक्‍खिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","थिक्‌ये़न् खे़ङ्‌हाॽरे़ खुने़ॽनु सोरिक् मे़वये़ल्‍ले़ मे़मे़त्तु “आदाङ्‌बे, बा कन् ये़म्‍मोए इस्राइलिहाॽ चोःक्‌युम्‍भो के़बिरुसिआङ् आनिॽ हाङ्‌जुम्‍मिन् याम्‍मो के़जोगुॽबि?” ");
INSERT INTO lifNT2_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ये़सुरे़ खे़ङ्‌हाॽ मे़त्तुसि, “आप्‍फाल्‍ले़ कन् पाःन्‍हाॽ के़त् के़लॽबान् निःमा थाःमा खिनिॽ याःम्‍बक् मे़ःन्‍लो॥ खे़ङ्‌ग पानुदिङ् पाःल्‍ले़ आबाङे कुनिङ्‌वाॽओ निःन्‍धो चोगुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","कर खिनिॽ थे़मा निङ्‌वाॽ खोःमा पोःङ् फाॽले़ सेसेमाङ्‌ङिन् खिनिॽओ ताःल्‍ले़ मुक्‍साम् के़घोःसुम्‍माङ् खिनिॽ यरुसले़म्‍मो, यहुदिया नु सामरिया थुम्‍मो हे़क्‍क्‍याङ् काक् इक्‍सादिङ् खाम्‍बेःक्‍मो खाराक् इङ्‌गाॽ आदोःन्‍दि के़बोःक्‍खिॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ये़सुरे़ हे़क्‍के पाःत्तु सुरुआङ् खुने़ॽ ओमे़मे़त्तुर मे़बत्‍छे़ल्‍ले़ए थाःङ्‌धाःङ् साङ्‌ग्राम्‍पेदाङ् ले़प्‍माङ् पक्‍खे़र खाप्‍मिःत्तिल्‍ले़ इःप्‍तु तेॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","खे़ङ्‌हाॽरे़ ताङ्‌साक्‍पो खुने़ॽ पङ्‌सिङ्‌बा ओमे़मे़त्तुर मे़ये़बे़ल्‍ले़ फःगे़लॽबा तेःत् के़जाङ्‌बा ने़प्‍फु माङ्‌लाइङ्‌बाहाॽ हक्‍चघत् खे़ङ्‌हाॽरे़ खुनिॽ पेसाङ् ये़म्‍ने़त्‍छिआङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","पारे़त्‍छि, “गालिलबा मनासे, थेआङ् ताङ्‌साक्‍पो ओगे़मे़त्तुम्‍बाबे? ये़सुःन् साङ्‌ग्राम्‍पेदाङ्‌ङो थोधो पङ्‌सिङ् पेबा हे़क्‍केए खुने़ॽ थिक्‌ये़न् याम्‍मो युःरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","हे़क्‍क्‍याङ् सेःक्‌युक्‍मिबाहाॽ जैतुन मे़प्‍मनाबा कोःक्‍मालाम् यरुसले़म मे़नुःक्‍खे़॥ खे़न् यरुसले़मलाम् किलोमितरधिक् माःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ये़क्‌यक्‍को मे़लाःसे़आङ् खे़ङ्‌हाॽ मे़यागे़बा थाःङ्‌स्‍मा याक्‍फाओ मे़लाःसे़॥ खे़प्‍मो पत्रुस, युहुन्‍ना, याकुब, आन्‍द्रियास, फिलिप, थोमा, बारथोलोमाइ, मत्ति, अल्‍फायसरे़ कुस्‍साः याकुब, हाङ्‌बिफ्‍युङ् के़जोःक्‍पा सिमोन हे़क्‍क्‍याङ् याकुबरे़ कुस्‍साः यहुदा मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","खे़ङ्‌हाॽ काक् सोरिक् मे़बोःक्‍खे़र चक्‍मे़ल्‍लॽए तुवा चोःक्‍कि मे़यागे़॥ खे़ङ्‌हाॽओ ये़सुरे़ कुम्‍मा मरियम नु वेॽ मे़न्‍छुमाहाॽ हे़क्‍क्‍याङ् ये़सुरे़ कुन्‍साॽसिआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","खे़न् ये़म्‍मो पत्रुसे़न् किप्‍थिक्‍काङ् निबोःङ् यारिक् (१२०) नसानिबा लुम्‍मो ये़म्‍सिङ्‌ङाङ् ");
INSERT INTO lifNT2_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","खे़ङ्‌हाॽ मे़त्तुसि, “फुॽनुसाॽसे, यहुदा इस्‍करियोतिन् आनिॽनुए वये़, हे़क्‍क्‍याङ् कन् माङ्‌सेवा चोःक्‍मा लक्‍किन् दाङ्‌बालाम् खोःसुआङ् वये़रो॥ कर खे़ल्‍ले़ अक्‍खेलॽरिक् ये़सुरे़ कुदे़म्‍से़ के़दाःबाहाॽ लाम्‍लोसुसिॽ के़लॽबा पाःन्‍निन् सेसेमाङ्‌ङिल्‍ले़ तगिसा दाउद हाङ्‌लाम् साम्‌योसाप्‍लाओ साप्‍ते़बा पाःन्‍निन् के़प्‍मा पोःक्‍खे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(कन् मनाःल्‍ले़ फे़न् याःम्‍बक्‍लाम् थगुबा याङ्‌ङिल्‍ले़ प्‍याङ्‌सिगे़न् इक्‍ताप् इङुआङ् वये़॥ खुने़ॽ खे़प्‍मो फोःन्‍छिङ्‌ङिल्‍ले़ मक्‍थ्‍ये़आङ् कुसाप्‍पोःक्‍किन् ते़स्‍से़आङ् कुहिदुत् लःन्‍दे़आङ् स्‍ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","हे़क्‍क्‍याङ् यरुसले़मबा मनाहाॽरे़ कन् पाःन्‍निन् निङ्‌वाॽ मे़घोःसुआङ् खे़न् प्‍याङ्‌सिगे़न् इक्‍ताप्‍पिन् “अक्‍केल्‍दामा” मिङ् मे़वाःत्तुरो॥ खे़न् फाॽइन् माक्‍खिॽ इक्‍ताप् पोःङ्‌लो॥) ");
INSERT INTO lifNT2_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","पत्रुसरे़ पाःत्तु, “अक्‍खेलॽरिक् कन् पाःन्‍निन् साप्‍पन्‍नो साप्‍ते़आङ् पत्, ‘खे़ल्‍ले़ कुहिम्‍धाःङ्‌हाॽ कुघाले़म् पोःङ्‌लरो॥’ हे़क्‍क्‍याङ् ‘खे़प्‍मो के़युङ्‌बा हाःत्ताङ् मे़होःप्‍लरो॥’ हे़क्‍क्‍याङ् ‘माङ्‌सेवा चोःक्‍मा कुलक्‍किन्‌वेॽ मनाःल्‍ले़ खोःसुररो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","हे़क्‍केःल्‍ले़ दाङ्‌बा ये़सुःन्‍नु सोरिक्‌आवये़ल्‍ले़ आनिॽनुए के़वाॽबा मनाःल्‍ले़ कुले़क्‌वा लत्‍थिक् सेःक्‍माए पोःङ्॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","खुने़ॽ युहुन्‍नारे़ चोगुबा बप्‍तिस्‍माआङ्धो दाङ्‌बा ये़सुःन् आनिॽ लुम्‍मोनु साङ्‌ग्राम्‍पेदाङ् पेबा थारिक् के़निःबा पोःङ्‌मा पोःङ्॥ खुने़ॽ आनिॽनुए दाङ्‌बा ये़सुःन् सिःमे़न्‍लाम् याम्‍मो कुहिङ्‌वे़त् पोःक्‍खे़बा पाःन्‍निल्‍ले़न् तोःन्‍दि पोःङ्‌मा पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ ने़प्‍फु मनाहाॽ मे़दोःन्‍दुसि–बरसाबास मे़प्‍मनाबा युसुफ (खे़ल्‍ले़ कुमिङ्‌ङिन् युस्‍तसआङ् वये़) हे़क्‍क्‍याङ् मत्तियास॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ अक्‍खेलॽरिक् मे़बाःत्तुर तुवा मे़जोगु, “आदाङ्‌बे, खे़ने़ॽग मे़न्‍छाम्‍गे़न् याप्‍मिरे़ खुनिॽ सिक्‍लुङ्‌मोबा पाःन्‍निन् के़निःसुॽरो॥ कन् सेःक्‌युक्‍मिबा माङ्‌सेवा लक्‍किन् चोःक्‍मा फाॽआङ् यहुदाःल्‍ले़ कुले़क्‌वा कन् ने़प्‍फुओ के़सेगुबा मनाःन् ओसेःन्‍दाङ् चोगे़ॽओ, थेआङ्‌भे़ल्‍ले़ यहुदाःल्‍ले़ खे़न् ले़रुआङ् लाॽरुबा कुलाम्‍मो पेरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ सिङ्‌जेःक् मे़ए़क्‍खुल्‍ले़ खे़न् मत्तियासरे़ कुमिङ्‌ङो थ्‍ये़रो॥ हे़क्‍क्‍याङ् खुने़ॽ थिक्-थिक् (११) सेःक्‌युक्‍मिबाहाॽओ योॽसिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","पे़न्‍तिकोस तङ्‌नाम्‍मो यरुसले़म्‍मो नसानिबाहाॽ थिक् ते़न्‍नो मे़जुप्‍से़आङ् मे़वये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","हक्‍चघत् खे़प्‍मो यम्‍बा सुरित् केजङ् के़हुबा कुइसिःक् इक्‍लाधिक् साङ्‌ग्राम्‍पेदाङ्‌लाम् ये़आङ् खे़ङ्‌हाॽ मे़यागे़बा हिम्‍मिन् सिदाक् थिम्‍सुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","हे़क्‍क्‍याङ् मिराःक्‍लाम्‌के़से़बा मिसाङ् हे़क्‍तङ्‌बा मिःन्‌के़रे़क्‍ले़ खुनिॽ थे़गेःक्‍को चुक्‍ते़बा खे़ङ्‌हाॽरे़ मे़निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","हे़क्‍क्‍याङ् सेसेमाङ्‌ङिल्‍ले़ थुक्‍तुसिआङ् सेसेमाङ्‌ङिल्‍ले़ पिरुसिबा कुइसिःक् वेॽ वेॽ मे़ल्‍ले़स्‍सुम्‍बा पाःन्‍दाङ्‌ङो पाःप्‍मा मे़हेःक्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","आल्‍ल यरुसले़म्‍मो इक्‍सादिङ् खाम्‍बेःक्‍मोबा काक् लाजेॽओनु के़दाःबाआङ् के़वाॽबा यहुदि साम्‌योबा मनाहाॽआङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","यरिक् मनाहाॽरे़ कन् इक्‍लाःन् मे़घे़प्‍सुआङ् खे़न् ते़न्‍नो खुनिॽ निङ्‌वाॽ मये़र मे़जुप्‍से़, थेआङ्‌भे़ल्‍ले़ के़दाःबाहाॽरे़ खुनिॽ आबाङे पेलिगे़न् पाःन्‍दाङ्‌ङो खे़न् नसानिबाहाॽरे़ मे़बाःत्तुबा मे़घे़प्‍सु॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ खुनिॽ निङ्‌वाॽ मये़आङ् सेःन्‍मे़दोसुसि, “मे़ःम्‍बे़! कन् काक् के़बाःप्‍पाहाॽग गालिलिसि मे़ःन्‍छिबि? ");
INSERT INTO lifNT2_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","हे़क्‍केःल्‍ले़ कङ्‌हाॽरे़ आबाङे आनिॽ पाःन्‍दाङ्‌हाॽओ आक्‍खेलॽरिक् पाःप्‍मा मे़सुक्‍तुबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","आनिॽग पर्थिया, मेदिया, एलामि, मे़सोपोतामिया, यहुदिया, काप्‍पादोकिया, पोन्‍तस, एसिया, ");
INSERT INTO lifNT2_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रिगिया, पाम्‍फिलिया, मिस्र नु लिबिया कुबेसाङ्‌बा साइरेनि ये़क्‌यक्, हे़क्‍क्‍याङ् रोमलाम् के़दाःबा (यहुदिहाॽ नु यहुदि साम्‌यो के़नाःप्‍पा थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽ), ");
INSERT INTO lifNT2_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","क्रेतिहाॽ हे़क्‍क्‍याङ् अरबिहाॽआङ् आवाॽ॥ करसाङ् खे़ङ्‌हाॽरे़ग आनिॽ आबाङे पाःन्‍दाङ्‌ङो निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ चोगुबा निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ मे़जे़क्‍खुर मे़बप्‍पा आघे़प्‍सुम्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","खुनिॽ निङ्‌वाॽ मये़ हे़क्‍क्‍याङ् हःन्‍दा मे़ले़क्‍ते़आङ् अक्‍खेलॽरिक् सेःन्‍मे़दोःसिङ्, “कन् फाॽइङ्‌ग थे़माःन्बे?” ");
INSERT INTO lifNT2_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","कर कुभारे़ किनाःन्‍दि मे़बिरुसिर चे़ल्‍ले़क्‍सेॽ थिःल्‍ले़ मयुसिआङ् वाॽ लॽरिक् मे़मे़त्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","कर पत्रुसे़न् वेॽ थिक्-थिक् (११) सेःक्‌युक्‍मिबाहाॽनु ये़म्‍सिङ्‌ङाङ् यम्‍बा इक्‍लाओ काक्‍ले़ मे़घे़प्‍सुर मे़त्तुसि, “यहुदियालाम् के़दाःबा यहुदि तेःङ्‌जुम्‍हाॽ नु यरुसले़म्‍मो के़युङ्‌बासे, कन् थे पोःक्‍खे़बा फाॽआङ् मे़त्‍निङ्‌लो, आबाःन्‍निन् खे़प्‍से़म्‍मे़ॽओ! ");
INSERT INTO lifNT2_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","कन् मनाहाॽ नु इङ्‌गाॽ खिनिॽ के़इःत्तुम्‍बा कुइसिःक् चे़ल्‍ले़क्‍सेॽ थिःल्‍ले़ मयिगे़बा मे़ःन्‍लो॥ तानाम्‍बा कुमुक् फाङ्‌सिओसाग (९) आत्तिन्‍हाॽरे़आङ् चे़ल्‍ले़क्‍सेॽ थिः मे़न्‍धुङुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","कर कङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा योएलरे़ अक्‍खेलॽरिक् पाःत्तुबा पाःन्‍निन् के़रे़बारो– ");
INSERT INTO lifNT2_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाःत्तुआङ् वाॽ, कन् इक्‍सादिङ् खाम्‍बेःक्‍माल्‍ले़ कुनुप्‍मा ये़न्‍हाॽओ इङ्‌गाॽ आसेसेमाङ्‌ङिन् काक् मे़न्‍छाम्‍गे़न् सुवाङ् सम्‍दाङ् पाङ्‌घुङ्‌ङाङ् खिनिॽ ये़म्‍बित्‍छाॽ नु मे़न्‍छुमाॽसाहाॽरे़ माङ्‌निङ्‌वाॽपाःन् मे़बाःत्तुॽ, खिनिॽ नालिङ्‌गे़न् थाङ्‌बे़न्‍साहाॽरे़ सुफो मे़निःसुॽ, हे़क्‍क्‍याङ् खिनिॽ खदाक्‍मिहाॽरे़ तादिगे़न् से़प्‍माङ् मे़माक्‍तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","खे़न् ये़न्‍हाॽओ इङ्‌गाॽ आसेवा के़जोःक्‍पा के़जोःक्‍माहाॽओ आसेसेमाङ्‌ङिन् पाङ्‌घुङ् हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ माङ्‌निङ्‌वाॽपाःन् मे़बाःत्तुॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","हे़क्‍क्‍याङ् इङ्‌गाॽ थो ताङ्‌साक्‍पो निङ्‌वाॽ के़माबा पाःन्‍हाॽ चोगुङ् हे़क्‍क्‍याङ् यो इक्‍सादिङ् खाम्‍बेःक्‍मोआङ् मिक्‍सेःन् चोगुङ्– माक्‍खिॽ, मि हे़क्‍क्‍याङ् हाःङ्‌गुहाःङ्‌गु के़लॽबा मिःक्‍खुॽइन् ओसेःन्‍धाक्‍निङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","हे़क्‍क्‍याङ् थो ताङ्‌साक्‍पो नाम्‍मिल्‍ले़ नाम्‍साङ् पिमा ले़रुआङ् खादाम्‍लो हे़क्‍क्‍याङ् लाबान् माक्‍खिॽ हे़क्‍के हे़ःत्लॽरिक् ले़ङ्‌सिङ्‌लो॥ कन् काक् पाःन्‍हाॽ दाङ्‌बान् नुःङ् युःबा पयम् यम्‍बा नु निङ्‌वाॽ के़माबा ये़न्‍निन् ताःमानुःल्‍ले़ तगि पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","हे़क्‍क्‍याङ् हाःत्‍ले़ दाङ्‌बे़ल्‍ले़ कुमिङ्‌ङिन् लोःक्‍खुॽ खे़न् ताङ्‌से़ःप्लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","इस्राइलिसे, कन् पाःन्‍निन् खे़प्‍से़म्‍मे़ॽओ–नासरतस्‍मा ये़सुःङ्‌ग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ हे़क्‍क्‍याङ् मिक्‍सेःन्‍हाॽनु खिनिॽ लुम्‍मो पाङ्‌घुरो॥ खिनिॽ लुम्‍मो याःम्‍बक्‍हाॽ चोगुबाङ्‌ग, खिनिॽआङ् के़निःसुम्‍मेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽ आबाङे कुनिङ्‌सेःक् नु तगि निङ्‌वाॽओ हे़क्‍के ये़सुःन् खिनिॽ हुक्‍को पिरे़आङ् फे़न् सुवाङ्‌हाॽरे़ खुनिॽ हुक्‍कोलाम् खुने़ॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् के़भोःन्‍दुम्‍माङ् के़से़रुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सिःमे़ल्‍ले़ तुक्‍खेवालाम् चोःक्‌युम्‍भो पिरुआङ् कुहिङ्‌वे़त् चोगुरो, थेआङ्‌भे़ल्‍ले़ सिःमे़ल्‍ले़ खुने़ॽ थेःक्‍मा मे़सुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","दाउद हाङ्‌ङिल्‍ले़ खुने़ॽ कुयाःम्‍बेओ अक्‍खेलॽरिक् साप्‍तुआङ् पत्, ‘सदादिङ् इङ्‌गाॽ आन्‍दाङ्‌बे़ङ्‌ग आदगाङ् निःसुङ्‌लो॥ खुने़ॽ आजुप्‍साङ् ले़प्‍माङ् वाॽबाल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽ मे़गिआन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","खे़ल्‍ले़ चोगुल्‍ले़ इङ्‌गाॽ सःत्ताआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःसुङ्‌लो॥ नासिङ्‌गे़न् आधक्‍लाओ इङ्‌गाॽ सिःआसाङ् याम्‍मो हिङ्‌ङा के़लॽबा निङ्‌साङ्‌ङो हाङ्‌हाङ् वाॽआरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","थेआङ्‌भे़ल्‍ले़ निङ्‌वाॽफुमाङ्‌ङे, इङ्‌गाॽ आयाम्‍साम्‍मिन् खे़मायङ्‌सङ्‌ङो पक्‍के़न्‍धने़न्‍लो॥ हे़क्‍क्‍याङ् सेसे के़सेवारोबाल्‍ले़ कुधक्‍किन् इप्‍पुङ्‌ङो किःमा यःप्‍मा के़म्‍बाङ्‌घुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","याम्‍मो हिङ्‌ङा फाॽआङ् खे़ने़ॽ ओसेःन्‍गे़धाक्‍ताङ्‌ङाङ् वाॽरो॥ हे़क्‍क्‍याङ् खे़ने़ॽ के़दगाङ्‌वाॽआल्‍ले़ सःप्‍माल्‍ले़ के़धिम्‍माॽरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","फुॽनुसाॽसे, आल्‍ल इङ्‌गाॽ निस्‍सेआङ् अक्‍खे पाःप्‍मा सुक्‍तुङ्‌लो–आनिॽ ताक्‍थे़बा दाउदे़ङ्‌ग स्‍ये़ हे़क्‍क्‍याङ् मे़लुप्‍तुआङ् कुइप्‍पुङ्‌ङिन् आल्‍लो थारिक्‍काङ् ने़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","हे़क्‍केसाङ् खुने़ॽ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा चोगे़बाल्‍ले़ कुमुॽइदाङ्‌साओ बा खुने़ॽ हे़क्‍तङ्‌बा हाङ् पोःङ् के़लॽबा माङ्‌हे़क् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ चोगुबान् खुने़ॽ कुसिङ् निःत्तु॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","हे़क्‍क्‍याङ् दाउदरे़ तगिनुसा ताःन्‍दि थे पोःङ् के़लॽबान् निःसुआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरे़ कुसिःमे़न्‍लाम्‌याम्‍मो हिङ्‌मारे़ कुयाःम्‍बेओ अक्‍खे पाःत्तुरो, ‘खुने़ॽग खे़मायङ्‌सङ्‌ङो पक्‍मे़धाने़न्, हे़क्‍क्‍याङ् खुने़ॽ नासिङ्‌गे़न् कुधक्‍किन्‍नाङ् मे़गिने़न्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","बा कन् ये़सुःन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ याम्‍मो कुहिङ्‌वे़त् चोगुबा पाःन्‍नो आनिगे़ के़रे़क् के़निःबा तोःन्‍दि वयिगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","हे़क्‍क्‍याङ् खुने़ॽ पानुदिङ् पाः निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुजुप्‍साङ् ले़प्‍माङ् युक्‍खु॥ खुने़ॽ निङ्‌वाॽफुपाःलाम् सेसेमाङ्‌ङिल्‍ले़न् माङ्‌हे़क्‍किन्‌खोःसुआङ् आनिगे़ओ थाःसुबान् खिनिॽ आबाङे के़निःसुम् के़घे़प्‍सुम्‍माङ् के़वयिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","दाउद हाङ्‌ङिङ्‌ग साङ्‌ग्राम्‍पेदाङ् थाःङ् मे़बेने़न्‍छाङ् खुने़ॽग आबाङे अक्‍खे पाःत्तु, यहवे दाङ्‌बाल्‍ले़ आन्‍दाङ्‌बान् अक्‍खे मे़त्तु, ‘खे़ने़ॽ के़निङ्‌मिहाॽ मे़नाःन्‍दुङ्‌सिङ्‌ङिल्‍ल थारिक् आजुप्‍साङ् ले़प्‍माङ् युङे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","हे़क्‍केःल्‍ले़ खिनिॽ नु काक्‌इस्राइलस्‍मा हिम्‍सयङ्‌हाॽरे़ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् के़भोःन्‍दुम्‍बा ये़सुःन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कन् दाङ्‌बा नु सेःन्‍दुबा ख्रिस्‍त चोगुआङ् वाॽ के़लॽबान् कुसिङ् निःप्‍माए पोःङ्‌॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","आल्‍ल कन् पाःन् के़घे़म्‍बाहाॽरे़ खुनिॽ योःम् पुॽरे़आङ् पत्रुस नु वेॽ सेःक्‌युक्‍मिबाहाॽ सेःन्‍मे़दोसुसि, “फुॽनुसाॽसे, आल्‍ल आनिगे़ थे चोगुम्‍बे़बाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","हे़क्‍क्‍याङ् पत्रुसरे़ मे़त्तुसि, “खिनिॽ के़रे़क् लायोलाम् हिन्‍दे़म्‍मे़ॽआङ् दाङ्‌बाओ नुःक्‍खे़म्‍मे़ॽ, हे़क्‍क्‍याङ् लायोलाम् ले़प्‍मि खोःमा फाॽआङ् ये़सु ख्रिस्‍तरे़ कुमिङ्‌ङो बप्‍तिस्‍मा पोःक्‍खे़म्‍मे़ॽओ! हे़क्‍क्‍याङ् सेसेमाङ्‌ङिल्‍ले़न् पर्धाःम् के़घोःसुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","थेआङ्‌भे़ल्‍ले़ कन् सेसेमाङ्‌ङिल्‍ले़न्‌माङ्‌हे़क्‍किङ्‌ग खिनिॽ लागि नु खिनिॽ मुॽइदाङ्‌साहाॽरे़ लागि, हे़क्‍क्‍याङ् दाङ्‌बा आनिॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ उःत्तुसिबा माःङ्‌घा माःङ्‌घाबा के़रे़क् मनाहाॽरे़ लागिरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","हे़क्‍क्‍याङ् खुने़ॽ यरिक् पाःन् पाःत्तुर साम्‍दिङ् पिरुसिआङ् “कन् फे़न् याप्‍मिहाॽरे़ मे़घोःसुबा खुम्‍दिङ्‌लाम् से़ःप्‍पासिम्‍मे़ॽओ” मे़त्तुसिर खाहुन् पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","हे़क्‍केःल्‍ले़ कन् पाःन्‍जान् नसाःन् के़जोःक्‍पाहाॽ बप्‍तिस्‍मा मे़बोःक्‍खे़आङ् बा खे़न् ये़न्‍नो हे़न्‍छिङ् सुम्‍सि (३०००) यारिक् मनाहाॽ खे़ङ्‌हाॽओ मे़योॽसिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","हे़क्‍क्‍याङ् खे़ङ्‌हाॽ सेःक्‌युक्‍मिबाहाॽरे़ खुनिॽ निसाम्‍मिन् नु सेसे तङ्‌जुम्‍मो, हे़क्‍क्‍याङ् तुवा चोःक्‍मा नु मिःम् साभाङ्‌जा चामाओ चक्मे़ल्‍लॽए मे़बत्‍छे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","सेःक्‌युक्‍मिबाहाॽरे़ यरिक् मिक्‍सेःन्‍हाॽ नु निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ मे़जोगुबाल्‍ले़ के़रे़क् मनाहाॽरे़ खुनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","हे़क्‍क्‍याङ् नसाःन् के़जोःक्‍पाहाॽ सोसोरिक् मे़युङे़ मे़वये़॥ हे़क्‍केलॽरिक् खुनिॽ चिगोःक्‌वाहाॽआङ् सोरिक् ओगप् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","हे़क्‍क्‍याङ् कुभारे़ खुनिॽ याङ्‌साकुन्‍धेहाॽ चिगःक्‌वाहाॽ मे़सङ्‌घुर चायोःम्‍बोओ के़वाॽबा मनाहाॽ याङ्‌ङिन् मे़हाःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","खे़ङ्‌हाॽ थिक्‍हुप् मे़बोःक्‍खे़आङ् थिक्‌याःन्‍धक् माङ्‌हिम्‍मो मे़बेर खुनिॽ हिम् हिम्‍मो मिःम् साभाङ्‌जा मे़जरो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़सःत्ते़र खुनिॽ निङ्‌वाॽ त्‍ये़आङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा मे़भोःसुआङ् के़रे़क् मनाहाॽरे़ खे़ङ्‌हाॽ नुःरिक् मे़मे़त्तुसिरो॥ हे़क्‍क्‍याङ् दाङ्‌बाल्‍ले़ थिक्‌याःन्‍धक् से़न्‍लप् के़घोःबा मनाहाॽ खुने़ॽओ फोःसुसिर तेॽरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","थिक्‌ये़न् ले़न्‍दिक् कुमुक् सुम्‍सिबा तुवा चोःक्‍मा ये़म्‍मो पत्रुस नु युहुन्‍नाःन् माङ्‌हिम्‍मो पेसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","खे़प्‍मो, कुघे़म्‍सिङ् नुःबा मे़प्‍मनाबा लाम्‍धेःप्‍पो, मनाहाॽरे़ सावाःन्‍छिङ्‌ङाङ्‌धोए कुलाङ् के़सक्‍पा मनाःन् माङ्‌हिम्‍मो तुवा चोःक्‍से़ के़बेःक्‍पाहाॽ याङ् नाःक्‍तुसिर फाॽआङ् थिक्‌याःन्‍धक् मे़बक्‍खु मे़दारुआङ् मे़युक्‍खुर मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","खे़ल्‍ले़ पत्रुस नु युहुन्‍नाःन् माङ्‌हिम्‍मो पेसिर पत्‍छे़त्‍छिबा निःसुसिआङ् याङ् नाःक्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","हे़क्‍केःल्‍ले़ पत्रुस नु युहुन्‍नाःन् खुने़ॽले़प्‍माङ् नुःरिक्‍काङ् ओमये़त्‍छि हे़क्‍क्‍याङ् पत्रुसरे़ मे़त्तु “आन्‍छिगे़ याप्‍मि ओआमे़त्ते़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","खे़ल्‍ले़आङ् थेःन्‍नि खोःसुङ्‌ङिया फाॽआङ् ओमे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","पत्रुसरे़ मे़त्तु, “इङ्‌गाॽ थेआङ् मे़गत्तान्‍लो, कर इङ्‌गाॽ थेःन् कत्तुङ् बाखे़न्‍ने पिने़–नासरतस्‍मा ये़सु ख्रिस्‍तरे़ कुमिङ्‌ङो खे़ने़ॽ पोगे़ॽआङ् लाङ्‌घेगे़ॽ॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","हे़क्‍क्‍याङ् पत्रुसरे़ खे़न् लाङ्‌सक्‍पे़ल्‍ले़ कुजुप्‍साङ् हुक्‍किन् ते़म्‍सुआङ् फोःक्‍खु॥ हे़क्‍केःल्‍ले़ खे़न् मनाःल्‍ले़ कुलाङ् नु कुलाङ्‌मिक्‍को थुम् लाःसे़आङ् ");
INSERT INTO lifNT2_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","पिच्‍चाक् पिन्‍दे़र तक्‍पे़त् ये़म्‍सिङ् हे़क्‍क्‍याङ् लाङ्‌घेःक्‍मा हेःक्‍ते़रो॥ हे़क्‍क्‍याङ्‌ग खे़ङ्‌ग लाङ्‌घेगे़र, पिच्‍चाक् पिन्‍दे़र, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःसुर पत्रुस हे़क्‍क्‍याङ् युहुन्‍नाःन्‍नु माङ्‌हिम्‍सिगाङ् पेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","खे़प्‍मोबा काक् मनाहाॽरे़ खे़न् लाङ्‌घेगे़बा नु निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनारा फोःसुबा मे़निःसुल्‍ले़ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","खे़ङ्‌ग माङ्‌हिम्‍मिल्‍ले़ कुघे़म्‍सिङ् नुःबा मे़प्‍मनाबा लाम्‍धेःप्‍पो सदादिङ् चानाःक्‍नु के़युङ्‌बा नु लाङ्‌घेःक्‍मा मे़न्‍छुक्‍मनाबा मनाःन्‍ने फाॽआङ् कुसिङ् मे़निःत्तुआङ् साॽरिक् खुनिॽ निङ्‌वाॽ मये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","हे़क्‍केःल्‍ले़ खे़न् मनाःल्‍ले़ पत्रुस नु युहुन्‍नाःन् ते़म्‍सुसिर माङ्‌हिम्‍मोबा सोलोमनरे़ कुआःम्‍भो मे़प्‍मनाबा ते़न्‍नो वये़॥ खे़प्‍मो मनाहाॽ मे़लोःक्‍ते़र मे़द्‌ये़आङ् खुनिॽ खिरि मे़जुप्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","हे़क्‍क्‍याङ् पत्रुसरे़ खे़ङ्‌हाॽ ओमे़त्तुसिर मे़त्तुसि, “इस्राइलिसे, कन् पाःन्‍नो थेआङ् खिनिॽ निङ्‌वाॽ मये़बाबे? थेआङ् कन् मनाःन् आन्‍छिगे़ मुक्‍साम् नु साम्‌योबाल्‍ले़ लाङ्‌गे़घेःक्‍पा चोगुबा फाॽआङ् याप्‍मि ओगे़मे़त्तिबाबे? ");
INSERT INTO lifNT2_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहाम, इसहाक नु याकुब हे़क्‍क्‍याङ् आनिॽ वेॽ पाधे़बाहाॽरे़ खुनिॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसेवारोबा ये़सुःन् मिमिदिङ् चोगुआङ् वाॽरो॥ खुने़ॽ के़दे़म्‍सुम्‍माङ् हाङ्‌युक्‍पाहाॽरो से़त्‍छे़ हुक्‍के़सुप्‍तुम्॥ सुहाङ्‌गे़म्‍बा पिलातसरे़ खुने़ॽ ले़प्‍मा निङ्‌वाॽ चोगुसाङ् खिनिॽ के़नाॽरुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","खिनिॽ सेसे नु साम्‌योनिबा मनाःल्‍ले़ कुले़क्‌वा मना के़से़प्‍पे़न् ले़रे़म्‌आबिरे़म्‍मे़ॽ फाॽआङ् के़नाःक्‍तुम्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","अक्‍खेलॽरिक् खिनिॽ ने़त्तिगे़न् हिङ्‌मन्‍ले़ कुबुन्‍निन् से़प्‍मा के़बाङ्‌घुम्‍सिम्, कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽग कुसिवे़त्‍लाम् कुहिङ्‌वे़त् चोगुरो॥ खे़न् पाःन्‍निल्‍ले़न् तोःन्‍दि आनिगे़ वयिगे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","हे़क्‍क्‍याङ् ये़सुओबा नसाःन्‍निल्‍ले़ चोगुल्‍ले़ कन् कुसिङ् के़निःत्तुम्‍बा मनाःन् के़धुम्‍बा पोःक्‍खे़बा के़निःसुम्‍माङ् के़वयिॽरो॥ खे़न् ये़सुओबा नसाःन्‍निल्‍ले़ कन् मनाःन् बा खिनिॽ तगिए वेःत्ते़आङ् वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","आल्‍ल फुॽनुसाॽसे, खिनिॽ सुहाङ्‌युक्‍पाहाॽरे़ ये़सुःन् ताप्‍फे़ःल्‍लिक् मे़मे़त्तुबा हे़क्‍के खिनिॽग थेआङ् मे़न्‍निए मे़ल्‍ले़ए कन् के़जोगुम्‍बारो फाॽआङ् इङ्‌गाॽ निङ्‌वाॽ कत्तुङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़ल्‍ले़ग तुक्‍खे चामाआङ् सिःमाए पोःङ् फाॽआङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽलाम् पाःत्तुबान् के़रे़बारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","खे़ल्‍ले़ चोगुल्‍ले़ आल्‍लो खिनिॽ लायोलाम् हिन्‍दे़म्‍मे़ॽआङ् दाङ्‌बाओ नुःक्‍खे़म्‍मे़ॽओ॥ हे़क्‍केलॽरिक् खिनिॽ लायो लासोःत्‍हाॽ माबेःक्‍नि, हे़क्‍क्‍याङ् निङ्‌वाॽफु दाङ्‌बालाम् याम्‍साम्‍मो के़धुम्‍बा पोःङ्‌मा ये़म् तानिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","हे़क्‍केलॽरिक् खुने़ॽ तगिसा सेःन्‍दुबा ख्रिस्‍ते़न्‌खिनिॽओ याम्‍मो के़बाङ्‌घि के़बिरिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ तगिनुसाए कुसेसे माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ मे़बाःत्तुबा कुइसिःक् के़रे़क् पाःन्‍हाॽ याम्‍मो कुसङ् मे़न्‍जोःक्‍के थारिक् ये़सु ख्रिस्‍ते़न्‌साङ्‌ग्राम्‍पेदाङ्‌ङो वाॽमा पोःङ् फाॽआङ् पाःत्तुआङ् वाॽ॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","मोसारे़आङ् माङ्‌धुक्‍नाःल्‍ले़ कुयाःम्‍बेओ अक्‍खे पाःत्तुआङ् वाॽ, ‘निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ इङ्‌गाॽ हे़क्‍तङ्‌बा माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़न्‌खिनिॽ फुॽनुसाॽलाम् फोःक्‍खुॽरो॥ कुबाःन्‍निन् खिनिॽ के़घे़प्‍सुम्‍ल पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","खे़न् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पे़ल्‍ले़ कुबाःन्‍निन् मे़ङ्‌घे़म्‍मनाबाहाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमनाहाॽलाम् मे़से़न्‍नाङ् मे़मे़क्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","हे़क्‍क्‍याङ् सामुए़ल्‍लाङ्धो याङ्‌सिबा काक् माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाहाॽरे़ हाबा कन् ये़न्‍हाॽरे़ कुयाःम्‍बेओ माङ्‌निङ्‌वाॽपाःन् मे़बाःत्तुआङ् मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽ पाधे़बाहाॽनु चोगुबा माङ्‌हुप्‍पिन् खिनिॽआङ् के़घोःसुम्‍माङ् के़वयिॽरो॥ खुने़ॽ अब्राहाम्‍मिन्‌अक्‍खे मे़त्तु, ‘खे़ने़ॽ के़मुॽइदाङ्‌सालाम्‍मे इक्‍सादिङ् खाम्‍बेःक्‍मोबा काक् सुवाङ्‌गे़न्‌सयङ्‌हाॽरे़ मुॽइसाम् मे़घोःसुॽरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","हे़क्‍केलॽरिक् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खिनिॽ फे़न् याःम्‍बक्‍कोलाम् नुःक्‍मासिआङ् मुॽइसाम् पिमासि फाॽआङ् खुने़ॽ आबाङे कुसेवारोबान् काक्‍नु तगि खिनिॽ इस्राइलिहाॽरो पाङ्‌घुआङ् वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","पत्रुस नु युहुन्‍नारे़ मनाहाॽ इङ्‌भोःसे़त्‍छुर यागे़त्‍छिल्‍ले़ निङ्‌वाॽफुसाम्‍बाहाॽ, माङ्‌हिम् के़गोःबा थक्‍सुबाहाॽरे़ खुनिॽ थक्‍तुम्‍बा नु कुभा सदुकिहाॽ खे़प्‍मो मे़द्‌ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","खे़ङ्‌हाॽरे़ ये़सुःन् कुसिःमे़न्‍लाम्‌याम्‍मो हिङे़बा हे़क्‍केए वेॽ मे़न्‍छाम् याप्‍मिरे़न् सिःमे़न्‍लाम् याम्‍मो हिङ्‌मन् वाॽ फाॽआङ् पाःन् इङ्‌भोःसे़त्‍छुबा मे़घे़प्‍सुबाल्‍ले़ खे़ङ्‌हाॽरे़ खुनिॽ साॽरिक् सिक्‍चिगे़ लॽरे़, ");
INSERT INTO lifNT2_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","खे़ङ्‌हाॽरे़ पत्रुस नु युहुन्‍नाःन् मे़दे़म्‍सुसि हे़क्‍क्‍याङ् खादामे़ पेबाल्‍ले़ चोगुल्‍ले़ नाम्‍दाःत्ताःत् पुङ्‌लाहिम्‍मो मे़साक्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","कर खे़न् पाःन्‍जाक् के़घे़म्‍बाहाॽओ यरिक् मनाहाॽरे़ नसाःन् मे़जोगु॥ नसाःन् के़जोःक्‍पा मनाहाॽ मे़बोःरे़आङ् ये़म्‍बित्‍छाहाॽरक्‌हे़न्‍छिङ् ङासि (५०००) यारिक् मे़गे़रे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","हे़क्‍क्‍याङ् कुदाःन्‍दिक्‍मा सुहाङ्‌युक्‍पाहाॽ, यहुदि तुम्‍लाम्‍लोःबाहाॽ नु साम्‌योथिम्‍साम्‍बाहाॽ यरुसले़म्‍मो चुम्‍लुङ् मे़जोगे़॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","खे़प्‍मोआङ् मानिङ्‌वाॽफुसाम्‍बा हन्‍नास, हे़क्‍क्‍याङ् कैयाफास, युहुन्‍ना, अले़क्‍जे़न्‍दर हे़क्‍क्‍याङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ कुहिम्‍सयङ्‌ङो के़वाॽबा वेॽ मनाहाॽआङ् मे़जुप्‍से़आङ् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ युहुन्‍ना नु पत्रुसे़न् खुनिॽ तगि मे़दारुसिआङ् अक्‍खे मे़मे़त्तुसिर सेःन्‍मे़दोसुसि, “आत्तिन् मुक्‍साम्‍लाम् इग्र हाःत्‍ले़ कुयुक्‍को अक्‍खेलॽरिक् निङ्‌वाॽ के़माबा याःम्‍बक् के़जोगे़त्‍छुबाबे?” ");
INSERT INTO lifNT2_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","हे़क्‍क्‍याङ् सेसेमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍मिल्‍ले़ थुक्‍तुआङ् पत्रुसरे़ खे़ङ्‌हाॽ मे़त्तुसि, “मनाहाॽरे़ खुनिॽ सुहाङ्‌युक्‍पाहाॽ नु तुम्‍लाम्‍लोःबासे, ");
INSERT INTO lifNT2_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","आइन् आन्‍छिगे़ कन् लाङ्‌सक्‍पा मनाःन् लुङ्‌माॽ तुक्‍ते़छुगे़आङ् वेःत्ते़बा नुःबा याःम्‍बक्‍किल्‍ले़ लागि खिनिॽ तगाङ् सेःन्‍दोःसे़ याप्‍मि के़दारिबाने़ फाॽग्र, ");
INSERT INTO lifNT2_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","आल्‍ल खिनिॽ नु वेॽ इस्राइलबा काक् मनाहाॽरे़ कन् कुसिङ् निःत्ते़म्‍मे़ॽओ, नासरतस्‍मा ये़सु ख्रिस्‍तरे़ कुमुक्‍साम्‍लाम् कन् मनाःन् खिनिॽ तगि वेःत्ते़आङ् ये़प्लो॥ ये़सुःङ्‌ग खिनिॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःम्‍मा से़प्‍मा के़बाङ्‌घुम्‍सिम्, कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽग कुसिवे़त्‍लाम् कुहिङ्‌वे़त् चोगुआङ् फोःक्‍खुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","खुने़ॽ कुमे़न्‍नो साम्‌योसाप्‍लाःल्‍ले़ अक्‍खेलॽरिक्‌पाःत्तुआङ् वाॽ, ‘खिनिॽ लुङ् के़गाम्‍बाहाॽरे़ के़नाॽरुम्‍बा लुङ्‌ङिन् खुने़ॽएरो, कर आल्‍लो मालुङ् पोःक्‍खे़रो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ये़सुलाम्‍लक् से़न्‍लप् वाॽ, थेआङ्‌भे़ल्‍ले़ आनिॽ मे़न्‍छाम्‍गे़न् याप्‍मिहाॽ से़न्‍लप् याप्‍मि के़बिबा इक्‍सादिङ् खाम्‍बेःक्‍मो वेॽ हाःत्ताङ् होःप्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","आल्‍ल यहुदि ये़जुम्‍भोबा पासिङ्‌पादाङ्‌लाहाॽरे़ पत्रुस नु युहुन्‍नाःन् साप्‍ला मे़न्‍निःप्‍मना मे़न्‍जोबा वये़त्‍छिसाङ्‌खुन्‍छिॽ आःन्‍छिङ्‌मान् मे़निःसुआङ् खुनिॽ निङ्‌वाॽ मये़रो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ कन् मनाहाॽ ये़सुःन्‍नु वये़त्‍छिबा निङ्‌वाॽ मे़घोःसु॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","कर खे़न् के़वेःप्‍पा मनाःन्‍नाङ् खे़ङ्‌हाॽनुए ये़बे़बा मे़निःसुबाल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खुनिॽ तक्‍ले़ङ्‌वाओ थेआङ् पाःप्‍मा मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ पत्रुस नु युहुन्‍नाःन् ये़जुम्‍भोलाम् लाःक्‍कात् मे़लःत्तुसि हे़क्‍क्‍याङ् अक्‍खेलॽरिक् पाःन् मे़धक्‍ते़रो, ");
INSERT INTO lifNT2_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“आल्‍ल कन् मनाहाॽ थे मे़प्‍मासिबे? कङ्‌हाॽरे़ग निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ मे़जोगुबान् यरुसले़म के़युङ्‌बा काक् मनाहाॽरे़ मे़निःसुआङ् मे़वाॽ॥ खे़ल्‍ले़ चोगुल्‍ले़ आनिॽआङ् कन् मे़ःन् फाॽआङ् पाःप्‍मा सुक्‍मे़दे़त्‍ने़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","कर कन् पाःन्‍निन् मनाहाॽओ मे़से़ने़न्‍ल फाॽआङ् खे़ङ्‌हाॽ आल्‍लआङ्धो ये़सुरे़ कुयाःम्‍बेओ हुॽमा ले़रे़छे़ॽ फाॽआङ् साम्‍दिङ् पिमासि पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ याम्‍मो मे़उःत्तुसिआङ् ये़सुरे़ कुयाःम्‍बेओ पाःप्‍मा इग्र हुॽमा ले़रे़से़ॽ फाॽआङ् इङ्‌जाःङ् मे़बिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","कर पत्रुस नु युहुन्‍नारे़ नोगप् पिरुसि, “आल्‍ल निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिःमाओ खिनिॽ के़बाःत्तुम्‍बान् खे़म्‍मा नुःबाबि, निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ पाःत्तुबान् खे़म्‍मा नुःबाबि? खिनिॽए निङ्‌वाॽ इःत्ते़म्‍मे़ॽओ! ");
INSERT INTO lifNT2_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","कर आन्‍छिगे़ ये़सुरे़ चोगुबा पाःन् निःसुसिगे़ हे़क्‍क्‍याङ् खे़प्‍सुसिगे़बा पाःन्‍हाॽ मे़म्‍बाःत्ते वाॽमा मे़सुक्‍सुगे़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","आल्‍ल काक् मनाहाॽरे़ खे़प्‍मो पोःक्‍खे़बा हिन्‍दोःक्‍किन् मे़निःसुआङ् निङ्‌वाॽफुमाङ्‌ङिन् नोगे़न् मे़बिरुर कुनारा मे़भोःसुबाल्‍ले़ चोगुल्‍ले़ कन् मनाहाॽ आक्‍खेलॽरिक् खुम्‍दिङ् पिमासि फाॽआङ्‌आप्‍तिक्‌कुःप्‍मा लाम् खोःमा मे़न्‍छुक्‍तुन्‍लो॥ खे़ल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ सेःक्‌युमिबाहाॽ याम्‍मो यङ्‌मा मे़से़रुसिआङ् मे़बाङ्‌घु मे़देःसुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","अक्‍खेलॽरिक् निङ्‌वाॽ के़माबा याःम्‍बक्‍लाम् के़वेःप्‍पा मनाःन् तङ्‌बे लिबोःङ्‌(४०) के़गे़प्‍पा वये़॥ खे़ङ्‌ग सावाःन्‍छिङ्‌ङाङ्धोए लाङ्‌मे़ङ्‌घेःक्‍मनाबा वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","हे़क्‍केलॽरिक् मे़ले़रुसिआङ् पत्रुस नु युहुन्‍नाःन्‌वेॽस्‍मा नसानिबाहाॽ तुम्‍से़ पेसि हे़क्‍क्‍याङ् तुम्निङ्‌वाॽफुसाम्‍बाहाॽ नु यहुदि तुम्‍लाम्‍लोःबाहाॽरे़ मे़मे़त्तुसिबा पाःन्‍हाॽ चे़क्‍खे़त्‍छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ कन् पाःन्‍निन् मे़घे़प्‍सुआङ् थिक्‍हुप् नु थिक्‍मुरा मे़बोःक्‍खे़आङ् अक्‍खेलॽरिक् तुवा मे़जोगे़, “आनिगे़ मुक्‍साम्‍दाङ्‌बाए, खे़ने़ॽग ताङ्‌साक्‍पे़न्‌, इक्‍सादिङ् खाम्‍बेःक्‍मान्, वाहङ्‌हाॽ हे़क्‍क्‍याङ् खे़प्‍मो के़वाॽबा के़रे़क् पाःन्‍हाॽ के़जोगुसिबारो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","उन्‍छेःन् खे़ने़ॽग आनिगे़ ताक्‍थे़बा दाउदरे़ कुमुराओलाम् खे़ने़ॽ के़सेवारोबाल्‍ले़ कुमे़न्‍नो सेसेमाङ्‌लाम् अक्‍खे के़बाःत्तुरो– ‘थेआङ् थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽरे़ खुनिॽ सिक्‍किन् आदक्‍ले़ङ्‌वाओ पोःक्पे? हे़क्‍क्‍याङ् थेआङ् मे़न्‍छाम्‍गे़न् याप्‍मिहाॽरे़ हने़बा निङ्‌सेःक् मे़जोगुबे? ");
INSERT INTO lifNT2_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","हे़क्‍क्‍याङ् इक्‍सादिङ् खाम्‍बेःक्‍मोबा हाङ्‌हाॽ नु सुहाङ्‌युक्‍पाहाॽ थिक्‍हुप् मे़बोःङ्‌ङाङ् दाङ्‌बा नु निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍ते़ल्‍ले़ कुदक्‍ले़ङ्‌वाओ मे़जुम्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","से़क्‍खाए बा खे़न् पाःन्‍निन् कन् ये़क्‌यक्‍को के़रे़आङ् वाॽ, थेआङ्‌भे़ल्‍ले़ हे़रोद हाङ्‌ङिन्, सुहाङ्‌गे़म्‍बा पन्‍तियस पिलातस, थिम्‍मे़न्‍दङ् सुवाङ्‌हाॽ नु इस्राइलिहाॽरे़ खे़ने़ॽ के़निङ्‌सेःक्‍को के़सेगुबा सेसे के़सेवारोबा ये़सुरे़ कुदक्‍ले़ङ्‌वाओ कन् ये़क्‌यक्‍को मे़जुप्‍से़आङ् मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","खे़ने़ॽ के़निङ्‌सेःक् पोःङ्‌नि फाॽआङ् तगिसा के़मुक्‍साम् नु के़निङ्‌वाॽरे़ के़इःत्तुबा पाःन्‍निन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","दाङ्‌बे, आल्‍ल खे़ङ्‌हाॽरे़ यङ्‌मा मे़से़रिगे़बान्‌निङ्‌वाॽ इःत्ते़ॽओ, हे़क्‍क्‍याङ् के़सेवारोबाहाॽ पेलिगे़न् के़बाःन्‍जाक्‍किन् हाङ्‌हाङ्‌ङाङ् पाःप्‍मा याप्‍मि के़धुम्‍बा आजोगे़ॽओ॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","हे़क्‍क्‍याङ् सेसे के़सेवारोबा ये़सुरे़ कुमुक्‍साम्‍लाम् मनाहाॽ मे़वेःत्‍नि, हे़क्‍क्‍याङ् यरिक् मिक्‍सेःन् नु निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ पोःङ्‌नि फाॽआङ् के़हुक्‍किन् सन्‍छे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","खे़ङ्‌हाॽरे़ तुवा मे़जोगु मे़सुरुल्‍ले़ मे़जुप्‍से़आङ् मे़वये़बा ते़न्‍निन् लुप्‍लि थाङे़बा हे़क्‍के साॽरिक् यक्‍खे़॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ काक् सेसेमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍मिल्‍ले़ थुक्‍तुसिआङ् निङ्‌वाॽफु पाःन्‍जाक्‍किन् मे़ङ्‌गिए मे़बारे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","आल्‍ल नसाःन् के़जोःक्‍पाहाॽ थिक् निङ्‌वाॽ थिक् मुरा मे़बोःक्‍खे़आङ् खुनिॽ मे़गत्तुबाःन्‌इङ्‌गाॽइन् मे़ल्‍लॽए के़रे़क्‍ले़ थिक् निङ्‌वाॽ थिक् हुप्‍पो मे़याङुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","हे़क्‍क्‍याङ् सेःक्‌युक्‍मिबाहाॽरे़ पयम् मुक्‍साम्‍नु ये़सुःन् सिःमे़न्‍लाम् याम्‍मो हिङे़बा पाःन्‍हाॽरे़न् तोःन्‍दि मे़बिरुआङ् खे़ङ्‌हाॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ हाङ्‌वागे़न् मुॽइसाम् थाःसु पिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","खुनिॽ लुम्‍मो चायोःम्‍बोओ के़वाॽबा मनाहाॽ मे़होःप्‍ते़, थेआङ्‌भे़ल्‍ले़ कुभारे़ मे़गत्तुबा याङ्‌साकुन्‍धे, हिम्‍धाःङ्, लाजेॽ सिङ्‌बुङ्‌हाॽ मे़सङ्‌घुआङ्‌खे़न् याङ्‌ङिन् सेःक्‌युक्‍मिबाहाॽरो मे़दारु, हे़क्‍क्‍याङ् मनाहाॽरे़ खुनिॽ चायोःम्‍बो कुइसिःक् मे़हाःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","हे़क्‍के के़जोःक्‍पाओ युसुफ मिङ् के़वाःप्‍पा ले़बि थाःक्‍कोबा सैप्रस वागप्‍खाम्‍मो सागे़वाःन्‍छिङ्‌बाधिक् वये़॥ खुने़ॽ कत्तुबा प्‍याङ्‌सिःन् सङ्‌घुआङ् याङ्‌हाॽ सेःक्‌युक्‍मिबाहाॽरो तारुरो॥ सेःक्‌युक्‍मिबाहाॽरे़ खुने़ॽ बरनाबास मिङ्‌मे़लोःक्‍खु (खे़न् फाॽइन् हाङ्‌हाङ् के़जोःक्‍पा साः पोःङ्‌लो)॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","कर खे़प्‍मो हननिया मे़प्‍मनाबा ये़म्‍बित्‍छाॽइल्‍ले़ कुमेःत् सफिराःन्‍नु खुन्‍छिॽ लक्‍कोबा कुभा लाजेॽधिक् सङ्‌घे़त्‍छुआङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","कुभा याङ्‌ङिन् कुमेःत्तिल्‍ले़ निःसुर चिक्‍खुलारु हे़क्‍क्‍याङ् कुभा याङ्‌ङिन् सेःक्‌युक्‍मिबाहाॽरो तारुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","कर पत्रुसरे़ सेःन्‍दोसु, “हननियाए, खे़ने़ॽ अक्‍खेलॽरिक् सेसेमाङ्‌ङिन् इङ्‌ले़क्‍मा फाॽआङ् के़निङ्‌वाॽइन्‌थेआङ्‌ने़ माफे़न्‍साम्‍मिन् थिम्‍मा के़बाङ्‌घुबाबे? थेआङ् खे़ने़ॽ कुभा याङ्‌ङिन् के़लारुआङ् काक् याङ् के़बिबा के़लाम्‍सिङ्‌बाबे? ");
INSERT INTO lifNT2_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","कङ्‌ग मे़न्‍छङ्‌ङे वये़साङ् खे़ने़ॽइन्‍नेसे़ वये़बा! आल्‍लो के़सङ्‌घुआङ्‌साङ् बा के़हुक्‍कोएसा याङ्‌ङिन् वाॽबा! अक्‍खेलॽरिक् थेआङ् खे़ने़ॽ के़निङ्‌वाॽओ ताप्‍फे़ःम्‍बा के़इःत्तुबाबे? खे़ने़ॽग मे़न्‍छाम्‍गे़न् याप्‍मिःन्‍लक् मे़ःन्, कर निङ्‌वाॽफुमाङ्‌ङिन्‍नाङ् इङ्‌गे़ले़क्‍तुआङ्‌वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","हे़क्‍क्‍याङ् हननियारे़ कन् पाःन्‍निन् खे़प्‍सुनुमे़ःन्‍ने हर्गुप्सा चोःन्‍दे़आङ् कुसक्‍मा पेरो॥ हे़क्‍क्‍याङ् खे़प्‍मो खे़न् के़घे़म्‍बा काक् मनाहाॽ साॽरिक् मे़गिसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","हे़क्‍क्‍याङ् खे़प्‍मो कुभा थाङ्‌बे़न्‍हाॽरे़ चे तेःत्तिल्‍ले़ मे़गित्तु हे़क्‍क्‍याङ् लाःक्‍कात् मे़देॽरुआङ् मे़लुप्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","हे़क्‍क्‍याङ् कुमुक् सुम्‍सि एगाङ् हननियारे़ कुमेःत्तिन् कुये़म्‍बाॽइन् थे़मा पोःक्‍खे़ के़लॽबा थेआङ् निङ्‌वाॽ मे़ङ्‌घोए खे़प्‍मो त्‍ये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","पत्रुसरे़ खे़न् सेःन्‍दोसु, “हननियारे़ कुलाजेन् सङ्‌घुआङ् खोःसुबा कुमे़ल्‍लुङ् याङ् बा कम्‍म्‍याक्‍लक्पि?” हे़क्‍केःल्‍ले़ खे़ल्‍ले़आङ् नोगप् पिरु, “ओरो! कुमे़ल्‍लुङ् याङ्‌ग बा खे़म्म्‍याक्‍लक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","हे़क्‍केःल्‍ले़ पत्रुसरे़ खे़न् मे़त्तु, “आक्‍खेलॽरिक् दाङ्‌बाल्‍ले़ कुसेसेमाङ्‌ङिन् साॽमा फाॽआङ् खिन्‍छिॽ निङ्‌वाॽइन्‌के़दङ्‌घे़त्‍छुबे? खे़प्‍से़ॽओ, खे़ने़ॽ के़गाप्‍पोबे़न् के़लुप्‍पाहाॽ खा लाम्‍धेःप्‍पो मे़गे़त्‍लरक् मे़बत्‍लो॥ खे़ङ्‌हाॽरे़ के़धक्‍किन्‍नाङ् मे़बक्‍खुआङ् मे़देॽरुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","खिमो पत्रुसरे़ कुलाङ्‌जक्‍पो खे़न् हर्गुप्सा चोःन्‍दे़आङ् कुसक्‍मा पेरो॥ हे़क्‍क्‍याङ् खे़न् थाङ्‌बे़न्‍हाॽ सिगाङ् मे़लाःसे़ल्‍ले़ खे़न् स्‍ये़बा मे़निःसु, हे़क्‍क्‍याङ् मे़बक्‍खु मे़देॽरुआङ् कुये़म्‍बाॽइल्‍ले़ कुबेसाङ् मे़लुप्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","हे़क्‍क्‍याङ् खे़न् पाःन् के़घे़म्‍बा मनाहाॽ नु सेसेहुप्‍लक्‍कोबा मनाहाॽ साॽरिक् मे़गिसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","हे़क्‍क्‍याङ् सेःक्‌युक्‍मिबाहाॽरे़ यरिक् मिक्‍सेःन् नु निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ मनालुम्‍मो मे़जोगुरो॥ हे़क्‍क्‍याङ् के़रे़क् नसाःन् के़जोःक्‍पाहाॽ ए़त्‍ले़ङ् सोलोमनरे़ कुआःम्‍भोओ सोसोरिक् मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","नसाःन् मे़न्‍जोःक्‍मनाबाहाॽरे़ खुनिॽनु तङ्‌सिङ्‌मा फाॽआङ् आःन्‍छिङ्‌मा मे़न्‍छुक्‍तुन्, कर खे़ङ्‌हाॽरे़ साॽरिक् मिङ्‌सो इङ्‌धाःङ् मे़बिरुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","हे़क्‍केसाङ् दाङ्‌बान् नसाःन् के़जोःक्‍पा मे़न्‍छुमाॽ नु ये़म्‍बित्‍छाॽहाॽ आल्‍लसाङ् यरिक् मे़योॽसिङ्‌ल मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","हे़क्‍केःल्‍ले़ सेःक्‌युक्‍मिबाहाॽरे़न् निङ्‌वाॽ के़माबा याःम्‍बक्‍किल्‍ले़ चोगुल्‍ले़ पत्रुसे़न् खे़प्‍मोलाम् पेःक्‍किल्‍ले़ कुसाम्‍म्रिःप्‍पे़न् के़दुक्‍पा सम्‍दाङ् चुक्‍काङ् मे़वेःत्‍ल फाॽआङ् मनाहाॽरे़ के़दुक्‍पा के़यॽबाहाॽ लाम्‍लाम्‍मो खुनिॽ ने़त्‍नाओ मे़ने़स्‍सुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","यरुसले़म खिरिबा पाङ्‌जुम्‍लाम्‍माङ् खे़प्‍मो मनाहाॽ मे़जुप्‍से़॥ खे़ङ्‌हाॽरे़ के़दुक्‍पा के़यॽबाहाॽ नु फे़न्‍साम्‍हाॽरे़ तुक्‍खे मे़जाःत्तुसिबाहाॽ खे़प्‍मो मे़दारुसि, हे़क्‍क्‍याङ् काक् मे़वेःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","हे़क्‍क्‍याङ् मानिङ्‌वाॽफुसाम्‍बा नु सदुकि लक्‍कोबा खुने़ॽ कुन्‍जुम्‍हाॽरे़ सेःक्‌युक्‍मिबाहाॽ साॽरिक् नामे़हे़त्तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ सेःक्‌युक्‍मिबाहाॽ मे़दे़म्‍सुसिआङ् पुङ्‌लाहिम्‍मो मे़साक्‍तुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","कर से़न्‍दिक् दाङ्‌बाल्‍ले़ पाङ्‌घुबा माङ्‌लाइङ्‌बे़न् त्‍ये़आङ् लाम्‍धेःप्‍पे़न्‌हन्‍दुबिरुसि, हे़क्‍क्‍याङ् लाःक्‍कात् लःत्तुसिआङ् मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“माङ्‌हिम्‍मो पेगे़म्‍मे़ॽआङ् कन् कुसङ् हिङ्‌मन्‍ले़ कुयाःम्‍बेओबा काक् पाःन्‍निन् मनाहाॽ इङ्‌भन् चोगे़म्‍सिम्‍मे़ॽओ॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","हे़क्‍क्‍याङ् कुदाःन्‍दिक् तानाम्‍सा माङ्‌हिम्‍मो मे़लाःसे़आङ् मनाहाॽ हुॽमा मे़हेःक्‍तुसिरो॥ बा खे़न् ये़म्‍मो मानिङ्‌वाॽफुसाम्‍बा नु कुन्‍जुम्‍हाॽरे़ यहुदि ये़जुम्‍भो नु काक् इस्राइलस्‍मा तुम्‍भाक्‍साहाॽरे़न् चुम्‍लुङ् मे़जोगुआङ् सेःक्‌युक्‍मिबाहाॽ पुङ्‌लाहिम्‍मोलाम् तारे़से़ॽ फाॽआङ् पुङ्‌लाइङ्‌बान् इङ्‌घङ् मे़हाक्‍तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","कर थक्‍सुबाहाॽ पुङ्‌लाहिम्‍मो मे़गे़रे़ल्‍ले़ सेःक्‌युक्‍मिबाहाॽ खे़प्‍मो मे़होःप्‍ते़, हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़नुःक्‍खे़ मे़बेआङ् अक्‍खे मे़मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“आनिगे़ पुङ्‌लाहिम्‍मो के़रिगे़ल्‍ले़ लाम्‍धेःप्‍पे़न्‌नुःरिक्‍काङ् ए़त्‍छिङ्‌ङाङ् पत्‍छे़, हे़क्‍क्‍याङ् थक्‍सुबाहाॽआङ् लाम्‍धेःप्‍पे़न्‌मे़गोःसुर मे़ये़बे़रो, कर आनिगे़ लाम्‍धेःप्‍पे़न्‌हम्‍नाःल्‍ले़ खे़प्‍मो हाःत्ताङ् मे़यागे़न्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","माङ्‌हिम् के़गोःबा थक्‍तुम्‍बान् नु तुम्निङ्‌वाॽफुसाम्‍बाहाॽरे़ कन् पाःन्‍निन् मे़घे़प्‍सुआङ् आल्‍ल थे पोःङ्‌बाबे फाॽआङ् खे़ङ्‌हाॽरे़ खुनिॽ हःन्‍दा ले़क्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","हे़क्‍क्‍याङ् खे़प्‍मो कुभा मनाधिक् फे़रे़आङ् अक्‍खे मे़त्तुसि, “खिनिॽ पुङ्‌लाहिम्‍मो के़साक्‍तुम्‍सिम्‍बा मनाहाॽरे़ग ना माङ्‌हिम्‍मोने़ ये़सुरे़ कुयाःम्‍बेओ मनाहाॽ मे़हुॽरुसिर मे़याक्‍लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","खे़न् थक्‍तुम्‍बाल्‍ले़ थक्‍सुबाहाॽ तेॽरुसिआङ् सेःक्‌युक्‍मिबाहाॽ थेआङ् मे़म्‍मे़त्‍छिङ्‌ङे ये़जुम्‍भोओ तारुसि, थेआङ्‌भे़ल्‍ले़ खे़ङ्‌हाॽ मनाहाॽरे़ लुङ्‌ङिल्‍ले़ आम्‍ले़प् आम्‍से़त् फाॽआङ् मे़गिसे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","खे़ङ्‌हाॽरे़ सेःक्‌युक्‍मिबाहाॽ ये़जुम्‍भो तगि मे़ये़प्‍सुसिआङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ खे़ङ्‌हाॽ मे़त्तुसि, ");
INSERT INTO lifNT2_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“आनिगे़ग ये़सुरे़ कुयाःम्‍बेओ मनाहाॽ थेआङ् मे़हुॽरे़म्‍सिम्‍मे़न्‍ने़ॽ फाॽआङ् इङ्‌जाःङ् पिआसिगे़आङ् वये़, कर खिनिॽग यरुसले़म्‍मो खिनिॽ निसाम्‍मिल्‍ले़ के़धिम्‍सुम्‍माङ् कन् मनाःल्‍ले़ कुसिःमे़ल्‍ले़ आप्‍तिक्‍किन् याप्‍मि कुःप्‍मा के़गोःत्तिआङ्‌के़वयिॽरो!” ");
INSERT INTO lifNT2_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","कर पत्रुस नु वेॽ सेःक्‌युक्‍मिबाहाॽरे़ नोगप् मे़बिरु, “आनिगे़ग खिनिॽ मनाहाॽरे़ पाःन्‍निन् खे़म्‍मानुःल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुइङ्‌जाःङ्‌ङिन्‍ने़ खे़म्‍मा पोःङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","खिनिॽ सिलाम्‍साक्‍मा सिङ्सम्‍दाङ् फोःम्‍मा से़प्‍मा के़बाङ्‌घुम्‍सिम्‍बा ये़सुःन् आनिॽ पाधे़बाहाॽरे़ खुनिॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ याम्‍मो कुहिङ्‌वे़त् चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽग लाम्‍लोःबा नु से़न्‍लप्‍दाङ्‌बा पोःङ्‌से़ कुजुप्‍साङ् ले़प्‍माङ् युक्‍खुरो॥ हे़क्‍केलॽरिक् इस्राइलस्‍मा मनाहाॽरे़ खुनिॽ लायोलाम् हिम्‍मा नु लायोलाम् ले़प्‍मि खोःमा सुये़म् मे़घोःसुआङ् मे़वाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","हे़क्‍क्‍याङ् कन् पाःन्‍निल्‍ले़न् तोःन्‍दिःङ्‌ग आनिगे़ वयिगे़रो, हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुइङ्‌जाःङ् ते़न्‍दिङ् के़जोःक्‍पाहाॽ पिरुसिबा सेसेमाङ्‌ङिन्‍नाङ्‌तोःन्‍दि वाॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","हे़क्‍क्‍याङ् कन् पाःन्‍निन् मे़घे़प्‍सुआङ् ये़जुम्‍भोओ के़वाॽबा मनाहाॽरे़ साॽरिक् खुनिॽ साक्‍के़न् पोगे़आङ् सेःक्‌युक्‍मिबाहाॽ से़प्‍मासि फाॽआङ् निङ्‌वाॽ मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","कर खे़प्‍मो साम्‌योथिम्‍साम्‍बा नु काक् मनाहाॽरे़ मिङ्‌सो इङ्‌धाःङ् मे़बिरुबा गमालियल मे़प्‍मनाबा फरिसिःन् ये़म्‍सिङ्‌ङाङ् खे़न् सेःक्‌युक्‍मिबाहाॽ सप्‍फाधिक् लाःक्‍कात् पाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","हे़क्‍क्‍याङ् खुने़ॽ वेॽ यहुदि ये़जुम्‍भोबाहाॽ अक्‍खेलॽरिक् मे़त्तुसि, “इस्राइलस्‍मा मनासे, कन् मनाहाॽ थे़मा मे़प्‍मासि खिनिॽ निङ्‌वाॽ के़इःत्तुम्‍माङ् के़वयिॽबे? सिङ्‌सिङ् लॽरे़म्‍मे़ॽओ! ");
INSERT INTO lifNT2_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","कुभा तङ्‌बे तगि थियादस मे़प्‍मनाबे़न् त्‍ये़आङ् वये़॥ खुने़ॽग रोमि हाङ्‌जुम्‍मिल्‍ले़ कुदक्‍ले़ङ्‌वाओ हाङ्‌बिफ्‍युङ् चोःक्‍मा फाॽआङ् इङ्‌गाॽएःक् लॽरे़आङ् वये़रो॥ हे़क्‍क्‍याङ् कुभा कुगिप् लिसि (४००) मनाहाॽरे़आङ् खुने़ॽ मे़दिम्‍दु, कर कुभा मनाहाॽरे़ खुने़ॽ मे़से़रुआङ् खुने़ॽ के़दिम्‍बा मनाहाॽ काक् मे़से़ःरे़आङ् मे़नुबे़ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","याङ्‌सि पयम् याम्‍नाःत्‍निःत्तो गालिलस्‍मा यहुदा मे़प्‍मनाबे़न् त्‍ये़आङ् कुभा मनाहाॽनु तङ्‌सिङ्‌ङाङ् हाङ्‌बिफ्‍युङ् चोगुरो, कर खुने़ॽआङ् मे़से़रु हे़क्‍क्‍याङ् खुने़ॽ के़दिम्‍बाहाॽआङ् मे़से़ःरे़ मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","कन् मनाहाॽ मे़सुसे़म्‍सिम्‍मिन्‍ने़ॽ ले़रे़म्‍दे़ःसे़म्‍सिम्‍मे़ॽ फाॽआङ् इङ्‌गाॽ सुजा पिनिङ्‌लो॥ थेआङ्‌भे़ल्‍ले़ कङ्‌हाॽरे़ मे़हुॽरुसिबा मे़जोगुसिबा पाःन्‍निन् मनालाम्ने़ फाॽग्र कन् मनाहाॽ मे़नुप् मे़बेःक्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","कर निङ्‌वाॽफुमाङ्‌लाम्ने़ फाॽग्र खिनिॽ कन् मनाहाॽ अप्‍मा के़न्‍छुक्‍तुम्‍सिम्‍मिन्‍लो, कर याङ्‌ना खिनिॽने़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ के़बोगिबा कुइसिःक् पोःङ्‌लो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","खुने़ॽ कुबाःन्‍निन् ये़जुम्‍भोबा मनाहाॽ खे़म्‍मा मे़दे़न्‍दे़रो॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ सेःक्‌युक्‍मिबाहाॽ मे़उःत्तुसिआङ् ते़ःम्‍भुक् मे़याक्‍तुसिर आल्‍ल कन् ये़सुरे़ कुयाःम्‍बेओ पाःप्‍मा हुॽमा के़ङ्‌घोःसुम्‍मिन्‍लो फाॽआङ् इङ्‌जाःङ् मे़बिरुसिआङ् मे़ले़रुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","हे़क्‍क्‍याङ् सेःक्‌युक्‍मिबाहाॽ ये़जुम्‍भोलाम् मे़लःन्‍दे़ मे़बेआङ् आनिगे़ग ये़सुरे़ कुमना पोःक्‍खिगे़बाल्‍ले़ चोगुल्‍ले़ तुक्‍खे चामा लाॽरिगे़ फाॽआङ् साॽरिक् मे़सःत्ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","हे़क्‍क्‍याङ् थिक्‌याःन्‍धक् खे़ङ्‌हाॽ माङ्‌हिम्‍मो नु हिम्हिम् मे़बेआङ् ये़सुःन्‍ने निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ सेःन्‍दुबा ख्रिस्‍तरो फाॽआङ् कन् सुनाइङ्‌ङिन् चक्‍मे़ल्‍लॽए मे़हुॽरुसिर इङ्‌भन् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","आल्‍ल खे़न् ये़म्‍मो हुॽसाम्‍बाहाॽ चक्‍मे़ल्‍लॽए मे़बोःरे़र मे़बेःल्‍ले़ ग्रिक के़बाःप्‍पा यहुदिहाॽ नु हिब्रु के़बाःप्‍पा यहुदिहाॽओ खे़माॽ पोगे़रो॥ ग्रिक के़बाःप्‍पा यहुदिहाॽरे़ आनिगे़ मेमेदुमाहाॽ थिक्‌याःन्‍धक्‍पा चामा थुङ्‌मा मे़हासुबाओ नुःरिक्‍काङ् कम्‍ब्राङ् मे़न्‍जोगुसिन् फाॽआङ् लुङ्‌मे़हाःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","हे़क्‍केःल्‍ले़ थिक्-ने़त् सेःक्‌युक्‍मिबाहाॽरे़ यरुसले़मस्‍मा नसानिबाहाॽ मे़उःत्तुसिआङ् अक्‍खे मे़मे़त्तुसि, “फुॽनुसाॽसे, आनिगे़ग निङ्‌वाॽफु पाःन्‍जाक्‍किन् इङ्‌भन् चोःक्‍मा नु हुॽमासि ले़प्‍माआङ् चामा थुङ्‌मारे़ तङ्‌गाम् चोःक्‍मा मे़लाॽरिगे़न्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","हे़क्‍केःल्‍ले़ खिनिॽ लुम्‍मोलाम् नुसि मिङ्‌सोदाङ्‌बा फाॽआङ् के़इङ्‌बा सेसेमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍मिल्‍ले़ थुक्‍तुसिबा नु सिक्‍कुम्‍दिङ्‌निङ्‌वाॽरे़ कुधिम् के़बोःङ्‌बा मनाहाॽ सेगे़म्‍सिम्‍मे़ॽओ॥ खे़ङ्‌हाॽ आनिगे़ कन् लक्‍पे़न्‍हाॽ हुक्‍सुप्‍तुम्‍सिम्‍बे़आङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","चक्‍मे़ल्‍लॽए तुवा चोःक्‍मा नु निङ्‌वाॽफु पाःन्‍जाक्‍किन् इङ्‌भन् चोःक्‍माओ नु हुॽमाओ ये़म् पिरुम्‍बे़ॽरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","सेःक्‌युक्‍मिबाहाॽरे़ मे़बाःत्तुबा कन् पाःन्‍निल्‍ले़ काक् नसानिबाहाॽरे़ खुनिॽ निङ्‌वाॽ तासुरो हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ सेसेमाङ्‌ङिल्‍ले़ कुमुक्‍साम्‍मिल्‍ले़ थुक्‍तुसिबा नु नसाःन्‍निल्‍ले़ कुधिम् के़बोःङ्‌बा स्‍तिफनस, हे़क्‍क्‍याङ् फिलिप, प्रखुरस, निकानोर, तिमोन, पर्मिनास, नु थिम्‍मे़न्‍दङ् सुवाङ्‌लाम् यहुदि साम्‌योओ के़दाःबा एन्‍तिओकस्‍मा नसानिबा निकोलसे़न्‌मे़सेगुसिआङ् ");
INSERT INTO lifNT2_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","खे़ङ्‌हाॽरे़ सेःक्‌युक्‍मिबाहाॽरो मे़दारुसिरो॥ हे़क्‍क्‍याङ् सेःक्‌युक्‍मिबाहाॽरे़ खुनिॽ सम्‍दाङ् हुक् मे़ने़स्‍सु मे़बिरुसिर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमुॽइसाम् मे़घोःसुनि फाॽआङ् तुवा मे़जोगुरो ");
INSERT INTO lifNT2_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","निङ्‌वाॽफु पाःन्‍जाक्‍किन् चक्‍मे़ल्‍लॽए मे़से़ःसुर मे़देॽरु॥ हे़क्‍क्‍याङ् यरुसले़म्‍मो हुॽसाम्‍बाहाॽ यरिक् मे़बोःक्‍खे़र मे़बेआङ् यरिक् निङ्‌वाॽफुसाम्‍बाहाॽरे़आङ् कन् नसाःन्‍निन् ते़न्‍दिङ् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","आल्‍ल कन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुलुङ्‌गुम् नु कुमुक्‍साम्‍मिल्‍ले़ के़दिम्‍बा स्‍तिफनसे़ल्‍ले़ मनालुम्‍मो निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ नु मिक्‍सेःन्‍हाॽ चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","कर “चोःक्‌युम्‍भोसाबाहाॽरे़न् चुम्‍लुङ्‌हिम्” मे़प्‍मनाबा यहुदि चुम्‍लुङ्‌हिम्‍मो के़याक्‍पा कुभा मनाहाॽ खुनिॽ तक्‍ले़ङ्‌वाओ मे़बोगे़॥ खे़ङ्‌हाॽ साइरेनि नु अले़क्‍जे़न्‍द्रिया ये़क्‌यक्, हे़क्‍क्‍याङ् सिलिसिया नु एसिया ते़ङ्‌गप्‍स्‍मा यहुदि मे़वये़रो॥ खे़ङ्‌हाॽरे़ स्‍तिफनसनु पाःन् थक्‍मा मे़हेःक्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","कर सेसेमाङ्‌लाम् सिक्‍कुम्‍दिङ् निङ्‌वाॽओ स्‍तिफनसे़न् पारे़बाल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ पाःन्‍धङ्‌ङो नाःम्‍मा मे़न्‍छुक्‍तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","हे़क्‍क्‍याङ् खे़ङ्‌हाॽरे़ स्‍वाःत्ताङ् मनाहाॽ अक्‍खेलॽरिक् पाःप्‍मा मे़हुसुसिरो, “आनिगे़ग कल्‍ले़ मोसा नु निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुदक्‍ले़ङ्‌वाओ माङ्‌चे़ॽया पारे़बा खे़प्‍सुम्‍बे़रो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","हे़क्‍केलॽरिक् खे़ङ्‌हाॽरे़ यहुदि तुम्‍लाम्‍लोःबाहाॽ, साम्‌योथिम्‍साम्‍बाहाॽ नु वेॽ मनाहाॽ मे़भोःक्‍खुसि॥ हे़क्‍क्‍याङ् खे़ङ्‌हाॽ मे़द्‌ये़आङ् स्‍तिफनसे़न् मे़दे़म्‍सुआङ् यहुदिहाॽरे़ खुनिॽ ये़जुम्‍भोओ मे़देॽरुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","हे़क्‍क्‍याङ् फोत्‍याबा तोःन्‍दि पिसे़ मे़दारुसिबाहाॽरे़ अक्‍खेलॽरिक् मे़बाःत्तु, “कन् मनाःल्‍ले़ग आप्‍फाल्‍ले़साङ् कन् सेसेमाङ्‌हिम् नु आनिॽ साम्‌योथिम्‍मिल्‍ले़ कुदक्‍ले़ङ्‌वाओ पारे़बारक् खे़प्‍सुम्‍बे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","हे़क्‍क्‍याङ् कल्‍ले़ग, नासरतस्‍मा ये़सुरे़ कन् माङ्‌हिम्‍मिन् यस्‍सुआङ् मोसारे़ आबिरे़ आयुसे़बा साक्‍थिम्‍हाॽ, चोःक्‍थिम्‍हाॽ के़रे़क् ले़क्‍खु आबिरे़रो लॽरिक् पाःत्तुरो॥” ");
INSERT INTO lifNT2_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","हे़क्‍क्‍याङ् खे़न् चुम्‍लुङ्‌ङो के़युङ्‌बाहाॽरे़ खुने़ॽ अदक्‍तक्‍काङ् ओमे़मे़त्तुल्‍ले़ कुनाराःङ्‌ग माङ्‌लाइङ्‌बाल्‍ले़न् हे़क्‍के ओःत्ते़बा मे़निःसुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","हे़क्‍क्‍याङ् मानिङ्‌वाॽफुसाम्‍बाल्‍ले़ स्‍तिफनसे़न् सेःन्‍दोसु, “कन् आप्‍तिक्‍हाॽ से़क्‍खाएबि?” ");
INSERT INTO lifNT2_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","हे़क्‍केःल्‍ले़ खुने़ॽ नोगप् पिरुसि, “पाःसे, फुॽनुसाॽसे, आघे़प्‍से़म्‍मे़ॽओ! आनिॽ सुधे़बा अब्राहाम्‍मिन् हारान ये़क्‌यक्‍को पेःक्‍माआङ् युङ्‌मानुःल्‍ले़ तगि खुने़ॽ मे़सोपोतामिया ते़ङ्‌गप्‍पो वये़ल्‍ले़ए मिमिदिङ्‌बा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुमिमिदिङ्‌ङिन् खुने़ॽओ ओसेःन्‍धाक्‍सिङ्‌ङाङ्‌ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","अक्‍खे मे़त्तुरो, ‘कन् लाजेॽ नु के़गाॽइ सोॽधोःक्‍हाॽ ले़रे़ध्‍ये़से़ॽआङ् खे़ने़ॽ ओसेःन्‍धाक्‍ने़बा लाजेॽओ पेगे़ॽओ॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","हे़क्‍केःल्‍ले़ खुने़ॽआङ् काल्‍दिहाॽरे़ खुनिॽ लाजेॽलाम् लःन्‍दे़आङ् हाराःन्‍नो पेआङ् युङ्‌सिङ्॥ खे़प्‍मो कुम्‍बा स्‍ये़आङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽ खे़न् लाजेॽलाम् तेॽरुआङ् आल्‍लो कप्‍मो आयुङ्‌बा लाजेॽओ तारुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","हे़क्‍केसाङ् खुने़ॽ कन् लाजेॽओ लाङ्‌भो तोॽमा लाजेॽआङ् मे़बिरुन्‍लो, कर कन् खुने़ॽ नु कुमुॽइदाङ्‌साहाॽ ताःन्‍दि पिमासि फाॽआङ् माङ्‌हे़क् चोगुरो॥ कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ माङ्‌हे़क् चोगुबा ये़म्‍मो अब्राहामरे़ कुस्‍साःधिक्‍काङ् होःप्‍ते़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","याङ्‌सि निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽ अक्‍खे मे़त्तु, ‘खे़ने़ॽ के़मुॽइदाङ्‌साहाॽ माःङ्‌घाबा वेॽ लाजेॽओ मे़युङ्‌लो॥ खे़प्‍मोबा लाजेॽसाबाहाॽरे़ ताप्‍फे़ःल्‍लिक् मे़मे़त्तुसिआङ् कुगिप् लिसि तङ्‌बे (४००) थारिक् खुनिॽ साक्‍के़ल्‍ले़क्‍काङ् योःक् मे़जोगुसिॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","कर के़मुॽइदाङ्‌साहाॽ योःक्‍पा के़जोःक्‍पा खे़प्‍मोबा लाजेॽसाबाहाॽ इङ्‌गाॽ खुम्‍दिङ् पिरुङ्‌सिङ्‌लो॥ हे़क्‍क्‍याङ् के़मुॽइदाङ्‌साहाॽ खे़न् लाजेॽओलाम् कन् लाजेॽओ मे़धाङ्‌ङाङ् इङ्‌गाॽ सेवा मे़जोःक्‍कारो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","हे़क्‍क्‍याङ् अब्राहाम्‍मिन् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुसेसे माङ्‌हुप्‍ले़न्‌मिक्‍सेःन् पोःङ्‌ल फाॽआङ् हर्दो हे़क्‍मा थिम् पिरुरो॥ हे़क्‍केःल्‍ले़ अब्राहामरे़ इसहाक्‍किन् सावाःन्‍दुआङ् ये़त्‍छि (८) ये़न्‍नो हर्दो हे़गु पिरु॥ हे़क्‍क्‍याङ् इसहाके़न् याकुबरे़ कुम्‍बारो॥ आनिॽग याकुबरे़ थिक्-ने़त् (१२) कुस्‍साःहाॽरे़ खुनिॽ मुॽइदाङ्‌सासिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","कुम्‍भुॽसिरे़ युसुफे़न् साॽरिक् नामे़हे़त्तुबाल्‍ले़ चोगुल्‍ले़ खे़ङ्‌हाॽरे़ खुने़ॽ मिस्रिहाॽरे़ खुनिॽ हुक्‍को मे़सङ्‌घुआङ्‌खुने़ॽ योःक्‍पा पोःक्‍खे़, कर निङ्‌वाॽफुमाङ्‌ङिन् खुने़ॽनु वये़, ");
INSERT INTO lifNT2_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","हे़क्‍क्‍याङ् खुने़ॽ कुदुक्‍खेवालाम् से़ःप्‍तुरो॥ हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽ लुङ्‌माॽ तुक्‍तुआङ् सिक्‍कुम्‍दिङ् निङ्‌वाॽ पिरुबाल्‍ले़ चोगुल्‍ले़ फारो हाङ्‌ङिल्‍ले़ खुने़ॽ मिङ्‌सो इङ्‌धाःङ् पिरुर मिस्र लाजेॽ नु कुयाङ्‌साकुन्‍धे सम्‍दाङ् सुहाङ्‌युक्‍पा चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","हे़क्‍क्‍याङ् मिस्र लाजेॽ नु कनान लाजेॽओ साॽरिक् यम्‍बा साक् थ्‍ये़आङ् यम्‍बा तुक्‍खेवा नु मिन्‍देॽ पोगे़, हे़क्‍केःल्‍ले़ आनिॽ सुधे़बा ताक्‍थे़बाहाॽरे़ चामा थे़माआङ् मे़ङ्‌गत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","कर याकुबरे़ मिस्रओ यरिक् चा वाॽ के़लॽबा खे़प्‍सुआङ् कुस्‍साःहाॽ चा लाःसे़ पाङ्‌घुसि॥ खे़ङ्‌हाॽरे़ युसुफलाम् चाःन् मे़इङु कर खुने़ॽ कुसिङ् मे़न्‍निःत्ते हिम्‍मो मे़नुःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","हे़क्‍केलॽरिक् मिस्रओ निले़ङ् चा लाःसे़ मे़बेःल्‍ले़ युसुफरे़ कुम्‍भुॽ कुन्‍साॽसि इङ्‌गाॽ युसुफआ फाॽआङ् मे़त्तुसि, हे़क्‍क्‍याङ् फारोहाङ्‌ङिल्‍ले़आङ् युसुफरे़ कुहिम्‍सयङ्‌हाॽ कुसिङ् निःत्तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","हे़क्‍क्‍याङ् युसुफरे़ कुम्‍बा याकुब नु काक् कुहिम्‍सयङ्‌हाॽ मिस्रओ उःत्तुसि॥ खे़ङ्‌हाॽ के़रे़क् नु-ङा (७५) मे़वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","हे़क्‍क्‍याङ् याकुब नु कुहिम्‍सयङ्‌हाॽ मिस्रओ मे़बे॥ याङ्‌सि खुने़ॽ नु कुस्‍साःहाॽ खे़प्‍मोए मे़स्‍ये़॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","खुनिॽ थक्‍हाॽ सेक्‍केम लाजेॽओ मे़देॽरुआङ् अब्राहामरे़ हामोररे़ कुस्‍साःहाॽलाम् इङुआङ् वये़बा इप्‍पुङ्‌दे़न्‍नो मे़लुप्‍तुसिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","आल्‍ल निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ अब्राहामनु चोगुबा माङ्‌हे़क्‍किन्‌के़प्‍मा इःत्ते़ल्‍ले़ मिस्रओ आनिॽ मनाहाॽ यरिक् मे़बोःन्‍दे़र मे़बेरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","यरिक् तङ्‌बे एगाङ् खे़प्‍मो वेॽस्‍मा मनाःन् हाङ् पोःक्‍खे़आङ् मिस्रओ हाङ् चोःक्‍मा हेःक्‍तु॥ खे़ल्‍ले़ युसुफरे़ कुयाःम्‍बेओ कुसिङ् मे़निःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","खे़ल्‍ले़ आनिॽ थाःक्‍थे़बाहाॽ इङ्‌ले़क् मे़त्तुसिर साॽरिक् निङ्‌घुम् चोगुसिआङ् ये़म्‍बित्‍छाॽ अङे़ःक्‌वासाहाॽ मे़सिर फाॽआङ् लाप्‍फु पाङ्‌घुसि॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","बा खे़न् ये़म्‍मो मोसाःन् सावाःन्‍छिङ्॥ खुने़ॽ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिःमाओ साॽरिक् नुःबा अङे़ःक्‌वा चोगे़॥ खुने़ॽ हिम्‍मो ला सुम्‍सि थारिक् कुम्‍बा कुम्‍मासिरे़ चिक्‍खे़छुआङ् कत्ते़छुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","हे़क्‍क्‍याङ् खुने़ॽ हिम् लाःक्‍कात् मे़लःत्तुआङ् वहङ्‌ङिल्‍ले़ कुयाओ मे़ने़स्‍सुल्‍ले़ खे़प्‍मो फारोहाङ्‌ङिल्‍ले़ कुस्‍साः हाङ्‌सामाल्‍ले़ खोःसुआङ् कुस्‍साः चोगुआङ् कत्तुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","हे़क्‍केलॽरिक् मिस्रओ के़वाॽबा के़रे़क् सिक्‍कुम्‍दिङ् निङ्‌वाॽ निसाम्‍हाॽ खुने़ॽ मे़हुॽरुरो॥ हे़क्‍क्‍याङ् थाङ्‌बे़न् के़रे़आङ् खुने़ॽ पाःन्‍नो नु याःम्‍बक्‍को मुक्‍के़गुबा पोःक्‍खे़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","हे़क्‍क्‍याङ् मोसाःन् तङ्‌बे लिबोःङ्‌(४०) के़रे़ल्‍ले़ कुगाॽइ इस्राइलिहाॽ तुम्‍से़ पेःक्‍मा निङ्‌वाॽ चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","हे़क्‍क्‍याङ् मिस्रिधिक्‍ले़ थिक् इस्राइलिःन् निङ्‌घुम् मे़त्तुबा निःसु॥ हे़क्‍केःल्‍ले़ खे़न् नाङ्‌मा फाॽआङ् पेआङ् खे़न् मिस्रिःन् हिप्‍तु से़रुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","खुने़ॽग निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ आबाङे कुमना इस्राइलिहाॽ खुनिॽ योःक्‍पा हिङ्‌मन्‍लाम् चोःक्‌युम्‍भो पिमासि फाॽआङ् खुने़ॽ पाङ्‌घुबा पाःन्‍निन् कुसिङ् मे़निःत्तुर के़लॽबा इःत्तुआङ् वये़, कर खे़ङ्‌हाॽरे़ खे़न् पाःन्‍निन् कुसिङ् मे़न्‍निःत्तुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","हे़क्‍क्‍याङ् कुदाःन्‍दिक् ने़प्‍फु इस्राइलिहाॽ चुङे़त्‍छिर यागे़त्‍छिबा निःसुसिआङ् नादङ् चोःक्‍मासि फाॽआङ् पेआङ् मे़त्तुसि, ‘तेःङ्‌बासे, खिन्‍छिॽग फुॽनुसाॽ के़धाप्‍सि! थेआङ् के़जुङ्‌सिबाबे?’ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","कर खे़न् निङ्‌घुम् के़मे़प्‍पे़ल्‍ले़ मोसाःन् थिक्‍ले़प्‍माङ् चन्‍दुर सेःन्‍दोसु, ‘खे़ने़ॽ हाःत्‍ले़ आनिगे़ सम्‍दाङ् हाङ् के़जोःक्‍पा नु खासे़न्‍लोःम्‍बा के़जोगे़आङ् के़वाॽबे? ");
INSERT INTO lifNT2_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","खे़ने़ॽ मिःप्‍मा मिस्रिःन् के़से़रुबा हे़क्‍के इङ्‌गाॽआङ् के़से़त्ताबाबि?’ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","कन् पाःन्‍निन् खे़प्‍सुआङ् मोसारे़ इङ्‌गाॽ मिस्रिःन् से़रुङ्‌बा पाःन्‍निन्‍नाङ् वेॽ मनाहाॽरे़ निङ्‌वाॽ मे़घोःसुबिला लॽरिक् निङ्‌वाॽ इःत्तुर किःसे़आङ् मिस्रलाम् मिद्यान लाजेॽओ खे़त्‍छिङ् पेआङ् खे़प्‍मोए वाॽमा हेःक्‍ते़, हे़क्‍क्‍याङ् खे़प्‍मोए मेःक्‍खिम् चोगुआङ् ने़प्‍फु कुस्‍साःआङ् पोःक्‍खे़त्‍छिरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","तङ्‌बे लिबोःङ्‌(४०) एगाङ् सिनाइ कोःक्‍माल्‍ले़ कुबेसाङ् एक्‍सादे़न्‍नोबा मि के़दिःप्‍पा पोःक्‍लाओ माङ्‌लाइङ्‌बान् मोसारो थाःन्‍छिङ्‌लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","मोसारे़ कुनिङ्‌वाॽ मये़आङ् थेःन्‍ने़बे? फाॽआङ् कुबेसाङ् पेरो॥ कर खे़ल्‍ले़ दाङ्‌बाल्‍ले़ कुइक्‍लाःन् खे़प्‍सु– ");
INSERT INTO lifNT2_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘इङ्‌गाॽ के़सुधे़बा अब्राहाम, इसहाक नु याकुबरे़ सेवा मे़जोगाङ्‌बा निङ्‌वाॽफुमाङ्‌आ॥’ मोसाःन् कुगिःमाल्‍ले़ यक्‍खे़आङ् खे़न् मि के़दिःप्‍पा पोःक्‍लाःन् ओमे़प्‍मा आःन्‍छिङ् मे़जोगुन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","हे़क्‍क्‍याङ् दाङ्‌बाल्‍ले़ मे़त्तु, ‘खे़ने़ॽ के़लाङ्‌सुःप्‍हाॽ फे़न्‍दे़ॽ, थेआङ्‌भे़ल्‍ले़ खे़ने़ॽ के़ये़प्‍पा दे़न्‍निन् सेसे चोःक्॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","इङ्‌गाॽ आमनाहाॽ मिस्रओ निङ्‌घुम्‍मो मे़वाॽबा निःसुङ्‌सिङ्‌ङाङ् खुनिॽ मेरिङ्‌ङिन्‌खे़प्‍सुङ्‌ङाङ् वाॽआ॥ हे़क्‍केःल्‍ले़ इस्राइलिहाॽ खुनिॽ योःक्‍पा हिङ्‌मन्‍लाम् चोःक्‌युम्‍भो पिसे़ इङ्‌गाॽ याङ्‌ङाङ् वाॽआ॥ आल्‍ल याङ्‌ना मिस्र लाजेॽओ खुनिॽ कुभाॽ पिसे़ नुःक्‍ने़ॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","बा कन् मोसाःन् इस्राइलिहाॽरे़ ‘खे़ने़ॽ आनिगे़ सम्‍दाङ् हाःत्‍ले़ हाङ् नु खासे़न्‍लोःम्‍बा के़सेगे़आङ् के़वाॽबे?’ मे़मे़त्तुर मे़नाॽरुआङ् मे़वये़, कर पोःक्‍लाओ ओसेःन्‍गे़धाक्‍सिङ्‌बा माङ्‌लाइङ्‌बाल्‍लोलाम् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुने़ॽए हाङ् के़जोःक्‍पा नु ताङ्‌गे़से़ःप्‍पा चोगुआङ् पाङ्‌घुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","मोसारे़ए इस्राइलिहाॽ मिस्रलाम् लाःक्‍कात् लःत्तुसि, हे़क्‍क्‍याङ् मिस्रओ, हे़ःत्ताङ्‌बा वाहङ्‌ङो नु तङ्‌बे लिबोःङ्‌(४०) थारिक् एःक्‍सादे़न्‍नो यरिक् निङ्‌वाॽ के़माबा याःम्‍बक्‍हाॽ चोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","कन् मोसारे़ इस्राइलिहाॽ अक्‍खे मे़त्तुसि, ‘निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ इङ्‌गाॽ हे़क्‍तङ्‌बाए माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पा खिनिॽ आबाङे मनालाम् खिनिॽओ पाङ्‌घुॽरो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","इस्राइलिहाॽ एःक्‍सादे़न्‍नो मे़जुप्‍से़ल्‍ले़ मोसाःन् खे़ङ्‌हाॽनु वये़, सिनाइ कोःक्‍माओ माङ्‌लाइङ्‌बान् खुने़ॽनु पारे़ हे़क्‍क्‍याङ् खे़न् हिङ्‌मन् के़बिबा निङ्‌वाॽफु पाःन्‍जाक्‍किन् खुने़ॽ खोःसु, हे़क्‍क्‍याङ्‌आनिॽ सुधे़बाहाॽ पिरुसिआङ् आनिॽ आघोःसुम्‍माङ्‌आवाॽरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","कर आनिॽ सुधे़बाहाॽरे़ खुने़ॽ कुबाःन्‍निन् ते़न्‍दिङ् चोःक्‍मा मे़नाॽरुआङ् मोसाःन्‍नाङ् मे़नाॽरु, हे़क्‍क्‍याङ् मिस्रओ नुःङ्‌मा निङ्‌वाॽ मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","हे़क्‍केःल्‍ले़ मोसारे़ कुम्‍भुॽ हारुन्‍निन् खे़ङ्‌हाॽरे़ अक्‍खे मे़मे़त्तु, ‘आनिगे़ लागि याप्‍मि लाम् के़लोःबा माङ्‌हाॽ चोगे़ आबिरे़ॽ॥ मिस्रलाम् याप्‍मि के़लःप्‍पा कन् मोसाःन् थे पोःक्‍खे़ फाॽआङ् आनिगे़ मे़निःसुम्‍बे़न्‍लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","हे़क्‍केःल्‍ले़ खे़ङ्‌हाॽरे़ पित्‍साःत्‌नावाइत्‍ला मे़जोगुआङ् सिदुङ्‌जभा मे़जोगुरो॥ खुनिॽ मे़जोगुबा याःम्‍बक्‍को मे़सःत्ते़र नावाइत्‍लाःन् इङ्‌धाःङ् पिसे़ ससाङ्‌स्रोःत् मे़जोगुरो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","हे़क्‍क्‍याङ् निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ ताङ्‌साक्‍पोबा खेःम्‍सिक्‍पे़न्‌सेवा मे़जोगुर फाॽआङ् खे़ङ्‌हाॽ ले़रुसिरो॥ कन् पाःन्‍निङ्‌ग माङ्‌निङ्‌वाॽपाःन् के़बाःप्‍पाल्‍ले़ साप्‍पन्‍नो साप्‍तुआङ् के़बप्‍पा कुइसिःक् के़रे़रो, ‘इस्राइलिसे, खिनिॽ एःक्‍सादे़न्‍नो तङ्‌बे लिबोःङ्‌(४०) थारिक् के़वयिल्‍ले़आङ् इङ्‌गाॽ आसेवा के़जोगुम्‍मिल्‍ले़ सिदुङ्‌जभा याप्‍मि के़म्‍बिरिन्‍लो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","कर खिनिॽग मोलोक साम्‍माङ्‌ङिल्‍ले़ कुमाङ्‌धाःन्‌नु खेःम्‍सिक्‍पे़न्‌रे़फान साम्‍माङ्‌ङिल्‍ले़न् नावाइत्‍लाःन् के़बक्‍खुम्‍लो॥ खिनिॽ आबाङे के़जोगुम्‍बा नावाइत्‍लाःन् सेवा के़मे़त्तुम्‍बाल्‍ले़ चोगुल्‍ले़ बे़बिलोन्‍नुःल्‍ले़आङ् माःङ्‌घा पाङ्‌निङ्‌लो॥’ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","खे़ङ्‌हाॽ ये़ःङ्‌घादे़न्‍नो मे़वये़ल्‍ले़ आनिॽ सुधे़बाहाॽरे़ निङ्‌वाॽफु साःङ्‌गाहिम् मे़गत्तु॥ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ मोसाःन् ओसेःन्‍धाक्‍तुबा हे़क्‍केए खे़न् चोगे़आङ् वये़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","याङ्‌सि निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ खुनिॽ तगिलाम् नाःत्तु लःत्तुसिबा सुवाङ्‌हाॽरे़ खुनिॽ लाजेॽओ यहोसुःन्‍नु मे़बेःल्‍ले़, खे़ङ्‌हाॽरे़ साःङ्‌गाहिम्‍मिन् खुनिॽनुए मे़गुयुआङ् मे़देॽरुरो॥ हे़क्‍क्‍याङ् दाउद हाङ्‌ङिल्‍ले़ कुये़म् थारिक् खे़न् साःङ्‌गाहिम्‍मिन् ने़स्‍से़रो॥ ");
INSERT INTO lifNT2_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","दाउद हाङ्‌ङिल्‍ले़ निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुनिङ्‌वाॽ ताःसुआङ् याकुबरे़ सेवा चोगुबा निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुलागि हिम् चोःक्‍मा फाॽआङ् पेलि फाक्‍तु, ");
INSERT INTO lifNT2_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","कर निङ्‌वाॽफुमाङ्‌ङिल्‍ले़ कुहि