﻿USE sofia;
DROP TABLE IF EXISTS sofia.lid_vpl;
CREATE TABLE lid_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lid_vpl WRITE;
INSERT INTO lid_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ma mwena handru badeh Kindrei mwesekei munyak ma kandrah. ");
INSERT INTO lid_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ya munyak kahis le badeh ma lakou aliy bwe, ndras badeh nohowan handru udu bolo lulik. Eme ya boto-on ta Malawi Ndrabun ta Kindrei badeh edek bwele-e gwa. ");
INSERT INTO lid_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Eme Kindrei eme, iy anya eh, “Kon kaleu.” Eme badeh kon aleu. Eme iy anyolom badeh ma iy sekesek handru. ");
INSERT INTO lid_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ano iy atehei ndrokowan udu aliy, udu bolo len hawe lulik. ");
INSERT INTO lid_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Eme iy tondrohani kon aleu badeh, “Len,” ma tondrohani lulik badeh, “Ben.” Ano kon eben ano kon aleu badeh len ari ah. ");
INSERT INTO lid_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ano Kindrei anya eh, “Ya abo lakou i buku asi jor badeh keme kasahan ki la-uh kon, ari kudu ndrandrahun labai ya ari kudu ndrandrahun labai.” Eme badeh asahan i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Eme badeh Kindrei mwesekei lakou i buku asi jor badeh apwai gwa badu andri ma apwai gwa badu loken. ");
INSERT INTO lid_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Eme iy tondrohaniy lakou i buku asi jor nane badeh “Kandrah.” Ano kon eben ano kon aleu badeh, len la-uh ai. ");
INSERT INTO lid_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ano Kindrei anya ja eh, “Abo gwa badu bahandra kandrah badeh keme lese ma hawe munyak kasahan.” Eme asahan i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Eme Kindrei badeh tondrohani kon soboren badeh, “Munyak” ma iy tondrohani gwa udu se nane dah, “Ndras.” Eme Kindrei anyolom badeh ma iy sekesek handru. ");
INSERT INTO lid_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ano iy anya eh, “Abo kei ma bwidiu kasahan bwele-e munyak, kato-ou buwa kei ma kato-ou salin ya iri badeh ndrateheyan labai.” Eme badeh asahan i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Eme saba buwa kei ateh bolo munyak eme loken, badeh Kindrei anyolom ma iy sekesek handru. ");
INSERT INTO lid_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ano kon eben ano kon aleu badeh len taloh ai. ");
INSERT INTO lid_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ano Kindrei anya ja eh, “Lakou ta anya badeh kanya bada kandrah ta apou len ma ben, ma kaleheyani kalem ta an ta len ma hawe ta jaha ma hawe len ta atudun nyamon tinan ta atukum. ");
INSERT INTO lid_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Eme oro doh kameh adeu lomada oro kameh anya udu kandrah eme bwele-e munyak.” Eme badeh asahan i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ya eme Kindrei badeh mwesekei lakou la-uh tinan ta anya, iy mwesekei an baden eh ta atondrok len ai. Ya bun baden eh ta atondrok ben ai; ma hawe iy mwesekei iri ndrau ale. ");
INSERT INTO lid_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ano iy atehei lakou ta anya udu kandrah badeh ta adeu lomadan eme andri bwele-e munyak ai; ");
INSERT INTO lid_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","i doh ta atondrok len hawe ben ma ta apou len ma lik. Eme Kindrei anyolom badeh ma iy sekesek handru. ");
INSERT INTO lid_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ano kon eben ano kon aleu len hahuw ai. ");
INSERT INTO lid_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ano Kindrei anya ja eh, “Ya abo lakou mulin kasahan bolo gwa ma reu kaso na sirih.” ");
INSERT INTO lid_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kindrei badeh ndramwesekei iri ni tinan badu ndras ma hawe iri saba lakou mulin ala ado bolo gwa badeh ndrano, ma iri badeh ndrateheyan labai. Eme Kindrei anyolom badeh ma iy sekesek handru. ");
INSERT INTO lid_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Eme iy atehei nyosowan i tiri ma iy anya, “Iri mulin badu gwa kadeu nah ma iri kaweleyani ndras, ma iri sirih ale kasahan solo-an.” ");
INSERT INTO lid_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Eme kon eben ano kon aleu len limeh ai. ");
INSERT INTO lid_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ano Kindrei anya eh, “Abo iri saba lakou katin haka badeh kasahan bwele-e munyak. Iri katin haka ndriliu ma ndriliu bwe, nadu bwisik ma tinan badeh kasahan. Ya iri badeh ndrateheyan labai.” Eme asahan i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ya eme Kindrei badeh mwesekei iri mari doh ano iy anyolom eme badeh iy sekesek handru. ");
INSERT INTO lid_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ano Kindrei anya ja eh, “Ya abo i dah kameh to kamwekes ndramak awas ai; ya teheyan ma kone oro ki le buku to. Ya eme oro kameh katondrok iri ni, katondrok iri sirih ma katondrok iri katin haka ndriliu ma ndriliu bwe, bwisik ma tinan.” ");
INSERT INTO lid_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ano Kindrei badeh mwesekei ndramak awas mwesekei teheyan ma konen i le buku iy, mwesekei mwan ma hawe badih. ");
INSERT INTO lid_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Ano badeh iy atehei nyosowan i turu ma tiye i turu i buku doh, “Ah badeh kamwekes nah ya lundriye ah oro kaweleyani kon munyak mari ma kado katondrok. Ma jo atehei ah badeh katondrok iri ni katondrok iri sirih ma hawe iri katin haka ndriliu. ");
INSERT INTO lid_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ya saba buwa kei badeh ah kaimon le ai. ");
INSERT INTO lid_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Arile iri katin haka ndriliu hawe iri sirih baden eh, jo atehei nyamon tiri badeh bwidiu ma hawe la-u kei i ta nyumon tiri ai.” Eme badeh asahan le ai. ");
INSERT INTO lid_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Eme Kindrei anyolom lakou mari iy mwesekei doh badeh ma iy sekesek handru ta aliy. Ano kon eben ano kon aleu badeh len onoh ai. ");
INSERT INTO lid_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Eme ya kon mari ma kandrah badeh ndramwesekei ndrano ai. ");
INSERT INTO lid_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Eme na len onoh badeh lahou ta Kindrei ano. Eme na len ndro taloh badeh iy amunyau. ");
INSERT INTO lid_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Eme iy nyosowani len ndro taloh ma atehei ere len, tasah na len doh badeh iy mwesekei lakou mari ma iy amunyau. ");
INSERT INTO lid_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Eme ya i dah nyala lakou mari badu munyak asahan i buku sah. Na len Laban Kindrei mwesekei kon munyak mari, ");
INSERT INTO lid_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","badeh sese kei bateh bwe, ari buwa kei badeh bateh bada ndren bwe, tasah iy batiye ur badeh bandruk bwe, ma lau ta apou ndren bwe. ");
INSERT INTO lid_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Arile gwa ja badeh udu bolo ndren eme loken badeh asabu bwele-e munyak. ");
INSERT INTO lid_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Ano badeh Laban Kindrei rawi ndren eme loken, ano iy amwekes ndramak na aliy; ano badeh iy aluhi kohan handru i no-on ma ndramak dah asahan awas. ");
INSERT INTO lid_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ano badeh Laban Kindrei mwesekei bilin nyaran Iden udu loboho an eme loken. Ano badeh iy tiye ndramak nane, iy mwesekei dah udu aliy ai. ");
INSERT INTO lid_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Iy badeh mwesekei saba kei mwasin badeh ateh udu aliy ma edeu salin. Eme udu alih ta bilin badeh kei lu-ei le, kei doh ta edeu koham winiyan bano bwe. Ma kei ale ta edeu tanan ndra-in ma tanan mwasin. ");
INSERT INTO lid_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ma gwa rawa badeh arorou, udu bolo Iden ta edeu gwa i ta bilin; ano udu doh badeh, apou i handra. ");
INSERT INTO lid_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Gwa rawa ma bwena eh, badeh aloh gwa Pison, badeh arorou awudi kon munyak aloh nyaran Habilah. ");
INSERT INTO lid_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ya bek nyikilikin aloh gol badeh, udu aliy ma kei ta suluw badeh udu aliy ma hawe bek mwasin mwasin badeh udu aliy ale. ");
INSERT INTO lid_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ya andra gwa rawa ja aloh gwa Gihon; badeh arorou awudi kon munyak aloh Kus. ");
INSERT INTO lid_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ano andra gwa taloh badeh gwa Taigres; iy badeh arorou loboho an eme loken ta kon Aseriya. Ano andra gwa hahuw badeh nyaran gwa Yupretis. ");
INSERT INTO lid_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ano badeh Laban Kindrei atehei ndramak nane udu bilin loboho kon Iden ta iy kinyor ma iy katondrok. ");
INSERT INTO lid_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ano iy tiye i tan, “Ou badeh winiyan aimon buwa kei mari badu bolo bilin; ");
INSERT INTO lid_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Arile kei ala ta leheya tanan ndra-in ma ta leheya tanan mwasin badeh ou saimon buwan ndri-i labai. I buku na len ou aniy kameh, ou kameh amak.” ");
INSERT INTO lid_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ano Laban Kindrei lomondra i buku doh, “Ei, bamwenen se bwe, i buku ndramak udu ya iy badeh le ari le. Jo kamwesekei ari seben mwasin ta aseben iy.” ");
INSERT INTO lid_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Eme iy andrei ndren eme, ano iy mwesekei iri katin haka mari ma hawe iri sirih. Ano badeh iy tukumwi iri ase ala hawe i ndramak nane dah ta iy katondrohan nyara iri. ");
INSERT INTO lid_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Eme ma iy tondrohani nyara iri sirih mari ma hawe iri katin haka mari; arile ari toro badeh mwasin ta asahan borobwar tan bwe. ");
INSERT INTO lid_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ano ja badeh Laban Kindrei badeh mwesekei ndramak dah amadin tuk; eme iy i ndramatinou kahis le badeh iy andrei ndruwi kabeden ari. Ano iy lowosani odan i hamon ja. ");
INSERT INTO lid_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Eme iy mwesekei badih dah nane na ndruwi kabede ndramak dah ano sirini iy ili hawen. ");
INSERT INTO lid_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ano ndramak dah anya ja eh, “Kabwe ai; i dah i buku le jo amwenen. Ndruwin andrei badeh badu ndruwik ma odan badeh badu odak amwenen. Ya eme iy badeh badih, tasah iy badeh asahan ta ndramak mwan.” ");
INSERT INTO lid_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Eme ya ta katin doh badeh i mwan badeh karuwani taman uru tinen ya iy keme len hawe udun ya uru badeh ka ari buruwen. ");
INSERT INTO lid_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ya uru ma la-uh badeh kolau bwe, arile uru badeh buli uru bama uru bwe. ");
INSERT INTO lid_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Eme ya mwak badeh tanan tan badeh ndrala labai udu bolo iri katin haka mari ala Laban Kindrei mwesekei. Eme ya mwak lelen i badih, “Em Kindrei tiye i tam handru ta ou badeh saimon buwa kei badu bolo bilin dah?” ");
INSERT INTO lid_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Eme i badih anya eh, “Aru badeh winiyan aimon buwa kei badu bilin. ");
INSERT INTO lid_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Arile kei udu alih ta bilin badeh Kindrei tiye anya, aru badeh saimon buwan. Ma aru sanyokar ale, bakameh aru amak.” ");
INSERT INTO lid_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Eme badeh mwak anya eh, “Badeh wasai oh; ou winiyan bamak bwe. ");
INSERT INTO lid_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kindrei tiye badeh, tasah iy tanan i buku ou aniy kameh ou kameh asahan i buku iri Kindrei. Ma ou kameh atanam lakou mwasin ma lakou ndra-in.” ");
INSERT INTO lid_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Eme i badih dah anyolom kei dah ma buwan badeh mwasin labai ta aimon, eme iy lomondra, “Mwasin handru en i buku jo kasahan badih ta tanan.” Eme iy andrei rayah ma iy aimon ai. Ano badeh iy andrei rayah i mine udun ma udun aimon ale. ");
INSERT INTO lid_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Eme uru aniy le badeh, ma uru akohok tanan ma uru atanan ai, uru badeh kolau bwe; eme ma uru asowek la-u kei aloh pik i se ma uru taliye ai. ");
INSERT INTO lid_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Eme na beyeh doh le badeh uru anuhun Laban Kindrei edek bolo bilin le badeh, uru aton ala bolo ndrokowa kei udu bolo bilin. ");
INSERT INTO lid_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Eme Laban Kindrei aloh iy, “Ou ndraheh?” ");
INSERT INTO lid_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Eme iy anya eh, “Jo anuhun ou ado bolo bilin; eme jo inoh ma jo aton tam, tasah jo kolau bwe.” ");
INSERT INTO lid_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","“Are tiye ta ah anya, ah kolau bwe?” Kindrei ndremenya, “Ah ndrani buwa kei ala jo mene anya ah saimon en?” ");
INSERT INTO lid_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Eme i mwan anya eh, “I badih ou atehei iy udu hawek kada-ah, badeh atehei buwa kei eme ma jo iniy.” ");
INSERT INTO lid_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Eme badeh Laban Kindrei lelen i badih, “Ou anya amwekes tasah?” Eme iy anya eh, “Mwak wendreyani jo ma jo iniy.” ");
INSERT INTO lid_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ano Laban Kindrei tiye i ta mwak, “Ou le kameh ou akohok isi ta aliy. Ou le ari badu bolo iri katin haka mari, ala adek ma seselek ya jo tandrakan ou le ari. Na len dah ma na len eme kameh, ou kameh seselek na baha ndrinem ma ou kameh kaniyam kameh ndren na len ari i buku ari udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","“Ya jo kameh mwesekei ou hawe i badih kameh ah kameh baseken ah bwe; nadu ah kameh uru kameh andra-i udu le buku doh. Ya nadu i badih kameh tihisiy batum abwesek ma i dah kameh ou kameh aso ma aimon katin.” ");
INSERT INTO lid_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ano iy tiye i ta i badih, “Jo kameh amwekes isi labai i buku nah ere ndrinem ma i dah kameh jo edeu sisi-in i buku ou anya adeu nah. Ya ta i doh kameh ou kameh anya udum sala len, arile i mwan le badeh atondrok ou.” ");
INSERT INTO lid_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Eme iy tiye i ta i mwan, “Ou anuhun boho udum ma ou aniy buwa kei mene jo tiye anya ou saimon. Ya eme ta lakou ou ndramwesekei, i dah kameh munyak andra-i. Ya i dah kameh len ou ado kameh ou amwekes lahou boto-on boto-on ta amwekes munyak ta atah nam nyamon. ");
INSERT INTO lid_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ya i dah kameh iri bwidiu bobodon kameh ateh ma i dah kameh ou kameh aimon buwa kei badu lokei. ");
INSERT INTO lid_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ma i dah kameh ou amwekes lahou boto-on ma sa-ar asahan ta amwekes nyamon. Winiya len ou le barala hamon barala munyak ja mene amwekes ou na aliy, ma ou kameh a munyak leleyah.” ");
INSERT INTO lid_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam tondrohani nyara udun badeh Ewa, tasah iy badeh tine iri lau mari. ");
INSERT INTO lid_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Eme Laban Kindrei mwesekei kolau i turu na ku-i katin haka ma iy tani i turu. ");
INSERT INTO lid_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Ano Kindrei tiye, “Abo iri ndramak badeh ndrasahan ndra buku to ai, ndratanan saba lakou mwasin ma saba lakou ndra-in. Eme ya iy badeh sakohok buwa kei ala ta amwekes kohan udu le buku doh ma iy badeh saimon. Bakameh iy kameh kohan kudu le buku doh.” ");
INSERT INTO lid_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Eme ma Laban Kindrei suni iy iu i len ta bilin Iden ma mwesekei iy apou munyak ala mene bwidi iy mene asahan na aliy. ");
INSERT INTO lid_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Eme ya loboho an eme loken manan ta bilin badeh iy atehei iri angelo, lau ta ndrokei; ma samen badeh anya ili eme udu mada san ta i bolo bilin Iden, badeh ta nohowa lau same mirihik ta kei ta edeu kohan mwasin. ");
INSERT INTO lid_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ano badeh Adam amadin hawe udun, eme ma ndrine udun i tinan. ");
INSERT INTO lid_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Eme ma iy atehei nah mwan; ano iy tiye, “Laban aseben jo ma nah mwan ndrasahan.” Eme iy tondrohani nyaran Ken. Ano badeh iy atehei mwan ari ja nyaran Abol. Eme badeh Abol badeh asahan ndramak ta atondrok iri katin haka, ma hawe Ken badeh asahan ndramak ta bilin. ");
INSERT INTO lid_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ano oro ado sese badeh, Ken eme badeh andrei nyamon rayah badu bilin eme iy asun i nyara salom i ta Laban. ");
INSERT INTO lid_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ano Abol eme andrei nadu sipsip ari kasen mwasin handru, ano badeh iy idiy imek. Eme iy edeu i nyara salom mwasin. Eme ya Laban Kindrei badeh sekesek ma aseken Abol ma salom tan. ");
INSERT INTO lid_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Arile ta Ken badeh iy baseken handru bwe. Eme badeh Ken i bolosen handru ma ndrinen isi handru en. ");
INSERT INTO lid_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ano badeh Kindrei tiye i ta Ken, “Ou a bolosen ta sasah? Badam asaram ta sasah? ");
INSERT INTO lid_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","I buku none ou amwekes lakou mwasin, i dah nane ou sekesek; arile ou ndramwesekei kandriyen ndra-in, eme karei ma lomondra ndra-in abe-en ou ma abwe-ek ou udu konam. Eme ou abadok doh?” ");
INSERT INTO lid_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ano badeh Ken tiye sahou i ta nadu tinen Abol, “Talu ka-au kala len.” Eme uru au ame len badeh, Ken eme tubuni iy, eme ma iy idi nadu tinen imek. ");
INSERT INTO lid_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ano Laban eme ndremenya Ken, “Nadu tinem ndraheh?” Eme iy anya, “Jo tanan bwe oh, jo atondrok iy ai?” ");
INSERT INTO lid_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ano Laban tiye, “I buku sah ou amwekes budon ndra-in dah? Ndraye nadu tinem asah eden udu bolo ndren kede-eh; eden eme tek ta ou kameh akohok isi saluwen. ");
INSERT INTO lid_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Eme ya i dah kameh munyak kameh andra-i na bales tasah na ou. Munyak badeh ndranyuwi ndraye nadu tinem i buku none ari lakou bohon asak le, na len ou adai iy. ");
INSERT INTO lid_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ya i buku none ou anya atah baso kameh, munyak kameh winiyan bamwekes bateh bwe, ma ou kameh ta tekedek le.” ");
INSERT INTO lid_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Eme Ken tiye i ta Laban i buku doh, “Ou tiye sahou badeh maha-an labai eme tek. ");
INSERT INTO lid_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ou kameh tikahei jo iu ta munyak ma ta tondrok ai, ma jo kameh edek le ai, ya are ndrondron jo kameh idi le jo ai?” ");
INSERT INTO lid_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Arile Laban anya eh, “Bwe, i buku none are idi ou, i dah kameh lau ndro taloh amak i saluwem.” Eme Laban atehei kalem i ta Ken ta tiye tanan i tare ndrondron iy badeh sadai iy. ");
INSERT INTO lid_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Eme Ken iu, iu ta mada Laban ili udu munyak aloh, “Lolo-an Le,” udu loboho an eme loken ta bilin Iden. ");
INSERT INTO lid_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ano badeh Ken uru udun atehei nadu uru eme tondrohani nyaran Inok. Ano badeh Ken tahi kon tinan ari ma tondrohani nyaran i nyara nadun. ");
INSERT INTO lid_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Eme Inok atehei nadun ari tondrohani nyaran Irat, ya iy badeh tama Mahuja-el. Eme Mahuja-el atehei nadun mwan ari nyaran Matusa-el ya iy badeh tama Lemek. ");
INSERT INTO lid_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemek badeh sudi badih la-uh, Adah hawe Silah. ");
INSERT INTO lid_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Eme Adah badeh edeu Jabel eme iy badeh tubu iri lau ta amadin asiu balei, ma iri doh badeh lahou tiri ta atondrok iri katin haka. ");
INSERT INTO lid_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ya nadu tinen Jubel badeh tubu iri lau ta oloh bala-eu ma ta adi ndran. ");
INSERT INTO lid_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silah badeh edeu Tubal Ken; iy badeh tubu iri lau ta amwekes lakou ta lahou i buku samen na hayen nyikilikin. Ya nadu tinen badeh nyaran Namah. ");
INSERT INTO lid_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ano Lemek tiye i ta udun uru, “Adah ah Silah ah kanuhun jo! Jo badeh ndradai loweu ari ndramak, tasah iy anya ka-um jo. ");
INSERT INTO lid_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","I buku none lau ndro taloh amak ta saluwe Ken imek, badeh kameh ndro tonoh ndro taloh (77) kameh amak i buku none iri kadai jo.” ");
INSERT INTO lid_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ano Adam uru udun atehei nadu uru mwan ari ja. Eme udun tiye, “Kindrei badeh atehei nah mwan ari i saluwe Abol ala Ken mene idi iy.” Eme iy tondrohani nyaran badeh Set. ");
INSERT INTO lid_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Eme Set atehei nadun mwan ari tondrohani nyaran Inos. Eme kabatana doh badeh iri lau baraloh nyara Laban barala ta atudun ai. ");
INSERT INTO lid_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ya i dah sare Adam oro ai. Len Kindrei mwesekei lau awas badeh, iy mwesekei konen i le buku iy. ");
INSERT INTO lid_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","(Iy mwesekei uru ari mwan ma badih ano iy atehei nyosowan i turu ma tondrohani uru “Lau”). ");
INSERT INTO lid_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Len Adam jaha tan asahan rinek tonoh (130) badeh nadun ari asahan ya konen i le buku iy, eme iy tondrohani nyaran Set. ");
INSERT INTO lid_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ano hamon ta aliy badeh Adam udu winiya jaha ndru lunek (800), ma iy badeh nadun rayah ale udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ano jaha tan i ndro rawa tonoh (930) badeh ma iy imek. ");
INSERT INTO lid_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Len Set jaha tan asahan rinek limeh (105), badeh nadun ari asahan nyaran Inos. ");
INSERT INTO lid_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Eme iy udu winiya jaha ndru lunek ndro taloh (807) ma iy badeh nadun rayah ale udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ano jaha tan asahan ndro rawa ronoh la-uh (912) badeh iy imek. ");
INSERT INTO lid_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Len Inos jaha tan asahan ndro ronoh (90), badeh iy atehei nadun ari nyaran Kenan, ");
INSERT INTO lid_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","eme iy badeh udu winiya jaha ndru lunek ronoh limeh (815). Iy badeh nadun rayah udu aliy ale. ");
INSERT INTO lid_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ano jaha tan asahan ndro rawa limeh (905) badeh ma iy imek. ");
INSERT INTO lid_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ano len Kenan jaha tan asahan ndro tonoh (70) badeh iy atehei nadun ari nyaran Mahalalel, ");
INSERT INTO lid_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ano iy udu winiya jaha ma ndru lunek hanoh (840) ma iy nadun rayah ale udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ano jaha tan asahan ndro rawa ronoh (910) badeh iy imek. ");
INSERT INTO lid_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ano len Mahalalel jaha tan asahan ndro hanoh limeh (65) badeh iy atehei nadun mwan ari nyaran Jaret. ");
INSERT INTO lid_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ano iy udu badeh winiya jaha ndru lunek tonoh (830). Ma iy badeh nadun rayah udu aliy ale. ");
INSERT INTO lid_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ano na jaha ndru lunek ndro tonoh limeh (895) badeh iy imek. ");
INSERT INTO lid_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ano na len Jaret jaha tan asahan rinek ndro hanoh la-uh (162) badeh iy atehei nadun mwan ari nyaran Inok. ");
INSERT INTO lid_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ano iy udu winiya jaha ma ndru lunek (800). Ma iy ale nadun rayah ale udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ano na jaha ndro rawa ndro hanoh la-uh (962), badeh ma iy imek. ");
INSERT INTO lid_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ano len Inok jaha tan asahan ndro hanoh limeh (65) badeh, iy atehei nadun mwan ari nyaran Matusala. ");
INSERT INTO lid_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ano hamon ta aliy badeh Inok badeh in hamon ta sahou ta Kindrei winiya jaha tonek (300), ma nadun rayah ja asahan. ");
INSERT INTO lid_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Iy udu badeh winiya jaha ma tonek ndro hanoh limeh (365). ");
INSERT INTO lid_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Iy anuhun sahou ta Kindrei ma iy in hamon ta Kindrei handru; ano iy amai leleyah, Kindrei kuhi iy iu. ");
INSERT INTO lid_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ano len Matusala jaha tan asahan rinek ndru lunoh ndro taloh (187) badeh iy atehei nadun ari mwan badeh nyaran Lemek. ");
INSERT INTO lid_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ano iy udu winiya jaha ndru tuluwi ndru lunoh la-uh (782) ma iy nadun rayah badeh udu aliy ale. ");
INSERT INTO lid_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ano jaha tan asahan ndro rawa ndro hanoh ndro ari (969) badeh ma iy imek. ");
INSERT INTO lid_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ano len Lemek jaha tan asahan rinek ndru lunoh la-uh (182) badeh iy atehei nadun mwan ari nyaran Nowa. ");
INSERT INTO lid_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Eme iy tiye i buku doh, “Tasah ta munyak mene ndrandra-i, i dah kameh i nah dah kameh aseben taha ta lahou boto-on taha amwekes.” Eme iy tondrohani nyaran badeh Nowa. ");
INSERT INTO lid_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Eme Lemek badeh udu le winiya jaha lemenek ndro ronoh limeh (595) ma nadun rayah udu aliy ale. ");
INSERT INTO lid_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ano jaha tan asahan ndro tonek ndro tonoh ndro taloh (777) badeh ma, iy imek. ");
INSERT INTO lid_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ano hamon Nowa jaha tan asahan lemenek (500), badeh iy atehei nadun mwan oro ma taloh, Sem eh, Ham eh, ma hawe Jepet. ");
INSERT INTO lid_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Na len iri lau weleyani kon munyak ma badih asahan ame len, ");
INSERT INTO lid_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","eme iri lau rayah batun badu kandrah, badeh anyolom iri badih badeh konen konen, eme iri asoh iri ala seken tiri udu tiri. ");
INSERT INTO lid_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ano Laban Kindrei anya eh, “Jo baseken kohak handru bado tiri luluwen bwe, iri ndramak leleyah labai. Na len dah ma len hamon eme kameh koha iri bado luwen bwe, winiya basakalawi jaha rinek lunoh bwe.” ");
INSERT INTO lid_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Na len doh badeh ma na len eme kameh iri lau tinan tinan le, ado bwele-e munyak. Iri badeh lundriye badih awas ma lau badu kandrah. Iri badeh lau ndra handru le ma lau nyara iri tinan le, na len mene ndra-au. ");
INSERT INTO lid_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Eme ya len Kindrei anyolom iri lau mari are bolo munyak badeh kandriyen tiri badeh ndrandra-i labai, ma budon tiri badeh ndra karei ma lomondra ndra-in na len mari. ");
INSERT INTO lid_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Eme iy tikisiy, tasah iy mene mwesekei iri ma atehei iri ado bwele-e munyak. Eme ma batun isi handru. ");
INSERT INTO lid_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Eme ma iy anya eh, “Jo tikisiy iri lau jo mwesekei ma hawe iri katin haka hawe sirih, arile jo kameh idi iri mari kameh amak ai.” ");
INSERT INTO lid_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Arile Kindrei ja badeh sekesek handru labai ta Nowa. ");
INSERT INTO lid_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Ya i dah badeh nyala Nowa ai. Nowa badeh nadun mwan badeh taloh; Sem eh, Ham eh, hawe Jepet. Nowa bamwekes se lakou bandra-i bwe ai, na len iy udu loken. Iy badeh anuhun sahou ma lakou mari mwasin ta Kindrei badeh iy in hamon ta aliy le ai. ");
INSERT INTO lid_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Arile iri lau mari badeh amwekes lakou leleyah, amwekes karei ma lomondra ndra-in tinan labai udu mada Kindrei. ");
INSERT INTO lid_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kindrei anyolom eme munyak badeh, iy anyolom karei ma lomondra ndra-in tiri lau ndrala labai ai, tasah lau badeh amwekes lakou leleyah udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Eme Kindrei tiye i ta Nowa, “Jo badeh ndratehei budon ta edeu sendrehendreh i tiri lau mari. Jo kameh idi iri ma munyak amak, tasah munyak badeh ndradah ta lomondra ndra-in tiri. ");
INSERT INTO lid_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ou badeh awuri ra-ei ndron na kei ki tam; ou mwesekei rum kudu aliy ano ou alesei ka-u ndron manan ma bolon. ");
INSERT INTO lid_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ou badeh tomondrohei nyaha ndron badeh kasahan rinek tonoh taloh (133) mita, ya tinan ta ndron badeh kasahan lunoh la-uh (22) mita ano tinan ta i loken badeh kasahan ronoh taloh (13) mita. ");
INSERT INTO lid_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ano ou mwesekei ndruwi bolobon ma ka-un i loboho loke reu kudu aliy, ki winiya hanoh hahuw sentimita ma ka-un ale ki buku aliy. Ya ou mwesekei sarasar ki taloh ma ou atehei mada san kudu kabede ndron. ");
INSERT INTO lid_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Jo kameh bwidi kon munyak kameh atuh ma lakou mari mulin badeh kameh amak. ");
INSERT INTO lid_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Arile jo kameh amwekes sahou randra le hawem. Ano ou a ndron hawe udum, hawe nadum oro ma udu oro. ");
INSERT INTO lid_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Ou andrei iri lakou mulin, ari mwan ari badih badeh kawek ndron ta iri badeh samak. ");
INSERT INTO lid_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ou kuhi saba nyamon ki nam ma tiri ale badeh kewek.” ");
INSERT INTO lid_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Eme Nowa badeh anuhun sahou ya iy mwekesei i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Eme Laban Kindrei tiye i ta Nowa, eme iy anya eh, “Ado mari ka ndron; jo badeh anyolom ou le badeh ado bolo munyak dah, ou amwekes kandriyen mwasin. ");
INSERT INTO lid_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ou kuhi ndro taloh katin haka mwasin ta asun ta salom, ari mwan hawe ari badih, ma ou kuhi ari ari katin haka ndra-in, mwan ma badih ndra-in ta salom. ");
INSERT INTO lid_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ou ale kuhi ndro taloh sirih, ari mwan ari badih. Ou an hamon ta bohok, tasah oro sirih ma katin haka randrah doh randrah doh kameh ado ma kameh adeu nah ja ado bwele-e munyak. ");
INSERT INTO lid_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ya len ndro taloh ano kameh jo kameh edeu ur undruk winiya len ma ben hanoh (40) ta adi iri mulin mari jo mene mwesekei.” ");
INSERT INTO lid_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Eme Nowa badeh mwesekei lakou mari Kindrei tiye. ");
INSERT INTO lid_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowa badeh jaha tan asahan ndro hawa (600) eh, badeh kon munyak atuh. ");
INSERT INTO lid_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Eme ya iy hawe udun, ma nadun oro hawe udu oro an ndron, tasah kon kameh atuh ai, ");
INSERT INTO lid_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","ma hawe ari mwan ari badih katin haka ma iri sirih ndra-in ma mwasin badeh an ndron hawe Nowa, i le buku Kindrei ndratiye. ");
INSERT INTO lid_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ano len ndro taloh ano badeh kon atuh. ");
INSERT INTO lid_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Eme len Nowa jaha tan asahan ndro hawa (600), eme, len ronoh ndro taloh na bun la-uh; badeh gwa udu baha munyak eme loken, ma kandrah asak. ");
INSERT INTO lid_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ano badeh ur eme andri winiya len ma ben hanoh. ");
INSERT INTO lid_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ya eme na len doh badeh Nowa hawe udun ma nadu uru mwan ma taloh hawe udu nadun oro badeh a ndron ai, ");
INSERT INTO lid_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ma hawe iri katin haka ndriliu ma ndriliu bwe, tinan ma bwisik ma saba sirih ale, ya iri ndrateheyan labai. ");
INSERT INTO lid_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Ari mwan ari badih katin haka mulin badeh a ndron hawe Nowa, i buku none Kindrei ndratiye. Ano Nowa oro a bolon badeh, Kindrei le sulu-i kou ili. ");
INSERT INTO lid_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Eme ur undruk udu bolo len hanoh nane eme ma ndron badeh telebek. ");
INSERT INTO lid_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Gwa eme loken labai, eme badeh ma ndron ateheh bwele-e gwa. ");
INSERT INTO lid_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Eme uluw eme loken labai eme badeh mandrei lawe-en sakalawi mandrei mari badeh atuh. ");
INSERT INTO lid_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Eme gwa eme loken, eme loken badeh nyahan ta aliy asahan taloh ranah udu ta mandrei nane iu i loken. ");
INSERT INTO lid_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Eme iri mulin mari badu munyak badeh amak, iri sirih eneh, iri katin haka eneh ma ndramak awas badeh amak ai. ");
INSERT INTO lid_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Iri lakou mari mulin ado munyak badeh amak le ai. ");
INSERT INTO lid_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Laban Kindrei badeh idi iri mulin mari ado munyak badeh amak ma lau awas ma katin haka ma sirih badeh amak. Iri mulin le ado badeh, Nowa le hawe iri mulin rayah nane a ndron hawen. ");
INSERT INTO lid_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Gwa badeh bala se andri bwe winiya len rinek lomonoh (150). ");
INSERT INTO lid_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kindrei badeh balen bamani Nowa ma hawe iri katin haka nane an hawen an ndron bwe; eme iy bwidi jor atohou ma amwekes gwa i lok i andri. ");
INSERT INTO lid_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Eme gwa badu baha munyak badeh badek bwe ma mada san ta gwa badu kandrah ili. Ya ur amondrei. ");
INSERT INTO lid_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Eme udu bolo len rinek lomonoh (150) badeh gwa i lok ai. ");
INSERT INTO lid_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Eme na len ronoh ndro taloh (17) udu bolo bun ndro taloh badeh mwe-e ndron amar ta mandrei Ararat. ");
INSERT INTO lid_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Gwa badeh i lok kahis le eme na len ari asahan mwena ta bun ronoh badeh no-o mandrei asahan. ");
INSERT INTO lid_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ano len hanoh ano badeh Nowa sihi kadam asak. ");
INSERT INTO lid_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Eme iy suni sirih ari ta aimon lakou abola nyara Raben badeh iu ili. Eme iy bame hamon bwe, iy atah atah le winiya gwa amar. ");
INSERT INTO lid_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ano ja badeh iy suni ban ili ta anyolom gwa ndra andri de bwe. ");
INSERT INTO lid_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Arile gwa bala se andri bwe eme ban dah basilahei ndrahun ta manyah bwe, eme iy atah eme hamon eme ndron. Eme Nowa atehei minen i manan andrei iy eme bolon. ");
INSERT INTO lid_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ano Nowa abe-en ben ndro taloh ja ano badeh iy suni ban ili ja. ");
INSERT INTO lid_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Eme ban nane eme hamon eme hawen na beyeh ma la-u kei aloh olip badeh udu bohon eme, ya eme Nowa ndratanan ai, gwa ndra andri ai. ");
INSERT INTO lid_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ano iy bini-i ben ndro taloh iu ano iy suni ban ili ja; eme ban dah ili ma ili ya iy bame hamon bwe. ");
INSERT INTO lid_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ano na len Nowa jaha tan asahan ndro hanek ari (601), na len ma mwena asahan ta bun ari badeh gwa amar. Eme Nowa abe-ei bwele-e ndron eme iy anyolom ili eme ma iy anyolom munyak anya kabosar ai. ");
INSERT INTO lid_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Eme na len lunoh ndro taloh (27) badeh munyak abosar mara-ei. ");
INSERT INTO lid_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Eme Kindrei tiye i ta Nowa, “Ou ma udum ma hawe nadum oro ma udu oro kame len ta ndron. ");
INSERT INTO lid_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ou kuhi iri sirih ma iri katin haka kame len hawem, ma iri kadeu nah ma kaseker kaweleyani kon munyak mari.” ");
INSERT INTO lid_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ya eme Nowa eme len ta ndron hawe udun, ma hawe nadun oro ma hawe udu nadun oro, ");
INSERT INTO lid_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ma hawe iri katin haka ma iri sirih arakou le adek ame len ta ndron, randrah doh randrah doh badeh adek ase. ");
INSERT INTO lid_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ano Nowa eme tukumwi bek; ano iy andrei ari ari badu tiri katin haka ma hawe iri sirih ari ari mwasin badeh iy asun iri ma buruwen in bada bek dah i nyara salom i ta Laban. ");
INSERT INTO lid_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Eme mahu bubure salom dah mwesekei Laban sekesek handru eme ma iy tiye udu ndrinen i buku doh, “Jo kameh winiya badeu maha bame ta munyak ja bwe ai, tasah tiri lau amwekes lakou; jo tanan na len iy ma loweu le badeh budon tan ma ndra-in le. Eme ya jo kameh winiyan badai iri lau mari ja bwe ai, i buku jo mene amwekes dah ja bwe ai.” ");
INSERT INTO lid_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“I dah mada an ta atah basoh Ma i dah kameh mada an ta a-eh Ma abwe-eh udu aliy, I buku munyak udu le. Ya i dah kameh kon anyala Ma kon i nyarahan, Kon an ma hawe kon ur Udu bolo len ma ben.” ");
INSERT INTO lid_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Eme Kindrei atehei nyosowan i bwele-e Nowa hawe nadun oro ano ma iy tiye, “Ado kadeu nah ma lundriye ado oro kaweleyani kon munyak mari. ");
INSERT INTO lid_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ya i dah kameh iri katin haka, sirih ma hawe iri ni kameh anoh adoh, ma iri kameh are baha tondrok tado. ");
INSERT INTO lid_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Eme ado badeh kaimon iri hawe bara la-u kei; jo atehei mari doh ta nyumon tado. ");
INSERT INTO lid_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Arile lakou ari le doh badeh ado saimon, lakou mulin ma ndra; jo anya ndri-i, ndra ki-iu op, tasah lakou doh badeh kohan ma ndrayen udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","I buku none are lau idi iri lau awas amak, i dah kameh iy kameh akohok sisi-in ta aliy. Ma jo kameh edeu isi i tare katin haka i buku none iy aimon lau amak. ");
INSERT INTO lid_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Tasah ndramak badeh mwesekei iy konen i le buku Kindrei, eme ya i buku none are lau idi ari ndramak imek, badeh iy ndramak nane doh, badeh lowan oro kadai iy kimek. ");
INSERT INTO lid_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“Ado badeh kamwekes nah kasola eme lundriye ado oro kado ma kaweleyani bolo munyak mari.” ");
INSERT INTO lid_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ano Kindrei tiye i ta Nowa hawe nadun oro, ");
INSERT INTO lid_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Na dah jo kameh amwekes sahou randra le hawem ma hawe tubum oro, ");
INSERT INTO lid_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ma hawe iri mulin mari ala ado ndron mene ame len hawem. ");
INSERT INTO lid_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Na sahou dah jo amwekes sahou randra le hawem, ya jo tandrakan jo kameh winiyan badai lakou mulin mari bwe ai, na len kon atuh bwe ai; ma badai munyak ma winiyan kon winiyan batuh ja badeh bwe ai. ");
INSERT INTO lid_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ya na kalem dah udu le ta sahou randra le, jo badeh amwekes hawem ma hawe iri mulin mari hamon asahan. ");
INSERT INTO lid_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Jo kameh edeu betekenyabwiu udu bolo asi kandrah. I doh badeh kalem ta sahou randra le tek i hawem ma hawe iri mulin mari badu munyak. ");
INSERT INTO lid_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ya i buku none jo tubulu-i kandrah na asi kandrah ma betekenyabwiu asahan, ");
INSERT INTO lid_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","badeh kameh jo abudon tandrakan tek mene ewek tam, ma i tiri katin haka mulin mari ta kon winiyan batuh ta adai iri ja bwe ai. ");
INSERT INTO lid_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ya buku none betekenyabwiu asahan bolo asi kandrah ya i buku jo anyolom kameh, jo kameh lomondrani sahou randra le tek hawe iri mulin mari badu munyak. ");
INSERT INTO lid_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Eme i dah kalem tek jo edeu udu ndrokowak hawe iri mulin mari.” Nowa Hawe Lundriyen Oro ");
INSERT INTO lid_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Eme ya nadu Nowa oro ame len ta ndron badeh, kadok badeh nyaran Sem, bwaneh badeh nyaran Ham ya silih Jepet. (Ham badeh tama Kenan). ");
INSERT INTO lid_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nadu Nowa oro ma taloh doh baden adeh tubu iri lau mari badu munyak. ");
INSERT INTO lid_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nowa badeh ndramak ta amwekes bilin ma hawe iy ndramak ta atah wa-in ma mwena. ");
INSERT INTO lid_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ano hamon ta iy a-un wa-in ano badeh ma iy ibo lolo-ou ma iy amadin kolau bwe, udu bolo asiu balei. ");
INSERT INTO lid_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Eme tama Kenan Ham badeh eme anyolom taman kolau bwe eme ma iy suburuk i ta nadu tinen uru. ");
INSERT INTO lid_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ano Sem uru Jepet ame andrei kolau, ano uru talahani udu kona uru. Eme uru adek na kona uru ala badeh tubulu-i tama uru. Ya mada uru badeh batou tama uru bwe. ");
INSERT INTO lid_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ano boto-on ta wa-in ano badeh Nowa amak iy i tanan ai nadun bwaneh badeh amwekes lakou nane doh i tan, ");
INSERT INTO lid_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","eme iy anya, “Jo tandrakan Kenan kameh i bonyo-ou ta nadu tinen uru. ");
INSERT INTO lid_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Katudun Laban Kindrei ta Sem! Kenan kameh i bonyo-ou ta Sem. ");
INSERT INTO lid_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ya Kindrei badeh mwesekei kane Jepet ki sola! Ya lundriyen badeh kamanyah kado hawe lau ta Sem oro. Ya Kenan badeh ki bonyo-ou ta Jepet.” ");
INSERT INTO lid_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Ano hamon ta kon atuh badeh Nowa udu winiya jaha tuluwi lemenek (350). ");
INSERT INTO lid_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ano jaha tan asahan ndro rawa lemenek (950) badeh ma iy imek. ");
INSERT INTO lid_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","I dah sare nadu Nowa oro; oro badeh Sem eh, Ham eh ma hawe Jepet. Hamon ta kon atuh badeh ano badeh oro nah ma taloh nadu oro udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ya nadu Jepet oro badeh Goma, Megok, Madai, Jaban, Tubal, Misek ma hawe Tiras ya eme i dah badeh nyara tubu oro. ");
INSERT INTO lid_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Nadu Goma oro badeh iri lau ala ado kon Askanas, iri ado kon Ripat ma ado kon Togama. ");
INSERT INTO lid_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ya nadu Jaban oro badeh ado kon Elisah, ado kon Spa-in, ado kon Saipres ma kon Rodes. ");
INSERT INTO lid_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Oro badeh tubu iri lau badu busu. Ya i dah baden eh tubu Jepet oro. Oro badeh manyah ado boho kamen ra-em ra-em ado kon rakon rakon. Ya boho kamen ra-em ra-em asehek bohon randrah labai udu kon nane doh. ");
INSERT INTO lid_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Nadu Ham badeh Kus, Ijip, Libiya, ma hawe Kenan ya oro doh badeh tubu oro nyara oro i dah. ");
INSERT INTO lid_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Tubu iri Kus doh badeh badu kon Seba, badu kon Habilah, badu kon Sabtah, badu kon Rama ma kon Sabteka. Tubu Rama badeh lau badu kon Seba hawe kon Dedan. ");
INSERT INTO lid_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Nadu Kus ari badeh nyaran Nimrot, iy badeh ma mwena asahan ndramak ta inyek kon ");
INSERT INTO lid_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","ma na seben ta Kindrei badeh iy badeh asahan ndramak ta bwisir ta katin haka, eme ya iri lau anya, “Kindrei badeh kabwidi ou kasahan ndramak ta bwisir ta katin haka ki le buku Nimrot!” ");
INSERT INTO lid_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ma mwena handru badeh iy badeh atondrok Babilon ma hawe kon Irek, kon Akat ya oro kon ma taloh doh badeh udu bolo kon tinan Babilon. ");
INSERT INTO lid_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Udu munyak doh badeh iy iu ili Aseriya ma tahi kon tinan aloh Ninibeh, kon Rehobot Ir, kon Kalah, ");
INSERT INTO lid_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ma Resen badeh udu ndrokowa Ninibeh ma ndrokowa kon tinan aloh Kalah. ");
INSERT INTO lid_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ya tubu Ijip badeh lau badu kon Lidiya, badu kon Anam, badu kon Lehap, badu kon Naptuh, ");
INSERT INTO lid_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","badu kon Patrus, badu kon Kasluh ma kon Krit, ya na oro doh le badeh iri Pilistin asahan. ");
INSERT INTO lid_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Nadu Kenan oro badeh kadok badeh Sidon ano badeh Het, ya i dah nyara tubu oro ai. ");
INSERT INTO lid_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kenan badeh tubu iri badu Jebusa, tubu iri Amora, tubu iri badu Gigasa, ");
INSERT INTO lid_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","tubu iri badu Hiba, tubu iri badu Aka, tubu iri badu Sina, ");
INSERT INTO lid_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","tubu iri badu Abada, tubu iri badu Samara ma hawe tubu iri badu Hamata. Ya oro boho kamen mari ta Kenan badeh aseker. ");
INSERT INTO lid_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ya kobek ta Kenan badeh ili taku kum ano ili isos Gerar mirihik ta kon Gasa. Ano ili loboho lan ili isos Sodom, Gomorah, isos Admah ma hawe isos Sebo-im mirihik ta Lasa. ");
INSERT INTO lid_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","I doh tubu Ham oro ya oro badeh manyah boho kamen ra-em ra-em ado munyak toro ma boho kamen toro badeh asehek boho kon toro randrah labai. ");
INSERT INTO lid_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ya Sem bwele-en ta Jepet badeh tubu iri Hiburu mari. ");
INSERT INTO lid_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ya nadu Sem oro badeh Ilam eh, Asur eh, Apaset eh, Lut eh, ma hawe Aram. Ya tubu oro lau ala nyara oro doh. ");
INSERT INTO lid_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Badeh lau ala are kon Us, are Hul, are Geta, are Mesek, badeh tubu Aram oro. ");
INSERT INTO lid_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Apaset badeh tama Silah ma Silah ja badeh tama Eba. ");
INSERT INTO lid_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eba badeh nadun badeh la-uh; ari badeh nyaran Pelek, tasah na len doh badeh lau badu munyak apou iri; ya iy ari ja badeh nyaran Joktan. ");
INSERT INTO lid_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ya iri lau badu kon Almodat, badu Selep, badu Hasamabet, badu Jerah, ");
INSERT INTO lid_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","badu Hadoram, badu Usal, badu Diklah, ");
INSERT INTO lid_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","badu Obal, badu Abima-el, badu Siba, ");
INSERT INTO lid_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","badu Opir, badu Habilah, ma hawe Jobap. Oro mari doh badeh nadu Joktan le. ");
INSERT INTO lid_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ya munyak oro are aliy badeh tinan tan badeh udu kon Mesa ili isos Separ udu loboho bolo mandrei loboho an eme loken. ");
INSERT INTO lid_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ya i dah badeh tubu Sem oro ya oro manyah boho kamen ra-em ra-em ado loboho munyak toro, ya oro badeh boho kon toro bala le randra bwe. Iy ari asehek tan labai iy ari asehek tan labai. ");
INSERT INTO lid_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Iri lau mari doh badeh lundriye Nowa, kon ari i buku ari asahan ta boho kamen ra-em ra-em. Kon atuh ya hamon ta aliy kon munyak badeh asahan na lundriye Nowa oro. ");
INSERT INTO lid_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ma mwena handru badeh lau badu munyak badeh asehek boho kon randra le. ");
INSERT INTO lid_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Eme iri badeh adek ala ame loboho an eme loken, eme iri ame Babilon ma ado aliy ado ai. ");
INSERT INTO lid_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ano badeh iri lelen iri ari ari, “Ado kame! Ya to kapon ndren ma kamwekes kabadok.” Eme iri asun ndren i bek ano iri amwekes alis i ta bek ta kasabata-an ki se. ");
INSERT INTO lid_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","eme iri anya, “Taha kamwekes asiu bokok kudu bolo kon dah ki loken bolo asi kandrah, eme ma to kasore nyara to ma to badeh saseker sala bolo munyak mari.” ");
INSERT INTO lid_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Eme badeh Laban eme andri bolo kon nane doh ma anyolom asiu nane iri atah ma atudun dah. ");
INSERT INTO lid_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ano ma iy anya, “Iri lau dah badeh iri rabuk le, ma iri asehek sahou randra le; I dah ma mwena ai, ta iri amwekes lakou dah. Mirihik kameh iri amwekes lakou leleyah na seken tiri ai. ");
INSERT INTO lid_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","To ka-au ka andri, katubuni boho kon tiri, eme ya iri sanuhun sahou tiri ari ari.” ");
INSERT INTO lid_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Eme badeh Laban sekerei iri badeh winiya munyak mari, ma iri ruwani asiu bokok ma iri batah bwe ai. ");
INSERT INTO lid_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kon tinan nane doh nyaran Babilon, tasah Kindrei badeh tubuni boho kon tiri lau mari ma kabatana doh badeh iri lau aseker ma weleyani kon munyak mari. ");
INSERT INTO lid_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ya i dah badeh lundriye Sem oro. Hamon ta kon atuh ya jaha la-uh ano badeh Sem badeh jaha tan asahan rawa (100), eme badeh nadun ari asahan nyaran Apaset. ");
INSERT INTO lid_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Hamon ta aliy badeh iy udu winiya jaha lemenek (500) ma hawe nadun rayah ale udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ya na len Apaset jaha tan asahan tonoh limeh (35) eme nadun ari asahan nyaran Silah. ");
INSERT INTO lid_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Hamon ta aliy badeh iy udu winiya jaha hanek taloh (403) ma iy atehei nadun rayah udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Eme Silah jaha tan asahan tonoh (30) badeh eme iy atehei nadun ari nyaran Eba. ");
INSERT INTO lid_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Hamon ta aliy iy udu winiya jaha hanek taloh (403) ma atehei nadun rayah ale. ");
INSERT INTO lid_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ano len Eba jaha tan asahan tonoh hahuw (34) badeh iy atehei nadun ari nyaran Pelek. ");
INSERT INTO lid_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ano hamon ta aliy badeh iy udu winiya jaha hanek tonoh (430) ma atehei nadun rayah ale udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ano len Pelek jaha tan asahan tonoh (30) badeh iy atehei nadun ari nyaran Reu. ");
INSERT INTO lid_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ano hamon ta aliy badeh iy udu winiya jaha lunek ndro ari (209) ma iy atehei nadun rayah ale udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ano len Reu jaha tan asahan tonoh la-uh (32) badeh iy atehei nadun ari nyaran Serak. ");
INSERT INTO lid_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Eme hamon ta aliy badeh iy udu winiya jaha lunek ndro taloh (207) ma iy atehei nadun rayah ale udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ano na len Serak jaha tan asahan tonoh (30) badeh iy atehei nadun ari nyaran Nahor. ");
INSERT INTO lid_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ano hamon ta aliy badeh iy udu winiya jaha lunek (200) ma iy tuwi nadun rayah udu aliy ale. ");
INSERT INTO lid_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ano na len Nahor jaha tan asahan lunoh ndro ari (29) badeh iy atehei nadun ari nyaran Tera. ");
INSERT INTO lid_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ano hamon ta aliy badeh iy udu winiya jaha rinek ronoh ndro ari (119) ma tuwi nadun rayah ale udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ano hamon ta Tera jaha tan asahan ndro tonoh (70) badeh iy atehei Abram atehei Nahor ma hawe Haran. ");
INSERT INTO lid_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","I dah lundriye Tera oro, iy ala tama Abram tama Nahor hawe Haran. Haran badeh tama Lot. ");
INSERT INTO lid_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Eme Haran badeh imek udu kon tan amwenen udu Ur udu Babilon. Ya taman badeh bamak bwe iy udu le. ");
INSERT INTO lid_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ano Abram sudi Sarai i tan ma Nahor sudi nadu Haran badih nyaran Milkah. Ya Haran badeh tama Iska. ");
INSERT INTO lid_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai badeh bato-ou nah bwe, iy badeh kis. ");
INSERT INTO lid_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera kuhi nadun Abram hawe udun Sarai ma hawe nadu tubun Lot, iu ndrine Haran. Eme ma oro au ame len ta kon tinan Ur udu bolo Babilon ma au ala munyak Kenan. Eme oro ala asos Haran ma ado aliy ai. ");
INSERT INTO lid_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Eme Tera imek udu aliy ya jaha tan badeh lunek limeh (205). ");
INSERT INTO lid_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ano Laban tiye i ta Abram, “Ou au ta munyak tam ma ou au ta lowam oro hawe asiu ta tamam ya ou au ai, ala kon munyak jo kameh leheya tam. ");
INSERT INTO lid_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Jo kameh edeu lundriyem oro asahan solo-an ma i dah kameh oro asahan kon rakon buruwen. Ya i dah kameh, jo nyosowani ou ma nyaram kameh lau mari i tanan ma nyosowan kameh i tiri lau. ");
INSERT INTO lid_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Jo kameh nyosowani are aseken ou. Arile jo kameh edeu isi i tare lau aten ou. Na ou le kameh jo kameh edeu nyosowan i lau kon rakon rakon buruwen.” ");
INSERT INTO lid_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Eme na len Abram jaha tan asahan ndro tonoh limeh (75) iy edek udu Haran eme len i buku none Laban ndratiye tan, ma Lot i hawen ale. ");
INSERT INTO lid_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Eme Abram andrei udun Sarai hawe Lot, nadu uru nadu tinen Haran, ma hawe lakou tan mari hawe iri lohowan tan. Iri mene ado Haran au ala munyak Kenan. Len oro asahan Kenan badeh ");
INSERT INTO lid_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram edek ili eme bolo munyak doh, eme iy asahan ta kei ndrabun badu Moreh, kon ndrabun udu Sekem (na len doh badeh iri Kenan are aliy). ");
INSERT INTO lid_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Eme Laban asahan hawe Abram ma iy tiye i tan i buku doh, “I dah kon munyak kameh jo edeu i ta lundriyem oro ai.” Ano Abram tukumwi bek i ta Laban mene asahan hawen. ");
INSERT INTO lid_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ano badeh iy edek ili loboho kum kon mandrei solo-an udu loboho lan eme loken kon tinan nyaran Betel, ano iy tahi asiu balei udu loboho an i andri ndrokowa Betel hawe Ai, udu loboho an eme loken. Ano iy tutuni bek ma iy aloh nyara Laban. ");
INSERT INTO lid_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ano iy edek rakon i rakon loboho kum loboho kon Kenan. ");
INSERT INTO lid_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Eme ya Kenan badeh nyamon bwe, eme iri akohok andra-i labai, eme badeh Abram iu i andri manyah sese udu loboho kum ta Ijip. ");
INSERT INTO lid_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Na len iy anya ki bilisiu ta kobek ta Ijip, iy tiye i ta udun, “Ou badeh ou badih konen labai. ");
INSERT INTO lid_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","I buku none iri Ijip anyolom ou kameh iri anya ou kede-eh uduk ma i dah kameh iri kameh adai jo ya ou kameh ado. ");
INSERT INTO lid_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ou kameh tiye tiri, ou badeh nadu tine, tasah na ou kameh iri kameh badai jo bwe, ma iri kameh tondrokei jo kameh udu mwasin.” ");
INSERT INTO lid_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Eme iy sakalawi kobek i bilisiu badeh iri Ijip anyolom udun badeh konen labai, ");
INSERT INTO lid_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","eme iri lau ta lahou badu bolo asiu ta kabin anyolom iy badeh konen labai, eme iri ala asehek i ta kabin, eme ma iri andrei iy ili loboho ndrahu kabin. ");
INSERT INTO lid_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Na iy le badeh kabin tondrokei Abram udu mwasin, nyohonei iy iri katin haka aloh sipsip, nyohonei iy katin haka aloh me, nyohonei iy katin haka aloh bulumakau, nyohonei iy katin haka aloh donki hawe katin haka aloh kamel ma hawe iri bonyo-ou tan ale. ");
INSERT INTO lid_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Laban eme atehei sik i tan ma hawe iri lau are bahan, tasah iy mene andrei Sarai. ");
INSERT INTO lid_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Eme kabin tiye Abram eme ya iy lelen iy, “Ou amwekes sasah eme tek dah? ");
INSERT INTO lid_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","I buku sah ou anya i dah nadu tinem, eme ya jo kandrei iy keme uduk. Udum doh, ou andrei iy ma ah ka-au!” ");
INSERT INTO lid_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Eme kabin tiye iri lau tan tiyani iy eme len ta kon munyak doh hawe udun ma iri lakou tan mari. ");
INSERT INTO lid_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Lot i hawe Abram uru udun ma hawe lakou ta Abram mari, eme oro au ala loboho rai ta Ijip ano oro ala loboho kum ta Kenan. ");
INSERT INTO lid_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram badeh tan lakou solo-an handru en, iri katin haka i buku none iri sipsip, me hawe bulumakau, bek nyikilikin silba hawe gol. ");
INSERT INTO lid_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ano badeh iy udu doh edek i rakon rakon ili Betel. Eme iy asahan kon mene ndrokowa Betel hawe Ai kon mene iy udu aliy bwena. ");
INSERT INTO lid_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Eme iy eme ta bek mene iy tukumwi ma iy aloh nyara Laban. ");
INSERT INTO lid_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot badeh tan iri sipsip, me ma bulumakau ale i buku none udun nadun oro hawe iri lohowan tan ale. ");
INSERT INTO lid_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Eme ya uru badeh munyak hawe bwidiu solo-an bwe, winiya uru ma la-uh bwe, tasah uru badeh katin haka turu badeh solo-an labai. ");
INSERT INTO lid_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Eme iri lau ta tondrok katin haka ta Abram hawe ta Lot badeh andra-i. (Na len doh badeh iri Kenan hawe iri Perisa badeh manyah ado munyak nane doh). ");
INSERT INTO lid_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ano badeh Abram tiye ta Lot anya eh, “Talu badeh lowa talu, arile lau tam hawe lau tek badeh andra-i. ");
INSERT INTO lid_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Eme ya talu kapou talu. Ou aseken munyak loboho heh bwena? I buku none ou aseken bilisiu badeh bilisiu baden eh jo ki aliy ai.” ");
INSERT INTO lid_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Eme Lot anyolom ili eme iy anyolom nyamak Jordan ili isos So-ar badeh gwa solo-an i buku none bilin ta Kindrei ma i buku none munyak badu Ijip. (I doh badeh Kindrei basulumwi kon tinan Sodom hawe Gomora bwe le). ");
INSERT INTO lid_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Eme Lot badeh solo-ei nyamak mari badu Jordan badeh i tan, eme iy iu i loboho lan ai. I dah sihide uru ma la-uh atalan i buku sah. ");
INSERT INTO lid_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ya Abram badeh udu munyak Kenan udu ai, ya Lot baden eh ili manyah udu bolo kon tinan nyamak ma manyah mirihik ta Sodom. ");
INSERT INTO lid_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Iri badeh kandriyen tiri badeh ndrandra-i labai ta mada Kindrei. ");
INSERT INTO lid_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ano hamon ta Lot ndra-au badeh, Laban tiye ta Abram, “Kon ou are aliy baden, ou suri ou, ma ou anyolom kili keme ki jaha, ki rai, ki kum ma ki lan. ");
INSERT INTO lid_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","16","Jo kameh edeu munyak doh i tam ma lundriyem oro kameh nyaran bwe, winiya ari lau winiyan bandromwei bwe; on badeh winiyan andromwei. ");
INSERT INTO lid_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ou ala anyolom kili bwele-e munyak mari, munyak jo kameh edeu i tam.” ");
INSERT INTO lid_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Eme Abram ili tahi asiu udu mirihik ta kei ndrabun loboho Mamre udu Hibron, eme udu doh badeh iy tukumwi bek ta salom i ta Laban. ");
INSERT INTO lid_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Na len kabin Amrapel badu Babilon, Ariyok badu Elasar, Sedola-oma badu Ilam ma Tidal badu Go-im, ");
INSERT INTO lid_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","oro badeh ala amwekes bahun i ta kabin ma limeh: oro kabin doh badeh, Bera badu Sodom, Birsa badu Gomora, Sinah badu Admah, Semeber badu Sebo-im ma hawe kabin badu Bela (So-ar). ");
INSERT INTO lid_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ya oro kabin ma limeh doh badeh atukum ase ma lau ta bahun badeh ado nyamak Sidim, na dah badeh aloh gwa ndras nyakadan. ");
INSERT INTO lid_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Oro badeh mene are baha tondrok ta Sedola-oma winiya jaha ronoh la-uh arile na jaha ronoh taloh badeh oro bwale oro ta are bahan. ");
INSERT INTO lid_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Na jaha ronoh hahuw badeh Sedola-oma hawe iri kabin ta seben tan badeh, ame ma lau ta bahun tiri, ame andrei iri Repa-im an Asterot Karna-im, ma Susim an Ham, iri Emim ado loboho munyak ta Kiriyata-im, ");
INSERT INTO lid_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ma hawe iri Hora ado mandrei Idom, tikahei iri ala Elparan loboho ka-u lomale an (kon ndra an le). ");
INSERT INTO lid_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ano oro tubuni oro, ano oro ame Kades (aloh Enmispat). Oro andrei munyak mari tiri Amaleka ma andrei Amora kon oro manyah ado Hasason Tamar. ");
INSERT INTO lid_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Ano iri kabin badu Sodom, badu Gomora, badu Admah, badu Sebo-im ma Bela tukumwi iri lau ta bahun tiri, ma amwekes bahun ado nyamak Sidim, amwekes bahun, hawe iri kabin badu Ilam, badu Go-im badu Babilon hawe Elasar. Kabin limeh amwekes bahun i la-u kabin hahuw. ");
INSERT INTO lid_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Eme nyamak doh badeh lawes udu aliy eme ya iri kabin badu Sodom hawe Gomora anya katobwak ta bahun eme badeh iri taku a bolo lawes amwekes na lakou sabata-an nane dah, eme ya oro kabin taloh le badeh taku akoh a mandrei. ");
INSERT INTO lid_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Eme oro kabin ma hahuw dah andrei lakou mari badu Sodom hawe Gomora, ma nyamon ale ma oro au. ");
INSERT INTO lid_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ya Lot nadu nadu tine Abram badeh oro ado Sodom, eme badeh iri andrei oro ma lakou toro mari. ");
INSERT INTO lid_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Eme ndramak ari ta atobwak eme badeh tiye nyala Abram ta lakou mari. Abram badeh Hiburu. Iy manyah udu mirihik ta kei ta aton ta Mamre badu Amora. Mamre hawe nadu tinen Eskol ma Aner badeh, oro lau ta seben Abram. ");
INSERT INTO lid_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Eme Abram anuhun iri badeh ndrakuhi Lot oro. Eme iy nyuruwini iri lau ta bahun tan badeh ame, iri mari a se badeh asahan tonek ronoh ndru la-uh (318). Eme iri tikahei iri badeh ala asos Dan. ");
INSERT INTO lid_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ano iy apwai lau ta bahun tan, ano na ben badeh iri ala amwekes bahun tikahei iri ala asos Hobah loboho Damaskus. ");
INSERT INTO lid_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Eme iy kuhi lakou mari mene andrei eme hamon. Ma hawe lowan Lot hawe lakou tan mari ma hawe iri badih ma hawe lau rayah ta bolo kou. ");
INSERT INTO lid_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ano len Abram eme hamon ta bahun ta i la-u Sedola-oma ma hawe iri kabin badeh, eme badeh kabin badu Sodom ili aturuk iy udu nyamak Sabeh (aloh Nyamak ta kabin). ");
INSERT INTO lid_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Eme kabin Melsisedek, kabin badu Salem, lau ta ndrokowa lau hawe Kindrei ta Kindrei badu loken, eme atiye jabi hawe wa-in i na Abram. ");
INSERT INTO lid_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Eme iy atehei nyosowan i tan, ano iy anya, “Ya abo, Kindrei badu loken, ou ta amwekes munyak ma kandrah, ou nyosowani Abram! ");
INSERT INTO lid_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kindrei badu loken atehei boto-on i tam ta bahun, ya masiye badeh ki ta Kindrei!” Eme badeh Abram eme atehei lakou tan rayah, i buku ronoh, iy atehei ari i tan ya i buku rinek, ronoh i tan, lakou doh iy andrei ta bahun eme badeh atehei i ta Melsisedek. ");
INSERT INTO lid_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ano kabin ta Sodom tiye i ta Abram, “Lakou tam mari kudu gwek, jo aseken le lau tek.” ");
INSERT INTO lid_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Eme Abram anya eh, “Jo badeh tandrakan ta mada Laban Kindrei badu loken, ndramak ta amwekes munyak ma kandrah, ta jo winiyan basolo-ei ari lakou tam bwe, i buku none saba lakou nadu bwisik i buku kam hawe ku-i katim. Bakameh hamon ou asehek, ‘Jo le badeh jo mwesekei Abram tan lakou solo-an.’ ");
INSERT INTO lid_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Jo kameh winiyan basolo-ei ari lakou bwe. Jo aseken lakou le iri lau tek mene andrei ma ndraniy badeh keme ai. Arile Aner, Eskol hawe Mamre, oro lau ta aseben jo badeh kakohok ki toro ai.” ");
INSERT INTO lid_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ano hamon ja badeh lele asahan ta Abram, eme iy anuhun Laban tiye i tan, “Abram, ou sanoh! Jo kameh i turuk tam ma jo kameh edeu nyosowan tinan labai i tam.” ");
INSERT INTO lid_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Arile Abram anya eh, “O Laban Kindrei, jo kada-ah nah bwe, ya saba lakou mwasin kameh ou kameh atehei eme la-uk? Lau ta atondrok lakou tek badeh Eliyesar badu Damaskus. ");
INSERT INTO lid_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ou badeh badeu tek rayah nah bwe, eme i dah kameh lau ari badu bolo oro lohowan tek kameh atondrok lakou mari tek ai.” ");
INSERT INTO lid_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ano iy anuhun Laban tiye tan ja, “Eliyesar lohowan tam badeh kameh batondrok lakou tam bwe, i dah kameh nadum amwenen kameh atondrok.” ");
INSERT INTO lid_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Eme Laban kuhi iy eme manan ma tiye, “Ou anyolom ki loke bada kandrah ya none ou ondrek ndrau se, ou kameh lundriyem oro kameh i solo-a ndrau don.” ");
INSERT INTO lid_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Eme badeh Abram atehei budon tan handru in ta Laban, tasah ta katin doh badeh Laban sekesek ma aseken iy ma aloh iy mwasin labai tan. ");
INSERT INTO lid_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ano Laban anya eh, “Jo badeh Laban, jo le badeh kuhi ou ado Ur udu Babilon ame len, ya jo badeh edeu munyak dah i tam.” ");
INSERT INTO lid_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Eme Abram ndremenya, “Laban Kindrei, i buku sah jo ki tanan i dah munyak tek amwenen.” ");
INSERT INTO lid_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Eme Kindrei anya eh, “Ou andrei ari bulumakau, ari rem ma hawe ari me jaha taloh ma hawe ari ban hawe ari ku.” ");
INSERT INTO lid_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Eme Abram andrei oro katin haka ma taloh, ma taloh sirih dah i mada Kindrei. Eme sapwai katin haka dah i lusi, eme tulusi atehei in bilisiu ya tulusi atehei in bilisiu, arile sirih le badeh iy bapwai bala lusi bwe. ");
INSERT INTO lid_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Eme iri manyuwe atah ame andri badeh anya kaimon, arile Abram tikahei iri au. ");
INSERT INTO lid_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Eme an anya ki-iu ki andri badeh, Abram amadin tuk, ya lulik ma nohowan eme la-un. ");
INSERT INTO lid_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Eme Laban tiye i tan, “Lundriyem oro kameh a buku lau badu leheleh ado munyak len labai; oro kameh a bonyo-ou udu gwek ma i dah kameh maha ndra-in handru i la-u oro winiya jaha hanek (400). ");
INSERT INTO lid_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ya jo badeh kameh edeu maha ma isi i ta kon heh iri are bonyo-ou tiri. Ano buku none iri ame len ta kon doh kameh, iri kameh kuhi lakou mari eme hawe iri. ");
INSERT INTO lid_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ou kameh ado alon winiyan isi basahan tam bwe winiya ou le barala lek hawe tamam oro. ");
INSERT INTO lid_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","I dah kameh lau rebesem au, ano rebesem au, ano rebesem au, ano rebesem au. Ano lundriyem oro barame dah ja ai. Tasah jo kameh winiyan batikahei iri Amora ba-au bwe, winiya kandriyen ndra-in tiri i tinan labai, ano jo baramwekes maha ma isi barala tiri ai.” ");
INSERT INTO lid_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ano len an amai ano kon ilik badeh kasu-er ma jih anya ma seselek, ma hawe sun anya asahan, ma edek ndrokowa katin haka dah. ");
INSERT INTO lid_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ano ma kabatana doh badeh, Laban amwekes sahou randra le hawe Abram, ano Kindrei tiye, “Jo badeh tandrakan ta edeu munyak i ta lundriyem oro badeh, kobek tan badeh udu Ijip ili taku gwa Yupretis, ");
INSERT INTO lid_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","hawe munyak tiri Keni, ma munyak tiri Kenis ma munyak tiri Kadmon, ");
INSERT INTO lid_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ma munyak Hita ma munyak tiri Perisa ma munyak tiri Repa-im, ");
INSERT INTO lid_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ma munyak Amora, ma munyak tiri Kenan, ma munyak tiri Gigasa ma hawe munyak tiri Jebus badeh ta lundriyem oro.” ");
INSERT INTO lid_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram Sarai badeh badeu tan ari nah bwe. Arile iy badeh badih ari udu aliy i nyara badih ta lahou tan ya iy badu Ijip. ");
INSERT INTO lid_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Eme iy tiye i ta Abram, “Laban badeh tawi jo, eme badeh jo bato-ou nah bwe. I buku sah, baden eh ou ala amadin hawe badih ta lahou tek? Koro-an iy katuwiy nah keme tek.” Eme Abram badeh aseken budon ta Sarai. ");
INSERT INTO lid_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Eme Sarai atehei Haga badeh i hawe udun ta nyeu. (i doh asahan badeh, len Abram eme udu Kenan jaha ronoh). ");
INSERT INTO lid_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Eme badeh Abram amadin hawe Haga ma Haga ndrinen i tinan. Eme len Haga tanan iy badeh ndratuwi nah, iy anyolom Sarai badeh anya jo le ai. ");
INSERT INTO lid_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ano Sarai tiye i ta Abram, “Ou le mwesekei badeh ma Haga banyolom jo bala mwasin bwe. Jo le badeh suni iy amadin hawem eme kabatana doh badeh iy atona iy badeh ndratuwi nah, eme ma iy madan andra-i eme tek. Eme Laban le baranyolom talu, ou mwasin de jo mwasin!” ");
INSERT INTO lid_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Eme Abram anya eh, “Mwasin labai iy badeh ta lahou tam iy udu baha tondrok tam; Saba lakou ou anya amwekes ki tan ou amwekes ai.” Eme badeh iy amwekes tibine i ta Haga andra-i labai, eme Haga atobwak. ");
INSERT INTO lid_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Eme Angelo ta Laban eme ndruni iy udu gwa li udu lomale an, gwa doh badeh udu ka-u san ili Sur. ");
INSERT INTO lid_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Eme iy anya eh, “Haga, ou badeh badih ta lahou ta Sarai, ou ado heh ame, ma ou anya ahe.” Eme iy anya eh, “Jo badeh atobwak eme len, ta badih ta kati asiu.” ");
INSERT INTO lid_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Eme iy tiye i tan, “Ou a hamon ja ma ou asahan bonyo-ou tan.” ");
INSERT INTO lid_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ano iy tiye, “Jo kameh edeu lundriyem oro a sola, winiya ari lau bandromwei bwe.” ");
INSERT INTO lid_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Angelo ta Laban tiye i tan ale, “Ou kede-eh nah mwan ere ndrinem eme ou tondrohani nyaran badeh ki Isma-el, tasah Laban badeh ndranuhun ndrelen ma tikisiy tam. ");
INSERT INTO lid_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Arile nadum kameh ta ramwes, iy kameh ta amwekes ramwes i la-u lau mari. Ma iri lau mari kameh budon tiri andra-i i tan, ma iy kameh udu ndrahun len labai ta lowan oro.” ");
INSERT INTO lid_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ano Haga aloh nyara Laban ma tiye sahou tan i buku doh, “Ou Kindrei ou ndranyolom jo, jo ndratou, ou are ala anyolom jo.” ");
INSERT INTO lid_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Eme ma iri aloh li doh badeh li ta Ber Lahai Roi, moson “Gwa li ta Kindrei, ou anyolom jo,” udu ndrokowa Kades hawe Beret. ");
INSERT INTO lid_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Eme Haga atehei nadu Abram mwan; eme badeh Abram tondrohani nyaran Isma-el. ");
INSERT INTO lid_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Na len doh badeh Abram jaha tan ndru lunoh onoh (86). ");
INSERT INTO lid_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Na len Abram jaha tan asahan ndro ronoh ndro ari (99), Laban badeh asahan hawen tiye, “Jo dah jo Kindrei jo tek boto-on. Ou anuhun jo ma len mari badeh ou amwekes kandriyen mwasin le. ");
INSERT INTO lid_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Jo kameh amwekes sahou randra le hawem ma edeu lundriyem oro a sola.” ");
INSERT INTO lid_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Eme Abram aluh i andri ma bulin i andri bada munyak, ano Kindrei anya eh, ");
INSERT INTO lid_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Jo amwekes sahou randra le dah hawem. Jo badeh tandrakan, ou badeh kameh asahan tubu iri lau mari badu kon munyak. ");
INSERT INTO lid_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nyaram kameh bala Abram bwe ai, nyaram kameh Abraham, tasah ou kameh asahan tubu iri lau badu kon munyak solo-an. ");
INSERT INTO lid_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Jo kameh edeu lundriyem oro a sola, eme oro rayah kameh asahan kabin. ");
INSERT INTO lid_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Jo kameh balek winiyan bamani tandrakan tek i tam ma hawe i ta lundriyem oro na len, eme, eme, bwe. Sahou randra le dah, winiyan ta bano bwe. Jo kameh asahan Kindrei tam ma Kindrei ta lundriyem oro. ");
INSERT INTO lid_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ou badeh badu leheleh ta kon Kenan mari, jo kameh edeu i tam ma i ta lundriyem oro udu le buku doh ma jo kameh i Kindrei toro.” ");
INSERT INTO lid_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ano Kindrei tiye ta Abraham, “Ou ma lundriyem oro badeh ndrine ado kise, ta sahou randra le hawek ma lau rebesem hamon ame. ");
INSERT INTO lid_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","I dah sahou randra le tek ou samaniy, udu ndrokowak hawe ndrokowam hawe lundriyem oro: lau mwan mari badeh kasan ku-i lakou tiri ki-iu. ");
INSERT INTO lid_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Na dah ma na len hamon eme ou badeh asan ku-i lakou ta nah ki-iu i buku len tan kasahan ndru la-uh. Iri ta lahou tam badu leheleh ma badu asiu tam ale. I doh badeh ta leheya sahou randra le udu ndrokowa talu ma la-uh. ");
INSERT INTO lid_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ado ari ari badeh kasan ki-iu eme ya mada lau kanyolom i dah badeh kalem ta leheya sahou randra le tek ma ou badeh udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Are lau mwan basan ku-i lakou tan bwe, iy badeh lau tek bwe, tasah iy babudon sahou randra le tek hawen bwe.” ");
INSERT INTO lid_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ano Kindrei tiye ta Abraham, “Ou badeh saloh udum Sarai ja ai; na dah ma na len eme badeh ou aloh Sara. ");
INSERT INTO lid_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Jo kameh edeu nyosowan i tan ma iy kameh atehei ari nah i tam. Jo kameh atehei nyosowan i tan ma iy kameh asahan tine iri lau mari badu kon rakon buruwen, ma kabin kameh asahan ta lundriyen oro.” ");
INSERT INTO lid_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Eme Abraham aluh ya bulin i andri bada munyak eme iy lomondra ili ma iy akodei iy ta ehe-en anya eh, “Winiyan ari ndramak jaha tan rinek (100) winiyan mwesekei nah? Ya Sara badeh jaha tan ndro ronoh (90), ya iy winiyan tuwi ale?” ");
INSERT INTO lid_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Eme Abraham tiye ta Kindrei, “I buku sah ou winiyan batehei Isma-el bame nah badu ndrinek bwe?” ");
INSERT INTO lid_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Arile Kindrei anya eh, “Bwe ai. Udum Sara kameh atehei nah ari i nadum ya ou tondrohani nyaran badeh ki Aisik. Jo bamani sahou randra le hawen ma lundriyen oro bwe. I doh ta udu le buku doh. Ya winiyan ta bano bwe. ");
INSERT INTO lid_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ya ndrelen tam ta Isma-el baden eh, jo ndranuhun; jo kameh nyosowani iy handru; ma jo kameh mwesekei iy asahan sola ma kanen kameh i sola. Iy kameh asahan tama oro lau ta batun ma ronoh la-uh ma jo kameh edeu iy asahan kon rakon buruwen. ");
INSERT INTO lid_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Arile jo kameh bamani sahou randra le hawe nadum Aisik bwe. I dah kameh adeu iy na jaha eme.” ");
INSERT INTO lid_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Eme Kindrei asehek sahou i ta Abraham ano badeh iy iu ai. ");
INSERT INTO lid_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Eme Na len doh le badeh, Abraham anuhun sahou ta Kindrei ma iy sani ku-i lakou ta Isma-el iu hawe tiri lau mwan are asiu tan ale. Iri doh badeh iri lau ta lahou tan badu bolo asiu. Iri lau ala adeu iri ado hawen ma hawe iri lau rayah ta sisih ale. ");
INSERT INTO lid_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham jaha tan asahan ndro ronoh ndro ari (99) badeh, sani ku-i lakou tan iu, ");
INSERT INTO lid_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","ya Isma-el badeh jaha tan ronoh taloh. ");
INSERT INTO lid_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Uru ma la-uh badeh asan ku-i lakou turu iu na len ari le, ");
INSERT INTO lid_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ma hawe iri lau ta lahou mari ta Abraham. ");
INSERT INTO lid_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ano na len, kon i nyarahan badeh Abraham eme manyah udu mada san ta asiu balei tan, eme ya Kindrei asahan hawen. Madan eme loke badeh iy anyolom lau taloh badeh ales. ");
INSERT INTO lid_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Iy anyolom oro le badeh iy sakaliye ili aturuk oro ano iy aluh i andri, bulin i ta bada munyak. ");
INSERT INTO lid_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ano iy anya eh, “Laban, ado sa-au ta kon tek, ado kado; jo dah ta atondrok ou. ");
INSERT INTO lid_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Gwa doh ado kasikine kati ado, ano ado kamunyau kado baha kei badeh. ");
INSERT INTO lid_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Jo kameh akohok rayah nyamon ta aseben ado, tasah san lawe-en labai. Ado badeh anuhun jo ma ado ame asiu tek, eme ya jo katondrok ado ma kaseben ado.” Eme oro anya eh, “Wurah handru, aso aseken kandriyen tam labai.” ");
INSERT INTO lid_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ano Abraham i bolo balei badeh asehek i ta Sara, “Suwi Ou andrei rayah palawa ma ou asun sabe jabi ramen.” ");
INSERT INTO lid_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ano iy sakaliye ili bolo iri katin haka badeh andrei bulumakau kasen mwasin handru, iy andrei atehei i mine ndramak ta lahou tan ari ili sesek ma ajeh. ");
INSERT INTO lid_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ano iy andrei sur simidin ta katin haka ma hawe bulumakau kasen nane ndrajuhi dah, bwese-ei i hawe oro. Eme oro aimon ai. Ya Abraham badeh ales udu baha kei. ");
INSERT INTO lid_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Eme oro ndremenya iy, “Udum Sara ndraheh?” Eme iy anya eh, “Iy udu bolo asiu balei.” ");
INSERT INTO lid_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ano Laban anya eh, “Jo kameh eme ja, na bolo jaha eme, ma udum Sara kameh nah udu ndrinen.” Ya Sara badeh udu mada san ta asiu balei udu konan. ");
INSERT INTO lid_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Sara hawe Abraham badeh uru ndra alon handru ma jaha turu badeh ndra sola labai, ma Sara badeh winiyan bato-ou nah ja bwe ai. ");
INSERT INTO lid_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Eme Sara badeh akodei iy ma iy ehe-en ma iy lomondra, “Jo badeh ndra ndrolo-oh, ma iy lau tek ndra alon, jo kameh barasekesek ta lakou dah de bwe.” ");
INSERT INTO lid_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ano Laban tiye i ta Abraham, “I buku sah Sara ehe-en ma anya eh, ‘Handru eh, jo kada-ah ndra alon, jo kameh ato-ou nah?’ ");
INSERT INTO lid_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Lakou mari kede-eh manamun ta Laban le ai. Jo kameh eme hamon na len ta aliy amwenen udu bolo jaha eme, ma Sara kameh tuwi nah mwan.” ");
INSERT INTO lid_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Eme Sara inoh ma mwesekei wasai anya eh, “Jo behe-en bwe.” Arile iy anya eh, “Ou ehe-en handru.” ");
INSERT INTO lid_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ano badeh oro lau dah au, adek ala, ano oro anyolom eme andri ta Sodom ma Abraham atiye oro ma anyolom oro au. ");
INSERT INTO lid_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Eme Laban anya eh, “Jo winiyan batonei sasah jo anya kamwekes ta mada Abraham bwe ai. ");
INSERT INTO lid_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Lundriyen oro kameh asahan kon tinan ari buruwen, ma na iy le badeh kameh, jo kameh atehei nyosowan i tiri kon munyak tinan mari. ");
INSERT INTO lid_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Jo badeh ndrasehek tan ta atehei iy badeh kabatanau nadun oro hawe lau badu asiu tan kanuhun le jo, ma kamwekes kandriyen mwasin le handru. I buku none oro an hamon ta batanau mari, jo tandrakan ta amwekes lakou mari i tan.” ");
INSERT INTO lid_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ano Laban tiye, “Ndrelen ta bada Sodom hawe Gomora tinan labai, ma karei ma lomondra ndra-in ndrandra-i labai. ");
INSERT INTO lid_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Eme ya jo ki-iu ki andri kanyolom i buku none lakou oro amwekes doh handru de bwe, i buku none ndrelen toro ndrame.” ");
INSERT INTO lid_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Eme uru lau dah au ala Sodom, arile Abraham le ales udu le mada Laban udu. ");
INSERT INTO lid_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ano Abraham eme mirihik ma iy lelen, “Ou kameh adai iri lau mwasin ma lau ndra-in ale? ");
INSERT INTO lid_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","I buku none lau mwasin ma lomonoh (50) i dah kameh ou sulumwi kon de bwe, ma ou sulumwi kon mari ano. Ya ou winiyan basebenei bwe ai, ta lau ma lomonoh (50) bado bwe ai. ");
INSERT INTO lid_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ou winiyan bamwesekei bwe. I buku none ou mwesekei kameh iri lau mwasin kameh ado bolo lau ndra-in ale. Ya iy kameh winiyan bwe. Iri lau ta anuhun sahou badu munyak badeh anuhun sahou badeh mwasin ja.” ");
INSERT INTO lid_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ano Laban tiye, “I buku none oro lau lomonoh (50) mwasin ado Sodom eh, badeh kameh jo winiyan basulumwi kon mari bwe.” ");
INSERT INTO lid_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eme Abraham tiye ja, “Jo badeh ndrasehek sahou boto-on labai ndra ta Laban. Jo badeh lakou leleyah, jo munyak ma koloweh leleyah. ");
INSERT INTO lid_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ya ki buku none lau limeh le ka-au udu baha lomonoh (50), ou winiyan sulumwi kon de bwe?” Eme Laban tiye, “I buku none jo anyolom lau hanoh limeh (45) ado aliy, badeh kameh jo winiyan basulumwi bwe ai.” ");
INSERT INTO lid_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Eme iy ndremenya ja i tan, “I buku sah i buku none lau hanoh (40) kado aliy?” Eme iy tiye, “Buku none oro lau hanoh le, jo winiyan bamwesekei bwe.” ");
INSERT INTO lid_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ano Abraham tiye, “Laban ei, ou sabolosen, jo kasehek, ya i buku none tonoh (30) ado aliy?” Eme iy tiye, “Buku none oro lau tonoh le, jo winiyan bamwesekei bwe.” ");
INSERT INTO lid_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eme Abraham tiye, “Len ndra-au badeh jo ndrasehek sahou boto-on ndra ta Laban, ki buku none lunoh (20) ado aliy, mwasin?” Eme iy tiye, “Oro lunoh le badeh jo winiyan basulumwi kon bwe.” ");
INSERT INTO lid_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ano iy tiye, “Laban ou sabolosen; jo anya kasehek sahou san rasan le ja. Ya ki buku none lau ronoh le mwasin de bwe?” Eme iy anya eh, “Buku none lau ronoh le badeh jo winiyan basulumwi bwe.” ");
INSERT INTO lid_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Eme Laban asehek sahou hawe Abraham ano badeh iy iu ai, eme ma Abraham i asiu ai. ");
INSERT INTO lid_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Lot badeh manyah udu mada san ta i bolo kon na beyeh, eme badeh uru Angelo la-uh asahan hawen. Iy anyolom uru le badeh iy edek ili hawe uru ma akor ma bulin i andri bada munyak. ");
INSERT INTO lid_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Eme iy tiye, “Laban, ah ma la-uh kame asiu tek tasah jo ta lahou ta ah. Ah kasikine kati ah ma ah kamadin ben ari, ano ma ndraben ah bara-au.” Eme uru anya, “Bwe ai, aru kameh amadin na ben dah ado lohalak bolo kon.” ");
INSERT INTO lid_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Arile iy andresei uru ma uru ala asiu tan. Ano Lot tiye oro lau ta lahou tan mwesekei jabi ramen yis bala bolon bwe i nuru lau dah. ");
INSERT INTO lid_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Eme oro bamadin bwe le badeh, iri lau loweu hawe iri lau-en mari badu kon Sodom badeh ala awudi asiu. ");
INSERT INTO lid_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Eme iri aloh Lot, “Oro lau ame na ben nane ndraheh? Oro kameh manan aso anya katou oro!” ");
INSERT INTO lid_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Eme Lot sulu-i kou ano iy eme manan, ma atuwi kou ili. ");
INSERT INTO lid_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Ado kawas tek, ado samwekes kandriyen badeh. ");
INSERT INTO lid_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Naduk badih ma la-uh kada-ah, uru bakohok se mwan bwe. Jo katiye uru kame manan ya ado badeh kamwekes sasah na seken tado ki turu. Ya ado samwekes ari lakou sala toro, oro badeh are baha tondrok tek.” ");
INSERT INTO lid_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Eme oro anya, “Ou abelek!” Ma oro tiye, “Ou lau dah badeh badu leheleh ame dah, eme ya ou anya amwekes kandriyen ta sahou ai. Oro kameh, bwe ai, arile aso kameh adeu maha tinan labai i tam.” Oro andres Lot boto-on labai ano oro anya katokos asiu. ");
INSERT INTO lid_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Arile oro lau ado bolon sulu-i kou ma aluwi Lot i bolon ano sulu-i kou ili. ");
INSERT INTO lid_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ano badeh oro bwidi mada iri agwah, eme ma iri banyolom kou bwe. ");
INSERT INTO lid_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ano uru lau ma la-uh dah lelen Lot, “Ou ari lowam, o ari molosou ta nadum, o ari nadu mwan ma badih udu kon dah de bwe. O ari lau udu bolo kon dah tam de bwe. Ou kuhi oro ka-au ta kon dah. ");
INSERT INTO lid_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Tasah aso kameh asun kon dah. Laban badeh anuhun ndrelen tiri, eme iy suni aso ame ta asun.” ");
INSERT INTO lid_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Eme Lot ili badeh asehek ta masa-an oro, ala sudi nadun oro badih. Iy tiye, “Suwi ado kame len ta kon dah, Laban kameh asun kon dah.” Arile udu nadun oro anya badeh iy ibo nyorei le. ");
INSERT INTO lid_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Na boholen badeh oro Angelo wekewek Lot, “Suwi! Ou kuhi udum ma nadum badih ma la-uh ya ado ka-au. Eme ya ado samak, len kon kameh andrakak!” ");
INSERT INTO lid_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Eme Lot badeh babotatahan bwe. Laban tikisiy iy eme iy kuhi udun ma nadun uru na lim ma sariye oro ame len ta kon. ");
INSERT INTO lid_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Eme oro ame len le badeh iy ari tiye anya eh, “Ado kabotataha batu ado! Ado sanyolom same hamon, ma ado samunyau loboho kon bwidiu udu aliy. Ado katobwak ka mandrei, bakameh ado kamak.” ");
INSERT INTO lid_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Arile Lot tiye i turu, “Ndri-i, Laban tek! ");
INSERT INTO lid_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ou badeh anuhun jo labai, ma mwesekei jo, ma ou sebenei kohak. Mandrei udu len labai, jo winiyan batobwak bala aliy bwe. Koro-an maha ma sisi-in tinan labai kabwidi jo kimek. ");
INSERT INTO lid_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ou ndranyolom kon bwisik udu mirihik ai kodo-oh. Ma kon doh nadu bwisik, eme jo katobwak ki aliy. Ma jo kameh winiyan bamak bwe.” ");
INSERT INTO lid_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Eme iy anya eh, “Abo mwasin jo aseken. Jo badeh winiyan basulumwi kon badeh bwe. ");
INSERT INTO lid_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Suwi ado kala suwi! Jo badeh winiyan bamwekes ari lakou bwe winiyan ado ndrasos.” Eme ta katin doh badeh kon doh aloh So-ar, tasah kon doh bwisik. ");
INSERT INTO lid_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot oro ala asos le So-ar badeh, an eme loken la-u kon. ");
INSERT INTO lid_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ano badeh Laban mwesekei jih nyarahan labai anya udu kandrah eme sulumwi Sodom hawe Gomora. ");
INSERT INTO lid_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Eme badeh sulumwi iri lau mari, sulumwi nyamak ma hawe sulumwi baso mari ano. Lakou mari badeh andrakak. ");
INSERT INTO lid_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Eme udu Lot anyolom i hamon badeh ma iy ibin i bek. ");
INSERT INTO lid_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Eme ma ndraben ta len ari ja, Abraham amak ma iy ili ndrahu kon iy mene ales udu aliy mada Laban, ");
INSERT INTO lid_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","eme iy anyolom i andri ili Sodom hawe Gomora ma hawe munyak ma nyamak mari loboho doh badeh iy anyolom kasu-er i loken. I buku none kasu-er ta jih nyarahan badeh i loken. ");
INSERT INTO lid_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Len Kindrei sulumwi kon tinan ma nyamak mene Lot manyah udu aliy, eme iy badeh bamaniy Abraham bwe ya eme iy mwesekei Lot atobwak ma iy udu mwasin. Loboho Iri Mowaba Ma Amora ");
INSERT INTO lid_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ano Lot hawe nadun uru badih ma la-uh badeh ruwani So-ar, eme oro ala manyah ado bolo mandrei, tasah iy badeh inoh ta manyah udu So-ar. Oro ma taloh badeh manyah ado munu bek. ");
INSERT INTO lid_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Eme len ari badeh nadu Lot badih bwele-en tiye i ta nadu tinen badih bahan, “Tama talu badeh ndra alon, eme ari lau ja kede-eh ja bwe ai, ta amadin talu bwe, i buku none kandriyen ta munyak mari. ");
INSERT INTO lid_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Talu kamwesekei tama talu badeh ka-un wa-in eme iy kamadin talu ya talu kato-ou nah.” ");
INSERT INTO lid_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Eme na ben doh badeh uru atehei wa-in i ta tama uru, ano badeh iy bwele-en turu badeh amadin hawen bwena. Iy amadin hawen badeh ano iy suri iy badeh, Lot batona bwe. ");
INSERT INTO lid_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Len ari ja badeh iy bwele-en tiye i ta iy bahan, “Na ben badeh jo amadin tama, talu kamwesekei iy ka-un wa-in na ben dah, eme ou ala amadin hawen ja eme ma talu kato-ou nah kasahan ta tama talu.” ");
INSERT INTO lid_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Eme uru mwesekei tama uru a-un wa-in na ben doh ano iy bahan ili amadin hawen. Eme i le buku aliy, iy amadin hawen badeh, ano iy suri iy eme loken badeh Lot batona se bwe. ");
INSERT INTO lid_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Eme uru ma la-uh tuwi nah nadu tama uru. ");
INSERT INTO lid_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Iy bwele-en badeh atehei nadun eme len badeh tondrohani nyaran badeh Mowab, moson “Ta tama.” Eme iy badeh tama iri Mowaba na len dah. ");
INSERT INTO lid_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Iy bahan badeh atehei nah mwan ale, eme tondrohani nyaran badeh Ben-ami, moson “Nadu tama oro.” Eme na len dah badeh iy badeh tama iri Amora. ");
INSERT INTO lid_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ano badeh Abraham ruwani ndrahunen bwena, eme iy edek ili loboho Negeb ma manyah udu ndrokowa Kades hawe Sur. Iy udu Gerar badeh luwen bwe, ");
INSERT INTO lid_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","eme badeh Abraham tiye anya Sara badeh nadu tinen. Ano kabin badu Gerar nyaran Abimelek atehei sahou ili andrei Sara ili. ");
INSERT INTO lid_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Arile Kindrei asahan ta Abimelek na ameh na ben ma tiye i tan, “Ou kameh amak tasah ou andrei badih tasou badeh.” ");
INSERT INTO lid_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Eme badeh Abimelek bala mirihik tan bwe, eme iy tiye, “Laban, jo badeh mwasin labai, ou kameh adai jo ma iri lau tek ai? ");
INSERT INTO lid_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham tiye badeh anya iy nadu tinen, eme Sara ale tiye i buku aliy. Jo mwesekei doh badeh budon tek bandra-i bwe ma jo bamwesekei ari lakou ndra-in bwe.” ");
INSERT INTO lid_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Eme Kindrei tiye i tan na ameh, “Jo tanan, ou badeh budon tam bandra-i bwe, eme jo badeh bamwesekei ou bamwekes lomondra ndra-in bame badak bwe, ma bamwesekei ou batawi iy bwe. ");
INSERT INTO lid_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ya eme na le dan, badeh ou atehei udun ki hamon. Tasah iy badeh ndramak ta boho Kindrei iy kameh amwekes salom i tam, i buku bwe, jo tiye tanan tam ou kameh amak ma hawe iri lau tam mari.” ");
INSERT INTO lid_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Eme na ma ndraben badeh iy luhi iri lau ta lahou badu bolo asiu tan ame, eme badeh iy asehek nyala iri. Eme badeh iri anoh. ");
INSERT INTO lid_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ano badeh Abimelek luhi Abraham eme bolon ma tiye, “Ou amwekes sasah eme taso dah? Jo mwesekei madam andra-i ta sasah handru, eme ya ou adeu maha tinan eme la-u aso ma tondrok tek dah? Lakou ou amwekes dah badeh ou winiyan bamwekes bame tek bwe ai.” ");
INSERT INTO lid_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ano badeh Abimelek ndremenya Abraham, “Saba katin handru ou badeh amwekes kandriyen dah?” ");
INSERT INTO lid_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Eme Abraham anya eh, “Jo abudon le i buku doh, iri lau badu kon dah banoh Kindrei bwe, eme i dah kameh iri kadai jo, tasah na uduk. ");
INSERT INTO lid_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Arile iy badeh nadu tine handru. Iy badeh nadu tama arile, nadun ta tine ta tewedeu jo bwe, eme badeh jo sudi iy. ");
INSERT INTO lid_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Eme Kindrei tiye jo eme len ta munyak, eme kon leheleh, eme badeh jo tiye i tan ta iy badeh kaleheya mwasin tan hawe seken tan udu tek handru ki tiri kon mari, ta jo badeh nadu tinen.” ");
INSERT INTO lid_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ano badeh Abimelek eme badeh kuhi katin haka sipsip ma bulumakau ma hawe iri bonyo-ou mwan ma badih atehei i ta Abraham, ma iy atehei udun Sara i hamon. ");
INSERT INTO lid_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Eme badeh Abimelek tiye i tan, “Munyak tek udu madam kede-eh, ou manyah ado aliy na seken tam.” ");
INSERT INTO lid_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ya i ta Sara badeh iy tiye i buku doh, “Jo kameh edeu ta nadu tinem kameh wa-iralou hayen nyikilikin amwekes na silba. Ta leheya udu mada iri lau tam mari, ta ou badeh bamwekes ari kandriyen ndra-in bwe, eme iri lau mari katanan ou badeh bamwekes ari lakou bandra-i bwe.” ");
INSERT INTO lid_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ano badeh Abraham amwekes salom i ta Kindrei, ma Kindrei mwesekei Abimelek ma hawe udun hawe oro bonyo-ou badih tan badeh ato-ou nah ja. ");
INSERT INTO lid_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Tasah ta udu Abraham Sara le mene, Kindrei mene sokei lakou ta amwekes nah tiri lau mari badu baha tondrok ta Abimelek. ");
INSERT INTO lid_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","I buku none Kindrei mene ndrasehek ma ndratandrakan ndra-au ta iy badeh tikisiy Sara labai, ");
INSERT INTO lid_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Eme udu bada Abraham i alon badeh, Sara ndrinen i tinan ma iy tuwi nah mwan i nadun. Amwenen le ta len mene Kindrei tandrakan iy. ");
INSERT INTO lid_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Eme badeh Sara atehei nah dah eme len badeh, Abraham tondrohani nyaran Aisik. ");
INSERT INTO lid_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ano len ta nadun Aisik asahan ndru la-uh badeh Abraham sani ku-i lakou tan iu, i buku Kindrei ndratiye tan. ");
INSERT INTO lid_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham jaha tan asahan rinek (100) badeh nadun Aisik eme len. ");
INSERT INTO lid_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Eme badeh Sara tiye, “Kindrei badeh atehei sekesek eme ndrinek ma buku none iri lau mari anuhun kameh iri kameh sekesek hawek.” ");
INSERT INTO lid_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ano iy tiye le, “Are tiye i ta Abraham anya, Sara kameh winiyan nyowo-ei nah bwe? Arile udu bada alon tan badeh jo ndratehei nah mwan ai.” ");
INSERT INTO lid_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Iy nah badeh i tinan ano na len Aisik aruwe sur badeh, Abraham mwesekei tine nyamon. ");
INSERT INTO lid_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Arile Sara anyolom nadu i badih Haga badu Ijip, atehei i nadu Abraham badeh bobose, eme iy tiye ta Abraham, “Ou tikahei badih ta lahou tam ma hawe nadun ki-iu, tasah nadun kameh winiyan bakohok ari lakou hawe nadum Aisik bwe.” ");
INSERT INTO lid_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Eme Abraham abudon la bwe, tasah iy badeh nadun le. ");
INSERT INTO lid_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Arile Kindrei tiye, “Ou sabudon tinan labai ta nah nadu badih ta lahou tam kede-eh. Ou badeh anuhun boho Sara asehek tam, tasah na Aisik le kameh lundriyem oro asahan. ");
INSERT INTO lid_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Jo kameh edeu nadu badih ta lahou tam kameh asahan kon rakon buruwen, tasah iy badeh nadum le.” ");
INSERT INTO lid_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Na ma ndraben ta len ari ja badeh Abraham kuhi nyamon rayah ma hawe bwisi gwa (amwekes na ku-i katin haka) idih na gwa atehei i mine Haga. Iy bwese-ei i nah badeh tukuni i konan ma tiye uru au. Eme iy edek leleyah ili bolo lomale an Bersiba. ");
INSERT INTO lid_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Eme gwa udu bolo bwisin ano badeh, iy nyahani i nah udu bolo bwidiu udu ai. ");
INSERT INTO lid_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Eme iy ili manyah udu len. Ano iy abudon, “Jo bwalek anyolom nah mwan kodo-oh imek.” Eme iy anya keden. ");
INSERT INTO lid_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Eme Kindrei anyolom i nah dah eden, eme badeh Angelo ta Kindrei udu kandrah aloh i ta Haga, “Ou ndra buku sah badeh? Ou sanoh, Kindrei badeh ndranuhun i nah eden kede-eh. ");
INSERT INTO lid_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ou bwese-ei iy keme loken ma ou apon iy, tasah jo kameh amwekes lundriyen oro kameh asahan kon tinan rakon handru.” ");
INSERT INTO lid_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ano badeh Kindrei mwesekei madan asak badeh, iy atou gwa li. Eme iy andrei bwisi gwa ili badeh asuniy ma i nah dah a-un. ");
INSERT INTO lid_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Iy badeh i tinan, Kindrei badeh udu hawen le. Iy badeh ndrahu manyah tan udu kon lomale an, eme iy badeh asahan nyekelen handru ta beteleu. ");
INSERT INTO lid_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Iy manyah udu lomale an nyaran Paran, ano tinen badeh andrei badih ari badu Ijip i udun. ");
INSERT INTO lid_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Na len doh badeh Abimelek hawe Pikol ndramak ta mwena ta bahun tan tiye i ta Abraham, “Sasah ou amwekes badeh Kindrei udu hawem. ");
INSERT INTO lid_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Na dah udu mada Kindrei badeh ou tandrakan ta ou badeh sawasai jo ma lundriye naduk oro. Jo badeh tikisiy ou labai, eme jo aseken ou badeh tikisiy jo ale ma kon munyak ou manyah are aliy dah.” ");
INSERT INTO lid_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Eme Abraham tandrakan. ");
INSERT INTO lid_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ano badeh Abraham eme nunu-uh Abimelek ta gwa li oro lau ta lahou ta Abimelek solo-ei. ");
INSERT INTO lid_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Eme Abimelek anya, “Aliy, jo tanan are amwekes badeh bwe. Ou batiye tek bwe, nane le jo badeh baranuhun.” ");
INSERT INTO lid_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Eme badeh Abraham kuhi sipsip hawe bulumakau eme atehei i ta Abimelek. Eme uru amwekes sahou randra le. ");
INSERT INTO lid_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ano Abraham kuhi sipsip kasen ndro taloh tan eme len, ");
INSERT INTO lid_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","eme badeh Abimelek ndremenya Abraham, “Saba moson ta ou atehei sipsip kasen ndro taloh udu len kede-eh?” ");
INSERT INTO lid_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eme iy tiye, “Ou kuhiy sipsip kasen ma ndro taloh doh, tasah gwa li badeh jo a-eh.” ");
INSERT INTO lid_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Eme nyara kon doh badeh Bersiba, moson “Li ta tandrakan,” tasah uru lau ma la-uh badeh tandrakan ado aliy. ");
INSERT INTO lid_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Hamon ta sahou randra le ano udu Bersiba badeh, hawe Pikol ndramak ta bwena ta bahun tan badeh uru au a hamon ala Pilistin. ");
INSERT INTO lid_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ano Abraham tahi kei tamarisk udu Bersiba, eme iy aloh nyara Laban, Kindrei ta udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Eme Abraham badeh manyah ili eme udu munyak ta Pilistin luluwen labai. ");
INSERT INTO lid_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Udu hamon ta aliy badeh Kindrei none Abraham. Eme iy tiye i tan, “Abraham!” Eme Abraham anya eh, “Jo kada-ah.” ");
INSERT INTO lid_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ano Kindrei tiye, “Ou andrei Aisik, nadum ala adem handru in tan kede-eh badeh ou ala loboho Moreya. Jo kameh leheya mandrei kameh i tam ma ou asun iy ki nyara salom.” ");
INSERT INTO lid_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Eme Abraham amak na ma ndraben, abedei ndro-o jih ano andrei i ta asun salom eme iy atehei i bwele-e katin haka donki ma andrei Aisik hawe uru lau ta lahou tan la-uh. Eme oro adek ala kon Kindrei ndratiye tan. ");
INSERT INTO lid_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Len la-uh ano ya i bada len taloh badeh Abraham atou kon nane udu len. ");
INSERT INTO lid_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Eme badeh iy tiye i turu lau ta lahou tan, “Ah kado dah ma donki kado jo hawe Aisik badeh aru kala kodo-oh. Aru kameh ala atudun ano badeh aru barame hamon hawe ah ja.” ");
INSERT INTO lid_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ano Abraham andrei ndro-o jih ta asun atehei i kase nadun Aisik eme iy andrei jih ma samen. Eme uru adek se ala badeh, ");
INSERT INTO lid_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aisik ndremenya taman Abraham, “Tama?” Eme Abraham anya, “Abo naduk sasah?” “Ndro-o jih hawe jih kada-an ai, ya sipsip ta asun ta salom ndrahe bah?” ");
INSERT INTO lid_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Eme Abraham anya eh, “Naduk, Kindrei le baradeu sipsip kasen barame ta asun ta salom.” Eme uru ma la-uh adek ala. ");
INSERT INTO lid_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Eme uru ala asos kon mene Kindrei tiye tan badeh, iy eme tukumwi bek i loken ta asun. Ano badeh iy kuhi ndro-o jih i bwele-en. Ano badeh i sawei nadun Aisik badeh atehei iy i bwele-e ndro-o jih udu bada bek dah. ");
INSERT INTO lid_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Eme iy andrei samen anya kamundroh le iy badeh, ");
INSERT INTO lid_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Angelo ta Laban aloh udu kandrah eme anya, “Abraham! Abraham!” Eme Abraham anya, “Jo kada-ah.” ");
INSERT INTO lid_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“Ou sadai iy ma ou samwekes sasah sala tan, jo badeh tanan, ou badeh anoh Kindrei labai, eme ou basolo-ei nadum bwe.” ");
INSERT INTO lid_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Eme Abraham madan eme loken badeh iy anyolom katin haka rem badeh andra batun badeh malou sakabwitiniy iy. Eme iy ruwani Aisik, iy ili badeh tawi rem dah eme, akohok kon ta Aisik ta salom. ");
INSERT INTO lid_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Eme Abraham tondrohani nyara kon nane doh badeh, “Kindrei Kameh Atehei.” Eme ma taku len dah aloh, “Mandrei doh badeh Laban Kameh Atehei.” ");
INSERT INTO lid_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","17","Ano badeh Angelo ta Laban udu kandrah aloh ja i ta Abraham ma tiye, “Ou badeh banoh ta adeu nadum ou aseken labai bwe, jo tandrakan handru jo kameh amwekes lundriyem oro kameh nyaran bwe, oro kameh a solo-a ndrau badu loken ma solo-a on badu babi. Lundriyem oro kameh akohok lakou mari tiri lau ta ndra-i i tam udu kon tinan tiri. ");
INSERT INTO lid_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ya nyosowan ta lundriye nadum oro kameh ili la-u kon munyak mari, tasah na ou anuhun sahou tek.” ");
INSERT INTO lid_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ano badeh Abraham uru au ala hawe uru lau ta lahou tan nane ma oro au ala Bersiba. Eme Abraham udu Bersiba udu le. ");
INSERT INTO lid_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ano udu len hamon badeh Abraham anuhun nadu tinen Nahor udun Milkah badeh atehei nadun ma ndru la-uh: ");
INSERT INTO lid_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Kadok badeh Us ano Bus ano badeh Kemu-el tama Aram, ");
INSERT INTO lid_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keset, Haso, Pildas, Jidlap ma Betu-el, tama Rebeka. ");
INSERT INTO lid_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Milkah badeh atehei nah ndru la-uh nane doh. ");
INSERT INTO lid_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Udu Nahor badih ta mada san nyaran Reumah badeh atehei Tebah, Gaham, Tahas hawe Ma-akah. ");
INSERT INTO lid_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara badeh udu winiya jaha rinek lunoh ndro taloh (127). ");
INSERT INTO lid_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Iy imek badeh udu Kiriyat Arba (aloh Hibron) udu munyak Kenan, eme Abraham ili moroha iy ma eden i la-un. ");
INSERT INTO lid_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ano Abraham suri iy udu ka-u udun eme loken badeh, iy tiye i tiri Hita. Iy tiye i buku doh, ");
INSERT INTO lid_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Jo badeh badu leheleh eme udu ndrokowa ado. Jo anya kisih sese munyak loboho dah eme ya jo ka-eh uduk ki aliy.” ");
INSERT INTO lid_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Eme iri Hita tiye i ta Abraham, ");
INSERT INTO lid_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Laban, ou anuhun aso. Udu bolo ahi dah, ou badeh ou lau ta Kindrei. Ou ahi udum badeh ki munu bek na seken tam le. Ari ndramak badeh winiyan bala bwalen ta lek (munu bek) tan ta a-eh bada kei tam kede-eh bwe.” ");
INSERT INTO lid_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ano badeh iy ales ma iy aluh i andri mada iri lau mari badu Hita ta munyak tiri. ");
INSERT INTO lid_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Eme Abraham tiye i tiri, “I buku none ado aseken ta jo kihiy bada kei tek dah, badeh ado kanuhun jo, ado kala hawe Epron nadu Sohar, badeh ado ka nyara bohok, ");
INSERT INTO lid_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","eme kasihinei munu bek ta Makpelah, i doh tan amwenen udu ka-u munyak tan badeh. Ado kandremenyani iy ta sihinen handru badeh sabe, eme ma kudu mada ado, jo kasihinei ki ndrahu a-eh tek.” ");
INSERT INTO lid_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eme Epron badeh manyah udu hawe iri Hita ndrahu kon ta atukum, mada san ta i bolon; eme iri lau mari badeh anuhun iy asehek; ");
INSERT INTO lid_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Laban ou anuhun, lo ndranye oro lau tek mari kede-eh, jo kameh atehei munyak mari ma munu bek udu aliy kede-eh i tam. Ta ou badeh ahi udum ki aliy.” ");
INSERT INTO lid_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Eme ja badeh Abraham aluh i andri udu mada iri lau mari ta munyak dah. ");
INSERT INTO lid_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Lo ndranye iri lau mari badeh iy tiye ta Epron, “Aha kanuhun jo, i buku none aha aseken badeh jo kasihinei munyak mari. I buku ado aseken sisih badeh, jo kihiy uduk ki aliy.” ");
INSERT INTO lid_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Eme Epron tiye ta Abraham, ");
INSERT INTO lid_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Laban, ou anuhun jo, munyak badeh sihinen badeh hanek (400) boroh amwekes na silba; arile lakou doh badeh talu barasehek ta aliy ndrokowa talu. Ou ahi udum.” ");
INSERT INTO lid_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Eme Abraham aseken budon ta Epron eme ma iy andromoi sihine lakou mari iy nane aloh udu ndranye lau mari badu Hita nane dah: badeh hanek (400) boroh amwekes na silba i buku none maha ta aliy udu ndrokowa lau ta atondrok. ");
INSERT INTO lid_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Eme udu ndranye iri Hita mari nane ame ado mada san ta i bolo kon dah, munyak ta Epron ma munu bek hawe iri kei udu kobek udu Makpelah mirihik ta Mamre badeh atehei i ta Abraham. ");
INSERT INTO lid_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ano badeh Abraham atehei udun Sara i munu bek udu munyak Makpelah mirihik ta Mamre (aloh Hibron) udu munyak Kenan. ");
INSERT INTO lid_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Eme munyak doh badeh ma munu bek udu aliy badeh ta Abraham handru badu mine iri Hita i tan ta mada lek. ");
INSERT INTO lid_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham badeh ndra alon labai, ma jaha tan ndra sola, eme Laban badeh atehei nyosowan i la-un ta mada san mari. ");
INSERT INTO lid_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Eme iy tiye i ta lau ta lahou tan ta atondrok badu asiu tan, ma iy ta atondrok lakou mari tan, “Ou tawi baha bak ta kalem, ");
INSERT INTO lid_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Jo badeh aseken ou tandrakan na nyara Laban, iy Kindrei badu kandrah ma munyak, ta ou sakohok badih sala ta naduk badu kenan, kon jo manyah udu hawe iri dah, ");
INSERT INTO lid_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","arile ou kameh ala kon tek ala hawe lowak oro amwenen akohok ari badih ki ta naduk Aisik.” ");
INSERT INTO lid_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Eme iy lau ta lahou tan tiye, “Ya ki buku none iy badih ki bwalen ta eme kameh ki buku sah bah?” ");
INSERT INTO lid_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham anya eh, “Ou badeh sandrei naduk sawek badeh. ");
INSERT INTO lid_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Laban Kindrei badu kandrah le badeh kuhi jo eme len ta boho kamen ta tama udu munyak tek, iy tiye ma tandrakan jo ta edeu munyak dah i ta lundriyek oro. Iy kameh suni angelo ili bwena tam, ta aseben ou kandrei ari badih badu badeh keme ta naduk. ");
INSERT INTO lid_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","I buku none i badih bwalen ta eme hawem eme, badeh batanau tek balem kamani ai. Arile ou sandrei naduk sawek badeh.” ");
INSERT INTO lid_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ano badeh i lau ta lahou tan dah tawi baha ba Abraham dah ma tandrakan bohon i tan ta nyala lakou nane dah. ");
INSERT INTO lid_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ano badeh i lau ta lahou tan dah andrei katin haka ronoh kamel ma hawe lakou rayah mwasin ta Abraham badeh, ma iy iu ili Aram Nahara-em ma edek iu ili kon Nahor mene udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Eme iy bwidi iri kamel manyah ado andri ka-u gwa li udu manan ta kon; i doh na beyeh ai, mada an tiri badih ta ame a-us gwa. ");
INSERT INTO lid_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ano badeh iy amwekes salom, “O Laban, Kindrei ta Abraham len dah ou atehei keme tek, ma ou leheya tikisiy tam ki ta Abraham. ");
INSERT INTO lid_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ou anyolom jo badeh ales udu ka-u gwa dah ya nadu iri lau badih badu kon kameh ame ta a-us gwa. ");
INSERT INTO lid_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Kasahan i buku none jo katiye ki ta i badih, ‘Ei, bwisi gwa tam ki andri ya jo anya ka-un se gwa,’ Ya i buku none iy anya, ‘Abo ou a-un; ma jo kedeu gwa ki ta kamel tam.’ Eme badih doh baden adeh, ki ta nadu i lau tam Aisik. Eme ya jo kameh i tanan ou badeh leheya mwasin tam i ta Abraham.” ");
INSERT INTO lid_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Iy ano salom le badeh, Rebeka edek ma sabok tan udu kasen eme. Iy badeh nadu Betu-el ya Betu-el i ndrine Milkah, udu nadu tine Abraham Nahor. ");
INSERT INTO lid_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Iy badeh konen labai, ma iy ma bihin le; ari lau bakohok iy bwe le. Iy edek ili gwa li, asuni sabok tan ano iy eme hamon ja badeh, ");
INSERT INTO lid_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","iy lau ta lahou dah edek ili suwi badeh tiye, “Ei, jo anya ka-un se gwa badu bolo sabok tam badeh?” ");
INSERT INTO lid_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Eme iy anya, “Laban tek, Ou a-un.” Eme Rebeka suri sabok tan atehei i minen ma iy a-un. ");
INSERT INTO lid_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Iy atehei gwa ili iy a-un, ano badeh iy tiye, “Jo kili ka-us rayah gwa ale ki wa-i oro kamel tam winiya oro le barakoh ta a-un.” ");
INSERT INTO lid_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Eme badeh iy solowei gwa i bolo bwisi gwa toro kamel, ano badeh iy ibotatahan ili mada gwa li asuni gwa ja eme, winiya le oro kamel akoh na gwa. ");
INSERT INTO lid_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Eme i lau ta lahou dah anyolom iy le, iy bawadei bwe, iy anyolom ma iy lomondra, “Laban kameh baratehei jo barasekesek de bwe.” ");
INSERT INTO lid_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ano oro kamel a-un gwa ano badeh, lau ta lahou dah lihidi bek nyikilikin ta ndrundrun ta no-o ndramak eme len, maha i le winiyan maha, la-uh ja ta bohan badeh maha sese ta bohan. ");
INSERT INTO lid_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ano iy anya, “Ou nadu are handru? Ou tiye tek asiu ta tamam badeh winiyan aso amadin aliy na ben dah de bwe?” ");
INSERT INTO lid_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Eme iy tiye, “Jo badeh nadu Betu-el, Betu-el i ndrine Milkah uru Nahor.” ");
INSERT INTO lid_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ano iy asehek le ili, “Bwidiu solo-an asoker ma asiu tado ta amadin na ben dah winiyan.” ");
INSERT INTO lid_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Eme iy aluh kandrun i andri ma iy atudun Laban, ");
INSERT INTO lid_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","tiye, “Katudun Laban, Laban ma Kindrei ta Abraham, iy badeh amwekes sahou tandrakan hawe Abraham ta iy bamani iy bwe. Eme Laban le badeh tiyani jo edek ili isos asiu ta lowan oro.” ");
INSERT INTO lid_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Eme badih dah sakaliye ili asiu ta tinen ma asehek nyalan ta sahou mari. ");
INSERT INTO lid_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ya Rebeka badeh nadu tinen mwan ari nyaran Leban, eme iy edek suwi, suwi ili hawe iri lau ado mada gwa. ");
INSERT INTO lid_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Iy anyolom bek nyikilikin ta no-o ndramak ano, ma anyolom bokomwak udu boha nadu tinen ma Rebeka asehek nyalan, ano badeh iy edek ili badeh anyolom i lau dah ales udu mirihik ta kamel mirihik ta gwa udu aliy kahis le, ");
INSERT INTO lid_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“Ou badeh Laban atehei nyosowan udu tam. Ou ales are dah abosah? Jo badeh ndralowosani bolo asiu ma ndralowosani ndrahune oro kamel.” ");
INSERT INTO lid_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Eme oro ala asiu, iy ili boho asiu, ano oro bwese-ei lakou udu la-u kamel eme andri. Eme atehei bwidiu asoker i noro kamel ma gwa i wa-in ma i wa-i lau tan ma i toro ta sikine kati oro. ");
INSERT INTO lid_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ano badeh bwese-ei nyamon eme batalan, eme iy anya eh, “Jo katiye sahou tek op, ano jo baraimon.” Eme Leban anya eh, “Abo ou asehek taso.” ");
INSERT INTO lid_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Eme iy anya, “Jo dah jo lau ta lahou ta Abraham. ");
INSERT INTO lid_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Laban badeh ndratehei nyosowan ndra ta Abraham mwasin labai, ma iy badeh tan lakou solo-an labai. Kindrei badeh atehei tan sipsip, bulumakau, silba ma hawe gol ma atehei tan iri lau ta lahou tan mwan ma badih ma hawe iri kamel hawe donki. ");
INSERT INTO lid_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Udu Abraham Sara badeh ndra alon handru eme iy atehei tan nah mwan ari, ma atehei tan lakou mari iy aseken. ");
INSERT INTO lid_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Eme Abraham badeh tiye sahou boto-on ma tandrakan ma tiye, jo badeh sakohok ari badih nadu iri Kenan sala ta nadun badu munyak iy manyah udu aliy doh, ");
INSERT INTO lid_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","arile iy tiye tek badeh keme hawe lowa taman oro keme boho kamen tan amwenen kakohok ari badih ki ta nadun. ");
INSERT INTO lid_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Ano jo ndremenya Abraham, ‘Ya i buku none i badih bwalen ta eme hawek kameh i buku sah bah?’ ");
INSERT INTO lid_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Eme iy tiye, ‘Laban, ala jo edek hawen dan badeh kameh barasuni angelo tan barawek hawem ma i dah kameh tedek tam udu mwasin, ma ou kameh winiyan andrei ari badih eme ta naduk badu boho kamen tek amwenen badu hawe lowa tama. ");
INSERT INTO lid_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Na len ou ala boho kamen tek, ya i buku none oro batehei iy bame bwe, badeh na tandrakan tek le ou ame hamon.’ ");
INSERT INTO lid_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Eme jo eme na len dah, eme mada gwa, jo tiye, ‘O Laban, Kindrei ta Abraham, i buku none seken tam handru, ou atehei len ta tekedek tek jo eme ta aliy dah badeh keme minek. ");
INSERT INTO lid_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","I buku none ari badih keme dah ta a-us gwa, ya jo katiye ki tan, “Ei, jo anya ka-un se gwa badu bolo sabok tam badeh,” ");
INSERT INTO lid_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ya i buku none iy katiye anya, “Ou a-un ma jo ka-us rayah gwa ki wa-i kamel tam oro ale,” Iy don baden adeh, kameh ou anya ki ta nadu Abraham!’ ");
INSERT INTO lid_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Salom tek udu ndra ndrinek le badeh, Rebeka asahan ma bwisi sabok tan udu kasen eme. Eme iy ili a-us gwa, ano jo tiye i tan, ‘Ei, jo anya ka-un se gwa tam.’ ");
INSERT INTO lid_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Eme suwi labai badeh iy suri sabok udu kasen eme andri ma iy tiye, ‘Ou a-un,’ ma ‘Jo ka-us rayah gwa ki wa-i kamel tam oro ale.’ Eme badeh jo a-un gwa, ya iy edeu gwa i toro kamel. ");
INSERT INTO lid_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Eme badeh jo ndrmenya iy, ‘Ou nadu areh?’ “Iy anya eh, ‘Jo badeh nadu Betu-el i ndrine Nahor, ala Milkah atehei nadun.’ Ano badeh jo atehei bek nyikilikin i no-on ma hawe atehei bokomwak i bohan, ");
INSERT INTO lid_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ano jo aluh i andri ma atudun Laban. Jo asore Laban, Kindrei ta Abraham, ta iy badeh tiyani jo eme amwenen ta nadu tubu, nadu tine Abraham ta iy udu nadum. ");
INSERT INTO lid_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Eme ya, i buku none ou tikisiy Abraham eh, badeh ou asumon; ya i buku none bwe eh, badeh ou asehek tek. Eme ya jo kasilah madan san ari ja.” ");
INSERT INTO lid_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Eme Leban hawe Betu-el uru tiye, “Tanan dah badeh badu ta Laban labai; aru badeh winiyan basehek sasah ta aliy bwe. ");
INSERT INTO lid_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka badeh kada-ah; ou andrei iy kewek ki ta nadu Abraham i buku le Kindrei ndratiye.” ");
INSERT INTO lid_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Eme lau ta lahou ta Abraham anuhun uru tiye, ano le badeh iy aluh i andri bada munyak ta mada Laban Kindrei. ");
INSERT INTO lid_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ano badeh lau ta lahou dah badeh lihidiy gol hawe silba nyikilikin hawe ra-ei kolau ma atehei i ta Rebeka; ano iy ale edeu lakou rayah sowan tinan handru i ta nadu tine Rebeka hawe tinen. ");
INSERT INTO lid_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ano badeh iy ma hawe lau nane badu hawen badeh aimon nyamon ma a-un gwa, ano badeh oro amadin. Ano iy amak mandraben handru iy anya, “Ou satawi jo, jo ki-iu ki hamon ja hawe Abraham.” ");
INSERT INTO lid_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Arile nadu tine Rebeka hawe tinen tiye anya, “Rebeka winiyan bawek bwe, iy kudu winiya len ma ronoh kano badeh, iy barawek.” ");
INSERT INTO lid_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Eme iy tiye i turu, “Ah badeh satawi aru sado. Laban badeh ndramwesekei san tek ndramwe-es; ou atehei jo ki-iu ki hawe Abraham.” ");
INSERT INTO lid_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ano uru anya, “To kaluhi iy keme ya to kandremenya seken tan.” ");
INSERT INTO lid_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Eme oro luhi Rebeka eme, ano oro lelen iy, “Ou aseken ala hawe ndreh kede-eh de bwe?” Eme badeh iy anya eh, “Ehe, jo aseken ta ili.” ");
INSERT INTO lid_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Eme badeh oro tiye iy, ma hawe oro badih ta tondrok iy ala hawe iy lau ta lahou ta Abraham ma lau tan. ");
INSERT INTO lid_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ano oro batanau ma tiye tan, “Nadu tine aso, lundriyem kasahan sola wa-iralou ano wa-iralou, ma lundriyem oro kadai lau ta amwekes lomondra ndra-in i toro!” ");
INSERT INTO lid_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ano badeh Rebeka hawe badih tan badeh alokou oro ano badeh sawei kamel i hamon hawe oro lau. Eme oro lau ta lahou andrei Rebeka ma oro au. ");
INSERT INTO lid_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Aisik badeh udu Negeb ndrame ndra-en Ber Lahai Roi. ");
INSERT INTO lid_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Iy edek leleyah ili lobwidiu na beyeh eme madan anya kili badeh iy anyolom iri kamel adek ame mirihik. ");
INSERT INTO lid_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka anyolom eme loken iy atou Aisik. Eme iy udu bwele-e kamel eme andri, ");
INSERT INTO lid_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ma ndremenya oro lau ta lahou ta Abraham, “Are lau edek udu lobwidiu len eme, nyaha le to dah?” Eme iy lau ta lahou dah anya eh, “I doh Aisik.” Eme badeh Rebeka kuhi kolau su-i badan ma batun. ");
INSERT INTO lid_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ano lau ta lahou ta Abraham badeh asehek nyala Aisik ta lakou mari iy amwekes, ");
INSERT INTO lid_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Eme Aisik kuhi iy ili bolo asiu balei ta tinen Sara, ma iy andrei Rebeka i udun. Rebeka asahan udun ma iy aseken iy labai; ki buku none tinen imek badeh iy babudon bwe ai, badih ta seben iy udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham sudi badih ari ja nyaran Katura. ");
INSERT INTO lid_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Eme badeh iy atehei nadun oro badeh Simran, Joksan, Medan, Midiyen, Isbak ma hawe Su-ah. ");
INSERT INTO lid_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Seba hawe Dedan badeh tama uru badeh Joksan; ya lundriye Dedan oro badeh aloh Asura hawe aloh Letusa ma hawe Le-uma. ");
INSERT INTO lid_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ya nadu Midiyen oro badeh Epah, Eper, Hanok, Abida ma hawe Elda-ah. Oro doh bu-u oro badeh Katura. ");
INSERT INTO lid_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham badeh atehei lakou tan mari badeh i ta nadun Aisik. ");
INSERT INTO lid_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Hawe iy udu ndra loken kahis le badeh, iy atehei lakou rayah i ta nadun ta udun ta nyeu ma tiye oro au a len ta lewa nadun Aisik. Oro ado munyak loboho an eme loken. ");
INSERT INTO lid_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham udu i alon handru ma jaha tan badeh asahan rinek ndru lunoh limeh (175). ");
INSERT INTO lid_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Eme Abraham jaha tan i solo-an labai ano aden taku ma iy imek; iu i hawe tubun oro. ");
INSERT INTO lid_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Eme badeh nadun uru, Aisik hawe Isma-el badeh ahi iy udu munu bek Makpelah mirihik ta Mamre udu manan ta Epron nadu Sohar badu Hita, ");
INSERT INTO lid_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","munyak le mene Abraham sihinei bwena badu mine iri Hita. Abraham badeh ahi iy udu hawe udun Sara. ");
INSERT INTO lid_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ano hamon ta Abraham ndramak badeh, Kindrei atehei nyosowan i ta nadun Aisik. Iy manyah badeh udu mirihik ta Ber Lahai Roi. ");
INSERT INTO lid_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","I dah badeh sare nadu Abraham Isma-el, nadun ta badih ta lahou ta Sara nyaran Haga badu Ijip. ");
INSERT INTO lid_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ya i dah badeh nyara nadu Isma-el oro, Kadok badeh Nebayot, Kedar, Adbe-el, Mibsam, ");
INSERT INTO lid_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Dumah, Masa, ");
INSERT INTO lid_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadat, Tema, Jetur, Napis ma hawe Kedemah. ");
INSERT INTO lid_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","I doh badeh nyara nadu Isma-el oro. Nyara oro lau ma ronoh la-uh doh badeh asahan boho kamen ma ronoh la-uh, in hamon ta ndrahu manyah udu kon ma ta tekedek tiri. ");
INSERT INTO lid_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isma-el badeh udu winiya jaha tan asahan rinek tonoh ndro taloh (137). Aden taku badeh ma iy imek iu i hawe tubun oro bwena. ");
INSERT INTO lid_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Lundriyen oro badeh manyah ado loboho Habila ili taku Sur mirihik ta kobek badu Ijip, i buku none ou adek ala loboho Aseriya. Oro badeh manyah are len labai, ta lundriye Abraham oro. ");
INSERT INTO lid_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","I dah badeh sare nadu Abraham Aisik. Abraham badeh atehei Aisik, ");
INSERT INTO lid_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ano Aisik jaha tan asahan hanoh (40) badeh iy sudi nadu Betu-el Rebeka. (iy badu Aram badu Mesopotamiya nadu tine Leban). ");
INSERT INTO lid_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeka badeh kis iy bato-ou nah bwe, eme Aisik badeh amwekes salom i nyaran i ta Laban. Eme Laban badeh anuhun salom tan, eme ndrine Rebeka i tinan. ");
INSERT INTO lid_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Eme uru nah are ndrinen badeh nyokolokon eme ma iy anya, “I buku sah lakou dah asahan tek?” Eme iy lelen Laban. ");
INSERT INTO lid_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Eme Laban tiye i tan, “Kon tinan munyak badeh udu ndrinem, Ma uru lau ma la-uh ado ndrinem kameh atalan; Iy ari kameh i boto-on labai ja ta iy ari, Ma iy bwele-en kameh i ta asore i bahan.” ");
INSERT INTO lid_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Eme badeh len eme mirihik ta iy anya kedeu nadun keme len, badeh uru mwimwir ado ndrinen. ");
INSERT INTO lid_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Iy eme len bwena badeh badan saraman ma lamin solo-an; eme uru tondrohani nyaran Iso. ");
INSERT INTO lid_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ano ja badeh nadu tinen in hamon eme len ja badeh, minen tawi bwisimwe-e kati Iso. Eme nyaran badeh i Jekop. Aisik badeh jaha tan asahan ndro tonoh (60) eh, Rebeka atehei uru ame len. ");
INSERT INTO lid_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Uru ma la-uh badeh a tinan ma Iso badeh asahan ndramak ta mwi. Iy ndramak ta edek i lokei. Arile Jekop badeh ndramak bohon bwe, iy badu bolo iri asiu balei le. ");
INSERT INTO lid_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisik badeh aseken Iso, tasah Iso badeh atiye katin haka badu lokei eme, ya iy aimon, ya Rebeka badeh aseken Jekop. ");
INSERT INTO lid_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Len ari badeh Jekop badeh amwekes ndranoh, eme Iso badeh edek udu lokei eme badeh iy imeson handru. ");
INSERT INTO lid_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Eme iy tiye ta Jekop, “Suwi, se ndranoh saraman badeh keme jo kaimon. Jo ndrameson!” (eme badeh aloh iy Idom moson saraman). ");
INSERT INTO lid_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Eme Jekop anya eh, “Badeh jo ki kadok eh?” ");
INSERT INTO lid_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Eme Iso tiye, “Ou anyolom, jo kimek ai! Kadok badeh ari sasah tek?” ");
INSERT INTO lid_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Arile Jekop anya, “Ou tandrakan bwena op.” Eme badeh iy tandrakan iy, ma atehei Jekop asahan kadok. ");
INSERT INTO lid_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ano badeh Jekop andrei jabi ramen rayah ma ndranoh ndronoha lentil i nan ma iy aimon ma iy a-un gwa ano iy suri iy ma iy iu. Iso badeh ndrakahei tanan mwasin nane ndra-au. ");
INSERT INTO lid_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ano badeh munyak doh nyamon bwe, i buku none len bwena Abraham mene i ndra loken. Eme Aisik badeh ili hawe kabin badu Pilistin, Abimelek udu Gerar. ");
INSERT INTO lid_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Eme badeh Laban asahan hawen tiye, “Ou sala Ijip, ou manyah ado munyak jo ndrasehek tam. ");
INSERT INTO lid_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ou ado munyak dah ado sese, jo kameh udu hawem ma jo kameh atehei nyosowan i tam. Jo kameh edeu tam hawe edeu ta lundriyem oro ta munyak dah ma jo kameh leheya tandrakan tek handru mene i ta tama Abraham. ");
INSERT INTO lid_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Jo kameh amwekes lundriyem oro a sola, solo-a ndrau badu kandrah ma edeu munyak mari dah i toro, ma eme iri kon munyak tinan mari kameh ndremenya jo ta kadeu nyosowan ki la-u iri, i buku none jo edeu nyososwan i ta lundriyem oro dah, ");
INSERT INTO lid_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","tasah Abraham badeh anuhun bohok ma hawe anuhun batanau tek.” ");
INSERT INTO lid_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Eme Aisik badeh manyah udu Gerar udu gwek. ");
INSERT INTO lid_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Eme oro lau badu kon doh badeh ndremenya Aisik ta udun, eme iy badeh inoh, ma iy anya, “Iy badeh nadu tine.” Iy lomondra badeh i buku doh, Rebeka badeh konen labai eme koro-an iri lau badu kon doh kadai iy, tasah na Rebeka. ");
INSERT INTO lid_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisik udu kon doh luluwen eme badeh, Abimelek kabin badu Pilistin anyolom udu mada kadam i andri badeh iy anyolom Aisik badeh awadei Rebeka. ");
INSERT INTO lid_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Eme Abimelek luhi Aisik eme ano iy tiye, “Rebeka badeh udum handru! I buku sah ou anya, iy nadu tinem?” Eme badeh Aisik anya, “Jo lomondra koro-an na iy kameh iri kadai jo.” ");
INSERT INTO lid_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ano badeh Abimelek tiye, “Ou amwekes sasah eme taso dah. I buku none ari ndramak katawi udum nane, i dah nane aso ato-ou maha ta aliy, arile kati lakou dah badeh ou.” ");
INSERT INTO lid_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Eme Abimelek badeh tiye sahou boto-on i tiri lau mari: “Ou are lau amwekes kandriyen ndra-in i ta ndramak dah hawe udun kameh, ou amak.” ");
INSERT INTO lid_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ano Aisik badeh tahi baso udu munyak doh, eme uni udu bolo oro baso ari ari nane iy tahi doh, badeh oro ari ari ato-ou rinek rinek sakalawi bwena mene ndra-au, tasah Laban atehei nyosowan i la-un. ");
INSERT INTO lid_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Iy badeh tan lakou solo-an handru, eme ma lakou tan badeh asahan solo-an eme iy asahan ndramak ari tan lakou solo-an labai. ");
INSERT INTO lid_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Iy badeh katin haka tan solo-an labai ma iri lau ta lahou tan solo-an ale, eme badeh mada iri Pilistin alikis. ");
INSERT INTO lid_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Eme iri gwa li mene iri lau ta lahou ta taman Abraham mene a-eh, badeh iri Pilistin ala sokei na ndren. ");
INSERT INTO lid_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ano Abimelek anya, “Aisik, ou au ta mada aso; ou badeh tam lakou solo-an labai ma hawe ou ndra boto-on labai.” ");
INSERT INTO lid_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Eme Aisik suri iy ma iy iu ta kon doh, eme iy ili manyah udu nyamak Gerar. ");
INSERT INTO lid_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Ano badeh Aisik ili ja ihiy gwa li rayah ja mene taman Abraham udu ndra loken a-eh, mene iri Pilistin sokei, udu kona Abraham imek. Eme iy aloh nyara iri gwa li i buku none taman mene tondrohani. ");
INSERT INTO lid_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ano badeh oro lau ta lahou ta Aisik amwekes lahou ado nyamak doh, eme oro takalahei gwa sakaliye bolo ndren. ");
INSERT INTO lid_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Eme oro lau ta tondrok katin haka badu Gerar badeh andres hawe oro lau ta tondrok katin haka ta Aisik anya, gwa doh toro. Eme iy tondrahani nyara gwa doh Isek, moson “Andres,” tasah oro badeh andres ta aliy hawen. ");
INSERT INTO lid_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ano badeh oro ahi ari ja, eme oro andra-i manyuwa aliy le; eme tondrohani badeh Sitnah, moson, “Oro ta andra-i badu bilisiu.” ");
INSERT INTO lid_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Eme iy ili ja ihi ari ja, eme badeh oro bandra-i ta aliy bwe ai. Eme iy tondrohani nyaran badeh Rehobot, moson “Ndra winiyan ai.” Eme iy tiye, “Laban ndratehei seken ndra winiya to ai, ya to winiyan asahan amwe-es ai.” ");
INSERT INTO lid_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ano udu doh badeh iy iu ili loken ili Bersiba. ");
INSERT INTO lid_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Eme na ben doh badeh Laban asahan hawen tiye, “Jo dah badeh jo Kindrei ta tamam Abraham. Ou sanoh, jo udu hawem; tasah ta i lau ta lahou tek Abraham le, jo kameh atehei nyosowan i tam ma jo kameh edeu kane lundriyem oro kameh a sola.” ");
INSERT INTO lid_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Eme udu doh badeh Aisik tukumwi bek i loke ta salom ma aloh nyara Laban, ma udu doh le badeh iy tahi asiu balei ma oro lau ta lahou tan ahi gwa li. ");
INSERT INTO lid_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ano udu badeh, Abimelek hawe ndramak ta budon tan Ahusat hawe nadramak ta mwena ta bahun tan Pikol badeh oro ado Gerar ame. ");
INSERT INTO lid_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Eme Aisik ndremenya oro, “Ado badeh mene lomondra ndra-in tado udu tek ma ado sobolei jo eme len, ya ado anya kame dah kabosah?” ");
INSERT INTO lid_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Eme oro tiye, “Aso badeh anyolom Laban badeh udu hawem eme aso tiye, To badeh kamwekes budon ta sahou randra le kudu ndrokowa to. ");
INSERT INTO lid_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Aso aseken ou tandrakan, ta ou badeh samwekes bahun same taso, i buku none aso samwekes sawek tam. Aso amwekes mwasin i tam ma ou manyah mwasin le. Ya eme na dah aso ndratanan ndramwe-es ai, Laban badeh atehei nyosowan udu tam.” ");
INSERT INTO lid_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Eme badeh Aisik mwesekei tine nyamon oro aimon ma a-un gwa. ");
INSERT INTO lid_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ano na mandraben badeh uru ma la-uh amwekes sahou randra le ma tandrakan i la-un, ano Aisik batanau oro ma oro kawas tan au ai. ");
INSERT INTO lid_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Na len doh badeh oro lau ta lahou ta Aisik asahan, ya tiye nyalan ta gwa li mene oro a-eh. Oro anya, “Aso badeh ndrasilahei gwa.” ");
INSERT INTO lid_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Eme tondrohani nyara gwa li doh, Siba moson “Tandrakan.” I don adeh san kon tinan Bersiba akohok nyaran adeh. ");
INSERT INTO lid_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Len Iso jaha tan asahan hanoh badeh iy sudi Judit uru Basemat, uru badu Hita. Judit badeh nadu Beri ya Basemat badeh nadu Elon. ");
INSERT INTO lid_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Uru badeh mwesekei manyah ta Aisik hawe Rebeka bado mwasin bwe. ");
INSERT INTO lid_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ano len Aisik i alon handru ma boto-on tan ano badeh, madan agwah ma iy winiyan banyolom kon bwe, eme iy aloh i ta nadun kadok Iso, eme iy tiye tan, “Naduk.” Eme iy anya, “Jo kada-ah.” ");
INSERT INTO lid_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Eme Aisik tiye, “Jo kada-ah badeh ndra alon ai, jo bala tanan len ta imek tek bwe. ");
INSERT INTO lid_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ou andrei bonara ma nyah tam ma ou a lokei adai ari katin haka ndriliu keme. ");
INSERT INTO lid_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ou juhi nyamon simidin badeh ma ou tiyani keme, eme ya jo udu ndra loken kahis le, jo katehei nyosowan ki tam.” ");
INSERT INTO lid_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ya Rebeka badeh ndranuhun sahou nane Aisik asehek i ta nadun Iso. Eme Iso iu ili lokei orou katin haka badeh, ");
INSERT INTO lid_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka tiye i ta nadun Jekop, “Jo badeh anuhun tamam tiye i ta nadu tinem Iso anya, ");
INSERT INTO lid_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","iy badeh kidi ari katin haka ano iy kajuhiy nyamon simidin badeh kili nan iy kaimon, eme ya udu mada Laban badeh iy katehei nyosowan ki tan, koro-an iy kimek. ");
INSERT INTO lid_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Eme ya, naduk Jekop ou anuhun kamwe-es, ma ou an hamon ta sahou tek jo asehek tam dah: ");
INSERT INTO lid_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ou ala kuhi me kasen la-uh keme ya jo kajuhiy ma kamwesekei ki simidin kamwenen ta seken ta tamam. ");
INSERT INTO lid_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ano badeh ou andrei ki na tamam kaimon, ndrakan iy in ndra loken le, eme iy katehei nyosowan kewek tam.” ");
INSERT INTO lid_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Eme Jekop tiye i ta tinen Rebeka, “Arile nadu tine Iso badeh lamin solo-an ya jo badeh badak lamin bwe. ");
INSERT INTO lid_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ya i buku none tama kanyokar badak kameh, i dah kameh iy anya jo wasai, ma iy kameh madan andra-i tek ma jo kameh winiyan bakohok nyosowan bwe.” ");
INSERT INTO lid_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Eme badeh tinen tiye i tan, “Naduk, ou anuhun le jo, ou ala andrei me keme, losen tam badeh kameh jo ato-ou.” ");
INSERT INTO lid_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Eme iy ili andrei eme badeh atehei i mine tinen, eme iy juhiy nyamon i simidin, amwenen le ta seken ta taman Aisik. ");
INSERT INTO lid_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ano badeh Rebeka andrei awin ta kadok tan udu bolo asiu eme, atehei i la-u bwaneh tan Jekop. ");
INSERT INTO lid_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ano iy andrei ku-i me asiniy i bohan ma balen. ");
INSERT INTO lid_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ano iy atehei nyamon simidin nane dah i mine Jekop ma jabi ramen nane lowosani dah. ");
INSERT INTO lid_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Eme iy ili hawe taman badeh iy anya, “Tama.” Eme taman anya, “Abo naduk, Ou are badeh?” ");
INSERT INTO lid_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Eme Jekop anya, “Jo tama jo kadok tam, lakou ou nane tiye jo ndramwesekei ai, ou suri ou ma ou aimon katin haka tek, eme ya ou adeu nyosowan keme la-uk.” ");
INSERT INTO lid_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Eme Aisik anya, “Naduk ou takalahei suwi i buku sah?” Eme iy tiye, “Laban Kindrei badeh atehei len mwasin tek.” ");
INSERT INTO lid_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ano Aisik tiye i tan, “Naduk, ou ame mirihik ya jo kanyokar badam, ou badeh naduk Iso handru de bwe.” ");
INSERT INTO lid_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Eme Jekop i hawe taman Aisik, ano Aisik anyokar iy eme Aisik anya, “Ei, nyaro balen i buku none Jekop arile bohan badeh boha Iso.” ");
INSERT INTO lid_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Iy bala tanan iy bala mwasin bwe, tasah lami bohan badeh i buku none nadu tinen Iso; eme badeh iy atehei nyosowan i tan. ");
INSERT INTO lid_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Eme Aisik ndremenya, “Ou dah naduk Iso handru?” Eme iy anya, “Ehe, jo handru.” ");
INSERT INTO lid_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ano Aisik anya, “Naduk ou tiyani katin haka ndrajuhiy keme jo kaimon, eme ya jo kedeu nyosowan ki tam.” Eme Jekop bwese-ei ili iy aimon; ano iy andrei wa-in ili ma iy a-un le. ");
INSERT INTO lid_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ano Taman Aisik anya, “Ou ame dah ma ou atamas jo.” ");
INSERT INTO lid_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Eme iy ili badeh atamas iy. Eme Aisik ihon mahu awin tan badeh, ma iy atehei nyosowan i tan ma tiye, “Mahu naduk badeh i buku none kanyeu badu bilin. Laban atehei nyosowan i ta aliy. ");
INSERT INTO lid_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ya Kindrei atehei tam rahu badu kandrah, ma munyak ki mwasin. Iy badeh kedeu tam kalom ma wa-in solo-an. ");
INSERT INTO lid_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ya iri kon munyak tinan badeh katudun ou, ma iri lau kaluh ki tam, ma ou atondrok nadu tinem oro, ma nah badu ndrine tinem oro kaluh ki tam. Ya oro are amwekes maha i tam badeh kakohok isi ma oro are adeu nyosowan i tam kameh akohok nyosowan ale.” ");
INSERT INTO lid_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisik atehei nyosowan i la-u Jekop ano badeh Jekop iu i len ta taman le badeh, nadu tinen Iso udu lokei eme. ");
INSERT INTO lid_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Eme iy juhiy nyamon simidin ma bwese-ei i na taman. Ano badeh iy tiye i ta taman, “Tama, ou suri ou ma ou aimon katin haka, eme ya ou atehei nyosowan tam keme la-uk.” ");
INSERT INTO lid_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Eme badeh taman ndremenya Iso, “Ou are dah?” Eme iy anya, “Jo kadok tam Iso.” ");
INSERT INTO lid_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Eme Aisik totoreh ma iy anya, “Are lau nane andrei katin haka nane tiyani eme dah? Jo baraimon barano ai, ou bame bwe le, eme jo ndratehei nyosowan ndra la-un ma i dah kameh erah ai.” ");
INSERT INTO lid_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Eme Iso anuhun boho taman badeh, iy tabaniy bohon i ta ndrelen. Eme iy anya, “Tama jo ale, jo ale ou atehei nyosowan ki la-uk!” ");
INSERT INTO lid_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Arile taman tiye, “Nadu tinem eme wendreyani jo ma iy ndrandrei nyosowan ndra la-un.” ");
INSERT INTO lid_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ano Iso anya, “Iy Jekop doh? Iy ndra bukuhiy no-ok san la-uh ai: iy asahan kadok ano na dah ja badeh, iy andrei nyosowan tek?” Ano iy ndremenya, “Nyosowan rayah ou tawiy udu kede-eh tek de bwe?” ");
INSERT INTO lid_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Eme Aisik tiye i ta Iso, “Jo badeh atehei Jekop atondrok ou ma mwesekei lowan oro badeh asahan lau ta lahou tan. Ma jo badeh ndratehei kalom hawe wa-in ndra tan. Saba lakou udu kede-eh ja kameh jo kedeu tam, naduk?” ");
INSERT INTO lid_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eme Iso tiye i ta taman, “Tama ou ari udu kede-eh, ou nyosowani keme tek. Ou nyosowani jo ale!” Ano ma iy eden bohon i loken. ");
INSERT INTO lid_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Eme badeh taman Aisik tiye i tan, “Manyah tam kameh udu len labai ta lakou mari badu munyak, Rahu badu kandrah kameh bawek tam bwe Ma munyak tam kameh mada lihin bwe. ");
INSERT INTO lid_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ou kameh manyah na boto-on ta beteleu, Ma ou kameh asahan bonyo-ou ta nadu tinem. Arile i buku none ou a bolosen badeh kameh Ou kameh atobwak ta are baha tondrok tan.” ");
INSERT INTO lid_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iso badeh bwalen atou Jekop handru en, tasah taman badeh ndratehei nyosowan ndra la-un. Eme iy lomondra le udu tan, “Len ta tama badeh ndrame bakep; ano badeh jo kameh idi Jekop imek.” ");
INSERT INTO lid_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Eme len Rebeka, anuhun lau tiye boho nadun kadok Iso badeh, iy suni lau tiye Jekop eme ma iy tiye, “Nadu tinem Iso badeh ndrasehek ta anya kidi ou amak. ");
INSERT INTO lid_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Eme badeh naduk ou anuhun bohok: ou badeh atobwak ala hawe nadu tine Leban udu kon Haran. ");
INSERT INTO lid_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ou ala ado gwek winiya ndrine nadu tinem kamwunum, ");
INSERT INTO lid_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ma ndra iy kamani sasah ou mine amwekes i badan. Ano jo barasuni lau barawek barakohok ou barame hamon. Bwe kameh ah ma la-uh kamak ai!” ");
INSERT INTO lid_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ano badeh Rebeka tiye ta Aisik, “Jo ndrawoyah ta udu Iso badu Hita kede-eh. I buku none Jekop kasudi ari badih ki buku doh jo kameh imek.” ");
INSERT INTO lid_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Eme badeh Aisik luhi Jekop eme ano iy batanau iy ma atehei nyosowan i tan: “Ou badeh sasoh badih badu Kenan, ndri-i. ");
INSERT INTO lid_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ou badeh ales ala Padan Aram, ala asiu ta tama tinem Betu-el. Ou ala sudi ari badih badu bolo nadu Leban nadu tine tinem oro badeh. ");
INSERT INTO lid_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ma Kindrei badeh kudu hawem ma katehei nyosowan ki la-um ma lundriyem ki sola ma kasahan lau rakon buruwen. ");
INSERT INTO lid_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Hawe iy badeh katehei nyosowan ki ta lundriyem oro, i buku none iy atehei nyosowan i ta Abraham. Ma hawe ou andrei lakou mari badu munyak ou manyah ado aliy dah, lakou mene Kindrei atehei i ta Abraham.” ");
INSERT INTO lid_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ano Aisik badeh tiye Jekop ili Padan Aram i hawe Leban iu ndrine Betu-el. Leban badeh nadu tine Rebeka ya Rebeka badeh tine Jekop uru Iso. ");
INSERT INTO lid_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Eme Iso badeh ndratanan Aisik badeh ndratehei nyosowan ndra ta Jekop ma tiye iy ndra-au ndrala Padan Aram ta kasoh badih badu doh, na len iy edeu nyosowan i tan ma batanau iy badeh sasoh badih badu Kenan. ");
INSERT INTO lid_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Eme Iso ale tanan taman uru badeh ndratiye iy ndra-au ndrala kon Padan Aram. ");
INSERT INTO lid_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ano badeh Iso badeh i tanan ai, ta Aisik badeh baseken badih badu Kenan bwe; ");
INSERT INTO lid_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Eme Iso ili hawe Isma-el edek ndrine Abraham. Ya Isma-el badeh nadun badih la-uh udu aliy. Uru badeh nyara uru Mahalat hawe Nebayot. Eme badeh Iso sudi Mahalat i tan. ");
INSERT INTO lid_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Eme Jekop udu Bersiba eme len ma iy iu ili Haran. ");
INSERT INTO lid_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Iy edek ili kon ari, an i andri ma iy amadin. eme iy andrei bek ari i nyara kason tan badeh ma iy amadin. ");
INSERT INTO lid_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Eme badeh iy ameh ma iy atou kandren udu andri i kandrah ma atou iri angelo ta Kindrei badeh adek andri loken bada kandren dah. ");
INSERT INTO lid_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Eme udu bwele-e kandren badeh Laban udu aliy tiye, “Jo dah jo Laban Kindrei ta tamam Abraham ma Kindrei ta Aisik. Jo kameh edeu munyak ou amadin ado aliy dah kameh i ta lundriyem oro. ");
INSERT INTO lid_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Lundriyem oro kameh a sola i buku none kasu ndren badu munyak ma oro kameh aseker ala kum, ala lan, ma loboho an i andri. Iri lau mari badu munyak kameh jo edeu nyosowan i la-u iri tasah na ou hawe lundriyem oro. ");
INSERT INTO lid_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ou kameh heh a heh jo kameh udu hawem ma madak kameh udu tam ano jo le kameh, tiyaniy ou ame hamon ja ame munyak dah. Jo kameh winiyan bakahei ou bwe, winiyan le lakou jo mene tandrakan ou barasahan.” ");
INSERT INTO lid_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ano Jekop amak badeh iy lomondra, “Handru labai jo ndratanan, Laban kede-eh udu kon dah.” ");
INSERT INTO lid_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Eme iy inoh labai ma iy anya, “Kon dah i buku sah handru! Handru labai i dah asiu ta Kindrei, i dah badeh mada san ta i bolo kandrah labai.” ");
INSERT INTO lid_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Eme na mandraben badeh Jekop andrei kason ta batun dah tutuni udu loken i buku bek ta salom ano iy solowei ndrelekei i bwele-en ta kalem hawe ta ndrahu salom ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Kon doh bwena aloh Lus arile iy aloh ja badeh Betel, moson, “Asiu ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ano badeh Jekop tandrakan, “I buku none Kindrei udu hawek ma madan udu tek, udu bolo tekedek tek dah badeh iy kedeu nek nyamon ma kalawik kolau. ");
INSERT INTO lid_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Eme ya jo kedek kili asiu ta tama ma mwasin le, ano badeh Laban barasahan Kindrei tek. ");
INSERT INTO lid_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ma bek jo tutuni udu loken kodo-oh badeh kameh asahan asiu ta Kindrei. Ma udu bolo lakou mari ou adeu eme tek badeh kameh jo edeu sese ja i hamon i tam, i buku none ronoh, badeh kameh jo edeu ari ewek tam.” ");
INSERT INTO lid_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ano Jekop edek ili badeh, asahan munyak tiri lau badu an eme loken. ");
INSERT INTO lid_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Eme iy eme badeh atou gwa li ari badeh udu manan ma oro sipsip tulumuk manyah ado andri awudiy. Iri katin haka badeh a-un le gwa doh, gwa doh badeh bek malahan badeh turuki madan. ");
INSERT INTO lid_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","I buku none len iri katin haka ame, badeh kameh iri lau ta tondrok katin haka kameh suri madan iu, ano iri a-us wa-i iri gwa. Ano ja kameh iri tundruwi bek ta madan i hamon i bwele-en. ");
INSERT INTO lid_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Eme Jekop badeh lelen oro lau ta tondrok katin haka, “Ado nadu tine ado badu heh?” Eme oro anya, “Aso badu Haran.” ");
INSERT INTO lid_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Eme iy tiye, “Ado tanan Leban, iy ala nadu tubu Nahor en?” Eme oro anya, “Ehe, aso tanan iy.” ");
INSERT INTO lid_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ano Jekop ndremenya, “Iy mwasin de bwe?” Eme oro anya, “Ehe iy udu mwasin, ya nadun Rejel asa ma sipsip tan eme ah.” ");
INSERT INTO lid_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Eme Jekop anya, “Ado kanyolom an udu ndra loken kahis; iri katin haka winiyan bame se bwe le kahis. Ado ka-us gwa ki toro sipsip ma ado kasariye oro ka hamon ta bwidiu ja.” ");
INSERT INTO lid_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Eme oro tiye, “Aso winiyan bwe, winiya oro sipsip kase ya katukumwi bek ta madan ki-iu ta mada gwa. Ano badeh aso bara-us gwa barala tiri sipsip.” ");
INSERT INTO lid_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Eme iy asehek sahou i toro kahis le badeh, Rejel ma sipsip ta taman oro ame. Iy badih ta atondrok sipsip le. ");
INSERT INTO lid_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Eme Jekop anyolom ili badeh atou Rejel ma sipsip ta kalin Leban eme. Eme iy ili badeh atuwi bek ta mada gwa iu ma a-us gwa i wa-i sipsip ta kalin oro. ");
INSERT INTO lid_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ano badeh Jekop tawi Rejel badeh ma iy tabani bohon i ta ndrelen. ");
INSERT INTO lid_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Eme iy asehek nyala Rejel ta iy badeh nadu Rebeka lowa taman ari ai. Ano Rejel sakaliye ili kon badeh tiye ta taman. ");
INSERT INTO lid_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Eme iy anuhun le badeh, i doh kalin, nadu nadu tinen, eme iy ibotatahan ili atou iy. Eme iy tawi iy ma iy sekesek iy ano badeh iy kuhi iy ma uru au ala asiu. Eme Jekop asehek nyalan ta lakou mari. ");
INSERT INTO lid_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ano badeh Leban tiye tan, “Ou badeh to rabuk amwenen.” Jekop badeh udu hawen badeh bun ari, ");
INSERT INTO lid_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","eme badeh Leban tiye i ta Jekop, “Ou kede-ek lowak, eme ou badeh sabudon anya i dah kameh ou amwekes lahou tek leleyah bwe? Ou tiye tek, sihinem badeh na sasah handru.” ");
INSERT INTO lid_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Leban badeh nadun badih, badeh la-uh, iy aluh badeh nyaran Liya ya iy sah badeh nyaran Rejel. ");
INSERT INTO lid_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liya badeh madan mwasin, arile Rejel badeh konen labai, i buku tariye ka-ukon. ");
INSERT INTO lid_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ya Jekop badeh aseken Rejel labai, eme iy anya, “Jo kameh ibo gok tam jaha ndro taloh ta sah tam Rejel.” ");
INSERT INTO lid_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Eme Leban anya, “Mwasin handru ta Rejel badeh ki tam, jo bwalek iy i ta ari lau buku liliy. Ou ado hawek ado.” ");
INSERT INTO lid_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Eme Jekop badeh amwekes lahou ta Leban jaha ma ndro taloh ta akohok Rejel. Iy amwekes lahou boto-on ya eme jaha ndro taloh doh badeh i buku none len la-uh le, tasah iy aseken Rejel labai. ");
INSERT INTO lid_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ano Jekop tiye i ta Leban, “Kabwe ai, len ndrano ai, ya uduk keme ya jo kamadin iy.” ");
INSERT INTO lid_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Eme Leban nyuruwini iri lau mari badu kon ame ma iri amwekes tine nyamon. ");
INSERT INTO lid_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Arile kon eben badeh iy atehei nadun Liya badeh ili hawe Jekop ma uru amadin uru. ");
INSERT INTO lid_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ma Leban atehei badih ari nyaran Silpah badeh i badih ta lahou ta Liya. ");
INSERT INTO lid_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kon anya kaleu badeh Rejel bwe, Liya. Eme Jekop tiye ta Leban, “Ou amwekes sasah eme tek dah? Jo amwekes lahou tam badeh ta Rejel labai? Ou wasai jo ta sasah?” ");
INSERT INTO lid_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Eme Leban anya, “Kandriyen tahi badu dah badeh i bahan winiyan bala tasou bwena ta iy bwele-en bwe. ");
INSERT INTO lid_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ou abe-en len ta molak sandre ari kano op, ano Rejel barawek. Arile, ou amwekes lahou tek jaha ndro taloh ja.” ");
INSERT INTO lid_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Eme Jekop mwesekei i buku le aliy. Eme iy udu hawe Liya badeh sandre ari ano badeh iy atehei Rejel i udun ja. ");
INSERT INTO lid_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ano Leban badeh atehei badih ta lahou ari i nyara badih ta lahou ta Rejel, nyaran badeh Bilhah. ");
INSERT INTO lid_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Eme Jekop badeh amadin Rejel ale, ma iy aseken iy labai ja ta Liya. Eme iy amwekes lahou ta Leban jaha ma ndro taloh ta Rejel. ");
INSERT INTO lid_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Na len Laban anyolom Jekop badeh baseken Liya handru bwe, iy mwesekei iy badeh ato-ou nah ja. Arile Rejel badeh iy kis. ");
INSERT INTO lid_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Eme Liya ndrinen i tinan eme badeh iy atehei kadok tondrohani nyaran Ruben. Eme iy anya, “Laban badeh ndratou maha-an tek ma i dah kameh uduk aseken jo ai.” ");
INSERT INTO lid_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ano ja badeh ndrinen i tinan ja ma iy tuwi nah mwan, tondrohani nyaran badeh Simiyon. Eme iy anya, “Laban badeh anyolom Jekop baseken jo bwe, eme iy atehei tek nah ja dah.” ");
INSERT INTO lid_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ano ja badeh ndrinen i tinan ja, iy tuwi nah mwan ja ma tondrohani nyaran Lebi. Eme iy anya, “I dah kameh uduk kameh budon tan abadok tek, tasah jo badeh atehei nah mwan taloh i tan.” ");
INSERT INTO lid_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ano ja badeh ndrinen i tinan ja badeh iy tuwi nah mwan ari ja, eme iy tondrohani nyaran badeh, Juda. Eme iy anya, “Na len dah kameh jo kameh atudun Laban.” Ano badeh iy ano ta ato-ou nah. ");
INSERT INTO lid_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ano na len Rejel anyolom iy bato-ou nah nadu Jekop bwe badeh, eme madan alikis nadu tinen. Eme badeh iy tiye i ta Jekop, “Ou atehei nah ki ndrinek, bwe kameh jo imek ai!” ");
INSERT INTO lid_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Eme Jekop ibolosen i tan eme iy tiye, “Jo winiyan bakohok ndrahu Kindrei bwe, iy le badeh baramwekes ou barato-ou nah!” ");
INSERT INTO lid_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ano badeh Rejel anya, “I doh badih ta lahou tek Bilhah doh. Ou amadin iy ya iy kato-ou nah keme tek. Eme na iy le badeh lundriyek oro kasola.” ");
INSERT INTO lid_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","5","Eme iy atehei Bilhah badeh i nyara udu Jekop ma Jekop amadin iy, eme ma iy tuwi nah mwan. ");
INSERT INTO lid_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ano badeh Rejel tiye, “Kindrei badeh ndramwesekei sahou ma iy ndratehei seken tek; iy badeh anyolom tikisiy tek ma iy atehei tek nah mwan.” Eme nah doh badeh tondrohani nyaran badeh Dan. ");
INSERT INTO lid_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ano badih ta lahou ta Rejel ndrinen tinan ja ma iy tuwi nadu Jekop mwan ari ja. ");
INSERT INTO lid_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Eme Rejel anya, “Jo badeh amwekes lahou boto-on labai hawe nadu tine eme ma jo ndrasakalawi iy.” Eme iy tondrohani nyaran badeh Nabtali. ");
INSERT INTO lid_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Eme Liya anyolom iy badeh bato-ou nah bwe badeh, eme iy andrei badih ta lahou tan Silpah badeh atehei iy i ta Jekop i buku none udun. ");
INSERT INTO lid_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Eme Silpah tuwi nah nadu Jekop. ");
INSERT INTO lid_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Eme Liya badeh anya, “Jo ndramwe-es ai,” eme iy tondrohani nyaran Gat. ");
INSERT INTO lid_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ano Silpah badih ta lahou ta Liya tuwi nadu Jekop mwan ari ja. ");
INSERT INTO lid_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Eme iy tiye, “Jo badeh sekesek labai! I dah kameh iri badih kameh aloh jo, ‘Sekesek.’” Eme iy tondrohani nyaran Aser. ");
INSERT INTO lid_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Na len bwidiu wit uni badeh Ruben ili lokei badeh ndruni kei ta nah aloh mandrake, eme iy kuhiy eme atehei i mine tinen Liya. Eme Rejel eme iy anya, “Liya, nek rayah mandrake ta nadum keme.” ");
INSERT INTO lid_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Arile i tan badeh iy anya, “Ou mene ndrandrei uduk ka-i ai. Ya i dah kameh mandrake kewek la-un ale?” Eme Rejel tiye i buku doh, “I buku none ou atehei mandrake ta nadum, ou kameh amadin hawe Jekop na ben kameh.” ");
INSERT INTO lid_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Eme Jekop udu lokei eme na beyeh badeh, Liya ili aturuk iy, eme Liya tiye, “Jo badeh andrei mandrake ta naduk, atehei ndra na Rejel eme ya na ben kameh ou ame amadin jo.” Eme badeh iy ili badeh amadin iy na ben. ");
INSERT INTO lid_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Eme Kindrei anuhun Liya, eme Liya ndrinen i tinan ma iy atehei kuwim tan nadu Jekop. ");
INSERT INTO lid_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Eme Liya anya, “Jo badeh atehei badih ta lahou tek i ta uduk, eme Kindrei badeh atehei nah i sihinek.” Eme tondrohani nyaran badeh Isakar. ");
INSERT INTO lid_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ano badeh Liya ndrinen i tinan ja iy tuwi nadu Jekop ja So-on tan. ");
INSERT INTO lid_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ano Liya anya, “Kindrei badeh ndratehei tek lakou mwasin labai. Na dah kameh uduk kameh anyolom jo udu mwasin ta madan ai, ma iy kameh masiye jo, tasah jo badeh ndratuwi nah onoh ndra nadun.” Eme iy tondrohani nyaran badeh Sebulun. ");
INSERT INTO lid_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ano udu ja badeh iy tuwi badih ma tondrohani nyaran badeh Dinah. ");
INSERT INTO lid_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ano badeh Kindrei lomondrani Rejel; iy anuhun iy, eme iy mwesekei ndrom ta ato-ou nah ja amwe-es. ");
INSERT INTO lid_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Eme ma ndrinen i tinan ma iy tuwi mwan. Ano iy tiye, “Kindrei badeh ndramwesekei tikisiy tek badeh ndrano.” ");
INSERT INTO lid_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Eme iy tondrohani nyaran badeh Josep, ano ma iy tiye, “Jo aseken Kindrei kedeu tek rayah nah ja.” ");
INSERT INTO lid_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rejel atehei Josep eme len ano badeh Jekop tiye ta Leban, “Ou satawi jo, jo anya ki-iu ki kon tek. ");
INSERT INTO lid_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Jo mene amwekes lahou tam ta uduk uru ma la-uh ma oro nah. Ou atehei oro kame ma jo ki-iu ki len tam. Ou badeh tanam jo mwasin labai len jo amwekes lahou tam.” ");
INSERT INTO lid_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Arile Leban anya, “Ou badeh mwasin ta madak ya ou winiyan ba-au bwe. Ou ado. Jo badeh ndrada kau, Laban atehei nyosowan eme tek tasah na ou.” ");
INSERT INTO lid_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ano badeh iy tiye le, “Abo, sabe ou aseken jo kisih ou.” ");
INSERT INTO lid_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Eme badeh Jekop anya, “Ou tanam lahou jo amwekes, ma san jo atondrok iri katin haka tam udu mwasin labai. ");
INSERT INTO lid_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Lakou tam sola bwe len jo eme, arile na dah ndra sola, tasah Laban atehei minen udu la-um, tasah na jo; ma loboho heh jo edek i aliy. Arile na dah badeh jo anya kasilah lakou ta aseben asiu tek ai.” ");
INSERT INTO lid_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Eme iy lelen, “Jo katehei sasah tam?” Eme Jekop anya, “Ou sanyohan jo lakou. I buku none ou aseken tanan tek doh; jo badeh kameh atondrok katin haka tam ilih le: ");
INSERT INTO lid_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Jo kameh anyolom iri katin haka tam mari, ma jo kameh lebelei iri sipsip kasen bokodon ma hawe iri me busuwen are len. I doh sihinek ai. ");
INSERT INTO lid_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Eme ya i buku none len hamon ou kameh i tanam jo badeh ta wasai bwe, buku na ben ou anya ame adeu sihinek. I buku none ari me belen udu bolon tek ma hawe i buku none ari sipsip kasen bokodon udu bolon tek, badeh jo bene-ei tam ai.” ");
INSERT INTO lid_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Eme Leban anya, “Mwasin. Ki buku none bohom baden.” ");
INSERT INTO lid_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Arile na len doh le badeh Leban lebelei iri me mwan busuwen ma hawe iri me badih busuwen ma iri sipsip bokodon. Ano iy atehei nadun oro ta atondrok. ");
INSERT INTO lid_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ano badeh Leban atehei len taloh udu ndrokowan hawe Jekop ta adek. Ya Jekop badeh atondrok kati haka rayah ta Leban ai. ");
INSERT INTO lid_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ano badeh Jekop tatasei andra kei popola ma almon rayah ma kei badeh alim ku-i kei winiya belen asahan bada iri. ");
INSERT INTO lid_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Eme badeh tatahiy andra kei doh badeh udu bwena ta bwekei ta gwa tiri katin haka. Iy tatahiy udu doh, tasah iri katin haka amwekes mada bun tiri na len iri ame a-un gwa. Eme iri katin haka kanyolom badeh iri kales kala ka-un gwa. ");
INSERT INTO lid_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ya i buku none iri me amwekes mada bun tiri are bwena ta kei dah, i dah kameh iri adeu nah bokodon hawe nah busuwen. ");
INSERT INTO lid_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ano badeh Jekop lebelei iri sipsip badeh are len labai ta me, ya batala iri badeh ili tiri katin haka busuwen ta Leban. Eme san doh badeh iri katin haka tan bala bolon ta Leban bwe. ");
INSERT INTO lid_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","I buku none iri katin haka boto-on mada bun tiri asahan badeh, Jekop tatahiy andra kei udu bwena ta bwekei ta gwa tiri katin haka eme iri ame amunyau ma iri amwekes mada bun tiri. ");
INSERT INTO lid_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Arile iri katin haka boto-on bwe badeh iy batehei iri bala aliy bwe. Eme badeh iri katin haka boto-on bwe baden eh a hawe Leban ai, ya boto-on badeh a hawe Jekop ai. ");
INSERT INTO lid_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","I san le doh badeh Jekop asahan ndramak tan lakou solo-an labai. Tan badeh iri katin haka solo-an, ma iri lau tan ta lahou solo-an ma hawe iri kamel hawe donki solo-an ado aliy. ");
INSERT INTO lid_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ano badeh Jekop eme anuhun nadu Leban oro asehek anya, “Jekop badeh tan lakou sola kede-eh badeh ta lakou ta tama to le.” ");
INSERT INTO lid_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Eme Jekop eme badeh atona kandriyen ta Leban bala buku none mwena mene bwe. ");
INSERT INTO lid_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ano Laban Kindrei tiye ta Jekop, “Ou au a hamon ala munyak ta tamam oro ma ala hawe lowam oro, ya jo kameh madak udu tam.” ");
INSERT INTO lid_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Eme iy suni sahou i ta Rejel uru Liya ame hawen ame lobwidiu hawe katin haka udu hawen dah. ");
INSERT INTO lid_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Eme iy tiye i turu, “Jo anyolom kandriyen ta tama ah amwekes eme tek bala buku none bwena mene bwe, arile Kindrei ta tama badeh udu hawek. ");
INSERT INTO lid_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ah tana ah, jo badeh amwekes lahou ta tama ah boto-on labai, ");
INSERT INTO lid_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","arile tama ah badeh mwesekei wasai san ronoh ta anya kisih jo; eme Kindrei badeh bamwesekei lomondra ta amwekes isi eme tek bwe. ");
INSERT INTO lid_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","I buku none iy katiye, ‘Iri me busuwen badeh sihinem, badeh kameh ma iri katin haka ala bada iri busuwen kameh tam le.’ Ma buku none iy katiye, ‘Iri me torowanan badeh sihinem, badeh kameh ma iri katin haka ala ato-ou bada iri torowanan badeh kameh tam le.’ Oro kasen ala busuwen badeh tek ai. ");
INSERT INTO lid_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Eme badeh Kindrei badeh kuhi katin haka ta tamam oro badeh atehei eme tek. ");
INSERT INTO lid_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Na mada bun tiri katin haka ta adeu nah badeh jo ameh. Jo ameh iri me mwan badeh amwekes mada bun hawe iri katin haka torowanan ma hawe busuwen. ");
INSERT INTO lid_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","I doh badeh angelo ta Kindrei tiye na ameh, anya, ‘Jekop.’ Eme jo anya, ‘Jo kada-ah.’ ");
INSERT INTO lid_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Eme iy tiye, ‘Ou anyolom ki loke tiri me mwan amwekes mada bun hawe iri katin haka torowanan busuwen kede-eh. Jo le badeh amwekes kandriyen doh, tasah jo badeh ndranyolom kandriyen mari Leban amwekes ewek badam. ");
INSERT INTO lid_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Jo dah badeh jo Kindrei mene asahan hawem udu Betel, eme ou mene tutuni bek i loke i buku none kalem ta abudon jo ma ou mene mwitiniy ndrelekei ta olip i bwele-en ma ou tandrakan eme tek. Na len dah badeh ou ruwani kon dah ya ou au ala munyak tam amwenen.’” ");
INSERT INTO lid_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ano Rejel uru Liya tiye, “Aru kameh winiyan bakohok munyak ta tama aru bwe ai. ");
INSERT INTO lid_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Iy badeh amwekes aru i buku none lau badu leheleh. Iy atehei aru a ta sisih ma iy ale ndrani sihine aru, mene ndrano. ");
INSERT INTO lid_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Handru labai lakou mari Kindrei kuhiy udu hawe tama aru badeh taru ma hawe lundriye aru oro. Ou an hamon ta sasah Kindrei asehek tam badeh.” ");
INSERT INTO lid_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ano Jekop eme, nyahani nadun ma udun uru ala manyah ado bwele-e kamel, ");
INSERT INTO lid_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","eme iy edek iu sariye iri katin haka tan i bwena tan, ma hawe lakou tan mari badu Padan Aram, edek iu ili hawe taman Aisik ili munyak Kenan. ");
INSERT INTO lid_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ya Leban badeh ndra-au, ndrasan lami iri sipsip, eme badeh Rejel ili badeh bene-ei ndramak, (asehek na sukumada kei) ta taman dah. ");
INSERT INTO lid_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ma ale Jekop badeh batiye tanan ta Leban badu Aram ta oro nane atobwak doh bwe. ");
INSERT INTO lid_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Eme iy atobwak ma hawe lakou tan mari ili gwa i bilisiu ili loboho mandrei badu munyak Gileyat. ");
INSERT INTO lid_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Udu len la-uh iu, ano i bada len taloh badeh lau tandra-un ta Leban, ta Jekop badeh ndratobwak. ");
INSERT INTO lid_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Eme iy kuhi lowan oro a hawen, eme oro sakaniy an hamon toro, eme na len ndro taloh oro ala badeh tawi oro ado munyak Gileyat. ");
INSERT INTO lid_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ano badeh Kindrei asahan ta Leban badu Aram na ameh tiye i tan i buku doh, “Balem kudu tam kamwe-es, ou badeh sandres oro.” ");
INSERT INTO lid_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jekop badeh tahi asiu balei tan badeh udu bolo mandrei Gileyat, amwenen le na len Leban oro lowan ala asos ma oro amadin doh ale. ");
INSERT INTO lid_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ano Leban tiye i ta Jekop, “Ou amwekes sasah dah? Ou badeh ndrawendreyani jo, eme ou tuwi naduk uru i buku none lau ta ateu ta bahun. ");
INSERT INTO lid_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","I buku sah ou aton le ma ou wendreya le ma ou atobwak? I buku sah ou batandra-un tek bwe. Eme ya ou au ma sekesek ma wari ma ada ndran? ");
INSERT INTO lid_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ou badeh ale batehei jo babose se nadu tubu oro ma hawe naduk uru bwe. Ou amwekes kandriyen dah bamwenen bwe. ");
INSERT INTO lid_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Jo badeh jo tek boto-on udu aliy ta amwekes maha ma isi ewek tam; arile na ben badeh Kindrei ta tamam badeh tiye tek, ta jo badeh balek kudu tek kamwe-es, jo badeh sasehek sahou ndra-in o sahou mwasin sawek tam ndri-i labai! ");
INSERT INTO lid_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Jo tanan ou badeh koham ndrapwe ta ala kon tam, arile ou badeh ndrabene-ei sukumada kei badu asiu tek.” ");
INSERT INTO lid_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Eme Jekop anya, “Jo badeh inoh, jo anya koro-an ou ka tawi nadum uru kado. ");
INSERT INTO lid_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Arile i buku none ou silahei are andrei sukumada kei tam badeh iy kimek, ma udu mada lowa talu oro badeh, ou anyolom i buku none ari lakou tam udu bolon tek handru, badeh ou andrei kewek hamon.” Arile Jekop badeh tanan bwe, Rejel badeh andrei sukumada kei nane doh. ");
INSERT INTO lid_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Eme badeh Leban asilah bolo asiu balei ta Jekop ano iy i bolon ta Liya ano badeh iy i bolon turu badih ta lahou dah, eme badeh iy batakalei ari lakou bwe. Iy udu asiu balei ta Liya eme len ano iy i bolon ta Rejel. ");
INSERT INTO lid_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rejel badeh andrei sukumada kei badu asiu ta taman badeh, tonei udu baha ndrahu manyah ta udu bwele-e kamel udu bada munyak ma iy manyah udu la-un. Leban badeh silahei bolo asiu balei mari arile iy batakalei ari lakou bwe. ");
INSERT INTO lid_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Eme Rejel tiye i ta taman, “Tama, ou sabolosen, jo badeh winiyan bales bare loken bwe; mada bun tek ndrasahan.” Eme iy asilah sukumada kei ta asiu tan, arile iy batakahei bwe. ");
INSERT INTO lid_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Eme Jekop i bolosen, Anya, “Sasah jo mwesekei andra-i dah? Saba kandriyen jo mwesekei ya ou ame atikah jo dah? ");
INSERT INTO lid_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Na dah ou badeh ndratakalahei bolo lakou tek mari. Ou silahei sasah badu asiu tam jo andrei? Abo, ou atehei keme manan ya lau tam ma lau tek kanyolom, are mwasin. ");
INSERT INTO lid_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Jo badeh udu hawem jaha lunoh ai, arile iri sipsip ma me tam badeh baruwe ta ato-ou nah bwe, ma jo badeh baimon ari katin haka tam bwe. ");
INSERT INTO lid_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Iri katin haka ndriliu aimon katin haka tam, arile jo bandrei bawek hawem bwe; jo le atehei saluwen. Arile ou badeh andrekei sihinen udu minek ewek na ben na len, buku none amai. ");
INSERT INTO lid_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Jo badeh an suluwmi jo na len ma nyala iniy jo na ben, ma jo bakohok matinou bamwenen bwe, ");
INSERT INTO lid_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","udu le buku doh winiya jaha ma lunoh jo udu asiu tam. Jo badeh amwekes lahou tam ta akohok nadum badih uru jaha ma ronoh hahuw, ano jaha onoh ta katin haka tam. Arile ou wendreyani jo ta adeu sihinek san ronoh. ");
INSERT INTO lid_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ki buku none Kindrei ta tama, Kindrei ta Abraham ma Aisik bare hawek bwe; i dah nane ou suni jo ki-iu na ari minek ma katik le. Arile Kindrei badeh atou maha ma isi udu tek ma lahou tinan jo mwesekei, eme na ben mene ou atou losen tan.” ");
INSERT INTO lid_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Eme Leban anya, “Uru badih kede-eh naduk, oro nah kede-eh badeh naduk ma hawe oro katin haka kede-eh tek. Lakou mari udu mada kede-eh tek le ai. Ya sasah na dah jo kamwekes ki bada naduk uru hawe nadu naduk oro?” ");
INSERT INTO lid_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ano Leban tiye, “Talu kamwekes sahou randra le, ki buku none kalem ta ndrokowa talu.” ");
INSERT INTO lid_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Eme badeh Jekop tutuni bek i loken i buku none kei ales. ");
INSERT INTO lid_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ano iy tiye i ta lowan oro, “Ado katukumwi rayah bek.” Eme oro tukumwi bek i se ano badeh oro aimon nyamon ado mirihik ta aliy. ");
INSERT INTO lid_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Eme Leban tondrohaniy kon doh Jegar Sahaduta, moson, “Bek ta tandrakan” i boho kon Aram, hawe Jekop tondrahani Galit, i boho kon Hiburu moson i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ano badeh Leban tiye, “Bek tukumwi dah i nyara kalem udu ndrokowak hawe ndrokowam na dah.” Tasah badeh aloh Galit. ");
INSERT INTO lid_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","I doh badeh aloh ale Mispah, moson, “Bokok,” tasah iy anya, “Laban Kindrei badeh madan kudu tam ma kudu tek len talu banyolom talu bwe. ");
INSERT INTO lid_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","I buku none ou batondrok naduk uru bala mwasin bwe, ya i buku none ou asoh badih ari ja, ya lau bare hawe talu banyolom bwe, arile Kindrei le baranyolom talu ma baradeu talu barala ta sahou.” ");
INSERT INTO lid_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ano badeh Leban tiye i ta Jekop le, “Bek tukumwi doh ma bek tutuni doh badeh jo mwesekei badeh ta ndrokowa talu. ");
INSERT INTO lid_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Tukumwi bek ma tutuniy bek doh badeh kalem ta tandrakan ta talu. Ta jo winiyan basakalawi bek tukumwi kede-eh bawek bilisiu ta amwekes isi bwe ai, ma ou ale sasakalawi bek tukumwiy ma bek tutuniy same bilisiu samwekes isi same tek. ");
INSERT INTO lid_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Winiya le Kindrei ta Abraham, ta Nahor, ma Kindrei ta tamam oro badeh baranuhun talu.” Eme Jekop tandrakan i ta nyara Kindrei ta taman Aisik. ");
INSERT INTO lid_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Eme iy amwekes salom i bada bek udu mandrei ma tiye iri lowan aimon nyamon. Oro aimon ano badeh oro amadin ben ari. ");
INSERT INTO lid_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Na mandraben badeh Leban atamas ma sekesek nadu tubun oro ma hawe nadun uru ma edeu nyosowan i toro. Ano badeh iy iu i hamon ja i kon tan. ");
INSERT INTO lid_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jekop ale suri iy ma iy iu, eme badeh angelo ta Kindrei eme asahan hawen. ");
INSERT INTO lid_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jekop anyolom oro badeh iy tiye, “I dah badeh ndrahu Kindrei!” Eme ma iy tondrohaniy badeh Mahana-em, moson, “Oro lumuk.” ");
INSERT INTO lid_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Eme Jekop eme badeh suni lau tan rayah ala bwena hawe nadu tinen Iso udu munyak Se-ir udu kon tinan Idom. ");
INSERT INTO lid_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Eme iy tiye i toro, “Ado katiye sahou ki ta Iso ki buku doh: ‘Jo badeh Jekop. Jo ndramak ta lahou tam. Jo badeh udu hawe Leban amwekes lahou tan eme taku len dah. ");
INSERT INTO lid_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Jo badeh tek iri bulumakau udu aliy, iri donki udu aliy, iri sipsip udu aliy, iri me udu aliy ma hawe lau mwan ma badih ta lahou tek ale udu aliy. Eme jo atiye sahou doh ewek tam, ta ou aseken jo de bwe.’” ");
INSERT INTO lid_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ano oro lau ta tiye sahou ame hamon badeh tiye ta Jekop i buku doh, “Aso ala nadu tinem Iso tiye; iy badeh eme ta atou ou, ma lau tan ma hanek (400) ado hawen ame.” ");
INSERT INTO lid_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jekop eme badeh iy inoh andra-i, eme badeh iy apwai lau ma katin haka sipsip, bulumakau ma hawe kamel tan i lumuk. ");
INSERT INTO lid_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Iy abudon badeh i buku doh, “I buku none iy amwekes bahun i la-u oro rabuk eh, badeh oro rabuk katobwak ai.” ");
INSERT INTO lid_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ano badeh Jekop amwekes salom i buku doh: “O Kindrei ta tama Abraham ma Kindrei ta tama Aisik, ou Laban ou tiye eme tek anya, jo badeh ki-iu ki hamon kili kon tinan ta lowak oro ma ou kameh adeu lundriyek oro a sola. ");
INSERT INTO lid_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Jo badeh bamwenen ta kandriyen mwasin tam bwe ma ba-en hamon tam i buku none ou leheya ndramak ta lahou tam bwe. Jo mene andrei le kandro tek len aso mene ame bilisiu ta gwa Jordan. Arile na dah jo ndra lumuk. ");
INSERT INTO lid_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Jo badeh inoh, jo amwekes salom, ou sebenei jo ta mine nadu tine Iso eme, koro-an iy kamwekes bahun keme tek ma oro nah ma hawe tine oro. ");
INSERT INTO lid_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Arile ou badeh ndratiye, ou kameh adeu kanek ma ou kameh adeu lundriyek oro kameh nyaran bwe, i buku none on badu babi, winiya are lau winiyan bandromwoi bwe.” ");
INSERT INTO lid_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Eme iy amadin ben ari eme badeh iy atehei lakou ta adeu i ta nadu tinen Iso: ");
INSERT INTO lid_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","iy atehei lunek (200) me badih, lunoh me mwan, lunek (200) sipsip badih ma lunoh mwan, ");
INSERT INTO lid_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","iy atehei tonoh kamel badih ma hawe rayah kasen, atehei hanoh bulumakau badih ma ronoh bulumakau mwan ano lunoh donki badih ma ronoh donki mwan. ");
INSERT INTO lid_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Iy apwai oro katin haka, rabuk are doh, rabuk are doh. Ano iy weleyani oro lau ta lahou tan atondrok, eme iy ari atondrok rabuk, iy ari atondrok rabuk, i le buku doh. Eme iy tiye i toro, “Ado kadek kabwena tek ya ndrokowa to sese udu aliy tiri katin haka.” ");
INSERT INTO lid_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Eme iy tiye ta ndramak badu bwena: “Ya i buku none nadu tine Iso kandruni ado, ya i buku none iy kandremenya ado, ‘Ado lau tare ame dah ya ado ado heh ame dah? ma katin haka mari ado bwena kede-eh tare?’ ");
INSERT INTO lid_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Eme ado katiye ki buku doh, ‘Oro badeh ta ndramak ta lahou tam Jekop. Oro doh tam ai. Ya Jekop badeh in hamon taso eme.’” ");
INSERT INTO lid_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ano iy ale tiye oro nane are hamon toro badu mwena ma hawe oro badu hamon tiri katin haka dah: ");
INSERT INTO lid_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","“Ma ado samaniy ta tiye, ‘Jekop in hamon eme.’” Jekop badeh abudon, “Jo kameh tamarei iy na lakou ki tan ma iy kameh mani kandriyen jo mene amwekes, i buku none jo ndruni iy.” ");
INSERT INTO lid_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Eme iri lakou ta anyohan Iso na aliy badeh in mwena ili. Ya Jekop udu amadin ben ari. ");
INSERT INTO lid_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ano na ben doh badeh Jekop suri iy, eme iy kuhi udun ma la-uh, kuhi uru badih ma la-uh ta lahou tan ma hawe nadun oro ma ronoh ari mwan badeh, oro adek ala bilisiu ala gwa Jabok. ");
INSERT INTO lid_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Iy tiyani oro a bilisiu ta gwa ano badeh iy tiyani iri lakou tan mari i bilisiu ale. ");
INSERT INTO lid_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jekop le ari badeh in hamon, eme badeh ndramak ari ili badeh uru akek, uru akek winiya le kon aleu. ");
INSERT INTO lid_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Eme ndramak dah atona boto-on tan anya kano le badeh, iy atehei minen i ba Jekop le badeh, ma ban asoh. ");
INSERT INTO lid_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ano iy ndramak dan anya, “Jo ki-iu ai, kon ndra leu.” Arile Jekop anya, “Jo winiyan baruwani ou ba-au bwe, ndra ou atehei nyosowan eme tek.” ");
INSERT INTO lid_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Eme ndramak dah ndremenya iy, “Nyaram areh?” Eme iy anya, “Nyarak Jekop.” ");
INSERT INTO lid_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ano badeh ndramak dan anya, “Nyaram kameh bala Jekop ja bwe ai, nyaram kameh aloh Isra-el, tasah ou badeh boto-on labai ta akek i la-u Kindrei hawe iri ndramak.” ");
INSERT INTO lid_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Eme Jekop anya, “Abo, ou tiye nyaram keme tek.” Arile iy anya, “Ou anya atanam nyarak ta sasah?” Ano badeh iy atehei nyosowan i la-un udu doh. ");
INSERT INTO lid_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Eme badeh Jekop tondrohani nyara kon Peniyel, moson “Mada Kindrei.” Eme iy anya, “Jo badeh anyolom Kindrei udu madak amwenen arile jo bamak bwe.” ");
INSERT INTO lid_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","An eme loken badeh iy udu Peniyel iu ma soka le, tasah ta ban. ");
INSERT INTO lid_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Eme ta katin doh badeh iri lundriye iri Isra-el badeh baimon ndrubulo katin haka bwe, tasah Jekop badeh edek andra-i na ban. ");
INSERT INTO lid_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jekop anyolom ili badeh iy atou Iso hawe lau tan ma hanek (400) badeh adek ame; eme iy eme andromwoi oro nah i le winiya Liya uru Rejel hawe uru badih turu ta lahou turu. ");
INSERT INTO lid_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Eme iy atehei nadun oro rayah ado hawe uru badih ta lahou tan ma la-uh ado bwena. Ano badeh Liya hawe oro nah rayah are hamon toro ano badeh udu hamon toro badeh iy atehei Rejel uru Josep ado hamon. ");
INSERT INTO lid_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jekop le udu bwena, eme iy aluh i andri bada munyak san ndro taloh udu mada Iso. ");
INSERT INTO lid_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Arile Iso sakaliye ili badeh tawi Jekop ma atamas iy, eme ma uru aden. ");
INSERT INTO lid_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ano mada Iso i loke badeh anyolom badih hawe iri nah. Eme iy ndremenya, “Are oro are hamon ame dah?” Eme Jekop anya, “Oro doh badeh Kindrei tikisiy jo eme iy atehei eme tek.” ");
INSERT INTO lid_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ano badeh uru badih ta lahou ma hawe nadu oro ame mirihik ma oro aluh a andri. ");
INSERT INTO lid_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ano ja Liya hawe nadun oro ame ja aluh a andri ale. Ano udu hamon handru badeh Rejel uru nadun Josep am ma uru ale aluh a andri. ");
INSERT INTO lid_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Eme badeh Iso ndremenya, “Oro lau jo ndrondron oro mene, moson i buku sah?” Eme badeh Jekop anya, “Badeh ta anya kanuhun ou sekesek tek de bwe.” ");
INSERT INTO lid_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Arile Iso tiye, “Nadu tine, jo badeh lakou tek solo-an labai udu aliy. Kudu gwek tam ai.” ");
INSERT INTO lid_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Arile Jekop tiye, “Bwe ai, i buku none ou ndraseken jo badeh, ou andrei. Jo badeh sekesek ta atou madam badeh i buku none jo sekesek ta atou Kindrei, ou badeh amwekes kandriyen mwasin ma ou ndraseken. ");
INSERT INTO lid_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Abo, ou andrei lakou tek jo andrei eme hawem dah; Kindrei badeh tikisiy jo labai, eme iy badeh atehei lakou mari dah eme tek.” Jekop eme andresei iy, andresei iy ma iy andrei. ");
INSERT INTO lid_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ano Iso tiye, “Jo ki hawem ma talu ma la-uh ka-au.” ");
INSERT INTO lid_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Eme Jekop tiye, “Ou tanam oro nah badeh babadok bwe le, eme ya jo badeh katondrok iri sipsip hawe iri bulumakau ma nadu iri bwisik. Ya ki buku none iri adek na len ari buruwen kameh ma iri kamak. ");
INSERT INTO lid_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Abo, ou adek a bwena tek, ya jo badeh kedek kamunum ki-in hamon. Jo kameh edek amunum hawe oro bulumakau ma hawe oro nah, winiya le jo le barateu ado barado Se-ir.” ");
INSERT INTO lid_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Eme Iso anya, “Abo, lau tek rayah kado hawem kado.” Eme Jekop anya, “Ou anya amwekes badeh ta sasah? I doh nane jo anya kanuhun le seken tam.” ");
INSERT INTO lid_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Eme na len doh le badeh Iso, iu ili Se-ir. ");
INSERT INTO lid_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Arile Jekop badeh ili Sukot ma iy tahi asiu tan hawe tahi mandron rayah tiri katin haka tan. Eme nyara kon Sukot badeh, moson, “Mandron,” badeh asahan kabatana doh. ");
INSERT INTO lid_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jekop udu Padan Aram, eme asahan mwasin le eme kon tinan Sekem udu Kenan, eme atehei ndrahu manyah tan udu rai mirihik ta kon tinan. ");
INSERT INTO lid_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Iy sihinei munyak doh badeh ta lundriye Hamor, tama Sekem na su-ubek kanen i winiya rinek silba boroh. ");
INSERT INTO lid_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ano iy tukumwi bek ta salom ma aloh “El Elohe Isra-el,” moson, “Kindrei tahi Isra-el.” ");
INSERT INTO lid_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Liya badeh atehei nah ari badih nyaran Dinah nadu Jekop. Eme iy ili badeh manyah hawe iri badih badu munyak doh. ");
INSERT INTO lid_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Eme badeh nadu Hamor nyaran Sekem badeh badu Hiba, iy atondrok loboho doh, eme badeh iy anyolom Dinah badeh iy mwesekei karei i tan. ");
INSERT INTO lid_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Iy ibis nadu Jekop Dinah labai, eme badeh iy atamar ma indrek iy kaseken iy. ");
INSERT INTO lid_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Eme Sekem tiye ta taman, “Tama ou andrei badih bihin kodo-oh keme uduk.” ");
INSERT INTO lid_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nadu Jekop oro mwan badeh ado ndra lobwidiu atondrok iri katin haka, eme Jekop anuhun nadun badih badeh lau ndratawi iy. Eme iy bamwekes ari lakou bwe winiya le nadun oro ame. ");
INSERT INTO lid_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Eme tama Sekem badeh ili hawe Jekop asehek sahou hawen. ");
INSERT INTO lid_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Eme nadu Jekop oro badeh barado lobwidiu barame ai. Eme oro anuhun nyala karei le badeh, boho oro asak ma ndrine oro isi labai. Tasah Sekem badeh mwesekei kandriyen ndra-in ma bobose iri Isra-el handru ta iy tawi Dinah nadu Jekop badih, lakou ndrabun handru ta amwekes. ");
INSERT INTO lid_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Arile Hamor tiye i toro, “Naduk, Sekem badeh ndrinen eden ta nadu ado badih labai. Ado katehei iy keme ma iy ki udu naduk. ");
INSERT INTO lid_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","To kasehek sahou ki randra ta to badeh kasoh to kili keme kudu ndrokowa to. ");
INSERT INTO lid_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Eme ya ado kado hawe aso kado munyak dah kado; ado badeh kamanyah loboho heh seken tado udu aliy ma ado badeh kamwekes sasah ki tado ma ado katiye lakou tado ta sisih kili keme.” ");
INSERT INTO lid_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ano Sekem tiye i ta tama Dinah hawe nadu tinen oro, “Ado aseken sasah le, eme sasah ado aseken jo kedeu kewek tado. ");
INSERT INTO lid_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ado katiye sasah ado aseken ma ado kadeu masah ta nadu ado ki loken jo winiyan atehei. Buku none ado katehei badih kede-eh keme uduk.” ");
INSERT INTO lid_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tasah nadu oro Dinah badeh badan ndrandra-i, eme badeh nadu Jekop oro abukoh no-o Sekem uru taman le. ");
INSERT INTO lid_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Eme oro tiye i turu, “Aso winiyan basumon bwe ai, aso winiyan bamwekes kandriyen dah bwe; Aso winiyan batehei nadu tine aso badih winiyan bala tare ku-i lakou tan ba-au bwe. ");
INSERT INTO lid_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Aso badeh aseken le i buku none iri nah mwan tam kasan ku-i iri ki-iu ki buku taso. ");
INSERT INTO lid_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ano badeh aso baradeu nadu aso badih barawek ma tado barame taso. Ma aso kameh ado manyah hawe ado ma to asahan ari buruwen. ");
INSERT INTO lid_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","I buku none ou baseken budon taso bwe, i dah kameh aso au ma hawe nadu tine aso badih.” ");
INSERT INTO lid_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","19","Tanan toro badeh mwasin ta ndranye Hamor uru nadun Sekem. Sekem badeh iy kadok, eme iy babe-en ta amwekes budon nane bwe ai, tasah iy badeh ndraseken nadu Jekop badih labai ai. ");
INSERT INTO lid_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Eme badeh Hamor hawe nadun Sekem badeh uru adek ala loboho mada san ta i bolo kon tinan turu ma tiye i tiri lau badu kon doh. ");
INSERT INTO lid_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Eme uru tiye, “Oro lau kede-eh kawas mwasin tato. Oro kamanyah kado munyak tato ma oro katiye sasah ki ta asih; munyak kada-ah winiya oro mari. To badeh winiyan asoh nadu oro badih ma oro ale, winiyan asoh tato. ");
INSERT INTO lid_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","I buku none to kasan ku-i lakou ta mwan ki-iu i le buku toro eh, i dah kameh oro kameh ado ma to kameh asahan ari buruwen. I buku none bwe eh, oro kameh au. ");
INSERT INTO lid_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","I dah kameh iri katin haka toro ma hawe lakou mari toro kameh i tato. Eme to katiye mwasin, oro sa-au oro kado hawe to kado.” ");
INSERT INTO lid_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Eme iri lau mari badu kon doh badeh aseken budon ta Hamor uru nadun Sekem, eme iri sani ku-i lakou tiri mwan iu. ");
INSERT INTO lid_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ano badeh len taloh ano, oro lau badeh ndrana toro mene ta baka sasan bano bwe le. Nadu Jekop ma hawe nadu tine Dinah, Simiyon uru Lebi badeh banoh bwe, uru ma samen ta bahun turu ala kon tinan badeh mwetehei iri lau mwan mari, ");
INSERT INTO lid_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ma hawe Hamor uru nadun Sekem ale. Ano badeh uru aluwi Dinah udu asiu ta Sekem eme andri ma uru au. ");
INSERT INTO lid_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ano udu hamon turu nadu Jekop oro mari ala kon tinan mene tawi Dinah udu aliy, oro ala badeh adek bwele-e lau amak ma bene-ei lakou mari, tasah ta kandriyen ndra-in ta karei i bada Dinah. ");
INSERT INTO lid_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Eme oro ala andrei iri katin haka sipsip, ma donki ma hawe lakou mari udu kon tinan doh. ");
INSERT INTO lid_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Eme oro kuhi lakou mwasin toro mari ma tawi badih ma nah hawe tuwi lakou mari badu asiu. ");
INSERT INTO lid_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ano badeh Jekop tiye i ta Simiyon uru Lebi, “Ah badeh ndramwesekei nono-ou ndrame tek; eme iri lau badu Kenan hawe badu Perisa ma lau mari badu munyak dah kameh mada iri andra-i eme tek. Jo badeh lau sola bwe; i buku none iri mari kase kame kamwekes bahun keme la-uk kameh, to mari kameh amak.” ");
INSERT INTO lid_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Arile oro anya, “Aso bwale aso iri amwekes nadu tine aso i buku none badih ta mada san.” ");
INSERT INTO lid_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ano badeh Kindrei tiye ta Jekop, “Ou au ala atah asiu ma atukum bek ki loke ta salom ki ta Kindrei kudu Betel. Iy mene asahan hawem len ou mene atobwak ta nadu tinem Iso ma ou manyah ado aliy.” ");
INSERT INTO lid_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ano Jekop eme badeh tiye nadun hawe udun ma hawe iri lau are hawen dah anya, “Ado kakahei iri kindrei badu leheleh tado ki-iu; Ya ado katubuni lomondra tado ma ado kasin iri kolau ha-un: ");
INSERT INTO lid_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ano ado kame to ka-au kala Betel ma jo katukum bek ta salom ki ta Kindrei. Ta iy mene aseben jo len jo mene udu ndra-in ma jo edek i heh badeh madan udu le tek.” ");
INSERT INTO lid_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Eme badeh iri mari andrei kindrei tiri mene badu leheleh i mine Jekop ma hawe buwadin ta ndranye iri ili, ma Jekop kuhiy ma ihiy udu baha kei aloh o-uk mirihik ta kon Sekem. ");
INSERT INTO lid_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ano len Jekop oro nadun suri oro au badeh nohonoh i la-u iri lau mari badu kon mirihik ta kon tinan nane, eme iri badai oro bwe. ");
INSERT INTO lid_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Eme Jekop ma hawe iri lau tan mari badeh ame asos Lus, na dah aloh badeh Betel udu munyak Kenan. ");
INSERT INTO lid_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Eme iy tutuni bek ta salom eme tondrohani kon doh in hamon ta nyara Kindrei badu El Betel, tasah Kindrei mene asahan madan len iy mene atobwak ta nadu tinen Iso. ");
INSERT INTO lid_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ma badih ta tondrok ta Rebeka nyaran Debora badeh imek, eme ahi iy badeh udu loboho kum ta Betel baha kei o-uk. Ma tondrohani loboho doh badeh, Alon Bakut, “Kei o-uk ndrahu ndrelen.” ");
INSERT INTO lid_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ano len Jekop udu Padan Aram eme hamon badeh, Kindrei asahan hawen ja ma atehei nyosowan i la-un. ");
INSERT INTO lid_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Eme badeh Kindrei tiye i tan, “Ou badeh nyaram Jekop, arile i dah kameh baloh ou Jekop bwe ai, na dah kameh aloh nyaram Isra-el.” ");
INSERT INTO lid_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Eme badeh Kindrei tiye i tan, “Jo dah jo Kindrei, jo tek boto-on labai. Ou badeh amwekes nah ma sola. Iri nah badu kon munyak tinan kasahan ta lau tam, ma ou badeh tama iri kabin na len hamon kameh asahan. ");
INSERT INTO lid_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Jo kameh edeu munyak mene jo edeu i ta Abraham uru Aisik kameh ewek tam, ma jo kameh edeu ale i ta lundriyem ame.” ");
INSERT INTO lid_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ano Kindrei ruwani iy ma iy iu ai. ");
INSERT INTO lid_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ano udu kon nane Kindrei asehek sahou hawen nane, Jekop tutuni bek toka udu loken ta budon tan samaniy. Ano iy solowei gwa i la-un; ma solowei ndrelekei ta olip i la-un ta salom. ");
INSERT INTO lid_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Eme iy tondrohani nyara kon doh Betel. ");
INSERT INTO lid_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ano Jekop oro ruwani Betel ma oro au. Eme oro bala mirihik ta Eprat bwe le badeh, Rejel atona iy anya kedeu nadun ma iy akohok andra-i handru ta isi. ");
INSERT INTO lid_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Eme isi ta adeu nah amaha badeh iri badih ta lahou ta nah tiye i tan, “I dah nah mwan ja, Rejel; ou sanoh.” ");
INSERT INTO lid_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Arile bwe ai, iy anya kimek, eme kohan anya kano le badeh iy tondrohani nyaran Benoni, moson “Naduk ta tikisiy.” Arile udu ja, taman tondrohani nyaran ja Benjamin, moson “Naduk ta anyo-ou jo.” ");
INSERT INTO lid_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Eme badeh ahi iy udu ka-u san ta kon Eprat na len dah aloh Betelehem. ");
INSERT INTO lid_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Eme Jekop tutuni bek i loken ta abudon udun udu aliy, eme na dah udu aliy le. ");
INSERT INTO lid_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ano Jekop edek ili le badeh ma manyah udu loboho bilisiu ta bokok Eder. ");
INSERT INTO lid_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isra-el oro manyah ado doh le, eme badeh nadun Ruben ili amadin hawe Bilhah, badih ta taman Isra-el ta nyeu. Eme Isra-el eme anuhun nyala aliy. Jekop badeh nadun ma ronoh la-uh. ");
INSERT INTO lid_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Nadu Liya oro mwan kadok badeh Ruben, ano Simiyon, ano Lebi, ano Juda, ano Isakar hawe Sebulun. ");
INSERT INTO lid_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ya Nadu Rejel oro badeh Josep uru le Benjamin. ");
INSERT INTO lid_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ya nadu bonyo-ou ta Rejel Bilhah badeh Dan hawe Naptali. ");
INSERT INTO lid_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ano nadu bonyo-ou ta Liya Silpah badeh Gat hawe Aser. Oro mari doh badeh nadu Isra-el adeu oro are Padan Aram. ");
INSERT INTO lid_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ano Jekop ili hawe Taman Aisik ili Mamre mirihik ta Kiriyat Arba, loboho mene Abraham uru Aisik manyah are aliy. ");
INSERT INTO lid_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Aisik badeh udu winiya jaha rinek ndru lunoh (180) ma iy imek mwasin le ari isi bwe ili hawe tubun oro. Eme badeh nadun uru Iso hawe Jekop ahi iy. ");
INSERT INTO lid_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","I dah nyala lundriye Iso oro nyaran ari ja aloh Idom. ");
INSERT INTO lid_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso badeh Sudi badih ari badu Kenan nyaran Adah: Adah badih i ndrine Elon badu Hita, ma udu Iso Oholibamah badeh i ndrine Anah ma Anah bu-un badeh Sibiyon badu Hiba; ");
INSERT INTO lid_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ya Iso ale badeh sudi Basemat ya Basemat badeh nadu tine Nebayot. Uru mala-uh badeh nadu Isma-el. ");
INSERT INTO lid_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Eme Adah badeh atehei Elipas; ano Basemat atehei Reu-el; ");
INSERT INTO lid_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ano Oholibamah atehei Je-us, Jalam hawe Korah. Oro mari doh badeh adek ndrine Iso le ari, ma adeu oro ado Kenan. ");
INSERT INTO lid_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ano badeh Iso ma nadun oro mari ma hawe udun ma katin haka tan mari hawe lakou tan mari udu Kenan badeh oro suri oro ame len ta nadu tinen Jekop ala munyak ari ja. ");
INSERT INTO lid_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Iy iu badeh, tasah munyak nane uru nadu tinen Jekop ado aliy doh nane winiya uru bwe; uru badeh turu katin haka solo-an labai. ");
INSERT INTO lid_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Eme Iso ala aloh Idom badeh manyah udu bolo mandrei ndrokowa Se-ir. ");
INSERT INTO lid_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Eme i dah badeh Sare lundriye Iso oro, tubu iri lau Idom badu munyak Se-ir: ");
INSERT INTO lid_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Udu Iso Adah badeh atehei nah mwan ari badeh nyaran Elipas. Ano udu Elipas eme atehei nadun mwan malimeh: Oro badeh Teman, Omar, Sepo, Gatam ma hawe Kenas. Ya ta udu Elipas ari ja badeh Timna atehei nadun ari nyaran Amalek. Ya udu Iso ari ja nyaran Basemat badeh atehei nadun ari le mwan nyaran Reu-el. Ano Reu-el eme badeh tuwi nadun oro ma hahuw: Oro badeh Nahat, Serah, Samah hawe Misah. ");
INSERT INTO lid_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ano udu Iso ari ja nyaran Oholibamah atehei nadun mwan taloh: Je-us, Jalam hawe Korah. Oholibamah iu ndrine Anah, ya Anah iu ndrine Sibiyon. ");
INSERT INTO lid_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","I doh badeh oro nadu Iso le, oro lau ta atondrok: Nadu Iso kadok Elipas badeh tubu iri lau ta atondrok: Oro badeh Teman, Omar, Sepo, Kenas, ");
INSERT INTO lid_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam hawe Amalek. Oro doh nadu tubu udu Iso, Adah. Iri doh badeh iri lau ta tondrok au ndrine Elipas ado Idom. ");
INSERT INTO lid_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nadu Iso Reu-el, badeh tama iri lau ta atondrok: Oro badeh Nahat, Serah, Samah hawe Misah. Oro doh badeh lau ta atondrok, oro badeh lundriye Reu-el badu Idom. Ya oro badeh tubu Basemat, ya Basemat badeh udu Iso. ");
INSERT INTO lid_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ya i dah badeh lundriye udu Iso nyaran Oholibamah: Oro lau ta tondrok ya nyara Oro badeh Je-us, Jalam hawe Korah. ");
INSERT INTO lid_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ya udu Iso badeh Oholibamah nadu Anah. Oro lau doh badeh nadu Iso ale, aloh Idom. Iri doh badeh lau ta atondrok. ");
INSERT INTO lid_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ya i dah badeh lundriye Se-ir oro; Se-ir badeh badu kon Idom. Oro badeh Lotan, Sobal, Sibiyon, Anah, Dison, Eser hawe Disan. Nadu Se-ir oro doh badeh ndramak ta budon badu Hora. ");
INSERT INTO lid_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ya i doh nadu Lotan uru: Uru badeh Hori hawe Heman. Ya nadu tine Lotan badih ari udu aliy nyaran Timna. ");
INSERT INTO lid_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ya lundriye nadu Sobal oro badeh: Alban, Manahat, Ebal, Sepo hawe Onam. ");
INSERT INTO lid_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ya lundriye Sibiyon oro badeh: Ayah hawe Anah. Anah doh badeh ari labai, iy doh badeh ala silahei gwa lakon nyarahan udu kon lomale an kon ndra an le, na len amwenen ta iy ili sariye donki ta taman Sibiyon aimon bwidiu. ");
INSERT INTO lid_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ya nadu Anah oro badeh: Nadu uru badeh mwan Dison hawe badih Oholibamah. ");
INSERT INTO lid_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Eme nadu Dison oro badeh: Hemdan, Itron, Esban hawe Keran. ");
INSERT INTO lid_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ya nadu Eser badeh: Bilhan, Saban hawe Akan. ");
INSERT INTO lid_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ya nadu Disan badeh: Us hawe Aran. ");
INSERT INTO lid_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ya i dah badeh oro lau ta budon badu Hora: oro badeh Lotan, Sobal, Sibiyon, Anah, Dison, Eser hawe Disan. Oro ari ari an munyak toro loboho munyak Se-ir. ");
INSERT INTO lid_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Oro lau dah asahan kabin tiri Idom udu bwena len iri Isra-el ari basahan kabin bwe le. ");
INSERT INTO lid_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Oro badeh Bela nadu Be-or badeh asahan kabin ta Idom. Kon tinan tan badeh nyaran Dinhabah. ");
INSERT INTO lid_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ano na len Bela imek badeh, Jobap nadu Serah badu Bosrah badeh asahan saluwen, i kabin. ");
INSERT INTO lid_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ano ja Jobap imek badeh Husam badu kon munyak tiri Teman badeh asahan saluwen i kabin. ");
INSERT INTO lid_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ano len Husam imek badeh nadu Bedat nyaran Hadat badeh akohok kon tan asahan kabin. Iy bwena mene amwekes bahun i tiri Midiyen ano ma iy asahan kabin ta kon munyak Idom. Kon tinan tan badeh nyaran Abit. ");
INSERT INTO lid_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ano na len Hadat imek badeh Samlah badu kon Masrekah akohok kon tan asahan kabin. ");
INSERT INTO lid_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ano na len Samlah imek badeh Sa-ul badu Rehobot badu gwa lakon akohok kon tan asahan kabin. ");
INSERT INTO lid_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ano na len Sa-ul imek badeh nadu Akbor nyaran Ba-al Hanan akohok kon asahan kabin. ");
INSERT INTO lid_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ano na len nadu Akbor nyaran Ba-al Hanan imek badeh Hadat akohok kon tan asahan kabin ma udun badeh nyaran Mehetabel badih i ndrine Matret, ma Matret i ndrine Mesahap. Ya kon tinan Hadat badeh nyaran Pau. Eme Iso badeh tama iri Idom mari. ");
INSERT INTO lid_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","I doh badeh nyara iri kabin badu ndrine Iso. Oro ari ari badeh ado boho kamen toro ma are munyak toro. Oro badeh Timna, Albah, Jetet, Oholibamah, Elah, Pinon, Kenas, Teman, Mipsar, Maktiyel hawe Iram. Oro doh badeh kabin tiri badu Idom, ari ari atondrok boho kamen tan udu munyak oro manyah ado aliy. ");
INSERT INTO lid_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jekop badeh manyah udu munyak mene taman udu aliy aloh munyak Kenan. ");
INSERT INTO lid_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ya eme i dah sare nadu Jekop oro: Josep badeh ma loweu le, jaha tan badeh ma ronoh ndro taloh le. Iy badeh udu atondrok katin haka hawe nadu tinen oro ta lundriye Bilhah hawe Silpah, udu Jekop ta nyeu. Oro badeh atondrok iri sipsip hawe me. Ano badeh iy eme, asehek nyala taman ta kandriyen ndra-in ta nadu tinen oro. ");
INSERT INTO lid_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jekop badeh aseken Josep tinan labai ja ta nadun oro mari. Tasah nadun doh badeh iy atehei iy badeh udu suniya iy ndra alon. Eme Jekop eme, mwesekei awin lawe-en moroyan labai i ta Josep. ");
INSERT INTO lid_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Eme nadu tinen oro anyolom tama oro badeh aseken Josep tinan labai ja toro. Eme oro ame badeh amwekes budon ndra-in i tan ma oro badeh bawadei iy bwe hawe basehek sahou mwasin bala tan bwe. ");
INSERT INTO lid_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ano badeh Josep eme ameh, eme iy asehek nyala nadu tinen oro. Eme badeh mwesekei budon toro andra-i labai ja tan. ");
INSERT INTO lid_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Eme Josep asehek i toro anya, “Ado kanuhun ameh tek doh: ");
INSERT INTO lid_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","To mari badeh ado lobwidiu aseu bwidiu wit ise, eme oro bwidiu wit tek badeh toka udu loken. Eme badeh tado mari badeh ame badeh awudi tek, eme ma oro aluh andri i ta tek.” ");
INSERT INTO lid_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ano nadu tinen oro tiye i tan anya, “Ou kede-eh anya, i dah kameh ou a kabin ma atondrok aso ai?” Eme badeh oro badeh no-o oro atok tan labai ai, tasah ta iy asehek nyala ameh tan i toro. ");
INSERT INTO lid_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ano ja badeh iy ameh ja, eme iy asehek ta nadu tinen oro, “Ado kanuhun, jo ameh ja, i doh ja badeh an hawe bun ma hawe ndrau ma ronoh ari badeh aluh i andri eme tek.” ");
INSERT INTO lid_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ano badeh iy asehek ameh doh i ta taman, eme badeh taman arah i tan, “Ameh tam badeh i buku sah badeh? Ou abudon anya i dah kameh tinem ma nadu tinem oro hawe jo kameh kandru aso kameh i andri tam?” ");
INSERT INTO lid_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Eme nadu tinen oro badeh mada oro badeh alikis tan, arile taman tawiy udu budon tan. ");
INSERT INTO lid_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nadu tine Josep oro ndra-au ndrasariye iri katin haka ndrala ndraimon bwidiu mirihik ta Sekem. ");
INSERT INTO lid_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Eme badeh Jekop tiye i ta Josep, “Ou tanam nadu tinem oro badeh atiye iri katin haka badeh aimon bwidiu ado mirihik ta Sekem. Ou ame, jo anya kaseken ou a hawe oro.” Eme iy anya, “Mwasin jo aseken.” ");
INSERT INTO lid_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Eme taman tiye i tan, “Ou ala anyolom nadu tinem oro ma hawe iri katin haka, oro ado mwasin de bwe em, oro ado ndra-in, ano ou ame hamon asehek tek.” Ano badeh taman suni iy edek udu nyamak Hibron ili. Eme Josep asahan Sekem badeh, ");
INSERT INTO lid_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ndramak ari ndruni iy edek leleya eme, eme iy ndremenya Josep, “Ou takaleh sasah?” ");
INSERT INTO lid_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Eme badeh iy anya eh, “Jo asilah nadu tine oro. Oro badeh atondrok katin haka. Ou tanam oro ado heh de bwe?” ");
INSERT INTO lid_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Eme ndramak dah anya, “Oro badeh ndra-au. Jo anuhun oro badeh tiye anya oro kameh ala Dotan.” Eme Josep in hamon toro ili badeh asahan hawe oro mirihik ta Dotan. ");
INSERT INTO lid_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Oro anyolom iy edek udu ndra len eme kahis le badeh, oro atilik nyala oro ta anya kadai iy. ");
INSERT INTO lid_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","20","Eme oro tiye i toro ari ari: “Iy ndramak ta ameh asa eme ah! Abo, to kadai iy ma kakahei iy ki bolo oro ari lek, ano to kato-en anya, iy badeh katin haka ndriliu ndrani iy. Ano badeh to kanyolom sasah kameh kasahan ta ameh tan.” ");
INSERT INTO lid_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Arile Ruben eme anuhun badeh iy anya kaseben ta akohok iy udu mine oro. Eme ma iy anya, “Ndri-i to sadai iy. ");
INSERT INTO lid_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Kakahei iy le, ki bolo lek kudu lomale an dah, ya to sadai iy ndrayen samou.” Ruben asehek sahou doh badeh, ta iy anya kaseben iy ma iy katiyani iy ki hamon hawe taman. ");
INSERT INTO lid_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ano badeh Josep eme isos hawe nadu tinen oro le badeh, oro tawi iy, sadi awin moroyan tan. Awin iy edeu doh nane sowan badeh tinan labai. ");
INSERT INTO lid_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ma oro bwese-e iy ma akahei iy i bolo lek gwa bolon bwe dah. ");
INSERT INTO lid_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ano oro manyah aimon nyamon, ano oro suri mada oro eme loken badeh oro anyolom iri lau ta Isma-el badeh adek are loboho Gileyat ame. Udu bwele-e kamel badeh lakou solo-an labai, lakou i buku none spais kei ta ndrelekei, bam hawe mer ndraye kei ta bekebek ndrana. Oro badeh adek ala Ijip ta atiye lakou ta sisih. ");
INSERT INTO lid_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Eme badeh Juda tiye i ta nadu tinen oro, “Saba lakou kameh kasahan ki ta to ki buku none to kadai nadu tine to, ano to kabisiniy? ");
INSERT INTO lid_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ado kame iy badeh nadu tine to, to katehei iy ki ta sisih. To badeh sadai iy, tasah iy badeh nadu tine to ma ndraye to le.” Eme badeh nadu tinen oro aseken. ");
INSERT INTO lid_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Eme iri lau rayah badu Midiyen ame badeh, oro aruwi Josep udu bolo lek eme loken. Ma oro atehei iy i ta sisih i toro Midiyen na su-ubek lunoh silba boroh i tiri lau badu Isma-el ma iri kuhi iy iu ili Ijip. ");
INSERT INTO lid_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ano badeh Ruben eme mada lek anya katou nadu tinen, arile nadu tinen aliy bwe. Eme badeh iy sadiy awin tan ma iy tikisiy andra-i labai. ");
INSERT INTO lid_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Eme iy ili hawe nadu tinen oro ma tiye, “Jo kameh barabwidiy barala buku sah handru? Iy nah badeh aliy bwe!” ");
INSERT INTO lid_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ano badeh oro adai me ari imek ano oro andrei awin tan badeh tahiy i ta ndra. ");
INSERT INTO lid_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Eme badeh oro andrei awin i hawe tama oro ma oro tiye, “Ou none anyolom awin doh se, koro-an ta nadum.” Aso badeh ndruniy. ");
INSERT INTO lid_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Eme iy anya, “I dah ta naduk le ai. Josep badeh ndramak handru, rayah katin haka ndriliu badeh ndrasadi iy ma ndrani iy.” ");
INSERT INTO lid_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Eme Jekop tikisiy ma iy sadiy awin tan eme iy asiniy awin ta tikisiy amwekes na lami me ma iy eden ndranye nadun ben solo-an. ");
INSERT INTO lid_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Nadun oro mwan ma badih ame atamar iy, arile winiyan bwe, iy bwalen. Eme iy tiye, “Winiyan bwe. Jo kameh eden winiya jo imek ta naduk.” Eme badeh iy eden ili le, ta ndranye nadun. ");
INSERT INTO lid_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ano udu badeh, udu kon Ijip badeh iri Midiyen atehei Josep ja i ta sisih i ta Podipa. Podipa badeh ndramak ta lahou badu bolo asiu ta kabin, ma iy ndramak ta mwena ta ndrokei. ");
INSERT INTO lid_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Na len doh badeh Juda ruwani nadu tinen oro ma iy iu i andri ili hawe ndramak ari badu Adulam nyaran Hirah. ");
INSERT INTO lid_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Eme udu doh badeh Juda awadei hawe badih ari badu Kenan nadu Su-a. Eme iy sudi iy ano iy amadin hawen. ");
INSERT INTO lid_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ma ndrinen i tinan ano ma iy atehei nah mwan ari tondrohani nyaran Er. ");
INSERT INTO lid_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ano ja badeh iy atehei mwan ari ja, tondrohani nyaran Onan. ");
INSERT INTO lid_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ano iy atehei ari ja ale ma tondrohani nyaran Silah. Iy atehei iy badeh udu Aksip. ");
INSERT INTO lid_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ano Juda andrei badih ari nyaran Tamar i ta nadun Er. ");
INSERT INTO lid_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Arile Er nadu Juda badeh kandriyen tan badeh bamwenen ta mada Laban bwe; eme Laban idiy iy imek. ");
INSERT INTO lid_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ano badeh Juda tiye ta Onan, “Ou amadin hawe nyawe nadu tinem ma ou mwesekei lahou ki handru, ta ou a udun ki saluwe nadu tinem. Eme ma ou amwekes ari nah ki ta nadu tinem.” ");
INSERT INTO lid_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Arile Onan badeh tanan, i dah kameh nah kameh bala lundriyen bwe; eme i buku none len mari iy amadin udu nadu tinen kameh gwa tan iu leleya bada munyak. Ya i dah kameh basahan nah nadu nadu tinen bwe. ");
INSERT INTO lid_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Kandriyen iy amwekes doh bamwenen ta mada Laban bwe; eme Laban idiy iy imek ale. ");
INSERT INTO lid_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ano Juda tiye i ta udu nadun badih Tamar, “Ou badeh ado badih nyau ado asiu tam ado gwek, winiya le Silah ki tinan.” Iy badeh abwerei koro-an iy kameh kimek ki le buku nadu tinen oro ale. Eme Tamar badeh iu i hamon i asiu ta taman. ");
INSERT INTO lid_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ano udu luluwen badeh, udu Juda iu ndrine Su-a imek. Ano tikisiy tan ta udun ano badeh, uru kawas tan Hirah badu Adulam badeh ala Timnah ala hawe iri lau asan lami sipsip tan. ");
INSERT INTO lid_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Eme na len lau tiye ta Tamar anya, nyanan mwan badeh ndra-au ndrala Timnah ndrasan lami sipsip, ");
INSERT INTO lid_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","eme iy eme badeh asini awin ta udun nyau mene iy edeu iu, ano andrei awi jam tubuluhi bulin na aliy. Ano nyahani iy manyah udu mada san ta kon Ina-im kon tinan ari udu san ili Timnah. Ma iy badeh tanan, nadu Juda mwan Silah badeh ndra winiya tasou, arile iy bala tasou bala tan bwe le. ");
INSERT INTO lid_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Eme Juda anyolom iy badeh iy anya i badih ta mada san, tasah iy tubuluhi batun. ");
INSERT INTO lid_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Iy banyolom iy bamwenen bwe, eme iy edek ili hawen ili ka-u san ma tiye, “Ou ame jo anya kamadin ou.” Arile iy badeh nyanan. Eme iy anya, “I buku none jo kamadin hawem sasah handru ou kameh atehei keme tek.” ");
INSERT INTO lid_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Eme iy anya, “Jo kameh edeu tam ari me kasen.” Eme iy tiye, “Ou atehei ari lakou ki nyara tandrakan tam, winiya ou le baratiyani barame.” ");
INSERT INTO lid_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Eme iy anya, “Saba lakou ki nyara tandrakan jo atehei tam?” Eme iy anya, “Na lakou ta balem ma ring hawe kandro tarou ta minem.” Eme iy atehei i minen ma iy amadin hawen, ano iy atehei nah i ndrinen ma ndrinen i tinan. ");
INSERT INTO lid_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ano hamon Tamar iu badeh iy asiniy awin ja iu. Ano iy asiniy awin ta nyau tan iy la-un ja. ");
INSERT INTO lid_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ano udu badeh iy suni kawas tan Hirah badu Adulam atiye me ili, ma tiye tan kakuhi lakou ta nyara tandrakan tan udu hawe i badih doh keme hamon. Arile iy ili badeh, iy batakalahei iy bwe. ");
INSERT INTO lid_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Eme iy ndremenya iri lau nane manyah ado doh, “I badih ta mada san ala manyah udu ka-u san Ina-im ndraheh?” Eme iri anya, “Ari badih ta mada san dah bwe oh.” ");
INSERT INTO lid_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Eme iy iu i hamon ja ili hawe Juda ma iy tiye, “Jo badeh batakalahei iy bwe. Ma iri lau badu kon doh anya, iri ari badih ta mada san i buku doh bare don bwe.” ");
INSERT INTO lid_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Eme Juda anya, “Lakou doh ki tan kudu gwek. Jo bwalek iri lau sondrokonya ma sehe-en to. Jo badeh none ta anya kisih iy, arile ou takaleh iy labwe.” ");
INSERT INTO lid_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Udu, bun taloh ano badeh, lau asehek ta Juda anya, “Nadu nyanam Tamar badeh ndra buku badih ta mada san ma nyolom tan ndra randra ma iy ndrinen ndra tinan.” Eme Juda anya, “Katiyani iy keme ma kasulumwi iy kimek.” ");
INSERT INTO lid_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ano iri andrei iy eme len, ano iy suni sahou i ta nyanan mwan Juda eme: “Jo badeh nah udu ndrinek dah nadu ndramak lakou tan dah. Ou tanam lakou dah ma tarou udu badan de bwe?” ");
INSERT INTO lid_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda anyolom ma iy tanan, ano iy tiye, “Iy badeh tiye sahou handru. Jo badeh ndra bwe ai, ta tandrakan tek, jo mene ndratehei iy ndratasou ndra ta Silah ai.” Eme iy bamadin hawen ja bwe ai. ");
INSERT INTO lid_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ben ano ta iy anya kedeu nadun keme len badeh, iri silahei iy badeh nah mwimwir udu ndrinen. ");
INSERT INTO lid_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Nah anya keme len badeh iy ari badeh minen eme len; eme badih ta lahou ta nah andrei kam saraman, eme iy sawei boha nah dah. Eme iy tiye, “I dah, eme len bwena.” ");
INSERT INTO lid_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Arile iy ruwani minen ja badeh, nadu tinen mwan eme len, ano iy tiye, “San ta iy eme len asa i le buku doh!” Eme badeh nyaran i Peres, moson “Iy eme len bwena.” ");
INSERT INTO lid_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ano badeh kam saraman udu boha nadu tinen in hamon eme len ja, eme tondrohani nyaran Serah, moson “Lomadan saraman.” ");
INSERT INTO lid_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ya Josep badeh ndrakuhi iy badeh ndrala Ijip. Podipa ndramak ta lau ta bolo asiu hawe ta bwena ta ndrokei sihine iy udu mine iri lau badu Isma-el. Iri mene kuhi iy ili doh. ");
INSERT INTO lid_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Eme Laban badeh udu hawe Josep, ma lakou mari iy amwekes badeh ndra mwasin le. Eme Josep badeh manyah tan badeh badu asiu ta Podipa, ");
INSERT INTO lid_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","eme Podipa anyolom Laban udu hawen ma mwesekei iy amwekes lakou ndra mwasin le. ");
INSERT INTO lid_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Eme iy anyolom Josep badeh udu mwasin ta madan, eme iy asahan ndramak ta lahou tan; ano Podipa anyolom iy badeh winiyan, eme iy atehei iy atondrok asiu tan ma lakou tan mari. ");
INSERT INTO lid_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Na len iy atehei Josep atondrok asiu tan ma lakou tan mari, Laban badeh atehei nyosowan i la-u asiu ta Podipa. Tasah na Josep le badeh, Laban atehei nyosowan i la-u lakou mari ta Podipa badu bolo asiu ma manan ale. ");
INSERT INTO lid_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Eme lakou mari iy atehei udu baha tondrok ta Josep. Iy badeh babudon ta lakou mari bwe, nyamon le iy aimon. Josep badeh ndramak ari buruwen ma iy badeh konen labai. ");
INSERT INTO lid_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ano udu sese badeh udu Podipa budon tan andra-i ta Josep eme iy ndremenyani iy ta iy kili hawen ki bada sau. ");
INSERT INTO lid_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Arile Josep bwalen, ma iy tiye, “Jo badeh atondrok lakou mari. Podipa winiyan babwerei bwe, tasah iy atehei budon i tek ta jo badeh winiyan tondrokei lakou mari badu asiu tan ma lakou tan mari. ");
INSERT INTO lid_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ari lau ja bado bwele-ek ja udu asiu dah bwe, jo le. Podipa badeh batawiy ari lakou bare minen ja bwe, arile udun: Tasah ou badeh udun labai. I buku sah handru kameh jo kamwekes kandriyen ndra-in ma karei ki ta Kindrei?” ");
INSERT INTO lid_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Eme iy badeh ndremenya seken ta Josep len ari i buku ari, ta iy kili bada sau hawen, arile Josep bwalen. ");
INSERT INTO lid_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ano na len ari badeh Josep anya kili bolo asiu kamwekes lahou tan. Eme ari lau ta lahou badeh bare aliy bwe. ");
INSERT INTO lid_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Eme udu Podipa tawi awin tan indrek iy, “Ou ame sau hawek.” Arile Josep atobwak eme manan, awin tan ta bwele-en le badeh udu ndra minen udu gwek. ");
INSERT INTO lid_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Eme udu Podipa anyolom awin tan badeh udu minen udu badeh, ");
INSERT INTO lid_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","eme iy luhi iri lau ta lahou tan ame. Eme iy tiye i toro, “Ado kanyolom. Iy ndramak badu Hiburu ala andrei iy mene eme hawe taha dah badeh bobose taha handru. Iy eme bolon dah badeh anya kamadin jo, arile jo eme arah. ");
INSERT INTO lid_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Iy anuhun jo arah le badeh, iy ruwani awin tan udu ka-uk udu ai, iy le atobwak eme len ta asiu ma iy iu.” ");
INSERT INTO lid_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Eme badeh awin tan udu ka-un udu gwek winiya le udun eme. ");
INSERT INTO lid_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ano iy asehek i ta udun i buku doh, “Iy ndramak ta lohowan badu Hiburu ou kuhi iy eme kede-eh anya kateu jo. ");
INSERT INTO lid_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Eme jo arah i ta lau kaseben jo le badeh, iy ruwani awin tan udu ka-uk udu ma iy atobwak i manan ta asiu.” ");
INSERT INTO lid_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Eme udu Podipa tiye i tan, “Iy ndramak ta lahou tam badeh amwekes kandriyen doh eme tek.” Eme iy anuhun sahou udun asehek i tan badeh, eme ndrinen i buku jih. ");
INSERT INTO lid_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Eme Podipa tawi Josep ma atehei iy i bolo kou, ndrahune iri lau ta bolo kou ta kabin areu aliy. ");
INSERT INTO lid_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Arile Josep udu bolo kou badeh, Laban udu hawen, Laban tikisiy iy ma mwesekei ndramak ta atondrok bolo kou badeh aseken iy. ");
INSERT INTO lid_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Eme ndramak ta atondrok iri badeh atehei Josep badeh atondrok iri lau mari nane are bolo kou nane dah. ");
INSERT INTO lid_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Eme iy ndramak ta atondrok ari lakou bwe, lakou badeh udu baha nyolom ta Josep, tasah Laban badeh udu hawe Josep, eme badeh mwesekei Josep winiyan amwekes lahou mari. ");
INSERT INTO lid_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Ano udu, len rayah ja hamon badeh uru ndramak ta lohowan, ndramak ta lohowan ta kabin badu Ijip. Iy ari ndramak ta atiye wa-in, ya iy ari ndramak ta mwena ta amwekes jabi ramen. Uru badeh mwesekei kabin i bolosen. ");
INSERT INTO lid_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Eme kabin atehei uru a bolo kou bolo asiu ta ndramak ta ndrokei. Ado bolon hawe Josep. ");
INSERT INTO lid_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Eme ndramak ta mwena ta ndrokei atehei ben solo-an i turu, eme iy atehei Josep badeh i ta lahou turu. ");
INSERT INTO lid_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ano uru ado bolo kou luluwen sese badeh, iy ndramak ta atiye wa-in hawe ndramak ta amwekes jabi ramen ta kabin badu Ijip badeh ameh. Ameh turu badeh i buku doh, ta iy ari moson i randrah labai, ta iy ari moson i randrah labai. ");
INSERT INTO lid_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ano Josep mandraben eme hawe uru badeh iy anyolom uru badeh tikisiy. ");
INSERT INTO lid_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Eme Josep ndremenya uru, “Ah tikisiy ta sasah na len dah?” ");
INSERT INTO lid_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Eme uru anya, “Aru mala-uh badeh ameh, arile ari ndramak ta tobolowe moso ameh taru bwe.” Ano Josep badeh tiye i turu, “Kindrei badeh ta edeu moso ameh, eme ah kasehek ameh ta ah.” ");
INSERT INTO lid_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Eme iy ndramak ta atiye wa-in asehek ameh tan i ta Josep i buku doh, “Jo badeh ameh malou wa-in badeh ateh udu bwena tek, ");
INSERT INTO lid_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ma wa-in doh badeh andran ma taloh. Eme la-un ateh le badeh buwan asahan ma buwan uni. ");
INSERT INTO lid_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Eme jo badeh tawi bwiniu ta kabin udu minek ano jo andrei buwa wa-in eme ma jo apis gwa tan i bolon. Ano badeh jo atehei i mine kabin.” ");
INSERT INTO lid_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Eme Josep tiye, “Moson badeh i buku doh: Andra wa-in ma taloh badeh moson len taloh. ");
INSERT INTO lid_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Len taloh ano kameh kabin kameh tiye ou ano ta bolo kou, ma iy kameh atehei ou a hamon ta lahou tam ja. Ma i dah kameh ou kameh atiye wa-in bwiniu i minen i buku bwena le mene. ");
INSERT INTO lid_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Arile ou samani jo, i buku none ou ado mwasin, ma ou tikisiy jo eme ou asehek nyala kabin, ma kameh iy sebenei jo eme len ta bolo kou. ");
INSERT INTO lid_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bwena ndra-au badeh iri bene-ei jo udu munyak ta Hiburu eme dah; eme udu badeh jo bamwekes ari lakou bandra-i bwe, arile iri atehei jo i bolo kou leleyah.” ");
INSERT INTO lid_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ano iy ndramak ta amwekes jabi ramen anuhun Josep badeh tiye moso ameh badeh mwasin, eme iy tiye ta Josep, “Jo ale ameh; Jo ameh badeh, udu bwele-e batuk badeh bwak jabi ramen ma taloh. ");
INSERT INTO lid_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Udu bwak bwele-e batuk loken badeh saba jabi ramen ta kabin udu bolon, eme iri sirih ame badeh aimon.” ");
INSERT INTO lid_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Eme Josep anya, “Moson ta aliy badeh i buku doh: Len taloh ano badeh kameh, kabin kameh andrei batum kameh iu. ");
INSERT INTO lid_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ma i dah kameh tatahiy badam udu ta kei ya iri sirih kameh ame aimon odam.” ");
INSERT INTO lid_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Eme na len taloh badeh amwenen ta len ta kabin, tinen atehei iy eme len, eme iy mwesekei tine nyamon niri lau ta lahou tan badu bolo asiu tan. Eme iy kuhi ndramak ta atiye wa-in ma ndramak ta amwekes jabi ramen uru ado bolo kou ame len, eme uru ame badeh ales are mada iri lau ta lahou tan badu bolo asiu dah. ");
INSERT INTO lid_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ano iy ruwani iy ndramak ta atiye wa-in; eme ma iy iu i ta lahou tan bwena mene, eme ma iy atehei bwiniu wa-in dah i mine kabin. ");
INSERT INTO lid_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Arile iy ndramak ta amwekes jabi ramen le badeh, iy tatahiy badan. Ma tatahiy i buku none Josep mene ndrasehek ndra-au. ");
INSERT INTO lid_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Arile ndramak ta atiye wa-in badeh balen ndramaniy sahou mene Josep asehek tan. ");
INSERT INTO lid_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Jaha la-uh ano badeh, kabin badu Ijip badeh ameh. Iy ameh badeh, iy ameh iy badeh ales udu gwa Na-el. ");
INSERT INTO lid_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Eme badeh iy anyolom oro bulumakau ma ndro taloh tinan bada oro nyimirin badeh asahan gwa ame loke an kapa gwa aimon bwidiu. ");
INSERT INTO lid_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ano ja iy anyolom bulumakau ndro taloh ja asahan; oro doh badeh sali oro bwe, ndruwin ndruwin. Oro ame ales are hawe oro bulumakau bwena nane are kapa gwa. ");
INSERT INTO lid_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Eme badeh oro bulumakau sali oro bwe nane dah aniy oro bulumakau sali oro udu aliy dah, ano badeh ma kabin amak. ");
INSERT INTO lid_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ano iy amadin ja badeh iy ameh ja. Eme iy anyolom bada kalom ari le, eme badeh udu bada kalom ari le doh badeh iy anyolom buwa kalom ma ndro taloh tinan badeh sukik udu badan badeh ndruni. ");
INSERT INTO lid_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ano ja badeh iy anyolom bada kalom ari le ja, eme badeh udu bada kalom ari le doh badeh iy anyolom buwa kalom ma ndro taloh badeh awa-is ma siyer rai oloh ili eme. ");
INSERT INTO lid_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Eme oro kalom ma ndro taloh awa-is nane dah sakalamiy oro kalom buwa oro tinan dah. Eme kabin amak badeh iy anya, “Jo dah nane ameh.” ");
INSERT INTO lid_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Eme iy tikisiy handru, eme na mandraben badeh iy suni sahou i tiri lau mari ta kau tan ma hawe iri lau ta budon tan badu Ijip ame. Eme iy asehek ameh tan i tiri, arile iri ari winiyan batiye moso ameh bala tan bwe. ");
INSERT INTO lid_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ano ndramak ta atiye wa-in tiye i ta kabin, “Jo anya kasehek tam, jo badeh ndramwekes lakou ndrandra-i. ");
INSERT INTO lid_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ou mene a bolosen i tek ma hawe i ta ndramak ta atondrok ta amwekes jabi ramen. Ano ou mene atehei aru a bolo kou udu bolo asiu ta ndramak ta bwena ta ndrokei. ");
INSERT INTO lid_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Eme na ben ari badeh aru ma la-uh ameh, ya ameh taru badeh, ta iy ari badeh moson randra labai, ya ta iy ari moson randra labai. ");
INSERT INTO lid_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ya nah loweu ari badeh Hiburu badeh udu hawe aru. Iy badeh lohowan ta ndramak ta bwena ta ndrokei. Eme aru asehek ameh taru i tan badeh eme iy tubuniy moson eme taru. ");
INSERT INTO lid_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Eme badeh asahan i le handru; jo badeh ou atehei jo i hamon ta lahou tek, arile ou andrei bale ndramak ta bwena ta amwekes jabi ramen.” ");
INSERT INTO lid_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ano kabin suni lau ala suwi badeh andrei Josep udu bolo kou eme. Ano Josep ili isik lami behesen, iy asiniy awin ano badeh iy ili ales ere mada kabin. ");
INSERT INTO lid_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Eme kabin tiye i tan, “Jo badeh ameh, eme ari ndramak badeh batiye moson bame tek bwe. Eme ndramak ari tiye tek anya, ou badeh winiyan tobolowe moso ameh.” ");
INSERT INTO lid_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Eme Josep tiye, “Jo le, jo winiyan bwe, arile Kindrei le winiyan tiye moson i tam.” ");
INSERT INTO lid_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ano badeh kabin asehek ameh tan, “Jo ameh badeh, jo badeh ales udu kapa gwa Na-el. ");
INSERT INTO lid_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Eme jo anyolom oro bulumakau ma ndro taloh tinan ma bada oro nyimirin are gwa ame badeh aimon bwidiu ado kapa gwa. ");
INSERT INTO lid_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ano ja badeh jo anyolom oro bulumakau ma ndro taloh sali oro bwe, ndruwin ndruwin are gwa ame loken. Jo bwena batou ari bulumakau munya-un bala buku none doh udu munyak Ijip bwena bwe. ");
INSERT INTO lid_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Eme oro aniy bulumakau tinan nyimirin dan. ");
INSERT INTO lid_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Oro ndraniy, arile ndramak anyolom badeh i buku none oro baniy bwe, oro ma ndrusarak kahis le. Eme badeh ma jo amak. ");
INSERT INTO lid_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ano ja badeh jo ameh ja, eme jo anyolom bada kalom ari le, eme udu bada kalom ari le doh badeh jo anyolom buwa kalom ma ndro taloh tinan badeh sukik udu badan badeh ndruni. ");
INSERT INTO lid_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ano ja jo anyolom bada kalom ari le ja, eme badeh udu bada kalom ari le doh badeh, jo anyolom buwa kalom ma ndro taloh tinan bwe awa-is ma siyer rai aloh ili eme. ");
INSERT INTO lid_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Eme oro buwa kalom salin bwe dah sakalamiy oro tinan nyimirin dah. Ya eme jo asehek ameh doh i tiri lau ta kau, arile iri winiyan batiye moson bame tek bwe.” ");
INSERT INTO lid_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ano badeh Josep tiye i ta kabin, “Ameh tam ma la-uh badeh moson i randra le; Kindrei badeh asehek tam ta lakou kameh iy kameh amwekes eme bakep ai.” ");
INSERT INTO lid_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Oro bulumakau tinan ma ndro taloh badeh moson jaha ma ndro taloh. Ya oro buwa kalom tinan ma ndro taloh badeh moson jaha ma ndro taloh ale. ");
INSERT INTO lid_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ya oro bulumakau ndruwin ma ndro taloh, oro an hamon ame ma buwa kalom ma ndro taloh awa-is siyer rai oloh badeh, moson, jaha ndro taloh kameh nyamon bwe. ");
INSERT INTO lid_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","I doh i buku le jo asehek tam kabin, luwen bwe kameh Kindrei badeh leheya tam lakou kameh iy amwekes. ");
INSERT INTO lid_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","I dah kameh jaha ndro taloh kameh munyak Ijip kameh idih na nyamon. ");
INSERT INTO lid_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ano udu hamon ta aliy na jaha ndro taloh ja kameh len ta son, len kameh nyamon bwe; eme jaha mwasin mene kameh lau maniy, tasah nyamon bwe kameh weleyani kon mari. ");
INSERT INTO lid_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Len ta nyamon solo-an mene lau ndramaniy, tasah len ta nyamon bwe eme kameh akohok andra-i labai. ");
INSERT INTO lid_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Moso ameh tam badeh Kindrei ndrasani ben, ya luwen bwe kameh asahan ai. ");
INSERT INTO lid_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Eme na dah badeh ou adeu ari lau ta budon ma lau ta tanan eme ou atehei iy katondrok kon munyak mari badu Ijip. ");
INSERT INTO lid_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ou ale tiye lau rayah ta lahou ta bolo asiu katondrok kon ari ari, iri kakohok lunoh nyamon badu bolo rinek rakum rakum na len ta nyamon amasu dah. ");
INSERT INTO lid_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Udu baha tondrok tam ou tiye toro, udu bolo jaha ndro taloh mwasin dah oro kakohok nyamon badeh ma oro katehei kudu bolo asiu bolo kon tinan dah. Ma oro badeh katondrok. ");
INSERT INTO lid_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Eme buku none jaha ndro taloh ta son asahan kameh, arau kameh i niri kon mari na len ta son kameh asahan Ijip. Eme kameh iri lau winiyan bakohok bandra-i ta son bwe.” ");
INSERT INTO lid_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","38","Eme kabin hawe iri lau ta lahou tan ta bolo asiu aseken budon tan, ma tiye i toro, “To winiyan basilahei ari ndramak i buku none Josep kede-eh bwe ai, iy badeh malawi ndrabun ta Kindrei udu tan.” ");
INSERT INTO lid_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ano kabin tiye i ta Josep, “Kindrei badeh ndraleheyani lakou mari doh i tam. Eme ya ou kede-eh ndramak ta budon ma ou kede-eh ndramak ta tanan labai, ari ndramak bala buku none ou bwe. ");
INSERT INTO lid_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Jo kameh atehei ou atondrok munyak mari; ma iri lau mari kameh anuhun le ou. Boto-on tek badeh udu bwele-em ya boto-on tam badeh udu bahan tek. ");
INSERT INTO lid_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Na dah jo badeh atehei ou atondrok munyak mari badu Ijip.” ");
INSERT INTO lid_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Eme kabin andrei ring tan amwenen atehei i andra lime Josep. Eme kabin asiniy awin i badan ma atehei gol sen nyikilikin i balen. ");
INSERT INTO lid_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ano iy atehei Josep manyah udu la-u sau, sau doh iri katin haka aliu, ma sau doh badu bahan ta kabin; ano iri lau ta ndrokei ta atudun adek an mwena tan aloh, “Aha kabelek! Aha kabelek!” Josep badeh ndrasahan ndramak ta atondrok munyak tinan mari badu Ijip. ");
INSERT INTO lid_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ano kabin tiye i tan, “Jo badeh kabin, eme ari ndramak badu Ijip mari dah, winiyan are lau winiyan batudun iy bwe, i buku none ou batiye ehe bala tan bwe.” ");
INSERT INTO lid_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Eme iy tondrohani Josep i badu Ijip badeh aloh Sepenat Paneya. Ano iy atehei badih i udun nyaran Asenat ya iy badih doh badeh nadu Podipera. Ya Podipera badeh iy Pris badu kon tinan On. Josep badeh jaha tan asahan tonoh badeh iy eme amwekes lahou ta kabin badu Ijip. Eme iy ruwani ndrahu kabin eme iy edek ili anyolom kon mari badu Ijip. ");
INSERT INTO lid_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Udu bolo jaha mwasin badeh munyak ato-ou nyamon solo-an labai, ");
INSERT INTO lid_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","eme iri nyamon solo-an labai. Eme Josep badeh akohok ano badeh iy atehei iri ado bolo asiu udu kon tinan. Udu bolo bilin awudi kon tiri ari ari, badeh iy atukum nyamon ma atehei udu kon tinan. ");
INSERT INTO lid_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Iy ma mwena ondrek kalom. Ano badeh kalom nyaran bwe, solo-a on badu ndras, eme badeh iy badeh babudon ta ondrek bwe. ");
INSERT INTO lid_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ben ta nyamon bwe basahan bwe le badeh, udu Josep Asenat badeh atehei nadun mwan la-uh. ");
INSERT INTO lid_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Eme Josep tiye, “Kindrei badeh ndramwekes jo ndramaniy isi tek ma ndramaniy iri lowa tama oro.” Eme iy tondrohani kadok tan badeh nyaran Manase. ");
INSERT INTO lid_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ano ja Josep tiye, “Kindrei badeh ndratehei jo ndrasola udu munyak ta ndra-i dah; eme iy tondrohani bwaneh tan Ipra-im.” ");
INSERT INTO lid_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ano badeh jaha ma ndro taloh ta nyamon solo-an udu Ijip nane iri lau sekesek ndrano. ");
INSERT INTO lid_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Eme i buku none Josep ndratiye len ta nyamon bwe asahan ai. Kon mari badeh nyamon bwe, arile munyak Ijip le, nyamon udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Eme udu sese iri lau badu Ijip nyamon bwe, iri ameson, eme iri aden i ta kabin ta nyamon. Eme kabin tiye iri ala hawe Josep ma iri kanuhun le Josep. ");
INSERT INTO lid_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ano udu nyamon bwe ma son akohok kon munyak mari eme Josep sihiy asiu ta nyamon ma edeu kalom i ta sisih i niri lau badu Ijip. ");
INSERT INTO lid_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Eme iri lau mari badu bolo munyak ame Ijip, ame hawe Josep asih nyamon, tasah kon mari ndrandra-i labai ta nyamon bwe. ");
INSERT INTO lid_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Na len Jekop badeh anuhun, udu Ijip badeh kalom udu aliy, eme Jekop tiye i ta nadun oro, “Ado kede-eh abosah le kede-eh? ");
INSERT INTO lid_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Jo anuhun badeh, anya Ijip badeh kalom udu aliy; eme ado kala kasih nato rayah, bwe kameh to amak ta son ai.” ");
INSERT INTO lid_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Eme badeh nadu tine Josep oro ma ronoh badeh ala Ijip ala asih kalom. ");
INSERT INTO lid_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Arile Jekop badeh batiye nadu tine Josep Benjamin bala hawe oro bala bwe, tasah iy badeh inoh koro-an lakou katok tan. ");
INSERT INTO lid_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Nadu Jekop oro ala hawe iri lau ame asih kalom, tasah munyak Kenan badeh nyamon bwe. ");
INSERT INTO lid_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Eme Josep badeh atondrok munyak mari badu Ijip, ya iy badeh edeu kalom ta sisih i tiri lau mari badu kon munyak. Eme nadu tine Josep oro ame badeh aluh andri bada munyak i ta Josep. ");
INSERT INTO lid_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Eme Josep badeh ndraseleyani nadu tinen oro, arile iy badeh amwekes iy i buku none iy tanan oro bwe. Eme Josep ndremenya oro boto-on, “Ado badu heh ame dah?” Eme oro anya, “Aso badeh badu Kenan, aso ame dah ta asih nyamon.” ");
INSERT INTO lid_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josep badeh ndraseleyani nadu tinen oro, arile nadu tinen oro baseleyani iy bwe. ");
INSERT INTO lid_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Eme Josep badeh abudon ameh mene iy ameh oro ma iy tiye, “Ado dah badeh ado lalou; ado ame dah ta asilah kon munyak boto-on de bwe.” ");
INSERT INTO lid_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Eme oro anya, “Bwe Laban, aso ame dah i buku none lohowan ame ta asih nyamon. ");
INSERT INTO lid_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Aso badeh nadu tinen aso, aso nadu ndramak ari le ya aso badeh lalou bwe, aso badeh ta wasai bwe, aso tiye sahou handru.” ");
INSERT INTO lid_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ano Josep tiye, “Bwe! Ado kede-eh ame ta anya kasilah kon munyak dah boto-on tan bwe udu heh.” ");
INSERT INTO lid_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ano oro tiye, “Aso nadu tine aso badeh ma ronoh la-uh; aso nadu ndramak ari le udu munyak Kenan. Eme nadu tinen aso ari badeh ndramak, arile iy ari le bahan badeh udu hawe tama aso.” ");
INSERT INTO lid_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Eme Josep anya, “I buku le jo nane ndrasehek ndra-au eh. Ado kede-eh lalou! ");
INSERT INTO lid_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","I dah kameh asilah tanan ta takaleh ado! Jo badeh tandrakan ta nyara kabin, ta ado kameh winiyan ba-au bwe, ndra ado kandrei nadu tine ado bahan keme. ");
INSERT INTO lid_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ado ari kala kandrei iy. Ado mari kameh ado, iri lau ta ndrokei kameh atondrok ado, ndra kasilahei labai, ado tiye sahou handru de bwe. Eme kabin in ndra loke kahis, iy ki tanan ado badeh lalou.” ");
INSERT INTO lid_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ano badeh Josep atehei oro a bolo kou len taloh. ");
INSERT INTO lid_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ano na len taloh badeh Josep tiye i toro, “Jo badeh ndramak ta inoh Kindrei, ado kamwekes lahou doh ma ado kameh bamak bwe: ");
INSERT INTO lid_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ta kasilah ado tiye sahou handru badeh, ari tado kudu bolo kou kudu. Ado mari badeh ka-au kala katiye kalom ado ndrasihinei kede-eh ki na lowa tama ado ameson are kodo-oh. ");
INSERT INTO lid_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","21","Ano ado katiyani nadu tine ado bahan keme hawek. I doh kameh jo i tanan ado tiye sahou handru, ma jo kameh winiyan badai ado bwe ai.” Eme oro asumon, ma oro tiye i toro ari ari, “Handru labai, na dah to akohok maha tato, ta to mene amwekes i bada nadu tine mene. To badeh anyolom isi ma maha tan mene iy aloh ta seben, arile to banuhun iy bwe. Eme adeh, to are bolo maha dah.” ");
INSERT INTO lid_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Eme Ruben tiye, “Jo mene tiye anya, ado sadai iy samak, arile ado banuhun bohok bwe. Na i dah to akohok maha ta imek tan ai.” ");
INSERT INTO lid_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Josep badeh anuhun ma iy tanan sahou mari oro asehek, arile oro baseleyani iy bwe, tasah ndramak ari badeh udu hawe oro ta tobolowe sahou toro i ta Josep. ");
INSERT INTO lid_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ano badeh Josep ruwani oro ado, eme iy ili badeh eden. Iy eden ano iy eme hamon badeh tiye sahou i toro ja, ano iy andrei Simiyon ma sawei iy, udu mada oro ma andrei iy iu. ");
INSERT INTO lid_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ano Josep eme badeh tiye iri anyuhiy ndrom ta nadu tinen oro na kalom ma tiye iri badeh atehei su-ubek toro ari ari i hamon i bolo ndrom toro, ma edeu noro nyamon ta san. Eme oro lakou doh ano badeh, ");
INSERT INTO lid_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","nadu tinen oro alokou ndrom kalom toro asih nane dah i bwele-e donki toro, ano ma oro au ai. ");
INSERT INTO lid_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Eme oro adek ala amadin ben ari ado san. Eme na ben doh badeh iy ari toro anya kaseh ndrom tan anya kakohok nyamon kanyohan donki tan. Eme udu mada ndrom badeh iy atou su-ubek tan badeh udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Eme iy aloh i ta nadu tinen oro, “Su-ubek tek ndrame hamon ja, asah udu mada ndrom tek kada-ah.!” Eme badeh oro abwerei labai, eme oro anya, “Kindrei amwekes sasah eme tato dah?” ");
INSERT INTO lid_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Eme oro ame asahan hawe tama oro ame Kenan. Ano badeh oro asehek ta tama oro ta lakou mari nane asahan bada oro: ");
INSERT INTO lid_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Aso ala badeh ndramak ta atondrok munyak mari badu Ijip badeh asehek sahou nyarahan eme taso ma iy tiye anya aso badeh lalou. ");
INSERT INTO lid_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Eme aso anya, ‘Aso dah lalou bwe! Aso tiye sahou handru, aso bawasai bwe! ");
INSERT INTO lid_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Aso badeh ma ronoh la-uh, nadu ndramak ari le. Ya nadu tine aso ari badeh ndramak ya nadu tine aso ari le bahan badeh udu hawe tama aso udu kon.’ ");
INSERT INTO lid_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Eme ndramak dah tiye, ‘I dah kameh jo kameh takaleh ado kede-eh tiye sahou handru de bwe.’ Eme iy anya, ‘Ari tado kameh kudu hawek kudu; ya ado mari kede-eh le kala katiye kalom ki na tama ado oro.’ ");
INSERT INTO lid_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ano iy tiye, ‘Ano ado katiyani nadu tine ado bahan keme hawek. Eme i dah kameh jo kameh i tanan ado badeh tiye sahou handru, ado badeh lalou bwe; ano ja kameh jo atehei nadu tine ado ewek hamon, ya ado kameh ado asih lakou.’” ");
INSERT INTO lid_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ano oro solowei ndrom toro, eme oro mari badeh atou su-ubek toro mari eme hamon; eme oro atou su-ubek badeh, oro ma hawe tama oro badeh anoh. ");
INSERT INTO lid_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ano tama oro tiye i toro, “Ado mari kede-eh anya kamwekes naduk kamai ma iy ki-iu ai? Josep mene ndra-au, ano Simiyon ndra-au ale; ano na dah ado anya kakohok Benjamin ja ai. Jo le kameh akohok maha ma isi ta aliy!” ");
INSERT INTO lid_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ano Ruben tiye i ta taman, “Tama, i buku none jo bandrei Benjamin bame hamon bwe, badeh ou adai naduk mwan ma la-uh ki saluwen. Ou atehei iy keme minek, jo kameh winiyan tondrokei iy ma jo kameh winiyan andrei iy eme hamon.” ");
INSERT INTO lid_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Arile Jekop tiye, “Naduk winiyan bawek hawe ado bwe; nadu tinen mene ndramak, eme iy le ari le udu kada-ah. Koro-an ari lakou katok tan kudu san. Ya jo badeh ndra alon, koro-an ado kameh kamwesekei jo katikisiy ma jo kimek.” ");
INSERT INTO lid_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Eme kon Kenan akohok andra-i ta nyamon bwe, ");
INSERT INTO lid_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ano oro aniy kalom mene oro asih badu Ijip ano, badeh Jekop tiye i ta nadun oro, “Ado ka hamon ja kasih rayah nyamon nato ja.” ");
INSERT INTO lid_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Eme Juda tiye i tan, “I ndramak mene tiye taso anya, i buku none aso bandrei nadu tine aso Benjamin bala bwe, aso winiyan bales bare madan bwe. ");
INSERT INTO lid_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","I buku none ou aseken ta nadu tine aso keme hawe aso badeh, aso ala asih nam nyamon ai. ");
INSERT INTO lid_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","I buku none ou batehei iy bame bwe, i dah kameh aso winiyan bala bwe. Tasah ndramak doh tiye mene anya, i buku none aso bandrei iy bala bwe, aso winiyan bales bare madan bwe.” ");
INSERT INTO lid_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ano Jekop anya, “I buku sah ado tiye ta ndramak doh anya, nadu tine ado ari udu aliy? Ado atehei maha ma tikisiy solo-an eme tek.” ");
INSERT INTO lid_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Eme oro anya, “Ndramak doh ndremenya aso san solo-an. Iy ndremenya lowa aso, ano iy ndremenya anya, ‘Tama ado udu aliy? Ya nadu tine ado ari udu aliy ja de bwe?’ Eme aso badeh tiye tan: tasah aso nane bala tanan bwe, ta budon tan nane anya aso kandrei nadu tine aso nane anya kili bwe.” ");
INSERT INTO lid_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ano Juda tiye i ta taman Jekop, “Ou atehei nah keme hawek, ma aso ka-au. Bwe kameh to mari amak ai. ");
INSERT INTO lid_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Jo le kameh balek udu tan, i buku none jo batiyani iy bame hamon bwe, badeh kameh jo akohok maha ta aliy len jo udu ndra loken udu bolo munyak dah. ");
INSERT INTO lid_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","To are dah abe-en luluwen labai anuhun boho tama to, samada to ndrala ano to ndrame san lusan ai.” ");
INSERT INTO lid_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ano tama oro badeh tiye toro, “I buku none badeh handru eh, ado kandrei lakou ta bilin dah katehei ki bolo ndrom tado kewek ki ta ndramak ta atondrok munyak mari badu Ijip: Ado kandrei sese ndrelekei ta resen, rayah bwirik, rayah spais (lakou i buku lei), rayah buwa pistasin, ma hawe almon (buwa kei i buku nyalin). ");
INSERT INTO lid_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ado kandrei su-ubek mene udu mada ndrom tado mene kewek, koro-an i doh mene bale ari ndramak ndramaniy ma hawe ado kandrei rayah su-ubek kewek ale ta asih nyamon. ");
INSERT INTO lid_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Eme ado kandrei nadu tine ado, ado kala ano badeh ado kame hamon suwi. ");
INSERT INTO lid_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Laban Kindrei kamwekes ndramak doh katikisiy ado, ya i katehei Benjamin hawe nadu tine ado Simiyon keme hamon hawe ado. I buku none naduk uru jo maniy uru, badeh jo winiyan babwidiy se lakou bwe.” ");
INSERT INTO lid_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Eme oro andrei lakou ta i ta ndramak nane, andrei su-ubek mene udu mada ndrom mene hawe su-ubek rayah ma hawe nadu tine oro Benjamin oro au ala Ijip. Eme oro ala adeu lakou i mine Josep. ");
INSERT INTO lid_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Eme badeh Josep anyolom Benjamin udu hawe oro le badeh iy tiye tiri lohowan tan ta bwena ta asiu tan, “Kandrei oro lau dah ka asiu tek. Ado kadai ari katin haka ma kajuhiy kudu le, i dah kameh oro aimon nyamon hawek na mada an ronoh la-uh.” ");
INSERT INTO lid_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Eme ndramak ta lohowan dah anuhun le boho Josep eme iy andrei oro a asiu. ");
INSERT INTO lid_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Eme oro ala asiu badeh, oro ndranoh, eme badeh oro lomondra, “Andrei to ame dah ta su-ubek mene udu mada ndrom ta tato le ai, len ma mwena handru to ame dah asih nyamon. Ya i dah kameh iri tawi to ma iri kameh andrei iri donki tato ma to kameh asahan bonyo-ou tan.” ");
INSERT INTO lid_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Udu mada san ta i bolo asiu badeh oro tiye i ta ndramak ta atondrok iri lohowan, ");
INSERT INTO lid_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ou anuhun aso, aso ma mwena handru badeh ndrame dah ndrasih nyamon. ");
INSERT INTO lid_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Eme aso adek ala hamon badeh aso amadin ben ari ado san, eme aso anya kase ndrom taso badeh, aso atou su-ubek silba aso asih nyamon na aliy mene udu mada ndrom taso. Eme aso ndrandrei ndrame udu hawe aso dah. ");
INSERT INTO lid_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ma aso ale andrei su-ubek rayah ale ta asih naso nyamon ja. Aso bala tanan bwe are handru atehei su-ubek silba udu mada ndrom taso.” ");
INSERT INTO lid_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ano ndramak ta lahou dah anya, “Ado sabudon ma ado badeh satikisiy. Sebwe Kindrei tado ma Kindrei ta tama ado atehei su-ubek udu mada ndrom tado.” Eme iy anya, “Jo ndrandrei su-ubek tado ta nyamon.” Ano iy andrei Simiyon eme len hawe oro. ");
INSERT INTO lid_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ano ndramak ta lohowan dah kuhi oro a asiu. Ano iy asuni gwa ta sikine kati oro ili, ma iy ale anyohan donki. ");
INSERT INTO lid_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Eme oro lihidiy lakou ta i ta Josep udu le, tasah Josep badeh ndratiye, i dah kameh oro aimon nyamon hawen na mada an ronoh la-uh. ");
INSERT INTO lid_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ano Josep eme asiu badeh oro andrei iri lakou nane anya ki tan dah ki bolo asiu hawen. Eme oro ala aluh andri bada munyak i tan. ");
INSERT INTO lid_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ano Josep ndremenya oro, “Ado ado mwasin de bwe? Ado mene tiye tek ta tama ado, ya iy udu mwasin ale? Iy bamak bwe le, ma boto-on tan kahis le?” ");
INSERT INTO lid_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Eme oro tiye, “Laban, tama aso badeh bamak bwe le, iy badeh boto-on tan kahis le.” Ano oro aluh andri i tan. ");
INSERT INTO lid_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Eme Josep anyolom nadu tinen Benjamin, tasah uru ma la-uh asahan ta badih ari le, eme iy tiye, “Iy doh nadu tine ado bahan ai, ala ado mene asehek tek en.” Eme Josep tiye, “Naduk Kindrei badeh atehei nyosowan i la-um.” ");
INSERT INTO lid_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ano badeh Josep ruwani oro, tasah ndrinen eden handru ta nadu tinen oro. Eme iy akohok andra-i handru ma iy ili bolo rum tan ma iy eden. ");
INSERT INTO lid_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ano Josep sikine madan, ano iy eme len, iy baden bwe ai. Ano iy tiye iri atiye nyamon eme. ");
INSERT INTO lid_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Josep badeh udu bada sau ari labai eme nyamon tan ili, ya nadu tinen oro badeh ado rasou labai. Ya iri lau badu Ijip badeh are len labai aimon nyamon tiri labai, tasah iri Ijip badeh winiyan baimon nyamon hawe iri Hiburu bwe, tasah iri Ijip badeh sumukok iri. ");
INSERT INTO lid_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Eme oro badeh manyah in hamon ta jaha toro. Kadok, ano Bwaneh, ano Silih, ano Sabak, ano Kubwe, ano So-on, i le buku doh ili taku ta iy bahan handru. Oro manyah ado bada sau ya batala oro badeh ili ta Josep. Eme badeh boho oro asak ta anyolom oro ari ari nane manyah ado andri i buku doh. ");
INSERT INTO lid_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Eme iri badeh akohok nyamon badu bada sau ta Josep badeh i noro. Ya nyamon i na Benjamin badeh solo-an labai, i buku none i na lau limeh. Eme badeh oro aimon nyamon ma a-un gwa ma oro asoh koha oro labwe. ");
INSERT INTO lid_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ano badeh Josep tiye sahou i ta ndramak ta lohowan tan ta atondrok asiu tan, “Ou anyuhi nyamon ma solo-an ki bolo ndrom toro lau kede-eh, winiya oro winiyan bwese-ei ma ou atehei su-ubek toro mari ki hamon bolo ndrom toro ari ari. ");
INSERT INTO lid_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ou atehei bwiniu tek le badeh ki bolo ndrom ta iy bahan ki hawe su-ubek tan ta kalom.” Eme iy mwesekei i le buku aliy in hamon ta boho Josep. ");
INSERT INTO lid_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ano na mandraben badeh oro au ma donki toro adek au. ");
INSERT INTO lid_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Oro bala len ta kon tinan handru bwe le badeh, Josep tiye i ta ndramak ta mwena ta atondrok iri lohowan tan badu bolo asiu, “Ou ala sakaniy oro lau nane. Ya i buku none ou ala tawi oro badeh, ou ndremenya oro ki buku doh, ‘Jo amwekes mwasin ewek tado, ya buku sah ado amwekes budon ndra-in i bada budon ndra-in? ");
INSERT INTO lid_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","I buku sah ado bene-ei bwiniu silba tek? Bwiniu doh badeh ala jo a-un gwa na aliy. Ma bwiniu doh badeh kau tek. Ado badeh ndrandra-i handru!’” ");
INSERT INTO lid_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ano ndramak ta lahou dah isos hawe oro, eme iy tiye sahou nane i toro. ");
INSERT INTO lid_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Eme oro anya, “Ou tiye sahou i buku badeh eme taso dah i buku sah badeh? Aso tandrakan handru aso babwidiy ari lakou bwe. ");
INSERT INTO lid_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ou tanam aso, aso mene andrei su-ubek mene udu bolo ndrom udu munyak Kenan mene ewek hamon. Ya ta saba katin handru aso kabene-ei silba badu asiu ta tinan tam? ");
INSERT INTO lid_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ndramak ta lohowan ta Laban, i buku none ou silahei are andrei, iy badeh kadai iy kimek ma aso mari badeh kasahan bonyo-ou tado.” ");
INSERT INTO lid_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ano iy anya, “Jo aseken budon badeh; arile iy ndramak le andrei bwiniu badeh kameh asahan bonyo-ou, ya ado mari ka-au ai.” ");
INSERT INTO lid_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Eme oro suri ndrom toro suwi i andri, ano oro sihiy ndrom toro. ");
INSERT INTO lid_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Eme ndramak ta lohowan takaleh bolo ndrom toro amwenen handru. Udu ta kadok ili taku ta iy bahan, eme iy ndruniy bwiniu dah udu bolo ndrom ta Benjamin. ");
INSERT INTO lid_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Eme oro sadi awin toro ma oro tikisiy labai, ano badeh oro atehei lakou toro i bwele-e donki toro, eme oro adek a hamon ja ala kon tinan. ");
INSERT INTO lid_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Oro ame hamon ame asiu badeh, Josep udu aliy le kahis. Eme oro aluh andri i tan, ");
INSERT INTO lid_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","eme Josep anya, “Ado mwesekei sasah handru dah? Ado badeh winiyan atanan jo badeh udu aliy winiyan takalahei ado na kau.” ");
INSERT INTO lid_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Eme Juda tiye, “Ndramak tinan, aso baratiye sasah handru barawek tam? Aso kandres ou barala buku sah? Aso katiye aso bwe barala buku sah? Kindrei badeh ndranyolom aso, aso badeh ndrandra-i. I dah kameh Benjamin le ari winiyan bala bonyo-ou tam le bwe, i dah kameh aso mari.” ");
INSERT INTO lid_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Eme Josep anya, “Bwe! Jo winiyan bamwekes kandriyen badeh bwe! I dah kameh iy ndramak le nane andrei bwiniu tek le kameh i bonyo-ou tek. Ado mari badeh ka-au ka hamon hawe tama ado ma mwasin.” ");
INSERT INTO lid_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ano badeh Juda ili hawe Josep tiye, “Ndramak ta tondrok, ou sabolosen, ou anuhun jo anya kasehek sahou tek. Ou sabolosen same tek; ou badeh i buku none le kabin. ");
INSERT INTO lid_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ou badeh mene ndremenya aso anya, ‘Tama ado udu aliy, ma hawe nadu tine ado udu aliy?’ ");
INSERT INTO lid_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Eme aso anya, ‘Ehe, aso badeh tama aso udu aliy ma hawe nadu tine aso udu aliy. Udu suniya tama aso i alon badeh iy atehei Benjamin ya nadu tinen ari badeh ndramak. Iy le ari badeh udu aliy; ma taman badeh aseken iy tinan labai.’ ");
INSERT INTO lid_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Eme ou mene tiye anya, aso badeh katiyani iy keme, eme badeh aso andrei iy eme ta ou badeh kanyolom iy. ");
INSERT INTO lid_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Eme aso mene tiye tam anya, taman badeh kameh winiyan batehei iy bwe, i buku none iy keme, kameh taman kameh imek. ");
INSERT INTO lid_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Eme badeh ou tiye anya, aso winyan bame bare madak bwe, i buku none nadu tine aso bame bwe. ");
INSERT INTO lid_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Eme na len aso ala hamon badeh aso tiye ta tama aso. ");
INSERT INTO lid_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ano badeh tama aso tiye aso badeh ame hamon ja kasih nyamon. ");
INSERT INTO lid_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Eme aso tiye tan, ‘Aso winiyan bala bwe; bala mada ndramak doh bwe i buku none nadu tine aso bahan bame hawe aso bwe. I buku none nadu tine aso bahan eme hawe aso, badeh aso winiya ala ai.’ ");
INSERT INTO lid_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Eme tama aso tiye taso, ‘Ado badeh tanan uduk Rejel badeh atehei nah i naduk badeh la-uh le. ");
INSERT INTO lid_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ya iy ari badeh ndramak. Sebwe iy badeh iri katin haka ndriliu ndrasadi iy, tasah kabatana aliy le badeh jo se batou madan bwe. ");
INSERT INTO lid_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Jo badeh ndra alon. I buku none ado andrei iy ewek kameh, jo kameh tikisiy ma na tikisiy tek i badan le kameh mwesekei jo imek!’” ");
INSERT INTO lid_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Eme Juda tiye, “Ndramak tinan, I buku none jo ki hamon ya tama kanyolom Benjamin bado hawek bwe kameh, i dah kameh iy imek. Iy badeh ndra alon labai ma budon tan badeh aso ta nah le dah, ya i dah kameh tikisiy tan le kameh kidiy iy kimek.” ");
INSERT INTO lid_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Eme Juda tiye ja, “Jo dah badeh ndratandrakan tama ta jo kameh akohok maha ta Benjamin; i buku none jo batiyani iy bala hamon hawe taman bwe, ma i dah kameh jo kameh akohok maha ta aliy winiya jo le baramak. ");
INSERT INTO lid_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Eme na dah ndramak tinan, jo kameh akohok kon tan asahan bonyo-ou udu; ou atehei iy ki-iu ki hawe nadu tinen oro. ");
INSERT INTO lid_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Jo winiyan bala hamon hawe tama bwe, i buku none Benjamin bame bwe. Jo badeh bwalek anyolom tama akohok maha ma isi ta aliy.” ");
INSERT INTO lid_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ano udu mada iri lohowan ta Josep badeh, Josep winiyan batawi iy bwe, eme iy tiye iri lohowan tan mari au. Ari ndramak badeh bare hawen bwe eme badeh iy asehek ta nadu tinen oro ta iy badeh are lau handru. ");
INSERT INTO lid_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Eme Josep tabani bohon i loken ta ndrelen eme badeh iri Ijip anuhun, eme badeh iri ala tandra-un ta kabin udu loboho ndrahu manyah tan. ");
INSERT INTO lid_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ano Josep tiye i ta nadu tinen oro, “Jo dah, Jo Josep. Tama udu loken kahis le?” Arile nadu tinen oro anuhun badeh oro toroyani oro eme oro batiye sahou bwe. ");
INSERT INTO lid_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ano Josep tiye i toro, “Abo, ado kameh mirihik.” Eme oro ame, ano iy tiye, “Jo dah, jo Josep ado mene atehei jo i ta sisih eme Ijip. ");
INSERT INTO lid_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ya ado sanoh ma ado satehei budon ndra-in sawek tado, tasah ado mene atehei jo i ta sisih eme Ijip, ndri-i. I doh badeh Kindrei le tiyani jo eme bwena ta aseben lau mari badeh samak. ");
INSERT INTO lid_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","I dah jaha la-uh ai, ta nyamon bwe udu bolo munyak dah; arile jaha limeh kahis, i dah kameh ari nyamon winiyan batahiy bwe ma i dah kameh ari len ta akohok nyamon bwe. ");
INSERT INTO lid_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kindrei atehei jo eme bwena dah i san randra labai, ta aseben ado ma lundriye ado samak. ");
INSERT INTO lid_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Eme i dah ado handru batiyani jo bame dah bwe, i dah Kindrei labai. Kindrei atehei jo asahan ndramak ta lahou tan badu bolo asiu ta kabin, ari ndramak ja bare bwele-ek bwe. Jo badeh atondrok munyak mari badu kon dah; jo badeh atondrok Ijip mari. ");
INSERT INTO lid_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Ya abo, ado ka hamon suwi ka hawe tama ma ado katiye tan i dah badeh boho nadum Josep: ‘Kindrei badeh ndratehei jo ndratondrok kon Ijip mari; ado kala ma ado kame suwi; ");
INSERT INTO lid_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ou ma hawe nadum oro ma nadu tubum oro, iri sipsip, iri me, iri bulumakau ma hawe lakou tam mari kame kamanyah kado loboho Gosen, kado mirihik tek. ");
INSERT INTO lid_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","I buku none ado ado Gosen badeh kameh madak kameh udu tado. Jaha limeh ta nyamon bwe badeh kahis le; eme jo badeh bwalek ou, ma hawe lowam oro ma hawe iri katin haka tado badeh sakohok sandra-i ta son.’” ");
INSERT INTO lid_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ano badeh Josep tiye le, “Ya ado mari, ma ou ale Benjamin, ado badeh ndranyolom jo badeh Josep handru. ");
INSERT INTO lid_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ado katiye ta tama ta jo badeh jo le ai udu Ijip ma ado kasehek tan ta lakou mari ado ndranyolom na mada ado. Ano ado kandrei iy suwi keme dah.” ");
INSERT INTO lid_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ano Josep korotani nadu tinen Benjamin ma iy eden; ma Benjamin tawi iy ma iy eden ale. ");
INSERT INTO lid_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ano badeh ma ndrelen le, iy korotani nadu tinen oro ma iy eden. Ano badeh ma nadu tinen oro asehek sahou hawen. ");
INSERT INTO lid_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ano na len sahou ili asahan ndranye kabin udu ndrahun manyah tan, ta nadu tine Josep oro badeh ndrame, eme badeh kabin hawe iri lau ta lahou tan badu bolo asiu tan badeh sekesek handru. ");
INSERT INTO lid_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Eme kabin tiye ta Josep, “Ou tiye ta nadu tinem oro ka lokou lakou ki la-u katin haka toro ma oro kala Kenan. ");
INSERT INTO lid_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Oro kala kandrei tama oro ma hawe lowa oro ano oro kame hamon. Jo kameh edeu munyak mwasin handru badu Ijip i toro, ma i dah kameh edeu toro lakou winiyan len oro ado ado. ");
INSERT INTO lid_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Oro katiye toro badeh andrei sau aliu na katin haka badu Ijip kili, ya udu oro ma hawe nadu oro ka la-un ma tama oro ki la-un ya oro ka tiyani oro kame dah. ");
INSERT INTO lid_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Oro badeh sabudon ta lakou toro mari, tasah lakou mari mwasin badu Ijip badeh kameh i toro.” ");
INSERT INTO lid_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ano nadu Jekop oro bwidiy i le buku aliy. Eme Josep atehei sau ta aliu na katin haka, i buku none mene ndratiye ma hawe nyamon i noro ta san. ");
INSERT INTO lid_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Josep ale edeu toro ari ari awin ta adeu ta asin, arile Benjamin le badeh iy atehei tonek silba boroh hawe limeh awin ta asin. ");
INSERT INTO lid_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ano iy atehei ta taman ronoh donki idih na lakou mwasin badu Ijip ma atehei ronoh donki ja idih na kalom hawe jabi ramen ma hawe nan rayah nyamon ta san. ");
INSERT INTO lid_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Eme badeh iy tiye ta nadu tinen oro au ai, ma iy tiye i toro, “Ado sandra-i sado san.” ");
INSERT INTO lid_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ano oro ruwani Ijip ma adek a hamon ala hawe tama oro Jekop ala Kenan. ");
INSERT INTO lid_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Eme oro tiye ta tama oro anya, “Josep badeh bamak bwe! Iy badeh atondrok kon Ijip mari!” Eme Jekop badeh andru-uk ma batehei budon tan bahis bala ta sahou toro handru bwe. ");
INSERT INTO lid_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Arile udu, oro asehek sahou mari badu boho Josep i tan, ano iy anyolom iri sau aliu na donki mene Josep atehei i mine oro badu Ijip eme badeh, ma balen aleu. ");
INSERT INTO lid_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Eme Jekop anya, “Naduk Josep badeh bamak bwe, iy udu kede-eh le! Jo kili kanyolom iy koro-an jo kimek.” ");
INSERT INTO lid_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ano badeh Jekop lokowani lakou tan mari ma iy iu ili Bersiba, eme badeh iy amwekes Salom i ta Kindrei ta taman Aisik. ");
INSERT INTO lid_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Eme badeh, na ben udu bolo ameh Kindrei asehek sahou i tan anya, “Jekop ei!” Eme Jekop asumon anya, “Jo kada-ah!” ");
INSERT INTO lid_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Eme iy anya, “Jo dah jo Kindrei, Kindrei ta tamam. Ou sanoh ta ala Ijip; jo kameh amwekes lundriyem oro kameh asola ma asahan kon rakon buruwen udu doh. ");
INSERT INTO lid_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Jo kameh udu hawem ewek Ijip ano jo kameh tiyani lundriyem oro kameh ame hamon ja ame munyak dah ja. Ou amak kameh Josep kameh udu hawem.” ");
INSERT INTO lid_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ano Jekop udu Bersiba eme len. Eme nadun oro badeh atehei tama oro Jekop, ma nadu oro bwisik ma hawe udu oro badeh, ado bolo asiu sau mene kabin atehei. ");
INSERT INTO lid_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Eme badeh oro andrei iri katin haka toro ma hawe lakou toro mari mene badu Kenan, eme oro adek ala Ijip. Jekop badeh kuhi nadun oro mari a hawen: ");
INSERT INTO lid_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","nadun oro, nadu tubun oro, nadu oro badih ma hawe nadu tubun oro, oro mari ano. ");
INSERT INTO lid_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ya kane lowa Isra-el oro ala Ijip hawen asa i doh: oro badeh kadok tan badeh Ruben, ");
INSERT INTO lid_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ma hawe nadun oro: oro badeh Hanok, Palu, Hesron ma hawe Karmi. ");
INSERT INTO lid_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ano Simiyon ma nadun oro badeh: Jemu-el, Jamin, Ohat, Jakin, Sohar ma hawe Sa-ul. Oro doh badeh badu ndrine udun badu Kenan. ");
INSERT INTO lid_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lebi ma nadun oro badeh: Gerson, Kohat ma hawe Merari. ");
INSERT INTO lid_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Juda ma nadun oro badeh: Er, Onan, Silah, Peres, ma Serah. (Ya nadu Juda uru ma la-uh badeh Er hawe Onan badeh amak ado ndra Kenan). Ya nadu Peres uru badeh Hesron hawe Hamul. ");
INSERT INTO lid_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakar ma nadun oro badeh: Tola, Pu-ah, Jasup hawe Simron. ");
INSERT INTO lid_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ya Sebulun oro nadun badeh: Seret, Elon hawe Jalel. ");
INSERT INTO lid_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Oro doh badeh nah nadu udu Jekop aloh Liya badeh, adeu oro ame len badeh ado Padan Aram ma hawe nadun badih ari badeh nyaran Dinah. Eme ya kane nadu Isra-el oro mari iu ndrine Liya badeh asahan tonoh taloh. ");
INSERT INTO lid_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ya i dah nadu Gat oro: oro badeh Sepon, Hagi, Suni, Esbon, Eri, Arot hawe Areli. ");
INSERT INTO lid_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ya nadu Aser oro badeh Imnah, Isbah, Isbi, Beriya ma hawe nadu tine oro badih Serah. Ya nadu Beriya oro badeh Heber hawe Malkiyel. ");
INSERT INTO lid_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Oro doh badeh ma ronoh onoh nadu Isra-el iu ndrine Silpah. Silpah doh badeh badih ta lohowan ta Leban eme Leban badeh atehei i ta nadun badih Liya. ");
INSERT INTO lid_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ano udu Isra-el Rejel badeh atehei nadu Isra-el la-uh le: badeh Josep uru Benjamin. ");
INSERT INTO lid_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Ano udu Ijip badeh Josep badeh nadun la-uh, uru badeh Manase hawe Ipra-im. Uru doh badeh au ndrine udu Josep nyaran Asenat. Ya Asenat badeh iy badih, nadu Podipera, pris badu kon On. ");
INSERT INTO lid_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ya nadu Benjamin oro badeh: Bela, Beser, Asbel, Gera, Naman, Ehi, Ros, Mupim, Hupim hawe At. ");
INSERT INTO lid_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Oro ma ronoh hahuw doh au ndrine udu Isra-el aloh Rejel. ");
INSERT INTO lid_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ano Dan badeh nadun badeh Husim. ");
INSERT INTO lid_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ya nadu Naptali oro badeh: Jase-el, Guni, Jeser hawe Silem. ");
INSERT INTO lid_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Oro ma ndro taloh doh nadu Isra-el badu ndrine Bilhah. Bilhah badeh badih ta lohowan ta Leban atehei i ta nadun badih Rejel. ");
INSERT INTO lid_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ya kane nadu Isra-el oro mari ma lundriye nadun oro ise ala Ijip badeh ma ndro hanoh onoh (66). I doh nadun oro le amwenen, bondrek udu nadun oro bwe. ");
INSERT INTO lid_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ano ja badeh nadu Josep uru ma la-uh adeu uru ado Ijip, eme kane nadu Isra-el oro hawe tama oro i se badeh asahan ndro tonoh (70) ala doh. ");
INSERT INTO lid_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ano badeh Jekop suni Juda ili badeh ta tiye ta Josep ma ta leheya san ki tan ta iy keme Gosen. ");
INSERT INTO lid_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Eme oro asahan badeh, Josep sandroh i bwele-e sau tan aliu na katin haka ma iy ili hawe taman ili Gosen. Eme iy isos hawe taman le badeh Josep akabah i la-u taman atehei minen i balen ma iy eden luluwen handru. ");
INSERT INTO lid_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ano Jekop tiye i ta Josep, “Jo badeh anya kimek ai, arile na dah jo ndranyolom ou ma jo ndratanan ai, ou badeh bamak bwe.” ");
INSERT INTO lid_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ano Josep tiye i ta nadu tinen ma hawe lowa taman oro mari, “Jo kameh ili hawe kabin asehek tan ta nadu tine oro ma hawe lowa tama oro mene manyah ado Kenan badeh ndrame hawek. ");
INSERT INTO lid_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Jo kameh tiye tan ta ado badeh lau ta atondrok iri katin haka ma ado badeh ndrandrei iri sipsip hawe iri bulumakau hawe lakou mari tado badeh ndrame. ");
INSERT INTO lid_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ya i buku none kabin kaloh ado kala, ya iy kandremeya ado ta lahou tado sasah handru, ");
INSERT INTO lid_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","badeh ado katiye tan, ‘Lahou taso handru badeh ta atondrok iri katin haka aso atondrok eme eme taku dah, i buku none tubu aso mene amwekes.’ I buku ado tiye i buku doh kameh, iy kameh atehei ado kameh manyah ado Gosen.” Josep asehek doh badeh, tasah iy badeh tanan iri Ijip badeh bwale iri ta atondrok iri katin haka ma sumukok iri lau atondrok. ");
INSERT INTO lid_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ano Josep kuhi nadu tine oro ma limeh ala hawe kabin. Eme Josep tiye i ta kabin, “Tama ma nadu tine oro badeh ado Kenan ndrame. Oro badeh ame ma katin haka toro ta aimon bwidiu, hawe lakou toro mari. Oro badeh are loboho Gosen.” ");
INSERT INTO lid_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ano iy leheya nadu tinen oro ala ta kabin. ");
INSERT INTO lid_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Eme kabin ndremenya oro, “Saba lahou tado?” Eme oro anya, “Lahou taso badeh ta atondrok iri katin haka sipsip, i buku none tubu aso oro bwena mene. ");
INSERT INTO lid_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Aso ame manyah ado munyak tinan dah, tasah munyak Kenan badeh nyamon bwe, ma bwidiu tiri katin haka taso ndrano. Ya eme aso ndremenya ou, ou winiyan atehei aso manyah ado loboho Gosen de bwe?” ");
INSERT INTO lid_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ano kabin tiye i ta Josep, “Na dah tamam hawe nadu tinem oro badeh ndrame, ");
INSERT INTO lid_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","eme munyak mari badu Ijip dah badeh i toro ai. Oro badeh kamanyah kado loboho munyak mwasin handru, udu loboho Gosen. Ma i buku none oro lau rayah mwasin ta atondrok katin haka ado bolo oro badeh, jo aseken oro katondrok katin haka tek ale.” ");
INSERT INTO lid_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ano ja Josep andrei taman ili leheya iy i ta kabin. Eme Jekop atehei nyosowan tan i la-u kabin. ");
INSERT INTO lid_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Ano kabin ndremenya Jekop anya, “Jaha tam sabe bah?” ");
INSERT INTO lid_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Eme Jekop tiye, “Jaha tek ta jo edek le badeh asahan rinek tonoh (130). Ya udu bolo oro jaha doh badeh sola bwe, arile jo akohok maha solo-an, bala buku none jaha ta tubu oro mene solo-an bwe.” ");
INSERT INTO lid_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ano Jekop atehei nyosowan i ta kabin ma iy iu i len tan. ");
INSERT INTO lid_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ano badeh Josep atehei taman hawe nadu tinen oro manyah ado Ijip. Atehei oro manyah ado munyak mwasin ma lakou mwasin udu bolo kon tinan aloh Ramisis i buku none le kabin ndratiye. ");
INSERT INTO lid_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ano Josep edeu nyamon i na taman, i na nadu tinen oro ma hawe i na nadu tinen oro bahan hawe lowa taman oro mari ale ya iy anyohan oro badeh in hamon ta kane nadun oro. ");
INSERT INTO lid_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ano badeh nyamon bwe badeh akohok andra-i handru, ma kon mari badeh nyamon bwe. Kon Ijip hawe Kenan badeh akohok andra-i labai. ");
INSERT INTO lid_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Eme iri badeh asih kalom ano Josep andrei su-ubek doh ili ndrahu kabin. ");
INSERT INTO lid_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ano na len su-ubek tiri Ijip hawe Kenan ano badeh, iri ame hawe Josep ndremenya, “Ou anyohan ahi nyamon! Bwe kameh ahi kamak ai! Su-ubek tahi badeh ndrasihinei ndrano.” ");
INSERT INTO lid_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Eme Josep anya, “I buku none su-ubek taha ndrano badeh, aha kadeu katin haka taha keme ta asih nyamon.” ");
INSERT INTO lid_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Eme badeh iri atiye katin haka tiri, iri katin haka aloh hos, iri sipsip, iri me, iri bulumakau hawe iri donki i mine Josep. Ano Josep edeu niri nyamon ili. Na jaha doh badeh Josep edeu nyamon i niri, tasah iri asih na katin haka tiri mari. ");
INSERT INTO lid_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ano udu jaha ari ja asahan badeh iri ame hawe Josep tiye, “Josep ahi winiyan batonei ari lakou ta madam bwe. Su-ubek tahi ndrano hawe katin haka tahi mari mene ndrawek tam. Ahi ari lakou ja ta edeu ewek tam ja bwe ai, arile ahi ndramak salin hawe munyak tahi le. ");
INSERT INTO lid_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ou samwekes ahi samak. Ou amwekes ari lakou! Ou samwekes bilin tahi sado leleyah. Ou asih munyak tahi na nyamon. Aso kameh a bonyo-ou ta kabin ya iy badeh kandrei munyak taso ki tan. Ou adeu naso kalom ma hawe ou adeu tahi badun ta atah ki bolo bilin tahi.” ");
INSERT INTO lid_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Eme Josep sihinei munyak mari udu Ijip i ta kabin. Eme andrei iri lau mari badu Ijip badeh adeu munyak tiri badeh i ta sisih; tasah nyamon bwe badeh akohok andra-i; eme munyak mari badeh asahan munyak ta kabin. ");
INSERT INTO lid_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Josep badeh mwesekei iri lau mari badu Ijip badeh asahan bonyo-ou. ");
INSERT INTO lid_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Munyak le iy basihinei bwe badeh, munyak tiri pris. Iri pris badeh badeu munyak tiri bala ta sisih bwe, tasah kabin badeh edeu niri nyamon mwasin udu le buku doh, ta iri badeh winiyan manyah ado aliy udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Eme Josep badeh tiye i tiri, “Aha ndratou, jo badeh ndrasihinei aha ma munyak taha ndra ta kabin. Ya buwa kalom ki taha ma aha atah ki bolo bilin taha. ");
INSERT INTO lid_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ya i buku none len ta nyamon kuni badeh, udu bolo nyamon taha ronoh badeh aha kadeu la-uh badu bolo ronoh ki ta kabin. Ya iri buwa kalom mari erah badeh ki taha ta atah ma ki ta nyumon taha ma lowa aha oro mari.” ");
INSERT INTO lid_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ano oro tiye, “Ou badeh amwekes kandriyen mwasin eme tahi; ma ahi bamak bwe. Ahi kameh a bonyo-ou ta kabin ai.” ");
INSERT INTO lid_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Eme Josep badeh mwesekei batanau boto-on i tiri lau mari badu Ijip ta kadeu la-uh badu bolo nyamon tiri ronoh ki ta kabin ki buku nyamon kuni. Eme kandriyen doh eme eme taku na len dah. Arile munyak tiri Pris le badeh bwe ai, bala ta kabin bwe. ");
INSERT INTO lid_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Iri lau badu Isra-el badeh manyah ado loboho Gosen udu Ijip. Eme iri badeh tiri lakou solo-an labai ma nadu iri badeh ndrasola le. ");
INSERT INTO lid_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jekop badeh manyah udu Ijip badeh winiya jaha ronoh ndro taloh, eme jaha tan mari ise badeh asahan rinek hanoh ndro taloh (147). ");
INSERT INTO lid_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ano len mirihik ta Jekop anya kimek badeh, iy luhi nadun Josep eme ano iy tiye i tan, “Josep ou atehei minem ki ndrokowa bak ma ou amwekes tandrakan ta ou badeh sahi jo sado Ijip dah ndri-i. ");
INSERT INTO lid_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Jo badeh aseken ou badeh ahi jo, kili hawe tama oro mene ado aliy; ou badeh tuwi jo udu Ijip dah ki len ma ou ahi jo badeh kudu hawe tama oro.” Eme Josep tiye, “Jo kameh amwekes i buku bohom badeh.” ");
INSERT INTO lid_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ano badeh Jekop tiye, “Ou tandrakan ta i dah kameh ou mwesekei.” Eme Josep tandrakan ma Jekop udu bada sau tan badeh edeu wurah. ");
INSERT INTO lid_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ano udu sese badeh iri tiye ta Josep ta taman badeh ndrabosik. Ano badeh Josep kuhi nadun uru ma la-uh, Ipra-im hawe Manase, eme oro ala hawe Jekop. ");
INSERT INTO lid_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Eme Jekop anuhun nadun Josep eme ta atou iy badeh, eme ma boto-on tan asahan ma iy suri iy ma iy manyah udu loken bada sau. ");
INSERT INTO lid_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ano Jekop tiye i ta Josep, “Kindrei tinan badeh asahan hawek udu kon Lus udu munyak Kenan badeh atehei nyosowan eme tek. ");
INSERT INTO lid_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Eme Kindrei tiye i tek i buku doh, ‘Jo kameh edeu nadum oro kameh asola ma lundriyem oro ari ari kameh asahan kon tinan rakon buruwen; ma jo kameh edeu munyak dah kameh i ta lundriyem i buku ari lakou i toro udu le buku doh.’” ");
INSERT INTO lid_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ano Jekop tiye le, “Josep, nadum uru ma la-uh, Ipra-im hawe Manase badeh adeu uru ado Ijip udu hamon ta jo asahan dah, arile uru badeh tek le, i buku none le Ruben uru Simiyon. ");
INSERT INTO lid_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Buku none ou adeu nah udu hamon turu ja badeh tek bwe ai; badeh tam labai; ya oro kameh akohok lakou badu mine Ipra-im uru Manase. ");
INSERT INTO lid_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Jo amwekes doh badeh, tasah ta tinem Rejel le. Na len jo udu Padan Aram eme len badeh ma aso are ndra munyak badu Kenan kahis le, ya aso bame mirihik ta kon Eprat bwele badeh Rejel imek. Eme jo amwekes tikisiy ano badeh jo ihiy iy udu ka-u san ili kon Eprat.” (Eprat kon doh na dah badeh aloh Betelehem). ");
INSERT INTO lid_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ano badeh Jekop anyolom nadu Josep uru badeh iy ndremenya, “Nadu are uru mwan dah?” ");
INSERT INTO lid_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Eme Josep anya, “Uru doh badeh naduk, Kindrei atehei eme tek na len jo udu Ijip dah.” Ano Jekop tiye, “Ou andrei uru kameh dah jo kedeu nyosowan ki turu.” ");
INSERT INTO lid_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Mada Jekop badeh anya kagwah, tasah iy badeh ndra alon labai, eme badeh iy winiyan banyolom kon bala mwasin bwe. Eme Josep andrei nadun uru badeh ame hawe Jekop, eme badeh Jekop tawi uru a batalan. ");
INSERT INTO lid_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ano Jekop tiye i ta Josep, “Jo mene anya i dah kameh jo winiyan banyolom ou bwe, arile Kindrei le mwesekei jo eme badeh ndranyolom ou hawe nadum uru mwan ma la-uh.” ");
INSERT INTO lid_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ano badeh Josep bwese-ei uru ado bada ba Jekop, ano iy aluh kandrun i andri bada munyak udu mada taman. ");
INSERT INTO lid_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ano Josep atehei Ipra-im udu bilisiu kamweu ta Jekop ya atehei Manase badeh udu bilisiu salin ta Jekop. ");
INSERT INTO lid_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Arile Jekop eme badeh atehei minen salin i sakan i bwele-e batu Ipra-im, aliy i bahan ai, ya minen kamweu badeh i bwele-e batu i kadok Manase. ");
INSERT INTO lid_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ano Jekop edeu nyosowan i la-u Josep: “Kindrei ala tama Abraham, tama Aisik ta atudun badeh katehei nyosowan ki la-u uru nah dah! Ma Kindrei ala udu hawek atondrok jo eme eme taku na len dah katehei nyosowan ki la-u uru le! ");
INSERT INTO lid_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Angelo ala sebenei jo ma lakou batok tek bwe badeh katehei nyosowan ki la-u uru! Eme ma iri katanan ah badeh badu hawek, hawe badu hawe tama Abraham uru Aisik kudu le buku doh! Ma lundriye uru badeh ki sola ma lundriye nadu uru ka sola!” ");
INSERT INTO lid_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Eme Josep badeh tikisiy handru ta anyolom taman badeh atehei minen salin i la-u Ipra-im; eme badeh Josep tawi mine taman udu bwele-e batu Ipra-im atehei i bwele-e batu Manase. ");
INSERT INTO lid_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Eme Josep tiye, “Tama bala buku badeh bwe. Iy kadok asah i dah; ou atehei minem salin ki bwele-e batun.” ");
INSERT INTO lid_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Eme taman bwalen ma iy tiye, “Naduk jo tanan. Lundriye Manase oro kameh asahan lau boto-on ale, arile lundriye nadu tinen oro bahan kameh boto-on labai ja ta iy kadok Manase, ma lundriyen oro kameh asahan solo-an ma kameh asahan kon tinan solo-an.” ");
INSERT INTO lid_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Eme na len doh badeh iy atehei nyosowan i la-u uru tiye anya, “Iri lau mari badu Isra-el kameh aloh nyara ah ta adeu nyosowan. Iri kameh aloh anya, ‘Kindrei kamwekes ou i buku none Ipra-im hawe Manase!’” San doh le badeh, eme badeh Jekop badeh atehei Ipra-im udu mwena ta Manase. ");
INSERT INTO lid_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ano Jekop tiye i ta Josep, “Ou badeh ndranyolom jo, jo badeh anya kimek ai, arile Kindrei le kameh udu hawem ma iy le kameh winiyan tiyani ou ala hamon ja ala munyak ta tubum oro. ");
INSERT INTO lid_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nadu tinem oro bwe ai, ou le badeh jo atehei kon Sekem i tam, i doh munyak mada lihin, jo mene andrei ta bahun udu mine iri Amora eme na boto-on ta samen hawe bonara tek.” ");
INSERT INTO lid_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ano badeh Jekop luhi nadun oro mari ame ano i tiye, “Ado mari kawudi jo, ya jo kasehek sahou ki tado ta sasah kameh asahan tado na len hamon kameh eme: ");
INSERT INTO lid_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Ado nadu Isra-el mari kame le se kanuhun tama ado. ");
INSERT INTO lid_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, ou badeh kadok tek, ma ou badeh boto-on tek Ma ou badeh kadok tek ou asahan mwena ma ou uni handru ta boto-on. Ou boto-on labai ja ta naduk mwan mari ma ou le ai. ");
INSERT INTO lid_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ou kameh budon tam bado rasi bwe i buku none wadah atohou, arile i dah kameh boto-on tam kameh ano, Tasah ou mene babeleben sau ta udu tamam ari bwe, eme ou ala amadin iy. ");
INSERT INTO lid_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Ya Simiyon ah Lebi badeh nadu tine ah. Ah badeh sahou ta-ah nyarahan ta amwekes bahun. ");
INSERT INTO lid_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Jo winiyan bawek hawe ah ta sahou kamu ta ah bwe. Ma jo winiyan bawek hawe ah na len ta asehek sahou bwe. Eme na losen ta-ah ma i dah kameh ah kameh atokos kati iri katin haka hawe amundroh lau leleyah. ");
INSERT INTO lid_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Jo batanau ah ka-i ai, tasah losen ta-ah badeh ndra-in handru Labai handru i buku siyer atohou eme i doh badeh ndra-in. Ah kameh winiyan bakohok ari munyak bwe, ma ah kameh aseker bolo munyak mari badu Isra-el dah. Ma iy ari i rasi labai ya iy ari iu i rasi labai ta lau badu Isra-el. ");
INSERT INTO lid_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Juda, ou kameh nadu tinem oro kameh atudun ou. Tasah ou ateu bale lau ta amwekes bahun ewek tam. Nadu tinem oro kameh kandru oro kameh aluh i andri tam. ");
INSERT INTO lid_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda, ou badeh boto-on i buku none katin haka layon; Ou adai iri lau ano, ou ame hamon ame ndrahunem ja, ame manyah ma ales boham hawe katim, Ari lau winiyan balisiy ou bwe. ");
INSERT INTO lid_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Juda, ou kameh kandro ta kabin kameh winiyan ba-au tam bwe, Ma lundriyem oro kameh asahan kabin le ai, Winiya le ndramak salin le barasahan. Iri kon munyak rakon rakon buruwen kameh atiye lakou i tam, Ma iri kameh aluh kandru i andri i nyara kalem ta anuhun sahou tiri i tam. ");
INSERT INTO lid_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ou kameh aseu donki kasen tam badeh i ta bada malou wa-in mwasin, ta bada wa-in seselek handru udu ta aliy. Ma ou kameh sikine awin tam na ndraye wa-in saraman. ");
INSERT INTO lid_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Madam badeh asaram i buku none wa-in le. Ma lihim badeh belen i buku none ma-o sur belen. ");
INSERT INTO lid_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulun kameh manyah tan kameh udu babi mirihik ta ndras. Madasu tan badeh mwasin tiri ndron gwa. Ya kobek tan badeh ili isos kon Sidon. ");
INSERT INTO lid_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar badeh boto-on labai ja ta donki. Iy amadin ndrokowa lakou ta ndrahu manyah badeh udu bwele-e donki. ");
INSERT INTO lid_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Arile iy badeh anyolom ndrahu manyah badeh mwasin labai, ma anyolom munyak badeh mwasin, Eme badeh iy aseken ta amwekes lahou, Eme ma iy akor ta ato-ou iri lakou. ");
INSERT INTO lid_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan kameh asahan ndramak ta anuhun sahou tiri lau tan, i buku none iri boho kamen ra-em ra-em badu Isra-el. ");
INSERT INTO lid_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan kameh asahan i buku none mwak udu ka-u san, ta atoh kati iri katin haka aloh hos, Ma ndramak manyah udu bwele-en kameh i bwak i le konan i andri. ");
INSERT INTO lid_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Laban, jo badeh abe-en ou ta aseben tam. ");
INSERT INTO lid_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gat kameh iri lau ta bahana kameh atohou a la-un arile iy kameh tikahei iri au. ");
INSERT INTO lid_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Munyak ta Aser kameh ateh ta nyamon mwasin, Ma na nyamon tan le doh kameh iy edeu i na kabin. ");
INSERT INTO lid_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naptali kameh i buku none katin haka aloh diya, Iy badeh konen ili labai ma iy asehek sahou mwasin ma iy kameh sakaliye leleyah ili eme. ");
INSERT INTO lid_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Josep kameh i buku none bada malou wa-in, seselek ka-u gwa. Eme badan badeh seselek i loken bada kabwek. ");
INSERT INTO lid_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Iri lau ta amwekes budon ndra-in i badan kameh ame amwekes bahun boto-on labai i tan, ma atikah iy na bonara hawe nyah, ");
INSERT INTO lid_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Arile bonara tan badeh boto-on labai, Ma iy badeh bohan boto-on labai, I doh badeh na boto-on ta mine Kindrei ta Isra-el, Ma na boto-on ta ndramak ta atondrok iri katin haka, iy bek ta Isra-el ta winiyan batokos bwe. ");
INSERT INTO lid_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","I dah badeh na Kindrei ta tamam le aseben ou, Ma i dah kameh Kindrei tinan le kameh atehei minen udu la-um, na nyosowan tan badu kandrah Ma na nyosowan ta gwa waru badu baha munyak, Ma na nyosowan tiri bulumakau hawe tiri nah, ");
INSERT INTO lid_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ma nyosowan ta tamam badeh sakalawi nyosowan ta kalom hawe kanyeu, Ma sakalawi nyosowan tiri mandrei kede-eh, Ma sakalawi nyosowan ta munyak mwasin badu ta buli ndrondro-ou kudu le buku doh, badeh kiroh keme la-u Josep, Tasah iy badeh udu mwena ta nadu tinen oro mari. ");
INSERT INTO lid_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin badeh i buku none ari mwi ndriliu, Na mandraben hawe na beyeh kameh iy abuyeh nyamon, Iy idiy ano iy aimon ma iy akohok rayah.” ");
INSERT INTO lid_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Oro ma ronoh la-uh doh badeh asahan boho kamen ma ronoh la-uh badu Isra-el. Eme i dah nyosowan ta tama oro edeu i la-u oro ari ari in hamon ta kandriyen toro. ");
INSERT INTO lid_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ano Jekop tiye sahou batanau i ta nadun oro, “Jo kameh iu i hawe tama oro ai, eme ado badeh katehei jo ki munu lek udu bilin ta Epron badu Hita. ");
INSERT INTO lid_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Munu bek udu kon Makpelah, mirihik ta Mamre udu Kenan, mene Abraham sihinei ta Epron badu Hita i ndrahu lek ta ndramak imek ma hawe bilin mari. ");
INSERT INTO lid_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ndrahune Abraham uru udun Sara, ndrahu Aisik uru udun Rebeka, ma jo mene ihiy Liya udu aliy. ");
INSERT INTO lid_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Munu bek doh udu aliy ma bilin badeh mene ndrasihinei badu tiri Hita.” ");
INSERT INTO lid_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ano Jekop asehek sahou ta batanau i ta nadun oro ano le badeh, iy suri katin ma luka i bada sau ma aden taku ma iy imek iu i hawe iri lau tan. ");
INSERT INTO lid_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Eme badeh Josep morohani iy i andri i la-u taman ma iy tawi buli taman ma iy eden. ");
INSERT INTO lid_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ano badeh Josep tiye i tiri lau ta komba ta atondrok taman. ");
INSERT INTO lid_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ili badeh winiya len ta komba asahan hanoh. Ya iri lau badu Ijip aden ili winiya len ndro tonoh. ");
INSERT INTO lid_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ano len ta ndrelen ano badeh, Josep tiye i tiri lau ta lahou ta kabin badu bolo asiu anya, “Ado katiyani sahou tek doh ki ta kabin: ");
INSERT INTO lid_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Na len suniya tama anya kimek badeh iy tiye, Jo badeh ndratandrakan ta a-eh iy kili munu bek mene iy ndralosowaniy udu munyak Kenan. Eme ya i buku none ou aseken eh, jo anya kili ka-eh tama ano badeh jo barame hamon ja.” ");
INSERT INTO lid_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Eme kabin anya, “Mwasin, iy kili kihiy taman i buku none iy mene ndratandrakan ta amwekes.” ");
INSERT INTO lid_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Eme badeh Josep iu ili a-eh taman. Eme iri lau ta lahou badu bolo asiu ta kabin, iri lau tinan ta anuhun sahou, ma hawe iri lau ta lahou ta mwena badu Ijip badeh a hawe Josep. ");
INSERT INTO lid_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ma udu Josep ma nadun uru, hawe nadu tinen oro mari ala. Ma hawe lowa taman, iri Isra-el, ala hawen ale. Arile nadu oro bwisik, hawe iri sipsip, iri me ma hawe iri bulumakau badeh ado loboho Gosen ado. ");
INSERT INTO lid_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Eme iri lau hawe sau aliu na katin haka mari ma lau ado bwele-e iri katin haka aloh hos, iri lau solo-an handru en a hawe Josep. ");
INSERT INTO lid_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ano len iri ame asos Atat kon ndrahu iri aburoh wit loboho rai ta Jordan badeh iri mari aden boho iri loken luluwen handru. Ma Josep tiye i tiri ado doh aden winiya len ma ndro taloh. ");
INSERT INTO lid_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Eme iri lau badu kati kon Kenan badeh anyolom iri lau nane aden ado Atat badeh iri tiye, “Iri lau badu Ijip badeh amwekes kabek ma aden tare doh!” Eme badeh iri tondrohani nyara kon doh ili Abel Misra-em, moson, “Iri Ijip aden.” ");
INSERT INTO lid_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Eme badeh nadu Isra-el oro badeh mwesekei i le buku tama oro mene tiye i toro. ");
INSERT INTO lid_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ano badeh iri bwese-ei iy ili atehei iy ili munu bek Makpelah loboho rai ta Mamre udu bolo bilin udu Kenan. Bilin mene Abraham sihinei ta Epron ndramak badu Hita i ta ndrahu a-eh ndramak imek. ");
INSERT INTO lid_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Josep ihiy taman ano badeh iy iu i hamon ja ili Ijip hawe nadu tinen oro hawe iri lau badu Ijip nane ala ta a-eh taman. ");
INSERT INTO lid_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Udu hamon ta tama oro imek badeh, nadu tine Josep oro tiye, “Ki buku sah kameh i buku none Josep badeh kabudon ndra-in keme tato ma i buku none iy kamwekes budon ta amwekes ki saluwen ta kandriyen ndra-in mene to amwekes i badan?” ");
INSERT INTO lid_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Eme badeh oro suni sahou ili ta Josep i buku doh: “Suniya tama to anya kimek badeh, ");
INSERT INTO lid_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","iy tiye tam badeh ta ou badeh balem sabudon ta kadriyen ndra-in mene aso amwekes ewek tam, ma i dah kameh aso kameh are baha Kindrei ta tamam.” Eme Josep anuhun badeh ma iy eden. ");
INSERT INTO lid_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ano badeh nadu tinen oro amwenen ala badeh kandru oro aluh i tan; Eme oro anya, “Aso are madam dah aso badeh bonyo-ou.” ");
INSERT INTO lid_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Arile Josep tiye i toro, “Ado sanoh; jo badeh winiyan bakohok kon ta Kindrei bwe. ");
INSERT INTO lid_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ado badeh amwekes kandriyen ndra-in eme tek, arile Kindrei badeh mwesekei asahan mwasin labai ta aseben lau mari are kede-eh, ma iri mari bamak bwe. ");
INSERT INTO lid_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ado badeh sanoh ta ari lakou. Jo kameh atondrok ado ma nadu ado oro.” Ano badeh Josep tiye budon mwasin i toro ma mwesekei ndrine oro ta tikisiy iu. ");
INSERT INTO lid_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ano badeh Josep badeh manyah udu Ijip le hawe lowa taman oro; eme badeh Josep badeh i alon, jaha tan ili asahan rinek ronoh (110) badeh ma iy imek. ");
INSERT INTO lid_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Iy badeh udu anyolom nadu tubun oro badu ndrine nadun Ipra-im. Iy anyolom nadu Makir oro; Makir badeh nadu Manase. Oro doh badeh i buku none nadun oro. ");
INSERT INTO lid_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ano Josep tiye i ta nadu tinen oro, “Jo badeh mirihik kimek ai, arile Kindrei kameh tondrokei ado kameh udu mwasin ma iy le kameh winiyan kuhiy ado ame len ma iy kameh tiyani ado ala munyak mene iy tandrakan i ta Abraham, i ta Aisik hawe Jekop.” ");
INSERT INTO lid_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ano badeh Josep tiye iri lau tan amwekes tandrakan. Eme Josep anya, “Ado katandrakan keme tek i buku none Kindrei kasariye ado ka hamon kala munyak Kenan badeh ado kakuhiy badak kewek.” ");
INSERT INTO lid_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Eme Josep badeh udu winiya jaha tan asahan rinek ronoh (110) badeh iy imek. Iy imek badeh udu Ijip. Eme iri lau ta komba atondrok badan ma atehei iy i bolo kes. ");
INSERT INTO lid_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Udu bolo len tiri Isra-el bwena, Kabin badeh atondrok kon tiri. Eme bwidiy nyamon winiya iri bwe. Eme ndramak ari badu Betlehem, udu loboho Juda, lokowaniy iy, udun ma nadun uru ma la-uh, iy andrei oro au ala loboho kon tiri Mowap. ");
INSERT INTO lid_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Nyara ndramak doh badeh Elimelek, nyara udun Nawomi; nyara nadun ma la-uh badeh Malon uru Kiliyon. Oro badu boho kamen ta Eparata. ");
INSERT INTO lid_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Oro ado, ano badeh, Elimelek imek, nyau tan hawe nadun uru ma la-uh ado ai. ");
INSERT INTO lid_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Nadun uru ma la-uh badeh atasou, uru andrei butuhu Mowap ma la-uh. Nyara uru badeh Opa uru Rut. Oro manyah ado Mowap badeh, winiya jaha ma ronoh. ");
INSERT INTO lid_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Ano badeh Malon uru Kiliyon amak. Eme tine uru Nawomi le ari udu ai, udun ma nadun uru ma la-uh ndramak. ");
INSERT INTO lid_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Nawomi udu Mowap badeh iy anuhun Laban atehei nyosowan i tiri lau tan i ta nyamon tiri. Eme Nawomi alokou iy ma nyanan uru ma la-uh ala hawen ta ala kon tan Juda. ");
INSERT INTO lid_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Oro tuwiy lokou toro ma oro adek au ala hamon ala Juda. ");
INSERT INTO lid_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Oro ala ado ndrukulu san ranah badeh, Nawomi asehek i ta nyanan uru, anya, “Ah kala hamon ka kon ta ah. Ma ah kala kado hawe tine ah. Laban badeh kameh amekes mwasin ewek ta ah buku ah amekes mwasin ndrame tek, ma toro ma taloh ndramak. ");
INSERT INTO lid_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Ma i dah kameh Laban katehei ah ka asiu ja.” Nawomi eme tawi uru ma uru taku a ta ndrelen. ");
INSERT INTO lid_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Uru ame tiye i ta Nawomi, “Bwai, aru kameh an hamon tam ala hawe iri lau tam.” ");
INSERT INTO lid_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Nawomi anya, “Bwai, ah nadu nyanak ma la-uh, ah ka hamon ai. Buku sah ah anya kame hawek nane? Naduk ndraheh ja kameh ah katasou ka turu? ");
INSERT INTO lid_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Ah kala hamon ai. Jo winiya bala tasou ja bwai, buku jo ki tasou ja na ben kameh, jo katuwiy la-uh nah mwan ja? ");
INSERT INTO lid_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Ah kameh atondrok uru a tinan, ano, ah barala turu? I dah kameh bwidiy ah winiya batasou bala ta ari mwan ja bwai! Ah naduk badih ma la-uh, ah tana ah. Laban ndratehei konan ndrame tek, eme ma jo tikisiy ah ma la-uh en!” ");
INSERT INTO lid_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Eme badeh uru ma la-uh atehei boho uru i ta ndrelen ja. Ano Opa tawi nyanan Nawomi ma iy eden. Ano ma iy iu i hamon. Arile Rut badeh bwalen ta ili hamon. ");
INSERT INTO lid_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nawomi eme tiye tan, “Rut, kayom ndra-au ndrala hamon ndra hawe lowan oro ai, ma hawe kindrei tan. Ou ala hawen ale!” ");
INSERT INTO lid_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Eme Rut anya, “Ou sasabolon jo, jo badeh anya kewek hawem; buku saba kon ou ala aliy, jo kameh ewek ale. Saba kon ou ado aliy, jo kameh udu aliy ale. Buku lowam oro, badeh kameh lowak ale; buku Kindrei tam badeh, kameh Kindrei tek ale. ");
INSERT INTO lid_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Buku ou amak ado heh, jo kameh imek udu hawem ale, ma ahiy jo udu kon nane jo imek udu aliy. Jo bwalek ari lakou kabwidiy ndrokowa talu kudu aliy. Imek le badeh kameh bwidiy ndrokowa talu ai. Jo tandrakan en, buku jo ba-en hamon ta sahou tek nane jo asehek bwe eh, i dah kameh Kindrei amekes se lakou maha-an eme tek.” ");
INSERT INTO lid_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Nawomi anyolom Rut badeh winiya baruwaniy iy bwe, eme iy basehek sahou ja bwai. ");
INSERT INTO lid_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Eme uru ma la-uh adek ala asos Betlehem. Uru asos le badeh, mani iri lau atur, eme iri badih anya, “Kede-eh Nawomi handru deh?” ");
INSERT INTO lid_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Nawomi tiye ili toro anya, “Ado saloh jo Nawomi. Tasah Kindrei, boto-on marakon udu tan badeh, bwidiy tikisiy tinan labai eme tek. ");
INSERT INTO lid_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Jo mene iu badeh, lakou tek solo-an labai. Ano Laban anya kandrei jo keme hamon ja badeh, tek ari lakou ja bwe. Ado saloh jo Nawomi ai, tasah Laban boto-on labai badeh, atehei maha-an solo-an eme la-uk.” ");
INSERT INTO lid_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Nawomi uru nyanan Rut, i badih badu Mowap, ame hamon kon ta Nawomi ja. Uru asahan Betlehem badeh, udu bada len tiri ta akohok nyamon iri aloh bali, badu bilin tiri. ");
INSERT INTO lid_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Bowas badeh iy nadu batun, iy badeh badu hawe udu Nawomi bwena Elimelek. ");
INSERT INTO lid_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Len ari badeh Rut tiye i ta Nawomi i buku doh: “Jo anya kili bolo bilin anya kanyidiu na talu bali, iri lau mwan nane mwetehei, erah in andri, buku ari ndramak aso-ok jo kanyidiu bali ki-in hamon tan.” Nawomi anya, “Mwasin, ou ala.” ");
INSERT INTO lid_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Eme Rut edek iu ili bolo bilin. Iy edek in hamon tiri lau ta amondroh ma iri lau ta atukum bali. Iy anyidiu nan iri bali erah in andri. Iy anyidiu ili, ili, eme ma iy i tanan bilin dah ta ndramak ari nyaran Bowas. Bowas badeh, badu boho kamen ta Elimelek. ");
INSERT INTO lid_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Bowas udu Betlehem eme anya katou oro lau tan. Iy eme isos, iy anyolom oro le badeh, iy anya, “Laban udu hawe ado.” Eme oro lau tan tiye sahou sekesek i tan anya, “Laban atehei nyosowan tan ewek tam.” ");
INSERT INTO lid_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Bowas eme ndremenya ndramak ta atondrok oro lau tan, “Are badih bihin kodo-oh?” ");
INSERT INTO lid_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Eme ndramak ta atondrok oro lau tan anya, “Iy badih bihin kodo-oh, iy badu kon Mowap. Iy in hamon ta Nawomi, uru ame dah. ");
INSERT INTO lid_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Iy eme ndremenya jo anya, iy aso-ok ta edek in hamon tiri lau anya kanyidiu nan bali. Iy anyidiu na mandraben eme isos nane dah, eme i dah iy baramunyau adeh, in bolo mandron kodo-oh.” ");
INSERT INTO lid_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Eme Bowas tiye ta Rut i buku doh, “Naduk badih, ou anuhun, jo anya kabatanau ou. Jo bwalek ou ala anyidiu bare bali badu bilin ta ndramak ari ja. Jo aso-ok ou anyidiu bare bali badu dah le kabwai. Ou ado, ma ou abo gok hawe oro badih tek kede-eh. ");
INSERT INTO lid_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ou anyolom bilin, ma ou an hamon toro. Buku oro anya katukum bare bali badeh, ou ado hawe oro. Jo ndrabatanau oro lau tek ale ta oro sanyolom ndra-in sawek tam. Buku balem anya kamar ta gwa, ou ala a-un gwa udu bolo sabok oro lau tek ndrasuniy.” ");
INSERT INTO lid_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ano Rut atubwa bwilindru-un ma bwilin ili andri ta munyak, ma iy anya, “Jo badih leheleh labai, buku sah ou anyolom jo, ma ou amekes mwasin eme tek?” ");
INSERT INTO lid_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Bowas tiye i ta Rut i buku doh, “Iri lau tiye tek badeh ta lakou marakon ou amekes an hamon ta nyanam Nawomi udu ndrabada len udum imek. Jo tanak ou ruwaniy tamam uru tinem, ma kon tam amwenen; i buku sah handru ou ame dah manyah ado bolo kon rakon ja, lau rayah ja, ou bala tanam iri bwena bwe. ");
INSERT INTO lid_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Laban Kindrei tiri Isra-el kasihinei ou, ta iri lahou ou ndramwesekei. Ou ado bahandran ma iy kameh turukiy ou udu mwasin, i buku nadu kakaro udu bahandra bani tinen.” ");
INSERT INTO lid_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut anya, “Ou badeh amekes kandriyen mwasin labai eme tek. Ndramak tinan, ou ale batanau jo tiri sahou mwasin. Jo badih mwasin bwe, bala buku oro badih tam kede-eh. Arile ou badeh asehek sahou ta batanau eme tek ma bwidiy ndrinek udu mwasin ja.” ");
INSERT INTO lid_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Oro anya kaimon nyamon ai. Bowas eme aloh Rut anya, “Ou ame dah. Ou aimon raon jabi ramen, ou atehei jabi ramen kili bolo wain, ou aimon.” Rut eme manyah udu andri hawe oro badih ta lahou ta Bowas. Bowas eme atehei na Rut bali raon iri ndraturuhiy le. Rut andrei ma iy aimon ili ma ndrinen irek, arile nyamon tan raon erah. ");
INSERT INTO lid_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Rut suriy iy, iy edek ili bolo bilin le badeh, Bowas eme tiye toro lau tan anya, “Iy kudu gwek kanyidiu kabede iri rabos, rabos nane in andri kodo-on! Ado sabolosen sala tan. ");
INSERT INTO lid_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ado kasoh raon bare bali badu bolo iri nane ndrabawei ndrarabos, kili tan. Ma jo bwalek ado sasehek iy.” ");
INSERT INTO lid_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Rut badeh anyidiu bare iri bali mari ili le se isos an amai. Iy tukumwiy marakon ili le se ano, iy ubwiy bare iri bali dah, eme maha-a salin asahan kilo ma ronoh. ");
INSERT INTO lid_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Iy eme bwese-ei ndrom bali tan, ma iy edek iu ili bolo kon tinan ma iy leheya ili ta nyanan, ta bare bali sabe iy tukumwiy, ma iy leheya bakatikibwah tan ili ta nyanan ale. ");
INSERT INTO lid_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Nawomi ndremenya iy, “Ou nane atukum bare bali badu loboho heh le? Bilin tare lau handru ou nane abo gok an bolon? Kindrei atehei nyosowan kili ta ndramak nane atou ou ma sebenei ou!” Rut asehek ili ta Nawomi anya, “Jo nane ibo gok in bolo bilin ta ndramak ari nyaran Bowas.” ");
INSERT INTO lid_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nawomi tiye tan, “Laban kanyosowaniy iy! Laban winiya bamaniy tandrakan tan i tiri lau ndramak ma iri lau bamak bwe le.” Eme Nawomi asehek ja, “Iy ndramak badeh badu hawe to handru en! To badeh boho kamen ari le. Iy kameh atondrok talu.” ");
INSERT INTO lid_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Ano Rut anya, “Bowas tiye tek i buku doh, jo badeh kibo gok hawe oro badih tan winiya le gok ta atukum bare iri bali marakon ano.” ");
INSERT INTO lid_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Nawomi tiye Rut, “Nadu nyanak, i dah kameh kandriyen ndra-in buku ou ala abo gok ala bolo bilin ta ndramak ari ja. Kora-on lakou kasahan tam ja. Mwasin ta ou abo gok le hawe oro badih ta Bowas ai.” ");
INSERT INTO lid_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Eme Rut ibo gok udu le mirihik hawe oro badih ta Bowas. Oro atukum bare bali ili, ili winiya le bare iri bali ma wit marakon ano. Eme ma iy in hawe nyanan udu gwek. ");
INSERT INTO lid_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Nawomi eme tiye Rut i buku doh, “Jo kameh atik ou a bahandra ari mwan, ma ou ki tam asumwem amwenen.” ");
INSERT INTO lid_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Nawomi anya, “Rut, ou anuhun, ndreh Bowas badeh, ou ale abo gok hawe oro badih tan badeh, iy badu mirihik tato handru en! Ou anuhun, ben kameh iy ili ndrahune gok, ta amekes bwisi bali iu. ");
INSERT INTO lid_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Abo, ou ala anyu, ano ou solowei suluw ki badam. Ou nyosowaniy ou na ra-ei awin tam mwasin handru en! Ano, ou ala mirihik ta ndrahune gok tan, arile iy satou ou, ma iy sala tanan ou labai. Ou atondrok an aliy winiya le iy aimon nyamon ma a-un gwa tan ano labai en! ");
INSERT INTO lid_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Buku iy manyah in andri, anya kamadin badeh, ou anyolom ndrahunen ta matinou kamwenen. Buku ou atou iy ndramadin tuk badeh, ou ala sihiy kolau ta katin ki-iu, ano ma ou amadin an hamon ta katin. Ano kameh iy barasehek budon tan barawek tam ai.” ");
INSERT INTO lid_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut anya, “Mwasin, jo ndranuhun bohom, i dah kameh jo in le ta budon tam baden ai.” ");
INSERT INTO lid_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ano Rut edek ili ndrahune gok tan ta aleben bali, i buku le nyanan Nawomi ndrasihidiy tan. ");
INSERT INTO lid_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Bowas aimon nyamon ano, eme ma nyamon sekeyani iy, ma bwidiy madan anya kamadin. Iy eme edek ili akahei iy in bata bali marakon iri tukumwiy i se badeh, ma iy amadin. Rut anyolom iy ano badeh, iy edek amwunum le ili sihiy kolau ta katin iu, ma iy amadin in katin. ");
INSERT INTO lid_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ili ben alih badeh Bowas soro-on ma iy anya katobolowe iy, eme ma manin atur ta atou badih ari amadin in katin. ");
INSERT INTO lid_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Bowas eme aloh, “Ou are lau?” Rut eme asumon, “Jo Rut, jo badih ta gok tam ari ai. Jo tanak, ou badeh badu hawe Elimelek. I dah kameh jo aso-ok ou atondrok jo, ma ou aseben jo, ma jo kewek tam ai.” ");
INSERT INTO lid_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Bowas anuhun boho Rut ano iy eme tiye i ta Rut i buku doh: “Laban nyosowaniy ou. Naduk, kandriyen ou amekes eme tek badeh, udu bwele-e kandriyen mara-ei ou amekes i ta nyanam Nawomi ma bwena handru. Ou basilah ari ndramak loweu bwe eh! Iy nadu batun, deh, nadu batun bwe deh, ou a tasou a tan.” ");
INSERT INTO lid_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ano Bowas anya, “Mwasin, Rut ou sanoh. Lau marakon an bolo kon dah badeh tanan ou badih ari mwasin. Saba lakou ou aso-ok badeh, jo winiyan.” Boas anya, “Badeh handru, jo badeh badu hawem, ma jo badeh kameh atondrok ou. ");
INSERT INTO lid_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Arile ndramak ari udu kede-eh badeh, badu hawem handru ai. Jo badeh bwe. ");
INSERT INTO lid_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Mwasin, i dah kameh ou ado. Bi-i ma ndraben talu baranuhun iy ndramak doh. Buku iy abudon ta atondrok ou eh, mwasin. Buku bwe eh, i dah kameh jo atondrok ou ai. Sahou tek badeh handru labai. Laban badeh ndratanan, kabwe. Abo, ou ala hamon amadin winiya le mandraben.” ");
INSERT INTO lid_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Eme iy ili hamon amadin in hawen ili winiya kon aleu. Rut badeh bwalen iri lau atou iy, eme iy amak mandraben handru en, tasah Bowas bwalen ari lau i tanan ta Rut udu hawen. ");
INSERT INTO lid_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Bowas anya, “Rut, ou talahaniy ra-ei kolau tam ki-in andri.” Rut eme bwidiy i buku le bohon oh. Bowas eme solowei bali ili bwele-e kolau nane dah. Maha-an ta bali doh asahan kilo ma lunoh. Bowas eme aseben iy suriy ili konan. Ano Rut tuwiy ma iy iu ili hamon ili kon tinan. ");
INSERT INTO lid_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Rut ili isos kon hawe nyanan. Eme Nawomi ndremenya iy, “Naduk, ou amekes i buku sah handru?” Rut eme asehek i ta Nawomi ta iri lakou marakon Bowas amekes i tan. ");
INSERT INTO lid_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Rut anya, “Iy bwalen jo eme hamon hawem leleyah, iy eme anyuhiy na talu bali dah.” ");
INSERT INTO lid_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Nawomi anya, “Ou ado le, anyolom saba lakou handru kameh asahan. Na len dah kameh iy winiya bamunyau bwe, winiya le sahou ma budon tan marakon amwenen.” ");
INSERT INTO lid_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Bowas eme edek ili manyah udu mada san i kon tinan, ndrahune iri ta atukum. Iy manyah udu le badeh, iy anyolom i ndreh nane badu hawe Elimelek oro dah edek eme. Eme Bowas aloh iy, “Borak, ou ame, talu kamanyah sese o.” Iy eme edek ili manyah udu hawen. ");
INSERT INTO lid_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Ano Bowas ili andrei oro kabin ma ronoh badu bolo kon tinan dah ame manyah ado hawe uru ale. Oro ame manyah ado andri. ");
INSERT INTO lid_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Ano Bowas asehek i ta boran, “Nawomi mene udu kon tiri Mowap, iy badeh ndrame hamon. Iy aso-ok ari ndramak kasihinei munyak mene ta bora to Elimelek. ");
INSERT INTO lid_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Eme ma jo anya kanuhun ou ta aliy. Buku ou aso-ok eh, mwasin, ou sihinei na le dan, udu mada oro kabin ma ronoh manyah kede-eh. Buku ou bwalem eh, ou asehek kamwenen, tasah ou le badeh kabwai. Buku ou bwe eh, badeh kameh jo ai.” Eme iy ndreh dah anya, “Jo kame isih munyak doh.” ");
INSERT INTO lid_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Bowas eme tiye i tan anya, “Buku ou kameh asih munyak udu mine Nawomi uru nyau badu Mowap, mwasin, ou andrei Rut ale kewek udum. I dah kameh munyak kudu ndra mine ado lowa iy ndramak mene ndramak ndra-au.” ");
INSERT INTO lid_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Ndreh dah anya, “Anya i buku baden eh? Jo winiyan ta isih munyak badeh bwai. Jo bwalek ta apou iri lokowak ili ta naduk oro amwenen hawe nadu ndramak ari ja. Jo kameh bwai, ou sihinei ki tam ai.” ");
INSERT INTO lid_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Kandriyen tiri Isra-el bwena ta apou, o ta adeu, o ta akohok munyak badeh, i buku doh: Buku sahou amwenen badeh kameh ndramak ari kameh tolowei ku-i katin iu, iy atehei ili ta ari ndramak ja. I doh ta leheya munyak doh ndra tan. ");
INSERT INTO lid_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ndreh nane dah asehek ili ta Bowas, “Mwasin, ou sihinei ai.” Iy eme tolowei ku-i katin iu, iy eme atehei i ta Bowas. ");
INSERT INTO lid_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Ano Bowas asehek i toro kabin ma ronoh dah ma lau rayah ja, “Aha marakon ndranuhun, ma aha ndranyolom, Jo badeh ndrasihinei lakou mara-ei ta Elimelek, ma nadun uru Malon uru Kiliyon udu mine Nawomi. ");
INSERT INTO lid_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Jo asehek i buku doh: Rut badeh badu kon tiri Mowap, iy badeh nyawe Malon, Jo kameh andrei iy i uduk. Jo amekes i buku doh ta iri lokowa Malon badeh, kudu ndra hawe nyawen. I buku nyaran in ta munyak ma i dah kameh nadun oro winiya bamaniy bwe. Buku na len dah aha marakon ndranyolom.” ");
INSERT INTO lid_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Oro kabin ma ronoh nane dah ma iri lau mari anya, “Ehe! Ahi ndranuhun, ma ahi ndranyolom. Ahi asolom Laban kameh kasebenei iy badih badeh ewek asiu tam. Iy ki le buku Rejel uru Leya. Uru badeh tuwiy nah solo-an labai, eme bwidiy lau badu Isra-el i sola labai. Ou kameh asahan nadu batun, badu boho kamen ta Eparata, bolo Betlehem kameh nyaram le kabwe. ");
INSERT INTO lid_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Laban winiya atehei ta ah nah solo-an, ma lundriyem oro winiya asahan a tinan i buku lundriye Peres, nadu Juda uru Tamar mwan.” ");
INSERT INTO lid_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Bowas eme andrei Rut i udun, ma iy eme andrei iy ili asiu tan. Laban atehei nyosowan i ta Rut, ma Rut nah udu tan. Eme ma iy tuwiy nah mwan. ");
INSERT INTO lid_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Iri badih ame asehek i ta Nawomi, “Katutuniy nyara Laban. I deh, iy ndratehei nah ari mwan kede-eh ndra nadu bwiliyem ta aseben ou. Ma nyaran kameh iri Isra-el winiya bamaniy bwe. ");
INSERT INTO lid_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Nyanam badeh aso-ok ou labai! Ma iy badeh bwidiy gok tam solo-an labai, bala buku ndro taloh nadum badu ndrinem amwenen bwe. I deh, iy ndratehei tam nah ari ma nah kede-eh kameh bwidiy manyah tam hamon kameh udu mwasin, ma iy tondrokei ou winiya le imek tam.” ");
INSERT INTO lid_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Nawomi eme bwese-ei iy, tukuniy iy udu batalan ma iy tondrokei iy. ");
INSERT INTO lid_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Iri badih badu kon doh badeh asehek anya, “Nawomi badeh ndratuwiy nah mwan ari.” Eme oro badih nane ame tondrohaniy nyaran ili Obet. Eme Obet badeh i tama Jesi, eme ja Jesi i tama Debit. ");
INSERT INTO lid_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","I dah Sare tubu Debit oro udu ndrabada Peres eme asahan ta Debit: Peres tuwiy Hesron, Hesron eme tuwiy Ram, Ram eme tuwiy Aminadap, Aminadap eme tuwiy Nason, Nason eme tuwiy Salmon, Salmon eme tuwiy Bowas, Bowas eme tuwiy Obet, Obet eme tuwiy Jesi, eme ma Jesi tuwiy Debit. ");
INSERT INTO lid_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Laban asehek sahou i ta nadu Amitai nyaran Jona. ");
INSERT INTO lid_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Laban tiye i buku doh: “Jo aso-ok ou suriy ou, ou ala bolo kon tinan Ninibe. Ou tiye sahou boto-on kili tiri mwan ma badih ki buku doh, ‘Laban ndranyolom aha amwekes kandriyen ndra-in solo-an labai.’” ");
INSERT INTO lid_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ano le badeh, Jona suriy iy, iy atobwak ta Laban. Iy atobwak ili kon tinan Jopa. Iy ili badeh iy anyolom ndron ta jam ra-ei badeh, alokou ta sakaliye kili Tasis. Iy ili ndremenya ndramak ta atondrok ndron. Eme ndramak ta atondrok ndron aso-ok, ano iy tiye Jona ta isih ndron ta iy ili bolon. Iy sihinei ndron ma iy sandroh ili bolon ta ili Tasis. Ano ndron alakak ta ili Tasis. ");
INSERT INTO lid_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Eme Laban bwidiy jor abakak udu no-o ndron toro. Jor eme bwidiy bayau atohou a tinan, ma bwidiy ndron anya katahan. ");
INSERT INTO lid_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Iri lau ta ndron nane dah ndranoh ndrandra-i labai. Iri ame aden ili ta kindrei tiri labai. Ano, oro ame sihiy bolo ndron, oro akeh lakou raon ili bolo bayau, ta amwekes ndron katelebek. Arile Jona ndramadin tuk in bolo ndron andri handru on! ");
INSERT INTO lid_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Ndramak tinan ta atondrok ndron dah ili andri bolo ndron, iy mete-ei Jona. “Ou amadin ta sah? Ou amak, ou asolom kili ta kindrei tam. Sebwe kindrei tam kameh winiyan anuhun to, ma iy winiya aseben to samak.” ");
INSERT INTO lid_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Eme oro lau ta ndron asehek sahou boto-on labai, anya, “Abo, kandrei nyara taha marakon ado bolo ndron dah, katukumwiy kise, kanyuhiy kili bolo ari ndrom, ano kasoroya, buku nyara are lau taku badeh, i doh iy le ai.” Eme oro soroya ili badeh, nyara Jona taku. ");
INSERT INTO lid_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ano le badeh oro lau ndremenyaniy Jona, “Abo, ou tiye taso, ou bwidiy saba lakou handru? Buku sah handru laba jor ndra-in atohou eme bwele-e to? Abo, ou tiye taso, saba gok tam handru? Ou badu heh handru? Saba kon tinan tam handru? Ou badu hawe lau heh handru?” ");
INSERT INTO lid_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Ano Jona tiye i toro, “Jo badeh badu Hiburu. Jo inoh Laban Kindrei badu kandrah. Iy badeh Kindrei, iy bwidiy ndras ma kon munyak.” ");
INSERT INTO lid_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Jona eme tiye i toro, “Jo badeh atobwak ta Laban.” Eme badeh oro lau ta ndron dah anuhun, eme ma bwidiy oro anoh andra-i labai. Eme oro tiye i ta Jona anya, “Ou badeh, bwidiy kandriyen ndra-in handru en! Tasah ou atobwak ta Laban!” ");
INSERT INTO lid_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Jor ma bayau atohou ili laba tinan le ai. Eme oro lau ta ndron dah ndremenyani Jona, “Aso kamwekes saba kandriyen handru kewek tam, ta bayau kameres ma aso ma ndron kasakaliye kudu mwasin?” ");
INSERT INTO lid_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Jona tiye i toro, “Ado kabwese-ei jo, kakahei jo kili bolo ndras. I dah kameh ma jor amondrei ma bayau ameres. Tasah, jo le adeh bwidiy, ma jor atohou eme bwele-e to.” ");
INSERT INTO lid_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Arile oro bakahei iy bala bolo ndras bwe. Oro ame a ta bahau anya kabahau oro kala amik, arile winiyan bwe. Jor ma bayau abadok udu le gwek ai. ");
INSERT INTO lid_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Oro ame aden ili ta Laban. “Laban, aso asolom ou; ou sadiy aso buku aso akahei Jona kili bolo ndras. Tasah iri budon dah, tam. Eme ma, bwidiy iri lakou mari asahan.” ");
INSERT INTO lid_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Ano oro bwese-ei Jona, eme oro akahei iy ili bolo ndras. Eme ma jor amondrei ma bayau ameres. ");
INSERT INTO lid_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Oro ame anyolom, ma oro anoh Laban tinan labai. Oro adi katin haka ari i ta salom, ano oro atudun Laban, ma tandrakan ta a hamon tan. ");
INSERT INTO lid_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Eme badeh Laban tiye laba tine kon ni ari eme le badeh, sakalamiy Jona iu ili bolo ndrinen. Jona in bolo ndrine ni doh winiya taloh len, taloh ben. ");
INSERT INTO lid_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Jona udu bolo ndrine ni badeh, iy asolom ili ta Laban Kindrei tan. ");
INSERT INTO lid_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Jona anya, “Laban, jo ndrandra-i ai. Jo aloh ewek tam, eme ma ou anuhun bohok. Jo ale udu kon ndra-in tiri lau ndramak. Jo eme eden ewek tam, ma ou ame anuhun ndrelen tek. ");
INSERT INTO lid_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","“Ou akahei jo, iu amai ili bolo ndras andri handru on! Ndras tubuluhiy jo amai mara-ei. Eme ou bwidiy goi atohou eme bwele-ek. ");
INSERT INTO lid_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Jo eme asehek i buku doh. Ou ndratikahei jo ndra-au. Arile jo kameh atou asiu tam ndrabun ja. ");
INSERT INTO lid_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","“Goi atohou eme bwele-ek, ma bwidiy kohak anya kano. Eme ma ndras tubuluhiy jo mara-ei. Korak badu bolo ndras badeh tabuwiy batuk. ");
INSERT INTO lid_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Jo badeh iu ili andri kati iri mandrei marakon udu bolo ndras. Budon tek badeh anya, jo kameh erah udu gwek. Arile Laban, ou Kindrei tek handru. Ou andrei kohak eme hamon ja. ");
INSERT INTO lid_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Laban, jo atona buku jo anya kimek, eme bwidiy jo abudon ou ja. Ma salom tek ewek asahan tam udu bolo asiu tam ndrabun handru. ");
INSERT INTO lid_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","“Iri lau badeh atubwa bwilindru-u iri i ta kindrei ta wendreya, iri maniy san mwasin ta an hamon tam. ");
INSERT INTO lid_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Arile jo anya kiyah wariy ta atudun nyaram, ma jo anya kedeu salom kewek tam. Lakou mari jo ndratandrakan ndrawek tam badeh, kameh jo kabwidiy. Laban, ou le ari, badeh, ou andrei ahi ame hamon hawem, ma ou atehei koha ahi eme hamon ja.” ");
INSERT INTO lid_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Eme ma Laban tiye ni, ma ni eya ili babi ma iy amuriy Jona ili loke bada babi. ");
INSERT INTO lid_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Udu rasan ja badeh, Laban asehek sahou ili ta Jona. Laban anya, ");
INSERT INTO lid_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Ou suri ou, ou adek ala bolo kon tinan tiri Ninibe. Sahou jo ndrasehek tam mene badeh, jo aso-ok ou ala tininiy kili tiri badih ma mwan badu bolo kon tinan Ninibe.” ");
INSERT INTO lid_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Jona badeh in le hamon ta boho Laban. Eme ma iy iu ili Ninibe. Ninibe badeh, kon laba tinan labai. Buku ndramak anya kedek kudu bilisiu kili bilisiu badeh, winiya len taloh. ");
INSERT INTO lid_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Jona edek ili bolo kon tinan Ninibe. Len ari ma buruwen badeh, iy edek le ai. Iy ili isos alih le badeh, iy asehek i tiri lau ai. Iy anya, “Buku len ma hanoh ano badeh, kon Ninibe kameh bohon ili andri.” ");
INSERT INTO lid_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Eme badeh iri lau mwan ma badih badu kon Ninibe badeh anuhun sahou ta Kindrei udu boho Jona. Iri ame atehei budon tiri marakon i le ta Kindrei. Iri anya, “Taha kabeles taha ta nyamon. Taha lau bwele-en ma iri lau ado baha taha badeh, kasin awin ta tikisiy, ta leheya tikisiy tataha.” Iri ame bwidiy i buku iri lau tinan tiri tiye. ");
INSERT INTO lid_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Sahou ili asahan le ta Kabin tiri Ninibe le badeh, iy suriy iy eme len ta koyeu tan. Iy asiniy awin tan mwasin iu, iy eme asiniy awin ndra-in ta tikisiy ili la-un. Iy ili manyah udu bolo koloweh, ta leheya tikisiy tan. ");
INSERT INTO lid_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Iy eme tiye sahou boto-on labai ili bolo kon tinan Ninibe i buku doh: “Jo Kabin ma oro lau tek, aso aso-ok aha lau mwan ma badih kabeles aha ta nyamon. Aha mwan ma badih, iri bulumakau, iri sipsip, taha badeh saimon nyamon ma sa-un gwa. ");
INSERT INTO lid_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Taha marakon ma iri katin haka tataha badeh, kadeu awin ndra-in ta tikisiy kili bwele-e taha. Ma taha kaden boto-on kili ta Kindrei, ta kandriyen ndra-in taha amwekes, ma taha kamaniy iri kandriyen ndra-in ki-iu. Taha katehei budon kili ta Kindrei le ari. ");
INSERT INTO lid_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Buku taha ka-en hamon tiri budon marakon don eh, sebwe Kindrei kameh kamaniy budon ta losen, ma taha winiya bamak bwe.” ");
INSERT INTO lid_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Kindrei eme anyolom iri, iri maniy kandriyen ndra-in tiri nane iri amwekes, eme ma iy tikisiy iri, ma iy bamwekes maha-an bala tiri bwe, i buku ma bwena iy anya kamwekes. ");
INSERT INTO lid_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Arile Jona badeh basekesek bwe, eme ma bwidiy ndrinen ibolosen, tasah Kindrei batubuniy boho kon bala andri bwe. ");
INSERT INTO lid_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Jona eme asolom, “Laban, jo tanak, i dah kameh lakou asahan. Jo i tanak badeh udu ndra kon tek, i doh le badeh bwidiy jo mene atobwak ili Tasis. Jo tanak ou badeh, Kindrei. Ou ta leheya kandriyen ta tikisiy. Ou winiya babolosen suwi bwe. Tikisiy tam badeh tinan labai. Jo tanak, ou kameh maniy kandriyen ndra-in, ma ou winiya bamwekes maha-an bala toro bwe.” ");
INSERT INTO lid_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","“Laban, jo anya kandremenya ou, jo aso-ok ou andrei jo kimek ki-iu. Jo bwalek ta udu. Buku jo kimek, i dah kameh mwasin ai. Buku jo bamak bwe badeh, i dah kameh ndra-in.” ");
INSERT INTO lid_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Laban eme asumon sahou ta Jona anya, “Ou abolosen badeh, katin sah?” ");
INSERT INTO lid_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jona eme edek ili manyah udu loboho an eme loken. Iy eme bwidiy nadu mandron ra-em ta iy in korohan ma iy atondrok, ma iy anya kanyolom saba lakou handru kameh asahan ta kon tinan Ninibe. ");
INSERT INTO lid_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Laban Kindrei eme bwidiy badamalou ari ateh ma seselek ili bwele-e mandron ta Jona. La-u badamalou dah eme turukiy an basulumwiy batun bwe, eme bwidiy Jona sekesek handru en. ");
INSERT INTO lid_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Udu mandraben, an eme loken. Kindrei eme tiye koromweh ari ili iniy kandro badamalou dah, ma malou dah asara. ");
INSERT INTO lid_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","An eme loke udu le alih badeh, Kindrei eme ja bwidiy jor rai nyarahan labai eme ma an nyarahiy batun ma bwidiy madan abuluw, ma bwidiy iy nyamun bwe. Jona anya, “Jo kimek badeh kameh mwasin ai. Buku jo bamak bwe, badeh kameh ndra-in.” ");
INSERT INTO lid_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Kindrei eme tiye ta Jona i buku doh: “Badamalou badeh asara eme bwidiy ou abolosen neh? Ou abolosen badeh, katin sah?” Jona eme asehek sahou ja, “Ehe, losen tek badeh amwenen. Jo ibolosen badeh, winiyan bwidiy jo kimek ki-iu.” ");
INSERT INTO lid_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Eme Laban tiye i ta Jona i buku doh: “Badamalou badeh ateh na ben, iy asara na ben ari ja. Ou bamwekes ari lakou bala tan bwe, ma ou babwidiy iy batinan bwe. Arile ou tikisiy badamalou badeh, tinan labai. ");
INSERT INTO lid_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Badeh kameh tikisiy tek tinan ili ta kon Ninibe, tasah Ninibe badeh kon tinan labai. Ma kane iri badih ma mwan udu bwele-e kane 120,000 ja. Ma bulumakau tiri badeh solo-an labai.” ");
INSERT INTO lid_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Idah nyara tubu Jises Krais, nadu Debit, iy ale nadu Abraham. ");
INSERT INTO lid_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Udu bada Abraham eme isos bada kabin Debit, kane tubun oro mari ndratorowenei: Abraham atehei Aisik, Aisik atehei Jekop, Jekop atehei Juda hawe nadu tinen oro mari. ");
INSERT INTO lid_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ano Juda atehei Peres uru Sera, tine uru badeh Tamar, Peres atehei Hesron, Hesron atehei Ram, ");
INSERT INTO lid_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram atehei Aminadap, Aminadap atehei Nason, Nason atehei Salmon, ");
INSERT INTO lid_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon atehei Bowas, Bowas badeh tinen Rahap, Bowas atehei Obet, Obet badeh tinen Rut, Obet atehei Jesi, ");
INSERT INTO lid_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi atehei kabin Debit. Udu kabatana kabin Debit eme isos bada len iri tawi iri lau badu Isra-el au ala bolo kou ala Babilon, nyara tubu iri ale ndratorowenei: Debit atehei Solomon, ya tinen bwena badeh udu Uraya. ");
INSERT INTO lid_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon atehei Rehobowam, Rehobowam atehei Abijah, Abijah atehei Asa, ");
INSERT INTO lid_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa atehei Jehosapat, Jehosapat atehei Jehoram, Jehoram atehei Usiya, ");
INSERT INTO lid_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya atehei Jotam, Jotam atehei Ahas, Ahas atehei Hesekaya, ");
INSERT INTO lid_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaya atehei Manase, Manase atehei Amon, Amon atehei Josaya, ");
INSERT INTO lid_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya atehei Johowakin ma nadu tinen oro. Ma udu bada len doh badeh, iri tawi iri Isra-el a bolo kou ala Babilon. ");
INSERT INTO lid_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Udu bada len tiri Isra-el ndrame len ta bolo kou udu Babilon, eme isos bada len ta Jises Krais asahan, nyara tubun oro mari badeh ndratorowenei: Johowakin atehei Seyaltiyel, Seyaltiyel atehei Serubabel, ");
INSERT INTO lid_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel atehei Abiyut, Abiyut atehei Eliyakim, Eliyakim atehei Asor, ");
INSERT INTO lid_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor atehei Sadok, Sadok atehei Akim, Akim atehei Eliyut, ");
INSERT INTO lid_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyut atehei Eliyesa, Eliyesa atehei Matan, Matan atehei Jekop, ");
INSERT INTO lid_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop atehei Josep, Josep udu Mariya, ya Mariya tuwi Jises, aloh iy Krais; Kindrei suni iy eme ta akohok iri lau tan ame hamon. ");
INSERT INTO lid_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ya idoh sare tubu Jises Krais udu ndra bada Abraham eme isos bada kabin Debit sare oro asahan ronoh hahuw (14). Ya ronoh hahuw (14) ja udu bada kabin Debit ili isos bada iri Isra-el ado bolo kou ado Babilon, ya ronoh hahuw (14) ja udu bada iri Isra-el ado bolo kou ado Babilon eme isos bada Jises Krais asahan. ");
INSERT INTO lid_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Idah sare Jises Krais eme asahan. Tinen Mariya san tan ta tasou ili ta Josep, arile bwena turu, uru bala tasou bwe le, Mariya badeh ndratanan iy kameh tuwi nah ari na boto-on ta Malawin Ndrabun. ");
INSERT INTO lid_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep badeh iy ndramak ari ta amekes kandriyen mwasin, arile iy bwalen ta asehek Mariya eme lewan ta lau mari sanuhun; eme ma iy amekes budon ta iy kisan tasou turu ki-iu kamunum le. ");
INSERT INTO lid_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Arile iy abudon kahis le badeh, angelo ari ta Kindrei asahan ta Josep udu bolo ameh ya asehek i buku doh, “Josep nadu Debit, ou sanoh ta akohok Mariya ewek udum. Tasah, na boto-on ta Malawin Ndrabun Mariya susune nah. ");
INSERT INTO lid_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Iy kameh tuwi nah mwan, ya ou kameh tondrohani nyaran Jises, tasah iy kameh sebenei iri lau ta karei ma lomondra ndra-in.” ");
INSERT INTO lid_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lakou mari doh asahan ta amekes amwenen sahou ta Kindrei iy ndrasehek ndrala tiri propet asahan ili handru: ");
INSERT INTO lid_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Badih ari bamadin hawe mwan bwe kameh susune nah ya iy kameh atehei nah mwan, ya idah kameh iri lau aloh iy Imanyuwel (moson i buku doh, “Kindrei udu hawe taha”). ");
INSERT INTO lid_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ya Josep amak eme loken, iy andrei Mariya i udun, i buku none sahou angelo ta Kindrei ndrasehek tan ta amekes. ");
INSERT INTO lid_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Arile, iy bamadin hawe udun bwe winiya len ta Mariya atehei nadun mwan. Eme ya Josep tondrohani nyaran Jises. ");
INSERT INTO lid_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Hamon ta Jises ndrasahan udu Betlehem udu bolo kon tinan Judiya, udu bada len ta kabin Herot, oro lau ta tanan badu loboho an eme loke ame Jerusalem, ");
INSERT INTO lid_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ma oro ndremenya, “Iy nah nane ndrasahan ma iy kameh asahan kabin tiri Juwis, iy ndraheh? Aso anyolom ndrau tan anya udu loboho mada an eme loken, eme ma aso ame dah ta atudun iy.” ");
INSERT INTO lid_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kabin Herot anuhun, eme ma manin atur labai, ma mani iri lau mari badu Jerusalem atur ale. ");
INSERT INTO lid_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eme iy aloh iri lau ado batu tinan tiri pris ma iri lau tanan ta leheya batanau malen mari ame le se ma iy lelen oro, “Mesaya kameh asahan heh?” ");
INSERT INTO lid_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eme oro lau nane dah tiye anya, “Udu Betlehem bolo kon tinan Judiya. Tasah propet, lau ta atiye sahou ta Kindrei ndratorowenei: ");
INSERT INTO lid_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Arile ou Betlehem ado bolo munyak Judiya, ou basahan hamon toro kon ale nyara oro tinan udu bolo munyak Judiya bwe handru. Idah kameh ndramak ari badu hawe aha amwenen kameh asahan, ma iy kameh asahan ndramak ta atondrok iri lau tek Isra-el.” ");
INSERT INTO lid_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ano Herot aloh oro lau ta tanan nane amunum le ame, ma iy ndremenya oro ta len amwenen ta ndrau asahan. ");
INSERT INTO lid_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ano iy suni oro ala Betlehem, ma iy tiye i toro i buku doh, “Ado kala kasilah kamwenen ta iy nah badeh. I buku none ado ala silahei iy, sahou keme tek ja. Ya jo ale, anya kewek katudun iy.” ");
INSERT INTO lid_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Oro anuhun sahou ta kabin Herot, ano ma oro au, ya ndrau mene anya udu loboho an eme loke, ili ja anya udu bwena toro ili udu bwele-e kon amwenen iy nah dah asahan udu aliy. ");
INSERT INTO lid_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Na len oro atou ndrau anya, oro sekesek handru. ");
INSERT INTO lid_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Oro ame asos asiu, oro atou nah dah udu hawe tinen Mariya, eme ya oro atehei bwili ndru-u oro i andri, ma atudun nadun. Ano oro aseh kohei kohoya luk toro, ma adeu gol hawe suluw ta amekes kasu-er ili manahun mwasin, ma hawe kei ta suluw aloh mer. ");
INSERT INTO lid_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na ben oro amadin ma oro ameh Kindrei batanau oro sala hamon ja sala hawe kabin Herot, oro kala hamon kala kon toro kala san rasan ja. ");
INSERT INTO lid_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Udu bada len oro anya ka-au le badeh, angelo ta Kindrei ari eme tiye ta Josep udu bolo ameh na ben. Iy tiye i buku doh, “Ou amak! Ou andrei iy nah hawe tinen, ma ado katobwak ka-au kala Ijip. Ado kado gwek winiya jo le baratiye ou, tasah Herot kameh asilah iy nah dah ta idi iy kimek.” ");
INSERT INTO lid_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep amak eme loken iy andrei iy nah dah hawe tinen ma oro atobwak na le ben au ala Ijip. ");
INSERT INTO lid_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Iy udu gwek winiya le kabin Herot imek, ma idah mesekei sahou asahan handru ma amwenen le i buku Laban ndrasihidiy i ta propet: “Jo aloh naduk eme len ta Ijip.” ");
INSERT INTO lid_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot i tanan oro lau ta tanan badeh, ndrawendreyani iy. Eme ma iy ibolosen handru ma iy atehei sahou boto-on i tiri lau ta bahun tan ta kadai iri nah mwan mari badu Betlehem. Iri nah doh ala jaha tiri udu kalama jaha la-uh eme andri. Iy atehei sahou ta adai nah mwan mari kamak, amwenen ta len iy i tanan ma iy seleyani oro lau ta tanan. ");
INSERT INTO lid_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Eme ma, sahou mene propet Jeremaya asehek badeh, asahan handru ma amwenen le: ");
INSERT INTO lid_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Bohon aloh udu kon Rama, ndrelen tinan ma hawe tikisiy tinan. Resel eden ndranye nadun oro, eme ma iy bwalen lau samekes ndrinen samwenen ja ai, tasah nadun oro ndrano ndra-au.” ");
INSERT INTO lid_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hamon ta Herot imek, angelo ari ta Kindrei asahan ta Josep udu bolo ameh udu Ijip, ");
INSERT INTO lid_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ma iy tiye i buku doh: “Ou amak, ou andrei iy nah kede-eh hawe tinen, ado ka-u kala hamon kamanyah kado munyak Isra-el. Oro lau mene anya kanone kadai iy nah dah kimek, oro ndramak.” ");
INSERT INTO lid_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eme ya Josep amak iy andrei iy nah dah ma hawe tinen oro au ala hamon ala munyak Isra-el. ");
INSERT INTO lid_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Arile Josep anuhun Akela-us ja badeh, atondrok Judiya, ma iy akohok ndrahune taman Herot. Eme ma bwidi iy inoh ta ili loboho doh. Arile, udu bolo ameh ta Josep, Kindrei batanau iy ta oro ka-au kala loboho Galili. ");
INSERT INTO lid_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Eme ma iy ili manyah udu kon ari aloh Nasaret. Ya sahou dah asahan ma amwenen le i buku le iri propet ndrasihidiy: “Idah kameh iri aloh iy lau badu Nasaret.” ");
INSERT INTO lid_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Udu bolo oro len doh Jon ta alomwa eme bwena atiye sahou ma asehek sahou udu bolo kon lomale an ta Judiya. ");
INSERT INTO lid_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ma iy asehek i buku doh, “Aha katobolowe ndrine aha, tasah tondrok ta Kindrei ndrame mirihik.” ");
INSERT INTO lid_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Idah iy le propet Aisaya asehek ta nyala aliy, “Ndramak ari aloh udu bolo kon lomale an i buku doh, ‘Kalowosa san ta Laban, ma kadik san kales lewan.’” ");
INSERT INTO lid_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon isin awin iri amekes na lami kamel, ma iy edeu ku-i bulumakau udu bada ndrukulun i buku malou ta aseu awin tan. Iy badeh, kaniyan sabaye ma hawe bwirik badu lokei. ");
INSERT INTO lid_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iri lau badu Jerusalem, badu Judiya ma iri lau badu kon mari badu loboho Jodan ame hawen. ");
INSERT INTO lid_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Eme ma iri asehek budon ma lomondra ndra-in ta karei tiri i ta Kindrei, ma iy alomwa iri ta sikine kandriyen ndra-in tiri iu udu gwa Jodan. ");
INSERT INTO lid_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Arile iy atou ja iri Parasi ma hawe oro Sadusi ame le hawen, ta iy kalomwa iri, eme ma iy tiye i toro Parasi ma Sadusi i buku doh: “Ado nadu mwak ndra-in. Are lau tiye ado ta atobwak au a len ta losen ta Kindrei kameh eme? ");
INSERT INTO lid_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ado kadeu nah ma ado kabatanau oro ta oro katubuni ndrine oro ta kandriyen ndra-in toro ki san ta tikisiy. ");
INSERT INTO lid_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ya ado sabudon ado ma satiye ado sala buku doh: ‘Aso badeh tama aso Abraham, eme ya aso anya, aso mwasin le ai.’ Arile bwe. Jo katiye tado kamwenen: Kindrei winiyan mesekei bek dah asahan i nadu Abraham. ");
INSERT INTO lid_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Samen kamondrou ta Kindrei badeh, ndrala ndrado mwe-e kei, ya iri kei ala bato-ou sali iri bala mwasin bwe, idah kameh amundroh iri ala andri, ano ma akeh iri au ala bolo jih. ");
INSERT INTO lid_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jo alomwa ado na gwa ta leheya ado badeh, ndratubuni ndrine ado ma ado tikisi kandriyen ndra-in tado. Arile ndramak ari in hamon tek eme kameh, boto-on tan badeh, sakalawi boto-on tek ja. Jo badeh, mwasin handru bwe, ta bwese ku-i katin bwe. Iy kameh inyu ado na boto-on ta Malawin Ndrabun ma aleben ado buku jih. ");
INSERT INTO lid_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Iy andrei lakou tan udu minen ta asorok bada kalom eme len lewa salin ma iy kameh atukum sali kalom tan ili asiu ta asumwe nyamon, ma idah kameh iy asun iri bada kalom ili bolo jih ta winiyan bamak bwe.” ");
INSERT INTO lid_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jises udu Galili eme amwenen ili gwa Jodan ta Jon kinyu iy. ");
INSERT INTO lid_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Arile Jon bwalen, eme iy tiye i buku doh, “Ou nane anyu jo ah, anya jo kinyu ou ja?” ");
INSERT INTO lid_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Eme ya Jises tiye i buku doh, “Ou anyu jo ma idah kameh talu mesekei iri lakou Kindrei anya talu kamekes.” Eme ma Jon aseken. ");
INSERT INTO lid_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon ta alomwa anyuwi Jises le badeh, ma Jises eme loken ta gwa Jodan ma nawin bwe kandrah asak, ma iy atou Malawin Mwasin ta Kindrei atah i buku ban eme andri amwenen le bwele-en ma manyah udu bwele-en. ");
INSERT INTO lid_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Eme ya aloh ari udu kandrah tiye i buku doh, “Badeh naduk handru, jo aseken iy labai, iy le mesekei jo sekesek handru tan.” ");
INSERT INTO lid_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ano Malawin Ndrabun andrei Jises iu ili kon lomale an ta balik kanone iy. ");
INSERT INTO lid_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hamon ta Jises abeles iy ta nyamon udu bolo hanoh (40) len hanoh (40) ben eme ma iy imeson. ");
INSERT INTO lid_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ya balik eme asahan hawen, ma iy tiye i buku doh, “I buku none ou anya ou Nadu Kindrei, ou asehek sahou kili toro bek dah kasahan jabi ramen.” ");
INSERT INTO lid_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Eme ya Jises tiye i buku doh, “Ndratorowenei, ‘Lau winiyan balelei le jabi ramen ta samak bwe, arile na sahou mari eme len asahan boho Kindrei.’” ");
INSERT INTO lid_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ano balik andrei iy, uru au ala Jerusalem kon ndrabun, eme ma balik atehei iy ales udu bwele-e no-o asiu tinan ta Kindrei loken on. ");
INSERT INTO lid_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ano balik tiye i tan i buku doh, “Ou anya ou Nadu Kindrei handru eh, ou akahei ou ado dah ala andri. Tasah i buku ndratorowenei, ‘Kindrei kameh edeu sahou batanau ili tiri angelo tan ame ta aseben ou. Ma idah kameh, iri bwese-ei ou, ma bek winiyan batahi katim bwe.’” ");
INSERT INTO lid_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jises tiye i buku doh i tan, “Ndratorowenei ale, ‘Ou satehei Laban Kindrei tam sala ta bolo none.’” ");
INSERT INTO lid_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ano ja balik andrei iy uru au ala bwele-e mandrei ari lawe-en, eme ma balik leheya iy ta boto-on ma lomadan tiri kon tinan mari badu munyak, iri kabin atondrok. ");
INSERT INTO lid_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Eme ma balik tiye i ta Jises i buku doh, “Jo winiyan atehei lakou mari dah ewek tam, i buku ou atehei bwili ndru-um i andri keme tek, ma atudun nyarak.” ");
INSERT INTO lid_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jises tiye i tan i buku doh, “Ou a len, Satan, tasah ndratorowenei ale, ‘Ou atudun le nyara Laban Kindrei tam, ma ou a-en hamon tan le ari kabwe.’” ");
INSERT INTO lid_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ano ya balik ruwani iy udu, ma iy iu, eme iri angelo ta Kindrei ame bwese-ei Jises ma aseben iy. ");
INSERT INTO lid_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na len Jises anuhun iri ndratehei Jon ta alomwa ndrala bolo kou, iy iu ili Galili ja. ");
INSERT INTO lid_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ano iy ruwani Nasaret ma iy iu ili manyah udu Kapena-um. Ya kon doh udu mirihik ta gwa li ari udu bolo munyak ta Sebulun ma udu bolo munyak ta Naptali. ");
INSERT INTO lid_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iri lakou doh asahan ta amekes sahou dah abadok ma i handru i le buku propet Aisaya ndrasihidiy: ");
INSERT INTO lid_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Munyak ta Sebulun ma munyak ta Naptali, san amwenen ili ndras amwenen le ta Jodan. Ya Galili badeh, munyak tiri lau badu leheleh, ");
INSERT INTO lid_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ya iri lau badeh ado bolo lulik arile iri ndratou lomadan tinan ndrasahan; udu bwele-e oro lau ale ado bolo munyak udu koroha imek eme ya lomadan ndrasahan tiri.” ");
INSERT INTO lid_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Udu bada len doh Jises asehek sahou ma bwena handru, eme ma iy tiye i buku doh: “Ado katobolowe ndrine ado, ma ado katikisiy handru ta kandriyen ndra-in tado, tasah tondrok ta Kindrei ndrame mirihik.” ");
INSERT INTO lid_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jises edek kabede gwa li Galili ma iy atou Saimon, iri aloh iy ale Pita, uru nadu tinen Enduru. Uru akeh kubwin ili bolo gwa li ta akohok ni, tasah uru lau ta bwisir ta ni. ");
INSERT INTO lid_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Eme Jises tiye i turu i buku doh, “Ah kame ka-en hamon tek. Ya idah kameh jo leheya ah san ta akohok lau.” ");
INSERT INTO lid_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Eme ya nawin bwe uru ruwani kubwin turu, ma uru au a-en hamon tan. ");
INSERT INTO lid_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iy edek ili bwena ja, ma iy atou Jemis nadu Sebedi hawe nadu tinen Jon. Uru ado bolo ndron hawe tama uru Sebedi, lowosa kubwin toro. Jises eme aloh uru, ");
INSERT INTO lid_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","eme ya, nawin bwe uru ruwani ndron ma hawe tama uru udu gwek, ma uru au a-en hamon ta Jises. ");
INSERT INTO lid_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jises edek ili loboho Galili mara-ei, leheya ma asehek sahou mwasin ta tondrok ta Kindrei udu bolo asiu ta atukum tiri Juwis, ma iy bwidi iri sik ndra-in mari udu bada iri lau iu. ");
INSERT INTO lid_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nyaran ma sihide lahou iy amekes aseker i bolo Siriya mara-ei, eme ya iri lau atiye iri lau sik udu tiri, ma iri lau sik tiri bwidi iri sisi-in labai, ya hawe iri lau balik lolowa iri ma bwidi iri lolo-ou, ma hawe iri lau kati iri ma mine iri winiyan ta bales bwe. Iri tiyani iri lau mari doh ame hawen, eme ma iy bwidi iri lau mari doh amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Eme ma iri lau solo-an badu Galili, ma iri lau badu Dekapolis, ma iri lau badu Jerusalem, ma iri lau badu Judiya, ma hawe iri lau badu kon udu loboho Jodan bilisiu ya iri lau mari doh adek a-en hamon tan. ");
INSERT INTO lid_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na len iy atou iri lau mari doh iy ili loken bwele-e mandrei, ma iy manyah udu aliy. Eme ya oro lau badu hamon tan ame hawen. ");
INSERT INTO lid_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Eme ma iy leheya oro, ma iy asehek sahou i toro i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Sekesek handru i toro lau ala ado ndra-in ta budon ma hawe manyah toro, idah kameh Kindrei atondrok oro ma oro kameh akohok iri lakou mwasin tan. ");
INSERT INTO lid_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Sekesek handru i toro lau ala ado ndra-in ta tikisiy ma ndrelen, idah kameh Kindrei bahabah oro ma oro ado ta sekesek handru. ");
INSERT INTO lid_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Sekesek handru i toro lau ala batudun oro ma nyara oro le bwe. Oro kameh akohok iri lakou mwasin badu munyak i buku le Kindrei ndratandrakan. ");
INSERT INTO lid_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Sekesek handru i toro lau ala abadok ta asilah budon mwasin ma hawe manyah mwasin ta Kindrei i buku oro ameson ta nyamon ma i buku bale oro amar ta gwa ta a-un, ya idah kameh oro adih handru. ");
INSERT INTO lid_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Sekesek handru i toro lau ala abadok ta amekes kandriyen ta tikisi lau, ya idah kameh tikisiy ta Kindrei tinan ili bwele-e oro. ");
INSERT INTO lid_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Sekesek handru i toro lau ala budon ma kandriyen toro udu mwasin, ya idah kameh oro atou Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Sekesek handru i toro lau ala abadok ta amekes kandriyen mwasin ta mondrei, ya idah kameh iri aloh oro nadu Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Sekesek handru i toro lau ala iri lau adai oro ma iri tawi oro ma andrei oro ala bolo kou, tasah oro badeh amekes kandriyen mwasin, ya idah kameh Kindrei kameh atondrok oro ma oro kameh akohok iri lakou mwasin tan. ");
INSERT INTO lid_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Sekesek handru ewek tado tasah, iri lau asehek sahou ta bobose ado ma iri adai ado ma iri asehek sahou ndra-in handru ta wasai ewek tado, tasah ado a-en hamon tek. ");
INSERT INTO lid_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ya, ado kasekesek, tasah ndramas mwasin udu kandrah kodo-oh abe-en ado. Idoh i le buku san iri lau ndradai iri propet mene ndrame bwena tado.” ");
INSERT INTO lid_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jises asehek ili le i buku doh, “Ado kaseben iri lau i buku ndras aseben nyamon ta munyak dah. Arile, i buku nyiminye ndras aliy bwe, ki buku sah handru kameh nyiminye ndras doh kasahan ja? Ndras doh bala mwasin ta i bolo ari nyamon bwai. Mwasin handru ta kakahei ndras doh ki-iu ma lau katisih na kati iri. ");
INSERT INTO lid_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ado kasahan buku lomadan ta lomada iri lau ado bwele-e munyak. Ya, i buku kon tinan ari udu bwele-e mandrei, iy winiyan baton bwe. Iri lau ado len winiyan atou lomadan. ");
INSERT INTO lid_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Eme ya iri lau telemei sun, iri batehei bado bahandra bwekei bwe. Iri atehei udu ndrahunen loken, tasah lomadan kameh lomatani lau mari ado bolo asiu. ");
INSERT INTO lid_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","I le buku san dah lomada ado kanya kili bwena ta lau. Ya idah kameh iri lau atou lahou tado ma kandriyen mwasin tado, eme ya iri lau kameh sekesek ma atudun tama ado Kindrei udu kandrah.” ");
INSERT INTO lid_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jises asehek ili le i buku doh, “Ya ado sabudon sala buku doh, anya jo eme dah ta akeh batanau malen, ma iri propet au, bwe; jo eme dah ta atikah oro au bwe, jo eme dah ta amekes batanau malen abadok ma amekes sahou tiri propet ta Kindrei kabadok ma i handru. ");
INSERT INTO lid_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","“Jo tiye tado handru i buku doh: Idah kameh munyak ma kandrah kameh amai iu. Arile sese kono-o tarou ta batanau malen winiyan bamai ba-au bwe, winiya le lakou mari Kindrei anya kamekes, kasahan i handru. ");
INSERT INTO lid_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","“Ya are lau winiyan banuhun randra sahou nadu bwisik ta batanau malen bwe, ma iy leheya lau ta iri ka-en hamon ta kandriyen tan doh, iy winiyan basahan bala tinan bado ta tondrok ta Kindrei, bwe. Arile, are lau none ma leheya lau ta iri kanuhun ma kamekes batanau malen, iy kameh, aloh nyaran i tinan handru udu bolo tondrok ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","“Ya jo katiye tado, ado winiyan ala bolo tondrok ta Kindrei, arile i buku none budon tado handru, ma kandriyen mwasin tado winiyan basakalawi budon ma kandriyen mwasin tiri Parasi ma hawe iri lau ta leheya kandriyen ta Moses bwe, ado winiyan bala bolo tondrok ta Kindrei bwe.” ");
INSERT INTO lid_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jises asehek ili le i buku doh, “Ado ndranuhun sahou ndrabatanau ndrala tiri lau rebesem bwena, ‘Ou sadai ndramak samak.’ I buku none are lau idi ari ndramak imek, iy lau doh kameh ales ili ta mada sahou tinan handru. ");
INSERT INTO lid_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Arile jo katiye handru, i buku none are lau andra-i i hawe nadu tinen, iy kameh ales ili ta mada sahou tinan, ya are lau tiye ili ta nadu tinen i buku doh: ‘Ou badeh, mwasin ta laleyah le,’ ya idah kameh ou ala ales a ta mada sahou tinan ta kansol tiri Isra-el. Ya are lau tiye ili ta nadu tinen i buku doh, ‘Ou lolo-ou,’ ya idah kameh mirihik ou ales ala bolo jih. ");
INSERT INTO lid_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Eme ma, i buku none ou anya ala atiye salom tam kili ndrahune salom, ou abudon bwena op, buku nadu tinem badeh iy tan sahou udu tam, ");
INSERT INTO lid_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ya, ou ruwani salom tam kudu andri bwena ta mada koto-ok op. Ou ala hawe nadu tinem, ou asehek sahou mwasin kili ta nadu tinem, ta leheya ndrine sen tam hawe nadu tinem ndrano ai. Ano ya ou ame barala baradeu salom tam barala bwele-e mada koto-ok ta salom. ");
INSERT INTO lid_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Buku ari ndramak tan losen udu tam ya iy atehei ou ala ta mada sahou, ou asehek sahou mwasin kili tan suwi na len ah ma la-uh adek san kahis le, bwe kameh iy atehei ou ala mine ndramak ta anuhun sahou, eme ya ndramak ta anuhun sahou atehei ou ala mine iri lulik, ya iri lulik atehei ou ala bolo asiu lulik. ");
INSERT INTO lid_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jo katiye tam handru, ou winiyan bame len bwe, winiya le ou sihinei labai na luk in hamon ta maha-an tam.” ");
INSERT INTO lid_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jises asehek ili le i buku doh, “Ya ado ndranuhun sahou mene iri ndrasehek, ‘Ou samekes karei hawe badih tasou.’ ");
INSERT INTO lid_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Arile, jo katiye kewek tam, ki buku none ari ndramak kanyolom boto-on kili bada ari badih ta amekes budon ndra-in ta karei kili tan, iy ndramak doh ndramesekei karei hawe iy badih doh ndrado ndrinen kabwe. ");
INSERT INTO lid_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ya i buku none madam salin suni ou ala bolo kandriyen ndra-in ta karei, ou holowani madam salin keme len, ya ou akahei ki-iu. Mwasin ta ou holowani madam salin ki-iu, ndra-in ta sakahei ou ma buruwen sala bolo jih ta udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ya, i buku none minem salin suni ou ta amekes kandriyen ndra-in ta karei, mwasin ta ou saniy ki-iu ya ou akahei ki-iu. Mwasin ta ou sani minem salin ki-iu, ndra-in ta sakahei ou ma buruwen sala bolo jih ta udu le buku doh.” ");
INSERT INTO lid_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jises asehek ili le i buku doh, “Sahou ndrasehek kabwe, ‘Ya, i buku none ari lau kisan tasou tan ma katikah udun ki-iu, iy katehei ramen la-ukei ma sahou boto-on in aliy ta asan tasou, ya iy katehei ki minen ta asan tasou.’ ");
INSERT INTO lid_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Arile jo katiye ki buku doh, i buku none are lau kisan tasou tan ma katikah udun ki-iu, ya iy badih tan badeh, bamadin hawe ari ndramak ja bwe, iy badeh, amekes udun i buku badih ta madasan. Iy mwan ale andrei badih ari bwena, udun ndratikahei iy, iy ale amekes kandriyen ta karei.” ");
INSERT INTO lid_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jises asehek ili le i buku doh, “Ya idah ado ndranuhun sahou ale ndrasehek ndrala ta lau rebesem bwena ndra-au, ‘Buku ou tandrakan i ta nyara Laban ta amekes sahou tam i handru, ou a-en hamon le ta sahou nane ou amekes ili ta Laban le ari.’ ");
INSERT INTO lid_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Arile jo katiye tam, ou satandrakan ta amekes iri sahou tam i handru, ndri-iy; ya ou satandrakan kandrah, tasah kandrah badeh kon ndrahu koyeu ta Kindrei manyah udu aliy. ");
INSERT INTO lid_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ya ou satandrakan sala ta munyak ale, tasah munyak badeh ta ndrahu kati Kindrei udu aliy. Ya ou satandrakan sala ta Jerusalem, tasah Jerusalem badeh kon ta kabin tinan. ");
INSERT INTO lid_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ya ou satandrakan sala ta batum, ndri-iy, tasah ou winiyan bamesekei ramen lami batum asahan belen deh asahan bokodon bwe. ");
INSERT INTO lid_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ya buku ou asehek sahou, ‘Ehe,’ ‘Ehe’ le kai-iy ai. I buku ou asehek sahou, ‘Bwe,’ ‘Bwe’ le kai-iy ai. Ya, i buku none iri sahou boto-on labai asahan ja, badeh, asahan ta balik.” ");
INSERT INTO lid_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jises asehek ili le i buku doh, “Ya ado ndranuhun sahou dah ndrasehek i buku doh, ‘I buku none are lau sudi madam eme len, ya ou ala sudi madan keme len ale. Ya i buku none are lau tubwani lihim, ya ou ala tubwani lihin ale.’ ");
INSERT INTO lid_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Arile jo katiye tam, ou sadeu saluwe kandriyen ndra-in ta ndramak are edeu kandriyen ndra-in ewek tam, ndri-iy. Ya i buku none are lau ubwi lim ili kapam salin, mwasin, ou tubuni kapam kamweu kili ja, ya iy kubwi lim ki aliy ale. ");
INSERT INTO lid_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ya are lau anya katehei ou ala ta mada sahou ta iy anya kakohok awin tam kili tan, mwasin, ou atehei awin tam lawe-en kili ale. ");
INSERT INTO lid_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ya, ki buku none ari lau ta bahun kandrek ou, ma iy anya ou bwese lakou tan a hawen ta ah kadek san winiya kilomita ari, mwasin, ou ala, ah kadek san winiya kilomita la-uh ja. ");
INSERT INTO lid_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ya ki buku none ari lau kandremenya ou ta ari lakou tam kili tan, mwasin, ou atehei kili tan. Ya are lau aseken ta akohok lakou tam bwena, ano iy anya katehei kewek hamon ja, mwasin, ou atehei lakou kili tan, ya ou satehei konam sala tan.” ");
INSERT INTO lid_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jises asehek ili le i buku doh, “Ado ndranuhun sahou dah ndrasehek i buku doh, ‘Ou aseken iri lau badu mirihik tam le amwenen. Ya ou bwalem iri lau amekes ndra-in ewek tam.’ ");
INSERT INTO lid_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Arile jo katiye tam, ou aseken iri lau amekes budon ndra-in ewek tam. Ma ou amekes salom ki ta Kindrei ta iy kaseben iri lau amekes ndra-in ewek tam ta adai ou. ");
INSERT INTO lid_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ya idah kameh ou asahan nadu Kindrei handru badu loken. Iy edeu an tan anya i bwele-e lau ndra-in ma i bwele-e lau mwasin ale. Ma iy edeu ur tan i bwele-e lau ta kandriyen ma lomondra mwasin, ma i bwele-e lau ta kandriyen ma lomondra ndra-in ale. ");
INSERT INTO lid_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ya, i buku ou aseken iri lau le nane aso-ok ou, ya bundruwe lakou tam doh, eme hamon kameh i buku sah bah? Ya iri lau ta kolowa luk ta takis amekes i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Eme ya, i buku none ou asehek sahou mwasin i le ta nadu tinem le amwenen, ya ou asahan mwasin ja tiri lau rayah ja na sasah bah? Ya iri lau badu leheleh amekes ale i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ou ado le mwasin handru i le buku tamam udu kandrah udu le mwasin handru.” ");
INSERT INTO lid_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jises asehek ili le i buku doh, “Ado kabudon kamwenen ta ado saleheya kandriyen mwasin tado sala mada lau ta lau kamasiye ado, ndri-iy. Ya, i buku none ado leheya kandriyen mwasin tado i mada lau ta iri kamasiye ado, ado winiyan bakohok sihine ado udu mine tama ado udu kandrah bwe. ");
INSERT INTO lid_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ya, i buku ado kadeu lakou ili tiri lau ndra-in, ado soloh ndrah ta lau katanan ado, ndri-iy, sala buku iri lau ta wasai amekes udu bolo asiu ta atukum, ma udu bolo iri kon tinan ale, ta iri lau kamasiye ma katudun oro. Jo katiye handru, oro ndrakohok sihine oro ndrano kabwe. ");
INSERT INTO lid_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Arile ado anya kadeu lakou kili tiri lau ndra-in, ado kamekes kudu ndra kabwak, ta iri mwan ma badih sado mirihik, sanyolom aha amekes. ");
INSERT INTO lid_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Eme ma, saba lakou ado adeu i tiri lau ndra-in, ado katone kamai labai. Ya tama ado udu kandrah ndratou ado adeu lakou i san kabwak, ma idah kameh iy edeu sihine ado.” ");
INSERT INTO lid_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jises asehek ili le i buku doh, “Na len ado anya kasolom, ado sasolom sala buku iri lau ta wasai, tasah iri lau ta wasai anya kasolom kameh, iri aseken ta ales ado loken ado bolo asiu ta salom, ma iri aseken ta amekes salom ado bolo bosoh tiri kon tinan ta lau katou iri. Ya jo katiye tado handru, oro ndrandrei sihine oro mara-ei ndrano kabwe. ");
INSERT INTO lid_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Arile, ado anya kasolom, ado kala bolo asiu tado, ya ado kasulu-i kou kili, ma ado kasolom kili ta tama ado, iri lau winiyan batou iy bwe. Ano ya, tama ado udu kandrah ndratou ado amekes lakou i san kabwak, ma idah kameh iy edeu sihine ado. ");
INSERT INTO lid_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ya ado anya kasolom, ado samekes sahou solo-an, sala buku none iri lau badu leheleh asolom. Iri anya Kindrei kameh anuhun salom tiri tasah iri badeh asehek sahou solo-an. ");
INSERT INTO lid_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ado sala buku none oro, tasah tama ado ndratanan saba lakou ado aseken ano ado ndremenya iy ta aliy. ");
INSERT INTO lid_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ya idah san ta salom ado ka-en hamon ta aliy: Tama aso, ou ado kandrah. Nyaram badeh, ki ndrabun. ");
INSERT INTO lid_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ma ou ame atondrok kon mari. Ahi kamesekei lahou na so-ok tam udu munyak, i le buku ndramesekei udu kandrah. ");
INSERT INTO lid_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ou anyohan aso na nyamon, winiyan ta len dah. ");
INSERT INTO lid_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ou mani kandriyen ndra-in taso, i le buku aso mani iri kandriyen ndra-in iri amekes eme taso. ");
INSERT INTO lid_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma ou satehei aso sala bolo iri none. Arile, ou sebenei aso ta sala bolo kandriyen ndra-in ta balik. ");
INSERT INTO lid_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aha kasolom ki buku doh. Tasah, buku aha mani kandriyen ndra-in tiri mwan ma badih rayah, tama aha udu kandrah kameh winiyan mani kandriyen ndra-in taha ale. ");
INSERT INTO lid_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Arile, buku aha bamani kandriyen ndra-in nane iri mwan ma badih rayah amekes ewek taha, bwe, tama aha ale kameh winiyan bamani iri kandriyen ndra-in nane aha amekes, bwe.” ");
INSERT INTO lid_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jises asehek ili le i buku doh, “Ki buku none ado anya kabeles ado ta nyamon, ado samekes teheya mada ado sandra-i sala buku iri lau ta wasai amekes. Ya iri lau ta wasai leheya mada iri ma teheya iri ta lau katou iri, kabeles iri ta nyamon. Jo katiye tado handru, oro ndrandrei sihine oro mara-ei ndrano kabwe. ");
INSERT INTO lid_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Arile, ki buku none ado anya kabeles ado ta nyamon, ado kadeu ndrelekei kili batu ado, ma ado kasikine mada ado. ");
INSERT INTO lid_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ya idah kameh iri lau winiyan baseleyani ado adeu ndrabun ili ta nyamon bwe, arile ili ta tama ado ala ado winiyan batou badan bwe, ya tama ado, iy ndratou saba lakou ado ndramesekei amunum le, ma iy kameh edeu sihine ado.” ");
INSERT INTO lid_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jises asehek ili le i buku doh, “Ado satukum tado iri lakou badu munyak, ndri-iy, tasah idah kameh iri amu-uk ma ndranyem kameh iniy ano iu, ma iri lau ta bahana kameh apwai asiu ma bene-ei iu. ");
INSERT INTO lid_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Arile ado katukum tado lakou mwasin handru badu kandrah, ya amu-uk hawe ndranyem winiyan baniy bano bwe, ma iri lau ta bahana winiyan bapwai asiu ma winiyan babene-ei bwe. ");
INSERT INTO lid_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tasah, i buku none ou tam lakou solo-an udu bolo munyak dah, kameh mesekei ou abudon solo-an ta aliy.” ");
INSERT INTO lid_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jises asehek ili le i buku doh, “Mada ado badeh, i buku lomada sun ta atelem bolo oda ado. Ya, i buku none mada ado udu mwasin, ya idah kameh bolo ado mara-ei idih na lomadan. ");
INSERT INTO lid_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Arile, i buku none mada ado ndra-in, ya idah kameh bolo ado mara-ei idih na lulik. Ya, i buku none lomadan udu bolo ado i lulik, ya idah kameh lulik i tinan labai.” ");
INSERT INTO lid_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jises asehek ili le i buku doh, “Ari ndramak winiyan bateu lahou ta lau tinan la-uh bala le rasan bwe. Ya idah kameh iy i bwalen iy ari, ya iy aseken iy ari; deh bwe, kameh, iy anuhun sahou ta iy ari labai ja, ta iy ari. Ado winiyan balelei Kindrei ta atondrok ado, ma hawe aseken luk ta atondrok ado bala le rasan bwe.” ");
INSERT INTO lid_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jises asehek ili le i buku doh, “Idah jo katiye tado, ado sabwerei ta manyah tado, saba lakou kameh ado aimon, ma saba lakou kameh ado a-un, ma ta bada ado ale, saba lakou kameh ado kataliye. Sebwe koha ado sakalawi nyamon, ma bada ado sakalawi kalawi ado, neh? ");
INSERT INTO lid_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ado katou iri sirih ateleh loken. Iri batah nyamon bwe, ma iri babwe-eh buwa nyamon bwe. Ma hawe iri batukum nyamon bala asumwe nyamon bwe, arile tama ado badu kandrah anyohan iri. Sebwe ado winiyan basakalawi iri sirih doh bwe nadeh? ");
INSERT INTO lid_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Buku ado abwerei ta iri lakou doh, idah kameh winiyan edeu ari len ja ili hawe len ta manyah tado, ta ado luluwen deh? Bwe! ");
INSERT INTO lid_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Tasah handru ado abudon andra-i ta kolau ma awin? Ado kanone kanyolom iri kanyeu ateh ado ndrahune iri se. Ya iri babo gok bwe, ma iri bamekes kalawi iri bwe. ");
INSERT INTO lid_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Arile, jo katiye tado, bwena mene kabin Solomon asini iri awin tan mwasin mara-ei handru ano, arile nyasou tiri kanyeu ja sakalawi nyasou ta kabin Solomon. ");
INSERT INTO lid_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Idah Kindrei edeu nyasou ma awin ili tiri bwidiu badu lokei, iri bwidiu ado na len dah, ano na len bi-i akeh iri au ala bolo jih ta asun iu. I buku sah, sebwe Kindrei winiyan badeu kolau ma awin bawek tado bwe nadeh? Budon tado handru tinan bwe? ");
INSERT INTO lid_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ya ado sabudon sandra-i ma satiye sala buku doh, ‘Aso kaimon saba lakou bah? Aso ka-un sasah bah? Ya aso kadeu saba lakou bah?’ ");
INSERT INTO lid_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Iri lau badu leheleh aseken ma asilah iri lakou mari doh. Ado sala buku iri, tasah tama ado udu kandrah tanan saba lakou ado aseken. ");
INSERT INTO lid_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Arile, ado kanyolom bwena kili ta tondrok ta Kindrei ma ta kandriyen mwasin tan, ano ya iri lakou mari doh Kindrei kameh edeu ewek tado. ");
INSERT INTO lid_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ya ado sabudon ta len bi-i, tasah len bi-i badeh, tan lomondra ma lahou tan labai. Kora-on aha kandruni maha-an ta bi-i ja, iy kameh sakalawi lakou nane ou abudon boto-on labai ta aliy na len dah.” ");
INSERT INTO lid_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jises asehek ili le i buku doh, “Ou satiye kandriyen ta ndramak ari ja, bwe kameh ou ale ala ta mada sahou tinan. ");
INSERT INTO lid_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","I le buku san tam ou tiye kandriyen ta ndramak ari ja, ya idah kameh ou ales ala ta mada sahou ale. Tasah, Kindrei kameh seleya kandriyen tam i buku le kandriyen ou ale amekes ili tiri mwan ma badih rayah ja. ");
INSERT INTO lid_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“I buku sah handru, ou nyowonya mutahu kei udu mada nadu tinem ari ja, arile ou batona sobola kei ranah ma buruwen udu madam bwe nadeh? ");
INSERT INTO lid_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","I buku sah handru, ou tiye ili ta nadu tinem ari ja i buku doh: ‘Jo kandrei mutahu kei ranah ma buruwen udu madam keme len,’ arile len mari ou batona sobola kei ranah ma buruwen udu bolo madam bwe? ");
INSERT INTO lid_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ou lau ta wasai, ma bwena ou andrei sobola kei udu bolo madam keme len op, ano ou kameh anyolom amwenen handru ta akohok mutahu kei udu mada nadu tinem ari ja eme len. ");
INSERT INTO lid_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ou sadeu nyamon ndrabun sala na mwi. Ya ou sakeh sa-un tam sala bwena ta bou. Buku ou akeh eh, idah kameh iri bou adek ala bwele-en ma tihisiy na kati iri, ano iri bou doh kameh tubuni iri ame hamon ja ani ou, ma sekese-ei ou ale bwisik.” ");
INSERT INTO lid_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jises asehek ili le i buku doh, “Ado kandremenya, ya ado kameh akohok. Ado kasilah, ya ado kameh takalahei. Ado kalim kou, ya kou kameh asak tado. ");
INSERT INTO lid_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tasah, iy are lau ndremenya, iy kameh akohok. Iy are lau asilah, iy kameh takalahei. Ya, iy are lau alim kou, ya kou kameh asak tan. ");
INSERT INTO lid_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ya, ou, i buku none nadum kandremenya ou ta jabi ramen, ya ou taman kameh adeu nan bek deh? ");
INSERT INTO lid_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Bwe, iy ndremenya ta ari ni, ya ou kameh adeu nan mwak deh? ");
INSERT INTO lid_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ya, i buku none ou tanam ou ndra-in, arile ou tanam ta adeu lakou mwasin ili ta nadum oro; ou winiyan atanam handru, tama ado udu kandrah kameh sekesek labai ta edeu lakou mwasin ale ili toro are lau ndremenya iy! ");
INSERT INTO lid_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ya, udu bolo lakou mari, ou amekes kili tiri lau, saba lakou ou aseken iri lau kamekes kewek tam ale. Idah amwenen le ta sahou batanau ta Moses, ma hawe sahou leheya tiri propet.” ");
INSERT INTO lid_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jises asehek ili le i buku doh, “Ado kala san ta loboho kou bwisik, tasah san ta kou ili bolo jih badeh, san tinan labai. Ya lau solo-an labai adek ala san aliy. ");
INSERT INTO lid_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Arile san ili ta kou bwisik ales ili kon ta manyah mwasin ma winiyan ta bano bwe. Ya idah kameh lau sola handru bwe adek ala san aliy.” ");
INSERT INTO lid_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jises asehek ili le i buku doh, “Ado katondrok ado kamwenen handru tiri propet ta wasai. Iri ame hawe ado kameh bilibik ala buku none iri sipsip, ta bada oro le. Arile udu bolo ndrine oro badeh, oro ala buku none iri mwi ndra-in ta atoh. ");
INSERT INTO lid_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ado winiyan seleyaniy amwenen handru ta saba lakou asahan ta kandriyen oro amekes, tasah, malou bobodon ndra-in winiyan bato-ou buwa waen bwe. Ya iri lau abwe-eh buwa pik eme ta bwidiu ndra-in? Bwe! ");
INSERT INTO lid_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","I le buku aliy, iri kei mwasin ato-ou buwa kei mwasin, arile kei ndra-in ato-ou buwa kei ndra-in. ");
INSERT INTO lid_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ya kei mwasin winiyan bato-ou buwa kei ndra-in bwe, ya kei ndra-in winiyan bato-ou buwa kei mwasin bwe. ");
INSERT INTO lid_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ya iri kei mari ala bato-ou buwa kei mwasin bwe idah kameh amundroh i andri ma akeh ili bolo jih ta asun iu. ");
INSERT INTO lid_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ya ado kameh ala tanan mwasin labai tiri propet ta wasai, tasah ado seleya amwenen handru ta saba lakou asahan ta kandriyen oro amekes. ");
INSERT INTO lid_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ado sabudon sala buku doh, ‘Iri lau mari aloh Jises i Laban iri winiyan ala bolo tondrok ta Kindrei udu kandrah.’ Arile, oro le lau ala amekes lahou ta tama udu kandrah. ");
INSERT INTO lid_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ya len doh kameh asahan, lau solo-an kameh asehek eme tek i buku doh, ‘Laban, Laban, ta nyaram aso asehek sahou ta Kindrei buku propet, ya ta nyaram aso atikah balik udu bwele-e lau au a len, ya ta nyaram aso amekes lahou tinan solo-an.’ ");
INSERT INTO lid_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Arile jo kameh tiye tiri handru, ‘Jo tanan ado bwe, ado ka-au ka len tek. Ado lau ta amekes kandriyen ndra-in.’” ");
INSERT INTO lid_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jises asehek ili le i buku doh, “Sendrehendreh ta aliy i buku doh: Are lau anuhun sahou tek dah ma iy in hamon ta aliy, iy i buku none ndramak tan budon mwasin, iy atah asiu tan udu bwele-e bek. ");
INSERT INTO lid_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ya ur undruk eme andri, ma wadah in gwa ma siyer atohou boto-on ili isos bada asiu. Arile batohowei asiu bwe, tasah asiu doh ndru ta aliy ili ihis bada bek. ");
INSERT INTO lid_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Arile, are lau iy anuhun sahou tek dah, arile iy ba-en hamon ta aliy bwe, iy i buku none ndramak tan budon mwasin bwe, iy atah asiu tan udu bwele-e on laleyah. ");
INSERT INTO lid_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ya ur undruk eme andri, ma wadah in gwa ma siyer atohou boto-on ili isos bada asiu ma tohowei asiu taku i andri, ma atohou andra-i labai.” ");
INSERT INTO lid_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jises ano ta sehek sahou doh, ya iri lau mari mani iri atur ta leheya tan. ");
INSERT INTO lid_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tasah iy leheya iri i buku none ndramak tan boto-on, iy bala buku none iri lau ta leheya kandriyen malen bwe. ");
INSERT INTO lid_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jises edek udu mandrei eme andri, ya lau solo-an labai a-en hamon tan. ");
INSERT INTO lid_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ya ndramak ari sik lepra udu tan eme hawen, ma iy atehei bwili ndru-un i andri, ma iy tiye i buku doh, “Laban, i buku none ou aseken ou winiyan mesekei jo kamwenen ja udu mada Kindrei.” ");
INSERT INTO lid_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jises eme atehei minen i badan ma tawi iy, ma iy tiye, “Jo aseken. Ya ou amwenen ja.” Nawin bwe sik lepra iu ma iy amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ano Jises tiye i tan, “Ou sasehek sala ta ari lau, ndri-iy, arile ou ales ala hawe iri pris, leheya badam ki tiri kanyolom. Ano ou adeu lakou kili ta salom i le buku Moses mene ndrabatanau, ya eme iri kanyolom ma katanan ou badeh, ndramwenen ja.” ");
INSERT INTO lid_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jises edek eme isos Kapena-um, ndramak batun tinan ta tondrok lau ta bahun eme hawen, ta ndremenya iy ta seben. ");
INSERT INTO lid_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ya iy ndramak batun tinan tiye i buku doh, “Laban, ndramak ta ndrahu so-ok tek ibo sik ndra-in labai udu kon, ma iy winiyan ta banyokolokon bwe. Iy akohok sisi-in tinan labai.” ");
INSERT INTO lid_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jises tiye i tan i buku doh, “Jo kameh ewek mesekei iy amwenen.” ");
INSERT INTO lid_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ya ndramak batun tinan tiye i buku doh, “Laban, jo ndramak ndra-in, jo winiyan baseken ou ta ame bolo asiu tek bwe, arile jo aseken ou asehek le sahou, ya ndramak ta ndrahu so-ok tek doh kamwenen ja. ");
INSERT INTO lid_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tasah, jo amwenen udu bahandra boto-on ta batun tinan ta tondrok lau mari ta bahun, ma jo badeh, lau tek rinek (100) ta bahun ale ado bahandrak. I buku none jo katiye ki ta ari lau anya, ‘Ou ala,’ idah kameh iy ilih. Ya, i buku none jo katiye anya, ‘Ou ame,’ idah kameh iy eme. I buku none jo katiye ki ta ndramak ta ndrahu so-ok tek anya, ‘Ou bwidi lahou doh,’ ya idah kameh iy bwidiy.” ");
INSERT INTO lid_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jises anuhun sahou doh ma manin atur, ma iy tiye ili tiri lau a-en hamon tan i buku doh, “Jo katiye tado handru, jo bandruni ari lau badu Isra-el tan budon tinan bala buku iy lau dah bwe. ");
INSERT INTO lid_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jo katiye tado, lau solo-an badu leheleh kameh ame, badu loboho an eme loken, ma badu loboho an i andri. Ya iri kameh akohok ndrahune iri ta manyah ta nyamon tinan hawe Abraham, ma hawe Aisik, ma hawe Jekop udu bahandra tondrok ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Arile, oro lau ala Kindrei mene tiye oro ala ado bolo tondrok tan kameh akeh oro au ala manan, ala bolo lulik, ya oro kameh aden, ma andrebek lihi oro.” ");
INSERT INTO lid_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ano Jises tiye ili ta ndramak batun tinan tiri lau ta bahun, “Ou ala kon, saba lakou ou aseken, ndramesekei in hamon ta budon tam tinan handru.” Eme ya ndramak ta ndrahu so-ok tan ndramwenen ja na le liliy. ");
INSERT INTO lid_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na len Jises edek eme ili asiu ta Pita, iy atou salahu Pita ibo sik. Badan nyarahan ma iy amadin in bada sau. ");
INSERT INTO lid_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jises eme tawi le minen ma badan nyarahan nane iu, ma badih doh suri iy le eme loke, ma iy amekes na Jises nyamon. ");
INSERT INTO lid_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Mirihik kon anya ka beyeh, ya iri lau atiye lau solo-an nane balik udu bwele-e iri ame hawe Jises, eme ma iy asehek le sahou ili tiri malawin ndra-in, ma tikahei iri au, ma iy mesekei iri lau mari amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Idoh ta amekes sahou ta propet Aisaya ndrasihidiy, asahan handru: “Iy amwenen bwese-ei sik tataha ma iy andrei sik ndra-in tataha iu i len.” ");
INSERT INTO lid_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jises atou iri lau solo-an labai awudi iy, eme ma iy tiye i toro lau tan au ala kapa gwa bilisiu. ");
INSERT INTO lid_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ano ndramak ari ta leheya kandriyen malen eme hawe Jises, ma iy tiye tan i buku doh, “Ndramak ta leheya, loboho heh ou ala aliy, jo kameh in le hamon tam.” ");
INSERT INTO lid_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jises tiye i tan i buku doh, “Iri mwi badu lokei, munu iri udu aliy, ya iri sirih ale awi iri ta matinou udu aliy. Arile, jo Nadu Ndramak Awas, badeh, ari ndrahu matinou tek, bwe.” ");
INSERT INTO lid_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ano ndramak ari badu hamon tan eme tiye i ta Jises, “Laban, jo kili kihi tama op. Ano jo barawek bara-en hamon tam.” ");
INSERT INTO lid_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Arile Jises tiye i tan i buku doh, “Ndri-iy ai! Ou ame a-en hamon tek, ya iri lau amak badeh, kado gwek. Idah kameh, iri lau badu hawe iri barala bara-eh iri.” ");
INSERT INTO lid_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ano Jises sandroh ili bolo ndron ra-ei, ma hawe oro lau tan ma ronoh la-uh a-en hamon tan. ");
INSERT INTO lid_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","I le mani tur, siyer laba tinan atohou eme bwele-e gwa li Galili, eme ma bayau atohou eme bolo ndron. Arile Jises amadin. ");
INSERT INTO lid_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ya oro lau tan ala mete-ei iy, ma oro tiye i buku doh, “Laban, ou aseben to! Bwe kameh to katuh ai!” ");
INSERT INTO lid_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jises tiye i buku doh, “Ado budon tado nadu bwisik labai, i buku sah ado anoh tinan labai?” Ano iy suri iy eme loken, ma tiye sahou boto-on i ta siyer ma hawe bayau, eme ma siyer ma bayau amondrei i le rasan. ");
INSERT INTO lid_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Eme ma oro lau tan mani oro atur, ma oro ndremenya oro, “Are ndramak i buku iy dah? Ya siyer ma bayau anuhun iy!” ");
INSERT INTO lid_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jises oro ame asos kapa gwa li loboho kon tiri lau Gadara. Eme ya uru lau ma la-uh doh malawin ndra-in udu bwele-e uru, ma uru ado mada lek adek ame hawe Jises. Ya malawin ndra-in mesekei uru ala lolo-ou ndra-in labai, ma iri lau winiyan badek bala san doh bwe. ");
INSERT INTO lid_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Eme ya uru ndremenya Jises ma uru arah i buku doh, “Ou Nadu Kindrei, ou anya amekes sasah keme taru? Ou ame dah ta adeu sisi-in eme taru, bwena ta len amwenen ta aliy?” ");
INSERT INTO lid_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Eme ya, udu len sese, bou rakou aimon nyamon. ");
INSERT INTO lid_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Eme ya malawin ndra-in tiye sahou tikisiy i ta Jises anya, “I buku ou tikahei aso ame len, ya ou suni aso kala bwele-e bou.” ");
INSERT INTO lid_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Eme iy tiye i toro, “Ado kala!” Eme iri malawin ndra-in ame len. Ano iri sandroh a bwele-e bou, ma bou rakou nane dah sakaliye are bwele-e mandrei ame andri ala bolo gwa li, ma oro amak. ");
INSERT INTO lid_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Eme ma oro lau ta atondrok bou nane dah atobwak au ala kon tinan, ma ala asehek tiri lau ta lakou mari asahan tiri bou, ma hawe lakou asahan turu lau nane dah malawin ndra-in udu bwele-e uru. ");
INSERT INTO lid_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ano ma lau mari badu kon nane dah au ala ta atou Jises. Oro atou Jises, eme ma oro ndremenya iy, ta iy karuwani kon tiri ma iy ki-iu. ");
INSERT INTO lid_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jises sandroh i bolo ndron ra-ei, ma iy iu i hamon i kapa gwa bilisiu ili kon tan amwenen. ");
INSERT INTO lid_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Eme ma, iri lau ra-on bwese-ei ndramak ari badan imek ta eme atou iy. Ndramak nane amadin bada nyahan tan. Jises atou buku none budon toro boto-on labai in tan, ma iy tiye i ta ndramak nane badan imek anya, “Ou abadok, naduk! Kandriyen ndra-in tam ndrasikinei ndra-au.” ");
INSERT INTO lid_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Eme ma oro lau ra-on ta leheya kandriyen malen nunu-uh i buku doh, “Ndramak kede-eh asehek sahou ndra-in i bada Kindrei.” ");
INSERT INTO lid_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Arile, Jises tanan budon toro ma iy anya, “Tasah handru ado abudon ndra-in i buku badeh in bolo ndrine ado? ");
INSERT INTO lid_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Buku sah, san manamun ndraheh, jo kasehek anya, ‘Kandriyen ndra-in tam ndrasikine ndra-au,’ deh bwe, katiye, ‘Ou suri ou, ma ou adek’? ");
INSERT INTO lid_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Jo winiyan leheya ewek tado ma ado ki tana ado, ta Nadu Ndramak Awas badeh, boto-on labai, udu bwele-e munyak dah ta tiye i ta ndramak ta mani kandriyen ndra-in tan iu.” Eme ma iy tiye i ta ndramak nane badan imek, iy anya, “Ou suri ou, ma ou andrei nyahan tam ma ou au a kon!” ");
INSERT INTO lid_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ndramak nane suri iy eme loken, ma iy iu i kon. ");
INSERT INTO lid_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Eme ma, iri lau mari nane atou, ma iri anoh, ma iri atudun nyara Kindrei, tasah Kindrei badeh, edeu iri boto-on i buku doh ili tiri lau mwan ma badih. ");
INSERT INTO lid_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Eme ma Jises edek ili, ya iy atou ndramak ari nyaran Metiu manyah ereu bolo asiu tan ta gok ta akohok luk ta takis, eme ma iy tiye i tan, “Ou ame an hamon tek.” Eme Metiu suri iy ma iy in hamon tan. ");
INSERT INTO lid_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ano, Jises manyah udu bolo asiu ta Metiu. Ya iri lau solo-an ta akohok luk ta takis, ma hawe iri Juwis ale ba-en hamon ta kandriyen ta batanau ta Moses bwe, ame aimon nyamon hawen, ma oro lau tan. ");
INSERT INTO lid_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Eme oro Parasi atou, ma oro orou sahou i ta Jises, ma oro tiye toro lau tan buku doh, “Tasah handru ndramak ta leheya tado aimon nyamon hawe oro lau ta akohok luk ta takis, ma hawe oro lau ale ba-en hamon ta batanau ta Moses bwe?” ");
INSERT INTO lid_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jises anuhun sahou toro, ma iy tiye, “Iri lau ale babo sik bwe, iri winiyan baso-ok ndramak ta anyumor bwe. Arile, iri lau tiri sik le badeh, aseken seben. ");
INSERT INTO lid_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ado kala kabudon kati sahou sokek dah kamwenen, ‘Jo baso-ok salom laleyah aha amekes eme tek bwe, arile jo aso-ok handru aha kamekes kandriyen ta tikisiy ki ta ndramak ari ja.’” Eme Jises anya ja, “Jo eme dah ta aseben lau mwasin le, bwe. Jo eme dah badeh, ta aseben iri lau ta karei ma lomondra ndra-in udu tiri kasahan mwasin.” ");
INSERT INTO lid_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jises hawe oro lau tan aimon nyamon kahis le badeh, oro lau ra-on ta Jon ta alomwa ame ndremenya iy i buku doh, “I buku sah handru ahi lau ta Jon hawe oro Parasi abeles ahi ta nyamon, ya oro lau tam bwe?” ");
INSERT INTO lid_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Eme Jises asumon i buku doh, “I buku none ndramak tasou bolohau udu aliy, ado winiyan babilisi oro lau ta molak bwe! Arile, na len hamon eme kameh, iri lau ta kaliu tan kuhi iy eme len, ma oro kameh, winiyan baimon nyamon bwe, oro kameh beleben, ma abeles oro ta nyamon. ");
INSERT INTO lid_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ado kanuhun. Ari ndramak winiyan bakuhi ranah kolau ha-un, ya suwidiy ja i manamunu awin malen bwe. Buku iri bwidiy i buku doh, ya iri sikine awin, kolau ha-un nane kameh bosokou, ma awin malen kameh atarah ja, eme ma, munun kameh i tinan labai ja. ");
INSERT INTO lid_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ari ndramak winiyan basukuni waen ha-un bala bolo ku-i me malen bwe. Buku none iy amekes i buku doh, waen doh kameh tuburok, ma kohan kameh tarani ku-i me nane, ma waen kamou, ma iu laleyah. Ma ku-i me ale kameh andra-i. Arile, iri lau asolou waen ha-un i bolo ku-i me ale ma bweseken kahis le, ma uru ma la-uh kameh ado mwasin.” ");
INSERT INTO lid_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jises asehek sahou ili toro lau ta Jon kahis le, ndramak ari tinan ta atondrok eme atehei bwili ndru-un ere mirihik ta kati Jises, ya iy tiye i buku doh, “Naduk badih ndramak na nane, arile jo aso-ok ou ame atehei le minem le ki tan, ya iy kamak ja.” ");
INSERT INTO lid_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iy tiye ano le badeh, Jises suri iy, ma iy in hamon tan, ma oro lau tan ale an hamon tan. ");
INSERT INTO lid_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Oro adek ala badeh, iy badih ari ja ereu san, sik ndra udu tan winiya jaha ronoh la-uh. Iy badih doh sokohani iy i ndrokowa iri lau ili in hamon ta Jises, ma iy abudon i buku doh, “Buku none jo katawi le kiri awin tan, sebwe jo winiyan amwenen.” Eme ma, iy atehei minen le i ta kiri awin ta Jises. ");
INSERT INTO lid_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Arile Jises tubuni iy, iy atou badih doh, ma iy anya, “Ou sabudon sandra-i, ndri-iy, naduk. Ou atehei budon tam handru in tek, ma mesekei ou asahan amwenen.” Eme na le liliy, sik tan ano, ma iy asahan amwenen. ");
INSERT INTO lid_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hamon ta aliy, Jises eme asahan asiu ta ndramak tinan nane. Eme iy atou iri lau ta kabek aden areu aliy. Iri lau doh oloh bala-eu, ma iri taya andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Eme Jises tiye i toro i buku doh, “Ado ka-au ka len. Iy nadu badih kede-eh bamak bwe, iy asah amadin le kede-eh.” Iri anuhun sahou tan, ma iri ehe-en iy andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Arile Jises abadok, ma tikahei iri ala manan. Eme ma iy ili bolo asiu, ma iy tawi mine nadu badih nane, ma iy amak ja. ");
INSERT INTO lid_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Eme ma, sahou nyala lakou nane Jises mesekei aseker i bolo kon loboho nane doh. ");
INSERT INTO lid_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jises ruwani kon nane, ma iy edek ili, ma uru lau la-uh mada uru bwe adek an hamon tan, ma uru aloh i tan anya, “O nadu tubu kabin Debit, ou tikisi aru!” ");
INSERT INTO lid_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jises ili bolo asiu ra-em, ma uru lau ma la-uh nane ame hawen. Ma iy ndremenyani uru, “Ah atehei budon boto-on handru ta jo winiyan mesekei ah amwenen deh bwe?” Ma uru anya, “Ehe, Laban, aru atehei budon taru handru.” ");
INSERT INTO lid_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eme Jises atehei minen i mada uru, ma iy anya, “Ah atehei budon boto-on in tek, ma lakou mwasin nane ah aseken kasahan ta ah.” ");
INSERT INTO lid_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Se nawin bwe mada uru asak. Arile, Jises atehei sahou boto-on anya, “Ah sasehek nyala ari lau ja, ta lakou asahan ta ah dah, ndri-iy.” ");
INSERT INTO lid_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Arile, uru ala asehek nyala lakou nane Jises mesekei asahan turu ili nyala iri lau mari badu loboho kon tinan nane doh. ");
INSERT INTO lid_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kala le uru lau mala-uh nane ruwani Jises, oro lau ra-on kuhi ndramak ari bohon bwe, ma malawin ndra-in ereu la-un. ");
INSERT INTO lid_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eme ma Jises tikahei malawin ndra-in nane iu, ma ndramak nane bohon bwe asehek sahou ja. Eme ya iri lau mari mani iri atur labai, ma anya, “Aden! Bwena mene ari lakou buku doh basahan bolo kon tinan Isra-el bwe, handru en!” ");
INSERT INTO lid_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Arile, iri Parasi anya, “Iy atikah malawin ndra-in iu tasah, tinan tiri malawin ndra-in badeh, edeu boto-on ili tan ta amekes lakou doh.” ");
INSERT INTO lid_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Hamon ta aliy, Jises edek ili bolo iri kon tinan ma bwisik mari, ma iy leheya iri in bolo asiu ta atukum tiri. Iy atiye sahou mwasin ta Kindrei aso-ok iri lau mwan ma badih, ma iy aso-ok iri kame baha tondrok mwasin tan. Ma Jises ale mesekei iri lau mari tiri sik in bada iri amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Eme Jises atou iri lau solo-an labai atukum, ma iy tikisi iri. Tasah, budon tiri inyon laleyah ta san ta takaleh Kindrei, ma iri ado ndra-in labai, buku none sipsip lau ta atondrok iri bwe. ");
INSERT INTO lid_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eme ma Jises tiye toro lau tan anya, “Ado katou, nyamon solo-an labai ndruni in bolo bilin, arile lau solo-an bwe, ta gok ta akohok nyamon nane doh bwe. ");
INSERT INTO lid_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Eme ya ado kasolom ki ta Laban ta kati bilin, ta iy kasuni lau kala katukumwi iri nyamon tan.” ");
INSERT INTO lid_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jises luhi oro lau tan ma ronoh la-uh ame hawen, ma iy edeu boto-on ili toro ta atikah malawin ndra-in in la-u lau mwan ma badih iu, ma amekes iri lau tiri sik in bada iri amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nyara oro aposel ma ronoh la-uh i buku doh: Ari in bwena badeh, Saimon, nyaran ari ja Pita, ma nadu tinen Enduru. Ano, Jemis hawe Jon, uru nadu Sebedi. ");
INSERT INTO lid_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ano Pilip uru Batolomiu, ma Tomas, hawe Metiu, iy lau ta akohok luk ta takis, ma hawe Jemis nadu Alpeyus, ma Tadeyus. ");
INSERT INTO lid_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ma hawe Saimon, iy lau badu bolo iri Selot, ma Judas Iskariyot, ndramak doh hamon kameh iy edeu sa-oh ta Jises. ");
INSERT INTO lid_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jises suni oro lau tan ma ronoh la-uh ala, ma iy atehei sahou i toro i buku doh, “Ado sala bolo kon ale iri lau badu Isra-el bwe, ndri-iy. Ma ado sala bolo kon tinan tiri Samariya. ");
INSERT INTO lid_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ado kala hawe iri lau mwan ma badih ale badu boho kamen tiri Isra-el amwenen, iri amai buku none sipsip iri lau ta atondrok iri bwe. ");
INSERT INTO lid_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ado kala kasehek nyala iri buku doh, ‘Mirihik kameh Kindrei eme atondrok iri lau badu kon munyak.’ ");
INSERT INTO lid_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ado kala kamekes kamwenen iri lau abo sik, ma ado kamak iri lau ale ndramak, ma kamekes kamwenen iri lau sik lepra udu bada iri, ma ado katikah iri malawin ndra-in udu la-u iri lau ki-iu. Lakou ado ndrakohok dah, ado akohok laleyah, ma sihinen bwe. Ya ado ale kadeu laleyah kili tiri lau mwan ma badih. Ado sakohok luk ta gok ado amekes, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ado sakohok gol, silba ma hawe kaba su-iy sareu mine ado, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ya buku ado adek, ado sabwese kohei ta nyamon, ndri-iy. Ma ado sakohok awin la-uh deh ku-i kati ado, deh ari kei ja ta edek hawe ado, ndri-iy. Ado kala laleyah le. Tasah, ndramak ibo gok, iri lau mwan ma badih kameh anyohan iy na nyamon, ma adeu lakou i tan. ");
INSERT INTO lid_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Buku none ado ala bolo ari kon tinan deh, ari kon bwisik, ado kanyolom kamwenen are lau handru badu bolo kon doh sekesek ta akohok ado, ya ado ka-en hawen winiya le ado ruwani kon nane doh. ");
INSERT INTO lid_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Buku none ado ala bolo ra-em asiu, ado kasehek toro lau ta asiu ki buku doh, ‘Kindrei katondrokei ado, ma ado kado mwasin.’ ");
INSERT INTO lid_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ya buku none oro lau badu asiu nane sekesek ta akohok ado, mwasin, sahou tado mwasin kudu la-u oro. Arile, buku none oro basekesek ta akohok ado bwe, mwasin, ado kakuhi sahou tado mwasin nane keme hamon ja. ");
INSERT INTO lid_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Buku none ari ndramak basekesek ta akohok ado ala asiu tan bwe, ma basekesek ta anuhun sahou tado bwe, mwasin. Ya buku none ado ruwani asiu deh kon nane, ado katuruhi kasu on ma ndren ta kati ado ki-iu, ma ado ka-au. ");
INSERT INTO lid_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jo asehek sahou handru ewek tado, na len Kindrei edeu lau ala ta mada sahou eme kameh, kon tinan dah kameh, bwese maha-an laba tinan tinan labai sakalawi ja maha-an mene asahan tiri lau ndra-in badu kon tinan Sodom ma Gomora.” ");
INSERT INTO lid_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jises asehek sahou ili ja buku doh, “Ado kanuhun! Jo kasuni ado buku none le sipsip ili bolo iri mwi badu lokei. Arile, ado kamekes budon ki mwasin buku none le mwak amekes, arile ado samekes kandriyen ndra-in ta amekes ndra-in ili bada ndramak ari ja. Aha kasahan ki buku le sirih aloh ban ale ba-um ari lakou bwe. ");
INSERT INTO lid_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Arile, mada ado kaleu! Ado kanyolom iri lau kamwenen. Iri kameh atehei ado ala mada iri kansol ta anuhun sahou, ya iri kameh a-um aha na bala oseu an bolo asiu tiri ta atukum, tasah ado an hamon ta sahou tek. ");
INSERT INTO lid_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Handru labai! Iri kameh seheyani ado ala mada iri lau ta atondrok, ma hawe iri kabin, ma iri kameh atehei ado ala ta mada sahou. Idoh le, ado winiyan leheya sahou tek ili tiri, ma hawe iri lau mwan ma badih badu leheleh ale. ");
INSERT INTO lid_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Buku none iri atehei ado ala ta mada sahou, ado sabwerei, ta saba san ado kasehek sahou, ma ta saba sahou kameh ado kasehek. Ado sabudon sandra-i, ndri-iy. Na len doh amwenen kameh Kindrei leheya ado ta saba sahou kameh asahan boho ado ta ado asehek. ");
INSERT INTO lid_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tasah, idoh ado amwenen basehek sahou bwe. Malawi Ndrabun ta tama ado amwenen kameh asehek sahou na boho ado. ");
INSERT INTO lid_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Na len doh kameh, ndramak atehei nadu tinen amwenen ili ta mada sahou, ya iy kameh edeu sa-oh tan. Ya tama iri ra-on ale kameh amekes i buku aliy ili ta nadu iri. Ma iri nah ra-on kameh asahan lau ta bahun ili ta tama ma tine iri, ma iri kameh atehei iri ala mada iri lau tinan ta kadai iri kamak. ");
INSERT INTO lid_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ya iri lau mari kameh baseken ado bwe, tasah ado badeh, an hamon ta sahou tek. Arile, are lau ales boto-on, ma baruwani budon tan ba-au tek bwe, winiya le len ta maha-an doh ano, Kindrei kameh andrei iy eme hamon. ");
INSERT INTO lid_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ya buku none are lau mwan deh badih badu saba kon tinan amekes ndra-in ewek tado, mwasin, ado katobwak kala kon tinan ari ja. Jo asehek sahou handru ewek tado, ado winiyan babwidi gok dah bano bwe udu bolo iri kon tinan badu Isra-el, ya jo Nadu Ndramak Awas ta Kindrei kameh eme hamon ja. ");
INSERT INTO lid_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ado kanuhun. Ari ndramak ta akohok tanan basakalawi ndramak ta leheya iy bwe. Ari bonyo-ou basakalawi ndramak ta atondrok iy bwe. ");
INSERT INTO lid_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Arile, buku none ari ndramak ta akohok tanan asahan buku none ndramak ta leheya iy, mwasin. Ya buku none ari bonyo-ou asahan buku none ndramak ta atondrok iy, mwasin. Iri lau tinan badu Isra-el tondrohani jo tama boho kamen, nyarak Belsabul. Ya idoh ado katana ado, iri kameh tondrohani nyara ado i le ndra-in labai, tasah, ado lau mwan ma badih an hamon tek.” ");
INSERT INTO lid_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jises asehek sahou ili ja buku doh, “Ado sanoh tiri lau ale anya kamekes ndra-in ewek tado. Lakou mari ale aton kede-eh kameh asahan eme lewan, lau mari kameh anuhun ma atou na mada iri. ");
INSERT INTO lid_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ya sahou jo asehek tado dan, hamon ado kasehek nyala iri lau mari. Sahou jo ohei nyala ado le dah, arile hamon, ado kales kare bwele-e ndrahu tukum tiri lau, ya ado kasehek nyala saba lakou jo asehek nyala ado dah, ki tinan ta lau mari kanuhun. ");
INSERT INTO lid_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ado sanoh tiri lau ale winiyan idi bada ado na dah, arile iri winiyan badai malawi ado bwe. Arile ado kanoh labai ta Kindrei, tasah iy winiyan idi malawim ma badam udu bolo jih ale anya udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Ado tana ado, iri lau asih sirih nadu bwisik ma la-uh na luk bororoh le, neh? Arile, tama ado badeh, atondrok uru sirih doh udu mwasin labai. Ari winiyan bamak bwe buku none tama ado baso-ok ta iy imek bwe. ");
INSERT INTO lid_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kindrei ale ndrandromwei lami batu ado mari, ya iy tanan ado mwasin labai. ");
INSERT INTO lid_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ya, ado sanoh tiri lakou ndra-in iri lau anya kamekes kewek tado. Kindrei winiyan tondrokei ado. Ado kanuhun! Ereu budon ta Kindrei, iri sirih badeh, lakou laleyah, arile iy atondrok iri. Eme ya iy winiyan tondrokei ado areu mwasin labai ja. ");
INSERT INTO lid_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Eme ma, are lau ale asehek ili tiri lau mwan ma badih buku none iy badu hawek, jo ale kameh asehek ta tama udu kon loken buku iy ndramak doh badu hawek handru. ");
INSERT INTO lid_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Arile, are lau asehek ta ndramak ari ja buku iy badu hawek bwe, jo ale kameh asehek ta tama udu kon loken, buku iy lau doh badu hawek bwe ale.” ");
INSERT INTO lid_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jises asehek sahou ili ja buku doh, “Ado satehei budon buku jo eme ta amekes mondrei. Bwe! Jo eme ta amekes buku doh bwe. Jo eme ta apou lau. ");
INSERT INTO lid_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Handru, jo eme, ‘ta amekes kandriyen ta andres asahan. Idah kameh, lau mwan kameh andres i la-u taman, ya nadu badih kameh andres i la-u tinen. Ya salahun uru kayon kameh andres uru, i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Lowa ndramak amwenen kameh amekes bahun i tan.’ ");
INSERT INTO lid_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Buku lau mwan o badih aso-ok taman uru tinen, idoh mwasin, arile, ki buku none iy baso-ok jo handru bwe ja, iy winiyan basahan lau tek bwe. Ya buku ndramak aso-ok nadun mwan deh badih, mwasin ale. Arile, ki buku none iri baso-ok jo handru bwe ja, iri winiyan basahan lau tek bwe le. ");
INSERT INTO lid_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ya, are lau mwan deh badih balokou iy ta imek ereu hamon tek bwe, buku none ndramak ta imek iy kabwese kei tondreh tan amwenen, iy badeh, winiyan basahan lau tek bwe. ");
INSERT INTO lid_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Iy are lau iy atehei budon boto-on ta amekes manyah tan kudu mwasin, iy winiyan batakalahei kohan mwasin bwe. Arile, are lau anya ki-in hamon tek, ya iy babudon ta kohan nadah bwe, iy winiyan akohok manyah mwasin hamon.” ");
INSERT INTO lid_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jises asehek sahou ili ja buku doh, “Are lau akohok ado ma aseben ado, idoh i buku none le iri akohok jo ma aseben jo. Ma are lau akohok jo, idoh i buku none le iy akohok Kindrei, iy suni jo eme dah. ");
INSERT INTO lid_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Buku none are lau akohok ari propet ta Kindrei, ma nyowo-ei iy udu asiu tan, hamon kameh Kindrei akunoh iy, buku le sihine iri lau ta atiye bohon. Ya buku none are lau akohok iri lau mwasin ili asiu tan ma anyo-ou iri, hamon kameh Kindrei akunoh iri buku le sihine iri lau mwasin. ");
INSERT INTO lid_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ya are lau atehei le ari bwiniu gwa i wa-i are lau laleyah badu hamon tek, mwasin, jo asehek handru ewek tado: Sihine i lau doh winiyan ba-au laleyah bwe.” ");
INSERT INTO lid_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jises tiye sahou ili toro lau tan ma ronoh la-uh ano, iy ruwani kon nane, ya iy edek ili bolo iri kon tinan loboho Galili. Ya iy leheya ma asehek sahou nyala Kindrei ili tiri. ");
INSERT INTO lid_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kala doh Jon ta alomwa ereu bolo kou. Iy anuhun yoyou ta gok mari Krais amekes, ya iy suni oro lau tan ra-on ala atou Jises. Iy tiye toro ");
INSERT INTO lid_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta ndremenya Jises i buku doh, “Sebwe ou ndramak aloh Krais, Kindrei mene tandrakan ta iy kameh suni iy eme. Buku none bwe, sebwe ahi kabe-en ndramak ari ja nadeh?” ");
INSERT INTO lid_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Eme Jises asumon boho oro i buku doh, “Ado kala hamon katiye ta Jon ta saba lakou ado ndratou ma ndranuhun dah: ");
INSERT INTO lid_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Iri lau mada iri bwe, iri atou kon ja, iri kati iri ndra-in iri adek ja, iri lau lepra udu bada iri, iri asahan amwenen, ma iri ndranye iri bwe, iri anuhun kon ja, ya iri lau ndramak, iri ndrasahan ndrame awas ja, ma hawe sahou ta nyala sahou mwasin badeh, ndratiyaniy ndrala bolo iri lau, lakou bwe. ");
INSERT INTO lid_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Eme ya, sekesek ki toro lau heh le nane bataku ta budon toro bwe, tasah ta jo le.” ");
INSERT INTO lid_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Eme oro lau ta Jon au ala hamon. Eme ma Jises asehek sahou ili tiri lau nyala Jon, “Buku sah, aha mene ala kon lomale an, anya katou sasah? Ari bwidiu awa-is nyukunyok ereu bolo jor neh? Sebwe bwe nadeh! ");
INSERT INTO lid_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aha ala anya katou sah handru? Ndramak ari atehei awin mwasin ereu badan? Bwe oh! Iri lau asin awin mwasin badeh, badu bolo asiu tiri kabin. ");
INSERT INTO lid_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Saba lakou handru aha anya kala katou? Sebwe aha anya kala katou propet? Ehe, aha atou iy, ma jo katiye tado kamwenen, iy badeh sakalawi iri lau mari mene ta atiye boho Kindrei ndra-au ndrala bwena. ");
INSERT INTO lid_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Eme sahou torowenei udu bolo buk ndrabun tiye i buku doh, ‘Jo kameh suni ndramak ari ewek bwena tam. Iy kameh atehe san tam.’ ");
INSERT INTO lid_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jo tiye tado amwenen, Jon ta alomwa badeh sakalawi iri lau mari tine iri tuwi iri ereu kon munyak eme kala dah. Arile, are lau nyaran bwe, udu baha tondrok ta Kindrei eme kameh sakalawi nyara Jon ja. ");
INSERT INTO lid_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kala mene Jon ta alomwa leheya sahou ta Kindrei eme winiya na len dah, iri lau solo-an ta bahun abo gok boto-on labai ta tiyani tondrok ta Kindrei keme bolo munyak, ya iri anya kasuni ari lau ta ereu bwena tiri. ");
INSERT INTO lid_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bwena handru kala Jon basahan bwe le, iri sahou mari ta Moses hawe iri propet badeh, leheya saba lakou Kindrei anya kamekes. ");
INSERT INTO lid_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ya buku none ado anya kanuhun, ado katunuhun kamwenen. Buk ndrabun ta Kindrei anya, propet Alaija kameh eme. Ya iy asehek nyala Jon amwenen. Iy badeh, ndramak nane nyaran Alaija, iri mene asehek anya, iy kameh eme. ");
INSERT INTO lid_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ou are lau ndranyem udu aliy, ou anuhun. ");
INSERT INTO lid_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Arile, jo kasehek iri lau na len dah ki buku sah handru? Iri badeh, i buku none le iri nah nadu bwisik manyah areu mada ba-en. Ra-on arah i ta ra-on i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Aso oloh bala eu ta molak ewek tado, arile ado bada mana bwe; ya aso ayah wari ta kabek, arile ado bataya bwe.’” ");
INSERT INTO lid_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jises leheya kati sahou sokek i buku doh, “Kala Jon mene eme, iy abeles iy ta nyamon ta iy kedeu budon tan boto-on kili ta Kindrei, ma iy ba-un gwa waen bwe, ma iri lau anya, ‘Aha sanuhun ndramak kede-eh, ndri-iy. Malawin ndra-in ereu la-un!’ ");
INSERT INTO lid_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ya, jo Nadu Ndramak Awas, jo eme aimon nyamon, ma a-un gwa waen hawe iri lau. Eme ma iri lau asehek jo i buku doh, ‘Aden, aha katou iy ndramak ta aimon nyamon tinan, ma iy ndramak ta a-un gwa waen solo-an labai. Iy ndramak ndra-in labai. Tasah handru iy amekes kawas hawe iri lau ta akohok takis, ma iri lau ba-en hamon ta batanau ta Moses bwe?’ Ehe, iri amekes sahou i buku doh. Arile, are lau mwan ma badih ale idih ta budon ta Kindrei, iy kameh amekes kandriyen mwasin, ya iri lau kameh atana iri buku none ndramak doh edek san mwasin handru.” ");
INSERT INTO lid_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","In bolo iri kon tinan ra-on mene, Jises amekes lahou tinan udu mada iri, arile iri batubuni ndrine iri bwe, eme Jises ibolosen ili tiri lau badu kon tinan nane doh. ");
INSERT INTO lid_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Iy tiye i buku doh, “Ado lau badu kon Korasin hawe ado lau badu kon Betsaida, ado katou! Sisi-in tinan labai kameh ewek bwele-e ado. Tasah, ki buku none lau ra-on mene kala kon tinan Tair hawe Saidon ma kamekes lahou tinan buku none jo ndramekes ereu ndrokowa ado, sebwe ndra bwena iri lau badu kon ma lubuk doh ndrasin awin bokodon, ma ndratahi iri na koloweh, ta leheya buku none iri tikisiy handru ta kandriyen ndra-in tiri mene, iri ndrabwidiy. ");
INSERT INTO lid_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Arile, jo tiye tado na dah, na len Kindrei le tanan ta adeu lau ala ta mada sahou, ado kameh bwese maha-an udu bwele-en labai ja ta kon Tair hawe Saidon. ");
INSERT INTO lid_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ya aha lau badu Kapena-um, sebwe iri lau ra-on ja kameh bwese nyara ado ili loken ili kandrah nadeh? Bwe handru en! Kindrei kameh akahei ado ala bolo jih, kon tiri lau ndra-in amak ado aliy. Tasah, buku none iri lau kala kon Sodom ma kamekes iri lahou tinan buku none jo amekes ereu ndrokowa ado dah, sebwe Sodom ereu kede-eh kahis le nadeh! ");
INSERT INTO lid_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eme ma jo tiye tado amwenen. Hamon na len Kindrei le tanan ta adeu lau ala ta mada sahou, maha-an asahan tado kameh sakalawi ja maha-an mene asahan tiri lau badu Sodom. Tasah, ado atou iri lakou mari jo amekes, arile ado batehei budon boto-on ba-en hamon tek bwe.” ");
INSERT INTO lid_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kala doh Jises tiye buku doh, “Tama, ou Laban badu munyak ma kandrah. Jo masiye ou! Tasah, ou tone lakou dah, ta mada iri lau ta tanan, ma hawe iri lau anya iri tanan labai, ya ou leheyani i tiri nah, tana iri lakou bwe. ");
INSERT INTO lid_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ehe, idoh asahan na seken tam le.” ");
INSERT INTO lid_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Eme ma, Jises asehek ili ja buku doh, “Tama ndratehei lakou mari ndrame minek. Ya ari ndramak ja winiyan bala tanan jo bala mwasin bwe. Tama le ari tanan jo udu mwasin labai. Ya ari ndramak ja winiyan bala tanan tama bala mwasin bwe; jo nadun le ari tanan iy, hawe oro lau le jo ndranyowonyani oro ndrala mada taman, oro le tana oro tama. ");
INSERT INTO lid_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Aha lau mwan ma badih abo gok boto-on labai ta asahan mwasin ereu mada Kindrei, ma akohok maha-an labai, aha mari kame hawek, ma jo kabwidi aha kamunyau. ");
INSERT INTO lid_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Aha kakohok tanan tek, ma ka-en hamon ta sahou tek, buku none le bulumakau udu le ya taman aseu kei ranah i tondreh in balen ta amekes iy aliu iri lakou. Ehe, aha kakohok tanan udu tek, tasah jo amekes lakou i san ta manamun i tiri lau mwan ma badih, ma jo babolosen ma basobolon ari ndramak bwe. Ya iri lakou tek kameh bamekes maha-an bala ta ari ndramak bwe, ya manyah taha kameh udu mwasin. ");
INSERT INTO lid_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ehe, lakou mari jo ndratiye taha, aha ka-en hamon ta aliy; idoh boto-on handru bwe, ya lakou mari jo edeu ewek taha ta bwese badeh, maha-an handru bwe.” ");
INSERT INTO lid_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ano, udu bolo len ari ta amunyau, Jises hawe oro lau tan adek bolo bilin ari ta wit. Oro lau tan amak son, ya oro abwe-eh buwa iri wit, ma oro aimon. ");
INSERT INTO lid_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iri lau Parasi atou lakou nane doh, ma iri abolosen i ta Jises buku doh, “Hei, ou anuhun! Oro lau tam abwe-eh buwa wit na len ta amunyau. Kandriyen doh ndrabun handru ta amekes na len ta amunyau.” ");
INSERT INTO lid_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jises asumon iri i buku doh, “Buku sah handru ya ado abolosen eme tek ma hawe oro lau tek? Sebwe ado babudon bamwenen ta kundruh ta lakou mene kabin Debit mesekei bwena bwe nadeh? Jo asehek ta lakou kala Debit hawe oro lau tan mene amak son. ");
INSERT INTO lid_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ya, iy ili bolo asiu ta Kindrei, ya kuhi jabi ramen nane iri pris ndraleheyaniy ndrala ta mada Kindrei, in bolo bosoh ndrabun handru doh. Ehe, Debit hawe oro lau tan aniy, arile jabi ramen doh ndrabun handru ta oro aimon. Iri pris le winiyan ta aimon. ");
INSERT INTO lid_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ya, sebwe aha banyolom sahou ereu bolo batanau malen bwe nadeh? Anya iri pris badeh kabo gok bolo asiu tinan ta Kindrei na len ta amunyau, idoh iri ba-en hamon ta sahou na len ta amunyau bwe, arile idoh kandriyen ndra-in bwe. ");
INSERT INTO lid_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Arile, jo tiye tado, ndramak ari in dah, iy sakalawi ja asiu tinan ta Kindrei, ma kandriyen ta len ta amunyau ale. ");
INSERT INTO lid_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sahou ta Kindrei ereu bolo buk ndrabun anya, ‘Jo baso-ok salom laleyah aha amekes eme tek bwe, arile jo aso-ok handru aha kamekes kandriyen ta tikisiy ki ta ndramak ari ja.’ Buku none aha tana aha kati sahou ta Kindrei doh, sebwe aha winiyan babolosen, ma bamekes sahou ndra-in bala bada ari ndramak iy kandriyen ndra-in badan bwe. Arile bwe, aha tanan kati sahou dah handru bwe. ");
INSERT INTO lid_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jo asehek tado, oro lau tek badeh, babwidi ari kandriyen ndra-in bwe, tasah jo Nadu Ndramak Awas, ya jo tama len ta amunyau.” ");
INSERT INTO lid_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ano Jises ruwani kon nane, ma iy ili bolo asiu ari tiri ta atukum. ");
INSERT INTO lid_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ya in bolo asiu ta atukum nane iy ndruni ndramak ari minen raka ndramak. Iri lau ra-on anya kadeu Jises kili ta mada sahou, eme ya oro ndremenyani iy i buku doh, “Taha winiyan amekes iri lau abo sik amwenen na len ta amunyau, deh bwe?” ");
INSERT INTO lid_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jises ndremenya oro anya, “Ya ki buku none ari tado tan ari sipsip, ya sipsip nane kataku ki bolo lek na len ta amunyau. Ado tana ado, sebwe ndramak nane winiyan tawi sipsip, ma aluwi iy eme loken nadeh? Handru, iy ibo gok na len ta amunyau, tasah buku none iy bamekes bwe, sipsip doh kameh imek, neh? ");
INSERT INTO lid_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ya ado kanuhun! Iri lau mwan ma badih badeh, sakalawi sipsip ja. Eme ya, mwasin ta aha kamekes kandriyen mwasin, ma kaseben iri lau abo sik na len ta amunyau.” ");
INSERT INTO lid_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iy tiye toro ano, iy tubuni iy ma iy tiye i ta ndramak nane minen ndra-in, iy anya, “Minem kales!” Nawin bwe ndramak nane minen ales, ma minen amwenen buku le minen raka mwasin nane. ");
INSERT INTO lid_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jises bwidi buku doh, ma iri Parasi ruwani asiu ta atukum, ma iri asehek ma atilik nyala iri ta takaleh san ta kadai Jises kimek. ");
INSERT INTO lid_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kala doh Jises i tanan budon tiri Parasi ta oro anya kamekes saba lakou i tan, eme iy ruwani kon tinan nane doh, ma iy edek iu ili. Iri lau mwan ma badih solo-an an hamon tan, eme ma iy mesekei iri mari amwenen ta sik tiri. ");
INSERT INTO lid_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Eme Jises batanau iri ta iri sasehek nyaran sala ta ndramak ari ja, ma sasehek nyala gok iy ndramesekei ta aseben iri. ");
INSERT INTO lid_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iy mesekei lakou doh in hamon ta sahou randra Kindrei mene tiye ta propet nyaran Aisaya. Iy mene torowenei i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Iy ndramak dah, ta amekes gok tek handru. Jo aso-ok iy handru, ndrinek badeh, sekesek tan handru. Jo kameh atehei Malawik Mwasin i la-un, ya iy kameh asehek nyala gok tek mwasin ta jo kameh akohok iri lau mari badu kon munyak dah ame hamon. ");
INSERT INTO lid_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iy winiyan babolosen ma barah laleyah bwe. Iri lau mwan ma badih winiyan banuhun iy asehek sahou laleyah ereu madasan, ma ereu mada baen bwe. ");
INSERT INTO lid_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bale banap badeh, boto-on bwe, ma anya kibok, iy winiyan batubwaniy bwe, ma iy winiyan basemete-ei sun ale banya bamwenen bwe. Iy kameh ibo gok udu le winiya le iy mesekei iri lau mari atana iri gok jo amekes ta akohok iri ame hamon. ");
INSERT INTO lid_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ya iri lau mwan ma badih badu boho kamen tiri Isra-el bwe, kameh atehei budon i tan, ma iri kameh abe-en iy akohok iri ame hamon.” ");
INSERT INTO lid_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kala doh oro lau ra-on kuhi ndramak ari malawin ndra-in udu la-un. Oro kuhi iy eme hawe Jises. Ndramak doh nane iy madan bwe, ma bohon bwe ale. Eme Jises mesekei iy amwenen, ma iy anyolom na madan ma asehek sahou na bohon ja. ");
INSERT INTO lid_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iri lau mari boho iri asak, ma iri anya, “Sebwe ndramak kede-eh nadu tubu kabin Debit ale taha abe-en iy ta eme kede-eh nadeh?” ");
INSERT INTO lid_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Arile, oro Parasi anuhun iri lau nane asehek sahou i buku doh, ma oro anya, “Bwe, iy ndramak nane Krais bwe, iy ndramak nane atikah malawin ndra-in ereu la-u ndramak nane iu badeh, na boto-on ta Belsabul, tinan tiri balik.” ");
INSERT INTO lid_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Arile Jises ndrandrei budon toro, ndra-in i tan, eme iy asehek i toro i buku doh, “Buku none iri lau badu kon munyak tinan kapou iri ranah i len, ma ranah i len, ma iri amekes bahun, iri lau badu kon doh kameh andra-i. Ya buku none iri lau badu kon rakon, deh badu boho kamen ra-em aseker, ma amekes bahun, iri lau doh winiyan bales boto-on bwe. ");
INSERT INTO lid_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ya ki buku oro lau ta Satan katikah Satan, ma oro lau tan kapou oro ki lumuk, ya ki buku sah handru iy tan boto-on ta atondrok iri lakou? ");
INSERT INTO lid_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ya, ki buku none Belsabul aseben jo handru, ma jo katikah iri malawin ndra-in, ya are lau handru aseben iri lau taha ta atikah malawin ndra-in? Sebwe balik aseben oro nadeh? Iri gok oro lau tado amekes, leheya buku none sahou tado badeh, bamwenen bwe. ");
INSERT INTO lid_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Arile ado kanuhun, i buku none Malawin Ndrabun ta Kindrei aseben jo ta atikah iri malawin ndra-in, ado ndratana ado kabwe, Kindrei ndrame ta atondrok aha lau mwan ma badih badu Isra-el. ");
INSERT INTO lid_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ya buku none ari ndramak anya ki bolo asiu ta ari ndramak boto-on, ma kabahana iri lakou tan, iy kameh amekes sah handru? Ma bwena handru iy kameh sawei iy ndramak boto-on nane na malou boto-on. Ano, iy winiyan akohok iri lakou ereu asiu ta ndramak nane. ");
INSERT INTO lid_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ya eme are lau iy kawas tek bwe, iy ndramak ta amekes bahun eme tek. Ya are lau baseben jo ta atukum iri lau kame ka-en hamon ta Kindrei bwe, iy kameh atikah iri lau ka-en ndra len ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Eme ma ado kanuhun, ya jo kasehek tado, Kindrei kameh mani kandriyen ndra-in, ma sahou ndra-in mari lau mwan ma badih amekes. Arile are lau aluhe i bada nyara Malawin Ndrabun, Kindrei winiyan bamani kandriyen ndra-in tan doh bwe. ");
INSERT INTO lid_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ma are lau asehek sahou ndra-in i bada Nadu Ndramak Awas, Kindrei le kameh winiyan mani kandriyen ndra-in tan. Arile, are lau amekes sahou ndra-in i bada Malawin Ndrabun, Kindrei winiyan bamani kandriyen ndra-in tan doh na len dah, deh na len eme hamon, bwe-en.” ");
INSERT INTO lid_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jises asehek sahou ra-on ja i buku doh, “Buku none kei mwasin, buwa kei doh kameh mwasin ale. Arile, buku none kei doh ndra-in, buwa kei doh ndra-in ale. Lau kanyolom buwa kei mwena, hamon iri barala tana iri buku kei doh mwasin deh bwe. ");
INSERT INTO lid_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Idoh buku le aha Parasi. Aha lau buku le mwak ndra-in, ya aha winiyan bamekes sahou mwasin na boho aha bwe. Tasah, boho ndramak badeh, asehek iri budon solo-an ale idih ereu bolo ndrinen amwenen. ");
INSERT INTO lid_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Buku none ndramak mwasin ma budon mwasin solo-an idih ereu ndrinen, idon adeh, iy ale amekes kandriyen mwasin ale. Iri lau ndra-in, tiri budon ndra-in solo-an ereu ndrine iri, ma iri ale amekes kandriyen ndra ndra-in le. ");
INSERT INTO lid_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Arile jo tiye tado, na len hamon Kindrei le tanan ta edeu lau ala ta mada sahou ma anuhun sahou ta lau mari, iy kameh bwetenei iri sahou ndra-in iri mene ndrasehek, iy kameh anuhun sahou mari iri asehek laleyah. ");
INSERT INTO lid_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ehe, sahou doh handru! Tasah, Kindrei kameh aleben aha ta sahou mene aha ndrasihidiy. Ma, na idoh Kindrei kameh aloh aha lau mwasin deh lau ndra-in, kandriyen tan ndra-in udu badan.” ");
INSERT INTO lid_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jises asehek sahou ano, eme oro lau ra-on ta leheya kandriyen tiri Juwis hawe oro Parasi ra-on asehek sahou i ta Jises i buku doh, “Ndramak ta leheya, aso aso-ok ou amekes ari kalem ta leheya eme taso, buku ou amekes gok ta Kindrei handru.” ");
INSERT INTO lid_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Arile Jises asumon i buku doh, “Iri lau mwan ma badih ta len dah badeh, iri ndra-in handru, ma iri batehei ndrine iri handru bala ta Kindrei bwe. Iri ndremenya ta anya katou kalem, arile winiyan bwai. Kalem ari le kameh iri atou, kalem ta propet Jona. ");
INSERT INTO lid_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ehe, Jona badeh, in bolo ndrine ni tinan in gwek na taloh len ma taloh ben. Idoh ya jo Nadu Ndramak Awas ale kameh, jo kameh ereu bolo lek na taloh len ma taloh ben. ");
INSERT INTO lid_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na len Kindrei le tanan ta edeu iri lau ala ta mada sahou, iri lau mwan ma badih badu Ninibe ale kameh ales ala ta mada sahou, ma iri kameh asehek sahou boto-on labai i taha lau ta len hamon dah. Tasah, iri lau badu Ninibe anuhun sahou Jona asehek, ma iri tubuni ndrine iri. Na idah, ndramak ari ereu ndrokowa ado dah, sakalawi ja Jona, arile ado banuhun sahou tan, ma batubuni ndrine ado bwe! ");
INSERT INTO lid_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na len hamon ta Kindrei kameh atehei iri lau mari badu kon munyak dah ala ta mada sahou, badih tinan kabin badu kon tinan Seba, kon tan in le loboho kum, kameh ales ereu mada sahou, iy kameh asehek ma nyowonya iri kandriyen ndra-in taha lau ta len hamon dah amekes. Tasah, iy badih kabin doh ereu len labai ta Isra-el, arile iy eme ta anuhun le kabin Solomon leheya iri tanan mwasin tan. Na dah, ndramak ari ereu ndrokowa ado, iy sakalawi ja Solomon, arile ado banuhun sahou bwe, ma ado batubuniy ndrine ado bwe.” ");
INSERT INTO lid_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jises asehek sahou ja anya, “Buku none ari ndramak tikahei malawi balik ereu la-u ari ndramak iu, malawi balik doh iu laleyah i bolo kon lomale an ta iy katakaleh ari kon ja, iy kili aliy. Arile, iy winiyan batou ari kon mwasin ta iy ili aliy bwe. ");
INSERT INTO lid_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Iy kameh asehek, ‘Jo ndrawoyah ai, sebwe jo kili hamon kili asiu tek bwena mene jo ereu aliy.’ Eme iy ili hamon anyolom asiu nane ereu laleyah, ndrasahan ha-un, ma ndranyosowani kabwe. ");
INSERT INTO lid_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ehe, iy atou buku doh, eme iy ili hamon ja andrei oro malawi ndra-in ndro taloh ja sakalawi iy ta amekes kandriyen ndra-in. Ya oro kameh ala bolo asiu nane. Ya eme ndramak dah, bala buku bwena mene, ja bwai, iy ndrandra-i labai ai. Jo asehek tado, kandriyen buku doh kameh asahan taha lau mwan ma badih ndra-in ereu kon munyak na len dah.” ");
INSERT INTO lid_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jises asehek sahou hawe iri lau mari nane kahis le, tinen hawe oro nadu tinen ame ales areu manan. Oro anya kasehek sahou hawen. ");
INSERT INTO lid_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ndramak ari asehek tan anya, “Jises ei, tinem ma hawe nadu tinem oro ales ado manan, oro anya kasehek sahou hawem.” ");
INSERT INTO lid_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jises asehek ta ndramak nane, “Ado anya tine handru, are lau bah? Ya nadu tine oro handru, lau heh bah?” ");
INSERT INTO lid_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eme Jises nyowonya ili toro lau tan ma iy anya, “Jo asehek tado, tine ma nadu tine oro handru asah idah! ");
INSERT INTO lid_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tasah, are lau ale in hamon ta so-ok ta tama in kon tan udu kandrah, iri badeh, nadu tine mwan ma badih handru, ma tine handru.” ");
INSERT INTO lid_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Na le len nane Jises ruwani asiu nane, ma iy ili manyah udu kapa gwa li Galili. ");
INSERT INTO lid_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iri lau solo-an atukum ta anuhun iy. Eme iy ili manyah in bolo ndron ra-ei in gwa, ya iri lau mari nane dah, ales an kapa gwa an amik ai. ");
INSERT INTO lid_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jises asehek sahou sokek solo-an i tiri. Iy asehek i buku doh, “Ado kanuhun! Ndramak ari ili sabara badu wit ili bolo bilin. ");
INSERT INTO lid_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Iy akeh ili, badu wit ra-on taku in san, ya iri sirih ame aniy. ");
INSERT INTO lid_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ra-on taku in bwele-e bek, ndren solo-an mwe-en bwe, ma badu wit ateh suwi. ");
INSERT INTO lid_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Arile, an eme loken ma iy anya boto-on, iy sulumwi wit nane, tasah kandron bala bolo munyak handru bwe, eme ma iy ame-er mara-ei ma imek ai. ");
INSERT INTO lid_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ya badu wit ra-on taku i bolo iri malou bobodon, ma malou bobodon nane ateh eme loken, ma tubuluhi wit nane ma iy bato-ou buwan bwai. ");
INSERT INTO lid_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Arile, badu wit ra-on taku i bolo ndren mwasin, ma iy ato-ou buwan. Ra-on ato-ou rinek (100), ra-on ato-ou ndro hanoh (60), ra-on ato-ou tonoh (30). ");
INSERT INTO lid_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ou are lau ndranyem udu aliy, ou anuhun.” ");
INSERT INTO lid_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hamon ta aliy, oro lau ta Jises ame ndremenya i buku doh, “Tasah handru ou amekes sahou sokek ili tiri lau?” ");
INSERT INTO lid_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ma Jises asumon i buku doh, “Kindrei aseken ado lau tek katanan iri sahou mene aton ta nyala tondrok ta Kindrei. Arile iy baleheya bala tiri lau ra-on ja bwe. ");
INSERT INTO lid_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Buku none ari ndramak tanan tan tinan udu aliy, iy kameh akohok tanan rasan ja i la-un. Arile, ndramak tanan tan sese le, idah kameh kuhiy mari iu. ");
INSERT INTO lid_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na kati budon le don adeh, jo amekes sahou sokek i tiri, tasah: ‘Mada iri asak, arile iri batou saba lakou iri atou bwe. Iri anuhun sahou, arile iri tanan moson ta aliy bwe.’ ");
INSERT INTO lid_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ya iri lau don adeh, sahou randra ta propet nyaran Aisaya asahan handru. Iy mene torowenei i buku doh, ‘Ado kameh anuhun sahou san solo-an, arile ado kameh winiya bala tanan kati sahou handru bwe. Ado kameh anyolom san solo-an, arile ado kameh winiyan baseleyani ari lakou bwe. ");
INSERT INTO lid_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tasah, ndrine iri ndraso, ma ndranye iri ndrawoyah ta anuhun sahou. Ya iri ndraturuki mada iri. Kora-on mada iri katou, ma ndranye iri kanuhun, ma budon tiri ki tanan, ya iri katubuni ndrine iri keme tek, ma jo kabwidi iri kamwenen ja.’ ");
INSERT INTO lid_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Arile ado kasekesek le ka-en. Tasah, mada ado anyolom iri lakou, ma ndranye ado aleu ale ta anuhun sahou tek. ");
INSERT INTO lid_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Jo asehek sahou handru ewek tado. Bwena mene propet solo-an, ma iri lau solo-an an hamon ta Kindrei aso-ok handru ta atou iri lakou aha atou na dah. Arile, iri batou bwe. Iri aso-ok handru ta anuhun iri sahou aha anuhun jo asehek. Arile iri banuhun bwe.” ");
INSERT INTO lid_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jises asehek sahou ja i buku doh, “Ado kanuhun moson ta sahou sokek ta ndramak akeh buwa wit ili bolo bilin tan. ");
INSERT INTO lid_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Iri lau rayah anuhun sahou mwasin nyala tondrok ta Kindrei, arile iri tanan katin handru bwe. Iri buku none le buwa wit taku ereu san, ya balik eme kuhi iu suwi handru sahou mwasin Kindrei tahiy ereu budon tiri. ");
INSERT INTO lid_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ya iri buwa wit taku in bwele-e bek, i buku le iri lau anuhun sahou, ya nawin bwe iri kuhiy ma iri sekesek ta aliy. ");
INSERT INTO lid_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Arile buwa wit doh kandron aliy bwe, ya i bareu luwen bwe. Ya i buku none ndrine sen asahan deh bwe-em ndra-i asahan, tasah ta sahou ta Kindrei, ya idah kameh, suwi suwi iri taku. ");
INSERT INTO lid_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ya iri buwa wit taku ereu ndrokowa iri malou bobodon, idoh leheya iri lau ale anuhun sahou ta Kindrei, arile iri abudon boto-on ta lakou badu kon munyak. Ya iri abudon boto-on labai ta atukum iri luk, ma iri lakou ra-on ja. Ya idoh sokei sahou ta Kindrei eme ma bwidi iri bato-ou sali iri bwe. ");
INSERT INTO lid_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Arile, iri buwa wit ale taku in munyak mwasin badeh, i buku le iri lau anuhun sahou ta Kindrei, ya iri tanan katin handru. Eme ya iri ato-ou sali iri, ra-on ato-ou rinek (100), ra-on ndro hanoh (60), ra-on tonoh (30).” ");
INSERT INTO lid_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jises asehek sahou sokek ari ja i toro. Iy asehek i buku doh, “Tondrok ta Kindrei i buku none le ndramak ari atah buwa wit mwasin le udu bilin tan. ");
INSERT INTO lid_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Arile iri lau amadin, ndramak ta bahun i ta ndramak nane eme, ya iy tahi iri buwa bwidiu ndra-in ereu ndrokowa wit, ano iy ndra-au. ");
INSERT INTO lid_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hamon wit nane asahan hawe bwidiu ndra-in kone uru i le se. Eme ya wit anya kato-ou buwan, iri lau ta gok atou bwidiu ndra-in ereu ndrokowa wit. ");
INSERT INTO lid_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Eme ma, iri lau ta gok ala hawe tama bilin, ma asehek tan, ‘Ndramak tinan, aso anya ou mene tahi le badu wit in bolo bilin tam. Buku sah handru ya bwidiu ndra-in doh ateh ale?’ ");
INSERT INTO lid_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ya tama bilin nane asehek i toro, ‘Ari ndramak ta bahun ndrabwidi kandriyen doh.’ Eme ya iri lau ta gok ndremenyani iy, ‘Ou aso-ok aso kala kasudi bwidiu ndra-in nane?’ ");
INSERT INTO lid_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Arile iy anya, ‘Ndri-iy, kora-on ado asoh bwidiu ndra-in nane ado kasudi wit ale. ");
INSERT INTO lid_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mwasin, ado karuwani uru ma la-uh winiya le len ta akohok nyamon. Na len ta akohok nyamon jo katiye toro lau ta amekes gok doh: Ado katukumwi bwidiu ndra-in bwena, ya kasawei ki se ta asun i jih. Arile ado katukumwi iri wit keme bolo asiu ta nyamon tek.’” ");
INSERT INTO lid_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jises asehek sahou sokek ari ja i toro. Iy asehek i buku doh, “Tondrok ta Kindrei badeh, i buku buwa kei ari iri aloh mastet. Ndramak ari kuhi buwa mastet ya iy ili tahiy in bolo bilin tan. ");
INSERT INTO lid_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Buwa mastet badeh, nadu bwisik handru. Arile buku none iy ateh eme tinan, iy kameh sakalawi ja iri buwa kei badu bolo bilin nane. Iy asahan buku ra-ei kei tinan, ya iri sirih atah ame amekes awi iri udu bada andran.” ");
INSERT INTO lid_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jises asehek sahou sokek ari ja. Iy anya, “Ado kanuhun! Tondrok ta Kindrei kameh asahan buku none yis. Ari badih kuhi yis nane ma iy tubuni i hawe rahak ndrom tinan palawa. Iy tubuni ili ili winiya palawa mara-ei apus eme loken.” ");
INSERT INTO lid_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iri sahou nane Jises amekes i tiri lau, iy amekes i sahou sokek le. Iy basehek ari sahou bame lewan bala tiri bwe. Iy asehek sahou sokek le. ");
INSERT INTO lid_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na kandriyen doh, Jises mesekei eme handru sahou randra propet ndratiye in bolo buk ndrabun. Iy tiye i buku doh, “Jo kameh asehek sahou sokek ewek taha, ma jo kameh asehek kundruh ta iri lakou solo-an bwena mene aton, kala munyak asahan, eme isos na len dah.” ");
INSERT INTO lid_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jises ruwani iri lau mari nane, ma iy i bolo asiu ra-em. Kala iy ili bolon, oro lau tan ame, ma asehek anya, “Aso aso-ok ou asehek keme taso moson ta sahou sokek ta bwidiu ndra-in ateh in bolo bilin.” ");
INSERT INTO lid_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Eme Jises anya, “Abo, ndramak nane ta atah wit in bolo bilin badeh, jo dah, jo Nadu Ndramak Awas. ");
INSERT INTO lid_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ya bilin badeh, kon munyak dah. Buwa wit badeh, iri lau mwasin badu hawe Kindrei. Ya bwidiu ndra-in doh badeh, iri lau ndra-in badu hawe balik amwenen. ");
INSERT INTO lid_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iy lau ta bahun i ta Kindrei eme tahi buwa bwidiu na ben, idoh, balik. Ya len ta akohok nyamon kameh, leheya buku none munyak dah anya kano ai. Iri lau ta gok badeh, iri angelo ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Iri lau atukum iri bwidiu ndra-in nane ma asun i jih, i buku none le iri angelo kameh amekes kandriyen buku le aliy, buku none Kindrei anya kasun kon munyak dah. ");
INSERT INTO lid_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jo Nadu Ndramak Awas, jo kameh atehei oro angelo tek ame akeh iu iri lakou mari ereu mada Kindrei ale amekes budon ta lau andra-i, ma hawe iri lau ta amekes kandriyen ndra-in. ");
INSERT INTO lid_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma oro kameh akahei iri ala bolo jih ale winiyan bamak bwe-en. In bolo jih doh kameh oro aden andra-i labai, ma oro asenyer lihi oro kameh ili ta isi tinan labai kameh oro akohok. ");
INSERT INTO lid_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Arile, na len doh kameh, oro lau nane a-en hamon ta kandriyen ta tama oro Kindrei kameh ala bolo tondrok tan, ma lomada oro kameh anya buku an anya. Are lau iri anuhun sahou dah, iri kabudon kamwenen.” ");
INSERT INTO lid_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jises asehek sahou ja anya, “Tondrok ta Kindrei kameh asahan buku none le ko-on iri lau ra-on tone ereu bolo bilin. Ndramak ari eme a-eh ndren ma iy atou, ma iy tone ja. Iy sekesek labai, ya ili mada ba-en, ma iy atehei iri lakou tan mari i ba-en, ma iri lau sihinei iu. Ya iy ili sihinei bilin nane ko-on ereu bolon, tasah idah ko-on nane ndrala tan ma iy winiyan akohok.” ");
INSERT INTO lid_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jises asehek sahou ja, “Sahou sokek ari ja i buku doh: Tondrok ta Kindrei i buku none ndramak ari ta amekes ba-en, anya katakaleh sa-un mwasin. ");
INSERT INTO lid_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ya buku iy atou ari sa-un mwasin handru, eme ya iy ili atehei iri lakou tan mari i ta ba-en, ma iy ili sihinei sa-un mwasin nane. Tasah, iy aso-ok sa-un nane handru sakalawiy iri lakou tan mari.” ");
INSERT INTO lid_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jises asehek kundruh ili ja: “Sahou sokek ari ja i buku doh. Tondrok ta Kindrei i buku none le ari kubwin iri lau akahei ili bolo gwa li. Ya kubwin nane akohok iri ni buku liliy. ");
INSERT INTO lid_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ano kubwin irek, iri lau aluwi eme babi. Ya oro manyah ma atukum iri ni mwasin i bolo bwak. Arile iri ni ndra-in oro akeh iu. ");
INSERT INTO lid_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hamon, buku Kindrei anya kon munyak dah ano, idah kameh asahan tiri mwan ma badih ale. Oro angelo kameh ame akohok iri lau ndra-in ereu ndrokowa iri lau mwasin ale areu hamon ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ya oro kameh akahei iri lau ndra-in nane ala bolo jih ale winiyan bamak bwe-en. In bolo jih doh kameh oro aden ma asenyer lihi oro ta isi tinan labai oro atona.” ");
INSERT INTO lid_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ya Jises ndremenya oro i buku doh, “Sebwe ado tana ado kati sahou dah deh bwe?” Ya oro asumon i buku doh, “Ehe, aso tanan.” ");
INSERT INTO lid_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Eme ya Jises asehek i toro i buku doh, “Abo, jo asehek tado, are lau iy tanan ta batanau malen ta Moses, ma iy ndra-en baha tondrok ta Kindrei, iy kameh asahan buku none tama asiu ra-em tinan. Ma iy winiyan ili bolo asiu ya akohok iri lakou mwasin sowan tinan, ma tiyani iri lakou ha-un, ma hawe iri lakou malen eme lewan.” ");
INSERT INTO lid_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jises asehek iri sahou sokek nane ano, iy iu i len ta kon nane, ");
INSERT INTO lid_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ya iy ili kati kon tan amwenen. Ya iy ili bolo asiu ta atukum tiri ma iy leheya sahou ta Kindrei i tiri. Iri anuhun sahou tan, ma mani iri atur, ma iri ndremenya, “Iy ndramak dah akohok tanan ereu heh? Ya are lau edeu boto-on i tan, ma iy amekes iri lahou tinan solo-an? ");
INSERT INTO lid_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Taha tana taha, iy ndramak dah nadu ndramak ari ta atah asiu. Ya tinen Mariya, ma Jemis hawe Josep ma Saimon hawe Judas oro, nadu tinen. ");
INSERT INTO lid_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ya oro nadu tinen badih mari areu hawe taha kede-eh. Eme ya buku sah handru, ya iy amekes iri lakou doh?” ");
INSERT INTO lid_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Oro asehek i buku doh, ma oro atehei kona oro i tan. Arile, Jises asehek i toro, “Iri propet ta atiye boho Kindrei nyara iri tinan ereu kon mari. Arile ereu kati kon tan amwenen, ma ereu boho kamen tan amwenen iy asahan buku lau laleyah.” ");
INSERT INTO lid_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Eme iy bamekes iri lahou tinan solo-an bareu kon dah bwe, tasah iri batehei budon tiri ba-en tan handru bwe. ");
INSERT INTO lid_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kala doh iri lau mwan ma badih badu kon Nasaret atehei kona iri i ta Jises, Herot Antipas ndramak ta in bwena ta kon tinan Galili, iy anuhun kundruh ta iri lakou Jises amekes. ");
INSERT INTO lid_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Eme ya iy asehek ta iri lau ta gok tan, “Ndramak doh iy Jon ta alomwa le ai. Iy ndramak ja ereu bolo lek ndrame loken. Eme ya iy ndrakohok boto-on ta amekes iri lahou tinan doh.” ");
INSERT INTO lid_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ehe, Herot abudon buku doh. Tasah, bwena ndra-au o-on iy tiye iri tawi Jon ta alomwa, ma sawei iy ma atehei iy i bolo asiu lulik. Herot amekes doh, tasah iy sudi udu nadu tinen Pilip nyaran Herodiyas. ");
INSERT INTO lid_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Eme ma Jon asehek ta Herot i buku doh, “Ou ndrandra-i tasah, ou sudi udu nadu tinem!” ");
INSERT INTO lid_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodiyas aso-ok ta Herot kidi Jon. Arile, Herot bwalen ma iy inoh. Tasah, lau solo-an badu Isra-el atehei budon boto-on anya Jon badeh, propet. ");
INSERT INTO lid_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na len ari, iri kabin ra-on ame aimon nyamon hawe Herot. Na len oro ame atukum doh ta abudon len tine Herot tuwi iy. Ya na len doh, nadu Herodiyas badih eme idi mana ta amekes ndrine oro kabin nane kasekesek. Herot sekesek labai ta mana tan nane. ");
INSERT INTO lid_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Eme ya iy edeu wurah i tan ma iy amekes sahou randra hawen i buku doh, “Jo tandrakan handru, saba lakou ou ndremenya jo ta aliy, jo winiyan atehei ewek tam.” ");
INSERT INTO lid_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Eme ya iy ili ndremenya tinen ta iy kamekes ki buku sah handru. Tinen atehei budon i tan. Eme ya iy ili asehek ta Herot ma oro kabin nane, “Jo aso-ok ou adai Jon ta alomwa ma ou atehei batun ki bolo bwekei, ya ou atehei keme tek.” ");
INSERT INTO lid_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herot anuhun sahou doh ya ndrinen andra-i labai. Arile iy abudon ta iy nane ndratandrakan ereu mada oro kabin aimon nyamon hawen nane, ya iy bwalen akohok bwilima ta tobolowe sahou tan nane iy ndrasihidiy. Eme ya iy tiye toro lau tan ta bahun ta kala kabwidi buku le sahou ta badih nane ndrasehek. ");
INSERT INTO lid_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eme lau ta bahun tan ala ma iy sani bale Jon ereu bolo asiu lulik. ");
INSERT INTO lid_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Eme ya iri kuhi batun ereu bolo bwekei raben eme, ma iri atehei i mine nadu badih nane, ma iy bwese-ei ili hawe tinen. ");
INSERT INTO lid_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ya oro lau ta Jon, badu hamon tan, ame bwese-ei bada kei le, ya oro ala ahi iy i lek ano oro ala tiye ta Jises. ");
INSERT INTO lid_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jises anuhun buku iri ndradai Jon ndramak, eme ma iy ruwani kon nane ma iy suni ndron ra-ei ili kon ari doh lau aliy bwe. Iy ma oro lau tan badu hamon tan le ala. Arile iri lau solo-an anuhun saba kon Jises ndrala aliy, ma iri ruwani kon tinan tiri ma iri adek ala takaleh iy. ");
INSERT INTO lid_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Eme Jises anya ki amik, iy atou iri lau solo-an labai, ma iy tikisi iri, ma iy amekes iri lau bada iri ndra-in amwenen. ");
INSERT INTO lid_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kon abeyeh ya oro lau ta Jises ame tiye tan i buku doh, “Kon dah lau aliy bwe, ya mirihik an iu i andri ai. Ou tiye iri lau kede-eh ka-au kala bolo kon lau an aliy ma iri kasih niri nyamon.” ");
INSERT INTO lid_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Arile Jises tiye toro lau tan i buku doh, “Tasah handru ya iri ka-au? Ado kadeu niri nyamon.” ");
INSERT INTO lid_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eme oro tiye tan, “Naso nyamon solo-an bwe, arile kada-ah limeh jabi ramen hawe ni ma la-uh le.” ");
INSERT INTO lid_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Eme iy tiye toro, “Ado kandrei jabi ramen hawe ni nane keme minek.” ");
INSERT INTO lid_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eme ya Jises tiye tiri lau mwan ma badih ta kamanyah ka-en andri bada bwidiu. Eme iy kuhi jabi ramen ma limeh ma hawe ni ma la-uh nane, ya iy anyolom iu i loken bolo kandrah, ma iy edeu wurah i ta Kindrei. Ano iy boso-ei jabi ramen dah ma iy edeu ili mine oro lau tan, ma oro lau tan adeu i niri lau mwan ma badih. ");
INSERT INTO lid_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iri mari aimon ma ndrine iri idih. Ya iri tukumwi tikibwah nane i se asahan bwak ma ronoh la-uh. ");
INSERT INTO lid_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kane iri lau mwan mara-ei aimon nyamon badeh ma lamawa (5,000), idoh bondrek iri badih ma nah bwe. ");
INSERT INTO lid_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Eme Jises tiye toro lau tan kasandroh kala bolo ndron, ma oro ka bwena kala kapa gwa bilisiu. Ya iy le udu hamon ta atiye iri lau ka-au. ");
INSERT INTO lid_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iy tiye iri lau mari au ano iy le ari iu ili bwele-e mandrei, ta iy kasolom. Mada an amai iu i andri, iy le ari udu bwele-e mandrei nane. ");
INSERT INTO lid_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ndron ndra-au ndrala len labai, ma jor ale udu bwena eme ma bayau nyokoda ndron andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mirihik boho len, Jises edek bwele-e gwa ili hawe oro lau tan nane. ");
INSERT INTO lid_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Arile, oro atou iy edek bwele-e gwa, ma oro anoh andra-i labai, ma oro totoreh. Oro anya, “Nyam! Nyam!” Oro anoh ma oro arah andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Arile, suwi labai Jises aloh i toro i buku doh, “Ndrine ado kamunum! Jo, jo! Ado sanoh!” ");
INSERT INTO lid_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Eme Pita asumon bohon i buku doh, “Laban, buku none ou handru eh, mwasin ou tiye, ya jo kedek bwele-e gwa kewek hawem.” ");
INSERT INTO lid_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eme Jises tiye i tan, “Ou ame.” Eme ya Pita ruwani ndron, ma iy edek bwele-e gwa ili hawe Jises. ");
INSERT INTO lid_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Arile iy atou jor boto-on labai ya iy inoh, ma iy atuh sese ili bolo gwa, eme iy aloh i buku doh, “Laban, ou sebenei jo!” ");
INSERT INTO lid_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Suwi labai Jises atehei minen ma tawi Pita. Eme iy tiye tan i buku doh, “Ou budon tam boto-on handru bwe. Tasah handru budon la-uh asahan tam?” ");
INSERT INTO lid_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Eme uru ma la-uh sandroh ala bolo ndron, ma jor amondrei. ");
INSERT INTO lid_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Eme ma oro lau areu bolo ndron nane asolom i ta Jises ma oro anya, “Handru labai, ou Nadu Kindrei handru.” ");
INSERT INTO lid_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jises hawe oro lau tan ala bilisiu, ma oro asos loboho kon Genesaret. ");
INSERT INTO lid_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iri lau badu kon doh atou Jises, ma iri seleyani iy, ma iri atehei sahou ili kon mari badu mirihik, ma iri tiyani iri lau mari abo sik ame hawen. ");
INSERT INTO lid_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Eme iri ndremenya Jises boto-on labai ta iy kalelei iri lau nane sik udu tiri katehei le mine iri kili kiri awin tan. Eme iri lau mari nane ateu awin tan, iri asahan amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na len ari oro Parasi hawe oro lau ta leheya kandriyen tiri Juwis, ruwani Jerusalem ma oro ame atou Jises, ma oro ndremenyani iy i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Buku sah handru oro lau tam ba-en hamon ta sahou batanau mene iri tubu taha ndrasihidiy ndrame tataha bwena bwe? Buku none oro anya kaimon nyamon oro basikine mine oro bwe.” ");
INSERT INTO lid_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jises asumon oro i buku doh, “Buku sah handru ado an hamon ta budon ma kandriyen tado amwenen, ya ado ba-en hamon ta batanau ta Kindrei bwe? ");
INSERT INTO lid_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kindrei anya, ‘Ou a-en bahandra tamam uru tinem, ma ou anuhun sahou turu,’ ma, ‘Are lau aluhe taman uru tinen, iy kimek ta aliy.’ ");
INSERT INTO lid_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Arile, ado Parasi ma ado lau ta leheya kandriyen tiri Juwis tiye i buku doh, ‘I buku none ari ndramak tan luk ta aseben taman uru tinen, arile iy tiye turu, “Luk jo anya kaseben ah na aliy jo ndraleheyani ta edeu i ta Kindrei.”’ ");
INSERT INTO lid_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ya, ta san doh ado aseken ndramak doh sabudon taman ma samekes mwasin sala tan, ndri-iy. Ta kandriyen doh ado atehei i andri labai sahou ta Kindrei, ya ado bwese-ei eme loken iri kandriyen ado akohok ta tubu aha iri. ");
INSERT INTO lid_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ado lau ta wasai, amwenen handru i buku none propet Aisaya leheyani kandriyen tado handru kala iy tiye i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Iri lau mwan ma badih dah bwese nyarak eme loken na boho iri le, arile ndrine iri ereu len labai. ");
INSERT INTO lid_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iri asehek sahou batanau ta lau le, arile iri anya, “Idah sahou ta Kindrei.” Idoh ya iri asolom laleyah eme tek.’” ");
INSERT INTO lid_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Eme Jises aloh iri lau mwan ma badih a hawen ma iy tiye tiri i buku doh, “Ado kanuhun ma kabudon kamwenen. ");
INSERT INTO lid_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Saba lakou i bolo boho ari ndramak, idoh babwidi iy bandra-i bwe. Arile, lakou bohon asehek, idoh mesekei ndramak andra-i.” ");
INSERT INTO lid_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Hamon ta aliy oro lau ta Jises ame tiye tan i buku doh, “Sebwe ou ndratanam oro Parasi ndranuhun sahou tam ma ndrine oro ndrandra-i labai tam.” ");
INSERT INTO lid_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Eme Jises asumon i buku doh, “Tama udu kandrah tan bilin udu aliy. Ya iri lakou mari ale iy batah bwe-en, idoh kameh iy asoh ma kandron iu. ");
INSERT INTO lid_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ado sabudon oro lau doh, oro badeh buku lau mada iri bwe, arile oro anya kaleheya san ki ta ndramak ari ja. Arile, buku none ari ndramak madan bwe anya kaleheya san ki ta ndramak ari ja madan bwe, uru ma la-uh kameh taku a bolo lek.” ");
INSERT INTO lid_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Eme Pita tiye ta Jises buku doh, “Winiyan ou asehek keme lewan moson ta sahou sokek ou asehek i tiri lau mwan ma badih nane, ya aso kanuhun.” ");
INSERT INTO lid_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Eme Jises tiye toro, “Buku sah? Ado ale budon tado baleu bwe le? ");
INSERT INTO lid_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sebwe ado tana ado bwe; saba lakou i bolo boho ndramak, badeh iu ili bolo ndrine ndramak ano ndramak iu akeh ili sareu. ");
INSERT INTO lid_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Arile, saba lakou bohon asehek badeh, asahan ta budon ta ndramak, ya lakou doh mesekei ndramak andra-i. ");
INSERT INTO lid_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Iri lakou mari ale asahan ta budon ta ndramak badeh, lolowa ndramak amekes lomondra ndra-in. Lakou buku none, budon ndra-in, kandriyen ta adai ndramak imek, ya iri kandriyen mari ta karei, ma kandriyen ta amekes tasou andra-i, kandriyen ta bahana, kandriyen ta amekes sahou wasai ereu mada iri lau ta anuhun sahou, ma kandriyen ta amekes sahou ndra-in i bada ndramak ari ja. ");
INSERT INTO lid_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Iri kandriyen mari doh mesekei ndramak andra-i adeh. Arile buku none ndramak aimon nyamon bwena ya iy basikine minen bwe, kandriyen doh bamesekei iy bandra-i bwe.” ");
INSERT INTO lid_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Eme Jises ruwani kon doh ma iy iu ili loboho kon tinan Tair ma Saidon. ");
INSERT INTO lid_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Badih ari badu kon Kenan iy ereu mirihik ta kon tinan Tair hawe Saidon, iy eme ma iy aloh i buku doh, “Laban, ou nadu Debit, ou tikisi jo. Malawin ndra-in ndrabwidi naduk badih ndrandra-i labai.” ");
INSERT INTO lid_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Arile Jises basumon iy bwe. Eme oro lau tan ame tiye tan i buku doh, “Iy badih doh arah, arah in hamon ta to eme. Ou suni iy ki-iu.” ");
INSERT INTO lid_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Eme Jises asumon oro i buku doh, “Kindrei suni jo eme ta aseben le iri sipsip badu Isra-el ale ndranyon.” ");
INSERT INTO lid_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Arile iy badih nane eme mirihik ta Jises ma iy atehei bwili ndru-un i andri, ma iy anya, “Laban, jo aso-ok ou sebenei jo handru.” ");
INSERT INTO lid_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Eme Jises asumon iy i buku doh, “Bamwenen ta ari lakou bwe, i buku none iri andrei nyamon tiri nah ma iri akahei i na nadu mwi.” ");
INSERT INTO lid_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Arile badih nane anya, “Laban, ou asehek sahou handru. Arile iri nadu mwi aimon kahu nyamon taku in bahandra sau ta nyamon ta tama iri ale.” ");
INSERT INTO lid_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jises anuhun sahou doh ma iy asumon i buku doh, “Badih, budon tam boto-on labai. Saba lakou ou aso-ok kameh asahan tam, iy winiyan asahan.” Kala le don nadun badih asahan amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Eme Jises ruwani kon doh ma iy edek iu ili kapa gwa li Galili. Iy ili bwele-e ka-u mandrei ma iy manyah. ");
INSERT INTO lid_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Iri lau solo-an ame hawen. Iri atiye iri lau kati iri ndra-in ma iri lau mada iri ndra-in ma ndruwi iri hewon, ma boho iri bwe, ma iri lau solo-an bada iri ndra-in. Iri atehei iri an mirihik ta kati Jises. Ma iy mesekei iri asahan amwenen. ");
INSERT INTO lid_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Eme iri lau mwan ma badih atou iri lau boho iri bwe asehek sahou, ma iri ndruwi iri hewon asahan amwenen, ma iri lau kati iri ndra-in adek ja, ma iri lau mada iri bwe atou kon, ma iri abudon solo-an. Eme iri atudun nyara Kindrei badu Isra-el i loken. ");
INSERT INTO lid_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jises luhi oro lau tan ma iy tiye toro i buku doh, “Jo tikisi iri lau dah. Iri an hawek ndra winiya len taloh ai, ma niri nyamon ta aimon bwe. Jo bwalek iri amak son ya jo kasuni iri ka-au. Kora-on mada iri kabuluw ya iri kataku kareu san.” ");
INSERT INTO lid_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eme oro lau tan tiye anya, “Kon dah lau aliy bwe. Idah kameh to kakohok jabi ramen solo-an badu heh, ya to kanyohonei iri lau solo-an an kon lomale an dah?” ");
INSERT INTO lid_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Eme Jises ndremenyani oro, “Nado jabi ramen sabe udu aliy?” Eme oro anya, “Ndro taloh le, ma hawe iri nadu ni rayah bwisik.” ");
INSERT INTO lid_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Eme ya Jises tiye tiri lau mwan ma badih kamanyah kado andri bada munyak. ");
INSERT INTO lid_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Eme iy andrei jabi ramen ma ndro taloh nane, ma nadu ni, ma iy edeu wurah i ta Kindrei. Ano iy boso-ei, ma atehei ili mine oro lau tan, ma oro lau tan adeu ili niri lau. ");
INSERT INTO lid_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Lau mari aimon ma ndrine iri idih. Ano iri tukumwi tikibwah asahan bwak ma ndro taloh. ");
INSERT INTO lid_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iri lau aimon nyamon doh, kane iri badeh, ma hawa (4,000), idoh bondrek iri badih ma nah bwe. ");
INSERT INTO lid_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Eme Jises tiye iri mwan ma badih au. Ano iy sandroh i bolo ndron, ya oro ala loboho Magadan. ");
INSERT INTO lid_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Iri Parasi hawe Sadusi ame hawe Jises anya kanone iy. Oro tiye tan ta amekes ari lahou tinan ta leheya buku none iy amekes gok ta Kindrei handru. ");
INSERT INTO lid_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Arile iy asumon oro i buku doh, “Na beyeh ado anya, ‘Mada kon ndra saram. Sebwe idah kameh jor bwe ma kon mondrei nadeh.’ ");
INSERT INTO lid_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na mandraben ado anya, ‘Asi kandrah ndra bokodon ma mada kon ndra saram. Sebwe na idah kameh jor atohou ma ur undruk nadeh.’ Ehe, ado atou kalem ere bolo kandrah, ma tiye amwenen. Arile ado batou ma baleheya bamwenen iri kalem ta len dah bwe. ");
INSERT INTO lid_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Iri lau mwan ma badih ta len dah badeh, lau ndra-in handru, ma iri batehei ndrine iri handru bala ta Kindrei bwe. Iri ndremenya ta anya katou kalem, arile winiyan bwai. Kalem ari le kameh iri atou, kalem ta Jona.” Eme ma Jises ruwani iri ma iy iu. ");
INSERT INTO lid_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jises hawe oro lau tan ala kapa gwa li bilisiu, arile oro lau tan maniy, ma oro bakohok jabi ramen bwe. ");
INSERT INTO lid_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Eme Jises tiye toro i buku doh, “Ado kanyolom kamwenen. Mada ado kaleu ta yis tiri Parasi hawe Sadusi.” ");
INSERT INTO lid_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Eme oro lau tan asehek sahou ndrokowa oro amwenen, “Sebwe iy amekes sahou doh tasah to bakohok jabi ramen bwe nadeh?” ");
INSERT INTO lid_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Arile, Jises tanan ta sahou nane oro asehek, eme iy tiye i buku doh, “Ado lau budon tado tinan handru bwe. Buku sah handru ado asehek, anya ado jabi ramen bwe? ");
INSERT INTO lid_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Sebwe mada ado baleu bwe le nadeh? Ado ndramaniy ja, ta limeh jabi ramen mene iri lau ma lamawa (5,000) aimon? Ma bwak sabe mene erah ado anyuhiy? ");
INSERT INTO lid_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ado ndramaniy ja ta jabi ramen ma ndro taloh iri lau ma hawa (4,000) mene aimon, ma bwak sabe ado anyuhiy? ");
INSERT INTO lid_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Buku sah handru budon tado kede-eh baleu bwe le? Jo babudon ta jabi ramen bwe. Mada ado kaleu ta yis tiri Parasi hawe Sadusi.” ");
INSERT INTO lid_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Oro anuhun sahou doh, ma oro atana oro buku iy basehek ta mada oro kaleu ta yis ta amekes jabi ramen, bwe. Arile, iy anya mada oro kaleu ta sahou toro Parasi hawe Sadusi oro leheya iri lau na aliy. ");
INSERT INTO lid_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jises iu ili loboho kon tinan Sesariya Pilipai. Kala doh iy ndremenya oro lau tan i buku doh, “Iri lau anya Nadu Ndramak Awas, iy are lau handru?” ");
INSERT INTO lid_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eme oro anya, “Lau ra-on anya ou Jon ta alomwa. Ya ra-on anya ou Alaija, ya ra-on anya ou Jeremaya, deh ou ari propet.” ");
INSERT INTO lid_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Eme Jises ndremenya oro, “Ya ado amwenen anya jo are lau?” ");
INSERT INTO lid_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pita asumon iy i buku doh, “Ou Krais, Kindrei suni ou ame dah. Ou Nadu Kindrei kohan handru udu aliy.” ");
INSERT INTO lid_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Eme Jises asumon sahou tan i buku doh, “Saimon, ou nadu Jon, ou winiyan sekesek. Tasah, ari ndramak badu kon munyak baleheya ou ta sahou dah bwe. Idoh tama le udu kandrah, iy leheyani sahou dah ewek tam. ");
INSERT INTO lid_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ya jo tiye tam i buku doh: Ou Pita, ya jo kameh amekes iri mwan ma badih tek asahan i buku asiu salom tek, ya ou kameh aseben iri i buku ndru bek aseben asiu ales boto-on udu bwele-e munyak dah, ya Satan hawe boto-on ta imek kameh winiyan batohowei asiu salom tek doh bala andri bwe. ");
INSERT INTO lid_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ya jo kameh amekes nyaram ki buku nyarak. Iri lakou ou asehek iri mwan ma badih kamekes udu munyak dah, mwasin, Kindrei udu kandrah mukuni ale. Ya saba lakou ou turukiy udu kon munyak, idoh kameh Kindrei ale turukiy udu kandrah.” ");
INSERT INTO lid_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Eme Jises batanau oro lau tan boto-on labai i buku doh, “Ado sasehek nyala lakou dah sala ta ari ndramak, anya jo badeh, Krais, ndri-iy.” ");
INSERT INTO lid_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kala doh Jises leheya oro lau tan anya iy ki-iu kili Jerusalem. Ya iy kameh akohok sisi-in solo-an labai ereu mine iri lau tinan areu bwena, ma hawe iri lau tinan tiri pris, hawe iri lau tanan ta sahou batanau. Ya iri kameh adai iy imek, ya len taloh ano iy kameh amak ja. ");
INSERT INTO lid_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita anuhun sahou doh, ya iy seheyani Jises i kabwak, ma iy ibolosen i tan i buku doh, “Laban, sebwe lakou doh kameh winiyan basahan tam bwe nadeh.” ");
INSERT INTO lid_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Arile Jises tubuni iy ma iy asehek ta Pita i buku doh, “Satan, ou a len a konak! Ou anya aturuk san tek. Ou ba-en hamon ta budon ta Kindrei bwe. Ou a-en hamon le ta budon tiri lau.” ");
INSERT INTO lid_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Eme Jises tiye toro lau tan i buku doh, “Buku none ari ndramak anya ki-in hamon tek, mwasin, iy kamani iri so-ok tan mari, ya iy kabwese-ei kei tondreh tan, ya iy ki-in hamon tek. ");
INSERT INTO lid_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tasah, buku none ari ndramak anya katawi kohan kudu, kohan kameh ano. Arile, buku none ari ndramak abudon jo ya kohan ano, iy kameh winiyan andrei kohan ja. ");
INSERT INTO lid_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ya, buku none ari ndramak kuhi lakou mari badu kon munyak, ya iy kimek, iri lakou doh kameh sebenei iy i buku sah handru? Ya lau kadeu saba sowan handru kameh ta akohok kohan keme hamon? ");
INSERT INTO lid_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nadu Ndramak Awas kameh eme ma lomadan ta taman. Ya iy kameh eme hawe oro angelo tan. Na len doh kameh iy edeu ndramas i tiri lau mwan ma badih i le winiya le kandriyen iri amekes. ");
INSERT INTO lid_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Jo asehek sahou handru ewek tado. Lau ra-on ales areu bolo to dah kameh bamak bwe, ya iri kameh atou Nadu Ndramak Awas eme hamon ma atondrok kon munyak i buku kabin.” ");
INSERT INTO lid_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Len onoh ano, Jises kuhi Pita uru Jemis hawe nadu tinen Jon. Iy kuhi oro ala bwele-e mandrei ari loken labai, ya oro le ado aliy. ");
INSERT INTO lid_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Oro ado, oro anyolom ili bada Jises ndratubuniy ndra randrah ja. Ya bwilin anya buku none an. Ya awin tan asahan belen, handru en! ");
INSERT INTO lid_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Eme Moses uru Alaija asahan, ma oro lau ta Jises nane atou uru asehek sahou hawen. ");
INSERT INTO lid_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pita atou lakou doh ya iy asehek ta Jises i buku doh, “Laban, mwasin handru ta aso are ndra kada-ah. Buku none ou aso-ok jo katahi mandron ki taloh kudu dah; ra-em tam, ra-em ta Moses, ma ra-em ta Alaija.” ");
INSERT INTO lid_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pita asehek sahou kahis le, asi kandrah ari anya labai ili tubuluhi oro. Ya sahou randra asahan bolo asi kandrah nane asehek i buku doh, “Idah naduk handru. Jo aso-ok iy labai, ma jo sekesek tan handru. Ado kanuhun sahou tan.” ");
INSERT INTO lid_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Oro lau ta Jises nane anuhun sahou doh, ya oro atehei bwili ndru-u oro i andri, ma bwili oro i bada munyak, ma oro anoh labai. ");
INSERT INTO lid_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Arile, Jises eme mirihik toro, ma iy tawi oro ma iy anya, “Ado kareu loken, ado sanoh, ndri-iy.” ");
INSERT INTO lid_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eme oro suri mada oro eme loken, oro batou ari ndramak ja bwe, oro atou Jises le ari. ");
INSERT INTO lid_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eme oro are bwele-e mandrei ame andri, Jises batanau oro boto-on buku doh, “Saba lakou ado ndratou, ado sasehek ta ari ndramak ili winiya le Nadu Ndramak Awas amak ereu bolo lek eme loken ja.” ");
INSERT INTO lid_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Eme oro lau tan ndremenyani iy i buku doh, “Buku sah iri lau ta leheya kandriyen tiri Juwis anya Alaija kameh eme bwena op?” ");
INSERT INTO lid_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Iy asumon oro i buku doh, “Sahou badeh handru. Alaija kameh eme, iy kameh lowosa iri lakou mari. ");
INSERT INTO lid_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Arile jo asehek tado i buku doh, Alaija ndrame, arile iri lau tana iri iy bwe. Iri an hamon ta budon tiri amwenen, ya iri amekes iri kandriyen mari i badan. Ya iri kandriyen doh kameh iri amekes i bada Nadu Ndramak Awas ale.” ");
INSERT INTO lid_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jises asehek i buku doh, ya oro lau tan atana oro buku iy asehek ta Jon ta alomwa. ");
INSERT INTO lid_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jises hawe oro lau tan ma taloh ame ndruni iri lau solo-an. Eme ndramak ari asahan ta Jises, ma iy atehei bwili ndru-un i andri, ");
INSERT INTO lid_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ma iy anya, “Laban, ou tikisi naduk mwan. Iy asahan lolo-ou, ya badan udu ndra-in labai. Len ra-on iy kataku i bolo jih, len ra-on kameh iy taku i bolo gwa. ");
INSERT INTO lid_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Jo tiyani iy ili hawe oro lau tam, arile oro winiyan babwidi iy bamwenen bwe.” ");
INSERT INTO lid_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Eme Jises asehek sahou i buku doh, “Ado lau mwan ma badih batehei budon handru bwe, budon ma kandriyen tado bamwenen bwe. Len sabe kameh jo kereu hawe ado, ano ado barala tanan boto-on ta Kindrei? Ado katiyani nah badeh, keme hawek.” ");
INSERT INTO lid_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Eme Jises ibolosen i ta malawi balik nane, ma balik ruwani nah nane, ma nawin bwe, lolo-ou tan ano. ");
INSERT INTO lid_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Hamon ta aliy oro lau tan ame hawen, ma oro ndremenya iy i buku doh, “Buku sah handru ya aso winiyan batikahei malawin ndra-in nane iu bwe?” ");
INSERT INTO lid_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Eme iy tiye toro i buku doh, “Budon tado boto-on handru bwe, mesekei ado winiyan bwe. Jo asehek tado handru, buku budon tado kasahan ki buku badu buwa kei mastet, idoh ado winiyan tiye ta mandrei idoh, ‘Ou suri ou, ya ou ala kodo-oh;’ iy winiyan ili. Ya idah kameh ari lakou ja batawi ado ta amekes lahou bwe.” ");
INSERT INTO lid_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jises hawe oro lau tan atukum areu loboho kon Galili. Eme Jises asehek i toro i buku doh, “Iri kameh atehei Nadu Ndramak Awas ili mine iri lau. ");
INSERT INTO lid_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ya iri lau kameh adai iy imek, ya hamon ta len taloh kameh iy amak ja.” Oro lau tan anuhun sahou doh, oro tikisiy labai. ");
INSERT INTO lid_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hamon ta aliy Jises hawe oro lau tan ala asahan kon tinan Kapen-um. Ya iri lau ta akohok takis ta asiu tinan ta Kindrei asahan ta Pita, ya oro ndremenya iy i buku doh, “Sebwe ndramak ta leheya ado edeu luk ale i ta asiu tinan ta Kindrei nadeh?” ");
INSERT INTO lid_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Eme Pita asumon anya, “Ehe.” Eme Pita iu ili bolo asiu, Pita basehek sahou bwe le, Jises eme ndremenyani iy, “Saimon ou abudon buku sah? Iri kabin badu kon munyak akohok luk ta takis ere mine are lau eme? Oro akohok ere mine oro lau toro amwenen, deh, oro akohok ereu mine ndramak ari ja?” ");
INSERT INTO lid_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Eme Pita anya, “Oro akohok luk ta takis ta ndramak ari ja.” Eme Jises tiye tan, “Idoh ya oro lau toro amwenen kameh bakeh luk ta takis bwe. ");
INSERT INTO lid_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Arile, kora-on to kabwidiy, ma oro kabolosen keme ta to. Ou ala kapa gwa ou akeh jai. Ari ni ou aluwiy ma bwena, idoh ou sihi bohon, ya ou kameh atou luk ari ereu bohon. Ou andrei luk doh ou ala atehei ki mine oro. Idoh ta takis ta talu ma la-uh.” ");
INSERT INTO lid_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kala doh oro lau ta Jises ame hawen ma ndremenya iy, “Are lau nyaran tinan ereu baha tondrok ta Kindrei?” ");
INSERT INTO lid_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Eme Jises luhi nadu nah ari nadu bwisik eme ales ereu ndrokowa oro. ");
INSERT INTO lid_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ano iy tiye i buku doh, “Jo tiye sahou handru ewek tado, buku none ado batubuni ndrine ado bwe, ma basahan buku none nah nadu bwisik dah bwe, ado winiyan bala bolo tondrok ta Kindrei bwe. ");
INSERT INTO lid_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ndramak atehei budon tan asahan buku le nah, ndramak doh kameh nyaran asahan tinan ereu bolo tondrok ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ya buku none ari ndramak abudon jo ya iy aseben ari nadu nah bwisik buku nah dah, badeh iy aseben jo.” ");
INSERT INTO lid_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jises asehek ja anya, “Buku none ari ndramak bwidi ari nadu nah ale atehei budon tan eme tek taku ta kandriyen ndra-in, sebwe mwasin ta ndramak doh kasawei ari bek maha-an ki balen ma kakahei iy katuh kili bolo ndras lawe-en ya iy kimek. ");
INSERT INTO lid_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Sisi-in tinan labai kameh i bwele-e iri lau badu kon munyak, iri nane amekes ndramak ari ja taku ta kandriyen ndra-in. Handru, iri kandriyen ndra-in doh kameh asahan. Arile jo tikisiy handru ta ndramak mesekei asahan. ");
INSERT INTO lid_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Buku none minem deh katim aliu ou ta amekes kandriyen ndra-in, mwasin ou saniy ya ou akahei ki-iu! Sebwe mwasin ta ou minem raka le ma ou katim raka le ta akohok koham mwasin ta ereu le buku doh. Kora-on minem ma la-uh ma katim ma la-uh udu aliy, ya iri kakahei ou ala bolo jih ale winiyan bamak bwe-en! ");
INSERT INTO lid_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ya, buku none madam aluwi ou ta amekes kandriyen ndra-in, sebwe mwasin ta ou sudiy ma ou akahei ki-iu! Mwasin ta ou madam ari le ya ou akohok koham mwasin ta ereu le buku doh, kora-on madam ma la-uh kudu aliy, ya iri kakahei ou ala bolo jih ta anya ereu le buku doh. ");
INSERT INTO lid_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Ado kabudon kamwenen. Kora-on ado anya ari ereu ndrokowa oro nah kede-eh lakou laleyah. Bwe handru. Jo asehek tado amwenen, ereu kandrah oro angelo toro badeh, len mari oro areu mada tama ereu kandrah.” ");
INSERT INTO lid_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jises asehek sahou ja anya, “Ado abudon buku sah? Buku none ari ndramak tan rinek (100) sipsip udu aliy, ya buku none ari sipsip tan amai, sebwe iy winiyan bala batakaleh bwe nadeh? Neh? Bwe labai. Iy kameh ruwani oro sipsip tan ma ndro ronoh ndro ari (99) nane areu bwele-e mandrei are gwek, ma iy kameh iu ili takaleh ari nane amai. ");
INSERT INTO lid_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jo asehek sahou handru ewek tado, buku none iy takalahiy, iy kameh sekesek labai. Iy sekesek toro ndro ronoh ndro ari (99) sipsip nane bamai bwe, arile, buku none iy takalahei sipsip ari nane amai, sekesek tan kameh i tinan labai. ");
INSERT INTO lid_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Buku le tama ado udu kandrah, iy bwalen ari nadu nah kede-eh samai.” ");
INSERT INTO lid_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jises asehek sahou ja i buku doh, “Buku none nadu tinem bwidi kandriyen ndra-in ewek tam, mwasin ta ou ala atou iy, ya ah kasehek sahou ki se ta kandriyen nane. Buku none iy anuhun sahou tam, mwasin, ou ndrandrei nadu tinem ndrame hamon. ");
INSERT INTO lid_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Arile, buku none iy banuhun sahou tam bwe, mwasin, ou andrei ari deh la-uh ndramak ja kewek hawem, ya, ‘Buku lau la-uh o taloh asehek anya, oro anyolom ari ndramak amekes kandriyen ndra-in, mwasin ta aha kasehek sahou hawen.’ ");
INSERT INTO lid_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Arile, buku none iy banuhun sahou toro bwe, mwasin, ou tiye ki tiri lau mwan ma badih badu bolo iri lau ta Kindrei. Buku batun boto-on ma iy bwalen anuhun sahou toro ale, mwasin, ou atou iy buku none ari ndramak tanan Kindrei bwe, deh iy ndramak ta kolowa luk ta takis ta lau. ");
INSERT INTO lid_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Jo asehek sahou handru ewek tado, iri lakou ado asehek iri mwan ma badih kamekes udu munyak dah, mwasin, Kindrei udu kandrah sekesek ale. Ya saba lakou ado turukiy udu kon munyak, idoh kameh Kindrei ale turukiy udu kandrah. ");
INSERT INTO lid_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ya jo asehek ja ewek tado. Buku none ah la-uh lau badu kon munyak atehei budon ta ah i se ta ari lakou, ya ah asolom ta amekes, o, ta akohok lakou doh, mwasin tama udu kandrah winiyan atehei ewek ta-ah. ");
INSERT INTO lid_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ya, buku none lau la-uh deh lau taloh ame atukum ta nyarak, mwasin, jo amwenen kameh ereu ndrokowa oro.” ");
INSERT INTO lid_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kala doh Pita eme hawe Jises ma ndremenyani iy i buku doh, “Laban, san sabe buku nadu tine kamekes ndra-in keme tek, ya jo kamani kandriyen ndra-in tan doh? Sebwe san ndro taloh le nadeh?” ");
INSERT INTO lid_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ya Jises asumon iy i buku doh, “Jo basehek anya ou mani kandriyen ndra-in tan san ndro taloh le bwe. Jo anya ou mani kandriyen ndra-in tan san ndro taloh, ano san ndro taloh ja, ano san ndro taloh ja, ili ili winiya asahan san nyaran bwe. ");
INSERT INTO lid_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ado kanuhun, tondrok ta Kindrei i buku none ari kabin anya kakohok iri luk oro lau tan ta gok mene andrei buku dinau udu minen, ma oro batehei saluwen bwe le. ");
INSERT INTO lid_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iy anya kamekes lakou doh le, iri tiyani ndramak ari eme hawen, iy kameh kisih luk ki hamon ki ta kabin nane na luk solo-an labai (K10,000,000). ");
INSERT INTO lid_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Arile iy ndramak nane tan luk ta edeu saluwe luk nane bwe. Eme ma, kabin nane anya iy kameh atehei iy ndramak nane hawe udun ma nadun ala mada ba-en, ya ari ndramak kasihinei oro kala lau ta gok buku bonyo-ou tan. Ya oro kandrei iri lakou mari ta ndramak nane ki mada ba-en ale ya ta kandriyen doh oro winiyan andrei luk tan mari eme hamon. ");
INSERT INTO lid_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Eme ndramak ta gok nane anuhun sahou doh, iy atehei bwili ndru-un in mirihik ta kati kabin nane, ma iy tiye ta kabin nane i buku doh, ‘Ou tikisi jo, ma ou abe-en jo, idah kameh jo winiyan atehei ewek hamon iri luk mari mene jo akohok tam.’ ");
INSERT INTO lid_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Eme ndramak tinan ta lau ta gok nane tikisi iy, ma iy ruwani iy, ma tiye tan ta iy sadeu luk sala hamon sala tan, ndri-iy ai. ");
INSERT INTO lid_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Arile, ndramak ta gok nane iu ili manan, ya iy atou ndramak ari ta gok badu hawen, iy mene andrei luk tan winiya rinek (K10) le. Eme ma iy tawi ndramak badu hawen nane ta gok, iy tawi balen ma iy asehek sahou boto-on i tan i buku doh, ‘Ou adeu iri luk mari mene ou akohok tek, keme hamon.’ ");
INSERT INTO lid_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lau ta gok badu hawen nane anuhun sahou doh, ma iy atehei bwili ndru-un i andri, ya iy tiye ta ndramak nane i buku doh, ‘Ou tikisi jo, ya ou abe-en jo. Idah kameh jo winiyan atehei ewek hamon iri luk mari mene jo akohok tam.’ ");
INSERT INTO lid_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Arile, ndramak nane bwalen. Eme iy atehei lau badu hawen nane i bolo kou winiya le ndramak nane atehei i hamon iri luk mari iy andrei ta ndramak nane. ");
INSERT INTO lid_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Oro lau ta gok ra-on ja badu hawe uru lau nane atou kandriyen doh, ya ndrine oro andra-i labai. Eme oro ala tiye ta tinan toro. ");
INSERT INTO lid_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eme ya tinan nane luhi ndramak ta gok nane, ma tiye tan i buku doh, ‘Ou lau ta gok ndra-in. Nane ou aden eme tek, ya jo anya ou sasih same hamon iri luk mari mene ou akohok tek. ");
INSERT INTO lid_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jo tikisi ou handru. Arile, buku sah handru ya ou batikisi iy lau ta gok badu hawem nane bwe?’ ");
INSERT INTO lid_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ndramak tinan nane ndrinen irih ya iy atehei iy lau ta gok nane i bolo kou ma iy tiye iri lau ta ndrokei katehei maha-an ki tan winiya le iy kasihinei iri luk tan mari nane kili hamon. ");
INSERT INTO lid_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Idoh buku le tama udu kandrah, iy kameh amekes iri kandriyen doh ewek taha mari, buku aha bamani iri kandriyen ndra-in nadu tine aha ari ja amekes ewek taha bwe.” ");
INSERT INTO lid_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jises asehek sahou tan nane ano, iy ruwani kon Galili ma iy iu ili loboho kon Judiya ereu kapa gwa Jodan bilisiu. ");
INSERT INTO lid_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Eme iri lau solo-an an hamon tan, ya iy mesekei bada iri nane udu ndra-in amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Eme oro Parasi rayah ame atou Jises ma oro anya kanone iy. Oro ndremenyani iy i buku doh, “Sebwe sahou batanau tataha anya, lau winiyan tikahei udun na saba katin udu budon tan amwenen nadeh?” ");
INSERT INTO lid_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jises asumon boho oro i buku doh, “Sebwe ado batou tarou ta Kindrei ereu bolo buk ndrabun tan bwe nadeh? Bwena handru kala Kindrei mene ‘mesekei lakou mari, iy mesekei lau mwan ma badih.’ ");
INSERT INTO lid_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Eme Kindrei anya, ‘Ta katin le doh, iy mwan karuwani taman uru tinen ya iy keme len hawe udun, ya uru kasahan ari buruwen.’ ");
INSERT INTO lid_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kindrei asehek anya, bada uru la-uh bwe, bada uru ndrasahan ari le buruwen. Idoh le, saba lakou Kindrei ndrasawei mari ndrase, ari ndramak sasaniy ja ai.” ");
INSERT INTO lid_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ya oro Parasi tiye tan i buku doh, “Ya buku sah handru Moses atehei sahou batanau eme tataha ya iy asehek anya ndramak winiyan atorou la-ukei ta amendren tasou ya iy atehei i mine badih ano iy winiyan aruwe badih iu?” ");
INSERT INTO lid_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Eme Jises asumon i buku doh, “Batu ado boto-on labai, eme Moses aruwe ado ta atikah badih iu. Arile bwena handru kandriyen doh bwe. ");
INSERT INTO lid_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jo asehek ewek tado i buku doh. Buku none udu ari ndramak bamekes madasarah bwe, ya udun ruwani iy, ma iy i tasou i ta badih ari ja, iy le mesekei karei i tan.” ");
INSERT INTO lid_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Oro lau ta Jises anuhun sahou doh, ya oro asehek i buku doh, “Buku none ndramak anya ki-in hamon ta kandriyen buku doh ya iy in hawe udun, sebwe mwasin mwan satasou, ndri-iy.” ");
INSERT INTO lid_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jises asehek i toro i buku doh, “Iri lau mari winiyan bakohok sahou dah bwe. Kindrei atehei boto-on i ta lau ra-on le. ");
INSERT INTO lid_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ado kanuhun. Iri lau rayah areu kede-eh iri ale batasou bwe. Lau ra-on bada iri andra-i kala tine iri tuwi iri. Lau ra-on asan iri, ma iri winiyan bamekes nah bwe, ya ra-on abudon ta amekes gok ta Kindrei, ya iri abeles iri ya iri batasou bwe. Arile, are lau winiyan akohok sahou dah, iy kakohok.” ");
INSERT INTO lid_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kala doh iri lau atiye iri nah bwisik ame hawe Jises. Iri aso-ok anya Jises katehei minen ki la-u iri nah nane, ya iy kasolom. Arile oro lau ta Jises abolosen i tiri lau nane. ");
INSERT INTO lid_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Arile Jises tiye toro lau tan i buku doh, “Ado karuwani iri nah kame hawek. Ado saturuk iri, ndri-iy. Tondrok ta Kindrei badeh, tiri lau buku iri nah nadu bwisik kede-eh.” ");
INSERT INTO lid_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Eme iy atehei minen i la-u iri nah nane, ano iy ruwani kon nane ma iy iu. ");
INSERT INTO lid_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Eme ndramak ari eme atou Jises ma iy anya, “Ndramak ta leheya, jo kamekes saba kandriyen mwasin handru ya jo kakohok kohan mwasin ta ereu le buku doh len mari?” ");
INSERT INTO lid_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jises tiye i tan i buku doh, “Tasah handru ya ou ndremenya jo ta kandriyen mwasin? Ndramak ari le Kindrei, iy mwasin labai. Arile, buku none ou anya akohok kohan mwasin ta ereu le buku doh, ou a-en hamon ta sahou batanau ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Eme ndramak nane ndremenya Jises ja i buku doh, “Ou asehek ta saba sahou batanau handru?” Jises anya, “Iri sahou batanau ale anya, ‘Ou sadai ndramak samak, ou samekes karei ta badih tasou. Ou sabahana, ou sawasai, ma sadeu iri lau laleyah sala ta mada sahou, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ou a-en bahandra tamam uru tinem, ma ou anuhun sahou turu.’ Ya, ‘Ou aseken iri lau ari ari badu hawem, i le buku ou aso-ok ou le.’” ");
INSERT INTO lid_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Eme ndramak loweu nane asehek ta Jises i buku doh, “Jo badeh, in hamon ta sahou batanau mari, ya saba lakou ja jo kamekes?” ");
INSERT INTO lid_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Eme Jises asehek tan i buku doh, “Buku none ou anya asahan ndramak mwasin handru, mwasin, ou ala atehei iri lakou tam mari kili mada ba-en, ya luk ou akohok ta iri lakou tam nane ou adeu ki tiri lau tiri lakou bwe. Ou amekes i buku doh kameh ou tam lakou mwasin handru udu kandrah. Ano ou bara-en hamon tek.” ");
INSERT INTO lid_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ndramak loweu nane anuhun sahou doh, ya budon tan andra-i, ma iy iu ai, tasah tan lakou solo-an labai. ");
INSERT INTO lid_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Eme Jises tiye toro lau tan i buku doh, “Jo tiye handru ewek tado, idah kameh, boto-on labai ta ndramak tan lakou solo-an, i buku none iy anya kili bolo tondrok ta Kindrei! ");
INSERT INTO lid_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jo asehek tado ja, masakan boto-on boto-on labai ta ndramak tan lakou solo-an ta iy ili bolo tondrok ta Kindrei, arile manamun labai ja ta kamel i buku iy i bolo manamunu nunu.” ");
INSERT INTO lid_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Oro lau tan anuhun sahou doh mani oro atur labai, ma oro anya, “Buku none i buku baden eh, are lau handru kameh winiyan akohok kohan mwasin ta ereu le buku doh?” ");
INSERT INTO lid_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Eme Jises anyolom amwenen i toro, ma iy anya, “Lau winiyan bwe. Arile Kindrei winiyan mesekei lakou mari.” ");
INSERT INTO lid_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ya Pita asumon bohon anya, “Ou atou, aso ndraruwani lakou mari, ya aso ndra-en hamon tam. Ya idah kameh aso kakohok sasah handru?” ");
INSERT INTO lid_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jises asehek i toro i buku doh, “Jo asehek handru ewek tado, na len lakou mari asahan ha-un, ya Nadu Ndramak Awas kameh akohok nyaran i tinan, ma iy kameh manyah udu koyeu ta kabin, koyeu doh tan amwenen. Na len doh ado lau ale an hamon tek, ado ale kameh manyah ado koyeu ma ronoh la-uh mwasin, ma ado kameh anuhun sahou toro boho kamen ma ronoh la-uh badu Isra-el. ");
INSERT INTO lid_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ya are mwan ma badih ale abudon nyarak, ma iy ruwani asiu tan ma nadu tinen mwan ma buru-un, ma taman uru tinen, nadun ma bilin tan, iy kameh akohok ndramas buku san rinek (100) ja i la-un, ma akohok kohan mwasin ta ereu le buku doh. ");
INSERT INTO lid_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Arile lau solo-an na dah areu bwena, iri kameh ame hamon. Ya iri lau solo-an na dah areu hamon iri kameh ame bwena.” ");
INSERT INTO lid_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jises asehek sahou ja anya, “Jo asehek dah tiri lau ale anya ka-en bwena, tasah tondrok ta Kindrei i buku le ndramak ari tan munyak solo-an. Na mandraben handru iy iu ili takaleh iri lau ta ame abo gok ta bolo bilin waen tan. ");
INSERT INTO lid_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Oro lau ta gok nane ndraso-ok ta akohok luk ronoh (K1) ta len ari, eme ndramak nane suni oro ala abo gok bolo bilin waen tan. ");
INSERT INTO lid_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Mada an eme ndro ari ndramak nane ili ma iy atou oro lau ra-on areu laleyah areu mada ba-en. ");
INSERT INTO lid_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eme iy tiye toro i buku doh, ‘Ado ale kala kabo gok bolo bilin waen. Ya jo kameh isih ado winiya le gok ado bwidiy.’ ");
INSERT INTO lid_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eme oro ala. “Ya, na mada an udu alih ma mada an taloh beyeh, ndramak nane ili amekes buku aliy ale. ");
INSERT INTO lid_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Eme na mada an limeh na beyeh, iy ili ja iy atou oro lau ra-on ales laleyah, eme iy ndremenyani oro, ‘Buku sah handru ya len ari ma buruwen dah ado ales laleyah ya ado bamekes ari gok bwe?’ ");
INSERT INTO lid_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Oro asumon bohon buku doh, ‘Ari ndramak badeu gok bame taso bo-oh.’ “Ndramak nane anya, ‘Mwasin, ado ale kala kabo gok bolo bilin waen tek.’ ");
INSERT INTO lid_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kon abeyeh handru tama bilin waen nane tiye ta ndramak ta in bwena ta gok tan buku doh, ‘Ou luhi oro lau ta gok kame ya ou adeu sihine oro. Ou adeu sihine oro lau ame hamon ta gok bwena, kano ou adeu sowa oro lau mari kili kisos are lau eme bwena handru ta gok.’ ");
INSERT INTO lid_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Eme oro lau nane abo gok na mada an limeh ame akohok sihine oro; oro ari, ari akohok luk ronoh (K1). ");
INSERT INTO lid_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Eme oro lau nane oro abo gok ma bwena handru oro ame, oro abudon buku oro kameh akohok luk solo-an ja. Arile bwe. Oro akohok luk ronoh (K1), ndramak ari, ari. ");
INSERT INTO lid_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Oro atou luk oro akohok ma oro abolosen i ta tama bilin waen nane buku doh, ");
INSERT INTO lid_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Oro lau ame hamon oro babo gok luwen bwe, arile ou adeu sihine oro i buku le aso akohok. Arile aso abo gok boto-on handru na mandraben eme isos dah, ya an sulumwi aso andra-i labai.’ ");
INSERT INTO lid_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Tama bilin nane anuhun sahou doh ya iy tiye ta ndramak ari toro lau ta gok nane anya, ‘Kawas tek, jo bamekes ari ndra-in bawek tam bwe, sebwe na mandraben handru, talu asehek ta ou kameh akohok luk ronoh (K1), neh? ");
INSERT INTO lid_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ou akohok sihinem ma ou a-au ai. Na so-ok tek amwenen ya jo edeu sihine i ndramak nane in hamon eme i buku le ado nane ame bwena. ");
INSERT INTO lid_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Idoh lakou tek amwenen. Sebwe jo winiyan ba-en hamon ta budon tek amwenen ta ondrek luk tek bwe nadeh, neh? Buku none jo anya kamekes kandriyen mwasin ki toro lau doh, buku sah handru ya ou abudon andra-i.’” ");
INSERT INTO lid_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Eme Jises anya, “Idoh i buku le iri lau ale an hamon handru, oro kameh ame bwena. Ya oro lau ale an bwena, oro kameh ame hamon ja.” ");
INSERT INTO lid_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jises edek iu ili Jerusalem. Iy kuhi oro lau tan ma ronoh la-uh ala a ka-un, ya oro adek kahis le, Jises tiye toro i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ado kanuhun, na dah to ala loke ala Jerusalem, ma iri kameh atehei Nadu Ndramak Awas ili mine iri tinan tiri pris ma hawe iri lau ta leheya kandriyen tiri Juwis. Ya iri kameh atehei iy ili ta mada sahou, ma iri kameh atilik sahou i se ta kadai iy kimek. ");
INSERT INTO lid_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ya oro kameh atehei iy ili mine iri lau ra-on badu leheleh, ta oro lau doh kabobose iy, ma ka-um iy na malou sakabuk i bek, ma katehei iy ki bada kei tondreh. Ya hamon ta len taloh iy kameh amak ja.” ");
INSERT INTO lid_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hamon ta aliy tine uru nah ma la-uh nadu Sebedi hawe nadun uru ame atou Jises. Eme iy atehei bwili ndru-un i andri ma iy anya kandremenya Jises ta lakou ari. ");
INSERT INTO lid_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Eme Jises ndremenyani iy anya, “Ou aso-ok saba lakou?” Iy badih nane asehek ta Jises i buku doh, “Jo aso-ok ou asehek anya naduk uru ma la-uh dah kameh manyah areu mirihik hawem areu kon tam ta atondrok, ari ereu minem salin, ari ereu minem kamweu.” ");
INSERT INTO lid_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jises anuhun sahou doh ma iy asumon i buku doh, “Ado tana ado saba lakou ado ndremenya kede-eh bo-oh! Sebwe ah winiyan a-un na bwiniu jo kameh a-un na aliy dah nadeh?” Uru asumon, “Aru winiyan.” ");
INSERT INTO lid_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jises tiye turu buku doh, “Handru, bwiniu kameh jo a-un na aliy, ah kameh a-un na aliy ale. Arile, are kameh manyah ereu minek salin ma are kameh manyah ereu minek kamweu, idoh jo winiyan batiye bwai. Tasah, kon doh tiri lau ale tama Kindrei ndralowosani iri kabwe.” ");
INSERT INTO lid_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ya eme oro lau tan ma ronoh anuhun sahou turu, oro abolosen labai ili turu. ");
INSERT INTO lid_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Arile Jises luhi oro mari ame hawen, ma iy asehek i toro i buku doh, “Ado tana ado, iri kabin tiri lau badu leheleh badeh, iri boto-on labai ta atondrok iri lau tiri, ma iri batanau boto-on labai ta iri lau tiri kanuhun sahou tiri handru. ");
INSERT INTO lid_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Arile kandriyen doh sa-en ndrokowa ado, ndri-iy. Ndramak anya ki tinan kereu ndrokowa ado, iy kasahan lau ta gok kereu ndrokowa ado. ");
INSERT INTO lid_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ya are lau anya kereu bwena tado, iy kasahan ndramak ta gok laleyah kereu ndrokowa ado. ");
INSERT INTO lid_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Idoh le Nadu Ndramak Awas eme ta iri lau kabo gok i tan bwe. Iy eme ta aseben iri, ma ta edeu kohan ta akunoh lau mari.” ");
INSERT INTO lid_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jises hawe oro lau tan ruwani kon tinan Jeriko, ma oro au. Iri lau solo-an labai an hamon toro. ");
INSERT INTO lid_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Uru lau la-uh manyah areu kabede san. Uru mada uru bwe, uru anuhun le buku Jises edek eme. Eme ma, uru arah boto-on buku doh, “Laban, ou nadu tubu kabin Debit, ou tikisi aru!” ");
INSERT INTO lid_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Iri lau solo-an abolosen i turu ma iri tiye turu ta uru kandru-uk. Arile, bwai, uru aloh ma arah boto-on le gwek anya, “Laban, ou nadu tubu kabin Debit, ou tikisi aru!” ");
INSERT INTO lid_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eme Jises udu rasi ma aloh i turu, “Ah aso-ok jo kamekes sasah kewek ta ah?” ");
INSERT INTO lid_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Uru asumon sahou tan i hamon i buku doh, “Laban, aru aso-ok ou sihi mada aru kasak.” ");
INSERT INTO lid_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Eme Jises tikisi uru, ma iy atehei minen i mada uru, ma nawin bwe mada uru amwenen, ma uru anyolom kon ja. Ma uru an hamon ta Jises. ");
INSERT INTO lid_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jises hawe oro lau tan ame mirihik ta Jerusalem, oro asahan kon Betapes ereu mandrei Olip. Eme Jises suni uru lau tan ma la-uh, ");
INSERT INTO lid_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma iy tiye turu buku doh, “Ah kala kon to anyolom i aliy don. Suwi labai ah kameh atou donki ari iri sawei udu aliy, ma nadun ale udu hawen. Ah katolowei malou ma kasirini uru kame hawek. ");
INSERT INTO lid_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ya, buku none ari ndramak kandremenya ah, ah katiye ki buku doh, ‘Laban gok udu turu, ano iy baratiyani uru barame hamon ja.’” ");
INSERT INTO lid_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lakou dah asahan ta amekes sahou mene propet ndrasehek bwena asahan handru, ");
INSERT INTO lid_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kasehek sahou dah ki tiri lau mwan ma badih badu Sayon, ‘Ado kanyolom, kabin tado eme ai. Iy eme buku ari ndramak nyaran bwe, ya iy manyah udu bwele-e donki ari. Ehe, iy manyah udu bwele-e donki ari ndramak bamanyah ba-en bwele-en bwena bwe.’” ");
INSERT INTO lid_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Eme uru lau tan ma la-uh nane ala bwidiy buku le nane iy ndratiye turu. ");
INSERT INTO lid_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Uru ame sirini donki uru nadun nane, ya uru atehei kolau turu lawe-en badu bwele-e awin turu i la-u uru donki ma la-uh nane, ya Jises manyah udu bwele-en. ");
INSERT INTO lid_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ya iri lau solo-an ame talaha awin tiri lawe-en badu bwele-e iri i san. Ya iri ra-on ala amundroh andra kei, ya iri anyehe ili san. ");
INSERT INTO lid_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iri lau ra-on adek ala bwena ta Jises ma hawe iri ra-on adek an hamon tan, ya iri mari arah i buku doh, “Hosana! Kasekesek ki ta nadu Debit! Kasore nyaran! Iy eme ta nyara Laban!” “Hosana! Kasekesek ki loken mara-ei!” ");
INSERT INTO lid_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jises iu ili bolo kon Jerusalem, ya iri lau mari badu bolo kon tinan nane mani iri lau mari atur tan, ma iri ndremenya iri i buku doh, “Idoh are lau handru?” ");
INSERT INTO lid_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Eme iri lau mwan ma badih nane adek hawen anya, “Idah propet nyaran Jises, iy badu kon Nasaret, badu loboho Galili.” ");
INSERT INTO lid_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jises ili loboho bolo asiu tinan ta Kindrei ya iy atikah iri lau amekes ba-en udu asiu doh. Iy bukudi iri sau tiri lau ta tokoha luk, ma hawe bwabwai tiri lau asih iri sirih aloh ban. ");
INSERT INTO lid_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ya iy tiye tiri i buku doh, “Buk ndrabun tiye i buku doh, ‘Asiu tek dah, asiu ta amekes salom labai,’ arile ado ndramesekei asiu tek, ndrasahan ‘asumwe iri lau ta bahana.’” ");
INSERT INTO lid_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jises udu bolo asiu tinan ta Kindrei, ya iri lau mada iri bwe, ma hawe kati iri ndra-in ame hawen, ma iy mesekei iri amwenen. ");
INSERT INTO lid_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Arile iri pris tinan hawe iri lau tanan ta sahou batanau atou iri lahou tinan iy amekes, ma oro anuhun iri nah arah udu bolo kou ta asiu tinan buku doh, “Hosana! Sekesek i ta nadu Debit!” Idoh mesekei ndrine oro andra-i. ");
INSERT INTO lid_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma oro ndremenya Jises i buku doh, “Sebwe ou ndranuhun sahou oro amekes doh?” Eme Jises asumon boho oro i buku doh, “Ehe, jo ndranuhun. Arile, sebwe ado banyolom sahou doh bwe, ‘Iri nadu nah atudun nyaran ili loken.’” ");
INSERT INTO lid_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Eme iy ruwani oro ma iy iu i len ta kon nane ma iy ili udu Betani na ben doh. ");
INSERT INTO lid_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na mandraben handru Jises edek iu i hamon i kon tinan nane ja, ya iy imeson andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iy atou kei pik ra-ei ales udu kabede san, ya iy ili mirihik ta aliy. Arile iy batou ari buwan ba-en aliy bwe. La-un le udu aliy. Eme iy tiye ta kei nane buku doh, “Ou winiyan bato-ou salim ja bwai.” Na le liliy kei pik doh asara ai. ");
INSERT INTO lid_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Oro lau tan atou lakou doh, ya mani oro atur. Eme oro anya, “Buku sah ya kei doh asara suwi labai?” ");
INSERT INTO lid_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Eme Jises asumon boho oro i buku doh, “Jo asehek sahou handru ewek tado, buku none ado atehei budon handru in ta Kindrei ya ado babwerei bwe, ado winiyan mesekei kandriyen jo amekes i ta kei pik nane. Ya idoh le bwe, buku none ado tiye i ta mandrei dah, ‘Ou suri ou ya ou sandroh ala bolo ndras,’ lakou doh kameh asahan buku le ado nane ndratiye. ");
INSERT INTO lid_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ya buku none ado atehei budon boto-on ma asolom, iri lakou ado asolom ta akohok, ado winiyan kuhiy.” ");
INSERT INTO lid_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jises iu ili hamon ili asiu tinan ta Kindrei nane ja, ya iy leheya iri lau mwan ma badih ta bolo sahou mwasin. Eme ya iri lau tinan tiri pris ma hawe iri lau-en ame hawen, ya oro ndremenyani iy i buku doh, “Ou akohok boto-on badu heh handru, ma ou amekes iri lakou kede-eh? Are lau atehei nyaran tinan ewek tam ma tiye ou ta amekes iri lahou dah?” ");
INSERT INTO lid_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jises asumon boho oro i buku doh, “Jo ale jo anya kandremenya ado ta lakou ari. Ya, buku none ado tiye amwenen eme tek, sebwe jo kameh tiye ewek tado are lau handru atehei boto-on eme tek ta amekes gok dah. ");
INSERT INTO lid_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kala Jon mene alomwa iri lau, iy akohok boto-on badu heh? Lakou doh badu kandrah deh, badu kon munyak le?” Eme oro andres udu ndrokowa oro le i buku doh, “Buku none to katiye anya, ‘Idoh lakou badu kandrah,’ idah kameh iy ndremenyani to ja anya, ‘Buku sah handru ya ado batehei budon tado bala ta aliy bwe?’ ");
INSERT INTO lid_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Arile buku none to katiye anya, ‘Idoh kandriyen tiri lau le,’ idah kameh to anoh iri lau ale, tasah iri anya, Jon badeh, propet ta Kindrei handru.” ");
INSERT INTO lid_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eme oro asumon boho Jises i buku doh, “Aso tana aso bwe.” Eme Jises tiye toro i buku doh, “Jo ale jo winiyan batiye bawek tado are lau handru atehei nyaran tinan eme tek ya jo amekes iri gok dah.” ");
INSERT INTO lid_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jises asehek sahou i toro pris ma hawe oro lau tinan ja i buku doh, “Ehe, ya ado abudon buku sah? Ndramak ari nadun la-uh. Iy ili hawe nadun kadok iy tiye tan buku doh, ‘Naduk, ou ala abo gok bolo bilin waen.’ ");
INSERT INTO lid_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nadun tiye tan buku doh, ‘Jo bwalek.’ Arile hamon iy tubuni budon tan ja ya iu ili ibo gok. ");
INSERT INTO lid_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ya ndramak nane ili hawe nadun bwaneh ja, ya iy asehek i buku le aliy ili tan ja. Ya nadun tiye tan buku doh, ‘Abo tama.’ Arile iy bala bwe. ");
INSERT INTO lid_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ya uru nah ma la-uh doh are lau handru in hamon ta budon ta tama uru?” Eme oro lau nane anya, “Nadun kadok.” Eme Jises tiye toro i buku doh, “Jo asehek tado handru, iri lau ta akohok luk ta takis taha ma hawe iri badih ta madasarah kameh ala bwena ala bolo tondrok ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tasah, Jon asahan tado bwena ma iy leheya kandriyen mwasin ewek tado, arile ado batehei budon boto-on bala ta aliy bwe. Arile iri lau ta akohok luk taha ta takis, ma hawe iri badih ta madasarah atehei budon boto-on i tan, ma ado atou kandriyen doh, arile ado batubuni budon tado bwe. Ma ado batehei budon boto-on bala ta aliy bwe.” ");
INSERT INTO lid_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jises asehek i tiri lau tinan ja i buku doh, “Ado kanuhun sahou sokek ari ja i buku doh: Ndramak ari bwidi bilin ta waen ari, ma iy bwidi kou awudiy. Ma in bolo bilin nane iy ihi lek ari ta atik ma apis buwa waen, ano iy tahi asiu ra-em ta atondrok. Ano iy atehei bilin ili mine iri salibah ta atondrok. Ma iy iu ili kon rakon ja. ");
INSERT INTO lid_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ya mirihik ta buwa waen nane uni, iy suni iri lohowan tan ala hawe iri lau nane iy atehei bilin i tiri ta atondrok, ta iri kakohok ra-on buwa waen ki hamon ki tan. ");
INSERT INTO lid_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Arile oro salibah ta bilin tawi oro lohowan tan, ubwi ari, adai iy ari, ma orowei ari na bek. ");
INSERT INTO lid_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hamon ta aliy tama bilin suni oro lohowan tan ra-on ja ta gok ala, kane oro solo-an ja sakalawi oro nane ala bwena. Ya oro lau ta gok ta bilin nane tawi oro ya mesekei kandriyen ili toro i buku le bwena nane. ");
INSERT INTO lid_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Eme hamon ta aliy tama bilin suni nadun amwenen ili hawe oro. Tama bilin nane abudon buku doh, ‘Sebwe oro kameh anuhun boho naduk.’ ");
INSERT INTO lid_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Arile oro salibah ta bilin atou nadun edek eme, ya oro asehek sahou ndrokowa oro buku doh, ‘Ei, nadun eme, to kadai iy, ma to kakuhi iri lakou tan mari.’ ");
INSERT INTO lid_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Eme oro tawi iy, ma kuhi iy iu ili kona bilin, ma oro adai iy imek. ");
INSERT INTO lid_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ya ado abudon buku sah? Buku tama bilin keme, eme iy kameh amekes saba lakou handru kili toro salibah nane abo gok an bolo bilin nane?” ");
INSERT INTO lid_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eme oro asehek tan buku doh, “Iy kameh idi oro lau doh amak, ma iy kameh atehei bilin ili mine iri lau rayah ja kabo gok ta aliy, ya buku none buwa waen uni, iy kameh akohok ra-on ale.” ");
INSERT INTO lid_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Eme Jises ndremenya oro i buku doh, “Sebwe ado banyolom sahou doh ereu bolo buk ndrabun ta Kindrei bwe nadeh, sahou i buku doh, ‘Bek ale iri lau ta atah asiu bwale iri, na dah, iy ndrasahan kati ndru ta ka-u asiu bek. Idah san ta Laban amekes, ma mwasin labai ta mada taha.’ ");
INSERT INTO lid_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ya jo asehek tado, Kindrei kameh kuhi tondrok tan ereu mine aha lau badu Isra-el eme hamon, ya iy kameh atehei ili mine iri lau ra-on ja ale winiyan a-en hamon ta so-ok tan amwenen. ");
INSERT INTO lid_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Are lau oro taku a bada bek doh kameh, ndruwi oro kameh ibok i le bwisik, arile, are lau oro i buku none bek doh, taku i la-u oro, idah kameh ati-i oro abwesek.” ");
INSERT INTO lid_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Oro tinan tiri pris hawe oro Parasi anuhun sahou sokek Jises amekes, oro tana oro buku Jises amekes sahou doh i la-u oro. ");
INSERT INTO lid_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Idoh mesekei budon toro ta ateu Jises handru, arile oro anoh iri lau mwan ma badih, tasah iri lau mwan ma badih anya Jises badeh, propet. ");
INSERT INTO lid_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jises amekes sahou sokek ili tiri lau ja i buku doh: ");
INSERT INTO lid_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tondrok ta Kindrei i buku none ari kabin, nadun mwan anya ki tasou, ya kabin nane mesekei tine nyamon. ");
INSERT INTO lid_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma mwena handru iy atehei sahou ili tiri lau kame ta nyamon ta tasou ta nadun. Ya, na len ta nyamon amwenen iy suni oro lohowan tan ala kaloh iri kame ta nyamon. Arile iri bwale iri. ");
INSERT INTO lid_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ya iy suni oro lohowan tan ra-on ja, ma iy tiye toro i buku doh, ‘Ado kala katiye tiri lau nane jo ndraluhi iri, ma ado katiye toro buku doh, jo ndralowosani nyamon kabwe. Iri bulumakau mwan ma hawe iri bou apar jo ndradai kabwe, ma jo ndralowosani lakou mari kabwe. Aha kame le kaimon nyamon ta tasou.’ ");
INSERT INTO lid_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Oro lohowan tan au ala tiye tiri lau nane, arile iri bwale iri anuhun, ma iri au ala amekes budon tiri amwenen. Ari iu ili bolo bilin tan, ari iu ili amekes gok ta akohok luk tan amwenen. ");
INSERT INTO lid_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Iri rayah tawi oro lohowan ta kabin nane luhani oro, ma adai oro amak. ");
INSERT INTO lid_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Eme ya kabin nane ibolosen, ma iy suni oro lau tan ta bahun ala adai iri lau nane, ma sulumwi kon tiri andrakak iu. ");
INSERT INTO lid_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Eme kabin nane anya, ‘Nyamon ta tasou ndralowosaniy kabwe, oro lau nane jo aloh oro ma bwena, ado kamani oro. ");
INSERT INTO lid_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ado kadek kala madasan mari, ya are lau ado ndruniy, ado kaluhi iri kame ta nyamon ta tasou.’ ");
INSERT INTO lid_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iy tiye i buku doh, ya oro lohowan tan nane au ala kon mari, ma oro luhi iri lau mwasin ma ndra-in ale ame. Asiu ta tasou nane aso na lau. ");
INSERT INTO lid_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Iri lau mari nane manyah ado andri, ya kabin nane eme bolon atou iri. Madan ili, iy atou ndramak ari, iy batehei awin ta ame bolo nyamon ta tasou nane bwe. ");
INSERT INTO lid_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Eme kabin nane ndremenyani iy, ‘Kawas tek, buku sah handru ou basini ari awin mwasin ta ame bolo nyamon ta tasou dah bwe?’ Iy ndramak nane basumon bwe. ");
INSERT INTO lid_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Kabin nane tiye toro lau ta ndrokei tan anya, ‘Ado kasawei katin ma minen ya ado kakahei iy ki-iu kili manan bolo lulik. Bolo lulik doh kameh iri lau aden andra-i labai ma lihi iri kameh asenyer andra-i labai.’ ");
INSERT INTO lid_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Ado kanuhun. Kindrei aloh taha mari. Arile iy ndralebelei ndramak ari, ari ta ili bolon.” ");
INSERT INTO lid_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Eme iri Parasi au ala manan atilik sahou tiri i se, ta takaleh madasan ta bolowa Jises ya sahou tan kinyon ma iri katehei iy ki mada sahou. ");
INSERT INTO lid_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Iri suni oro ra-on tiri hawe oro lau ra-on ta Herot, ala atou Jises, ma oro tiye tan i buku doh, “Ndramak ta leheya, aso tanan, ou lau ta asehek sahou handru. Ya, na sahou handru ou ale leheya iri lau mwan ma badih ta kandriyen ta Kindrei. Ou banoh ta ari ndramak bwe. Ya, ou asehek sahou ari le ili tiri lau mari, buku ndramak nyaran tinan, deh, ndramak iy nyaran bwe. ");
INSERT INTO lid_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Eme ya, ou asehek kamwenen keme taso. Ou abudon buku sah? Mwasin ta taha kadeu takis ki ta Sisa, deh, ndri-iy?” ");
INSERT INTO lid_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Arile Jises ndratanan budon toro ndra-in. Eme ya, iy asehek i buku doh, “Ado lau ta wasai, buku sah handru ado anya kanone jo? ");
INSERT INTO lid_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ado kaleheya keme tek ari luk nane ado asih takis tado na aliy.” Eme oro andrei luk bororoh ari ili minen. ");
INSERT INTO lid_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Eme Jises ndremenyani oro i buku doh, “Malawi ndramak ma nyaran kede-eh are lau handru?” ");
INSERT INTO lid_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Oro anya “Ta Sisa.” Iy tiye toro, “Mwasin, saba lakou ta Sisa, ado kadeu ki ta Sisa. Ya saba lakou ta Kindrei, ado kadeu ki ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Oro anuhun sahou doh ma boho oro asak. Eme ma, oro ruwani iy ma oro au ai. ");
INSERT INTO lid_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na len le nane, oro Sadusi ame hawe Jises anya kanone iy. Oro anya, iri lau ale ndramak bwena mene, iri kameh winiyan bamak ja bwe. Eme oro ndremenyani Jises i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ndramak ta leheya, Moses bwena mene anya, ‘Buku none ari ndramak imek, ya iy nadun bwe, nadu tinen kameh kandrei nyau tan ki udun, ya iy katehei nah ki tan, ma nah doh ki nyara nadu tinen, ya nyara nadu tinen sa-au, ndri-iy.’ ");
INSERT INTO lid_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Ya, len ari bwena, oro lau ma ndro taloh nadu tine oro areu ndrokowa ahi dah. Eme kadok toro i tasou ta badih ari, ya iy nadun bwe ma iy imek. Ma iy ruwani udun i mine nadu tinen oro. ");
INSERT INTO lid_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Bwaneh andrei iy, nadun bwe ale ma iy imek. Silih andrei iy buku aliy le, badih nane andromwei oro mari ano ili isos ta kalai. ");
INSERT INTO lid_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Oro amak, ya hamon ta aliy badih nane imek ale. ");
INSERT INTO lid_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ya, ou tiye taso. Na len hamon ta iri lau mari amak ame loken ja, badih doh kameh ili udu are lau handru? Ou tanam, iy i tasou ili toro mari.” ");
INSERT INTO lid_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Eme Jises asumon boho oro i buku doh, “Ado ndrandra-i labai, tasah ado tana ado tarou ereu bolo buk ndrabun ta Kindrei bwe. Ma ado tana ado boto-on ta Kindrei bwe ale. Eme ya ado asehek sahou laleyah. ");
INSERT INTO lid_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Na len iri lau ndramak kameh amak ame awas ja, ya iri kameh winiyan bala batasou ja bwe. Iri kameh asahan buku iri angelo areu kandrah. ");
INSERT INTO lid_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Handru labai. Iri lau ndramak bwena, hamon kameh iri amak ja. Sebwe ado batou bolo tarou ta Kindrei iy mene asehek ewek tado bwe nadeh? Iy asehek i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Jo Kindrei ta Abraham, ta Aisik, ma ta Jekop.’ Sahou doh leheya taha i buku doh: Kindrei atondrok koha oro ma taloh, ma oro ado awas ado hawen kahis le. Eme ma, Kindrei batiye anya iy mene Kindrei tiri lau ndramak, arile na dah, bwe. Bwe! Iy badeh, Kindrei tiri lau koha iri udu aliy kahis le.” ");
INSERT INTO lid_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iri lau mari anuhun sahou doh, mani iri atur ta sahou tan. ");
INSERT INTO lid_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kala doh oro Parasi anuhun buku Jises ndrasokei san toro Sadusi. Eme oro Parasi tukumwi oro a se ma oro ame atou Jises. ");
INSERT INTO lid_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ereu ndrokowa oro, ndramak ari iy tanan labai ta sahou batanau. Iy anya kanone Jises na sahou ya iy ndremenyani iy i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ndramak ta leheya, saba sahou batanau badeh, tinan handru ma sakalawi iri sahou batanau mari?” ");
INSERT INTO lid_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Eme Jises asumon i buku doh, “‘Ou aseken Laban tam Kindrei na ndrinem mari, ma na koham handru mari, ma hawe na budon tam mari.’ ");
INSERT INTO lid_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sahou batanau dah tinan handru ma iy batanau udu bwele-en labai. ");
INSERT INTO lid_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ya sahou batanau ari ja i buku le aliy, ‘Ou aseken iri lau ari ari badu hawem, i le buku ou aso-ok ou le.’ ");
INSERT INTO lid_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Sahou batanau ma la-uh doh kati iri sahou batanau malen mari hawe sahou tiri propet ale.” ");
INSERT INTO lid_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Oro Parasi atukum kahis le, Jises ndremenyani oro buku doh, ");
INSERT INTO lid_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ado abudon i buku sah handru ta ndramak taha aloh Krais o Mesaya? Iy nadu are handru?” Eme oro tiye i tan i buku doh, “Iy nadu Debit.” ");
INSERT INTO lid_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jises ndremenya oro ja i buku doh, “Ya i buku sah handru ya Malawi Ndrabun atehei budon i ta Debit ya Debit aloh ndramak nane ‘Laban’? Debit asehek i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Laban Kindrei tiye i ta Laban tek i buku doh: “Ou ame manyah ado loboho minek salin, winiya jo le baratehei iri lau ta amekes budon ndra-in i tam barado bahandra katim.”’ ");
INSERT INTO lid_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Ado kanuhun. Debit amwenen aloh ndramak nane Laban tan. Ya ki buku sah handru kameh iy ndramak nane ja ki nadu Debit?” ");
INSERT INTO lid_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ari toro winiyan basumon boho Jises bwe. Kala le doh, iri anoh ta ndremenya Jises ta randra sahou ja. ");
INSERT INTO lid_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Hamon ta aliy Jises asehek sahou ili tiri lau mwan ma badih hawe oro lau tan. ");
INSERT INTO lid_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Iy asehek i buku doh, “Iri lau ta leheya batanau malen hawe iri Parasi leheya aha ta sahou batanau, buku le Moses bwena mene amekes. ");
INSERT INTO lid_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Iri sahou mari oro asehek ewek taha badeh, aha kanuhun ma ka-en hamon ta aliy. Arile kandriyen oro amekes, ado sa-en hamon ta aliy, tasah oro asehek iri sahou, arile oro ba-en hamon ta sahou toro bwe. ");
INSERT INTO lid_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","I buku le oro atisih lau na kandriyen malen solo-an labai ta iri ka-en hamon ta aliy, arile oro winiyan batehei mine oro ta aseben bwe. ");
INSERT INTO lid_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Iri lakou mari oro amekes doh, ta amekes iri lau katou. Oro asin nyeh ndra tinan ta asolom ereu mine oro ma bwili oro, ma oro aseu malou lawe-en ereu kiri awin toro. ");
INSERT INTO lid_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iri anya kamanyah kareu le ndrahu kon ta atudun ta nyamon tinan, ma bwabwai mwasin badu ndrahu tukum tiri Juwis. ");
INSERT INTO lid_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ya oro anya lau mari kasumon oro na len ta baen. Ma oro anya lau kaloh oro ‘ndramak ta leheya.’ ");
INSERT INTO lid_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Arile lau saloh ado ‘ndramak ta leheya,’ ndri-iy. Tasah ndramak ari le, iy ndramak tinan ta leheya ado, ya ado mari badeh, nadu tine ado. ");
INSERT INTO lid_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ya ereu kon munyak dah ado saloh ari ndramak tama ado, ndri-iy. Ndramak ari le tama aha, ya iy udu kandrah. ");
INSERT INTO lid_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ya iri saloh ado ‘ndramak ereu bwena,’ ndri-iy, tasah ndramak ari le ereu bwena, iy Mesaya o Krais. ");
INSERT INTO lid_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ndramak nyaran tinan ereu ndrokowa aha iy kasahan lohowan taha. ");
INSERT INTO lid_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ndramak atudun nyaran amwenen ili loken, nyaran kameh eme andri, ya are lau amekes nyaran amwenen eme andri, nyaran kameh ili loken.” ");
INSERT INTO lid_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Jises asehek sahou ja i buku doh, “Ado lau tanan ta batanau malen ma ado Parasi, mada ado kaleu! Sisi-in laba tinan doh kameh ewek bwele-e ado! Ado kalime ado la-uh! Tasah, ado ndrasulu-i kou ta ala bolo kon mwasin udu kandrah ereu mada iri lau. Ado ale winiyan bala bolon bwe. Ya, buku none iri lau anya kala bolon, ado aturuk san tiri. ");
INSERT INTO lid_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ado lau tanan ta batanau malen ma ado Parasi, ado kabudon kamwenen! Sisi-in laba tinan doh kameh ewek bwele-e ado! Ado kalime ado la-uh! Ado adek bolo kon ma bwele-e ndras mari ta amekes ndramak ari le ta in hamon taha. Ya buku none iy in hamon taha, ado mesekei iy ndramak ta i bolo jih, i buku none ado le. Ado mesekei kandriyen tan asahan ndra-in, sakalawi tado ja. ");
INSERT INTO lid_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ado lau mada ado bwe! Sisi-in laba tinan doh kameh ewek bwele-e ado! Ado anya kaleheya san ki tiri lau, ado kabudon kamwenen. Ado asehek i buku doh, ‘Buku none ndramak asehek sahou handru i ta asiu tinan ta Kindrei, ma iy tandrakan handru i ta kon loken, idoh lakou laleyah. Arile, buku none ndramak asehek i ta gol ereu bolo asiu ta Kindrei, ma iy tandrakan ili kon loken, idoh kameh iy kabwidi lakou buku iy nane ndrasehek.’ ");
INSERT INTO lid_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ado lolo-ou ma mada ado bwe. Saba lakou iy mwasin ereu mada Kindrei? Gol mwasin deh, asiu tinan ta Kindrei? Ado tana ado bwe nadeh? Buku none gol ereu asiu tinan ta Kindrei, gol doh bamesekei asiu tinan ta Kindrei bala mwasin bwe; asiu ta Kindrei le mwasin, ma iy mesekei gol doh asahan mwasin ma ndrabun. ");
INSERT INTO lid_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ya ado ale anya, ‘Buku none ari ndramak tandrakan in bwele-e mada koto-ok, idoh ari lakou handru bwe. Arile, buku none iy tandrakan in bwele-e iri lakou ta asun ere bwele-e mada koto-ok, iy kamesekei buku iy nane ndratandrakan.’ ");
INSERT INTO lid_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ado mada ado bwe. Saba lakou mwasin ereu mada Kindrei, iri lakou ta asun nane deh, o mada koto-ok? Iri lakou ta asun nane ereu bwele-e mada koto-ok, idoh lakou laleyah. Arile, mada koto-ok le mesekei iri lakou ta asun nane asahan ndrabun ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ya, buku none ou tandrakan ereu bwele-e mada koto-ok, idoh ou asehek sahou ndrabun handru. Ou ndratandrakan udu bwele-e mada koto-ok ma hawe iri lakou mari ta salom nane ereu bwele-e mada koto-ok nane. ");
INSERT INTO lid_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ya buku none ou tandrakan ili bwele-e asiu tinan ta Kindrei, ou ndratandrakan ndrala bwele-e asiu tinan ta Kindrei ma ndrala bwele-e Kindrei ale, tasah ou ado bolo asiu tan. ");
INSERT INTO lid_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ya are lau tandrakan ili kandrah, iy ndratandrakan ndrala ndrahu manyah ta Kindrei ma Kindrei ale, tasah idoh ndrahunen ta manyah. ");
INSERT INTO lid_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ado lau ta leheya kandriyen tiri Juwis ma ado Parasi, mada ado kaleu! Sisi-in laba tinan doh kameh ewek bwele-e ado! Ado kalime ado la-uh! Iri bake mari badu bolo bilin ado apou ari, ari i ronoh, ronoh, ya ado adeu ari ari badu bolo ronoh doh, i ta Kindrei. Idoh mwasin, arile ado ndramani iri sahou tinan badu bolo batanau ta Kindrei, buku none kandriyen ta anuhun sahou amwenen, ma tikisiy lau, ma adeu budon boto-on i ta Laban. Sebwe mwasin ta ado ka-en hamon ta sahou batanau tinan ma ado samani iri sahou batanau bwisik nane ale. ");
INSERT INTO lid_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ado mada ado bwe. Ado anya kaleheya san ki tiri lau, arile ado amwenen batou san bwe. Ado atou lakou nadu bwisik buku buruku udu bolo suw tado, ya ado abo gok ta akohok eme len, arile ado batou lakou tinan buku kamel udu bolo suw tado, ya ado a-un le ma sakalami lakou mari. ");
INSERT INTO lid_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ado lau ta leheya kandriyen tiri Juwis ma ado Parasi, mada ado kaleu! Sisi-in laba tinan doh kameh ewek bwele-e ado! Ado kalime ado la-uh! Ado sikine kona bwesam ma kona bwekei amwenen, arile nyamon ale ado apwe irek in bolo bwekei tado, ado akohok i san ta bahana ma san ta ndrakok. ");
INSERT INTO lid_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ado Parasi, ado mada ado bwe! Ado kasikine bolo bwesam ma bolo bwekei op, ano konan barasahan mwasin ale. ");
INSERT INTO lid_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ado lau ta leheya kandriyen tiri Juwis ma ado Parasi, mada ado kaleu! Sisi-in laba tinan doh kameh ewek bwele-e ado! Ado kalime ado la-uh! Ado buku none ari lek ta lau ndramak areu bolon, konan badeh, iri nyosowaniy na iri kanyeu ma iri lakou konen mwasin labai, arile bolon kodo-oh ndrarahak le ndruwi ndramak ma manahun ndra-in labai. ");
INSERT INTO lid_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ado a buku aliy adeh. Iri lau atou bada ado, iri anya ado mwasin. Arile bolo oda ado kodo-oh irek ta sahou wasai ma kandriyen ta ba-en hamon ta sahou batanau bwe.” ");
INSERT INTO lid_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jises asehek sahou ili ja i buku doh, “Ado lau ta leheya kandriyen tiri Juwis ma ado Parasi, mada ado kaleu! Sisi-in laba tinan doh kameh ewek bwele-e ado! Ado kalime ado la-uh! Ado a-eh lek mwasin tiri propet, ma ado anyasou lek tiri lau mwasin. ");
INSERT INTO lid_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ma ado anya, ‘Buku none to ka-en hawe iri tubu taha bwena, sebwe to winiyan baseben ta adai iri propet ta Kindrei amak bwe.’ ");
INSERT INTO lid_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Na sahou ado amekes doh, ado leheya buku none ado nadu iri lau mene adai iri propet ta Kindrei bwena. ");
INSERT INTO lid_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mwasin, ado kadek, ado kabwidiy kano iri kandriyen ndra-in mene iri tubu aha mene ndramesekei! ");
INSERT INTO lid_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Ado mwak ndra-in. Kindrei kameh atehei ado ala ta mada sahou, ma ado kameh ala bolo jih. Ya ado kasahan kamwenen ki buku sah handru? ");
INSERT INTO lid_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ado kanuhun kamwenen! Jo kameh suni iri propet ma iri lau budon tiri mwasin ma iri lau tanan mwasin ta leheya ado, ame atou ado. Arile ado kameh adai iri ra-on amak ma atahi iri ra-on ala bada kei tondreh, hawe iri ra-on kameh ado ubwi iri na malou an bolo asiu ta atukum taha. Ya ado kameh sobolon iri ereu bolo kon tinan taha ma oro kameh sakaliye au ala kon rakon ja. ");
INSERT INTO lid_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kandriyen ta adai iri lau mwasin don adeh, mesekei maha-an eme kon munyak. Maha-an doh kameh ereu bwele-e ado amwenen. Iri adai iri lau mwasin udu ndra kabatana ndraye Ebol eme isos ndraye Sekaraya nadu Berekaya, iy ndramak ale ado adai ereu ndrokowa asiu tinan ta Kindrei ma mada koto-ok. Ado amwenen kameh akohok iri maha-an ta kandriyen ndra-in doh. ");
INSERT INTO lid_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jo asehek sahou handru ewek tado, sohowa iri kandriyen ndra-in doh kameh ewek bwele-e aha lau mwan ma badih ale kede-en.” ");
INSERT INTO lid_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jises asehek sahou ja anya, “Jerusalem, Jerusalem, jo tikisi ado labai, ado adai iri propet, ma ado ateu iri lau Kindrei suni iri ame atou ado, ma ado orowei iri na bek ma adai iri amak. San solo-an jo anya katukumwi nadum oro, buku none iri kakaro tukumwi nadu iri areu bahandra bani iri. Arile ado bwale ado! ");
INSERT INTO lid_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nadah asiu ta salom tado kameh andra-i ma udu laleyah. ");
INSERT INTO lid_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jo asehek tado amwenen, ado winiyan batou jo ja bwe, winiya le len hamon kameh ado anya, ‘Kasekesek ki ta ndramak doh iy eme ta nyara Laban.’” ");
INSERT INTO lid_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jises ruwani asiu tinan ta Kindrei ma iy iu i len, ya oro lau tan ame leheya i tan asiu tinan ta Kindrei nane, konen handru. ");
INSERT INTO lid_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Eme iy asehek sahou ja i toro i buku doh, “Ado ndratou iri lakou mari ta asiu kede-eh? Jo tiye tado amwenen, ari ndruwi asiu bek kameh winiyan bales bareu loken bwe. Iri marakon kameh ato-oh iu i andri.” ");
INSERT INTO lid_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jises eme manyah udu bwele-e mandrei Olip, oro lau tan aton le ame ndremenya iy anya, “Ou tiye keme taso, na saba len handru kameh lakou doh kasahan? Ya saba kalem kameh leheya aso buku none len tam ta eme hamon, ma kon munyak ano.” ");
INSERT INTO lid_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jises asumon oro i buku doh, “Ado kanyolom kamwenen, ya ari ndramak sawendreyani ado, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Iri lau solo-an kameh ame anya iri asehek sahou tek ma anya, ‘Jo dah Krais.’ Ya iri kameh wendreyani lau solo-an. ");
INSERT INTO lid_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ado kameh anuhun kurutuwe bahun ereu mirihik, ma yoyou ta bahun ereu len. Arile, budon tado sandra-i, ndri-iy. Iri lakou doh kameh asahan bwena op, arile lakou mari ta ano kameh, kahis le. ");
INSERT INTO lid_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tasah, kon munyak tinan ari kameh amekes bahun i ta kon tinan ari, ya kabin badu kon rakon kameh amekes bahun i ta kabin badu kon rakon ja. Son kameh asahan bolo kon, ma kon ari ari kameh ndroi asahan. ");
INSERT INTO lid_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Iri lakou mari doh anya kasahan buku none sisi-in ta badih anya kato-ou nah. ");
INSERT INTO lid_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ano, iri kameh ateu ado, ma a-um ado, ma adai ado amak. Iri lau badu kon munyak tinan mari kameh baseken ado bwe, tasah ado an hamon tek. ");
INSERT INTO lid_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na len doh kameh iri lau solo-an aruwe budon tiri udu tek iu, ma au ala hamon. Iri ari, ari kameh nyowonya ndramak ari ja ili tiri lau ndra-in, ma iri kameh bwale iri ndramak ari ja. ");
INSERT INTO lid_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Iri propet solo-an ta wasai kameh asahan, ma iri kameh wendreyani iri lau solo-an. ");
INSERT INTO lid_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kandriyen ndra-in solo-an kameh asahan, ma iri lau solo-an kameh ruwani kandriyen ta aseken ndramak ari ja. ");
INSERT INTO lid_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Arile, are lau tawiy ili isos munyak ano, Kindrei kameh winiyan akohok iy i hamon ja. ");
INSERT INTO lid_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Sahou mwasin dah nyala tondrok ta Kindrei kameh tiyaniy ili isos kon mari, ta iri lau marakon kanuhun, ano kon munyak dah barano. ");
INSERT INTO lid_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Hamon kameh aha anyolom ‘lakou munya-un ndra-in’ propet Daniyel mene tiye, lakou doh munya-un ndra-in ales udu kon ndrabun ta iy sare aliy. (Are lau anyolom sahou dah iy kabudon kamwenen.) ");
INSERT INTO lid_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Are lau iri are kon Judiya katobwak kala bolo mandrei. ");
INSERT INTO lid_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Are lau ereu bwele-e asiu loken sala hamon sala bolo asiu sakohok lakou tan, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ya are lau ereu bolo bilin sala hamon sala sakohok kolau tan, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Len doh kameh len ndra-in labai tiri badih ale nah ere tiri, ma badih nah ma nyandren. ");
INSERT INTO lid_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Aha kasolom ki ta Kindrei ta aha satobwak na len ta jor ma ur, ma na len ta amunyau, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tasah, na len ndra-in doh eme kameh kon mari kameh andra-i handru en, sakalawi iri len ndra-in mene kabatana Kindrei bwidi munyak eme taku dah. Ya ari ja hamon winiyan basakalawiy bwai. ");
INSERT INTO lid_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Arile, Kindrei ndrasani kane len doh. Ya i buku none iy basaniy bwe, ari ndramak winiyan basakalawiy bwe. Arile, toro lau le nane Kindrei ndranyowonyani oro, iy kameh sani len doh kameh a mo-on. ");
INSERT INTO lid_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ya buku none ari ndramak katiye taha, ‘Krais asah idah!’ deh, ‘Laban asah in kenoh!’ Aha sanuhun, ndri-iy labai. ");
INSERT INTO lid_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tasah, idah kameh, krais ta wendreya ma hawe propet ta wendreya kameh asahan. Ya iri kameh amekes iri lahou tinan ma kalem ta wendreya iri lau, ma iri ale anya kanone iri lau ala budon ta Kindrei udu tiri kataku. ");
INSERT INTO lid_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aha ndranuhun! Jo ndratiye taha bwena. ");
INSERT INTO lid_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ya, buku none lau asehek anya, ‘Laban ndrame, iy ereu bolo kon lomale an.’ Aha sala, ndri-iy. Ya buku none iri anya, ‘Iy asah aton kenah,’ aha satehei budon taha sala ta aliy, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Len ta Nadu Ndramak Awas eme hamon kameh mada lau mari atou iy. Iy kameh eme buku le kalik anya ereu rai, lau areu ndra jaha kameh atou ale. ");
INSERT INTO lid_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kon ale oda ari lakou, o ndramak ereu aliy, idoh kamen adeh, iri sirih ta aimon lakou bolo-an le kameh atukum areu aliy.” ");
INSERT INTO lid_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Hamon ta len ndra-in asahan, ‘An kameh ilik, ma bun kameh winiyan banya bwe. Ya ndrau udu kandrah kameh taku ereu kandrah eme andri, ma boto-on mari badu kandrah kameh nyukunyok.’ ");
INSERT INTO lid_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Hamon ta aliy, idah kameh kalem ta Nadu Ndramak Awas asahan bolo kandrah, ya lau mari badu munyak kameh aden, ma iri kameh atou Nadu Ndramak Awas asahan ereu bwele-e asi kandrah, ma boto-on tan ma lomadan tinan labai. ");
INSERT INTO lid_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ya kurutuwe ndrah kameh anyar tinan labai, ma iy kameh suni oro angelo tan au ala kati jor ma hahuw ereu bolo munyak dah, ta atukum iri lau tan, ala budon tan udu tiri, ereu kon ranah ili taku ranah ame hawen. ");
INSERT INTO lid_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ado kanyolom kei pik, ya iy kameh tiye tado. Buku none andran irek ta gwa ma nyabun asahan, ado tana ado, idah kameh mirihik kon i le an ai. ");
INSERT INTO lid_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ya, buku none aha anyolom iri lakou nane jo ndrasehek, aha tana aha len ndrame bakep, ya Nadu Ndramak Awas ndrareu le mada kou ta eme hamon ai. ");
INSERT INTO lid_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jo tiye tado handru en! Iri lau rebesem areu kede-eh kahis na len dah kameh bamak bwe le, iri lakou mari doh kameh asahan. ");
INSERT INTO lid_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kandrah hawe kon munyak dah kameh ano iu, arile sahou tek le kameh winiyan bano bwe. ");
INSERT INTO lid_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ari ndramak bala tanan len, deh, mada an ta Laban eme hamon bwe. Iri angelo badu kandrah ale ma nadun ale tanan bwe, taman le ari tanan. ");
INSERT INTO lid_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Len ta Nadu Ndramak Awas eme kameh asahan, buku le iri lakou mene asahan na len ta Nowa. ");
INSERT INTO lid_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Na len bwena ta wadah asahan, iri lau amekes nyamon tinan, iri a-un gwa, iri mwan ma badih atasou ili eme, ili le isos ta len Nowa oro ala bolo ndron tan tinan. ");
INSERT INTO lid_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Arile, iri lau tana iri bwe, winiya le wadah eme aluwi iri mari au. Len ta Nadu Ndramak Awas kameh asahan buku le len mene ndrasahan bwena. ");
INSERT INTO lid_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na len doh, uru lau la-uh kameh abo gok se ereu bolo bilin, ya ari kameh iu, ya ari kameh udu api. ");
INSERT INTO lid_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Uru badih la-uh kameh alim badu wit areu se, ari kameh andrei iy iu, ya ari kameh udu api. ");
INSERT INTO lid_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Aha kanyolom kamwenen, tasah aha tanan saba len Laban taha eme hamon, bwe. ");
INSERT INTO lid_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Arile, budon tado kaleu ta tanan doh: Buku tama asiu i tanan, saba ben handru iri lau ta bahana kameh ame apou asiu tan, iy kameh winiyan bamadin bwe, iy kameh atehei ndrokei, tasah iy winiyan bamukuni iri lau ame apou asiu tan bwe. ");
INSERT INTO lid_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ya buku none aha ale, aha kalokou aha na len mari. Tasah, Nadu Ndramak Awas kameh asahan na len aha batehei budon ta iy eme bwe. ");
INSERT INTO lid_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Are lau iy mwasin ta gok, ma iy budon mwasin? Iy don adeh, tinan tan ndratehei tondrok tiri lau tan ra-on ja ndra-en bahandran ta adeu niri nyamon na len ari ari, iy le tanan. ");
INSERT INTO lid_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sekesek handru in bwele-e ndramak doh, buku none tinan tan eme takalahi iy amekes gok tan mwasin. ");
INSERT INTO lid_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jo tiye tado handru, tinan tan kameh atehei iy ta atondrok iri lakou tan mari. ");
INSERT INTO lid_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Arile, buku none iy lau ta gok ndra-in katiye anya, ‘Ndramak ta asiu doh kameh winiyan bame suwi bwe,’ ");
INSERT INTO lid_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ya iy kameh a-um iri lau ta gok hawen, ma iy kameh ili aimon nyamon ma a-un gwa lolo-ou hawe iri lau ta a-un gwa lolo-ou. ");
INSERT INTO lid_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ya, na len ari, tinan ta ndramak nane ta gok kameh eme hamon na len iy ndramak nane tanan bwe. ");
INSERT INTO lid_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tinan tan kameh sani iy i lunah, ma mesekei iy akohok maha-an buku le iri lau kalime iri la-uh. Iy kameh anyar, ma asenyer lihin. ");
INSERT INTO lid_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Tondrok ta Kindrei udu kandrah i buku le oro badih bihin ma ronoh. Ndramak ari anya ki tasou. Eme ma, iri badih bihin doh bwese-ei sun toro ta ala ndruni iy in san ma tiyani iy eme ta molak. ");
INSERT INTO lid_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Oro limeh badeh bale oro bwe, ya oro limeh oro tanan labai. ");
INSERT INTO lid_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Oro limeh bale oro bwe nane bwese-ei lam toro, oro bakohok ra-on ndrelekei ja bwe. ");
INSERT INTO lid_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Oro limeh nane bale oro udu aliy, oro kuhi lam toro, ma oro kuhi ndrau ndrelekei ari ale. ");
INSERT INTO lid_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ndramak nane ta tasou bame suwi bwe, ya oro badih nane mada oro amadin, ya oro amadin. ");
INSERT INTO lid_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Na ndrukulu ben alih, iri anuhun ndramak ari aloh i buku doh, ‘Iy ndrame, ndramak ta tasou ndrame! Aha kame katou iy.’ ");
INSERT INTO lid_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Eme oro badih ma ronoh nane amak, mine oro i ta sun toro, anya katelem ja. ");
INSERT INTO lid_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Eme ya, oro limeh nane bale oro bwe, tiye toro limeh nane bale oro udu aliy, ‘Ado kanyohan aso sese ndrelekei tado, sun taso anya kamak ai.’ ");
INSERT INTO lid_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Arile oro limeh nane bale oro udu aliy anya, ‘Sebwe winiya to bwe nadeh! Ado ka hamon kala kasih ra-on ja kewek tado.’ ");
INSERT INTO lid_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Eme oro badih ma limeh nane adek au ala hamon ala asih toro ndrelekei, oro adek ala anya kasih le badeh, ndramak ta tasou nane asahan, ya oro limeh nane ndralowosani oro ma oro abe-en iy, oro au ala bolo asiu hawen, ma oro aimon nyamon ta tasou nane, ma iri sulu-i kou ihis. ");
INSERT INTO lid_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Luwen bwe oro badih limeh nane ame hamon aloh anya, ‘Laban, Laban, ou sulu-i kou, aso anya kawek asiu.’ ");
INSERT INTO lid_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Arile iy asumon boho oro anya, ‘Jo tiye handru, jo tanan ado bwe oh!’ ");
INSERT INTO lid_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Eme ya, ado kanyolom kamwenen, tasah ado tana ado bwe, saba len, ma saba mada an handru, kameh iy eme hamon ja. ");
INSERT INTO lid_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Tondrok ta Kindrei kameh i buku le ndramak ari anya kedek kili kon ari leheleh, ya iy luhi oro lohowan tan ya iy indrom luk tan ili toro ta oro katondrok. ");
INSERT INTO lid_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Iy abudon kandriyen ta gok ma nyamu lohowan tan ari, ari. Eme ya, i ta iy ari, iy atehei lamalou (K5,000), i ta ari ja iy atehei lulou (K2,000), i ta ari ja iy atehei ralou (K1,000), ano iy akohok tekedek tan iu ili kon len. ");
INSERT INTO lid_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Iy nane kuhi lamalou (K5,000), nawin bwe iy ili amekes ba-en na luk tan, eme ya iy kuhi lamalou (K5,000) ja ili hawen. ");
INSERT INTO lid_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ya iy nane kuhiy lulou (K2,000) mesekei buku aliy ale, ma iy kuhi lulou (K2,000) ja ili hawen tan nane. ");
INSERT INTO lid_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Arile, iy ari nane kuhiy ralou (K1,000) le, ili ihi lek ili bolo ndren, ma iy tone luk ta tinan tan nane. ");
INSERT INTO lid_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Jaha solo-an iu ano tinan toro lohowan nane eme hamon, ma iy ndremenya oro ta luk tan mene iy atehei ili mine oro. ");
INSERT INTO lid_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ndramak nane kuhi lamalou (K5,000) eme madan ma iy anya, ‘Tinan tek, ou mene atehei lamalou (K5,000) eme tek. Jo ili ja mesekei lamalou (K5,000) ja ndrala hawen.’ ");
INSERT INTO lid_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Tinan tan anya, ‘Lohowan tek, ou ndramak mwasin, ou ndranyowo-ei lakou nadu bwisik, idah kameh jo mesekei ou atondrok lakou tinan; ou ala bolo kon tek ta sekesek.’ ");
INSERT INTO lid_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ya iy ndramak nane kuhi lulou (K2,000) eme madan ma iy anya, ‘Tinan tek, ou atehei lulou (K2,000) eme minek, jo ndramesekei lulou (K2,000) ja ndrala hawen.’ ");
INSERT INTO lid_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Tinan tan tiye tan, ‘Ou ndramak mwasin; Ou ndranyowo-ei lakou nadu bwisik, idah kameh jo mesekei ou atondrok lakou tinan, ou ala bolo kon tek ta sekesek.’ ");
INSERT INTO lid_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Iy ndramak nane kuhi ralou (K1,000) le eme bwena ma iy anya, ‘Tinan tek, jo tanan ou badeh, ndramak ta losen. Ou akohok lakou laleyah ma akohok lakou badu bwisi limem bwe. ");
INSERT INTO lid_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Eme ya, jo inoh, ma jo ili tone luk tek nane ili bolo ndren. Idoh luk ralou (K1,000) tam kewek hamon.’ ");
INSERT INTO lid_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Arile tinan tan anya, ‘Ou ndramak ndra-in ma ou lau ta awoyah! Ou tanam jo kameh akohok lakou jo batah bwe, ma jo kameh atukum nyamon bolo kon mari ale jo bakeh badu nyamon bala aliy bwe. ");
INSERT INTO lid_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tasah handru ou mene batehei luk tek bala mine iri lau ta amekes luk asahan solo-an bwe? Ya, buku none jo asahan, jo kameh akohok luk tek ma saba lakou ja badu hawen. ");
INSERT INTO lid_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ado kakuhi luk ralou (K1,000) ereu minen keme len, ma katehei kili mine iy lau tan nane akohok lamalou (K5,000) i bwele-e lamalou (K5,000) mene udu minen ta atondrok. ");
INSERT INTO lid_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tasah, i ta ndramak ari, ari tan lakou udu aliy, idah kameh iy akohok solo-an ja ili la-un. Arile, ndramak tan lakou bwe, ya sese le iy tawiy, idah kameh kuhi mari ano iu. ");
INSERT INTO lid_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ya, ta lohowan ndra-in nane, ado kakahei iy kili bolo kon lulik. Kon doh iri kameh aden ma asenyer lihi iri.’” ");
INSERT INTO lid_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jises asehek sahou ili ja anya, “Na len Nadu Ndramak Awas eme ma lomadan, iri angelo tan ale ereu hawen, iy kameh manyah ereu koyeu tan lomadan handru. ");
INSERT INTO lid_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ya, iri lau mari badu munyak kameh ame atukum areu madan, ya iy kameh apou iri, ari i len, ari i len, buku none iri lau ta atondrok lebelei iri sipsip hawe me. ");
INSERT INTO lid_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma iy kameh atehei iri sipsip ala minen salin, ma iri me kameh ala minen kamweu. ");
INSERT INTO lid_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ya kabin kameh tiye toro lau areu minen salin anya, ‘Ado kame, tama ndranyosowani ado. Ado kame kakohok ndrahune ado, tama ndralowosaniy kala munyak dah ma ha-un kahis le. ");
INSERT INTO lid_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tasah, bwena jo imek son, ou adeu nek nyamon, balek amar ou atehei wa-ik gwa, jo lau badu leheleh ou luhi jo ili asiu. ");
INSERT INTO lid_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jo kolau bwe, ou atehei kolau ra-ei eme jo taniy, jo ibo sik ou ame tondrokei jo, jo in bolo kou, ou ame anyolom jo.’ ");
INSERT INTO lid_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ya iri lau mwasin kameh asumon iy anya, ‘Laban, na saba len ahi atou ou amak son, ya aso nyohonei ou; ya, na saba len balem amar ya aso atehei wa-im gwa? ");
INSERT INTO lid_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na saba len aso atou ou lau badu leheleh, ya aso luhi ou ame asiu; ya, ou kolau ta taliye bwe, ya aso atehei kolau ra-ei ewek ya ou taniy? ");
INSERT INTO lid_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ya na saba len ou abo sik, ya, ou areu bolo kou, ya aso awek anyolom ou?’ ");
INSERT INTO lid_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ya kabin kameh asumon i buku doh, ‘Handru, jo tiye tado, buku none ou ndrabwidiy ndrala ta ari nadu tinek laleyah kede-eh, ou ndrabwidiy ndrame tek.’ ");
INSERT INTO lid_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ya iy kameh tiye toro lau areu minen kamweu i buku doh, ‘Ado ka-au ka len! Lakou ndra-in udu la-u ado. Ado kala bolo jih, tama ndralowosaniy ta balik hawe oro angelo tan. ");
INSERT INTO lid_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tasah, jo imek son ado banyohan jo nyamon bwe, balek asamar ado badeu wa-ik gwa bwe. ");
INSERT INTO lid_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Jo lau badu leheleh ado baluhi jo bawek asiu bwe, jo kolau ta taliye bwe, ado badeu kolau bame tek ta taliye bwe, jo ibo sik ma jo in bolo kou ado bame banyolom jo bwe.’ ");
INSERT INTO lid_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Oro kameh asumon i buku doh, ‘Laban na kahis aso atou ou amak son, deh, balem amar, deh, ou lau badu leheleh, deh, ou kolau ta taliye bwe, deh, ou abo sik, deh, ou a-en bolo kou, ya aso banyohan ma bawek batou ou bwe?’ ");
INSERT INTO lid_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Iy kameh asumon i buku doh, ‘Handru jo tiye tado, buku none ou bamekes bala ta ari ndramak laleyah kede-eh bwe, ou bamekes bame tek bwe le.’ ");
INSERT INTO lid_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ya oro kameh au ala bolo kon ndra-in, arile iri lau mwasin kameh au ala bolo kon mwasin.” ");
INSERT INTO lid_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jises bwidi iri sahou doh ano, iy tiye toro lau tan anya, ");
INSERT INTO lid_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ado tana ado, len la-uh hamon kameh taha abudon len tinan ta Pasoba, ma Nadu Ndramak Awas kameh, iri atehei iy ili mine iri lau ndra-in, ma oro kameh tatahi iy ili bada kei tondreh.” ");
INSERT INTO lid_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Na len doh iri tinan tiri pris hawe iri lau tinan areu bwena tiri Isra-el atukum areu asiu ta tinan tiri pris, nyaran Kayapas. ");
INSERT INTO lid_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Oro atilik sahou toro i se ta takaleh san ta wendreya Jises, ma kateu iy, ma kadai iy kimek. ");
INSERT INTO lid_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Arile, oro tiye anya, “To samekes na len tinan ta nyamon, ndri-iy, koro-an iri lau kabokoro-ei ma bahun tinan kasahan.” ");
INSERT INTO lid_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jises udu Betani udu asiu ta Saimon, iy bwena lepra udu tan. ");
INSERT INTO lid_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jises udu andri aimon nyamon kahis le, badih ari eme ma bwisi ndrau ari ma ndrelekei manahun mwasin udu bolon, lakou doh sowan tinan labai, ma iy solowei ili batu Jises. ");
INSERT INTO lid_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Oro lau tan atou, ma oro abolosen ma oro anya, “Aden! Tasah handru iy asolou ndrelekei mwasin doh iu laleyah? ");
INSERT INTO lid_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ndrelekei doh nane katehei kili mada ba-en ya luk solo-an asahan ta aliy, ya katehei ki tiri lau tiri lakou bwe.” ");
INSERT INTO lid_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Arile, Jises tanan budon toro, ma iy anya, “Ado abudon ndra-in i ta badih kede-eh tasah? Badih kede-eh ndramesekei lakou tinan ma mwasin labai ndrame tek. ");
INSERT INTO lid_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Iri lau tiri lakou bwe kameh len mari ado hawe ado, arile jo kameh winiyan bado hawe ado len mari bwe. ");
INSERT INTO lid_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iy solowei ndrelekei doh eme badak ta alokou jo ta ili bolo lek. ");
INSERT INTO lid_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Handru, jo tiye tado. Saba kon iri atiye sahou mwasin ili udu bolo kon munyak dah, saba lakou iy ndrabwidiy dah kameh iri asehek ta aliy ta abudon nyaran.” ");
INSERT INTO lid_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ano ya iy ari ereu ndrokowa oro ronoh la-uh nyaran Judas Iskariyot, iy ili atou oro tinan tiri pris. ");
INSERT INTO lid_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma iy tiye toro, “Saba lakou handru kameh ado atehei eme tek, buku none jo atehei iy ewek mine ado?” Eme oro sihinei iy na bek nyikilikin silba ma tonoh (30). ");
INSERT INTO lid_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kala doh iy takaleh madasan ta katehei iy kili mine oro. ");
INSERT INTO lid_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na len ma bwena ta nyamon tinan ta jabi ramen oro bamekes yis bala bolon bwe, oro lau ta Jises ame ndremenya iy anya, “Saba kon ou aso-ok aso kalowosaniy ta to kaimon nyamon ta Pasoba kudu aliy?” ");
INSERT INTO lid_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Eme iy anya, “Ado kala bolo kon tinan kala katou ndramak ari ma katiye ki tan, ‘Ndramak ta leheya anya, len tek ndrame mirihik; jo kameh aimon nyamon udu asiu tam hawe oro lau tek.’” ");
INSERT INTO lid_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Eme oro lau ta Jises mesekei buku le Jises nane ndrasehek, ma oro lowosani nyamon ta Pasoba ma asiu buku le aliy. ");
INSERT INTO lid_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kon abeyeh Jises hawe oro lau tan ma ronoh la-uh manyah ado andri ta aimon nyamon. ");
INSERT INTO lid_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Oro aimon nyamon kahis le, iy tiye, “Jo asehek sahou handru ewek tado, iy ari ereu bolo ado kede-eh kameh atehei jo ili mine iri lau ndra-in.” ");
INSERT INTO lid_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Eme oro tikisiy handru en, ma oro ari ari ndremenya iy anya, “Laban ou tiye, jo deh, bwe?” ");
INSERT INTO lid_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Eme iy asumon boho oro anya, “Are lau na dah edeu minen i bolo bwekei hawek, iy kameh adeh, atehei jo ili mine iri lau ndra-in. ");
INSERT INTO lid_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nadu Ndramak Awas kameh imek i buku le tarou mene ndratorowenei ta nyalan. Arile sisi-in laba tinan kameh i bwele-e ndramak iy ale atehei Nadu Ndramak Awas ili mine iri lau ndra-in, sebwe mwasin tinen mene satuwi iy, ndri-iy!” ");
INSERT INTO lid_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas, iy lau kameh edeu iy ili mine iri lau ndra-in, ndremenya anya, “Ndramak ta leheya, jo deh bwe?” Jises tiye tan, “Ou ndratiye badeh, kabwai.” ");
INSERT INTO lid_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kala oro aimon nyamon doh, Jises kuhi jabi ramen, ma iy asolom i la-un, iy boso-ei i noro lau tan, ma iy anya, “Ado kakohok ma ado kaimon, idah odak amwenen.” ");
INSERT INTO lid_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ano iy kuhi bwiniu waen, ma iy edeu wurah i ta aliy, ano iy edeu wa-i oro lau tan, iy anya, “Ado mari ka-un. ");
INSERT INTO lid_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tasah, idah ndrayek ta sahou randra le, ndrayek amou ta sikine lau mari ta kandriyen ndra-in tiri. ");
INSERT INTO lid_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jo asehek tado, jo kameh winiyan ba-un ndraye buwa waen dah hawe ado ja bwe, winiya le len jo kameh a-un ja i san ha-un hawe ado udu bolo tondrok ta tama amwenen.” ");
INSERT INTO lid_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Eme oro ayah wari ari ta atudun, ano ma oro au ala mandrei Olip. ");
INSERT INTO lid_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ano Jises tiye toro i buku doh, “Ado mari kameh ruwani jo, ma sakaliye au na ben dah, tasah iri ndratorowei bwena udu bolo buk ndrabun i buku doh, ‘Jo kameh idi ndramak ta tondrok, ya iri sipsip tan kameh aseker laleyah.’ ");
INSERT INTO lid_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Arile, hamon ta aliy kameh jo amak ja, ya jo kameh ili bwena tado ili Galili.” ");
INSERT INTO lid_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita asumon iy i buku doh, “Buku none oro mari atou lakou asahan tam, ya oro anoh ma aseker, jo kameh winiyan baruwani ou bwe.” ");
INSERT INTO lid_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jises tiye tan anya, “Handru jo asehek tam. Na ben dah kameh, kakaro baden bwe le, ou kameh besebes anya ou tanam jo bwe san tulusin.” ");
INSERT INTO lid_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita tiye tan anya, “Jo winiyan basehek sahou badeh bwe, buku none jo imek hawem jo winiyan babesebes anya jo tanan ou, bwe.” Eme ya oro lau tan mari asehek sahou buku aliy ale. ");
INSERT INTO lid_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ano Jises ma hawe oro lau tan au ala kon ari aloh Getsemeni. Eme iy tiye i toro lau tan, “Ado kamanyah kado dah, ya jo kameh ili sese kodo-oh asolom.” ");
INSERT INTO lid_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Iy kuhi Pita hawe nadu Sebedi uru ma la-uh, iy tikisiy ma budon tan andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Iy tiye toro anya, “Jo tikisiy labai, ma jo anya kimek. Ado kado dah ma mada ado katele hawek.” ");
INSERT INTO lid_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eme Jises edek ili bwena sese, ma iy taku i le batalan. Eme ma iy asolom i buku doh, “Tama, buku none winiyan eh, ou kuhi maha-an ta tikisiy udu bwele-ek dah ki-iu, arile idoh budon tek le, ou amekes saba lakou ou tanam mwasin.” ");
INSERT INTO lid_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ano, iy eme hamon iy atou oro lau tan ndramadin, ma iy tiye ta Pita, “Buku sah handru ya ado winiyan bareu loken luluwen hawek bwe? ");
INSERT INTO lid_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ado kanyolom ma ado kasolom ki ta Kindrei ta ado sataku sala bolo kandriyen ndra-in. Ndrine ado aso-ok handru ta amekes gok, arile oda ado badeh, boto-on handru bwe.” ");
INSERT INTO lid_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","San rasan ja Jises iu ili len ma iy asolom, “Tama, buku none maha-an dah winiyan ba-au bwe winiya le jo kanyuwiy, mwasin, tama jo in hamon ta budon tam.” ");
INSERT INTO lid_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ano ja iy eme hamon atou oro ndramadin ja, tasah mada oro amadin labai. ");
INSERT INTO lid_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jises ruwani oro areu gwek, iy iu ili hamon asolom san rasan ja, iy tiye sahou buku le iy nane ndrasehek ndrala ta taman. ");
INSERT INTO lid_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ano iy eme hamon atou oro lau tan ma iy anya, “Ado kede-eh amadin ma amunyau kahis le? Ado katou! Mada an ndrano ai. Idah kameh, Nadu Ndramak Awas kameh ili mine iri lau ndra-in ai. ");
INSERT INTO lid_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ado kareu loken, to ka-au. Ado katou, iy ndramak ta atiye jo ili mine iri lau ndra-in asah ndrasahan idah.” ");
INSERT INTO lid_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iy asehek sahou kahis le, Judas, iy badu hawe oro lau ma ronoh la-uh nane, iy edek eme hawen, hawe iri lau solo-an handru en, ma samen ma kei udu mine iri. Iri tinan tiri pris ma ndramak ereu bwena tiri lau suni oro ame. ");
INSERT INTO lid_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas nane ndratiye toro i buku doh, “Are lau jo atehei bohok i bohon, badeh iy le ai, ado katawi iy ai.” ");
INSERT INTO lid_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judas ales amwenen ili hawe Jises ma iy anya, “Ei, ou ndramak ta leheya!” Ma iy atehei bohon i boho Jises. ");
INSERT INTO lid_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Eme Jises asumon bohon anya, “Kawas tek, sasah ou anya amekes, ou amekes ai.” Iri lau ame atehei mine iri i ta Jises ma tawi iy. ");
INSERT INTO lid_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ndramak ari badu hawe Jises aluwi samen tan, ma sani ka-u ndranye bonyo-ou ta tinan tiri pris iu. ");
INSERT INTO lid_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jises tiye tan, “Ou atehei samen tam ki hamon ki ndrahunen! Are lau akohok samen, iy kameh imek na samen. ");
INSERT INTO lid_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Sebwe ou tanam bwe nadeh? Jo winiyan ndremenya tama, ya iy winiyan suni iri angelo solo-an labai, kane iri sakalawi iri lau ta bahun badu kon munyak tinan ma ronoh la-uh, tukumwi i le se. ");
INSERT INTO lid_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Arile, buku none jo kamesekei buku doh, sahou ta Kindrei ereu bolo buk ndrabun tan kameh basahan handru bwe. Buk ndrabun ta Kindrei anya, iri lakou doh kasahan tek.” ");
INSERT INTO lid_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kala doh Jises asehek tiri lau nane ta ateu iy anya, “Buku sah ya ado ame ma samen hawe kei ta ateu jo, jo ari lau ta amekes ramwes deh? Len mari jo manyah udu bolo asiu tinan ta Kindrei ma jo asehek sahou ma leheya aha, ya aha bateu jo bwe. ");
INSERT INTO lid_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Arile iri lakou mari dah asahan ta amekes sahou iri propet mene ndratorowenei asahan i handru.” Eme oro lau ta Jises mari ruwani iy ma oro atobwak au. ");
INSERT INTO lid_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iri lau nane tawi Jises kuhi iy ili asiu ta Kayapas iy tinan tiri pris. Iri lau ta leheya kandriyen tiri Juwis ma hawe iri lau-en atukum ado aliy. ");
INSERT INTO lid_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Arile, Pita in hamon tiri ili, iy ili isos bada kowah ta mada asiu ta Kayapas. Iy iu ili bolo kowah ma iy manyah hawe iri lau ta ndrokei, iy anya kanyolom saba lakou handru kameh asahan ta Jises. ");
INSERT INTO lid_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Oro tinan tiri pris ma hawe iri lau mari ta kansol nane anya kanone katakaleh ari sahou wasai kihis bada Jises ma iri kadai iy kimek. ");
INSERT INTO lid_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Iri lau solo-an ame asehek sahou wasai, arile iri batakalahei ari lakou ndra-in Jises mesekei bwe. Hamon ta aliy uru lau la-uh asahan. ");
INSERT INTO lid_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ma uru anya, “Ndramak kede-eh anya, ‘Jo winiyan tohowei asiu tinan ta Kindrei, ya len taloh hamon jo winiyan tahiy i loken ja.’” ");
INSERT INTO lid_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tinan tiri pris suri iy ereu loken ma iy tiye ta Jises anya, “Ou randra sahou ta tiye i ta sahou nane doh oro to-en ewek tam deh bwe?” ");
INSERT INTO lid_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Arile bwai, iy andru-uk le ai. Ano, tinan tiri pris asehek sahou i tan ja anya, “Jo ndremenya ou na nyara Kindrei kohan udu aliy, ya ou tandrakan handru ki loken ma ou tiye taso. Ou kede-eh Krais handru deh bwe? Ya ou Nadu Kindrei?” ");
INSERT INTO lid_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jises asumon bohon anya, “Ou ndrasehek badeh kabwai. Arile jo tiye tado, hamon kameh ado anyolom Nadu Ndramak Awas kameh manyah udu loboho lim salin ta Kindrei iy boto-on labai, ya iy kameh udu bwele-e asi jor badu kandrah eme.” ");
INSERT INTO lid_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Eme ma tinan tiri pris ibolosen ta sahou doh ya iy tarani awin tan le ma iy anya, “Iy ndrabobose nyara Kindrei kabwai. Ya buku sah ja to anya kasilah sahou ta i badan ja? Ado mari ndranuhun sahou bobose nane. ");
INSERT INTO lid_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ya ado abudon i buku sah?” Eme iri asumon anya, “Iy ndrabwidi kandriyen ndra-in, ya iy kimek ta aliy.” ");
INSERT INTO lid_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ano iri amuri bwilin ma a-um iy, ya oro ra-on atahan lim i kapan, ");
INSERT INTO lid_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ma anya, “Ou ndramak Kindrei ndraleheyaniy, ou asehek sahou buku none iri propet. Ou tiye taso, are lau a-um ou doh?” ");
INSERT INTO lid_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita manyah udu manan boho asiu, ya badih ari lohowan ta tinan tiri pris eme atou iy, ma iy anya, “Ou ale, ou are hawe Jises badu Galili.” ");
INSERT INTO lid_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Arile Pita besebes udu mada iri lau mari anya, “Jo tanak saba sahou ou asehek kede-eh bo-oh.” ");
INSERT INTO lid_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ya Pita suri iy ma iy iu ili manyah udu madasan ta eme asiu. Badih ta lohowan ari ja atou iy, ma iy tiye toro lau areu mirihik tan anya, “Iy ndramak kede-eh badu hawe Jises badu Nasaret.” ");
INSERT INTO lid_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita anuhun ma iy anya ja, “Jo tanan ndramak badeh bwe, handru!” Ma iy tandrakan ale. ");
INSERT INTO lid_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Luwen bwe iri lau areu san ame, ma tiye ta Pita, “Handru labai, ou kede-eh ari ai badu hawe oro, tasah sehek sahou tam kede-eh buku le aliy, handru en!” ");
INSERT INTO lid_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ano Pita tandrakan boto-on labai, “Jo asehek sahou handru, jo tanan ndramak badeh, bo-oh. Buku none jo wasai, Kindrei kamesekei maha-an keme la-uk.” Iy asehek sahou ano le badeh, kakaro eden. ");
INSERT INTO lid_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ano, Pita bwetenei sahou ta Jises ndratiye ndrala tan anya, “Kakaro baden bwe le, ou kameh besebes anya ou tanam jo bwe san tulusin.” Eme iy iu ili len, ma iy eden andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na mandraben handru en, iri tinan tiri pris ma hawe iri lau tinan amekes budon i bada Jises ta kadai iy kimek. ");
INSERT INTO lid_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Iri sawei iy, ma tiyani iy ili, ma atehei iy ili mine tinan tiri Rom nyaran Pailat. ");
INSERT INTO lid_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, ndramak ta edeu Jises ili mine iri lau ndra-in, iy i tanan ta iri atehei maha-an i la-u Jises, iy tubuni budon tan, ma iy kuhi luk silba bororoh ma tonoh (30) iu ili hamon ili mine tinan tiri pris ma tinan tiri lau. ");
INSERT INTO lid_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Iy anya, “Jo ndrabwidi kandriyen ndra-in. Ndramak jo atehei ewek mine ado badeh, babwidi ari kandriyen ndra-in bwe, ya ado kameh adai iy imek.” Oro asumon bohon i buku doh, “Ari lakou taso bwe, badeh lokowam labai.” ");
INSERT INTO lid_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iy akahei luk nane ili andri in bolo asiu tinan ta Kindrei, ma iy sakaliye iu. Eme iy ili simidi iy. ");
INSERT INTO lid_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tinan tiri pris kuhi luk nane ma iy anya, “Luk dah ta sa-oh. To satehei sala hawe luk badu bolo asiu tinan ta Kindrei, ndri-iy.” ");
INSERT INTO lid_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Oro mari atehei sahou i se, ya luk nane oro sihinei munyak ranah tiri lau ta amekes kun na ndren, ya munyak doh iri a-eh iri lau badu leheleh amak ala aliy. ");
INSERT INTO lid_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Idoh le ya iri aloh munyak doh, “Munyak ta ndra,” eme isos dah. ");
INSERT INTO lid_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Idoh mesekei sahou ta propet nyaran Jeremaya asahan handru anya, “Oro kuhi luk silba bororoh ma tonoh (30), kanen badeh, iri lau badu Isra-el sekesek ta akohok buku none sihinen, ");
INSERT INTO lid_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ya na luk nane oro sihinei munyak tiri lau ta amekes kun, buku none le Laban tiye tek.” ");
INSERT INTO lid_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jises ales udu bwena ta tinan tiri Rom, ma iy ndremenya iy anya, “Ou kabin tiri Juwis, neh?” Jises anya, “Ou ndrasehek badeh, kabwai.” ");
INSERT INTO lid_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Arile, iy basumon ari sahou bwe-en, kala tinan tiri pris hawe tinan tiri lau to-en sahou ili tan. ");
INSERT INTO lid_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Eme Pailat tiye tan buku doh, “Oh anuhun iri sahou doh iri lau to-en ewek la-um kede-eh deh bwe?” ");
INSERT INTO lid_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Arile Jises basehek ari sahou bwe, idoh mesekei tinan tiri Rom abudon solo-an labai. ");
INSERT INTO lid_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jaha mari na len ta nyamon tinan, ndramak in bwena ta kon tinan ruwani ndramak ari badu bolo kou eme len. Iri lau le aloh nyaran, ya Pailat kameh aruwe iy ili mine iri. ");
INSERT INTO lid_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Na len doh ndramak ari nyaran Barabas udu bolo kou ale tasah iy ta amekes kandriyen ta ramwes. ");
INSERT INTO lid_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iri lau tukumwi iri, ma Pailat ndremenya iri anya, “Aha aso-ok are lau jo karuwaniy kewek mine aha? Barabas deh Jises, iri asehek anya iy Krais, Kindrei suni iy eme.” ");
INSERT INTO lid_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat asehek buku doh, tasah iy tanan, ndrine iri ndra-in ta Jises, ma iri tiyani iy eme mada sahou. ");
INSERT INTO lid_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma kala Pailat manyah udu bada koyeu tan ta anuhun sahou kahis le, udun atehei sahou eme anya, “Ou samekes ari lakou sala bada iy lau badeh, ndri-iy, tasah na ben jo ameh jo atou ndramak badeh, ya ameh doh mesekei budon tek andra-i labai.” ");
INSERT INTO lid_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Eme iri tinan tiri pris ma oro lau tinan tiri lau sosokok iri lau solo-an dah anya, “Aha kaloh, ‘Ahi aso-ok Barabas keme mine ahi, ya ou adai Jises kimek.’” ");
INSERT INTO lid_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailat ndremenya iri ja, “Are lau handru aha aso-ok jo karuwaniy kewek mine aha?” Iri arah, “Barabas!” ");
INSERT INTO lid_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Eme Pailat ndremenya iri, “Ya jo kamekes sasah ki ta Jises iri aloh Krais?” Iri mari anya, “Katahi iy ki bada kei tondreh!” ");
INSERT INTO lid_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Iy anya, “Buku sah handru, saba lakou ndra-in handru iy mesekei?” Arile bwai, iri sarakau i loken le gwek anya, “Katahi iy ki bada kei tondreh!” ");
INSERT INTO lid_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat ndratanan ai, buku iri kameh winiyan banuhun sahou tan bwai, ya mirihik bahun anya kasahan. Eme iy kuhi gwa, ma iy sikine minen ereu mada iri lau mari, ma iy anya, “Ado sato-en sahou same la-uk buku none ndramak dah imek. Lokowa ado ai!” ");
INSERT INTO lid_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eme iri lau mari anya, “Ndrayen badeh, keme la-u ahi, ma nadu ahi!” ");
INSERT INTO lid_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pailat eme ruwani Barabas ili mine iri, arile iy atehei Jises ili mine iri lau ta bahun, ta iri ka-um iy na malou sakabuk i bek. Ano iy atehei Jises ili mine iri lulik ta katahi iy kili ta kei tondreh. ");
INSERT INTO lid_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Iri lau ta bahun ta Pailat kuhi Jises ili bolo asiu tinan ta atukum tiri Rom, ma iri mari tukumwi iri ame ales are madan. ");
INSERT INTO lid_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Eme iri tarani kolau tan iu, ma atehei kolau ari saraman lawe-en ili la-un. ");
INSERT INTO lid_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ya oro tabuwi bada malou bobodon i se buku none barak ma atehei ili batun. Ano oro atehei bala banap ari ili minen salin; ano oro atehei bwili ndru-u oro in bwena tan ma oro bobose iy anya, “Ou kabin tiri Juwis ou, areu le buku doh len mari!” ");
INSERT INTO lid_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eme oro amuri iy, ano oro kuhi bala banap nane ereu mine oro ubwiy i batun. ");
INSERT INTO lid_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Oro bobose iy ano, oro tolowei kolau saraman nane udu la-un iu, eme ma oro tani kolau tan amwenen ili hamon i badan. Ano oro sirini iy iu ili ta kadai iy ki bada kei tondreh. ");
INSERT INTO lid_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Oro adek au ala len, oro ndruni ndramak ari badu Sairini nyaran Saimon. Oro lau ta bahun andrekei iy bwese-ei kei tondreh ta Jises. ");
INSERT INTO lid_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Oro ame asos kon iri aloh Golgata, moson ta aliy iri aloh, “Kon ta bwisi bar ta ndramak.” ");
INSERT INTO lid_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Oro atehei waen, oro tubuni i hawe gwa ari nyakadan labai anya iy ka-un, arile Jises atona, eme iy ba-un bwai. ");
INSERT INTO lid_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Oro atahi iy i bada kei tondreh, ano oro atehei kolau tan i andri ma oro amekes laki na aliy, ta andrei kolau tan i le winiya iri. ");
INSERT INTO lid_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ano oro manyah ado andri, ma oro atondrok iy. ");
INSERT INTO lid_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Udu bwele-e batun loken, oro torowenei sahou tanan ta bobose anya, “Idah Jises, Kabin tiri Juwis.” ");
INSERT INTO lid_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ano oro atahi uru lau la-uh ta bahana areu mirihik ta Jises. Iy ari ereu minen salin, ya iy ari ereu minen kamweu. ");
INSERT INTO lid_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Eme ya iri lau adek mirihik tan, nyokoda batu iri ili eme ma bobose Jises i buku doh, ");
INSERT INTO lid_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Ou adeh, ou mene anya ou kameh tohowei asiu tinan ta Kindrei eme andri, ano kameh ou tutuniy ja na len taloh le. Ya abo, ou sebenei ou le ai, buku none ou Nadu Kindrei, ou ame andri ta kei tondreh badeh!” ");
INSERT INTO lid_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Oro tinan tiri pris ma iri lau ta leheya kandriyen tiri Juwis ma tinan tiri lau bobose Jises buku aliy ale. ");
INSERT INTO lid_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Iri anya, “Iy sebenei iri lau rayah, arile iy winiyan basebenei iy amwenen bwe! Iy badeh, kabin tiri Isra-el; iy keme andri ta kei tondreh, ya eme aso kameh atehei budon taso in hamon tan. ");
INSERT INTO lid_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Iy atehei budon tan in ta Kindrei, ma iy anya, iy badeh, Nadu Kindrei. Mwasin, aso anya katou iy kasebenei iy amwenen na dah ");
INSERT INTO lid_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Uru lau mala-uh nane sukik areu hawen ale asehek sahou ndra-in i tan ale. ");
INSERT INTO lid_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na mada an udu le alih, lulik tubuluhi kon marakon udu gwek winiya mada an i taloh na beyeh. ");
INSERT INTO lid_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Mada an ili taloh na beyeh, Jises arah boto-on labai anya, “Eli, Eli, lama sabaktani?” moson ta aliy i buku doh, “Kindrei tek, Kindrei tek, buku sah handru ya ou ruwani jo?” ");
INSERT INTO lid_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Eme iri lau ra-on areu mirihik anuhun sahou tan ma anya, “Iy kede-eh aloh Alaija!” ");
INSERT INTO lid_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Eme ma, suwi handru oro ari toro sakaliye ili kuhi konyei ari, tolomwani i bolo waen titi-in, ma atehei ili no-o banap ma atehei ili bohon ta iy ka-un. ");
INSERT INTO lid_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Arile oro ra-on anya, “Kareu op, to kanyolom, idah kameh Alaija eme aseben iy deh bwe.” ");
INSERT INTO lid_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Eme Jises arah tinan labai ja, ano iy ruwani kohan ma iy imek. ");
INSERT INTO lid_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kala doh amwenen kolau tinan badu bolo asiu tinan ta Kindrei atarah i ma lusi ereu loken eme andri. Munyak totoreh ma iri bek asak, i ma lusi. ");
INSERT INTO lid_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ma lek tiri lau mwasin ndramak bwena asak, ma iri lau mwasin ta Kindrei amak ame loken. ");
INSERT INTO lid_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iri ruwani lek tiri. Hamon ta Jises amak eme loken, iri ala bolo kon tinan Jerusalem, ma iri lau solo-an atou iri. ");
INSERT INTO lid_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Iri lau ta bahun ma tinan tiri nane atondrok Jises nane atou kon totoreh ma iri lakou mari nane asahan, oro anoh labai ma oro anya, “Handru labai, iy kede-eh Nadu Kindrei handru!” ");
INSERT INTO lid_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Iri badih solo-an ale ales areu len anyolom le, iri mene areu hamon tan adek loboho Galili ame ta aseben iy. ");
INSERT INTO lid_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ereu ndrokowa iri badeh, Mariya badu Makdala ma hawe Mariya ari ja tine Jemis uru Josep ma hawe udu Sebedi ale. ");
INSERT INTO lid_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kon abeyeh, ndramak ari nadu batun, tan luk solo-an badu Arimateya asahan, nyaran Josep. Iy badeh, ndramak ari ale badu hamon ta Jises. ");
INSERT INTO lid_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iy ili atou Pailat ta ndremenya bada kei, ma Pailat atehei sahou ta oro katehei bada kei kili mine Josep. ");
INSERT INTO lid_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Eme Josep kuhi bada kei eme andri, ma su-i iy na kolau ari ha-un, ");
INSERT INTO lid_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ma atehei iy ili bolo lek tan ma ha-un le iy ihiy in bolo munu bek. Ano iy tundruwi bek ari laba tinan ili turuki madan ano iy iu ai. ");
INSERT INTO lid_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya badu Makdala hawe Mariya ari ja uru ale manyah anyolom ili boho lek nane. ");
INSERT INTO lid_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Len ta alokou iri lakou ta len ta amunyau ano, ya len ari hamon, iri tinan tiri pris ma hawe iri Parasi ala atou Pailat. ");
INSERT INTO lid_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Oro tiye tan buku doh, “Tinan, aso bwetenei sahou ari ndramak ta wasai kede-eh mene asehek kala iy mene ereu loken kahis le, iy anya, ‘Hamon ta len taloh, jo kameh amak eme loken ja.’ ");
INSERT INTO lid_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Idoh le ya ou tiye, ya oro katondrokei mada lek nane kamwenen winiya len taloh, koro-an oro lau tan same sabwese-ei bada kei sa-au, ano oro kameh asehek tiri lau anya iy ndramak ndrame loken. Sahou wasai doh kameh ndra-in ja sakalawi wasai nane ndrasahan bwena.” ");
INSERT INTO lid_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat tiye toro anya, “Ado kakuhi iri lulik kala katondrokei lek nane, ya oro katondrokei kamwenen handru en.” ");
INSERT INTO lid_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eme oro ala turuki mada lek nane, ma oro lulik ales areu aliy ta atondrok. ");
INSERT INTO lid_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Len ta amunyau ano, ma ndra wahun ta len ma bwena ta wik ari ja, Mariya Makdala ma Mariya ari ja uru adek ala ta anyolom mada lek ta Jises. ");
INSERT INTO lid_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","I le mani tur, munyak nyukunyok ili eme, ya angelo ari badu kandrah eme andri ma susuwini bek badu mada lek iu i len. Ano iy ili manyah udu aliy. ");
INSERT INTO lid_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Konen i buku none kalik, ya kolau tan badeh, belen i buku none asi kandrah belen mara-ei. ");
INSERT INTO lid_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Oro lulik ta atondrok iy nane anoh labai, ya oro totoreh ma oro asahan buku none iri lau ndramak. ");
INSERT INTO lid_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Arile angelo nane asehek sahou ili turu badih nane anya, “Ah sanoh, jo tanan ah takaleh Jises, mene iri tatahi iy i bada kei tondreh. ");
INSERT INTO lid_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Iy bareu dah bwe, iy ndramak ndrame awas ja! Idoh buku none le iy mene ndrasehek. Ah kame katou ndrahunen mene iy amadin udu aliy. ");
INSERT INTO lid_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ano ah kala suwi katandra-un toro lau tan ta iy ndramak ndrame loken, ya iy ndra-au ndrala bwena ndrala Galili. Ya idah kameh, ado winiyan anyolom iy ereu doh, buku jo ndrasehek.” ");
INSERT INTO lid_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Eme ma, uru ruwani lek nane suwi suwi, uru anoh arile uru sekesek, uru sakaliye ala tiye toro lau tan. ");
INSERT INTO lid_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","I le mani tur, Jises asahan hawe uru ma iy anya, “Ndraben ta-ah.” Uru ame mirihik tan ma tawi katin ma asolom ili tan. ");
INSERT INTO lid_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jises tiye turu, “Ah sanoh, ndri-iy, ah kala katiye ta nadu tinek oro kala Galili, ya oro katou jo kameh in doh.” ");
INSERT INTO lid_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kala uru badih nane adek kahis le, oro lau ta ndrokei ra-on ta atondrok mada lek nane au ala bolo kon tinan, ma tiye iri tinan tiri pris nyala lakou mari nane asahan. ");
INSERT INTO lid_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tinan tiri pris atukum hawe iri lau tinan, ma tukumwi sahou toro i ari, ano oro atehei luk tinan labai ili toro lau ta ndrokei nane. ");
INSERT INTO lid_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ma iri tiye toro anya, “Ado kasehek ki buku doh, ‘Na ben, oro lau tan ame ya ndrabene-ei bada kei ndra-au, kala aso amadin kahis le.’ ");
INSERT INTO lid_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Buku none tinan badu kon anuhun sahou dah, aso kameh winiyan asehek sahou i tan, ya ado kameh winiyan bame mada sahou bwe.” ");
INSERT INTO lid_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eme oro lau ta atondrok mada lek nane kuhi luk ma oro ala amekes buku le oro nane ndranuhun. Sahou dah aseker ereu ndrokowa iri Juwis eme isos na len dah. ");
INSERT INTO lid_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Oro lau ta Jises ma ronoh ari nane au ala mandrei ari udu Galili buku Jises ndratiye toro ta ala aliy. ");
INSERT INTO lid_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ereu doh oro atou iy, ma oro atudun nyaran, arile oro ra-on badeh, budon toro i la-uh. ");
INSERT INTO lid_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Eme Jises eme mirihik toro ma tiye toro anya, “Boto-on ma lakou mari badu kandrah ma munyak badeh udu minek. ");
INSERT INTO lid_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ado kala kon mari, ya kamesekei iri lau mari kasahan lau tek, ado kalomwa iri na nyara tama, ma nadun ma hawe Malawi Ndrabun. ");
INSERT INTO lid_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma ado kaleheya iri ta lakou mari jo ndratiye tado. Ya jo kameh in hawe ado na len mari, winiya le munyak dah ano.” ");
INSERT INTO lid_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Idah sahou mwasin ma mwena asahan ta nyala Jises Krais, Nadu Kindrei. ");
INSERT INTO lid_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","I buku none propet Aisaya ndratorowenei, “Jo kameh suni ndramak ari ewek bwena tam. Iy kameh ta atehe san tam.” ");
INSERT INTO lid_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Ndramak ari aloh udu bolo kon lomale an i buku doh, ‘Kalowosa san ta Laban, ma kadik san kales lewan.’” ");
INSERT INTO lid_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ya eme Jon ta alomwa asahan bolo kon lomale an ta atiye sahou mwasin ma inyu iri lau, ma tiye tiri katubuni ndrine iri, ma Kindrei kameh sikine kandriyen ndra-in tiri mara-ei iu. ");
INSERT INTO lid_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Eme iri lau mari badu loboho Judiya ma badu kon tinan Jerusalem ame anuhun iy. Eme ma iri asehek budon ma lomondra ndra-in ta karei tiri i ta Kindrei, ma iy alomwa iri ta sikine kandriyen ndra-in tiri iu udu gwa Jodan. ");
INSERT INTO lid_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon isin awin iri amekes na lami kamel, ma iy aseu balaban, iri amekes na ku-i bulumakau udu ndrukulun i buku malou ta aseu awin tan. Ya iy badeh, kaniyan sabaye ma hawe bwirik badu lokei. ");
INSERT INTO lid_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Eme iy tiye i buku doh, “Ndramak ari in hamon tek eme kameh boto-on tan sakalawi boto-on tek ja. Jo badeh, mwasin handru bwe, ta aluh i andri ta talou malou ta molowa ku-i katin bwe. ");
INSERT INTO lid_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jo badeh, alomwa ado na gwa, arile iy kameh inyu ado na boto-on ta Malawin Ndrabun.” ");
INSERT INTO lid_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Eme nawin bwe na len doh, Jises ere Nasaret udu bolo Galili eme, ma Jon inyu iy in gwa Jodan. ");
INSERT INTO lid_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ano, Jises edek udu gwa eme loken le badeh, nawin bwe iy atou kandrah asak, ma Malawin Mwasin atah i buku ban eme andri eme bwele-en. ");
INSERT INTO lid_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ya, eme aloh ari udu kandrah tiye i buku doh, “Ou badeh, naduk handru, ma ou adek handru. Ou le mesekei jo sekesek labai.” ");
INSERT INTO lid_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ano suwi labai Malawin Ndrabun tiyani Jises iu ili kon lomale an. ");
INSERT INTO lid_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Eme Jises udu gwek winiya len ma hanoh (40) hawe iri katin haka, eme Satan none iy kataku, arile iri angelo ta Kindrei badu loken ame bwese-ei Jises ma aseben iy. ");
INSERT INTO lid_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ano hamon ta iri ndratehei Jon ta alomwa ndrala bolo kou, Jises eme asahan Galili ta atiye sahou mwasin ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Eme iy tiye i buku doh, “Len ndrasahan ai, ma tondrok ta Kindrei ndrame bakep! Ya ado katubuni ndrine ado ta karei ma lomondra ndra-in tado, ya ado katehei budon tado handru ki ta sahou mwasin.” ");
INSERT INTO lid_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ya eme Jises edek kabede gwa li Galili ili, ma iy atou Saimon hawe nadu tinen Enduru. Uru akeh kubwin turu ili bolo gwa li ta akohok ni, tasah uru lau ta bwisir ta ni. ");
INSERT INTO lid_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Eme Jises tiye i turu i buku doh, “Ah kame ka-en hamon tek ma jo kaleheya ah, san ta akohok lau.” ");
INSERT INTO lid_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Eme ya nawin bwe uru ruwani kubwin turu, ma uru au a-en hamon tan. ");
INSERT INTO lid_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ano Jises edek ili bwena sese ja, iy atou Jemis uru Jon an hawe tama uru Sebedi. Oro an ndron toro lowosa kubwin toro. ");
INSERT INTO lid_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Eme iy atou uru le badeh, ma iy aloh i turu, eme uru ruwani tama uru Sebedi hawe lau ta kubwin nane an gwek ai. Eme ma uru an hamon ta Jises. ");
INSERT INTO lid_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ano oro ame kon tinan Kapena-um na bolo len ta amunyau, eme ma Jises ili bolo asiu ta atukum tiri Juwis, ma leheya iri lau. ");
INSERT INTO lid_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Eme iri lau mari mani iri atur ta leheya tan, tasah iy leheya iri, bala buku none iri lau ta leheya kandriyen tiri Juwis, bwe. Arile, iy leheya iri, i buku none ari ndramak leheya tan boto-on labai. ");
INSERT INTO lid_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Eme nawin bwe, udu bolo asiu ta atukum tiri Juwis nane dah, ndramak ari malawin ndra-in udu bwele-en. ");
INSERT INTO lid_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Eme iy aloh, “Jises badu Nasaret, ou anya amekes sasah keme taso? Ou ame dah ta adai aso kamak ai? Jo tanan ou are handru kede-eh, ou badeh, ndramak ndrabun ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Arile Jises tiye sahou boto-on i ta malawin ndra-in anya, “Ou andru-uk ma ou ame len ta ndramak badeh!” ");
INSERT INTO lid_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Eme ma malawin ndra-in nane dah mesekei ndramak dah totoreh ma anyar bohon i loken, ano iy ruwani iy ma iy eme len. ");
INSERT INTO lid_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Eme iri lau mari mani iri atur, ma iri ndremenya iri ari ari, “Saba lakou handru dah? Idah tanan ha-un ja nadeh? Sahou ta ndramak dah boto-on labai, iy tiye le badeh, malawin ndra-in anuhun bohon ma iri au.” ");
INSERT INTO lid_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Eme ma sahou ta nyalan aseker ili bolo kon mari badu loboho Galili. ");
INSERT INTO lid_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ano nawin bwe oro ame len ta asiu ta atukum tiri Juwis ma oro adek ales ala asiu ta Saimon uru Enduru, ma Jemis uru Jon a hawe oro. ");
INSERT INTO lid_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Eme salahu Saimon ibo sik, badan nyarahan in bada sau. Eme Jises asahan le badeh, oro tiye i tan. ");
INSERT INTO lid_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Eme Jises ili hawen tawi minen ma suri iy eme loken, eme ma badan nyarahan nane iu, ma iy amekes noro nyamon. ");
INSERT INTO lid_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Eme na beyeh an anya ki andri badeh, iri atiye iri lau mari sik ma hawe lau malawin ndra-in udu bwele-e iri ame hawen. ");
INSERT INTO lid_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Eme iri lau mari badu kon tinan mara-ei atukum ala loboho le madasan ta asiu. ");
INSERT INTO lid_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Eme Jises mesekei iri lau, saba sik udu tiri badeh, amwenen ja, ma tikahei iri malawin ndra-in solo-an au. Eme iy tiye iri malawin ndra-in kandru-uk le, tasah iri tanan iy. ");
INSERT INTO lid_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ano na mandraben ma wahun an bame loken bwe le, Jises suri iy ma edek eme len ta asiu ma edek iu ili kon ari doh, lau bare aliy bwe. Eme ma iy udu aliy asolom. ");
INSERT INTO lid_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Arile Saimon hawe oro lau nane an hawen ala takaleh iy. ");
INSERT INTO lid_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eme oro ndruni iy ma asehek i tan, “Iri lau mari asilah ou.” ");
INSERT INTO lid_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Eme Jises tiye i toro, “To ka-au ka kon rayah ja, ya jo kameh kasehek sahou ki aliy, tasah jo dah eme ta aliy amwenen ai.” ");
INSERT INTO lid_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Eme ma iy edek ili loboho Galili mara-ei asehek sahou in bolo asiu ta atukum tiri Juwis ma atikah iri malawin ndra-in au. ");
INSERT INTO lid_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Eme ndramak ari sik lepra udu tan eme atehei bwili ndru-un i andri, ma iy ndremenya Jises i buku doh, “I buku none ou aseken, ou winiyan mesekei jo kamwenen ja udu mada Kindrei.” ");
INSERT INTO lid_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Eme Jises tikisi iy labai, eme iy atehei minen i badan ma tiye i tan i buku doh, “Jo aseken. Ya ou amwenen.” ");
INSERT INTO lid_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Eme ma nawin bwe, lepra udu badan amai iu laleyah ma iy ndramwenen ja. ");
INSERT INTO lid_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Eme iy suni iy iu ma tiye sahou boto-on i tan i buku doh, “Ou sala sasehek ta ari lau ja ai, ndri-iy. Arile, ou ales ala hawe iri pris, leheya badam ki tiri kanyolom, ano ou adeu salom ta asun i le buku Moses mene ndrabatanau, ya eme iri kanyolom ma katanan ou badeh, ndramwenen ja.” ");
INSERT INTO lid_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Arile bwai, ndramak nane dah ili asehek i tiri lau mari. Eme handru labai iy asehek san solo-an labai, eme Jises winiyan bala kon tinan bwe. Arile iy udu ndra kon nane lau aliy bwe doh, eme ma iri lau badu heh, badu heh ame le hawen. ");
INSERT INTO lid_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Na len ra-on hamon ja, Jises eme hamon eme Kapena-um, eme ma sahou ta nyalan ndraseker, tasah iy ndrame bolo kon. ");
INSERT INTO lid_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Eme iri atukum ala le, eme ma bolo asiu aso ma reu bwe, eme asiu winiya lau bwe, ma loboho madasan aso ale. Eme Jises asehek sahou mwasin i tiri. ");
INSERT INTO lid_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ya eme oro lau ma hahuw bwese-ei ndramak ari badan imek anya keme hawe Jises. ");
INSERT INTO lid_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Arile iri lau solo-an labai, eme oro winiyan batiyani iy bala hawe Jises bwe. Eme oro bosokei bwele-e asiu amwenen le bwele-e Jises ales udu aliy, eme oro atehei ndramak nane dah in bada nyahan tan ili andri amwenen le ta batala Jises. ");
INSERT INTO lid_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Eme Jises anyolom budon toro boto-on labai in tan, ya eme iy tiye sahou i ta ndramak nane badan imek anya, “Naduk, kandriyen tam ndra-in mari badeh, ndrasikine mara-ei ndra-au.” ");
INSERT INTO lid_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ya eme oro lau ra-on ta leheya kandriyen tiri Juwis manyah are doh ale, ya eme oro ari ari lomondra, ");
INSERT INTO lid_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“I buku sah handru iy asehek sahou ndra-in i buku doh i ta Kindrei? Ari ndramak winiyan basikine kandriyen ndra-in bwe. Kindrei le ari, kabwe!” ");
INSERT INTO lid_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Suwi labai Jises ndratanan budon toro, eme iy tiye i toro, “Tasah handru iri budon solo-an doh udu ndrine ado? ");
INSERT INTO lid_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Katiye ki manamwun ki buku sah handru ki ta ndramak badan imek dah, ‘Kandriyen ndra-in tam ndrasikine ndra-au,’ deh, bwe katiye, ‘Ou suri ou, ou andrei nyahan tam ma ou adek’? ");
INSERT INTO lid_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Jo winiyan leheya ewek tado ma ado ki tana ado, ta Nadu Ndramak Awas badeh, boto-on labai, udu bwele-e munyak dah ta tiye i ta ndramak ta mani kandriyen tan ndra-in iu.” ");
INSERT INTO lid_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Eme Jises tiye i ta ndramak badan imek dah, “Jo tiye tam, ou suri ou, ou andrei nyahan tam ma ou au a kon!” ");
INSERT INTO lid_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Eme iri mari anyolom ndramak nane dah suri iy eme loken, andrei nyahan tan ma iy edek iu. Eme iri mari mani iri atur labai, ma iri atudun nyara Kindrei i buku doh, “Ahi ndra bwena bwena batou ari lakou bala buku dah bwe!” ");
INSERT INTO lid_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ano Jises iu i hamon ja ili kapa gwa li Galili. Eme iri lau mari atukum ame hawen ma iy leheya iri. ");
INSERT INTO lid_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ano iy edek ili, ma iy atou ndramak ari ta akohok luk ta takis, nadu Alpeyus nyaran Libai. Iy manyah ereu bolo asiu tan ta gok ta akohok luk ta takis. Eme Jises tiye i tan, “Ou ame an hamon tek.” Eme Libai suri iy ma iy in hamon tan. ");
INSERT INTO lid_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ano Jises manyah udu bolo asiu ta Libai. Ya iri lau solo-an ta akohok luk ta takis, ma hawe iri Juwis ale ba-en hamon ta kandriyen ta batanau ta Moses bwe, ma hawe oro lau tan ame aimon nyamon hawen. Ya iri lau solo-an ale an hamon tan. ");
INSERT INTO lid_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Eme oro lau ta leheya kandriyen tiri Juwis ma hawe oro Parasi atou Jises aimon nyamon udu hawe iri lau ta lomondra ndra-in ma hawe iri lau ta akohok luk ta takis. Eme oro tiye i toro lau ta Jises, “Tasah handru iy aimon nyamon hawe oro lau ta akohok luk ta takis, ma hawe oro lau ale ba-en hamon ta batanau ta Moses bwe?” ");
INSERT INTO lid_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Eme Jises anuhun oro, ma iy tiye toro i buku doh, “Iri lau ale babo sik bwe, iri winiyan baso-ok ndramak ta anyumor iri bwe. Arile iri lau tiri sik le badeh, aseken seben. Jo eme dah ta aseben lau mwasin le bwe. Jo eme dah badeh, ta aseben iri lau ta karei ma ta lomondra ndra-in udu tiri kasahan mwasin.” ");
INSERT INTO lid_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Udu bolo len doh, oro lau ta Jon ma hawe iri Parasi, abeles iri ta nyamon. Eme lau ra-on ame ndremenya Jises anya, “I buku sah handru oro lau ta Jon ta alomwa ma hawe iri lau tiri Parasi abeles iri ta nyamon, arile oro lau tam ja, bwe?” ");
INSERT INTO lid_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Eme Jises asumon boho oro i buku doh, “I buku none ndramak tasou bolohau udu aliy, ado winiyan babilisi oro lau ta molak bwe! Arile, na len hamon eme, idah kameh iri kuhi iy eme len, ma na len doh, oro kameh winiyan baimon nyamon bwe. ");
INSERT INTO lid_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Arile, len hamon eme kameh, ndramak doh kameh, iri lau ta amekes kaliu i tan kuhi iy eme len. Ma na bolo len doh ale kameh oro winiyan baimon nyamon bwe. ");
INSERT INTO lid_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ado kanuhun. Ari ndramak winiyan bakuhi ranah kolau ha-un, ya suwidiy ja i manamunu awin malen bwe. Buku iri bwidiy i buku doh, ya iri sikine awin, kolau ha-un nane kameh bosokou, ma awin malen kameh atarah ja, eme ma munun kameh i tinan labai ja ai. ");
INSERT INTO lid_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ari ndramak winiyan basukuni waen ha-un bala bolo ku-i me malen bwe. Buku none iy amekes i buku doh, waen kameh tuburok, ma kohan kameh tarani ku-i me nane, ma waen kameh iu laleyah. Tasah waen ha-un badeh, ndrahunen ku-i me ha-un.” ");
INSERT INTO lid_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ano, udu bolo len ari ta amunyau, Jises ma hawe oro lau tan adek bolo bilin ari ta wit. Eme oro lau tan abwe-eh buwa wit nane dah. ");
INSERT INTO lid_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Eme ya oro Parasi ame tiye i ta Jises, “Hei, ou anuhun! Tasah handru oro abwe-eh buwa wit na len ta amunyau? I buku sah oro ba-en hamon ta kandriyen tahi bwe?” ");
INSERT INTO lid_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Eme Jises asumon iri i buku doh, “Buku sah handru ya ado abolosen eme tek ma hawe oro lau tek? Sebwe ado babudon bamwenen bado ta kundruh ta lakou kabin Debit mene mesekei bwe nadeh? Jo asehek ta lakou kala Debit hawe oro lau tan aso-ok lakou tasah oro ameson. ");
INSERT INTO lid_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ya eme iy ili bolo asiu ta Kindrei ya kuhi jabi ramen nane iri pris ndraleheyaniy ndrala ta mada Kindrei, in bolo bosoh ndrabun handru doh. Lakou idoh asahan na len pris, Abiyata in ndra tinan tiri pris. Ehe, Debit hawe oro lau tan aniy, arile jabi ramen doh ndrabun handru ta oro aimon. Iri pris le winiyan ta aimon.” ");
INSERT INTO lid_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Eme ma Jises asehek sendrehendreh i buku doh, “Mesekei len ta amunyau badeh, ta aseben ndramak labai, arile bamesekei ndramak ta aseben len ta amunyau bo-oh. ");
INSERT INTO lid_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Eme ma jo Nadu Ndramak Awas, ya jo tama len ta amunyau.” ");
INSERT INTO lid_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Eme Jises iu i hamon ja ili asiu ta atukum tiri Juwis, ya eme ndramak ari in aliy, minen imek. ");
INSERT INTO lid_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Oro lau rayah ado aliy, eme ya oro anya katakaleh madasan ta kadeu Jises ki ta mada sahou. Eme iri atehei mada iri udu tan, i buku iy kamesekei ndramak dah kamwenen na len ta amunyau dah, deh bwe. ");
INSERT INTO lid_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Eme Jises tiye i ta ndramak nane minen imek dah, “Ou ame mwena dah.” ");
INSERT INTO lid_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ya eme iy ndremenya iri, “Saba kandriyen mwasin kameh taha kamekes na len ta amunyau? Kamekes kandriyen mwasin ta aseben koha lakou deh, bwe kamekes kandriyen ndra-in ta adai lau?” Eme iri basehek randra sahou bwe. ");
INSERT INTO lid_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Eme Jises anyolom ili eme i tiri, eme iy ibolosen, arile bwai, ndrinen ale tikisi iri, tasah iri badeh, ndrandra-i ma ndrine iri ndraso. Ano, iy tiye i ta ndramak nane dah anya, “Minem kales!” Eme iy talasei minen ma minen amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Eme oro Parasi ame len ta asiu ta atukum, ma oro au suwi labai atukum hawe iri lau rayah ta Herot, eme ma oro asehek ma atilik nyala oro ta takaleh san ta kadai Jises kimek. ");
INSERT INTO lid_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ano Jises ma hawe oro lau tan ame gwa li Galili, ma hawe iri lau solo-an labai an hamon tan. Iri lau badeh, badu Galili, badu Judiya, ");
INSERT INTO lid_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ya badu Jerusalem, badu loboho Idumiya, badu loboho kapa gwa Jodan bilisiu ma hawe badu mirihik ta kon tinan Tair hawe Saidon. Iri lau solo-an doh nane ame hawe Jises, tasah iri anuhun lakou solo-an iy amekes. ");
INSERT INTO lid_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iri lau solo-an labai, eme Jises tiye i toro lau tan lowosani ndron ra-ei ta iy ki aliy, koro-an lau katisi iy. ");
INSERT INTO lid_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iy ndramesekei iri lau solo-an ndramwenen, ya eme iri lau sik udu tiri ndrokowa iri ame hawen, tasah oro anya kateu le badan. ");
INSERT INTO lid_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ya eme loboho heh, loboho heh, Jises ili badeh, iri lau malawin ndra-in udu bwele-e iri atou iy le badeh, iri atarah a andri ma aloh, “Ou badeh, Nadu Kindrei!” ");
INSERT INTO lid_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eme Jises batanau iri ta iri sanyowonya iy are lau handru, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Eme Jises iu ili bwele-e mandrei i loke ma iy aloh oro lau ala so-ok tan udu toro. Eme ma oro ame hawen. ");
INSERT INTO lid_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Eme iy andrei oro lau ma ronoh la-uh dah, eme ma Jises tondrohani nyara oro i aposel, lau badu hawen ma iy kameh tiye oro au a len atiye sahou. ");
INSERT INTO lid_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma iy edeu boto-on i toro ta atikah malawin ndra-in ki-iu. ");
INSERT INTO lid_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Ya idah nyara oro lau tan ma ronoh la-uh: Saimon (Jises tondrohani nyaran Pita), Nadu Sebedi uru, Jemis uru Jon (eme Jises tondrohani nyara uru Bowanekes, moson “Nadu Kuruh”), ya hawe Enduru, Pilip, Batolomiu, Metiu, Tomas, ma Jemis nadu Alpeyus, Tadeyus, Saimon Selot, Judas Iskariyot, iy ale ndramak doh hamon kameh iy edeu sa-oh ta Jises. ");
INSERT INTO lid_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Eme Jises iu i kon. Udu ja, lau solo-an labai atukum, eme Jises hawe oro lau tan ari len ta aimon nyamon bwe. ");
INSERT INTO lid_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eme lowan oro anuhun, ma oro anya kala kakohok iy, tasah iri lau anya, “Iy badeh, ndra lolo-ou.” ");
INSERT INTO lid_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Iri lau ra-on ta leheya kandriyen tiri Juwis are Jerusalem ame asehek anya, “Jises badeh, Belsabul ndra bwele-en!” Iri ra-on ja anya, “Idoh tinan tiri malawin ndra-in edeu boto-on i tan ta atikah iri au.” ");
INSERT INTO lid_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ya eme Jises aloh iri lau ame hawen ma iy asehek sahou sokek ra-on, “Ki buku sah handru tama iri balik Satan katikah Satan? ");
INSERT INTO lid_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ki buku sah handru, buku rakon kon buruwen kapou uru ki la-uh ya uru kadai uru, idah kameh ndrokowa uru udu aliy. ");
INSERT INTO lid_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","“Ya, ki buku iri lau badu boho kamen ra-em kaseker, idah kameh iri lau doh winiyan bales boto-on bwe. ");
INSERT INTO lid_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ya, ki buku oro lau ta Satan kapou oro ki lumuk, idah kameh iy boto-on bwe, ma kameh nyaran mirihik ano. ");
INSERT INTO lid_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ya, buku none ndramak anya ki bolo asiu ta ndramak boto-on, ma kabahana iri lakou tan, iy kameh amekes sah handru? Ma bwena handru iy kameh sawei iy ndramak boto-on nane na malou boto-on. Ano iy winiyan akohok iri lakou ereu asiu ta ndramak nane. ");
INSERT INTO lid_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Jo tiye tado handru! Kindrei kameh winiyan mani kandriyen ndra-in ta lau, ma sahou ndra-in lau asehek. ");
INSERT INTO lid_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Arile, are lau aluhe i bada nyara Malawin Ndrabun, Kindrei kameh winiyan bamani kandriyen ndra-in tan doh bwe, tasah maha-an tan winiyan bano bwe.” ");
INSERT INTO lid_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jises tiye sahou doh, tasah oro ra-on tiye anya, “Iy badeh, malawin ndra-in udu bwele-en.” ");
INSERT INTO lid_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eme tine Jises hawe nadu tinen oro asos. Oro ales are manan ya oro suni sahou ili ta ndremenya iy. ");
INSERT INTO lid_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ya lau solo-an labai manyah ma awudi Jises, eme oro tiye i tan, “Jises ei, tinem hawe nadu tinem oro are manan kodo-oh, oro anya ou ala.” ");
INSERT INTO lid_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Eme Jises tiye, “Ado anya tine handru, are lau bah? Ya nadu tine oro handru, lau heh bah?” ");
INSERT INTO lid_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Iy anyolom ili eme i toro lau nane manyah dah, eme ma iy tiye, “Jo asehek tado, tine ma nadu tine oro handru, asah ado mari manyah kede-eh! ");
INSERT INTO lid_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Are lau in hamon ta so-ok ta Kindrei, iri badeh, nadu tine mwan ma badih handru, ma tine handru.” ");
INSERT INTO lid_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ano ja, Jises leheya iri lau an kapa gwa li Galili. Iri lau solo-an labai atukum ta anuhun iy, eme iy sandroh in ndron ra-ei ma manyah udu bolo ndron ere bwele-e gwa, ya iri lau mari nane dah, an kapa gwa amik ai. ");
INSERT INTO lid_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eme iy asehek sahou solo-an i tiri na sahou sokek, eme udu bolo leheya tan, iy tiye i tiri i buku doh, ");
INSERT INTO lid_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Aha kanuhun! Ndramak ari ili sabara badu wit ili bolo bilin, ");
INSERT INTO lid_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ya eme iy akeh ili, badu wit ra-on taku in san, ya iri sirih ame aniy. ");
INSERT INTO lid_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ra-on ja taku in bwele-e bek, ndren solo-an mwe-en bwe, ma badu wit ateh suwi. ");
INSERT INTO lid_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Arile, an anya eme loken nyarahan boto-on labai, ma sulumwi wit nane, tasah kandron bala bolo munyak alih bwe, eme ma iy ame-er mara-ei ma imek. ");
INSERT INTO lid_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ya badu wit ra-on ja taku in bolo bada malou bobodon. Bada malou bobodon nane ateh eme loken, ma tubuluhi wit nane ma iy bato-ou buwan bwai. ");
INSERT INTO lid_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Arile buwa wit ra-on taku i bolo ndren mwasin, ma iy ateh i tinan ma iy ato-ou buwan solo-an labai. Eme buwan ra-on ato-ou tonoh (30), ya ra-on ato-ou ndro hanoh (60) ma ra-on ja ato-ou rinek (100).” ");
INSERT INTO lid_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ano, Jises isan sendrehendreh ta sahou i buku doh, “Ou are lau ndranyem udu aliy, ou anuhun kamwenen.” ");
INSERT INTO lid_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Eme ma lau solo-an aseker, ano Jises le ari, ma hawe lau ra-on badu bolo oro nane ma hawe oro lau tan anuhun, ma oro ndremenya Jises ta saba moson handru ta sahou sokek nane ndra-au. ");
INSERT INTO lid_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Eme iy tiye i toro, “Kindrei aseken ado lau tek katanan iri sahou mene aton ta nyala tondrok ta Kindrei. Arile iri rayah bare hawe to dah bwe, jo asehek i san ta sahou sokek, ");
INSERT INTO lid_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","‘Iri kameh anuhun sahou san solo-an, arile iri kameh winiya bala tanan kati sahou handru bwe. Iri kameh anyolom san solo-an, arile iri kameh winiyan baseleyani ari lakou bwe. Koro-an iri katubuni ndrine iri ja ma Kindrei kameh sikine lomondra ndra-in tiri iu.’” ");
INSERT INTO lid_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Eme Jises ndremenya oro, “Budon tado kede-eh aleu ta sahou sokek dah deh bwe? Ki buku sah kameh budon tado kaleu ta sahou sokek mara-ei? ");
INSERT INTO lid_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ndramak ta sabara buwa kei doh, i buku ndramak ta atiye sahou ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","San rayah, sahou ta Kindrei taku in san. Ya iri lau doh anuhun. Arile, Satan eme ja, sokosowei sahou mwasin nane Kindrei tahiy ereu budon tiri. ");
INSERT INTO lid_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Lau rayah i buku none buwa wit taku in bwele-e bek. Ya eme suwi labai iri anuhun sahou ta Kindrei ma sekesek le, ");
INSERT INTO lid_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","arile bala ndrine iri handru bwe ma bare gwek luluwen bwe. Ya i buku none ndrine sen asahan deh bwe-em ndra-i asahan, tasah ta sahou ta Kindrei, ya idah kameh, suwi suwi iri taku. ");
INSERT INTO lid_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Lau rayah ja, i buku none buwa wit taku in ndrokowa bada malou bobodon. Idoh i buku none iri anuhun sahou ta Kindrei, ");
INSERT INTO lid_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","arile iri abudon boto-on labai ta lakou solo-an badu kon munyak. Ya iri abudon boto-on labai ta atukum iri luk, ma iri lakou ra-on ja. Ya idoh sokei sahou ta Kindrei, eme ma bwidi iri bato-ou sali iri bwe. ");
INSERT INTO lid_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ya lau rayah ja, i buku none buwa wit ateh in munyak mwasin. Iri anuhun sahou ta Kindrei, eme iri tawiy ma iri ato-ou sali iri. Rayah asahan tonoh (30), rayah ndro hanoh (60), ma rayah asahan rinek (100).” ");
INSERT INTO lid_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Eme Jises asehek le ili, “Ndramak ari iy telemei sun, iy winiyan batehei bado bahandra bwekei bwe, ma iy ale winiyan batehei bala bahandra sau bwe le, arile iy kameh atehei udu ndrahunen loken. ");
INSERT INTO lid_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lakou mari aton kede-eh kameh eme lewan, ya saba lakou tubuluhiy kameh andrei lakou ta tubuluhen iu. ");
INSERT INTO lid_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ou anuhun, i buku ndranyem udu aliy, ou anuhun kamwenen!” ");
INSERT INTO lid_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Eme Jises tiye i tiri, “Ndranyem kirih ki ta sahou ou anuhun! Saba maha-an ou amekes i tiri, kameh i le buku maha-an ou akohok. Eme kameh, ou akohok maha-an solo-an labai ja i hawen. ");
INSERT INTO lid_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Are ndramak tanan tan mwasin udu aliy, iy kameh akohok tanan mwasin labai ja i la-un. Ya ndramak tanan tan sese le, tanan tan sese le doh kameh kuhiy mari iu.” ");
INSERT INTO lid_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Eme Jises asehek ili le, “Ya tondrok ta Kindrei i buku none ndramak sabara buwa kei ili bolo bilin. ");
INSERT INTO lid_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Iy amadin na ben ma amak na len, eme buwa kei ateh, arile iy bala tanan bwe, i buku sah handru ateh. ");
INSERT INTO lid_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Munyak le anyohan buwa kei ateh ma edeu salin. Ma mwena handru iy i tinan ano, nyandren asahan ano ja, buwan asahan. ");
INSERT INTO lid_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Len ta buwa kei uni badeh, ndramak andrei samen ili isan, tasah len ta akohok badeh, ndrano.” ");
INSERT INTO lid_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Eme Jises ndremenya, “Taha kasehek tondrok ta Kindrei kameh ki buku sah handru? Saba sahou sokek taha kasehek kaleu? ");
INSERT INTO lid_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tondrok ta Kindrei i buku none buwa kei ari iri aloh mastet. Badun badeh, nadu bwisik labai udu bolo munyak idah. Ndramak andrei, iy ili tahiy i bolo munyak. ");
INSERT INTO lid_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ano, ateh eme loke ma i tinan sakalawi ja iri buwa kei badu bolo bilin. Iy asahan buku ra-ei kei ma edeu andran. Eme iri sirih winiyan ame amekes ndrahu iri ta aton.” ");
INSERT INTO lid_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ya eme Jises asehek sahou i tiri lau na sahou sokek solo-an i buku le doh, iy tiye san solo-an handru winiya iri akohok amwenen. ");
INSERT INTO lid_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Iy asehek i tiri na sahou sokek le, arile iy le ma hawe oro lau tan le ja, iy asehek moso sahou marakon i toro. ");
INSERT INTO lid_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na len mirihik ta kon akoroh, Jises tiye i toro lau tan i buku doh, “To ka-au kala kapa gwa bilisiu.” ");
INSERT INTO lid_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Eme iri lau marakon an gwek, oro suni Jises i hawe oro, ya ndron ra-on ja a hawe oro ale. ");
INSERT INTO lid_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Eme laba siyer atohou ya bayau i tinan, eme ndron bokobwak, bayau eme ndron, ndrai idih, ya mirihik ndron anya katuh. ");
INSERT INTO lid_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Arile, Jises amadin in bada sau hamon ta ndron, eme oro ala mete-ei iy, ma oro tiye i tan, “Ndramak ta leheya, ou batikisi to bwe nadeh? I buku to kamak?” ");
INSERT INTO lid_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Eme iy amak eme loke, ma iy asehek sahou i ta siyer ma bayau anya, “Ou amondrei! Bahun ka-iy ai!” Eme siyer ma bayau amondrei ma gwa ndras ameres udu le udu. ");
INSERT INTO lid_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eme Jises tiye i toro, “Ado anoh tasah? Buku sah ado batehei budon tado ba-en tek bwe?” ");
INSERT INTO lid_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eme ma mani oro atur labai, ma oro ndremenya oro ari ari anya, “Iy are lau handru? Ya siyer ma bayau anuhun iy!” ");
INSERT INTO lid_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Oro ame asos kapa gwa li loboho kon tiri lau Gerasa. ");
INSERT INTO lid_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jises udu ndron eme andri le badeh, ndramak ari badu mada lek, malawin ndra-in udu bwele-en eme asahan hawen. ");
INSERT INTO lid_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ya ndramak nane dah ndrahu matinou tan badu mada lek ta lau amak, ya ari lau winiyan basawei iy bwe, sen winiyan bwe. ");
INSERT INTO lid_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","San solo-an aseu iy na sen ma sei i sakan, arile iy mindrindri sen amendreh, ma iy sekese-ei andra-i labai, ya ari lau iy boto-on, iy winiyan batawi iy bwe ale. ");
INSERT INTO lid_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ben len ben len, iy in mada lek ndrokowa mandrei anyar ma alim iy na bek. ");
INSERT INTO lid_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ya eme iy atou Jises i ndra len on, eme iy sakaliye ili taku udu katin ma atudun nyaran. ");
INSERT INTO lid_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Eme Jises tiye i tan, “Ou malawin ndra-in, ou ame len ta ndramak badeh.” Eme iy anyar bohon i tinan anya, “Jises Nadu Kindrei, ou anya amekes sasah keme tek? Jo tandrakan ta nyara Kindrei, ou samekes sisi-in same tek.” ");
INSERT INTO lid_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Eme Jises ndremenyani iy, “Nyaram are lau?” Eme iy anya, “Nyarak badeh, Solo-an, tasah aso nyaran bwe!” ");
INSERT INTO lid_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Eme ya iy asehek sahou ta tikisiy i ta Jises i buku doh, “Ou satikahei aso sa-au ta kon dah.” ");
INSERT INTO lid_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Eme ya bou rakou buruwen aimon nyamon an ka-u mandrei. ");
INSERT INTO lid_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Eme malawin ndra-in tiye sahou tikisiy i ta Jises anya, “Ou tikahei aso ka bwele-e bou.” ");
INSERT INTO lid_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Eme Jises tiye i toro, “Abo, ado ka-au.” Eme malawin ndra-in nane dah ame len ma a bwele-e bou. Ya kane oro bou doh, i buku none luwa (2,000), eme oro sakaliye are bwele-e mandrei ame andri ala bolo gwa li, ma oro amak. ");
INSERT INTO lid_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Eme ma lau ta atondrok iri bou doh atobwak au a kon tinan ma hawe a lokei asehek i tiri lau. Eme ma iri lau ame anyolom. ");
INSERT INTO lid_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iri ame hawe Jises ma iri anyolom ndramak nane malawin ndra-in mene udu la-un nane dah manyah udu andri ai. Iy ndratani kolau ma budon tan ndramwenen ja ai. Eme ma iri anoh. ");
INSERT INTO lid_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ya oro lau nane anyolom dah, ala asehek nyala iri ta ndramak mene, malawin ndra-in udu la-un badeh, ndramwenen ja, ma hawe bou. ");
INSERT INTO lid_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Eme iri tiye Jises ta iy ki-iu ki rasi ja ta loboho doh. ");
INSERT INTO lid_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Suniya Jises anya ki-iu kili bolo ndron, ya ndramak nane malawin ndra-in udu bwele-en eme tiye sahou tikisiy i ta Jises, ta iy anya ki hawen. ");
INSERT INTO lid_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Arile Jises bwalen, eme iy tiye i tan, “Ou a kon hawe lowam oro, ya ou asehek nyala oro ta lahou tinan Laban ndramesekei ndrawek tam, ma iy tikisi ou, ma iy mesekei ou ndramwenen ja.” ");
INSERT INTO lid_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ya eme ndramak nane dah, iu ili bolo kon ma ronoh udu loboho Dekapolis asehek ta nyala lahou tinan mene, Jises ndramesekei i tan, ya eme iri lau marakon lomondra solo-an. ");
INSERT INTO lid_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Eme Jises i ndron ja iu i kapa gwa bilisiu, eme ya lau solo-an labai, atukum ame le kapa gwa hawen. ");
INSERT INTO lid_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Eme ndramak ari ta atondrok asiu ta atukum tiri Juwis nyaran Jairus, iy atou Jises ma iy eme taku in katin. ");
INSERT INTO lid_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Eme Jairus tiye sahou tikisiy i tan i buku doh, “Naduk badih badeh, mirihik ta anya kimek ai, ou ame atehei minem ki tan ya iy kamak ja.” ");
INSERT INTO lid_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Eme Jises i hawen, ma hawe iri lau solo-an an hamon tan ala ale, ma awudi iy udu le alih. ");
INSERT INTO lid_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Eme ya badih ari udu aliy, sik ndra udu tan winiya jaha ma ronoh la-uh. ");
INSERT INTO lid_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iy ndrakahei luk sabe kolek ndra tiri lau ta anyumor ma amekes iy kamwenen, arile bwe, sik tan bamwenen se bwai. Ya iy akohok sisi-in kahis le, ma sik ja asahan boto-on le gwek. ");
INSERT INTO lid_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Iy ndranuhun nyala Jises bwena, eme iy sokohani iy i ndrokowa iri lau ili in hamon tan, eme iy tawi kiri awin ta Jises, ");
INSERT INTO lid_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","tasah iy anya, “I buku none jo katawi le kiri awin tan kameh jo amwenen ja.” ");
INSERT INTO lid_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Eme se nawin bwe, sik ndra tan iu ma ano mara-ei, eme iy atona bolo odan badeh, ndramwenen mara-ei. ");
INSERT INTO lid_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jises ndratanan boto-on tan ndrame len, eme iy tubuni madan i tiri lau marakon, eme ma iy tiye, “Are lau tawi awin tek?” ");
INSERT INTO lid_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eme oro lau tan anya, “Ou atou lau ahas badam badeh, i buku sah handru, ma ou tiye anya ja, ‘Are lau tawi jo?’” ");
INSERT INTO lid_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Eme madan ili eme, iy anya kasilah are lau nane amekes lakou doh. ");
INSERT INTO lid_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Eme badih nane dah tanan lakou nane asahan tan, eme iy inoh ma iy totoreh, ma iy morohani iy i andri kati Jises eme ma iy asehek sasah mene asahan tan. ");
INSERT INTO lid_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Eme Jises tiye i tan anya, “Nadu badih den, ou atehei budon tam handru in tek, ma mesekei ou asahan amwenen. Ou au ma ndrinem kamunum, tasah sik tam ndra-au ma ndrano mara-ei.” ");
INSERT INTO lid_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Eme iy asehek sahou kahis le, lau ra-on ado asiu ta Jairus ame tiye ta Jairus, “Nadum badih ndramak. I buku sah ou asehek sahou kahis i ta ndramak ta leheya badeh?” ");
INSERT INTO lid_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Eme Jises banuhun sahou toro bwe, eme iy tiye i ta Jairus, “Ou sanoh, budon tam handru ki-in tek.” ");
INSERT INTO lid_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Eme Jises bwalen ari lau sa-en hamon tan, arile Pita le, Jemis le hawe Jon nadu tine Jemis, oro le a hawen ala. ");
INSERT INTO lid_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Oro ame asos asiu ta Jairus, eme Jises atou iri lau ta kabek taya andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Eme Jises i bolon tiye i tiri, “I buku sah ado aden ma taya ndranyen? Nah kede-eh bamak bo-oh, iy amadin le oh.” ");
INSERT INTO lid_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Eme iri ehe-en iy. Arile iy tikahei iri ame len ta asiu, eme Jises hawe tama nah hawe tinen ma hawe oro lau tan le ala bolo asiu, nane iy nadu badih imek in aliy. ");
INSERT INTO lid_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eme Jises tawi minen ma tiye i tan i buku doh, “Talita kumi,” moson, “Nadu badih, jo tiye i tam, ou amak ame loke.” ");
INSERT INTO lid_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Eme se nawin bwe, nadu badih dah suri iy ma iy edek (jaha tan badeh, ronoh la-uh). Eme suwi labai mani oro atur. ");
INSERT INTO lid_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Eme Jises tiye sahou batanau i toro lau, ta oro sala sasehek ta ari ndramak ja ndri-iy, eme iy tiye i toro, “Ado kadeu nyamon ki nan.” ");
INSERT INTO lid_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Eme Jises iu i len ta kon nane iy udu aliy, eme iy iu ili kon tan amwenen, ma hawe oro lau tan ale ala hawen. ");
INSERT INTO lid_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Eme na bolo len ta amunyau, iy leheya iri lau an asiu ta atukum tiri Juwis. Eme lau solo-an anuhun iy asehek sahou, ma mani iri atur, ma iri ndremenya, “Iy ndramak kede-eh, iy akohok tanan doh badu heh handru? Aden! I buku sah iy amekes lahou tinan na minen! ");
INSERT INTO lid_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Taha tana taha, iy ndramak kede-eh ta atah asiu, ma iy nadu Mariya, nadu tine Jemis, Joses, Judas hawe Saimon, ya nadu tinen oro badih, are hawe to kada-ah, neh?” Oro asehek i buku doh, ma oro atehei kona oro i tan. ");
INSERT INTO lid_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Eme Jises tiye i tiri anya, “Iri propet ta atiye boho Kindrei, nyara iri tinan ereu kon mari. Arile ereu kati kon tan amwenen, ma ereu boho kamen tan amwenen, ma ndrokowa oro ndraye oro rabuk, iy asahan buku lau laleyah.” ");
INSERT INTO lid_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Eme Jises winiyan bamekes ari lahou tinan bareu kon dah bwai, arile iy le edeu minen i bwele-e iri le lau sik udu tiri, eme ma sik tiri iu. ");
INSERT INTO lid_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Eme Jises manin atur, tasah iri batehei budon tiri handru ba-en tan bwe. Jises leheya boto-on tan, arile oro lau tan bala tanan iy bala mwasin bwe (Kalan 6:6–8:21) Eme ma Jises iu ili kon ari ari ta leheya iri lau. ");
INSERT INTO lid_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Eme iy luhi oro lau tan ma ronoh la-uh ame hawen, eme iy tiye oro la-uh la-uh a se, ma eme iy suni oro au ala bolo kon mara-ei ta atiye sahou mwasin ili tiri mwan ma badih. Ma iy ale edeu boto-on i toro ta atikah iri malawin ndra-in iu. ");
INSERT INTO lid_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","9","Iy tiye sahou batanau i toro, ta oro winiyan akohok kandro le ta adek hawe oro, arile oro sakohok ari lakou sala hawe oro, lakou i buku jabi ramen, lakou i buku kohei ma luk, ndri-iy labai, ma ale sa-en ndrakali oro. Arile iy tiye i toro kasin le ku-i kati oro ya oro sasin awin la-uh. Oro kasin ari le ka-iy, ma hawe kandro ta lime oro. ");
INSERT INTO lid_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iy ale tiye i toro, “I buku none ado ala asahan rakon kon, ma iri lau badu kon doh atehei ado ala bolo ra-em asiu, ya ado ka-en le aliy kado gwek winiya le len ado anya ka-au kala kon rakon ja. ");
INSERT INTO lid_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ya, i buku none ado asahan rakon kon, ya iri lau badu kon doh basekesek ta akohok ado ala asiu tiri bwe, ma iri basekesek ta anuhun sahou tado bwe, ya buku ado anya ka-au, ado katuruhi kasu on ma ndren ta kati ado ki-iu, ya ado ka-au. Ya eme ta kalem doh iri kalomondra ta kandriyen ndra-in tiri.” ");
INSERT INTO lid_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jises asehek sahou ano, ya oro lau tan au ala atiye sahou tan i tiri lau mwan ma badih. Oro asehek i tiri i buku doh: “Aha katubuni kona aha kili tiri kandriyen ndra-in marakon taha, ma katehei budon taha kili ta Kindrei le ari.” ");
INSERT INTO lid_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ya, malawin ndra-in solo-an labai udu bwele-e iri mwan ma badih, eme ma oro lau ta Jises ame, abo gok ta atikah iri malawin ndra-in solo-an iu. Ma oro atah ndrelekei ta kei olip i bada iri lau abo sik ma iri amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Eme kabin Herot anuhun sahou nyala Jises ndraseker winiya le bolo kon. Eme iri lau ra-on anya, “Jon ta alomwa mene ndramak ja ereu bolo lek tan ndrame loken, eme ma boto-on tan bwena ndrame hamon ja, ya boto-on tan udu ta Jises, eme iy amekes lahou tinan.” ");
INSERT INTO lid_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Iri ra-on anya ja, “Iy Alaija,” ya iri ra-on anya ja, “Iy propet, i buku none le lau ta tiye boho Kindrei bwena ndra-au o-on.” ");
INSERT INTO lid_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot anuhun, ya iy anya ja, “Kede-eh Jon ta alomwa! Jo mene ndrasani batun, arile iy ndramak ja!” ");
INSERT INTO lid_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ya Herot bwena ndra-au o-on tiye iri tawi Jon ta alomwa, ma sawei iy ma atehei iy i bolo asiu lulik. Herot amekes doh, tasah iy mene sudi udu nadu tinen Pilip nyaran Herodiyas. ");
INSERT INTO lid_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Eme ma Jon tiye Herot anya, “Ou ndrandra-i tasah, ou sudi udu nadu tinem!” ");
INSERT INTO lid_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Eme Herodiyas badeh, tan losen in ta Jon ma iy anya kidi iy, arile iy udu bahandra tondrok ta Herot, ");
INSERT INTO lid_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ma Herot ale, inoh Jon, tasah Jon badeh, ndramak mwasin labai ta mada Kindrei, eme ma Herot badai iy bwe. Batun aso ta anuhun Jon, arile iy aso-ok ta anuhun iy labai ja. ");
INSERT INTO lid_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ya, madasan ta Herot kidi Jon asahan i buku doh: Eme len ta Herot mene tinen tuwi iy anya kasahan, eme ya iy iwer nyamon i niri lau tan badu bolo asiu hawe iri lau tinan ta bahun ma hawe lau batun badu Galili. ");
INSERT INTO lid_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Eme budon ndra-in ta Herodiyas asahan i buku doh. Eme nadu Herodiyas badih eme bolon idi mana, eme mesekei ndrine Herot hawe iri lau nane sekesek, ya eme kabin tiye i ta nadu badih bihin dah, “Ou aso-ok sasah handru? Jo winiyan atehei saba lakou i tam i buku ou aso-ok.” ");
INSERT INTO lid_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eme iy tiye ja, “Jo tandrakan ou, jo tiye sahou handru en, jo winiyan atehei saba lakou i tam i buku none ou ndremenya ta aliy i buku none ranah lakou jo atondrok jo winiyan atehei i tam.” ");
INSERT INTO lid_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ya eme badih bihin dah iu i manan, tiye i ta tinen, “Saba lakou jo katiye?” Eme tinen anya ja, “Jo aso-ok batu Jon ta alomwa.” ");
INSERT INTO lid_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Eme badih bihin dah iu i bolon suwi suwi ili hawe kabin ma tiye, “Jo aso-ok na le dah ou adai Jon ta alomwa ma ou atehei batun ki bolo raben bwekei, ya ou bwese-ei keme tek.” ");
INSERT INTO lid_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Eme sahou doh mesekei kabin tikisiy handru en, iy abudon ta iy nane ndratandrakan ereu mada oro kabin aimon nyamon hawen nane, ya iy bwalen akohok bwilima ta tobolowe sahou tan iy ndrasihidi ta nadu badih nane doh. ");
INSERT INTO lid_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Eme suwi labai iy suni ndramak ta bahun ari ili bolo asiu lulik mwetehei batu Jon eme. ");
INSERT INTO lid_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Eme iy andrei batun i bolo bwekei ma atehei i mine badih bihin dah, eme ma badih bihin dah atehei i mine tinen. ");
INSERT INTO lid_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Eme oro lau ta Jon anuhun, oro ame andrei bada kei, oro su-iy, ma ala ahi iy i lek. ");
INSERT INTO lid_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Eme oro aposel ame hamon ame hawe Jises, ma oro asehek nyalan ta lakou mari oro amekes. ");
INSERT INTO lid_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iri lau solo-an solo-an ame au ame au, eme Jises hawe oro lau tan badeh, ari len ta aimon nyamon bwe. Ya eme Jises tiye i toro, “To ka-au ka kon rasi ja kamunyau op.” ");
INSERT INTO lid_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ya eme oro le ala ndron ra-ei, ma oro au ala kon rasi sese len ja, lau aliy bwe. ");
INSERT INTO lid_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Arile, iri lau ra-on ndratou oro au, ma iri ndratanan, idoh oro le ai, eme iri lau badu kon tinan loboho doh adek a san loke ala mwena ta Jises oro lau tan, a kon nane oro anya ka aliy. ");
INSERT INTO lid_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Eme oro anya ka amik le badeh, Jises atou iri lau solo-an labai, ma iy tikisi iri, tasah iri badeh, a buku none sipsip, ari ndramak ta atondrok iri bwe, ma eme iy leheya iri ta lakou solo-an. ");
INSERT INTO lid_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ya mirihik kon anya keben ai, eme oro lau tan ame tiye i buku doh, “Mirihik kon eben ai, ma loboho dah mundrindriyou. ");
INSERT INTO lid_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ou tiye iri lau kede-eh ka-au kala kon mirihik ma ndrahu oro kasih noro nyamon ta aimon.” ");
INSERT INTO lid_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Arile, Jises tiye toro anya, “Ado kadeu niri nyamon.” Eme oro anya ja, “Jises, ou aseken aso kala kasilah sihine ndramak ta bun ma ndru la-uh ki se, ma kasih jabi ramen ma kanyohan oro?” ");
INSERT INTO lid_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ya eme Jises tiye i toro ja, “Ado kala kondrek. Jabi ramen tado sabe udu aliy?” Eme oro ala atou, ano oro tiye i tan anya, “Limeh jabi ramen hawe la-uh ni.” ");
INSERT INTO lid_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Eme Jises tiye oro lau tan kapwai iri lau dah, ma katiye iri kamanyah ka-en andri bada bwidiu. ");
INSERT INTO lid_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Eme oro apwai iri lau nane dah manyah an se, ra-on rinek (100) ado se ai, ra-on ja lomonoh (50) an se ai, i le buku doh. ");
INSERT INTO lid_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Eme Jises andrei jabi ramen ma limeh hawe ni ma la-uh dah, iy eme anyolom iu i loken bolo kandrah, ma iy edeu wurah i ta Kindrei. Ano iy boso-ei jabi ramen dah, ma iy edeu ili mine oro lau tan. Eme oro ala adeu ili winiya iri lau mari, ma Jises ale boso-ei ni ma la-uh ma oro adeu i le winiya iri ale. ");
INSERT INTO lid_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Iri mari aimon nyamon doh ma ndrine iri idih. ");
INSERT INTO lid_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ano oro lau tan bwese tikibwah tiri erah i bwak ma ronoh la-uh. ");
INSERT INTO lid_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ya kane lau mwan mara-ei aimon jabi ramen nane dah ma lamawa (5,000). ");
INSERT INTO lid_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Suwi suwi Jises tiye oro lau tan kasandroh kala bolo ra-ei ndron, ma oro kasowe kala bwena kala kapa gwa Betsaida bilisiu. Ya iy le kameh udu hamon ta atiye iri lau ka-au. ");
INSERT INTO lid_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iy tiye iri lau au, ano iy iu ili bwele-e mandrei ta iy kasolom. ");
INSERT INTO lid_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Eme kon a beyeh, ya ndron toro lau tan udu le alih ta gwa li, Jises lebai le in ndra amik kahis. ");
INSERT INTO lid_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Eme iy atou oro lau tan ndrawoyah ta abahau, tasah jor atohou boto-on i bada ndron toro. Mirihik boho len, Jises edek bwele-e gwa ili hawe oro. Iy anya kedek ki bwena toro, ");
INSERT INTO lid_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","arile, oro atou iy edek bwele-e gwa eme oro anya, “Nyam! Nyam!” Eme ma oro anyar, ");
INSERT INTO lid_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tasah oro mari anyolom iy, ma oro anoh andra-i labai. Arile, Jises aloh i toro suwi i buku doh, “Ndrine ado kamunum! Jo, jo! Ado sanoh!” ");
INSERT INTO lid_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Eme iy i ndron hawe oro ma jor amondrei, eme oro lau tan badeh, boho oro asak, ");
INSERT INTO lid_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","tasah budon toro baleu ta jabi ramen mene moson i buku sah, bwe, ma budon toro ale ndraso. ");
INSERT INTO lid_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Eme oro ala bilisiu, ma oro asos loboho kon Genesaret, eme oro sawei ndron toro i hanai udu ai. ");
INSERT INTO lid_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Oro are ndron ame loken le badeh, iri lau seleyani Jises. ");
INSERT INTO lid_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ya eme iri lau badu loboho doh sakaliye ame ma atiye iri lau abo sik an bada nyahan ame hawen, eme iri anuhun Jises udu heh, iri ala le ai. ");
INSERT INTO lid_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Eme Jises ili heh ili heh, ili kon bwisik, ili kon tinan, ili kon lokei, eme iri tiyani iri lau sik udu tiri ala ndrahu baen, ya ndremenya Jises boto-on labai ta iy kalelei iri katehei le mine iri kili kiri awin tan. Eme iri lau mari nane ateu awin tan, iri asahan amwenen ja. ");
INSERT INTO lid_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Eme iri lau ra-on ta leheya kandriyen tiri Juwis, iri badeh, ado Jerusalem ame hawe iri Parasi, atukum ame hawe Jises. ");
INSERT INTO lid_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ya iri ndratou oro lau ra-on ta Jises aimon nyamon, ya oro basikine mine oro bala buku none kandriyen tiri Parasi bwe. ");
INSERT INTO lid_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Tasah iri Parasi ma hawe iri Juwis mari badeh, winiyan baimon nyamon bwe, i buku none iri basikine mine iri bwena bwe, tasah iri an hamon ta kandriyen ta tubu iri. ");
INSERT INTO lid_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ya i buku none iri are baen ame, ya nyamon badu baen iri winiyan baimon bwe, i buku none nyamon basikine bwe. Iri badeh, an hamon ta kandriyen solo-an labai, i buku none san ta sikine bwiniu ma kun hawe kun kaba ma hawe sau. ");
INSERT INTO lid_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ya eme iri Parasi ma hawe iri lau ta leheya kandriyen tiri Juwis ndremenya Jises i buk doh, “I buku sah oro lau tam aimon nyamon ya oro basikine mine oro bwe, ya oro ba-en hamon ta kandriyen ta tubu ahi iri bwe?” ");
INSERT INTO lid_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Eme Jises tiye i tiri, “Amwenen handru i buku none propet Aisaya ndratiye nyala aha! Aha asehek na boho aha le, i buku none iy ndratorowenei, ‘Iri lau mwan ma badih dah bwese nyarak eme loken na boho iri le, arile ndrine iri ereu len labai. ");
INSERT INTO lid_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Iri asehek sahou batanau ta lau le, arile iri anya, “Idah sahou ta Kindrei.” Idoh ya iri asolom laleyah eme tek.’” ");
INSERT INTO lid_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Eme Jises anya, “Aha ndraruwani kandriyen ta Kindrei, eme aha an hamon ta kandriyen tiri ndramak.” ");
INSERT INTO lid_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Eme ja iy tiye i tiri, “Batu aha ndrala labai, ya eme aha baseken batanau ta Kindrei bwai, eme ma aha tawi kandriyen taha le. ");
INSERT INTO lid_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses mene ndratiye, ‘Ou a-en bahandra tamam uru tinem, ma ou anuhun sahou turu,’ ma, ‘Are lau aluhe taman uru tinen, iy kimek ta aliy.’ ");
INSERT INTO lid_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Arile ado Parasi ma ado lau ta leheya kandriyen tiri Juwis tiye i buku doh, ‘I buku none ari ndramak luk tan ta aseben taman uru tinen, arile iy tiye turu i buku doh, “Luk jo anya kaseben ah na aliy badeh, Korban (moson ta aliy, ndraleheyani ta adeu i ta Kindrei).”’ ");
INSERT INTO lid_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ya, ta san doh ado baseken iy baseben taman uru tinen bwe. ");
INSERT INTO lid_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ta kandriyen doh le ado atehei sahou ta Kindrei i andri mara-ei, ma hawe lahou ra-on ja badu hawen, ya ado bwese-ei iri kandriyen solo-an ado akohok ta tubu aha iri ja eme loken mara-ei.” ");
INSERT INTO lid_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Eme Jises aloh iri lau mwan ma badih a hawen ja, ya eme iy tiye tiri i buku doh, “Aha mari kanuhun jo, ma aha kabudon kamwenen. ");
INSERT INTO lid_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Saba lakou badu manan i bolo boho ari ndramak, badeh winiyan bamesekei iy bandra-i bwe. Arile lakou udu bolo bohon eme len idoh kameh, mesekei ndramak andra-i adeh.”  ");
INSERT INTO lid_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“I buku none are ndramak ndranyen udu aliy, badeh iy kanuhun!” ");
INSERT INTO lid_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ano iy ruwani iri lau ma iy ili bolo asiu, eme ma oro lau tan ndremenya iy ta sahou sokek nane. ");
INSERT INTO lid_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Eme ma Jises tiye i toro, “Buku sah? Ado ale budon tado baleu bwe le? Sebwe ado tana ado bwe, sasah udu manan i bolo ndramak, badeh winiyan bamesekei ndramak bandra-i bwe, ");
INSERT INTO lid_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tasah idoh winiyan bala budon bwe, arile ili ndrabai ano ndramak iu akeh ili sareu.” (Eme sehek ta aliy, Jises anya, nyamon mari mwasin ta aimon le ai.) ");
INSERT INTO lid_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Eme Jises asehek ili le, “Saba lakou ala udu bolo boho ndramak eme len, lakou don adeh, mesekei ndramak andra-i. ");
INSERT INTO lid_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lakou ala udu bolo budon ta ndramak eme len, ma lolowa ndramak amekes lomondra ndra-in. Lakou buku none, kandriyen mari ta karei, kandriyen ta bahana, kandriyen ta adai ndramak imek, ma kandriyen ta amekes tasou andra-i. ");
INSERT INTO lid_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ya i buku none kandriyen ta madalakis ta lakou ta ndramak, ya kandriyen ta ramwes, kandriyen ta wendreya l au, kandriyen ta aten lau, kandriyen ta atudun nyaram, ma hawe kandriyen ta nyaladan. ");
INSERT INTO lid_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Iri kandriyen mari doh badu bolo ndramak eme len ma mesekei ndramak andra-i adeh.” ");
INSERT INTO lid_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ano Jises suri iy ma iy iu ili loboho kon tinan Tair ma Saidon. Eme ya iy i bolo asiu ra-em. Eme Jises anya, iri sala tanan iy udu doh, arile iy winiyan batone iy bwai. ");
INSERT INTO lid_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Eme suwi labai badih ari anuhun nyalan, eme ya iy eme taku i andri kati Jises, tasah nadun badih badeh, malawin ndra-in udu la-un. ");
INSERT INTO lid_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Badih dah kandriyen tan badu Grik, arile iy badu Siroponisiya, eme iy lelen Jises katikahei malawin ndra-in udu la-u nadun badih keme len. ");
INSERT INTO lid_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Eme Jises tiye i tan i buku doh, “Kanyohan iri nah bwena op, tasah bamwenen ta ari lakou bwe, i buku none iri andrei nyamon tiri nah ma iri akahei i na nadu mwi.” ");
INSERT INTO lid_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Arile, iy tiye i ta Jises i buku doh, “Laban, ou asehek sahou handru. Arile iri nadu mwi an bahandra sau badeh, aimon kahu nyamon tiri nah.” ");
INSERT INTO lid_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Eme iy tiye i tan, “Ya ta sehek ta aliy, ou au ai. Malawin ndra-in nane udu la-u nadum badih badeh, ndra-au.” ");
INSERT INTO lid_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eme badih dah iu i kon, ma iy atou nadun ales in bada sau, ya malawin ndra-in badeh, ndra-au. ");
INSERT INTO lid_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ano Jises udu loboho Tair edek iu ili Saidon, ma iy edek ja ili loboho gwa li Galili, ano ili loboho kon ma ronoh udu bolo Dekapolis. ");
INSERT INTO lid_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eme iri lau ra-on tiyani ndramak ari ndranyen siu ma iy bohon bwe, eme oro ndremenya Jises katehei minen ki bwele-en. ");
INSERT INTO lid_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Eme Jises andrei iy udu bolo iri lau nane eme len, ya Jises sakaruk i kandro minen ma iy atehei i munu ndranye ndramak nane ma i bada kalimen ale. ");
INSERT INTO lid_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Eme Jises anyolom i kandrah ma ndrinen eden labai, eme iy tiye i ta ndramak nane dah, “Epata,” moson ta aliy i buku doh, “Ou asak!” ");
INSERT INTO lid_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Se nawin bwe, ndranye iy ndramak dah asak ma kalimen nyokolokon ma iy asehek sahou amwenen mara-ei ja. ");
INSERT INTO lid_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ano Jises tiye sahou batanau i toro anya, “Ado sasehek sala ta ari ndramak.” Jises tiye i toro san solo-an solo-an, arile bwai, oro asehek le ili ai. ");
INSERT INTO lid_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Eme iri anuhun, ma mani iri atur. Eme iri tiye i buku doh, “Lakou mari iy amekes doh, ndra amwenen le ai. Iy mesekei ndramak ndranyen siu ma hawe bohon bwe, amwenen ja!” ");
INSERT INTO lid_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Udu bolo len doh iri lau solo-an labai atukum ame le hawen. Iri ado, ya iri nyamon ta aimon bwai. Eme Jises luhi oro lau tan ala hawen, ma iy asehek i toro i buku doh, ");
INSERT INTO lid_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Jo tikisi iri lau dah. Iri an hawek ndra winiya len taloh ai, ma niri nyamon ta aimon bwe. ");
INSERT INTO lid_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ya i buku none jo katiye iri ma son tiri ka-au ka kon tiri, kora-on mada iri kabuluw ya iri kataku kado san, tasah iri rayah mene ame, san tiri lawe-en labai.” ");
INSERT INTO lid_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eme oro lau tan anya, “Kon dah lau aliy bwe. Are lau kameh winiyan salahani niri nyamon udu bolo kon lomale an le dah?” ");
INSERT INTO lid_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Eme Jises ndremenyani oro, “Nado jabi ramen sabe udu aliy?” Eme oro anya, “Ndro taloh le.” ");
INSERT INTO lid_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Eme iy tiye i tiri lau mwan ma badih kamanyah kado andri bada munyak. Eme iy andrei jabi ramen ma ndro taloh dah, eme iy edeu wurah i ta Kindrei. Ano iy boso-ei ma atehei ili mine oro lau tan, ma oro adeu ili niri lau. ");
INSERT INTO lid_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Oro ale ni toro ra-on udu aliy, eme Jises asehek sahou ta nyosowan i ta aliy. Ano iy tiye oro lau tan adeu i le winiya iri. ");
INSERT INTO lid_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Eme iri aimon ma ndrine iri idih. Ano oro lau ta Jises tukumwi tikibwah tiri erah asahan i bwak ma ndro taloh. ");
INSERT INTO lid_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ya kane iri lau nane doh i buku hawa (4,000). Ano iy tiye iri lau mwan ma badih au ala hamon ala kon tiri. ");
INSERT INTO lid_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Eme Jises i bolo ndron ra-ei hawe oro lau tan ma oro au ala loboho kon Dalmanuta. ");
INSERT INTO lid_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ano iri Parasi ame ya andres hawe Jises. Iri anya kanone iy ma iri ndremenya iy kamekes kalem badu kandrah ta leheya buku none iy amekes gok ta Kindrei handru. ");
INSERT INTO lid_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Eme ya budon tan ihis in bolo ndrinen o-on, eme iy anya, “Ki buku sah handru iri lau mwan ma badih ta len dah anya katou kalem? Jo tiye tado handru en! Idah kameh kalem handru winiyan basahan tiri lau na len dah bwai.” ");
INSERT INTO lid_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Eme Jises ruwani iri Parasi areu, ma iy i ndron ma iu i len ili kapa gwa li bilisiu. ");
INSERT INTO lid_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ya oro lau ta Jises ndramaniy ta akohok jabi ramen, oro andrei rabah le i ndron. ");
INSERT INTO lid_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Eme Jises anya, “Mada ado kaleu ta yis tiri Parasi ma ta Herot.” ");
INSERT INTO lid_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eme oro tiye nyala oro ari ari, “Sebwe iy amekes sahou doh tasah to bakohok jabi ramen bwe nadeh?” ");
INSERT INTO lid_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Eme Jises tanan ta sahou nane oro asehek, eme iy tiye i toro, “Buku sah handru ado asehek, anya ado jabi ramen bwe? Sebwe mada ado baleu bwe le nadeh? Bar tado boto-on? ");
INSERT INTO lid_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ado mada ado udu aliy ya ado batou bwe? Ma ndranye ado udu aliy ya ado banuhun bwe? ");
INSERT INTO lid_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ado ndramaniy ja, ta jo mene boso-ei jabi ramen ma limeh i niri lau ma lamawa (5,000) mene deh bwe? Ya bwak sabe mene erah ado andrei?” Eme oro anya, “Ma ronoh la-uh.” ");
INSERT INTO lid_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ya ado ndramaniy ja ta jabi ramen ma ndro taloh i niri lau ma hawa (4,000), ma bwak sabe mene erah ado andrei?” Eme oro anya, “Bwak ma ndro taloh.” ");
INSERT INTO lid_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eme Jises tiye i toro, “Budon tado kede-eh baleu bwe le?” ");
INSERT INTO lid_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ano Jises hawe oro lau tan au ala asahan Betsaida. Eme ma iri lau ra-on sirini ndramak ari madan kaseu, ya oro tiyani iy eme hawe Jises. Ma oro tiye i ta Jises i buku doh: “Aso aso-ok ou atehei minem kili bwele-e iy ndramak dan op.” ");
INSERT INTO lid_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Eme Jises tawi mine ndramak madan kaseu nane dah ma sirini iy eme len ta kon. Eme Jises sakaruk i madan ma atehei minen i bwele-e madan, ma iy anya, “Ou atou ari lakou deh bwe?” ");
INSERT INTO lid_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Eme ya iy anyolom i loke ma iy anya, “Ehe, jo atou iri lau, iri a buku none kei adek ma seselek laleyah.” ");
INSERT INTO lid_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ano ja Jises atehei minen i bwele-e mada ndramak dah ja, ma ndramak dah madan atau i loke eme ma iy anyolom lakou amwenen mara-ei. ");
INSERT INTO lid_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Eme Jises anya, “Ou au ala asiu tam ya ou sala bolo kon.” ");
INSERT INTO lid_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Eme ma Jises hawe oro lau tan adek san anya kala loboho kon tinan Sesariya Pilipai, eme ya Jises ndremenya oro lau tan, “Iri lau anya jo are lau handru?” ");
INSERT INTO lid_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eme oro tiye i tan, “Iri ra-on anya ja ou Jon ta alomwa, ya iri ra-on anya ja, ou Alaija, ya iri ra-on anya ja, ou ari propet.” ");
INSERT INTO lid_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eme Jises ndremenya oro, “Ya ado amwenen anya jo are lau handru?” Eme Pita asumon bohon i buku doh, “Ou kede-eh Krais handru oh.” ");
INSERT INTO lid_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Eme Jises batanau oro satiye ta ari lau ja ai, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma iy leheya oro ta, Nadu Ndramak Awas kameh akohok sisi-in solo-an labai, ma iri lau tinan areu bwena, hawe iri lau tinan tiri pris, ma hawe iri lau ta leheya kandriyen tiri Juwis kameh baseken iy bwe. Ma idah kameh iri adai iy imek, ya len taloh ano iy kameh amak ja. ");
INSERT INTO lid_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iy asehek aleu amwenen i toro lau tan. Eme Pita anuhun sahou doh, ya iy seheyani Jises i kabwak, ma iy ibolosen i tan anya, “Ou sato-en sala buku badeh!” ");
INSERT INTO lid_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Arile Jises tubuni iy ma iy anyolom oro lau tan, eme ma iy to-en Pita anya, “Satan, ou a len a konak! Ou ba-en hamon ta budon ta Kindrei bwe. Ou a-en hamon le ta budon tiri lau.” ");
INSERT INTO lid_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eme Jises luhi iri lau solo-an solo-an ma hawe oro lau tan, eme ma tiye i toro, “Buku none ari ndramak anya ki-in hamon tek, mwasin, iy kamani so-ok tan mari, ya iy kabwese kei tondreh tan, ya iy ki-in hamon tek. ");
INSERT INTO lid_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tasah, buku none ari ndramak anya katawi kohan kudu, kohan kameh ano. Arile, buku none ari ndramak abudon jo ma atiye sahou mwasin tek, ya kohan ano, iy kameh winiyan andrei kohan ja. ");
INSERT INTO lid_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ya, buku none ari ndramak kuhi lakou mari badu kon munyak, ya iy kimek, iri lakou doh kameh sebenei iy i buku sah handru? ");
INSERT INTO lid_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ya lau kadeu saba sowan handru kameh ta akohok kohan keme hamon? ");
INSERT INTO lid_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ou are lau bwilim ama jo ma ta sahou tek udu bolo lau rebesem dah ta maliye Kindrei ma lomondra ndra-in, Nadu Ndramak Awas kameh bwilin ama ou ale, i buku none len hamon kameh, iy eme ma hawe lomada taman hawe iri angelo, lau ndrabun badu loken.” ");
INSERT INTO lid_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Eme Jises asehek i toro i buku doh, “Jo asehek sahou handru ewek tado. Lau ra-on ales ereu bolo to dah kameh winiyan bamak bwe, ya iri kameh anyolom tondrok ta Kindrei ma hawe boto-on tan kameh asahan.” ");
INSERT INTO lid_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Len onoh ano, Jises kuhi Pita, Jemis ma hawe Jon a hawen, ma Jises kuhi oro ala bwele-e mandrei ari loken labai, ya oro le ado aliy. Oro ado, oro anyolom ili bada Jises ndratubuniy ndra randrah ja. ");
INSERT INTO lid_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ma awin tan ndra nyikilikin asahan i belen ma sakalawi belen ta lakou mari badu munyak dah, i buku kasikine. ");
INSERT INTO lid_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eme oro lau tan ma taloh nane dah atou Alaija uru Moses asahan, ma asehek sahou hawen. ");
INSERT INTO lid_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Eme Pita atou lakou doh ya iy asehek ta Jises i buku doh, “Ndramak ta leheya, mwasin handru ta aso are ndra kada-ah, ya aso katahi taloh mandron kudu dah, ra-em tam, ra-em ta Moses, ma ra-em ta Alaija.” ");
INSERT INTO lid_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita asehek sahou doh, tasah iy hawe uru nane anoh, eme iy bala tanan sahou nane iy asehek bwe. ");
INSERT INTO lid_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Eme ma asi kandrah asahan ma tubuluhi oro, ya sahou ari asahan bolo asi kandrah nane asehek i buku doh, “Idah naduk handru. Jo aseken iy labai, ya ado kanuhun sahou tan.” ");
INSERT INTO lid_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eme suwi labai oro anyolom ili, ma oro batou ari lau hawe oro bwe, arile Jises le ari. ");
INSERT INTO lid_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eme oro are bwele-e mandrei ame andri, Jises batanau oro i buku doh, “Saba lakou ado ndratou ma ndranuhun, ado sasehek sala ta ari ndramak, ili winiya le Nadu Ndramak Awas amak ereu bolo lek tan eme loken.” ");
INSERT INTO lid_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eme oro basehek bwe, toro le, eme udu ndrokowa oro le, oro ndremenya oro ta saba moson, “Ta amak ta imek tan,” ma i buku sah handru. ");
INSERT INTO lid_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Eme oro ndremenya Jises i buku doh, “Buku sah iri lau ta leheya kandriyen tiri Juwis anya Alaija kameh eme bwena op?” ");
INSERT INTO lid_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Eme iy tiye i toro anya, “Sahou badeh, handru. Alaija eme bwena handru ta lowosa iri lakou mari. Ya i buku sah handru ja sahou mene torowenei anya idah kameh Nadu Ndramak Awas kameh akohok sisi-in solo-an ma iri kameh bwale iri iy? ");
INSERT INTO lid_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Arile jo asehek tado i buku doh, Alaija ndrame, arile iri an hamon ta budon tiri amwenen, ya iri amekes iri kandriyen mari i badan, i buku none ndratorowenei sihiden.” ");
INSERT INTO lid_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eme oro ame hawe oro lau ra-on ja ta Jises, eme oro anyolom lau solo-an solo-an awudi oro ma iri lau ta leheya kandriyen tiri Juwis ame andres hawe oro lau ta Jises. ");
INSERT INTO lid_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Eme nawin bwe, iri lau atou Jises ma mani iri atur ma iri sakaliye ala hawen ma sekesek ma anyumos badan. ");
INSERT INTO lid_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Eme ya Jises ndremenya oro lau tan, “Ado andres hawe iri ta sasah handru?” ");
INSERT INTO lid_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Eme ndramak ari udu bolo iri anya, “Ndramak ta leheya, jo atiye naduk eme hawem ai, tasah malawin ndra-in udu la-un, ya iy winiyan basehek sahou bwe. ");
INSERT INTO lid_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","I buku none asahan, malawin ndra-in kameh moraha iy i andri bada ndren, ma bubusi bohon eme len ma iy andrebek lihin ale, ma iy sorokok en. Eme jo tiye oro lau tam katikahei malawin ndra-in doh ki-iu, arile oro winiyan batikahei ba-au bwe.” ");
INSERT INTO lid_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Eme Jises tiye i toro, “Ado lau mwan ma badih batehei budon tado handru bame tek bwe. Len sabe kameh jo kereu hawe ado, ano ado barala tanan boto-on ta Kindrei? Ado katiyani nah badeh, keme hawek.” ");
INSERT INTO lid_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eme oro tiyani iy i hawen. Eme malawin ndra-in anyolom Jises, ma iy morohani nah dah i andri bada ndren ma iy tundrundru ma bubusi bohon atau. ");
INSERT INTO lid_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Eme Jises ndremenya tama i nah nane dah, “Malawin ndra-in udu la-un len sabe handru?” Eme iy anya, “Iy ma nadu bwisik le badeh, asahan ai. ");
INSERT INTO lid_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","San solo-an iy moraha iy i jih ma i gwa anya kamekes iy kimek. Ya i buku none saba lakou ou winiyan mesekei, ya ou tikisi aso, ma ou sebenei aso!” ");
INSERT INTO lid_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Eme Jises tiye i tan i buku doh, “I buku sah handru ou anya, i buku jo winiyan? Lakou mari winiyan asahan i tare lau i buku none budon tan handru in tek.” ");
INSERT INTO lid_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eme tama nah nane dah aloh, “Laban, jo badeh, budon tek sese le in tam, arile ou aseben jo ja ya budon tek handru ki tam.” ");
INSERT INTO lid_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eme ya Jises anyolom iri lau solo-an solo-an sakaliye a le se ame, eme iy tiye sahou boto-on i ta malawin ndra-in anya, “Ou malawin ndra-in, ou bohom bwe, ou ndranyem siu, jo tiye tam, ou ame len tan ma ou same hamon ja ai!” ");
INSERT INTO lid_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ano malawin ndra-in nane anyar ma iy morohani i nah dah i andri ma iy amei, eme ma malawin ndra-in nane udu bwele-en eme len, ya i nah mwan dah sorokok i buku none iy ndramak, eme iri lau solo-an anya ja, “Iy ndramak.” ");
INSERT INTO lid_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Arile Jises tawi minen, ma suri iy eme loken. ");
INSERT INTO lid_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Eme Jises iu i asiu, ma oro lau tan ndremenya iy anya, “Buku sah handru ya aso winiyan batikahei malawin ndra-in nane iu bwe?” ");
INSERT INTO lid_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eme iy tiye i toro, “Lakou i buku dah winiyan batikahei bame len na saba san ja bwe, arile na salom i ta Kindrei le winiyan ai.” ");
INSERT INTO lid_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Eme ma, Jises hawe oro lau tan ruwani kon doh ame len, ma oro adek ales au ala bolo Galili. Ya Jises bwalen lau sala tanan ta iy udu heh handru. ");
INSERT INTO lid_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tasah iy anya kaleheya oro lau tan, “Iri kameh atehei Nadu Ndramak Awas ili mine iri lau. Ya iri lau kameh adai iy imek. Ano len ma taloh ja kameh iy amak ja.” ");
INSERT INTO lid_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Arile budon toro baleu ta sahou tan nane bwe, eme oro anoh ta ndremenya iy. ");
INSERT INTO lid_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Eme oro ame asahan Kapena-um, oro ame ala ado bolo asiu ra-em. Eme Jises ndremenya oro lau tan, “Ado andres ta sasah nane an san?” ");
INSERT INTO lid_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Arile, oro batiye randra sahou bwe, tasah oro adek san doh, oro le andres oro, ta are handru udu bwele-en toro mari. ");
INSERT INTO lid_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Eme Jises manyah udu andri, ano iy luhi oro lau tan ma ronoh la-uh ame hawen, ano iy tiye i toro, “Are lau anya ki bwena badeh, iy ki-in ndrobek, ma iy ki ndrahu so-ok ta lau mari.” ");
INSERT INTO lid_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Eme Jises andrei nadu nah ari nadu bwisik eme ales ereu ndrokowa oro. Eme iy awudi iy na minen ya eme iy tiye i toro, ");
INSERT INTO lid_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ya buku none ari ndramak abudon jo, ya iy aseben ari nadu nah bwisik buku nah dah, badeh iy aseben jo. Ma are lau oro aseben jo, badeh, oro baseben jo le bwe, arile oro ale aseben Kindrei iy nane suni jo eme dah.” ");
INSERT INTO lid_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Eme Jon tiye i ta Jises, “Ndramak ta leheya, aso atou ndramak ari atikah malawin ndra-in eme len na boto-on ta nyaram, ya eme aso anya kabarah iy, tasah iy badu hawe to bwe.” ");
INSERT INTO lid_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Eme Jises tiye i toro, “Ado sabarah iy, tasah are lau amekes lahou tinan na boto-on ta nyarak, suwi labai iy winiyan batiye ndra-in ta nyarak bwe. ");
INSERT INTO lid_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ya are lau tan bahun tato bwe, iy badeh, kawas tato ma iy badu hawe to. ");
INSERT INTO lid_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jo tiye tado handru! Are lau atehei bwiniu gwa i wa-im, tasah ou badu hawe Krais, sihine i lau doh winiyan ba-au laleyah bwe. ");
INSERT INTO lid_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Buku none ari ndramak bwidi ari nadu nah ale atehei budon tan eme tek taku ta kandriyen ndra-in, sebwe mwasin ta ndramak doh kasawei ari bek maha-an ki balen ya kakahei iy katuh kili bolo ndras ki-in gwek kimek. ");
INSERT INTO lid_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ya i buku none minem aliu ou ta amekes kandriyen ndra-in, mwasin ou saniy ki-iu! Sebwe mwasin ta minem raka le ka-iy ta akohok koham mwasin ta ereu le buku doh. Kora-on minem ma la-uh udu aliy, ya ou kameh ala bolo jih ta winiyan bamak bwe! ");
INSERT INTO lid_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ya, i buku none katim aliu ou ta amekes kandriyen ndra-in ou saniy ki-iu! Sebwe mwasin ta katim raka le ka-iy ta akohok koham mwasin ta ereu le buku doh. Kora-on katim ma la-uh udu aliy, ya iri kakahei ou ala bolo jih ale ta winiyan bamak bwe! ");
INSERT INTO lid_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ya, buku none madam aluwi ou ta amekes kandriyen ndra-in, sebwe mwasin ta ou holowaniy ma kakahei ki-iu! Mwasin ta madam ari le ka-iy, ya ou ala bahandra tondrok ta Kindrei, kora-on madam ma la-uh kudu aliy, ya iri kakahei ou ala bolo jih ta anya ereu le buku doh. ");
INSERT INTO lid_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ya bolo jih doh, ‘Iri nadu un aimon iri lau ndramak, ya iri winiyan bamak bwe. Ma jih asun iri lau ndramak ale winiyan bamak bwe.’ Iri lau ndramak ado bolo jih doh kameh akohok sisi-in solo-an ndra-in ta udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Lau marakon kameh asah i buku none ndras hawe jih. Jih badeh, i buku none sisi-in ta leheya kandriyen ta ndramak mwasin, ya ndras i bolo nyamon badeh, ta amekes nyamon i simidin. Eme ma aha marakon kandrei sahou ta Kindrei ma katehei ki buku ndras kudu bolo oda aha, ma iy kameh winiyan atisih iri kandriyen ndra-in. ");
INSERT INTO lid_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ndras mwasin, arile i buku none iy mani nyiminyen, ya idah kameh ou baramesekei nyiminyen barame hamon barala buku sah bah? Ou badeh, i buku ndras ki-in bolo odam ya ndrinem kamunum ki ta ndramak ari ari.” ");
INSERT INTO lid_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Eme ma Jises hawe oro lau tan ruwani kon Kapena-um, ma oro au ala loboho kon Judiya ereu kapa gwa Jodan bilisiu. Eme ma iri lau solo-an solo-an atukum ame hawen ja, ya eme i buku none kandriyen tan ala iy ndramekes ndramekes ndra-au, eme ma iy leheya iri. ");
INSERT INTO lid_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eme iri Parasi ame hawe Jises anya kanone iy. Eme iri ndremenya iy, “Sebwe sahou batanau tataha anya, ndramak winiyan atikah udun iu deh bwe?” ");
INSERT INTO lid_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Eme Jises tiye i tiri anya, “Moses mene batanau sasah handru i taha?” ");
INSERT INTO lid_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eme iri anya, “Moses tiye tahi anya ndramak winiyan atorou la-ukei ta amendren tasou, ya iy atehei i mine badih tan ano iy winiyan aruwe badih tan iu.” ");
INSERT INTO lid_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Eme Jises tiye i tiri i buku doh, “Batu ado boto-on labai, eme Moses torowenei batanau i taha. ");
INSERT INTO lid_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Arile, bwena handru kala Kindrei mene ‘mesekei lakou mari, iy mesekei lau mwan ma badih.’ ");
INSERT INTO lid_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ta katin le doh, iy mwan karuwani taman uru tinen ya iy keme len hawe udun, ");
INSERT INTO lid_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ya uru kasahan ari buruwen.’ Kindrei asehek anya, bada uru la-uh bwai, bada uru ndrasahan ari le buruwen. ");
INSERT INTO lid_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Idoh le, saba lakou Kindrei ndrasawei mari ndrase, ari ndramak sasaniy ja ai.” ");
INSERT INTO lid_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Eme oro a hamon a asiu, oro lau tan ndremenya iy ta sahou mene. ");
INSERT INTO lid_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Eme Jises tiye i toro, “Ndramak tikahei udun iu ya i buku none iy sudi badih ari ja, iy le mesekei karei i tan. ");
INSERT INTO lid_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma ale i buku none iy badih tikahei udun mwan ya i buku none iy ili i tasou i ta mwan ari ja, badeh, iy mesekei karei i tan ale.” ");
INSERT INTO lid_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ano iri lau atiye iri nah ala hawe Jises ta iy kedeu minen ki bada iri. Eme oro lau tan abolosen i tiri. ");
INSERT INTO lid_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Eme Jises seleyaniy, ma iy ibolosen i toro lau tan, “Ado karuwani iri nah kame hawek. Ado saturuk iri, ndri-iy. Tondrok ta Kindrei badeh, tiri lau buku iri nah nadu bwisik kede-eh. ");
INSERT INTO lid_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Jo tiye sahou handru ewek tado. I buku ado basahan buku none iri nah bwisik bwe, ado kameh winiyan bala bolo tondrok ta Kindrei bwe.” ");
INSERT INTO lid_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Eme iy nyuruwini iri nah nane ame hawen. Iy atehei minen i bwele-e oro ari ari, ma asehek sahou ta nyosowan boto-on i tiri nah dah. ");
INSERT INTO lid_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Eme Jises anya kedek san anya ki-iu le badeh, ndramak ari sakaniy in hamon tan eme, aluh udu andri mada Jises, ma iy ndremenya iy, “Ndramak ta leheya, ou mwasin handru. Jo kamekes saba kandriyen handru ya jo kakohok kohan mwasin ta ereu le buku doh len mari?” ");
INSERT INTO lid_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Eme Jises tiye i tan i buku doh, “Tasah handru ou aloh jo mwasin handru? Ari ndramak badeh, bala mwasin i buku none Kindrei bwe, Kindrei le ari, kabwe. ");
INSERT INTO lid_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ou tanam batanau ta Kindrei, ‘Ou sadai ndramak samak, ou samekes karei ta badih tasou, ou sabahana, ou sawasai, madam salikis. Arile, ou a-en bahandra tamam uru tinem, ma ou anuhun sahou turu.’” ");
INSERT INTO lid_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Eme ndramak dah anya, “Ndramak ta leheya, jo ma loweu eme taku dah, jo in hamon ta sahou batanau mari le ai.” ");
INSERT INTO lid_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Eme Jises anyolom iy ndramak dah, ma iy tikisi iy, ma iy anya, “Lakou ari le kahis. Ou ala atehei iri lakou tam mari kili mada ba-en, ya luk ou akohok ta iri lakou tam nane ou adeu ki tiri lau tiri lakou bwe. Ou amekes i buku doh kameh ou tam lakou mwasin handru udu kandrah. Ano ou bara-en hamon tek.” ");
INSERT INTO lid_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ndramak dah anuhun, ma sa-ar asahan bwilin, ma iy tikisiy labai, tasah tan lakou solo-an labai, ma iy bwalen ta edeu iu, ya eme ma iy edek iu. ");
INSERT INTO lid_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iy ndramak nane ndra-au ai. Eme Jises anyolom ili eme, ma iy tiye i toro lau tan i buku doh, “Idah kameh boto-on labai ta ndramak tan lakou solo-an, i buku none iy anya kili bolo tondrok ta Kindrei!” ");
INSERT INTO lid_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Eme oro lau tan badeh, boho oro asak, tasah ta sahou iy asehek. Eme Jises asehek ili le, “Ado naduk, idah kameh boto-on labai ta ndramak anya kili bolo tondrok ta Kindrei! ");
INSERT INTO lid_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Masakan boto-on boto-on boto-on labai ta ndramak tan lakou solo-an ta iy ili bolo tondrok ta Kindrei, arile manamun labai ja ta kamel i buku iy i bolo manamunu nunu.” ");
INSERT INTO lid_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jises asehek, ma mani oro atur labai. Eme ma oro ndremenya iy, “Buku none i buku baden eh, are lau handru kameh winiyan akohok kohan mwasin ta ereu le buku doh?” ");
INSERT INTO lid_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Eme Jises anyolom amwenen i toro, ma iy anya, “Lau winiyan bwe, arile Kindrei badeh, bala buku aliy bwe. Kindrei le ari winiyan amekes iri lakou marakon.” ");
INSERT INTO lid_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jises asehek, ma Pita anya, “Ou atou, aso ndraruwani lakou taso mari, ya aso ndra-en hamon tam.” ");
INSERT INTO lid_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pita asehek i buku doh, ma Jises asehek i toro anya, “Jo tiye tado handru. Are lau ruwani asiu tan, ma nadu tinen mwan, ma buru-un, ma taman uru tinen, ma nadun, ma bilin tan tasah ta jo, ma ta sahou mwasin, ");
INSERT INTO lid_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","iy kameh akohok lakou solo-an handru na len dah. Iy kameh akohok ndramas buku san rinek (100) ja i bwele-e lakou tan bwena. Ndramas doh buku asiu solo-an ja, ma nadu tinen mwan solo-an ja ma buru-un solo-an solo-an ja, ma tinen hawe nadun ma bilin solo-an, ma ale hawe iri lau amekes ndra-in i tan ale. Arile len hamon, Kindrei kameh winiyan edeu kohan handru i tan ta winiyan bano bwe ta udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Arile lau solo-an na len dah areu bwena, iri kameh ame hamon. Ya iri lau solo-an na len dah areu hamon iri kameh kala bwena.” ");
INSERT INTO lid_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ano Jises hawe iri lau ado san adek ala Jerusalem, ma Jises edek iu i bwena tiri, eme ma oro lau tan mani oro atur, ma iri lau an hamon tan badeh, anoh. Eme Jises ma hawe oro lau tan ma ronoh la-uh a ka-un ya eme iy tiye nyala oro ta sasah kameh asahan badan. ");
INSERT INTO lid_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Eme iy tiye nyala oro i buku doh, “Ado kanuhun, na dah to ala loke ala Jerusalem, ma iri kameh atehei Nadu Ndramak Awas ili mine iri tinan tiri pris ma hawe iri lau ta leheya kandriyen tiri Juwis. Ya iri kameh atehei iy ili ta mada sahou, ma iri kameh atilik sahou i se ta kadai iy kimek, ma iri kameh adeu iy i mine iri lau badu leheleh. ");
INSERT INTO lid_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma iri kameh bobose iy ma omor iy ma a-um iy na malou sakabuk i bek ma hawe adai iy imek, arile hamon ta len taloh kameh iy amak ja.” ");
INSERT INTO lid_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Eme nadu Sebedi, Jemis uru Jon ame hawe Jises, eme uru tiye i tan, “Ndramak ta leheya, aru anya kandremenya ou, saba lakou aru ndremenya, ou mesekei keme taru.” ");
INSERT INTO lid_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eme Jises anya, “Saba lakou ah aseken jo kamesekei kewek ta-ah?” ");
INSERT INTO lid_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Eme uru tiye i tan, “I buku none ou aseken, aru anya kamanyah ka-en hawem, ari kamanyah kudu bilisiu minem salin, ya ari kamanyah kudu bilisiu minem kamweu kudu bolo lomadan tam.” ");
INSERT INTO lid_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Arile Jises tiye i turu, “Ah bala tanan ta saba lakou ah ndremenya kede-eh bo-oh! Sebwe ah winiyan a-un na bwiniu jo kameh a-un na aliy dah nadeh? Ya, sebwe ah winiyan anyu na inyu jo kameh inyu na aliy?” ");
INSERT INTO lid_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Eme uru tiye i tan, “Aru winiyan.” Eme Jises tiye i turu ja, “Handru, bwiniu kameh jo a-un na aliy, ah kameh a-un na aliy ale, ma inyu, jo inyu na aliy, ah kameh anyu na aliy ale. ");
INSERT INTO lid_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Arile, are kameh manyah ereu minek salin ma are kameh manyah ereu minek kamweu, idoh jo winiyan batiye bwai. Tasah kon doh tiri lau ale tama Kindrei ndralowosani iri kabwe.” ");
INSERT INTO lid_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ya eme oro lau tan ma ronoh anuhun sahou turu, oro anya kabolosen ki ta Jemis uru Jon. ");
INSERT INTO lid_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ano Jises luhi oro lau tan mari ame hawen ma iy tiye i toro i buku doh, “Ado tana ado, iri lau lomondra ta atondrok iri lau badu leheleh badeh, tiri boto-on ta atondrok iri lau tiri, ma iri badeh, batanau boto-on labai ta iri lau tiri kanuhun sahou tiri handru. ");
INSERT INTO lid_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Arile, kandriyen doh sa-en ndrokowa ado, ndri-iy. Ndramak anya ki tinan kereu ndrokowa ado, iy kasahan lau ta gok kereu ndrokowa ado. ");
INSERT INTO lid_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma are anya kereu bwena tado iy kasahan ndramak ta gok laleyah kereu ndrokowa ado. ");
INSERT INTO lid_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tasah Nadu Ndramak Awas ale eme ta iri lau kamekes gok tan, bwe. Iy eme ta aseben iri, ma ta edeu kohan ta akunoh lau mari.” ");
INSERT INTO lid_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ano oro ame Jeriko, ya Jises hawe oro lau tan anya ka-au ta Jeriko ma hawe iri lau solo-an solo-an. Eme nadu Timeyus nyaran Batimeyus, iy madan bwe, manyah udu ka-u san anyolou iri lau ta lakou. ");
INSERT INTO lid_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Eme iy anuhun, idoh Jises badu Nasaret le ai, eme iy aloh, “Jises, ou nadu tubu kabin Debit, ou tikisi jo!” ");
INSERT INTO lid_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Eme iri lau solo-an abolosen i tan ma tiye iy kandru-uk, arile bwai, iy aloh ma arah boto-on le gwek ai, “Nadu tubu kabin Debit ou tikisi jo!” ");
INSERT INTO lid_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Eme Jises udu rasi ma tiye sahou i tan i buku doh, “Ado kaluhi iy keme.” Eme ma oro luhi Batimeyus ma oro tiye sahou i tan i buku doh, “Ndrinem kamunum! Ou suri ou ma ou ame. Jises aloh ou!” ");
INSERT INTO lid_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eme Batimeyus suri iy ales i loken suwi suwi. Iy asini kolau ta bwele-en iu, ma ruwaniy udu api, ma iy edek amwenen ili hawe Jises. ");
INSERT INTO lid_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iy edek ili isos le badeh, Jises tiye i tan i buku doh, “Ou aso-ok jo kamekes sasah ki tam?” Eme ndramak madan kaseu dah anya, “Ndramak ta leheya, jo anya kanyolom kon ja.” ");
INSERT INTO lid_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Eme Jises tiye i tan, “Ou au ai, budon tam handru ndramesekei ou ndramwenen ja.” Eme ma nawin bwe madan amwenen ma iy anyolom ja ma iy in hamon ta Jises. ");
INSERT INTO lid_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Eme oro ame mirihik ta Jerusalem ya ame kon Betapes ma Betani udu loboho kesehe mandrei Olip. Eme Jises suni uru lau tan la-uh, ");
INSERT INTO lid_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ma iy tiye i turu i buku doh, “Ah kala kon to anyolom i aliy don. Suwi labai ah kameh atou nadu donki ari loweu, ari ndramak bamanyah bare bwele-en bwe le. Ya ah katolowei malou ma kasiriniy keme. ");
INSERT INTO lid_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","I buku none are lau kandremenya ah anya, ‘Ah abo sah kede-eh?’ Ah katiye ki buku doh, ‘Laban gok udu tan, ano iy baratiyaniy barame hamon ja!’” ");
INSERT INTO lid_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Eme uru au ma atou nadu donki badeh, iri sakabwitiniy udu ta kou udu alih ta san ili bolo kon, eme uru tolowei malou iu. ");
INSERT INTO lid_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Eme iri lau rayah ales are loboho doh ndremenya uru, “Hei, ah anya katalou donki badeh, ta sasah?” ");
INSERT INTO lid_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Eme uru tiye sahou nane Jises asehek i turu, eme oro tiye uru kandrei ma katiyaniy kili. ");
INSERT INTO lid_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Eme uru sirini donki ili hawe Jises, ma oro lau tan lowosani kolau toro lawe-en badu bwele-e awin toro i kona donki nane, ya Jises ili manyah udu bwele-en. ");
INSERT INTO lid_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Eme iri lau solo-an labai talou kolau tiri lawe-en badu bwele-e awin tiri ya iri talaha ili madasan. Ya iri ra-on badeh, ala asan la-u kei badu bilin ma anyehe i andri. ");
INSERT INTO lid_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Eme iri lau ra-on adek ala bwena ta Jises ma hawe iri ra-on adek an hamon badeh aloh i buku doh, “Hosana! Kasekesek iy! Kasore nyaran! Iy eme ta nyara Laban! ");
INSERT INTO lid_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Kasore tondrok ta tama Debit kameh, eme! Hosana! Kasekesek ki loken mara-ei!” ");
INSERT INTO lid_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Eme ma oro ala asos kon tinan Jerusalem. Ma Jises hawe oro lau tan ala bolo asiu tinan ta Kindrei. Ano oro anyolom ili eme i ta lakou mari. Arile, an anya kamai ki-iu ki andri ai. Eme ma oro ruwani Jerusalem ma adek au ala kon bwisik Betani, ma oro amadin doh. ");
INSERT INTO lid_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ya eme na len ari ja, oro are Betani ame len, ma Jises imeson andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Eme iy ere ndra len, iy atou kei pik ra-ei, suhuyen labai. Eme iy edek ili bada kei dah, anya katou buwa pik dah udu aliy deh bwe. Arile iy ili badeh, iy batou se ari bwe, laba le la-un, tasah bamwenen ta len ta buwa pik bwe. ");
INSERT INTO lid_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Eme Jises tiye i ta kei nane i buku doh, “Iri lau winiyan baimon salim ja bwai.” Eme oro lau tan anuhun sahou iy asehek. ");
INSERT INTO lid_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Eme oro ame Jerusalem ma Jises iu ili bolo asiu tinan ta Kindrei ya iy atikah iri lau amekes ba-en udu asiu doh. Eme Jises bukudi iri sau tiri lau ta tokoha luk, ma hawe bwabwai tiri lau asih iri sirih aloh ban. ");
INSERT INTO lid_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ya iy baseken are lau sabwese lakou sala bolo asiu doh, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Eme Jises leheya iri mwan ma badih, ma iy tiye i tiri, “Sebwe buk ndrabun ndratiye nadeh? Tiye i buku doh, ‘Asiu tek dah, ta lau mari badu munyak tinan mari ta salom,’ arile aha ndramesekei asiu tek, ndrasahan ‘asumwe iri lau ta bahana.’” ");
INSERT INTO lid_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jises asehek i buku doh, ma iri lau tinan tiri pris hawe iri lau ta leheya kandriyen tiri Juwis anuhun iy. Eme iri anoh iy, tasah iri lau mari boho iri asak ta leheya tan. Eme iri lomondra ta anya kadai iy. ");
INSERT INTO lid_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Len mara-ei Jises hawe oro lau tan amekes i buku doh: Kon a beyeh, oro adek are kon tinan au ala amadin a bolo kon bwisik. ");
INSERT INTO lid_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eme mandraben ta len ari ja badeh, oro adek anya kala hamon kala Jerusalem. Eme oro anyolom kei pik mene Jises asehek sahou i tan badeh, ndrasara mara-ei, udu ta la-un ili isos bada kandron. ");
INSERT INTO lid_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ya Pita, balen bamaniy bwe, eme iy anya, “Ou anyolom, ndramak ta leheya, kei pik mene ou tiye sahou boto-on i ta aliy, badeh, ndrasara mara-ei!” ");
INSERT INTO lid_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pita asehek i buku doh badeh, ma Jises tiye ili toro lau tan anya, “Ado kanuhun! Ado katehei budon tado handru badeh, kili ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Jo asehek sahou handru ewek tado, ou are lau asehek sahou i ta mandrei doh anya, ‘Ou suri ou ya ou sandroh ala bolo ndras,’ ma budon ta nohonoh sa-en ndrinem, arile budon tam handru ki-in ta lakou ou asehek, idah kameh asahan tam buku le ou nane ndratiye. ");
INSERT INTO lid_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ya ta sehek ta aliy i buku doh, sasah ou ndremenya i san ta salom, ya budon tam ki-in ta aliy handru i buku ou ndrandrei, idah kameh ou andrei handru. ");
INSERT INTO lid_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ya i buku none ou are ales ta salom badeh, ou badeh, balem kamani saba lomondra ndra-in ta bada are lau, ya idah kameh ou ale tamam Kindrei udu kandrah kameh sikine lomondra ndra-in tam iu.”  ");
INSERT INTO lid_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Arile, buku ou bamani lomondra ndra-in ta bada iri rayah bwe, tamam Kindrei udu kandrah ale kameh winiyan basikine lomondra ndra-in tam bwe ale.” ");
INSERT INTO lid_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Eme oro ame asahan Jerusalem ja. Ya eme iy edek ili bolo asiu tinan ta Kindrei le badeh, iri tinan tiri pris hawe iri lau ta leheya kandriyen tiri Juwis hawe iri lau-en badeh, ame hawen. ");
INSERT INTO lid_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Eme iri ndremenya Jises, “Ou akohok boto-on badu heh handru, ma ou amekes iri lakou kede-eh? Are lau atehei nyaran tinan ewek tam ma tiye ou ta amekes iri lahou dah?” ");
INSERT INTO lid_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ya eme Jises tiye i tiri, “Jo ale anya kandremenya aha ta lakou ari. Ano buku none aha tiye amwenen eme tek, sebwe jo kameh tiye ewek taha are lau handru atehei boto-on eme tek ta amekes gok dah. ");
INSERT INTO lid_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kala Jon mene alomwa iri lau, iy akohok boto-on badu heh? Lokou doh badu kandrah deh, badu kon munyak le? Aha tiye keme tek.” ");
INSERT INTO lid_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Eme iri andres udu ndrokowa oro le i buku doh, “Buku none to katiye anya, ‘Idoh lakou badu kandrah,’ idah kameh iy ndremenya to ja anya, ‘Buku sah handru ya aha batehei budon taha bala ta aliy bwe?’ ");
INSERT INTO lid_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Arile, buku none to katiye anya, ‘Idoh kandriyen tiri lau le,’ winiyan bwe nadeh?” Iri lomondra i buku doh. Iri anoh iri lau tasah iri lau anya, Jon badeh, propet ta Kindrei handru. ");
INSERT INTO lid_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Eme iri asumon boho Jises i buku doh, “Ahi tana ahi bwe.” Eme Jises tiye tiri i buku doh, “Jo ale jo winiyan batiye bawek taha ta are lau handru atehei nyaran tinan eme tek ya jo amekes iri gok dah bwe.” ");
INSERT INTO lid_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Eme ya Jises asehek sahou sokek i tiri i buku doh, “Ndramak ari badeh, bwidi bilin ari ta waen, ma iy bwidi kou awudiy. Ma udu bolo bilin tan nane doh, iy ihi lek ari ta atik ma apis buwa waen, ano iy tahi asiu ra-em ta atondrok bilin doh. Eme iy ruwani bilin ili mine iri lau salibah ta atondrok. Ma iy iu i kon rakon ja. ");
INSERT INTO lid_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Eme ya len ta abwe-eh buwa waen asahan, iy eme suni lohowan tan ari ili hawe oro salibah atondrok bilin waen nane dah, anya kakohok rayah buwa waen ki minen. ");
INSERT INTO lid_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Eme oro salibah ta bilin tawi iy ma adai iy, eme ma oro tikahei iy iu na luka minen ma luka katin. ");
INSERT INTO lid_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ano ja, iy suni lohowan tan ari ili hawe oro ja. Eme oro adai iy i batun, ma abolei iy andra-i labai. ");
INSERT INTO lid_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ano ja, iy suni lohowan tan ari ili ja. Eme oro adai iy imek, ma hawe iri rayah ja ale oro ubwiy, ma rayah badeh, oro adai imek. ");
INSERT INTO lid_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ano, ari le badu bolo oro erah ya idoh nadun amwenen, ya iy badeh, aseken iy labai. Eme tama bilin nane abudon buku doh, ‘Sebwe oro kameh anuhun boho naduk.’ ");
INSERT INTO lid_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Arile oro salibah ta bilin suburuk i toro ari ari i buku doh, ‘Ei, nadun eme, to kadai iy, ma to kakuhi iri lakou tan mari.’ ");
INSERT INTO lid_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Eme oro tawi iy, ma adai iy imek, ma oro akahei iy iu i len ta bilin. ");
INSERT INTO lid_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ya idah kameh tama bilin kamekes saba lakou handru? Iy kameh idi oro lau doh amak, ma iy kameh atehei bilin ili mine iri lau rayah ja katondrok ma kabo gok ta aliy. ");
INSERT INTO lid_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Handru labai, sebwe ado banyolom sahou doh ereu bolo buk ndrabun ta Kindrei bwe nadeh, sahou i buku doh, ‘Bek ale iri lau ta atah asiu bwale iri, na dah, iy ndrasahan kati ndru ta ka-u asiu bek. ");
INSERT INTO lid_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Idah san ta Laban amekes, ma mwasin labai ta mada taha.’” ");
INSERT INTO lid_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Eme iri tinan tiri pris hawe iri lau ta leheya kandriyen tiri Juwis hawe iri lau-en nane anya ja Jises asehek sahou sokek doh i bada iri. Eme ma iri anya kateu iy. Arile iri winiyan bwe, tasah iri anoh iri lau solo-an nane dah. Eme iri ruwani iy ma iri au. ");
INSERT INTO lid_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ano oro suni iri Parasi rayah hawe lau rayah ta Herot a hawe Jises ma ndremenya ta none iy na sahou. ");
INSERT INTO lid_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Eme iri ame hawen ma anya, “Ndramak ta leheya, ahi tanan, ou lau ta asehek sahou handru, ma ou banoh are ndramak bwe. Ya ou asehek sahou ari le ili tiri lau mari, buku ndramak nyaran tinan, deh, ndramak iy nyaran bwe, ya ou badeh, leheya san handru ta Kindrei. Ou abudon i buku sah? Mwasin ta taha kadeu takis ki ta Sisa, deh, ndri-iy?” ");
INSERT INTO lid_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Arile Jises badeh, ndratanan iri asehek sahou na boho iri le, eme ma iy tiye i tiri, “Buku sah handru aha anya kanone jo? Aha kaleheya keme tek ari luk bororoh ya jo kanyolom.” ");
INSERT INTO lid_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eme iri andrei ari ili minen, ya eme iy ndremenyani iri i buku doh, “Malawi ndramak ma nyaran kede-eh are lau handru?” Eme iri anya, “Ta Sisa.” ");
INSERT INTO lid_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Eme Jises tiye i tiri, “Mwasin, saba lakou ta Sisa, aha kadeu ki ta Sisa. Ya saba lakou ta Kindrei, aha kadeu ki ta Kindrei.” Ya eme boho iri asak. ");
INSERT INTO lid_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Eme iri Sadusi ame hawe Jises anya kanone iy. Oro anya, iri lau ale ndramak bwena mene, iri kameh winiyan bamak ja bwe. ");
INSERT INTO lid_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Eme oro ndremenyani Jises i buku doh, “Ndramak ta leheya, Moses bwena mene torowenei nyala taha anya, ‘Buku none ari ndramak imek, ya udun erah ya iy nadun bwe, nadu tinen kameh kandrei nyau tan ki udun, ya iy katehei nah ki tan, ma nah doh ki nyara nadu tinen, ya nyara nadu tinen sa-au, ndri-iy.’ ");
INSERT INTO lid_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Len ari bwena, oro lau ma ndro taloh, oro badeh, nadu tine oro. Eme kadok toro i tasou ta badih ari, eme ya iy imek ma iy nadun bwe. ");
INSERT INTO lid_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ano iy bwaneh sudi udun ja, ano bwaneh imek ma uru nah bwe le. Ano ja silih sudi iy ja eme i le buku aliy, iy imek ma uru nadu uru bwe le. ");
INSERT INTO lid_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ya eme oro ma ndro taloh amak, nah bwe le i buku aliy. Ano, udu hamon badeh, ma iy badih ale imek. ");
INSERT INTO lid_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ya, ou tiye taso. Na len hamon ta iri lau mari amak ame loken ja, badih doh kameh ili udu are lau handru? Ou tanam, iy i tasou ili toro ma ndro taloh nane doh.” ");
INSERT INTO lid_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Eme Jises tiye i tiri anya, “Aha ndrandra-i labai, tasah aha bala tanan tarou ereu bolo buk ndrabun ta Kindrei bwe. Ma aha tana aha boto-on ta Kindrei bwe ale. Eme ya ado asehek sahou laleyah. ");
INSERT INTO lid_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Na len iri lau ndramak kameh amak ame awas ja, ya iri kameh winiyan bala tasou ja bwe. Iri kameh asahan buku iri angelo areu kandrah. ");
INSERT INTO lid_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Handru labai. Iri lau ndramak bwena, hamon kameh iri amak ja. Sebwe aha banyolom ta tarou ta Moses bwe nadeh? Idoh asehek ta nyala len mene Moses atou jih anya udu ta kei. Eme ma Kindrei tiye i ta Moses i buku doh, ‘Jo Kindrei ta Abraham, ta Aisik, ma ta Jekop.’ ");
INSERT INTO lid_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Aha ndrandra-i kede-eh! Sahou doh leheya taha i buku doh: Kindrei atondrok koha oro ma taloh, ma oro ado awas ado hawen kahis le. Eme ma, Kindrei batiye anya iy mene Kindrei tiri lau ndramak, arile na dah, bwe. Bwe! Iy badeh, Kindrei tiri lau koha iri udu aliy kahis le. Eme ma aha andra-i kede-eh, tasah aha abudon anya, iri lau ale ndramak bwena mene, iri kameh winiyan bamak ja bwe.” ");
INSERT INTO lid_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Eme ma ndramak ari ta leheya kandriyen tiri Juwis eme bolo iri ma iy anuhun iri andres iri. Eme iy anuhun Jises asehek sahou i tiri ndra mwasin le ai. Eme ma iy ndremenya Jises i buku doh, “Saba sahou batanau badeh, tinan handru ma udu bwele-e iri sahou batanau mari?” ");
INSERT INTO lid_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Eme Jises anya, “Lakou laba tinan handru asah idoh, ‘Aha kanuhun, aha lau badu Isra-el, Laban badeh, iy le ari, iy Kindrei tataha. ");
INSERT INTO lid_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ya ou aseken Laban tam Kindrei na ndrinem mari, ma na koham handru mari, ma na budon tam mari, ma na boto-on tam mari.’ ");
INSERT INTO lid_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ya la-uh ta aliy ja asah idoh, ‘Ou aseken iri lau ari ari badu hawen, i le buku ou aso-ok ou le.’ Ya ari batanau ja badeh, winiyan basakalawi uru batanau ma la-uh dah bwai. Uru le badeh, maha-an ma udu bwele-en labai.” ");
INSERT INTO lid_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Eme ma iy ndramak nane dah tiye i ta Jises, “Handru labai, ndramak ta leheya, ou nane tiye handru. Ari Kindrei udu kede-eh ja bwai, iy le ari. ");
INSERT INTO lid_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma ou aseken iy na ndrinem mari, ma na budon tam mari, ma na boto-on tam mari. Ma ou aseken iri lau ari ari badu hawem, i le buku ou aseken ou le, idoh mwasin handru, sakalawi kandriyen ta asun lakou i buku salom i ta Kindrei, ma lakou adai i buku salom i ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Eme Jises anuhun ma iy asehek mwasin handru, eme iy tiye i tan, “Ou badeh, are mirihik labai ta tondrok ta Kindrei.” Ano, hamon ta aliy iri anoh ma iri bandremenya ari ndremenya bala tan ja bwai. ");
INSERT INTO lid_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jises udu ndra bolo asiu tinan ta Kindrei kahis, eme ma iy leheya iri mwan ma badih ta kandriyen ta Kindrei. Iy tiye tiri anya, “Ya aha kanuhun. Debit badeh, ndramak ndra bwena, arile, bolo len mari lundriyen oro badeh, asahan kahis. I buku sah handru iri lau ta leheya kandriyen tiri Juwis anya ja, Krais badeh, nadu Debit? ");
INSERT INTO lid_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Taha ndratanan, bwena mene Malawin Ndrabun atehei budon i ta Debit le tiye i buku doh, ‘Laban Kindrei tiye i ta Laban tek i buku doh: “Ou ame manyah ado loboho minek salin winiya jo le baratehei iri lau ta amekes budon ndra-in i tam barado bahandra katim.”’ ");
INSERT INTO lid_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ado kanuhun. Debit amwenen aloh ndramak nane Laban tan. Ya ki buku sah handru kameh iy ndramak nane ja ki nadu Debit?” Eme iri lau solo-an handru anuhun ma iri sekesek. ");
INSERT INTO lid_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jises leheya iri mwan ma badih kahis ma iy tiye tiri udu bolo leheya tan anya, “Mada aha kaleu tiri lau ta leheya kandriyen tiri Juwis. Iri aseken adek ala ame na kolau moroyan lawe tiri, eme iri anya lau mari kasumon iri na len ta baen. ");
INSERT INTO lid_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ya iri anya kamanyah kareu le bwabwai mwasin badu tukum tiri Juwis, ma ndrahu kon ta atudun ta nyamon tinan. ");
INSERT INTO lid_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iri bene-ei asiu ta badih nyau, ya iri wendreya ta aliu salom lawe-en lawe-en. Idah kameh iri lau buku doh kameh akohok maha-an laba tinan labai.” ");
INSERT INTO lid_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Eme Jises manyah udu mirihik ta ndrahune luk udu asiu tinan ta Kindrei, eme ma iy anyolom lau ala ame akeh luk i bolo lakou ta ndrahu luk nane dah. Iri lau tiri lakou solo-an badeh, akeh luk solo-an handru en. ");
INSERT INTO lid_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Eme ya badih nyau ari tan se lakou bwe badeh, eme akahei luk bororoh saraman ma la-uh le. ");
INSERT INTO lid_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Eme Jises luhi oro lau tan ame ma iy asehek i toro, “Jo katiye tado handru en! I badih nyau tan lakou bwe kede-eh, akeh luk solo-an labai ja tiri lau rayah kede-eh ja. ");
INSERT INTO lid_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tasah iri lau mari kede-eh akahei rayah le badu bolo luk tiri solo-an, arile iy badih nyau tan lakou bwe badeh, ndrakahei luk mari ta sukunyan ndrala.” ");
INSERT INTO lid_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Eme Jises udu asiu tinan ta Kindrei eme len le badeh, lau tan ari tiye i tan i buku doh, “Ou anyolom ndramak ta leheya, asiu amekes na bek tinan kede-eh, mwasin handru labai ma asiu mari kede-eh konen handru.” ");
INSERT INTO lid_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Eme Jises tiye tan i buku doh, “Ou anyolom asiu tinan tinan kede-eh deh? Ari ndruwi asiu bek kameh winiyan bales bareu loken bwe. Iri marakon kameh ato-oh iu i andri.” ");
INSERT INTO lid_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ya eme Jises manyah udu bwele-e mandrei Olip bilisiu ta asiu tinan ta Kindrei. Iy le ari udu ndra ndrahun, eme Pita ma Jemis hawe Jon uru Enduru ala ndremenya iy anya, ");
INSERT INTO lid_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ou tiye keme taso, na saba len handru kameh iri lakou doh kasahan? Ya saba kalem kameh kasahan bwena ta leheya lakou mari doh buku ndrame bakep?” ");
INSERT INTO lid_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Eme Jises tiye i toro i buku doh, “Ado kanyolom kamwenen, ya ari ndramak sawendreyani ado, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Iri lau solo-an kameh ame anya iri asehek sahou tek ma anya, ‘Jo dah Krais’ Ya iri kameh wendreyani lau solo-an. ");
INSERT INTO lid_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ya i buku none ado anuhun kurutuwe bahun ereu mirihik, ma yoyou ta bahun ereu len, budon tado sandra-i, ndri-iy. Iri lakou doh kameh asahan bwena op, arile lakou mari ta ano kameh kahis le. ");
INSERT INTO lid_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tasah, kon munyak tinan ari kameh amekes bahun i ta kon tinan ari, ya kabin badu kon rakon kameh amekes bahun i ta kabin badu kon rakon ja. Ma idah kameh kon ari ari kameh ndroi asahan aliy, ma son kameh asahan bolo kon. Iri lakou mari doh anya kasahan buku none sisi-in ta badih anya kato-ou nah. ");
INSERT INTO lid_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Arile, bale aha ki-in taha, tasah iri kameh ateu ado ma adeu aha a mine iri kansol ma atehei aha a ta sahou. Ya iri kameh ubwi aha an bolo asiu ta atukum tiri Juwis, ma aha kameh ales are mada iri lau ta atondrok ma hawe iri kabin. Iri amekes doh ta ado katiye sahou tek mwasin ki tiri ya iri marakon kanuhun ma katanan. ");
INSERT INTO lid_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Eme ma sahou mwasin badeh, katiye mwena op, ki tiri kon marakon. ");
INSERT INTO lid_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ya, i buku none iri atehei aha ka ta sahou, aha sabwerei ta saba sahou kameh aha kasehek. Arile, i buku none len ta aliy asahan, aha kameh asehek sahou Kindrei edeu ewek taha, tasah sahou aha asehek kameh sahou taha bwe, sahou ta Malawin Ndrabun labai. ");
INSERT INTO lid_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ya na len doh kameh ndramak atehei nadu tinen amwenen ili ta mada sahou, ya iy kameh edeu sa-oh tan. Ya tama iri ra-on ale kameh amekes buku aliy ili ta nadu iri. Ma iri nah ra-on kameh asahan lau ta bahun ili ta tama ma tine iri, ma iri kameh atehei iri ala mada iri lau tinan ta kadai iri kamak. ");
INSERT INTO lid_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ya iri lau mari kameh baseken aha bwe, tasah aha badeh, an hamon tek. Arile, are lau tawi iy ili isos munyak ano, Kindrei kameh winiyan akohok iy i hamon ja. ");
INSERT INTO lid_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Idah kameh aha anyolom ‘lakou munya-un ndra-in’ ales udu kon ndrabun ta iy sare aliy. (Are lau anyolom sahou dah iy kabudon kamwenen.) Are lau iri are kon Judiya katobwak kala bolo mandrei. ");
INSERT INTO lid_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ya are lau ereu bwele-e asiu loken sala hamon sala bolo asiu sakohok ari lakou tan ja, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ya are lau ereu bolo bilin sala hamon sala sakohok kolau tan ja, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Len doh kameh len ndra-in labai tiri badih nah ereu tiri, ma badih nah ma nyandren! ");
INSERT INTO lid_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ado kasolom ki ta Kindrei ta ado satobwak na len ta jor ma ur. ");
INSERT INTO lid_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tasah, len ndra-in doh eme kameh, kon mari kameh andra-i mara-ei, sakalawi ja iri len ndra-in mene kabatana Kindrei bwidi munyak eme taku dah. Ya ari ja hamon winiyan basakalawiy bwai. ");
INSERT INTO lid_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Arile, Laban ndrasani kane len doh. Ya, i buku none iy basaniy bwe, ari ndramak winiyan basakalawiy bwe. Arile, toro lau le nane Kindrei ndranyowonyani oro, iy kameh sani len doh kameh a mo-on. ");
INSERT INTO lid_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ya buku none ari ndramak katiye taha, ‘Krais asah idah!’ deh, ‘Laban asah in kenoh!’ Aha sanuhun, ndri-iy labai. ");
INSERT INTO lid_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tasah, idah kameh krais ta wendreya ma hawe propet ta wendreya kameh asahan. Ya iri kameh amekes iri lahou tinan ma kalem ta wendreya iri lau, ma ale anya kanone iri lau ala budon ta Kindrei udu tiri badeh, kataku. ");
INSERT INTO lid_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","“Bale aha kudu aliy! Lakou mari doh kameh barasahan hamon, eme ya jo ndratiye taha ereu bwena.” ");
INSERT INTO lid_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Arile, hamon ta len ndra-in ano, ya udu bolo len doh kameh, ‘An kameh ilik, ma bun kameh winiyan banya bwe. ");
INSERT INTO lid_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ya ndrau udu kandrah kameh taku ereu kandrah eme andri, ma boto-on mari badu kandrah kameh nyukunyok.’ ");
INSERT INTO lid_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ano iri lau kameh anyolom Nadu Ndramak Awas asahan ereu bwele-e asi kandrah, ma boto-on tan ma lomadan tinan labai. ");
INSERT INTO lid_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Eme ya iy kameh suni iri angelo tan au ala kati jor ma hahuw ereu bolo munyak dah, ta atukum iri lau tan, ala budon tan udu tiri, ereu kon ranah ili taku ranah ame hawen. ");
INSERT INTO lid_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ya aha kanyolom kei pik, ya iy kameh tiye tado. Buku none andran irek ta gwa ma nyabun asahan, aha tana aha, idah kameh kon ndra an le ai. ");
INSERT INTO lid_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ya, buku none aha anyolom iri lakou nane jo ndrasehek, aha atana aha len ndrame bakep ai. ");
INSERT INTO lid_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Jo tiye tado handru! Iri lau rebesem areu kede-eh kahis na len dah kameh bamak bwe le, iri lakou mari doh kameh asahan. ");
INSERT INTO lid_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kandrah hawe kon munyak dah kameh ano iu, arile sahou tek le kameh winiyan bano bwe. ");
INSERT INTO lid_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ari ndramak bala tanan len, deh, mada an ta Laban eme hamon bwe. Iri angelo badu kandrah ma nadun ale tanan bwe, taman le ari badeh, tanan ai. ");
INSERT INTO lid_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Bale aha kudu aliy! Aha kanyolom kamwenen, tasah aha tanan bwe, saba len handru, kameh iy eme hamon ja. ");
INSERT INTO lid_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ya idah kameh, i buku none ndramak ari anya kedek kili kon ari leheleh, ya iy atehei iri lohowan tan atondrok ai, iy ari ari in ta lahou tan labai, iy ari ari in ta lahou tan labai. Ma iy tiye ta ndramak ta madasan badeh, madan kaleu. ");
INSERT INTO lid_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ya aha kanyolom kamwenen, tasah aha tanan saba len tama asiu kameh eme bwe. Iy kameh asahan na beyeh, deh bwe, iy kameh asahan na ben alih deh, bwe na boho len deh, bwe na ma ndraben an eme loken. ");
INSERT INTO lid_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Koro-an iy keme i le mani tur, ya iy kameh kasilahei aha amadin kahis le. ");
INSERT INTO lid_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Lakou jo asehek nyala ado badeh, jo asehek nyala aha mari ya mada aha kaleu!” ");
INSERT INTO lid_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ya idah kameh, len la-uh ano, ya hamon ta aliy badeh, len ndrabun aloh Pasoba ma hawe nyamon tinan ta jabi ramen yis bolon bwe, kameh asahan. Eme iri lau tinan tiri pris ma hawe iri lau ta leheya kandriyen tiri Juwis badeh, takaleh madasan ta bahana ta ateu Jises ma anya kadai iy. ");
INSERT INTO lid_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tasah, iri anya, “To samekes sado bolo len ta nyamon tinan, ndri-iy, bwe kameh iri lau solo-an kabokoro-ei ma bahun kasahan.” ");
INSERT INTO lid_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ya eme Jises udu Betani udu asiu ta Saimon ale lepra mene udu tan. Ya iy manyah udu bada sau aimon nyamon. Eme ya badih ari eme hawen ma bwisi ndrau suluw tan amekes na kandro kei aloh nat. Ya sowan badeh, laba tinan labai. Eme iy tubwani bale bwisi ndrau suluw iu, ano iy asolou i batu Jises. ");
INSERT INTO lid_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Eme ya oro lau rayah abolosen ma tiye i toro ari ari i buku doh, “Aden! Tasah handru iy asolou suluw doh iu laleyah? ");
INSERT INTO lid_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ndrelekei doh nane katehei kili mada ba-en ya winiyan asahan i luk denariyus ere bwele-e tonek (300), ya kanyohan ki tiri lau lakou bwe.” ");
INSERT INTO lid_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Arile Jises anya, “Ado karuwani iy. Ado abudon andra-i i ta iy badih kede-eh tasah? Badih kede-eh ndramesekei lakou tinan ma mwasin labai ndrame tek. ");
INSERT INTO lid_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ya idah kameh, iri lau tiri lakou bwe kameh len mari iri are hawe ado, ma i buku none ado aseken, ado winiyan aseben iri, arile jo kameh winiyan bado hawe ado len mari bwe. ");
INSERT INTO lid_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Lakou iy badih dah anya kamekes badeh, asah iy ndramesekei dah. Iy asolou suluw badeh, i badak udu bwena dah, ta lowosa jo ta ki lek. ");
INSERT INTO lid_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ya jo tiye handru i tado. Saba kon iri atiye sahou mwasin ili udu bolo kon munyak dah, saba lakou iy ndrabwidiy dah kameh iri asehek ta aliy ta abudon nyaran.” ");
INSERT INTO lid_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ano ya, iy ari badu hawe oro lau tan ma ronoh la-uh nyaran Judas Iskariyot, iu i hawe iri lau tinan tiri pris anya kedeu sa-oh ta Jises ki mine iri. ");
INSERT INTO lid_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Eme iri tinan tiri pris anuhun badeh, iri sekesek ma tandrakan Judas ta kanyohan iy na luk. Eme Judas takaleh san ta edeu Jises ki mine iri. ");
INSERT INTO lid_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Eme na len ma mwena ta nyamon tinan ta jabi ramen yis bolon bwe eme asahan, na len ta adai iri nadu sipsip i ta salom ta Pasoba, eme oro lau ta Jises ndremenya iy, “Ou aseken aso kala heh kamekes ma kalowosa ta to kaimon nyamon ta Pasoba kado aliy?” ");
INSERT INTO lid_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eme ya iy suni uru lau tan ma la-uh ma tiye turu i buku doh, “Ah kala bolo kon tinan Jerusalem ya idah kameh ndramak ari bwese gwa in bolo sabok kameh ndruni ah. ");
INSERT INTO lid_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Eme ah ka-en hamon tan kala asiu ala iy anya ki bolon en, eme ah katiye ki ta ndramak ta asiu ki buku doh: ‘Ndramak ta leheya anya, asiu tan ndraheh? Ya idah kameh oro lau tan ma iy kameh aimon nyamon ta Pasoba a-en aliy.’ ");
INSERT INTO lid_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ya idah kameh iy leheya ah ta bolo asiu ari udu loken badeh, ndralowosaniy le. Eme ah kala aliy kamekes nyamon tato kudu le ai.” ");
INSERT INTO lid_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eme uru lau ta Jises dah adek au a kon tinan, eme uru takalahei i le buku none ndrasihidiy turu, ma oro lowosani nyamon ta Pasoba ma asiu buku le aliy. ");
INSERT INTO lid_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ano kon abeyeh Jises eme hawe oro lau tan ma ronoh la-uh ai. ");
INSERT INTO lid_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Eme oro an ndra andri aimon nyamon badeh, Jises asehek i toro i buku doh, “Jo tiye sahou handru ewek tado, iy ari ereu bolo ado kede-eh kameh atehei jo i mine iri lau ndra-in, iy ala aimon nyamon hawek en.” ");
INSERT INTO lid_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Eme oro tikisiy labai, ma oro ari ari ndremenya iy anya, “Jo nadeh, jo nadeh?” ");
INSERT INTO lid_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Eme Jises tiye i toro, “Ari badu bolo ado ma ronoh la-uh dan. Iy are alomwa jabi ramen i bolo bwekei hawek en. ");
INSERT INTO lid_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tasah, Nadu Ndramak Awas kameh imek buku le none tarou mene ndratorowenei ta nyalan. Arile, sisi-in laba tinan kameh i bwele-e iy ndramak nane ale atehei Nadu Ndramak Awas ili mine iri lau ndra-in, sebwe mwasin tinen mene satuwi iy, ndri-iy!” ");
INSERT INTO lid_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Kala oro aimon nyamon doh, Jises kuhi jabi ramen, ma iy asalom i la-un, ano iy boso-ei i noro. Ano iy tiye i toro i buku doh, “Ado kandrei, idah odak amwenen.” ");
INSERT INTO lid_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ano iy kuhi bwiniu waen, ma iy edeu wurah i ta aliy, ano iy edeu i wa-i oro lau tan, eme ma oro mari a-un. ");
INSERT INTO lid_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Eme Jises tiye i toro ja, “Idah ndrayek ta sahou randra le, ma idah kameh amou ta lau mari. ");
INSERT INTO lid_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jo tiye tado handru. Jo winiyan ba-un ndraye buwa waen dah hawe ado ja bwe, winiya le len jo kameh a-un ja i san ha-un udu bolo tondrok ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eme oro ayah wari ari ta atudun, ano ma oro au ala mandrei Olip. ");
INSERT INTO lid_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Oro adek ala le kahis, eme ma Jises tiye i toro anya, “Ado mari kameh ruwani jo, tasah iri ndratorowenei bwena udu bolo buk ndrabun asehek i buku doh, ‘Jo kameh idi ndramak ta tondrok, ya iri sipsip tan kameh aseker laleyah.’ ");
INSERT INTO lid_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Arile, hamon ta aliy kameh jo amak ja, ya jo kameh ili bwena tado ili Galili.” ");
INSERT INTO lid_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ya eme Pita tiye i tan i buku doh, “I buku none oro mari anoh ma aseker, jo winiyan batobwak bwe.” ");
INSERT INTO lid_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Eme Jises asehek i tan anya, “Handru jo asehek tam. Na ben dah kameh, kakaro baden san lusan bwe le badeh, ou kameh besebes anya ou tanam jo bwe san tulusin.” ");
INSERT INTO lid_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Arile, iy tiye sahou boto-on boto-on i buku doh, “Jo winiyan basehek sahou badeh bwe, buku none jo imek hawem jo winiyan babesebes anya jo tanan ou, bwe.” Eme ya oro mari badeh, asehek sahou randra le. ");
INSERT INTO lid_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Eme ma oro adek au ala kon ari aloh Getsemeni. Eme iy tiye i toro lau tan, “Ado kamanyah kado dah, ya jo kameh asolom ki ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ano iy kuhi Pita, Jemis ma hawe Jon oro a hawen, eme Jises atona bolo odan badeh, amaha ma sisi-in hawe iy tikisiy. ");
INSERT INTO lid_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Eme iy tiye i toro anya, “Jo tikisiy labai, ma jo anya kimek. Ado kado dah ma mada ado katele.” ");
INSERT INTO lid_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Eme ya Jises edek ili bwena sese, ma iy taku i andri bada ndren. Eme ma iy asolom i buku doh, i buku none winiyan eh, len doh ki-iu ki len tan. ");
INSERT INTO lid_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Eme ma iy anya, “Tama, tama, lakou mari badeh, ou ndra winiyan le ai. Ou andrei bwiniu dah ki-iu ki len tek, arile idoh budon tek le, ou amekes saba lakou ou tanam mwasin.” ");
INSERT INTO lid_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ano iy eme hamon iy atou oro lau tan ma taloh nane dah ndramadin. Eme iy mete-ei oro ma tiye i ta Pita anya, “Saimon, ou kede-eh ndramadin? Buku sah handru ya ou winiyan bareu loken luluwen bwe? ");
INSERT INTO lid_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ado kanyolom ma ado kasolom ki ta Kindrei ta ado sataku sala bolo kandriyen ndra-in. Ndrine ado aso-ok handru ta amekes gok, arile oda ado badeh, boto-on handru bwe.” ");
INSERT INTO lid_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ano ja iy iu i hamon asolom ma tiye sahou nane le i ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ano iy eme hamon badeh, iy atou oro ndramadin ja, tasah mada oro badeh, maha-an ta amadin labai. Eme ya oro randra sahou ta tiye i tan bwai. ");
INSERT INTO lid_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ano iy eme hamon i san tulusin ja badeh, ma iy anya, “Ado kede-eh amadin ma amunyau kahis le? Ka-iy ai! Mada an ndrasahan. Ado katou! Idah kameh Nadu Ndramak Awas kameh ili mine iri lau ta lomondra ndra-in ai. ");
INSERT INTO lid_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ado kareu loken, to ka-au. Ado katou, iy ndramak ta atiye jo ili mine iri lau ndra-in asah ndrasahan kede-eh.” ");
INSERT INTO lid_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ya eme Jises asehek sahou kahis le, Judas, iy badu hawe oro lau ma ronoh la-uh nane, edek eme hawen, hawe iri lau solo-an ma samen hawe kei udu mine iri. Iri tinan tiri pris ma hawe iri lau ta leheya kandriyen tiri Juwis ma hawe iri lau-en suni oro ame. ");
INSERT INTO lid_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas nane ndratiye toro i buku doh, “Are lau jo atehei bohok i bohon, badeh iy le ai, ado katawi iy, ma kasirini iy ki-iu ma mwasin.” ");
INSERT INTO lid_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Eme Judas isos le badeh, iy edek ales amwenen ili hawen ma anya, “Ndramak ta leheya!” Ma iy atehei bohon i boho Jises. ");
INSERT INTO lid_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Eme ma iri atehei mine iri i ta Jises ma tawi iy. ");
INSERT INTO lid_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Arile, oro lau tan ari badeh, ales are mirihik nane doh aluwi samen tan, ma iy sani ka-u ndranye bonyo-ou ta tinan tiri pris ari taku iu. ");
INSERT INTO lid_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Eme Jises tiye i tiri lau marakon doh anya, “Buku sah ya ado ame ma samen hawe kei ta ateu jo, jo ari lau ta amekes ramwes deh? ");
INSERT INTO lid_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Len mari jo udu hawe aha leheya in asiu tinan ta Kindrei, ya aha bateu jo bwe. Arile bwai. Kasahan ai, ya kamekes sahou ta buk ndrabun kasahan i handru.” ");
INSERT INTO lid_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ano oro lau tan mari ruwani iy ma oro atobwak au. ");
INSERT INTO lid_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Eme ndramak loweu ari in hamon ta Jises ya lakou badan bwe, arile ra-ei le kolau in badan. Eme iri anya kaseu iy, ");
INSERT INTO lid_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","arile iy ruwani kolau tan ma iy ndrakane le sakaliye iu. ");
INSERT INTO lid_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Eme iri sirini Jises i hawe tinan tiri pris ari. Eme iri tinan tiri pris rayah hawe iri lau-en ma hawe iri lau ta leheya kandriyen tiri Juwis mari nane atukum dah. ");
INSERT INTO lid_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ya Pita badeh, edek in ndra hamon o-on, eme iy ili bolo kowah ta asiu ta tinan tiri pris dah. Eme iy manyah udu andri hawe iri lau ta atondrok madasan alakan iy i ta jih. ");
INSERT INTO lid_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ano iri tinan tiri pris ma hawe iri lau mari badu hawe iri kansol nane anya kanone katakaleh ari sahou wasai kihis bada Jises ta anya kadai iy kimek, arile iri takaleh labwe. ");
INSERT INTO lid_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tasah, iri solo-an labai asehek sahou ta wendreya i tan, arile iri batakalahei ari lakou ndra-in Jises mesekei bwe, ma sahou tiri ba-en badan bwe ale. ");
INSERT INTO lid_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Eme iri rayah ales are loken badeh, asehek sahou ta wendreya i badan, i buku doh, ");
INSERT INTO lid_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ahi mene ndranuhun iy anya ja, ‘Jo kameh tohowei asiu tinan ta Kindrei dah ala amekes na lim kameh iu, ano na len ma taloh ja kameh jo tutuni ari ja, idoh bamekes na lim bwe.’” ");
INSERT INTO lid_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Arile bwai, sahou tiri ba-en se badan bwe ale. ");
INSERT INTO lid_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Eme tinan tiri pris nane suri iy ereu loken bolo iri eme ma iy ndremenya Jises, “Ou randra sahou ta tiye i ta sahou nane doh oro to-en ewek tam deh bwe?” ");
INSERT INTO lid_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Arile bwai, iy andru-uk le ai, ma iy batiye se sahou bwe. Ano ja tinan tiri pris ndremenya iy ja anya, “Ou kede-eh Krais handru deh bwe? Ya ou Nadu Kindrei ahi katudun ai?” ");
INSERT INTO lid_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Eme Jises anya, “Ehe, jo adeh badeh. Ya idah kameh aha anyolom Nadu Ndramak Awas kameh manyah udu loboho lim salin ta Kindrei iy boto-on labai, iy kameh udu bwele-e asi jor badu kandrah eme.” ");
INSERT INTO lid_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Eme ma tinan tiri pris ibolosen ta sahou doh ya iy tarani awin tan le ma iy anya ja, “I buku sah ja to anya kasilah sahou ta i badan ja? ");
INSERT INTO lid_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Aha mari ndranuhun sahou bobose nane. Ya aha abudon i buku sah?” Eme iri mari anya, “Kadeu iy ki ta sahou ma kadai iy kimek.” ");
INSERT INTO lid_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Eme iri rayah omor iy, ma iri tubuluhi madan ma a-um iy ma tiye sahou i tan anya, “Ou none tiye i buku ou propet, are lau a-um ou doh!” Eme iri lau ta tondrok madasan andrei iy ma ubwi iy. ");
INSERT INTO lid_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ya Pita badeh, manyah udu bolon loboho andri kahis le. Eme badih ari lohowan ta ndramak tinan tiri pris edek eme. ");
INSERT INTO lid_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Eme iy atou Pita alakan iy eme iy anyolom iy boto-on boto-on. Ano i badih dah anya, “Ou kede-eh ale mene are hawe Jises badu Nasaret adeh.” ");
INSERT INTO lid_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Arile Pita anya ja, “Bwe oh, jo tanan sasah ou asehek kede-eh bo-oh.” Eme ma Pita edek eme madasan le badeh. Eme ma kakaro eden. ");
INSERT INTO lid_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ya badih ta lohowan nane dah atou Pita ma iy asehek ja i toro lau ales dah, “Iy ndramak kede-eh iy ari badu hawe oro adeh.” ");
INSERT INTO lid_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Arile iy anya ja, “Jo tanan bwe oh.” Ano luwen bwe iri lau ales tiye i ta Pita ja, “Handru, ou kede-eh ari badu hawe oro, tasah ou kede-eh badu Galili.” ");
INSERT INTO lid_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ano Pita tandrakan boto-on labai, “Jo asehek sahou handru, jo tanan ndramak ala ado asehek iy badeh, bo-oh. Buku none jo wasai, Kindrei kamesekei maha-an keme la-uk.” ");
INSERT INTO lid_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iy asehek sahou ano le badeh, kakaro eden san lusan ja. Eme Pita bwetenei sahou mene Jises tiye i tan anya, “Kakaro baden san lusan bwe le, ou kameh besebes anya ou tanam jo bwe san tulusin.” Eme ma iy atehei bohon i ta ndrelen. ");
INSERT INTO lid_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ano na mandraben handru badeh, iri tinan tiri pris hawe iri batun tinan ma iri lau ta leheya kandriyen tiri Juwis ma hawe iri kansol rayah ame atukum atilik nyala iri. Ano ma iri sawei Jises ma tiyani iy ili, ma atehei iy ili mine Pailat. ");
INSERT INTO lid_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Eme Pailat ndremenya iy, “Ou kabin tiri Juwis, neh?” Eme Jises anya, “Ou ndrasehek badeh kabwai.” ");
INSERT INTO lid_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Eme iri tinan tiri pris badeh, asehek sahou solo-an boto-on i bada Jises. ");
INSERT INTO lid_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Eme Pailat ndremenya iy ja i buku doh, “Ou ari sahou ta tiye deh bwe? Ou anuhun sahou solo-an labai iri asehek i badam.” ");
INSERT INTO lid_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Arile Jises batiye randra sahou bwe, idoh mesekei Pailat abudon solo-an labai. ");
INSERT INTO lid_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Eme ya na len ta nyamon tinan, i buku none kandriyen tan, eme iy ruwani ndramak ari badu bolo kou eme len, i buku are ndramak iri aseken ta aliy. ");
INSERT INTO lid_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eme na len doh badeh, ndramak ari nyaran Barabas in bolo kou hawe iri lau rayah ta amekes bahun i bada gabman ta atondrok. Iri mene adai ndramak imek udu bolo len ta bahun. ");
INSERT INTO lid_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Eme iri lau solo-an ame hawe Pailat ma anya kandremenya iy ta iy katehei ndramak ki mine iri, i buku none iy ndramekes bwena ndra-au ndra-au. ");
INSERT INTO lid_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Eme iy tiye i tiri, “Aha aseken jo karuwani kabin tiri Juwis kewek mine aha?” ");
INSERT INTO lid_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat asehek i buku doh, tasah iy ndratanan, ndrine iri tinan tiri pris badeh, ndra-in ta Jises, ma iri tiyani iy eme mada sahou. ");
INSERT INTO lid_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Arile iri tinan tiri pris badeh, sosokok iri lau solo-an dah anya ja, Pailat karuwani Barabas ki mine iri ai. ");
INSERT INTO lid_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Eme Pailat ndremenya iri ja, “Ya jo kamekes sasah ki ta ndramak ala aha aloh iy kabin tiri Juwis?” ");
INSERT INTO lid_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eme iri arah ja anya, “Katahi iy ki bada kei tondreh!” ");
INSERT INTO lid_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Eme Pailat tiye i tiri, “Buku sah handru, saba lakou ndra-in handru iy mesekei?” Arile bwai, iri sarakau i loken le gwek anya, “Katahi iy ki bada kei tondreh!” ");
INSERT INTO lid_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ya eme Pailat anya kamekes iri lau solo-an nane dah kasekesek, eme ma iy ruwani Barabas i mine iri ai. Arile iy atehei Jises ili mine iri lau ta bahun, ta iri ka-um iy na malou sakabuk i bek. Ano iy atehei Jises ili mine iri lulik ta atideh iy kili bada kei tondreh. ");
INSERT INTO lid_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Eme oro lau rayah ta bahun aluwi iy eme len i bolo asumwe Pailat (idoh asiu tinan ta atukum tiri Rom). Eme ma oro luhi iri lau solo-an solo-an ta bahun dah ame. ");
INSERT INTO lid_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Eme iri atehei kolau ari saraman lawe-en ili la-un. Ano iri tabuwi bada malou bobodon i se buku none barak ma atehei ili batun. ");
INSERT INTO lid_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Eme ma iri wendreya ta asore ma abelek iy ma sarakau anya ja, “Ou kabin tiri Juwis, ou areu le buku doh len mari!” ");
INSERT INTO lid_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eme iri ubwi iy na bala banap i batun ma omor iy, ma iri atehei bwili ndru-u iri i andri ma wendreya ta atudun iy. ");
INSERT INTO lid_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Iri bobose iy ano, iri tolowei kolau saraman nane udu la-un iu, eme ma iri tani kolau tan amwenen ili hamon i badan. Eme iri sirini iy iu i len ta kadai iy ki bada kei tondreh. ");
INSERT INTO lid_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Eme iri adek ala badeh, iri ndruni ndramak ari nyaran Saimon badu Sairini. Iy badeh, edek udu kon munyak tinan eme, ya iy badeh, tama Aleksandra ma hawe Rupus. Eme iri andrekei iy bwese-ei kei tondreh ta Jises. ");
INSERT INTO lid_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Eme iri andrei Jises ili kon ari aloh Golgata, moson ta aliy iri aloh, “Kon ta bwisi bar ta ndramak.” ");
INSERT INTO lid_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Eme iri atehei waen hawe gwa ari nyakadan aloh mer tubuniy i hawen anya iy ka-un, arile iy banyuwiy bwe. ");
INSERT INTO lid_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Eme ma iri atahi iy i bada kei tondreh, ano iri andrei kolau tan i andri ma iri amekes laki na aliy, ta are winiyan andrei lakou ta Jises. ");
INSERT INTO lid_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Iri atahi Jises doh na mada an ndro ari na mandraben. ");
INSERT INTO lid_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Eme iri atahi sahou tanan ta bobose i bada kei tondreh i buku doh, “Idah Kabin tiri Juwis.” ");
INSERT INTO lid_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ya udu hawen ale iri atahi uru lau la-uh ta bahana ado kabeden. Ari ereu minen salin, ya ari ereu minen kamweu. ");
INSERT INTO lid_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Eme ya iri lau adek mirihik badeh, nyokoda batu iri ili eme ma bobose Jises i buku doh, “Ehe! Ou adeh mene anya ou kameh tohowei asiu tinan ta Kindrei eme andri, ano kameh ou tutuniy ja na bolo len taloh le. ");
INSERT INTO lid_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ya abo, ou sebenei ou amwenen, ma ou ame andri ta kei tondreh badeh!” ");
INSERT INTO lid_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ya eme ale iri tinan tiri pris bobose iy i tiri ari ari ma hawe iri lau ta leheya kandriyen tiri Juwis bobose iy i buku doh, “Iy sebenei iri rayah, arile iy winiyan basebenei iy amwenen bwe! ");
INSERT INTO lid_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Taha kanyolom, Krais kabin ta Isra-el iy keme andri ta kei tondreh, ya eme ahi kanyolom ma budon tahi handru ki tan!” Ya uru lau ma la-uh sukik areu hawen ale badeh, asehek sahou ndra-in i tan ale. ");
INSERT INTO lid_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ano ya an eme udu le alih badeh, lulik tubuluhi kon marakon udu gwek winiya mada an i taloh na beyeh. ");
INSERT INTO lid_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Eme na mada an taloh na beyeh badeh, Jises arah boto-on labai anya, “Eloi, Eloi, lama sabaktani?” moson ta aliy i buku doh, “Kindrei tek, Kindrei tek, buku sah handru ya ou ruwani jo?” ");
INSERT INTO lid_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Eme iri lau ra-on areu mirihik anuhun sahou tan ma anya, “Aha kanuhun, iy aloh Alaija.” ");
INSERT INTO lid_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Eme iy ari sakaliye ili badeh, lomwani konyei idih na waen titi-in. Eme iy atehei ili no-o banap ma atehei ili bohon ta iy ka-un, eme ma iy anya, “To kareu op, to kanyolom, idah kameh Alaija barame baratalou iy barame andri ta kei tondreh deh bwe.” ");
INSERT INTO lid_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Eme Jises anyar bohon i loken, eme ma kohan ano ma iy imek. ");
INSERT INTO lid_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kala doh amwenen kolau tinan badu bolo asiu tinan ta Kindrei atarah i ma lusi ereu loken eme andri. ");
INSERT INTO lid_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eme ndramak ari tinan ta bahun badeh, ales ere mwena ta kei tondreh badeh, anyolom Jises nane anyar ma imek i buku sah. Eme ma iy anya, “Handru labai, ndramak kede-eh Nadu Kindrei handru!” ");
INSERT INTO lid_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma ale iri badih rayah ale areu len anyolom. Ya udu bolo iri badih nane doh badeh, Mariya badu Makdala ma hawe Salome ma hawe Mariya tine i loweu Jemis ma Joses. ");
INSERT INTO lid_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Oro badeh, an hamon ta Jises udu ndra Galili o-on ma aseben iy, ma ale hawe iri badih solo-an ame hawen ame Jerusalem. ");
INSERT INTO lid_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Eme kon a beyeh ai, len ta lowosa len ta amunyau ai. ");
INSERT INTO lid_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Eme ya Josep badu Arimateya eme, ya iy badeh, tinan ari badu hawe iri kansol, ma iy badeh, abe-en ma anya katou tondrok ta Kindrei. Iy banoh bwe, eme iy ili hawe Pailat ta ndremenya bada kei. ");
INSERT INTO lid_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Eme Pailat nunu-uh tasah iy anya, Jises ndramak handru nadeh. Eme iy luhi tinan ari ta bahun eme ya iy ndremenya iy, ta Jises ndramak luluwen ndra-au deh bwe. ");
INSERT INTO lid_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Eme iy anuhun ndramak tinan ta bahun anya Jises badeh, ndramak handru. Ano Pailat tiye ta Josep badeh, kili kabwese-ei bada kei ai. ");
INSERT INTO lid_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Eme ya Josep sihinei kolau ra-ei belen eme iy andrei Jises eme andri. Ano iy su-i iy na kolau nane dah, eme iy bwese-ei Jises ili bolo lek ndramak ari doh ihiy in bolo munu bek. Ano iy tundruwi bek tinan ari ili turuki madan. ");
INSERT INTO lid_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Eme ya Mariya badu Makdala hawe Mariya tine Joses badeh anyolom ndrahune Jises nane nyahani iy in aliy ale. ");
INSERT INTO lid_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Eme ya len ta amunyau ndrano ai, eme Mariya badu Makdala hawe Salome hawe Mariya tine Jemis badeh, sihinei suluw. Eme oro anya kala kanyas ki bada Jises. ");
INSERT INTO lid_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Eme ma ndra wahun ta len ma bwena ta wik ari ja, ma ndraben handru oro au a mada lek, an barame loken ai. ");
INSERT INTO lid_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Eme oro asehek nyala oro ari ari i buku doh, “Are lau kameh kaseben to katundruwi bek tinan udu mada lek ki-iu ki len?” ");
INSERT INTO lid_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Oro asehek i buku doh, tasah bek badeh, laba tinan labai. Ano oro suri batu oro eme loken le badeh, oro anyolom bek ta mada lek badeh, ndratundruwiy ndra len. ");
INSERT INTO lid_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Eme oro a bolon badeh, oro atou ndramak loweu ari asini awin belen nyikilikin labai manyah badeh, udu loboho lim salin. Eme ya oro toroyani oro. ");
INSERT INTO lid_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Eme iy tiye i toro, “Ado satoroyani ado. Ado anya kasilah Jises badu Nasaret iri mene tatahi iy i bada kei tondreh. Iy badeh, ndramak ndrame awas ja! Ya ado kanyolom ndrahunen mene iri nyahani iy in aliy. ");
INSERT INTO lid_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Arile ado kala katandra-un toro lau tan ma hawe Pita, ya iy ndra-au ndrala bwena ndrala Galili. Ya idah kameh ado winiyan anyolom iy ereu loboho doh, i buku iy mene ndrasehek tado bwena ndra-au.” ");
INSERT INTO lid_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eme ma oro ado bolo lek ame manan, ma sakaliye au a kon. Ma mani oro atur ma oro totoreh, eme ma oro basehek nyala ari lau bwe, tasah, oro anoh.  ");
INSERT INTO lid_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Eme ma ndra wahun ta len ma bwena ta wik ari ja badeh, Jises asahan ma mwena hawe Mariya badu Makdala ala iy mene tikahei oro malawin ndra-in ma ndro taloh ado bwele-en au en. ");
INSERT INTO lid_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Eme Mariya ili tiye i toro mene an hawe Jises tikisi iy ma aden iy en. ");
INSERT INTO lid_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Eme oro anuhun Mariya asehek nyala oro anya ja, “Jises ndramak, jo ndranyolom iy.” Arile oro badeh, batehei budon toro handru ba-en ta aliy bwe. ");
INSERT INTO lid_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ano hamon ta aliy ja, Jises asahan hawe uru lau tan la-uh ja i san randrah labai, idoh na len uru adek ala kon munyak tinan. ");
INSERT INTO lid_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Eme uru au a hamon ma asehek nyala iri mari, arile bwai, iri batehei budon tiri handru ba-en ta sahou turu bwe. ");
INSERT INTO lid_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ano hamon ja badeh, Jises asahan hawe oro lau tan ma ronoh ari le, ya oro badeh, manyah an andri aimon nyamon. Ya eme iy tiye sahou boto-on i toro, tasah, ta budon toro handru ba-en tan bwe, ma ndrine oro ndrabadok. Ma oro badeh, mene budon toro handru ba-en toro lau mene anyolom iy hamon ta iy amak eme loken ja bwe. ");
INSERT INTO lid_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Eme ma iy tiye i toro i buku doh, “Ado kala bolo kon munyak mara-ei badeh, katiye sahou mwasin doh ki tiri lau mari. ");
INSERT INTO lid_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ya iy are budon tan handru in ta sahou mwasin ma kanyuwi iy, idah kameh Kindrei sebenei kohan. Arile, iy are lau batehei budon tan handru ba-en ta sahou mwasin bwe, idah kameh iy ales ere ta sahou udu mada Kindrei ma iy kameh akohok ndra-in labai, tasah ta lomondra ndra-in tan. ");
INSERT INTO lid_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Idah kameh kalem asahan ta are lau budon tan handru in ta aliy. Na boto-on ta nyarak le, iri kameh atikah malawin ndra-in iu, ma idah kameh iri asehek boho kon rakon ja nane iri tana iri bwena bwe. ");
INSERT INTO lid_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ya, i buku none iri ateu mwak deh, bwe iri a-un gwa nyakadan, idah kameh iri winiyan bakohok sisi-in ma bamak bwe. Ma idah kameh iri adeu mine iri i bwele-e iri lau abo sik, ya idah kameh sik udu tiri iu.” ");
INSERT INTO lid_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ya eme Laban Jises asehek sahou i toro ano, ma Kindrei andrei iy iu i loken bolo kandrah, ma iy ili manyah udu loboho mine Kindrei salin. ");
INSERT INTO lid_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Eme ma oro au a len, ma atiye sahou ili bolo kon mari, ma Laban aseben oro ma amekes kalem asahan ta edeu boto-on i ta sahou toro. ");
INSERT INTO lid_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Jo ai, Tiyopilus. Jo atorou la-ukei dah ewek tam: Iri lau solo-an mene ndratorou sahou solo-an ta nyala lakou mene asahan bolo ndrokowa taha. ");
INSERT INTO lid_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Oro atorou ta nyala lakou mene to ndranuhun bwena mene ndra-au. Ya lakou doh mene, oro atou na mada oro amwenen, udu ndra bada katin eme, eme ma oro a lohowan ta atiye. ");
INSERT INTO lid_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ou le ai, Tiyopilus, i buku jo mene ndratakalahei lakou mari doh, ndramwenen udu ndra bada katin eme. Eme jo abudon mwasin handru ta jo katorou sarada lakou mari doh, ki tam. ");
INSERT INTO lid_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jo atorou ewek tam, ta ou atanam kamwenen handru ta nyala lakou mene ou ndranuhun ndra-au. ");
INSERT INTO lid_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Na len kabin Herot atondrok munyak badu Judiya, pris ari udu aliy. Nyaran Sekaraya. Iy asahan ta lundriye pris Abijah oro. Ya udun badeh, nyaran Elisabet, lundriye Aron oro badu hawe oro pris ale. ");
INSERT INTO lid_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Uru ma la-uh badeh, bamekes se kandriyen ndra-in bandra-i ta mada Kindrei bwe. Uru badeh, an hamon handru ta sahou batanau ta Laban, ma an hamon ta kandriyen ta Laban mari. ");
INSERT INTO lid_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Uru badeh, ndra alon labai, ya uru bato-ou ari nah bwe. Tasah, Elisabet badeh, kis. ");
INSERT INTO lid_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Eme na len ari, Sekaraya hawe oro lau badu hawen, amekes lahou ta pris, i ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Eme i buku none in hamon ta kandriyen tiri pris, oro asoh nyek, ta are handru ki bolo bosoh ndrabun udu bolo asiu tinan ta Kindrei, ta asun ndrelekei udu mada koto-ok. Eme nyek badeh, tiye Sekaraya. ");
INSERT INTO lid_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ano len ta asun ndrelekei asahan, Sekaraya i bolon, ya iri lau ame are manan atudun, ma amekes salom. ");
INSERT INTO lid_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Eme angelo ari ta Kindrei badu loken eme, ales udu loboho lim salin bilisiu ta ndrelekei nane, anya udu mada koto-ok dah. ");
INSERT INTO lid_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraya atou iy le badeh, iy toroyani iy ma iy inoh. ");
INSERT INTO lid_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Arile angelo dah tiye i tan, “Sekaraya, ou sanoh. Kindrei ndranuhun salom tam, udum kameh atehei nah mwan ari. Eme ou tondrohani nyaran ki Jon. ");
INSERT INTO lid_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Buku atehei iy eme len, ado kameh sekesek, ma hawe iri lau mari kameh sekesek ale. ");
INSERT INTO lid_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ya udu mada Kindrei, iy kameh asahan ndramak ari tinan handru. Iy sa-un waen hawe gwa boto-on, ndri-iy labai. Atehei iy eme len le badeh, iy kameh idih na Malawin Ndrabun. ");
INSERT INTO lid_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iy le kameh tiyani iri lau badu Isra-el kameh ame hamon ja, ame hawe Laban Kindrei tiri. ");
INSERT INTO lid_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma idah kameh iy i bwena ta Laban na boto-on, ma hawe nyaran i tinan i buku none propet Alaija. Ma idah kameh iy kameh tubuni ndrine tama iri nah eme hamon ja, aseken nadu iri; ma iy kameh tubuni ndrine iri lau ta banuhun sahou bwe, ame hamon ta budon lewen ta lau mwasin; ma hawe idah kameh iy lowosa iri lau ta Laban, ado abe-en iy.” ");
INSERT INTO lid_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Eme Sekaraya tiye i ta angelo, “Ki buku sah kameh jo ki tanan lakou handru dah kasahan? Tasah, aru uduk ma la-uh badeh, ndra alon labai.” ");
INSERT INTO lid_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Eme angelo dah tiye, “Jo dah, angelo Gabiriyel. Jo ales udu mada Kindrei eme dah, ta asehek nyalam ta sahou mwasin dah. ");
INSERT INTO lid_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma idah kameh ou winiyan basehek sahou bwe; winiya le len ta aliy barasahan. Tasah, ou batehei budon tam handru ba-en ta sahou tek bwe.” ");
INSERT INTO lid_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Eme iri lau abe-en Sekaraya, abe-en abe-en labwe. Eme iri lomondra anya, “Iy ndra luluwen labai udu bolo asiu tinan ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ano Sekaraya eme len badeh, iy winiyan basehek sahou bala tiri bwe. Eme iy asehek sahou na andra lim le i tiri. Eme iri anya, “Iy kede-eh nane amekes lele in asiu tinan ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lahou tan ta amekes ano, iy iu i asiu tan. ");
INSERT INTO lid_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Udu len rayah ano iu, Elisabet nah ere tan. Eme iy udu le asiu winiya bun ma limeh. ");
INSERT INTO lid_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Eme Elisabet tiye, “Kabwai, Laban ndrasebenei jo i san dah. Iy ndrabwidi maha-an ta bwilima udu tek badeh, ndra-au!” ");
INSERT INTO lid_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Eme nah udu ta Elisabet asahan bun onoh badeh, Kindrei suni angelo Gabiriyel ja, ili kon Nasaret, udu loboho Galili. ");
INSERT INTO lid_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Iy anya katiye sahou ta tandrakan ari, anya ki ta badih ari bakohok mwan bwe le, san tan ndra ta ndramak ari nyaran Josep. Ya Josep doh, badu boho kamen ta kabin Debit oro. Ya nyara badih doh, Mariya. ");
INSERT INTO lid_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eme angelo Gabiriyel ili asahan hawen ma asumon iy anya, “Bada-an tam! Laban udu hawem, ma iy atehei nyosowan laba tinan ewek la-um!” ");
INSERT INTO lid_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Eme Mariya manin atur ta sahou ta angelo dah, eme iy lomondra saba sahou tan doh kameh. ");
INSERT INTO lid_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Eme angelo dah anya, “Mariya, ou sanoh. Kindrei badeh, sekesek tam handru. ");
INSERT INTO lid_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Idah kameh, ou tuwi nah mwan ari ere ndrinem, eme ou tondrohani nyaran ki Jises. ");
INSERT INTO lid_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iy kameh asahan ndramak tinan, ma idah kameh aloh iy Nadu Kindrei udu loken labai. Laban Kindrei kameh mesekei iy asahan kabin, i buku none tubun Debit mene, ");
INSERT INTO lid_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ma idah kameh iy asahan kabin ta atondrok lundriye Jekop oro, udu le buku doh; ma tondrok tan kameh winiyan bano bwe!” ");
INSERT INTO lid_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Eme Mariya tiye i ta angelo, “Jo badeh, bakohok ari mwan bwe. Idah kameh ki buku sah handru?” ");
INSERT INTO lid_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eme angelo dah anya, “Malawin Ndrabun kameh ewek la-um, ma hawe boto-on ta Kindrei ewek la-um. Ta katin doh le, nah doh kameh i ndrabun ma aloh iy Nadu Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ou tanam boram Elisabet, iri asehek anya iy kameh nadun bwe; iy badeh, ndra alon labai. Arile na len dah badeh, nah udu tan bun tan ndrasahan onoh ai. ");
INSERT INTO lid_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Lakou mari kede-eh Kindrei winiyan mesekei le ai.” ");
INSERT INTO lid_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Eme Mariya anya, “Jo dah, jo lohowan ta Laban, kasahan ki buku ou asehek badeh!” Eme ma angelo dah iu ai. ");
INSERT INTO lid_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ano udu hamon ja, Mariya alokou iy, ano iy edek suwi iu ili bolo ndrondro-ou, badu kon tinan ili kon ari udu bolo Judiya. ");
INSERT INTO lid_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Iy ma sekesek tan edek iu ili bolo asiu ta Sekaraya atou Elisabet. ");
INSERT INTO lid_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Eme Elisabet anuhun sahou sekesek ta Mariya, ma nah udu ndrinen nyokolokon. Eme Elisabet idih na Malawin Ndrabun, ");
INSERT INTO lid_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ma iy asehek sahou boto-on anya, “Ou badeh, nyosowan tam, sakalawi nyosowan tiri badih mari, ma nyosowan ki la-u nah, na len ou kameh adeu iy eme len! ");
INSERT INTO lid_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Lakou laba tinan dah, asahan eme tek, ta sasah handru? Ya eme tine Laban eme selesen jo dah. ");
INSERT INTO lid_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jo anuhun sahou sekesek tam le badeh, ma nah udu ndrinek nyokolokon ta sekesek. ");
INSERT INTO lid_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Idah kameh ou sekesek handru, tasah budon handru tam ndra-en ta sahou mene Laban ndrasehek tam.” ");
INSERT INTO lid_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Eme Mariya iyah wari ma tiye i buku doh: “Ndrinek atudun nyara Laban; ");
INSERT INTO lid_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma kohak handru sekesek ta Kindrei, ta aseben jo, ");
INSERT INTO lid_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","tasah jo badeh, lohowan tan ma iy tondrokei jo! Na dah kameh iri lau rebesem, ano rebesem kameh aloh jo akohok nyosowan. ");
INSERT INTO lid_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tasah, Kindrei tinan labai, iy mesekei lakou tinan labai ndrame tek, ya nyaran badeh, ndrabun. ");
INSERT INTO lid_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iy leheya tikisiy tan i tiri lau heh anoh iy; ano ili ta lau rebesem au, ano lau rebesem au, i le buku doh. ");
INSERT INTO lid_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iy amekes kalem tinan na bohan; ma iy tikahei iri lau ta budon, udu ndrine iri anya iri le ai, badeh iu. ");
INSERT INTO lid_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Iy tikahei iri kabin tinan ame andri ta koyeu tiri; ma iy tutuni iri lau, amekes lahou i buku iri nah a loken. ");
INSERT INTO lid_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Iy nyohonei iri lau ta son na lakou mwasin; ma tikahei iri lau, tiri lakou solo-an au, na luka lim ma na luka kati. ");
INSERT INTO lid_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Eme iy tawi tandrakan tan i tiri lau badu Isra-el, ma iy bamani tikisiy tan i ta Abraham ma lundriyen oro bwe, ta udu le buku doh, i buku iy mene ndratiye ta tubu ahi iri mene ndra-au.” ");
INSERT INTO lid_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya udu hawe Elisabet udu gwek winiya bun taloh, ano iy iu i hamon ja ili kon tan. ");
INSERT INTO lid_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Eme len ano ta Elisabet anya kedeu nadun, iy atehei nah mwan. ");
INSERT INTO lid_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Eme ya iri lau asiu tiri udu mirihik tan, hawe lowan oro ndranuhun ta Laban amekes mwasin i tan handru. Eme ya oro mari ame sekesek hawen. ");
INSERT INTO lid_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ano udu, nah dah len tan asahan ndru la-uh badeh, oro ala ta asan ku-in; eme oro anya katondrohon nyaran, ki nyara taman Sekaraya. ");
INSERT INTO lid_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Arile tinen anya ja, “Bwe! Nyaran kameh aloh iy Jon.” ");
INSERT INTO lid_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Eme oro tiye i tan, “Nyara lowa ado ari bala buku aliy, bwe oh!” ");
INSERT INTO lid_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ano oro amekes kalem i ta taman ta nyaran nah dah, ki are lau handru. ");
INSERT INTO lid_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Eme Sekaraya edeu kalem anya, “Ari barak keme, ya jo katorou nyaran.” Eme iy torowenei nyaran badeh, Jon. Eme oro mari, boho oro asak! ");
INSERT INTO lid_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Eme na le liliy, Sekaraya asehek sahou ja, ma iy atudun Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Eme iri lau badu mirihik badeh, boho iri asak labai. Eme ma nyala lakou dah aseker ili bolo ndrondro-ou, kon tinan loboho Judiya. ");
INSERT INTO lid_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iri lau anuhun nyala aliy, eme iri lomondra ma ndremenya, “Iy nah doh kameh asahan sah handru kameh?” Oro badeh, lomondra i buku doh, tasah boto-on ta Laban udu bwele-en. ");
INSERT INTO lid_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ano tama Jon Sekaraya idih na Malawin Ndrabun, ma iy asehek sahou ta lele. ");
INSERT INTO lid_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Taha katudun Laban Kindrei ta Isra-el! Tasah, iy ndrame ta akunoh iri lau tan. ");
INSERT INTO lid_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Iy atehei ndramak ari boto-on eme ta seben taha, badu boho kamen ta lohowan tan Debit, ");
INSERT INTO lid_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","i buku none iy mene atehei sahou kani iri propet ndrabun, bwena mene ndratiye ndra-au, ");
INSERT INTO lid_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ya iy aseben taha are mine iri lau ta amekes bahun eme tataha, ma aseben taha ado mine iri lau, ta ato-ou kaliu eme tataha, ame len. ");
INSERT INTO lid_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ma iy kameh leheya tikisiy i ta tama taha iri, ma ta budon ta sahou randra le tan mene, ");
INSERT INTO lid_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ta sahou tandrakan tan mene iy tandrakan i ta Abraham: ");
INSERT INTO lid_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ta aseben taha ado mine iri lau ta amekes bahun eme bada taha, ma mesekei taha sanoh ta amekes lahou tan. ");
INSERT INTO lid_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ma taha ka ndrabun, ma kado mwasin ta mada Kindrei na len mari, udu bolo manyah tataha. ");
INSERT INTO lid_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ya idah kameh ou naduk kameh, aloh ou propet ta Kindrei, udu loken labai; Ma ou kameh au ala bwena atehe san ta Laban, ");
INSERT INTO lid_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ma atiye sahou tanan i tiri lau tan ta nyala seben, ndrame. Ya iy kameh balen mani karei ma lomondra ndra-in tiri. ");
INSERT INTO lid_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tasah, ta tikisiy mwasin ta Kindrei tataha, iy kameh mesekei lomadan ta aseben kameh eme loke la-u taha. ");
INSERT INTO lid_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ma anya udu kandrah eme la-u iri lau badu heh, badu heh, are bolo lulik ta imek, ma leheya san ta kati taha, eme san mwasin ta bahun bwe.” ");
INSERT INTO lid_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Eme iy nah dah, i tinan, ma hawe boto-on ta Malawin Ndrabun udu la-un, ma manyah tan badeh, badu lomale an winiya iy le barasahan barame lewan, mada lau mari badu Isra-el. ");
INSERT INTO lid_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na len doh Sisa, ndramak ta atondrok nyaran Akustus, suni sahou i tiri lau mari badu bahandra tondrok ta Rom katorou nyara iri, ma kondrek kane iri lau. ");
INSERT INTO lid_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Lahou doh ma mwena handru barasahan ai, ta ondrek kane lau na len, Kuriniyus atondrok kon Siriya. ");
INSERT INTO lid_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eme iri lau mari ala kon tinan ta tubu iri ari ari, adeu nyara iri. ");
INSERT INTO lid_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Eme Josep badeh, udu kon tinan Nasaret. Kon doh udu bolo Galili, eme Josep ili. Ano, iy ili loboho Judiya ma ili kon tinan Betlehem. Kon doh mene adeu Debit udu aliy. Eme Josep ili doh, tasah iy badu boho kamen ta Debit. ");
INSERT INTO lid_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Iy mene, iri amekes san ta Mariya i tan. Eme uru ala doh ta adeu nyara uru. Arile Mariya badeh, nah udu tan. ");
INSERT INTO lid_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Eme uru ado Betlehem are gwek le badeh, ben asahan ta Mariya anya kedeu nadun. ");
INSERT INTO lid_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Eme uru ala, iy atehei nadun udu bolo asiu tiri bulumakau. Iy mwan, su-i iy na kolau, ma nyahani iy udu bolo bwekei ta ndrahu nyamon tiri bulumakau, tasah oro badeh, ari asiu ta ala aliy bwe. ");
INSERT INTO lid_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ya eme, oro lau rayah ta atondrok iri sipsip badu kon doh, atondrok iri sipsip an lobwidiu na ben. ");
INSERT INTO lid_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Eme angelo ari ta Laban badu loken eme asahan hawe oro, ma lomadan ta Laban lomatani oro. Eme ya oro anoh andra-i labai. ");
INSERT INTO lid_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Arile angelo dah, tiye i toro, “Ado sanoh! Ado kanuhun! Jo eme dah ta tiye nyala ado ta sahou mwasin, ma hawe idah kameh amekes lau mari kameh sekesek tinan labai. ");
INSERT INTO lid_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Na len dah, udu kon tinan ta Debit, nah ari ta seben ado ndrasahan. Iy badeh, Laban Krais! ");
INSERT INTO lid_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kalem ta aliy kameh ado atanan iy handru i buku doh: Idah kameh ado atou nah doh kameh su-i iy na kolau, ma nyahani iy, udu bolo bwekei ta ndrahu nyamon ta bulumakau.” ");
INSERT INTO lid_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Eme nawin bwe, iri angelo solo-an labai badu loken ame hawe angelo ari nane dah, ma iri ayah wari ta atudun nyara Kindrei i buku doh, ");
INSERT INTO lid_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Lomadan ki ta Kindrei, udu loken labai bwele-e kandrah, Ma mondrei udu bwele-e munyak i toro are iy aseken oro labai, ado mwasin ta madan.” ");
INSERT INTO lid_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ano iri angelo au a len ta mada oro, ma iri au ala kandrah. Eme ya oro lau ta atondrok sipsip ame, ndremenya oro ari ari anya, “To ka-au kala Betlehem, kanyolom lakou nane Laban asehek ta to.” ");
INSERT INTO lid_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Eme ya oro suri oro suwi suwi, ma oro ala takaleh, ma atou Mariya uru Josep, ma anyolom nah nane dah, amadin udu bolo bwekei ta ndrahu nyamon ta bulumakau. ");
INSERT INTO lid_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Eme oro lau ta atondrok iri sipsip anyolom iy. Ano oro asehek i tiri ta nyala nah nane dah mene angelo asehek i toro. ");
INSERT INTO lid_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ya eme iri lau anuhun sahou nane oro asehek dah, ma iri abudon solo-an labai ta aliy. ");
INSERT INTO lid_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Eme bale Mariya bamaniy bwe, iy lomondra boto-on labai ta aliy kahis le. ");
INSERT INTO lid_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ano oro lau ta atondrok sipsip au ala hamon ja, ma ayah wari ta atudun Kindrei ta lakou mari oro anuhun, ma lakou mari oro anyolom, asahan i buku le angelo mene ndrasihidi toro ndra-au. ");
INSERT INTO lid_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Eme ya len tan asahan ndru la-uh, idoh len ta asan ku-in. Ano uru tondrohani nyaran i Jises, nyaran mene le, angelo tiye, na len doh mene, nah bare ta Mariya bwe le. ");
INSERT INTO lid_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ano, len asahan ta Josep uru Mariya kamekes kandriyen malen ta Moses mene batanau ta sikine uru. Eme uru tiyani nah dah, ili Jerusalem ta leheya iy ki mada Laban, ");
INSERT INTO lid_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","i buku none ndratorowenei udu bolo sahou batanau malen ta Laban, “Ta nah kadok mari badeh, kadeu iri ka mine Laban.” ");
INSERT INTO lid_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Eme uru ale ala adeu “la-uh ban, ya i buku ban bwe, na la-uh ku, i mine iri pris ta asun” i nyara salom in hamon ta batanau ta Laban. ");
INSERT INTO lid_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Eme ndramak ari badu Jerusalem nyaran Simiyon badeh, udu aliy. Iy badeh, mwasin handru ta mada Kindrei ma iy inoh Kindrei labai. Ya iy badeh, Malawin Ndrabun udu tan, ma iy abe-en len ta seben ta lau badu Isra-el kameh asahan. ");
INSERT INTO lid_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ma Malawin Ndrabun ndratiye tan, ta iy kameh winiyan bamak bwe, winiya iy udu atou tandrakan ta Laban, Krais. ");
INSERT INTO lid_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Eme Malawin Ndrabun tiye Simiyon ili bolo asiu tinan ta Kindrei. Ano Josep uru Mariya ala atiye nah dah, ili bolo asiu tinan ta Kindrei in hamon le ta batanau mene ndratiye. ");
INSERT INTO lid_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Eme Simiyon bwese-ei nah dah udu bohan, ma iy edeu wurah i ta Kindrei: ");
INSERT INTO lid_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kabwai Laban, ou bamani tandrakan tam i ta lohowan tam bwe, kabwe, ou anya jo kimek, jo kimek ai ma sekesek. ");
INSERT INTO lid_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tasah, udu madak amwenen jo ndranyolom seben tam ai, ");
INSERT INTO lid_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ou mene lowosani udu mada lau mari anyolom: ");
INSERT INTO lid_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Anya ma lomadan eme len, ta leheya ou ame len mada iri lau badu leheleh, ma lomadan anya i tiri lau tam, Isra-el.” ");
INSERT INTO lid_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Eme tama Jises uru tinen badeh, boho uru asak ta sahou nane Simiyon asehek nyala Jises dah. ");
INSERT INTO lid_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ano, Simiyon atehei nyosowan i la-u oro, ano iy tiye i ta Mariya, “Iy nah le doh, Kindrei le edeu iy, ma idah kameh iy aseben iri lau badu Isra-el rayah, ya iri rayah kameh bwale iri iy. Ma idah kameh, iy i kalem ta lau kameh asehek sahou nyarahan i tan, ");
INSERT INTO lid_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ma idah kameh, iy leheya budon ndra-in tiri kameh eme lewan. Ma idah kameh ou tikisiy handru, i buku none samen madan, mesekei ndrinem tikisiy tinan labai.” ");
INSERT INTO lid_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Eme ya propet badih ari nyaran Ana nadu Panuwel udu aliy. Iy badu boho kamen ta Aser. Iy udu ta udun jaha ma ndro taloh le, ano udun imek. Iy i nyau udu udu, iy i alon, ma jaha tan asahan ndru lunoh hahuw (84). ");
INSERT INTO lid_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ya ben len, ben len, iy abeles iy ta nyamon, ma iy baruwani ta ili asiu tinan ta Kindrei ta amekes solom, ma ta atudun Kindrei, bwe. ");
INSERT INTO lid_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Eme iy eme isos hawe oro na len doh, ma iy edeu wurah i ta Kindrei, hawe iy asehek nyala nah doh, i tiri lau heh mari abe-en bohon ili bwena, ta ndramak ta akunoh iri Jerusalem. ");
INSERT INTO lid_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Eme uru mesekei lahou mari in hamon ta batanau mari ta Laban. Ano uru ala hamon ja, ala Galili ma ala kon turu Nasaret. ");
INSERT INTO lid_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Eme nah dah i tinan i boto-on; ma iy idih ta tanan badu loken, hawe nyosowan ta Kindrei udu tan. ");
INSERT INTO lid_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jaha mari ndra-au, tine Jises uru badeh, ala Jerusalem na len ta nyamon tinan tiri Juwis mene ado Ijip ame len, aloh Pasoba. ");
INSERT INTO lid_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ano, jaha ta Jises asahan ronoh la-uh, oro ala ta nyamon i le buku bwena. ");
INSERT INTO lid_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Eme len ta nyamon ano, oro adek ala hamon ala kon, arile Jises badeh, udu ndra Jerusalem udu gwek. Taman uru tinen tana uru bwe; ");
INSERT INTO lid_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","uru anya deh, iy deh udu bolo oro le. Eme oro adek ala len ari buruwen ano badeh, bale uru bwetenei iy. Eme uru takalahei bolo ndrokowa lowa uru, ma kawas turu nane dah, ");
INSERT INTO lid_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","arile uru batakalahei iy bwe. Eme uru adek ja, ala hamon ala Jerusalem takaleh iy. ");
INSERT INTO lid_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ya eme i bada len taloh badeh, uru takalahei iy manyah udu bolo iri lau ta leheya kandriyen tiri Juwis. Iy udu asiu tinan ta Kindrei, anuhun iri ma lelen ndremenya i tiri. ");
INSERT INTO lid_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Eme iri mari anuhun tanan ta sahou iy akeh, i hamon i tiri, ma boho iri asak tan. ");
INSERT INTO lid_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eme ya taman uru tinen atou, boho uru asak. Eme tinen tiye i tan, “Naduk, ou amekes saba kandriyen eme taru dah? Aru tamam badeh, bale aru asin ou, ya eme aru ame takaleh ou dah.” ");
INSERT INTO lid_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Eme iy anya, “I buku sah ah anya kame katakaleh jo? Ah badeh, bala tana ah, ta jo dah udu asiu ta tama bwe nadeh?” ");
INSERT INTO lid_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Arile uru bakohok bolo sahou tan nane iy asehek i turu dah, bwe. ");
INSERT INTO lid_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Eme ya, i buku none kandriyen tan ta anuhun sahou badeh, iy i hawe uru, ma oro au ala andri ala Nasaret. Ya eme tinen tone tanan mari doh udu le ndrinen. ");
INSERT INTO lid_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Eme Jises badeh, salin i tinan ma hawe tanan tan ale i tinan. Ma Kindrei sekesek tan labai, hawe iri lau ale sekesek tan. ");
INSERT INTO lid_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Idoh, udu bada jaha ronoh limeh ta Sisa ari ja nyaran, Taiberiyus atondrok kon mari; eme Pontiyus Pailat badeh, atondrok kon loboho Judiya. Ya Herot badeh, atondrok kon loboho Galili. Ya nadu tinen Pilip badeh, atondrok kon loboho Ituriya hawe Trakonitis; ma Lisaniyas atondrok Abilene, ");
INSERT INTO lid_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ya Anas uru Kayapas badeh, uru lau tinan tiri pris. Eme nadu Sekaraya Jon udu kon lomale an, ya eme Kindrei suni sahou i tan. ");
INSERT INTO lid_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Eme Jon edek ili bolo kon mari badu loboho gwa Jodan ili atiye sahou, ta tiye iri lau katubuni ndrine iri ta kandriyen ndra-in ma Kindrei kameh sikine iu. ");
INSERT INTO lid_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","I buku none propet Aisaya mene ndratorowenei udu bolo tarou tan: “Ndramak ari aloh udu bolo kon lomale an i buku doh, ‘Kalowosa san ta Laban, ma kadik san kales lewan. ");
INSERT INTO lid_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bolo sa-eu badeh, katurukiy kanyemes keme loke, ma hawe iri bwili ndrondro-ou hawe mandrei badeh, katiriy kanyemes keme andri, Ma san mwekele-eu badeh, kales le, Ma san totokon badeh, kanyemes le. ");
INSERT INTO lid_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ya eme iri lau mari kanyolom ndramak ta seben ta Kindrei.’” ");
INSERT INTO lid_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Eme iri lau solo-an ame hawe Jon ta iy kinyu iri. Arile, iy tiye i tiri i buku doh, “Aha badeh, mwak ndra-in. Are lau tiye aha ta atobwak au a len ta losen ta Kindrei kameh eme? ");
INSERT INTO lid_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ado kadeu nah ma ado kabatanau oro ta oro katubuni ndrine oro ta kandriyen ndra-in toro ki san ta tikisiy. Ya ado sabudon ado ma satiye ado sala buku doh: ‘Aso badeh tama aso Abraham, eme ya aso anya, aso mwasin.’ Arile bwe. Jo katiye tado kamwenen, Kindrei winiyan mesekei iri bek dah, winiyan asahan i nadu Abraham. ");
INSERT INTO lid_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Samen kamondrou ta Kindrei badeh, ndrala ndrado mwe-e kei, ya iri kei ala bato-ou sali iri bala mwasin bwe, idah kameh amundroh iri ala andri, ano ma akeh iri au ala bolo jih.” ");
INSERT INTO lid_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eme iri lau ndremenya, “Ya ahi kameh ki buku sah handru bah?” ");
INSERT INTO lid_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eme Jon anya, “Ado lau heh, awin tado la-uh, ado kanyohan ari ki ta ndramak tan awin bwe. Ma are lau nan nyamon udu aliy, iy kanyohan ki na ndramak nan nyamon bwe.” ");
INSERT INTO lid_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ano iri lau ta akohok luk ta takis ame anya kanyu iri ma iri ndremenya Jon, “Ndramak ta leheya, ahi ka buku sah handru bah?” ");
INSERT INTO lid_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ya eme Jon anya, “Ado sakohok lakou sawek la-u lakou tado bwena ja!” ");
INSERT INTO lid_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Eme iri lau rayah ta bahun ndremenya iy ja, “Ya, aso ka buku sah bah?” Eme iy tiye i toro, “Ado kasekesek ta sihine ado le. Ya ado sawendreya ta satara luk ta ari ndramak, ma ado sandres ndramak laleyah ta sahou.” ");
INSERT INTO lid_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Eme ya mada iri lau asak, ma iri lomondra i bada Jon. Eme ya iri anya, “Iy sala Krais?” ");
INSERT INTO lid_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eme Jon anya, “Jo alomwa ado na gwa, arile ndramak ari in hamon tek eme kameh, boto-on tan badeh, sakalawi boto-on tek ja. Jo badeh, mwasin handru bwe, ta talou malou ta molowa ku-i katin bwe. Arile, iy kameh inyu ado na boto-on ta Malawin Ndrabun ma aleben ado buku jih. ");
INSERT INTO lid_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma iy andrei lakou tan udu minen ta asorok bada kalom eme len lewa salin. Idah kameh iy atukum sali kalom ili asiu ta asumwe nyamon, ma idah kameh, iy asun iri bada kalom ili bolo jih ta winiyan bamak bwe.” ");
INSERT INTO lid_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","San solo-an, Jon badeh atiye sahou mwasin ta aliu iri. ");
INSERT INTO lid_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ya eme Jon asehek sahou boto-on i ta Herot, ndramak ta atondrok, tasah iy sudi udu nadu tinen Pilip Herodiyas i tan, hawe iy amekes kandriyen ndra-in solo-an labai. ");
INSERT INTO lid_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ano ma ndra-in labai ja badeh, iy atehei Jon i bolo kou. ");
INSERT INTO lid_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jon bala bolo kou bwe le badeh, iy anyuwi iri lau mari, ano iy inyu Jises. Eme ya iy amekes salom le badeh, kandrah asak, ano ");
INSERT INTO lid_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Malawin Ndrabun atah i buku ban eme andri eme bwele-en. Ya eme aloh ari udu kandrah tiye i buku doh, “Ou badeh, naduk handru, ma ou adek handru; ou le mesekei jo sekesek labai.” ");
INSERT INTO lid_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ano Jises jaha tan ndra buku none tonoh (30), iy amekes lahou tan eme len. Eme iri lau mari abudon anya tama Jises badeh, Josep. Arile, tinen badeh, edek ndrine Heli, ");
INSERT INTO lid_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ano Heli edek ndrine Matat, ano Matat edek ndrine Libai, ano Libai edek ndrine Melki, ano Melki edek ndrine Janai, ano Janai edek ndrine Josep, ");
INSERT INTO lid_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ano Josep edek ndrine Matatiyas, ano Matatiyas edek ndrine Amos, ano Amos edek ndrine Nahum, ano Nahum edek ndrine Esli, ano Esli edek ndrine Nagai, ");
INSERT INTO lid_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ano Nagai edek ndrine Mat, ano Mat edek ndrine Matatiyas, ano Matatiyas edek ndrine Semen, ano Semen edek ndrine Josek, ano Josek edek ndrine Joda, ");
INSERT INTO lid_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ano Joda edek ndrine Jo-anan, ano Jo-anan edek ndrine Resa, ano Resa edek ndrine Serubabel, ano Serubabel edek ndrine Seyaltiyel, ano Seyaltiyel edek ndrine Neri, ");
INSERT INTO lid_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ano Neri edek ndrine Melki, ano Melki edek ndrine Adi, ano Adi edek ndrine Kosam, ano Kosam edek ndrine Elmadam, ano Elmadam edek ndrine Er, ");
INSERT INTO lid_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ano Er edek ndrine Josuwa, ano Josuwa edek ndrine Eliyeser, ano Eliyeser edek ndrine Jorim, ano Jorim edek ndrine Matat, ano Matat edek ndrine Libai, ");
INSERT INTO lid_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ano Libai edek ndrine Simiyon, ano Simiyon edek ndrine Juda, ano Juda edek ndrine Josep, ano Josep edek ndrine Jonam, ano Jonam edek ndrine Eliyakim, ");
INSERT INTO lid_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ano Eliyakim edek ndrine Meleya, ano Meleya edek ndrine Mena, ano Mena edek ndrine Matata, ano Matata edek ndrine Netan, ano Netan edek ndrine Debit, ");
INSERT INTO lid_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ano Debit edek ndrine Jesi, ano Jesi edek ndrine Obet, ano Obet edek ndrine Bowas, ano Bowas edek ndrine Salmon, ano Salmon edek ndrine Nason, ");
INSERT INTO lid_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ano Nason edek ndrine Aminadap, ano Aminadap edek ndrine Atmin, ano Atmin edek ndrine Arni, ano Arni edek ndrine Hesron, ano Hesron edek ndrine Peres, ano Peres edek ndrine Juda, ");
INSERT INTO lid_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ano Juda edek ndrine Jekop, ano Jekop edek ndrine Aisik, ano Aisik edek ndrine Abraham, ano Abraham edek ndrine Tera, ano Tera edek ndrine Nahor, ");
INSERT INTO lid_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ano Nahor edek ndrine Seruk, ano Seruk edek ndrine Reu, ano Reu edek ndrine Pelek, ano Pelek edek ndrine Eber, ano Eber edek ndrine Sela, ");
INSERT INTO lid_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ano Sela edek ndrine Kenan, ano Kenan edek ndrine Apasat, ano Apasat edek ndrine Sem, ano Sem edek ndrine Nowa, ano Nowa edek ndrine Lemek, ");
INSERT INTO lid_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ano Lemek edek ndrine Matusala, ano Matusala edek ndrine Inok, ano Inok edek ndrine Jaret, ano Jaret edek ndrine Mahalalel, ano Mahalalel edek ndrine Kenan, ");
INSERT INTO lid_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ano Kenan edek ndrine Inos, ano Inos edek ndrine Set, ano Set edek ndrine Adam, ya ano Adam badeh, nadu Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ano Jises udu gwa Jodan eme loken le badeh, iy idih na boto-on ta Malawin Ndrabun. Eme Malawin Ndrabun andrei iy iu ili kon lomale an. ");
INSERT INTO lid_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Udu loboho kon doh, balik none iy ta iy kataku udu bolo len ma hanoh (40). Udu bolo len doh Jises baimon se nyamon bwe, eme suniya len anya kano badeh, iy imeson. ");
INSERT INTO lid_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Eme balik tiye i ta Jises i buku doh, “I buku none ou anya, ou Nadu Kindrei, ou asehek sahou ki ta bek kede-eh, kasahan jabi ramen.” ");
INSERT INTO lid_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Eme Jises tiye i tan i buku doh, “Ndratorowenei, ‘Lau winiyan balelei le jabi ramen ta samak bwe!’” ");
INSERT INTO lid_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ano ja, balik andrei iy uru ala loke, suwi suwi iy leheya iy ta kon tinan mari badu munyak, iri kabin atondrok. ");
INSERT INTO lid_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Eme ma balik tiye i ta Jises i buku doh, “Lakou mari ou atou nane kede-eh, udu minek. Eme ya jo winiyan edeu i tare lau na seken tek, ya eme idah kameh, jo edeu boto-on ma hawe lakou mwasin mari doh kameh i tam, ");
INSERT INTO lid_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","i buku none ou atehei bwili ndru-um keme tek, ma atudun nyarak.” ");
INSERT INTO lid_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Eme Jises tiye i tan ja i buku doh, “Sahou ta Kindrei badeh, ndratorowenei ale, ‘Ou atudun le nyara Laban Kindrei tam, ma ou a-en hamon tan le ari kabwe.’” ");
INSERT INTO lid_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ano ja, balik andrei iy uru ala Jerusalem, eme ma balik atehei iy ales udu bwele-e no-o asiu tinan ta Kindrei loken on. Ano balik tiye i tan i buku doh, “Ou anya ou Nadu Kindrei handru eh, ou akahei ou ado dah ala andri. ");
INSERT INTO lid_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tasah, i buku ndratorowenei, ‘Kindrei kameh edeu sahou batanau ili tiri angelo tan ame ta aseben ou ma atondrok ou. ");
INSERT INTO lid_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ma idah kameh, iri bwese-ei ou, ma bek winiyan batahi katim bwe.’” ");
INSERT INTO lid_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jises tiye i buku doh i tan, “Sahou ta Kindrei badeh, ndratiye, ‘Ou satehei Laban Kindrei tam sala ta bolo none.’” ");
INSERT INTO lid_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ano balik none iy ta madasan mari, arile Jises banuhun iy bwe, ano iy ruwani iy ma iy iu, winiya len ari ja, iy barasahan. ");
INSERT INTO lid_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ano Jises eme hamon eme Galili, hawe boto-on ta Malawin Ndrabun udu hawen eme. Ya eme sahou ta nyala iri lakou iy amekes badeh, aseker ili winiya loboho doh. ");
INSERT INTO lid_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ano iy leheya iri udu asiu ta atukum tiri Juwis, eme ma iri atudun iy. ");
INSERT INTO lid_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ano Jises iu i hamon ja ili Nasaret, kon mene iy i tinan udu aliy. Eme i buku none len ta amunyau mari ndra-au, eme na len ta amunyau dah ja, Jises ili bolo asiu ta atukum tiri Juwis. ");
INSERT INTO lid_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Eme iy ales ere loke, iri atehei tarou ta Aisaya i minen. Ano iy sihi buk i ta sahou nane Aisaya atorou dah. Ano iy aloh: ");
INSERT INTO lid_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Malawin Ndrabun ta Laban badeh, udu bwele-ek, Tasah, iy suni jo ta atiye sahou ki tiri lau lakou bwe. Iy suni jo ta tiye sahou ki tiri lau are bolo kou kame len, Ma kamekes iri lau mada iri kaseu, kanyolom ja; Ma ta talou malou tiri lau, ado ndra-in handru ka-au. ");
INSERT INTO lid_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma hawe ta tiye ta Laban kameh aseben iri lau tan na jaha doh.” ");
INSERT INTO lid_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ano Jises lukumwi buk nane dah, ya atehei i mine ndramak ta atondrok, ano ma iy udu andri leheya oro. Eme iri lau mari nane ado asiu ta ndrahu tukum tiri Juwis dah, mada oro asoh ili le tan. ");
INSERT INTO lid_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ano iy tiye i toro, “Sahou nane ado ndranuhun badeh, ndrasahan handru na len dah.” ");
INSERT INTO lid_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Eme oro asehek anya, iy ndramak mwasin labai. Ya, mani oro atur, ma oro lomondra solo-an labai ta sahou mwasin iy asehek. Ya eme oro anya, “Iy kede-eh nadu Josep labai, neh?” ");
INSERT INTO lid_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ano Jises tiye i toro, “Jo tanan labai, idah kameh ado anya, ‘Ou tiye sahou mwasin ki tam le. Ou badeh, ndramak ta amekes lau oh? Ou amekes kudu kon tam mwena op!’ Ya idah kameh, ado tiye eme tek ale anya, ‘Abo, ou none amekes lahou mene ou amekes udu Kapena-um kudu kon tam amwenen dah se.’” ");
INSERT INTO lid_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Eme Jises anya, “Jo katiye tado kamwenen, iri lau badu bolo kon tiri propet amwenen badeh, iri winiyan baseken iy bwe. ");
INSERT INTO lid_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Arile jo katiye tado kamwenen, kabatana Alaija, iri badih nyau badu Isra-el badeh, solo-an labai. Idoh, amwenen na len iri lau badu kon mari mene ameson, tasah ur badeh, bandruk se bwe, winiya jaha taloh ranah. ");
INSERT INTO lid_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eme Alaija badeh, bala baselesen oro ari badu Isra-el bwe, arile iy le ili hawe badih nyau ari udu kon Sarepat, udu loboho kon Saidon. ");
INSERT INTO lid_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ya na len propet Alaisa in ndra propet badeh, iri Isra-el solo-an badeh, sik lepra udu tiri. Ya udu bolo iri mari badeh, ndramak ari le badu Siriya, nyaran Naman badeh, Alaisa mesekei iy amwenen.” ");
INSERT INTO lid_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Eme iri mari nane ado bolo asiu ta atukum nane dah anuhun, ma iri abolosen. ");
INSERT INTO lid_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Eme iri ato-ou ame loken ma aluwi iy eme len ta kon. Eme iri seheyani iy ili loken bwele-e kiri mandrei, kon tinan nane udu aliy dah, ma iri anya kakeh iy ki andri. ");
INSERT INTO lid_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Arile, Jises asoh bolo ndrokowa iri iu. ");
INSERT INTO lid_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ano, na len ari ja, Jises edek iu ili andri i kon tinan ari aloh Kapena-um udu loboho Galili. Ma iy leheya iri lau mwan ma badih na len ta amunyau. ");
INSERT INTO lid_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Eme iri lau mani iri atur ta bolo leheya tan, tasah sahou tan badeh, nyarahan labai. ");
INSERT INTO lid_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eme udu bolo asiu ta atukum nane dah, ndramak ari malawin ndra-in udu la-un. Eme iy aloh bohon i tinan, ");
INSERT INTO lid_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei! Jises badu Nasaret, ou anya amekes sasah keme taso? Ou ame dah ta adai aso kamak ai? Jo tanan ou are handru kede-eh, ou badeh, ndramak ndrabun ta Kindrei!” ");
INSERT INTO lid_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Eme Jises tiye i ta malawi ndra-in anya, “Ou andru-uk ma ou ame len ta ndramak badeh!” Eme malawin ndra-in dah morahani ndramak dah i andri ndrokowa iri lau. Ma iri malawin ndra-in ame len ma au, udu mada iri lau mari nane dah. Iri bamesekei ari isi bala bada ndramak dah, bwe. ");
INSERT INTO lid_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Eme iri lau mani iri mari atur, ma iri asehek i tiri ari ari, “Saba lahou handru dah? Sahou tan nyarahan ma boto-on labai, tasah iy tiye sahou i ta malawin ndra-in le badeh, ma iri ame len!” ");
INSERT INTO lid_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Eme sahou ta nyala Jises aseker ili bolo kon mari badu loboho doh. ");
INSERT INTO lid_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ano Jises udu asiu ta atukum tiri Juwis eme len ales ili asiu ta Saimon. Eme oro asehek i tan ta iy kaseben salahu Saimon. Tasah, iy badeh, ibo sik ma badan badeh, nyarahan nyarahan. ");
INSERT INTO lid_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Eme Jises edek ili ka-au sau hawen, ma tiye sahou nyarahan i ta sik nane dah. Ano ma badan anyala, ma iy suri iy le eme loke, ma iy amekes noro nyamon. ");
INSERT INTO lid_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Eme len ta amunyau ano, an anya ki andri, iri atiye iri lau solo-an, saba sik udu tiri ame hawe Jises. Ya eme iy edeu minen i la-u iri mari, ma iy mesekei iri amwenen ja. ");
INSERT INTO lid_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ma hawe iri malawin ndra-in solo-an ado la-u iri lau anyar ame len, tiye i buku doh, “Ou badeh, Nadu Kindrei.” Arile, iy tiye iri kandru-uk le, tasah iri ndratanan, iy badeh, Krais. ");
INSERT INTO lid_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ano na mandraben handru Jises udu kon tinan eme len, ili kon ari doh, lau bare aliy bwe. Eme iri lau takaleh iy, ma iri ala hawen. Ya eme iri ateu iy na sahou ta iy sa-au, iy badeh, kudu. ");
INSERT INTO lid_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Arile Jises tiye i tiri, “Bwe! Jo ki-iu kili katiye sahou mwasin ta nyala tondrok ta Kindrei ki tiri kon tinan rayah ja. Tasah, Kindrei suni jo eme dah ta atiye sahou tan.” ");
INSERT INTO lid_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Eme iy atiye sahou ili loboho Judiya, udu bolo asiu ta tukum tiri Juwis. ");
INSERT INTO lid_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ano na len ari ja, Jises badeh, ales udu babi ta gwa li ari aloh Genesaret. Ya iri lau badeh, awudi iy, kon aso, ta anya kanuhun sahou ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Eme madan ili badeh, atou ndron lu-ei ta ni iri aluwi in babi. Oro lau ta ni badeh, ruwani ndron udu gwek, ya oro soroya kubwin toro. ");
INSERT INTO lid_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Eme Jises sandroh in bolo ndron ta Saimon, eme iy tiye Saimon susuwini iy i len sese ta babi. Ya eme Jises udu ndron badeh, leheya sahou ta Kindrei i tiri lau mari an babi. ");
INSERT INTO lid_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eme sahou tan ano le badeh, iy tiye i ta Saimon, “Ado kasowe kame len, ya ado kakeh kubwin tado ki gwa, kawe-ek ni.” ");
INSERT INTO lid_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Eme Saimon anya, “Ndramak ta leheya, aso badeh, ndramekes na ben ari buruwen ndra-au, arile aso bakohok se ni bwe. Arile, in hamon ta bohom ou ndratiye, jo kameh akeh kubwin ili gwa ja.” ");
INSERT INTO lid_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Eme oro akahei kubwin i gwa, eme ya kubwin toro anya katarah, tasah ni badeh, solo-an labai. ");
INSERT INTO lid_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eme oro anyoleh i toro lau toro are ndron ra-ei ja kame kaseben oro. Ano oro weleyani ndron toro, ma lu-ei na ni, ma ndron toro anya katuh. ");
INSERT INTO lid_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Eme Saimon Pita anyolom lakou dah asahan, ma iy taku i andri na bwili ndru-un udu kati Jises, ma tiye i buku doh, “Ou sado madak Laban, ou au. Jo badeh, kandriyen tek ndra-in!” ");
INSERT INTO lid_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ya eme Saimon hawe oro lau tan ta ni are hawen badeh, mani oro atur labai, tasah ni oro kuhiy solo-an labai. ");
INSERT INTO lid_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma uru lau badu hawe Saimon, Jemis uru Jon nadu Sebedi badeh, mani uru atur ale. Ano Jises tiye i ta Saimon, “Kabwai, ou sanoh; na dah, ma na len hamon eme, ou kameh akohok iri ndramak, i buku ou awe-ek ni badeh.” ");
INSERT INTO lid_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Eme oro aluwi ndron toro eme babi eme loken, ano oro ruwani lakou toro mari udu api, ma oro an hamon ta Jises. ");
INSERT INTO lid_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ano na len ari ja, Jises udu kon tinan ari, ya udu loboho doh badeh, ndramak ari sik lepra ini badan mari. Iy eme atou Jises le badeh, iy morahani iy i andri anyolou iy anya, “Laban, i buku ou aseken ou winiyan mesekei jo kamwenen ja udu mada Kindrei!” ");
INSERT INTO lid_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Eme Jises atehei minen i badan ma tawi iy, ano iy tiye, “Jo aseken. Ya ou amwenen ja.” Eme ma sik lepra tan amai i le rasan. ");
INSERT INTO lid_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ano Jises tiye i tan, “Ou satiye lakou dah, sala ta ari ndramak labai; arile ou ales ala hawe iri pris, leheya badam ki tiri kanyolom; ano ou adeu salom ta asun i le buku Moses mene ndrabatanau. Ya eme iri kanyolom ma katanan ou badeh, ndramwenen ja.” ");
INSERT INTO lid_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Arile, sahou ta nyala Jises badeh, ndraseker ndra tinan labai, eme ya iri lau solo-an ame ta anuhun sahou tan, ma hawe kamekes iri kamwenen. ");
INSERT INTO lid_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Arile len solo-an badeh, Jises iu ili kon lau aliy bwe ta asolom. ");
INSERT INTO lid_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ano na len ari ja, Jises leheya iri lau mwan ma badih udu bolo asiu ari. Eme iri Parasi, hawe iri lau ta leheya kandriyen tiri Juwis, badu bolo kon tinan Galili, iri badu Judiya ma hawe badu Jerusalem ame manyah anuhun Jises asehek sahou. Ya eme boto-on ta Laban badeh, eme la-u Jises ta amekes iri lau sik udu tiri kamwenen. ");
INSERT INTO lid_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Eme lau rayah badeh, bwese-ei ndramak ari, badan imek udu bada sau eme. Oro anya kabwese iy keme bolo asiu, ma kadeu iy kudu mada Jises. ");
INSERT INTO lid_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Arile iri lau solo-an labai, eme oro san ta bwese iy ili bolo asiu bwe. Eme oro bwese-ei ndramak dah i loke bwele-e asiu, ano oro bosokei bwele-e asiu dah, ma atehei ndramak dah, in bada nyahan i andri bolo lau nane dah, ili udu mada Jises. ");
INSERT INTO lid_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ya eme Jises anyolom budon toro handru, eme iy tiye i ta ndramak dah, “Kawas tek, kandriyen ndra-in tam ndrasikinei ndra-au.” ");
INSERT INTO lid_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Eme oro lau ta leheya kandriyen tiri Juwis, hawe oro Parasi badeh, asehek i toro ari ari anya, “Iy ndramak kede-eh bobose o! Iy aluhe Kindrei kede-eh! Ari ndramak winiyan basikine kandriyen ndra-in bwe; Kindrei le ari, kabwe!” ");
INSERT INTO lid_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Eme Jises badeh, ndratanan budon toro, eme iy tiye i toro, “Tasah handru ado ndremenya solo-an udu ndrine ado? ");
INSERT INTO lid_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","San manamun ndraheh, katiye, ‘Kandriyen ndra-in tam ndrasikine ndra-au,’ deh, bwe katiye, ‘Ou suri ou, ma ou adek.’ ");
INSERT INTO lid_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Jo winiyan leheya ewek tado ma ado ki tana ado, ta Nadu Ndramak Awas badeh, boto-on labai udu bwele-e munyak dah ta tiye i ta ndramak ta mani kandriyen ndra-in tan iu.” Eme Jises tiye i ta ndramak badan imek dah, “Jo tiye tam, ou suri ou, ou andrei nyahan tam ma ou au a kon!” ");
INSERT INTO lid_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ano suwi labai, iy suri iy eme loken udu mada iri mari, ma andrei nyahan tan nane, ma iy atudun Kindrei udu bohon, ma iu i kon. ");
INSERT INTO lid_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Eme iri mari badeh, mani iri atur handru en, ma iri atudun nyara Kindrei. Ya boho iri asak, ma iri tiye i buku doh, “Taha na dah badeh, ndranyolom kalem randrah labai.” ");
INSERT INTO lid_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ano Jises eme len badeh, iy atou ndramak ari ta akohok luk ta takis, nyaran Libai, iy manyah ereu bolo asiu tan ta gok ta akohok luk ta takis. Eme Jises tiye i tan, “Ou ame an hamon tek.” ");
INSERT INTO lid_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Eme Libai ruwani lakou tan mari, ma iy in hamon tan. ");
INSERT INTO lid_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ano, Libai mesekei tine nyamon udu asiu tan, i na Jises. Ma hawe iri lau solo-an ta akohok luk ta takis badeh, ame aimon nyamon hawe oro ale. ");
INSERT INTO lid_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ya oro Parasi rayah, hawe oro lau rayah ta leheya kandriyen tiri Juwis, badu bolo oro nane dah, nunu-uh oro lau ta Jises anya, “Tasah handru ado aimon nyamon hawe oro lau ta akohok luk ta takis, ma hawe oro lau ale ba-en hamon ta batanau ta Moses bwe?” ");
INSERT INTO lid_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ya eme Jises asumon i buku doh, “Iri lau ale babo sik bwe, iri winiyan baso-ok ndramak ta anyumor bwe. Arile, iri lau tiri sik le badeh, aseken seben. ");
INSERT INTO lid_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jo eme dah ta aseben lau mwasin le, bwe. Jo eme dah badeh, ta aseben iri lau ta karei ma lomondra ndra-in udu tiri badeh, katubuni ndrine iri, ma iri kasahan mwasin.” ");
INSERT INTO lid_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Eme ya iri ndremenya Jises anya, “Oro lau ta Jon ta alomwa mene abeles oro ta nyamon, ma hawe oro amekes salom solo-an sese. Ma hawe oro lau tiri Parasi badeh, amekes i le buku oro le; arile oro lau tam badeh, babeles oro ta nyamon bwe.” ");
INSERT INTO lid_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Eme Jises asumon i buku doh, “I buku none ndramak tasou bolohau udu aliy, ado winiyan babilisi oro lau ta molak bwe! ");
INSERT INTO lid_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Arile, na len hamon eme kameh, iri lau ta kaliu tan kuhi iy eme len, ma na len doh kameh oro winiyan baimon nyamon bwe.” ");
INSERT INTO lid_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ano Jises tiye sahou sokek ari ja i toro i buku doh, “Ari ndramak winiyan batarani kolau ha-un, ya iy winiyan baserehei bala ta ndrabwak, udu ta kolau malen bwe. Ya i buku none iy kaserehei kolau ha-un ki aliy kameh tarani andra-i labai. Ma kolau malen kameh ndrabwak i tinan le gwek, ma winiya kolau ha-un bala winiyan ja bwe. ");
INSERT INTO lid_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ari ndramak winiyan basukuni waen ha-un bala bolo ku-i me malen bwe. Buku none iy amekes i buku doh, waen doh kameh tuburok, ma kohan kameh tarani ku-i me nane, ma waen kamou ma iu laleyah; ma ku-i me ale kameh andra-i. ");
INSERT INTO lid_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Arile, waen ha-un badeh, ki bolo ku-i me ale ma bweseken kahis le.” ");
INSERT INTO lid_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Eme iy anya, “Ma idah kameh, iri lau ndra-un waen malen kameh bwale iri a-un waen mamakahis le, tasah iri anya waen malen badeh, simidin.” ");
INSERT INTO lid_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ano, udu bolo len ari ta amunyau, Jises hawe oro lau tan adek bolo bilin ari ta wit. Eme oro lau tan abwe-eh buwa wit nane dah, ano oro bosowa udu bolo mine oro, ano oro aimon. ");
INSERT INTO lid_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Eme oro lau rayah ta Parasi anya, “Tasah handru ado abwe-eh buwa wit na len ta amunyau? I buku sah ado ba-en hamon ta kandriyen tahi bwe?” ");
INSERT INTO lid_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Eme Jises asumon iri i buku doh, “Buku sah handru ya ado abolosen eme tek ma hawe oro lau tek? Sebwe ado babudon bamwenen ta kundruh ta lakou mene kabin Debit mesekei bwena bwe nadeh? Jo asehek ta lakou kala Debit hawe oro lau tan mene amak son. ");
INSERT INTO lid_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ya, iy ili bolo asiu ta Kindrei; ya iy andrei jabi ramen nane iri pris ndraleheyaniy ndrala ta mada Kindrei, in bolo bosoh ndrabun handru doh. Debit hawe oro lau tan aniy, arile jabi ramen doh ndrabun handru ta oro aimon. Iri pris le winiyan ta aimon.” ");
INSERT INTO lid_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ano Jises edeu sendrehendreh i buku doh, “Jo Nadu Ndramak Awas, ya jo tama len ta amunyau.” ");
INSERT INTO lid_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ano na len ta amunyau ari ja badeh, Jises ili leheya sahou udu bolo asiu ta atukum tiri Juwis. Eme ndramak ari udu aliy, minen salin imek. ");
INSERT INTO lid_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ya iri Parasi, ma hawe iri lau ta leheya kandriyen tiri Juwis badeh, takaleh madasan ta kadeu Jises ki ta mada sahou. Eme iri atehei mada iri udu tan, i buku iy kamesekei ndramak dah kamwenen na len ta amunyau dah, deh bwe. ");
INSERT INTO lid_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Arile, Jises ndratanan budon toro, eme iy tiye i ta ndramak minen imek dah anya, “Ou are loke mada lau mari dah!” Eme ndramak minen imek dah, suri iy ere loken. ");
INSERT INTO lid_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ano Jises lelen oro, “Jo anya kandremenya ado, saba kandriyen mwasin kameh taha kamekes na len ta amunyau? Kamekes kandriyen mwasin ta aseben koha lakou deh, bwe kamekes kandriyen ndra-in ta adai lau?” ");
INSERT INTO lid_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ano, Jises anyolom ili eme i toro mari, ano iy tiye i ta ndramak minen imek dah anya, “Minem kales!” Eme iy talasei minen ma minen ndramwenen ja. ");
INSERT INTO lid_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Arile, bwai, ndrine oro badeh, isi handru, eme oro asehek nyala oro ari ari, ta saba madasan handru, oro kamekes ki bada Jises. ");
INSERT INTO lid_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ano len ari, Jises iu i kabede-e mandrei, ma iy udu gwek ben ari, amekes salom i ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ano kon aleu, iy luhi oro lau tan ame badeh, iy lebelei oro ronoh la-uh, badu bolo oro ame len, eme iy tondrohani nyara oro badeh, i aposel. ");
INSERT INTO lid_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ya oro badeh: Saimon (udu ja, iy aloh iy Pita), ano nadu tinen Enduru; ano Jemis, ano Jon, ano Pilip, ano Batolomiu, ");
INSERT INTO lid_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ano Metiu, ano Tomas, ano Jemis nadu Alpeyus, ano Saimon aloh Selot, ");
INSERT INTO lid_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ano Judas nadu Jemis, ma hawe Judas Iskariyot, ndramak kameh ta edeu sa-oh. ");
INSERT INTO lid_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ano, iy eme andri hawe oro, ales udu bwele-e munyak nyemesen. Ma hawe iri lau tan solo-an handru ado aliy. Ma ale, iri lau buku liliy badu loboho Judiya, badu loboho Jerusalem, ma hawe lau badu loboho mada ndras ta kon tinan Tair hawe Saidon nane an doh ale. Iri ame badeh, anya kanuhun Jises asehek sahou, ma hawe iri atiye iri lau sik udu tiri ame hawen, ta iy kamekes iri kamwenen. ");
INSERT INTO lid_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ma iri lau ala malawin ndra-in udu la-u iri ale, iy mesekei iri amwenen ja. ");
INSERT INTO lid_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Eme ma iri lau solo-an anya kateu le badan, tasah nyaraha boto-on ta Jises eme len ma mesekei iri mari amwenen ta sik tiri. ");
INSERT INTO lid_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ano mada Jises anyolom oro lau tan badeh, ma iy tiye anya: “Ou are lau ou lakou bwe badeh, ou sekesek. Tasah, lakou udu baha tondrok ta Kindrei kameh, tam. ");
INSERT INTO lid_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ou are lau, ou ameson badeh, na dah, ou sekesek. Idah kameh, ou adih handru. Ou are lau ou taya na dah, idah kameh, ou sekesek. ");
INSERT INTO lid_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ou are lau, iri lau amekes budon ndra-in i tam, ya iri bwale iri ou, hawe iri aluhe, ma hawe iri kaloh ou anya malawin ndra-in udu la-um badeh, ou sekesek, tasah ou badeh, an hamon ta Nadu Ndramak Awas! ");
INSERT INTO lid_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ou sekesek ma ou sandroh ta sekesek i buku lakou doh, katok badam, tasah ndramas mwasin ta lakou doh kameh abe-en ou udu kandrah. Tasah, iri doh mene tubu iri amekes i buku aliy, ili tiri propet. ");
INSERT INTO lid_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Arile, ado lau tado lakou solo-an mada ado kaleu! Sisi-in tinan labai kameh ewek bwele-e ado, tasah len ta sekesek mari tado mene ndrano! ");
INSERT INTO lid_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ya ado lau bameson bwe kede-eh, mada ado kaleu! Sisi-in tinan labai kameh ewek bwele-e ado, tasah ado kameh akohok andra-i labai ta son. Ya ado lau ta abasa kede-eh, mada ado kaleu! Sisi-in tinan labai kameh ewek bwele-e ado, tasah idah kameh ado aden ma taya. ");
INSERT INTO lid_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ma, mada ado kaleu, i buku none oro lau kamasiye ado, ya ado anya, ado le ai. Idah kameh sisi-in tinan labai kameh ewek bwele-e ado. Idoh, i buku none tubu oro mene amekes, anya oro badeh, propet handru. Arile, bwe. ");
INSERT INTO lid_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Arile, jo katiye tado, are lau anuhun bohok dah: Ado badeh, kaseken iri lau amekes budon ndra-in ewek tado. Ma hawe ado ale, kamekes kandriyen mwasin ki toro lau ala budon ndra-in toro udu tado, ");
INSERT INTO lid_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ma hawe ado ale kamekes salom ki ta Kindrei kanyosowani oro lau ala aten ado, hawe oro lau ala amekes bolo manyah tado, udu ndra-in. ");
INSERT INTO lid_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Ki buku none ari ndramak kubwi lim ki kapam badeh, ou tubuni bilisiu kili ja, iy kubwiy ale; ya ki buku none iy kandrei awin tam, badeh ou atehei awin tam lawe-en kili ale. ");
INSERT INTO lid_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Ya ki buku none are lau kandremenya ou ta ari lakou tam kili tan, mwasin, ou atehei kili tan. Ya ki buku none are lau kandrei lakou tam badeh, ou sandrek same hamon ja. ");
INSERT INTO lid_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Saba lakou ou aseken iri kamekes kewek tam, badeh, ou amekes ki tiri ki le buku aliy. ");
INSERT INTO lid_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ya, buku none ou aseken oro lau le nane aso-ok ou; idah kameh, ou winiyan akohok nyosowan ta aliy i buku sah bah? Ya iri lau ta karei ma lomondra ndra-in badeh, aseken le iri lau ala amekes kandriyen ndra-in i le buku iri. ");
INSERT INTO lid_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ou winiyan bakohok nyosowan laleyah bwe, i buku none ou aseken le iri lau amekes mwasin le ewek tam. Iri lau ta karei ma lomondra ndra-in amekes ale i buku aliy. ");
INSERT INTO lid_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma i buku none ou aseken ta adeu lakou i ta lau mwasin tam le; tasah ou badeh, aseken ta akohok bundruwen keme hamon. Idah kameh, ou winiyan bakohok nyosowan laleyah ta aliy bwe! Iri lau ta karei ma lomondra ndra-in badeh, amekes i buku aliy ale. ");
INSERT INTO lid_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ndri-iy labai! Ou badeh, aseken iri lau ta amekes bahun i badam, ma ou amekes mwasin i tiri; ya buku ou adeu lakou, ou sabudon ta bundruwen. Badeh, ou kameh akohok ndramas mwasin labai, ma idah kameh ou asahan nadu Kindrei handru badu loken. Tasah, iy badeh, amekes mwasin i bada iri ta adeu wurah bwe, hawe lau ta kandriyen ndra-in ale. ");
INSERT INTO lid_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ou badeh, ki ndramak ta tikisiy, i buku none tamam Kindrei le.” ");
INSERT INTO lid_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ou satiye kandriyen ta ndramak ari ari; ya, ou winiyan bare ta mada sahou tinan bwe; ou samekes sahou boto-on sala ta lau, ya idah kameh, Kindrei bamekes sahou boto-on bawek tam bwe. Ou mani kandriyen ndra-in tiri, ya idah kameh, Kindrei ale, mani kandriyen ndra-in tam. ");
INSERT INTO lid_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ou anyohan iri lau lakou, ya idah kameh, Kindrei anyohan ou ale. Ma hawe bundruwe lakou tam eme hamon kameh solo-an labai, ma amou i andri, ma idah kameh, bolo asiu idih na aliy. Idah kameh, ou akohok bundruwe lakou tam, eme hamon kameh in hamon ta bundruwe lakou tam mene. I buku none ou adeu lakou solo-an, idah kameh, ou akohok bundruwe lakou tam in hamon ta lakou tam solo-an. Ya i buku none lakou tam solo-an bwe, idah kameh, ou akohok bundruwe lakou tam i le buku aliy.” ");
INSERT INTO lid_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jises ale tiye sahou sokek i toro, “I buku none ari ndramak madan bwe anya kaleheya san ki ta ndramak ari ja madan bwe ale, sebwe uru ma la-uh kameh taku a bolo lek nadeh? ");
INSERT INTO lid_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ado kanuhun. Ari ndramak ta akohok tanan basakalawi ndramak ta leheya iy bwe. Arile, i buku none ari ndramak ta akohok tanan asahan buku ndramak ta leheya iy, mwasin. ");
INSERT INTO lid_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“I buku sah handru, ou nyowonya mutahu kei udu mada nadu tinem ari ja, arile ou batona sobola kei ranah buruwen udu madam bwe nadeh? ");
INSERT INTO lid_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","I buku sah handru, ou tiye ili ta nadu tinem ari ja i buku doh, ‘Nadu tine, jo kandrei mutahu kei ranah buruwen udu madam keme len,’ arile len mari ou batona sobola kei ranah buruwen udu bolo madam bwe? Ou lau ta wasai, ma bwena ou andrei sobola kei udu bolo madam keme len op, ano ou kameh anyolom amwenen handru ta akohok mutahu kei udu mada nadu tinem ari ja eme len. ");
INSERT INTO lid_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Kei mwasin badeh, winiyan bato-ou buwa kei ndra-in bwe. Ma kei ndra-in badeh, winiyan bato-ou buwa kei mwasin bwe. ");
INSERT INTO lid_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Taha winiyan akohok tanan badeh, udu ta buwa kei ari ari ato-ou. Ya malou bobodon ndra-in badeh, winiyan bato-ou buwa kei pik bwe, ma malou kakarik badeh, winiyan bato-ou buwa waen bwe. ");
INSERT INTO lid_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Idoh badeh, moson i buku doh: Buku none ndramak mwasin ma budon mwasin solo-an idih ereu ndrinen, idon adeh, iy ale amekes kandriyen mwasin ale. Iri lau ndra-in, tiri budon ndra-in solo-an ereu ndrine iri, ma iri ale amekes kandriyen ndra-in le. Tasah, boho ndramak badeh, asehek iri budon solo-an ale idih ereu bolo ndrinen. ");
INSERT INTO lid_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ado aloh jo badeh, ‘Laban, Laban’ ta laleyah le, arile ado ba-en hamon ta sahou tek bwe. ");
INSERT INTO lid_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Arile, jo winiyan leheya ado ta saba san, i buku ari ndramak keme hawek kanuhun sahou tek, ma iy ki-in hamon ta aliy. ");
INSERT INTO lid_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Iy badeh, i buku none ndramak a-eh ndru ta asiu tan udu bada ndren boto-on. Ya eme na len ta wadah atohou badeh, batoho-ei asiu tan bala andri bwe. Tasah, ndru-u asiu tan badeh, boto-on. ");
INSERT INTO lid_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Arile, i buku none ndramak anuhun sahou tek ya eme iy ba-en hamon ta aliy bwe; badeh, iy i buku none ndramak atah asiu tan udu bwele-e ndren laleyah, ya ndru bala andri handru bwe. Ya eme wadah anya katohou, asiu tan taku i andri, ma atokos andra-i labai.” ");
INSERT INTO lid_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jises asehek sahou tan i tiri lau doh ano, iy edek eme isos Kapena-um. ");
INSERT INTO lid_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Eme ndramak batun tinan ta atondrok lau ta bahun udu Kapena-um ale. Iy ma hawe ndramak ta lohowan tan, ma lohowan tan doh badeh, iy aseken iy tinan labai. Arile, iy badeh, ibo sik ma iy anya kimek. ");
INSERT INTO lid_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Eme ya, batun ta atondrok iri lau ta bahun anuhun Jises ndrame. Ya eme iy suni oro lau-en rayah badu Juwis badeh, ala anya katandra-un Jises keme kamekes lohowan tan dah, kamwenen. ");
INSERT INTO lid_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Eme oro ala asahan hawe Jises ma oro tiye sahou boto-on i tan anya, “Jises, ndramak ta atondrok iri lau ta bahun doh badeh, mwasin labai, ya iy aseken seben tam. ");
INSERT INTO lid_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Iy ndramak doh badeh, aseken taha labai, ma iy mene tahi asiu ta tukum tataha.” ");
INSERT INTO lid_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ano Jises i hawe oro ili. Ya eme Jises bala mirihik ta asiu bwe le badeh, tinan ta lohowan dah, suni lau rayah ja ala tiye i tan: “Laban, ou sala mirihik ta asiu tan, tasah iy anya, iy ndramak ndra-in, iy winiyan baseken ou ta ala bolo asiu tan bwe. ");
INSERT INTO lid_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Eme ya iy salin amwenen bame batou ou bwai. Arile iy anya, ou sala, ou asehek le sahou, ya lohowan tan kamwenen ja. ");
INSERT INTO lid_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tasah, iy amwenen asehek anya iy badeh, udu bahandra boto-on ta batun tinan ta tondrok lau mari ta bahun, ma iy badeh, tan lau rinek (100) ta bahun ale ado bahandran. I buku iy katiye ki ta ari lau anya, ‘Ou ala,’ idah kameh iy ilih. Ya i buku iy katiye anya, ‘Ou ame,’ idah kameh iy eme. I buku none iy katiye ki ta ndramak ta ndrahu so-ok tan anya, ‘Ou bwidi lahou doh,’ ya idah kameh iy bwidiy.” ");
INSERT INTO lid_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ano Jises anuhun sahou doh, manin atur ta aliy. Eme iy tubuni batalan eme hamon, i tiri lau solo-an an hamon tan nane dah badeh, ma iy tiye anya, “Jo katiye tado kamwenen, jo bandruni ari lau badu Isra-el tan budon tinan bala buku iy lau dah bwe.” ");
INSERT INTO lid_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ano oro lau nane ala iy suni oro ame dah, ala hamon ala asiu badeh, anyolom lohowan nane doh, ndramwenen ja. ");
INSERT INTO lid_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ano udu sese badeh, Jises hawe oro lau tan ma hawe iri lau mari nane are hamon tan badeh, ala kon tinan ari aloh Na-in. ");
INSERT INTO lid_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Eme iy ili mirihik ta madasan tinan ta ili bolo kon le badeh, iri bwese-ei nadu badih nyau ari badeh, ndramak in bada sau eme. Eme ya iri lau solo-an ale badu kon tinan an hawen ame. Badih nyau doh badeh, nadun mwan ari le doh, kabwe. ");
INSERT INTO lid_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Eme Laban Jises anyolom iy ma iy tikisi badih nyau dah, tinan labai. Ya eme Jises tiye i tan, “Balem sasin.” ");
INSERT INTO lid_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ano Jises edek ili badeh, atehei minen i bwele-e ndramak nane, iri su-i iy ma bwese-ei iy dah, eme iri ado rasi. Ano Jises tiye i ta ndramak loweu nane dah, anya, “Jo tiye tam, ou amak!” ");
INSERT INTO lid_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Eme ndramak loweu dah, suri iy ma iy asehek sahou. Ano Jises atehei iy i hawe tinen. ");
INSERT INTO lid_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Eme iri lau mari badeh, boho iri asak ma iri atudun Kindrei. Ma iri anya, “Propet tinan ndrasahan bolo taha. Eme Kindrei badeh, ndrame ta aseben iri lau tan.” ");
INSERT INTO lid_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Eme ya sahou ta nyala Jises badeh, aseker ili bolo Judiya ma hawe aseker ili bolo kon tinan mirihik ale. ");
INSERT INTO lid_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ano, oro lau ta Jon ame asehek nyalan, ta lakou mari oro nane anyolom. ");
INSERT INTO lid_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Eme Jon luhi uru lau tan la-uh ame, ano iy tiye i turu, “Ah kala hawe Laban badeh, kandremenya iy ki buku doh, ‘Sebwe ou ndramak aloh Krais, Kindrei mene tandrakan ta iy kameh suni iy eme. Buku none bwe, sebwe ahi kabe-en ndramak ari ja nadeh?’” ");
INSERT INTO lid_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Eme uru ame hawe Jises, ma uru anya, “Jon ta alomwa badeh, suni aru ame dah ta ndremenya ou, ‘Sebwe ou ndramak aloh Krais, Kindrei mene tandrakan ta iy kameh suni iy eme. Buku none bwe, sebwe ahi kabe-en ndramak ari ja nadeh?’” ");
INSERT INTO lid_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na len doh badeh, amwenen ta Jises amekes sik udu tiri lau iu, hawe amekes iri lau malawin ndra-in udu la-u iri iu ale. Ma hawe iri lau batou kon bwe, atou kon ja. ");
INSERT INTO lid_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Eme Jises asumon boho oro i buku doh, “Ah kala hamon katiye ta Jon ta saba lakou ah ndratou, ma ndranyolom dah: Iri lau mada iri bwe, iri atou kon ja, ya iri kati iri ndra-in iri adek ja, ya iri lau lepra udu tiri, bada iri asahan amwenen, ya iri lau ndranye iri banuhun kon bwe, iri ndranuhun kon ja, ya iri lau ndramak, iri ndrasahan ndrame awas ja, ma hawe sahou ta nyala sahou mwasin badeh, ndratiyaniy ndrala bolo iri lau, lakou bwe. ");
INSERT INTO lid_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Eme ya, sekesek ki toro lau heh le nane bataku ta budon toro bwe, tasah ta jo le.” ");
INSERT INTO lid_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ano uru lau ta Jon ma la-uh au ala hamon. Eme Jises asehek i tiri lau ta nyala Jon, “Buku sah, aha mene ala kon lomale an, anya katou sasah? Ari bwidiu awa-is nyukunyok ereu bolo jor neh? Sebwe, bwe nadeh! ");
INSERT INTO lid_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ya ado ala atou sah? Ndramak ari atehei awin mwasin ereu badan? Bwe oh! Iri lau ta adeu kolau hawe awin nyikilikin badeh, ado kon ta ndrahu kabin. ");
INSERT INTO lid_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Eme ya ado ala anyolom are lau? Sebwe ado anya kala kanyolom propet? Ehe, ado atou iy, ma jo katiye tado kamwenen, iy badeh sakalawi iri lau mene ta atiye boho Kindrei ndra-au ndra bwena. ");
INSERT INTO lid_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Eme sahou torowenei udu bolo buk ndrabun tiye i buku doh, ‘Jo kameh suni ndramak ari ewek bwena tam. Iy kameh atehe san tam.’ ");
INSERT INTO lid_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Eme jo katiye kamwenen kewek tado, Jon badeh, sakalawi iri lau mari tine iri tuwi iri ereu kon munyak eme kala dah. Arile, are lau nyaran bwe, udu baha tondrok ta Kindrei eme kameh sakalawi nyara Jon ja.” ");
INSERT INTO lid_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Eme iri mwan ma badih hawe iri lau ta akohok luk ta takis anuhun sahou Jises asehek ma oro barala tanan ai, sahou ta Kindrei badeh, mwasin handru. Tasah, oro mene, Jon ndranyu oro. ");
INSERT INTO lid_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Arile, iri Parasi hawe iri lau ta tanan ta kandriyen tiri Juwis ndra-au mene, baseken budon ta Kindrei bwe, ya eme Jon badeh, banyu iri bwe. ");
INSERT INTO lid_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Eme iy asehek ili le, “Ya jo kasehek iri lau na len dah ki buku sah handru? Iri ki buku are handru? ");
INSERT INTO lid_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Iri badeh, i buku none le iri nah nadu bwisik manyah areu mada ba-en. Ra-on arah i ta ra-on i buku doh, ‘Aso oloh bala eu ta molak ewek tado, arile ado bada mana bwe; ya aso ayah wari ta kabek, arile ado bataya bwe.’ ");
INSERT INTO lid_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tasah, kala Jon mene eme, iy abeles iy ta nyamon ta iy kedeu budon tan boto-on kili ta Kindrei, ma iy ba-un gwa waen bwe, eme ado anya, iy badeh, malawin ndra-in ereu la-un! ");
INSERT INTO lid_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ya, jo Nadu Ndramak Awas, jo eme aimon nyamon ma a-un gwa waen hawe iri lau. Eme ma ado asehek jo i buku doh, ‘Aden, ado katou iy ndramak ta aimon nyamon tinan, ma iy ndramak ta a-un gwa waen solo-an labai. Iy ndramak ndra-in labai. Tasah handru iy amekes kawas hawe iri lau ta akohok takis, ma iri lau ba-en hamon ta batanau ta Moses bwe?’ ");
INSERT INTO lid_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ehe, iri amekes sahou i buku doh. Arile, are lau mwan ma badih ale idih ta tanan mwasin ta Kindrei, ya iri lau kameh atana iri buku none ndramak doh asahan nadu Kindrei handru.” ");
INSERT INTO lid_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ano Parasi ari eme badeh, tiye Jises na beyeh ili aimon nyamon ili asiu tan. Eme iy ili manyah, udu andri ndrahu nyamon udu asiu ta Parasi dah. ");
INSERT INTO lid_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Eme ya badih ari ta madasan udu kon tinan doh badeh, anuhun Jises badeh, udu asiu ta Parasi aimon nyamon. Eme iy andrei bwisi ndrau ari suluw, ");
INSERT INTO lid_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ya eme iy ili ales udu hamon ta kati Jises eden, ma amekes wa-i madan i kona katin. Ano iy o-ou kona kati Jises na lami batun, ano iy aluh i andri atehei no-on i kati Jises. Ano ja, iy asolou ndrelekei i bwele-e katin. ");
INSERT INTO lid_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ya eme ndramak nane andrei Jises i asiu tan doh, anyolom badeh, iy lomondra udu budon tan anya, “Ki buku none ndramak kede-eh, ki ari propet, idah nane, iy ndratona i badih anyokar katin kede-en adeh? Ma iy ndratanan badih doh badeh, ta madasan adeh.” ");
INSERT INTO lid_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Eme Jises tiye i ta Parasi doh anya, “Saimon, jo tek sahou udu tam.” Eme ya Saimon anya, “Sasah, ndramak ta leheya, ou tiye tek.” ");
INSERT INTO lid_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Eme Jises anya, “Uru lau la-uh badeh, andrei luk rayah ta ndramak ari atehei i mine uru. Iy ari badeh, andrei rawa (K100), ya iy ari ja, andrei rinek (K10). ");
INSERT INTO lid_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Eme udu, uru ma la-uh badeh, winiyan batehei saluwe luk ta ndramak doh, bala hamon bwe. Ya eme tama luk doh, anya ndri-iy ai, bale ah kamaniy ai. Eme ya, Saimon, ou abudon are handru kameh aseken tama luk tinan labai.” ");
INSERT INTO lid_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Eme Saimon anya, “Ta budon tek badeh, ndramak nane andrei luk solo-an.” Eme Jises anya, “Ou seleya badeh, amwenen.” ");
INSERT INTO lid_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ano Jises tubuni batalan i ta i badih dah, ano Jises tiye i ta Saimon, “Ou ndratou badih dah amekes lahou dah? Jo eme asiu tam nane, ou badeu gwa ta sikine katik bwe. Arile, iy badeh, sikine katik na wa-i madan ma owei abosar na lami batun. ");
INSERT INTO lid_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ou badeh, basekesek jo bwe, arile jo eme asiu le badeh, badih doh, baruwani no-on ta katik bwe le. ");
INSERT INTO lid_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma ou badeh, basolou suluw bala batuk bwe, arile iy badeh, asolou suluw i kona katik. ");
INSERT INTO lid_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Eme jo katiye tam kamwenen, karei tan mari badeh, ndrasikine ndrano ndra-au, tasah iy badeh, leheya kandriyen ta tikisiy tinan labai. Ya eme, are lau bala tanan ta iy, bamani karei tan ba-au bwe, iy ale winiyan batikisi ari ndramak bwe le.” ");
INSERT INTO lid_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ano Jises tiye i ta badih dah, “Kabwe, karei tam ndrasikinei ndra-au.” ");
INSERT INTO lid_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Eme iri lau rayah nane aimon nyamon hawe oro asehek i toro ari ari anya, “Are ndramak kede-eh? Iy leheya anya iy winiyan sikine karei kede-eh?” ");
INSERT INTO lid_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ano Jises tiye i ta badih dah ja, “Ou au ma ou sabwerei, tasah budon tam handru le, sebenei ou.” ");
INSERT INTO lid_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Eme idoh ano badeh, Jises edek ili eme bolo iri kon tinan mari, hawe ili bolo iri kon bwisik mari, atiye sahou mwasin ta Kindrei aso-ok iri lau mwan ma badih, ma iy aso-ok iri kame baha tondrok mwasin ta Kindrei. Ma hawe oro lau tan ma ronoh la-uh badeh, ado hawen, ");
INSERT INTO lid_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma hawe oro badih rayah ale mene Jises amekes sik hawe malawin ndra-in udu bwele-e oro iu badeh, ado hawen ale: Oro badeh, Mariya badu Makdala, iy mene ale malawin ndra-in ma ndro taloh ado la-un ame len; ");
INSERT INTO lid_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ya Jo-ana, udu ndramak ta atondrok asiu ta Herot nyaran Kusa; ya Susana hawe badih rayah ja. Oro badih doh badeh, adek hawe oro adeu lakou toro amwenen i ta sisih, akohok luk ta aseben oro. ");
INSERT INTO lid_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ano udu, iri lau solo-an badu kon tinan ari ari atukum ame hawe Jises, eme iy tiye sahou sokek ari i tiri i buku doh: ");
INSERT INTO lid_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Na len ari badeh, ndramak ari ili sabara badu wit ili bolo bilin. Iy akeh ili, badu wit ra-on taku in san; eme ya iri lau adek la-un ma hawe iri sirih atah ame aniy. ");
INSERT INTO lid_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ya rayah badeh, taku in bwele-e bek, ano eme apwak, ano awa-is, tasah munyak sese le in bwele-en. ");
INSERT INTO lid_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ya rayah ja badeh, taku udu bolo malou bobodon nane ateh eme loken, ma tubuluhi wit nane ma iy bato-ou buwan bwai. ");
INSERT INTO lid_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ano rayah ja badeh, taku ili bolo ndren mwasin. Eme ateh eme loken, ato-ou buwan solo-an; ya ra-on ja badeh, ato-ou rinek (100).” Eme iy tiye doh ano badeh, iy aloh anya, “Ou are lau ndranyem udu aliy, ou anuhun.” ");
INSERT INTO lid_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ano oro lau tan ndremenya Jises, ta moso sahou sokek nane doh. ");
INSERT INTO lid_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Eme iy anya, “Kindrei aseken ado lau tek katanan iri sahou mene aton ta nyala tondrok ta Kindrei. Arile, i tiri lau buku liliy badeh, jo asehek i san ta sahou sokek. Eme ya, ‘Iri kameh anyolom anyolom ja, arile iri winiyan baseleyani bwe; ya iri anuhun amwenen, arile batu iri winiyan baleu ta aliy bwe.’” ");
INSERT INTO lid_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Ano Jises tiye, “Sali sahou sokek asah i buku doh: Buwa wit badeh, moson i buku sahou ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ya oro buwa wit taku udu san badeh, i buku none lau rayah ai. Oro doh badeh, anuhun sahou ta Kindrei, arile balik eme kuhi iu sahou mwasin Kindrei tahiy ereu budon toro, eme ya oro satehei budon toro handru sa-en ta sahou. Koro-an sahou doh, kasebenei koha oro kudu mwasin. ");
INSERT INTO lid_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ya buwa wit taku udu bwele-e bek badeh, i buku none lau rayah ai. Oro doh badeh, sekesek ta anuhun sahou ta Kindrei, arile kandro oro badeh, barih bala andri handru bwe. Ya oro badeh, atehei budon handru, arile bado luwen bwe, eme ya buku none ndrine sen asahan deh, ndra-i asahan toro badeh, oro taku. ");
INSERT INTO lid_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ya buwa wit taku udu bolo malou bobodon badeh, i buku none oro lau doh, anuhun sahou ta Kindrei, arile oro ado badeh, abudon boto-on ta lakou solo-an badu kon munyak. Ya oro abudon boto-on labai ta atukum iri luk, ma hawe bale oro asin ta kandriyen badu bada oro tinan labai. Eme ma, oro badeh, buni ta budon bwe. ");
INSERT INTO lid_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Arile, buwa wit taku udu munyak mwasin badeh, i buku oro lau anuhun sahou ta Kindrei, eme oro tawi sahou doh, udu ndrine oro ihis labai, ma udu le udu, oro ato-ou sali oro mwasin. ");
INSERT INTO lid_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Ki buku ari ndramak katelem sun, iy winiyan batone bado bolo sabok bwe, ma iy ale winiyan batehei bala baha sau bwe. Iy kameh suriniy udu loken. Ya, i buku none are lau eme anyolom kameh iy eme asiu. ");
INSERT INTO lid_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Eme ya lakou mari aton badeh kameh asahan eme lewan. Ma saba lakou tubuluhiy kameh asahan eme lewan ale. ");
INSERT INTO lid_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Eme ya, ou lomondra kamwenen ta sahou ou anuhun ma an hamon ta aliy. Ndramak tanan tan mwasin udu aliy, iy kameh akohok tanan mwasin labai ja i la-un. Ya eme, are lau anya iy tan tanan sese udu aliy, idah kameh, tanan sese le doh kameh kuhiy mari iu.” ");
INSERT INTO lid_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ano, tine Jises hawe nadu tinen oro ame anyolom iy, arile lau solo-an labai ya oro winiyan bala mirihik tan bwe. ");
INSERT INTO lid_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Eme ndramak ari ili tiye tan anya, “Jises ei, tinem hawe nadu tinem oro ales ado manan, anya katou ou.” ");
INSERT INTO lid_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Eme Jises tiye i tan anya, “Tine hawe oro nadu tine handru asah oro are hawek anuhun sahou ta Kindrei, ma oro amekes lahou ta aliy dah.” ");
INSERT INTO lid_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ano na len ari ja badeh, Jises tiye i toro lau tan anya, “To ka-au kala kapa gwa bilisiu kodo-oh.” Eme oro sandroh a ndron ra-ei badeh, ma oro alakak ala bilisiu. ");
INSERT INTO lid_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Eme oro alakak ala badeh, Jises ndramadin. Eme laba jor atohou eme andri bwele-e gwa li, ya bayau i tinan ma eme ndron, eme ya oro akohok andra-i labai. ");
INSERT INTO lid_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Eme oro lau tan ala badeh, mete-ei iy anya, “Laban, Laban, to dah kameh atuh ma amak ai!” Ano Jises suri iy eme loken, tiye sahou boto-on i ta jor hawe bayau, ma jor amondrei hawe bayau ameres. ");
INSERT INTO lid_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ano iy tiye i toro, “I deh, budon tado handru ndraheh?” Eme oro anoh, hawe mani oro atur, ma oro tiye i toro ari ari anya, “Iy are lau handru kede-eh? Iy tiye sahou boto-on le badeh, jor hawe bayau anuhun bohon!” ");
INSERT INTO lid_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ano, oro alakak ala loboho Gerasa. Kon doh, udu bilisiu ta Galili. ");
INSERT INTO lid_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Eme Jises sandroh i babi le badeh, ndramak ari badu kon tinan doh, iri malawin ndra-in udu la-un eme hawen. Ya ndramak doh badeh, ndra bwena ndra-au badeh, iy ndrakane le. Iy badeh, ari asumwen bwe, asumwen badeh, munu bek ta ndrahu lau amak ala aliy. ");
INSERT INTO lid_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Eme iy atou Jises le badeh, iy anyar ma aluh i andri udu mada Jises ma iy aloh i tinan i tan anya, “Jises, Nadu Kindrei badu loken, ou anya amekes sasah keme tek? Ndri-iy, ou samekes sisi-in same badak!” ");
INSERT INTO lid_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Iy aloh i buku doh, tasah Jises badeh, ndratiye sahou boto-on ndra ta malawin ndra-in ta anya keme len. Ya malawin ndra-in badeh, ndrahas ndrado la-un luluwen labai. Iri sawei minen hawe katin na sen, ma lau ta ndrokei atondrok iy, arile iy mindrindri sen, eme malawin ndra-in lolowa iy ili kon lomale an, ili bolo ndrokowa bek. ");
INSERT INTO lid_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Eme Jises ndremenya iy, “Nyaram are lau?” Eme iy anya, “Nyarak badeh, Solo-an.” Tasah, malawin ndra-in solo-an ndrado bwele-en badeh nyaran bwe. ");
INSERT INTO lid_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Eme oro asehek sahou ta tikisiy i ta Jises i buku doh, “Ou satikahei aso sala bolo lek ta isi.” ");
INSERT INTO lid_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Eme udu loboho doh badeh, bou rakou aimon nyamon are ka-u mandrei. Eme oro tiye sahou ta tikisiy i ta Jises anya, “Ou tikahei aso kala bwele-e iri bou nane doh.” Eme ya Jises tiye le badeh, ");
INSERT INTO lid_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","oro malawin ndra-in are la-un ame len, ma a bwele-e iri bou. Eme oro sakaliye are bwele-e mandrei ame andri ala bolo gwa li, ma oro amak. ");
INSERT INTO lid_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Eme oro lau ta atondrok iri bou anyolom lakou doh asahan ma oro atobwak au a kon tinan ma hawe a lokei asehek i tiri. ");
INSERT INTO lid_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ya eme iri lau ala anyolom. Iri ala asos hawe Jises le badeh, iri atou iy ndramak nane malawin ndra-in mene udu la-un ndramwenen ja. Iy ndratani kolau hawe budon tan ndramwenen ya iy manyah udu kati Jises. Eme ma iri anoh. ");
INSERT INTO lid_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ano iri lau nane anyolom dah, ala asehek tiri lau ta nyala ndramak mene malawin ndra-in udu la-un badeh, ndramwenen ja. ");
INSERT INTO lid_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ano iri lau badu loboho kon Gerasa tiye Jises ta ki-iu, tasah iri badeh, anoh boto-on tan. Eme ma Jises sandroh i ndron ma anya ki-iu ai. ");
INSERT INTO lid_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Arile ndramak nane malawin ndra-in udu la-un eme tiye Jises ta iy anya ki hawen. Arile Jises eme tiye iy iu, ma asehek i tan i buku doh, ");
INSERT INTO lid_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ou ala kon asehek tiri ta nyala lahou tinan Kindrei ndramesekei ndrawek tam.” Eme ndramak nane dah, iu ili bolo kon tinan mari doh asehek ta nyala lahou tinan mene Jises ndramesekei i tan. ");
INSERT INTO lid_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ano Jises eme hamon le badeh, iri lau solo-an ame sekesek iy, tasah iri mene abe-en iy. ");
INSERT INTO lid_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ano, ndramak batun ari badu asiu ta ndrahu tukum tiri Juwis nyaran Jairus, iy eme aluh i andri udu kati Jises. Ano iy tiye sahou tikisiy i ta Jises i buku doh, “Ou ame asiu tek op.” ");
INSERT INTO lid_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tasah, nadun ari le badih, jaha tan badeh, ronoh la-uh, ya iy anya kimek. Eme Jises edek ili badeh, kon ndraso tiri lau ma sese le iri kandribitini iy. ");
INSERT INTO lid_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ya udu bolo iri nane doh badeh, badih ari udu aliy ya sik ndra badeh, udu tan winiya jaha ronoh la-uh. Eme ari lau badeh, winiyan bamesekei iy bamwenen bwe. ");
INSERT INTO lid_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ya eme iy badih nane dah, sokohani iy i ndrokowa iri lau ili in hamon ta Jises, eme iy tawi awin tan, ma se nawin bwe, sik ndra tan iu ma ano mara-ei. ");
INSERT INTO lid_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Eme Jises ndremenya, “Are lau tawi jo?” Ya eme iri bisiniy, ya eme Pita tiye i tan anya, “Laban, iri lau sola nane ahas badam badeh.” ");
INSERT INTO lid_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Arile Jises tiye, “Boto-on badu badak ewek len badeh, jo atona ndramak ari tawi jo.” ");
INSERT INTO lid_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ano badih dah ndraseleyani iri lau badeh, ndratanan, eme iy eme morohani iy i andri kati Jises. Eme ma udu mada iri lau mari nane iy asehek ta saba katin handru iy ateu bada Jises hawe i buku sah iy amwenen ja. ");
INSERT INTO lid_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ano Jises tiye sahou i ta badih nane dah, “Nadu badih, ou atehei budon tam handru in tek, ma mesekei ou asahan amwenen. Ou au ma ndrinem kamunum.” ");
INSERT INTO lid_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Eme iy asehek sahou kahis le, ndramak ari badu asiu ta ndramak ta batun eme tiye i ta Jairus; “Nadum badih ndramak. Ou sasehek sahou ja sala ta ndramak ta leheya badeh, ndri-iy.” ");
INSERT INTO lid_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Eme Jises anuhun le badeh, iy tiye i ta Jairus, “Ou sanoh; budon tam handru ki-in tek, ma idah kameh, nadum amwenen ja.” ");
INSERT INTO lid_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ano iy eme asahan asiu ta Jairus badeh, iy batiye ari lau bala hawen bala asiu bwe. Pita le, Jon le, Jemis le hawe taman uru tinen le badeh, ala bolo asiu hawen ai. ");
INSERT INTO lid_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ya iri lau badeh, aden hawe iri taya ndranyen. Eme Jises anya, “Aha kandru-uk, iy bamak bwe, iy badeh, amadin le oh.” ");
INSERT INTO lid_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Eme iri ehe-en iy, tasah iri tanan badih badeh, ndramak handru. ");
INSERT INTO lid_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Arile, Jises tawi mine badih imek dah, ma iy tiye, “Naduk, ou amak!” ");
INSERT INTO lid_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Eme kohan handru asahan ma iy suri iy. Ano ma Jises tiye oro adeu nyamon i nan. ");
INSERT INTO lid_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Eme ya taman uru tinen badeh, boho uru asak, arile Jises tiye turu i buku doh: “Ah badeh, sasehek ta ari lau, ndri-iy, ta nyala lahou asahan dan, ndri-iy labai.” ");
INSERT INTO lid_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ano, Jises luhi oro lau tan ma ronoh la-uh ame hawen, ano iy edeu boto-on i toro, ta atikah iri malawin ndra-in ka-au hawe edeu boto-on i toro, ta amekes iri lau sik udu tiri kamwenen. ");
INSERT INTO lid_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ano, iy tiye oro au ala atiye sahou mwasin, ta nyala tondrok ta Kindrei, ma kamekes iri sik kamwenen. ");
INSERT INTO lid_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Eme iy tiye i toro anya: “Ado sakohok kandro, ya ado sakohok kohei, ya ado sakohok jabi ramen, ya ado sakohok luk, ma hawe ado sakohok ari kolau ja, sawek hawe ado, na len ta tekedek tado. ");
INSERT INTO lid_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ya, i buku none ado kala kon tinan, ya buku ari lau kasumon ado badeh, ado kare asiu tan le kado gwek, winiya le ado barame len ta kon tinan badeh; ");
INSERT INTO lid_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ya, i buku none ado kala, ya iri lau basekesek ta akohok ado ala asiu tiri bwe, ya buku ado anya ka-au, ado katuruhi kasu on ma ndren ta kati ado ki-iu, ma ado ka-au. Ya eme ta kalem doh iri kalomondra ta kandriyen ndra-in tiri.” ");
INSERT INTO lid_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Eme oro ala kon ari ari, ala aliy atiye sahou mwasin, ma amekes sik tiri lau badu heh, badu heh, iu. ");
INSERT INTO lid_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Eme ya Herot Antipas ndramak ta atondrok Galili badeh, anuhun nyala lahou mari doh. Eme ndrinen badeh, amaha ta aliy, tasah lau rayah asehek anya, Jon ndramak ja ereu bolo lek ndrame loken, ");
INSERT INTO lid_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ya iri rayah anya ja, Alaija ndrasahan ja, ma hawe iri rayah anya ja, ari propet badu bolo oro bwena mene ndramak ja. ");
INSERT INTO lid_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Arile bwe, Herot anya, “Jo mene ndramwetehei batu Jon o! Ya are lau handru ja asahan dah?” Eme iy badeh, anya kanyolom ndramak doh. ");
INSERT INTO lid_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ano, oro lau tan ame hamon, ya oro asehek nyala Jises ta lakou mari oro amekes. Ano iy kuhi oro ala hawen ma oro ala kon tinan ari aloh Betsaida. ");
INSERT INTO lid_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Arile, iri lau badeh, ndrandrei budon tan, eme iri an hamon tan ala. Eme iy tiye sahou sekesek i tiri, ano iy asehek sahou ta nyala tondrok ta Kindrei, ma amekes iri lau sik udu tiri amwenen. ");
INSERT INTO lid_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ano kon abeyeh, oro lau tan ma ronoh la-uh ame tiye i ta Jises i buku doh, “Ou tiye iri lau kede-eh ka-au kala kon mirihik ma ndrahu iri kasilah niri nyamon, ma kasilah ndrahu iri ta matinou. Tasah, to dah bare kon bwe, to dah are kon laleyah!” ");
INSERT INTO lid_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Eme Jises tiye i toro, “Ado kadeu niri nyamon.” Eme oro anya, “Aso badeh, nyamon bwe, udu kada-ah badeh, limeh jabi ramen le, hawe la-uh ni. Ki buku none to kala kasih sola ja, keme hawen badeh, winiya iri ai.” ");
INSERT INTO lid_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iri lau badeh, i buku lamawa (5,000). Arile, Jises tiye i toro lau tan, “Ado badeh, katukumwi iri lau kase, lomonoh (50) kase, lomonoh (50) kase, ki le buku doh.” ");
INSERT INTO lid_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Eme oro lau tan mesekei i le buku bohon, ya eme oro tiye iri lau badeh, kamanyah ka-en andri. ");
INSERT INTO lid_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ano iy andrei jabi ramen ma limeh, hawe ni ma la-uh nane dah eme, ano iy anyolom iu i loken bolo kandrah, ma iy edeu wurah i ta Kindrei. Ano iy boso-ei jabi ramen dah. Ya eme iy edeu ili mine oro lau tan. Eme oro ala adeu ili winiya iri lau mari. ");
INSERT INTO lid_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Eme iri aimon ma ndrine iri idih. Ya tikibwah tiri erah, eme oro lau tan anyuhiy i bwak badeh, asahan ronoh la-uh. ");
INSERT INTO lid_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ano na len ari ja badeh, Jises hawe oro lau tan le ala rasi ja asolom. Eme iy ndremenya oro lau tan, “Iri lau anya jo are lau handru?” ");
INSERT INTO lid_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eme oro anya, “Iri rayah anya ou Jon ta alomwa, ya iri rayah anya ja, ou Alaija; ma iri rayah anya ja, ou badeh, oro ari propet mene ndramak ndrame loke ja.” ");
INSERT INTO lid_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Eme Jises ndremenya oro, “Ya ado amwenen anya jo are lau?” Eme Pita asumon iy i buku doh, “Ou badeh, Krais, Kindrei suni ou ame dah.” ");
INSERT INTO lid_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ma eme Jises batanau oro boto-on ta oro badeh, sasehek ta ari lau ndri-iy. ");
INSERT INTO lid_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ano iy tiye, “Nadu Ndramak Awas kameh akohok sisi-in solo-an labai, ma iri lau tinan areu bwena, hawe iri lau tinan tiri pris, ma hawe iri lau ta leheya kandriyen tiri Juwis kameh baseken iy bwe. Ma idah kameh, iri adai iy imek, ya len taloh ano iy kameh amak ja.” ");
INSERT INTO lid_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ano iy tiye i toro mari: “Buku none ari ndramak anya ki-in hamon tek, mwasin, iy kamani so-ok tan mari, ya iy kabwese-ei kei tondreh tan na len mari. Ya iy ki-in hamon tek. ");
INSERT INTO lid_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tasah, buku none ari ndramak anya katawi kohan kudu, kohan kameh ano. Arile, buku none ari ndramak abudon jo ya kohan ano, iy kameh winiyan andrei kohan ja. ");
INSERT INTO lid_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ya, buku none ari ndramak kuhi lakou mari badu kon munyak, ya iy kimek, iri lakou doh kameh sebenei iy i buku sah handru? ");
INSERT INTO lid_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ou are lau bwilim ama jo ma ta sahou tek, Nadu Ndramak Awas kameh bwilin ama tan ale, i buku none len hamon kameh, iy eme ma lomadan tan, hawe lomadan ta taman, ma hawe lomadan tiri angelo, lau ndrabun badu loken. ");
INSERT INTO lid_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jo asehek sahou handru ewek tado. Lau ra-on ales ereu bolo to dah kameh winiyan bamak bwe, ya iri kameh anyolom tondrok ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jises asehek sahou tan ano badeh, udu, ben ndru la-uh ano, iy kuhi Pita, Jon ma hawe Jemis a hawen, ma oro ala bwele-e mandrei ala asolom. ");
INSERT INTO lid_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eme iy asolom le badeh, badan asahan i randrah labai, bwilin anya ma awin tan badeh, nyikadin tinan labai, anya i buku kalik. ");
INSERT INTO lid_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Eme oro atou Moses uru Alaija asahan ma lomadan badu loken ame, asehek sahou hawen ta nyala imek kameh iy bwese udu Jerusalem. ");
INSERT INTO lid_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ya Pita hawe Jon uru Jemis badeh, ndramadin tuk, eme oro amak badeh, oro anyolom lomada Jises hawe lomada uru lau nane ales are hawen dah. ");
INSERT INTO lid_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Eme ya uru lau nane are hawe Jises anya ka-au le badeh, Pita tiye i ta Jises i buku doh, “Laban, mwasin handru ta aso are ndra kada-ah, ya aso katahi taloh mandron kudu dah, ra-em tam, ra-em ta Moses, ma ra-em ta Alaija.” Arile, Pita bala tanan sasah iy asehek doh, bwe. ");
INSERT INTO lid_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ya sahou ta Pita udu ndra bohon kahis le badeh, asi kandrah seselek eme anya katubuluhi oro, ma oro anoh. ");
INSERT INTO lid_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Eme ya sahou ari asahan bolo asi kandrah nane asehek i buku doh, “Idah naduk handru, jo suni iy ewek; ya ado kanuhun sahou tan.” ");
INSERT INTO lid_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Eme sahou doh ano le badeh, oro atou Jises le ari udu ndrahun. Ya eme oro badeh, tawi le udu budon toro, oro basehek nyala lakou nane udu bolo len doh mene oro atou, bwe. ");
INSERT INTO lid_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ben ari oro are bwele-e mandrei, ano oro are mandrei ame andri, ano len ari ja badeh, lau solo-an labai ame hawe Jises. ");
INSERT INTO lid_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eme ndramak ari udu bolo iri aloh, “Ndramak ta leheya, jo naduk ari le dah, jo aseken ou ame anyolom iy se. ");
INSERT INTO lid_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Iy nah doh, malawin ndra-in udu la-un, ya i le mani tur malawin ndra-in kameh amekes iy arah. Ano, iy totoreh hawe bubusi bohon kameh atau; ma amekes badan kameh isi udu gwek, luluwen labai. ");
INSERT INTO lid_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Eme jo badeh, tiye oro lau tam rayah ta katikahei malawin ndra-in udu la-un doh ki-iu, arile oro winiyan bwe.” ");
INSERT INTO lid_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Eme Jises asehek sahou i buku doh, “Ado lau mwan ma badih batehei budon handru bwe, budon ma kandriyen tado bamwenen bwe. Len sabe kameh jo kereu hawe ado, ano ado barala tanan boto-on ta Kindrei? Ou tiyani nadum keme dah.” ");
INSERT INTO lid_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ano nah dah, edek eme hawe Jises le badeh, malawin ndra-in mudi iy i andri bwidi iy totoreh, ma bubusi bohon atau. Eme Jises ibolosen i ta malawin ndra-in udu la-un iu, ma iy amwenen ja. Eme iy atehei nah dah, i hawe taman. ");
INSERT INTO lid_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Eme mani iri lau mari atur labai, ta boto-on ta Kindrei. Ya eme iri lau boho iri asak kahis le ta lakou nane Jises amekes, eme ma Jises tiye i toro lau tan, ");
INSERT INTO lid_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ado badeh, katehei ndranye ado kamwenen ki-in ta sahou jo anya kasehek tado: Iri kameh atehei Nadu Ndramak Awas ili mine iri lau ta atondrok.” ");
INSERT INTO lid_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Arile, budon toro baleu ta sahou tan nane bwe. Tasah, sahou dah badeh, ndraton ma oro bandrei bwe, ma oro ale badeh, anoh ta ndremenya Jises ta aliy. ");
INSERT INTO lid_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ano, oro lau ta Jises andres oro, ta are kudu bwele-en toro. ");
INSERT INTO lid_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Eme Jises badeh, ndratanan budon toro, eme iy andrei nadu nah ari nadu bwisik eme, ales udu kabeden. ");
INSERT INTO lid_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ano iy tiye i toro, “Ya buku none ari ndramak abudon jo, ya iy aseben ari nadu nah bwisik buku nah le dah, badeh iy aseben jo. Ma are lau oro aseben jo, badeh oro aseben Kindrei iy nane suni jo eme dah. Tasah, are lau nyaran bwe udu bolo ado kameh, iy doh kameh nyaran i tinan labai.” ");
INSERT INTO lid_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Eme Jon anya, “Ndramak ta leheya, aso atou ndramak ari atikah malawin ndra-in eme len na boto-on ta nyaram, ya eme aso anya kabarah iy, tasah iy badeh, ari taso bwe.” ");
INSERT INTO lid_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Eme Jises anya, “Ado sabarah iy, tasah are lau tan bahun tado bwe, iy badeh, kawas tado ma badu hawe ado.” ");
INSERT INTO lid_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jises badeh, tanan, mirihik kameh Kindrei akohok iy udu Jerusalem iu i kandrah. Eme ya mesekei budon tan badeh, abadok ta ili Jerusalem. ");
INSERT INTO lid_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Eme iy suni iri lau rayah ta tiye sahou ala bwena, ala kon Samariya ta lowosa lakou mari lewan; ");
INSERT INTO lid_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Iy ili, arile iri lau badeh, baseken iy bwe, tasah tekedek tan doh nane ta ili Jerusalem labai. ");
INSERT INTO lid_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Eme Jemis uru Jon anuhun kandriyen doh badeh, eme uru ndremenya Jises, “Laban, ou aseken to kaloh jih udu kandrah keme andri kasulumwi iri?” ");
INSERT INTO lid_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Arile, Jises tubuni iy eme, iy tiye boto-on i toro anya, “Bwe.” ");
INSERT INTO lid_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Eme oro au a kon ari ja. ");
INSERT INTO lid_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Eme oro adek san ala badeh, ndramak ari tiye i tan anya, “Jises, loboho heh, ou ala aliy, jo kameh in le hamon tam.” ");
INSERT INTO lid_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Eme Jises tiye i tan i buku doh, “Iri mwi badu lokei, munu iri udu aliy, ya iri sirih ale awi iri ta matinou udu aliy. Arile, jo Nadu Ndramak Awas badeh, ari ndrahu matinou tek, bwe.” ");
INSERT INTO lid_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ano, Jises tiye sahou i ta ndramak ari ja anya, “Ou ame an hamon tek.” Eme ndramak dah anya ja, “Laban, jo kili kihi tama op. Ano jo barawek bara-en hamon tam.” ");
INSERT INTO lid_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Arile Jises tiye i tan ja, “Iri lau amak badeh, kado gwek. Idah kameh, iri lau badu hawe iri barala bara-eh iri. Arile, ou badeh, adek ala atiye sahou ta nyala tondrok ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ano ja, ndramak ari ja tiye anya, “Laban, jo kameh in hamon tam; arile jo kili katiye tanan ta lowak oro op.” ");
INSERT INTO lid_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Eme ya Jises tiye i tan, “I buku none are lau kapou ndren ta bilin, ya iy bamesekei bano bwe, badeh, iy atalei labai, ta amekes lahou badu baha tondrok ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Udu hamon ta idoh ano badeh, Laban tiye i toro lau ma ndro tonoh la-uh (72) le, ano iy suni uru la-uh, la-uh a se, ala mwena tan ala bolo iri kon tinan ari ari, ma hawe iri kon kameh iy ilih aliy. ");
INSERT INTO lid_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma iy tiye i toro anya, “Ado katou, nyamon solo-an labai ndruni in bolo bilin, arile lau solo-an bwe, ta gok ta akohok nyamon nane doh bwe. Eme ya ado kasolom ki ta Laban ta kati bilin, ta iy kasuni lau kala katukumwi iri nyamon tan. ");
INSERT INTO lid_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Eme ado kala! Jo suni ado i buku iri nadu sipsip ala bolo iri mwi badu lokei. ");
INSERT INTO lid_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ado badeh, sakohok kohei ta ndrahu luk sawek, ya ado sakohok kohei ta ndrahu lakou sawek, ya ado badeh, sakohok ku-i kati ado ale; ya i buku none ado adek ala badeh, ado sare rasi sasumon ma sasehek sahou luluwen hawe ndramak. Ado badeh, kadek kales le kala. ");
INSERT INTO lid_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ya i buku none ado anya kala ra-em asiu, badeh, ado katiye anya, ‘Ado mwasin? Nyosowan udu la-u ado.’ ");
INSERT INTO lid_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ya i buku none are ndramak mwasin udu aliy, iy aseken ado badeh, mwasin tado kudu tan kudu gwek; ya i buku none ndramak baseken sahou mwasin tado bwe, ado kakuhi sahou mwasin nane keme hamon ja. ");
INSERT INTO lid_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ya i buku none iri lau mwasin ado aliy, asumon ado badeh, ado kala kado asiu toro kado gwek; kaimon sasah, ka-un sasah oro anyohan ado. Tasah, ndramak ibo gok, iri lau mwan ma badih kameh anyohan iy na nyamon, ma adeu sihinen i tan ta gok. Ado badeh, sasar sala mada asiu ra-em sala ra-em. ");
INSERT INTO lid_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ya, buku none ado ala bolo kon tinan, iri kasumon ado, saba nyamon iri adeu badeh, ado kaimon le. ");
INSERT INTO lid_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma ado kamekes iri lau sik udu tiri kamwenen, ma hawe ado katiye tiri, ‘Tondrok ta Kindrei badeh, ndrame mirihik tado.’ ");
INSERT INTO lid_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Arile, ki buku none ado kala kon tinan, ya iri baseken ado bwe, badeh, udu ndra bolo kon tinan nane badeh, ado katiye anya, ");
INSERT INTO lid_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Aso anyas ndren ta kon tinan tado udu kati aso iu, ta leheya ki mada ado, tasah ado badeh, baseken sahou, ma ado ndrandra-i labai. Ma ale, ado badeh, ki tanan, ta tondrok ta Kindrei badeh, ndrame mirihik tado. Arile, ado badeh, baseken bwe.’ ");
INSERT INTO lid_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Eme jo katiye tado kamwenen, na len Kindrei edeu lau ala ta mada sahou eme kameh, kon tinan dah kameh bwese maha-an laba tinan labai sakalawi maha-an asahan tiri lau ndra-in badu kon tinan Sodom mene ja! ");
INSERT INTO lid_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Eme ya, ado lau badu kon Korasin, hawe ado lau badu kon Betsaida, ado katou! Sisi-in tinan labai kameh ewek bwele-e ado. Tasah, ki buku none lau ra-on mene kala kon tinan Tair hawe Saidon ma kamekes lahou tinan buku none jo ndramekes ereu ndrokowa ado, sebwe ndra bwena iri lau badu kon ma lubuk doh ndrasin awin bokodon, ma ndratahi iri na koloweh, ta leheya buku none iri tikisi handru ta kandriyen ndra-in tiri mene, iri ndrabwidiy. ");
INSERT INTO lid_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Arile, na len Kindrei le tanan ta adeu lau ala ta mada sahou, ado kameh bwese maha-an udu bwele-en labai ja ta kon Tair hawe kon Saidon. ");
INSERT INTO lid_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya ado lau badu Kapena-um, sebwe iri lau ra-on ja kameh bwese nyara ado ili loken ili kandrah nadeh? Bwe handru en! Kindrei kameh akahei ado ala bolo jih, kon tiri lau ndra-in amak ado aliy. ");
INSERT INTO lid_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Ya are lau anuhun ado badeh, iy anuhun jo ale; ya are lau baseken ado bwe, i buku none iy badeh, baseken jo bwe ale. Ma hawe are lau baseken jo bwe, iy ale, baseken Kindrei bwe le, iy ndramak nane suni jo eme dah.” ");
INSERT INTO lid_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ano udu badeh, oro lau ma ndro tonoh la-uh (72) nane ame asahan, eme oro sekesek andra-i labai ma oro tiye i ta Jises anya, “Laban, iri malawin ndra-in ale badeh, anuhun boho aso, ya ame len na boto-on ta nyaram.” ");
INSERT INTO lid_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Eme Jises tiye toro, “Jo badeh, anyolom boto-on ta tama balik Satan badeh, taku udu kandrah eme andri, i buku none kalik takamek. ");
INSERT INTO lid_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ado kanuhun! Jo badeh, ndratehei boto-on handru ndrawek tado, ta ado winiyan adek bwele-e mwak ndra-in, hawe adek bwele-e sabiyep; ma boto-on ta sakalau boto-on ta balik; ya eme ari lakou winiyan batok tado bwe. ");
INSERT INTO lid_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Arile, ado badeh, sasekesek ta ado badeh, sakalawi boto-on ta malawin ndra-in, ndri-iy, arile ado badeh, kasekesek, tasah nyara ado badeh, ndratorowenei udu kandrah.” ");
INSERT INTO lid_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na len doh badeh, Jises idih labai na sekesek ta Malawin Ndrabun, eme iy tiye, “Tama, ou Laban badu munyak ma kandrah! Jo masiye ou! Tasah, ou tone lakou dah ta mada iri lau ta tanan, ma hawe iri lau anya iri tanan labai, ya ou leheyani i tiri nah, tana iri lakou bwe. Ehe, idoh asahan na seken tam le. ");
INSERT INTO lid_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tama ndratehei lakou mari ndrame minek. Ya ari ndramak ja winiyan bala tanan jo bala mwasin bwe. Tama le badeh, tanan jo udu mwasin labai. Ma ari ndramak ja winiyan bala tanan tama bala mwasin bwe; jo nadun le ari tanan iy, hawe oro lau le jo ndranyowonyani oro ndrala mada taman, oro le tana oro tama.” ");
INSERT INTO lid_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ano iy tubuni batalan i toro lau tan le, eme iy tiye i toro, “Sekesek handru i toro are lau an hamon ame kameh anyolom lakou ado ndratou asahan eme lewan dah! ");
INSERT INTO lid_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ya eme jo katiye tado, iri propet hawe iri kabin mene badeh, aseken labai ta atou lakou ado atou na dah, arile iri batou bwe. Ma hawe iri aseken labai ta anuhun iri sahou ado anuhun dah, arile iri banuhun bwe.” ");
INSERT INTO lid_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ano, ndramak ari tanan ta leheya kandriyen tiri Juwis ales ere loke none Jises. Eme iy anya, “Ndramak ta leheya, jo kamekes sasah handru, ya kohak kudu le buku doh?” ");
INSERT INTO lid_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Eme Jises tiye i tan, “Torowenei udu bolo tarou malen mene, ou ndratou, tiye i buku sah handru?” ");
INSERT INTO lid_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ano ndramak nane dah anya, “Tiye badeh, i buku doh: ‘Ou aseken Laban tam Kindrei na ndrinem mari, ma na koham handru mari, ma na boto-on tam mari, ma hawe na budon tam mari.’ Ma ano ja, ‘Ou aseken iri lau ari ari badu hawem, i le buku, ou aseken ou le.’” ");
INSERT INTO lid_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Eme Jises anya, “Ou badeh, tiye amwenen labai, ya i buku none ou amekes iri lakou mari doh, idah kameh, koham udu le buku doh.” ");
INSERT INTO lid_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Arile, ndramak ta leheya kandriyen tiri Juwis doh badeh, anya kaleheya iy le, anya iy ndra ari ai. Eme iy ndremenya Jises anya, “Are oro le handru badu hawek? Ya eme jo kaseken oro.” ");
INSERT INTO lid_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ano Jises tiye i hamon i tan, i buku doh: “Ndramak ari badeh, anya kedek kudu Jerusalem kili Jeriko. Eme iy edek ili badeh, iri lalou ado san tawi iy, ma bene-ei lakou tan marakon. Eme iri adai iy andra-i labai imek i kei ra-ei, ma iri ruwani iy udu api. Ya iri atobwak au. Ya iy ndramak nane doh amadin udu ka-u san mirihik anya kimek. ");
INSERT INTO lid_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ano, pris ari badeh, edek san nane eme. Iy edek eme badeh, anyolom ndramak nane, arile iy abelek i san bilisiu iu ai. ");
INSERT INTO lid_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ano ja, ndramak ari badu boho kamen ta Libai edek san doh, eme ja. Eme iy anyolom ndramak dah, ale, arile iy abelek i san bilisiu iu ai. ");
INSERT INTO lid_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Arile, udu ja, ndramak ari badu kon Samariya edek eme amwenen ta ndrahune ndramak dah udu aliy, iy atou ndramak doh. Eme iy tikisi ndramak doh, labai. ");
INSERT INTO lid_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Eme iy ili hawen badeh, solowei ndrelekei hawe waen i badan, ano sawei na kari kolau. Eme iy bwese-ei ndramak dah, i bwele-e donki tan, ma tiyani iy ili asiu ra-em ta ndrahu iri lau. Eme iy atondrok iy. ");
INSERT INTO lid_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Udu len ari ja badeh, ndramak dah atehei luk ma lunek (K20) i ta ndramak ta asiu dah. Ano iy tiye ta ndramak ta asiu dah, anya, ‘Ou atondrok iy ya i buku none jo eme hamon, idah kameh jo edeu saluwe luk tam, ou ndrakahei ndra-au ta atondrok iy kewek hamon.’ ");
INSERT INTO lid_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Ya ou anya, udu bolo oro lau ma taloh doh, are handru amekes kandriyen mwasin i ta ndramak nane, iri lalou adai iy doh?” ");
INSERT INTO lid_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Eme ndramak ta leheya kandriyen tiri Juwis doh, anya, “Iy ndramak ala ili aseben iy en.” Ano Jises tiye sahou i tan i buku doh, “Ou ala amekes kandriyen ki le buku iy ndramak nane amekes doh!” ");
INSERT INTO lid_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ano, Jises hawe oro lau tan, adek san au ala bolo kon ari badeh, badih ari nyaran Mata, iy luhi oro ala asiu tan. ");
INSERT INTO lid_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma nadu tinen badih ari badeh, udu aliy ale, ya nyaran Mariya. Iy edek eme manyah udu kati Jises anuhun iy asehek sahou. ");
INSERT INTO lid_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Eme Mata badeh, nunu-uh ta nadu tinen baseben iy ta amekes lahou hawen bwe. Eme iy ili hawe Jises tiye i tan anya, “Laban, ou batou nadu tine titili jo ta amekes lakou mari kada-ah bwe? Ou tiye iy keme kaseben jo!” ");
INSERT INTO lid_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ano Laban tiye, “Mata, ou tikisiy ma ou nunu-uh ta lakou solo-an labai. ");
INSERT INTO lid_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kandriyen ari le doh, udu ta Mariya ta anuhun sahou, idoh kandriyen mwasin, ya jo winiyan batiye iy ta aliy bwe.” ");
INSERT INTO lid_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na len ari badeh, Jises udu kon ari asolom. Iy amekes salom ano badeh, lau tan oro ari ndremenya iy anya, “Laban, ou leheya aso ta san ta asolom, i buku none Jon mene leheya oro lau tan.” ");
INSERT INTO lid_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Eme Jises tiye i toro anya, “I buku none ado anya kasolom badeh, ado kasolom ki buku doh: ‘Tama aso, Nyaram badeh, ki ndrabun, Ma ou ame atondrok kon mari. ");
INSERT INTO lid_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ou atehei nyamon ki le winiyan ta aso kaimon, na len ari ari. ");
INSERT INTO lid_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ou mani kandriyen ndra-in taso, i le buku aso mani kandriyen ndra-in toro are lau le, amekes eme taso. Ma ou satehei aso sala bolo iri none, ndri-iy.’” ");
INSERT INTO lid_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ano ja iy tiye i toro, “I buku none ou ari kawas tam udu aliy, ya na ndrukulu ben badeh, ou ala hawe kawas tam anyar iy ta jabi ramen ma tolo-os, ");
INSERT INTO lid_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tasah kawas tam ari badeh, udu len barame ai, ya eme ou nyamon ta amekes nan bwe. ");
INSERT INTO lid_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Eme kawas tam udu asiu anya, ‘Au, ou ame amak jo, na ben alih dah ta sah? Kou taso ndrala, ma naduk oro ale ndramadin. Ya jo winiyan basuri jo, ta edeu nam nyamon bwai.’ ");
INSERT INTO lid_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Eme jo katiye tado kamwenen, ou badeh, kawas tan handru, arile iy winiyan basuri iy banyohan ou nyamon bwe. Arile, ta boto-on ta bwilima tam bwe, ou ndremenya ndremenya ja. Idah kameh, kawas tam kameh suri iy eme loken, anyohan ou na sasah ou aseken ta aliy. ");
INSERT INTO lid_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Eme ya jo katiye tado: Ado kandremenya, ya ado kameh akohok. Ado kasilah, ya ado kameh takalahei. Ado kalim kou, ya kou kameh asak tado. ");
INSERT INTO lid_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tasah, iy are lau ndremenya, iy kameh akohok. Iy are lau asilah, iy kameh takalahei. Ya iy are lau alim kou, ya kou kameh asak tan. ");
INSERT INTO lid_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ya, i buku none ou badeh, a tama ari nah, ya iy kandremenya ou ta ari ni, ya ou badeu ni bwe? Ya, ou kameh adeu nan mwak ai? ");
INSERT INTO lid_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O, buku iy kanyar ta ndrusu sirih, idah kameh ou atehei nan sabiyep ai? ");
INSERT INTO lid_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ya, ou tanam ou ndra-in, arile ou tanam ta adeu lakou mwasin ili na nadum oro, ou winiyan atanam handru, tama ado udu kandrah kameh sekesek labai ta edeu Malawin Ndrabun ale ili toro are lau ndremenya iy!” ");
INSERT INTO lid_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ano udu, Jises tikahei malawin ndra-in udu la-u ndramak ari, mesekei iy basehek sahou bwe. Eme malawin ndra-in dah iu, ma ndramak dah asehek sahou ja. Eme ya iri lau boho iri asak. ");
INSERT INTO lid_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Arile oro lau rayah anya, “Iy atikah malawin ndra-in iu tasah tinan tiri malawin ndra-in nyaran Belsabul badeh, edeu boto-on ili tan ta amekes lakou doh.” ");
INSERT INTO lid_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Eme ya iri lau rayah badu bolo oro le badeh, ndremenya iy ma anya kanone iy, ta kamekes kalem badu kandrah ta leheya buku none iy amekes gok ta Kindrei handru. ");
INSERT INTO lid_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Arile, Jises ndrandrei budon toro ndra-in tan, ya eme iy asehek toro i buk doh, “Ki buku none iri lau badu kon munyak tinan kapou iri ranah i len, ma ranah i len, ma iri amekes bahun, iri lau badu kon doh kameh andra-i. Ya, ki buku none, boho kamen ra-em kaseker, idah kameh, iri lau doh winiyan bales boto-on bwe. ");
INSERT INTO lid_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ya, ki buku none oro lau ta Satan kapou oro ki lumuk, ya, ki buku dah handru iy tan boto-on ta atondrok iri lakou? Jo asehek sahou ewek tado dah, tasah ado anya boto-on jo akohok dah, ta atikah iri malawin ndra-in au, badeh, ta Belsabul edeu eme tek. ");
INSERT INTO lid_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ya, ki buku none Belsabul aseben jo handru, ma jo katikah iri malawin ndra-in, ya are lau handru aseben iri lau taha ta atikah malawin ndra-in? Sebwe balik aseben oro nadeh? Iri gok oro lau tado amekes, leheya buku none sahou tado badeh, bamwenen bwe. ");
INSERT INTO lid_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Arile ado kanuhun, i buku none boto-on ta Kindrei amwenen aseben jo ta atikah iri malawin ndra-in, ado ndratana ado kabwe, Kindrei ndrame ta atondrok aha lau mwan ma badih badu Isra-el. ");
INSERT INTO lid_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ya, ki buku ari ndramak boto-on kandrei beteleu tan, ya iy katehei ndrokei ta asiu tan, idah kameh, lakou tan mari udu mwasin. ");
INSERT INTO lid_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Arile, ki buku none ari ndramak boto-on ja, keme hawen uru kada uru, idah kameh, ndramak hamon nane, kameh idi iy ma kuhi lakou tan ta bahun kameh iu. Ano, iy akohok lakou tan mari ma atehei i tiri lau. ");
INSERT INTO lid_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ya, eme are lau iy kawas tek bwe, iy ndramak ta amekes bahun eme tek. Ya are lau baseben jo ta atukum iri lau kame ka-en hamon ta Kindrei bwe, iy kameh atikah iri lau ka-en ndra len ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Buku none ari ndramak tikahei malawi ndra-in ereu la-u ari ndramak iu, malawi ndra-in doh iu laleyah i bolo kon lomale an ta iy katakaleh ari kon ja, iy kili aliy. Eme, buku iy batou ari kon mwasin ta iy ili aliy bwe, ");
INSERT INTO lid_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","iy kameh asehek, ‘Jo ndrawoyah ai, sebwe jo kili hamon kili asiu tek bwena mene jo ereu aliy.’ Eme iy ili hamon anyolom asiu nane ereu laleyah, ndrasahan ha-un, ma ndranyosowani kabwe. ");
INSERT INTO lid_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ehe, iy atou buku doh, eme iy ili hamon ja andrei oro malawi ndra-in ndro taloh ja sakalawi iy ta amekes kandriyen ndra-in. Ya oro kameh ala bolo asiu nane. Ya eme ndramak dah, bala buku bwena mene ja bwai, iy ndrandra-i labai ai.” ");
INSERT INTO lid_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Eme Jises asehek sahou kahis le badeh, udu bolo iri lau mari nane dah, badih tasou ari aloh, “Sekesek handru labai i tare badih atehei ou, ma hawe nyohonei ou badeh.” ");
INSERT INTO lid_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Arile, Jises tiye ja i buku doh, “Sekesek badeh, ki toro are lau anuhun sahou ta Kindrei, ma an hamon ta aliy.” ");
INSERT INTO lid_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eme lau ame a sola badeh, Jises tiye i tiri anya, “Iri lau mwan ma badih ta len dah badeh, iri ndra-in handru. Iri ndremenya ta anya katou kalem, arile winiyan bwai, kalem ari le kameh iri atou, kalem ta Jona. ");
INSERT INTO lid_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona badeh, i nyara kalem ta lau badu Ninibe na len bwena mene, ya jo Nadu Ndramak Awas ale, i nyara kalem ta lau na len dah. ");
INSERT INTO lid_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na len hamon ta Kindrei kameh atehei iri lau mari badu kon munyak dah ala ta mada sahou, badih tinan kabin badu kon tinan Seba, kon tan in loboho kum, kameh ales ereu ta mada sahou, iy kameh asehek ma nyowonya iri kandriyen ndra-in taha lau ta len hamon dah amekes. Tasah, iy badih kabin doh ereu len labai ta Isra-el, arile iy eme ta anuhun le kabin Solomon leheya iri tanan mwasin tan. Na dah, ndramak ari ereu ndrokowa ado, iy sakalawi ja Solomon, arile ado banuhun sahou, ma batubuni ndrine ado bwe. ");
INSERT INTO lid_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na len Kindrei le tanan ta edeu iri lau ala ta mada sahou, iri lau mwan ma badih badu Ninibe ale kameh ales ala ta mada sahou, ma iri kameh asehek sahou boto-on labai i taha lau ta len hamon dah. Tasah, iri lau badu Ninibe anuhun sahou Jona asehek, ma iri tubuni ndrine iri. Na idah, ndramak ari ereu ndrokowa ado dah, sakalawi ja Jona, arile ado banuhun sahou tan, ma batubuni ndrine ado bwe! ");
INSERT INTO lid_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“I buku none ari ndramak iy katelemei sun, iy winiyan batehei bala kon korohan bwe, ma hawe iy winiyan batehei bado bahandra bwekei bwe; iy kameh atehei udu ndrahunen loken. Ya, i buku none are lau eme anyolom kameh, iy eme asiu. ");
INSERT INTO lid_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mada ado badeh, i buku lomada sun ta atelem bolo oda ado. Ya, i buku none mada ado udu mwasin, badeh kameh bolo ado mara-ei idih na lomadan. Arile, i buku none mada ado ndra-in, idah kameh bolo ado kameh ilik. ");
INSERT INTO lid_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Eme ya mada ado kaleu ta sun udu bolo ado badeh, samak. ");
INSERT INTO lid_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ya, i buku none sun lomatani bolo ado mari, ya sese lulik aliy bwe, idah kameh lomadan telemei kon mari. I buku none sun anya badeh, lomatani ado mara-ei.” ");
INSERT INTO lid_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Eme ya sahou ta Jises ano le bohon badeh, Parasi ari andrei Jises i hawen aimon nyamon. Eme Jises ili manyah udu andri aimon nyamon. ");
INSERT INTO lid_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Eme ya iy anyolom Jises badeh, basikine minen bwe, ya iy aimon nyamon, eme ya iy lomondra solo-an labai. ");
INSERT INTO lid_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ano Jises tiye i tan anya, “Ado Parasi badeh, sikine kona bwesam ma kona bwekei tado le, arile bolo ado badeh, ndrarahak le ko-ak hawe manahun ndra-in. ");
INSERT INTO lid_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ado bale ado bwe! Ndramak mene amekes konan badeh, iy ale amekes bolon. ");
INSERT INTO lid_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Abo, i buku none ado anya kamekes kandriyen mwasin udu bolon ma konan badeh, ado kanyohan lakou udu bolo bwekei ki tiri lau tiri lakou bwe. Ma idoh kameh ado asahan mwasin. ");
INSERT INTO lid_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ado Parasi, mada ado kaleu! Sisi-in laba tinan kameh ewek bwele-e ado! Ado badeh, apou la-ukei mint hawe la-ukei ruwe tado badeh, i ronoh, ronoh. Ano ado adeu ari ari badu bolo ronoh doh, i ta Kindrei. Ado ale, amekes i buku aliy i ta lakou mari badu bilin tado. Idoh mwasin, arile ado ndramani iri kandriyen ta tikisiy hawe kandriyen mwasin ta Kindrei. Sebwe mwasin ta ado ka-en hamon ta sahou batanau tinan ma ado samani iri sahou batanau bwisik nane ale. ");
INSERT INTO lid_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ya ado Parasi, mada ado kaleu! Sisi-in laba tinan ale kameh ewek bwele-e ado! Tasah, ado badeh, aseken le ta manyah ado bada bwabwai mwasin udu ndrahu tukum taha Juwis. Ma hawe ado badeh, aseken lau le badeh, kasumon ado hawe kamasiye ado an bolo ba-en. ");
INSERT INTO lid_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Ado ndranuhun! Sisi-in laba tinan doh kameh ewek bwele-e ado! Nyolom ta bada ado badeh, mwasin. Arile bolo ado badeh, ndrandra-i labai, tasah ado badeh, mahu ado ndrala. I buku none iri lau adek ame badeh, banyolom mada lek bwe. Ya eme iri adek bwele-en ma bales balesani iri.” ");
INSERT INTO lid_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Eme ari badu bolo oro lau ta leheya kandriyen tiri Juwis badeh, tiye i ta Jises anya, “Ndramak ta leheya, ou asehek sahou badeh, eme orowei aso amwenen.” ");
INSERT INTO lid_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Eme Jises tiye i hamon ja anya, “Ado lau ta leheya kandriyen tiri Juwis, mada ado kaleu! Sisi-in laba tinan ale kameh ewek bwele-e ado! Tasah, ado atisih lau na kandriyen malen solo-an labai ta iri ka-en hamon ta aliy. Arile, ado badeh, batehei mine ado ta aseben bwe. ");
INSERT INTO lid_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Ado ndranuhun! Sisi-in laba tinan doh kameh ewek bwele-e ado! Tasah, iri propet mene, tubu ado oro amwenen badeh, adai oro. Eme ado lowosa lek amwenen badeh, ta aliy ai. ");
INSERT INTO lid_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Eme ya ado kede-eh asakau ado laleyah, i buku none tubu ado mene amekes. Tubu ado oro adai iri propet, ya ado badeh, kani ado ta a-eh lek ai. ");
INSERT INTO lid_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ado kanuhun kamwenen! Tasah, ta katin doh, na tanan ta Kindrei mwasin le, iy anya, ‘Jo kameh suni iri propet hawe iri lau ta batun tiri lau ta Kindrei, ala hawe iri. Ma idah kameh, iri adai iri propet rayah amak, hawe adai iri lau rayah ta batun tiri lau ta Kindrei kameh amak ma hawe bwese isi tinan.’ ");
INSERT INTO lid_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ya eme ado lau na len dah kameh a saluwe iri lau ala adai iri propet mene amak, kabatana munyak asahan le. ");
INSERT INTO lid_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Udu ndra kabatana ndraye Ebol eme isos ndraye Sekaraya, mene adai iy ya ndrayen amou udu ndrokowa mada koto-ok ma asiu ta atudun. Eme jo bawendreya bwe, ado lau na len dah kameh a saluwe oro bwese isi mari doh. ");
INSERT INTO lid_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ado lau ta leheya kandriyen tiri Juwis, mada ado kaleu! Sisi-in laba tinan ale kameh ewek bwele-e ado! Tasah, ado ndrasulu-i kou ta asiu ta akohok tanan handru ndrala. Eme ya ado amwenen ale, bala se bolon bwe, ya eme iri lau buku liliy anya ka bolon, arile ado aturuk san ta iri sala bolon.” ");
INSERT INTO lid_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ano, Jises udu hawe iri anya ki-iu badeh, iri Parasi hawe iri lau ta leheya kandriyen tiri Juwis badeh, asehek sahou ndra-in ta losen i tan, hawe lelen iy ta ndremenya solo-an. ");
INSERT INTO lid_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iri anya kamekes iy kasehek saba sahou ndra-in ya iri kabarah iy. ");
INSERT INTO lid_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Udu, iri lau solo-an solo-an labai, ari ndramak winiyan bandromwei bwe, iri ame atukum ta anya kanuhun Jises. Eme ma kon aso mara-ei, ma rayah adek bwele-e rayah. Tasah, kon ari soson bwe. Ya eme Jises asehek sahou ma mwena i toro lau tan anya, “Mada ado badeh, kaleu ta yis tiri Parasi. Kandriyen ta wasai tiri doh badeh, i buku yis; sese le winiyan ta edeu ili bolo jabi ramen buruwen kolek. ");
INSERT INTO lid_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lakou mari ale aton kede-eh kameh asahan eme lewan, lau mari kameh anuhun ma atou na mada iri. ");
INSERT INTO lid_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma saba lakou ado asehek hawe saba lakou ado tone badeh kameh asahan eme lewan mada lau mari. Ma hawe saba lakou ado ohei le ta aliy, udu bolo asiu kameh, iri are bwele-e ndrahu tukum tiri lau kameh asehek i tinan ta lau mari kanuhun. ");
INSERT INTO lid_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Jo kasehek ki tado kamwenen ado kawas tek, ado sanoh tiri lau ale winiyan adai bada ado na dah. Badeh, iri adai bada ado le, arile iri winiyan badai malawi ado bwe. ");
INSERT INTO lid_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Arile, jo anya kaleheya ado ta are handru kameh ado kanoh iy: Ado kanoh labai ta Kindrei, tasah iy winiyan idi ndramak imek, ano iy le tan boto-on udu aliy ta akeh ndramak doh, i bolo jih. Eme jo asehek tado dah badeh, ado kanoh iy. ");
INSERT INTO lid_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ado badeh, ndratana ado, iri lau asih sirih nadu bwisik ma limeh na luk bororoh saraman la-uh (2t) le, neh? Arile, tama ado badeh, atondrok sirih doh udu mwasin labai. Kindrei bamani iri ari se bwe. ");
INSERT INTO lid_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Handru labai, Kindrei ale badeh, ndrandromwei lami batu ado mari, ya iy tanan ado mwasin labai. Ya, ado sanoh tiri lakou ndra-in iri lau anya kamekes kewek tado. Kindrei winiyan tondrokei ado handru. Ado kanuhun! Ereu budon ta Kindrei, iri sirih badeh, lakou laleyah, arile iy atondrok iri. Eme ya iy winiyan tondrokei ado areu mwasin labai ja. ");
INSERT INTO lid_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ya, jo kasehek tado kamwenen, are lau ale asehek ili tiri lau mwan ma badih buku none iy badeh badu hawek, jo Nadu Ndramak Awas ale kameh asehek tiri angelo ta Kindrei buku iy ndramak doh badu hawek handru. ");
INSERT INTO lid_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Arile, are lau asehek ta ndramak ari ja buku iy badu hawek bwe, jo ale kameh asehek i tiri angelo ta Kindrei buku iy lau doh badu hawek bwe ale. ");
INSERT INTO lid_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ma are lau oro asehek sahou ndra-in i bada Nadu Ndramak Awas, Kindrei le kameh winiyan mani kandriyen ndra-in tan. Arile, are lau oro aluhe i bada nyara Malawin Ndrabun, Kindrei winiyan bamani kandriyen ndra-in tan doh bwe. ");
INSERT INTO lid_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ya, i buku none iri katehei ou ales are ta sahou, are bolo asiu ta atukum deh, iri katehei ou ales are mada iri lau ta atondrok kon, badeh, ou sabwerei ou, ta saba sahou kameh ou asehek ta aliy. Ado sabudon sandra-i, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Na le bolo len doh kameh Malawin Ndrabun kameh leheya ou ta sahou ou kameh asehek.” ");
INSERT INTO lid_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Eme ndramak ari udu bolo iri lau nane doh, tiye i ta Jises buku doh, “Ndramak ta leheya, ou tiye ki ta nadu tine badeh, kapwai lakou ta tama aru ki le winiya aru.” ");
INSERT INTO lid_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Eme Jises tiye i tan i buku doh, “Ou den, are lau tiye tam anya, jo kanuhun sahou ta apou lakou ta tama ah, ki ta ah nadu tinem?” ");
INSERT INTO lid_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ano Jises tiye i tiri mwan ma badih, “Bale ado kudu tado! Mada ado kaleu tado, ta ado badeh, saseken lakou doh, lakou doh le, tasah koha ndramak badeh, winiyan bado luluwen na lakou solo-an doh, bwe. I buku tan lakou solo-an labai, arile iri lakou mari doh kameh winiyan basebenei koham ta udu le buku doh, bwe le.” ");
INSERT INTO lid_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ano Jises asehek sahou sokek ari doh, i ndranye oro: “Bilin ta ndramak ari tan lakou solo-an badeh, ato-ou sali iri badeh, solo-an. ");
INSERT INTO lid_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Eme iy lomondra anya, ‘Idah kameh, barala buku sah bah? Jo ari kon ta adeu iri nyamon tek marakon ki aliy bwai.’ ");
INSERT INTO lid_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Ano iy anya, ‘Jo kamekes ki buku sah bah? Sebwe jo badeh, kamekes ki buku doh: Jo katokosei asiu ta nyamon ki-iu, ya jo katahiy ki tinan ja. Idoh kameh, winiya iri nyamon hawe iri lakou tek mwasin mari i bolon ai.’ ");
INSERT INTO lid_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ano iy le asehek nyalan anya, ‘Jo badeh, lakou tek solo-an labai, winiyan udu andrei jaha solo-an. Idah kameh, mesekei jo sekesek ma a-un gwa, tasah manyah tek ndramwenen kabwe.’ ");
INSERT INTO lid_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Arile, Kindrei tiye i tan anya, ‘Balem bwe, na ben dah kameh ou amak; ya lakou tam mari doh kameh ki tare bah?’ ");
INSERT INTO lid_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Lakou i buku doh kameh asahan i tare lau, i buku iy anya katukum lakou sola sola badu munyak; arile ta mada Kindrei badeh, lakou doh, bala mwasin ta madan bwe.” ");
INSERT INTO lid_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ano Jises tiye i toro lau tan: “Ado sabwerei ta manyah tado, saba lakou kameh ado aimon, ma ta bada ado ale, saba lakou kameh ado kataliye. ");
INSERT INTO lid_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Koha ado sakalawi nyamon, ma bada ado sakalawi kalawi ado ale. ");
INSERT INTO lid_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ado kanone kanyolom iri sirih se: Iri batah nyamon bwe, ma iri babwe-eh nyamon bwe. Ma hawe iri ari asiu ta asumwe nyamon bwe, arile Kindrei le badeh, anyohan iri. Udu budon ta Kindrei ja badeh, iy kameh atondrok ado udu mwasin labai ja tiri sirih! ");
INSERT INTO lid_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Buku ado abwerei ta iri lakou doh, idah kameh winiyan edeu ari len ja ili hawe len ta manyah tado, ta ado luluwen deh? Bwe! ");
INSERT INTO lid_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","I buku none ado winiyan bamesekei lakou nadu bwisik doh bwe, ya i buku sah ado abwerei ta lakou mari? ");
INSERT INTO lid_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ado kanone kanyolom iri kanyeu ateh se. Ya iri babo gok bwe, ma iri bamekes kalawi iri bwe. Arile, jo katiye tado, bwena mene kabin Solomon asini iri awin tan mwasin mara-ei handru ano, arile nyasou tiri kanyeu ja sakalawi nyasou ta kabin Solomon. ");
INSERT INTO lid_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Idah Kindrei edeu nyasou ma awin ili tiri bwidiu badu lokei, iri bwidiu ado na len dah, ano na len bi-i akeh iri au ala bolo jih ta asun iu. I buku sah, sebwe Kindrei winiyan badeu kolau ma awin bawek tado bwe nadeh? Budon tado handru tinan bwe? ");
INSERT INTO lid_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ya ado sabudon sandra-i ta saba nyamon kameh ado kaimon, hawe sabwerei ta saba gwa kameh ado ka-un, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tasah, iri lau badu kon munyak tinan mara-ei aseken ma asilah iri lakou doh. Ado sala buku iri, tasah tama ado Kindrei iy tanan saba lakou ado aseken. ");
INSERT INTO lid_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Arile, ado kanyolom bwena kili ta tondrok ta Kindrei op. Ano ya iri lakou doh Kindrei kameh edeu ewek tado. ");
INSERT INTO lid_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ado marakou sanoh! Tama ado Kindrei badeh, sekesek tado labai, eme ado kameh atondrok lakou hawen. ");
INSERT INTO lid_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Eme lakou tado mari badeh, kasihinei ki-iu ta luk ya luk ta aliy badeh, ado kadeu ki tiri lau lakou bwe. Ado badeh, katakaleh tado kohei kohoya luk udu kandrah; lakou winiyan ta apus bwe, hawe winiyan ta amu-uk bwe, ma hawe iri lau ta bahana winiyan babene-ei bwe. ");
INSERT INTO lid_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tasah, i buku none ou tam lakou solo-an udu bolo munyak dah, kameh mesekei ou abudon solo-an ta aliy. ");
INSERT INTO lid_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ado badeh, kanyasou, hawe kalokou ado, ma katelemei sun tado kudu le, koro-an lakou kasahan, ");
INSERT INTO lid_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ki buku none iri lohowan abe-en ndramak ta kati asiu udu ta molak eme hamon. Ya i buku none iy eme asumon, oro kameh sulu-i kou asak tan. ");
INSERT INTO lid_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Idah kameh, udu mwasin toro labai, tasah mada oro badeh, bamadin bwe, na len ndramak ta kati asiu asahan. Eme ya jo katiye tado kamwenen, idah kameh, iy asini awin ta lohowan tan, ano iy tiye oro manyah ado andri ano iy bwese nyamon i noro. ");
INSERT INTO lid_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ma idah kameh, mwasin labai i toro lohowan, i buku none ndramak ta asiu eme anyolom oro badeh, abe-en. I buku none iy eme na ndrukulu ben deh, na boho len badeh, oro ndra abe-en iy le. ");
INSERT INTO lid_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Arile, budon tado kaleu ta tanan doh: Buku none tama asiu i tanan saba mada an handru iri lau ta bahana kameh ame apou asiu tan, iy kameh atehei ndrokei, tasah iy winiyan bamukuni iri lau ame apou asiu tan bwe. ");
INSERT INTO lid_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ya, buku none ado ale, ado kalokou ado na len mari. Tasah, Nadu Ndramak Awas kameh asahan na len ado batehei budon ta iy eme bwe.” ");
INSERT INTO lid_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Eme Pita anya, “Laban, ou tiye sahou sokek badeh, eme tahi mari deh, bwe, eme taso lau tam le?” ");
INSERT INTO lid_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Eme Jises tiye i hamon ja anya, “Are lau iy mwasin ta gok, ma iy budon mwasin? Iy don adeh, tinan tan kameh atehei iy ta atondrok iri lau tan ra-on ja an bahandran ta adeu niri nyamon na len ari, ari, iy le tanan. ");
INSERT INTO lid_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sekesek handru in bwele-e ndramak doh, buku none tinan tan eme takalahi iy amekes gok tan mwasin. ");
INSERT INTO lid_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jo tiye tado handru, tinan tan kameh atehei iy ta atondrok iri lakou tan mari. ");
INSERT INTO lid_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Arile, buku none iy lau ta gok tan nane katiye anya, ‘Ndramak ta asiu doh kameh winiyan bame suwi bwe,’ ya iy kameh a-um iri lau mwan ma badih ta gok. Ano iy aimon nyamon aimon aimon, ano iy a-un gwa boto-on a-un a-un, ma iy ibo lolo-ou. ");
INSERT INTO lid_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ya, na len ari, tinan ta ndramak nane ta gok kameh eme hamon na len iy ndramak nane tanan bwe. Tinan tan kameh sani iy i lunah, ma mesekei iy akohok maha-an buku le iri lau ta tebelese mene. ");
INSERT INTO lid_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ya ki buku none ari lohowan tanan lahou ta tinan tan, ya iy bamesekei bwe, idah kameh, iy bwese maha-an tinan labai. ");
INSERT INTO lid_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Arile, i buku none ari lohowan bala tanan lahou ta tinan tan bwe, ya iy amekes lahou laleyah, idah kameh, adai iy udu, le udu. Ma i buku none are lau akohok lakou solo-an labai, badeh, iy kedeu solo-an ale, ki hamon; ma i buku none are lohowan katondrok lakou solo-an kudu bahan, iy badeh, kamekes lahou kirih le gwek. ");
INSERT INTO lid_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Jo eme dah badeh, ta asun kon munyak. Ki jo aseken handru mene badeh, jih ndranya! ");
INSERT INTO lid_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Arile, jo kameh ilih bolo isi udu mwena tek eme, eme ya jo aseken keme suwi ya lokohak! ");
INSERT INTO lid_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ado anya jo eme munyak dah, ta amekes mondrei? Bwe! Jo katiye tado kamwenen, jo eme kameh ta apou lau. ");
INSERT INTO lid_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Na dah kameh, oro limeh badu boho kamen ra-em le, arile idah kameh apou oro, taloh a bilisiu ya la-uh a bilisiu ma oro andra-i. ");
INSERT INTO lid_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Idah kameh, oro apou oro, taman kameh andres i la-u nadun mwan, ma nadun ale kameh andres i la-u taman. Ya tinen kameh andres i la-u nadun badih, ma nadun badih ale kameh andres i la-u tinen. Ya salahun uru kayon kameh andres uru, i le buku aliy.” ");
INSERT INTO lid_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Eme Jises tiye i tiri anya, “I buku none ado atou kon abakak udu loboho an i andri, idah kameh, ado tanan, ur kameh eme. Ma idah kameh asahan handru. ");
INSERT INTO lid_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ya, i buku none ado atou jor lan atohou badeh, ado tanan, idah kameh lolan. Ma idah kameh asahan handru. ");
INSERT INTO lid_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bale ado bwe! Ado atou kalem ere bolo kandrah ma munyak, ma tiye amwenen. Arile, buku sah ja ado winiyan batou ma baleheya bamwenen iri kalem ta len dah bwe? ");
INSERT INTO lid_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Ya buku sah ado winiyan ta amekes budon ta kandriyen mwasin bwe? ");
INSERT INTO lid_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ki buku none ari ndramak tan losen udu tam ya iy katehei ou a ta sahou, ya sahou kahis le, badeh, ou ala hawen ya ah kasehek ta aliy bwena. I buku none ou bala bwe badeh, iy kameh seheyani ou ala mine iri lau ta anuhun sahou. Ano iri lau ta anuhun sahou kameh tiye iri lulik atehei ou ala bolo asiu lulik. ");
INSERT INTO lid_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Jo katiye tado kamwenen, ado winiyan bame len bwe, winiya le ado sihinei labai na luk in hamon ta maha-an tado.” ");
INSERT INTO lid_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ya eme lau rayah are hawe oro na len doh mene tiye i ta Jises ta nyala ndraye iri lau rayah badu Galili badeh, Pailat ndrasolowei ndrala hawe katin haka ta asun ta salom tiri. ");
INSERT INTO lid_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Eme Jises anya, “Ado abudon i buku sah handru? Ado anya oro lau badu Galili adai oro doh badeh, lomondra ndra-in ma karei toro sakalawi karei ma lomondra ndra-in tiri Galili mari deh bwe? Tasah, oro amak i buku doh? ");
INSERT INTO lid_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jo katiye tado kamwenen: Bwe! Arile, i buku none ado batubuni ndrine ado bwe, idah kameh, ado amak i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ya ado kanone kabudon oro lau ma ronoh ndru la-uh (18) mene asiu boko bek lawe tihisi oro ado Silowam se? Ado badeh, abudon anya oro doh badeh, ndra-in labai ja, sakalawi oro lau are Jerusalem dan ai? ");
INSERT INTO lid_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bwe! Jo katiye tado kamwenen. Arile, i buku none ado batubuni ndrine ado bwe le, badeh kameh ado amak i le buku aliy.” ");
INSERT INTO lid_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ano Jises asehek sahou sokek nyala ndramak ari anya: “Ndramak ari mene badeh, tahi kei pik udu bolo bilin tan. Ano iy anya kili katou kei doh, ndrato-ou salin deh bwe. Eme iy ili tandrana tandrana, arile iy banyolom ari bwe. ");
INSERT INTO lid_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Eme iy tiye i ta ndramak ta atondrok anya, ‘Jaha taloh ai, jo eme anya katou kei pik dah, ta salin ya eme, jo se batou ari salin bwe. Kei pik kede-eh a-un gwa ta munyak laleyah, ya eme kamwetehei ki-iu!’ ");
INSERT INTO lid_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Arile, ndramak ta atondrok bilin anya, ‘Ndri-iy, kudu gwek jaha ari dan op, ya jo kanone kawudi na lek ya jo kakeh sisoh ki mwe-en. ");
INSERT INTO lid_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ki buku none ato-ou salin na jaha eme eh, mwasin ai, ya i buku none bwe eh, badeh, baramwetehei bara-au ai.’” ");
INSERT INTO lid_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na len ta amunyau ari, Jises leheya iri lau udu asiu ta atukum tiri Juwis. ");
INSERT INTO lid_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Eme badih ari udu aliy badeh, malawin ndra-in ndramesekei konan ndrahun, andrei jaha ronoh ndru la-uh (18) ai. Eme iy winiyan bales bwe, iy akor le. ");
INSERT INTO lid_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","13","Eme Jises anyolom iy ma iy luhi iy eme mwena. Ano iy atehei minen i badan, ma tiye i tan anya, “Badih den, ndrokonam ndramwenen!” Eme konan ales ja ma iy atudun Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Eme ndramak ari batun ta atondrok ndrahu asiu ta atukum badeh, ibolosen ta Jises nane mesekei badih doh badeh, udu bolo len ta amunyau. Eme ndramak dah, asehek eme lewan i tiri lau i buku doh, “Taha badeh, atehei len onoh le, ta taha kamekes lahou; ya buku none ou anya amekes lahou badeh, ou amekes kudu bolo oro len doh. Ya na len ta amunyau badeh, ou samekes lakou!” ");
INSERT INTO lid_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Eme Laban tiye i tan anya, “Ado ta wasai! Sebwe ado kede-eh batalou iri oks hawe donki na len ta amunyau, ma basariye iri bala ba-un gwa bwe nadeh? ");
INSERT INTO lid_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ya ado abudon i buku sah handru ta i badih, badu boho kamen ta Abraham dah, Satan mesekei ndrokonan badeh, samwenen na len ta amunyau?” ");
INSERT INTO lid_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ya eme sahou iy tiye dah badeh, mesekei iri lau heh budon tiri ndra-in udu tan badeh, bwili iri ama. Arile, iri lau buku liliy badeh, sekesek labai ta lakou mwasin iy amekes. ");
INSERT INTO lid_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ano Jises ndremenya, “Bolo tondrok ta Kindrei badeh, i buku sah handru? Jo kasehek ki buku sah bah? ");
INSERT INTO lid_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bolo tondrok ta Kindrei badeh, i buku none buwa kei ari aloh mastet, ndramak tahi in bolo bilin tan. Iy ateh eme loken ma i tinan, ya iri sirih atah ame amekes awi iri udu bada andran.” ");
INSERT INTO lid_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ano iy ndremenya ja, “Ya eme jo kasehek bolo tondrok ta Kindrei ki bada sah handru bah? ");
INSERT INTO lid_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bolo tondrok ta Kindrei badeh, i buku none yis, badih andrei ya iy tubuni i hawe rahak ndrom tinan palawa. Iy tubuni ili ili winiya palawa mara-ei apus eme loken.” ");
INSERT INTO lid_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ano Jises edek ma atiye sahou i tiri lau badu bolo kon tinan, ma i tiri lau badu kon bwisik, ma ili ales ili Jerusalem. ");
INSERT INTO lid_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Eme ndramak ari ndremenya anya, “Laban, idah kameh, lau rayah le kameh koha iri bano bwe? I buku none iri ala baha tondrok ta Kindrei?” Eme iy tiye i toro, ");
INSERT INTO lid_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ado badeh, kabadok ado ta ala madasan bwisik. Tasah, jo katiye tado kamwenen, iri lau solo-an anya kanone ta ala bolon, arile iri winiyan bwe. ");
INSERT INTO lid_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eme ya ki buku none, ndramak ta ali asiu udu bolo asiu, ya iy kasulu-i kou kili, ya ado badeh, kare manan, kaloh anya, ‘Laban, ou sulu-i kou, aso anya kawek asiu.’ Arile ndramak ta ali asiu kameh anya, ‘Ado badu heh badeh? Jo tanan ado bwe oh!’ ");
INSERT INTO lid_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Ano kameh ado tiye anya, ‘Aso mene aimon nyamon hawe a-un gwa hawem en, ma ou mene leheya aso an bolo kon taso en!’ ");
INSERT INTO lid_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Arile, idah kameh, iy tiye i toro anya, ‘Jo tanan ado bwe oh! Ya ado are heh ame dah? Ado same madak. Ado ka-au! Ado badeh, lau ta amekes kandriyen ndra-in labai!’ ");
INSERT INTO lid_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Idah kameh, akeh ado ame len ta baha tondrok ta Kindrei, ala bolo jih, ya ado kameh aden, ma andrebek lihi ado, tasah ado kameh anyolom Abraham, Aisik hawe Jekop ma hawe iri propet mari are baha tondrok tan. Arile, ado le, bwai! ");
INSERT INTO lid_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma idah kameh, iri lau badu leheleh kameh ame, badu loboho an eme loken, ya iri lau badu loboho an i andri, hawe iri lau badu kum, hawe iri lau badu tolau, kameh akohok ndrahune iri ta manyah ta nyamon tinan ado baha tondrok ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Handru labai, idah kameh, lau rayah badu ndrobek kameh ala mwena, ya lau rayah badu mwena kameh ame ndrobek.” ");
INSERT INTO lid_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na len doh, iri Parasi rayah ame hawe Jises tiye i tan anya, “Ou au a kon ari ja. Kabin Herot anya kidi ou!” ");
INSERT INTO lid_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Arile, Jises tiye i toro, “Ado kala katiye ta mwi badu lokei badeh, anya, ‘Jo kameh udu gwek atikah iri malawin ndra-in au, hawe amekes iri lau sik udu tiri iu na dah, ma hawe na bi-i, ano na atoha, lahou tek barano adeh. ");
INSERT INTO lid_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Aliy ai, arile bwai, jo na dah hawe na bi-i ili isos atoha badeh, jo ndrado Jerusalem ai, tasah udu bolo oro len doh nane ari propet badeh, winiyan bamak bare ari kon buku liliy bwe. Iy imek udu Jerusalem amwenen.’ ");
INSERT INTO lid_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, jo tikisi ado labai, ado adai iri propet, ma ado ateu iri lau Kindrei suni iri ame atou ado, ma ado orowei iri na bek ma adai iri amak. San solo-an jo anya katukumwi nadum oro, buku none iri kakaro tukumwi nadu iri areu bahandra bani iri. Arile, ado bwale ado! ");
INSERT INTO lid_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nadah asiu ta salom tado kameh udu laleyah. Eme, jo katiye tado kamwenen, ado winiyan batou jo ja bwe, winiya le len hamon kameh ado anya, ‘Kasekesek ki ta ndramak doh iy eme ta nyara Laban.’” ");
INSERT INTO lid_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na len ta amunyau ari, Jises aimon nyamon udu asiu ta tinan tiri Parasi ari. Eme iri badeh, atehei mada iri udu tan. ");
INSERT INTO lid_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Eme udu batalan badeh, ndramak ari badeh, sik pis udu ta bohan hawe katin. ");
INSERT INTO lid_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Eme Jises ndremenya oro Parasi hawe iri lau tanan ta leheya kandriyen tiri Juwis anya, “Mwasin ta amekes ndramak amwenen na len ta amunyau deh bwe?” ");
INSERT INTO lid_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Eme iri badeh, ari sahou bwe. Ya eme iy tawi ndramak dah, ma mesekei iy amwenen ma hawe tiye iy iu. ");
INSERT INTO lid_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ano Jises ndremenya oro anya, “Ya, ki buku none ari nadu ado, deh ari katin haka tado oks, kataku ki bolo lek na len ta amunyau. Ado tana ado, sebwe ndramak nane winiyan tawi iy ma aluwi iy eme loken nadeh? Handru, iy ibo gok na len ta amunyau, tasah buku none iy bamekes bwe eh, iy kameh imek neh?” ");
INSERT INTO lid_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eme oro ari sahou bwe. ");
INSERT INTO lid_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Eme Jises atou oro lau ame ta nyamon dah badeh, soso-on ndrahu manyah tiri lau tinan udu mirihik ta nyamon, ya eme iy asehek sahou sokek i toro anya, ");
INSERT INTO lid_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“I buku none ari ndramak katiye ou ala aimon nyamon ta molak hawen, ou badeh, sasoso-on sala bwena, hawe iri lau tinan. Koro-an ari ndramak udu bale iri kodo-oh ja, iri aseken iy. ");
INSERT INTO lid_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ki buku i handru kameh, ndramak ta kati nyamon kameh suni ndramak ta tiye ou nane, ame kameh tiye tam anya, ‘Ou suri ou, ya ndramak dah kamanyah kudu badeh.’ Ano kameh bwilim ama andra-i, ma ou ala manyah are ndrobek. ");
INSERT INTO lid_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Arile, i buku none iri katiye ou ala ta aimon nyamon badeh, ou manyah are ndrobek. Ya i buku none ndramak ta kati nyamon eme atou ou kameh anya, ‘Kawas tek, ou ame manyah ame ndrahu manyah mwasin udu bwena kada-ah.’ Ma idah kameh, iri tinan kameh barala tanan ou ai, ta ou badeh, ndramak ari awas. ");
INSERT INTO lid_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Eme ya, i buku none are lau anya katudun iy ki loke, iy kameh ari nyaran bwe. Ya are lau amekes iy i buku iri nah nadu bwisik, idah kameh, nyaran i tinan.” ");
INSERT INTO lid_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ano Jises tiye i ta ndramak nane kuhi iy aimon nyamon hawen anya, “I buku none ou awer nyamon tinan, badeh, ou sakohok iri kawas le, ma ou sakohok nadu tinem oro le, ma hawe ou sakohok lowam oro le, ma hawe ou sakohok iri lau lakou tiri solo-an, asiu tiri udu ka-u asiu tam le; i buku none ou akohok oro, idah kameh, oro akohok ou ala hawe oro ja, i saluwe ou mene akohok oro. ");
INSERT INTO lid_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Arile, i buku none ou awer nyamon tinan badeh, ou akohok iri lau tiri lakou bwe, ou akohok iri lau boha iri imek, hawe kati iri imek, ya ou akohok iri lau bada iri imek, ma hawe iri lau mada iri bwe, kawek kaimon nyamon hawem. ");
INSERT INTO lid_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ya idah kameh, ou akohok nyosowan ta aliy. Tasah, iri badeh, lakou bwe, eme ya iri badeu saluwen bwe, arile idah kameh, ou akohok bundruwe nyamon tam na len iri lau mwasin amak, ame loken.” ");
INSERT INTO lid_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Eme ndramak ari badu bolo oro ta tukum ta nyamon tinan anuhun sahou Jises asehek badeh, eme ma iy tiye i ta Jises, “Are lau aimon nyamon udu baha tondrok ta Kindrei eme kameh, iy badeh, kasekesek.” ");
INSERT INTO lid_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Eme Jises anya, “Ndramak ari badeh, iwer tine nyamon, ya eme iy atehei sahou i tiri lau solo-an labai, ta ame. ");
INSERT INTO lid_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Eme na len ta nyamon amwenen, ndramak ta iwer nyamon suni lohowan tan ari ili, ta tandra-un iri lau mene sahou i tiri badeh, anya, ‘Ado kame, lakou mari ndra lokowaniy ndrano.’ ");
INSERT INTO lid_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Arile, iri mari badeh, ari bala bwe, iri anya tiri gok le. Eme iy ari ma mwena eme, tiye anya, ‘Jo badeh, tikisiy handru en, jo barasihinei bilin ranah ai, ya eme jo kili katou op.’ ");
INSERT INTO lid_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Ano iy ari ja ili tiye anya, ‘Jo badeh, tikisiy handru en, jo barasihinei bulumakau ma ronoh ai, ya eme jo ki-iu kaseu uru la-uh la-uh kase, ma kanone oro ta apou ndren.’ ");
INSERT INTO lid_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ano ari ja eme anya, ‘Jo bawek bwai, tasah jo barala tasou ai.’ ");
INSERT INTO lid_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ano lohowan dah, iu i hamon tandra-un ta ndramak ta iwer nyamon tan dah. Eme ndramak ta iwer nyamon nane dah, ibolosen, ma tiye lohowan tan dah, anya, ‘Ou ala suwi ala bolo kon badeh, kuhi iri lau tiri lakou bwe kame, ou kuhi iri lau mine iri imek hawe kati iri imek, ou kuhi iri lau mada iri bwe, ma hawe iri lau bada iri imek, ala ado loboho heh, loboho heh, bolo kon badeh, kame.’ ");
INSERT INTO lid_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Ano lohowan dah anya, ‘Tinan tek, sasah ou tiye badeh, ndrano, arile asiu baso bwe le.’ ");
INSERT INTO lid_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Ano ja, ndramak ta kati nyamon dah, tiye i ta lohowan tan anya, ‘Ou ala loboho san tinan hawe san bwisik hawe lobwilis badeh, tiye iri lau kame, ya bolo asiu tek kidih.’ ");
INSERT INTO lid_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Eme jo katiye tado kamwenen, idah kameh oro lau mene sahou i toro mwena badeh, winiyan baimon nyamon dah bwe.” ");
INSERT INTO lid_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Eme ya iri lau solo-an badeh, are hamon ta Jises, eme iy tubuni batalan i hamon i tiri ma iy tiye: ");
INSERT INTO lid_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“I buku none are lau anya ki-in hamon tek, iy badeh, karuwani tinen uru taman, ma iy karuwani udun hawe nadun oro, ma iy karuwani nadu tinen oro mwan hawe badih. Ma hawe kohan ale, iy sabwerei labai ta aliy. Ya, i buku none iy abudon iri lakou doh tinan labai, badeh, iy ma nah bwisik kahis le, ma iy winiyan basahan lau tek bwe. ");
INSERT INTO lid_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ma are lau mwan ma badih balokou iy ta imek bwe, ta ereu hamon tek, buku none ndramak ta imek iy kabwese kei tondreh tan amwenen, iy badeh, winiyan basahan lau tek bwe le. ");
INSERT INTO lid_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ya, i buku none ari tado anya katah bokok, badeh kameh iy winiyan batah bwena bwe op. Idah kameh, iy manyah mwena lomondra ta luk sabe kameh winiyan ta tahi asiu bokok, deh bwe. ");
INSERT INTO lid_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ya, i buku iy banyolom bolo luk bwena bwe, ya iy katehei ndru kili ya bano bwe; idah kameh, iri lau atou kameh, iri kabobose iy anya, ");
INSERT INTO lid_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Katou iy, iy anya katah asiu ki loke badeh, bano bwe.’ ");
INSERT INTO lid_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O bwe em, ki buku none ari kabin kili kamekes bahun i ta kabin ari ja. Idah kameh iy manyah ma lomondra op, ‘Oro lau ta bahun tek ma 10,000 kada-ah winiyan adai oro lau ta bahun ta kabin ma 20,000 kodo-oh, deh bwe?’ ");
INSERT INTO lid_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","I buku none iy winiyan bwe; ya iy kabin ari nane in ndra len kahis le, iy kameh suni oro lau ala tandra-un i tan ta bahun ndri-iy ai, oro kado le ai. ");
INSERT INTO lid_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","I le buku aliy, i buku none are tado baruwani lakou tan mari bado api bwe, badeh, iy winiyan basahan lau tek bwe. ");
INSERT INTO lid_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ndras badeh, mwasin, arile i buku none nyakadan tan ki-iu, idah kameh, ou baramesekei nyiminye ndras doh barame hamon barala buku sah bah? ");
INSERT INTO lid_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Idah kameh, iy winiyan bakahei bala bwele-e munyak ta amekes munyak amwenen, bwe. Idah kameh akahei iu. I buku none ou are lau ndranyem udu aliy, ou anuhun!” ");
INSERT INTO lid_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ano iri lau ta akohok luk ta takis, hawe iri lau ta amekes karei ma lomondra ndra-in ame awudi Jises, ta anuhun sahou tan. ");
INSERT INTO lid_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Eme ya iri Parasi hawe iri lau ta leheya kandriyen tiri Juwis badeh, nunu-uh anya, “Iy ndramak kede-eh, aseken iri lau ta karei ma lomondra ndra-in hawe aimon nyamon hawe iri.” ");
INSERT INTO lid_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ano Jises tiye sahou sokek doh i toro, ");
INSERT INTO lid_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ya, i buku none ari tado sipsip tan ma rinek (100) udu aliy, ya buku none ari sipsip tan kamai; sebwe iy winiyan bala batakaleh bwe nadeh? Neh? Bwe labai. Iy kameh ruwani oro sipsip tan ma ndro ronoh ndro ari (99) nane ado lobwidiu are gwek. Ya idah kameh, iy ili takaleh ari nane amai dah, iy takaleh, takaleh ndra iy takalahei iy labai. ");
INSERT INTO lid_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Ya, i buku none iy katakalahei iy, idah kameh, iy sekesek handru ma bwese-ei iy kameh udu kasen ma uru au a kon. Ano kameh, iy luhi oro kawas tan hawe oro lau badu mirihik ta asiu tan ame anya, ‘Ado kame kasekesek hawek, ta sipsip tek mene amai, jo ndratakalahei iy ja.’” ");
INSERT INTO lid_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Eme Jises anya, “Jo katiye tado kamwenen, idah kameh i le buku aliy; sekesek laba tinan labai kameh udu kandrah i buku none ari ndramak ta karei ma lomondra ndra-in katubuni ndrinen. Sakalawi oro lau ma ndro ronoh ndro ari (99) mene oro anya oro mwasin, arile oro batubuni ndrine oro bwe. ");
INSERT INTO lid_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ya, i buku none ari badih badeh, tan luk ronoh bororoh udu aliy, ya ari kamai. Idah kameh, iy telemei sun ma andrei sisir, asir bolo asiu, asir asir, winiya le iy baratakalahei. ");
INSERT INTO lid_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ya, i buku none iy takalahei, idah kameh, iy tiye oro kawas tan hawe oro lau asiu toro udu mirihik tan kameh ame ma iy anya, ‘Jo ndratakalahei luk tek bororoh ari mene amai, ado kame kasekesek hawek.’ ");
INSERT INTO lid_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Idah kameh, i le buku aliy; iri angelo badu kandrah kameh sekesek ado mada Kindrei i buku none, ari ndramak katubuni ndrinen.” ");
INSERT INTO lid_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Eme Jises asehek ili le anya: “Ndramak ari badeh, nadun mwan ma la-uh udu aliy. ");
INSERT INTO lid_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Eme iy bahan tiye i ta taman anya, ‘Tama ou atehei lakou tek keme ai.’ Eme tama uru apwai lakou tan mari badeh, i turu. ");
INSERT INTO lid_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Se luwen bwe, iy bahan eme tukumwi lakou tan mari ma sihinei i ta luk. Eme iy andrei luk ma iy iu ili kon munyak tinan ari. Eme iy sabarani luk tan badeh, i ta lakou laleyah. ");
INSERT INTO lid_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Udu hamon ta luk tan mari anya kano, kon munyak doh badeh, nyamon bwe. Eme badeh, iy nyamon bwe. ");
INSERT INTO lid_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Eme iy ili amekes lahou ta ndramak ari badu kon munyak doh, eme iy suni iy ili anyohan iri bou tan. ");
INSERT INTO lid_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Iy badeh, abudon anya, ‘Jo kini ku-i ndrakeyam ala bou aimon kede-eh kameh, son tek iu ai.’ Arile, ari ndramak banyohan se nyamon bala nan bwe. ");
INSERT INTO lid_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Ano iy lomondra i hamon anya, ‘Jo kada-ah anya kimek ta son! Ya oro lau ta lahou ta tama badeh, aimon nyamon solo-an labai, ma nyamon badeh, erah. ");
INSERT INTO lid_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jo ki-iu ki hamon hawe tama, ya jo katiye tan ki buku doh: Jo badeh, amekes kandriyen ndra-in i ta Kindrei ma i tam. ");
INSERT INTO lid_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Jo badeh, mwasin ta asahan nadum ja bwai; jo badeh, kasahan i buku none iri lau ta lahou tam.’ ");
INSERT INTO lid_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Eme iy suri iy, ma edek iu ili hamon hawe taman. Arile, iy udu ndra len kahis le badeh, taman atou iy ma ndrinen eden tan. Eme taman sakaliye ili badeh, akabah i la-un ma tawi iy. ");
INSERT INTO lid_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ano nadun tiye i tan anya, ‘Tama jo badeh, amekes kandriyen ndra-in i ta Kindrei ma i tam. Jo badeh, mwasin ta asahan nadum ja bwai.’ ");
INSERT INTO lid_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Arile, taman tiye i ta lohowan tan anya, ‘Ou ala suwi andrei ari awin mwasin ha-un, keme kasini ki la-un. Katehei ring ki andra limen hawe kasini ku-i katin kili. ");
INSERT INTO lid_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kadai bulumakau kasen, ya to kamekes nyamon tan, ma kasekesek. ");
INSERT INTO lid_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tasah, jo anya, naduk dah mene ndramak, arile iy bamak bwe; iy mene amai, arile iy ndrasahan ja.’ Eme iri amekes nyiminye aliy. ");
INSERT INTO lid_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ya nadu tinen bwele-en badeh, udu ndra lokei. Iy eme mirihik ta asiu badeh, iy anuhun ndran hawe lau ada mana. ");
INSERT INTO lid_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Eme iy luhi lohowan ari eme, iy lelen iy, ‘Iri amekes sasah doh?’ ");
INSERT INTO lid_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Eme lohowan anya, ‘Nadu tinem mene badeh, ndrame hamon ja. Ya eme tamam badeh, idi bulumakau kasen i ta aimon tan, tasah iy badeh, bamak bwe, iy ma mwasin le ndrame hamon ja.’ ");
INSERT INTO lid_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Eme nadun bwele-en badeh, ibolosen, eme iy bwalen ta i bolon. Eme taman eme manan indrek iy, ta ki bolon. ");
INSERT INTO lid_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Arile, iy tiye i ta taman anya, ‘Ou anyolom se! Na jaha ndra-au, ndra-au badeh, jo amekes lahou tam i buku none iri bonyo-ou, ya jo batebelese sese ta bohom bwe. Arile, ou badeh, batehei ari me kasen bame ya jo hawe iri kawas tek basekesek bwe. ");
INSERT INTO lid_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Arile, nadum dah mene sabarani luk tam iu laleyah i tiri badih ta madasan, ya iy eme hamon ja badeh, ou adai bulumakau kasen i nan!’ ");
INSERT INTO lid_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Eme taman anya, ‘Naduk, ou badeh, badu hawek ya lakou tek mari kameh i tam. ");
INSERT INTO lid_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Arile, naduk, to badeh, kasekesek hawe kamekes nyiminyen, tasah aso anya iy mene ndramak, arile iy bamak bwe; iy mene amai, arile iy ndrasahan ja!’” ");
INSERT INTO lid_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ano Jises asehek sahou sokek ari i toro lau tan anya: “Lohowan ari badeh, atondrok lakou ta ndramak ari, tan lakou solo-an. Ndramak tan lakou solo-an nane dah, anuhun lohowan tan atondrok lakou dah badeh, sabara luk tan laleyah. ");
INSERT INTO lid_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Eme iy luhi lohowan ta atondrok dah eme, ya iy lelen iy, ‘Jo mene anuhun ou amekes lakou ari. Ou torowenei sasah le ndra-au, hawe sasah le udu kede-eh kudu, ya keme tek. Tasah, ou ndrano, ou winiyan batondrok lakou tek ja bwai.’ ");
INSERT INTO lid_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Eme lohowan ta atondrok lomondra iy tan le, anya, ‘Jo ki buku sah bah? Ndramak tan lakou solo-an tek kede-eh, ndratikahei jo ndrano ta gok. Ya jo badeh, boto-on ta apou ndren bwe, hawe jo ta bwilima ta anyolou lakou. ");
INSERT INTO lid_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jo tanan, jo badeh, ndrano. Eme ya jo badeh, kamekes tanan doh; ya idah kameh iri lau winiyan aseken jo ili asiu tiri ai.’ ");
INSERT INTO lid_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Eme lohowan ta atondrok dah luhi iri lau mari mene, andrei lakou ta ndramak tan lakou solo-an mene tan dah, ame. Eme iy ndremenya iy ari bwena anya, ‘Ou mene andrei lakou sabe ta ndramak mene tan lakou solo-an?’ ");
INSERT INTO lid_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Eme iy anya, ‘Jo mene andrei sabok ndrelekei ta olip ma rinek (100).’ “Eme iy anya, ‘Ou manyah atorou, ou mene andrei sabok ma lomonoh (50) le.’ ");
INSERT INTO lid_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Ano iy ndremenya ndramak ari ja, ‘Ya ou mene andrei sabe?’ “Eme iy anya, ‘Jo mene andrei ndrom sahin wit rinek (100).’ “Eme iy tiye i tan, ‘Ou torowenei ndru lunoh (80) le.’ ");
INSERT INTO lid_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Eme ndramak tan lakou solo-an nane dah, masiye lohowan tan. Tasah, iy badeh, anyolom bohon ili bwena, ta bolo manyah tan. Idoh badeh, leheya iri lau badu munyak dah badeh, iri tanan mwasin labai ta atondrok lakou tiri. Iri badeh, sakalau iri lau badu lomadan ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Eme ya jo katiye tado kamwenen, ado badeh, katamar iri lau na lakou tado badu munyak. Ya, i buku none ano badeh, iri kameh aseken ado ala kon ta udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Are lau winiyan tondrokei lakou bwisik badeh, iy winiyan tondrokei lakou tinan ale; ya are lau winiyan batondrokei lakou bwisik bwe badeh, iy winiyan batondrokei lakou tinan bwe ale. ");
INSERT INTO lid_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ya, i buku none ou winiyan batondrokei lakou badu munyak bwe; idah kameh, ou winiyan baratondrokei lakou handru barala buku sah? ");
INSERT INTO lid_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ya, i buku none ou winiyan batondrokei lakou ta ari ndramak bwe, ya idah kameh, are lau le kanyohan ou lakou bah? ");
INSERT INTO lid_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Lohowan ari winiyan bateu lahou ta lau tinan la-uh bala le rasan bwe. Ya idah kameh iy bwalen iy ari, ya iy aseken iy ari; deh bwe, kameh iy anuhun sahou ta iy ari labai ja, ta iy ari. Ado winiyan balelei Kindrei ta atondrok ado, ma hawe aseken luk ta atondrok ado bala le rasan bwe.” ");
INSERT INTO lid_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Eme oro Parasi badeh, oro lau ta aseken luk labai, eme oro anuhun sahou mari doh badeh, ma oro bobose iy. ");
INSERT INTO lid_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Eme Jises tiye i toro anya, “Ado le baden adeh, anya, ado mwasin ta mada lau adeh, arile bwe, Kindrei badeh, tanan ndrine ado. Tasah, sasah lau atou ta mada iri, anya idoh aliy le ai; arile bwe! Ta mada Kindrei anyolom badeh, lakou ndra-in laleyah.” ");
INSERT INTO lid_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Sahou ta nyala batanau mene Moses torowenei hawe iri sahou tiri propet badeh, sendrehendreh ta aliy kabatana le Jon ta alomwa, kabwe. Ya, sahou mwasin ta nyala tondrok ta Kindrei badeh, ndratiye udu kabatana Jon ta alomwa, eme taku idah. Eme lau mari badeh, atuw iri alih bolon. ");
INSERT INTO lid_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kandrah hawe kon munyak dah kameh ano iu mara-ei. Arile, ari kono-o tarou badu bolo batanau malen winiyan ta bano bwe. ");
INSERT INTO lid_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ya, i buku none are lau katikahei udun ki-iu, ano ja iy kasudi badih ari ja, iy le mesekei karei i tan. Ya i buku none are ndramak kasudi ari badih udun ndratikahei iy, iy le mesekei karei i badan. ");
INSERT INTO lid_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ndramak ari badeh, lakou tan solo-an labai. Iy badeh, anyasou na lakou saraman mwasin asih na luk solo-an, ma iy badeh, iwer nyamon ta aimon na len mari. ");
INSERT INTO lid_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Udu boho mwendreu tan badeh, ndramak ari nyaran Lasarus. Ya iy badeh, manyah udu andri, ma badan mari ndrarahak le soso-ou. ");
INSERT INTO lid_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Iy udu aliy badeh, atondrok kahu nyamon ta ndramak tan lakou solo-an kataku, ya iy kaimon. Ya iri mwi badeh, asom mada soso-ou tan. ");
INSERT INTO lid_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Ano, Lasarus imek ya iri angelo badu kandrah ame andrei iy ili manyah udu ka-u Abraham. Ano ndramak tan lakou solo-an ale imek, ya eme iri ahi iy. ");
INSERT INTO lid_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Eme udu bolo jih kodo-oh badeh, odan isi, ma iy anyolom i len badeh, iy atou Lasarus manyah udu ka-u Abraham. ");
INSERT INTO lid_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Eme iy aloh, ‘Tama Abraham, ou tikisi jo, ya ou suni Lasarus katehei andra limen ki ta gwa keme ta kalimek, ya kanyala. Tasah, jo akohok isi laba tinan labai, udu bolo jih dah!’ ");
INSERT INTO lid_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Arile, Abraham anya, ‘Naduk, ou none lomondra ou mene ado awas se. Ou badeh, mene akohok lakou mwasin, ya Lasarus mene badeh, anyidiu lakou ndra-in. Arile, na dah, iy manyah udu mwasin ai, ya ou ado ta sisi-in ai. ");
INSERT INTO lid_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ya laba tinan labai ja badeh, lek laba tinan labai udu ndrokowa to kada-ah. Ma i buku none, are lau anya kudu dah kewek bilisiu hawem badeh, winiyan bwe. Ma ale, i buku none are lau kudu bilisiu tado badeh, anya keme hawe aso kameh winiyan bwe le.’ ");
INSERT INTO lid_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","“Eme iy anya, ‘Tama, ou suni Lasarus kili asiu ta tama oro, katiye tanan ta nadu tine oro ma limeh same bolo sisi-in, jo udu aliy dah.’ ");
INSERT INTO lid_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Eme Abraham anya, ‘Sahou ta Moses hawe sahou tiri propet badeh, ndrawek toro; Eme nadu tinem oro badeh, kanuhun sahou doh!’ ");
INSERT INTO lid_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Eme iy anya, ‘Tama Abraham, ki buku none ari lau ndrasu-u, ya iy kamak ki loke, idoh mwasin ai. Winiyan tiye tanan i toro, ma idah kameh, oro ruwani kandriyen ndra-in toro ai.’ ");
INSERT INTO lid_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Arile, Abraham tiye tan anya, ‘I buku none oro banuhun sahou ta Moses hawe sahou tiri propet bwe, idah kameh oro winiyan banuhun sahou ta su-u udu bolo lek tan amak eme loke, bwe ale.’” ");
INSERT INTO lid_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ya eme Jises tiye i toro lau tan anya: “Lakou ala, amekes lau taku ta kandriyen ndra-in ma karei kameh barasahan. Arile, oro lau ta amekes asahan kameh akohok sisi-in ndra-in labai ta aliy! ");
INSERT INTO lid_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Buku ari ndramak bwidi ari nadu nah kataku ki bolo kandriyen ndra-in, sebwe mwasin ta ndramak doh kasawei ari bek maha-an ki balen, ya kakahei iy katuh kili bolo ndras ki-in gwek ai. ");
INSERT INTO lid_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Eme ya mada ado kaleu tado. “Ya, i buku none nadu tinem ari amekes kandriyen ndra-in badeh, ou tiye sahou boto-on ki tan. Ya, i buku none iy tubuni ndrinen badeh, ou mani ki-iu. ");
INSERT INTO lid_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ya, i buku none iy amekes kandriyen ndra-in i tam san ma ndro taloh, udu bolo len ari. Ya, i buku none iy keme hamon san ndro taloh keme hawem katiye ou, iy ndratubuni ndrinen, badeh, ou mani kandriyen ndra-in nane iy amekes ewek tam.” ");
INSERT INTO lid_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Eme oro aposel tiye i ta Laban anya, “Ou mesekei budon handru taso ki tinan!” ");
INSERT INTO lid_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Eme iy anya, “Buku budon tado kasahan ki buku badu buwa kei mastet, badeh, idoh ado winiyan tiye i ta kei malberi dah, anya, ‘Ou sudi ou, ma kandrom keme loke, ya ou ala gwa ndras ma ateh ame loke!’ Idah kameh iy anuhun boho ado. ");
INSERT INTO lid_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ya, i buku none ado ari lohowan tado kapou ndren ta bilin, o, iy katondrok iri sipsip tado; kon abeyeh ya iy badeh, udu bilin eme lewan, ya ou winiyan tiye iy suwi ewek hawem ta aimon nyamon, deh bwe? ");
INSERT INTO lid_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Winiyan bwe! Idah kameh, ou tiye tan anya, ‘Ou mesekei nyamon tek ta beyeh suwi, ano ou bwese-ei keme bada sau ma ou abe-en jo kaimon nyamon, ma ka-un gwa bwena op. Ano ou baraimon barado hamon.’ ");
INSERT INTO lid_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ano kameh, iy winiyan edeu wurah i ta lohowan tan, ta anuhun sahou tan, deh bwe? Winiyan bwe! ");
INSERT INTO lid_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ya eme ado ale kamekes ki le buku aliy; i buku none ado kamesekei lahou mari iri tiye ado ta amekes, ano ado katiye anya, ‘Aso badeh, lohowan laleyah, aso ndramesekei lahou, arile aso an hamon le ta batanau.’” ");
INSERT INTO lid_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ano Jises anya kedek kili Jerusalem eme ya iy andrei san ndrokowa kobek ta Samariya hawe Galili. ");
INSERT INTO lid_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","13","Eme iy edek anya kili bolo kon ari badeh, oro lau lepra ma ronoh ndruni iy. Ya eme oro are ndra len badeh, aloh i ta Jises anya, “Jises, ndramak ta leheya, ou tikisi aso!” ");
INSERT INTO lid_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eme Jises atou oro badeh, ma iy anya, “Ado kala kaleheya bada ado, kili tiri pris.” Eme ya oro adek ala, se nawin bwe ma bada oro ndramwenen ja. ");
INSERT INTO lid_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Eme iy ari badu bolo oro ma ronoh nane anyolom sik lepra udu badan badeh, ndra-au. Iy eme hamon atou Jises, bohon ndra loken le hawe sekesek, ma iy atudun Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Iy eme morahani iy udu kati Jises edeu wurah i tan. Ma iy ndramak nane doh badeh, badu Samariya. ");
INSERT INTO lid_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jises anyolom i ndramak doh le badeh, ma iy lelen iy anya, “Jo anya kede-eh, ado ma ronoh badeh, ndramwenen. Ya oro ndro ari ndra heh bah? ");
INSERT INTO lid_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","I buku sah handru iy ndramak badu leheleh le badeh, eme hamon edeu wurah? Ya oro lau badu Isra-el ndraheh bah?” ");
INSERT INTO lid_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ano Jises tiye i tan, “Ou suri ou, ya ou au; budon tam handru le badeh, ndramesekei ou ndramwenen ja.” ");
INSERT INTO lid_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Len ari, oro Parasi rayah ame ndremenya Jises, “Na saba len handru kameh tondrok ta Kindrei kasahan tiri mwan ma badih badu kon munyak?” Eme Jises tiye i toro anya, “Tondrok ta Kindrei eme kameh bala buku none kalem ado kameh atou bwe. ");
INSERT INTO lid_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Iri winiyan basehek anya, ‘Aha kanyolom, iy asah kada-ah,’ o ‘Iy asah kodo-oh.’ Aha kanuhun! Lahou Kindrei amekes kameh udu bolo ndrine aha.” ");
INSERT INTO lid_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ano Jises tiye i toro lau tan anya, “Na len eme, ado kameh aseken labai ta atou ari len ta Nadu Ndramak Awas, arile ado kameh winiyan batou bwe. ");
INSERT INTO lid_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ya, i buku none iri lau kanyowonya anya, ‘Asah kodo-oh,’ o, iri anya, ‘Asah idah!’ badeh, ado sarou sa-en hamon tiri. ");
INSERT INTO lid_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Len ta Nadu Ndramak Awas asahan kameh lau mari atou iy. Len tan badeh, i buku none kalik takamek udu kandrah bilisiu ili taku bilisiu. ");
INSERT INTO lid_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Arile, ma mwena ta aliy, jo kameh bwese maha-an, ma iri lau na bolo len dah kameh adeu kona iri eme tek. ");
INSERT INTO lid_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Len ta Nadu Ndramak Awas kameh asahan, buku le iri lakou mene asahan na len ta Nowa. ");
INSERT INTO lid_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Iri lau amekes nyamon tinan, iri a-un gwa, iri mwan ma badih atasou ili eme, ili le isos ta len Nowa oro ala bolo ndron tan tinan. Eme kon atuh ma iri lau mari amak. ");
INSERT INTO lid_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“I le buku none Lot oro mene. Iri lau mari badeh, aimon nyamon, iri badeh, a-un gwa, iri badeh, adeu lakou tiri i ta sisih, iri badeh, atah baso i bilin hawe iri atah asiu. Eme iri amekes ili ili, ");
INSERT INTO lid_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","winiya le Lot oro, ado Sodom ame len. Bek solpa anya i buku mada ur taku udu kandrah eme andri, ma sulumwi iri lau mari amak. ");
INSERT INTO lid_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ya eme Nadu Ndramak Awas kameh asahan na len tan amwenen i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Na len doh, are lau ereu bwele-e asiu loken sala hamon sala bolo asiu sakohok lakou tan ndri-iy. Ya are lau ereu bolo bilin iy sala hamon sala asiu tan ja ai, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ado badeh, samani kundruh ta udu Lot! ");
INSERT INTO lid_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Are lau abudon labai ta kohan, iy kameh winiyan bandrei bwe handru en. Arile, are lau imek ta lahou tek, kohan handru kameh ta udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Jo katiye tado kamwenen, na ben doh kameh, uru la-uh kameh an sau rasou ya ari kameh iu, ya ari kameh udu api. ");
INSERT INTO lid_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ya uru badih la-uh kameh alim badu wit areu se, ari kameh andrei iy iu, ya ari kameh udu api.” ");
INSERT INTO lid_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Oro lau tan anuhun sahou doh badeh, ma oro ndremenya Jises anya, “Laban, idoh kameh asahan heh handru?” Eme, Jises tiye i toro anya, “Kon ale oda ari lakou, o ndramak ereu aliy, idoh kamen adeh, iri sirih ta aimon lakou bolo-an le kameh atukum areu aliy.” ");
INSERT INTO lid_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ano Jises tiye sahou sokek ari i toro lau tan ta oro badeh, saruwani budon handru toro, ma oro saruwani kandriyen ta salom. ");
INSERT INTO lid_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Eme iy tiye anya, “Udu bolo kon tinan ari, ndramak ari ta anuhun sahou ta lau badeh, udu aliy. Iy badeh, banoh se Kindrei bwe, hawe iy ari tikisi tan, tiri lau bwe. ");
INSERT INTO lid_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ya udu kon tinan doh badeh, badih nyau ari udu aliy. Badih nyau doh, eme hawe ndramak ta anuhun sahou san solo-an ta tiye tan anya, ‘Ou aseben jo ta sahou, hawe ndramak ales hawek ta sahou!’ ");
INSERT INTO lid_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Len solo-an, ndramak ta anuhun sahou badeh, bwalen ta aseben iy. Arile, udu badeh, iy le lomondra i tan anya, ‘Jo badeh, batudun Kindrei ma ba-en hamon tan bwe. Ma hawe jo ale batikisi ari lau bwe. ");
INSERT INTO lid_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Arile, iy badih nyau kede-eh eme eme ja, eme eme ja, ya jo ndraliliy ai. Arile, ndri-iy ai, jo kaseben iy ta sahou tan ai.’” ");
INSERT INTO lid_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Eme ya Laban anya, “Ado kanuhun sahou ta ndramak ndra-in ta anuhun sahou doh. ");
INSERT INTO lid_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ado abudon i buku sah handru i ta Kindrei? I buku none lau ta Kindrei amwenen, kaden ki tan na len na ben mara-ei. Ado anya idah kameh Kindrei ndrawoyah, ma iy winiyan banuhun boho oro bwai? ");
INSERT INTO lid_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Jo katiye tado kamwenen, iy kameh anuhun sahou toro ma sebenei oro suwi labai! Arile, i buku none jo Nadu Ndramak Awas keme hamon keme kon munyak dah ja, jo kameh winiyan silahei iri mwan ma badih nane atehei budon tiri handru in tek, deh bwe?” ");
INSERT INTO lid_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Eme Jises tiye sahou sokek dah, i toro lau anya oro le mwasin, oro an hamon ta kandriyen malen mari, ya oro badeh, anyolom ndra-in i tiri lau buku liliy. ");
INSERT INTO lid_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Eme iy anya, “Uru lau la-uh badeh, ala bolo asiu tinan ta Kindrei, amekes salom. Iy ari badeh, Parasi, ya iy ari ja badeh, ndramak ta akohok luk ta takis. ");
INSERT INTO lid_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Eme iy Parasi dah, ales ere loken asolom i badan le, i buku doh, ‘Jo edeu wurah ewek tam Kindrei, ta jo badeh, bala buku none iri lau mari ta ndrakok, hawe bala buku none iri lau ta nyaladan, hawe lau ta amekes madasarah kede-eh, bwe. Ma hawe bala buku none ndramak ta akohok luk ta takis kede-eh, bwe. ");
INSERT INTO lid_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ya jo badeh, abeles jo san la-uh la-uh, udu bolo wik ari ari, ma hawe udu bolo iri lakou tek ronoh, ronoh mari, jo edeu ari ari badu bolo iri lakou doh, ewek tam.’ ");
INSERT INTO lid_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Arile, ndramak ta akohok luk ta takis dah, udu len badeh, ales ere loken ma kandrun i andri, ma hawe minen udu aden, anya, ‘Kindrei, ou tikisi jo, jo ndramak ndra-in ta karei ma lomondra ndra-in.’ ");
INSERT INTO lid_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Jo katiye tado kamwenen, iy Parasi, bwai, arile ndramak ta akohok luk ta takis dah kameh iu i hamon i asiu tan, ma iy kameh udu mwasin ta mada Kindrei. Eme ya i buku none, are lau atudun iy le, idah kameh, iy ari nyaran bwe, ya i buku none are lau batudun iy bwe, idah kameh nyaran i tinan.” ");
INSERT INTO lid_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Eme ale iri lau atiye nadu iri bwisik ame hawe Jises ya iy kedeu minen le ki bada iri, ta edeu nyosowan ki tiri. Eme oro lau ta Jises anyolom badeh, oro abolosen i tiri. ");
INSERT INTO lid_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Arile, Jises luhi oro nah bwisik ame hawen ma iy tiye i toro lau tan, “Ado karuwani iri nah kame hawek. Ado saturuk iri, ndri-iy. Tondrok ta Kindrei badeh, tiri lau buku iri nah nadu bwisik kede-eh. ");
INSERT INTO lid_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jo tiye sahou handru ewek tado. I buku ado basahan buku none iri nah bwisik dah bwe, ado kameh winiyan bala bolo tondrok ta Kindrei bwe.” ");
INSERT INTO lid_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ano ndramak ari ta atondrok eme ndremenya Jises anya, “Ndramak ta leheya, ou mwasin handru en. Jo kamekes saba kandriyen handru ya jo kakohok kohan mwasin ta ereu le buku doh len mari?” ");
INSERT INTO lid_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Eme Jises tiye i tan i buku doh, “Tasah handru ou aloh jo mwasin? Ari ndramak badeh, bala mwasin i buku none Kindrei bwe, Kindrei le ari, kabwe. ");
INSERT INTO lid_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ou tanam batanau ta Kindrei, ‘Ou samekes karei ta badih tasou, ou sadai ndramak samak, ou sabahana, ou sawasai. Arile, ou a-en bahandra tamam uru tinem, ma ou anuhun sahou turu.’” ");
INSERT INTO lid_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Eme ndramak dah anya, “Jo ma loweu eme taku dah, jo in hamon ta sahou batanau mari le ai.” ");
INSERT INTO lid_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Eme Jises anuhun ano, iy tiye i tan, “Lakou ari le kahis. Ou atehei iri lakou tam mari kili ba-en, ya luk ou akohok ta iri lakou tam nane, ou adeu ki tiri lau tiri lakou bwe. Ou amekes i buku doh kameh ou tam lakou mwasin handru udu kandrah. Ano ou bara-en hamon tek.” ");
INSERT INTO lid_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Eme ndramak dah anuhun badeh, ma sa-ar asahan bwilin, ma iy tikisi labai, tasah tan lakou solo-an labai. ");
INSERT INTO lid_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Eme Jises anyolom ndramak dah, ano iy anya, “Idah kameh, boto-on labai ta ndramak tan lakou solo-an, i buku none iy anya kili bolo tondrok ta Kindrei! ");
INSERT INTO lid_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Handru labai, masakan boto-on boto-on labai ta ndramak tan lakou solo-an ta iy ili bolo tondrok ta Kindrei, arile manamun labai ja, ta kamel, i buku iy i bolo manamunu nunu.” ");
INSERT INTO lid_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Eme oro lau anuhun sahou ta Jises badeh, oro anya, “Buku none i buku baden eh, are lau handru kameh winiyan akohok kohan mwasin ta ereu le buku doh?” ");
INSERT INTO lid_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Eme Jises tiye i hamon i toro, “Saba lakou lau winiyan bamesekei bwe badeh, Kindrei winiyan mesekei.” ");
INSERT INTO lid_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ano Pita tiye i ta Jises anya, “Ou atou, aso ndraruwani lakou mari, ya aso ndra-en hamon tam.” ");
INSERT INTO lid_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Eme Jises tiye i toro anya, “Jo tiye tado handru. Are lau abudon tondrok ta Kindrei, ma iy ruwani asiu tan, ya are lau ruwani udun oro hawe nadun oro, ma nadu tinen oro, ma taman oro hawe tinen oro ado kon ado gwek, ");
INSERT INTO lid_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","idah kameh, iy akohok lakou solo-an handru labai na dah, hawe akohok kohan mwasin ta ereu le buku doh, na len eme.” ");
INSERT INTO lid_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ano Jises kuhi oro lau tan ma ronoh la-uh ala a ka-un, ma iy tiye i toro, “To kameh ala loke ala Jerusalem, ya lakou mari iri propet mene asehek ta nyala Nadu Ndramak Awas, idah kameh asahan i handru. ");
INSERT INTO lid_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","Idah kameh, iri atehei iy ili mine iri lau ra-on badu leheleh. Ma iri kameh bobose iy, ma iri kameh amekes sahou ndra-in ta bwilima i tan, ma hawe omor iy. Ya iri kameh a-um iy na malou sakabuk i bek, ma hawe adai iy imek. Ya ano udu, i bada len taloh kameh iy amak ja.” ");
INSERT INTO lid_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Arile, oro lau tan badeh, bakohok bolo sahou tan bwe, moson amai labai toro. ");
INSERT INTO lid_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jises eme mirihik ta Jeriko badeh, ndramak ari madan bwe, manyah udu ka-u san anyolou lakou. ");
INSERT INTO lid_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eme ya iy anuhun iri lau arou ala ame badeh, iy ndremenya iri anya, “Sasah badeh?” ");
INSERT INTO lid_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eme iri anya, “Jises badu Nasaret asah, edek san ewek eh.” ");
INSERT INTO lid_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Eme ya iy aloh anya, “Jises, ou nadu tubu kabin Debit, ou tikisi jo!” ");
INSERT INTO lid_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Eme oro lau adek an bwena badeh, abolosen i tan ma tiye iy kandru-uk. Arile, bwai, iy aloh ma arah boto-on le gwek anya, “Nadu tubu kabin Debit, ou tikisi jo!” ");
INSERT INTO lid_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eme Jises udu rasi ya tiye iri katiye ndramak doh, keme hawen. Iy eme mirihik badeh, Jises tiye i tan, ");
INSERT INTO lid_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ou aso-ok jo kamekes sasah kewek tam?” Ya eme iy anya, “Laban, jo anya kanyolom kon ja.” ");
INSERT INTO lid_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Eme Jises tiye i tan anya, “Madam kasak, budon handru tam badeh, ndramesekei ou ndramwenen ja.” ");
INSERT INTO lid_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Eme nawin bwe, madan amwenen ma iy anyolom kon ja. Eme ma iy atudun nyara Kindrei, ma iy in hamon ta Jises. Eme iri lau mari anyolom badeh, iri mari atudun nyara Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jises ili bolo kon Jeriko. Iy edek san amwenen ta iu. ");
INSERT INTO lid_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ya ndramak ari nyaran Sakiyas udu aliy. Iy ndramak ta atondrok iri lau ta akohok luk ta takis. Ya iy ale tan lakou solo-an. ");
INSERT INTO lid_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Iy badeh, aseken handru ta atou bada Jises, arile iy badeh, mo-on labai, ya eme koroha iri lau solo-an badeh, iy batou Jises bwe. ");
INSERT INTO lid_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Eme iy sakaniy i bwena ta san kameh Jises edek eme aliy, ya iy nyikidi kei ari aloh, Sikamo. ");
INSERT INTO lid_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jises edek eme isos bahandra kei nane iy udu aliy, ya madan anya ki loke badeh, atou iy. Eme Jises tiye i tan anya, “Sakiyas, ou ame andri suwi, na dah kameh jo anya kewek asiu tam.” ");
INSERT INTO lid_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Eme iy ales eme andri, ndrinen badeh sekesek labai, ma iy kuhi Jises i asiu tan. ");
INSERT INTO lid_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ya eme iri lau atou badeh, iri nunu-uh nunu-uh anya, “Aha kanyolom se! Iy badeh, ilih amadin asiu ta ndramak ari ta amekes kandriyen ndra-in.” ");
INSERT INTO lid_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakiyas eme ales ere loke udu asiu tan, tiye sahou i ta Laban anya, “Laban, ou ndratou! Na dah kameh jo edeu lakou tek ranah mara-ei kameh i tiri lau tiri lakou bwe. Ya, i buku none jo mene ndrabene-ei rayah lakou tiri ndrame tek, idah kameh, jo edeu lakou san hasan ja, i la-u toro mene ja.” ");
INSERT INTO lid_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Eme Jises tiye i tan i buku doh, “Na len dah Kindrei ndrasebenei oro ndramak badu asiu dah, tasah na dah, ndramak dah, ndrasan lundriye Abraham. ");
INSERT INTO lid_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tasah, Nadu Ndramak Awas eme andri dah badeh, ta asilah ma ta aseben are oro taku ta kandriyen ndra-in.” ");
INSERT INTO lid_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Iri lau anuhun iy asehek sahou nane dah kahis le badeh, iy asehek sahou sokek i tiri, tasah iy ndrame mirihik ta Jerusalem. Eme iri lau lomondra anya, idah kameh Kindrei atondrok kon dan ai? ");
INSERT INTO lid_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Eme Jises anya, “Na len ari badeh, ndramak batun ta boho kamen ra-em badeh, anya kili kon munyak ari udu len, ta iri kadeu iy kasahan kabin ta atondrok iri, ano iy barame hamon ja. ");
INSERT INTO lid_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Eme iy luhi oro lohowan tan ma ronoh ame, ya iy atehei luk ma luwa (K200) i mine oro. Udu bolo luk ma luwa (K200) doh badeh, iy ari ari akohok lunek (K20). Ano iy tiye i toro i buku doh, ‘Ado kadeu luk doh, ki ta amekes lahou, ya kaliu bundruwen keme hamon, winiya le jo barasahan.’ ");
INSERT INTO lid_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Arile, iri lau badu kon tan baseken iy asahan kabin bwe. Eme iri suni iri lau rayah are hamon tan ala, ta tiye i tan anya, ‘Ahi bwale ahi ndramak kede-eh asahan kabin tahi.’ ");
INSERT INTO lid_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Arile, bwe adeh, iy ndrasahan kabin ai. Ano iy eme hamon eme kon. Eme iy suni sahou ili toro lohowan mene iy edeu luk i mine oro ame, ya iy ndremenya oro ta sabe handru oro ndraluwi ndrame na luk mene. ");
INSERT INTO lid_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Eme iy ari ma mwena ili anya, ‘Tinan tek, luk tam mene, badeh, jo ndraluwiy luwa (K200) ja ndrame hawe lunek (K20) mene eme minek.’ ");
INSERT INTO lid_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Eme kabin tan anya, ‘Lohowan tek, ou mwasin handru. Ou tondrokei luk nadu bwisik asahan sola, ou kameh atondrok kon tinan ronoh udu baha tondrok tam.’ ");
INSERT INTO lid_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ano iy ari eme ja anya, ‘Tinan tek, luk tam mene badeh, jo ndraluwiy rawa (K100) ja ndrame hawe lunek (K20) mene eme minek.’ ");
INSERT INTO lid_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Eme kabin tiye i tan anya, ‘Ou kameh atondrok kon tinan limeh.’ ");
INSERT INTO lid_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ano iy ari eme ja anya, ‘Tinan tek, luk tam mene asah idah, jo su-iy na ndrari kolau, ma tone udu abe-en ou. ");
INSERT INTO lid_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Jo badeh, inoh ou, tasah ou badeh, ndramak ta losen. Ou akohok lakou laleyah ma akohok lakou badu bwisi limem bwe.’ ");
INSERT INTO lid_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Eme kabin tiye i tan anya, ‘Ou lohowan ndra-in! Jo kameh edeu maha-an ewek tam in hamon ta sahou tam. Ou tanam jo badeh, ndramak ta losen. Jo akohok lakou laleyah ma akohok lakou badu bwisi limek, jo atah bwe. ");
INSERT INTO lid_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ya, i buku sah handru, ou batehei luk tek bala bolo buk ta ndrahu luk bwe? Ya, i buku none jo keme hamon badeh, jo winiyan andrei ma hawe bundruwen ale.’ ");
INSERT INTO lid_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Ano iy tiye i toro lau nane ales are mirihik dah, anya, ‘Ado kakuhi luk ma lunek (K20) tan, ya katehei ki ta ndramak nane luk ma luwa (K200) udu minen.’ ");
INSERT INTO lid_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Eme oro lau tiye i ta kabin anya, ‘Tinan taso, iy mene ndrandrei luk ma luwa (K200) bwena mene o!’ ");
INSERT INTO lid_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Arile, ndramak tinan dah, tiye i toro ja anya, ‘Jo katiye tado, are lau oro mene ndrakohok bwena, idah kameh oro akohok i la-un ja. Arile, are lau oro sese le udu aliy, idah kameh kuhi mari ano iu. ");
INSERT INTO lid_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma ado katiyani are lau oro mene anya jo sasahan kabin badeh, kame, ya ado kadai oro kamak kare madak.’” ");
INSERT INTO lid_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jises asehek sahou doh, ano iy edek in bwena toro iu ili Jerusalem. ");
INSERT INTO lid_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Iy edek eme mirihik ta kon Betapes ma Betani, udu loboho kesehe mandrei aloh Olip. Eme iy suni uru lau tan la-uh ma tiye turu anya, ");
INSERT INTO lid_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ah kala kon udu bwena ta to badeh. Ya ah ala bolo kon le kameh ah atou donki ari loweu, ari ndramak bamanyah bare bwele-en bwe le. Ya ah katolowei malou, ma ah kasiriniy keme dah. ");
INSERT INTO lid_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ya, i buku none are lau kandremenya ah anya, ‘Ah anya katalou malou tan ta sasah?’ Ah katiye ki buku doh, ‘Laban gok udu tan.’” ");
INSERT INTO lid_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eme uru lau tan nane ala badeh, atou udu aliy, i le buku none Jises nane ndrasehek turu. ");
INSERT INTO lid_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ya uru talou malou kahis le badeh, iri lau ta nadu donki dah, anya, “Hei, ah anya katalou donki badeh, ta sasah?” ");
INSERT INTO lid_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eme uru tiye i tan anya, “Laban gok udu tan.” ");
INSERT INTO lid_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Eme uru sirini iy ili hawe Jises, ano oro lowosani kolau toro lawe-en badu bwele-e awin toro i konan, ma bwese-ei Jises manyah udu la-un. ");
INSERT INTO lid_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eme iy edek ili badeh, iri lau ame asin awin tiri lawe-en ya iri talaha in san. ");
INSERT INTO lid_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ano iy edek eme mirihik ta kon tinan, san ili andri ili bwilin ndrondro-ou Olip. Eme iri lau solo-an badu hamon tan badeh, iri sekesek tinan labai, ma hawe iri atudun nyara Kindrei na boho iri i loken, ta lahou tinan mari mene iri ndranyolom ndra-au. ");
INSERT INTO lid_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ma iri anya, “Kasekesek ki ta kabin! Kasore nyaran! Iy eme ta nyara Laban!” “Mondrei udu kandrah, ma lomadan ki ta Kindrei badu loken!” ");
INSERT INTO lid_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Eme oro Parasi rayah ado bolo iri lau nane, tiye i ta Jises anya, “Ndramak ta leheya, ou abarah iri lau tam kandru-uk!” ");
INSERT INTO lid_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Eme iy tiye i toro anya, “I buku none oro kandru-uk kameh iri bek kameh katubuni iri, ma iri kasarakau.” ");
INSERT INTO lid_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Eme iy edek eme mirihik ta kon tinan Jerusalem, ma iy anyolom badeh, iy eden ndranye Jerusalem. ");
INSERT INTO lid_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Iy anya, “Jo badeh, aseken labai na len dah, ado katanan kandriyen ta amekes mondrei. Arile, bwai, ndramai ta mada ado ai. ");
INSERT INTO lid_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na len eme kameh iri lau ta amekes bahun ewek tado kameh tabadah munyak eme loke anyek kon tado. Ma iri kameh awudi kon tado mari, ma turuki madasan mari awek bolon. ");
INSERT INTO lid_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Iri kameh adai ado ma hawe nadu ado oro. Kon ma asiu tado kameh atokos, ari lakou winiyan bado bwe. Tasah, ado banyolom tanan ta Kindrei bwe, ta aseben ado bwe.” ");
INSERT INTO lid_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ano Jises ili bolo asiu tinan ta Kindrei, ya iy atikah iri lau asih lakou are aliy, au a manan. ");
INSERT INTO lid_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Eme iy tiye i tiri anya, “Buk ndrabun tiye i buku doh, ‘Asiu tek dah, asiu ta amekes salom labai,’ arile ado ndramesekei asiu tek badeh, ndrasahan ‘asumwe iri lau ta bahana.’” ");
INSERT INTO lid_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Eme na len mari badeh, Jises leheya udu asiu tinan ta Kindrei, arile iri tinan tiri pris, ma hawe iri lau ta leheya kandriyen tiri Juwis, ma hawe iri lau batun tiri lau lomondra ta anya kadai iy. ");
INSERT INTO lid_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Arile, iri takaleh madasan ta kada iy labwe, tasah iri lau mari badeh, tawi sahou tan. ");
INSERT INTO lid_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ano na len ari, Jises leheya iri lau ta bolo sahou mwasin udu bolo asiu tinan ta Kindrei. Eme iri lau tinan tiri pris, hawe iri lau ta leheya kandriyen tiri Juwis, ma hawe iri lau ta batun tiri lau badu Isra-el ame hawen. ");
INSERT INTO lid_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Eme iri tiye i tan anya, “Ou tiye keme taso, ou akohok boto-on badu heh handru, ma ou amekes iri lakou kede-eh? Are lau atehei nyaran tinan ewek tam ma tiye ou ta amekes iri lahou dah?” ");
INSERT INTO lid_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Eme Jises asumon boho oro i buku doh, “Jo anya kandremenya ado ta lakou ari. Ano ado katiye keme tek ja. ");
INSERT INTO lid_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Kala Jon mene alomwa iri lau, iy akohok boto-on badu heh? Lakou doh badu kandrah deh, badu kon munyak le?” ");
INSERT INTO lid_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eme oro asehek nyala aliy udu ndrokowa oro ari ari anya, “Buku none to katiye anya, ‘Idoh lakou badu kandrah,’ idah kameh iy ndremenya to ja anya, ‘Buku sah ado batehei budon tado bala ta aliy bwe?’ ");
INSERT INTO lid_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Arile, i buku none to katiye anya, ‘Idoh kandriyen tiri lau le,’ idah kameh, iri lau korowei to na bek, tasah budon tiri lau ndrahas anya, Jon badeh, propet ta Kindrei handru.” ");
INSERT INTO lid_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Eme iri asumon bohon i buku doh, “Ahi tana ahi bwe.” ");
INSERT INTO lid_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Eme Jises tiye tiri i buku doh, “Jo ale, jo winiyan batiye bawek taha are lau handru atehei nyaran tinan eme tek ya jo amekes iri gok dah.” ");
INSERT INTO lid_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ano Jises asehek sahou sokek ari ili tiri lau anya, “Ndramak ari bwidi bilin ta waen ari. Eme iy atehei bilin ili mine iri salibah ta atondrok, ma iy iu i kon rakon ja, ma udu gwek luluwen labai. ");
INSERT INTO lid_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Eme na len ta abwe-eh buwan asahan, iy suni lohowan tan ari ili hawe oro salibah atondrok bilin waen nane dah, anya kakohok rayah buwa waen ki minen. Eme oro salibah adai iy ma tikahei iy iu na luka minen ma luka katin. ");
INSERT INTO lid_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ano ja, tama bilin dah, suni lohowan tan ari ili ja. Iy ili i le buku aliy le, oro adai iy ma abolei iy andra-i labai, ma tikahei iy iu na luka minen ma luka katin. ");
INSERT INTO lid_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ano ja, iy suni lohowan tan ari ili ja san tulusin ai. Eme oro adai iy, ma iy akohok andra-i labai, ma oro akahei iy eme len. ");
INSERT INTO lid_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Ano tama bilin anya, ‘Ki buku sah bah? I buku none jo kasuni naduk amwenen ala jo aseken iy labai kede-eh, sebwe oro kameh anuhun boho naduk.’ ");
INSERT INTO lid_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Arile, oro salibah ta bilin atou iy edek eme, oro asehek nyala oro anya, ‘Ei, nadun eme, to kadai iy, ma to kakuhi iri lakou tan mari.’ ");
INSERT INTO lid_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eme oro kuhi iy eme len ta bilin, ma oro adai iy imek. “Ya ado abudon i buku sah? Tama bilin kameh amekes saba lakou handru kili toro salibah nane abo gok an bolo bilin nane? ");
INSERT INTO lid_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iy kameh idi oro lau doh amak, ma iy kameh atehei bilin ili mine iri lau rayah ja kabo gok ta aliy.” Ya iri lau anuhun sahou sokek doh aleu labai, eme iri anya, “Sasahan ai, ma ndri-iy ai!” ");
INSERT INTO lid_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Arile, Jises anyolom boto-on i toro ma i lelen, “Sahou mene ndratorowenei ndra-au, saba moson ta aliy handru? Sahou i buku doh, ‘Bek ale iri lau ta atah asiu bwale iri, na dah, iy ndrasahan kati ndru ta ka-u asiu bek.’ ");
INSERT INTO lid_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Are lau oro taku a bada bek doh kameh, ndruwi oro kameh ibok i le bwisik, arile are lau oro i buku none bek doh, taku i la-u oro, idah kameh ati-i oro abwesek.” ");
INSERT INTO lid_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Eme iri lau ta leheya kandriyen tiri Juwis hawe iri tinan tiri pris nane anya ja Jises asehek sahou sokek doh i bada iri. Eme ma iri anya katakaleh madasan ta ateu iy na le liliy. Arile, oro winiyan bwe, tasah oro anoh iri lau. ");
INSERT INTO lid_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Eme oro atehei mada oro udu ta Jises, ma oro suni iri lalou rayah atehei mada iri udu ta Jises. Oro amekes oro i buku none lau ta tandra-un sahou handru, ala, anya kasan Jises na sahou. Ya eme oro anya katehei iy ki mine iri lau ta atondrok hawe kili baha boto-on ta tondrok tiri Rom. ");
INSERT INTO lid_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Eme ya oro lalou lelen Jises anya, “Ndramak ta leheya, aso badeh, tanan sasah ou leheya kede-eh, ndra handru le ai, ma ou badeh, banoh are ndramak bwe. Ou badeh are le alih turu. Tasah, ou badeh, leheya san ta Kindrei handru i tiri lau. ");
INSERT INTO lid_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ou abudon i buku sah? Mwasin ta taha kadeu takis ki ta Sisa, deh ndri-iy?” ");
INSERT INTO lid_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Arile, Jises anyolom ili mada oro ta wasai ma tiye toro anya, ");
INSERT INTO lid_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ado kaleheya keme tek ari luk bororoh. Malawi ndramak ma nyaran kede-eh are lau handru?” ");
INSERT INTO lid_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eme oro anya, “Ta Sisa.” Ya eme Jises tiye i toro, “Mwasin, saba lakou ta Sisa, ado kadeu ki ta Sisa. Ya saba lakou ta Kindrei, ado kadeu ki ta Kindrei.” ");
INSERT INTO lid_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Eme oro anya kawasai iy kasehek sahou ndra-in kudu mada iri lau, ma oro kateu iy. Arile, oro winiyan batawi iy bwe. Eme ya boho oro asak ta sahou tan i toro, ma oro andru-uk. ");
INSERT INTO lid_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Eme oro Sadusi rayah ame hawe Jises anya kanone iy. Oro anya, iri lau ale ndramak bwena mene, iri kameh winiyan bamak ja bwe. ");
INSERT INTO lid_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Eme oro ndremenyani Jises i buku doh, “Ndramak ta leheya, Moses bwena mene torowenei nyala taha anya, ‘Buku none ari ndramak imek, ya udun erah ya iy nadun bwe, nadu tinen kameh kandrei nyau tan ki udun, ya iy katehei nah ki tan, ma nah doh ki nyara nadu tinen, ya nyara nadu tinen sa-au, ndri-iy.’ ");
INSERT INTO lid_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ya, len ari bwena, oro lau ma ndro taloh, oro badeh, nadu tine oro. Eme kadok toro i tasou ta badih ari, eme ya iy imek ma iy nadun bwe. ");
INSERT INTO lid_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ano iy bwaneh sudi nyawe nadu tinen i tan, eme iy imek, ma nadun bwe le. ");
INSERT INTO lid_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ano ja silih sudi nyawe nadu tinen uru ja, eme iy imek ale, nadun bwe le. Eme amekes i buku doh, ili ano ta kalai. Oro mari badeh, amak ari nadu oro bwe. ");
INSERT INTO lid_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ano udu hamon badeh, badih imek ale. ");
INSERT INTO lid_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ya, ou tiye taso. Na len hamon ta iri lau mari amak ame loken ja, badih doh kameh ili udu are lau handru? Ou tanam, iy i tasou ili toro ma ndro taloh nane doh.” ");
INSERT INTO lid_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Eme Jises tiye i toro anya, “Lau mwan hawe badih are munyak dah, asoh iri a tasou. ");
INSERT INTO lid_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Arile, iri mwan hawe iri badih mwasin ta mada Kindrei kameh, na len eme kameh iri amak ame awas ja, iri winiyan bala tasou ja bwe. ");
INSERT INTO lid_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Iri kameh asahan buku iri angelo, ya iri badeh, nadu Kindrei labai, tasah iri amak ame awas ja. ");
INSERT INTO lid_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Handru labai. Iri lau ndramak bwena, hamon kameh iri amak ja. Moses ale leheya i buku aliy le. Idoh asehek nyala len mene Moses atou jih anya udu ta kei. Tasah, Moses mene tiye nyala Laban i buku doh: ‘Ou badeh, Kindrei ta Abraham, ta Aisik, ma ta Jekop.’ ");
INSERT INTO lid_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Sahou doh leheya taha i buku doh: Kindrei atondrok koha oro ma taloh, ma oro ado awas ado hawen kahis le. Eme ma, Kindrei batiye anya iy mene Kindrei tiri lau ndramak, arile na dah, bwe. Bwe! Iy badeh, Kindrei tiri lau koha iri udu aliy kahis le. Handru labai. Iri lau mari mene ndramak ndrasu-u, ma hawe iri lau mari ado loken kahis le, iri mara-ei a buku awas kahis le, tasah Kindrei atondrok iri.” ");
INSERT INTO lid_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Eme oro lau rayah ta leheya kandriyen tiri Juwis anya, “Ndramak ta leheya, ou tiye sahou badeh, amwenen handru.” ");
INSERT INTO lid_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ya eme ma iri anoh, ma iri bandremenya iy ja bwe. ");
INSERT INTO lid_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ano Jises ndremenya oro anya, “I buku sah handru iri mwan ma badih anya ja, Krais badeh, nadu Debit? ");
INSERT INTO lid_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tasah, udu bolo buk Wari ta Debit tiye i buku doh, ‘Laban Kindrei tiye i ta Laban tek i buku doh: “Ou ame manyah ado loboho minek salin, ");
INSERT INTO lid_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","winiya jo le, baratehei iri lau ta amekes budon ndra-in ewek tam, barabwesek barado bahandra katim.”’ ");
INSERT INTO lid_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ado kanuhun. Debit amwenen aloh ndramak nane Laban tan. Ya ki buku sah handru kameh iy ndramak nane ja ki nadu Debit?” ");
INSERT INTO lid_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eme iri lau anuhun kahis le badeh, Jises tiye i toro lau tan anya, ");
INSERT INTO lid_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mada ado kaleu toro lau ta leheya kandriyen tiri Juwis. Oro badeh, aseken adek ala ame na kolau moroyan lawe toro, eme oro anya lau mari kasumon oro na len ta baen. Ya oro anya kamanyah kareu le bwabwai mwasin badu ndrahu tukum tiri Juwis, ma ndrahu kon ta atudun ta nyamon tinan. ");
INSERT INTO lid_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Oro bene-ei asiu tiri badih nyau, ya iri wendreya ta aliu salom lawe-en lawe-en. Oro lau buku doh kameh akohok maha-an laba tinan labai.” ");
INSERT INTO lid_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jises badeh, udu ndra bolo asiu tinan ta Kindrei kahis, iy eme suri madan eme loken badeh, iy atou iri lau tiri lakou solo-an, adeu luk tiri i bolo lakou ta ndrahu luk udu asiu tinan ta Kindrei dah. ");
INSERT INTO lid_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ano ja, iy atou badih nyau ari tan se lakou bwe badeh, akahei luk tan bororoh saraman ma la-uh le. ");
INSERT INTO lid_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Eme Jises anya, “Jo katiye tado handru en! Iy badih nyau tan lakou bwe kede-eh, akeh luk solo-an labai ja ta lau mari. ");
INSERT INTO lid_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tasah, iri lau mari kede-eh akahei rayah le badu bolo luk tiri solo-an, arile iy badih nyau tan lakou bwe badeh, atehei luk mari ta sukunyan ndrala.” ");
INSERT INTO lid_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eme oro lau tan rayah atou asiu tinan ta Kindrei amekes na bek badeh, konen konen labai; ma lakou moroyan adeu i ta Kindrei, eme oro asehek nyala aliy. Arile, Jises eme tiye i toro, ");
INSERT INTO lid_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ado ndratou lakou mari kede-eh, na len eme kameh ado winiyan batou ari ndruwi asiu bek winiyan bales, bareu loken bwe. Iri marakon kameh ato-oh iu i andri.” ");
INSERT INTO lid_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Eme oro ndremenya iy anya, “Ndramak ta leheya, na saba len handru kameh lakou doh kasahan? Ya saba kalem kameh kasahan bwena ta leheya lakou doh eme bakep ai?” ");
INSERT INTO lid_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Eme Jises tiye i buku doh, “Ado kanyolom kamwenen, ya ari ndramak sawendreyani ado, ndri-iy. Iri lau solo-an kameh ame anya iri asehek sahou tek ma anya, ‘Jo dah Krais,’ ma, ‘Len ndra bakep ai, ta Kindrei eme akohok taha ame hamon.’ Arile, ado sa-en hamon toro. ");
INSERT INTO lid_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ya, i buku none ado anuhun kurutuwe bahun, hawe lakou maha-an asahan, budon tado sandra-i, ndri-iy. Iri lakou doh kameh asahan bwena op, arile lakou mari ta ano kameh kahis le.” ");
INSERT INTO lid_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ano iy tiye i toro ja anya: “Kon munyak tinan ari kameh amekes bahun i ta kon tinan ari; ya kabin badu kon rakon kameh amekes bahun i ta kabin badu kon rakon ja. ");
INSERT INTO lid_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma idah kameh kon ari ari kameh ndroi asahan aliy, ya son kameh asahan bolo kon, hawe sik asahan aliy. Ma idah kameh kalem ta nohowa lau kameh asahan bada kandrah. ");
INSERT INTO lid_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Arile, lakou mari doh kahis le kameh iri ateu ado. Ma iri kameh adai ado, ano seheyani ado ala asiu ta atukum tiri Juwis ales are mada sahou. Ano ja kameh iri seheyani ado ala hawe iri kabin hawe iri lau ta atondrok. Iri amekes doh tasah, idoh len ta ado katiye sahou tek mwasin ki tiri. ");
INSERT INTO lid_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma idoh kameh atehe san mwasin i tado kasehek nyala sahou tek ki toro. ");
INSERT INTO lid_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Arile, ado badeh, kalomondra bohon ki bwena ta ado sabwerei ta sasah kameh ado kasehek. ");
INSERT INTO lid_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Jo le kameh edeu sahou hawe budon mwasin ewek tado, ya iri lau kameh winiyan bandres ma tebelese budon nane jo edeu ewek tado ta atiye bwe. Ma winiyan babisini sahou tado bwe. ");
INSERT INTO lid_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ya tama ado oro, hawe tine ado oro, hawe nadu tine ado oro, hawe lowa ado oro, ma hawe kawas tado oro kameh adeu sa-oh tado, ma eme iri kameh adai ado rayah kameh amak. ");
INSERT INTO lid_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ya iri lau mari kameh baseken ado bwe, tasah ado an hamon tek. ");
INSERT INTO lid_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Arile, ari lami batu ado winiyan ba-au bwe, ma koha ado kameh udu le buku doh. ");
INSERT INTO lid_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Arile, i buku none ado le kabadok ado, idah kameh, ado le winiyan sebenei koha ado handru. ");
INSERT INTO lid_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ya, i buku none ado katou iri lau ta bahun kawudi Jerusalem, badeh, ado tanan ai, mirihik kameh Jerusalem atokos ai. ");
INSERT INTO lid_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Eme ya, are lau oro are kon Judiya badeh, katobwak kala bolo mandrei. Ya are lau oro are bolo kon tinan badeh, katobwak kame len. Ma hawe are lau oro are len badeh, sala bolo kon tinan, ndri-iy. ");
INSERT INTO lid_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tasah, idoh badeh, len ta adeu maha-an i hamon, amwenen le ta sahou ta Kindrei mene ndratorowenei. ");
INSERT INTO lid_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Len doh kameh len ndra-in labai tiri badih ale nah ereu tiri, ma badih nah ma nyandren! Tasah, Kindrei kameh ibolosen i tiri lau badu munyak dah, ma iri kameh bwese maha-an laba tinan labai. ");
INSERT INTO lid_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ya idah kameh, iri amundroh lau rayah na samen, ya iri rayah kameh kuhi iri a bonyo-ou a kon munyak tinan mari. Ma iri lau badu leheleh kameh atondrok lakou mari badu Jerusalem, winiya le tondrok tiri barano. ");
INSERT INTO lid_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Idah kameh kalem asahan ta an, kalem asahan ta bun hawe iri ndrau. Ya iri kon munyak tinan kameh bwese maha-an laba tinan labai, hawe iri anoh ma anyon ala ame ta kurutuwe bayau badu ndras. ");
INSERT INTO lid_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lau mari kameh anoh ma mada iri abuluw ta lakou kameh asahan la-u kon munyak, ma boto-on mari badu kandrah kameh nyukunyok. ");
INSERT INTO lid_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ano amwenen ta lakou doh, asahan kameh, iri lau kameh anyolom Nadu Ndramak Awas asahan ereu bwele-e asi kandrah, ma boto-on tan ma lomadan tinan labai. ");
INSERT INTO lid_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Eme ya, i buku none ado atou lakou mari doh kasahan badeh, mada ado katele ai, tasah len ta ndramak ta seben badeh, ndrame bakep ai.” ");
INSERT INTO lid_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ano ja iy asehek sahou sokek doh i toro, “Ado kanyolom kei pik hawe iri kei mari kede-eh se. ");
INSERT INTO lid_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","I buku none ado katou la-un ha-un kasahan badeh, ado tana ado, idah kameh kon i le an ai. ");
INSERT INTO lid_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ya, buku ado anyolom iri lakou nane jo ndrasehek, ado tana ado tondrok ta Kindrei ndrame bakep ai. ");
INSERT INTO lid_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Jo tiye tado handru en! Iri lau rebesem areu kede-eh kahis na len dah kameh bamak bwe le, iri lakou doh kameh asahan. ");
INSERT INTO lid_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kandrah ma kon munyak dah kameh ano iu, arile sahou tek le kameh winiyan bano bwe. ");
INSERT INTO lid_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Bale ado ki tado doh! Ado satehei budon hawe ndrine ado sahis ta lakou badu kon munyak, hawe ado sabulum ndrine ado na nyamon hawe a-un gwa boto-on ta amekes manyah tado kudu mwasin. Bwe kameh, len doh asahan kameh i le mani tur. ");
INSERT INTO lid_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tasah, lakou doh kameh asahan eme ta lau mari badu munyak. ");
INSERT INTO lid_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Arile, na len mari, mada ado kaleu hawe ado kasolom, eme ya ado winiyan ales boto-on ma ado winiyan teleyani lakou doh kameh asahan. Ma hawe ado winiyan ales are mada Nadu Ndramak Awas.” ");
INSERT INTO lid_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na len ari ari badeh, Jises leheya udu asiu tinan ta Kindrei. Ano kon eben, iy iu ili mandrei Olip amadin. ");
INSERT INTO lid_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Eme iri lau mari na mandraben badeh, ala anuhun iy asehek sahou udu asiu tinan ta Kindrei. ");
INSERT INTO lid_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Kabwai, mirihik ta len ta nyamon tinan, ta jabi ramen yis bolon bwe asahan ai, iri aloh Pasoba. ");
INSERT INTO lid_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Eme iri lau tinan tiri pris, hawe iri lau ta leheya kandriyen tiri Juwis anya kadi Jises ki san ta bahana le. Tasah, iri badeh, anoh iri lau solo-an ado aliy. ");
INSERT INTO lid_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Eme Satan badeh, i bolo ndramak ari badu bolo oro lau ma ronoh la-uh ta Jises, nyaran Judas Iskariyot. ");
INSERT INTO lid_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Eme iy ili edeu sa-oh i tiri lau tinan tiri pris, ma hawe iri lau tinan ta ndrokei ta atondrok asiu tinan ta Kindrei, ma oro asehek nyala aliy; ta Judas kameh edeu Jises ki mine oro ki buku sah handru. ");
INSERT INTO lid_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Eme oro sekesek ta aliy, ma sekesek ta asih Judas na luk. ");
INSERT INTO lid_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Eme Judas sekesek ta aliy, ma iy ili takaleh madasan ta kadeu Jises ki san ta bahana le, ya iri lau sala tanan ta aliy labai. ");
INSERT INTO lid_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ano, len ta nyamon tinan ta jabi ramen yis bolon bwe badeh, asahan. Len doh, iri aloh Pasoba. Idoh badeh, iri pris adai sipsip kasen ta aimon ta Pasoba. ");
INSERT INTO lid_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Eme Jises suni Pita uru Jon kala Jerusalem ma tiye turu anya, “Ah kala bwena kalowosa lakou ta to ta aimon na len ta Pasoba.” ");
INSERT INTO lid_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eme uru anya, “Ou aseken aru kala heh, kalowosa na to nyamon?” ");
INSERT INTO lid_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Eme Jises tiye turu anya, “Ah kanuhun. Ah kadek kala bolo kon tinan badeh, ya idah kameh, ah atou ndramak ari bwese-ei gwa in bolo sabok kameh ndruni ah. Eme ah ka-en hamon tan kala asiu iy ili aliy, ");
INSERT INTO lid_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ma ah katiye ki ta ndramak ta asiu anya, ‘Ndramak ta leheya anya, asiu tan ndraheh? Ya idah kameh oro lau tan ma iy kameh aimon nyamon ta Pasoba a-en aliy.’ ");
INSERT INTO lid_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Idah kameh, iy leheyani ah ta bolo asiu ari udu loken badeh, ndralowosani le. Eme ah kala aliy kamekes nyamon kudu le tato ai.” ");
INSERT INTO lid_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eme uru ala amwenen le, i buku boho Jises ndratiye turu nane. Eme oro lowosani nyamon ta Pasoba ma asiu buku le aliy. ");
INSERT INTO lid_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Eme mada an ta aimon nyamon asahan badeh, Jises hawe oro lau tan manyah ado andri ndrahu nyamon. ");
INSERT INTO lid_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ano iy tiye i toro anya, “Jo badeh, aseken handru ta aimon nyamon ta Pasoba dah hawe ado, tasah len hamon eme kameh, jo kameh bwese sisi-in tinan labai. ");
INSERT INTO lid_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Eme jo katiye tado kamwenen, jo kameh winiyan baimon nyamon na len ta Pasoba ja bwai; winiya le barasahan handru i san ta imek tek i nyara Pasoba, ma tondrok ta Kindrei winiya udu le buku doh.” ");
INSERT INTO lid_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ano, Jises kuhi bwiniu ma iy edeu wurah, ma edeu salom, ma tiye anya, “Ado ka-un waen dah, a sese le ki winiya ado. ");
INSERT INTO lid_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Jo katiye tado kamwenen, jo kameh winiyan ba-un ndraye buwa waen dah ja bwai, winiya le tondrok ta Kindrei barasahan.” ");
INSERT INTO lid_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ano Jises kuhi jabi ramen, iy edeu wurah i ta aliy, ano iy boso-ei i noro ma iy anya, “Idah odak amwenen. Jo edeu ta aseben ado. Ado kamekes kandriyen ki le buku doh ta abudon jo.” ");
INSERT INTO lid_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ano i le buku aliy, nyamon ano badeh, iy kuhi bwiniu waen, ma iy anya, “Bwiniu waen dah, kalem ta sahou randra le ha-un ja, ta ndrayek amou ewek ta aseben ado mari. ");
INSERT INTO lid_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Arile, ndramak ta edeu sa-oh tek hawe ta edeu jo i mine iri lau ndra-in badeh, manyah udu ndrahu nyamon hawek kada-ah. ");
INSERT INTO lid_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nadu Ndramak Awas kameh imek, ya sahou ta aliy bwai. Idoh in hamon ta seken ta Kindrei le. Arile sisi-in laba tinan kameh i bwele-e ndramak iy ale atehei iy ili mine iri lau ndra-in.” ");
INSERT INTO lid_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Eme oro ndremenya oro ari ari ta are lau handru badu bolo oro doh kameh amekes lakou doh. ");
INSERT INTO lid_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma hawe oro ale andres oro ta are handru kameh kudu bwele-en toro. ");
INSERT INTO lid_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Eme Jises tiye i toro anya, “Iri kabin tiri lau badu leheleh badeh, atondrok iri lau tiri, ya oro aseken iri lau doh badeh, kaloh oro kawas toro ta aseben oro. ");
INSERT INTO lid_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Arile, ado badeh, sala buku doh, ndri-iy labai. Are tado nyaran udu loken badeh, katehei iy keme andri ki buku nah bwisik. Ya are tado udu bwena badeh, iy kasahan lau ta gok kereu ndrokowa ado. ");
INSERT INTO lid_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Are lau handru udu bwele-en? Ndramak ta asiu aimon nyamon deh, bwe, iy lohowan ta atiye nyamon? Sebwe iy ndramak ta asiu dah, nadeh? Arile, jo udu ndrokowa ado badeh, i buku lohowan ta aseben le ado. ");
INSERT INTO lid_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ado le badeh, baruwani jo bwe, ado an hawek na len mari jo bwese maha-an. ");
INSERT INTO lid_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","I buku none tama le edeu boto-on dah, eme tek ta atondrok, ya na dah jo kameh edeu ewek tado atondrok i le buku aliy. ");
INSERT INTO lid_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Eme ya ado kameh aimon nyamon, ma a-un gwa ado bolo tondrok tek, ma ado kameh manyah ado koyeu hawek anuhun sahou toro boho kamen ma ronoh la-uh badu Isra-el. ");
INSERT INTO lid_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Ou ndranuhun Saimon! Tama Balik Satan badeh, ndrasumon ta none ado mari ta anya kapou ado, i buku ndramak ta bilin aleben buwa wit i len, ya munyahun i len. ");
INSERT INTO lid_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Arile, Saimon, jo badeh, ndrasolom ta budon handru tam sataku. Ya, i buku none ou taku, ou badeh, tubuni ndrinem ma ou aseben budon toro kirih ja.” ");
INSERT INTO lid_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Arile, Pita tiye i ta Jises anya, “Laban, i buku none ou ala bolo kou kameh jo ewek hawem ale. Ya, i buku none ou amak kameh jo imek hawem ale.” ");
INSERT INTO lid_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Eme Jises tiye i tan anya, “Pita, jo katiye tam kamwenen. Na ben kameh, kakaro baden bwe le, ou kameh besebes anya ou tanam jo bwe san tulusin.” ");
INSERT INTO lid_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ano Jises ndremenya oro anya, “Jo mene suni ado ala laleyah, ari kohoya ado bwe, ya ari kohei ndrahu luk tado bwe, ma hawe ari ku-i kati ado bwe. Eme ado andriliu ta ari lakou deh bwe?” Eme oro anya, “Bo-oh, aso bandriliu ta ari lakou bo-oh.” ");
INSERT INTO lid_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ya eme iy tiye i toro, “Arile, na dah kameh i buku none ado ari kohei ta kohoya luk bwe, hawe i buku none ado ari kohoya ado ari kohei ta ndrahu lakou bwe badeh, ado kasilah tado ai. Ma i buku none ado ari samen ta bahun bwe, badeh, ado katehei lakou tado ki ta sisih ya ado kasih samen ta bahun ki tado. ");
INSERT INTO lid_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sahou mene ndratorowenei anya; ‘Iri lau badeh, ondrek jo ale udu mada sahou, hawe iri lau ndra-in.’ Ya eme, jo katiye tado kamwenen, lakou doh kameh asahan handru eme badak. Handru labai sahou mene ndratorowenei asehek ta nyalak, ndrame bakep handru.” ");
INSERT INTO lid_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eme oro lau tan anya, “Laban, ou anyolom samen ta bahun la-uh asah idah.” Eme Jises anya, “Badeh, ka-iy ai.” ");
INSERT INTO lid_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ya eme, i buku none Jises mene ndramekes ndra-au ndra-au badeh, iy hawe oro lau tan ala bwili ndrondro-ou Olip. ");
INSERT INTO lid_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Oro asos badeh, Jises tiye i toro anya, “Ado kasolom ki ta Kindrei ta ado, sataku sala bolo kandriyen ndra-in.” ");
INSERT INTO lid_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ano iy ili bwena sese, reu i buku none ndramak korou bek kili kisos aliy en. Eme iy atehei bwili ndru-un i andri ma iy asolom anya, ");
INSERT INTO lid_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tama, na seken tam le, i buku none ou aseken badeh, ou andrei bwiniu ta isi udu hawek ki-iu. Arile idoh budon tek le, ou amekes ta seken tam le kasahan ki handru.”  ");
INSERT INTO lid_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","44","Eme angelo ari badu kandrah eme edeu boto-on i tan. Eme ya Jises atona maha-an laba tinan labai, ma iy asolom irih le gwek; ma sa-ar tan atekeu i buku none ndra i andri bada munyak. ");
INSERT INTO lid_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ano iy suri iy eme loke edek ili hawe oro lau tan atou oro ndramadin ta tikisiy. ");
INSERT INTO lid_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Eme iy anya, “Ado amadin ta sasah? Ado kamak kasolom ki ta Kindrei ta ado sataku sala bolo kandriyen ndra-in.” ");
INSERT INTO lid_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ya eme iy asehek sahou kahis le, Judas, iy badu hawe oro lau ma ronoh la-uh nane, in mwena ma hawe lau rayah an hamon tan, ame. Iy edek eme hawe Jises anya kedeu bohon ki boho Jises. ");
INSERT INTO lid_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Arile, Jises lelen iy anya, “Judas, ou kameh adeu bohom eme bohok ma leheya Nadu Ndramak Awas i mine iri lau ai?” ");
INSERT INTO lid_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eme oro lau ta Jises anyolom teheya lakou asahan badeh, oro tiye i ta Jises anya, “Laban, aso amundroh oro na samen ai?” ");
INSERT INTO lid_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Eme ari toro badeh, mwetehei ndranye bonyo-ou ta tinan tiri pris ari, salin iu. ");
INSERT INTO lid_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Eme Jises eme anya, “Ka-iy ai!” Eme Jises atehei minen i ndranye bonyo-ou dah, ma ndranyen amwenen ja. ");
INSERT INTO lid_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ano Jises tiye i tiri tinan tiri pris, ma i tiri tinan ta atondrok asiu tinan ta Kindrei, ma hawe i tiri lau batun tiri Juwis nane, ame ta ateu iy dah anya, “Buku sah ya ado ame ma samen hawe kei? Jo ari lau ta amekes ramwes deh? ");
INSERT INTO lid_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jo badeh, udu hawe ado na len mari udu asiu tinan ta Kindrei, eme ya ado bateu jo bwe. Arile, na ben dah, ben tado ta amekes ai, tasah boto-on ta balik badeh, ndratondrok kon ai.” ");
INSERT INTO lid_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iri tawi Jises ma andrei iy ili asiu ta tinan tiri pris. Ya Pita badeh, edek udu hamon tiri amunum le, udu ndra len eme. ");
INSERT INTO lid_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ya iri badeh, tabani jih udu lohalak ta bolo kowah ta mada asiu doh, ma iri manyah anyan jih. Pita ili badeh, manyah udu hawe iri. ");
INSERT INTO lid_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Eme badih ari ta lohowan atou Pita udu lomada jih. Eme iy anyolom Pita amwenen badeh, iy anya, “Iy ndramak kede-eh mene, ari badu hawen adeh.” ");
INSERT INTO lid_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Eme Pita besebes anya, “Ou badih den, jo tanan iy ndramak kede-eh bo-oh.” ");
INSERT INTO lid_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ano udu ja badeh, ndramak ari atou iy ja anya, “Ou kede-eh, ari badu hawe oro adeh.” Eme Pita anya, “Aden, jo bwe!” ");
INSERT INTO lid_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ano udu luluwen badeh, ndramak ari ja anyolom Pita ili ili, ya iy seleyani Pita ma iy anya, “Iy ndramak kede-eh, badu hawen handru ma iy badu Galili.” ");
INSERT INTO lid_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Eme Pita anya, “Aden, jo maliye sahou ou asehek badeh!” Pita asehek udu ndra bohon le badeh, kakaro eden. ");
INSERT INTO lid_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Eme ya Jises tubuni iy, ma anyolom amwenen eme ta Pita. Eme Pita bwetenei sahou ta Laban mene asehek i tan i buku doh: “Na ben dah kameh kakaro baden bwe le, ou kameh besebes anya ou tanam jo bwe san tulusin.” ");
INSERT INTO lid_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Eme iy iu ili len, ma iy eden andra-i labai. ");
INSERT INTO lid_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ya eme oro lau ta ndrokei atondrok Jises badeh, bobose iy ma a-um iy. ");
INSERT INTO lid_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Eme oro sawei madan na kolau ma oro andrek iy anya, “Abo, buku none ou propet, ou none tiye se, are lau a-um ou doh?” ");
INSERT INTO lid_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma hawe oro asehek sahou ndra-in solo-an i badan. ");
INSERT INTO lid_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kon aleu badeh, iri lau tinan atukum ame hawe iri tinan tiri pris, hawe iri lau ta leheya kandriyen tiri Juwis atukum iri ase. Ano iri lau tiyani Jises ili ales udu mada iri. ");
INSERT INTO lid_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Eme iri anya, “Abo, ou tiye taso! Ou kede-eh Krais deh?” Eme Jises anya, “I buku none jo katiye tado kameh, ado anya jo wasai. ");
INSERT INTO lid_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma i buku none jo kandremenya ado ale kameh, ado winiyan basumon bohok bwe. ");
INSERT INTO lid_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Arile, na dah ma na len eme kameh Nadu Ndramak Awas kameh manyah udu loboho lim salin ta Kindrei iy boto-on labai.” ");
INSERT INTO lid_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Eme iri ndremenya iy anya, “Sebwe, ou kede-eh Nadu Kindrei ai?” Eme iy tiye i hamon i toro anya, “Ehe, ado tiye badeh, amwenen handru!” ");
INSERT INTO lid_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ano iri anya, “To anya kanuhun bohon ja ta sasah? To ndranuhun amwenen udu bohon kede-eh!” ");
INSERT INTO lid_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ano iri lau mari nane suri iri are loken ma tiyani Jises ili hawe Pailat, ");
INSERT INTO lid_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Eme iri tebeya wasai anya, “Ahi badeh, ndratakalahei ndramak dah amekes bolo manyah tiri lau tahi, bamwenen bwe. Iy tandra-un tiri lau badeh, sakeh luk sala ta Sisa, ma tiye anya, iy badeh, Krais, ma iy kabin tiri Isra-el.” ");
INSERT INTO lid_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ya eme Pailat ndremenya iy, “Ou kabin tiri Juwis neh?” Eme Jises anya, “Ou ndrasehek badeh kabwai.” ");
INSERT INTO lid_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ano, Pailat aloh i tiri tinan tiri pris, hawe iri lau mari dah, anya, “Jo batou ari lakou ndra-in iy ndramak dah, amekes bo-oh!” ");
INSERT INTO lid_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Arile, iri sarakau anya, “Iy mene leheya ma amekes ndrokowa iri lau badu loboho Judiya bado mwasin bwe. Iy mene amekes kandriyen doh, udu ndra Galili on, eme taku dah.” ");
INSERT INTO lid_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Eme Pailat anuhun sahou nane iri asehek ano iy ndremenya iri anya, “Iy badu Galili handru?” ");
INSERT INTO lid_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ya eme Pailat akohok tanan amwenen ta kon ta Jises. Kon ta Jises badeh, udu baha tondrok ta Herot, eme iy suni Jises ili hawe Herot. Tasah, na len doh badeh, Herot udu Jerusalem ale. ");
INSERT INTO lid_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Eme Herot atou Jises badeh, iy sekesek handru, tasah iy ndra mwena mwena ndra-au badeh, aseken ta atou Jises labai. Iy mene anuhun le nyalan, eme na dah, iy anya kanyolom Jises kamekes kalem. ");
INSERT INTO lid_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Iy ndremenya Jises san solo-an solo-an, arile Jises andru-uk le. ");
INSERT INTO lid_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Eme iri lau tinan tiri pris, hawe iri lau ta leheya kandriyen tiri Juwis adek ame mirihik asehek sahou boto-on i bada Jises. ");
INSERT INTO lid_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ano Herot hawe oro lau ta bahun tan bobose iy, ma atehei kolau moroyan i la-un, ma suni iy i hamon hawe Pailat ja. ");
INSERT INTO lid_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na len bwena ndra-au, Herot uru Pailat badeh, ndrokowa uru udu aliy, arile na le len dah, badeh, uru ndra kawas ja. ");
INSERT INTO lid_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ano Pailat luhi iri lau hawe iri tinan tiri pris, ma hawe iri lau ta atondrok, hawe iri mari, ame. ");
INSERT INTO lid_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ya eme iy tiye i tiri anya, “Ado tiyani ndramak dah eme, ado anya iy badeh, amekes bolo ndrokowa iri lau andra-i. Udu mada ado nane ndra-au badeh, jo batakalahei ari lakou ndramak dah, amekes andra-i, i buku none ado mene asehek, bwe. ");
INSERT INTO lid_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma Herot ale batakalahei ari lakou iy amekes andra-i bwe le. Ya eme ado anyolom, iy suni iy eme hamon ja dah. Iy winiyan bamak laleyah bwe, tasah iy bamesekei ari lakou bandra-i bwe. ");
INSERT INTO lid_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ya eme, idah kameh jo tiye iri lau ta bahun tek amekes isi i badan, ano iy bara-au.” ");
INSERT INTO lid_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Arile, iri mari sarakau i le rasan anya, “Kadai iy, kadai iy! Ya karuwani Barabas keme hawe ahi!” ");
INSERT INTO lid_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas in bolo kou mene badeh, iy ta amekes bahun udu bolo kon tinan, ma hawe idi ndramak amak. ");
INSERT INTO lid_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Eme Pailat tiye i toro ja anya, “Katolowei Jises ki-iu ai?” ");
INSERT INTO lid_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Arile, iri aloh ma sarakau anya ja, “Katahi iy ki bada kei tondreh! Katahi iy ki bada kei tondreh!” ");
INSERT INTO lid_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ano i san tulusin ja iy tiye: “Buku sah handru, saba lakou ndra-in handru iy mesekei? Ndramak dah bamesekei se ari lakou bandra-i bwe, ya iy kimek laleyah ai? Eme idah kameh oro lau ta bahun tek ubwi iy ano iy bara-au.” ");
INSERT INTO lid_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Arile, iri arah ma tiye sahou boto-on anya, “Katahi iy ki bada kei tondreh!” Eme ma abadok i tiri ai. ");
INSERT INTO lid_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Eme Pailat in hamon ta boho iri ma tiye ta Jises badeh, kadai iy. ");
INSERT INTO lid_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ya eme iy ruwani Barabas mene amekes bahun udu kon tinan, ma idi ndramak badeh, udu bolo kou eme len. Ano iy atehei Jises ili mine iri, ma iri amekes sasah na seken tiri ai. ");
INSERT INTO lid_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Eme iri lau ta bahun badu Rom sirini Jises ili le badeh, iri ndruni ndramak ari nyaran Saimon badu kon Sairini. Iy edek udu kon munyak tinan eme. Eme iri tawi iy, atehei kei tondreh i kasen ma iy bwese udu hamon ta Jises. ");
INSERT INTO lid_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na bolo len doh badeh, iri lau mwan ma badih solo-an solo-an labai adek an hamon ta Jises. Ma hawe iri badih solo-an aden ma taya ndranye Jises. ");
INSERT INTO lid_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Eme Jises tubuni iy ma tiye i toro anya, “Ado badih badu Jerusalem, ado saden ndranyek; ado kaden ndranye ado le, hawe nadu ado oro. ");
INSERT INTO lid_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tasah, udu bolo maha-an doh, eme kameh iri tiye anya, ‘Iri badih kis, hawe iri badih bato-ou nah bwe, hawe iri badih ta asus nah bwe kameh ado mwasin ja tiri ala nah udu aliy.’ ");
INSERT INTO lid_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tasah, na bolo len hamon doh kameh iri lau badu Israel tiye i tiri mandrei anya, ‘Ado katohou kame bwele-e aso!’ Ma hawe tiye i ta bwilin ndrondro-ou anya, ‘Ado tubuluhi aso ma katone aso ta lakou ndra-in doh!’ ");
INSERT INTO lid_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iri kameh amekes lakou doh, eme badak. Ya jo kameh i buku kei nyamanyak. Ya i buku none len ndra-in handru keme kameh, ado kameh i buku kei sana-an.” ");
INSERT INTO lid_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Eme uru lau la-uh ndra-in ta tebelese badeh, sariye uru ala ta adeu uru ala bada kei tondreh ale. ");
INSERT INTO lid_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Eme iri asos kon aloh, “Bwisi bar ta ndramak.” Eme iri atahi Jises i bada kei tondreh. Ma hawe atahi uru lau ma la-uh nane ale. Eme, iy ari udu loboho lim salin ta Jises, ya ari badeh, udu loboho lim kamweu. ");
INSERT INTO lid_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Eme Jises tiye anya, “Tama, ou mani kandriyen ndra-in toro, tasah oro bala tana oro sasah oro amekes dah bwe.” Eme oro lau ta bahun atehei kolau tan i andri, ma oro amekes laki ta aliy, ta andrei kolau tan i le winiya oro. ");
INSERT INTO lid_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iri lau mari badeh, anyolom Jises, ya iri lau ta atondrok badu Juwis badeh, bobose iy anya, “Iy badeh, aseben iri lau rayah oh; ya abo, i buku none iy anya iy Krais handru, Kindrei suni iy; kanone iy kasebenei iy le amwenen se.” ");
INSERT INTO lid_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Eme ya iri lau ta bahun ame bobose iy ale. Ma iri adeu waen titi-in i tan, ");
INSERT INTO lid_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ma iri anya, “Buku none ou kabin tiri Juwis handru eh, ou none sebenei ou le se!” ");
INSERT INTO lid_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ya sahou tanan ari badeh, torowenei udu bwele-e batu Jises tiye i buku doh: “Idah Kabin tiri Juwis” ");
INSERT INTO lid_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Eme ndramak ndra-in ari udu ta kei tondreh mirihik tan nane asehek sahou ndra-in i ta Jises anya, “Ou kede-eh Krais, bwe nadeh? Ou sebenei ou, ma hawe aru ah!” ");
INSERT INTO lid_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Arile, ndramak ari udu bilisiu badeh, ibolosen i tan anya, “Ou kede-eh, banoh Kindrei bwe nadeh? Ou badeh, bwese maha-an i le buku iy kede-eh! ");
INSERT INTO lid_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Talu bwese maha-an dah, amwenen ai, ta lakou talu amekes, arile iy badeh, bamekes se ari lakou bandra-i bwe.” ");
INSERT INTO lid_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ano iy tiye i ta Jises anya, “Jises, i buku none ou ame hamon, ma boto-on tam atondrok kon mari, ou samani jo.” ");
INSERT INTO lid_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Eme Jises tiye i tan, “Jo katiye tam kamwenen handru en, na le dah kameh, ou ado hawek ado kon mwasin udu kandrah.” ");
INSERT INTO lid_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Eme, an eme udu le alih badeh, lulik tubuluhi kon marakon udu gwek winiya mada an taloh na beyeh. ");
INSERT INTO lid_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma an banya bwe. Eme ma kolau ta aturuk madasan ta asiu tinan ta Kindrei badeh, atarah i le ma lusi. ");
INSERT INTO lid_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Eme Jises aloh bohon i loke, anya, “Tama! Jo atehei kohak handru ewek minem.” Iy tiye sahou doh ano le badeh, kohan ano ma iy imek. ");
INSERT INTO lid_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Eme ndramak ari tinan ta bahun anyolom lakou nane doh asahan badeh, iy atudun nyara Kindrei ma anya, “Handru labai, ndramak kede-eh, mwasin labai ta mada Kindrei.” ");
INSERT INTO lid_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ya eme iri lau mari anyolom lakou marakon doh badeh, ndrine iri tikisiy andra-i labai, ma mine iri i ade iri, hawe kandru iri i andri, ma iri adek au. ");
INSERT INTO lid_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Arile, oro are tanan iy, hawe oro badih mene an hamon tan ado ndra Galili ame badeh, ales ado len anyolom lakou mari doh asahan. ");
INSERT INTO lid_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ya eme ndramak ari badu hawe iri kansol nyaran, Josep badeh, ndramak ari mwasin handru ta mada Kindrei. Iy badeh, badu kon ari iri aloh Arimateya udu bolo kon loboho Judiya. ");
INSERT INTO lid_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ya iy mene basekesek ta budon tiri mene amekes i bada Jises bwe. Ma hawe iy udu le, abe-en tondrok ta Kindrei kasahan. ");
INSERT INTO lid_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Eme iy ili hawe Pailat ta ndremenya bada kei. ");
INSERT INTO lid_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ano iy eme kuhi bada kei eme andri, su-i iy na kolau ra-ei belen, ma atehei iy i munu bek ari, ndrasaniy bwena, ya lau bala aliy bwe le. ");
INSERT INTO lid_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Idoh badeh, asahan na len ta alokou len ta amunyau, anya kasahan ai. ");
INSERT INTO lid_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Eme oro badih mene ado hamon ta Jises ado ndra Galili ame badeh, an hamon ta Josep ala anyolom munu bek nane, hawe anyolom lowosa iy i bolon i andri i buku sah. ");
INSERT INTO lid_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ano oro au ala kon anyas ndrelekei hawe suluw ta amekes ki badan. Arile, oro amunyau na len ta amunyau in hamon ta batanau ndratiye. ");
INSERT INTO lid_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Len ta amunyau ano, ya ma ndra wahun ta len ma bwena ta wik ari ja, oro badih mene andrei ndrelekei hawe suluw, oro mene amekes badeh, oro ala mada lek. ");
INSERT INTO lid_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Oro ala badeh, anyolom bek ta mada lek ndratundruwiy ndra len. ");
INSERT INTO lid_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eme oro ala bolon badeh, oro banyolom Laban Jises bare aliy bwe. ");
INSERT INTO lid_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Eme ya oro lomondra solo-an solo-an ta aliy le badeh, oro anyolom lau la-uh asini awin lomadan labai i buku kalik ame ales are ka-u oro. ");
INSERT INTO lid_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Eme oro badih dah, anoh labai badeh, oro aluh ala andri bada munyak. Eme uru lau ma la-uh dah, tiye i toro anya, “Ado anya kame kanyolom ndramak mulin udu ndrahu lau amak dah ta sah? ");
INSERT INTO lid_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ado ndramani sahou mene iy tiye tado udu Galili ja? Iy bado dah bwe; Iy ndramak ja! ");
INSERT INTO lid_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nadu Ndramak Awas mene atehei iy i mine iri lau ndra-in ta karei ma lomondra ndra-in, ya iri atahi iy i bada kei tondreh, ma iy imek. Ya eme na len taloh ja badeh, iy ndramak ja ndrame loken.” ");
INSERT INTO lid_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ano badeh, oro baralomondrani ai. ");
INSERT INTO lid_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ano oro ado mada lek ame hamon badeh, oro asehek i toro lau ta Jises ma ronoh ari hawe asehek i tiri lau rayah ja. ");
INSERT INTO lid_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Oro badih nane badeh, Mariya Makdala, Jo-ana hawe Mariya tine Jemis ma hawe oro lau rayah are hawe oro asehek nyala oro aposel. ");
INSERT INTO lid_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Arile, oro batehei budon toro handru bala ta sahou toro badih nane bwe, tasah oro anya sahou toro badeh, ari moson bwe. ");
INSERT INTO lid_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ya eme Pita suri iy ma sakaliye ili mada lek. Eme iy aluh anya kanyolom kili badeh, atou le kolau le udu api. Ya eme iy eme len badeh, lomondra i tan le, ta lakou nane asahan dah. ");
INSERT INTO lid_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Eme na le len doh badeh, uru lau ta Jises la-uh badeh, adek ado san ala kon Ema-us. San doh, udu Jerusalem ili Ema-us badeh, i buku none kilomita ronoh ari. ");
INSERT INTO lid_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Uru adek san asehek nyala lakou mari mene ndra-au. ");
INSERT INTO lid_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Uru asehek nyala uru ala le, eme Jises asahan hawe uru. ");
INSERT INTO lid_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Arile, uru baseleyani se iy bwai. ");
INSERT INTO lid_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Eme iy tiye i turu anya, “Ah asehek nyala ah ta sasah nane adek san dah?” Eme uru ado rasi, ma mada uru i andri ta tikisiy. ");
INSERT INTO lid_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Eme iy ari nyaran Kliyopas anya, “Ou dah, lau badu leheleh barame Jerusalem ai, ya ou tanam lakou mari mene asahan doh bwe?” ");
INSERT INTO lid_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eme iy anya, “Saba lakou asahan deh?” Eme uru anya, “Aru badeh, asehek nyala Jises badu Nasaret. Iy badeh, propet. Iy asehek sahou badeh, sahou tan nyarahan labai, ma iy badeh, udu mwasin labai udu mada iri lau mari, ma udu mada Kindrei, ta bolo lahou tan mari iy amekes. ");
INSERT INTO lid_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Eme ya iri tinan tiri pris tahi, ma hawe iri lau ta atondrok ahi, atehei iy ili mine iri lau ta bahun badu Rom, ma atahi iy i bada kei tondreh. ");
INSERT INTO lid_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Arile, ahi badeh, abudon boto-on tan anya, iy le kameh winiyan sebenei iri lau badu Isra-el ado mwasin. Ya eme idah, i bada len taloh ai, ta lakou mari mene asahan. ");
INSERT INTO lid_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma laba tinan ja badeh, oro badih rayah badu hawe aso badeh, mesekei boho aso asak handru ta aliy. Oro badeh, ala mada lek na mandraben nane anya katou iy, ");
INSERT INTO lid_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","arile oro batou iy bado aliy bwe. Eme oro ame badeh, tandra-un nyala aso mari ta aliy, ma oro tiye badeh, anya oro atou oro angelo ale. Ya eme oro angelo tiye i toro anya, ‘Jises ndramak ja.’ ");
INSERT INTO lid_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Eme oro lau taso rayah ja ala atou, i le buku aliy. I buku none oro nane ndrasehek, oro banyolom iy bwe.” ");
INSERT INTO lid_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Eme iy tiye turu anya, “Ah badeh, ndra bwe oh, ma ndrine ah badeh, edek amunum labai ta budon handru ta lakou mari mene iri propet asehek! ");
INSERT INTO lid_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Idoh mwasin o? Ta Krais mene bwese maha-an doh, ya eme iy winiyan ili bolo lomadan tan.” ");
INSERT INTO lid_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Eme iy asehek nyala lakou mari udu bolo sahou ta Kindrei i turu aleu labai, udu ndra kabatana Moses hawe tarou tiri propet, ano i turu. ");
INSERT INTO lid_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ya eme oro adek ame mirihik ta kon nane oro anya ka aliy badeh, Jises edek ales ili. ");
INSERT INTO lid_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Arile, uru anya, “Ei, ou anya a heh? Ou amadin hawe aru na ben dan op, mirihik kon eben ai.” Eme iy eme hamon hawe uru. ");
INSERT INTO lid_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Eme Jises manyah hawe uru udu andri ndrahu nyamon badeh, andrei jabi ramen ma edeu wurah i ta aliy. Ano iy boso-ei ma edeu i nuru. ");
INSERT INTO lid_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Eme mada uru aleu, ma uru baraseleyani iy ai. Arile, bwe adeh, iy ndramai ta mada uru ai. ");
INSERT INTO lid_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Eme uru asehek i turu ari ari anya, “Sahou tan doh mene adeh, mesekei aru abadok ma sekesek adeh! Na len mene, iy edek san hawe talu asehek sahou mari badu bolo sahou ta Kindrei aleu eme ta talu.” ");
INSERT INTO lid_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Eme uru suri uru suwi suwi ala Jerusalem. Eme uru ala badeh, ndruni oro lau ma ronoh ari ta Jises hawe lau rayah are hawe oro atukum. ");
INSERT INTO lid_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Eme oro anya, “Handru! Handru! Laban badeh, n