﻿USE sofia;
DROP TABLE IF EXISTS sofia.lhi_vpl;
CREATE TABLE lhi_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lhi_vpl WRITE;
INSERT INTO lhi_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Liq che ve awr lehr, Ar brar hanr ve awg yad he lehq Dar viq ve awg yad phehq che Yer suq Khreq ve awg ceng awg khad teq cax peg teq cax te yaq lag lar che awg lawn buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ar brar hanr ve awg yad awr lehr, Id caq yaog. Id caq ve awg yad awr lehr, Yar koq yaog. Yar koq ve awg yad awr lehr, Yud daq he lehq yawd ved awg vix awg nax teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yud daq ve awg yad awr lehr, awg mid ma Tar mar lor paw lar che Phar rehq he lehq Ser raq yaog. Phar rehq ve awg yad awr lehr, Her sar ronr yaog. Her sar ronr ve awg yad awr lehr, Ar ranr yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ar ranr ve awg yad awr lehr, Ar miq nar daq yaog. Ar miq nar daq ve awg yad awr lehr, Nar sonr yaog. Nar sonr ve awg yad awr lehr, Sar lar monr yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sar lar monr ve awg yad awr lehr, awg mid ma Rar haq geh paw lar che Bawd saq yaog. Bawd saq ve awg yad awr lehr, awg mid ma Rud thaq geh paw lar che Awd behq yaog. Awd behq ve awg yad awr lehr, Ye sehd yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ye sehd ve awg yad awr lehr, Jawd mawd Dar viq yaog. Dar viq ve awg yad awr lehr, Ud rid yaq ve awg mid ma te jaw che yad mid te ghad geh pawag che Sawd laq monr yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sawd laq monr ve awg yad awr lehr, Rawd baor yaog. Rawd baor ve awg yad awr lehr, Ar bid yaq yaog. Ar bid yaq ve awg yad awr lehr, Ar saq yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ar saq ve awg yad awr lehr, Yawd sar phaq yaog. Yawd sar phaq ve awg yad awr lehr, Yar hawd ranr yaog. Yar hawd ranr ve awg yad awr lehr, Awd siq yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Awd siq ve awg yad awr lehr, Yod tanr yaog. Yod tanr ve awg yad awr lehr, Ar khad yaog. Ar khad ve awg yad awr lehr, Her sar kiz yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Her sar kiz ve awg yad awr lehr, Maq nad ser yaog. Maq nad ser ve awg yad awr lehr, Ar monr yaog. Ar monr ve awq yad awr lehr, Yod siq yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yod siq ve awg yad awr lehr, Bar bud lunx muhd mig lo su yug kae che teq coaq thad, Yer khawd niq he lehq yawd ved awg vix awg nax teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Bar bud lunx muhd mig lo su i hehd haq yug ve vehr khaz nuhr, Yer khawd niq ve awg yad awr lehr, Sar lar ter laq yaog. Sar lar ter laq ve awg yad awr lehr, Ser rud ber laq yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ser rud ber laq ve awg yad awr lehr, Ar bid oq yaog. Ar bid oq ve awg yad awr lehr, Ed lar kenr yaog. Ed lar kenr ve awg yad awr lehr, Ar cawr yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ar cawr ve awg yad awr lehr, Sar doq yaog. Sar doq ve awg yad awr lehr, Ar kher yaog. Ar kher ve awg yad awr lehr, Ed lid oq yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ed lid oq ve awg yad awr lehr, Ed lar sar yaog. Ed lar sar ve yad awr lehr, Mar thanr yaog. Mar thanr ve awg yad awr lehr, Yar koq yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yar koq ve awg yad awr lehr, Mar riq ve awg phad mawd Yod sehq yaog. Mar riq awr lehr, Khreq lehd koz che Yer suq haq pawag vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kheh te lehq, Ar brar hanr haq tanr te lehq Dar viq ve awg coaq lo kha gag che teq chi uhd co cawg che yaog. Dar viq haq tanr te lehq Bar bud lunx muhd mig lo su yug ve che awq coaq kha gag teq chi uhd co cawg che yaog. Bar bud lunx muhd mig lo su yug ve che haq tanr te lehq Khreq ve awg coaq kha gag teq chi uhd co cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yer suq Khreq paw che awr lehr, che kheh te che yaog. Yawd ved awr ye Mar riq he lehq Yod sehq he daq tug kar tiq te daq peg khaz nuhr, ix mag maq he daq ser huh, Daq che kehg che Awg ha phu ve kand pax haq cud lehq Mar riq yad hu vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yawd he tug kar tiq te daq lar che Yod sehq awr lehr, thed che cawd che chaw phehq lehq Mar riq ve mehz khuhd mad lug vid gad lehq, yawd haq taq chuhax teh lar haz tug duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yawd u kheh te duhd ngawx chehd che te yand huh, yuhq maz mawg che awg khuhn, Jawd mawd Ghig sa ve muhd nuh maq cuh yad te ghad tuhaz lehq koz che, “Dar viq ve yad Yod sehq-og, nawg kar tiq te lar che yad mid Mar riq haq he tug ta duhd har. Awg lawn ghod ver, yawd yad hu che awr lehr, Daq che kehg che Awg ha phu ve kand pax khuhn hu che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yawd yad par te ghad pawag tug yaog. Nawg yawd haq Yer suq lehd koz gha meh vid tug yaog. Awg lawn ghod ver, yawd ved chaw ceng haq i hehd ve vend bax teq pa awg khuhn yawd thaer khuhq vid tug yaog,” lehz muhd nuh maq cuh yad koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Awg ceng che ve teq pa phehaq che awr lehr, Jawd mawd Ghig sa yawd ved cuh kar var te ghad haq cud lehq koz lar che tawd khuhd peh lawq tug awg pun phehaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Yawd koz che, “Ngawx lar, yad mid hax te ghad yad hu lehq yad par te ghad pawag tug yaog. Yad par u ve haq Ed mar noer laq lehd koz gha meh vid tug yaog,” lehz koz lar che yaog. (Ed mar noer laq lehd koz che cuhx kig awr lehr, Ghig sa a nig geh chehd che lehd koz che yaog.) ");
INSERT INTO lhi_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yod sehq yuhq nuhd-ag che te yand, Jawd mawd Ghig sa ve muhd nuh maq cuh yad yawd haq koz vid lar che heh te lehq yawd kar tiq te lar che yad mid haq he che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kheh ma khuhd, yad par u ve maq paw ser che kheh ceh yawd awg mid ma geh mad yuhq. Yad par u ve pawag lehq yawd haq Yer suq lehd koz meh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jawd mawd Her roq ve awg co haq Yud daq muhd mig Behr lehr hehnr khaz awg khuhn Yer suq pawag che yaog. Awg khaz nuhr, cud yiq cawg var teq pa muhd ni tuhz phawd awr tuag lehq Yer ruq sar lehnr med huh lag gag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","I hehd koz che, “Pawag vehr che, Yud daq Jawd mawd khar lo awr le. Awg lawn ghod ver, muhd ni tuhz phawd awr lo yawd ved muhd ki sir haq ngag hehd gha mawg lehq yawd haq a kor pi tug ngag hehd lag che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jawd mawd Her roq tawd khuhd u ve haq gha kad che te yand, yawd he lehq Yer ruq sar lehnr med yad teq pa liz ni ma khuhn duhd har jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Yud daq chaw teq pa ve paw khod nux teq pa he lehq liq buhq var teq pa haq Jawd mawd Her roq kug phawng peg lehq, “Khreq khar lo pawag tuawg le,” lehd koz i hehd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","I hehd yawd haq kawq koz vid che, “Yud daq muhd mig Behr lehr hehnr khaz khuhn pawag tug yaog. Awg lawn ghod ver, Ghig sa ve cuh kar var che kheh koz buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yud daq muhd mig Behr lehr hehnr khaz-og, Yud daq Jawd mawd uq penr che khaz teq pa awg khuhn, nawg awr lehr suaq keh awg mig awg phond i che ma hez. Awg lawn ghod ver, ngag ved chaw ceng phehq che Id sar rer laq chaw haq seh kae tug Jawd mawd te ghad nawg geh tuhaz tug yaog,’” lehd koz buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kheh te lehq, Jawd mawd Her roq awr lehr, cud yiq cawg var teq pa haq taq chuhax kug yug veha lehq, muhd ki sir awg kawd maq tanr tuhaz che haq kha nehax na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","U kheh te peg lehq, Jawd mawd Her roq i hehd haq koz vid che, “Nig hehd teq pa kae lehq yad par nehax u ve haq kha nehax ca ngawx-eq. Yawd haq mawg vehr ver, ngag yawd haq a kor gha ca pi tug ngag haq liz kawq koz ax,” lehd koz vid lehq, yawd i hehd haq Behr lehr hehnr khaz lo kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jawd mawd Her roq ve tawd khuhd haq i hehd gha kad peg lehq, i hehd tu lehq muhd ni tuhz phawd awr lo i hehd gha mawg lar che muhd ki sir khaz nuhr ghaq kae lehq, yad par nehax chehd chehd che thang huh gaeg lehq jehd vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Muhd ki sir u ve haq gha mawg che te yand, i hehd teq pa ha lehg jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yehg khuhn gehe che te yand, awr ye Mar riq he lehq yad par nehax haq gha mawg lehq, i hehd boz cuhx lar lehq yad par nehax haq a kor pi che yaog. I hehd teq pa yug veha lar che laq sawnr haq pheq tuhz lehq si, lawd banr he lehq mud rar, laq sawnr che ve teq pa yawd haq tand vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jawd mawd Her roq chehd lo maq gha kawq koeq vid tug, yuhq maz che awg khuhn Ghig sa i hehd haq tawd yaw vid cheaq te lehq i hehd teq pa awr lehr, i hehd muhd mig lo koeq che, yaq kaw awg suhx te caz haq kawq koeq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","I hehd teq pa saw kawq veh vehr khaz nuhr, yuhq maz che awg khuhn Yod sehq haq Jawd mawd Ghig sa ve muhd nuh maq cuh yad te ghad lag lehq koz vid che, “Tu lor. Yad nehax he lehq awr ye ix mag haq sir ve lehq Ed jid tuq muhd mig lo phawe lor. Ngag nawg haq kawq koz ax thad kha gag u huh chehd laer. Awg lawn ghod ver, yad nehax haq dawz vehr tug Jawd mawd Her roq ghaq ca tod che yaog,” lehz koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","U ve teq hax khuhn, Yod sehq tu lehq, yad par nehax he lehq yawd ved awr ye Mar riq haq sir ve lehq Ed jid tuq muhd mig lo phawe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jawd mawd Her roq suh vehr che awg yand kha gag, i hehd u huh chehd chehd che yaog. Awg lawn che ve awr lehr, Jawd mawd Ghig sa yawd ved cuh kar var te ghad haq cud lehq “Ed jid tuq muhd mig khuhn, ngag ved yad par haq ngag kug tuhz tug yaog,” lehd koz lar che tawd khuhd u ve heh phehaq tug awg pun yawd te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Awg yand u ve khuhn, Jawd mawd Her roq awr lehr, cud yiq cawg var teq pa yawd haq her ka che law lehz gha sir vehr lehq, yawd nez nag jad che yaog. Cud yiq cawg var teq pa haq kha nehax na ngawx lar che awg yand haq yawd sawnr ngawx lehq Behr lehr hehnr khaz khuhn he lehq awg pad huh kha chehd che haw khaz nehax a saq nid khuhq haq tanr lehq awg huhx ve teq pa haq ca dawz vehr pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","U thad lo cuh kar var Yer rar miq koz lar che tawd khuhd u ve haq phehaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rar maq khaz awg khuhn, paz huhg kehd huhg che awg khuhd he lehq duhd har gad har che awg khuhd haq gha kad che yaog. Rar kher laq awr lehr, yawd ved yad teq pa haq te lehq huhg chehd lehq, yawd ved yad teq pa saw suh vehr cheaq te lehq su te ghad-eg liz yawd haq ni ma sa vid tug te maq gha,” lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jawd mawd Her roq suh vehr lehq, Jawd mawd Ghig sa ve muhd nuh maq cuh yad te ghad Ed jid tuq muhd mig khuhn chehd che Yod sehq haq yuhq maz che khuhn maw vid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Tu lehq, yad nehax he lehq awr ye ix mag haq sir ve lehq, Id sar rer laq muhd mig lo kawq koeq lor. Awg lawn ghod ver, yad nehax che ve haq dawz vehr tug ca chehd che chaw saw suh vehor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kheh te lehq yawd tu lehq yad nehax he lehq yawd ved awr ye haq sir ve lehq, Id sar rer laq muhd mig lo kawq koeq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kheh ma khuhd, Ar kher laq yawd awr pa Jawd mawd Her roq ve a yad haq kawq taz lehq Yud daq muhd mig haq uq penr chehd che awg lawn Yod sehq yawd gha sir che te yand, yawd kuhz lehq u huh koeq maq pir che yaog. Kheh te lehq yuhq maz che awg khuhn Jawd mawd Ghig sa yawd haq kawq koz vid lehq, Gar liq lehd muhd mig lo kae lehq, ");
INSERT INTO lhi_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nar sar rehq med khuhn ca chehd-eg che yaog. Kheh te lehq, “Khreq haq Nar sar rehq chaw lehd koz tug yaog,” lehz Jawd mawd Ghig sa ve cuh kar var koz lar che tawd khuhd u ve heh phehaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Awg yand u ve khuhn, Yod hanr a kaz tur var Yud daq muhd mig he pir khuhn awg god khehz teag lo bon ca mar lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Muhd nuh maq muhd mig lag gag vehr tez cheaq te lehq,vend bax haq duhd phuhz lor,” lehd bon mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Cuh kar var Id sar yaq koz lar che awr lehr, “Heh pir khuhn lo chaw te ghad kug lehq koz che. ‘Jawd mawd Ghig sa ve yaq kaw haq ghu te lar lor. Yawd ved yaq kaw teq pa haq thed-e lehd teog,’” lehd koz lar che tawd khuhd che ve te khuhd awr lehr, Yod hanr awg lawn haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yod hanr awr lehr, Kar lar oq awg muh te lar che beg ke haq veq deh lehq yawd ved cuh pehg huh sar gig caz te lar che sehx hang chuhq lar che yaog. Yawd ved cad tug awr lehr par ceq he lehq heh pir khuhn cawg che pehd ghig yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Awg yand u ve khuhn Yer ruq sar lehnr med yad, Yud daq muhd mig chaw awg gha lia he lehq Yawd danr lawg puhg huh kha chehd che chaw awg gha lia yawd chehd lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","I hehd teq pa a sug yawd ved vend bax teq pa haq koz mar vid lehq Yod hanr i hehd teq pa haq Yawd danr lawg khuhn a kaz tur vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","A kaz tur tug, Phar rir sehd he lehq Sar duq kehd chaw teq pa kha peh vad-ag yawd chehd lo phoz lag che haq Yod hanr gha mawg lehq yawd i hehd teq pa haq koz vid che, “Vig haeg awq tuhq ma yad teq paog, nez nag lehq cir yanr tug lag tod che haq gha pong tug a sug nig hehd haq koz ax cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nig hehd awg cehg mag ni ma pa lehq duhd phuhz vehr che awg ceng u ve te mar ser. ");
INSERT INTO lhi_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kheh te lehq, ‘Ar brar hanr awr lehr a nig ved Awr pa phehq che yaog,’ lehz nig hehd ve ni ma khuhn taq ca duhd gid chehd. Awg lawn ghod ver, Ghig sa awr lehr, huhx meh dig che ve teq pa haq yug lehq Ar brar hanr ve awg yad awg dug teq pa te tug te vid gha che yaog lehz ngag nig hehd haq koz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A meha loar suhz cehg khi cuhz per huh khi chuhz taz teh law lar peor. Kheh te lehq daq che awg sir mad nuhq che awg cehg teq pa haq thawq kuhd lehq, a mir khuhn yug chid bag ke tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nig hehd vend bax haq duhd phuhz vehr che haq gha sir vid tug awg pun, ngag nig hehd haq a kaz khuhn tur ax che yaog. Kheh ma khuhd, ngag khaz nuhr lag tug chaw te ghad awr lehr, ngag haq keh liz kand pax ir che yaog. Yawd ved khi noz haq yug cid lar tug kheh tawa liz ngag maq kenr. Chaw u ve te ghad awr lehr, Daq che kehg che Awg ha phu khuhn he lehq a mir awg khuhn, nig hehd haq baz tiz sar pehar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yawd ved laq kuhr khuhn, a cag fend tug yug cid chehd che yaog. Yawd ved a cag dawz kig haq kehr ghad jawq fend kha peg ver, cag sir cag yehg khuhn saw puhd ke tug yaog. Kheh ma khuhd cag cox haq vawr, maq suh vix che a mir khuhn tox ke tug yaog,” lehz Yod hanr koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Awg yand u ve khuhn, Yer suq awr lehr a kaz tur tug Gar liq lehd muhd mig khuhn tuhaz lehq Yawd danr lawg lo Yod hanr chehd huh lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kheh ma khuhd Yod hanr yawd haq tawr lehq koz che, “Ngag awr lehr, nawg geh a kaz khanr tur cawd che yaog. Nawg vawr ngag geh lag cheawg la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yer suq yawd haq kawq koz vid che, “A meha vawr che kheh te lar ser. Awg lawn ghod ver, thed che cawd che awg gha lia phehaq vid tug a nig te cawd che yaog,” lehz koz vid che yaog. Kheh te lehq Yod hanr yawd haq a kaz tur vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Yer suq a kaz tur peg lehq, a kaz khuhn tuhaz che awg yand u ve khuhn teq per maq lehax, muhd nuh maq phaw vehr che yaog. Kheh te lehq Ghig sa ve Awg ha phu liz a pia kar heh te yaq lehq, yawd thag huh miag che haq Yer suq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Muhd nuh kawag lo awg khuhd buhg tuhaz lehq koz che, “Chaw che ve awr lehr, ngag haq jad che Yad phu yaog. Yawd haq ngag ni ma cawd jad che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","U kheh te peg lehq, ned haeg ber che lawd che haq Yer suq gha khanr tug Awg ha phu yawd haq heh pir khuhn teq chaweh mad cawg awg god khehz teag lo sir ve kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yer suq awr lehr, awr ma cad che uhd chi ni uhd chi hax gaeg lehq awr meq jad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Awg yand u ve khuhn, ned haeg ber par u ve yawd chehd huh lag lehq koz che. “Nawg Ghig sa ve Yad phu awg cehg mag ver, huhx meh dig che ve teq pa haq pax kaq lehq khaor mod teog,” lehz Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yer suq kawq koz vid che, “Liq phu khuhn che kheh koz buhq lar che yaog. ‘Chaw yad awr lehr, cad tug haq lehax te lehq a saq teq gha che ma hez hawg. Ghig sa ve mawq kaw awg khuhn tuhaz che tawd khuhd awg mag gha lia haq te lehq a saq teq gha che yaog.’” ");
INSERT INTO lhi_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","U kheh te peg lehq ned haeg awr lehr, Yer suq haq daq kehg che med lo sir ve kae lehq, bon yehg nux muh jad che awg thag lo hox vid lar lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Nawg awg cehg mag Ghig sa ve Yad phu awg lehd koz ver, pawz kha peog. Awg lawn ghod ver, Liq phu khuhn che kheh koz buhq lar che yaog. ‘Nawg haq haq sax tug awg pun yawd ved muhd nuh maq cuh yad haq yawd koz vid lar peg che yaog.’ ‘Nawg ved khi kud huhx meh haq maq gha yaw vid tug, i hehd ve laq kuhr che lehq nawg haq haq yug ax vehr tug yaog.’” ");
INSERT INTO lhi_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yer suq yawd haq kawq koz vid che, “Liq phu khuhn ted kag kawq buhq lar ser che, ‘Nawg ved Jawd mawd Ghig sa haq nawg maq gha ber maq gha lawd hawg,’ lehz kawq koz vid che yaog.” ");
INSERT INTO lhi_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Te pawz ned haeg yawd haq suaq keh muh jad che keh dig ted mag thag huh sir ve kae che yaog. Mig gig khod-aq kha cawg che muhd mig teq pa he lehq muhd mig u ve teq pa ve awg mig awg phond awg gha lia yawd haq maw vid lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Nawg ngag haq nar khehr teh mi lehq a kor pia ver, chuhr huh kha mawg chehd che teq pa awg gha lia ngag nawg haq pehar tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kheh te lehq Yer suq yawd haq kawq koz vid che, “Sar tanr-og, phawe lor. Awg lawn ghod ver, ‘Nawg ved Jawd mawd Ghig sa haq lehax nawg a kor gha pi lehq, yawd ved kanx haq lehax nawg gha te che yaog,’ lehz Liq phu awg khuhn buhq lar che yaog.” ");
INSERT INTO lhi_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kheh te peg lehq, ned haeg yawd haq teh lar haz lehq phaw veh lehq muhd nuh maq cuh yad teq pa lag lehq yawd haq ga vid lehq ngawx haq sax vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yod hanr haq su pheh yug lehq thawnr khuhn ke vehr che awg lawn Yer suq gha kad che te yand, yawd Gar liq lehd muhd mig lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Yawd Nar sar rehq med khuhn tuhez lehq, Sar bur lonr he lehq Nar tar liq muhd mig awg kanr huh, ghig po nux pad huh cawg che Kar per nar unr med khuhn gaeg lehq u huh chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Che kheh te che awr lehr, cuh kar var Id sar yaq koz lar che tawd khuhd u ve heh phehaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sar bur lonr muhd mig he lehq Nar tar liq muhd mig awr lehr, Gar liq lehd ghig po nux awg pad huh, Yawd danr lawg ox pax awr, Yud daq chaw ma hez che teq pa chehd kig Gar liq lehd muhd mig yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Awg naz tud te che khuhn chehd che chaw teq pa awr lehr ir jad pawd jad che awg ghiz haq gha mawg lehq suh che muhd mig he lehq suh che awg ha khuhn chehd che chaw teq pa awg pun liz awg ghiz paw vid vehor,” lehz koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Awg yand u ve haq tanr lehq, Yer suq bon tanr mar lehq koz che, “Vend bax haq duhd phuhz lehq ni ma pa lor. Awg lawn ghod ver, Ghig sa ve muhd mig lag gag vehr tez-or,” lehd koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gar liq lehd ghig po nux pad huh Yer suq yaq kaw tod kae tod-ag huh, Per troq lehd koz che Sid monr he lehq yawd ved awg nax var Anr drehr ix mag, ghig po khuhn geq phehd chehd che haq Yer suq gha mawg che yaog. Awg lawn ghod ver, I hehd awr lehr, ngad ca var phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Kheh te lehq Yer suq koz che, “Ngag khaz nuhr ghaq laoq. Ngag nig mag haq chaw ca var te cuha laq,” lehz ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ix mag te pawaz lehax geq haq teh lar haz lehq yawd khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kheh te peg lehq Yer suq awg nuz awr teq tawn nehax kawq kae che te yand Yer ber dehd ve awg yad par Yar koq he lehq Yod hanr awr pa Yer ber dehd geh huh lawd kor khuhn geq ghu behz chehd che haq Yer suq gha mawg lehq ix mag haq liz yawd kug yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ix mag liz te pawz maq lehax huh lawd kor he lehq ix mag ved awr pa haq teh lar haz lehq yawd khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yer suq awr lehr Gar liq lehd muhd mig khuhn ted kag peg ted kag kaod kae lehq, i hehd teq pa ve bon lawg kig teq pa awg khuhn Ghig sa ve muhd mig awg lawn he lehq ha lehg che bon khuhd liz ca kaod mar vid tod che yaog. Chaw u ve teq pa khuhn cawg che a nar awg ceng gha lia he lehq kha nag chehd che chaw awg gha lia haq yawd ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kheh te cheaq te lehq Sud riq muhd mig khuhn yawd ved awg lawn hax ceh nux maz buhg veh che yaog. A nar laex ceng te nag chehd che chaw, puhq phez che chaw, khi kud laq kuhr suh vehr che chaw, ned geh che chaw awg gha lia yawd chehd lo sir veha lag lehq, yawd chaw nag u ve teq pa haq saw ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kheh te lehq Gar liq lehd muhd mig, Der kar pawd liq muhd mig, Yer ruq sar lehnr med, Yud daq muhd mig he lehq Yawd danr lawg kax ox pax awr ve chaw mor nux u ve teq pa yawd khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yawd khaz nuhr ghaq tod che chaw awg mor nux haq Yer suq gha mawg lehq, yawd keh thag lo taez che yaog. Yawd mi chehd huh yawd ved awg laq ghuhd teq pa yawd chehd lo lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Kheh te lehq, yawd awg laq ghuhd teq pa haq tanr mar vid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ni ma khuhn co ha phawd awr har ghuhd che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, muhd nuh maq muhd mig awr lehr, i hehd ve muhd mig phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Duhd har gad har che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, i hehd ni ma sa tug Ghig sa te vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ni ma nud-u ghad nehr ghad te che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, mig gig awr lehr, i hehd gha tug awg sinx phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Thed che cawd che haq meq khod kaz khod chehd che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, i hehd gha cad buhz dawg buhz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Har kax vix che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, Ghig sa i hehd teq pa haq kawq har kax vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ni ma khuhn phu che kehg che cawg che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, i hehd Ghig sa haq gha mawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Cawd daq hawr daq tug te che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, i hehd haq Ghig sa yawd ved yad yaog lehd koz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ghig sa ve a lor haq ca lehq thed-e ghad cawd-aw ghad te cheaq te lehq su du deh che haq gha khanr che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, muhd nuh maq muhd mig awr lehr, i hehd ve muhd mig phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ngag haq te lehq, su nig hehd haq kha muhd kha na te lehq, du deh ax lehq, her ka lehq nig hehd awg lawn haeg che awg ceng teq pa haq koz ver, nig hehd awr lehr awg bon ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ha lehg tug awg ceng kha peh vad-ag cawg vid-oq. Awg lawn ghod ver, muhd nuh maq lo nig hehd ve laq sawnr ir jad che Ghig sa teh ax lar peg che yaog. Nig hehd haq keh awg kawd lag peg che Ghig sa ve cuh kar var teq pa haq liz su u kheh te du deh vid jaw che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nig hehd awr lehr, mig ghig ve a lehq phehq che yaog. A lehq u ve mehg che pehz vehr ver, khawd-ehg kheh te kawq mehg gha hawg le. A lehq u ve teq chaweh awg bon mad cawg vehr cheaq te lehq su yug chid bag lehq chaw yad naz tod chea lehax yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nig hehd teq pa awr lehr, mig gig ve awg ghiz phehq che yaog. Keh thag lo cawg che med haq khuhd ceh lar maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","U ve haq sur daq che a mir khehd tox lar lehq khuhr luhd cuhr muhq lar che liz chaw te ghad-eg maq te jaw. Kheh ma khuhd yehg yad ka yad awg gha lia awg ghiz haq gha mawg vid tug muh kig lo teh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","U ve heh te lehq su mehz khuhd suhr lo nig hehd liz awg ghiz pawd vid-oq. U kheh te ver, nig hehd daq che kanx te lar che haq su gha mawg che te yand muhd nuh maq lo chehd che nig hehd ve Awr pa haq su chid ir chid muh vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Awg lid tawd khuhd he lehq Ghig sa ve cuh kar var teq pa ve tawd khuhd haq te lug tug ngag lag che law lehz ta duhd. Te lug tug ngag lag che ma hez hawg. U ve haq peh lawq vid tug ngag lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngag ni hehd haq awg cehg mag koz ax laq, mig gig he lehq muhd nuh maq che ve mad lug ser che kheh ceh, awg ceng gha lia peh lawq thad kha gag awg lid tawd khuhd awg khuhn liq mehz nehax lehd ma koz, joz lar che awg mehz nehax lehd ma koz, lug vid mehx vid maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kheh te lehq, a sug te ghad lehd ma koz, awg lid tawd khuhd che teq pa awg khuhn i jad che ted mag mar haq yawd awg ton liz maq te lehq, su haq liz maq te tug mar vid che chaw awr lehr, muhd nuh maq muhd mig lo su haq keh i jad che chaw phehq tug yaog. Kheh ma khuhd, chaw khar ve te ghad lehd ma koz, yawd awg ton liz te lehq, su haq liz te tug mar vid che chaw awr lehr, muhd nuh maq muhd mig lo ir jad che chaw gha phehq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Awg lawn ghod ver, Liq buhq var teq pa he lehq Phar rir sehd teq pa haq keh nig hehd thed che cawd che mad cawg mad ver, nig hehd muhd nuh maq muhd mig khuhn maq gha gehe hawg lehz, ngag nig hehd haq koz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","‘Chaw haq nawg maq gha dawz vehr,’ kheh te lehq ‘Su haq dawz vehr che chaw teq pa awr lehr, suhx jehg suhx taz che haq gha khanr che yaog,’ lehz a mig thad lo ve chaw teq pa haq koz vid che tawd khuhd haq nig hehd gha kad jaw peor. ");
INSERT INTO lhi_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kheh te lehq, ngag nig hehd haq koz ax laq, a vix a nax haq nez nag che chaw awr lehr, suhx jehg suhx taz che haq gha khanr tug yaog. A sug yawd ved a vix a nax haq maq sawnr ma caz te che chaw awr lehr, suhx jehg suhx taz var mehz khuhd suhr lo kae lehq suhx gha jehg gha taz che yaog. A vix a nax haq chaw kar lehd koz che chaw awr lehr, muhd naz hoq a mir khuhn gha geh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kheh te lehq, nawg ved tand tug haq tand kig lo yug ve lag tod-ag huh, nawg vix nawg nax nawg haq vend bax ted ceng cear tar kig cawg che haq nawg duhd nuhd ver, ");
INSERT INTO lhi_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tand kig awg pad huh tand tug haq teh lar haz lehq a vix a nax haq nawg kawq cawd daq lar haz peg nuhr heh, kawq lag lehq tand tug haq kawq yug tand-oq. ");
INSERT INTO lhi_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nawg haq a moz te che chaw geh teq geha suhx jehg suhx taz kig lo kae tod che yaq kaw kanr huh, nig mag kawq cawd daq tug har naq teoq. U kheh maq te ver, yawd suhx jehg suhx taz var laq khuhn nawg haq chid aq vid tug yaog. Suhx jehg suhx taz var liz nawg haq thawnr awg hox laq khuhn chid aq vid lehq, nawg haq thawnr khuhn yug ke vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ngag nawg haq awg cehg mag koz ax laq, phu ted pehq phuhd nehax peg thad kha gag maq saw sehr ver, nawg thawnr khuhn maq gha tuhaz hawg. ");
INSERT INTO lhi_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Nawg hax chaw hax paz maq gha te hawg,’ lehd koz lar che tawd khuhd haq nig hehd gha kad peor. ");
INSERT INTO lhi_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kheh ma khuhd, ngag nig hehd haq koz ax laq, yad mid haq ngawx lehq hax chawd te gad che ni ma cawg che chaw teq pa awr lehr, yawd ved ni ma khuhn lo yad mid u ve haq hax chawd te vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kheh te lehq, nawg ved mehz sir laq yaq awr ve teq pax te yaq vid tug te ver, mehz sir u ve te pax kehx khao. Awg ton teq ton maq ve muhd naz hoq khuhn gha khanr cheaq keh, awg khen nehax ted mag lehax lug vehr che vawr, daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","U ve heh te lehq, nawg ved laq kuhr laq yaq awr pax awr ve liz te yaq vid tug te ver, laq kuhr u ve teq pax haq tawz khaog. Awg ton teq ton maq ve muhd naz hoq khuhn gha khanr cheaq keh, awg khen nehax te mag lehax lug vehr che vawr, daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","A sug yawd ved awg mid ma haq chid bag ver, chid bag che liq te koz yawd haq gha te vid che yaog, lehd koz lar che liz cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kheh ma khuhd, ngag nig hehd haq koz ax laq, hax chawd hax paz te che ted ceng ma hez lehq, awg kag awg nuz awr ve awg lawn haq te lehq a sug yawd ved awg mid ma haq chid bag che ver, yawd awr lehr, yawd ved awg mid ma haq hax chawd hax paz te cuh che yaog. Su chid bag lar che yad mid haq ca he che chaw liz hax chawd hax paz te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Ma hez hez che awg ceng haq nawg maq gha khanr. Nawg khanr lar che heh Jawd mawd Ghig sa mehz khuhd suhr gha te che yaog’ lehz, a mig thad lo ve chaw teq pa haq koz vid lar che tawd khuhd haq liz nig hehd gha kad jaw peor. ");
INSERT INTO lhi_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kheh ma khuhd ngag nig hehd haq koz ax laq, a cehax liz taq khanr. Muhd nuh maq haq liz cud lehq taq khanr. Awg lawn ghod ver, muhd nuh maq awr lehr, Ghig sa ve kaw jaw te lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mig gig haq liz cud lehq taq khanr. Awg lawn ghod ver, mig gig awr lehr, Ghig sa ve khi naz kig te lar che yaog. Yer ruq sar lehnr med haq liz cud lehq taq khanr. Awg lawn ghod ver, med u ve awr lehr, Jawd mawd nux ve med te lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nawg ved a kor haq liz cud lehq taq khanr. Awg lawn ghod ver, nawg ved cuhz kheh muh ted mag nehax phu vid tug he lehq naz vid tug liz nawg te maq gha. ");
INSERT INTO lhi_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Nawg koz cawd che tawd awr lehr, ‘yag ver yaog,’ ‘ma hez ver ma hez hawg,’ lehd lehax koz. U ve nuz awr koz kae chehd ser ver, ned haeg lo lag che phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Su nawg ved mehz sir haq te lug ax ver, yawd ved mehz sir haq liz nawg kawq te lug vid lehq, su nawg ved cig haq te khehq ax ver, yawd ved cig haq liz nawg kawq te khehq vid-oq’ lehd koz lar che awg lid tawd khuhd haq nig hehd gha kad jaw che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kheh ma khuhd, ngag nig hehd haq koz ax laq, nawg haq te yaq che chaw haq tad kawq te khuhq vid. Nawg ved par loz laq yaq awr phawd awr su tha phehd ax ver, laq vehr awr phawd awr liz kawq mawr vid ser. ");
INSERT INTO lhi_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Su nawg haq tanr lehq nawg ved a poq he gad che ver, a poq nux maz liz yawd haq kawq pid ser. ");
INSERT INTO lhi_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Su nawg haq bax nex lehq yaq kaw te kid lod mig lo kae cuha ver, yawd geh ni kid lod mig lo kawq kae ser. ");
INSERT INTO lhi_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Lawg che chaw haq pid-oq. Chid gad ngar gad che chaw haq liz mehz khuhd teq nar awr phuhz pe lehq taq te. Chid vid ngar vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘A sug yawd pad huh chehd che chaw haq haq lehq, a sug yawd ved cand par haq cand-oq’ lehd koz lar che tawd khuhd haq nig hehd gha kad jaw che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kheh ma khuhd, ngag nig hehd haq koz ax laq, nig hehd ve cand par teq pa haq haq lehq, nig hehd haq du deh che chaw teq pa haq bon lawg vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Nig hehd u kheh te ver, nig hehd awr lehr, muhd nuh maq lo chehd che nig hehd ve Awr pa ve yad phehq che yaog. Awg lawn ghod ver, chaw haeg he lehq chaw daq teq pa awg thag huh yawd ved muhd ni ghiz kha sur suar paw vid che yaog. Thed che chaw he lehq ma thed che chaw teq pa thag huh muhd yeg liz kha sur suar lag vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nig hehd haq haq che chaw haq lehax haq ver, a thoq awg bon cawag le. Awg khawnr ghawz var teq pa liz u kheh te chehd che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nawg ved awg chawd teq pa haq lehax awg chawd te lehq tawd yaw daq chehd ver, su te chehd cheaq keh nawg awg lex a thoq te hawg le. Su Ghig sa haq maq sir che chaw teq pa liz u kheh te chehd che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kheh te cheaq te lehq, muhd nuh maq lo chehd che nig hehd ve Awr pa peh lawq che heh, nig hehd teq pa liz peh lawq vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Su gha mawg tug awg pun lehax chaw yad mehz khuhd suhr nawg daq che kanx maq gha te tug sa tiq tar-og. U kheh sa tiq maq tar ver, muhd nuh maq lo chehd che Awr pa geh nawg laq sawnr maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kheh te lehq nawg har kax lehq tand vid ga vid che te yand, chaw her ka var heh taq te. I hehd haq su chid muh vid tug bon lawg kig khuhn lehd ma koz, yaq kaw kar lo lehd ma koz, behd mez cuh vid che yaog. Ngag nig hehd haq awg cehg mag koz ax laq, chaw u ve teq pa awr lehr a sug yawd ved laq sawnr haq gha vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kheh ma khuhd, nawg su haq tand vid ga vid che te yand nawg ved laq kuhr laq yaq awr pax awr a thoq te che haq laq kuhr laq vehr awr pax awr taq sir vid. ");
INSERT INTO lhi_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kheh te cheaq te lehq su haq tand vid ga vid che te yand su mad mawg kig huh ca te. U kheh te ver su mad mawg kig huh mawg vix che nawg ved Awr pa awr lehr nawg haq laq sawnr pehar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nig hehd bon lawg che te yand chaw her ka var teq pa heh taq te. Awg lawn ghod ver, i hehd haq su gha mawg vid tug bon lawg kig khuhn lehd ma koz, yaq kaw ceh huh lehd ma koz, hox lar lehq bon lawg gad vix che yaog. Ngag nig hehd haq awg cehg mag koz ax laq, chaw u ve teq pa awr lehr a sug yawd ved laq sawnr haq gha vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kheh ma khuhd nawg bon lawg thad ver, nawg ved bawehd khuhn geh lehq ghaz mir hoz lar lehq su mad mawg kig huh nawg ved Awr pa geh lawr-oq. Mad mawg kig huh mawg vix che nawg ved Awr pa awr lehr, nawg haq laq sawnr pehar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nig hehd bon lawg thad ver, Ghig sa haq maq sir ser che heh taq te. I hehd teq pa bon lawg cheawg lehr, awg bon mad cawg che tawd haq te thawz te thawz kaod koz lawg che yaog. Awg lawn ghod ver, i hehd u kheh te lawg ver, i hehd lawg lar che heh te gha tug yaog lehd duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Chaw u ve teq pa heh taq te. Awg lawn ghod ver nig hehd lor chehd che teq pa haq nig hehd mad lawg ser liz, nig hehd ve Awr pa sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kheh te lehq, nig hehd bon che kheh koz lawr-oq. Muhd nuh maq lo chehd che ngag hehd ve Awr paog, nawg ved awg meh haq khar thad liz yawz yan che cawg vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nawg ved muhd mig mig gig thang huh cawg vid-oq. Muhd nuh maq lo nawg ved a lor cawd che heh mig gig yad teq pa liz nawg ved a lor cawd che haq ghaq te vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yaq ni lor che cad tug dawg tug teq pa yaq ni ngag hehd haq pehar laoq. ");
INSERT INTO lhi_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Su ngag hehd haq te yaq ax lar che vend bax haq ngag hehd phehd kha vid che heh te lehq ngag hehd ve vend bax haq liz phehd kha ax laoq. ");
INSERT INTO lhi_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kheh te lehq, vend bax ber che awg khad teq pa khuhn, ngag hehd haq taq kae cuha. Kheh te lehq haeg che awg khad khuhn ngag hehd haq pong ax laoq. ");
INSERT INTO lhi_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Awg lawn ghod ver nig hehd su ved te yaq kig haq phehd kha vid ver, muhd nuh maq lo chehd che nig hehd ve Awr pa liz nig hehd ve yaq kig haq phehd kha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kheh ma khuhd, nig hehd su ved yaq kig haq ma phehd kha vid ver, nig hehd ve Awr pa liz u ve heh te lehq nig hehd ve yaq kig haq liz ma phehd kha ax hawg. ");
INSERT INTO lhi_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nig hehd cad tug ce che te yand, chaw her ka var teq pa heh te lehq mehz khuhd awg nuhr tiq he lehq duhd har cehar lehz taq ca te mar vid. Chaw u ve teq pa vawr i hehd cad tug ce chehd che haq su gha mawg gha sir vid tug, i hehd ve mehz khuhd u kheh te tar che yaog. Ngag nig hehd haq awg cehg mag koz ax laq, i hehd awr lehr a sug yawd ved awg bon haq gha vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kheh ma khuhd, nawg cad tug ce chehd thad ver, mehz khuhd kha nehax chuhd lehq a kor haq nag mad kha nehax gehz lehq kehr ghad te chehd lar. ");
INSERT INTO lhi_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","U kheh te ver, nig hehd cad tug ce chehd che haq su maq sir mad mawg. Kheh ma khuhd, su mad mawg kig lo chehd che nawg ved Awr pa mawg tug yaog. Kheh te lehq su mad mawg kig lo mawg vix che nawg ved Awr pa awr lehr nawg haq awg bon pehar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mig gig che ve thang huh nig hehd ve med nged jeg kor taq saw phoz lar. Mig gig thang huh saw phoz lar ver, yud taz vix lehq awg puhd liz cad vix lehq chaw khuhd liz khuhd yug gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kheh ma khuhd, muhd nuh maq lo nig hehd ve med nged jeg kor saw phoz lar lor. U huh yud liz ma taz vix puhd liz ma cad vix lehq chaw khuhd liz khuhd yug maq gha. ");
INSERT INTO lhi_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Awg lawn ghod ver, nawg ved med nged jeg kor khar lo cawg liz, nawg ved ni ma u huh cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mehz sir awr lehr, awg ton ve a mir khehd phehq che yaog. Kheh te cheaq te lehq nawg ved mehz sir daq ver, nawg ved awg ton liz awg ghiz kha nehax cawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kheh ma khuhd, nawg ved mehz sir mad daq ver, te ton maq ve awg naz tud awg naz hoq saw phehq vehr tug yaog. Nawg ved awg ton khuhn ve awg ghiz awg naz tud phehq vehr ver, naz tud che u ve awr lehr kuhz tug ir jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Chaw te ghad-eg liz jawd mawd ni ghad ve awg ceg te maq gha. Awg lawn ghod ver, te ghad haq cand ver, te ghad haq haq tug yaog. Te ghad haq yawz yan ver, te ghad haq maq sawnr ma caz te tug yaog. Nig hehd awr lehr Ghig sa ve awg ceg he lehq phu si med nged jeg kor ve awg ceg te pawaz lehax teq geha te maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Kheh te cheaq te lehq, ngag nig hehd haq koz ax laq, khawd-ehg kheh te a saq teq lehq gha cad gha dawg tug haq ta duhd har. Khawd-ehg kheh te lehq, nig hehd ve awg ton gha veq gha deh tug haq liz ta duhd har. A saq teq che ted ceng awr lehr cad tug haq keh awg phuhd khaz lehq awg ton liz beg ke veq kad haq keh awg phuhd khaz che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Muhd-aq lo pog tod che ngaz nehax teq pa haq ngawx-oq. I hehd awr lehr a cag maq ti, a cag liz mad ghiq lehq cag yehg khuhn cag sir liz ma puhd ke. Kheh ma khuhd muhd nuh maq lo chehd che nig hehd ve Awr pa awr lehr i hehd haq car vid taw vid chehd che yaog. Nig hehd teq pa awr lehr ngaz nehax u ve te pa haq keh awg phuhd khaz che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Duhd har cheaq te lehq a sug yawd ved a saq haq teq sawax liz kawq yehg vid gha tug nig hehd awg khuhn a sug te ghad te gha hawg le. ");
INSERT INTO lhi_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Kheh te ver, beg ke veq kad awg pun liz nig hehd a thoq te duhd har cheawg le. Heh pir lo cawg che suhz vez u ve khawd-ehg kheh te iar che haq duhd ngawx-oq. Awg cehg u ve kanx liz maq te, ghoq kheh liz mad gag. ");
INSERT INTO lhi_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kheh te lar, ngag nig hehd haq koz ax laq, paw sa jad lehq awg mig awg phond ir jad che Jawd mawd Sawd laq monr liz suhz vez nehax u ve teq pa te vez nehax kheh tawa liz mad daq ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kha sehax maq yonr che chaw teq paog, yaq ni teq chehd lehq sawx vawr ver, a mir khuhn bag ke vehr tug muhq cehg haq Ghig sa kheh taw taw maq deh vid veq vid chehd ver, u ve haq keh lex lehq nig hehd haq veq deh ax tug ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kheh te cheaq te lehq, khawd-ehg kheh te ver gha cad gha dawg tug, khawd-ehg kheh te ver gha veq gha deh tug, haq ta duhd har. ");
INSERT INTO lhi_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Awg lawn ghod ver, Ghig sa haq maq sir che chaw teq pa liz, awg ceng che ve teq pa haq ghaq ca chehd che yaog. Awg ceng che ve teq pa nig hehd lor chehd che haq muhd nuh maq lo chehd che nig hehd ve Awr pa Ghig sa sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kheh ma khuhd, a yed ir jad che ted ceng awr lehr, Ghig sa ve muhd mig he lehq yawd ved thed che cawd che haq caoq. Nig hehd lor chehd che awg ceng teq pa awg gha lia yawd nig hehd haq kawq thehnr ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kheh te cheaq te lehq, sawx vawr awg pun ta duhd har. Awg lawn ghod ver, sawx vawr awg pun sawx vawr duhd har tug cawg chehd che yaog. Teq ni awg pun teq ni duhd har tug law chehd che awg ceng cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Su haq nig hehd vend bax taq tar. U kheh te ver, Ghig sa liz nig hehd haq vend bax maq tar hawg. ");
INSERT INTO lhi_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Awg lawn ghod ver, nig hehd su haq vend bax tar che heh te lehq Ghig sa liz nig hehd haq vend bax kawq tar tug yaog. Nig hehd su haq khawd-ehg kheh te vid lar liz, Ghig sa nig hehd haq u kheh kawq te khuhq ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nig hehd a sug yawd ved mehz sir khuhn ve suhz tehd nux tor laq kheh hi te che haq maq ngawx mawg he lar lehq, a thoq awr te lehq nawg vix nawg nax teq pa ve mehz sir khuhn lo cawg che mehz pux nehax haq ca ngawx mawg cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nig hehd a sug yawd ved mehz sir khuhn suhz tehd nux tor laq kheh hi cawg chehd liz a thoq awr te lehq nawg vix nawg nax haq nawg ved mehz sir khuhn lo cawg chehd che mehz pux nehax haq ngag bez kha ax laq lehd ca koz tod cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Chaw her ka var teq paog, nig hehd ve mehz sir khuhn suhz tehd nux tor laq kheh hi te che haq awg kawd yug kha ser. U kheh te peg ver, nawg vix nawg nax ve mehz sir khuhn cawg chehd che mehz pux nehax haq khawd-ehg kheh te yug tuhz gha tug nawg kha sehax mawg cehnr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Daq kehg jad che awg ceng yug lehq phid haq ta pid. Pix koer sehnx haq yug lehq vaq mehz khuhd suhr taq ca bag teh vid. U kheh te ver, u ve teq pa haq vaq u ve teq pa naz kix lar lehq phid u ve teq pa nig hehd haq kawq phuhz cheq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Lawg lor. Lawg ver, gha tug yaog. Ca lor. Ca ver, mawg tug yaog. Ghaz mir haq thuhz lor. Thuhz ver, phawa tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Awg lawn ghod ver, lawg che chaw awg gha lia gha tug yaog. Ca che chaw liz mawg tug yaog. Yehg ghaz mir haq thuhz che chaw haq liz i hehd haq yehg ghaz mir phaw vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nig hehd teq pa awg khuhn a sug te ghad cawg hawg le. Yad khaor mod lawg ver, huhx meh dig yug pid che. ");
INSERT INTO lhi_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ngad lawg ver, vig yug pid tuawg la. ");
INSERT INTO lhi_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nig hehd awr lehr, haeg che chaw phehq liz a sug yawd ved yad haq med nged daq maq pid khuhd nuhd chehd ver, cheaq keh lex lehq muhd nuh maq lo chehd che nig hehd ve Awr pa geh kha lawg che chaw teq pa haq daq che awg ceng yawd pid tug ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kheh te cheaq te lehq, su nawg haq tea vid gad che heh te lehq nig hehd liz su haq u kheh te vid-oq. Awg lawn ghod ver, tawd che ve te khuhd awr lehr, awg lid tawd khuhd liq awg khuhn he lehq Ghig sa ve cuh kar var teq pa koz lar che tawd khuhd yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mad kuhg che ghaz mir khuh haq gehe. Awg lawn ghod ver lug vid kig lo kae che yaq kaw awr lehr kae sa jad lehq ghaz mir khuh liz kuhg jad che yaog. Kheh te lehq chaw u huh gehe che liz cawg mad jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kheh ma khuhd, a saq teq vid kig lo kae che ghaz mir khuh awr lehr, mad kuhg lehq yaq kaw liz har jad che yaog. Ca mawg lehq gehe che chaw liz a cehax lehax cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Awg cehg mag ma hez che Ghig sa ve cuh ka var teq pa haq sa tiq tar-oq. Awg khuhn phawd awr ver haeg jad che heh phid heh te chehd liz, yawg ve awg gig kox haq veq deh lehq nig hehd chehd lo lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","I hehd te che kanx haq ngawx ver, i hehd khawd-ehg kheh te che chaw haq nig hehd gha sir che yaog. A chud bid haq a pehx med sir gha sax jawa la. A chud cehg hag a kud sir gha sax jawa la. ");
INSERT INTO lhi_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","U ve haq sur daq che yaog. Daq che awg cehg haq ver, daq che awg sir nuhq che yaog. Mad daq che awg cehg haq ver, mad daq che awg sir nuhq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Daq che awg cehg awr lehr, mad daq che awg sir nuhq tug awg khad mad cawg hawg. Kheh te lehq mad daq che awg cehg haq liz, daq che awg sir nuhq tug awg khad mad cawg hawg. ");
INSERT INTO lhi_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Daq che awg sir mad nuhq che awg cehg teq pa awr lehr, thawq kuhd lehq a mir khuhn tox ke tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kheh te cheaq te lehq, chaw u ve teq pa te che kanx haq ngawx ver, i hehd ve ni ma he lehq i hehd khawd kheh te tod che haq sir gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ngag haq, ‘Jawd mawd-og, Jawd mawd-og,’ lehd kha koz che chaw awg gha lia muhd nuh maq muhd mig khuhn gha gehe che ma hez. Muhd nuh maq lo chehd che ngag ved Awr pa ve a lor haq te che chaw teq pa lehax gha gehe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ghig sa suhx jehg suhx taz che awg ni u ve haq gaeg ver, ‘Jawd mawd-og, Jawd mawd-og, ngag hehd nawg ved awg meh awg khuhn bon mar che ma hez hawg la. Nawg awg meh awg khuhn ned haeg teq pa haq ghaq kog lehq and tug kha peh te peg che ma hez hawg la,’ lehz chaw kha peh vad-ag ngag haq koz ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kheh liz, ngag i hehd haq che kheh koz vid tug yaog. ‘Ngag nig hehd haq maq sir daq. Haeg che chaw teq paog, yor log,’ lehd koz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kheh te cheaq te lehq, ngag mar vid che tawd khuhd haq gha kad lehq na yug lehq te che chaw teq pa awr lehr, huhx meh thag huh yehg te che cud yiq cawg che chaw teq pa haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Muhd yeg lag lehq a kaz ir taz lehq muhd huh nux lag lehq yehg u ve haq thinr liz yehg u ve huhx meh thag huh te lar cheaq te lehq ma kuhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ngag mar vid che tawd khuhd haq gha kad lehq maq na yug lehq maq te che chaw te pa awr lehr, sehnd de khuhn yehg te che cud yiq mad cawg che chaw teq pa haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Muhd yeg lag lehq a kaz ir taz lehq muhd huh nux mez lag che te yand, yehg u ve haq thinr ver, yehg u ve saw kuhd bag vehr che yaog,” lehz Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yer suq tawd u ve teq pa haq yaw mar peg che te yand, yawd mar che tawd khuhd u ve haq chaw kheh ma ve and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Awg lawn ghod ver, yawd mar che tawd khuhd u ve teq pa liq buhq var teq pa mar che haq maq sur. Kheh ma khuhd, yawd vawr Ghig sa lo lag che kand pax cawg che phad heh te mar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yer suq kehaq lo yaq thad, chaw kha peh vad-ag yawd khaz nuhr ghaq tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Awg yand u ve khuhn, khir tuq var te ghad lag lehq, nar khehr teh mi lar lehq a kor pi lehq koz che, “Jawd mawd-og, nawg te gad ver, ngag haq daq kehg vid tug nawg te gha che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yer suq laq kuhr che lehq yawd haq vad lar lehq koz che, “Ngag te gad che yaog. Daq vid kehg vid-oq,” lehd koz vid che yaog. Teq pear lehax yawd khir tuq a nar mehx vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yer suq yawd haq koz vid che, “Awg lawn che ve chaw te ghad-eg haq liz ta koz vid. Kheh ma khuhd, nawg kae lehq paw khod haq awg ton ca maw vid-eq. Su mehz khuhd suhr huh sax khiz te tug, Mod ser awg lid teh lar che heh te lehq tand tug liz ca tand vid-eq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yer suq Kar per nar unr med khuhn gehe che te yand, maq yad awg hox te ghad yawd chehd lo lag lehq yawd haq lawg khawx lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Jawd mawd-og, ngag ved awg ceg khi kud laq kuhr suh vehr lehq yehg khuhn yuhq chehd che yaog. Yawd awr lehr gha tuq gha khanr jad che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yer suq yawd haq koz vid che, “Ngag lag lehq yawd haq ghu na vid tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kheh te lehq, maq yad awg hox u ve yawd haq kawq koz vid che, “Jawd mawd-og, ngag ved yehg khuhn nawg haq gehag vid tug ngag te maq kenr. Kheh te lar, nawg tawd teq pear lehax yaw liz ngag ved awg ceg na vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Awg lawn ghod ver, ngag awr lehr maq yad te lehq su ved kand pax awg huhx lo chehd lehq ngag huhx lo liz maq yad teq pa cawg che yaog. Ngag huhx ve maq yad te ghad haq, ‘Kae-oq,’ lehd koz vid ver, yawd veh che yaog. ‘Lar-oq,’ lehd koz vid ver, yawd lag che yaog. Ngag ved awg ceg var haq liz, ‘Che ve teoq,’ lehd koz vid ver, yawd te veh che yaog,” lehz kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tawd u ve haq Yer suq gha kad che te yand, yawd and jad lehq, yawd khaz nuhr ghaq tod che chaw teq pa haq koz vid che, “Ngag nig hehd teq pa hag awg cehg mag koz ax laq, Id sar rer laq chaw teq pa awg khuhn liz che kheh taw maq yonr che haq ngag mad mawg jaw ser. ");
INSERT INTO lhi_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ngag nig hehd haq koz ax laq, muhd ni tuhz phawd awr he lehq muhd ni kehg phawd awr lo chehd che chaw kha peh vad-ag lag lehq muhd nuh maq muhd mig awg khuhn Ar brar hanr, Id caq, Yar koq teq pa geh teq geha gha mi cad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kheh ma khuhd, Ghig sa ve muhd mig khuhn gha chehd cawd che teq pa vawr, awg bag phawd awr lo awg naz tud teag huh yug chid bag pe che haq gha khanr tug yaog. U huh kha chehd che chaw teg pa huhg lehq cig geq yuhz cheq tug yaog,” lehz Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yer suq maq yad awg hox haq koz vid che, “Nawg koeq lor. Nawg yonr che heh phehaq tug yaog,” lehd koz vid che yaog. Kheh te lehq, awg yand u ve khuhn teq pear lehax awg ceg u ve liz na vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yer suq awr lehr, Per troq ve yehg khuhn gehe che te yand Per troq ve awr pi ma kaz nag lehq yuhq chehd che haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yawd ved laq kuhr haq Yer suq vad lehq kaz nag chehd che na vehr che yaog. Kheh te lehq yawd tu lehq Yer suq haq te car te taw vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Muhd phiq muhd sux naz huh, ned geh che chaw teq pa kha peh vad-ag Yer suq chehd lo sir veha lag lehq yawd tawd yaw vid lehq ned teq pa haq ghaq kog vid che yaog. Chaw nag awg gha lia haq liz yawd ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yawd che kheh te che awr lehr, awg cehg mag cuh kar var Id sar yaq koz lar che heh, “Yawd awg ton a nig ved nag guhg kig haq haq yug ve lar lehq, a nig ved a nar teq pa haq puhd cid lar che yaog,” lehd koz lar che heh phehaq vid tug te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yawd haq kha caw yuhd te chehd che chaw awg mor nux haq Yer suq gha mawg lehq, “Ghig po nux ox pax awr khanr kae veg,” lehz yawd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Awg yand u ve khuhn, liq buhq var te ghad yawd chehd lo lag lehq koz che, “Sar lar-og, nawg khar lo kae lehd ma koz ngag liz nawg khaz nuhr ghaq kae tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yer suq yawd haq koz vid che, “Heh phid vawr awg kor cawg lehq, muhd-aq lo pog tod che ngaz teq pa liz, yuhq kig awg phi cawg che yaog. Kheh ma khuhd chaw yad ve Yad phu awr lehr, a kor cuhx kig mad cawg hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Awg laq ghuhd awg mor khuhn chehd che yawd ved awg laq ghuhd te ghad lawg lehq koz che, “Jawd mawd-og, ngar pa suh vehr che haq awg kawd ca tur vid lar haez sar,” lehd koz a khawag lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yer suq yawd haq kawq koz vid che, “Ngag khaz nuhr ghaq laoq. Chaw suh teq pa i hehd khad nawag tur daq vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yawd huh lawd kor khuhn gehe lehq yawd ved awg laq ghuhd teq pa liz yawd khaz nuhr ghaq gehe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Awg yand u ve haq, ghig po u ve khuhn muhd huh nux mez lag jad cheaq te lehq, ghig bad dawz taz lehq huh lawd kor khuhn a kaz gehe lehq peh vehr liz, Yer suq awr lehr, yuhq mir ka chehd ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Awg laq ghuhd teq pa yawd haq ca nuhr vid lehq koz che, “Jawd mawd-og, ngag hehd haq a cehax ga laoq. Ngag hehd a kaz thunr che suh vehr tez-or,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yer suq i hehd haq koz vid che, “Kha nehax maq yonr che chaw teq paog, nig hehd a thoq te kuhz cheawg le,” lehd koz che yaog. Kheh te lehq yawd tuag lehq muhd huh he lehq ghig bad haq ded vid che te yand taq hiax gawr ghad chehd vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","I hehd teq pa and jad lehq koz che, “Chaw che ve a sug lehq nar. Muhd huh he lehq ghig bad liz yawd khuhd na che law,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Khanr kae lehq ghig po nux ox pax awr Gar dar raq muhd mig khuhn gaeg che te yand, chaw tur phuh lo tuhaz che ned geh che haw khaz var ni ghad yawd chehd lo lag che yaog. Chaw u ve ni ghad haeg jad cag jad cheaq te lehq, yaq kaw u ve haq chaw te ghad-eg liz te tod maq pir. ");
INSERT INTO lhi_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chaw u ve ni ghad hax ceh kug ded lehq koz che, “Ghig sa ve Yad phu-og, nawg a thoq te lehq ngag nid-ag haq ca soq saq tod cheawg le. Awg yand mad gag ser liz ngag nid-ag haq du deh tug nawg lag cheawg la,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","I hehd haq kheh maq ma vid daq kig huh vaq teq mor nux phoz kaz cad chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kheh te lehq, ned u ve teq pa Yer suq haq lawg khawx lehq koz che, “Nawg ngag hehd haq ca ghaq kog tod che ver, ngag hehd haq vaq u ve teq pa khuhn geh chehd cuha laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kheh te lehq Yer suq ned teq pa haq koz vid che, “Tuhez lor,” lehd koz vid che yaog. Ned u ve teq pa chaw u ve ni ghad khuhn tuhaz lehq vaq mor nux khuhn gehe che te yand, vaq mor nux u ve hax khod med lo saw cex yaeq lehq ghig po khuhn pawz geh lehq a kaz saw ka suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kheh te lehq vaq hu par teq pa med khuhn cex phaw gehe che yaog. Med khuhn chehd che chaw teq pa haq ned geh che chaw ni ghad awg lawn he lehq kha phehaq che awg lawn teq pa saw khae mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Med yad awg gha lia tuhaz lehq Yer suq haq gha mawg daq tug lag che yaog. Yawd haq gha mawg che te yand, i hehd ve muhd mig khuhn tuhez vid tug yawd haq lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yer suq huh lawd kor kawq cind kawaq lehq, yawd ved med lo gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Awg yand u ve haq, yuhq kig khuhn yuhq chehd che khi kud laq kuhr suh vehr che chaw te ghad haq su yawd chehd lo ga taz veha lag che yaog. I hehd yonr che haq Yer suq gha mawg lehq, khi kud laq kuhr suh vehr che phad haq koz vid che, “Yad par-og, ha lehg lar-oq. Awg lawn ghod ver, nawg ved vend bax haq pong ax vehr che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Liq buhq var ted pehg pehar awr lehr, “Chaw che ve phad Ghig sa haq maq sawnr ma caz koz che yaog,” lehz ni ma khuhn duhd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","I hehd khawd-ehg kheh duhd chehd che haq Yer suq gha sir lehq koz vid che, “A thoq te nig hehd ve ni ma khuhn mad daq che awg khad haq duhd chehd cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Khawd-ehg kheh koz vid che vawr a cehax sa hawg le. ‘Nawq ved vend bax haq pong ax vehor,’ lehd koz vid che sa hawg la. Ma hez ver, ‘Tu lehq yaq kaw tod kae lor,’ lehd koz vid che sa hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kheh te lehq, chaw yad ve Yad phu awr lehr mig gig khod-aq lo vend bax phehd kha vid tug kand pax cawg che haq nig hehd gha sir vid tug, ngag che kheh te tug yaog,” lehd koz che yaog. Khi kud laq kuhr suh vehr che phad haq kawq koz vid che, “Tu lehq nawq ved yuhq phi haq saw taz ve lehq yehg lo koeq lor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kheh te lehq, chaw u ve phad liz tuag lehq yawd ved yehg lo kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","U ve haq gha mawg che te yand chaw awg gha lia and jad lehq, chaw yad teq pa haq che kheh te gha tug kand pax pid che phad Ghig sa haq chid ir chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yer suq u huh tuhaz che te yand, awg khawnr ghawz kig yehg khuhn mi chehd che Mar thehr meh che chaw te ghad haq yawd gha mawg che yaog. “Ngag khaz nuhr ghaq laor,” lehz yawd haq koz vid che te yand, yawd tuag lehq Yer suq khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kheh te lehq, yehg awg khuhn lo Yer suq teh cuh pad huh mi cad chehd che te yand, awg khawnr ghawz var he lehq vend bax yad teq pa kha peh lag lehq Yer suq he lehq yawd ved awg laq ghuhd teq pa geh teq geha mi cad chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Phar rir sehd teq pa u ve haq gha mawg lehq Yer suq ve awg laq ghuhd teq pa haq koz vid che, “Nig hehd ve sar lar a thoq te lehq awg khawnr ghawz var he lehq vend bax yad teq pa geh teq geha cad cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tawd khuhd u ve haq Yer suq gha kad che te yand yawd kawq koz vid che, “Chehd sa chehd che chaw awr lehr, naz chuhd sehr phad haq maq lor. Nag che chaw teq pa lehax lor che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","‘Tand tug haq ngag he gad che ma hez hawg. Har kax che ted ceng haq he gad che yaog,’ lehd koz che tawd khuhd haq nig hehd sir tug ca hend ser. Awg lawn ghod ver, thed che cawd che chaw teq pa haq kug yug tug ngag lag che ma hez. Vend bax yad teq pa haq kug yug tug ngag lag che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Awg yand u ve khuhn Yod hanr ve awg laq ghuhd teq pa Yer suq chehd lo lag lehq koz che, “Ngag hehd he lehq Phar rir sehd teq pa cad tug ce chehd liz, a thoq te lehq nawg ved awg laq ghuhd teq pa cad tug maq ce cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yer suq i hehd haq koz vid che, “Awg mid ma he che phad awr lehr, khehx cad-ag che chaw teq pa geh chehd-ag huh i hehd duhd har chehd vid tuawg la. Kheh ma khuhd awg mid ma he che phad haq i hehd geh yug phaz che awg ni cawag tug yaog. Awg yand u veaq gaeg ver, i hehd cad tug ce tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Beg ke awg pir haq pha awg suhx chaw te ghad-eg liz mad yug nehx jaw. U kheh te yug nehx ver, nehx lar che pha awg suhx u ve dehg khuhq vehr ver, beg ke awg pir haq ghawg lehq kawq pheq jad vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Che ve haq sur daq che yaog. Sar gig thux pu awg pir awg khuhn a pehx med ghig awg suhx chaw te ghad-eg liz mad yug ke jaw. U kheh te ke ver, sar gig thux pu awg pir peq khod cheaq te lehq, a pehx med ghig liz sez vehr lehq sar gig thux pu liz sax vehr che yaog. Kheh ma khuhd a pehx med ghig awg suhx haq yug lehq sar gig thux pu awg suhx khuhn ke ver, nid ceng cear mad lug hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yer suq awg lawn che ve teq pa i hehd haq koz vid chehd-ag huh, bon lawg kig awg hox te ghad yawd mehz khuhd suhr lag lehq nar khehr teh mi lar lehq koz che, “A meha heh ngag ved yad mid suh vehr che yaog. Kheh ma khuhd nawg lag lehq yawd haq laq kuhr tar vid ver yawd kawq teq tuag vehr tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kheh te lehq, Yer suq tu lehq yawd ved awg laq ghuhd teq pa geh chaw u ve phad khaz nuhr ghaq kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Awg yand u ve khuhn teq chi nid khuhq kha gag suhr yaq chehd che Yad mid te ghad Yer suq kuhr tehx nuhr phawd awr veaq lag lehq yawd ved a poq awg jog med haq khuhd soz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Awg lawn ghod ver, “Ngag yawd ved a poq awg jog med nehax haq lehax gha soz liz, ngag na vehr tug yaog lehz,” Yawd ved ni ma khuhn duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yer suq kuhr phuhz ngawx lehq yawd haq mawg che te yand, “Yad mid-og, ha lehg chehd-oq. Nawg yonr che ted ceng haq te lehq nawg na vehr che yaog,” lehd koz vid che yaog. Teq pear lehax yad mid u ve liz na vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Bon lawg kig awg hox ve yehg khuhn Yer suq gaeg che te yand, tehd lehd koeg mez che chaw teq pa he lehq chaw kha peh nux maz diz diz huhd huhd he lehq phoz huhg chehd che haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kheh te lehq yawd i hehd haq koz vid che, “Awg gha lia saw tuhez. Yad mid nehax che ve suh vehr che ma hez hawg. Yawd yuhq mir ka chehd cheawg,” lehd koz vid lehq, su yawd haq ga ghig che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Chaw u ve teq pa haq saw ghaq tuhz pe peg lehq, yawd gehe lehq yad mid nehax u ve laq kuhr haq yug lehq yad mid nehax u ve liz tuag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kheh te lehq awg lawn u ve muhd mig u ve khuhn awg kag gha lia lo buhg veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yer suq u huh tu lehq kae che te yand, mehz cox var ni ghad liz yawd khaz nuhr ghaq kae lehq, “Dar viq ve Yad phu-og, ngag nid-ag haq a cehax har kax laoq,” lehd koz kug chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yer suq yehg khuhn gehe che te yand, mehz cox var u ve ni ghad yawd chehd lo kae che yaog. Yer suq ix mag haq na che, “Ngag nig mag ved mehz sir ghu te mawg ax gha hawg lehz yonr chehd-aq la,” lehd koz na ngawx che yaog. “Yonr chehd-aq, Jawd mawd-og,” lehz ix mag kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kheh te lehq ix mag ved mehz sir haq yawd vad lar lehq, “Nig mag yonr che heh te lehq nig mag haq phehaq vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kheh te lehq ix mag mehz kawq mawg vehr che yaog. Yer suq ix mag haq koz vid che, “Awg lawn che ve haq chaw te ghad-eg liz taq sir vid,” lehd koz tawd pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kheh ma khuhd ix mag tuhez lehq Yer suq ve awg lawn muhd mig u ve khuhn awg kag gha lia lo ca kaod koz tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ix mag tuhz veh tod-ag huh ned geh che chaw kar var te ghad haq su Yer suq chehd lo sir veha lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ned haq ghaq kog peg lehq chaw kar u ve tawd yaw gha vehr che yaog. Chaw mor nux kheh ma ve and jad lehq koz che, “Id sar rer laq chaw teq pa awg khuhn liz che kheh taw taw maq ve mad mawg jaw ser,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kheh ma khuhd Phar rir sehd te pa koz che, “Yawd ned jawd mawd ve kand pax haq yehd lehq ned haq ghaq kog che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Awg yand u ve khuhn awg pad awg ki huh cawg che med he lehq khaz teq pa awg khuhn Yer suq yawd kae lehq bon lawg kig awg khuhn Ghig sa ve muhd mig haq caz daq che ha lehg che bon khuhd ca mar vid lehq nag guhg chehd che chaw nag a nar teq pa awg ceng gha lia haq liz, yawd saw ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Chaw kha peh vad-ag haq Yer suq yawd gha mawg che te yand, yawd chaw u ve teq pa haq har kax che yaog. Awg lawn ghod ver, i hehd teq pa awr lehr yawg huhx var mad cawg che yawg heh te lehq, ni ma soq saq jad lehq awg ghad nud jad chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kheh te lehq yawd ved awg laq ghuhd teq pa haq yawd koz vid che, “A cag ghiq tug cawg mad jad chehd liz, a cag ghig var a cehax lehax cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kheh te cheaq te lehq, yawd ved a cag ghiq kig lo a cag ghiq var teq pa har naq lag peha vid tug, Awg sehr phad geh bon lawr-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yer suq yawd ved awg laq ghuhd teq chi ni ghad haq kug yug lehq ned chaq chiz teq pa haq ghaq kog lehq nag guhg chehd che a nar awg ceng gha lia haq ghu na vid tug yawd i hehd teq pa haq kand pax pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Che ve awr lehr, awg laq ghuhd teq chi ni ghad ve awg meh yaog. Awg kawd te ghad, Per troq lehd koz che Sid monr he lehq yawd ved awg nax var Anr drehr, Yer ber dehd ve awg yad par Yar koq he lehq yawd ved awg nax var Yod hanr, ");
INSERT INTO lhi_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Phid liq he lehq Bar thawd lar mehd, Thod maq he lehq awg khawnr ghawz var Mar thehr, Ar lar phehd ve awg yad par Yar koq he lehq Thar dehd, ");
INSERT INTO lhi_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","muhd mig haq haq che awg mor khuhn ve Sid monr he lehq Yer suq haq chid aq vid che phad Yud daq Id sar kar rir oq teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yer suq awg laq ghuhd che ve teq chi ni ghad haq kae pe lehq, i hehd haq koz vid che, “Bid saz a naz chaw teq pa chehd kig lo taq kae. Sar mar riq chaw teq pa ve med khuhn liz taq gehe. ");
INSERT INTO lhi_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kheh ma khuhd mehx vehr che yawg teq pa heh phehq che Id sar rer laq chaw ceng geh lo kae. ");
INSERT INTO lhi_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kae lehq, ‘Muhd nuh maq muhd mid lag gag vehr tez-or,’ lehd koz lehq bon ca mar vid-eq. ");
INSERT INTO lhi_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kheh te lehq, chaw nag teq pa haq liz ca ghu na vid-eq. Suh vehr che chaw teq pa haq liz kawq te teq vid-eq. Khir tuq a nar kex che chaw teq pa haq liz daq kehg vid tug te vid-eq. Ned teq pa haq liz ghaq kog vid-eq. Kand pax che ve haq nig hehd kheha gha che heh te lehq su haq liz kheha ca kawq ga vid-eq. ");
INSERT INTO lhi_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nig hehd kae che te yand, nig hehd ve laq sax khuhn phu, si, pehq sanr teq pa ta doz ve kae. ");
INSERT INTO lhi_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kheh te lehq, yaq kaw kanr huh lor ver yehd tug awg pun, laq sax, beg ke veq kad, khi noz he lehq jud fir tag liz tad yug ve kae. Awg lawn ghod ver kanx te che chaw awr lehr, cad tug dawg tug haq gha cad cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nig hehd teq pa med khar ve ted kag khuhn lehd ma koz, khaz khar ve ted kag khuhn lehd ma koz gehe che te yand, nig hehd teq pa haq ha lehg ha ka haq yug ax gad che chaw ve yehg haq ca na ngawx lehq, med u ve khuhn ma tuhz kae ser che kheh ceh u huh taq hiax chehd lar. ");
INSERT INTO lhi_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Yehg khuhn gehe che te yand Ghig sa ve awg bon i hehd haq naq vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Yehg u ve khuhn nawg haq ha lehg ha ka haq yug ax ver, Ghig sa ve awg bon yehg ka u ve khuhn cawg vehr che yaog. Kheh ma khuhd yehd ka u ve nawg haq mad haq yug ax ver, Ghig sa ve awg bon u ve nawg chehd lo kawaq vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kheh te lehq, nawg haq mad haq yug ax lehq nawg ved tawd khuhd haq maq na yug ver, yehg u ve khuhn lehd ma koz, med u ve khuhn lehd ma koz, tuhez thad ver, khi ho haq hehr chehd che jeq mia u ve haq phi kha lar haz-oq. ");
INSERT INTO lhi_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ngag nig hehd haq awg cehg mag koz ax laq, suhx jehg suhx taz che awg ni gaeg ver, med u ve awr lehr Sawd donr he lehq Kawd mod raq med haq keh liz gha khanr jad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yawg nehax haq heh phid mor nux khuhn lo kae pea che heh te lehq, ngag nig hehd haq kae pea che yaog. Kheh te cheaq te lehq vig heh te lehq cud yiq gha cawg lehq, a pia heh te lehq su haq mad yaq vix che chaw heh teoq. ");
INSERT INTO lhi_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chaw yad teq pa haq sa tiq kha nehax taoq. Awg lawn ghod ver, i hehd awr lehr, suhx jehg suhx taz var teq pa mehz khuhd suhr lo nig hehd haq pheh ve suhx jehg suhx taz lehq i hehd ve bon lawg kig awg khuhn nig hehd haq jawq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ngag haq te lehq, nig hehd haq muhd mig jawd mawd he lehq jawd mawd nux teq pa mehz khuhd suhr lo su yug ve kae tug yaog. I hehd teq pa ve mehz khuhd suhr he lehq bid saz a naz chaw teq pa mehz khuhd suhr nig hehd ngag awg lawn sax khiz gha khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Su nig hehd haq pheh che te yand nig hehd tawd khawd kheh gha koz yaw tug ta duhd har. Awg yand u ve khuhn gaeg ver, tawd khawd kheh gha koz gha yaw tug nig hehd haq sir ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Awg lawn ghod ver, tawd yaw sehr pha vawr nig hehd ma hez hawg. Nig hehd ve Awr pa ve Awg ha phu awr lehr, nig hehd haq cud lehq tawd yaw tuhz peha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","A vix a nax te ghad he lehq te ghad suh tug chid aq daq tug yaog. Awr pa liz a sug yawd ved yad haq suh tug chid aq daq tug yaog. Yad teq pa liz, a sug yawd ved awr pa awr ye haq kawq phuhz lehq dawz vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ngag ved awg meh haq te lehq, chaw awg gha lia nawg haq cand tug yaog. Kheh ma khuhd awg leh med kha gag yeg chehd che chaw teq pa awr lehr, thaer khuhq che haq gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Med te med khuhn su nawg haq du deh ax ver, awg kag awg nuz awr ve med lo phaw eq. Ngag nig hehd haq awg cehg mag koz ax laq, Id sar rer laq ve med teq pa haq nig hehd kae che mad peg tand chaw yad ve Yad phu lag gag vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Awg laq ghuhd awr lehr yawd ved sar lar haq keh maq ir hawg. Awg ceg liz yawd ved awg sehr phad haq keh maq ir hawg. ");
INSERT INTO lhi_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Awg laq ghuhd awr lehr yawd ved sar lar haq sur lehq, awg ceg liz yawd ved awg sehr phad haq sur ver, ni khaz suh cawd vehr che yaog. Su yehg sehr phad haq, ‘Ber sar bud laq,’ lehd koz ver, yawd ved yehg yad ka yad teq pa haq cheaq keh liz lex lehq koz tug ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kheh te lehq i hehd haq ta kuhz. Awg lawn ghod ver kha hoz beh lar che awg ceng gha lia liz maq gha saw pheq tuhz lehq kha khuhd ceh lar che awg ceng gha lia liz maq sir gha tug teq chaweh mad cawg. ");
INSERT INTO lhi_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ngag nig hehd haq awg naz tud te kig huh koz ax che awg ceng teq pa awr lehr, awg ghiz pawd kig lo kawq koz vid-oq. Nig hehd haq a yax yax khuhd sad ax che awg ceng teq pa awr lehr, yehg thag lo taez lehq su haq hax ceh nux kug lehq koz vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Awg ton haq dawz vehr gha liz nawg ved co ha haq dawz vehr maq gha che chaw haq ta kuhz. Kheh ma khuhd muhd naz hoq khuhn co ha haq liz awg ton haq liz te lug gha che phad haq kuhz lor. ");
INSERT INTO lhi_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Jar mead nehax nig kheh ted pehq phuhad lehax huhd che liz, nig hehd ve awr pa ve a lor ma cawd ver, teq kheha liz mig giaq lo cheag mad gag hawg. ");
INSERT INTO lhi_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nawg ved a kor haq ve cuhz kheh muh nehax awg kheh gha lia haq liz, yawd saw ghawn ngawx lar peor. ");
INSERT INTO lhi_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kheh te cheaq te lehq ta kuhz. Jar mead awg mor nux u ve teq pa haq keh nig hehd awr lehr awg phuhd khaz jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Chaw khar ve te ghad lehd ma koz, chaw yad mehz khuhd suhr ngag haq khanr yug ver, muhd nuh maq lo chehd che ngag ved Awr pa mehz khuhd suhr ngag liz yawd haq khanr yug tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kheh ma khuhd chaw khar ve te ghad lehd ma koz, chaw yad mehz khuhd suhr ngag haq chid bag ver, muhd nuh maq lo chehd che ngag ved Awr pa meh khuhd suhr ngag liz yawd haq chid bag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mig gig thag huh cawd daq hawr daq tug awg pun ngag lag cheawg lehd ta duhd. Cawd daq hawr daq tug awg pun ngag lag che ma hez hawg. A dax haq ngag yug veha lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Awg lawn ghod ver, yad par he lehq yawd ved awr pa, yad mid he lehq yawd ved awr ye, awg khed ma he lehq yawd ved awr pi ma teq pa, te ghad he lehq te ghad ma cawd daq vid tug ngag lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","A sug yawd ved cand par awr lehr a sug yawd ved yehg yad ka yad teq pa phehq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ngag haq haq cheaq keh, a sug yawd ved awr pa awr ye haq haq che chaw te ghad awr lehr ngag ved awg laq ghuhd te maq kenr. Ngag haq haq cheaq keh a sug yawd ved yad par yad mid haq haq che chaw te ghad awr lehr, ngag ved awg laq ghuhd te maq kenr. ");
INSERT INTO lhi_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","A sug yawd ved laq kan haq taz lehq ngag khaz nuhr mad ghaq che chaw te ghad awr lehr, ngag ved awg laq ghuhd te maq kenr. ");
INSERT INTO lhi_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","A sug yawd ved a saq gha pong tug te che chaw te ghad awr lehr, a saq gha sond tug yaog. Kheh ma khuhd ngag awg pun a sug yawd ved a saq haq sond che chaw te ghad awr lehr, a saq haq kawq gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nig hehd haq haq yug che chaw awr lehr, ngag haq liz haq yug che yaog. Kheh te lehq ngag haq haq yug che chaw awr lehr, ngag haq lag peha che phad haq liz haq yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Chaw te ghad Ghig sa ve cuh kar var phehq cheaq te lehq, su yawd haq haq yug ver, haq yug che phad liz cuh kar var haq kha sur suar Ghig sa geh laq sawnr gha tug yaog. Chaw te ghad thed che cawd che chaw phehq cheaq te lehq, su yawd haq haq yug ver, haq yug che phad liz thed che cawd che chaw te ghad haq kha sur suar Ghig sa geh laq sawnr gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chaw khar ve te ghad lehd ma koz, ngag ved awg laq ghuhd awg khuhn i jad che chaw te ghad haq a kaz gawg maq te kawz taw vid ver, taw vid che phad awr lehr, awg bon ma sond tug yaog lehz, ngag nig hehd haq awg cehg mag koz ax che yaog,” lehd Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yer suq awr lehr, yawd ved awg laq ghuhd teq chi ni ghad haq mar vid peg lehq u huh tuhez lehq Gar liq lehd muhd mig khuhn cawg che med teq pa khuhn bon ca mar vid tug kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yod hanr thawnr khuhn geh chehd-ag huh, Khreq te chehd che kanx teq pa awg lawn gha kad lehq yawd ved awg laq ghuhd teq pa haq ca na ngawx pe lehq, ");
INSERT INTO lhi_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Nawg awr lehr, lag tug chaw u ve te ghad yaog la. Ma hez ver, awg kag awg nuz awr ve chaw te ghad haq ngag hehd gha law ser tuawg la,” lehz yawd haq ca na ngawx pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yer suq i hehd haq kawq koz vid che, “Nig hehd kha gha kad lehq kha gha mawg che awg ceng teq pa Yod hanr haq ca kawq koz vid-eq. ");
INSERT INTO lhi_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mehz cox che chaw mehz mawg gha che, khi lug che chaw teq pa yaq kaw tod gag che, khir tuq kex che chaw teq pa daq kehg vehr che, nar puh ma kad che chaw teq pa nar puh kad vehr che, suh vehr che chaw teq pa kawq teq tuag lehq chaw har chaw ghuhd yad teq pa liz ha lehg che bon khuhd haq gha kad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ngag te che awg ceng haq ma nez nag che chaw teq pa awr lehr, awg bon ir che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yod hanr ve awg laq ghuhd teq pa kawq veh tod-ag huh, Yer suq awr lehr Yod hanr ve awg lawn chaw mor nux haq koz vid che, “Nig hehd heh pir lo awg nar nuh awg god khehz teag lo a thoq ca ngawx-eg cheawg le. Pund cehg haq muhd huh mez lehq aw taz aw yaq te chehd che haq la. ");
INSERT INTO lhi_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ma hez ver, a thoq haq ca ngawx-eq tug kae cheawg le. Nud-u ghad te che beg ke veq che chaw haq la. Nud-u ghad te che beg ke veq che chaw teq pa awr lehr, Jawd mawd ve hawx yehg khuhn chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ma hez ver, a thoq haq ca ngawx-eg tug kae cheawg le. Ghig sa ve cuh kar var haq la. Yaog. Ghig sa ve cuh ka var haq ca ngawx-eg che yaog. Yawd awr lehr Ghig sa ve cuh kar var teq pa haq keh ir che chaw te ghad yaog, lehz ngag nig hehd haq koz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","‘Ngawx lor, nawg haq keh awg kawd nawg ved yaq kaw haq ghu te tug ngag ved cuh yad haq ngag kae pe tug yaog,’ lehd koz buhq lar che awr lehr yawd haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ngag nig hehd haq awg cehg mag koz ax laq, mig gig khod-aq yad mid geh kha pawag che chaw yad teq pa khuhn, a kaz tur vid var Yod hanr haq keh ir che chaw te ghad-eg liz mad cawg ser. Kheh ma khuhd muhd nuh maq muhd mig awg khuhn su haq keh i che chaw te ghad liz, yawd haq keh ir ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","A kaz tur var Yod hanr kanx tanr te che awg ni haq tanr lehq yaq ni kha gag, muhd nuh maq ve muhd mig haq hax ceh nux bawz daq lehq chaw khawr maq te che chaw teq pa hinx yug ve vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Awg lawn ghod ver Ghig sa ve cuh kar var awg gha lia he lehq Mod ser ve awg lid tawd khuhd liq awr lehr, Yod hanr ve awg coaq lo kha gag Ghig sa ve muhd mig lag tug awg lawn koz mar lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nig hehd na yug gad ver, chaw che ve awr lehr, lag lawg ghod che Ed lid yaq u ve phad yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kad tug nar puh cawg che chaw teq pa kha sehax naoq. ");
INSERT INTO lhi_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Chaw a meha teq co ve haq a thoq maq vawr, gha yug tehz mar vid tug lehq nar. Chaw a meha teq co ve awr lehr, chaw yad nehax heh te lehq kax khuhn mi lar lehg kug daq lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nig hehd awg pun ngag hehd nuhr mez liz nig hehd ka ma khez. Ngag hehd paz huhg kehd huhg chehd liz, nig hehd ma duhd har,’ lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Awg lawn ghod ver, Yod hanr lag lehq ma cad mad dawg cheaq te lehq, su ‘Yawd haq Ned geh che yaog,’ lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chaw yad ve Yad phu lag lehq cad che dawg che haq te lehq, ‘Chaw che ve awr lehr, cad lex dawg lex che chaw, a pehx med ghig dawg pong dawg lex che chaw, awg khawnr ghawz var he lehq vend bax yad teq pa haq awg chawd te che chaw yaog,’ lehz su kawq koz che yaog. Kheh ma khuhd cud yiq ma yiq ted ceng awr lehr, yawd te che kanx teq pa awg khuhn cawd ma cawd che haq su gha mawg gha sir che yaog,” lehd Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kheh te lehq, Yer suq yawd and tug ir che kanx awg ceng teq pa te mar vid peg che med teq pa awr lehr, i hehd vend bax haq ma duhd phuhz cheaq te lehq Yer suq i hehd haq ded mar lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Khawd rar senr med-og, nawg liz gha duhd har jad tug yaog. Ber sehd daq med-og, nawg liz gha duhd har jad tug yaog. Awg lawn ghod ver, nig hehd awg khuhn te peg che and tug ir jad che kanx teq pa awr lehr, Tud ruq med he lehq Sid donr med khuhn te che heh ver, i hehd awr lehr a mig thad lo thux pu pha haq veq deh lar lehq khuhq ha toz puhr lehq vend bax duhd phuhz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ngag nig hehd haq koz ax laq, suhx jehg suhx taz che awg ni gaeg ver, Tud ruq med he lehq Sid donr med awr lehr, nig hehd kheh taw maq maq gha khanr hawg. ");
INSERT INTO lhi_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kar per nar unr med-og, nawg haq vawr muhd nuh maq lo kha gag chid taz ax lawg lehd ta duhd. Nawg awr lehr, suh muhd mig lo kha gag chid bag yaq pe tug yaog. Awg lawn ghod ver, nawg awg khuhn te peg che and tug ir che kanx teq pa Sawd donr med khuhn te che heh ver, med u ve awr lehr yaq ni kha gag cawg chehd ser tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ngag nig hehd haq koz ax laq, suhx jehg suhx taz che awg ni gaeg ver, Sawd donr med awr lehr nig hehd kheh taw maq toq maq gha khanr hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Awg yand u ve khuhn, Yer suq koz che, “Muhd nuh maq he lehq mig naz ma haq uq penr sehr phad A pa-og, cud yiq cawg che chaw he lehq sir vix che chaw teq pa haq awg lawn che ve nawg khuhd ceh lar lehq chaw yad nehax heh te lehq teq chaweh maq sir che chaw teq pa haq nawg pheq mar vid cheaq te lehq ngag nawg haq chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A pa-og, che ve awr lehr, nawg a lor cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ngag ved Awr pa awr lehr awg ceng gha lia ngag haq saw chid aq ax lar peor. Awr pa ma hez ver, Yad phu haq su te ghad-eg liz maq sir. Yad phu he lehq Yad phu pheq mar vid gad che chaw haq ma hez ver, Awr pa haq te ghad-eg liz maq sir. ");
INSERT INTO lhi_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kanx te heg lehq med nged puhd huhd che chaw awg gha lia ngag chehd lo laor. Ngag nig hehd haq ghad jehd vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ngag ved taz tug haq taz lehq ngag geh hend yug laoq. Awg lawn ghod ver ngag awr lehr, ni ma nud nud nehg nehg cawg lehq nig hehd ve ni ma liz ghad gha jehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Awg lawn ghod ver ngag ved taz tug taz sa lehq ngag ved awg veg liz lawg che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Awg yand u ve haq Yer suq awr lehr Sa ba to awg ni haq ha khuhn phanr kae cawd che yaog. Yawd ved awg laq ghuhd teq pa awr meq jad lehq cag no chehz lehq cag sir pex cad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Phar rir sehd teq pa gha mawg lehq, “Ngawx-oq, Sa ba to awg ni awg khuhn maq te kenr maq te cawd che awg ceng haq nawg ved awg laq ghuhd teq pa te chehd che law,” lehz i hehd teq pa Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yer suq i hehd teq pa haq kawq koz vid che, “Dar viq he lehq yawd ved awg chawd teq pa awr meq vehr che te yand i hehd khawd-ehg kheh te che awg lawn haq nig hehd maq ghawn jaw lehq la. ");
INSERT INTO lhi_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yawd Ghig sa ve yehg khuhn gehe lehq yawd awg ton liz yawd ved awg chawd teq pa liz cad maq kenr cad ma cawd che paw khod nux teq pa lehax cad kenr cad cawd che tand lar che khaor mod haq phoz cad che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma hez ver, Sa ba to awg ni haq bon yehg nux awg khuhn paw khod teq pa Sa ba to awg ni ve awg lid haq te yaq vehr liz, i hehd vend bax maq tar che awg lawn haq Mod ser ve awg lid tawd khuhd awg khuhn nig hehd maq gha ghawn jaw la. ");
INSERT INTO lhi_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ngag nig hehd haq koz ax laq, bon yehg nux haq keh ir che chaw te ghad chuhr huh chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","‘Tand tug haq ngag he gad che ma hez hawg. Har kax che ted ceng haq ngag he gad che yaog,’ lehd koz lar che tawd khuhd u ve haq nig hehd na gha heh ver, vend bax mad cawg che chaw che ve teq pa haq nig hehd vend bax tar tug ma hez. ");
INSERT INTO lhi_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Awg lawn ghod ver chaw yad ve Yad phu awr lehr Sa ba to awg ni ve Jawd mawd phehq che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yawd u huh tuhz kae lehq i hehd ve bon lawg kig khuhn gehe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","U huh laq kuhr teq pax suh vehr che chaw te ghad cawg che yaog. I hehd Yer suq haq vend bax tar tug, “Sa ba to awg ni awg khuhn su haq ghu na vid cawd hawg la,” lehz i hehd yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yer suq i hehd haq kawq koz vid che, “Nig hehd awg khuhn ve chaw te ghad ghad ve yawg teq kheh cawg lehq, Sa ba to awg ni khuhn yawg u ve teq kheh mig kor khuhn che geh chehd lawz ver, mad yug tuhz vid hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Chaw yad awr lehr, yawg haq keh awg phuhd khaz jad che yaog. Kheh te cheaq te lehq, Sa ba to awg ni khuhn daq che awg ceng te che awg lid haq mad yaq hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kheh te peg lehq Yer suq laq kuhr teq pax suh vehr che phad haq koz vid che, “Nawg ved laq kuhr che peha,” lehd koz vid che yaog. Yawd laq kuhr che peha che te yand, yawd ved laq kuhr na vehr lehq teq pax awr ve heh te lehq kawq daq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Awg yand u ve khuhn Phar rir sehd teq pa tuhez lehq Yer suq haq khawd-ehg kheh te ver dawz vehr gha tug jehg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kheh te lehq awg lawn u ve haq Yer suq juhg vehr lehq, yawd u huh tuhz veh vehr che yaog. Chaw kha peh vad-ag yawd khaz nuhr ghaq kae lehq i hehd teq pa awg gha lia haq yawd ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Yawd ved awg lawn su haq maq gha koz mar vid tug i hehd teq pa haq yawd tawd kha sehax yaw lehq sa tiq pid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Awg lawn che ve awr lehr cuh kar var Id sar yaq koz lar che tawd khuhd u ve awg cehg mag phehaq tug awg pun te che yaog. Yawd koz lar che tawd khuhd awr lehr, ");
INSERT INTO lhi_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ngag lez yug lar che ngag ved awg ceg te ghad haq ngawx-oq. Yawd haq ngag ni khaz suh jad lehq haq jad che yaog. Ngag ved Awg ha phu yawd haq pid lehq thed cawd che khuhn suhx jehg tug awg lawn Yud daq chaw ma hez che awg gha lia haq yawd koz mar vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tawd ghawg daq lehq awg khuhd hehnd che te ceng yawd maq te. Yaq kaw kanr lo chaw te ghad-eg liz yawd ved awg khuhd haq maq gha kad. ");
INSERT INTO lhi_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Awg cehg mag thed che cawd che khuhn suhx maq gha jehg maq gha taz ser che kheh ceh, theh kax chehd che pund cehg haq yawd maq uhx chid bag. A mir khehd awg caz nehax ye yea he lehq toq chehd che haq yawd mad yug suh. ");
INSERT INTO lhi_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yawd awr lehr chaw ceng awg ga lia ve duhd law kig phehq che yaog,” lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Awg yand u ve khuhn ned geh che haq te lehq mehz cox vehr lehq kar che chaw te ghad haq su Yer suq chehd lo sir veha lag che yaog. Yawd chaw kar u ve haq ghu na vid cheaq te lehq chaw kar u ve tawd yaw gha lehq mehz mawg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kheh te lehq chaw mor nux teq pa and jad lehq koz daq che, “Chaw che ve phad Dar viq ve yad ma hez hawg la,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kheh ma khuhd, Phar rir sehd teq pa gha kad che te yand, “Chaw che ve phad awr lehr ned jawd mawd Ber sar bud laq ve kand pax haq cud lehq ned teq pa haq ghaq kog che yaog,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","I hehd duhd chehd che haq Yer suq gha sir lehq i hehd haq koz vid che, “Ma cawd maq hawr daq che muhd mig awg mag gha lia gha lug gha sez tug yaog. Ma cawd maq hawr daq che med he lehq yehg ka teq pa liz ca yeg chehd maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kheh te lehq, Sar tanr awr lehr, Sar tanr chawd chawad ghaq kog daq ver, I hehd khad nawad phaz daq tuq te daq che yaog. Kheh te cheaq te lehq, i hehd ve muhd mig khawd-ehg kheh te yeg chehd ghag hawg le. ");
INSERT INTO lhi_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ngag awr lehr, Ber sar bud laq haq cud lehq ned teq pa haq ghaq kog che law lehd koz ver, nig hehd ve yad teq pa a sug ved kand pax haq cud lehq ghaq kog cheawg le. Kheh te ver, i hehd awr lehr nig hehd haq suhx jehg suhx taz var phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kheh ma khuhd, ngag awr lehr Ghig sa ve Awg ha phu haq cud lehq ned teq pa haq ghaq kog che ver, Ghig sa ve muhd mig nig hehd geh lag gag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Awg ghad hehnd jad che chaw te ghad haq mad yug pheh teh lar ser ver, yawd ved yehg khuhn gehe lehq yawd ved med nged jeg kor haq a sug hinx yug gha tuawg le. Awg ghad hehnd jad che chaw haq pheh teh lar peg heh, yawd yehg khuhn gehe lehq yawd ved med nged teq pa haq hinx yug gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ngag phawd awr ma chehd che chaw awr lehr, ngag ved cand par phehq che yaog. Ngag geh ma ghawz phoz che chaw teq pa awr lehr, ghawz fong che chaw phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kheh te lehq ngag nig hehd teq pa haq koz ax laq, chaw yad te yaq che vend bax teq pa awg ceng gha lia he lehq Ghig sa haq maq sawnr ma caz koz gid che awg ceng gha lia haq vend bax phehd vid gha che yaog. Kheh ma khuhd, Daq kehg che Awg ha phu haq maq sawnr ma caz koz che chaw teq pa haq Ghig sa vend bax ma phehd vid hawg. ");
INSERT INTO lhi_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chaw yad ve Yad phu haq maq sawnr ma caz koz gid che chaw a sug te ghad lehd ma koz, yawd ved vend bax haq phehd vid gha che yaog. Kheh ma khuhd, Daq kehg che Awg ha phu haq maq sawnr ma caz koz gid che chaw a sug te ghad lehd ma koz, a meha ve teq co haq liz he lehq awg khaz nuhr ve te co haq liz yawd ved vend bax haq phehd vid maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Awg cehg daq ver, awg sir liz daq che yaog. Awg cehg mad daq ver, awg sir liz mad daq che yaog. Awg lawn ghod ver awg sir haq te lehq awg cehg haq sir gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Vig haeg ve awg yad teq paog, nig hehd chaw haeg phehq lar cheaq te lehq daq che tawd khuhd haq khawd-ehg kheh te yaw ghag le. Awg lawn ghod ver ni ma awg khuhn kha peh cawg chehd che heh te lehq mawq kaw khuhn liz awg ceng u ve teq pa haq yaw tuhz peha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Daq che chaw awr lehr, a sug yawd ved ni ma khuhn cawg lar che daq che awg ceng haq lehax yaw tuhz peha che yaog. Kheh te lehq haeg che chaw teq pa awr lehr, a sug yawd ved ni ma khuhn cawg lar che heh te lehq haeg che awg ceng haq yaw tuhz peha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ngag nig hehd haq koz ax laq, suhx jehg suhx taz che awg ni u ve huh gaeg ver, chaw awg gha lia awr lehr awg bon mad cawg che tawd khuhd kha yaw lar che teq pa haq gha kawq koz mar vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Awg lawn ghod ver, nawg ved tawd khuhd haq te lehq nawg vend bax tar che haq gha pong lehq, nawg ved tawd khuhd haq te lehq nawg cir yanr che haq liz gha khanr tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Awg yand u ve khuhn liq buhq var he lehq Phar rir sehd teq pa Yer suq haq koz vid che, “Sar lar-og, nawg te mar lar che awg hez teq ceng cear haq ngag hehd mawg gad che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yawd i hehd haq kawq koz vid che, “Haeg lehq hax chawd hax paz te che chaw heh te lehq Ghig sa haq ma yawz maq yan che chaw che ve teq co awr lehr, awg hez haq lawg che yaog. Cuh kar var Yod naq ve awg hez ma hez ver, awg kag awg nuz awr ve awg hez chaw che ve teq co haq maq te mar vid. ");
INSERT INTO lhi_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yod naq awr lehr, ngad nux maz ux peg khuhn sehr ni sehr hax gha chehd che heh te lehq chaw yad ve Yad phu liz, mig kor khuhn sehr ni sehr hax gha chehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Suhx jehg suhx taz che awg ni haq gaeg ver, Nid nar ver med yad teq pa awr lehr, chaw a meha teq co haq ve chaw geh teq geha tuag lehq chaw a meha teq co ve haq vend bax tar tug yaog. Awg lawn ghod ver, Yod naq bon mar che haq te lehq, i hehd a sug yawd ved vend bax haq duhd phuhz che yaog. Kheh ma khuhd, a meha chuhr huh Yod naq haq keh ir che te ghad chehd chehd liz, nig hehd vend bax haq ma duhd phuhz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Suhx jehg suhx taz che awg ni haq ver, awg huhx muhd mig lo chehd che jawd mawd ma liz a meha teq co ve chaw geh teq geha tuag lehq chaw a meha teq co ve haq vend bax tar tug yaog. Awg lawn ghod ver, yawd Sawd laq monr ve cud yiq haq na tug mig gig awg leh med lo tu lehq lag che yaog. Kheh ma khuhd, a meha chuhr huh Sawd laq monr haq keh ir che te ghad chehd chehd liz, nig hehd yawd khuhd maq na yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ned chaq chiz teq kheh chaw te ghad awg khuhn tuhez lehq a kaz mad cawg lehq awg god khehz teag lo ca koad kae lehq ghad jehd kig ca kaod ngawx-eg liz ca mad mawg che te yand, ");
INSERT INTO lhi_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","yawd koz che, ‘Ngag tuhaz che ngag ved yehg lo kaw koeq sar,’ lehd koz lehq yawd kawq kawaq che te yand yehg u ve kawd-aw ghad kehr ghad kha sehax ghu jawq siz lar lawz che haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kheh te lehq, yawd kae lehq yawd haq keh haeg jad che ned suhr kheh haq sir veha lehq, yehg u ve khuhn phoz geh lehq chehd che yaog. Kheh te lehq awg khaz nuhr gaeg lehq chaw u ve awr lehr awg kawd maq thad haq keh liz kawq haeg jad vehr che yaog. A meha teq co haq ve chaw haeg che awr lehr, che ve haq sur daq che yaog,” lehz Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yer suq chaw awg mor nux haq tawd yaw vid chehd-ag huh, yawd ved awr ye he lehq awq nax var teq pa awr lehr yawd haq tawd yaw daq gad lehq awg bag huh lag hox law chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kheh te lehq, chaw te ghad lag lehq Yer suq haq koz vid che, “Nawr ye he lehq nawg nax var teq pa nawg haq tawd yaw daq gad lehq awg bag huh hox law chehd che yaog.” ");
INSERT INTO lhi_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yawd haq lag koz-a che phad haq Yer suq koz vid che, “Ngar ye he lehq ngag nax var teq pa a suawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kheh te peg lehq yawd ved awg laq ghuhd teq pa haq yawd bez lar lehq koz che, “Chuhr huh ngawx, chaw che ve teq pa awr lehr, ngar ye he lehq ngag nax var teq pa phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Muhd nuh maq lo chehd che ngag ved Awr pa ve a lor haq kha ghaq te che chaw teq pa awr lehr ngag nax var, ngag nax ma he lehq ngar ye phehq che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Awg ni u ve haq Yer suq yehg u ve khuhn tuhez lehq Gar liq lehd ghig po nux pad huh kae lehq mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Chaw awg mor nux awr lehr Yer suq yawd chehd huh phoz lag vehr cheaq te lehq yawd yaeq lehq, huh lawd kor khuhn geh mi chehd che yaog. Chaw awg mor nux vawr, pehg puhg huh phoz hox chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kheh te lehq, yawd tawd par hax te lehq awg lawn laex ceng mar vid lehq koz che, “Awg yuhd ser var te ghad awg yuhd ca ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yawd awg yuhd ser thad huh, awg yuhd ted pehg pehar yaq kaw khuhn che geh lehq ngaz teq pa yaq lehq ghawz cad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Awg yuhd ted pehg pehar mig sar pad kig huh huhx meh de khuhn che geh lehq mig sar maq nax cheaq te lehq har naq yeg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kheh ma khuhd awg yeg u ve teq pa awg chi geh maq nax cheaq te lehq, muhd ni tuhaz ver, muhd cha chiz jad ver nuhr vehr god vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Awg yuhd ted pehg pehar a chud de khuhn che geh lehq a chud yeg teq pa ir-ag lehq awg yeg u ve haq hoz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Awg yuhd ted pehg pehar mig khid daq kig huh che geh lehq awg sir nuhq che yaog. Ted pehg pehar teq ha pun, ted pehg pehar khuhq chi pun, ted pehg pehar sehz chi pun nuhq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nar puh cawg che chaw kha sehax naoq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Awg laq ghuhd teq pa Yer suq geh lag lehq koz che, “A thoq te chaw che ve teq pa haq nawg tawd par hax te lehq mar vid cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yer suq i hehd haq kawq koz vid che, “Muhd nuh maq muhd mig awg lawn khuhd ceh lar che awg ceng teq pa haq nig hehd sir tug a khawag cawg che yaog. Kheh ma khuhd, i hehd teq pa sir tug a khawag mad cawg hawg. ");
INSERT INTO lhi_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Awg lawn ghod ver, cawg chehd che chaw haq kawq thehnr vid lehq yawd kha peh vad-ag kawq cawg mad vid tug yaog. Kheh ma khuhd, mad cawg che chaw geh yawd kha cawg lar che teq pa haq liz kawq yug ve tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Awg lawn ghod ver i hehd ngawx mawg chehd liz, mad mawg che heh te lehq kad chehd liz ma kad che heh te lehq maq na gha cheaq te lehq ngag i hehd teq pa haq tawd par hax gha te mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Cuh kar var Id sar yaq koz lar che tawd khuhd i hehd khuhn phehaq che yaog. Yawd koz lar che, ‘Nig hehd awg cehg mag gha kad liz, na maq gha hawg. Nig hehd awg cehg mag gha mawg liz, maq sir hawg. ");
INSERT INTO lhi_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Awg lawn ghod ver, chaw ceng che ve mehz sir haq hoz tehr lar lehq nar puh liz chuhd lar lehq, ni ma liz heh cheaq te lehq i hehd kad liz mag na gha, mawg liz maq sir, ni ma khuhn liz maq gehg che yaog. Kheh mehz ver, ngag geh phuhz kawaq heh ver ghu na vid che haq gha tug yaog,’ lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kheh ma khuhd nig hehd ve mehz sir mawg lehq nar puh liz gha kad che awr lehr, awg bon ir jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ngag nig hehd haq awg cehg mag koz ax laq, nig hehd gha mawg chehd che awg ceng teq pa haq a mig thad lo ve Ghig sa ve cuh kar var teq pa he lehq thed che cawd che chaw teq pa laex ghad mawg gad jad liz, maq gha mawg. Nig hehd gha kad che teq pa haq i hehd kad gad jad liz, maq gha kad. ");
INSERT INTO lhi_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Awg yuhd ser var ve awg lawn tawd par hax te mar lar che cuhx kig haq kha sehax na lar. ");
INSERT INTO lhi_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Chaw te ghad Ghig sa ve muhd mig awg lawn gha kad lehq na maq gha ver, ned haeg lag lehq yawd ved ni ma khuhn lo ser lar che awg yuhd haq yug tuhz vehr che yaog. Che ve awr lehr, yaq kaw khuhn che che awg yuhd haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Huhx meh de lo che che awg yuhd awg lawn awr lehr, bon khuhd haq gha kad lehq teq pear lehax har naq ha lehg ha ka haq yug che chaw haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kheh ma khuhd bon khuhd u ve haq te lehq tuq che khanr che he lehq du deh che haq gha phud che te yand, yawd ved ni ma sir khuhn awg chi kha sehax ma cuhz yeg cheaq te lehq, khanr ma ghad lehq teq pear lehax yawd chid bag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","A chud de lo che che awg yuhd awg lawn awr lehr, bon khuhd u ve haq gha kad liz mig gig khod-aq lo ve duhd har tug awg ceng teq pa he lehq phu si med nged jeg kor teq pa bon khuhd u ve haq hoz beh lar cheaq te lehq awg sir nuhq maq gha che chaw haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mig khid daq kig lo che che awg yuhd awg lawn awr lehr, bon khuhd u ve haq gha kad lehq na gha che chaw teq pa haq koz che yaog. I hehd teq pa ted pehg pehar teq ha pun, ted pehg pehar khuhq chi pun he lehq ted pehg pehar sehz chi pun awg sir nuhaq che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yer suq i hehd haq awg kag awr ve awg lawn tawd par hax ted mag kawq te mar vid lehq koz che, “Muhd nuh maq muhd mig awr lehr yawd ved ha khuhn daq che awg yuhd ser che chaw te ghad haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Chaw yad teq pa yuhq mir ka chehd huh, yawd ved cand par lag lehq a cag ser lar che khuhn a vanx yuhd kawq ser ke lar haz lehq kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Awg yeg yeg vehr lehq awg sir nuhaq che te yand, a vanx haq liz kha sehax ngawx lehq sir gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kheh te lehq yehg sehr phad haq awg ceg var teq pa na lehq koz che, ‘Jawd mawd-og, nawg ved ha khuhn lo daq che awg yuhd haq lehax nawg ser lar che ma hez hawg la. A thoq te a vanx cawg gha cheawg le,’ lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Yehg sehr phad kawq koz vid che, ‘Cand par te ghad ghad te che yaog,’ lehz i hehd haq koz vid che yaog. Awg ceg var teq pa yawd haq na lehq koz che, ‘Nawg ngag hehd haq a vanx cehg u ve teq pa ca ghawg kha vid gad la,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yawd kawq koz vid che, ‘Taq te ser. Nig hehd a vanx cehg haq ghawg chid bag ver a cag cehg teq pa haq liz ga ghawg chid bag vehr lawg. ");
INSERT INTO lhi_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Teh lar lehq a cag ghig che awg yand kha gag nid ceng cear teq geha ir taz chehd vid ser,’ lehz yehg sehr phad koz che yaog. A cag ghiq yand gaeg ver, ‘A vanx cehg haq awg kawd ghiq chuhq lar lehq a mir khuhn tox ke peg nuhr heh, a cag haq ghiq dawz lehq cag sir ngag ved cag yehg khuhn saw ke laoq,’ lehz a cag ghiq var teq pa haq ngag koz vid tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yer suq i hehd haq tawd par hax ted mag kawq te mar vid lehq koz che, “Muhd nuh maq muhd mig awr lehr chaw te ghad yawd ved ha khuhn ser lar che a ghawd yuhd haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Awg yuhd u ve awr lehr awg yuhd awg ceng gha lia khuhn suaq keh i jad liz iar che te yand, ghawd phaq muhq nuha teq pa awg kag awr ve haq keh ir lehq awg cehg nux maz phehq vehr che yaog. Kheh te lehq muhd-aq lo pog tod che ngaz teq pa lag lehq awg kax teq pa thag huh awg phi te lehq ghad jehd che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yer suq i hehd haq tawd par hax ted mag kawq te mar vid lehq koz che, “Muhd nuh maq muhd mig awr lehr did haq sur daq che yaog. Yad mid te ghad did haq yug lehq khaor mod mia sehz khuhr luhd khuhn ke ver, awg gha lia haq saw cid tuag vid gha che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Awg lawn che ve teq pa awg gha lia haq Yer suq tawd par hax te lehq chaw mor nux haq koz mar vid che yaog. Tawd par hax maq te ver yawd i hehd haq maq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Yawd che kheh te che awr lehr Ghig sa ve cuh kar var koz lar che tawd khuhd heh phehaq vid tug te che yaog. Tawd khuhd u ve awr lehr, “Ngag ved mawq kaw ngax lehq tawd par hax te mar vid tug yaog. Mig gig haq tanr te phanr thad loar khuhd ceh lar che awg ceng haq ngag pheq mar vid tug yaog,” lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yer suq yawd chaw mor nux haq phaz daq lar haz lehq yehg khuhn gehe che te yand yawd ved awg laq ghuhd teq pa yawd chehd huh lag lehq, “Ha khuhn ser che a vanx yeg awg lawn tawd par hax te mar che cuhx kig ngag hehd haq a cehax koz mar ax laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yer suq yawd kawq koz che, “Daq che awg yuhd ser par awr lehr chaw yad ve Yad phu yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ha awr lehr mig gig che ve haq koz che yaog. Daq che awg yuhd awr lehr muhd nuh maq muhd mig yad teq pa haq koz che yaog. A vanx yeg awr lehr haeg che awg sehr phad ve awg yad teq pa haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Awg yuhd u ve haq ser che cand par awr lehr ned haeg yaog. A cag ghiq che awg yand awr lehr mig gig che ve leh che awg yand haq koz che yaog. A cag ghiq sehr phad teq pa awr lehr muhd nuh maq cuh yad teq pa haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","A vanx yeg haq ghiq lehq a mir khuhn tox ke che heh te lehq mig gig che ve leh che awg yand gaeg ver, u ve heh phehaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Chaw yad ve Yad phu awr lehr yawd ved muhd nuh maq cuh yad teq pa haq peha lehq su haq te yaq vid che chaw he lehq haeg che haq te che chaw awg gha lia haq yawd ved muhd mig awg khuhn i hehd saw yug tuhz peg ver, ");
INSERT INTO lhi_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","a mir ji paw chiz jad che khuhn yug chid bag ke tug yaog. U huh i hehd kug huhg paz huhg lehq cig gig yuhz cheq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kheh te lehq, awg yand u ve khuhn thed che cawd che chaw teq pa awr lehr i hehd ve Awr pa ve muhd mig khuhn muhd ni heh te awg ghiq pawd-ag tug yaog. Nar puh cawg che chaw kha sehax naoq. ");
INSERT INTO lhi_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Muhd nuh maq muhd mig awr lehr, ti mi khuhn khuhd ceh lar che awg phuhd khaz jad che med nged haq sur daq che yaog. Med nged u ve haq mawg che chaw awr lehr, kawq ghu khuhd ceh lar haz lehq ha lehg jad che khuhn koeq lehq yawd kha cawg lar che med nged awg ceng gha lia haq huhd kha lar haz lehq ti mi u ve haq vig yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Muhd nuh maq muhd mig awr lehr daq jad che pix koer sehnx sir haq ca che tad kag var haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Yawd awg phuhd khaz jad che pix koer sehnx sir ted mag haq gha mawg che te yand, yawd koeq lehq yawd kha cawg lar che med nged awg ceng gha lia saw huhd ve lehq sehnx sir u ve haq vig yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ted ceng liz, muhd nuh maq muhd mig awr lehr lad chuhd ghig khuhn phehd ke lehq ngad awg ceng gha lia haq hoz yug chehd che geq haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ngad kha peh vad-ag cawg vehr che te yand, ngad ca var teq pa geq haq ghig puhg lo ghawg yug peg ver, mi lar lehq daq che ngad teq pa haq khuhr luhd khuhn lez ke lehq mad daq che ngad teq pa haq yug chid bag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mig gig leh che awg yand u ve liz che ve haq sur daq che yaog. Muhd nuh maq cuh yad te pa tuhaz lehq thed che cawd che chaw teq pa he lehq haeg che chaw teq pa haq fir daq pehg daq peg ver, ");
INSERT INTO lhi_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","haeg che chaw teq pa haq a mir ji paw chiz jad che khuhn yug bag ke tug yaog. U huh i hehd kug huhg paz huhg lar lehq cig geq yuhz cheq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Awg lawn che ve teq pa awg gha lia haq nig hehd teq pa saw na gha vehor la,” lehd koz na ngawx che te yand, “na gha vehor,” lehz i hehd yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yer suq kawq koz vid che, “Kheh te lehq, muhd nuh maq muhd mig awg lawn hend yug peg che liq buhq var awg gha lia awr lehr, yehg sehr phad te ghad a sug yawd ved med nged ke lar kig awg khuhn med nged awg pir he lehq awg suhx yug tuhz che haq sur daq che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tawd pa hax u ve teq pa haq Yer suq te mar vid peg lehq yawd u huh tuhz veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yawd ved muhd mig lo yawd kawq gag vehr lehq i hehd ve bon lawg kig khuhn mar vid che yaog. Kheh te lehq i hehd teq pa and lehq koz che, “Chaw che ve phad, che kheh te che cud yiq he lehq kand pax khar lo ca gha veha cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yawd vawr a suhz te var ve yad par ma hez hawg la. Awr ye liz Mar riq meh che ma hez hawg la. Yawd ved awg nax var teq pa vawr, Yar koq, Yod sehq, Sid monr he lehq Yud daq teq pa ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yawd ved awg nax ma teq pa liz a nig geh chehd chehd che ma hez hawg la. Kheh te lehq chaw che ve phad vawr che kheh te gha che cud yiq he lehq kand pax che ve teq pa khar lo ca gha veha cheawg le,” lehd koz lehq ");
INSERT INTO lhi_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","nez nag che yaog. Yer suq i hehd haq koz vid che, “Ghig sa ve cuh kar var te ghad awr lehr awg mig awg phond cawg che yaog. Kheh ma khuhd a sug yawd ved muhd mig he lehq a sug yawd ved yehg awg khuhn awg mig awg phond mad cawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I hehd teq pa Yer suq haq maq yonr cheaq te lehq, u huh yawd and tug kha peh maq te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Awg yand u ve haq Gar liq lehd muhd mig khuhn jawd mawd Her roq uq penr chehd huh, Yer suq ve awg lawn haq gha kad lehq, ");
INSERT INTO lhi_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","yawd ved awg ceg teq pa haq koz vid che, “Che ve phad awr lehr a kaz tur vid var Yod hanr yaog. Yawd suh vehr che kawq teq tuag vehr cheaq te lehq yawd and tug awg ceng che ve teq pa haq te gha che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Jawd mawd Her roq yawd ved awg nax var Phid liq ve awg mid ma Her ror diq awg lawn haq te lehq, Yod hanr haq pheh lehq thawnr khuhn ke lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Awg lawn ghod ver Yod hanr awr lehr, “Yad mid u ve haq nawg he maq na hawg,” lehz yawd haq koz vid jaw cheaq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jawd mawd Her roq awr lehr Yod hanr haq dawz vehr gad liz muhd mig yad teq pa haq yawd kuhz che yaog. Awg lawn ghod ver, Yod hanr awr lehr Ghig sa ve cuh kar var yaog lehz muhd mig yad teq pa sawnr lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kheh ma khuhd, Jawd mawd Her roq paw che awg ni haq duhd nuhd che pawehd te thad huh, Her ror diq ve awg yad mid chaw kheh ma ve mehz khuhd suhr lo pawehd te mar vid lehq Jawd mawd Her roq ni ma cawd jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kheh te lehq yad mid u ve haq, “Nawg kha lawg che awg ceng gha lia nawg haq pehar tug yaog,” lehd koz jawd mawd Her roq kar tiq te lehq khanr lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yad mid u ve lawg che vawr, awr ye mar vid lar che heh te lehq, “A kaz tur vid var Yod hanr ve a kor yug lehq a khehd pehd nehz khuhn ke lehq chuhr huh pehar laoq,” lehd koz lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jawd mawd Her roq yawd duhd har jad che yaog. Kheh liz yawd chaw kheh ma ve mehz khuhd suhr khanr lar che tawd khuhd gha cawg lar cheaq te lehq yad mid u ve lawg che heh te vid tug a khawag pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kheh te lehq, yawd chaw haq phehd pe lehq thawnr yehg khuhn Yod hanr ve a kor ca tawz yug pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A kor u ve a khehd pehz nehz khuhn ke veha lag lehq yad mid u ve haq pid lehq yawd liz awr ye haq yug ve ca pid-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kheh te lehq, Yod hanr ve awg laq ghuhd teq pa lag lehq yawd ved awg ton haq tur vid lar haz lehq i hehd teq pa Yer suq haq ca khae mar vid-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yer suq awg lawn u ve haq gha kad che te yand, yawd huh lawd kor cind ve lehq chaw gawr ghad te kig lo yawd te ghad lehax veh che yaog. Med teq pa khuhn chehd che muhd mig yad teq pa gha kad vehr lehq mig gig thang veaq seh yaq kaw tod lehq yawd khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yawd huh lawd kor khuhn tuhez che te yand, chaw awg mor nux haq yawd gha mawg che yaog. Yawd i hehd teq pa haq har kax lehq i hehd teq pa khuhn ve chaw nag teq pa haq ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Muhd phiq vehr lehq awg laq ghuhd teq pa yawd chehd lo lag lehq koz che, “Chuhr huh vawr heh pir khuhn te lehq muhd liz phiq vehr tez-og. Chaw che teq pa haq khaz khuhn kae lehq cad tug ca vig cad-eg vid tug i hehd haq phehd pe vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Kheh ma khuhd Yer suq i hehd haq koz vid che, “I hehd kae vid tug maq lor hawg. Nig hehd i hehd haq car vid laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Awg laq ghuhd teq pa kawq koz vid che, “Ngag hehd geh khaor mod ngad dig he lehq ngad nehax niq kheha lehax cawg che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yer suq kawq koz vid che, “U ve teq pa yug veha lehq ngag chehd lo laor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Kheh te lehq, “Chaw mor nux haq, muhq de thang huh phoz mi cuh vid-oq,” lehd koz vid che yaog. Khaor mod u ve ngad diq he lehq ngad niq kheh u ve haq yawd yug lar lehq muhd nuh maq lo kuhr chid ngawx lar lehq bon chid muh che yaog. U kheh te peg lehq yawd khaor mod haq khehq lehq awg laq ghuhd teq pa haq pid lehq awg laq ghuhd teq pa liz chaw awg mor nux haq pehg car vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kheh te lehq chaw awg gha lia kha buhz gha cad che yaog. Cad lex lar che teq pa haq ca kawq ghawz phoz che te yand, teq chi niq khuhr luhd kha peh ghad gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Cad che chaw teq pa awr lehr, yad mid he lehq chaw yad nehax haq maq sawnr liz, haw khaz lehax a lag kheh ngad hinx ghad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","U kheh te peg lehq Yer suq awr lehr muhd mig yad teq pa haq phehd pe vid chehd-ag huh, awg laq ghuhd teq pa haq huh lawd kor khuhn geh lehq yawd haq keh awg kawd ghig po nux ox pax awr lo khanr kae pe lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yawd muhd mig yad teq pa haq phehd pe vid peg lehq yawd te ghad lehax bon ca laweg tug keh thag lo taez che yaog. Muhd sux naz vehr liz, yawd te ghad lehax u huh chehd chehd ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Huh lawd kor u ve ghig po awg kaw jen lo gaeg che te yand muhd huh phawd ma cawd cheaq te lehq, ghig bad taz lehq huh lawd kor haq thinr jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Muhd khax te khend lo muhd thid-ag phawd awr seh na rir te lehq khuhq nar rir awg kar u ve khuhn Yer suq a kaz thag huh yaq kaw tod ve lehq i hehd teq pa chehd lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","A kaz thag lo yawd yaq kaw tod lag che haq awg laq ghuhd teq pa gha mawg lehq i hehd kuhz jad lehq, “Chaw ha law,” lehd koz che yaog. I hehd kuhz jad cheaq te lehq hax ceh kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yer suq i hehd haq har naq kug vid lehq koz che, “Ni hehd ve ni ma tag vid-oq. Ta kuhz. Ngag yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Per troq yawd haq koz vid che, “Jawd mawd-og, nawg awg cehg mag ver a kaz thag huh veaq seh ngag haq nawg chehd lo lag cuha laoq hehq,” lehd koz vid che te yand, ");
INSERT INTO lhi_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Laor hehq,” lehz yawd koz che yaog. Kheh te lehq Per troq huh lawd kor khuhn tuhez lehq a kaz thag veaq seh yaq kaw tod lehq Yer suq chehd lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kheh ma khuhd muhd huh hehnd jad che haq yawd gha mawg lehq kuhz jad vehr che yaog. Yawd a kaz ka vehr lehd te che te yand, “Jawd mawd-og, ngag haq a cehax ga laoq,” lehd koz kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Teq pear lehax Yer suq yawd ved laq kuhr che lehq yawd haq ghawg cid lar lehq koz vid che, “Kha sehax maq yonr che chaw-og, a thoq te lehq nawg thuhd duhd nuhg duhd te cheawg le,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yer suq he lehq Per troq ix mag huh lawd kor khuhn gehag vehr che te yand, muhd huh liz dehg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Huh lawd kor khuhn chehd che chaw teq pa yawd haq a kor pi lehq koz che, “Nawg awr lehr awg cehg mag Ghig sa ve Yad phu yag lo,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ghig po nux ox pax awr lo khanr kae lehq Ger ner sar rehq muhd mig lo gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","U huh chehd che chaw teq pa awr lehr, Yer suq haq tawnd gha che te yand, i hehd chaw phehd pe lehq muhd mig u ve khuhn ted kag peg ted kag ca kaod koz vid lehq nag che guhg che chaw teq pa awg gha lia Yer suq chehd lo sir veha lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chaw nag teq pa awr lehr Yer suq yawd ved a poq awg jog med nehax haq gha soz tug kheh tawa yawd haq lawg khawx che yaog. Kha soz che chaw teq pa liz saw na vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kheh te lehq Phar rir sehd teq pa he lehq liq buhq var teq pa Yer ruq sar lehnr med lo tu lehq Yer suq chehd lo lag na che, ");
INSERT INTO lhi_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nawg ved awg laq ghuhd teq pa a thoq te lehq A pux chaw mawd teq pa pehar lar che awg lid teq pa haq te yaq cheawg le. Awg lawn ghod ver, i hehd teq pa laq kuhr ma chuhd ser liz cad tug cad che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Kheh te lehq, Yer suq i hehd haq kawq koz vid che, “Nig hehd liz a thoq te nig hehd ve awg lid haq te lehq Ghig sa ve awg lid tawd khuhd haq te yaq cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Awg lawn ghod ver Ghig sa koz lar che, ‘Nawg ved awr pa awr ye haq yawz yawz yan yan teoq.’ Kheh te lehq, ‘A sug yawd ved awr pa awr ye haq kha muhd kha na koz che chaw te ghad awr lehr, awg cehg mag gha suh che yaog,’ lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kheh ma khuhd nig hehd awr lehr, ‘Chaw khar ve te ghad lehd ma koz, a sug yawd ved awr pa awr ye haq, “Ngag geh kha cawg che nig hehd gha cawd che med nged teq pa Ghig sa haq tand vid peor,” lehd koz peg ver, ");
INSERT INTO lhi_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","a suq yawd ved awr pa awr ye haq yawz yan tug maq lor,’ lehz nig hehd koz che yaog. Kheh te lehq nig hehd ve awg lid haq te lehq Ghig sa pid lar che tawd khuhd haq nig hehd te lug vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Chaw he ka var teq paog, nig hehd ve awg lawn Id sar yaq koz lar che tawd khuhd awr lehr cawd jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Chaw che ve teq pa awr lehr, i hehd ve mawq kaw ngag haq yawz yan chehd liz, i hehd ve ni ma awr lehr, ngag haq vid daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Chaw yad teq pa teh lar che awg lid awg khad haq mar vid cheaq te lehq, i hehd ngag haq a kor pi che awr lehr, cuhx kig teq chaweh mad cawg,’” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kheh te lehq Yer suq chaw mor nux haq kug veha lehq koz vid che, “Kha sehax na lehq sir laor. ");
INSERT INTO lhi_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mawq kaw khuhn geh veh che awg ceng awr lehr, chaw yad haq chaq chiz tug maq te. Kheh ma khuhd mawq kaw khuhn tuhaz che awg ceng awr lehr, chaw yad haq chaq chiz tug te che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Awg yand u ve khuhn yawd ved awg laq ghuhd teq pa yawd chehd lo lag lehq, “Tawd che ve te khuhd haq Phar rir sehd teq pa gha kad thad huh, i hehd nez nag jad che haq nawg sir chehd-aq la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yer suq kawq koz che, “Muhd nuh maq lo chehd che ngag ved Awr pa maq kha lar che awg cehg awg gha lia haq saw ghawg chid bag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Chaw u ve teq pa a gad lehd vid lar ser. I hehd mehz cox vehr liz yaq kaw mar par te che yaog. Mehz cox che chaw awr lehr, mehz cox che chaw haq yaq kaw seh kae ver, ix mag ni ghad ghad mig kor khuhn che geh tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Kheh te lehq Per troq Yer suq haq koz vid che, “Tawd par hax che ve cuhx kig ngag hehd haq a cehax kawq koz ax laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yer suq kawq koz vid che, “Khawd-ehg kheh awr nag nig hehd liz na maq gha ser cheawg la. ");
INSERT INTO lhi_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mawq kaw khuhn kha cad ke che awg ceng gha lia ux peg khuhn gehe lehq, khuhd kog yehg lo saw chid bag vehr che haq nig hehd maq sir la. ");
INSERT INTO lhi_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kheh ma khuhd mawq kaw khuhn yaw tuhaz che tawd khuhd awr lehr ni ma khuhn lo tuhaz che yaog. Awg ceng che ve teq pa awr lehr chaw yad haq chaq chiz tug te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Awg lawn ghod ver haeg che khad haq duhd che, chaw haq dawz vehr che, hax chawd hax paz te che, gid yaq che, su med nged khuhd che, ma hez hez che haq sax khiz khanr che he lehq maq sawnr ma caz koz che, che ve teq pa awr lehr ni ma khuhn lo tuhaz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Awg ceng che ve teq pa awr lehr chaw haq chaq chiz tug te che yaog. Kheh ma khuhd laq kuhr ma chuhd lehq cad tug cad che vawr, chaw haq chaq chiz tug te che ma hez hawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yer suq u huh tuhez lehq Tud ruq he lehq Sid donr muhd mig phawd awr lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Awg yand u ve khuhn, muhd mig u ve teq tawn khuhn chehd che Khar nar muhd mig chaw phehq che yad mid te ghad awr lehr, “Dar viq ve Yad phu Jawd mawd-og, ngag haq a cehax har kax laoq. Ngag ved yad mid ned geh lehq tuq khanr jad che yaog,” lehd koz hax ceh kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kheh ma khuhd Yer suq tawd teq pear liz maq yaw khuhq vid. Yawd ved awg laq ghuhd teq pa yawd chehd huh lag lehq lawg khawx che, “Yad mid che ve ngag hehd khaz nuhr ghaq lag lar lehq kaod kug tod cheaq te lehq ghaq kawq pe lor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yer suq kawq koz vid che, “Id sar rer laq chaw teq pa khuhn che mehx vehr che yawg nehax heh te che teq pa haq lehax ghaq ca tug kheh tawa Ghig sa ngag haq lag peha lar che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yad mid u ve lag lehq Yer suq mehz khuhd suhr huh nar khehr teh mi lar a kor pi lehq koz che, “Jawd mawd-og, ngag haq a cehax ga laoq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yer suq koz che, “Yad nehax teq pa ve cad tug haq yug lehq phid teq pa haq car vid ma cawd hawg,” lehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yad mid u ve kawq koz che, “Jawd mawd-og, nawg koz che awr lehr cawd che yaog. Kheh ma khuhd phid teq pa awr lehr awg sehr phad ve teh cuh awg huhx sez chehd che cad tug teq pa haq ca ghawz cad che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kheh te lehq Yer suq kawq koz che, “Yad mid-og, nawg yonr che awr lehr ir jad che yaog. Nawg he gad che heh nawg awg pun phehaq vid-oq,” lehd koz vid che yaog. Kheh te lehq yawd ved yad mid liz teq pear lehax na vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yer suq u huh tuhez lehq Gar liq lehd ghig po nux pad huh kae che yaog. Awg yand u ve haq yawd kehaq lo taez lehq mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Awg yand u ve khuhn chaw kha peh vad-ag Yer suq yawd chehd lo lag che yaog. Khi lug laq lug che chaw, mehz cox che chaw, kar che chaw he lehq awg kag awg nuz awr ve chaw nag teq pa laex ghad haq liz i hehd sir veha taz veha lehq yawd ved khi pad huh teh lar che yaog. Kheh te lehq, yawd chaw awg gha lia haq saw ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kheh te lehq, chaw kar teq pa tawd yaw gha vehr lehq khi lug laq lug che chaw teq pa liz kawq daq lehq yaq kaw tod gha vehr lehq, mehz cox che chaw teq pa liz mehz kawq mawg vehr che haq chaw awg gha lia gha mawg che te yand i hehd teq pa and jad lehq Id sar rer laq ve Ghig sa haq chid ir chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yer suq yawd ved awg laq ghuhd teq pa haq kug yug veha lehq koz vid che, “Chaw che ve teq pa haq ngag har kax che yaog. Awg lawn ghod ver i hehd chuhr huh ngag geh chehd che sehr ni gaeg lehq cad tug liz teq chaweh mad cawg. I hehd awr meq jehd chehd ver ngag i hehd haq mad kawq pe gad. Kawq pe ver yaq kaw kar lo i hehd ghad nud lehq awg ghad peg vehr tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Awg laq ghuhd teq pa kawq koz che, “Chaw che kheh ma ve gha cad buhz tug, chuhr huh heh pir khuhn awg god choz teag lo cad tug khar lo cae ver gha hawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yer suq i hehd haq na che, “Nig hehd teq pa geh khaor mod khar nid dig cawg chehd-aq le.” I hehd teq pa koz che, “Khaor mod suhr dig he lehq ngad nehax a cehax cawg che yaog,” lehz i hehd yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Kheh te lehq Yer suq chaw mor nux haq mig kang phoz mi cuh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yer suq khaor mod u ve suhr dig he lehq ngad teq pa haq yug lar lehq bon haq chid muh peg lehq khaor mod khehq che yaog. Kheh te peg lehq, khaor mod he lehq ngad teq pa awg laq ghuhd teq pa haq pid lehq awg laq ghuhd teq pa liz chaw mor nux haq pehg car vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","I hehd awg gha lia kha buhz ghad gha cad peg nuhr, cad lex lar che teq pa haq ca kawq ghawz khuhq che te yand, suhr khuhr luhd kha peh ghad gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kha cad che chaw teq pa awr lehr, yad mid he lehq chaw yad nehax haq maq sawnr liz, haw khaz chaw mawd teq pa lehax uhd hinx ghad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yer suq chaw mor nux u ve teq pa haq kawq pe peg lehq yawd huh lawd kor cind ve lehq Mar gar dar muhd mig lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Awg yand u ve khuhn Phar rir sehd teq pa he lehq Sar duq kehd teq pa lag lehq Yer suq haq lawd ngawx lehq koz che, “Muhd nuh maq ve awg hez a cehax te mar laoq,” lehd koz lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yer suq koz che, “Nig hehd awr lehr muhd phiq ver, ‘Muhd nuh kawag lo nix-i ghad te ver, sawx vawr ver muhd daq tug yaog,’ lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kheh te lehq, ‘Muhd sawx huh muhd nuh maq lo awg ni sid he lehq mog hoz chehd ver yaq ni muhd huh muhd yeg lag tug yaog,’ lehz nig hehd koz che yaog. Nig hehd awr lehr muhd nuh maq lo liz ngawx lehq sir vix chehd liz, ngag te che awg cuhx awg yand awg hez teq pa haq nig hehd fir daq maq gha. ");
INSERT INTO lhi_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Haeg lehq hax chawd hax paz te che chaw heh te lehq Ghig sa haq ma yawz maq yan che chaw che ve teq co awr lehr awg hez haq lehax lawg che yaog. Kheh ma khuhd Yod naq ve awg hez ma hez ver, awg kag awr ve awg hez i hehd haq maq te mar hawg,” lehd koz vid lar haz lehq yawd i hehd haq phaz daq lehq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Awg laq ghuhd teq pa ghig po nux ox pax awr lo khanr kae tod che te yand khaor mod mad yug veha che haq duhd nuhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yer suq koz che, “Phar rir sehd he lehq Sar duq kehd teq pa ve did haq sa tiq kha sehax teoq,” lehd koz lehq i hehd haq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Awg laq ghuhd teq pa koz daq che, “A nig khaor mod mad yug veha cheaq te lehq yawd che kheh koz che yaog,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yer suq awg lawn u ve haq sir lehq koz che, “Kha nehax maq yonr che chaw teq paog. Nig hehd khaor mod mad yug veha lag che awg lawn haq a thoq te lehq nig hehd kaod koz daq cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","A meha kha gag liz nig hehd ma duhd gha ser cheawg la. Khaor mod ngad dig haq chaw ngad hinx ghad cad peg nuhr, nig hehd awg lex khar niq khuhr luhd kawq ghawz gha che haq ma duhd nuhd vehr lehq la. ");
INSERT INTO lhi_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kheh te lehq khaor mod suhr dig haq chaw uhd hinx ghad cad peg nuhr, nig hehd awg lex khar niq khuhr luhd kawq ghawz gha che haq ma duhd nuhd vehr lehq la. ");
INSERT INTO lhi_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ngag khaor mod awg lawn haq te lehq nig hehd haq koz chehd che ma hez hawg. A thoq te lehq nig hehd na maq gha cheawg le. Phar rir sehd he lehq Sar duq kehd teq pa ve did haq sa tiq tar lehq jaw kae veh kae,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kheh te lehq awg laq ghuhd teq pa khaor mod khuhn ke che did haq yawd koz chehd che ma hez law lehz i hehd na gha vehr che yaog. Kheh te lar Phar rir sehd he lehq Sar duq kehd teq pa ve mar che tawd khuhd haq sa tiq tar lehq jaw kae veh kae vid tug koz chehd che law, lehz i hehd gha sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yer suq awr lehr Phid liq Kehd sar riq muhd mid lo gaeg che te yand yawd ved awg laq ghuhd teq pa haq na ngawx che, “Chaw yad ve Yad phu haq a suawg lehd su koz chehd-aq le.” ");
INSERT INTO lhi_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","I hehd kawq koz che, “Chaw ted pehg pehar nawg haq Yod hanr a kaz tur var yaog lehd koz chehd-aq, ted pehg pehar Ed lid yaq yaog lehd koz chehd-aq, ted pehg pehar Yer rar miq, ma hez ver, Ghig sa ve cuh kar var te ghad ghad yaog lehd koz chehd-aq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yer suq yawd ved awg laq ghuhd teq pa haq kawq na lehq koz che, “Kheh te ver, nig hehd teq pa vawr, ngag haq a suawg lehd koz chehd cheawg le.” ");
INSERT INTO lhi_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sid monr Per troq kawq koz che, “Nawg awr lehr Khreq lehd koz che, teq chehd che Ghig sa ve Yad phu phehq che yaog.” ");
INSERT INTO lhi_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yer suq yawd haq kawq koz vid che, “Yod naq ve yad par Sid monr-og, nawg awr lehr awg bon ir che yaog. Awg lawn ghod ver chaw yad nawg haq awg lawn che ve pheq mar che ma hez hawg. Muhd nuh maq lo chehd che ngag ved Awr pa nawg haq pheq mar ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Kheh te lehq, ngag nawg haq koz ax laq, nawg awr lehr Per troq yaog. Huhx meh che ve awg thag huh ngag ved awg mor haq ngag te tug yaog. Suh che muhd mig ve kand pax awr lehr awg mor che ve haq ma ghad hawg. ");
INSERT INTO lhi_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Muhd nuh maq muhd mig ve sawnd liz ngag nawg haq peha tug yaog. Mig gig khod-aq lo nawg kha pheh lar che teq pa haq muhd nuh maq lo liz pheh lar tug yaog. Mig gig khod-aq lo nawg kha phi kha vid che teq pa haq muhd nuh maq muhd mig khuhn lo liz phi kha vid tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kheh te lehq yawd Khreq phehq che awg lawn chaw te ghad-eg haq liz maq gha koz vid tug yawd i hehd haq tawd hehnd chawa yaw vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Awg yand u ve haq tanr lehq Yer suq yawd Yer ruq sar lehnr med lo gha kae lehq awg hox chaw mawd teq pa, paw khod nux teq pa he lehq liq buhq var teq pa ve laq khuhn lo laex ceng haq yawd gha tuq gha khanr tug awg lawn lehd ma koz, yawd gha suh lehq sehr ni teq ni haq gaeg ver kawq teq tuag tug awg lawn teq pa yawd ved awg laq ghuhd teq pa haq koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Per troq yawd haq cuhz ghawg ve lehq, “Jawd mawd-og, u kheh te maq gha hawg. Awg ceng u ve teq pa nawg haq a cehax liz maq gha phehq vid hawg,” lehd koz lehq yawd haq ded che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yer suq kuhr phuhz ngawx lar lehq Per troq haq koz vid che, “Sar tanr-og, phawe lor. Ngag geh ta chehd-oq. Per troq nawg awr lehr ngag ved kanx khad haq tawr chuhd che yaog. Awg lawn ghod ver nawg ved duhd khad awr lehr Ghig sa ve duhd khad ma hez law, chaw yad ve duhd khad yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kheh te lehq Yer suq yawd ved awg laq ghuhd teq pa haq koz vid che, “Chaw khar ve te ghad lehd ma koz ngag khaz nuhr ghaq lag gad ver, a sug yawd ved a lor haq teh lar haz lehq a sug yawd ved laq kan haq taz lehq ngag khaz nuhr ghaq laoq. ");
INSERT INTO lhi_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Awg lawn ghod ver, chaw khar ve te ghad lehd ma koz, a sug yawd ved a saq gha pong vid tug te liz, yawd ved a saq gha sond tug yaog. Kheh ma khuhd chaw khar ve te ghad lehd ma koz, ngag awg pun a saq gha sond ver, yawd ved a saq haq kawq gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Awg lawn ghod ver chaw te ghad ghad mig gig koar kha cawg che awg ceng gha lia saw gha vehr liz yawd ved a saq sond vehr ver, yawd awg pun a thoq awg bon cawg tuawg le. Kheh te lehq, nawg a thoq ted ceng ca yug ve lehq nawg ved a saq haq kawq pa khuhq gha hawg le. ");
INSERT INTO lhi_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Awg lawn ghod ver chaw yad ve Yad phu awr lehr, yawd Awr pa ve awg mig awg phond ir jad che khuhn yawd ved muhd nuh maq cuh yad teq pa geh teq geha lag tug yaog. Awg yand u ve khuhn, a sug yawd te lar che heh chaw awg gha lia haq yawd kawq te vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ngag nig hehd haq awg cehg mag koz ax laq, chuhr huh hox chehd che chaw teq pa awg khuhn ve ted pehg pehar awr lehr, chaw yad ve Yad phu yawd ved muhd mig khuhn lag che haq maq gha mawg ser che kheh ceh yawd maq gha suh ser hawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Khuhq ni peg lehq Yer suq awr lehr Per troq, Yar koq he lehq Yar koq ve awg nax var Yod hanr haq lehax sir ve lehq keh muh maq ted mag thag lo i hehd taez che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kheh te lehq i hehd mehz khuhd suhr huh Yer suq ve awg hoq awg han pa che yaog. Yawd ved mehz khuhd vawr, muhd ni heh te lehq awg ghiz pawd lehq yawd ved beg ke veq kad liz awg ghiz heh te lehq awg phu ched phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mod ser he lehq Ed lid yaq liz i hehd mehz khuhd suhr huh tuhaz lehq Yer suq haq tawd yaw daq chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kheh te lehq Per troq Yer suq haq koz vid che, “Jawd mawd-og, a nig chuhr huh lag chehd chehd che awr lehr daq jad vehr che yaog. Nawg ni ma cawd ver ngag chuhr huh hax po seh lehd te tug yaog. Nawg awg pun ted mag, Mod ser awg pun ted mag he lehq Ed lid yaq awg pun ted mag te tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Per troq koz chehd che mad peg tand, awg ghiz pawd-aw ghad te che mog i hehd haq lag lehq hoz beh vehr che yaog. Kheh te lehq mog u ve khuhn awg khuhd buhg tuhaz lehq koz che, “Chaw che ve awr lehr ngag haq jad che ngag ved Yad phu yaog. Yawd haq ngag ni ma cawd jad che yaog. Yawd ved tawd khuhd haq na yur-og,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Awg laq ghuhd teq pa gha kad che te yand i hehd kuhz jad lehq mehz khuhd miag lo boz cuhx vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Awg yand u ve khuhn Yer suq lag lehq i hehd haq soz lar lehq koz che, “Tu lor. Ta kuhz,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","I hehd kuhr kawq chid ngawx che te yand awg kag awr ve chaw te ghad-eg liz mad mawg. Yer suq te ghad lehax chehd chehd lawz che haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kheh te peg lehq i hehd teq pa kehaq lo kawq yaq tod-ag huh Yer suq i hehd haq koz vid che, “Chaw yad ve Yad phu suh kig lo mad kawq teq tuag ser che kheh ceh nig hehd gha mawg lar haz che awg lawn che ve chaw te ghad-eg haq liz ta koz vid,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Kheh te lehq yawd ved awg laq ghuhd teq pa yawd haq na che, “A thoq te lehq liq buhq var teq pa Ed lid yaq awg kawd lag lawg lehd koz lar cheawg le,” lehd koz lehq na che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yer suq kawq koz vid che, “Ed lid yaq awr lehr awg kawd maq gha lag lehq awg ceng gha lia haq gha saw ghu te lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kheh ma khuhd ngag nig hehd haq koz ax laq, Ed lid yaq lag peor. Kheh liz i hehd yawd haq maq sir cheaq te lehq i hehd te gad che heh yawd haq te vid che yaog. U ve haq kha sur suar chaw yad ve Yad phu haq liz i hehd ve laq khuhn gha khanr tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kheh te lehq awg laq ghuhd teq pa awr lehr, Yod hanr a kaz tur var ve awg lawn haq yawd koz chehd che law lehz i hehd sir vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yer suq he lehq yawd ved awg laq ghuhd teq pa chaw awg mor nux chehd-ag huh kawq gag che te yand haw khaz var te ghad lag lehq yawd mehz khuhd suhr huh nar khehr teh mi lar lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Jawd mawd-og, ngag yad par haq a cehax har kax laoq. Yawd puhq phez cheaq te lehq gha khanr jad che yaog. Yawd a mir khuhn he lehq a kaz khuhn te thawz te thawz kuhd geh don chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nawg ved awg laq ghuhd teq pa chehd lo ngag yawd haq sir veha lag liz i hehd yawd haq ghu na vid maq gha,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yer suq kawq koz vid che, “Ni ma kuhq lehq maq yonr che chaw teq paog. Ngag nig hehd geh khawd-ehg muh maq gha chehd ser tuawg le. Nig hehd haq khawd-ehg muh maq gha yeg khanr ser tuawg le. Chaw yad nehax ix ve ngag chehd lo sir veha lar-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kheh te lehq Yer suq ned u ve haq ded lehq ned u ve yad par nehax u ve khuhn tuhz veh che yaog. Te pehar lehax yad par nehax u ve liz na vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kheh te lehq, Yer suq yawad lehax chehd chehd huh awg laq ghuhd teq pa yawd geh lag lehq na che, “A thoq te lehq ngag hehd ned u ve haq ghaq tuhz maq gha cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yer suq kawq koz vid che, “Awg lawn ghod ver nig hehd kha sehax maq yonr cheaq te lehq yaog. Ngag nig hehd haq awg cehg mag koz ax laq, nig hehd yonr che ted ceng a ghawd yuhd kheh hia liz cawg ver, keh che ve ted dig haq, ‘Ox lo jiz kae,’ lehd koz vid liz, jiz veh tug yaog. Nig hehd te maq gha che teq chaweh liz mad cawg hawg,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Gar liq lehd muhd mig khuhn i hehd teq geha phoz chehd thad huh Yer suq koz che, “Chaw yad ve Yad phu awr lehr chaw yad ve laq khuhn chid aq che haq gha khanr tug awg yand ned vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","I hehd yawd haq dawz vehr lehq sehr ni teq ni gaeg ver yawd kawq teq tuag tug yaog,” lehd koz che te yand, awg laq ghuhd teq pa duhd har jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","I hehd Kar per nar unr med lo kawq gaeg che te yand, bon yehg nux awg pun awg khawnr ghawz sehr phad teq pa Per troq chehd lo lag lehq, “Nawg ved sar lar vawr awg khawnr maq ke cheawg la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Per troq kawq koz vid che, “Ke che yaog,” lehd koz che yaog. Kheh te lehq Per troq yehg khuhn gehe che te yand, Yer suq tawd awg kawd yaw lehq koz che, “Sid monr-og, nawg khawd-ehg kheh duhd-aq le. Mig gig koar ve jawd mawd teq pa awr lehr a suq geh awg khawnr ghawz cawd hawg le. A suq yawd ved yad geh la. Ma hez ver su geh ghawz che la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Su geh ghawz che yaog,” lehz Per troq koz che te yand, Yer suq awr lehr, “Kheh te ver, i hehd ve yad teq pa awg khawnr maq ke vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kheh ma khuhd awg khawnr ghawz par teq pa a nig haq maq gha nez nag vid tug nawg ghig po lo kae lehq ber ted mag ca bag keoq. Awg kawd maq gha che ngad haq yug lehq mawq kaw ngax ngawx ver phu ted thehq haq nawg gha mawg tug yaog. Phu u ve haq yug ve lehq ngag awg pun he lehq nawg awg pun i hehd haq ca ke vid-eq,” lehz Per troq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Awg yand u ve khuhn awg laq ghuhd teq pa Yer suq chehd lo lag lehq koz che, “Muhd nuh maq muhd mig awg khuhn a sug te ghad vawr, suaq keh ir jad hawg le,” lehd koz na che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kheh te lehq Yer suq chaw yad nehax te ghad haq kug veha lehq i hehd teq pa kanr hox vid lar lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Ngag nig hehd haq awg cehg mag koz ax laq, nig hehd ni ma maq pa lehq chaw yad nehax teq pa heh maq te ver, muhd nuh maq muhd mig khuhn nig hehd maq gha gehe hawg. ");
INSERT INTO lhi_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kheh te cheaq te lehq, a sug te ghad lehd ma koz chaw yad nehax che ve heh te lehq ni ma nehr ghad tar che chaw awr lehr, muhd nuh maq muhd mig awg khuhn suaq keh ir jad che chaw te ghad phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chaw a sug te ghad lehd ma koz chaw yad nehax heh te che te ghad haq ngag ved awg meh awg khuhn haq yug ver, ngag haq haq yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Kheh te lehq ngag haq yonr che chaw yad nehax che ve teq pa khuhn ve te ghad haq maq yonr vid tug te che chaw khar ve te ghad lehd ma koz, yawd ved kuhr pehg haq huhx meh mawr nux pheh ku li lehq nax jad che lad chuhd ghig khuhn chid bag ke pe ver, yawd awg pun daq jad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Su te yaq vid tug te cheaq te lehq, mig gig chaw yad gha duhd har jad che yaog. Awg lawn ghod ver su yaq vid tug te che ted ceng awr lehr cawg tug yaog. Kheh ma khuhd su yaq vid tug te che chaw teq pa awr lehr gha duhd har jad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nawg ved laq kuhr ma hez ver khi kud nawg haq te yaq vid tug te ver, tawz khaoq. Khi kud laq kuhr nig pax pax cawg lar lehq khar thad liz maq suh vix lehq toq chehd che a mir khuhn gha khanr cheaq keh, khi kud laq kuhr mad cawg lehq a saq teq kig lo gha gehe che awr lehr, nawg awg pun daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nawg ved mehz sir teq pax nawg haq te yaq vid tug te ver, mehz sir u ve haq kehx khaoq. Mehz sir nig pax pax cawg lar lehq a mir toq chehd che muhd naz hoq khuhn gha khanr cheaq keh, mehz sir teq pax lehax cawg lar lehq a saq teq kig lo gha gehe che awr lehr nawg awg pun daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nig hehd awr lehr chaw yad nehax heh te che te ghad ghad haq maq sawnr ma caz maq gha te tug sa tiq kha sehax teoq. Awg lawn ghod ver ngag ni hehd haq koz ax laq, muhd nuh maq lo i hehd ve muhd nuh maq cuh yad teq pa awr lehr, muhd nuh maq lo ngag ved Awr pa ve mehz khuhd suhr huh khar thad liz chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nig hehd khawd-ehg kheh duhd-aq le. Chaw te ghad ghad yawd ved yawg teq ha kheh cawg lehq teq kheh mehx vehr ver, kuhd chi kuhd kheh haq keh thag lo teh lar haz lehq mehx vehr che teq kheh haq yawd ghaq ca ngawx veh tug yaog ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ngag nig hehd haq awg cehg mag koz ax laq, yawg u ve haq kawq ca mawg vehr ver, maq mehx che yawg kuhd chi kuhd kheh haq ha lehg cheaq keh u ve teq kheh haq ha lehg jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Che ve haq kha sur suar, chaw yad nehax heh te che chaw che ve teq pa te ghad-eg haq liz lug vehr mehx vehr tug haq muhd nuh maq lo chehd che nig hehd ve Awr pa ni ma ma cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nawg ved a vix a nax te ghad ghad nawg haq te yaq ax ver, yawd chehd lo kae lehq nig mag lehax chehd-ag huh yawd ved yaq kig haq kawq koz mar vid-oq. Yawd nawg ved tawd khuhd haq na ver, nawg vix nawg nax haq nawg kawq gha vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kheh ma khuhd nawg ved tawd khuhd haq yawd maq na yug ver, sax khiz te var te ghad la ni ghad sir daq ve lehq teq geha kae-og. Awg lawn ghod ver ni ghad la seh ghad gha sir gha mawg lar vid lehq sax khiz cawg lar vid tug te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","I hehd ve tawd khuhd haq yawd maq na yug ver, Khreq yad awg mor haq koz vid-oq. Khreq yad awg mor ve tawd khuhd haq liz maq kawq na yug ver, bid saz a naz chaw he lehq awg khawnr ghawz var teq pa heh te sawnr tar vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ngag nig hehd haq awg cehg mag koz ax laq, mig gig khod-aq lo nig hehd kha pheh lar che teq pa haq muhd nuh maq lo liz pheh lar tug yaog. Mig gig khod-aq lo nig hehd kha phehd kha vid che teq pa haq muhd nuh maq lo liz phehd kha vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kheh te lehq ngag nig hehd haq kawq koz ax laq, mig gig khod-aq lo nig hehd awg khuhn ve chaw ni ghad ni ma hawr daq lehq ted ceng cear lawg ver, muhd nuh maq lo chehd che ngag ved Awr pa awr lehr, ix maq lawg che heh te vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Awg lawn ghod ver chaw ni ghad seh ghad ngag ved awg meh haq cud lehq phawng daq chehd ver, u huh i hehd geh ngag chehd tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kheh te lehq Per troq Yer suq chehd huh lag lehq na che, “Jawd mawd-og, ngag vix ngag nax teq pa ngag haq te thawz te thawz kaod te yaq ax ver, ngag i hehd haq vend bax khar ni pawz gha phehd vid lawg le. Suhr pawz kha gag la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yer suq yawd haq kawq koz vid che, “Suhr pawz kha gag lehax ma hez hawg. Suhr pawz, suhr chi pawz kha gag la khar ni pawz liz gha phehd vid che yaog lehz ngag nawg haq koz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","A thoq te lehq ngag nawg haq u kheh gha te lehd koz ver, muhd nuh maq muhd mig awr lehr yawd ved awg ceg teq pa geh phu cag land haq ghu te gad che jawd mawd te ghad haq sur che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Yawd cag land haq tanr ghu te chehd che te yand, jawd mawd ve jeg teq chi lang thehq cha lar che chaw te ghad haq su yawd chehd lo sir veha lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Chaw u ve awr lehr, yawd jeg khuhq sehr vid tug mad cawg cheaq te lehq, yawd ved awg sehr phad koz che, ‘Yawd ved awg ton liz, yawd ved awg mid awg yad liz, yawd kha cawg lar che med nged jeg kor teq pa awg gha lia, saw ca huhd ve lehq sehr vid-oq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kheh te lehq awg ceg var u ve yawd mehz khuhd suhr huh nar khehr teh mi lar lehq koz che, ‘Jawd mawd-og, ngag haq awg yand nehax a cehax lawg tar ax ser. Ngag awg gha lia saw ca khuhq sehr ax tug yaog,’ lehd koz lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kheh te lehq jawd mawd awr lehr yawd haq har kax cheaq te lehq yawd haq phehd vid lehq yawd ved jeg haq liz pong vid vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Awg yand u ve khuhn awg ceg var u ve tuhez che te yand, yawd geh jeg teq ha thehq cha lar che awg kag awr ve awg ceg te ghad haq yawd gha mawg lehq yug veha lehq kuhr pehg suhx chuhq lar lehq, ‘Ngag ved jeg a meha har naq sehr laoq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kheh te lehq yawd geh jeg cha lar che awg ceg u ve te ghad awr lehr nar khehr teh mi lar lehq koz che, ‘Ngag haq awg yand nehax a cehax lawg tar ax. Ngag nawg haq ca khuhq sehr ax tug yaog,’ lehd koz lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kheh ma khuhd yawd maq na lehq jeg kawq sehr gha thad kha gag awg ceg var u ve haq thawnr khuhn yug ke lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Yawd che kheh te che haq awg kag awr ve awg ceg teq pa gha mawg che te yand, i hehd duhd har jad lehq awg lawn kha phehaq che teq pa awg sehr phad haq ca koz vid-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kheh te lehq yawd ved awg sehr phad yawd haq kug veha lehq koz vid che, ‘Haeg che awg ceg-og, nawg ngag haq lawg khawx cheaq te lehq nawg ved jeg awg gha lia haq ngag pong ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ngag nawg haq har kax che heh te lehq nawg liz su haq har kax vid cawd che yaog ma hez hawg la,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kheh te peg lehq yawd ved awg sehr phad nez nag jad lehq yawd ved jeg saw sehr peg thad kha gag thawnr khuhn yug ke lehq yawd haq du deh vid tug chid aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nig hehd teq pa liz a sug yawd ved a vix a nax te yaq che teq pa haq ni ma awg tawg kha gag vend bax ma phehd vid ver, muhd nuh maq lo chehd che ngag ved Awr pa liz nig hehd haq che kheh tea tug yaog,” lehz Yer suq i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yer suq awg lawn che ve teq pa awg gha lia saw koz mar vid peg lehq yawd Gar liq lehd muhd mig lo tu lehq Yawd danr lawg kax ox pax awr lo cawg che Yud daq muhd mig lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Chaw kha peh vad-ag awg mor nux yawd khaz nuhr ghaq kae lehq yawd chaw nag u ve teq pa haq saw ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Awg yand u ve khuhn, Phar rir sehd ted pehg pehar yawd haq lawd ngawx tug lag lehq koz che, “A thoq ted ceng haq te lehq lehd ma koz awg lid tawd khuhd haq cud lehq a sug yawd ved awg mid ma haq chid bag gha hawg la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yer suq i hehd haq kawq koz vid che, “Awg kawd maq thad huh te phanr sehr phad Ghig sa awr lehr haw khaz he lehq yad mid haq te phanr lar peg lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Kheh te cheaq te lehq haw khaz awr lehr yawd ved awr pa awr ye haq phaz daq lar haz lehq yawd ved awg mid ma geh ca chehd lehq ix mag ni ghad liz teq suhr teq sar lehax phehq vehr che yaog.’ ");
INSERT INTO lhi_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kheh te cheaq te lehq, ix mag awr lehr ni ghad mad kawq phehq-oq. Kheh te lar, te ghad lehax phehq vehr che yaog. Kheh te cheaq te lehq Ghig sa yug caz daq vid lar che haq chaw yad maq gha yug phaz daq vid hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Phar rir sehd teq pa kawq koz che, “Kheh te ver, chid bag vid che liq te koz buhq vid peg ver chid bag gha hawg lehd a thoq te lehq Mod ser tawd pid lar cheawg le,” lehd koz yawd haq kawq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yer suq i hehd haq kawq koz vid che, “Nig hehd ni ma heh cheaq te lehq a sug yawd ved awg mid ma haq chid bag tug Mod ser a khawag pehar che yaog. Kheh ma khuhd awg kawd maq thad lo ver Ghig sa che kheh maq gha te lar. ");
INSERT INTO lhi_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ngag nig hehd haq koz ax laq, hax chawd hax paz te che ted ceng ma hez ver a sug yawd ved awg mid ma haq chid bag lehq awg kag awg nuz awr ve yad mid haq he che chaw a sug te ghad lehd ma koz hax chawd hax paz te che yaog,” lehz Yer suq i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Awg laq ghuhd teq pa Yer suq haq koz vid che, “Awg phad mawd awg mid ma haq he che ted ceng che kheh phehq che ver, maq he che awr lex lehq daq jad che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kheh te lehq Yer suq i hehd haq koz vid che, “Tawd khuhd che ve haq chaw gha lia khanr yug maq gha hawg. Khanr yug tug awg bon gha che chaw teq pa lehax khanr yug gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Awg lawn ghod ver, chaw ted pehg pehar ver tanr paw tuhaz loar awg tawn phehq tuhaz che yaog. Chaw ted pehg pehar ver, awg tawn phehq vid tug su i hehd haq te vid che yaog. Chaw ted pehg pehar ver muhd nuh maq muhd mig awg pun a sug yawd ved awg ton haq chaw tawn te phehaq vid che yaog. Awg ceng che ve teq pa haq khanr yug gha che chaw teq pa awr lehr awg mid ma maq ca liz cawd che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Awg yand u ve khuhn chaw yad nehax teq pa haq Yer suq laq kuhr tar lehq bon lawg vid tug awg pun su yawd chehd lo sir veha lag che yaog. Awg laq ghuhd teq pa chaw yad nehax sir veha lag che chaw teq pa haq ded che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kheh ma khuhd Yer suq koz vid che, “Chaw yad nehax teq pa haq ngag chehd lo lag peha laoq. I hehd haq taq tawr lar. Awg lawn ghod ver, muhd nuh maq muhd mig awr lehr, chaw yad nehax che ve teq pa heh te che chaw ve muhd mig yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Chaw yad nehax teq pa haq laq kuhr tar vid peg lehq yawd liz u huh tuhz veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Awg yand u ve khuhn chaw te ghad phad Yer suq chehd lo lag lehq koz che, “Sar lar-og, co tiq ha tiq haq gha tug ngag daq che kanx a thoq ted ceng gha te lawg le,” lehd koz na che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yer suq kawq koz vid che, “A thoq te lehq nawg ngag haq daq che awg lawn na cheawg le. Daq che awg sehr phad te ghad lehax cawg che yaog. A saq teq kig lo nawg kae gad ver, awg lid tawd khuhd teq pa haq na yug lehq teoq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Awg lid tawd khuhd khar ve ted mag le,” lehz yawd kawq na che te yand, Yer suq kawq koz vid che, “Chaw haq ta dawz vehr, hax chawd hax paz taq te, su ved med nged haq ta khuhd, su haq ma hez hez che sax khiz taq khanr, ");
INSERT INTO lhi_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","nawr pa nawr ye haq yawz yawz yan yan teoq, nawg awg ton haq haq che heh te lehq nawg pad huh chehd che chaw haq haq-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chaw hax var u ve phad koz che, “Awg ceng che ve teq pa awg gha lia ngag saw te peor. Ngag a thoq ted ceng gha kawq te ser lawg le,” lehd koz kawq na che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yer suq yawd haq kawq koz vid che, “Nawg awg ceng gha lia saw lawq vid gad ver nawg koeq lehq nawg kha cawg lar che med nged jeg kor teq pa awg gha lia saw huhd lehq har yad ghuhd yad teq pa haq ca pehg vid-eq. Muhd nuh maq lo awg phuhd khaz che med nged nawg cawg lar tug yaog. U kheh te lar haz lehq nawg vawr kawaq lehq ngag khaz nuhr ghaq laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Chaw hax var u ve yawd tawd khuhd che ve haq gha kad che te yand, yawd duhd har jad che khuhn kawq veh che yaog. Awg lawn ghod ver yawd paw sa jad lehq med nged jeg kor cawg mad jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yer suq yawd ved awg laq ghuhd teq pa haq koz vid che, “Ngag nig hehd haq awg cehg mag koz ax laq, paw sa che chaw teq pa awr lehr, muhd nud maq muhd mig khuhn gehe tug har jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ngag nig hehd haq te pawz kawq koz ax laq sar, kar lar oq teq kheh a ghoq nar khuhn gehe che vawr, paw sa che chaw te ghad Ghig sa ve muhd mig khuhn gehe cheaq keh sa che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Awg laq ghuhd teq pa tawd khuhd u ve haq gha kad che te yand, i hehd and jad lehq koz che, “Kheh te ver thaer khuhq che haq a sug gha vid tuawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yer suq awg laq ghuhd teq pa haq ngawx lar lehq koz vid che, “Chaw yad vawr te maq gha hawg. Kheh ma khuhd Ghig sa awr lehr awg ceng gha lia haq te gha che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Awg yand u ve khuhn Per troq koz che, “Ngag hehd teq pa awr lehr awg ceng gha lia haq saw chid bag lar haz lehq nawg khaz nuhr ghaq tod che yaog. Kheh te ver ngag hehd teq pa a thoq gha tuawg le,” lehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yer suq i hehd teq pa haq koz vid che, “Ngag nig hehd haq awg cehg mag koz ax laq, mig gig awg suhx ghu te che awg yand khuhn chaw yad ve Yad phu awr lehr yawd ved awg mig awg phond cawg che kaw jaw awg thag lo mi che te yand, nig hehd teq pa ngag khaz nuhr ghaq tod che chaw teq pa liz kaw jaw teq chi nid mag awg thag lo mi lehq Id sar rer laq chaw teq chi nid ceng haq suhx gha jehg gha taz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ngag ved awg meh haq te lehq, a sug yawd ved yehg, a sug yawd ved a vix a nax, a sug yawd ved awr pa awr ye, a sug yawd ved awg yad awg dug, a sug yawd ved ti mi he lehq ha haq chid bag lar haz che chaw awg gha lia awr lehr, u ve haq keh teq ha pun kawq gha lehq co tiq ha tiq awg sinx haq liz gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kheh ma khuhd su haq keh awg kawd chehd che chaw kha peh vad-ag, su khaz nuhr gha kawq chehd tug yaog. Su khaz nuhr chehd chehd che chaw kha peh vad-ag, su haq keh awg kawd chehd chehd lawz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Awg lawn ghod ver muhd nuh maq muhd mig awr lehr yawd ved a pehx med kho khuhn kanx te vid tug muhd sawx ted naq loar chaw ca veh che kho sehr phad te ghad haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Yawd kanx canr te tu ghad phuhd teq ni ve ted thehq pid tug koz daq chez peg lehq yawd i hehd teq pa haq yawd ved a pehx med kho khuhn kanx te pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Muhd sawx phawd awr a lag kuhd nar rir heh te yand huh kho sehr phad yawd kax lo kawq kae lehq kax khuhn kanx mad cawg he lehq kheha chehd chehd che chaw teq pa haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Nig hehd teq pa liz ngag ved a pehx med kho khuhn kae lehq kanx ca te ver, nig hehd ve ghad phuhd kenr daq cawd daq che heh ngag nig hehd haq pehar tug yaog,’ lehd yawd koz vid lehq ");
INSERT INTO lhi_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","i hehd teq pa liz kae che yaog. Kheh te peg lehq kho sehr phad muhd kaw cuhaz huh te pawz he lehq muhd phiq phawd awr seh nar rir kheh yand huh te pawz kawq kae lehq u ve heh te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kheh te lehq muhd phiq phawd awr lo a lag kheh ngad nar rir te yand huh kho sehr phad te pawz kax lo kawq kae lehq chaw ted pehg teq chaweh maq te lehq kheha ca hox chehd cheaq yawd gha mawg lehq, ‘Nig hehd teq pa a thoq te lehq teq ni tad vand chuhr huha lehax hox chehd cheawg le,’ lehd koz i hehd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chaw u ve teq pa kawq koz che, ‘Chaw te ghad-eg liz ngag hehd haq kanx canr maq te cuha cheaq te lehq yaog,’ lehz i hehd yawd haq kawq koz vid che te yand, kho sehr phad i hehd haq koz vid che, ‘Nig hehd teq pa liz ngag ved a pehx med kho khuhn kae lehq kanx ca te lor,’ lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Muhd phiq vehr lehq kho sehr phad awr lehr, ‘Kanx te che chaw teq pa haq ca kug-eq. Su khaz nuhr leh leha lag che te ghad haq tanr lehq awg kawd maq thad loar lag lehq te chehd che chaw awg gha lia haq i hehd ve ghad phuhd pid-oq,’ lehz yawd ved med nged haq sax var haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Muhd phiq pawd awr a lag kheh ngad nar rir te yand huh lag teag che chaw teq pa awr lehr, te ghad ve ted thehq gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Su haq keh awg kawd maq lag lehq kanx ca teag che chaw teq pa lag che te yand, i hehd teq pa awr lehr su haq keh lex lehq i hehd ve ghad phuhd gha mad jad tug yaog lehz duhd lar liz, i hehd teq pa te ghad ve ted thehq lehax gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","I hehd ve ghad phuhd yug peg che te yand, kho sehr phad haq khand lehq ded lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Awg khaz nuhr lo lag lehq ca teag che chaw teq pa awr lehr, teq nar riar lehax kanx gha te che yaog. Kheh liz ngag hehd teq ni tad vand muhd cha awg chiz hehz kanx te nar che chaw teq pa haq kha sur suar nawg i hehd haq ghad phuhd pid che law,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kheh te lehq kho sehr phad i hehd teq pa khuhn ve chaw te ghad haq kawq koz vid che, ‘Awg chawd-og, ngag nig hehd haq ma hez awr ca tea che ma hez hawg. Ngag nig hehd haq ted thehq lehax pehar tug koz daq lar che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nawg ved ghad phuhd haq yug ve lehq kae lor. Awg lawn ghod ver su khaz nuhr lo lag che chaw te ghad haq liz nawg kheh ma pid tug ngag ni ma cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ngag ved phu haq ngag khawd-ehg kheh te yehd gad liz yehd tug a khawag cawg che ma hez hawg la. Ngag ni ma daq lehq su haq pid che haq nawg soer lehq la,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Che ve haq sur daq che yaog. Su khaz nuhr lo chehd che chaw awr lehr, su haq keh awg kawd maq chehd lawz tug yaog. Su haq keh awg kawd maq chehd lar che chaw awr lehr, su khaz nuhr lo kawq chehd chehd lawz tug yaog,” lehz Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kheh te lehq Yer suq yawd Yer ruq sar lehnr med lo kae tod che awg yand khuhn yawd ved awg laq ghuhd teq chi ni ghad haq lehax kug ve kae lehq yaq kaw kar lo i hehd teq pa haq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“A nig Yer ruq sar lehnr med lo kae tod che yaog. Chaw yad ve Yad phu awr lehr paw khod nux teq pa he lehq liq buhq var teq pa ve laq khuhr khuhn chid aq vid che haq gha khanr lehq yawd gha suh vid tug i hehd yawd haq suhx jehg suhx taz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kheh te lehq su yawd haq maq sawnr ma caz te che, jawq che, laq kan thag huh thaq vehr che, awg ceng che ve teq pa haq gha khanr tug bid saz a naz chaw teq pa ve laq khuhn yawd haq chid aq vid tug yaog. Kheh ma khuhd sehr ni teq ni gaeg ver yawd kawq teq tuag tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Awg yand u ve khuhn Yer ber dehd ve yad par ni ghad he lehq awr ye i hehd teq pa Yer suq chehd lo lag lehq awr ye boz cuhx lar a kor pi lehq yawd geh ted ceng lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yer suq yad mid u ve haq na lehq koz che, “Nawg a thoq he gad lehq le,” lehd koz vid che te yand, “Nawg ved muhd mig awg khuhn ngag ved yad par che ve ni ghad haq nawg ved laq yaq awr pax awr te ghad he lehq laq vehr awr pax awr te ghad a cehax mi vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yer suq i hehd haq koz vid che, “Nig hehd a thoq lawg chehd che haq nig hehd maq sir. Ngag gha dawg tug kawz haq nig hehd dawg gha hawg la,” lehd koz na ngawx che te yand, “Dawg gha hawg,” lehz i hehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yer suq i hehd haq koz vid che, “Ngag ved kawz haq nig mag gha dawg cehg mag tug yaog. Kheh ma khuhd a sug ngag ved laq vehr laq yaq awr mi tug vawr, ngag pehar tug a khawag mad cawg hawg. Ngag ved Awr pa i hehd awg pun ghu teh vid lar che chaw teq pa lehax gha mi tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Awg lawn u ve haq awg kag awr ve cuh yad teq chi ghad gha kad che te yand, awg vix awg nax u ve ni ghad haq i hehd nez nag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kheh te lehq, Yer suq i hehd teq pa awg gha lia haq saw kug veha lehq koz vid che, “Bid saz a naz chaw ve jawd mawd teq pa awr lehr i hehd muhd mig yad haq uq penr lehq i hehd ve awg hox awg nax teq pa liz muhd mig yad teq pa awg thag lo kand pax haq yug lehq bax te nex te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kheh ma khuhd, nig hehd teq pa awg khuhn vawr che kheh maq gha te hawg. Nig hehd teq pa awg khuhn chaw ir phehq gad che chaw a sug te ghad lehd ma koz, yawd nig hehd ve awg ceg gha te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nig hehd awg khuhn ve chaw awg hox te gad che chaw a sug te ghad lehd ma koz, nig hehd haq su vig yug lar che awg ceg te ghad heh gha phehq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Awg lawn ghod ver, chaw yad ve Yad phu heh te lehq su yawd awg pun kanx te vid tug lag che ma hez. Yawd vawr su awg pun kanx te tug lag lehq chaw kha peh vad haq pong vid tug, yawd ved a saq tand vid tug awg pun lag che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yer suq he lehq yawd ved awg laq ghuhd teq pa Yer riq khod med khuhn tuhz veh tod-ag huh, chaw awg mor nux i hehd khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Awg yand u ve haq yaq kaw jad huh mi chehd che mehz cox var ni ghad awr lehr Yer suq ix mag pad huh phanr veh tod che haq gha kad che te yand, “Dar viq ve Yad phu Jawd mawd-og, ngag nid-ag haq a cehax har kax laoq,” lehd koz huh kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Chaw mor nux ix mag haq, “Taq chuhax chehd-oq,” lehd koz ga ded chehd liz ix mag awr lehr, “Dar viq ve Yad phu Jawd mawd-og, ngag nid-ag haq a cehax har kax laoq,” lehd koz lex lehq hax ceh nux maz kawq huh kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kheh te lehq Yer suq jehd lehq ix mag haq kug veha lehq koz vid che, “Nig mag haq ngag a thoq tea vid gad lehq le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kheh te lehq ix mag koz che, “Jawd mawd-og, ngag nid-ag ve mehz sir mawg tug tea vid gad che yaog,” lehz Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kheh te lehq Yer suq ix mag haq har kax lehq ix mag ved mehz sir haq vad vid che yaog. Teq pear lehax ix mag ved mehz sir mawg vehr lehq ix mag liz yawd khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yer suq he lehq yawd ved awg laq ghuhd i hehd teq pa Yer ruq sar lehnr med pad lo gaeg lehq Sar lonr keh thang huh chehd che Ber phar ger khaz lo gaeg che te yand Yer suq yawd ved awg laq ghuhd ni ghad haq kae pe lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Nig mag mehz khuhd suhr huh cawg che khaz u ve khuhn tanr gehe ver, pix lar awr ye ma he lehq awg yad nehax pheh teh lar che haq gha mawg tug yaog. Niq kheh kheha phi lehq ngag chehd lo seh veha laoq. ");
INSERT INTO lhi_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Chaw te ghad ghad nig mag haq te ceng ceng koz na ver, ‘Jawd mawd lor che yaog,’ lehd kawq koz vid-oq. Yawd har naq pehar vehr tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Awg lawn che ve awr lehr, Ghig sa ve cuh kar var koz lar che tawd khuhd heh phehaq vid tug awg pun te che yaog. Yawd koz lar che, ");
INSERT INTO lhi_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Yid onr ve med yad teq pa haq che kheh koz vid-oq. ‘Ngawx lor, nig hehd ve Jawd mawd awr lehr, ni ma nud nehg che khuhn pix lar ma he lehq awg yad nehax haq cind lehq nig hehd chehd lo lag chehd che yaog,’” lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Awg laq ghuhd u ve ni ghad khaz u ve khuhn kae lehq Yer suq ix mag haq cuh che heh ca te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ix mag awr lehr pix lar awr ye ma he lehq awg yad nehax haq seh vea lehq pix lar u ve awg thag huh a poq kuhz kaq vid peg lehq Yer suq taz cind vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Yawd haq awg mig awg phond pid che awg hez te tug, chaw awg mor awg cud nux awg khuhn chaw ted pehg pehar ver a sug yawd ved a poq yug lehq yaq kaw khuhn khawd vid lehq ted pehg pehar ver suhz pir ca chuh veha lehq yaq kaw khuhn khawd vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yer suq ghud med awr he lehq kuhr tehx nuhr hez tod che chaw mor nux teq pa kaod kug lehq koz che, “Dar viq ve Yad phu haq Ho sa na phehq vid-oq. Jawd mawd Ghig sa ve awg meh khuhn lag che chaw haq awg bon ir vid-oq. Muhd nuh maq lo chehd che ir jad muh jad che Ghig sa haq liz Ho sa na phehq vid-oq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yer suq Yer ruq sar lehnr med khuhn gehe che te yand, med yad teq pa awg gha lia phoz koz daq che diz vad-ag he lehq, “Che ve phad che a suawg le,” lehd koz na daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Chaw che ve phad awr lehr, Gar liq lehd muhd mig Nar sar rehq med lo lag che Ghig sa ve cuh kar var Yer suq yaog,” lehz chaw awg mor nux koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yer suq bon yehg nux awg vaw khuhn gehe lehq u huh med nged huhd daq pa daq chehd che chaw awg gha lia haq saw ghaq kog lehq phu pa chehd che teh cuh he lehq a pia kar mi huhd chehd che mi khuhd teq pa haq liz yawd saw phuhz chid bag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","“‘Ngag ved yehg haq bon lawg kig yehg,’ lehd koz lehq Liq phu khuhn buhq lar liz nig hehd teq pa awr lehr yehg che ve haq chaw khuhd chehd kig yehg yug te vehr che law,” lehz Yer suq i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mehz cox var teq pa he lehq khi lug laq lug che chaw teq pa bon yehg nux khuhn Yer suq chehd lo lag lehq yawd i hehd teq pa haq ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Paw khod nux he lehq liq buhq var teq pa awr lehr, Yer suq te che and tug teq pa he lehq bon yehg khuhn chaw yad nehax teq pa, “Dar viq ve Yad phu haq Ho sa na phehq vid-oq,” lehd koz kug chehd che haq i hehd gha mawg che te yand, i hehd nez nag jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","“Chaw yad nehax che ve teq pa khawd-ehg kheh koz kug chehd che haq, nawg kad chehd-aq la,” lehd koz Yer suq haq na ngawx che te yand, Yer suq kawq koz che, “Ngag kad chehd che yaog. ‘Nawg awg pun chid muh che tawd khuhd chaw yad nehax teq pa he lehq cux pehz nux chehd che yad nehax teq pa ve mawg kaw khuhn tuhaz vid tug nawg te vid lar peor,’ lehd koz lehq Liq phu khuhn buhq lar che haq nig hehd teq pa maq gha ghawn jaw lehq la,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kheh te peg lehq Yer suq awr lehr i hehd teq pa haq phaz daq lar haz lehq med u ve khuhn tuhez lehq Ber tar niq khaz khuhn ca hax-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Muhd thid-ag lehq muhd sawx ted naq Yer suq med khuhn koeq tod che awg yand khuhn yawd awr meq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Awg yand u ve khuhn yaq kaw jad huh cuhz chehd che a kud cehg ted cehg haq yawd gha mawg lehq ca ngawx-eg che te yand awg sir mad nuhq lehq awg phaq lehax cawg che haq yawd gha mawg che yaog. Kheh te lehq Yer suq a kud cehg haq koz vid che, “Yaq ni khaz nuhr ver nawg awg sir te pawz-a liz maq gha kawq nuhq hawg,” lehd koz vid che te yand, teq pear lehax awg nuhr tiq awg god khehz te lehq suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Awg laq ghuhd teq pa u ve haq gha mawg che te yand, “A kud cehg che ve a thoq te lehq teq pear lehax nuhr lehq god suh vehr che lehq nar,” lehd koz lehq Yer suq haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yer suq kawq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq. Nig hehd yonr che ni ma thuhd phuhz nuhg phuhz maq te ver, a kud cehg che ve haq ngag te gha cheaq keh liz nig hehd teq pa vawr kawq te gha nuhr, keh che ve ted dig haq, ‘Jiz kae lehq lad chuhd ghig khuhn gehe lor,’ lehd koz vid ver, koz vid che heh te vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nig hehd yonr che khuhn bon lawg ver, nig hehd kha lawg che awg ceng teq pa haq Ghig sa tea tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yer suq bon yehg nux awg khuhn gehe lehq mar vid chehd-ag huh paw khod nux teq pa he lehq muhd mig yad ve awg hox chaw mawd teq pa yawd chehd lo lag lehq, “Nawg khar lo kand pax gha lehq che kheh te cheawg le. Kand pax u ve a sug nawg haq pehar cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yer suq kawq koz vid che, “Ngag liz nig hehd haq tawd te khuhd na ngawx sar. Nig hehd yaw khuhq ax gha ver, ngag khar lo kand pax gha lehq che kheh te che awg lawn nig hehd haq koz ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yod hanr yawd a kaz tur vid tug kand pax a sug pid lar cheawg le. Ghig sa geh la, ma hez ver chaw yad geh la,” lehd i hehd haq na ngawx che yaog. I hehd teq pa phoz jehg daq lehq koz che, “‘Muhd nuh maq lo gha cheawg,’ lehz a nig koz ver, ‘A thoq te lehq nig hehd yawd haq maq yonr cheawg le,’ lehz yawd a nig haq kawq koz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","‘Chaw yad teq pa geh gha cheawg,’ lehd koz ver, muhd mig yad teq pa haq kuhz tug cawg che yaog. Awg lawn ghod ver Yod hanr awr lehr Ghig sa ve cuh kar var te ghad yaog lehz chaw kheh ma ve yonr chehd che yaog,” lehz i hehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kheh te cheaq te lehq, “Ngag hehd maq sir,” lehz i hehd teq pa Yer suq haq kawq koz vid che yaog. Yer suq i hehd haq kawq koz vid che, “Kheh te ver, ngag liz khar lo kand pax gha lehq che kheh te che awg ceng teq pa ngag nig hehd haq ma koz ax hawg. ");
INSERT INTO lhi_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Awg lawn che ve haq nig hehd khawd-ehg kheh duhd chehd-aq le. Chaw te ghad yawd ved yad ni ghad cawg che yaog. Awg vix var te ghad haq yawd koz vid che, ‘Yad par-og, yaq ni a pa ve a pehx med kho khuhn kanx ca teoq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Ngag maq kae-og,’ lehz awg yad par u ve kawq koz vid che yaog. Kheh ma khuhd awg khaz nuhr maq muh tand yawd ni ma kawq pa vehr lehq kawq kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kheh te lehq awg nax var te ghad geh liz awr pa kawq kae lehq koz vid che, ‘Yad par-og, yaq ni a pa ve a pehx med kho khuhn kanx ca teoq,’ lehd koz vid che yaog. Kheh te lehq awg yad par che ve kawq koz che, ‘Ngar paog, ngag kae tug yaog,’ lehz awg yad par koz vid che yaog. Kheh ma khuhd, yawd mad kawq kae. ");
INSERT INTO lhi_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Yad par u ve ni ghad a sug te ghad vawr, awr pa ve a lor haq te che law le,” lehd i hehd haq na ngawx che te yand, “Awg vix var te ghad yaog,” lehz i hehd Yer suq haq kawq yaw khuhq vid che yaog. Kheh te lehq Yer suq i hehd haq koz vid che, “Ngag nig hehd haq awg cehg mag koz ax laq, awg khawnr ghawz var he lehq meh mar lanx teq pa awr lehr, nig hehd teq pa haq keh awg kawd Ghig sa ve muhd mig awg khuhn gha gehe tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Awg lawn ghod ver, Yod hanr awr lehr thed che cawd che yaq kaw haq tod lag lehq nig hehd geh lag che liz nig hehd maq yonr. Kheh ma khuhd, awg khawnr ghawz var he lehq meh mar lanx teq pa vawr, i hehd Yod hanr haq yonr che yaog. Nig hehd awr lehr che ve teq pa haq gha mawg peg liz vend bax haq ma duhd phuhz lehq Yod hanr haq maq yonr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tawd par hax che ve ted mag haq kha sehax na ngawx ser. Yehg sehr phad te ghad awr lehr, a pehx med kho ted mag te peg lehq kho liz kha sehax caw ko lar lehq a pehx med ghig nex kig liz kha nehax dud lehq te lar che yaog. Kheh te lehq, muhd-aq lo taz law kig liz te peg lehq kho u ve su kho te cad var haq ngar vid lar haz lehq, yawd vawr awg bag muhd mig lo veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","A pehx med sir meh vehr lehq awg sir sax yand gaeg che te yand, kho sehr phad u ve yawd ved awg ceg var teq pa haq a pehx med sir sax lehq pehg daq tug, kho ngar vid lar che teq pa chehd lo kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kheh ma khuhd, kho ngar te cad var u ve teq pa awr lehr awg sehr phad ve awg ceg var u ve teq pa haq yug lehq, te ghad haq vawr ga phuhz dawz lehq, te ghad haq vawr dawz vehr lehq, te ghad haq vawr huhx meh ga bag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Awg khaz nuhr te pawz gaeg lehq kho sehr phad yawd ved awg ceg var teq pa haq awg kawd maq te pawz kae pe cheaq keh, mad chawa kawq kae pe che yaog. Kheh liz, kho ngar te cad var u ve teq pa awr lehr i hehd haq liz awg kawd maq thad ve teq pa haq te vid che heh, kawq te vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Awg leh med te pawz gaeg lehq kho sehr phad, ‘Ngag ved awg yad par haq, i hehd yawz yan tug yaog,’ lehz koz lehq yawd haq i hehd chehd lo kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kheh ma khuhd, kho ngar te var teq pa yad par u ve haq gha mawg che te yand, ‘Chaw che ve awr lehr awg sinx gha awg ka gha sehr phad te ghad yaog. Lar-og, yawd haq dawz vehr lehq yawd ved awg sinx a nig yuag veg,’ lehz i hehd teq pa koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kheh te lehq kho ngar te var u ve teq pa kho sehr phad ve awg yad par haq yug lehq kho awg bag phawd awr lo yug chid bag pe lehq dawz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Kheh te lehq kho sehr phad lag che te yand, kho ngar te var u ve teq pa haq yawd khawd-ehg kheh te vid tuawg le,” lehz Yer suq i hehd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","I hehd teq pa Yer suq haq kawq koz vid che, “Haeg jad che chaw u ve teq pa haq hehnd jad che awg khuhn te lehq gha dawz vehr tug yaog. A pehx med sir meh vehr ver awg sehr phad haq kawq pehg khuhq vid gha che chaw teq pa haq kawq ngar vid,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yer suq i hehd haq koz vid che, “‘Yehg kawx par teq pa chid bag lar che huhx meh dig vawr, a yed ir jad che, awg cir huh tanr kawx lar che huhx meh dig phehq vehr che yaog. Awg ceng che ve awr lehr, Jawd mawd Ghig sa te lar che kanx te lehq, a nig mehz khuhd suhr and tug awg ceng phehq vehr che yaog,’ lehz Liq phu awg khuhn buhq lar che haq nig hehd maq gha ghawn jaw lehq la. ");
INSERT INTO lhi_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kheh te lehq ngag nig hehd haq koz ax laq. Ghig sa ve muhd mig awr lehr nig hehd awg khuhn yug tuhz lehq Ghig sa ve a lor haq te lehq awg sir nuhq che chaw teq pa haq kawq pid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Huhx meh dig u ve thag huh kuhd kaq che chaw teq pa awr lehr awg ghuhd awg mi tehz te veh tug yaog. Kheh te lehq chaw a sug te ghad thag huh lehd ma koz, huhx meh dig u ve che kaq ver, chaw u ve awr lehr awg mi tehz veh tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Yawd koz chehd che tawd par hax u ve teq pa haq paw khod nux teq pa he lehq Phar rir sehd teq pa gha kad che te yand, yawd i hehd awg lawn koz chehd che law lehz i hehd gha sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","I hehd teq pa Yer suq haq pheh yug gad liz, chaw mor nux haq kuhz che yaog. Awg lawn ghod ver Yer suq awr lehr Ghig sa ve cuh kar var phehq che yaog lehz i hehd teq pa yonr chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Kheh te lehq Yer suq i hehd haq tawd par hax te pawz kawq te mar vid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ghig sa ve muhd mig awr lehr yawd ved yad par awg pun khehx cad tug ghu lar che jawd mawd te ghad haq sur che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Khehx ca cad-ag vid tug kug lar che chaw teq pa haq, ‘Cad laoq,’ lehd koz ca kug vid tug, yawd ved awg ceg teq pa haq yawd kae pe liz, chaw u ve teq pa mad lag. ");
INSERT INTO lhi_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kheh liz, te pawz awg kag awr ve awg ceg teq pa haq jawd mawd u ve te pawz kawq kae pe lehq, ‘“Cad tug teq pa haq kha nehax ghu lar peor. Ngag ved nud haq dawz lehq nud yad nehax awg phoq chuhd te che haq liz dawz lehq saw te lar peor. Cad laoq,” lehd koz lehq kug lar che chaw teq pa haq ca koz vid-eq,’ lehz yawd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kheh ma khuhd, awg lawn u ve haq i hehd teq chaweh ma duhd ngawx lehq te ghad vawr ha khuhn veh lehq te ghad vawr tad kag ca te veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Awg kag awr ve chaw teq pa awr lehr, yawd ved awg ceg teq pa haq yug pheh lar phuhz dawz peg lehq dawz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jawd mawd nez nag jad lehq yawd ved maq yad teq pa haq kae pe lehq yawd ved awg ceg haq dawz vehr che chaw teq pa haq saw dawz vehr lehq i hehd ve med haq liz a mir saw tox ke vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kheh te lehq jawd mawd yawd ved awg ceg var teq pa haq yawd koz vid che, ‘Khehx cad tug haq ngag kha sehax ghu lar peor. Kheh ma khuhd khehx cad kig lo lag tug ngag kug lar che chaw che ve teq pa awr lehr lag maq kenr. ");
INSERT INTO lhi_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Kheh te cheaq te lehq, yaq kaw tad lonx khad teq pa lo kae lehq chaw kha mawg che teq pa haq khehx cad kig lo saw ca kug veha laoq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kheh te lehq awg ceg var u ve teq pa yaq kaw tad lonx nux maz teq pa lo kae lehq kha mawg che chaw awg gha lia, mad daq che chaw lehd ma koz, daq che chaw lehd ma koz, saw ca kug veha lehq khehx cad kig lo lag che chaw kha peh vad-ag phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Khehx cad-ag che chaw teq pa haq jawd mawd ca geh ngawx-ag che te yand, haw khaz var te ghad yawd khehx cad kig lo lag che haq maq hawr che beg ke veq tod che chaw te ghad haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kheh te lehq, jawd mawd koz vid che, ‘Awg chawd-og, khehx cad kig lo lag tug beg ke liz mad veq lehq khawd-ehg kheh te khehx cad kig lo lag gag cheawg le,’ lehd koz vid che te yand, haw khaz var u ve teq chaweh liz kawq koz vid maq gha. ");
INSERT INTO lhi_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kheh te lehq awg yand u ve khuhn jawd mawd awg ceg teq pa haq koz vid che, ‘Yawd ved khi kud laq kuhr haq yug tehr chuhq lehq awg bag lo awg naz tud teag lo yug chid bag peoq. U huh kha chehd che chaw teq pa awr lehr cig geq yuhz cheq lar lehq gha kug huhg paz huhg chehd tug yaog,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Awg lawn ghod ver kug yug lar che chaw kha peh vad-ag cawg liz, lez yug che chaw teq pa vawr, a cehax lehax cawg che yaog,” lehz Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Awg yand u ve khuhn Phar rir sehd teq pa tuhez lehq Yer suq tawd yaw yaq cuh vid tug awg khad ca lehq jehg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Kheh te lehq, i hehd ve awg laq ghuhd teq pa he lehq jawd mawd Her roq ve chaw teq pa haq Yer suq chehd lo kae pe che yaog. I hehd kae lehq koz che, “Sar lar-og, nawg awr lehr thed che cawd che chaw phehq lehq Ghig sa ve yaq kaw haq thed-e ghad mar vid che yaog. Nawg chaw te ghad-eg haq liz ma kuhz lehq su ved mehz khuhd haq liz maq ngawx che haq ngag hehd sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kheh te cheaq te lehq, nawg khawd-ehg kheh duhd lar che ngag hehd haq a cehax koz ax laoq. Jawd mawd nux Kehd sar haq awg khawnr ke vid cawd hawg la. Maq ke vid cawd hawg la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kheh ma khuhd, i hehd ve ni ma kuhq che haq Yer suq sir vehr lehq, “Chaw her ka var teq paog, nig hehd a thoq te lehq ngag haq lawd ngawx cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Awg khawnr ke chehd che phu ted thehq yug veha ngag a cehax ngawx-ag,” lehd koz vid lehq i hehd yawd haq phu ted thehq yug maw vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yer suq i hehd haq koz vid che, “A sug ved awg han he lehq a sug ved awg meh cawg law le,” lehd koz na ngawx che te yand, ");
INSERT INTO lhi_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Jawd mawd nux Kehd sar ve yaog,” lehz i hehd kawq koz vid che yaog. Kheh te lehq Yer suq i hehd haq kawq koz vid che, “Kheh te ver jawd mawd nux Kehd sar ve med nged ver, jawd mawd nux Kehd sar haq kawq khuhq vid-oq. Ghig sa ve med nged ver, Ghig sa haq khuhq vid-oq.” ");
INSERT INTO lhi_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tawd khuhd u ve haq i hehd gha kad che te yand, and jad vehr lehq i hehd teh lar haz lehq kawq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kawq teq tuag che mad cawg hawg lehd koz che Sar duq kehd chaw teq pa u ve teq ni khuhn Yer suq geh ca na-ag lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Sar lar-og, Mod ser koz lar che, ‘Haw khaz var te ghad yad mad cawg ser lehq suh vehr ver, awg nax var yawd ved awg mid ma haq kawq he lehq awg vix var awg pun awg ceng awg khad gha cawg vid che yaog,’ lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Te pawz thad huh ngag hehd geh ve awg vix awg nax suhr ghad cawg che yaog. Awg vix var nux u ve te ghad awg mid ma he lehq yad mad cawg ser tand, suh vehr lehq awg mid ma u ve awg nax var haq teh vid lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","U ve haq kha sur suar ni ghad te ghad, seh ghad te ghad he lehq suhr ghad kha gag che ve heh lehax te lar haz lehq saw suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Awg khaz nuhr gaeg lehq yad mid u ve liz suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kheh te lehq, kawq teq tuag che te yand, yad mid ma u ve te ghad a sug mid ma gha te lawg le. Awg lawn ghod ver yad mid ma u ve haw khaz u ve teq pa awg gha lia haq he jaw peg che yaog,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yer suq i hehd haq kawq koz vid che, “Liq phu he lehq Ghig sa ve kand pax haq nig hehd teq pa na maq gha cheaq te lehq, nig hehd teq pa duhd yaq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Awg lawn ghod ver kawq teq tuag che te yand, awg phad mawd awg mid ma he daq che lehd ma koz, laq kuhr cax vid che lehd ma koz, maq te. Muhd nuh maq cuh yad heh saw phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chaw suh kig lo kawq teq tuag che awg lawn Ghig sa nig hehd haq koz ax lar che haq nig hehd maq gha ghawn jaw la. ");
INSERT INTO lhi_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ngag vawr Ar brar hanr ve Ghig sa, Id caq ve Ghig sa he lehq Yar koq ve Ghig sa phehq che yaog,’ lehz yawd koz lar che yaog. Yawd awr lehr suh che chaw teq pa ve Ghig sa phehq che ma hez. Teq chehd che chaw teq pa ve Ghig sa phehq che yaog,” lehz Yer suq i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tawd khuhd u ve haq chaw awg mor nux gha kad che te yand, yawd mar vid che tawd khuhd u ve haq i hehd teq pa and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sar duq kehd teq pa Yer suq haq tawd kawq yaw khuhq maq gha che awg lawn Phar rir sehd teq pa gha kad che te yand i hehd teq geha phoz lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","I hehd ve awg mor awg khuhn awg lid tawd khuhd sir jad che te ghad Yer suq haq lawnd ngawx che khuhn che kheh koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Sar lar-og, awg lid tawd khuhd teq pa awg khuhn khar ve ted mag vawr awg lid tawd khuhd awg gha lia khuhn suaq keh ir jad cheawg le,” lehd koz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yer suq kawq koz vid che, “‘Nawg ved ni ma awg gha lia, nawg ved co ha awg gha lia he lehq nawg ved duhd khad awg gha lia nawg ved Jawd mawd Ghig sa haq gha haq che yaog.’ ");
INSERT INTO lhi_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Che ve awr lehr, awg lid tawd khuhd awg gha lia haq keh ir jad che awg lid tawd khuhd he lehq awg kawd maq ve awg lid tawd khuhd ted mag phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ni khuhd te khuhd liz che ve haq sur daq che yaog. Nawg awg ton haq haq che heh te lehq nawg pad nawg ki huh chehd che chaw teq pa haq gha haq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Awg lid tawd khuhd awg gha lia he lehq Ghig sa ve cuh kar var teq pa ve tawd khuhd kha buhq lar che awg gha lia cuhx kig tawd khuhd che ve nid mag awg khuhn lo lehax saw chehd chehd che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Phar rir sehd teq pa phawng daq chehd-ag huh, Yer suq i hehd teq pa haq na lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Khreq awg lawn haq nig hehd teq pa khawd-ehg kheh duhd cheawg le. Yawd a sug ved yad phu phehq cheawg le,” lehd koz na ngawx che yaog. “Yawd awr lehr Dar viq ve yad phu phehq che yaog,” lehd I hehd yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yer suq kawq koz che, “Kheh te ver Awg ha phu Dar viq haq duhd pawnr vid lehq a thoq te lehq yawd haq, ‘Jawd mawd,’ lehd koz cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Awg lawn ghod ver Dar viq koz che, ‘Jawd mawd Ghig sa vawr ngag ved Jawd mawd haq koz vid che, “Nawg ved cand par teq pa haq nawg ved khi ho awg huhx lo ngag tar thad kha gag ngag ved laq yaq awr pax awr mi lar-oq,” lehd koz lar che yaog.’ ");
INSERT INTO lhi_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Dar viq yawd haq, ‘Jawd mawd,’ lehd koz ver, yawd awr lehr khawd-ehg kheh te lehq Dar viq ve yad phehq cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Chaw te ghad-eg yawd haq tawd teq per-a liz kawq yaw khuhq vid maq gha lehq u ve teq ni haq tanr lehq su te ghad-eg liz yawd haq tawd kawq na ngawx maq pir vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Awg yand u ve khuhn Yer suq chaw awg mor nux he lehq yawd ved awg laq ghuhd teq pa haq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Liq buhq var teq pa he lehq Phar rir sehd teq pa vawr Mod ser ve awg lid tawd khuhd mar tug a khawag cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kheh te cheaq te lehq, i hehd teq pa nig hehd haq kha mar che awg ceng teq pa haq na yug lehq teog. Kheh ma khuhd, i hehd te che heh taq te. Awg lawn ghod ver i hehd koz mar che vawr ted ceng te che vawr ted ceng te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Huhd jad che med nged awg veg nux su haq cuhx puhr vid che heh te lehq i hehd chaw yad teq pa haq awg lid hehnd jad lehq yehd har jad che te teh vid che yaog. Kheh te lar, i hehd ve awg ton vawr laq nuh med nehax ted mag nehax liz maq ga chid vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","I hehd kha te che kanx awg ceng gha lia chaw yad teq pa ngawx mawg vid tug lehax te che yaog. Liq phu awg tawn nehax doz puhd kig liz awg nux maz te lehq a poq awg jog med liz awg yehg du nux te deh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","I hehd vawr thi cad thi dawg kig lo liz awg mig awg phond cawg che mi kig haq mi lehq bon lawg kig khuhn liz su mehz khuhd suhr lo awg mig awg phond cawg kig lo ca mi gad jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","I hehd teq pa awr lehr, kax khuhn lo su i hehd haq tar ir yawz yan vid gad che he lehq su i hehd haq, ‘Sar lar,’ lehd koz ax che haq, i hehd he gad jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Su nig hehd haq, ‘Sar lar,’ lehd taq gha koz vid. Awg lawn ghod ver nig hehd Sar lar te ghad lehax cawg lehq nig hehd teq pa awr lehr a vix a nax lehax yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mig gig khod-aq lo te ghad-eg haq liz, ‘Awr pa,’ lehd ta koz. Awg lawn ghod ver nig hehd muhd nuh maq lo chehd che Awr pa te ghad lehax cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Kheh te lehq su nig hehd haq Seh kae sehr phad lehd taq gha koz vid. Awg lawn ghod ver Khreq te ghad lehax nig hehd haq seh kae sehr phad phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nig hehd awg khuhn ve suaq keh ir jad che chaw te ghad awr lehr, su ved awg ceg gha te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","A sug yawd awg ton haq tar ir che chaw a sug te ghad lehd ma koz, tar i che haq gha khanr tug yaog. A sug yawd awg ton haq tar i che chaw a sug te ghad lehd ma koz, tar ir che haq gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Liq buhq var he lehq Phar rir sehd, chaw her ka var teq paog, nig hehd gha duhd har jad tug yaog. Awg lawn ghod ver, chaw yad teq pa muhd nuh maq muhd mig awg khuhn gehe tug haq, nig hehd ghaz mir hoz tehr lar che yaog. Nig hehd liz maq gehe he lar lehq, gehe gad che chaw teq pa haq liz nig hehd tawr chuhd lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Liq buhq var he lehq Phar rir sehd, chaw her ka var teq paog, nig hehd gha duhd har jad tug yaog. Awg lawn ghod ver, chaw te ghad nig hehd ve awg laq ghuhd phehaq vid tug, mig gig thag lo he lehq lad chuhd ghig thag lo veaq ted kag peg ted kag ca kaod mar che yaog. Chaw te ghad nig hehd ve awg laq ghuhd phehq vehr che te yand, nig hehd awr lehr yawd haq muhd naz hoq khuhn nig hehd haq keh nig pun kheh taw maq gha khanr tug te vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Yaq kaw mar sehr phad mehz cox var teq paog, nig hehd gha duhd har jad tug yaog. Nig hehd mar lar che, ‘Chaw te ghad ghad bon yehg nux haq cud lehq khanr lar ver, yawd khanr lar che heh maq te liz teq chaweh ma hez hawg. Kheh ma khuhd, bon yehg nux ve si haq cud lehq khanr lar ver, yawd khanr lar che heh gha te che yaog,’ lehz nig hehd koz mar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mehz cox che chaw kar var-og, khar ve ted ceng vawr a yed a cehax ir hawg le. Si vawr ir cheawg la. Ma hez ver si haq daq vid ja vid gha che bon yehg nux vawr ir cheawg la. ");
INSERT INTO lhi_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nig hehd koz che, ‘Chaw te ghad ghad tand kig haq cud lehq khanr lar che ver, yawd khanr lar che heh maq te liz teq chaweh ma hez hawg. Kheh ma khuhd, tand kig awg thag lo cawg che tand tug haq cud lehq khanr lar che ver, yawd khanr lar che heh gha te che yaog,’ lehz nig hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mehz cox var teq paog, khar ve ted ceng vawr a yed ir cheawg le. Tand tug vawr ir cheawg la. Ma hez ver, tand tug haq daq vid ja vid gha che tand kig vawr ir cheawg la. ");
INSERT INTO lhi_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kheh te cheaq te lehq tand kig haq cud lehq khanr lar che chaw teq pa awr lehr, tand kig he lehq u ve awg thag huh kha cawg chehd che teq pa haq saw cud lehq khanr lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Chaw khar ve te ghad lehd ma koz, bon yehg nux haq cud lehq khanr lar ver, bon yehg nux he lehq u ve khuhn chehd che phad haq cud lehq khanr lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Muhd nuh maq haq cud lehq khanr lar che chaw khar ve te ghad lehd ma koz, Ghig sa ve kaw jaw he lehq kaw jaw thag huh mi chehd sehr phad haq cud lehq khanr lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Liq buhq var he lehq Phar rir sehd, chaw her ka var teq paog, nig hehd gha duhd har jad tug yaog. Awg lawn ghod ver, nig hehd awr lehr, a sur, i khind he lehq muhd noer teq pa haq teq chi pun teq pun tand vid lehq awg lid tawd khuhd awg khuhn cawg che a yed ir jad che teq pa, thed-e ghad cawd-aw ghad te che, har kax vix che he lehq yonr che, che ve teq pa haq nig hehd maq te. Che ve teq pa haq liz nig hehd teq pa te cawd lehq, lex lehq awg kag awg nuz awr ve awg ceng haq liz nig hehd te cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yaq kaw mar sehr phad mehz cox var teq paog, nig hehd awr lehr, a kaz dawg tug khuhn cawg che a pix phehq tug a kaz puhd ma nehax haq che kha lar haz liz, kar lar oq teq ton maq ve haq lehd dawg ke pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Liq buhq var he lehq Phar rir sehd, chaw her ka var teq paog, nig hehd gha duhd har jad tug yaog. Awg lawn ghod ver nig hehd teq pa awr lehr, a khehd he lehq kawz khehd teq pa haq awg bag phawd awr lehax chuhd liz, awg khuhn phawd awr vawr, lawd phaq pehz ir mehz he lehq her ka yug gad che kha peh vad-ag cawg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mehz cox var Phar rir sehd teq paog, a khehd he lehq kawz khehd haq awg khuhn phawd awr awg kawd chuhd ser, u kheh te ver awg bag phawd awr liz daq kehg vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Liq buhq var he lehq Phar rir sehd, chaw her ka var teq paog, nig hehd gha duhd har jad tug yaog. Awg lawn ghod ver, nig hehd awr lehr, phux-u ghad te che gehz lar che chaw tur phuh haq sur daq che yaog. Chaw tur phuh u ve awg bag phaw awr ver pehz daq mehz te chehd liz, awg khuhn phawd awr ver, chaw ghuhd khawaz lehax he lehq awg chaq chiz te che kha peh vad-ag te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Che ve haq sur daq che yaog. Nig hehd awr lehr, awg thag phawd awr chaw yad ngawx mawg che ver, thed che cawd che chaw phehq che haq sur che yaog. Kheh ma khuhd, awg khuhn phawd awr ver, her ka che he lehq haeg che awg ceng kha peh vad-ag cawg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Liq buhq var he lehq Phar rir sehd, chaw her ka var teq paog, nig hehd gha duhd har jad tug yaog. Awg lawn ghod ver nig hehd teq pa awr lehr, Ghig sa ve cuh kar var teq pa ve tur phuh teq pa haq ghu te lehq, thed che cawd che chaw teq pa ve kawx lar che tur phuh teq pa haq ngawx sa tug te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kheh te lehq nig hehd koz che, ‘Ngag hehd teq pa a nig ved awg pux awr pi co u ve haq gha chehd cawd che heh ver, Ghig sa ve cuh kar var teq pa haq ngag hehd maq ga dawz vehr hawg,’ lehz nig hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nig hehd che kheh koz che awr lehr, Ghig sa ve cuh kar var teq pa haq dawz vehr che chaw teq pa ve awg yad awg dug phehq che yaog lehz, nig hehd a sug yawd awg ton awg lawn sax khiz khanr chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kheh te lehq, nig hehd teq pa liz nig hehd ve awg pux awr pi teq pa te che haq te peg vid tug teoq. ");
INSERT INTO lhi_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Vig haeg awg tuhq ma hehnd jad che yad teq paog, suhx jehg suhx taz che te yand nig hehd khawd-ehg kheh te ver muhd naz hoq haq pong gha tuawg le. ");
INSERT INTO lhi_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kheh te cheaq te lehq, cuh kar var, cud yiq cawg var he lehq liq buhq var teq pa haq ngag nig hehd chehd lo lag peha tug yaog. Nig hehd awr lehr ted pehg pehar haq yug dawz vehr lehq, laq kan thag huh thaq vehr tug yaog. Ted pehg pehar haq nig hehd ve bon lawg kig awg khuhn jawq lehq, te med peg te med lo nig hehd kae lehq ghaq dawz vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kheh te cheaq te lehq, thed che cawd che Ar ber laq ve awg suhr haq tanr lehq, bon yehg nux he lehq tand kig awg kar huh nig hehd dawz vehr che Bar rar khiq yad par Yar khar riq ve awg suhr thad kha gag, mig gig koar lo kha sez lar peg che thed che cawd che chaw teq pa ve awg suhr awg gha lia nig hehd haq chiag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ngag nig hehd haq awg cehg mag koz ax laq, awg ceng che ve teq pa haq te lehq Ghig sa chaw a meha teq co ve haq cir yanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yer ruq sar lehnr med-og, Yer ruq sar lehnr med-og, khar thad liz Ghig sa ve cuh kar var teq pa haq nig hehd dawz vehr lehq, nig hehd geh lag peha che chaw teq pa haq huhx meh bag vehr che yaog. Ghaz ye ma awr lehr, yawd ved awg yad teq pa haq yawd ved tawg laq huhx uh saw chehd vid gad che heh te lehq, nig hehd ve awg yad awg dug teq pa haq ngag huhx lo khar ni pawz phoz chehd vid gad liz, nawg ngag haq maq te cuh-a. ");
INSERT INTO lhi_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ngawx lor, nig hehd ve chehd kig awr lehr, awg gawg cux yen ghad tor ghad veh tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kheh te cheaq te lehq, ngag nig hehd haq koz ax laq, ‘Jawd mawd Ghig sa ve awg meh khuhn lag che chaw te ghad haq awg bon ir vid-oq,’ lehz nig hehd ma koz che kheh ceh, nig hehd ngag haq maq gha kawq mawg hawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yer suq bon yehg nux khuhn tuhz veh tod che awg yand khuhn yawd ved awg laq ghuhd teq pa lag lehq, bon yehg nux awg vaw khuhn ve yehg teq pa yawd haq bez mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yer suq i hehd haq koz vid che, “Yehg che ve teq pa haq nig hehd mawg chehd-aq la. Ngag nig hehd haq awg cehg mag koz ax laq, yehg che ve teq pa awr lehr, huhx meh ted dig thag huh ted dig mad cawg vehr thad kha gag su te lug tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yer suq Sar lonr keh thag huh mi chehd che awg yand khuhn, yawd ved awg laq ghuhd teq pa lehax yawd chehd lo lag lehq, “Awg ceng che ve teq pa khar thad phehaq tug le. Nawg kawq yaq tug he lehq mig gig che ve awg yand leh tug awg hez khawd-ehg kheh phehaq tug awg le. Ngag hehd haq a cehax koz ax laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yer suq i hehd haq kawq koz vid che, “Chaw te ghad-eg liz nig hehd haq maq gha her ka yug tug, sa tiq taoq. ");
INSERT INTO lhi_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Awg lawn ghod ver, chaw kha peh vad-ag ngag ved awg meh haq ca uhx lar lehq, ‘Ngag awr lehr Khreq yaog,’ lehd koz lehq, chaw kha peh haq ca kaod her ka lehq ca beg yug tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Maq bawz che he lehq bawz daq lehd te chehd che awg khuhd haq nig hehd gha kad tug yaog. Kheh liz, nig hehd ta kuhz. Awg lawn ghod ver, awg ceng che ve teq pa awg cehg mag phehaq liz, mig gig ve a saq awg leh med mad gag ser hawg. ");
INSERT INTO lhi_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Chaw ceng ted ceng he lehq ted ceng, muhd mig te pez he lehq te pez yaq daq jiz daq tug yaog. Meq che kaz che he lehq mig hiz che teq pa ted kag peg ted kag lo phehaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Awg ceng che ve teq pa awr lehr, yad mid yad paw tug ux peg tanr nag che haq sur che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Awg yand u ve khuhn, su nig hehd haq pheh ve lehq du deh lehq, dawz vehr tug yaog. Awg lawn ghod ver, nig hehd ngag ved chaw phehq cheaq te lehq chaw ceng awg gha lia nig hehd haq ngawx bawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kheh te lehq, awg yand u ve haq chaw mad awr ve yonr che ted ceng haq chid bag vehr tug yaog. Kheh te lehq, te ghad he lehq te ghad kawq phuhz daq lehq cand daq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma hez hez che cuh kar var teq pa liz kha peh vad-ag tuhaz lehq, chaw kha peh haq ca kaod her ka lehq hax ceh ca beg yug tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Awg lawn ghod ver, haeg che awg ceng cawg mad-ag cheaq te lehq, chaw mad awr ve haq pehnd che ted ceng yawnd vehr pehz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kheh ma khuhd, awg leh med kha gag yeg chehd che chaw teq pa awr lehr, thaer khuhq che haq gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Chaw ceng awg gha lia Ghig sa ve muhd mig awg lawn gha kad vid tug awg pun, ha lehg che bon khuhd che ve mig gig khod-aq awg kag gha lia lo ca koz mar vid tug yaog. U kheh te peg ver, awg leh med gag vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kheh te lehq, liq che ve haq gha ghawn che chaw awr lehr sir-oq. Ghig sa ve cuh kar var Dar yer laq koz lar che heh te lehq, te lug te sez vix che chaq chiz che awg ceng awr lehr, daq kehg che chehd kig khuhn hox chehd che haq nig hehd gha mawg che te yand, ");
INSERT INTO lhi_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yud daq muhd mig khuhn chehd che chaw teq pa haq kehaq lo phaw taez vid. ");
INSERT INTO lhi_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yehg thag lo chehd che chaw a sug yawd ved yehg khuhn med nged ca geh yug tug taq yaeq. ");
INSERT INTO lhi_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ha khuhn chehd che chaw teq pa liz, a sug yawd ved beg ke veq kad taq ca kawq yug tod. ");
INSERT INTO lhi_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Awg ni awg yand u ve haq gaeg ver, yad mid yad hu chehd che he lehq yad nehax cux pehz nux chehd che chaw teq pa awr lehr, phehq bawg jad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nig hehd gha phawe tug awg yand u ve awr lehr, muhd kaz che awg yand he lehq Sa ba to awg ni ve awg yand haq maq gha cawd daq vid tug bon lawg-oq. ");
INSERT INTO lhi_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Awg lawn ghod ver, mig gig haq tanr te phanr che teq ni haq tanr lehq yaq ni kha gag mad phehaq jaw ser lehq, che ve khaz nuhr liz mad kawq phehaq tug, tuq jad khanr jad che ted ceng awr lehr, u huh phehaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Awg yand u ve mad yug ngeh vid ver, chaw te ghad-eg liz a saq gha pong kig mad cawg. Kheh ma khuhd, lez yug lar che chaw teq pa haq te lehq, awg yand u ve teq pa haq yug ngeh vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Awg yand u ve khuhn, chaw te ghad ghad lag lehq, ‘Ngawx chuhr, Khreq chuhr huh chehd chehd che yaog. Od lo chehd chehd che yaog,’ lehz nig hehd haq koz ax ver taq yonr. ");
INSERT INTO lhi_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Awg lawn ghod ver, ma hez hez che Khreq he lehq ma hez hez che cuh kar var teq pa tuhaz tug yaog. I hehd awr lehr, te gha ver lez yug lar che chaw teq pa haq liz her ka yug beg yug gha tug, ir che and tug he lehq awg hez teq pa te maw vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kha sehax tawnd lar mehr. Mad phehaq ser thad loar, ngag nig hehd haq sa tiq pehar lehq koz ax lar peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Kheh te cheaq te lehq, ‘Ngawx chuhr, Khreq heh pir lo chehd chehd che yaog,’ lehd koz liz taq kae. ‘Bawehd awg khuhn lo Khreq chehd chehd che yaog,’ lehd koz liz taq yonr. ");
INSERT INTO lhi_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Awg lawn ghod ver, muhd ni tuhz phawd awr lo muhd pehq che awr lehr, muhd ni kehg phawd awr lo pawd che heh te lehq, chaw yad ve Yad phu kawq yaq tug awr lehr, che ve heh te lehq lag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Suh chehd che awg ton khar lo cawg liz, nag beg ngaz teq pa u huh phoz lag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tuq che khanr che awg yand u ve peg vehr khaz nuhr, teq pear lehax muhd ni awg naz tud te lehq, har pa liz awg ghiz mad kawq pawd. Muhd ki sir teq pa muhd-aq lo cheag lehq, muhd nuh maq ve kand pax cawg che a yad teq pa liz hiz hiz nez nez phehq vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Awg yand u ve haq, chaw yad ve Yad phu ve awg hez muhd nuh maq lo tuhaz tug yaog. Mig gig koar lo ve chaw ceng awg gha lia paz huhg kehd huhg lehq, chaw yad ve Yad phu awr lehr, awg mig awg phond ir lehq kand pax cawg che khuhn muhd nuh maq ve mog thag lo cind lehq yaq che haq gha mawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kheh te peg ver, behd pehz hehnd mehz mez lehq yawd yawd ved muhd nuh maq cuh yad teq pa kae pe tug yaog. Kheh te lehq, muhd nuh maq cuh yad teq pa muhd uhg cir mig uhg phawd lo lez yug lar che chaw teq pa haq yug phawng daq vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","A kud cehg haq tehz mar che tawd par hax che ve haq hend yug-oq. Awg kax tuhaz lehq awg car car vehr ver, muhd god yand gag vehr tez che haq nig hehd gha sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Che ve haq su daq che yaog. Awg ceng che ve teq pa phehaq che haq nig hehd gha mawg che te yand, yawd awr lehr, yehg ghaz mir khuh pad huh lag gag vehr che haq nig hehd sir-oq. ");
INSERT INTO lhi_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ngag nig hehd haq awg cehg mag koz ax laq, chaw che ve teq coaq ve maq suh ser huh, awg ceng che ve teq pa saw phehaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Muhd nuh maq he lehq mig naz ma mehx vehr tug yaog. Kheh ma khuhd, ngag ved tawd khuhd awr lehr maq mehx vehr hawg. ");
INSERT INTO lhi_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Awg ni awg hax u ve haq chaw te ghad-eg liz maq sir. Muhd nuh maq cuh yad teq pa liz, Yad phu liz, maq sir. Awr pa te ghad lehax sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Chaw yad ve Yad phu kawq yaq tug awr, Nod ar ve awg co heh phehq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nod ar huh lawd kor khuhn gehe che teq ni thad kha gag, a kaz maq thunr ser che awg yand khuhn, i hehd awr lehr cad che dawg che, awg phad mawd awg mid ma he daq lehq laq kuhr cax che, che kheh te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A kaz thunr lag lehq i hehd haq po chid ve veh thad kha gag i hehd maq sir che heh te lehq, chaw yad ve Yad phu kawq yaq che te yand liz, che ve haq kha sur suar lag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Awg yand u ve khuhn, chaw ni ghad ha khuhn lo teq geha chehd che liz, te ghad haq sir ve lehq te ghad haq teh lar haz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Yad mid ni ghad teq geha huhx meh mawr giz chehd liz, te ghad haq sir ve lehq te ghad haq teh lar haz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kheh te cheaq te lehq, nig hehd ve Jawd mawd khar ve teq ni haq kawaq tug nig hehd maq sir cheaq te lehq kha nehax ghu hehnd lehq law laor. ");
INSERT INTO lhi_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yehg sehr phad awr lehr, chaw khuhd lag tug awg yand sir chehd heh ver, yawd ved yehg khuhn chaw khuhd maq gha gehag vid tug yawd kha nehax paog lar vehr tug yaog lehz nig hehd sir laor. ");
INSERT INTO lhi_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kheh te cheaq te lehq, nig hehd liz kha nehax ghu lar hehnd laor. Awg lawn ghod ver, nig hehd ma duhd ma gad che awg yand awg khuhn, chaw yad ve Yad phu kawq yaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kar tiq yeg lehq cud yiq cawg che awg ceg te ghad awr lehr, a suawg le. Awg sehr phad ve yehg ka yad awg khuhn awg kag awr ve awg ceg teq pa haq awg yand cawd cawd cad tug dawg tug pehg car vid tug awg pun yawd ved awg sehr phad awr lehr, awg ceg var u ve haq awg hox te cuh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Awg ceg te ghad che kheh te lehq kanx kha sehax te chehd che haq yawd ved awg sehr pha kawaq lehq gha mawg ver, awg ceg u ve awr lehr awg bon ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ngag nig hehd haq awg cehg mag koz ax laq, awg sehr phad awr lehr, yawd ved med nged jeg kor awg gha lia awg ceg var u ve haq awg hox te cuh vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kheh ma khuhd, haeg jad che awg ceg var u ve te ghad awr lehr, ‘Ngag ved jawd mawd har naq mad kawaq tag ser hawg,’ lehd duhd lehq, ");
INSERT INTO lhi_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","awg kag awg nuz awr ve awg ceg var teq pa haq dawz lehq, juhg dawg buhz che chaw teq pa geh cad chehd dawg chehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Awg ceg u ve ma duhd ma gad che awg ni awg yand awg khuhn mad juhg tand, yawd ved awg sehr phad kawq gag ver, ");
INSERT INTO lhi_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","yawd haq toq nux te puhr vid lehq, mawg kig huh ver ted ceng, mad mawg kig lo ver ted ceng te che chaw teq pa geh ghaq kog pe tug yaog. U huh kha chehd che chaw teq pa awr lehr, paz huhg kehd huhg chehd lehq cig geq yuhz cheq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kheh te lehq, muhd nuh maq muhd mig awr lehr, a sug yawd ved a mir khehd haq yug lar lehq awg mid ma he sehr phad haq law haq yug chehd che yad mid hax teq chi ghad haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","I hehd awg khuhn ve ngad ghad vawr, cud yiq mad cawg lehq ngad ghad vawr, cud yiq cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Cud yiq mad cawg che yad mid ngad ghad vawr, a sug yawd ved a mir khehd lehax yug ve kae lar lehq nag mand kawq ke thehnr tug mad yug ve kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kheh ma khuhd, cud yiq cawg che yad mid ngad ghad vawr, a sug yawd ved a mir khehd he lehq peg vehr ver kawq ke thehnr tug nag mand haq liz yug ve kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Awg mid ma he sehr phad har naq mad lag cheaq te lehq, yad mid hax u ve teq pa awg gha lia yuhq mir geq lehq yuhq mir saw ka vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Muhd khax te khend lo gaeg lehq, ‘Awg mid ma he sehr phad lag vehor. Yawd haq ca haq yug laoq,’ lehd koz kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kheh te lehq yad mid hax u ve teq pa tuag lehq, a sug yawd ved a mir khehd haq tox che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Cud yiq mad cawg che yad mid ngad ghad u ve awr lehr, cud yiq cawg che yad mid ngad ghad haq koz vid che, ‘Ngag hehd ve a mir khehd suh vehr lehd te cheaq te lehq, ngag hehd haq nag mand nehax a cehax kawq pehg ax,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kheh ma khuhd, cud yiq cawg che teq pa kawq koz vid che, ‘Ngag hehd awg pun he lehq nig hehd awg pun nag mand mad lawq hawg. Kheh te cheaq te lehq, nag mand huhd par geh ca vir-eg,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kheh te lehq i hehd teq pa nag mand ca vig tod che te yand, awg mid ma he sehr phad lag lehq, ghu lar hehnd lar che chaw teq pa khehx cad kig lo yawd geh teq geha gehg veh peg lehq, ghaz mir hoz lar vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Awg khaz nuhr, yad mid hax cud yiq mad cawg che ngad ghad kawaq lehq, ‘Jawd mawd-og, Jawd mawd-og, ngag hehd haq ghaz mir a cehax phawa laoq,’ lehd koz kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kheh ma khuhd, yawd kawq koz che, ‘Ngag nig hehd haq awg cehg mag koz ax laq, ngag nig hehd haq a cehax liz maq sir daq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kheh te cheaq te lehq, nig hehd khar thad liz kha sehax ghu hehnd lehq law lar. Awg lawn ghod ver, ngag khar thad kawaq tug awg ni, awg yand nig hehd maq sir hawg. ");
INSERT INTO lhi_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Muhd nuh maq muhd mig awr lehr, awg sehr phad te ghad awg bag muhd mig lo kae-ag lehd te lehq, yawd ved med nged jeg kor haq ngawx haq sax vid tug, awg ceg var teq pa haq kug lehq aq vid lar haz che haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I hehd teq pa pix che cheng che haq yawd ngawx lehq, te ghad haq phu ngad hinx, te ghad haq niq hinx he lehq te ghad haq teq hinx pid lar haz lehq yawd veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Phu ngad hinx gha che awg ceg var te ghad vawr, har naq phu u ve yug ve lehq tad kag ca te cheaq te lehq, awg mehaq ngad hinx kawq gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Phu niq hinx gha che awg ceg var te ghad liz, awg mehaq niq hinx kawq gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kheh ma khuhd, phu teq hinx gha che chaw te ghad vawr, yawd ved awg sehr phad ve phu u ve yug lehq mig kor dud lehq khuhd ceh lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Awg khaz nuhr awg yand muh vehr lehq, awg sehr phad kawaq che yaog. Kheh te lehq, yawd awg ceg var u ve teq pa phu khawd-ehg kheh te yehd che haq kug na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Phu ngad hinx gha lar che awg ceg var te ghad vawr, awg mehaq liz ngad hinx kawq yug veha lehq koz che, ‘Jawd mawd-og, nawg ngag haq phu ngad hinx pehar lar che yaog. Ngawx-oq, ngag awg mehaq liz ngad hinx kawq gha veha vehr che yaog,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Yawd ved awg sehr phad koz che, ‘Nawg te che daq vehr che yaog. Kar tiq yeg lehq daq che thed che awg ceg-og, i che awg ceng haq nawg thed cheaq te lehq, mad che awg ceng haq ngawx haq sax tug, ngag nawg haq aq ax tug yaog. Nawg liz ngag geh teq geha ga ha lehg laoq,’ lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Phu niq hinx gha lar che te ghad liz lag lehq, ‘Jawd mawd-og, nawg ngag haq phu niq hinx pehar lar che yaog. Ngawx-oq, ngag awg mehaq liz niq hinx kawq gha vehr che yaog,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Yawd ved awg sehr phad koz che, ‘Nawg te che daq vehr che yaog. Kar tiq yeg lehq daq che thed che awg ceg-og, i che awg ceng haq nawg thed cheaq te lehq, mad che awg ceng haq ngawx haq sax tug, ngag nawg haq aq ax tug yaog. Nawg liz ngag geh teq geha ga ha lehg laoq,’ lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Phu teq hinx lehax gha lar che awg ceg var liz lag lehq koz che, ‘Jawd mawd-og, nawg awr lehr te har che chaw te ghad phehq che haq ngag sir che yaog. Nawg maq ser lar kig lo nawg ghiq yug lehq, nawg maq kha lar kig lo awg sir awg no haq nawg ghawz phoz che haq ngag sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kheh te lehq ngag kuhz cheaq te lehq, nawg ved phu haq ngag yug lehq mig kor khuhn dud fiz lehq khuhd ceh lar che yaog. Ngawx chuhr, nawg ved med nged nawg haq kawq khuhq pehar che yaog,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Awg sehr phad ded lehq koz vid che, ‘Haeg jad che chaw bawg var-og, maq ser lar kig lo ngag ghiq yug lehq, maq kha lar kig lo awg sir awg no haq ngag ghawz phoz che haq nawg sir chehd ver, ");
INSERT INTO lhi_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","phu che ve yug ve lehq phu chid vid kig thawnr yehg khuhn liz ca ke lar cawd che yaog. U kheh te ver, ngag kawaq che te yand ngag ved phu che ve he lehq awg mehaq haq liz ngag kawq gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kheh te lehq, yawd geh phu teq hinx haq yug khuhq lehq, phu teq minr cawg che chaw te ghad haq pid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Awg lawn ghod ver, cawg chehd che chaw awg gha lia haq kawq thehnr vid lehq, yawd kha peh vad-ag cawg tug yaog. Kheh ma khuhd, mad cawg che chaw geh, yawd kha cawg lar che haq liz kawq yug ve tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kheh te peg lehq, awg bon mad cawg che awg ceg var te ghad haq awg bag lo awg naz tud teag lo yug chid bag peoq. U huh kha chehd che chaw teq pa awr lehr, kug huhg paz huhg chehd lehq cig geq yuhz cheq lar tug yaog,’ lehz awg sehr phad koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Chaw yad ve Yad phu lag che te yand, yawd ved awg mig awg phond ir jad che khuhn lag lehq, muhd nuh maq cuh yad awg gha lia yawd geh lag lehq, yawd ved awg mig awg phond cawg che kaw jaw awg thag lo yawd mi tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Awg yand u ve khuhn, chaw ceng awg gha lia yawd mehz khuhd suhr huh phoz lag vid lehq, yawg huhx var, yawg he lehq a chiq haq pehg daq che heh te lehq, yawd i hehd teq pa haq pehg daq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yawg teq pa haq yawd ved laq yaq awr phawd awr tar lehq, a chiq teq pa haq laq vehr awr phawd awr tar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Awg yand u ve khuhn, laq yaq awr phawd awr ve chaw teq pa haq Jawd mawd che kheh koz vid tug yaog. ‘Ngag ved Awr pa geh awg bon gha che chaw teq paog, laoq. Mig gig te phanr thad loar nig hehd awg pun ghu lar che muhd mig awg khuhn ca chehd laoq. ");
INSERT INTO lhi_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Awg lawn ghod ver, ngag awr meq che te yand, nig hehd ngag haq awr canr che yaog. Ngag a kaz sex che te yand, nig hehd ngag haq a kaz tawa che yaog. Ngag khehx chaw phehq che te yand, nig hehd ngag haq haq yug ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ngag beg ke veq kad mad cawg che te yand, nig hehd ngag haq veq deh ax che yaog. Ngag nag guhg che te yand, nig hehd ngag haq ngawx haq sax che yaog. Ngag thawnr khuhn chehd che te yand, nig hehd ngag haq ca ngawx-ag che yaog,’ lehd yawd koz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Awg yand u ve khuhn, thed che cawd che chaw yawd haq che kheh koz yaw khuhq vid tug yaog. ‘Jawd mawd-og, nawg awr meq che haq ngag hehd gha mawg lehq awr canr che khar thad le. Nawg a kaz sex che haq ngag hehd gha mawg lehq a kaz tawa che khar thad le. ");
INSERT INTO lhi_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Nawg khehx chaw phehq che haq ngag hehd gha mawg lehq haq yug ax che khar thad le. Beg ke veq kad mad cawg lehq beg ke veq kad feax che khar thad le. ");
INSERT INTO lhi_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nawg nag guhg che lehd ma koz, thawnr khuhn chehd che lehd ma koz, ngag hehd gha mawg lehq nawg haq ca ngawx-ag che khar thad le,’ lehd kawq koz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kheh te lehq, Jawd mawd i hehd haq kawq koz vid che, ‘Ngag nig hehd haq awg cehg mag koz ax laq, i jad che a vix a nax nig hehd awg khuhn ve chaw te ghad haq nig hehd te vid che awr lehr, ngag haq tea che yaog,’ lehz i hehd haq kawq koz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Kheh te lehq, laq vehr awr phawd awr chehd che chaw teq pa haq yawd che kheh koz ded vid tug yaog. ‘Khen che haq gha khanr che chaw teq paog, ngag haq phaz daq ve lehq, ned haeg he lehq yawd ved cuh yad teq pa awg pun ghu lar che co co tar taer toq chehd che a mir awg khuhn gehe log. ");
INSERT INTO lhi_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Awg lawn ghod ver, ngag awr meq thad nig hehd ngag haq teq chaweh liz maq canr. Ngag a kaz sex thad, nig hehd ngag haq teq chaweh liz maq tawa. ");
INSERT INTO lhi_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ngag khehx chaw phehq thad, nig hehd ngag haq mad haq yug ax. Ngag beg ke veq kad mad cawg thad, nig hehd ngag haq beg ke veq kad maq feax. Ngag nag guhg thad lehd ma koz, thawnr khuhn chehd thad lehd ma koz, nig hehd ngag haq maq ca ngawx-ag,’ lehd koz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Kheh te lehq i hehd liz koz che, ‘Jawd mawd-og, nawg awr meq che, a kaz sex che, khehx chaw phehq che, beg ke veq kad mad cawg che, nag guhg che, thawnr khuhn chehd che haq ngag hehd gha mawg lehq, nawg haq maq ga che khar thad le,’ lehz yawd haq kawq koz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Awg yand u ve khuhn, Jawd mawd kawq koz vid che, ‘Ngag nig hehd haq awg cehg mag koz ax laq, chaw che ve teq pa awg khuhn i jad che chaw nehax te ghad haq nig hehd maq te vid cheaq te lehq, ngag haq nig hehd maq tea che yaog,’ lehz i hehd haq kawq koz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kheh te cheaq te lehq, i hehd awr lehr, co co tar taer cir yanr che haq gha khanr yug tug yaog. Kheh ma khuhd, thed che cawd che chaw teq pa awr lehr, co co tar taer a saq teq che haq gha haq yug tug yaog,” lehz Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Awg lawn u ve teq pa haq Yer suq saw koz lar haz peg lehq, yawd ved awg laq ghuhd teq pa haq yawd koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Che khaz nuhr niq ni gaeg ver Par sar khar pawehd gag tug haq nig hehd liz sir chehd che yaog. Chaw yad ve Yad phu haq laq kan thag huh thaq vehr tug chid aq vid che haq yawd gha khanr tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kheh te lehq, paw khod nux teq pa he lehq Yud daq chaw teq pa ve awg hox chaw mawd teq pa vawr, Kar yar phaq meh che paw khod nux ve chehd kig lo jehg daq lehq, ");
INSERT INTO lhi_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yer suq haq khawd-ehg kheh te pheh yug lehq dawz vehr gha tug, i hehd awg khad ca lehq khuhd jehg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kheh ma khuhd i hehd koz daq che, “Muhd mig yad teq pa maq gha kaod suq saq tug pawehd te chehd che awg yand che ve khuhn taq te ser,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yer suq Ber tar niq khaz khuhn khir tuq phehq jaw che phad Sid monr ve yehg khuhn chehd chehd thad huh, ");
INSERT INTO lhi_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","yad mid te ghad yawd chehd lo lag lehq, awg phuhd khaz jad che nag mad huhx ke lar che a kaw phua ted mag yug veha lag lehq, Yer suq teh cuh pad huh awr mi cad chehd che haq yawd ved a kor thag huh nag mad juhd puhr vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yawd che kheh te che haq awg laq ghuhd teq pa gha mawg che te yand, i hehd teq pa nez nag jad lehq koz che, “A thoq te lehq teq chaweh awg bon mad cawg kig huh che ve haq yehd bag vehr cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nag mad huhx che ve haq yug ve lehq, awg phuhd pehz khaz mehz ca huhd lehq har yad ghuhd yad teq pa haq pehg vid gha che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yer suq awg lawn che ve haq gha kad che te yand, i hehd haq koz vid che, “A thoq te lehq yad mid che ve haq te soq saq vid cheawg le. Yawd ngag haq daq che awg ceng tea che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Har yad ghuhd yad teq pa vawr, nig hehd geh khar thad liz chehd che yaog. Kheh ma khuhd ngag vawr, nig hehd geh khar thad liz ma chehd chehd hawg. ");
INSERT INTO lhi_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nag mad huhx che ve ngag ved awg ton haq nger puhr che awr lehr, ngag awg ton haq tur ax tug awg pun yawd ghu lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ngag nig hehd haq awg cehg mag koz ax laq, ha lehg che bon khuhd che ve mig gig khod-aq lo khar lo ca mar vid-eg liz, yad mid che ve haq duhd nuhd vid tug awg pun yawd te lar che kanx che ve haq koz mar vid tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Awg yand u ve haq, awg laq ghuhd teq chi ni ghad awg khuhn chehd che, Yud daq Id sar kar rir oq meh che te ghad paw khod nux teq pa geh kae lehq, ");
INSERT INTO lhi_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“Yer suq ve awg ton nig hehd haq chid aq ax ver, ngag haq khawd-ehg ma pehar lawg le,” lehd koz vid che yaog. Kheh te lehq i hehd teq pa yawd haq phu sehz chi thehq pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Awg yand u ve haq tanr lehq, Yer suq ve awg ton su haq chid aq vid tug, awg yand daq che haq lehax Yud daq ca chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Khaor mod awg khuhn did maq ke che pawehd awg kawd maq ve teq ni haq, awg laq ghuhd teq pa Yer suq chehd lo lag lehq koz che, “Nawg awg pun Par sar khar pawehd cad tug, khar lo ted kag ngag hehd haq ca ghu cuha vid gad lehq le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yer suq kawq koz vid che, “Med khuhn lo gehe lehq haw khaz var u ve te ghad chehd lo kae lehq, ‘Sar lar koz che, “ngag ved awg yand gag vehr tez-og. Nawg ved yehg khuhn ngag ved awg laq ghuhd teq pa geh teq geha Par sar khar pawehd haq ngag cad tug yaog,” ced,’ lehz yawd haq koz vid-eq,” lehd awg laq ghuhd teq pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kheh te lehq, Yer suq koz vid che heh awg laq ghuhd teq pa kae lehq, Par sar khar pawehd cad tug awg pun ca ghu che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Muhd phiq muhd sux naz vehr huh, Yer suq awg laq ghuhd teq chi ni ghad geh teh cuh pad huh awr mi cad chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","I hehd teq pa awr phoz cad chehd-ag huh, Yer suq koz vid che, “Ngag nig hehd haq awg cehg mag koz ax laq, nig hehd awg khuhn ve chaw te ghad ngag haq kawq phuhz lehq su haq chid aq vid tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","I hehd teq pa duhd har jad che khuhn, “Jawd mawd-og, ngag la,” lehd koz lehq te ghad peg te ghad yawd haq kawq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yer suq kawq koz che, “Ngag geh teq geha a khehd ted mag khuhn lehax cad chehd che chaw te ghad, ngag haq su ved laq khuhn chid aq vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Chaw yad ve Yad phu awr lehr, yawd ved awg lawn Liq phu khuhn buhq lar peg che heh te lehq yawd gha kae tug yaog. Kheh ma khuhd, chaw yad ve Yad phu haq chid aq vid che chaw te ghad awr lehr, gha duhd har jad tug yaog. Chaw u ve maq pawag che heh ver, yawd awg pun lex lehq daq jad che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yawd haq kawq phuhz var Yud daq koz che, “Jawd mawd-og, ngag awr la,” lehd koz na ngawx che te yand, “Yaog, nawg yaog,” lehz Yer suq yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","I hehd teq pa phoz cad chehd huh, Yer suq khaor mod haq yug lehq bon haq chid muh che yaog. Kheh te peg lehq yawd khaor mod haq yug lehq khehq lehq awg laq guhd teq pa haq yawd pid lehq koz che, “Yug lehq cad-oq. Che ve awr lehr ngag ved awg ton yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Kawz khehd haq liz yawd yug lehq bon haq chid muh peg lehq, i hehd teq pa haq pid lehq koz che, “Nig hehd awg gha lia che ve haq dawr-oq. ");
INSERT INTO lhi_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Awg lawn ghod ver, che ve awr lehr kar tiq sax caz haq caz daq che ngag ved awg suhr yaog. Chaw kha peh vad-ag vend bax gha pong tug awg pun ngag ved awg suhr nger puhr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ngag nig hehd teq pa haq koz ax laq, Awr pa ve muhd mig awg khuhn lo nig hehd geh teq geha a pehx med ghig awg suhx haq ngag gha dawg tug awg ni kha gag, ngag a pehx med ghig haq mad kawq dawg-og,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kheh te peg lehq, i hehd teq pa Ghig sa haq liq khuhd ka chid muh lar haz lehq tuhez lehq Sar lonr khehaq lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Awg yand u ve khuhn Yer suq i hehd haq koz vid che, “Yaq pehax nig hehd awg gha lia ngag haq saw chid bag lar haz lehq phaw veh tug yaog. Awg lawn ghod ver, ‘Yawg huhx var haq ngag dawz vehr lehq, yawg teq pa ted mag ted kag lo phaw veh tug yaog,’ lehz Liq phu khuhn buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kheh ma khuhd, ngag kawq teq tuag ver, nig hehd haq keh awg kawd Gar liq lehd muhd mig lo ngag kae tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Per troq koz che, “Su awg gha lia nawg haq saw chid bag lar haz lehq phaw veh liz, ngag awr lehr u kheh maq ca te hawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yer suq Per troq haq koz vid che, “Ngag nawg haq awg cehg mag koz ax laq, yaq pehax ghaz mad buhg ser huh, nawg ngag haq maq sir daq lehz sehr pawz koz tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Per troq koz che, “Ngag nawg geh gha suh liz, ngag nawg haq maq ca chid bag lar haz hawg,” lehd koz vid che yaog. Kheh te lehq awg laq ghuhd teq pa liz u kheh saw koz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kheh te peg lehq Yer suq awr lehr, yawd ved awg laq ghuhd teq pa geh kae lehq, Ger ser mar niq lehd koz che ted kag lo gaeg che yaog. Yawd koz che, “Ngag ox lo bon ca laweg chehd-ag huh, nig hehd chuhr huh mir lar-oq,” lehz awg laq ghuhd teq pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kheh te peg lehq, Per troq he lehq Yer ber dehd ve awg yad par ni ghad haq yawd sir ve kae che yaog. Awg yand u ve khuhn yawd ved ni ma khuhn duhd har lehq phehq bawg jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","I hehd haq koz vid che, “Ngag ved ni ma duhd har jad che suhag lehd tea. Chuhr huh chehd lehq ngag geh teq geha law lar-oq.” ");
INSERT INTO lhi_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Kheh te lar haz lehq, yawd awg nuz awr a cehax kawq kae lar lehq, yawd ved mehz khuhd miaq lo boz cuhx lar lehq koz che, “Ngar paog, kawz che ve ngag haq pong gha ver, pong ax laoq. Kheh ma khuhd, ngag ved a lor cawd che heh tad phehq vid. Nawg ved a lor cawd che heh phehq vid-oq,” lehd koz bon lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Awg laq ghuhd teq pa geh yawd kawaq lehq, i hehd yuhq mir ka chehd lawz che haq gha mawg che te yand, Per troq haq koz vid che, “Teq nar rir nehax liz nig hehd ngag haq law lar maq gha cheawg la. ");
INSERT INTO lhi_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Nig hehd ber che lawd che awg khad khuhn maq gha kae tug bon lawg lehq law lar-oq. Nig hehd thed cawd che haq te gad che ni ma cawg liz, awg suhr awg sar phawd awr awg ghad nud che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yawd ni pawz te pawz kawq kae lehq, “Ngar paog, kawz che ve haq ngag mad dawg lehq mad pong gha che ver, nawg a lor cawd che heh phehaq vid-oq,” lehd koz bon kawq lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kheh te lehq, yawd te pawz kawq kawaq liz, i hehd yuhq mir geq jad che mehz phaw ma ghad cheaq te lehq yuhq mir ka chehd che haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kheh te lehq, yawd i hehd haq teh lar haz lehq sehr pawz te pawz liz, yawd lawg jaw che heh te lehq, bon ca kawq laweg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Awg yand u ve haq, awg laq ghuhd teq pa geh yawd te pawz kaw kawaq lehq koz vid che, “Nig hehd teq pa yuhq mir ka lehq awg ghad jehd chehd ser cheawg la. Chaw yad ve Yad phu haq, vend bax yad ve laq khuhn chid aq vid tug awg yand gag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tu lor. Kae veg. Ngawx lor. Ngag haq kawq phuhz lehq chid aq vid che phad lag gag vehor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yer suq tawd yaw chehd che mad peg tand, cuh yad teq chi ni ghad awg khuhn chehd che Yud daq meh che te ghad lag lehq, a teh puhd lehq suhz tag taz che chaw awg mor nux liz yawd geh ga lag che yaog. Chaw mor nux u ve teq pa awr lehr, paw khod nux teq pa he lehq Yud daq chaw teq pa ve awg hox chaw mawd teq pa cuh peha lar che chaw teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yawd haq chid aq vid che chaw te ghad awr lehr, i hehd haq awg hez che kheh te tug yaog lehd koz che yoag. “Ngag bux vid che phad awr lehr, yawd yaog. Yawd haq yug pheh lor,” lehz koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kheh te lehq, Yud daq Yer suq chehd lo thed-eg ghad gehag lehq, “Jawd mawd-og, awg bon ir vid-oq,” lehd koz lehq, yawd haq bux vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yer suq yawd haq koz vid che, “Awg chawd-og, nawg duhd lar che heh har naq teoq,” lehz yawd haq koz vid che yaog. Kheh te lehq, i hehd teq pa gehag lehq Yer suq haq yug cid lar lehq pheh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Awg yand u ve khuhn, Yer suq geh chehd chehd che chaw te ghad, yawd ved a teh ghawg tuhaz lehq paw khod nux vig lar che awg ceg var te ghad ve nar puh chuh chez vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kheh te lehq Yer suq yawd haq koz vid che, “Nawg ved a teh haq awg phi khuhn kawq khuhq keoq. Awg lawn ghod ver, a teh haq kha yehd che chaw vawr, a teh haq te lehq suh tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Muhd nuh maq cuh yad teq chi niq mor haq keh mad che liz ngag haq lag ga vid tug a meha ngag Awr pa geh lawg maq gha hawg lehz nawg duhd cheawg la. ");
INSERT INTO lhi_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kheh ma khuhd, ngag u kheh te lawg ver, che kheh gha phehaq tug yaog lehd koz lehq Liq phu khuhn buhq lar che teq pa heh khawd-ehg kheh te ca phehq lag gha tuawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Awg yand u ve khuhn Yer suq chaw awg mor nux haq koz vid che, “Nig hehd teq pa vawr chaw khuhd haq ca phehag che heh te lehq a teh puhd lehq suhz tag taz veha lehq ngag haq ca phehag cheawg la. Ni gha lia bon yehg nux khuhn ngag mi lar lehq mar vid chehd huh liz, nig hehd ngag haq maq ca phehag. ");
INSERT INTO lhi_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kheh ma khuhd, che kheh phehaq tug awr lehr, Ghig sa ve cuh kar var teq pa ve liq khuhn buhq lar che heh saw phehaq tug awg pun yaog,” lehd koz che yaog. Awg yand u ve haq, awg laq ghuhd awg gha lia yawd haq saw chid bag lar haz lehq phaw veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Yer suq haq yug pheh ve che chaw teq pa awr lehr, paw khod nux Kar yar phaq ve yehg lo yug ve kae che yaog. U huh, liq buhq var he lehq awg hox chaw mawd teq pa phawng daq chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Per troq awr lehr, paw khod nux ve sax nanx awg pad huh kho ko lar kig huh kha gag Yer suq khaz nuhr vid viad lo ghaq kae lehq, awg lawn che ve haq awg leh med kha gag gha sir gha mawg tug, yawd gehe lehq saw par teq pa geh mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Paw khod nux teq pa he lehq phawng daq chehd che chaw awg gha lia awr lehr, Yer suq haq gha dawz vehr tug, yawd awg lawn ma hez hez che sax khiz haq ca che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ma hez hez che sax khiz khanr var kha peh vad-ag cawg liz, jehg sehr phad teq pa teq chaweh sax khiz yug te tug ca mad mawg. Awg leh med lo gaeg lehq, ma hez hez che sax khiz khanr var ni ghad tuhaz lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Chaw che ve phad koz che, ‘Ghig sa ve bon yehg nux haq ngag te lug lehq, sehr ni awg khuhn lo lehax kawq te gha hawg,’” lehz ix mag sax khiq khanr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Awg yand u ve khuhn paw khod nux tuag lehq koz che, “Chaw che ve phad nawg haq awg lawn sax khiz khanr chehd che yaog. Nawg teq chaweh liz ma koz khuhq vehr cheawg la,” lehd Yer suq haq na che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kheh liz, Yer suq taq chuh-ax ghad chehd chehd che yaog. Paw khod nux yawd haq kawq koz vid che, “Ghig sa ve Yad phu Khreq lehd koz che te ghad awr lehr, nawg yaog la. Ngag hehd haq koz ax tug, teq chehd che Ghig sa ve mehz khuhd suhr ngag nawg haq khanr cuha che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yer suq kawq koz vid che, “Nawg koz che heh yaog. Kheh te lehq, ngag nig hehd haq awg cehg mag koz ax laq, che khaz nuhr ver chaw yad ve Yad phu vawr, kand pax ir jad che awg sehr phad ve laq yaq awr phawd awr mi lar lehq, mog khuhn yaq che haq nig hehd gha mawg tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kheh te lehq paw khod nux yawd ved beg ke veq kad haq juhq seh lehq koz che, “Chaw che ve phad awr lehr, awg cehg mag Ghig sa haq maq sawnr ma caz koz che yaog. A nig sax khiz a thoq haq kawq ca sar le. Yawd Ghig sa haq maq sawnr ma caz koz che haq a meha chuhr huh nig hehd gha kad vehor. ");
INSERT INTO lhi_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nig hehd teq pa khawd-ehg kheh duhd-aq le,” lehd koz na ngawx che te yand, “Yawd vawr suh kenr vehr che yaog,” lehz i hehd teq pa koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kheh te lehq, su yawd ved mehz khuhd khuhn cux ghig pheq puhr lehq chung phehd lehq, ted pehg vawr mehz khuhd khuhn tha ke vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kheh te peg lehq yawd haq na che, “Khreq-og, nawg haq a sug dawz che law le. Ghig sa ve cuh kar var heh te lehq ngag hehd haq koz ax laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Awg yand u ve haq Per troq sax nanx yehg awg bag huh mi chehd lehq, awg ceg ma te ghad yawd chehd-ag huh lag lehq koz che, “Nawg liz Gar liq lehd chaw Yer suq geh chehd che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kheh ma khuhd, Per troq chaw kheh ma ve mehz khuhd suhr huh her ka lehq koz che, “Nawg koz chehd che ix ve haq ngag maq sir,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Kheh te peg lehq Per troq yehg ghaz mir khuh bag lo tuhez thad huh, awg kag awg nuz awr ve awg ceg ma te ghad yawd haq mawg lehq u huh chehd che chaw teq pa haq koz vid che, “Che ve phad awr lehr Nar sar rehq chaw Yer suq geh chehd che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Per troq te pawz kawq her ka lehq koz che, “Chaw u ve phad haq ngag maq sir daq,” lehd koz lehq khanr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Teq per nehax heh gaeg lehq, u huh hox chehd che chaw teq pa Per troq chehd lo lag lehq, “Nawg liz awg cehg mag i hehd awg mor khuhn chehd che chaw te ghad phehq che yaog. Awg lawn ghod ver, nawg tawd yaw che khuhd haq lehax na liz, ngag hehd sir che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kheh te lehq Per troq khen lehq, “Chaw u ve phad haq ngag maq sir daq,” lehd koz lehq khanr che yaog. Yawd u kheh koz chehd che awg yand awg khuhn ghaz buhg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","“Ghaz mad buhg ser huh nawg ngag haq sehr pawz kha gag chid bag tug yaog,” lehz Yer suq koz vid lar che haq Per troq kawq duhd nuhd vehr che yaog. Kheh te lehq, yawd tuhez lehq duhd har jad che khuhn hax ceh huhg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Muhd sawx ted naq muhd thid-ag che te yand, paw khod nux teq pa he lehq Yud daq chaw teq pa ve awg hox chaw mawd teq pa awg gha lia Yer suq haq dawz vehr tug jehg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Kheh te peg lehq, i hehd Yer suq haq pheh yug ve lehq, muhd mig jawd mawd Pid laq ve laq kuhr khuhn yawd haq chid aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kheh te lehq Yer suq haq chid aq vid che phad Yud daq awr lehr, Yer suq haq dawz vehr tug suhx jehg suhx taz che haq yawd gha mawg che te yand, yawd kawq duhd phuhz lehq, phu u ve sehz chi thehq paw khod nux teq pa he lehq awg hox chaw mawd teq pa haq kawq yug khuhq pid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Vend bax mad cawg che chaw te ghad haq ngag chid aq ax cheaq te lehq, ngag vend bax te vehr che yaog,” lehd koz vid che yaog. I hehd kawq koz che, “Che ve haq ngag hehd khawd-ehg kheh te caz daq hawg le. U ve awr lehr, nawg ved kanx yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Phu u ve haq bon yehg nux khuhn chid bag ke lar haz lehq, yawd tuhez lehq yawd khad yawad kuhr pehg ca pheh suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Paw khod nux teq pa phu u ve haq ghawz veha lehq koz che, “Phu che ve awr lehr, awg suhr hehr vehr cheaq te lehq, phu tand geh khuhq daq ma cawd hawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kheh te lehq, i hehd teq pa jehg daq lehq, khehx chaw teq pa haq tur vid tug, phu u ve yug ve lehq a jeq mawq khu te par ve mig gig te pez haq vig lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kheh te lehq, yaq ni kha gag mig gig u ve te pez haq awg suhr mig gig lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","U thad lo, cuh kar var Yer rar miq koz lar che heh phehaq che yaog. Yawd koz che, “Id sar rer laq chaw teq pa ted pehg pehar awg phuhd koz chez lar che, chaw te ghad ve awg phuhd phu sehz chi thehq haq yug lehq, ");
INSERT INTO lhi_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Jawd mawd Ghig sa ngag haq koz ax lar che heh, a jeq mawq khu te par ve mig gig te pez haq i hehd vig che yaog.” ");
INSERT INTO lhi_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yer suq haq muhd mig jawd mawd mehz khuhd suhr huh sir ve hox vid lar lehq, muhd mig jawd mawd yawd haq na che, “Nawg awr lehr Yud daq chaw teq pa ve jawd mawd yaog la,” lehd koz vid che yaog. “Nawg koz che heh yaog,” lehz Yer suq kawq yaw khuhq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kheh ma khuhd, paw khod nux he lehq awg hox chaw mawd teq pa yawd haq vend bax tar che te yand, yawd teq chaweh liz mad kawq koz khuhq vid. ");
INSERT INTO lhi_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Kheh te lehq, muhd mig jawd mawd Pid laq Yer suq haq na lehq koz che, “Nawg awg lawn i hehd vend bax tar lehq sax khiz khawd kheh koz khanr chehd che haq nawg maq gha kad la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kheh ma khuhd, yawd teq chaweh liz mad kawq koz khuhq vid cheaq te lehq, muhd mig jawd mawd Pid laq and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pawehd u ve haq te che te yand, thawnr khuhn chehd che chaw teq pa awg khuhn ve chaw kheh ma ve ni ma cawd che chaw te ghad haq muhd mig jawd mawd phehd kha vid tug awg lid cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Awg yand u ve haq, thawnr khuhn geh chehd che chaw teq pa awg khuhn, awg meh buhg jad che Bar rar baq meh che chaw te ghad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kheh te lehq, i hehd phawng daq chehd che te yand, muhd mig jawd mawd Pid laq na che, “Nig hehd awg pun a sug haq phehad vid gad le. Bar rar baq haq la, ma hez ver Khreq lehd koz che Yer suq haq la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Awg lawn ghod ver, Yer suq haq soer che ni ma cawg che haq te lehq, i hehd yawd haq chid aq ax che yaog lehz, muhd mig jawd mawd Pid laq sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kheh te lehq, suhx jehg suhx taz kig kaw jaw thag lo muhd mig jawd mawd Pid laq yawd mi chehd-ag huh, yawd ved awg mid ma yawd haq tawd che kheh koz sanr peha che yaog. “Thed che cawd che chaw che ve phad haq teq chaweh taq te. Awg lawn ghod ver a mig hax ngag yuhq maz a cehax liz mad daq. Kheh te lehq yaq ni teq ni maq ve ngag duhd har jad che yaog,” lehd koz tawd sanr fea che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kheh ma khuhd, paw khod nux teq pa he lehq awg hox chaw mawd teq pa vawr, Bar rar baq haq lawg yug lehq Yer suq haq dawz vehr tug, muhd mig yad teq pa haq awg ghad hax ceh pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Muhd mig jawd mawd Pid laq muhd mig yad haq koz vid che, “Chaw che ve ni ghad awg khuhn a suq haq phehd vid gad lehq le,” lehd koz na che yaog. Kheh te lehq i hehd teq pa koz che, “Bar rar baq haq yaog” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Kheh te ver, Khreq lehd koz che Yer suq haq ngag khawd-ehg kheh gha te lawg le,” lehd koz lehq muhd mig jawd mawd Pid laq i hehd haq na ngawx che te yand, i hehd teq pa awg gha lia koz che, “Laq kan thag huh thaq vehr lor,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Muhd mig jawd mawd Pid laq kawq koz vid che, “A thoq te lehq le. Yawd a thoq ted ceng haq te yaq kig cawg cheawg le,” lehd i hehd haq na ngawx che te yand, i hehd teq pa hax ceh nux maz kawq kug lehq koz che, “Yawd haq laq kan thag huh thaq veh-oq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Muhd mig jawd mawd Pid laq awr lehr, muhd mig yad teq pa diz diz huhd huhd te tuag vehr che haq yawd gha mawg lehq, yawd teq chaweh te maq gha vehr che haq yawd gha sir vehr lehq, muhd mig yad kheh ma ve mehz khuhd suhr laq kuhr chuhd lehq koz che, “Chaw che ve phad gha suh che toq ngag awg khod-aq lo tad gag vid. Nig hehd khad nawg-a nig hehd teoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Muhd mig yad teq pa awg gha lia koz che, “Toq che ve awr lehr, ngag hehd he lehq ngag hehd ve awg yad awg dug teq pa khanr yug che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kheh te lehq muhd mig jawd mawd Pid laq awr lehr, Bar rar baq haq phehd kha vid lehq, Yer suq haq jawq peg lehq laq kan thag huh thaq vehr tug maq yad teq pa haq chid aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kheh te lehq muhd mig jawd mawd Pid laq ve maq yad teq pa, Yer suq haq maq yad teq pa ve sax nanx nux khuhn sir ve kae lehq, maq yad ted taq ve awg gha lia Yer suq haq ga phoz paog vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","I hehd teq pa yawd ved a poq haq kuhz kha lehq, a poq yehg maq awg ni sid te che yawd haq kawq deh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","A chud te haq yug lehq si ux cuhr heh te ghaq lehq, yawd ved a kor haq khuhz vid che yaog. Yawd ved laq kuhr laq yaq awr pax awr ve khuhn pund cehg ted mag yug cid vid lar lehq, yawd mehz khuhd suhr huh khi cuhx teh mi lehq koz che, “Yud daq ve jawd mawd-og, nawg awg bon ir vid-oq,” lehd koz lehq, yawd haq maq sawnr ma caz koz gid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","U kheh te peg lehq, yawd haq cux ghig kaod pheq puhr vid lehq, pund cehg u ve yug lehq yawd ved a kor haq kawq kaod dawz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Yawd haq maq sawnr ma caz te koz gid peg lehq, yawd ved a poq awg ni sid te che haq yug khuhz kha lehq, yawd ved a poq awg pir kawq ghawz veq vid peg lehq, laq kan thag huh thaq vehr tug yawd haq seh ve kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","I hehd teq pa tuhaz tod-ag huh, Kud rer ner med yad Sid monr meh che te ghad haq mawg che yaog. I hehd yawd haq yug lehq Yer suq ve laq kan haq taz cuh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gawd laq gawd taq lehd koz che awg ti ted kag lo i hehd gaeg che yaog. Awg meh u ve cuhz kig awr lehr, a kor ghuhd lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","I hehd teq pa a pehx med ghig ce maq te che yug lehq awg khad tuhx te che awg ceng haq pawnd daq lehq, Yer suq haq taw vid che yaog. Kheh liz, yawd lehq ngawx peg lehq mad kawq dawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","I hehd teq pa yawd haq laq kan thag huh yug thaq ke peg lehq, yawd ved beg ke veq kad teq pa haq yug lehq pehg daq tug nar bar kehx yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kheh te lehq, i hehd teq pa u huh mi lar lehq yawd haq paog chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kheh te lehq, i hehd teq pa yawd haq vend bax tar che liq buhq khang gid lar che yawd ved a kor thag lo nehx lar lehq, “Chaw che ve phad vawr, Yud daq chaw teq pa ve Jawd mawd Yer suq yaog,” lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Awg yand u ve khuhn, chaw khuhd liz ni ghad Yer suq geh teq geha laq kan thag huh thaq vehr lar che yaog. Laq yaq awr pax awr te ghad he lehq laq vehr awr pax awr te ghad thaq ke lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Phanr taz phanr yaq te tod chehd che chaw teq pa, yawd haq maq sawnr ma caz te koz gid lehq a kor hiz lar lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Bon yehg nux haq te lug lehq sehr ni awg khuhn lehax kawq te gha che chaw-og, nawg awg ton haq pong vid tug teoq. Nawg Ghig sa ve Yad phu yaog ver, laq kan thag huh yaq laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Paw khod nux teq pa awr lehr, liq buhq var teq pa he lehq awg hox chaw mawd teq pa geh teq geha su heh te lehq yawd haq koz gid ghig gid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","I hehd koz che, “Su haq yawd pong vid gha che yaog. Yawd awg ton haq yawd kawq ga pong vid maq gha. Yawd Id sar rer laq ve jawd mawd ma hez hawg la. Kheh te lehq, yawd a meha laq kan thag huh yaq ver, ngag hehd liz yawd haq yonr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yawd Ghig sa haq yonr che yaog. ‘Ngag awr lehr Ghig sa ve Yad phu yaog,’ lehd yawd koz lar cheaq te lehq Ghig sa yawd haq ni ma cawd ver, Ghig sa yawd haq yug pong vid-oq,” lehz i hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yawd geh teq geha laq kan thag huh thaq ke lar che chaw khuhd var ni ghad liz, su heh te lehq yawd haq maq sawnr ma caz te koz gid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Muhd kaw cuhaz huh te lehq muhd phiq phawd awr seh nar rir kha gag, mig gig koar lo awg naz hoq awg naz tud saw phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Muhd phiq phawd awr seh nar rir kheh yand gaeg lehq, Yer suq awg khuhd pehz hehnd mehz lehq koz che, “E li, E li, la ma sa ba tha ni,” lehd koz kug che yaog. Cuhx kig vawr, “Ngag ved Ghig sa-og, Ngag ved Ghig sa-og, a thoq te lehq nawg ngag haq chid bag lar haz cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","U huh hox chehd che chaw teq pa ted pehg tawd khuhd u ve haq gha kad che te yand, “Chaw che ve phad awr lehr, Ed lid yaq haq ca kug chehd che law,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","I hehd awg khuhn ve chaw te ghad teq pear maq lehax cex kae lehq, a kaz chuhq gha che pha nuad ted mag yug veha lehq, pund tag awg med-e gehd choz lar lehq a pehx med ghig ce maq te che khuhn tiz ke peg lehq, yawd haq bez taw vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kheh ma khuhd, chaw ted pehg pehar koz che, “Taq te ser. Ed lid yaq yawd haq ca ga vid-ag tug lehq nar, law ngawx lar veg ser,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yer suq awg khuhd pehz hehnd mehz te pawz kawq kug peg lehq sax chez vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Awg yand u ve haq, bon yehg nux khuhn ve pha thed lar che liz, awg thag lo te lehq awg huhx lo kha gag ni khod te pheq vehr che yaog. Mig hiz lehq huhx meh teq pa liz awg khod sez phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tur phuh teq pa phaw kha vehr lehq, suh vehr lar che Ghig sa ve daq kehg che chaw kha peh vad-ag awg ton kawq teq tuag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yer suq kawq teq tuag peg khaz nuhr, i hehd liz tur phuh khuhn tuhaz lehq, Yer ruq sar lehnr med khuhn gehe lehq, chaw laex ghad i hehd haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Maq yad awg hox he lehq yawd geh Yer suq haq paog chehd che maq yad teq pa awr lehr, mig hiz che he lehq kha phehaq che awg ceng teq pa haq gha mawg che te yand, i hehd teq pa kuhz jad lehq koz che, “Chaw che ve phad awr lehr, awg cehg mag Ghig sa ve Yad phu te ghad phehq che yaog,” lehz koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Awg kanr a cehax vid-aq lo yad mid teq pa liz kha peh vad-ag hox lar ngawx chehd che yaog. I hehd teq pa awr lehr, Yer suq Gar liq lehd muhd mig khuhn tuhaz thad lo ag, yawd khaz nuhr ghaq lag lehq yawd ved awg ceg te lehq te car te taw vid tod che yad mid teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","I hehd awg mor awg khuhn, Mar riq Mar gar dar laq, Yar koq he lehq Yod sehq ve awr ye Mar riq he lehq Yer ber dehd awg yad par teq pa ve awr ye, chaw che ve teq pa chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Muhd phiq vehr huh, Ar riz mar thehr med yad Yod sehq meh che paw sa var te ghad lag che yaog. Yawd awr lehr, Yer suq ve awg laq ghuhd te ghad phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yawd muhd mig jawd mawd Pid laq geh kae lehq, Yer suq ve awg ton haq ca lawg yueg che yaog. Kheh te lehq, yawd haq pid tug muhd mig jawd mawd Pid laq tawd sanr vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kheh te lehq Yod sehq awr lehr, Yer suq ve awg ton haq yug ve kae lehq, daq kehg che pha phua yug thiz vid lehq, ");
INSERT INTO lhi_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","huhx meh thuhz lar che yawd ved tur phuh awg suhx khuhn yug ve ke lehq, tur phuh awg khod med huh huhx meh diq nux ted mag phuhz chuhd lar haz lehq koeq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Awg yand u ve khuhn, Mar riq Mar gar dar laq he lehq awg kag awr ve Mar riq te ghad liz, tur phuh awg pad huh mi lar ngawx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sawx awr kheha gaeg ver, Sa ba to awg ni gag vehr lehq, paw khod nux te pa he lehq Phar rir sehd teq pa muhd mig jawd mawd Pid laq geh kae lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Jawd mawd-og, chaw he ka var che ve phad awr lehr, yawd teq chehd ser thad huh, ‘Sehr ni gaeg ver, ngag kawq teq tuag tug yaog,’ lehz ngag hehd haq yawd koz ax lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kheh te cheaq te lehq, yawd ved awg laq ghuhd teq pa yawd haq maq gha ca khuhd yug ve lehq, ‘Yawd suh kig lo kawq teq tuag vehor,’ lehz su haq maq gha ca koz vid tug, sehr ni kha gag yawd ved tur phuh u ve haq kha nehax paog lar vid tug tawd sanr vid-oq. U kheh maq te ver, a mig her ka cheaq keh a meha kawq her ka ver, sang nar jad vehr tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jawd mawd Pid laq i hehd haq koz vid che, “Nig hehd teq pa geh paog par maq yad teq pa sir ve lehq nig hehd te gha che heh te lehq kha sehax paog cuh vid lar-eq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kheh te lehq i hehd teq pa kae lehq, tur phuh haq su maq gha phaw vid tug huhx meh dig haq cunr dawz lar lehq, paog par teq pa haq kha sehax paog cuh vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sa ba to awg ni te peg lehq, suhr ni teq ni khuhn awg kawd maq ve teq ni muhd sawx ted naq huh, Mar riq Mar gar dar laq he lehq awg kag awr ve Mar riq te ghad, ix mag tur phuh lo ca ngawx-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Awg yand u ve khuhn, mig hiz jad che yaog. Awg lawn ghod ver, Jawd mawd Ghig sa ve muhd nuh maq cuh yad te ghad muhd nuh maq lo yaq lehq tur phuh haq phuhz chuhd lar che huhx meh diq u ve haq phuhz kha lar lehq, yawd huhx meh dig u ve thag huh taz mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Muhd nuh maq cuh yad u ve yawd ved awg hoq awg han vawr, muhd pehq che heh te lehq, yawd ved beg ke veq kad liz phux-u ghad te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Paog chehd che maq yad teq pa Ghig sa ve muhd nuh maq cuh yad haq gha mawg lehq kuhz ched jad cheaq te lehq, chaw suh heh te lehq kuhd teh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Muhd nuh maq cuh yad u ve yad mid u ve ni ghad haq koz vid che, “Ta kuhz. Laq kan thag huh thaq vehr lar che Yer suq haq nig mag ca ngawx-ag cheawg lehz ngag sir chehd-aq. ");
INSERT INTO lhi_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yawd chuhr huh ma chehd. Awg lawn ghod ver, yawd koz lar che heh te lehq Ghig sa yawd haq kawq teq tuag vid vehor. Yawd haq teh lar kig huh ca ngawx laoq. ");
INSERT INTO lhi_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Har naq koeq lehq yawd ved awg laq ghuhd teq pa haq che kheh ca koz vid-oq, ‘Suh kig lo Ghig sa yawd haq kawq teq tuag vid vehor. Nig hehd haq keh awg kawd Gar liq lehd muhd mig lo yawd veh che yaog. U huh nig hehd yawd haq gha mawg tug yaog,’ lehd koz vid-oq. Awg lawn che ve ngag nig mag haq koz ax che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kheh te lehq ix mag kuhz liz kuhz, ha liz ha lehg jad che khuhn te pawaz lehax tur phuh lo tuag lehq, awg laq ghuhd teq pa haq cex kawq koz vid-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Awg yand u ve khuhn, Yer suq liz ix mag mehz khuhd suhr huh lag hox lar lehq ix mag haq koz vid che, “Awg bon ir vid-oq,” lehd koz vid che yaog. Kheh te lehq ix mag yawd ved khi kud haq vuhz cuhx lar lehq yawd haq a kor pi vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kheh te lehq, Yer suq ix mag haq koz vid che, “Ta kuhz. Ngag ved a vix a nax teq pa haq Gar liq lehd muhd mig lo kae tug ca koz vid-eq. U huh i hehd ngag haq gha mawg tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Yad mid u ve ni ghad kae tod che awg yand u ve haq, paog chehd che chaw teq pa ted pehg med khuhn gehe lehq, kha phehaq che awg ceng gha lia paw khod nux teq pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kheh te lehq paw khod nux teq pa awr lehr awg hox chaw mawd teq pa haq phawng daq lehq jehg daq peg lehq, maq yad teq pa haq phu kha peh vad-ag pid lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“‘Muhd khax te khend lo ngag hehd yuhq mir ka chehd-ag huh, yawd ved awg laq ghuhd teq pa lag lehq yawd haq lag khuhd yug ve vehr che yaog,’ lehz nig hehd su haq koz vid mehr. ");
INSERT INTO lhi_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Awg lawn che ve haq muhd mig jawd mawd nux gha kad ver, nig hehd teq pa haq yawd teq chaweh maq gha te vid tug, ngag hehd teq pa yawd haq koz vid tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kheh te lehq i hehd teq pa phu u ve haq yug lehq, su i hehd haq koz mar vid lar che heh te che yaog. Yud daq chaw teq pa awg khuhn a meha yaq ni thad kha gag awg lawn che ve haq lao daq veh chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Awg laq ghuhd u ve teq chi te ghad awr lehr, Gar liq lehd muhd mig khuhn Yer suq koz mar vid lar che keh dig u ve lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","I hehd yawd haq gha mawg lehq a kor pi che yaog. Kheh ma khuhd ted pehg pehar vawr thuhd duhd nuhg duhd te chehd ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yer suq i hehd teq pa chehd lo lag lehq koz che, “Muhd nuh maq lo ve he lehq mig gig khod-aq lo ve kand pax awg gha lia ngag haq saw pehar vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kheh te cheaq te lehq nig hehd teq pa kae lehq, chaw ceng gha lia ngag ved awg laq ghuhd phehaq vid tug ca teoq. Awr pa, Yad phu he lehq daq kehg che Awg ha phu ve awg meh awg huhx lo i hehd haq baz tiz sar pid-oq. ");
INSERT INTO lhi_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ngag nig hehd haq pid lar che tawd khuhd awg gha lia haq na yug lehq te tug, i hehd haq mar vid-oq. Mig gig che ve awg yand leh thad kha gag, ngag nig hehd geh khar thad liz chehd tug yaog,” lehz i hehd haq koz vid che yaog.");
INSERT INTO lhi_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ghig sa ve Yad phu Yer suq Khreq ve ha lehg che bon khuhd awg kawd maq thad awr lehr che kheh yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ghig sa ve cuh kar var Id sar yaq ve liq awg khuhn buhq lar che heh, “Ngawx lor, nawg ghud med awr nawg ved yaq kaw haq ghu lar ax tug, ngag ved cuh yad haq ngag kae pe che yaog, lehz koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","‘Jawd mawd Ghig sa ve yaq kaw haq ghu lar lor. Yawd ved yaq kaw teq pa haq thed-e lehd teo,’ lehz heh pir khuhn lo chaw te ghad kug chehd tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Yod hanr baz tiz sar pehar var heh pir khuhn tuhaz che yaog. Vend bax phehd kha gha tug, vend bax duhd phuhz che haq caz daq che baz tiz sar ted ceng haq yawd mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yud daq muhd mig chaw awg gha lia he lehq Yer ruq sar lehnr med yad awg gha lia Yod hanr chehd lo kae che yaog. A sug yawd ved vend bax haq koz mar vid lehq, Yod hanr i hehd haq Yawd danr lawg kax awg khuhn baz tiz sar pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yod hanr awr lehr, kar lar oq awg muh te lar che beg ke haq veq deh lehq, cuhq pehng huh sar gig sehx hang caz chuhq lar che yaog. Par ceq he lehq heh pir khuhn ve pehd ghig haq yawd cad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yawd bon mar lehq koz che, “Ngag khaz nuhr lag tug te ghad awr lehr, ngag haq keh kand pax ir che yaog. Ngag cuhq kuhq lehq yawd ved khi noz caz haq phi tug lehax liz maq kenr. ");
INSERT INTO lhi_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ngag awr lehr nig hehd haq a kaz awg khuhn baz tiz sar pehar che yaog. Kheh ma khuhd yawd awr lehr, nig hehd haq Daq che kehg che Awg ha phu awg khuhn baz tiz sar pehar tug yaog,” lehz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Awg yand u ve awg khuhn, Gar liq lehd muhd mig Nar sar rehq med khuhn Yer suq tuhaz lehq, Yawd danr lawg kax awg khuhn Yod hanr yawd haq baz tiz sar pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yer suq a kaz awg khuhn tanr tuhaz che te yand huh, muhd nuh maq phaw lehq Awg ha phu awr lehr a pia heh te lehq yawd awg thang huh yaq che haq Yer suq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","“Nawg awr lehr ngag haq jad che ngag ved Yad phu yaog. Nawg haq ngag ni ma cawd jad che yaog,” lehz muhd nuh maq lo awg khuhd buhq tuhaz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Teq pear lehax Awg ha phu yawd haq heh pir khuhn ghaq pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Yawd heh pir khuhn lo uhd chi ni chehd lehq, Sar tanr yawd haq ber che lawd che yaog. Yawd haeg che to nud to saz teq pa geh chehd lehq, muhd nuh maq cuh yad teq pa yawd lor che haq ga vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","15","Yod hanr haq su pheh yug peg khaz nuhr, Yer suq Gar liq lehd muhd mig lo lag che yaog. Ghig sa ve ha lehg che bon khuhd haq Yer suq mar vid lehq koz che, “Awg yand gag vehr che yaog. Ghig sa ve muhd mig lag gag vehr tez che yaog. Vend bax haq duhd phuhz lehq ha lehg che bon khuhd haq yonr lor,” lehd koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Gar liq lehd ghig po nux pad huh Yer suq kae tod-ag huh, Sid monr he lehq yawd ved awg nax var Anr drehr ghig po awg khuhn geq phehd chehd che haq gha mawg che yaog. Awg lawn ghod ver, ix mag awr lehr ngad ca var phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yer suq koz che, “Ngag khaz nuhr ghaq lar-oq. Ngag nig mag haq chaw ca sehr phad te cuha tug yaog,” lehz ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ix mag teq pear lehax geq haq teh lar haz lehq yawd awg khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yer suq awg nuz awr a cehax kawq kae che te yand, Yer ber dehd ve awg yad par Yar koq he lehq yawd ved awg nax var Yod hanr, huh lawd kor khuhn geq ghu behz chehd che haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Teq pear lehax Yer suq ix mag haq kug yug che yaog. Kanx canr te cad var teq pa geh awr pa Yer ber dehd haq huh lawd kor khuhn lo teh lar haz peg lehq, ix mag yawd awg khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","I hehd Kar per nar unr med khuhn gehe che yaog. Sa ba to awg ni haq teq pear lehax Yer suq bon lawg kig lo taez lehq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yawd mar vid che haq i hehd and jad che yaog. Awg lawn ghod ver, liq buhq var teq pa mar vid che heh te yawd mar che ma hez. Yawd kand pax cawg che awg khuhn mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Awg yand u ve haq i hehd ve bon lawg kig awg khuhn ned chaq chiz geh che chaw te ghad cawg che yaog. Yawd kug lehq ");
INSERT INTO lhi_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","koz che, “Nar sar rehq chaw Yer suq-og, nawg ngag hehd haq khawd-ehg kheh caz daq che awg le. Ngag hehd haq te lug ax tug nawg lag cheawg la. Nawg haq ngag sir chehd che yaog. Nawg awr lehr, Ghig sa ve Daq kehg che chaw u ve te ghad phehq che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Awg yand u ve haq Yer suq yawd haq ded lehq koz che, “Taq chuhax chehd-oq. Yawd awg khuhn lo tuhz kae-o,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ned chaq chiz awr lehr, chaw u ve haq hax ceh nux phez dawz cuh vid lehq, awg khuhd hehnd chawa kug lehq yawd awg khuhn tuhz veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Chaw awg gha lia and lehq koz che, “Che ve awr lehr, khawd-ehg kheh awr le. Mar vid che che awr lehr, awg suhx ted ceng law lehg. Ned chaq chiz teq pa haq liz kand pax awg khuhn yawd tawd pid lehq i hehd na yug che yaog,” lehz i hehd te ghad he lehq te ghad koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yawd ved awg lawn teq pear lehax Gar liq lehd muhd mig awg kag gha lia lo buhg veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Teq pear lehax i hehd bon lawg kig awg khuhn tuhz kae lehq, Yar koq he lehq Yod hanr geh Sid monr he lehq Anr drehr teq pa ve yehg khuhn gehe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Sid monr ve awg pi ma kaz nag lehq yuhq chehd che yaog. Yawd ved awg lawn Yer suq haq i hehd har naq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yer suq lag lehq, yad mid u ve laq kuhr haq yug lehq tuag vid che yaog. Yawd ved kaz nag che na vehr lehq, yawd i hehd haq te car te taw vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Muhd ni kehg vehr lehq muhd sux naz vehr tez huh, nag che guhg che chaw awg gha lia he lehq ned geh che chaw teq pa haq Yer suq chehd lo sir veha lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Med yad awg gha lia ghaz mir khuh awg pad huh phoz chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A nar laex ceng te nag chehd che chaw kha peh haq yawd ghu na vid lehq, ned teq pa haq liz ghaq kog vid che yaog. Ned teq pa yawd haq sir cheaq te lehq Yer suq i hehd haq tawd maq yaw cuh vid. ");
INSERT INTO lhi_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Muhd sawx ted naq, muhd ma thid ser huh, Yer suq tuag lehq heh pir khuhn kae lehq, u huh bon lawg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sid monr he lehq yawd geh chehd che awg chawd teq pa Yer suq haq ghaq ca che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","I hehd Yer suq haq mawg che te yand, “Chaw awg gha lia nawg haq ca chehd che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yer suq i hehd haq koz vid che, “Awg pad awg ki huh cawg che med khaz teq pa haq liz ngag bon gha mar vid tug awg nuz awr kae veg. Awg lawn ghod ver, che kheh te tug ngag lag che yaog,” lehz yawd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Gar liq lehd muhd mig awg kag gha lia i hehd ve bon lawg kig teq pa awg khuhn yawd bon ca mar vid lehq, ned teq pa haq ghaq kog che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Khir tuq var te ghad yawd geh lag lehq nar kheh teh mi lar lehq koz che, “Nawg te gad ver, ngag haq daq vid kehg vid tug nawg te gha che yaog,” lehz Yer suq haq lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yer suq yawd haq har kax lehq laq kuhr che lehq yawd haq vad lehq koz che, “Ngag te gad che yaog. Daq vid kehg vid-og,” lehz koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Teq pear lehax khir tuq a nar mehx vehr lehq yawd daq vehr kehg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yer suq yawd haq tawd hehnd chawa koz vid che, “Awg lawn che ve chaw te ghad-eg haq liz ta ca koz vid. Nawg kae lehq paw khod haq nawg ved awg ton ca maw vid-eq. Su mehz khuhd suhr huh sax khiz te tug, nawg daq vehr kehg vehr che awg pun Mod ser ve awg lid teh lar che heh, te tand tug ca tand vid-eq,” lehz Yer suq koz vid lehq teq pear lehax yawd haq koeq pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kheh ma khuhd, yawd tuhz veh lehq awg lawn u ve haq hax ceh nux ca kaod koz vid lehq, awg kag gha lia awg khuhd buhg veh vid tug te che yaog. Kheh te cheaq te lehq Yer suq awr lehr med teq pa khuhn kha sehax phawd thi mehz thi ba ba te tod maq gha lehq, heh pir khuhn chehd chehd che yaog. Khar phawd chor phawd lo chehd che chaw teq pa yawd chehd lo lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","U ve khaz nuhr maq muh tand, Yer suq Kar per nar unr med awg khuhn te pawz kawq gehe lehq, yehg ted yehg awg khuhn yawd chehd chehd che awg lawn haq su gha kad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Chaw phoz lag mad jad che haq te lehq yehg khuhn chehd kig mad cawg lehq, ghaz mir awg pad huh liz chehd kig mad cawg. Yer suq i hehd haq bon khuhd mar vid chehd thad, ");
INSERT INTO lhi_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","khi kud laq kuhr suh vehr che chaw te ghad haq chaw uhg ghad taz veha lehq yawd chehd huh lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Chaw chehd mad che haq te lehq, Yer suq chehd lo i hehd gehe mad gag lehq, Yer suq chehd chehd che awg thang huh beh lar che haq i hehd phaz kha che yaog. Kheh te lehq phaz kha lar kig huh, khi kud laq kuhr suh che chaw yuhq chehd che yuhq phi haq i hehd phehd yaq pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yer suq awr lehr i hehd yonr che ni ma haq gha mawg che te yand, khi kud laq kuhr suh vehr che chaw haq, “Yad par-og, nawg ved vend bax phehd kha vehr che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Liq buhq var ted pehg pehar u huh mi chehd lehq, a sug yawd ved ni ma khuhn che kheh duhd chehd che, ");
INSERT INTO lhi_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Che phad awr lehr, a thoq te che kheh koz cheawg le. Yawd Ghig sa haq maq sawnr ma caz koz che yaog. Ghig sa te ghad ma hez ver, vend bax haq a sug phehd kha gha tuawg le.” ");
INSERT INTO lhi_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","I hehd che kheh duhd chehd che haq Yer suq yawd ved ni ma khuhn teq pear lehax sir lehq, i hehd haq koz vid che, “Nig hehd ni ma khuhn a thoq te che kheh duhd chehd cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Khi kud laq kuhr suh che chaw te ghad haq tawd khar ve te khuhd a cehax koz vid ver sa hawg le. Nawg ved vend bax phehd kha vehor lehd koz vid che sa hawg la. Ma hez ver, Tu lehq nawg ved yuhq phi haq taz ve lehq yaq kaw tod kae-o lehd koz vid che sa hawg la. ");
INSERT INTO lhi_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kheh te cheaq te lehq, chaw yad ve Yad phu awr lehr, mig gig khod-aq lo vend bax phehd kha tug kand pax cawg che haq nig hehd gha sir vid tug,” lehd koz peg lehq, khi kud laq kuhr suh che chaw haq kawq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ngag nawg haq koz ax laq, tu lor. Nawg ved yuhq phi haq taz ve lehq nawg ved yehg lo koeq lor,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Awg yand u ve haq yawd teq pear lehax tu lehq, yuhq phi haq taz ve lehq chaw kheh ma ve mehz khuhd suhr yawd tuhz veh che yaog. Kheh te lehq, chaw kheh ma ve and lehq Ghig sa haq chid ir chid muh vid lehq, “A nig te pawz-a liz che kheh te che haq mad mawg jaw,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","U ve awg khaz nuhr, Yer suq Gar liq lehd ghig po nux pad huh te pawz kawq kae thad huh, chaw awg mor nux yawd chehd lo lag lehq, yawd i hehd haq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yawd awg nuz awr kawq kae tod huh, awg khawnr saw kig yehg awg khuhn Ar lar phehd ve yad par Ler viq mi chehd che haq yawd gha mawg che yaog. “Ngag khaz nuhr ghaq lar-oq,” lehz Yer suq yawd haq koz vid che te yand, yawd tu lehq Yer suq khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Awg khaz nuhr, Ler viq yehg lo Yer suq he lehq yawd ved awg laq ghuhd teq pa teh cuh pad huh mi cad chehd-ag huh, awg khawnr saw var he lehq vend bax yad teq pa liz kha peh i hehd geh mi cad chehd che yaog. Awg lawn ghod ver, i hehd kha peh Yer suq awg khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Awg khawnr saw var he lehq awg kag awr ve vend bax yad teq pa geh yawd awr cad chehd che haq, Phar rir sehd teq pa ve liq buhq var teq pa gha mawg che te yand, yawd ved awg laq ghuhd teq pa haq koz vid che, “Che phad awr lehr, a thoq vawr te lehq awg khawnr saw var he lehq vend bax yad teq pa geh teq geha cad cheawg le,” lehz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tawd u ve haq Yer suq gha kad thad, yawd i hehd haq kawq koz vid che, “Chehd sa che chaw teq pa naz chuhd sehr phad haq maq lor. Nag che chaw teq pa lehax lor che yaog. Thed che cawd che chaw teq pa haq kug yug tug ngag lag che ma hez. Vend bax yad teq pa haq kug yug tug ngag lag che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Awg yand u ve awg khuhn, Yod hanr ve awg laq ghuhd teq pa he lehq Phar rir sehd teq pa cad tug ce lehq bon lawg chehd che yaog. Kheh te lehq, su Yer suq chehd lo lag lehq koz che, “Yod hanr ve awg laq ghuhd teq pa he lehq Phar rir sehd teq pa ve awg laq ghuhd teq pa cad tug ce chehd liz, a thoq maq vawr te lehq nawg ved awg laq ghuhd teq pa cad tug maq ce cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yer suq i hehd haq kawq koz vid che, “Awg mid ma he che phad khehx cad-ag che chaw teq pa geh chehd-ag huh, i hehd cad tug ce tug lehq la. Yawd i hehd geh chehd che kheh ceh, i hehd cad tug ce maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kheh ma khuhd, awg mid ma he che phad haq khehx cad-ag che chaw teq pa geh yug phaz vid che awg ni lag gag tug yaog. U ve teq ni gaeg ver, i hehd cad tug ce tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Beg ke awg pir haq pha awg suhx a sug liz maq nehx jaw. U kheh te nehx ver, pha awg suhx awr lehr awg pir haq ghawg coer vehr lehq, lex lehq kawq pheq jad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kheh te lehq, sar gig thux pu awg pir awg khuhn a pehx med ghig awg suhx a sug liz maq ke jaw. U kheh te ke ver, a pehx med ghig awg suhx awr lehr, sar gig thux pu haq te khod cheaq te lehq, a pehx med ghig sez vehr lehq, sar gig thux pu liz lug vehr che yaog. A pehx med ghig awg suhx haq sar gig thux pu awg suhx awg khuhn gha ke che yaog,” lehz Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sa ba to awg ni teq ni awg khuhn, Yer suq ha khuhn phanr kae chehd-ag huh, yawd ved awg laq ghuhd teq pa cag no haq chehz yug lehq veh tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Phar rir sehd teq pa yawd haq koz vid che, “Ngawx-oq, Sa ba to awg ni thad liz te maq kenr te ma cawd che haq i hehd a thoq vawr te lehq te cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yer suq i hehd haq kawq koz vid che, “Dar viq he lehq yawd ved awg chawd teq pa awr meq lehq cad tug mad cawg che te yand, i hehd khawd-ehg kheh te che awg lawn haq nig hehd teq pawz-a liz maq gha ghawn jaw lehq la. ");
INSERT INTO lhi_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ar bir ar tar paw khod nux te chehd-ag huh, Ghig sa ve yehg awg khuhn Dar viq gehe lehq, paw khod teq pa ma hez ver te ghad-eg liz cad maq kenr cad ma cawd che, Ghig sa haq tand lar che khaor mod haq cad lehq, awg chawd teq pa haq liz pehg car vid che ma hez lehq la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Kheh te lehq yawd kawq koz che, “Sa ba to awg ni awr lehr chaw yad awg pun te lar che yaog. Chaw yad awr lehr, Sa ba to awg ni awg pun te lar che ma hez. ");
INSERT INTO lhi_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kheh te lehq, chaw yad ve Yad phu awr lehr, Sa ba to awg ni ve awg jawd mawd liz phehq che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yawd bon lawg kig khuhn kawq gehe che te yand, u huh laq kuhr teq pax suh che chaw te ghad chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yer suq haq vend bax tar gha tug, Sa ba to awg ni haq chaw nag u ve haq yawd ghu na vid tug lehq nar, i hehd yawd haq kha nehax ngawx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yawd awr lehr, laq kuhr teq pax suh che chaw haq, “Nawg tu lehq awg kaw jen ca hox laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kheh te peg lehq yawd i hehd haq koz vid che, “Sa ba to awg ni haq daq tug te cawd hawg la, ma hez ver lug tug te cawd hawg la. Su ved a saq haq pong vid cawd hawg la, ma hez ver dawz vehr cawd hawg la,” lehd koz na ngawx che yaog. Kheh ma khuhd, i hehd taq chuhax gawr lehd chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yer suq nez nag lehq i hehd haq kha sehax caw ngawx che yaog. I hehd ni ma heh cheaq te lehq yawd duhd har lehq, chaw u ve haq, “Nawg ved laq kuhr cheo,” lehd koz vid che yaog. Awg yand u ve haq, yawd laq kuhr che lehq na vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kheh te lehq, Phar rir sehd teq pa tuhz veh lehq, Yer suq haq khawd-ehg kheh te ver gha dawz vehr tug, teq pear lehax Her roq ve chaw teq pa geh ca jehg daeq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yer suq yawd ved awg laq ghuhd teq pa geh Gar liq lehd ghig po nux phawd awr lo kawq kae lehq, Gar liq lehd muhd mig khuhn chehd che chaw awg mor nux yawd khaz nuhr ghaeq che yaog. Kheh te lehq, Yud daq muhd mig, ");
INSERT INTO lhi_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yer ruq sar lehnr med, Id du mehd muhd mig, Yawd danr lawg kax ox pax awr he lehq Tud ruq med he lehq Sid donr med lo chehd che chaw teq pa liz, yawd te che kanx teq pa awg lawn gha kad cheaq te lehq, yawd chehd lo lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Chaw awg mor nux yawd haq maq gha biz daq tug, “Huh lawd kor nehax ted mag haq ghu lar-oq,” lehz awg laq ghuhd teq pa haq yawd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Awg lawn ghod ver, chaw nag kha peh haq yawd ghu na vid cheaq te lehq, nag che guhg che chaw teq pa awg gha lia yawd haq gha vad tug, yawd chehd lo hax ceh nux biz daq gehag chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ned chaq chiz teq pa liz, yawd haq gha mawg che te yand, yawd mehz khuhd suhr huh boz cuhx lar lehq, “Nawg awr lehr Ghig sa ve Yad phu yaog,” lehd koz kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yawd ved awg lawn su haq maq gha sir vid tug, Yer suq i hehd haq tawd hehnd chawa yaw vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kheh te peg lehq, Yer suq keh thag lo taez che yaog. Yawd kug gad che chaw teq pa haq kug yug lehq, i hehd yawd geh kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","15","I hehd awg khuhn, yawd geh chehd vid tug, ha lehg che bon khuhd ca mar vid tug, ned teq pa haq ghaq kog gha che kand pax pid tug, Yer suq yawd ved awg laq ghuhd te tug chaw teq chi ni ghad haq lez yug che yaog. Awg laq ghuhd teq chi ni ghad che teq pa awr lehr, cuh yad lehd Yer suq i hehd haq koz meh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yer suq kug yug lar che chaw teq chi ni ghad u ve teq pa awr lehr, Yer suq awg meh awg suhx Per troq lehd koz meh vid che Sid monr, ");
INSERT INTO lhi_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yer ber dehd ve awg yad par Yar koq, Yar koq ve awg nax var Yod hanr, (ix mag haq awg meh awg suhx Bawd ner gehq meh vid che, cuhx kig awr lehr, muhd tawnr yad lehd koz gad che yaog), ");
INSERT INTO lhi_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anr drehr, Phid liq, Bar thawd lar mehd, Mar thehr, Thod maq, Ar lar phehd ve awg yad par Yar koq, Thar dehd, muhd mig haq haq che awg mor haq caz daq che chaw Sid monr he lehq ");
INSERT INTO lhi_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yer suq haq chid aq vid che phad Yud daq Id sar kar rir oq teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Awg yand u ve haq, yawd yehg khuhn gehe che yaog. Chaw awg mor nux te pawz kawq phoz lag cheaq te lehq, i hehd awr liz cad ma tand che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Awg lawn u ve haq yawd ved awg ceng awg khad teq pa gha kad che te yand, Yawd ghud vehr che yaog lehz i hehd koz lehq kae lehq yawd haq ca sir khuhq veha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yer ruq sar lehnr med lo yaq che liq buhq var teq pa koz che, Yawd awr lehr Ber sar bud laq geh chehd che chaw phehq che yaog. Ned jawd mawd haq ghad va lehq ned teq pa haq yawd ghaq kog che yaog lehz i hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yawd i hehd haq kug lehq, tawd par hax te mar lehq koz che, “Sar tanr awr lehr Sar tanr haq khawd-ehg kheh te ghaq kog gha tuawg le. ");
INSERT INTO lhi_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Muhd mig te pez, yawd khad yawad ma cawd maq hawr daq ver, muhd mig u ve yeg maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yehg ka liz, yawd khad yawad ma cawd maq hawr daq ver, yehg ka u ve yeg chehd maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sar tanr yawd awg ton haq yawd kawq phuhz lehq phaz daq che ver, yawd liz yeg chehd maq gha. Yawd lug vehr sez vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Awg ghad hehnd che chaw haq awg kawd maq pheh teh lar ver, a sug lehd ma koz yawd ved yehg awg khuhn gehe lehq yawd ved med nged jeg kor haq hinx yug maq gha. Awg ghad hehnd che chaw haq pheh teh lar peg nuhr heh, yawd ved yehg khuhn lo gehe lehq med nged jeg kor haq hinx yug gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ngag nig hehd haq awg cehg mag koz ax laq, chaw yad teq pa te che vend bax awg gha lia he lehq Ghig sa haq maq sawnr ma caz kha koz kha yaw che awg gha lia haq phehd vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kheh ma khuhd, Daq che kehg che Awg ha phu haq maq sawnr ma caz koz che chaw a sug te ghad haq lehd ma koz, khar thad liz vend bax ma phehd vid hawg. Yawd co co taer taer vend bax cawg chehd che chaw phehq che yaog,” lehz Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yawd ned chaq chiz cawg che lehz i hehd koz cheaq te lehq, Yer suq che kheh koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Awg yand u ve haq, Yer suq ve awr ye he lehq awg nax var teq pa lag che yaog. I hehd awg bag phawd awr hox lar lehq Yer suq haq ca kug pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chaw awg mor nux yawd haq kha caw yuhd mi chehd che yaog. I hehd yawd haq koz vid che, “Nawr ye he lehq nawg nax var teq pa nawg haq ca lehq awg bag phawd awr huh chehd chehd che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yer suq kawq koz che, “Ngar ye he lehq ngag nax var teq pa a suawg le,” lehz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kha caw yuhd mi chehd che chaw teq pa haq yawd caw ngawx lehq koz che, “Chuhr huh chehd che chaw awr lehr, ngar ye he lehq ngag nax var teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ghig sa ve a lor haq kha te che chaw awr lehr, ngag nax var ngag nax ma he lehq ngag ved awr ye phehq che yaog,” lehz Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Te pawz ghig po nux pad huh Yer suq kawq mar vid chehd-ag huh, chaw awg mor nux yawd chehd lo phoz lag cheaq te lehq, ghig po khuhn chehd che huh lawd kor khuhn yawd geh mi che yaog. Chaw awg mor nux awg gha lia awr lehr, ghig puhg pad huh chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Awg yand u ve haq, yawd tawd par hax te lehq, awg lawn laex ceng mar vid che yaog. Yawd mar vid che awg khuhn che kheh koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Na ser. Awg yuhd ser var te ghad awg yuhd ca ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yawd ser che te yand, awg yuhd ted pehg pehar yaq kaw khuhn che lehq, ngaz teq pa ghawz cad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Awg yuhd ted pehg pehar mig sar pad kig huhx meh de khuhn che lehq, mig sar maq nax cheaq te lehq, teq pear lehax yeg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kheh ma khuhd, awg yeg u ve awg chi mad nuhq cheaq te lehq, muhd ni tuhaz ver, huh jad chiz jad lehq nuhr vehr god vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Awg yuhd ted pehg pehar a chud de huh che che yaog. A chud bid iar lehq awg yeg haq hoz cheaq te lehq, awg sir mad nuhq. ");
INSERT INTO lhi_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kheh te peg lehq awg yuhd ted pehg pehar mig khid daq kig khuhn che che yaog. Awg yeg yeg vehr ir vehr lehq, awg sir kha peh nuhaq che yaog. Awg sir sehz chi pun, khuhq chi pun he lehq teq ha pun nuhq mad-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kad tug nar puh cawg che chaw teq pa kha nehax naoq,” lehz yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Awg khaz nuhr su ma chehd che te yand, yawd khaz nuhr ghaq kae che chaw he lehq cuh yad teq chi ni ghad, yawd haq tawd par hax teq pa awg lawn ca na ngawx-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yer suq i hehd haq koz vid che, “Ghig sa ve muhd mig awg lawn khuhd ceh lar che awg ceng teq pa nig hehd haq sir vid gha che yaog. Kheh ma khuhd, maq yonr che chaw teq pa haq awr lehr, awg gha lia tawd par hax lehax gha te mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","A thoq haq te lehq le lehd koz ver, I hehd ngawx chehd liz ngawx mad mawg. I hehd kad chehd liz na maq gha. Che kheh ma hez ver, i hehd kawq phuhz kawaq lehq i hehd ve vend bax phehd kha tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yer suq i hehd haq kawq koz vid che, “Tawd par hax che ve haq nig hehd na maq gha lehq la. Na maq gha ver, tawd par hax awg gha lia haq khawd-ehg kheh te na gha tuawg le. ");
INSERT INTO lhi_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Awg yuhd ser var awr lehr, bon khuhd haq ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yaq kaw khuhn che che awg yuhd awg lawn awr lehr, bon khuhd haq kad liz teq pear lehax Sar tanr lag lehq, i hehd awg khuhn ser lar che bon khuhd haq yug tuhz vehr che haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Huhx meh de lo che che awg yuhd awg lawn awr lehr, bon khuhd haq gha kad lehq, teq pear lehax ha lehg ha ka haq yug che haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kheh ma khuhd, i hehd awg chi mad cuhx nuhq cheaq te lehq, teq cuhx nehax lehax teq che yaog. Awg khaz nuhr bon khuhd haq te lehq duhd har gad har lehq du deh che haq gha phud daq thad, teq pear lehax i hehd ve yonr che ted ceng lug veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","A chud de lo che che awg yuhd awg lawn awr lehr, i hehd bon khuhd haq kad che liz, ");
INSERT INTO lhi_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mig gig khod-aq ve duhd har tug teq pa, phu si med nged jeg kor ha lehg tug her ka che teq pa he lehq lawd phaq ir che awg ceng gha lia haq sex lae che teq pa awr lehr, bon khuhd haq hoz lar cheaq te lehq, awg sir nuhaq maq gha che haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mig khid daq kig khuhn che che awg yuhd awg lawn awr lehr, bon khuhd haq kad lehq haq yug lehq, awg sir sehz chi pun, khuhq chi pun, teq ha pun nuhaq che chaw haq koz che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kheh te peg lehq Yer suq i hehd haq koz vid che, “A mir khehd tox lehq khuhr luhd cuhr muhq lar tuawg la. Ma hez ver, tehn huhx teh lar tuawg la. A mir khehd teh kig awg thang huh teh lar tug ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Awg lawn ghod ver, kha khuhd ceh lar che awg ceng teq pa kha sehax saw mawg vid tug yaog. Su haq maq sir vid che awg ceng teq pa liz, awg ghiz pawd kig huh mawg vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kad tug nar puh cawg che chaw a sug lehd ma koz, kha nehax naoq,” lehd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Kheh te lehq, yawd i hehd haq koz vid che, “Nig hehd kha gha kad che teq pa haq sa tiq tar-oq. Nig hehd kawg vid che heh te lehq, Ghig sa liz nig hehd haq kawq kawg ax tug yaog. Awg khod-aq, awg lex liz kawq thehnr ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Awg lawn ghod ver, cawg che chaw haq kawq thehnr vid tug yaog. Mad cawg che chaw geh, yawd kha cawg che teq pa haq kawq yug ve tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yer suq te pawz kawq koz che, “Ghig sa ve muhd mig awr lehr, chaw te ghad ha khuhn lo awg yuhd ser che haq sur che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yawd muhd phiq yuhq lehq muhd sawx kawq tuag lehq, ni gha lia u kheh te chehd che yaog. Awg yuhd u ve yeg lehq ir veh che yaog. Kheh ma khuhd, awg yuhd u ve khawd-ehg kheh te yeg veh ir veh che haq yawd maq sir. ");
INSERT INTO lhi_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mig gig yawd khad yawad awg sir nuhaq vid che yaog. Awg kawd maq awg yeg yeg vid lehq, awg khaz nuhr awg no phehaq peg lehq awg no awg khuhn awg sir nuhq vehr mag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Meh vehr lehq ghiq che awg yand gag vehr cheaq te lehq, awg sehr phad teq pear lehax ghiq kawx yug lehq ghiq che yaog,” lehz Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kheh te lehq yawd koz che, “Ghig sa ve muhd mig haq a thoq yug tehz daq ngawx tuawg le. Tawd par hax khar ve ted ceng yehd lehq tehz mar tuawg le. ");
INSERT INTO lhi_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ghig sa ve muhd mig awr lehr, a ghawd yuhd haq sur che yaog. Awg yuhd u ve haq ha khuhn ser che te yand, mig gig thang kha cawg che awg yuhd awg gha lia haq keh i liz, ");
INSERT INTO lhi_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ser peg khaz nuhr awg yeg yeg veh ir veh lehq, ghawd phaq muhg nuha awg gha lia haq keh ir che yaog. Awg kax teq pa ir veh lehq, muhd-aq lo pog che ngaz teq pa muhd cha seh kig huh awg phi te gha che yaog,” lehz Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","I hehd na gha che heh lehax, che kheh te che tawd par hax kha peh Yer suq i hehd haq bon khuhd mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tawd par hax ma yehd ver, yawd i hehd haq maq mar vid. Kheh ma khuhd, yawd ved awg laq ghuhd teq pa lehax chehd che te yand, yawd i hehd haq awg lawn che teq pa awg gha lia kha nehax koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","U ve teq ni muhd phiq vehr huh, “Ox pax awr lo khanr kae veg,” lehz Yer suq yawd ved awg laq ghuhd teq pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kheh te lehq chaw awg mor nux haq i hehd phaz daq lar haz lehq, Yer suq chehd chehd vehr che huh lawd kor khuhn i hehd yawd haq sir ve veh che yaog. Awg kag awr ve huh lawd kor teq pa liz i hehd geh kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Awg yand u ve haq, muhd huh nux mez lag lehq, a kaz duhd teq pa huh lawd kor khuhn thinr gehag cheaq te lehq, huh lawd kor awg khuhn a kaz peh vehr tez che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yer suq awr lehr huh lawd kor awg mehr mi phawd awr u gehd cuhx lehq, yuhq mir ka chehd che yaog. Kheh te lehq, awg laq ghuhd teq pa yawd haq ca hiz nuhr vid lehq, “Sar lar-og, ngag hehd lug vehr tug haq nawg a cehax liz ma duhd ngawx lehq la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yer suq tuag lehq muhd huh haq ded vid lehq, ghig po haq, “Taq hiax gawr lehd chehd-oq,” lehd koz vid che yaog. Muhd huh dehg vehr lehq, taq hiax gawr lehd chehd vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Awg yand u ve haq Yer suq koz che, “Nig hehd a thoq haq te lehq kuhz cheawg le. Nig hehd yonr che ni ma mad cawg lehq la,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","I hehd kuhz jad lehq, te ghad he lehq te ghad koz daq che, “Che phad a suawg le. Muhd huh he lehq ghig po liz yawd ved tawd khuhd haq na yug che law,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kheh te lehq, ghig po nux ox pax awr, Gar dar raq muhd mig lo i hehd gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yer suq huh lawd kor awg khuhn tuhaz huh, ned chaq chiz geh che chaw te ghad awr lehr, teq pear lehax chaw tur phuh huh tuhaz lehq yawd haq ca mawg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chaw u ve awr lehr, chaw tur phuh teq pa cawg kig huh lehax chehd chehd che yaog. Chaw te ghad-eg liz yawd haq pheh teh lar maq gha. Son caz yug lehq pheh teh lar liz maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Awg lawn ghod ver, laex pawz su yawd haq son kawng son caz yug pheh teh lar liz, yawd son caz haq ghawg chez lehq, son kawng haq uhx theh che yaog. Chaw te ghad-eg liz yawd haq mend vid tug te maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tur phuh teq pa huh lehd ma koz, keh dig thag huh lehd ma koz, muhd kaw muhd phiq khar thad liz yawd kug chehd che yaog. Yawd awg ton haq liz, huhx meh sir yug lehq gi thur-e chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yer suq vid-aq lo lag tod che haq chaw u ve gha mawg che te yand, yawd chehd lo cex lag lehq yawd haq a kor pi che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Yawd awg khuhd hehnd chawa kug lehq koz che, “Muh jad che Ghig sa ve Yad phu Yer suq-og, nawg ngag haq khawd-ehg kheh caz daq lehq le. Nawg ngag haq maq gha du deh tug, Ghig sa mehz khuhd suhr huh ngag nawg haq lawg khawx che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Awg lawn ghod ver, “Ned chaq chiz-og, yawd awg khuhn tuhz kae-o,” lehz Yer suq yawd haq koz vid cheaq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","“Nawg a thoq meh cheawg le,” lehz Yer suq yawd haq na ngawx che te yand, “Ngag hehd mad jad cheaq te lehq, ngag ved awg meh awr lehr Ler junr yaog,” lehz yawd Yer suq haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Muhd mig u ve awg khuhn i hehd haq maq gha ghaq tuhz tug, yawd Yer suq haq hax ceh nux lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Keh u ve awg baq haq, vaq mor nux kaz cad chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kheh te lehq, ned teq pa yawd haq lawg khawx che, “Vaq u ve teq pa awg khuhn ngag hehd gha gehe tug, ngag hehd haq kae peha laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Awg yand u ve haq, Yer suq i hehd haq kae cuh vid che yaog. Ned chaq chiz teq pa tuhz veh lehq vaq u ve teq pa awg khuhn gehe che yaog. Vaq awg mor nux awr lehr, mig har kig lo hax ceh nux cex yaeq lehq, ghig po khuhn lo gehe lehq a kaz ka suh vehr che yaog. Vaq u ve teq pa, a lag kheh niq hinx kheh cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vaq huhx var teq pa cex koeq lehq, awg lawn u ve haq med khaz teq pa awg khuhn ca koz vid che yaog. Kheh te lehq, khawd-ehg kheh phehaq che awg lawn haq gha sir tug, chaw ted pehg ca ngawx-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","I hehd Yer suq chehd lo gaeg che te yand, ned chaq chiz Ler junr geh che chaw te ghad beg ke veq deh lehq mi chehd che haq i hehd gha mawg che yaog. Yawd ved ni ma awg kawd maq thad huh heh te lehq kawq daq vehr che haq liz i hehd gha mawg lehq kuhz jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Gha mawg chehd che chaw teq pa awr lehr, ned geh che chaw awg lawn he lehq vaq teq pa khawd-ehg kheh phehaq che awg lawn, ca ngawx-ag che chaw teq pa haq koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kheh te lehq, i hehd ve muhd mig teq tawn awg khuhn tuhez vid tug, i hehd Yer suq haq lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yer suq huh lawd kor awg khuhn gehe che te yand, ned chaq chiz geh jaw che chaw che te ghad awr lehr, yawd geh chehd tug lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yer suq yawd haq ma chehd cuh vid. Kheh ma khuhd yawd haq koz vid che, “Nawg yehg lo koeq lehq, Jawd mawd Ghig sa nawg haq khawd-ehg ma ga lar lehq har kax lar che awg lawn, nawg ved awg ceng awg khad teq pa haq ca koz mar vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kheh te lehq yawd tuhz veh lehq, Yer suq yawd haq khawd-ehg taw maq ga lar peg che awg lawn, Der kar pawd liq muhd mig awg khuhn yawd hax ceh nux ca koz mar vid cheaq te lehq, chaw awg gha lia and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yer suq huh lawd kor cind lehq ghig po nux ox pax awr lo kawq khanr kae che yaog. Yawd ghig po pad huh chehd chehd huh, chaw awg mor nux yawd chehd lo phoz lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Awg yand u ve haq, Yar id ruq meh che bon lawg kig huh ve awg hox te che te ghad lag lehq Yer suq haq mawg lehq, yawd ved khi pad huh boz cuhx vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yawd Yer suq haq koz vid che, “Ngag ved yad mid nehax suh vehr tez che yaog. Yawd na vehr lehq a saq gha teq tug, nawg lag lehq yawd awg thag huh laq kuhr a cehax ca tar vid laoq,” lehd koz, hax ceh nux lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kheh te lehq, yawd Yar id ruq geh kae che yaog. Chaw awg mor nux yawd khaz nuhr ghaq kae lehq, yawd haq biz daq caq daq te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Teq chi nid khuhq kheh taw awg suhr yaq don chehd che yad mid te ghad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Naz chuhd ghu vix var laex ghad ve laq kuhr awg khuhn yawd laex ceng gha khanr jad peg che yaog. Yawd kha cawg che awg gha lia haq yehd vehr peg liz, yawd a cehax liz maq na che awg khod-aq, a nar u ve sang te sang kawq jad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Yawd Yer suq awg lawn gha kad jaw che yaog. Kheh te lehq, chaw awg mor nux awg khuhn yawd Yer suq kuhr tehx nuhr phawd awr huh lag lehq, yawd ved beg ke haq ca vad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Awg lawn ghod ver, “Yawd ved beg ke haq lehax ngag gha vad ver, ngag na vehr tug yaog,” lehz yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Awg yand u ve haq, yawd awg suhr yaq chehd che teq pear lehax cheh vehr lehq, yawd na vehr che haq yawd awg ton sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yer suq yawd ved awg ton awg khuhn kand pax tuhz veh che haq teq pear lehax gha sir cheaq te lehq, chaw awg mor nux haq yawd phuhz ngawx lehq, “Ngag ved beg ke haq a sug vad cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yawd ved awg laq ghuhd teq pa awr lehr, “Chaw awg mor nux nawg haq biz daq caq daq te chehd che haq nawg mawg chehd liz, ‘Ngag haq a sug vad cheawg le,’ lehd koz na ngawx cheawg la,” lehz Yer suq haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yawd haq vad lar che chaw haq gha mawg tug Yer suq kha sehax caw ngawx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yad mid u ve awr lehr, yawd awg khuhn khawd-ehg kheh phehaq che awg lawn haq sir cheaq te lehq, yawd kuhz ched chehd che yaog. Yawd Yer suq chehd lo lag lehq yawd mehz khuhd suhr huh boz cuhx lar lehq, awg lawn awg gha lia yawd haq thed-e ghad koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yer suq yawd haq koz vid che, “Yad mid-og, nawg yonr che ted ceng awr lehr, nawg haq na tug tea vehr che yaog. Duhd sa che awg khuhn koeq lor. Nawg haq chehd sa tug kha sehax tea vehor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yawd u kheh koz chehd-ag huh, bon lawg kig huh ve awg hox te ghad ve yehg lo lag che chaw teq pa koz che, “Nawg ved yad mid suh vehor. A thoq te Sar lar haq kawq soq saq vid cheawg le.” ");
INSERT INTO lhi_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tawd khuhd u ve haq Yer suq maq na he lar lehq bon lawg kig huh ve awg hox te ghad haq, “Ta duhd har. Yonr che lehax teo,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Per troq, Yar koq he lehq Yar koq awg nax var Yod hanr, i hehd seh ghad ma hez ver, awg kag awr ve chaw te ghad-eg haq liz yawd khaz nuhr mad ghaq lag cuh vid. ");
INSERT INTO lhi_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Yawd bon lawg kig huh ve awg hox te ghad ve yehg huh gaeg che te yand, su diz diz huhd huhd te lehq, hax ceh nux huhg lehq paz huhg chehd che haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yer suq yehg khuhn gehe lehq, “Nig hehd a thoq te diz diz huhd huhd te lehq huhg chehd cheawg le. Chaw yad nehax che suh che ma hez. Yawd yuhq mir ka chehd che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Awg yand u ve haq, i hehd Yer suq haq phoz ghig che yaog. Yer suq i hehd awg gha lia haq ghaq tuhz pe lehq, chaw yad nehax ve awr pa awr ye he lehq yawd geh lag che chaw teq pa haq sir ve lehq, chaw yad nehax teh lar kig huh gehe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Awg yand u ve haq, Yer suq yad mid nehax ve laq kuhr haq yug lehq koz che, “Tar lid tar kug miz.” Tawd u ve cuhx ki awr lehr, “Yad mid-og, ngag nawg haq koz ax laq, tu laoq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Awg yand u ve haq, yad mid nehax u ve teq pear lehax tuag lehq, yaq kaw tod veh che yaog. Awg lawn ghod ver, yawd a saq teq chi nid khuhq gag vehr che yaog. Chaw u ve teq pa duhd ma tuhz lehq and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Awg lawn u ve haq su te ghad-eg liz maq gha sir vid tug, Yer suq i hehd haq kha sehax tawd pid peg lehq, “Yad mid nehax haq cad tug car vid-oq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yer suq u huh tuhz veh lehq yawd chehd jaw che med lo kawq gag vehr che yaog. Yawd ved awg laq ghuhd teq pa liz yawd khaz nuhr ghaq kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sa ba to awg ni gaeg lehq bon lawg kig awg khuhn yawd mar vid che yaog. Gha kad che chaw laex ghad and jad lehq koz che, “Chaw che phad awr lehr, kheh te che awg ceng teq pa haq khar lo gha cheawg le. Yawd gha che cud yiq awr lehr, khawd-ehg kheh ve cud yiq awg le. Kheh taw maq kand pax ir che kanx yawd laq khuhn khawd-ehg kheh te phehaq cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yawd awr lehr, Mar riq ve yad par a suhz te che laq med te var phehq che ma hez hawg la. Yar koq, Yod sehq, Yud daq, Sid monr teq pa ve awg vix var ma hez hawg la. Yawd awg nax ma teq pa liz, a nig geh chehd che ma hez hawg la,” lehd koz lehq, i hehd yawd haq nez nag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yer suq i hehd haq koz vid che, “Ghig sa ve cuh kar var te ghad awr lehr, awg mig awg phond cawg che yaog. Kheh ma khuhd, a sug yawd chehd jaw kig, a sug yawd ved a vix a nax he lehq a sug yawd ved yehg awg khuhn awr lehr, awg mig awg phond mad cawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chehd har che chaw ted pehg pehar awg thag huh laq kuhr tar lehq ghu na vid che lehax ma hez ver, u huh kand pax ir che kanx awg kag awr ve haq yawd te maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","I hehd maq yonr vix cheaq te lehq, yawd and jad che yaog. U ve khaz nuhr, yawd te khaz peg te khaz lo kha sehax saw caw kae lehq bon mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Awg yand u ve haq, cuh yad teq chi ni ghad haq yawd kug yug lehq, ni ghad ted kag ni ghad ted kag kae pe che yaog. Ned chaq chiz teq pa haq ghad tug, i hehd haq kand pax pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jud fir tag ted tag ma hez ver, yaq kaw kar huh awg pun awg kag awr ve teq chaweh tad yug ve kae. Laq sax liz, khaor mod liz ta puhd ve kae. Sehx hang caz khuhn lo phu ta doz puhd kae. ");
INSERT INTO lhi_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Khi noz cuhx lehq, a poq te khoz lehax deh ve kae-o lehz, Yer suq i hehd haq tawd pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yer suq i hehd haq kawq koz vid che, Khar ve ted kag lehd ma koz, su ved yehg khuhn nig hehd gehe che te yand, khaz u ve awg khuhn lo ma tuhz kae ser che kheh ceh, u ve ted yehg awg khuhn lehax chehd laor. ");
INSERT INTO lhi_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Khar ve ted kag huh lehd ma koz, nig hehd haq mad haq yug lehq nig hehd ve tawd khuhd haq maq na che ver, u huh nig hehd tuhz kae che te yand, i hehd haq sax khiz te mar vid tug, khi ho haq hehr chehd che a jeq mia haq tha kha lar haz-oq lehz, i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kheh te lehq i hehd tuhz kae lehq, Chaw yad teq pa awr lehr a sug yawd ved vend bax haq duhd phuhz cawd che yaog lehd koz bon mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","I hehd ned kha peh haq ghaq kog lehq, nag che guhg che chaw kha peh haq nag mand puhr vid lehq ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Awg yand u ve haq Yer suq awg lawn buhg veh jad cheaq te lehq, jawd mawd Her roq gha kad che yaog. Chaw ted pehg pehar koz che, “Baz tiz sar pehar var Yod hanr suh kig lo kawq teaq vehr che yaog. Kheh te cheaq te lehq, kand pax ir che kanx che teq pa haq yawd te gha che yaog.” ");
INSERT INTO lhi_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Chaw ted pehg pehar koz che, “Yawd awr lehr Ed lid yaq yaog.” Awg kag awr ve teq pa koz che, “Yawd awr lehr a mig thad lo Ghig sa ve cuh kar var teq pa haq sur che cuh kar var te ghad phehq che yaog.” ");
INSERT INTO lhi_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jawd mawd Her roq gha kad lehq, “Chaw cheawg lehr, ngag kuhr tawz vehr che Yod hanr yaog. Yawd suh kig lo kawq teq tuag vehr che,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Awg lawn che awr lehr che kheh yaog. Jawd mawd Her roq ve awg nax var Phid liq ve awg mid ma Her ror diq haq jawd mawd Her roq he che yaog. Yad mid u ve haq te lehq, yawd ved chaw haq phehd vid lehq Yod hanr haq pheh yug lehq thawnr khuhn ke lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","A thoq maq vawr te lehq le lehd koz ver, Nawg nax var ve awg mid ma haq nawg he ma cawd lehz, Yod hanr jawd mawd Her roq haq koz vid cheaq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Kheh te cheaq te lehq, Her ror diq Yod hanr haq nez nag lehq cand jad lehq dawz vehr gad che yaog. Kheh ma khuhd, dawz vehr maq gha ser. ");
INSERT INTO lhi_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Awg lawn ghod ver, Yod hanr awr lehr thed che cawd che daq che kehg che chaw phehq che haq jawd mawd Her roq sir cheaq te lehq, yawd haq kuhz lehq kha nehax haq sax chehd che yaog. Yod hanr mar vid che tawd khuhd haq jawd mawd Her roq gha kad che te yand, yawd ni ma soq saq jad chehd che liz, ha lehg ha ka na gad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jawd mawd Her roq paw che haq duhd nuhd tug pawehd te che awg ni kawq gag vehr lehq, yawd awr lehr yawd awg huhx ve jawd mawd teq pa, maq yad ve awg hox teq pa he lehq Gar liq lehd muhd mig awg khuhn ve awg hox awg nax teq pa haq kug lehq thi cad thi dawg che yaog. Awg yand cawd cheaq te lehq, ");
INSERT INTO lhi_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Her ror diq ve awg yad mid gehe lehq pawehd te mar vid che te yand, jawd mawd Her roq he lehq yawd geh mi cad chehd che chaw teq pa ni ma cawd jad che yaog. Kheh te lehq jawd mawd Her roq yad mid haq koz vid che, “Nawg he gad che heh lawr-oq. Ngag nawg haq pehar tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kheh te lehq yawd khanr lehq yad mid haq koz vid che, “Nawg kha lawg che teq pa, ngag ved muhd mig te khod kheh taw ngag pehar tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Awg yand u ve haq, yad mid u ve tuhz veh lehq, “Ngag a thoq maq haq gha lawg tuawg le,” lehz yawd ved awr ye haq na ngawx che yaog. Awr ye awr lehr, “Yod hanr A kaz tur var ve a kor haq lawg yur-oq,” lehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kheh te lehq, teq pear lehax yad mid u ve jawd mawd nux geh har naq kawq gehe lehq koz che, “Yod hanr A kaz tur var ve a kor haq a khehd pehz nehz awg khuhn ke lehq ngag haq har naq pehar tug he gad che yaog,” lehd koz lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jawd mawd awr lehr, duhd har jad vehr liz, yawd khanr lar peg cheaq te lehq yawd geh mi cad chehd che chaw teq pa haq te lehq, yawd koz lar che tawd khuhd haq maq te lug gad. ");
INSERT INTO lhi_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Awg yand u ve haq jawd mawd awr lehr, a saq saw var te ghad haq, “Yod hanr ve a kor ca tawz veha laoq,” lehd koz lehq, teq pear lehax kae pe che yaog. Yawd kae lehq, thawnr khuhn Yod hanr ve a kor haq tawz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A kor u ve a khehd pehz nehz khuhn ke veha lag lehq yad mid haq pid che yaog. Kheh te lehq awg yad mid liz, awr ye haq pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yod hanr ve awg laq ghuhd teq pa awr lehr, awg lawn u ve haq gha kad che te yand, i hehd lag lehq yawd ved awg ton haq yug lehq, tur phuh khuhn ca tur vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Awg yand u ve haq, cuh yad teq pa Yer suq chehd lo phoz lag lehq, i hehd kha te kha mar che awg lawn awg gha lia yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Awg yand u ve khuhn Yer suq awr lehr, “Nig hehd teq pa lar-oq. Heh pir khuhn chaw gawg kig huh ghad a cehax ca jehd-eg veg ser,” lehz i hehd haq koz vid che yaog. Awg lawn ghod ver, chaw kha peh yig yig lag lag te chehd cheaq te lehq, i hehd awr liz cad ma tand che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kheh te lehq, i hehd huh lawd kor cind lehq heh pir khuhn chaw gawg kig ted kag huh kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","I hehd tuhz veh che haq chaw kha peh gha mawg gha sir che yaog. Kheh te lehq, khar med chi med lo chehd che chaw teq pa ghig po nux jad huh cex kae lehq, awg kawd gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yer suq huh lawd kor khuhn tuhez che te yand, chaw awg mor nux haq gha mawg che yaog. I hehd awr lehr, yawg huhx var mad cawg che yawg teq pa haq sur cheaq te lehq, yawd i hehd haq har kax lehq awg lawn laex ceng mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Muhd phiq vehr che te yand, yawd ved awg laq ghuhd teq pa yawd chehd lo lag lehq koz che, “Chuhr huh awr lehr heh pir khuhn te lehq, muhd liz phiq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Chaw che teq pa awr lehr, awg pad awg ki huh cawg che khaz khuhn pan khuhn lo kae lehq cad tug ca vig cad-eg tug, i hehd haq phehd vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kheh ma khuhd yawd awr lehr, “Nig hehd teq pa i hehd haq car vid-oq,” lehz i hehd haq kawq koz vid che te yand, awg laq ghuhd teq pa awr lehr, “A nig khaor mod niq ha thehq phuhd ca vig lehq, i hehd haq gha car vid tuawg la,” lehd koz kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yer suq koz che, “Nig hehd geh khaor mod khar nid dig cawg hawg le. A cehax ca ngawx ser,” lehd koz vid che te yand, i hehd ca ngawx peg lehq, “Khaor mod ngad dig he lehq ngad nig kheh cawg che yaog,” lehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Awg yand u ve haq Yer suq awr lehr, “Muhq nuhx-uh ghad te che awg thang huh chaw kheh ma ve haq awg mor awg mor te mi cuh-oq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","I hehd awr lehr, teq ha ghad teq mor, ngad chi ghad teq mor, che kheh te awg mor awg mor te mi che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yer suq khaor mod u ve ngad dig he lehq ngad u ve niq kheh haq yug lar lehq, muhd nuh maq lo chid ngawx lehq bon haq chid muh che yaog. Khaor mod u ve haq yawd khehq peg lehq, chaw kheh ma ve mehz khuhd suhr huh ca chid teh vid tug, awg laq ghuhd teq pa haq pid che yaog. Ngad u ve niq kheh haq liz, chaw awg gha lia haq pehg vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Awg yand u ve khuhn, chaw awg gha lia kha buhz gha cad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Kheh te lehq, cad lex ve khaor mod awg khehq he lehq ngad sar awg pez teq pa haq kawq ghawz che te yand, teq chi niq khuhr luhd kha peh ghad gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Khaor mod haq cad che chaw teq pa, haw khaz chaw mawd lehax ngad hinx ghad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Chaw awg mor nux haq Yer suq phehd vid chehd-ag huh, yawd ved awg laq ghuhd teq pa haq huh lawd kor khuhn har naq gehe vid lehq, ghig po nux ox pax awr Ber sehd daq med lo i hehd haq awg kawd khanr veh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yawd chaw awg mor nux haq phaz daq peg khaz nuhr, bon ca laweg tug yawd kehaq lo taez che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Muhd sux naz vehr huh, huh lawd kor awr lehr, ghig po awg kaw jen lo gaeg che yaog. Yer suq awr lehr, ghig puhg pad huh yawd te ghad lehax chehd lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Muhd huh phawd ma cawd cheaq te lehq, awg laq ghuhd teq pa huh lawd kor ghawz che teq chuhd jad che haq yawd gha mawg lehq, muhd khax seh nar rir pong vehr lehq, Yer suq ghig po thag huh i hehd chehd lo yaq kaw tod kae lehq, i hehd haq pong vehag lehd te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yawd ghig po thag lo yaq kaw tod kae chehd che haq i hehd gha mawg che te yand, chaw ha law lehd duhd lehq, hax ceh nux kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Awg lawn ghod ver, i hehd awg gha lia yawd haq gha mawg lehq kuhz jad che yaog. Yawd teq pear lehax i hehd haq tawd yaw lehq, Ni ma tag vid-oq. Ta kuhz, ngag yaog lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Awg yand u ve khuhn huh lawd kor khuhn yawd i hehd chehd lo gehe lehq, muhd huh dehg vehr lehq, i hehd and jad cehg mag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Awg lawn ghod ver, khaor mod haq and tug te mar che awg lawn i hehd ma duhd sir ma duhd pawnr. I hehd ni ma liz heh chehd ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","I hehd ghig po nux ox pax awr lo khanr kae peg lehq, Ger ner sar rehq muhd mig lo gaeg thad, huh lawd kor haq ghig puhg huh pheh teh lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Huh lawd kor awg khuhn i hehd tuhez lehq, chaw teq pa teq pear lehax yawd haq sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Muhd mig u ve awg khuhn chaw u ve teq pa awg kag gha lia lo cex kae lehq, Yer suq khar lo chehd che haq gha kad liz, chaw nag chaw guhg teq pa haq yuhq phi thag huh taz ve lehq, u huh veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yawd kha gehe kig awg kag gha lia, khaz khuhn lehd ma koz, med khuhn lehd ma koz, pan khuhn lehd ma koz, kax awg pad huh chaw phawng daq kig huh chaw nag teq pa haq su ca yug teh chehd che yaog. Yawd ved a poq awg car med haq lehax gha vad tug, yawd haq lawg khawx lehq, kha vad che chaw teq pa na vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Awg yand u ve haq, Yer ruq sar lehnr med lo lag che Phar rir sehd ted pa he lehq liq buhq var te pehg Yer suq chehd huh phoz lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yawd ved awg laq ghuhd teq pa laq kuhr mad daq kehg lehq awr cad chehd che haq i hehd gha mawg che yaog. Laq kuhr mad daq kehg lehd koz che awr lehr, awg lid cawg che heh laq kuhr ma chuhd che haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Awg lawn ghod ver, Phar rir sehd teq pa he lehq Yud daq chaw awg gha lia, chaw mawd teq pa pid lar che awg lid teq pa heh te lehq, laq kuhr ma chuhd ver, cad tug ma cad. ");
INSERT INTO lhi_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kax ca hox kawaq huh liz, i hehd a kaz ma chuhd peg ver, cad tug ma cad. Kawz khehd, a khehd, kid mawq khu teq pa haq chuhd che awg lid he lehq awg kag awr ve awg lid laex ceng haq i hehd yehd chehd te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Awg yand u ve haq, Phar rir sehd teq pa he lehq liq buhq var teq pa Yer suq haq na ngawx che, “Nawg ved awg laq ghuhd teq pa awr lehr, chaw mawd teq pa awg lid pehar lar che heh a thoq haq te lehq maq te le. Laq kuhr mad daq kehg lehq a thoq te cad tug cad cheawg le.” ");
INSERT INTO lhi_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yer suq kawq koz vid che, “Chaw her ka var teq paog, nig hehd awg lawn Id sar yaq koz lar che tawd khuhd awr lehr cawd jad che yaog. Yawd buhq lar che, ‘Chaw che ted ceng awr lehr, i hehd ve mawq kaw ngag haq yawz yan chehd liz i hehd ve ni ma awr lehr ngag haq vid daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Chaw yad teq pa teh lar che awg lid awg khad teq pa haq mar vid cheaq te lehq, i hehd ngag haq a kor pi che awr lehr, cuhx kig teq chaweh mad cawg,’ lehd koz buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ghig sa pehar lar che tawd khuhd teq pa haq nig hehd chid bag lar haz lehq, chaw yad teq pa ve awg lid teq pa haq nig hehd yug cid chehd che yaog.” ");
INSERT INTO lhi_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yer suq i hehd haq kawq koz vid che, “Nig hehd ve awg lid teq pa haq te gha tug, Ghig sa pid lar che tawd khuhd teq pa haq nig hehd chid bag lar haz gha che law. ");
INSERT INTO lhi_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Awg lawn ghod ver Mod ser koz lar che, Nawg ved awr pa awr ye haq yawz yawz yan yan teo. Kheh te lehq, A sug yawd ved awr pa awr ye haq kha muhd kha na koz che chaw te ghad awr lehr, awg cehg mag gha suh che yaog lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Kheh ma khuhd nig hehd awr lehr, Chaw te ghad ghad yawd ved awr pa awr ye haq, ‘Ngag geh kha cawg che nig hehd gha cawd che med nged teq pa awr lehr, Kawr banr phehq che yaog,’ lehd yawd koz ver, yawd ved awr pa awr ye haq nig hehd a cehax liz mad kawq ga vid cuh. ");
INSERT INTO lhi_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Teq cax peg teq cax chaw yad geh gha che awg lid teq pa haq nig hehd yehd lehq Ghig sa ve tawd khuhd haq te pehz vid che yaog. U kheh te che awg lid laex ceng haq nig hehd te che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Awg yand u ve khuhn, chaw awg mor nux haq yawd chehd lo kawq kug yug lehq koz che, “Nig hehd awg gha lia ngag ved tawd haq na lehq sir-oq. ");
INSERT INTO lhi_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Awg bag phawd awr ve awg ceng awr lehr, chaw yad awg khuhn gehe lehq chaq chiz tug te maq gha. Kheh ma khuhd, chaw yad awg khuhn lo tuhaz che awg ceng awr lehr, chaw yad haq chaq chiz tug te che yaog,” lehz yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chaw awg mor nux haq yawd phaz daq lehq yehg khuhn gehe che te yand, tawd par hax u ve awg lawn yawd ved awg laq ghuhd teq pa yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yer suq i hehd haq kawq koz vid che, “Nig hehd liz na maq gha lehq la. Chaw te ghad awg khuhn, awg bag phawd awr te lehq awg khuhn phawd awr kha gehe che awg ceng gha lia yawd haq chaq chiz tug te maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Awg lawn ghod ver, yawd ved ni ma khuhn lo maq gehe. Yawd ved ux peg awg khuhn gehe lehq, khuhd kog yehg khuhn chid bag vehr che yaog,” lehz yawd koz vid che yaog. (Yawd che kheh koz che awr lehr, cad tug dawg tug awg gha lia daq che kehg che yaog lehd koz gad che yaog.) ");
INSERT INTO lhi_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kheh te peg lehq yawd kawq koz che, “Chaw te ghad awg khuhn tuhaz che awg ceng awr lehr, yawd haq chaq chiz tug te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Awg lawn ghod ver, chaw yad ni ma khuhn lo tuhaz che teq pa awr lehr, haeg che haq duhd che, gid yaq che, su med nged khuhd che, chaw haq dawz vehr che, hax chawd hax paz te che, su ved med nged jeg kor haq sex lae che, awg haeg te che, su haq her ka che, te pong te lex che, khawehx che, maq sawnr ma caz koz che, ni ma ir che muh che, ma duhd ngawx vix che, che teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Haeg che che awg gha lia awr lehr, awg khuhn phawd awr ve tuhaz lehq, chaw yad haq chaq chiz tug te che yaog,” lehd yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Awg yand u ve khuhn, yawd u huh tuhz kae lehq, Tud ruq he lehq Sid donr muhd mig phawd awr lo kae che yaog. Yawd yehg te yehg khuhn gehe lehq, chaw te ghad-eg haq liz maq sir cuh vid gad liz, yawd ca khuhd jaz maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kheh ma khuhd, ned chaq chiz geh chehd che yad mid nehax te ghad ve awr ye awr lehr, teq pear lehax Yer suq awg lawn gha kad lehq, yawd yawd chehd lo lag lehq yawd ved khi pad huh boz cuhx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yawd ved yad mid awg khuhn ned haq ghaq tuhz tug yawd Yer suq haq lawg khawx che yaog. Yad mid u ve awr lehr, Sud rid phid niq muhd mig khuhn chehd che Yud daq chaw ma hez che chaw phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yer suq awr lehr, “Awg yad teq pa haq awg kawd kha buhz ghad car vid ser. Awg yad teq pa ve cad tug haq yug lehq phid teq pa haq car vid ma cawd hawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yad mid kawq koz che, “Jawd mawd-og, nawg koz che awr lehr cawd che yaog. Kheh ma khuhd, phid teq pa awr lehr, chaw yad nehax teq pa cad sez dawg sez lar che haq teh cuh awg huhx lo ghawz cad che yaog,” lehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yer suq awr lehr, “Nawg che kheh koz cheaq te lehq, koeq lor. Nawg ved yad mid awg khuhn ned tuhz veh che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yad mid u ve yawd yehg lo kawq gaeg che te yand, yawd ved yad mid nehax yuhq phi khuhn yuhq chehd che haq liz, ned tuhz veh vehr che haq liz yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","U ve awg khaz nuhr, Yer suq Tud ruq muhd mig khuhn kawq tuhz veh che yaog. Yawd Sid donr muhd mig huh te lehq Der kar pawd liq muhd mig awg kaw jen huh phanr kae lehq, Gar liq lehd ghig po nux huh gag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Awg yand u ve khuhn, nar puh bag lehq tawd kha nehax yaw maq gha che chaw te ghad haq su Yer suq chehd lo sir veha lag lehq, yawd awg thag huh laq kuhr tar tug i hehd yawd haq lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kheh te lehq, chaw awg mor nux khuhn Yer suq yawd haq sir ve tuhez lehq, awg bag lo veh che yaog. Chaw u ve nar puh khuhn yawd ved laq nuh bez ke lehq, cux ghig pheq lehq yawd ved ha lez haq yug hehr vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Awg yand u ve haq, Yer suq muhd nuh maq lo chid ngawx peg lehq har kax jad che khuhn sax nux maz ghawg lar lehq, “Ed phar taq” lehd koz che yaog. Cuhx kig awr lehr, phaw vid-oq lehd koz gad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kheh te lehq, chaw u ve nar puh kad vehr lehq, ha lez awg kud caz nud vehr lehq tawd kha nehax kawq yaw gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Awg lawn che chaw te ghad-eg haq liz maq gha koz vid tug, Yer suq i hehd haq tawd yuhz vid che yaog. Kheh ma khuhd, yawd i hehd haq sang tawr lar chehd liz, i hehd sang lex lehq su haq koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","I hehd teq pa and jad lehq koz che, “Yawd awg gha lia haq kha daq ghad te peor. Nar puh bag che chaw teq pa kad vid tug yawd te lehq, kar che chaw teq pa tawd yaw vix tug liz te che yaog,” lehd i hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Awg yand u ve awg khuhn, chaw awg mor nux kha peh vad-ag kawq phoz lag lehq, i hehd geh cad tug mad cawg. Kheh te lehq Yer suq yawd ved awg laq ghuhd teq pa haq kug phoz lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Chaw awg mor nux che haq ngag har kax che yaog. Awg lawn ghod ver, i hehd ngag geh chehd che sehr ni gag vehr lehq, cad tug teq chaweh liz mad cawg. ");
INSERT INTO lhi_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","I hehd awr meq khod chehd lehq ngag i hehd haq koeq pe ver, yaq kaw kanr huh ghad nud jad tug yaog. I hehd ted pehg pehar vid-aq lo lag che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yawd ved awg laq ghuhd teq pa awr lehr, “Chuhr huh heh pir khuhn chaw kheh ma ve haq kha buhz gha car vid tug khaor mod khar lo ca gha tug awg le,” lehz yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Nig hehd geh khaor mod khar nid dig cawg hawg le,” lehz Yer suq i hehd haq na ngawx che te yand, “Khaor mod suhr dig cawg che yaog,” lehd i hehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Awg yand u ve khuhn, chaw awg mor nux mig kag lo mi tug yawd tawd pid che yaog. Yawd khaor mod u ve suhr dig haq yug lehq bon haq chid muh peg lehq khehq che yaog. Kheh te peg lehq, khaor mod u ve chaw awg mor nux mehz khuhd suhr huh ca chid teh vid tug, yawd ved awg laq ghuhd teq pa haq yawd pid lehq, i hehd liz chaw awg mor nux mehz khuhd suhr huh ca chid teh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","I hehd geh ngad nehax liz a cehax cawg che yaog. Awg bon haq chid muh peg khaz nuhr, “Su mehz khuhd suhr huh ca chid teh vid-oq,” lehz Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","I hehd kha buhz cad peg lehq, cad lex che teq pa haq i hehd kawq ghawz che te yand, suhr khuhr luhd kha peh ghad gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Cad che chaw a lag kheh uhg hinx ghad cawg che yaog. Kheh te peg lehq, yawd i hehd haq koeq pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Teq pear lehax yawd ved awg laq ghuhd teq pa geh huh lawd kor khuhn gehe lehq, Dar lar mar nuq muhd mig lo cind kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Awg yand u ve haq, Phar rir sehd teq pa lag lehq, Yer suq haq tawd ghawg daq che yaog. Yawd haq lawnd ngawx tug, muhd nuh maq ve awg hez yawd geh lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yawd ved ni ma khuhn duhd har jad lehq koz che, “Chaw che teq co awr lehr, a thoq haq te lehq awg hez haq lawg cheawg le. Ngag nig hehd haq awg cehg mag koz ax laq, chaw che teq co haq awg hez ted cear liz maq maw vid,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Awg yand u ve khuhn, Yer suq i hehd haq phaz daq lar haz lehq, huh lawd kor awg khuhn kawq gehe lehq ghig po nux ox pax awr lo cind veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Awg laq ghuhd teq pa khaor mod yug ve kae tug lend lar haz lehq, huh lawd kor awg khuhn i hehd khaor mod ted dig lehax cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yer suq i hehd haq sa tiq pid lehq koz che, “Phar rir sehd ve did he lehq jawd mawd Her roq ve did haq sa tiq te lehq jaw kae-o,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","I hehd awr lehr, “A nig khaor mod mad cawg cheaq te lehq che kheh koz che yaog,” lehz te ghad he lehq te ghad koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yer suq awg lawn u ve haq sir lehq i hehd haq koz vid che, “Nig hehd khaor mod mad yug veha lag che awg lawn haq a thoq haq te lehq koz daq cheawg le. A meha kheh taw nig hehd ma duhd gag ma duhd sir ser lehq la. Nig hehd ni ma heh chehd ser lehq la. ");
INSERT INTO lhi_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nig hehd mehz sir cawg liz mad mawg lehq la. Nar puh cawg liz ma kad lehq la. Nig hehd ma duhd nuhd lehq la. ");
INSERT INTO lhi_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ngag khaor mod ngad dig haq khehq lehq, chaw ngad hinx ghad haq car vid peg khaz nuhr, nig hehd awg lex khar niq khuhr luhd kawq ghawz gha cheawg le,” lehd koz na ngawx che te yand, “Teq chi niq khuhr luhd gha che yaog,” lehz i hehd yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ngag khaor mod suhr dig haq yug lehq, chaw uhg hinx ghad haq car vid peg lehq, nig hehd awg lex khar niq khuhr luhd kawq ghawz gha cheawg le,” lehd koz kawq na ngawx che te yand, “Suhr khuhr luhd gha che yaog,” lehz i hehd yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Kheh te peg lehq yawd i hehd haq, “A meha liz nig hehd ma duhd sir ser lehq la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","U ve awg khaz nuhr, i hehd Ber sehd daq med lo gaeg che yaog. Chaw ted pehg mehz cox var te ghad haq yawd chehd lo sir veha lag lehq, yawd haq vad vid tug Yer suq haq lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yawd mehz cox var ve laq kuhr haq ghawg lehq khaz awg bag lo sir ve tuhez che yaog. Yawd ved mehz sir haq cux ghig pheq ke vid peg lehq, yawd awg thag huh laq kuhr tar lehq, “Nawg ted ceng cear mawr-a la,” lehd koz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chaw u ve chid ngawx lehq, “Ngag chaw teq pa haq mawg che yaog. I hehd awr lehr suhz cehg haq sur liz, yaq kaw tod kae chehd che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yawd ved mehz sir haq Yer suq laq kuhr te pawz kawq vad che yaog. Chaw u ve awr lehr te pawz kha nehax kawq ngawx che te yand, mehz sir daq vehr lehq awg gha lia haq kha nehax kehr ghad mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Awg yand u ve haq Yer suq yawd haq, “Khaz che awg khuhn taq gehe,” lehd koz vid lehq, yawd ved yehg lo koeq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yer suq he lehq yawd ved awg laq ghuhd teq pa Phid liq Kehd sar riq muhd mig awg khuhn cawg che khaz teq pa huh kae che yaog. Yaq kaw kanr huh kae chehd-ag huh, yawd ved awg laq ghuhd teq pa haq yawd na ngawx che, “Su ngag haq a suawg lehd koz cheawg le.” ");
INSERT INTO lhi_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Awg laq ghuhd teq pa kawq koz che, “Chaw ted pehg pehar nawg haq Yod hanr A kaz tur var yaog lehd koz che, ted pehg pehar Ed lid yaq yaog lehd koz che, kheh te lehq ted pehg pehar a mig thad lo Ghig sa ve cuh kar var awg khuhn ve te ghad phehq che yaog,” lehz nawg haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Awg yand u ve khuhn Yer suq awr lehr, “Nig hehd teq pa vawr ngag haq a suawg lehd koz chehd cheawg le,” lehz i hehd haq na ngawx che te yand, “Nawg awr lehr Khreq yaog,” lehz Per troq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yawd awg lawn chaw te ghad-eg haq liz maq gha koz vid tug, Yer suq i hehd haq tawd hehnd chawa yaw vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Awg yand u ve khuhn chaw yad ve Yad phu awr lehr, laex ceng haq gha tuq gha khanr tug awg lawn yawd i hehd haq mar vid che yaog. Awg hox chaw mawd teq pa, paw khod nux teq pa he lehq liq buhq var teq pa yawd haq chid bag lehq dawz vehr tug awg lawn lehd ma koz, sehr ni teq ni gaeg ver yawd kawq teq tuag tug awg lawn lehd ma koz, i hehd haq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Awg lawn che yawd kha sehax saw koz mar vid che yaog. Kheh te lehq, Per troq Yer suq haq ted kag lo sir ve lehq ded che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yer suq phuhz ngawx lehq yawd ved awg laq ghuhd teq pa haq mawg che te yand Per troq haq koz vid che, “Sar tanr-og, phawe lor. Awg lawn ghod ver, nawg ved duhd khad awr lehr, Ghig sa ve duhd khad ma hez. Chaw yad ve duhd khad phehq che yaog,” lehd koz lehq yawd haq ded che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Awg yand u ve haq, chaw awg mor nux he lehq yawd ved awg laq ghuhd teq pa haq yawd kug yug lehq koz vid che, “Chaw te ghad ghad ngag khaz nuhr ghaq lag gad ver, a sug yawd ved a lor haq chid bag lar haz lehq, a sug yawd ved laq kan haq taz lehq ngag khaz nuhr ghaq lar-oq. ");
INSERT INTO lhi_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Awg lawn ghod ver, a sug te ghad lehd ma koz, a sug yawd ved a saq haq pong vid gad che ver, yawd ved a saq sond tug yaog. Kheh ma khuhd, a sug te ghad lehd ma koz, ngag awg pun he lehq ha lehg che bon khuhd awg pun yawd ved a saq sond ver, yawd ved a saq haq pong vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Chaw te ghad ghad mig gig awg gha lia haq gha liz, yawd ved a saq sond vehr ver, a thoq vawr awg bon cawag le. ");
INSERT INTO lhi_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Chaw te ghad ghad, a sug yawd ved a saq awg pun a thoq maq ted ceng haq yug lehq pa gha tuawg le. ");
INSERT INTO lhi_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Awg lawn ghod ver, chaw khar ve te ghad lehd ma koz, te yaq vix lehq vend bax te vix che chaw che teq co awg khuhn ngag haq he lehq ngag ved tawd khuhd haq yaq taw che ver, chaw yad ve Yad phu awr lehr, yawd Awr pa ve awg mig awg phond awg khuhn daq che kehg che muhd nuh maq cuh yad teq pa geh teq geha lag che te yand, chaw u ve haq yaq taw tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ngag nig hehd haq awg cehg mag koz ax laq, chuhr huh hox chehd che chaw ted pehg pehar awr lehr, Ghig sa ve muhd mig kand pax awg khuhn lag che haq maq gha mawg ser che kheh ceh, maq gha suh lehz,” yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Khuhq ni pong vehr lehq, Yer suq awr lehr Per troq, Yar koq he lehq Yod hanr haq lehax sir ve lehq taq chuhax gawr ghad keh muh maq ted dig awg thag lo i hehd taez che yaog. Awg yand u ve khuhn, i hehd mehz khuhd suhr huh yawd ved awg hoq awg han pa lehq, ");
INSERT INTO lhi_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","yawd ved beg ke awg ghiz tuhaz lehq phu daq jad che yaog. Mig gig khod-aq lo med nged chuhd var a sug te ghad lehd ma koz, u kheh taw maq chuhd phu maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mod ser he lehq Ed lid yaq liz i hehd mehz khuhd suhr tuhaz lehq Yer suq geh nag ux te daq chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Awg yand u ve haq Per troq awr lehr, “Jawd mawd-og, ngag hehd chuhr huh chehd che awr lehr daq che yaog. Ngag hehd hax po seh lehd te tug yaog. Nawg awg pun ted mag, Mod ser awg pun ted mag he lehq Ed lid yaq awg pun ted mag te tug yaog,” lehz Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Awg lawn ghod ver, i hehd kuhz jad cheaq te lehq, yawd khawd-ehg kheh gha koz tug haq maq sir. ");
INSERT INTO lhi_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Awg yand u ve khuhn, mog i hehd haq lag hoz lar lehq, “Chaw cheawg lehr, ngag haq jad che Yad phu yaog. Yawd ved tawd khuhd haq nao,” lehd mog u ve awg khuhn awg khuhd buhg tuhaz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","I hehd teq pear lehax caw ngawx che te yand, awg kag awr ve chaw te ghad-eg haq liz mad kawq mawg. Yer suq lehax i hehd geh chehd chehd che haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Keh u ve te dig huh i hehd kawq yaq tod che te yand, chaw yad ve Yad phu awr lehr suh kig huh mad kawq teq tuag ser che kheh ceh, i hehd gha mawg che teq pa chaw te ghad-eg haq liz maq gha koz vid tug, Yer suq i hehd haq tawd yuhz vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","I hehd, tawd khuhd u ve haq tawnd lar lehq, “Suh kig lo kawq teq tuag che ted ceng a thoq maq haq koz cheawg le,” lehz te ghad he lehq te ghad na ngawx daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Awg yand u ve khuhn i hehd awr lehr, “Ed lid yaq awg kawd gha lag tug yaog lehz, a thoq te lehq liq buhq var teq pa koz cheawg le,” lehd yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yawd kawq koz vid che, “Ed lid yaq awg kawd awg cehg mag lag lehq, awg gha lia haq kawq ghu te che yaog. Chaw yad ve Yad phu awr lehr, laex ceng haq gha tuq gha khanr lehq chid bag che haq gha khanr tug yaog,” lehz a thoq te lehq buhq lar cheawg le lehz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kheh ma khuhd, “Ngag nig hehd haq koz ax laq, Ed lid yaq lag gag vehr lehq, yawd ved awg lawn buhq lar che heh te lehq, su yawd haq te gad che heh te vid vehor,” lehz Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","I hehd awr lehr, awg kag awr ve awg laq ghuhd teq pa geh kawq gag che te yand, chaw awg mor nux awg laq ghuhd teq pa haq kha caw yuhd chehd lar lehq, liq buhq var teq pa i hehd geh tawd ghawg daq chehd che haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Chaw awg mor nux awg gha lia teq pear lehax Yer suq haq gha mawg che te yand and jad lehq, yawd chehd lo cex kae lehq yawd haq haq yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Awg yand u ve haq Yer suq awr lehr, “Nig hehd i hehd geh a thoq awg lawn tawd ghawg daq chehd cheawg le,” lehz na ngawx che te yand, ");
INSERT INTO lhi_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","chaw awg mor nux awg khuhn lo chaw te ghad yawd haq koz vid che, “Sar lar-og, ngag ved yad par haq nawg chehd lo sir veha lar che yaog. Yawd awr lehr, kar che ned geh chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ned yawd haq yug cid che te yand, yawd khar lo chehd che lehd ma koz, ned yawd haq biz bag pe che yaog. Awg yand u ve haq, mawq kaw khuhn cux ghig phoz tuhaz lehq, cig cheq cid lehq awg ton awg heh guhx phehq vehr che yaog. Ned haq ghaq kog tug nawg ved awg laq ghuhd teq pa haq ngag koz vid liz, i hehd te maq gha,” lehz yawd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yer suq kawq koz che, “Yonr che mad cawg che chaw che teq paog, ngag nig hehd geh khawd-ehg muh gha chehd tug ser-aw le. Ngag nig hehd haq khawd-ehg muh maq gha yeg khanr tug ser-aw le. Yawd haq ngag chehd lo sir veha lar-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kheh te lehq i hehd awr lehr, yad par haq yawd chehd lo sir veha lag che yaog. Ned u ve Yer suq haq gha mawg che te yand, yad par haq yawd puhq phez vid tug te lehq, yad par u ve mig kag lo kuhd veh che yaog. Yawd awr lehr, mawq kaw khuhn cux ghig phoz tuhaz lehq phez dawz chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yer suq awr lehr, “Yawd che kheh te phehaq che khawd-ehg muh maq gag vehor le,” lehz awr pa haq na ngawx che te yand, awr pa koz che, “Yawd awg nehax loar che kheh te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Yawd haq te lug tug, a mir awg khuhn lehd ma koz, a kaz awg khuhn lehd ma koz, laex pawz ned yawd haq biz ke vid che yaog. Kheh ma khuhd, nawg ted ceng cear te gha ver, ngag hehd haq har kax lehq ga laoq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yer suq koz che, “Te gha ver lehz nawg koz cheawg la. Yonr che chaw teq pa awg pun awg ceng awg gha lia phehaq gha che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Awg yand u ve khuhn yad par nehax ve awr pa teq pear lehax kug lehq, “Ngag yonr che yaog. Ngag yonr mad gag che awg ceng haq a cehax ga laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Chaw awg mor nux yawd chehd lo cex lag tod che haq Yer suq gha mawg che te yand, ned chaq chiz u ve haq ded lehq, “Kar lehq nar puh bag che ned-og, yawd awg khuhn tuhez lehq awg khaz nuhr te pawz-a liz yawd awg khuhn tad kawq gehe lehz ngag nawg haq tawd pehar che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kheh te lehq, ned u ve hehnd chawa kug lehq yad par u ve haq hax ceh nux puhq phez vid lar haz lehq tuhz veh che yaog. Yad par nehax u ve chaw suh heh phehq vehr cheaq te lehq, Yawd suh vehor lehz, chaw laex ghad koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kheh ma khuhd, Yer suq yawd ved laq kuhr haq yug lehq, yawd haq ghawg tu vid lehq yawd tuag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yer suq yehg khuhn geh veh lehq, yawd ved awg laq ghuhd teq pa taq chuhax gawr ghad te che awg khuhn, “Ned u ve haq a thoq vawr te lehq ngag hehd ghaq kog maq gha cheawg le,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yer suq awr lehr, “Bon lawg che ted ceng ma hez ver, ned che ted ceng haq ghaq kog maq gha,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","I hehd u huh tuhz kae lehq Gar liq lehd muhd mig haq phanr kae che yaog. I hehd kae che awg lawn chaw te ghad-eg haq liz yawd maq sir vid gad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Awg lawn ghod ver, yawd yawd ved awg laq ghuhd teq pa haq mar vid lehq koz che, “Chaw yad ve Yad phu awr lehr, chaw yad teq pa ve laq kuhr awg khuhn lo chid aq che haq gha khanr lehq, i hehd yawd haq dawz vehr tug yaog. Dawz vehr peg khaz nuhr, sehr ni gaeg ver yawd kawq teq tuag tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tawd khuhd u ve haq i hehd na maq gha liz, yawd haq kawq na ngawx maq pir. ");
INSERT INTO lhi_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","U ve khaz nuhr i hehd Kar per nar unr med lo gaeg che yaog. Yer suq yehg khuhn chehd chehd che te yand, “Yaq kaw kanr lo nig hehd a thoq maq awg lawn jehg daq cheawg le,” lehz yawd i hehd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kheh ma khuhd, i hehd yaq taw lehq taq hiax chehd chehd che yaog. Awg lawn ghod ver, a sug te ghad su haq keh ir cheawg le lehz yaq kaw kanr lo i hehd te ghad he lehq te ghad tawd ghawg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kheh te lehq yawd mi lar lehq, cuh yad teq chi ni ghad haq kug yug lehq, “Su haq keh ir gad che chaw te ghad awr lehr, su haq keh i che chaw gha te lehq, su ved awg ceg gha te che yaog,” lehz yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kheh te peg lehq, chaw yad nehax te ghad haq yawd yug lehq i hehd awg kaw jen huh tar che yaog. Chaw yad nehax haq yawd chid taz lar lehq, i hehd haq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Chaw yad nehax haq ngag ved awg meh awg khuhn haq yug che chaw a sug te ghad lehd ma koz, ngag haq haq yug che yaog. Ngag haq haq yug che chaw awr lehr, ngag haq lehax haq yug che ma hez. Ngag haq lag peha che phad haq yawd haq yug che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Awg yand u ve khuhn Yod hanr koz che, “Sar lar-og, chaw te ghad nawg ved awg meh haq cud lehq ned teq pa haq ghaq kog chehd che haq ngag hehd gha mawg che yaog. Yawd a nig geh teq geha lag che chaw ma hez cheaq te lehq, ngag hehd yawd haq tawr lar che yaog,” lehz Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yer suq kawq koz che, “Yawd haq taq tawr lar. Awg lawn ghod ver, ngag ved awg meh haq cud lehq and tug te che chaw a sug te ghad lehd ma koz, u kheh te peg khaz nuhr ngag haq har naq kawq khaex gha tug ma hez. ");
INSERT INTO lhi_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","A nig ved cand par phawd awr ma chehd che chaw te ghad awr lehr, a nig phawd awr chehd che chaw phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Awg lawn ghod ver, Khreq ve awg meh haq nig hehd puhd chehd che haq te lehq, khar ve chaw te ghad lehd ma koz, nig hehd haq a kaz te kawz tawa che ver, yawd ved awg bon a cehax liz maq mehx hawg lehz, ngag nig hehd haq awg cehg mag koz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ngag haq yonr che chaw yad nehax te ghad haq yaq vid tug te che chaw a sug te ghad lehd ma koz, yawd ved kuhr pehg haq huhx meh mawr nux pheh chuhq lehq lad chuhd ghig khuhn chid bag ke pe ver, yawd awg pun daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nawg ved laq kuhr teq pax nawg haq te yaq vid tug te ver, tawz chid bar-oq. Laq kuhr niq pax pax cawg lehq, muhd naz hoq khuhn maq suh gha che a mir toq chehd che awg khuhn gha khanr che haq keh, laq lug lehq a saq teq che khuhn gha gehe che awr lehr, nawg awg pun daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nawg ved khi kud teq pax nawg haq te yaq vid tug te ver, tawz chid bar-oq. Khi kud niq pax pax cawg lehq muhd naz hoq khuhn chid bag ke che haq gha khanr che haq keh, khi lug lehq a saq teq che awg khuhn gha gehe che awr lehr, nawg awg pun daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","Nawg ved mehz sir teq pax nawg haq te yaq vid tug te ver, kehx chid bar-oq. Mehz sir niq pax pax cawg lehq, huhz nehax liz maq suh vix, a mir liz maq suh gha che muhd naz hoq khuhn chid bag ke che haq gha khanr che haq keh, mehz sir teq pax lehax cawg lehq Ghig sa ve muhd mig awg khuhn lo gha gehe che awr lehr, nawg awg pun daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Awg lawn ghod ver, a lehq yug lehq tand tug haq puhr vid che heh, a mir puhr vid che ted ceng haq chaw awg gha lia gha khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A lehq awr lehr daq che yaog. Kheh ma khuhd, mehg che pehz vehr ver, khawd-ehg kheh te kawq mehg gha tuawg le. Nig hehd khuhn a lehq cawg vid lehq, te ghad he lehq te ghad cawd daq hawr daq cawg vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yer suq u huh tuhz kae lehq, Yud daq muhd mig lo he lehq Yawd danr lawg ox pax awr lo kae lehq, chaw awg mor nux teq pa yawd chehd lo kawq phoz lag che yaog. Yawd awg lid cawg lar che heh, yawd i hehd haq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kheh te lehq yawd haq lawnd ngawx tug, Phar rir sehd teq pa yawd chehd lo lag lehq, “Awg phad mawd te ghad awr lehr, a sug yawd ved awg mid ma haq chid bag ver, Mod ser ve awg lid awg khad haq hawr hawg la,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yawd kawq koz che, “Mod ser nig hehd haq tawd khawd-ehg kheh pehar lar cheawg le,” lehz i hehd haq na ngawx che te yand, ");
INSERT INTO lhi_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Chid bag daq che liq te koz buhq vid peg ver, awg mid ma haq chid bag gha hawg lehz Mod ser tawd pehar lar che yaog,” lehd i hehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yer suq kawq koz che, “Nig hehd ni ma heh cheaq te lehq Mod ser nig hehd haq tawd che kheh te pehar lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kheh ma khuhd, awg gha lia haq awg kawd maq te phanr thad liz, Ghig sa awr lehr haw khaz he lehq yad mid haq te phanr lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kheh te cheaq te lehq haw khaz awr lehr, yawd ved awr pa awr ye haq phaz daq lar haz lehq, ");
INSERT INTO lhi_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ix mag teq suhr teq sar lehax phehq vehr tug yaog. Kheh te cheaq te lehq, ix mag ni ghad phehq che ma hez, te ghad lehax phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kheh te cheaq te lehq, Ghig sa cax daq vid lar che haq chaw yad maq gha yug phaz daq vid,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yehg khuhn chehd chehd che te yand, awg laq ghuhd teq pa awr lehr, awg lawn u ve yawd haq kawq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kheh te lehq yawd koz che, “A sug yawd ved awg mid ma haq chid bag lehq awg kag awr ve yad mid haq ca he che chaw a sug te ghad lehd ma koz, hax chawd hax paz te lehq yawd ved awg mid ma haq yaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Yad mid liz, a sug yawd ved awg phad mawd haq chid bag lehq awg kag awr ve haw khaz haq ca he ver, hax chawd hax paz te che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Awg yand u ve khuhn chaw yad nehax teq pa haq Yer suq soz vid tug, chaw yad nehax teq pa haq su yawd chehd lo sir veha lag che te yand, awg laq ghuhd teq pa awr lehr, sir veha lag che chaw teq pa haq ded che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yer suq u ve haq gha mawg che te yand nez nag lehq, “Chaw yad nehax teq pa haq ngag chehd lo lag vid-oq. I hehd haq taq tawr lar. Awg lawn ghod ver, Ghig sa ve muhd mig awr lehr, chaw u kheh te che ve muhd mig phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ngag nig hehd haq awg cehg mag koz ax laq, chaw yad nehax heh te lehq Ghig sa ve muhd mig haq mad haq yug che chaw a sug te ghad lehd ma koz, Ghig sa ve muhd mig awg khuhn maq gha gehe hawg,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Awg yand u ve haq, chaw yad nehax teq pa haq yawd chid taz lar lehq, i hehd awg thag huh laq kuhr tar lehq bon naq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yawd yaq kaw kae tod-ag huh, chaw te ghad yawd chehd lo cex lag lehq yawd mehz khuhd suhr huh nar kheh teh mi lar lehq, “Daq che Sar lar-og, co tiq ha tiq gha tug ngag khawd-ehg kheh gha te lawg le,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yer suq kawq koz che, “A thoq haq te lehq nawg ngag haq daq che lehd koz cheawg le. Ghig sa ma hez ver, daq che te ghad-eg liz mad cawg. ");
INSERT INTO lhi_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Awg lid tawd khuhd teq pa haq nawg sir che yaog. Chaw haq ta dawz vehr, hax chawd hax paz taq te, su ved med nged haq ta khuhd, su haq ma hez hez che sax khiz taq khanr, su ved med nged haq taq her ka yug, nawg ved awr pa awr ye haq yawz yawz yan yan teo,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Chaw u ve awr lehr, “Sar lar-og, ngag chaw yad nehax te chehd che te yand thad loar tanr lehq awg lid tawd khuhd awg gha lia che ve haq ngag na yug lehq te peor,” lehz Yer suq haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yer suq yawd haq ngawx lehq yawd haq haq lehq, “Nawg ted ceng lor ser che yaog. Nawg koeq lehq kha cawg lar che med nged jeg kor haq huhd kha lehq har yad ghuhd yad teq pa haq pehg vid-eq. Muhd nuh maq lo awg phuhd khaz che med nged nawg cawg lar tug yaog. Kheh te lehq, nawg kawq lag lehq ngag khaz nuhr ghaq lar-oq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tawd khuhd che ve haq yawd gha kad che te yand, mehz khuhd nuhr ghad te lehq, duhd har jad lehq kawq veh che yaog. Awg lawn ghod ver, yawd med nged jeg kor cawg mad jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yer suq awr lehr, yawd ved awg laq ghuhd teq pa haq caw ngawx lehq koz che, “Paw sa che chaw teq pa awr lehr, Ghig sa ve muhd mig awg khuhn gehe tug khawd-ehg taw maq har jad cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Awg laq ghuhd teq pa awr lehr, yawd koz che tawd khuhd haq gha kad che te yand and jad che yaog. Te pawz Yer suq i hehd haq koz vid che, “Ngag yad teq paog, Ghig sa ve muhd mig awg khuhn gehe tug khawd-ehg taw maq har jad cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kar lar oq teq kheh a ghoq nar khuhn gehe tug awr lehr, paw sa che chaw te ghad Ghig sa ve muhd mig awg khuhn gehe tug haq keh sa che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","I hehd sang lehq and jad lehq, “Kheh te ver, thaer khuhq che haq a sug gha hawg le,” lehz awg laq ghuhd teq pa koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yer suq i hehd haq ngawx lehq, “Chaw yad awr lehr che haq te maq gha. Kheh ma khuhd, Ghig sa te maq gha che ma hez. Awg lawn ghod ver, Ghig sa awr lehr awg gha lia haq te gha che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Awg yand u ve khuhn Per troq koz che, “Ngag hehd awr lehr awg ceng gha lia haq teh lar haz lehq nawg khaz nuhr ghaq lag vehr che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yer suq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, ngag awg pun he lehq ha lehg che bon khuhd awg pun, a sug yawd ved yehg, a sug yawd ved a vix a nax, a sug yawd ved awr pa awr ye, a sug yawd ved awg yad awg dug he lehq a sug yawd ved ti mi teq pa haq chid bag lar haz che chaw a sug te ghad lehd ma koz, ");
INSERT INTO lhi_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","che ted caq naq awg khuhn lo yehg, a vix a nax, awr ye, awg yad awg dug he lehq ti mi teq pa haq teq ha pun gha che yaog. Che teq pa geh teq geha tuq che khanr che haq liz gha che yaog. Awg khaz nuhr ted caq naq awg khuhn co tiq ha tiq haq liz gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kheh ma khuhd, su ghud med awr chehd che chaw mad awr, su awg khaz nuhr gha kawq chehd tug yaog. Su awg khaz nuhr chehd che chaw mad awr, su awg ghud suhr gha kawq chehd tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","U ve awg khaz nuhr, i hehd Yer ruq sar lehnr med lo kae tod-ag huh, yaq kaw kanr huh Yer suq awr lehr i hehd awg ghud med awr kae che yaog. I hehd and jad lehq, i hehd awg khaz nuhr kae che chaw teq pa liz kuhz che yaog. Kheh te lehq cuh yad teq chi ni ghad haq yawd kawq kug yug lehq, yawd khawd-ehg kheh te gha khanr tug awg lawn teq pa i hehd haq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“A nig Yer ruq sar lehnr med lo kae tod che yaog. Chaw yad ve Yad phu awr lehr, paw khod nux teq pa he lehq liq buhq var teq pa ve laq kuhr awg khuhn chid aq che haq gha khanr tug yaog. Yawd gha suh tug i hehd yawd haq suhx jehg suhx taz lehq, Yud daq chaw ma hez che chaw teq pa ve laq kuhr awg khuhn chid aq vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","I hehd yawd haq maq sawnr ma caz te lehq, cux ghig pheq puhr lehq, yawd haq jawq peg ver yawd haq dawz vehr tug yaog. Kheh te lehq sehr ni teq ni gaeg ver, yawd kawq teq tuag tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Awg yand u ve khuhn, Yer ber dehd ve awg yad par Yar koq he lehq Yod hanr yawd chehd lo lag lehq, Sar lar-og, ngag nid-ag lawg che heh nawg tea tug ngag nid-ag he gad che yaog lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yawd awr lehr, Nig mag awg pun ngag haq a thoq ted ceng te cuha vid gad lehq le lehz, ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ix mag awr lehr, Nawg awg mig awg phond gha che te yand, nawg ved laq yaq awr pax awr te ghad, laq vehr awr pax awr te ghad, ngag nid-ag haq mi cuha laoq lehd, yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yer suq koz che, Nig mag a thoq ted ceng haq lawg che, nig mag maq sir. Ngag dawg che kawz khehd haq nig mag dawg gha hawg la. Ngag khanr che baz tiz sar haq nig mag khanr gha hawg la lehz, ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Khanr gha che yaog lehz, ix mag kawq koz vid che te yand, Yer suq kawq koz che, Ngag dawg che kawz khehd haq nig mag gha dawg tug yaog. Ngag khanr che baz tiz sar haq nig mag gha khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kheh ma khuhd, a sug ngag ved laq yaq awr pax awr laq vehr awr pax awr gha mi tug, ngag pehar tug a khawag mad cawg hawg. I hehd awg pun ghu teh lar vid che chaw teq pa lehax u huh gha mi che yaog lehz, ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Awg lawn che haq awg kag awr ve cuh yad teq chi ghad gha kad che te yand, Yar koq he lehq Yod hanr haq i hehd nez nag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kheh te lehq, Yer suq i hehd haq kug yug lehq koz vid che, Yud daq chaw ma hez che chaw teq pa awg thag lo jawd mawd te tug a yad gha che chaw teq pa awr lehr, i hehd haq uq penr lehq, i hehd ve chaw ir teq pa awr lehr, i hehd haq bax te nex te che haq nig hehd sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kheh ma khuhd, nig hehd awg khuhn che kheh maq gha te. Nig hehd awg khuhn chaw ir phehq gad che chaw a sug te ghad lehd ma koz, yawd nig hehd ve awg ceg gha te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Nig hehd awg khuhn awg hox te gad che chaw a sug te ghad lehd ma koz, awg gha lia awg pun yawd awr lehr vig lar che awg ceg gha phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Awg lawn ghod ver, chaw yad ve Yad phu awr lehr, su yawd awg pun kanx te tug lag che ma hez. Yawd su awg pun kanx te tug lag lehq, chaw kha peh haq thaer khuhq vid tug, yawd ved a saq pid tug awg pun lag che yaog lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Awg yand u ve khuhn, i hehd Yer riq khod med lo lag gag vehr che yaog. Yer suq awr lehr, yawd ved awg laq ghuhd teq pa he lehq chaw awg mor nux geh Yer riq khod med awg khuhn lo tuhz veh tod che te yand, Tiq mehd ve yad par Bar tiq mehd meh che mehz cox che lawg cad var te ghad yaq kaw pad huh mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nar sar rehq chaw Yer suq yaog lehz, yawd gha kad che te yand yawd koz che, “Dar viq ve Yad phu Yer suq-og, ngag haq har kax laoq,” lehd koz kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Chaw laex ghad awr lehr, “Taq chuhax chehd-oq,” lehd koz yawd haq ded vid chehd liz, yawd awr lehr, “Dar viq ve Yad phu-og, ngag haq har kax laoq,” lehd koz, lex lehq hax ceh nux kawq kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yer suq jehd lar lehq, “Yawd haq kug vid che lar-oq,” lehd koz vid che yaog. I hehd mehz cox var u ve haq kug vid lehq, “Ha lehg laoq. Tu lor. Yawd nawg haq kug chehd che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Chaw u ve awr lehr, yawd ved a poq yehg maq haq kuhz teh lar haz lehq, pawz tu lehq Yer suq chehd lo lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kheh te lehq, Yer suq yawd haq koz vid che, “Nawg awg pun ngag haq a thoq ted ceng te cuha vid gad lehq le,” lehd koz na ngawx che te yand, “Sar lar-og, ngag mehz mawg vid tug nawg haq te cuha gad che yaog,” lehz yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yer suq awr lehr, “Kae lor. Nawg yonr che ted ceng awr lehr nawg haq na tug tea vehor,” lehd yawd haq koz vid che yaog. Chaw u ve teq pear lehax mehz mawg vehr lehq Yer suq khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","I hehd awr lehr, Yer ruq sar lehnr med awg pad huh, Sar lonr keh haq ned che Ber phar ger khaz he lehq Ber tar niq khaz pad huh lag ga che te yand, Yer suq yawd ved awg laq ghuhd ni ghad haq kae pe lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Nig mag mehz khuhd suhr huh cawg che khaz khuhn kae-o. U huh gehe che te yand, chaw te ghad-eg liz ma cind jaw ser che pix lar nehax pheh lar che haq nig mag teq pear lehax gha mawg tug yaog. Phi lehq seh veha laoq. ");
INSERT INTO lhi_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nig mag a thoq haq te lehq che kheh te cheawg le lehz chaw te ghad ghad na ver, Jawd mawd lor lehq yawd teq pear lehax kawq khuhq veha tug yaog lehd koz vid-oq,” lehz ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ix mag kae lehq, ghaz mir awg bag yaq kaw khuhn pix lar nehax pheh lar che haq gha mawg lehq, pix lar nehax u ve haq phi che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","U huh hox chehd che chaw ted pehg pehar awr lehr, “Nig mag a thoq te lehq pix lar nehax haq phi cheawg le,” lehd ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yer suq ix mag haq koz vid lar che heh ix mag kawq koz vid che te yand, i hehd a khawag pehar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kheh te lehq ix mag pix lar nehax u ve haq Yer suq chehd lo seh veha lag lehq, pix lar nehax awg thag huh i hehd ve a poq khawd vid lar peg lehq Yer suq taz cind che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Chaw kha peh a sug yawd ved a poq haq yaq kaw khuhn khawd vid lehq, ted pehg pehar ha jad huh suhz phaq chuh lehq yaq kaw khuhn khawd vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Yawd mehz khuhd suhr he lehq kuhr tehx nuhr kae che chaw teq pa kug lehq koz che, “Ho sa na, Jawd mawd Ghig sa ve awg meh awg khuhn lag che chaw awr lehr, awg bon ir vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Lag tod che a nig ve awr pa Dar viq ve muhd mig awr lehr, awg bon ir vid-oq. Muhd nuh maq lo liz Ho sa na phehq vid-oq,” lehd i hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Awg yand u ve haq, yawd Yer ruq sar lehnr med awg khuhn gehe lehq bon yehg nux awg vaw awg khuhn lo gehe che yaog. Awg ceng gha lia haq yawd caw ngawx peg khaz nuhr, muhd phiq vehr cheaq te lehq cuh yad teq chi ni ghad yawd geh teq geha Ber tar niq khaz lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Awg khaz nuhr teq ni gaeg lehq Ber tar niq khaz khuhn lo i hehd tuhaz che te yand, Yer suq awr meq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Kheh te lehq yawd vid-aq lo chehd-ag huh liz awg phaq cawg che a kud cehg ted cehg haq gha mawg lehq, awg cehg u ve awg sir nuhaq lehq nar mad nuhq lehq nar, gha mawg tug yawd ca ngawx-eg che yaog. Awg pad huh yawd gaeg che te yand, awg sir nuhq che awg yand ma hez cheaq te lehq, awg phaq haq lehax yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Awg yand u ve khuhn Yer suq awr lehr, “Yaq ni khaz nuhr ver, nawg ved awg sir haq a sug liz taq gha cad vid,” lehz a kud cehg haq koz vid che yaog. Yawd u kheh koz che haq yawd ved awg laq ghuhd teq pa gha kad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kheh te lehq i hehd Yer ruq sar lehnr med lo gaeg che yaog. Yawd bon yehg nux awg khuhn gehe lehq, bon yehg nux awg khuhn med nged vig med nged huhd che chaw teq pa haq ghaq kog lehq, phu pa sehr phad teq pa ve teh cuh teq pa haq lehd ma koz, a pia huhd sehr phad teq pa ve mi khuhd teq pa haq lehd ma koz, yawd phuhz bag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Med nged ted ceng cear yug lehq bon yehg nux awg vaw u ve haq phanr kae tug, chaw te ghad-eg haq liz yawd a khawag ma pid. ");
INSERT INTO lhi_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yawd i hehd haq mar vid che, “Ngag ved yehg haq chaw awg ceng gha lia awg pun bon lawg kig yehg gha koz tug yaog lehz buhq lar che liz, nig hehd awr lehr, yehg che haq chaw khuhd chehd kig phehq vehr vid vehor,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Paw khod nux teq pa he lehq liq buhq var teq pa tawd khuhd u ve haq gha kad che te yand, yawd haq dawz vehr tug awg khad ca che yaog. Awg lawn ghod ver, chaw awg gha lia yawd mar vid che haq and jad cheaq te lehq, paw khod nux teq pa he lehq liq buhq var teq pa yawd haq kuhz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Muhd phiq vehr che te yand i hehd med awg bag lo tuhz veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Awg khaz nuhr teq sawx i hehd yaq kaw u ve haq kawq kae che te yand, a kud cehg u ve awr lehr, awg chi kha gag nuhr vehr god vehr che haq i hehd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Kheh te lehq Per troq duhd nuhd-ag lehq, “Sar lar-og, ngawx ser. Nawg khen vid lar haz che a kud cehg awr lehr, nuhr vehr god vehr che law lehg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yer suq i hehd haq kawq koz vid che, “Ghig sa haq yonr lor. ");
INSERT INTO lhi_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ngag nig hehd haq awg cehg mag koz ax cheawg, chaw a sug te ghad lehd ma koz, yawd koz che heh phehq vehr tug yaog lehz yonr lehq, ni ma thuhd duhd nuhg duhd maq te ver, keh che ted dig haq, ‘Jiz tuhez lehq lad chuhd ghig awg khuhn ca che gehe lor,’ lehd koz che te yand, yawd awg pun phehq vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kheh te lehq, ngag nig hehd haq koz ax laq, nig hehd bon lawg che awg khuhn kha lawg che awg gha lia haq gha tug yaog lehz yonr lor. U kheh te yonr ver, nig hehd gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nig hehd hox lar lehq bon lawg chehd che te yand, chaw te ghad ghad awg khod-aq nawg vend bax tar che ver, vend bax u ve haq phehd kha-o. U kheh te ver, muhd nuh maq lo chehd che nig hehd ve Awr pa awr lehr, nig hehd ve vend bax haq liz phehd kha ax tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","I hehd Yer ruq sar lehnr med lo te pawz kawq lag che yaog. Yawd bon yehg nux awg khuhn lo tod kae chehd che te yand, paw khod nux teq pa, liq buhq var teq pa he lehq awg hox chaw mawd teq pa yawd chehd lo lag lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Nawg khawd-ehg kheh ve kand pax gha lehq che teq pa haq te cheawg le. Kand pax che ve a sug nawg haq pehar cheawg le,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yer suq kawq koz vid che, “Ngag liz nig hehd haq tawd te khuhd na ngawx sar. Nig hehd yaw khuhq ax gha ver, ngag khawd-ehg kheh ve kand pax gha lehq che teq pa haq te che awg lawn nig hehd haq koz ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yod hanr yawd baz tiz sar pid che ted ceng awr lehr, muhd nuh maq lo gha che awg la, ma hez ver chaw yad teq pa geh gha che awg la. Ngag haq kawq koz ax laoq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","I hehd te ghad he lehq te ghad jehg daq lehq koz che, “Muhd nuh maq lo gha che lehz a nig koz ver, Kheh te ver, nig hehd a thoq te yawd haq maq yonr cheawg le lehz, yawd a nig haq kawq koz ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kheh ma khuhd, chaw yad teq pa geh gha che lehd koz ver, mad phehq,” lehz i hehd koz daq che yaog. Awg lawn ghod ver, Yod hanr awr lehr Ghig sa ve cuh kar var awg cehg mag phehq che yaog lehz, chaw awg gha lia sawnr lar cheaq te lehq, chaw kheh ma ve haq i hehd kuhz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kheh te lehq, “Ngag hehd maq sir,” lehz i hehd Yer suq haq kawq koz vid che yaog. Yer suq liz, “Che heh te lehq ngag khawd-ehg kheh ve kand pax gha lehq che teq pa haq te che, ngag nig hehd haq ma koz ax hawg,” lehz i hehd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kheh te lehq, Yer suq i hehd haq tawd par hax teq pa te mar vid lehq koz che, Chaw te ghad awr lehr, a pehx med kho te lehq ti lar peg khaz nuhr, kha caw yuhd ko lar lehq, a pehx med sir nex kig dud lar che yaog. Paog lar kig yehg muh che liz te lehq, kho te var teq pa haq a pehx med kho u ve ngar vid lar haz lehq, awg kag awr ve muhd mig lo yawd veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Awg yand gag vehr che te yand, kho u ve awg khuhn lo yawd gha cawd che yawd ved a pehx med sir teq pun haq gha tug, kho te var teq pa chehd lo awg ceg te ghad haq yawd kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","I hehd yawd haq yug teh lar lehq dawz peg khaz nuhr, awg kawd sawz koeq pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Awg khaz nuhr te pawz, awg kag awr ve awg ceg te ghad haq yawd i hehd chehd lo kae pe che yaog. I hehd yawd ved a kor haq dawz khuh pe lehq, kha muhd kha na te vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kheh te lehq, yawd awg kag awr ve awg ceg te ghad haq kawq kae pe vid che te yand, i hehd yawd haq dawz vehr che yaog. Awg kag awr ve awg ceg laex ghad haq yawd kawq kae pe che liz, ted pehg pehar haq i hehd dawz lehq, ted pehg pehar haq i hehd dawz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Yawd haq jad che yad par lehax yawd geh cawg lar haz che yaog. Ngag ved yad par haq i hehd yawz yan tug yaog lehz yawd koz lehq, awg leh med te pawz yawd ved yad par haq i hehd chehd lo kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kheh ma khuhd, kho te var teq pa koz che, Chaw cheawg lehr, awg sinx gha che phad phehq che yaog. Lar-oq, yawd haq dawz vehr-ag veg. U kheh te ver, yawd ved awg sinx haq a nig gha tug yaog lehz, te ghad he lehq te ghad koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kheh te lehq, i hehd yawd haq yug lehq dawz vehr peg lehq kho awg bag phawd awr lo chid bag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Kheh te lehq, kho awg sehr phad khawd-ehg kheh te vid tuawg le. Yawd lag lehq kho te var teq pa haq dawz vehr peg ver, kho u ve awg kag awr ve chaw teq pa haq kawq ngar vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Yehg kawx che phad teq pa chid bag lar che huhx meh dig awr lehr, awg cuhz penr awg cir huh kawx lar che huhx meh dig phehq vehr che yaog. Che awr lehr, Jawd mawd Ghig sa te che kanx te lehq, a nig mehz khuhd suhr huh and tug te che yaog, lehz Liq phu awg khuhn nig hehd maq ghawn jaw lehq la lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","I hehd yawd haq pheh yug gad che yaog. Awg lawn ghod ver, tawd par hax che yawd i hehd awg lawn koz chehd che haq i hehd sir che yaog. Kheh ma khuhd, chaw awg mor nux haq kuhz cheaq te lehq, i hehd yawd haq phaz daq lar haz lehq tuhz veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yer suq tawd yaw che awg khuhn, khawd-ehg kheh te ver yawd haq tawd yaw yaq vid tug, i hehd awr lehr Phar rir sehd ted pehg pehar he lehq Her roq chaw ted pehg pehar haq yawd chehd lo kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kheh te lehq i hehd lag lehq koz che, “Sar lar-og, nawg awr lehr thed che cawd che chaw te lehq, chaw te ghad-eg haq liz nawg ma kuhz che haq ngag hehd sir che yaog. Chaw yad ve mehz khuhd haq nawg maq ngawx lehq Ghig sa ve yaq kaw haq thed-e ghad mar vid che yaog. Jawd mawd nux Kehd sar haq awg khawnr ke vid cawd hawg la, maq ke vid cawd hawg la. Ngag hehd gha ke vid tuawg la, maq gha ke vid hawg la,” lehd koz ");
INSERT INTO lhi_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","yawd haq na ngawx che yaog. Yawd awr lehr, i hehd her ka vix che chaw phehq cheawg lehz sir lehq, “Nig hehd a thoq te ngag haq lawnd ngawx cheawg le. Ngag ngawx tug, phu ted thehq ngag chehd lo yug veha laoq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kheh te lehq, i hehd yug veha lag che yaog. Yawd i hehd haq koz vid che, “A sug ved awg han, a sug ved awg meh cawar le,” lehd koz na ngawx che te yand, “Jawd mawd nux Kehd sar ve yaog,” lehz i hehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yer suq i hehd haq kawq koz vid che, “Jawd mawd nux Kehd sar ve med nged Jawd mawd nux Kehd sar haq pid-oq. Ghig sa ve med nged Ghig sa haq pid-oq,” lehd koz che te yand, i hehd yawd haq and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","U ve khaz nuhr, kawq teq tuag che mad cawg lehd koz che Sar duq kehd chaw teq pa yawd chehd lo lag lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Sar lar-og, Mod ser ngag hehd awg pun che kheh koz buhq lar che, ‘Chaw te ghad ve awg vix var yad mad cawg lehq suh vehr ver, awg nax var te ghad awr lehr yawd ved awg mid ma haq kawq he lehq awg vix var awg pun awg ceng awg khad gha cawg vid che yaog,’ lehd koz buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pong lag thad, awg vix awg nax suhr ghad cawg che yaog. Awg kawd te ghad awr lehr, awg mid ma haq he lehq yad mad cawg ser huh suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ni ghad te ghad liz, yad mid u ve haq he lehq yad mad cawg ser huh suh vehr che yaog. Seh ghad te ghad liz u ve heh te che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Che haq kha sur suar a vix a nax suhr ghad kha gag yad mad cawg lar haz che yaog. I hehd awg gha lia suh vehr khaz nuhr, yad mid u ve liz suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kawq teq tuag che te yand, yad mid u ve a sug te ghad ve awg mid ma phehq tuawg le. Awg lawn ghod ver, i hehd suhr ghad yad mid u ve haq he peg che yaog,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yer suq i hehd haq kawq koz vid che, “Liq phu haq liz, Ghig sa ve kand pax haq liz nig hehd maq sir cheaq te lehq, nig hehd duhd yaq che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Awg lawn ghod ver, suh vehr che chaw teq pa kawq teq tuag che te yand, awg phad mawd awg mid ma he daq che lehd ma koz, laq kuhr cax vid che lehd ma koz, maq te. Muhd nuh maq lo chehd che muhd nuh maq cuh yad teq pa heh phehq vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Suh vehr che chaw teq pa kawq teq tuag che awg lawn Ghig sa Mod ser haq koz vid lar che heh, Mod ser buhq lar che liq awg khuhn nig hehd maq ghawn jaw la. A chud bid awg lawn buhq lar che teq tawn awg khuhn, Ngag awr lehr Ar brar hanr ve Ghig sa, Id caq ve Ghig sa he lehq Yar koq ve Ghig sa phehq che yaog,” lehz Ghig sa yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yawd awr lehr, suh vehr che chaw teq pa ve Ghig sa phehq che ma hez. Teq chehd che chaw teq pa ve Ghig sa phehq che yaog. Nig hehd duhd yaq jad che yaog lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Awg yand u ve haq, liq buhq var te ghad lag lehq i hehd tawd ghawg daq chehd che haq gha kad che te yand, Yer suq i hehd haq kha nehax kawq yaw khuhq vid che haq gha sir lehq, “Awg lid tawd khuhd awg gha lia awg khuhn lo khar ve te khuhd ir jad cheawg le,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yer suq yawd haq koz vid che, “Ir jad che ted mag awr lehr, Id sar rer laq chaw teq paog, na ser. A nig ved Jawd mawd Ghig sa awr lehr, yawd te ghad lehax Jawd mawd phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nawg ved ni ma awg gha lia, nawg ved co ha awg gha lia, nawg ved duhd khad awg gha lia he lehq nawg ved awg ghad awg sax awg gha lia nawg ved Jawd mawd Ghig sa haq gha haq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ni khuhd te khuhd awr lehr, Nawg awg ton haq haq che heh, nawg awg pad awg ki huh chehd che chaw haq gha haq che yaog. Awg lid tawd khuhd che ni khuhd haq keh ir che mad cawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Liq buhq var u ve kawq koz che, “Cawd che yaog, Sar lar-og. Ghig sa te ghad lehax cawg lehq, yawd ma hez ver awg kag awr ve Ghig sa mad cawg che lehz nawg koz che awr lehr thed jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kheh te lehq, ni ma awg gha lia, cud yiq ma yiq awg gha lia, awg ghad awg sax awg gha lia yawd haq haq lehq, a sug yawd awg ton haq haq che heh awg pad awg ki huh chehd che chaw haq haq che awr lehr, a mir tox tand che awg gha lia he lehq tand tug awg gha lia haq keh ir che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yawd kha nehax duhd ngawx lehq yaw khuhq che haq Yer suq gha mawg che te yand, “Nawg awr lehr Ghig sa ve muhd mig haq ma vid daq,” lehd yawd haq koz vid che yaog. U ve khaz nuhr chaw te ghad-eg liz yawd haq kawq na ngawx maq pir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yer suq bon yehg nux awg khuhn mar vid chehd-ag huh, yawd koz che, “Khreq awr lehr Dar viq ve Yad phu yaog lehz, a thoq te liq buhq var teq pa koz cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daq che kehg che Awg ha phu Dar viq haq duhd pawnr vid che awg khuhn yawd koz che, ‘Jawd mawd Ghig sa awr lehr ngag ved Jawd mawd haq koz vid che, “Nawg ved cand par teq pa haq nawg ved khi ho awg huhx lo ngag teh thad kha gag ngag ved laq yaq awr pax awr huh mi lar-oq,” lehd koz lar che yaog.’ ");
INSERT INTO lhi_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dar viq awg ton yawd haq Jawd mawd lehd koz che ver, khawd-ehg kheh te lehq yawd ved yad phu phehq tuawg le,” lehd koz na ngawx che yaog. Chaw awg mor nux u ve awr lehr, yawd ved tawd khuhd haq ha lehg ha ka na yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yawd mar vid chehd che awg khuhn yawd koz che, “Liq buhq var teq pa haq sa tiq teo. I hehd awr lehr, a poq yehg che haq deh lehq ca kaod te tod lehq kax khuhn lo su i hehd haq yawz yan ax che haq lehd ma koz, ");
INSERT INTO lhi_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","bon lawg kig awg khuhn awg mig awg phond cawg che mi khuhd haq mi che lehd ma koz, thi cad thi dawg kig lo awg mig awg phond cawg che mi kig haq mi che lehd ma koz, i hehd duhd cawd jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","I hehd awr lehr, meh chuhd ma ve yehg he lehq med nged teq pa haq hinx yug lehq, vend bax maq gha tuhaz tug muh chawa bon lawg che yaog. Su haq keh lex lehq ir jad che cir yanr che haq i hehd gha khanr tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Awg yand u ve khuhn, phu tand ke kig mehz khuhd suhr phawd awr yawd mi lar lehq, chaw kheh ma ve phu tand ke kig huh phu ke che haq ngawx chehd che yaog. Paw sa che chaw laex ghad phu kha peh ke che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kheh te lehq har ghuhd che meh chuhd ma te ghad lag lehq, tawnd sia pehq sanr nehax nid mag ke che yaog. Pehq sanr nehax u ve nid mag awr lehr, ted pehq phuhd lehax cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yer suq yawd ved awg laq ghuhd teq pa haq kug yug lehq i hehd haq koz vid che, “Ngag nig hehd haq awg cehg mag koz ax laq, phu tand ke kig huh ke che chaw awg gha lia haq keh har ghuhd che meh chuhd ma che te ghad awr lehr lex lehq ke mad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Awg lawn ghod ver, i hehd cawg mad jad che awg khuhn yug tuhz lehq ke che yaog. Kheh ma khuhd, yad mid che te ghad awr lehr, har ghuhd jad che awg khuhn, yawd ved a saq hu tug kha cawg che awg gha lia haq yug tuhz lehq ke che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yer suq bon yehg nux awg khuhn tuhz kae che te yand, yawd ved awg laq ghuhd te ghad yawd haq koz vid che, “Sar lar-og, ngawx ser. Khawd-ehg taw maq daq jad che huhx meh teq pa he lehq khawd-ehg taw maq daq jad che yehg teq pa chuhr huh cawg che.” ");
INSERT INTO lhi_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yer suq yawd haq kawq koz vid che, “Ir jad che yehg che teq pa haq nawg mawr-a la. Chuhr huh huhx meh ted dig awg thang ted dig mad cawg thad kha gag su te lug tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yer suq awr lehr, bon yehg nux mehz khuhd suhr phawd awr, Sar lonr keh thag lo mi chehd-ag huh, Per troq, Yar koq, Yod hanr he lehq Anr drehr teq pa lag lehq, ");
INSERT INTO lhi_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Awg ceng u ve teq pa khar thad phehaq tuawg le. Che awg gha lia phehq vehr tez che te yand awg hez khawd-ehg kheh te tuhaz tuawg le,” lehz yawd haq a yax yax khuhd na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yer suq i hehd haq kawq koz vid che, “Chaw te ghad-eg liz nig hehd haq maq gha her ka yug beg yug tug sa tiq tar-oq. ");
INSERT INTO lhi_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Chaw kha peh vad-ag ngag ved awg meh haq puhd veha lag lehq, Ngag awr lehr yawd yaog lehd koz lehq, chaw kha peh haq her ka yug beg yug tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Maq bawz che he lehq bawz daq veg lehd te chehd che awg lawn haq nig hehd gha kad che te yand, nig hehd kuhz ched che ni ma tad cawg vid. Awg ceng che ve teq pa gha phehaq tug yaog. Kheh ma khuhd, awg leh med mad gag ser. ");
INSERT INTO lhi_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Chaw ted ceng he lehq ted ceng, muhd mig te pez he lehq te pez yaq daq jiz daq tug yaog. Chehd kig ted kag peg ted kag awg khuhn lo mig hiz lag tug yaog. Meq che kaz che liz cawag tug yaog. Awg ceng che ve teq pa awr lehr, tuq che khanr che awg cuhz penr lehax te ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nig hehd a sug yawd awg ton haq sa tiq teo. Awg lawn ghod ver, jehg sehr phad awg mor teq pa ve laq kuhr awg khuhn su nig hehd haq chid aq vid tug yaog. Bon lawg kig teq pa awg khuhn lo su nig hehd haq jawq tug yaog. Ngag haq te lehq nig hehd muhd mig jawd mawd he lehq jawd mawd nux teq pa mehz khuhd suhr huh gha hox lar lehq, i hehd mehz khuhd suhr huh sax khiz gha khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ha lehg che bon khuhd awr lehr, chaw ceng awg gha lia haq awg kawd gha mar vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nig hehd haq suhx jehg ax tug su nig hehd haq chid aq vid che te yand, tawd khawd-ehg kheh te gha yaw tug haq awg kawd ta duhd har. Awg yand u ve awg khuhn nig hehd haq tawd yaw cuha che heh lehax yaw-og. Awg lawn ghod ver, tawd yaw che phad awr lehr, nig hehd ma hez, Daq che kehg che Awg ha phu yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kheh te lehq, a vix a nax te ghad he lehq te ghad suh tug chid aq daq tug yaog. Awr pa liz, a sug yawd ved awg yad haq chid aq tug yaog. Yad par yad mid teq pa liz, a sug yawd ved awg pa awg ye haq phuhz lehq dawz vehr vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ngag ved awg meh haq te lehq chaw awg gha lia nig hehd haq cand tug yaog. Kheh ma khuhd, awg leh kha gag yeg chehd che chaw awr lehr, thaer khuhq che haq gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Liq che haq ghawn che chaw awr lehr che kheh sir-oq. Te lug te sez vix che chaq chiz che awg ceng awr lehr, ma chehd cawd che chehd kig huh chehd che haq nig hehd gha mawg che te yand, Yud daq muhd mig awg khuhn lo chehd che chaw teq pa keh thag lo lawg khoq lo phawe lor. ");
INSERT INTO lhi_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kheh te lehq, yehg awg thang huh chehd che chaw tad kawq yaeq. Med nged ted ceng cear ca yug tug, yehg awg khuhn tad kawq gehe. ");
INSERT INTO lhi_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ha khuhn chehd che chaw liz, a sug yawd ved beg ke ca kawq yueg tug, tad koeq. ");
INSERT INTO lhi_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Awg yand u ve awg khuhn yad hu ma he lehq cux pehz nux chehd che chaw yad nehax cawg che chaw teq pa awr lehr, gha duhd har jad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Awg yand u ve awr lehr, muhd kaz yand maq gha cawd tug bon lawr-oq. ");
INSERT INTO lhi_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Awg lawn ghod ver, mig gig haq Ghig sa te phanr che teq ni haq tanr lehq yaq ni kha gag mad phehq lag jaw ser lehq, awg khaz nuhr liz mad kawq phehaq tug tuq jad khanr jad che ted ceng awr lehr, awg ni awg hax u ve teq pa awg khuhn phehaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Awg yand u ve haq Jawd mawd Ghig sa maq ngeh vid gha che ver, chaw te ghad-eg liz pong maq gha. Kheh ma khuhd, yawd lez yug lar che chaw teq pa haq te lehq, awg yand u ve haq yawd ngeh vid gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Awg yand u ve haq, chaw ted pehg pehar awr lehr, Ngawx-oq, Khreq chuhr huh chehd chehd che yaog. U huh chehd chehd che yaog lehz nig hehd haq koz ax ver, taq yonr. ");
INSERT INTO lhi_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Awg lawn ghod ver, ma hez hez che Khreq he lehq ma hez hez che cuh kar var teq pa tuhaz tug yaog. I hehd awr lehr, te gha ver lez yug lar che chaw teq pa haq her ka yug beg yug gha tug, and tug he lehq awg hez teq pa haq te mar vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nig hehd sa tiq teo. Mad phehq lag ser thad loar awg ceng gha lia ngag nig hehd haq koz ax lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tuq che khanr che awg yand u ve peg khaz nuhr, awg ni awg hax u ve teq pa awg khuhn, muhd ni naz tud vehr lehq, har pa liz awg ghiz mad kawq pawd. ");
INSERT INTO lhi_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Muhd ki sir teq pa muhd nuh maq lo cheag lehq, muhd nuh maq lo cawg che kand pax teq pa liz hiz hiz nad nad te veh tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kheh te lehq, chaw yad ve Yad phu awr lehr, awg mig awg phond he lehq ir jad che kand pax cawg che awg khuhn mog khuhn yaq che haq su gha mawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Awg yand u ve haq muhd uhg cir mig uhg phawd awr lo, mig gig awg leh med te lehq muhd nuh maq awg leh med kha gag, muhd nuh maq cuh yad teq pa haq yawd kae pe lehq, yawd lez yug lar che chaw teq pa haq phawng daq vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","A kud cehg haq tehz mar che tawd par hax che haq hend yur-oq. Awg mar mar-a lehq awg car car vehr che te yand, muhd god yand gag vehr tez che haq nig hehd sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Che ve heh te lehq, awg ceng che teq pa phehq lag chehd che haq nig hehd gha mawg che te yand, yawd awr lehr ghaz mir khuh awg pad huh lag gag vehr che haq nig hehd sir-oq. ");
INSERT INTO lhi_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ngag nig hehd haq awg cehg mag koz ax laq, che teq co mad pong veh ser huh liz, awg ceng che awg gha lia phehaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Muhd nuh maq he lehq mig naz ma mehx vehr tug yaog. Kheh ma khuhd, ngag ved tawd khuhd awr lehr, ma mehx vehr hawg. ");
INSERT INTO lhi_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Awg ni awg hax u ve haq chaw te ghad-eg liz maq sir. Muhd nuh maq cuh yad teq pa liz, Yad phu liz maq sir. Awr pa te ghad lehax sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Awg yand u ve khar thad lag gag tug haq nig hehd maq sir cheaq te lehq, sa tiq te lehq law lar-oq. ");
INSERT INTO lhi_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Awg yand u ve awr lehr, chaw te ghad awg kag awr ve muhd mig lo veh che haq sur che yaog. Yawd ved yehg khuhn tuhz veh thad, yawd ved awg ceg te ghad peg te ghad haq a sug yawd ved kanx chid aq vid lar haz lehq, ghaz mir khuh paog par haq liz kha nehax paog lar tug tawd pid lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kheh te lehq, yehg sehr phad kawq gag tug awr lehr, muhd phiq huh lehq nar, te khend lo lehq nar, ghaz phuh buhag lo lehq nar, muhd sawx lo lehq nar, khar thad kawq gag tug haq nig hehd maq sir cheaq te lehq, law lar-oq. ");
INSERT INTO lhi_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kheh ma hez ver, yawd teq pear lehax kawq gag lehq, nig hehd yuhq mir ka chehd che haq yawd gha mawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nig hehd haq ngag koz ax lar che heh, chaw awg gha lia haq ngag koz vid che, paog lar-oq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Niq ni peg ver, Par sar khar pawehd he lehq Khaor mod awg khuhn did maq ke che pawehd te che awg yand gag vehr tug yaog. Awg yand u ve haq, paw khod nux teq pa he lehq liq buhq var teq pa awr lehr, khawd-ehg kheh te lehq her ka che awg khuhn yawd haq pheh yug lehq dawz vehr tug ca che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Awg lawn ghod ver, i hehd awr lehr, “Chaw kheh ma ve diz diz huhd huhd maq gha te vid tug, pawehd te che awg yand awg khuhn taq te,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yer suq awr lehr Ber tar niq khaz khuhn khir tuq var phehq jaw che Sid monr ve yehg khuhn teh cuh pad huh mi cad chehd-ag huh, yad mid te ghad gehag che yaog. Yawd awr lehr, awg phuhd khaz jad che nag mand huhx ke lar che phux-u ghad te che huhx meh kaw ted mag yug veha lag lehq, a kaw u ve haq dawz khod peg lehq Yer suq ve a kor haq nag mand huhx u ve nger puhr vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ted pehg pehar nez nag lehq koz che, “A thoq vawr te awg bon mad cawg che awg khuhn nag mand huhx che haq yehd vehr cheawg le. ");
INSERT INTO lhi_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nag mand huhx che ve haq sehz ha thehq phaz huhd lehq, har yad ghuhd yad teq pa haq pehg vid cawd che yaog,” lehz te ghad he lehq te ghad koz daq che yaog. Kheh te peg lehq, yad mid u ve haq i hehd ded che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kheh ma khuhd Yer suq koz che, “Yad mid che haq ta ded. Nig hehd a thoq te yawd haq soq saq vid cheawg le. Yawd ngag haq daq che ted ceng tea che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Har che ghuhd che chaw teq pa nig hehd geh khar thad liz chehd chehd che yaog. Nig hehd te gad ver, khar thad te yand lehd ma koz, i hehd haq daq che awg ceng te vid gha che yaog. Kheh ma khuhd, ngag nig hehd geh khar thad liz chehd tug ma hez. ");
INSERT INTO lhi_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yad mid che awr lehr, te vix te gha che heh te vehr che yaog. Ngag awg ton haq tur tug awg pun, awg ghud suhr thad loar yawd nag mand huhx puhr ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ngag nig hehd haq awg cehg mag koz ax laq, ha lehg che bon khuhd mig gig awg kag gha lia lo ca mar vid che khar ve ted kag lehd ma koz, yad mid che haq duhd nuhd tug awg pun yawd te lar che kanx che haq koz mar vid tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Awg yand u ve khuhn, awg laq ghuhd teq chi ni ghad awg khuhn Yud daq Id sar kar rir oq awr lehr, Yer suq haq paw khod nux teq pa ve laq kuhr awg khuhn chid aq vid tug i hehd chehd lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","I hehd tawd u ve haq gha kad che te yand ha lehg jad lehq, yawd haq phu pid tug kar tiq te lar che yaog. Kheh te lehq yawd haq chid aq vid tug, daq che awg yand haq Yud daq ca chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Khaor mod awg khuhn did maq ke che pawehd awg kawd teq ni huh, par sar khar yawg nehax haq dawz tand che teq ni awg khuhn, Yer suq ved awg laq ghuhd teq pa yawd chehd lo lag lehq koz che, “Par sar khar pawehd cad tug, nawg awg pun khar lo ted kag ngag hehd haq ca ghu cuha vid gad lehq le,” lehz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kheh te lehq, yawd yawd ved awg laq ghuhd ni ghad haq kae pe lehq koz vid che, “Med awg khuhn lo kae-o. A kaz mawq khu chid tod che haw khaz te ghad haq nig mag gha phud daq tug yaog. Yawd khaz nuhr ghaq kae lehq, ");
INSERT INTO lhi_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","yawd khar lo gehe che lehd ma koz, yehg sehr phad haq che kheh koz vid-oq. ‘Sar lar koz ax che, “Ngag he lehq ngag ved awg laq ghuhd teq pa geh teq geha Par sar khar pawehd cad tug, ngag awg pun teh lar che khehx chaw bawehd khar lo le.”’ ");
INSERT INTO lhi_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kheh te lehq, chehd kig kha nehax ghu lar vehr che, awg thang ted thaeg bawehd ir che te bawehd yawd nig mag haq sir mar ax tug yaog. U huh a nig awg pun ghu lar-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Awg laq ghuhd u ve ni ghad tuhez lehq, med awg khuhn lo gehe che te yand, yawd koz ax che heh gha mawg lehq, Par sar khar pawehd cad tug awg pun ghu lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Muhd sux naz vehr huh, awg laq ghuhd teq chi ni ghad geh yawd lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","I hehd awr mi cad chehd-ag huh Yer suq awr lehr, “Ngag nig hehd haq awg cehg mag koz ax laq, nig hehd awg khuhn lo ngag geh teq geha khaz cad che chaw te ghad awr lehr, ngag haq kawq phuhz tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","I hehd duhd har lehq, “Ngag la,” lehd koz te ghad peg te ghad yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Kheh te lehq yawd koz che, “Teq chi ni ghad awg khuhn ngag geh te khehd khuhn lehax khaz cad chehd che chaw te ghad yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chaw yad ve Yad phu awr lehr, yawd ved awg lawn buhq lar che heh, yawd gha koeq tug yaog. Kheh ma khuhd, chaw yad ve Yad phu haq chid aq che chaw te ghad awr lehr gha duhd har jad tug yaog. Chaw u ve maq pawag che heh ver, yawd awg pun daq jad che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","I hehd cad chehd-ag huh, yawd khaor mod haq yug lehq bon haq chid muh che yaog. Kheh te peg lehq yawd khaor mod haq khehq lehq awg laq ghuhd teq pa haq pid lehq koz che, “Yur-oq. Che awr lehr ngag ved awg ton yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kawz khehd haq liz yawd yug lehq, bon haq chid muh peg lehq i hehd haq pid lehq, i hehd awg gha lia kawz khehd u ve haq dawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kheh te peg lehq yawd kawq koz che, “Che awr lehr kar tiq sax caz haq caz daq che ngag ved awg suhr yaog. Awg suhr che awr lehr, chaw kha peh ve awg pun nger puhr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ngag nig hehd haq awg cehg mag koz ax laq, Ghig sa ve muhd mig awg khuhn a pehx med ghig awg suhx haq gha dawg tug awg ni kha gag, ngag a pehx med ghig haq mad kawq dawg,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kheh te lehq, i hehd ka mig khuhd ka lar haz lehq i hehd tuhez lehq Sar lonr kehaq lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Awg yand u ve khuhn Yer suq i hehd haq kawq koz vid che, “Nig hehd awg gha lia ngag haq chid bag vehr tug yaog. Awg lawn ghod ver, ‘Yawg huhx var haq ngag dawz vehr lehq, yawg teq pa phaz daq lehq ted kag teq kheh phaw veh tug yaog,’ lehz Liq phu khuhn buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kheh ma khuhd, ngag kawq teq tuag peg khaz nuhr nig hehd haq keh awg kawd Gar liq lehd muhd mig lo ngag kae tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Awg yand u ve khuhn Per troq koz che, “Su awg gha lia nawg haq chid bag liz ngag awr lehr nawg haq ma chid bag hawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yer suq awr lehr, “Ngag nawg haq awg cehg mag koz ax laq, yaq pehax ghaz phuh ni pawz mad buhg ser huh, nawg ngag haq sehr pawz kha gag chid bag tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Per troq awr lehr, “Nawg geh teq geha ngag gha suh liz, nawg haq ngag ma chid bag hawg,” lehz yawd haq hehnd chawa koz vid che yaog. I hehd awg gha lia liz u kheh koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Awg yand u ve haq Ger ser mar niq lehd koz che ted kag huh i hehd gaeg lehq, “Ngag bon ca lawg tod-ag huh nig hehd chuhr huh mi lar-oq,” lehz yawd ved awg laq ghuhd teq pa haq Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kheh te lehq, Per troq, Yar koq, Yod hanr teq pa haq yawd geh teq geha sir ve kae che yaog. Awg yand u ve khuhn yawd ni ma awg khuhn duhd har jad, soq saq jad vehr lehq, ");
INSERT INTO lhi_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","i hehd haq koz vid che, “Ngag ni ma duhd har jad che suh vehr tez che yaog. Chuhr huh chehd lar lehq law lar-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Kheh te peg lehq, yawd awg nuz awr a cehax kae peg lehq, yawd mig kag lo boz cuhx lar lehq, awg yand che ve yawd haq pong ax gha ver, pong ax tug bon lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Ar baq A pa-og, nawg awg ceng gha lia ve haq te gha che yaog. Kawz khehd che ve ngag haq pong kae cuha ax laoq. Kheh ma khuhd, ngag a lor cawd che heh tad phehq vid. Nawg a lor cawd che heh phehq vehr vid-oq,” lehd koz lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Yawd kawq gag che te yand, i hehd yuhq mir ka chehd che haq gha mawg lehq Per troq haq koz vid che, “Sid monr-og, nawg yuhq mir ka chehd cheawg la. Teq nar rir lehax liz nawg paog lar maq gha la. ");
INSERT INTO lhi_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Nig hehd ber che lawd che awg khad haq maq gha kae tug bon lawg lehq law lar-oq. Nig hehd te gad che ni ma cawg liz, awg suhr awg sar awr lehr awg ghad nud che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Kheh te peg lehq, yawd te pawz kawq kae lehq, awg kawd thad huh lawg che heh te lehq bon kawq lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Yawd te pawz kawq kawaq huh, i hehd yuhq mir geq jad cheaq te lehq yuhq mir ka chehd che haq yawd gha mawg che yaog. Yawd haq khawd-ehg kheh kawq koz vid tug i hehd maq sir. ");
INSERT INTO lhi_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sehr pawz te pawz yawd kawaq lehq koz vid che, “Nig hehd yuhq mir ka lehq ghad jehd chehd ser cheawg la. Pehog, chaw yad ve Yad phu awr lehr vend bax yad teq pa ve laq khuhn lo chid aq che haq gha khanr che awg yand gag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tu, kae veg. Ngawx lor, ngag haq chid aq vid var awg pad huh lag gag vehr-or,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yawd tawd yaw chehd-ag huh, cuh yad teq chi ni ghad awg khuhn lo Yud daq meh che te ghad lag lehq, a teh puhd lehq suhz tag taz che chaw awg mor nux liz yawd geh lag che yaog. Chaw awg mor nux u ve awr lehr, paw khod nux teq pa, liq buhq var teq pa he lehq awg hox chaw mawd teq pa cuh peha lar che chaw phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yawd haq kawq phuhz che phad te ghad awr lehr, i hehd haq awg hez che kheh te tug koz vid lar che, “Ngag bux vid che chaw te ghad awr lehr yawd yaog. Yawd haq pheh yug ve lehq kha nehax sir ve kae lor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yawd lag che te yand Yer suq chehd lo har naq kae lehq, “Sar lar-og,” lehd koz lehq yawd haq bux vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kheh te lehq i hehd Yer suq haq pheh yug vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Awg pad huh hox chehd che chaw teq pa awg khuhn te ghad awr lehr, yawd ved a teh ghawg tuhaz lehq, paw khod nux vig lar che awg ceg haq chuh lehq nar puh chez vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yer suq i hehd haq koz vid che, “Nig hehd awr lehr, chaw khuhd haq ca pheh yug che heh, a teh he lehq suhz tag teq pa yug veha lag lehq ngag haq ca pheh yuag cheawg lehg. ");
INSERT INTO lhi_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ni gha lia bon yehg nux awg khuhn ngag nig hehd geh chehd lehq mar vid che liz, nig hehd ngag haq maq pheh yug. Kheh ma khuhd, che kheh te lag che awr lehr, Liq phu khuhn buhq lar che heh phehaq vid tug awg pun yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kheh te lehq, yawd ved awg laq ghuhd teq pa yawd haq saw chid bag lar haz lehq phaw veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Chaw hax var te ghad awr lehr, piq pha te khoz lehax yawd awg ton haq vend lar lehq Yer suq khaz nuhr ghaq kae che yaog. Chaw u ve teq pa yawd haq pheh yug che te yand, ");
INSERT INTO lhi_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","piq pha u ve haq yawd kuhz chid bag lar haz lehq awg ku ni te phaw veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kheh te lehq i hehd awr lehr, Yer suq haq paw khod nux chehd lo yug ve kae che yaog. Paw khod nux teq pa, awg hox chaw mawd teq pa he lehq liq buhq var teq pa awg gha lia u huh phoz lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Per troq awr lehr, paw khod nux ve sax nax awg pad huh ko lar kig awg khuhn phawd awr kha gag Yer suq khaz nuhr a cehax vid-aq lo ghaq kae lehq, paog par teq pa geh mi lehq, a mir lehg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Paw khod nux teq pa he lehq jehg daq var awg mor awg gha lia awr lehr, Yer suq haq gha dawz vehr tug, sax khiz khanr var teq pa haq ca che liz, sax khiz ca mad mawg. ");
INSERT INTO lhi_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Awg lawn ghod ver, chaw kha peh yawd awg lawn ma hez hez che sax khiz khanr che liz, i hehd sax khiz khanr che maq hawr daq. ");
INSERT INTO lhi_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Awg yand u ve khuhn chaw ted pehg pehar tuag lehq, yawd awg lawn ma hez hez che sax khiz khanr lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Laq kuhr te lar che bon yehg nux che haq ngag te lug lehq, laq kuhr maq te che awg kag awr ve bon yehg nux haq sehr ni awg khuhn lo lehax ngag kawq te tug yaog lehz yawd koz che haq ngag hehd gha kad peg che yaog,” lehz i hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","I hehd kheh te sax khiz khanr che liz, maq hawr daq. ");
INSERT INTO lhi_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kheh te lehq, paw khod nux tu lehq awg kaw jen lo hox lar lehq, “Nawg teq chaweh liz maq koz khuhq cheawg la. Chaw che teq pa nawg awg lawn a thoq sax khiz khanr cheawg le,” lehz Yer suq haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kheh ma khuhd, Yer suq taq chuhax chehd lar lehq teq chaweh maq koz khuhq che yaog. Paw khod nux te pawz kawq koz vid che, “Nawg awr lehr Awg bon ir che phad Ghig sa ve Yad phu Khreq lehd koz che te ghad yaog la,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yer suq kawq koz che, “Yaog, ngag yaog. Kheh te lehq, chaw yad ve Yad phu awr lehr, Kand pax awg sehr phad ve laq yaq awr pax awr huh mi lehq, muhd nuh maq ve mog khuhn yaq che haq nig hehd gha mawg tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Kheh te lehq paw khod nux awr lehr, yawd khad yawad, yawd ved a poq haq juhq pheq lehq koz che, “A nig a thoq haq sax khiz kawq lor sear le. ");
INSERT INTO lhi_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Yawd awr lehr, Ghig sa haq maq sawnr ma caz koz che haq nig hehd gha kad vehr che yaog. Nig hehd khawd-ehg kheh duhd-aq le,” lehd koz na ngawx che te yand, “Yawd awr lehr suh kenr che yaog,” lehz i hehd awg gha lia Yer suq haq suhx jehg suhx taz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Awg yand u ve haq, chaw ted pehg pehar yawd haq cux ghig pheq puhr che, yawd ved mehz khuhd haq beh lar lehq yawd haq chung lehq koz che, “Ghig sa ve cuh kar var heh te lehq, a sug nawg haq chung che ngag hehd haq koz ax laoq,” lehz yawd haq koz vid che yaog. Paog par teq pa liz yawd haq dawz lehq yug ve veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Per troq awr lehr, awg huhx lo ko lar che awg khuhn phawd awr huh chehd chehd che te yand, paw khod nux ve awg ceg ma te ghad lag lehq, ");
INSERT INTO lhi_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Per troq a mir lehq chehd che haq gha mawg che te yand, yawd haq kha nehax ngawx peg lehq, “Nawg liz Nar sar rehq chaw Yer suq geh chehd che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kheh ma khuhd, Per troq ghawg khaz lehq, “Nawg koz che haq ngag maq sir, na liz na maq gha,” lehd koz che yaog. Kheh te peg lehq, ko lar che ghaz mir awg bag huh yawd tuhz veh lehq ghaz phuh liz buhg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Awg ceg ma u ve te pawz yawd haq kawq mawg che te yand, awg pad huh hox chehd che chaw teq pa haq, “Chaw che te ghad awr lehr, i hehd awg khuhn chehd che chaw te ghad phehq che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kheh ma khuhd yawd te pawz kawq ghawg khaz che yaog. Awg khaz nuhr maq muh tand gaeg lehq awg pad huh hox chehd che chaw teq pa koz che, “Nawg awr lehr awg cehg mag i hehd awg khuhn chehd che chaw te ghad phehq che yaog. Awg lawn ghod ver, nawg Gar liq lehd chaw phehq che yaog,” lehz Per troq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Kheh te lehq yawd khad yawad, yawd awg ton haq khen lehq, “Nig hehd koz che te ghad haq ngag maq sir,” lehd koz lehq khanr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Teq pear lehax ghaz phuh ni pawz te pawz buhg tuhaz che yaog. “Ghaz phuh ni pawz mad buhg ser huh nawg ngag haq sehr pawz kha gag chid bag tug yaog,” lehz Yer suq yawd haq koz vid lar che haq Per troq duhd nuhd-ag che yaog. Yawd u ve haq kawq duhd nuhd-ag lehq jehd cid ma ghad vehr lehq hax ceh nux maz huhg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Muhd thid-ag che te yand, teq pear lehax paw khod nux teq pa he lehq awg hox chaw mawd teq pa, liq buhq var teq pa he lehq jehg daq var awg mor awg gha lia geh jehg daq che yaog. I hehd Yer suq haq pheh lar peg lehq sir ve lehq, jawd mawd Pid laq ve laq khuhn lo yawd haq chid aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Awg yand u ve khuhn jawd mawd Pid laq koz che, “Nawg awr lehr, Yud daq chaw teq pa ve jawd mawd nux yaog la,” lehz yawd haq na ngawx che yaog. “Nawg koz che cawd che yaog,” lehz Yer suq yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Paw khod nux teq pa awr lehr, yawd haq vend bax hax ceh nux tar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kheh te lehq, jawd mawd Pid laq koz che, “Nawg teq chaweh liz mad kawq koz vehr cheawg la. I hehd nawg haq vend bax khawd-ehg ma tar che haq ngawx ser,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kheh ma khuhd, Yer suq tawd teq pear liz maq yaw khuhq cheaq te lehq jawd mawd Pid laq and che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pawehd u ve haq te che te yand, thawnr khuhn chehd che chaw teq pa awg khuhn, muhd mig yad teq pa lawg che te ghad haq jawd mawd Pid laq phehd vid che awg lid cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Awg yand u ve haq, muhd mig haq phuhz veh lehq chaw haq dawz vehr che Bar rar baq meh che chaw te ghad cawg che yaog. Yawd awr lehr, phuhz veh che awg chawd teq pa geh teq geha thawnr khuhn pheh ke lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Awg yand u ve khuhn, chaw awg mor nux jawd mawd Pid laq chehd lo kae lehq awg lid cawg che heh tea tug i hehd lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jawd mawd Pid laq awr lehr, “Nig hehd awg pun Yud daq chaw teq pa ve jawd mawd nux haq phehad vid gad cheawg la,” lehz i hehd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Awg lawn ghod ver, paw khod nux teq pa Yer suq haq khawehx che ni ma cawg cheaq te lehq, yawd haq chid aq ax che haq jawd mawd Pid laq sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kheh ma khuhd, Yer suq haq ma phehd vid lehq Bar rar baq haq phehd vid tug, paw khod nux teq pa awr lehr chaw awg mor nux haq ca joz phuhz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jawd mawd Pid laq awr lehr, “Kheh te ver, Yud daq chaw teq pa ve jawd mawd nux lehz nig hehd koz che te ghad haq ngag khawd-ehg kheh gha te tuawg le,” lehd koz i hehd haq kawq na ngawx che te yand, ");
INSERT INTO lhi_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","“Yawd haq laq kan thag huh thaq vehr lor,” lehd koz, i hehd hax ceh nux kawq kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Jawd mawd Pid laq i hehd haq koz vid che, “A thoq haq te lehq le. Yawd haeg che a thoq maq ted ceng haq te cheawg le,” lehd koz na ngawx che te yand, “Yawd haq laq kan thag huh thaq vehr lor,” lehd koz, i hehd ghaq te maq heh hax ceh nux kawq kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kheh te lehq jawd mawd Pid laq awr lehr, chaw awg mor nux ni ma cawd tug te gad cheaq te lehq, i hehd awg pun Bar rar baq haq phehd vid lehq, Yer suq haq jawq peg lehq, laq kan thag huh thaq vehr tug chid aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Awg yand u ve khuhn, maq yad teq pa awr lehr muhd mig jawd mawd nux ve hawx yehg haq caz daq che ko lar che awg khuhn lo Yer suq haq sir ve kae lehq, maq yad ted taq ve awg gha lia haq kug phoz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","I hehd awr lehr, pha awg naz mix-a te che a poq yehg maq yawd haq deh vid che yaog. A chud te haq liz yug lehq, si ux cuhr heh te ghaq lehq yawd haq khuhz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","“Yud daq ve jawd mawd-og, nawg awg bon ir vid-oq,” lehz i hehd yawz yan che heh te lehq yawd haq koz gid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kheh te peg lehq, i hehd pund tag haq yug lehq yawd ved a kor haq kaod dawz che yaog. Yawd haq cux ghig kaod pheq puhr lehq, nar kheh teh mi lar lehq yawd haq a kor kaod pi gid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Yawd haq maq sawnr ma caz te peg lehq, awg naz mix-a te che a poq yehg maq haq i hehd kuhz kha lehq yawd ved a poq haq kawq fex vid che yaog. Kheh te lehq laq kan thag huh thaq vehr tug, i hehd yawd haq sir ve tuhez che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ar ler sar duq he lehq Rud phuq awr pa, Sid monr meh che Kud rer ner med yad te ghad, ha khuhn kae kawaq che haq i hehd gha mawg lehq, yawd haq bax nex lehq Yer suq ve laq kan haq taz cuh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Gawd laq gawd taq lehd koz che chehd kig huh i hehd Yer suq haq yug ve kae che yaog. Awg meh u ve cuhx kig awr lehr, a kor ghuhd lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mud rar khuhq huhz lar che a pehx med ghig su yawd haq taw vid che liz, yawd mad dawg. ");
INSERT INTO lhi_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Su yawd haq laq kan thag huh thaq ke peg khaz nuhr, i hehd awr lehr beg ke khar ve te khoz haq a sug gha cawd che haq, i hehd nar bar kehx yug lehq yawd ved beg ke haq pehg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","I hehd yawd haq laq kan thag huh thaq ke lar che awr lehr, muhd sawx kuhd nar rir te yand yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","“Yud daq chaw teq pa ve jawd mawd nux yaog,” lehd koz yawd haq vend bax tar che liq i hehd buhq nehx lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Kheh te lehq yawd geh teq geha chaw khuhd ni ghad haq liz, laq yaq awr pax awr te ghad, laq vehr awr pax awr te ghad, laq kan thag huh thaq ke lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yig yig lag lag te che chaw teq pa awr lehr, yawd haq maq sawnr ma caz koz gid lehq, a sug yawd ved a kor hiz lehq koz che, “Ag log ngawx ser, bon yehg nux haq te lug lehq sehr ni awg khuhn kawq te gha hawg ghod che chaw-og, ");
INSERT INTO lhi_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","nawg awg ton haq yug pong vid lehq laq kan thag huh yaq laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Paw khod nux teq pa liz, liq buhq var teq pa geh teq geha che ve heh te lehq yawd haq koz gid ghig gid lehq koz che, “Su haq vawr, yawd ga gha che yaog. Kheh ma khuhd, yawd awg ton haq yawd ga maq gha. ");
INSERT INTO lhi_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A nig gha mawg lehq gha yonr tug, Khreq lehd koz che Id sar rer laq ve jawd mawd nux haq laq kan thag huh yaq vid-oq,” lehz te ghad he lehq te ghad koz daq che yaog. Yawd geh teq geha laq kan thag huh thaq ke lar che ni ghad liz, yawd haq maq sawnr ma caz koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Muhd kaw cuhaz huh loar tanr lehq muhd phiq phawd awr seh nar rir kha gag, mig gig awg gha lia awg naz tud phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Muhd phiq phawd awr seh nar rir gaeg che te yand, Yer suq awg khuhd hehnd chawa te lehq, “Ed liq, Ed liq, lar mar sar baq tar ni,” lehd koz kug che yaog. Cuhx kig awr lehr, “Ngag ved Ghig sa-og, ngag ved Ghig sa-og, a thoq te nawg ngag haq chid bag lar haz ax cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Awg pad huh hox chehd che chaw ted pehg pehar tawd u ve haq gha kad che te yand, “Ngawx lor, yawd Ed lid yaq haq kug che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kheh te lehq, chaw te ghad cex kae lehq, a kaz chuhq vid tug pha ted mag haq yug lehq a pehx med ghig ce maq awg khuhn tur ke peg lehq, pund tag haq choz lehq yawd haq taw vid che yaog. Chaw u ve te ghad koz che, “Law lar ser. Ed lid yaq yawd haq ca yug yaq vid-ag tug lehq nar, ngag hehd ngawx lar sar,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yer suq awg khuhd hehnd chawa kug lehq, sax chez vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Awg yand u ve haq, bon yehg nux ve pha thed lar che awr lehr, awg thag lo te lehq awg huhx lo kha gag ni khod te pheq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Yawd kheh te sax chez vehr che haq yawd mehz khuhd suhr huh hox chehd che maq yad awg hox te ghad gha mawg che te yand, “Chaw che awr lehr awg cehg mag Ghig sa ve yad phu te ghad phehq che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","U huh a cehax vid-aq lo yad mid teq pa liz chehd lar ngawx chehd che yaog. I hehd awg khuhn, Mar riq Mar gar dar laq, a saq i che Yar koq te ghad he lehq Yod sehq ve awr ye Mar riq he lehq Sar lor mer teq pa chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","I hehd awr lehr, Yer suq Gar liq lehd muhd mig awg khuhn chehd-ag huh, yawd khaz nuhr ghaq kae lehq yawd haq ga vid lehq te car te taw vid tod che yad mid teq pa yaog. Yer ruq sar lehnr med lo yawd geh teq geha taz lar che awg kag awr ve yad mid laex ghad liz u huh chehd lehq ngawx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Sa ba to awg ni mad gag ser awg ghud suhr teq ni muhd phiq vehr huh, ghu hehnd che awg ni cawd cheaq te lehq, ");
INSERT INTO lhi_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","awg mig awg phond cawg che jehg daq var, Ar riz mar thehr med yad Yod sehq meh che te ghad lag che yaog. Yawd awr lehr, Ghig sa ve muhd mig haq duhd law chehd che chaw te ghad phehq che yaog. Yawd ni ma tag che khuhn te lehq, jawd mawd Pid laq chehd lo kae lehq Yer suq ve awg ton haq lawg yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Awg yand kheh muha lehax liz suh vehr che haq te lehq, jawd mawd Pid laq and lehq maq yad awg hox haq kug yug lehq, “Yawd suh vehr cehg mag che yaog la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Yer suq suh vehr che awg lawn maq yad awg hox koz vid lehq jawd mawd Pid laq gha sir che te yand, Yer suq ve awg ton Yod sehq haq pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kheh te lehq, Yod sehq pha phua liz vig lehq, Yer suq ve awg ton haq yug yaq peg lehq, pha phua yug huhz thiz peg lehq, huhx meh thuhz lar che tur phuh awg khuhn ke lar che yaog. Tur phuh awg khod med huh huhx meh phuhz chuhd lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mar riq Mar gar dar laq he lehq Yod sehq ve awr ye Mar riq awr lehr, yawd teh lar kig haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sa ba to awg ni peg che te yand, Mar riq Mar gar dar laq, Yar koq ve awr ye Mar riq he lehq Sar lor mer teq pa awr lehr, Yer suq ve awg ton haq ca puhr vid tug san huhx vig che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Teq sinx awg khuhn lo awg kawd maq teq ni nag mi sawx ted naq muhd ni tuhaz che te yand, i hehd tur phuh lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kheh te lehq i hehd awr lehr, “Tur phuh awg khod med huh chuhd lar che huhx meh haq a nig haq a sug phuhz kha ax tuawg le,” lehz te ghad he lehq te ghad koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","I hehd chid ngawx che te yand, huhx meh u ve phuhz kha lar che haq gha mawg che yaog. Huhx meh u ve awr lehr ir jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tur phuh awg khuhn i hehd gehe che te yand, phux-u ghad te che a poq yehg maq veq lar che chaw hax var te ghad laq yaq awr pax awr huh mi chehd che haq gha mawg lehq i hehd kuhz jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yawd i hehd haq koz vid che, “Ta kuhz. Laq kan thag huh thaq vehr che Nar sar rehq chaw Yer suq haq nig hehd ca tod che haq ngag sir che yaog. Yawd kawq teq tuag vehr che yaog. Yawd chuhr huh ma chehd. Yawd haq teh lar kig huh ca ngawx laoq. ");
INSERT INTO lhi_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kheh ma khuhd nig hehd kae lehq, yawd ved awg laq ghuhd teq pa he lehq Per troq haq che kheh koz vid-oq. Nig hehd haq keh awg kawd Gar liq lehd muhd mig lo yawd kae tug yaog. Yawd nig hehd haq koz ax lar che heh, u huh nig hehd yawd haq gha mawg tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yad mid u ve teq pa awr lehr, tur phuh khuhn tuhaz lehq, kuhz ched lehq and jad che awg khuhn i hehd cex koeq che yaog. I hehd kuhz jad cheaq te lehq, te ghad-e haq liz ma koz vid. ");
INSERT INTO lhi_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Teq sinx awg khuhn awg kawd maq teq ni nag mi sawx ted naq Yer suq kawq teq tuag peg khaz nuhr yawd awg ton Mar riq Mar gar dar laq haq awg kawd maw vid che yaog. Yad mid u ve awr lehr, pong lag thad ned suhr kheh geh chehd che haq Yer suq ghaq kog vid jaw che yad mid te ghad phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yer suq geh chehd jaw che chaw teq pa duhd har gad har lehq huhg chehd che te yand, Mar riq kae lehq i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yer suq teq chehd lehq Mar riq yawd haq gha mawg che awg lawn i hehd gha kad che te yand, maq yonr. ");
INSERT INTO lhi_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","U ve awg khaz nuhr, i hehd awg khuhn chaw ni ghad khaz khuhn kawq koeq tod-ag huh, yawd awg hoq awg han pa vehr che awg khuhn yawd awg ton ix mag haq maw vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ix mag kawaq lehq, chehd lar haz che chaw teq pa haq koz vid che liz i hehd maq yonr. ");
INSERT INTO lhi_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","U ve awg khaz nuhr, cuh yad teq chi te ghad awr mi cad chehd che te yand, yawd awg ton i hehd haq maw vid che yaog. I hehd maq yonr vix che he lehq ni ma liz heh che haq te lehq, yawd i hehd haq ded vid che yaog. Awg lawn ghod ver, yawd kawq teq tuag peg khaz nuhr, yawd haq gha mawg che chaw teq pa ve khuhd haq i hehd maq yonr cheaq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kheh te lehq, yawd i hehd haq koz vid che, “Mig gig khod-aq awg kag gha lia lo kae lehq chaw awg gha lia haq ha lehg che bon khuhd ca mar vid-oq. ");
INSERT INTO lhi_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yonr lehq baz tiz sar khanr yug che chaw awr lehr, thaer khuhq che haq gha tug yaog. Maq yonr che chaw awr lehr, cir yanr che haq gha khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yonr che chaw teq pa awg khuhn awg hez che teq pa haq gha mawg tug yaog. Ngag ved awg meh haq cud lehq, ned teq pa haq i hehd ghaq kog tug yaog. I hehd tawd laex ceng khuhd te yaw vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","I hehd awr lehr, vig teq pa haq yug gha tug yaog. Awg tuhq ma haq dawg che liz, i hehd teq chaweh mad phehq. Chaw nag teq pa awg thag lo i hehd laq kuhr tar lehq chaw u ve teq pa na vid tug yaog,” lehz Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kheh te lehq, Jawd mawd Yer suq i hehd haq u kheh koz vid peg khaz nuhr, Ghig sa yawd haq muhd nuh maq lo chid taez lehq, Ghig sa ve laq yaq awr pax awr huh yawd mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Awg laq ghuhd teq pa liz tuhz kae lehq awg kag gha lia lo bon khuhd ca mar vid che yaog. Jawd mawd Ghig sa awr lehr i hehd geh kanx te lehq awg hez teq pa te tuhaz che awg khuhn, bon khuhd u ve haq yeg chehd lar vid gha che yaog.");
INSERT INTO lhi_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tar ir yawz yan che Thawd phid luq-og, a nig awg khuhn awg cehg mag phehq jaw peg che awg lawn che ve teq pa haq chaw laex ghad buhq tuhz lar peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Awg kawd maq thad loar, bon khuhd mar par teq pa i hehd mehz sir kha ter tear gha mawg lar che heh te lehq, a nig haq bon khuhd mar par teq pa saw koz ax lar vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kheh te cheaq te lehq, ngag liz awg lawn che ve haq ted thaeg peg ted thaeg ghaq sawnr ghaq tehz ngawx lag lehq nawg awg pun sir sa tug buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nawg gha hend lar haz peg che awg lawn u ve teq pa, awg cehg mag cawd che yaog, lehz gha sir tug awg pun ngag duhd ngawx lehq buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yud daq muhd mig jawd mawd Her roq ve awg co haq, Ar bid yaq ve awg mor khuhn chehd che Yar khar liq meh che Ghig sa ve paw khod te ghad cawg che yaog. Yawd ved awg mid ma awr lehr, Ar ronr ve awg ceng awg khad khuhn chehd che Id lid sar behq meh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ghig sa ve mehz caz awg khuhn chaw che ni ghad awr lehr, Ghig sa ve awg lid tawd khuhd he lehq teh lar che awg lid awg khad haq kha nehax haq sax lehq te yaq kig mad cawg cheaq te lehq, ix mag haq chaw daq chaw thed te sawnr lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kheh liz ix mag awr lehr, mawd jad vehr liz yad mad cawg. Awg lawn ghod ver, Id lid sar behq chaw meh ma phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yar khar liq ve awg mor kanx te tug awg yand gaeg lehq, Ghig sa mehz khuhd suhr yawd paw khod ve kanx haq geh te chehd-ag huh, ");
INSERT INTO lhi_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Yer ruq sar lehnr bon yehg nux khuhn geh lehq sa huhx geh tox tand-eg tug, paw khod teq pa awg lid cawg lar che heh, nar bar kehx yug lehq yawd gha cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Sa huhx haq tox tand chehd che awg yand u ve khuhn, chaw awg mor nux liz awg bag huh chehd lar lehq bon lawg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ghig sa ve muhd nuh maq cuh yad te ghad tuhaz lehq, sa huhx tox tand kig huh laq yaq awr phawd awr hox chehd lawz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Yar khar liq muhd nuh maq cuh yad haq gha mawg lehq, tez mag nuh he lehq kuhz jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Muhd nuh maq cuh yad koz che, “Yar khar liq-og, ta kuhz. Ghig sa nawg ved bon lawg khuhd haq gha kad vehr che yaog. Nawg mid ma Id lid sar behq yad par te ghad hu pawag tug yaog. Yawd haq Yod hanr lehd koz meh vid-oq. ");
INSERT INTO lhi_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nawg ha lehg duhd sa che haq gha lehq, yawd pawag cheaq te lehq chaw kha peh vad-ag ha lehg duhd sa che haq gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Awg lawn ghod ver, yawd Jawd mawd Ghig sa ve mehz caz awg khuhn chaw ir chaw muh te ghad gha te tug yaog. Yawd buhz vix che a pehx med ghig he lehq juhg teq pa ted cear liz mad dawg lehq, yawd awr ye ve ux peg khuhn chehd thad loar, Daq kehg che Awg ha phu kha nehax chehd che chaw yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Id sar rer laq chaw teq pa laex ghad haq sir lehq ni ma kawq pa vid lehq, i hehd ve Jawd mawd Ghig sa chehd lo kawq phuhz kawaq vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yawd Ed lid yaq heh te Awg ha phu chehd lehq kand pax cawg che khuhn, Yer suq haq keh awg kawd kae lehq yawd awg tan tawd yaw tug yaog. Awr pa awg yad kawq cawd daq vid lehq, maq na yug vix che chaw teq pa kawq na yug lehq thed cawd che yaq kaw haq kawq siar tug, Ghig sa mehz khuhd suhr lo kae gag tug te tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Yar khar liq muhd nuh maq cuh yad haq koz vid che, “Ngag khawd-ehg te awg cehg mag awg lehz sir gha hawg le. Awg lawn ghod ver, ngag mid ma awd nag liz mawd jad vehor.” ");
INSERT INTO lhi_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Muhd nuh maq cuh yad u ve koz che, “Ngag awr lehr, Ghig sa mehz khuhd suhr huh hox chehd che Kar ber laq yaog. Ngag nawg haq tawd yawa lehq, ha lehg che tawd khuhd che ve ca koz ax pea che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kheh liz nawg ngag ved tawd khuhd haq maq yonr cheaq te lehq, awg lawn che ve teq pa mad phehaq ser che kheh ceh, nawg tawd yaw maq gha lehq chaw kar heh gha te chehd tug yaog. Awg ceng che ve teq pa, awg yand gaeg ver phehaq tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Awg bag lo chehd lehq Yar khar liq haq law chehd che chaw teq pa ha mad lehg vehr che yaog. Awg lawn ghod ver, yawd Yer ruq sar lehnr bon yehg nux khuhn geh veh che muh jad vehr lehq, ");
INSERT INTO lhi_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","yawd tuhaz gha mehx, i hehd teq pa haq teq chaweh tawd yaw daq maq gha he lehq laq kuhar lehax te mar che yaog. Kheh te lehq, i hehd teq pa duhd che Yer ruq sar lehnr bon yehg nux khuhn awg hez ted ceng cear haq yawd gha mawg che yaog lehz duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Yar khar liq yawd kanx te tug awg tar pong vehr lehq, yawd yehg lo kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","U ve khaz nuhr, awg mid ma Id lid sar behq yad hu vehr lehq har pa ngad mag kha gag ted kaer liz maq kae he lehq yehg khuha lehax chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yawd koz che, “A meha Ghig sa ngag haq che kheh tea gad che law. Ngag mehz khuhd maq gha lug lehq su haq maq gha yaq taw vid tug tea vehr che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Id lid sar behq yad hu che har pa khuhq mag khuhn gaeg lehq, Ghig sa awr lehr, muhd nuh maq cuh yad Kar ber laq haq Gar liq lehd muhd mig Nar sar rehq med lo kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Dar viq ve awg ceng awg khad Yod sehq meh che haq he tug te lar che yad mid hax Mar riq chehd huh lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Muhd nuh maq cuh yad Mar riq chehd lo lag lehq koz che, “Awg bon ir che yad mid-og, Ghig sa nawg haq awg bon kha peh vad-ag naq ax lehq Ghig sa nawg haq lez yug che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mar riq tawd khuhd u ve haq gha kad lehq ni ma khuhn duhd soq saq lehq khawd-ehg awr te lehq muhd nuh maq cuh yad ngag haq u kheh koz awg bon naq ax che lehq nar lehd duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Kheh te lehq, muhd nuh maq cuh yad kawq koz che, “Mar riq-og, ta kuhz. Awg lawn ghod ver, Ghig sa nawg haq ni ma cawd jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nawg yad hu lehq, yad par te ghad pawag tug yaog. Yawd haq Yer suq lehd koz gha meh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yad par u ve awr lehr, chaw ir chaw muh te lehq, ir jad muh jad che Ghig sa ve Yad phu yaog. Ghig sa awr lehr, yad par u ve haq yawd awg pux nux Dar viq ve kaw jaw pid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Kheh te lehq, Yar koq ve chaw ceng chaw khad teq pa haq yawd khar thad liz uq penr lehq yawd ved muhd mig awr lehr, co co taer taer awg leh med mad cawg hawg.” ");
INSERT INTO lhi_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mar riq muhd nuh maq cuh yad haq koz vid che, “Khawd-ehg te awg ceng che ve teq pa phehaq ghag le. Awg lawn ghod ver, ngag haw khaz geh mad yuhq jaw ser ehx-eh.” ");
INSERT INTO lhi_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Muhd nuh maq cuh yad kawq koz che, “Daq kehg che Awg ha phu nawg thag huh yaq lehq, ir jad muh jad che Ghig sa ve kand pax nawg haq hoz beh lar tug yaog. Kheh te cheaq te lehq, pawag che yad u ve awr lehr, Ghig sa ve Yad phu cehg mag yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ngawx lor, chaw meh ma lehd koz che nawg vix nawg nax Id lid sar behq heh mawd vehr liz, yad hu che har pa khuhq mag gag vehor. ");
INSERT INTO lhi_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Awg lawn ghod ver, Ghig sa te maq gha che teq chaweh mad cawg hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mar riq koz che, “Ngag awr lehr, Ghig sa nawg ved awg ceg ma yaog. Nawg koz che heh ngag haq tea laoq.” U kheh te lar haz lehq, muhd nuh maq cuh yad yawd haq phaz daq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Awg yand u ve khuhn, Mar riq har naq tu kae lehq Yud daq muhd mig khuhn kehaq lo cawg che med ted mag lo gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Yawd Yar khar liq ve yehg khuhn gehe lehq, Id lid sar behq haq tawd yaw daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Id lid sar behq Mar riq tawd yaw che khuhd haq gha kad che te yand, Daq kehg che Awg ha phu yawd khuhn chehd lehq yawd ux peg khuhn hu chehd che yad u ve liz phez ghawz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Id lid sar behq awg khuhd hehnd chawa kug lehq koz che, “Yad mid kheh ma ve awg khuhn lo nawg awr lehr, awg bon ir jad lehq nawg yad ux peg khuhn ve liz awg bon ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Khawd-ehg te lehq ngag ved Jawd mawd Khreq ve awr ye ngag chehd lo lag che lehq nar lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yawd ved tawd khuhd ngag ved nar puh khuhn gehag che te yand, ngag ved yad nehax ux peg khuhn chehd che liz ha lehg che khuhn phez ghawz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ghig sa koz vid lar che tawd khuhd haq yonr che yad mid awr lehr, awg bon ir che yaog. Yawd haq Ghig sa kha koz vid lar che tawd khuhd teq pa phehaq tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mar riq koz che, “Ngag ved ni ma awg tawg kha gag, Jawd mawd Ghig sa haq tar ir chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kheh te lehq ngag ved co ha liz, ngag ved thaer khuhq sehr phad Ghig sa haq ha lehg jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Awg lawn ghod ver, ngag awg mig awg phond mad cawg che chaw yawd ved awg ceg ma haq yawd ngawx ax vehor. Yaq ni khaz nuhr ver, chaw teq co peg teq co ngag haq awg bon ir che yad mid lehd koz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Awg lawn ghod ver, kha peg khod-aq kand pax ir che phad ngag haq yawd ved kanx ir jad che ted ceng tea peor. Yawd ved awg meh liz daq kehg jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ghig sa haq yawz yan lehq, kuhz vix che chaw teq pa haq yawd khar thad liz har kax vid che cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ghig sa yawd ved laq kuhr kand pax ir jad che haq yehd lehq te mar peor. Ni ma ir ni ma muh che chaw teq pa haq yawd te lug vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ghig sa awr lehr, awg mig awg phond cawg che jawd mawd teq pa ve a yad yug kha lehq, teq chaweh awg mig awg phond mad cawg lehq a sug yawd awg ton haq tar nehg che chaw teq pa haq yawd yug chid taz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Meq che kaz che chaw teq pa haq yawd daq che awg ceng kha buhz lehd car vid lehq, paw sa che chaw teq pa haq laq kuhr khuhn teq chaweh mad cawg vid lehq kawq pe tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ghig sa awr lehr, yawd ved chaw ceng haq ga vid lehq Id sar rer laq chaw te pa haq yawd koz vid lar che heh, har kax vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ghig sa awr lehr, Ar brar hanr he lehq yawd ved awg yad awg dug teq pa haq kar tiq te vid lar che heh te tug khar thad liz ma lend che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mar riq awr lehr, Id lid sar behq geh har pa seh lehd chehd lar haz lehq, yawd ved yehg lo kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Id lid sar behq yad paw tug awg yand gaeg lehq yad par te ghad pawag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ghig sa yawd haq ir jad che awg bon te vid che haq awg vix awg nax teq pa he lehq awg chawd teq pa gha kad lehq, yawd geh ga ha lehg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hex ni gaeg lehq, yad nehax u ve haq awg gig med soer vid tug i hehd teq pa lag che yaog. Kheh te lehq, awr pa ve awg meh heh te lehq Yar khar liq meh vid-ag lehd te gha mehx, ");
INSERT INTO lhi_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","awr ye koz che, “Ma hez hawg. Yawd haq Yod hanr gha meh vid lawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","I hehd teq pa yawd haq koz vid che, “Nawg ved awg ceng awg khad khuhn awg meh yix kheh koz meh che mad cawg hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kheh te lehq, yad nehax u ve haq awg meh a thoq meh vid tug awr pa haq chaw kar ve awg hez te na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Yawd buhq kig pehnr boz haq lawg lehq, “Yawd ved yad awg meh Yod hanr yaog,” lehd koz buhq teh vid lehq su and jad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Teq pear lehax, yawd ved mawq kaw he lehq ha lez awg pir heh te kawq daq vehr lehq yawd tawd yaw lehq Ghig sa haq chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Awg yand u ve khuhn, i hehd pad huh chehd che chaw teq pa kuhz jad che yaog. Awg lawn u ve teq pa Yud daq muhd mig khuhn kehaq lo awg kag gha lia lo buhg veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Awg lawn cheaq kha gha kad che chaw teq pa, ni ma sir khuhn tawnd lar lehq duhd che, “Chaw yad nehax che khawd-ehg ve chaw lehq nar.” Awg lawn ghod ver, Ghig sa yawd geh chehd cheaq i hehd sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Yar khar liq yad nehax ve awr pa Daq kehg che Awg ha phu kha nehax chehd che khuhn, Ghig sa ve tawd khuhd yaw lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Id sar rer laq ve Ghig sa haq chid muh-o. Awg lawn ghod ver, yawd ved chaw ceng haq ca ngawx-ag lehq ca thaer khuhq vid-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yawd ved awg ceg var Dar viq ve awg ceng awg khad khuhn yawd ngag hehd awg pun kand pax ir jad che Thaer khuhq sehr phad pawag vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Awg ceng gha lia a mig thad lo Ghig sa yawd ved daq kehg che cuh kar var haq cud lehq koz, ");
INSERT INTO lhi_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","A nig ved cand par teq pa haq pong ax lehq, a nig haq ngawx bawg che chaw teq pa ve laq khuhn yug pong ax che yaog, lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ghig sa yawd a nig ved a pux a pi teq pa haq har kax vid cheaq te lehq yawd ved daq kehg che kar tiq sax caz haq duhd nuhd vid tug awg pun te che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","A nig ved a pux nux Ar brar hanr haq yawd kar tiq sax caz te lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","A nig ved cand par laq khuhn Ghig sa yug pong ax peg lehq, a nig yawd ved kanx te che awg khuhn teq chaweh kuhz tug mad cawg. ");
INSERT INTO lhi_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","A nig teq coaq Ghig sa ve mehz khuhd suhr huh, daq che kehg che he lehq thed che cawd che kanx haq te gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yad par nehax-og, su nawg haq ir jad muh jad che Ghig sa ve cuh kar var lehd koz che yaog. Awg lawn ghod ver nawg awr lehr, Yer suq-aq keh awg kawd kae lehq yawd ved yaq kaw haq gha te vid lar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ghig sa yawd ved chaw teq pa thaer khuhq che haq gha tug awg lawn sir vid tug awg pun, yawd i hehd haq har kax vid lehq vend bax phehd kha vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Awg lawn ghod ver, Ghig sa har kax vix cheaq te lehq, muhd nuh kawag lo ve awg ghiz a nig thag lo thiag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Awg naz tud awg naz hoq te che khuhn chehd lehq, suh tug awg khad khuhn mi chehd che chaw teq pa haq awg ghiz paw vid lehq, duhd sa ha lehg che yaq kaw awg khad a nig haq sir mar ax che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Yad nehax u ve awg ton ir taz lehq, co ha phawd awr liz awg ghad cawg mad-ag lehq, Id sar rer laq chaw teq pa mehz khuhd suhr huh tuhz mawa thad kha gag, yawd heh pir khuhn awg god khehz awg nar nuh teag lo lehax chehd chehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Awg yand u ve khuhn, Rod maq uq penr che muhd mig khuhn chehd che muhd mig yad teq pa haq awg senr ca ke tug muhd mig jawd mawd nux Kehd sar Awd gud tuq tawd pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Che te pawz awg senr cag land yug che vawr, Sud riq muhd mig haq uq penr che Kud rer niq jawd mawd te chehd-ag huh awg kawd maq te pawz yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chaw awg gha lia a sug yawd khad ve chehd kig med lo koeq lehq, awg senr cag land ca kawq ke che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yod sehq liz, Dar viq ve awg ceng awg khad cawd cheaq te lehq, Gar liq lehd muhd mig Nar sar rehq med lo te lehq Yud daq muhd mig Behr lehr hehnr lehd koz che Dar viq ve med lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yawd he tug te lar che yad mid Mar riq liz awg senr cag land buhq ke tug awg pun kae tod che yaog. Yawd yad hu jad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ix mag Behr lehr hehnr med u ve khuhn chehd che awg yand haq Mar riq yad paw yand gag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Mar riq yad par awg kawd maq ve te ghad pawag lehq, khawd hu huhz vid lehq nud lawd kor khuhn yuhq vid lar che yaog. Awg lawn ghod ver, ix mag awg pun hax kig yehg ted kaer liz mad ngeq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Behr lehnr hehnr med jad lo yawg huhx var teq pa muhd phiq ver yawg huhx hax chehd che chaw cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ghig sa ve muhd nuh maq cuh yad te ghad tuhaz lehq, i hehd pad huh hox chehd lawz che yaog. Ghig sa ve awg mig awg phond i hehd haq kha caw yuhd thiag lehq, i hehd kuhz jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Muhd nuh maq cuh yad u ve i hehd haq koz vid che, “Ta kuhz. Awg lawn ghod ver, chaw awg gha lia awg pun ha lehg tug ir jad che tawd khuhd koz ax tug ngag lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Awg lawn ghod ver, yaq ni Dar viq ve med khuhn nig hehd awg pun Thaer khuhq sehr phad pawag vehor. Yawd awr lehr, Jawd mawd Khreq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yawd haq nig hehd gha sir tug awg hez awr lehr, chaw yad nehax u ve haq khawd hu huhz vid lehq nud lawd kor khuhn yuhq vid lar lawz tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Muhd nuh maq cuh yad u ve te ghad chehd-ag huh muhd nuh maq cuh yad awg mor nux kawq phoz tuhaz lehq, i hehd Ghig sa haq chid muh lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Muhd nuh maq lo chehd che Ghig sa haq awg mig awg phond cawg vid-oq. Mig gig khod-aq lo liz, Ghig sa ni ma cawd che chaw teq pa haq ha lehg duhd sa tug cawg vid-oq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Muhd nuh maq cuh yad teq pa muhd nuh kawag lo kawq taz kawq veh khaz nuhr, yawg huhx var teq pa koz daq che, “Yer, a nig Behr lehr hehnr med lo Ghig sa a nig haq koz ax lar che awg ceng u ve teq pa phehaq chehd che haq ca ngawx-eg veg.” ");
INSERT INTO lhi_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","I hehd teq pa har naq kae lehq ca ngawx-eg mehx, Mar riq he lehq Yod sehq haq liz mawg lehq, yad nehax paw lar che haq liz nud lawd kor khuhn yuhq chehd lawz che haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","I hehd teq pa u kheh te gha mawg lar haz lehq, muhd nuh maq cuh yad i hehd haq awg lawn u ve koz vid lar che heh te lehq, su haq liz kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Yawg huhx var teq pa koz che awg lawn u ve haq kha gha kad che chaw teq pa and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mar riq awr lehr, awg lawn u ve teq pa ni ma khuhn kha nehax tawnd lar lehq duhd ngawx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Yawg huhx var teq pa kawq koeq lehq, muhd nuh maq cuh yad i hehd haq koz vid lar che heh, awg cehg mag gha kad gha mawg cheaq te lehq, Ghig sa haq chid ir chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hex ni gaeg lehq, yad nehax haq awg gig med soer vid thad huh, yawd haq Yer suq lehd koz meh vid che yaog. Awg meh cheawg lehr, awr ye ux peg khuhn maq hu ser thad loar muhd nuh maq cuh yad meh vid lar peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mod ser awg lid teh lar che heh, awg ton daq kehg tug te yand gaeg lehq yad par nehax Yer suq haq yug ve lehq Yer ruq sar lehnr bon yehg nux lo kae lehq Ghig sa haq chid aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mod ser ve awg lid tawd khuhd khuhn buhq lar che heh te lehq, awg kawd maq paw che yad par te ghad awg gha lia Ghig sa haq gha chid aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yad mid teq pa awr lehr, yad paw peg ver, Mod ser ve awg lid tawd khuhd khuhn koz lar che heh te lehq, a pia nig kheh la ma hez ver, noq ka kehx nig kheh gha tand vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Yer ruq sar lehnr med khuhn chehd che Sid mor meh che haw khaz te ghad yawd thed che cawd che chaw te lehq, Ghig sa haq tar ir yawz yan che chaw he lehq Id sar rer laq chaw ceng teq pa haq Ghig sa ga vid tug duhd law chehd che Daq kehg che Awg ha phu yawd geh chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Daq kehg che Awg ha phu Sid mor haq pheq mar vid che nawg maq suh ser huh Ghig sa lo lag che Khreq haq nawg gha mawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Daq kehg che Awg ha phu Sid mor yawd haq duhd pawnr vid cheaq te lehq, yawd Yer ruq sar lehnr bon yehg nux lo kae che yaog. Awg yand u ve awg khuhn Yer suq awr ye awr pa liz Mod ser ve awg lid cawg lar che heh, yawd haq Yer ruq sar lehnr bon yehg nux lo awg lid ca te vid-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Sid mor awr lehr, yad nehax haq yawd ved laq kuhr khuhn chid cid lar lehq Ghig sa haq chid muh lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ngag ved Jawd mawd Ghig sa-og nawg ved tawd khuhd cawg lar che heh, nawg ved awg ceg var duhd sa che khuhn a meha suh cuha laoq. ");
INSERT INTO lhi_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Awg lawn ghod ver, ngag ved mehz sir nawg thaer khuhq ax che haq gha mawg vehor. ");
INSERT INTO lhi_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Chaw ceng kheh ma ve mehz khuhd suhr lo thaer khuhq ax tug nawg tea lar peor. ");
INSERT INTO lhi_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Thaer khuhq che u ve awr lehr, lawd kir yad teq pa awg pun awg ghiz he lehq nawg ved chaw ceng ve awg mig awg phond phehq che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yad nehax awg lawn Sid mor yawd u kheh koz che haq awr pa awr ye and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Sid mor ix mag haq bon naq vid lehq awr ye Mar riq haq koz vid che, “Yad nehax che ve haq te lehq, Id sar rer laq chaw laex ghad gha kuhd lehq laex ghad tu gag tug yaog. Su yawd haq maq sawnr ma caz koz tug awg hez ted ceng yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kheh te cheaq te lehq chaw laex ghad ve ni ma khuhn duhd chehd che kha nehax pheq tuhaz vid tug yaog. Nawg ved ni ma haq liz, a dax ghawg gehd che heh te lehq gehd pawnr pe tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ar sar ve awg ceng awg khad, Phar noer laq ve awg yad mid Ar naq meh che cuh kar ma te ghad cawg che yaog. Yawd mawd jad vehor. Yawd awg phad mawd he peg khaz nuhr awg phad mawd geh suhr khuhq kheh tawa lehax gha chehd lar haz lehq, ");
INSERT INTO lhi_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","yawd awg phad mawd suh vehr lehq hex chi uhd khuhq kha gag meh chuhd ma te chehd che yaog. Yawd Yer ruq sar lehnr bon yehg nux haq ma phaz he lar lehq, muhd kaw muhd khax cad tug ce lehq bon lawg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mar riq Yod sehq he lehq Sid mor i hehd teq pa yad nehax Ghig sa haq chid aq vid chehd-ag huh, Ar naq lag lehq Ghig sa haq chid muh che yaog. Yer ruq sar lehnr med haq thaer khuhq ax tug law chehd che chaw teq pa haq yawd yad nehax u ve awg lawn khae mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yod sehq he lehq Mar riq ix mag Ghig sa ve awg lid tawd khuhd cawg lar che heh saw te peg lar haz lehq, i hehd chehd kig Gar liq lehd muhd mig Nar sar rehq med lo kawq koeq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yad nehax u ve awg ton iar lehq, awg ghad liz cawg che yaog. Yawd laz lehnx lehq, Ghig sa liz yawd haq awg bon naq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Yer suq awr ye awr pa Yer ruq sar lehnr lo Par sar khar pawehd te ver, khuhq gha lia kae jaw che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yer suq a saq teq chi nid khuhq gaeg lehq, i hehd awg lid cawg che heh, Yer ruq sar lehnr lo pawehd te tug taez che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Pawehd te che awg ni peg vehr lehq, i hehd teq pa yehg lo koeq che te yand, yad par nehax Yer suq vawr, Yer ruq sar lehnr med khuhn chehd lar haz vehr che haq awr ye awr pa maq sir. ");
INSERT INTO lhi_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ix mag duhd che, Yer suq yawd geh lag che chaw teq pa geh kawq veh che gha hawg lehd duhd che yaog. I hehd kawaq che teq ni yaq kaw mig lo gaeg lehq yawd awg chawd teq pa he lehq awg vix awg nax chehd lo ca na ngawx-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kheh liz ca mad mawg te lehq, ix mag sir daq vea lehq Yer ruq sar lehnr med lo kawq cag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ghaq ca che sehr ni gaeg lehq, Yer suq Yer ruq sar lehnr bon yehg nux khuhn mi lehq sar lar nux teq pa haq tawd ox daq na daq chehd lawz cheaq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yer suq ve tawd khuhd haq gha kad che chaw teq pa, yawd sir lehq yaw khuhq chehd che tawd khuhd haq and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Awr ye awr pa gha mawg lehq and jad vehr che yaog. Awr ye yawd haq koz vid che, “Yad par-og, a thoq te nawg a ye a pa haq ix kheh tea cheawg le. A pa awd nag duhd har jad lehq ghaq ca teq vehor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yer suq kawq yaw khuhq vid lehq koz che, “Nig mag a thoq te lehq ngag haq ghaq ca tod cheawg le. Ngag Ngar pa ve yehg khuhn gha chehd lawg ghod che haq nig mag maq sir lehq la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kheh ma khuhd, awr ye awr pa Yer suq koz chehd che awg lawn haq na maq gha. ");
INSERT INTO lhi_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kheh te lehq, Yer suq awr lehr, awr ye awr pa geh Nar sar rehq med lo koeq lehq, ix mag uq penr che huhx uh chehd lehq na yug chehd che yaog. Awr ye awr lehr, awg lawn u ve teq pa awg gha lia ni ma khuhn kha nehax tawnd ke lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yer suq awr lehr, cud yiq phawd liz, awg ton phawd liz iar lehq, Ghig sa liz chaw yad liz yawd haq ni ma cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rod maq jawd mawd nux Kehd sar Tir ber riq uq penr che teq chi ngad khuhq gaeg lehq, Yud daq muhd mig khuhn Por tiq Pid laq jawd mawd te lehq uq penr chehd huh, Gar liq lehd muhd mig awg khuhn Her roq jawd mawd te lehq uq penr chehd lehq, Ix tuq rehd he lehq Tar rar khod niq muhd mig khuhn Her roq yawd ved awg nax var Phid liq jawd mawd te lehq uq penr chehd-ag huh, Ar bid ler muhd mig khuhn Lud sar niq jawd mawd te lehq uq penr chehd lehq, ");
INSERT INTO lhi_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ar naq he lehq Kar yar phaq Ghig sa ve paw khod nux te chehd che awg yand awg khuhn, heh pir khuhn awg god khehz awg nar nuh teag lo chehd che Yar khar liq ve yad par Yod hanr chehd lo Ghig sa ve tawd khuhd gag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kheh te lehq, Yod hanr Yawd danr lawg kax puhg huh, awg kiz awg naz kae lehq, “Ghig sa nawg ved vend bax haq phehd kha ax vid tug awg pun, awg ton ni ma awg suhx kawq pa lehq baz tiz sar khanr yug lor,” lehd koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Cuh kar var Id sar yaq ve liq khuhn buhq lar che haq kha sur suar, “Heh pir khuhn awg god khehz awg nar nuh teag lo chaw te ghad kug lehq koz che, ‘Jawd mawd Ghig sa lag tug yaq kaw haq te lar lor. Yawd ved yaq kaw teq pa haq thed-e ghad teo. ");
INSERT INTO lhi_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Lawg khoq lawg ma awg ti gha lia pehag vid lehq, keh nux keh nehax awg mag gha lia haq gha te nehg vid tug yaog. Yaq kaw awg kuhq kux te che haq thehd-e lehd yug te vid lehq, awg khoq awg khehq te che yaq kaw haq tawr ghad phinr ghad gha kawq te tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Chaw awg gha lia Ghig sa lo lag che thaer khuhq cheaq gha mawg tug yaog,’” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Chaw awg mor nux Yod hanr chehd lo baz tiz sar ca khanr yuag che chaw teq pa haq yawd koz vid che, “Haeg jad che vig heh te lehq he ka vix che awg tuhq ma cawg che chaw teq paog, lag tug ve Ghig sa cir yanr che haq phaw tuhaz tug a sug nig hehd haq koz ax cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nig hehd teq pa awg cehg mag duhd phuhz gad phuhz lehq ni ma pa vehr che awg sir nuhaq che haq gha mawg vid. A nig Ar brar hanr ve awg yad awg dug te lehq vend bax gha pong vehor lehz a cehax liz ta duhd. Awg lawn ghod ver, Ghig sa awr lehr, huhx meh dig che ve teq pa haq yug lehq Ar brar hanr ve yad phehaq vid tug kand pax cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A meha loar, khi chuhz taz lehq awg cehg khi penr teh lar peor. Kheh te lehq, daq che awg sir mad nuhq che te pa haq thawq lehq, a mir khuhn bag ke tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Muhd mig yad teq pa yawd haq kawq na lehq koz che, “Kheh te ver, ngag hehd khawd-ehg kheh gha te lawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yawd i hehd haq kawq koz vid che, “A poq ni khoz cawg che chaw awr lehr, a poq mad cawg che chaw haq pehg vid-oq. Kheh te lehq, cad tug cawg che chaw teq pa liz, u ve heh teo,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Awg khawnr saw var teq pa liz baz tiz sar khanr yug tug yawd chehd lo lag lehq koz che, “Sar lar-og, ngag hehd khawd-ehg kheh gha te tuawg le,” lehd koz na che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yod hanr i hehd haq koz vid che, “Nig hehd awg khawnr saw ver, koz lar che nuz awr taq saw,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Maq yad teq pa liz, Yod hanr haq na lehq koz che, “Ngag hehd teq pa awr hehq, khawd-ehg kheh awr gha te lawg le,” lehd koz na che yaog. Yawd i hehd teq pa haq kawq koz vid che, “Su ved med nged taq ca lu yug. Su haq ma hez hez che awg lawn taq ca te ke. Nig hehd gha chehd che ghad phuhd haq ni khaz suh lor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Chaw awg gha lia Khreq lag tug haq duhd law lehq law chehd cheaq te lehq, Yod hanr haq Khreq lehq nar, ma hez lehq nar, lehz ni ma khuhn duhd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","I hehd teq pa haq Yod hanr koz vid che, “Ngag awr lehr, nig hehd haq a kaz khuhn baz tiz sar pehar tug yaog. Kheh ma khuhd, ngag haq keh kand pax ir che te ghad lag tod che yaog. Yawd ved khi noz caz haq phi tug kheh tawa liz ngag te maq kenr hawg. Yawd awr lehr, Daq kehg che Awg ha phu awg khuhn ma koz, a mir haq cud che ma koz, nig hehd haq baz tiz sar pehar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yawd ved laq kuhr khuhn a cag fed tug haq yug cid chehd che yaog. A cag kha sehax thez fed kha lehq cag sir mag maq haq cag yehg khuhn puhd ke lar lehd te che yaog. Kheh te lar, cag cox haq vawr, maq suh vix che a mir khuhn yawd yaz tox ke tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kheh te cheaq te lehq, Yod hanr yawd ha lehg che bon khuhd mar che khuhn chaw teq pa haq laex ceng ca kaod koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gar liq lehd muhd mig haq uq penr che jawd mawd Her roq awr lehr, awg nax var mid ma Her ror diq haq yug lehq, yawd mid ma yug te che awg lawn he lehq yawd awg haeg kha te che awg lawn teq pa haq Yod hanr yawd haq yug ded mar vid cheaq te lehq, ");
INSERT INTO lhi_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","jawd mawd Her roq awr lehr, pong lag thad haq keh liz kawq haeg jad lehq, te yaq kig ted ceng kawq cawg mad-ag cheawg lehr, Yod hanr haq pheh lehq thawnr yehg khuhn ke che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Chaw laex ghad baz tiz sar khanr yug peg lehq, Yer suq liz baz tiz sar khanr yug lehq bon lawg chehd-ag huh, muhd nuh maq phaw lehq ");
INSERT INTO lhi_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Daq kehg che Awg ha phu awr lehr, awg hoq awg han a pia kar haq sur che yawd thag huh yaq che yaog. Kheh te lehq, muhd nuh kawag lo awg khuhd buhg tuhaz lehq koz che, “Nawg awr lehr, ngag haq jad che ngag ved Yad phu yaog. Ngag nawg haq ni ma cawd jad che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yer suq kanx tanr teag huh, a saq sehz chi khuhq kheh taw gaeg che yaog. Yawd awr pa awr lehr, Yod sehq yaog lehz su duhd che yaog. Yod sehq ve awr pa awr lehr, Id liq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Id liq ve awr pa awr lehr, Mar saq yaog. Mar saq ve awr pa awr lehr, Ler viq yaog. Ler viq ve awr pa awr lehr, Mer lar khiq yaog. Mer lar khiq ve awr pa awr lehr, Yar naq yaog. Yar naq ve awr pa awr lehr, Yod sehq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yod sehq ve awr pa awr lehr, Mar tar thiq yaog. Mar tar thiq ve awr pa awr lehr, Ar moq yaog. Ar moq ve awr pa awr lehr, Nar honr yaog. Nar honr ve awr pa awr lehr, Id sar liq yaog. Id sar liq ve awr pa awr lehr, Nar gehd yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nar gehd ve awr pa awr lehr, Mar aq yaog. Mar aq ve awr pa awr lehr, Mar tar thiq yaog. Mar tar thiq ve awr pa awr lehr, Ser miq yaog. Ser miq ve awr pa awr lehr, Yod sehq yaog. Yod sehq ve awr pa awr lehr, Yud daq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yud daq ve awr pa awr lehr, Yod har naq yaog. Yod har naq ve awr pa awr lehr, Rer saq yaog. Rer saq ve awr pa awr lehr, Ser rud ber laq yaog. Ser rud ber laq ve awr pa awr lehr, Sar lar ter laq yaog. Sar lar ter laq ve awr pa awr lehr, Ner riq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ner riq ve awr pa awr lehr, Mer lar khiq yaog. Mer lar khiq ve awr pa awr lehr, Ad diq yaog. Ad diq ve awr pa awr lehr, Kawd sanr yaog. Kawd sanr ve awr pa awr lehr, Id lar mawd daq yaog. Id lar mawd daq ve awr pa awr lehr, Id raq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Id raq ve awr pa awr lehr, Yawd ser yaog. Yawd ser ve awr pa awr lehr, Id ler sar yaog. Id ler sar ve awr pa awr lehr, Yod renr yaog. Yod renr ve awr pa awr lehr, Mar saq yaog. Mar saq ve awr pa awr lehr, Ler viq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ler viq ve awr pa awr lehr, Sud monr yaog. Sud monr ve awr pa awr lehr, Yud daq yaog. Yud daq ve awr pa awr lehr, Yod sehq yaog. Yod sehq ve awr pa awr lehr, Yod nanr yaog. Yod nanr ve awr pa awr lehr, Ed lar kenr yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ed lar kenr ve awr pa awr lehr, Mer ler yaog. Mer ler ve awr pa awr lehr, Mehd nar yaog. Mehd nar ve awr pa awr lehr, Mar tar thaq yaog. Mar tar thaq ve awr pa awr lehr, Nar tanr yaog. Nar tanr ve awr pa awr lehr, Dar viq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dar viq ve awr pa awr lehr, Ye sehd yaog. Ye sehd ve awr pa awr lehr, Awd behq yaog. Awd behq ve awr pa awr lehr, Bawd saq yaog. Bawd saq ve awr pa awr lehr, Sar lar monr yaog. Sar lar monr ve awr pa awr lehr, Nar sonr yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nar sonr ve awr pa awr lehr, Ar miq nar daq yaog. Ar miq nar daq ve awr pa awr lehr, Aq min yaog. Aq min ve awr pa awr lehr, Ar ranr yaog. Ar ranr ve awr pa awr lehr, Her sar ronr yaog. Her sar ronr ve awr pa awr lehr, Phar rehq yaog. Phar rehq ve awr pa awr lehr, Yud daq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yud daq ve awr pa awr lehr, Yar koq yaog. Yar koq ve awr pa awr lehr, Id caq yaog. Id caq ve awr pa awr lehr, Ar brar hanr yaog. Ar brar hanr ve awr pa awr lehr, Ter raq yaog. Ter raq ve awr pa awr lehr, Nar khawr yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nar khawr ve awr pa awr lehr, Ser roz yaog. Ser roz ve awr pa awr lehr, Rar gawd yaog. Rar gawd ve awr pa awr lehr, Phar lehz yaog. Phar lehz ve awr pa awr lehr, Her baq yaog. Her baq ve awr pa awr lehr, Sar laq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sar laq ve awr pa awr lehr, Kar id nanr yaog. Kar id nanr ve awr pa awr lehr, Ar phar yaq yaog. Ar phar yaq ve awr pa awr lehr, Ser maq yaog. Ser maq ve awr pa awr lehr, Nod ar yaog. Nod ar ve aw pa awr lehr, Lar mehq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lar mehq ve awr pa awr lehr, Mar tud sar laq yaog. Mar tud sar laq ve awr pa awr lehr, Ed nawq yaog. Ed nawq ve awr pa awr lehr, Yar rehq yaog. Yar rehq ve awr pa awr lehr, Mar har ler laq yaog. Mar har ler laq ve awr pa awr lehr, Kar id nanr yaog. ");
INSERT INTO lhi_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kar id nanr ve awr pa awr lehr, Id noz yaog. Id noz ve awr pa awr lehr, Ser taq yaog. Ser taq ve awr pa awr lehr, Ar danr yaog. Ar danr ve awr pa awr lehr, Ghig sa yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yer suq Daq kehg che Awg ha phu yawd geh kha nehax chehd lehq, Yawd danr lawg lo tu lehq koeq tod che awg yand awg khuhn, Awg ha phu yawd haq sir ve lehq heh pir khuhn awg god khehz awg nar nuh teag lo ned haeg Sar tanr ber che haq gha khanr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ned haeg Sar tanr Yer suq haq ber che uhd chi ni kha gag ber che yaog. Awg yand u ve khuhn, yawd cad tug teq chaweh ma cad cheaq te lehq, uhd chi ni gaeg lehq cad tug meq jad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ned haeg Sar tanr yawd haq koz vid che, “Nawg awg cehg mag Ghig sa ve Yad phu awg lehd koz ver, huhx meh dig che ve haq khaor mod yug te lehq cad hehq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yer suq yawd haq kawq khuhq vid lehq koz che, “Liq phu khuhn che kheh koz buhq lar che yaog. Chaw yad awr lehr, cad tug haq lehax te lehq a saq teq chehd che ma hez hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Te pawz ned haeg Sar tanr awr lehr, yawd haq sir ve lehq muh kig lo kawq taez lehq mig gig khod-aq kha cawg che muhd mig awg gha lia haq teq per nehax maw vid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Muhd mig che teq pa haq uq penr tug kand pax he lehq i hehd ve awg mig awg phond ngag nawg haq saw pear tug yaog. Awg ceng che ve teq pa ngag haq saw chid aq ax lar peg cheaq te lehq ngag kha pid gad che haq pid gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kheh te cheaq te lehq, nawg ngag haq a kor pia ver, awg ceng che ve teq pa nawg ved med nged lehax saw phehq vehr che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yer suq yawd haq kawq yaw khuhq vid lehq koz che, “Liq phu khuhn che kheh koz buhq lar che yaog. Nawg ved Jawd mawd Ghig sa haq nawg a kor gha pi lehq, yawd ved kanx haq lehax nawg gha te che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Te pawz ned haeg Sar tanr awr lehr, yawd haq Yer ruq sar lehnr med khuhn cawg che bon yehg nux thag lo sir teh lar lehq koz vid che, “Nawg awg cehg mag Ghig sa ve Yad phu awg lehd koz ver, chuhr huh pawz kha pe ngawx lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Awg lawn ghod ver, Liq phu khuhn che kheh koz buhq lar che yaog. Nawg haq haq sax tug awg pun, yawd ved muhd nuh maq cuh yad teq pa haq yawd cuh vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nawg ved khi kud huhx meh haq maq gha yaw vid tug muhd nuh maq cuh yad teq pa nawg haq law haq yug vehr lawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yer suq kawq yaw khuhq lehq koz che, “Liq phu khuhn che kheh koz buhq lar che yaog. Nawg ved Jawd mawd Ghig sa haq nawg maq gha ber maq gha lawd hawg,” lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ned haeg Sar tanr awr lehr, yawd awg ceng gha lia caw ber ngawx lar haz lehq, yawd haq teq cuhx nehax ca phaw chehd lar lehq awg yand daq che haq law chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yer suq awr lehr, daq kehg che Awg ha phu ve kand pax awg khuhn Gar liq lehd muhd mig huh kaw kawaq lehq, yawd ved awg lawn awg kiz awg naz awr ve muhd mig teq pa khuhn hax ceh buhg veh kad veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","I hehd ve bon lawg kig teq pa khuhn yawd mar vid lehq, chaw awg gha lia yawd haq chid ir chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yer suq yawd iar kig Nar sar rehq med lo kawq gag lehq awg lid cawg lehq te jaw che heh, Sa ba to awg ni gaeg lehq bon yehg taez che yaog. Liq phu haq ghawn tug yawd tuag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Su yawd haq cuh kar var Id sar yaq ve Liq phu yug vid che yaog. Yawd yug lehq pheq che te yand, che kheh koz buhq lar cheaq ca mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Yer suq yawd ghawn lehq koz che, “Ghig sa ve Awg ha phu ngag awg thag huh chehd chehd che yaog. Awg lawn ghod ver, har ghuhd che chaw teq pa haq ha lehg che bon khuhd kud vid tug yawd ngag haq lez yug lar peor. Yawd ngag haq pea lar che awr lehr, pheh lar che chaw teq pa haq phehd vid tug lehd ma koz, mehz cox chehd che chaw teq pa mehz kawq mawag tug lehd ma koz, mar vid kud vid tug awg pun ngag haq pea lar che yaog. Awg khod-aq liz, su du deh che haq gha khanr che chaw teq pa haq pong vid tug lehd ma koz, ");
INSERT INTO lhi_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Jawd mawd Ghig sa yawd ved chaw teq pa haq har kax vid tug, ca ga vid-ag che awg khuhq awg yand gag vehor, lehd koz mar vid tug yawd ngag haq pea lar che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Kheh te lehq, liq u ve haq yawd kawq loq lehq bon lawg kig huh mi khuhd mi lehq awg hox te var haq khuhq pid peg lehq, mi chehd che yaog. Bon lawg kig khuhn chehd che chaw awg gha lia yawd haq kha nehax ngawx chehd-ag huh, ");
INSERT INTO lhi_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","yawd i hehd haq tanr mar vid lehq koz che, “Nig hehd gha kad chehd che Liq phu khuhn ve awg lawn che ve awr lehr, yaq ni nig hehd mehz khuhd suhr awg cehg mag phehaq vehor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chaw awg gha lia yawd haq chid muh lehq, yawd ved mawq kaw khuhn tuhaz lehq na sa jad che tawd khuhd teq pa haq and jad lehq koz daq che, “Chaw che ve Yod sehq yad par ma hez hawg la,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yer suq i hehd haq koz vid che, “Nig hehd awr lehr, ‘Naz chuhd sehr phad-og, a sug yawd awg ton haq awg kawd te na ser.’ Ngag hehd gha kad che heh, Kar per nar unr med lo nawg te che kanx teq pa haq chuhr huh a sug yawd chehd kig med huh liz teo, lehz ngag haq nig hehd koz tug te chehd che haq ngag sir che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yer suq te pawz kawq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, Ghig sa ve cuh kar var a sug te ghad cawar le. A sug yawd ved chehd kig huh awg mig awg phond gha lehq su tar ir yawz yan che. ");
INSERT INTO lhi_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ngag nig hehd haq thed-e lehd koz ax laq, Ed lid yaq ve awg co haq sehz khuhq nuhr har pa khuhq mag kha gag muhd yeg mad lag lehq, muhd mig teq pa khuhn meq nux kaz nux cawag che te yand, Id sar rer laq chaw ceng awg khuhn meh chuhd ma cawg mad-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kheh ma khuhd, Ghig sa Ed lid yaq haq Id sar rer laq ve meh chuhd ma te ghad-eg chehd lo maq kae pe. Kheh te lar lehq, Sid donr muhd mig Sar rar taq med khuhn chehd che meh chuhd ma te ghad chehd loa lehax yawd haq kae cuh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Cuh kar var Id lid sehd ve awg co haq liz, Id sar rer laq ve chaw ceng khuhn khir tuq kex che chaw kha peh cawg che yaog. Kheh ma khuhd, te ghad-eg haq liz te na vid che mad cawg. Sud riq chaw Ner manr te ghad ma hez ver,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bon yehg khuhn chehd che chaw awg gha lia tawd khuhd u ve haq gha kad che te yand, i hehd teq pa nez nag jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","I hehd teq pa cex tuag lehq Yer suq haq ghaq biz ve lehq med bag lo tuhez lehq, i hehd chehd chehd che med keh u ve hax khod med lo sir ve kae lehq biz kha peag lehd duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yawd awr lehr, i hehd teq pa awg kar huh veaq, khuhd phaw tuhz veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yer suq Gar liq lehd muhd mig Kar per nar unr med lo yaq lehq, Sa ba to awg ni huh chaw laex ghad haq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yawd mar vid che tawd khuhd teq pa haq i hehd teq pa and jad che yaog. Awg lawn ghod ver, yawd kand pax cawg che khuhn mar vid cheaq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Bon yehg u ve khuhn chehd chehd che haw khaz var te ghad haq ned chaq chiz geh chehd che yaog. Yawd huh kug lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ag log, Nar sar rehq chaw Yer suq-og, nawg ngag hehd haq a thoq caz daq lehq le. Nawg ngag hehd haq ca te lug tod cheawg la. Nawg haq ngag hehd sir chehd-aq. Nawg awr lehr, Ghig sa ve Daq kehg che chaw u ve te ghad yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yer suq ned haq ded lehq koz che, “Tawd ta mad chehd, taq chuhax tuhz laoq,” lehd koz vid che te yand, ned u ve chaw u ve phad haq chaw kheh ma ve mehz khuhd suhr huh biz bag pe lehq, teq chaweh nag tug maq te vid he lar haz lehq tuhz veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","I hehd teq pa and jad che khuhn koz daq che, “Yawd ved tawd che khawd-ehg kheh awr ve tawd awg le. Yawd tawd yaw vid che khuhn kand pax cawg lehq ned chaq chiz teq pa liz tuhz veh che law.” ");
INSERT INTO lhi_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","U ve khaz nuhr, Yer suq ve awg lawn teq pa khar lo chor lo awg kiz awg naz hax ceh buhg veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yer suq bon yehg khuhn tuhez lehq, Sid monr ve yehg khuhn gehe che yaog. Sid monr awg pi ma kaz nag jad lehq, i hehd teq pa yawd haq ghu na vid tug, Yer suq haq lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yer suq yad mid u ve pad huh yig hox lar lehq, kaz nag che u ve haq yawd ded lehq ghaq kog vid che yaog. Teq pear lehax yawd na vehr lehq tu lehq, Yer suq he leh yawd geh lag che chaw teq pa haq haq yug vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Muhd ni kehg vehr lehd teag huh, chaw laex ghad chaw nag laex ceng te nag che teq pa haq sir vea lehq Yer suq chehd lo lag che yaog. Kheh te lehq chaw u ve teq pa haq yawd laq kuhr tar lehq saw ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ned teq pa liz chaw u ve teq pa khuhn tuhez lehq kug che, “Nawg awr lehr, Ghig sa ve Yad phu yaog,” lehd koz che yaog. Kheh liz, yawd i hehd haq tawd maq gha yaw cuh vid. Awg lawn ghod ver, i hehd yawd haq Khreq yaog lehz sir chehd cheaq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Muhd sawx ted naq, Yer suq heh pir khuhn gawr ghad teag lo tuhz veh che yaog. Kheh te lehq, i hehd teq pa yawd haq kha mawg ghad ghaq ca lehq yawd i hehd haq maq gha teh lar haz veh tug te che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kheh ma khuhd, yawd kawq koz che, “Ghig sa ve muhd mig awg lawn ha lehg che bon khuhd awg kag awg nuz awr ve med teq pa haq liz ngag gha ca mar vid-eg tug yaog. Awg lawn ghod ver, che kheh te tug Ghig sa ngag haq pea lar che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Kheh te lehq Yer suq awr lehr, Yud daq muhd mig khuhn cawg che bon lawg kig teq pa khuhn laex kag lo yawd bon ca mar vid-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Teq ni thad huh, Yer suq Ger ner sar rehq ghig po nux pad lo hox lar lehq, Ghig sa ve tawd khuhd mar chehd che haq na tug chaw awg mor nux hax ceh biz daq caq daq gehag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ghig puhg huh, huh lawd kor nid mag deh lar che haq Yer suq gha mawg che yaog. Ngad ca par teq pa huh lawd kor khuhn tuhez lehq, i hehd ve geq haq chuhd kha chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Sid monr ve huh lawd kor khuhn yawd gehe lehq, a kaz khuhn a cehax jiz gehe tug Sid monr haq koz vid che yaog. Yawd huh lawd kor khuhn geh mi lar lehq, chaw mor nux haq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yawd mar che phehd vehr lehq Sid monr haq koz vid che, “A kaz nax kig huh jiz gehe lehq, nig hehd ve geq haq phehd keo ngad gha vid,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sid monr kawq koz che, “Jawd mawd-og, ngag hehd a mig hax teq hax muhd kha thid hax ceh ca geq liz teq kheha liz maq gha. Kheh ma khuhd, nawg koz cheaq te lehq, ngag kawq te ngawx tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","I hehd teq pa Yer suq koz che heh te lehq, i hehd ve geq khuhn ngad geh mad jad lehq geq liz pheq vehr lawq lawq gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kheh te lehq, i hehd teq pa awg chawd ve huh lawd kor ted mag haq laq meg meg vid lehq, ngad lag ga yuag vid che yaog. Ngad gha mad jad lehq, huh lawd kor nid mag mar khuhn ngad kha peh he lehq a kaz thur vehr lehd te che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sid monr Per troq u ve haq gha mawg lehq, Yer suq ve khi pad huh boz cuhx lar lehq koz che, “Jawd mawd-og, ngag pad-a ta chehd-oq. Awg lawn ghod ver, ngag awr lehr vend bax ir jad che chaw yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Yawd u kheh koz cheawg lehr, ngad ca gha mad jad cheaq yawd he lehq awg chawd teq pa and jad vehr cheaq te lehq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sid monr geh teq geha kanx te che yawd ved awg chawd Yer ber dehd ve awg yad par Yar koq he lehq Yod hanr liz and jad vehr che yaog. Kheh te lehq, Yer suq Sid monr haq koz vid che, “Ta kuhz. Yaq ni khaz nuhr ver, nawg chaw ca par gha te tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","I hehd teq pa awr lehr, huh lawd kor ghig puhg lo deh lehq, awg ceng gha lia saw chid bag lar haz lehq, Yer suq khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Te pawz thad huh, Yer suq med ted mag khuhn chehd-ag huh, teq ton maq ve khir tuq kex che haw khaz te ghad Yer suq haq mawg lehq, mehz khuhd miaq boz cuhx lar lehq koz che, “Jawd mawd-og, nawg te gad ver, ngag haq daq kehg tug nawg te gha che yaog,” lehd koz lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yer suq laq kuhr yawd haq vad vid lehq koz vid che, “Ngag ni ma cawd lehq te gad che yaog. Daq vid kehg vid-oq,” lehd koz vid che yaog. Teq per nehax lehax yawd khir tuq kex che a nar mehx vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yer suq yawd haq koz vid che, “Su te ghad-eg haq ta koz vid mehr. Kheh te lar Ghig sa ve paw khod chehd lo vawr, awg ton ca maw vid lehq Mod ser koz lar che heh te lehq, nawg na vehr che sax khiz cawg tug awg pun tand tug ca yug tand vid-eq mehr,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kheh liz, Yer suq ve awg lawn ghaq te maq heh buhg veh che yaog. Kheh te lehq, chaw kha peh vad-ag yawd chehd lo phoz lag che yaog. Ted pehg ver, Yer suq mar che khuhd na gad che yaog. Ted pehg pehar ver, i hehd nag chehd che a nar haq ghu na ax vid tug lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kheh te lehq, Yer suq awr lehr, heh pir khuhn gawr ghad teag lo kae lehq bon ca laweg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Teq ni thad huh, Yer suq yawd mar vid chehd che awg yand khuhn, Yer ruq sar lehnr lo he lehq Gar liq lehd muhd mig Yud daq muhd mig khuhn cawg che khaz gha lia lo chehd che Phar rir sehd teq pa he lehq liq buhq var teq pa lag lehq phoz mi chehd che yaog. Nag che chaw teq pa haq ghu na vid tug, Ghig sa ve kand pax Yer suq yawd geh cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chaw teq mor, chaw nag taz tug khuhn khi kud laq kuhr suh vehr che chaw nag te ghad yuhq vid lehq ga taz vea lehq lag che yaog. Yawd haq yug ve gehe lehq, Yer suq mehz khuhd suhr huh tar tug i hehd awg khad ca che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kheh liz chaw mad jad lehq, chaw nag yug ve gehe mad gag. Kheh te lehq, i hehd teq pa chaw nag ga taz ve yehg thag lo taez lehq, a yuhd phaz kha lar chaw mor nux kanr huh Yer suq mehz khuhd suhr huh yawd yuhq chehd che yuhq phi haq phehd yaq pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yer suq i hehd teq pa yonr che ni ma haq gha mawg lehq koz che, “Yad par-og, nawg ved vend bax haq pong ax vehor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Liq buhq var he lehq Phar rir sehd teq pa ni ma khuhn duhd che, “Chaw che phad a suawg le. Ghig sa haq ma yawz maq yan ca koz che, Ghig sa te ghad ma hez ver, a sug vend bax pong vid gha hawg le,” lehd duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","I hehd u kheh duhd chehd che haq Yer suq sir lehq, i hehd haq koz vid che, “Nig hehd a thoq te ix kheh ca duhd cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Tawd khar ve te khuhd vawr yaw vid ver, a cehax sa hawg le. ‘Nawg ved vend bax haq pong ax vehor,’ lehd koz che he lehq, ‘Tu lehq yaq kaw tod kae lor,’ lehd koz vid che sa hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kheh ma khuhd, chaw yad ve Yad phu awr lehr, mig gig khod-aq lo ve vend bax phehd kha vid tug kand pax cawg che haq nig hehd gha sir tug awg pun,” lehd koz peg lehq, khi kud laq kuhr suh che phad haq koz vid che, “Ngag nawg haq koz ax laq, tu-og. Nawg ved yuhq phi ghawz taz ve lehq nawg yehg lo koeq lor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Teq pear lehax yawd tuag lehq, chaw kheh ma ve mehz khuhd suhr yawd ved yuhq phi ghawz taz ve lehq, Ghig sa haq seh chid ir seh chid muh he lehq yehg lo kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chaw awg gha lia and jad lehq, Ghig sa haq chid ir chid muh che yaog. I hehd teq pa kuhz jad che khuhn koz che, “A nig ma duhd ngawx jaw che awg ceng teq pa, yaq ni a nig gha mawg vehr lo,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","U kheh te lar haz Yer suq tuhez lehq, awg khawnr saw var Ler viq meh che te ghad awg khawnr saw kig yehg khuhn mi chehd che haq yawd gha mawg lehq koz vid che, “Ngag khaz nuhr ghaq laoq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Yawd awr lehr, awg ceng gha lia saw chid bag lar haz lehq, Yer suq khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ler viq yawd ved yehg lo Yer suq awg pun thi cad thi dawg che pawehd nux te che yaog. Awg khawnr saw var laex ghad he lehq awg nuz awr ve chaw teq pa liz laex ghad i hehd geh teq geha phenx haq phoz mi cad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Phar rir sehd teq pa he lehq liq buhq var teq pa, Yer suq ve awg laq ghuhd teq pa haq ca khuhd sawr ded mar vid lehq koz che, “A thoq te lehq nig hehd teq pa awg khawnr saw var teq pa he lehq vend bax yad geh thi cad thi dawg tod cheawg le.” ");
INSERT INTO lhi_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yer suq i hehd haq kawq koz vid che, “Chehd sa chehd che chaw teq pa, naz chuhd sehr phad haq maq lor. Nag che chaw teq pa lehax lor che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Thed cawd lehq daq vehr che chaw teq pa haq ngag ca kuag che ma hez hawg. Vend bax yad teq pa, a sug yawd ved vend bax haq duhd phuhz vid tug awg pun ngag lag che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","I hehd teq pa Yer suq haq koz vid che, “Yod hanr ve awg laq ghuhd teq pa he lehq Phar rir sehd ve awg laq ghuhd teq pa ver, te thawz te thawz cad tug ce lehq bon lawg chehd lar. Kheh te lar khawd-ehg te cheawg le. Nawg ved awg laq ghuhd teq pa vawr, khar thad liz cad che dawg chea lehax te chehd lar,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yer suq i hehd teq pa haq koz vid che, “Na ka pawehd te che phad yawd ved awg chawd teq pa khehx cad kig lo lag che haq cad tug ce vid gha hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kheh ma khuhd, na ka pawehd te che phad haq teq ni ver, awg chawd teq pa haq yug phaz daq vid tug yaog. Awg yand u ve khuhn, i hehd cad tug ce tug yaog,” lehz yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yer suq i hehd haq tawd par hax ted mag te mar vid lehq koz che, “Chaw te ghad-eg liz, a poq suhx maq vig vea lar awg pez juhq yug lehq, a poq pir khuh chehd che haq nehx che maq te hawg. U kheh te ver, a poq suhx maq kawq khuh vehr che awg khod-aq liz, a poq pir haq mad kawq hawr vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kheh te lehq, chaw te ghad-eg liz sar gig thux pu awg pir khuhn a pehx med ghig awg suhx maq ke jaw. U kheh te ke ver, a pehx med ghig u ve sar gig thux pu poz khod lehq, a pehx med ghig liz saw sez vehr nuhr sar gig liz saw sax vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A pehx med ghig awg suhx haq sar gig thux pu awg suhx khuhn gha ke che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A pehx med ghig awg pir haq dawg peg che chaw a sug te ghad lehd ma koz, awg suhx haq mad kawq dawg gad hawg. Awg lawn ghod ver, awg pir awr lehr, daq che yaog,” lehz koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te pawz thad huh, Sa ba to awg ni haq Yer suq ha khuhn phanr kae tod-ag huh, yawd ved awg laq ghuhd teq pa cag no chehz lehq, i hehd laq kuhr khuhn ke si lehq pex cad tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Phar rir sehd ted pehg koz che, “A thoq te nig hehd Sa ba to awg ni ve awg lid haq te yaq cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yer suq i hehd haq kawq koz vid che, “Nig hehd teq pa Dar viq he lehq yawd ved awg chawd teq pa awr meq vehr huh, khawd-ehg te che awg lawn u ve maq gha ghawn jaw la. ");
INSERT INTO lhi_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dar viq Ghig sa ve yehg khuhn gehe lehq, Ghig sa haq tand vid lar che khaor mod haq yug cad lehq yawd ved awg chawd teq pa haq liz car vid che yaog. Awg lid cawg lar che heh te ver, Ghig sa ve paw khod teq pa ma hez ver te ghad-eg liz cad maq na hawg.” ");
INSERT INTO lhi_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Kheh te lehq, Yer suq Phar rir sehd haq koz vid che, “Chaw yad ve Yad phu awr lehr, Sa ba to awg ni ve Awg jawd mawd yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Awg nuz awr ve Sa ba to awg ni teq ni kawq gaeg lehq, Yer suq bon lawg kig lo gehe lehq mar vid chehd kig huh laq kuhr laq yaq awr pax suh che te ghad liz chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Phar rir sehd he lehq liq buhq var teq pa Sa ba to awg ni gaeg ver Yer suq chaw nag haq ghu na vid ver vend bax ca gha vid tug jaz ngawx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yer suq awr lehr, i hehd teq pa duhd chehd che haq sir lehq, laq kuhr teq pax suh che phad haq koz vid che, “Nawg tu lehq awg kaw jen lo ca hox lag,” lehd koz vid lehq, yawd liz tu lehq lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yer suq i hehd haq koz vid che, “Ngag nig hehd haq na ngawx sar. Sa ba to awg ni ver daq tug te cawd hawg la. Ma hez ver lug tug te cawd hawg la. Su ved a saq haq pong vid cawd hawg la. Ma hez ver te lug cawd hawg la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yer suq i hehd teq pa haq kha nehax caw ngawx peg lehq, chaw u ve phad haq koz vid che, “Nawg ved laq kuhr che peo,” lehd koz vid che yaog. Chaw u ve liz laq kuhr che pe lehq, yawd laq kuhr na vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","I hehd nez nag jad lehq, Yer suq haq khawd-ehg kheh gha te tug phoz jehg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Teq ni awr gaeg lehq, Yer suq Ghig sa geh bon lawg tug awg pun kehaq lo taez che yaog. Yawd teq hax muhd kha thid Ghig sa geh bon lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Muhd thid-ag lehq, yawd ved awg laq ghuhd teq pa haq yawd kug lehq, i hehd teq pa awg khuhn chaw teq chi ni ghad haq lez yug che yaog. Chaw u ve teq pa haq yawd cuh yad lehd koz meh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Chaw che ve teq pa awr lehr, (1) Per troq lehd koz meh lar che haq Yer suq Sid monr kawq meh vid che, (2) yawd ved awg nax var Anr drehr, (3) Yar koq, (4) Yod hanr, (5) Phid liq, (6) Bar thawd lar mehd, ");
INSERT INTO lhi_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","(7) Mar thehr, (8) Thod maq, (9) Ar lar phehd ve awg yad par Yar koq, (10) muhd mig haq haq che awg mor khuhn ve Sid monr, ");
INSERT INTO lhi_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","(11) Yar koq ve awg yad par Yud daq he lehq (12) Yer suq haq chid aq vid tug Yud daq Id sar kar rir oq che ve teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kheh te lar haz lehq, Yer suq yawd lez yug lar che awg laq ghuhd teq pa geh kehaq lo yaq lehq awg tawg khuhn hox chehd che yaog. Yawd ved awg laq ghuhd teq pa loar, Yud daq muhd mig khuhn ve awg kag gha lia lo lag che Yer ruq sar lehnr med he lehq lad chuhd ghig puhg pad huh ve Tud ruq he lehq Sid donr muhd mig lo chehd che chaw awg mor nux yawd ved tawd khuhd haq na tug he lehq i hehd nag chehd che a nar teq pa ghu na ax vid tug yawd geh phoz chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ned chaq chiz te lug vid che chaw teq pa haq liz yawd ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Chaw awg gha lia yawd haq gha soz gha duhq vid tug te che yaog. Awg lawn ghod ver, yawd awg khuhn kand pax tuhaz lehq i hehd awg gha lia haq ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yer suq awg laq ghuhd teq pa haq ngawx lar lehq koz che, “A meha har che ghuhd che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, Ghig sa ve muhd mig awr lehr nig hehd ve muhd mig yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","A meha meq chehd kaz chehd che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, nig hehd haq Ghig sa duhd buhz gad buhz ax tug yaog. A meha huhg chehd che chaw teq pa awr lehr, awg bon ir che yaog. Awg lawn ghod ver, nig hehd gha ghig tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Chaw yad ve Yad phu haq pad lehq su nig hehd haq cand che, sawnr kha ax che, su nig hehd haq koz gid ghig gid che, su nawg ved awg meh haq te lug ax che ver, awg bon ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Awg ni u ve teq pa khuhn ha lehg lehq pawz juhz chehd-oq. Awg lawn ghod ver, muhd nuh maq khod-aq lo nig hehd ve laq sawnr ir jad che yaog. I hehd ve awg pux awr pi teq pa liz, Ghig sa ve cuh kar var teq pa haq u kheh te lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","A meha, paw sa che chaw teq pa awr lehr, gha lug gha sez jad tug yaog. Awg lawn ghod ver, nig hehd awr lehr, a sug yawd duhd sa tug awg ceng haq saw gha peor. ");
INSERT INTO lhi_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A meha gha cad buhz dawg buhz chehd che chaw teq pa gha lug gha sez jad tug yaog. Awg lawn ghod ver, nig hehd gha meq gha kaz tug yaog. A meha ghig chehd che chaw teq pa gha lug gha sez jad tug yaog. Awg lawn ghod ver, nig hehd duhd har jad lehq gha huhg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Su awg gha lia nig hehd haq chid muha che te yand, nig hehd gha duhd har jad tug yaog. Awg lawn ghod ver, i hehd ve awg pux awr pi teq pa liz ma hez hez che cuh kar var teq pa haq u kheh te chid muh vid jaw che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kheh te cheaq te lehq nig hehd ngag khuhd na chehd che chaw teq pa haq ngag koz ax laq, nig hehd ve cand par teq pa haq haoq. Nawg haq ngawx bawg che chaw teq pa haq daq che awg ceng te vid-oq. ");
INSERT INTO lhi_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nawg haq khen che chaw teq pa haq awg bon naq vid-oq. Nawg haq kha muhd kha na tea che chaw teq pa awg pun bon lawg vid-oq. ");
INSERT INTO lhi_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nawg ved par loz teq pax haq tha phehad che chaw haq teq pax awr liz kawq phuhz mawr vid ser. Nawg ved a poq yehg maq haq yug gad che chaw teq pa haq a poq awg khuhn ve liz kawq pid fe ser. ");
INSERT INTO lhi_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nawg geh kha lawg che chaw awg gha lia haq pid-oq. Nawg ved med nged yug ve che chaw geh tad kawq yug khuhq. ");
INSERT INTO lhi_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Su nig hehd haq tea vid gad che heh, nig hehd liz su haq u kheh gha te vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Nawg haq haq che chaw teq pa haq lehax nawg haq ver, nig hehd awg pun a thoq awg bon cawg hawg le. Awg lawn ghod ver, vend bax yad teq pa liz i hehd haq haq che chaw haq kawq haq khuhd nuhd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nig hehd haq daq che awg ceng tea che chaw haq lehax daq che awg ceng kawq te khuhq vid ver, nig hehd awg pun teq chaweh awg bon mad cawg hawg. Vend bax yad teq pa liz u kheh te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nig hehd kawq khuhq gha tug yaog lehd duhd che chaw haq lehax chid vid ngar vid ver, nig hehd awg pun a thoq awg bon cawag le. Vend bax yad teq pa liz vend bax yad haq i hehd chid vid ngar vid lar che heh, kawq khuhq gha tug lehd duhd lar lehq chid vid ngar vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nig hehd awr lehr, nig hehd ve cand par teq pa haq haq lehq daq che awg ceng te vid-oq. Kawq khuhq gha tug haq ma duhd lar che khuhn su haq chid vid ngar vid-oq. U kheh te ver, nawg laq sawnr kha peh vad-ag gha lehq, ir jad muh jad che Ghig sa ve yad nawg gha te tug yaog. Awg lawn ghod ver, yawd awr lehr, awg bon haq maq sir vix che chaw he lehq haeg che chaw teq pa haq awg bon te vid vix che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nig hehd ve awr pa har kax vix che heh te lehq, nig hehd liz har kax vix che ni ma cawg vid-oq. ");
INSERT INTO lhi_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Su haq nawg vend bax taq tar. U kheh te ver, Ghig sa liz nawg haq vend bax maq tar hawg. Su haq nawg ta koz. U kheh te ver, nawg haq liz Ghig sa ma koz hawg. Su haq nawg vend bax phehd vid. U kheh te ver, Ghig sa liz nawg haq vend bax phehad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Su haq pid-oq. U kheh te ver, Ghig sa nawg haq pehar che te yand, kawg tug ir che haq kawq kawg ax cheaq keh liz, peh sez thad kha gag nex ke hiz ke lehq nig hehd ve ta poz khuhn juhd kea tug yaog. Awg lawn ghod ver, nig hehd su haq kawg vid lar che heh, su liz nig hehd haq kawq kawg ax tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yer suq i hehd haq tawd par hax te mar vid che, “Mehz cox che chaw mehz cox var haq yaq kaw sir mar vid gha hawg la. Ix mag ni ghad ghad mig kor khuhn maq che geh hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Awg taq pehd awr lehr, yawd ved sar lar haq keh ir che ma hez hawg. Kha nehax kha gha hend yug peg che chaw teq pa awr lehr, a sug yawd ved sar lar kheh tawa lehax yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nig hehd a sug yawd ved mehz kha khuhn cawg che suhz theh nux haq maq sir mad juhg he lar lehq, a thoq te nawg vix nawg nax teq pa ve mehz kha khuhn mehz pux nehax haq ca ngawx chehd cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nig hehd a sug yawd ved mehz kha khuhn cawg chehd che suhz theh nux haq mad mawg lehq, ‘A vix a nax ve mehz kha khuhn mehz pux nehax haq ngag yug kha ax laq,’ lehz a thoq te nawg vix nawg nax teq pa haq ca koz tod cheawg le. Chaw pha yax te var teq paog, nawg ved mehz kha khuhn cawg chehd che suhz theh nux haq awg kawd yug tuhz ser. U kheh te peg heh, nawg vix nawg nax ve mehz kha khuhn cawg chehd che mehz pux nehax haq khawd-ehg te yug tuhz tug nawg kha nehax sir lehq mawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Daq che awg cehg awr lehr, mad daq che awg sir nuhaq maq gha hawg. U ve haq kha sur suar, mad daq che awg cehg liz daq che awg sir nuhaq maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Awg lawn ghod ver, awg sir haq ngawx ver awg cehg teq pa haq sir che yaog. A chud cehg haq a kud sir maq gha sax jaw. A chud bid haq a pehx med sir maq gha sax jaw. ");
INSERT INTO lhi_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Daq che chaw awr lehr, a sug yawd ved ni ma khuhn daq che awg ceng doz lar kig huh ve daq che awg ceng haq yug tuhaz che yaog. Haeg che chaw liz, a sug yawd haeg che awg ceng doz lar kig huh ve haeg che awg ceng haq yug tuhaz che yaog. Awg lawn ghod ver, ni ma khuhn kha peh vad-ag cawg che heh yawd ved mawq kaw khuhn yaw tuhaz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ngag koz lar che heh nig hehd maq te he lar lehq, a thoq te ngag haq ‘Jawd mawd-og, Jawd mawd-og,’ lehd koz cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ngag chehd lo lag lehq ngag ved tawd khuhd haq kad lehq na yug che chaw teq pa awr lehr, khawd-ehg kheh te che chaw haq sur daq che, ngag nig hehd haq koz mar laq sar. ");
INSERT INTO lhi_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Yehg tanr te tanr kawx che te yand, nax chawa dud lehq huhx meh thag huh teh lehq te lar che chaw te ghad haq sur che yaog. A kaz ir taz lehq, a kaz duhd yehg u ve haq thinr liz, kha yeg ghad dud ti lar cheaq te lehq ma hiz nez. ");
INSERT INTO lhi_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kheh ma khuhd, tawd khuhd haq gha kad lehq maq na yug che chaw teq pa awr lehr, awg cuhz penr ma dud ke lehq mig thang lehax kawx lehq te lar che chaw te ghad haq sur che yaog. A kaz ghig duhd yehg u ve haq thinr lehq, teq pear lehax yehg u ve kuhd lehq lug jad sez jad vehr tug yaog,” lehd koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yer suq awr lehr, chaw kheh ma ve haq tawd khuhd u ve awg gha lia saw mar vid lar haz lehq, Kar per nar unr med lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Awg yand u ve khuhn Rod maq ve maq por te ghad, yawd haq che awg ceg te ghad nag lehq suh vehr tez che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Maq por u ve Yer suq awg lawn gha kad lehq, yawd ved awg ceg haq ghu na vid tug, Yud daq chaw teq pa ve awg hox chaw mawd teq pa kae pe lehq, Yer suq haq ca lawg khawx pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","I hehd Yer suq chehd lo gaeg lehq, Yer suq haq kha nehax lawg khawx lehq koz che, “Nawg yawd haq che kheh te vid kenr che chaw te ghad yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Awg lawn ghod ver, yawd a nig ved chaw ceng haq haq lehq a nig awg pun bon lawg kig tea lar peg che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kheh te lehq, Yer suq i hehd geh kae che yaog. Maq por ve yehg pad huh gaeg che te yand, maq por yawd ved awg chawd teq pa haq lag pea lehq koz che, “Jawd mawd-og, nawg awg pun har tug taq teo. Awg lawn ghod ver, ngag nawg haq haq yug lehq ngag ved yehg khuhn lag vid tug ngag maq kenr. ");
INSERT INTO lhi_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Kheh te lehq ngag liz nawg chehd lo lag maq kenr hawg lehd duhd che yaog. Kheh te lar nawg tawd teq pear lehax yaw liz, ngag ved awg ceg na vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Awg lawn ghod ver, ngag awr lehr su ved kand pax awg huhx uh chehd lehq ngag huhx uh liz maq yad teq pa cawg che yaog. Ngag chaw che te ghad haq ‘Kae’ lehd koz vid ver yawd veh che yaog. Chaw u ve phad haq ‘Laor’ lehd koz vid ver, yawd lag che yaog. Ngag ved awg ceg var haq liz ‘Che ve te’ lehd koz vid ver, yawd te vehr che yaog,” lehd ca koz vid pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tawd khuhd u ve haq Yer suq gha kad che te yand, yawd and lehq yawd kuhr tehx nuhr ghaq tod che teq pa haq kuhr phuhz ngawx lar lehq koz che, “Id sar rer laq chaw awg khuhn liz che kheh taw maq yonr che chaw ngag mad mawg jaw ser,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Yawd ved awg chawd teq pa yehg lo kawq gag gha mehx, awg ceg var na vehr chehd lawz che haq i hehd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","U kheh te lar haz maq muh tand, Yer suq he lehq yawd ved awg laq ghuhd teq pa Nar id naq meh che khaz lo kae lehq, chaw awg mor nux i hehd geh teq geha kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","I hehd teq pa lag lehq med u ve ghaz mir huh gaeg che te yand, chaw suh te ghad haq su ga taz si tod lawz che haq gha mawg daq che yaog. Chaw suh u ve awr lehr, meh chuhd ma ve yad par te ghad lehax te che suh vehr che haq su ga taz ve veh tod che geh awr ye meh chuhd ma he lehq med yad teq pa liz, awg mor nux te lehq veh tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jawd mawd Yer suq Khreq awr lehr, yad mid u ve haq gha mawg lehq yawd haq har kax jad lehq koz vid che, “Tad huhg” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Yer suq awr lehr, awg pad huh kae lehq taz tod che kawnd kor haq yig vad-eg lehq, taz par teq pa jehd vehr che yaog. Yer suq koz che, “Chaw hax var-og, ngag nawg haq koz ax laq, tu laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Suh chehd che chaw u ve tu mi lehq, tawd yaw vehr che yaog. Yer suq awr lehr, chaw hax var u ve awr ye ve laq khuhn yawd haq aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Chaw awg gha lia kuhz jad lehq, Ghig sa haq chi ir chid muh lehq koz che, “Ghig sa ve cuh kar var nux a nig chehd huh tuhaz vehr che law. Ghig sa awr lehr, yawd ved chaw teq pa haq ca ngawx-ag vehor,” lehz i hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yer suq ve awg lawn che Yud daq muhd mig khuhn he lehq awg kiz awg naz awg kag gha lia lo buhg veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yod hanr ve awg laq ghuhd teq pa awr lehr, awg lawn u ve awg gha lia Yod hanr haq saw khae mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yod hanr awr lehr, yawd ved awg laq ghuhd ni ghad haq kug yug lehq, Yer suq chehd lo ca na ngawx pe lehq koz che, “Te ghad lag lawg ghod che nawg yaog la. Ma hez ver, te ghad haq gha kawq law ser lawg la.” ");
INSERT INTO lhi_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Chaw u ve ni ghad Yer suq chehd lo gaeg lehq na che, “Te ghad lag lawg ghod che u ve nawg yaog la. Ma hez ver, awg kag awg nuz awr ve chaw te ghad haq gha duhd law ser lawg la. Baz tiz sar pehar var Yod hanr ngag nid-ag haq nawg chehd lo ca na pea lar che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Awg yand u ve khuhn, Yer suq chaw nag teq pa a nar laex ceng te nag che laex ghad haq ghu na vid lehq, haeg che ned geh che haq liz ghaq kog vid lehq mehz cox che chaw teq pa haq liz mehz kawq mawag vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yer suq ix mag haq kawq koz vid che, “Nig mag kha gha kad kha gha mawg che teq pa Yod hanr haq ca kawq koz vid-eq. Mehz cox che chaw teq pa mehz kawq mawag lehq, khi lug che chaw teq pa yaq kaw tod gag che, khir tuq kex che chaw teq pa daq kehag che, nar puh bag che chaw nar puh kad-ag che, suh vehr che chaw teq pa kawq teq tuag lehq, har che ghuhd che chaw teq pa liz, ha lehg che bon khuhd haq gha kad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ngag haq ni ma mad lug lehq yonr che chaw teq pa awr lehr, awg bon ir che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yod hanr cuh pea che chaw u ve ni ghad kawq veh lehq, Yer suq awr lehr chaw mor nux haq Yod hanr awg lawn khae mar vid che, “Nig hehd heh pir khuhn awg god khehz teag lo kae che a thoq haq ca ngawx-eg tug kae cheawg le. Pund cehg haq muhd huh mez lehq, aw taz aw yaq te chehd che haq ca ngawx-eg cheawg la. ");
INSERT INTO lhi_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ma hez ver, a thoq haq ca ngawx-eg tug kae cheawg le. Beg ke pehz daq mehz awg nud nehq te che veq lar che chaw haq la. Veq kad daq lehq cad tug dawg tug daq che chaw teq pa awr lehr, jawd mawd ve hawx yehg khuhn chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ma hez ver, a thoq haq ca ngawx-eg cheawg le. Ghig sa ve cuh kar var haq la. Yaog, Ghig sa ve cuh kar var haq ca ngawx-eg che yaog. Ngag nig hehd haq koz ax laq. Yawd awr lehr, Ghig sa ve cuh kar var haq keh ir che chaw te ghad yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Liq phu khuhn koz lar che Yod hanr che phad yaog. Ngawx lor. Nawg ghud med lo nawg ved yaq kaw haq te tug ngag ved cuh yad haq nawg ghud med awr lo kae vid tug yaog, lehd koz buhq lar cheawg lehr yawd haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ngag nig hehd haq koz ax laq, yad mid ma khuhn kha paw tuhaz che chaw teq pa khuhn awr lehr, Yod hanr haq keh ir che chaw te ghad-e liz mad cawg hawg. Kheh ma khuhd, Ghig sa ve muhd mig khuhn suaq keh i jad che chaw te ghad awr lehr, yawd-aq keh liz ir ser che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yer suq koz che haq awg khawnr saw var he lehq chaw awg gha lia gha kad che te yand, Ghig sa te che awr lehr, thed jad cawd jad law lehd koz che yaog. I hehd Yod hanr ve baz tiz sar haq khanr yug lar haz peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kheh ma khuhd, Phar rir sehd teq pa he lehq awg lid tawd khuhd sir var teq pa awr lehr, Ghig sa i hehd awg pun te lar che awg ceng haq mad haq yug, awg lawn ghod ver, Yod hanr baz tiz sar pid che haq i hehd mad haq yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Kheh te lehq Yer suq koz che, “Chaw a meha ve teq co ve haq a thoq gha yug tehz mar tuawg le. I hehd a thoq haq sur daq cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Chaw che teq co haq ve awr lehr, chaw yad nehax teq pa kax khuhn mi lar kug daq lehq koz che, ngag hehd nuhr mez liz nig hehd ka ma khez, ngag hehd kug huhg paz huhg liz nig hehd ma duhd har, lehd koz chehd che haq sur che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Awg lawn ghod ver, baz tiz sar pehar var Yod hanr lag lehq khaor mod ma cad lehq a pehx med ghig mad dawg cheaq te lehq, nig hehd yawd haq ned geh che chaw lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chaw yad ve Yad phu lag lehq, cad che dawg cheaq te lehq, chaw cheawg lehr cad pong cad lex che chaw, a pehx med ghig dawg pong dawg lex che chaw, awg khawnr saw var he lehq vend bax yad teq pa haq awg chawd te che chaw yaog, lehz nig hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kheh ma khuhd, Ghig sa ve cud yiq ma yiq haq haq yug che chaw teq pa awr lehr, cud yiq ma yiq u ve thed cawd lehq daq che haq gha mawg tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Phar rir sehd te ghad yawd geh awr cad tug Yer suq haq kug che yaog. Kheh te lehq, Phar rir sehd u ve yehg khuhn yawd gehe lehq mi cad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Phar rir sehd ve yehg khuhn, Yer suq mi cad chehd che haq med u ve khuhn chehd che haeg che yad mid ma te ghad gha sir lehq, nag huhx ke lar che phux-u lehd te che huhx meh te lar che a kaw ted mag yug vea lag lehq, ");
INSERT INTO lhi_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yer suq kuhr tehx nuhr phawd awr khi pad huh hox lar huhg chehd che yaog. Yawd ved mehz ghig Yer suq khi haq coz kaq lehq, yawd ved cuhz kheh muh yug siz che yaog. U kheh te peg lehq, yawd Yer suq ve khi haq bux vid peg lehq nag huhx puhr vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Yer suq haq kug lar che Phar rir sehd u ve phad yawd gha mawg lehq, yawd ni ma khuhn duhd che, “Chaw cheawg lehr, Ghig sa ve cuh kar var awr lehd koz ver, yawd haq duhq chehd che yad mid che ve khawd-ehg kheh ve yad mid awg le ghod che he lehq a suawg le ghod che haq yawd sir tug yaog. Awg lawn ghod ver, yad mid cheawg lehr, haeg che yad mid yaog,” lehz yawd duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yer suq kawq koz che, “Sid monr-og, ngag nawg haq ted ceng koz ax laq mehr.” Sid mor koz che, “Koz ax hehq sar lar-og,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yer suq koz che, “Phu chid vid var te ghad geh jeg cawg var ni ghad cawg che yaog. Te ghad vawr, jeg ngad ha thehq cawg lehq, te ghad vawr, jeg ngad chi thehq cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ix mag jeg khuhq sehr tug phu mad cawg te lehq, phu chid vid var ix mag ni ghad ghad haq jeg kheha pong vid vehr che yaog. Kheh te ver, ix mag awg khuhn khar ve te ghad vawr, yawd haq lex lehq kawq haq tuawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sid monr kawq koz che, “Ngag duhd che, jeg haq gha pong mad che phad awr lehr, lex lehq kawq haq mad tug yaog.” Yer suq yawd haq koz vid che, “Nawg duhd che cawd vehr che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yer suq yad mid u ve haq kuhr phuhz ngawx lar lehq Sid monr haq koz vid che, “Yad mid che ve haq nawg mawar la. Ngag nawg ved yehg khuhn ngag gehag huh, ngag khi chuhd tug a kaz nawg maq pehar. Kheh ma khuhd, yad mid che te ghad awr lehr, yawd ved mehz ghig ngag ved khi haq coz puhr lehq yawd ved cuhz kheh muh yug siz ax peor. ");
INSERT INTO lhi_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ngag nawg yehg khuhn tanr gehag huh, nawg ngag haq maq buax. Kheh ma khuhd, yad mid cheawg lehr yawd tanr gehag loar, khar thad liz ngag ved khi haq bux don chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nawg ngag ved a kor haq nag huhx ma gehz ax. Kheh ma khuhd, yawd awr lehr ngag ved khi haq nag huhx puhr ax vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kheh te cheaq te lehq, ngag nawg haq koz ax laq, yawd awr lehr, vend bax mad jad che haq gha pong cheaq te lehq haq mad che yaog. Vend bax a cehax lehax cawg lehq gha pong che chaw awr lehr, a cehax lehax haq che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yad mid u ve haq liz yawd koz vid che, “Nawg ved vend bax teq pa haq ngag phehad vehor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Yawd geh mi cad chehd che chaw teq pa duhd lehq koz daq che, “Vend bax haq liz phehd kha gha che chaw che a suawg le,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yer suq yad mid u ve haq koz vid che, “Nawg yonr cheaq te lehq, nawg gha pong vehor. Ha lehg duhd sa che khuhn kae lor.” ");
INSERT INTO lhi_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","U ve khaz nuhr, maq muh tand Yer suq awr lehr, te med peg te med te khaz peg te khaz lo kae lehq, Ghig sa ve muhd mig awg lawn ha lehg che bon khuhd ca koz mar vid tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Cuh yad teq chi ni ghad liz, yawd geh kae che yaog. Kheh te lehq, yad mid teq pa ted pehg khuhn haeg che ned haq Yer suq ghaq kog lehq, nag che guhg che teq pa haq yawd ghu na vid lar che yad mid teq pa liz yawd geh kae che yaog. U ve teq pa awr lehr, ned suhr kheh tuhz veh jaw che Mar gar dar laq lehd koz che Mar riq, ");
INSERT INTO lhi_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Her roq ve med nged haq sax var Khud saq ve awg mid ma Yod har naq, Sud sar naq he lehq awg kag awg nuz awr ve yad mid teq pa laex ghad, a sug yawd ved med nged jeg kor teq pa haq yehd lehq, Yer suq he lehq awg laq ghuhd teq pa haq ga vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Med teq pa lo lag che muhd mig yad teq pa chaw kha peh vad-ag Yer suq chehd lo phoz lag lehq, yawd i hehd haq tawd par hax te mar vid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ha kawd cad var te ghad yawd ha khuhn awg yuhd ca ser che te yand, awg yuhd ted pehg yaq kaw khuhn che geh lehq, su ga naz tod lehq ngaz teq pa liz ghawz cad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Awg yuhd ted pehg huhx meh dig thang cawg che mig sar nehax pad-a ghad te che thag huh che geh lehq, awg yeg yeag che te yand mig sar god cheaq te lehq nuhr vehr god vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Awg yuhd ted pehg pehar a chud de khuhn che geh lehq, a chud goq khuhn yeag lehq awg yeg u ve haq a chud bid hoz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Awg yuhd ted pehg pehg ax ver, mig khid daq kig huh che geh lehq, awg yeg yeag lehq awg cehg iar che te yand, awg sir awg no teq ha pun nuhaq che yaog.” Yawd u kheh koz peg lehq awg khuhd hehnd chawa kug lehq koz che, “Na tug nar puh cawg che chaw teq pa kha nehax nao,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kheh te lehq, yawd ved awg laq ghuhd teq pa awr lehr, yawd haq kawq na lehq koz che, “Tawd par hax che ve a thoq haq koz gad cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yer suq kawq koz che, “Ghig sa ve muhd mig awg lawn khuhd ceh lar che awg ceng teq pa haq nig hehd sir tug a khawag cawg che yaog. Kheh ma khuhd, awg kag awg nuz awr ve chaw teq pa awr lehr, ngawx chehd liz ngawx mad mawg lehq kad chehd liz na maq gha tug, i hehd haq tawd par hax lehax gha te mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tawd par hax che cuhx kig awr lehr, che kheh yaog. Awg yuhd awr lehr, Ghig sa ve bon khuhd yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yaq kaw khuhn ve chaw lehd koz che teq pa awr lehr, bon khuhd u ve haq i hehd gha kad peg liz khawd-ehg te lehq i hehd maq gha yonr tug he lehq thaer khuhq che haq maq gha vid tug, ned haeg Sar tanr lag lehq i hehd ni ma khuhn ve bon khuhd u ve haq yug kha vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Huhx meh thag lo ve chaw lehd koz che teq pa awr lehr, bon khuhd u ve haq gha kad lehq ha lehg ha ka haq yug che chaw teq pa haq koz che yaog. Kheh ma khuhd, i hehd awg chi ma cuhz nax cheaq te lehq, teq cuhx teq jaw nehax lehax yonr lehq ber che lawd cheaq gha phud ver kawq lug vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A chud de khuhn ve chaw lehd koz che teq pa awr lehr, i hehd bon khuhd haq gha kad peg che chaw teq pa yaog. Kheh ma khuhd, i hehd mig gig khod-aq lo a saq teq chehd che te yand, duhd har gad har che teq pa, paw sa che teq pa he lehq ha lehg tug awg ceng teq pa i hehd haq hoz lar lehq, awg sir nuhaq maq gha. ");
INSERT INTO lhi_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mig gig daq kig lo ve chaw lehd koz che teq pa awr lehr, daq che ni ma awg khuhn gha kad che chaw teq pa haq koz che yaog. I hehd awr lehr, bon khuhd u ve haq cuhz cid lar lehq, yeg khanr che khuhn awg sir nuhaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A mir khehd tox lehq khuhr luhd cuhr muhq lar che ma koz, tehn huhx uh tar che ma koz, chaw te ghad-eg liz maq te hawg. Kha lag che chaw teq pa awg ghiz haq gha mawg tug a mir khehd tar kig lo tar lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Awg lawn ghod ver, kha khuhd ceh lar che awg ceng teq pa kha nehax gha mawg tug yaog. Su haq maq sir cuh vid gad che awg ceng teq pa liz su siar lehq, awg ghiz pawd kig lo tuhaz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kheh te lehq, nig hehd kha gha kad che teq pa haq sa tiq tar-oq. Awg lawn ghod ver, cawg che chaw haq kawq ix vid tug yaog. Mad cawg che chaw geh yawd cawg chehd-aq lehd duhd che teq pa haq liz kawq yug ve ser tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yer suq awr ye he lehq awg nax var teq pa yawd chehd lo lag che yaog. Kheh ma khuhd, chaw mad jad lehq yawd chehd lo gehe mad gag. ");
INSERT INTO lhi_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Su yawd haq koz vid che, “Nawr ye he lehq nawg nax var teq pa nawg haq mawg gad lehq, awg bag lo hox law chehd-aq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yawd i hehd haq kawq koz vid che, “Ghig sa ve tawd khuhd haq kad lehq na yug che chaw teq pa awr lehr, ngar ye he lehq ngag nax teq pa heh yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Te ni gaeg lehq Yer suq awr lehr, yawd ved awg laq ghuhd teq pa geh huh lawd kor khuhn gehe lehq i hehd teq pa haq koz vid che, “A nig ghig po nux ox pax awr khanr kae veg,” lehd koz vid lehq huh lawd kor khuhn veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","I hehd teq pa kae tod-ag huh, Yer suq yuhq mir ka vehr che yaog. Awg yand u ve khuhn muhd huh nux lag lehq, huh lawd kor khuhn a kaz ghig bad dawz gehag che kuhz lawq lawq he lehq a kaz thur vehr lehd te lehq, i hehd suh lawq lawq gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Awg laq ghuhd teq pa Yer suq haq ca nuhr tu vid lehq koz che, “Jawd mawd-og, ngag hehd teq pa suh vehr tez-or,” kheh te lehq, yawd tuag lehq muhd huh he lehq ghig bad haq ded vid lehq muhd huh jehd vehr lehq ghig bad liz dehg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yer suq i hehd haq na lehq koz che, “Nig hehd teq pa yonr che ni ma khar lo saw veh cheawg le,” lehd koz vid che yaog. I hehd teq pa kuhz jad and jad lehq koz daq che, “Ag log, chaw che phad che a suawg le. Yawd ded ver, ghig bad he lehq muhd huh teq pa liz yawd khuhd na che law.” ");
INSERT INTO lhi_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kheh te lehq i hehd awr lehr, Gar liq lehd muhd mig haq tawr ghad huh chehd che Ger rar saq muhd mig lo gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yawd huh lawd kor khuhn tuhaz lehq pehg puhg huh mig gig thag lo gaeg che te yand, med u ve khuhn chehd che ned geh che haw khaz var te ghad yawd haq ca mawg daq che yaog. Chaw u ve awr lehr, beg ke veq kad mad veq lehq yehg khuhn liz ma chehd lehq chaw tur phuh cawg kig loa lehax chehd che muh jad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Chaw u ve Yer suq haq gha mawg che te yand, aox vad-ag he lehq yawd mehz khuhd suhr huh kuhd veh lehq boz cuhx lar huh kug lehq koz che, “Muh jad che Ghig sa ve Yad phu Yer suq-og, a thoq te nawg ngag haq ca te soq saq tod cheawg le. Nawg ngag haq tad tuq khaq cuha laoq ngag lawg khawx che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yawd u kheh koz cheawg lehr, Yer suq ned u ve teq pa haq ded lehq chaw u ve phad khuhn ghaq kog cheaq te lehq, a mig awr ver, ned chaq chiz u ve te thawz te thawz chaw u ve phad khuhn geh lehq, su yawd ved laq kuhr khi kud haq son kawng son caz yug pheh teh lar lehq chaw paog chehd che yaog. Kheh te liz saw uhx theh saw cuhz chez lar haz lehq, heh pir khuhn gawr ghad teag lo sir ve phaw veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","“Nawg a thoq meh cheawg le,” ghod lehq Yer suq yawd haq na lehq yawd koz che, “Ngag ved awg meh awr lehr, Ned Phoz meh che yaog,” lehd koz vid che yaog. Awg lawn ghod ver, yawd awg khuhn ned kha peh vad-ag chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ned u ve teq pa i hehd haq nax jad che ted kag lo Yer suq i hehd haq maq gha yug kea vid tug, yawd haq hax ceh lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Keh u ve thag huh vaq mor nux buhd cad chehd che yaog. Vaq u ve teq pa khuhn i hehd geh chehd tug, Yer suq geh i hehd a khawag lawg lehq, yawd i hehd haq a khawag pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kheh te lehq, ned u ve teq pa chaw u ve phad khuhn tuhaz lehq vaq mor u ve khuhn kawq gehe lehq, vaq u ve teq pa pehg phawd-aq lo huh cex kae lehq, a kaz khuhn saw pawz geh lehq a kaz saw ka suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Vaq hu par teq pa awg ceng u ve teq pa haq gha mawg lar haz lehq, i hehd cex koeq lehq med khuhn he lehq med jad med je lo cawg che khaz teq pa khuhn teq suh ca kaod koz vid-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kheh te lehq, awg ceng u ve teq pa haq chaw kha peh vad-ag ga ca phoz ngawx-eg che yaog. I hehd teq pa Yer suq chehd lo lag gag a mehx, ned saw tuhz veh che u ve phad beg ke veq kad kha nehax veq deh lehq, chaw cehg mag he lehq Yer suq khi pad huh mi chehd lawz cheaq gha mawg lehq i hehd kuhz jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Gha mawg lar haz che chaw u ve teq pa awr lehr, ned geh che chaw u ve phad khawd-ehg kheh te na vehr che awg lawn su haq koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","U kheh te cheaq te lehq, Ger rar saq muhd mig khuhn chehd che chaw teq pa kuhz jad cheaq te lehq, Yer suq i hehd chehd kig huh tuhez vid tug yawd haq lawg khawx che yaog. Kheh te lehq, Yer suq liz huh lawd kor khuhn geh lehq kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kheh te lehq ned tuhz veh che chaw u ve phad awr lehr, Yer suq geh kae tug yawd haq lawg khawx che yaog. Kheh ma khuhd Yer suq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nawg ved yehg lo koeq lehq, Ghig sa nawg haq khawd-ehg taw maq ga peg che awg lawn ca koz vid-eq,” lehd koz lehq yawd haq kawq pe che yaog. Kheh te lehq, yawd kae lehq Yer suq yawd haq khawd-ehg taw maq tea lar che awg lawn teq pa med u ve khuhn saw ca koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kheh te lehq Yer suq Gar liq lehd lo kawaq gag lehq, chaw awg mor nux yawd haq duhd law chehd cheaq te lehq yawd haq haq yug vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yar id ruq meh che bon lawg kig huh ve awg hox te chehd che te ghad phad lag lehq, Yer suq ve khi pad huh a kor pi lehq boz cuhx lar lehq, Yer suq haq yawd ved yehg lo lag vid tug lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Awg lawn ghod ver, yawd yad mid a saq teq chi nid khuhq heh gaeg che yad mid te ghad lehax cawg che suh vehr tez che yaog. Yer suq awr lehr, kae che te yand, chaw mor nux kar huh biz daq caq daq te kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Awg yand u ve khuhn, teq chi nid khuhq kha gag awg suhr yaq lehq nag chehd che yad mid te ghad cawg che yaog. Chaw te ghad-eg liz yawd haq ghu na vid maq gha. ");
INSERT INTO lhi_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yawd awr lehr, Yer suq kuhr tehx nuhr phawd awr veaq lag lehq, yawd ved a poq yehg ma awg jog med nehax haq vad lehq yawd suhr yaq chehd che teq pear lehax cheh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yer suq awr lehr, “Ngag haq a sug vad cheawg le,” lehd koz na che yaog. Chaw kheh ma ve a sug liz ma vad lehd koz daq chehd lehq Per troq koz che, “Jawd mawd-og, chaw mor nux nawg haq biz daq caq daq he lehq cehr cehr noz noz te lehq nawg haq duhq che ma hez hawg la,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kheh liz Yer suq koz che, “Chaw te ghad ghad ngag haq vad che yaog. Awg lawn ghod ver, ngag awg khuhn kand pax tuhz veh che haq ngag juhg che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yad mid u ve awr lehr, khuhd ceh maq gha veh che law lehz sir vehr lehq, yawd kuhz jad che khuhn tuhaz lehq Yer suq mehz khuhd suhr kuhz ched che khuhn boz cuhx lar lehq koz che, a thoq te lehq vad che he lehq yawd a nar na vehr che chaw kheh ma ve kad chehag huh koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yer suq yawd haq koz vid che, “Yad mid-og, nawg a nar na vehr che ix ve awr lehr, nawg yonr che haq te lehq yaog. Ha lehg duhd sa che khuhn kae lor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yawd u kheh koz chehd-ag huh, bon lawg kig awg hox ve yehg lo lag che chaw te ghad koz che, “Nawg yad mid suh vehor. Sar lar haq taq te soq saq vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tawd khuhd u ve haq Yer suq gha kad lehq Yar id ruq haq koz vid che, “Ta kuhz. Ngag haq yonr chea lehax teo. Yawd na vehr tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kheh te lehq Yer suq yawd yehg huh lag gag lehq, Per troq, Yod hanr, Yar koq he lehq yad mid nehax ve awr ye awr pa ma hez ver, chaw te ghad-eg liz yawd geh maq gha gehe cuh vid. ");
INSERT INTO lhi_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yad mid nehax u ve suh vehr cheaq te lehq su paz huhg kehd huhg chehd-ag huh, Yer suq i hehd haq koz vid che, “Taq ca huhg. Yawd maq suh ser hawg. Yuhq mir ka chehd cheawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Chaw yad nehax u ve awg cehg mag suh vehr che haq i hehd sir chehd cheaq te lehq, Yer suq haq i hehd ghig yuhg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yawd yad mid nehax ve laq kuhr haq yug cid lar lehq koz che, “Yad mid-og, tu laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kheh te lehq, yawd ved co ha kawq gehag lehq teq pear lehax yawd tu mi vehr che yaog. Yawd haq cad tug yug vea car vid laoq, lehz Yer suq awr ye awr pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yad nehax u ve awr ye awr pa and jad che yaog. Kheh liz awg lawn che ve, ix mag su te ghad-eg haq liz maq gha khae mar vid tug Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kheh te lehq Yer suq awg laq ghuhd teq chi ni ghad haq kug teh lar lehq ned awg gha lia haq ghaq kog gha tug he lehq chaw nag teq pa haq te na vid gha tug kand pax pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kheh te lehq, i hehd Ghig sa ve muhd mig awg lawn ca mar ca koz vid lehq chaw nag teq pa haq ghu na vid tug, yawd i hehd haq kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yawd koz che, “Yaq kaw kanr yehd tug jud fir tag, laq sax, cad tug, phu he lehq a poq awg lex teq pa teq chaweh tad yug ve kae. ");
INSERT INTO lhi_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Kheh te lehq, yehg khar ve khuhn gha hax vehr liz, ted kag lo maq gha kawq kae ser che kheh ceh, yehg u ve khuhn kha nehax chehd lar. ");
INSERT INTO lhi_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nig hehd haq mad haq yug ax ver, nig hehd khaz u ve khuhn tuhez lehd te che te yand, nig hehd ve khi ho haq hehr chehd che a jeq mia u ve siz kha lar haz. U kheh te ver i hehd teq pa ve yaq kig suaq sax khiz te mar vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kheh te lehq i hehd teq pa te khaz peg te khaz lo kae lehq, ha lehg che bon khuhd ca mar vid-eg lehq, chaw nag teq pa haq liz ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Awg lawn che teq pa haq jawd mawd Her roq gha kad lehq, yawd a cehax liz ca duhd ma tuhz che yaog. Awg lawn ghod ver, chaw ted pehg pehg ax koz che, Yod hanr suh vehr che kawq teq tuag vehor lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Lex lehq ted pehg kawq koz che, Ghig sa ve cuh kar var Ed lid yaq tuhaz vehor lehd koz che yaog. Ted pehg pehag ver, kawq koz che a mig thad lo Ghig sa ve cuh kar var te ghad ghad kawq teaq vehr che law lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Her roq koz che, “Yod hanr vawr ngag kuhr tawz vehr che ehx eh. Kheh te lar su koz daq lehq ngag gha kad chehd che u ve phad a sug lehq nar,” lehd duhd lehq, Yer suq haq yawd mawg daq tug ghaq ca chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Awg yand u ve khuhn cuh yad teq pa kawaq lehq, i hehd kha te lar haz che awg lawn teq pa Yer suq haq koz mar vid che yaog. Yawd awr lehr, i hehd haq lehax taq chuhax kug ve lehq, Ber sehd daq ghod che med lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kheh liz, muhd mig yad teq pa gha siar che te yand, i hehd teq pa yawd khaz nuhr phoz ghaeq che yaog. Yawd i hehd haq haq yug vid lehq, Ghig sa ve muhd mig awg lawn mar vid lehq, a nar nag che chaw teq pa haq liz yawd ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Muhd phiq vehr tez lehq, cuh yad teq chi ni ghad yawd chehd lo lag lehq koz che, “Chaw che teq pa haq awg pad huh cawg che khaz khuhn pan khuhn ca hax lehq, cad tug dawg tug ca vig cad-eg vid tug, i hehd haq phehd vid-oq. Awg lawn ghod ver, chuhr huh teq chaweh mad cawg te kig huh te lehq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kheh ma khuhd yawd koz che, “Nig hehd teq pa i hehd teq pa haq car vid-oq,” lehd koz vid che yaog. I hehd kawq koz che, “A nig geh cawg che cad vid tug chaw kheh ma ve haq car tug maq ca kawq vig ix ver ma mad, a nig geh khaor mod ngad dig he lehq ngad nehax niq kheha lehax cawg che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Awg lawn ghod ver, chaw u ve teq pa haw khaz lehax liz, a lag ngad hinx ghad kheh ma cawg che yaog. Kheh te lehq Yer suq yawd ved awg laq ghuhd teq pa haq koz vid che, “Chaw che teq pa awg mor awg mor te phoz mi cuh vid-oq. Teq mor ve ngad chi ghad kheh taw,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","I hehd teq pa liz, chaw awg gha lia haq u kheh te phoz mi cuh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yer suq awr lehr, khaor mod u ve ngad dig he lehq ngad niq kheh u ve haq yug lar lehq, muhd nuh kawag lo kuhr chid ngawx lar lehq Ghig sa haq chid muh che yaog. U kheh te peg lehq, awg laq ghuhd teq pa haq khehq vid lehq, chaw u ve teq pa haq ca pehg car vid cuh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","I hehd teq pa kha buhz gha cad peg nuhr, kawq ghawz khuhq che awg lex ve teq chi niq khuhr luhd kawq cawg chehd ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Teq ni thad huh, Yer suq yawd te ghad lehax bon lawg chehd huh, awg laq ghuhd teq pa phoz lag lehq yawd i hehd haq na ngawx lehq koz che, “Su ngag haq a suawg lehd koz chehd-aq le.” ");
INSERT INTO lhi_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Awg laq ghuhd teq pa kawq koz che, “Su koz che nawg awr lehr, baz tiz sar pehar var Yod hanr yaog lehd koz chehd-aq. Ted pehg vawr, Ghig sa ve cuh kar var Ed lid yaq law lehd koz chehd-aq. Kheh te lehq ted pehg pehar ver, a sawehd lo ve Ghig sa ve cuh kar var te ghad ghad kawq teaq che law lehd koz chehd-aq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Kheh te lehq Yer suq i hehd haq kawq na che, “Kheh te ver, nig hehd vawr hehq, ngag haq a suawg lehd koz chehd cheawg lehq.” Per troq yawd haq kawq yaw khuhq vid lehq koz che, “Nawg awr lehr, Ghig sa ve Khreq yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Awg lawn u ve su te ghad-eg haq maq gha koz vid tug, Yer suq i hehd haq tawd chuhd lar haz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kheh te lehq yawd koz che, “Chaw yad ve Yad phu awr lehr, laex ceng haq gha tuq gha khanr tug yaog. Awg hox chaw mawd teq pa, Ghig sa ve paw khod nux teq pa he lehq liq buhq var teq pa liz yawd haq chid bag lehq su dawz vehr tug yaog. Kheh liz sehr ni gaeg ver, yawd kawq teq tuag tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kheh te lehq, Yer suq i hehd awg gha lia haq koz vid che, “Chaw khar ve te ghad lehd ma koz, ngag khaz nuhr ghaq gad ver, a sug yawd ved a lor haq teh lar haz lehq, ni gha lia a sug yawd ved laq kan haq taz lehq ngag khaz nuhr ghaq laoq. ");
INSERT INTO lhi_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Awg lawn ghod ver, a sug te ghad lehd ma koz, a sug yawd ved a saq pong tug te liz, yawd ved a saq gha sond tug yaog. Kheh ma khuhd, a sug te ghad lehd ma koz, ngag awg pun a saq gha sond liz, yawd ved a saq haq ngag yug pong vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kheh te lehq, chaw te ghad ghad mig gig khod-aq kha cawg che awg ceng yawd saw gha vehr liz, yawd ved a saq gha sond vehr tug ver, a thoq awg bon cawag le. ");
INSERT INTO lhi_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Chaw khar ve te ghad lehd ma koz, ngag haq he lehq ngag ved tawd khuhd haq yaq taw hawg ghod ver, Yad phu ved awg mig awg phond, Awr pa ve awg mig awg phond he lehq daq kehg che muhd nuh maq cuh yad teq pa ve awg mig awg phond khuhn lag che te yand, chaw yad ve Yad phu liz chaw u ve haq yaq taw tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ngag nig hehd haq awg cehg mag koz ax laq, chuhr huh hox chehd che chaw teq pa ted pehg pehar awr lehr, Ghig sa ve muhd mig haq maq gha mawg ser ver, maq ca suh ser hawg,” lehz yawd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yer suq u kheh koz peg nuhr, hex ni kheh taw gaeg lehq, Yer suq awr lehr Per troq, Yod hanr he lehq Yar koq i hehd teq pa haq sir ve lehq bon ca laweg tug kehaq lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yawd bon lawg chehd-ag huh, yawd ved mehz khuhd awg hoq awg han pa lehq, Yawd ved veq kad liz, phux u ghad he lehq awg ghiz lawd lawd te tuhaz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Awg yand u ve khuhn, Mod ser he lehq Ed lid yaq ix maq tuhaz lehq, Yer suq haq tawd yaw daq chehd lawz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ix mag awg mig awg phond cawg che khuhn tuhaz lehq tawd yaw daq che awg lehr Yer ruq sar lehnr med khuhn, awg cehg mag Ghig sa awg khad te lar che heh phehaq tug Yer suq gha khanr suh che awg lawn u ve haq koz daq chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Per troq he lehq yawd ved awg chawd ix mag yuhq mir geq lehq yuhq mir jo chehd che yaog. Kheh ma khuhd, i hehd kha nehax kawq nuhd-ag lehq, Yer suq ve awg mig awg phond he lehq yawd geh hox chehd che chaw ni ghad haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chaw u ve ni ghad Yer suq haq phaz daq vehar lehd te chehd-ag huh, Per troq yawd haq koz vid che, “Jawd mawd-og, a nig chuhr huh chehd liz daq che yaog. Ngag hehd hax po seh lehd teag. Nawg awg pun ted mag, Mod ser awg pun ted mag he lehq Ed lid yaq awg pun ted mag te tug yaog,” lehz ma nuhd maq theh phehq vehr che khuhn koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yawd tawd u ve yaw chehd-ag huh, mog dig lag lehq i hehd haq hoz beh vehr che yaog. U kheh te lehq Per troq he lehq yawd ved awg chawd ix mag kuhz jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mog u ve khuhn awg khuhd buhg tuhaz lehq koz che, “Chaw che ve phad awr lehr, ngag lez yug lar che ngag ved Yad phu yaog. Yawd ved tawd khuhd haq na yuor,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Awg khuhd u ve buhg tuhaz peg lehq, Yer suq yawd te ghad lehax chehd lawz cheaq i hehd gha mawg che yaog. I hehd teq pa gha mawg gha sir che awg lawn u ve teq pa, awg yand u ve khuhn i hehd ve ni ma khuhn taq hiax teh lar lehq, su te ghad-eg haq liz ma koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Awg khaz nuhr teq ni gaeg lehq, Yer suq he lehq awg laq ghuhd seh ghad u ve teq pa kehaq lo phoz yaq che te yand, chaw mor nux yawd haq ca mawg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chaw awg mor nux u ve khuhn chehd che chaw te ghad phad kug lehq koz che, “Sar lar-og, ngag ved yad par haq a cehax ngawax laoq, ngag lawg khawx che yaog. Awg lawn ghod ver, ngag yad par te ghad lehax cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ned yawd khuhn geh kheh che yaog. Yawd ned geh che te yand, huh kug lar haz lehq kuhd veh ver, phez dawz lar lehq, mawq kaw khuhn sux ghig phoz buhd buhd te che yaog. Nag jad tug te vid lar haz lehq a cehax liz ma tuhez gad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ned u ve haq ghaq tuhz vid tug, nawg ved awg laq ghuhd teq pa geh ngag lawg khawx jaw che yaog. Kheh liz, i hehd te maq gha,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yer suq kawq koz che, “Yonr che mad cawg lehq yaw har jad che a meha teq co ve chaw-og, nig hehd teq pa geh ngag khawd-ehg muh maq awr gha yeg khanr chehd ser lawg le. Nawg yad chuhr huh sir vea laor,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Yad par nehax u ve lag tod-ag huh, ned u ve yawd haq miaq lo biz kuhd pe lehq phez dawz vid che yaog. Yer suq awr lehr, ned chaq chiz u ve haq ghaq tuhz lehq chaw yad nehax u ve haq ghu na vid peg lehq, awr pa haq kawq khuhq pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kheh te lehq, chaw awg gha lia Ghig sa ve ir jad muh jad che kand pax haq gha mawg lehq and jad che yaog. Yawd te che kanx teq pa haq su phoz and chehd-ag huh, Yer suq yawd awg laq ghuhd teq pa haq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Tawd khuhd che teq pa haq kha nehax na lehq tawnd laor. Awg lawn ghod ver, chaw yad ve Yad phu awr lehr, cand par teq pa ve laq khuhn chid aq vid tug awg yand gag vehr tez che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kheh liz yawd koz chehd che tawd khuhd u ve haq i hehd na maq gha. I hehd na maq gha vid tug te lar che yaog. Kheh te lar awg lawn u ve haq te ghad-eg liz kawq na ngawx maq pir. ");
INSERT INTO lhi_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Awg laq ghuhd teq pa i hehd khad nawad i hehd ve awg mor khuhn, a sug vawr suaq keh ir cheawg le ghod lehq, tawd ghawg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yer suq awr lehr, i hehd teq pa ve ni ma khuhn a thoq duhd chehd che haq sir lehq, chaw yad nehax te ghad sir vea lehq yawd pad huh hox vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kheh te lehq, i hehd teq pa haq koz vid che, “Chaw yad nehax haq ngag ved awg meh khuhn haq yug che chaw te ghad awr lehr, a sug lehd ma koz, ngag haq haq yug che yaog. Ngag haq haq yug che chaw awr lehr, ngag haq lag pea che phad haq liz haq yug che yaog. Awg lawn ghod ver, nig hehd awg khuhn suaq keh i che chaw awr lehr, suaq keh ir che te ghad gha te tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yod hanr Yer suq haq koz vid che, “Jawd mawd-og, chaw te ghad nawg ved awg meh haq uhx lehq ned ghaq kog cheaq ngag hehd gha mawg lehq tawr kha lar haz. Awg lawn ghod ver, yawd a nig geh lag che ma hez lehq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yer suq Yod hanr haq koz vid che, “Yawd haq taq tawr kha. Awg lawn ghod ver, nig hehd haq maq tawr daq che teq pa awr lehr, su nig hehd pax awr chehd che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yer suq yawd muhd nuh kawag lo kawq taz koeq tug awg yand gag vehr tez lehq, Yer ruq sar lehnr med lo kae tug haq yawd duhd chez gad chez lar lehq kae tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Yawd-aq keh awg kawd yawd awg tan teq pa haq Sar mar riq khaz te khaz lo kae lehq, yawd lag tug awg khad ca te pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kheh liz yawd Yer ruq sar lehnr med lo veh tod cheaq te lehq, chaw u ve teq pa yawd haq mad haq yug vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yawd ved awg laq ghuhd Yar koq he lehq Yod hanr ix mag awg ceng u ve haq gha mawg che te yand koz che, “Jawd mawd-og, muhd nuh kawag lo ve a mir cheag vid lehq, chaw che teq pa haq saw toq kha vid che awr cawd gha hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Kheh liz Yer suq kuhr phuhz ngawx lehq ix mag haq ded kha lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","U kheh te lar haz lehq, i hehd teq pa awg nuz awr ve te khaz lo kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","I hehd teq pa kae tod-ag huh yaq kaw kanr chaw te ghad phad lag lehq, Yer suq haq koz vid che, “Nawg khar lo kae lehd ma koz, ngag liz nawg khaz nuhr ghaq kae tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yer suq yawd haq koz vid che, “Heh phid awr lehr, awg kor cawg che yaog. Ngaz teq pa liz, awg phi cawg hawg. Kheh ma khuhd chaw yad ve Yad phu awr lehr, yuhq kig liz mad cawg hawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yer suq chaw te ghad haq kawq koz vid che, “Ngag khaz nuhr ghaq laoq,” lehd koz vid che yaog. Chaw u ve phad kawq koz che, “Jawd mawd-og, ngag a cehax lawg lehq ngar pa haq ca tur vid lar haez sar,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yer suq kawq koz che, “Chaw suh teq pa awr lehr, i hehd khad nawad tur daq vid-oq. Kheh te lehq, nawg vawr kae lehq Ghig sa ve muhd mig awg lawn ca mar vid-eq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Te ghad Yer suq haq koz vid che, “Jawd mawd-og, ngag nawg khaz nuhr ghaq kae tug yaog. Kheh liz, ngag yehg lo koeq lehq yehg khuhn chehd che teq pa haq a cehax ca kawq koz vid lar haez sar,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yer suq yawd haq koz vid che, “Thehx khen haq yug cid lar lehq kuhr tehx nuhr phuhz ngawx chehd che chaw teq pa awr lehr, Ghig sa ve muhd mig haq maq kenr hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","U kheh te lar haz Yer suq awr lehr, awg nuz awr ve awg laq ghuhd suhr chi ghad haq kawq lez yug lehq, yawd kae tug med he lehq khaz teq pa lo ted kag ve ni ghad ni ghad te lehq yawd ghud med awr kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yawd awg laq ghuhd teq pa haq koz vid che, “A cag ghiq tug kha peh vad-ag cawg liz, a cag ghiq par a cehax lehax cawg che yaog. Kheh te lehq, yawd ved a cag ghiq kig lo a cag ghiq par ca pea vid tug awg sehr phad geh bon lawg-or. ");
INSERT INTO lhi_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nig hehd teq pa kae lor. Ngag nig hehd haq kae pea cheawg lehr, yawg nehax heh phid mor khuhn ca chehd pe vid che heh yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Phu kaw pi, laq sax he lehq khi noz teq pa ta puhd ve kae. Kheh te lehq, yaq kaw kanr su haq mawg daq ver tawd ta kaod yaw daq chehd. ");
INSERT INTO lhi_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yehg khar ve khuhn gehe liz, ‘Yehg che ve haq Ghig sa ve bon duhd sa ha lehg che cawg vid,’ lehd koz lehq bon awg kawd naq vid ser. ");
INSERT INTO lhi_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Yehg u ve khuhn ha lehg duhd sa che chaw cawg chehd vehr ver, nawg naq vid che awg bon u ve i hehd geh cawg vehr che yaog. Kheh ma khuhd, mad cawg chehd lawz ver, awg bon u ve nawg geh kawq kawaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yehg khar ve khuhn gha hax vehr liz, u ve khuhn lehax chehd lar, jiz taz jiz yaq ta kaod te. Su a thoq yug vea car tawa liz u ve haq cad-oq. Awg lawn ghod ver, kanx te par awr lehr, ghad phuhd gha cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Med khar ve ted kag khuhn gehe lehd ma koz, su nig hehd haq haq yug ax lehq, nig hehd mehz khuhd suhr huh cad tug a thoq hanr teha liz u ve haq cad-oq. ");
INSERT INTO lhi_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kheh te lehq, u huh nag guhg chehd che chaw teq pa haq ghu na vid lehq i hehd haq ‘Ghig sa ve muhd mig nig hehd teq pa awg pad huh lag gag vehor,’ lehd koz mar vid-oq. ");
INSERT INTO lhi_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kheh te lar lehq, med khar ve ted kag khuhn lehd ma koz, nig hehd kae lehq nig hehd haq mad haq yug ax ver, nig hehd tuhez lehq yaq kaw lo hox lar lehq i hehd haq che kheh koz vid. ");
INSERT INTO lhi_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nig hehd ve med khuhn cawg che jeq mia teq pa ngag hehd ve khi ho haq hehr chehd che haq liz nig hehd yaq kig haq sir vid tug awg pun, ngag hehd siz kha lar haz che yaog. Kheh ma khuhd, nig hehd sir lar cawd che Ghig sa ve muhd mig nig hehd teq pa awg pad ned vehr che haq nig hehd sior,’ lehz i hehd haq koz vid-oq. ");
INSERT INTO lhi_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ngag nig hehd haq koz ax laq, Ghig sa suhx jehg che awg ni gaeg ver, med u ve awr lehr, haeg jad che Sawd donr med-aq keh liz gha khanr jad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Khawd rar senr chaw-og, nawg gha lug gha sez tug yaog. Ber sehd daq chaw-og, nawg liz gha lug gha sez tug yaog. Awg lawn ghod ver, nig hehd awg khuhn te peg che and tug awg ceng teq pa awr lehr, Tud ruq med he lehq Sid donr med khuhn te che heh ver, i hehd awr lehr, a sawehd lo liz chi kud thux pu pha haq veq lar lehq khuhq ha khuhn tehd mi lar lehq paz huhg kehd huhg lehq vend bax duhd phuhz vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Suhx jehg che awg ni gaeg ver, nig hehd awr lehr Bid saz a naz chaw Tud ruq med he lehq Bid saz a naz chaw Sid donr med haq keh liz gha khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kar per nar unr chaw-og, nawg haq muhd nuh kawag lo kha gag chid taz ax lawg lehd duhd lehq la. Ma hez hawg, nawg awr lehr, suh muhd mig lo kha gag gha yug yaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nig hehd ve tawd khuhd haq na yug che chaw teq pa awr lehr, ngag ved tawd khuhd haq na yug che chaw yaog. Nig hehd haq chid bag che chaw awr lehr, ngag haq liz chid bag che yaog. Ngag haq chid bag che chaw awr lehr, ngag haq lag pea che phad haq liz chid bag che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Awg laq ghuhd u ve suhr chi ghad ha lehg ha ka che khuhn kawaq lehq koz che, “Jawd mawd-og, nawg ved awg meh haq uhx ver, ned teq pa haq liz ngag hehd ghad che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yer suq i hehd teq pa haq koz vid che, “Sar tanr muhd pehq heh te lehq muhd-aq lo cheag che haq ngag gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nig hehd haeg che vig he lehq awg tuhq ma cawg che cir kox noz teq pa haq naz kix lar gha tug he lehq Sar tanr ve kand pax awg gha lia haq ghad tug, ngag nig hehd haq kand pax pehar lar che yaog. A thoq ted ceng lehd ma koz, nig hehd haq nag tug te maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kheh ma khuhd, ned teq pa haq nig hehd ghad cheaq te lehq taq ha lehg. Muhd nuh kawag lo nig hehd ve awg meh buhq ke lar che haq ha lehg chehd-oq,” lehz yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Awg yand u ve khuhn Yer suq awr lehr, Daq che kehg che Awg ha phu awg khuhn ha lehg lehq koz che, “Muhd nuh maq he lehq mig gig haq uq penr sehr phad A pa-og, awg lawn che ve teq pa haq cud yiq cawg lehq sir vix che chaw teq pa maq gha sir vid tug nawg khuhd ceh lar lehq, chaw yad nehax heh te che teq pa haq nawg pheq mar ax cheaq te lehq, ngag nawg haq chid muh che yaog. A pa-og, che kheh te tug nawg ni ma cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ngar pa awr lehr, awg ceng gha lia ngag haq chid aq ax lar peor. Awr pa ma hez ver, Yad phu a sug lehq nar ghod che haq su te ghad-eg liz maq sir. Yad phu ma hez ver Yad phu pheq mar vid cuh gad che chaw ma hez ver, Awr pa a sug lehq nar ghod che haq su te ghad-eg liz maq sir hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kheh te lehq, yawd kuhr tehx nuhr phuhz ngawx lar lehq, awg laq ghuhd teq pa haq lehax koz vid che, “Awg ceng che ve teq pa haq nig hehd gha mawg cheawg lehr, awg bon ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Awg lawn ghod ver, ngag nig hehd haq koz ax laq, nig hehd teq pa gha mawg chehd che awg ceng che ve teq pa haq Ghig sa ve cuh kar var laex ghad he lehq jawd mawd teq pa laex ghad mawg gad liz maq gha mawg. Nig hehd gha kad che awg ceng che ve teq pa haq i hehd teq pa kad gad liz maq gha kad,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kheh te lehq, awg lid tawd khuhd sir var te ghad yawd haq lawd ngawx tug tuag lehq koz che, “Sar lar-og, ngag co tiq ha tiq gha tug khawd-ehg kheh gha te lawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yer suq yawd haq koz vid che, “Awg lid tawd khuhd khuhn khawd-ehg kheh koz buhq lar law le. Nawg ghawn ngawx che khawd-ehg kheh te gha siar le,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Yawd kawq koz che, “Nawg ved ni ma kha peg, nawg ved co ha kha peg, nawg ved awg ghad awg sax kha peg he lehq nawg ved duhd khad kha peg nawg ved Jawd mawd Ghig sa haq gha haq che yaog. Nawg awg ton haq haq che heh, nawg pad huh chehd che haq gha haq che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yer suq kawq koz che, “Nawg yaw khuhq ax che awr lehr, cawd vehr che yaog. Nawg u kheh ca te lor. U kheh te ver, nawg co ha gha teq tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kheh ma khuhd chaw u ve awr lehr, yawd ved mehz khuhd ma gha lug vid tug, “Ngag pad huh chehd che chaw a suawg le,” lehz Yer suq haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yer suq kawq koz che, “Yud daq chaw te ghad Yer ruq sar lehnr med lo tu lehq Yer riq khod med lo yaeq tod-ag huh, su chaw khuhd te lehq yawd ved veq kad teq pa saw kuhz saw lu yug peg lehq, ghawg phuhz dawz lehq a lag lag suh te teh lar haz lehq phaw veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Awg yand u ve khuhn, Ghig sa ve paw khod te ghad yaq kaw u ve te caz haq kae cawd lehq chaw u ve phad haq gha mawg che te yand, yaq kaw jad lo jaw veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","U ve heh te lehq, Ler viq chaw te ghad liz u huh lag gag lehq chaw u ve phad haq gha mawg lehq, yaq kaw jad lo jaw veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kheh ma khuhd, Sar mar riq chaw te ghad chaw u ve phad chehd che yaq kaw u ve haq lag lehq gha mawg che te yand, yawd haq har kax jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yawd chehd huh har naq kae lehq, yawd ved nag kig awg khuh teq pa haq nag mand he lehq a pehx med ghig juhd ke lehq hoz thiz vid che yaog. U kheh te vid peg lehq yawd ved pix lar nehax thang chid taz vid ve lehq, chaw hax kig yehg ted yehg lo yug ve kae lehq yawd haq ngawx haq sax vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Sawx awr teq ni kheha gaeg lehq, yawd phu nid thehq yug tuhz lehq yehg sehr phad haq pid lehq koz vid che, ‘Chaw cheaq kha nehax ngawx haq sax vid-oq. Cheaq keh kawq peg cawd ver, ngag kawaq ver nawg haq ngag kawq khuhq sehr ax lawg,’ lehd koz vid lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kheh te cheaq te lehq, nawg duhd che chaw che seh ghad awg khuhn khar ve te ghad awr law le. Su chaw khuhd te vid che phad pad huh chehd che haq sur che,” lehd koz Yer suq yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yawd kawq koz che, “Yawd haq har kax vid che te ghad yaog,” lehd koz yaw khuhq vid lehq Yer suq koz che, “Nawg liz u kheh ca te lor,” lehz yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yer suq he lehq awg laq ghuhd teq pa Yer ruq sar lehnr med lo kae tod-ag huh, yaq kaw kanr khaz te khaz khuhn gehe lehq, Mar thaq meh che yad mid te ghad yawd ved yehg khuhn i hehd haq haq yug vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mar thaq awr lehr, awg nax ma Mar riq meh che te ghad cawg che yaog. Mar riq awr lehr, Jawd mawd Yer suq ve khi pad huh mi lar lehq yawd mar che tawd khuhd haq na chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kheh te lar Mar thaq vawr, te car te taw che kanx mad jad lehq ni ma soq saq che yaog. Yawd Yer suq chehd lo kae lehq koz vid che, “Jawd mawd-og, ngag nax ma che ve te car te taw tug kanx ngag haq lehax teha lar che nawg teq chaweh ma duhd lehq la. Ngag geh kanx ga tea tug yawd haq a cehax koz vid ser,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jawd mawd Yer suq kawq koz che, “Mar thaq-og, Mar thaq-og, nawg awr lehr laex ceng haq duhd har duhd khix chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kheh te lar, lor jad che ted ceag lehax cawg che yaog. Mar riq awr lehr, daq che ted ceng haq lez yug vehor. U ve ted ceng su te ghad-eg liz, lu yug hinx yug maq gha hawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Te pawz thad huh, Yer suq ted kag lo bon lawg chehd che yaog. Yawd bon lawg peg lehq, yawd ved awg laq ghuhd te ghad koz che, “Jawd mawd-og, Yod hanr yawd ved awg laq ghuhd teq pa haq bon lawg mar vid che heh te lehq ngag hehd haq liz bon lawg mar laoq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Kheh te lehq yawd koz che, “Nig hehd bon lawg thad ver, che kheh koz lawg-o. Awr pa-og, nawg ved awg meh haq yawz yawz yan yan te vid-oq. Nawg ved muhd mig gag vid-oq. ");
INSERT INTO lhi_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ngag hehd lor che cad tug dawg tug teq pa, ni gha lia ngag hehd haq pehar laoq. ");
INSERT INTO lhi_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ngag hehd ve vend bax haq liz phehd kha laoq. Awg lawn ghod ver, ngag hehd haq kha te yaq ax lar che chaw teq pa ve vend bax haq liz ngag hehd phehd kha vid che yaog. Vend bax ber che awg khad khuhn ngag hehd haq taq kae cuha laoq,” lehz i hehd haq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kheh te lehq yawd kawq koz che, “Tawd par hax te ver, nawg awg chawd te ghad muhd khax te khend lo nawg yehg lo lag lehq, nawg yawd haq teq chaweh yug car vid tug mad cawg te lehq, awg chawd te ghad chehd lo kae lehq awg chawd haq koz vid che, ‘Ngag haq khaor mod sehz dig a cehax chiad lar ser. ");
INSERT INTO lhi_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Awg lawn ghod ver, ngag ved awg chawd te ghad ca gid-ag lehq, yawd haq teq chaweh yug car vid tug mad cawg,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yehg khuhn chehd che awg chawd te ghad kug lehq koz che, ‘Ngag haq tad soq saq lor. Ghaz mir liz khawnr vehr cheawg. Ngag yad phoz sir lehq yuhq phi khuhn yuhq chehd vehr lehq nawg haq tu yug ax tug te maq gha,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ngag nig hehd teq pa haq koz ax laq, yawd awr lehr, yawd awg chawd daq cheawg lehd duhd che khuhn maq tu yug vid liz, chaw u ve hax ceh kaod lawg don chehd cheaq te lehq, yawd tuag lehq awg chawd u ve kha lor che yawd pid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Te pawz ngag nig hehd haq koz ax laq, lawg lor. Lawg ver gha tug yaog. Ca lor. Ca ver mawg tug yaog. Ghaz mir haq thuhz lor. Thuhz ver nig hehd haq phawa tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Awg lawn ghod ver, lawg che chaw awg gha lia gha tug yaog. Ca che chaw liz mawg tug yaog. Ghaz mir haq thuhz che chaw teq pa haq liz, ghaz mir phaw vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Nig hehd teq pa awg khuhn a sug te ghad cawg hawg le. A pa te che yad ngad lawg ver, ngad awg tan vig yug pid tuawg la. ");
INSERT INTO lhi_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma hez ver, ghaz ghu lawg ver, cir kox noz yug vid tuawg la. ");
INSERT INTO lhi_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kheh te lehq, nig hehd chaw haeg phehq liz, nig hehd ve yad teq pa haq med nged daq maq pid khuhd nuhd chehd ver, u veaq keh lex lehq muhd nuh kawag lo chehd che nig hehd ve Awr pa Ghig sa geh kha lawg che chaw teq pa haq Daq kehg che Awg ha phu yawd pid tug ma hez hawg la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Te pawz thad huh, kar che ned teq kheh haq Yer suq ghaq kog lehq, ned tuhz veh peg khaz nuhr, chaw kar u ve tawd yaw gha vehr lehq su and jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kheh te lehq te pehg koz daq che, “Yawd awr lehr, ned haeg Sar tanr ve kand pax haq cud lehq ned teq pa haq ghaq kog che yaog,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Chaw ted pehg yawd haq te ngawx gad che khuhn, Yer suq geh muhd nuh kawag lo ve and tug awg hez lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kheh te lehq, Yer suq i hehd ve ni ma khuhn duhd chehd che haq sir lehq koz che, “Muhd mig khar ve te pez lehd ma koz, ma cawd maq hawr daq vix ver gha lug tug yaog. Yehg ka khar ve ted mag lehd ma koz, ma cawd maq hawr daq vix ver gha phaz daq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ngag awr lehr, Ber sar bud laq haq cud lehq ned teq pa haq ghaq kog che yaog lehz nig hehd koz che yaog. Kheh ma khuhd, Sar tanr i hehd teq pa ma cawd maq hawr daq ver, i hehd ve muhd mig khawd-ehg te yeg chehd gha hawg le. ");
INSERT INTO lhi_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ngag Ber sar bud laq haq cud lehq ned ghaq kog che law ghod ver, nig hehd chaw teq pa awr lehr, a sug haq cud lehq ghaq kog lar cheawg le. Kheh te cheaq te lehq, nig hehd ve chaw nig hehd khad nawag haq suhx jehg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kheh te lar, ngag Ghig sa ve kand pax haq cud lehq ned haq ghaq tuhz lar che ver, Ghig sa ve muhd mig nig hehd geh gag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Awg ghad hehnd jad che chaw te ghad laq khen laq cax yug lehq yawd yehg haq paog chehd ver, yawd ved med nged haq su te ghad-eg mad lag kaod hawg. ");
INSERT INTO lhi_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kheh ma khuhd, yawd-aq keh awg ghad hehnd jad che chaw te ghad lag lehq, yawd haq hez daq lehq ghad ver, yawd yehd chehd che laq cax teq pa haq lu yug ve peg nuhr, yawd ved med nged teq pa haq liz yug lehq pehg daq vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ngag phawd awr ma chehd che chaw awr lehr, ngag ved cand par yaog. Ngag geh yawg awg mor maq ga saw phoz ax che chaw teq pa awr lehr, yawg awg mor te phaz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ned chaq chiz teq kheh awr lehr, chaw te ghad khuhn tuhez lehq, muhd-aq miaq awg god khehz teag huh ghad jehd kig ca kaod ngawx tod che yaog. Yawd ca mad mawg che te yand, ‘Ngag tuhaz che ngag ved yehg lo kaw koeq sar,’ lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yawd kawq gag che te yand, yehg u ve kehr ghad kha nehax te siz lar lawz cheaq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kheh te lehq, yawd-aq keh haeg jad che ned suhr kheh haq ca kawq sir vea lehq, yehg u ve khuhn chehd che yaog. Kheh te cheaq te lehq, chaw u ve te ghad awr lehr, awg khaz nuhr te tuhaz che awg ceng teq pa, awg kawd thad veaq keh liz kawq haeg jad vehr che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yawd u kheh koz chehd-ag huh, chaw mor nux khuhn chehd che yad mid te ghad kug lehq koz che, “Nawg haq hu che ux peg he lehq nawg haq gha nux vid che cux pehz awr lehr, awg bon ir che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yer suq kawq koz che, “Yaog. Kheh te lar, awg cehg mag awg bon ir che chaw teq pa awr lehr, Ghig sa ve tawd khuhd haq na yug lehq ghaq te che chaw teq pa yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Chaw awg mor nux phoz lag lehq ghaq te ghaq mad te lehq yawd koz che, “Chaw a meha teq co ve awr lehr, haeg che chaw teq pa yaog. I hehd teq pa and tug awg hez haq lehax lawg chehd che yaog. Kheh ma khuhd, Yod naq ve awg hez ma hez ver, awg nuz awr ve awg hez teq chaweh haq liz maq mar vid. ");
INSERT INTO lhi_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yod naq awr lehr, Nid nar ver med yad teq pa ve and tug awg hez heh te lehq, chaw yad ve Yad phu liz chaw a meha teq co ve and tug awg hez te tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Awg lawn ghod ver, awg huhx muhd mig ve jawd mawd ma awr lehr, Sawd laq monr ve cud yiq tawd khuhd haq na tug, mig gig leh med lo tu lehq lag che yaog. Kheh te cheaq te lehq, Ghig sa suhx taz che awg niaq ver, awg huhx muhd mig ve jawd mawd ma awr lehr, tu lehq a meha teq co ve chaw haq vend bax tar tug yaog. Ngawx lor, chuhr huh Sawd laq monr haq keh ir che te ghad chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ghig sa suhx taz che awg ni haq gaeg ver, Nid nar ver med yad teq pa liz tuag lehq, a meha teq co ve chaw haq vend bax tar tug yaog. Awg lawn ghod ver, Yod naq bon mar che haq te lehq, Nid nar ver med yad teq pa a sug yawd ved vend bax haq duhd phuhz che yaog. Ngawx lor, chuhr huh Yod naq haq keh ir che te ghad chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A mir khehd tox lehq mad mawg kig lo tar che ma koz, khuhr luhd cuhr muhq lar che ma koz, chaw te ghad-eg liz maq te hawg. Chaw kha lag che awg gha lia awg ghiz haq gha mawg vid tug, a mir khehd tox lehq a mir khehd tar kig lo tar lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nawg ved mehz sir awr lehr, awg ton ve a mir khehd heh yaog. Nawg ved mehz sir daq ver, nawg ved awg ton awg ghiz kha nehax cawg tug yaog. Nawg ved mehz sir mad daq ver, nawg ved awg ton awg naz tud awg naz hoq saw phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kheh te cheaq te lehq, nawg awg ton khuhn cawg che awg ghiz u ve awg naz tud awg naz hoq maq gha phehq vehr vid tug sa tiq teo. ");
INSERT INTO lhi_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nawg awg ton khuhn ted kaer liz naz hoq che mad cawg lehq, teq ton maq ve awg ghiz kha nehax cawg hawg ghod ver, a mir khehd awg ghiz nawg haq thiag che heh te lehq, nawg awg ton awr lehr, awg ghiz pawd-aw ghad cawg tug yaog,” lehz yawd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yer suq u kheh koz chehd-ag huh, Phar rir sehd te ghad yawd geh awr cad-eg tug Yer suq haq kug che yaog. Kheh te yawd kae lehq, teh cuh pad huh mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Awr ma cad ser huh, yawd awg lid cawg che heh laq kuhr ma chuhd che haq Phar rir sehd u ve gha mawg lehq and che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jawd mawd Yer suq yawd haq koz vid che, “Nig hehd Phar rir sehd teq pa awr lehr, a khehd he lehq kawz khehd chuhd ver, awg thang phawd awr lehax chuhd che yaog. Kheh te lar, nig hehd awg khuhn phawd awr ver, haeg che ted ceng he lehq lawd phaq ir che kha peh vad-ag cawg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Chaw kar chaw thaw teq paog, awg thang phawd awr te par Ghig sa u ve, awg khuhn phawd awr liz te lar che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kheh te cheaq te lehq, nawg cawg lar che med nged u ve teq pa chaw har yad teq pa haq pid-oq. U kheh te ver, nig hehd awg khuhn cawg che awg ceng gha lia daq kehg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Phar rir sehd teq paog, nig hehd gha lug gha sez tug yaog. Awg lawn ghod ver, a sur, i khend he lehq ghawd phaq muhq nuha teq pa nig hehd teq chi pun teq pun kha nehax te che yaog. Kheh te lar, Ghig sa ve haq che pehnd che he lehq chaw yad haq thed che khuhn suhx mad jehg che yaog. Che teq pa haq liz nig hehd te lehq awg kag awg nuz awr ve awg ceng teq pa haq liz nig hehd te cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Phar rir sehd teq paog, nig hehd gha lug gha sez tug yaog. Awg lawn ghod ver bon lawg kig huh awg mig awg phond cawg che mi kig haq ma koz, kax khuhn lo nig hehd haq yawz yan ax vid tug haq ma koz nig hehd he gad jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Nig hehd gha lug gha sez tug yaog. Awg lawn ghod ver, nig hehd awr lehr, teq chaweh awg hez maq te lar che chaw tur phuh haq sur lehq, su maq sir che khuhn te tod chehd che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Awg lid tawd khuhd sir var te ghad yawd haq kawq koz vid che, “Sar lar-og, nawg ix kheh koz cheawg lehr, ngag hehd haq liz nawg maq sawnr ma caz koz che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yer suq kawq koz che, “Nig hehd awg lid tawd khuhd sir var teq pa liz gha lug gha sez tug yaog. Awg lawn ghod ver, Nig hehd awr lehr, puhd har jad che med nged teq pa heh te che su haq puhr vid che yaog. Nig hehd teq pa vawr, a cehax liz maq ga puhd vid lehq a sug yawd ved laq nuh mead liz med nged u ve haq mad duhq. ");
INSERT INTO lhi_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nig hehd gha lug gha sez tug yaog. Awg lawn god ver, nig hehd awr lehr, nig hehd ve awg pux awr pi teq pa dawz vehr lar che Ghig sa ve cuh kar var teq pa ve tur phuh teq pa haq kawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kheh te lehq, nig hehd ve awr pux awr pi teq pa te che kanx haq nig hehd sax khiz khanr lehq ni ma cawd che yaog. Awg lawn ghod ver, i hehd vawr Ghig sa ve cuh kar var teq pa haq dawz vehr lehq, nig hehd vawr tur phuh u ve teq pa haq kawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kheh te cheaq te lehq, Ghig sa cud yiq ma yiq cawg che che kheh koz lar che yaog. ‘Ngag awr lehr, i hehd teq pa chehd lo ngag ved cuh kar var he lehq cuh yad teq pa kae pe tug yaog. Ted pehg i hehd dawz vehr lehq ted pehg haq awr lehr du deh vid tug yaog.’ ");
INSERT INTO lhi_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kheh te cheaq te lehq, Ghig sa mig gig haq tanr phanr thad loar ve cuh kar var teq pa haq dawz vehr lehq awg suhr sez lar che toq u ve a meha teq co ve chaw haq gag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","U ve awr lehr, Ar ber laq ve awg suhr haq tanr lehq, tox tand kig he lehq daq kehg che Ghig sa ve chehd kig Yer ruq sar lehnr bon yehg nux awg kanr huh dawz vehr lar che Yar khar riq ve awg suhr u ve a meha teq coaq ve chaw awg cehg mag gha khanr puhd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Awg lid tawd khuhd sir var teq paog, nig hehd awr lehr, gha lug gha sez tug yaog. Awg lawn ghod ver, cud yiq ma yiq haq phaw tug sawnd nig hehd yug cid lar lehq, nig hehd a sug yawd awg ton liz maq gehe he lar lehq, su gehe gad che chaw teq pa haq liz nig hehd law tawr lar che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yer suq u huh tuhz veh che te yand, liq buhq var he lehq Phar rir sehd teq pa awr lehr, yawd haq chaq nag che khuhn koz gid lehq ");
INSERT INTO lhi_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yer suq tawd yaw yaq che haq ca gha vid tug, yawd haq tawd hax ceh na lehq laex ceng yaw cuh vid lar lehq jaz na jaz ngawx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Awg yand u ve khuhn, chaw awg hinx awg mir ghad phoz lag lehq biz daq caq daq te chehd-ag huh, Yer suq yawd ved awg laq ghuhd teq pa haq koz vid che, “Phar rir sehd teq pa ve did haq sa tiq tar. Did ghod che u ve awr lehr, pha yax te che haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kha hoz tehr lar che awg ceng awg gha lia mad pheq tuhaz tug awg ceng teq chaweh mad cawg hawg. Kha khuhd ceh lar che awg ceng liz maq sir tug teq chaweh mad cawg hawg. ");
INSERT INTO lhi_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kheh te lehq, awg naz tud teag lo nig hehd khuhd koz daq che awg ceng liz muhd kaw awg ghiz cawg kig lo su gha kad tug yaog. Nig hehd ve bawehd awg khuhn nar puh pad-ag khuhd sad daq lar che liz yehg thag lo koz tuhaz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ngag ved awg chawd teq paog, ngag nig hehd haq koz ax laq, awg ton haq lehax dawz vehr gha che chaw yad haq ta kuhz. U ve nuz awr, yawd nawg haq teq chaweh kawq te maq gha vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kheh ma khuhd, nig hehd a sug haq gha kuhz cawd che ngag koz ax laq. Awg ton haq liz dawz vehr peg nuhr, muhd naz hoq khuhn liz kawq yug chid bag ke gha che kand pax ir jad che Ghig sa u ve haq nig hehd kuhz-oq. Ngag nig hehd haq awg cehg mag koz ax laq, yawd haq kuhz-oq. ");
INSERT INTO lhi_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Jar mead ngad kheh veaq nid pehq lehax huhd che ma hez hawg la. Jar mead u ve teq pa teq kheh haq liz Ghig sa yawd ma lend lar haz. ");
INSERT INTO lhi_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nig hehd ve cuhz kheh muh awg gha lia haq liz yawd saw ghawn ngawx lar peor. Nig hehd awr lehr, Jar mead u ve teq pa laex khehaq keh awg phuhd khaz jad che yaog. Kheh te cheaq te lehq, ta kuhz. ");
INSERT INTO lhi_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Ngag nig hehd haq koz ax laq, a sug lehd ma koz, chaw yad mehz khuhd suhr ngag haq khanr yug che chaw teq pa awr lehr, Ghig sa ve muhd nuh maq cuh yad teq pa ve mehz khuhd suhr chaw yad ve Yad phu liz yawd haq khanr yug tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Chaw yad mehz khuhd suhr ngag haq chid bag che chaw awr lehr, Ghig sa ve muhd nuh maq cuh yad mehz khuhd suhr chaw yad ve Yad phu liz yawd haq chid bag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Chaw yad ve Yad phu haq kha koz yaq che chaw khar ve te ghad lehd ma koz, yawd vend bax phehd vid tug yaog. Kheh te lar, Daq kehg che Awg ha phu haq maq sawnr ma caz koz che chaw teq pa ve vend bax haq ma phehd vid hawg. ");
INSERT INTO lhi_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Su nig hehd haq bon lawg kig khuhn ma koz, jawd mawd teq pa he lehq kand pax cawg che chaw teq pa mehz khuhd suhr ma koz, yug ve kae ax ver, nig hehd khawd-ehg kheh gha koz khuhq vid tug ta duhd har. ");
INSERT INTO lhi_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Awg lawn ghod ver, awg yand u ve awg khuhn nig hehd khawd-ehg kheh gha koz gha te tug, Daq kehg che Awg ha phu nig hehd haq koz mar ax tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chaw awg mor nux u ve khuhn chehd che te ghad Yer suq haq koz vid che, “Sar lar-og, ngag haq ngar pa ve awg sinx pehg ax tug nawg ngag vix var haq a cehax kud viad,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Kheh ma khuhd Yer suq kawq koz che, “Yad par-og, nig mag kanr huh suhx taz lehq awg sinx pehg ax tug a sug ngag haq teha lar cheawg le,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yawd i hehd teq pa haq kawq koz vid che, “Sa tiq te, su ved med nged jeg kor haq sex lae che ni ma tad cawg vid. Awg lawn ghod ver, med nged jeg kor cawg mad cheaq te lehq, chaw yad a saq gha teq che ma hez hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kheh te lehq, yawd i hehd haq tawd par hax te mar vid lehq koz che, “Paw sa che chaw te ghad yawd ved ti mi he lehq ha mig gig awg ti daq jad lehq, awg sir awg no gha mad jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Paw sa var u ve phad yawd ved ni ma khuhn duhd che, ‘Ngag khawd-ehg kheh te cawd lehq nar. Awg sir awg no kheh ma ma ve tar kig liz mad kawq cawg.’ ");
INSERT INTO lhi_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kheh te lehq yawd duhd che, ‘Ngag cag yehg che teq pa phaz kha lehq cag yehg cheaq keh ir che teq pa awg suhx kawq te sar. Kheh te lehq, cag yehg u ve teq pa khuhn med nged he lehq awg sir awg no awg gha lia ke teh lar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kheh te lehq, ngag ved ni ma haq che kheh koz vid tug yaog. “Ngag cad tug dawg tug he lehq med nged jeg kor daq maq kha peh vad-ag laex khuhq awg pun ghawz phoz lar peor. Kheh te cheaq te lehq, ghad jehd lar cad chehd dawg chehd lar lehq ha lehg ha ka pehor pehor sar sar te chehd lar cawd vehr che yaog.”’ ");
INSERT INTO lhi_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kheh ma khuhd Ghig sa yawd haq koz vid che, ‘Chaw lug kid-og, yaq pehax loar nawg ved co ha haq ngag yug khuhq vehr tug yaog. Kheh te lehq, nawg ghawz phoz lar che med nged u ve teq pa a sug gha vehr lawg le,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","A sug yawd awg ton pua lehax med nged jeg kor saw ghawz phoz lar lehq Ghig sa phawd awr vawr har ghuhd che chaw teq pa awr lehr, u ve heh lag che yaog,” lehz i hehd teq pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Peg lehq, Yer suq yawd ved awg laq ghuhd teq pa haq koz vid che, “Kheh te cheaq te lehq ngag nig hehd teq pa haq koz ax laq, nig hehd teq pa khawd-ehg te ver gha cad gha dawg lehq, a saq gha teq chehd tuawg le ghod che haq ta duhd khix. Khawd-ehg te ver gha veq gha deh lehq awg ton gha teq chehd tuawg le ghod che haq nig hehd ta duhd khix. ");
INSERT INTO lhi_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Awg lawn ghod ver, a saq teq che ted ceng awr lehr, cad tuaq keh a yed ir lehq, awg ton liz veq kad-aq keh a yed ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Naz kag teq pa haq ngawx-oq. I hehd teq pa awr lehr, a cag liz maq kha mad ghiq. Cag pheh cag yehg he lehq ca phoz lar che liz ted kaer mad cawg. Kheh liz, Ghig sa i hehd teq pa haq car vid taw vid che yaog. Nig hehd teq pa awr lehr, ngaz u ve teq pa haq keh a yed khawd-ehg taw maq iar le. ");
INSERT INTO lhi_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nig hehd teq pa awg khuhn chaw a sug te ghad lehd ma koz, duhd khix cheaq te lehq a sug yawd ved a saq teq nia liz kawq te yehg vid gha hawg le. ");
INSERT INTO lhi_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kheh te lehq, awg ceng nehax kheh tawa ve haq liz te maq gha ver, awg kag awg nuz awr ve awg ceng nux maz haq a thoq te nig hehd ca duhd khix chehd cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Suhz vez khawd-ehg kheh te iar che haq duhd ngawx-oq. Yawd kanx maq te, ghoq kheh liz mad ghawg. Kheh te lar, ngag nig hehd haq koz ax laq, jawd mawd Sawd laq monr awg mig awg phond cawg jad che veq kad veq lar cheaq keh liz yawd daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kha nehax maq yonr che nig hehd teq paog, yaq ni teq chehd liz sawx vawr ver a mir khuhn bag tox vehr tug muhq cehg nehax haq liz Ghig sa kheh taw taw fex vid deh vid chehd hawg ghod ver, u ve haq keh lex lehq nig hehd haq feax tug deha tug ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nig hehd teq pa a thoq yug cad yug dawg tug nar ghod che haq taq ca duhd har lehq ni ma khuhn liz duhd khix che tad cawg vid ser. ");
INSERT INTO lhi_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Awg lawn ghod ver, awg ceng u ve teq pa haq mig gig chaw yad Ghig sa haq maq sir che chaw teq pa ghaq ca chehd che yaog. Kheh te lar, nig hehd awg pun vawr, nig hehd ve Awr pa awr lehr, nig hehd awg ceng u ve teq pa haq lor che haq sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kheh te cheaq te lehq, nig hehd teq pa Ghig sa ve muhd mig haq awg kawd ghaq ca ser. U kheh te ver, yawd nig hehd lor chehd che awg ceng u ve teq pa haq kawq thehr ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yawg awg mor nehax teq paog, ta kuhz. Nig hehd ve Awr pa awr lehr, nig hehd haq muhd mig u ve pehar tug ni ma cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Nig hehd cawg lar che med nged teq pa haq huhd lehq, chaw har yad teq pa haq ca pehg vid-oq. Maq pir vix maq sax vix che a sug yawd ved phu kaw pi haq teo. Chaw khuhd khuhd yug maq gha lehq, puhd ma cad gha che muhd nuh kawag lo mad peg maq leh vix che nig hehd ve med nged ghawz phoz laor. ");
INSERT INTO lhi_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Awg lawn ghod ver, nig hehd ve med nged khar lo cawg liz nig hehd ve ni ma u huh cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Kanx te tug beg ke kha nehax veq lar lehq a mir khehd tox teh lar lehq paog lar. ");
INSERT INTO lhi_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","A sug yawd ved awg sehr phad khehx cad kig lo kae lar haz kawaq lehq, ghaz mir haq thuhz ver, teq pear lehax phaw vid gha tug heh te lehq, nig hehd liz u kheh te paog lar. ");
INSERT INTO lhi_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Awg sehr phad kawaq lehq, paog chehd lawz ser che awg ceg var u ve phad awr lehr, awg bon ir che yaog. Ngag nig hehd haq awg cehg mag koz ax laq, awg sehr phad awr lehr, yawd ved beg ke kawq pa kha lehq awg ceg teq pa haq cad phenx pad huh phoz mi vid lar lehq, yawd awg ton i hehd haq kha nehax te car te taw vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Awg sehr phad te khend lo la muhd thid-ag phawd awr lo kawaq lehq u kheh te paog chehd lawz ser che awg ceg var teq pa awr lehr, awg bon ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yehg sehr phad awr lehr, chaw khuhd lag tug awg yand awg kawd loar sir lar ver, chaw khuhd maq gha gehag tug yawd kha nehax paog lar tug yaog lehz nig hehd sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","U ve heh te lehq, nig hehd teq pa liz kha nehax ghu lar hehnd laor. Awg lawn ghod ver, nig hehd ma duhd ma gad che awg yand khuhn chaw yad ve Yad phu kawq yaq tug yaog,” lehz Yer suq i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Kheh te lehq, Per troq Yer suq haq na lehq koz che, “Jawd mawd-og, tawd par hax che ngag hehd haq lehax koz chehd cheawg la. Ma hez ver, chaw awg gha lia haq koz vid chehd cheawg la,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jawd mawd Yer suq kawq koz che, “A sug te ghad awr le. Thed lehq cud yiq cawg che med nged haq sax var te ghad awg hox te lehq, awg ceg teq pa haq awg yand kha cawd-aw lehd cad tug dawg tug pehg car vid tug, awg sehr phad kanx pid lar che. ");
INSERT INTO lhi_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Awg sehr phad kawaq lehq, yawd pid lar haz che kanx haq yawd ved awg ceg var te chehd lawz che haq yawd gha mawg ver, awg ceg var u ve phad awr lehr awg bon ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ngag nig hehd haq awg cehg mag koz ax laq, awg sehr phad awr lehr, yawd ved med nged awg gha lia haq ngawx haq sax vid tug, awg ceg var u ve phad haq te cuh vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kheh ma khuhd, awg ceg var u ve awr lehr, ‘Yawd ved awg sehr phad har naq mad kawaq ser hawg,’ lehd duhd lehq, thi cad thi dawg lehq juhg buhz ka buhz he lehq awg ceg var awg ceg ma haq kaod dawz kaod yaq chehd ver, ");
INSERT INTO lhi_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","awg ceg var u ve ma duhd ma gad he lehq maq sir mad juhg che awg yand khuhn yawd ved awg sehr phad kawaq lehq, yawd haq hehnd che khuhn toq pid lehq maq na yug che chaw teq pa geh yug chehd vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","A sug yawd ved awg sehr phad ve a lor haq sir chehd liz, maq te law lar lehq, awg sehr phad ve a lor haq maq te che awg ceg te ghad awr lehr, hax ceh nux maz jawq che haq gha khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Maq sir che khuhn te yaq lehq jawq kenr jawq cawd che awg ceg var te ghad haq awr lehr, a cehax lehax jawq che haq gha khanr tug yaog. Mad chawa gha che chaw teq pa awr lehr, mad chawa gha khuhq sehr tug yaog. Mad chawa aq vid lar che phad awr lehr, mad chawa yawd geh kawq lawg khuhq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Mig gig haq a mir toq vid tug ngag lag che yaog. Ngag khar thad liz a mir u ve toq chehd lar vid gad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kheh te lar, ngag gha khanr tug baz tiz sar ted mag cawg che yaog. U ve haq ngag maq gha khanr peg ser ver, ngag ni ma khuhn duhd har jad chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nig hehd duhd ver, ngag mig gig-aq lo lag che cawd daq hawr daq tug ca teag cheawg lehd duhd lehq la. Ma hez hawg. Su phaz daq gid daq tug ngag ca teag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Awg lawn ghod ver, a meha haq tanr lehq, yehg ted yehg khuhn chehd che chaw ngad ghad u ve phaz daq lehq, ni ghad teq mor te lehq, seh ghad teq mor te vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Awr pa he lehq awg yad par, awr ye he lehq awg yad mid, awr pi ma he lehq awg khed ma liz, te ghad haq te ghad ma cawd maq hawr daq lehq phaz daq vehr tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kheh te lehq, Yer suq chaw mor nux haq phuhz ngawx lar lehq koz vid che, “Muhd ni kehg phawd awr lo mog naz dig chid tuag che haq nig hehd gha mawg ver, ‘Muhd yeg lag lehd te che yaog,’ lehd koz tuhaz che yaog. Nig hehd koz che heh te lehq awg cehg mag lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Awg huhx phawd awr lo ve muhd huh mez taz che haq nig hehd gha mawg ver, ‘Huh jad chiz jad tug yaog,’ lehz nig hehd koz che yaog. Koz lar che heh lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Chaw pha yax te var teq paog, mig gig he lehq muhd nuh maq haq nig hehd ngawx sir lehq fir daq pehg daq gha che yaog. Kheh te lar, a meha phehq chehd che awg lawn haq a thoq te nig hehd fir daq pehg daq maq gha cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","A thoq te lehq khar ve ted ceng te cawd maq te cawd che haq nig hehd khad nawag duhd te maq gha cheawg la. ");
INSERT INTO lhi_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nawg haq ma cawd daq che phad geh sax nax lo kae tod-ag huh, yaq kaw kar lo yawd haq kawq cawd daq tug hax ceh teo. U kheh maq te ver, nawg awr lehr, yawd suhx jehg suhx taz kig lo sir ve kae lehq, suhx taz peg ver, suhx taz var liz thawnr awg hox haq chid aq vid tug yaog. Thawnr awg hox u ve nawg haq thawnr khuhn yug ke huh tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ngag nawg haq koz ax laq, nawg thawnr yehg u ve khuhn su maex che awg phuhd kha khuhq gha saw chehd kha peg heh ma hez ver, thawnr yehg u ve khuhn maq gha tuhez hawg,” lehz Yer suq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Awg yand u ve khuhn chaw ted pehg lag lehq, jawd mawd Pid laq Gar liq lehd chaw teq pa tand tug tand chehd-ag huh dawz vehr cheaq te lehq, i hehd ve awg suhr he lehq i hehd tand chehd che to saz ve awg suhr haq phawng daq che awg lawn Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yer suq kawq koz che, “Gar liq lehd chaw u ve teq pa haq su u kheh te suh vid cheawg lehr, awg kag awr ve Gar liq lehd chaw haq keh liz i hehd vend bax ir jad cheaq te cheawg lehz nig hehd duhd lehq la. ");
INSERT INTO lhi_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma hez hawg. Ngag nig hehd haq koz ax laq, i hehd teq pa suaq keh vend bax ir che ma cawg hawg. Nig hehd teq pa liz vend bax ma duhd phuhz ver, nig hehd awg gha lia liz i hehd teq pa heh te lehq gha lug gha sez tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ma hez ver, taz law ngawx kig Sid lonr yehg muh maq kuhd ter lehq, suh vehr che chaw teq chi hex ghad u ve teq pa awr lehr, Yer ruq sar lehnr med khuhn chehd che awg kag awr ve chaw teq pa haq keh i hehd te yaq cheawg lehz nig hehd duhd cheawg la. ");
INSERT INTO lhi_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma hez hawg. Ngag nig hehd haq koz ax laq, nig hehd teq pa vend bax ma duhd phuhz lehq ni ma maq pa ver, nig hehd teq pa awg gha lia liz i hehd teq pa heh te lehq gha lug gha sez tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yer suq yawd tawd par hax te mar lehq koz che, “Chaw te ghad yawd ved a pehx med kho khuhn a kud ted cehg kha lar che yaog. A kud cehg u ve haq yawd ca ngawx-ag liz awg sir mad mawg. ");
INSERT INTO lhi_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kheh te lehq, kho haq sax var haq yawd koz vid che, ‘Ngag a kud cehg che ve haq ca ngawx-ag che seh khuhq gag vehor, awg sir liz mad mawg. Awg cehg che ve haq thawq kuhd lor. A thoq te lehq mig khid te pehz chea lehax te vid lar cheawg le,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kho haq sax var kawq koz che, ‘Jawd mawd-og, cig ni khuhq teha lar ser. Ngag awg cehg cuhz per caw kar lehq, khid kha nehax ke vid ngawx sar. ");
INSERT INTO lhi_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Awg suhx-ag gaeg lehq awg sir nuhq ver, daeq che yaog. Kheh te lar, awg sir heh mad nuhq hawg ghod ver lehr, thawq kuhd vehr che yaog,’” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sa ba to awg ni teq ni huh bon lawg kig ted kag awg khuhn Yer suq mar vid chehd-ag huh, ");
INSERT INTO lhi_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","u huh ned geh lehq nag che teq chi hex khuhq gaeq che yad mi te ghad chehd chehd che yaog. Yawd awr lehr, cuhq khu biz maq phehq vehr lehq, kawq thed maq gha vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yer suq yad mid ma u ve haq gha mawg lehq yawd kug veha lehq koz vid che, “Yad mid-og, nawg ved a nar haq nawg gha pong vehor,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yad mid u ve thag huh yawd ved laq kuhr tar vid lehq, teq pear lehx yad mid u ve cuhq kawq thed gha vehr lehq, Ghig sa haq chid ir chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sa ba to awg niaq Yer suq chaw nag haq ghu na vid cheaq te lehq, bon lawg kig huh ve awg hox u ve phad yawd nez nag jad lehq su haq koz vid che, “Kanx te cawd che awg ni khuhq ni cawg che yaog. Nig hehd a nar ghu na tug, awg ni u ve teq pa khuhn laor. Sa ba to awg ni haq ver tad lag,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Kheh te lehq, Yer suq yawd haq kawq koz vid che, “Chaw pha yax te var teq paog, nig hehd teq pa awg gha lia Sa ba to awg ni ver a sug yawd ved nud he lehq pix lar nehax haq caz kheh phi kha vid lehq, awg kho khuhn seh ve tuhez lehq a kaz ca taw vid chehd che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ar brar hanr ve yad mid che ve haq ned haeg Sar tanr pheh teh lar che teq chi hex khuhq gaeg che yaog. Pheh lar che u ve haq Sa ba to awg ni teq niaq phehd kha vid che ma cawd hawg la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yer suq che kheh koz cheaq te lehq, yawd haq cand che chaw teq pa ve mehz khuhd lug lehq gha yaq taw che yaog. Kheh liz chaw mad awr lehr, yawd te che kanx teq pa daq jad che haq gha mawg lehq ha lehg jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kheh te lehq Yer suq koz che, “Ghig sa ve muhd mig a thoq haq sur cheawg le. Ngag a thoq haq yug lehq gha tehz mar tuawg le. ");
INSERT INTO lhi_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ghig sa ve muhd mig awr lehr, chaw te ghad yawd ved kho khuhn ser lar che a ghawd yuhd haq sur che yaog. Awg yuhd nehax u ve yeg lehq iar ver, awg cehg nux maz te vehr che yaog. Kheh te lehq muhd-aq lo pog che ngaz teq pa awg kax u ve thag huh awg phi te che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yer suq te pawz kawq koz che, “Ghig sa ve muhd mig haq ngag a thoq yug lehq gha tehz mar tug lehq na. ");
INSERT INTO lhi_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ghig sa ve muhd mig awr lehr, did haq sur daq che yaog. Yad mid te ghad did yug lehq khaor mod te tug cag kha mia seh khuhr luhd khuhn ke ver, awg gha lia saw cid tuag vid che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","U kheh te lar haz lehq Yer suq awr lehr, Yer ruq sar lehnr med lo kae che yaog. Yawd kae tod che yaq kaw kanr huh cawg che med he lehq khaz teq pa khuhn seh mar vid te kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Kheh te lehq chaw te ghad na che, “Jawd mawd-og, thaer khuhq cheaq gha tug chaw a cehax lehax cawg cheawg la,” lehd koz na che yaog. Yer suq i hehd haq kawq khuhq vid che, ");
INSERT INTO lhi_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mad kuhg che ghaz mir khuhn geh gag tug cud cad lehq hax ceh teo. Awg lawn ghod ver, ngag nig hehd haq koz ax laq, chaw laex ghad geh gad lehq kaod pawnx te liz geh mad gag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yehg sehr phad tuag lehq ghaz mir hoz lar haz peg ver, nig hehd awg bag lo hox lar lehq ghaz mir haq thuhz tug yaog. ‘Jawd mawd-og, ngag hehd haq ghaz mir a cehax phawa laoq,’ lehd koz vid ver, yehg sehr phad awr lehr, ‘Nig hehd khar lo lag cheaq ngag maq sir,’ lehd kawq koz khuhq ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kheh te ver, nig hehd koz che, ‘Ngag hehd teq pa nawg geh teq geha cad jaw dawg jaw lehq, ngag hehd ve med khuhn cawg che yaq kaw teq pa huh liz nawg ngag hehd haq mar jaw peg che yaog,’ lehd koz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yehg sehr phad kawq koz vid che, ‘Nig hehd khar lo te lag cheaq ngag maq sir. Chaw haeg var teq paog, kae lor. Ngag mawg kig huh liz ta chehd-oq,’ lehd koz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ar brar hanr, Id caq, Yar koq he lehq Ghig sa ve cuh kar var teq pa awg gha lia Ghig sa ve muhd mig khuhn chehd chehd cheaq nig hehd gha mawg lehq, nig hehd awg ton haq vawr su awg bag phawd awr ghaq kog ax ver, nig hehd awr lehr, cig geq yuhz cheq lar lehq gha huhg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Awg yand u ve khuhn muhd ni tuhz muhd ni kehg, awg kiz awg naz awr lo chehd che chaw teq pa phoz lag lehq, Ghig sa ve muhd mig khuhn phoz mi lar thi cad thi dawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Su khaz nuhr chehd che chaw teq pa, su ghud med awr chehd lawz tug yaog. Su ghud med awr chehd che chaw teq pa, su khaz nuhr lo chehd lawz tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Awg yand u ve khuhn, Phar rir sehd ted pehg lag lehq Yer suq haq koz vid che, “Nawg chuhr huh tuhez lor. Awg lawn ghod ver, jawd mawd Her roq nawg haq dawz vehr gad che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yer suq i hehd haq kawq koz vid che, “Nig hehd kae lehq heh phid u ve haq che kheh ca kud vid-eq. ‘Yaq ni sawx vawr, ned teq pa haq ngag ghaq kog lehq chaw nag teq pa haq ngag ghu na vid tug yaog. Sehr ni teq niaq gaeg ver, ngag ved kanx peg vehr che yaog,’ lehd ca kud vid-eq. ");
INSERT INTO lhi_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kheh ma khuhd, yaq ni sawx vawr he lehq phehq ni awr vawr, ngag gha kae ser lawg. Awg lawn ghod ver, Yer ruq sar lehnr med khuhn, Ghig sa ve cuh kar var haq gha dawz vehr lawg. ");
INSERT INTO lhi_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yer ruq sar lehnr med-og, Yer ruq sar lehnr med-og, nawg awr lehr, Ghig sa ve cuh kar var teq pa haq khar thad liz dawz vehr lehq, nawg chehd lo pea lar che chaw teq pa haq khar thad liz huhx meh saw bag suh vehr che yaog. Ghaz ye ma yawd ved awg yad teq pa haq yawd ved tawg laq huhx-uh saw phoz chehd vid che heh te lehq, nawg ved awg yad awg dug teq pa haq laex pawz ngag phoz chehd lar vid gad liz nawg maq te leq. ");
INSERT INTO lhi_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ngawx lor, nig hehd ve yehg awr lehr, awg kawd naz he lehq tor ghad yen ghad lag tug yaog. Ngag nig hehd haq koz ax laq, ‘Jawd mawd Ghig sa ve awg meh khuhn lag che chaw te ghad haq awg bon ir vid-oq,’ lehd ma koz ser che kheh ceh, nig hehd ngag haq maq gha kawq mawg hawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sa ba to awg ni huh Yer suq awr lehr, Phar rir sehd awg mor khuhn chehd che awg hox te ghad ve yehg khuhn awr ca cad-eg lehq, i hehd teq pa kha nehax jaz ngawx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","U huh chehd che haw khaz te ghad ux peg khuhn a kaz cawg lehq khi kud laq kuhr awg phoq chuhd he lar lehq Yer suq mehz khuhd suhr huh lag hox chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yer suq na che, “Sa ba to awg ni khuhn chaw nag haq te na vid ver yaq hawg la. Mad yaq hawg la,” lehd koz lehq awg lid tawd khuhd sir var he lehq Phar rir sehd teq pa haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kheh liz, i hehd teq pa te ghad-eg liz teq chaweh ma koz. Kheh te lehq, Yer suq chaw nag u ve phad haq yug cid lar lehq ghu na vid peg lehq, kawq pe vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","U kheh te peg lehq, Yer suq kuhr phuhz ngawx lar lehq i hehd haq na che, “Nig hehd a sug yawd ved yad par la, ma hez ver, nawg ved nud Sa ba to awg ni haq nag baw khuhn che geh chehd lawz ver, har naq mad yug tuhz vid che a sug cawg hawg le,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","I hehd teq pa awr lehr, tawd u ve haq kawq khuhq vid maq gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Khehx cad kig lo kug lar che khehx chaw teq pa lag lehq awg mig awg phond cawg che mi kig haq lez mi che haq Yer suq gha mawg lehq, tawd par hax te mar vid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Chaw te ghad ghad nawg haq khehx cad kig lo kug ver, awg mig awg phond cawg che mi kig haq taq ca mi. Awg lawn ghod ver, nawaq keh awg mig awg phond cawg che chaw liz lag ver, ");
INSERT INTO lhi_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nig mag haq kug che phad lag lehq, ‘Nawg tu. Che phad mi vid,’ lehd koz tug yaog. U kheh te ver, nawg awr lehr, gha yaq taw nuhr liz, su kheh tawa liz awg mig awg phond mad cawg che mi kig lo gha kawq yaq mie tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Chaw te ghad ghad nawg haq ca kug ax cawd ver, nawg kae lehq awg mig awg phond mad cawg che teq pa mi kig huh awg kawd ca mi lar ser. U kheh te ver, nawg haq kug che phad lag lehq, ‘Awg chawd-og, cheaq keh awg mig awg phond cawg che mi kig haq kawq taz mi lag,’ lehd koz ax tug yaog. U kheh te ver, nawg geh mi chehd che chaw teq pa ve mehz khuhd suhr nawg awg mig awg phond gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Awg lawn ghod ver, a sug yawd awg ton haq tar ir che chaw khar ve te ghad lehd ma koz, tar nehg cheaq gha tug yaog. A sug yawd awg ton haq tar nehg che chaw khar ve te ghad lehd ma koz, tar ir cheaq gha tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kheh te lehq, Yer suq yawd haq kug che yehg sehr phad haq koz vid che, “Muhd kaw awr cad tug ma koz, muhd phiq awr cad tug ma koz, nawg su haq ca kug ver, nawg ved awg chawd, a vix a nax, awg ceng awg khad he lehq awg pad awg ki huh chehd che paw sa che teq pa haq tad kug. U kheh te che chaw haq kug ver, i hehd liz nawg haq kug lehq awg bon kawq te khuhq ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kheh te ver, nawg thi cad thi dawg tug su haq ca kug che te yand, har ghuhd che chaw, khi theh che chaw, laq kuhr mad daq che chaw he lehq mehz cox che chaw teq pa haq ca kug lor. ");
INSERT INTO lhi_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","U kheh te ver, nawg awg bon ir che yaog. Awg lawn ghod ver, i hehd nawg haq awg bon kawq te khuhq ax maq gha. Thed che cawd che chaw teq pa kawq teq tuag che awg yand gaeg ver, Ghig sa nawg haq awg bon kawq te khuhq ax tug yaog,” lehz Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Yawd geh teq geha mi cad chehd che chaw te ghad phad tawd u ve haq gha kad lehq koz che, “Ghig sa ve muhd mig khuhn thi cad thi dawg kig huh gha geh cad tug chaw awr lehr, awg bon ir che yaog,” lehz Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yer suq kawq koz che, “Chaw te ghad yawd pawehd nux te lehq, thi cad thi dawg tug chaw kha peh vad-ag haq kug lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Thi cad thi dawg tug awg ceng gha lia saw hanr saw te peg lehq, yawd ved awg ceg var haq kug lar che chaw teq pa chehd lo, ‘Cad laoq. Awg ceng gha lia saw hanr saw te peor,’ lehd ca koz vid pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Chaw u ve teq pa te ghad peg te ghad pong kig ca che khuhn koz khuhq che yaog. Awg kawd te ghad koz che, ‘Ngag ti mi awg suhx te pez vig lar lehq gha ca ngawx-eg ser tug law mehr. Kae mad gag ser law,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ni ghad te ghad kawq koz che, ‘Ngag nud ngad ceh vig lar lehq, a cehax gha ca sir ve lehq te ngawx-eg ser tug law. Kae ma tand ser law,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Seh ghad te ghad koz che, ‘Ngag yad mid he che maq muh ser lehq, lag mad gag,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kheh te lehq, awg ceg var u ve kawaq lehq, yawd ved awg sehr phad haq awg lawn u ve teq pa saw khae mar vid che yaog. Yehg sehr phad u ve yawd nez nag jad lehq, awg ceg var haq koz vid che, ‘Har naq med khuhn kae lehq, yaq kaw nux yaq kaw nehax teq pa lo kae lehq, har ghuhd che chaw, laq kuhr mad daq che chaw, mehz cox che chaw, khi theh che chaw teq pa haq ca sir vea laoq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","U kheh te peg lehq, awg ceg var kawq koz che, ‘Jawd mawd-og, nawg koz ax lar che heh te peor. Kheh liz chehd kig kawq cawg chehd sear,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Yehg sehr phad kawq koz che, ‘Kheh te ver, med bag lo kawq kae lehq, yaq kaw nux yaq kaw nehax teq pa he lehq su ti mi lo kae khad yaq kaw lo liz har naq ca cex beg vid lehq, ngag ved yehg che ve haq peh lawq lawq ca sir vea kawq laoq. ");
INSERT INTO lhi_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Awg lawn ghod ver, ngag nig hehd haq koz ax laq, awg kawd thad loar kug lar che chaw u ve teq pa te ghad-eg liz ngag ved cad tug haq maq gha cend ngawx lar haz hawg,’ lehz awg ceg var haq koz vid che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kheh te lehq, Yer suq yawd khaz nuhr ghaq tod che chaw mor nux haq phuhz ngawx lar lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ngag khaz nuhr ghaq che chaw a sug lehd ma koz, a sug yawd ved awr pa awr ye, awg mid awg yad, a vix a nax teq pa haq ma koz, a sug yawd ved a saq haq liz ma koz, maq ngawx bawg ver, ngag ved awg laq ghuhd te maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Chaw a sug te ghad lehd ma koz, a sug yawd ved laq kan haq taz lehq ngag khaz nuhr mad ghaq ver, ngag ved awg laq ghuhd te maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tawd par hax te ver, nig hehd khuhn ve chaw te ghad ghad yehg muh maq nux ted mag te gad ver, phu khawd-ehg ma gha peg tug khawd-ehg ma ver, lawq che haq kha sehax maq sawnr ngawx lehq te che chaw cawg hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","U kheh te maq sawnr ngawx ver, yehg haq tanr kawx peg ver, yug te tug mad cawg he lehq kawq cax te maq gha ver, su kha lag mawag che chaw koz gid ghig gid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Chaw che ve phad tanr kawx chea lehax gha che law. Te peg maq gha che law,’ lehz su koz gid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ma hez ver, jawd mawd te ghad yawd su ved jawd mawd te ghad haq bawz daq lehd te ver, su ved maq yad niq mir ghad lag che haq yawd ved maq yad teq mir ghad bawz ghad tug nar, ma ghad tug nar, lehz mi lar lehq awg kawd kha nehax ma duhd ngawx ser che jawd mawd te ghad ghad cawg hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma ghad tug haq yawd sir ver, su lag che mad gag tag ser loar, awg tan te sehr phad haq har naq kae pe lehq, su haq cawd daq tug gha ca te pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Che heh yaog. Nig hehd teq pa awg khuhn liz a sug te ghad lehd ma koz, nawg kha cawg che awg ceng gha lia Ghig sa haq ma chid aq vid ver, ngag ved awg laq ghuhd te maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","A lehq awr lehr, daq che yaog. Kheh te lar mehg che pehz vehr ver, kawq mehg tug te maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","A lehq u ve awr lehr, mig gig awg pun lehd ma koz, mig khid te tug awg pun lehd ma koz, teq chaweh awg bon mad cawg vehr lehq, su yug lehq cag kawx khi lo chid bag pe vehr che yaog. Kad tug nar puh cawg che chaw naog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Awg yand u ve khuhn awg khawnr saw var he lehq vend bax yad teq pa, Yer suq mar che haq na tug yawd awg pad huh phoz lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Phar rir sehd teq pa he lehq liq buhq var teq pa koz che, “Che phad vend bax yad teq pa haq haq yug lehq, i hehd teq pa geh thi cad thi dawg che law,” lehd koz khaex che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yer suq i hehd haq tawd par hax te mar vid che, ");
INSERT INTO lhi_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nig hehd teq pa khuhn chaw te ghad yawg teq ha kheh cawg lehq teq kheh mehx vehr ver, kuhd chi kuhd kheh haq kaz cad kig muhq de khuhn teh lar haz lehq, mehx vehr che yawg teq kheh haq mawg thad kha gag mad ghaq cae hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yawg u ve haq yawd ca mawg vehr ver, ha lehg jad che khuhn yug lehq laq boz thang chid taz vea lehq kawaq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Yawd ved yehg lo kawq gag ver, yawd ved awg chawd teq pa he lehq awg pad awg ki huh ve chaw teq pa haq kug lehq, ‘Ngag geh ga ha lehg laoq. Awg lawn ghod ver ngag ved yawg mehx vehr che kawq ca mawg vehor,’ lehz yawd koz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ngag nig hehd haq koz ax laq, u ve haq sur daq che yaog. Vend bax haq duhd phuhz tug maq lor lehd duhd che thed che cawd che chaw kuhd chi kuhg ghad haq keh, vend bax yad te ghad vend bax haq duhd phuhz lehq kaw kawaq ver, muhd nuh kawag lo ha lehg tug lex lehq cawg mad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Tawd par hax te ver, yad mid ma te ghad yawd awg phuhd khaz che phu teq chi thehq cawg che ted thehq yehg khuhn che mehx vehr cawd ver, a mir khehd tox lar lehq yehg jawq siz lehq, mawg thad kha gag mad ghaq ca che yad mid ma cawg hawg la. ");
INSERT INTO lhi_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Yawd phu u ve haq kawq mawg vehr che te yand, yawd awg chawd teq pa he lehq yawd pad huh chehd che chaw teq pa haq koz vid che, ‘Ngag geh ga ha lehg laoq. Awg lawn ghod ver, ngag ved phu mehx vehr che kawq ca mawg vehor,’ lehd koz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ngag nig hehd haq koz ax laq, u ve haq su daq che yaog. Ghig sa liz, vend bax yad te ghad vend bax haq duhd phuhz lehq kaw kawaq ver, yawd ved muhd nuh maq cuh yad mehz khuhd suhr ha lehg tug cawg che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yer suq te pawz kawq koz che, “Chaw te ghad phad yawd yad par ni ghad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Awg nax var te ghad awr pa haq koz vid che, ‘Ngar pa-og, ngag gha cawd che ngag ved awg sinx teq pa ngag haq pehar laoq,’ lehd koz vid che yaog. Kheh te lehq, awr pa ix mag haq awg sinx pehg vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Awg khaz nuhr maq muh tand, awg nax var te ghad yawd ved med nged jeg kor teq pa saw yug ve lehq, vid-ag lo muhd mig ted mag khuhn ca chehd-eg che yaog. U huh yawd mig gig a lor tand pehor haq ghaq te lehq, yawd ved phu he lehq med nged saw cad saw yehd bag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Yawd kha cawg che saw cad saw yehd peg che te yand, muhd mig u ve khuhn meq nux kaz nux cawag lehq, yawd teq chaweh yug cad tug mad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kheh te lehq, yawd muhd mig u ve khuhn chehd che chaw te ghad geh ca chehd lehq kanx ca te che yaog. Su yawd haq ha lo vaq hu cuh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Yawd meq jad lehq, vaq cad chehd che a nuhz sir u ve teq pa kha buhz cad gad jad che yaog. Kheh liz, su yawd haq cad tug teq chaweh maq car vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kheh te lehq, yawd kawq sir kawq nuhd-ag lehq koz che, ‘Ngar pa geh chehd lehq kanx canr te cad chehd che chaw teq pa liz, cad mad peg dawg mad peg te chehd-aq. Ngag awr lehr, chuhr huh meq jehd kaz jehd lehq suh vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ngag tu lehq ngar pa chehd lo koeq lehq, “Ngar pa-og, ngag awr lehr Ghig sa haq liz nawg haq liz te yaq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yaq ni khaz nuhr ver, ngag awr lehr, nawg ved yad-awg lehd liz koz maq kenr. Nawg ngag haq nawg ved kanx canr te par kheh tawa sawnr tar ax laoq,” lehz yawd koz vid tug yaog,’ lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Yawd tu lehq awr pa chehd lo koeq che yaog. Yawd vid-ag lo kawaq tod ser huh loar, awr pa gha mawg lehq, yawd haq har kax che khuhn yawd chehd lo cex kae lehq kuhr haq vuhz cuhx lar lehq bux vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kheh te lehq, awg yad par yawd haq koz vid che, ‘Ngar pa-og, ngag awr lehr Ghig sa haq liz nawg haq liz te yaq vehr cheaq te lehq, yaq ni khaz nuhr ver nawg ved yad-awg lehd liz koz ax maq kenr vehr che yaog,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kheh liz awr pa awg ceg var teq pa haq kuhr phuhz ngawx lar lehq koz vid che, ‘Daq jad che a poq nux maz yug vea lehq yawd haq har naq deh vid laoq. Yawd ved laq nuh haq laq per liz nuhx vid laoq. Khi haq khi noz liz cuhx vid laoq. ");
INSERT INTO lhi_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kheh te lar haz lehq, nud nehax awg phoq chuhd te che teq kheh ca seh vea dawz laoq. Ha lehg ha ka thi cad thi dawg lehq pawehd teag veg. ");
INSERT INTO lhi_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Awg lawn ghod ver, ngag yad par che suh vehr cheawg lehd duhd liz, a meha kawaq vehor. Mehx vehr peg liz a meha kawq ca mawg vehor,’ lehd koz lehq i hehd teq pa ha lehg ha ka pawehd te che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Awg vix var vawr, ha khuhn kanx te chehd che yaog. Yawd kawaq lehq yehg pad huh gaeg lehq, nuhr mez ka khez chehd che awg khuhd haq gha kad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Yawd awg ceg var te ghad haq kug na che, ‘A thoq te chehd cheawg le,’ lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Awg ceg var koz vid che, ‘Nawg nax var yawd mad nag mad guhg lehq mad lug ma sez che khuhn kawq gag vehr lehq, nawr pa nud nehax awg phoq chuhd te che teq kheh dawz cad lar pawehd te chehd cheawg,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Awg vix var nez nag jad lehq, yehg khuhn liz mad kawq gehe che yaog. Kheh te lehq, awr pa tuhaz lehq yawd haq caw beg lehq lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yawd awr pa haq kawq koz vid che, ‘Ngawx hehq. Ngag nawg ved awg ceg lehax te chehd che kheh muh muh gaeg lehq, nawg ved tawd khuhd haq te khuhad liz mad pong lex jaw. Kheh liz, ngag ved awg chawd teq pa geh ha lehg ha ka te tug, a chiq nehax teq kheha liz nawg ngag haq maq pehar jaw. ");
INSERT INTO lhi_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kheh te lar, meh mar lanx teq pa haq awg chawd te lehq, nawg ved phu si muhd jeg haq saw yehd saw cad bag vehr che nawg ved yad par che te ghad kawaq gha mehx, nud par nehax awg phoq chuhd te che dawz car vid che law hehq,’ lehz koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Awr pa kawq koz vid che, ‘Yad par-og, nawg awr a pa geh khar thad liz chehd chehd che yaog. Ngag kha cawg lar che med nged awg gha lia nawg ved lehax yaog. ");
INSERT INTO lhi_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Nawg nax var vawr, suh vehr lehq a meha kawq teaq heh te lehq, mehx vehr lehq a meha kawq ca mawg vehr che haq te lehq, ha lehg ha ka te vid cawd che yaog,’ lehz awr pa yawd haq kawq koz vid che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Awg laq ghuhd teq pa haq Yer suq tawd par hax te mar vid lehq koz che, “Paw sa var te ghad yawd ved med nged haq sax var te ghad cawg che yaog. Med nged haq sax var u ve yawd awg sehr phad ve med nged haq kheha saw kaod te kog vehr chehd che haq su sir lehq, su awg sehr phad haq khuhq kud vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Awg sehr phad yawd haq kug lehq, ‘Nawg ved awg lawn ngag gha kad che, nawg khawd-ehg kheh te cheawg le. Nawg med nged haq sax var te chehd che, cag land ngag chehd lo yug khuhq vea. Awg lawn ghod ver, yaq ni khaz nuhr ver, nawg haq med nged haq sax che mad kawq te cuha vehr che yaog,’ lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kheh te lehq, med nged haq sax var u ve phad yawd ved ni ma khuhn duhd che, ‘Ngag khawd-ehg te ver cawd tug lehq na. Ngag ved awg sehr phad awr lehr, ngag haq yawd ved med nged haq sax che kanx khuhn yug tuhz vehr tug yaog. Mig giaq ha kawd cad tug liz ngag te tug duhd ma tuhz. Su geh ca lawg cad-eg liz ngag yaq taw che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Med nged haq sax che kanx khuhn su ngag haq ghaq tuhz ax ver, ngag khawd-ehg te ver, su ved yehg khuhn ngag haq su haq yug ax tug u ve ngag sir vehor,’ lehd yawd duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yawd ved awg sehr phad geh jeg kha cawg lar che chaw te ghad peg te ghad haq yawd kug vea lehq, awg kawd maq te ghad haq koz vid che, ‘Ngag ved awg sehr phad geh nawg jeg khawd-ehg ma cawg lar hawg le,’ lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Nag mand teq ha piz cawg lar che yaog,’ lehz kud vid che yaog. Kheh te lehq, med nged haq sax var koz vid che, ‘Nawg ved cag land haq yug vea lehq har naq mi lar lehq ngad chi piz lehax buhq keog,’ lehz koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kheh te peg lehq, ni ghad te ghad haq yawd kawq na lehq koz che, ‘Nawg jeg khawd-ehg ma cawg lar hawg le,’ lehd koz na che yaog. ‘Cag sir teq ha taz cawg lar che yaog,’ lehd koz vid che yaog. Kheh te lehq, med nged haq sax var koz che, ‘Nawg ved cag land yug vea lehq hex chi taz lehax buhq keog,’ lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ma thed che med nged haq sax var u ve phad cud yiq yehd vix cheaq te lehq, awg sehr phad yawd haq chid muh che yaog. Awg lawn ghod ver, mig gig chaw yad teq pa awr lehr, mig gig chaw yad teq pa haq cawd daq tug te vix che awr lehr, Ghig sa ve awg ghiz yad teq pa haq keh te vix che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kheh te lehq, ngag nig hehd haq koz ax laq, mig gig-aq lo cawg che phu si muhd jeg haq yehd lehq awg chawd te daq lar. Awg lawn ghod ver, phu si muhd jeg u ve peg vehr khaz nuhr ver, muhd nuh kawag lo Ghig sa nawg haq haq yug ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","A cehax lehax te che haq thed che chaw teq pa awr lehr, kha peh vad-ag te che haq liz te thed tug yaog. Kanx nehax khuhn te lehq ma thed che chaw teq pa awr lehr, kanx nux maz khuhn te liz ma thed tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kheh te lehq, mig gig-aq lo ve phu si muhd jeg haq liz nig hehd ma thed ma cawd ver, awg cehg mag muhd nuh kawag lo ve med nged jeg kor a sug nig hehd haq chid aq ax ghag le. ");
INSERT INTO lhi_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nig hehd teq pa su ved med nged haq ma thed ma cawd ver, a sug nig hehd ve med nged nig hehd haq ca aq ax piar le. ");
INSERT INTO lhi_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Awg ceg khar ve te ghad lehd ma koz, jawd mawd ni ghad ve awg ceg te maq gha hawg. Awg lawn ghod ver, te ghad haq cand ver, te ghad haq haq tug yaog. Ma hez ver, te ghad haq yawz yan ver, te ghad haq maq sawnr ma caz te tug yaog. Nig hehd liz Ghig sa ve awg ceg loar, phu si muhd jeg ve awg ceg loar teq geha te maq gha hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Phar rir sehd teq pa awr lehr, i hehd phu si haq sex lae che chaw te lehq, tawd khuhd u ve haq gha kad che te yand, Yer suq haq i hehd koz gid ghig gid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yer suq i hehd haq koz vid che, “Nig hehd awr lehr, chaw yad ve mehz khuhd suhr huh ver, a sug yawd awg ton thed che cawd che heh te liz, Ghig sa awr lehr, nig hehd ve ni ma haq sir che yaog. Awg lawn ghod ver, chaw yad tar ir che awg ceng haq awr lehr, Ghig sa ngawx bawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Awg lid tawd khuhd he lehq Ghig sa ve cuh kar var teq pa ve tawd khuhd awr lehr, Yod hanr ve awg coaq lehax gag che yaog. U ve khaz nuhr lag cheawg lehr, Ghig sa ve muhd mig awg lawn ha lehg che bon khuhd mar vid lehq, chaw awg gha lia muhd mig u ve khuhn biz daq caq daq gehe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mig gig muhd nuh maq lug vehr paz vehr cheaq keh, awg lid tawd khuhd liq khuhn ve awg maex nehax ted mag lug vehr mehx vehr tug vawr har jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","A sug yawd mid ma haq chid bag lar haz lehq awg nuz awr ve yad mid haq ca he che chaw teq pa awr lehr, hax chawd hax paz te che yaog. Awg phad mawd chid bag vehr che yad mid haq ca he che chaw teq pa liz hax chawd hax paz te che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Te pawz thad huh, paw sa var te ghad yawd awg phuhd khaz che poq sar pha awg naz miax te che haq veq lehq, ni gha lia thi cad thi dawg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Yawd ved yehg kho ghaz mir khuh pad huh, awg ton tad laod pawd ma kox lehax te che ca lawg cad var Lar sar ruq meh che te ghad haq su taz vea lehq teh lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yawd awr lehr, paw sa var u ve cad sez dawg sez lar che teh cuh huhx uh ve cad tug ca ghawz cad gad che yaog. Phid teq pa liz yawd ved pawd ma kox haq sawz lehq chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Teq ni awr gaeg lehq, har ghuhd jad lehq lawg cad var u ve phad suh vehr che yaog. Kheh te lehq, muhd nuh maq cuh yad teq pa lag sir ve lehq, Ar brar hanr pad huh muhd nuh kawag lo chehd vid vehr che yaog. Paw sa var u ve liz suh vehr lehq, su yawd haq taz tur vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Muhd naz hoq khuhn, paw sa var u ve yawd gha tuq gha khanr jad che te yand, yawd kuhr ca chid ngawx pe lehq, Ar brar hanr he lehq Lar sar ruq ix mag vid-aq lo chehd lehq Lar sar ruq liz Ar brar hanr pad huh chehd chehd che haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kheh te lehq, yawd huh kug lehq koz che, ‘A pa Ar brar hanr-og, ngag haq a cehax har kax laoq. Ngag awr lehr, a mir che khuhn gha tuq gha khanr jad cheaq te lehq, Lar sar ruq yawd ved laq nuh med a kaz khuhn tiz ke lar haz lehq ngag ved ha lez gawg vid tug a cehax ca te pea viad laoq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kheh te lehq Ar brar hanr kawq koz che, ‘Yad par-og, nawg teq chehd thad huh daq che awg ceng teq pa haq lehax nawg gha lehq, Lar sar ruq vawr, mad daq che awg ceng teq pa haq lehax gha che haq nawg duhd nuhd-oq. A meha chuhr huh awr lehr, yawd duhd sa gad sa che khuhn gha chehd lehq, nawg awr lehr, tuq che khanr che khuhn gha chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Lex lehq, a nig teq pa awg kanr huh lawg khoq nax maq nux cawg che yaog. Kheh te cheaq te lehq, ngag hehd chehd huh ve liz nig hehd chehd lo lag mad gag. Nig hehd chehd lo ve liz ngag hehd chehd huh lag mad gag hawg,’ lehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Paw sa var kawq koz che, ‘Kheh te ver, A pa-og, nawg geh ngag che kheh lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ngag nax var ngad ghad cawg ser hawg. I hehd teq pa tuq che khanr che chehd kig che ve huh maq gha lag tug, Lar sar ruq haq ngar pa yehg lo kae pe lehq i hehd haq kha nehax ca mar vid pe ser,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ar brar hanr kawq koz che, ‘I hehd geh Mod ser he lehq Ghig sa ve cuh kar var teq pa ve tawd khuhd cawg chehd che yaog. Tawd khuhd u ve teq pa haq i hehd teq pa na yug vid-oq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Paw sa var kawq koz che, ‘U vea lehax mad lawq ser hawg. A pa Ar brar hanr-og, suh lar haz lehq kawq teq tuag che te ghad i hehd chehd lo kae ver, i hehd vend bax duhd phuhz tug yaog,’ lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ar brar hanr kawq koz che, ‘Mod ser he lehq Ghig sa ve cuh kar var ve tawd khuhd haq i hehd maq na yug ver, suh kig lo chaw te ghad kawq teq tuag liz, i hehd ca yonr tug ma hez,’ lehz kawq koz vid che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yer suq yawd ved awg laq ghuhd teq pa haq kawq koz vid che, “Su te yaq tug awg ceng vawr cawag tug yaog. Kheh liz su te yaq vid tug te che chaw teq pa awr lehr, gha lug gha sez jad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Chaw te ghad, chaw yad nehax teq pa te ghad ghad te yaq vid tug te cheaq keh ver, yawd haq yug lehq cag kha mia giz tug huhx meh mawr yawd ved kuhr pehg haq pheh ku li lehq, ghig nuh maq khuhn chid bag ke che awr lex lehq daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nig hehd teq pa kha nehax heog. Nawg vix nawg nax teq pa nawg haq te yaq ver, yawd haq mar vid-oq. Yawd vend bax haq duhd phuhz vehr ver, yawd ved vend bax haq phehd vid-oq. ");
INSERT INTO lhi_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Teq ni awg khuha lehax suhr pawz kha gag nawg haq te yaq lehq, suhr pawz pawz ax nawg chehd lo kawaq lehq, ‘Ngag vend bax haq duhd phuhz vehor,’ lehd koz ver, nawg yawd haq vend bax phehd vid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kheh te lehq, cuh yad teq pa Jawd mawd Yer suq haq koz vid che, “Ngag hehd teq pa yonr che ted ceng cawg mad-ag tug a cehax tea laoq,” lehz yawd geh lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jawd mawd Yer suq kawq koz che, “Nig hehd yonr che ted ceng ghawd pheh yuhd nehax kheh hia liz cawg heh ver, puhd cehg nux che ve haq, ‘Awg chi loar saw ghawg ve lehq ghig nuh maq lo ca cuhz-eq lor,’ lehd koz vid liz te pawaz lehax nig hehd koz vid che heh na vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nig hehd ve awg ceg te ghad ti mi lo ti mi thehox kawaq la, ma hez ver yawg ca huhx kawaq ver, ‘Har naq awr teq geha mi cad laoq,’ lehd koz vid che nig hehd teq pa awg khuhn a sug te ghad cawg hawg le. ");
INSERT INTO lhi_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ma hez ver, awg ceg var u ve haq koz vid che, ‘Kanx te tug beg ke kha nehax veq lar lehq, ngag awg pun cad tug ca te lor. Ngag haq hanr car hanr tawa lehq ngag cad buhz dawg buhz vehr nuhr heh, nawg kawq cad kawq dawg lehd koz vid tug ma hez hawg la.’ ");
INSERT INTO lhi_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Awg ceg var u ve awg sehr phad koz che heh te cheaq te lehq, awg sehr phad yawd haq chid muh vid tuawg la. ");
INSERT INTO lhi_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","U ve heh te lehq nig hehd teq pa liz, nig hehd haq kha cuha che awg ceng gha lia haq saw te peg ver, che kheh koz cawd che yaog. ‘Ngag hehd awr lehr, maq kenr che awg ceg teq pa yaog. Ngag hehd gha te cawd che kanx teq pa kheh tawa ngag hehd te lar che yaog.’” ");
INSERT INTO lhi_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yawd Yer ruq sar lehnr med lo kae tod che awg yand khuhn, Sar mar riq muhd mig he lehq Gar liq lehd muhd mig awg cuhx kanr phanr kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Khaz te khaz awg khuhn Yer suq gehe che te yand, khir tuq kex che chaw teq chi ghad vid-ag lo chehd lar lehq yawd haq ca mawg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","I hehd teq pa awg khuhd pehz hehnd mehz te kug lehq koz che, “Jawd mawd Yer suq-og, ngag hehd haq a cehax har kax laoq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yer suq i hehd haq mawg lehq koz che, “Nig hehd teq pa kae lehq, Ghig sa ve paw khod teq pa haq awg ton ca maw vid-eq,” lehd koz vid che yaog. Kheh te lehq, i hehd kae tod-ag huh, i hehd teq pa na vehr lehq awg daq maq phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Awg mor u ve khuhn chehd che chaw te ghad awr lehr, yawd awg ton na vehr che haq yawd gha siar che te yand, yawd kaw kawaq lehq awg khuhd pehz hehnd mehz kug lehq Ghig sa haq chid ir chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Yer suq ve khi pad huh mehz khuhd miaq lo boz cuhx lar lehq yawd ved bon haq chid muh che yaog. Chaw u ve te ghad awr lehr, Sar mar riq chaw yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kheh te lehq Yer suq koz che, “Na vehr che chaw teq chi ghad ma hez hawg la. Kuhg ghad khar lo veh cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Khawd-ehg te cheawg le. Lawd kir yad te ghad ma hez ver, kawaq lehq Ghig sa haq kawq chid ir chid muhag che chaw mad cawg vehr cheawg la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Peg lehq Yer suq yawd haq koz vid che, “Tu lehq koeq lor. Nawg yonr che haq te lehq, nawg ved a nar na vehr che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ghig sa ve muhd mig khar thad lag tug awg lawn Phar rir sehd teq pa na ngawx lehq, Yer suq koz che, “Ghig sa ve muhd mig lag che awr lehr, mehz sir ngawx lehq mawg gha che ted ceng ma hez hawg. ");
INSERT INTO lhi_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","‘Ngawx lag, chuhr huh cawg che yaog,’ ma hez ver, ‘O lo cawg che yaog,’ lehz chaw te ghad-eg liz koz ax maq gha hawg. Awg lawn ghod ver, Ghig sa ve muhd mig awr lehr, nig hehd awg khuhn cawg chehd che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Awg laq ghuhd teq pa haq yawd kawq koz vid che, “Chaw yad ve Yad phu lag tug haq nig hehd mawg gad che awg yand cawag tug yaog. Kheh liz, nig hehd gha mawg tug ma hez. ");
INSERT INTO lhi_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","‘Chor lo ngawx lag,’ ma hez ver, ‘O lo ngawx lag,’ lehz su nig hehd haq koz ax tug yaog. Kheh liz, nig hehd i hehd teq pa koz ax che awg khad haq tad ghaq kae. ");
INSERT INTO lhi_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Awg lawn ghod ver, muhd pehq cheawg lehr, muhd teq cir lo pehq liz teq cir lo awg ghiz thi gag che heh te lehq, Chaw yad ve Yad phu liz, yawd yaq che awg ni u ve haq sur daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kheh ma khuhd, u kheh maq te ser huh yawd awr lehr, tuq che khanr che laex ceng haq gha khanr lehq a meha teq co ve chaw teq pa chid bag che haq liz gha khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nod ar ve awg coag te lar haz che heh te lehq, chaw yad ve Yad phu ve awg co khuhn liz u kheh lag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nod ar huh lawd kor khuhn gehe che teq ni kha gag, i hehd cad chehd dawg chehd lehq, awg phad mawd awg mid ma he daq chehd che yaog. Awg yand u ve khuhn a kaz thur lehq, chaw saw suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lawd tar ve awg coaq liz u ve heh te che yaog. I hehd cad chehd dawg chehd che, med nged vig daq pa daq chehd che, mig cad vad cad lehq, yehg te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kheh ma khuhd, Lawd tar Sawd donr med khuhn tuhz vehr che teq ni haq, muhd nuh kawag lo a mir he lehq kang dig che yaq lehq, i hehd teq pa awg gha lia haq saw te lug vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Chaw yad ve Yad phu tuhaz che awg ni haq gaeg ver, u ve heh lag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Awg ni u ve khuhn, yehg thag lo chehd che chaw a sug yawd ved yehg khuhn med nged cawg chehd ver, taq ca yaq yug laoq. U ve heh te lehq ha khuhn chehd che chaw liz, tad koeq. ");
INSERT INTO lhi_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lawd tar ve awg mid ma haq duhd nuhd-oq. ");
INSERT INTO lhi_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","A sug yawd ved a saq pong tug te che chaw khar ve te ghad lehd ma koz, yawd ved a saq gha sond tug yaog. A sug yawd ved a saq sond che chaw khar ve te ghad lehd ma koz, yawd ved a saq gha pong tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ngag nig hehd haq koz ax laq, u ve teq hax khuhn haw khaz ni ghad teq geha yuhq phi ted mag khuhn lehax yuhq chehd liz, te ghad haq sir ve lehq, te ghad haq lehax teh lar haz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Yad mid ni ghad teq geha huhx meh mawr haq cag kha mia giz chehd che liz, te ghad haq sir ve lehq, te ghad haq lehax teh lar haz tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kheh te lehq, awg laq ghuhd teq pa Yer suq haq na che, “Awg lawn che ve teq pa khar lo phehaq tuawg le.” Yawd kawq koz che, “Chaw suh khar lo cawg liz nag beg ngaz u huh chehd che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Awg laq ghuhd teq pa ni ma maq gha lug lehq khar thad liz bon lawg che awg ghad maq gha nud vid tug, Yer suq tawd par hax te mar vid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Med ted mag khuhn chehd che suhx taz var te ghad cawg che yaog. Yawd Ghig sa haq liz ma kuhz lehq chaw yad te ghad-eg haq liz ma yawz maq yan che chaw yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Med u ve khuhn meh chuhd ma te ghad cawg che yaog. Yawd suhx jehg suhx taz var u ve phad chehd lo te thawz te thawz lag lehq kaod koz don chehd che, ‘Ngag haq kaod yaq chehd che awg lawn che ve teq pa thed che cawd che khuhn ngag haq a cehax jehg ax laoq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Yawd har naq mad jehg vid che yaog. Kheh liz, awg khaz nuhr yawd ni ma khuhn duhd che, ‘Ngag Ghig sa haq ma kuhz lehq chaw yad haq ma yawz yan liz, ");
INSERT INTO lhi_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","meh chuhd ma che ve ngag haq lag kaod soq saq cheaq te lehq, ngag yawd haq thed che cawd che khuhn har naq te vid sar. U kheh maq te vid ver, yawd khar thad liz, ngag ved ni ma haq lag kaod te soq saq don vehr tug yaog,’ lehd duhd che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kheh te lehq Jawd mawd Yer suq i hehd haq kawq koz vid che, “Ma thed ma cawd che suhx jehg suhx taz var ve ni ma khuhn liz che kheh duhd lehq che kheh koz che haq duhd ngawx-oq. ");
INSERT INTO lhi_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ghig sa lez yug lar che chaw teq pa, muhd kaw muhd khax yawd haq lawg khawx chehd ver, Ghig sa thed cawd che khuhn i hehd awg pun maq te vid tuawg la. Yawd pehz muh mehz law chehd leq tuawg la. ");
INSERT INTO lhi_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ngag nig hehd haq koz ax laq, thed che cawd che ted ceng yawd nig hehd awg pun har naq tea vehr tug yaog. Kheh ma khuhd, chaw yad ve Yad phu lag gag ver, mig gig-aq lo yonr che ted ceng cawg chehd che haq gha mawg tuawg la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A sug yawd awg ton haq daq kehg thed cawd jad vehor lehd duhd lehq, su haq tar nehg che teq pa haq Yer suq tawd par hax te mar vid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Chaw ni ghad bon laweg tug Yer ruq sar lehnr bon yehg nux lo taez che yaog. Te ghad awr Phar rir sehd, te ghad awr awg khawnr saw var yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Phar rir sehd te ghad tu hox lar lehq ni ma khuhn bon lawg che, ‘Ghig sa-og, ngag awr lehr awg kag awr ve chawaq maq sur cheaq te lehq, nawg ved bon haq chid muh che yaog. I hehd teq pa awr lehr, su ved ca lu yug hinx yug che chaw, ma thed ma cawd che chaw, hax chawd hax paz te che chaw teq pa yaog. Lex lehq ngag awr lehr, awg khawnr saw var che phad haq liz maq sur ax cheaq te lehq, nawg haq chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Teq sinx awg khuhn nig ni ngag cad tug ce che yaog. Ngag kha ca gha che awg khuhn teq chi pun teq pun tand che yaog,’ lehd koz lehq yawd bon lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kheh ma khuhd, awg khawnr saw var te ghad vawr, vid-ag lo hox lar lehq muhd-aq lo liz kuhr chi ngawx mad phehq lehq duhd har jad che khuhn yawd ved ni ma pi huh tha lar lehq, ‘Ghig sa-og, ngag vend bax ir jad che haq a cehax har kax laoq,’ lehd koz lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kheh te lehq, ngag nig hehd teq pa haq koz ax laq, awg khawnr saw var che phad awr lehr, yawd ved yehg lo koeq che te yand, Ghig sa mehz khuhd suhr chaw daq chaw thed phehaq che yaog. Phar rir sehd vawr, thed che cawd che chaw mad phehq. Awg lawn ghod ver, a sug yawd awg ton haq tar ir che chaw teq pa awr lehr, tar nehg cheaq gha khanr che yaog. A sug yawd awg ton haq tar nehg che chaw teq pa awr lehr, tar ir cheaq gha haq yug che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Chaw yad nehax teq pa haq Yer suq vad lar lehq bon naq vid tug, su yawd chehd lo sir vea lag che yaog. Awg laq ghuhd teq pa u ve haq gha mawg lehq, sir vea che chaw teq pa haq ded che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kheh te lehq, Yer suq chaw yad nehax teq pa haq kug lehq koz che, “Chaw yad nehax teq pa ngag chehd lo lag pea vid. I hehd haq taq tawr chuhd. Awg lawn ghod ver, Ghig sa ve muhd mig awr lehr, chaw yad nehax u ve teq pa heh te che chaw ve muhd mig yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ngag nig hehd haq awg cehg mag koz ax laq, chaw yad nehax teq pa heh te lehq, Ghig sa ve muhd mig haq mad haq yug che chaw a sug te ghad lehd ma koz, yawd ved muhd mig awg khuhn maq gha gehe hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Bon phawd awr ve awg hox jawd mawd te ghad, yawd haq na che, “Daq jad che Sar lar-og, co tiq ha tiq haq gha tug ngag khawd-ehg kheh gha te lawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yer suq kawq koz che, “A thoq te nawg ngag haq daq jad che lehd koz cheawg le. Ghig sa te ghad ma hez ver, daq jad che te ghad-eg liz mad cawg hawg. ");
INSERT INTO lhi_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Awg lid tawd khuhd teq pa haq nawg sir che yaog. ‘Hax chawd hax paz taq te, chaw haq ta dawz vehr, su ved med nged ta khuhd, su haq ma hez hez che awg ceng sax khiz taq khanr, nawr ye nawr pa haq yawz yawz yan yan teo,’” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Chaw u ve phad koz che, “Awg ceng che ve teq pa vawr, ngag chaw yad nehax te chehd ser thad loar saw na yug lehq te peor,” lehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yer suq tawd khuhd u ve haq gha kad lehq yawd haq koz vid che, “Nawg ted ceng lor ser che yaog. Nawg kha cawg che med nged jeg kor teq pa haq ca huhd lehq, har yad ghuhd yad teq pa haq ca pehg vid-oq. Muhd nuh kawag lo med nged awg phuhd khaz che awg ceng nawg cawg lar tug yaog. U kheh te lar haz lehq, nawg vawr kawaq lehq ngag khaz nuhr ghaq laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Chaw u ve, yawd tawd khuhd u ve haq gha kad che te yand, yawd duhd har jad che yaog. Awg lawn ghod ver, yawd paw sa jad che chaw te ghad te lehq. ");
INSERT INTO lhi_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yer suq chaw u ve phad duhd har jad cheaq gha mawg lehq yawd koz che, “Paw sa che chaw teq pa awr lehr, Ghig sa ve muhd mig khuhn gehe tug har jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Awg lawn ghod ver, kar lar oq teq kheh ghoq nar khuhn gehe che vawr, paw sa var te ghad Ghig sa ve muhd mig khuhn gehe tuaq keh sa che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tawd khuhd che ve haq gha kad che chaw teq pa koz che, “Kheh te ver, a sug te ghad thaer khuhq cheaq gha tuawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yawd kawq koz che, “Chaw yad te maq gha che awg ceng teq pa haq Ghig sa te gha che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Per troq koz che, “Kheh te ver, Ngag hehd awr lehr, awg ceng gha lia saw teh lar haz lehq nawg khaz nuhr lag tod vehr che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yer suq kawq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, Ghig sa ve muhd mig awg pun, a sug yawd ved yehg, a sug yawd ved awg mid ma, a sug yawd ved a vix a nax, a sug yawd ved awr pa awr ye he lehq a su yawd ved awg yad awg dug teq pa haq teh lar haz che chaw khar ve te ghad lehd ma koz, ");
INSERT INTO lhi_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","a meha ve teq co haq loar, u veaq keh lex lehq kawq gha nuhr, lex lehq awg khaz nuhr ve teq coaq lo liz co tiq ha tiq haq gha tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yer suq yawd ved awg laq ghuhd teq chi ni ghad haq kug lehq koz vid che, “A nig Yer ruq sar lehnr med lo kae tod che yaog. Chaw yad ve Yad phu awg lawn Ghig sa ve cuh kar var teq pa kha buhq lar che awg gha lia phehaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Awg lawn ghod ver, yawd haq lawd kir yad teq pa ve laq khuhn chid aq vid lehq, su koz gid ghig gid che, maq sawnr ma caz te che he lehq cux ghig pheq puhr cheaq gha khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Su yawd haq jawq peg ver, dawz vehr tug yaog. Kheh te peg lehq sehr ni teq ni gaeg ver, yawd kawq teq tuag tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kheh ma khuhd, awg lawn che teq pa haq i hehd a cehax liz maq sir. I hehd haq koz vid che tawd khuhd che teq pa awr lehr, i hehd haq cuhx kig khuhd ceh lar vid cheaq te lehq, yawd koz chehd che haq i hehd na maq gha. ");
INSERT INTO lhi_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yer suq lag lehq Yer riq khod med pad huh gaeg che te yand, mehz cox var te ghad yaq kaw pad huh mi lar lawg cad chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mehz cox var u ve chaw mor nux phanr veh che khuhd haq gha kad lehq, su haq a thoq maq te cheawg le lehd koz na che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Nar sar rehq chaw Yer suq phanr veh tod che yaog,” lehz su yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kheh te lehq yawd kug lehq koz che, “Dar viq ve Yad phu Yer suq-og, ngag haq a cehax har kax laoq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yawd mehz khuhd suhr veh tod che chaw teq pa awr lehr, “Taq chuhax chehd-oq,” lehd koz lehq yawd haq ded vid liz, “Dar viq ve Yad phu-og, ngag haq a cehax har kax laoq,” lehd koz ghaq te ghaq hehnd hax ceh kawq kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yer suq jehd lehq hox lar koz che, “Yawd haq ngag chehd lo sir vea laor,” lehd koz vid che yaog. Mehz cox var u ve yawd pad huh lag gag lehq Yer suq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nawg haq ngag a thoq tea vid gad lehq le,” lehd koz na ngawx che yaog. “Jawd mawd-og, ngag mehz mawg gha tug nawg tea vid gad che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yer suq kawq koz vid che, “Mehz mawag vid-oq. Nawg yonr che ted ceng haq te lehq, nawg na vehor,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Chaw u ve phad teq pear lehx mehz mawag lehq, Ghig sa haq seh chid ir seh chid muh lehq Yer suq khaz nuhr ghaq veh che yaog. Chaw awg gha lia u ve haq gha mawg lehq, Ghig sa ve bon haq chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yer suq awr lehr, Yer riq khod med khuhn gehe lehq tod phanr vehr tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Med u ve khuhn paw sa jad che awg khawnr saw var awg hox Sar kehd meh che te ghad phad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yer suq khar ve te ghad lehq na lehz yawd mawg gad lehq ca ngawx-eg liz, chaw mor nux kha peh te lehq, yawd awg ton maq muh lehq ngawx mad mawg. ");
INSERT INTO lhi_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Awg lawn ghod ver, Yer suq yaq kaw u ve haq lag tod cheaq te lehq, Yer suq haq gha mawg tug yawd awg ghud med awr cex kae lehq nuhg cehg ted cehg haq taez che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yer suq lag lehq u huh gaeg che te yand, yawd haq kuhr chid ngawx lar lehq koz vid che, “Sar kehd-og, har naq yaq laoq. Yaq ni ngag nawg ved yehg lo gha ca hax-eg tug yaog,” lehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Kheh te lehq, Sar kehd har naq yaq lehq ha lehg ha ka yawd haq haq yug vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","U kheh te cheaq su gha mawg che te yand Yer suq haq ca khaex lehq koz che, “Yawd vend bax yad te ghad ve yehg lo ca hax-eg che law,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sar kehd tu lehq Jawd mawd Yer suq haq koz vid che, “Jawd mawd-og, ngag ved med nged jeg kor awg gha lia te khod chaw har chaw ghuhd teq pa haq pehq vid tug yaog. Chaw te ghad ghad ve med nged haq ngag pha yax te lar cawd ver, uhd pun kheh taw ngag kawq khuhq vid tug yaog,” lehz Jawd mawd Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yer suq kawq koz vid che, “Yehg che ted mag awg khuhn yaq ni thaer khuhq che ted ceng lag gag vehor. Awg lawn ghod ver, yawd liz Ar brar hanr ve yad te ghad yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Chaw yad ve Yad phu awr lehr, mehx vehr che chaw teq pa haq ca lehq thaer khuhq vid tug lag che yaog,” lehz Sar kehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tawd khuhd u ve teq pa haq i hehd teq pa na chehd-ag huh, Yer suq yawd i hehd teq pa haq tawd par hax kawq te mar vid che yaog. Awg lawn ghod ver, yawd Yer ruq sar lehnr med pad huh gag vehr cheaq te lehq, Ghig sa ve muhd mig awr lehr, maq muh tand ver gha mawg vehr tug law lehz i hehd duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","U kheh te lehq yawd koz che, “Jawd mawd ve awg ceng awg khad te ghad, yawd jawd mawd te tug a yad vid kig muhd mig te pez lo ca yug vea kawaq tug yawd ka veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yawd maq kae ser huh, yawd ved awg ceg teq chi ghad haq kug yug lehq i hehd haq phu te ghad ve ted cawehg pid lehq koz vid che, ‘Ngag kawaq gag thad kha gag phu che yug ve lehq tad kag ca te mehr,’ lehz i hehd haq koz vid lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kheh ma khuhd, yawd ved muhd mig yad teq pa yawd haq cand lehq, i hehd ve awg tan te var yawd khaz nuhr ghaq kae pe lehq, ‘Chaw che ve phad haq ngag hehd ve jawd mawd te lehq, ngag hehd haq uq penr vid tug ngag hehd maq he gad,’ lehd ca koz vid pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Yawd jawd mawd te tug a yad gha vea kawaq lehq, yawd phu pid lar haz che awg ceg var teq pa tad kag te che awg mehaq gha maq gha che haq sir gha tug, i hehd teq pa haq ca kug pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Awg kawd ve te ghad lag lehq koz che, ‘Jawd mawd-og, nawg ved phu ted cawehg haq yug lehq ngag ca kag che teq chi cawehg kawq gha che yaog,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Awg jawd mawd kawq koz vid che, ‘Daq che awg ceg var-og, nawg te lar cheawg lehr, daq vehr che yaog. Awg ceng nehax haq loar nawg thed cheaq te lehq med teq chi kag haq uq penr lor,’ lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ni ghad te ghad lag lehq koz che, ‘Jawd mawd-og, nawg ved phu ted cawehg haq ngag yug ve lehq ca kag che, ngad cawehg kawq gha che yaog,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Awg jawd mawd awg ceg var haq kawq koz vid che, ‘Med ngad kag haq nawg uq penr lor,’ lehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Seh ghad te ghad lag lehq koz che, ‘Jawd mawd-og, ner, nawg ved phu ted cawehg che ve haq ngag pha khuhn kha nehax thiz lehq teh lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nawg vawr, te hehnd jad che chaw te ghad te lehq, ngag nawg haq kuhz che yaog. Nawg ved maq teh lar kig lo liz nawg saw yug lehq, nawg maq gha ser lar kig lo liz nawg ghiq yug che yaog,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kheh te lehq, awg jawd mawd kawq koz vid che, ‘Haeg che awg ceg var-og, nawg koz lar che tawd khuhd haq ngag yug lehq suhx jehg suhx taz ax tug yaog. Ngag awr lehr, te hehnd jad che chaw te lehq, ngag maq teh lar kig lo liz saw yug lehq maq ser lar kig lo liz ghiq yug che haq nawg sir chehd ver, ");
INSERT INTO lhi_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","a thoq te ngag ved phu che ve yug ve lehq, phu chid vid kig phu thawnr khuhn maq ca ke lar cheawg le. U kheh ca te lar heh ver, ngag kawaq ver, ngag ved phu haq liz gha lehq awg mehaq liz kawq gha tug yaog,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kheh te lehq, awg pad huh hox chehd che chaw teq pa haq yawd koz vid che, ‘Yawd geh cawg che phu u ve ted cawehg haq yug khuhq lehq, phu teq chi cawehg cawg che phad haq pid-oq,’ lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Chaw u ve teq pa koz che, ‘Jawd mawd-og, yawd phu teq chi cawehg cawg vehr cheawg,’ lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Ngag nig hehd haq koz ax laq, cawg chehd che chaw teq pa haq kawq ke thehnr vid tug yaog. Mad cawg che chaw teq pa geh, cawg chehd ser che liz kawq yug ve tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kheh te lehq, ngag ved cand par ngag haq i hehd ve jawd mawd maq te cuha gad che chaw teq pa haq, chuhr ngag mehz khuhd suhr huh yug vea dawz vehr laoq,’ lehd koz vid tug yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yer suq u kheh koz peg lehq, yawd Yer ruq sar lehnr med lo kawq taz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yawd lag lehq Sar lonr keh pad huh cawg che Ber phar ger khaz he lehq Ber tar niq khaz huh gaeg che te yand, awg laq ghuhd ni ghad haq kae pe lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Nig mag mehz khuhd suhr huh cawg chehd che khaz u ve khuhn gehe. U gehe ver, chaw te ghad-eg liz ma cind jaw ser che pix lar nehax pheh teh lar che haq nig mag gha mawg tug yaog. Phi lehq chuhr huh seh vea kawq lag. ");
INSERT INTO lhi_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nig mag haq su te ghad ghad lag lehq, ‘A thoq te phi cheawg le,’ lehd koz na ver, ‘Jawd mawd lor che yaog,’ lehd kawq koz vid-oq,” lehz ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Awg laq ghuhd u ve ni ghad kae che te yand, Yer suq koz lar che heh saw te chehd lawz cheaq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ix mag kae lehq pix lar nehax haq phi chehd-ag huh, awg sehr phad ca na-ag che, “A thoq te pix lar nehax haq phi kha chehd cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Jawd mawd lor che yaog,” lehz ix mag kawq khuhq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kheh te lehq, ix mag pix lar nehax u ve Yer suq chehd lo seh vea lag lehq, pix lar nehax cuhq thag huh a poq kuhz kaq vid peg lehq Yer suq haq cind cuh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yawd cind ve lehq kae tod che te yand, yawd kae tod che yaq kaw u ve haq med yad teq pa a sug yawd ved a poq kuhz lehq khawd vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yawd lag lehq Sar lonr kehaq lo yaeq che yaq kaw kag thuhd thawq penr gaeg lehq, awg laq ghuhd teq pa awg gha lia i hehd gha mawg lar haz che and tug teq pa haq ha lehg ha ka te lehq, hax ceh kug lehq Ghig sa haq chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","I hehd koz che, “Jawd mawd Ghig sa ve awg meh khuhn lag che Jawd mawd te ghad awr lehr, awg bon ir vid-oq. Muhd nuh kawag lo duhd sa gad sa che cawg vid-oq. Muh jad kig lo liz awg mig awg phond cawg vid-oq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chaw mor nux u ve khuhn chehd che Phar rir sehd ted pehg Yer suq haq koz vid che, “Sar lar-og, nawg ved awg laq ghuhd teq pa haq, ‘U kheh ta koz,’ lehd koz vid-oq.” ");
INSERT INTO lhi_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kheh te lehq, yawd kawq koz vid che, “Ngag nig hehd haq koz ax laq, chaw che ve teq pa taq chuhax chehd vehr liz huhx meh dig che teq pa kug tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Med awg pad lo gaeg che te yand, med haq gha mawg vehr lehq yawd huhg lar koz che, ");
INSERT INTO lhi_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Khawd-ehg te lehq nawg gawr ghad gha chehd tug haq yaq ni nawg sir heh ver daq jad tug yaog. Kheh ma khuhd, a meha awr lehr gawr ghad gha chehd tug ted ceng awr lehr, nawg ved mehz khuhd suhr huh khuhd ceh lar vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Awg lawn ghod ver, nawg ved cand par teq pa nawg jad huh taq dud lehq, nawg haq kha caw yuhd awg phawd gha lia saw caw hoz che awg ni cawag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kheh te lehq, nawg awr lehr nawg awg khuhn chehd che nawg ved awg yad awg dug teq pa haq su miaq lo yug chid bag lar haz tug yaog. Nawg awg khuhn huhx meh ted dig thag huh ted dig mad cawg lar haz thad kha gag su te lug vehr lar haz tug yaog. Awg lawn ghod ver, Ghig sa yaq tug awg yand nig hehd maq sir cheag te lehq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kheh te lehq, yawd Yer ruq sar lehnr bon yehg nux khuhn gehe lehq med nged huhd chehd che chaw teq pa haq ghaq kog che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yawd koz che, “Ngag ved yehg haq bon lawg kig yehg te tug yaog, lehz Liq phu khuhn buhq lar liz, nig hehd vawr yehg che ve haq chaw khuhd chehd kig yehg yug te vehr che law,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yawd Yer ruq sar lehnr bon yehg nux khuhn ni gha lia mar vid chehd che yaog. Ghig sa ve paw khod nux teq pa, liq buhq var teq pa he lehq Yud daq chaw ve awg hox awg nax teq pa yawd haq dawz vehr khad ca che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kheh ma khuhd, i hehd khawd-ehg te liz dawz vehr tug awg khad ca mad mawg. Awg lawn ghod ver, chaw gha lia yawd mar che khuhd haq na gad jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Teq ni thad huh, Yer suq Yer ruq sar lehnr bon yehg nux khuhn chaw kha peh haq mar vid lehq ha lehg che bon khuhd mar chehd-ag huh, Ghig sa ve paw khod nux teq pa, liq buhq var teq pa he lehq awg hox chaw mawd teq pa teq geha lag lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Nawg khar lo kand pax gha lehq su med nged huhd chehd che haq ghaq kog cheawg le. A sug nawg haq kand pax pehar cheawg le. Ngag hehd haq liz a cehax koz ax laoq,” lehd koz na che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Kheh te lehq, Yer suq kawq koz che, “Ngag liz ni hehd haq tawd te khuhd na ngawx sar. Nig hehd kawq yaw khuhq ax ngawx ser. ");
INSERT INTO lhi_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yod hanr yawd baz tiz sar pid chehd che, muhd nuh kawag lo lag cheawg la, ma hez ver, chaw yad teq pa geh lag cheawg la,” lehz i hehd teq pa haq na che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","I hehd teq pa phoz jehg daq lehq koz che, “‘Muhd nuh kawag lo lag cheawg’ lehd koz ver, ‘Nig hehd a thoq te yawd haq maq yonr cheawg le,’ lehz yawd kawq koz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","‘Chaw yad teq pa geh lag cheawg’ lehd koz ver, chaw che ve teq pa a nig haq huhx meh ga bag vehr tug yaog. Awg lawn ghod ver Yod hanr awr lehr, Ghig sa ve cuh kar var awg lehz i hehd yonr che yaog,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kheh te lehq, i hehd teq pa yawd haq kawq koz vid che, “Khar lo lag che nar ngag hehd maq sir,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kheh te lehq, Yer suq liz i hehd haq koz vid che, “Ngag liz kand pax khar lo lag lehq kanx che kheh te che, nig hehd heh te lehq ma koz ax hawg,” lehz i hehd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Kheh te lehq, Yer suq chaw awg gha lia haq tawd par hax che kheh te mar vid che, “Chaw te ghad phad yawd a pehx med kho te lehq saw kha ke lar haz lehq, su kho te cad var teq pa haq awg phuhd kawq ghawz cad tug ngar vid lar haz lehq, awg bag muhd mig lo muh chawa ca chehd tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Awg yand gaeg che te yand, kho ngar te var chehd lo yawd gha cawd che awg sir awg no ca ghawez tug, yawd ved awg ceg var te ghad kae pe che yaog. Kho ngar te var u ve awg ceg var u ve haq ghawg phuhz dawz lehq, teq chaweh ma pid lehq ghaq kawq pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Awg khaz nuhr te pawz, yawd ved awg ceg var te ghad i hehd chehd lo kawq kae pe che yaog. U ve te ghad haq liz ghawg phuhz dawz lehq kha muhd kha na kaod te gid peg lehq, awg ton kawad kawq pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kheh te lehq, awg ceg var seh ghad te ghad haq yawd kawq kae pe che yaog. U ve te ghad haq liz ghawg dawz nag vid peg lehq ghaq kog vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kheh te ver, kho sehr phad koz che, ‘Ngag khawd-ehg kheh te ver cawd tuawg le. Ngag haq che yad par haq ngag kae pe sar. I hehd teq pa yawd haq yawz yan vawd gha hawg,’ lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kheh ma khuhd, kho ngar te var u ve teq pa, yad par u ve haq gha mawg lehq koz daq che, ‘Chaw cheawg lehr, awg sinx gha var te ghad yaog. Laor, yawd ved awg sinx a nig gha tug yawd haq dawz vehar veg,’ lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kheh te lehq, i hehd yawd haq kho awg bag lo ghawg ve lehq dawz chid bag vehr che yaog. Kheh te cheaq te lehq, kho awg sehr phad i hehd haq khawd-ehg te vid tuawg le. ");
INSERT INTO lhi_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yawd lag lehq, kho ngar te var teq pa haq saw dawz vehr lehq, kho u ve yug lehq awg kag awg nuz awr ve chaw teq pa haq kawq ngar vid tug yaog,” lehz Yer suq koz che yaog. Tawd khuhd u ve haq gha kad lehq i hehd koz daq che, “U kheh te maq gha hawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kheh te lehq, Yer suq i hehd teq pa haq ngawx cuhx lar lehq koz vid che, “Yehg kawx var yehg bag lo ghawz chid bag lar che huhx meh dig awr lehr, awg cuhz penr awg cir huh kawx lar che a yed ir jad che huhx meh phehq vehor, lehd koz lehq Liq phu khuhn buhq lar che tawd che ve te khuhd a thoq haq koz gad cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Huhx meh u ve thag huh kuhd kaq che chaw awr lehr, khod lehq theh vehr tug yaog. Chaw a sug te ghad lehd ma koz, huhx meh u ve che kaq ver lehr, chaw u ve awg mi tehz veh tug yaog,” lehz Yer suq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Liq buhq var he lehq Ghig sa ve paw khod nux teq pa awr lehr, tawd par hax u ve te mar che i hehd haq koz chi chehd che yaog lehz gha sir che yaog. Kheh te lehq, awg yand u ve khuhn yawd haq pheh yug tug te che yaog. Kheh liz, su haq i hehd kuhz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yer suq haq muhd mig jawd mawd ve kand pax khuhn chid aq vid gha tug, i hehd chaw jaz phehd lehq, yawd tawd yaw yaq che haq ca gha tug chaw daq chaw thed heh te lehq yawd geh kae pe lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jaz ngawx par u ve teq pa koz che, “Sar lar-og, nawg vawr thed-e ghad mar vid koz vid lehq, chaw yad ve mehz khuhd haq liz maq ngawx che khuhn Ghig sa ve kanx khad haq thed-e ghad cawd aw ghad mar vid cheawg, lehz ngag hehd sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","A nig muhd mig jawd mawd nux Kehd sar haq awg khawnr ke vid cawd hawg la, maq ke vid cawd hawg la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kheh liz, Yer suq awr lehr, i hehd cud yiq te lehq khuhd na chehd che haq sir lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Phu ted thehq yug vea ngag ngawx-ag. A sug ved awg han, a sug ved awg meh cawg lehq nar,” lehd koz na ngawx gha mehx, “Muhd mig jawd mawd nux Kehd sar ve cawg che yaog,” lehz kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kheh te lehq, Yer suq koz che, “Kheh te ver, muhd mig jawd mawd nux Kehd sar ve med nged ver, muhd mig jawd mawd nux Kehd sar haq pid-oq. Ghig sa ve med nged ver, Ghig sa haq kawq khuhq pid-oq,” lehz kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Chaw mor nux mehz khuhd suhr huh yawd tawd yaw yaq kig haq ca maq gha. Kheh te lar, yawd yaw khuhq che tawd haq i hehd and lehq taq chuhax chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kawq teq tuag che mad cawg hawg ghod che Sar duq kehd chaw ted pehg pehar yawd chehd lo lag lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Sar lar-og, Mod ser ngag hehd awg pun che kheh koz buhq ax lar che, chaw te ghad awg mid ma ca lehq, yad mad cawg ser lehq suh vehr ver, awg nax var u ve awg vix var mid ma haq kawq he lehq awg vix var ve awg ceng awg khad gha cawg vid che yaog, lehd koz buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pong lag thad awg vix awg nax suhr ghad cawg che yaog. Awg vix kaog te ghad awg mid ma he lehq yad mad cawg ser huh suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ni ghad te ghad liz, ");
INSERT INTO lhi_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","seh ghad te ghad liz yad mid u ve haq he che yaog. Awg vix awg nax suhr ghad kha gag yad mid u ve haq he lehq yad mad cawg he lar haz lehq saw suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Awg khaz nuhr gaeg lehq, yad mid u ve liz suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kheh te cheaq te lehq, kawq teq tuag ver, yad mid u ve te ghad a sug mid ma te tuawg le. Awg lawn ghod ver, i hehd suhr ghad yad mid u ve haq saw he peg che yaog,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yer suq kawq koz che, “A meha mig gig cheaq chehd che chaw teq pa awr lehr, awg phad mawd awg mid ma he daq lehq na ka pawehd te che cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kheh ma khuhd, awg khaz nuhr ve teq coaq suh kig lo kawq teq tuag che ted ceng haq gha kenr che chaw teq pa awr lehr, awg phad mawd awg mid ma he daq lehq na ka pawehd te che mad kawq cawg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Suh kig lo i hehd teq pa kawq tea tuag vehr cheaq te lehq Ghig sa ve muhd nuh maq cuh yad heh phehq vehr che yaog. Suh che ted ceng i hehd khuhn mad kawq cawg vehr cheaq te lehq Ghig sa ve awg yad awg dug phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Suh vehr che chaw kawq teq tuag che awg lawn, Mod ser liz a chud bid haq a mir toq che awg lawn buhq thad huh pheq mar lar che yaog. Yawd awr lehr Jawd mawd Ghig sa haq, Ar brar hanr ve Ghig sa, Id caq ve Ghig sa he lehq Yar koq ve Ghig sa phehq che yaog, lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ghig sa awr lehr, suh vehr che chaw teq pa ve Ghig sa phehq che ma hez. Teq chehd che chaw teq pa ve Ghig sa phehq che yaog. Yawd haq te lehq, suh vehr che chaw awg gha lia teq chehd che yaog,” lehz koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Kheh te lehq, liq buhq var teq pa ted pehg koz che, “Sar lar-og, nawg koz cheawg lehr cawd jad vehr che yaog,” lehd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kheh te lehq, i hehd teq pa te ghad-eg liz, Yer suq haq kawq na ngawx maq pir vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kheh te lehq, yawd i hehd teq pa haq na lehq koz che, “Khreq awr lehr, Dar viq ve yad yaog, lehz a thoq te su koz cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Awg lawn ghod ver, Dar viq yawd awg ton koz che, ‘Jawd mawd Ghig sa awr lehr, ngag ved Jawd mawd haq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Nawg ved cand par teq pa haq nawg ved khi huhx lo nawg ved khi tar kig ngag yug tea peg thad kha gag, ngag ved laq yaq awr phawd awr lo mi laoq,’ lehz chid muh che liq khuhn koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Kheh te lehq, Dar viq liz yawd haq Jawd mawd lehd koz ver, khawd-ehg te lehq yawd ved yad te ghag le,” lehz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Chaw kha peh vad-ag phoz na chehd-ag huh, yawd awg laq ghuhd teq pa haq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Liq buhq var teq pa haq sa tiq kha nehax tar-oq. I hehd awr lehr, a poq yehg maq te che haq deh lehq ca te tod gad lehq kax khuhn lo liz, su i hehd haq yawz yan ax vid gad lehq bon lawg kig awg khuhn lo liz awg mig awg phond cawg che mi khuhd haq mi lehq thi cad thi dawg kig huh liz, awg mig awg phond cawg che mi kig haq lehax i hehd ca mi gad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Chaw che ve teq pa awr lehr, meh chuhd ma ve yehg liz pha yax te lehq, yawd ved vend bax maq gha tuhaz tug bon pehz muh mehz te lawg che yaog. Suaq keh lex lehq ir jad che toq haq i hehd teq pa gha khanr tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yer suq kuhr chid ngawx lehq bon yehg khuhn phu tand ke kig huh paw sa che chaw teq pa phu tand ke chehd che haq mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Har ghuhd jad che meh chuhd ma te ghad pehq sanr nid pehq ke che haq liz yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kheh te lehq yawd koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, har ghuhd che meh chuhd ma che te ghad awr lehr, suaq keh ke mad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Awg lawn ghod ver, su teq pa vawr cad lex yehd lex che teq pa yug vea ke che yaog. Kheh ma khuhd, yad mid che te ghad awr lehr, har ghuhd jad che khuhn yawd a saq hu tug teh lar che awg gha lia haq saw yug tuhz lehq ke vehr che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yer ruq sar lehnr bon yehg nux u ve haq daq jad ngawx sa jad che huhx meh sir haq yug te lehq tand tug med nged awg ceng yug tand che awg lawn haq chaw ted pehg koz daq che te yand Yer suq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Nig hehd gha mawg chehd che che teq pa awr lehr, huhx meh ted dig awg thang ted dig mad cawg gha thad kha gag lug vehr sez vehr tug awg ni gag tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","I hehd teq pa kawq koz che, “Sar lar-og, Yer ruq sar lehr bon yehg nux u ve lug vehr lehd te ver, awg ceng u ve teq pa khar thad phehaq lawg le. Phehaq lehd te ver, a thoq awg hez tuhaz lawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yer suq i hehd haq kawq koz vid che, “Su nig hehd haq pha yax maq gha te tug, sa tiq teo. Awg lawn ghod ver, chaw mad awr ve ngag ved awg meh haq puhd vea lehq, ‘Ngag awr lehr, yawd yaog.’ ‘Awg yand gag vehr tez-or,’ lehd koz tug yaog. I hehd koz che khaz nuhr tad ghaeq. ");
INSERT INTO lhi_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nig hehd teq pa maq bawz che he lehq muhd mig khuhn phuhz daq che awg lawn haq gha kad che te yand ta kuhz. Awg lawn ghod ver, awg ceng che ve teq pa awg kawd gha kex-ag ser tug yaog. Kheh ma khuhd, teq pear lehax awg leh med mad gag ser hawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kheh te lehq, yawd i hehd teq pa haq kawq koz vid che, “Chaw ceng ted ceng he lehq ted ceng, muhd mig te pez he lehq te pez yaq daq jiz daq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mig hax ceh nux hiz lehq, meq che kaz che he lehq a nar nag beg nux teq pa cawag tug yaog. Muhd nuh kawag lo kuhz tug ir jad che awg ceng he lehq awg hez teq pa tuhaz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kheh ma khuhd, awg ceng che ve teq pa maq kex-ag ser huh, su nawg haq pheh yug lehq tuq khanr cuha tug yaog. Bon lawg kig awg khuhn liz su nawg haq kug na kug jehg lehq, thawnr yehg teq pa khuhn liz su nawg haq yug ke huh tug yaog. Ngag ved awg meh haq te lehq, muhd mig phawd awr ve awg hox awg nax jawd mawd teq pa ve mehz khuhd suhr lo liz su nig hehd haq sir ve kae tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Awg ceng che teq pa haq nawg gha khanr che vawr, ngag awg lawn nawg sax khiz gha khanr tug awg pun te che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kheh te cheaq te lehq, nig hehd khawd-ehg kheh gha te gha koz tug ghod che haq ca duhd ngawx lar tug maq lor hawg. ");
INSERT INTO lhi_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Awg lawn ghod ver, nig hehd ve cand par teq pa awg gha lia tawr ma ghad lehq yaw khuhq maq gha lawq lawq te che tawd khuhd he lehq cud yiq ngag nig hehd haq pehar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A ye a pa, a vix a nax, awg ceng awg khad he lehq awg chawd awg paz teq pa thad kha gag liz, nig hehd haq kawq phuhz tug yaog. I hehd teq pa nig hehd ted pehg pehar haq liz dawz vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ngag ved awg meh haq te lehq, su nig hehd haq cand jad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kheh ma khuhd, nig hehd a koar ve cuhz kheh muh nehax ted maer liz maq gha te lug vid hawg. ");
INSERT INTO lhi_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nig hehd ve ni ma yeg khanr vix cheaq te lehq, nig hehd ve co ha gha teq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Yer ruq sar lehnr med haq maq mor nux kha caw yuhd lag hoz vehr che haq nig hehd gha mawg che te yand, med u ve lug vehr lehd te cheaq nig hehd sior. ");
INSERT INTO lhi_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Awg yand u ve khuhn, Yud daq muhd mig awg khuhn chehd che chaw teq pa kehaq lo phawe lor. Med khuhn chehd che chaw teq pa med khuhn tuhez lor. Med bag lo chehd che chaw teq pa med khuhn tad kawq gehe mehr. ");
INSERT INTO lhi_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Awg lawn ghod ver, Liq phu khuhn kha buhq lar che awg ceng saw phehaq tug, cir yanr che awg ni awg hax gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Awg yand u ve khuhn, yad mid yad hu chehd che he lehq chaw yad nehax cux pehz nux chehd che chaw teq pa awr lehr, gha lug gha sez jad tug yaog. Awg lawn ghod ver, mig gig che thag lo duhd har gad har jad tug yaog. Yud daq chaw ted ceng haq Ghig sa nez nag lehq cir yanr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","I hehd teq pa awr lehr, a teh chuh vehr cheaq gha khanr tug yaog. Su i hehd haq pheh yug ve lehq muhd mig awg gha lia khuhn awg ceg te vid tug yaog. Lawd kir yad teq pa awr lehr, i hehd ve awg yand peg thad kha gag, Yer ruq sar lehnr med haq naz kix lar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Awg yand u ve khuhn, muhd ni, har pa, muhd ki sir teq pa khuhn awg hez tuhaz tug yaog. Lad chuhd ghig he lehq ghig bad teq pa awg khuhd buhg hehnd jad lehq, chaw ceng chaw yad teq pa and jad lehq duhd har gad har jad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Chaw yad teq pa awr lehr, mig gig khod-aq lo phehaq tug awg ceng teq pa haq duhd ngawx che te yand, kuhz jad cheaq te lehq ma nuhd maq theh phehq vehr tug yaog. Awg lawn ghod ver, muhd nuh kawag lo kand pax cawg che awg ceng teq pa liz, hiz hiz nad nad phehq vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","U thad gaeg ver, chaw yad ve Yad phu awr lehr, awg mig awg phond he lehq kand pax ir che khuhn mog khuhn yaq che haq i hehd gha mawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Awg ceng u ve teq pa tanr teag lehd te che te yand, nig hehd tu lehq kuhr chid ngawx-oq. Awg lawn ghod ver, nig hehd haq thaer khuhq ax tug awg yand gag vehr tez che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yawd i hehd haq tawd par hax te mar vid lehq koz che, “A kud cehg he lehq suhz cehg teq pa haq ngawx-oq. ");
INSERT INTO lhi_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Awg car car-ag che te yand, muhd god yand gag vehr tez che haq nig hehd khad nawad duhd sir duhd mawg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","U ve haq kha sur suar, awg ceng che teq pa phehaq chehd che haq nig hehd gha mawg che te yand, Ghig sa ve muhd mig awr lehr, awg pad huh lag vehr che haq nig hehd sior. ");
INSERT INTO lhi_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ngag nig hehd haq awg cehg mag koz ax laq, chaw che te coaq ve mad pong veh ser huh, awg ceng che teq pa awg gha lia phehaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Muhd nuh maq he lehq mig naz ma saw mehx vehr tug yaog. Kheh ma khuhd, ngag ved tawd khuhd awr lehr, mehx maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nig hehd teq pa a sug yawd awg ton haq sa tiq kha nehax teo. Sa tiq kha nehax maq te ver, cad pong cad lex lehq, juhg dawg sar cad lehq juhg buhz juhg ka lehq mig gig khod-aq duhd har gad har tug teq pa haq lehax duhd har chehd ver, awg ni awg yand u ve ngaz va yaw heh te lehq, nig hehd mad juhg ma khehz te chehd-ag huh, nig hehd haq yaw tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Awg lawn ghod ver, awg ni u ve awr lehr, mig gig khod-aq chehd che chaw awg gha lia geh saw gag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kheh te lehq, phehaq tug awg ceng u ve awg gha lia haq nig hehd gha pong lehq, chaw yad ve Yad phu mehz khuhd suhr lo hox yeg chehd tug khar thad liz bon lawg lehq law laor,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yer suq awr lehr, muhd kaw ver, ni gha lia Yer ruq sar lehnr bon yehg nux lo mar vid lar haz lehq, muhd phiq ver, hax gha lia Sar lonr kehaq lo ca hax-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Su teq pa liz, yawd mar che tawd khuhd haq na tug, muhd sawx ted naq loar, Yer ruq sar lehnr bon yehg nux khuhn yawd chehd lo phoz lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Awg yand u ve khuhn, Par sar khar pawehd lehd koz che, Khaor mod khuhn did maq ke che pawehd te yand gag vehr tez che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ghig sa ve paw khod nux teq pa he lehq liq buhq var teq pa awr lehr, khawd-ehg te lehq yawd haq dawz vehr gha tug awg khad ca che yaog. Awg lawn ghod ver, i hehd teq pa awr lehr, muhd mig yad teq pa haq kuhz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kheh te lehq, awg laq ghuhd teq chi ni ghad khuhn chehd che, Yud daq Id sar kar rir oq meh che te ghad ve ni ma khuhn ned haeg Sar tanr geh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yawd awr lehr, Ghig sa ve paw khod nux teq pa he lehq bon yehg nux ve maq yad awg hox teq pa chehd lo kae lehq, Yer suq haq i hehd ve laq khuhn khawd-ehg te chi aq vid gha tug ca jehg daeq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","I hehd teq pa ha lehg jad lehq, Yud daq haq phu pid tug kar tiq te daq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yawd liz kar tiq te daq lar che heh, chaw mor nux ma chehd ver, Yer suq haq i hehd ve laq khuhn chid aq vid tug, daq che awg yand haq yawd ca chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Par sar khar pawehd yawg nehax gha dawz che awg ni he lehq Khaor mod khuhn did maq ke che pawehd te che awg ni teq ni gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Kheh te lehq, Yer suq awr lehr, Per troq he lehq Yod hanr haq kae pe lehq, “A nig Par sar khar pawehd haq gha cad tug awg pun ca te,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Khar lo ve ted kag haq ca te le,” lehz ix mag yawd haq kawq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yer suq kawq koz vid che, “Kha nehax na lar. Nig mag med khuhn gehe ver, a kaz phud chid taz tod che te ghad phad haq gha mawg tug yaog. Yawd khaz nuhr kae lehq, yawd yehg khar ve khuhn geh veh liz, nig mag liz u huh ghaq gehe lehq, ");
INSERT INTO lhi_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Yehg sehr phad haq che kheh koz vid, ‘Sar lar nawg haq na che, Ngag he lehq ngag ved awg laq ghuhd ngag hehd teq pa Par sar khar pawehd cad tug, khehx chaw bawehd khar lo awg le,’ lehz yawd haq na ngawx-oq. ");
INSERT INTO lhi_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kheh te ver, yawd te lar peg che awg thang ted thaeg bawehd ir che te bawehd yawd nig mag haq sir mar ax tug yaog. U huh te laor,” lehz ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ix mag kae che te yand, Yer suq koz ax lar che heh gha mawg lehq, Par sar khar pawehd cad tug awg pun te lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Awg yand gaeg che te yand, yawd teh cuh pad huh mi lehq, cuh yad teq pa liz yawd geh teq geha mi cad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kheh te lehq yawd koz che, “Tuq che khanr che haq ngag maq gha khanr ser huh, nig hehd geh teq geha ngag Par sar khar pawehd che haq cad gad jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Awg lawn ghod ver, ngag nig hehd haq koz ax laq, Ghig sa ve muhd mig khuhn pawehd che ve ted mag mad gag maq chi ser che kheh ceh, pawehd che ted mag haq ngag mad kawq cad hawg,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Kheh te peg lehq, yawd kawz khehd haq yug lehq bon chid muh peg khaz nuhr yawd koz che, “Kawz khehd che haq yug lehq nig hehd pehg dawor. ");
INSERT INTO lhi_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ngag nig hehd haq koz ax laq, Ghig sa ve muhd mig mad gag ser che kheh ceh, yaq ni khaz nuhr ver, ngag a pehx med ghig haq mad kawq dawg hawg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Khaor mod haq liz yawd yug lehq bon haq chid muh che yaog. U kheh te peg lehq, yawd khaor mod haq khehq lehq, awg laq ghuhd teq pa haq pid lehq koz vid che, “Cheawg lehr, nig hehd awg pun tand che ngag ved awg ton yaog. Ngag haq duhd nuhd tug che kheh teo,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","U ve heh te lehq, muhd phiq awr cad peg huh liz kawz khehd haq yawd yug lehq koz che, “Kawz khehd che awg lehr, nig hehd awg pun nger puhr lar che, ngag ved awg suhr haq yug te lar che kar tiq sax caz awg suhx phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ngawx lor. Ngag haq kawq phuhz che chaw te ghad liz, ngag geh a khehd che ve ted mag khuha lehax cad chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chaw yad ve Yad phu awr lehr, yawd haq Ghig sa duhd chez lar che heh khanr suh che khuhn gha te koeq tug yaog. Kheh ma khuhd, yawd haq kawq phuhz che chaw te ghad awr lehr, gha lug gha sez tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kheh te lehq, awg laq ghuhd teq pa awr lehr, a nig awg khuhn a sug te ghad che kheh te tuawg le lehz i hehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ghig sa ve muhd mig awg khuhn a sug suaq keh gha ir tuawg le lehd koz lehq, awg laq ghuhd teq pa tawd ghawg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Kheh te lehq Yer suq koz che, “Bid saz a naz ve jawd mawd teq pa awr lehr, i hehd teq pa awg khod-aq uq penr che yaog. I hehd teq pa awg khod-aq kand pax cawg che chaw teq pa haq bon sehr phad, lehz i hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kheh ma khuhd, nig hehd khuhn u kheh maq gha te hawg. Nig hehd awg khuhn suaq keh ir che chaw te ghad awr lehr, suaq keh i jad che chaw te ghad heh teo. Awg hox te che chaw te ghad liz su ved awg ceg heh teo. ");
INSERT INTO lhi_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kheh te ver, teh cuh haq mi cad chehd che he lehq te car te taw chehd che a sug suaq keh ir cheawg le. Mi cad chehd che phad ma hez hawg la. Kheh ma khuhd, ngag vawr nig hehd geh chehd che te car te taw var heh te lehq chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ngag ber che lawd che haq gha khanr thad nig hehd awr lehr, ngag geh khar thad liz chehd che chaw teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ngar pa ngag haq muhd mig pehar che heh te lehq, ngag liz nig hehd haq muhd mig pehar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Kheh te lehq, ngag ved muhd mig khuhn ngag ved teh cuh haq nig hehd gha mi cad gha mi dawg tug yaog. Nig hehd awr lehr, kaw jaw thag lo mi lehq, Id sar rer laq chaw teq chi nid ceng haq nig hehd suhx gha jehg lehq suhx gha taz tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sid monr-og, Sid monr-og, kha nehax na. Sar tanr nig hehd teq pa haq su a cag ha kha khenx kha che heh te lehq, nig hehd haq ha kha tug lawg chehd vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kheh ma khuhd, nawg yonr che ted ceng maq gha mehx vehr tug, ngag nawg awg pun bon lawg peor. Nawg kawq phuhz kawaq che te yand, nawg ved a vix a nax teq pa haq awg ghad pid-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Kheh te lehq Per troq kawq koz che, “Jawd mawd-og, ngag nawg geh kae tug te lar peor. Thawnr yehg khuhn lehd ma koz, suh kig lo lehd ma koz, ngag kae tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yer suq kawq koz che, “Per troq-og, ngag nawg haq koz ax laq, yaq pehax ghaz phuh mad buhg tand, nawg ngag haq maq sir daq lehz sehr pawz kha gag koz tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yer suq yawd ved awg laq ghuhd teq pa haq na ngawx lehq koz che, “Ngag nig hehd haq kae pea lehq, phu kaw pi, laq sax he lehq khi noz mad yug ve kae cuha ver, nig hehd lor che cuz che awg ceng cawg ser hawg la,” lehz Yer suq na ngawx che te yand, “Lor che cuz che ted cear liz, mad cawg,” lehz yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Kheh te lehq yawd kawq koz vid che, “A meha a sug phu kaw pi he lehq laq sax cawg liz yug ve kae. A teh mad cawg che chaw teq pa ver, a sug yawd ved veq kad huhd lehq a teh ca vig yuer. ");
INSERT INTO lhi_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kheh te cheaq te lehq, ngag nig hehd haq koz ax laq, ‘yawd haq chaw haeg teq pa khuhn sawr ke tug yaog,’ lehd koz buhq lar che tawd khuhd u ve awr lehr, ngag awg khuhn gha kex gha phehaq che yaog. Awg lawn ghod ver, ngag awg lawn buhq lar che teq pa awg cehg mag phehaq tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","I hehd kawq koz vid che “Jawd mawd-og, ngawx-ehq chuhr a teh nid mag cawg vehr che yaog,” lehd koz vid che te yand, yawd koz che, “Pehog. Awg lawn cheaq tad kawq koz lor,” lehz yawd i hehd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","U ve khaz nuhr, yawd tuhez lehq yawd kae jaw che heh te lehq, Sar lonr kehaq lo kae che yaog. Awg laq ghuhd teq pa liz, yawd khaz nuhr ghaq kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Yawd kae lehq gaeg che te yand, “Ber che lawd che khuhn nig hehd maq gha gehe tug bon kha nehax lawg chehd-oq,” lehz yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Awg laq ghuhd teq pa chehd kig huh te lehq, huhx meh bag chi miag huh gaeg lehq, yawd nar khehr teh mi lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“A pa-og, nawg ni ma cawd ver, kawz khehd che ve haq ngag gha pong tug a cehax tea laoq. Kheh ma khuhd, ngag ved a lor cawd che heh tad phehq vid. Nawg ved a lor cawd che heh phehq vid,” lehd koz bon lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Awg yand u ve khuhn, muhd nuh maq cuh yad te ghad muhd nuh kawag lo tuhaz lehq yawd haq awg ghad pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yawd ni ma khuhn tuq khaq jad cheaq te lehq, yawd bon hax ceh kawq lawg che yaog. Yawd a kir tuhz che liz awg suhr ghig heh te lehq mig kag lo sod yaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yawd bon lawg lar haz tu lehq awg laq ghuhd teq pa chehd lo koeq che te yand, i hehd duhd har jad che khuhn yuhq mir ka chehd che haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yawd i hehd haq koz vid che, “A thoq te nig hehd yuhq mir ka chehd cheawg le. Tu-og. Ber che lawd che khuhn maq gha gehe tug bon lawg chehd-oq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yawd che kheh koz chehd che te yand, cuh yad teq chi ni ghad khuhn chehd che Yud daq meh che te ghad, chaw mor nux haq sir vea lag che yaog. Yer suq haq bux vid tug, awg pad huh yawd jiz gehag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kheh te lehq Yer suq koz vid che, “Yud daq-og, nawg bux che haq te lehq chaw yad ve Yad phu haq chid aq vid che law lehg,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yer suq geh chehd che chaw teq pa awr lehr, khawd-ehg kheh te lag vehr che haq gha mawg che te yand, “Jawd mawd-og, ngag hehd a teh gha ghawg chuh lawg la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","I hehd awg khuhn ve chaw te ghad awr lehr, Ghig sa ve paw khod nux ve awg ceg var te ghad haq chuh lehq, laq yaq awr pax ve nar puh chez vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yer suq koz vid che, “Pehog. Tad kawq te lor,” lehd koz vid peg lehq, awg ceg var u ve nar puh haq yug lehq kawq ghu na vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kheh te lehq, Yer suq yawd haq ca phehag che Ghig sa ve paw khod nux teq pa, Yer ruq sar lehnr bon yehg nux ve maq yad awg hox teq pa he lehq awg hox chaw mawd teq pa haq phuhz ngawx lar lehq koz vid che, “Nig hehd ngag chaw khuhd-awg lehd duhd lehq la. A teh taz, suhz tag taz vea lag che. ");
INSERT INTO lhi_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ngag ni gha lia nig hehd geh Yer ruq sar lehnr bon yehg nux khuhn chehd thad ver, nig hehd ngag haq maq pheh yug. Kheh ma khuhd a meha ve awg yand awr lehr, nig hehd ve awg yand yaog. Naz hoq che kand pax ve awg yand yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kheh te lehq, i hehd yawd haq pheh ve lehq Ghig sa ve paw khod nux ve yehg lo seh ve kae che yaog. Per troq awr lehr, i hehd khaz nuhr vid vid-ag lo ghaq kae tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yehg pad huh ko lar che awg kaw jen huh su a mir ceh lehq teq geha mi lehq a mir phoz lehg chehd-ag huh, Per troq liz su geh a mir ca mi leheg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yawd a mir ghiz pawd kig huh mi chehd lehq, awg ceg ma te ghad mawg lehq yawd kha nehax ngawx peg lehq koz che, “Che phad liz u ve phad geh chehd che chaw te ghad yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kheh liz Per troq pha yax te lehq koz che, “Yad mid-og, ngag yawd haq maq sir daq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kheh te lehq, awg khaz nuhr maq muh tand chaw te ghad yawd haq kawq mawg lehq koz che, “Nawg liz u ve teq pa khuhn chehd che chaw te ghad yaog,” lehd koz vid che te yand Per troq koz che, “Phad-og, ngag ma hez hawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Teq nar lir kheh muha kawq gaeg lehq, chaw te ghad phad koz che, “Chaw che ve phad liz u ve phad geh chehd che te ghad cehg mag yaog. Awg lawn ghod ver, yawd liz Gar liq lehd chaw yaog,” lehd koz lehq sax khiz khanr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Per troq koz che, “Phad-og, nawg koz chehd che yix ve ngag maq sir,” lehd koz che yaog. Yawd u kheh koz chehd che mad peg tand ghaz phuh buhg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kheh te lehq Jawd mawd Yer suq awr lehr, Per troq haq kuhr phuhz ngawx che yaog. “Yaq pehax ghaz phuh mad buhg tand, nawg ngag haq maq sir daq lehz sehr pawz kha gag koz tug yaog,” lehd koz vid lar che haq Per troq duhd nuhd-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Kheh te lehq, yawd awg bag lo tuhez lehq hax ceh nux huhg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yer suq haq pheh lar che chaw teq pa awr lehr, yawd haq koz gid ghig gid lehq dawz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yawd ved mehz khuhd haq pha yug hoz tehr lar dawz phehd lar lehq, “A sug nawg haq dawz che law le. Ghig sa ve cuh kar var heh te lehq ngag hehd haq koz ax laoq,” lehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","I hehd yawd haq kaod koz gid lehq, maq sawnr ma caz kaod te gid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Muhd thid-ag che te yand, Yud daq chaw teq pa ve awg hox chaw mawd te chehd che Ghig sa ve paw khod nux teq pa he lehq liq buhq var teq pa phawng daq che yaog. Su yawd haq jehg daq var awg mor u ve mehz khuhd suhr sir ve kae lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nawg Khreq yaog la, ngag hehd haq a cehax koz ax,” lehd koz na che yaog. Yer suq kawq koz che, “Ngag koz ax liz nig hehd yonr tug ma hez. ");
INSERT INTO lhi_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ngag nig hehd haq na liz, nig hehd kawq khuhq ax tug ma hez. ");
INSERT INTO lhi_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kheh ma khuhd, chaw yad ve Yad phu awr lehr, yaq ni khaz nuhr ver, kand pax ir jad che Ghig sa ve laq yaq awr phawd awr mi chehd tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kheh te lehq, i hehd teq pa Yer suq haq na che, “Kheh te ver, nawg Ghig sa ve Yad phu yaog la,” lehd koz na che yaog. Yer suq kawq koz vid che, “Nig hehd koz che heh yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Kheh te lehq i hehd koz che, “A nig a thoq sax khiz kawq ca tug lor ser hawg le. Awg lawn ghod ver, yawd koz che tawd khuhd haq a nig awg ton gha kad peor,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kheh te lehq, phawng daq chehd che chaw awg gha lia phoz tuag lehq, Yer suq haq jawd mawd Pid laq chehd lo pheh ve kae lehq, yawd haq vend bax tar lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","“Chaw che phad yaog, ngag hehd ve chaw ceng haq kaod mar phuhz lehq, Jawd mawd nux Kehd sar haq awg khawnr maq gha ke vid tug te lehq, yawd awg ton Khreq lehd koz che jawd mawd te ghad yaog lehd koz tod che haq ngag hehd gha sir gha mawg che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Kheh te lehq, jawd mawd Pid laq Yer suq haq na che, “Nawg awr lehr, Yud daq chaw teq pa ve jawd mawd yaog la,” lehd koz na lehq Yer suq koz che, “Yaog, nawg koz che heh yaog,” lehz Yer suq yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kheh te lehq jawd mawd Pid laq koz vid che, “Chaw che ve phad teq chaweh te yaq kig haq ngag mad mawg,” lehz Ghig sa ve paw khod nux teq pa he lehq chaw awg gha lia haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kheh liz, i hehd ghaq te maq heh ghaq hehnd kawq koz che, “Chaw che ve phad awr lehr, muhd mig yad haq kaod mar phuhz lag che Yud daq muhd mig kha peg te lar haz lehq chuhr huh Gar liq lehd muhd mig Yer ruq sar lehnr med huh kha gag gaeg che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tawd khuhd u ve haq jawd mawd Pid laq gha kad che te yand, “Yawd Gar liq lehd chaw yaog la,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Yer suq awr lehr, jawd mawd Her roq uq penr chehd che muhd mig khuhn chehd che haq jawd mawd Pid laq sir vehr lehq, jawd mawd Her roq chehd lo sir ve kae vid che yaog. Awg yand u ve khuhn jawd mawd Her roq liz Yer ruq sar lehnr med khuhn chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jawd mawd Her roq awr lehr, Yer suq haq gha mawg che te yand ha lehg jad che yaog. Awg lawn ghod ver, yawd awg lawn haq gha kad jaw lehq yawd te mar che awg hez ted ceng cear haq gha mawag vawz gha hawg lehz yawd duhd law chehd cheaq te lehq, Yer suq haq mawg daq gad che muh chuhd vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kheh te lehq, yawd Yer suq haq tawd laex ceng na ngawx liz gha, Yer suq yawd haq tawd te khuhad liz mad kawq yaw khuhq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ghig sa ve paw khod nux he lehq liq buhq var u huh hox chehd che teq pa yawd haq vend bax hax ceh tar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jawd mawd Her roq he lehq yawd ved maq yad teq pa liz Yer suq haq maq sawnr ma caz te lehq koz gid ghig gid che yaog. U kheh te peg lehq, yawd haq jawd mawd ve beg ke daq jad che veq vid lehq, jawd mawd Pid laq chehd lo kawq sir kog pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","U ve teq ni haq tanr lehq, jawd mawd Her roq he lehq jawd mawd Pid laq kawq cawd daq vehr che yaog. Awg lawn ghod ver, pong lag thad ix mag ma cawd daq te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kheh te lehq jawd mawd Pid laq awr lehr, Ghig sa ve paw khod nux teq pa, awg hox chaw mawd teq pa he lehq chaw kheh ma ve haq kug phawng lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Chaw che phad, muhd mig yad haq mar phuhz mar yaq che chaw lehd koz lehq nig hehd ngag chehd lo pheh vea lar che yaog. Ngag nig hehd kheh ma ve mehz khuhd suhr huh yawd haq na ngawx liz, nig hehd yawd haq koz lehq vend bax ca lar che heh, ngag yawd yaq kig teq chaweh liz mad mawg. ");
INSERT INTO lhi_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jawd mawd Her roq liz yawd awg khuhn te yaq kig mad mawg lehq, yawd haq a nig chehd lo kawq pea che yaog. Ngawx lor, yawd suh kenr che vend bax teq chaweh liz maq te. ");
INSERT INTO lhi_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kheh te cheaq te lehq, ngag yawd haq jawq lehq phehd vid tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Chaw awg mor nux tawd te khuhad lehax te kug tuhaz lehq koz che, “Che ve phad haq yug ve dawz vehr lehq, Bar rar baq haq vawr ngag hehd chehd lo phehd pea,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bar rar baq awr lehr, med u ve khuhn chaw phuhz te lehq, chaw haq dawz vehr cheaq te lehq, su yawd haq thawnr yehg khuhn pheh ke lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jawd mawd Pid laq awr lehr, Yer suq haq phehd vid gad cheaq te lehq, i hehd haq te pawz kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kheh liz, i hehd teq pa kug lehq koz che, “Laq kan thag huh thaq vehor, yawd haq laq kan thag huh thaq vehor,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jawd mawd Pid laq sehr pawz te pawz kawq koz vid che, “A thoq maq haq te lehq le. Yawd haeg che a thoq ted ceng haq te cheawg le. Yawd awg khuhn suh lawq lawq ve toq ted cear liz ngag mad mawg. Kheh te cheaq te lehq, ngag yawd haq jawq lehq phehd vid tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kheh te lehq, i hehd awg khuhd pehz hehnd mehz te kug lehq koz che, yawd haq laq kan thag huh thaq vehr lor lehd koz hax ceh kug cheaq te lehq, i hehd phawd awr ghad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kheh te lehq jawd mawd Pid laq awr lehr, i hehd koz che heh te koz chez vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kheh te lehq, yawd Bar rar baq muhd mig haq phuhz lehq su haq dawz vehr che phad haq phehd vid lehq, Yer suq haq i hehd te gad che heh te vid tug chid aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Yer suq haq maq yad teq pa sir ve tuhez tod-ag huh, kehaq lo chehd lehq med khuhn lag tod che Kud rer ner med yad Sid monr meh che te ghad haq i hehd yug lehq laq kan taz vid lehq Yer suq khaz nuhr ghaq kae vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Chaw awg mor nux yawd khaz nuhr ghaq tod lehq yad mid teq pa liz yawd haq har kax che khuhn ghaq paz huhg kehd huhg tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yer suq i hehd haq kuhr phuhz ngawx lar lehq koz vid che, “Yer ruq sar lehnr ve yad mid teq paog, ngag haq har kax che khuhn tad huhg lor. Nig hehd a sug yawd khad awg ton haq he lehq nig hehd ve yad nehax dug nehax awg pun har kax che khuhn huhg lor. ");
INSERT INTO lhi_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Awg lawn ghod ver, teq ni ver che kheh koz tug yaog. ‘Chaw meh ma teq pa awr lehr, awg bon ir che yaog. Yad maq hu jaw che ux peg he lehq yad nehax maq nux jaw che cux pehz teq pa awr lehr, awg bon ir che yaog,’ lehd koz che awg ni awg hax gag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kheh te lehq, i hehd teq pa awr lehr, keh teq pa haq che kheh koz vid tug yaog. ‘Ngag hehd haq a cehax paz ter ax laoq.’ Keh nehax teq pa haq liz, ‘Ngag hehd haq a cehax hoz beh ax laoq,’ lehd koz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","I hehd awr lehr, daq che thed che chaw haq liz kheh taw maq te gha cheawg lehr, mad daq ma thed che chaw teq pa haq ver, khawd-ehg taw maq teag lawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kheh te lehq yawd geh teq geha dawz vehr tug liz, chaw haeg ni ghad sir vea che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","A kor ghuhd lehd koz che chehd kig lo gaeg lehq, i hehd yawd haq laq kan thag huh thaq ke lar che yaog. Chaw haeg u ve ni ghad liz, yawd ved laq yaq awr te ghad he lehq laq vehr awr te ghad laq kan thag huh thaq ke lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Kheh te lehq Yer suq koz che, “A pa-og, i hehd ve vend bax haq phehd vid-oq. Awg lawn ghod ver, i hehd khawd-ehg kheh te chehd che haq i hehd maq sir che yaog.” U kheh te peg khaz nuhr, i hehd teq pa Yer suq ve veq kad pehg daq yug tug nar bar kehx yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Chaw kha peh vad-ag phoz hox lar lehq ngawx chehd che yaog. Yud daq chaw ve awg hox teq pa awr lehr, yawd haq koz gid ghig gid lehq koz che, “Su haq ver yawd pong vid gha che yaog. Yawd awr lehr, Khreq lehd koz che Ghig sa lez yug lar che chaw te ghad-awg lehd koz ver, yawd awg ton haq yawd kawq te pong ngawx vid,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Maq yad teq pa liz yawd haq koz gid ghig gid lehq, a pehx med ghig ce maq te che taw vid lehq koz che, ");
INSERT INTO lhi_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Nawg awr lehr, Yud daq chaw teq pa ve jawd mawd-awg lehd koz ver, nawg awg ton haq gha pong vid tug teo,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Yawd thang huh liz “Chaw che phad awr lehr, Yud daq chaw teq pa ve jawd mawd yaog,” lehd koz buhq nehx lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kheh te lehq, laq kan haq thaq ke lar che chaw haeg te ghad koz che, “Nawg Khreq ma hez lehq la. Nawg awg ton haq liz, ngag hehd haq liz te pong ax laoq,” lehz Yer suq haq maq sawnr ma caz te koz gid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Te ghad kawq koz che, “Nawg heh te lehq, su suhx taz lar che haq yawd liz gha khanr chehd cheaq te lehq nawg Ghig sa haq ma kuhz lehq la. ");
INSERT INTO lhi_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Awd nag che kheh te gha khanr cheawg lehr cawd vehr che yaog. Awg lawn ghod ver, awd nag te yaq cheaq te lehq, khanr kenr khanr cawd che heh gha khanr che yaog. Kheh te lar, chaw che phad vawr, teq chaweh liz maq te yaq hawg,” lehd koz lehq ded vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Kheh te peg lehq, yawd Yer suq haq lawg khawx lehq koz che, “Yer suq-og, nawg ved muhd mig khuhn gehe che te yand, ngag haq liz a cehax duhd nuhad laoq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yer suq yawd haq kawq koz vid che, “Ngag nawg haq awg cehg mag koz ax laq, yaq ni nawg ngag geh teq geha Par rar tid suq khuhn gha chehd tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Awg yand u ve awr lehr, a lag teq khawr lehnd te lehq muhd phiq phawd awr sehr nar lir kha gag, muh ni awg ghiz liz mehx vehr lehq, mig giaq lo awg naz tud awg naz hoq phehq vehr che yaog. Yer ruq sar lehnr bon yehg nux khuhn kor lar che pha u ve liz, awg kaw jen khod vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kheh te lehq, Yer suq awg khuhd pehz hehnd mehz te kug lehq koz che, “A pa-og, ngag ved co ha nawg ved laq kuhr khuhn chid aq ax che yaog,” lehd koz che yaog. Yawd che kheh koz lar haz lehq sax chez vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Awg ceng che teq pa haq maq por te ghad gha mawg lehq koz che, “Chaw che phad awr lehr, awg cehg mag thed che cawd che chaw te ghad yag lo,” lehz yawd koz lehq Ghig sa haq chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kheh te lehq, lag phoz ngawx chehd che chaw teq pa awr lehr, i hehd awg ceng u ve teq pa haq gha mawg che te yand duhd har gad har che khuhn a sug yawd ni ma pi tha hiz lar haz lehq kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yawd haq kha sir che chaw awg gha lia he lehq Gar liq lehd muhd mig loar te lehq yawd khaz nuhr ghaq tod che yad mid ma teq pa liz a cehax vid-ag lo hox lar ngawx chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Awg yand u ve haq, Yud daq muhd mig khuhn cawg che Ar riz mar thehr med lo lag che Yod sehq meh che chaw te ghad cawg che yaog. Yawd awr lehr, daq che thed che cawd che chaw te lehq, Ghig sa ve muhd mig haq duhd law chehd che chaw te ghad yaog. Yawd awr lehr, Yud daq chaw teq pa khuhn chehd che awg hox jehg daq var awg mor khuhn chehd liz, i hehd jehg chez lehq te lar che haq ni ma ma cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yawd jawd mawd Pid laq chehd lo kae lehq, Yer suq ve awg ton haq ca lawg yueg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Yer suq ve awg ton haq yug yaq lehq, pha phua daq maq awg phuhd khaz jad che yug thiz peg lehq, te ghad-eg liz maq tur jaw ser che huhx meh thuhz lar che tur phuh khuhn ke teh lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Awg ni u ve awr lehr, ngad ni haq cawd lehq Sa ba to awg ni haq ver, jehd tug te law che awg ni teq ni gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Gar liq lehd muhd mig loar te lehq Yer suq khaz nuhr ghaq tod che yad mid teq pa liz ghaq kae lehq, tur phuh he lehq yawd awg ton haq loar khawd-ehg te tar vehr che haq i hehd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kheh te lehq, i hehd teq pa koeq lehq sa huhx teq pa he lehq nag huhx teq pa haq te lar che yaog. Awg lid tawd khuhd cawg lar che heh, Sa ba to awg ni teq ni haq i hehd ghad jehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Awg kawd maq teq sinx u ve haq sinx ni naq mi sawx ted naq loar yad mid teq pa awr lehr, i hehd teq pa te teh lar che sa huhx teq pa haq yug ve lehq tur phuh lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","I hehd tur phuh lo gaeg che te yand, tur phuh haq hoz beh lar che huhx meh dig u ve phuhz kha lar lawz cheaq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kheh te lehq i hehd ca geh ngawx-eg lehq, Yer suq ve awg ton ma chehd lawz vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Awg lawn u ve teq pa haq i hehd ca duhd ma tuhz te chehd-ag huh, awg ghiz lawd-aw vad-ag he lehq mehz pehz khehd mehz te che beg ke veq che haw khaz ni ghad i hehd pad huh hox chehd lawz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Yad mid u ve teq pa kuhz jad lehq mig kag lo boz cuhx chehd-ag mehx, chaw u ve ni ghad koz che, “Nig hehd a thoq te teq chehd che chaw haq chaw suh che chehd kig lo ca tod cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yawd chuhr huh ma chehd hawg. Kawq teq tuag vehor. Gar liq lehd muhd mig khuhn chehd-ag huh, yawd nig hehd haq koz ax lar che tawd khuhd haq nig hehd duhd ngawx-oq. ");
INSERT INTO lhi_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Yawd koz che, ‘Chaw yad ve Yad phu awr lehr, vend bax yad teq pa ve laq khuhn chid aq vid che haq gha khanr lehq, laq kan thag huh thaq vehr peg khaz nuhr, sehr ni gaeg ver, kawq teq tuag tug yaog,’ lehz nig hehd haq koz vid lar che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kheh te lehq, Yer suq koz lar che tawd khuhd haq yad mid u ve teq pa kawq duhd nuhd-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","I hehd tur phuh lo kaw kawaq lehq, awg laq ghuhd teq chi te ghad he lehq su teq pa haq liz i hehd awg lawn khae mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Awg lawn u ve teq pa cuh yad teq pa haq ca koz vid-eg che yad mid teq pa awr lehr, Mar riq Mar gar dar laq, Yod har naq, Yar koq ve awr ye Mar riq he lehq awg kag awg nuz awr ve yad mid teq pa yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yad mid teq pa koz che tawd khuhd haq, teq chaweh cuhx kig mad cawg hawg lehd duhd lehq, cuh yad teq pa i hehd haq maq na che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kheh te lehq, Per troq tuag lehq tur phuh lo ca cex ngawx-eg che yaog. Yawd Yer suq tar lar che tur phuh khuhn boz ngawx pe ngawx-ag mehx, Yer suq awg ton vawr mad mawg he lar, yawd haq thiz che pha lehax chehd lawz cheaq gha mawg lehq, yawd ca duhd ma tuhz he lehq yehg lo kawaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Awg ni u ve teq ni khuhn, awg laq ghuhd ni ghad Yer ruq sar lehnr med haq suhr kid lod vid daq che Ed mawr khaz lo kae tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ix mag kae tod che yaq kaw kanr huh, Yer suq haq caz daq che awg lawn teq pa kaod koz daq kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ix mag che kheh kaod koz daq jehg daq kae tod-ag huh, Yer suq liz ix mag pad huh lag lehq, ix mag geh teq geha kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kheh ma khuhd, ix mag yawd haq maq sir vid tug, ix mag ved mehz sir haq yug phuhz vid lar che heh te che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Kheh te lehq Yer suq ix mag haq koz vid che, “Nig mag yaq kaw kanr a thoq koz daq jehg daq veh tod cheawg le,” lehd koz na ngawx che te yand, ix mag awr lehr, hox lar lehq duhd har cehar lehz te vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kheh te lehq, ix mag awg khuhn Kar lawd phaq meh che phad koz che, “Yer ruq sar lehnr med khuhn chehd che chaw teq pa awr lehr, che teq cuhx med u ve khuhn a thoq phehq chehd che awg lawn haq maq sir che chaw awr lehr, khehx chaw nawg te ghad lehax cawg che gha hawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yer suq kawq koz che, “A thoq maq awg lawn cawg law le,” lehd koz na ngawx che te yand, ix mag kawq koz che, “Nar sar rehq chaw Yer suq ve awg lawn yaog. Chaw u ve awr lehr, Ghig sa mehz khuhd suhr, chaw yad kheh ma ve mehz khuhd suhr, yawd koz che te che awg khuhn kand pax cawg lehq Ghig sa ve cuh kar var te ghad phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ghig sa ve paw khod nux teq pa he lehq ngag hehd ve awg hox chaw mawd teq pa awr lehr, yawd gha suh vid tug awg pun suhx jehg suhx taz tug chid aq vid lehq, laq kan thag huh thaq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Yawd awr lehr, Id sar rer laq chaw ceng haq thaer khuhq vid var te ghad yaog, lehz ngag hehd duhd law chehd che yaog. Kheh te lehq, awg lawn che ve phehaq che yaq ni haq sawnr ver, sehr ni gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ngag hehd awg mor khuhn chehd che yad mid teq pa liz, ngag hehd haq and tug awg lawn koz ax che yaog. Yaq sawx ted naq i hehd teq pa tur phuh lo ca ngawx-eg che, yawd ved awg ton haq mad mawg lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Kheh te lehq i hehd kawaq lehq koz che, awg ha awg khuhn muhd nuh maq cuh yad teq pa haq i hehd teq pa gha mawg lehq, yawd teq chehd che yaog lehz i hehd yad mid teq pa haq koz ax che yaog lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ngag hehd awg mor khuhn chehd che chaw te pehg tur phuh lo ca ngawx-eg che liz, yad mid teq pa koz che heh te gha mawg che yaog. Kheh ma khuhd i hehd teq pa liz Yer suq awg ton haq mad mawg,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kheh te lehq, Yer suq ix mag haq koz vid che, “A thoq te lehq nig hehd kheh maq kar lehq yonr har cheawg le. Khawd-ehg te lehq Ghig sa ve cuh kar var teq pa koz lar che tawd khuhd haq maq na yug cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Khreq awr lehr, che kheh te gha tuq gha khanr lehq, yawd ved awg mig awg phond khuhn gha chehd tug ma hez hawg la,” lehz ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kheh te lehq, Mod ser haq tanr lehq Ghig sa ve cuh kar var teq pa awg gha lia he lehq Liq phu awg gha lia khuhn yawd ved awg lawn kha buhq lar che teq pa, ix mag haq cuhx kig saw yug tuhz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ix mag kae tod che khaz lo gag vehr lehq Yer suq awr lehr, khaz u ve haq pong ka vehag lehd te che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kheh te lehq ix mag koz vid che, “Ngag nid-ag geh hax lar haz ser. Awg lawn ghod ver, muhd ni liz kehg vehr lehq, muhd liz phiq vehr tez-or,” lehd koz lehq yawd haq hax ceh lawg khawx che yaog. Kheh te lehq, yawd ix mag geh hax tug kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Yawd ix mag geh teh cuh pad huh mi lehq cad tug cad che te yand, yawd khaor mod haq yug lehq bon chid muh peg khaz nuhr, khaor mod khehq lehq ix mag haq pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","U huh gaeg lehq, ix mag mehz sir kha nehax kawq cehar lehq, Yer suq yaog lehz gha kawq siar che yaog. Kheh te lehq Yer suq awr lehr, ix mag mehz khuhd suhr huh mehx vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ix mag koz daq che, “Yaq kaw kar lo awd nag haq tawd yawa lehq Liq phu cuhx kig pheq mar che te yand, awd nag ved ni ma khuhn geh jad che ma hez hawg la,” lehz ix mag koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Awg yand u ve khuhn ix mag har naq tu lehq Yer ruq sar lehnr med lo kawq kae che yaog. Kae lehq gaeg che te yand, cuh yad teq chi te ghad he lehq i hehd geh chehd che chaw teq pa phawng daq chehd lawz che haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chaw u ve teq pa ix mag haq koz vid che, “Jawd mawd Yer suq awg cehg mag kawq teq tuag vehr che yaog. Sid monr haq yawd ved awg ton maw vid peor,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Kheh te lehq ix mag liz, yaq kaw kar lo gha phud gha mawg lar haz che awg lawn teq pa he lehq khaor mod khehq ax lehq yawd yag lo, lehz gha kawq siar che awg lawn liz, i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","I hehd u kheh koz daq chehd-ag huh, Yer suq yawd awg ton i hehd teq pa kar huh hox lar lehq, “Nig hehd teq pa duhd sa gad sa tug cawg vid-oq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kheh te lehq i hehd teq pa awr lehr, chaw ha mawg che law lehd duhd lehq, tez mag nuh he lehq kuhz jad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yer suq i hehd haq koz vid che, “A thoq te nig hehd ngag awg lehz maq yonr lehq kuhz chehd cheawg le. ");
INSERT INTO lhi_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ngag cehg mag yaog. Ngag ved laq kuhr khi kud haq ngawx-oq. Ngag haq soz ngawx vad ngawx-oq. Ngag awr lehr, nig hehd mawg chehd che heh te lehq, awg suhr awg sar he lehq awg ghuhd cawg che yaog. Chaw ha ver, awg ceng che ve teq pa mad cawg hawg,” lehd koz lehq, ");
INSERT INTO lhi_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","yawd ved laq kuhr khi kud i hehd haq maw vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","I hehd and lehq ga ha lehg jad cheaq te lehq, kha nehax maq yonr ser te chehd-ag huh, Yer suq koz che, “Nig hehd geh cad tug ted ceng cear mad cawg lar la,” lehd koz i hehd teq pa haq na che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ngad pinr lar che teq theh yug lehq yawd haq pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yawd yug lehq, i hehd mehz khuhd suhr cad vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kheh te lehq yawd kawq koz che, “Mod ser ve awg lid tawd khuhd liq khuhn ma koz, Ghig sa ve cuh kar var teq pa ve liq awg khuhn loar, chid muh che liq teq pa awg khuhn lo lehd ma koz, ngag awg lawn kha buhq lar che awg gha lia gha phehaq tug yaog, lehz ngag nig hehd geh chehd ser thad loar, nig hehd haq ngag koz vid lar peg che yaog.” ");
INSERT INTO lhi_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","U kheh te lehq, Liq phu ve cuhx kig haq sir vid tug, yawd i hehd ve ni ma haq duhd pawnr vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Yawd i hehd haq koz vid che, “Liq phu khuhn che kheh koz buhq lar che yaog. Khreq awr lehr, gha khanr suh lehq sehr ni gaeg ver, gha kawq teq tuag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Vend bax duhd phuhz lehq vend bax phehd kha tug awg lawn, Yer ruq sar lehnr med haq tanr lehq chaw ceng awg gha lia haq yawd ved awg meh khuhn gha mar vid tug yaog lehd koz buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nig hehd awr lehr, awg lawn che ve teq pa haq sax khiz khanr var teq pa phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ngar pa pid tug yaog, lehd koz lar che awg ceng ngag nig hehd haq pehar tug yaog. Kheh te lehq, muhd nuh kawag lo ve kand pax haq nig hehd maq gha ser che kheh ceh, med che khuhn chehd lar ser,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kheh te lehq, yawd i hehd teq pa haq sir ve lehq Ber tar niq khaz pad huh gaeg che te yand, yawd laq kuhr chid lehq, i hehd teq pa haq bon naq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","U kheh te bon naq vid chehd-ag huh, yawd i hehd haq phaz daq lar haz lehq muhd nuh kawag lo taz kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","I hehd yawd haq boz cuhx lar a kor pi vid lar haz lehq, ha lehg jad che khuhn Yer ruq sar lehnr med lo kaw kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kheh te lehq i hehd teq pa awr lehr, khar thad liz Yer ruq sar lehnr bon yehg nux khuhn chehd lehq Ghig sa haq chid muh chehd che yaog.");
INSERT INTO lhi_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Awg kawd maq thad liz Tawd khuhd cawg lar che yaog. Tawd khuhd u ve Ghig sa geh chehd lehq Tawd khuhd u ve awr lehr, Ghig sa phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tawd khuhd u ve awr lehr, awg kawd maq thad liz Ghig sa geh teq geha chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yawd haq cud lehq Ghig sa awg gha lia haq te phanr lar che yaog. Kha cawg chehd che awg gha lia awg khuhn lo yawd maq te phanr che ted cear liz mad cawg. ");
INSERT INTO lhi_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yawd awg khuhn lo co ha teq che ted ceng cawg che yaog. Co ha teq che u ve awr lehr, chaw yad ve Awg ghiz yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Awg ghiz u ve awr lehr, naz hoq che awg khuhn lo pawd tuhaz lehq, naz hoq che awr lehr Awg ghiz haq ma ghad. ");
INSERT INTO lhi_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ghig sa peha lar che Yod hanr meh che chaw te ghad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yawd awr lehr sax khiz khanr tug awg pun lag che yaog. Yawd haq te lehq chaw awg gha lia yonr vid tug, Awg ghiz u ve awg lawn yawd sax khiz khanr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yawd awr lehr Awg ghiz phehq che ma hez. Kheh ma khuhd, Awg ghiz awg lawn sax khiz khanr tug yawd lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Awg ghiz awg cehg mag awr lehr mig gig thag lo lag lehq chaw awg gha lia haq awg ghiz paw vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yawd awr lehr mig gig haq te phanr lar lehq, mig gig khod-aq lo chehd chehd liz, mig gig yad yawd haq maq sir. ");
INSERT INTO lhi_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yawd ved chehd kig lo yawd lag liz, yawd ved chaw yawd haq maq haq yug. ");
INSERT INTO lhi_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kheh ma khuhd, yawd haq kha haq yug lehq yawd ved awg meh haq kha yonr che chaw awg gha lia haq Ghig sa ve awg yad phehq vid tug yawd a khawag pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","I hehd haq Ghig sa ve awg yad phehq vid che awr lehr, awg ceng awg khad haq te lehq ma hez. Awg suhr awg sar a lor haq te lehq ma hez. Chaw yad ve a lor haq te lehq liz ma hez. Ghig sa haq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tawd khuhd u ve awr lehr, awg suhr awg sar puhd lehq ngag hehd geh chehd che yaog. Yawd ved awg mig awg phond haq ngag hehd gha mawg che yaog. Awg mig awg phond u ve awr lehr, Awr pa lo lag che Yad phu tinr-a ve awg mig awg phond phehq che yaog. Yawd awg khuhn awg bon awg sinx he lehq awg cehg mag cawd che ted ceng kha lawq cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","(Yod hanr awr lehr yawd awg lawn sax khiz khanr che awg khuhn kug lehq koz che, “‘Ngag khaz nuhr lag tug chaw te ghad awr lehr, ngag haq keh ir che yaog. Awg lawn ghod ver, ngag mad cawg ser thad loar liz yawd cawg chehd vehr che yaog,’ lehz ngag koz lar che awr lehr, chaw che te ghad yaog,” lehd koz che yaog.) ");
INSERT INTO lhi_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","A nig awg gha lia awr lehr, yawd peh lawq che ted ceng awg khuhn, awg bon ted ceng peg ted ceng gha lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Awg lawn ghod ver, awg lid tawd khuhd awr lehr, Mod ser haq cud lehq pehar lar che yaog. Kheh ma khuhd, awg bon awg sinx he lehq awg cehg mag cawd che ted ceng awr lehr, Yer suq Khreq haq cud lehq phehaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Chaw te ghad-eg liz Ghig sa haq mad mawg jaw. Khar thad liz Awr pa pad huh chehd che Yad phu tinr-a awr lehr, Awr pa awg lawn kha sehax saw pheq mar ax peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yud daq chaw ve awg hox awg nax teq pa awr lehr, paw khod teq pa he lehq Ler viq chaw teq pa haq Yer ruq sar lehnr med lo tu lehq Yod hanr chehd lo kae pe che yaog. I hehd awr lehr, “Nawg a suawg le,” lehd koz na ngawx che te yand, ");
INSERT INTO lhi_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yod hanr che kheh te sax khiz khanr che yaog. “Ngag awr lehr Khreq ma hez,” lehd koz, kha sehax thed-e ghad koz vid che yaog. Yawd maq her ka ma khuhd ceh. ");
INSERT INTO lhi_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kheh te lehq i hehd awr lehr, “Kheh te ver, nawg Ed lid yaq lehq la,” lehd koz na ngawx che te yand, “Ngag Ed lid yaq ma hez,” lehz yawd kawq koz vid che yaog. “Lag tug ve Ghig sa ve cuh kar var u ve te ghad lehq la,” lehd koz kawq na ngawx che te yand, “Ma hez,” lehz yawd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kheh te lehq i hehd kawq koz che, “Nawg a suawg le. Ngag hehd haq peha lar che chaw teq pa haq ngag hehd kawq koz vid gha tug, nawg awg ton awg lawn nawg khawd-ehg kheh koz cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yod hanr kawq koz che, “Ghig sa ve cuh kar var Id sar yaq koz lar che heh, ‘Jawd mawd Ghig sa ve yaq kaw haq thed-e ghad teo,’ lehz heh pir khuhn lo kug chehd che te ghad ve awg khuhd awr lehr ngag yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Chaw u ve teq pa awr lehr, Phar rir sehd teq pa kae pe che chaw teq pa phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","I hehd kawq koz che, “Nawg awr lehr Khreq ma hez, Ed lid yaq liz ma hez. Ghig sa ve cuh kar var u ve te ghad liz ma hez che ver, a thoq te nawg su haq baz tiz sar pid cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yod hanr kawq koz che, “Ngag awr lehr su haq a kaz awg khuhn lo baz tiz sar pid che yaog. Kheh ma khuhd, nig hehd maq sir che chaw te ghad nig hehd awg khuhn lo chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yawd awr lehr, ngag khaz nuhr lag che chaw te ghad phehq che yaog. Yawd ved khi noz caz haq phi tug lehax liz ngag maq kenr,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","I hehd Yod hanr haq kheh te na ngawx che awg ti awr lehr, Ber tar niq khaz khuhn Yawd danr lawg kax ox pax awr lo Yod hanr baz tiz sar pid chehd kig huh yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Awg khaz nuhr teq ni, Yod hanr awr lehr Yer suq yawd chehd lo lag tod che haq gha mawg che te yand yawd koz che, “Mig gig yad ve vend bax haq yug kha che phad, Ghig sa ve Yawg nehax haq ngawx-oq. ");
INSERT INTO lhi_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","‘Ngag khaz nuhr lag tug chaw te ghad awr lehr, ngag haq keh ir che yaog. Awg lawn ghod ver, ngag mad cawg ser thad loar liz yawd cawg chehd vehr che yaog,’ lehd ngag koz lar che awr lehr, chaw che te ghad haq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Awg kawd maq thad ngag yawd haq maq sir. Kheh ma khuhd, Id sar rer laq chaw teq pa yawd haq kha sehax gha mawg gha sir vid tug, ngag lag lehq su haq a kaz awg khuhn lo baz tiz sar pid che yaog.” ");
INSERT INTO lhi_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Kheh te lehq, Yod hanr sax khiz khanr lehq koz che, “Awg ha phu awr lehr, a pia heh te muhd nuh maq lo yaq lehq yawd awg thag huh chehd chehd che haq ngag gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Awg kawd maq thad ngag yawd haq maq sir. Kheh ma khuhd, a kaz awg khuhn lo su haq baz tiz sar pid tug ngag haq cuha che phad te ghad ngag haq koz ax che, ‘Yawd awg thag huh Awg ha phu yaq lehq chehd chehd che te ghad haq nawg gha mawg ver, yawd awr lehr daq che kehg che Awg ha phu awg khuhn su haq baz tiz sar pid che phad phehq che yaog,’ lehd koz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ngag gha mawg peg lehq, chaw che te ghad awr lehr Ghig sa ve Yad phu phehq che yaog lehz ngag sax khiz khanr che yaog,” lehz Yod hanr koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Awg khaz nuhr teq ni Yod hanr awr lehr, yawd ved awg laq ghuhd ni ghad geh u huh kawq hox chehd huh, ");
INSERT INTO lhi_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yer suq lag tod che haq yawd ngawx lehq, “Ghig sa ve Yawg nehax haq ngawx-oq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Awg laq ghuhd u ve ni ghad awr lehr, yawd koz che tawd khuhd haq gha kad lehq, Yer suq khaz nuhr ghaq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yer suq phuhz ngawx lehq, ix mag yawd khaz nuhr ghaq lag tod che haq gha mawg che te yand, “Nig mag a thoq haq ca cheawg le,” lehd koz na ngawx che yaog. Ix mag kawq koz che, “Rar bid-og, nawg khar lo chehd cheawg le,” lehd koz yawd haq na ngawx che yaog. (Rar bid lehd koz che awr lehr, Sar lar haq koz che yaog.) ");
INSERT INTO lhi_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Yer suq ix mag haq koz vid che, “Lar-oq, nig mag gha mawg tug yaog.” Kheh te cheaq te lehq, ix mag kae lehq, yawd ved chehd kig haq gha mawg che yaog. Awg yand u ve haq, muhd phiq phawd awr uhd nar rir kheh taw gag vehr che haq te lehq, u ve teq ni ix mag yawd geh chehd lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yod hanr koz che tawd khuhd haq gha kad lehq Yer suq khaz nuhr ghaq veh che chaw u ve ni ghad awg khuhn ve te ghad awr lehr Sid monr Per troq awg nax var Anr drehr yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","U ve awg khaz nuhr, yawd awr lehr, yawd ved awg vix var Sid monr haq awg kawd ca che yaog. Yawd haq gha mawg lehq, “Ngag nid-ag Mir six yaq haq gha mawg vehor,” lehd koz vid che yaog. (Mir six yaq lehd koz che awr lehr, Khreq lehd koz che yaog.) ");
INSERT INTO lhi_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kheh te lehq yawd awr lehr, yawd awg vix var haq Yer suq chehd lo sir ve kae che yaog. Yer suq Sid monr haq ngawx peg lehq koz che, “Nawg awr lehr Yod hanr ve yad par Sid monr yaog. Nawg haq Per troq lehz koz su kug tug yaog,” lehd koz vid che yaog. (Ker phaq lehd koz che awr lehr, Per troq haq koz che yaog.) ");
INSERT INTO lhi_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Awg khaz nuhr teq ni, Yer suq Gar liq lehd muhd mig lo kae tug duhd chez lar che yaog. Yawd awr lehr Phid liq haq phud daq lehq, “Ngag khaz nuhr ghaq laoq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Phid liq awr lehr, Anr drehr he lehq Per troq ve chehd kig Ber sehd daq med yad phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Phid liq awr lehr, Nar tar ner laq haq ca mawg che te yand yawd koz che, “Mod ser buhq lar che awg lid tawd khuhd liq awg khuhn lehd ma koz, Ghig sa ve cuh kar var teq pa buhq lar che liq awg khuhn lehd ma koz, chaw te ghad ve awg lawn haq buhq lar che heh, chaw u ve haq ngag hehd gha mawg peg che yaog. Yawd awr lehr Yod sehq ve yad, Nar sar rehq chaw Yer suq yaog,” lehz Nar tar ner laq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nar tar ner laq kawq koz che, “Nar sar rehq med khuhn daq che awg ceng ted ceng cear tuhaz gha tuawg la,” lehd koz na ngawx che te yand, “Ca ngawx laoq,” lehz Phid liq yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nar tar ner laq yawd chehd lo lag tod che haq Yer suq gha mawg che te yand, Nar tar ner laq ve awg lawn yawd che kheh koz che, “Yawd awg khuhn her ka che a cehax liz mad cawg che, Id sar rer laq chaw awg cehg mag te che te ghad haq ngawx-oq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nar tar ner laq awr lehr, “Nawg ngag haq khawd-ehg kheh te sir cheawg le,” lehd koz na ngawx che te yand, Yer suq kawq koz che, “Phid liq nawg haq mad kug ser thad liz, a kud cehg awg huhx lo nawg chehd chehd che haq ngag mawg che yaog,” lehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nar tar ner laq Yer suq haq kawq koz khuhq vid che, “Rar bid-og, nawg awr lehr Ghig sa ve Yad phu phehq che yaog. Id sar rer laq chaw teq pa ve Jawd mawd liz nawg phehq che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yer suq kawq koz che, “Ngag nawg haq a kud cehg awg huhx lo mawg che yaog lehd koz ax cheaq te lehq nawg yonr cheawg la. Che haq keh ir che awg ceng teq pa haq liz nawg gha mawg tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yer suq yawd haq te pawz kawq koz vid che, “Ngag nig hehd haq awg cehg mag koz ax laq, muhd nuh maq phaw lar lehq, Ghig sa ve muhd nuh maq cuh yad teq pa chaw yad ve Yad phu awg khod-aq taz taz yaq yaq te chehd che haq nig hehd gha mawg tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","U ve khaz nuhr, sehr ni teq ni gaeg che te yand, Gar liq lehd muhd mig Kar naq khaz awg khuhn su khehx cad chehd lehq, Yer suq ve awr ye u huh chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yer suq he lehq yawd ved awg laq ghuhd teq pa haq liz, khehx cad kig huh lag tug su kug vid lar lehq i hehd u huh chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","A pehx med ghig peg vehr che te yand, Yer suq ve awr ye awr lehr, “I hehd a pehx med ghig mad cawg vehor,” lehz Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yer suq kawq koz vid che, “Yad mid-og, che ve awr lehr ngag haq khawd-ehg kheh te caz daq cheawg le. Ngag ved awg yand mad gag ser,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Yer suq ve awr ye awr lehr, awg ceg teq pa haq koz vid che, “Yawd nig hehd haq te cuha che heh teo,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yud daq chaw teq pa ve awg lid cawg che heh, daq vid kehg vid tug a kaz chuhd che awg lid awg khuhn yehd tug, u huh a kaz ke tug huhx meh mawq khu khuhq mag cawg chehd che yaog. Mawq khu ted mag ve haq, a kaz ni taz sehr taz heh ke daw che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yer suq awr lehr, “Mawq khu che teq pa haq a kaz kha peh kho ke-og,” lehz awg ceg teq pa haq koz vid che yaog. Kheh te lehq, i hehd a kaz kha peh kho ke che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Awg yand u ve haq Yer suq i hehd haq koz vid che, “A meha ke ve lehq, khehx cad-ag che awg hox haq ca yug vid-eq,” lehd koz che te yand, i hehd ca yug vid-eg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Khehx cad-ag che awg hox awr lehr, a kaz a pehx med ghig phehq vehr che haq a cehax dawg ngawx che yaog. A pehx med ghig che khar lo lag che haq yawd maq sir. (Kheh ma khuhd, a kaz kho ke che awg ceg teq pa awr lehr sir chehd che yaog.) Awg yand u ve khuhn khehx cad-ag che awg hox awr lehr, awg mid ma he che phad haq kug yug lehq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Chaw awg gha lia awr lehr, daq jad che a pehx med ghig haq awg kawd maq taw vid che yaog. Kheh te lehq, su kha buhz dawg peg che te yand, u kheh taw mad daq che a pehx med ghig kawq taw vid che yaog. Kheh ma khuhd nawg vawr, daq jad che a pehx med ghig haq a meha thad kha gag haq sax lar che law,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yer suq awr lehr, awg kawd ped maq ve and tug awg hez che ted mag haq Gar liq lehd muhd mig Kar naq khaz khuhn te lehq, yawd ved awg mig awg phond te maw vid che yaog. Kheh te lehq, yawd ved awg laq ghuhd teq pa yawd haq yonr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","U ve awg khaz nuhr yawd awr lehr, yawd ved awr ye, yawd ved awg nax var teq pa he lehq yawd ved awg laq ghuhd teq pa geh Kar per nar unr khaz lo yaeq che yaog. I hehd u huh khawd-ehg muh maq ma chehd. ");
INSERT INTO lhi_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yud daq chaw teq pa ve Par sar khar pawehd te che awg yand gag vehr tez huh, Yer suq awr lehr Yer ruq sar lehnr med lo taez che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Awg yand u ve khuhn bon yehg nux awg khuhn, yawg, nud, a pia teq pa huhd chehd che chaw teq pa he lehq phu pa sehr phad teq pa u huh mi chehd che haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yawd awr lehr, a caz kheh haq yug lehq jawq tug te lar peg lehq, i hehd awg gha lia, yawg he lehq nud teq pa haq bon yehg nux awg khuhn lo ghaq kog che yaog. Phu pa sehr phad teq pa ve phu haq nger chid bag lehq, i hehd ve teh cuh teq pa haq phuhz bag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A pia huhd che chaw teq pa haq liz, “Med nged che teq pa haq yug kae-o. Ngag Awr pa ve yehg haq med nged huhd med nged vig kig yehg taq te,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","“Nawg ved yehg haq ngag haq jad che ni ma awr lehr, ngag awg khuhn a mir toq che heh te lehq toq chehd che yaog,” lehz Liq phu khuhn buhq lar che haq yawd ved awg laq ghuhd teq pa duhd nuhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Awg yand u ve haq Yud daq chaw teq pa koz che, “Nawg kheh te te che awr lehr, a thoq awg hez ted ceng ngag hehd haq te mar ax tuawg le,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yer suq kawq koz che, “Bon yehg nux che haq te lur-oq. Sehr ni awg khuhn ngag kawq te peg tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Awg yand u ve khuhn Yud daq chaw teq pa koz che, “Bon yehg nux che haq uhd chi khuhq khuhq kha gag gha te che yaog. Nawg awr lehr sehr ni awg khuhn lo lehax kawq te peg tuawg la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kheh ma khuhd Yer suq u kheh koz che awr lehr, bon yehg nux phehq che yawd ved awg ton haq koz gad che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kheh te cheaq te lehq, suh kig lo yawd kawq teq tuag che te yand, yawd ved awg laq ghuhd teq pa awr lehr yawd koz lar che tawd khuhd haq duhd nuhd lehq, Liq phu he lehq Yer suq koz lar che tawd khuhd haq i hehd yonr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Par sar khar pawehd te chehd che awg yand awg khuhn, Yer suq Yer ruq sar lehnr med khuhn chehd chehd che te yand, yawd te mar che awg hez teq pa haq su gha mawg cheaq te lehq, chaw kha peh vad-ag yawd ved awg meh haq yonr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kheh ma khuhd Yer suq awr lehr, yawd awg ton chaw u ve teq pa haq yawd maq yonr. Awg lawn ghod ver, chaw awg gha lia haq yawd sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Chaw yad ve ni ma awg khuhn khawd-ehg kheh cawg che haq yawd sir chehd che haq te lehq, chaw yad ve awg lawn chaw te ghad-eg liz sax khiz khanr tug haq yawd maq lor. ");
INSERT INTO lhi_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Awg yand u ve khuhn, Yud daq chaw teq pa awg khuhn lo awg hox awg nax phehq che, Niq kawd der meh che Phar rir sehd te ghad cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yawd awr lehr, muhd khax huh Yer suq chehd lo lag lehq koz che, “Rar bid-og, nawg awr lehr Ghig sa chehd lo lag che Sar lar te ghad phehq che haq ngag hehd sir che yaog. Awg lawn ghod ver, nawg te mar che awg hez teq pa awr lehr, Ghig sa yawd awg khuhn chehd che chaw ma hez ver, chaw te ghad-eg liz te maq gha hawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yer suq kawq koz che, “Ngag nawg haq awg cehg mag koz ax laq, chaw khar ve te ghad lehd ma koz awg suhx te pawz mad kawq pawag ver, Ghig sa ve muhd mig haq maq gha mawg hawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Niq kawd der kawq koz che, “Mawd vehr che chaw te ghad awr lehr, khawd-ehg kheh te kawq pawag gha tuawg le. Yawd ved awr ye ux peg khuhn yawd kawq gehe lehq te pawz kawq pawag gha tuawg la,” lehz yawd haq na ngawx che te yand, ");
INSERT INTO lhi_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yer suq kawq koz che, “Ngag nawg haq awg cehg mag koz ax laq, chaw khar ve te ghad lehd ma koz, a kaz he lehq Awg ha phu awg khuhn maq pawag ver, Ghig sa ve muhd mig awg khuhn gehe maq gha. ");
INSERT INTO lhi_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Awg suhr awg sar geh pawag che ted ceng awr lehr, awg suhr awg sar phehq che yaog. Awg ha phu geh pawag che ted ceng awr lehr, awg ha phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nig hehd awg suhx te pawz gha kawq pawag che yaog lehz ngag nawg haq koz ax che haq ta and. ");
INSERT INTO lhi_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Muhd huh awr lehr, khar lo mez veh gad liz mez veh lehq, awg khuhd u ve haq nawg kad che yaog. Kheh ma khuhd, khar lo mez lag che lehq nar, khar lo mez veh tug lehq nar, nawg maq sir. Awg ha phu awg khuhn pawag che chaw awg gha lia awr lehr, u ve haq sur daq che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Niq kawd der kawq koz che, “Che teq pa khawd-ehg kheh te phehaq gha tuawg le,” lehz yawd haq na ngawx che te yand, ");
INSERT INTO lhi_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yer suq kawq koz che, “Nawg awr lehr Id sar rer laq chaw teq pa awg khuhn lo Sar lar te ghad phehq liz, awg lawn che teq pa haq nawg maq sir la. ");
INSERT INTO lhi_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ngag nawg haq awg cehg mag koz ax laq, ngag hehd sir che awg ceng awg lawn haq ngag hehd koz lehq, ngag hehd mawg che awg ceng awg lawn haq ngag hehd sax khiz khanr che yaog. Kheh ma khuhd, ngag hehd sax khiz khanr che haq nig hehd mad haq yug. ");
INSERT INTO lhi_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mig gig haq caz daq che awg ceng teq pa awg lawn ngag nig hehd haq koz ax vehr che liz nig hehd maq yonr ver, muhd nuh maq haq caz daq che awg ceng awg lawn ngag nig hehd haq koz ax ver, khawd-ehg kheh te lehq nig hehd yonr tuawg le. ");
INSERT INTO lhi_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Muhd nuh maq lo yaq che Chaw yad ve Yad phu ma hez ver, chaw te ghad-eg liz muhd nuh maq lo ma taez jaw. ");
INSERT INTO lhi_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Heh pir khuhn lo Mod ser vig haq chid taz che heh, Chaw yad ve Yad phu haq liz chid taz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Yawd haq kha yonr che chaw awg gha lia co tiq ha tiq gha tug, yawd haq chid taz vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Awg lawn ghod ver, Ghig sa mig gig yad haq haq jad cheaq te lehq, yawd ved Yad phu tinr-a pehar che yaog. Yad phu haq kha yonr che chaw awg gha lia maq gha lug maq gha sez lehq co tiq ha tiq haq liz gha tug awg pun, Ghig sa yawd ved Yad phu tinr-a pehar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Awg lawn ghod ver, mig gig yad haq suhx jehg tug, Ghig sa yawd ved Yad phu haq mig gig khod-aq lo lag peha che ma hez. Kheh ma khuhd, Yad phu haq te lehq mig gig yad thaer khuhq che haq gha tug yawd lag peha che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yad phu haq yonr che chaw awr lehr, Ghig sa ve suhx jehg che haq maq gha khanr. Maq yonr che chaw awr lehr, Ghig sa ve Yad phu tinr-a ve awg meh haq maq yonr che haq te lehq, a meha liz Ghig sa ve suhx jehg suhx taz che haq gha khanr vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","I hehd suhx jehg suhx taz che che ve haq gha khanr che awr lehr mig gig khod-aq lo awg ghiz gehag vehr liz, mig gig yad teq pa ve kanx teq pa awr lehr haeg cheaq te lehq, awg ghiz haq keh i hehd naz hoq che haq haq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Awg lawn ghod ver, awg haeg teq pa haq te che chaw awr lehr, awg ghiz haq ngawx bawg lehq, yawd te che teq pa maq gha tuhaz tug, awg ghiz geh yawd mad lag. ");
INSERT INTO lhi_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kheh ma khuhd, awg cehg mag cawd che haq te che chaw awr lehr, yawd te che teq pa Ghig sa haq cud lehq te che lehz tuhaz tug, awg ghiz geh yawd lag che yaog,” lehz koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","U ve awg khaz nuhr Yer suq he lehq yawd ved awg laq ghuhd teq pa Yud daq muhd mig lo kae che yaog. Yawd i hehd geh u huh chehd lehq, su haq baz tiz sar pid chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Sar lenr med awg pad huh Ehr nonr lehd koz che ted kag huh a kaz cawg mad che haq te lehq, Yod hanr liz u huh su haq baz tiz sar pid chehd che yaog. Chaw teq pa u huh kae lehq baz tiz sar khanr yug chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Awg lawn ghod ver, Yod hanr awr lehr thawnr khuhn maq gha geh ser. ");
INSERT INTO lhi_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Awg yand u ve haq, Yod hanr ve awg laq ghuhd ted pehg awr lehr, daq vid kehg vid tug a kaz chuhd che awg lid awg lawn Yud daq chaw te ghad geh tawd ghawg daq chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","I hehd Yod hanr chehd lo lag lehq koz che, “Rar bid-og, nawg Yawd danr lawg kax ox pax awr lo chehd-ag huh nawg geh chehd jaw lehq, nawg yawd awg lawn haq sax khiz khanr che te ghad awr lehr, su haq baz tiz sar pid chehd lehq chaw awg gha lia yawd chehd lo veh chehd che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yod hanr kawq koz che, “Ghig sa yawd haq pid che ted ceng ma hez ver, chaw yad awr lehr ted cear liz maq gha hawg. ");
INSERT INTO lhi_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","‘Ngag Khreq ma hez. Ngag awr lehr yawd awg ghud suhr lag peha che chaw te ghad phehq che yaog,’ lehz ngag koz che haq nig hehd awg ton ngag awg pun sax khiz khanr gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Awg phad mawd he tug yad mid hax haq gha che te ghad awr lehr, awg mid ma he che phad phehq che yaog. Awg pad huh hox lar lehq awg mid ma he che phad ve awg khuhd haq na che awg chawd te ghad awr lehr, awg mid ma he che phad ve awg khuhd haq gha kad cheaq te lehq ha lehg jad che yaog. U ve heh te lehq, ha lehg che ted ceng ngag awg khuhn lo saw lawq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yawd awr lehr, gha ir veh muh veh tug yaog. Kheh ma khuhd ngag awr lehr, gha i veh yawnd veh tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Muhd nuh maq lo yaq che te ghad awr lehr, awg gha lia haq keh ir sehr phad phehq che yaog. Mig gig khod-aq lo ve chaw te ghad awr lehr, mig gig ve chaw phehq lehq mig gig ve awg lawn haq yawd koz che yaog. Muhd nuh maq lo yaq che te ghad awr lehr, awg gha lia haq keh ir sehr phad phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yawd gha mawg gha kad che awg ceng teq pa ve awg lawn haq yawd sax khiz khanr che yaog. Kheh ma khuhd, yawd sax khiz khanr che haq chaw te ghad-eg liz mad haq yug. ");
INSERT INTO lhi_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yawd sax khiz khanr che haq haq yug che chaw te ghad awr lehr, Ghig sa awr lehr awg cehg mag cawd jad che yaog lehd koz cunr dawz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ghig sa peha lar che te ghad awr lehr, Ghig sa ve tawd khuhd haq yaw che yaog. Awg lawn ghod ver, Ghig sa yawd haq Awg ha phu kha lawq ghad pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Awr pa awr lehr, Yad phu haq haq lehq, awg ceng awg gha lia yawd ved laq khuhn lo chid aq vid peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yad phu haq yonr che chaw awr lehr, co tiq ha tiq cawg che yaog. Yad phu haq mad yonr che chaw awr lehr, co tiq ha tiq haq maq gha mawg. Yawd awg thag huh Ghig sa nez nag che ted ceng cawg lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Jawd mawd Yer suq su haq yawd ved awg laq ghuhd phehaq vid lehq baz tiz sar pid chehd che awr lehr, Yod hanr su haq awg laq ghuhd phehaq vid lehq baz tiz sar pid che haq keh mad che haq Phar rir sehd teq pa gha kad che yaog. (Kheh ma khuhd, Yer suq yawd awg ton su haq baz tiz sar pid che ma hez. Yawd ved awg laq ghuhd teq pa lehax pid che yaog.) Phar rir sehd teq pa awg lawn che ve haq gha kad vehor lehz Jawd mawd Yer suq gha sir che te yand, ");
INSERT INTO lhi_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yud daq muhd mig lo yawd tuhez lehq, Gar liq lehd muhd mig lo te pawz kawq kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yawd awr lehr Sar mar riq muhd mig haq gha phanr kae cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kheh te cheaq te lehq, Sar mar riq muhd mig awg khuhn cawg che Sud khar meh che med te med lo yawd gaeg che yaog. Med u ve awr lehr, Yar koq yawd ved yad par Yod sehq haq pid lar haz che mig gig te pez haq ned che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","U huh Yar koq ve nang baw cawg che yaog. Yer suq yaq kaw tod lag che teq chuhd cheaq te lehq, nang baw awg pad huh mi chehd che yaog. Awg yand u ve awr lehr, muhd kaw cuhaz te yand cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sar mar riq yad mid te ghad a kaz ca khoag che yaog. Yer suq awr lehr, “Ngag haq a kaz a cehax tawa laoq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","U ve awg yand khuhn yawd ved awg laq ghuhd teq pa awr lehr, med khuhn cad tug ca vig veh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sar mar riq yad mid kawq koz che, “Nawg Yud daq chaw phehq liz, a thoq te ngag Sar mar riq yad mid geh a kaz lawg dawg cheawg le,” lehd yawd haq koz vid che yaog. Awg lawn ghod ver, Yud daq chaw he lehq Sar mar riq chaw teq pa awr lehr awg chawd maq te daq cheaq te lehq che kheh koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yer suq kawq koz che, “Ghig sa pehar che laq sawnr he lehq ‘Ngag haq a kaz a cehax tawa laoq,’ lehz nawg haq koz ax che chaw haq nawg sir ver, nawg yawd geh lawg tug yaog. Kheh te lehq, yawd liz nawg haq co ha teq vid gha che a kaz tawa tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yad mid u ve kawq koz che, “Jawd mawd-og, nawg a kaz nex tug teq chaweh liz mad cawg. Nang baw che nax jad che yaog. Co ha teq vid gha che a kaz haq nawg khar lo gha tuawg le. ");
INSERT INTO lhi_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A nig ved awr pa Yar koq awr lehr, nang baw che ngag hehd haq pehar lar che yaog. Yawd awg ton liz, yawd ved awg yad awg dug teq pa liz, yawd ved ced cag teq pa liz, nang baw che haq dawg che yaog. Nawg awr lehr yawd haq keh ir che lehq la,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yer suq kawq koz che, “A kaz che haq kha dawg che chaw awr lehr, a kaz kawq sex tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kheh ma khuhd, ngag yawd haq pid tug a kaz haq kha dawg che chaw awr lehr, te pawz-a liz a kaz mad kawq sex. Ngag yawd haq pid tug a kaz awr lehr, yawd awg khuhn co tiq ha tiq tuhaz che a kaz khuh phehq tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yad mid u ve kawq koz che, “Jawd mawd-og, ngag a kaz maq gha kawq sex tug he lehq chuhr huh a kaz maq gha kawq khoag tug, a kaz u ve ted ceng ngag haq a cehax pehar laoq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yer suq awr lehr, “Nawg ved awg phad mawd haq ca kug veha lehq chuhr huh kawq lar-oq,” lehz yawd haq koz vid che te yand, ");
INSERT INTO lhi_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Ngag awg phad mawd mad cawg,” lehz yad mid u ve yawd haq kawq koz vid che yaog. Yer suq kawq koz che, “Nawg awg phad mawd mad cawg lehz nawg koz che awr lehr cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Awg lawn ghod ver, nawg awg phad mawd ngad ghad cawg jaw peg lehq, a meha nawg geh chehd chehd che te ghad awr lehr nawg ved awg phad mawd ma hez. Nawg che kheh koz che awr lehr, cawd jad che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yad mid u ve kawq koz che, “Jawd mawd-og, nawg awr lehr Ghig sa ve cuh kar var phehq che yaog lehz a meha ngag gha sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ngag hehd ve a pux a pi teq pa awr lehr, keh dig che awg thag huh Ghig sa haq a kor pi che yaog. Kheh ma khuhd, Yer ruq sar lehnr med awg khuhn lehax Ghig sa haq a kor gha pi cawd che yaog lehd nig hehd Yud daq chaw koz che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yer suq koz che, “Yad mid-og, ngag koz che tawd khuhd haq yonr-oq. Keh dig che ted dig awg thag huh lehd ma koz, Yer ruq sar lehnr med awg khuhn lehd ma koz, Awr pa Ghig sa haq u huh nig hehd a kor maq pi tug ve awg yand gag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nig hehd awr lehr, nig hehd maq sir che haq a kor pi che yaog. Ngag hehd awr lehr, ngag hehd sir lar che haq a kor pi che yaog. Awg lawn ghod ver, thaer khuhq che ted ceng awr lehr, Yud daq chaw teq pa geh lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kheh ma khuhd, awg cehg mag a kor pi che chaw teq pa awr lehr, co ha awg khuhn he lehq awg cehg mag cawd che awg khuhn Awr pa Ghig sa haq a kor pi tug awg yand gag vehr chehd lehq, a meha liz gag vehr che yaog. Awg lawn ghod ver, Awr pa Ghig sa awr lehr, yawd haq a kor pi tug u kheh te a kor pi che chaw teq pa haq ca chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ghig sa awr lehr awg ha phehq che yaog. Kheh te lehq, yawd haq a kor pi che chaw teq pa awr lehr, co ha awg khuhn he lehq awg cehg mag cawd che awg khuhn a kor gha pi che yaog,” lehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yad mid u ve kawq koz che, “Mir six yaq lag tug haq ngag sir che yaog. Yawd lag gag che te yand, yawd a nig haq awg ceng gha lia koz mar ax tug yaog,” lehz Yer suq haq koz vid che yaog. (Mir six yaq lehd koz che awr lehr, Khreq haq koz che yaog.) ");
INSERT INTO lhi_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yer suq kawq koz che, “Nawg haq tawd yaw chehd che ngag awr lehr, yawd yaog,” lehz yad mid u ve haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Awg yand u ve khuhn yawd ved awg laq ghuhd teq pa kawq gag vehr lehq, yad mid geh yawd tawd yaw daq chehd che haq i hehd and che yaog. Kheh ma khuhd, “Nawg a thoq haq he gad lehq le. A thoq te yawd geh nawg tawd yaw daq chehd cheawg le,” lehz te ghad-eg liz maq na ngawx. ");
INSERT INTO lhi_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kheh te lehq, yad mid u ve awr lehr, yawd ved a kaz mawq khu haq teh lar haz lehq, med awg khuhn lo koeq lehq med yad teq pa haq koz vid che, ");
INSERT INTO lhi_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Ngag kha te jaw che awg lawn awg gha lia ngag haq koz ax vehr che chaw te ghad haq ca ngawx laoq. Yawd awr lehr Khreq phehq che lehq nar,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","I hehd med khuhn tuhez lehq Yer suq chehd lo lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Awg yand u ve awg khuhn awg laq ghuhd teq pa koz che, “Rar bid-og, cad tug a cehax cad-oq,” lehz yawd haq lawg khawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kheh ma khuhd, yawd awr lehr, “Nig hehd maq sir che cad tug ngag cawg che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kheh te lehq, awg laq ghuhd teq pa koz che, “Chaw ted pehg pehar yawd haq cad tug lag car vid lehq nar,” lehz te ghad he lehq te ghad na daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yer suq kawq koz che, “Ngag haq peha che phad ve a lor haq te lehq, yawd ved kanx haq te peg che awr lehr, ngag ved cad tug phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Har pa uhg lehd gaeg ver, cag ghiq che awg yand gaeg tug yaog lehz nig hehd koz che ma hez hawg la. Kheh ma khuhd, ngawx lor, ngag nig hehd haq koz ax laq, ha teq pa haq chid ngawx-oq. A meha liz cag ghiq tug a cag meh vehr lehq six-i ghad phehq vehor. ");
INSERT INTO lhi_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ti sehr phad he lehq ghiq sehr phad teq geha gha ha lehg tug, cag ghiq sehr phad awr lehr ghad phuhd gha chehd vehr lehq co tiq ha tiq awg pun awg sir ghawz ke chehd vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kheh te cheaq te lehq, ‘Te ghad ti lehq te ghad ghiq che yaog,’ lehd koz che tawd te khuhd awr lehr, che haq cawd daq jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nig hehd kanx maq gha te lar kig huh ngag nig hehd haq cag ca ghiq pe che yaog. Su kanx te lar lehq, i hehd te lar che kanx u ve ve ghiq kig awg khuhn nig hehd geh vehor,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Yad mid u ve awr lehr, “Ngag kha te jaw che awg lawn awg gha lia yawd ngag haq koz ax che yaog,” lehz sax khiz khanr che haq te lehq, med u ve awg khuhn chehd che Sar mar riq chaw laex ghad Yer suq haq yonr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kheh te cheaq te lehq, Sar mar riq chaw teq pa yawd chehd lo lag gag thad, i hehd geh chehd tug yawd haq lawg khawx che yaog. Kheh te lehq, yawd u huh niq ni chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kheh te lehq, yawd ved tawd khuhd haq te lehq u ve haq keh mad-ag che chaw laex ghad liz kawq yonr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","I hehd awr lehr yad mid u ve haq koz vid che, “Nawg ved tawd khuhd haq lehax te lehq ngag hehd yonr che ma hez. Awg lawn ghod ver, ngag hehd awg ton yawd ved tawd khuhd haq ngag hehd gha kad lehq, chaw cheawg lehr mig gig yad teq pa ve Thaer khuhq par awg cehg mag phehq che haq ngag hehd sir che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yer suq u huh niq ni chehd peg khaz nuhr, Gar liq lehd muhd mig lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Awg lawn ghod ver, Ghig sa ve cuh kar var awr lehr, a sug yawd ved muhd mig awg khuhn awg mig awg phond mad cawg lehz, Yer suq yawd awg ton sax khiz khanr jaw che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kheh ma khuhd, yawd Gar liq lehd muhd mig lo gaeg che te yand, Gar liq lehd chaw teq pa yawd haq haq yug che yaog. Awg lawn ghod ver, chaw u ve teq pa awr lehr, Yer ruq sar lehnr med lo Par sar khar pawehd awg khuhn kae jaw lehq, pawehd u ve awg khuhn yawd kha te che awg hez teq pa haq gha mawg vehr che haq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Kheh te lehq, a kaz haq yawd a pehx med ghig phehaq vid vehr che ted kag, Gar liq lehd muhd mig Kar naq khaz khuhn yawd te pawz kawq gag che yaog. Awg yand u ve haq, Kar per nar unr med awg khuhn lo chehd che jawd mawd haq kanx te vid var chaw ir te ghad ve yad par nag chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Yer suq awr lehr, Yud daq muhd mig lo tu lehq Gar liq lehd muhd mig lo lag gag vehr che awg lawn haq jawd mawd ve kanx te var u ve gha kad che te yand, yawd ved yad par suh vehr tez cheaq te lehq, Yer suq lag lehq yawd haq ghu na vid tug, yawd Yer suq haq ca lawg khawx-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Kheh te lehq Yer suq koz che, “Nig hehd awg hez he lehq and tug teq pa haq maq gha mawg ver, nig hehd ca yonr tug ma hez,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","“Jawd mawd-og, ngag ved yad maq suh ser huh a cehax lar-oq,” lehz jawd mawd ve kanx te var u ve yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yer suq kawq koz che, “Koeq lor. Nawg ved yad par gha teq chehd tug yaog,” lehz yawd haq koz vid che yaog. Jawd mawd ve kanx te var u ve awr lehr, Yer suq koz vid che tawd khuhd haq yonr lehq kawq veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Yawd koeq tod che te yand, yawd ved awg ceg teq pa yawd haq phud daq lehq, “Nawg ved yad par na vehor,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kheh te lehq, “Yawd khar thad te yand tanr na vehr cheawg le,” lehd koz na ngawx che te yand, “A mig ni muhd phiq phawd awr teq nar rir thad huh, yawd kaz nag che na vehr che yaog,” lehz i hehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kheh te lehq, awg yand u ve awr lehr, “Nawg ved yad par gha teq chehd tug yaog,” lehz Yer suq yawd haq koz vid che awg yand haq cawd che yaog lehz awr pa sir lehq, yawd awg ton he lehq yawd ved yehg yad ka yad awg gha lia liz Yer suq haq yonr vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Awg hez che awr lehr, Yer suq Yud daq muhd mig lo tu lehq Gar liq lehd muhd mig lo lag gag vehr khaz nuhr, yawd te che awg hez nid ceng ted ceng phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","U ve awg khaz nuhr, Yud daq chaw teq pa ve pawehd te che awg yand gag vehr lehq, Yer suq Yer ruq sar lehnr med lo taez che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yer ruq sar lehnr med awg khuhn, Yawg Tar meq pheq awg pad huh, Her brehd khuhd Ber ter sar daq lehd koz che ghig po ted mag cawg che yaog. Ghig po u ve awg jad huh awg thang beh lar che yaq kaw tod kig ngad kag cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yaq kaw tod kig u ve teq pa awg khuhn nag che chaw, mehz cox che chaw, khi lug che chaw he lehq khi kud laq kuhr suh che chaw kha peh vad-ag yuhq chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Awg lawn ghod ver, Ghig sa ve muhd nuh maq cuh yad te ghad awg yand awg yand ver ghig po che ve khuhn yaq lehq a kaz haq te hiz vid che yaog. A kaz hiz vehr che te yand, awg kawd ped maq gha gehe che chaw te ghad awr lehr, yawd nag che a nar a thoq ted ceng lehd ma koz, na vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Sehz chi hex khuhq kha gag nag chehd che chaw te ghad awr lehr, u huh chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yer suq awr lehr, chaw u ve haq gha mawg lehq, yawd nag muh jad vehr che haq gha sir che te yand, “Nawg chehd sa vid gad la,” lehd koz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Chaw nag u ve te ghad kawq koz che, “Jawd mawd-og, a kaz hiz vehr che te yand, ghig po awg khuhn ngag haq yug kea tug chaw mad cawg. Kheh te lehq, ngag yaeq tod che te yand, awg kag awr ve chaw te ghad ngag ghud med awr geh veh che yaog,” lehz Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yer suq koz che, “Tu lor. Nawg ved yuhq phi haq yug ve lehq kae-oq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chaw u ve te ghad awr lehr, teq pear lehax na vehr lehq, yawd ved yuhq phi haq yug ve lehq veh che yaog. U ve teq ni awr lehr, Sa ba to awg ni phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kheh te cheaq te lehq, na vehr che chaw u ve te ghad haq Yud daq chaw ve awg hox awg nax teq pa koz vid che, “Yaq ni awr lehr Sa ba to awg ni yaog. Nawg ved yuhq phi haq yug ve kae che awr lehr ma cawd,” lehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Awg yand u ve khuhn yawd koz che, “Ngag haq ghu na ax che chaw te ghad awr lehr, ‘Nawg ved yuhq phi haq yug ve lehq kae-oq,’ lehz ngag haq koz ax che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","I hehd kawq koz che, “‘Nawg ved yuhq phi haq yug ve lehq kae-oq,’ lehd koz ax che chaw a suawg le,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Na vehr che chaw u ve te ghad awr lehr, yawd haq ghu na ax che chaw te ghad a sug lehq nar yawd maq sir. Awg lawn ghod ver, u huh chaw chehd mad jad cheaq te lehq, Yer suq tuhz veh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","U ve awg khaz nuhr, bon yehg nux awg khuhn Yer suq yawd haq gha mawg lehq, “Ngawx ser, nawg chehd sa vehr che yaog. Che haq keh lex lehq tuq che khanr che haq nawg maq gha kawq khanr tug, vend bax tad kawq te,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Chaw u ve te ghad tuhez lehq, “Ngag haq ghu na ax che chaw te ghad awr lehr Yer suq yaog,” lehz Yud daq chaw ve awg hox awg nax teq pa haq ca koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sa ba to awg ni teq ni huh Yer suq u kheh te cheaq te lehq, Yud daq chaw ve awg hox awg nax teq pa yawd haq tanr du deh vid veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kheh ma khuhd, Yer suq awr lehr i hehd haq koz vid che, “Ngag Awr pa awr lehr, a meha kha gag kanx te chehd che yaog. Kheh te lehq, ngag liz kanx te chehd che yaog,” lehz i hehd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kheh te lehq, yawd Sa ba to awg ni haq te lug che awg khod-aq liz Ghig sa haq yawd ved Awr pa lehd koz lehq, yawd awg ton haq Ghig sa heh te sawnr tar che haq te lehq, Yud daq chaw ve awg hox awg nax teq pa awr lehr lex lehq yawd haq khawd-ehg kheh te lehq gha dawz vehr tug haq ca che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kheh te cheaq te lehq Yer suq i hehd haq koz vid che, “Ngag nig hehd haq awg cehg mag koz ax laq, Yad phu awr lehr yawd khad yawad a lor cawd che heh teq chaweh liz te maq gha. Kheh ma khuhd Awr pa te chehd che haq gha mawg che heh lehax yawd te che yaog. Awg lawn ghod ver, Awr pa kha te che awg ceng gha lia haq Yad phu liz te che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Awg lawn ghod ver, Awr pa awr lehr Yad phu haq haq lehq yawd awg ton kha te che awg gha lia Yad phu haq pheq mar vid che yaog. Nig hehd gha and jad tug, awg ceng che ve teq pa haq keh ir che kanx teq pa liz Yad phu haq yawd pheq mar vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Awg lawn ghod ver, Awr pa awr lehr suh vehr che chaw teq pa haq kawq teq tuag vid lehq i hehd haq co ha teq che ted ceng pid che heh, Yad phu liz yawd pid gad che chaw teq pa haq co ha teq che ted ceng pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Awr pa awr lehr chaw te ghad-eg haq liz suhx mad jehg. Kheh ma khuhd, chaw awg gha lia Awr pa haq yawz yan che heh Yad phu haq liz yawz yan tug, suhx jehg tug kand pax awg gha lia yawd Yad phu haq chid aq vid vehr che yaog. Yad phu haq ma yawz yan che chaw awr lehr, yawd haq lag peha che phad, Awr pa haq liz ma yawz yan che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ngag nig hehd haq awg cehg mag koz ax laq, ngag ved tawd khuhd haq na yug lehq, ngag haq lag peha che phad haq yonr che chaw te ghad awr lehr, co tiq ha tiq cawg chehd vehr che yaog. Suhx jehg che haq yawd maq gha khanr. Kheh ma khuhd, suh che awg khuhn yawd pong vehr lehq, teq che awg khuhn gha geh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ngag nig hehd haq awg cehg mag koz ax laq, co ha phawd awr suh vehr che chaw teq pa Ghig sa ve Yad phu ve awg khuhd haq gha kad lehq gha kad che chaw teq pa co ha gha teq tug awg yand gag tug yaog. Awg yand u ve awr lehr a meha liz gag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Awg lawn ghod ver, Awr pa yawd awg khuhn co ha teq che ted ceng cawg che heh, Yad phu yawd awg khuhn liz co ha teq che ted ceng cawg tug Awr pa yawd haq a khawag pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kheh te lehq, suhx jehg tug kand pax liz yawd haq pid lar che yaog. Awg lawn ghod ver, yawd awr lehr chaw yad ve Yad phu phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Awg lawn che haq ta and. Awg lawn ghod ver, tur phuh awg khuhn chehd che chaw awg gha lia yawd ved tawd khuhd haq gha kad lehq ");
INSERT INTO lhi_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tur phuh awg khuhn tuhaz tug awg yand gaeg tug yaog. Daq che haq te che chaw teq pa awr lehr, co ha teq che ted ceng awg pun kawq teq tuag tug yaog. Haeg che haq te che chaw teq pa awr lehr, suhx jehg suhx taz tug awg pun kawq teq tuag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ngag awr lehr, ngag khad ngag ngag ved a lor cawd che heh teq chaweh liz te maq gha. Ngag gha kad che heh ngag suhx jehg che yaog. Ngag suhx jehg che awr lehr cawd che yaog. Awg lawn ghod ver, ngag ved a lor haq ngag maq te. Ngag haq peha lar che phad ve a lor haq lehax ngag te che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ngag awr lehr, ngag awg ton awg lawn haq sax khiz khanr che ver, ngag ved sax khiz awr lehr awg cehg mag ma hez. ");
INSERT INTO lhi_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ngag ved awg lawn haq sax khiz khanr che phad awg kag awr ve chaw te ghad cawg che yaog. Kheh te lehq, yawd ngag ved awg lawn haq sax khiz khanr che awr lehr, awg cehg mag cawd che yaog lehz ngag sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nig hehd awr lehr, Yod hanr chehd lo su haq kae pe lehq, awg cehg mag cawd che awg lawn haq yawd sax khiz khanr lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Chaw yad sax khiz khanr che haq ngag lor che ma hez. Kheh ma khuhd, nig hehd thaer khuhq che haq gha tug, ngag che kheh koz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yod hanr awr lehr, a mir toq chehd lehq awg ghiz pawd chehd che a mir khehd phehq che yaog. Nig hehd awr lehr, yawd ved awg ghiz haq teq cuhx te yand ha lehg gad che ni ma cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kheh ma khuhd ngag cawg lar che sax khiz awr lehr, Yod hanr ve sax khiz haq keh ir che yaog. Awg lawn ghod ver, peg thad kha gag te tug Awr pa ngag haq te cuha che kanx teq pa awr lehr, Awr pa ngag haq peha lar che yaog lehz ngag awg lawn sax khiz khanr che yaog. A meha liz kanx u ve teq pa haq ngag te chehd lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kheh te lehq, ngag haq peha lar che Awr pa liz, ngag awg pun sax khiz khanr che yaog. Nig hehd awr lehr, yawd tawd yaw che awg khuhd haq te pawz-a liz ma kad jaw. Yawd ved awg hoq awg han haq liz nig hehd te pawz-a liz mad mawg jaw. ");
INSERT INTO lhi_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yawd ved tawd khuhd liz nig hehd awg khuhn mad cawg. Awg lawn ghod ver, yawd peha lar che te ghad haq nig hehd maq yonr. ");
INSERT INTO lhi_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nig hehd awr lehr, Liq phu awg khuhn co tiq ha tiq haq gha tug yaog lehd duhd cheaq te lehq, Liq phu haq nig hehd kha nehax pheq ngawx ghawn ngawx che yaog. Liq phu u ve awr lehr, ngag awg lawn sax khiz khanr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kheh ma khuhd, nig hehd co ha teq che ted ceng haq gha tug, ngag geh nig hehd mad lag gad. ");
INSERT INTO lhi_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Chaw yad geh lag che awg mig awg phond haq ngag maq ca. ");
INSERT INTO lhi_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kheh ma khuhd, ngag nig hehd haq sir che yaog. Ghig sa ve haq pehnd che ted ceng nig hehd awg khuhn mad cawg che haq ngag sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ngag awr lehr, ngag Awr pa ve awg meh awg khuhn lag che liz, nig hehd ngag haq mad haq yug. Kheh ma khuhd, awg kag awr ve chaw te ghad a sug yawd ved awg meh awg khuhn lag ver, yawd haq nig hehd haq yug tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nig hehd te ghad he lehq te ghad haq pid daq che awg mig awg phond haq ha lehg lehq, te ghad lehax phehq che Ghig sa pid che awg mig awg phond haq maq ca cheaq te lehq, nig hehd awr lehr khawd-ehg kheh te lehq yonr gha tuawg le. ");
INSERT INTO lhi_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Awr pa mehz khuhd suhr huh ngag nig hehd haq vend bax tar ax tug lehd ta duhd. Nig hehd haq vend bax tar che chaw te ghad cawg che yaog. Yawd awr lehr, nig hehd ghad va chehd che Mod ser yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Awg lawn ghod ver, Mod ser haq nig hehd yonr ver, ngag haq liz nig hehd yonr tug yaog. Awg lawn ghod ver, yawd ngag ved awg lawn haq buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kheh ma khuhd, yawd buhq lar che liq teq pa haq nig hehd maq yonr ver, ngag ved tawd khuhd haq nig hehd khawd-ehg kheh te yonr tuawg le,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","U ve awg khaz nuhr, Yer suq awr lehr, Tir ber riq lehd koz che Gar liq lehd ghig po nux ox pax awr lo khanr kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nag che guhg che chaw teq pa awg khuhn yawd te che awg hez teq pa haq gha mawg cheaq te lehq, chaw awg mor nux yawd khaz nuhr ghaq kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Kheh te lehq Yer suq awr lehr, kehaq lo taez lehq, u huh yawd ved awg laq ghuhd teq pa geh mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Awg yand u ve khuhn, Yud daq chaw teq pa ve Par sar khar pawehd te tug awg yand gag vehr tez che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yer suq chid ngawx lehq, chaw awg mor nux yawd chehd lo lag tod che haq gha mawg che te yand, yawd Phid liq haq koz vid che, “Chaw kheh ma ve gha cad tug, a nig khaor mod khar lo ca vig tuawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yawd che kheh koz na ngawx che awr lehr, Phid liq haq lawnd ngawx che yaog. Awg lawn ghod ver, yawd khawd-ehg kheh te tug haq Yer suq yawd awg ton sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Phid liq kawq koz che, “Chaw kheh ma ve khaor mod te ghad a cehax nehax gha cad tug, phu niq ha thehq phuhd vig che liz mad lawq tag,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yawd ved awg laq ghuhd teq pa awg khuhn awg laq ghuhd te ghad, Sid monr Per troq ve awg nax var Anr drehr koz che, ");
INSERT INTO lhi_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“A choq te lar che khaor mod ngad dig he lehq ngad nehax niq kheh cawg che yad par nehax te ghad chuhr huh chehd chehd che yaog. Kheh ma khuhd, chaw kheh ma ve awg pun che teq pa awr lehr a thoq awg bon cawag le,” lehz Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yer suq awr lehr, “Chaw che teq pa haq mi cuh vid-oq,” lehd koz vid che yaog. U huh muhq de phehq che yaog. Kheh te lehq, u huh mi chehd che chaw awr lehr, haw khaz lehax ngad hinx ghad kheh taw cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Awg yand u ve khuhn Yer suq awr lehr, khaor mod u ve teq pa haq yug lehq bon haq chid muh peg khaz nuhr, mi chehd che chaw teq pa haq pehg vid che yaog. U ve heh te lehq, ngad sar haq liz i hehd cad gad che heh pehg vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kheh te lehq, i hehd kha buhz gha cad peg che te yand yawd koz che, “Teq chaweh maq gha sond vid tug, cad lex lar che teq pa haq ca kawq ghawz-oq,” lehz yawd ved awg laq ghuhd teq pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kheh te cheaq te lehq, i hehd kawq ghawz che te yand, a choq te lar che khaor mod ngad dig haq cad lex lar che teq pa awr lehr, teq chi niq khuhr luhd gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kheh te lehq, yawd te che awg hez che haq chaw kheh ma ve gha mawg che te yand, “Chaw che awr lehr, mig gig khod-aq lo lag tug ve Ghig sa ve cuh kar var u ve te ghad awg cehg mag phehq che yaog,” lehz i hehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Chaw u ve teq pa awr lehr, yawd haq jawd mawd yug te cuhag lehd duhd che haq Yer suq sir cheaq te lehq, teq pear lehax yawd tuhz veh lehq te ghad lehax kehaq lo kawq taez che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Muhd phiq vehr huh, yawd ved awg laq ghuhd teq pa ghig po huh yaeq lehq, ");
INSERT INTO lhi_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","huh lawd kor khuhn gehe peg lehq, ghig po nux ox pax awr Kar per nar unr med lo khanr kae tod che yaog. Awg yand u ve haq muhd sux naz jad vehr liz, Yer suq i hehd chehd lo mad lag gag ser. ");
INSERT INTO lhi_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kheh te lehq, muhd huh nux mez jad lehq, a kaz duhd taz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","I hehd huh lawd kor haq ngad kid lod khuhq kid lod kheh taw ghawz kae vehr che te yand, Yer suq ghig po awg thag huh yaq kaw tod lehq, huh lawd kor awg pad huh lag tod che haq i hehd gha mawg lehq kuhz jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Yer suq awr lehr, “Ngag yaog. Ta kuhz,” lehd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kheh te lehq, i hehd yawd haq huh lawd kor awg khuhn ha lehg ha ka haq yug lehq, huh lawd kor awr lehr i hehd kae tod che ted kag lo teq pear lehax gag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Awg khaz nuhr teq ni ghig po nux ox pax awr lo chehd lar haz che chaw awg mor nux awr lehr, a mig ni huh huh lawd kor nehax ted mag lehax cawg chehd che he lehq Yer suq awr lehr yawd ved awg laq ghuhd teq pa geh teq geha huh lawd kor u ve awg khuhn maq geh lehq, yawd ved awg laq ghuhd teq pa lehax veh che haq i hehd sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Kheh ma khuhd, Tir ber riq med lo lag che huh lawd kor teq pa awr lehr, Jawd mawd Yer suq bon haq chid muh peg khaz nuhr i hehd khaor mod gha cad kig awg pad huh lag gag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kheh te cheaq te lehq, Yer suq he lehq yawd ved awg laq ghuhd teq pa u huh ma chehd che haq chaw awg mor nux gha sir che te yand, huh lawd kor u ve teq pa haq i hehd cind lehq, Yer suq haq ca ngawx-eg tug Kar per nar unr med lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ghig po nux ox pax awr lo i hehd Yer suq haq gha mawg che te yand, “Rar bid-og, nawg chuhr huh khar thad lag cheawg le,” lehz i hehd yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yer suq kawq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, awg hez teq pa haq nig hehd gha mawg cheaq te lehq ngag haq ca che ma hez. Khaor mod kha buhz gha cad cheaq te lehq nig hehd ngag haq ca che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Lug vix sez vix che cad tug haq gha tug awg pun hax ceh nux maq taq pawnx te. Kheh ma khuhd, co co taer taer teq che co tiq ha tiq pid che, yeg che cad tug haq gha tug awg pun hax ceh nux teo. Cad tug u ve awr lehr, Chaw yad ve Yad phu nig hehd haq pehar tug ve cad tug phehq che yaog. Awg lawn ghod ver, Awr pa Ghig sa awr lehr chaw yad ve Yad phu haq cunr dawz lar vehor,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kheh te lehq, i hehd kawq koz che, “Ghig sa ve kanx te tug, ngag hehd khawd-ehg kheh gha te tuawg le,” lehz yawd haq na ngawx che te yand, ");
INSERT INTO lhi_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","“Yer suq kawq koz che, Ghig sa ve kanx te che ted ceng awr lehr, yawd peha lar che te ghad haq yonr che ted ceng phehq che yaog,” lehz i hehd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Kheh te lehq i hehd kawq koz che, “Ngag hehd gha mawg lehq nawg haq gha yonr tug, nawg a thoq awg hez haq te mar ax tuawg le. Nawg a thoq haq te mar ax tuawg le. ");
INSERT INTO lhi_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","A pux a pi teq pa gha cad tug awg pun, ‘Muhd nuh maq ve cad tug yawd i hehd haq pid che yaog,’ lehz buhq lar che heh, a nig ved a pux a pi teq pa awr lehr, heh pir khuhn mar naq sir haq gha cad che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Awg yand u ve haq Yer suq kawq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, muhd nuh maq ve cad tug nig hehd haq pehar che phad awr lehr Mod ser ma hez. Muhd nuh maq lo lag che awg cehg mag ve cad tug nig hehd haq pehar sehr phad awr lehr ngag ved Awr pa yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Awg lawn ghod ver, Ghig sa ve cad tug awr lehr, muhd nuh maq lo yaq lehq mig gig yad teq pa haq co ha teq vid gha che phad phehq che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","I hehd kawq koz che, “Jawd mawd-og, cad tug u ve ngag hehd haq khar thad liz pehar laoq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yer suq kawq koz che, “Ngag awr lehr co ha teq vid gha che cad tug phehq che yaog. Ngag geh lag che chaw awr lehr, mad kawq meoq. Ngag haq yonr che chaw awr lehr, a kaz te pawz-a liz mad kawq sex-og. ");
INSERT INTO lhi_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Kheh ma khuhd, ngag nig hehd haq koz ax laq. Nig hehd awr lehr, ngag haq mawg vehr liz maq yonr ser. ");
INSERT INTO lhi_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Awr pa ngag haq kha pehar lar che chaw teq pa awr lehr, ngag geh lag tug yaog. Ngag geh lag che chaw haq ngag ma chid bag. ");
INSERT INTO lhi_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Awg lawn ghod ver, ngag muhd nuh maq lo yaq che awr lehr, ngag ved a lor haq te tug yaq che ma hez. Ngag haq peha lar che phad ve a lor haq te tug awg pun ngag yaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ngag haq peha lar che phad ve a lor awr lehr che kheh yaog. Yawd ngag haq kha pehar lar che chaw teq pa te ghad-eg liz ngag maq gha sond vehr lehq, awg leh med ve awg ni awg khuhn lo ngag i hehd awg gha lia haq kawq teq tuag vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Awg lawn ghod ver, che ve awr lehr ngag Awr pa ve a lor cawd che yaog. Yad phu haq mawg lehq yonr che chaw awg gha lia awr lehr co co taer taer teq che co tiq ha tiq haq gha tug yaog. Awg leh med ve awg ni awg khuhn lo, chaw u ve teq pa haq ngag kawq teq tuag vid tug yaog,” lehz Yer suq i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Ngag awr lehr muhd nuh maq lo yaq che cad tug phehq che yaog,” lehz yawd koz cheaq te lehq, Yud daq chaw teq pa nez nag lehq yawd haq kaod koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Chaw che awr lehr, Yod sehq ve yad par Yer suq ma hez hawg la. Yawd ved awr pa awr ye haq ngag hehd sir chehd che ma hez hawg la. “Ngag muhd nuh maq lo yaq che yaog,” lehd a meha yawd khawd-ehg kheh te koz gha cheawg le lehz, i hehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Awg yand u ve khuhn Yer suq koz che, “Nig hehd ngag haq ta kaod koz. ");
INSERT INTO lhi_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ngag haq peha lar che phad Awr pa awr lehr, su haq ngag geh mad ghawg veha lag che ver, chaw te ghad-eg liz ngag geh lag maq gha. Kheh te lehq, ngag geh ghawg veha lag che chaw haq awg leh med ve awg ni awg khuhn lo, ngag kawq teq tuag vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ghig sa ve cuh kar var teq pa ve liq awg khuhn, ‘Ghig sa awr lehr i hehd awg gha lia haq mar vid tug yaog,’ lehd koz buhq lar che yaog. Awr pa geh kha gha kad lehq kha gha hend peg che chaw awg gha lia awr lehr, ngag geh lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ngag che kheh koz che awr lehr, chaw te ghad ghad Awr pa haq mawg jaw che yaog lehd koz che ma hez. Ghig sa lo lag che te ghad ma hez ver Awr pa haq mad mawg jaw. Yawd te ghad lehax Awr pa haq mawg jaw che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ngag nig hehd haq awg cehg mag koz ax laq, yonr che chaw awr lehr, co tiq ha tiq cawg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ngag awr lehr, co ha teq vid gha che cad tug phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nig hehd ve a pux a pi teq pa awr lehr, heh pir khuhn lo mar naq sir haq gha cad liz, i hehd suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kheh ma khuhd, cad tug che ve awr lehr muhd nuh maq lo yaq che cad tug phehq che yaog. Cad tug che ve haq cad che chaw te ghad awr lehr maq gha suh tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ngag awr lehr, muhd nuh maq lo yaq che co ha teq vid gha che cad tug phehq che yaog. Cad tug che ve haq cad che chaw khar ve te ghad lehd ma koz, co co taer taer co ha teq tug yaog. Kheh te lehq mig gig yad ve co ha gha teq tug awg pun, ngag pehar tug ve cad tug u ve awr lehr, ngag ved awg sar yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Kheh te cheaq te lehq, Yud daq chaw teq pa koz che, “Chaw che awr lehr, yawd ved awg sar a nig haq khawd-ehg kheh te canr gha tuawg le,” lehd i hehd te ghad lehq te ghad tawd ghawg daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yer suq kawq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, Chaw yad ve Yad phu ve awg sar haq ma cad lehq yawd ved awg suhr haq mad dawg ver, nig hehd awg khuhn co ha teq che ted ceng mad cawg. ");
INSERT INTO lhi_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ngag ved awg sar haq cad lehq ngag ved awg suhr haq dawg che chaw te ghad awr lehr, co co taer taer teq che co tiq ha tiq cawg che yaog. Awg leh med teq ni awg khuhn ngag yawd haq kawq teq tuag vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Awg lawn ghod ver, ngag ved awg sar awr lehr, awg cehg mag cad tug phehq che yaog. Ngag ved awg suhr liz awg cehg mag dawg tug phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ngag ved awg sar haq cad lehq ngag ved awg suhr haq dawg che chaw awr lehr, ngag awg khuhn chehd lehq, ngag liz yawd awg khuhn chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Teq chehd che Awr pa ngag haq lag peha lehq, yawd haq te lehq ngag teq chehd che heh, ngag haq cad che chaw liz, ngag haq te lehq co ha teq chehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Cad tug che ve awr lehr, muhd nuh maq lo yaq che yaog. Cad tug che ve awr lehr, a pux a pi teq pa gha cad che cad tug haq sur che ma hez. Cad tug u ve haq i hehd gha cad peg liz, suh che yaog. Cad tug che ve haq cad che chaw awr lehr, co co taer taer co ha gha teq tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kar per nar unr med lo cawg che Yud daq chaw ve bon lawg kig awg khuhn yawd mar vid chehd-ag huh, awg lawn che teq pa haq yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yawd ved awg laq ghuhd teq pa tawd u ve haq gha kad che te yand, i hehd laex ghad koz che, “Tawd che ve awr lehr na har jad che yaog. A sug na gha tuawg le,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yawd ved awg laq ghuhd teq pa awg lawn che haq kaod koz chehd che haq Yer suq yawd ved ni ma awg khuhn lo sir che te yand yawd koz che, “Tawd che ve haq te lehq nig hehd nez nag lehq la. ");
INSERT INTO lhi_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Chaw yad ve Yad phu awr lehr, awg kawd maq chehd jaw kig lo kawq taz veh che haq nig hehd gha mawg ver, khawd-ehg kheh duhd tuawg le. ");
INSERT INTO lhi_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Co ha teq che ted ceng pid sehr phad awr lehr Awg ha phu yaog. Awg suhr awg sar awr lehr, teq chaweh awg bon mad cawg. Ngag nig hehd haq koz ax che tawd khuhd che teq pa awr lehr, co ha he lehq a saq teq che ted ceng phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kheh ma khuhd, nig hehd awg khuhn ve chaw ted pehg pehar maq yonr,” lehz i hehd haq koz vid che yaog. Awg lawn ghod ver, maq yonr che chaw teq pa a suawg le ghod che haq lehd ma koz, yawd haq chid aq vid tug chaw te ghad a suawg le ghod che haq lehd ma koz, awg kawd maq thad liz Yer suq sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Kheh te lehq yawd koz che, “Che ve haq te lehq ngag Awr pa a khawag maq pehar ver, chaw te ghad-eg liz ngag geh lag mad gag hawg, lehz ngag nig hehd haq koz ax lar peor,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","U ve awg khaz nuhr yawd ved awg laq ghuhd laex ghad kawq phuhz kawq veh lehq yawd geh mad kawq te tod che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","“Nig hehd liz kawq koeq tuawg la,” lehz cuh yad teq chi ni ghad haq Yer suq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sid monr Per troq kawq koz che, “Jawd mawd-og, ngag hehd a sug geh kae tuawg le. Nawg awr lehr co tiq ha tiq pid che tawd khuhd cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nawg awr lehr Ghig sa ve Daq kehg sehr Phad te ghad phehq che haq ngag hehd yonr lehq sir lar peor,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yer suq kawq koz che, “Ngag nig hehd teq chi ni ghad haq lez yug lar che ma hez hawg la. Kheh ma khuhd, nig hehd awg khuhn te ghad awr lehr, ned haeg phehq che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yawd che kheh koz che awr lehr, Sid monr Id sar kar rir oq ve yad Yud daq haq koz gad che yaog. Awg lawn ghod ver, yawd awr lehr cuh yad teq chi ni ghad awg khuhn chehd lehq, Yer suq haq chid aq vid tug te ghad phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","U ve khaz nuhr Yer suq awr lehr, Gar liq lehd muhd mig awg khuhn ted kag peg ted kag kae che yaog. Yud daq chaw ve awg hox awg nax teq pa yawd haq dawz vehr tug ca chehd cheaq te lehq, Yud daq muhd mig awg khuhn yawd maq kae. ");
INSERT INTO lhi_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Awg yand u ve haq, Yud daq chaw teq pa Hax po pawehd te che awg yand gag vehr tez che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yawd ved awg nax var teq pa koz che, “Nawg te che kanx teq pa haq nawg ved awg laq ghuhd teq pa gha mawg tug, chuhr huh tuhz kae lehq Yud daq muhd mig lo kae-oq. ");
INSERT INTO lhi_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Awg lawn ghod ver, a sug yawd ved awg meh buhg veh tug he gad che chaw te ghad awr lehr, taq chuhax gawr ghad yawd teq chaweh ma khuhd te. Kanx che teq pa haq nawg te chehd ver, mig gig yad teq pa haq nawg awg ton kha sehax maw vid-oq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Awg lawn ghod ver, yawd ved awg nax var teq pa liz yawd haq maq yonr. ");
INSERT INTO lhi_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kheh te lehq Yer suq koz che, “Ngag ved awg yand mad gag ser. Kheh ma khuhd, nig hehd awg pun awr lehr khar thad liz awg yand cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mig gig yad nig hehd haq cand maq gha. Kheh ma khuhd ngag haq cand che yaog. Awg lawn ghod ver, i hehd te che kanx teq pa awr lehr haeg jad che yaog lehz ngag sax khiz khanr cheaq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Pawehd u ve awg khuhn lo nig hehd kae-oq. Ngag ved awg yand kha nehax mad gag ser cheaq te lehq, pawehd u ve awg khuhn lo ngag maq kae ser,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yawd u kheh koz vid peg lehq, Gar liq lehd muhd mig awg khuhn chehd lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yawd ved awg nax var teq pa pawehd u ve awg khuhn kae lar peg khaz nuhr, yawd liz su haq mad mawg cuh vid lehq taq chuhax gawr lehd te veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pawehd u ve awg khuhn lo Yud daq chaw ve awg hox awg nax teq pa yawd haq ca lehq, “Yawd khar lo chehd-aq le,” lehz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Chaw awg mor nux awg khuhn lo yawd awg lawn haq su tawd khuhd ghawg daq chehd che yaog. Ted pehg pehar awr lehr, “Yawd chaw daq phehq che yaog,” lehd koz che yaog. Ted pehg pehar awr lehr, “Yawd chaw daq phehq che ma hez. Chaw teq pa haq yaq kaw mar yaq chehd che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kheh ma khuhd, Yud daq chaw ve awg hox awg nax teq pa haq kuhz cheaq te lehq, chaw te ghad-eg liz yawd awg lawn kha sehax su kad kig huh ma koz daq. ");
INSERT INTO lhi_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pawehd u ve te lehq awg kaw jen khen vehr che te yand, Yer suq bon yehg nux awg khuhn lo taez lehq bon tanr mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kheh te lehq Yud daq chaw ve awg hox awg nax teq pa and lehq, “Chaw che awr lehr liq ma hend jaw liz, khawd-ehg kheh te lehq kheh taw maq sir cheawg le,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yer suq kawq koz che, “Ngag mar vid che tawd khuhd awr lehr, ngag ved tawd khuhd ma hez. Kheh ma khuhd, ngag haq lag peha che phad ve tawd khuhd phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ghig sa ve a lor haq te gad che chaw awr lehr, ngag mar vid che tawd khuhd che ve Ghig sa lo lag che tawd khuhd phehq che lehq nar, ma hez ver, ngag khad ngag koz che tawd khuhd phehq che lehq nar haq yawd sir tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","A sug yawd khad yawad koz gad che heh koz che chaw awr lehr, a sug yawd awg ton awg pun awg mig awg phond ca che yaog. Kheh ma khuhd, yawd haq lag peha che phad ve awg ton awg pun awg mig awg phond ca che chaw awr lehr, thed che chaw phehq lehq yawd awg khuhn her ka che awg ceng mad cawg. ");
INSERT INTO lhi_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Mod ser awr lehr, nig hehd haq awg lid tawd khuhd pehar lar che ma hez hawg la. Kheh liz, awg lid tawd khuhd u ve haq nig hehd te ghad-eg liz maq na yug. A thoq te lehq nig hehd ngag haq dawz vehr tug ca cheawg le,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chaw awg mor nux u ve teq pa kawq koz che, “Nawg awr lehr ned geh vehr che chaw phehq che yaog. Nawg haq dawz vehr tug a sug ca cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yer suq kawq koz che, Ngag awg hez ted mag te lehq, nig hehd awg gha lia and che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mod ser awr lehr, awg gig med soer che awg lid nig hehd haq pehar lar che yaog. (Awg cehg mag koz ver, Mod ser geh awg kawd maq lag che ma hez. A pux a pi teq pa geh awg kawd maq lag che yaog.) Sa ba to awg ni thad loar nig hehd chaw haq awg gig med soer vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mod ser ve awg lid tawd khuhd haq maq gha te lug tug, Sa ba to awg ni teq ni awg khuhn liz chaw yad haq nig hehd awg gig med soer vid cawd ver, ngag awr lehr Sa ba to awg ni teq ni awg khuhn chaw te ghad ve awg ton awg gha lia haq ghu na vid cheaq te lehq, a thoq te lehq nig hehd ngag haq nez nag cheawg le. ");
INSERT INTO lhi_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nig hehd gha mawg che awg ceng haq lehax ngawx lehq suhx jehg che taq te. Awg cehg mag cawd che awg khuhn lehax suhx jehr-oq lehz, i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Kheh te lehq, Yer ruq sar lehnr med yad ted pehg pehar koz che, “I hehd dawz vehr tug ca chehd che awr lehr, chaw che phad ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ngawx ser. Chaw awg mor nux mehz khuhd suhr yawd kha sehax tawd yaw chehd liz, su yawd haq teq chaweh ma koz. Chaw che phad awr lehr, Khreq phehq che haq a nig ved awg hox awg nax teq pa awg cehg mag sir che lehq nar. ");
INSERT INTO lhi_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kheh ma khuhd, chaw che phad khar lo lag che haq a nig sir che yaog. Kheh te lehq, Khreq lag che te yand, yawd khar lo lag che haq chaw te ghad-eg liz sir tug ma hez,” lehz i hehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kheh te lehq, Yer suq bon yehg nux awg khuhn lo mar vid chehd-ag huh yawd awg khuhd hehnd chawa kug lehq koz che, “Nig hehd ngag haq sir che yaog. Ngag khar lo lag che haq liz nig hehd sir che yaog. Kheh liz, ngag khad ngag lag gad lehq lag che ma hez. Ngag haq lag peha che phad awr lehr, awg cehg mag cawd che yaog. Nig hehd yawd haq maq sir. ");
INSERT INTO lhi_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ngag awr lehr yawd haq sir che yaog. Awg lawn ghod ver, ngag yawd chehd lo lag lehq, yawd ngag haq peha lar che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Kheh te cheaq te lehq, i hehd yawd haq pheh yug tug te che yaog. Kheh liz, yawd ved awg yand mad gag ser cheaq te lehq, chaw te ghad-eg liz yawd haq maq ca pheh yug. ");
INSERT INTO lhi_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kheh ma khuhd, chaw awg mor nux awg khuhn chaw laex ghad yawd haq yonr che yaog. I hehd koz che, Khreq lag che te yand, chaw che te ghad te che awg hez teq pa haq keh yawd te tuawg la lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Chaw awg mor nux Yer suq ve awg lawn khuhd koz daq ghawg daq chehd che haq Phar rir sehd teq pa gha kad cheaq te lehq, paw khod nux teq pa he lehq Phar rir sehd teq pa awr lehr, yawd haq pheh yug tug bon yehg nux ve maq yad teq pa haq kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kheh te lehq Yer suq koz che, “Ngag nig hehd geh teq cuhx te yand nehax chehd lar haz lehq ngag haq lag peha che phad geh kawq koeq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nig hehd ngag haq ca tug yaog. Kheh liz, ngag haq ca mawg tug ma hez. Ngag ved chehd kig huh nig hehd lag mad gag hawg,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Kheh te lehq Yud daq chaw ve awg hox awg nax teq pa koz daq che, “A nig yawd haq maq gha kawq mawg tug yawd khar lo kae tug awg le. Phaz daq lehq Her lar saq chaw teq pa geh ca chehd veh che a nig ved Yud daq chaw teq pa ve chehd kig lo kae lehq, Her lar saq chaw teq pa haq yawd ca mar vid tug awg la. ");
INSERT INTO lhi_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‘Nig hehd ngag haq ca tug yaog. Kheh liz ngag haq ca mawg tug ma hez. Ngag ved chehd kig huh nig hehd lag mad gag hawg,’ lehz yawd koz che tawd awr lehr, khawd-ehg kheh koz gad che lehq nar,” lehz i hehd te ghad he lehq te ghad koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pawehd te che awg leh med teq ni, awg ni ir che teq ni awg khuhn, Yer suq hox lar lehq awg khuhd hehnd chawa kug lehq koz che, “A kaz sex che chaw cawg ver, ngag geh lag lehq ca dawg laoq. ");
INSERT INTO lhi_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ngag haq yonr che chaw awr lehr, Liq phu awg khuhn buhq lar che heh, ‘Yawd ved ni ma awg khuhn lo co ha teq vid gha che a kaz lawg teq pa tuhaz lehq yuhg yaeq tug yaog,’” lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yawd che kheh koz che awr lehr, yawd haq yonr che chaw teq pa gha tug Awg ha phu awg lawn haq koz che yaog. Awg lawn ghod ver, Yer suq awr lehr awg mig awg phond haq maq gha ser cheaq te lehq, Ghig sa awr lehr Awg ha phu maq pehar ser. ");
INSERT INTO lhi_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Che kheh koz che haq gha kad che te yand, chaw ted pehg pehar awr lehr, “Chaw che ve te ghad awg cehg mag Ghig sa ve cuh kar var u ve te ghad phehq che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ted pehg pehar koz che, “Chaw che ve te ghad awr lehr, Khreq phehq che yaog.” Kheh ma khuhd ted pehg pehar koz che, “Khreq awr lehr Gar liq lehd muhd mig awg khuhn tuhaz tuawg la. ");
INSERT INTO lhi_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Khreq awr lehr Dar viq ve awg ceng awg khad phehq lehq Dar viq ve chehd kig Behr lehr hehnr med nehax awg khuhn lo tuhaz tug yaog lehz, Liq phu awg khuhn lo buhq lar che ma hez hawg la,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kheh te lehq, Yer suq haq te lehq chaw kheh ma ve ni ma maq hawr daq. ");
INSERT INTO lhi_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","I hehd ted pehg pehar yawd haq pheh yug gad che yaog. Kheh liz, chaw te ghad-eg liz yawd haq maq ca pheh yug. ");
INSERT INTO lhi_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Awg yand u ve khuhn, bon yehg nux ve maq yad teq pa awr lehr, paw khod nux teq pa he lehq Phar rir sehd teq pa chehd lo kawaq che yaog. Paw khod nux teq pa he lehq Phar rir sehd teq pa koz che, “A thoq te lehq nig hehd yawd haq mad yug veha lag cheawg le,” lehd koz na ngawx che te yand, ");
INSERT INTO lhi_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","bon yehg nux ve maq yad teq pa kawq koz che, “Chaw u ve te ghad mar vid che heh, chaw te ghad-eg liz maq mar vid jaw,” lehd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Phar rir sehd teq pa kawq koz che, “Nig hehd haq liz yawd her ka gha vehr cheawg la. ");
INSERT INTO lhi_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Awg hox awg nax teq pa he lehq Phar rir sehd teq pa awg khuhn yawd haq yonr che chaw te ghad ghad cawg hawg la. ");
INSERT INTO lhi_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Awg lid tawd khuhd haq maq sir che chaw che teq pa awr lehr, Ghig sa khen che haq gha khanr che chaw phehq che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","I hehd awg khuhn chehd che, awg kawd maq huh Yer suq chehd lo lag jaw che Niq kawd der te ghad koz che, ");
INSERT INTO lhi_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“A nig ved awg lid tawd khuhd awr lehr, chaw te ghad ghad yawd a nig haq koz ax che tawd khuhd haq maq gha kad lehq yawd te che haq maq gha sir che kheh ceh, yawd haq suhx jehg suhx taz che awg lid cawg hawg la,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","I hehd yawd haq kawq koz khuhq vid che, “Nawg liz Gar liq lehd chaw phehq cheawg la. Nawg kha nehax char ngawx ser. Gar liq lehd muhd mig awg khuhn lo Ghig sa ve cuh kar var te ghad-eg liz ma tuhaz che haq nawg gha mawg tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Awg yand u ve khuhn i hehd awr lehr, te ghad peg te ghad a sug yawd ved yehg lo koeq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kheh ma khuhd, Yer suq awr lehr, Sar lonr keh thag lo taez che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Naq mi sawx ted naq bon yehg nux awg khuhn yawd te pawz kawq kae lehq, chaw awg gha lia yawd chehd lo lag che yaog. Yawd mi lar lehq i hehd haq mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hax chawd te chehd che yad mid te ghad haq Liq phu phawd awr ve sar laq teq pa he lehq Phar rir sehd teq pa yug veha lag lehq awg kaw jen huh teh lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Awg yand u ve haq i hehd koz che, “Sar lar-og, yad mid che te ghad hax chawd te chehd huh, yawd haq yug gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kheh te che chaw haq huhx meh gha bag vehr che yaog lehd koz, awg lid tawd khuhd awg khuhn lo Mod ser a nig haq tawd pehar lar che yaog. Kheh ma khuhd, nawg khawd-ehg kheh koz tuawg le,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","I hehd che kheh koz che awr lehr, yawd haq vend bax tar gha tug, yawd haq lawnd ngawx che yaog. Yer suq cuhq kuhq lehq, mig kag lo yawd ved laq nuh buhq chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kheh liz, i hehd yawd haq na ngawx don chehd che haq te lehq, yawd thed-e ghad kawq tu lehq koz che, “Nig hehd awg khuhn vend bax mad cawg che chaw te ghad huhx meh yug lehq yawd haq awg kawd bar-oq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Awg yand u ve haq, yawd kuhq ghad te pawz kawq boz cuhx lar lehq, mig kag lo laq nuh kawq buhq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tawd u ve haq i hehd gha kad che te yand, su haq keh mawd che chaw teq pa haq tanr lehq te ghad peg te ghad tuhz veh che yaog. Kheh te lehq, Yer suq te ghad lehax chehd chehd lehq, yad mid u ve liz awg kaw jen huh hox chehd ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Awg yand u ve khuhn, Yer suq thed-e ghad kawq tu lar lehq koz che, “Yad mid-og, i hehd khar lo saw veh vehr cheawg le. Chaw te ghad-eg liz nawg haq maq suhx jehg suhx taz lehq la,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Yad mid u ve kawq koz che, “Jawd mawd-og, te ghad-eg liz ngag haq maq suhx jehg suhx taz ax,” lehd koz vid che yaog. Yer suq koz che, “Ngag liz nawg haq maq suhx jehg suhx taz. Kae lor. Vend bax tad kawq te,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kheh te lehq, Yer suq te pawz kawq koz che, “Ngag awr lehr mig gig ve awg ghiz phehq che yaog. Ngag khaz nuhr ghaq lag che chaw awr lehr, naz hoq che awg khuhn te pawz-a liz mad kawq veh hawg. Co ha teq vid gha che awg ghiz yawd awg khuhn cawg tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Phar rir sehd teq pa kawq koz che, “Nawg awr lehr nawg awg ton awg lawn sax khiz khanr che yaog. Nawg ved sax khiz awr lehr, ma cawd,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yer suq kawq koz che, “Ngag awr lehr ngag awg ton awg lawn sax khiz khanr che liz, ngag ved sax khiz awr lehr cawd che yaog. Awg lawn ghod ver, ngag khar lo lag che he lehq khar lo kae tug haq ngag sir che yaog. Nig hehd awr lehr, ngag khar lo lag che he lehq khar lo kae tug haq maq sir. ");
INSERT INTO lhi_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nig hehd awr lehr, awg thang phawd awr lehax ngawx lehq suhx jehg che yaog. Ngag awr lehr chaw te ghad-eg haq liz suhx mad jehg. ");
INSERT INTO lhi_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kheh ma khuhd ngag suhx jehg ver, ngag suhx jehg che awr lehr cawd che yaog. Awg lawn ghod ver, ngag te ghad lehax suhx jehg che ma hez. Ngag haq peha lar che Awr pa awr lehr ngag geh teq geha suhx jehg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Sax khiz khanr che phad ni ghad cawg ver, sax khiz u ve awr lehr cawd che yaog lehz, nig hehd ve awg lid tawd khuhd liq awg khuhn lo buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ngag awr lehr ngag awg ton awg lawn sax khiz khanr che yaog. Kheh te lehq, ngag haq peha lar che Awr pa awr lehr ngag awg lawn sax khiz khanr che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kheh te lehq i hehd koz che, “Nawg Awr pa khar lo le,” lehd yawd haq na ngawx che yaog. Yer suq kawq koz che, “Nig hehd awr lehr ngag haq lehd ma koz, ngag ved Awr pa haq lehd ma koz, maq sir. Nig hehd ngag haq sir ver, ngag ved Awr pa haq liz nig hehd sir tug yaog,” lehd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Bon yehg nux awg khuhn lo yawd mar vid chehd che te yand, phu ghawz kig bawehd awg khuhn tawd che teq pa haq yawd koz che yaog. Yawd ved awg yand mad gag ser cheaq te lehq, chaw te ghad-eg liz yawd haq maq pheh yug. ");
INSERT INTO lhi_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Te pawz yawd kawq koz che, “Ngag nig hehd haq phaz daq veh tug yaog. Nig hehd ngag haq ca liz, nig hehd ve vend bax awg khuhn nig hehd gha suh tug yaog. Ngag kae kig lo nig hehd lag mad gag,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kheh te lehq Yud daq chaw ve awg hox awg nax teq pa koz che, “‘Ngag kae kig lo nig hehd lag mad gag,’ lehd yawd koz che awr lehr, yawd awg ton haq yawd khad yawad dawz vehr tuawg la,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yawd kawq koz che, “Nig hehd awr lehr mig gig cheaq ve chaw phehq che yaog. Ngag awr lehr muhd nuh maq ve chaw phehq che yaog. Nig hehd awr lehr, mig gig ve chaw phehq che yaog. Ngag awr lehr, mig gig ve chaw phehq che ma hez. ");
INSERT INTO lhi_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kheh te cheaq te lehq, nig hehd ve vend bax awg khuhn nig hehd gha suh tug yaog, lehz ngag nig hehd haq koz ax peg che yaog. Awg lawn ghod ver, ngag awr lehr u ve te ghad yaog lehz nig hehd maq yonr ver, nig hehd ve vend bax awg khuhn nig hehd gha suh tug yaog,” lehd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","I hehd yawd haq kawq koz vid che, “Nawg a suawg le.” Yer suq koz che, “Awg kawd maq thad tanr lehq a meha kha gag liz ngag nig hehd haq koz ax chehd che heh yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nig hehd awg lawn ngag koz lehq suhx jehg tug kha peh cawg che yaog. Kheh liz, ngag haq peha lar che phad awr lehr, awg cehg mag cawd lehq, yawd geh lo ngag gha kad che heh mig gig yad teq pa haq ngag koz vid che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Awr pa awg lawn yawd i hehd haq koz vid chehd che haq i hehd maq sir. ");
INSERT INTO lhi_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kheh te cheaq te lehq Yer suq koz che, “Chaw yad ve Yad phu haq nig hehd chid taez peg khaz nuhr, ngag awr lehr yawd phehq che yaog lehz nig hehd gha sir tug yaog. Kheh te lehq, ngag awr lehr ngag ved a lor haq teq chaweh liz maq te. Awr pa ngag haq mar lar che heh lehax ngag koz che haq liz nig hehd gha sir tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kheh te lehq ngag haq peha lar che phad awr lehr, khar thad liz ngag geh teq geha chehd chehd che yaog. Yawd ngag haq ma chid bag lar haz ax. Awg lawn ghod ver, yawd ni ma cawd che awg ceng teq pa haq ngag khar thad liz te chehd che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tawd u ve teq pa haq yawd yaw che te yand, chaw laex ghad yawd haq yonr vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kheh te lehq, yawd haq yonr che Yud daq chaw teq pa haq Yer suq koz vid che, “Ngag ved tawd khuhd awg khuhn nig hehd chehd yeg ver, nig hehd ngag ved awg laq ghuhd awg cehg mag phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kheh te lehq awg cehg mag cawd che ted ceng haq nig hehd sir tug yaog. Awg cehg mag cawd che ted ceng u ve awr lehr, nig hehd haq pong vid ax tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","I hehd kawq koz che, “Ngag hehd awr lehr Ar brar hanr ve awg ceng awg khad phehq che yaog. Ngag hehd awr lehr, su ved awg ceg te pawz-a liz maq gha te jaw. Nig hehd haq pong ax tug yaog lehz nawg khawd-ehg kheh koz gha cheawg le,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yer suq kawq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, vend bax te che chaw awg gha lia awr lehr, vend bax ve awg ceg phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Awg ceg awr lehr, yehg khuhn lo co co taer taer maq gha chehd. Awg yad awr lehr, co co taer taer gha chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yad phu nig hehd haq pong ax ver, nig hehd awg cehg mag gha pong tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nig hehd awr lehr Ar brar hanr ve awg ceng awg khad phehq che haq ngag sir che yaog. Kheh liz, ngag ved tawd khuhd nig hehd awg khuhn chehd kig mad cawg cheaq te lehq, nig hehd ngag haq dawz vehr tug ca che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ngag awr lehr, ngag ved Awr pa geh lo gha mawg che awg ceng teq pa haq lehax ngag koz che yaog. Kheh ma khuhd nig hehd awr lehr, nig hehd ve awr pa geh lo gha kad che awg ceng teq pa haq te che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","I hehd yawd haq kawq koz vid che, “Ar brar hanr awr lehr ngag hehd ve awr pa phehq che yaog.” Yer suq kawq koz che, “Nig hehd awr lehr, Ar brar hanr ve awg yad phehq che ver, Ar brar hanr te che kanx teq pa haq kha sur suar nig hehd liz te tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ngag awr lehr Ghig sa geh lo gha kad che awg cehg mag cawd che ted ceng nig hehd haq koz ax che phad phehq liz, nig hehd ngag haq dawz vehr tug ca che yaog. Ar brar hanr awr lehr che kheh maq te. ");
INSERT INTO lhi_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nig hehd awr lehr, nig hehd ve awr pa te che heh te chehd che yaog,” lehz i hehd haq koz vid che yaog. I hehd kawq koz che, “Ngag hehd awr lehr hax chawd yad phehq che ma hez. Ngag hehd ve Awr pa te ghad lehax cawg lehq, yawd awr lehr Ghig sa phehq che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yer suq kawq koz che, “Ghig sa awr lehr nig hehd ve Awr pa phehq ver, nig hehd ngag haq haq tug yaog. Awg lawn ghod ver, ngag awr lehr Ghig sa lo lag lehq a meha chuhr huh chehd chehd lar che yaog. Ngag khad ngag lag gad lehq lag che ma hez. Yawd ngag haq peha lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ngag koz che tawd khuhd haq a thoq te nig hehd na maq gha cheawg le. Ngag ved tawd khuhd haq nig hehd haq yug maq gha cheaq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nig hehd awr lehr, nig hehd ve awr pa ned haeg geh lo lag lehq, nig hehd awr pa ve a lor cawd che heh te gad che yaog. Yawd awr lehr, awg kawd maq thad liz su haq dawz vehr che phad phehq che yaog. Yawd awg khuhn awg cehg mag cawd che a cehax liz mad cawg cheaq te lehq, awg cehg mag cawd che haq yawd te pawz-a liz maq yaw jaw. Yawd her ka che tawd haq yaw che te yand, yawd ved ni ma awg khuhn phehq che heh yaw che yaog. Awg lawn ghod ver, yawd awr lehr her ka sehr phad phehq lehq, her ka che ted ceng ve awr pa liz phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kheh ma khuhd, ngag nig hehd haq awg cehg mag cawd che tawd koz ax cheaq te lehq nig hehd ngag haq maq yonr. ");
INSERT INTO lhi_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngag vend bax cawg che lehd nig hehd awg khuhn a sug pheq mar ax gha tuawg le. Awg cehg mag cawd che tawd khuhd haq ngag yaw ver, a thoq te nig hehd ngag haq maq yonr cheawg le. ");
INSERT INTO lhi_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ghig sa ve chaw awr lehr, Ghig sa ve tawd khuhd haq na che yaog. Kheh ma khuhd, nig hehd awr lehr Ghig sa ve chaw phehq che ma hez cheaq te lehq, maq na,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yud daq chaw teq pa kawq koz che, “Nawg awr lehr Sar mar riq chaw phehq lehq ned geh che chaw liz phehq che yaog lehd ngag hehd koz che awr lehr cawd che yaog ma hez hawg la,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yer suq kawq koz che, “Ngag ned geh che chaw ma hez. Kheh ma khuhd, ngag awr lehr ngag ved Awr pa haq yawz yan che yaog. Nig hehd awr lehr ngag haq ma yawz yan. ");
INSERT INTO lhi_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ngag awr lehr ngag ved awg mig awg phond haq maq ca. Kheh liz, ngag haq ngag ved awg mig awg phond ca ax sehr phad te ghad cawg lehq yawd awr lehr suhx jehg sehr phad phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ngag nig hehd haq awg cehg mag koz ax laq, ngag ved tawd khuhd haq na yug lehq te kae che chaw awr lehr, te pawz-a liz suh che haq maq gha phud tug yaog,” lehz Yer suq i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yud daq chaw teq pa kawq koz che, “Nawg ned geh che chaw phehq che haq a meha ngag hehd sir vehor. Ar brar hanr he lehq Ghig sa ve cuh kar var teq pa suh vehr che yaog. ‘Ngag ved tawd khuhd haq na yug lehq te kae che chaw awr lehr, te pawz-a liz suh che haq maq gha phud tug yaog,’ lehz nawg koz che law lehg. ");
INSERT INTO lhi_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nawg awr lehr suh vehr che a nig ved awr pa Ar brar hanr haq keh ir che lehq la. Ghig sa ve cuh kar var teq pa liz suh vehr che yaog. Nawg awr lehr nawg awg ton a suawg le lehd koz chehd cheawg le,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yer suq kawq koz che, “Ngag awg ton haq ngag awg mig awg phond chid ir chid muh ver, awg mig awg phond u ve awr lehr kheha phehq che yaog. Ngag haq awg mig awg phond chid ir chid muh sehr phad awr lehr, ngag ved Awr pa yaog. Yawd awr lehr nig hehd ve Ghig sa phehq che yaog lehz, nig hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kheh liz, nig hehd yawd haq maq sir. Ngag awr lehr yawd haq sir che yaog. Ngag yawd haq maq sir lehz ngag koz ver, nig hehd heh te lehq ngag liz her ka var phehq tug yaog. Kheh ma khuhd, ngag yawd haq sir lehq, yawd ved tawd khuhd haq liz ngag na yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nig hehd ve awr pa Ar brar hanr awr lehr, ngag ved awg ni awg hax haq gha mawg tug ha lehg jad che yaog. Yawd gha mawg peg lehq ha lehg che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yud daq chaw teq pa kawq koz che, “Nawg awr lehr a saq ngad chi khuhq liz mad gag ser. Ar brar hanr haq nawg mawg jaw lehq la,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yer suq kawq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, Ar brar hanr mad cawg ser thad loar ngag cawg chehd vehr che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Kheh te lehq, i hehd awr lehr yawd haq bag tug huhx meh dig ghawz che yaog. Kheh ma khuhd, Yer suq khuhd jaz lar lehq bon yehg nux awg khuhn tuhz veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yer suq yaq kaw kae tod che te yand, pawag thad loar mehz cox vehr che chaw te ghad haq yawd gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Awg yand u ve khuhn, yawd ved awg laq ghuhd teq pa koz che, “Rar bid-og. Chaw che te ghad pawag thad loar mehz cox vehr che awr lehr, a sug ved vend bax haq te lehq le. Yawd ved vend bax haq te lehq la. Awr pa awr ye ve vend bax haq te lehq la,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yer suq kawq koz che, “Yawd ved vend bax haq te che ma hez. Awr pa awr ye ve vend bax haq te che liz ma hez. Yawd awg khuhn lo Ghig sa ve kanx teq pa kha sehax maw vid tug awg pun yawd che kheh phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ngag haq lag peha che phad ve kanx teq pa haq muhd kaw huh a nig gha te che yaog. Chaw te ghad-eg liz kanx te maq gha che muhd khax ve awg yand gag vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ngag awr lehr mig gig koar chehd ser che awg yand awg khuhn, mig gig ve awg ghiz phehq che yaog,” lehd yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Che kheh koz peg khaz nuhr, mig kag huh yawd cux ghig pheq puhr lehq a jeq nehz te peg lehq, chaw u ve te ghad ve mehz sir haq gehz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Sid lonr ghig po lo kae lehq chuhd kha-oq,” lehz Yer suq yawd haq koz vid che yaog. (Sid lonr lehd koz che cuhx kig awr lehr, Kae pe vehor lehd koz gad che yaog.) Kheh te lehq yawd kae lehq ca chuhd kha che yaog. Awg yand u ve haq, yawd mehz mawg vehr lehq yawd ved yehg lo kawaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kheh te lehq, yawd ved yehg awg pad awg ki huh chehd che chaw teq pa he lehq yawd lawg cad chehd che haq gha mawg jaw che chaw teq pa koz che, “Chaw che ve phad awr lehr, pong lag thad mi lar lehq lawg cad chehd che chaw te ghad ma hez hawg la,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ted pehg pehar koz che, “Yawd yaog.” Ted pehg pehar koz che, “Yawd ma hez. Yawd haq sur che chaw te ghad yaog,” lehd koz daq che yaog. Kheh ma khuhd, yawd awg ton koz che, “Nig hehd koz daq chehd che chaw awr lehr ngag yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kheh te cheaq te lehq i hehd koz che, “Kheh te ver, nawg ved mehz sir khawd-ehg kheh te kawq mawg gha vehr cheawg le,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yawd kawq koz che, “Yer suq meh che chaw te ghad a jeq nehz te lehq, ngag ved mehz sir haq gehz ax peg lehq, ‘Sid lonr ghig po lo kae lehq chuhd khaoq,’ lehz ngag haq koz ax che yaog. Kheh te cheaq te lehq, ngag ca chuhd kha che te yand mehz mawg vehr che yaog,” lehd yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","I hehd kawq koz che, “Yawd khar lo kae le,” lehz chaw u ve te ghad haq na ngawx che te yand, “Ngag maq sir,” lehd yawd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chaw u ve teq pa awr lehr, mehz cox jaw che chaw u ve te ghad haq Phar rir sehd teq pa chehd lo sir kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Yer suq a jeq nehz te lehq yawd ved mehz sir haq mawg vehr vid gha che teq ni awr lehr, Sa ba to awg ni phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Yawd ved mehz sir khawd-ehg kheh te kawq mawg gha vehr che awg lawn Phar rir sehd teq pa yawd haq te pawz kawq na ngawx che te yand, yawd kawq koz che, “Ngag ved mehz sir haq yawd a jeq nehz gehz ax lehq, ngag ca chuhd kha che te yand mehz mawg vehr che yaog,” lehd yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Kheh te lehq, Phar rir sehd awg mor khuhn ve ted pehg pehar koz che, “Chaw u ve phad awr lehr Ghig sa lo lag che ma hez. Awg lawn ghod ver, Sa ba to awg ni thad yawd maq ce maq kan,” lehd koz che yaog. Kheh ma khuhd, ted pehg pehar koz che, “Vend bax yad te ghad awr lehr, che kheh te che awg hez teq pa haq khawd-ehg kheh te gha tuawg le,” lehd koz daq che yaog. Kheh te lehq, i hehd te ghad he lehq te ghad duhd khad maq hawr daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kheh te cheaq te lehq, mehz cox jaw che chaw haq i hehd te pawz kawq koz vid che, “Nawg ved mehz sir haq yawd mawg vehr vid gha che haq te lehq chaw u ve te ghad awg lawn nawg khawd-ehg kheh koz tuawg le,” lehz na ngawx che yaog. Yawd awr lehr, “Chaw u ve phad awr lehr Ghig sa ve cuh kar var phehq che yaog,” lehd yawd kawq koz khuhq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kheh ma khuhd, Yud daq chaw ve awg hox awg nax teq pa awr lehr, mehz mawg vehr che chaw te ghad ve awr pa awr ye haq mad kug na ser kheh ceh yawd awr lehr awg kawd maq thad loar mehz cox lehq awg khaz nuhr mehz kawq mawg gha vehr che haq i hehd maq yonr. ");
INSERT INTO lhi_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","I hehd awr lehr, awr pa awr ye haq koz vid che, “Che phad awr lehr nig mag ved yad par yaog la. Pawag thad loar mehz cox che lehz nig mag koz che awr lehr, che te ghad yaog la. Kheh te ver, a meha khawd-ehg kheh te lehq yawd mehz mawg vehr cheawg le,” lehz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Yawd ved awr pa awr ye kawq koz che, “Che phad awr lehr, ngag nid-ag ve yad par phehq lehq pawag thad loar mehz cox var phehq che haq ngag nid-ag sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kheh liz, a meha khawd-ehg kheh te lehq yawd mehz kawq mawg gha vehr che haq ngag nid-ag maq sir. Yawd ved mehz sir haq a sug mawg vehr vid che haq liz ngag nid-ag maq sir. Yawd haq na ngawx-oq. Yawd ir vehr che yaog. Yawd ved awg ton awg lawn yawd koz ax tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Yawd ved awr pa awr ye che kheh koz che awr lehr, Yud daq chaw ve awg hox awg nax teq pa haq kuhz cheaq te lehq koz che yaog. Awg lawn ghod ver, Yer suq awr lehr Khreq phehq che yaog lehd koz lehq khanr yug che chaw a sug te ghad haq lehd ma koz, i hehd ve bon awg mor awg khuhn ghaq tuhz tug yaog lehz, Yud daq chaw ve awg hox awg nax teq pa jehg chez lar peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kheh te cheaq te lehq, awr pa awr ye koz che, “Yawd ir vehr che yaog. Yawd haq na ngawx-oq,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kheh te lehq i hehd awr lehr, mehz cox jaw che chaw haq te pawz kawq kug veha lehq koz che, “Ghig sa haq lehax chid ir chid muh vid-oq. Chaw u ve awr lehr, vend bax yad phehq che haq ngag hehd sir che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Awg yand u ve haq yawd kawq koz che, “Yawd vend bax yad lehq nar, ma hez lehq nar, ngag maq sir. Ted ceng haq ngag sir che yaog. Awg kawd maq thad ngag mehz cox che liz, a meha ngag mehz mawg vehr che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","I hehd kawq koz che, “Yawd nawg haq khawd-ehg kheh tea cheawg le. Nawg ved mehz sir haq yawd khawd-ehg kheh te lehq kawq mawg vehr vid gha cheawg le,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yawd kawq koz che, “Ar sind heh ngag nig hehd haq koz ax peg che liz nig hehd maq na. A thoq te lehq nig hehd te pawz kawq kad gad ser-a le. Nig hehd liz, yawd ved awg laq ghuhd te gad lehq la,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","I hehd yawd haq kha muhd kha na koz lehq, “Nawg awr lehr yawd ved awg laq ghuhd phehq che yaog. Ngag hehd awr lehr, Mod ser ve awg laq ghuhd phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ghig sa awr lehr Mod ser haq tawd yaw vid lar che haq ngag hehd sir che yaog. Kheh ma khuhd, chaw che phad khar lo lag che haq ngag hehd maq sir,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yawd kawq koz che, “Yawd ngag ved mehz sir haq mawg vehr vid gha che liz, yawd khar lo lag che haq nig hehd maq sir che awr lehr, and tug cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ghig sa awr lehr, vend bax yad teq pa ve tawd khuhd haq maq na yug che haq a nig sir che yaog. Kheh ma khuhd, chaw te ghad ghad Ghig sa haq yawz yan lehq yawd ved a lor haq te ver, chaw u ve te ghad ve tawd khuhd haq Ghig sa na yug che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Muhd kawr mig yaq thad loar tanr lehq yaq ni kha gag, pawag thad liz mehz cox chehd che chaw haq su mehz kawq mawg vehr vid gha che, chaw te ghad-eg liz ma kad jaw. ");
INSERT INTO lhi_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Chaw u ve te ghad awr lehr, Ghig sa lo lag che ma hez ver, yawd teq chaweh liz te maq gha,” lehd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","I hehd kawq koz che, “Nawg awr lehr vend bax kha peh cawg che awg khuhn pawag liz, nawg ngag hehd haq mar cheawg la,” lehd koz vid lehq, yawd haq i hehd Yud daq chaw ve bon mor awg khuhn ghaq tuhz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chaw u ve haq su ghaq tuhz vid che awg lawn haq Yer suq gha kad lehq, yawd haq ca mawg che te yand, “Chaw yad ve Yad phu haq nawg yonr cheawg la,” lehz Yer suq yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","“Jawd mawd-og, yawd haq ngag gha yonr tug, Chaw yad ve Yad phu awr lehr a suawg le,” lehz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yer suq kawq koz che, “Nawg yawd haq gha mawg vehr che yaog. A meha nawg haq tawd yaw chehd che awr lehr yawd yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Jawd mawd-og, ngag yonr che yaog,” lehz yawd koz lehq Yer suq haq a kor pi che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Awg yand u ve khuhn Yer suq koz che, “Mehz mad mawg che chaw teq pa mehz mawg tug he lehq mehz mawg che chaw teq pa mehz cox tug, suhx jehg tug awg pun mig gig khod-aq lo ngag lag che yaog,” lehz koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Yawd awg pad huh chehd chehd che Phar rir sehd teq pa tawd u ve haq gha kad che te yand, “Ngag hehd liz mehz cox var phehq cheawg la,” lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yer suq kawq koz che, “Nig hehd mehz cox var phehq cehg mag ver, nig hehd awr lehr vend bax cawg tug ma hez. Kheh ma khuhd, ‘Ngag hehd mehz mawg chehd che yaog,’ lehz a meha nig hehd koz cheaq te lehq, nig hehd vend bax cawg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ngag nig hehd haq awg cehg mag koz ax laq, yawg khawz awg khuhn lo gehag huh, ghaz mir khuhn lo maq gehag lehq awg kag awr ve te khad haq ca taz gehag che chaw te ghad awr lehr, chaw khuhd chaw naz phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kheh ma khuhd, ghaz mir khuhn lo gehag che chaw te ghad awr lehr, yawg huhx var phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ghaz mir khuh paog par awr lehr, yawd haq ghaz mir phaw vid che yaog. Yawg teq pa awr lehr, yawd ved awg khuhd haq na yug che yaog. Yawd awr lehr, yawd ved yawg teq pa ve awg meh haq kug lehq, yawg u ve teq pa haq yawd sir ve tuhez che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Yawd ved yawg awg gha lia haq sir ve tuhez peg ver, yawg teq pa mehz khuhd suhr huh yawd kae lehq, yawg teq pa yawd ved tawd khuhd haq sir cheaq te lehq, yawd khaz nuhr veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yawg teq pa awr lehr, i hehd maq sir daq che chaw teq pa ve awg khuhd haq maq sir cheaq te lehq, chaw u kheh te che te ghad awg khaz nuhr i hehd mad ghaq kae. Kheh ma khuhd, phaw veh che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yer suq awr lehr, tawd par hax che ve i hehd haq koz mar vid che yaog. Kheh liz, yawd i hehd haq a thoq maq awg lawn koz mar vid che haq i hehd na maq gha. ");
INSERT INTO lhi_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kheh te lehq, Yer suq te pawz kawq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, ngag awr lehr yawg teq pa gehag tug ghaz mir khuh phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ngag mad lag ser awg kawd thad kha lag peg che chaw awg gha lia awr lehr, chaw khuhd chaw naz phehq che yaog. Kheh ma khuhd, yawg teq pa awr lehr, i hehd ve awg khuhd haq maq na. ");
INSERT INTO lhi_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ngag awr lehr, ghaz mir khuh phehq che yaog. Ngag awg khuhn lo gehag che chaw awr lehr, thaer khuhq che haq gha tug yaog. Yawd awr lehr, tuhz tuhz geh geh te lehq, kaz cad kig haq gha mawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Chaw khuhd awr lehr, khuhd yug tug, dawz vehr tug he lehq te lug tug awg pun lehax lag che yaog. Ngag awr lehr, yawg teq pa a saq gha teq tug awg pun awg khod-aq liz, a saq teq che u ve haq caz daq che awg ceng kha lawq gha tug awg pun ngag lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ngag awr lehr daq che yawg huhx sehr phad phehq che yaog. Daq che yawg huhx sehr phad awr lehr, yawg teq pa awg pun yawd ved a saq tand vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ghad phuhd cad lehq huhx sehr phad awr lehr, yawg huhx sehr phad cehg mag phehq che ma hez lehq yawg teq pa liz yawd ved phehq che ma hez. Kheh te cheaq te lehq, heh phid lag che haq yawd gha mawg che te yand, yawg teq pa haq yawd chid bag lar haz lehq phaw veh che yaog. Kheh te lehq, heh phid u ve awr lehr, yawg teq pa haq cheq lehq phaz daq vid vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Chaw u ve awr lehr, ghad phuhd cad sehr phad lehax phehq lehq yawg teq pa awg pun teq chaweh ma duhd ngawx cheaq te lehq, yawd phaw veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ngag awr lehr daq che yawg huhx sehr phad phehq che yaog. Awr pa ngag haq sir lehq, ngag liz Awr pa haq sir che heh te lehq, ngag ved yawg teq pa haq ngag sir lehq, ngag ved yawg teq pa liz ngag haq sir che yaog. Kheh te lehq, ngag awr lehr ngag ved yawg teq pa awg pun ngag ved a saq haq tand che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yawg khawz che ve khuhn ma chehd che awg kag awg nuz awr ve yawg teq pa liz ngag cawg ser che yaog. Yawg u ve teq pa haq liz ngag gha ca sir veha lehq, i hehd ngag ved khuhd haq na tug yaog. Awg yand u ve khuhn, yawg mor teq mor lehax cawg lehq, yawg huhx sehr phad te ghad lehax cawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ngag ved a saq haq ngag kawq yug khuhq gha tug, ngag a saq tand vid cheaq te lehq Awr pa ngag haq haq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ngag ved a saq haq chaw te ghad-eg liz maq hinx yug maq lu yug veh. Kheh ma khuhd, ngag khad ngag tand vid che yaog. Ngag ved a saq haq tand vid tug kand pax he lehq kawq yug khuhq tug kand pax awr lehr ngag geh cawg che yaog. Che kheh te tug, Awr pa ngag haq tawd pehar vehr che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tawd khuhd u ve teq pa haq te lehq Yud daq chaw teq pa awr lehr, te ghad he lehq te ghad duhd khad mad kawq hawr daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","I hehd awg khuhn lo chaw laex ghad koz che, “Yawd awr lehr ned geh lehq ghud che yaog. Yawd ved tawd khuhd haq a thoq te nig hehd na chehd cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ted pehg pehar koz che, “Yawd ved tawd khuhd che ve teq pa awr lehr, ned geh che chaw te ghad ve tawd khuhd ma hez. Ned awr lehr mehz cox che chaw haq mehz mawg vehr vid gha tuawg la,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Awg yand u ve haq, Yer ruq sar lehnr med awg khuhn Chid aq vid che pawehd te chehd che yaog. Muhd kaz che awg yand liz cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yer suq awr lehr bon yehg nux awg khuhn lo cawg che Sawd laq monr ve kod med huh te tod chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Awg yand u ve haq, Yud daq chaw teq pa yawd haq caw hoz lar lehq koz che, “Ngag hehd thuhd duhd nuhg duhd te tug nawg khawd-ehg muh maq tea tug awg le. Nawg Khreq phehq cehg mag ver, ngag hehd haq kha sehax koz ax laoq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yer suq kawq koz che, “Ngag nig hehd haq koz ax peg che liz nig hehd maq yonr. Ngag Awr pa ve awg meh awg khuhn lo ngag te che kanx teq pa awr lehr, ngag ved awg lawn haq sax khiz khanr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kheh liz, nig hehd awr lehr ngag ved yawg teq pa ma hez cheaq te lehq, nig hehd maq yonr. ");
INSERT INTO lhi_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ngag ved yawg teq pa awr lehr, ngag ved awg khuhd haq na yug che yaog. Yawg u ve teq pa haq ngag sir lehq, i hehd ngag awg khaz nuhr ghaq lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ngag i hehd haq co co taer taer teq che co tiq ha tiq pid lehq, i hehd te pawz-a liz maq gha lug maq gha sez tug yaog. A sug liz ngag ved laq kuhr awg khuhn i hehd haq lu yug maq gha. ");
INSERT INTO lhi_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ngag haq yawg u ve teq pa chid aq ax sehr phad ngag ved Awr pa awr lehr, awg gha lia haq keh ir che yaog. A sug liz Awr pa ve laq kuhr awg khuhn lo yawg u ve teq pa haq lu yug maq gha. ");
INSERT INTO lhi_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Awr pa ngag nid-ag te ghad lehax phehq che yaog,” lehz yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Awg yand u ve khuhn Yud daq chaw teq pa awr lehr, yawd haq bag tug huhx meh dig kawq ghawz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yer suq kawq koz che, “Ngag ved Awr pa geh lo lag che daq che kanx laex ceng ngag nig hehd haq te mar ax peg che yaog. Kanx u ve teq pa awg khuhn, khar ve ted ceng haq te lehq nig hehd ngag haq huhx meh bag vehar lehd te cheawg le,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yud daq chaw teq pa kawq koz che, “Nawg daq che kanx te cheaq te lehq ngag hehd nawg haq huhx meh bag vehar lehd te che ma hez. Nawg Ghig sa haq maq sawnr ma caz koz che haq te lehq bag vehar lehd te che yaog. Awg lawn ghod ver, nawg chaw yad phehq che liz, Ghig sa heh nawg te che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yer suq kawq koz che, “Nig hehd ve awg lid tawd khuhd awg khuhn che kheh te buhq lar che yaog. ‘Ngag koz che, nig hehd awr lehr ghig sa teq pa phehq che yaog,’ lehz koz buhq lar che ma hez hawg la. ");
INSERT INTO lhi_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ghig sa awr lehr, yawd ved tawd khuhd haq gha che chaw teq pa haq ghig sa teq pa phehq che yaog lehd koz che yaog. (Liq phu tawd khuhd haq te lug maq gha.) ");
INSERT INTO lhi_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kheh te ver, Awr pa daq vid kehg vid lehq mig gig che khod-aq lo peha lar che te ghad awr lehr, ‘Ngag Ghig sa ve Yad phu phehq che yaog,’ lehz ngag koz cheaq te lehq, ‘Nawg Ghig sa haq maq sawnr ma caz koz che yaog,’ lehz nig hehd koz che lehq la. ");
INSERT INTO lhi_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngag Awr pa ve kanx teq pa haq ngag maq te ver, ngag haq taq yonr. ");
INSERT INTO lhi_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kheh ma khuhd ngag te ver, nig hehd ngag haq maq yonr liz, ngag te che kanx teq pa haq yonr-oq. U kheh te yonr ver, Awr pa ngag awg khuhn chehd che he lehq ngag Awr pa awg khuhn chehd che haq nig hehd gha sir gha mawg tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Awg yand u ve haq, i hehd yawd haq kawq pheh yuag lehd te che yaog. Kheh ma khuhd, yawd i hehd ve laq kuhr awg khuhn lo tuhz veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yod hanr awg kawd maq thad baz tiz sar pid che ted kag, Yawd danr lawg kax ox pax awr lo yawd te pawz kawq kae lehq, u huh chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Kheh te lehq, chaw laex ghad yawd chehd lo lag che yaog. I hehd koz che, “Yod hanr awr lehr awg hez teq chaweh maq te. Kheh ma khuhd, chaw che te ghad ve awg lawn Yod hanr kha koz lar che awg gha lia awr lehr, cawd cehg mag che yaog,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","U huh chaw laex ghad yawd haq yonr vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mar riq he lehq yawd ved awg vix ma Mar thaq chehd kig Ber tar niq khaz yad Lar sar ruq meh che te ghad nag chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mar riq u ve te ghad awr lehr, pong lag thad Jawd mawd Yer suq haq nag mand huhx puhr vid lehq, yawd ved khi kud haq cuhz kheh muh yug siz vid che yad mid te ghad yaog. Nag chehd che Lar sar ruq awr lehr, yawd ved awg nax var phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kheh te lehq, awg vix ma u ve ni ghad awr lehr, Yer suq chehd lo su haq kae pe lehq, “Jawd mawd-og, nawg haq che chaw te ghad nag chehd che yaog,” lehd koz vid cuh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tawd u ve haq Yer suq gha kad thad yawd koz che, “Nag che u ve awr lehr yawd haq suh vid tug ma hez. Kheh ma khuhd, nag che u ve awr lehr Ghig sa ve awg mig awg phond haq tuhaz vid lehq, nag che u ve haq te lehq Ghig sa ve Yad phu awg mig awg phond gha tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yer suq awr lehr, Mar thaq he lehq yawd ved awg nax ma haq lehd ma koz, Lar sar ruq haq lehd ma koz, haq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kheh te lehq, Lar sar ruq nag che awg lawn haq yawd gha kad che te yand, Yer suq yawd chehd chehd kig lo niq ni kawq chehd lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","U ve awg khaz nuhr Yer suq koz che, “A nig Yud daq muhd mig lo te pawz kawq kae veg,” lehd awg laq ghuhd teq pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Awg laq ghuhd teq pa kawq koz che, “Rar bid-og, a mig teq nia heh Yud daq chaw teq pa nawg haq huhx meh bag vehar lehd te che liz, nawg u huh te pawz kawq kae tuawg la,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yer suq kawq koz che, “Teq ni awg khuhn lo teq chi niq nar rir cawg che ma hez hawg la. Chaw te ghad ghad muhd kaw maq thad yaq kaw tod kae ver, mig gig che ve awg ghiz haq gha mawg cheaq te lehq, yawd khi thid pog par tug ma hez. ");
INSERT INTO lhi_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kheh ma khuhd, chaw te ghad ghad muhd khax huh yaq kaw tod kae ver, yawd awg khuhn lo awg ghiz mad cawg cheaq te lehq, khi thid pog par kuhd che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yawd che kheh koz peg khaz nuhr, yawd i hehd haq te pawz kawq koz vid che, “A nig ved awg chawd Lar sar ruq yuhq mir ka vehr che yaog. Kheh liz, yawd haq ca nuhr vid tug ngag kae sar,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Awg laq ghuhd teq pa koz che, “Jawd mawd-og, yawd yuhq mir ka chehd che ver, na vehr tug yaog,” lehd yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yer suq awr lehr, Lar sar ruq suh vehr che awg lawn haq koz che yaog. Kheh ma khuhd, i hehd awr lehr Lar sar ruq yuhq mir ka chehd che haq yawd koz che lehz duhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kheh te cheaq te lehq, Yer suq i hehd haq kha sehax koz vid che, “Lar sar ruq suh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Kheh te lehq, nig hehd awg pun ngag u huh ma chehd lar che awr lehr, ngag ha lehg che yaog. Che ve awr lehr, nig hehd gha yonr tug awg pun yaog. A meha a nig yawd geh kae veg,” lehd Yer suq i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kheh te lehq, Yad ceh ka lehd koz che Thod maq te ghad awr lehr, “Yawd geh teq geha suh tug a nig liz kae veg,” lehz yawd ved awg chawd awg laq ghuhd teq pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yer suq lag gag che te yand thad, Lar sar ruq haq tur phuh kehaq lo tur lar che uhd ni gag vehr che haq yawd gha sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ber tar niq khaz awr lehr, Yer ruq sar lehnr med haq ned che yaog. Seh kid lod kheh tawa vid daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kheh te cheaq te lehq, Mar thaq he lehq Mar riq geh Yud daq chaw kha peh vad-ag lag lehq, ix mag ved awg nax var Lar sar ruq suh cheaq te lehq, ix mag haq ni ma duhd sa tug te vid chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Yer suq lag tod che awg lawn haq Mar thaq gha kad che te yand, yawd tuhez lehq Yer suq haq ca mawg daq vehr che yaog. Kheh ma khuhd Mar riq awr lehr, yehg khuhn chehd lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Awg yand u ve khuhn Mar thaq Yer suq haq koz che, “Jawd mawd-og, nawg chuhr huh chehd chehd che ver, ngag ved awg nax var suh tug ma hez. ");
INSERT INTO lhi_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kheh ma khuhd, a meha liz Ghig sa geh nawg a thoq maq ted ceng lawg che lehd ma koz, Ghig sa nawg haq pehar tug yaog lehd ngag sir che yaog,” lehz Yer suq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yer suq koz che, “Nawg nax var kawq teq tuag tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mar thaq koz che, “Awg leh med teq ni huh kawq teq tuag che awg yand gaeg ver, yawd kawq teq tuag tug haq ngag sir che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yer suq kawq koz che, “Ngag awr lehr, kawq teq tuag che ted ceng he lehq co ha teq che ted ceng phehq che yaog. Ngag haq yonr che chaw awr lehr, suh vehr che liz, yawd kawq teq chehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","A saq teq lehq ngag haq yonr che chaw awg gha lia awr lehr, te pawz-a liz maq gha suh tug yaog. Tawd khuhd che haq nawg yonr cheawg la,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mar thaq koz che, “Yaog, Jawd mawd-og. Nawg awr lehr mig gig khod-aq lo lag tug ve Ghig sa ve Yad phu Khreq phehq che haq ngag yonr che yaog,” lehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mar thaq che kheh koz peg khaz nuhr, yawd kae lehq yawd ved awg nax ma Mar riq haq koz vid che, “Sar lar lag gag vehr che yaog. Yawd nawg haq kug chehd che yaog,” lehz a yax yax khuhd sad vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mar riq tawd u ve haq gha kad che te yand, yawd har naq tu lehq Yer suq chehd lo kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Awg yand u ve khuhn, Yer suq awr lehr khaz khuhn lo maq gehe ser. Kheh ma khuhd, Mar thaq yawd haq ca mawg daq che ted kag lo yawd chehd chehd ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kheh te lehq, Mar riq geh yehg awg khuhn lo chehd chehd lehq yawd haq ni ma duhd sa tug te vid chehd che Yud daq chaw teq pa awr lehr, Mar riq har naq tu lehq tuhz veh che haq gha mawg che te yand, yawd tur phuh lo ca huhg che gha hawg lehd duhd lehq, i hehd yawd khaz nuhr ghaq kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mar riq awr lehr, Yer suq chehd chehd kig huh lag gag lehq yawd haq mawg che te yand, yawd ved khi pad huh boz cuhx lar lehq koz che, “Jawd mawd-og, nawg chuhr huh chehd chehd che ver, ngag ved awg nax var suh tug ma hez,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mar riq he lehq yawd awg khaz nuhr lag tod che Yud daq chaw teq pa huhg chehd che haq Yer suq gha mawg che te yand, yawd ved ni ma awg khuhn lo duhd har jad lehq hax ceh nux khand che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Nig hehd yawd haq khar lo ca tar vehr cheawg le,” lehz Yer suq na ngawx che te yand, “Jawd mawd-og, ca ngawx laoq,” lehd i hehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yer suq awr lehr, mehz ghig yaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kheh te cheaq te lehq, Yud daq chaw teq pa koz che, “Ngawx ser. Yawd awr lehr, Lar sar ruq haq haq jad law lehg,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Kheh ma khuhd, ted pehg pehar koz che, “Mehz cox var haq mehz mawg vid gha che chaw che te ghad awr lehr, Lar sar ruq maq gha suh tug haq te maq gha hawg la,” lehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Awg yand u ve haq, Yer suq yawd ved ni ma awg khuhn lo te pawz kawq hax ceh nux khand lehq tur phuh lo lag che yaog. Tur phuh u ve awr lehr, hax kor te lehq, awg khod med huh huhx meh dig hoz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Huhx meh dig haq phuhz khaoq,” lehz Yer suq koz che te yand, suh vehr che chaw te ghad ve awg vix ma Mar thaq koz che, “Jawd mawd-og, yawd suh vehr che a meha uhd ni gag vehr che haq te lehq, kid nug vehr tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yer suq kawq koz che, “Nawg yonr ver, Ghig sa ve awg mig awg phond haq nawg gha mawg tug yaog lehz ngag nawg haq koz ax peg che ma hez hawg la,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Awg yand u ve haq, huhx meh dig u ve haq i hehd phuhz kha che yaog. Yer suq muhd nuh maq lo chid ngawx lehq koz che, “A pa-og, nawg ngag ved tawd khuhd haq na vehr cheaq te lehq, ngag nawg haq chid muh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ngag ved tawd khuhd haq nawg khar thad liz na che haq ngag sir che yaog. Kheh ma khuhd, nawg ngag haq peha lar che yaog lehz, chuhr huh caw hox chehd che chaw che teq pa gha yonr tug, i hehd awg pun ngag che kheh koz che yaog,” lehd yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yawd che kheh koz peg khaz nuhr, “Lar sar ruq-og, tuhz laoq,” lehd yawd awg khuhd hehnd chawa kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Awg yand u ve haq, suh vehr che chaw u ve te ghad awr lehr, tur phuh awg khuhn lo tuhaz che yaog. Yawd ved khi kud laq kuhr haq pha pez huhz lar lehq yawd ved mehz khuhd haq phar ceq pheh chuhq lar che yaog. Yer suq koz che, “Yawd haq phi kha vid lehq yawd ved yehg lo kawq pe vid-oq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kheh te cheaq te lehq, Mar riq geh lag che Yud daq chaw kha peh vad-ag awr lehr, Yer suq te che kanx haq gha mawg lehq, yawd haq yonr vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kheh liz, i hehd awg khuhn ve ted pehg pehar awr lehr, Phar rir sehd teq pa chehd lo kae lehq, Yer suq te che kanx awg lawn ca koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Awg yand u ve khuhn, paw khod nux teq pa he lehq Phar rir sehd teq pa awr lehr, jehg sehr phad awg mor haq kug phoz peg lehq koz che, “A nig khawd-ehg kheh gha te tuawg le. Awg lawn ghod ver, chaw u ve phad awr lehr, awg hez laex ceng te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","A nig yawd haq kheha teh lar ver, chaw awg gha lia yawd haq yonr tug yaog. Kheh te lehq, Rod maq chaw teq pa lag lehq, a nig ved bon yehg nux haq lehd ma koz, a nig ved muhd mig haq lehd ma koz, hinx yug vehr tug yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kheh ma khuhd, i hehd ve awg mor awg khuhn lo Kar yar phaq meh che chaw te ghad cawg che yaog. Yawd awr lehr, u ve ted khuhq ve paw khod nux phehq che yaog. Yawd koz che, “Nig hehd teq chaweh liz maq sir. ");
INSERT INTO lhi_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Chaw ceng ted ceng awg gha lia maq gha lug tug, chaw te ghad awr lehr chaw ceng ted ceng awg pun suh ver, nig hehd awg pun lex lehq daq che haq nig hehd ma duhd sir law lehg,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tawd khuhd u ve haq yawd khad yawad duhd tuhaz lehq yaw che ma hez. Kheh ma khuhd, u ve te khuhq awg khuhn lo yawd paw khod nux phehq cheaq te lehq, Yer suq awr lehr chaw ceng u ve ted ceng awg pun gha suh tug yaog lehz yawd koz che awr lehr, Ghig sa ve cuh kar var heh te lehq mad pheaq ser che awg ceng haq yawd awg kawd koz lar vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Chaw ceng u ve ted ceng awg pun lehax Yer suq suh che ma hez. Kheh ma khuhd, awg kag gha lia lo phaz daq vehr che Ghig sa ve awg yad awg dug teq pa haq teq mor lehax phehaq vid tug awg pun liz, yawd suh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","U ve teq ni haq tanr lehq, yawd haq dawz vehr tug i hehd jehg chez lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kheh te cheaq te lehq Yer suq awr lehr, Yud daq chaw teq pa awg khuhn lo phawd thi mehz thi mad kawq te tod. Yawd u huh tuhez lehq, heh pir pad haq ned che muhd mig te pez awg khuhn cawg che Ed phar renr med nehax lo gaeg che yaog. U huh yawd ved awg laq ghuhd teq pa geh yawd chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yud daq chaw teq pa ve Par sar khar pawehd gag vehr tez che te yand, chaw kha peh vad-ag a sug yawd awg ton haq daq vid kehg vid tug, pawehd mad gag ser thad liz, kehag lo med jad lo chehd che chaw teq pa tu lehq Yer ruq sar lehnr med lo taez che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kheh te lehq, i hehd Yer suq haq ca chehd che yaog. Bon yehg nux awg khuhn lo i hehd hox chehd che te yand, i hehd te ghad he lehq te ghad koz daq che, “Nig hehd khawd-ehg kheh duhd-aq le. Yawd awr lehr pawehd che ve awg khuhn mad lag hawg la,” lehz na daq ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Awg yand u ve haq paw khod nux teq pa he lehq Phar rir sehd teq pa awr lehr, kheh te tawd sanr vid lar che yaog. “A sug te ghad lehd ma koz, yawd khar lo chehd chehd che haq sir ver, yawd haq ngag hehd pheh yug tug gha koz ax che yaog,” lehz tawd sanr vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Par sar khar pawehd mad gag ser awg kawd khuhq ni thad huh, Yer suq awr lehr Ber tar niq khaz lo gaeg che yaog. Khaz u ve awr lehr, suh kig lo yawd kawq teq tuag vid che Lar sar ruq ve chehd kig phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Awg yand u ve khuhn, i hehd awr lehr yawd haq muhd phiq awr ted pog te car vid che yaog. Mar thaq awr ke car vid sehr ma te lehq Lar sar ruq he lehq awg kag awg nuz awr ve chaw teq pa Yer suq geh teq geha mi cad chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Awg yand u ve haq Mar riq awr lehr, awg phuhd khaz jad che nar duz lehd koz che nag mand huhx sehz law haq yug lehq, Yer suq ve khi kud haq puhr vid che yaog. Kheh te peg lehq, Mar riq yawd ved cuhz kheh muh yug lehq Yer suq ve khi kud haq siz god vid che yaog. Nag mand huhx u ve awg sax awr lehr, yehg ted yehg maq ve awg huhx he phehq vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kheh ma khuhd, yawd ved awg laq ghuhd awg mor awg khuhn ve te ghad Yud daq Id sar kar rir oq awr lehr koz che (Yawd awr lehr Yer suq haq kawq phuhz tug ve te ghad yaog), ");
INSERT INTO lhi_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nag mand huhx che haq phu sehz ha thehq huhd vehr lehq har yad ghuhd yad teq pa haq a thoq te mad pehg vid cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yawd che kheh koz che awr lehr, har che ghuhd che chaw teq pa haq duhd ngawx lehq koz che ma hez. Yawd awr lehr chaw khuhd phehq cheaq te lehq koz che yaog. Phu laq sax haq yawd haq sax lehq, ke lar che phu haq yawd khuhd yug jaw che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yer suq koz che, “Yad mid che haq ta ded. Ngag haq tur ax tug awg ni teq ni awg pun, nag mand huhx u ve haq yawd haq sax lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Har che ghuhd che chaw teq pa awr lehr, nig hehd geh khar thad liz chehd chehd che yaog. Kheh ma khuhd, ngag nig hehd geh khar thad liz chehd tug ma hez,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yer suq u huh chehd chehd che haq Yud daq chaw awg mor nux gha sir che te yand, i hehd u huh kae che yaog. Yer suq haq te lehq lehax veh che ma hez. Suh kig lo yawd kawq teq tuag vid che Lar sar ruq haq liz mawg gad lehq kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Awg yand u ve khuhn, paw khod nux teq pa awr lehr, Lar sar ruq haq liz dawz vehr tug jehg chez lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Awg lawn ghod ver, Lar sar ruq haq te lehq Yud daq chaw laex ghad i hehd ve awg mor awg khuhn tuhz veh chehd lehq Yer suq haq yonr veh chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Awg khaz nuhr teq ni, Yer suq awr lehr Yer ruq sar lehnr med lo lag tod che haq pawehd u ve awg khuhn gag vehr che chaw awg mor nux gha kad che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","I hehd awr lehr, chaw kha che dag ka awg kax teq pa haq yug lehq, yawd haq ca haq yug tug tuhz veh che yaog. I hehd koz che, “Ho sa na, Jawd mawd Ghig sa ve awg meh awg khuhn lag che te ghad haq awg bon ir vid-oq. Id sar rer laq chaw teq pa ve Jawd mawd haq awg bon ir vid-oq,” lehd awg khuhd hehd chawa te lehq koz kug che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Awg yand u ve haq Yer suq awr lehr, pix lar nehax haq mawg lehq cind che yaog. Liq phu khuhn buhq lar che heh, ");
INSERT INTO lhi_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Yid onr ve yad mid-og, ta kuhz. Ngawx lor, nawg ved jawd mawd awr lehr, pix lar awg yad haq cind lehq lag tod che yaog,” lehz buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yawd ved awg laq ghuhd teq pa awg kawd maq thad awg lawn u ve teq pa haq maq sir. Kheh liz, Yer suq awg mig awg phond haq gha peg khaz nuhr, yawd ved awg lawn haq che kheh te buhq lar che teq pa haq lehd ma koz, su yawd haq che kheh te vid che haq lehd ma koz, i hehd duhd nuhd-ag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yer suq Lar sar ruq haq tur phuh awg khuhn lo kug tuhaz lehq yawd haq suh kig lo kawq teq tuag vid che te yand, Yer suq geh chehd chehd che chaw teq mor awr lehr awg lawn u ve haq sax khiz kawq cax khanr chehd ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Chaw mor nux che ve teq pa yawd haq ca haq yuag che awr lehr, yawd awg hez u ve haq te che awg lawn haq i hehd gha kad cheaq te lehq yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kheh te lehq, Phar rir sehd teq pa koz daq che, “A nig teq chaweh te maq gha. Ngawx lor, mig gig yad awg gha lia yawd khaz nuhr ghaq veh vehr che yaog,” lehz te ghad he lehq te ghad koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pawehd u ve awg khuhn a kor piag tug awg pun lag che chaw teq pa awg khuhn Her lar saq chaw ted pehg pehar cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","I hehd awr lehr, Gar liq lehd muhd mig khuhn cawg che Ber sehd daq med yad Phid liq geh kae lehq, “Sar lar-og, ngag hehd Yer suq haq mawg gad che yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Phid liq kae lehq Anr drehr haq koz vid lehq, Anr drehr he lehq Phid liq ix mag Yer suq haq ca koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Awg yand u ve khuhn Yer suq koz che, “Chaw yad ve Yad phu awg mig awg phond gha tug awg yand gag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ngag nig hehd haq awg cehg mag koz ax laq, a cag yuhd teq sir mig gig khod-aq lo maq che lehq, mad lug maq suh ver, awg yuhd teq sir lehax cawg chehd che yaog. Kheh ma khuhd, lug vehr suh vehr ver, awg sir kha peh vad-ag nuhaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","A sug yawd ved a saq haq haq che chaw awr lehr, a saq gha sond tug yaog. Mig gig che khod-aq lo a sug yawd ved a saq haq cand che chaw awr lehr, co co taer taer teq che co tiq ha tiq gha tug awg pun a sug yawd ved a saq haq haq sax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ngag ved kanx haq te che chaw te ghad awr lehr, ngag khaz nuhr gha ghaq tod che yaog. Kheh te lehq, ngag chehd che ted kag lo ngag ved kanx haq te che chaw liz chehd tug yaog. Ngag ved kanx haq te che chaw te ghad haq Awr pa tar ir tar muh vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","A meha ngag ni ma duhd har jad che yaog. Ngag khawd-ehg kheh gha koz cawd hawg le. A pa-og, awg yand che awg khuhn ngag haq thaer khuhq ax laoq lehd gha koz cawd hawg la. Ma hez, awg lawn ghod ver awg yand che ve awg pun ngag lag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","A pa-og, nawg ved awg meh haq awg mig awg phond tuhaz vid-oq,” lehd koz che yaog. Awg yand u ve haq, muhd nuh maq lo awg khuhd buhg tuhaz lehq, “Ngag ved awg meh haq awg mig awg phond cawg vid peg che yaog. Kheh te lehq, ngag ved awg meh haq ngag te pawz awg mig awg phond kawq cawg vid tug ser che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","U huh hox chehd che chaw awg mor nux u ve teq pa awr lehr, awg khuhd u ve haq gha kad lehq, “Muhd tawnr vehr che yaog,” lehd koz che yaog. Ted pehg pehar awr lehr, “Muhd nuh maq cuh yad yawd haq tawd yaw vid che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yer suq kawq koz che, “Buhg tuhaz che awg khuhd u ve awr lehr, ngag awg pun ma hez. Nig hehd awg pun yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mig gig che ve awr lehr, a meha suhx jehg che haq gha khanr tug awg yand gag vehr che yaog. Mig gig che ve haq uq penr sehr phad haq a meha ghaq kog tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kheh te lehq ngag haq mig gig che ve thag lo chid taez che te yand, chaw awg gha lia haq ngag geh lo ngag ga ghawg vea tug yaog,” lehz koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yawd che kheh koz che awr lehr, yawd khawd-ehg kheh gha te suh tug awg lawn haq koz mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Chaw awg mor nux kawq koz che, “Khreq awr lehr co co taer taer teq chehd tug yaog lehz, awg lid tawd khuhd awg khuhn ngag hehd gha sir gha kad lar che yaog. Chaw yad ve Yad phu haq gha chid taez tug yaog lehz, nawg khawd-ehg kheh te lehq u kheh koz gha cheawg le. Chaw yad ve Yad phu u ve awr lehr, a suawg le,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yer suq kawq koz che, “Awg ghiz awr lehr, nig hehd geh teq pear lehax kawq chehd lar haz tug yaog. Naz hoq che nig hehd haq ma gha hoz tehr lar tug, nig hehd geh awg ghiz cawg ser che te yand, nig hehd tod kae lor. Naz hoq che awg khuhn tod kae che chaw awr lehr, yawd khar lo kae che haq yawd maq sir. ");
INSERT INTO lhi_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nig hehd geh awg ghiz cawg ser che te yand, nig hehd awg ghiz ve yad phehq tug, awg ghiz haq yonr lor,” lehz i hehd haq koz vid che yaog. Tawd che teq pa haq Yer suq koz peg khaz nuhr, i hehd chehd huh tuhz veh lehq ca khuhd jaz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","I hehd mehz khuhd suhr yawd awg hez kheh taw maq mad jad che haq te vehr liz, i hehd yawd haq maq yonr ser che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Che kheh te lag che awr lehr, Ghig sa ve cuh kar var Id sar yaq koz lar che tawd te khuhd phehaq vid tug awg pun yaog. Yawd koz che, “Jawd mawd Ghig sa-og, ngag hehd koz che tawd khuhd haq a sug yonr hawg le. A sug haq Jawd mawd Ghig sa ve kand pax pheq maw vid cheawg le,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kheh te cheaq te lehq i hehd yonr maq gha. Awg lawn ghod ver, Id sar yaq te pawz kawq koz che, ");
INSERT INTO lhi_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“I hehd mehz sir maq gha mawg tug, ni ma maq gha duhd pawnr tug he lehq ni ma mad kawq pa lehq ngag i hehd haq maq gha ghu na tug, i hehd ve mehz sir haq yawd cox vid lar lehq, i hehd ve ni ma haq yawd heh vid lar peg che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Id sar yaq u kheh koz che awr lehr, Yer suq ve awg mig awg phond haq yawd gha mawg che haq te lehq, Yer suq awg lawn haq yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kheh te lar, Yud daq chaw ve awg hox awg nax teq pa awg khuhn liz, laex ghad yawd haq yonr vehr che yaog. Kheh ma khuhd, Yud daq chaw teq pa ve bon awg mor awg khuhn ghaq tuhz ax che haq i hehd maq gha phud tug, i hehd yonr liz Phar rir sehd teq pa haq kuhz cheaq te lehq, yonr che yaog lehd i hehd ma koz tuhz. ");
INSERT INTO lhi_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Awg lawn ghod ver, Ghig sa geh lag che awg mig awg phond haq keh, chaw yad teq pa geh lag che awg mig awg phond haq i hehd haq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yer suq awg khuhd hehnd chawa kug lehq koz che, “Ngag haq yonr che chaw awr lehr, ngag haq lehax yonr che ma hez. Ngag haq lag peha che phad haq liz yonr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ngag haq mawg che chaw awr lehr, ngag haq lag peha che phad haq mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ngag haq kha yonr che chaw awg gha lia naz hoq che awg khuhn maq gha chehd tug, ngag awr lehr awg ghiz heh te lehq mig gig khod-aq lo yaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ngag ved tawd khuhd haq kad lehq maq na yug che chaw khar ve te ghad lehd ma koz, ngag yawd haq suhx mad jehg. Awg lawn ghod ver, mig gig yad teq pa haq suhx jehg tug awg pun ngag lag che ma hez. Kheh ma khuhd, mig gig yad teq pa haq thaer khuhq tug awg pun ngag lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ngag haq chid bag lehq ngag ved tawd khuhd haq mad haq yug che chaw haq suhx jehg vid var cawg che yaog. Ngag koz lar che tawd khuhd teq pa awr lehr, awg leh med teq ni ver i hehd haq suhx jehg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ngag awr lehr, ngag khad ngag a lor cawd che heh teq chaweh liz ma koz. Ngag haq lag peha che Awr pa awr lehr, ngag khawd-ehg kheh gha koz gha yaw tug, yawd ngag haq tawd pehar lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yawd tawd pehar lar che awr lehr, co co taer taer teq che co tiq ha tiq phehq che yaog lehz ngag sir che yaog. Kheh te cheaq te lehq ngag kha koz che teq pa awr lehr, Awr pa ngag haq koz ax che heh, ngag koz che yaog,” lehd yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Yer suq awr lehr mig gig che khod-aq lo tuhez lehq Awr pa geh gha koeq tug awg yand gag vehr che haq Par sar khar pawehd maq te ser huh yawd sir tar che yaog. Mig gig che khod-aq lo chehd che yawd ved chaw teq pa haq yawd haq chehd che heh, awg leh med kha gag i hehd haq yawd haq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Muhd phiq awr cad chehd huh, Yer suq haq kawq phuhz tug, ned haeg awr lehr Sid monr ve yad par Yud daq Id sar kar rir oq ve ni ma awg khuhn duhd tuhz vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yer suq awr lehr, awg ceng awg gha lia yawd ved laq kuhr awg khuhn Awr pa chid aq vid peg che haq lehd ma koz, yawd Ghig sa lo lag vehr che haq lehd ma koz, Ghig sa chehd lo kawq koeq tug haq lehd ma koz, yawd sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Awr cad chehd kig huh, Yer suq tuag lehq yawd ved a poq yehg maq haq kuhz kha peg lehq, phar ceq yug lehq, yawd ved cuhq pehng haq chuhq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kheh te lehq, a khehd nux awg khuhn a kaz ke lehq, awg laq ghuhd teq pa ve khi kud haq tanr chuhd vid che yaog. Kheh te peg lehq, yawd chuhq chehd che phar ceq yug lehq siz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yawd Sid monr Per troq chehd lo gag che te yand, Per troq koz che, “Jawd mawd-og, nawg awr lehr ngag ved khi kud haq chuhd tug awg la,” lehd koz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yer suq kawq koz che, “Ngag a thoq te chehd che haq a meha nawg maq sir. Kheh ma khuhd, awg khaz nuhr nawg sir tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Per troq koz che, “Ngag ved khi kud haq nawg te pawz-a liz maq gha chuhd hawg,” lehz yawd haq koz vid che yaog. Yer suq kawq koz che, “Ngag nawg haq maq gha chuhd ver, nawg ngag ved awg laq ghuhd ma hez,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Sid monr Per troq kawq koz che, “Jawd mawd-og, ngag ved khi kud haq lehax ma hez. Laq kuhr he lehq a kor haq liz chuh-ad laoq,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yer suq kawq koz che, “Muhg chuhd peg che chaw awr lehr, awg ton saw daq kehg vehr che haq te lehq, khi kud haq lehax chuhd tug lor che yaog. Nig hehd awr lehr daq kehg vehr che yaog. Kheh ma khuhd, nig hehd awg gha lia daq kehg che ma hez,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Awg lawn ghod ver, a sug yawd haq kawq phuhz tug haq yawd sir che yaog. Kheh te cheaq te lehq, “Nig hehd awg gha lia daq kehg che ma hez,” lehz yawd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yer suq i hehd ve khi kud haq chuhd vid peg khaz nuhr, yawd ved a poq yehg maq haq kawq deh lehq yawd ved mi kig huh kawq mi vehr che yaog. Kheh te peg lehq yawd koz che, “Ngag nig hehd haq khawd-ehg kheh tea che haq nig hehd sir-ag la. ");
INSERT INTO lhi_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nig hehd awr lehr ngag haq Sar lar he lehq Jawd mawd lehd koz che yaog. Nig hehd koz che awr lehr cawd che yaog. Awg lawn ghod ver, nig hehd koz che heh ngag awr lehr Sar lar he lehq Jawd mawd phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Kheh te lehq ngag awr lehr, Jawd mawd he lehq Sar lar phehq che liz, nig hehd ve khi kud haq chuh-ad ver, nig hehd liz te ghad lehq te ghad ve khi kud haq chuhd daq cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Awg lawn ghod ver, ngag nig hehd haq tea che heh te lehq nig hehd liz te tug, ngag nig hehd haq hend yug jawg yug tug te mar lar peor. ");
INSERT INTO lhi_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ngag nig hehd haq awg cehg mag koz ax laq, awg ceg awr lehr yawd ved awg sehr phad haq keh maq ir. Cuh pe lar che chaw liz, yawd haq cuh peha che phad haq keh maq ir. ");
INSERT INTO lhi_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Awg ceng che teq pa haq nig hehd sir lehq, sir che heh te ver, nig hehd awg bon ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Nig hehd awg gha lia haq ngag koz chehd che ma hez. Ngag lez yug lar che chaw teq pa haq ngag sir che yaog. Kheh liz che ve awr lehr, Liq phu khuhn buhq lar che heh, ‘Ngag ved cad tug haq cad che chaw te ghad awr lehr, ngag haq yawd ved khi nir khuhq ax che yaog,’ lehd koz lar che tawd te khuhd haq phehaq vid tug awg pun te che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Awg ceng che teq pa phehaq che te yand, ngag awr lehr Khreq yaog lehz nig hehd yonr tug, a meha mad phehq lag ser ghud suhr thad liz ngag nig hehd haq koz lar peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ngag nig hehd haq awg cehg mag koz ax laq, ngag kae pe che chaw haq haq yug che te ghad awr lehr, ngag haq haq yug che yaog. Ngag haq haq yug che chaw te ghad awr lehr, ngag haq lag peha che phad haq haq yug che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yer suq awr lehr, awg ceng che ve teq pa haq koz peg lehq, yawd ni ma khuhn duhd har jad lehq koz che, “Ngag nig hehd haq awg cehg mag koz ax laq, nig hehd awg khuhn chaw te ghad ngag haq kawq phuhz tug yaog,” lehz yawd sax khiz khanr lehq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","“Yawd a sug te ghad haq koz gad lehq nar,” lehz awg laq ghuhd teq pa duhd lehq, te ghad he lehq te ghad ngawx daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yawd ved awg laq ghuhd teq pa awg khuhn Yer suq haq che te ghad awr lehr, Yer suq ni ma pi pad huh en mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Sid monr Per troq awr lehr, yawd a sug haq koz che lehq nar lehd yawd haq nawg na ngawx lehq ngag hehd haq koz ax laoq lehz awg laq ghuhd u ve te ghad haq awg hez te mar vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Awg yand u ve haq, awg laq ghuhd u ve awr lehr, Yer suq ve ni ma pi awg pad huh jiz kae lehq, Jawd mawd-og, a suawg le lehz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yer suq kawq koz che, Ngag khaor mod ted dig haq yug lehq awr chid khuhn tur peg lehq pid che chaw te ghad awr lehr, yawd yaog lehd Yer suq yawd haq koz vid che yaog. Kheh te lehq, khaor mod ted dig haq awr chid khuhn chuhd peg lehq, Sid monr Id sar kar rir oq ve yad par Yud daq haq yawd pid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yud daq awr lehr, khaor mod u ve teq per-a haq cad peg lehq, Sar tanr yawd awg khuhn geh vehr che yaog. Yer suq koz che, “Nawg te tug kanx haq har naq ca teo,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","A thoq haq te lehq Yer suq yawd haq u kheh koz vid che haq teh cuh pad huh mi chehd che chaw te ghad-e liz maq sir. ");
INSERT INTO lhi_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yud daq awr lehr, phu kaw pi haq haq sax che chaw phehq che te lehq, Yer suq yawd haq, “Pawehd che awg pun a nig lor che awg ceng teq pa haq ca vir-oq,” lehd koz vid lehq nar, ma hez ver, “Har ghuhd che chaw teq pa haq ted ceng cear ca pid-oq,” lehd koz vid lehq nar lehz, i hehd ted pehg pehar duhd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yud daq awr lehr, khaor mod u ve teq per-a haq cad peg lehq teq pear lehax yawd tuhz veh che yaog. Awg yand u ve awr lehr, muhd khax te khend huh cawd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yawd tuhz veh peg khaz nuhr Yer suq koz che, “Chaw yad ve Yad phu awr lehr, a meha awg mig awg phond gha vehr che yaog. Yawd awg khuhn Ghig sa liz awg mig awg phond gha vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yawd awg khuhn Ghig sa awg mig awg phond gha cheaq te lehq, Ghig sa awr lehr yawd awg ton awg khuhn Yad phu haq awg mig awg phond pid tug yaog. Yawd awr lehr, teq pear lehax Yad phu haq awg mig awg phond pid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Haq che yad teq paog, ngag nig hehd geh teq pear lehax gha chehd tug yaog. Nig hehd ngag haq ca tug yaog. Ngag kae kig lo nig hehd lag maq gha lehz Yud daq chaw teq pa haq ngag koz vid che heh, a meha nig hehd haq liz ngag koz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nig hehd te ghad he lehq te ghad haq daoq lehz, ngag nig hehd haq tawd awg suhx te khuhd pehar che yaog. Ngag nig hehd haq haq che heh, nig hehd liz te ghad he lehq te ghad haq daoq. ");
INSERT INTO lhi_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nig hehd te ghad he lehq te ghad haq daq ver, haq daq che u ve haq te lehq nig hehd ngag ved awg laq ghuhd phehq che haq chaw awg gha lia gha sir tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sid monr Per troq koz che, “Jawd mawd-og, nawg khar lo kae tuawg le,” lehz yawd haq na ngawx che yaog. Yer suq kawq koz che, “Ngag kae kig lo a meha nawg lag mad gag. Kheh ma khuhd, awg khaz nuhr nawg ghaq lag tug yaog,” lehz koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Per troq koz che, “Jawd mawd-og, a thoq te lehq a meha ngag nawg khaz nuhr ghaq lag maq gha cheawg le. Nawg awg pun ngag ved a saq tand tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yer suq kawq koz che, “Ngag awg pun nawg ved a saq tand tuawg la. Ngag nawg haq awg cehg mag koz ax laq, ghaz phuh mad buhg ser huh, nawg ngag haq sehr pawz kha gag chid bag vehr tug yaog,” lehd yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Nig hehd ve ni ma ta duhd har gad har. Ghig sa haq yonr-oq. Ngag haq liz yonr-oq. ");
INSERT INTO lhi_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ngag Awr pa ve yehg awg khuhn chehd kig cawg mad jad che yaog. Chehd kig mad cawg che heh ver, mad cawg lehz ngag nig hehd haq koz ax lar tug yaog. Ngag koeq lehq, nig hehd awg pun chehd kig ca ghu tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ngag koeq lehq nig hehd awg pun chehd kig ca ghu lar haz peg ver, ngag ved chehd kig lo nig hehd liz gha chehd tug, ngag te pawz kawaq lehq nig hehd haq ngag geh sir ve koeq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ngag kae kig yaq kaw haq nig hehd sir che yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thod maq koz che, “Jawd mawd-og, nawg khar lo kae tug haq ngag hehd maq sir. Khawd-ehg kheh te lehq yaq kaw haq ngag hehd sir gha tuawg le,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yer suq koz che, “Ngag awr lehr yaq kaw yaog. Awg cehg mag cawd che ted ceng he lehq co ha teq che ted ceng liz ngag phehq che yaog. Ngag haq ma cud ver, chaw te ghad-eg liz Awr pa chehd lo gag maq gha. ");
INSERT INTO lhi_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nig hehd ngag haq sir ver, ngag ved Awr pa haq liz nig hehd sir tug yaog. A meha haq tanr lehq nig hehd awr lehr yawd haq sir lehq yawd haq gha mawg peor,” lehz Thod maq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Phid liq koz che, “Jawd mawd-og, ngag hehd haq Awr pa a cehax mawa laoq. Mawa ver, ngag hehd ni khaz suh tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yer suq koz che, “Phid liq-og, ngag nig hehd geh kheh muh muh chehd peg liz, nawg ngag haq maq sir ser cheawg la. Ngag haq mawg che chaw awr lehr, Awr pa haq mawg vehr che yaog. Ngag hehd haq Awr pa a cehax mawa laoq lehz, nawg khawd-ehg kheh te koz gha cheawg le. ");
INSERT INTO lhi_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Awr pa awg khuhn lo ngag chehd lehq ngag awg khuhn lo Awr pa chehd che haq nawg maq yonr lehq la. Ngag nig hehd haq koz ax lar che tawd khuhd teq pa awr lehr, ngag khad ngag a lor cawd che heh ngag koz che ma hez. Kheh ma khuhd, ngag awg khuhn chehd chehd che Awr pa awr lehr, yawd ved kanx teq pa haq yawd te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngag awr lehr Awr pa awg khuhn chehd lehq Awr pa awr lehr ngag awg khuhn chehd che haq yonr lor. Ma hez ver, ngag te che kanx teq pa haq te lehq ngag haq yonr lor. ");
INSERT INTO lhi_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ngag nig hehd haq awg cehg mag koz ax laq, ngag haq yonr che chaw awr lehr ngag te che kanx teq pa haq yawd te tug yaog. Kanx che ve teq pa haq keh ir che kanx teq pa haq liz yawd te tug yaog. Awg lawn ghod ver, ngag awr lehr Awr pa chehd lo kawq veh tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Awr pa awr lehr Yad phu haq te lehq awg mig awg phond gha tug, ngag ved awg meh awg khuhn nig hehd kha lawg che teq pa haq ngag te tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ngag ved awg meh awg khuhn nig hehd ted ceng cear lawg ver, nig hehd lawg che heh ngag te tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nig hehd ngag haq haq ver, ngag pid lar che tawd khuhd teq pa haq nig hehd na yug lehq te tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ngag awr lehr, Awr pa geh lawg lehq, nig hehd geh co co taer taer chehd tug, awg kag awr ve Ga vid var te ghad yawd nig hehd haq pehar tug yaog. Ga vid var u ve awr lehr, awg cehg mag cawd che Awg ha phu phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mig gig yad teq pa awr lehr, yawd haq mad mawg maq sir cheaq te lehq, yawd haq haq yug maq gha. Kheh ma khuhd, nig hehd awr lehr yawd haq sir che yaog. Awg lawn ghod ver, yawd nig hehd geh chehd lehq, nig hehd awg khuhn liz yawd chehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ngag nig hehd haq yad chawd sia heh chid bag lar haz ax tug ma hez. Ngag nig hehd geh kawaq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Teq cuhx nehax gaeg ver, mig gig yad teq pa awr lehr ngag haq maq gha kawq mawg-o. Kheh liz nig hehd awr lehr, ngag haq gha kawq mawg tug yaog. Ngag teq chehd che haq te lehq, nig hehd liz gha teq chehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","U ve teq ni gaeg ver, Awr pa awg khuhn ngag chehd che haq lehd ma koz, nig hehd ngag awg khuhn chehd che haq lehd ma koz, ngag nig hehd awg khuhn chehd che haq lehd ma koz, nig hehd gha sir tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ngag pid lar che tawd khuhd haq kad lehq te che chaw awr lehr, ngag haq haq che chaw phehq che yaog. Ngag haq haq che chaw te ghad haq ngag ved Awr pa haq tug yaog. Ngag liz chaw u ve haq haq lehq, ngag ved awg ton yawd haq kha sehax maw vid tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yud daq Id sar kar rir oq ma hez che, Yud daq meh che te ghad koz che, “Jawd mawd-og, a thoq haq te lehq nawg ved awg ton ngag hehd haq mawa lehq mig gig yad teq pa haq maq maw vid cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yer suq kawq koz che, “Ngag haq haq che chaw awr lehr, ngag ved tawd khuhd haq na yug lehq te tug yaog. Ngag ved Awr pa yawd haq haq tug yaog. Ngag nid-ag yawd chehd lo lag lehq yawd geh chehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ngag haq mad haq che chaw awr lehr, ngag ved tawd khuhd haq maq na yug. Kheh te lehq, nig hehd gha kad che tawd khuhd awr lehr, ngag ved tawd khuhd ma hez. Ngag haq peha lar che Awr pa ve tawd khuhd phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ngag nig hehd geh chehd chehd ser che te yand, tawd khuhd che teq pa ngag nig hehd haq koz lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Kheh ma khuhd, Awr pa awr lehr, ngag ved awg meh awg khuhn nig hehd haq Ga vid sehr phad Daq che kehg che Awg ha phu haq peha tug yaog. Yawd awr lehr, nig hehd haq awg ceng gha lia mar ax lehq, ngag nig hehd haq kha koz ax che tawd khuhd awg gha lia nig hehd haq kawq duhd nuhad tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Duhd sa gad sa che ted ceng ngag nig hehd haq teh lar haz ax che yaog. Ngag nig hehd haq pehar che ngag ved duhd sa gad sa che ted ceng awr lehr, mig gig yad teq pa pehar che heh ngag nig hehd haq pehar che ma hez. Nig hehd ve ni ma ta duhd har gad har. Kuhz che ni ma liz tad cawg vid. ");
INSERT INTO lhi_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ngag koeq lehq nig hehd chehd lo ngag te pawz kawq kawaq tug yaog lehz ngag nig hehd haq koz ax vehr che tawd khuhd haq nig hehd gha kad peg che yaog. Nig hehd ngag haq haq ver, Awr pa chehd lo ngag koeq cheaq te lehq nig hehd ha lehg tug yaog. Awg lawn ghod ver, Awr pa awr lehr ngag haq keh ir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kheh te lehq, awg ceng u ve teq pa phehaq che te yand, nig hehd gha yonr tug, mad phehq lag ser ghud suhr a meha liz ngag nig hehd haq koz ax peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","A meha haq tanr lehq ngag nig hehd haq tawd kheh taw taw mad kawq yaw-og. Awg lawn ghod ver, mig gig che ve haq uq penr che phad lag chehd che yaog. Yawd awr lehr ngag awg khod-aq teq chaweh kand pax mad cawg. ");
INSERT INTO lhi_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Kheh ma khuhd, Awr pa haq ngag haq che yaog lehz, mig gig yad teq pa gha sir tug, Awr pa ngag haq tawd pehar lar che heh ngag te che yaog. Tu lor. Kae veg. ");
INSERT INTO lhi_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Ngag awr lehr awg cehg mag phehq che a pehx med te phehq che yaog. Ngag ved Awr pa awr lehr, kho haq sax var phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ngag awg khuhn awg sir mad nuhq che awg kax teq pa haq yawd tawz kha che yaog. Awg sir nuhq che awg kax teq pa haq awr lehr, lex lehq awg sir nuhq mad-ag tug yawd kehr ghad ghu sawnr vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ngag nig hehd haq koz ax lar che tawd khuhd haq te lehq, a meha liz nig hehd daq kehg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ngag awg khuhn chehd-oq. Ngag liz nig hehd awg khuhn chehd tug yaog. Awg kax awr lehr, awg te haq maq cuhx nuhq ver, yawd khad yawad awg sir nuhaq maq gha che heh, nig hehd liz ngag awg khuhn ma chehd ver, awg sir nuhaq maq gha. ");
INSERT INTO lhi_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ngag awr lehr a pehx med te phehq lehq, nig hehd awr lehr awg kax teq pa phehq che yaog. Ngag awg khuhn chehd lehq, ngag liz yawd awg khuhn chehd che chaw te ghad awr lehr, awg sir kha peh vad-ag nuhaq che yaog. Awg lawn ghod ver, ngag haq phaz daq ver, nig hehd teq chaweh liz te maq gha. ");
INSERT INTO lhi_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ngag awg khuhn ma chehd che chaw awr lehr, awg kax teq pa heh te lehq chid bag che haq gha khanr lehq, nuhr vehr god vehr tug yaog. U kheh te che awg kax teq pa haq su ghawz phoz lehq, a mir awg khuhn chid bag ke lehq a mir toq bag vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Nig hehd ngag awg khuhn chehd lehq ngag ved tawd khuhd nig hehd awg khuhn chehd ver, nig hehd lawg gad che heh lawr-oq. Nig hehd gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nig hehd awg sir kha peh vad-ag nuhaq che haq te lehq, ngag ved Awr pa awg mig awg phond gha lehq, nig hehd liz ngag ved awg laq ghuhd awg cehg mag phehq che haq su gha mawg tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Awr pa ngag haq haq che heh, ngag liz nig hehd haq haq che yaog. Ngag ved haq pehnd che awg khuhn chehd-oq. ");
INSERT INTO lhi_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ngag ved Awr pa pid lar che tawd khuhd teq pa haq ngag na yug lehq yawd ved haq pehnd che awg khuhn ngag chehd chehd che heh, nig hehd liz ngag pehar lar che tawd khuhd teq pa haq na yug ver, ngag ved haq pehnd che awg khuhn nig hehd chehd tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nig hehd awg khuhn ngag ved ha lehg che cawg lehq nig hehd ha lehg che peh lawq tug, tawd che ve teq pa ngag nig hehd haq koz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ngag pehar lar che tawd awr lehr, ngag nig hehd haq haq che heh, nig hehd te ghad he lehq te ghad haq daoq. ");
INSERT INTO lhi_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A sug yawd ved awg chawd teq pa awg pun, a sug yawd ved a saq tand vid che haq pehnd che ted ceng haq keh ir che haq pehnd che ted cear liz mad cawg. ");
INSERT INTO lhi_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nig hehd awr lehr ngag pehar lar che tawd khuhd teq pa haq te ver, nig hehd ngag ved awg chawd phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","A meha haq tanr lehq, ngag nig hehd haq awg ceg lehz mad kawq koz vehr che yaog. Awg lawn ghod ver, awg ceg awr lehr awg sehr phad a thoq ted ceng te tug haq yawd maq sir. Ngag nig hehd haq awg chawd lehd koz che yaog. Awg lawn ghod ver, Awr pa geh ngag gha kad che awg ceng awg gha lia ngag nig hehd haq koz ax peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nig hehd ngag haq lez yug lar che ma hez. Ngag nig hehd haq lez yug lar che yaog. Nig hehd kae lehq awg sir nuhaq lehq, awg sir u ve yeg chehd tug awg pun, ngag nig hehd haq lez teh lar che yaog. Nig hehd u kheh te ver, ngag ved awg meh awg khuhn Awr pa geh nig hehd kha lawg che awg gha lia yawd nig hehd haq pehar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ngag nig hehd haq tawd kheh te pehar che yaog. Nig hehd te ghad he lehq te ghad haq daoq. ");
INSERT INTO lhi_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Mig gig yad nig hehd haq cand ver, nig hehd haq ma cand ser awg kawd thad liz ngag haq cand vehr che yaog lehz sir-oq. ");
INSERT INTO lhi_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nig hehd awr lehr mig gig ve chaw phehq ver, mig gig yad teq pa awr lehr nig hehd haq a sug yawd ved chaw heh te lehq, haq tug yaog. Kheh ma khuhd nig hehd awr lehr, mig gig ve chaw phehq che ma hez lehq mig gig awg khuhn ngag nig hehd haq lez tuhz che haq te lehq, mig gig yad teq pa nig hehd haq cand che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Awg ceg awr lehr yawd ved awg sehr phad haq keh maq ir lehz ngag nig hehd haq koz ax lar peg che haq duhd nuhd-og. Mig gig yad teq pa ngag haq du deh ax che ver, nig hehd haq liz du deh ax tug yaog. Ngag ved tawd khuhd haq i hehd na yug lehq te ver, nig hehd ve tawd khuhd haq liz na yug lehq te tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Kheh ma khuhd i hehd awr lehr ngag ved awg meh haq te lehq, awg ceng che ve awg gha lia nig hehd haq tea tug yaog. Awg lawn ghod ver, ngag haq lag peha che phad haq i hehd maq sir. ");
INSERT INTO lhi_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ngag mad lag lehq i hehd haq tawd maq gha yaw vid-ag ver, i hehd vend bax cawg tug ma hez. Kheh ma khuhd, a meha i hehd awr lehr vend bax gha pong tug, teq chaweh ca koz kig mad cawg. ");
INSERT INTO lhi_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ngag haq cand che chaw awr lehr, ngag ved Awr pa haq liz cand che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Awg kag awr ve chaw te ghad-eg liz maq te jaw che kanx haq i hehd teq pa awg khuhn ngag maq te vehr ver, i hehd awr lehr vend bax cawg tug ma hez. Kheh ma khuhd, a meha ngag he lehq ngag ved Awr pa haq i hehd gha mawg lehq, cand vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Che kheh phehaq che awr lehr, i hehd ve awg lid tawd khuhd awg khuhn buhq lar che heh, “Teq chaweh awg lawn mad cawg liz, i hehd ngag haq cand vehr che yaog,” lehd koz lar che tawd te khuhd haq te peh vid tug awg pun phehaq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Awr pa chehd lo lag che Ga vid var haq ngag nig hehd chehd lo lag peha tug yaog. Yawd awr lehr, Awr pa chehd lo tuhaz che awg cehg mag cawd che ted ceng ve Awg ha phu phehq che yaog. Yawd lag gag che te yand, ngag awg lawn yawd sax khiz khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nig hehd liz, awg khiz penr thad haq tanr lehq ngag geh teq geha chehd chehd che haq te lehq, ngag awg lawn sax khiz khanr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nig hehd yonr che khuhn ni ma maq gha nud lehq maq gha kuhd veh tug, awg lawn che teq pa ngag nig hehd haq koz lar haz ax che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Su nig hehd haq Yud daq chaw ve bon awg mor awg khuhn ghaq kog tug yaog. Nig hehd haq dawz vehr che chaw awr lehr, Ghig sa ve kanx haq te che yaog lehd duhd lehq kheh te che awg yand awr lehr lag gag tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","I hehd awr lehr, Awr pa haq lehd ma koz, ngag haq lehd ma koz, maq sir cheaq te lehq u kheh te tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kheh ma khuhd, awg yand u ve lag gag thad ver, awg lawn che teq pa ngag nig hehd haq koz lar haz ax che haq nig hehd duhd nuhd tug, tawd che teq pa ngag nig hehd haq koz ax vehr che yaog. Ngag nig hehd geh teq geha chehd chehd ser cheaq te lehq, awg kawd thad liz awg lawn che teq pa ngag nig hehd haq ma koz ax ser. ");
INSERT INTO lhi_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Kheh ma khuhd, ngag haq lag peha che phad chehd lo a meha ngag koeq tug yaog. ‘Nawg khar lo kae tuawg le,’ lehz nig hehd te ghad-eg liz ngag haq maq na ngawx law. ");
INSERT INTO lhi_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Kheh liz, awg lawn che teq pa ngag nig hehd haq koz ax cheaq te lehq, nig hehd ve ni ma awg khuhn duhd har tug kha peh cawg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kheh ma khuhd, ngag nig hehd haq thed-e ghad koz ax laq, ngag koeq che awr lehr nig hehd awg pun awg bon cawg che yaog. Awg lawn ghod ver, ngag mad koeq ver, Ga vid var nig hehd geh lo mad lag hawg. Kheh ma khuhd ngag koeq ver, ngag yawd haq nig hehd geh lo lag peha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Yawd lag che te yand, vend bax awg lawn lehd ma koz, thed che cawd che awg lawn lehd ma koz, suhx jehg suhx taz che awg lawn lehd ma koz, mig gig yad teq pa awr lehr awg ceng che teq pa haq caz daq che awg lawn haq i hehd duhd yaq chehd che yaog lehz yawd i hehd haq kha sehax pheq maw vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","I hehd ngag haq maq yonr che haq te lehq, vend bax awg lawn pheq mar vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ngag awr lehr Awr pa chehd lo koeq lehq, nig hehd ngag haq maq gha kawq mawg tug haq te lehq, thed che cawd che awg lawn pheq mar vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mig gig che haq uq penr che jawd mawd te ghad haq suhx jehg suhx taz vid peg che haq te lehq suhx jehg suhx taz che awg lawn liz pheq mar vid tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ngag nig hehd haq koz ax tug awg ceng kha peh vad-ag cawg ser che liz, a meha nig hehd haq yug maq gha ser. ");
INSERT INTO lhi_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kheh ma khuhd, awg cehg mag cawd che Awg ha phu lag che te yand, awg cehg mag cawd che awg gha lia ve awg khad awg khuhn nig hehd gehe tug, yawd nig hehd haq seh kae ax tug yaog. Awg lawn ghod ver, yawd khad yawad yaw gad che heh yawd yaw che ma hez. Kheh ma khuhd, yawd kha gha kad che awg ceng teq pa haq lehax koz mar ax tug yaog. Awg khaz nuhr phehaq tug awg lawn teq pa liz, yawd nig hehd haq koz mar ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yawd awr lehr, ngag haq awg mig awg phond pid tug yaog. Awg lawn ghod ver, ngag ved awg ceng haq yawd yug lehq nig hehd haq koz mar ax tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Awr pa kha cawg che awg ceng gha lia ngag ved phehq che yaog. Kheh te cheaq te lehq, ngag ved awg ceng che ve haq yawd yug lehq, nig hehd haq koz mar ax tug yaog lehz ngag koz ax peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Teq thawz nehax gaeg ver, nig hehd ngag haq maq gha kawq mawg-o. Teq thawz nehax kawq gaeg ver, gha kawq mawg tug yaog,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Awg yand u ve khuhn yawd ved awg laq ghuhd ted pehg pehar koz che, “‘Teq thawz nehax gaeg ver, nig hehd ngag haq maq gha kawq mawg-o. Teq thawz nehax kawq gaeg ver, gha kawq mawg tug yaog,’ lehd koz ax che lehd ma koz, ‘Ngag Awr pa chehd lo kawq veh cheaq te lehq,’ lehd koz ax che lehd ma koz, yawd a nig haq khawd-ehg kheh koz ax gad che lehq nar,” lehz i hehd te ghad he lehq te ghad koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Kheh te peg lehq i hehd kawq koz che, “‘Teq thawz nehax gaeg ver,’ lehd yawd koz che tawd te khuhd a thoq haq koz gad cheawg le. Yawd koz che tawd khuhd haq a nig maq sir,” lehz i hehd koz daq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","I hehd yawd haq na ngawx gad che haq Yer suq sir cheaq te lehq yawd koz che, “‘Teq thawz nehax gaeg ver, nig hehd ngag haq maq gha kawq mawg-o. Teq thawz nehax kawq gaeg ver, gha kawq mawg tug yaog,’ lehz ngag koz ax che tawd khuhd haq nig hehd te ghad he lehq te ghad na daq chehd cheawg la. ");
INSERT INTO lhi_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ngag nig hehd haq awg cehg mag koz ax laq. Nig hehd gha kug huhg paz huhg tug yaog. Kheh ma khuhd, mig gig yad teq pa awr lehr, gha ha lehg tug yaog. Nig hehd gha duhd har tug liz, nig hehd duhd har che u ve awr lehr, ha lehg tug kawq phehq tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yad mid te ghad yad paw che te yand, yad paw tug awg yand gag vehr cheaq te lehq, yawd duhd har che yaog. Kheh ma khuhd, yad paw peg khaz nuhr, mig gig che khod-aq lo chaw te ghad pawag vehr che haq te lehq, yawd ha lehg jad lehq awg kawd thad yawd gha khanr che teq pa haq mad kawq duhd nuhd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","U ve heh te lehq, a meha nig hehd gha duhd har liz, ngag nig hehd haq te pawz kawq phud daq tug haq te lehq, nig hehd ve ni ma gha ha lehg tug yaog. Kheh te lehq, nig hehd ve ha lehg che u ve haq chaw te ghad-eg liz nig hehd geh hinx yug ve maq gha. ");
INSERT INTO lhi_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","U ve teq ni gaeg ver, nig hehd ngag haq teq chaweh liz mad kawq na ngawx tug yaog. Ngag nig hehd haq awg cehg mag koz ax laq. Ngag ved awg meh awg khuhn Awr pa geh nig hehd ted ceng cear lawg ver, yawd nig hehd haq pehar tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","A meha kha gag ngag ved awg meh haq cud lehq nig hehd ted cear liz mad lawg jaw ser. Nig hehd ve ha lehg che ted ceng peh lawq tug lawg lor. Lawg ver, gha tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ngag tawd par hax yehd lehq, nig hehd haq awg lawn che ve teq pa koz mar lar peg che yaog. Tawd par hax mad kawq yehd lehq, Awr pa ve awg lawn ngag nig hehd haq kha sehax koz mar ax tug awg yand gag vehr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Awg yand u ve awg khuhn nig hehd ngag ved awg meh haq cud lehq lawg tug yaog. Nig hehd awg pun Awr pa geh ngag lawg tug yaog lehz, ngag ma koz. ");
INSERT INTO lhi_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Awg lawn ghod ver, nig hehd ngag haq haq lehq, Awr pa geh lo ngag lag che yaog lehz nig hehd yonr cheaq te lehq, Awr pa yawd awg ton nig hehd haq haq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ngag awr lehr Awr pa geh lo lag lehq, mig gig khod-aq lo lag gag vehr che yaog. Kheh te lehq, a meha mig gig che awg khuhn lo ngag tuhz veh lehq Awr pa chehd lo kawq koeq tug yaog,” lehd yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yawd ved awg laq ghuhd teq pa koz che, “A meha nawg tawd par hax ma yehd lehq kha sehax koz ax chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nawg awg gha lia haq sir chehd che haq lehd ma koz, chaw te ghad-eg liz nawg haq na ngawax tug nawg maq lor che haq lehd ma koz, a meha ngag hehd sir che yaog. Kheh te cheaq te lehq, nawg Ghig sa geh lo lag che haq ngag hehd yonr che yaog,” lehd i hehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yer suq kawq koz che, “A meha nig hehd yonr vehor la. ");
INSERT INTO lhi_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ngawx lor, nig hehd phaz daq lehq, nig hehd awg gha lia a sug yawd ved chehd kig lo koeq lehq ngag haq lehax chid bag lar haz tug awg yand gag vehr tez lehq a meha liz lag gag vehr che yaog. Kheh ma khuhd, ngag awr lehr ngag te ghad lehax gha chehd tug ma hez. Awg lawn ghod ver, Awr pa ngag geh chehd chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nig hehd ngag haq te lehq duhd sa gad sa che ted ceng haq gha tug, tawd che teq pa ngag nig hehd haq koz ax peor. Mig gig che khod-aq lo nig hehd gha tuq gha khanr tug yaog. Kheh ma khuhd ni ma tad lug. Ha lehg chehd-oq. Ngag awr lehr mig gig che ve haq ghad vehr che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tawd u ve teq pa haq Yer suq koz peg lehq, yawd muhd nuh maq lo chid ngawx lehq koz che, “A pa-og, awg yand lag gag vehr-or. Yad phu awr lehr nawg haq awg mig awg phond pid tug, nawg ved Yad phu haq awg mig awg phond pid-oq. ");
INSERT INTO lhi_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Awg lawn ghod ver, Yad phu haq kha chid aq vid lar che chaw teq pa haq yawd co co taer taer teq che co tiq ha tiq pid tug, chaw ceng awg gha lia awg khod-aq nawg yawd haq kand pax pid peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Kheh te lehq, awg cehg mag phehq che Ghig sa nawg te ghad lehax he lehq nawg peha lar che Yer suq Khreq haq i hehd sir che ted ceng awr lehr, co co taer taer teq che co tiq ha tiq phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nawg ngag haq te cuha che kanx haq ngag te peg cheaq te lehq, mig gig che khod-aq lo ngag nawg haq awg mig awg phond pid lar peg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","A pa-og, mig gig maq te phanr ser thad loar nawg geh teq geha ngag cawg chehd che awg mig awg phond, a meha nawg mehz khuhd suhr huh ngag haq pehar laoq. ");
INSERT INTO lhi_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Mig gig yad teq pa awg khuhn nawg ngag haq pehar lar peg che chaw teq pa haq nawg ved awg lawn ngag pheq maw vid peg che yaog. I hehd awr lehr nawg ved chaw phehq lehq, ngag ved laq kuhr awg khuhn nawg i hehd haq aq vid ax lar che yaog. Kheh te lehq, nawg ved tawd khuhd haq i hehd na yug lehq te vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nawg ngag haq kha pehar lar che awg ceng awg gha lia awr lehr, nawg geh lo lag che haq a meha i hehd sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Awg lawn ghod ver, nawg ngag haq koz ax che tawd khuhd teq pa ngag i hehd haq koz vid peg che yaog. Kheh te lehq, tawd khuhd u ve teq pa haq i hehd haq yug lehq, ngag nawg geh lo lag che haq i hehd awg cehg mag kha sehax sir lehq, nawg ngag haq peha lar che haq i hehd yonr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","I hehd awg pun ngag bon lawg chehd che yaog. Mig gig yad teq pa awg pun ngag bon lawg che ma hez. Kheh ma khuhd, nawg ngag haq pehar lar che chaw teq pa awg pun ngag bon lawg chehd che yaog. Awg lawn ghod ver, i hehd awr lehr nawg ved chaw phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ngag kha cawg che chaw awg gha lia awr lehr, nawg ved yaog. Nawg kha cawg che chaw awg gha lia liz, ngag ved yaog. Kheh te lehq, i hehd teq pa haq te lehq ngag awg mig awg phond gha che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","A meha haq tanr lehq mig gig khod-aq lo ngag mad kawq chehd-o. Kheh ma khuhd, chaw che teq pa awr lehr, mig gig khod-aq lo chehd chehd ser che yaog. Ngag nawg geh lo kawaq tug yaog. Daq che kehg che A pa-og, ngag nid-ag te ghad lehax phehq che heh te lehq i hehd liz te ghad lehax phehaq tug, nawg ngag haq pehar lar che nawg ved awg meh awg khuhn i hehd teq pa haq haq sax-oq. ");
INSERT INTO lhi_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ngag i hehd geh chehd chehd che te yand, nawg ngag haq pehar lar che chaw teq pa haq nawg ved awg meh awg khuhn ngag haq sax lar peg che yaog. Ngag i hehd haq haq sax lar che haq te lehq, lug vehr sez vehr che yad te ghad ma hez ver, te ghad-eg liz mad mehx vehr che yaog. Chaw u ve te ghad lug vehr che awr lehr, Liq phu khuhn peh lawq tug awg pun te che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","A meha ngag nawg geh lo kawaq tug yaog. Ngag ved ha lehg che ted ceng i hehd awg khuhn pehag vid tug, ngag mig gig khod-aq lo chehd chehd ser che te yand tawd che teq pa i hehd haq ngag koz vid lar haz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nawg ved tawd khuhd ngag i hehd haq pid vehr che yaog. Kheh te lehq, ngag awr lehr mig gig ve chaw phehq che ma hez che heh, i hehd liz mig gig ve chaw phehq che ma hez cheaq te lehq, mig gig yad i hehd haq cand che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mig gig che khod-aq lo nawg i hehd haq yug tuhz tug ngag lawg che ma hez. Kheh ma khuhd, haeg che te ghad haq gha pong tug awg pun nawg i hehd haq haq sax tug ngag lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ngag awr lehr mig gig ve chaw phehq che ma hez che heh, i hehd liz mig gig ve chaw phehq che ma hez. ");
INSERT INTO lhi_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Awg cehg mag cawd che ted ceng haq cud lehq i hehd haq daq lag kehg lag vid-oq. Nawg ved tawd khuhd awr lehr awg cehg mag cawd che ted ceng phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nawg ngag haq mig gig che khod-aq lo peha lar che heh, ngag liz i hehd haq mig gig che khod-aq lo kae pe che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Awg cehg mag cawd che ted ceng haq te lehq i hehd gha daq gha kehg vid tug, i hehd awg pun ngag ved awg ton nawg haq ngag tand vid lar peor. ");
INSERT INTO lhi_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Chaw che teq pa awg pun lehax ngag bon lawg che ma hez. I hehd mar che tawd khuhd haq te lehq ngag haq yonr tug ve chaw teq pa awg pun liz ngag bon lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","I hehd awg gha lia te ghad heh lehax phehaq tug awg pun ngag bon lawg che yaog. A pa-og, nawg ngag awg khuhn chehd lehq ngag liz nawg awg khuhn chehd che heh, i hehd awg gha lia liz ngag nid-ag awg khuhn chehd vid-oq. U kheh te ver, nawg ngag haq lag peha che yaog lehz mig gig yad teq pa yonr tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ngag nid-ag te ghad lehax phehq che heh te lehq, i hehd liz te ghad lehax phehaq tug, nawg ngag haq pehar lar che awg mig awg phond i hehd haq ngag pid vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","I hehd awg cehg mag te ghad lehax kha nehax phehaq tug, ngag i hehd awg khuhn chehd lehq nawg liz ngag awg khuhn chehd che yaog. U kheh te ver, nawg ngag haq peha lar che haq lehd ma koz, ngag haq haq che heh i hehd haq liz nawg haq che haq lehd ma koz, mig gig yad teq pa gha sir tug yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","A pa-og, mig gig che haq maq te phanr ser thad liz nawg ngag haq haq cheaq te lehq nawg ngag haq pehar lar che awg mig awg phond haq i hehd gha mawg tug, nawg ngag haq pehar lar che chaw teq pa haq ngag geh teq geha chehd cuh vid gad che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Thed che cawd che A pa-og, mig gig yad teq pa nawg haq maq sir liz, ngag nawg haq sir lehq nawg ngag haq peha lar che yaog lehz chaw che ve teq pa sir chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nawg ngag haq haq che haq pehnd che ted ceng i hehd awg khuhn lo cawg lehq ngag i hehd awg khuhn chehd tug nawg ved awg lawn ngag i hehd haq sir vid lar peg che yaog. Kheh te lehq, ngag i hehd haq kawq cax sir vid tug ser che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yer suq u kheh koz peg khaz nuhr, yawd ved awg laq ghuhd teq pa geh teq geha tuhz veh lehq, Ker donr lawg kax ox pax awr lo khanr kae che yaog. U huh cawg che kho awg khuhn yawd he lehq yawd ved awg laq ghuhd teq pa teq geha gehe che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yer suq awr lehr yawd ved awg laq ghuhd teq pa geh teq geha u huh laex pawz phawng daq jaw cheaq te lehq, yawd haq kawq phuhz par Yud daq awr lehr, chehd kig u ve haq sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kheh te lehq Yud daq awr lehr, maq yad teq mor he lehq paw khod nux he lehq Phar rir sehd teq pa kae peha che bon yehg nux ve maq yad teq pa haq sir veha lehq lag che yaog. I hehd awr lehr, a mir khehd tox lehq a mir liz tox lehq laq cax liz yug veha lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Kheh te lehq, Yer suq awr lehr, yawd haq khawd-ehg kheh phehq tug awg gha lia haq sir lehq, yawd i hehd geh kae lehq, “Nig hehd a sug haq ca cheawg le,” lehz i hehd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","I hehd kawq koz che, “Nar sar rehq chaw Yer suq haq ca che yaog,” lehd koz che te yand, “Ngag awr lehr yawd yaog,” lehz Yer suq i hehd haq kawq koz vid che yaog. Yawd haq kawq phuhz par Yud daq liz i hehd geh hox chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ngag awr lehr yawd yaog lehz Yer suq koz che te yand, i hehd awg khaz nuhr jiz koeq lehq mig kag lo kuhd veh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","“Nig hehd a sug haq ca cheawg le,” lehz yawd i hehd haq te pawz kawq na ngawx che te yand, “Nar sar rehq chaw Yer suq haq ca che yaog,” lehz i hehd kawq koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yer suq kawq koz che, “Ngag awr lehr yawd yaog lehz nig hehd haq ngag koz ax peg che yaog. Kheh te lehq, nig hehd ngag haq ca che ver, chaw che teq pa haq phehd vid-oq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yawd che kheh koz che awr lehr, “Nawg ngag haq pehar lar che chaw teq pa awg khuhn chaw te ghad-eg liz maq mehx veh,” lehd koz lar che tawd te khuhd haq phehaq vid tug awg pun koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Awg yand u ve haq, Sid monr Per troq a teh puhd chehd che haq te lehq, a teh u ve haq yawd ghawg tuhz lehq, paw khod nux ve awg ceg te ghad haq chuh lehq, laq yaq awr pax awr ve nar puh chez che yaog. Awg ceg u ve awr lehr, Mar lar khuz meh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Awg yand u ve khuhn, Yer suq awr lehr Per troq haq koz vid che, “Nawg ved a teh awg phi awg khuhn kawq khuhq ke-og. Awr pa ngag haq pehar lar che kawz khehd haq ngag maq gha dawg tug lehq la,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Awg yand u ve khuhn, maq yad teq mor, i hehd ve awg hox he lehq Yud daq chaw ve awg hox awg nax teq pa peha che bon yehg nux ve maq yad teq pa u ve awr lehr, Yer suq haq yug pheh lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Awg kawd maq thad yawd haq Ar naq chehd lo yug ve kae che yaog. Awg lawn ghod ver, Ar naq awr lehr Kar yar phaq ve awg pur phehq che yaog. Kar yar phaq awr lehr, u ve ted khuhq awg khuhn paw khod nux te chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kar yar phaq u ve te ghad awr lehr, “Chaw ceng awg pun chaw te ghad suh ver, lex lehq daq jad che yaog,” lehz Yud daq chaw ve awg hox awg nax teq pa haq awg khad bez mar vid jaw che te ghad yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sid monr Per troq he lehq awg kag awr ve awg laq ghuhd te ghad Yer suq khaz nuhr ghaq kae che yaog. Awg laq ghuhd u ve te ghad awr lehr, paw khod nux haq sir daq cheaq te lehq, paw khod nux ve sax nax awg pad huh ko lar che awg khuhn Yer suq geh teq geha gehe che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kheh ma khuhd, Per troq awr lehr, awg bag phawd awr ghaz mir awg pad huh hox chehd che yaog. Kheh te lehq, paw khod nux haq sir daq che awg laq ghuhd u ve te ghad tuhez lehq, ghaz mir paog sehr ma haq koz vid peg lehq, Per troq haq sir gehag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Awg yand u ve haq, ghaz mir paog sehr ma awr lehr, “Nawg liz chaw u ve te ghad ve awg laq ghuhd phehq che ma hez hawg la,” lehd koz Per troq haq na ngawx che te yand, “Ma hez hawg,” lehz yawd kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Awg yand u ve khuhn kaz cheaq te lehq, awg ceg teq pa he lehq maq yad teq pa awr lehr, sir niq haq yug lehq a mir ceh lehq, hox lehg chehd che yaog. Per troq liz i hehd geh hox lehq a mir lehg chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Awg yand u ve khuhn paw khod nux awr lehr, Yer suq haq yawd ved awg laq ghuhd teq pa he lehq yawd mar vid che teq pa awg lawn na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yer suq kawq koz che, “Chaw awg mor nux mehz khuhd suhr huh mig gig yad teq pa haq ngag mar vid peg che yaog. Yud daq chaw awg gha lia phawng daq kig Yud daq chaw ve bon lawg kig teq pa awg khuhn lehd ma koz, bon yehg nux awg khuhn lehd ma koz, ngag khar thad liz mar che yaog. Ngag su haq ted cear liz ma khuhd mar jaw. ");
INSERT INTO lhi_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","A thoq te lehq nawg ngag haq na ngawax cheawg le. Ngag i hehd haq a thoq mar vid che awg lawn, ngag mar vid che chaw teq pa haq na ngawx-oq. Ngag a thoq mar che haq i hehd sir che yaog,” lehz yawd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yawd che kheh koz che te yand, awg pad huh hox chehd che Yud daq chaw ve awg hox awg nax teq pa peha che bon yehg nux ve maq yad te ghad awr lehr, Yer suq haq tha phehd lehq, “Paw khod nux haq nawg che kheh te yaw khuhq cheawg la,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yer suq kawq koz che, “Ngag koz che ma cawd ver, ma cawd che haq kha nehax bez mar ax laoq. Ngag koz che cawd che ver, a thoq haq te ngag haq dawz ax cheawg le,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yer suq haq su pheh lar che haq Ar naq maq phi lehq, paw khod nux Kar yar phaq chehd lo yawd haq sir kae cuh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Sid monr Per troq hox lehq a mir lehg chehd huh, “Nawg liz yawd ved awg laq ghuhd ma hez hawg la,” lehd koz i hehd yawd haq na ngawx che yaog. “Ma hez hawg,” lehz yawd koz lehq her ka che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Per troq chuh lehq nar puh chez che chaw te ghad ve a vix a nax phehq che paw khod nux ve awg ceg te ghad koz che, “Nawg awr lehr kho awg khuhn chaw u ve geh teq geha chehd chehd che haq ngag mawg che yaog ma hez hawg la,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Per troq te pawz kawq her ka che yaog. Awg yand u ve haq ghaz phuh buhg vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","U ve awg khaz nuhr naq mi sawx ted naq huh, i hehd awr lehr Yer suq haq Kar yar phaq chehd lo te lehq Yud daq muhd mig khod-aq uq penr che Rod maq jawd mawd ve hawx yehg awg khuhn yug ve kae che yaog. I hehd awr lehr, maq gha chaq chiz lehq, Par sar khar pawehd haq gha cad tug, jawd mawd ve hawx yehg awg khuhn maq gehe. ");
INSERT INTO lhi_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kheh te lehq, jawd mawd Pid laq i hehd chehd lo tuhaz lehq, “Chaw che ve phad awg khod-aq nig hehd a thoq vend bax tar kig cawar le,” lehz i hehd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","I hehd kawq koz che, “Chaw che ve phad awr lehr, haeg che haq maq te ver, ngag hehd nawg haq chid aq ax tug ma hez hawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Kheh te lehq, jawd mawd Pid laq koz che, “Nig hehd yawd haq yug lehq, nig hehd awg lid tawd khuhd cawg lar che heh suhx jehr-oq,” lehz i hehd haq koz vid che yaog. Yud daq chaw ve awg hoz awg nax teq pa kawq koz che, “Ngag hehd awr lehr, chaw te ghad-eg haq liz dawz vehr tug a khawag mad cawg,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","I hehd che kheh koz che awr lehr, Yer suq yawd khawd-ehg kheh gha te suh tug ve awg lawn haq koz lar che heh phehaq vid tug awg pun te che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Kheh te lehq jawd mawd Pid laq awr lehr, hawx yehg awg khuhn kawq gehe lehq, Yer suq haq kug yug peg lehq, “Nawg awr lehr Yud daq chaw teq pa ve Jawd mawd yaog la,” lehd koz yawd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yer suq kawq koz che, “Nawg khad nawag duhd tuhaz lehq na ngawx chehd cheawg la. Ma hez ver, ngag ved awg lawn su nawg haq koz ax lar cheawg la,” lehd yawd haq koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jawd mawd Pid laq kawq koz che, “Ngag awr lehr Yud daq chaw phehq che lehq la. Nawg ved chaw ceng he lehq paw khod nux teq pa nawg haq ngag ved laq khuhn chid aq ax vehr che yaog. Nawg a thoq ted ceng haq te yaq cheawg le,” lehd koz na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yer suq kawq koz che, “Ngag ved uq penr tug kand pax awr lehr, mig gig che khod-aq lo ve ma hez. Ngag ved uq penr tug kand pax mig gig che khod-aq lo ve phehq che heh ver, ngag awr lehr Yud daq chaw ve awg hox awg nax teq pa ve laq khuhn maq gha gag tug, ngag ved awg ceg teq pa i hehd haq bawz tug yaog. Kheh ma khuhd, ngag ved uq penr tug kand pax awr lehr, mig gig che khod-aq lo ve ma hez,” lehd koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jawd mawd Pid laq koz che, “Kheh te ver, nawg jawd mawd phehq che yaog la,” lehd koz yawd haq na ngawx che te yand, Yer suq kawq koz che, “Nawg koz che heh, ngag jawd mawd phehq che yaog. Awg cehg mag cawd che ted ceng awg lawn sax khiz khanr tug awg pun ngag pawag lehq mig gig khod-aq lo lag vehr che yaog. Awg cehg mag cawd che ted ceng ve chaw awg gha lia awr lehr, ngag ved tawd khuhd haq na che yaog,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jawd mawd Pid laq koz che, “Awg cehg mag cawd che ted ceng awr lehr, a thoq ted ceng le,” lehz yawd haq na ngawx vid che yaog. Jawd mawd Pid laq che kheh koz peg khaz nuhr, Yud daq chaw ve awg hox awg nax teq pa chehd lar kig huh yawd tuhz kae lehq koz che, “Chaw che ve phad awg khuhn yaq kig haq ngag ca mad mawg. ");
INSERT INTO lhi_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Par sar khar pawehd te che te yand, ngag nig hehd awg pun chaw te ghad haq phehd vid che awg lid cawg che yaog. Kheh te cheaq te lehq, nig hehd awg pun Yud daq chaw teq pa ve Jawd mawd haq ngag phehad tug nig hehd he gad cheawg la,” lehz i hehd haq na ngawx che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","I hehd te pawz kawq kug lehq koz che, “Che phad haq ma hez. Kheh ma khuhd, Bar rar baq haq phehd laoq,” lehd koz che yaog. Bar rar baq awr lehr, muhd mig khuhn chaw phuhz phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Awg yand u ve khuhn jawd mawd Pid laq awr lehr, Yer suq haq yug lehq jawq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Maq yad teq pa awr lehr, a chud te haq yug lehq si ux cuhr heh te ghaq peg lehq, yawd ved a kor haq khuhz vid che yaog. Kheh te peg lehq, awg naz mix-a te che a poq yehg maq yawd haq deh vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Awg yand u ve haq, i hehd yawd chehd lo lag lehq, “Yud daq chaw teq pa ve Jawd mawd-og, nawg awg bon ir vid-oq,” lehd kheha kaod koz gid vid lehq, yawd ved mehz khuhd haq laex pawx tha phehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jawd mawd Pid laq te pawz kawq tuhaz lehq koz che, “Chaw che ve phad awg khuhn lo ngag yaq kig teq chaweh mad mawg che haq nig hehd gha sir tug, ngag yawd haq nig hehd chehd lo sir tuhaz vehr che yaog,” lehz Yud daq chaw ve awg hox awg nax teq pa haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Awg yand u ve khuhn, Yer suq awr lehr a chud ux cuhr haq khuhz lar lehq, awg naz mix-a te che a poq yehg maq haq deh lar lehq tuhaz che yaog. Jawd mawd Pid laq awr lehr, Chaw che ve phad haq ngawx-oq lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Paw khod nux teq pa he lehq bon yehg nux ve maq yad teq pa awr lehr, Yer suq haq gha mawg che te yand, “Yawd haq laq kan thag huh thaq vehr lor, thaq vehr lor,” lehz hax ceh nux kug che yaog. Jawd mawd Pid laq koz che, “Nig hehd khad nig hehd yawd haq yug lehq laq kan thag huh thaq vehr-oq. Awg lawn ghod ver, ngag yawd awg khuhn yaq kig teq chaweh mad mawg,” lehd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yud daq chaw ve awg hox awg nax teq pa kawq koz che, “Ngag hehd awr lehr awg lid tawd khuhd cawg che yaog. Ngag hehd awg lid tawd khuhd cawg chehd che heh te che ver, yawd awr lehr suh kenr che yaog. Awg lawn ghod ver, yawd awr lehr yawd awg ton haq Ghig sa ve Yad phu phehq che yaog lehz yawd koz che yaog.” ");
INSERT INTO lhi_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jawd mawd Pid laq tawd u ve haq gha kad che te yand, lex lehq kawq kuhz jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yawd hawx yehg awg khuhn te pawz kawq gehe lehq, “Nawg khar lo lag cheawg le,” lehd koz Yer suq haq na ngawx che yaog. Kheh liz, Yer suq yawd haq teq chaweh maq yaw khuhq vid. ");
INSERT INTO lhi_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Kheh te lehq jawd mawd Pid laq kawq koz che, “Nawg ngag haq tawd maq yawa tug lehq la. Nawg haq phehad tug lehd ma koz, laq kan thag huh thaq vehr tug lehd ma koz, ngag kand pax cawg che haq nawg maq sir lehq la,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yer suq kawq koz che, Muhd nuh maq lo nawg haq kand pax pid che ma hez ver, nawg ngag awg khod-aq teq chaweh kand pax mad cawg. Kheh te cheaq te lehq, nawg ved laq khuhn ngag haq chid aq ax che chaw te ghad awr lehr, lex lehq nawg haq keh vend bax ir che yaog lehz, yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","U ve te yand haq tanr lehq, jawd mawd Pid laq awr lehr Yer suq haq phehd vid tug awg khad ca che yaog. Kheh ma khuhd Yud daq chaw ve awg hox awg nax teq pa kug lehq koz che, Nawg chaw che ve phad haq phehd vid che ver, nawg jawd mawd nux Kehd sar ve awg chawd phehq che ma hez. A sug yawd awg ton haq jawd mawd te che chaw awg gha lia awr lehr, jawd mawd nux Kehd sar ve cand par phehq che yaog lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kheh te cheaq te lehq, tawd u ve haq jawd mawd Pid laq gha kad che te yand, yawd Yer suq haq sir ve tuhez lehq, suhx jehg suhx taz che kaw jaw thag huh ca mi che yaog. Kaw jaw u ve awr lehr, Ar rar miq khuhd Gar bar taq lehd koz che, huhx meh khuhd lar che awg ti ted kag huh cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Awg ni u ve awr lehr, Par sar khar pawehd te tug awg pun ghu che awg ni phehq lehq, awg yand awr lehr muhd kaw cuhaz che te yand cawd che yaog. Jawd mawd Pid laq awr lehr, Yud daq chaw ve awg hox awg nax teq pa haq koz vid che, “Nig hehd ve Jawd mawd haq ngawx lor.” ");
INSERT INTO lhi_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","I hehd koz che, “Yawd haq dawz vehr lor, dawz vehr lor. Laq kan thag huh thaq vehr lor,” lehz hax ceh nux kug che yaog. Jawd mawd Pid laq koz che, “Nig hehd ve Jawd mawd haq laq kan thag huh ngag gha thaq vehr tuawg la,” lehz i hehd haq na ngawx che te yand, “Kehd sar ma hez ver, ngag hehd jawd mawd nux mad cawg,” lehz paw khod nux teq pa kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Awg yand u ve haq, Yer suq haq laq kan thag huh thaq vehr tug, jawd mawd Pid laq awr lehr i hehd ve laq kuhr awg khuhn chid aq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Kheh te cheaq te lehq, i hehd Yer suq haq yug lehq yawd haq sir ve tuhez che yaog. Yawd awr lehr yawd ved laq kan haq taz lehq, a kor ghuhd lehd koz che awg ti huh kae che yaog. Awg ti u ve awr lehr Ar rar miq khuhd ver, Gawd laq gawd taq meh che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","U huh i hehd yawd haq laq kan thag huh thaq ke lar che yaog. Kheh te lehq, yawd geh teq geha awg kag awr ve chaw ni ghad haq liz, te phawd awr lo te ghad laq kan thag huh thaq ke lar lehq, Yer suq haq awg kaw jen huh thaq ke vid lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jawd mawd Pid laq awr lehr, liq buhq lehq Yer suq ve laq kan thag huh nehx lar che yaog. Liq u ve awr lehr, “Yud daq chaw teq pa ve Jawd mawd Nar sar rehq chaw Yer suq yaog,” lehd koz buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yer suq haq laq kan thag huh thaq vehr vid kig awr lehr, med haq ned cheaq te lehq, Yud daq chaw kha peh vad-ag liq u ve haq ghawn che yaog. Liq u ve awr lehr, Ar rar miq liq, Rod maq liq he lehq Her lar saq liq te buhq lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kheh te cheaq te lehq, Yud daq chaw teq pa ve paw khod nux teq pa awr lehr, jawd mawd Pid laq haq koz vid che, “‘Yud daq chaw teq pa ve Jawd mawd yaog,’ lehd koz tad buhq. ‘Ngag awr lehr Yud daq chaw teq pa ve Jawd mawd yaog lehz che phad yawd koz che yaog,’ lehd koz buhq-oq.” ");
INSERT INTO lhi_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Jawd mawd Pid laq awr lehr, “Ngag buhq lar che haq ngag mad kawq ghu buhq-oq,” lehd i hehd haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Maq yad teq pa awr lehr, Yer suq haq laq kan thag huh thaq ke lar peg khaz nuhr, yawd ved beg ke haq yug lehq uhd pun pehg lehq, te ghad teq pun yug che yaog. Awg khuhn ve a poq yehg maq haq liz i hehd yug che yaog. Kheh ma khuhd, a poq u ve awr lehr, a poq kuhr biz mad cawg. Kuhr tag haq tanr lehq a poq mehr mend lo kha gag te chid lar che a poq phehq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Kheh te cheaq te lehq i hehd koz che, “A poq che haq a nig mad juhq khod lehq, a sug gha cawd che haq sir tug nar bar kehx yug yuag veg lehd,” koz te ghad he lehq te ghad koz daq che yaog. I hehd che kheh te che awr lehr, “Ngag ved beg ke haq i hehd pehg yug lehq, ngag ved a poq haq liz i hehd nar bar kehx yug che yaog,” lehd koz Liq phu khuhn buhq lar che tawd khuhd haq phehaq vid tug awg pun te che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Yer suq ve laq kan pad huh yawd ved awr ye, awr ye ve awg nax ma, Kar lawd phaq ve awg mid ma Mar riq he lehq Mar riq Mar gar dar laq teq pa hox chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yer suq awr lehr, yawd ved awr ye he lehq yawd haq che awg laq ghuhd yawd awg pad huh hox chehd che haq gha mawg che te yand, yawd ved awr ye haq yawd koz vid che, “Yad mid-og, nawg ved yad par haq ngawx-oq,” lehd koz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Awg laq ghuhd u ve te ghad haq liz, “Nawr ye haq ngawx-oq,” lehd koz vid che yaog. Awg yand u ve haq tanr lehq, awg laq ghuhd u ve te ghad awr lehr, yawd ved yehg khuhn lo Yer suq ve awr ye haq sir ve chehd vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","U ve awg khaz nuhr, kanx awg gha lia a meha te peg vehr che haq Yer suq sir lehq, “Ngag a kaz sex che yaog,” lehz yawd koz che yaog. Yawd u kheh koz che awr lehr, Liq phu tawd khuhd awg khuhn koz lar che heh phehaq vid tug awg pun yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","U huh ce che a pehx med ghig kha peh cawg che mawq khu ted mag cawg che yaog. I hehd awr lehr, lad chuhd ghig khuhn cawg che muhg ted mag haq yug lehq ce che a pehx med ghig awg khuhn tiz ke peg lehq, pund tag haq choz lehq yawd ved mawq kaw haq chid duhq vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yer suq awr lehr, ce che a pehx med ghig u ve haq chuhq dawg peg lehq, Peg vehr che yaog lehd koz lehq, a kor kuhq ghad te peg lehq sax chez che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","U ve teq ni awr lehr, pawehd awg pun ghu che awg ni phehq lehq, awg khaz nuhr teq ni ver, ir jad che Sa ba to awg ni phehq cheaq te lehq, Sa ba to awg ni teq ni awg khuhn laq kan thag huh suh chehd che awg ton teq pa maq gha teh lar haz tug, Yud daq chaw ve awg hox awg nax teq pa awr lehr jawd mawd Pid laq chehd lo kae lehq, chaw u ve teq pa har naq suh vid tug i hehd ve khi kud haq dawz theh lehq, suh vehr che awg ton u ve teq pa haq yug kha tug, yawd haq lawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kheh te lehq, maq yad teq pa lag lehq, Yer suq geh teq geha laq kan thag huh thaq ke lar che chaw ni ghad ve khi kud haq dawz theh vehr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kheh ma khuhd, i hehd Yer suq chehd lo lag gag che te yand, yawd suh vehr che haq gha mawg cheaq te lehq, yawd ved khi kud haq i hehd ma dawz theh vid. ");
INSERT INTO lhi_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kheh liz, maq yad te ghad yawd ved ned kud phawd awr haq a gehd thaq lehq, awg suhr he lehq a kaz te pawaz lehax dong tuhaz che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nig hehd liz gha yonr tug, u ve haq gha mawg che chaw te ghad sax khiz khanr che yaog. Yawd sax khiz khanr che awr lehr awg cehg mag cawd che yaog. Yawd koz che tawd khuhd awr lehr, awg cehg mag cawd che yaog lehz yawd sir che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Awg ceng che ve teq pa u kheh phehaq che awr lehr, “Yawd ved awg ghuhd ted mag-a liz maq gha dawz theh,” lehz Liq phu khuhn buhq lar che tawd khuhd haq phehaq vid tug awg pun te lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kheh te lehq, Liq phu awg khuhn awg kag awr ve ted kag koz lar che, “I hehd thaq pawnr lar che te ghad haq i hehd ngawx tug yaog,” lehd koz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","U ve awg khaz nuhr, Ar riz mar thehr med yad Yod sehq awr lehr, Yer suq ve awg ton haq gha yug kae tug jawd mawd Pid laq chehd lo ca lawg che yaog. Kheh te lehq, jawd mawd Pid laq yawd haq a khawag pid che yaog. Kheh te cheaq te lehq yawd lag lehq, Yer suq ve awg ton haq yug kae che yaog. Yod sehq u ve te ghad awr lehr, Yer suq ve awg laq ghuhd phehq che liz, Yud daq chaw ve awg hox awg nax teq pa haq kuhz cheaq te lehq, awg laq ghuhd phehq che yaog lehz su haq maq sir cuh. ");
INSERT INTO lhi_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pong lag thad Yer suq chehd lo muhd khax te khend huh lag che Niq kawd der te ghad liz lag che yaog. Yawd awr lehr, mud rar he lehq a cawr khuhq huhz daq lar che, sehz chi uhd kid lod kheh taw yug veha lag che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ix mag awr lehr, Yer suq ve awg ton haq yug lehq, Yud daq chaw teq pa ve chaw tur che awg lid cawg che heh, san huhx teq pa haq ke lehq, pha phua yug thiz lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yawd haq laq kan thag huh thaq vehr kig huh, kho teq kho cawg che yaog. Kho u ve awg khuhn chaw te ghad-eg haq liz maq tur jaw ser che tur phuh awg suhx ted mag cawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","U ve teq ni awr lehr, Yud daq chaw teq pa ve pawehd awg pun ghu che awg ni phehq lehq, tur phuh u ve liz awg pad huh cawg cheaq te lehq, ix mag yawd haq u huh ca tur lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Suhr ni awg khuhn awg kawd maq teq ni, muhd ma thid ser huh, Mar riq Mar gar dar laq awr lehr ted naq tur phuh huh kae lehq, tur phuh awg khod med huh chuhd lar che huhx meh dig phuhz kha lar che haq gha mawg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kheh te lehq Sid monr Per troq he lehq Yer suq haq che awg kag awr ve awg laq ghuhd te ghad chehd huh yawd cex lag lehq koz che, “Tur phuh awg khuhn Jawd mawd Yer suq haq su yug tuhz ve lehq, yawd haq khar lo ca teh lar lehq nar ngag hehd maq sir,” lehz ix mag haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Kheh te cheaq te lehq, Per troq he lehq awg kag awr ve awg laq ghuhd u ve te ghad tuhez lehq tur phuh huh kae che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ix mag teq geha cex kae che te yand, awg laq ghuhd u ve te ghad awr lehr Per troq haq keh cex gehg lehq, tur phuh lo yawd awg kawd gaeg che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tur phuh awg khuhn lo yawd kawq suhx ngawx lehq, pha phua u huh teh lar che haq gha mawg che yaog. Kheh ma khuhd tur phuh awg khuhn yawd maq gehe. ");
INSERT INTO lhi_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yawd khaz nuhr ghaq cex lag tod che Sid monr Per troq lag gag lehq, tur phuh awg khuhn gehe che yaog. Gehe che te yand, pha phua teh ax lar che haq lehd ma koz, ");
INSERT INTO lhi_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","a kor haq beh che phar ceq haq lehd ma koz, yawd gha mawg che yaog. Phar ceq u ve pha phu geh teq geha maq teh lar lehq, awg kag awr ve ted kag lo loq teh lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Awg yand u ve haq, tur phuh lo awg kawd maq gag che, awg kag awr ve awg laq ghuhd u ve te ghad liz tur phu khuhn gehe lehq gha mawg cheaq te lehq yonr che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Awg lawn ghod ver, Yer suq suh kig lo gha kawq teq tuag che yaog lehz Liq phu khuhn koz lar che haq ix mag maq sir ser. ");
INSERT INTO lhi_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Awg yand u ve haq, awg laq ghuhd u ve ni ghad awr lehr, a sug yawd ved yehg lo kawq koeq che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kheh ma khuhd, Mar riq awr lehr tur phuh awg pad huh hox lar lehq huhg chehd che yaog. Yawd huhg chehd-ag huh, tur phuh khuhn kawq suhx ngawx lehq, ");
INSERT INTO lhi_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","phux-u ghad te che a poq veq deh lar che muhd nuh maq cuh yad ni ghad haq gha mawg che yaog. Ix mag awr lehr, Yer suq ve awg ton teh lar kig a kor phawd awr te ghad, khi mehr mi phawd awr te ghad mi chehd che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ix mag awr lehr, “Yad mid-og, a thoq te huhg chehd cheawg le,” lehz,yawd haq na ngawx che te yand yawd kawq koz che, “Ngag ved Awg jawd mawd haq su yug ve lehq, khar lo ca teh lar lehq nar ngag maq sir cheaq te lehq huhg chehd che yaog,” lehz ix mag haq kawq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Yawd u kheh koz peg lehq kuhr tehx nuhr phawd awr phuhz ngawx che te yand, Yer suq hox chehd che haq gha mawg che yaog. Kheh liz, Yer suq yaog lehz yawd maq sir. ");
INSERT INTO lhi_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yer suq koz che, “Yad mid-og, a thoq te huhg chehd cheawg le. Nawg a sug haq ca cheawg le,” lehz yawd haq na ngawx che yaog. Mar riq awr lehr, yawd haq kho haq sax sehr phad lehq gha hawg lehd duhd lehq koz che, “A vix var-og, nawg yawd haq yug ve ver, khar lo teh lar che haq ngag haq a cehax koz ax laoq. Ngag yawd haq ca yug khuheq tug yaog,” lehz yawd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yer suq awr lehr, “Mar riq-og,” lehz yawd haq koz vid che yaog. Mar riq phuhz ngawx lehq, “Rar bud niq-og,” lehd koz, Ar rar miq khuhd yaw lehq koz vid che yaog. (Rar bud niq lehd koz che awr lehr sar lar haq koz che yaog.) ");
INSERT INTO lhi_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yer suq koz che, “Ngag haq ta vad. Awg lawn ghod ver, Awr pa geh ngag maq gha taez ser. Ngag ved a vix a nax teq pa chehd lo kae lehq che kheh koz vid-oq. Ngag ved Awr pa he lehq nig hehd ve Awr pa, ngag ved Ghig sa he lehq nig hehd ve Ghig sa chehd lo ngag taez tug yaog,” lehz Mar riq haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mar riq Mar gar dar laq kae lehq, “Ngag Jawd mawd Yer suq haq gha mawg vehr che yaog,” lehz awg laq ghuhd teq pa haq koz vid che yaog. Kheh te lehq, Yer suq yawd haq koz ax che awg lawn teq pa liz, yawd i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Suhr ni awg khuhn awg kawd maq teq ni Yer suq kawq teq tuag che teq ni muhd phiq huh, awg laq ghuhd teq pa phawng daq chehd che yaog. I hehd awr lehr, Yud daq chaw ve awg hox awg nax teq pa haq kuhz cheaq te lehq ghaz mir teq pa liz hoz lar che yaog. Awg yand u ve khuhn Yer suq lag lehq i hehd awg kaw jen huh hox lar lehq, “Nig hehd geh duhd sa gad sa tug cawg vid-oq,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yawd che kheh koz peg lehq, yawd ved laq kuhr he lehq yawd ved ned kud phawd awr i hehd haq maw vid che yaog. Kheh te lehq, awg laq ghuhd teq pa awr lehr, Jawd mawd Yer suq haq gha mawg che te yand, ha lehg jad che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yer suq te pawz kawq koz che, “Nig hehd geh duhd sa gad sa tug cawg vid-oq. Awr pa ngag haq peha lar che heh, ngag liz nig hehd haq kae pe che yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yawd che kheh koz peg lehq, i hehd awg thag lo awg sax mez pe lehq koz che, “Daq che kehg che Awg ha phu haq haq yur-oq. ");
INSERT INTO lhi_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","A sug te ghad ve vend bax haq nig hehd phehd kha ver, vend bax phehd kha che haq yawd gha tug yaog. A sug te ghad ve vend bax haq nig hehd ma phehd vid ver, yawd ved vend bax cawg chehd tug yaog,” lehz i hehd haq koz vid che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yer suq i hehd chehd lo lag thad, cuh yad teq chi ni ghad awg khuhn lo Yad ceh ka lehd koz che Thod maq te ghad awr lehr, i hehd geh ma chehd lar che yaog. ");
INSERT INTO lhi_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kheh te cheaq te lehq, awg kag awr ve awg laq ghuhd teq pa awr lehr, “Jawd mawd Yer suq haq ngag hehd gha mawg vehor,” lehz yawd haq koz vid che yaog. Kh