﻿USE sofia;
DROP TABLE IF EXISTS sofia.lgl_vpl;
CREATE TABLE lgl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lgl_vpl WRITE;
INSERT INTO lgl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Isuuna sulia Jesus 'a Christ. 'I lia 'e futa ala David walelitalona, wale 'e futa ala kwalofa Abraham li. ");
INSERT INTO lgl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ma isuuna 'e, 'e fuli'ae ala Abraham. Wela Abraham Aesak, Aesak 'e alua Jakob, ma Jakob ka alua Juda failia walefae lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ma wela Juda gi Peres failia Sera. (Teite daroa ratala Tama.) Ma wela Peres Hesron, Hesron ka alua Ram. ");
INSERT INTO lgl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ka alua Aminadab, Aminadab ka alua Nason, Nason ka alua Salmon. ");
INSERT INTO lgl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ka alua Boas, ma teite lia ratala Rahab. Boas ka alua Obed, teite lia ratala Rut. Obed ka alua Jesi. ");
INSERT INTO lgl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi ka alua David walelitalona 'i Israel. David ka alua Solomon, teite lia 'orula ke wale Iuraea ");
INSERT INTO lgl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ka alua Rihoboam, Rihoboam ka alua Abaeja, Abaeja ka alua Asa. ");
INSERT INTO lgl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ka alua Jehosafat, Jehosafat ka alua Joram, Joram ka alua Iusaea. ");
INSERT INTO lgl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Iusaea ka alua Jotam, Jotam ka alua Ehas, Ehas ka alua Hesikaea. ");
INSERT INTO lgl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesikaea ka alua Manase, Manase ka alua Emon, Emon ka alua Josaea. ");
INSERT INTO lgl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaea ka alua Jekonaea failia ai 'i burila gi. Gera futa ka sui lo malimae gera gi ka bi sakea ioli 'i Israel gi fala falua baela 'i Babilon. ");
INSERT INTO lgl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","'I burila malimae gera gi gera sakea ioli 'i Israel gi fala 'i Babilon, Jekonaea ka bi alua Sialtiel. Ma Sialtiel ka alua Serababel. ");
INSERT INTO lgl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel ka alua Abaeud, Abaeud ka alua Elaeakim, Elaeakim ka alua Aso. ");
INSERT INTO lgl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aso ka alua Sadok, Sadok ka alua Akim, Akim ka alua Eliud. ");
INSERT INTO lgl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud ka alua Elaesa, Elaesa ka alua Matan, Matan ka alua Jakob. ");
INSERT INTO lgl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob ka alua Josef arai Mary teite Jesus lia gera soia lou 'alia Christ, sulia 'i lia lo wale God 'e filia fala walelitalona li. ");
INSERT INTO lgl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Fuli'ae mae ala Abraham la la ka dao ala David walelitalona, akwala wala fai ului ioli. Sui ka fuli'ae ala David walelitalona la la ka li dao ala talasi ba malimae gera gi gera sakea ioli 'i Israel gi fala 'i Babilon, na akwala wala fai ului ioli lou. Ma ka fuli'ae ala talasi ioli Israel gi gera la fala 'i Babilon la la ka dao ala talasi Jesus Christ 'e futa ai, na akwala wala fai ului ioli lou. ");
INSERT INTO lgl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Futanala Jesus Christ 'e 'uri 'e: Talasi gera alu fafia Mary teite Jesus 'ala Josef, ma iko 'ali daro io ruru 'ua, Mary ka saiai 'e dodolanaa lo ala Aloe 'are Abu. ");
INSERT INTO lgl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma Josef, wale 'e gera alu fafia 'alaa, 'e malata 'ali ma ka lugasia, sulia 'i lia wale rada. Wasua ma iko 'ali 'e oogaa faa'ekenala 'i maala afulana, ma ka malata 'ali ma ka lugatae agwaagwa mola ala. ");
INSERT INTO lgl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wasua ma talasi kae malata mola 'ua 'ala sulia me 'are fo gi li, eniselo God ka fatae fala 'i laola mo'osu bole na ma ka sae 'uri 'e, “Josef 'i'o wale ala kwalofa David li, ikoso mau 'alia tolenala Mary 'ali rau 'alia wateu 'o. Sulia 'e dodolanaa ala Aloe 'are Abu. ");
INSERT INTO lgl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma 'i lia kae faafutaa te wela wale, ma koe fafurataa 'alia Jesus (fadanai ‘Walelifaamauri’), sulia 'i lia kae faamauria ioli lia gi faasia ta'ana gera gi.” ");
INSERT INTO lgl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma 'are 'e gi kae fuli 'ali fakwalaimokia 'are ba God 'e faarono mae 'alida, ala talasi ba profet lia 'e sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Te ulao 'auabua kae dodolanaa ma kae faafutaa te wela wale, ma gera kae soia 'alia Emanuel.” Ma fadanala ratae 'are fo 'e 'uri 'e: “God 'e io fae gia.” ");
INSERT INTO lgl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ma talasi Josef 'e ada ai, ka tau lo sulia 'are fo eniselo fo God 'e ilida fala gi. Ma ka tolea lo Mary. ");
INSERT INTO lgl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wasua ma iko 'ali daro teo ruru 'ua la la ka dao ala talasi Mary 'e faafutaa wela wale fo li. Ma Josef ka fafurata 'alia Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ala talasi Herod 'e walelitalona ai, Jesus ka futa 'i Betlehem, te maefalua 'i laola provins 'i Judea. Iko 'ali tekwa mola 'i burila, nali wale faasia 'i tataenala da'afi, wale gera saiala lio raeanala kwalikwali gi li, gera ka dao mae 'i laola falua ba'ela 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma gera ka soilidi 'uri 'e ala ioli gi, “'Uri'e ma wela ba kae walelitalona 'ala Jiu gi li 'e futa 'i fe? Meulu saiai 'e futa 'i lifi'e, sulia talasi meulu io 'ua mae 'i tataenala da'afi li, meulu ka lesia lo fe kwalikwali 'e fatailia futanala, ma meulu ka la lo mae 'ali meulu boururu, ma meulu ka faa aofia.” ");
INSERT INTO lgl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma malatala Herod walelitalona 'e malata mara'ebi'ebi rasua talasi 'e rono sulia me 'are fo li, failia ioli 'i Jerusalem gi lou. ");
INSERT INTO lgl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma ka soia fata abu ba'ela gi, failia waleli falalauna ala taki gi li, 'ali gera logo ma ka soilidi 'uri 'e ada, “'Uri'e ma 'i fe lo Christ kae futa ai?” ");
INSERT INTO lgl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma gera ka olisi 'uri 'e ala, “'I Betlehem ba, falua 'i laola provins 'i Judea. Sulia geregerena ba profet li 'e sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem, falua 'i laola provins 'i Judea, Iko 'ali 'o wawade 'i safitala falua 'ilitoa 'i Judea gi, sulia te wale 'ilitoa kae la mae faasia 'i'o, 'ali kae talaia ioli lau gi 'i Israel.’” ");
INSERT INTO lgl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ma Herod ka faisoi agwaagwa fala wale fo gera dao mae faasia tataenala da'afi li gi li fala alaa raefuli na, 'ali ma ka daria talasi ta lo daulu etae lesia fe kwalikwali fo ai. ");
INSERT INTO lgl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma ka keri daulu fala 'i Betlehem, ka sae 'uri 'e, “Moulu la, Moulu ka lio 'oka 'afia wela 'e. Ma ala moulu ka daria, moulu ka faarono lau mae, 'ali lau wasua lakae la lou ko fala faa aofia nala.” ");
INSERT INTO lgl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","'I burila Herod 'e sae 'urifo ka sui, daulu ka la lo 'adaulu. Talasi daulu li dao lo 'i sulia tala li, daulu ka lesia lou fe kwalikwali ba daulu etae lelesia lo mae 'i tataenala da'afi li. Daulu ka babalafe rasua ala talasi daulu lesia lou. Ma fe kwalikwali fo ka eta 'i lao adaulu la la ka dau fafia lifi la Jesus 'e teo ai. ");
INSERT INTO lgl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Daulu ruu 'i luma, ma daulu ka lesia welaa failia teite lia Mary. Daulu ka boururu daulu ka faa aofia lo wela fo, ma daulu ka tafalia wai daulu gi, ma daulu ka kwatea lo kwatena liunali 'e ba'ela gi fala: goulu, failia 'are la rasula 'e si'ina 'oka, ma waiwai si'ina fofo 'oka gi. ");
INSERT INTO lgl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sui daulu ka oli lo 'adaulu sulia na tala mamata fala falua daulu, sulia God 'e lui nasi adaulu 'i laola mo'osu bole na, ma ka ilia ikoso 'ali daulu oli lou 'i so'ela Herod. ");
INSERT INTO lgl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","'I burila wale fo gi daulu oli lo fala falua daulu, eniselo God ka fatae fala Josef 'i laola mo'osu bole na, ma ka sae 'uri 'e, “Josef 'o tatae, ko sakea wela 'e failia teite lia, moulu ka tafi fala 'i Ejipt, ma moulu ka io 'i lifila la la ka dao ala talasi lakae ilia moulu ka oli lou mae ai. Sulia Herod kae lio 'afia wela 'e 'ali 'e raunia.” ");
INSERT INTO lgl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ma Josef ka tatae, ka sakea wela failia teite lia Mary, ma daulu ka la lo 'i laola fe boni fo fala falua 'i Ejipt. ");
INSERT INTO lgl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma daulu ka io 'i lififo la la Herod ka mae. Ma me 'are fo ka fakwalaimokia lo me saena ba God 'e ilia fala te profet ba ka gerea 'uri 'e, “Lakae soia mae wela lau faasia 'i Ejipt.” ");
INSERT INTO lgl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ma talasi Herod walelitalona 'e sailoai wale fo gera la mae faasia tataenala da'afi li gi li gera kotofia, ogala ka ta'a rasua. Ma ka kwatea saenala fala waleli ofona afula lia gi 'ali gera raunia sui ke wela wale 'i Betlehem gi failia mae falua galia gi. 'E bokerida 'ali gera raunia ke wela wale fo iko 'ali gera dao 'ua ala ta rua fe nali 'ada gi, malaa lo alaana ba wale ba gi gera taua sulia talasi ba fe kwalikwali ba 'e etae fatae ai. ");
INSERT INTO lgl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'E 'urifo ioli 'i Betlehem gi, gera ka anisia wela fo gera 'e mae gi. Gera ani 'urifo, malaa ba Jeremaea te profet ba 'e ilia lo mae 'i lao, ");
INSERT INTO lgl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Gera ronoa line anina fo 'e talulu mae faasia falua 'i Rama line gala ba'ela. Rachel kae anisia wela lia gi. Talasi 'e ani, iko ta ioli 'ali sai ala gwafenala sulia wela lia gi gera mae sui.” ");
INSERT INTO lgl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","'I burila Herod 'e mae lo, eniselo God ka fatae lou 'i laola mo'osu bole na fala Josef 'i Ejipt, ");
INSERT INTO lgl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ma ka sae 'uri 'e, “Josef 'o tatae, ko sakea lo wela failia teite lia Mary, moulu ka oli lo fala 'i Israel, sulia ioli ba gera kae tau fala rauninala wela 'e li, gera mae lo.” ");
INSERT INTO lgl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma Josef ka tatae, ka sakea lo wela failia teite lia Mary, ma daulu ka oli lo fala 'i Israel. ");
INSERT INTO lgl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wasua ma talasi Josef 'e ronoa Akilas 'e walelitalona 'i fulila mama lia Herod 'i Judea, ka mau 'alia iona 'i lififo li. Ma eniselo ka ilia lou fala 'i laola mo'osu bolena, 'ali daulu la fala provins 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Lia fo daulu ka io ala falua 'i Nasareti 'i laola provins 'i Galili. Ma ka fakwalaimokia lo me 'are ba profet gi gera alaa 'uri 'e sulia, “Gera kae soia 'alia wale 'i Nasareti.” ");
INSERT INTO lgl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma barae fe nali 'i burila, talasi Jesus 'e ba'ela lo, John wale fasiuabu ka dao mae, ma ka fuli'aea lo faalalauna 'i laola abae lifi kwasi 'i Judea, ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“'Amu bulusi faasia abulona ta'ana 'amiu gi, sulia talasi God kae 'ilitoa fafia ioli lia gi li 'e garani dao lo.” ");
INSERT INTO lgl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","John ba wale ba profet Aesea 'e sae 'uri 'e sulia, “Te wale 'e rii 'i laola abae lifi kwasi la iko 'ali totolia ta ioli 'ali io ai. Ma ka sae 'uri 'e, ‘Aofia kae dao lo mae! 'Amu farada lo tala fala!’” ");
INSERT INTO lgl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John 'e toro 'alia sunasunala kamel, ma ka firia 'i abalola 'alia sunasunala buluka. Ma fana lia fo siisii failia ninidua kwasi. ");
INSERT INTO lgl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ma ioli afula gera la mae 'i so'ela faasia falua 'i Jerusalem, failia falua 'i laola provins 'i Judea gi sui, ma faasia falua garania kwai 'i Jodan gi. ");
INSERT INTO lgl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma gera ka tafanailia ta'ana gera gi, ma 'i lia ka fasiuabu gera 'i laola kwai 'i Jodan. ");
INSERT INTO lgl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma talasi John 'e lesia ioli afula ala Farasi gi failia Sadusi gi gera la lou mae 'i so'ela 'uri 'ali lia ka fasiu abu gera, lia ka sae 'uri 'e fada, “'Amu malaa mola 'amiu kalela waa gi! Ite 'e fabasu 'amiu 'ali 'amu tafi faasia kwaikwaina God? ");
INSERT INTO lgl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","'Amu taua 'are kae fatailia 'amu bulusi lo faasia ta'ana 'amiu gi li. ");
INSERT INTO lgl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma ikoso 'ali 'amu malata 'uri 'e 'i laola malatamiu, ‘'I 'amami ioli 'ami futa lo mae ala kwalofa Abraham gi. 'Ato 'ali ta kwaikwaina faasia God ka dao amaami.’ Ma lakae ili rada ai famiu, 'e talawarau mola 'ala fala God 'ali sakea tali me fau ala fau 'e gi, ma ka raunailia 'alia kwalofa Abraham gi! ");
INSERT INTO lgl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ala talasi 'e, God 'e rerei lo 'alia kwaikwaina, malaa na ioli 'e dau ala kwaikwai, ma ka rerei fala tofunala 'ai gi. Ma 'ai iko 'ali gera funu 'alia ta fuae 'ai 'oka gi li, 'i lia kae tofuda ma kae tasida 'i laola dunaa. ");
INSERT INTO lgl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Lau fasiu abu 'amiu 'alia kwai 'ali fatailia lia 'e 'amu bulusi lo faasia abulo ta'ana 'amiu gi. Wasua ma te wale kae la mae 'i burigu, lia kae fasiu abu 'amiu 'alia Aloe 'are Abu failia dunaa. Ma 'e 'ilitoa ka liufi lau, ma iko 'ali lau totolia sakenala 'ae botu lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","'E rerei lo fala sofilina 'i matanala ioli gi sui, ka malaa te wale 'e kefoa fuae 'ai 'oka faasia tete 'are gi li. Ma ka logosia fufuae 'are 'oka gi 'i laola luma li goli 'arena. Ma ka 'agofia lo tete 'are gi 'i laola dunaa la kae 'ago firi.” ");
INSERT INTO lgl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ala talasi fo, Jesus ka la mae faasia provins 'i Galili fala kwai 'i Jodan 'i so'ela John 'ali John ka fasiuabua. ");
INSERT INTO lgl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ma John ka maili tonala olisinala malatala Jesus ka sae, 'uri 'e, “'E totolia 'i'o tae ko fasiu abu lau, ma 'o la mae 'amua 'i soegu 'ali lau fasiu abu 'o.” ");
INSERT INTO lgl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma Jesus ka olisi 'uri 'e ala, “Wasua ka 'urila 'ala, ko taua lo 'amua fagu, sulia ala taunai, gora tau lo sulia liola God.” Ma John ka ala fafia. ");
INSERT INTO lgl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Talasi Jesus 'e siu abu ka sui lo, ka tatae mae faasia kwai ma 'i nali ka tafa fala, ma ka lesia Aloe 'are Abu God ka sifo mae malaa na fe bola, ma ka 'o'o fafia. ");
INSERT INTO lgl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma te line 'are 'e talulu mae faasia 'i nali ma ka sae 'uri 'e, “Lia 'e lo moutae wela lau, lau kwaima rasua ala, ma lau babalafe rasua 'alia.” ");
INSERT INTO lgl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","'I burila me 'are fo, Aloe 'are Abu ka talaia lo Jesus fala abae lifi kwasi 'alia Saetan ka mailitonala. ");
INSERT INTO lgl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma Jesus ka abu fana sulia fai akwalae fe atoa gi, ma fai akwalae fe boni gi, ma ka fiolo rasua lo. ");
INSERT INTO lgl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Sui, Saetan ka la mae 'i so'ela, ma ka sae 'uri 'e, “Ala 'i'o Wela God, 'o sae fala me fau 'e gi 'ali gera rau 'ali tali berete.” ");
INSERT INTO lgl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma Jesus ka olisi 'uri 'e ala, “Geregerena Abu 'e ilia, ‘Ioli ikoso 'ali mauri mola 'alia fana talifilia. Ma 'e mauri 'alia saena 'e laa mae faasia God gi sui.’” ");
INSERT INTO lgl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sui Saetan ka talaia lou Jesus fala falua abu 'i Jerusalem, ma ka fa uraa ala te lifi la 'e rae rasua 'i nali, fofola Luma Abu God. ");
INSERT INTO lgl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma ka sae 'uri 'e fala, “Ala 'i'o Wela God, 'o 'aru fala 'i fua faasia 'i lifi'e, sulia Geregerena Abu ba sae 'uri 'e, ‘God kae kwatea mae eniselo lia gi famu, 'ali gera dau rarala amu, 'alia 'aemu wasua ikoso foto ala ta me fau.’” ");
INSERT INTO lgl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma Jesus ka olisi 'uri 'e ala, “Ma Geregerena Abu ba sae lou 'uri 'e, ‘Ko ala mailina tonala God 'o li.’” ");
INSERT INTO lgl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sui Saetan ka talaia lou Jesus fala gwaula fe uo 'e rae rasua, ma ka fatailia tatalona gi sui ala molagali failia sinosino na gera gi fala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma Saetan ka sae 'uri 'e, “'Are 'e gi sui lau kae kwateda famu, ala ko boururu 'i maala 'aegu, ma ko faa aofia lau.” ");
INSERT INTO lgl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma Jesus ka olisi 'uri 'e ala, “Saetan, 'o la tatau ko faasia lau! Sulia Geregerena Abu ba 'e ilia, ‘Talifilia God 'o mola koe faa aofia, ma koe galo fala.’” ");
INSERT INTO lgl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sui ala talasi fo, Saetan ka la lo faasia Jesus. Ma eniselo gi gera ka la mae, ma geraka kwairanai lo ala. ");
INSERT INTO lgl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Talasi Jesus 'e ronoa gera alua lo John 'i laola raraa li, 'i lia ka oli fala provins 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma iko 'ali 'e io 'i laola falua lia 'i Nasareti. 'E la ka io 'ala 'i Kapaneam, falua 'i rabela 'osi 'i Galili, ala gulae tolo 'i Sebulun failia 'i Naftali. ");
INSERT INTO lgl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","'E tau 'urifo 'uri 'ali ma ka fakwalaimokia saenala profet Aesea ba 'e sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Falua 'i Sebulun failia falua 'i Naftali, daro io 'i laola provins 'i Galili, ma daro ka io sulia tala fala 'osi ba'ela li, ma daro ka io sulia kwai 'i Jodan, gula la ioli iko lou Jiu gi li gera io ai. ");
INSERT INTO lgl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ioli la gi, gera io 'i laola maerodo, gerakae lesia madakwana ba'ela. Ma nalife ioli gera io 'i laola falua gogolafana ala maena li 'e 'afu fafida, madakwana kae tala 'afui gera.” ");
INSERT INTO lgl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Fuli ala talasi fo, Jesus ka faarono 'alia faronona 'oka lia 'uri 'e, “'Amu bulusi faasia abulona ta'ana 'amiu gi, sulia talasi God kae 'ilitoa fafia ioli lia gi li 'e dao garani 'amiu lo!” ");
INSERT INTO lgl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ala talasi Jesus 'e liu sulia 'osi 'i Galili, ka lesia Simon (lia 'e soia lou 'alia Peter) failia Andrew walefae lia. 'I daroa rua walelikwaiasina gi. Daro kae kwaiasi 'adaroa 'alia fuo daroa 'i laola 'osi 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma Jesus ka sae 'uri 'e fadaroa, “Mora dona lau mae, 'ali lau falalau 'amoroa 'alia kwaiasina 'afia ioli li fala sakenada mae 'i soegu.” ");
INSERT INTO lgl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ala me talasi fo mola lo, daro ka tafisia lo fuo daroa gi, ma daro ka dona buria lo. ");
INSERT INTO lgl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sui Jesus ka la lou ko, ma ka lesia lou na rua wale, James failia John rua wela Sebedi gi. Daro io 'adaroa 'i laola baru failia mama daroa Sebedi, ma daulu kae raumia fuo daulu gi. Ma Jesus ka soi daroa. ");
INSERT INTO lgl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ala me talasi fo mola lou, daro ka tafisia lo 'adaroa baru failia mama daroa, ma daro ka donaa lo Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus ka liufia lo falua 'i laola provins 'i Galili gi li, ma ka falalaua ioli gi 'i laola luma fala foana 'ala Jiu gi li. Ma ka faarono 'alia Faronona 'Oka sulia 'Ilitoanala God, ma ka guraa ioli gera matai 'alia mataina mamata gi li sui. ");
INSERT INTO lgl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma alaana sulia Jesus ka talo 'i laola falua gi sui 'i laola provins 'i Siria, ma ioli afula gera matai 'alia mataina mamata gi li sui, gera sakeda mae 'i so'ela. Ioli rabeda 'e fii rasua gi, ma ioli aloe 'are ta'a gi ka too ada gi, ma ioli malu ka tauda gi, ma ioli 'aeda ka mae gi, gera la mae 'i so'ela. Ma Jesus ka gurada sui. ");
INSERT INTO lgl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma ioli afula rasua gi lou, gera la sulia Jesus ala talasi fo. Ioli faasia provins 'i Galili gi, ma falua 'i Jerusalem, ma nali falua lou laola provins 'i Judea, ma ala provins 'i Dekapolis, ma faasia gula ala tala nala da'afi ala kwai 'i Jodan. ");
INSERT INTO lgl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Talasi Jesus 'e lesia lo logona ba'ela fo li, ka 'idu fala fofola me raeraena, ma ka gwauru 'i fua. Ma waleli galona lia gi gera ka logo galia, ");
INSERT INTO lgl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma 'i lia ka fuli'ae ala falalaunada 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“'Oilakinaa fala ioli gera saiai gera siofa 'i maala God gi, sulia gera kae too ala 'are 'oka gi, talasi God kae 'ilitoa fafida. ");
INSERT INTO lgl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","'Oilakinaa fala ioli gera kwaimalatai gi, sulia God kae gwafeda. ");
INSERT INTO lgl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","'Oilakinaa fala ioli gera fawawade gera 'i talada gi, sulia God kae kwatea molagali 'e fada. ");
INSERT INTO lgl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","'Oilakinaa fala ioli gera fiolo ma gera ka siligou fala radana li, sulia God kae kwate 'afu ai fada. ");
INSERT INTO lgl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","'Oilakinaa fala ioli malatada amasia ioli mamata gi li, sulia God kae amasida lou. ");
INSERT INTO lgl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","'Oilakinaa fala ioli lioda 'e sakwadola fala God gi, sulia gera kae lesia God. ");
INSERT INTO lgl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","'Oilakinaa fala ioli gera galo fala aroarona 'i safitala ioli li, sulia God kae soi gera 'alia wela lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","'Oilakinaa fala ioli la gi gera malakwaita ada 'i fofola taunala 'are rada gi, sulia gera kae too lo ala 'are 'oka gi, talasi God ka 'ilitoa fafida. ");
INSERT INTO lgl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“'Oilakinaa famiu talasi ioli kae ili ta'a amiu, ma gera kae malakwaita amiu, ma gera kae ilia 'are ta'a afula gi amiu 'i fofola 'i 'amiu ioli li galona lau gi. ");
INSERT INTO lgl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lau ilia 'are 'e gi sulia gerakae taua lou 'are ta'a gi amiu lia gera taua ala profet gi 'i lao. Moulu babalafe 'amoulu, sulia God kae kwatea kwaiarana ba'ela la 'e alu golia famiu 'i nali.” ");
INSERT INTO lgl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesus ka sae lou 'uri 'e, “Me asi 'e famamua fana famiu. Ma 'i 'amiu lou 'amu malaa me asi fala faa'okanala ioli gi sui. Wasua ma ala asiasilanai ka sui faasia, 'e 'ato rasua ko faa asiasila lou. Ma iko 'ali 'oka lo fala taunai 'alia ta me 'are, ma 'e 'oka 'ali 'amu taasi lo 'amiu 'alia 'i maluma, 'ali ioli gi gera uria lo 'ada. ");
INSERT INTO lgl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“'Amiu 'amu malaa lou fakwaru fala ioli gi sui 'i laola molagali. Luma gera galofia 'i gwaula fe uo li 'e 'ato 'ali agwa. ");
INSERT INTO lgl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma iko ta ioli 'ali fakwarua fe ulu, sui ka alua 'ala 'i malula dako. Talasi 'e fakwarua fe ulu fo ka sui lo li, ka sakea, ka uranailia ala lifi 'i nali, 'ali ma ka madakwa fala ioli gi sui 'i laola luma. ");
INSERT INTO lgl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma ka 'urifo lou, fe ulu 'amiu ka tala ko 'i lao ala ioli gi sui, 'ali talasi gera lesia 'are 'oka 'amu tauda gi li, gera ka batafea Mama 'amiu 'i nali. ");
INSERT INTO lgl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moulu ala fii nai 'uri lau la mae fala faasuinala taki Moses gi failia falalauna profet gi li. Iko 'ali lau la mae fala faasuinali, lau la mae 'agua fala faa ali'afunala falalauna fo gi. ");
INSERT INTO lgl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Lakae ilia me 'are kwalaimoki famiu, ala talasi 'i nali failia molagali daro io 'ua, 'ato 'ali ta me toritorina wawade wasua ala taki 'ali sui, la la ka dao ala talasi la 'are 'i laola taki gi li sui gera fuli kwalaimoki lo. ");
INSERT INTO lgl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","'Are la fo, ite ioli 'e iko 'ali ronosulia ta taki wawade wasua, ma ka falalaua lou tali ioli fala barasi na 'alia ta taki wawade, God kae alua kae fafu'isi 'i laola Tatalona lia. Ite 'e ronosulia taki gi ma ka falalau tali ioli fala ronosulinali, malaa lou 'i lia talala, God kae alu lia kae ba'ela 'i laola Tatalona lia. ");
INSERT INTO lgl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lakae ilia famoulu, ala io radanamiu 'e iko 'ali liufia wale li falalauna ala taki gi li, failia Farasi gi ala tauna sulia liola God, 'e 'ato rasua 'ali 'amu io failia ioli God kae 'ilitoa fafida gi. ");
INSERT INTO lgl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“'Amiu ronoa sui lo saena 'ilitoa ba gera ili 'uri 'e ali fala koko gia gi 'i lao ‘Ko ala rau ioli na. Ala ta ioli 'e rau ioli, gerakae sakea 'i maala waleli tolinimalata gi.’ ");
INSERT INTO lgl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wasua ma talasi 'e, lakae ilia famiu, ite 'e ogata'a fala walefae lia, gerakae sakea 'i maala wale li tolinimalata gi. Ma ite 'e ilia fala walefae lia, ‘'I'o me 'oraewale mola 'i'o,’ gerakae sakea 'i maala wale li tolinimalata gi. Ma ite 'e soia walefae lia 'alia, ‘Me kwe 'i'o,’ 'i lia kae la 'i laola tala fala dunaa 'e 'ago ma ikoso ke mae. ");
INSERT INTO lgl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ta 'e, ala 'o rerei 'alia foasina 'o fala God 'i fofola 'erefau, ma ko malata tonai iko 'ali 'e madakwa 'ua 'i safitamoroa toolamu sulia me rerona 'o, ");
INSERT INTO lgl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'o tafisia ga foasina la 'o 'i maala 'erefau, sui ko oli, ma ko faarada 'o ga failia. Sui 'i buri, ko bi oli mae 'ali 'o kwatea foasina 'o fala God. ");
INSERT INTO lgl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ma ala ta ioli ka sake 'o 'i maala taki, 'o sae kwaima ga failia, talasi iko 'ali mora dao 'ua mala taki li. Suli ala mora dao lo, 'i lia kae kwate 'o lo fala waleli tolinimalata gi, ma 'i burila 'e tolinimalata famu, 'i lia kae kwate 'o lou fala wale fala firi ioli na gi li, ma wale fala firi ioli na li ka bi alu 'o 'i laola rara. ");
INSERT INTO lgl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Lakae ilia famu, ala 'e 'urifo, 'e 'ato 'ali 'o latafa faasia rara la la ko kwatea lo bata 'isi'isi 'e totolia kwaikwaina 'o li. ");
INSERT INTO lgl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Moulu ronoa sui lo saena 'ilitoa gi gera ilia, ‘Ikoso 'ali 'o tau ta'a failia ta geliwateu.’ ");
INSERT INTO lgl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ma talasi 'e, lakae ilia famiu, ite 'e bubunia ta geli 'alia lio 'i wale ta'a, 'i lia 'e tau ta'a sui lo 'alia liola. ");
INSERT INTO lgl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Lia fo, ala 'o oga koe fulia ta me 'are ta'a 'alia fili maa aolo 'o, 'o 'iroa, ma ko taasia faasi 'o. 'E ke 'oka mola 'ala famu ala ko taasia 'alia ta gula ala rabemu, taufasia God ka bi 'ui 'alia rabemu sui 'i laola dunaa ala lifi li maenaa li. ");
INSERT INTO lgl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma ala 'o oga koe fulia ta me 'are ta'a 'alia fili lima aolo 'o, 'o 'ole mousia ma ko taasia faasia 'o. 'E ke 'oka mola 'ala ala ko taasi 'alia ta gula ala rabemu, taufasia God ka bi 'ui 'alia rabemu sui 'i laola dunaa ala lifi li maenali. ");
INSERT INTO lgl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Moulu ronoa sui lo saena 'ilitoa gi gera ilia, ‘Ite 'e lugasia wateu lia, 'i lia ka kwatea fofoe saena ala kwailugatae nali fala.’ ");
INSERT INTO lgl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wasua ma talasi 'e, lakae ilia famiu, 'ato ta wale 'ali lugasia wateu lia. Ala wale 'e lugasia wateu lia, 'i lia lo 'e kwatea wateu lia ka tau wale. Ma ala ta wale ka tolea lou geli fo, wale la 'e tau wateu lou 'i maala God. Teke me 'are mola wale 'e saiala lugasinala wateu lia 'i fofola, ala 'e tau ta'a failia ta wale mamataa. ");
INSERT INTO lgl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Moulu ronoa lou saena 'ilitoa gera ilia fala ioli 'ua lo mae 'i lao gi, ‘Ala 'o alafuu 'alia ratala God, ikoso 'o 'oia lo alafuuna 'o.’ ");
INSERT INTO lgl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma talasi 'e, lakae ilia famoulu, ko ala alafuuna 'ali ta me 'are. Ko ala alafuuna 'alia 'i nali, sulia God 'e 'ilitoa 'i lifi fo. ");
INSERT INTO lgl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma ikoso alafuu 'alia molagali, sulia God 'e 'ilitoa lou fafia. Ma ikoso alafuu 'alia 'i Jerusalem, sulia lia falua walelitalona ba'ela ka tasa li. ");
INSERT INTO lgl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma ko ala alafuuna 'alia gwaumu, sulia 'e 'ato ko raunailia ta teke me ifu 'i gwaumu ka kaka'a 'o ma ka gola. ");
INSERT INTO lgl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ala koe alafafi, 'o ilia mola, ‘'Eo.’ 'O ma ala iko 'ali 'o alafafi, 'o ilia mola ‘Iko.’ Ma ala koe ilia lou ta me 'are, me 'are la 'e la lo mae faasia Saetan.” ");
INSERT INTO lgl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesus 'e alaa ma ka sae 'uri 'e, “Moulu ronoa sui lo saena 'ilitoa gi gera sae 'uri 'e, ‘Ala ta ioli ka getea maala ta ioli, geraka getea lou maala ioli la. Ma me lifo lou fala duunala me lifo.’ ");
INSERT INTO lgl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Wasua ma talasi 'e, lakae ilia famoulu, ikoso duua ta 'are ta ioli taua ka ta'a famu. Ala ta ioli ka fidalia gula babali aolo amu, 'o ala'alia ka fidalia lou gula babali mauli amu. ");
INSERT INTO lgl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma ala ta ioli ka sake 'o 'i mala taki fala sakenala to'omi fafu ba'ela 'o, 'o ala'alia ka sakea lou to'omi 'i malula 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","'O ala ta ioli ka suunailia ko sakea 'okoe 'are lia sulia ta tofui tala, 'o sakea lou sulia ta ruala tofui tala. ");
INSERT INTO lgl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma 'o kwate 'ala ta ioli 'e sugaa ta me 'are amu. Ma talasi ta ioli ka oga sake lanana ala ta me 'are amu, 'o kwatelana ai fala. ");
INSERT INTO lgl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Moulu ronoa sui lo saena 'ilitoa gi 'e 'uri 'e, ‘'Amu kwaima ala ioli kwaima 'amiu gi, ma 'amu malimae ala ioli gera malimae amiu gi.’ ");
INSERT INTO lgl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wasua ma talasi 'e, lakae ilia famoulu, 'amu kwaima ala malimae 'amiu gi, ma 'amu ka foa fala ioli gera malakwaita amiu gi. ");
INSERT INTO lgl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ala 'amu ka tau 'urifo, 'amu wela ala Mama 'amiu 'i nali. Sulia 'e raunailia da'afi, ma ka rara fafia ioli ta'a gi failia ioli 'oka gi sui, ma ka kwatea uta fala ioli gera fulia 'are 'oka gi li, failia ioli gera fulia 'are ta'a gi li lou. ");
INSERT INTO lgl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ala 'amu kwaima mola ala ioli 'e gera kwaima amiu gi, God ikoso kwaiara 'amiu mola. Sulia wale 'aurafu li goli bata ala takisi gi li wasua, gera taua lou me 'are la! ");
INSERT INTO lgl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma ala 'amu sae 'oka mola failia kwaima 'amiu gi, iko 'ali 'amu mamata mola faasia ioli gi sui. Sulia ioli gera raria God gi wasua, gera taua lou me 'are la! ");
INSERT INTO lgl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","'Amu ka rada sui, malaa Mama 'amiu 'i nali 'e rada.” ");
INSERT INTO lgl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ma Jesus ka sae lou 'uri 'e, “'Amu madafi 'amiu, taufasia 'amu tau 'are 'oka mola 'i maala ioli, 'ali gera lesida, ma geraka 'aurae 'amiu fafida. Ala 'amu tau 'urifo, 'ato 'ali 'amu sakea ta kwaiara faasia Mama 'amiu 'i nali. ");
INSERT INTO lgl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ala 'o kwatea kwakwatena fala rananala ioli siofa gi li, ikoso akwatailia fala ioli gi 'uri 'ali gera batafe 'o fafia. Sulia falafala ioli 'asa gi li lo 'e 'urifo. Gera kwairanai ala ioli siofa gi 'i laola luma fala foana gi li ma sulia tala ba'ela gi lou, 'uri 'ali ioli gi sui gera ka batafeda. Ma lakae ilia famoulu, God ikoso kwatea ta kwaiara fada, sulia gera sakea sui lo kwaiarana gera gi. ");
INSERT INTO lgl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma talasi 'o kwatea me 'are fala kwairanaina li, ikoso fatailia fala ta ioli, ta kwaima 'o wasua ikoso sai lou ai. ");
INSERT INTO lgl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Talasi 'o kwatea ta 'are fala ta ioli, 'o faagwaa faasia ta ioli lou faasia lesinai 'o ma saina ai. Wasua ko kwate agwaagwa ai, Mama 'o 'i nali 'e lesia taa gi 'o tauda, ma kae kwatea kwaiarana famu.” ");
INSERT INTO lgl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesus ka sae lou 'uri 'e, “Talasi 'amu kae foa, ikoso 'ali 'amu malaa ioli 'asa gera foa mola 'ada 'ali ioli 'ali lesida. Sulia ala talasi gera foa, gera oga rasua ala urana 'i laola luma fala foana gi li, 'o ma sulia tala ba'ela gi, 'uri 'ali ioli gi gera ka lesida, ma geraka 'auraeda. Ma lakae ilia famoulu, gera sakea sui lo kwaiarana gera gi faasia ioli 'e gera 'auraeda gi. ");
INSERT INTO lgl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma talasi koe foa, 'o la ala ta lifi 'e io raefuli, ma ko io 'i lifila ko foosia God, ma iko ta ioli 'ali lesia 'o. Wasua iko ta ioli 'ali'e leesi 'o ala talasi koe foa, Mama 'o 'i nali 'e lesi'o. Ma 'i lia lou kae kwaiara 'o fala 'are 'o tauda gi. ");
INSERT INTO lgl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ala talasi 'amu foa, ikoso 'ali amu malaa lou ioli 'e raria God gi. Sulia talasi gera kae foa, gera sae tekwa rasua, ma iko 'ali gera sai madakwa ala taa gi 'e gera ilida. Malatada 'e fia 'uria ala gera foa tekwa 'urifo God kae ronoda. ");
INSERT INTO lgl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma ikoso 'ali 'amu tau lou malaa ioli fo gi, sulia Mama 'amiu 'i nali 'e etae sai sui lo ala taa gi 'amu boboo fali, 'amu ka bi sugaada. ");
INSERT INTO lgl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Ala talasi 'amu kae foa, 'amu ka sae 'uri 'e, ‘Mama 'ami 'i nali, 'Ami oga ioli gi sui geraka fabaelaa ratamu, sulia 'e abu rasua. ");
INSERT INTO lgl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dao mae 'alia 'ilitoana 'o fafia maurinala ioli gi sui. Ma liomu 'ami ka tau sulia 'i wado malaa lou 'i nali. ");
INSERT INTO lgl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","'O kwatea mae famami fana 'e totolia fe atoa 'e li. ");
INSERT INTO lgl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'O kwailufa 'alia ta'ana 'amami gi, malaa lou 'ami kwailufa 'alia ta'ana ioli 'e fulida amaami gi. ");
INSERT INTO lgl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'O ala lugatae na mami fala ilitoona gi fala liufi namami. Ma ko lau 'ali 'ami faasia Saetan.’ ");
INSERT INTO lgl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ala 'amu kwailufa 'alia ta'ana ta ioli 'e fulia amiu gi, Mama 'amiu 'i nali kae kwailufa lou 'alia ta'ana 'amiu gi. ");
INSERT INTO lgl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma ala iko 'ali 'amu kwailufa ala ioli 'e fulia 'are ta'a amiu, Mama 'amiu 'i nali wasua ikoso kwailufa lou amiu.” ");
INSERT INTO lgl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesus ka sae lou 'uri 'e, “Ala talasi 'amu abu fana fala foa nanata na li, ikoso 'ali 'amu malaa ioli 'asa gi. Sulia talasi gera abu fana, gera lio malaa ioli gera kwaimalatai gi, 'uri 'ali ioli ka leesia lia 'e gera abu fana, ma geraka 'auraeda. Ma lakae ilia famoulu, ioli fo gi 'ato 'ali gera sakea ta kwaiara, sulia ioli 'e kwatea lo kwaiara fada 'alia tafenada. Ma God ikoso 'ali kwatea lo ta kwaiara fada. ");
INSERT INTO lgl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wasua ma ala talasi koe abu fana, ko sisiu 'amua, ma ko usuri ifu 'amua malaa lia 'e koe tautaua ala atoa gi li sui, ");
INSERT INTO lgl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","'ali ioli ikoso lio raea lia 'e 'o abu fana. Ma wasua 'ala ioli ikoso lio rae 'o, Mama 'o 'i nali 'e leesi 'o, ma kae kwatea kwaiara famu fala 'are 'o tauda gi. 'I lia 'e leesi 'o ala atoa gi sui, wasua 'i'o iko 'ali 'o lesia.” ");
INSERT INTO lgl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Sui, Jesus ka sae lou 'uri 'e, “'Amu ala goli nala too 'arena 'amiu gi 'i laola molagali lifi 'e sulaa failia furafurana kae fafuta'a, failia ioli belibeli kae belida. ");
INSERT INTO lgl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","'Amu golia too 'arena 'amiu gi 'i nali, lifi sulaa ma furafurana 'ato 'alia 'e fafuta'a, failia ioli belibeli 'ato 'ali belia. ");
INSERT INTO lgl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sulia talasi too 'arena 'amiu gi 'e io 'i nali, manomiu ka lio 'alaa sui lo fala 'i nali. Ma talasi too 'arena 'amiu gi 'e io 'i laola molagali li, manomiu ka toli tegula sui lo fala 'are 'i laola molagali gi li. Sulia 'i fe too 'arena 'o 'e io ai, 'i lifila lou manomu 'e io ai. ");
INSERT INTO lgl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Suli ala maamu 'e 'oka, ko io 'i laola madakwana ala falalauna God, sulia maamu 'e dau talaia mae madakwana 'i laola rabemu. ");
INSERT INTO lgl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ala iko 'ali 'o lesia madakwa na 'e, maamu 'e ta'a, ma ko io mola 'amua 'i laola maerodo. 'Amu madafi 'amiu, ala 'amu tafisia madakwana God, 'i laola manomiu 'e rodo rasua.” ");
INSERT INTO lgl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesus ka sae lou 'uri 'e, “'Ato 'ali ta ioli 'ali ka galo 'ala ta rua wale ba'ela atale. Ala 'e 'urifo, 'i lia kae malimae ala ta ai, ma ka kwaima ala ta ai. Ma kae galo 'oka 'ala ta wale, ma kae 'ailuga 'ali ta wale. Lia fo, 'e 'ato rasua 'ali ta ioli 'ali galo 'ala God ma bata ala teke me talasi. ");
INSERT INTO lgl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“'Are la 'e laka ilia famoulu, ikoso 'ali 'amu fiitala sulia ta 'amu kae 'ania, ma 'amu kae goufia, ma ta 'amu kae toro 'alia fafia rabemiu. Sulia maurina 'e 'oka ka tasa liufia fana, ma rabe 'e 'oka ka tasa liufia toro. ");
INSERT INTO lgl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lesia fe malu gi 'i laola raloo, iko 'ali gera 'abero mola sulia galona ala ta raku. Ma iko 'ali gera fisua mola ta fana, ma iko 'ali gera raunailia mola ta gwaurau fala alu fana na. Wasua ma Mama 'amiu 'i nali ranolida mola 'ala. God 'e lio ba'ela rasua amiu ka liufia fe malu fo gi. God kae ranoli 'amiu mola 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wasua 'amu ka fiitala sulia maurina 'amiu gi, 'e 'ato rasua 'ali 'amu taua manomiu ka ke tekwa wawade lou. ");
INSERT INTO lgl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma 'utaa bui 'e 'amu ka fiitala sulia 'afinamiu? 'Amu lesia ga taganala 'ai 'e gera afola gi. 'E iko 'ali gera galo mola, ma iko 'ali gera raunailia mola ta toro 'ada. ");
INSERT INTO lgl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma lakae ilia famoulu, gera lio sinosino ka tasa liufia toro ba Solomon walelitalona 'e ruufida gi. ");
INSERT INTO lgl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ma taganala 'ai gi, gera io mola sulia keme talasi dodoko, ma gera ka taasida lou 'i laola dunaa. Ka 'urifo wasua 'ala, God 'e faaruufida 'alia 'are 'oka gi. 'Amu fiitala 'e, 'uri fasia God ikosoe bi faatoro 'amiu? Fitoona 'amiu gi 'e wawade. ");
INSERT INTO lgl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Lia fo, 'o ala fiitalana 'uri 'e, ‘Fana, failia 'are li goufia, 'o ma toro lau gi kae la mae faasia 'i fe?’ ");
INSERT INTO lgl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","'Eo, ioli gera io tatau faasia God gi, gera saiala fiitalana sulia 'are fo gi li. Ma 'i 'amiu, Mama 'amiu 'i nali 'e saiai ka sui lo lia 'e 'amu boboo fala 'are fo gi li. ");
INSERT INTO lgl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","'Amu silia maurina 'e God 'e 'ilitoa fafia failia tau 'are rada na ka liufia 'are gi sui, ma 'i lia kae kwatea 'are 'amu booboo fai gi famiu. ");
INSERT INTO lgl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Lia fo, ikoso 'ali 'amu fiitala sulia booboona fala 'i danii gi. Alua fala 'i dani. Iko 'ali'e totolia 'ali 'amu logosia fiitalana 'i dani gi failia fiitalana ala fe atoa 'e tara'ela gi li lou. Sulia fe atoa 'e tara'ela 'e too ala fiitalana 'e totolia lo tara'ela gi.” ");
INSERT INTO lgl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma Jesus ka sae lou 'uri 'e, “'Amu ala iili saena na suli ta ioli mamata, taufasia God 'e bi suafafi 'amiu lou. ");
INSERT INTO lgl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ala 'amu iili ioli, God kae suafafi lou 'urifo amiu. Ma ta taki ta 'amu kwaia ta ioli 'alia, taki la lou God kae kwai 'amiu 'alia. ");
INSERT INTO lgl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","'O too ala ta'ana ba'ela gi, wasua 'o balufia mola 'amua ioli 'e too ala ta'ana wawade gi li. 'O malaa wale 'e lesia fulafulae tafu wawade 'i laola maala walefae lia li, wasua ma iko 'ali 'e lesia mola te boboe wado ba'ela 'i laola maala 'i talala. ");
INSERT INTO lgl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ma ko sae 'uri 'e fala ioli mamata, ‘'O fulia me 'are 'e ta'a, ala 'alia 'ali lau farada maurinamu.’ Wasua ma iko 'ali 'o malata booboo mola sulia ta'ana ba'ela 'o tauda gi. ");
INSERT INTO lgl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","'I'o ioli 'asa 'i'o. 'O taasia ga ta'ana 'o gi. Sui, ko bi totolia kwairanaina ala ta ioli mamata fala ta'ana lia gi li. ");
INSERT INTO lgl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ma 'amu ala kwate nala 'are abu gi fala kui gi, sulia gera kae bulusi, ma gerakae 'alai 'amiu. Ma ikoso 'ali 'amu kwatea launi 'amiu gi fala boo gi, tau ma gera bi uria mola 'ada.” ");
INSERT INTO lgl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesus ka sae lou 'uri 'e, “'Amu ka sugaa God 'ali 'amu sakea 'are 'amu suga 'afia. 'Amu faitale 'afia 'are 'amu boboo fai gi ala God, ma 'i lia kae rana 'amiu, 'ali 'amu daria. 'Amu ka kidikidi ala mala luma, ma God ka tafa famiu. ");
INSERT INTO lgl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sulia ioli gera suga ala God gi sui, gera kae sakea 'are gera sugaa fai gi. Ma ioli gera faitale 'afia 'are gera boboo fai gi li sui ala God, gera kae darida. Ma ioli gera kidikidi ala mala luma li, God kae tafa fada. ");
INSERT INTO lgl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“'Uri'e ma, ite amoulu ala mama gi, ala wela 'o 'e suga 'o fala ta me fana, ko kwatea mola me fau fala? ");
INSERT INTO lgl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma ala wela 'o 'e suga 'afia ta me lodae ia, ko kwatea 'amua ta fe wa fala? 'E 'ato mola! ");
INSERT INTO lgl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","'Amiu ioli ta'a gi 'amu saiala kwatenala 'are 'oka gi fala wela 'amiu gi. Ma Mama 'amiu 'i nali, lia 'e 'oka ka tasa liufi 'amiu lou. 'Urifo 'i lia kae kwatea 'are 'oka gi fala ioli gera suga lia fai gi. ");
INSERT INTO lgl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Me 'are la fo, 'are 'amu kae tautauda gi sui, tali ta 'amu oga 'alia ioli mamata gi 'ali gera taua famiu, 'amu ka taua lou fada. Sulia lia lo fadanala faalalauna gi sui 'i laola taki Moses, failia profet gi.” ");
INSERT INTO lgl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesus ka sae lou 'uri 'e, “'Amu ruu ala maala luma 'e susukudi, sulia maala luma 'e ba'ela ma ka afola, 'e la fala maena firi. Ma liuna sulia ka talawarau rasua, ma ioli afula rasua gi gera la sulia tala fo. ");
INSERT INTO lgl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ma maala luma failia tala fala maurina firi li 'e susukudi, ma liuna sulia ka 'ato, ma ofotae ioli gi mola gera liu sulia.” ");
INSERT INTO lgl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesus ka alaa lou ka sae 'uri 'e, “'Amu madafi 'amiu faasia profet kotokoto gi. 'Amu madafi 'amiu sulia gera lio malaa ioli 'oka gi, wasua malatada 'e malaa kui kwasi gi lia gera oga fata'anamiu. ");
INSERT INTO lgl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma 'amu ka lio raea mola 'amiu profet kotokoto fo gi 'alia 'are ta'a 'e gera tauda gi. Gia saiala 'okanala 'o ma ta'anala 'ai gi sui, 'alia fufuae 'are gera funu 'alida gi. Ma 'e 'ato ta ioli ka fisua fufuae 'ai 'oka faasia kwalokarakaraa. ");
INSERT INTO lgl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma 'ai 'oka 'e funu 'alia fuae 'are 'oka gi, ma 'ai ta'a ka funu 'alia fuae 'are ta'a gi. ");
INSERT INTO lgl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'Ai 'oka 'e 'ato ka funu 'alia fuae 'are ta'a, ma 'ai ta'a 'e 'ato ka funu 'alia fuae 'are 'oka. ");
INSERT INTO lgl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","'Ai iko 'ali gera funu 'alia fuae 'are 'oka gi li, gera kae tofuda, ma gerakae 'ui 'alida 'i laola dunaa. ");
INSERT INTO lgl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Lia fo, lakae ilia famiu, 'amu ka lio raea profet kotokoto gi 'alia 'are gera tauda gi.” ");
INSERT INTO lgl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesus ka sae lou 'uri 'e, “Iko lou ioli gera soi 'uri 'e agu gi sui, ‘Aofia! Aofia!’ gera kae io failia ioli God kae 'ilitoa fafida gi. Ma ioli gera tau sulia liola Mama lau 'i nali mola gerakae io failia ioli 'e God kae 'ilitoa fafida gi. ");
INSERT INTO lgl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ioli afula gi gerakae sae 'uri 'e fagu ala fe atoa fo ala tolinimalata na li, ‘Aofia! 'Ami faatalo 'alia saenala God 'alia ratamu, ma 'ami ka balia aloe 'are ta'a gi 'alia ratamu, ma 'ami ka taua 'are mama'ala gi 'alia ratamu.’ ");
INSERT INTO lgl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wasua ma lakae sae madakwa 'uri 'e fada, ‘Iko 'ali lau sai amiu. Ioli tau ta'a gi 'i 'amiu. 'Amu la tatau ko faasia lau!’ ");
INSERT INTO lgl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Lia fo, ioli gera ronoa alaana lau gi li, ma gera ka tau sulia, gera malaa wale liotoo 'e raunailia luma lia 'i fofola fulu 'ai nasi gi ma ka 'eli ka sifo lalo 'i laola faufaua. ");
INSERT INTO lgl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Uta ba'ela 'e too, ma kwai gi ka afe, failia oru ba'ela ka fotoia luma fo, wasua ma luma fo iko 'ali toli mola, sulia 'e ura nasi 'i fofola fau nasi. ");
INSERT INTO lgl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ioli gera ronoa alaana lau gi, ma iko 'ali gera tau sulia, gera malaa wale kwekwe'ela 'e raunailia luma lia 'i fofola ole, ma iko 'ali 'eli 'ali sifo lalo mola. ");
INSERT INTO lgl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ma uta ba'ela ka too, ma kwai gi ka afe, ma oru ba'ela ka fotoia luma fo, ma luma fo ka toli, ma ka manisi sui lo.” ");
INSERT INTO lgl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Talasi Jesus 'e fasuia falalauna sulia 'are gi sui, ioli gi gera ka kwele rasua, ");
INSERT INTO lgl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sulia gera sai 'oka ala lia 'e Jesus 'e famalata 'alia nanatana failia kwalaimokina ala God. 'E iko 'ali 'e dona lou sai 'arena wale li falalauna ala taki Moses gi li, sulia gera famalata mola 'alia nanatana gera 'i talada gi. ");
INSERT INTO lgl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Talasi Jesus 'e sifo lo mae faasia 'i gwaula fe uo fo li, logona ba'ela rasua gera ka la mae sulia. ");
INSERT INTO lgl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma te wale kuu 'e odea rabela ka la mae, ma ka boururu 'i maala Jesus, ma ka sae 'uri 'e, “Arai, ala ko marabe, ko guraa lau.” ");
INSERT INTO lgl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sui Jesus ka tadaa ko limala, ma ka dau tonala rabela, ma ka sae 'uri 'e, “'Eo, lau marabe. 'O mafo lo.”. Ma nainali mola 'i burila Jesus 'e sae 'urifo, kuu fo ka sigi lo faasia wale fo. ");
INSERT INTO lgl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesus ka sae 'uri 'e fala, “Ikoso 'ali 'o faronoa lou ta ioli 'alia me 'are 'e lau taua famu. Wasua ma 'o la, ko fatailia rabemu fala fata abu God, ko ala'alia fata abu God ka iro 'oka amu. Sui ko kwatea foasina 'o malaa lia ba Moses 'e ilia fala kwatenai, 'ali fatailia kwalaimoki fala ioli gi sui lia 'e rabemu 'e mafo lo.” Ma Jesus ka kwatea wale fo ka la lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Talasi Jesus 'e dao lo ala falua 'i Kapaneam, te wale etaeta ala wale li mae faasia 'i Rom gi, 'e la mae 'i so'ela Jesus, ma ka sugaa 'ali kwairanai ala, ");
INSERT INTO lgl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ma ka sae 'uri 'e, “Aofia, ioli li galona lau, 'e matai rasua, ma ka teo mola 'ala, ma ka raria lo bulusinala rabela 'i talala, ma rabela ka fii rasua.” ");
INSERT INTO lgl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus ka sae 'uri 'e fala, “'Oka mola 'ala, lakae la mae fala luma 'o 'ali lau guraa.” ");
INSERT INTO lgl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma wale etaeta fo ka sae lou 'uri 'e fala Jesus, “Aofia, iko 'ali lau totolia 'ali lau fadao 'o 'i luma agu. 'O ilia mola mae ta alaana, ala ko ilia mola ta me alaana, wale li galona lau kae 'akwaa lo. ");
INSERT INTO lgl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Lau saiai 'o totolia mola 'amua taunala me 'are 'urifo, suli 'i lau talagu wale lau galo 'i malula wale ba'ela gi lou, ma lau too ala wale li mae gi gera galo 'i malula nanata na lau. Ma ala laka sae 'uri 'e fala ta wale, ‘'O la,’ lia ka la lo. Ma ala laka sae 'uri 'e fala ta wale, ‘'O la mae,’ 'i lia ka la lo mae. Ma ala laka sae 'uri 'e fala ta wale li galona lau, ‘'O taua me 'are 'e,’ 'i lia ka taua lo.” ");
INSERT INTO lgl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ma talasi Jesus 'e ronoa me 'are fo li, ka kwele rasua. Ma ka bulusi fala ioli gera la sulia gi, ma ka sae 'uri 'e fada, “Lakae ilia famiu, iko 'ali lau lesia 'ua ta ioli 'ali fitoo 'uri 'e, 'i laola falua 'i Israel wasua. ");
INSERT INTO lgl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma lakae ilia famiu, ioli afula 'e iko lou Jiu gi li, gerakae la mae faasia falua afula gi laola molagali fala 'adona failia koko gia gi Abraham, Aesak, ma Jakob ala maoma ala babalafena li 'i nali. ");
INSERT INTO lgl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma afulanala Jiu gi lia 'e totolia gera ka 'ado ala 'are 'oka gi 'i nali, God kae tabalida fala lifi rodo. Ma talasi gera io ala lifi fo li, gerakae ani, ma gerakae giria lifoda, sulia gera rabefii.” ");
INSERT INTO lgl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ma Jesus ka bulusi lou fala wale ba'ela fo, ka sae 'uri 'e fala, “'O oli. Lau taua lo 'are 'e 'o sugaa, sulia 'o fitoo agu.” Ma ala me talasi fo mola lo, wale li galona ba lia ka 'akwaa lo. ");
INSERT INTO lgl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ma ala na fe atoa, Jesus ka la mae 'i luma ala Peter. Talasi Jesus 'e ruu 'i luma, ka lesia funo geli Peter 'e teo mola 'ala, 'e matai 'alia 'ago'agona ba'ela. ");
INSERT INTO lgl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ma Jesus ka dau tonala limala geli fo. Ma ala me talasi fo mola lo, 'ago'agona fo ka sui lo faasia. Lia ka 'akwaa lo, ma ka tatae ka galo fana lo 'ala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","'E raurafi, ioli ala falua fo li gera sakea mae ioli afula aloe 'are ta'a gi 'e tooada 'i soela. Ma Jesus ka balia aloe 'are ta'a fo gi faasida 'alia saenala mola. Ma ka guraa lou ioli matai gi sui. ");
INSERT INTO lgl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Talasi 'e taua 'are fo gi li, 'e fakwalaimokia saenala profet Aesea ba 'e gerea ka sae 'uri 'e, “'I lia 'e faamauri gia faasia mataina gia gi.” ");
INSERT INTO lgl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ma talasi Jesus 'e lesia ioli afula gera logo mae galia, lia ka sae 'uri 'e fala waleli galona lia gi, “Golu tofolo fala abae 'osi lobaa.” ");
INSERT INTO lgl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ala talasi fo lou, te wale falalau ala taki li ka la mae 'i so'ela Jesus ka sae 'uri 'e, “Waleli Falalauna, lau oga 'ali lau la fae 'o 'i fe wasua koe la fai.” ");
INSERT INTO lgl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Talasi Jesus ronoa me 'are fo li, ka sae 'uri 'e, “'E iko 'ali 'e talawarau. 'A kui kwasi gi gera too ala lifi gera gi fala teona, ma malu gi lou gera too ala tatafe gera gi. Wasua ma 'i lau, Wela Wale li, iko 'ali lau too ala ta luma 'agua 'i talagu fala mo'osu na.” ");
INSERT INTO lgl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma na wale ala wale li galona lia gi, ka sae fala Jesus 'uri 'e, “Arai, 'o ala'alia 'ali lau la, laka io ga failia mama lau, la la ka mae bui, laka alua ka sui, laka bi dona 'o.” ");
INSERT INTO lgl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus 'e olisia ka sae 'uri 'e, “Iko. 'O la lo mae faelau ala talasi 'e. Ala'alia ioli iko 'ali gera too ala maurina ala God gi, gera alua lo 'ada ioli mae gera gi.” ");
INSERT INTO lgl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ma Jesus ka tae 'i laola baru failia waleli galona lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma ala talasi daulu 'idu tatau lo ko, koburu ka dao torani daulu lo, ma asi ka rae 'i nali, ma ka taasi lo mae fafia baru fo. Ma baru fo ka garani wawalo lo. Wasua ma Jesus 'e mo'osu mola 'ala 'i laola baru fo. ");
INSERT INTO lgl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ma wale li galona lia gi gera ka faa ada, gera ka sae 'uri 'e, “Aofia! 'O faamauri golu! Golu kae garani mae lo.” ");
INSERT INTO lgl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ala talasi fo Jesus ka sae 'uri 'e fadaulu, “'Uta 'e 'amu ka mau? Lau lesia fitoona 'amiu agu 'e iko 'ali ba'ela.” Jesus 'e sae 'urifo fadaulu sui ka tatae, ma ka sae nanata fala oru failia lafolafo, 'ali daro ka io aroaro. Ma ala talasi fo mola, oru failia lafolafo daro ka io aroaro lo, ma ka beata lo. ");
INSERT INTO lgl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma wale li galona lia gi gera ka kwele rasua, ma geraka sae 'uri 'e, “Wale 'utaa lo 'e wani? Oru failia lafolafo gi wasua gera rono lou sulia!” ");
INSERT INTO lgl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ma talasi daulu li dao lo ala na abae 'osi ala mae falua 'i Gadara, Jesus ka dao tonala rua wale aloe 'are ta'a gi 'e io adaroa. Rua wale fo gi daro io 'i laola gilu 'i laola fau fala gigiluna ala ioli maegi li. Ma sulia daro balubalua rasua, iko ta ioli 'ali dao garania lo lifi fo daro io ai. ");
INSERT INTO lgl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ala talasi aloe 'are fo gera io ala rua wale fo gi li gera lesia Jesus ai, gera ka rii 'uri 'e, “Wela 'e God, taa 'o oga koe taua ameulu? 'Uta ko la mae fala malakwaita na ameulu, lia 'e talasi ala malakwaitanali iko 'ali dao 'ua?” ");
INSERT INTO lgl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ala talasi fo, boo afula gi gera fana garania 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ma aloe 'are ta'a fo gi gera ka aniulu 'uri 'e fala Jesus, “Ala koe lulu 'ameulu, 'o lulu 'ameulu fala 'i laola boo lobaa gi.” ");
INSERT INTO lgl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma Jesus ka sae 'uri 'e fala aloe 'are fo gi, “Moulu la lo!” Ma gera ka latafa, ma gera ka la lo fala 'i laola boo fo gi. Ma boo fo gi sui gera 'aru ala me raeraena 'i rabela faulifu fala 'i laola 'osi li. Ma gera ka mae sui 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma ioli gera lio sulia boo fo gi li, gera ka lalao fala falua gera. Ma gera ka alaa sulia 'are fo Jesus 'e taua, ma 'are 'e fuli fala rua wale ba gi li failia aloe 'are ta'a fo gi. ");
INSERT INTO lgl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma ioli ala mae falua fo sui gera la sui mae fala lesinala Jesus. Talasi gera dao 'i soela, gera ka soilidia 'ali 'e la faasia maefalua fo gera. ");
INSERT INTO lgl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus failia waleli galona lia gi, daulu rae 'i laola baru, ma daulu ka tofolo lou ala 'osi ba'ela fo 'i Galili. Ma talasi daulu li dao lo ala falua 'i Kapaneam, ");
INSERT INTO lgl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","nali ioli gera ka sakea mae te wale la rabela mae 'i fofola tafe 'i so'ela Jesus, 'ali 'e guraa. Ma talasi Jesus 'e lesia fitoona daulu, lia ka sae 'uri 'e fala wale rabe mae fo, “'O ala mau na wale'e, lau kwailufa lo 'alia ta'ana 'o gi sui.” ");
INSERT INTO lgl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ala talasi fo, nali wale falalau ala taki gi gera ka malata 'uri 'e, “Talifilia God mola 'e saiala kwailufana 'alia ta'ana gi li. 'E fafuradani lia 'i talala failia God.” ");
INSERT INTO lgl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma Jesus 'e raea malata 'i laola lioda gi, ma ka sae 'uri 'e fadaulu, “Moulu ala malata ta'a na lou 'uri la.” ");
INSERT INTO lgl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Sui ka sae 'uri 'e, “Ala laka sae 'uri 'e fala wale rabe mae 'e, ‘Ta'ana 'o gi, lau kwailufa lo alida,’ 'ato 'ali moulu lesia mola 'ali 'e fuli. Wasua ma ala laka sae 'uri 'e, ‘Tatae ma ko liu lo,’ 'urifo lo 'amu ka bi lesia lia 'e nanatana agu fala gurana. ");
INSERT INTO lgl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Talasi lakae guraa wale 'e li, lakae fatailia famiu lia 'e 'i lau, Wela Wale li, lau too ala nanatana fala kwailufa na 'alia ta'ana gi li.” Sui Jesus ka sae 'uri 'e fala wale rabe mae fo, “'O tatae lo, sakea tafe 'o, ma ko la lo 'i falua 'o.” ");
INSERT INTO lgl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ala talasi fo mola, wale fo ka tatae, ma ka oli lo fala falua lia. ");
INSERT INTO lgl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ala talasi fo ioli gi gera lesia me 'are fo Jesus 'e fulia, gera kwele, ma geraka mau. Ma gera ka batafea God sulia 'e kwatea nanatana 'urifo fala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ma ala talasi Jesus 'e la lo faasia lifi fo li, ka lesia Matthew. 'E gwauru mola 'ala ala lifi fala golinala bata ala takisili, sulia 'e galo 'i lififo. Ma Jesus ka sae 'uri 'e fala, “'O la mae faelau.” Ma Matthew ka tatae, ma ka la lo 'ala failia. ");
INSERT INTO lgl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","'I burila Jesus 'e soia Matthew 'ali 'e waleli galona 'ala, ka lai fana lo 'i luma ala Matthew. Ma alae ioli gera kae goli goli bata ala takisili gera io lou 'i lififo. Ma nali ioli ta'a lou, gera fana lou failia Jesus failia waleli galona lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma talasi Farasi gi gera lesia me 'are fo li, gera ka soilidia waleli galona lia gi, 'uri 'e, “'E totolia ikoso 'ali fana lou failia ioli 'urifo gi.” ");
INSERT INTO lgl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesus ka ronoa me 'are fo, ma ka sae 'uri 'e, “Ioli iko 'ali gera matai gi, iko 'ali gera oga mola ta ioli li gurana, wasua ma ioli gera matai gi lou 'ada, gera boboo fala ioli li gurana. ");
INSERT INTO lgl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","'Amu malata ga sulia malutala Geregerena Abu ba 'e sae 'uri 'e, ‘Lau oga mola kwaiamasina 'amiu fala ioli li, iko lou foasina 'amiu gi.’ Iko 'ali lau la mae fala kwalonala ioli rada gi 'ali geraka bulusi, wasua ma ioli 'e taunada ta'a gi lou 'ada 'e lau la mae fala kwalonada fala olisi nala malatada.” ");
INSERT INTO lgl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Burila 'are fo gi, waleli galona John wale fasiuabu gi, gera ka la mae 'i so'ela Jesus, geraka sae 'uri 'e, “'Ameulu failia Farasi gi, meulu saiala abu fana na. Ma 'utaa 'e waleli galona 'o gi iko 'ali gera tau 'urifo?” ");
INSERT INTO lgl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma Jesus ka olisi 'uri 'e adaulu, “'E iko 'ali ke rada fala ioli gera io ala fanana ala araarainali 'ali geraka kwaimalatai. Dunala lia 'e, arai fa'alu 'e io 'ua mola 'ala failida, gera ka babalafe. Wasua ma talasi kae dao mae 'i dani gerakae sakea arai fa'alu faasida. Talasi fo bui, gera ka bi abu fana lou, sulia gera kwaimalatai. Lia fo iko 'ali totolia waleli galona lau gi 'ali geraka abu fana talasi lau io 'ua mola 'agua failida.” ");
INSERT INTO lgl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sui Jesus ka sae lou 'uri 'e, “Iko ta ioli 'ali'e taibolosia ta toro 'e gaga lo 'alia ta nisinisi toro fa'alu. Suli ala ka tau 'urila, nisinisi toro fa'alu fo kae gagasia toro 'ualo fo sulia toro fa'alu 'e lugu lo 'i burila saunai, ma ka taua maekwakwana la 'e ba'ela rasua. ");
INSERT INTO lgl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ma 'amu sai lou ai, iko 'ali'e totolia 'ali ta ioli 'ali alua waen fa'alu 'i laola wai 'ualo gera galofia 'alia sunasunala nanigot li, sulia wai 'ualo fo 'ato 'ali 'e paku. Suli ala ka tau 'urila, talasi waen fo kae tora mola mae, ka fogaa lo wai 'ualo fo, ma waen fo ka aniki lo, ma wai 'are fo ka ta'a lo. Lia fo ioli ka alua lo waen fa'alu 'i laola wai fa'alu 'e saiai kae paku faasia fata'anala rua 'are fo gi sui.” ");
INSERT INTO lgl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Talasi Jesus 'e alaa 'ua, te wale etaeta ala ioli Jiu gi ka la mae. Ma ka boururu 'i maala Jesus, ma ka sae 'uri 'e, “Ulao lau 'e bi mae mola. Lau oga ko la mae 'ali 'o alua limamu fafia 'ali maurifa'alu lou.” ");
INSERT INTO lgl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ma Jesus failia waleli galona lia gi daulu ka la failia wale fo. ");
INSERT INTO lgl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma talasi daulu kae liu 'ua ko ai, te geli 'abu 'e tafalia, ma ka matai 'alia sulia akwala wala rua fe nali gi li, ka la mae 'i burila Jesus, ma ka dau tonala tamitamila to'omi tekwa lia. ");
INSERT INTO lgl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sulia geli fo 'e malata 'uri 'e, “Te 'ali lau dau mola tonala tamitamila to'omi Jesus, lakae 'akwaa lo.” ");
INSERT INTO lgl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Talasi 'e dau tonala tamitamila to'omi lia li, Jesus ka bulusi, ma ka lesia lo geli fo, ma ka sae 'uri 'e fala, “'O ala malata fitala na. 'O 'akwaa lo, sulia 'o fitoo agu.” Ma ala me talasi fo mola lo, mataina fo ka sui lo faasia. ");
INSERT INTO lgl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ma talasi Jesus failia waleli galona lia gi daulu li dao, daulu ka ruu 'i laola luma wale etaeta fo li, daulu ka lesia ioli gi gera kae ufia 'au ala maenali, ma ioli afula gi lou gera logo 'i lififo, ma gera kae ani. ");
INSERT INTO lgl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma Jesus ka sae 'uri 'e fala ioli fo gi, “'Amiu sui 'amu latafa. Wela geli 'e iko 'ali mae mola, 'e mo'osu mola 'ala.” Talasi gera ronoa Jesus 'e sae 'urifo li, gera ka wasi 'ada 'alia. ");
INSERT INTO lgl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","'I burila ioli fo gi gera la faasia, Jesus ka ruu ko 'i laola toobi fo, ma ka dau 'i maala limala ulao fo, ma ulao fo ka tatae. ");
INSERT INTO lgl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Burila me 'are fo Jesus 'e taua, alaana sulia ka talo ala tolo fo sui. ");
INSERT INTO lgl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Burila Jesus 'e la ko faasia lifi fo, rua wale maa daroa koro gi daro dona Jesus, daro ka rii, 'uri 'e, “Galela David walelitalona, 'o amasi 'ameroa mae!” ");
INSERT INTO lgl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma talasi Jesus 'e ruu 'i laola te luma li, rua wale maa koro fo gi daro ruu lou 'i burila. Ma Jesus ka sae 'uri 'e fadaroa, “'Uri'e ma mora fitoo agu lakae guraa maa moroa?” Ma daro ka olisi 'uri 'e ala, “'Eo, Aofia.” ");
INSERT INTO lgl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma Jesus ka dau tonala maa daroa, ka sae 'uri 'e, “Sulia mora fitoo, me 'are 'e kae fuli kwalaimoki lo famoroa.” ");
INSERT INTO lgl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma maa daroa ka lio lo, ma Jesus ka sae nanata fadaroa 'ali ikoso daro faarono 'alia fala ta ioli. ");
INSERT INTO lgl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ma talasi daro la, daro bi alaa 'adaroa sulia Jesus so'ela ioli daro dao tonada gi ala gulae tolo fo. ");
INSERT INTO lgl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Talasi rua wale ba gi daro latafa lo, nali wale gera sakea lou mae te wale 'i so'ela Jesus. Fokala wale fo 'e 'ato, sulia te aloe 'are ta'a 'e too ala. ");
INSERT INTO lgl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma Jesus ka balia aloe 'are ta'a fo faasia wale fo. Sui, wale fo ka sae lo. Ma ioli gera logo ala talasi fo li, gera ka kwele rasua 'alia, ma gera ka sae 'uri 'e, “Iko 'ali gia lelesia 'ua ta 'are 'uri 'e laola falua gia 'i Israel!” ");
INSERT INTO lgl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wasua ma Farasi gi, gera ka sosa saena 'uri 'e sulia Jesus, “Wale 'ilitoa ala aloe 'are ta'a gi li lo 'e kwatea nanatana fala wale 'e ka balia aloe 'are ta'a gi 'alia.” ");
INSERT INTO lgl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma talasi Jesus 'e liliu 'ala ala falua ba'ela gi ma mae falua wawade gi li, ka faalalau 'i laola luma fala foana gera gi li, ma ka fadaa Faronona 'Oka sulia Tatalona God, ma ka guraa ioli 'e matai 'alia mataina mamata gi sui. ");
INSERT INTO lgl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma Jesus 'e lesia ioli fo gi, ma ka amasi rasua ada sulia gera watoutou, ma iko 'ali gera totolia rananada 'i talada. Gera malaa sipsip iko ta wale fala liona sulida gi. ");
INSERT INTO lgl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma Jesus ka sae 'uri 'e fala waleli galona lia gi, “Ioli 'e gi gera malaa 'ai li 'ania afula gera funu 'alia fuae 'are afula la gi gera maua ma gera ka mada lo 'i laola raku. Wasua ioli li galona gi 'e iko 'ali gera afula 'ali gera talaida fala God. ");
INSERT INTO lgl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","'Urifo 'amu ka foa, ma 'amu ka sugaa God lia 'e ba'ela ala galo na, 'ali 'e kwatea mae ioli li galona gi 'ali gera talaida fala God.” ");
INSERT INTO lgl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus ka soia mae akwala wala rua wale li galona lia gi 'i so'ela, ma ka kwatea lo nanatana fada fala balianala aloe 'are ta'a gi, ma fala guranala mataina afula tootoo gi sui. ");
INSERT INTO lgl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ma ratala akwala wala rua wale li lifurono lia gi 'e 'uri 'e: etala, Simon (lia 'e soia lou 'alia Peter), failia walefae lia Andrew, ma James failia John, rua wela Sebedi gi. ");
INSERT INTO lgl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Batolomiu, Tomas, Matthew, wale ba fala golinala bata ala takisili, James wela Alfeas, Tadeas, ");
INSERT INTO lgl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, na wale ala alae Jiu gera oga balinala ioli 'i Rom gi faasia 'i Israel, ma Judas Iskariot wale ba kae kwatea Jesus fala malimae lia gi li. ");
INSERT INTO lgl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ma Jesus ka keria akwala wala rua wale fo gi, ka sae 'uri 'e, “Ikoso moulu la 'i safitala ioli mamata fo faasia Jiu gi li ma ikoso moulu ruu 'i laola tali falua ala ioli 'i Samaria gi. ");
INSERT INTO lgl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Moulu la mola fala ioli 'i Israel gi, gera malaa sipsip gera rero lo 'ada gi. ");
INSERT INTO lgl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ma talasi moulu la, moulu ka fatalo 'uri 'e, ‘Talasi God kae 'ilitoa fafia ioli lia gi li, 'e dao garani 'amiu lo!’ ");
INSERT INTO lgl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ma 'amu ka guraa ioli matai gi, ma 'amu ka taea ioli mae gi, ma 'amu ka guraa ioli kuu 'e fata'ada gi, ma 'amu ka balia aloe 'are ta'a gi. 'Amu sake gwaugwau ai, 'urifo 'amu ka kwate gwaugwau lou ai. ");
INSERT INTO lgl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Ioli 'e galo, 'e totolia ioli gi ka lio sulia. Lia fo talasi 'amu la, ikoso 'ali 'amu malata 'abero fala dauna fafia ta seleni. Ikoso 'amu sakea ta wai. Ma ikoso 'ali 'amu sakea ta rua to'omi 'o ma ta 'ae botu, 'o ma ta fe kuba wasua. ");
INSERT INTO lgl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ma ala 'amu dao ala ta falua, 'amu ka lio 'afia ta ioli 'e oga kae kwalo 'amiu fala 'i laola luma lia. Ma 'amu ka io failia ioli la la la ka dao ala talasi 'amu ka la faasia mae falua la li. ");
INSERT INTO lgl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Talasi 'amu ruu 'i laola ta luma, 'amu ka sae 'uri 'e fala ioli gera io 'i lifi la gi, ‘God kae fa'oka 'amiu, ma aroarona lia ka io fae 'amiu 'i laola luma 'e.’ ");
INSERT INTO lgl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ala ioli 'i laola luma la gi gera tau kwaima fae 'amiu, 'oilakina 'amiu kae io lou failida. Ma ala 'e iko, 'oilakina la ka oli lou mae 'i soemiu. ");
INSERT INTO lgl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ma ala 'amu dao ala ta falua, ma iko ta luma 'o ma iko ta ioli 'ali marabe mola fala kwalo namiu, 'o ma gera barasi 'alia rononala saenamiu, moulu ka la faasia lifi la. Talasi moulu ka la faasia, moulu ka tafula gora faasia 'aemoulu malaa faabasuna lo fada lia God kae kwai gera, dunala gera barasi 'alia rononala saenala God. ");
INSERT INTO lgl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma Lakae ilia 'are kwalaimoki famoulu, ala fe atoa fo God kae loko kwaikwaina fala molagali li, kwaikwaina kae kwatea fala ioli la gi li kae ba'ela ka liufia kwaikwaina God kae kwatea fala ioli ta'a ba 'i laola rua mae falua ba 'i Sodom failia 'i Gomora gi li.” ");
INSERT INTO lgl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ma Jesus ka sae lou 'uri 'e, “'Amu ka fafurono 'oka, lakae keri 'amiu fala nanana gi, sulia 'amu la lo malaa sipsip gi 'i so'ela ioli ta'a gera malaa kui kwasi gera oga fafuta'anamiu gi. Lia fo, 'amu ka liolio 'oka, ikoso 'ali 'amu tau ta me 'are rero 'ali gera suafafi 'amiu 'alida. ");
INSERT INTO lgl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","'Amu ka lio suli 'amiu, sulia ioli gi gera kae dau 'amiu, ma gera kae talai 'amiu 'i so'ela ioli lokomalata gi, ma gerakae rabusi 'amiu 'i laola luma li foana gera gi. ");
INSERT INTO lgl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dunala 'amu liu suli lau, gerakae tara 'amiu 'i so'ela wale etaeta failia walelitalona gera gi fala tolinikwaikwaina na famiu. Ma talasi gera tau kae 'urifo amiu, 'amu ka faarono 'alia Faronona 'Oka fada failia fala ioli mamataa fo faasia Jiu gi li. ");
INSERT INTO lgl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Talasi gera sake 'amiu 'i maala ioli li lokomalata gi, ikoso 'ali 'amu malata 'abero fala ta me 'are 'ali 'amu ilia ma 'amu kae sae 'utaa 'alida, sulia God lo kae kwatea alaana gi famiu fala ilinali ala talasi fo. ");
INSERT INTO lgl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ikoso 'ali 'amu alaa talifili 'amiu. Alo ala God Mama 'amiu 'i nali lo kae sae 'amiu. ");
INSERT INTO lgl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ioli afula gi, gerakae sakea walefae gera gera fitoo agu gi fala ioli gi 'ali gera raunida. Ma ioli afula gi lou, gerakae tau lou 'urifo ala wela gera gi lia gera fitoo agu. Ma wela afula gi lou, gerakae malimae lo ala mama ma teite gera gi, ma geraka sakeda 'i so'ela ioli gi fala rauninada. ");
INSERT INTO lgl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ioli afula gi, geraka malimae amiu sulia 'i 'amiu ioli li galona lau gi. Ma ta ioli mola 'ala kae fitoo nasi, la la ka dao ala suinala talasi ala nana na li, God kae faamauri lia. ");
INSERT INTO lgl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ala ioli ala ta falua gera malakwaita amiu, 'amu tafi, 'amu ka la faasia mae falua la nainali, ma 'amu ka la fala ta falua mamata. Lakae ilia famiu, 'ato 'ali 'amu faasuia mola galona 'amiu ala mae falua Israel gi li, 'i lao agu, Wela Wale li, lakae dao lo mae. ");
INSERT INTO lgl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ioli 'e kae raerae malata mola 'ala, iko 'ali ba'ela liufia ioli fo kae faalalau lia. Ma ioli li galona iko 'ali ba'ela liufia arai 'ilitoa lia. ");
INSERT INTO lgl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","'E 'oka fala ioli raerae malata 'ali malaa ioli li faalalau lia. Ma ta me 'are gera taua ala wale ba'ela, gera kae taua lou ala ioli li galona lia gi. Ma ala 'i lau, wale 'ilitoa 'amiu, gera soi lau 'alia Saetan wale ba'ela ala aloe 'are ta'a gi li, 'urila ma 'i 'amiu wasua, gerakae soi 'amiu lou 'alia ta ratae 'are 'e ta'a ka tasa.” ");
INSERT INTO lgl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jesus ka sae lou fala waleli galona lia gi 'uri 'e, “Ikoso moulu mau 'alia ioli. 'Are ioli 'e faagwaa, God kae fatailia. Ma 'are agwa gi sui, God kae sae sulida. ");
INSERT INTO lgl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma 'are lau ilia famiu 'i laola boni li, 'amu ilia lou ala matoula atoa. Ma 'are lau nuru 'alia famiu, 'amu ka sae abitakwa 'alia fala ioli sui. ");
INSERT INTO lgl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma ikoso 'ali 'amu maulia ioli kae raunia rabemiu ka mae, wasua ma 'e 'ato 'ali 'e raunia manoe 'are. 'Amu maulia mola God, sulia 'i lia lo totolia fafuta'anala manoe 'are failia rabe 'are 'i laola dunaa 'ago firi. ");
INSERT INTO lgl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ma malu wawade gi wasua 'e 'ato 'ali ta teke me malu ada ka toli 'i wado ala Mama 'amiu 'i nali ikoso 'ali ala'alia. ");
INSERT INTO lgl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ma 'i 'amiu wasua, ifula gwaumiu, God 'e sai sui ali. ");
INSERT INTO lgl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Lia fo ikoso 'ali amu mau, sulia God 'e malata ba'ela ala ioli gi ka liufia malu afula! ");
INSERT INTO lgl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ioli kae fulanailia 'e fakwalaimoki agu 'i maala ioli li, lakae fulanailia ioli fo lou fala Mama lau 'i nali. ");
INSERT INTO lgl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma ta ioli wasua 'ala 'e tofe fafi lau 'i maala ioli gi, lakae tofe lou fafia fala Mama lau 'i nali.” ");
INSERT INTO lgl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma Jesus ka sae lou 'uri 'e, “Ikoso moulu fia lou 'uri lau la mae failia aroarona fala molagali. Iko 'ali lau sakea mae aroarona. Lau la mae 'ali ioli fo iko 'ali gera fitoo agu gi, gera kae kwalaa failia ioli lau gi. ");
INSERT INTO lgl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Malimae ioli li, lia na ioli mola ala kwalofa lia. Sulia wela wale gi, gerakae kwalaa failia mama gera gi. Ma geli ulao gi, gerakae kwalaa failia teite gera gi. Geli wateu mae gi wasua, gerakae kwalaa failia funo geli gera gi. ");
INSERT INTO lgl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ma ta ioli 'e kwaima ala mama lia 'o ma teite lia ka liufi lau, 'i lia iko 'ali totolia dona nagu. Ma ta ioli 'e kwaima ala wela lia gi ka liufi lau, 'i lia iko 'ali totolia dona nagu. ");
INSERT INTO lgl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma 'e 'ato 'ali ta ioli 'ali dona lau malaa na wale li galona lau, ala iko 'ali 'e marabe fala dona nagu, wasua ka famalifii, ma ka mae ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma ta ioli 'e barasi 'ali 'e dona lau dunala 'e oga ka tau 'ala sulia kwaiogalina lia gi 'i talala, 'i lia kae talafia maurina firi. Wasua ma ala ta ioli iko 'ali tau sulia kwaiogalina lia gi 'i talala, ma ka marabe kae mae osiala 'e dona lau, 'i lia kae too ala maurina firi. ");
INSERT INTO lgl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ma ta ioli 'e kwalo 'amiu, 'e kwalo lau lou. Ma ta ioli 'e kwalo lau, 'e kwaloa lou God lia 'e kwate lau mae. ");
INSERT INTO lgl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma ta ioli 'e kwaloa profet, osiala 'i lia ioli 'e galo fala God, 'i lia kae sakea kwaiara malaa lou kwaiara fo God kae kwatea fala profet li. Ma ta ioli 'e kwaloa ioli rada, sulia ioli fo 'e rada, 'i lia kae sakea kwaiara malaa lo ioli rada. ");
INSERT INTO lgl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma lakae ilia 'are kwalaimoki famiu, ala ta ioli ka kwatea ta mae kwai gwari fala ta ioli ala wale li galona 'e lau gi, sulia 'i lia wale li galona lau, 'i lia kae sakea lou ta kwaiara.” ");
INSERT INTO lgl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Talasi Jesus 'e alaa ka sui lo fala akwala wala rua wale li galona lia gi, ka la lou fala fatalona 'alia Faronona 'Oka failia falalau nala ioli ala mae falua galia 'i Galili gi. ");
INSERT INTO lgl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ala talasi fo John wale fasiuabu 'e io 'i laola raraa, ka ronoa galona fo Jesus Christ 'e tauda gi, ma ka keria nali wale ala wale li galona lia gi daulu ka la 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ma daulu ka soilidi 'uri 'e ala, “'O famadakwa 'ameulu mae. 'Uri'e ma 'i'o lo 'e Christ 'e John 'e ilia kae dao mae, 'o ma 'ami ka masia lou 'amami ta wale mamata?” ");
INSERT INTO lgl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma Jesus ka olisi 'uri 'e adaulu, “Moulu oli, ma moulu ka faronoa John 'alia 'are 'e moulu ronoa ma moulu ka lesida gi. ");
INSERT INTO lgl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ioli maada koro gi, gera lio lo. Ma ioli 'aeda mae gi, gera ka liu lo. Ioli kuu fafuta'ada gi, rabeda ka mafo lo. Ma ioli aninada bali gi, gera ka rono lo. Ioli gera mae lo gi, gera maurifa'alu lou. Ma Faronona 'Oka ba, lau sae lo sulia fala ioli siofa gi. ");
INSERT INTO lgl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ma 'oilakina fala ioli iko 'ali too malata ruarua agu gi.” ");
INSERT INTO lgl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Talasi wale li galona John gi gera oli lo, Jesus ka sae sulia John fala logona fo 'uri 'e, “Ala talasi 'amu la 'i so'ela John 'i laola abae lifi kwasi li, ite 'amu la fala lesinala 'i lififo? Ta wale 'e malata ruarua ka malaa mola 'ala me gwano rade 'e saola ala oru li? Iko! John iko lou wale 'urifo. ");
INSERT INTO lgl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","'Uri'e ma, ta 'amu la fala lesinai? Ta wale 'e toro 'alia to'omi la folinai ba'ela? Iko! Sulia ioli fo gera toro 'urifo gi, gera io 'i laola luma walelitalona gi li. ");
INSERT INTO lgl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Moulu ilia ga mae. Ta 'e 'amu la ko fala lesinai? Ta profet? 'Eo! 'I lia na profet kwalaimoki lou! Ma 'i lia 'e liufia lou profet 'i lao gi sui. ");
INSERT INTO lgl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","John lo ba gera geregere sulia 'i laola Geregerena Abu ala talasi God 'e alaa fala Christ 'uri 'e, ‘Lio ga, lakae kwatea ko te wale li sake alaana lau 'i lao amu, 'ali lia kae rerei 'alia ioli gi famu.’ ");
INSERT INTO lgl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Lakae ilia me 'are kwalaimoki famiu, John 'e 'ilitoa ka liufia ioli gera futa mae 'i laola molagali 'e li sui. Wasua ioli wawade 'i laola 'Ilitoana God gi, gera 'ilitoa ka tasa liufia lou John. ");
INSERT INTO lgl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Fuli'ae ala talasi John 'e fuli'aea faatalona na 'alia Faronona 'Oka la la ka dao 'i tara'ela, ioli ta'a gi gera kwalaa failia 'Ilitoana God, ma gera tau fala launala 'Ilitoana God fala fafuta'a nai. ");
INSERT INTO lgl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Taki Moses gi, failia profet gi sui la la ka dao ala talasi John, gera faatalo mae sulia daonala Christ. ");
INSERT INTO lgl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Gera ilia Profet Elaeja kae oli lou mae 'i laoala Christ. 'E 'oka 'ali 'amu fakwalaimokia John lo Elaeja ba gera ilia. ");
INSERT INTO lgl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","'Amu ka fafurono 'oka fala alaana 'e lau gi.” ");
INSERT INTO lgl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma Jesus ka sae lou 'uri 'e fada, “Lakae fafuradania famiu io namiu ioli 'i tara'ela, 'amu malaa wela wawade gera logo 'i maala uusina 'alia rua logona gi li. Ma gera ka rii kwailiu fada, ");
INSERT INTO lgl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘'Ami ufi 'au, ma iko 'ali moulu wae mola sulia. Ma meulu nulia lo fe nuu sulia maenali famoulu, ma iko 'ali moulu kwaimalatai mola.’ ");
INSERT INTO lgl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Talasi John wale fasiuabu 'e dao mae, 'e abu fana, ma iko 'ali goufia ta waen, ma gera ka ilia 'uri 'e too ala aloe 'are ta'a. ");
INSERT INTO lgl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sui, talasi 'i lau, Wela Wale li, lau dao mae, lau fana ruru ma laka gou failia ioli gi, ma 'amu ka sae lou 'uri 'e, ‘Moulu lesia! 'E fana ba'ela, ma ka gou ba'ela ala waen, ma ka kwaima failia ioli gera goli bata ala takisi gi li ma ioli taunada ta'a gi lou.’ Wasua ma, ioli 'e gera ronosulia liotoo God gi, gera fatailia lia 'e God 'e kwalaimoki.” ");
INSERT INTO lgl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Burila Jesus 'e sae 'urifo ka sui, ka fuli'ae lo fala sae balubalua na fala mae falua ba 'e taua mae 'are mama'ala afula gi ali, sulia ioli ala mae falua fo gi li gera raria bulusina faasia ta'ana gera gi li. ");
INSERT INTO lgl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jesus ka sae 'uri 'e, “'E ta'a famiu ioli 'amu io 'i Koresin gi. Ma ioli 'amu io 'i Betsaeda gi ka 'urifo lou. Osiala iko 'ali 'amu fakwalaimokia 'are mama'ala afula ba lau tauda famiu gi. Ala gera taua 'are mama'ala fo gi 'i Taea ma 'i Saedon 'i lao, ioli 'i lififo gi gera ka gwauru 'i wado, ma gera ka rufia toro midia gi, ma gera ka farafurafua rabeda 'alia 'ora, 'ali ka fatailia gera bulusi sui lo faasia ta'ana gera gi. ");
INSERT INTO lgl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'Are kwalaimoki 'e lakae ilia famiu, ala fe atoa God kae kwaia iolila molagali, kwaikwaina 'amiu kae ba'ela ka liufia lo ioli 'i Taea failia Saedon gi. ");
INSERT INTO lgl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Ioli 'amu io 'i Kapaneam gi, 'amu fia God kae lafu 'amiu fala 'i nali. Wasua ma, 'i lia kae 'ui 'ala 'ali 'amiu 'i laola gilu ala famalifiina li. Sulia 'are mama'ala ba lau tauda 'i laola mae falua 'amiu gi li, ala laka taua 'are 'urifo gi 'i Sodom, 'urila ioli 'i Sodom gi gera ka bulusi lo, ma God ikoso manisia mola falua gera. ");
INSERT INTO lgl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Lia fo, Lakae ilia famiu, ala fe atoa God kae kwaia ioli ala molagali li, kwaikwaina 'amiu kae tasa ka liufia ioli 'i Sodom gi.” ");
INSERT INTO lgl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ala talasi fo, Jesus ka foa ka sae 'uri 'e, “Mama, 'i'o 'o 'ilitoa fafia 'are gi sui 'i nali ma 'i wado lou. Lau batafe 'o, dunala 'o fatailia 'Ilitoana 'o fala ioli 'e gera malaa wela wawade gi li, ma ko faagwaa 'are 'e gi faasia ioli 'e gera 'auraeda dunala gera too ala liotoo, ma geraka lio saiala 'are afula gi li. ");
INSERT INTO lgl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","'Eo Mama, 'are 'e gi 'e 'uri 'e lo sulia kwaiogalina 'o 'ua lo mae 'i lao.” ");
INSERT INTO lgl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ma Jesus ka sae 'uri 'e fala logona fo, “Mama lau 'e kwatea lo 'are gi sui fagu. Ma talifilia Mama mola 'e sai agu wela lia. Ma talifilia Wela mola 'i talala 'e saiala Mama lia, ma talifili ioli 'e Wela 'e filida gi ma ka fatailia Mama fada, gera mola gera saiala Mama.” ");
INSERT INTO lgl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Me saena nasi wale falalau ala taki Moses gera alua famiu gi, gera gulugulu fafii 'amiu. 'Amu la mae 'i soegu, 'ali lau lafua faasi 'amiu. ");
INSERT INTO lgl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ma 'amu ka ronosuli lau, ma lakae faalalau 'amiu, sulia falafala lau gi 'e kwaimaa ma ka aroaro, ma 'amu ka dao tonala mamalona fala manomiu. ");
INSERT INTO lgl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sulia kwai talai na lau amiu, 'e talawarau fala dona nai.” ");
INSERT INTO lgl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Talasi fo, ala na Sabat atoa ala mamalona li, Jesus failia wale li galona lia gi daulu la, ma daulu ka liu faifolo ala te raku ala witi li, 'are fala galofia nala berete li. Talasi fo, wale li galona lia gi gera fiolo, ma gera ka fisua funui 'are gi, ma gera ka 'anida. ");
INSERT INTO lgl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma nali wale ala Farasi gi gera lesida. Ma gera ka balufia Jesus 'uri 'e, “'O lesia! Me 'are 'e wale li galona 'o gi gera taua, 'e 'oia taki Moses gi, dunala moulu 'oia witi ala Sabat, atoa ala mamalona li!” ");
INSERT INTO lgl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma Jesus ka olisi 'uri 'e adaulu, “Lau saiai moulu idu sulia 'i laola Buka Abu me 'are ba David walelitalona 'e taua 'i lao. Ala talasi fo, David failia wale lia gi daulu fiolo rasua, ");
INSERT INTO lgl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'i lia ka la 'i laola luma God, ma fata abu 'ilitoa ka kwatea fala David berete la gera fa abua fala God. Ma David ka 'ania lo berete fo, ma ka kwatea lou fala wale lia gi, ma gera ka 'ania. Wasua taki gia ala'alia fala talifilia fata abu God gi mola gera saiala 'aninai. David 'e tau wasua 'ala 'urifo God iko 'ali kwaia mola.” ");
INSERT INTO lgl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma Jesus ka sae lou 'uri 'e, “Lau saiai moulu idu sulia 'i laola Buka Abu, taki fala fata abu gera galo 'i laola Luma Abu God ala Sabat, atoa ala mamalona li. Gera galo wasua 'ada 'urifo ala Sabat God iko 'ali kwaida mola. ");
INSERT INTO lgl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Lakae ilia famoulu, galona lau taua 'e ba'ela ka tasa liufia Luma Abu God, ma 'i lau 'e lo fae 'amiu. ");
INSERT INTO lgl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","'Eo, God 'e sae 'uri 'e, ‘Lau oga kwaiamasina ala ioli li, iko lou foasina 'amiu gi.’ Ma ala 'amu ka saiala malutala me 'are 'e, 'e 'ato 'ali 'amu ka loko kwaikwaina ala ioli lau gi, sulia iko 'ali gera rero mola. ");
INSERT INTO lgl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Dunala 'i lau, Wela Wale li, lau too ala nanatana fala iilinala me 'are fala ioli ma geraka taua mola 'ada ala fe atoa ala mamalona li.” ");
INSERT INTO lgl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ma talasi Jesus 'e la faasia lifi fo li, ka la 'i laola te luma fala foana li. ");
INSERT INTO lgl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma te wale limala mae 'e io lou 'i laola luma fo fala foana li. Ma nali ioli gera soilidia Jesus 'uri 'e, “'Uri'e ma 'e totolia mola 'ala fala guranala ioli matai gi ala Sabat, atoa ala mamalona li?” Gera soilidia 'urifo 'uri 'ali gera daria ta me 'are fala saena 'i maala Jesus ala 'oianala taki God ala gurana li. Gurana gera lesia 'alia galona. ");
INSERT INTO lgl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ala talasi fo, Jesus ka soilidi gera lou 'uri 'e, “'Amu faarono lau ga, ala ta ioli amiu, sipsip lia 'e toli 'i laola ta gilu ala Sabat, 'urifo ma ikoso 'ali lafua faasia gilu ala fe atoa fo? ");
INSERT INTO lgl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Moulu saiai, God 'e lio 'ilitoa ala ioli ka liufia sipsip. Sulia ioli 'e 'ilitoa 'urifo, iko 'ali rero mola fala taunala ta 'are 'oka fala ma rananala ala Sabat atoa ala mamalona li.” ");
INSERT INTO lgl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ala talasi fo mola lo, Jesus ka sae 'uri 'e fala wale fo limala 'e mae, “'O tadaa limamu.” Ma wale fo ka tadaa limala. Ma talasi fo mola, limala ba 'e mae ka 'oka lo malaa gula lima ba 'e 'oka mola 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Talasi Farasi gi gera lesia me 'are fo li, gera ka latafa sui 'i maluma. Ma gera ka logo fala loko malata na fala rauninala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Talasi Jesus 'e ronoa lia 'e gera logo fala loko malata na 'uri 'ali geraka raunia, 'i lia ka la lo faasia falua fo. Ioli afula gi, gera ka la sulia Jesus, ma ka guraa ioli afula gera matai gi, ma gera ka 'akwaa sui lo. ");
INSERT INTO lgl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma Jesus ka sae luida ikoso gera alaa sulia fala ta ioli lou. ");
INSERT INTO lgl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","'E tau 'urifo 'ali 'e fakwalaimokia saenala God ba profet Aesea 'e ilia 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wale li galona lau 'e, lau filia 'ali ma ka taua galona lau. Lau kwaima rasua ala, ma lau babalafe rasua 'alia. Lakae kwatea ko Aloe 'are lau 'ali ka io failia. Wale 'e kae kwatea lou lokomalatana rada fala ioli mamata faasia Jiu gi li. ");
INSERT INTO lgl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","'E iko 'ali 'e io 'alia alafaitalili na, ma iko 'ali'e akwa baela, ma iko 'ali sae 'auraea 'i talala maala falua gi. ");
INSERT INTO lgl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","'E iko 'ali 'e taasi faeburi 'alia ioli siofa ma ioli watoutou gi. Ma 'i lia kae kwatea loko malatana rada fala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Wale 'e lo, ioli afula faasia falua gi sui, gera kae fitoo ala.” ");
INSERT INTO lgl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sui burila, nali ioli gera sakea mae te wale 'i so'ela Jesus fala guranala. Wale fo, aloe 'are ta'a 'e sura ala, failia maala ka koro, ma fokala ka 'ato. Ma Jesus ka guraa wale fo, ma ka lio ma ka sae lou. ");
INSERT INTO lgl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Te logona fo ka kwele rasua, ma gera ka soilidi kwailiu 'uri 'e, “'Uri'e ma wale 'e lo wale ba God 'e filia, ma kae futa mae ala kwalofa ba David walelitalona li?” ");
INSERT INTO lgl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma talasi nali Farasi gera ronoa me 'are fo gi li, gera ka sae 'uri 'e, “Iko lou 'i lia 'e. Jesus 'e balia aloe 'are ta'a gi 'alia nanatanala Saetan 'ilitoe aloe 'are ta'a gi.” ");
INSERT INTO lgl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma sulia Jesus 'e sai mola 'ala ala malatada, ka sae 'uri 'e fada, “Ala alae ioli 'i laola ta falua ba'ela gera kwalaa mola 'i matanada talada, 'urila falua ba'ela fo kae tagalo lo. Ma ala ta falua, 'o ma ta wale, failia wateu, failia wela lia gi, daulu kwalaa mola 'i matanadaulu taladaulu, 'e 'ato 'ali daulu ka io ruru. ");
INSERT INTO lgl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma tatalona Saetan 'e 'urifo lou. Ala Saetan kae kwalaa failia ioli 'e gera liu sulia gi, 'urila gera kae tagalo kwailiu. ");
INSERT INTO lgl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“'Eo, ma moulu ilia lau balia aloe 'are ta'a gi 'alia nanatanala Saetan. 'Urilali ma nanatanala ite 'e nali wale li galona 'amoulu gera balia aloe 'are ta'a gi 'alia? Saetan? 'E iko mola! 'Are fo gi, gera fatailia lia 'e 'amu rero. ");
INSERT INTO lgl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Lau balia aloe 'are ta'a gi 'alia nanatanala God. Ma 'i lia ka fatailia lo famiu lia 'e Tatalona God fafia ioli gi li 'e dao garani lo mae 'i soemiu. ");
INSERT INTO lgl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ala ta ioli mola 'ala 'e oga ka balia ta aloe 'are ta'a, ioli la ka nanata ka liufia Saetan. 'E malaa lou te wale 'e oga kae ruu 'i laola luma na wale nanata fala sakenala 'are lia gi li. 'I lia ka nanata ka liufia lou wale fo, 'ali 'e totolia firinala wale nanata fo, sui bui ka bi sakea 'are lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ioli 'e iko 'ali dona buri agu, 'i lia malimae lau. Ma ioli 'e iko 'ali kwairanai agu fala logosinala mae ioli gi 'i so'ela God, 'i lia kae tagalailia ioli faasia God. ");
INSERT INTO lgl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Sulia 'e 'urifo, laka ilia famiu, God 'e saiai kae kwailufa 'alia ta'ana ioli 'e taua ma 'are ta'a 'e ilida gi. Ma ala ta ioli 'e sae ta'a fagu, Wela Wale li, God 'e saiai kae kwailufa 'alia. Wasua ma ala ta ioli ka sae fafuta'a galona Alo ala God, 'ato rasua 'ali God kwailufa 'alia ioli la, ala talasi 'e, 'o ma talasi kae lao mae gi.” ");
INSERT INTO lgl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesus ka sae lou 'uri 'e, “Moulu saiai ala 'amu too ala 'ai 'oka, fuala wasua ka 'oka lou. Ma ala 'amu too ala 'ai ta'a, fuala wasua ka ta'a lo lou. 'Urifo lou ala ioli. Sulia 'are 'oka gi 'e la mae faasia ioli 'oka, ma 'are ta'a gi ka la mae faasia ioli ta'a. ");
INSERT INTO lgl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ma 'amu malaa mola 'amiu kale wa gi! Ma 'ato rasua 'amu ka ilia ta 'are ka 'oka, sulia malata 'amiu gi 'e ta'a. Ta 'i laola manola ioli, lia lo kae manotafa mae 'i fokala. ");
INSERT INTO lgl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ioli 'e 'oka, saenala wasua kae 'oka lou. Ma ioli 'e ta'a, saenala wasua kae ta'a lou. ");
INSERT INTO lgl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Lakae ilia famiu, talasi ala kwaikwaina li, God kae kwaia ioli gi sui 'i laola molagali fala alaana ta'a gera ilida gi. ");
INSERT INTO lgl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma God kae loko kwaikwaina fala ioli 'alia saenada 'i talada. Ala alaana ta ioli ka 'oka, God kae fulanailia ioli la 'e rada. Ma ala alaana ta ioli ka ta'a, God kae fulanailia ioli la 'e rero.” ");
INSERT INTO lgl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sui nali wale falalau ala taki gi failia nali Farasi, gera la mae 'i so'ela Jesus, gera ka sae 'uri 'e fala, “Waleli Falalauna, meulu oga rasua ko taua ta 'are mama'ala, 'ali fatailia kwalaimoki ala lia 'e God 'e kwate 'o mae.” ");
INSERT INTO lgl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus ka sae 'uri 'e fadaulu, “'Amiu iolila talasi'e, 'i 'amu ioli ta'a gi. Dunala 'amu oga lesinala 'are mama'ala kae fatailia nanatanala God, wasua ma 'e 'ato famiu fala lesinai. 'Amu kae lesia mola 'amiu 'are mama'ala malaa 'are ba 'e fuli fala profet ba 'i lao Jona. ");
INSERT INTO lgl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona ba 'e io 'i laola ogala gwaa rasu sulia olu fe atoa, ma olu fe boni gi. Ma 'i lau, Wela Wale li, lakae 'urifo lou. Lakae io 'i laola wado sulia olu fe atoa ma olu fe boni gi. ");
INSERT INTO lgl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Talasi God kae loko kwaikwaina fala ioli li, ioli gera io 'i Ninifa gi, gera kae tatae 'ali gera ka alaa sulia rerona 'amiu gi. Gera kae tau 'urifo, sulia gera bulusi lo faasia ta'ana gera gi, ala talasi Jona 'e fulanailia fada. Ma te wale 'e 'ilitoa ka liufia Jona 'e io lo fae 'amiu. 'E 'urifo wasua, iko 'ali 'amu bulusi mola faasia ta'ana 'amiu gi. ");
INSERT INTO lgl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ma talasi God kae loko kwaikwaina fala ioli li, geli 'ilitoa ba 'i Siba, kae tatae lou fala alaana sulia rerona 'amiu gi. Te geli fo kae tau 'urifo, sulia 'e la mae faasia falua lia 'e tatau rasua fala rononala Solomon walelitalona. Ma te wale 'e 'ilitoa ka liufia Solomon 'e io mola 'ala fae 'amiu. 'E 'urifo wasua, iko 'ali 'amu oga mola rononala.” ");
INSERT INTO lgl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesus ka sae lou 'uri 'e, “Talasi gera balia aloe 'are ta'a faasia ta ioli, 'i lia kae liu lo 'ala 'i laola lifi kwasila, ma ka lio 'afia ta lifi 'ali 'e io lou ai. Ma ala 'e liolio ma ka iko lo, ");
INSERT INTO lgl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kae malata 'uri 'e, ‘Lakae oli fala ioli ba lau ioio mae ala 'i lao, ma laka la mae faasia. Ala talasi 'e oli mae ka dao, ka lesia ioli ba 'e sogolia ma ka farada lo maurinala sui. ");
INSERT INTO lgl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Talasi 'e lesia 'e 'urifo, ka oli ma ka talaia lou mae na fiu aloe 'are daulu ta'a ka rasua liufia 'i lia, daulu ka la mae, ma daulu ka io lo 'i laola ioli fo. Ala talasi fo, ionala ioli fo ka bi ta'a ka liufia lo 'i lao. Ma kae 'urifo lou famiu ioli talasi'e gi, 'amu ioli ta'a gi, ma ionamiu ka bi ta'a ka liufia lo 'i lao, sulia 'amu barasi 'ali lau.” ");
INSERT INTO lgl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Talasi Jesus kae alaa 'ua fala ioli fo gi li, teite lia failia walefae lia gi daulu ka dao mae. Ma daulu ka ura mola 'adaulu 'i maluma, ma daulu ka sae mae fala 'ali daulu ka alaa failia. ");
INSERT INTO lgl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma na wale ala logona fo ka sae 'uri 'e fala Jesus, “Teite 'o failia walefae 'o gi, daulu ura mola mae 'adaulu 'i maluma, ma daulu oga 'ali daulu alaa fae 'o.” ");
INSERT INTO lgl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus ka olisi 'uri 'e adaulu, “Lakae ilia ioli 'e teite lau failia walefae lau gi li.” ");
INSERT INTO lgl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ala talasi fo, Jesus ka uusua wale li galona lia gi, ma ka sae 'uri 'e, “'Amu lesia ga. Gera lo gera malaa lo teite lau gi failia walefae lau gi. ");
INSERT INTO lgl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sulia ioli 'e tau sulia liola Mama lau 'i nali, lia lo walefae lau, failia gelifae lau, ma teite lau.” ");
INSERT INTO lgl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ala fe atoa fo lou, Jesus ka latafa faasia luma fo, ma ka la 'i rabela 'osi, ma ka gwauru 'i fua fala falalauna. ");
INSERT INTO lgl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma sulia logona ba'ela rasua gera logo galia, ka rae 'i laola te baru, ma ka gwauru 'i laola, ma ioli gi gera ka ura ko 'i sulia ole. ");
INSERT INTO lgl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sui ka falalau gera 'alia 'are afula gi 'alia alaana tarifulaana gi, ka sae 'uri 'e, “Te wale 'e la ka taasi 'alia fufuae witi gi 'i laola raku lia. ");
INSERT INTO lgl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma talasi 'e taasi 'alia fufuae witi fo gi li, nali fufuae witi gera toli sulia talaliliu, ma malu gi gera ka lofo mae, ma gera ka 'anida sui. ");
INSERT INTO lgl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma nali fufuae witi gera ka toli ala lifi faufaua gi, lifi la wado iko 'ali ba'ela. Ma gera ka bulao nainali sulia liafo wado iko 'ali 'e afula. ");
INSERT INTO lgl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma talasi da'afi 'e tatae mae, ka daafia witi 'e bulao gi, gera ka kuku lou, sulia kalokaloda iko 'ali sifo lalo. ");
INSERT INTO lgl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma nali fufuae witi gera toli 'i safitala kwalo karakaraa gi, ma kwalo fo gi ka ba'ela fafia witi gi. ");
INSERT INTO lgl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma nali fufuae witi lou 'e toli 'i laola wado 'oka, ma talasi gera tatae mae, gera ka funu 'alia fuae 'are afula gi. Ma nali witi gera ka funu 'alia teke talanae fuae 'are, ma nali witi gera ka funu 'alia olo akwala fuae 'are, ma nali witi lou gera ka funu 'alia olu akwala fuae 'are.” ");
INSERT INTO lgl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ma Jesus ka faasuia saenala 'uri 'e, “Ala ta ioli 'e oga ka sai 'oka ala 'are 'e gi, 'i lia ka fafurono 'oka.” ");
INSERT INTO lgl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Waleli galona lia gi daulu la mae 'i so'ela, daulu ka soilidi 'uri 'e ala, “'Uta 'e ko sae fala ioli 'alia saena ala tarifulaana gi li?” ");
INSERT INTO lgl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus ka olisi 'uri 'e adaulu, “Talasi sui gi, God iko 'ali'e faamadakwa kae 'ilitoa 'utaa fafia ioli lia gi. Wasua ma talasi'e, madakwana 'e dao lo famiu. Ma ioli 'e iko lou wale li galona lau gi li, iko 'ali lau faamadakwa fada. ");
INSERT INTO lgl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ite 'e too ala ta madakwana wawade sulia Tatalona God, God kae kwate ba'ela 'ala, 'ali 'e too ala madakwana ba'ela ka ali'afu. Ma ioli iko 'ali ronosulia faalalauna 'e gi li, ta madakwana wawade wasua 'e too ai sulia Tatalona God, God kae olifailia faasia. ");
INSERT INTO lgl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Lau sae fala ioli 'alia alaana tarifulaana gi, sulia gera lesia lo 'are lau tauda gi, wasua ma iko 'ali gera lio fakwalaimokida. Gera ronoa alaanagu, wasua ma iko 'ali gera malinailia. ");
INSERT INTO lgl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","'E 'uri 'e 'ali ka fakwalaimokia alaana ba profet Aesea 'e ilia 'i lao ba 'e sae 'uri 'e, ‘Gera kae fafurono ma gerakae fafurono, wasua ma ikoso gera saiala faronona 'oka God. Ma gera kae lio ma gera kae lio, wasua ma ikoso gera lesia ta 'e God kae taua fada. ");
INSERT INTO lgl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sulia malatada 'e oeda, ma geraka bolosia lo aninada, ma geraka bolosia lou maada. Taufasia maada ka bi lesia, 'o ma aninada ka bi ronoa, ma malatada ka malinailia saenala God, ma geraka bulusi mae 'i soegu ma laka gurada.’” ");
INSERT INTO lgl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma Jesus ka sae lou 'uri 'e, “'Oilakina rasua famiu, sulia lia 'e maamoulu 'e lesia lo galona lau tauda gi, failia aninamoulu ka ronoa falalauna lau gi. ");
INSERT INTO lgl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","'Are kwalaimoki lakae ilia famoulu, profet afula gi, failia ioli rada 'i lao gi, gera oga rasua ala lesinala 'are 'e 'amu lesida gi, wasua ma iko 'ali gera lesida. Ma gera oga rasua lou ala rononala 'are 'e 'amu ronoda gi, ma iko 'ali gera ronoda. ");
INSERT INTO lgl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“'Amu fafurono fala fadanala tarifulaana sulia wale 'e taasi fufuae witi gi li. ");
INSERT INTO lgl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nali ioli gera ronoa faronona sulia Tatalona God, ma iko 'ali gera malinailia, sui Saetan ka la mae, ma ka laua lo saenala God faasida. Gera malaa fufuae witi 'e gera toli sulia talaliliu, ma malu ka 'anida. ");
INSERT INTO lgl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma fufuae witi fo gera toli 'i fofola wado faufaua li, 'e malaa ioli fo gera ronoa saenala God, ma gera ka sakea 'alia babalafena. ");
INSERT INTO lgl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wasua ma, saenala God iko 'ali laliu mola 'i laola maurinada. Gera fakwalaimoki mola sulia me talasi wawade. Ma talasi ilitoona ma malakwaitana 'e dao mola ai, dunala gera fakwalaimoki ala saenala God, iko 'ali gera fitoo lo. ");
INSERT INTO lgl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma nali ioli gera malaa fufuae witi fo gera toli 'i safitala kwalo karakaraa gi li. Gera ronoa saenala God, wasua ma gera malata 'abero 'ada sulia 'are afula 'i laola maurina gera gi li, ma gera ka malata ba'ela ala bata. Ma 'are fo gi, 'e malaa kwalo karakaraa gi lia 'e ba'ela fafia saenala God 'i laola maurinada. 'E iko 'ali gera olisi mola 'i laola maurinada ka malaa witi fo iko 'ali gera funu mola 'ali ta fuae 'are gi. ");
INSERT INTO lgl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma nali ioli lou gera malaa fufuae witi gera toli 'i laola wado 'oka li. Gera ronoa saenala God, ma gera ka malinailia, ma geraka fatailia iona rada ka malaa witi fo 'e funu 'alia fuae 'are gi li. Nali witi te talanae fuae 'are ma nali witi olo akwala fuae 'are ma nali witi olu akwala fuae 'are.” ");
INSERT INTO lgl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus ka ilia lou te tarifulaana fada 'uri 'e, “Tatalona God 'e malaa wale la 'e fasia fufuae 'are gi 'i laola raku lia. ");
INSERT INTO lgl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma ala na fe boni, talasi ioli gi gera mo'osu 'ada, malimae ka la mae ma ka fasia nali fufuae fasifasi ta'a 'i safitala fufuae 'are 'oka lia gi. Sui ka la 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ma talasi fufuae 'are 'oka gi gera bulao mae, ma gera ka fuli'ae li funu lo, fufuae fasifasi ta'a ba gi gera ka bulao lou. ");
INSERT INTO lgl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ioli li galona lia gi, gera la mae 'i so'ela, ma geraka soilidia 'uri 'e, ‘Arai wale'e, 'o fasia fufuae 'are 'oka gi li ba. Ma fasifasi lobaa gi gera la mae faasia 'i fe?’ ");
INSERT INTO lgl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ma ka olisi 'uri 'e ada, ‘Ta malimae lo laa 'e taua me 'are la.’ Ma ioli li galona lia gi, gera ka soilidia 'uri 'e, ‘'O oga meulu ka la ma meulu ka failia fasifasi ta'a fo gi?’ ");
INSERT INTO lgl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Lia ka olisi 'uri 'e adaulu, ‘Iko, taufasia talasi 'amu kae failia fasifasi lobaa gi li, 'amu bi fafuta'a lou tali 'ai 'oka failida. ");
INSERT INTO lgl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","'Amu alua daro tatae ruru lo 'adaroa la la ka dao ala talasi li fisu 'are. Ma talasi fo, lakae sae 'uri 'e fala ioli gera kae golia 'are lau gi li: 'Amu lafua fasifasi gi 'i lao, ma 'amu ka firi logosida, ma 'amu ka 'agofida. Sui 'amu ka bi lafua 'are 'oka gi, ma 'amu ka sakea mae fala 'i laola luma li alu goli 'are 'agua.’” ");
INSERT INTO lgl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sui Jesus ka ilia lou te tarifulaana 'uri 'e, “Tatalona God 'e 'uri 'e: Te wale 'e sakea fufuae 'ai wawade rasua gera soia 'alia mastad, ma ka fasia 'i laola raku lia. ");
INSERT INTO lgl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma fufuae 'are fo 'e wawade rasua ala fufuae 'are gi sui, ma talasi 'e tatae mae ai, 'e alua lo te 'ai 'e ba'ela ka liufia lo 'ai gi sui 'i laola raku fo li. Ma talasi 'ai fo 'e ba'ela ka ulua, fe malu gi gera ka raunailia tatafe gera gi ala rarala 'ai fo.” ");
INSERT INTO lgl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sui Jesus ka sae lou 'alia na tarifulaana 'uri 'e, “Tatalona God 'e malaa ist wawade fala fafalenala berete li, lia te geli 'e sakea ma ka dolaa failia flaoa afula, la la ka rufia sui suufau li flaoa fo ka fale.” ");
INSERT INTO lgl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus 'idufae alaa mola 'ala sulia 'are 'e gi 'alia tarifulaana fala logona fo. ");
INSERT INTO lgl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","'E tau 'urifo 'ali ka fakwalaimokia alaana God lia profet 'e gerea ka sae 'uri 'e, “Lakae sae 'alia tarifulaana gi fala ioli. Ma lakae fada 'are laa gi iko 'ali gera fada madakwa ai 'i lao fuli ala talasi lau raunailia molagali li.” ");
INSERT INTO lgl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sui Jesus ka tafisia lo logona fo ma ka ruu 'i laola luma. Ma wale li galona lia gi daulu ka dao 'i so'ela, ma daulu ka sae 'uri 'e, “'O fadaa ga fameulu tarifulaana ba sulia fasifasi ta'a 'i laola raku li.” ");
INSERT INTO lgl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Lia ka olisi 'uri 'e adaulu, “Wale fo 'e fasia fufuae 'are 'oka gi li, 'i lia lo 'i lau, Wela Wale li. ");
INSERT INTO lgl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma raku, molagali, ma fufuae 'are 'oka gi lo ioli 'i laola Tatalona God gi. Ma fasifasi fo gi ioli gera ronosulia Saetan gi. ");
INSERT INTO lgl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma malimae 'e fasia fasifasi gi li lo Saetan. Ma talasi ala fisu 'are na li lo suinala molagali, ma ioli gera fisu 'are gi lo eniselo gi. ");
INSERT INTO lgl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Talasi ioli li galona gi gera golia fasifasi li, ma gera ka 'agofia 'i laola dunaa li, 'e malaa lou suinala molagali. ");
INSERT INTO lgl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Lakae kwatea eniselo gi, 'ali gera logosia ioli gera taua 'are ta'a gi, failia ioli gera fareroa ioli li, ma eniselo gi gera kae lafuda faasia tatalona lau. ");
INSERT INTO lgl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma gera ka taasi 'ali gera 'i laola dunaa, lifi la gera kae ani, ma gera kae 'ala niriniritae ma gerakae giria lifoda. ");
INSERT INTO lgl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ioli rada gi, gera ka tala malaa da'afi 'i laola tatalona Mama gera li. Moulu malata 'oka sulia 'are 'e gi.” ");
INSERT INTO lgl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesus ka sae lou 'uri 'e fala wale li galona lia gi, “Tatalona God 'e malaa bata ba'ela gera faa agwaa 'i laola raku li. Ma talasi te wale 'e lesia, 'i lia ka faagwaa lou 'ala. Ma 'e babalafe rasua, ma ka la ma ka foli 'alia 'are lia gi sui, ma ka folia lo raku fo, 'ali 'e sakea 'ala bata ba'ela fo 'e 'eli fafia 'i laola. ");
INSERT INTO lgl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ma Tatalona God 'e malaa lou wale foli 'ali 'are la 'e lio 'afia fufuae roa iroiroa 'oka lia folinai 'e ba'ela rasua. ");
INSERT INTO lgl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Talasi 'e daria fufuae roa iroiroa fo liunai 'e ba'ela rasua li, ka la, ka li foli 'alia 'are lia gi sui, sui ka folia lo. ");
INSERT INTO lgl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Tatalona God 'e malaa lou fuo gera kwaiasi 'alia 'i laola asi li, ma gera ka alasia 'alia ke kale ia afula mamata gi sui. ");
INSERT INTO lgl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ma talasi 'e fonu, ioli gera kwaiasi gi gera taraa 'i rara, ma gera ka gwauru 'i wado. Sui gera ka golia lo ia 'oka gi 'i laola apira gi, ma gera ka taasi 'alia ia ta'a gi. ");
INSERT INTO lgl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'E 'urifo lou ala suinala molagali. Eniselo gi gerakae la mae, ma gera kae tolinia ioli ta'a gi faasia ioli 'oka gi. ");
INSERT INTO lgl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ioli ta'a gi, gera kae taasi 'alida 'i laola dunaa, ma 'i lififo gera kae ani, ma gera kae 'ala niriniritae ma gera kae giria lifoda.” ");
INSERT INTO lgl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sui Jesus ka soilidi 'uri 'e adaulu “Moulu saiala 'are 'e gi?” Ma geraka olisi 'uri 'e ala, “'Eo.” ");
INSERT INTO lgl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma Jesus ka sae 'uri 'e fadaulu, “'Amoulu lo ioli lau faalalau 'amoulu gi. 'Urifo 'amu ka faalalau 'alia alaana sulia Tatalona God. Moulu sai 'oka ala Geregerena Abu 'i laola Alafuuna 'Ualo failia alaana fa'alu 'e lau gi.” ");
INSERT INTO lgl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ala talasi Jesus 'e alaa 'alia tarifulaana fo gi ka sui, ka la lo faasia mae falua fo. ");
INSERT INTO lgl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma ka oli lou mae ala mae falua lia 'i Nasareti. Ma ka la 'i laola luma fala foana li fala falalaunala ioli gi. Ma talasi ioli gi gera ronoa, gera ka kwele rasua, ma gera ka sae 'uri 'e, “Ma nanatana ala ite 'e kwate ka faalalau 'alia saenala God 'uri 'e, failia taunala 'are mama'ala gi? ");
INSERT INTO lgl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Golu sai mola 'agaulu ala wale 'e, 'i lia wela Josef mola tae, wale 'e saiala raunailinala 'are 'alia 'ai li, ma teite lia mola Mary. Ma walefae lia gi mola James, Josef, Simon, ma Judas. ");
INSERT INTO lgl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma gelifae lia gi, gera io mola 'ada fae golu 'i lifi'e. 'Uta 'e ka too rasua ala liotoo 'uri 'e?” ");
INSERT INTO lgl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma talasi fo, gera ka barasi 'alia Jesus. Sui Jesus ka sae 'uri 'e fada, “profet 'e 'ato fala 'alia walefae lia gi failia ioli ala mae falua lia gi li, 'ali gera ka lio 'ato ala.” ");
INSERT INTO lgl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma Jesus iko 'ali taua tali 'are mama'ala afula ala mae falua lia, sulia ioli fo gi, gera barasili fitoo ala. ");
INSERT INTO lgl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma ala talasi fo, Herod Antipas walelitalona 'i Galili, 'e ronoa faronona sulia Jesus, ");
INSERT INTO lgl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ma ka sae 'uri 'e fala ioli gera galo failia gi, “Wale 'e, 'i lia John wale fasiuabu lia 'e maurifa'alu lou! Lia 'e kae taua lou 'are li kwelena gi.” ");
INSERT INTO lgl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ala talasi John 'e mauri 'ua, Herod 'e tolea Herodias wateu walefae lia Filip. Ma John ka balufia Herod 'uri 'e, “Taki God 'e iko 'ali alafafia 'ali 'o tolea wateu walefae 'o li.” Lia fo Herod ka keria nali wale 'ali geraka doia John, gera ka firia, ma gera ka alua 'i laola raraa. Herod 'e taua me 'are fo sulia wateu lia Herodias lo 'e oga. ");
INSERT INTO lgl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ala talasi John 'e io 'i laola raraa li, Herod ka ogaa rasua rauninala, wasua ma 'e mau 'alia ioli, sulia gera ilia John 'i lia te profet. ");
INSERT INTO lgl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sui ala na fe atoa, Herod ka galofia te fanana ba'ela fala malatainala fe atoa 'e futa ai. Ala fanana fo, ulao Herodias 'e la mae ka wae fala Herod failia kwaima lia gi 'ali gera lesia. Talasi Herod 'e lesia ulao fo 'e wae, ka babalafe rasua 'alia. ");
INSERT INTO lgl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ma ka etae alafu lo fala ulao fo 'uri 'e, “Lakae kwatea ta taa mola 'ala 'o suga agu.” ");
INSERT INTO lgl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Teite ulao fo li ka alaa fala ulao fo, ka sae 'uri 'e, “'O sugaa, ko sae 'uri 'e, ‘Lau oga ko kwatea mae gwaula John wale fasiuabu fagu ala me talasi 'e lo. 'O alua mae 'i fofola ta tete 'are.’” Ma ulao fo ka tau lo 'urifo sulia saenala teite lia. ");
INSERT INTO lgl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma talasi Herod 'e ronoa me 'are fo li, ka kwaimalatai rasua. Wasua, 'e taua lo 'ala, sulia 'e etae alafu lo, ma kwaima lia gi gera ka ronoa sui lo. ");
INSERT INTO lgl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma ka keria wale li galona lia gi geraka 'ole mousia mae gwaula John wale fasiuabu 'i laola raraa. ");
INSERT INTO lgl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma gera ka sakea mae gwaula John 'i fofola tete 'are, ma gera ka kwatea lo fala ulao fo Herodias. Ma ulao fo ka sakea ka kwatea lo fala teite lia. ");
INSERT INTO lgl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Talasi wale li galona John gi gera ronoa me 'are fo li, gera ka la mae, gera ka sakea rabela, geraka alomia lo 'i laola gilu. Sui, geraka la geraka faronoa Jesus 'alia. ");
INSERT INTO lgl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ala talasi Jesus 'e rono sulia me 'are fo 'e fuli fala John li, ka tafisia lo lifi fo, ma ka la talifilia 'i laola baru fala lifi la iko ta ioli 'ali io ai. Ioli gera rono ai, ma gera ka tafisia falua gera gi, ma geraka la lo 'i burila Jesus sulia tala. ");
INSERT INTO lgl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma talasi Jesus 'e sifo ma ka lesia logona ba'ela fo li, ka amasida, ma ka guraa ioli gera matai gi. ");
INSERT INTO lgl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma ala fe raurafi fo, wale li galona lia gi gera la mae 'i so'ela, ma gera ka sae 'uri 'e, “Lifi 'e iko 'ali io garania ta falua, ma kae garani boni lo. 'O keria logona 'e 'ali gera la lo 'ada, 'ali gera ka la fala mae falua 'i lifi'e gi li 'ali gera foli fana 'ada.” ");
INSERT INTO lgl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus ka olisi 'uri 'e adaulu, “Ikoso 'ali gera la. 'Amoulu lo moulu kwatea fana 'ada.” ");
INSERT INTO lgl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma daulu ka olisi 'uri 'e ala, “Meulu too mola ala lima fe berete gi failia rua lode ia gi.” ");
INSERT INTO lgl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma Jesus ka sae 'uri 'e fadaulu, “Moulu sakeda mae 'i lifi 'e 'i soegu.” ");
INSERT INTO lgl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma ka taua ioli gi gera ka gwauru 'i wado 'i laola fasifasi. Sui ka sakea lima berete fo gi ma rua lode ia fo gi. Ma ka lio ala ala fala 'i nali, ma ka batafea God. Sui ka liia berete fo gi, ma ka kwatea fala wale li galona lia gi, ma daulu ka tolinia fala ioli fo gi. ");
INSERT INTO lgl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ioli fo gi sui gera fana la la gera ka bote. Sui wale li galona lia gi ka golia fana 'e ore gi 'i laola teke akwala wala rua pera, la la gera ka fonu sui. ");
INSERT INTO lgl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ioli fo gera fana gi 'e totolia lima to'oli wale, ma iko 'ali gera idumia mola geli gi failia wela gi. ");
INSERT INTO lgl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","'I burila 'are fo, Jesus ka keria wale li galona lia gi gera ka etaeta fala na gula ala 'osi fo 'i laola baru. Ma 'i lia ka io 'ala 'i buri 'ali ketaa logona fo. ");
INSERT INTO lgl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ma 'i burila ioli gi gera oli lo, 'i lia ka rae talifilia gwaula me raraena 'ali foa. Ma ala fe boni fo, 'e io lo 'ala talifilia 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma talasi fo, baru ba 'e tatau lo faasia 'i rara, ma lafolafo ka fotoia sulia 'e laofia oru. ");
INSERT INTO lgl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma ala malui boni 'ofaedani, Jesus ka liu lo mae 'i fofola kwai, ma ka la lo mae 'i soedaulu. ");
INSERT INTO lgl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ma talasi daulu leesia kae liu mae 'i fofola kwai li, daulu ka mau rasua. Ma daulu ka rii 'uri 'e, “Te aloe 'are!” Ma daulu ka akwa babali. ");
INSERT INTO lgl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma nainali mola Jesus ka sae 'uri 'e fadaulu, “Moulu ala mau na! 'I lau mola tae.” ");
INSERT INTO lgl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma Peter ka olisi 'uri 'e ala, “Aofia, ala 'i'o kwalaimoki mola la, 'o sae mae fagu 'ali lau liu ko fala 'i soemu 'i fofola kwai 'e.” ");
INSERT INTO lgl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus ka sae 'uri 'e, “'Eo, 'o la mae.” Sui Peter ka sifo faasia baru, ma ka fuli'ae li liulo 'i fofola kwai fala 'i soela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sui ala talasi 'e lesia oru ba'ela li, lia ka mau ma ka fuli'ae ka wawalo lo 'i laola kwai. Ma ka rii 'uri 'e, “Aofia, 'o faamauri lau!” ");
INSERT INTO lgl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma nainali mola Jesus ka kwate lima ko fala, ka dau ala, ma ka sae 'uri 'e, “Me fitoona 'o 'e wawade rasua. 'Uta ko malata ruarua agu?” ");
INSERT INTO lgl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma ala talasi daro rae lo 'i laola baru li, oru ka aroaro lo. ");
INSERT INTO lgl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Urifo mola ioli gera io 'i laola baru li, gera ka faa aofia geraka sae 'uri 'e, “'E kwalaimoki 'i'o Wela God.” ");
INSERT INTO lgl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ma talasi daulu tofolo 'i laola 'osi li, daulu ka sifo lo ala te mae falua gera soia 'alia Genesaret. ");
INSERT INTO lgl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ioli ala mae falua fo gi li, gera ka lio raea Jesus. Ma gera ka kwate saena fala nali mae falua lou sulia Jesus, 'ali ioli fo gi, gera ka sakea mae ioli matai gera gi 'ali gera la mae 'i so'ela. Ma gera ka sakea mae ioli matai afula gi 'i so'ela. ");
INSERT INTO lgl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma ioli fo gi ka sugaa Jesus 'ali ka ala'alia ioli matai fo gi gera ka dau tonala 'aela to'omi lia. Ma ioli gera dau tonala to'omi lia gi li, gera ka 'akwaa sui lo. ");
INSERT INTO lgl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sui nali Farasi failia wale falalau ala taki gi li, gera ka la mae faasia 'i Jerusalem 'i so'ela Jesus fala soilidinala. ");
INSERT INTO lgl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Gera ka sae 'uri 'e, “'Uta 'e wale li galona 'o gi iko 'ali gera ronosulia falalauna 'e koko gia gi gera alua lo mae faga, sulia iko 'ali gera saua mola limada 'i lao gera ka bi fana?” ");
INSERT INTO lgl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesus ka olisi 'uri 'e ada, “'Amoulu lou, 'utaa 'e 'amu ka tau 'amiu sulia falalauna 'amiu gi 'i talamiu, ma iko 'ali 'amu tau sulia taki God gi? ");
INSERT INTO lgl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God 'e sae 'uri 'e, ‘'O fabaelaa mama 'o failia teite 'o.’ Ma ‘Ala ta ioli 'e fai'isi fala mama lia 'o ma teite lia, gera kae raunia ka mae.’ ");
INSERT INTO lgl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wasua ma, moulu faalalau rero 'amoulu 'uri 'e, ala ta ioli 'e too ala tali 'are 'e saiai kae ranaa 'alia mama lia 'o ma teite lia, ma ka sae 'ala 'uri 'e, ‘Lakae kwatea lo 'are ba gi fala God.’ ");
INSERT INTO lgl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Moulu ilia, 'uri 'e 'oka mola 'ala fala 'ali ikoso 'e ranaa lo mama lia failia teite lia 'alia 'are fo 'e etae alafu lo 'alida fala God gi. Ma ala 'e 'urifo, falalauna 'e moulu alua, 'e tefulailia lo saenala God. ");
INSERT INTO lgl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ma moulu ilia moulu ronosulia God, ma iko 'ali kwalaimoki mola. Aesea 'e sae kwalaimoki talasi ba 'e alaa suli 'amoulu, lia ba 'e gerea God 'e sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Alae ioli 'e gera faaba'ela lau mola 'alia saenada, wasua ma malatada 'e tatau rasua faasia lau. ");
INSERT INTO lgl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gera foasi lau gwaugwau mola 'ada, dunala gera faalalau mola 'ada sulia taki gera 'i talada gi, ma gera ka ilia 'uri taki God gi lo sefo!’” ");
INSERT INTO lgl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ma Jesus ka soia mae ioli afula gi 'i so'ela, ma ka sae 'uri 'e fada, “Moulu fafurono mae fagu, ma 'amu ka malinailia. ");
INSERT INTO lgl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Iko lou ta 'are ta ioli kae 'ania, kae fatasua ioli la. Iko! Alaana 'e latafa faasia fokala ioli li 'ala 'e fa'uli'ulia maurinala ioli.” ");
INSERT INTO lgl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sui wale li galona Jesus gi, gera ka la mae 'i so'ela, gera ka sae 'uri 'e fala, “'Are ba 'o ilida gi, Farasi gi gera ronoda, ma malatada iko 'ali 'oka sulia.” ");
INSERT INTO lgl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma Jesus ka olisi 'uri 'e adaulu, “God kae fafuta'a falalauna rero gi, sulia 'e iko 'ali la mae faasia 'i lia, malaa na wale 'e failia 'are ta'a gera bulao mae garania 'are 'e fasida gi. ");
INSERT INTO lgl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Moulu ala malata 'aberona sulia Farasi fo gi li. Sulia gera malaa mola 'ada wale maa koro la 'e talaia lou na wale maa koro. Ma 'amu ka sai lou ai, ala ta wale maala 'e koro ka talaia lou na wale maala 'e koro, daro kae toli sui mola 'i laola mae gilu.” ");
INSERT INTO lgl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma Peter ka sae 'uri 'e fala Jesus, “'O fadaa ga mae malutala alaana ba 'o bi ilida mola mae fameulu gi.” ");
INSERT INTO lgl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus ka olisi 'uri 'e ala, “'I 'amoulu wale li galona lau gi, wasua ma iko 'ali moulu malinailia 'ua lou malaa 'i daulu. ");
INSERT INTO lgl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'Uta 'e iko 'ali moulu saiala 'are 'e gi? 'Eo, 'are ioli 'e 'ania kae dao tarosi lo 'i laola ogala, ma 'i buri kae latafa lou mae 'ala faasia rabela. ");
INSERT INTO lgl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wasua ma ta alaana ta'a 'e latafa faasia fokala ioli, 'e fuli mae faasia 'i laola manola ioli. Mali fo bui kae fa'uli'ulia maurinala ioli. ");
INSERT INTO lgl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ma 'are ta'a 'e latafa faasia laola manola ioli li 'e 'uri 'e: rau ioli na, tau ta'ana failia geli wateu gi li, tau ta'ana gi sui matanala ioli gi, kotona fafia ta ioli, belinala ta me 'are ta ioli, failia alaana ta'a sulia ta ioli. ");
INSERT INTO lgl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","'Are fo gi lo gera saiala fa'uli'ulinala maurinala ioli 'i maala God. Na falafala koko gia gi gera falalau gia mae 'alia, gia ka sau lima 'i lao ala fana na. Wasua ma ala ioli ikoso tau sulia, maurinala ikoso ta'a mola.” ");
INSERT INTO lgl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus ka la lo faasia lifi fo, ma ka la lo fala gulae tolo 'i Taea failia 'i Saedon. ");
INSERT INTO lgl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma te geli iko lou Jiu 'i laola iona 'i Kenan ka la mae 'i so'ela, ma ka rii 'uri 'e, “Aofia, ulufa'alu ala kwalofa David, 'o amaasi lau mae! Aloe 'are ta'a 'e rufia welageli lau, ma ka famalifii rasua.” ");
INSERT INTO lgl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesus iko 'ali olisia mola 'alia ta alaana. Ma wale li galona lia gi daulu ka la 'i so'ela Jesus, ma daulu ka sae 'uri 'e, “'O keria ka la lo 'ala, sulia 'e dona golu mola 'ala, ma ka none rasua lo.” ");
INSERT INTO lgl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesus ka sae fala geli fo 'uri 'e, “God 'e kwate lau mola mae fala ioli Jiu gi lia 'e gera malaa sipsip 'e gera rero lo 'ada gi.” ");
INSERT INTO lgl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sui geli fo ka la mae, ma ka boururu lo 'ala 'i maala 'aela ka sae 'uri 'e, “Aofia, 'o kwairanai mae agu!” ");
INSERT INTO lgl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus ka olisi 'uri 'e ala, “'E iko 'ali rada fala sakenala fana wela gi li, ma taasi nai fala kui gi.” ");
INSERT INTO lgl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Geli fo ka sae 'uri 'e, “'Eo. Wasua ma kui gi wasua lou gera sai ala 'aninala mola 'ada orenala fana 'e toli faasia fofola tarapapa ioli 'e too ada li.” ");
INSERT INTO lgl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sui Jesus ka olisi 'uri 'e ala, “Geli 'e fitoona 'o 'e ba'ela rasua! Ma 'are 'e 'o sugaa, lakae kwatea famu.” Ma welageli lia ka 'akwaa lo ala tofui matola fo mola lo. ");
INSERT INTO lgl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Talasi Jesus 'e la mae faasia mae falua fo li, ka oli mae sulia tala 'e liu totolala 'osi ba'ela 'i Galili. Ma ka rae gwaula fe uo, ma ka gwauru 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma ala talasi fo, ioli afula rasua gera ka la mae 'i so'ela. Ma gera ka sakea lou mae ioli matai afula gi, nali ioli 'aeda ka mae failia limada ka mae, nali ioli maada ka koro, ma nali ioli fokada ka 'ato. Gera aluda 'i maala 'aela Jesus, ma ka gurada, ma gera ka 'akwaa sui. ");
INSERT INTO lgl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma ioli fo gera logo fala bubu na li gi li, gera ka 'afero rasua ala talasi gera lesia ioli fo fokada 'ato gi, gera sae lo, ma ioli fo 'aeda mae, failia limada mae gi gera ka 'oka lo, ma ioli iko 'ali gera liu 'oka gi, gera liu 'oka lo, failia ioli fo maada ka koro gi, gera ka lio lo. Ma sulia gera lesia 'are fo gi, gera ka 'auraea God fo 'i Israel. ");
INSERT INTO lgl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sui Jesus ka soia mae wale li galona lia gi 'i so'ela, ka sae 'uri 'e fadaulu, “Lau malatai rasua ala ioli 'e gi, sulia gera io fae golu sulia olu atoa gi ka sui lo, ma fana gera gi ka sui lo. Ma iko 'ali lau oga olifaenada fala falua gera gi ala talasi gera fiolo 'uri 'e, taufasia ta ioli ada ka bi watoutou, ma ka maefulu sulia tala.” ");
INSERT INTO lgl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wale li galona lia gi daulu ka olisi 'uri 'e ala, “'I laola lifi dadala 'uri 'e 'i fe 'e golu kae daria ta fana ai 'ali totolia ioli afula 'uri 'e?” ");
INSERT INTO lgl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma Jesus ka soilidi daulu 'uri 'e, “Fita berete gi 'e moulu too ali?” Wale li galona lia gi daulu olisia ma daulu ka sae 'uri 'e “Fiu berete gi mola, failia ofotae me lode ia gi mola 'e meulu too ali.” ");
INSERT INTO lgl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ala talasi fo, Jesus ka ilia fala ioli gi gera ka gwauru 'i fua. ");
INSERT INTO lgl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sui, ka sakea fiu berete fo gi failia lode ia fo gi, ka batafea God. Sui ka liia, ma ka kwatea fala wale li galona lia gi, 'ali daulu tolinia fala ioli fo gi. ");
INSERT INTO lgl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma ioli fo gi, gera fana sui, ma gera ka bote. Buri 'ala gera fana ka sui, wale li galona gi gera ka fafonua fiu pera gi 'alia orenala fana. ");
INSERT INTO lgl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wale gera 'ania fana fo gi li, gera fai to'oli wale gi. 'E iko 'ali gera idumia mola geli ma wela. ");
INSERT INTO lgl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ma burila gera fana ka sui lo, Jesus ka bi ketada fala falua gera gi. Ma 'i lia failia wale li galona lia gi, daulu ka sifo, ma daulu ka rae 'i laola baru, daulu ka la fala mae falua gera soia 'alia Magadan. ");
INSERT INTO lgl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nali Farasi failia nali Sadusi, gera la mae 'i so'ela Jesus 'ali geraka mailitonala, ma gera ka soilidia 'ali ka fulia ta 'are mama'ala 'ali ka fatailia God 'e kwate lia mae. ");
INSERT INTO lgl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesus 'e olisi daulu ka sae 'uri 'e, “Ala talasi da'afi ka suu, ala 'amu lesia dasa 'e melamelaa, 'amu ka sailoai uuta ikoso 'ali too 'i dani. ");
INSERT INTO lgl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","'Eo, 'ofaedani, ala 'amu lesia dasa 'e melamelaa ma ka gola, 'amu ka sai lou ala lia uuta kae too. Moulu saiala lesinala raloo, wasua ma iko 'ali 'amu lio raea mola 'are 'e God 'e fulia ala talasi 'e gi li. ");
INSERT INTO lgl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","'I 'amiu ioli la talasi 'e 'amu taua 'are ta'a afula gi, ma iko 'ali 'amu fitoo mola ala God. 'Amu ka oga lesinala fataena gi. Wasua ma ikoso lau kae taua mola ta 'are mama'ala famiu. 'Are mama'ala lakae taua 'ali 'amu lesia mola 'e 'are mama'ala ba 'e fuli fala profet Jona 'i lao.” Burila Jesus 'e sae 'urifo ka sui, ka la lo 'ala faasida. ");
INSERT INTO lgl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ala talasi Jesus failia wale li galona lia gi daulu tofolo fala gulae 'osi lobaa li, wale li galona lia gi iko 'ali gera too ala ta berete, suli daulu bulono 'ali sakenali faili daulu. ");
INSERT INTO lgl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma Jesus ka sae 'uri 'e fadaulu, “Moulu ka lio 'oka suli 'amiu faasia ist fala berete li ala Farasi gi failia Sadusi gi li.” ");
INSERT INTO lgl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Talasi wale li galona lia gi gera ronoa me alaana fo gi li, daulu ka sae lo 'adaulu sulia 'i safitadaulu talifilidaulu, ma sulia daulu fia 'uria Jesus 'e sae sulia berete kwalaimoki, ma daulu ka sae 'uri 'e, “Mala Jesus 'e sae 'urifo, sulia lia 'e iko 'ali golu sakea mae ta berete tae 'e!” ");
INSERT INTO lgl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma sulia Jesus 'e sai mola 'ala ala malatala wale li galona lia gi, ka sae 'uri 'e, “'Uta 'e moulu ka malata fiitala rasua sulia lia 'e iko 'ali moulu sakea mae ta berete? Me fitoona 'amoulu gi 'e wawade rasua! ");
INSERT INTO lgl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Iko 'ali moulu malinailia 'ua malutala 'are 'e lau ilia famoulu? Ma 'amu bulono lo 'alia lima berete ba lau ranolia 'alia lima to'oli wale gi li, ma moulu ka fafonua pera afula 'alia fana ba ore gi li. ");
INSERT INTO lgl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Mala 'amu bulono lou 'alia fiu berete gi mola ba lau ranolia 'alia fai to'oli wale gi, ma moulu ka fafonua pera afula ba gi 'alia fana 'e ore. ");
INSERT INTO lgl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Uta 'e iko 'ali moulu saiala taa 'e lau sae sulia? Iko lou berete 'e lakae sae sulia. Lau ilia 'amu ka madafi 'amiu faasia ist kae fafalea berete Farasi gi failia Sadusi gi li.” ");
INSERT INTO lgl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Burila 'e sae 'urifo ka sui, wale li galona gi daulu bi saiala taa fo Jesus 'e sae sulia. 'E sae 'ala sulia faalalauna kotokoto Farasi gi failia Sadusi gi li. ");
INSERT INTO lgl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Talasi Jesus 'e dao ala gulae tolo 'i Sesarea Filipae, ka soilidia wale li galona lia gi 'uri 'e, “'Uri'e ma ioli gi gera soi lau, Wela Wale li, 'alia ite?” ");
INSERT INTO lgl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Daulu ka olisi 'uri 'e ala, “Nali ioli gera soi 'o 'alia John wale fasiuabu lia 'e maurifa'alu lou, ma nali ioli gera soi 'o 'alia Elaeja lia 'e maurifa'alu lou. Ma nali ioli lou gera soi 'o 'alia Jeremaea 'o ma ta wale ala profet gi lia 'e maurifa'alu lou.” ");
INSERT INTO lgl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sui Jesus ka soilidi 'uri 'e adaulu “'Urilali ma 'utaa 'i 'amoulu, moulu soi lau 'alia ite?” ");
INSERT INTO lgl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma Simon Peter ka olisi 'uri 'e ala, “'I'o lo Christ, wale God 'e filia fala faamurinala ioli lia gi li. God 'e mauri firi 'i'o lo wela moutae lia.” ");
INSERT INTO lgl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma Jesus ka sae 'uri 'e, “Simon wela John 'oilakina famu. Sulia ioli iko 'ali fatailia me 'are 'e famu. Mama lau 'i nali lo 'e fatailia famu. ");
INSERT INTO lgl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma lakae ilia famu, 'i'o 'a Peter, fadanai me fau, 'i fofola fau 'e lakae raunailia logonae ioli gera fitoo agu gi. Lakae alu 'o wale lalifu koe fanasia ioli 'e gera kae fitoo agu gi. Ma nanatanala maena ikoso totolia 'ali liufida. ");
INSERT INTO lgl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma lakae kwatea nanatana famu lia 'e malaa kii ala maluma ala 'Ilitoana God. Ala ta taa 'o luia ioli gi ikoso 'ali gera taua 'i laola molagali, God ka alafafia lou saenamu 'i nali. Ma ta taa 'o ala'alia ioli gi ka taua 'i laola molagali, God ka ala'alia lou 'i nali.” ");
INSERT INTO lgl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sui Jesus ka sae nasi fala wale li galona lia gi, 'ali ikoso gera faronoa ta ioli 'alia liafo 'i lia lo 'a Christ. ");
INSERT INTO lgl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Fuli ala talasi fo ka la, Jesus ka fuli'ae fala famadakwanala wale li galona lia gi 'uri 'e, “Lakae la fala 'i Jerusalem. Ma wale etaeta gi, failia fata abu ba'ela gi, failia wale falalau ala taki gi li, gera kae faamalifii lau, ma gerakae rauni lau. Ma ala olula fe atoa, God kae tae lau lou fala maurina.” ");
INSERT INTO lgl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma Peter ka talaia ko, ma ka balufia 'uri 'e ala, “Aofia, God 'e luia! 'Are la gi, 'ato 'ali fuli famu!” ");
INSERT INTO lgl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma Jesus ka bulusi, ma ka sae 'uri 'e fala Peter, “Saetan, 'o la tatau ko faasi lau! 'O ura bolosi lau. Sulia malatamu 'e fuli mola mae faasia ioli. Ma iko lou faasia God.” ");
INSERT INTO lgl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sui Jesus ka sae 'uri 'e fala wale li galona lia gi, “Ite 'e oga kae dona lau, ikoso 'ali malata 'abero sulia 'are 'e ogada gi mola 'i talala. Lia ka dona lau, wasua talasi kae famalifii, ma kae mae ala 'ai rara folo li. Ala ta ioli 'e oga kae dona lau, 'i lia ka buri 'ali 'i lia talala, ka awailia 'ai rara folo lia, ma ka dona buri agu. ");
INSERT INTO lgl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ite 'e barasi 'ali dona nagu, sulia 'e oga kae tau 'ala sulia liola 'i talala, 'i lia kae talafia maurina firi. Wasua ala ta ioli kae mae fafia ratagu, 'i lia kae too ala maurina firi. ");
INSERT INTO lgl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ala ta ioli ka too ala 'are afula 'i laola molagali 'e, ma ka mae, ma 'e io tatau faasia God, 'are la gi ikoso fulia mola ta 'okana fala. Iko ta ioli 'ali totolia folinala maurina firi 'alia ta bata. ");
INSERT INTO lgl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Lau ilia 'are 'e sulia 'i lau, Wela Wale li, lakae la mae failia eniselo lau gi, ala Tatalona Mama lau li, ma lakae kwatea kwaiara 'o ma kwaikwaina fala ioli gi sui, sulia 'are gera tauda gi. ");
INSERT INTO lgl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","'Are kwalaimoki lakae ilia famiu, tali wale amoulu ikoso gera mae la la gera ka lesia lakae dao mae, ma lakae 'ilitoa.” ");
INSERT INTO lgl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Olo fe atoa gi 'i buri, Jesus ka talaia Peter, failia rua walefae gi James ma John talifilidaulu fala 'i gwaula te fe uo. ");
INSERT INTO lgl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma talasi daulu lio ko, daulu ka lesia lo maala Jesus 'e olisi. Maala ka wasinosino malaa da'afi, failia to'omi lia gi ka kaka'asiroroa rasua. ");
INSERT INTO lgl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma olu waleli galona fo gi, daulu ka lesia Moses failia Elaeja daro alaa 'adaroa failia Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma Peter ka sae 'uri 'e fala Jesus, “Aofia, 'e 'oka rasua golu ka io 'i lifi'e. Ala 'o oga, lakae raunailia ta olu babala, ta ai famu, ta ai fala Moses, ma ta ai fala Elaeja.” ");
INSERT INTO lgl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Talasi Peter kae sae mola 'ala 'ua 'urifo, te dasa 'e wasinosino rasua malumalunai ka kufi fafidaulu, ma daulu ka ronoa linae 'are 'e sae mae 'uri 'e faasia 'i laola dasa fo, “Teke wela moutae lau lo 'e 'i lia lau kwaima rasua ala. Lau babalafe 'alia. Moulu rono sulia!” ");
INSERT INTO lgl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma talasi wale li galona lia gi daulu ronoa lo linae 'are fo li, daulu ka mau rasua, ma daulu ka teo lo 'adaulu fafia maadaulu 'i wado. ");
INSERT INTO lgl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma Jesus ka dao 'i soedaulu, ma ka dau tonadaulu, ka sae 'uri 'e, “Moulu tatae. Moulu ala mau na.” ");
INSERT INTO lgl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Talasi daulu lio ko, iko 'ali daulu lesia lo ta ioli, talifilia Jesus mola. ");
INSERT INTO lgl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Talasi daulu sifo mae faasia 'i gwaula fe uo fo li, Jesus ka sae nasi fadaulu 'uri 'e, “Ikoso moulu faronoa ta ioli 'alia 'are 'e moulu lesida gi, la la ka dao ala talasi God kae tae lau, Wela Wale li, faasia maenali.” ");
INSERT INTO lgl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Olu wale li galona lia gi daulu ka soilidia 'uri 'e, “'Uta wale falalau ala taki gi li gera ilia Elaeja kae etae oli mae, sui bui wale ba God 'e filia ka bi la mae?” ");
INSERT INTO lgl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus ka olisi 'uri 'e adaulu, “'E kwalaimoki. Elaeja kae etae oli mae, 'ali ranaa ioli gi 'ali gera rerei. ");
INSERT INTO lgl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma lakae ilia lou famoulu, Elaeja 'e dao sui lo mae. Wasua ma ioli gi iko 'ali gera lio raea mola. Lia fo, gera ka taua 'are ta'a gi ala sulia lioe ioli gera gi. Ma gerakae tau lou 'urifo agu.” ");
INSERT INTO lgl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ala talasi olu wale li galona fo gi daulu ronoa, daulu bi saiala lia 'e Jesus 'e alaa fadaulu sulia John wale fasiuabu. ");
INSERT INTO lgl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Talasi Jesus failia olu wale li galona lia gi daulu sifo mae fala 'aela fe uo fo li, ioli afula gi gera logo lo, ma te wale ka la mae, ka boururu 'i maala 'aela Jesus, ma ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Aofia, 'o malataia wela wale lau, sulia maluu 'e taua. Matai la 'e taua ma ka kwekwe'ela, ma ala talasi afula 'e 'ui 'alia lo 'i laola dunaa, failia 'i laola kwai lou. ");
INSERT INTO lgl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Lau sakea mae fala wale li galona 'o gi. Ma 'e 'ato rasua fadaulu fala guranala.” ");
INSERT INTO lgl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus ka sae 'uri 'e fadaulu, “'I 'amiu ioli la talasi 'e, malatamiu 'e nasi rasua, ma ioli ta'a gi 'i 'amiu! Iko 'ali 'amu fakwalaimoki lau 'ua! Lau kwaimanosi lo 'alia ikoe fitoona 'e 'amiu. Lau io fae 'amiu ka dao lo 'uri 'e, totolia moulu ka fakwalaimoki lau lo.” Sui ka sae 'uri 'e fala wale fo, “'O sakea mae wela la 'o 'i lifi'e.” ");
INSERT INTO lgl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma Jesus ka sae nanata fala aloe 'are ta'a fo, ma ka la lo faasia wela fo. Ma wela fo ka 'akwaa lo ala talasi fo mola lo. ");
INSERT INTO lgl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sui, talasi daulu io talifilidaulu, wale li galona gi daulu la mae 'i so'ela Jesus, ma daulu ka soilidi 'uri 'e ala, “'Uta ka 'ato fameulu fala lulunala aloe 'are ta'a ba?” ");
INSERT INTO lgl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma Jesus ka olisi 'uri 'e adaulu, “'E 'urifo, sulia fitoona 'amoulu 'e olidodoko rasua. Ma lakae ilia famoulu, ala fitoona 'amoulu ala God ka ba'ela ka malaa wasua 'ala fufuae 'ai wawade 'e gera soia 'alia mastad li, moulu sai mola 'amoulu ala tauanala 'are 'ato gi. Ala 'e 'urifo, fe uo lobaa wasua, moulu ka 'idua faasia 'i fulila 'alia saenamolu. Ma ala moulu fakwalaimoki ala nanatanala God, iko ta 'are 'ali 'ato fala tau nai 'amiu.” ");
INSERT INTO lgl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Talasi wale li galona lia gi gera logo mae 'i Galili, Jesus ka sae 'uri 'e fadaulu, “'I lau, Wela Wale li, gerakae kwate lau fala malimae lau gi, ");
INSERT INTO lgl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","'ali gera rauni lau. Ma ala olula fe atoa, God kae tae lau lou fala maurina.” Ma talasi wale li galona gi gera ronoa Jesus 'e sae 'urifo li, gera ka kwaimalatai rasua. ");
INSERT INTO lgl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ala talasi Jesus failia wale li galona lia gi daulu la mae fala falua 'i Kapaneam, wale gera goli bata ala takisi fala Luma Abu God gi li, gera la mae 'i so'ela Peter, ma gera ka soilidia, “'Uri'e ma wale li faalalau 'amoulu 'e saiai ka kwatea lou bata 'e meulu liu fala golinai fala Luma Abu God li?” ");
INSERT INTO lgl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma Peter ka olisi 'uri 'e adaulu, “'Eo, 'e saiai ka kwatea.” Ma talasi Peter 'e ruu 'i laola luma li, Jesus ka etae soilidi ga 'uri 'e ala, “Simon, 'o malata 'utaa? Ite lo walelitalona ala molagali li saiala sakenala bata faasida? Wela gera 'i talada gi, 'o ma faasia ioli mamata gi?” ");
INSERT INTO lgl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter ka olisi 'uri 'e ala, “Fasia ioli mamata gi.” Ma Jesus ka sae 'uri 'e, “'E 'urila, wela gera gi iko 'ali gera kwatea mola takisi. Lia fo, ala ikoso lau kwatea wasua takisi fala Luma Abu Mama lau li, 'e 'oka mola 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma ka 'urifo wasua, iko 'ali 'oka 'ali golu fafuta'a malatada fagaulu. 'O la 'i laola 'osi, ko li kwaiasi mae 'alia kwalo li kwaiasina. Lode ia koe etae tafoa, 'o tafalia fokala, koe lesia bata 'e tala'ala folinala takisi gora gi li sui fala teke fe nali laulau. Sakea bata la, ma ko kwatea fadaulu.” ");
INSERT INTO lgl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ala talasi fo, wale li galona Jesus gi gera la mae 'i so'ela, ma gera ka soilidia 'uri 'e ala, “'Uri'e ma, Talasi God kae 'ilitoa, ite ameulu lo kae 'ilitoa ka ba'ela?” ");
INSERT INTO lgl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ala talasi fo, Jesus ka soia mae ke wela 'i so'ela, ma ka fa uraa 'i safitadaulu. ");
INSERT INTO lgl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma ka sae 'uri 'e, “'Are kwalaimoki lakae ilia famoulu, ala 'amu ka olisia abulona 'amiu gi, ma 'amu ka fawawade 'amiu 'i talamiu malaa wela gi, 'amu ka bi totolia 'ali God ka 'ilitoa fafi 'amiu. ");
INSERT INTO lgl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ma ta ioli 'e fawawade lia 'i talala malaa ke wela 'e, 'i lia kae 'ilitoa talasi God kae 'ilitoa ai. ");
INSERT INTO lgl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ala ta ioli 'e kwaloa ta wela 'uri 'e dunala 'e fitoo agu, 'i lia 'e kwalo lau lou. ");
INSERT INTO lgl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ala ta ioli ka taua ioli 'e gera mamaea gi ka toli faasia fitoona gera agu, 'e 'oka fala 'ali gera firia ta fau ba'ela 'i luala, ma geraka 'ui 'alia 'i laola asi matakwa. ");
INSERT INTO lgl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kwaimalatai fala ioli 'i laola molagali gi li sulia 'are 'e afula fala farero nada, wasua ma kwaimalatai rasua fala ioli kae taua ioli gi gera ka toli faasia fitoona gera agu. ");
INSERT INTO lgl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ma ala limamu 'o ma 'aemu 'e taua ko toli faasia fitoona 'o agu, 'o 'ole mousia fa'asi 'o. 'E ke 'oka mola 'ala famu ala ko io tekwa 'amua 'i laola maurina 'i nali failia teke fili lima 'o ma teke fili 'ae, ka 'oka liufia ko bi sifo 'i laola lifi ala kwaikwaina li failia rua lima gi 'o ma rua 'ae gi, lifi la dunaa 'e 'ago firi. ");
INSERT INTO lgl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma ala maamu 'e kwatea ko toli faasia fitoona 'o agu, 'o 'iroa fa'asi 'o, ma ko tasia. 'E 'oka famu ala ko ruu 'i laola maurina 'i nali failia teke fili maa, ka 'oka liufia ko sifo 'i laola lifi ala dunaa 'ago firi failia rua fili maa gi.” ");
INSERT INTO lgl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ma Jesus ka sae lou 'uri 'e, “Ikoso moulu lolonailia ke wela 'e gi. Sulia eniselo gera gi kae farono 'alia fala God Mama lau 'i nali, 'alia taa gi 'amu tauda ada. ");
INSERT INTO lgl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ma ala ta wale ka too ala teke talanae sipsip, ma na ai ka rari, ma ta lo wale fo kae taua? Wale fo kae tafisia sikwa akwala wala sikwa sipsip fo gera ore gi ala lifi gera fana ai, ma ka la ka li lio 'afia teke sipsip fo 'e rari. ");
INSERT INTO lgl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Talasi 'e dao lo tonai, ka babalafe ka ba'ela liufia lo babalafena lia failia sipsip 'e gera io mola 'ada failia gi. ");
INSERT INTO lgl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Mama 'amiu mae 'i nali, 'i lia 'e malata 'urifo lou, sulia 'e iko 'ali oga ta ke wela 'ali fulu 'i osiala ta'ana lia gi.” ");
INSERT INTO lgl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesus ka sae 'uri 'e fala wale li galona lia gi, “Ala ioli futa 'o 'e taua ta 'are rero amu, 'o la 'i so'ela, ko faronoa 'alia me rerona lia 'i safitamoroa talifili 'amoroa. Ma ala 'e fafurono famu, mora ka kwaima lou. ");
INSERT INTO lgl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma ala iko 'ali 'e fafurono famu, 'o sakea ta teke ioli 'o ma ta rua ioli lou fae 'o, 'ali daro ka fakwalaimokia 'are 'o ilida gi sui fala, 'ali 'o tau sulia Geregerena Abu ba 'e sae 'uri 'e, ‘Rua ioli 'o ma ta olu ioli 'ali daulu ka fakwalaimokia alaana 'o ilia.’ ");
INSERT INTO lgl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma ala iko 'ali aala mola fafia sae fakwalaimoki na daulu, 'o farono 'alia fala logonae ioli gera fitoo ala God gi. Ma ala logonae ioli God gi wasua, iko 'ali 'e fafurono mola fada, 'o alua 'i maluma faasia logonae ioli God gi ka malaa ioli 'e raria God, 'o ma ioli ta'a 'e golia bata ala takisi li. ");
INSERT INTO lgl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“'Are kwalaimoki lakae ilia famoulu, ta taa moulu luia ioli gi 'ali ikoso gera taua 'i laola molagali, God 'e luia lou 'i nali. Ma ta taa moulu ala'alia ioli gi ka taua 'i laola molagali, God 'e alafafia lou 'i nali. ");
INSERT INTO lgl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Lakae ilia lou famoulu, ala ta rua ioli amoulu daro alafafia ta 'are 'i laola molagali, ma daro ka foa fai, Mama lau 'i nali kae kwatea fadaroa. ");
INSERT INTO lgl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sulia ala ta rua ioli 'o ma ta olu ioli daulu logo ala ta lifi, sulia daulu fakwalaimoki lau, lau io lou 'i lifila fae daulu.” ");
INSERT INTO lgl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Peter 'e dao 'i so'ela Jesus, ka soilidi 'uri 'e ala, “Aofia, ta fita talasi 'e lakae saiala kwailufa na ala ioligu, talasi 'e taua 'are ta'a gi agu? Ka dao ala fiu talasi gi?” ");
INSERT INTO lgl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma Jesus ka olisi 'uri 'e ala, “Lakae ilia famu, iko lou fiu talasi gi mola, ma ala talasi gi sui mola ko kwailufa. ");
INSERT INTO lgl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Lau ilia 'urifo sulia 'ilitoana God malaa na walelitalona 'e oga faradanala sake lanana gi failia ioli li galona lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Etala ioli li galona ka dao mae 'e sake lana ala akwala to'oli bata. ");
INSERT INTO lgl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ioli li galona fo iko 'ali totolia lo duunala sake lanana lia, ma walelitalona ka sae nanata, 'ali gera foli 'alia failia wateu lia, ma wela lia gi, failia 'are lia gi sui fala duunala sake lanana fo lia. ");
INSERT INTO lgl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ma ioli li galona fo 'e la mae ka boururu 'i maala walelitalona fo, ma ka aniulu 'uri 'e, ‘'O kwate talasi ga fagu, 'ali lau duua 'are 'o gi sui.’ ");
INSERT INTO lgl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma walelitalona fo ka malataia ma ka kwailufa lo 'alia sake lanana lia 'ali ikoso duua lo, ma ka ala'alia ka la lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ma talasi wale fo 'e latafa, ka manodaria na wale ala wale li galona gi lia 'e sake lana lou ala nali ofotae bata wawade 'i so'ela. Lia ka daua, ma ka fuli'ae lo 'ininala luala, ma ka sae 'uri 'e, ‘'O duua lo 'are ba 'o sake lana ali 'i soegu gi!’ ");
INSERT INTO lgl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ma wale li galona fo ka boururu, ma ka aniulu 'uri 'e, ‘'O kwate talasi ga fagu, lakae duu famu.’ ");
INSERT INTO lgl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Wasua ma lia 'e barasi, ka sakea ka alua 'i laola raraa, ka io la la ka dao ala talasi kae duua sui sake lanana fo lia li. ");
INSERT INTO lgl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma talasi nali wale li galona gera lesia me 'are fo li, malatada ka kwaimalatai rasua. Ma gera ka la 'i so'ela walelitalona fo, ma gera ka faronoa 'alia 'are fo gi sui. ");
INSERT INTO lgl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ma walelitalona fo ka soia mae wale li galona etaeta fo, ma ka sae 'uri 'e fala, ‘'I'o te wale ta'a rasua 'i'o! Lau kwailufa lo 'alia sake lanana ba 'o gi sui, sulia 'o aniulu fagu 'afia. ");
INSERT INTO lgl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Totolia ko kwaimalatai lou fala wale li galona fo, malaa ba lau taua lou famu.’ ");
INSERT INTO lgl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma walelitalona fo ka ogata'a rasua, ka kwatea fala kwainala 'i laola raraa, la la ka dao ala talasi kae duua sui 'are 'e sake lana ali gi.” ");
INSERT INTO lgl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ma Jesus ka faasuia tarifulaana fo 'uri 'e, “Mama lau 'i nali kae tau lou 'urifo amiu ala ikoso 'amu kwailufa kwalaimoki ala iolimiu.” ");
INSERT INTO lgl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Talasi Jesus 'e alaa ka sui lo, ka la faasia gulae tolo fo 'i Galili. Ma ka tofolo ala kwai 'i Jodan, ma ka li dao ala na gula ala gulae tolo 'i Judea. ");
INSERT INTO lgl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ioli afula rasua gera la sulia. Ioli gera matai gi, Jesus 'e gurada ma gera ka 'akwaa sui. ");
INSERT INTO lgl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nali Farasi gera la lou mae fala mailina tonala Jesus. Ma gera ka soilidi 'uri 'e ala, “'Uri'e ma ala taki Moses, 'e 'oka mola 'ala fala wale ka lugasia wateu lia fafia ta 'are mola 'ala 'e oga?” ");
INSERT INTO lgl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus ka olisi 'uri 'e adaulu, “'Uri'e ma iko 'ali 'amu malata 'oka sulia 'are 'e moulu idumia 'i laola Geregerena Abu gi li 'e? Geregerena Abu 'e sae 'uri 'e, ‘Ala fulinai mae, God 'e raunailia ioli 'alia wale failia geli.’ ");
INSERT INTO lgl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma Geregerena Abu ka sae lou 'uri 'e, ‘'I osiala me 'are fo, wale ka tafisia lo mama lia failia teite lia, ma ka io 'ado failia wateu lia, ma daro ka alua lo teke malata malaa mola lo teke ioli.’ ");
INSERT INTO lgl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iko lou ta rua ioli tootoo, ma malaa teke ioli lo. 'Urifo 'are 'e God 'e firi logosia ka sui lo, iko 'ali 'oka fala ta ioli 'ali lufaa lou.” ");
INSERT INTO lgl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma Farasi gi gera ka soilidi lou 'uri 'e ala, “Ma na taki ala taki Moses gi 'e sae 'uri 'e, ‘Moses 'e ala'alia wale ka gerea ta fofoe saena ala kwai lugataena, ma ka kwatea fala wateu lia 'ali 'e lugasia lo.’ Ma 'utaa Moses ka ala'alia fala wale 'ali sai ala tau na 'urifo?” ");
INSERT INTO lgl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus ka sae 'uri 'e fadaulu, “Moses 'e ala'alia famiu Jiu gi fala lugasinala wateu 'amiu gi, sulia 'e 'ato fala faalalaunamiu, sulia malatamiu 'e nasi rasua. Wasua ka 'urifo, 'i lao mae ala talasi God 'e raunailia wale failia geli li, iko 'ali 'urifo. ");
INSERT INTO lgl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma laka ilia famoulu, ala wateu ta wale iko 'ali tau ta'a fafia, ma arai lia ka barasi 'alia ma ka tolea 'ala na geli mamata lou, wale la 'e rero lo 'alia tau wateu na.” ");
INSERT INTO lgl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Burila Jesus 'e sae 'urifo fada sui, wale li galona lia gi gera ka sae 'uri 'e fala, “Ala 'e 'ato rasua fala wale ka lugasia wateu lia 'urila, 'e 'oka mola fala wale ikoso arai.” ");
INSERT INTO lgl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma Jesus ka sae 'uri 'e fadaulu, “Wale afula gi iko 'ali gera sai 'oka ala 'are kwalaimoki sulia araaraina li. Ma barae wale mola God 'e kwatea liotoo fada 'ali geraka malinailia falalauna 'e. ");
INSERT INTO lgl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Lau iilia 'are 'e sulia nali wale iko 'ali gera arai, sulia fuli'ae mae ala talasi gera futa ai me 'are gi iko 'ali rada 'oka 'i laola rabeda, lia 'e taua iko 'ali gera totolia araina. Ma nali wale iko 'ali gera arai sulia ioli gi gera kwaria rabeda taua ma iko 'ali gera totolia lo araina. Ma nali wale iko 'ali gera arai 'ali geraka galo tegula lo fala God. Ma wale gera totolia geraka arai gi, ala 'alia geraka tau sulia falalauna 'e sulia araaraina li.” ");
INSERT INTO lgl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","'I burila 'are fo, nali ioli gera sakea mae ke wela gi 'i so'ela Jesus, 'ali 'e alua limala fafida, ma ka foa fafida. Ma wale li galona lia gi daulu ka balufida. ");
INSERT INTO lgl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma Jesus ka sae 'uri 'e fadaulu, “Moulu ala 'alia ke wela la gi 'ali gera la mae 'i soegu, moulu ala luinada. Sulia God 'e 'ilitoa fafia ioli gera malaa ke wela 'e gi li.” ");
INSERT INTO lgl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sui Jesus ka alua limala 'i fofola ke wela fo gi, ma ka fa'oka gera. Sui, ka la lo. ");
INSERT INTO lgl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ala na talasi, te wale ulufa'alu 'e la mae 'i so'ela Jesus, ma ka soilidi 'uri 'e ala, “Waleli Falalauna, 'are 'oka taa gi lo lakae taua 'ali lau too ala maurina firi?” ");
INSERT INTO lgl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus ka sae 'uri 'e fala, “'Uta ko soilidi lau sulia 'are 'oka gi? Te God mola 'e 'oka. Ala ko oga 'ali 'o too ala maurina firi failia God, ko rono sulia taki lia 'e kwateda gi.” ");
INSERT INTO lgl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma wale fo ka soilidia lou Jesus 'uri 'e, “Taki taa gi?” Jesus ka olisi 'uri 'e ala “Ko ala rau ioli na, ikoso tau ta'a failia ta wateu ta wale, ikoso belia ta 'are, ikoso koto fafia ta ioli. ");
INSERT INTO lgl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ma ko lio 'ato ala mama 'o failia teite 'o. Ma ko kwaima ala ioli gi sui ka malaa lou lia 'e 'o kwaima amu 'i talamu.” ");
INSERT INTO lgl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sui ulufa'alu fo ka sae 'uri 'e fala Jesus, “'Are la gi sui, lau tau lo mae sulida. 'Uri'e ma taa lou lakae taua?” ");
INSERT INTO lgl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma Jesus ka olisi 'uri 'e ala “Ala 'o oga 'ali 'o io 'oka teifau, 'o la ko fo li 'alia 'are 'o gi sui, ko sakea bata ai, ko kwatea fala ioli siofa gi, 'ali 'o too ala too 'arena 'i nali. Sui ko bi la mae 'ali 'o dona buri agu.” ");
INSERT INTO lgl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma talasi ulufa'alu fo 'e ronoa me 'are fo li, liola ka kwaimalatai rasua lo, ma ka la lo 'ala, sulia 'i lia wale too'are rasua. ");
INSERT INTO lgl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma Jesus ka sae 'uri 'e fala wale li galona lia gi, “Lakae ilia famoulu, 'e 'ato rasua fala ioli too'are 'ali 'e ruu 'i laola maurina 'e God kae 'ilitoa fafia. ");
INSERT INTO lgl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma laka ilia lou famoulu, 'e 'ato rasua fala ta kamel 'ali ruu sulia mae kwakwana wawade 'i 'aela sulii li taitai. Wasua ma 'e bi 'ato ka li liufia rasua lou ai, fala ta ioli too'are 'ali God 'ali 'ilitoa fafia maurinala.” ");
INSERT INTO lgl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Talasi wale li galona lia gi gera ronoa 'are fo gi li, gera ka kwele rasua, ma geraka sae 'uri 'e, “Ma ala 'e 'ato fala ioli too'are gi 'uri la, ite mola 'e totolia maurina firi?” ");
INSERT INTO lgl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma talasi Jesus kae sae, ka lio rada ko fala wale li galona lia gi, ma ka sae 'uri 'e, “'E 'ato rasua fala ioli 'ali too ala maurina firi, wasua fala God iko 'ali 'ato mola. 'Are gi sui 'e talawarau fala God.” ");
INSERT INTO lgl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ala talasi fo, Peter ka soilidia Jesus 'uri 'e, “Ma 'utaa 'i 'ameulu? Meulu tafisia lo too 'arena 'ameulu gi sui, ma meulu ka dona buri lo amu. Ma ta God kae kwatea fameulu?” ");
INSERT INTO lgl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma Jesus ka olisi 'uri 'e fadaulu, “Lakae ilia famoulu, ala talasi God kae fafa'alua molagali li, 'i lau, Wela Wale li, lakae io ala fuli iona lau fala lokokwaikwaina ala ioli sui. Ala talasi fo, 'i 'amoulu akwala wala rua waleli galona 'e lau gi, moulu kae gwauru fae lau ala lifi ala 'ilitoana li fala lokokwaikwaina fala ioli ala akwala wala rua kwalofa 'i Israel gi li. ");
INSERT INTO lgl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma ite 'e tafisia luma lia, failia walefae lia gi, failia gelifae lia gi, ma mama failia teite lia, ma wela lia gi, 'o ma ta wado wasua 'ala, sulia 'e dona buri agu, ioli la kae too lou ala 'are 'oka afula gi liufia 'are 'e too ai 'i lao gi. Ma God kae kwatea lou maurina firi fala. ");
INSERT INTO lgl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma ioli afula gera ba'ela ala talasi 'e li, gerakae wawade. Ma ioli afula gera wawade ala talasi 'e li, gera kae ba'ela.” ");
INSERT INTO lgl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesus ka sae lou 'uri 'e fala wale li galona lia gi, “Tatalona God 'e 'uri 'e: 'E malaa te wale 'e too ala wado li, ma 'ofaedani ka la fala darinala ioli fala galo na 'i laola raku lia li. ");
INSERT INTO lgl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ma ka aala fala folinada 'alia me bata 'e totolia folifolina fala teke fe atoa li, ma ka kerida lo fala galona 'i laola raku lia. ");
INSERT INTO lgl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ma ala sikwa me tofui matolaa 'i rafule, 'i lia ka la lou, ma ka lesia nali ioli gera ura gwaugwau mola 'ada 'i laola uusina, ma iko 'ali gera taua mola ta me 'are. ");
INSERT INTO lgl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma ka sae 'uri 'e fada, ‘'I 'amoulu lou moulu la lou mae, 'ali moulu galo 'i laola raku lau, ma lakae foli 'amoulu 'alia me bata 'e totolia me galona fo li.’ ");
INSERT INTO lgl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma gera ka la lo. “Ma matoula atoa, failia ala olu tofui matolaa 'i burila matoula atoa, 'i lia ka la lou, ma ka tau lou 'urifo. ");
INSERT INTO lgl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma 'i raurafi lo ala limala tofui matolaa, 'e la ma ka dao tonala nali ioli gera ura gwaugwau mola 'ada 'i maala uusina. Ma ka soilidi 'uri 'e ada ‘'Uta 'e 'amu ka ura gwaugwau mola 'amiu 'i lifi'e sulia fe atoa laulau 'e, ma iko 'ali 'amu taua mola ta me 'are?’ ");
INSERT INTO lgl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma gera ka olisi 'uri 'e ala, ‘Iko ta ioli 'ali soi 'ameulu mola fala ta galona.’ “Ma ka sae 'uri 'e fadaulu, ‘'I 'amoulu lou moulu la mae, 'ali moulu galo 'i laola raku lau.’ ");
INSERT INTO lgl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ma talasi da'afi 'e suu lo, wale fo 'e too ala raku li ka sae 'uri 'e fala wale ba'ela ala galona lia gi li, ‘'O soia mae waleli galona ba gi, ma ko foli gera 'alia bata gera gi. 'O fuli'ae ala wale ba lau soida 'i buri gi, la la ka dao ala wale ba lau etae soida mae gi.’ ");
INSERT INTO lgl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ma wale galona fo 'e soida 'i buri 'i raurafi gi, gera dao mae, ma ka folida 'alia bata 'e totolia folifolina fala teke fe atoa laulau 'ala teke wale li. ");
INSERT INTO lgl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma talasi wale ba 'e soida mae 'i lao gi gera dao mae, gera fia 'uri kae foli gera ka ke ba'ela. Ma 'i gera sui gera sakea mola bata la gi 'e totolia folifolina fala teke fe atoa 'ala teke wale. ");
INSERT INTO lgl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma talasi gera sakea lo, gera ka nurunuru buri fala wale 'e too ala raku li, gera ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Wale 'e 'o soida mae 'i buri gi, gera galo mola sulia ke me talasi wawade, ma ko folida ka rada lou fae 'ameulu lia 'e meulu sake gulugulu lo ala galo na sulia fe atoa 'e laulau, ma da'afi ka da'afi fifi rasua lo ameulu.’ ");
INSERT INTO lgl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ma 'i lia ka olisia na wale adaulu 'uri 'e, ‘Wale 'e, iko 'ali lau peko 'o mola. 'O alafafia galona 'agua fala folifolina 'e totolia teke fe atoa li mola ba. ");
INSERT INTO lgl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sakea lo folifolina 'o, ma ko la lo. Lau oga lakae kwatea fala wale 'e lau soia 'isi'isi mae ada gi ka rada lou fae 'o. ");
INSERT INTO lgl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ma lau too ala nanatana fala taunala taa lau oga laka taua 'alia bata lau 'i talagu gi. 'Uta ko 'uga, sulia lau kwate 'are ba'ela fala wale mamata lobaa gi?’” ");
INSERT INTO lgl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ma suinai Jesus ka sae 'uri 'e, “Lia fo, ioli 'e 'isiburi 'i talasi 'e gi li, kae etaeta lou. Ma ioli 'e gera etaeta talasi 'e gi li, gerakae aliburi.” ");
INSERT INTO lgl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Talasi Jesus 'e la fala 'i Jerusalem, ka talaia wale li galona lia gi daulu ka liu garania, ma ka alaa fadaulu talifilidaulu 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Moulu ka fafurono 'oka mae fagu. Golu kae la ko fala 'i Jerusalem. Ma te wale kae kwate lau, Wela Wale li, fala fata abu ba'ela gi, failia wale falalau ala taki gi li, 'ali gera ka loko kwaikwaina ta'a agu fala rauninagu. ");
INSERT INTO lgl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma gerakae kwate lau fala ioli mamata faasia Jiu gi li, ma gerakae dorakwala 'ali lau, ma gerakae rabusi lau. Sui gerakae fotoi lau ala 'ai rara folo fala rauninagu. Ma ala olula fe atoa, God kae tae lau lou fala maurina.” ");
INSERT INTO lgl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","'I burila me 'are fo, wateu Sebedi failia rua wela lia gi, James failia John, daulu ka dao mae fala lesinala Jesus. Te geli fo ka la mae, ka boururu 'i maala Jesus, ma ka sugaa fala taunala ta me 'are fala rua wela lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma Jesus ka soilidia geli fo 'uri 'e, “Taa 'e 'o oga?” Geli fo ka sae 'uri 'e, “Lau oga ko etae alafu fagu ko ala'alia rua wela 'e lau gi, daro ka gwauru garani 'o, ta wale ka gwauru 'i aba aolo amu, ma ta wale 'i aba mauli amu, talasi koe walelitalona 'i laola Tatalona 'o li.” ");
INSERT INTO lgl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ala talasi fo, Jesus ka sae 'uri 'e fala wela fo gi, “Me 'are 'e mora sugaa, iko 'ali mora sai mola ala malutala. Mora totolia mola 'amoroa famalifiina malaa famalifiina 'e lakae ruu 'i laola?” Ma daro ka sae 'uri 'e, “'Eo, mera totolia mola 'ameroa.” ");
INSERT INTO lgl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus ka sae lou 'uri 'e fadaroa, “'E kwalaimoki famalifiina 'e kae dao amoroa. Wasua ma fala ite kae gwauru aba aolo agu, ma aba mauli agu malaa lia la mora oga, iko lou 'i lau 'e lakae filia. Talifilia Mama lau 'i nali mola 'e saiala kwatenai fala ioli lia 'e filida fai ka sui lo gi.” ");
INSERT INTO lgl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Talasi akwala wale li galona fo gi daulu ronoa me 'are fo li, daulu ka ogata'a rasua fala rua walefae fo gi. ");
INSERT INTO lgl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Lia fo, Jesus ka soi daulu sui mae 'i so'ela, ma ka sae 'uri 'e, “Moulu saiai ioli 'ilitoa fala ioli mamata faasia Jiu gi li, gera too ala nanatana, ma gera sai rasua ala sunailianala ioli gi fala taunala 'are gera ogada gi. ");
INSERT INTO lgl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wasua, ikoso ke 'urifo 'i safitamoulu. Ala ta ioli amoulu 'e oga kae etaeta 'i safitamoulu, 'i lia ka raea 'i lia ioli galona 'amoulu. ");
INSERT INTO lgl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma ala ta ioli amoulu 'e oga ka 'ilitoa, 'i lia ka galo gwaugwau fala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'I lia ka tau malaa 'i lau, Wela Wale li. Sulia 'i lau iko 'ali lau la mae 'ali ioli gi gera ka galo folosi lau. Ma lau la mae 'agua 'ali lau galo folosia ioli gi sui, ma laka kwatea maurinagu fala faamurinala ioli afula gi faasia ta'ana gera gi.” ");
INSERT INTO lgl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Talasi Jesus failia wale li galona lia gi daulu la ko fala 'i Jerusalem, daulu ka liufia lo ko mae falua 'i Jeriko. Ma talasi daulu la faasia falua fo li, ioli afula rasua gera la mae suli daulu. ");
INSERT INTO lgl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma rua wale maa daroa 'e koro gi daro gwauru 'i rabela tala. Ma talasi daro ronoa Jesus kae liu mae sulia tala li, daro ka rii lo 'uri 'e, “'I'o ulufa'alu ala kwalofa David li, 'o malatai 'ameroa mae.” ");
INSERT INTO lgl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma talasi ioli gi gera ronoa daro rii, gera ka balufia daroa 'uri 'e, “Mora io aroaro!” Talasi gera sae 'urifo, daro ka bi rii ba'ela rasua lou 'uri 'e, “'I'o ulufa'alu ala kwalofa David li, 'o malatai 'ameroa mae.” ");
INSERT INTO lgl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ma talasi Jesus 'e rono daro rii 'urifo li, ka uratoo, ma ka soi daroa mae, ka soilidi 'uri 'e adaroa, “Taa 'e mora oga lakae taua famoroa?” ");
INSERT INTO lgl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Daro ka olisi 'uri 'e ala “Mera oga ko tafalia maameroa 'ali mera ka saiala lio na.” ");
INSERT INTO lgl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","'Urifo, Jesus ka amasi rasua adaroa, ka dau tonala maa daroa. Ma ala me talasi fo mola lo, maa daroa ka lio lo, ma daro ka la lo failia Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ma Jesus failia wale li galona lia gi daulu dao garania lo 'i Jerusalem, ala falua 'i Betfeis, 'i gwaula fe uo 'i Olif. 'I lifi fo, Jesus ka keria na rua wale ala wale li galona lia gi, daro ka etaeta 'i lao, ");
INSERT INTO lgl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma ka sae 'uri 'e fadaroa, “Mora laa fala falua lobaa mora laofia ko, ma mora kae daria te dongki, gera firia 'i lififo failia kalela. Mora ka lugasi daroa, ma mora ka sake daroa mae 'i soegu. ");
INSERT INTO lgl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma ala ta ioli ka soilidi 'amoroa, mora ka olisi 'uri'e ala, ‘Aofia 'e oga.’ Ma kae ala 'alida famoroa.” ");
INSERT INTO lgl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Me 'are 'e 'e fuli 'ali 'e fakwalaimokia saena ba profet 'e ilia 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“'Amu ka ilia fala ioli 'i Jerusalem gi 'amu ka sae 'uri 'e, ‘Lesia. Walelitalona 'amiu, 'e la lo mae 'i soemiu. 'E fawawade lia, ma ka la mae 'i fofola te dongki. 'E la mae 'i fofola te kale dongki.’” ");
INSERT INTO lgl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma rua wale fo ala wale li galona lia gi li, daro ka etaeta lo 'i lao, ma daro ka taua lo 'are fo Jesus 'e ilida fadaroa gi. ");
INSERT INTO lgl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Daro talaia mae dongki fo failia kalela, ma daulu ka folotailia toro daulu gi 'i fofola kalela, ma Jesus ka gwauru 'i fofola. ");
INSERT INTO lgl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma ioli afula rasua gi gera folotailia toro gera gi sulia tala, ma nali ioli gera ka tofua 'abala baibai gi, ma gera ka folotailia sulia tala fala fa'ilitoanala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Te logona ba'ela fo 'e eta 'i lao ala Jesus, ma gera ka aliburia lou ko, gera akwa 'uri 'e, “'Auraea na fala wela ala kwalofa David walelitalona li! Ma God ko 'oilakitailia wale 'e la mae 'alia nanatana 'o li! Gia 'auraea God!” ");
INSERT INTO lgl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ma talasi Jesus 'e li dao 'i Jerusalem, mae falua fo ka boeboeta rasua lo, ma nali ioli gera ka soilidi 'uri 'e, “Ite 'e?” ");
INSERT INTO lgl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma logona fo gera ka sae 'uri 'e, “'I lia Jesus profet, wale faasia falua 'i Nasareti 'i laola provins 'i Galili.” ");
INSERT INTO lgl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Talasi Jesus 'e la mae ka dao 'i laola Luma Abu God, ka tabalia ioli gera uusi 'ada 'i lififo gi. Ma ka geusia tafe ioli gera olisi bata lifi fo gi li, ma ka geusia 'are fala gwauruna 'ala wale gera foli 'alia fe bola gi li. ");
INSERT INTO lgl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma Jesus ka sae 'uri 'e fala ioli fo gi, “Saenala God 'i laola Geregerena Abu 'e sae 'uri 'e, ‘Luma lau, luma li foa.’ Wasua ma 'amu bulusia lo 'alia lifi li belia ioli li.” ");
INSERT INTO lgl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ala talasi fo, nali wale maada 'e koro, ma nali wale 'aeda ka mae, gera la lou mae 'i so'ela Jesus 'i laola Luma Abu God, ma ka gurada sui. ");
INSERT INTO lgl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Fata abu ba'ela gi, failia wale falalau ala taki gi li, gera ogata'a rasua talasi gera lesia 'are 'oka Jesus 'e tauda gi, ma gera ka ronoa ke wela gi gera rii 'uri 'e, “'Auraea na fala wela ala kwalofa David walelitalona li!” ");
INSERT INTO lgl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma fata abu ba'ela gi failia wale famalata gi, gera ka sae 'uri 'e fala Jesus, “'O ronoa me 'are 'e gera ilia! 'Uta 'e iko 'ali 'o luida?” Ma Jesus ka olisi 'uri 'e adaulu, “'Eo, lau ronoa. Iko 'ali 'amu idumia mola alaana ba 'i laola Geregerena Abu li? 'E sae 'uri 'e, ‘'O faalalaua wela wawade gi 'ali gera batafe 'o 'i talamu.’” ");
INSERT INTO lgl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sui 'i burila, Jesus failia wale li galona lia gi, daulu ka la lo faasia 'i Jerusalem, ma daulu ka la fala 'i Betani. Ma talasi 'e boni, daulu ka teo lo 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","'Ofaedani ala ruala fe atoa, talasi Jesus failia wale li galona lia gi daulu oli mae fala 'i Jerusalem, Jesus ka fiolo. ");
INSERT INTO lgl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma ka lesia te 'ai figi 'e ura 'i rabela tala, ma ka la 'i 'aela, ma iko 'ali lesia mola ta fuae 'are ai, ma rarala mola 'e ulua. Ma ka sae 'uri 'e fala 'ai figi fo, “Sulia iko 'ali 'o alua mola ta fuae 'are, 'urila fuli ala talasi 'e ikoso funufunu lo!” Ala me talasi fo mola, fe 'ai fo ka kuku lo. ");
INSERT INTO lgl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Talasi wale li galona gi daulu lesia me 'are fo li, daulu ka 'afero rasua. Ma daulu ka soilidi 'uri 'e ala, “Taa 'e tau ma 'ai fo ka mae nainali lo 'ala 'uri fo?” ");
INSERT INTO lgl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus ka olisi 'uri 'e adaulu, “Lakae ilia famoulu, ala 'amu fakwalaimoki ma iko 'ali 'amu malata ruarua, 'amu sai ala taunala mola 'amiu 'are ba'ela ka liufia me 'are 'e lau taua ala 'ai figi 'e li. Ala 'amu ilia fala fe uo fo, ‘'O la, ko io 'i laola asi,’ 'urila kae la mola 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ala 'amu foasia God, ma 'amu ka fakwalaimoki God kae taua 'are 'amu sugaada gi, 'i lia kae taua mola 'ala.” ");
INSERT INTO lgl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Talasi Jesus 'e oli lou 'i laola Luma Abu God fala falalaunala ioli gi li, fata abu ba'ela gi, ma nali wale etaeta ala Jiu gi, gera la mae 'i so'ela. Ma gera ka soilidi 'uri 'e ala, “Nanatana taa 'e 'o too ai fala taunala 'are 'e gi? Ma ite lo 'e kwatea nanatana 'e famu?” ");
INSERT INTO lgl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma Jesus ka olisi 'uri 'e adaulu, “Lakae soilidi 'amoulu ga fala me 'are. Ala moulu olisia, laka bi faarono 'amoulu 'alia nanatana 'e lau too ai fala taunala 'are 'e gi li. ");
INSERT INTO lgl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Moulu ilia ga fagu, nanatana ba John 'e too ai fala fasiuabu na li, 'e fuli mae faasia 'i fe? 'E fuli mae ala God, 'o ma 'e fuli mola mae ala ioli?” Ma gera ka fuli'ae ala alafaitalilina 'i safitadaulu kwailiu 'uri 'e, “Taa 'e golu kae ilia? Ala golu olisia ma golu ka sae 'uri 'e, ‘Faasia God,’ 'i lia kae sae 'uri 'e, ‘'Urilali ma 'utaa iko 'ali 'amu fakwalaimokia John?’ ");
INSERT INTO lgl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma ala golu sae 'uri 'e, ‘Ioli mola 'e kwatea nanata na fala John ka fasiuabua ioli gi, iko lou God,’ ioli 'e gi gera kae ogata'a fagaulu.” Gera mau, sulia ioli gi gera ilia John 'i lia te profet. ");
INSERT INTO lgl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Lia fo gera ka olisi mola 'uri 'e ala Jesus, “Meulu raria lou ite 'e ilia fala John ka fasiuabua ioli gi.” Ma Jesus ka sae 'uri 'e fadaulu, “'Eo, ala 'e 'urila, 'i lau wasua ikoso lau ilia lou famoulu ite 'e kwatea nanatana 'e fagu.” ");
INSERT INTO lgl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ma Jesus ka sae lou 'uri 'e fadaulu, “Moulu malata 'utaa sulia me 'are 'e? Te wale 'e too ala rua wela wale gi. Ma ka la 'i so'ela wela 'i lao, ka sae 'uri 'e fala, ‘Ulufa'alu lau, tara'ela ko la, ma ko galo 'i laola raku ba golu.’ ");
INSERT INTO lgl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ma wela fo 'i lao ka olisi 'uri 'e ala, ‘Lau barasi wani.’ Sui 'i buri, ka olisia malatala, ma ka la lo 'i raku. ");
INSERT INTO lgl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","'I burila, mama ka la lou 'i so'ela ruala wela lia, ma ka ilia lou me alaana fo fala. Ma wela fo ka olisia 'uri 'e, ‘'E 'oka mola 'ala lakae la.’ Wasua ma iko 'ali la mola. ");
INSERT INTO lgl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“'Uri fo ma ite adaroa lo 'e taua 'are ba mama daroa 'e oga?” Ma gera ka olisi 'uri 'e ala, “Wela ba 'i lao.” Ma Jesus ka sae 'uri 'e fada, “'Are kwalaimoki lakae ilia famoulu, ioli ta'a 'e gera golia bata ala takisi li, ma geli tau ta'a 'i labata gi, gerakae etae ruu 'i laola maurina 'e God kae 'ilitoa fafia 'i lao amiu. ");
INSERT INTO lgl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sulia John wale fasiuabu ba dao lo mae 'i soemiu fala fatailianala iona 'e God 'e oga famiu 'ali 'amu io sulia, ma iko 'ali 'amu fakwalaimokia mola. Wasua ma, ioli pekopeko 'e gera golia bata ala takisi li, failia geli tau ta'a 'i labata gi, gera fakwalaimokia John. Wasua 'amu lesia 'amiu 'are fo gi, iko 'ali 'amu fakwalaimokia mola John, ma iko 'ali 'amu olisia mola malatamiu.” ");
INSERT INTO lgl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesus ka sae lou 'uri 'e fada, “Moulu ronoa ga lou te tarifulaana 'e. Te wale 'e fasia raku. Ma ka raunailia banisi galia, ma ka 'elia te gilu fala manisianala fuae 'ai gi fala raunailinala waen, ma ka raunailia te luma fala ioli lio folo li. Ma ka alua raku lia 'i lofola limala ioli gera galo 'i laola gi. Sui ka la lo 'ala fala na mae falua. ");
INSERT INTO lgl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma talasi raku fo 'e maua, ka keria mae ioli li galona lia gi fala 'i soela ioli fo gera lio sulia raku lia gi li, 'ali gera kwatea ko ta gula ala fuae 'are gera fisuda gi. ");
INSERT INTO lgl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ma ioli fo gera lio sulia raku fo gi li, gera daua ioli li galona fo lia gi, ma gera ka rabusia etala wale, ma ruala wale gera ka raunia ka mae lo, ma olula wale gera ka 'uia 'alia fau la la ka mae. ");
INSERT INTO lgl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sui ka keria lou nali ioli li galona afula lou liufia 'i lao fadaulu. Ma ioli fo gera lio sulia raku fo gi li, gera ka tau lou 'urifo ada. ");
INSERT INTO lgl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma suinai, ka keria lo wela moutae lia 'i soedaulu. Sulia 'e malata 'uri 'e, ‘Gera kae lio 'ato ala wela lau.’ ");
INSERT INTO lgl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Sui ma talasi fo ioli fo gi gera lesia lo wela fo lia li, gera ka alaa 'uri 'e 'i matanadaulu, ‘Wela wale 'e too ala raku li lo 'e. Golu raunia ka mae, 'ali golu sakea lo 'agaulu 'are 'e lia gi sui.’ ");
INSERT INTO lgl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma gera ka daua, gera ka 'ui 'alia 'i maluma faasia raku fo, ma gera ka raunia ka mae. ");
INSERT INTO lgl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“'Urifo ma talasi wale 'e too ala raku li 'e dao mae, taa kae taua ala ioli fo gera lio sulia raku lia li?” ");
INSERT INTO lgl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma gera olisi 'uri 'e ala, “'I lia kae raunia ioli ta'a fo gi gera kae mae, ma kae kwatea lou raku lia fala tali ioli mamata gera saiai gera kae kwatea ta gula ala 'okanala raku fala ala talasi ala fisu 'are na li.” ");
INSERT INTO lgl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma Jesus ka sae 'uri 'e fada, “'E kwalaimoki 'amu idumia Geregerena Abu ba 'e sae 'uri 'e, ‘Fau 'e wale raunae luma gi gera barasi 'alia, lia lo fau age 'e 'ilitoa ka liufia fau gi sui ala balibali. God 'e tafanailia 'are fo, ma lesinai ka 'oka rasua.’ ");
INSERT INTO lgl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ma lia 'e laka ilia famoulu, 'oilakina ala 'ilitoanala God kae lafua faasi 'amiu, ma kae kwatea fala ioli gera ronosulia gi. ");
INSERT INTO lgl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma ala ta ioli 'e toli 'i fofola fau fo, 'i lia kae manisi. Ma ite fau fo kae toli fafia, rabela kae meme sui.” ");
INSERT INTO lgl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ma talasi fata abu ba'ela gi failia Farasi gi gera ronoa tarifulaana fo li, gera ka saiai Jesus 'e sae sulida. ");
INSERT INTO lgl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","'Are la fo gera ka oga daunala. Wasua ma gera mau, sulia ioli afula gi gera logo ala talasi fo, gera fakwalaimoki ala Jesus lia 'e 'i lia profet. ");
INSERT INTO lgl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus ka sae lou 'alia tarifulaana fala ioli gi 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Tatalona God 'e 'uri 'e: Te walelitalona 'e raunailia fana na fala araarainala ulufa'alu lia. ");
INSERT INTO lgl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma ka keria ioli li galona lia gi 'afia ioli 'e kwaloda mae fala fanana fo li, 'ali gera la lo mae. Wasua ma gera barasi 'alia laa na mae. ");
INSERT INTO lgl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Sui ka keria lou nali ioli li galona, ka sae 'uri 'e fada, ‘Moulu faronoa ioli 'e lau kwaloda gi, fanana lau 'e kwaimamali lo. Lau raunia sui lo buluka ba'ela lau gi failia kale buluka 'oka lau gi, ma 'are gi sui ka kwaimamali lo. 'Amu la lo mae ala fanana 'e lau.’ ");
INSERT INTO lgl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Wasua ma iko 'ali gera ogaa mola ronona sulia, ma gera ka la mamata 'ada. Na wale 'e la 'ala 'i raku ala, ma na wale 'e la 'ala 'i laola sitoa lia. ");
INSERT INTO lgl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma nali wale gera daua ioli galona fo gi, gera ka kwaida, ma gera ka raunida. ");
INSERT INTO lgl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma walelitalona fo ka ogata'a rasua, ma ka keria lo wale li mae afula lia gi, ma gera ka raunia lo wale fo gera raunia ioli li galona fo lia gi li. Ma gera ka 'agofia lo falua ba'ela gera. ");
INSERT INTO lgl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Sui ka sae 'uri 'e fala ioli li galona lia gi, ‘Fana na 'e kwaimamali lo, wasua ma ioli ba lau kwaloda gi, iko 'ali gera totolia laa na mae ala fana na fae 'ameulu. ");
INSERT INTO lgl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Moulu la sulia tala gi, ma moulu ka soia mae ioli 'amu kae dao tonada gi sui, 'ali gera la mae ala fanana 'e.’ ");
INSERT INTO lgl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ma ioli li galona gi gera ka la sulia tala gi, ma geraka logosia mae ioli gera dao tonada gi sui. Ma fanana ala araaraina fo li ka fonu 'alia ioli 'oka gi failia ioli ta'a gi lou. ");
INSERT INTO lgl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sui talasi walelitalona 'e dao mae fala lesinala ioli fo gera dao gi li, ka lesia te wale iko 'ali 'e toro mola 'alia toro ala araaraina li. ");
INSERT INTO lgl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma walelitalona fo ka sae 'uri 'e, ‘Iko 'ali 'o toro mola 'alia toro fala fanana ala araaraina li 'urila iko 'ali 'oka 'ali 'o io 'i lifi'e.’ Ma wale fo iko 'ali ilia lo ta me 'are. ");
INSERT INTO lgl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Sui walelitalona fo ka ilia fala ioli li galona lia gi, ‘Moulu firi fafia limala failia 'aela wale 'e, ma moulu ka 'ui 'alia 'i laola lifi rodo fo 'i maluma, ala lifi fo ioli kae ani ma kae 'ala niriniri kae giria lifoda, sulia gera famalifii.’” ");
INSERT INTO lgl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sui Jesus ka sae lo 'uri 'e, “Ioli afula gi God 'e kwaloda, wasua ma barae ioli mola 'e filida.” ");
INSERT INTO lgl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farasi gi gera la, ma gera ka lokomalata fala fareronala Jesus 'alia 'are 'e ilida gi. ");
INSERT INTO lgl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma gera ka keria wale li galona gera gi failia nali wale gera oga kwalofa Herod ka walelitalona, 'i so'ela Jesus. Ma gera ka sae 'uri 'e, “Waleli Falalauna, meulu saiai 'are 'o ilida gi, 'are kwalaimoki gi sui mola. 'O faalalau mola sulia kwalaimoki na ma liola God fala ioli. Ma iko 'ali 'o 'ado mola failia taa gi ioli malata sulia. Ma iko 'ali 'o malata mola fala 'ilitoanala ta ioli. ");
INSERT INTO lgl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","'O ilia ga fameulu! 'Uri'e ma taki gia, 'e luia kwatenala bata ala takisi li fala wale 'ilitoa ala tatalona 'i Rom li? 'Uri'e ma 'e rada mola 'ala 'ali 'ami ka kwatea takisi fo, 'o iko?” ");
INSERT INTO lgl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma Jesus ka sai ala me malata ta'a gera gi, ma ka sae 'uri 'e, “'I 'amoulu ioli 'asa gi, 'utaa 'e moulu ka tau fala faareronagu? ");
INSERT INTO lgl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moulu fatailia ga fagu seleni la 'amu kae folifoli takisi 'alia.” Ma gera ka sakea mae me seleni ma gera ka fatailia fala. ");
INSERT INTO lgl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma ka soilidi 'uri 'e ada, “Ma lulula ite 'e ala me seleni 'e? Ma ratala ite 'e lou?” ");
INSERT INTO lgl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma gera ka olisi 'uri 'e ala, “Lulula failia ratala walelitalona 'i Rom.” Ma Jesus ka sae 'uri 'e, “'Amu kwatea fala walelitalona 'i Rom 'are lia gi, ma 'amu ka kwatea 'are God gi fala God.” ");
INSERT INTO lgl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ma talasi gera ronoa olisina fo 'e 'oka 'urifo, gera ka 'afero rasua, ma gera ka la lo 'ada faasia. ");
INSERT INTO lgl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ma ala fe atoa fo lou, nali Sadusi gera la mae 'i so'ela Jesus. Sadusi gi gera ilia 'uria ioli ikoso tatae lou faasia maenaa. ");
INSERT INTO lgl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ma gera ka soilidia Jesus, gera ka sae 'uri 'e, “Waleli Faalalauna, Moses 'e gerea taki faga ka alafuu 'uri 'e, ‘Ala ta wale 'e mae, ma wateu lia ka mauri 'ua, wasua ma iko 'ali too ala ta wela, walefae lia ka tolea lou 'orula, 'ali daro ka too ala ta wela 'ali ka tofulila wale fo 'e mae lo.’ ");
INSERT INTO lgl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma na kwalofa agaulu Jiu gi, gera too ala fiu walefae gi. Ma wale etaeta ka tolea te ulao. Talasi iko 'ali daro too 'ua ala ta wela, wale fo ka mae lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ma ruala wale ka tolea lou geli fo. Ma iko 'ali daro too 'ua lou ala ta wela, ka mae lou. Olula walefae ka tolea lou, ma ka mae lou 'urifo. 'E 'urifo la la fiu walefae fo gi, gera maemae ka sui. ");
INSERT INTO lgl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","'I burila barae walefae fo gera mae, geli fo lou ka mae lo. ");
INSERT INTO lgl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Geli fo 'e toletolea fiu walefae fo gi. Ala 'e 'urifo, talasi ioli gi kae tatae faasia maena li, ite ala fiu walefae fo gi lo arai kwalaimoki geli fo li?” ");
INSERT INTO lgl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus ka olisi gera 'uri 'e, “Moulu rero, sulia iko 'ali 'amu raea mola Geregerena Abu failia nanatanala God. ");
INSERT INTO lgl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sulia, talasi ioli mae gi gerakae tatae lou fala maurina li, gera kae malaa lo eniselo gi ikoso gera too geli lo. ");
INSERT INTO lgl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“'Eo, lakae faalalau 'amiu sulia tataena faasia maena li. Lau saiai 'amu idumia lia ba God 'e ilia 'ua lo mae 'i lao ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘'I lau God Abraham, ma God Aesak, failia God Jakob.’ Ma fadanai 'uri 'e, wale fo gi ba gera mae lo, God 'e ilia 'i lia God daulu 'ua, sulia daulu mauri failia.” ");
INSERT INTO lgl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ma talasi fo ioli afula gi gera logo galia Jesus, gera ronoa 'are fo gi, gera ka 'afero rasua 'alia falalaunala. ");
INSERT INTO lgl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ala talasi Farasi gi gera ronoa Jesus 'e faaloboa lo Sadusi gi 'alia olisina 'e tau ada li, geraka logo mae 'i so'ela. ");
INSERT INTO lgl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma te wale adaulu 'e faalalau 'alia taki li, ka mailia 'ali fareroa Jesus 'alia soilidinala 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wale Faalalau, taki taa 'e 'ilitoa ka liufia taki gia gi sui?” ");
INSERT INTO lgl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma Jesus ka olisia 'uri 'e, “'O kwaima ala God 'o 'alia manomu sui, ma 'alia liomu sui, ma 'alia malatamu sui. ");
INSERT INTO lgl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lia lo taki etaeta ma ka 'ilitoa ka tasa. ");
INSERT INTO lgl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma ruala taki 'e maala 'i lia lou, ‘'O kwaima ala iolimu ka rada lou failia kwaimana 'o too ai famu 'i talamu.’ ");
INSERT INTO lgl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ma taki faasia Moses gi sui, failia faalalauna profet gi li, gera 'ado sui 'i laola rua taki 'e gi.” ");
INSERT INTO lgl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ala talasi nali Farasi gera logo galia Jesus, 'i lia ka soilidi 'uri 'e ada ");
INSERT INTO lgl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Christ, wale 'e God 'e filia fala faamurinala ioli gi li, moulu ilia 'e futa mae ala ite?” Gera ka olisi 'uri 'e ala, “Christ kae futa mae ala kwalofa David walelitalona.” ");
INSERT INTO lgl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sui Jesus ka soilidi gera lou 'uri 'e, “Ala kae futa ala kwalofa David walelitalona, 'utaa ba Alo ala God ka sae 'uri 'e ala David, ");
INSERT INTO lgl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘God 'e sae 'uri 'e fala Aofia lau: 'O gwauru aba aolo agu, ma ko 'ilitoa faelau, maasia talasi lakae alua malimae 'o gi kae ronosuli 'o.’ ");
INSERT INTO lgl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“David 'ala 'i talala fo 'e soia Christ 'alia ‘Aofia’. Lia fo, Christ ulufa'alu ala kwalofa David li, ma 'i lia Aofia David lou.” ");
INSERT INTO lgl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma talasi fo, iko ta wale adaulu 'ali totolia lo olisinala 'alia ta me 'are. Ma gera ka 'eke lo 'ada faasia soilidinala lou Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","'I burila 'are fo gi, Jesus ka sae fala ioli fo gera logo mae gi, failia wale li galona lia gi 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Wale faalalau ala taki gi li, failia Farasi gi, gera too ala nanatana fala faalalauna 'alia taki Moses gi li. ");
INSERT INTO lgl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Lia fo, 'amu ka ronosulida, ma 'amu ka taua 'are gera ilida famiu gi sui. Wasua ma ikoso 'amu tau sulia taunada, sulia iko 'ali gera tau mola sulia 'are 'e gera sae sulida gi. ");
INSERT INTO lgl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Gera alua taki afula 'e 'ato fala ioli 'ali rono sulia, ma 'i gera talada iko 'ali gera marabe fala kwairanaina ala ioli fala tauna sulia taki fo gi li. ");
INSERT INTO lgl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ma gera taua 'are sui 'uri 'ali ioli ka lesida ma ka fia 'uria 'i gera ioli 'oka gi 'i gera. Ma 'are 'uri 'e gi gera tauda. Gera firia 'i maala darada ma 'i limada 'are afola ba'ela gera gerea Geregerena Abu gi ai. Ma gera ka taia 'are samusamua 'i 'a'aela to'omi tekwa gera gi. ");
INSERT INTO lgl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma gera ka oga rasua ala gwauruna ala lifi 'ilitoa ala fana na gi li, ma lifi 'ilitoa fala gwauruna 'i laola luma fala foana gi li. ");
INSERT INTO lgl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma gera ka oga rasua ala faba'ela nada 'i maala uusina gi, ma gera ka oga ioli ka sae 'uri 'e fada, ‘Waleli Falalauna lau, lau rono sulia saenamu.’ ");
INSERT INTO lgl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Wasua ma iko 'ali 'oka fala ta ioli mola 'ala 'ali ka sae 'uri 'e suli 'amiu, ‘Waleli Falalauna lau, lau rono sulia saenamu,’ sulia 'i lau mola teke wale faalalau 'amiu, ma 'i 'amoulu alae waasila 'i laola logonae fakwalaimokina. ");
INSERT INTO lgl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma ikoso 'ali 'amu fa'ilitoa ta wale faalalau 'i laola molagali 'e 'alia saena 'uri 'e, ‘Mama 'ami,’ sulia 'amu ka fa'ilitoa mola teke Mama 'amiu lia 'e io 'i nali. ");
INSERT INTO lgl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma iko 'ali 'oka fala ta ioli 'ali soi 'uri 'e 'amiu, ‘Wale ba'ela,’ sulia 'amu too mola ala teke wale ba'ela, ma 'i lia lo 'e 'i lau, Christ, wale God 'e filia fala faamurinala ioli li. ");
INSERT INTO lgl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ala ta ioli amoulu 'e oga ka ba'ela 'i safitamoulu, 'i lia ka malaa ioli li galona. ");
INSERT INTO lgl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma ioli kae fabaelaa lia 'ala 'i talala, God kae fasifoa. Ma ioli kae fawawade lia 'i talala, God kae soi ba'ela ala.” ");
INSERT INTO lgl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Ma Jesus ka sae lou 'uri 'e, “'E ta'a rasua famoulu alae wale faalalau 'e ala taki gi li failia 'i 'amoulu Farasi gi, 'i 'amoulu ioli 'asa gi! God kae kwai 'amiu, sulia 'amu folo bolosia maala luma ala Tatalona God faasia ioli. 'I 'amoulu lou iko moulu oga mola ruuna 'i laola Tatalona God, ma 'amu ka bolosia ioli gera malatasusuu fala ruuna gi li. ");
INSERT INTO lgl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“'E ta'a famoulu wale ala taki gi li ma 'i 'amoulu Farasi gi wale 'asa 'e 'amu 'oi 'ala ioli, 'ali gera ka iili 'amiu 'alia ioli 'oka gi li. God kae kwai 'amiu, sulia 'amu ulafu rasua 'alia galinala lifi gi sui, 'i laola asi failia laola tolo, fala daona tonala ioli li, 'uri 'ali ka liu sulia taki Moses gi. Talasi ioli fo ka la mola suli 'amoulu, moulu bi rerei 'alia fala laa na fala lifi ala maena li. Ma kwaikwaina lia ka bi ba'ela ka liufia 'amoulu sulia abulonala ta'a ka liufi 'amoulu lou. ");
INSERT INTO lgl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“'E ta'a famoulu, ma moulu malaa lo ioli maa koro gera talaia ioli gi li. Lia fo, God kae kwai rasua amiu, sulia 'amu faalalau 'uri 'e ala ioli, ‘Wasua ta ioli mola 'ala 'e fanasia alafuuna lia 'alia Luma Abu God, 'e 'oka mola 'ala ala iko 'ali taua lo me 'are fo 'e alafuu fai. Wasua ma ala ka fanasia alafuuna lia 'alia goulu ba 'i laola Luma Abu God li, 'i lia lo 'e abu rasua faasia 'oianala alafuu na lia.’ ");
INSERT INTO lgl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Maa moulu 'e koro, ma moulu ka kwekwe'ela rasua. Ta 'e ba'ela, goulu 'o ma Luma Abu God 'e taua goulu fo ka abu? Luma Abu God 'e ba'ela ka liufia goulu! ");
INSERT INTO lgl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma moulu faalalaua lou ioli 'uri 'e, ‘Wasua ta ioli ka fanasia alafuuna lia 'alia 'ere fau, 'e 'oka mola 'ala ala iko 'ali taua me 'are 'e alafuu fai. Ma ala 'e fanasia alafuuna lia 'alia foasina 'e io 'i fofola 'ere fau li, mali fo lo 'e abu ka tasa faasia 'oianala alafuu na fo lia.’ ");
INSERT INTO lgl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Maa moulu 'e koro. Ta 'e ba'ela, foasina 'o ma 'ere fau fo 'e kwatea foasina ka abu? 'Ere fau 'e 'ilitoa ka liufia foasina. ");
INSERT INTO lgl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Dunala 'ere fau 'e 'ilitoa ka liufia foasina, ite 'e fanasia alafuuna lia 'alia 'ere fau, 'e alafuu 'alia 'ere fau lobaa failia foasina gera io 'i fofola 'ere fau fo gi li sui. ");
INSERT INTO lgl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma ta ioli mola 'ala 'e fanasia alafuuna lia 'alia Luma Abu God, 'urifo ma 'e alafuu lo 'alia God lia 'e io 'i laola Luma Abu fo li. ");
INSERT INTO lgl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma ala ta ioli ka fanasia alafuuna lia 'alia 'i nali, ma 'e alafuu 'alia ioiona God tela, ma God 'e io lou 'i nali. ");
INSERT INTO lgl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“'E ta'a famoulu wale faalalau ala taki gi li ma 'i 'amoulu Farasi gi, 'i 'amoulu wale 'asa gi. God kae kwai 'amiu. Moulu kwatea tanafulula 'are fala God ala keme 'are 'amu fasida 'i laola raku 'amiu gi li fala faa fana'oka nala fana 'amiu gi, ma iko 'ali 'amu malata 'abero mola fala ronona sulia falalauna ba'ela ala taki gi li. Falalauna ba'ela ala taki li 'e sae 'uri 'e, ‘Ioli ka tau 'are rada fala ioli gi sui. Ka kwaiamasi ala ioli ma saenala ka kwalaimoki.’ 'Amu taua 'are fo gi, failia 'are wawade 'i laola taki gi li lou. ");
INSERT INTO lgl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Moulu malaa wale maa koro 'e talaia ioli li. Moulu sai mola 'amoulu ala malata 'aberona fala laa na sulia keme 'are wawade 'i laola taki li. Ma iko 'ali moulu malata 'abero mola 'alia 'are ba'ela 'i laola taki gi li. Talasi 'amu tau 'urifo, ka lio malaa 'amu lafua mola 'amiu me lano bulu faasia taa 'e 'amu goufia, wasua ma 'amu olomia 'amiu te kamel ba'ela laulau. ");
INSERT INTO lgl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“'E ta'a famoulu wale faalalau ala taki gi li ma 'i 'amoulu Farasi gi lia 'e 'amu saiala taunala 'are 'uri 'ali ioli ka babalafe 'ali 'amiu. God kae kwai 'amiu, sulia 'amu madafia rasua saunala rabela teu fala fana na li, wasua ma 'amu fafonua 'alia fana 'amu sakea 'alia suunae nala ioli sulia 'amu fana'ete. ");
INSERT INTO lgl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","'I 'amoulu Farasi gi maamoulu 'e koro! Moulu olisia malata 'amoulu gi ka kwaga. Ala malata 'amiu gi ka kwaga, abulona 'amiu gi wasua ka kwaga lou. 'Urifo, manomiu ka malaa teu 'e kwaga sui 'i rabela failia 'i laola. ");
INSERT INTO lgl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“'E ta'a famoulu wale faalalau ala taki gi li failia 'i 'amoulu Farasi gi, moulu tau 'ali ioli 'e soi 'amiu 'alia wale 'oka gi. Wasua ma God kae kwai 'amiu, sulia 'amu malaa gigiluna gera uulia ma lesinai ka 'oka 'i maluma, wasua ma 'i laola 'e fonu 'alia sulii failia rabela ioli 'e mae, ka wa'a lo gi. ");
INSERT INTO lgl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Me 'are 'e 'e kwalaimoki amoulu, sulia 'are 'amu tauda gi 'e lio 'oka rasua maala ioli gi. Wasua ma manomoulu 'e ta'a rasua, ma moulu saiala kotofinala ioli. ");
INSERT INTO lgl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“'E ta'a famoulu wale faalalau ala taki gi li, ma 'i 'amoulu lou Farasi gi, 'amu saiala taunala 'are 'ali ioli soi 'oka amiu. Wasua ma God kae kwai 'amiu, sulia 'amu ilia 'uri ala 'amu ka ioio ala talasi 'i lao gi, ikoso 'ali 'amu ranaa mola koko 'amiu gi fala rauninala profet gi. 'Uri 'i 'amiu lo 'amu ka alua fau 'oka 'i fofola gigiluna profet fo gi li, failia ioli 'oka 'i lao gi 'ali gigiluna gera gi 'e lio 'oka. ");
INSERT INTO lgl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Talasi 'amu ilia 'i gera lo koko 'amiu gi li, 'e fatailia 'amu futa oliolitala kwalofa koko ta'a 'amiu gera raunia profet fo gi 'i lao. ");
INSERT INTO lgl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ala 'e 'urila, faasuia lo 'amiu galona fo koko 'amiu gi gera fuli'aea lo mae 'i lao! ");
INSERT INTO lgl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Abulona 'amiu 'e malaa fe wa gi. 'E 'ato rasua 'ali 'amu tafi faasia kwaikwaina 'alia dunaa ala lifi fala maenaa li. ");
INSERT INTO lgl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Dunala 'are fo gi, laka ilia 'are 'e famoulu, lakae keria tali profet failia tali ioli sai 'are failia tali wale faalalau 'i soemiu. Ma tali ai 'amu kae raunida ma 'amu ka fotoida ala 'ai rara folo. Ma tali ai 'amu kae dauda ma 'amu kae rabusida 'i laola luma fala foana 'amiu gi li, ma 'amu kae tabali kwailiu ada faasia 'i laola falua 'amiu gi. ");
INSERT INTO lgl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Lia 'e taua God kae kwai 'amiu fafia raunina 'amu taua ala ioli gi sui, fuli'ae mae ala maenala Ebol, wale rada ba, lala mae ka dao ala maenala Sekaraea, wela Barakaea lia 'amu raunia ka mae garania 'ere fau 'i laola Luma Abu God. ");
INSERT INTO lgl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Lakae ilia famoulu kwaikwaina fala maenala wale fo gi li sui kae io fafia ioli ala talasi 'e li.” ");
INSERT INTO lgl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ma Jesus ka lio ko fala falua 'i Jerusalem, ma ka sae 'uri 'e, “Iolila Jerusalem 'e! 'Amu 'uia profet ba God 'e kerida mae famiu gi 'alia fau gi, ma 'amu ka raunida. Ala talasi afula lau oga 'ali 'amu la mae 'i soegu 'ali lau lio suli 'amiu malaa karai 'e ofia kalela 'i malula 'aba'abala. Wasua ma iko 'ali 'amu oga mola. ");
INSERT INTO lgl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ma talasi 'e lo, God kae la lo faasi 'amiu, ma kae faeburi lo 'alia falua 'amiu. ");
INSERT INTO lgl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma lakae ilia famiu, ikoso 'ali 'amu leesi lau lou, la la ka dao ala talasi la 'amu kae sae 'uri 'e, ‘God, 'o 'oilakitailia wale 'e la mae 'alia nanatana 'o li!’” ");
INSERT INTO lgl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","'I burila Jesus 'e sae 'urifo ka sui, ka la lo faasia Luma Abu God. Ma talasi Jesus kae la ko, alae wale li galona lia daulu ka la mae 'i so'ela, ma daulu ka sae 'uri 'e, “'O lesia ga luma 'oka 'e galia Luma Abu gi li.” ");
INSERT INTO lgl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus ka sae 'uri 'e fadaulu, “'Eo, moulu lesia luma ba'ela 'e gi. Ikoso ta teke me fau 'i lifi'e ala Luma Abu God kae io 'i fulila. 'I gera sui gerakae tagalae 'i wado.” ");
INSERT INTO lgl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Burila Jesus ka rae gwaula fe uo 'i Olif, ma talasi 'e gwauru wale li galona lia gi daulu la mae 'i so'ela, ma daulu ka io 'adaulu talifili daulu. Ma daulu ka soilidi Jesus 'uri 'e, “Talasi taa 'e 'are 'e 'o ilida fameulu gi kae fuli ai? Ma taa kae fuli 'ali fatailia talasi 'o fala olina mae failia talasi molagali kae sui ai?” ");
INSERT INTO lgl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Jesus ka olisi 'uri 'e adaulu, “'Amu ka lio suli 'amiu, sulia wale afula gi gerakae la mae 'i lulufala ratagu, ma gerakae kotofi 'amiu, gerakae sae 'uri 'e, ‘'I lau lo Christ, wale ba God 'e filia.’ Ma talasi gera taua 'are fo gi li, ioli afula kae fakwalaimokia kotona fo gera gi. Ma 'amu ka lio suli 'amiu, taufasia ta wale ada bi kotofi 'amiu, ma 'amu ka fakwalaimoki ala kotona gera gi. ");
INSERT INTO lgl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma na 'are lou, moulu kae rono ala mae ala falua garani gi li, failia alaana sulia maee li ala nali falua tatau lou mae. Ka 'urila wasua 'ala, ikoso 'ali 'amu malata fiitala sulida. 'Are 'urifo gi kae dao mae, wasua ma ikoso 'ali fatailia suinala molagali. ");
INSERT INTO lgl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Mae falua gi gerakae kwalaa kwailiu 'i matanada, failia tatalona gi gerakae kwalaa kwailiu 'i matanada. Ma fiolo kae dao ala lifi gi sui ma lululu kae 'asu ala lifi gi sui. ");
INSERT INTO lgl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma 'are fo gi lia lo fulinala rabefiina, malaa mola 'ala geli faafutaa ba 'e fuli'ae ka fii lo fala too wela na li. ");
INSERT INTO lgl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ala talasi fo lou, ioli ala mae falua mamataa kwailiu 'i laola molagali li ikoso gera oga 'amiu, sulia 'i 'amiu ioli lau gi. Ma tali ioli ada gerakae dau 'amiu, ma gerakae kwate 'amiu fala malimae 'amiu gi fala kwainamiu ma fala rauninamiu. ");
INSERT INTO lgl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma nali ioli afula gera fitoo agu, ikoso gera dau nanata ala fitoona gera gi. Ma ioli gi gerakae malimae kwailiu 'i safitada. Ma gera kae kwatea ioli God gi fala malimae gera gi. ");
INSERT INTO lgl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma ala talasi fo, profet kotokoto afula kae dao mae, ma gera kae talaida, ma gerakae kotofia ioli afula kae la sulia faalalauna rero fo gera gi. ");
INSERT INTO lgl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma gerakae taua 'are rero afula rasua gi. Ma fofola me 'are fo, kwaimanaa ioli afula gi li kae watoutou. ");
INSERT INTO lgl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wasua ka 'urifo 'ala, ala ta ioli 'e nanata fala laa na sulia God la la ka dao ala suinala talasi fo, 'i lia God kae faamauria. ");
INSERT INTO lgl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma Faronona 'Oka 'e sulia Tatalona God, gerakae faarono 'alia 'i laola molagali fala ioli gi sui. Buri 'ala lo, suinala molagali ka bi dao mae. ");
INSERT INTO lgl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ma moulu kae lesia 'Are Fa'uli'uli kae tatae mae ala lifi abu. Te 'are ta'a fo kae fa'uli'ulia Luma Abu God, ma kae tau 'ali God kae manisia. 'Are ba profet Daniel etae sae lo mae sulia 'i lao.” (Alaana fala ioli 'e kae idumia 'e 'uri 'e: 'O malinailia 'oka ala malutala 'are 'e.) ");
INSERT INTO lgl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Talasi 'amu ka lesia 'are 'e gi kae dao mae, ioli gera io ala provins 'i Judea gi li, gerakae tafi fala gwaula fe uo gi. ");
INSERT INTO lgl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ala talasi fo, ala ta ioli 'e io 'i maluma ala luma lia, 'i lia ka tafi nainali lo, ma ikoso 'ali malata lou fala ruuna 'i laola luma lia fala sakenala ta me 'are 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma ite 'e io 'ala 'i laola raku, ikoso 'ali 'e oli lou 'i luma fala ta toro 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kwaimalataina ba'ela rasua fala barae geli gera dodolanaa gi, ma gera ka faasusua wela wawade gi li ala talasi fo, sulia 'e 'ato rasua 'ali gera tafi nainali. ");
INSERT INTO lgl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","'Eo, 'amu ka foa ma 'amu ka sugaa God, 'ali 'are fo gi ikoso fuli ma 'amu ka tafi ala talasi ala gwarii li, 'o ma ala Sabat, atoa ala mamalona li. ");
INSERT INTO lgl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dunala famalifiina ala fe atoa fo gi li, kae ta'a ka liufia famalifiina ioli 'i laola molagali li gera saiai, fuli 'ua mae ala talasi God 'e raunailia molagali la la ka dao ala talasi 'e. Ma ikoso 'ali ta 'are 'urifo 'ali kae fuli lou 'i buri. ");
INSERT INTO lgl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma ala God ikoso fadodokoa talasi ala famalifiina li, 'e 'ato 'ali ta ioli 'ali mauri. Ma 'e fadodokoa talasi fo fala 'okanala ioli 'e filida gi. ");
INSERT INTO lgl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“'Eo, ala ta ioli ka sae 'uri 'e famiu, ‘Lesia, lia lo 'e Christ,’ 'o ma ka sae 'uri 'e, ‘Lesia, lia 'i lokoo,’ ikoso 'ali 'amu fakwalaimokia ");
INSERT INTO lgl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sulia ioli kotokoto gi kae dao mae, ma gerakae sae 'uri 'e, ‘'I lau Christ,’ failia ioli kotokoto gi gerakae sae 'uri 'e, ‘'I lau na profet.’. Ma gerakae fulia 'are mama'ala ba'ela gi 'uri 'ali gera talai rero ala ioli 'e God 'e filida gi wasua ma 'e 'ato rasua fada. ");
INSERT INTO lgl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Lia fo, wasua 'are 'e gi iko 'ali gera fuli 'ua, lakae ilia lo famiu 'i lao 'ali 'amu saiali. ");
INSERT INTO lgl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","“Ala talasi 'i lau, Wela Wale li, lakae oli mae, ioli gi sui gerakae leesi lau. Malaa lou lia 'e 'amu saiala lesinala kwanaa faasia tataenala da'afi ka dao ala suunala da'afi 'i laola raloo talasi kae kwana. Ala tali ioli gera sae 'uri 'e famiu, ‘Christ 'e io 'i laola abae lifi kwasi,’ ikoso 'ali 'amu la fala lifi la. Ala tali ioli gera sae 'uri 'e famiu, ‘Christ 'e agwa 'i lifi'e,’ ikoso 'ali 'amu fakwalaimokia alaana 'urifo gi. ");
INSERT INTO lgl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Olinagu mae ikoso ta ioli 'ali'e talafia, ka malaa lou lia malububu ikoso talafia ta 'are 'e mae.” ");
INSERT INTO lgl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“'I burila talasi famalifiina fo gi ka sui bui, ‘God kae bolosia da'afi, failia madama, ma ikoso 'ali daro tala. Ma God kae kwatea kwalikwali gi gerakae toli faasia 'i laola raloo. Ma God kae taua 'are 'i nali gi, gerakae la rero faasia fulida.’ ");
INSERT INTO lgl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Buri 'ala 'are fo gi, totofo ala olinagu mae ka bi fatae mae 'i laola raloo. Ma ala talasi fo mola, ioli gi sui 'i laola molagali, gerakae ani sulia gera kae leesia lakae oli mae 'i fofola me dasa 'i laola raloo, ma lakae la mae failia nanatana lau failia wasinosinona ba'ela lau. ");
INSERT INTO lgl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma eniselo kae ufia bunu kae ani ba'ela fala logosinala ioli lau filida sui lo gi. Ala talasi fo, lakae keria mae eniselo lau gi, 'ali gera logosia mae ioli lau gi faasia falua 'i laola molagali gi li sui.” ");
INSERT INTO lgl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mola, Jesus ka sae sulia tarifulaana 'uri 'e, “'Amu malata ga sulia 'ai figi gi. Talasi 'amu lesia 'abala 'e uulua 'oka, 'amu ka saiai talasi ala 'ago'agonali 'e dao garani lo. ");
INSERT INTO lgl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ka 'urifo lou, talasi 'amu lesia famalifiina fo gi sui kae dao mae, 'amu ka saiai olinagu mae 'e garani lo. ");
INSERT INTO lgl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'Are kwalaimoki 'e lakae ilia famiu, ioli gera mauri ala talasi 'e li sui ikoso 'ali gera mae 'ua ma 'are 'e gi ka fuli. ");
INSERT INTO lgl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","'Are 'i nali gi ma 'are 'i laola molagali gi li, gerakae sui. Wasua ma saenagu 'ato 'ali sui. ");
INSERT INTO lgl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Iko ta ioli 'ali 'e saiala talasi lakae oli mae ai. Eniselo gi wasua iko 'ali gera sai lou ai, ma 'i lau, Wela wasua, iko 'ali lau sai lou ai. God Mama talifilia mola 'e saiai. ");
INSERT INTO lgl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Olinagu mae kae malaa 'are ba 'e fuli ala talasi ba Noa li. ");
INSERT INTO lgl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ala fe atoa ba 'i lao ala kwai afe ba'ela ba li, ioli gi gera fana ma gera ka gou 'ada, ma wale gi failia geli gi gera ka arai 'ada ma gera ka kwate geli 'ada kwailiu, la la ka dao ala fe atoa ba Noa 'e rae 'i laola faga ba'ela ba lia li. ");
INSERT INTO lgl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Wasua 'ala, gera raria 'ua ta 'e kae dao mae, la la ka dao ala talasi la kwai afe ba'ela ba 'e dao mae, ma ka sakeda sui lo. Ma kae 'urifo lou ala talasi lakae dao mae ai. ");
INSERT INTO lgl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ala talasi fo, rua wale gi daro galo 'i laola raku. Ma lakae sakea ta teke wale fae lau, ma ta teke wale ka io lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma rua geli gi lou daro kae galo fana 'adaroa, ma na teke ai lakae sakea, ma ruala lakae tafisia. ");
INSERT INTO lgl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","'Amu ka liolio 'oka, sulia 'amu raria fe atoa ta 'e 'i lau, Aofia 'amiu, lakae dao mae ai. ");
INSERT INTO lgl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'Amu ka malata tonala 'are 'e gi, ala ioli ala luma 'e sai mola 'ala ala talasi ioli belibeli kae dao mae ai, 'urila kae liolio 'oka ma ikoso ala'alia ioli belibeli fo ka ruu mae 'i laola luma lia. ");
INSERT INTO lgl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Lia fo, 'amu ka rerei lou, sulia lakae dao mae ala talasi la iko 'ali 'amu saiai.” ");
INSERT INTO lgl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ma Jesus ka sae lou 'uri 'e fala wale li galona lia gi, “'Amu malaa lo wale li galona la 'e liotoo ma ka galo rada. Ma arai ba'ela ka alua ka lio sulia ioli galona gi, ma ka kwatea fana fada ala talasi fala kwate fana na li. ");
INSERT INTO lgl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ma 'oilakina fala wale li galona fo talasi arai ba'ela 'e dao fafia ma 'e taua 'are fo gi li, ala talasi 'e dao mae 'i luma lia li! ");
INSERT INTO lgl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Lakae ilia 'are kwalaimoki famiu, wale ba'ela fo kae alu lia ka lio sulia 'are lia gi sui. ");
INSERT INTO lgl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Wasua ma, ala 'i lia wale li galona ta'a, 'i lia kae malata 'uri 'e, ‘Arai ba'ela lau, daonala mae 'e tatau 'ua,’ ");
INSERT INTO lgl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ma ka fuli'ae fala kwainala ioli galona gi, ma ka io li fana lo 'ala ma ka gou waen lo 'ala failia ioli gou waen gi. ");
INSERT INTO lgl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sui arai ba'ela ka dao mae ala ta atoa iko 'ali kwaimamali ai, fe atoa iko 'ali 'e saiai. ");
INSERT INTO lgl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Arai ba'ela kae kwatea kwaikwaina 'afaa fala ma ka alua failia ioli 'asa gera koto 'alia galona 'ala God gi. Ma talasi kae io ala lifi fo li, kae ani ma kae giria lifola, sulia kae famalifii rasua.” ");
INSERT INTO lgl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ma Jesus ka sae lou 'uri 'e, “Talasi ala oli nagu mae, Tatalona God kae malaa akwala geli ulao gera sakea fe fakwaru gera gi li, ma gera ka kwaimamali masia arai fa'alu kae la mae kae sakeda fala fanana ala araaraina li. ");
INSERT INTO lgl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ma na lima geli ulao daulu nonoe, ma na lima ai daulu ka malata. ");
INSERT INTO lgl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Te geli ulao nonoe fo gi gera sakea fe fakwaru gera gi, wasua ma iko 'ali gera sakea mola ta waiwai ala 'olif 'ali ka totolia fakwarunala fakwaru daulu gi 'alia. ");
INSERT INTO lgl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma ai malata fo gi gera sakea 'au ba'ela ala waiwai ala 'olif li fala fakwaruanala fakwaru daulu gi. ");
INSERT INTO lgl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Arai fa'alu fo iko 'ali dao nainali, ma geli ulao fo gi maadaulu ka momosula sui, ma gera ka mo'osu lo 'ada. ");
INSERT INTO lgl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ma matoula boni, ioli gi gera rii 'uri 'e, ‘Arai fa'alu 'e dao lo mae! 'Amu la, ma 'amu ka manotonala.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Te akwala geli ulao fo gera ka tatae, ma gera ka fakwarua lo fakwaru gera gi. ");
INSERT INTO lgl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma geli ulao nonoe fo gi gera ka sae 'uri 'e fala geli ulao malata fo gi, ‘Moulu kwatea ta waiwai ala 'olif fameulu fali fakwaru 'ameulu, sulia waiwai 'olif 'ameulu fala fakwaruna li kae garani sui lo.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Sui ulao malata fo gi daulu ka olisi 'uri 'e adaulu, ‘Iko, sulia 'e iko 'ali totoli golu sui. Moulu la ala ta luma, 'ali moulu folia ta waiwai 'olif fala fakwaru na 'amoulu.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ma talasi gera la fala folinali, arai fa'alu fo ka dao mae. Ma ulao fo gera rerei gi, gera ka la lo failia fala fanana ala araaraina li. Ma gera ka folo lo bolosia mala luma. ");
INSERT INTO lgl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“'I burila geli ulao ba gi, daulu ka dao lou mae, daulu ka sae 'uri 'e, ‘Arai fo! 'O tafalia ko mala luma fameulu!’ ");
INSERT INTO lgl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma arai fa'alu fo ka olisi 'uri 'e adaulu, ‘'Are kwalaimoki lakae ilia famoulu, lau rari 'amoulu.’” ");
INSERT INTO lgl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ma Jesus ka faasuia lo tarifulaana fo 'uri 'e, “Ta 'e, 'amu ka liolio 'oka, sulia 'amu raria fe atoa 'o ma talasi lakae oli mae ai.” ");
INSERT INTO lgl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sui Jesus ka ilia lou tarifulaana 'e fala wale li galona lia gi, “Ala talasi lakae oli mae, Tatalona God 'e malaa te wale la 'e la ala te lifi tatau, ma ka soia ioli li galona lia gi, ma ka kwatea gera ka lio sulia too 'arena lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma ka kwatea lima to'oli seleni gi fala na wale. Ma fala na wale lou, 'e kwatea rua to'oli seleni gi. Ma fala na wale lou, ka kwatea teke to'oli seleni. 'E kwatea ka totolia lo sai arena daulu gi. Sui ka la lo sulia lalana lia. ");
INSERT INTO lgl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma wale fo 'e sakea lima to'oli seleni gi li, 'e galo 'alida, ma ka too lou ala na lima to'oli seleni fafia. ");
INSERT INTO lgl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma wale ba 'e sakea rua to'oli seleni gi li, 'e galo lou 'alida, ma ka too ala na rua to'oli seleni lou fafia. ");
INSERT INTO lgl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wasua ma wale ba 'e sakea teke to'oli seleni gi li, 'e la ma ka 'elia te gilu 'i laola wado, ma ka faagwaa 'ala seleni ba arai ba'ela 'e kwatea fala gi. ");
INSERT INTO lgl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“'I burila keme talasi tekwa, arai ba'ela ba daulu ka oli mae, ma ka oga 'ali saiala seleni ba 'e aluda fae daulu gi. ");
INSERT INTO lgl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma wale ba 'e sakea lima to'oli seleni gi li, ka sakea lou mae na lima to'oli seleni, ma ka sae 'uri 'e, ‘Arai ba'ela, 'o kwatea lima to'oli seleni gi fagu ba. 'O lesia ga, lau sakea lou na lima to'oli seleni fafia.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ma arai ba'ela ka olisi 'uri 'e ala, ‘'I'o ioli li galona 'oka lau. Lau saiai laka fitoo amu! 'O galo 'oka 'alia 'are wawade gi, lia 'e lakae alu 'o, koe ba'ela fafia 'are afula gi. 'O la mae, ma ko io babalafe fae lau.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma wale ba 'e sakea rua to'oli seleni gi li ka dao lou mae. Ma ka sae 'uri 'e, ‘Arai ba'ela, 'o kwatea mola rua to'oli seleni gi fagu ba. 'O lesia ga, lau sakea lou na rua to'oli seleni fafia.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ma arai ba'ela ka olisia 'uri 'e, ‘'I'o ioli galona 'oka lau, lau saiai laka fitoo amu! 'O galo 'oka 'alia 'are wawade gi. Lia 'e lakae alu 'o, koe ba'ela fafia 'are afula gi. 'O la mae, ma ko io babalafe fae lau.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Sui wale ba 'e sakea teke to'oli seleni gi li ka dao mae. Ma ka sae fa'ali mola 'ala 'uri 'e, ‘Arai ba'ela, lau saiai 'i'o wale malatamu 'e iko 'ali sai ala tolina fafia ta me 'are li. 'O fisu 'are 'amua ala lifi la iko 'ali 'o fasia, ma ko sakea 'amua 'are ioli mamata gi li. ");
INSERT INTO lgl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","'Are la fo lau mau, ma laka lai faagwaa lo seleni ba 'o gi 'i laola wado. 'O lesia seleni ba 'o gi 'e mola 'ali.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ma arai ba'ela ka olisi 'uri 'e ala, ‘'I'o wale li galona ta'a 'i'o, ma ko 'e'ela ta'a. 'O sai mola 'amua ala lia 'e lau fisu 'are ala lifi iko 'ali lau fasida gi, ma laka sakea mola 'agua 'are ioli mamata gi li. ");
INSERT INTO lgl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ala 'o malata 'urila, 'utaa iko 'ali 'o alua mola seleni lau gi 'i laola lifi li alu bata na 'ali ka afula, ma ka dao ala talasi lau oli mae ai, 'ali laka sakea seleni fo gi ma seleni tarena gi failia.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Sui arai ba'ela fo ka sae 'uri 'e fala wale li galona lia gi lou, ‘Moulu sakea lo seleni la gi faasia, ma moulu ka kwatea fala wale 'e too ala akwala to'oli seleni gi li. ");
INSERT INTO lgl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sulia ioli gera too ala 'are afula gi li, lakae kwatea lou tali 'are fada, 'ali gera too 'are ka afula lou. Ma ite iko 'ali too ala ta 'are, ta 'are wawade wasua 'e too ai, lakae lafua faasia. ");
INSERT INTO lgl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma wale li galona 'e, moulu 'ui 'alia 'i maluma 'i laola mae rodo, lifi la ioli gi kae ani ani mola 'ada failia girinala lifoda sulia 'e famalifii rasua.’” ");
INSERT INTO lgl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus ka sae lou 'uri 'e fala wale li galona lia gi, “Talasi lau, Wela Wale li, lakae oli lou mae fala tatalofana failia eniselo gi li, lakae gwauru ala lifi li gwauru na 'ala wale tatalofa. ");
INSERT INTO lgl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ma ioli gi sui faasia falua gi sui gerakae logo mae 'i soegu. Ma lakae tolinia ioli gi sui, malaa na wale 'e lio sulia sipsip gi ka tolinia sipsip gi faasia nanigot gi. ");
INSERT INTO lgl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma laka alua lo ioli rada gi 'i aba aolo agu, ma ioli ta'a gi 'i aba mauli agu. ");
INSERT INTO lgl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Sui laka sae 'uri 'e fala ioli 'e gera io 'i aba aolo agu gi, ‘'I 'amiu lo ioli Mama lau 'e babalafe fae 'amiu gi. 'Amu ruu mae 'i laola 'Ilitoana 'e rerei 'alia famiu ala fulinala mae molagali li. ");
INSERT INTO lgl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sulia talasi lau fiolo ai, 'amu kwatea fana fagu. Ma talasi lau siligou ai, 'amu kwatea kwai fagu. Ma wasua 'ala lau ioli dao faasia na falua mamata, 'amu kwalo lau fala 'i laola luma 'amiu gi. ");
INSERT INTO lgl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma talasi lau dadala, 'amu kwatea toro fagu. Ma talasi lau matai, 'amu lio suli lau. Ma talasi lau io 'i laola raraa li, 'amu daofi lau.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sui ioli rada gi gera ka olisia 'uri 'e agu, ‘Aofia, talasi taa 'e 'ami lesia 'o fiolo, ma 'ami ka ranoli 'o? Talasi ta 'e 'o siligou, ma 'ami ka kwatea kwai famu? ");
INSERT INTO lgl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma talasi ta 'e 'i'o ioli dao faasia falua mamata li, ma 'ami ka kwalo 'o 'i luma, ma talasi ta 'o dadala ai, ma 'ami ka kwatea toro famu? ");
INSERT INTO lgl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma talasi ta 'e 'ami lesia 'o matai ai, 'o ma ko io 'i laola raraa, ma 'ami ka daofi 'o?’ ");
INSERT INTO lgl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ma laka olisida 'uri 'e, ‘'Are kwalaimoki lakae ilia famiu, talasi 'amu taua ta 'are 'urifo fala ta ioli mola 'ala iko 'ali gera lio ba'ela ala, 'amu taua lo fagu.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Sui lakae sae 'uri 'e fala ioli fo gera io 'i aba mauli agu gi, ‘'Amu la tatau ko faasi lau. God kae kwai 'amiu. Ma 'amu kae la 'i laola dunaa 'e 'ago firi, lia God 'e rerei 'alia fala Saetan, failia eniselo ta'a lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sulia lau fiolo, ma iko 'ali 'amu kwatea mola ta fana 'agua. Ma talasi lau siligou, iko 'ali 'amu kwatea mola ta kwai 'agua. ");
INSERT INTO lgl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma talasi lau dao mae faasia falua mamata li, iko 'ali 'amu kwalo lau mola fala 'i laola luma 'amiu gi. Ma talasi lau dadala, iko 'ali amu kwate toro mola fagu. Ma talasi lau matai ma laka io 'i laola raraa li, iko 'ali amu lio mola suli lau.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma gera ka olisi 'uri 'e ala, ‘Aofia, talasi ta 'e 'ami lesi'o, 'o fiolo, 'o ma 'o siligou, 'o ma 'i'o ioli dao, 'o ma ko dadala, 'o ma 'o matai 'o ma 'o io 'i laola raraa, ma iko 'ali 'ami rana 'o mola?’ ");
INSERT INTO lgl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ma laka olisida 'uri 'e, ‘'Are kwalaimoki Lakae ilia famiu, talasi iko 'ali 'amu kwairanai ala ta ioli mola 'ala lia iko 'ali gera lio ba'ela ala, 'amu taua lo agu.’ ");
INSERT INTO lgl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Sui gera ka la lo 'ada fala kwaikwaina fo kae ioio firi, ma ioli rada gi gera ka la lo fala maurina firi.” ");
INSERT INTO lgl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Talasi Jesus 'e faalalau 'alia 'are fo gi ka sui, ka sae 'uri 'e fala wale li galona lia gi, ");
INSERT INTO lgl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Moulu saiai ka sui lo, Fanana ala Daofae Liu na li kae fuli 'i fulee. Ma ala talasi fo, gerakae kwate lau, Wela Wale li, fala malimae lau gi, 'ali gera foto fafi lau ala 'ai rara folo.” ");
INSERT INTO lgl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ala talasi fo lou, fata abu ba'ela gi, failia wale etaeta Jiu gi li, gera logo 'i laola luma ba'ela 'ilito'ola fata abu la ratala Kaeafas. ");
INSERT INTO lgl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma gera ka alatolae, 'ali gera daria ta talasi 'ali gera dau agwa ala Jesus, ma gera ka raunia. ");
INSERT INTO lgl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma gera ka sae kwailiu 'uri 'e, “Ikoso 'ali golu daua ala fe atoa ala fana na li, taufasia ioli gi gera bi kwalaa fae golu.” ");
INSERT INTO lgl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma Jesus failia wale li galona lia gi, daulu la ko fala 'i Betani, daulu ka io 'i laola luma Simon, wale la kuu 'e tautaua 'i lao. ");
INSERT INTO lgl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Talasi Jesus kae fana 'ala, te geli 'e la mae 'i so'ela failia botole 'e kwana rasua, ma 'e fonu 'alia waiwai 'e si'ina fofo 'oka, ma folifolinai ka ba'ela rasua. 'E la mae, ma ka nikia fafia gwaula Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Talasi wale li galona lia gi daulu lesia, daulu ka ogata'a, ma daulu ka sae 'adaulu taladaulu 'uri 'e, “'Uta 'e geli 'e ka fafuta'a waiwai 'oka 'e? ");
INSERT INTO lgl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Waiwai fo, ala golu ka foli 'alia, bata ba'ela golu kae sakea 'alia. Ma golu ka sakea bata fo gi fala rananala ioli siofa gi!” ");
INSERT INTO lgl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma sulia Jesus 'e sai mola 'ala ala taa fo daulu kae sae sulia, ka sae 'uri 'e fadaulu, “'Uta 'e moulu ka sae 'uri'e, ma moulu ka fa 'ekea geli 'e? 'Are 'oka rasua 'e lia 'e taua fagu. ");
INSERT INTO lgl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ioli siofa gi gera io mola 'ada fae 'amiu sulia atoa gi. Ma 'i lau, talasi dodoko mola 'e lakae io fae 'amoulu sulia. ");
INSERT INTO lgl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma talasi geli 'e 'e nikia waiwai 'e ala rabegu, 'e rerei lau lo maasia alominagu ala gigiluna ala fe atoa ala maenagu li. ");
INSERT INTO lgl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma laka ilia famoulu, ala falua gi sui 'i laola molagali gera kae faatalo 'alia Faronona 'Oka gera kae ronoa lou me 'are 'e geli 'e 'e taua fagu, ma gera kae malata tonala.” ");
INSERT INTO lgl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","'I burila 'are fo gi sui, na wale ala akwala wala rua wale li galona Jesus gi, ratala Judas Iskariot ka la 'i so'ela fata abu ba'ela gi. ");
INSERT INTO lgl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma ka soilidi gera 'uri 'e, “Ala laka kwatea Jesus famoulu, taa moulu kae kwatea 'agua?” Ma gera ka idumia olu akwala seleni gi, ma gera ka kwatea fala. ");
INSERT INTO lgl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Fuli ala talasi fo, Judas ka liolio lo 'afia ta talasi 'e totolia fala kwatenala Jesus fadaulu. ");
INSERT INTO lgl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ma ala etala atoa ala fanana 'e gera soia 'alia, “Beret la iko ta Ist ai,” wale li galona gi daulu la mae 'i so'ela Jesus, ma daulu ka soilidi 'uri 'e ala, “'I fe 'o oga meulu ka rerei 'alia Fanana ala Daofae Liu na li famu ai?” ");
INSERT INTO lgl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma Jesus ka sae 'uri 'e fadaulu, “Moulu la fala 'i Jerusalem. Ala talasi moulu li dao 'i so'ela te wale la lau filia, moulu ka sae 'uri 'e fala, ‘Wale faalalau 'ameulu, 'e ilia talasi lia 'e dao garani lo. Lia failia wale li galona lia gi gera kae 'ania Fanana ala Daofae Liu na li 'i luma 'o.’” ");
INSERT INTO lgl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ala talasi fo, wale li galona gi gera la, ma geraka alaa failia wale fo malaa lo lia ba Jesus 'e ilia lo fadaulu, ma daulu ka rerei lo 'alia fanana fo 'i lifi fo. ");
INSERT INTO lgl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ma 'i raurafi, Jesus ka gwauru 'i lififo 'ali ka fana failia akwala wala rua wale li galona lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma talasi daulu kae fana lo, Jesus ka sae 'uri 'e fadaulu, “'Are kwalaimoki lakae ilia famoulu, na wale amoulu kae kwate lau fala malimae lau gi.” ");
INSERT INTO lgl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Talasi wale li galona gi daulu ronoa me 'are fo li, daulu ka kwaimalatai rasua. Ma io ma na teke wale adaulu 'e fuli'ae li soilidia Jesus 'uri 'e, “Aofia, 'uri 'e ma 'o sae suli lau 'e?” Ma daulu sui mola daulu soilidi 'urifo. ");
INSERT INTO lgl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sui Jesus ka sae 'uri 'e, “Te wale amoulu, lia kae saua me berete lia 'i laola teu fae lau, 'i lia lo kae kwate lau fala malimae lau gi. ");
INSERT INTO lgl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'I lau, Wela Wale li, lakae mae malaa lo lia ba Geregerena Abu 'e ilia ka sui lo mae 'i lao. Ma kwaimalatai rasua fala wale 'e kae kwate lau fala malimae lau gi li. 'E 'oka fala wale la ala iko 'ali gera fafutaa mola.” ");
INSERT INTO lgl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ala talasi fo, Judas wale fo kae kwatea Jesus fala malimae lia gi li, ka sae 'uri 'e, “Wale li Faalalau, koe sae suli lau la?” Ma Jesus ka sae 'uri 'e fala, “'I'o 'i talamu 'o talae ilia lo.” ");
INSERT INTO lgl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ma ala talasi daulu kae fana, Jesus ka sakea tofui berete, ma ka batafea God, sui ka liia, ma ka kwatea fala wale li galona lia gi, ma ka sae 'uri 'e, “Moulu sakea, ma moulu ka 'ania, lia lo 'e rabegu.” ");
INSERT INTO lgl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sui ka sakea teu li gou, ma ka batafea God, sui ka kwatea fadaulu, ma ka sae 'uri 'e, “'Amoulu sui, moulu goufia. ");
INSERT INTO lgl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Lia lo 'e 'abugu lia God 'e fanasia 'alia alafuuna fa'alu, sulia 'abugu kae afe fala ioli afula gi, 'ali God ka kwailufa lo 'alia ta'ana gi. ");
INSERT INTO lgl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","'Are kwalaimoki lakae ilia famoulu, ikoso lau goufia lou waen 'e la la ka dao ala fe atoa lakae goufia waen fa'alu fae 'amoulu 'i laola Tatalona Mama lau li.” ");
INSERT INTO lgl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sui daulu ka nulia fe nuu, ma daulu ka la fala fe uo la gera soia 'alia Olif. ");
INSERT INTO lgl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma Jesus ka sae 'uri 'e fadaulu, “Ala fe boni 'e, 'i 'amoulu sui moulu kae tafi faasi lau. Sulia Geregerena Abu 'e sae 'uri 'e, ‘God kae raunia wale 'e lio sulia sipsip gi li, ma sipsip gi sui geraka tagalae.’ ");
INSERT INTO lgl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ka 'urifo wasua 'ala, 'i burila lakae tatae lou fala maurina, lakae eta 'i lao amoulu fala 'i Galili.” ");
INSERT INTO lgl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma Peter ka olisia 'uri 'e, “'I lau 'ato 'ali lau la faasi 'o, wasua wale 'e gi gera ka la 'ada fa'asi 'o!” ");
INSERT INTO lgl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma Jesus ka sae 'uri 'e fala Peter, “Laka ilia famu, 'i lao ala karai kae ani 'i laola fe boni 'i tara'ela, koe tofe 'ali lau 'uri iko 'ali 'o sai agu.” ");
INSERT INTO lgl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma Peter ka olisi 'uri 'e ala, “Wasua laka mae fae 'o, 'e 'ato 'ali lau ilia 'uri lau rari 'o!” Ma wale li galona gi sui, daulu sae lou 'urifo. ");
INSERT INTO lgl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sui Jesus ka la failia wale li galona lia gi ala te lifi gera soia 'alia 'i Getsemani, ma ka sae 'uri 'e fadaulu, “Moulu io 'amoulu 'i lifi'e talasi lakae la 'i lokoo 'ali lau foa.” ");
INSERT INTO lgl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma ka talaia Peter, failia rua wela Sebedi gi failia. Ma ka fuli 'aela lo kwaimalataina ba'ela rasua failia malata boesinala. ");
INSERT INTO lgl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma ka sae 'uri 'e fadaulu, “Manogu 'e fii ka ba'ela rasua, 'e totolia lo rauninagu. Moulu io 'i lifi'e, moulu ka ada, ma moulu ka liolio fae lau.” ");
INSERT INTO lgl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sui 'i lia ka 'idu wawade lou ko faasi daulu, ma ka boururu la la maala darala ka too lo 'i wado, ma ka foa 'uri 'e, “Mama 'e, ala 'e talawarau mola 'ala, 'o ala'alia famalifiina 'e 'ali laa faasi lau. Wasua, iko lou liogu, ma sulia liomu lou 'ala.” ");
INSERT INTO lgl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sui Jesus ka oli 'i so'ela olu wale li galona lia gi, ma ka lesia daulu mo'osu lo, ma ka sae 'uri 'e fala Peter, “Peter wale'e, 'utaa 'e iko 'ali moulu ada fae lau sulia ta teke me talasi wasua? ");
INSERT INTO lgl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Moulu ada, moulu ka liolio 'alia foana taufasia ilitoona ka bi liufi 'amoulu. Sulia moulu oga taunala 'are 'oka gi, wasua ma rabemoulu 'e watoutou rasua.” ");
INSERT INTO lgl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus ka la lou, ma ka foa ala ruala talasi 'uri 'e, “Mama 'e, ala iko 'ali 'e totolia 'ali 'o bolosia famalifiina 'e faasi lau, 'oka mola 'ala, laka rono lo 'agua sulia liomu.” ");
INSERT INTO lgl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma talasi 'e oli mae 'i soela wale li galona lia gi li, ka lesia daulu mo'osu lou, sulia maa daulu 'e momosula rasua lo. ");
INSERT INTO lgl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma Jesus ka la lou faasidaulu, ma ka foa lou ala olula talasi, ka ilia lou me alaana ba gi mola 'ali. ");
INSERT INTO lgl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sui ka la lou 'i soela olu wale li galona lia gi, ma ka sae 'uri 'e fadaulu, “Moulu mo'osu 'ua 'e? Ma moulu ka mamalo 'ua 'e? Lio ga, gera kae kwate lau lo, Wela Wale li, 'i lofola limala ioli ta'a gi. Talasi ba 'e dao lo mae! ");
INSERT INTO lgl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Moulu tatae, golu ka la lo. Moulu lesia wale ba kae kwate lau fala malimae lau gi li, 'e dao lo mae.” ");
INSERT INTO lgl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ma talasi Jesus kae alaa 'ua ai, Judas, na wale ala akwala wala rua wale li galona ba lia gi, ka dao lo mae. Te logona ba'ela 'e la mae failia faasia fata abu ba'ela gi, ma wale etaeta gi. Ma gera ka sakea mae 'au li ofona gi, failia subi gi. ");
INSERT INTO lgl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas 'e kwatea sui lo maetoto fada 'uri 'e, “Wale lakae loto 'i babalila, 'i lia lo wale la moulu oga.” ");
INSERT INTO lgl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ma nainali lia ka la rada lo 'i so'ela Jesus ma ka sae 'uri 'e, “Wale Faalalau, aroarona ka io fae 'o.” Sui ka loto lo 'i babalila. ");
INSERT INTO lgl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma Jesus ka sae 'uri 'e fala, “Wale 'oka lau, 'o taua lo me 'are 'e nainali.” Sui gera ka 'idu garani mae ala, ma gera ka daua Jesus, ma gera ka dau nasi lo fafia. ");
INSERT INTO lgl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma na wale ala wale li galona Jesus gi ka lafua 'au li ofona lia, ma ka kwaia wale li lifurono 'ilito'ola fata abu, ma ka tofu tabia lo fili anina aolo lia. ");
INSERT INTO lgl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma Jesus ka sae 'uri 'e fala, “'O alua 'au li ofona 'o 'i fulila, sulia ioli gera kwalaa 'alia 'au li ofona gi li, gera kae mae lou 'alia 'au li ofona gi. ");
INSERT INTO lgl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Lau oga ko saiai, ala laka sugaa Mama lau, 'i lia ka keria mae eniselo afula gi liufia akwala wala rua logonae wale li mae afula gi! ");
INSERT INTO lgl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma ala laka ilia eniselo gi ka rana lau 'urilali, iko 'ali lau fakwalaimokia 'are ba Geregerena Abu 'e ilia sulia Christ kae famalifii 'alia gi.” ");
INSERT INTO lgl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sui Jesus ka sae 'uri 'e fala ioli gi, “'Uri'e ma, moulu fia 'i lau ta wale belibeli 'e? Lia 'e Moulu ka dao mae failia 'au gi failia subi gi fala daunagu? Tekwa lo mae, lau faalalau 'amiu 'i laola Luma Abu God, wasua ma iko 'ali 'amu dau lau mola. ");
INSERT INTO lgl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","'Are 'e gi sui ka fuli 'uri'e 'ali fakwalaimokia geregerena profet gi ala Geregerena Abu.” Sui wale li galona lia gi sui daulu ka faeburi lo 'alia, ma daulu ka tafi lo 'adaulu. ");
INSERT INTO lgl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ma wale fo gera daua Jesus gi, gera talaia fala 'i laola luma Kaeafas, 'ilito'ola fata abu. Ma wale falalau ala taki gi li, failia wale etaeta gi lou, gera logo 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma Peter 'e ali buri tatau ko, ma ka dao lou 'i laola labata ala luma 'ilito'ola fata abu, ma ka ruu ko 'i laola labata, ma ka io failia wale lio folo gi, 'uri 'ali ka lesia taa gera kae taua ala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma fata abu ba'ela gi, failia logonae wale lokomalata gi sui, gera tau fala darinala tali alaana kotokoto sulia Jesus 'e totolia 'ali gera raunia fafia. ");
INSERT INTO lgl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wasua ioli afula sae kotokoto gi gera la lou mae, iko 'ali gera daria mola ta 'are. Sui 'i buri, na rua ioli kotokoto daro tatae mae, daro ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Wale 'e 'e sae 'uri 'e, ‘Lau saiala osinala Luma Abu God, ma laka raunae fa'alu lou ai 'i laola olu fe atoa gi.’” ");
INSERT INTO lgl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sui 'ilito'ola fata abu ka tatae, ka sae 'uri 'e fala Jesus, “'Uri'e ma, ikoso olisia mola ta 'are, ala 'are ta'a 'e daro ilia amu gi?” ");
INSERT INTO lgl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wasua ma, Jesus 'e lobo mola 'ala. Ma 'ilito'ola fata abu ka sae lou 'uri 'e, “Lau suga 'o 'ali 'o sulufolo 'alia ratala God 'e mauri, ma ko ilia fameulu 'i'o lo 'e Christ, Wela God, 'o ma iko?” ");
INSERT INTO lgl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus ka sae 'uri 'e fala, “Lia la 'o ilia lo. 'Are kwalaimoki lakae ilia famiu, fuli ala talasi 'e ka la 'ala, 'amu kae leesi lau, Wela Wale li, lakae gwauru 'i aba aolo ala God 'e nanata ka tasa, ma lakae la mae 'i fofola dasa gi 'i nali.” ");
INSERT INTO lgl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mola 'ilito'ola fata abu fo, ka gagasia to'omi tekwa lia 'i talala ka fatailia ogata'anala, ma ka sae 'uri 'e, “Iko 'ali golu oga lou ta ioli li sae fakwalaimoki! Golu ronoa sui lo lia fafuradani lia lo failia God. ");
INSERT INTO lgl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","'Amu malata 'utaa?” Ma gera ka olisi 'uri 'e ala, “'E totolia kae mae lo.” ");
INSERT INTO lgl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sui gera ka nisufia maala, ma gera ka kwaia. Ma nali ioli geraka fidalia, gera ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Christ, ala 'i'o lo na profet, 'o ilia mae, ite 'e fidali 'o 'uri 'e?” ");
INSERT INTO lgl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma Peter ka io 'i laola labata, ma te geli ulao li galona ka la mae 'i so'ela ka sae 'uri 'e, “'I'o 'o io lou failia Jesus, te wale 'e faasia 'i Galili.” ");
INSERT INTO lgl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sui Peter ka tofe 'i maada 'uri 'e, “Iko 'ali lau saiala 'are koe sae sulia.” ");
INSERT INTO lgl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sui, Peter 'e la ka gwauru garania 'ala mae 'olofolo, ma te geli ulao li galona lou ka lesia, ma ka sae 'uri 'e fala ioli gera io 'i lifi fo gi, “Ma wale 'e ioio lou failia Jesus, te wale fo faasia 'i Nasareti.” ");
INSERT INTO lgl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma Peter ka tofe lou, ma ka talifolo 'uri 'e, “Iko 'ali lau saiala wale la.” ");
INSERT INTO lgl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ma iko 'ali tekwa mola 'i burila, ioli gera ura 'i lififo gi, gera la 'i so'ela Peter, ma gera ka sae 'uri 'e fala, “'I'o lou na wale adaulu kwalaimoki lo, sulia rononala saenamu 'e talae fatae 'o.” ");
INSERT INTO lgl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Talasi fo 'i lia ka talifolo lou 'uri 'e, “Ala laka koto, God kae kwai lau. Iko 'ali lau saiala wale la.” Ma 'urifo mola, karai ka ani lo. ");
INSERT INTO lgl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma Peter ka malata tonala alaana ba Jesus 'e ilia, “'I lao ala karai ka ani 'i laola fe boni 'e 'i tara'ela, koe ilia olu talasi gi iko 'ali 'o sai agu.” Talasi Peter 'e malata tonala me 'are fo li, ka latafa, ma ka uluulu ala ani na 'alia kwaimalataina ba'ela rasua. ");
INSERT INTO lgl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","'Ofaedani ta'a 'ua, fata abu ba'ela gi sui failia wale etaeta gi, gera ka lokomalata lo fala rauninala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sui geraka firia, ma gera ka talaia lo 'i so'ela Paelat, wale 'ilitoa faasia 'i Rom. ");
INSERT INTO lgl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ma Judas, wale ba 'e kwatea Jesus fala malimae lia gi li, ala talasi 'e saiai gera loko kwaikwaina lo ala Jesus fala maenala, ka malata oli, ma ka oli failia olu akwala seleni ba gi fala fata abu ba'ela gi failia wale etaeta gi, ma ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Lau tau ta'a lo, sulia lau kwatea wale rada fala rauninala.” Sui gera ka olisi 'uri 'e ala, “Iko lou 'aberona 'ameulu la. Sulia mali la gulagula 'o lo 'ala la.” ");
INSERT INTO lgl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma Judas ka 'ui 'alia seleni fo gi 'i laola Luma Abu God, ma ka la lo 'ala. 'E la 'i maluma, ma ka li lioa lia lo 'ala 'i talala. ");
INSERT INTO lgl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma fata abu ba'ela gi, gera ka sakea seleni fo gi, ma gera ka sae 'uri 'e, “Iko 'ali rada ala taki golu 'ali golu ka alua lo seleni 'e gi failia bata ala Luma Abu God gi, sulia seleni 'e bata ala rau ioli na li.” ");
INSERT INTO lgl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma gera ka alaa ka sui, gera ka alafafia 'ali gera ka folia 'alia te tofui wado, wado te wale kae rauraunae teu. Ma gera ka olisia wado fo 'alia lifi fala alunala ioli mae gi ai, ioli mamata faasia Jiu gi li. ");
INSERT INTO lgl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Dunala 'e folia wado fo 'alia bata fo 'e sakea fala rauninala ioli li, gera ka soia wado fo 'alia, “Wado ala 'Abu” la la ka dao 'i tara'ela. ");
INSERT INTO lgl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'Urifo, gera ka fakwalaimokia alaana ba profet Jeremaea 'e sae 'uri 'e, “Gera sakea lo olu akwala seleni ba gi, bata ba ioli 'i Israel gi gera folia 'alia wale li, ");
INSERT INTO lgl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ma gera ka kwatea fala folinala wado wale 'e raunailia teu gi li, malaa lo God 'e ilia fagu.” ");
INSERT INTO lgl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ma Jesus ka ura 'i maala Paelat, wale 'ilitoa faasia 'i Rom. Ma Paelat ka soilidi 'uri 'e ala, “'I'o walelitalona Jiu gi li 'e?” Jesus ka olisi 'uri 'e ala, “Lia la 'o ilia lo.” ");
INSERT INTO lgl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Talasi fata abu ba'ela gi, failia wale etaeta gi, gera suafafia Jesus, iko 'ali olisida 'alia ta alaana. ");
INSERT INTO lgl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sui Paelat ka sae 'uri 'e fala, “Iko 'ali 'o ronoa mola 'are ta'a afula 'e gera sua fafi 'o 'alida gi?” ");
INSERT INTO lgl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma Jesus iko 'ali olisidaulu mola 'alia ta alaana. Lia fo Paelat ka kwele rasua 'alia. ");
INSERT INTO lgl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ala Fanana ala Daofae Liu na li, wale 'ilitoa faasia 'i Rom, kae 'idufae lugasia ta teke ioli ala Jiu gi lia gera oga faasia 'i laola raraa. ");
INSERT INTO lgl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma ala talasi fo, te wale 'e io lou 'i laola raraa ratala Barabas, ioli sui gera saiala. ");
INSERT INTO lgl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lia fo, talasi ioli gi gera logo mae, Paelat ka soilidida 'uri 'e, “Ite 'amu oga laka lugasia famiu, Barabas, 'o ma Jesus lia 'e gera soia 'alia Christ?” ");
INSERT INTO lgl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","'E sae 'urifo, sulia 'e saiai lia fo wale etaeta ala Jiu gi li, gera kwatea Jesus fala sulia gera kwaifii mola fala. ");
INSERT INTO lgl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma talasi Paelat 'e gwauru ala lifi li loko malata na li, wateu lia ka kwatea me alaana fala 'uri 'e, “'O ala taunala ta 'are ala wale rada la. Sulia lau mo'osu bole, ma laka ogabolo rasua sulia ala fe boni ba sui.” ");
INSERT INTO lgl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma fata abu ba'ela gi, failia wale etaeta gi, gera sae aninala ioli gi, 'ali gera ka sugaa Paelat fala lugasinala Barabas, ma ka alua Jesus fala maena. ");
INSERT INTO lgl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma Paelat ka soilidia lou logona fo 'uri 'e, “Ite adaroa 'amu oga 'ali lau lugasia?” Ma gera ka olisi 'uri 'e ala, “Barabas.” ");
INSERT INTO lgl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Paelat ka sae 'uri 'e, “Ma taa 'e lakae taua ala Jesus, 'e gera soia 'alia Christ?” 'I gera sui gera ka sae 'uri 'e, “'O foto fafia ala 'ai rara folo.” ");
INSERT INTO lgl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma Paelat ka sae lou 'uri 'e, “Osiala ta ta'a 'e 'i lia 'e taua?” Sui gera ka akwa ba'ela 'uri 'e, “Fotoia ala 'ai rara folo.” ");
INSERT INTO lgl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ma talasi Paelat 'e lesia 'e 'ato 'ali 'e taua lo ta 'are, ma kwalaana kae garani fuli'ae, 'i lia ka sakea me kwai, ma ka saua lo limala 'i maada sui, ka sae 'uri 'e, “Iko 'ali lau 'ado fae 'amiu ala maenala wale 'e. Gulagula 'amiu lo 'e.” ");
INSERT INTO lgl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ma logona fo sui gera ka olisia 'uri 'e, “Maenala ka teo fafi 'i 'amami, ma fafia wela 'amami gi lou.” ");
INSERT INTO lgl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Paelat ka lugasia ko Barabas fada, ma ka kwatea waleli mae afula lia gi gera ka rabusia Jesus. Sui ka kwatea fada 'ali geraka fotoia ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma waleli mae afula Paelat gi, gera talaia Jesus 'i laola luma Paelat, ma wale li ofo afula lifi fo gi sui, gera ka logo mae galia Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma gera ka kalasua lo toro lia, ma gera ka faaruufia 'alia toro melamelaa boraa. ");
INSERT INTO lgl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sui gera ka sakea te 'eregwau ala kwalo karakaraa li, ma gera ka alua 'i gwaula, ma gera ka kwatea te rarae 'ai 'ali 'e dau ai 'alia fili lima aolo lia, malaa 'i lia na walelitalona. Ma gera ka boururu fala, ma gera ka dorakwala sulia, gera ka sae 'uri 'e, “'O mauri tekwa 'amua, walelitalona 'e Jiu gi li.” ");
INSERT INTO lgl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma gera ka nisufia, ma gera ka sakea te rarae 'ai ba, ma gera ka kwaia gwaula 'alia. ");
INSERT INTO lgl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Talasi gera maafoo fala ka sui, gera ka kalasua lou toro ba, ma gera ka faaruufia lou 'alia toro lia gi, sui gera ka talaia ko fala fotoinala ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ma talasi gera la lo ko, gera ka lesia te wale faasia 'i Saeren, lia ratala Simon. Ma waleli mae afula gi, gera ka taua 'ali 'e sakea 'ai rara folo fo Jesus. ");
INSERT INTO lgl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sui gera li dao ala lifi gera soia 'alia 'i Golgota. (Fadanala me saena fo Golgota 'e 'uri 'e “Lifi ala gwae ioli li”.) ");
INSERT INTO lgl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","'I lifi fo, gera kwatea waen gera dolaa 'alia 'ai 'afaa fala Jesus. Ma Jesus ka mami tonai, ma iko 'ali goufia mola. ");
INSERT INTO lgl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sui gera ka foto fafia ala 'ai rara folo, ma gera ka none 'alia 'are malaa daisi 'ali geraka tolinia toro lia gi 'i matanada. ");
INSERT INTO lgl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sui gera ka gwauru 'i fua, ma geraka lio 'ada sulia. ");
INSERT INTO lgl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma 'i gwaula 'ai rara folo fo gera alua te geregerena la 'e sae 'uri 'e, “Te wale 'e Jesus, Walelitalona Jiu gi li.” ");
INSERT INTO lgl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sui, gera ka fotoia lou rua wale belibeli gi ala 'ai rara folo gi failia, na wale ala gula aolo ala, ma na wale ala gula mauli. ");
INSERT INTO lgl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma ioli gera liu gi, gera ka 'asua gwauda, ma gera ka fai'isi ko fala Jesus, ma gera ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“'O ilia koe osia Luma Abu God, ma ko raunae fa'alu lou ai sulia olu fe atoa gi mola. Ala 'i'o Wela God, 'o faamauri 'o ga 'i talamu, ma ko sifo mae faasia 'ai rara folo la.” ");
INSERT INTO lgl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma fata abu ba'ela gi gera ka dorakwala lou 'alia 'urifo, failia wale falalau ala taki gi li, failia wale etaeta gi, gera sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“'I lia ba faamauria ioli mamata gi, ma iko 'ali faamauria mola 'i lia talala. Ala 'i lia wale talo gia ioli Jiu gi li kwalaimoki, ka sifo mae faasia 'ai rara folo, 'ali golu fakwalaimokia ");
INSERT INTO lgl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","'E fitoo ala God, ma ka sae 'uri 'e, ‘'I lau 'a Wela God.’ Golu liolio ga 'ali golu lesia God kae faamauria 'o ma iko.” ");
INSERT INTO lgl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma rua wale ta'a gera fotoida failia gi, daro sae maafoo lou 'urifo fala. ");
INSERT INTO lgl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Mae rodo 'e kufi fafia falua gi sui 'i lifi fo fuli ala matoula atoa, la la ka li dao ala olu me tofui matolaa gi raurafi. ");
INSERT INTO lgl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma raurafi, Jesus ka akwa ba'ela 'uri 'e, “'Ilae, 'Ilae, lema sabaktani.” Fadanai 'e 'uri 'e, “God lau, God lau, 'utaa 'e ko fae buri 'ali lau?” ");
INSERT INTO lgl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma nali ioli gera io garania, gera ronoa, ma gera ka sae 'uri 'e, “'E soia Elaeja.” ");
INSERT INTO lgl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma na wale adaulu ka lalao ka sakea mae te lumulumu asi, ma ka fafonua 'alia waen 'afaa, ma ka fanaasia ala mae 'ai, ma ka kwatea fala 'ali goufia. ");
INSERT INTO lgl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma nali ioli lou gera sae 'uri 'e, “Mano ga, golu lesia ala Elaeja kae dao mae fala faamurinala 'o ma iko.” ");
INSERT INTO lgl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sui, Jesus ka akwa ba'ela lou, mola ka mae lo. ");
INSERT INTO lgl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma to'omi ba'ela 'e bolosia lifi abu 'i laola Luma Abu God li ka gaga 'alia rua abae 'are, ka fuli mae 'i gwaula la la ka dao 'i 'aela. Ma lululu ka 'asu, ma fau gi ka foga, ");
INSERT INTO lgl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ma nali gigiluna gwau gera tafa, ma ioli afula ala ioli God gera mae lo gi, gera mauri lou. ");
INSERT INTO lgl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma gera ka latafa faasia gigiluna gera gi. Ma burila Jesus ka tatae oli lou, gera ka ruu laola falua abu 'i Jerusalem. Ma ioli afula gi gera ka lesida. ");
INSERT INTO lgl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma wale etaeta ala waleli mae afula fo gera raunia Jesus gi li, failia waleli mae lia gi, talasi gera lesia lululu, ma 'are mamata gi sui lou 'e fuli, gera ka mau rasua ma gera ka sae 'uri 'e, “'E kwalaimoki rasua lo, 'i lia Wela God.” ");
INSERT INTO lgl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma nali geli afula gera dona buria mae Jesus fuli 'i Galili ma gera ka kwairanai ala, gera io lou 'i lififo, ma gera ka liolio tatau ko 'ada. ");
INSERT INTO lgl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na ai adaulu Mary faasia 'i Magdala, ma Mary teite 'a James failia Josef, ma wateu Sebedi, ma nali geli lou. ");
INSERT INTO lgl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ala talasi 'e raurafi lo ma ka garania boni, te wale too'are 'e la mae. Lia te wale faasia falua 'i Arimetea, ma ratala Josef. Ma 'i lia te waleli galona Jesus lou. ");
INSERT INTO lgl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ma ka la 'i so'ela Paelat, ka sugaa rabela Jesus. Ma Paelat ka ilia gera ka kwatea fala. ");
INSERT INTO lgl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma Josef ka sakea lo rabela Jesus, ma ka buta 'alia 'aba to'omi kaka'a fa'alu. ");
INSERT INTO lgl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sui ka alua 'i laola bao gwau fa'alu lia, gera 'elia 'i laola fau ba'ela li. Sui ka bolosia lo maala bao fo 'alia abae fau ba'ela, sui ka la lo. ");
INSERT INTO lgl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary faasia Magdala, ma na Mary lou, daro ioio 'i maala gigiluna fo. ");
INSERT INTO lgl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ma ala fe atoa 'i burila Sabat, atoa ala mamalona li, fata abu ba'ela gi, failia Farasi gi, gera logo fala lokomalata na failia Paelat. ");
INSERT INTO lgl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma gera ka sae 'uri 'e fala, “Wale ba'ela, meulu malata tonala talasi wale kotokoto 'e 'e mauri 'ua ai, 'e sae 'uri 'e, ‘Lakae mauri lou ala olula fe atoa!’ ");
INSERT INTO lgl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ma ko faronoa wale 'o gi geraka la, ma geraka lio folosia gigiluna fo la la ka dao ala olula fe atoa. Iko 'ali 'oka wale li galona lia gi gera ka sakea 'ada rabela, ma gera ka faagwaa, ma gera ka kotofia ioli gi, gera ka ilia 'uri Jesus 'e mauri lou. Ma 'o saiai ala gera koto 'urifo, kae ta'a ka liufia lo kotona ba 'e etae kotofia mae 'alia ioli li.” ");
INSERT INTO lgl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma Paelat ka sae 'uri 'e fadaulu, “Ala 'e 'urila, 'i 'amoulu moulu ka filia tali wale ala waleli mae afula 'e lau gi, 'ali gera lio folo, ma gera ka lio folo 'oka galia bao la.” ");
INSERT INTO lgl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ma ala talasi fata abu ba'ela gi, failia Farasi gi gera ronoa me 'are fo li, gera ka rerei lo, ma gera ka la lo fala bao fo. Ma talasi gera dao ala bao fo li, gera ka alua lo maetoto ala bao fo, 'ali ala ta ioli ka 'idua wasua abae fau fo 'i maala bao fo li, gera kae saiai. Ala talasi fo lou, gera ka alua lo wale lio folo gi 'i lifi fo. ");
INSERT INTO lgl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","'I burila Sabat, fe atoa ala mamalona li, talasi 'e gogolafae ioli 'ua ala Sade 'ofaedani, Mary faasia 'i Magdala, ma na Mary lou, daro ka la fala bao ba 'ali daro lesia. ");
INSERT INTO lgl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma lululu ba'ela 'e 'asu, ma te eniselo God ka sifo mae faasia 'i nali, ma ka 'idua lo abae fau ba faasia maala bao fo, ma ka gwauru 'i fofola. ");
INSERT INTO lgl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Leesinala malaa lo kwana ma to'omi lia gi ka kaka'asi roroa rasua. ");
INSERT INTO lgl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma ala talasi fo wale lio folo gi gera lesia, gera ka mau rasua, ma gera ka toli, gera ka lebelebe, ma gera ka malaa lo 'ada wale mae gi. ");
INSERT INTO lgl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma eniselo fo ka sae 'uri 'e fadaroa, “Mora ala mau na. Lau saiai mora lio 'afia Jesus ba gera raunia ala 'ai rara folo li. ");
INSERT INTO lgl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'E iko 'ali 'e io lo 'i lifi'e. 'E mauri lo malaa ba 'e ilia lo famoulu. Mora la mae 'i lifi'e, ma mora ka lesia lifi ba 'e teo teo ai. ");
INSERT INTO lgl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mora la nainali, ma mora ka faarono 'uri 'e ala wale li galona lia gi, ‘Jesus 'e mauri lo, ma ka la 'i lao amoulu fala 'i Galili, ma moulu kae lesia lo 'i lififo.’ Ma mora ka malata tonala 'are 'e lau ilida famoroa gi.” ");
INSERT INTO lgl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","'Urifo mola, daro ka la nainali lo faasia bao fo 'alia mauna. Ma wasua 'ala, daro babalafe rasua. Ma daro ka lalao 'ali daro faronoa wale li galona lia gi. ");
INSERT INTO lgl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma ala talasi fo, Jesus ka dao tonadaroa ka sae 'uri'e, “Aroarona ka io fae 'amoroa.” Ma daro ka la mae 'i so'ela, ma daro ka boururu fala, ma daro ka dau ko 'i 'aela, ma daro ka faa aofia. ");
INSERT INTO lgl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma Jesus ka sae 'uri 'e fadaroa, “Ikoso mora mau. Mora la, ma mora ka faronoa walefae lau gi, 'ali gera la fala 'i Galili. Ma gera kae leesi lau lo 'i lififo.” ");
INSERT INTO lgl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ala talasi rua geli fo gi daro oli ko sulia tala li, nali wale ala wale lio folo fo gi, gera la lo faasia bao gwau fo Jesus, ma gera ka oli lo fala 'i Jerusalem. Talasi gera li dao ala mae falua ba'ela 'i lifi fo li, gera ka alaa lo sulia 'are gera lesida gi sui fala fata abu ba'ela gi. ");
INSERT INTO lgl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma talasi fata abu ba'ela gi, ma nali wale etaeta lou ala Jiu gi, gera alaa ruru ka sui lo, gera ka kwatea bata ba'ela fala wale li lio folo fo gi. ");
INSERT INTO lgl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Talasi gera kwatea bata fo fala wale lio folo gi li, gera ka sae 'uri 'e, “Moulu ka koto 'uri 'e fala ioli gi sui, ‘Talasi meulu mo'osu 'i laola boni li, wale li galona Jesus gi gera la mae, ma gera ka belia rabela.’” ");
INSERT INTO lgl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma wale etaeta fo gi, gera sae lou 'uri 'e, “Ala Paelat 'e ronoa me 'are 'e, ikoso 'ali moulu malata 'abero, sulia 'i 'ameulu lo meulu kae farada fala, 'ali ikoso ke ogata'a famoulu.” ");
INSERT INTO lgl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ma talasi wale lio folo fo gi gera sakea bata fo ka sui lo, gera la, ma gera ka tau lo 'are fo fata abu ba'ela gi, failia wale etaeta Jiu gi li gera ilia fada gi. Ma Jiu gi gera faatalo lo 'alia alaana fo ala kotona li, la la ka dao 'i tara'ela. ");
INSERT INTO lgl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Akwala wala teke waleli galona lia gi gera la lo fala 'i Galili, fala te fe uo Jesus 'e ilia fadaulu 'ali daulu ka la fai. ");
INSERT INTO lgl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ma talasi daulu lesia Jesus, daulu ka faa aofia, 'urifo wasua 'ala nali wale adaulu daulu malata ruarua 'ua. ");
INSERT INTO lgl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ma Jesus ka dao mae 'i soedaulu, ka sae 'uri 'e, “God 'e kwate teifau lo ala nanata na gi sui 'i nali ma 'i laola molagali fagu. ");
INSERT INTO lgl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Lia fo, 'amu ka la, ma 'amu ka faalalau ioli gi sui ala falua gi sui, 'ali gera waleli galona lou 'agua. Ma 'amu ka fasiuabuda 'alia ratala Mama, ma Wela, failia Aloe 'are Abu. ");
INSERT INTO lgl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma 'amu ka famalatada 'ali gera ka ronosulia 'are lau faalalau 'amoulu 'alida gi. Ma lakae io fae 'amiu la la ka dao ala suinala molagali.” ");
INSERT INTO lgl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Fuli nala mae Faronona 'Oka 'e sulia Jesus Christ Wela God 'e 'uri 'e: ");
INSERT INTO lgl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Mala lia ba profet Aesea 'e gerea me 'are God 'e ilia fala Christ, “Lakae kwatea te wale kae sake saena lau gi 'i lao amu, 'ali 'e rerei ala ioli maasi 'o. ");
INSERT INTO lgl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te wale kae rii fala ioli gi 'i laola lifi kwasi. Ma kae sae 'uri 'e, ‘Aofia kae dao lo mae! Moulu farada talaa fala!’” ");
INSERT INTO lgl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Wale li faronona la fo John wale fasuiabu. Daonala John mae 'i laola lifi kwasi fo iko 'ali totolia ta ioli 'ali io ai fo 'e 'urifo. John 'e rufia te toro gera galofia 'alia ifula kamel li, ma ka firia abalola 'alia sunasunala buluka. Ma ka 'ania siisii failia ninidua kwasi. John ka fasiuabua ioli gi, ka alaa ma ka sae 'uri 'e fada, “'Amu bulusi faasia ta'ana 'amiu gi, ma 'amu ka sisiu abu 'ali God ka kwailufa amiu.” Ioli afula faasia 'i Judea, failia 'i Jerusalem gi, gera la mae fala rononala saenala John. Gera ka ili tafanailia ta'ana gera gi, ma John ka fasiuabuda 'i laola kwai 'i Jodan. ");
INSERT INTO lgl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma John ka sae 'uri 'e fala ioli gi, “Te wale kae la mae 'i burigu, 'i lia 'e 'ilitoa ka liufi lau, ma iko 'ali lau totolia 'ali lau 'adaoro, ma laka lafua 'ae botu lia gi. ");
INSERT INTO lgl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","'I lau lakae fasiuabu 'amiu mola 'alia kwai, ma 'i lia kae fasiu abu 'amiu 'alia Alo ala God.” ");
INSERT INTO lgl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","'E iko 'ali 'e tekwa mola 'i burila 'are fo gi, Jesus ka dao lo mae faasia falua 'i Nasareti 'i Galili. Jesus ka dao 'i so'ela John 'ali 'e sisiu abu. Ma John ka fawawaloa 'i laola kwai 'i Jodan. ");
INSERT INTO lgl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Talasi Jesus 'e tatae mae faasia kwai li, ka lesia lofola raloo 'e tafa, ma Alo ala God ka sifo mae fafia mala na fe bola. ");
INSERT INTO lgl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma linela God ka talulu mae faasia 'i nali ka sae 'uri 'e, “'I'o mola wela moutae lau ma laka babalafe rasua 'ali'o.” ");
INSERT INTO lgl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Talasi fo mola, Alo ala God ka talaia Jesus fala 'i laola lifi kwasi. ");
INSERT INTO lgl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma Jesus ka io 'i lififo sulia fai akwala fe atoa, ma Saetan ka mailitonala. 'Are kwasi gi gera io lou 'i lififo, ma eniselo gi gera ka la mae, ma geraka kwairanai ala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","'I burila gera alua lo John 'i laola raraa, Jesus ka la 'i Galili ma ka fabasu 'alia Faronona 'Oka 'e la mae faasia God. ");
INSERT INTO lgl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ka sae 'uri 'e, “Talasi God kae 'ilitoa fafia ioli lia gi li 'e garani lo. 'Amu bulusi faasia ta'ana 'amiu gi, ma 'amu ka fakwalaimokia Faronona 'Oka 'e.” ");
INSERT INTO lgl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Talasi Jesus 'e liu sulia 'osi 'i Galili, ka lesia Simon failia walefae lia Andrew. Daroa rua waleli kwaiasina gi. Daro kae kwaiasi 'adaroa 'alia fuo daroa 'i laola 'osi fo. ");
INSERT INTO lgl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma Jesus ka sae 'uri 'e fadaroa, “Mora la mae faelau, 'amoroa rua waleli kwaiasina fala ia li, wasua ma lakae famalata 'amoroa 'alia sake ioli na mae 'i soegu.” ");
INSERT INTO lgl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ala me talasi fo mola lo, daro ka tafisia lo fuo daroa gi, ma daro ka la lo failia. ");
INSERT INTO lgl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma Jesus ka 'idu wawade lou ko, ka lesia James failia John, rua wela Sebedi gi. Daro io 'adaroa 'i laola te baru, ma daro kae raumia fuo daroa. ");
INSERT INTO lgl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma talasi Jesus 'e leesi daroa mola, ka soi daroa lo, ma daro ka tafisia lo mama daroa Sebedi 'i laola baru failia wale gera galo 'adaulu gi, ma daro ka la lo failia Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesus failia wale li galona lia gi, daulu li dao ala falua 'i Kapaneam. Ma ala Sabat, atoa ala mamalona li, Jesus ka ru 'i laola luma fala foana li, ma ka falalaua ioli afula gi. ");
INSERT INTO lgl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Talasi gera ronoa, gera ka kwele rasua 'alia falalaunala, sulia gera sai 'oka 'ala lia Jesus 'e falalau 'alia nanatana failia kwalaimokina God. 'E iko 'ali 'e falalau malaa wale falalau ala taki Moses gi li, sulia gera falalau mola 'alia nanatana gera 'i talada gi. ");
INSERT INTO lgl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ala talasi fo lou, te wale aloe 'are ta'a 'e io ala, kae akwa ma ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus! 'I'o wale 'i Nasareti! Ta 'e koe taua ameulu? Mala koe la mae fala fafuta'anameulu tae 'e! Lau sai mola 'agua amu, 'I'o laa Wale Abu God!” ");
INSERT INTO lgl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma Jesus ka balufia 'uri'e ala te aloe 'are ta'a fo, “'O lobo mola lo, ma ko la tafa mae fasia wale la!” ");
INSERT INTO lgl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma te aloe 'are ta'a fo, ka akwa ba'ela, ma ka falebelebea wale fo, ma ka la tafa lo faasia. ");
INSERT INTO lgl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma ioli gera logo 'i lififo gi li, gera 'afero rasua, ma gera ka soilidi kwailiu 'ada 'uri'e “Ma 'are 'utaa 'e awale? Mala ta faalalauna fa'alu tae ne? Wale 'e 'e sae 'alia nanatana. Lia ka saefala aloe 'are ta'a gi, ma gera ka ronosulia saenala.” ");
INSERT INTO lgl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iko 'ali dole mola alaana sulia Jesus ka talo lo 'i laola provins 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Talasi Jesus failia James, ma John, daulu la ko faasia luma fala fo'ana li, daulu ka la fala luma Simon mama Andrew. ");
INSERT INTO lgl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Talasi Jesus 'e dao 'i laola luma fo li, gera ka faronoa 'alia funo geli Simon lia 'e matai 'alia ragana, ma ka teo mola 'ala 'i tafe. ");
INSERT INTO lgl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma Jesus ka la 'i so'ela geli fo, ma ka dau 'i limala, ka fatataea. Ma ragana fo ka sui lo faasia, ma geli fo ka tatae ma ka ranoli daulu. ");
INSERT INTO lgl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ala fe raurafi fo, ala suunala da'afi, talasi atoa fala mamalona ala Jiu gi 'e sui lo, wale gi ka sakea mae ioli matai gi, failia ioli aloe 'are ta'a gi 'e io ada gi 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma ioli ala falua fo li gera ka logo sui mae 'i mala luma fo. ");
INSERT INTO lgl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma Jesus ka guraa ioli afula gera matai 'alia mataina afula totoo gi li. Ma ka balia lou aloe 'are ta'a afula gi. Ma iko 'ali 'e ala'alia aloe 'are ta'a fo gi 'ali geraka sae, sulia gera sai sui mola ala lia 'e 'i lia Wela God. ");
INSERT INTO lgl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","'Ofaedani, talasi 'e gogolafa 'ua, Jesus 'e ada ka tatae, ma ka latafa faasia luma fo. Ma ka lai foa 'ala ala lifi la 'e aroaro. ");
INSERT INTO lgl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma Simon failia wale kwaima lia gi daulu ka lio 'afia. ");
INSERT INTO lgl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Talasi daulu li dao tonala, daulu ka sae 'uri 'e fala, “Ioli sui kae lio 'afi'o.” ");
INSERT INTO lgl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma Jesus ka olisi 'uri'e adaulu, “Lau saiai, wasua 'ala golu la lou ala ta mae falua garani 'ali lau faalalauda lou, sulia me galona 'e lo lau la mae fali taua.” ");
INSERT INTO lgl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","'Urifo mola, Jesus ka la 'i laola mae falua gi sui 'i laola provins 'i Galili, ma ka fadaa saenala God 'i laola luma fala foana li gi li, ma ka balia aloe 'are ta'a gi faasia ioli gi. ");
INSERT INTO lgl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","'Urifo lou, te wale kuua 'e la mae 'i so'ela Jesus, ma ka boururu 'i 'aela, ma ka aniulu ka sae 'uri 'e, “Ala ko aala, 'o gura lau.” ");
INSERT INTO lgl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma Jesus ka malatai rasua ala, ka tadaa ko limala, ma ka dau tonala wale fo, ka sae 'uri 'e, “Lau aala. Rabemu 'e mafo lo!” ");
INSERT INTO lgl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma nainali mola kuu fo ka sigi lo faasia, ma rabela ka mafo sui lo. ");
INSERT INTO lgl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus ka sae nasi 'uri'e fala wale fo, ");
INSERT INTO lgl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ko ala farononala ta ioli 'alia 'are 'e lau taua famu. Wasua ma ko la, ko fatailia rabemu fala fata abu God, ma ko aala 'alia fata abu God ka iro 'oka amu. Sui ko kwatea foasinana 'o mala lia ba Moses 'e ilia fala kwatenai, 'alia ioli gi sui gera fakwalaimokia lia 'e rabemu 'e mafo lo.” Ma Jesus ka ilia fala wale fo ka la lo. ");
INSERT INTO lgl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Wasua ma, wale fo 'e la, ma ka alaa kwailiu 'alia 'i laola falua gi sui sulia me 'are fo Jesus 'e taua ala rabela ka 'oka lo. 'I osiala alaanala fo wale fo li, ioli afula gi gera ka logo 'afuia Jesus fala rononala. 'Urifo ma ka 'ato lou fala Jesus 'ali 'e liu tafanae 'i laola falua gera gi, ma Jesus ka io too mola 'ala ala lifi aroaro gi. 'E 'urifo wasua 'ala, ioli 'i laola falua gi sui gera la mola mae 'ada 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","'I burila barae fe atoa 'e sui, Jesus ka oli lou mae fala 'i Kapaneam. Ma gera ka faarono kwailiu 'alia lia Jesus 'e io mola 'ala 'i laola luma ba kae 'idufae dao dao lo ai 'i laola falua fo li. ");
INSERT INTO lgl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'Urifo ioli afula gi gera ka logo lo mae 'i so'ela Jesus, lala luma fo gera iofia ka fonu rasua lo, ma iko lo ta lifi 'ali ore 'i laola luma fo. Ma 'i maluma wasua, ioli afula gi gera logo lou ai. Ma Jesus ka fadaa saenala God fada. ");
INSERT INTO lgl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Talasi fo fai wale gi gera la mae, gera ka sakea mae te wale rabela 'e mae. ");
INSERT INTO lgl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma sulia logona fo 'e ba'ela rasua, 'e 'ato fadaulu fala sakenala ko 'i so'ela Jesus. 'Urifo mola, daulu ka rae 'i fofola luma failia te wale fo. Ma daulu ka tafalia te maekwakwana ba'ela 'i gwaofala luma totolala lifi Jesus 'e io ai, ma daulu ka fasifoa te wale fo 'i fofola tafe lia 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma talasi Jesus 'e lesia maka saiala me fitoona daulu li, ka sae 'uri 'e fala te wale fo rabela 'e mae, “Ulufa'alu fo, lau kwailufa lo 'alia ta'ana 'o gi.” ");
INSERT INTO lgl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma talasi fo, nali wale falalau ala taki gi gera io lou 'i lifi fo, ma gera ka malata 'ada 'uri 'e 'i talada, ");
INSERT INTO lgl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ale wale! 'E iko 'ali 'e totolia 'alia ka sae 'urifo. Ioli iko 'ali saiala kwailufana 'alia ta'ana li. Talifilia God mola 'e saiala kwailufana 'alia ta'ana li. Lia 'e fafuradani lia lou failia God.” ");
INSERT INTO lgl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ma Jesus ka saiala malatadaulu, ma ka sae 'uri 'e fadaulu, “Moulu ala malatana lou 'urilaa.” Ma Jesus 'e sai lou ala lia gera fakwalaimokia talifilia God mola 'e saiala gura ioli na. Mola ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","“Ala laka sae 'uri 'e fala wale fo rabela 'e mae ‘Ta'ana 'o gi lau kwailufa lo 'alida,’ ikoso 'ali molu lesia mola tame 'are 'ali fuli. Ma ala laka sae 'uri 'e, ‘'O tatae, ko sakea tafe 'o, ma ko liu lo,’ 'urifolo moulu ka bi lesia lia 'e nanatana 'e io agu fala gurana. ");
INSERT INTO lgl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Talasi lakae guraa wale 'eli, lau fatailia famoulu lia 'e 'i lau, Wela Wale li, lau too ala nanatana fala kwailufa na 'alia ta'anali.” 'Urifo Jesus ka sae 'uri 'e fala te wale fo rabela 'e mae, ");
INSERT INTO lgl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Laka ilia famu, 'o tatae, ko sakea tafe la 'o, ma ko la lo 'i luma amu.” ");
INSERT INTO lgl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma wale fo ka tatae, ka sakea lo me tafe fo lia, ma ka la lo. 'Urifo, ioli sui gera lesia, ma geraka 'afero rasua. Talasi fo, gera ka batafea God, ma gera ka sae 'uri 'e, “Iko 'ali gi lelesia tali 'are 'uri 'e 'i lao!” ");
INSERT INTO lgl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na talasi lou, Jesus 'e oli lou fala 'i taufofola 'osi 'i Galili. Ma logona ba'ela gera kae la mae 'i so'ela, ma ka faalalau gera. ");
INSERT INTO lgl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Talasi 'e liu ko sulia 'osi fo li, ka lesia Lifae, wela Alfeas. Lifae 'e gwauru 'ala ala lifi fala sakenala bata ala takisi li, sulia 'e galo 'i lififo. Ma Jesus ka sae 'uri 'e fala, “'O la mae faelau.” Ma Lifae ka tatae, ka la lo 'ala failia. ");
INSERT INTO lgl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","'I burila liafo Jesus 'e sakea Lifae 'ali waleli galona 'ala, ka lai fana lo 'i luma ala Lifae. Ma ioli gera kae sakesake bata ala takisi gi li gera io lou 'i lififo. Ma nali ioli ta'a lou, gera fana failia Jesus failia waleli galona lia gi. Ioli afula ta'a 'urifo gi, gera la failia Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nali Farasi wale gera falalau 'alia taki Moses gi li, gera lesia Jesus kae fana failia ioli ta'a gi, ma ioli gera kae sakesake bata ala takisi li. Mola Farasi gi gera ka sae 'uri 'e fala waleli galona Jesus gi, “'E iko 'ali 'e totolia 'ali 'e fana failia ioli 'urifo gi.” ");
INSERT INTO lgl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma talasi Jesus 'e ronoa me 'are fo li, ka sae 'uri 'e fadaulu, “Moulu saiai, iko lou ioli 'akwaa gi gera boboo 'afia ta ioli li gurana. Ioli matai gi mola gera oga ioli kwaigurai 'ali 'e gurada. 'E iko 'ali lau la mae fala ioli ionada 'e rada lo 'i maala God gi, lau la mae 'agua fala ioli ta'a gi.” ");
INSERT INTO lgl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ala na talasi, nali waleli galona John wale fasiuabu, ma waleli galona Farasi gi, gera abu fana fala foana. Ma nali wale gera la mae, gera ka sae 'uri 'e fala Jesus, “Waleli galona John gi, ma waleli galona Farasi gi li, gera abu fana. 'E iko 'ali 'oka lia 'e waleli galona 'o gi iko 'ali gera abu fana.” ");
INSERT INTO lgl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma Jesus ka olisi 'uri 'e adaulu, “'E iko 'ali rada fala ioli gera io ala fanana ala araaraina li, 'ali gera abu fana. Dunala lia 'e, arai fa'alu 'e io 'ua mola 'ala failia ioli gi li gera ka babalafe. Iko dadala 'ali gera abu fana, sulia gera io ala fanana. ");
INSERT INTO lgl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wasua ma talasi kae dao mae 'i dani gera kae sakea arai fa'alu fasida. Talasi fo bui, gera ka bi abu fana, sulia gera kwaimalatai. Lia 'e iko 'ali totolia waleli galona lau gi 'ali gera abu fana talasi lau io 'ua mola 'agua failida.” ");
INSERT INTO lgl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jesus ka sae lou 'uri 'e, “Iko ta ioli 'ali saiala taibolosianala ta toro 'e gaga sui lo 'alia keme nisinisi toro fa'alu. Suli ala ka tau 'urila, me nisinisi toro fa'alu fo kae gagasia toro 'ualo fo, dunala toro fa'alu 'e lugu 'i burila sauanai, ma ka taua te maekwakwana ba'ela. ");
INSERT INTO lgl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma moulu ka sai lou ai, 'e iko 'ali 'e totolia 'ali ta ioli 'ali alua waen fa'alu 'i laola wai 'ualo gera galofia 'alia sunasunala nanigot li, dunala 'e 'ato 'alia wai 'ualo fo 'ali 'e paku. Suli ala kae tau 'urila, talasi waen fo kae tora mola mae ai, ka fogaa lo wai 'ualo fo, ma waen fo ka anikilo, ma wai gaga fo ka ta'a lo. 'Are la fo ioli ka alua lo waen fa'alu 'i laola wai fa'alu 'ali 'e saiai ka paku failia.” ");
INSERT INTO lgl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ala na Sabat, atoa ala mamalona li, Jesus failia waleli galona lia gi, daulu la sulia te tala 'e liu 'i laola raku ala witi li, 'are fala galofia nala berete li. Ma talasi daulu kae liu ko 'adaulu, waleli galona lia gi ka 'oia funui witi gi, ma daulu ka 'ania. ");
INSERT INTO lgl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma Farasi gi gera ka lesia, ma gera ka sae 'uri 'e fala Jesus, “Lesia! Me 'are 'e moulu taua 'e 'oia taki Moses, sulia molu 'oia witi ala Sabat, atoa ala mamalona li.” ");
INSERT INTO lgl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ma Jesus ka olisi 'uri'e adaulu, “Lau saiai moulu idumia 'i laola Buka Abu sulia me 'are ba David 'e taua, talasi ba 'Abiata 'e fata abu 'ilitoa. Talasi ba, David failia wale lia gi gera fiolo rasua, sulia 'e iko lo ta fana 'adaulu. Ma David ka ru 'i laola luma God, ma fata abu 'ilitoa ka kwatea berete fo gera fa abua fala God fala David. Ma David ka 'ania lo berete fo, ma ka kwatea lou fala wale lia gi, ma gera ka 'ania. Wasua ma taki 'e ala'alia talifilia fata abu God gi mola gera saiala 'aninai. Ma iko 'ali golu lesia mola 'i laola Buka Abu 'ali God 'e ogata'a fala David.” ");
INSERT INTO lgl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sui mola Jesus ka sae 'uri 'e fala Farasi gi, “God 'e raunailia atoa ala mamalona li fala rananala ioli. Iko 'ali 'e raunailia atoa ala mamalona li 'ali 'e gulugulu fafia ioli. ");
INSERT INTO lgl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Dunala 'i lau, Wela Wale li, lau too ala nanatana fala ilianala 'are fala ioli gi fala taua nali, ma gera sai mola 'ada ala taua nali ala atoa ala mamalona li.” ");
INSERT INTO lgl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na talasi lou, Jesus 'e la lou 'i laola luma fala foana li, ma te wale limala 'e mae 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma nali Farasi gera io lou 'i lififo ala me tofuitalasi fo, gera ka lio sulia Jesus tau ma 'e guraa wale fo ala Sabati, atoa ala mamalona li. Ala ka guraa wale fo, daulu ka sae 'i maala Jesus 'alia 'oianala taki God ala Sabat ala guranala ioli, gura na gera malataia 'e malaa lou galona. ");
INSERT INTO lgl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma Jesus ka sae 'uri 'e fala wale fo limala 'e mae, “Tatae mae ko ura 'i maala falua 'e sui.” ");
INSERT INTO lgl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mola, Jesus ka soilidia 'uri'e ala Farasi gi, “Taa taki gia 'e ala'alia fala taunai ala atoa ala mamalona li? 'E ala'alia taunala 'are 'oka gi, 'o ma taunala 'are ta'a gi? 'E ala'alia faamurinala ioli, 'o ma rauninala ioli?” Ma iko 'ali daulu ilia molalo ta me 'are. ");
INSERT INTO lgl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus 'e lio gali daulu, ma ka lio ogata'a, sulia 'e iko 'ali daulu malataia lo wale matai fo, ma ka malatai daulu lou sulia malatadaulu 'e nasi rasua. Sui mola, Jesus ka sae 'uri 'e fala te wale fo, “Tadaa mae limamu.” Ma wale fo ka tadaa mola ko limala, limala ka 'oka lo. ");
INSERT INTO lgl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","'Urifo mola Farasi gi ka latafa, ma gera ka ogolu fala alaana ruru failia nali wale ala wale Herod gi, ma daulu ka malata fala rauninala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jesus failia waleli galona lia gi, daulu ka tafisia alae ioli fo, ma daulu ka la fala 'osi 'i Galili. Ioli afula ka la lou 'i buri daulu. Gera la mae faasia provins 'i Galili, 'i Judea ma 'i Idumea. Ma nali ioli lou faasia 'ilito'ola falua 'i Jerusalem, ma faasia gwae falua ala talanala da'afi li ala kwai 'i Jodan. Ma nali ioli gera ka la mae faasia falua galia 'i Taea failia 'i Saedon gi. Te logona ba'ela fo, gera la mae 'i so'ela Jesus, sulia gera ronoa 'are ba'ela gi 'e tauda. ");
INSERT INTO lgl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sulia logona fo 'e ba'ela rasua, Jesus ka ilia fala waleli galona lia gi 'ali daulu rerei agau 'alia ta baru, tauma ioli bi bebesia. ");
INSERT INTO lgl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jesus 'e guraa ioli afula gi ka sui lo, 'are la fo ioli matai afula gi gera ka suunaili gera ko, 'ali gerake dau tonala Jesus 'ali gera 'akwaa. ");
INSERT INTO lgl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma talasi ioli aloe 'are ta'a 'e io ada gi gera lesia Jesus, gera ka boururu 'i maala, ma gera ka rii 'uri 'e, “'I'o lo Wela kwalaimoki God!” ");
INSERT INTO lgl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wasua ma Jesus 'e sae fala aloe 'are ta'a fo gi ka luia 'ali ikoso gera faronoa ta ioli 'ali 'i lia. ");
INSERT INTO lgl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","'Urifo mola Jesus ka rae fala 'i gwaula te fe uo, ma ka soia ioli gi fala galona failia. Mola gera ka la mae 'i so'ela, ");
INSERT INTO lgl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ma ka filia akwala wala rua wale, ma ka fafuratada 'alia wale li lifurono gi. Ma ka sae 'uri 'e fadaulu, “Lau fili 'amoulu 'ali moulu io garani lau, ma laka keri 'amoulu fala faalalauna sulia saenala God fala ioli sui. ");
INSERT INTO lgl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma moulu ka too ala nanatana fala balinala aloe 'are ta'a gi.” ");
INSERT INTO lgl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ratala akwala wala rua wale fo 'e filida gi gera 'uri 'e: Simon, lia Jesus 'e fafurata lou 'alia Peter, ");
INSERT INTO lgl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma James failia John rua wela Sebedi gi, lia Jesus 'e fafurata daroa 'alia “Boneges,” rata fo 'e kwatea fadaroa sulia 'i daroa rua wale tenae ogaogata'a nainali mala kurukuru li. ");
INSERT INTO lgl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ma Andrew, Filip, Batolomiu, Matthew, Tomas, ma James, wela Alfeas, ma Tadeas, ma Simon, na wale ala alae Jiu fo gera oga rasua ala balinala ioli 'i Rom gi faasia Israel. ");
INSERT INTO lgl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ma Judas Iskariot wale kae kwatea Jesus fala malimae lia gi li. ");
INSERT INTO lgl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","'Urifo, Jesus ka oli lou 'i laola luma fo kae 'idufae dao dao lo ai. Ma ioli afula gi, gera ka logo lo mae. 'Urifo Jesus failia waleli galona lia gi iko 'ali daulu too lo ala ta talasi fala taunala ta 'are 'o ma fana na wasua. ");
INSERT INTO lgl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma talasi iolifuta lia gi gera rono ala me 'are fo li, gera ka la 'i so'ela fala olifaenala fala 'i falua, sulia gera ronoa liafo ioli gi gera sae 'uri 'e, “'E kwekwe'ela rasua lo.” ");
INSERT INTO lgl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma nali wale falalau ala taki Moses gi gera la mae faasia 'i Jerusalem, ma gera ka sae 'uri 'e, “Jesus 'e balia aloe 'are ta'a gi 'alia nanatana Saetan, wale baela ala aloe 'are ta'a gi li sui.” ");
INSERT INTO lgl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Lia fo, Jesus ka soia mae ioli gi ka sae 'uri 'e fada 'alia tarifulaana, “Saetan 'e 'ato ka balia aloe 'are ta'a gi faasia ioli lia gi. ");
INSERT INTO lgl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ala alae ioli 'i laola ta falua ba'ela daulu kae kwalaa mola 'i matanadaulu taladaulu, 'urila falua ba'ela la kae osi, ma ioli kae takalo. ");
INSERT INTO lgl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma ala wale failia wateu lia ma wela daroa gi, daulu kae kwalaa mola 'i matanadaulu 'e 'ato 'ali daulu ke io ruru. ");
INSERT INTO lgl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma tatalona Saetan 'e 'urifo lou. Ala Saetan kae kwalaa failia ioli gera liu sulia gi, 'urila gera kae takalo kwailiu mola, ma nanatanala fafida ka dao lo ala suinai.” ");
INSERT INTO lgl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","'I burila Jesus ka alaa lou sulia na tarifulaana, ka sae 'uri 'e, “ala ta ioli mola 'ala kae oga 'ali balia ta aloe 'are ta'a, ioli la ka nanata ka liufia Saetan. 'E malaa lou, na wale 'e oga kae ruu 'i laola luma te wale nanata li, 'alia 'e sakea 'are wale nanata fo gi li. Wale la ka nanata ka liufia lou te wale nanata fo, 'ali 'e talawarau 'ali 'e firia wale nanata fo sui ka bi sakea 'are lia gi. ");
INSERT INTO lgl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“'Are kwalaimoki la kae ilia famoulu, tau ta'ana gi, ma sae fafuta'ana ioli 'e taua ala God gi, God 'e kwailufa mola 'ala 'alida. ");
INSERT INTO lgl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wasua ma, ala ta ioli kae 'itoli sae fafuta'a mola 'ala Alo ala God, God 'ato 'ali kwailufa ala, sulia ta'ana fo kae io firi.” ");
INSERT INTO lgl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesus 'e sae 'urifo sulia wale falalau ala taki gi li, gera ilia 'i lia 'e too ala aloe 'are ta'a. ");
INSERT INTO lgl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","'I burila 'are fo gi, teite Jesus failia walefae lia gi, daulu ka dao. Daulu ura mola 'i maala luma, ma daulu ka kwate saena ko fala Jesus, ma daulu ka soilidi 'afia. ");
INSERT INTO lgl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ioli afula rasua gera io galia Jesus, ma gera ka farono 'uri'e ala “Teite 'o, failia walefae 'o gi, daulu ura 'i maluma, ma daulu ka oga 'ali daulu leesi 'o.” ");
INSERT INTO lgl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma Jesus ka olisi 'uri 'e adaulu, “Laka ilia famoulu ite lo teite kwalaimoki lau, ma walefae lau gi!” ");
INSERT INTO lgl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Mola Jesus ka lio fala ioli afula fo gera io galia gi, ma ka sae 'uri 'e, “Lia 'e, ioli gera mala teite lau, failia walefae lau gi li 'e lo! ");
INSERT INTO lgl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sulia ta ioli mola 'ala 'e taua 'are God 'e oga gi, lia lo walefae lau, failia gelifae lau, ma teite lau.” ");
INSERT INTO lgl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ala na talasi lou, Jesus 'e faalalau 'i toufofola 'osi 'i Galili. Ma logona ba'ela rasua gera ka logo 'afuia, ma ka rae 'i laola te baru ka gwauru 'i laola, ma ka 'idu wawade lou 'i laola 'osi. Ma logona fo, gera ka ura ko 'i rabela 'osi. ");
INSERT INTO lgl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma Jesus ka faalalau 'alia 'are afula gi fada 'alia tarifulaana gi ma ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Moulu fafurono ga! Te wale 'e la ka taasi 'alia fufuala witi 'i laola raku lia. ");
INSERT INTO lgl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma talasi 'e taasi 'alia fufuala witi fo gi li, nali fufuae witi gera toli sulia talaliliu, ma malu gi gera ka lofo mae, ma gera 'anida ka sui. ");
INSERT INTO lgl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma nali fufuae witi gera ka toli ala lifi faua, lifi la iko 'ali 'e wadoa rasua. Ma gera ka bulao nainali, sulia liafo wado iko 'ali afula. ");
INSERT INTO lgl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma ala talasi da'afi kae tatae mae, ka daafia lo witi fo 'e bulao gi, ma gera ka kuku lo, sulia kalokaloda iko 'ali ruu lalo. ");
INSERT INTO lgl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma nali fufuae witi gera toli 'i safitala kwalo karakaraa gi, ma kwalo fo ka baela fafia witi gi, ma witi fo gi iko 'ali gera funu mola. ");
INSERT INTO lgl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma nali fufuae witi lou, gera toli 'i laola wado 'oka, ma talasi gera bulao mae, gera ka funu 'alia fuae 'are afula gi. Ma nali witi gera ka funu 'alia olu akwala fuae 'are, ma nali witi gera ka funu 'alia olo akwala fuae 'are, ma nali witi lou gera ka funu 'alia teke talanae fuae 'are.” ");
INSERT INTO lgl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma Jesus ka faasui 'uri'e ala saenala, “Ioli 'e oga 'ali 'e sai 'oka ala 'are 'e gi li ka fafurono 'oka.” ");
INSERT INTO lgl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Talasi Jesus 'e io 'ala talifilia, akwala wala rua waleli galona ba lia gi, failia nali ioli gera ronoa saenala, gera ka la mae 'i so'ela. Ma gera ka soilidia 'ali 'e famadakwa fadanala tarifulaana fo gi. ");
INSERT INTO lgl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma ka olisi 'uri 'e adaulu, “Talasi 'e sui gi, God iko 'ali faamadakwa kae 'ilitoa 'utaa fafia ioli lia gi. Wasua ma talasi 'e, madakwana lia 'e fatae lo famoulu. Ioli iko 'ali gera oga 'ali gera ioli li galona 'agua gi, lakae sae 'alia tarifulaana gi fada, ma ikoso lau fadaa ");
INSERT INTO lgl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","fada, 'ali 'e fakwalaimokia lia ba Gegerena Abu 'e sae 'uri 'e, ‘Gera kae lio, ma gera kae lio, wasua ma iko 'ali gera lesia ta 'e God 'e taua fada. Ma gera kae fafurono, ma geraka fafurono, wasua iko 'ali gera malinailia saenala God. Sulia ala gera lio raea, ma gera ka malinailia, 'urila gera kae bulusi mae fala God, ma 'i lia kae kwailufa 'alia ta'ana gera gi.’” ");
INSERT INTO lgl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","'Urifo Jesus ka soilidi 'uri 'e ala ioli li galona lia gi, “'Uri 'e iko 'ali 'amu sai mola ala tarifulaana fo? Ala iko 'ali 'amu saiala tarifulaana fo, moulu kae bi sai mola 'utaa ala tarifulaana gi? ");
INSERT INTO lgl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Te wale ba 'e taasi fufuae witi, 'e taasi 'alia saenala God ba. ");
INSERT INTO lgl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma ioli gera ronoa saenala God gi, gera malaa fufuae witi fo 'e toli sulia talaliliu li. Ma talasi gera ronoa, Saetan 'e la mae, ma ka lafua lou 'ala saenala God fasida. ");
INSERT INTO lgl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma nali ioli lou gera malaa fufuae witi gera toli ala lifi faua li. Talasi gera ronoa saenala God, gera sakea ma gera ka babalafe rasua. ");
INSERT INTO lgl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wasua ma, saenala God iko 'ali laliu mola 'i laola maurinada. Lia fo fitoona gera gi ka mauri mola sulia keme talasi wawade. Ma talasi gera li dao tonala 'atonagili, failia famalifiina gi li dunala faronona 'oka 'e, gera ka taasi mola 'alia saenala God. ");
INSERT INTO lgl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma nali ioli gera mala fufuae witi gera toli 'i safitala kwalo karakaraa gi li. Gera ronoa saenala God, ");
INSERT INTO lgl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wasua gera malata 'abero 'ada sulia 'are kwailiu 'i laola maurinada, ma gera ka malata ba'ela sulia bata. Ma 'are fo gi, gera malaa kwalo karakaraa 'e ba'ela fafia saenala God 'i laola maurinada. 'E iko 'ali gera olisia mola maurinada, ka malaa witi fo iko 'ali funu mola 'alia ta fuae 'are. ");
INSERT INTO lgl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma nali ioli lou gera mala fufuae witi fo gera toli 'i laola wado 'oka li. Gera ronoa saenala God, ma gera ka ronosulia, ma gera fatailia io aolona, ka malaa witi fo 'e funu 'alia fuae 'are gi li. Nali witi olu akwala fuae 'are, ma nali witi olo akwala fuae 'are, ma nali ai teke talanae fuae 'are.” ");
INSERT INTO lgl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'Urifo mola Jesus ka soilidi 'uri 'e ala logona fo, “'E uta? 'Uri'e ma ala ta ioli ka sakea mae ta fe uulu, kae alua mola 'i malula dako 'o ma ta tafe? 'E iko mola! Kae alua ala lifi fala alu uulu na li, 'i nali. ");
INSERT INTO lgl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tali 'are ioli gi iko 'ali gera sai sai ali 'i lao, gera kae sai lo ali. ");
INSERT INTO lgl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ala ta ioli ka oga 'ali sai 'oka ala 'are 'e gi, 'i lia ka fafurono 'oka.” ");
INSERT INTO lgl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma Jesus ka sae lou 'uri 'e fadaulu, “'Amu malata 'oka sulia 'are 'e 'amu ronoda gi. God kae kwate ba'ela ala liotoo famiu, ala 'amu ka ronosulia faalalauna lau gi li. ");
INSERT INTO lgl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ite wasua 'ala 'e too ala ta madakwana wawade sulia tatalona God, God kae kwate ba'ela 'ala. Wasua ma ioli fo iko 'ali ronosulia faalalauna 'e gi li, ta madakwana wawade wasua 'ala 'e too ai sulia tatalona God, God kae olifailia faasia.” ");
INSERT INTO lgl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus ka sae lou 'uri 'e fada, “Tatalona God 'e malaa wale 'e fasia te fufuae 'are 'i laola raku lia li. ");
INSERT INTO lgl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","'E ada, ka liu kwailiu 'ala ala atoa gi, ma ka mo'osu 'ala ala boni gi. 'Urifo wasua 'ala, talasi fo fufuae 'are gi gera bulao lo, ma ka tatae lo, iko lou ta me 'aberona lia fo. Sulia wale fo iko 'ali sai ala me 'are 'e taua fufuae 'are ka bulao. ");
INSERT INTO lgl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Wado 'i talala lo 'e faamauria fufuae 'are fo gi gera ka ba'ela, ma gera ka funu 'alia fuae 'are gi. 'Ilitoe 'ai lo 'e etae ba'ela mae, sui tagae 'are gi, 'i buri fufuae 'are gi ka bi la tafa mae. ");
INSERT INTO lgl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma talasi fufuae 'are fo gi gera maua, wale fo ka fuli'aela fisunala tagae 'are gi, sulia 'e dao lo ala talasi fala fisu 'are na li.” ");
INSERT INTO lgl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus 'e sae lou 'uri 'e, “Lakae sae lou ko sulia na fe 'u'ulu fali fafuradania tatalona God fafia ioli lia gi li. ");
INSERT INTO lgl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","'E 'uri 'e: Te wale 'e sakea fufuala 'ai la gera soia 'alia mastad, 'e titike ka liufia fufuala 'ai gi sui, ma ka fasia 'i laola wado. ");
INSERT INTO lgl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","'I burila 'e fasia sui, fufuae 'are ba ka tatae, ma ka alua lo 'ai. 'Ai fo 'e ba'ela ka liufia lo 'ai afula gi. Ma ka too ala rarae 'ai ba'ela gi, ma malu gi gera ka lofo mae, ma gera ka raunailia tatafe gera gi ai.” ");
INSERT INTO lgl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesus 'e sae 'urifo fala ioli gi 'alia tarifulaana fo gi, ma ka sae sulia 'are 'e totolia geraka sai ali gi. ");
INSERT INTO lgl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma ka sae fada 'alia tarifulaana gi. Wasua ma, talasi 'e io 'ala talifilia failia waleli galona lia gi li, ka bi faamadakwa 'are gi sui fadaulu. ");
INSERT INTO lgl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","'E raurafi lo ala fe atoa fo, Jesus ka sae 'uri 'e fala waleli galona lia gi, “Golu tofolo ga fala gulae 'osi lobaa.” ");
INSERT INTO lgl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ma daulu ka tafisia lo logona fo, ma daulu ka la lo failia Jesus 'i laola baru ba 'e gwauru 'i laola. Ma nali baru lou 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma oru ba'ela ka tatae mae, ma lafolafo ka mabita lo mae 'i laola baru fo, ma ka garani wawalo lo. ");
INSERT INTO lgl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma Jesus 'e mo'osu 'ala 'i burila baru, ma ka alu gwau ala bogwau lia. Ma waleli galona lia gi ka fa adaa, ma daulu ka sae 'uri 'e, “Aofia golu kae garani mae lo! Iko 'ali 'o malata 'abero molaa 'e?” ");
INSERT INTO lgl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma Jesus ka tatae, ma ka balufia oru fo ka sae 'uri 'e, “'O aroaro lo!” Ma ka sae lou 'uri 'e fala lafolafo fo gi, “Moulu io too lo!” 'Urifo mola, ooru ba ka aroaro lo, ma 'osi ka folafola lo. ");
INSERT INTO lgl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma ka sae 'uri 'e fala waleli galona lia gi, “'Uta 'e moulu ka mau? Lau lesia fitoona amoulu agu iko 'ali ba'ela mola.” ");
INSERT INTO lgl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma daulu ka mau rasua lo, ma daulu ka soilidi kwailiu 'adaulu 'uri 'e, “Wale 'utaa 'e ooru ma lafolafo wasua gera rono lou sulia!” ");
INSERT INTO lgl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesus failia waleli galona lia gi, daulu tofolo folosia 'osi 'i Galili, ma daulu ka li dao ala gulae 'osi fo ala provins 'i Gerasa. ");
INSERT INTO lgl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma talasi Jesus 'e sifo faasia baru li, te wale aloe 'are ta'a 'e io ala ka la mae faasia bao fala gigilunali ma ka la mae 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wale fo ionala lo 'i laola bao 'urifo gi, ma iko ta ioli 'ali totolia firinala 'alia ta seni. ");
INSERT INTO lgl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sulia talasi afula gi, gera firi fafia limala failia 'aela 'alia seni gi, sui ka mousia mola seni fo gi, failia ai 'i 'aela gi. Ma iko ta ioli 'ali nanata totolia daunala. ");
INSERT INTO lgl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma boni failia dani, 'e io 'i safitala bao ala gigilunali gi li ma ka rae 'i fofola uo gi ma ka akwa, ma ka talae kwaria 'ala rabela 'alia fau ladi gi. ");
INSERT INTO lgl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Talasi 'e io tatau 'ua mae ai, ka lesia lo mae Jesus, ma ka lalao mae, ka boururu 'i maala. ");
INSERT INTO lgl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jesus ka sae 'uri 'e fala, “Aloe 'are ta'a fo, 'o latafa mae faasia wale 'e.” Ma 'i lia ka akwa ba'ela 'uri 'e, “Jesus! 'I'o, Wela God 'e nanata rasua. Ma ta 'e 'o oga koe taua agu? Lau ani ulu ko famu 'alia ratala God, ikoso kwatea ta kwaikwaina fagu!” ");
INSERT INTO lgl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sui Jesus ka soilidi 'uri 'e ala, “Ite ratamu?” Ma 'i lia ka olisi 'uri 'e ala Jesus, “Ratagu Ramo Afula, sulia meulu afula rasua.” ");
INSERT INTO lgl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma ka ani ulu fala Jesus faasia bali na daulu faasia gwae falua fo. ");
INSERT INTO lgl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma bo afula rasua gera fana mola 'ada lou 'i babalila fe uo fo. ");
INSERT INTO lgl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma aloe 'are ta'a fo gi, gera ka ani ulu 'uri 'e fala Jesus, “'O kwate 'ameulu fala 'i laola bo lobaa gi, 'ali meulu ru 'ameulu 'i laola bo fo gi” ");
INSERT INTO lgl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma Jesus ka ala'alida, ma aloe 'are ta'a fo gi gera ka latafa faasia wale fo, ma gera ka lai ru 'i laola bo fo gi. Ma bo fo gi 'e totolia ta rua to'oli bo fo. Ma gera ka tafi ala fou kolaa 'ato ma gera ka toli 'i laola 'osi fo, ma gera ka gou geraka mae sui lo. ");
INSERT INTO lgl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma wale gera lio sulia bo fo gi li, gera ka tafi, ma gera ka faarono 'alia me 'are fo 'e fuli ala bo fo gi li 'i laola falua fo, ma falua wawade 'afuia gi lou. Ma ioli afula gi gera ka la fala lesinala me 'are fo 'e fuli. ");
INSERT INTO lgl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Talasi gera dao 'i so'ela Jesus, gera ka lesia wale ba aloe 'are ta'a afula gi gera io ala, 'e gwauru lo 'ala 'i lififo, ma ka toro lo, ma ka malata rada lo. Ma ioli gi gera ka mau, gera ka 'afero rasua. ");
INSERT INTO lgl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma ioli fo gera lesia me 'are fo 'e fuli 'urifo li, gera ka alaa fala ioli gi sulia wale fo aloe 'are ta'a gi gera ioio ala, ma gera ka alaa lou sulia bo fo gi. ");
INSERT INTO lgl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma 'i burila, alae ioli fo daulu ka sugaa Jesus 'ali la faasia gwae falua daulu. ");
INSERT INTO lgl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma talasi Jesus 'e rae lo 'i laola baru li, wale ba aloe 'are ta'a gi gera io ala 'i lao, ka soilidia Jesus 'ali 'e la failia. ");
INSERT INTO lgl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Wasua ma Jesus iko 'ali ala'alia, ma ka sae 'uri 'e fala, “'O oli 'i falua 'i so'ela ioli 'o gi, ma ko farono gera 'alia 'are 'oka God 'e taua famu gi sui, failia kwaiamasinala famu.” ");
INSERT INTO lgl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma wale fo ka la lo, ma ka faronoa ioli ala tofui lifi 'i Dekapolis 'alia 'are Jesus 'e tauda fala gi sui. Ma ioli gi sui gera ka 'afero rasua. ");
INSERT INTO lgl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus 'e tofolo lou ko fala na gulae 'osi. Ma talasi 'e li dao ioli afula gi gera ka logo 'afuia. ");
INSERT INTO lgl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma te wale etaeta 'i laola Luma fala fo'ana 'i laola falua fo li, ratala Jaeras, ka la mae. Ma talasi 'e lesia Jesus, ka boururu 'i maala 'aela, ");
INSERT INTO lgl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma ka ani ulu 'uri'e fala, “Ke welageli lau 'e teoli maena lo. 'O la mae, 'ali 'o alua limamu fafia, 'ali gura ma ka mauri.” ");
INSERT INTO lgl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma Jesus ka la lo failia. Ma logona ba'ela fo geraka la lo 'i burila, ma gera ka kwaibebesi lo. ");
INSERT INTO lgl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma te geli 'abu 'e tafalia sulia akwala wala rua fe nali ka sui lo li, 'e io lou 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ma ke geli ka rabefii rasua lo. Ma ka fafulua lo bata afula lia gi fala ioli kwaigurai afula gi, wasua 'ala ionala iko 'ali 'oka mola. 'E bi ta'a ka rasua mola lo. ");
INSERT INTO lgl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma talasi 'e ronoa ala saena sulia Jesus, ka suusuu mae 'i burila Jesus 'i safitala logona fo, ma ka dau tonala to'omi tekwa Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sulia 'e malata 'uri 'e, “Te 'ali lau dau tonala mola suisuinala to'omi Jesus, lau 'oka lo.” ");
INSERT INTO lgl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma talasi 'e dau tonala mola to'omi Jesus li, nainali mola 'abu fo 'e tafa ala ka lana lo, ma ka saiala rabela 'e 'akwaa lo faasia me mataina fo. ");
INSERT INTO lgl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ala me talasi fo mola 'ala, Jesus 'e saiala nanatana lia 'e guraa te ioli. Ma Jesus ka bulusi 'i safitala logona fo, ka soilidi 'uri 'e, “Ite 'e dau tonala ko to'omi lau?” ");
INSERT INTO lgl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma waleli galona lia gi, gera ka olisi 'uri'e ala, “'O lesia mola 'amua ioli gera afula rasua ma gera ka bebesi 'o lo. 'Uta ko soilidi 'afia teke ioli 'e dau tonamu?” ");
INSERT INTO lgl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wasua ma Jesus ka lio kwailiu 'ali 'e lesia ioli 'e taua me 'are fo li. ");
INSERT INTO lgl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma geli fo 'e saiala 'are 'e fuli fala, ma ka liu lebelebe mae 'alia mauna, ma ka boururu 'i maala 'aela Jesus. Ma ka faronoa 'alia 'are afula kwalaimoki 'e tauda gi. ");
INSERT INTO lgl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma Jesus ka sae 'uri 'e fala, “Geli 'e God 'e gura 'o lo sulia 'o fakwalaimoki lau. 'O la lo 'amua, ma ikoso malata booboo, 'o 'akwaa lo faasia me mataina 'o.” ");
INSERT INTO lgl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma talasi Jesus kae alaa mola 'ala 'ua, nali ioli gera ka dao mae faasia luma Jaeras, ma gera ka sae 'uri 'e fala Jaeras, “Ke welageli ba 'o 'e mae lo. 'O ala faa 'aberosinala lou waleli faalalau.” ");
INSERT INTO lgl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma Jesus iko 'ali booboo mola sulia me 'are fo gera ilia, ma ka sae 'uri 'e fala Jaeras, “'O ala fitala na 'O alua fitona 'o gi agu” ");
INSERT INTO lgl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iko 'ali 'e ala 'alia ta ioli lou 'ali la failia, talifilia mola Peter, ma James, failia walefae lia John. ");
INSERT INTO lgl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ma talasi gera li dao 'i luma Jaeras li, Jesus ka ronoa nonena failia anina failia lagu na 'e ba'ela rasua. ");
INSERT INTO lgl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ma Jesus ka ru ko, ka sae 'uri 'e fadaulu, “'E 'utaa 'e moulu ka ani, ma moulu ka lagu ka 'uri 'e rasua lo? Wela 'e iko 'ali mae 'e, 'e mo'osu mola.” ");
INSERT INTO lgl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ma gera ka bi wasi 'ada 'alia Jesus. Ma 'i lia ka balida ko 'i maluma, ma ka talaia mama wela fo li, ma teite lia, failia waleli galona lia 'e gera io failia gi, ma gera ka ruu 'i laola mae tobi fo wela fo 'e teo ai. ");
INSERT INTO lgl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma Jesus ka dau ala limala wela fo, ma ka sae 'uri 'e fala, “Talita kom!” Fadanai 'e 'uri 'e, “Lau ilia famu wela 'oka lau, 'o tatae!” ");
INSERT INTO lgl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma wela fo ka tatae, ka ura ma ka liulo. Wela fo akwalae nali wala rua 'e sui lo 'ala 'i burila futanala. Ma gera ka 'afero rasua 'alia me 'are fo. ");
INSERT INTO lgl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wasua ma Jesus sae luida, fasia farononala lou ta ioli 'alia me 'are fo. Ma ka ilia 'ali gera ranolia wela fo. ");
INSERT INTO lgl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus failia waleli galona lia gi, daulu tafisia lo lifi fo, ma daulu ka oli fala falua 'e ba'ela mae ai 'i Nasareti. ");
INSERT INTO lgl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma ala Sabati, fe atoa ala mamalona li, Jesus ka faalalau 'i laola luma fala foana li. Ma ioli afula gi gera ronoa, ma gera ka 'afero rasua. Ma gera ka soilidi kwailiu 'uri 'e, “Ite 'e kwatea nanatana fala ka faalalau 'alia saenala God 'uri 'e, failia taunala 'are mama'ala gi? ");
INSERT INTO lgl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Me wale 'e golu sai 'oka mola 'agaulu ala. Lia wale ba kae galogalo lumaa mola tae. Teite lia mola ba Mary. Nali walefae lia ba James, ma Josef, ma Judas, failia Simon. Ma gelifae lia gi gera io mola 'ada 'i lifi'e.” 'Urifo, gera ka barasi 'alia. ");
INSERT INTO lgl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma Jesus ka sae 'uri 'e fada, “Ioli ala falua gi li gera saiala fa'ilitoanala profet gi. Wasua ma ioli ala falua lia 'i talala gi li, iolifuta lia gi 'ato 'ali gera fa'ilitoa.” ");
INSERT INTO lgl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma 'e iko 'ali totolia lo 'ali 'e taua tali 'are mama'ala 'i laola falua lia 'i talala. Ma ka alua limala fafia barae ioli matai ma ka gurada. ");
INSERT INTO lgl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma ka 'afero rasua 'alia ikoe fakwalaimokina gera. 'Urifo Jesus ka la ala mae falua galia 'i lififo gi li, ma ka faalalau ioli gi. ");
INSERT INTO lgl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ka soia akwala wala rua wale ala waleli galona lia gi 'i so'ela, ma ka kwatea nanatana fada fala balinala aloe 'are ta'a gi, ma ka logosi daulu sui mae ma ka tolini daulu 'ali too rua wale fala me lalana fo. ");
INSERT INTO lgl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma Jesus ka sae nasi 'uri 'e fadaulu, “Moulu ala sakenala ta me 'are fala lalana 'e, talifilia fe kuba mola moulu kae sakea. Ikoso 'ali 'amu sakea ta me fana, 'o ma ta wai, 'o ma tali bata. ");
INSERT INTO lgl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Moulu ka ru 'ae botu mola, ikoso moulu sakea lou ta me 'are 'ali rua lou ala mali 'o rufia lo. ");
INSERT INTO lgl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ala ta ioli 'e kwalo 'amiu, 'amu ka io 'i soela lala ka dao ala talasi moulu kae tafisia falua la li. ");
INSERT INTO lgl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma ala moulu li dao ala ta falua, ma ioli 'i lifila gi iko 'ali gera kwalo 'amiu, ma iko 'ali gera ogaa mola rononamoulu, moulu ka la 'amoulu fasida. Ma moulu ka tafula fulafulala wado faasia 'aemoulu fala fabasunada 'alia kwaikwaina God dunala gera barasi 'alia rononala saenala God.” ");
INSERT INTO lgl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma daulu ka la lo, daulu ka fadaa fala ioli gi 'ali gera olisi faasia ta'ana gera gi. ");
INSERT INTO lgl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma daulu ka balia aloe 'are ta'a afula gi, ma daulu ka waiwaia ioli matai afula gi, ma gera ka gura. ");
INSERT INTO lgl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Herod 'e ronoa 'are sulia Jesus gi lia kae faalalau ma ka guraa ioli gi li. Ma ratala Jesus ka talo lo 'i laola falua gi sui. Ma nali wale gera sae 'uri 'e, “John wale fasiuabu 'e mauri fa'alu lou! Lia 'e kae taua lou 'are mama'ala gi.” ");
INSERT INTO lgl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma nali wale lou gera ka sae 'uri 'e, “'I lia 'a Elaeja.” Ma nali wale gera ka sae 'uri 'e, “'I lia na profet, mala profet ba 'i lao mae gi.” ");
INSERT INTO lgl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ala talasi Herod 'e ronoa 'are fo ioli 'e ilia sulia Jesus gi li, ka sae 'uri 'e, “John wale ba lau kwatea fala 'ole mousinala gwaula, lia 'e 'e tatae lou faasia maena.” ");
INSERT INTO lgl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Herod 'e tolea mola Herodias, wateu walefae lia Filip. Ma John ka sae 'uri 'e fala Herod, “Taki God 'e luia ikoso tolea wateu walefae 'o li.” 'Urifo, liola Herodias ka ta'a rasua fala John, ma ka oga rauninala, wasua ma 'e 'ato rasua fala, dunala Herod 'e saiala John wale rada, ma wale 'e abu. Herod 'e maulia John, ma ka kakalia John. Herod talala lo 'e keria wale gi fala daunala John, ma gera ka alua 'i laola rara faasia Herodias. Herod 'e oga rasua ala rononala John, wasua ka malata guagua 'ala ala talasi kae fafuronosia saenala John ai. ");
INSERT INTO lgl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mola Herodias ka malata daria me talasi agau fala rauninala John. Ala fe atoa fo Herod 'e fabaelaa fe atoa 'e futa ai, ka raunailia te fana na fala ioli ba'ela lia gi, failia ioli ba'ela lia fala kwalaana gi li, failia fainaonao 'i laola provins 'i Galili gi li. ");
INSERT INTO lgl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma ala me talasi fo, ulao Herodias 'e manotafa mae ka wae, Herod failia wale lia gi liafo gera fana ruru failia, geraka saola rasua failia ulao fo. Ma Herod ka sae 'uri 'e fala ulao fo, “Ta me 'are mola 'ala koe sugaa agu, lakae kwatea famu.” ");
INSERT INTO lgl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma ka alafuu 'uri 'e fala, “Tali ta koe sugaa agu, lakae kwatea famu, wasua 'ala ta aba ala tatalona 'e lau.” ");
INSERT INTO lgl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma ulao fo ka latafa ka la lo 'i soela teite lia, ma ka soilidi 'uri 'e, “Tali ta 'e lakae sugada?” Ma teite lia ka olisi 'uri 'e ala, “Gwaula John wale fasiuabu.” ");
INSERT INTO lgl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma ulao fo ka oli nainali 'i so'ela Herod, ma ka suga 'uri 'e ala, “Lau oga ko kwatea mae gwaula John wale Fasiuabu fagu 'i lofola ta taetae 'are ala me talasi 'e mola lo.” ");
INSERT INTO lgl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma Herod ka kwaimalatai rasua sulia me 'are fo. Sui wasua 'ala, sulia 'e alafuu 'i maala ioli 'e fana ruru failida gi, iko 'ali 'e luia lo faasia. ");
INSERT INTO lgl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Herod ka kwatea te wale fala li sakenala mae gwaula John. Ma wale fo ka la 'i laola raraa, ma ka 'ole mousia lo luala John, ");
INSERT INTO lgl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma ka sakea mae gwaula 'i lofola te taetae 'are ma ka kwatea fala ulao fo, ma ulao fo ka kwatea fala teite lia. ");
INSERT INTO lgl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma talasi waleli galona John gi gera rono ala me 'are fo li, gera la mae, gera ka sakea lo rabela, ma gera ka alomia lo. ");
INSERT INTO lgl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wale li lifurono gi daulu oli lo mae, ma daulu ka logo sui mae 'i so'ela Jesus, daulu ka faronoa 'alia 'are daulu tauda gi, failia 'are daulu faalalau sulida gi. ");
INSERT INTO lgl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesus failia waleli galona lia gi, daulu 'abero rasua sulia ioli afula gi gera tagoli dao mola 'ada ala lifi fo daulu io ai. Ma Jesus failia waleli galona lia gi iko 'ali daulu too lo ala ta me talasi fala fana na wasua. Ma Jesus ka sae 'uri 'e fadaulu, “Moulu la mae fae lau 'ali golu la fala ta me lifi buri tatau 'ali goluke mamalo ga 'agaulu.” ");
INSERT INTO lgl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma daulu ka la talifilidaulu 'alia baru fala lifi 'e aroaro. ");
INSERT INTO lgl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","'E 'urifo wasua 'ala, ioli afula gi faasia falua gi sui gera lio raeda, ma gera ka lalao 'i laoada, ma gera ka eta li dao adaulu 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma talasi Jesus 'e sifo faasia baru li, ka lesia te logona ba'ela lifi fo, ma ka kwaimalatai rasua sulia gera malaa lo sipsip iko ta wale fala lio na sulida gi. Ma ka faalalau gera 'alia 'are afula gi. ");
INSERT INTO lgl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma talasi da'afi kae garani sifo lo, waleli galona lia gi daulu la mae 'i so'ela, ma daulu ka sae 'uri 'e, “Lifi 'e iko ta ioli 'ali io ai, ma da'afi kae garani suu lo. ");
INSERT INTO lgl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'O ilia fala ioli 'e gi 'ali gera la lo 'ada, 'ali gera la ala mae falua 'e 'afuida gi, 'ali gera lai foli tali me fana.” ");
INSERT INTO lgl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ma Jesus ka olisi 'uri 'e adaulu, “'I 'amoulu, moulu kwate fana 'ada.” Ma daulu ka soilidi 'uri 'e ala, “'Urila li ma 'o oga 'ali meulu kwatea ta maelae bata fala folinala berete 'ali 'e totolia ranolinala logona 'e?” ");
INSERT INTO lgl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma Jesus ka soilidi 'uri 'e adaulu, “Ta fita me berete moulu too ali? Moulu la moulu ka lai lio mae 'afia.” Ma talasi daulu darida lo daulu ka sae 'uri 'e, “Lima me berete gi mola failia rua lode ia gi.” ");
INSERT INTO lgl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","'Urifo Jesus ka ilia fala waleli galona lia gi 'ali daulu ilia fala ioli fo gi 'ali gera ka gwauru 'alia bolubolunae ioli 'i fofola fasifasi marakwa. ");
INSERT INTO lgl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma gera ka gwauru 'i wado 'alia talanae ioli ma nali bolubolunae ioli lima akwala ioli. ");
INSERT INTO lgl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma Jesus ka sakea lima berete fo gi failia rua lode ia fo gi, ma ka lio 'alaa fala 'i nali, ma ka batafea God. Ma ka liia berete fo gi, ma ka kwatea fala waleli galona lia gi, 'ali daulu tolinia 'i matanala ioli fo gi. Ma ka tolinia lou rua lode ia fo gi fada. ");
INSERT INTO lgl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma ioli afula fo gi gera fana, ma gera ka bote sui lo. ");
INSERT INTO lgl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mola, waleli galona lia gi gera ka golia lo orenala berete failia ia fo gi, ma gera ka fafonua akwala wala rua pera gi. ");
INSERT INTO lgl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lima to'oli wale gi fo gera fana. ");
INSERT INTO lgl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","'I burila me 'are fo, Jesus ka keria waleli galona lia gi 'ali daulu eta fala na gulae 'osi 'alia baru, fala falua 'i Betsaeda. Ma 'i lia ka io 'ala 'i buri 'ali 'e ketaa logona fo. ");
INSERT INTO lgl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","'I burila 'e alualu ala ioli afula fo gi, ka la 'i gwaula te fe uo 'ali foa 'ala. ");
INSERT INTO lgl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma talasi kae fuli 'ae rodo lo mae, baru ba lia lo 'i matanala 'osi, ma Jesus ka io mola 'ala 'ua talifilia 'i rara. ");
INSERT INTO lgl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma Jesus ka lesia waleli galona lia gi, gera galo nanata rasua lo ala foutanaa, sulia daulu laofia me oru. Ma 'i 'ofaedani, Jesus ka liu 'i fofola asi, ka laafi daulu mae. Ma ka garani liufi daulu lo. ");
INSERT INTO lgl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma talasi daulu leesia lia 'e liu 'i fofola asi li, daulu ka fia 'uri 'i lia te aloe 'are. Ma daulu ka akwa babali, ");
INSERT INTO lgl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","suli daulu mau rasua lo ala talasi daulu lesia 'e liu 'i fofola asi li. Ma nainali mola Jesus ka sae ko 'uri'e fadaulu, “'I lau mola tae! Moulu ala mau na.” ");
INSERT INTO lgl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sui mola, ka tae lo 'i laola baru fae daulu, ma oru ka aroaro lo. Ma daulu ka 'afero rasua, ");
INSERT INTO lgl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","sulia iko 'ali daulu malinailia nanatana Jesus too ai fala ranolinala lima to'oli wale ba gi li 'alia lima me berete gi mola. Sulia malata daulu 'e taritarifaa rasua faasia malinailianala 'are fo daulu lesida gi. ");
INSERT INTO lgl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Daulu faifolo ala 'osi fo, ma daulu ka sifo ala mae falua 'i Genesaret, ma daulu ka gwalua baru 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ma talasi daulu tafisia baru li, ioli 'i lififo gi gera lio raea nainali mola ala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma ioli gi gera ka lalao 'i laola 'afutala gwae falua fo gi, ma gera ka sakea mae ioli matai gi 'i fofola tafe gi fala lifi gera ronoa Jesus 'e io ai. ");
INSERT INTO lgl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma lifi Jesus 'e la ai gi sui, falua gera sakea mae ioli matai gi fala 'i uusina gera ka fateoda ma gera ka sugaa Jesus 'ali ioli matai gi gera ka dau tonala tamitamila to'omi tekwa lia. Ma ioli matai gera dau tonala gi sui gera ka gura lo. ");
INSERT INTO lgl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farasi gi ma nali wale falalau ala taki gi li, gera la mae faasia 'i Jerusalem, ma gera ka logo 'afuia Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma gera ka lesia nali wale ala waleli galona Jesus gi iko 'ali gera sau lima sui ma gera ka bi fana. Iko 'ali daulu sau lima sulia falafala fo Farasi gi gera ilia fala ioli Jiu gi 'ali gera tau sulia. ");
INSERT INTO lgl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jiu gi failia Farasi gi lou, gera tau sulia falafala koko gera gi gera faalalau lo mae 'alia. 'E 'ato gera ka fana ala ikoso gera sau lima sulia falafala ala sau limana li. ");
INSERT INTO lgl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma talasi gera ka oli mae faasia 'i uusina, 'e 'ato 'ali gera fana, ala iko 'ali gera sau lima ga sulia falafala gera lo mae 'i lao. 'Urifo gera ka rono sulia falafala afula gera gi, malaa saunala teu gi, failia fe kukii gi, ma dako gi. ");
INSERT INTO lgl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","'Urifo Farasi gi, failia wale falalau ala taki gi li, gera ka soilidi 'uri 'e ala Jesus, “'Uta 'e waleli galona 'o gi iko 'ali gera ronosulia faalalauna koko gia gi gera alua lo mae faga, sulia iko 'ali gera saua mola limada ma gera fana lo?” ");
INSERT INTO lgl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma 'i lia ka olisi 'uri'e adaulu, “Aesea 'e sae kwalaimoki talasi ba 'e alaa suli 'amoulu. 'I 'amoulu wale 'oso'oso gi, malaa lia ba 'e gere 'uri 'e ai, ‘God 'e ilia, ioli 'e gi, gera faaba'ela lau mola 'alia niduda, wasua ma malatada 'e tatau rasua faasi lau. ");
INSERT INTO lgl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gera fo'asi lau gwaugwau mola 'ada, dunala gera faalalau mola 'ada sulia taki gera 'i talada gi, ma gera ka ilia 'uria taki God gi lo sefo!’ ");
INSERT INTO lgl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Moulu aburono ala taki God gi, ma moulu ka ronosulia mola faalalauna ioli li.” ");
INSERT INTO lgl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma Jesus ka sae lou 'uri 'e fadaulu, “Moulu sai rasua ala barasina 'alia ma olisinala taki God gi, ma moulu ka rono mola sulia falafala 'i talamiu gi. ");
INSERT INTO lgl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sulia Moses ba 'e sae 'uri 'e, ‘'O fabaelaa mama 'o, failia teite 'o.’ Ma ‘ala ta ioli 'e 'isia mama lia 'o ma teite lia, gera kae raunia.’ ");
INSERT INTO lgl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wasua ma, moulu faalalau rero 'uri 'e, ala ta ioli 'e too ala ta 'are 'e saiala kae ranaa 'alia mama lia 'o ma teite lia, ma ka sae 'uri 'e, ‘Lakae kwatea 'are 'e gi fala God.’ ");
INSERT INTO lgl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Moulu ilia 'uri 'e 'oka mola 'ala ala ikoso 'ali 'e ranaa lo mama lia failia teite lia 'i osiala me alafuuna fo 'e taua lo fala God 'alia 'are fo gi li. ");
INSERT INTO lgl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma ala 'e 'urilaa, faalalauna 'e moulu alua, 'e fadalaa saenala God. 'Are afula ta'a 'urifo gi moulu tauda.” ");
INSERT INTO lgl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","'Urifo Jesus ka faisoi ka logosia lou mae logona ba'ela fo 'i so'ela, ma ka sae 'uri 'e fada, “Moulu fafurono fagu, ma 'amu ka malinailia: ");
INSERT INTO lgl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Ta me 'are mola 'ala ioli 'e 'ania ikoso taua 'ali 'uli'uli. Me 'are 'e fulia ta'ana gi li, 'e fuli mae 'ala faasia liola ioli, lia lo 'e kwatea ioli ka 'uli'uli.” ");
INSERT INTO lgl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma talasi Jesus 'e tafisia lo logona fo li, ka ruu 'i laola luma failia waleli galona lia gi, ma gera ka soilidia 'ali fadaa saena fo gi. ");
INSERT INTO lgl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma Jesus ka sae 'uri 'e fadaulu, “'Uri'e ma iko 'ali moulu sai mola ala 'are 'e gi li 'e? 'Are ioli ka 'ania ikoso 'ali 'e fa'uli'ulia mola ioli 'i maala God, ");
INSERT INTO lgl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","sulia fana 'e iko 'ali la 'i laola liola ioli. 'E la mola 'ala 'i laola lofola, ma ka sigitafa lou 'ala 'i maluma faasia rabela.” 'I lulufala me alaana 'e lo Jesus 'e ilia fana gi sui gera 'oka mola 'ada fala 'aninali. ");
INSERT INTO lgl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma Jesus ka sae lou 'uri 'e, “Ta me 'are ta'a ta wale ka fulia 'o ma ka ilia ka rero me 'are la gi lo kae fa'uli'ulia 'i maala God. ");
INSERT INTO lgl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","'I osiala malatana ta'a gi 'e manotafa mae faasia 'i laola liola ioli, lia ka taua 'are ta'a gi, ka tau ulao, ma ka beli, ma ka rau ioli, ");
INSERT INTO lgl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma ka tau wateu, ma ka maka'uu, ma ka taua 'are ta'a afula gi, ma ka kotofia ioli, ma ka ma'ali 'are, ma ka 'olafia ioli, ma ka faraea lia 'i talala, ma ka fefeo ka nonoe. ");
INSERT INTO lgl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sulia 'are afula ta'a fo gi sui gera latafa faasia liola ioli, lia 'e taua ka 'uli'uli 'i maala God.” ");
INSERT INTO lgl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sui mola, Jesus ka la lo faasia lifi fo, ma ka la fala gulae falua 'i Taea. Ma ka ru 'i laola te luma, sulia iko 'ali 'e oga ta ioli 'ali 'e saiala lia 'e 'e io 'i lififo li, wasua 'ala 'e 'ato fala 'alia 'e agwa. ");
INSERT INTO lgl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ma te geli ka ronoa liafo Jesus 'e dao, ma ka la nainali mae, ka boururu 'i maala 'aela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma geli fo, geli faasia 'i Fonisia 'i laola iona 'i Siria, ma 'i lia iko lou geli Jiu, ma ulao lia aloe 'are ta'a 'e io ala. 'Urifo, ka aniulu fala Jesus 'ali 'e balia aloe 'are ta'a fo faasia ulao fo lia. ");
INSERT INTO lgl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma Jesus ka sae 'uri 'e sulia Jiu gi liafo gera malaa wela gi li, “Meulu kae etae ranolia ga wela gi. 'E iko 'ali rada 'ali meulu etae taasia ga fana wela gi li fala kui gi.” ");
INSERT INTO lgl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma geli fo ka olisi 'uri 'e ala, “Aofia 'e, kui gi wasua gera sai mola 'ada ala 'aninala lou orenala fana fo 'e toli 'i malula tarapapa fala fanana 'ala wela gi li.” ");
INSERT INTO lgl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sui Jesus ka sae 'uri 'e fala, “'O oli 'amua 'i falua 'o. Te aloe 'are ta'a la, 'e la lo faasia ulao 'o. 'I osiala me olisina la 'o taua agu 'e fatailia 'o fitoo.” ");
INSERT INTO lgl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma ka oli 'i falua, ma ka lesia ulao ba lia 'e mo'osu mola 'ala 'i laola tafe. Ma aloe 'are ta'a ba ka la kwalaimoki lo faasia. ");
INSERT INTO lgl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sui Jesus ka tafisia lo gulae falua 'i Taea, ma ka dao tarosi faasia 'i Saedon, ma gulae falua 'i Dekapolis, ma ka sifo lo ko fala 'i sulia 'osi 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma ioli 'i lififo gi gera ka sakea mae te wale aninala 'e bali ma fokala ka 'ato 'i so'ela Jesus, ma gera ka aniulu fala Jesus 'ali 'e alua limala fafia wale fo. ");
INSERT INTO lgl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma Jesus ka talaia wale fo faasia logona fo 'ali 'e alu talifilidaroa, ma ka dilaa gagaula 'i laola aninala wale fo. Ma ka nisu 'i gagaula, ma ka dau tonala meala wale fo. ");
INSERT INTO lgl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sui mola Jesus ka lio alaala fala 'i nali, ma ka tole manona ba'ela, ma ka sae 'uri 'e, “Efata!” Fadanai 'e 'uri 'e, “Tafa lo!” ");
INSERT INTO lgl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Me talasi fo, aninala wale fo ka tafa ma ka rono lo, failia fokala ka rarae lo ma ka fuli'ae ka sae madakwa lo. ");
INSERT INTO lgl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus ka luia ikoso ta ioli 'ali farono kwailiu 'alia. 'Urifo wasua 'ala ioli gi gera alaa kwailiu mola 'ada 'alia gurana fo Jesus 'e taua ala wale fo li. ");
INSERT INTO lgl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ioli gera ronoa me kwaiguraina fo li, gera ka 'afero rasua ma gera ka sae 'uri 'e, “'Ae wani! 'I lia 'e taua 'oka rasua ala 'are gi sui! Lia 'e taua wale ba aninala 'e bali ka rono lo, ma fokala ba 'e 'ato ka sae lo.” ");
INSERT INTO lgl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Iko 'ali 'e tekwa mola 'i burila 'are fo gi, te logona ba'ela ka dao mae. Ma talasi fo iko lo ta fana 'ada, Jesus ka soia mae waleli galona lia gi ma ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Lau malataia alae ioli 'e sulia gera io lo faelau sulia olu fe atoa gi, ma iko lo ta fana fada fala 'i tara'ela. ");
INSERT INTO lgl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma ala gera fiolo ma laka olifailida 'i falua gera gi, gera kae toli sulia tala, sulia nali ioli ada falua gera gi 'e tatau.” ");
INSERT INTO lgl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma waleli galona lia gi gera ka soilidi 'uri 'e, “'I fe lo golukae daria ta fana kae totolia ranolinala ioli afula 'uri 'e gi 'i laola gulae lifi kwasi 'e iko 'ali totolia ta ioli 'ali io ai?” ");
INSERT INTO lgl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma Jesus ka soilidi 'uri 'e, “Ta fita me berete la moulu too ai?” Ma daulu ka olisi 'uri 'e ala, “Fiu me berete gi 'e.” ");
INSERT INTO lgl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma Jesus ka ilia fala logona fo gera ka gwauru 'i fua. Mola ka sakea fiu berete fo gi, ma ka batafea God, sui ka liia ma ka kwatea fala waleli galona lia gi, daulu ka tolinia ala logona fo. ");
INSERT INTO lgl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma daulu too lou ala barae lode ia wawade gi. Ma Jesus ka kwatea lou batafena fala God, ma ka ilia fala waleli galona lia gi daulu ka tolinia lou ala logona fo. ");
INSERT INTO lgl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma gera ka fana lala gera ka bote sui. 'I burila, waleli galona lia gi gera ka golia lo orenala fana 'i laola fiu pera gi lala ka fonu. ");
INSERT INTO lgl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Logona fo 'e totolia ta fai to'oli wale. Sui Jesus ka olifailida lo fala falua gera gi, ");
INSERT INTO lgl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma 'i lia failia waleli galona lia gi, daulu nainali daulu ka tae 'i laola baru, ma daulu ka la fala na gulae falua 'i Dalmanuta. ");
INSERT INTO lgl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma nali Farasi gera la mae, ma gera ka olisusu failia Jesus, gera ka oga 'ali gera mailitonala. Lia fo gera ka sugaa 'ali 'e fulia ta 'are mama'ala, 'ali 'e fatailia nanatana God 'e kwatea mae ka io ala. ");
INSERT INTO lgl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","'Urifo Jesus ka tole mano, ma ka sae 'uri 'e, “'Uta 'e ioli ala ului wale 'e li gera ka sugaa 'are mama'ala? Lakae ilia me 'are kwalaimoki famoulu, 'e 'ato 'ali lau fatailia mola tali 'are mama'ala fala ului wale 'e.” ");
INSERT INTO lgl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma ka tafisida ka tae lou 'i laola baru, ma ka tofolo fala na gulae 'osi. ");
INSERT INTO lgl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Talasi daulu lo 'i laola 'osi li, waleli galona lia gi gera bulono 'alia sakenala mae tali me berete, wasua ma teke me berete mola daulu too ai 'i laola baru. ");
INSERT INTO lgl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma Jesus ka fabasu 'uri 'e adaulu, “Moulu ka lio 'oka suli 'amoulu faasia iist fala berete li lia 'e ala Farasi gi failia Herod.” ");
INSERT INTO lgl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma gera ka alaa kwailiu 'uri 'e 'i safitada, “'E sae 'urifo 'i osiala iko 'ali golu sakea mae ta me berete.” ");
INSERT INTO lgl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Talasi Jesus 'e saiai lia 'e iko 'ali daulu malinailia me saenaa fo sulia faalalauna ta'a fo Farasi gi failia Herod gera kae taua, ka sae 'uri 'e fadaulu, “'Uta 'e moulu ka alaa sulia lia 'e iko 'ali moulu sakea mae tali me berete? Iko 'ali moulu malinailia 'are 'ualo 'i lao gi laola malatae wale 'e lau ilia famoulu gi? Lau lesia malatamoulu 'e taritarifaa rasua faasia fakwalaimokina. ");
INSERT INTO lgl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Moulu lesia ma moulu ka ronoa 'are afula lau tauda gi, wasua ma iko 'ali moulu malinailida mola. Iko moulu malata mola tonala ");
INSERT INTO lgl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","talasi ba lau liia lima me berete ba gi fala lima to'oli wale ba gi li? Ma ta fita pera ba moulu golia lou orenala fana ba 'i laola lala ka fonu?” Ma daulu ka olisi 'uri 'e ala, “Akwala wala rua pera gi.” ");
INSERT INTO lgl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma Jesus ka soilidi lou 'uri 'e, “Ma talasi ba lau liia fiu me berete ba gi li fala fai to'oli wale, fita pera gi ba moulu golia orenala fana 'i laola lala ka fonu?” Ma daulu ka olisi lou 'uri 'e ala, “Fiu pera gi.” ");
INSERT INTO lgl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma 'i lia ka soilidi lou 'uri 'e adaulu, “'Uta 'e iko 'ali moulu saiala me 'are 'e lakae sae sulia?” ");
INSERT INTO lgl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Daulu li dao ala falua 'i Betsaeda, ma ioli gi gera ka sakea mae te wale maala 'e koro, ma gera ka sugaa Jesus 'ali 'e dau tonala. ");
INSERT INTO lgl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma Jesus ka dau 'i limala wale fo, ka talaia fala 'i maluma faasia falua fo. Ma Jesus ka nisu 'i laola maala te wale fo, ma ka alua limala fafia. Sui, ka soilidi 'uri 'e ala, “'O lesia ta 'are?” ");
INSERT INTO lgl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mola wale fo ka lio alaala ma ka sae 'uri 'e, “Lau lesia ioli gi, gera malaa 'ai gi, ma gera kae liu liu.” ");
INSERT INTO lgl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sui Jesus ka alua lou limala fafia maala wale fo. Ma wale fo ka bi lio kwalaimoki, ma ka lio madakwa lo ala 'are gi sui. ");
INSERT INTO lgl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma Jesus ka keria lo fala 'i luma lia, ma ka sae 'uri 'e fala, “Ko alua la na ga ala mae falua lobaa li.” ");
INSERT INTO lgl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sui Jesus failia waleli galona lia gi daulu ka la fala mae falua 'afuia falua 'i Sesarea Filipae. Ma talasi daulu liu 'adaulu, 'i lia ka soilidi 'uri 'e ala waleli galona lia gi, “Ite ioli gi gera ili lau 'alia?” ");
INSERT INTO lgl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma daulu ka olisi 'uri 'e ala, “Nali ioli gera ili 'o 'alia John wale fasiuabu lia 'e mauri oli lou, ma nali ioli gera ka ili 'o 'alia Elaeja lia 'e mauri lou, ma nali ioli lou gera ka ili 'o 'alia na wale ala profet ba 'i lao gi lia 'e 'e mauri oli lou.” ");
INSERT INTO lgl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma Jesus ka soilidi lou 'uri 'e adaulu, “Ma 'i 'amoulu, moulu soi lau 'alia ite?” Ma Peter ka olisi 'uri 'e ala, “'I'o lo Christ, wale God 'e filia fala faamaurinala ioli lia gi li.” ");
INSERT INTO lgl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma Jesus ka sae nasi 'uri 'e fadaulu, “Moulu alua faronona 'ali lau fala ta ioli.” ");
INSERT INTO lgl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma Jesus ka fuli'ae 'uri 'e fala faalalaunala waleli galona lia gi, “'I lau, Wela Wale li, lakae famalifii ala 'are afula gi. Ma wale etaeta gi, failia fata abu ba'ela gi, failia wale falalau ala taki gi li, gerakae barasi 'ali lau. Ma gera kae rauni lau, ma ala olula fe atoa, Lakae tatae faasia maenaa.” ");
INSERT INTO lgl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ma ka alaa madakwa rasua sulia me 'are fo. Ma Peter ka talaia wawade ko ala fasia alae waleli galona fo, ma ka balufia. ");
INSERT INTO lgl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Wasua ma Jesus 'e bulusi, ka lio fala waleli galona lia gi, ma ka balufi 'uri 'e ala Peter, “Wale 'e li Saetan 'o la tatau ko faasi lau. Malata 'o gi 'are ioli li mola, 'e iko 'alia malata God gi.” ");
INSERT INTO lgl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mola Jesus ka soia mae logona fo failia waleli galona lia gi 'i so'ela, ma ka sae 'uri 'e, “Ta ioli mola 'ala 'e oga kae dona lau, ikoso 'ali 'e malata 'abero sulia 'are lia 'i talala 'e ogada gi. Lia ka marabe fala dona nagu, wasua ka famalifii, 'o ma ka mae ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ta ioli mola 'ala 'e barasi 'alia dona nagu, sulia 'e oga kae taua 'ala sulia kwaiogalina lia gi 'i talala, 'i lia kae talafia maurina firi. Wasua ma ala ta ioli mola 'ala kae mae fagu ma fala Faronona 'Oka 'e, 'i lia kae too ala maurina firi. ");
INSERT INTO lgl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ala ta ioli ka too ala 'arela molagali sui, ma ka mae, ma ka io tatau faasia God, 'are la gi 'ato 'ali gera fulia mola ta me 'okana fala. ");
INSERT INTO lgl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Iko ta ioli 'ali 'e totolia folinala maurina firi 'alia bata. ");
INSERT INTO lgl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma ala ta ioli 'e mau fafi lau failia saenagu 'i laola atoali ta'ana 'e ioli gi gera ikoe foasia lo God, 'urila talasi la kae dao mae failia wasinosinona Mama lau li failia eniselo abu gi, 'I lau, Wela Wale li, lakae mau lou 'alia.” ");
INSERT INTO lgl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mola Jesus ka sae lou 'uri 'e, “Lakae ilia lou famoulu, nali wale amoulu, ala alae wale 'e, ikoso 'ali daulu mae lala daulu ka lesia God kae 'ilitoa fafia ioli lia gi 'alia nanatanala.” ");
INSERT INTO lgl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","'I burila olo fe atoa gi, Jesus ka talaia Peter, ma James, failia John, daulu ka rae fala gwaula fe uo ma daulu ka io talifili daulu 'i lififo. Ma talasi daulu lio ko, daulu ka lesia Jesus 'e olisi 'i maa daulu, ");
INSERT INTO lgl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ma to'omi lia ka wasinosino, ma ka kaka'a rasua. 'E kaka'a ka liufia lo ta to'omi kaka'a ta ioli 'i laola falua 'e 'i wado 'e saua. ");
INSERT INTO lgl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma olu waleli galona fo gi daulu ka lesia Elaeja failia Moses, daro dao tafanae mae 'i soedaulu, ma daro ka alaa failia Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma Peter ka sae 'uri 'e fala Jesus, “Aofia 'e 'oka rasua fagaulu 'ali golu io 'agaulu 'i lifi'e. Meulu kae raunailia olu babala gi, ta ai famu, ta ai fala Moses, ma ta ai fala Elaeja.” ");
INSERT INTO lgl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peter 'e sae 'urifo, sulia iko 'ali 'e sai lo ala ta me 'are fala ilinai, sulia daulu mau rasua lo. ");
INSERT INTO lgl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma me dasa ka sifo mae ma ka 'afu fafi daulu. Ma linela God ka talulu mae faasia me dasa fo ma ka sae 'uri 'e, “Te wela moutae lau lo 'e, lau kwaima rasua ala. Moulu rono sulia!” ");
INSERT INTO lgl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma daulu ka lio nainali 'afui daulu, ma iko 'ali daulu lesia lo ta wale fae daulu, talifilia Jesus mola. ");
INSERT INTO lgl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Talasi daulu sifo lo mae faasia fe uo fo li, Jesus ka sae lui 'uri 'e adaulu, “Moulu ala faronoanala ta ioli 'alia me 'are 'e moulu lesia, lala ka dao ala talasi la 'i lau, Wela Wale li, lau tatae lo faasia maenaa.” ");
INSERT INTO lgl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma daulu ka ronosulia saenala, ma daulu ka alaa kwailiu 'uri 'e 'i safitadaulu, “Malatae wale 'utaa 'e 'e ilia, ‘Lakae tatae faasia maenaa ale?’” ");
INSERT INTO lgl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma daulu ka soilidi 'uri 'e ala, “'Uta 'e wale falalau ala taki gi li gera ka ilia Elaeja kae etae dao mae?” ");
INSERT INTO lgl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma Jesus ka olisi 'uri'e adaulu, “Elaeja 'e etae dao kwalaimoki mae tatabula, 'ali 'e rerei 'ali 'are gi sui. Iko 'ali moulu roronoa 'i laola Geregerena Abu lia ba 'e ilia Wela Wale li kae famalifii rasua ma ioli gi gera kae barasi'alia. ");
INSERT INTO lgl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Lakae ilia famoulu, Elaeja 'e etae dao lo, ma ioli gi geraka taua 'are ta'a gera oga 'ali gera taua ala gi, malaa lia ba Geregerena Abu 'e sae lo mae suli lia.” ");
INSERT INTO lgl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ma talasi daulu oli lo mae 'i safitala waleli galona gera io ko 'i buri gi li, daulu ka lesia te logona ba'ela gera logo 'afuida. Ma nali wale falalau ala taki gi gera olisusu failida. ");
INSERT INTO lgl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma talasi ioli gi gera lesia Jesus, gera ka 'afero rasua, gera ka lalao ko, ma gera ka babalafe fali kwalogaea. ");
INSERT INTO lgl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma Jesus ka soilidi 'uri 'e ala waleli galona lia gi, “Ta gi la moulu kae olisusu 'uri 'e fafida failia alae wale la.” ");
INSERT INTO lgl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma te wale 'i laola logona fo li, ka olisi 'uri 'e ala, “Waleli Faalalau, lau sakea mae ke wela wale lau famu. Aloe 'are ta'a 'e io ala, ma iko 'ali 'e saesae lo. ");
INSERT INTO lgl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma talasi aloe 'are ta'a fo ka dao ala, kae 'ui'ui 'alia 'i wado. Ma fokala ka futofutoa, ka 'alaniriniri, ma rabela ka gaga'ai sui. Ma laka aniulu fala waleli galona 'o gi 'ali daulu balia aloe 'are ta'a fo, ma 'e 'ato rasua fadaulu.” ");
INSERT INTO lgl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sui Jesus ka sae 'uri 'e fadaulu, “'Uri 'e iko 'ali moulu fakwalaimoki lau 'ua! Lau toetoela lo 'alia ikoe fitoonana 'e 'amoulu. Lau io fae 'amoulu ka dao lo 'uri 'e, totolia moulu ka fakwalaimoki lau lo. Sakea mae wela la fagu.” ");
INSERT INTO lgl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma daulu ka sakea mae wela fo fala Jesus. Ma talasi aloe 'are ta'a fo 'e lesia Jesus, ka 'ui 'alia wela fo 'i wado, ma ka bulusia, ma fokala ka futofutoa sui lo. ");
INSERT INTO lgl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma Jesus ka soilidi 'uri 'e ala mama wela fo li, “Talasi ta 'e me 'are 'e 'e fuli ala wela 'e?” Ma 'i lia ka olisi 'uri 'e ala Jesus, “'E fuli 'ua lo mae ala wawadenala. ");
INSERT INTO lgl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Talasi afula 'e 'ui lo mae 'alia 'i laola dunaa ma 'i laola kwai, 'uri 'ali raunia 'ali mae. Ma ala 'e totoli 'o mola 'ala 'o malatai 'ameroa mae, ma ko kwairanai ameroa.” ");
INSERT INTO lgl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma Jesus ka sae 'uri 'e, “'Eo, 'o fakwalaimoki lau! 'Are gi sui 'e talawarau mola 'ala fala ta ioli mola 'ala 'e fakwalaimoki lau.” ");
INSERT INTO lgl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iko 'ali dole mola mama wela fo li ka akwa 'uri 'e, “Lau fakwalaimoki! Wasua 'ala rana lau mae, 'ali fitoona lau 'ali nanata ma ka lalifu!” ");
INSERT INTO lgl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Talasi Jesus 'e lesia logona fo kae tatu mae fala me lifi fo li, ka sae 'uri 'e fala aloe 'are ta'a fo, “'I'o aloe 'are 'e 'o fabalia aninala wela 'e li, ma ko fa'atoa lo fokala wela 'e li, lau ilia famu 'o latafa mae, ma ikoso olifaeburi ko iofia lou wela 'e.” ");
INSERT INTO lgl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma aloe 'are ta'a fo ka rii, ma ka 'asua wela fo, ma ka latafa lo faasia. Ma wela fo lesinala ka malaa lo ioli 'e mae lo. Ma ioli afula gera ka sae 'uri 'e, “'E mae lo.” ");
INSERT INTO lgl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wasua ma, Jesus ka dau ala limala wela fo, ma ka fatataea, ma wela fo ka tatae. ");
INSERT INTO lgl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Talasi Jesus 'e ru 'i laola luma li, waleli galona lia gi daulu ka soilidi 'uri 'e ala talasi daulu io talifilidaulu, “'Uta fo ka 'ato fameulu fala balinala aloe 'are ta'a ba?” ");
INSERT INTO lgl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma Jesus ka olisi 'uri 'e adaulu, “Te foana mola 'e totolia balinala aloe 'are ta'a 'uri fo gi, iko ta me 'are lou.” ");
INSERT INTO lgl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Talasi fo, Jesus failia waleli galona lia gi daulu tafisia lifi fo, ma daulu ka la lo fala gulae falua 'i Galili. Ma Jesus iko 'ali oga ta ioli 'ali saiala me lifi fo daulu io ai, ");
INSERT INTO lgl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sulia 'e faalalau 'uri 'e ala waleli galona lia gi, “'I lau, Wela Wale li, gerekae kwate lau fala malimae lau gi, ma gera kae rauni lau. Ma 'i burila olu fe atoa gi, lakae tatae oli lou faasia maenaa.” ");
INSERT INTO lgl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Wasua ma waleli galona Jesus gi iko 'ali daulu malinailia me 'are fo Jesus 'e ilia, ma daulu ka mau 'alia soilidinala. ");
INSERT INTO lgl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ma talasi daulu li dao ala falua 'i Kapaneam, ma daulu ka ru 'i laola luma li, Jesus ka soilidi 'uri 'e ala waleli galona lia gi, “Ta ba moulu alafaitalili mae fafia sulia tala?” ");
INSERT INTO lgl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wasua ma iko 'ali daulu ilia ta me 'are, suli daulu alafaitalili mae fafia ite adaulu lo 'e ba'ela ka 'ilitoa fafi daulu sui. ");
INSERT INTO lgl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma Jesus ka gwauru 'i fua, ma ka soia mae akwala wala rua waleli galona ba lia gi 'i so'ela, ma ka sae 'uri 'e, “ala ta ai amoulu 'e oga 'ali 'e eta eta, 'i lia kae alu lia ka 'isiburi, ma 'i lia lo wale kae galo folosia ioli gi sui.” ");
INSERT INTO lgl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sui Jesus ka talaia mae te wela, ma ka fa'uraa 'i safitadaulu. 'E ofia wela fo, ma ka sae 'uri 'e fadaulu, ");
INSERT INTO lgl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ala ta ioli kae kwaloa ta wela wawade 'uri 'e 'alia ratagu, 'i lia 'e kwalo lau lou. Ma ala ta ioli 'e kwalo lau, iko 'ali 'e kwalo lau talifili lau mola, 'e kwaloa lou God 'e 'e kwate lau mae.” ");
INSERT INTO lgl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John 'e sae 'uri 'e fala Jesus, “Waleli Falalau, meulu lesia te wale 'e balia aloe 'are ta'a gi 'alia ratamu. Ma meulu ka luia faasia taunala me 'are fo, sulia 'i lia 'e iko lou ta wale ala alae wale 'e golu.” ");
INSERT INTO lgl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma Jesus ka sae 'uri 'e, “Moulu ala luinala lou, sulia ta ioli mola 'ala 'e taua ta 'are mama'ala 'alia ratagu, 'e 'ato 'ali lia ka ilia lou ta me 'are ta'a agu. ");
INSERT INTO lgl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ala ta wale 'e iko 'ali 'e malimae agaulu, 'i lia wale golu la. ");
INSERT INTO lgl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Lakae ilia me 'are kwalaimoki famoulu, ala ta wale 'e kwatea ta mae teu kwai famoulu, 'i osiala 'i 'amoulu ioli lau gi, ioli la kae sake kwalaimoki ala kwaiarana lia. ");
INSERT INTO lgl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ala ta wale ka kwatea ioli 'e gera mamaea gi gera ka toli faasia fitoona gera agu, 'e 'oka 'ali gera gwalua ta fau ba'ela 'i luala, ma gera ka gulufaua 'i laola asi matakwa. ");
INSERT INTO lgl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ma ala ko oga 'ali 'o taua ta me 'are ta'a 'alia limamu, 'ole mousia fa'asi 'o. 'E ke 'oka mola 'ala famu ala ko io tekwa 'amua 'i laola maurina 'i nali failia teke fili lima, ka liufia ala ko bi sifo 'i laola lifi ala kwaikwainali failia rua lima gi, lifi dunaa 'e 'ago firi ai. ");
INSERT INTO lgl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma ala ko oga 'ali 'o taua ta 'are ta'a 'alia 'aemu, 'ole mousia fa'asi 'o. 'E ke 'oka mola 'ala famu ala ko io tekwa 'amua 'i laola maurina 'i nali failia teke fili 'ae, ka liufia ala ko bi sifo 'i laola lifi ala kwaikwainali failia rua 'a'ae gi. ");
INSERT INTO lgl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma ala 'o oga 'ali 'o taua ta 'are ta'a 'alia maamu, 'o lafua 'amua fa'asi 'o. 'E ke 'oka mola 'ala famu ala ko ru 'i laola Tatalona God failia ta teke fili maa, ka liufia ala ko bi sifo 'i laola lifi ala kwaikwainali failia rua maa gi. ");
INSERT INTO lgl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Te lifi fo, wawaa gi gera 'ania ioli gi, ma ioli fo gi ikoso 'ali gera mae, failia dunaa fo 'e 'agofia ioli gi li kae 'ago firi. ");
INSERT INTO lgl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Sulia gera alua dunaa 'i fofola ioli gi sui, ka malaa lo me asi gera tagalailia laola fana li.” ");
INSERT INTO lgl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Me asi 'e 'oka lo, wasua ma ala asiasilanai 'e fulu lo faasia, 'e 'ato 'ali ta me 'are 'ali kwatea 'ali 'e asiasila faeburi lou.” “'Urifo lou, moulu ka fababalafea ioli gi malaa lou meme asi 'e fa'oka fana li. Ma moulu ka io 'alia aroarona 'i safitamoulu.” ");
INSERT INTO lgl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sui Jesus ka tafisia 'i Kapaneam, ma ka la fala gulae falua 'i Judea, ma ka tofolo ala kwai 'i Jodan. Ma ioli afula gi gera ka logo mae 'i soela, ma ka falalau gera, malaa lia ba 'e fuli ka falalau lo mae. ");
INSERT INTO lgl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma nali Farasi gera ka la mae 'i so'ela Jesus, ma gera ka mailia fareronala faasia taki Moses, ma gera ka soilidi 'uri'e ala, “'Uri'e ma taki Moses 'e ala mola 'ala 'alia wale ka lugatailia wateu lia?” ");
INSERT INTO lgl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma Jesus ka olisi 'uri 'e adaulu, “Ta ba Moses 'e kwate kwaikaena famiu 'alia sulia me 'are 'e?” ");
INSERT INTO lgl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma gera ka sae 'uri 'e, “Moses 'e ala'alia wale ka gerea ta 'abae 'are 'ali 'e fatailia barasina 'e taua ma ka kwatea fala wateu lia, 'ali lugasia lo.” ");
INSERT INTO lgl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma Jesus ka sae 'uri 'e, “Moses 'e geresia taki la famoulu sulia 'e 'ato fala faalalaunamoulu. ");
INSERT INTO lgl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wasua ma, fuli lo mae ala talasi God 'e raunailia 'are gi sui, Geregerena Abu 'e ilia, ‘'E raunailia ioli 'alia wale ma geli. ");
INSERT INTO lgl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","'I osiala me 'are fo, wale ka tafisia mama lia failia teite lia, ma ka 'ado failia wateu lia, ");
INSERT INTO lgl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma daro ka alua teke malata mala teke ioli mola lo.’ 'E iko lou ta rua ioli tootoo, ma teke ioli lo. ");
INSERT INTO lgl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Lia fo, 'are God 'e 'adoa lo ka io 'ala 'urifo, iko 'ali 'oka fala ta ioli 'ali tatalia lou.” ");
INSERT INTO lgl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma talasi Jesus failia waleli galona lia gi daulu oli 'i luma, daulu ka soilidia malutala me 'are fo. ");
INSERT INTO lgl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma ka olisi 'uri 'e adaulu, “Ta wale mola 'ala 'e lugatailia wateu lia, ma ka tolea 'ala ta wateu mamata, 'e tau wateu lo fafia wateu lia. ");
INSERT INTO lgl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma 'e 'urifo lou, ala ta wateu 'e lugasia arai lia, ma ka tolea lo ta wale mamata, 'i lia 'e tau arai lo fafia arai lia.” ");
INSERT INTO lgl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nali ioli gera sakea mae ke wela wawade gera gi 'i so'ela Jesus, 'ali 'e dau tonada ma ka fa'okada, wasua ma waleli galona lia gi gera ka balufia ioli fo gi. ");
INSERT INTO lgl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma talasi Jesus 'e lesia me 'are fo li, ka ogata'a, ma ka sae 'uri 'e fadaulu, “Moulu ala 'alia wela wawade gi 'ali gera la mae 'i soegu, moulu ka alua bolosinada. Dunala ioli 'e malata kwalaimoki ka malaa wela wawade, 'i lia 'e totolia iona 'i laola Tatalona God. ");
INSERT INTO lgl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Lakae ilia 'are kwalaimoki famoulu, ala ta ioli 'e iko 'ali fakwalaimoki malaa wela wawade, 'e 'ato rasua 'ali 'e ru 'i laola Tatalona God.” ");
INSERT INTO lgl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma Jesus ka ofia wela wawade fo gi, ma ka alua limala fafida, ma ka fa'okada. ");
INSERT INTO lgl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Talasi Jesus 'e fuli'ae ka la lou ko sulia talaa li, te wale 'e lalao mae, ma ka boururu 'i maala. Ma ka soilidi 'uri 'e, “Waleli Falalauna 'Oka, ta taa 'oka 'e laka taua 'ali lau too ala maurina firi?” ");
INSERT INTO lgl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma Jesus ka olisi 'uri 'e ala, “'Uta 'e ko soi lau 'alia wale 'oka? Iko ta ioli 'ali 'oka, te God mola 'e 'oka. ");
INSERT INTO lgl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","'E 'oka ko saiala alaana 'ilitoa ba God 'uri 'e gi, ‘Ko ala rau ioli na, ma ikoso tau ta'a fasia arai 'o ma wateu 'o, ma ikoso beli, ma ikoso kotofafi ta ioli, ma ikoso kotofia ma ko belia ta ioli, ma ko fa'atoa mama 'o failia teite 'o.’” ");
INSERT INTO lgl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma 'i lia ka sae 'uri 'e, “Waleli Falalauna, 'e fuli lo mae ala talasi lau wawade, laka ronosulia lo mae taki 'e gi sui.” ");
INSERT INTO lgl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Mola, Jesus ka lio ko fala 'alia kwaimanaa, ma ka sae 'uri 'e fala, “Teke me 'are mola 'e iko 'ua amu. 'O la ma ko foli 'alia too 'arena ba 'o sui, ma ko sakea bata ai gi, ma ko kwatea fala ioli siofa gi, ma ko bi too ala too 'arena 'i nali. Sui ko dona buri lau.” ");
INSERT INTO lgl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Me talasi wale fo 'e ronoa mola 'are fo gi li, maala ka lio kwaimalatai lo. Ma ka la lo 'ala failia kwaimalataina, sulia 'i lia wale too 'are rasua. ");
INSERT INTO lgl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sui Jesus ka lio ko fala waleli galona lia gi ma ka sae 'uri 'e, “'E 'ato rasua fala ioli too 'are gi 'ali gera ru 'i laola Tatalona God.” ");
INSERT INTO lgl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma waleli galona lia gi gera ka 'afero rasua 'alia alaana fo gi. Sui Jesus ka sae lou 'uri 'e fadaulu, “Alae wela lau, 'e 'ato rasua fala ruuna 'i laola Tatalona God. ");
INSERT INTO lgl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","'E 'ato rasua 'alia ta kamel 'ali 'e ruu sulia mae kwakwaana wawade 'i mala suli li. 'E 'ato ka lai liufia lou 'ali ta ioli too 'are 'ali 'e ruu 'i laola Tatalona God.” ");
INSERT INTO lgl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ma waleli galona lia gi daulu ka 'afero rasua, sulia daulu fia 'uria too 'are na 'oilakina mae faasia God tafo. Ma daulu ka soilidi kwailiu adaulu 'uri 'e, “'Urilali mala ikoso ta ioli 'ali too ala maurina firi?” ");
INSERT INTO lgl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma Jesus ka lio ragaragaa ko fadaulu ma ka sae 'uri 'e, “'E 'ato fala ioli gi talada 'ali gera too ala maurina firi, wasua ma fala God iko 'ali 'ato mola. 'Are gi sui 'e talawarau fala God.” ");
INSERT INTO lgl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma Peter ka sae 'uri 'e fala, “'I 'ameulu meulu tafisia lo 'are gi sui 'ali meulu dona 'o!” ");
INSERT INTO lgl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma Jesus ka olisi 'uri 'e ala, “'Eo, lakae ilia famoulu, ala ta ioli kae tafisia luma lia, 'o ma walefae lia gi, 'o ma gelifae lia gi, 'o ma mama lia, 'o ma teite lia, 'o ma wela lia gi, 'o ma wado lia, dunagu failia Faronona 'Oka 'e, ");
INSERT INTO lgl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","'i lia kae too lou ala 'are la gi ka afula ka liufia lou 'i lao. 'I lia kae too 'are afula lou malaa luma gi, failia walefae gi, ma gelifae gi, ma teite gi, failia wela gi, ma wado. Ma kae too lou ala famalifiina. Ma talasi kae dao mae, 'i lia kae too ala maurina firi. ");
INSERT INTO lgl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wasua 'ala ioli afula gera eta 'i lao gi, gera kae 'isiburi, ma ioli afula 'e gera 'isiburi gi, gera kae etaeta 'i lao.” ");
INSERT INTO lgl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesus failia waleli galona lia gi, daulu la sulia tala fala 'i Jerusalem, ma Jesus ka etaeta ko adaulu. Ma waleli galona lia gi daulu ka 'afero rasua, failia ioli gera dona daulu ko gi, gera mau rasua. Ma Jesus ka talaia akwala wala rua waleli galona lia gi ka ke 'idu tatau lou ko faasia ioli gi. Ma ka bi farono daulu 'alia me 'are kae fuli fala. ");
INSERT INTO lgl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ma Jesus ka sae 'uri 'e, “Moulu fafurono! Golu kae laa fala 'i Jerusalem, ma gera kae 'oi 'agua ma gera kae kwate lau, Wela Wale li, fala fata abu ba'ela gi failia wale falalau ala taki gi li. Ma gera kae kwate kwaikwaina fagu fala maenagu, ma gera kae kwate lau fala ioli mamata gi. ");
INSERT INTO lgl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma ioli la gi gera kae faora 'ali lau, ma gera kae nisufi lau, ma gera kae kwai lau, ma gera kae rauni lau. Ma ala olula fe atoa, lakae tatae lou faasia maenaa.” ");
INSERT INTO lgl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","'Urifo mola, James failia John, rua wela wale Sebedi gi, daro ka la mae 'i so'ela Jesus, ma daro ka sae 'uri 'e, “Waleli Falalauna, 'i 'ameroa mera oga ko kwatea ta me 'are mola 'ala mera kae sugaa amu.” ");
INSERT INTO lgl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma Jesus ka soilidi 'uri 'e adaroa, “Ta mora oga 'ali lau taua famoroa?” ");
INSERT INTO lgl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma daro ka olisi 'uri 'e ala, “Talasi koe 'ilitoa fafia molagali ma 'are gi sui, ko ala 'alia ta wale ameroa 'ali 'e gwauru 'i aba aolo amu, ma ta wale ala aba mauli amu fala 'ilitoana fafia ioli gi li.” ");
INSERT INTO lgl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ma Jesus ka sae 'uri 'e fadaroa, “Mora raria me 'are 'e mora sugaa 'uri 'e ai. 'Uri mora totolia mola 'amoroa famalifiina 'e kae dao agu?” ");
INSERT INTO lgl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma daro ka olisi 'uri 'e ala, “'I 'ameroa mera totolia mola 'ameroa fala taunai.” Ma Jesus ka sae 'uri 'e fadaroa, “Aia 'e 'oka, mora kae famalifii lou malaa 'i lau. ");
INSERT INTO lgl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wasua ma iko 'ali lau lakae filia ite kae gwauru 'i gula aolo agu ma gula mauli agu. Talifilia God lo kae kwatea lifi 'urifo gi fala nalife ioli lia 'e rerei 'alida maasida.” ");
INSERT INTO lgl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma talasi akwala waleli galona fo gi daulu ronoa me 'are fo li, daulu ka ogata'a fala James failia John. ");
INSERT INTO lgl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma Jesus ka logosi daulu ma ka sae 'uri 'e fadaulu, “Moulu sai mola 'amoulu ai wale ba'ela 'e gera 'ilitoa fala ioli 'e iko 'ali gera Jiu gi li, gera too ala nanatana, ma gera sai rasua ala suunaenala ioli fala taunala 'are gera ogada gi. ");
INSERT INTO lgl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wasua 'ala, ikoso ke 'urifo lou 'i safitamoulu. Ala ta ioli amoulu 'e oga ka etaeta, 'i lia ka saiai 'i lia ioli fali galo mola folosi 'amoulu. ");
INSERT INTO lgl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma ala ta ioli amoulu 'e oga ka 'ilitoa, 'i lia ka galo gwaugwau fala ioli gi sui. ");
INSERT INTO lgl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sulia 'i lau, Wela Wale li, iko 'ali lau la mae 'ali ioli 'ali galo folosi lau. Wasua ma lau la mae 'agua 'ali lau galo folosia ioli gi sui, ma laka kwatea maurinagu fala faamurinala ioli afula gi.” ");
INSERT INTO lgl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ala me talasi fo, Jesus failia waleli galona lia gi daulu dao lo mae ala falua 'i Jeriko. Ma talasi daulu tafisia lo falua fo failia logona ba'ela fo li, te wale maala 'e koro 'e gwauru mola 'ala 'i sulia tala fala suganaa. Ratala Batimeas, wela Timeas. ");
INSERT INTO lgl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma talasi 'e ronoa Jesus, wale 'i Nasareti kae lao mae, ka akwa 'uri 'e, “Jesus 'i'o la wela wale ala kwalofa David, 'o amasi lau mae.” ");
INSERT INTO lgl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma ioli gi gera ka famanoa geraka saebolosia ma gera ka ilia fala 'ali 'e io aroaro. Wasua ma 'e bi akwa ka ba'ela rasua lou 'uri 'e, “Ulufa'alu fo ala kwalofa David li, 'o amasi lau mae!” ");
INSERT INTO lgl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma Jesus ka mano ma ka sae 'uri 'e, “Moulu soia mae.” Ma geraka soia Batimeas, ma gera ka sae 'uri 'e, “'O babalafe! Tatae lo, Jesus 'e faisoi lo mae famu.” ");
INSERT INTO lgl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Suimola ka tasia lo to'omi ba'ela lia, ma ka tatae nainali, ma ka la lo 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma Jesus ka soilidia 'uri 'e, “Ta 'o oga 'ali lau taua famu?” Ma wale maa koro fo ka olisi 'uri 'e ala Jesus, “Waleli Falalauna, lau oga 'ali lau lio lou.” ");
INSERT INTO lgl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma Jesus ka sae 'uri 'e fala, “'O la lo. 'O Lio lo dunala 'o fakwalaimoki lau.” Ma iko 'ali dole mola mala ka madakwa lo, ma ka donaa lo Jesus sulia talaa. ");
INSERT INTO lgl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Talasi Jesus failia waleli galona lia gi daulu li dao garania falua 'i Jerusalem, daulu dao ala falua 'i Betfeis ma 'i Betani, gwaula fe uo gera soia 'alia 'i Olif. Mola, 'i lia ka kwatea na rua wale ala waleli galona lia gi, daro ka eta lo 'i lao. ");
INSERT INTO lgl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma ka sae 'uri 'e fadaroa, “Mora la ala mae falua lobaa mora laofia ko. Ma talasi mora ka lai dao 'i lififo li, mora kae lesia te dongki. Gera firia mola 'ada dongki fo, ma iko ta ioli 'ali'e tae tae 'ua 'i fofola. Mora ka tatalia, ma mora ka talaia mae fala 'i lifi'e. ");
INSERT INTO lgl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma ala ta ioli ka soilidi 'amoroa, ‘'Uta 'e mora ka tatali 'uri 'e ala dongki 'e?’ Mora ka ilia fala, Aofia 'e boboo fai, ma kae olifae nainali lou mae ai 'i lifi 'e.’” ");
INSERT INTO lgl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ma daro ka la lo, daro ka lesia ke dongki gera firia mola 'ada sulia tala 'i mala te luma. Ma talasi daro kae tatalia, ");
INSERT INTO lgl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nali wale gera ura 'i lififo, gera ka soilidi 'uri 'e adaroa, “Ta la mora kae tatalia ke dongki la fai?” ");
INSERT INTO lgl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma daro ka olisidaulu mala me ilina ba Jesus 'e taua fadaroa, ma wale fo gi ka ala 'alia fadaroa. ");
INSERT INTO lgl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma daro ka talaia mae ke dongki fo 'i so'ela Jesus, ma daulu ka folotailia lo me to'omi daulu gi fali rafalia fofola donki fo, ma Jesus ka rae 'i fofola. ");
INSERT INTO lgl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ioli afula gi gera ka folotailia to'omi tekwa gera gi 'i sulia tala, ma nali ioli gera ka tofua 'abala baibai, ma gera ka folotailia sulia tala. Gera tolae 'urifo fala faba'elanala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Falua gera la failia, nali ioli gera ka etaeta 'i lao ala, nali ai gera aliburia, gera akwa 'uri 'e, “'Auraea God! Ma God ko oilakitailia wale 'e 'e la mae 'alia nanatana 'o li! ");
INSERT INTO lgl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ma God ko oilakitailia mae daonala tatalona 'e malaa tatalona ba koko gia David li! 'Auraea God lia 'e io 'i nali!” ");
INSERT INTO lgl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesus ka ruu 'i laola falua 'i Jerusalem, ma ka la 'i laola Luma Abu God. Sui ka lio kwailiu ka lesia 'are gi sui. Wasua ma sulia 'e garani rodo lo, ka la lo fala 'i Betani failia akwala wala rua waleli galona ba lia gi. ");
INSERT INTO lgl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ka lai dani ala fe atoa 'i buri, Jesus ka fiolo talasi 'i lia failia waleli galona lia gi daulu kae oli lo mae faasia 'i Betani. ");
INSERT INTO lgl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma ka lio ko, ka lesia te 'ai ulua gera soia 'alia figi li. Ma ka la garania 'uri 'ali 'e lesia ta fuae 'are ai. Wasua ma talasi 'e dao 'i 'aela, ka lesia mola rarae 'are gi, sulia talasi fo iko 'ali talasi fala figi gi fala funu na li. ");
INSERT INTO lgl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma Jesus ka sae 'uri 'e fala fe 'ai figi fo, “'Ato 'ali ta ioli 'ali 'ania lou ta fuae 'are amu!” Ma waleli galona lia gi daulu ka ronoa me 'are fo. ");
INSERT INTO lgl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ma talasi daulu dao lo 'i Jerusalem, Jesus ka la 'i laola Luma Abu God. Sui, ka balia ioli gera kae foli 'alia 'are fala foasina gi li ma ai gera kae foli 'are gi, ma ai gera kae 'olafi ioli 'i lififo gi li. Ma ka geusia tafe ioli gera kae oliolisi bata gi, ma ka liisia tafe fali gwaugwauru 'ala ioli gera kae foli 'alia fe bola gi li. ");
INSERT INTO lgl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma iko 'ali ala 'alia ta ioli 'ali sakea ta me 'are 'i laola Luma Abu God. ");
INSERT INTO lgl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma ka falalaua ioli gi, ka sae 'uri 'e, “God 'e ilia 'i laola Geregerena Abu ka sae 'uri 'e, ‘Luma lau, gera soia 'alia luma fala fo'ana 'ala iolila molagali sui.’ Wasua ma moulu bulusia 'alia lifi fala belinala ioli.” ");
INSERT INTO lgl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Talasi fata abu ba'ela gi failia wale falalau ala taki gi li gera ronoa me 'are fo li, gera ka fuli'aela lo lio na 'afia ta me 'are fala rauninala Jesus. Ma gera ka mau 'alia, sulia logona fo sui gera 'afero rasua 'alia faalalaunala. ");
INSERT INTO lgl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","'E raurafi lo, Jesus failia waleli galona lia gi, daulu ka tafisia lo 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","'Ofaedani ala fe atoa 'i buri, Jesus failia waleli galona lia gi daulu ka la sulia tala. Daulu ka lesia 'ai figi ba 'e kuku sui lo la ka sifo ka dao 'i kalokalola. ");
INSERT INTO lgl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma Peter ka malata tonala 'are ba Jesus 'e taua ala 'ai fo li, ma ka sae 'uri 'e fala, “Waleli Falalauna, lesia ga 'ai figi ba 'o 'uasia 'e mae lo!” ");
INSERT INTO lgl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma Jesus ka olisi 'uri 'e ala, “Moulu fitoo kwalaimoki lo ala God. ");
INSERT INTO lgl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Lakae ilia famoulu, ala moulu kae sae 'uri 'e fala fe uo 'e, ‘'O tatae, ma ko 'ui 'ali 'o 'i talamu 'i laola asi,’ ma iko 'ali moulu malata ruarua 'i laola malatamoulu, ma moulu ka malata kwalaimoki ala me 'are 'e moulu ilia kae fuli, 'are la kae fuli mola 'ala famoulu. ");
INSERT INTO lgl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lia 'e lakae ilia famoulu, talasi moulu ka foa, ma moulu ka sugaa ta 'are, moulu ka falalamaa moulu sakea lo, ma God kae kwatea mola 'ala me 'are la moulu suga. ");
INSERT INTO lgl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","'Eo, talasi 'amu ka foa, 'amu ka kwailufa 'alia ta'ana ta ioli 'e taua amiu gi, 'ali Mama 'amiu lia 'e io mae 'i nali ka kwailufa lou 'alia ta'ana 'amiu gi.” ");
INSERT INTO lgl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesus failia waleli galona lia gi, daulu oli lou mae fala 'i Jerusalem. Talasi Jesus 'e la ko 'i laola Luma Abu God, fata abu ba'ela gi, failia waleli falalau ala taki gi li, failia wale fainaonao gi, gera la mae 'i so'ela. ");
INSERT INTO lgl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma gera ka soilidi 'uri 'e ala, “Nanatana lalama ta 'e 'o too ai fala taunala 'are 'e gi? Ma ite 'e kwatea famu?” ");
INSERT INTO lgl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma Jesus ka olisi 'uri 'e adaulu, “'Eo, laka soilidi 'amoulu ga 'alia me 'are. Ala moulu olisi lau, laka bi faarono 'amoulu 'alia nanatana lalama 'e lau too ai fala taunala 'are 'e gi li. ");
INSERT INTO lgl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Moulu ilia ga fagu, nanatana lalama ba John 'e too ai fala fasiuabu na li 'e fuli mae 'i fe ba? 'E fuli mae ala God, 'o ma 'e fuli mola mae ala ioli?” ");
INSERT INTO lgl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma daulu ka fuli'ae ala alafaitalilina kwailiu 'uri 'e 'i safitadaulu, “Ta me ta golu kae ilia? ala golu ka olisi 'uri 'e ala, ‘'E fuli mae faasia God,’ 'i lia kae ilia, ‘'E 'Urilali 'utaa iko 'ali moulu fakwalaimokia John?’ ");
INSERT INTO lgl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma 'e iko 'ali 'oka lou 'ali golu ilia, ‘'E fuli mola mae ala ioli.’” Daulu tau 'urifo sulia daulu maulia ioli gi, dunala ioli gi sui gera saiala John 'i lia profet kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Me 'are la fo, daulu ka olisi 'uri 'e ala Jesus, “Meulu raria.” Ma Jesus ka sae 'uri 'e fadaulu, “'I lau wasua ikoso lau tafanailia lou nanatana lalama 'utaa 'e lau taua 'are 'e gi 'alia.” ");
INSERT INTO lgl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sui, Jesus ka alaa fala wale ba'ela Jiu gi li 'alia tarifulaana ka sae 'uri 'e, “Te wale 'e fasia raku. Ma ka raunailia banisi galia, ma ka 'elia te gilu fala manisinala fuae 'ai fala raunailianala waen, ma ka raunailia te luma fala lioliona 'afuia raku li. Ma ka alua raku lia 'i lofola limala ioli gera galo 'i laola gi. Sui, ka la lo 'ala fala na mae falua. ");
INSERT INTO lgl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma talasi raku fo 'e maua, ka keria na ioli 'e galo 'ala 'i soela ioli fo gera galo 'i laola raku lia li, 'uri 'ali gerake kwatea mae ta gula ala fuae 'are fo gera fisuda gi. ");
INSERT INTO lgl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wasua ma ioli fo gera galo 'i laola raku gi li gera firi nasi ala, ma gera ka rabusia, ma gera ka olifae gwaugwau mola 'ada ala. ");
INSERT INTO lgl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mola, wale ba 'e too ala raku fo li ka keria lou na ioli 'e galo 'ala. Ma ioli fo gera galo 'i laola raku li, gera ka kwaia gwaula, ma gera ka malata'a rasua lo ala. ");
INSERT INTO lgl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sui wale ba 'e too ala raku li, ka kwatea lou na ioli 'e galo 'ala, ma daulu ka raunia ka mae lo. Ma daulu ka tau lou 'urifo ala ioli afula 'e kerida 'i buri gi. Daulu rabusia nali wale, ma daulu ka raunia nali wale ka mae. ");
INSERT INTO lgl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Teke wale mola 'e orea fala kerinala, teke wela moutae lia wale fo li. Ka keria, ma ka malata 'uri 'e, ‘Gera kae lio 'ato ala wela lau.’ ");
INSERT INTO lgl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Wasua ma, ioli fo gera galo 'i laola raku li, daulu sae kwailiu adaulu 'uri 'e 'i safitadaulu, ‘Wela ba wale 'e too ala raku li lo 'e. La mae 'ali golu raunia, 'ali golu too lo 'agaulu ala 'are lia gi sui.’ ");
INSERT INTO lgl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma daulu ka sakea wela fo, daulu ka raunia ka mae, mola daulu ka 'ui 'alia lo rabela 'i maluma faasia laola raku fo.” ");
INSERT INTO lgl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma Jesus ka soilidi 'uri 'e adaulu “Ta me ta wale 'e 'e too ala raku li kae taua? 'I lia kae la mae, ka raunia ioli fo gi. Sui ka kwatea raku fo lia fala ioli mamata gi. ");
INSERT INTO lgl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Lia ba 'amu idumia lo 'i laola Geregerena Abu ba 'e sae 'uri 'e, ‘Me fau 'e ioli raunae luma gi gera barasi 'alia, lia lo me fau 'e 'ilitoa ka liufia fau gi sui ala balibali. ");
INSERT INTO lgl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","God lo 'e fulia me 'are fo, ma lesinai ka 'oka rasua.’” ");
INSERT INTO lgl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Wale etaeta Jiu gi li, gera oga 'ali gera daua Jesus, sulia gera saiala Jesus 'e sae sulia tarifulaana fo fala tafanaenala reronada. Wasua ma gera mau 'alia logona fo gera ka tafisia, ma gera ka la lo 'ada. ");
INSERT INTO lgl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nali ioli etaeta ala Jiu gi, gera kwatea nali Farasi ma nali wale faasia alae wale Herod 'ali daulu soilidia Jesus 'uri 'ali daulu faboeboetaa. ");
INSERT INTO lgl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Daulu dao 'i so'ela ma daulu ka sae 'uri 'e, “Waleli Falalauna, meulu raea 'are 'o ilida gi, 'are kwalaimoki gi sui mola. 'O faalalau sulia kwalaimokina ma nanatana failia liola God fala ioli gi. Ma iko 'ali 'o ke 'ado failia ta ioli failia me malatae wale gera gi. Ma iko 'ali 'o malata ba'ela mola ala 'ilitoanala ta ioli. 'O ilia ga fameulu! 'E uta? Taki gia 'e luia kwatenala bata ala takisi li fala wale ba'ela 'i 'afutala Rom? 'E uta? 'E totolia mola 'ala 'ali meulu kwatea takisi fo, 'o 'e iko?” ");
INSERT INTO lgl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wasua ma, Jesus 'e sai mola 'ala ala koto na daulu, ma ka olisi 'uri 'e adaulu, “'Uta moulu ka tau fala faareronagu? Moulu sakea mae ta me seleni 'ali lau lesia ga.” ");
INSERT INTO lgl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma daulu ka sakea mae me seleni, ma ka soilidi 'uri 'e adaulu “Ma lulula ite 'e? Ma ratala ite 'e lou?” Ma daulu ka olisi 'uri 'e ala, “Lulula failia ratala wale li talona 'i Rom.” ");
INSERT INTO lgl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma Jesus ka sae 'uri 'e, “Moulu kwatea fala wale 'e talo 'i Rom 'are lia gi, ma moulu ka kwatea lou 'are God gi fala God.” Ma daulu ka 'afero rasua 'alia. ");
INSERT INTO lgl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sui, nali Sadusi gera la mae 'i so'ela Jesus. Sadusi gi gera ilia 'uria ioli gi ikoso gera tatae lou faasia maena. ");
INSERT INTO lgl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ma gera ka soilidi 'uri 'e ala Jesus, “Waleli Faalalauna, Moses 'e gerea taki faga ka alafuu 'uri 'e, ‘ala ta wale 'e mae ma wateu lia ka mauri 'ua, wasua ma iko 'ali too ala ta wela, walefae lia ka tolea lou me 'oru fo, 'uri 'ali daro alu ta wela 'ali olitalala wale fo 'e mae lo.’ ");
INSERT INTO lgl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Fiu walefae gi daulu io. Ma wale 'i lao ka tolea te geli, ma iko 'ali alua mola ta wela ka mae lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sui ruala walefae ka tolea lou geli fo, ma iko 'ali alua lou ta wela ka mae lou 'ala. Sui olula walefae ka 'urifo lou. ");
INSERT INTO lgl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma ka 'urifo lou fala ai burila gi sui. Ma fiu walefae fo gi sui fo daulu tolea geli fo, ma iko 'ali daulu alua mola ta wela, ma daulu ka mae sui lo 'adaulu. Sui, geli fo ka mae lou. ");
INSERT INTO lgl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","'Urifo li ma talasi God kae taea ioli mae gi sui faasia maenaa li, ite adaulu lo arai geli fo li? Sulia fiu walefae fo gi sui ba daulu toletolea lo geli fo.” ");
INSERT INTO lgl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma Jesus ka olisi 'uri 'e adaulu, “Moulu rero rasua, sulia iko 'ali moulu raea mola Geregerena Abu failia nanatanala God. ");
INSERT INTO lgl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sulia, talasi fo ioli mae gi gera kae mauri oli lou, gera malaa lo 'ada eniselo 'i nali gi, ikoso gera too wale 'o too geli lo. ");
INSERT INTO lgl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Lakae faalalau 'amiu sulia tataena faasia maenaa li. Lau saiai 'amu idumia 'i laola geregerena ba Moses ala me lifi ba 'e sae sulia duna ba 'e 'agofia buruburui maasu ba li. God ka sae 'uri 'e fala Moses, ‘'I lau lo God 'a Abraham, failia God 'a Aesak, ma God 'a Jakob.’ ");
INSERT INTO lgl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Fadanai 'e 'uri 'e, wale fo gi gera mae lo, wasua 'ala God 'e ilia 'i lia God gera 'ua, sulia gera mauri mola 'ada failia. Moulu rero rasua lo!” ");
INSERT INTO lgl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma te waleli falalau ala taki Moses, 'e ronoa alaana fo gi. Ma ka ronoa olisina 'oka Jesus 'e taua ala Sadusi gi li. Ka la mae ma ka soilidi 'uri 'e ala Jesus, “Taki 'utaa lo 'e ba'ela ka eta ala taki Moses gi sui?” ");
INSERT INTO lgl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma Jesus ka olisi 'uri 'e ala, “Taki 'e ba'ela ka eta ala taki gi li sui 'e 'uri 'e, ‘Jiu gi 'amu fafurono! God gia, 'i lia teke God mola. ");
INSERT INTO lgl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","'O kwaima ala God 'o 'alia malatamu laulau, ma 'alia manomu laulau, ma 'alia liomu laulau, ma 'alia nanatanamu laulau.’ ");
INSERT INTO lgl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma ruala taki 'e 'uri 'e, ‘Ko kwaima ala ioli gi sui ka malaa lou lia 'e 'o kwaima amu 'i talamu.’ Iko ta taki lou 'ali 'e ba'ela ka liufia rua taki 'e gi.” ");
INSERT INTO lgl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Waleli falalau ala taki Moses ka sae 'uri 'e fala Jesus, “Waleli Faalalauna, olisina 'o 'e 'oka rasua. 'E kwalaimoki, talifilia Aofia mola 'e God, ma iko lou ta god mamata. ");
INSERT INTO lgl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma ioli gi sui gera ka kwaima lo ala God 'alia lioda laulau, ma 'alia malatada laulau, ma 'alia nanatanada laulau. Ma gera ka kwaima ala ioli gi sui ka malaa lou me kwaimana gera tau ada 'i talada. Ioli gera ronosulia rua taki 'e gi li, gera taua me 'are 'ilitoa rasua ka liufia kwate foasina fala God.” ");
INSERT INTO lgl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ma Jesus ka lesia liotoo 'e too ai ma ka sae 'uri 'e fala, “'O garani rasua lo fala God 'ali 'ilitoa fafia maurina 'o.” 'I burila me 'are fo, iko ta ioli 'ali too oga lo fali soilidia lou Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sui Jesus ka faalalau 'i laola Luma Abu God ka soilidi 'uri 'e, “'E 'utaa 'e wale falalau ala taki Moses gi li gera ilia Christ wale ala kwalofa David li? ");
INSERT INTO lgl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aloe 'are Abu ba 'e sae 'uri 'e 'alia David, ‘God 'e ilia fala Aofia lau: 'O gwauru 'i aba aolo agu, ma ko 'ilitoa faelau, masia talasi lakae alua malimae 'o gi gera ka ronosuli 'o.’ ");
INSERT INTO lgl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“David 'i talala fo 'e soia Christ 'alia ‘Aofia.’ 'Are la fo, Christ 'e iko 'ali wela wale ala kwalofa David li mola. 'I lia Aofia David lou.” Logona ba'ela fo gera babalafe rasua talasi gera ronoa Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma Jesus ka faalalau 'uri 'e ada, “'Amu madafi 'amiu faasia wale falalau ala taki Moses gi li, sulia gera oga liuna failia to'omi tekwa gi li. Ma gera ka oga rasua lou ala ioli gi 'ali gera fa'ilitoada, ma 'ali gera ka sae 'oka folisida 'i maala uusina gi. ");
INSERT INTO lgl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma gera ka oga gwauruna 'i lao ala lifi 'ilitoa 'i laola luma fala foana gi li, ma ala lifi 'oka gi ala talasi fala fanana gi li. ");
INSERT INTO lgl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Wasua ma gera belia luma gi failia 'are 'oru gi gera too ali gi. Ma gera ka foa tekwa 'uri 'ali ioli gi gera soilafeda. Waleli faalalau ala taki Moses gi li kwaikwaina gera kae ta'a rasua fada!” ");
INSERT INTO lgl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus 'e gwauru 'i laola Luma Abu God garania taetae 'are fala alu bata na 'i laola. Ka lesia ioli gera kwatea bata gera gi li. Ma ioli afula gera too 'are gi gera kwatea bata afula. ");
INSERT INTO lgl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sui, ka lesia me 'oru dalaa rasua. 'E la mae, ka kwatea lou rua me seleni wawade gi. ");
INSERT INTO lgl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma Jesus ka soia mae waleli galona lia gi, ma ka sae 'uri 'e fadaulu, “Me 'are kwalaimoki lakae ilia famoulu, me kwatena 'e geli 'oru 'e li, 'e ba'ela ka liufia kwatekwatena ioli gera kwate bata ba'ela gi. ");
INSERT INTO lgl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sulia ioli fo gera too 'are gi gera kwatea mola nali keme aba wawade ala too 'arena gera gi. Wasua ma me 'oru dalaa 'e, 'e kwate tefau lo ala me 'are 'e too ali fala ionala gi sui.” ");
INSERT INTO lgl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Talasi Jesus 'e tafisia lo Luma Abu God li, na waleli galona lia ka sae 'uri 'e fala, “Waleli faalalauna, 'o lesia ga fau ba'ela fo gi, failia luma 'oka 'e gi ala Luma Abu God!” ");
INSERT INTO lgl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma Jesus ka olisi 'uri 'e ala, “'O oga luma ba'ela 'e ala Luma Abu 'e God tae ne! Ikoso ta teke me fau 'i lifi'e ala Luma Abu 'e God kae io 'i fulila. Gera kae tagalae sui 'i wado.” ");
INSERT INTO lgl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma talasi Jesus 'e io 'i gwaula fe uo 'i Olif, totolala Luma Abu God, Peter, failia James, failia John, ma Andrew, daulu la mae 'i so'ela, ma daulu ka soilidi 'uri 'e ala, ");
INSERT INTO lgl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“'O ilia ga fameulu, 'i nanita 'e 'are 'e gi kae dao mae ai? Ma ta taa 'e kae fuli, 'ali fatailia talasi 'are 'e gi sui kae fuli, ma kae dao ai?” ");
INSERT INTO lgl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma Jesus ka sae 'uri 'e fadaulu, “Moulu ka liolio 'oka, ma ikoso 'ali moulu ala 'alia ta wale 'ali talai rero amoulu. ");
INSERT INTO lgl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sulia wale afula gi gera kae dao mae 'alia ratagu, ma gera kae sae 'uri 'e, ‘'I lau lo 'e Christ!’ Ma gera kae talai rero ala ioli afula gi. ");
INSERT INTO lgl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma talasi 'amu kae ronoa kwalaana gi li, failia alaana sulia kwalaana gi li, ikoso 'ali 'amu fiitala. 'Are 'urifo gi kae dao mae, wasua 'ala fafu'isinala 'are gi sui iko 'ua. ");
INSERT INTO lgl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mae falua gi gera kae kwalaa kwailiu 'i matanada, ma tatalona gi gera kae kwalaa kwailiu 'i matanada. Ma lululu kae 'asu ala lifi gi sui, failia talasi ala fiolo li kae liu. Ma 'are fo gi etanala mola rabefii na fo, malaa geli fafuta 'e fuli'ae ka welafii. ");
INSERT INTO lgl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ma moulu ka liolio 'oka. Nali ioli kae dao mae famoulu, ma gera kae sake 'amoulu fala kwate kwaikwai na famoulu. Gera kae rabusi 'amiu 'i laola luma fala foana gi li. Sulia moulu fakwalaimoki lau, gera ka kwatea moulu kae ura 'i maala wale etaeta gi failia wale 'ilitoa gi. Talasi fo, moulu kae faronoda 'ali lau. ");
INSERT INTO lgl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ma moulu ka sae sulia Faronona 'Oka fala ioli gi sui 'i laola molagali. ");
INSERT INTO lgl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma talasi gera kae dau 'amoulu, ma gera ka sake 'amoulu fala kwate kwaikwaina famoulu, ikoso 'ali 'amu malata 'abero fala ta me alaana fali ilia. Moulu kae ilia mola me alaana Alo ala God kae kwatea famoulu ala me tofuimatolaa fo li. Sulia alaana moulu kae ilida gi, 'e iko lou saenamoulu 'i talamoulu. Alaana fo gi, 'e la mae faasia Alo ala God. ");
INSERT INTO lgl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ma ioli kae kwatea walefae gera gi fala rauninada. Ma mama gi, gera kae tau lou 'urifo ala wela gera gi. Ma wela gi, gera kae olisusu ma gera kae kwatea mama failia teite gera gi fala rauninada. ");
INSERT INTO lgl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma ioli gi sui gera kae lio ta'a amiu, 'i osiala ioli lau gi 'i 'amiu. Ma ite 'e garu nasi kwalaimoki agu ka li dao ala fe atoa 'isi'isi, God kae faamauria. ");
INSERT INTO lgl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Moulu kae lesia 'Are Fa'uli'uli kae tatae mae ala lifi abu 'e totolia ikoso 'e ura ai. 'Are ta'a fo kae fa'uli'ulia Luma Abu God, ma kae taua ikoso ta wale 'ali io ai.” (Me alaana fala ioli 'e saiala toomaenali 'e 'uri 'e: 'O malinae 'oka ala malutala me 'are 'e.) “Talasi 'amu lesia 'are 'e gi kae dao mae, ioli gera io ala provins 'i Judea gi li, gera kae tafi fala gwaula fe uo gi. ");
INSERT INTO lgl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma ta ioli 'o io 'i gwaofala luma, ko tafi lo, Ko ala sifo na lou mae fala 'i laola luma 'o fala sakenala ta me 'are. ");
INSERT INTO lgl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma ioli 'o io 'i laola raku 'o li ko tafi lo, Ko ala oli na lou 'i falua fala to'omi tekwa 'o. ");
INSERT INTO lgl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma ala fe atoa fo gi, kae ta'a fala wateu dodolanaa gi, sulia 'e 'ato fada 'ali gera tafi, ma ka ta'a lou fala wateu gera too ala wela wawade gi li. ");
INSERT INTO lgl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Moulu ka foa fala God 'ali 'are 'e gi ikoso 'ali gera dao mae ala talasi ala boni li gwari li. ");
INSERT INTO lgl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Famalifiina ala fe atoa fo gi li, kae ta'a ka liufia lou famalifiina 'e ioli 'i laola molagali gi li gera saiai, fuli 'ua mae ala talasi God 'e raunailia molagali ka dao ala talasi 'e. Ma ikoso ta 'are 'urifo 'ali fuli lou 'i buri. ");
INSERT INTO lgl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma ala God ikoso fadodokoa talasi ala famalifiina li, 'e 'ato 'ali ta ioli 'ali mauri. Ma God 'e fadodokoa talasi fo fala 'okanala ioli 'e filida gi. ");
INSERT INTO lgl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ala ta ioli 'e sae 'uri 'e famoulu, ‘Lesia, Christ 'e lo,’ 'o ma ka sae 'uri 'e, ‘Lesia, lia loba,’ ikoso 'ali 'amu fakwalaimokia. ");
INSERT INTO lgl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sulia wale kotokoto gi kae dao mae, gera kae sae 'uri 'e, ‘'I lau lo Christ,’ failia wale kotokoto gi gera kae sae 'uri 'e, ‘'I lau lo profet.’ Ma gera kae taua 'are mama'ala gi 'uri 'ali talai rero ala ioli God 'e filida gi, wasua ma 'e 'ato rasua fada. ");
INSERT INTO lgl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Moulu ka liolio 'oka! Lau etae faarono 'amiu lo 'ali 'are 'e gi, fali fabasu 'amiu sui gera ka bi dao mae. ");
INSERT INTO lgl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma talasi famalifiina fo kae sui, ‘God kae bolosia lo da'afi, failia madama, ikoso 'ali daro tala. ");
INSERT INTO lgl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma God kae taua kwalikwali gi, gera kae toli faasia 'i laola raloo. Ma God kae taua 'are 'i nali gi, gera kae la rero faasia fulida.’ ");
INSERT INTO lgl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ka 'urifo bui, 'i lau Wela Wale li, laka bi dao mae. Lakae dao mae 'i laola nanatana ba'ela, failia wasinosinona ba'ela 'i fofola me dasa gi. ");
INSERT INTO lgl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma lakae kwatea eniselo lau gi 'i laola molagali sui, 'ali gera logosia mae ioli God 'e filida gi.” ");
INSERT INTO lgl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mola, Jesus ka sae 'uri 'e 'alia tarifulaana, “Moulu ka malata ga sulia 'ai figi gi. Talasi 'amu lesia 'abala 'e ulua, 'amu ka sailoai talasi fala 'ago'agonali 'e dao garani lo. ");
INSERT INTO lgl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","'E 'urifo lou, talasi 'amu lesia famalifiina fo gi kae dao mae, 'amu ka sailoai fulinala me 'are 'e 'e garani lo. ");
INSERT INTO lgl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Me 'are kwalaimoki 'e la kae ilia famoulu, 'are 'e gi kae fuli ala talasi ului wale 'e 'e mauri 'ua ai. ");
INSERT INTO lgl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Falua 'i nali failia molagali kae sui, wasua ma saenagu 'ato 'ali 'e sui. ");
INSERT INTO lgl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Iko ta ioli 'ali 'e saiala talasi kwalaimoki lakae oli mae ai. Eniselo gi 'i nali wasua iko 'ali gera sai lou ai, ma 'i lau Wela wasua, iko 'ali lau sai lou ai. God Mama talifilia mola 'e saiai. ");
INSERT INTO lgl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Moulu ka liolio 'oka, ma moulu ka rerei, sulia iko 'ali 'amu sai ala talasi. ");
INSERT INTO lgl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Olinagu mae kae malaa na wale 'e la ala falua tatau, ma ka alua luma lia 'i limala ioli galona lia gi. 'E kwatea galona tootoo gi fada. Ma ka ilia fala wale 'e lio folosia maala luma 'ali ka liolio 'oka masia daonala. ");
INSERT INTO lgl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'Are la fo, 'amu ka liolio 'oka, sulia iko 'ali 'amu saiala talasi lakae dao mae ai, malaa lou wale ba'ela ala luma li. Mala kae dao mae raurafi, 'o ma ala didila boni, 'o ma 'ofaedani, 'o ma rafule malumalu talasi da'afi kae bi tatae ai. ");
INSERT INTO lgl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma ala 'e dao nainali mae, kae ta'a rasua lo famoulu ala 'e dao tonamoulu talasi moulu mo'osu. ");
INSERT INTO lgl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma na me 'are lakae ilia lou famoulu, me 'are ba lau ilia lo fala ioli gi sui 'e 'uri 'e: Moulu ka liolio 'oka!” ");
INSERT INTO lgl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rua fe atoa tatabula ala Fanana ala Daofaeliuna li ma fanana fo Jiu gi gera saiala aninala berete la iko ta ist 'i laola. Ma fata abu ba'ela gi, failia wale falalau ala taki gi li, gera ka logo raefuli ma gera ka toria me 'are fala dau agwana ala ma rauninala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Gera sae 'uri 'e, “Ikoso golu taua ala talasi ala Fanana li, taufasia ioli gi gera bi kwalaa fae golu.” ");
INSERT INTO lgl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ala talasi Jesus 'e io 'i laola mae falua 'i Betani li, ka fana 'i laola luma Simon wale la kuu 'e tautaua 'i lao. Ma te geli ka la mae 'i so'ela failia fe botole waiwai maelala 'e nana rasua, ma ka fonu 'alia waiwai 'e si'ina fofo 'oka, ma maelala ka rae rasua. 'E tafalia maala botole waiwai fo, ma ka nikia lo waiwai si'ina 'oka fo fafia gwaula Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma nali wale gera io 'i lififo, gera ka ogata'a, ma gera ka sae kwailiu 'ada 'uri 'e 'i safitada, “Iko 'ali 'e totolia 'ali 'e fafuta'a te waiwai si'ina 'oka fo! ");
INSERT INTO lgl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Totolia ka foli mola 'alia fala tali bata afula, 'ali 'e sakea bata fo gi, ma ka kwatea fala ioli dalaa gi.” Ma daulu ka balufia geli fo. ");
INSERT INTO lgl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus 'e ronoa, ma ka sae 'uri 'e, “Moulu alua ka io 'ala! Moulu ala sae fafuta'a nala lou. 'I lia 'e taua galona 'oka rasua fagu. ");
INSERT INTO lgl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ioli dalaa gi gera kae io talau mola 'ada fae 'amiu. Tenae talasi mola 'ala 'amu sai ala rana nada. Ma 'i lau ikoso lau io tekwa mola fae 'amoulu. ");
INSERT INTO lgl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","'E taua me 'are 'e 'oka fala tauanai. 'E nikia te waiwai si'ina fofo 'oka 'e 'i rabegu tatabula ala maenagu fali rerei 'alia fala alominagu. ");
INSERT INTO lgl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Me 'are kwalaimoki lakae ilia famoulu, ala lifi gi sui 'i laola molagali gera kae alaa sulia Faronona 'Oka 'e, gera kae alaa lou sulia me 'are 'oka 'e 'e taua agu fala malatafaeburina tonai.” ");
INSERT INTO lgl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sui Judas Iskariot, na wale ala akwala wala rua waleli galona ba lia gi, ka la 'i soela fata abu ba'ela gi, ka faarono 'uri 'e adaulu, “Lakae kwatea Jesus famoulu.” ");
INSERT INTO lgl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma gera ka babalafe rasua sulia me 'are fo 'e ilia 'urifo ai, ma gera ka alafuu 'ali gera kwate bata fala. Ma Judas ka fuli'ae lo fala lio na 'afia ta me talasi 'oka fala kwatenala Jesus fadaulu. ");
INSERT INTO lgl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ala etala fe atoa ala Fanana ala berete fo iko ta ist 'i laola li, fe atoa fala rauninala keme sipsip bi ba'ela fala Fanana ala Daofae Liuna li. Talasi fo, waleli galona Jesus gi ka soilidi 'uri 'e ala, “'I fe 'o oga 'ali meulu reirei 'alia Fanana ala Daofae Liu na li famu ai?” ");
INSERT INTO lgl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma Jesus ka sae 'uri 'e fala na rua wale adaulu “Mora la 'i Jerusalem, ma te wale kae sake kwai, kae manotafa fali daotonamoroa. Mora ka donaa ");
INSERT INTO lgl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","fala te luma 'i lififo kae ruu 'i laola. Mora ka soilidi 'uri 'e ala wale fo 'e too ala luma laa li, ‘Waleli Faalalauna 'e ilia mae luma 'i fe lo kae 'ania Fanana ala Daofae Liu na li failia waleli galona lia gi ai?’ ");
INSERT INTO lgl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma 'i lia kae fatailia te tobi ba'ela 'e io 'i nali. 'Are gi sui gera kwaimamali lo 'alida 'i lifi fo. Ma mora ka reirei 'alia 'are gi sui fagaulu 'i lifi fo.” ");
INSERT INTO lgl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Rua waleli galona fo gi daro la, ma daro ka dao lo 'i Jerusalem, ma daro ka lesia 'are gi sui 'e malaa lia ba Jesus 'e ilia lo fadaroa. Ma daro ka rerei lo 'alia 'are fala Fanana ala Daofae Liu na li gi li sui. ");
INSERT INTO lgl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","'E raurafi, Jesus ka dao mae failia akwala wala rua waleli galona lia gi. ");
INSERT INTO lgl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma talasi daulu kae fana, Jesus ka sae 'uri 'e, “Me 'are kwalaimoki lakae ilia famoulu, te wale amoulu kae kwate lau fala malimae lau gi. Wale la kae fana mola 'ala faelau ala me tofui talasi 'e.” ");
INSERT INTO lgl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma waleli galona lia gi daulu ka fuli'ae lo ogata'ana, ma daulu ka alaa li teke ioli 'uri 'e fala Jesus, “Ikoso lau kwate 'o fala malimae 'o gi!” ");
INSERT INTO lgl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma Jesus ka olisi 'uri 'e adaulu, “'I lia na wale mola lou amoulu ala akwala wala rua waleli galona 'e lau gi, ma kae alua tofui berete lia 'i laola teu faelau. ");
INSERT INTO lgl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma 'i lau, Wela Wale li, lakae mae malaa lia ba Geregerena Abu 'e sae lo mae suli lau. Wasua 'ala, kwaimalatai rasua fala wale 'e kae kwate lau fala malimae lau gi li! 'E 'oka fala wale fo tara ikoso 'ali 'e futa mola.” ");
INSERT INTO lgl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma talasi daulu kae fana lo, Jesus 'e sakea me berete, ma ka batafea God, sui ka liia. 'E kwatea fala waleli galona lia gi, ka sae 'uri 'e, “Sakea ma moulu ka 'ania. Rabegu lo 'e.” ");
INSERT INTO lgl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sui ka sakea teui waeni, ma ka batafea God, sui ka kwatea fadaulu. Ma 'i daulu sui daulu ka gou ai. ");
INSERT INTO lgl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma Jesus ka sae 'uri 'e, “Lia 'e lo 'abugu lia 'e afe fala ioli sui fala fanasinala fekena fa'alu God. ");
INSERT INTO lgl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'Are kwalaimoki lakae ilia famoulu, ikoso lau goufia lo waen 'e lala ka dao ala fe atoa lakae goufia lou waen 'e talasi God kae 'ilitoa fafia ioli gi sui.” ");
INSERT INTO lgl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","'I burila daulu nulia fe nuu, daulu ka la fala uo 'i Olif. ");
INSERT INTO lgl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesus ka sae 'uri 'e fadaulu, “'Amoulu sui moulu kae tafi faasi lau. Sulia Geregerena Abu 'e sae 'uri 'e, ‘God kae raunia wale 'e 'e lio sulia sipsip gi li, ma sipsip gi sui gera ka tagala.’ ");
INSERT INTO lgl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Ka 'urifo wasua 'ala, 'i burila tataenagu fala maurina, lakae eta lo 'i lao amoulu fala 'i Galili.” ");
INSERT INTO lgl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma Peter ka olisi 'uri 'e ala, “'E 'ato rasua 'ali lau la fa'asi 'o, wasua ioli gi sui gera ka la 'ada fa'asi 'o!” ");
INSERT INTO lgl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma Jesus ka sae 'uri 'e fala Peter, “Lakae ilia famu. Sui ma kakaraikua kae ani rua me talasi 'i laola fe boni 'e tara'ela, koe tofe ta'a 'uri iko 'ali 'o sai agu.” ");
INSERT INTO lgl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma Peter ka olisi fiifii 'uri 'e ala, “Wasua laka mae fae 'o, 'e 'ato mola 'ali lau tofe 'uri lau rari 'o!” Ma waleli galona fo gi sui gera ilia lou me 'are fo. ");
INSERT INTO lgl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sui Jesus failia waleli galona lia gi, daulu ka la fala te lifi gera soia 'alia 'i Getsemani. Talasi daulu dao lo, Jesus ka sae 'uri 'e fadaulu, “Moulu io 'amoulu 'i lifi'e talasi lakae foa 'agua.” ");
INSERT INTO lgl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sui ka talaia Peter, James, ma John failia. Ma ka kwaimalatai rasua ma ka liodila. ");
INSERT INTO lgl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma ka sae 'uri 'e fadaulu, “Malatagu 'e boeboetaa rasua, ma ka totolia mola lo rauninagu. Moulu io 'i lifi'e, moulu ka ada, ma moulu ka dai faelau.” ");
INSERT INTO lgl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma Jesus ka 'idu wawade ko, ma ka boururu 'i wado. Ma ka foa 'uri 'ali ala ka talawarau mola 'ala, ikoso ke liu 'i laola talasi ala famalifiina li. ");
INSERT INTO lgl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma ka foa 'uri 'e, “Mama, 'are gi sui 'e talawarau famu. 'O sakea famalifiina 'e faasi lau. Wasua, 'e iko lou kwaiogalina lau, ma sulia kwaiogalina 'o 'ala.” ");
INSERT INTO lgl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sui Jesus ka oli mae 'i soela olu waleli galona ba lia gi, ma daulu mo'osu mola 'adaulu. Ma ka sae 'uri 'e fala Peter, “Simon 'utaa 'e ko mo'osu? Totolia ko ada faelau sulia ta ke tofui matolaa wawade wasua.” ");
INSERT INTO lgl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma ka sae 'uri 'e fadaulu, “Moulu ada, moulu ka liolio 'alia foana taufasia ilitoona ka bi liufi 'amoulu. Sulia manomoulu 'e oga taunala 'are 'oka gi, wasua ma rabemoulu 'e watoutou rasua.” ");
INSERT INTO lgl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ma Jesus ka la lou faasi daulu, ma ka foa, ma ka ilia lou me alaana ba gi mola 'ali. ");
INSERT INTO lgl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sui ka oli lou mae 'i soedaulu, ma ka dao soedaulu daulu mo'osu lou, sulia maa daulu 'e momosula rasua. Ma iko 'ali daulu sai lo ala ta me 'are 'ali daulu ilia fala. ");
INSERT INTO lgl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Olula me talasi 'e oli lou mae ai, ka sae 'uri 'e fadaulu, “'Uri moulu kae momo'osu 'ua 'e? 'E 'oka lo! Lesia gera kae kwate lau lo, Wela Wale li, fala limala wale ta'a gi. Talasi 'e dao lo! ");
INSERT INTO lgl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tatae golu la lo. Lesia wale ba kae kwate lau fala malimae lau gi li 'e dao lo mae!” ");
INSERT INTO lgl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Talasi Jesus kae alaa 'ua, Judas, na wale ala akwala wala rua waleli galona ba lia gi, ka dao lo mae. Te logona ba'ela 'e la mae failia faasia fata abu ba'ela gi, failia wale etaeta gi, ma wale falalau ala taki gi li. Ma gera ka sakea mae 'au li ofona gi failia subi gi. ");
INSERT INTO lgl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma Judas, wale fo kae kwate Jesus fadaulu, 'e kwatea lo totofo 'uri 'e fala logona fo, “Wale lakae loto 'i babalila, wale la lo moulu oga. Moulu ka daua, ma moulu ka talaia lo.” ");
INSERT INTO lgl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sui, Judas ka dao, ka la lo ko 'i so'ela Jesus, ma ka sae 'uri 'e, “Waleli Faalalauna!” Mola, ka loto lo 'i babalila. ");
INSERT INTO lgl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma gera ka daua lo Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ala me talasi fo, wale 'e io garani, 'e lafua me 'au fala ofonali, ma ka tofu mousia aninala waleli galona fata abu 'ilitoa li. ");
INSERT INTO lgl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma Jesus ka soilidi 'uri 'e adaulu, “Moulu fia 'uri 'i lau wale belibeli 'e? Lia 'e moulu ka la mae failia 'au li ofona gi, failia subi gi fala daunagu? ");
INSERT INTO lgl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","'E Tekwa lo mae, lau faalalau 'amiu 'i laola Luma Abu God, wasua ma iko 'ali 'amu dau lau mola. Ma me 'are 'e moulu taua, 'e fakwalaimokia lo Geregerena Abu.” ");
INSERT INTO lgl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","'Urifo mola, waleli galona lia gi sui daulu ka tafisia, ma daulu ka tafi lo 'adaulu. ");
INSERT INTO lgl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma te ulufa'alu 'e toro mola 'alia me kabilato li, 'e aliburia Jesus. Ala talasi gera daua ulufa'alu fo li ");
INSERT INTO lgl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","me kabilato fo lia ka toli lo faasia, ma ka tafi dadala lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","'Urifo, gera ka talaia Jesus fala luma fata abu 'ilitoa li. Ma fata abu ba'ela gi, failia wale etaeta gi, failia wale falalau ala taki gi li, gera logo sui 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma Peter 'e aliburi tatau ko 'ala, ma ka ruu lou 'i laola labu ala luma fata abu 'ilitoa li. 'E io 'ala 'i lififo failia ioli liofolo gi, ma ka rara 'ala 'i rabela dunaa. ");
INSERT INTO lgl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mola, fata abu ba'ela gi, failia gwaurunae wale 'ilitoa fala Jiu gi li, gera tau fala darinala ta me 'are ta'a fala suafafinala Jesus 'alia 'uri 'ali gera raunia, wasua ma iko 'ali gera daria mola ta me 'are 'urifo fali suua 'alia. ");
INSERT INTO lgl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ioli afula gi gera koto fafia Jesus, wasua ma alaanada iko 'ali 'e alua ta teke me malata. ");
INSERT INTO lgl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma nali wale gera ka tatae lou, ma gera ka koto 'uri 'e fafia Jesus, ");
INSERT INTO lgl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Meulu ronoa 'uri 'o ilia, ‘Lakae osia Luma Abu 'e God ioli gi gera raunailia, ma 'i laola olu fe atoa gi, lakae raunailia lou ta Luma Abu iko lou ioli gi gera raunailia.’” ");
INSERT INTO lgl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma 'i gera wasua, alaana gera gi iko 'ali alu teke malata lou. ");
INSERT INTO lgl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma fata abu 'ilitoa ka ura 'i maada, ma ka soilidi 'uri 'e ala Jesus, “'Uri'e ma, iko 'ali 'o too mola ala ta me alaana fala olisinala alaana 'e wale 'e gi gera suafafi 'o 'alida gi?” ");
INSERT INTO lgl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Wasua Jesus 'e lobo mola 'ala, ma iko 'ali 'e olisia mola. Ma fata abu 'ilitoa ka soilidi lou 'uri 'e ala, “'Uri 'e ma, 'I'o lo Christ, Wela Wale God?” ");
INSERT INTO lgl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma Jesus ka olisi 'uri 'e ala, “'Eo, 'i lau lo 'e. Moulu kae leesi lau, Wela Wale li, lau gwauru 'i aba aolo ala God nanata. Lakae 'ilitoa failia, ma lakae oli mae faasia 'i nali fofola dasa gi.” ");
INSERT INTO lgl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mola te fata abu 'ilitoa fo ka gagasia lo to'omi tekwa lia 'i talala ka fatailia lo ogata'anala ma ka sae 'uri 'e, “Iko 'ali golu oga lou ta ioli 'ali fakwalaimokia! ");
INSERT INTO lgl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Moulu talae ronoa lo 'e fafuradani lia failia God! Moulu malata 'utaa ala?” Ma 'i gera sui gera ilia 'e rero lo, ma 'e totolia gera ka raunia lo. ");
INSERT INTO lgl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma nali wale ada gera ka fuli'ae fala nisufinala Jesus, ma gera ka firi bolosi maala, ma gera ka gumulia. Ma gera ka sae 'uri 'e, “'O ilia ga ite 'e gumuli 'o?” Ioli liofolo gi gera talaia, ma gera ka rabusi kwailiu ala. ");
INSERT INTO lgl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter 'e gwauru 'ua mola 'ala 'i laola labu, talasi gera kae kwate kwaikwaina fala Jesus. Te geli ulao 'e galo ala fata abu 'ilitoa ka dao. ");
INSERT INTO lgl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma talasi 'e lesia Peter 'e rara 'ala, ka lio tootoo fala, ma ka sae 'uri 'e, “'I'o lou na wale failia Jesus, wale ba 'e la mae faasia mae falua 'i Nasareti.” ");
INSERT INTO lgl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma Peter ka tofe 'uri 'e, “Lau raria, iko 'ali lau saiala me 'are 'e koe sae sulia.” Ma ka latafa ko 'i maluma faasia lifi fo. Ma ala me talasi fo, kakaraikua ka ani lo. ");
INSERT INTO lgl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma geli ulao ba ka lesia lou 'i lififo, ma ka sae 'uri 'e fala ioli gera ura galia lififo li gi li, “'I lia na wale lou adaulu 'e!” ");
INSERT INTO lgl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma Peter ka tofe lou 'alia. Iko 'ali tekwa mola lou 'i burila, ioli gera ura garania gi gera ka sae lou 'uri 'e fala Peter, “'E 'ato rasua 'ali 'o tofe 'uri 'i'o iko ta wale adaulu, sulia 'i'o lou 'o la mae faasia 'i Galili.” ");
INSERT INTO lgl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sui Peter ka alafuu 'uri 'e, “Alua God kae kwatea kwaikwaina fagu, ala iko 'ali lau sae kwalaimoki! Iko 'ali lau saiala wale 'e moulu kae sae sulia!” ");
INSERT INTO lgl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Me talasi fo mola, kakaraikua ka ani ruala talasi lo. Ma Peter ka malata tonala me alaana ba 'uri 'e Jesus 'e ilia fala, “Sui ma kakaraikua ka bi ani rua talasi, oolu me talasi gi koe ilia iko 'ali 'o sai agu.” Ma talasi Peter 'e malata tonala me 'are fo li, ka ani ka 'ilu'ilu rasua lo. ");
INSERT INTO lgl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","'Ofaedani 'ua, gwaurunae wale 'ilitoa fala loko malatana 'ala Jiu gi li gera logo nainali. Fata abu ba'ela gi, failia wale etaeta gi, failia wale falalau ala taki Moses gi li, 'i gera fo 'i laola logonae wale fo. Gera logo fali loko malata fala ta me 'are gera kae taua ala Jesus. Sui gera ka firia Jesus 'alia seni, ma gera ka talaia ko fala kwatenala fala Paelat, wale ba'ela faasia 'i Rom. ");
INSERT INTO lgl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma Paelat ka soilidi 'uri 'e ala, “'I'o walelitalona Jiu gi li 'e?” Ma Jesus ka olisi 'uri 'e ala, “Lia laa 'o ilia lo.” ");
INSERT INTO lgl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ma fata abu ba'ela gi gera ka sua fafia 'alia 'are rero afula gi. ");
INSERT INTO lgl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma Paelat ka soilidi lou 'uri 'e ala, “'O ronoa ga 'are afula 'e gera sua fafi 'o lo 'alida gi! 'Uri ikoso olisida lo?” ");
INSERT INTO lgl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Wasua ma Jesus iko 'ali 'e ilia mola ta me alaana, ma Paelat ka 'afero rasua. ");
INSERT INTO lgl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ala Fanana ala Daofae Liu na li, Paelat 'e saiala lugasinala ta teke wale Jiu gi gera sugaa fai faasia raraa. ");
INSERT INTO lgl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma ala talasi fo, te wale ratala Barabas 'e io lou 'i laola raraa, sulia 'i lia lou na wale ala wale ta'a fo gera rau ioli ala kwalaana failia wale 'i Rom gi li. ");
INSERT INTO lgl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sui afulana ka logo mae, gera ka sugaa Paelat 'ali 'e lugasia ta teke wale faasia raraa malaa falafala kae 'idufae tautaua lo mae ala talasi 'urifo gi li. ");
INSERT INTO lgl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma Paelat ka soilidi 'uri 'e ada, “'Amu oga 'ali lau lugasia walelitalona ba Jiu gi li famoulu?” ");
INSERT INTO lgl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sulia Paelat 'e sai mola 'ala ala lia fo fata abu ba'ela gi gera kwatea mae Jesus 'i so'ela, fofola mola kwaifiina gera fala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Wasua ma, fata abu ba'ela gi gera saefia afulana fo, 'ali gera sugaa Paelat fala lugasinala Barabas fada. ");
INSERT INTO lgl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma Paelat ka soilidi lou 'uri 'e ala afulana fo, “'Urilali ma ta ta 'e lakae taua ala wale 'e 'amu soia 'alia walelitalona Jiu gi li?” ");
INSERT INTO lgl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma gera ka akwa 'uri 'e, “'O fotofafia ala 'ai rara folo!” ");
INSERT INTO lgl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma Paelat ka soilidi 'uri 'e, “Ta rero 'e taua?” Ma gera ka bi akwa ba'ela rasua lou 'uri 'e, “Fotofafia ala 'ai rara folo!” ");
INSERT INTO lgl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma Paelat ka lugasia Barabas fada, sulia 'e oga 'ali faatolia malatala afulana fo. Sui, ka kwatea Jesus 'ali gera rabusia, ma ka kwatea fala fotoinala ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Waleli ofona gi, gera talaia ko Jesus fala 'i laola labu ala luma ba'ela Paelat, ma gera ka ralofia mae waleli ofona gi sui. ");
INSERT INTO lgl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma gera ka faaruufia 'alia te to'omi marimarikioaa tekwa, ma gera ka alua te 'eregwau ala kwalo karakaraa li 'i gwaula malaa na walelitalona. ");
INSERT INTO lgl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sui gera ka faaora 'uri 'e 'alia faba'elanala, “Walelitalona 'e Jiu gi li, 'o mauri tekwa 'amua!” ");
INSERT INTO lgl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sui gera ka rabu 'i gwaula 'alia tofui 'ai, ma gera ka nisufia, ma gera ka boururu 'i maala, faaorana 'alia 'ilitoanala. ");
INSERT INTO lgl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","'I burila faaorana fo 'alia 'e sui lo, gera ka kalasua to'omi marimarikioaa tekwa lia faasia. Sui gera ka faaruufia lou 'alia toro lia 'i talala. Sui mola gera ka talaia lo fala fotoinala ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma talasi gera lo sulia tala li, gera ka dao tonala te wale la ratala Simon, mama Aleksanda failia Rufus. 'I lia wale faasia falua 'i Saeren. 'E la mae fala 'i Jerusalem faasia na lifi atale. Ma Waleli ofona gi, gera ka suunailia 'ali 'e sakea 'ai rara folo fo Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ma gera ka talaia ko Jesus fala te lifi gera soia 'alia 'i Golgota. Ma fadanai 'e 'uri 'e, “Talii gwae ioli.” ");
INSERT INTO lgl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Gera kwatea waen gera dolaa failia 'are gera soia 'alia “Mira,” te sului 'are fala fagwarinala fiina li, wasua ma Jesus iko 'ali goufia mola. ");
INSERT INTO lgl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma gera ka fotofafia ala 'ai rara folo. Ma gera ka tolini kwailiu ala toro lia gi 'i safitada. Gera ka none 'alia daisi 'ali gera daria ite adaulu kae sakea ta me toro ala toro lia gi. ");
INSERT INTO lgl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ala sikwala me tofuimatolaa raafule (9 o' clock AM), gera ka foto lo fafia ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma gera ka fotoia me saena gera suafafia 'alia 'i gwaula 'ai rara folo fo. Me saena laa 'e 'uri 'e, “Walelitalona Jiu gi li.” ");
INSERT INTO lgl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ma gera ka fotofafia lou rua wale belibeli gi ala rua 'ai rara folo gi failia Jesus. Na wale 'i gula aolo ala, ma na wale 'i gula mauli ala. ");
INSERT INTO lgl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma ioli gera liu totolala lifi fo li, gera 'asua gwauda, ma gera ka abasisaena sulia Jesus, ma gera ka sae lou 'uri 'e, “'O ilia koe osia Luma Abu God, ma koe raunailia mola sulia olu fe atoa gi li! ");
INSERT INTO lgl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","'O faamauri 'o 'i talamu! Sifo mae faasia 'ai rara folo laa!” ");
INSERT INTO lgl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma fata abu ba'ela gi, failia wale falalau ala taki gi li, gera ilia lou me saena fo. Ma gera ka sae faaora 'alia Jesus, ma gera ka sae kwailiu 'ada 'uri 'e 'i safitada, “'E faamauria ioli atale gi, ma 'e 'ato 'ali faamauri 'i lia talala! ");
INSERT INTO lgl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Golu lio ga fala 'ali 'e sifo mae faasia 'ai rara folo ala 'i lia lo Christ, walelitalona Jiu gi li 'ali golu bi fakwalaimokia!” Ma rua wale fo gera fotoi daroa ala 'ai rara folo gi failia Jesus wasua daro soi tefulailia lou Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Fuli ala matoula atoa (12'o clock), 'afutala provins fo sui 'e rodo, lala ka dao ala abali raurafi ala olula tofuimatolaa (3 o' clock PM). ");
INSERT INTO lgl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma abali raurafi ala olula tofuimatolaa (3 o'clock PM), Jesus ka akwa ba'ela 'uri 'e, “Eloi, Eloi, lama sabaktani?” malutala me saena fo 'e 'uri 'e “God lau, God lau, 'utaa ko buri ma ko lugasi lau lo 'amua?” ");
INSERT INTO lgl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma nali wale gera io 'i lififo, gera ka ronoa, ma gera ka fia 'uri 'e soia Elaeja. ");
INSERT INTO lgl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma na wale adaulu ka lalao ko, ma ka fawawalosia te anina 'i laola waen 'afaa, ma ka alua 'i maala te mae 'ai, ma ka kwatea ko 'i maala nidula Jesus, 'uri 'ali 'e goufia, ma ka sae 'uri 'e, “Golu lio ga, mala Elaeja kae la mae 'ali 'e lafua mae 'i fua faasia 'ai rara folo!” ");
INSERT INTO lgl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mola Jesus ka akwa ba'ela, sui ka mae lo. ");
INSERT INTO lgl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma ruu ba'ela 'e bolosia lifi abu 'i laola Luma Abu God li ka gaga lo, fuli 'i gwaula ka li dao 'i 'aela. ");
INSERT INTO lgl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma ioli ba'ela ala waleli ofona gi li, lia 'e ura 'i 'aela 'ai rara folo ala me talasi fo li, 'e ronoa riinala, ma ka lesia maenala, ma ka sae 'uri 'e, “'E kwalaimoki rasua, wale 'e Wela God lo!” ");
INSERT INTO lgl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma nali geli gera io lou 'i lififo, gera lio tatau ko. Mary geli 'i Magdala, ma Mary teite James wela 'i burila Joses, ma Salome. ");
INSERT INTO lgl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","'I daulu lou daulu dona buria Jesus ala talasi 'e io 'ua 'i Galili, ma daulu ka kwairanai ala. 'I lififo lou geli afula gera la mae failia fala 'i Jerusalem gi. ");
INSERT INTO lgl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","'E raurafi, Josef, wale faasia falua 'i Arimetea, 'e la mae. 'I lia wale 'ilitoa lou ala gwaurunae wale 'ilitoa fala Jiu gi li. Alae wale daulu kae faifaimaasi fali lesia talasi God kae 'ilitoa fafia ioli lia gi li. Lia 'e too oga, ma ka la 'i so'ela Paelat. Ma ka sugaa fala rabela Jesus, sulia fe atoa fo atoa ala rerei na masia Sabat, atoa ala mamalona li. ");
INSERT INTO lgl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma Paelat ka 'afero talasi 'e ronoa Jesus 'e mae lo. Ma ka soia wale ba'ela ala waleli ofona gi li, ma ka soilidia fala maenala Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Talasi Paelat 'e ronoa faasia wale ba'ela fo lia Jesus 'e mae lo li, Paelat ka bi ala 'alia Josef 'ali sakea rabela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josef ka folia te ruu kaka'a, ma ka fasifoa rabela Jesus, ma ka 'afua 'alia ruu fo, ma ka alua 'i laola bao la gera 'elia 'i laola te fau. Sui ka gwelusia te abae fau ba'ela, ma ka bolosia lo maala bao fo. ");
INSERT INTO lgl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma Mary geli 'i Magdala, failia Mary teite Joses, daro lesia lifi fo gera alua Jesus ai. ");
INSERT INTO lgl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","'I burila Sabati, burila fe atoa ala mamalona li 'e sui lo, Mary geli 'i Magdala, ma Mary teite James, failia Salome, daulu folia mae 'are si'ina fofo 'oka gi fala waiwaianala rabela Jesus. ");
INSERT INTO lgl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","'Ofaedani 'ua ala Sade, talasi da'afi kae bi tatae, daulu ka la mae fala bao. ");
INSERT INTO lgl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Talasi daulu kae laoko, daulu ka soilidi kwailiu 'adaulu 'uri'e 'i matanadaulu, “Ite kae gefusia te abae fau ba faasia maala gilu?” Sulia fau fo 'e ba'ela rasua. ");
INSERT INTO lgl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sui, talasi daulu li dao lo, daulu ka lesia te abae fau ba 'e 'idu lo. ");
INSERT INTO lgl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ma talasi daulu ruu ko 'i laola bao li, daulu ka lesia te wale fa'alu 'e rufia to'omi kaka'a, ma ka gwauru 'ala gula aolo 'i laola bao fo. Ma daulu ka mau rasua. ");
INSERT INTO lgl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma wale fo ka sae 'uri 'e, “Moulu ala mau na. Lau saiai moulu kae lio 'afia Jesus tela, wale ba 'i Nasaret gera raunia ala 'ai rara folo li. 'E iko 'ali io lo 'i lifi'e. Sulia 'e tatae lo faasia maena! Moulu lesia lifi ba gera alua rabela ai loko! ");
INSERT INTO lgl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Moulu la 'i so'ela waleli galona lia gi failia Peter, ma moulu ka faarono 'uri 'e adaulu, ‘Jesus 'e eta lo 'i lao maasi 'amoulu 'i Galili, moulu li lesia lo 'i lifi fo, mala lia ba 'e ilia lo famoulu.’” ");
INSERT INTO lgl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma alae geli fo daulu ka latafa, daulu ka tafi lo faasia bao fo, sulia daulu mau, ma daulu ka lebelebe rasua. 'E iko 'ali daulu alaa lo 'alia tame 'are fala ta ioli, sulia daulu mau rasua. ");
INSERT INTO lgl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","'Ofaedani 'ua ala Sade, Jesus 'e maurifa'alu lou, ma ka fatae fala Mary geli 'i Magdala, te geli ba Jesus 'e balia fiu aloe 'are ta'a gi faasia. ");
INSERT INTO lgl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma Mary ka la 'i soela waleli galona Jesus gi. Gera kwaimalatai, ma gera ka aani rasua. Ma Mary ka farono daulu. ");
INSERT INTO lgl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","'E iko 'ali daulu fakwalaimokia mola Mary talasi daulu ronoa liafo Jesus 'e maurifa'alu, ma Mary ka lesia lo. ");
INSERT INTO lgl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","'I burila lou, Jesus ka fatae fala na rua waleli galona lia, talasi daro kae liu sulia tala 'e la faasia 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma daro ka oli mae, daro ka faronoa lou nali waleli galona daulu, ma iko 'ali daulu ke fakwalaimokia mola. ");
INSERT INTO lgl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma 'i buri 'ala lo, Jesus ka fatae fala akwala ma na teke wale ala waleli galona lia gi, talasi daulu kae fana 'adaulu. Ma ka balufi daulu sulia iko 'ali daulu fakwalaimoki, ma malatadaulu ka nasi rasua faasia fakwalaimoki nala wale gera lesia lo 'i burila tataenala faasia maenaa li. ");
INSERT INTO lgl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma ka sae 'uri 'e fadaulu, “Moulu la 'i laola molagali sui, ma moulu ka faarono 'alia Faronona 'Oka fala ioli gi sui. ");
INSERT INTO lgl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma ioli 'e fakwalaimokia Faronona 'Oka li, ma ka sisiu abu, 'i lia kae mauri firi failia God. Ma ioli 'e iko 'ali 'e fakwalaimoki, God kae kwaia. ");
INSERT INTO lgl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ioli gera fakwalaimoki gi, gera kae too ala nanatana fala taunala 'are mama'ala 'uri 'e gi: Gera kae balia aloe 'are ta'a gi 'alia ratagu, ma gera kae sae 'alia saena iko 'ali gera sai ali gi. ");
INSERT INTO lgl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma ala gera ka doia wasua ta fe wa 'o ma gera ka goufia wasua ta kwai li maena 'ato 'ali ke fafuta'ada mola. Ma ala gera alu lima 'i fofola ta ioli 'e matai, ioli la kae 'akwaa lo.” ");
INSERT INTO lgl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","'I burila 'e alaa fadaulu, Aofia Jesus ka oli lo fala 'i nali, ma ka gwauru 'i aba aolo ala God ka 'ilitoa failia. ");
INSERT INTO lgl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma waleli galona lia gi gera ka la lo, ma gera ka farono 'alia saenala God ala lifi gi sui. Ma Aofia ka galo failida, ma ka kwatea nanatana fada fala taunala 'are mama'ala gi, 'ali daulu fatailia falalauna daulu 'e lalama. ");
INSERT INTO lgl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiofilas, ioli afula gi gera geregere sulia 'are Jesus 'e fulida 'i safitamami gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Gera gerea 'are 'ami ronoa faasia wale gera talae lesia 'are fo gi li. Ma wale gera talae lesia fulinala 'are fo gi li, gera ka sae lou sulia Faronona 'Oka fo famami. ");
INSERT INTO lgl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Lia 'e wale 'ilitoa Tiofilas, lau malataia 'e 'oka 'ali lau geregere sulia 'are 'e gi famu, suli lau sai 'oka ala 'are 'e gi sui, fuli lo mae ala etanala 'u'ulu 'e. ");
INSERT INTO lgl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma laka geregere sulia 'are 'e gi 'ali 'o saiala lalamanala 'are 'e gera faalalau 'alida famu gi. ");
INSERT INTO lgl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ala talasi Herod 'e 'ilitoa fafia provins 'i Judea, te fata abu la ratala Sekaraea 'e io lou ala talasi fo, ma 'i lia na wale ala alae fata abu fala foana faasia 'i Abaeja. Wateu lia Elisabet 'e laa lou mae faasia kwalofa fata abu gera fuli mae ala Aaron gi, walefae Moses. ");
INSERT INTO lgl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Abulo nadaroa sui 'e rada, ma ka aolo 'i maala God, suli daro rono 'oka rasua sulia taki God gi failia kwaikaena lia gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wasua ma me 'are mola, iko 'ali daro too ala ta wela, sulia Elisabet 'e 'amara. Ma 'i lia failia arai lia Sekaraea wasua, daro waro lo lou. ");
INSERT INTO lgl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Te atoa Sekaraea 'e laa 'i laola Luma Abu God, 'ali 'e li taua galona fata abu gi li, sulia talasi fo talasi alae fata abu daulu Sekaraea fala galo na 'i laola Luma Abu God li. ");
INSERT INTO lgl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Falafala ala fata abu na li fala filinala ta fata abu fala 'agofinala 'ai si'ina 'oka, 'e 'uri 'e: Gera ka 'ui 'alia 'are malaa daisi fala filinala ite kae taua galona fata abu fala 'agofinala 'ai si'ina 'oka 'i fofola 'erefau 'i laola Luma Abu God. Ala talasi fo, gera ka filia Sekaraea, ma 'i lia ka ruu 'i laola Luma Abu, ");
INSERT INTO lgl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ma ioli afula gera io 'i maluma gi, gera ka foa ala talasi fo kae 'agofia 'ai si'ina 'oka fo li ai. ");
INSERT INTO lgl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma te eniselo God ka fatae fala, 'e ura 'i gula aolo ala 'erefau fo. ");
INSERT INTO lgl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Talasi Sekaraea 'e lesia eniselo fo li, ka maola ma ka mau rasua. ");
INSERT INTO lgl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sui, eniselo fo ka sae 'uri 'e fala, “Sekaraea, 'o alua mau na! God 'e ronoa linela foanamu, ma wateu 'o Elisabet kae faafutaa te wela wale. Ma koe fafurataa 'alia John. ");
INSERT INTO lgl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Koe babalafe rasua, ma ioli afula gi lou, gera kae babalafe ala talasi kae futa mae ai! ");
INSERT INTO lgl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sulia 'i lia wale 'ilitoa 'i maala God. Ikoso 'ali 'e goufia ta waen 'o ma ta 'are goufinai nanata 'e sai ala taunala ka lulumui. Ma talasi kae futa mae, Aloe 'are Abu kae io lo failia. ");
INSERT INTO lgl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","'I lia kae olifailia mae ioli afula 'i Israel gi fala 'i soela God gera. ");
INSERT INTO lgl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma 'i lia kae eta mae 'i lao ala Aofia, ma kae nanata malaa Profet Elaeja. Ioli gera alafaitalili 'i matanada gi, 'i lia kae logosida lou, 'ali mama gi, failia wela gera gi, gera kae kwaima ada. Ma kae olisia malatala ioli aburono gi, 'ali gera malata rada. Ma kae rerei 'alia ioli gi maasia Aofia, 'ali gera kae maasia daonala.” ");
INSERT INTO lgl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sui, Sekaraea ka sae 'uri 'e fala eniselo fo, “Lakae sai 'utaa ala lalamanala 'are la? Sulia 'i lau failia wateu lau, mera waro sui lo.” ");
INSERT INTO lgl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma eniselo fo ka olisi 'uri 'e ala: “'I lau Gebriel 'e, lau io failia God sulia atoa gi sui. Ma God lo 'e kwate lau mae, 'ali lau alaa fae'o, ma laka faarono 'o 'alia faronona 'oka 'e. ");
INSERT INTO lgl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ma ala iko 'ali 'o fakwalaimokia mola faronona 'e lau, koe lesia kwalaimokinai ala talasi God 'e 'olea fala me 'are 'e 'ali 'e fuli ai. Ma 'i osiala iko 'ali 'o fakwalaimokia saenagu, fokamu kae 'ato, ma ikoso sae tafa lala ka dao ala talasi 'are 'e lau etae sae sulia 'i lao famu kae kwalaimoki.” ");
INSERT INTO lgl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ala talasi fo ioli gera io maasia Sekaraea gi, gera ka 'afero rasua, sulia 'e io tekwa mae 'i laola Luma Abu. ");
INSERT INTO lgl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma talasi Sekaraea 'e la mae 'i maluma 'i so'ela ioli fo gi li, fokala ka 'ato lo, ma iko 'ali alaa lo failia ioli fo gi. 'Urifo mola ioli gi sui, gera ka malata lo 'uri 'e: “Kwalaimoki rasua, mala 'e lesia ta fataena 'i laola Luma Abu.” Suli fokala 'e 'ato lo, ma ka alaa mola 'alia limala fala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma talasi 'e faasuia lo galonala 'i laola Luma Abu God li, Sekaraea ka oli lo fala luma lia. ");
INSERT INTO lgl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma iko 'ali tekwa mola 'i burila, wateu lia Elisabet ka dodolanaa lo, ma fala lima madama gi iko 'ali 'e liliu lo 'i maluma faasia luma daroa, ");
INSERT INTO lgl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ma ka sae 'uri 'e, “Talasi 'e, God 'e rana lau lo, ma ka lafu lau lo faasia lio ta'ana ba gera tau agu lia ba lau ioio mae 'i laola 'i maala ioli afula gi li, 'alia 'amarana.” ");
INSERT INTO lgl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Talasi Elisabet 'e dodolanaa ka dao lo ala olo madama gi li, God ka keria mae eniselo Gebriel fala te falua 'i laola provins 'i Galili gera soia 'alia 'i Nasareti. ");
INSERT INTO lgl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","'E sakea mae te faronona fala te ulao 'au abua gera alu fafia fala wale la ratala Josef 'ali tolea. Josef 'e futa mae oliolitala kwalofa David walelitalona. Ratala ulao 'au abua fo Mary. ");
INSERT INTO lgl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eniselo 'e la mae, ka sae 'uri 'e fala, “Atoa 'oka ko famu! 'Oilakina God famu 'e ba'ela!” ");
INSERT INTO lgl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Talasi Mary 'e ronoa saenala eniselo fo li, ka malata boesia, ma ka tau 'ali 'e saiala malutala me alaana fo eniselo 'e ilia fala. ");
INSERT INTO lgl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sui eniselo ka sae lou 'uri 'e fala, “Mary, 'o alua mau na, sulia God 'e aamasi'o. ");
INSERT INTO lgl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Dunala God 'e fili 'o, koe dodolanaa, ma koe faafutaa te wela wale, ma koe fafurata 'alia Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma 'i lia kae 'ilitoa rasua, ma gera kae soia 'alia Wela God. God 'e kwatea kae 'ilitoa, malaa koko 'ualo lia David. ");
INSERT INTO lgl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma kae 'ilitoa firi fafia Jiu gi, fuui wale ala Jakob, ma Tatalona lia ikoso 'ali sui!” ");
INSERT INTO lgl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma Mary ka sae 'uri 'e fala eniselo fo, “'Au abua 'i lau. 'Uri'e ma alaana 'e 'o ilida fagu gi kae fuli 'utaa?” ");
INSERT INTO lgl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma eniselo fo ka olisi 'uri 'e ala, “Aloe 'are Abu kae sifo mae fafi 'o, ma nanatana God kae io fae'o. 'Are la fo Wela Abu 'e, gera kae soia 'alia Wela God. ");
INSERT INTO lgl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'O saiala ioli futa 'o Elisabet. Ioli gi sui gera iilia 'e 'ato lo 'ali ka too ala ta wela. Wasua 'e waro 'ala, talasi'e 'e dodolanaa lo sulia olo madama gi. ");
INSERT INTO lgl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sulia iko ta 'are 'ali 'ato mola fala God.” ");
INSERT INTO lgl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma Mary ka sae 'uri 'e, “Lau oga 'are 'e 'o ilida fagu gi ka fuli kwalaimoki lo aagu, sulia 'i lau geli li galona God.” Talasi Mary 'e sae mola 'urifo, eniselo fo ka laa lo faasia. ");
INSERT INTO lgl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ala talasi fo mola, Mary ka rerei, ma ka la nainali lo fala ke maefalua 'i tolo ala gula provins 'i Judea. ");
INSERT INTO lgl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Talasi 'e li dao, ka ruu 'i laola luma Sekaraea, ka sae 'oka fala Elisabet. ");
INSERT INTO lgl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma talasi Elisabet 'e ronoa saenala Mary, te wela fo 'e dodolanaa 'alia ka maola ma ka saola 'i laola ogala. Ma Aloe 'are Abu ka sura ala Elisabet, ");
INSERT INTO lgl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ma ka sae ba'ela 'uri 'e, “'Oilakina famu liufia geli gi sui, failia 'oilakina fala wela 'e 'o dodolanaa 'alia. ");
INSERT INTO lgl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Iko 'ali lau totolia 'alia 'are ba'ela 'e ka fuli fagu, sulia teite Aofia lau li 'e la mae fala leesinagu! ");
INSERT INTO lgl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sulia talasi lau ronoa mola saenamu, wela 'e lau dodolanaa 'alia ka lofo lo 'i laola ogaagu, sulia 'e babalafe rasua. ");
INSERT INTO lgl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","'Oilakina famu sulia 'o fakwalaimokia saenala God famu kae fuli.” ");
INSERT INTO lgl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma Mary ka sae 'uri 'e, “Manogu 'e batafea God, ");
INSERT INTO lgl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","failia alo agu 'e babalafe sulia God 'e faamauri lau. ");
INSERT INTO lgl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Lakae nuu batafea 'agua, sulia 'e malata toonagu, lau me geli mamaea mola 'agua, ma laka io li galona mola 'ala. 'E fuli 'i tara'ela ka lao 'alaa, ioli gi sui gera kae ilia lau io 'alia 'oilakina ba'ela, ");
INSERT INTO lgl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sulia 'are ba'ela gi God 'e tauda fagu 'alia nanatanala. Ma ratala God 'e abu. ");
INSERT INTO lgl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","'E fuli 'i tara'ela ka la 'alaa sulia uului ioli gi sui, 'e fatailia kwaiaamasina lia fala ioli gera lio 'ato ala gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","'E tadaa limala fo 'e nanata rasua, ma ka tagalailia ioli gera faaba'ela gera 'i talada gi. ");
INSERT INTO lgl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","'E fasifoa walelitalona nanata gi faasia tatalona gera gi, ma ka fa'ilitoa ioli gera mamaea gi. ");
INSERT INTO lgl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ioli gera fiolo gi, 'e ranoli gera 'alia 'are 'oka gi, ma ka taua ioli too'are gi gera ka dalaa. ");
INSERT INTO lgl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","'E malata tonala alafuuna 'e taua fala koko 'ualo gia gi li, ma ka kwairanai aga ioli li galona lia gi 'i Israel. Iko 'ali 'e bulono 'alia fatailianala kwaiaamasina lia 'e etae alafuu 'alia fala Abraham, ma faga lou kwalofa ioio firi lia!” ");
INSERT INTO lgl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary 'e io failia Elisabet sulia olu madama gi, sui ka bi oli fala falua lia. ");
INSERT INTO lgl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Talasi 'e dao lo fala Elisabet 'ali 'e faafuta, ka faafutaa te wela wale. ");
INSERT INTO lgl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ioli kwaima lia gi, failia iolifuta lia gi, gera ronoa 'are 'oka fo God 'e taua fala, ma gera ka babalafe rasua fafia. ");
INSERT INTO lgl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Fiu atoa gi sui 'i burila futanala wela fo, gera ka ronosulia falafala Jiu gi fala 'olenala wale na li. Ma gera ka oga 'ali gera fafurata lia 'alia mama lia Sekaraea. ");
INSERT INTO lgl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ma teite lia ka olisi 'uri 'e ada, “Ikoso moulu soia 'alia ratae 'are la! 'A ratala 'ala John.” ");
INSERT INTO lgl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma ioli fo gi gera ka olisi 'uri 'e ala, “Iko ta ioli ala kwalofa 'amoroa gi 'ali gera too ala ratae 'are la.” ");
INSERT INTO lgl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sui gera ka alaa 'alia limada, gera ka taua totofo gi fala mama lia Sekaraea, ma gera ka soilidia fala ratae 'are taa 'e oga gera kae fafurata 'alia wela fo. ");
INSERT INTO lgl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma Sekaraea ka uusu, ma ka suga 'afia ta 'aba 'are fala geregerena, ma ka geregere 'uri 'e ai, “'A ratala wela 'e John.” Ma ioli gi sui gera ka 'afero rasua. ");
INSERT INTO lgl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma talasi fo lou, nidula Sekaraea ka sae tafa lo, ma ka batafea lo God. ");
INSERT INTO lgl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma ioli gera logo mae 'i lififo li, gera ka 'afero rasua, ma faronona sulia 'are fo gi li ka talofia lo ioli gera io 'i tolo gi, 'i laola 'afutala provins 'i Judea. ");
INSERT INTO lgl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma ioli gera ronoa 'are fo gi li, gera malata galida, ma gera ka sae 'uri 'e, “Wela 'e kae ba'ela mae 'alia ta wale 'utaa 'i danii 'e?” Gera sae 'urifo, sulia gera saiala nanatana God 'e io failia wela fo. ");
INSERT INTO lgl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ma Aloe 'are Abu ka suraa ala Sekaraea mama John, ma Sekaraea ka faatalo 'uri 'e 'alia faronona God, ");
INSERT INTO lgl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Batafe na fala God 'e Jiu gi li. 'E la mae fala rananaga ioli lia gi, ma fala famaurinaga. ");
INSERT INTO lgl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","'I lia kae kwatea mae faga te wale li faamauri 'e too ala nanatana ba'ela, kae laa mae faasia kwalofa David walelitalona, wale li galona Aofia li. ");
INSERT INTO lgl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","'E alafuu faga 'alia 'are 'e gi, ala saenala profet abu gi 'i lao, ");
INSERT INTO lgl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","'ali 'e faamauri gia faasia malimae gia gi ma faasia nanatanala ioli gera malimae aaga gi. ");
INSERT INTO lgl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","'E alafuu kae fatailia kwaiaamasinala fala koko 'ualo gia gi, ");
INSERT INTO lgl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ka feke fala koko 'ualo gia Abraham 'ali ma kae lafu gia faasia malimae gia gi, ");
INSERT INTO lgl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","'ali gia galo fala ma ikoso gia mau, ");
INSERT INTO lgl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ma gia ka io rada 'i maala sulia atoa gi sui.” ");
INSERT INTO lgl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma Sekaraea ka sae 'uri 'e fala wela lia John, “'I'o Wela 'e lau, gera kae soi 'o 'alia profet God 'e 'ilitoa fafia 'are gi li sui. Ma koe eta 'i lao ala Aofia, 'ali ko faabasua ioli gi gera ka rerei 'alia maurinada maasi 'i lia. ");
INSERT INTO lgl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ma koe faronoa ioli lia gi, gera kae too ala mauri na talasi God kae kwailufa 'alia ta'ana gera gi li. ");
INSERT INTO lgl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sulia God gia, 'e kwaiaamasi rasua aaga. Malaa da'afi 'e tala mae failia madakwana li, ");
INSERT INTO lgl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","wale li faamauri gia kae dao mae faasia God failia madakwana fala ioli gera io 'i laola mae rodo ala maena li. Ma 'i lia kae kwairanai aga 'ali 'e talai gia fala too na ala aroarona li failia God.” ");
INSERT INTO lgl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma wela fo John rabela ka ba'ela, failia alo ala ka nanata. Talasi 'e ba'ela lo, ka io 'i laola abae lifi kwasi, la la ka dao ala atoa 'e fatae fala ioli 'i Israel gi li. ");
INSERT INTO lgl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ala talasi ala wawadenala John, wale 'ilitoa ala falua ba'ela 'i Rom ratala Ogastas, 'e alua te taki fala ioli ala falua gi sui 'i malula 'ilitoana lia, 'ali gera laa 'i falua koko 'ualo gera gi fala gerenala ratada. ");
INSERT INTO lgl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma etala geregerena bui 'e, gera taua talasi Kwirinias 'e 'ilitoa fafia profins 'i Siria. ");
INSERT INTO lgl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma ioli gi sui, gera ka la fala gerenala ratada, na ioli ma 'e oli oli lo 'ala fala falua lia li. ");
INSERT INTO lgl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ma Josef lou 'e laa mae faasia falua lia 'i Nasareti ala gulae tolo 'i Galili, ma ka la fala gulae tolo 'i Judea fala mae falua David walelitalona gera soia 'alia 'i Betlehem, sulia Josef wale ala kwalofa David li. ");
INSERT INTO lgl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josef 'e la 'ali ka gerea ratala failia Mary, te geli ba gera alu fafia 'ala. Ma talasi fo, Mary 'e dodolanaa lo. ");
INSERT INTO lgl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma talasi daro io 'i Betlehem, ke geli ka rabefii lo fala faafutana. ");
INSERT INTO lgl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma ka faafutaa wela etaeta lia, ma ka 'afua 'alia toro gi, ma ka faateoa 'i laola lifi li ranoli buluka na, sulia iko lo ta luma 'ali daro folia daro ka io ai. ");
INSERT INTO lgl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma ioli gera lio sulia sipsip gi li, gera io garania lou falua fo, ma gera ka lio sulia sipsip gera gi 'i laola boni. ");
INSERT INTO lgl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma eniselo God ka fatae fada, ma madakwanala God ka rara fafida, ma gera ka mau rasua. ");
INSERT INTO lgl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma eniselo fo ka sae 'uri 'e fada, “Ikoso moulu mau, sulia lau sakea mae faronona 'oka kae fababalafea ioli gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","'I tara'ela wale li faamauri 'amiu 'e futa 'i laola mae falua David 'i Betlehem, ma 'i lia lo Christ Aofia. ");
INSERT INTO lgl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma totofo famoulu 'e 'uri 'e: Moulu kae lesia te wela wawade gera 'afua 'alia toro gi, ma 'e teo ala lifi fala ranolinala buluka gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Toraa wasua, molae eniselo afula faasia 'i nali gera ka logo fatae lou failia eniselo ba, ma gera ka batafea God 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Fa'ilitoa God 'i nali. Ma aroarona fala ioli 'i wado God 'e babalafe failida gi.” ");
INSERT INTO lgl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","'I burila eniselo gi gera oli lo fala 'i nali, wale gera lio sulia sipsip fo gi li gera ka alaa kwailiu 'ada 'uri 'e, “Golu la ga fala 'i Betlehem 'ali golu li lesia 'are 'e God 'e sae sulia fagaulu gi.” ");
INSERT INTO lgl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ma daulu ka la nainali, ma daulu ka daria Mary failia Josef, ma daulu ka lesia wela wawade fo 'e teo ala lifi fala ranoli buluka na li. ");
INSERT INTO lgl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma talasi daulu lesia, daulu ka sae sulia 'are fo eniselo gi gera ilia fadaulu sulia wela fo li. ");
INSERT INTO lgl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma ioli gera ronoa gi, gera ka 'afero rasua 'alia alaana fo daulu faarono 'alida gi. ");
INSERT INTO lgl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma Mary 'e soi 'ato ala alaana fo gi, ma ka alu golida 'i laola manola. ");
INSERT INTO lgl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma wale lio folo bolosia sipsip gi li gera oli, ma gera ka batafea God fafia 'are gera ronoda gi sui, ma gera ka lesia lo kwalaimokinala alaana ba eniselo 'e iilida fada gi. ");
INSERT INTO lgl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ma ala wiki 'i buri, talasi fala 'ole wale na ala wela fo li, daro ka fafurata 'alia Jesus, ratae 'are ba eniselo 'e ilia lo fala Mary, talasi iko 'ali 'e dodolanaa 'ua ai li. ");
INSERT INTO lgl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Talasi 'e dao lo fala Josef failia Mary 'ali daro ka faakwaga daroa lo burila futanala wela malaa lo taki Moses 'e ilia fala taunai 'i burila faafutana li. 'Urifo mola, daro ka sakea wela fo fala 'i laola Luma Abu God 'i Jerusalem 'ali daro ka kwatea fala God, ");
INSERT INTO lgl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","malaa ba gera gerea ka sui lo 'i laola taki God gi 'uri 'e, “'A wela wale etaeta, gera kae kwatea fala God.” ");
INSERT INTO lgl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Daro ka kwatea lou foasina 'alia rua fe fao gi, 'o ma rua fe bola welawelaa gi, malaa taki God 'e oga fala faakwaga nala Mary. ");
INSERT INTO lgl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma talasi fo, te wale ratala Simion 'e io 'i Jerusalem. 'I lia te wale 'oka, ma ka 'itooli foasia God, ma ka io li rerei fala talasi God kae faamauria ioli Israel gi li. Ma Aloe 'are Abu 'e io ala, ");
INSERT INTO lgl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ma ka ilia ka mauri lala ka dao ala talasi kae lesia Christ fo God 'e alafuu 'alia fala famaurinala ioli lia gi li. ");
INSERT INTO lgl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aloe 'are Abu 'e talaia Simion ka la fala Luma Abu God, ma ka dao tonala Josef failia Mary, talasi daro sakea mae wela wawade fo Jesus, 'ali daro ka taua 'are taki 'e ilida fala taunali gi li. ");
INSERT INTO lgl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Urifo mola, Simion ka sakea wela fo 'i limala, ma ka batafea God 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“God, lia 'e alafuuna ba 'o 'e kwalaimoki lo. Lia 'e, wale li galona 'o 'e bi totolia lo maena, ma lau babalafe rasua. ");
INSERT INTO lgl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Dunala maagu 'e lesia lo wale 'e 'o kwatea mae 'ali 'e faamauria ioli li. ");
INSERT INTO lgl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","'I lia wale 'o rerei 'alia, 'ali ioli sui kae lesia. ");
INSERT INTO lgl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wale li faamauri 'e, 'e malaa fe fakwaru, sulia kae fatailia liomu fala ioli mamata faasia Jiu gi li. Ma 'i lia kae faa 'ilitoa 'amami Jiu gi, ioli 'o gi.” ");
INSERT INTO lgl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ma mama lia failia teite lia, daro ka 'afero rasua talasi daro ronoa 'are fo Simion 'e iilida sulia wela fo gi li. ");
INSERT INTO lgl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma Simion ka fa'oka daroa. Sui, ka sae 'uri 'e fala Mary, teite lia, “Te wela 'e wela God 'e filia 'ua lo mae, ioli afula 'i Israel gi gera kae too ala mauri na ala ma afulanala lou ioli 'i Israel gi maurinada kae mae sulia iko 'ali gera saiala. 'I lia lo totofo kae fatailia God fala ioli li, ma afulanala ioli kae barasi 'alia, ");
INSERT INTO lgl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'are la kae fatailia malata agwaagwa gera gi. Ma kwaimalataina ba'ela kae dao amu, ka malaa na me 'au 'e too ala manomu ka fii rasua.” ");
INSERT INTO lgl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ma me geli 'oru 'e io lou ala talasi fo li, ratala 'Ana, ma 'i lia te profet lou, ma 'e waro lo, fe nali lia gi ka dao lo ala kwalu akwala wala fai fe nali. 'I lia wela geli 'a Faniuel ala kwalofa Asa. 'Ana talasi 'e ulao, 'e wateu ma ka io failia arai lia sulia fiu fe nali gi mola, ");
INSERT INTO lgl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ma 'i burila arai lia ka mae, sui ka 'oru lo 'ala la la ka dao ala talasi 'e. 'E io, ma ka 'idufae laa mola 'ala 'i laola Luma Abu God fala abu fana na failia foasinala God sulia atoa ma boni. ");
INSERT INTO lgl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ala talasi fo lou, 'i lia 'e dao tonala Josef failia Mary, ma ka batafea God, ma ka alaa sulia wela fo fala ioli gera maasia talasi God kae faamauria ioli Jerusalem gi li. ");
INSERT INTO lgl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Talasi Josef failia Mary daro faasuia lo 'are taki God 'e iilida fala taunali gi li, daro ka oli lo fala falua daroa 'i Nasareti, falua 'i laola gulae tolo 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wela fo 'e ba'ela mae, ma ka nanata, ma ka too ala liotoo. Ma kwai'ofena God ka io failia. ");
INSERT INTO lgl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ala fe nali gi sui, mama Jesus ma teite lia daro la fala falua ba'ela 'i Jerusalem fala fe atoa ba'ela ala Fanana ala daofaeliuna li. ");
INSERT INTO lgl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma talasi Jesus 'e dao lo ala akwala wala rua fe falisi gi li, daulu ka la ala fanana fo sulia falafala gera. ");
INSERT INTO lgl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","'I burila fanana fo 'e sui, mama lia ma teite lia daro ka oli lo 'adaroa, ma Jesus ka io 'ala 'i Jerusalem, ma iko 'ali daro saiai. ");
INSERT INTO lgl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Daro fia 'uri 'e la lo failia logona fo, ma daro ka la lo 'adaroa sulia fe atoa laulau fo. Sui, daro ka bi fuli'ae fala faitalena 'afia 'i safitala iolifuta daroa gi li, failia ioli kwaima daroa gi. ");
INSERT INTO lgl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma talasi daro lio ma iko 'ali daro lesia, daro ka oli, daro ka li lio lou mae 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ma olula fe atoa, daro ka bi dao tonala 'i laola Luma Abu God. 'E gwauru 'ala failia wale faalalau ala Jiu gi li, ma ka fafuronosida, ma ka soilidida sulia 'are gera faalalau 'alida gi. ");
INSERT INTO lgl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma ioli gera ronoa gi sui, gera 'afero rasua 'alia sai 'arena lia failia olisina lia gi. ");
INSERT INTO lgl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ma talasi Josef failia Mary daro lesia, daro ka 'afero rasua. Ma teite lia ka sae 'uri 'e fala, “Wela lau, 'o tau 'utaa ameroa 'e? Mera mama 'o, mera lio mae 'afi 'o, ma mera ka malata boeboeta rasua.” ");
INSERT INTO lgl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma Jesus ka olisi daroa 'uri 'e, “'Uta 'e mora ka lio 'afi lau ala lifi atale gi? Totolia mora ka sai mola 'amoroa ai, lakae io mola 'agua 'i laola Luma Mama lau li.” ");
INSERT INTO lgl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Urifo ma iko 'ali daro sai mola ala malutala me alaana fo 'e ilia fadaroa. ");
INSERT INTO lgl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sui, Jesus ka oli lo fae daroa fala 'i Nasareti, ma ka rono suli daroa. Ma teite lia ka alu golia 'are fo gi sui 'i laola manola. ");
INSERT INTO lgl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma Jesus ka ba'ela ala rabe failia liotoo, ma God failia ioli gera babalafe sui 'alia. ");
INSERT INTO lgl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ala talasi fo, 'e dao lo ala akwala wala lima fe nali Taebirias 'e 'ilitoa ala falua ba'ela 'i Rom, ma Pontias Paelat ka 'ilitoa fafia 'i Judea, ma Herod 'e 'ilitoa fafia 'i Galili, ma Filip walefae lia ka lio sulia 'i Iturea ma 'i Trakonaetis, ma Lisanias ka lio sulia gulae tolo 'i Abilin. ");
INSERT INTO lgl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Talasi fo lou, 'Anas failia Kaeafas daroa rua 'ilito'ola fata abu gi ala falua 'i Jerusalem. Ma ala talasi fo, saenala God ka dao ala John wela Sekaraea, talasi 'e io 'i laola abae lifi kwasi li. ");
INSERT INTO lgl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma John ka la ala lifi galia kwai 'i Jodan gi. Ma ka sae 'uri 'e fala ioli, “'Amu bulusi faasia ta'ana 'amiu gi, ma 'amu ka sisiu abu, 'ali God kae kwailufa 'alia ta'ana 'amiu gi.” ");
INSERT INTO lgl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'E malaa lia ba profet Aesea 'e gerea ka sae 'uri 'e, “Te wale kae rii 'i laola abae lifi kwasi kae sae 'uri 'e, ‘Aofia kae dao lo mae! 'Amu farada tala fala! ");
INSERT INTO lgl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ma 'amu ka fafonua ote gi, ma 'amu ka faootea sifosifona gi failia fe uo gi. Ma 'amu ka farada tala koki gi, ma 'amu ka fadada tala gilugilua gi. ");
INSERT INTO lgl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma ioli sui kae lesia lia 'e God kae famaurida.’” ");
INSERT INTO lgl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ma ioli afula gera laa mae 'i so'ela John 'ali ka fasiuabuda. Ma John ka sae 'uri 'e fada, “'Amu malaa mola 'amiu kale wa gi! Iko 'ali lau iilia famiu fasiuabuna kae lau 'ali 'amiu faasia kwaikwaina God ala ikoso 'ali 'amu bulusi faasia ta'ana 'amiu gi li. ");
INSERT INTO lgl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","'Amu taua 'are 'e fatailia 'amu bulusi lo faasia ta'ana 'amiu gi li! Ma ikoso 'ali 'amu malata 'uri 'e 'i laola malatamiu, ‘'I 'amami ioli 'ami futa mae ala kwalofa Abraham gi li. 'Ato ta kwaikwaina faasia God kae dao amaami.’ Ma lakae iili rada ai famiu, 'e talawarau mola 'ala fala God 'ali sakea ta me fau ala fau 'e gi, ma ka raunailia 'alia kwalofa Abraham gi! ");
INSERT INTO lgl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ala talasi 'e, God 'e rerei lo 'alia kwaikwaina, malaa wale 'e dau ala me kwaikwai li, ma ka rerei fala tofunala 'ai gi li. Ma 'ai iko 'ali gera funu 'alia tali fuae 'are 'oka gi li, kae tofuda, ma ka tasida 'i laola dunaa.” ");
INSERT INTO lgl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sui, ioli gi gera ka soilidi 'uri 'e ala John, “Ta taa 'e 'ami ka taua ka fatailia 'ami bulusi?” ");
INSERT INTO lgl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma John ka olisi 'uri 'e ada, “Ala ta ioli 'e too ala rua toro gi, ka kwatea ruala toro fala ta ioli iko 'ali too ala ta me toro. Ma ala ta ioli 'e too ala fana gi, 'i lia ka tolinia.” ");
INSERT INTO lgl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma nali wale 'asa ala sakenala bata ala takisi li, gera dao lou mae fala sisiuabuna, ma gera ka soilidi 'uri 'e, “Wale li faalalauna, ta taa lo 'ami ka taua ka fatailia 'ami bulusi?” ");
INSERT INTO lgl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma John ka olisi 'uri 'e ada, “'Amu ka logosia mola bata 'e totolia bata taki 'e alua. Ikoso 'ali 'amu suga liufia totofoe bata fo.” ");
INSERT INTO lgl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma nali wale li ofona gera ka soilidia lou 'uri 'e, “Ma 'i 'ameulu, ta taa 'e meulu kae taua ka fatailia 'ami bulusi?” Ma 'i lia ka sae 'uri 'e fada, “'Amu ala suunailianala ta ioli fala kwate bata na 'amiu. Ma ikoso 'ali 'amu beli ta ioli. Ma moulu ka babalafe fafia me bata gera kae folifoli 'amiu lo 'alida gi.” ");
INSERT INTO lgl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ioli gera kwaimamali fala daonala Christ, wale 'e God 'e filia kae famauria ioli lia gi li, gera malata 'uri 'e, “Mala John lo 'e Christ.” ");
INSERT INTO lgl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ma John ka sae 'uri 'e fada, “Lakae fasiuabu 'amiu mola 'alia kwai, ma wale 'e kae dao mae 'i lia 'e 'ilitoa ka liufi lau. Ma iko 'ali lau totolia 'ali lau tatalia 'ae botu lia gi faasia 'aela. Ma 'i lia kae faasiu abu amiu 'alia Alo ala God failia dunaa. ");
INSERT INTO lgl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma kae rerei lo fala lokokwaikwaina fala ioli sui, ka malaa na wale kae kefoa bouboui 'are 'oka gi faasia sunasunae 'are gi. Ma ka logosia bouboui 'are 'oka gi 'i laola luma li goli 'are na, ma ka 'agofia lo sunasunae 'are gi 'i laola dunaa la ikoso 'ali mae.” ");
INSERT INTO lgl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma John ka sae sulia Faronona 'Oka fada 'alia alaana afula 'urifo gi, ma ka saefida 'ali gera olisia falafala gera gi. ");
INSERT INTO lgl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma talasi fo lou, John ka sae nanata rasua fala Herod, wale 'e 'ilitoa fafia gulae tolo fo li, sulia Herod 'e tolea Herodias, wateu walefae lia Filip, ma ka taua 'are ta'a afula gi lou. ");
INSERT INTO lgl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma me 'are ta'a ka ba'ela rasua Herod 'e taua lo 'e sakea John, ma ka alua 'i laola rara. ");
INSERT INTO lgl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma 'i lao ala talasi Herod 'e alua John 'i laola raraa li, John 'e fasiuabua ioli afula gi. Jesus 'e la mae, ma John ka fasiuabua lou. Ma talasi Jesus 'e foa, lofola raloo ka tafa, ");
INSERT INTO lgl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma Alo ala God ka sifo mae fafia malaa na fe bola. Ma te linae 'are ka talo mae faasia 'i nali ka sae 'uri 'e, “'I'o wela moutae lau ma lau kwaima rasua amu. Lau babalafe rasua 'ali'o.” ");
INSERT INTO lgl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ala talasi Jesus 'e dao lo totolia olu akwala fe nali 'i burila futa nala, ka fuli'ae liu lo fala faalalauna. Ma ioli sui, gera fia 'uria Jesus wela 'a Josef mola. Ma Josef 'e futa ala Hilae. ");
INSERT INTO lgl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilae 'e futa ala Matat, Matat ka futa ala Lifae, Lifae ka futa ala Melkae, Melkae ka futa ala Janae, Janae ka futa ala Josef. ");
INSERT INTO lgl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josef wela Matataeas, Matataeas ka futa ala Emos, Emos ka futa ala Neham, Neham ka futa ala Eslae, Eslae ka futa ala Nagae. ");
INSERT INTO lgl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagae wela 'a Meata, Meata ka futa ala Matataeas, Matataeas ka futa ala Semein, Semein ka futa ala Josek, Josek ka futa ala Joda. ");
INSERT INTO lgl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda wela Joanan, Joanan ka futa ala Risa, Risa ka futa ala Serababel, Serababel ka futa ala Sialtiel, Sialtiel ka futa ala Nirae. ");
INSERT INTO lgl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nirae wela Melkae, Melkae ka futa ala Adae, Adae ka futa ala Kosam, Kosam ka futa ala Elmadam, Elmadam ka futa ala Ere. ");
INSERT INTO lgl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ere wela Josua, Josua ka futa ala Eliesa, Eliesa ka futa ala Jorim, Jorim ka futa ala Matat, Matat ka futa ala Lifae. ");
INSERT INTO lgl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lifae wela Simion, Simion ka futa ala Juda, Juda ka futa ala Josef, Josef ka futa ala Jonam, Jonam ka futa ala Elaeakim. ");
INSERT INTO lgl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaeakim wela Milia, Milia ka futa ala Mena, Mena ka futa ala Matata, Matata ka futa ala Netan, Netan ka futa ala David walelitalona. ");
INSERT INTO lgl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David wela Jesi, Jesi ka futa ala Obed, Obed ka futa ala Boas, Boas ka futa ala Salmon, Salmon ka futa ala Nason. ");
INSERT INTO lgl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason wela Aminadab, Aminadab ka futa ala Admin, Admin ka futa ala Anae, Anae ka futa ala Hesron, Hesron ka futa ala Peres, Peres ka futa ala Juda. ");
INSERT INTO lgl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda wela Jakob, Jakob ka futa ala Aesak, Aesak ka futa ala Abraham, Abraham ka futa ala Tera, Tera ka futa ala Neho. ");
INSERT INTO lgl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neho wela Sirag, Sirag ka futa ala Riu, Riu ka futa ala Pileg, Pileg ka futa ala Eba, Eba ka futa ala Sela. ");
INSERT INTO lgl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela wela Keinan, Keinan ka futa ala Afaksad, Afaksad ka futa ala Siem, Sem ka futa ala Noa, Noa ka futa ala Lamek. ");
INSERT INTO lgl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek wela Metusala, Metusala ka futa ala Enok, Enok ka futa ala Jered, Jered ka futa ala Mahelalel, Mahelalel ka futa ala Kenan. ");
INSERT INTO lgl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan wela Enos, Enos ka futa ala Set, Set ka futa ala Adam wela God. ");
INSERT INTO lgl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Alo ala God 'e sura ala Jesus, ma Jesus ka oli mae faasia kwai 'i Jodan, ma Alo ala God ka talaia fala abae lifi kwasi. ");
INSERT INTO lgl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma Saetan ka mailitonala 'i lififo sulia fai akwala fe atoa gi. Ma sulia fe atoa fo gi, Jesus iko 'ali 'ania mola ta me fana, ma ka fiolo rasua lo. ");
INSERT INTO lgl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma Saetan ka sae 'uri 'e fala, “Sulia 'i'o Wela God, 'o sae fala me fau 'e 'ali 'e bulusi 'alia ta tofui berete.” ");
INSERT INTO lgl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma Jesus ka olisi 'uri 'e ala, “Geregerena Abu 'e iilia, ‘Ioli ikoso mauri mola 'alia fana talifilia.’” ");
INSERT INTO lgl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sui Saetan ka talaia fala fofola me raeraena la 'e rae rasua, ma 'i laola me talasi wawade mola, ka fatailia lo tatalona 'i laola molagali gi li sui. ");
INSERT INTO lgl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma ka sae 'uri 'e fala Jesus, “Lakae kwatea tatalona 'e gi sui, failia 'are 'oka gi sui famu. Sulia 'are 'e gi, 'are lau gi sui mola, ma lau saiai laka kwateda sui mola 'agua fala ta ioli mola 'ala lau filia. ");
INSERT INTO lgl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma ala ko boururu, ko foasi lau, lakae kwatea tatalona 'e gi sui famu.” ");
INSERT INTO lgl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma Jesus ka olisi 'uri 'e ala, “Geregerena Abu 'e iilia, ‘Talifilia God 'o mola ko foasia, ma ko galo fala.’” ");
INSERT INTO lgl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sui, Saetan ka talaia lou fala falua ba'ela 'i Jerusalem, ma ka fa uraa ala te lifi 'e rae rasua 'i nali fofola Luma Abu God li. Ma ka sae 'uri 'e fala Jesus, “Ala 'i'o Wela God, 'o 'aru fala 'i fua faasia 'i lifi'e. ");
INSERT INTO lgl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sulia Geregerena Abu 'e iilia, ‘God kae kwatea mae eniselo lia gi, 'ali gera ka lio 'oka suli 'o. ");
INSERT INTO lgl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ma gera ka dau amu, 'ali 'aemu wasua 'ato 'ali 'e foto ala ta me fau.’” ");
INSERT INTO lgl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma Jesus ka olisi 'uri 'e ala, “Geregerena Abu 'e sae lou 'uri 'e, ‘'O ala mailinalatonala God 'o li.’” ");
INSERT INTO lgl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","'I burila Saetan 'e mailitonala Jesus 'alia 'are fo gi ka sui, ka la lo faasia Jesus ala talasi fo, ka maasia lou ta me talasi. ");
INSERT INTO lgl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ma nanatana ala Alo ala God 'e io failia Jesus, ma ka oli lo fala provins 'i Galili. Ma alaana sulia ka talo 'i laola gulae provins fo sui. ");
INSERT INTO lgl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma ka faalalau 'i laola luma fala foana gera gi li, ma ioli gi sui gera ka 'auraea. ");
INSERT INTO lgl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sui Jesus ka la fala 'i Nasareti, falua ba 'e ba'ela mae 'i laola. Ma ala Sabat, fe atoa ala mamalona li, ka la 'i laola luma fala foa na li sulia falafala lia lo mae. Ma ka tatae fala iduminala Geregerena Abu, ");
INSERT INTO lgl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ma gera ka kwatea geregerena 'a profet Aesea 'e gerea fala. Ma 'i lia ka tafalia, ma ka daria lifi la Aesea 'e gerea ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Alo ala God 'e sura agu, sulia 'e fili lau 'ali lau sae sulia Faronona 'Oka fala ioli siofa gi. Ma ka kwate lau mae 'ali lau faatalo 'alia fala ioli gera io 'i laola raraa gi li, gera kae sakwadola. Ma lakae guraa ioli maada koro gi. Ma lakae lufaa ioli gera malata'a ada gi. ");
INSERT INTO lgl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma lakae faarono 'alia talasi 'e dao lo fala Aofia 'ali faamauria ioli lia gi.” ");
INSERT INTO lgl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Talasi Jesus 'e idumia ka sui, ka lou lo fafia geregerena fo, ma ka olifailia fala wale 'e lio sulia luma fala foana li, ma ka gwauru 'i fua ka faalalau. Ma ioli gera io 'i laola luma fo fala foana li sui, gera ka bubu nanata lo fala. ");
INSERT INTO lgl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma 'i lia ka fuli'ae ka alaa fada 'uri 'e, “Geregerena Abu 'e, 'e fuli kwalaimoki lo 'i tara'ela, ala talasi 'e 'amu ronoa lau idumia ko famiu.” ");
INSERT INTO lgl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma ioli sui gera ka soi 'oka ala, ma gera ka 'afero rasua sulia alaanala 'e 'oka. Ma gera ka sae 'uri 'e, “'Uri'e ma iko lou wela ba Josef mola 'e? Ma 'e ilia 'i lia lo fakwalaimokinala geregerena abu 'e.” ");
INSERT INTO lgl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma Jesus ka sae 'uri 'e fada, “Lau saiai 'amu kae sae 'uri 'e fagu, ‘Wale li gurana, 'o guraa 'o ga 'i talamu.’ Ma 'amu kae sae lou 'uri 'e fagu, ‘'O taua ga 'i laola falua 'o 'are ba 'ami ronoa 'o tauda mae ala falua 'i Kapaneam gi li.’” ");
INSERT INTO lgl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sui Jesus ka sae lou 'uri 'e, “Lakae ilia 'are kwalaimoki famiu, 'e 'ato 'ali gera ka kwaloa ta profet 'i laola falua lia 'i talala. ");
INSERT INTO lgl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Lakae ilia lou famiu, geli 'oru afula Jiu gi li gera io mola 'ada 'i Israel ala talasi Elaeja 'e io ai. Ma talasi ba uuta iko 'ali too sulia olu fe nali ma olo madama gi li, ma fiolo ba'ela ka liu lou ala falua gia gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma God iko 'ali keria Elaeja fala 'oru 'i Israel gi. 'E keria 'ala Elaeja 'i so'ela me 'oru la iko lou geli Jiu lia 'e io 'i Serefat, falua 'i laola gulae tolo 'i Saedon. ");
INSERT INTO lgl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma ioli afula Jiu 'i Israel gi kuu 'e odeda ala talasi Elaesa 'e profet ai. Ma iko 'ali 'e guraa mola ta ioli ada. Talifilia Neman wale iko lou Jiu li mola 'e la mae faasia falua 'i Siria Elaesa ka guraa.” ");
INSERT INTO lgl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ma talasi gera ronoa 'are fo li, ioli sui 'i laola luma fo fala foana li, gera ka ogata'a. Gera ogata'a dunala Jesus 'e iilia God kae ranaa 'ala ioli mamata faasia Jiu gi li, ma 'i gera iko. ");
INSERT INTO lgl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ma gera ka tatae, ma gera ka tabalia Jesus faasia falua fo. Ma gera ka talaia Jesus fala gwaula fe uo gera raunailia falua gera 'i fofola, 'uri 'ali gera ka 'ui 'alia Jesus 'i fua, 'ali ka mae. ");
INSERT INTO lgl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Wasua ma, 'e liudolada mola 'i safitala logona fo, ma ka la lo 'ala faasida. ");
INSERT INTO lgl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sui, Jesus ka la fala 'i Kapaneam, te falua ala gulae tolo 'i Galili. Ma ala na Sabat, fe atoa ala mamalona li, ka faalalau ioli 'i lififo gi li. ");
INSERT INTO lgl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma ioli fo gera logo mae 'i so'ela 'i laola luma fala foana li, gera 'afero rasua 'alia falalauna lia gi, sulia Jesus 'e sae 'alia nanatana failia kwalaimokina God. ");
INSERT INTO lgl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma te wale aloe 'are ta'a 'e io ala, 'e io lou 'i lififo. Ma ka akwa 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus wale 'i Nasareti, lau saiamu, 'i'o Wale Abu God. Taa 'e 'o oga koe taua ameulu? Mala 'o la mae fala fafuta'a nameulu tae ne?” ");
INSERT INTO lgl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesus ka balufia aloe 'are ta'a fo, 'uri 'e, “'O lobo ma ko latafa mae faasia wale la!” Ma aloe 'are ta'a fo ka 'ui 'alia wale fo 'i wado 'i maala logona fo, ma ka latafa lo faasia. Ma wale fo rabela iko 'ali malaa mola. ");
INSERT INTO lgl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ioli gera logo 'i lififo gi li, gera ka 'afero rasua, ma gera ka soilidi kwailiu 'uri 'e, “Ma falalauna taa 'e 'uri 'e wani? Wale 'e 'e balia aloe 'are ta'a gi 'alia kwalaimokina failia nanatana, ma gera ka latafa sui 'i maluma!” ");
INSERT INTO lgl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma alaana sulia Jesus ka talo ala falua gi sui galia gulae tolo fo. ");
INSERT INTO lgl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sui Jesus ka la faasia luma fala foana li, ma ka la 'i luma 'a Simon. 'Urifo ma funo geli Simon, 'e matai 'alia ragana ba'ela ala talasi fo. Ma daulu ka sugaa Jesus 'ali guraa. ");
INSERT INTO lgl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Urifo mola, Jesus 'e la ka ura 'i rabela tafe geli fo li, ma ka balufia ragana fo faasia. Ma geli fo ka 'akwaa lo, ma ka tatae ka 'ago fana, ma ka ranoli daulu lo. ");
INSERT INTO lgl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ala talasi da'afi 'e suu lo, ma atoa Jiu gi fala mamalona li 'e sui lo, ioli afula gi gera sakea mae ioli kwaima gera gi mataina tootoo gi 'e tauda 'i so'ela Jesus. Ma Jesus ka alua limala fafida, ma ka gurada sui. ");
INSERT INTO lgl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","'E 'urifo lou, aloe 'are ta'a afula gi gera tafi faasia ioli gi, ma gera ka akwa 'uri 'e, “'I'o Wela God!” Ma Jesus ka lui nasi ala aloe 'are ta'a fo gi ikoso 'ali gera sae, sulia gera saiai ka sui lo lia 'e 'i lia Christ, wale God 'e filia fala famaurinala ioli lia gi li. ");
INSERT INTO lgl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","'Ofaedani, Jesus 'e laa faasia falua 'i Kapaneam, ka laa fala te lifi 'e aroaro. Ma ioli gi gera fuli'ae fala lio na 'afia, ma talasi gera daria, gera ka sae 'uri 'e fala, “Ikoso laa faasia falua 'e.” ");
INSERT INTO lgl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sui Jesus ka sae 'uri 'e fada, “God 'e kwate lau mae fala faatalona 'alia Faronona 'Oka li, lia 'e laka la 'i laola tali falua mamataa lou, 'ali lau faabasu 'alia lia 'e God kae 'ilitoa fafia ioli lia gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma Jesus ka faatalo 'alia Faronona 'Oka 'i laola luma fala foana gi li ala lifi 'i Israel gi. ");
INSERT INTO lgl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ala na fe atoa, Jesus 'e ura ka faalalau 'i rabela 'osi ba'ela 'i Galili, ma ioli afula gi gera susuu mae 'i so'ela fala rononala saenala God. ");
INSERT INTO lgl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma ka lesia rua baru walekwaiasina gi gera tafisia ka io mola 'ala 'i maala matakwa li olo, ma daulu kae saua fuo daulu gi. ");
INSERT INTO lgl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ma Jesus ka tae 'i laola baru Simon, ma ka iilia fala 'ali ke usulae wawade ko ala faasia 'i rara. Ma Jesus ka gwauru 'i laola baru fo, ma ka lao 'ala ala faalalaunala ioli. ");
INSERT INTO lgl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma talasi 'e faalalau ioli gi ka sui lo, ka sae 'uri 'e fala Simon, “Moulu usulailia lou ko baru 'e fala 'i fafo, sui moulu ka aala 'alia fuo 'amoulu gi.” ");
INSERT INTO lgl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma Simon ka olisi 'uri 'e ala, “Waleli Falalauna, meulu galo ulafu lo mae sulia boni laulau 'e, wasua ma iko 'ali meulu tafoa mola ta ia. Wasua, sulia saenamu, lakae aala lo 'agua 'alia fuo 'e gi.” ");
INSERT INTO lgl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma talasi daulu aala 'alia fuo fo gi li, daulu ka tafoa ia afula rasua, ma fuo gi ka garani gaga lo. ");
INSERT INTO lgl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sui daulu ka fairalo fala wale kwaima daulu gi 'i laola na baru lou, 'ali daulu la mae, daulu ka kwairanai adaulu. 'Urifo daulu ka dao mae, ma daulu ka fafonua rua baru fo gi 'alia ia, la la garani daro ka wawalo lo. ");
INSERT INTO lgl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma talasi Simon Peter 'e lesia 'are fo li, ka la mae ka boururu 'i maala Jesus, ma ka sae 'uri 'e, “Aofia, 'o la faasia lau! 'I lau wale ta'a rasua!” ");
INSERT INTO lgl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simon failia wale fo gera io 'i lififo gi li, gera ka 'afero rasua 'alia ia afula fo daulu tafoa. ");
INSERT INTO lgl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma na rua wale daro galo failia Simon, ratadaroa James failia John, rua wela Sebedi gi, daro 'afero rasua lou. Ma Jesus ka sae 'uri 'e fala Simon, “'O ala mau na. 'I lao ba koe kwaikwaiasi fala ia gi, ma fuli 'i tara'ela ka la 'alaa, koe kwaiasi mola fala ioli 'ali gera fitoo ala God.” ");
INSERT INTO lgl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma talasi daulu dao 'i rara, daulu ka tafisia lo baru gi failia 'are gi sui sulia ole, ma daulu ka la lo failia Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ala na fe atoa, Jesus 'e io 'i laola na falua, ma te wale kuu 'e taua, 'e io lou 'i lififo. Talasi 'e lesia Jesus, ka la mae 'i so'ela, ka boururu 'i maala, ma ka sugaa ka sae 'uri 'e, “Arai ala 'o marabe, 'o saiai ko guraa lau mola 'amua.” ");
INSERT INTO lgl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sui Jesus ka tadaa ko limala, ma ka dau tonala rabela, ma ka sae 'uri 'e, “'Eo, lau marabe. 'O mafo lo.” Ma nainali mola 'i burila alaana fo Jesus iilida gi, kuu fo ka sigi lo faasia wale fo. ");
INSERT INTO lgl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sui Jesus ka keri olifailia wale fo ka sae 'uri 'e fala, “'O ala farononala ta ioli 'alia 'are 'e gi. Ma ko laa ga 'i so'ela fata abu, ma ko fatailia rabemu fala, 'ali 'e saiai lia 'e 'o 'akwaa lo. Sui ko kwatea foasina Moses 'e ilia 'ali ioli gi sui gera ka fakwalaimokia lia 'e kuu ba 'e ioio 'i rabemu 'e sigi lo.” ");
INSERT INTO lgl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'E 'urifo wasua 'ala, faronona sulia 'are 'e Jesus fulida gi, 'e talofia lo lifi afula gi, ma ioli afula gi gera ka la mae 'i so'ela fala rononala falalauna lia gi, ma 'ali Jesus ka gurada lou faasia mataina gera gi. ");
INSERT INTO lgl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma talasi afula, Jesus 'e la faasia ioli gi fala lifi aroaro gi fala foana. ");
INSERT INTO lgl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na fe atoa, talasi Jesus kae faalalau 'i laola na luma, nali Farasi failia wale falalau ala taki gi li, gera io lou 'i lififo, gera la mae faasia falua afula gi ala gulae tolo 'i Galili failia 'i Judea, ma 'i Jerusalem. Ma nanatana God ka io failia Jesus, 'ali 'e guraa ioli gera matai gi. ");
INSERT INTO lgl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma nali wale gera sakea mae te wale rabela mae, daulu sakea mae 'i fofola tafe. Daulu ka tau nanata fala ruuna 'i luma failia, 'ali daulu alua 'i maala Jesus, 'ali ka guraa. ");
INSERT INTO lgl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Wasua sulia logona fo 'e ba'ela rasua, alae wale kwaima fo wale fo li iko 'ali daulu totolia lo ruuna ko 'i luma 'i so'ela Jesus. 'Urifo daulu ka sakea wale fo, daulu ka rae failia 'i fofola luma, ma daulu ka tafalia te mae kwakwana ba'ela, daulu ka fasifoa mae wale fo 'i fofola tafe 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ma talasi Jesus 'e lesia fitoona daulu li, ka sae 'uri 'e fala wale fo rabela 'e mae, “Walekwaima lau, lau kwailufa lo 'alia ta'ana 'o gi.” ");
INSERT INTO lgl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma wale falalau ala taki gi li failia Farasi gi, gera ka nurunuru buri kwailiu 'adaulu 'i safitadaulu 'uri 'e, “Ale wale! 'E fiia 'uri 'i lia wale 'utaa 'e? 'E fafuradania lo failia God. Ioli 'ato 'ali kwailufa 'alia ta'ana gi. Talifilia God mola 'e saiala kwailufana 'alia ta'ana gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesus 'e sai ala malata 'i laola lioda gi, ma ka sae 'uri 'e fada, “'Amu ala malata na lou 'uri la.” Ma Jesus sai lou ala lia 'e gera fakwalaimokia talifilia God mola 'e sai ala guraa ioli na li. ");
INSERT INTO lgl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Mola 'urifo ka sae 'uri 'e, “Ala laka sae 'uri 'e fala wale 'e rabela 'e mae, ‘Ta'ana 'o gi, lau kwailufa lo 'alida,’ 'ato 'ali 'amu lesia mola 'ali 'e fuli. Ma ala laka sae 'uri 'e, ‘Tatae, ma ko liu,’ 'urifo lo 'amu ka bi lesia lia 'e lau too ala nanatana fala gurana. ");
INSERT INTO lgl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Talasi lau guraa wale 'e li, lau fatailia famiu lia 'e 'i lau, Wela Wale li, lau too ala nanatana fala kwailufa na 'alia ta'ana gi li.” Sui Jesus ka sae 'uri 'e fala wale rabe mae fo, “Lakae ilia famu, 'o tatae lo, ko sakea tafe 'o, ma ko laa lo 'i falua 'o.” ");
INSERT INTO lgl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma wale fo, nainali mola ka tatae lo 'i maada, mola ka sakea tafe 'e teoteo 'i fofola, ma ka oli 'i falua lia failia batafena ba'ela fala God. ");
INSERT INTO lgl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma 'i gera sui gera ka 'afero rasua lo, ma gera ka batafea God. Me 'are fo gera lesia gera 'afero rasua, gera ka sae 'uri 'e, “'Eo, 'are li 'aferona ba'ela rasua 'e golu lesia 'i tara'ela.” ");
INSERT INTO lgl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","'I burila me 'are fo, Jesus 'e la ko 'i maluma, ma ka lesia Lifae, wale fala sakenala bata ala takisi li, 'e gwauru ala lifi 'e galo ai. Jesus ka sae 'uri 'e fala, “'O la mae faelau.” ");
INSERT INTO lgl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lifae ka tatae, ma ka tafisia lo 'are lia gi sui, ma ka la lo failia Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sui Lifae ka taua te fanana ba'ela fala Jesus 'i luma aala. Ma talasi fo lou, ioli afula gera golia bata ala takisi li failia nali ioli lou, gera fana failia Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Nali Farasi ma wale falalau ala taki gi li gera ka ogata'a, ma gera ka sae 'uri 'e fala wale li galona Jesus gi, “'E totolia ikoso ka fana ma ka gou failia wale goli bata ala takisi gi li ma ioli ta'a 'urifo gi.” ");
INSERT INTO lgl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus 'e olisidaulu ka sae 'uri 'e, “Ioli iko 'ali gera matai gi, iko 'ali gera booboo mola fala ta wale li gurana, ma ioli 'e gera matai gi lou 'ada, gera boboo fala wale li gurana. ");
INSERT INTO lgl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Iko 'ali lau la mae fala kwalonala ioli rada gi 'ali gera ka bulusi, ma ioli taunada ta'a gi lou 'ada, lau la mae fala kwalonada fala olisi malata na.” ");
INSERT INTO lgl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nali ioli gera sae 'uri 'e fala Jesus, “Ala talasi afula gi, wale li galona John gi gera abu fana fala foana, failia wale li galona Farasi gi gera ka 'urifo lou. Ma wale li galona 'e 'o gi, gera fana ma gera ka gou mola 'ada.” ");
INSERT INTO lgl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus 'e olisidaulu ka sae 'uri 'e, “'E iko 'ali rada fala ioli 'e gera io ala fanana ala araarainali 'ali gera ka abu fana. Sulia talasi arai fa'alu 'e io mola 'ala 'ua failida gera ka babalafe. ");
INSERT INTO lgl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wasua ma talasi kae dao mae 'i danii gera kae sakea arai fa'alu faasida. Talasi fo bui, gera ka bi abu fana lou, sulia gera kwaimalatai. 'Are laa 'e iko 'ali totolia 'ali wale li galona lau gi gera ka abu fana mola 'ada talasi lau io 'ua failida.” ");
INSERT INTO lgl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sui Jesus ka sae 'alia tarifulaana fada 'uri 'e, “'E iko 'ali 'e rada 'ali ta ioli 'ali sakea ta nisinisi toro fa'alu fala taibolosinala ta toro 'ualo. Suli ala ka tau 'urila, me nisinisi toro fa'alu fo kae gagasia te toro 'ualo fo, sulia toro fa'alu 'e lugu 'i burila wasinai, ma toro fa'alu ikoso lio 'oka mola failia toro 'ualo. ");
INSERT INTO lgl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma 'amu sai lou ai, 'e iko 'ali 'e totolia fala ta ioli 'ali alua waen fa'alu 'i laola wai 'ua gera galofia 'alia sunasunala nanigot li, sulia wai 'ualo fo iko 'ali sai ala paku na. Suli ala ka tau 'urila li, talasi waen fo kae tora mola mae, ka fogaa lo wai 'ualo fo, ma waen la ka anikilo, ma wai fo ka ta'a lo. ");
INSERT INTO lgl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lia fo ioli ka alua lo waen fa'alu 'i laola wai fa'alu 'e saiai kae paku. ");
INSERT INTO lgl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Ta ioli kae 'idufae goufia mola 'ala waen 'ualo, iko 'ali oga waen fa'alu. Sulia 'e sae 'uri 'e, ‘Te waen 'ualo 'e goufinai mamasia ka 'oka.’” ");
INSERT INTO lgl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na Sabat, atoa ala mamalona li, Jesus failia wale li galona lia gi daulu la la, ma daulu ka liu faifolo 'i laola te raku witi, 'are fala galofinala berete li. Ma talasi daulu liu ai, wale li galona lia gi daulu ka 'oia nali funi 'are, ma daulu ka 'arada 'i laola limadaulu, ma daulu ka 'anida. ");
INSERT INTO lgl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma talasi wale ala Farasi gi gera lesia, gera ka sae 'uri 'e, “Me 'are 'e moulu taua 'e 'oia taki Moses, sulia moulu fisua witi 'e ala Sabat, atoa ala mamalona li.” ");
INSERT INTO lgl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus ka olisi 'uri 'e adaulu, “Lau saiai moulu iidu sulia 'i laola Buka Abu 'are ba David walelitalona 'e taua 'i lao. Ala talasi fo, David failia wale lia gi daulu fiolo rasua, ");
INSERT INTO lgl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ma ka la 'i laola luma God, ma 'ilito'ola fata abu ka kwatea fala David berete fo gera fa abua fala God gi. Ma David ka 'ania lo berete fo, ma ka kwatea lou fala wale lia gi, ma gera ka 'ania. Wasua ma taki gia 'e ala'alia talifilia fata abu God gi mola gera saiala 'aninai. Ma iko 'ali golu lesia 'i laola Buka Abu 'ali God 'e ogata'a mola fala David.” ");
INSERT INTO lgl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sui Jesus ka sae lo 'uri 'e, “'I lau, Wela Wale li, lau too ala nanatana fala iilinala 'are fala ioli gera saiai gera ka taua mola 'ada ala atoa ala mamalona li.” ");
INSERT INTO lgl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma ala na fe atoa ala Sabat lou, Jesus ka la 'i laola luma fala foana li ma ka faalalau. Ma te wale 'e io lou 'i lififo li fili lima aolo ala 'e mae. ");
INSERT INTO lgl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma nali wale falalau ala taki gi, failia Farasi gi, gera io lou 'i lififo, ma gera ka liolio fala Jesus ala kae guraa wale fo ala Sabat, atoa ala mamalona li. Ala 'e 'urifo, gera ka sae maala Jesus 'alia 'oinala taki God ala gurana li, me 'are fo gera malata sulia 'e malaa lou galo na. ");
INSERT INTO lgl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma Jesus 'e sai mola 'ala ala malatada, ma ka sae 'uri 'e fala wale fo limala 'e mae, “Tatae, ko ura mae 'i lao ala ioli 'e gi sui.” Ma wale fo ka tatae, ma ka la mae 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma Jesus ka sae 'uri 'e fala Farasi gi, ma wale falalau ala taki gi li, “Lakae soilidi 'amoulu ga, Taa taki golu 'e ala'alia 'ali golu taua ala atoa ala mamalona li? 'E ala'alia taunala 'are 'oka gi, 'o ma taunala 'are ta'a gi? 'E ala'alia faamurinala ta ioli, 'o ma rauninala ta ioli?” ");
INSERT INTO lgl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesus 'e sae 'urifo ka sui, ka lio kwailiu fadaulu, mola ka sae 'uri 'e fala wale fo limala 'e mae, “Tadaa mae limamu.” Ma ka tadaa, ma limala ka 'oka lo. ");
INSERT INTO lgl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ala talasi gera lesia, gera ka ogata'a rasua, ma gera ka alaa ruru ma gera ka fou malata fala ta me 'are 'ali gera taua ala Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ala na talasi lou, Jesus ka rae fala gwaula fe uo 'ali 'e foa. Ma 'i laola boni laulau fo, 'i lia 'e foasia God. ");
INSERT INTO lgl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Talasi 'e 'ofaedani lo, ka soia mae wale li galona lia gi 'i so'ela, ma ka filia akwala wala rua wale, ma ka soida 'alia wale li lifurono gi. ");
INSERT INTO lgl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ratada: Simon lia Jesus fafurata 'alia Peter, ma Andrew walefae lia, ma James, John, Filip, Batolomiu, ");
INSERT INTO lgl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, Tomas, ma James wela Alfeas, ma Simon na wale ala wale Jiu gi gera oga balinala wale 'i Rom gi faasia 'i Israel, ");
INSERT INTO lgl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma Judas wela James, ma Judas Iskariot te wale kae foli'alia Jesus fala malimae lia gi li. ");
INSERT INTO lgl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus 'e sifo mae faasia 'i gwaula fe uo fo failia akwala wala rua wale wale li lifurono lia gi, ma ka ura ala me lifi ote failia logona ba'ela la nali ioli 'i laola ioli li galona lia gi lou. Ma nali ioli afula lou gera la mae faasia gulae tolo 'i Judea, ma failia falua ba'ela 'i Jerusalem, ma falua 'i Taea ma 'i Saedon gi lia gera io sulia asi li, gera io lou 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Gera la mae fala rononala Jesus, ma 'ali Jesus ka gurada faasia mataina gera gi. Ma ioli gera too ala aloe 'are ta'a gi li, gera la lou mae, ma Jesus ka gurada. ");
INSERT INTO lgl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ioli sui gera mailia 'ali gera dau tonala Jesus, sulia nanatanala 'e la ko faasia fala guranala ioli sui. ");
INSERT INTO lgl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus ka lio ko fala wale li galona lia gi ma ka sae 'uri 'e, “'Oilakina famiu ioli 'e 'amu siofa gi, sulia God kae 'ilitoa fafi 'amiu. ");
INSERT INTO lgl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'Oilakina famiu ioli 'e 'amu fiolo ala talasi 'e li, sulia 'amu kae bote. 'Oilakina famiu ioli 'e 'amu aani ala talasi 'e li, sulia 'amu kae wasi. ");
INSERT INTO lgl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'Oilakina famiu talasi ioli kae malakwaita amiu, ma gerakae lulu 'amiu, ma gera ka sae fafuta'a 'amiu, ma soi ta'a amiu, sulia 'amu ronosuli lau Wela Wale li. ");
INSERT INTO lgl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","'Amu babalafe, ma 'amu ka wae sakasaka 'alia babalafena ba'ela talasi ioli kae tau 'uri la amiu, sulia kwaiarana ba'ela 'e maasi 'amiu 'i nali. Lau iilia 'are 'e sulia gera kae taua lou 'are ta'a amiu lia koko 'ualo gera gi gera taua ala profet 'i lao mae gi. ");
INSERT INTO lgl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Wasua ma, kae ta'a ka ba'ela famiu ioli 'e 'amu too ala too 'arena gi li ala talasi 'e li, sulia wawaelana gi 'amu too sui lo ali. ");
INSERT INTO lgl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kae ta'a ka ba'ela famiu ioli 'e 'amu fana bote ala talasi 'e li, sulia 'amu kae fiolo. Kae ta'a ka ba'ela famiu ioli 'e 'amu wasi ala talasi 'e li, sulia 'amu kae lagu, ma 'amu kae ani. ");
INSERT INTO lgl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","'E ta'a ka ba'ela famiu talasi ioli kae soi 'oka amiu, sulia koko 'ualo gera gi, gera tau lou 'are fo gi fala profet kotokoto gi 'i lao.” ");
INSERT INTO lgl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesus 'e faalalau lou 'uri 'e, “Lakae ilia famiu ioli 'e 'amu rono sulia saenagu gi, 'amu ka kwaima ala malimae 'amiu gi, ma 'amu ka tau 'oka fala ioli gera malakwaita amiu gi. ");
INSERT INTO lgl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma 'amu ka foasia God, 'ali 'e fa'oka ioli 'e gera 'uasi 'amiu gi, ma 'amu ka foa fala ioli gera taua 'are ta'a gi amiu. ");
INSERT INTO lgl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma ala ta wale ka fidalia babalimu, 'o ala'alia ka fidalia lou ta fili babali amu. Ma ala ta ioli ka sakea to'omi fafu ba'ela 'o, 'o ala 'alia ka sakea lou toro 'o 'ala. ");
INSERT INTO lgl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma ko kwate 'ala ta ioli mola 'ala 'e sugaa ta me 'are amu. Ma ala ta ioli 'e sakea ta 'are ala 'are 'o gi, ikoso 'ali 'o sugaa lou 'ali 'e olifailia mae famu. ");
INSERT INTO lgl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ta taa 'amu oga ioli mamata gi gera ka taua famiu, 'amu ka taua lou fada. ");
INSERT INTO lgl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ma ala 'amu kwaima mola ala ioli 'e gera kwaima amiu gi, ikoso 'ali 'amu sakea mola ta kwaiarana. Sulia ioli ta'a gi wasua, gera kwaima lou ala ioli fo gera kwaima ada gi. ");
INSERT INTO lgl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma ala 'amu tau 'oka mola fala ioli gera tau 'oka famiu gi, ikoso 'ali 'amu sakea mola ta kwaiarana. Sulia ioli ta'a gi wasua gera tau lou 'urila. ");
INSERT INTO lgl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma ala 'amu kwate 'are mola fala ioli gera saiai gera kae duu famiu gi, ikoso 'ali 'amu sakea mola ta kwaiarana. Sulia ioli ta'a gi wasua, gera tau lou 'urila fala ioli ta'a gi, 'ali gera duu lou fada. ");
INSERT INTO lgl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wasua ma 'amu ka kwaima ala malimae 'amiu gi, ma 'amu ka tau 'oka fada, ma 'amu kwate 'are ma ikoso 'ali 'amu maasia lou duunali. Ala 'amu tau 'urifo, 'amu kae sakea kwaiarana ba'ela, ma abulonamiu kae malaa God mama 'amiu lia 'e 'ilitoa ka tasa. Sulia God 'e tau 'oka fala ioli ta'a gi ma ioli iko 'ali gera babalafe fafia taa God 'e taua fada. ");
INSERT INTO lgl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","'Amu ka kwaiaamasi ala ioli, ka malaa lou Mama 'amiu lia 'e kwaiamasi amiu. ");
INSERT INTO lgl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“'Amu alua iili ioli na, taufasia God 'e bi suafafi amiu lou. Ma ikoso 'ali 'amu iili kwaikwaina fala ta ioli mamata, 'ali God ikoso kwate kwaikwaina lou famiu. 'Amu ka kwailufa ala ioli sui, ma God kae kwailufa lou amiu. ");
INSERT INTO lgl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","'Amu ka kwate 'ala ioli, 'ali God ka kwate lou 'amiu. Ma God kae kwatea kwatena 'e malaa te wale ba 'e fafonua te wai 'are ka nekenekea, la la ka fonu mabusu lo. Ma God kae kwate 'amiu, malaa lou 'amu kwate 'ala ioli mamata gi.” ");
INSERT INTO lgl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesus 'e sae lou sulia tarifulaana fada 'uri 'e, “Ta wale maala 'e koro, 'e 'ato ka talaia lou ta wale maala 'e koro. Ala ka tau 'urila, 'i daroa sui mola daro kae toli 'i laola gilu. ");
INSERT INTO lgl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ioli 'e kae raerae malata mola 'ala, 'e 'ato ka liufia ioli 'e faalalau lia. Ma ala ioli raerae malata 'e sake sui 'are fo ioli faalalau 'e kwatea fala gi, 'i lia 'e malaa lo ioli faalalau lia. ");
INSERT INTO lgl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“'O too ala ta'ana ba'ela gi, wasua ma 'o balufia 'amua ioli 'e too ala ta'ana wawade gi li. 'O malaa te wale 'e lesia me goraa 'i laola maala walefae lia li, wasua ma iko 'ali 'e lesia mola te babae wado ba'ela 'i laola maala 'i talala. ");
INSERT INTO lgl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma ko sae 'uri 'e fala ioli mamata, ‘Ko ala tau nala ta 'are ta'a.’ Wasua ma iko 'ali 'o malata 'abero mola ala ta'ana ba'ela 'e 'o tauda gi. 'I'o ioli 'asa 'i'o. 'O tafisia ga ta'ana 'o gi. Sui, ko bi totolia kwairanaina ala ta ioli mamata fala ta'ana lia gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jesus ka sae lou 'alia te tarifulaana fada 'uri 'e, “Fe 'ai 'e bulao ka 'oka, 'e 'ato ka funu 'alia fuae 'are ta'a gi. Ka malaa lou, ta 'ai 'e bulao ka ta'a, 'e 'ato ka funu 'alia fuae 'are 'oka gi. ");
INSERT INTO lgl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Golu saiala 'ai gi sui 'alia fufuae 'are gera funu 'alida gi. Ma 'e 'ato ta ioli ka fisua fufuae 'ai 'oka faasia kwalokarakaraa. ");
INSERT INTO lgl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma ioli 'oka ka taua lou 'are 'oka gi sulia malatae ioli rao lia. Ma ioli ta'a ka taua lou 'are ta'a gi sulia malatae ioli midia lia. 'Are 'e io 'i laola manola ioli li, lia lo kae latafa mae 'alia saenala.” ");
INSERT INTO lgl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ma Jesus ka sae lou 'uri 'e, “'Uta 'e, ala talasi 'amu alaa faelau, 'amu ka soi lau 'alia Aofia, wasua ma iko 'ali 'amu tau mola sulia 'are 'e lau ilida famiu gi? ");
INSERT INTO lgl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ta ioli mola 'ala 'e la mae 'i soegu, ma ka rono sulia saenagu, ma ka tau sulia, lakae fatailia famiu fitoona lia, failia ionala. ");
INSERT INTO lgl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","'E malaa wale 'e raunailia luma lia, ka 'elia fulu 'ai gi ka laliu. Talasi uuta ka too, ma kwai 'e busu mae, 'e 'ato ka osia, sulia 'e raunailia luma lia 'i fofola fulu 'ai 'e 'elia ka laliu gi. ");
INSERT INTO lgl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma ioli 'e ronoa saenagu, ma iko 'ali tau sulia, 'e malaa wale 'e raunailia luma lia 'i fofola ole li, iko 'ali 'elia fulu 'ai 'ali 'e laliu mola. Talasi kwai 'e busu mae, ma ka foto ala luma fo li, luma fo ka toli, ma ka tagalo sui lo.” ");
INSERT INTO lgl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Talasi Jesus 'e faasuia lo saenala fala ioli fo gi li, ka la lo fala falua 'i Kapaneam. ");
INSERT INTO lgl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma te wale 'i lififo li, 'e matai ka ba'ela ma ka garani mae lo. Wale fo, 'i lia wale 'e galo 'ala te wale ba'ela ala wale li mae faasia falua ba'ela 'i Rom li. Ma wale ba'ela fo, 'e lio ba'ela rasua ala wale li galona lia. ");
INSERT INTO lgl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma talasi wale ba'ela fo 'e ronoa Jesus 'e dao mae, ka keria nali wale etaeta ala Jiu gi, 'ali gera soia Jesus ka la mae, 'ali guraa wale li galona fo lia. ");
INSERT INTO lgl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Talasi gera dao 'i so'ela Jesus, gera ka aniulu, gera ka sae 'uri 'e, “Te wale ba'ela 'e 'e totolia ko kwairanai ala wale li galona lia, ");
INSERT INTO lgl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sulia wale ba'ela fo 'e kwaima rasua amami Jiu gi, ma ka raunailia te luma fala foana li 'amami 'i lifi'e.” ");
INSERT INTO lgl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","'Urifo Jesus ka la lo failida. Ma talasi 'e dao garania lo ko luma li, wale ba'ela fo 'i Rom ka keria lou ko wale kwaima lia gi, 'ali gera sae 'uri 'e fala, “Arai ba'ela, ko ala 'abero na. Iko 'ali lau totolia 'ali 'o la mae 'i laola luma lau. ");
INSERT INTO lgl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma 'i lau wasua lou iko 'ali lau totolia lou laa na ko 'afi 'o 'i talagu. 'O sae mola ma wale li galona lau ka 'akwaa lo. ");
INSERT INTO lgl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Lau saiai 'o totolia mola 'amua taunala 'are 'urifo, suli 'i lau talagu wale lau galo 'i malula wale ba'ela gi li, ma laka too ala wale li mae gi gera galo 'i malula nanatana lau. Ma ala lau iilia fala ta wale laka sae 'uri 'e, ‘'O la,’ 'i lia ka la lo. Ma ala laka ilia fala ta wale laka sae 'uri 'e, ‘'O la mae,’ 'i lia ka la lo mae. Ma ala laka ilia fala ta wale li galona ulafu ma laka sae 'uri 'e, ‘'O taua 'are 'e,’ 'i lia ka taua lo.” ");
INSERT INTO lgl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ala talasi Jesus 'e ronoa 'are fo li, ka 'afero rasua. Ma ka bulusi, ka sae 'uri 'e fala ioli fo gera la 'i burila gi, “Lakae ilia famiu, iko 'ali lau lesia 'ua ta ioli 'i Israel 'ali fitoo 'uri 'e.” ");
INSERT INTO lgl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma wale li sake alaana fo gi, gera ka oli fala 'i luma wale ba'ela fo li, ma gera ka lesia wale matai ba 'e 'akwaa lo. ");
INSERT INTO lgl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma iko 'ali tekwa mola 'i burila 'are fo gi, Jesus failia wale li galona lia gi, ma ioli afula gi lou, gera la fala te falua gera soia 'alia 'i Nein. ");
INSERT INTO lgl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma talasi 'e dao garania maala geti ala falua fo li, te logona gera sakea mae te wale mae, ma gera ka la lo mae 'i maluma. Te wale mae fo, 'i lia ulufa'alu moutae me geli 'oru li. Ma logona ba'ela fo gera ka la mae failia fala alominala. ");
INSERT INTO lgl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ma talasi Jesus, Aofia, 'e lesia me 'oru fo li, ka aamasi rasua ala, ma ka sae 'uri 'e fala, “'O ala ani na.” ");
INSERT INTO lgl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sui ka la ko, ma ka dau tonala tafe fo wale mae fo 'e teo 'i laola, ma wale fo gera awailia wale mae fo li, gera ka ura too. Mola Jesus ka sae 'uri 'e, “Wale ulufa'alu 'e, lau iilia famu, 'o tatae!” ");
INSERT INTO lgl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma ulufa'alu ba ka tatae lo, ma ka fuli'ae ka alaa. Ma Jesus ka kwatea lo fala teite lia. ");
INSERT INTO lgl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma ioli gera lesia 'are fo gi li, gera 'afero rasua, ma gera ka batafea God 'uri 'e, “Te profet 'ilitoa 'e fatae lo mae 'i safitaga. God 'e dao lo mae fala rananaga ioli lia gi.” ");
INSERT INTO lgl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma alaana sulia Jesus, ka talo lo 'i laola 'afutala lifi 'i Israel, failia falua galia gi lou. ");
INSERT INTO lgl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ala talasi wale li galona John gi gera faarono lia 'alia galonala Jesus, John ka soia mae rua wale li galona lia gi 'i so'ela, ");
INSERT INTO lgl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma ka keri daroa 'i so'ela Jesus, Aofia, fala soilidinala 'uri 'e, “'Uri'e ma 'i'o lo 'e Christ, wale 'e kae dao mae 'o ma meulu ka maasia lou 'ameulu ta wale mamata?” ");
INSERT INTO lgl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ma talasi daro li dao 'i so'ela Jesus, daro ka soilidi 'uri 'e ala, “John wale fasiuabu 'e keri 'ameroa mae fala soilidinamu, 'Uri'e ma 'i'o lo 'e Christ, wale 'e kae dao mae, 'o ma meulu ka maasia lou 'ameulu ta wale mamata?” ");
INSERT INTO lgl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma ala talasi fo lou, Jesus 'e guraa ioli matai afula gi, ma ka balia aloe 'are ta'a gi faasia ioli gi, ma ka guraa ioli maada koro gi. ");
INSERT INTO lgl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Lia fo Jesus ka sae 'uri 'e fadaroa, “Mora oli mora ka faronoa John 'alia 'are 'e mora lesida gi, ma mora ka ronoda 'i tara'ela gi. Ioli maada koro gi, gera lio lo. Ma ioli 'aeda mae gi, gera ka liu lo. Ma ioli kuu 'e odeda gi, gera ka mafo lo. Ma ioli aninada bali gi, gera rono lo. Ma ioli gera mae gi, gera mauri lou. Ma Faronona 'Oka, lau faatalo lo 'alia fala ioli siofa gi. ");
INSERT INTO lgl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","'Oilakina God fala ioli iko 'ali gera barasi 'ali lau 'i fofola 'are lau tauda gi.” ");
INSERT INTO lgl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","'I burila rua wale li galona John gi daro oli lo, Jesus 'e fuli 'ae ka alaa sulia John fala ioli gera logo 'i lififo gi 'uri 'e, “Ala talasi 'amu la 'i so'ela John 'i laola abae lifi kwasi li, ta taa 'amu la fala lesinai 'i lififo? Te wale iko 'ali 'e fakwalaimoki ka malaa mola 'ala me gwano rade 'e saola ala oru li? Iko! John iko lou wale 'urifo. ");
INSERT INTO lgl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'Uri'e ma, taa 'amu la fala lesinai? Te wale 'e toro 'alia to'omi folifolinai ba'ela? Iko! Sulia wale gera toro 'urifo gi, gera too 'are, ma gera ka io 'i laola luma 'oka rasua gi. ");
INSERT INTO lgl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","'Amu famadakwa lau mae. Taa 'amu la ko fala lesinai? Te profet? 'Eo! 'I lia profet kwalaimoki! Ma 'e liufia rasua profet 'i lao gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","John ba gera geregere sulia 'i laola Geregerena Abu ala talasi God 'e sae 'uri 'e, ‘Lio ga, lakae keria wale li sake alaana lau 'i lao amu, 'ali ka rereia ioli gi famu.’” ");
INSERT INTO lgl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesus ka sae lou 'uri 'e, “Lakae ilia famiu, John 'e 'ilitoa ka liufia ioli gera futa mae 'i laola molagali 'e gi li sui. 'Urifo wasua, ioli 'e gera fawawade gera 'i talada gi 'i laola Tatalona God, gera ba'ela ka tasa rasua liufia John.” ");
INSERT INTO lgl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ioli gera ronoa saenala gi sui, ma wale goli bata ala takisi gi li wasua, talasi gera rono sulia saenala Jesus, gera ka saiai teke tala God mola 'e rada ma ka kwalaimoki, sulia gera bulusi, ma John ka fasiu abu gera sui. ");
INSERT INTO lgl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ma Farasi gi failia wale falalau ala taki gi li, 'i osiala gera 'e'ela 'alia bulusi na ma sisiuabuna ala John, 'e iko 'ali gera oga mola ronona sulia kwaiogalina God 'e rerei 'alia fada. ");
INSERT INTO lgl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma Jesus ka sae lou 'uri 'e fada, “Lakae fafuradani 'amiu io namiu ioli la talasi 'e, lia iko 'ali 'amu fakwalaimoki gi, 'amu malaa wela wawade ");
INSERT INTO lgl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","'e gera logo 'i maala uusina 'alia rua logona gi li. Ma gera ka rii kwailiu fada, ‘Meulu uufi 'au, ma iko 'ali moulu wae mola sulia. Ma meulu ka nulia fe nuu sulia maena li famoulu, ma iko 'ali moulu kwaimalatai mola.’ ");
INSERT INTO lgl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Talasi John wale Fasiuabu 'e dao mae, 'e abu fana, ma iko 'ali goufia ta waen, ma 'amu ka iilia 'uri 'e too ala aloe 'are ta'a. ");
INSERT INTO lgl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sui, talasi 'i lau, Wela Wale li, lau dao mae, lau fana ruru, ma laka gou failia ioli gi, ma 'amu ka sae lou 'uri 'e, ‘'Amu lesia! 'E fana ba'ela, ma ka gou ba'ela ala waen, ma ka kwaima failia ioli gera goli bata ala takisi gi li ma ioli taunada ta'a gi lou.’ ");
INSERT INTO lgl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wasua ma, ioli gera ronosulia liotoo God gi li, gera fatailia lia 'e God 'e kwalaimoki.” ");
INSERT INTO lgl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Te wale ala Farasi gi li ratala Simon, 'e kwaloa Jesus 'ali ka fana failia. Ma Jesus ka la 'i luma lia, ma ka gwauru ka uluna faeburi, ma ka fana failia. ");
INSERT INTO lgl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma te geli abulonala 'e ta'a 'e io lou 'i laola falua fo. Ala talasi geli fo 'e saiala Jesus kae fana 'i laola luma Farasi fo li, ka sakea mae te botole 'e fonu 'alia waiwai 'e si'ina 'oka rasua li. ");
INSERT INTO lgl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma ka ruu 'i laola luma, ka ura 'i burila Jesus totolala 'aela, ka ani, ma ka faawasiua 'aela Jesus 'alia kwai la maala. Sui, ka faalanaa 'aela Jesus 'alia ifula, ma ka lotofia. Sui ka nikia waiwai si'ina fofo 'oka fo 'i fofola 'aela Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma talasi Farasi fo 'e kwaloa Jesus 'e lesia me 'are fo li, ka malata 'ala 'uri 'e, “Ala wale 'e profet, ka saiala abulonala geli 'e 'e ta'a rasua.” ");
INSERT INTO lgl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma Jesus ka saiala malata Farasi fo li, ma ka sae 'uri 'e fala, “Simon wale'e! Te 'are lau oga lakae ilia famu.” Ma Simon ka sae 'uri 'e, “Waleli Falalauna, 'o ilia mae fagu.” ");
INSERT INTO lgl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus ka sae 'uri 'e fala, “Rua wale gi daro sake lana ala seleni faasia te wale la kae kwatekwate lana ala seleni gi. Te wale 'e sake lana ala lima talanae seleni gi, ma na wale ka sake lana ala lima akwala seleni gi. ");
INSERT INTO lgl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma 'i daroa sui iko 'ali daro totolia duunala seleni fo gi, ma wale fo 'e ala'alia sake lanana fo fadaroa ka kwailufa lo 'alia sake lanana daroa gi sui. 'Uri fo ma ite adaroa lo 'e babalafe ka tasa rasua, ala rua wale fo 'e kwatea seleni fo gi fadaroa?” ");
INSERT INTO lgl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma Simon ka olisi 'uri 'e ala, “Lau fia mala wale fo 'e sakea seleni afula gi li.” Ma Jesus ka sae 'uri 'e, “'O olisi rada ai.” ");
INSERT INTO lgl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sui Jesus ka bulusi fala geli fo, ma ka sae 'uri 'e fala Simon, “'O lesia ga geli 'e. Talasi lau ruu mae 'i laola luma 'o li, iko 'ali 'o kwatea mola ta kwai fagu fala saunala 'aegu. Wasua ma, 'i lia 'e saua 'aegu 'alia kwai la maala, ma ka faalanaa 'alia ifula gwaula. ");
INSERT INTO lgl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma iko 'ali 'o kwalo lau mola 'alia lotofinagu. Ma geli 'e, 'e fuli ala talasi ba lau ruu mae 'i luma, 'e fuli lo ala lotofinala 'aegu. ");
INSERT INTO lgl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma iko 'ali 'o waiawaia mola gwaugu 'alia ta waiwai. Ma geli 'e, 'e nikia waiwai si'ina 'oka 'e 'i 'aegu. ");
INSERT INTO lgl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Lia fo, laka ilia famu, kwaimanaa ba'ela lia, 'e fatailia rerona afula lia gi gera alafu sui lo. Wasua ma, ite kwailufana 'alia ta'ana lia gi li 'e wawade, me kwaimanaa lia ka wawade lou.” ");
INSERT INTO lgl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sui Jesus ka sae 'uri 'e fala geli fo, “Lau kwailufa lo 'alia ta'ana 'o gi.” ");
INSERT INTO lgl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma nali ioli gera io 'i lififo, gera ka ogata'a fala Jesus, ma gera ka sae kwailiu 'uri 'e 'i safitada, “Te wale 'utaa 'e 'e saiala kwailufana 'alia ta'ana gi li 'uri 'e?” ");
INSERT INTO lgl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sui Jesus ka sae 'uri 'e fala geli fo, “'O la lo 'alia aroarona. God 'e faamauri 'o, sulia 'o fakwalaimoki.” ");
INSERT INTO lgl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","'I burila 'are fo gi, Jesus ka la lo ala falua wawade gi, failia falua ba'ela gi, ma ka farono 'alia Faronona 'Oka sulia God kae 'ilitoa fafia ioli lia gi li. Ma akwala wala rua wale li galona lia gi, daulu la lou failia, ");
INSERT INTO lgl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma nali geli lou lia Jesus 'e balia aloe 'are ta'a gi failia mataina gi faasida. Ma geli la gi 'e: Mary, geli 'i Magdala lia ba Jesus 'e balia fiu aloe 'are ta'a gi faasia, ");
INSERT INTO lgl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma Joana, wateu Kusa wale ba'ela ala wale gera galo 'i laola luma Herod walelitalona gi, ma Susana, ma nali geli afula lou. Geli fo gi fo gera foli 'are 'alia bata gera gi fala rananala Jesus failia wale li galona lia gi. ");
INSERT INTO lgl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ioli afula gi gera logo mae 'i so'ela Jesus. Gera la mae faasia falua mamata kwailiu gi sui. Jesus ka sae 'alia tarifulaana fada 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Te wale 'e la ka tagalailia fufuae 'are gi 'i laola raku witi lia. Ma ala talasi kae tagalailia fufuae 'are fo gi li, nali fufuae 'are gera toli sulia talaliliu. Ma ioli gi gera liu, ma gera ka urida, ma malu gi gera ka 'anida lou. ");
INSERT INTO lgl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nali fufuae 'are ka toli 'i fofola wado faufaua. Ma talasi gera bulao mae, 'e nainali mola gera ka kuku lo, sulia wado fo iko 'ali too ala ta kwai. ");
INSERT INTO lgl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma nali fufuae 'are ka toli lou 'i safitala kwalo karakaraa gi. Ma kwalo karakaraa gi gera ka bulao mae failia fufuae 'are 'oka gi, ma gera ka lolo fafia witi fo gi. ");
INSERT INTO lgl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma nali fufuae 'are ka toli lou 'i fofola wado 'oka, ma gera ka bulao, ma gera ka funu 'alia fuae 'are afula rasua gi.” Ma Jesus ka faasuia saenala 'uri 'e, “Ala ta ioli 'e oga ka sai 'oka ala 'are 'e gi, 'i lia ka fafurono 'oka.” ");
INSERT INTO lgl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sui wale li galona Jesus gi gera ka soilidia fala fadanala tarifulaana fo, ");
INSERT INTO lgl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ma ka olisi 'uri 'e adaulu, “Talasi sui gi, God iko 'ali faamadakwa kae 'ilitoa 'utaa fafia ioli lia gi. Wasua ma 'i tara'ela, madakwana 'e dao lo famiu. Fala ioli 'e iko lou wale li galona lau gi li, lau sae 'alia tarifulaana gi, ma iko 'ali lau faamadakwa, 'ali ‘Gera ka fafurono, ma geraka fafurono, wasua ikoso gera saiala faronona God. Ma gera kae lio, ma gera kae lio, wasua ikoso gera lesia taa 'e God 'e taua fada.’” ");
INSERT INTO lgl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","'Urifo, Jesus ka sae lou 'uri 'e, “Fadanala tarifulaana fo 'e 'uri 'e: Fufuae 'are, 'e malaa saenala God. ");
INSERT INTO lgl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Fufuae 'are fo gera toli sulia talaliliu gi li, gera malaa ioli fo gera ronoa saenala God gi, ma Saetan ka la mae ka lafua alaana fo gi faasi gera. Lia fo 'e kwate iko 'ali gera fakwalaimoki fala maurinada. ");
INSERT INTO lgl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma fufuae 'are gera toli 'i fofola wado 'e faufaua li, 'e malaa ioli fo gera ronoa saenala God, ma gera ka sakea failia babalafena. Wasua ma, saenala God iko 'ali laliu mola 'i laola maurinada. Gera ka fakwalaimoki mola sulia talasi wawade. Ma talasi ilitoona 'e dao mola ai, iko 'ali gera fakwalaimoki lo. ");
INSERT INTO lgl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Fufuae 'are fo gera toli 'i safitala kwalo karakaraa gi li, 'e malaa ioli 'e gera rono, wasua ma gera ka malata 'abero 'ada sulia 'are mamata gi li, malaa too 'arena gi, ma babalafena gwaugwau 'i laola molagali li lia 'e 'e bebesida. 'Are la fo 'e taua gera ka ba'ela dole. ");
INSERT INTO lgl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Fufuae 'are fo gera toli 'i fofola wado 'oka gi li, 'e malaa ioli 'e gera ronoa saenala God ma gera ka golia 'i laola malatae ioli aolo ma ka 'oka. Ma gera ka galo nanata 'alia fitoona fala taunala galona 'oka afula gi.” ");
INSERT INTO lgl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesus ka sae lou 'uri 'e, “Iko ta ioli 'ali fakwarua ta fe ulu, ma ka alua mola 'ala 'i malula ta dako 'o ma ta tafe. Ma kae alua lo 'i fulila, 'ali ioli fo 'e ruu mae 'i luma kae lesia. ");
INSERT INTO lgl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“'E 'urifo lou ala ta 'are 'e io agwaagwa ala talasi 'e, ta atoa kae fatae sui. Ma nali alaana gera kufi fafia, kae la tafa sui mae 'i maluma. ");
INSERT INTO lgl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Lia fo 'amu ka fafurono 'oka, sulia God kae kwate afula ala liotoo famiu, ala 'amu ka ronosulia falalauna lau gi li. Ite 'e too ala ta madakwana wawade sulia 'ilitoana God, God kae kwate baela fala. Ma ta ioli 'e iko 'ali ronosulia falalauna 'e gi, ta madakwana wawade wasua 'e fia 'uri 'e too ai sulia 'ilitoana God, God kae olifailia faasia.” ");
INSERT INTO lgl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'I burila, teite Jesus failia walefae lia gi, daulu ka dao mae, ma daulu ka oga lesinala, ma 'e 'ato fadaulu fala 'idu garaninala, sulia ioli afula gi gera logo galia Jesus ala talasi fo. ");
INSERT INTO lgl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma te wale 'i laola logona fo li ka sae 'uri 'e fala Jesus, “Teite 'o failia walefae 'o gi, daulu ura mola mae 'adaulu 'i maluma, ma daulu oga leesinamu.” ");
INSERT INTO lgl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesus ka sae 'uri 'e fada sui, “Ite ioli gera ronoa, ma gera ka tau sulia saenala God, 'i gera lo 'e teite lau gi, failia walefae lau gi.” ");
INSERT INTO lgl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Te talasi, Jesus failia wale li galona lia gi, daulu tae 'i laola te baru, ma ka sae 'uri 'e fadaulu, “Golu tofolo ga fala gulae 'osi lobaa.” Ma daulu ka fuli'ae, daulu ka tofolo lo. ");
INSERT INTO lgl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma ala talasi daulu la lo ko, Jesus ka mo'osu 'ala. Ala talasi fo mola, oru ba'ela ka tatae mae, ma lafolafo gi ka mabita lo mae 'i laola baru fo, ma baru fo ka garani wawalo lo. ");
INSERT INTO lgl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Waleli galona lia gi gera ka fa adaa Jesus gera ka sae 'uri 'e, “Arai wale'e! Golu kae garani wawalo lo!” Sui Jesus ka tatae ka balufia oru failia lafolafo fo 'e mabita mae, ma gera ka ronosulia, ma 'osi ka beata lo. ");
INSERT INTO lgl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sui Jesus ka balufia wale li galona lia gi 'uri 'e, “'Uta 'e iko 'ali moulu fakwalaimoki lau?” Ma daulu 'afero, ma daulu ka mau, ma daulu ka soilidi kwailiu 'uri 'e, “Wale 'utaa lo 'ala 'e? 'E sae nanata mola, ma oru failia lafolafo ba'ela gi, daro ka rono lo sulia.” ");
INSERT INTO lgl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sui Jesus failia wale li galona lia gi, daulu ka tofolo 'i laola 'osi fo la la daulu ka dao ala gulae tolo 'i Gerasa, ala gulae 'osi 'e io fakiliu 'i gula looba faasia lifi 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ala talasi Jesus 'e sifo ko 'i rara faasia baru li, ka dao tonala te wale faasia lifi fo li. Wale fo, aloe 'are ta'a gi gera io ala, ma ka io dadala tekwa lo mae, ma iko 'ali io lou 'i laola ta luma. 'E io mola 'ala 'i laola bao fala alunala ioli mae gi li. ");
INSERT INTO lgl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ala talasi afula sui lo mae gi, gera firi fafia rua 'aela gi ma limala lou, ma gera ka alua wale lio folo gi fali lio sulia. Wasua ma, 'e mousia mola 'ala seni fo gi, ma aloe 'are ta'a fo gi gera ka tabalia fala 'i laola abae lifi kwasi. Ma talasi 'e lesia mola Jesus ai, ka akwa ba'ela, ma ka boururu lo 'i maala 'aela Jesus. Jesus ka sae 'uri 'e fala, “Aloe 'are ta'a fo, 'o latafa mae faasia wale 'e.” Ma wale fo ka rii 'uri 'e, “Jesus, 'I'o Wela God 'e nanata rasua li! Taa 'e 'o oga koe tau agu? Lau suga 'o ikoso kwatea ta kwaikwaina fagu.” ");
INSERT INTO lgl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus ka soilidia, “Ite ratamu?” Ma ka olisia 'uri 'e, “Ratagu wale afula li ofona.” 'E sae 'urifo sulia aloe 'are ta'a afula rasua gi gera io ala. ");
INSERT INTO lgl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Aloe 'are ta'a fo gi gera ka ani ulu fala Jesus 'ali ikoso balida fala 'i laola gilu laaliu fala kwaikwaina li. ");
INSERT INTO lgl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma boo afula gi, gera fana 'ada 'i babalila fe uo 'e garani lou lifi fo li. Ma aloe 'are ta'a fo gi, gera ka sugaa Jesus 'ali gera ka rufia 'ada bo fo gi. Ma Jesus ka ala'alida. ");
INSERT INTO lgl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gera latafa faasia wale fo, ma gera ka rufia lo boo fo gi sui. Boo fo gi sui, gera ka lalao lo fala me raeraena 'ato 'e toli fala 'i laola 'osi li, ma gera ka gimolo, gera ka mae sui lo. ");
INSERT INTO lgl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ala talasi wale fo gera lio sulia boo fo gi li gera lesia 'are fo li, gera ka tafi, ma gera ka faarono 'alia 'i laola falua fo ma falua wawade galia gi lou. ");
INSERT INTO lgl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ioli gera ronoa, gera la mae fala lesinala 'are fo 'e fuli. Ma talasi gera dao mae 'i so'ela Jesus, gera ka lesia wale fo aloe 'are ta'a 'e la lo faasia, ma ka gwauru lo 'ala 'i maala 'aela Jesus, ma ka toro lo, ma ka malata rada lo. Ma 'i gera sui gera ka mau. ");
INSERT INTO lgl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma wale gera lesia talasi fo Jesus 'e balia aloe 'are ta'a fo gi faasia wale fo li, gera ka alaa lo sulia fala ioli fo gera logo mae gi. ");
INSERT INTO lgl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sui ioli gera io ala lifi fo li sui, gera ka ilia fala Jesus 'ali 'e la lo faasida, sulia gera mau rasua. Sui Jesus ka tae lo 'i laola baru ka rerei fala laa na. ");
INSERT INTO lgl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Te wale ba aloe 'are ta'a 'e la faasia, ka aniulu fala Jesus 'uri 'e, “'O ala 'alia 'ali lau la fae 'o.” Ma Jesus ka keria ka sae 'uri 'e fala, ");
INSERT INTO lgl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“'O oli 'amua 'i falua 'o, ma ko faarono 'alia 'are 'e God 'e fulia famu gi.” Sui, wale fo ka oli lo fala falua lia, ma ka alaa lo sulia 'are fo Jesus 'e fulia fala gi. ");
INSERT INTO lgl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sui, ala talasi Jesus 'e oli lou mae faasia gulae 'osi looba li, ioli gi gera maasia, ma gera ka babalafe rasua fala lesinala. ");
INSERT INTO lgl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma te wale ratala Jaeras ka dao mae. Te wale fo 'i lia na wale etaeta 'i laola luma fala foana li. 'E la mae ka boururu 'i 'aela Jesus, ma ka ani ulu fala Jesus 'ali 'e la failia fala luma lia. ");
INSERT INTO lgl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sulia teke me welageli lia 'e matai, ma ka garani mae lo. Teke akwala wala rua fe falisi gi mola 'e ba'ela mae sulia. Ma talasi Jesus 'e laa failia, ioli afula gera logo galia lou. ");
INSERT INTO lgl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma te geli 'abu 'e tafalia 'e io lou 'i lififo. Te mataina ta'a fo 'e taua lo sulia akwala wala rua fe falisi gi. Ma ka fasuia lo too 'arena lia gi sui fala waleli gurana gi, wasua ma iko ta wale 'ali guraa mola. ");
INSERT INTO lgl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ma geli fo ka gali mae 'i burila Jesus, ma ka dau tonala 'aela to'omi Jesus, ma 'abu fo ka lana lo faasia ala talasi fo mola lo. ");
INSERT INTO lgl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesus ka soilidi 'uri 'e, “Ite 'e dau tonagu?” Ala talasi fo, logona fo sui gera ka tofe. Ma Peter ka sae 'uri 'e, “Arai wale'e, ioli afula 'e gera bebesi 'o lo.” ");
INSERT INTO lgl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wasua ma Jesus ka sae 'uri 'e, “Te ioli 'e dau tonagu, sulia lau saiai talasi nanatana lau 'e guraa te ioli li.” ");
INSERT INTO lgl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Geli fo 'e saiai Jesus 'e madafia lo, ka liu mae, ka lebelebe, ka mau, ma ka boururu 'i maala 'aela Jesus. Ma talasi ioli afula fo gera liofiifii fala, 'i lia ka faarono gera sui sulia ta fo 'e dau tonala Jesus fai, ma ka taua ka 'akwaa nainali lo. ");
INSERT INTO lgl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma Jesus ka sae 'uri 'e fala, “Geli 'e God 'e guraa 'o lo, sulia 'o fakwalaimoki lau. Laa lo 'amua, ma ikoso malata 'abero lo.” ");
INSERT INTO lgl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Talasi Jesus kae alaa mola 'ala 'ua, te wale ka dao lo mae faasia luma Jaeras, ka faronoa Jaeras 'uri 'e, “Me welageli ba 'o, 'e mae lo. Ikoso faa 'aberosia lou wale li faalalauna.” ");
INSERT INTO lgl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma Jesus 'e ronoa, ka sae 'uri 'e fala Jaeras, “Ikoso mau. Ala ko fakwalaimoki lau, ke welageli la 'o kae 'oka lou.” ");
INSERT INTO lgl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ala talasi gera dao ko 'i luma, Jesus ka talaia mola Peter, failia John, ma James failia mama ma teite wela fo li, daulu ka ruu 'i luma. Jesus ka luia ikoso ta ioli lou 'ali ruu faedaulu 'i luma. ");
INSERT INTO lgl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma logona fo sui, gera lagu, ma gera ka anisia wela fo. Sui Jesus ka sae 'uri 'e, “Moulu ala ani na. Wela 'e iko 'ali mae mola, 'e mo'osu mola 'ala 'e.” ");
INSERT INTO lgl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma gera ka wasi 'ada 'alia Jesus, sulia gera saiai wela fo 'e mae kwalaimoki lo. ");
INSERT INTO lgl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sui Jesus ka dau 'i limala wela fo, ma ka rii 'uri 'e, “Wela 'e 'o tatae lo!” ");
INSERT INTO lgl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma manola ka oli lou mae, ma ka tatae. Ma Jesus ka ilia fada 'ali gera ka kwatea ta fana fala. ");
INSERT INTO lgl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Teite lia failia mama wela fo li, daro ka 'afero rasua 'alia 'are fo. Sui Jesus ka lui daulu ikoso daulu alaa sulia 'are fo gi fala ta ioli. ");
INSERT INTO lgl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus 'e soia mae akwala wala rua wale li galona lia gi 'i so'ela. Ma ka kwatea nanatana failia 'ilitoana fala guranala mataina gi li, failia balianala aloe 'are ta'a gi fada. ");
INSERT INTO lgl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Lia ka kerida fala faatalona 'alia 'Ilitoana God, ma guranala ioli matai gi. ");
INSERT INTO lgl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma ka sae 'uri 'e fada, “Ikoso moulu dau fafia ta 'are fala lalana 'amoulu. Moulu ala sakenala ta fe kuba, ma ta wai, ma ta fana, ma ta bata, ma ta rua toro fala olisina. ");
INSERT INTO lgl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ma ala tali wale ala ta luma gera kwalo 'amoulu, moulu ka io babatoo 'i laola luma la, la la ka dao ala talasi la 'amu kae la ai. ");
INSERT INTO lgl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ala ta wale ala ta falua iko 'ali gera kwalo 'amoulu, moulu ka la 'amoulu faasida, ma moulu ka tafula goraa faasia 'aemoulu malaa faabasuna lo fada lia God kae lokokwaikwaina fada, dunala gera 'e'ela 'alia rononala saenala God.” ");
INSERT INTO lgl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma wale li galona gi gera laa, ma gera ka liu lo ala falua gi sui fala alaana sulia Faronona 'Oka sulia God, ma failia guranala ioli ala lifi gi li sui. ");
INSERT INTO lgl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ma ala talasi fo lou, Herod Antipas walelitalona 'i Galili, 'e ronoa alaana sulia 'are fo Jesus 'e tauda gi. Ma malatala ka boesia sulia nali ioli gera ilia 'uri John Fasiuabu 'e mauri lou, ");
INSERT INTO lgl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ma nali wale lou gera ka ilia lia 'alia Profet Elaeja, ma nali wale lou gera ka iilia 'i lia na profet 'ua mae 'i lao lia 'e tatae lou faasia maena. ");
INSERT INTO lgl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Mola ma Herod ka sae 'uri 'e, “John ba lau keria wale li ofona gi ka 'ole mousia lo gwaula! Ma wale 'utaa 'e gera alaa sulia 'uri 'e?” 'Urifo, ka fuli'ae ala talasi fo, Herod ka oga rasua ala lesinala Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma talasi akwala wala rua wale li lifurono Jesus gi gera oli lo mae faasia faatalona 'alia 'Ilitoana God ma guranala ioli matai gi li, gera ka alaa sulia 'are gera tauda gi. Sui, Jesus failia wale li galona lia gi, gera ka la talifilidaulu fala falua 'i Betsaeda. ");
INSERT INTO lgl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Wasua ma ala talasi fo, ioli gi gera ronoa lo Jesus kae liu, gera ka la lou sulia. Ma Jesus ka kwaloda, ma ka sae sulia 'Ilitoana God fada, ma ka faamauria lou ioli gera matai gi. ");
INSERT INTO lgl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma raurafi lo, talasi da'afi garani suu, akwala wala rua wale li galona lia gi gera ka la mae 'i so'ela, ma gera ka sae 'uri 'e, “'O ketaa logona 'e, 'ali gera ka la 'ada ala falua gi, ma gera ka daria ta fana failia ta lifi fala teona, sulia lifi 'e iko ta ioli 'ali io mola ai.” ");
INSERT INTO lgl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sui Jesus ka sae 'uri 'e fadaulu, “Moulu kwatea tali fana fada fala 'aninai.” Ma daulu ka olisi 'uri 'e ala, “Meulu too mola ala lima tofui berete gi, failia rua me lode ia gi. 'Uri'e ma 'o oga meulu ka lai folia mae fana fala logona ba'ela 'e li 'e?” ");
INSERT INTO lgl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Te logona fo 'e totolia lima to'oli wale gi fo gera io 'i lifi fo. Jesus ka sae 'uri 'e fala wale li galona lia gi, “Moulu ilia fada gera ka gwauru 'i fua 'alia lima akwala ioli 'ali gwaegwae ioli.” ");
INSERT INTO lgl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Buri 'ala wale li galona gi gera tau 'urifo ka sui, ioli gi sui gera ka gwauru lo 'i fua. ");
INSERT INTO lgl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sui Jesus ka sakea lima tofui berete fo gi, failia rua me lode ia fo gi, ma ka lio ala ala fala 'i nali, ma ka batafea God. Sui ka liia tofui berete fo gi, failia ia fo gi, ma ka kwatea fala wale li galona lia gi, 'ali gera ka tolinia ala ioli fo gi. ");
INSERT INTO lgl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ma gera sui gera ka fana, ma gera ka bote rasua. Ma wale li galona lia gi, gera ka golia fana 'e ore 'i laola akwala wala rua apira gi la la ka fonu. ");
INSERT INTO lgl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Te talasi Jesus 'e foa 'ala talifilia, ma wale li galona lia gi gera ka la mae 'i so'ela, ma 'i lia ka soilidida 'uri 'e, “Ite ioli gi gera soi lau 'alia?” ");
INSERT INTO lgl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma daulu ka olisi 'uri 'e ala, “Nali ioli gera ilia 'uri 'i'o John wale Fasiuabu lia 'e mauri lou. Ma nali ioli gera ilia 'uri 'i'o Elaeja lia 'e mauri lou. Ma nali ioli lou gera ilia 'uri 'i'o na wale ala profet ba 'i lao mae gi lia 'e mauri lou.” ");
INSERT INTO lgl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma Jesus ka soilidi daulu 'uri 'e, “Ma 'i 'amoulu moulu soi lau 'alia ite?” Peter 'e olisia ka sae 'uri 'e, “'I'o 'a Christ, wale God 'e filia fala rananala ioli lia gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sui Jesus ka sae nasi adaulu 'ali ikoso 'ali daulu faronoa lou ta ioli 'alia 'are fo. ");
INSERT INTO lgl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma ka sae lou 'uri 'e, “'I lau, Wela Wale li, lakae famalifii ka ba'ela rasua 'alia 'are afula gi. Ma wale etaeta gi, failia fata abu ba'ela gi, failia wale falalau ala taki gi li, gera kae barasi 'ali lau. Ma gera kae rauni lau, sui ala olula fe atoa, God kae tae lau lou fala maurina.” ");
INSERT INTO lgl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma Jesus ka sae lou 'uri 'e fadaulu sui, “Ite 'e oga kae dona lau, ikoso malata 'abero sulia 'are 'e ogada gi 'i talala. Atoa gi sui ka marabe fala donanagu, wasua ala talasi kae famalifii, ma ka mae ala 'ai rara folo li. ");
INSERT INTO lgl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ite 'e 'e'ela 'alia dona nagu dunala 'e oga kae tau 'ala sulia kwaiogalina lia 'i talala gi, 'i lia kae talafia maurina firi. Wasua ma ala ite 'e iko 'ali malata 'abero sulia 'are 'e ogada 'i talala gi, ma ka marabe kae mae fagu, 'i lia kae too ala maurina firi. ");
INSERT INTO lgl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ala ta wale 'e too ala 'are gi sui 'i laola molagali, talasi ka mae ma ka io tatau faasia God, 'are fo gi ikoso fulia mola ta 'okana fala. ");
INSERT INTO lgl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma ala ta ioli 'e mau fafi lau failia saenagu, 'urila 'I lau, Wela Wale li, lakae mau lou 'alia, ala talasi lakae dao mae failia wasinosinona lau li, failia wasinosinona Mama lau li, failia wasinosinona eniselo abu gi li lou. ");
INSERT INTO lgl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Lakae ilia lo famiu, nali ai amoulu 'i lifi'e, ikoso gera mae la la gera ka lesia God kae 'ilitoa fafia ioli lia gi.” ");
INSERT INTO lgl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Totolia kwalu atoa gi 'i burila Jesus 'e iilia 'are fo gi, ka talaia Peter, ma John, failia James, ma daulu ka rae 'i gwaula fe uo fala foana. ");
INSERT INTO lgl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma talasi Jesus 'e foa 'ala, maala ka olisi ka wasinosino, failia to'omi lia gi ka kaka'asiroaroa ma ka wasinosino rasua. ");
INSERT INTO lgl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma nainali mola rua wale gi daro ka io lou 'i lififo failia, ma daro ka alaa failia Jesus. 'I daroa Moses failia Elaeja. ");
INSERT INTO lgl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ma daro ka fatae 'alia wasinosinona 'i nali, ma daro ka alaa failia Jesus sulia maenala ma olinala faasia molagali fala 'i nali lia 'e kae faa ali'afua 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Wasua ma Peter failia rua kwaima lia gi, daulu mo'osu lo 'adaulu. Sui ala talasi daulu ada lo, daulu ka lesia wasinosinonala Jesus failia rua wale fo daro ura failia gi. ");
INSERT INTO lgl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma ala talasi rua wale fo gi daro kae la lo faasia Jesus, Peter ka sae 'uri 'e fala, “Arai, 'e 'oka rasua golu ka io 'i lifi'e. Alua meulu kae raunailia olu babala gi, ta ai famu, ta ai fala Moses, ma ta ai fala Elaeja.” ('E raria lou me 'are fo 'e ilia.) ");
INSERT INTO lgl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma talasi Peter kae alaa 'ua, te dasa ka dao ma malumalunai ka kufi fafi daulu. Ma olu wale li galona fo gi, daulu ka mau ala talasi fo dasa fo 'e la mae ka dau fafidaulu. ");
INSERT INTO lgl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma te linae 'are ka la mae faasia 'i laola dasa fo ka sae 'uri 'e, “Lia lo wela lau. Lau filia. Moulu rono sulia!” ");
INSERT INTO lgl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma talasi linae 'are fo 'e sui lo, teke Jesus lo 'e io failia olu wale li galona lia gi 'i lififo. Ma daulu ka lobo fafia 'are fo, ma ala talasi fo iko 'ali daulu faronoa lo ta ioli 'alia 'are fo daulu lesia. ");
INSERT INTO lgl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sui fe atoa 'i burila 'are fo gi li, Jesus failia olu wale li galona lia gi, daulu ka sifo mae faasia gwaula fe uo fo Jesus 'e olisi ai, ma ioli afula gera dao fala lesinala Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma na wale ala logona fo ka rii ka sae 'uri 'e, “Waleli Falalauna, lau suga 'o, ko balia aloe 'are ta'a fo faasia wela lau, sulia 'i lia teke wela moutae lau lo fo. ");
INSERT INTO lgl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Aloe 'are ta'a 'e olofia nainali mola, ma ka akwa ba'ela, ma ka 'ui 'alia 'i fua ma ka 'asua, ma fokala ka futofutoa. Talasi 'e taua, 'e 'ato rasua fala suina faasia, ma ka malakwaita rasua lo ala. ");
INSERT INTO lgl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lau sugaa wale li galona 'o gi fala balinala faasia, ma ka 'ato rasua fadaulu fala taunai.” ");
INSERT INTO lgl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus ka sae 'uri 'e, “'I 'amoulu malatamoulu 'e nasi rasua, ma 'i 'amiu ioli ta'a gi! Iko 'ali 'amu fakwalaimoki lau 'ua 'e! Lau io fae 'amoulu ka dao lo 'uri 'e, laka kwaimanosi lo 'alia abu fitoona 'e 'amiu.” Sui ka sae 'uri 'e fala wale fo, “'O sakea mae wela la 'o 'i lifi'e.” ");
INSERT INTO lgl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ala talasi fo wela fo 'e dao mae ala lifi fo Jesus 'e ura ai li, aloe 'are ta'a fo ka bi 'ui 'alia wela fo 'i fua, ma ka 'asua. Ma Jesus ka balufia aloe 'are ta'a fo, ma ka bi la faasia wela fo, ma ionala wela fo ka bi 'oka, ma Jesus ka kwatea wela fo fala mama lia. ");
INSERT INTO lgl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma ioli gera logo gi, gera ka 'afero rasua 'alia nanatanala God. Ala talasi ioli gi gera 'afero mola 'ada 'ua ala 'are fo Jesus 'e fulia gi li, 'i lia ka sae 'uri 'e fala wale li galona lia gi, ");
INSERT INTO lgl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ikoso moulu bulono 'alia 'are 'e lau ilida famoulu gi. 'I lau, Wela Wale li, gera kae kwate lau 'i lofola limala malimae lau gi.” ");
INSERT INTO lgl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Wasua ma wale li galona lia gi iko 'ali daulu saiala taa fadanala alaana fo 'e iilia. God 'e faagwaa malutala alaana fo faasidaulu. Ma daulu mau lou fala soilidinala fala fadanala alaana fo. ");
INSERT INTO lgl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ma alafaitalilina ka la 'i safitala wale li galona Jesus gi, sulia ite adaulu 'e ba'ela ka 'ilitoa fafidaulu sui. ");
INSERT INTO lgl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma sulia Jesus 'e saiala malatadaulu, ka sakea te wela, ka fa uraa 'i safitadaulu, ");
INSERT INTO lgl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma ka sae 'uri 'e fadaulu, “Ala ite 'o kwaloa ta wela 'uri 'e sulia 'e fakwalaimoki lau, 'o kwalo lau lou la. Ma ala ite 'o kwalo lau, 'o kwaloa lou God lia 'e keri lau mae. Sulia ite 'o fawawade 'o talamu 'i safitamoulu, 'i'o koe wale ba'ela koe 'ilitoa fafi 'amoulu sui.” ");
INSERT INTO lgl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sui John ka sae 'uri 'e, “Arai, meulu lesia te wale 'e balia aloe 'are ta'a gi 'alia nanatana 'o, ma meulu ka luia faasia taunai, sulia iko 'ali 'e 'ado fae golu.” ");
INSERT INTO lgl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus ka sae 'uri 'e fadaulu, “Ikoso moulu luia, sulia ite iko 'ali ura bolosi golu, 'i lia fae golu.” ");
INSERT INTO lgl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Talasi 'e dao garani lo fala Jesus 'ali oli lo 'i nali, ka malata ba'ela ala lalana fala 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma ka keria wale gi gera ka etaeta 'i lao ala. Gera la, ma gera ka dao ala te falua ala gulae tolo 'i Samaria 'ali daulu kae rerei 'alia 'are gi sui maasia. ");
INSERT INTO lgl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Wasua wale 'i lififo gi li iko 'ali gera oga mola kwalonala, sulia 'i lia wale Jiu 'ala ma kae laa fala 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma talasi rua wale ala wale li galona lia gi James failia John, daro lesia me 'are fo li, daro ka sae 'uri 'e fala, “Aofia, 'e 'utaa? 'Uri'e ma 'o oga mera ka suga fala ta dunaa faasia 'i nali 'ali 'e 'agofia sui ioli fo gi?” ");
INSERT INTO lgl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sui Jesus ka bulusi ma ka balufidaroa. ");
INSERT INTO lgl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma daulu ka la lo 'adaulu fala na falua mamata. ");
INSERT INTO lgl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma ala talasi daulu la lo sulia tala li, te wale ka sae 'uri 'e fala Jesus, “Lau oga lakae la fae 'o ala ta lifi mola 'ala koe la fai.” ");
INSERT INTO lgl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesus ka sae 'uri 'e fala, “'E iko 'ali 'e talawarau. Kui kwasi gi gera too ala lifi gera gi fala teona, ma malu gi lou gera too ala tatafe gera gi. Wasua ma 'i lau, Wela Wale li, iko 'ali lau too ala ta luma fala mo'osu na.” ");
INSERT INTO lgl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma Jesus ka sae 'uri 'e fala na wale lou, “'O la mae suli lau.” Wasua ma wale fo ka sae 'ala 'uri 'e, “Arai, 'o ala'alia laka laa, laka io ga failia mama lau, la la ka mae, laka alua ka sui, laka bi dona 'o.” ");
INSERT INTO lgl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma Jesus ka olisia ma ka sae 'uri 'e fala, “Ala'alia ioli iko 'ali gera too ala maurina ala God gi li, 'ali gera ka alua lo 'ada ioli mae gera gi. 'I'o, 'o la, ma ko sae sulia 'Ilitoana God.” ");
INSERT INTO lgl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma na wale lou ka sae 'uri 'e, “Arai, lakae ali buri 'o. Wasua ma, 'o ala'alia 'ali lau laa ma laka alualu ga ala ioli lau gi 'i falua.” ");
INSERT INTO lgl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus ka sae 'uri 'e fala, “Ta ioli 'e oga kae donaa lau, ma ka malata ba'ela sulia 'are lia 'e tafisida gi, 'e iko 'ali 'e totolia 'alia God ka 'ilitoa fafia maurinala.” ");
INSERT INTO lgl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'I burila 'are fo gi, Aofia Jesus ka filia fiu akwala wala rua wale gi, ma ka kerida 'ali rua ioli 'ali gera eta 'i lao aala fala falua 'e malata fala laa na fai gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma ka sae 'uri 'e fada, “Ioli gera rerei lo fala fakwalaimokina ala God gi li, gera malaa 'are afula 'i laola raku fala logosinali gi. Wasua ma ioli fala logosinala 'are fo gi li, iko 'ali gera afula. 'Are la fo, moulu ka foasia God 'ali 'e kwatea mae ioli li galona gi fae 'amoulu. ");
INSERT INTO lgl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Moulu laa lo. Lau keri 'amoulu malaa kale sipsip gi 'i safitala kui kwasi gi, sulia ioli afula gera oga fafuta'a namiu. ");
INSERT INTO lgl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ikoso moulu sakea ta bata, 'o ma ta wai fala alu batana 'i laola, 'o ma ta 'ae botu. Ma ikoso 'ali moulu dole ala sae kwaima na failia ta ioli sulia tala. ");
INSERT INTO lgl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ma talasi 'amu ka ruu ala ta luma, 'amu ka sae 'uri 'e, ‘God ka fa'oka 'amiu, ma aroarona ka io fae 'amiu 'i laola luma 'e.’ ");
INSERT INTO lgl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma ala wale 'e io 'i lifi la li 'e kwalo 'amiu 'alia aroarona, 'oilakina 'amoulu kae io lou failia wale la. Ma ala ka iko, 'oilakina fo ka oli lou mae 'i soemiu. ");
INSERT INTO lgl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'Amu ka io 'i laola luma la, ma 'amu ka 'ania, ma 'amu ka goufia 'are gera kwateda famiu gi. Sulia wale 'e galo, ka sakea lo folifolina lia. Moulu ka io too, ma ikoso 'ali 'amu lae mola 'amiu fala luma kwailiu gi. ");
INSERT INTO lgl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ma talasi 'amu dao ala ta falua ma gera ka kwalo 'amiu, 'amu ka 'ania fana taa gera kwatea famiu. ");
INSERT INTO lgl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma 'amu ka guraa ioli matai 'i laola falua laa gi li, ma 'amu ka sae 'uri 'e fala ioli 'i lifila gi, ‘Talasi God kae 'ilitoa fafia ioli lia gi li, 'e dao garani 'amiu lo.’ ");
INSERT INTO lgl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma ala 'amu dao ala ta falua, ma iko 'ali gera kwalo 'amiu, 'amu ka la sulia tala 'i laola falua laa li, ma 'amu ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Goraa ala falua 'e 'amiu lia 'e raratai malula 'aemeulu, meulu tafula lo ko fali fatailia reronamiu. Me 'are 'e faabasuna lo famiu lia God kae loko kwaikwaina famiu dunala 'amu barasi 'alia rononala saenala God. 'Amu ka malata tonala 'are 'e: 'Ilitoana God 'e dao garani 'amiu lo.’ ");
INSERT INTO lgl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Lakae ilia famiu, atoa ala kwaikwaina li kae dao mae, God kae kwatea kwaikwaina fala ioli ala falua ta'a ba 'i Sodom. Wasua ma kae kwatea kwaikwaina ba'ela ka tasa fala ioli ala falua la li ka liufia ioli ala falua ba 'i Sodom li!” ");
INSERT INTO lgl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesus 'e sae 'uri 'e, “'E ta'a ba'ela lo famiu ioli 'e 'amu io 'i Koresin gi. Ma 'i 'amiu lia 'amu io 'i Betsaeda ka 'urifo lou. Sulia iko 'ali 'amu fakwalaimokia 'are mama'ala afula ba lau tauda famiu gi. Ala gera taua 'are mama'ala fo gi 'i Taea ma 'i Saedon 'i lao, ioli 'i lififo gi li gera ka gwauru 'i wado, ma gera ka rufia toro midia gi, ma gera ka bulia rabeda 'alia 'ora, 'ali ka fatailia lia gera bulusi sui lo faasia ta'ana gera gi. ");
INSERT INTO lgl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ala fe atoa God kae loko kwaikwaina fala ioli ala molagali 'e li, kwaikwaina 'amiu kae ba'ela ka liufia ioli 'i Taea failia Saedon gi. ");
INSERT INTO lgl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Eo, 'i 'amiu me iona 'i Kapaneam, 'amu fia 'uria God kae lafu 'amiu fala 'i nali. Wasua ma, kae 'ui 'ali 'amiu 'i laola gilu ala famalifiina li.” ");
INSERT INTO lgl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sui Jesus ka sae 'uri 'e fala wale li galona lia gi, “Ala ta ioli 'e rono suli 'amoulu, 'i lia 'e rono lou suli lau. Ma ta ioli 'e 'e'ela 'ali 'amoulu, 'i lia 'e 'e'ela lou 'ali lau. Ma ta ioli 'e 'e'ela 'ali lau, 'i lia 'e 'ela lou 'alia God 'e kwate lau mae.” ");
INSERT INTO lgl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma fiu akwala wala rua wale fo gi gera ka laa lo. Ma talasi gera oli mae, gera ka babalafe rasua, gera ka sae 'uri 'e, “Aofia, aloe 'are ta'a gi wasua gera ronosuli 'ameulu talasi 'ami balida 'alia nanatana 'o li!” ");
INSERT INTO lgl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesus ka olisi 'uri 'e adaulu, “Lau lesia nanatanala Saetan 'e kalasu faasia ma ka toli nainali ka malaa kwana faasia 'i nali. ");
INSERT INTO lgl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Moulu rono ga! Lau kwatea lo nanatana famoulu 'ali moulu ka liu wasua wa gi ma farifari gi, ikoso gera 'ala fiifii amoulu. Lau kwatea lo famoulu nanatana 'e ba'ela ka liufia Saetan malimae gia li. Iko ta 'are ala Saetan 'ali sai lo ala fafuta'a na moulu. ");
INSERT INTO lgl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Moulu babalafe sulia aloe 'are ta'a gi gera ronosuli 'amoulu. Wasua ma moulu babalafe ba'ela rasua lou sulia God 'e gerea lo ratamoulu 'i nali.” ");
INSERT INTO lgl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma talasi fo, Alo ala God ka fababalafea Jesus, ma ka sae 'uri 'e, “Mama, 'i'o 'o 'ilitoa fafia 'are gi sui 'i nali ma 'i fua lou. Lau batafe 'o, sulia 'o fatailia 'are 'e gi fala ioli 'e gera malaa wela wawade gi li, ma ko faagwaa 'are 'e gi faasia ioli 'e gera 'auraeda dunala gera liotoo, ma gera ka lio raea 'are afula gi li. 'Eo Mama, 'are 'e gi gera 'urifo lo sulia liomu 'ua lo mae 'i lao.” ");
INSERT INTO lgl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sui Jesus ka sae 'uri 'e, “Mama lau 'e kwatea lo 'are gi sui fagu. Ma talifilia Mama mola 'e saiagu wela lia. Ma talifilia Wela 'i talala 'e saiala Mama, ma talifilia ioli Wela 'e filida fala fatailianala Mama fada gi mola, gera saiala Mama.” ");
INSERT INTO lgl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sui Jesus ka bulusi fala wale li galona lia gi talifilidaulu, ka sae 'uri 'e fadaulu, “'Oilakina famoulu, sulia moulu lesia 'are li 'aferona 'e gi 'i tara'ela. ");
INSERT INTO lgl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Lakae ilia famoulu, profet afula gi failia walelitalona afula 'i lao gi, gera oga lou lesinala 'are 'e moulu lesida 'i tara'ela gi, wasua ma ka 'ato rasua fada. Ma gera ka oga rasua lou ala rononala 'are 'e moulu ronoa 'i tara'ela gi, ma ka 'ato lou fada.” ");
INSERT INTO lgl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Te wale falalau ala taki li, 'e la mae 'i so'ela Jesus. 'E oga kae mailitonala, ma ka sae 'uri 'e, “Wale li faalalauna, ta taa 'e lakae taua 'ali lau too ala maurina firi?” ");
INSERT INTO lgl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma Jesus ka olisi 'uri 'e ala “Taa Geregerena Abu gi gera iilia? 'Uri'e ma 'o malinailia 'utaa ai?” ");
INSERT INTO lgl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma wale fo ka olisi 'uri 'e ala, “'O kwaima ala God 'o, 'alia malatamu laulau, ma 'alia manomu laulau, ma 'alia nanatanamu laulau, ma 'alia liomu laulau. Ma ko kwaima ala iolimu ka malaa lou 'o kwaima amu 'i talamu.” ");
INSERT INTO lgl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma Jesus ka sae lou 'uri 'e, “Olisina 'o 'e rada. Ko tau 'urila, koe mauri.” ");
INSERT INTO lgl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Wasua ma, wale falalauna fo, 'e oga kae fatailia 'i lia ionala 'e rada mola 'ala, ma ka soilidia lou Jesus 'uri 'e, “Ite lo ioligu lia laka kwaima ada?” ");
INSERT INTO lgl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma Jesus 'e saiai ioli Jiu gi gera barasi 'alia ioli 'i Samaria gi ma ka olisi 'uri 'e ala, “Te wale Jiu 'e ioio mae 'i Jerusalem ma ka la fala 'i Jeriko. Ma talasi kae liu 'ala sulia tala li, wale belibeli gi gera ka kwaia, ma gera ka sakea 'are lia gi sui failia toro lia gi. Ma gera ka kwaia lala ka maefulu lo, ma gera ka taasi 'alia, ma gera ka la lo 'ada faasia. ");
INSERT INTO lgl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma talasi fo, te fata abu ala Luma Abu God li 'e liu lou sulia tala fo, ma talasi 'e lesia wale fo li, ka rafe lo 'ala sulia na gulae tala, ma ka la lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sui, te wale galo kwairanai 'i laola Luma Abu God li ka la lou mae sulia tala fo. Ma talasi 'e dao 'i lififo li, ka lesia wale ba. Ma ka rafe lo 'ala faasia ala na gulae tala, ma ka la lou 'ala faasia. ");
INSERT INTO lgl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sui te wale faasia gulae tolo mamata 'i Samaria ka la lou mae sulia tala fo. Talasi 'e lesia wale fo li, ka kwaiaamasi rasua ala. ");
INSERT INTO lgl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ma ka la mae 'i so'ela, ka sau golia malaa 'i rabela gi 'alia waiwai failia waen, ma ka 'afua. Sui ka lafua 'i fofola dongki lia, ma ka sakea lo fala te luma fala folinai fala iona 'i laola li, ma ka lio sulia 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma ala ruala fe atoa, ka sakea rua me seleni 'e totolia folifolina fala rua fe atoa gi li, ma ka kwatea fala wale 'e lio sulia luma fo li, ka sae 'uri 'e fala, ‘'O lio sulia wale 'e, talasi lakae oli mae, lakae duua seleni 'o ranaa 'alida gi sui.’” ");
INSERT INTO lgl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sui Jesus ka sae 'uri 'e fala, “'O malata 'utaa? Ite ala olu wale fo gi lo iolila wale fo wale belibeli gi gera kwaia?” ");
INSERT INTO lgl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma wale falalauna fo ala taki li ka sae 'uri 'e, “Wale fo 'e kwaiaamasi ala.” Ma Jesus ka olisi 'uri 'e ala, “'O laa, ma ko tau lou 'urifo.” ");
INSERT INTO lgl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Talasi Jesus failia wale li galona lia gi daulu la, daulu ka li dao ala te falua, ma te geli ratala Mata ka kwaloa Jesus fala 'i luma lia. ");
INSERT INTO lgl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma geli fae lia Mary ka gwauru garania 'aela Aofia Jesus, ma ka fafurono 'ala fala falalauna Jesus gi. ");
INSERT INTO lgl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma malatala Mata ka boesia sulia 'i lia mola kae taua galona 'i luma gi sui. Ma ka la mae 'i so'ela Jesus, ka sae 'uri 'e fala, “Aofia, 'uri'e ma iko 'ali 'o malata 'abero mola sulia lia 'e galifae lau 'e aalu lau mola laka taua galona 'e gi sui talifili lau? 'O ilia fala 'ali 'e la mae ka kwairanai lou agu!” ");
INSERT INTO lgl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma Aofia ka olisi 'uri 'e ala, “Mata, 'o malata kwaikirori ma malatamu ka boesi 'o sulia 'are afula gi. ");
INSERT INTO lgl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Wasua ma teke me 'are mola 'e 'ilitoa. Mary 'e filia 'are 'ilitoa, ma 'e 'ato ta ioli ka sakea faasia.” ");
INSERT INTO lgl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ala na fe atoa, Jesus kae foa 'ala, ala na lifi. Ma talasi 'e foa ka sui mola, na wale ala wale li galona lia gi ka sae 'uri 'e fala, “Aofia, 'o faalalau 'ameulu 'alia foana, malaa ba John 'e faalalau lou wale li galona lia gi 'alia foana li.” ");
INSERT INTO lgl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus ka sae 'uri 'e fadaulu, “Talasi 'amu kae foa, 'amu ka sae 'uri 'e, ‘Mama, 'Ami oga ioli sui ka fabaelaa ratamu, sulia 'e abu rasua. Dao mae 'alia 'ilitoana 'o fafia maurinala ioli sui. ");
INSERT INTO lgl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ma 'o kwatea famami fana 'e totoli 'amami sulia atoa gi li. ");
INSERT INTO lgl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma ko kwailufa 'alia ta'ana 'ami gi, malaa lou 'ami kwailufa 'alia ta'ana ioli 'e tauda ami gi sui. Ma ikoso lugatae 'ami fala ilitoona 'ali liufi 'ami.’” ");
INSERT INTO lgl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma Jesus ka sae 'alia te tarifulaana 'uri 'e fala wale li galona lia gi, “Ala ta ioli amoulu 'e la 'i so'ela wale kwaima lia 'i luma lia matoula boni, ma ka sae 'uri 'e fala, ‘Walekwaima lau, 'o kwatea ga mae ta olu tofui berete fagu, ");
INSERT INTO lgl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sulia te wale kwaima lau, 'e io io mae ala na falua tatau, ma ka dao mae 'i soegu. Wasua ma iko 'ali lau too ala ta fana 'ali lau kwatea fala.’ ");
INSERT INTO lgl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma wale kwaima fo 'o 'i laola luma li ka sae 'uri 'e, ‘'O ala faa 'aberosinagu! Mala luma 'e folo lo, ma wela lau gi meulu ka mo'osu sui lo. 'E 'ato 'ali lau tatae lou fala kwatenala ta 'are famu.’ ");
INSERT INTO lgl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Laka ilia famoulu, wasua 'ala iko 'ali oga taunala ta 'are, ala wale fo ka suga, ma ka galo 'ala ala suganaa, wale fo 'i laola luma li, kae tatae ma kae kwatea 'are 'e ogada gi sui. Ma iko 'ali 'e taua 'i osiala wale fo wale kwaima lia, ma sulia 'e 'itoli suga mola 'ala. ");
INSERT INTO lgl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","'Are la laka ilia famoulu. 'Amu ka suga ala God 'ali 'amu sakea 'are 'amu suga 'afida gi. 'Amu ka lio 'afia 'are 'amu boboo fai gi ala God, ma 'i lia kae rana 'amiu 'ali 'amu darida. 'Amu ka kidikidi ala mala luma, ma God kae tafa famiu. ");
INSERT INTO lgl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sulia ioli gera suga ala God gi, gera kae sakea 'are gera sugaada gi. Ma ioli gera lio 'afia 'are gera boboo fai gi ala God, gera kae darida. Ma ioli gera kidikidi ala mala luma li, God kae tafa fada. ");
INSERT INTO lgl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“'Uri 'e ma, ite amoulu mama gi, ala wela 'o ka sugaa lode ia, ko kwatea 'amua fe wa fala? ");
INSERT INTO lgl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma ala wela 'o 'e sugaa ta ekela karai, ko kwatea 'amua ta farifari fala? 'E iko! ");
INSERT INTO lgl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sui ala 'i 'amiu ioli ta'a gi, 'amu saiala kwatenala 'are 'oka gi fala wela 'amiu gi. Ma Mama 'amiu 'i nali, 'i lia 'e 'oka ka tasa rasua liufi 'amiu. 'Urifo 'i lia kae kwatea Alo ala God fala ioli gera suga lia 'afia gi!” ");
INSERT INTO lgl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ala na talasi, Jesus 'e balia te aloe 'are ta'a faasia te wale fokala 'e 'ato. Ma talasi aloe 'are ta'a fo 'e tafi faasia, wale fo ka sae lo. Ma alae ioli afula gera logo 'i lififo gi li, gera ka 'afero. ");
INSERT INTO lgl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma nali ioli ada gera ka sae 'uri 'e, “Jesus 'e balia aloe 'are ta'a gi 'alia nanatanala Saetan, 'ilito'ola aloe 'are ta'a.” ");
INSERT INTO lgl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma nali ioli ada, gera oga geraka mailitonala Jesus. Ma gera ka sugaa 'uri 'ali 'e fulia ta 'are mama'ala, 'ali fatailia 'e too ala nanatana faasia God. ");
INSERT INTO lgl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma sulia Jesus 'e sai mola 'ala ala malatada, ka sae 'uri 'e fada, “Ala ioli 'i laola ta falua ba'ela gera kwalaa mola 'i matanadaulu 'i taladaulu, 'urila falua ba'ela fo kae tagalae lo. Ma ala wale failia wateu, ma wela lia gi, daulu kwalaa 'i matanadaulu 'i taladaulu, 'e 'ato 'ali daulu io ruru. ");
INSERT INTO lgl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ma 'ilitoana Saetan 'e 'urifo lou. Ala Saetan kae kwalaa failia ioli gera la sulia gi, 'urila gera kae tagalae kwailiu mola. Lau ilia 'are 'e gi, dunala 'amu ilia lau balia aloe 'are ta'a gi 'alia nanatanala Saetan. ");
INSERT INTO lgl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","'Amu iilia lau balia aloe 'are ta'a gi 'alia nanatanala Saetan. 'Urilali ma nanatana ite fo nali wale li galona 'amoulu gera balia aloe 'are ta'a gi 'alia? Saetan? 'E iko! Sulia 'are fo gi, 'e fatailia lia 'e 'amu rero. ");
INSERT INTO lgl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Lau balia aloe 'are ta'a gi 'alia nanatanala God. Ma ka fatailia famiu lia 'e 'ilitoanala God fafia ioli 'e dao garani lo mae amiu.” ");
INSERT INTO lgl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jesus ka sae lou sulia te tarifulaana 'uri 'e, “Ala ta wale ramo kae rerei 'alia 'are li kwalaana lia gi, ma ka lio folo 'oka bolosia luma lia, 'e 'ato ta wale ka belia 'are lia gi 'i laola luma lia. ");
INSERT INTO lgl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ma ala ta wale 'e nanata ka li liufia lou 'e la mae, ma ka kwalaa failia, ma ka liufi lia, wale la kae sake sui lo 'are li kwalaana lia gi lia 'e fitoo ali, ma ka tolinia sui lo 'are lia gi sui ala wale kwaima lia gi. ");
INSERT INTO lgl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ma ite iko 'ali dona buri agu, 'i lia malimae lau. Ma ite iko 'ali kwairanai agu fala logosinala mae ioli 'i so'ela God, 'i lia kae tagalailia ioli faasia God.” ");
INSERT INTO lgl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesus ka sae lou 'uri 'e, “Talasi gera balia aloe 'are ta'a ka laa faasia ta ioli, ka liliu 'i laola lifi kwasila, ma ka lio 'afia ta lifi 'uri 'ali 'e io lou ai. Ma ala 'e liolio ma ka iko lo, kae malata 'uri 'e, ‘Lakae oli fala ioli ba lau ioio mae ala 'i lao ma laka la mae faasia.’ ");
INSERT INTO lgl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ala talasi 'e oli mae ka dao, ka lesia ioli ba 'e kwaga, ma ka farada lo maurinala sui. ");
INSERT INTO lgl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Talasi 'e lesia 'e 'urifo, ka oli ma ka talaia lou mae na fiu aloe 'are gera ta'a ka ba'ela liufia 'i lia, gera ka la mae ma gera ka io lo 'i laola ioli fo. Ala talasi fo, ionala ioli fo ka bi ta'a ka liufia lo 'i lao.” ");
INSERT INTO lgl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Talasi Jesus 'e ilia 'are fo gi fada, te geli 'i laola logona fo li ka akwa 'uri 'e, “Geli 'e fafuta 'o ma ka fasusu 'o lo 'e babalafe ka tasa.” ");
INSERT INTO lgl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ma, Jesus 'e olisia ka sae 'uri 'e, “Kwalaimoki rasua. Wasua ma ioli 'e gera ronoa saenala God, ma gera ka tau sulia gi, 'i gera lo gera babalafe ka tasa.” ");
INSERT INTO lgl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma talasi ioli afula gera logo galia mae Jesus, 'i lia ka sae 'uri 'e fada, “'I 'amiu ului ioli 'e, 'i 'amiu ului ioli ta'a. Sulia 'amu oga lesinala ta 'are mama'ala kae fatailia nanatanala God, wasua ma 'e 'ato famiu fala lesinai. 'Amu kae lesia mola 'amiu 'are mama'ala malaa 'are ba 'e fuli fala profet Jona li. ");
INSERT INTO lgl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","'Are 'e fuli fala Jona, 'e malaa na totofo 'e fatailia fala ioli 'i Ninifa gi 'i lia 'e la mae faasia God. 'Are kae fuli fagu 'e malaa na totofo 'e fatailia lou lia 'e God 'e kwate 'e lau mae, Wela Wale li, fala ioli ala talasi 'e li. ");
INSERT INTO lgl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ma ala atoa God kae loko kwaikwaina fala ioli li, geli ba 'e 'ilitoa ala falua 'i Siba, kae tatae, ma kae fatailia ta'ana 'amiu gi ioli ala uului ioli 'e li, sulia abulonamiu 'e rero rasua. 'I lia 'e la tatau mae faasia suinala fofola wado fala rononala liotoo Solomon. Ma, 'i lau, te wale 'e lau 'ilitoa ka tasa liufia Solomon, lau io 'i lifi'e 'i tara'ela, ma iko 'ali 'amu rono mola suli lau. ");
INSERT INTO lgl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ka malaa lou ala atoa God kae loko kwaikwaina fala ioli li, ioli 'i Ninifa gi gera kae fatailia ta'ana 'amiu gi, sulia gera bulusi sui faasia rerona gera gi, talasi gera ronoa faatalona Jona fada. Ma 'i lau te wale 'ilitoa ka liufia rasua Jona, lau io 'i lifi 'e talasi 'e, ma iko 'ali 'amu bulusi mola.” ");
INSERT INTO lgl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesus ka sae 'uri 'e, “Iko ta ioli 'ali fakwarua fe ulu, ma ka faagwaa 'ala ka alua 'i malula ta dako. Talasi 'e fakwarua fe ulu ka sui ka alua lo ala lifi fala fakwaru ulu na li, 'ali ta ioli 'e ruu mae 'i laola luma, 'e saiala lesinala madakwanai. ");
INSERT INTO lgl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ala iko 'ali 'o lesia madakwana 'e, maamu 'e ta'a, ma 'o io mola 'amua 'i laola maerodo. Ala maamu ka 'oka ko io 'i laola madakwana 'e, sulia maamu 'e dau talaia madakwana fala 'i laola rabemu. ");
INSERT INTO lgl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'Amu ka madafi 'amiu ala 'amu barasi 'alia madakwana lau, 'i laola manomiu 'e rodo. ");
INSERT INTO lgl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ala 'amu fonu 'alia madakwa na, iko lo ta gula lou ala rabemiu 'e bolosia madakwa na, 'urifo ka malaa 'amu io ala lifi ulu 'e kwaru ai.” ");
INSERT INTO lgl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ala talasi Jesus 'e alaa ka sui lo, te wale ala Farasi gi li ka kwaloa fala fana na 'i luma ala. Jesus ka la failia, ma ka fana failia. ");
INSERT INTO lgl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma Farasi fo ka 'afero rasua, sulia 'e lesia Jesus iko 'ali saua mola limala ka bi fana. ");
INSERT INTO lgl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma Aofia Jesus ka sae 'uri 'e fala, “'I 'amiu Farasi gi, 'amu malata booboo rasua fala saunala 'i maluma ala teu li gou gi, failia 'are li fana 'amiu gi. Wasua ma, 'i laola manomiu 'e fonu 'alia 'are ta'a gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Moulu kwekwe'ela rasua! God 'e raunailia gula 'i maluma ala 'are gi li sui, 'i lia lou 'e raunailia 'i laola 'are gi. ");
INSERT INTO lgl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","'Amu ka kwatea 'are 'i laola teu li gou 'amiu gi li failia 'are 'i laola 'are li fana 'amiu gi li fala ioli siofa gi, 'ali 'are 'amiu gi sui ka kwaga 'i maala God. ");
INSERT INTO lgl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ta'ana famiu Farasi gi, sulia 'amu kwatea mola fala God na gula ala tanafulula fana ala fana 'amu fasia 'i laola raku 'amiu gi li. Wasua ma, iko 'ali amu malata 'abero mola fala faradanala iona 'amiu gi failia iolimiu, ma kwaimana 'amiu fala God. 'E 'oka 'amu ka taua 'are wawade malaa kwatenala tanafulula fana 'amiu gi fala God, wasua ma 'amu ka malata tonala lou 'are ba'ela ala kwaimana ala God, failia ioli ala falua 'amiu gi li sui. ");
INSERT INTO lgl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ta'ana famiu Farasi gi, sulia talasi 'amu la 'i laola luma fala foana li, 'amu oga gwauruna ala lifi li gwauru 'ala wale 'ilitoa gi li. Ma talasi 'amu la 'i maala uusina gi li, 'amu oga ioli gi gera ka fa'ilitoa 'amiu. ");
INSERT INTO lgl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ta'ana famiu Farasi gi, sulia 'amu malaa gigiluna ala ioli mae iko 'ali gera 'uia ta fourara 'i fofola, ma talasi ioli gi gera liu 'i fofola, iko 'ali gera lio raea lia 'are si'ina ma ka wa'a 'e io 'i laola.” ");
INSERT INTO lgl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sui te wale falalau ala takili ka sae 'uri 'e, “Waleli Falalauna, talasi 'o sae 'urifo, 'o sae fafuta'a 'ameulu lo fo.” ");
INSERT INTO lgl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma Jesus ka sae 'uri 'e, “Ta'ana famiu waleli falalauna ala taki gi li, sulia 'amu raunailia taki 'ato afula gi fala ioli, ma ka 'ato rasua fada fala ronosulinali, ma iko 'ali 'amu kwairanai ada. ");
INSERT INTO lgl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ta'ana lou famiu, sulia 'amu faakwaga fofola bao profet gi li ka lio 'oka rasua, profet ba koko 'ualo 'amiu gi gera raunida gi. ");
INSERT INTO lgl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","'Are 'e gi, 'e fatailia 'amu alafafia tauna ta'a fo koko 'ualo 'amiu gi gera tauda ada. Sulia gera raunida, ma 'amu ka raunailia gigiluna gi fada. ");
INSERT INTO lgl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ma 'i osiala me 'are fo, God ala liotoo lia 'e sae 'uri 'e, ‘Lakae kwatea ko profet gi, failia wale li lifurono gi fada, wasua ma gera raunia nali ai ada, ma gera ka malakwaita lou ala nali ai ada.’ ");
INSERT INTO lgl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sulia 'e 'urifo, gerakae loko kwaikwaina fala uului ioli ala talasi 'e li fafia rauninala profet gi, fuli lo mae ala etanala fofola wado. ");
INSERT INTO lgl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Fuli mae ala maenala Ebol la la ka dao ala maenala Sekaraea wale ba gera raunia 'i laola Luma Abu God, 'i matanala 'ere fau failia lifi abu li. 'Are kwalaimoki 'e la kae ilia famiu, gera kae loko kwaikwaina ala uului ioli ala talasi 'e li fafia maenala wale fo gi. ");
INSERT INTO lgl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ta'ana famiu waleli falalauna ala taki gi li, sulia 'amu faagwaa kwalaimokina God, 'ali ioli gi ikoso saiai. Iko 'ali 'amu fakwalaimoki mola ai, ma 'amu ka bolosia ioli faasia saina ai.” ");
INSERT INTO lgl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma talasi Jesus 'e la lo faasia falua fo li, wale falalau ala taki gi li, failia Farasi gi, gera ka fuli'ae fala sae fafuta'a nala, ma gera ka soilidia 'are afula gi ala. ");
INSERT INTO lgl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ma gera ka maili fala kotofinala Jesus fala daona tonala ta me 'are rero kae iilia. ");
INSERT INTO lgl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ala talasi fo lou, logonae ioli ba'ela, 'e totolia ta barae to'oli ioli gera logo mae fala rononala Jesus. Logonae ioli ba'ela fo gera afula rasua geraka urida 'i talada lo. 'I lao ala Jesus ka alaa fala logonae ioli ba'ela fo, 'e etae sae 'uri 'e fala wale li galona lia gi, “'Amu ka madafi 'amiu faasia ronona sulia malatae wale ta'a Farasi gi li, sulia 'i gera ioli 'asa gi. ");
INSERT INTO lgl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta taa wale 'asa 'e faagwaa, God kae fatailia. Ma 'are agwaagwa gi, gerakae sai lou ali. ");
INSERT INTO lgl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma ta taa 'amu iilia 'i laola mae rodo, gera kae ronoa 'i laola dani teetee. Ma ta taa 'amu nurunuru 'alia 'i laola aninala ta ioli ala ta lifi alu talifili 'amoroa, gera kae faronoa 'alia fala ioli gi sui 'ali geraka rono abitakwa ai.” ");
INSERT INTO lgl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesus ka sae lou 'uri 'e, “Lakae ilia famoulu wale kwaima lau gi, ikoso 'ali 'amu maulia ta ioli kae raunia rabemiu, ma 'i burila ikoso gera taua mola ta 'are ta'a ala manomiu. ");
INSERT INTO lgl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wasua ma la kae fatailia famoulu wale 'amu ka maulia, 'amu ka maulia God. Sulia 'i lia lo 'e saiala ka raunia rabemiu, ma 'e too lou ala nanatana fala taasinala manomiu 'i laola lifi li malakwaitana. 'Eo, laka ilia lou famoulu, God talifilia mola moulu ka maulia. ");
INSERT INTO lgl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Lima fe suri gi, gera foli 'alida mola fala rua me seleni wawade gi. Wasua fe suri gi gera ka wawade 'ada, God iko 'ali bulono mola 'ali ta ai ada. ");
INSERT INTO lgl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ifu ala gwaumiu gi wasua, God sai mola 'ala ali sui. 'Are la fo ikoso 'ali 'amu mau, sulia God 'e malata ba'ela ala ioli ka liufia fe malu afula 'e gi.” ");
INSERT INTO lgl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sui Jesus ka sae lou 'uri 'e, “Lakae ilia famoulu, ala ta ioli 'e iili tafanailia 'i lao ala ioli 'i lia wale li galona lau, 'urila 'i lau, Wela Wale li wasua, lakae iili tafanailia lou 'i lao ala eniselo God gi. ");
INSERT INTO lgl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma ala ta ioli ka tofe fafi lau 'i maala ioli, lakae tofe lou fafia ioli la 'i maala eniselo God gi. ");
INSERT INTO lgl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ma ala ta ioli ka sae fafuta'a lau, God saiala ka kwailufa mola 'ala 'alia. Wasua ma ala ta ioli ka sae fafuta'a galona Alo ala God, 'ato rasua 'ali God kwailufa ala ioli la. ");
INSERT INTO lgl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ma gera kae sake 'amiu fala lokokwaikwaina famiu 'i laola luma fala foana gi li 'o ma 'i lao ala wale 'ilitoa gi. Ala talasi fo, ikoso 'amu mau, ma ikoso 'amu malata booboo fala ta alaana 'utaa 'amu kae iilia, ma 'amu kae olisi gera 'alia. ");
INSERT INTO lgl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sulia talasi fo, Alo ala God kae faalalau 'amiu 'alia 'are 'amu kae ilida gi.” ");
INSERT INTO lgl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Te wale 'i laola logona fo li, 'e sae 'uri 'e fala Jesus, “Waleli Falalauna, 'o ilia fala ai 'i lao agu ka tolinia too 'arena mama 'ameroa 'e tafisia fameroa gi.” ");
INSERT INTO lgl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma Jesus ka olisia 'uri 'e, “Wale 'e, ite 'e kwatea nanatana fagu fala lokomalatana fala tolininala 'are 'i matanamoroa gi?” ");
INSERT INTO lgl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Maka sae 'uri 'e fada sui, “'Amu ka malata 'oka, taufasia 'amu fana'ete. Sulia maurina kwalaimoki ioli li iko lou bata 'o ma too 'arena lia gi.” ");
INSERT INTO lgl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Urifo Jesus ka sae 'alia tarifulaana fada 'uri 'e, “Te wale too 'are 'e too ala te wado 'oka ka fasi 'are 'i laola, ma ka fisu 'are 'oka afula ala 'are 'e fasida 'i laola gi. ");
INSERT INTO lgl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma ka io ka malata 'ala sulia 'i talala ma ka sae 'uri 'e, ‘Taa lakae taua? Sulia iko 'ali lau too lo ala ta lifi fala alu golinala 'are lau gi. ");
INSERT INTO lgl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Lakae tau 'uri 'e, lakae osia babala 'e la kae lologosi 'are 'i laola ka sui, laka raunailia lou tali babala fa'alu 'e ba'ela liufia. Ma laka bi golia mae fuae 'are lau gi failia tali 'are lou 'i lifi'e. ");
INSERT INTO lgl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sui laka bi sae 'uri 'e fagu 'i talagu, 'Oilakina rasua famu! 'O too lo ala 'are 'oka afula 'o ogada 'e totolia fe nali afula gi li. 'O io ko 'asu'asu 'ae lo 'amua! 'O fana 'oka 'amua, ma ko gou 'amua, ma ko taua lo 'are fala fababalafenala maurinamu gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wasua ma, God 'e sae 'uri 'e fala, ‘Me kwe li 'o! 'I laola fe boni 'e 'i tara'ela lo 'e koe mae, ma ikoso saiala ite kae too ala 'are 'e 'o golida famu 'i talamu gi?’” ");
INSERT INTO lgl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ma Jesus ka faasuia falalauna fo 'uri 'e, “Kae fuli lou 'urifo fala ioli gera goli 'are fada 'i talada gi, wasua ma 'i maala God gera siofa rasua.” ");
INSERT INTO lgl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sui Jesus ka sae 'uri 'e fala wale li galona lia gi, “Lakae ilia famoulu, ikoso 'ali 'amu malata boesi 'amiu sulia taa 'amu kae 'ania, ma taa 'amu kae toro 'alia fafia rabemiu. ");
INSERT INTO lgl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sulia maurina 'e, 'e 'oka ka tasa liufia fana, ma rabe 'e 'e 'oka ka tasa liufia toro. ");
INSERT INTO lgl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lesia fe malu gi, iko 'ali gera malata boesida mola sulia galona ala ta raku. Ma iko 'ali gera fisua mola ta fana, ma iko 'ali gera raunailia mola ta babala fala alu fana na. Wasua ma God 'e ranolida mola 'ala. Ma God 'e lio ba'ela rasua amiu ka liufia fe malu gi. Lia fo, God kae ranoli 'amiu mola 'ala. ");
INSERT INTO lgl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Wasua 'amu ka malata boesi 'amiu sulia maurinamiu 'e 'ato rasua 'ali 'amu ka taua manomiu ka ke tekwa wawade lou. ");
INSERT INTO lgl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma ala iko 'ali 'amu totolia mola taunala ta keme 'are fala faatekwanala manomiu, 'utaa 'e 'amu ka malata boesi 'amiu sulia 'are mamata gi? ");
INSERT INTO lgl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Moulu lesia ga taganala 'ai 'e gera taga afola gi. 'E iko 'ali gera galo mola, ma iko 'ali gera raunailia mola ta toro ada. Ma laka iilia famoulu, gera lio kwana ka tasa liufia toro Solomon walelitalona 'e ruufida gi. ");
INSERT INTO lgl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ma taganala 'ai gi gera io mola sulia keme talasi dodoko, ma gera ka taasi lou 'alida 'i laola dunaa. Ka 'urifo wasua 'ala, God 'e faaruufida 'alia 'are 'oka gi. 'Uri 'e ma 'amu fitala 'uria God ikoso faatoro 'amiu? Fitoona 'amiu gi 'e wawade. ");
INSERT INTO lgl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ma ikoso 'ali 'amu malata boesi 'amiu sulia taa 'amu kae 'ania, ma taa 'amu kae goufia. ");
INSERT INTO lgl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sulia ioli gera io tatau faasia God gi lo gera saiala malata boesinada sulia 'are fo gi. Ma 'i 'amoulu, Mama 'amoulu 'e sai sui lo ala lia 'amu boboo fala 'are fo gi li. ");
INSERT INTO lgl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'Amu ka malata mola sulia maurina 'e God 'e 'ilitoa fafia, ma 'i lia ka kwatea 'are 'amu booboo fai gi famiu.” ");
INSERT INTO lgl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sui Jesus ka sae lou 'uri 'e, “'I 'amoulu ioli lau gi, wasua 'amu ka malaa sipsip wawade gi, ikoso 'amu mau sulia God Mama 'amiu, 'e babalafe rasua fala kwatenala 'ilitoana lia famiu. ");
INSERT INTO lgl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","'Amu ka foli 'alia 'are 'amiu gi, ma 'amu ka kwatea bata ai fala ioli siofa gi. Ala 'amu tau 'urifo, 'amu kae too ala 'ite ba'ela fala goli batana gi li 'i nali lifi 'e 'ato ka furafura. 'Amu alu golia too 'arena 'amiu gi 'i nali, ala lifi 'e 'ato 'ali gera kae faasuia, ma lifi wale belibeli gi ikoso dao ai, ma iko ta sula fali fafuta'ada. ");
INSERT INTO lgl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sulia talasi too 'arena 'amiu 'e io 'i nali, manomiu 'e toli tegula lo fala 'i nali. Ma talasi too 'arena 'amiu 'e io 'i laola molagali li, manomiu ka toli tegula lo fala 'are 'i laola molagali gi li. ");
INSERT INTO lgl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“'Amu ka io li liolio maasia ta taa 'e kae dao mae. Ma 'amu ka rufia toro 'amiu gi, ma 'amu ka fakwarua ulu 'amiu gi, ");
INSERT INTO lgl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","malaa lo wale li galona gera maasia wale 'ilitoa gera kae oli mae faasia ta fanana ala araaraina li. Talasi 'e dao mae ma ka kidikidi, nainali mola geraka tafalia lo maala luma fala. ");
INSERT INTO lgl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","'Oilakina fala wale li galona fo gi ala wale 'ilitoa gera 'e dao tonada, ma gera ada mola 'ada 'ua, ma gera maasia ala talasi 'e oli mae ai. Lakae ilia 'are kwalaimoki famoulu, 'i lia kae rerei, ma ka fagwauruda sui, ma ka ranolida. ");
INSERT INTO lgl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'Oilakina fada ala 'e dao tonada gera kwaimamali, ala kae dao lo mae matoula boni, 'o ma malui boni 'i 'ofaedani! ");
INSERT INTO lgl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ma moulu ka malata tonala 'are 'e, ala wale ala luma 'e saiala talasi wale belibeli kae dao mae ai, 'e 'ato fala wale belibeli 'ali ruu 'i laola luma lia. ");
INSERT INTO lgl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'I 'amoulu lou, moulu ka io li kwaimamali maasi lau, Wela Wale li. Lakae dao mae ala talasi 'amu fia ikoso 'ali lau dao mae ai.” ");
INSERT INTO lgl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter ka sae 'uri 'e, “Aofia. 'Uri'e ma 'o ilia tarifulaana 'e fameulu mola 'e, 'o ma fala ioli gi sui?” ");
INSERT INTO lgl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Aofia ka olisia 'uri 'e, “'Amu kae malaa wale galona 'e liotoo ma ka galo rada. Ma arai ba'ela ka alua ka lio sulia wale li galona gi sui, ma ka kwatea fana fada ala talasi fala kwate fana na 'ada li. ");
INSERT INTO lgl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ma 'oilakina fala wale galona fo ala wale ba'ela lia 'e dao tonala, ma 'e taua 'are fo gi ala talasi 'e dao mae 'i luma lia li! ");
INSERT INTO lgl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Lakae ilia 'are kwalaimoki famoulu, wale ba'ela fo kae alua 'i lia kae lio sulia 'are lia gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wasua ma, kae ta'a rasua ala wale galona fo ka malata 'uri 'e li, ‘Wale ba'ela lau, daonala mae 'e tatau 'ua,’ ma ka fuli'ae fala kwainala wale li galona gi, failia geli li galona gi, ma ka io li fana lo 'ala ma ka gou mala kwe lo 'ala la la gwaula ka lulumui lo. ");
INSERT INTO lgl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sui ma wale ba'ela ka dao mae ala na fe atoa 'e iko 'ali kwaimamali ai, ma ala talasi lia 'e raria lou. Wale ba'ela kae kwatea kwaikwaina 'afaa fala, ma kae alua ala lifi fala ioli iko 'ali gera fakwalaimoki gi. ");
INSERT INTO lgl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Wale galona 'e saiala 'are wale ba'ela lia 'e oga ka taua, wasua ma iko 'ali rerei ma iko 'ali taua mola 'are fo wale ba'ela 'e oga, gerakae kwatea kwaikwaina ba'ela fala. ");
INSERT INTO lgl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ma wale li galona fo iko 'ali 'e saiala 'are wale ba'ela lia 'e oga, ma ka taua 'are totolia geraka rabusia fafia, gera kae kwatea me kwaikwaina wawade mola fala. “Ala God 'e kwate afula ala 'are fala ta ioli, God 'e oga ioli la ka olifae afula lou ala 'are gi fala. Ma ala God 'e kwatea 'are afula rasua gi fala ta ioli, 'e oga lou 'are afula rasua gi faasia ioli la.” ");
INSERT INTO lgl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesus ka sae lou 'uri 'e, “Lau la mae fala 'agofinala molagali, ma lau oga dunaa 'e 'ali fuli 'ae ka 'ago lo! ");
INSERT INTO lgl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lakae ruu 'i laola famalifiina ba'ela rasua 'e malaa talasi ioli 'e wawalo 'i laola kwai ala siuabunali. Lau malata nanata fai 'alia siuabuna 'e ala famalifiina ba'ela fo li ka ali'afu lo! ");
INSERT INTO lgl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","'Uri'e ma 'amu fia 'uri lau dao mae failia aroarona 'i laola molagali? 'E iko! Lau dao mae failia tolini na. ");
INSERT INTO lgl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","'E eta ala talasi 'e ka la 'alaa, luma lima ioli gi gera io 'i laola, gera kae tolini gera 'i osiagu. Olu ioli gi ala ta gula, ma rua ioli gi ala na gula. ");
INSERT INTO lgl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mama gi gera kae olisusu failia ulufa'alu gera gi, ma ulufa'alu gi gera kae olisusu failia mama gera gi. Ma teite gi gera kae olisusu failia ulao gera gi, ma ulao gi gera kae olisusu failia teite gera gi. Ma funo geli gi gera kae olisusu failia geli funao gera gi, ma geli funao gi gera ka olisusu failia funo geli gera gi.” ");
INSERT INTO lgl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus ka sae lou fala logonae ioli ba'ela fo 'uri 'e, “Ala 'amu lesia me dasa gi gera rae mae faasia sunala da'afi, 'amu ka sailoai uta kae too. Ma kae too kwalaimoki lo. ");
INSERT INTO lgl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma ala oru 'e rae mae, 'amu ka sai lou ai lia kae 'ago'ago. Ma kae 'ago'ago kwalaimoki lo. ");
INSERT INTO lgl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","'I 'amiu ioli 'asa gi! Sulia 'amu saiala lesinala 'i laola raloo failia molagali, wasua ma iko 'ali 'amu lio raea 'are God 'e fulia ala talasi 'e gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jesus 'e alaa lou ka sae 'uri 'e, “'Uta iko 'ali 'amu filia 'are rada gi fala taunali? ");
INSERT INTO lgl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ala ta wale kae sake 'o fala tolinimalata na, 'i lao ala mora ka alaa 'i laola tolinimalata na, ko mailia tonala faradanala 'are gi 'i matanamoroa. Suli ala ikoso 'ali 'o tau 'urifo, ma 'i lia ka sake'o 'i so'ela wale tolinimalata gi, ma 'i burila ka loko kwaikwaina famu, 'i lia kae kwate 'o lou fala wale firi ioli gi, ma wale firi ioli gi gera ka alu 'o 'i laola raraa. ");
INSERT INTO lgl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ma laka iilia famiu, ala 'e 'urifo, 'e 'ato rasua 'ali 'o latafa faasia raraa, lala ko kwatea bata 'isi'isi 'e totolia kwaikwaina 'o gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma ala talasi fo lou, nali ioli gera io 'i lififo, gera faronoa Jesus 'alia wale faasia 'i Galili gi lia Paelat 'e raunida, talasi gera foasi God gi. ");
INSERT INTO lgl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma Jesus ka sae 'uri 'e, “'Uta? Sulia gera raunia alae ioli fo gera ka mae 'urifo, 'amu fia 'uria ta'ana gera gi 'e ba'ela ka liufia ioli Galili gi sui? ");
INSERT INTO lgl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'E iko! Ma laka iilia famiu, ala iko 'ali 'amu bulusi faasia ta'ana 'amiu gi, 'i 'amiu sui 'amu kae mae lou malaa 'i gera. ");
INSERT INTO lgl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","'Amu malata 'utaa sulia akwala wala kwalu ioli ba 'i laola falua 'i Saelom luma ba'ela 'e toli fafida, ma gera ka mae sui? 'Uri'e ma, 'amu fia 'uri 'are fo 'e fatailia 'i gera ioli ta'a gi, ka liufia ioli gera io 'i laola falua 'i Jerusalem gi li? ");
INSERT INTO lgl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'E iko! Lakae iilia famoulu, ala iko 'ali 'amu bulusi faasia ta'ana 'amiu gi, 'i 'amiu sui 'amu kae mae lou malaa 'i gera.” ");
INSERT INTO lgl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sui Jesus ka alaa fada 'alia tarifulaana 'uri 'e, “Te wale 'e fasia te 'ai gera soia 'alia figi li 'i laola raku lia. Ala na talasi, 'e la ma ka lio 'afia tali fuae 'are 'i gwaula 'ai fo, ma iko 'ali lesia mola ta fuae 'are ai. ");
INSERT INTO lgl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma ka sae 'uri 'e fala wale 'e galo 'i laola raku lia li, ‘Lesia ga, olu fe nali gi lau liolio mae 'afia fuae 'are gi, ma iko 'ali lau lesia mola ta fuae 'are ai. 'Uri 'e 'o tofua lo 'amua! Iko 'ali totolia 'ali 'e io bolosia mola 'ala wado faasia galona gi?’ ");
INSERT INTO lgl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Wasua ma ioli galona fo 'e olisia ka sae 'uri 'e, ‘Arai, 'o ala'alia 'ai 'e ka io ga 'ala sulia ta teke fe nali lou. Lakae 'eli galia, ma lakae alua naela buluka 'i 'aela, 'ali ka fa'oka wado 'e. ");
INSERT INTO lgl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma ala 'ai 'e ka funu 'alia fuae 'are gi ala fe nali lo ba mae, 'e 'oka. Ma ala ka iko, ko tofua lo 'amua.’” ");
INSERT INTO lgl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ala te Sabat atoa ala mamalona li, Jesus 'e faalalau 'i laola te luma fala foana li. ");
INSERT INTO lgl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma te geli 'e io 'i lififo aloe 'are ta'a 'e kokia sulila fofola ka bou, ma ka matai sulia akwala wala kwalu fe nali gi, ma iko 'ali totolia 'ali ka ura rada. ");
INSERT INTO lgl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ma talasi Jesus 'e lesia, ka soia mae 'i so'ela ka sae 'uri 'e fala, “'O 'akwaa lo faasia matai la 'e tau 'o.” ");
INSERT INTO lgl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma ka alua limala 'i fofola sulila, ma ala talasi fo mola, geli fo ka tatae rada, ma ka batafea God. ");
INSERT INTO lgl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma talasi wale etaeta ala luma fala foana fo li, 'e lesia Jesus 'e taua 'are fo ala geli fo ala Sabat atoa ala mamalona li ka ogata'a rasua, ma ka sae 'uri 'e fala ioli lifi fo gi li, “Olo fe atoa gi fala taunala galona 'amiu gi. Ma ala atoa fo gi lou, 'amu ka la mae fala gurana. Ikoso 'ali 'amu la mae fala gurana ala Sabat atoa ala mamalona li.” ");
INSERT INTO lgl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma Aofia Jesus 'e olisia ka sae 'uri 'e, “'I 'amiu ioli 'asa gi! Sulia 'amu 'idufae taua mola 'amiu galona gi talasi 'amu tatalia buluka ma dongki 'amiu gi li, ma 'amu ka talaida fala kwai fala fagoufinada ala Sabat atoa ala mamalona li. ");
INSERT INTO lgl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma geli 'e, 'i lia 'e futa lou ala kwalofa koko 'ualo gia Abraham, ma Saetan ka firi mae fafia 'alia matai na sulia akwala wala kwalu fe nali gi. Ma 'e 'oka laka guraa mataina 'e faasia ala atoa ala Sabat.” ");
INSERT INTO lgl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Talasi Jesus 'e sae 'urifo, malimae lia gi gera ka 'eke rasua, ma ioli gi gera bi babalafe 'ada, sulia 'are li 'aferona gi Jesus 'e tauda. ");
INSERT INTO lgl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus 'e alaa lou ka sae 'uri 'e, “Lakae alaa lou sulia na 'u'ulu fali fatailia 'ilitoana God fafia ioli lia gi li. ");
INSERT INTO lgl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","'E 'uri 'e: Te wale 'e sakea fufuala 'ai wawade gera soia 'alia mastad, ma ka fasia 'i laola raku lia. Sui ka bulao mae, ma ka alua 'ai ba'ela, ma malu gi gera ka la mae, ma gera ka io, ma gera ka raunailia tatafe gera gi ala rarala 'ai fo.” ");
INSERT INTO lgl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma Jesus ka sae lou 'uri 'e, “Lakae alaa lou ko sulia na 'u'ulu fali fatailia 'ilitoana God fafia ioli lia gi li. ");
INSERT INTO lgl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","'E malaa ist wawade fala faa falenala berete te geli 'e sakea, ma ka dola failia flaoa afula, la la ka rufia sui suufau fo ka ubu ma ka fale.” ");
INSERT INTO lgl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Talasi Jesus 'e laa fala 'i Jerusalem, ka liu 'i laola mae falua ba'ela gi, failia mae falua wawade gi, ma ka faalalau ioli afula gi. ");
INSERT INTO lgl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma te wale ka soilidia 'uri 'e, “Arai: 'Uri'e ma ta barae ioli mola God kae faamaurida?” Jesus 'e olisia ma ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Lakae ilia famiu, 'amu ka suusuu, 'ali 'amu ruu ala maala luma fo 'e susukudi 'e la fala 'i nali. Sulia ioli afula gerakae tau fala ruuna, ma 'e 'ato rasua fada sulia maala luma fo kae folo faasida. ");
INSERT INTO lgl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Talasi wale ba'ela ala luma 'i nali kae tatae, ma kae folo bolosia maala luma li, 'amu kae ura 'i maluma, ma 'amu kae kidikidi ala maala luma, ma 'amu kae sae 'uri 'e, ‘Arai, 'o tafa ko famami.’ Wasua ma 'i lia kae olisi 'amiu ma kae sae 'uri 'e, ‘Iko 'ali lau sai amiu, ma iko 'ali lau saiala lifi 'amu la mae faasia.’ ");
INSERT INTO lgl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sui 'amu kae olisi 'uri 'e ala, ‘'Ami fana fana fae 'o, ma 'ami ka gou gou lou fae 'o, ma ko faalalau 'i laola falua 'amami gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Wasua ma 'i lia kae sae 'uri 'e, ‘'I 'amiu ioli ta'a gi, 'amu la tatau ko faasi lau. Iko 'ali lau sai amiu, ma iko 'ali lau saiala lifi 'amu la mae faasia.’ ");
INSERT INTO lgl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ma talasi 'amu lesia Abraham, ma Aesak, ma Jakob, ma profet gi sui 'i laola 'Ilitoana God, ma God kae taasi 'amiu 'i maluma, 'amu kae kwaimalatai, 'amu kae ani, ma 'amu kae ogata'a failia 'ala niriniritaena ma giria nala lifomiu! ");
INSERT INTO lgl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma ioli gi gerakae dao mae faasia tataenala da'afi, ma 'i sunala da'afi, ma faasia gwaula tolo, ma 'i 'aela tolo, ma gera kae logo ala fanana lobaa 'i laola 'Ilitoana God. ");
INSERT INTO lgl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sulia ioli gera fafu'isi ala talasi 'e gi li, gera kae etaeta 'i lao. Ma ioli gera etaeta 'i lao ala talasi 'e gi li, gera kae aliburi.” ");
INSERT INTO lgl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ala talasi fo, nali Farasi gera la mae 'i so'ela Jesus ma gera ka sae 'uri 'e fala, “'O laa faasia 'i lifi'e fala ta falua mamata, sulia Herod walelitalona 'e oga rasua ala rauninamu.” ");
INSERT INTO lgl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma Jesus ka sae 'uri 'e, “Herod 'e malaa kui kwasi, sulia 'e koto rasua. Moulu lai iilia fala, 'i tara'ela failia 'i dani, lakae taua 'agua galona lau ala balinala aloe 'are ta'a gi li, ma guranala ioli matai gi. Ma ala olula fe atoa, laka bi faasuia galona lau gi. ");
INSERT INTO lgl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Wasua, lakae dao tarosi lo 'agua fala 'i Jerusalem 'i tara'ela, ma 'i dani, ma fe atoa lo ba gi lou. Sulia iko 'ali rada 'ali gera raunia profet ala ta falua mamata, 'i Jerusalem mola.” ");
INSERT INTO lgl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ma Jesus ka sae lou 'uri 'e, “Ioli la Jerusalem 'e! 'I 'amiu ba 'amu 'uilae fau ala profet ba God 'e kerida mae famiu gi, ma 'amu ka raunida. Ala talasi afula lau oga 'amu ka la mae 'i soegu, 'ali lau lio suli 'amiu malaa karai 'e ofia kalela 'i malula 'aba'abala. Wasua ma iko 'ali 'amu oga mola. ");
INSERT INTO lgl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ma talasi 'e lo, God kae la faasi 'amiu, ma kae taasi faeburi lo 'alia falua 'amiu. Ma lakae iilia famiu, ikoso 'ali 'amu leesi lau lou, la la ka dao ala talasi 'amu kae sae 'uri 'e, ‘God 'o 'oilakitailia wale 'e la mae 'alia nanatana 'o li!’” ");
INSERT INTO lgl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ala te Sabat atoa ala mamalona li, Jesus 'e la ka fana ala luma te wale etaeta ala Farasi gi li. Ma talasi fo, wale gi gera ka liolio fala lesinala ta ta kae taua. ");
INSERT INTO lgl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma te wale rua limalimala failia rua 'aela gera ubu rasua gi, 'e la mae 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma Jesus ka soilidia Farasi gi failia waleli falalauna ala taki gi li 'uri 'e, “Taki gia gi 'e ala'alia gia ka guraa ta ioli matai ala Sabat, 'o ma iko?” ");
INSERT INTO lgl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wasua ma iko 'ali gera ke olisia mola. Sui Jesus ka dau tonala wale matai fo, ma ka 'akwaa lo, ma Jesus ka ala'alia ka la lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sui Jesus ka soilidida 'uri 'e, “'Uri'e ma ala ta wela 'o 'o ma ta buluka 'o, 'e toli 'i laola ta gilu ala Sabat atoa ala mamalona li, 'o saiai ko lafua mola 'amua?” ");
INSERT INTO lgl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma talasi Jesus 'e soilidi 'urifo li, iko ta ioli 'ali ke olisia mola. ");
INSERT INTO lgl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ma talasi Jesus 'e lesia wale gi gera dao mae fala fana na, ma gera ka filia 'ada lifi 'ilitoa gi fala gwauruna ai, 'i lia ka sae 'alia tarifulaana fada 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Talasi ta ioli 'e suga 'o fala ta fanana ala araaraina li, ikoso gwauru ala lifi li gwaugwauru 'ala wale etaeta gi li, taufasia gera kwaloa lou ta wale 'e 'ilitoa ka ba'ela liufi 'o fala fanana la. ");
INSERT INTO lgl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma ioli 'e kwalo 'amoroa mae ka dao, ma ka sae 'uri 'e famu, ‘'O tatae ga, 'ali wale 'e ka gwauru 'i lifila.’ 'Urifo ko bi 'eke rasua 'amua, sulia gera 'idu 'o ko gwauru lo ala lifi 'i fua fala ioli siofa gi li. ");
INSERT INTO lgl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Talasi ta ioli 'e kwalo 'o, ko gwauru 'amua ala ta lifi 'i fua, ma talasi ioli 'e kwalo 'o mae 'e dao, 'i lia kae sae 'uri 'e famu, ‘Wale 'e, 'o 'idu mae fala ta lifi 'oka.’ 'Urifo, 'i lia ka faaba'ela 'o 'i maala ioli 'amu logo 'i lifila gi. ");
INSERT INTO lgl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sulia ioli 'e faaba'ela lia 'i talala, God kae fawawade lia. Ma ioli 'e fawawade lia 'i talala, God kae fabaelaa.” ");
INSERT INTO lgl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sui Jesus ka sae 'uri 'e fala wale fo 'e raunailia fanana fo li, “Talasi 'o raunailia ta fanana, ikoso kwaloa mola mae kwaima 'o gi, failia iolifuta 'o gi, 'o ma ioli too'are gera io garani 'o gi. Sulia gera saiai gera kae raunailia ta fanana 'urifo lou, ma gera ka suga'o lou fala duunala soina 'o taua ada. ");
INSERT INTO lgl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Talasi 'o raunailia ta fanana, 'o kwaloa ioli siofa gi, failia ioli 'aeda 'o ma limada mae gi, failia ioli maada ka koro gi. ");
INSERT INTO lgl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ala ko tau 'urifo, 'oilakina famu. Wasua ikoso gera duu famu, God kae duua famu, ala talasi ioli rada gi gera tatae lou faasia maena li.” ");
INSERT INTO lgl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ma talasi fo, te wale ala alae ioli gera io fala fanana li, 'e ronoa 'are Jesus 'e ilia, ka sae 'uri 'e, “'Oilakina fala ioli gera kae fana ala fanana 'i laola 'Ilitoana God li.” ");
INSERT INTO lgl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma Jesus ka sae 'uri 'e, “Ala te talasi, te wale 'e raunailia te fanana ba'ela, ma ka kwaloa mae ioli afula gi fala fana na. ");
INSERT INTO lgl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma talasi 'are gi sui 'e rerei lo, 'i lia ka keria wale li galona lia ka la fala soinala mae ioli 'e kwaloda gi 'ali gera ka la lo mae. 'E sae 'uri 'e, ‘'Amu la lo mae sulia 'are gi gera rereida sui lo.’ ");
INSERT INTO lgl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Wasua ma gera fuli'ae gera ka sae falii, gera ka iilia 'are gi 'e bebesida 'are la ikoso gera la mae. Na wale 'e sae 'uri 'e, ‘Lau folia me tofui wado, ma lau oga laka li lesia ga. 'O faaronoa, lau kwaimalatai rasua.’ ");
INSERT INTO lgl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma ruala wale ka sae 'uri 'e, ‘Lau folia akwala buluka ala talasi 'e, ma lau oga laka lai mailida ga, mala gera galo 'oka 'o ma iko. 'O faronoa lau kwaimalatai rasua ikoso 'ali lau la mola lo ko.’ ");
INSERT INTO lgl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma olula wale ka sae 'uri 'e, ‘Lau bi arai mola, ma ka 'ato rasua fagu fala laa na ko. 'O faronoa lau kwaimalatai.’ ");
INSERT INTO lgl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Talasi wale li galona lia 'e oli mae ma ka faronoa wale ba'ela lia 'alia 'are fo gi li, wale ba'ela fo 'e ogata'a rasua, ma ka sae 'uri 'e fala wale li galona lia, ‘'O la nainali sulia tala ba'ela gi, ma sulia tala wawade gi, ko soia mae ioli siofa gi, failia ioli 'aeda 'o ma limada mae gi, failia ioli maada koro gi, ma failia tali ioli rabeda mae lou.’ ");
INSERT INTO lgl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Talasi wale li galona fo 'e oli mae, ka sae 'uri 'e fala wale ba'ela lia, ‘Arai, 'are ba 'o ilida fagu gi, lau tauda sui lo, ma lifi li gwauru ala fanana 'o li iko 'ali fonu 'ua 'alia ioli.’ ");
INSERT INTO lgl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wale ba'ela fo ka sae lou 'uri 'e, ‘'O la lou sulia ke tala wawade gera io tatau gi, ko kwaloda, ma ko kwalagaea tali ioli 'ali luma lau ka fonu. ");
INSERT INTO lgl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma lakae ilia famu, 'e 'ato rasua fala ta ioli ala ioli ba lau kwaloda mae 'i lao gi, gera kae fana ala fanana 'e lau.’” ");
INSERT INTO lgl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ala na talasi, logona ba'ela gera la failia Jesus. Ma ka bulusi ka sae 'uri 'e fada, ");
INSERT INTO lgl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ite ioli 'e oga kae dona lau, 'i lia ka kwaima aagu ka liufia mama lia, teite lia, wateu lia, wela lia gi, walefae lia gi, gelifae lia gi, ma 'i lia talala lou. ");
INSERT INTO lgl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'E 'ato fala ta ioli ka malaa na wale li galona lau, ala iko 'ali 'e marabe fala donanagu, wasua talasi kae famalifii, ma kae mae ala 'ai rara folo li. ");
INSERT INTO lgl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Ala ta ioli amiu 'e oga kae raunailia ta luma ba'ela, 'i lia ka gwauru, ma ka malata ga sulia ta fita bata 'e too ai 'ali ka totolia faasuinala luma la. ");
INSERT INTO lgl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ala iko 'ali 'e tau 'urifo, ma ka alua lo ageage ala faanasinala luma fo sui, ma ioli gi gera lesia iko 'ali too ala bata 'e totolia fala faasuinai, gera kae dorakwala 'alia, ma gera ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Te wale 'e 'e fuli'ae lo ala faauuranala luma 'e, wasua ma iko 'ali totolia 'ali faasuia.’ ");
INSERT INTO lgl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ma ala ta walelitalona 'e laa failia teke akwala to'oli wale lia gi fala kwalaana failia na walelitalona 'e laa mae failia rua akwala to'oli wale lia gi fala kwalaana li. 'I lia kae gwauru ga 'i fua ka malata 'ala sulia taufasia iko 'ali nanata totolia kwalana failia walelitalona ai fo li. ");
INSERT INTO lgl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma ala 'e iko, 'i lia ka keria ta wale lia, 'ali 'e la, ma ka suga fala aroarona 'i matanadaroa, ala talasi gera io tatau 'ua mae. ");
INSERT INTO lgl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'E 'urifo lou, 'amu ka etae malata 'oka ga sulia famalifiina 'e 'amu kae dao tonai talasi 'amu kae dona lau li. Ala ta ioli amiu iko 'ali taasi faeburi 'alia 'are lia gi sui, 'e 'ato rasua kae dona lau.” ");
INSERT INTO lgl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesus ka sae lou 'uri 'e, “Me asi 'are 'oka. 'Urifo wasua 'ala, ala asiasila nai 'e dalakwai lo faasia, 'e 'ato rasua ko taua ka asiasila lou. ");
INSERT INTO lgl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma iko 'ali 'oka lo fala taunala ta 'are 'alia. 'E iko 'ali 'e 'oka lo fala wado ma fala rananala ta 'are. Ma 'e totolia gera ka taasia mola lo 'ada. 'Amu fafurono 'oka sulia alaana 'e gi.” ");
INSERT INTO lgl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ala na talasi, ioli afula gera galo ala golinala bata ala takisi li, failia ioli gera fia 'uri gera “ioli ta'a” 'urifo gi lou, gera dao fala fafuronosinala Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farasi gi failia wale falalau ala taki gi li, gera etania nurunuruna gera ka sae 'uri 'e, “Wale 'e 'e kwaloa ioli ta'a gi ma ka fana 'ala failida!” ");
INSERT INTO lgl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Lia fo Jesus ka alaa 'alia tarifulaana gi fada 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ala ta wale amoulu 'e too ala teke talanae sipsip, ma na teke ai ada ka rari, taa wale fo kae taua? 'I lia kae tafisia sikwa akwala wala sikwa sipsip fo gi, ma ka laa ka lio 'afia teke 'are fo 'e rari, la la ka daria lo. ");
INSERT INTO lgl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma talasi 'e daria, ka babalafe rasua, ma ka sakea 'i gwaula 'aba'abala, ");
INSERT INTO lgl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma ka sakea mae 'i falua. Sui ka soia mae wale kwaima lia gi, failia ioli ala falua lia gi li, 'ali gera ka logo mae, ma ka sae 'uri 'e fada, ‘Lau babalafe rasua, sulia lau daria lo sipsip ba lau 'e rari. 'Are la 'e 'amu ka babalafe faelau!’” ");
INSERT INTO lgl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma Jesus ka sae lou 'uri 'e, “Lakae iilia famiu, babalafena ba'ela 'urifo lou 'i nali fafia teke ioli ta'a 'e bulusi. Babalafena failia ka liufia babalafena fafia sikwa akwala wala sikwa ioli gera rada mola 'ada gi.” ");
INSERT INTO lgl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma Jesus ka alaa lou 'alia tarifulaana 'uri 'e, “Ala ta geli 'e too ala ta akwala seleni, ma na teke seleni ka iko, ta kae taua? 'I lia kae fakwarua ta ulu, ma kae salofia luma lia, ma ka lio ala lifi gi sui lala ka daria. ");
INSERT INTO lgl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma talasi 'e daria ka rii lo fala ioli kwaima lia gi, failia ioli ala falua lia gi li gera ka logo mae 'i so'ela, ma ka sae 'uri 'e fada, ‘Lau babalafe rasua, sulia lau daria seleni ba lau 'e iko. Lia fo 'amu babalafe faelau!’” ");
INSERT INTO lgl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma Jesus ka sae lou 'uri 'e, “Lakae ilia famiu, kae 'urifo lou 'i nali. Eniselo God gi failia God, gera babalafe rasua fafia teke ioli ta'a 'e bulusi mae.” ");
INSERT INTO lgl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma Jesus ka alaa lou 'alia na tarifulaana 'uri 'e, “Te wale 'e too ala rua wela wale gi. ");
INSERT INTO lgl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wela 'i buri 'e sae 'uri 'e fala mama lia, ‘Mama, 'o kwatea lo mae gula lau ala too 'arena golu li.’ 'Urifo mola, wale fo ka tolinia lo too 'arena daulu 'i matanala rua wela wale fo lia gi. ");
INSERT INTO lgl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","'I burila barae fe atoa 'e sui, wela wale ba 'i buri ka foli lo 'alia gula lia ala too 'arena daulu li, ma ka laa lo 'ala failia bata lia gi. Ma ka laa lo fala te falua tatau, ma ka fafuta'a sui 'ala bata lia gi ala iona ta'a. ");
INSERT INTO lgl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","'I burila 'e faasuia lo bata lia gi, fiolo ba'ela ka liu ala gulae falua fo, ma 'e iko 'ali too lo ala ta me 'are. ");
INSERT INTO lgl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ma ka laa 'i so'ela te wale ala falua fo li ka soilidi fala ta galona, ma wale fo ka kwate galona midia ala liona sulia boo lia gi li fala. ");
INSERT INTO lgl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma ka oga 'ali 'ania tali orenae fana ala fana boo gi li, sulia iko ta ioli 'i lififo 'ali kwatea mola ta fana 'ala. ");
INSERT INTO lgl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ma talasi 'e malata 'oka, ka sae 'uri 'e fala 'i talala, ‘Ioli li galona mama lau gi li, gera fana 'oka sui mola 'ada talasi 'e, ma gera ka bote, ma 'i lau 'e la kae fiolo mola 'agua fala maenagu! ");
INSERT INTO lgl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","'E 'oka fagu laka oli 'i so'ela mama lau, ma laka sae 'uri 'e fala, Mama, lau rero rasua lo 'i maala God, ma 'i maamu. ");
INSERT INTO lgl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Iko 'ali totolia lo 'ali 'o soi lau 'alia wela 'o. 'O ala'alia laka galo lo 'agua famu malaa na ioli li galona 'o.’ ");
INSERT INTO lgl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ma ka tatae, ka oli 'i so'ela mama lia. “Ma talasi 'e dao tatau 'ua ko faasia 'i falua, mama lia 'e lio ko, ka lesia. Ma ka kwaiamasi rasua ala wela lia. Ma ka lalao ko, ka ofia mae wela lia, ma ka lotofia babalila. ");
INSERT INTO lgl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma wela fo ka sae 'uri 'e fala, ‘Mama, lau rero rasua lo 'i maala God ma 'i maamu. Iko 'ali totolia lo 'ali 'o soi lau 'alia wela 'o.’ ");
INSERT INTO lgl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Wasua ma mama lia ka soia ioli li galona lia gi ka sae 'uri 'e, ‘Moulu nainali! 'Amu sakea mae to'omi tekwa 'e kwana ka tasa, ma Moulu ka faarufia 'alia. Ma moulu ka alua fe kome gi 'i limala, ma moulu ka alua 'ae botu gi 'i 'aela. ");
INSERT INTO lgl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sui, moulu ka laa, Moulu ka raunia mae kale buluka boke ba 'ali golu raunailia fanana ma golu ka babalafe 'agaulu. ");
INSERT INTO lgl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sulia wela 'e lau, 'e malaa 'e maemae lo, ma ka mauri lou. Ma ka malaa 'e ikoiko lo, ma laka lesia lou.’ Ma fanana fo ka fuli'ae lo. ");
INSERT INTO lgl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ma ala talasi fo, wela ba 'i lao 'e io 'ua mae 'ala 'i laola raku. Ma talasi 'e oli mae ma ka dao garania lo mae luma li, ka ronoa linela 'au uufia failia waena. ");
INSERT INTO lgl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma ka fairalo fala na ioli ala ioli li galona gi, ma ka soilidia sulia taa fo gera kae wae 'alia. ");
INSERT INTO lgl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma ioli li galona fo ka olisi 'uri 'e ala, ‘Ai burimu 'e oli lo mae 'i falua, ma mama 'o ka raunia lo kale buluka boke ba, sulia ai burimu 'e mauri, ma ka oli mae ka dao lo.’ ");
INSERT INTO lgl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma wela fo 'i lao ka ogata'a rasua, iko 'ali ruu lo ko 'i laola luma. Ma mama lia ka latafa mae, ma ka kwalogaea 'ali 'e ruu ko 'i laola luma. ");
INSERT INTO lgl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma ka olisia mama lia 'uri 'e, ‘Lesia, lau galo famu malaa wale li galona gwaugwau 'o sulia fe nali afula 'e gi, ma laka ronosulia saenamu. Wasua, iko 'ali 'o kwatea mola ta keme nanigot fagu, 'ali lau taua ta fanana failia wale kwaima lau gi! ");
INSERT INTO lgl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ma wela 'e 'o, 'e fafuta'a lo too 'arena 'o ala geli tau ta'a 'i labata gi, ma talasi 'e oli mae ka dao 'i falua, ko raunia lo kale buluka boke ba'ela 'oka ba fala!’ ");
INSERT INTO lgl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma mama lia ka olisi 'uri 'e ala, ‘Wela lau, 'o io talau fae lau, ma 'are lau gi sui, 'are 'o gi lou. ");
INSERT INTO lgl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wasua, golu taua lo 'agaulu fanana 'e, ma golu ka babalafe 'agaulu, sulia ai burimu lesinai 'e malaa 'e maemae lo, ma ka mauri lou. Ma 'e ikoiko lo ma talasi 'e golu lesia lou.’” ");
INSERT INTO lgl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus ka sae lou 'alia tarifulaana fala wale li galona lia gi 'uri 'e, “Te wale too'are 'e too ala te wale li galona 'e alua ka ba'ela fala too 'arena lia gi. Ma ioli gi ka faronoa wale too'are fo 'alia wale li galona lia, 'e 'aurafu, ma ka fafuta'a mola 'ala too 'arena lia gi. ");
INSERT INTO lgl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ma wale too'are fo ka soia mae wale li galona lia ma ka soilidi 'uri 'e ala, ‘Me 'are 'utaa 'e lau ronoa suli 'o wale'e? 'O gerea fita bata lau gi 'e 'o galo 'alida, sulia ikoso koe ba'ela lo ala too 'arena lau gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ma wale li galona 'aurafu fo ka malata 'uri 'e, ‘Wale ba'ela lau kae faasui lau lo faasia galona lau. 'Uri'e ma ta taa lo 'e lakae taua 'ali lau too ala ta galona fa'alu? Iko 'ali lau nanata lo fala 'elinala gilu gi, ma lau 'eke rasua lou 'alia suganaa. ");
INSERT INTO lgl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Lau saiala 'are lakae taua 'ali talasi lau sui faasia galona lau li, ioli gi gera kae kwalo lau mola 'ada 'i laola luma gera gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ma ka soia mae ioli gera sake lana faasia wale ba'ela lia li, ma ka sae 'uri 'e fala etala wale, ‘Fita 'are gi 'o sake lana ai faasia wale ba'ela lau?’ ");
INSERT INTO lgl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'I lia ka olisi 'uri 'e ala, ‘Teke talanae botole waiwai gi.’ Ma wale li galona 'aurafu fo ka sae 'uri 'e fala, ‘'Abae 'are ala sake lanana 'o li 'e, 'o gwauru, ma ko gerea lima akwala 'are gi mola.’ ");
INSERT INTO lgl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ma ka sae 'uri 'e fala ruala wale, ‘Ma 'i'o ta fita 'are 'o sake lana ali?’ Ma 'i lia ka olisia 'uri 'e, ‘Teke talanae wai flaoa.’ Ma wale li galona 'aurafu fo ka sae 'uri 'e fala, ‘'Abae 'are ala sake lanana 'o li 'e, 'o gerea kwalu akwala 'are gi mola.’ ");
INSERT INTO lgl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ma wale ba'ela ka batafea wale li galona 'aurafu fo fala liotoo 'e too ai. Suli ioli 'i laola molagali li gera liotoo ka tasa ala 'are 'i laola molagali gi li ka liufia ioli ala madakwana li. ");
INSERT INTO lgl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Lakae ilia famoulu, moulu ka kwatea too 'arena 'amiu gi fala rananala ioli mamata gi. Ma talasi bata 'amiu 'e sui, God kae kwalo 'amiu 'i nali. ");
INSERT INTO lgl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ite 'e galo 'oka 'alia too 'arena wawade gi, 'i lia kae galo 'oka lou 'alia too 'arena ba'ela gi. Ma ite 'e galo 'e'ela 'alia too 'arena wawade gi, 'i lia kae galo 'e'ela lou 'alia too 'arena ba'ela gi. ");
INSERT INTO lgl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ka 'urifo lou, ala iko 'ali 'amu galo 'oka 'alia too 'arena gi 'i laola molagali, God ikoso fitonamiu lou failia too 'arena kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma ala iko 'ali 'amu galo 'oka 'alia 'are ta ioli mamata gi, God ikoso kwatea lou 'are 'i nali gi famiu. ");
INSERT INTO lgl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Iko ta wale li galona 'ali 'e galo 'ala ta rua wale ba'ela mamata. Ala 'e 'urifo lo, 'i lia kae malimae ala na wale ba'ela, ma ka kwaima ala na wale ba'ela. Ma ka galo 'oka 'ala na wale, ma ka taasi faeburi 'alia na wale. Ta 'e, 'e 'ato rasua ala 'amu kae galo fala God, failia bata lou ala teke talasi.” ");
INSERT INTO lgl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ma talasi Farasi gi gera ronoa 'are fo li, gera ka dorakwala sulia Jesus, sulia 'i gera wale ma'ali bata rasua gi 'i gera. ");
INSERT INTO lgl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesus ka sae 'uri 'e fada, “'Amu taua 'are 'oka gi 'i maala ala ioli, 'ali gera ka batafe 'amiu. Wasua ma God 'e sai ala manomiu. Sulia taa ta ioli 'e malata ba'ela ai, God iko 'ali lio ba'ela mola ai.” ");
INSERT INTO lgl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesus ka sae lou 'uri 'e, “Taki Moses gi, failia geregerena ala profet gi li, 'e galo ka talai 'amiu mae la la ka dao ala talasi John wale fasiuabu 'e dao ai. Ma 'e fuli'ae ala John, lia 'e faatalo 'alia Faronona 'Oka sulia God kae 'ilitoa fafia ioli lia gi li, ioli afula gera babalafe fala ruuna 'i laola maurina 'e God kae 'ilitoa fafia. ");
INSERT INTO lgl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wasua ma iko 'ali fadaa lou 'uri nanatana ala taki li 'e sui lo sefo, wasua ta taki ka wawade 'ala. Raloo, failia molagali kae sui, wasua ma nanatanala taki gi kae io tekwa ikoso sui. ");
INSERT INTO lgl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ala ta wale 'e lugasia wateu lia ma ka tolea lou ta geli mamata, 'i lia 'e tau ta'a lo. Ma ala ta wale ka tolea geli gera lugasia, 'i lia 'e tau ta'a lou.” ");
INSERT INTO lgl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesus ka alaa lou ma ka sae 'uri 'e, “Te wale too'are 'e toro 'alia toro 'oka gi folifolinali 'e ba'ela, ma ka io 'alia iona 'oka sulia atoa gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma te wale siofa malaa 'e taua rabela, ratala Lasaros, 'e gwauru 'i wado 'i 'aela maala luma wale too'are fo li. ");
INSERT INTO lgl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma Lasaros ka oga 'ali 'ania orenala fana 'e toli faasia tarapapa li fana 'ala wale too'are fo li. Ma talasi Lasaros 'e gwauru 'i wado, kui gi wasua, gera dao mae, ma gera ka meilia malaa 'i rabela gi. ");
INSERT INTO lgl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lasaros 'e mae, ma eniselo gi gera ka sake 'alaa aala 'i so'ela Abraham fala fanana ba'ela 'i nali. Ma wale too'are fo ka mae lou, ma gera ka alua lo. ");
INSERT INTO lgl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma ka la lo fala lifi fala ioli mae gi li lifi gera io 'alia famalifiina ba'ela li. Ma ka lio ko fala 'i nali, ma ka lesia Abraham failia Lasaros daro io 'adaroa. ");
INSERT INTO lgl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma ka akwa ko fala Abraham ka sae 'uri 'e, ‘Koko Abraham 'e, 'o malatai lau mae. Kwatea mae Lasaros, 'ali ka fawasiua 'u'ula 'i laola kwai, ma ka fagwaria mae meagu, sulia lau io lo 'alia fiina 'i laola dunaa 'e.’ ");
INSERT INTO lgl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Wasua ma Abraham ka sae 'uri 'e fala, ‘Wela lau, 'o malata tonala ga talasi ba 'o mauri, 'o too ala 'are 'oka afula gi, ma Lasaros ka too mola ala 'are ta'a gi. Wasua ma talasi 'e, 'e io lo 'i laola babalafena 'i lifi'e, ala talasi 'o io 'amua 'i laola fiina li. ");
INSERT INTO lgl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma na 'are lou, God 'e alua te gilu ba'ela iko 'ali too ala ta suisuina li 'i matanagolu, ma iko 'ali totolia lo 'ali ta ioli ka tofolo ko fala 'i gula laa. Ma iko 'ali totolia lou 'ali ta ioli ka tofolo mae fala 'i soemeulu.’ ");
INSERT INTO lgl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma 'i lia ka olisi 'uri 'e ala, ‘Koko Abraham, lau ani ulu famu ko keria Lasaros fala luma mama lau li, ");
INSERT INTO lgl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","'ali 'e fabasua lima walefae lau gi, taufasia gera bi laa lou mae ala lifi li famalifiina 'e.’ ");
INSERT INTO lgl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma Abraham 'e olisia ka sae 'uri 'e, ‘Geregerena Moses, failia profet gi li 'e io sui mola 'ali failida. 'E totolia gera ka ronosulida.’ ");
INSERT INTO lgl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma 'i lia ka sae 'uri 'e, ‘Koko Abraham 'e, iko mola. Ala ta wale 'e maemae lo ma ka mauri lou, ka laa 'i soedaulu lo tara daulu bulusi faasia ta'ana daulu gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma Abraham ka sae 'uri 'e fala, ‘Ala iko 'ali gera ronosulia geregerena Moses failia profet gi li, 'e 'ato mola 'ali gera ka fakwalaimoki, wasua ta wale ka tatae lou faasia maena.’” ");
INSERT INTO lgl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus 'e sae 'uri 'e fala wale li galona lia gi, “'Are kae kwatea ma ioli kae abulo ta'a gi, 'are fo gi 'are fali fuli lo gi fo. Wasua ma kae ta'a rasua fala ioli kae taua ma 'are fo gi kae fuli! ");
INSERT INTO lgl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ala ta ioli ka taua ioli 'e gera mamaea gi ka toli faasia fitoona gera agu, 'e 'oka fala gera ka firia ta fau ba'ela 'i luala, ma gera ka taasi 'alia 'i laola asi matakwa. ");
INSERT INTO lgl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","'Amu ka madafi 'amiu! “Ala ioli futa 'o 'e abulo ta'a, 'o balufia. Ala 'e bulusi, 'o kwailufa 'alia ta'ana lia gi. ");
INSERT INTO lgl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma ala abulonala 'e ta'a famu ala fiu talasi gi 'i laola teke fe atoa, ma ka la lou mae 'i soemu 'i burila fiu talasi fo gi, ma ka sae 'uri 'e, ‘Lau bulusi lo,’ 'O kwailufa lou 'alia.” ");
INSERT INTO lgl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Wale li lifurono lia gi gera ka sae 'uri 'e fala Aofia Jesus, “'O fananata fitoona 'ameulu gi.” ");
INSERT INTO lgl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma Jesus ka olisi 'uri 'e adaulu, “Ala 'amu too ala fitoona 'e wawade ka malaa wasua fufuae mastad 'e wawade rasua, 'amu saiai 'amu ka ilia mola 'amiu fala ta 'ai ba'ela, ‘'O lafu 'o fae kalokalomu, ma ko ura 'i laola asi.’ Ma kae rono mola 'ala sulia saenamiu. ");
INSERT INTO lgl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ala ta wale amoulu 'e too ala ta ioli li galona fala aafita wado na 'o ma ka lio sulia sipsip gi, ma talasi 'e oli mae faasia raku li, ta taa koe iilia fala? Koe iilia kae la nainali mae, ma ka fana ga? ");
INSERT INTO lgl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'E iko! Koe sae 'amua 'uri 'e fala, ‘'O 'agofia ga mae fana lau gi, sui ko toro fa'alu, ko sake fana mae, laka fana ma laka gou ka sui bui, 'i buri, ko bi fana, ma ko bi gou 'amua.’ ");
INSERT INTO lgl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma wale ba'ela ikoso 'ali soi 'oka mola ala wale li galona lia, sulia 'e taua mola me 'are fala taunai 'ala gi. ");
INSERT INTO lgl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","'E 'urifo lou famoulu. Talasi 'amu taua 'are God 'e keri 'amiu fali gi ka sui, 'amu ka sae 'uri 'e, ‘'I 'amami ioli galona gi mola, ma 'ami ka tau lo galona 'ami fala taunali gi.’” ");
INSERT INTO lgl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus 'e laa fala 'i Jerusalem, ma ka liu matanala gulae tolo 'i Samaria failia 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma talasi 'e dao ala na mae falua, ka dao tonala te akwalae wale kuu 'e tauda gi. Gera ura tatau ");
INSERT INTO lgl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma gera ka akwa ba'ela mae 'uri 'e, “Jesus wale ba'ela, 'o malatai 'ameulu mae!” ");
INSERT INTO lgl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ma talasi Jesus 'e lesida, ka sae 'uri 'e fadaulu, “Moulu la, moulu ka fatailia rabemoulu fala fata abu God gi, 'ali gera ka fakwalaimokia lia rabemoulu 'e mafo lo.” Ma talasi daulu laa lo, rabedaulu ka mafo sui lo. ");
INSERT INTO lgl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Talasi na wale adaulu 'e lesia lia rabela 'e mafo lo li ka oli mae, ma ka akwa ba'ela, ma ka batafea God. ");
INSERT INTO lgl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma ka toli ka boururu 'i maala 'aela Jesus ma ka batafea. 'I lia iko lou wale Jiu li fo, 'i lia wale 'ala faasia 'i Samaria. ");
INSERT INTO lgl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma Jesus ka sae 'uri 'e, “Akwalae wale ba lau gurada ma rabeda ka mafo lo. Ma na sikwa wale lou, gera 'i fe? ");
INSERT INTO lgl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","'Uta wale ba gi sui iko 'ali gera oli mae fala batafenala God, ma talifilia wale 'e iko lou Jiu li mola 'e oli mae?” ");
INSERT INTO lgl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma Jesus ka sae 'uri 'e fala, “Tatae, ko laa lo God 'e gura'o lo dunala 'o fakwalaimoki lau.” ");
INSERT INTO lgl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nali Farasi gera soilidia Jesus 'uri 'e, “Talasi 'utaa God kae 'ilitoa fafia molagali?” Ma Jesus ka olisi 'uri 'e adaulu, “Talasi God kae 'ilitoa fafia ioli lia gi li, ikoso 'ali 'amu lesia 'alia ta totofo ba'ela. ");
INSERT INTO lgl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma ikoso ta ioli 'ali sae 'uri 'e, ‘Lesia ga, 'ilitoanala God 'i lifi'e!’ 'O ma ka sae 'uri 'e, ‘Lia 'i lokoo!’ Sulia lifi God 'e 'ilitoa ai 'ala 'i laola maurinala ioli.” ");
INSERT INTO lgl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sui Jesus ka sae 'uri 'e fala wale li galona lia gi, “Talasi kae dao mae, talasi 'amu kae oga lesinala atoa lau, Wela Wale li. Wasua ma 'ato 'ali 'amu lesia. ");
INSERT INTO lgl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma tali ioli gerakae sae 'uri 'e famiu, ‘Lio ga, Christ 'i lokoo!’ 'O ma gerakae sae 'uri 'e, ‘Lio ga, lia 'i lifi'e!’ 'Urifo wasua, ikoso 'ali 'amu laa fala liona 'afia. ");
INSERT INTO lgl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sulia olinagu mae, Wela Wale li, kae malaa kwana 'e madakwa 'i laola raloo li, ma madakwanai kae rara 'i laola raloo tefau, ma ioli sui kae lesia. ");
INSERT INTO lgl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wasua ma 'i lao ala olinagu mae, lakae famalifii, ma ioli gi gerakae barasi 'ali lau. ");
INSERT INTO lgl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Talasi lakae oli mae ai, kae malaa lou talasi ba ala Noa. ");
INSERT INTO lgl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Talasi Noa, wale gi gera fana, ma gera ka gou, ma wale gi failia geli gi gera ka wateu ma gera ka arai. Mola gera ka maola lo sulia fe atoa Noa 'e tae 'i laola faga ba'ela li, ma kwai ka fonu mae, ma ka fagimolosida sui lo. ");
INSERT INTO lgl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ma talasi lakae oli mae ai, 'e malaa lou atoa ba Lot, sulia ioli gi gera fana, ma gera ka gou, ma gera ka folia 'are, ma gera ka foli 'ali 'are, gera ka fasi fana, ma gera ka raunae luma. ");
INSERT INTO lgl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ala atoa fo Lot 'e laa faasia 'i Sodom, gera maola, ma dunaa failia fau 'ago'ago gi gera toli lo mae faasia 'i nali ma ka 'agofida sui. ");
INSERT INTO lgl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Lia kae 'urifo lou ala fe atoa lakae oli mae ai. ");
INSERT INTO lgl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ma ala fe atoa fo, ioli 'e io io 'i maluma ala luma lia li, ikoso ke oli lou 'i laola fala sakenala 'are lia gi. Ka 'urifo lou fala ioli 'i laola raku li, ikoso 'ali oli lou 'i luma. ");
INSERT INTO lgl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","'Amu ka malata tonala 'are ba 'e fuli fala wateu Lot li. ");
INSERT INTO lgl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ite 'e oga kae dau fafia maurinala 'ala 'i talala, 'i lia kae mae. Ma ite kae fae buri 'alia maurinala 'i osiala 'e dona lau, 'i lia kae mauri kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Lakae ilia famoulu, ala fe boni fo, rua ioli gi daro teo 'i laola teke tafe, na ioli God kae sakea, ma na ioli kae ore. ");
INSERT INTO lgl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Rua geli gi daro logosi fana, na geli God kae sakea, ma na geli kae ore.” ");
INSERT INTO lgl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ma wale li galona lia gi ka soilidia 'uri 'e, “Aofia, 'i fe lo 'e 'are la gi kae fuli ai?” Ma Jesus ka olisi 'uri 'e adaulu, “Olinagu mae ikoso ta ioli 'ali talafia ka malaa lou lia lanobulu 'ato 'ali 'e talafia ta me 'are 'e mae.” ");
INSERT INTO lgl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesus 'e alaa fala wale li galona lia gi 'alia tarifulaana 'e, 'ali ka fatailia fadaulu gera ka foa sulia atoa gi sui, ma ikoso gera fitala. ");
INSERT INTO lgl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Lia ka sae 'uri 'e, “Te wale li lokomalata, 'e io ala te falua, ma iko 'ali moulia God, ma iko 'ali soi ba'ela lou ala ta ioli. ");
INSERT INTO lgl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma me 'oru 'i laola falua fo li, 'e la mae sulia atoa gi 'i so'ela fala ani uluna fala ma ka sae 'uri 'e, ‘Lau oga ko kwatea lokomalata na rada fagu bolosia malimae lau gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ma sulia talasi tekwa lo, wale li lokomalata fo iko 'ali aala mola fafia. Sui 'i buri ka malata 'ala 'uri 'e 'i talala, ‘Wasua iko 'ali lau moulia mola God, ma iko 'ali lau soi ba'ela mola ala ta ioli, ");
INSERT INTO lgl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","lakae kwatea lo 'agua lokomalata na rada fala me 'oru 'e, 'i lia 'e faa 'aberosi lau rasua 'alia lalana mae 'i soegu, ma 'e bi faakweo lau 'alia 'idufae daona 'i soegu!’” ");
INSERT INTO lgl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma Aofia Jesus ka sae 'uri 'e, “Moulu ronoa ga 'are 'e wale li lokomalatana ta'a fo 'e ilia. ");
INSERT INTO lgl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'Urifo wasua 'e kwatea lokomalata na rada fala, lia fo ikoso 'ali 'amu malata ruarua ala God sulia kae kwatea rada na fala ioli lia gi, ioli gera anisia sulia boni ma dani. God ikoso dole fala rananada. ");
INSERT INTO lgl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Lakae iilia famiu, God kae kwate nainali ala rada na fada. Ma talasi 'i lau, Wela Wale li, lakae oli mae 'i laola molagali li, 'uri 'e ma lakae dao tonala ioli afula gi gera fakwalaimoki lau, 'o ma ta barae ioli mola?” ");
INSERT INTO lgl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus 'e alaa 'alia tarifulaana fala nali ioli gera fakwalaimokia 'uri 'i gera 'i talada mola gera rada ma gera ka mamagu 'alia nali ioli, ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Rua wale gi daro laa 'i laola Luma Abu God 'ali daro foa. Na wale Farasi, ma na wale 'e galo ala golinala bata ala takisi li. ");
INSERT INTO lgl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farasi fo 'e ura talifilia, ma ka foa 'uri 'e, ‘God, lau batafe 'o sulia iko 'ali lau malaa wale mamata fo gi sui. Sulia gera beli, ma gera ka taua 'are ta'a gi, ma gera ka tau wateu ta'a. Iko 'ali lau malaa wale ta'a looba 'e golia bata ala takisi li. ");
INSERT INTO lgl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Lau abu fana ala rua atoa gi 'i laola teke wiki, ma laka kwatea tanafulula too 'arena lau gi famu.’ ");
INSERT INTO lgl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ma wale fo 'e golia bata ala takisi li, 'e ura tatau mae 'ala. Ma iko 'ali 'e taea mola maala fala 'i nali, sulia 'e mau rasua. Ma ka fatailia olidodokona lia 'alia fidalinala fuufuula, ma ka sae 'uri 'e, ‘God, 'o malatai lau mae, lau wale ta'a 'i lau!’” ");
INSERT INTO lgl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma Jesus ka sae lou 'uri 'e, “Lakae iilia famiu, wale 'e olidodoko lo God kae faa rada ala talasi 'e latafa, ma iko lou Farasi fo. Sulia ioli gera faaba'ela gera 'i talada gi, God kae fawawade gera. Ma ioli gera fawawade gera 'i talada gi, God kae faaba'ela gera.” ");
INSERT INTO lgl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nali ioli gera sakea mae ke wela wawade gi 'i so'ela Jesus, 'ali ka dau tonada ma ka fa'okada. Ma talasi wale li galona lia gi gera lesia, gera ka balufida. ");
INSERT INTO lgl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ma Jesus ka soia mae wela fo gi 'i so'ela, ma ka sae 'uri 'e “'Amu ala'alia wela wawade la gi 'ali gera ka la mae 'i soegu, ma ikoso 'ali 'amu bolosida lou. Sulia ite 'e malata kwalaimoki ka malaa wela wawade gi, 'i lia 'e totolia iona 'i laola 'Ilitoana God. ");
INSERT INTO lgl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Lakae ilia 'are kwalaimoki famiu, ioli iko 'ali fakwalaimoki malaa wela wawade li, 'e 'ato rasua 'alia God ka 'ilitoa fafia maurinala.” ");
INSERT INTO lgl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Te wale etaeta ala Jiu gi li, 'e soilidia Jesus ka sae 'uri 'e, “Wale li faalalauna 'oka, ta taa 'oka 'e laka taua 'ali lau too ala maurina firi?” ");
INSERT INTO lgl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma Jesus 'e olisia ka sae 'uri 'e, “'Uta 'e ko soi lau 'alia wale 'oka? Iko ta ioli 'ali 'oka, talifilia God mola 'e 'oka. ");
INSERT INTO lgl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","'E 'oka ko saiala kwaikaena 'ilitoa ba God 'e sae 'uri 'e gi, ‘Ko ala rau ioli na, ma ikoso tau wateu ta'a, ma ikoso beli, ma ikoso koto fafia ta ioli, ma ko soi ba'ela ala mama 'o failia teite 'o.’” ");
INSERT INTO lgl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wale fo 'e olisia ka sae 'uri 'e, “'E fuli lo mae ala talasi lau wawade, laka ronosulia taki la gi sui lala ka dao 'i tara'ela.” ");
INSERT INTO lgl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma talasi Jesus 'e ronoa me 'are fo li, ka sae 'uri 'e fala, “Teke me 'are mola 'e iko 'ua. 'O foli 'alia 'are 'o gi sui, ma ko sakea bata ai gi, ko kwatea fala ioli siofa gi, ma ko bi too ala too 'arena 'i nali. Sui, ko laa mae ko dona buri agu.” ");
INSERT INTO lgl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma talasi wale fo 'e ronoa 'are fo li, liola ka dila rasua, sulia 'i lia wale too'are. ");
INSERT INTO lgl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ma talasi Jesus 'e lesia wale fo liola 'e dila, ka sae 'uri 'e, “'E 'ato rasua lo fala ioli too'are gi 'ali gera ruu 'i laola maurina 'e God 'e 'ilitoa fafia. ");
INSERT INTO lgl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","'E 'ato rasua fala ta kamel 'ali ruu sulia mae kwakwana wawade 'i 'aela suli li. Wasua, 'e 'ato fala ioli too'are 'ali God ka 'ilitoa fafia maurinala, ka liufia me 'atona fala kamel li fala ruu na sulia mae kwakwana wawade 'i 'aela suli li.” ");
INSERT INTO lgl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Talasi ioli gi gera ronoa alaana fo li, gera ka soilidi 'uri 'e, “'Urilali ma ite mola 'e saiala too na ala maurina firi li?” ");
INSERT INTO lgl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma Jesus ka olisida 'uri 'e, “'Are 'e 'ato rasua fala ioli li, iko 'ali 'ato mola fala God.” ");
INSERT INTO lgl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma Peter ka sae 'uri 'e fala Jesus, “'I 'ameulu meulu tafisia lo too 'arena 'ameulu gi sui, 'ali meulu dona 'o!” ");
INSERT INTO lgl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesus ka sae 'uri 'e, “'Eo. Lakae ilia famoulu, ala ta ioli 'e tafisia luma lia, 'o ma wateu lia, 'o ma barae walefae lia gi, ma mama lia 'o ma teite lia, ma wela lia gi, 'i osiala 'Ilitoana God, ");
INSERT INTO lgl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","'i lia kae too ala 'are afula gi 'i laola molagali ka liufia 'are 'e tafisida gi. Ma ala maurina fa'alu 'e dao mae, ioli la kae too lou ala maurina firi.” ");
INSERT INTO lgl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ma talasi Jesus 'e la failia wale li galona lia gi talifili daulu, ka sae 'uri 'e fadaulu, “Golu laa 'i Jerusalem 'ali gera kae faa ali'afua 'are ba profet gi gera gerea suli 'i lau, Wela Wale li. ");
INSERT INTO lgl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gera kae kwate lau 'i laola limala ioli mamata faasia Jiu gi li, 'ali gera kae 'oi 'agua, ma gera ka fa'isi fagu, ma gera ka nisufi lau. Gera ka rabusi lau, ma gera kae rauni lau. ");
INSERT INTO lgl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ma ala olula fe atoa, lakae mauri lou.” ");
INSERT INTO lgl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Wasua 'ala wale li galona gi iko 'ali gera sai mola ala alaana fo Jesus 'e ilida fadaulu gi, sulia malatadaulu 'e nasi rasua faasia malinailianala 'are Jesus 'e sae sulia. Lia fo 'e kwatea ma iko 'ali daulu saiala taa fo Jesus 'e sae sulia. ");
INSERT INTO lgl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Talasi Jesus 'e li dao garania mae falua 'i Jeriko li, te wale maala 'e koro 'e io 'i rabela talaa. Ala atoa gi 'e suga bata ala ioli sulia talaa. ");
INSERT INTO lgl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ma talasi 'e ronoa ioli afula gi gera liu, ka soilidi gera ka sae 'uri 'e, “Taa 'e 'uri 'e?” ");
INSERT INTO lgl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma gera olisia gera ka sae 'uri 'e, “Jesus wale ba 'i Nasareti tae 'e laa mae.” ");
INSERT INTO lgl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma wale maa koro fo ka akwa ma ka sae 'uri 'e, “Jesus 'i'o ulufa'alu ala kwalofa David li, 'o malatai lau mae!” ");
INSERT INTO lgl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma ioli gera etaeta 'i lao ala gi gera ka balufia, ma gera ka sae fala 'ali 'e io aroaro. Wasua ma ka bi akwa ba'ela lou, ma ka sae 'uri 'e, “'I'o wela ala kwalofa David li, 'o malatai lau mae!” ");
INSERT INTO lgl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ma Jesus ka mano ma ka iilia fada 'ali gera talaia mae 'i so'ela. Ma talasi 'e dao garani, Jesus ka soilidia, ");
INSERT INTO lgl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Taa 'o ogaa laka taua famu?” Ma wale maa koro fo ka sae 'uri 'e, “Aofia, lau oga 'ali maagu ka lio.” ");
INSERT INTO lgl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesus ka sae 'uri 'e fala, “'O lio lo. God 'e gura'o lo, dunala 'o fakwalaimoki lau.” ");
INSERT INTO lgl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma 'urifo mola ka lio lo, ma ka laa lo failia Jesus, ma ka batafea God. Ma talasi ioli gi gera lesia, gera ka batafea lou God. ");
INSERT INTO lgl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus 'e dao 'i Jeriko, ma ka liu ko 'i laola. ");
INSERT INTO lgl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma te wale etaeta ala wale goli bata ala takisi gi li, ratala Sakias, 'i lia wale too'are rasua. ");
INSERT INTO lgl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ma ka tau rasua fala lesinala Jesus. Ma ka 'ato, dunala 'i lia wale dodoko rasua, ma iko 'ali lesia Jesus, sulia logona fo 'e bolosia. ");
INSERT INTO lgl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ma ka lalao 'i lao ala logona fo, ka rae 'i gwaula te 'ai gera soia 'alia Sikamo, 'uri 'ali lesia Jesus talasi kae liu mae sulia tala li. ");
INSERT INTO lgl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Talasi Jesus 'e dao ala lifi fo li, ka lio ko fala 'i nali 'i gwaula fe 'ai fo, ma ka lesia Sakias, ka sae 'uri 'e fala, “Sakias, 'o sifo nainali mae, sulia lakae io 'i laola luma 'o 'i tara'ela.” ");
INSERT INTO lgl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakias ka babalafe rasua, ma ka sifo nainali mae, ka kwaloa lo Jesus 'i laola luma lia. ");
INSERT INTO lgl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ioli gi sui gera lesia me 'are fo, ma gera ka nurunuru 'i burila 'uri 'e, “Jesus 'e laa lo 'ali 'e io failia “wale ta'a” 'urifo wani.” ");
INSERT INTO lgl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma Sakias ka tatae, ka sae 'uri 'e fala Aofia Jesus, “Aofia, lakae kwatea ta gula ala too 'arena lau fala ioli siofa gi. Ma ala laka sake rasua ala tali 'are ala ta ioli lakae duua fai me talasi fafia fada.” ");
INSERT INTO lgl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma Jesus ka sae 'uri 'e fala, “'I tara'ela God 'e faamauria lo iona 'e, sulia wale 'e 'e fakwalaimokia God malaa fakwalaimokina ba koko 'ualo gia Abraham. ");
INSERT INTO lgl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","'I lau, Wela Wale li, lau la mae fala darinala ioli gera laa rero gi, 'ali lau faamaurida lou.” ");
INSERT INTO lgl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Logona ba'ela fo gera fafurono fala 'are Jesus 'e ilida gi sui. Sulia 'e dao garania lo 'i Jerusalem, ka iilia tarifulaana 'e 'ali 'e farada malatada, suli gera fia 'uria 'Ilitoana God kae fuli nainali lo. ");
INSERT INTO lgl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","'Are la 'e taua Jesus ka sae 'uri 'e fada, “Te wale ala iona 'ilitoa li, 'e rerei fala laana 'i so'ela te walelitalona ba'ela 'e io tatau mae, 'ali ka sugaa fala nanatana failia 'ilitoana, 'ali talasi kae oli mae, 'i lia kae walelitalona fala falua lia. ");
INSERT INTO lgl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma 'i lao ala 'e la, 'e soia mae akwala wale li galona lia gi 'i so'ela, ka kwatea seleni ba'ela fadaulu, ka sae 'uri 'e, ‘Moulu galo 'alia seleni 'e gi, 'ali moulu ka sakea lou tali seleni 'i maala ai 'e gi maasi lau.’ ");
INSERT INTO lgl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ma ioli ala falua wale 'ilitoa fo li, gera malimae ala, ma gera ka keria nali ioli 'ali gera ka alaa fala walelitalona ba'ela fo, sulia iko 'ali gera oga mola wale fo 'ali walelitalona 'ada. ");
INSERT INTO lgl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ka 'urifo wasua 'ala, walelitalona ba'ela 'e alua wale fo ka walelitalona lo fada, ma talasi 'e oli mae, ka iilia fala ioli li galona ba lia gi ba 'e kwate seleni fadaulu, 'ali ka daria ta fita seleni 'e daulu sakea 'i maala seleni ba 'e kwateda fadaulu gi. ");
INSERT INTO lgl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ma etala wale li galona 'e laa mae, ka sae 'uri 'e, ‘Arai, lau sakea na akwala seleni lou fafia seleni ba 'o kwateda fagu gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma wale 'ilitoa fo ka sae 'uri 'e fala, ‘'I'o wale galona 'oka. Dunala lau saiai laka fitoo amu ala 'are wawade gi, lakae alua koe lio sulia akwala mae falua gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","'Urifo ma ruala ioli li galona 'e laa mae ma ka sae 'uri 'e, ‘Arai, lau sakea lou na lima seleni fafia seleni ba 'o kwateda fagu gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma wale 'ilitoa fo ka sae 'uri 'e fala, ‘'O lio sulia lima mae falua gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Burila olula wale li galona ka laa lou mae, ka sae 'uri 'e, ‘Arai, seleni 'o gi ba lau sakeda, lau buta niriniri fafida 'alia 'abae toro. ");
INSERT INTO lgl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sulia lau mau 'ali 'o wale saesae rasua. 'O malaa na wale 'e saiala sakenala mola 'ala 'are ioli mamata gi li, ma 'o saiai ko sakea lou fana faasia raku ioli gi li.’ ");
INSERT INTO lgl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sui wale 'ilitoa fo ka sae 'uri 'e fala, ‘'I'o wale galonamu 'e ta'a. Lakae loko kwaikwaina famu 'alia alaana 'o gi 'i talamu. 'O iilia 'uri 'i lau wale saesae rasua, ma laka malaa na wale 'e sakea 'are ioli mamata gi li, ma laka sakea fana faasia raku nali ioli gi. ");
INSERT INTO lgl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ala 'o malata 'urila, 'utaa iko 'ali 'o sakea seleni lau gi, ma ko alua 'amua 'i laola lifi li alu bata na, 'ali ala talasi laka oli mae, laka sakea tali seleni ka tarena 'i maala?’ ");
INSERT INTO lgl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","'Urifo mola wale 'ilitoa ka sae 'uri 'e fala wale gera ura 'i lififo gi, ‘Moulu sakea seleni 'e faasia, ma Moulu ka kwatea fala wale 'e too ala akwala seleni gi li.’ ");
INSERT INTO lgl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Gera ka sae 'uri 'e, ‘Aofia, 'e too lo ala akwala seleni gi.’ ");
INSERT INTO lgl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma wale 'ilitoa fo ka olisida 'uri 'e, ‘Lakae ilia famiu ala ta ioli 'e galo 'oka 'alia 'are lau kwateda fala gi, lakae kwatea lou tali 'are afula fala. Ma ta ioli iko 'ali galo 'oka 'alia ta taa lau kwatea fala, wasua tali 'are wawade 'e too ali, la kae lafua lou faasia. ");
INSERT INTO lgl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma malimae ba lau gera barasi 'ali lau walelitalona fada gi, moulu talaida mae, ma moulu ka raunida 'i lifi'e 'i lao agu.’” ");
INSERT INTO lgl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Burila Jesus 'e sae 'urifo ka sui, ka la lo 'i lao ada fala 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ma talasi 'e dao garania falua 'i Betfeis ma 'i Betani fofola uo gera soia 'alia 'i Olif, ka keria rua wale li galona lia gi 'i lao, ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Mora la ala falua lokoo mora laofia ko. Ma talasi mora dao 'i lififo li, mora kae lesia te dongki. Gera firia mola 'ada dongki fo, ma iko ta ioli 'ali raerae 'ua 'i fofola. Mora lufaa, ma mora ka talaia mae 'i lifi'e. ");
INSERT INTO lgl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma ala ta ioli ka soilidi 'amoroa, ‘'Uta mora ka lufaa dongki la?’ Mora ka ilia fala, ‘Aofia 'e boboo fai.’” ");
INSERT INTO lgl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Rua wale fo gi daro la, ma daro ka daria, malaa lo Jesus 'e ilia. ");
INSERT INTO lgl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Talasi daro lufaa dongki fo li, wale 'e too ala dongki li ka sae 'uri 'e, “Ta la mora lufaa ke dongki la fai?” ");
INSERT INTO lgl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Daro ka sae 'uri 'e, “Aofia 'e boboo fai.” ");
INSERT INTO lgl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma daro ka talaia lo mae 'i so'ela Jesus, ma daro ka alua to'omi daroa gi 'i fofola dongki fo, ma gera ka ranaa Jesus, 'ali ka gwauru 'i fofola. ");
INSERT INTO lgl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma talasi Jesus 'e la ko sulia tala li, ioli gi gera ka folotailia to'omi gera gi sulia tala, 'ali ma ka liu 'i fofoli. ");
INSERT INTO lgl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ma talasi 'e dao garania 'i Jerusalem ala lifi tala 'e sifo fala fe uo 'i Olif li, ioli afula ala wale li galona lia gi li gera io 'i lififo, ma gera ka fuli'ae fala batafenala God 'alia te akwana ba'ela, fafia 'are mama'ala ba'ela gera lesida gi. ");
INSERT INTO lgl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ma gera ka sae 'uri 'e, “God 'o 'oilakitailia walelitalona 'e la mae 'alia nanatana 'o li! Ma aroarona failia God. Gia batafea God 'i lia 'ilitoana lia 'e tasa!” ");
INSERT INTO lgl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ma nali Farasi lou 'i lififo, ma gera ka sae 'uri 'e fala Jesus, “Wale li Faalalauna, 'o iilia fala wale li galona 'o gi, 'ali gera io aroaro.” ");
INSERT INTO lgl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma Jesus ka olisi 'uri 'e adaulu, “Lakae ilia famoulu, ala gera ka io aroaro, fau 'e gi gerakae galo ala batafenala God.” ");
INSERT INTO lgl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ma talasi Jesus 'e dao garania lo 'i Jerusalem, ka lio ko, ma ka lesia mae falua fo, ma ka ani, sulia liola 'e kwaimalatai fala ioli gera io 'i lififo gi. ");
INSERT INTO lgl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma ka sae 'uri 'e, “'E 'oka ala 'amu ka saiai 'i tara'ela 'are 'e talaia ioli fala aroarona li. Wasua ma 'i tara'ela 'amu raria mola. ");
INSERT INTO lgl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ma talasi kae dao mae, malimae 'amiu gi, gera ka la mae, gera ka kwalaa fae 'amiu, ma gera ka bolosi 'amiu, ma ka 'ato famiu 'ali 'amu latafa. ");
INSERT INTO lgl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ma gera kae tagalailia falua 'amiu failia ioli 'i laola gi sui. Ma ta teke me fau wasua 'ato 'ali teo lo ala lifi 'e io io ai 'i lao ala falua 'amiu. Gera kae fafuta'a falua 'amiu, sulia iko 'ali 'amu lio raea talasi God 'e laa mae fala famaurinamiu.” ");
INSERT INTO lgl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Talasi Jesus 'e ruu ko 'i laola Luma Abu God li, ka balia ioli gera foli 'ali 'are gi. ");
INSERT INTO lgl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma ka sae 'uri 'e fada, “'I laola geregerena 'ualo 'i laola Geregerena Abu li, God 'e sae 'uri 'e, ‘Luma lau, luma li foana.’ Wasua ma 'amu bulusia lo 'alia lifi fala belinala 'are ioli li.” ");
INSERT INTO lgl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma ala atoa gi sui, Jesus 'e faalalau 'i laola Luma Abu God. Ma fata abu ba'ela gi, ma wale falalau ala taki gi li, ma nali wale etaeta ala Jiu gi, gera tau fala rauninala Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Wasua ma iko 'ali gera ka too mola ala ta matolaa fala tau nai, sulia afulana gera io failia sulia atoa gi fala rononala falalauna lia gi. ");
INSERT INTO lgl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ala na fe atoa, Jesus 'e faalalaua ioli gi 'i laola Luma Abu God. Ma ka faatalo lou 'alia Faronona 'Oka. Ma talasi fo, fata abu ba'ela gi, ma wale falalau ala taki gi li, ma nali wale etaeta lou, gera la mae 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma gera ka soilidi 'uri 'e ala, “Nanatana taa 'e 'o too ai fala taunala 'are 'e gi? Ma ite lo 'e kwatea nanatana 'e famu?” ");
INSERT INTO lgl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","'I lifi fo, Jesus ka sae 'uri 'e fadaulu, “'Eo, laka soilidi 'amoulu ga fala me 'are. ");
INSERT INTO lgl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","'Amu ilia ga fagu, nanatana John 'e too ai fala fasiuabuna li, 'e fuli mae faasia 'i fe? 'E fuli mae ala God, 'o ma 'e fuli mola mae ala ioli?” ");
INSERT INTO lgl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma daulu ka soilidi 'i matanadaulu kwailiu 'uri 'e, “Taa golu kae iilia? Ala golu olisia ma golu sae 'uri 'e, ‘Faasia God,’ 'i lia kae sae 'uri 'e, ‘'Urilali ma 'utaa mola iko 'ali 'amu fakwalaimokia John?’ ");
INSERT INTO lgl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma iko 'ali 'oka lou ala golu kae sae 'uri 'e, ‘'E fuli mola mae ala ioli,’ ioli gi gera kae 'ui golu 'alia fau gi, ma gera kae rauni golu, sulia gera fakwalaimoki ala John lia na profet lou.” ");
INSERT INTO lgl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","'I lifi fo, daulu ka olisia Jesus 'uri 'e, “Iko 'ali meulu saiai.” ");
INSERT INTO lgl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma Jesus ka sae 'uri 'e fadaulu, “'I lau wasua ikoso lau faarono 'amoulu lou 'alia nanatana 'utaa 'e lau taua 'alia 'are 'e gi.” ");
INSERT INTO lgl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","'I burila, Jesus ka faarono gera lou 'alia na tarifulaana 'uri 'e, “Te talasi, te wale 'e fasia te raku grep, ma ka alua nali wale li galona gera ka lio sulia raku fo. Ma wale ba'ela ala raku li ka la ala te falua tatau, ma ikoso ke oli nainali mae. ");
INSERT INTO lgl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","'E dao lo ala talasi raku fo 'e maua, ma wale ba'ela fo ka keria te wale li galona lia, 'ali ka sakea mae tali fuae 'ai grep ala 'ai fo 'e fasida 'i laola raku fo li. Ma talasi wale li galona fo 'e dao 'i laola raku fo li, wale galona gera lio sulia raku fo li, gera ka kwaia, sui gera ka olifae gwaugwau ala 'i so'ela wale ba'ela lia. ");
INSERT INTO lgl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ma wale ba'ela fo ka keria lou ruala wale li galona. Ma wale galona gera lio sulia raku fo li, gera ka kwaia lou, ma gera ka sae ta'a fala, ma gera ka olifae gwaugwau lou ala. ");
INSERT INTO lgl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'Urifo, wale ba'ela fo ka keria lou olula wale li galona lia, ma gera ka kwai ta'a ala rabela ka kakasi, ma gera ka taasi 'alia faasia lifi fo. ");
INSERT INTO lgl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","'I burila, wale ba'ela fo ka malata 'uri 'e, ‘Ta taa lou 'e lakae taua? Mala laka kwatea lo 'agua wela wale 'e lau, lau kwaima rasua ala. Mala 'i lia bui wale galona gera lio sulia raku li gera kae bi soi ba'ela ala.’ ");
INSERT INTO lgl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mola talasi wale gera galo ala raku fo li, gera lesia wale fo, gera ka sae 'uri 'e 'i matanada kwailiu, ‘'I lia wela kwalaimoki ala wale ba'ela ba li lo 'e, 'i lia kae sakea raku 'e. Golu raunia ka mae 'ali golu sakea lo raku 'e 'agaulu.’ ");
INSERT INTO lgl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Urifo mola gera ka taba sulia wale fo 'i maluma faasia 'i laola raku ba, ma gera ka raunia ka mae lo.” Ma Jesus ka soilidida 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Taa wale ba'ela ala raku fo li kae taua? 'I lia kae dao mae, ka raunia wale fo gi. Sui ka kwatea lo raku lia fala ioli mamata gi.” Talasi ioli gi gera ronoa alaana fo Jesus li, gera ka sae lo 'uri 'e, “Iko, 'e 'ato 'ali 'urila!” ");
INSERT INTO lgl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sui Jesus ka lio nanata fada, ka sae 'uri 'e, “Ala iko 'ali 'urifo, taa 'e malutala alaana ba 'i laola Geregerena Abu lia ba 'e sae 'uri 'e, ‘Fau 'e wale raunae luma gi gera barasi 'alia, 'i lia lo fau ageage 'e 'ilitoa ka liufia fau ala balibali gi li sui.’ ");
INSERT INTO lgl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Ma ala ite 'e toli fofola fau fo, 'i lia kae manisi. Ma ite fau fo 'e toli fafia, rabela kae meme sui.” ");
INSERT INTO lgl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ala talasi fo, fata abu ba'ela gi failia wale falalau ala taki gi li, gera ka bi lio raea alaana fo Jesus 'e tauda suli gera gi, ma gera ka oga daunala ala talasi fo. Wasua ma gera ka mau lou 'ada 'alia ioli gi. ");
INSERT INTO lgl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ma wale etaeta gi gera ka mailia fala daona tonala ta matolaa fala doinala Jesus. Ma gera ka folia nali wale 'uri 'ali gera ka koto 'alia soilidinala Jesus. Sulia gera oga gera kae suafafia 'alia ta 'are iko 'ali rada, 'ali ma ka totolia kwatenala fala wale ba'ela 'i Rom 'e lio sulia 'i Judea. ");
INSERT INTO lgl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Gera dao 'i so'ela, ma gera ka sae 'uri 'e, “Waleli falalauna, meulu saiai 'o faalalau, ma ko ilia 'are kwalaimoki gi. Ma iko 'ali 'o 'ado mola failia ta ioli 'alia ta taa gera malata sulia. 'O faalalau mola sulia kwalaimokina ma kwaiogalina God fala ioli li. ");
INSERT INTO lgl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","'O iilia mae fameulu, 'Uri'e ma 'e rada mola 'ala fagaulu fala kwatenala seleni ala takisi li fala walelitalona 'i Rom 'o ma iko?” ");
INSERT INTO lgl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma Jesus ka lio raea kotona daulu, ma ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Fatailia ga mae ta seleni fagu.” Ma talasi gera sakea mae te seleni fala, 'i lia ka soilidida 'uri 'e, “'Uri'e ma lulula ite 'e 'i fofola seleni 'e? Ma ratala ite 'e lou?” Ma gera ka olisia 'uri 'e, “Walelitalona 'i Rom.” ");
INSERT INTO lgl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma Jesus ka sae 'uri 'e fada, “Ala 'urilali, 'amu ka kwatea fala walelitalona 'i Rom 'are lia gi, ma 'amu ka kwatea lou 'are God gi fala God.” ");
INSERT INTO lgl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma daulu ka io aroaro, sulia daulu 'afero rasua 'alia olisina fo Jesus 'e taua adaulu. Ma iko 'ali gera totolia lo 'ali gera daria ta me kotona ala Jesus 'i maala ioli fo gi. ");
INSERT INTO lgl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sui, nali Sadusi gera ka la mae 'i so'ela Jesus. Sadusi gi gera iilia 'uri ioli gi ikoso gera tatae lou faasia maena. Ma gera ka soilidia Jesus gera ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Waleli Falalauna, Moses 'e gerea taki faga ka iilia, ‘Ala ta wale 'e mae, ma wateu lia ka mauri 'ua, ma iko 'ali too ala ta wela, walefae lia ka tolea lou me 'oru fo, 'ali daro ka too ala ta wela 'ali ka olitalala wale fo 'e mae lo.’ ");
INSERT INTO lgl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Ala te talasi, fiu walefae gi gera io. Ma wale 'i lao ka tolea te geli, ma iko 'ali alua mola ta wela, wale fo ka mae lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","“Ma ruala walefae ka tolea lou me 'oru fo, ma ka mae lou. ");
INSERT INTO lgl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sui olula walefae ka 'urifo lou. Ma ka 'urifo lou fala ai burila gi sui. Fiu walefae fo gi sui mola, daulu toletolea geli fo, ma iko 'ali daulu too mola ala ta wela, ma daulu ka mae sui. ");
INSERT INTO lgl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma suinai, geli fo ka mae lou. ");
INSERT INTO lgl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","'Urifo ma, ala atoa God kae taea ioli mae gi sui faasia maena li, ite adaulu lo wateu lia? Sulia fiu walefae fo gi sui mola ba daulu toletolea geli fo.” ");
INSERT INTO lgl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma Jesus ka olisi 'uri 'e adaulu, “Talasi 'e, wale gi ma geli gi, gera arai ma gera ka wateu. ");
INSERT INTO lgl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wasua ma ala talasi kae dao mae, wale failia geli gera totolia tataena faasia maena li, ma gera ka too lo ala maurina firi 'i nali li, ikoso gera arai ma ikoso gera wateu lo. ");
INSERT INTO lgl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Sulia gera malaa lo 'ada eniselo gi, ma ikoso gera mae lo. 'I gera wela God gi lo, sulia gera tatae lo faasia maena. ");
INSERT INTO lgl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“'Urifo, ma geregerena Moses 'e faamadakwa lo faga lia ioli mae gi, gera kae mauri lou. Sulia talasi ba God 'e fatailia fala Moses ala dunaa ba 'e 'agofia 'ai wawade ba li, Moses 'e soia God 'alia, ‘God 'a Abraham, ma God Aesak, ma God Jakob.’ ");
INSERT INTO lgl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Malutala 'e 'uri 'e: Nali ioli gera mae lo, gera kae foasia mola 'ada God, sulia gera mauri lo failia.” ");
INSERT INTO lgl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma nali wale ala wale falalau ala taki gi li, gera ka sae 'uri 'e, “Wale li faalalauna, olisina 'o 'e 'oka rasua!” ");
INSERT INTO lgl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma gera ka mau lo 'alia Soilidinala. ");
INSERT INTO lgl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sui Jesus ka soilidi 'uri 'e ada, “'E 'utaa, gera iilia Christ wale ala kwalofa David li? ");
INSERT INTO lgl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David ba 'e sae 'uri 'e sulia 'i laola Geregerena ala Sam gi, ‘God 'e sae 'uri 'e fala Aofia lau: 'O gwauru 'i gula aolo agu, ma ko 'ilitoa faelau, ");
INSERT INTO lgl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","maasia talasi lakae alua malimae 'o gi gera ka ronosuli 'o.’ ");
INSERT INTO lgl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“David 'ala 'i talala 'e soia Christ 'alia ‘Aofia.’ Lia fo, Christ iko lou ulufa'alu ala kwalofa David li mola. 'I lia Aofia David lou.” ");
INSERT INTO lgl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Talasi ioli afula gi gera fafurono, Jesus ka sae 'uri 'e fala wale li galona lia gi, ");
INSERT INTO lgl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“'Amu ka madafi 'amiu faasia wale falalau ala taki Moses gi li, sulia gera oga liuna failia to'omi tekwa gi li. Ma gera ka oga rasua lou 'alia ioli ka fa'ilitoada, ma gera ka sae 'oka fada 'i maala uusina gi. Ma gera ka oga gwauruna 'i lao ala lifi 'ilitoa li gwauruna gi 'i laola luma fala foana gi li, ma ala lifi 'oka gi talasi ala fanana gi li. ");
INSERT INTO lgl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Wasua ma gera belia luma gi failia 'are me 'oru gi gera too ali gi. Ma gera ka foa tekwa, 'uri 'ali ioli ka sae 'oka sulida. Wale faalalau ala taki Moses gi li, kwaikwaina gera kae ta'a rasua fada!” ");
INSERT INTO lgl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Talasi Jesus 'e io 'ua 'i laola Luma Abu God li, ka liolio, ma ka lesia ioli too'are gi gera laa mae fala kwate bata na 'i laola kukufi 'are fala alu bata na 'i laola. ");
INSERT INTO lgl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma ka lesia lou te 'oru 'e siofaa rasua. 'E laa mae, ma ka kwatea rua me seleni wawade gi. ");
INSERT INTO lgl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma Jesus ka sae 'uri 'e, “'Are kwalaimoki lakae ilia famiu, kwatena 'e me 'oru siofa 'e 'e kwatea, 'e ba'ela ka tasa liufia ioli 'e gera kwate seleni ba'ela gi. ");
INSERT INTO lgl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sulia ioli too'are gi, gera kwatea mola na gula wawade ala too 'arena gera gi. Ma me 'oru siofa 'e, 'e kwatea sui lo 'are 'e too ali fala ionala gi.” ");
INSERT INTO lgl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ma nali wale li galona ala Jesus, gera ka tafea Luma Abu God, sulia lesinai 'e kwana 'oka rasua 'alia me fau 'oka gera launia 'alia gi, ma ala kwatena gera kwatea fala God gi lou. Sui Jesus ka sae 'uri 'e fadaulu, ");
INSERT INTO lgl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“'Are 'e 'amu lesida lo gi sui, fe atoa kae dao mae ikoso ta teke me fau wasua 'ali io 'i fulila, gerakae tagalae sui 'i wado!” ");
INSERT INTO lgl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma gera ka soilidia 'uri 'e, “Wale li faalalauna, nanita 'e 'are 'e gi kae dao mae ai? Ma ta taa kae etae fuli, 'ali fatailia talasi fala 'are 'e gi li 'e dao lo?” ");
INSERT INTO lgl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma Jesus ka olisi 'uri 'e adaulu, “Moulu ka liolio 'oka, ma ikoso 'ali 'amu ala'alia ta ioli ka talai rero amiu. Sulia ioli afula gi gerakae dao mae 'alia ratagu, ma gera kae sae 'uri 'e, ‘'I lau lo Christ!’ Ma gera kae sae lou 'uri 'e, ‘Talasi 'olea 'e dao lo!’ Ikoso moulu la sulida. ");
INSERT INTO lgl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma ikoso 'ali 'amu mau ala talasi 'amu ka rono ala mae gi, failia alaana sulia mae gi li, sulia 'are fo gi kae etae fuli ga 'i lao. Wasua 'are fo gi ka fuli, suinala talasi iko 'ali garani 'ua.” ");
INSERT INTO lgl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sui Jesus ka sae lou fala wale li galona lia gi 'uri 'e, “Mae falua gi gera kae kwalaa kwailiu, failia tatalona gi gera kae kwalaa kwailiu. ");
INSERT INTO lgl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma lululu ba'ela gi kae 'asu, failia fiolo, failia mataina ba'ela rasua gi kae liu ala falua gi sui, ma 'are ba'ela mamata fala mauna 'alida gi, failia totofo kae manotafa mae faasia 'i laola lofola raloo li. ");
INSERT INTO lgl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma 'i lao ala 'are fo gi kae fuli, gera kae taua 'are ta'a gi amiu, sulia 'amu ronosuli lau. Gera kae firi 'amiu, ma gera kae faamalifii 'amiu, ma gera kae kwate 'amiu fala luma fala foana gi li 'ali gera mailitonamiu, ma gera kae alu 'amiu 'i laola raraa, ma gera kae sake 'amiu 'i lao ala wale etaeta gi fala loko kwaikwaina amiu. ");
INSERT INTO lgl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ka 'urifo ma talasi 'oka 'amiu bui fala saena sulia Faronona 'Oka God li fo. ");
INSERT INTO lgl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma ikoso 'ali 'amu malata 'abero lou fala ta taa 'amu kae olisida 'alia. ");
INSERT INTO lgl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sulia lakae kwatea sui famiu alaana ala liotoo li, ma iko ta malimae 'amiu kae sae olisi 'amiu, 'o ma ka tofe 'alia 'are 'amu kae ilida gi. ");
INSERT INTO lgl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma mama 'amiu gi, teite 'amiu gi, ai burimiu gi, ma walefae 'amiu gi, failia kwaima 'amiu gi, gerakae kwate 'amiu fala wale etaeta gi. Ma tali ioli amiu gerakae raunida. ");
INSERT INTO lgl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ioli gi sui gera kae malimae amiu 'i dunagu. ");
INSERT INTO lgl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ka 'urifo wasua 'ala, 'ato ta teke ifu wawade ala gwaumiu kae iko. ");
INSERT INTO lgl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","'Amu ka ura nasi 'alia fakwalaimokina 'amiu gi, 'ali 'amu ka mauri firi.” ");
INSERT INTO lgl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ma Jesus ka sae lou 'uri 'e fada, “Talasi 'amu lesia wale li kwalana gi li, gera ala galia 'i Jerusalem, moulu ka saiai gera kae tagalailia lo falua ba'ela 'e. ");
INSERT INTO lgl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ma ala talasi fo, ioli gera io 'i Judea gi, gera kae tafi sui fala gwaula fe uo gi. Ma ioli gera ioio 'i laola mae falua ba'ela 'e li, gera kae tafi faasia. Ma ioli gera io galia ikoso gera oli lou mae fala falua ba'ela 'e. ");
INSERT INTO lgl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sulia talasi lo fala kwaikwai na li, 'ali 'are ba gera geregere sulia 'i laola Geregerena Abu li kae fuli kwalaimoki lo. ");
INSERT INTO lgl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ala talasi fo, kwaimalatai na ba'ela fala geli gera dodolanaa gi, failia geli gera faasusua wela wawade gi li, sulia 'e 'ato fada 'ali geraka tafi. Ma kwaimalatai na ba'ela kae dao fafia falua 'e, sulia God kae kwaia ioli 'i laola gi. ");
INSERT INTO lgl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nali ioli ada gera kae raunida 'alia 'au li ofona gi. Ma tali ioli ada gera kae dauda, ma gera kae firi fafida, ma gera kae sakeda fala falua mamata gi. Ma ioli mamata faasia Jiu gi li, gera kae fafuta'a falua ba'ela 'i Jerusalem la la ka dao ala suinala talasi gera. ");
INSERT INTO lgl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“'Are mamata gi kae fuli ala da'afi, madama, failia kwalikwali gi. Ma ioli ala mae falua ba'ela 'i laola molagali gi li sui, gera kae fitala, ma gera kae mau 'alia raenala asi, failia mabitanala fe lafolafo gi. ");
INSERT INTO lgl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ma ioli gi gera kae maefulu sulia gera kae mau rasua, talasi gera kae maasia daonala mae 'are 'e gi fafia molagali 'e sui. Sulia 'are 'i laola raloo gi li, gera kae la rero. ");
INSERT INTO lgl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Talasi fo bui, 'i lau, Wela Wale li, lakae bi dao mae. Lakae dao mae failia nanatana ba'ela, failia madakwana ba'ela 'i fofola me dasa gi. ");
INSERT INTO lgl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma talasi 'are 'e gi 'e fuli'ae kae fuli, 'amu ka ura, ma 'amu ka lio 'alaa, sulia talasi God kae faamauri 'amiu, 'e dao garani lo mae.” ");
INSERT INTO lgl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sui Jesus ka sae sulia tarifulaana fada 'uri 'e, “Moulu malata ga sulia 'ai 'e gera soia 'alia figi failia 'ai gi sui lou 'i lifi'e. ");
INSERT INTO lgl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Talasi 'amu lesia 'abala 'e ulua 'oka, 'amu ka sailoai talasi fala 'ago'agonali 'e garani lo. ");
INSERT INTO lgl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka 'urifo lou, ala talasi 'amu lesia 'are fo gi 'e fuli, 'amu ka sai lo ala talasi God kae 'ilitoa, 'e dao garani lo. ");
INSERT INTO lgl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Are kwalaimoki rasua lakae ilia famiu, 'are fo gi kae fuli sui ioli 'e gera mauri 'ua ala talasi 'e gi li, gera ka bi mae. ");
INSERT INTO lgl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Raloo failia molagali gera kae sui, ma saenagu ikoso 'ali sui. ");
INSERT INTO lgl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“'Amu ka lio lio 'oka. Ikoso 'ali 'amu tau sulia fanana ba'ela gi, ma gou na fala lulumui na li, ma malata 'aberona gi ala maurina 'e 'i laola molagali li. Ala 'amu tau 'urifo, fe atoa fo kae dao faamaola 'amiu malaa na 'aisiki. ");
INSERT INTO lgl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sulia 'are fo gi kae dao mae fafia ioli gi sui, ala lifi gi sui 'i laola molagali 'e. ");
INSERT INTO lgl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","'Amu ka liolio 'oka, ma 'amu ka foa ala talasi gi sui, 'ali 'amu too ala nanatana fala iona 'i laola 'are fo kae fuli gi li. 'Amu ka liolio 'oka, ma 'amu ka foa ala talasi gi sui 'ali ikoso 'ali 'amu 'eke lou talasi 'amu kae ura 'i maagu agu, Wela Wale li.” ");
INSERT INTO lgl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ala atoa gi sui, Jesus 'e faalalau ioli 'i laola Luma Abu God. Ma raurafi gi ka la fala gwaula fe uo 'i Olif. ");
INSERT INTO lgl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma ala 'ofaedani ala rafule gi sui, ioli afula gera ka la mae 'i laola Luma Abu God fala rononala saenala Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Talasi fala Fanana ala Daofae Liu na Jiu gi li 'e garani lo. Ala fanana fo, gera saiala 'aninala berete iko ta ist ai. ");
INSERT INTO lgl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma fata abu ba'ela gi, failia wale falalau ala taki gi li, gera ka malata fala rau agwaagwa na ala Jesus, sulia gera maulia ioli gi. ");
INSERT INTO lgl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma Saetan ka ruufia Judas Iskariot, na wale ala akwala wala rua wale li galona ba Jesus gi. ");
INSERT INTO lgl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sui Judas ka laa 'i so'ela fata abu ba'ela gi, failia wale etaeta ala wale gera lio sulia Luma Abu God gi li, ma ka iilia fada 'e saiai ka kwairanai fala daunala Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ma gera ka babalafe rasua, ma gera ka kwate seleni fala. ");
INSERT INTO lgl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ka alafafia, ma ka fuli'ae ka lio 'afia ta talasi iko ta ioli 'ali io failia Jesus, 'ali 'e kwatea Jesus fada. ");
INSERT INTO lgl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","'Urifo, atoa ioli Jiu gi fala 'aninala berete iko ta ist 'i laola 'e dao lo. Atoa fo, gera raunia lou kale sipsip gi, ma gera ka rerei 'alia fana fala Fanana ala Daofae Liu na li. ");
INSERT INTO lgl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ma Jesus ka keria Peter failia John ka sae 'uri 'e fadaroa, “Mora lai rerei 'alia fana fagaulu fala 'aninai ala Fanana ala Daofae Liu na li.” ");
INSERT INTO lgl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Daro ka soilidi 'uri 'e ala Jesus, “'I fe lo 'o oga mera kae rerei 'alia lifi fala fana na li?” ");
INSERT INTO lgl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesus ka olisi daroa 'uri 'e, “Talasi mora dao lo ala falua li, mora kae dao tonala te wale kae sakea fe 'are fala sake kwainali. Mora ka la sulia fala luma kae la fai. ");
INSERT INTO lgl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Mora ka sae 'uri 'e fala wale fo luma lia li, ‘Wale li faalalauna 'e sae mae 'uri 'e famu: 'I fe mae luma 'ali lau 'ania Fanana ala Daofae Liu na li failia wale li galona lau gi?’ ");
INSERT INTO lgl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma wale fo kae fatailia mae tobi ba'ela ala luma la 'e io 'i nali, lifi la 'are gi gera rerei lo 'alida, ma 'i lifila mora kae rerei 'alia fana gi.” ");
INSERT INTO lgl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","'Urifo, daro ka la lo, ma daro ka dao tonala 'are gi sui malaa lo liafo Jesus 'e ilia fadaroa. Ma daro ka rerei lo 'alia fana 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","'E dao lo ala talasi fala 'aninala Fanana ala Daofae Liu na li, ma Jesus failia wale li lifurono lia gi, daulu ka gwauru lo ala lifi li fana. ");
INSERT INTO lgl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma ka sae 'uri 'e fadaulu, “Lau oga rasua 'aninala Fanana ala Daofae Liu na li fae 'amoulu, sui laka bi famalifii 'agua. ");
INSERT INTO lgl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ma laka ilia famoulu, 'e 'ato 'ali lau 'ania lou Fanana ala Daofae Liu na li fae 'amoulu, la la ka dao ala talasi ala fakwalaimokinala talasi God kae 'ilitoa.” ");
INSERT INTO lgl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sui Jesus ka sakea teu, ma ka batafea God. Sui ka sae 'uri 'e fada, “Moulu sakea, ma moulu ka 'ado ai 'i safitamoulu. ");
INSERT INTO lgl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Lakae ilia famoulu, fuli 'i tara'ela ka la 'alaa, ikoso lau goufia lou waen 'e la la ka dao ala talasi 'ilitoanala God kae fatae ai.” ");
INSERT INTO lgl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sui Jesus ka sakea berete, ma ka batafea God, sui ka liia, ma ka kwatea fadaulu. Ma ka sae 'uri 'e, “Lia 'e lo rabegu, lau kwatea folosi 'amiu. 'Amu ka tau talau ala 'are 'e fala malata na tonagu.” ");
INSERT INTO lgl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","'I burila fanana, ka sakea lou teu, ka sae 'uri 'e, “Lia 'e lo 'abugu, lia 'e afe fala foasina folosi 'amiu. God 'e fanasia alafuuna fa'alu 'alia 'abugu. ");
INSERT INTO lgl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Lesia ga! Wale kae kwate lau fala malimae lau gi li, 'e gwauru lou fae lau 'i lifi'e ala lifi li fana. ");
INSERT INTO lgl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sulia 'i lau, Wela Wale li, lakae mae malaa lo God 'e oga fagu. Wasua ma, 'e ta'a rasua fala wale 'e kae kwate lau fala malimae lau gi li!” ");
INSERT INTO lgl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma daulu ka fuli'ae fala soilidi kwailiuna 'i safitadaulu 'afia ite adaulu fo kae taua me 'are fo. ");
INSERT INTO lgl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma wale li galona lia gi gera ka alafaitalili 'i safitadaulu kwailiu fafia ite adaulu lo 'e 'ilitoa ka tasa. ");
INSERT INTO lgl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma Jesus ka sae 'uri 'e fadaulu, “Moulu saiala wale ba'ela gera 'ilitoa fala ioli mamataa faasia Jiu gi li, gera too ala nanatana, ma gera sai rasua ala sunailianala ioli fala taunala 'are gera ogada gi. Ma gera ka oga ioli ka soida 'alia wale 'ilitoa gi. ");
INSERT INTO lgl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wasua, ikoso 'ali 'amu tau lou 'urifo 'i safitamoulu. Ite amoulu 'e kwaitalai, 'i lia ka malaa wale 'e mamaea. Ma ioli 'e 'ilitoa, 'i lia ka malaa ioli li galona. ");
INSERT INTO lgl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","'Uri'e ma ite 'e gera iilia 'e ioli 'ilitoa, ioli 'e gwauru fala fana na li, 'o ma ioli 'e galo 'ala? Ioli 'e gwauru fala fana na lo 'e 'ilitoa. Wasua ma 'i lau lau io 'i safitamoulu malaa wale li galona. ");
INSERT INTO lgl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Moulu io lo mae fae lau 'i laola ilitoona lau gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Malaa Mama lau 'e kwatea sui lo 'ilitoana fagu, 'i lau wasua laka kwatea lou 'ilitoana famoulu, ");
INSERT INTO lgl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","'ali moulu ka fana fae lau, ma moulu ka gou fae lau 'i laola Tatalona lau. Ma moulu kae gwauru ala lifi li gwauruna ai fala 'ilitoana li, ma moulu kae 'ilitoa fafia akwala wala rua fuui wale ba 'i Israel gi.” ");
INSERT INTO lgl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sui Jesus ka sae 'uri 'e fala Peter, “Simon Peter! 'O fafurono ga. God 'e ala'alia Saetan, 'ali kae mailia 'ali kae tagalae 'amoulu sui faasi lau, malaa wale 'e galo 'i laola raku fala 'efonala fufuae 'are 'oka gi li faasia taetae 'are ta'a gi. ");
INSERT INTO lgl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ka 'urifo wasua 'ala Simon, lau foa famu, 'ali ikoso oli fae buri ala fitoona 'o. Ma ala talasi 'o malata oli lou mae tonagu ko fananata ioli gera fakwalaimoki agu gi.” ");
INSERT INTO lgl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma Peter ka olisi 'uri 'e ala, “Aofia, lau kwaimamali mola 'agua fala laa na fae 'o 'i laola raraa li, ma fala maena fae 'o!” ");
INSERT INTO lgl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma Jesus ka olisia 'uri 'e, “Peter, laka ilia famu, 'i laola fe boni 'e tara'ela, 'i lao ala karai kae ani, koe tofe olu talasi 'uri iko 'ali 'o sai agu.” ");
INSERT INTO lgl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sui Jesus ka soilidi 'uri 'e ala wale li galona lia gi, “'Uri'e ma talasi ba lau keri 'amoulu ma iko 'ali moulu too ala ta seleni, 'o ma ta wai, 'o ma ta 'ae botu, moulu olidodoko 'ali ta me 'are ba?” Ma daulu ka olisi 'uri 'e ala, “Iko mola.” ");
INSERT INTO lgl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma Jesus ka sae 'uri 'e, “Ma talasi 'e, ite 'e too ala ta seleni 'o ma ta wai, 'i lia ka sakea lo. Ma ite iko 'ali too ala ta 'au li ofona, 'i lia ka foli 'alia to'omi ba'ela lia, ma ka folia ta 'au 'alia. ");
INSERT INTO lgl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Lakae ilia 'are 'e famoulu, sulia Geregerena Abu ba 'e sae suli lau 'uri 'e, ‘Gera alua failia ioli ta'a gi.’ 'Are fo kae fuli lo fagu, sulia geregerena suli lau gi sui kae fuli kwalaimoki lo.” ");
INSERT INTO lgl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma wale li galona lia gi daulu ka sae 'uri 'e, “Aofia, lesia ga golu too lo ala rua 'au li ofona gi 'i lifi'e!” Ma 'i lia ka olisi 'uri 'e adaulu, “'E 'oka lo. Mano lo 'urila.” ");
INSERT INTO lgl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus failia wale li galona lia gi, daulu tafisia lo falua ba'ela fo, ma daulu ka la lo fala fe uo gera soia 'alia Olif, malaa ba daulu kae 'idufae la la lo ai ala talasi gi li sui. ");
INSERT INTO lgl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma talasi daulu dao ala lifi fo li, 'i lia ka sae 'uri 'e fadaulu, “Moulu foa, taufasia ilitoona gi bi liufi 'amoulu.” ");
INSERT INTO lgl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sui Jesus ka 'idu wawade lou ko faasidaulu ka totolia 'ui na 'alia ta me fau li, ma ka boururu 'i fua, ka foa. ");
INSERT INTO lgl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ka foa 'uri 'e, “Mama 'e, ala ko marabe, 'o lafua famalifiina 'e faasi lau. Wasua, iko lou liogu, ma sulia liomu lou 'ala.” ");
INSERT INTO lgl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma te eniselo faasia 'i nali 'e dao mae, ma ka fananata lia. ");
INSERT INTO lgl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma talasi liola 'e fii rasua, ka foa nanata lou. Ma 'ida'ida 'i rabela ka udu ka toli 'i wado malaa na uduudui 'abu. ");
INSERT INTO lgl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ma talasi 'e tatae faasia foana li, ka oli 'i so'ela wale li galona lia gi. Daulu mo'osu 'adaulu, sulia daulu kweo rasua 'alia kwaimalataina. ");
INSERT INTO lgl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma Jesus ka sae 'uri 'e fadaulu, “'Uta 'e moulu ka mo'osu 'uri'e? Moulu tatae, ma moulu ka foa, taufasia ilitoona gi ka bi liufi 'amoulu.” ");
INSERT INTO lgl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Talasi Jesus kae sae 'ua mola 'ala failida, te logonae wale ba'ela gera ka dao lo mae. Ma na wale ala wale li galona ba lia gi, lia ratala Judas, 'e talaida mae. Ma ka dao mae 'i so'ela Jesus, ma ka lotofia 'i babalila. ");
INSERT INTO lgl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ma Jesus ka sae 'uri 'e fala, “Judas, 'o kwate lau, Wela Wale li, fala malimae lau gi 'alia lotofiinagu!” ");
INSERT INTO lgl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma talasi wale li galona daulu io failia Jesus gi, daulu lesia 'are fo gi li, daulu ka sae 'uri 'e, “Aofia! 'Uri'e ma meulu ka kwaida 'alia 'au li ofona 'e 'ameulu gi?” ");
INSERT INTO lgl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma na wale adaulu, ka kwaia te wale li galona 'ilito'ola fata abu, ma ka tofu tabia lo gula anina aolo ala. ");
INSERT INTO lgl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mola Jesus ka sae 'uri 'e, “Mano lo 'urila!” Ma ka dau tonala aninala wale fo, ma ka guraa lo. ");
INSERT INTO lgl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sui Jesus ka sae fala fata abu ba'ela gi, failia wale gera lio folo bolosia Luma Abu God gi li, failia wale ba'ela gera laa mae 'i lifi fo fala doinala gi, ka sae 'uri 'e, “'Uri'e ma, 'i lau wale belibeli 'e, 'ali moulu laa mae 'afi lau failia 'au gi failia subi gi? ");
INSERT INTO lgl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Lau io mola 'agua 'i soemiu 'i laola Luma Abu God sulia atoa gi, ma iko 'ali 'amu tau mola fala daunagu. Wasua ma talasi 'amoulu lo 'e, 'ali moulu galo lo 'alia nanatana Saetan, wale 'e 'ilitoa fafia mae rodo li.” ");
INSERT INTO lgl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sui gera ka daua lo Jesus, ma gera ka talaia lo 'i laola luma 'ilito'ola fata abu. Ma Peter ka liu lo mae 'i burida ala na tofui tala 'e tatau lou faasida. ");
INSERT INTO lgl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma te dunaa gera galofia 'i matanala gula abitakwa 'i laola labata ala luma li, ma Peter ka gwauru 'ala failia ioli gera gwauru galia dunaa fo li. ");
INSERT INTO lgl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ma talasi te geli ulao li galona 'e lesia Peter 'e gwauru 'i lififo garania dunaa li, ka lio nanata fala ma ka sae 'uri 'e, “Wale 'e 'e io lou failia Jesus.” ");
INSERT INTO lgl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ma Peter ka tofe 'uri 'e, “Geli fo, iko 'ali lau saiala wale la!” ");
INSERT INTO lgl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma iko 'ali tekwa mola 'i burila, te wale ka lesia Peter ma ka sae 'uri 'e, “'I'o na wale lou adaulu 'e!” Ma Peter ka olisia 'uri 'e, “'I lau iko wale'e.” ");
INSERT INTO lgl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma totolia na teke tofui matola lou 'i burila, na wale lou ka sae nanata 'uri 'e, “'E kwalaimoki. Wale 'e 'e io lou failia Jesus, sulia 'i lia lou wale faasia 'i Galili!” ");
INSERT INTO lgl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ma Peter ka olisia 'uri 'e ala, “Lau raria 'are 'e koe sae sulia wale 'e!” Ma talasi 'e sae mola 'urifo, karai ka ani lo. ");
INSERT INTO lgl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma Aofia ka bulusi, ma ka lio tootoo ko fala Peter. Ma Peter ka malata lo tonala alaana ba Aofia 'e ilia fala 'uri 'e, “'I lao ala karai kae ani, koe tofe olu talasi 'o rari lau.” ");
INSERT INTO lgl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma Peter ka latafa, ma ka ani 'ilu'ilu lo 'alia kwaimalataina ba'ela rasua. ");
INSERT INTO lgl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma wale li ofona gera lio folo galia Jesus gi, gera dorakwala 'alia, ma gera ka rabusia. ");
INSERT INTO lgl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ma gera ka firi bolosia maala, ma gera ka soilidi 'uri 'e ala, “'O iilia ga ite 'e rabusi 'o?” ");
INSERT INTO lgl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma gera ka iilia alaana ta'a afula gi lou ala. ");
INSERT INTO lgl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma 'ofaedani talasi 'e dani lo, wale kwai talai Jiu gi li, ma fata abu ba'ela gi, failia wale falalau ala taki gi li, gera alaa ruru, ma gera ka talaia mae Jesus 'i soedaulu. ");
INSERT INTO lgl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ma gera ka sae 'uri 'e fala, “'O iilia fameulu. 'Uri'e ma 'i'o lo Christ, wale God 'e filia fala famaurinamami?” Ma ka olisi 'uri 'e ada, “Ala laka iilia famoulu, 'e 'ato moulu ka fakwalaimoki lau. ");
INSERT INTO lgl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma ala laka soilidi 'amoulu 'ali ta 'are, 'e 'ato 'ali moulu olisia. ");
INSERT INTO lgl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ma 'e fuli ala talasi 'e ka la 'alaa, 'i lau, Wela Wale li, lakae gwauru 'i gula aolo ala God 'e nanata ka tasa, ma lakae 'ilitoa failia.” ");
INSERT INTO lgl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma 'i gera sui mola gera ka soilidia 'uri 'e, “'Uri'e ma 'i'o lo 'e Wela God?” Ma ka olisi 'uri 'e ada, “Lia la 'amu talae iilia lo.” ");
INSERT INTO lgl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma gera ka sae 'uri 'e, “Iko 'ali golu oga lo ta ioli li sae fakwalaimokina lou. Sulia golu talae ronoa sui lo ala saenala lia 'e ilia 'i lia Wela God li!” ");
INSERT INTO lgl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma logonae wale etaeta fo sui, gera tatae, ma gera ka talaia Jesus 'i so'ela Paelat fala lokokwaikwaina ala. ");
INSERT INTO lgl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma gera ka fuli'ae fala suu fafinala 'alia 'are rero gi ma gera ka sae 'uri 'e, “Meulu daria wale 'e 'e sae aninala ioli 'amami gi. Ma ka ilia fada 'ali ikoso gera kwatea seleni ala takisi li fala walelitalona 'i Rom, ma ka ilia 'uri 'i lia lo Christ, wale 'e God 'e filia fala tatalofa nali.” ");
INSERT INTO lgl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma Paelat ka soilidia 'uri 'e, “'Uri'e ma 'i'o lo walelitalona ioli Jiu gi li, ne?” Ma Jesus ka olisia 'uri 'e, “Lia la 'o iilia lo.” ");
INSERT INTO lgl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sui Paelat ka sae 'uri 'e fala fata abu ba'ela gi, failia logona fo, “Iko 'ali lau daria mola ta rerona ala wale 'e 'ali totolia rauninala.” ");
INSERT INTO lgl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma gera ka sae nanata 'uri 'e, “Ma 'i laola provins 'i Judea sui, wale 'e 'e fafuta'a lo ioli 'alia falalauna lia. 'E fuli lo mae 'i Galili lala ka dao lo 'i lifi'e.” ");
INSERT INTO lgl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ma talasi Paelat 'e ronoa me 'are fo li, ka soilidi 'uri 'e adaulu “'Uri'e ma wale 'e 'e laa mae faasia 'i Galili?” ");
INSERT INTO lgl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma talasi 'e saiai lia Jesus 'e laa mae faasia lifi Herod 'e 'ilitoa fafia, ka keria Jesus 'i so'ela Herod. Sulia Herod 'e io lou 'i Jerusalem ala talasi fo. ");
INSERT INTO lgl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ma talasi Herod 'e lesia Jesus, ka babalafe rasua, sulia 'e ronoa alaana sulia, ma ka kwaimasi ka tekwa lo mae fala lesinala. Ma 'e oga lesinala Jesus 'ali taua ta 'are li 'aferona. ");
INSERT INTO lgl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herod 'e soilidia 'are afula gi ala, ma Jesus iko 'ali olisia mola 'alia ta 'are. ");
INSERT INTO lgl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ma fata abu ba'ela gi, failia wale falalau ala taki gi li, gera ura lou 'i lififo, ma gera ka sae nanata fala suafafinala Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma Herod failia wale li kwalaana lia gi, daulu ka dorakwala 'adaulu 'alia Jesus, ma daulu ka sae ta'a fala. Ma daulu ka faaruufia 'alia te to'omi tekwa 'oka, ma ka keri olifaedaulu lou failia 'i so'ela Paelat. ");
INSERT INTO lgl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma 'e fuli ala fe atoa fo, Herod failia Paelat daro ka bi kwaima lou. 'I lao daroa rua malimae gi. ");
INSERT INTO lgl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Paelat ka logosia lo fata abu ba'ela gi, failia wale etaeta gi, ma ioli gi. ");
INSERT INTO lgl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma ka sae 'uri 'e fada, “'Amu keria mae wale 'e 'i soegu, 'amu ka iilia 'uri 'e talai rero ala ioli gi faasia dona nala tatalofa 'i Rom. Ma lau soilidia 'i maamoulu, ma iko 'ali lau daria mola ta rerona ala failia 'are 'e 'amu suafafia 'alida gi. ");
INSERT INTO lgl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma Herod wasua iko 'ali daria mola ta rerona ala, lia 'e ka olifailia lou mae 'ala. Wale 'e iko 'ali taua mola ta 'are 'e rero 'ali ka mae. ");
INSERT INTO lgl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'Are la, lakae kwatea 'ali gera kwaia mola. Sui laka alua ka la lo 'ala.” ");
INSERT INTO lgl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ala Fanana ala Daofae Liu na li, Paelat 'e saiala lugataenala ta teke wale 'e io 'i laola raraa fala Jiu gi, sulia falafala gera 'e 'urifo lo. ");
INSERT INTO lgl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ma 'i gera sui mola gera akwa gera ka sae 'uri 'e, “Moulu raunia wale 'e ka mae! Ma 'o lugasia mae Barabas fameulu!” ");
INSERT INTO lgl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas gera alua 'i laola raraa, sulia 'e fulia kwalaana ba'ela 'i laola falua ba'ela fo, ma 'i lia wale rau ioli. ");
INSERT INTO lgl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Paelat 'e oga ka lugasia Jesus, ma ka soilidia lou logona fo. ");
INSERT INTO lgl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ma gera ka galo 'ala akwana ma gera ka rii 'uri 'e, “Moulu raunia ka mae! 'Amu ka fotoia ala 'ai rara folo!” ");
INSERT INTO lgl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma Paelat ka sae lou 'uri 'e fada ala olula talasi, “Ma ta rerona taa 'e 'e taua? Iko 'ali lau daria mola ta 'are 'e taua 'ali totolia ma ka mae fafia. Lia 'e lakae kwatea 'ali gera kwaia mola, sui laka lugasia, ma ka la lo 'ala.” ");
INSERT INTO lgl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ma gera ka galo ala akwa na ma gera ka suusuu failia fala fotoinala Jesus ala 'ai rara folo. Ma akwana gera ka liufia lo. ");
INSERT INTO lgl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ma Paelat ka kwatea kwaikwaina fo gera suusuu failia sulia suganaa gera. ");
INSERT INTO lgl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma ka lugasia Barabas wale ba gera oga, wale ba gera alua 'i laola raraa fala fulinala kwalaana ba'ela, ma rau iolina li. Sui Paelat ka kwatea Jesus fada, sulia kwaiogalina gera. ");
INSERT INTO lgl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ma wale ofona gi, gera ka talaia lo Jesus fala maena. Ma talasi gera laa ko, gera ka dao tonala te wale ratala Simon, faasia falua 'i Saeren. Gera daua Simon talasi 'e laa mae ma ka ruu 'i laola 'ere 'i Jerusalem faasia te lifi 'i maluma. Ma gera ka alua lo 'ai rara folo 'i gwaula 'aba'abala, ma gera ka suunailia 'ali 'e sakea 'i burila Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma te logona ba'ela gera ka la 'i burila. Ma nali geli 'i laola logona fo gera lagu, ma gera ka anisia. ");
INSERT INTO lgl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesus 'e bulusi fadaulu ma ka sae 'uri 'e, “Geli 'e 'i Jerusalem gi! Ikoso moulu ani fagu. Moulu anisia 'amoulu 'i talamoulu, failia wela 'amoulu gi. ");
INSERT INTO lgl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sulia kae dao ala fe atoa ioli gi gera kae sae 'uri 'e, ‘'Oilakina fala geli gera 'amara gi, failia geli iko 'ali gera fafuta gi, ma iko 'ali gera faasusu gi!’ ");
INSERT INTO lgl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma talasi fo ioli gi gera kae sae 'uri 'e fala fe uo gi, ‘'Amu toli mae fafi 'amami.’ Ma gera kae sae 'uri 'e fala raeraena gi, ‘'Amu kufi mae fafi 'amami.’ ");
INSERT INTO lgl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sulia ala gera taua 'are 'uri'e agu, wale 'e lau rada, gera kae taua 'are 'e ta'a ka tasa amiu lia 'amu too ala ta'ana gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma gera ka sakea lou rua wale belibeli gi, fala rauninadaroa failia Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ma talasi gera li dao ala lifi la gera soia 'alia “Tali gwae Ioli,” gera ka fotoia Jesus ala 'ai rara folo. Ma rua wale belibeli ba gi, gera ka fotoidaroa lou ala rua 'ai rara folo gi, na wale ala gula aolo ala Jesus, ma na ai ala gula mauli ala. ");
INSERT INTO lgl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma Jesus ka sae 'uri 'e, “Mama, 'o kwailufa 'alida, sulia gera raria 'are 'e gera taua.” Ma wale li ofona gi gera ka none malaa daisi, 'uri 'ali gera kae daria ite ada kae sakea to'omi Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ioli gera ura 'i lififo gi li, gera ka lio mola 'ada fala, ma wale etaeta ala Jiu gi li, gera ka dorakwala 'alia gera ka sae 'uri 'e, “'E faamauria ioli mamata gi. Ala lia lo Christ, wale God 'e filia, 'e totolia ka faamauria lia 'i talala.” ");
INSERT INTO lgl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma wale li ofona gi, gera ka dorakwala lou sulia, ma gera ka la ko 'i so'ela, ma gera ka kwatea waen 'afaa fala. ");
INSERT INTO lgl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma gera ka sae 'uri 'e, “Ala 'i'o walelitalona Jiu gi li, 'o faamauri 'o 'i talamu!” ");
INSERT INTO lgl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma gera ka gerea te alaana 'uri 'e 'i gwaula 'ai rara folo, “Lia lo walelitalona Jiu gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma na wale ala rua wale ba gera fotoida failia Jesus gi, ka sae fafuta'a 'uri 'e ala, “'Uri'e ma 'i'o Christ? 'O faamauri 'o talamu ma 'i 'ameroa lou!” ");
INSERT INTO lgl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sui ruala wale ka balufia 'uri 'e ala, “'Uri'e ma, iko 'ali 'o maulia mola kwaikwaina God li 'e, wale 'e li? Golu rada sui mola, sulia gera kwatea mola teke kwaikwaina fagaulu. ");
INSERT INTO lgl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ma 'i gora kwaikwaina 'e 'e rada mola 'ala, sulia gora sakea lo 'i maala 'are ta'a gora tauda gi. Ma 'i lia 'e iko 'ali taua mola ta 'are rero.” ");
INSERT INTO lgl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma ka sae 'uri 'e fala Jesus, “Jesus, 'o malata tonagu talasi koe oli mae 'alia 'ilitoana 'o li.” ");
INSERT INTO lgl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma Jesus ka sae 'uri 'e fala, “Lakae ilia 'are kwalaimoki famu, 'i tara'ela koe io fae lau 'i nali.” ");
INSERT INTO lgl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","'E fuli 'i matoula atoa, da'afi ka iko 'ali tala, ma lifi fo sui ka rodo lo, la la ka dao ala olula tofui matola raurafi. ");
INSERT INTO lgl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma to'omi ba'ela 'e bolosia lifi abu 'i laola Luma Abu God li ka gaga 'alia rua abae 'are gi. ");
INSERT INTO lgl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma Jesus ka akwa ba'ela 'uri 'e, “Mama, lau kwatea lo ko manogu famu.” 'E sae 'urifo ka sui mola, ka mae lo. ");
INSERT INTO lgl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ma wale etaeta ala wale li ofona gi li 'e lesia 'are fo, ma ka batafea God 'uri 'e, “'E kwalaimoki, 'i lia wale rada!” ");
INSERT INTO lgl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma talasi ioli fo gi gera logo, gera ka bubunia, gera lesia maenala Jesus ka sui, 'i gera sui gera oli lo 'ada 'i falua gera gi. Ma gera ka fidalia fuufuuda fala fatailianala kwaimalataina gera gi. ");
INSERT INTO lgl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma ioli gera saiala Jesus gi sui, failia geli gera la mae 'i burila faasia 'i Galili gi, gera ura tatau ko 'ada, ma gera ka lesia 'are fo gi sui. ");
INSERT INTO lgl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ma te wale faasia falua 'i Arimetea 'i laola provins 'i Judea, ratala Josef, 'e io lou 'i lififo. Ma 'i lia wale rada, ma wale 'oka, ma ka faimaasi lou fala lesinala God kae 'ilitoa fafia ioli lia gi. Wasua 'i lia na wale ala alae wale fala lokomalata na 'ala Jiu gi li, iko 'ali 'e ala mola fafia 'are fo gera iilia, ma gera ka taua ala Jesus gi. ");
INSERT INTO lgl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'E laa 'i soela Paelat, ma ka sugaa fala rabela Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ma ka lafua lo rabela Jesus, ma ka buta 'alia 'aba to'omi kaka'a. Ma ka alua 'i laola bao fa'alu fala alunala ioli mae gi lia gera 'elia 'i laola fau ba'ela. ");
INSERT INTO lgl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma fe atoa fo Faraede. Fe atoa fala rerei na fala Sabat li, atoa ala mamalona 'e garani fuli'ae lo. ");
INSERT INTO lgl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Geli fo gera la mae 'i burila Jesus faasia 'i Galili gi, daulu la lou failia Josef. Ma daulu ka lesia bao fo, ma daulu ka lesia lo alunala Jesus 'i laola. ");
INSERT INTO lgl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sui daulu ka oli 'i falua, ma daulu ka rerei 'alia waiwai gi, failia 'are si'ina fofo 'oka gi fali dalafia 'alia rabela Jesus. Ma atoa ala Sabat gera ka mamalo lo, malaa taki 'e ilia. ");
INSERT INTO lgl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","'Ofaedani ala Sade rafule alae geli ba daulu ka sakea waiwai si'ina 'oka daulu rerei 'alida gi, ma daulu ka la lo 'i maala bao fo. ");
INSERT INTO lgl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma daulu ka lesia bao fo 'e tafa lo, sulia abae fau 'e bolosia iko 'ali io lo 'i maala bao fo. ");
INSERT INTO lgl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ma daulu ka ruu ko, wasua ma iko 'ali daulu lesia lo rabela Aofia Jesus. ");
INSERT INTO lgl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma talasi daulu kae malata 'adaulu 'ua sulia me 'are fo li, rua eniselo daro rufia to'omi 'e wasinosino rasua gi, daro ka fatae mae, ma daro ka ura 'i gegedaulu. ");
INSERT INTO lgl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Geli fo gi daulu ka mau rasua, ma daulu ka gwautoli 'i fua. Ma rua wale fo gi, daro ka sae 'uri 'e fadaulu, “'Uta 'e moulu ka lio 'afia wale 'e mauri 'i laola lifi fala ioli mae gi li 'uri'e? ");
INSERT INTO lgl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'E iko 'ali 'e io lo 'i lifi'e, 'e mauri lou. Moulu malata tonala 'are ba 'e faarono 'amoulu sui 'alia, talasi ba 'e io 'ua fae 'amoulu 'i Galili. 'E sae 'uri 'e ba, ");
INSERT INTO lgl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Gera kae kwate lau, Wela Wale li, fala wale ta'a gi, ma gera kae rauni lau ala 'ai rara folo, sui ala olula fe atoa, lakae mauri lou.’” ");
INSERT INTO lgl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sui geli fo gi daulu ka malata tonala saenala. ");
INSERT INTO lgl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ma daulu ka oli lo faasia bao fo, ma daulu ka faronoa akwala wala teke wale ala wale li galona lia gi, ma nali ioli lou gera dao 'i soedaulu. ");
INSERT INTO lgl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Geli gera faronoa wale li lifurono lia gi li, lia 'e Mary faasia Magdala, ma Joana, ma Mary teite James, ma nali geli lou. ");
INSERT INTO lgl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Wasua ma wale wale li lifurono gi gera ka fia 'uria geli fo gi gera alaa bali mola 'ada, ma iko 'ali gera fakwalaimokia mola saenada. ");
INSERT INTO lgl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ma Peter ka tatae, ma ka lalao fala maala bao. Ma 'e 'adaoro ko, ma ka lesia mola to'omi kaka'a 'e teo 'i lififo gi. Sui ka oli, ma ka 'afero rasua 'alia 'are fo 'e fuli. ");
INSERT INTO lgl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ala fe atoa fo, na rua wale ala wale li galona Jesus gi, daro la fala falua 'i Emeas. 'E totolia teke akwala wala teke tofui tala faasia 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma daro ka alaa 'adaroa sulia 'are fo 'e fuli gi. ");
INSERT INTO lgl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ma talasi daro alaa 'adaroa, Jesus ka liu garani daroa mae, ma ka liu lou fae daroa. ");
INSERT INTO lgl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Daro lesia mola 'adaroa, wasua ma God iko 'ali ala'alia 'ali daro ka lio raea. ");
INSERT INTO lgl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma Jesus ka sae 'uri 'e fadaroa, “Taa 'e mora kae alaa mae sulia talasi 'e mora liu mae ai?” Ma daro ka ura too, ma malatadaroa ka dila. ");
INSERT INTO lgl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma na wale adaroa ratala Kleopas, ka sae 'uri 'e, “Lau fia mala 'i'o mola 'o io 'i Jerusalem, ma iko 'ali 'i saiala 'are 'e fuli 'i laola atoa 'e gi li.” ");
INSERT INTO lgl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma Jesus ka soilididaroa 'uri 'e, “'Are 'utaa gi la ale?” Ma daro ka olisia 'uri 'e, “Me 'are 'e gera taua ala Jesus, wale ba 'i Nasareti. Wale fo, 'i lia profet, wale fala alaana 'alia saenala God, sulia God failia ioli gi gera saiala saenala 'e nanata, ma galonala ka 'ilitoa rasua. ");
INSERT INTO lgl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Fata abu ba'ela 'amami gi, failia wale kwaitalai gi, gera kwatea fala rauninala, ma gera ka fotoia ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma meulu ka malata 'ameulu sulia 'uri 'i lia lo kae fasakwadolaa ioli 'i Israel gi. Ma 'i tara'ela, olula fe atoa lo 'i burila 'are fo gi 'e fuli. ");
INSERT INTO lgl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma meulu ka 'afero rasua, sulia nali geli ala alae ioli 'ameulu, daulu la li dao ala bao. ");
INSERT INTO lgl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ma iko 'ali daulu lesia rabela. Ma daulu ka oli mae, daulu ka ilia daulu lesia eniselo gi gera farono daulu 'alia lia 'e mauri lou. ");
INSERT INTO lgl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma nali wale lou ala alae ioli 'ameulu, daulu la lou ala gigiluna fo, ma daulu ka daria 'e kwalaimoki lo, malaa lo me 'are fo geli fo gi daulu ilia. Ma iko 'ali daulu lesia lo rabela Jesus.” ");
INSERT INTO lgl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma Jesus ka sae 'uri 'e fadaroa, “Mora kwekwe'ela rasua! Ma malatamoroa iko 'ali nainali fala fakwalaimoki nala 'are ba profet gi gera ilia lo mae 'i lao. ");
INSERT INTO lgl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Christ kae famalifii ga, sui ka bi 'ilitoa 'alia 'ilitoana ba'ela.” ");
INSERT INTO lgl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma Jesus ka faalalau daroa 'alia 'are ba gera ilia sulia Christ 'i laola Geregerena Abu gi li. Ka fuli'ae ala geregerena Moses gi failia geregerena Profet gi. ");
INSERT INTO lgl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma talasi daulu dao garania lo falua daulu la fai li, Jesus ka tau 'uri kae liu dao fae liu adaroa. ");
INSERT INTO lgl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma daro ka luia, daro ka sae 'uri 'e, “'O io ga mae 'amua fae 'ameroa, sulia na gula ala atoa 'e liu lo, ma garani ka boni lo.” Ma ka la lo 'ala faedaroa. ");
INSERT INTO lgl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Talasi 'e gwauru lo fala fana na fae daroa, ka sakea tofui berete, ma ka batafea God, sui ka liia berete fo, ma ka kwatea fadaroa. ");
INSERT INTO lgl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Talasi daro lesia me 'are fo li, God ka ala'alia daro ka bi lio raea, ma ka fulu lo faasidaroa. ");
INSERT INTO lgl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma daro ka alaa kwailiu fadaroa, daro ka sae 'uri 'e, “'Eo wani! Talasi ba 'e alaa mae fagaroa sulia tala li, ma ka faalalau gora 'alia Geregerena Abu li, gora babalafe rasua.” ");
INSERT INTO lgl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ma ala me talasi fo mola, daro ka tatae, daro ka oli lou fala 'i Jerusalem. Ma daro ka dao tonala akwala wala teke wale li galona ba gi gera logo mola 'ada, failia nali ioli lou. ");
INSERT INTO lgl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma ioli 'i laola logona fo li gera ka farono daroa 'uri 'e, “Aofia 'e mauri kwalaimoki lo! 'E fatae fala Simon!” ");
INSERT INTO lgl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma daro ka alaa sulia 'are ba 'e fuli sulia tala li, ma sulia talasi daro lio raea talasi kae liia tofui berete li. ");
INSERT INTO lgl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Talasi rua wale fo gi daro kae alaa mola 'adaroa fadaulu, Jesus ka fatae, ma ka ura 'i safitadaulu, ma ka sae 'uri 'e fadaulu, “Aroarona ka io fae 'amoulu.” ");
INSERT INTO lgl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma gera ka maola, ma gera ka mau rasua, sulia gera fia 'uri gera lesia ta aloe 'are. ");
INSERT INTO lgl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma Jesus ka sae 'uri 'e, “Taa 'e taua ma moulu ka mau? Ikoso moulu malata ruarua! ");
INSERT INTO lgl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","'I lau mola tae. Moulu lesia rua limalimagu failia rua 'aegu. Moulu dau tonala rabegu, 'ali moulu saiai, sulia aloe 'are iko 'ali too ala ta suli failia ta filisi, malaa lia 'e 'amu lesia lau too ai.” ");
INSERT INTO lgl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","'I buri 'ala 'e iilia 'are fo gi ka sui, ka fatailia lo fulila maala nila 'i rua limala gi failia rua 'aela gi fadaulu. ");
INSERT INTO lgl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma gera ka babalafe rasua failia 'aferona 'alia. Wasua, gera fitala mola 'ada, sulia iko 'ali gera sai 'oka 'ua ala. Ma Jesus ka sae lou 'uri 'e fadaulu, “Moulu kwatea ta fana 'agua.” ");
INSERT INTO lgl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma gera ka kwatea te tofui ia fala. ");
INSERT INTO lgl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ma ka sakea, ka 'ania 'i maada. ");
INSERT INTO lgl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sui ka sae lou 'uri 'e fadaulu, “'Are 'e gi lau iilida 'ua lo mae famoulu, talasi lau io 'ua mae fae 'amoulu. 'Are 'e gi sui ba gera gereda suli lau 'i laola taki Moses gi, ma 'i laola geregerena Profet gi li, ma 'i laola Sam gi, gerakae fuli kwalaimoki lo.” ");
INSERT INTO lgl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sui Jesus ka tafalia malatada 'ali geraka saiala Geregerena Abu. ");
INSERT INTO lgl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ka sae 'uri 'e fadaulu, “Gera geregere suli lau, Christ, lakae famalifii, ma ala olula fe atoa, lakae tatae lou faasia maena. ");
INSERT INTO lgl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma 'e fuli mae 'i Jerusalem la la ka dao 'i laola falua gi sui, moulu ka sae sulia bulusi na failia kwailufana 'alia ta'ana gi li 'alia ratagu. ");
INSERT INTO lgl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ma 'i 'amoulu lo moulu kae faarono 'alia 'are 'e gi. ");
INSERT INTO lgl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma 'i lau talagu, lakae kwatea Alo ala God famiu lia Mama lau 'e etae alafuu lo 'alia. Ma 'amu ka faimaasi 'i Jerusalem, la la nanatana faasia 'i nali ka sifo mae fafi 'amiu.” ");
INSERT INTO lgl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sui ka talaida lo faasia 'i laola falua ba'ela fo, la la gera ka dao ala falua 'i Betani, ma ka taea lo limala 'i nali, ma ka fa'oka gera. ");
INSERT INTO lgl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ma talasi kae fa'oka gera mola 'ala 'ua ai, ka tafisi gera lo, ma ka oli lo fala 'i nali. ");
INSERT INTO lgl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma gera ka faa aofia, sui gera ka oli lo 'ada 'i Jerusalem failia babalafena ba'ela. ");
INSERT INTO lgl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma talasi afula gi gera io mola 'ada 'i laola Luma Abu God fala batafenala God. ");
INSERT INTO lgl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Fuli 'ua lo mae 'i lao ma God ka bi raunailia molagali, 'are gera soia 'alia Saena 'e io lo, ma ka io lo mae failia God. Ma Saena fo, 'i lia God. ");
INSERT INTO lgl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ala fulina 'ua, Saena 'e io lo mae failia God. ");
INSERT INTO lgl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","God 'e raunailia 'are gi sui 'ali 'i lia. 'Are God 'e raunailida gi sui, 'e raunailida 'alia Saena. ");
INSERT INTO lgl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ma maurina kwalaimoki 'e fuli mae faasia Saena. Ma maurina kwalaimoki fo lo madakwana kwalaimoki 'e faamadakwa 'are kwalaimoki sulia God gi fala ioli. ");
INSERT INTO lgl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Madakwana fo ka rara 'i laola maerodo, ma maerodo 'ato 'ali famaea. ");
INSERT INTO lgl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God ka kwatea mae te wale la ratala John wale fasiuabu, ");
INSERT INTO lgl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","'e la mae fala farononala ioli gi 'alia madakwana fo. 'E la mae ka faarono gera 'alia, 'ali ioli gi sui gera ka ronoa ma gera ka fakwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma John 'i talala iko lou madakwana fo, 'i lia 'e la mola mae 'ali ka faarono sulia madakwana fo. ");
INSERT INTO lgl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sui, madakwana kwalaimoki fo ka bi la mae 'i laola molagali, ma ka rarafia ioli gi sui. ");
INSERT INTO lgl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Saena fo 'e io lo 'i laola molagali. God 'e raunailia molagali 'e 'ali 'i lia, wasua ma ioli gi iko 'ali gera lio raea mola. ");
INSERT INTO lgl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","'E dao mae 'i laola falua lia, wasua ma ioli lia gi iko 'ali gera kwaloa mola. ");
INSERT INTO lgl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma nali ioli gera kwaloa, ma gera ka fakwalaimoki ala ma 'i lia ka kwatea lo nanata na fada 'ali ka fatailia 'i gera wela God gi. ");
INSERT INTO lgl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gera futa fa'alu 'alia wela God gi! Futana fa'alu fo 'e fuli mae ala God. Iko 'ali 'e fuli sulia lioe wale ala molagali li, 'o ma ka futa ala ioli 'i laola molagali 'e li. ");
INSERT INTO lgl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Saena ka la lo mae 'alia wale, ma ka io lo fae gia. Meulu lesia lo 'ilitoana 'e too ai, sulia 'i lia lo wela moutae God Mama. 'Oka na failia kwalaimokina God gi sui gera sifo mae fagaulu ala 'i lia. ");
INSERT INTO lgl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John wale fasiuabu 'e faarono sulia, talasi ba 'e akwa ka sae 'uri 'e, “'I lia lo wale ba lau alaa sulia ala talasi ba lau sae 'uri 'e li, ‘Te wale kae la mae 'i burigu, 'i lia 'e 'ilitoa ka tasa liufi lau, sulia 'e io 'ua lo mae 'ala 'i lao, 'i lau laka bi futa.’” ");
INSERT INTO lgl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ma 'i osiala kwai'ofena ba'ela lia, Christ 'e kwatea 'are 'oka gi faga sulia atoa gi sui. ");
INSERT INTO lgl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","God 'e kwatea taki lia gi faga ala Moses. Ma ka kwatea kwai'ofena lia failia kwalaimokina sulia 'i lia 'alia Jesus Christ. ");
INSERT INTO lgl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Iko ta ioli 'ali lesia 'ua God. Talifilia Wela God mola, 'i lia 'e rada failia God Mama, ma ka io failia, 'i lia lo 'e fatailia God faga. ");
INSERT INTO lgl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wale etaeta ioli Jiu 'i Jerusalem gi li, gera keria fata abu gi, failia wale kwairanai ala fata abu gi li, 'ali gera ka soilidia John 'uri 'e, “'Uri'e ma 'i'o ite 'e?” ");
INSERT INTO lgl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma John ka olisi madakwa 'uri 'e ada, “'I lau iko lou Christ, wale ba God 'e filia fala fasakwadolaa nala ioli gi li.” ");
INSERT INTO lgl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma gera ka soilidi lou 'uri 'e ala, “'Urilali ma ite mola 'i'o? 'I'o Elaeja?” Ma ka olisida lou 'uri 'e, “Iko.” Ma gera ka soilidia lou 'uri 'e, “'Uri la ma 'i'o te profet ba 'ami kae masia?” Ma John ka olisi lou 'uri 'e ada, “Iko.” ");
INSERT INTO lgl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma fafu'isinai, gera ka soilidi lou 'uri 'e ala, “'Urilali ma ite mola 'i'o? 'O ilia mae ta 'are fameulu, 'ali meulu ka faronoa wale gera keri 'ameulu mae gi. Ta taa 'o too ai fali ilia suli 'o 'i talamu?” ");
INSERT INTO lgl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ma John ka olisidaulu 'alia alaana ba profet Aesea 'e gerea 'uri 'e, “'I lau wale kae rii 'i laola abae lifi kwasi li 'uri 'e, ‘Aofia kae dao lo mae! 'Amu farada tala fala.’” ");
INSERT INTO lgl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma wale gera la mae faasia Farasi gi li, gera ka soilidi lou 'uri 'e ala, ");
INSERT INTO lgl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“'Uta 'e ko fasiuabua ioli gi, ala 'i'o iko lou Christ, 'o ma Elaeja, 'o ma profet ba?” ");
INSERT INTO lgl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma John ka olisi 'uri 'e adaulu, “Lau fasiu abu mola 'alia kwai. Ma te wale 'amu raria, 'e ura mola 'ala 'i safitamiu. ");
INSERT INTO lgl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","'I lia wale 'e la mae 'i burigu, wasua ma iko 'ali lau totolia laka 'adaoro, ma laka tatalia 'ae botu lia gi.” ");
INSERT INTO lgl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","'Are fo gi 'e fuli 'i Betani, falua 'i aba ala tataenala da'afi li ala kwai 'i Jodan, lifi John kae fasiuabua ioli gi ai. ");
INSERT INTO lgl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ala fe atoa 'i buri, John 'e lesia Jesus kae la mae 'i so'ela, ma ka ilia fala ioli gi, “'Amu lesia, lia 'e lo wale 'e malaa kale sipsip God kae lufaa abulo ta'ana ioli la molagali li 'alia. ");
INSERT INTO lgl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","'I lia lo wale ba lau alaa sulia talasi ba lau sae 'uri 'e, ‘Te wale kae la mae 'i burigu. 'I lia 'e 'ilitoa ka tasa liufi lau, sulia 'e io 'ua lo mae 'i lao ma laka bi futa.’ ");
INSERT INTO lgl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","'I lao mae, iko 'ali lau saiai 'i lia lo wale 'e, wasua 'ala, lau fasiu abu 'alia kwai 'ali ioli 'i Israel gi gera ka lio raea.” ");
INSERT INTO lgl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma John ka sae lou 'uri 'e, “Lau lesia Aloe 'are Abu 'e sifo mae faasia 'i nali malaa na fe bola, ma ka 'o'o fafia. ");
INSERT INTO lgl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","'I lau wasua lou iko 'ali lau lio raea 'i lao. Wasua ma God 'e 'e keri lau mae 'ali lau fasiu abu 'alia kwai li, 'e sae 'uri 'e fagu, ‘Koe lesia Aloe 'are Abu kae sifo mae, ma kae 'o'o fafia te wale. 'I lia lo wale kae fasiu abu 'alia Aloe 'are Abu li.’” ");
INSERT INTO lgl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma John ka sae lou 'uri 'e, “Lau lesia lo, ma la kae ilia famiu, 'i lia lo Wela God.” ");
INSERT INTO lgl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ma ala fe atoa 'i buri, John 'e ura lou 'i lififo failia na rua wale ala wale li galona lia gi. ");
INSERT INTO lgl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ala talasi 'e lesia Jesus kae liu 'ala, John ka sae 'uri 'e, “'I lia lo Kale Sipsip God.” ");
INSERT INTO lgl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ma rua wale li galona lia gi, daro ronoa me 'are fo, ma daro ka la lo 'adaroa sulia Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ma Jesus ka bulusi, ka lesia daro kae la sulia, ma ka soilidi 'uri 'e adaroa, “Ta mora kae lio 'afia?” Ma daro ka olisi 'uri 'e ala, “Rabae, 'o io 'i fe?” fadanala rabae “Wale Faalalau.” ");
INSERT INTO lgl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma ka olisi daroa 'uri 'e, “Mora la mae, 'ali mora lesia.” Ma daro ka la failia, daro ka lesia lifi 'e io ai. Ma daro ka io lo 'adaroa failia sulia fe atoa fo. 'E dao lo garania fai tofui matola raurafi talasi daro lesia ma daro ka la failia. ");
INSERT INTO lgl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na wale ala rua wale fo gi Andrew, walefae Simon Peter. ");
INSERT INTO lgl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Me 'are etaeta Andrew 'e taua lo, 'e la ma ka faitale 'afia Simon walefae lia, ma ka faarono 'uri 'e ala, “Mera dao lo tonala Mesaea.” Fadanala saena fo “Christ,” wale ba God 'e filia fala rananala ioli gi li. ");
INSERT INTO lgl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'Urifo ka talaia Simon 'i so'ela Jesus. Ma Jesus ka bubu nanata fala, ma ka sae 'uri 'e, “Simon, wela John, lau fafurata 'o lo 'alia Sifas.” Me ratae 'are fo, ala saena Grik gi li, gera ilia lou 'alia Peter, fadanai, “Fau.” ");
INSERT INTO lgl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sui ala ruala fe atoa, Jesus ka foua malatala ka laa fala provins 'i Galili, ma ka dao tonala Filip, ka sae 'uri 'e fala, “'O la mae suli lau.” ");
INSERT INTO lgl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip wale faasia 'i Betsaeda, mae falua Andrew failia Peter. ");
INSERT INTO lgl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip 'e dao tonala Nataniel, ka faarono 'uri 'e ala, “Meulu dao lo tonala wale ba Moses 'e geregere sulia 'i laola taki li, failia profet gi gera ka geregere sulia. 'I lia Jesus wela Josef faasia 'i Nasareti.” ");
INSERT INTO lgl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma Nataniel ka sae 'uri 'e, “'O malataia 'uri ta me 'are 'oka 'e sai mola 'ala ala laana mae faasia 'i Nasareti wani?” Ma Filip ka olisia ka sae 'uri 'e fala, “La mae ko talae lesia 'amua.” ");
INSERT INTO lgl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Talasi Jesus 'e lesia Nataniel kae la mae 'i so'ela, ka sae 'uri 'e sulia, “Te wale 'e Jiu kwalaimoki, sulia iko 'ali 'e too ala ta kotona!” ");
INSERT INTO lgl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel ka olisi 'uri 'e ala, “'O sai 'utaa agu?” Ma Jesus ka olisia ka sae 'uri 'e, “Lau leesi 'o 'i 'aela 'ai figi 'i lao ala Filip ka bi soi 'o.” ");
INSERT INTO lgl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma talasi Nataniel 'e ronoa me 'are fo li, ka sae 'uri 'e, “Waleli Falalauna, 'i'o lo Wela God! 'I'o lo wale li talona 'ami ioli Jiu gi li!” ");
INSERT INTO lgl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus ka sae 'uri 'e fala, “'O fakwalaimoki mola 'i fofola lau ilia lau leesi 'o 'i 'aela 'ai figi? Lakae ilia famu, koe lesia 'are ba'ela la gi 'e liufia lou me 'are 'e.” ");
INSERT INTO lgl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sui Jesus ka sae lou 'uri 'e fadaulu, “'Are kwalaimoki la kae ilia famoulu, moulu kae lesia 'i nali kae tafa, ma 'amu kae lesia lou eniselo God gi gerakae rae ala ala fala 'i nali, ma gerakae sifo mae fafi lau, Wela Wale li.” ");
INSERT INTO lgl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","'I burila rua fe atoa gi 'e sui, te araaraina ka fuli ala te mae falua la ratala 'i Kena 'i laola gulae tolo 'i Galili. Ma teite Jesus ka io lou 'i lififo ala talasi fo. ");
INSERT INTO lgl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma gera sugaa lou mae Jesus failia wale li galona lia gi fala araaraina fo. ");
INSERT INTO lgl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma talasi ioli gi gera gou, ma waeni ka sui, teite Jesus ka sae 'uri 'e fala, “Iko 'ali gera too lo ala ta waen.” ");
INSERT INTO lgl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma Jesus ka olisi 'uri 'e ala, “Teite, 'o ala suga nagu 'ua fala taunala ta 'are, sulia talasi lau iko 'ali dao 'ua.” ");
INSERT INTO lgl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma teite Jesus ka sae 'uri 'e fala wale li galona gi, “'Amu tau sulia ta 'are kae ilia famiu.” ");
INSERT INTO lgl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ma olo kukufi 'are ba'ela fala sake kwai na gi li lia gera galofida 'alia fau, gera io 'i lififo, fala sau limanaa 'ala ioli gi sulia falafala Jiu gi li. Teke kukufi ka sakea fiu akwala wala lima 'o ma teke talanae lita ala kwai. ");
INSERT INTO lgl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ma Jesus ka sae 'uri 'e fala wale li galona gi, “'Amu fafonua fe kukufi 'are 'e gi 'alia kwai.” Ma gera ka fafonuda sui. ");
INSERT INTO lgl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sui ka sae 'uri 'e fada, “'Amu taofia ta kwai ali, ma 'amu ka kwatea fala ioli ba'ela ala fanana 'e li.” Ma gera ka kwatea fala ioli fo, ");
INSERT INTO lgl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ma ka gou tonala kwai fo, ma 'e olisi lo 'alia waeni. Ma iko 'ali saiala waen fo 'e la mae faasia 'i fe. Wasua ma wale li galona gera fafonua kwai fo gi li mola gera saiai. 'Urifo wale ba'ela fo ka rii mae fala arai fa'alu fo, ");
INSERT INTO lgl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma ka sae 'uri 'e fala, “Ioli sui gera etae kwatea waen 'oka fala goufinai 'i lao, ma 'i burila ioli gi gera gou ka rasua lo, gera ka bi kwatea waen dalakwai. Ma 'o alu golia 'amua waen 'oka rasua 'e la la ka dao lo ala talasi 'e!” ");
INSERT INTO lgl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Me 'are 'e lo etala 'are mama'ala Jesus 'e taua 'i Galili, 'i laola mae falua 'i Kena. 'I lififo 'e fatailia 'ilitoana lia, ma wale li galona lia gi gera ka fakwalaimoki ala. ");
INSERT INTO lgl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","'I burila, Jesus failia teite lia, ma walefae lia gi, failia wale li galona lia gi, daulu ka la lo fala falua 'i Kapaneam. Ma daulu ka io 'i lififo sulia barae fe atoa. ");
INSERT INTO lgl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Garania lo Fanana ala Daofae Liu na li fala ioli Jiu gi li, ma Jesus ka la fala falua ba'ela 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ma 'i lififo 'i laola Luma Abu God, ka lesia ioli gi gera foli 'alia buluka gi, failia sipsip gi, failia bola gi fala foasi na. Ma ka lesia lou ioli gera olisi 'alia seleni gi li, gera io 'ada 'i rabela tatafe gera gi. ");
INSERT INTO lgl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ma ka sakea me kwalo gi ka galofia 'alia 'are fala rabuna li, ma ka tabalia lo buluka fo gi, failia sipsip gi, ma 'are fo gi sui faasia 'i laola Luma Abu God. Ma ka gefusia lo tatafe ioli gera olisi 'alia seleni gi li, ma ka tagalailia seleni gera gi. ");
INSERT INTO lgl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma ka taba sulia ioli gera foli 'alia bola gi li ma ka sae 'uri 'e fada, “'Amu sakea 'are 'e gi 'i maluma! Ikoso 'ali 'amu taua Luma Mama lau li 'alia lifi li usi na!” ");
INSERT INTO lgl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma wale li galona lia gi daulu ka malata tonala Geregerena Abu ba 'e sae 'uri 'e, “God, kwaimaana lau fala Luma 'o li, 'e malaa duna 'e 'ago 'i laola manogu.” ");
INSERT INTO lgl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sui wale ba'ela Jiu gi li gera ka soilidia Jesus 'uri 'e, “Ite 'e kwatea kwalaimokina famu fala taunala 'are 'e gi? Ala God 'e kwatea kwalaimokina famu, fatailia ta 'are mama'ala 'ali meulu ka fakwalaimoki 'o!” ");
INSERT INTO lgl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma Jesus ka olisi 'uri 'e adaulu, “Ala 'amu ka osia wasua Luma Abu 'e, lakae fa uraa lou 'i laola olu fe atoa gi.” ");
INSERT INTO lgl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma gera ka soilidia lou 'uri 'e, “Luma Abu 'e God gera raunailia sulia fai akwala wala olo fe falisi gi. 'Uri koe fa uraa mola 'i laola olu fe atoa gi wani?” ");
INSERT INTO lgl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wasua ma Luma Abu fo Jesus 'e sae sulia fo 'ala rabela. ");
INSERT INTO lgl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ma talasi God 'e taea faasia maenali, wale li galona lia gi daulu ka malata tonala me 'are fo 'e ilia, ma daulu ka fakwalaimoki ala Geregerena Abu failia 'are Jesus 'e ilida gi. ");
INSERT INTO lgl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma ala talasi Jesus 'e io 'i Jerusalem ala Fanana ala Daofae Liu na li, ioli afula gi gera fakwalaimoki ala sulia gera lesia 'are mama'ala 'e tauda gi. ");
INSERT INTO lgl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sui ka 'urifo wasua 'ala, Jesus iko 'ali fitonada mola, sulia 'e sai sui mola ada. ");
INSERT INTO lgl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wasua iko ta ioli 'ali faaronoa 'alia ta 'are sulia ioli fo gi, 'e sai mola 'ala ala 'are 'i laola malatada gi sui. ");
INSERT INTO lgl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Ala na talasi, te wale 'ilitoa Jiu gi li, 'e la mae 'i so'ela Jesus. Wale fo ratala Nikodimas, 'i lia na wale ala Farasi gi. 'E la mae 'i so'ela Jesus 'i laola boni, ma ka sae 'uri 'e fala, “Waleli Falalauna, 'ami saiai God 'e kwate 'o mae fali falalau 'ami, sulia 'are mama'ala 'o fulida gi, 'e 'ato 'ali ta ioli ka tauda ala God iko 'ali io failia.” ");
INSERT INTO lgl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus ka olisi 'uri 'e ala, “'Are kwalaimoki lakae ilia famu, 'ato 'ali ta ioli 'ali lesia maurina God 'e 'ilitoa fafia, ala iko 'ali 'e futa fa'alu lou.” ");
INSERT INTO lgl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma Nikodimas ka soilidi 'uri 'e ala Jesus, “Ioli 'e ba'ela lo, kae futa lou 'utaa? 'E 'ato rasua fala ioli 'ali 'e oli lou 'i laola lofola teite lia, ma ka futa lou mae!” ");
INSERT INTO lgl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus ka sae 'uri 'e fala, “'Are kwalaimoki lakae ilia famu. 'E 'ato rasua fala ta ioli 'ali ka ruu 'i laola maurina 'e God 'e 'ilitoa fafia, ala 'e iko 'ali futa 'alia kwai failia Aloe 'are Abu. ");
INSERT INTO lgl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Talasi ioli 'e futa ala mama lia failia teite lia li, 'i lia 'e rau lo 'alia ioli. Ma ioli 'e futa ala Aloe 'are Abu God li, 'i lia 'e futa fa'alu mae faasia 'i nali. ");
INSERT INTO lgl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ikoso kwele, suli lau ilia famu 'amu ka futa fa'alu lou. ");
INSERT INTO lgl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Aloe 'are Abu 'e malaa oru. Sulia wasua ko ronoa oru, 'ato 'ali 'o lesia mola 'e la mae faasia 'i fe, 'o ma kae la fala 'i fe. Ma Aloe 'are Abu lou, 'ato 'ali 'o lesia kae olisi 'utaa ala ioli 'ali ka alua ioli fa'alu.” ");
INSERT INTO lgl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas ka soilidia lou 'uri 'e, “'Uri'e ma 'are 'e gi kae kwalaimoki 'utaa?” ");
INSERT INTO lgl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus ka olisi 'uri 'e ala “'I'o wale falalau 'ilitoa Jiu gi li. Ma 'utaa 'e iko 'ali 'o sai mola ala malutala 'are 'e gi? ");
INSERT INTO lgl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","'Are kwalaimoki la kae ilia famu, 'ami faarono 'alia 'are 'ami saiali gi, ma 'ami ka sae sulia 'are 'ami lesida gi. Ma iko ta ioli amiu 'ali fakwalaimoki mola. ");
INSERT INTO lgl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ala iko 'ali 'amu fakwalaimokia 'are lau ilida famiu sulia 'arela molagali 'e li, 'amu ka bi fakwalaimoki mola 'utaa agu ala laka faarono 'amiu 'alia 'are 'i nali gi? ");
INSERT INTO lgl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Iko ta ioli 'ali rae fala 'i nali, talifilia 'i lau, Wela Wale li, mola lau sifo mae faasia 'i nali.” ");
INSERT INTO lgl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Malaa talasi ba 'i lao, Moses 'e fa uraa fe wa ba 'e raunailia 'alia brasi li 'i gwaula te 'ai ba li 'i laola abae lifi kwasi. Gera kae fa uraa 'urifo lou ala Wela Wale li 'i nali gwaula fe 'ai, ");
INSERT INTO lgl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","'ali ioli gera fitoo agu gi, gera kae mauri firi. ");
INSERT INTO lgl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God 'e fatailia kwaimaana ba'ela lia fala ioli gi sui 'i laola molagali, ka kwatea mae teke Wela moutae lia, 'ali ioli gera fitoo ala gi, ikoso 'ali gera mae, gera kae too ala maurina firi. ");
INSERT INTO lgl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God iko 'ali kwatea mae Wela lia fala 'i laola molagali 'ali kwaia ioli la molagali, 'e kwatea mae 'ala 'ali ka famaurida. ");
INSERT INTO lgl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ma ite 'e fakwalaimoki ala Wela lia, God ikoso kwaia. Ma ioli iko 'ali fakwalaimoki ala Wela lia li, God 'e kwaia sui lo, sulia iko 'ali fakwalaimoki ala teke wela moutae lia. ");
INSERT INTO lgl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Kwaikwaina 'e 'uri 'e, wale 'e malaa madakwana li, 'e dao lo mae 'i laola molagali. Wasua ma ioli gi, gera babalafe 'ada failia maerodo ka liufia 'ala madakwana, sulia taunada 'e ta'a. ");
INSERT INTO lgl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sulia ioli abulonala 'e ta'a, 'e 'e'ela 'alia madakwana, ma iko 'ali oga laa na mae fala madakwana li, sulia 'e iko 'ali oga abulo ta'ana lia gi 'ali ka fatae. ");
INSERT INTO lgl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ma ioli tau 'arenala 'e rada, kae la mae fala madakwana, 'ali madakwana ka fatailia 'e taua 'are sulia kwaiogalina God gi. ");
INSERT INTO lgl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","'I buri, Jesus ka la failia wale li galona lia gi fala 'i Judea, ma ka io fae daulu 'i lififo. Ma daulu ka fasiuabu ioli 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma ala talasi fo lou, John kae fasiuabua ioli gi ala mae falua 'i Aenon garania 'i Salim. John 'e fasiuabu 'i lififo sulia lifi kwai 'e lama ai. Ioli afula gi lou gera la 'i so'ela John fala sisiuabuna. ");
INSERT INTO lgl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ala talasi fo, iko 'ali gera alua 'ua John 'i laola raraa.) ");
INSERT INTO lgl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma ala talasi fo, nali wale ala waleli galona John gi, gera alafaitalili failia te wale ala Jiu gi li sulia falafala Jiu gi sulia saunala rabeda, 'ali geraka kwaga 'i maala God. ");
INSERT INTO lgl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ma waleli galona John gi gera la 'i so'ela John, ma gera ka soilidi 'uri 'e ala, “Waleli Falalauna, 'o saiala wale ba 'e ura fae 'o 'i gulae kwai lobaa ala kwai 'i Jodan li, 'i lia 'o ilia 'are 'oka gi sulia? Ala talasi 'e, kae fasiuabua lo ioli gi, ma ioli afula gi, gera la sui lo 'i so'ela!” ");
INSERT INTO lgl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma John ka olisi 'uri 'e adaulu, “Ioli 'e too mola ala ta God 'e kwatea fala. ");
INSERT INTO lgl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Moulu ronoa sui lo ba lau ilia famoulu, 'i lau iko lou Christ, wale God 'e filia. 'I lau wale lau la mae 'i lao ala 'ali lau faatalo 'alia ma laka fatalo sulia. ");
INSERT INTO lgl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Christ 'e malaa wale kae too geli. Ma 'i lau lau malaa wale kwaima arai fa'alu li. Ma wale kwaima arai fa'alu li, 'e babalafe rasua talasi arai fa'alu 'e dao fala ara araina lia li. Ma ka 'urifo lou agu. Lau babalafe rasua ala talasi 'e, sulia Jesus 'e dao lo. ");
INSERT INTO lgl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","'Ilitoana Christ gera kae faa ba'elaa. Ma 'i lau, gera kae fawawade lau. ");
INSERT INTO lgl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Christ 'e la mae faasia 'i nali, ma ka 'ilitoa ka tasa liufia ioli gi sui. John Fasiuabu wale faasia molagali li mola. Ma ka saiala alaana mola sulia 'are 'e fuli 'i laola molagali gi li. Ma 'e kwalaimoki rasua, Christ 'e la mae faasia 'i nali, ka 'ilitoa ka tasa liufia ioli gi sui. ");
INSERT INTO lgl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","'E alaa madakwa sulia ta 'e lesia, ma ka ronoa faasia 'i nali. Sui ka 'urifo wasua 'ala, iko ta ioli 'ali oga mola fakwalaimokina ala ta gi 'e ilida. ");
INSERT INTO lgl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma ioli 'e fakwalaimoki ala ta gi 'e ilida, ioli la 'e fatailia God 'e kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma Christ 'e God 'e kwatea mae faasia 'i nali, 'e fatalo'alia saenala God, sulia God 'e kwatea sui lo Aloe 'are Abu lia 'ali ka ranaa. ");
INSERT INTO lgl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ma God Mama ka kwaima rasua ala Wela lia, ma ka alua 'i lia ka 'ilitoa fala 'are gi sui. ");
INSERT INTO lgl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma ta ioli mola 'ala 'e fakwalaimoki ala Wela 'e, 'i lia kae mauri firi. Ma ioli iko 'ali fakwalaimoki ala Wela 'e li, 'i lia kae mae, sulia 'e io 'i malula kwaikwaina God.” ");
INSERT INTO lgl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Jesus failia wale li galona lia gi, daulu la faasia 'i Judea, ma daulu ka la fala 'i Galili. Daulu la, sulia Jesus 'e saiai Farasi gi gera ronoa ioli afula rasua gera donaa, ma ioli afula rasua ka fasiuabuda ka liufia John wale Fasiuabu. Ma wale li galona lia gi lou 'ala fo gera fasiuabua ioli, iko lou Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma talasi daulu laa fala 'i Galili, daulu ka tofolo ala provins 'i Samaria. ");
INSERT INTO lgl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma daulu ka dao ala te mae falua la ratala 'i Saeka 'i laola provins 'i Samaria. Maefalua fo 'e io garania wado la ba 'ua lo mae 'i lao Jakob 'e kwatea fala wela lia Josef. ");
INSERT INTO lgl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma mae kete ba Jakob lou 'e io 'i lififo. Ma Jesus rabela 'e kweo 'alia liuna, ma ka gwauru 'ala 'i rabela kete fo. Ma talasi fo, 'e dao lo ala matoula atoa. ");
INSERT INTO lgl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ma wale li galona lia gi, daulu ka la fala falua fo 'ali daulu foli fana. Ma te geli faasia 'i Samaria ka la mae 'uri 'ali ufi kwai. Ma Jesus ka sae 'uri 'e fala, “'O kwatea mae ta me kwai 'ali lau gou ga.” ");
INSERT INTO lgl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma geli fo ka olisi 'uri 'e ala, “'I'o wale 'i Jiu, ma 'i lau geli 'i Samaria. 'Uta 'e ko suga lau 'afi ta kwai fala gouna?” 'E sae 'urifo, sulia Jiu gi iko 'ali gera kwaima failia ioli Samaria gi. ");
INSERT INTO lgl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma Jesus ka olisi 'uri 'e ala, “Ala ko saiala kwakwatena God li, ma ko saiala ite 'e 'e suga 'o 'afi ta me kwai, mala 'i'o lo ko suga lau mae, 'ali ma laka kwatea kwai ala maurina li famu.” ");
INSERT INTO lgl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma geli fo ka sae 'uri 'e fala, “Iko 'ali 'o too ala ta 'are li tao kwai, ma kete 'e lou 'e la liu rasua. 'I fe bui koe bi sakea kwai ala maurina laa li ai? ");
INSERT INTO lgl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Koko gia Jakob 'e kwatea mae kete 'e faga. Ma 'i lia, failia wela lia gi, failia 'are ranolia lia gi, gera gou ala kete 'e. Ma 'i'o 'o 'ilitoa ka liufia Jakob?” ");
INSERT INTO lgl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma Jesus ka sae 'uri 'e, “Ioli gera goufia kwai 'e li, gera kae siligou lou. ");
INSERT INTO lgl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ma ioli gera kae gou ala kwai lakae kwatea li, ikoso 'ali gera siligou lou 'i buri. Ma kwai 'e lakae kwatea fada kae alua lo mae fulafulaa laa ka kwatea maurina firi fada.” ");
INSERT INTO lgl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma geli fo ka sae 'uri 'e, “'O kwatea mae kwai laa fagu, 'ali ikoso lau siligou lo, ma 'ali ikoso lau la lou mae 'i lifi'e fala sake kwaina.” ");
INSERT INTO lgl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma Jesus ka sae 'uri 'e fala, “'O laa, ko soia mae arai 'o, ma mora ka oli mae 'i lifi'e.” ");
INSERT INTO lgl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma geli fo ka olisi 'uri 'e ala, “Iko 'ali lau too ala ta arai.” Jesus ka sae 'uri 'e, “'O sae kwalaimoki ala talasi 'o ilia iko 'ali 'o too ala ta arai. ");
INSERT INTO lgl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sulia 'o tootoo ala lima arai gi, ma wale laa 'o io failia ala talasi 'e li, 'i lia iko lou arai kwalaimoki 'o. Me 'are la 'o ilia 'e kwalaimoki.” ");
INSERT INTO lgl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma geli fo ka olisi 'uri 'e ala, “Arai ba'ela, lau saiai 'i'o te profeti. ");
INSERT INTO lgl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","'A koko 'ami gi 'i Samaria, gera foasia God 'i gwaula fe uo 'e. Ma 'i 'amiu ioli 'i Jiu gi, 'amu ilia lifi fala foasinala God mola 'i Jerusalem. 'Uri 'e ma 'i fe ala rua lifi 'e gi lo 'e kwalaimoki?” ");
INSERT INTO lgl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma Jesus ka sae 'uri 'e fala, “Geli 'e 'o fakwalaimoki lau, talasi kae dao mae talasi ioli gi ikoso gera foasia lo Mama 'i gwaula fe uo 'e 'o ma 'i Jerusalem wasua. ");
INSERT INTO lgl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'I 'amiu ioli 'i Samaria gi, 'amu raria ite 'e 'amu foasia. Ma, 'i 'amami ioli 'i Jiu gi, 'ami saiala ite 'ami foasia, ma 'ami saiala fatalona 'alia tala God fala faamaurinala ioli gi li. ");
INSERT INTO lgl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Wasua ma ta talasi kae dao mae, ma 'e fuli'ae lo, talasi Aloe 'are kae fatailia Kwalaimokina God, lia kwatea ka talawarau 'ali ioli gi geraka foasia God ala lifi gi sui. Ioli 'urifo gi lo Mama 'e oga foasina gera gi. God, 'i lia Aloe 'are, ma Aloe 'are kae talaia ioli gi kae foasia 'alia Kwalaimoki na. Ioli 'urifo gi gera saiai geraka foasia Mama.” ");
INSERT INTO lgl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma geli fo ka sae 'uri 'e fala, “Lau saiala wale God 'e filia lia gera soia 'alia Christ, kae dao mae. Ma talasi kae dao mae, 'i lia kae faarono gia 'alia 'are gi sui.” ");
INSERT INTO lgl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus ka olisia 'uri 'e, “'I lau 'e lo.” ");
INSERT INTO lgl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ma talasi fo, wale li galona lia gi gera ka dao lo mae, ma daulu ka kwele rasua, sulia daulu lesia Jesus 'e alaa 'ala failia geli fo. Wasua ma iko ta wale adaulu 'ali soilidia mola geli fo, “Ta ta 'e 'o oga?” Ma iko 'ali daulu soilidia mola lou Jesus, “'Uta 'e ko alaa failia geli 'e?” ");
INSERT INTO lgl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma geli fo ka taasi lo 'alia 'are li sake kwainali, ma ka oli 'i falua, ma ka sae 'uri 'e fala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“'Amu la mae, 'ali 'amu lesia te wale 'e faarono lau 'alia 'are lau tautauda gi sui. Mala 'i lia lo wale ba God 'e filia?” ");
INSERT INTO lgl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ma geraka tafisia mae falua fo, ma gera ka la mae 'i so'ela Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Talasi fo, wale li galona lia gi geraka soilidia Jesus 'uri 'e, “Wale falalau, 'ania ga ta me fana!” ");
INSERT INTO lgl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma Jesus ka olisi 'uri 'e adaulu, “Lau too ala fana li 'ania 'agua lia 'amu raria.” ");
INSERT INTO lgl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma wale li galona lia gi, daulu ka soilidi kwailiu 'uri 'e 'i safitadaulu, “Mala ta ioli ka sake fana mae fala tae ne?” ");
INSERT INTO lgl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma Jesus ka sae 'uri 'e fadaulu, “Fana lau, ronona sulia saenala God 'e 'e keri lau mae, ma fasuinala galona lia 'e kwatea fagu fala taunali gi. ");
INSERT INTO lgl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","'Amu too ala te agiagi saena ba 'e sae 'uri 'e, ‘Fai madama gi lou, sui talasi li fisu 'are.’ Ma la kae ilia famiu, 'amu lesia ga ioli 'e gera la mae gi. Gera malaa te raku 'e maua lo, ma ka totolia lo fala fisunai. ");
INSERT INTO lgl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","God kae kwaiara ioli 'e gera fisu'are 'i laola raku li. Ma 'i lia kae logosia lo alu 'arena fala maurina firi, 'ali wale 'e fasi 'are, failia wale 'e kae fisu 'are, daro ka babalafe sui. ");
INSERT INTO lgl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Agiagi saena ba 'e sae 'uri 'e 'e kwalaimoki, ‘Na wale kae fasi 'are, ma na wale ka fisu.’ ");
INSERT INTO lgl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Lakae keri 'amiu fala fisunala 'are 'i laola raku la iko 'ali 'amu galogalo mae ai. Nali ioli 'ada gera galogalo ai ma 'amu ka sake gwaugwau ala 'okanala galonada.” ");
INSERT INTO lgl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ma ioli afula 'i laola falua fo ala gulae tolo fo 'i Samaria li, gera ka fakwalaimoki ala Jesus, sulia geli fo 'e ilia, “'E faarono lau 'alia 'are lau tautauda gi sui.” ");
INSERT INTO lgl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ma talasi gera la mae 'i so'ela Jesus, gera ka ani ulu 'uri 'ali ka io lou 'ala failida. Ma Jesus ka io 'i lififo sulia rua fe atoa gi. ");
INSERT INTO lgl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma ioli afula gi lou gera fakwalaimoki, sulia faronona Jesus gi. ");
INSERT INTO lgl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma gera ka sae 'uri 'e fala geli fo, “'Ami fakwalaimoki lo, iko lou 'i fofola 'are ba 'o ilida famami gi, wasua ma sulia 'ami talae ronoa 'amami saenala. Ma 'ami ka saiai 'i lia lo wale li faamauri kwalaimoki ioli gi sui.” ");
INSERT INTO lgl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","'I buri 'ala Jesus failia wale li galona lia gi daulu io ala mae falua fo sulia rua fe atoa gi ka sui, daulu ka bi la fala 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesus talala ka sae 'uri 'e, “Profet gi ioli iko 'ali soi ba'ela mola ada 'i laola falua gera gi 'i talada.” ");
INSERT INTO lgl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma talasi Jesus 'e oli mae fala 'i Galili, ioli lifi fo gi li gera ka kwaloa, sulia gera la lou 'i Jerusalem ala Fanana ala Daofae Liu na li, ma gera ka lesia 'are Jesus 'e fulida gi. ");
INSERT INTO lgl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sui, Jesus ka oli lou fala 'i Kena te falua 'i Galili, lifi ba 'e olisia kwai ka alua lo waen li. Ma talasi 'e io 'ala 'i lififo li, te ulufa'alu te wale 'ilitoa faasia 'i Kapaneam, 'e matai ba'ela rasua. ");
INSERT INTO lgl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ma talasi wale fo 'e ronoa Jesus 'e la lo faasia 'i Judea ma ka oli lou mae fala 'i Galili, ka la mae 'i so'ela Jesus, 'ali ka aniulu fala 'ali laa failia fala 'i Kapaneam, 'ali ka guraa ulufa'alu fo lia, sulia 'e matai ka garani mae lo. ");
INSERT INTO lgl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Buri 'ala wale fo 'e sae 'urifo ka sui, Jesus ka sae 'uri 'e fala, “'Amu oga lesinala 'are mama'ala gi failia 'are li 'aferona 'alida gi, sui 'amu ka bi fakwalaimoki agu.” ");
INSERT INTO lgl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wasua Jesus ka sae 'ala 'urifo, wale fo ka sae 'uri 'e fala Jesus, “Aofia, 'o la ga mae fae lau, taufasia wela lau 'e bi mae.” ");
INSERT INTO lgl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sui Jesus ka sae 'uri 'e fala, “'O oli 'amua, ulufa'alu 'o 'e 'akwaa lo.” Ma te wale fo ka la lo, sulia 'e fakwalaimoki ala saenala Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ma talasi kae liu ko 'ala sulia tala li, wale li galona lia gi, gera ka lalao mae fala farononala 'uri 'e, “Arai, te wela ba 'o 'e 'akwaa lo ma ka mauri lo!” ");
INSERT INTO lgl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma wale 'ilitoa fo ka soilidi 'uri 'e adaulu, “Tofuimatola ta lo ulufa'alu lau 'e 'akwaa ai?” Ma daulu ka olisi 'uri 'e ala, “'Ago'agona 'e sui faasia 'i nalafi ala etala tofui matola 'i atoa.” ");
INSERT INTO lgl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma mama wela fo li ka saiai tofui matola ba Jesus 'e ilia saena ba gi ai lo fo. 'I burila me 'are fo, wale 'ilitoa fo failia ioli 'i laola luma lia gi li sui, gera ka fakwalaimoki lo ala Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Me 'are fo ruala 'are mama'ala Jesus ka fulia ala talasi 'e oli mae faasia 'i Judea fala 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","'I burila 'are fo gi, Jesus ka laa fala 'i Jerusalem, ala te fanana Jiu gi li. ");
INSERT INTO lgl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","'I Jerusalem, te lamo ala kwai li 'e io garania lifi gera soia 'alia mae 'olofolo ala sipsip li. Ala saena Jiu gi li, gera soia lamo fo 'alia 'i Betsaeda. Lima taofa tekwa gi gera io 'i rabela lamo fo. ");
INSERT INTO lgl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ioli afula rasua gi gera teo 'i laola taofa fo gi. Ioli gera matai 'alia kwalukae mataina mamata gi sui: ioli maada ka koro gi, ioli rabeda mae gi, ma ioli limada failia 'aeda ka mae gi lou. ");
INSERT INTO lgl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma te wale 'e teo 'i lififo, 'e matai lo mae sulia olu akwala wala kwalu fe nali gi. ");
INSERT INTO lgl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Talasi Jesus 'e lesia 'e teo mola 'ala 'i lifi fo li, ma ka saiai 'e matai ka tekwa rasua lo, ka soilidi 'uri 'e ala wale fo, “'O oga ko 'akwaa?” ");
INSERT INTO lgl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma wale matai fo ka olisia Jesus 'uri 'e, “Arai, iko 'ali lau too ala ta ioli fala sake nagu ko fala 'i laola lamo, ala talasi kwai kae bulusi. Ala talasi gi sui, talasi laka tau fala laa na 'i laola kwai fo li, ta ioli 'e etae laa lo 'ala 'i lao faasi lau.” ");
INSERT INTO lgl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma Jesus ka sae 'uri 'e, “Tatae, sakea tafe 'o, ko liu lo.” ");
INSERT INTO lgl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ala me talasi fo mola lo, wale fo ka 'oka lo, ma ka tatae, ka sakea lo tafe lia, ma ka liu lo. Ma fe atoa fo Sabati atoa ala mamalona li. ");
INSERT INTO lgl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Lia fo wale etaeta Jiu gi li, gera ka sae 'uri 'e fala wale fo 'e 'akwaa lo li, “'I tara'ela atoa ala Sabati li, ma ka abu rasua ala taki gia gi 'ali 'o sakea tafe 'o.” ");
INSERT INTO lgl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wale fo ka sae 'uri 'e fada, “Wale 'e guraa lau lo 'e ilia laka sakea tafe lau, ma laka liu.” ");
INSERT INTO lgl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma gera ka soilidia lou 'uri 'e, “Wale ta 'e ilia ko taua me 'are la?” ");
INSERT INTO lgl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ma wale fo 'e raria lou 'ala Jesus, sulia ioli afula rasua gi gera io ala lifi fo. Ma Jesus ka liu lo 'ala 'i safitada. ");
INSERT INTO lgl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","'I burila lo, Jesus ka bi dao tonala 'i laola Luma Abu God, ma ka sae 'uri 'e fala, “'O fafurono ga, 'o 'oka lo. Ma ko bulusi faasia abulo ta'ana 'o gi, tau ma ta me 'are 'e ta'a ka rasua lou ka bi tau 'o 'i buri. Sulia mali fo bui kae bi ta'a ka tasa liufia me 'are ba 'e etae tau 'o 'i lao.” ");
INSERT INTO lgl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ala talasi wale fo 'e latafa lo 'i maluma faasia Luma Abu God li, ka laa 'i so'ela wale etaeta Jiu gi li, ma ka sae 'uri 'e fada, “Jesus ba 'e guraa lau, ma laka 'akwaa.” ");
INSERT INTO lgl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ma talasi fo, gera ka fuli'ae lo ala malimaena ala Jesus, sulia 'e guraa wale fo ala Sabati atoa ala mamalona li. ");
INSERT INTO lgl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma Jesus ka sae 'uri 'e fada, “Mama lau 'e galo sulia atoa gi sui, 'i lau wasua laka galo lou 'urifo.” ");
INSERT INTO lgl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","'I fofola me alaana fo gi, wale etaeta Jiu gi li malatada ka nanata rasua fala rauninala Jesus 'ali mae. Gera oga rauninala, sulia iko 'ali 'e malata ba'ela ala falafala sulia Sabat gi li, failia 'e ilia God Mama lia. Ma sulia 'e 'urifo, 'e fafuradania lia lo failia God. ");
INSERT INTO lgl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma Jesus ka olisi 'uri 'e ada, “'Are kwalaimoki la kae ilia famiu. 'I lau, Wela God, 'e 'ato 'ali lau taua ta 'are 'i talagu. Lau saiai laka taua mola 'are lau lesia Mama lau 'e tauda gi. Ma taa Mama lau ka tauda, lia lou la kae tauda. ");
INSERT INTO lgl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sulia Mama lau 'e kwaima aagu, ma ka fatailia 'are kae tauda gi sui fagu. Ma kae fatailia lou fagu galona la gi 'e ba'ela ka liufia lou guranala wale fo, ma 'amu kae 'afero rasua 'alia 'are lakae tauda gi. ");
INSERT INTO lgl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mama lau 'e saiai ka taea ioli gera mae lo gi ma ka faamaurida. Ma 'i lau Wela lia, lakae tau lou 'urifo. Lakae kwatea lou maurina fala ioli lau filida gi. ");
INSERT INTO lgl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mama lau ikoso loko kwaikwaina fala ta ioli, sulia 'e kwatea lo nanatana fala lokokwaikwaina li fala Wela lia. ");
INSERT INTO lgl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","'E kwatea 'are 'e fagu 'ali ioli gi sui gera ka soi ba'ela aagu, malaa lou lia 'e gera soi ba'ela ala Mama lau li. Ma ite 'e iko 'ali soi ba'ela aagu, 'i lia 'e iko 'ali soi ba'ela lou ala Mama lau, lia 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“'Are kwalaimoki la kae ilia famiu. Ala ta ioli 'e ronoa saenagu, ma ka fakwalaimoki ala God lia 'e keri lau mae, 'i lia kae too ala maurina firi. Ikoso lau loko kwaikwaina lo fala. Ma 'e laa lo faasia maena, ma ka ruu lo 'i laola maurina kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","'Are kwalaimoki la kae ilia famiu, talasii kae dao mae, ma 'e dao lo mae, ioli gera mae lo gi gera kae rono lau, Wela God. Ma ioli gera ronosuli lau gi, gera kae mauri. ");
INSERT INTO lgl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","'E malaa Mama kalokalola maurina kwalaimoki, ma ka kwatea fagu, Wela lia, 'ali lau malaa lou kalokalola maurina kwalaimoki fala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma ka kwatea lo kwalaimokina fagu, 'ali laka loko kwaikwaina fala ioli gi, sulia 'i lau Wela Wale li. ");
INSERT INTO lgl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ikoso 'ali 'amu 'afero 'alia me 'are 'e, sulia talasi kae dao mae talasi ioli gera mae lo gi, gera kae rono lau, ");
INSERT INTO lgl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma gera kae latafa faasia gigilu gera gi, 'ali ioli gera taua 'are 'oka gi li, gera ka tatae mae, ma gera ka too ala maurina firi. Ma ioli gera taua 'are ta'a gi li, gera kae tatae mae, ma gera kae io 'i laola kwaikwaina firi. ");
INSERT INTO lgl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ikoso 'ali lau taua ta 'are sulia malatagu 'i talagu. Lau saiai laka lokokwaikwaina fala ioli sulia taa lau ronoa God 'e ilia fagu. Lokokwaikwainagu 'e rada, sulia God 'e saenasi mae fagu ma laka tau sulia taa gi 'e ogada, ma iko 'ali lau tau sulia kwaiogalina lau 'i talagu gi. ");
INSERT INTO lgl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ala lakae faarono suli 'i lau 'i talagu, ikoso ta ioli 'ali fakwalaimoki mola ala faronona lau gi. ");
INSERT INTO lgl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ma te wale 'e io mola 'ala, lia 'e faarono 'alia taa 'e saiai suli lau. Ma laka saiai 'are 'e faarono 'alia suli lau gi gera kwalaimoki sui. ");
INSERT INTO lgl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","'I 'amiu ba 'amu keria ko wale 'amiu gi 'i so'ela John, ma 'i lia ka faarono 'amiu 'alia 'are kwalaimoki suli lau gi. ");
INSERT INTO lgl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iko 'ali lau uluna mola ala ta 'are ta ioli kae sae falalama lau 'alia, wasua lau sae sulia sae fakwalaimokinala John suli lau, 'ali ka rana 'amiu fala maurina fa'alu. ");
INSERT INTO lgl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John 'e malaa na fe ulu 'e tala 'oka. Ma 'amu ka babalafe fafia 'are 'e ilida gi sulia ke me talasi wawade. ");
INSERT INTO lgl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Wasua ma lau too lou ala 'are fali falalamaa lau lia 'e 'ilitoa ka liufia John: faalalau na lau gi failia 'are mama'ala 'e laka fulida gi. Ma 'are fo gi lo galona lau fali tauda gi sulia Mama 'e kwateda fagu laka tauda. Galona 'e lau gi gera falalamaa lia Mama lau 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Mama 'i talala lou 'e falalamaa lau. Iko 'ali 'amu ronoa linela, 'o ma 'ali 'amu ka lesia maala, ");
INSERT INTO lgl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ma iko 'ali 'amu kwaloa mola saenala 'i laola manomiu, sulia iko 'ali 'amu fakwalaimoki agu lia 'i lia 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","'Amu 'idufae idumia Geregerena Abu gi, sulia 'amu fia 'uria 'amu kae too ala maurina firi sulia. Ma Geregerena Abu fo gi 'e fatailia 'are kwalaimoki gi sui suli lau. ");
INSERT INTO lgl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","'E 'urifo wasua 'ala, iko 'ali 'amu oga mola laa na mae 'i soegu 'ali lau faamauri 'amiu. ");
INSERT INTO lgl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ma 'i lau 'e, iko 'ali lau lio 'afia ta ioli 'ali ka soi ba'ela agu. ");
INSERT INTO lgl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Wasua ma lau sai amiu lia iko 'ali 'amu too mola ala ta kwaimaana fala God. ");
INSERT INTO lgl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Lau la mae 'alia nanatana Mama lau li, wasua ma iko 'ali 'amu kwalo lau mola. Ma ala ta ioli ka la mae 'alia nanatana lia 'i talala, 'amu ka kwalo 'alia babalafe na. ");
INSERT INTO lgl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","'E 'urifo sulia 'amu oga ioli gi gera ka soi lafe 'amiu. Wasua ma iko 'ali 'amu oga mola taunala 'are 'oka gi 'ali God ka soi lafe 'amiu. Ma ala 'e 'urila, 'e 'ato rasua lo 'ali 'amu ka fakwalaimoki lau. ");
INSERT INTO lgl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Iko lou 'i lau lakae suua 'amiu 'i maala Mama lau. Moses 'ala kae suua 'amiu suli 'i lia 'e gerea taki 'e 'amu fitoo ai gi. ");
INSERT INTO lgl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ala 'amu fakwalaimokia Moses, totolia 'amu ka fakwalaimoki lau lou, sulia 'i lia 'e geregere mae suli lau. ");
INSERT INTO lgl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Sulia iko 'ali 'amu fakwalaimoki ala taa Moses 'e gerea suli lau, 'e 'ato rasua famiu 'ali 'amu fakwalaimoki ala taa gi laka ilida famiu.” ");
INSERT INTO lgl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","'I burila, Jesus ka tofolo ala 'osi 'i Galili gera soia lou 'alia 'osi 'i Taebirias. ");
INSERT INTO lgl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma te logona ba'ela ka la 'i burila, sulia gera lesia 'are mama'ala gi 'e tauda 'alia guranala ioli matai gi. ");
INSERT INTO lgl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ma Jesus ka rae 'i gwaula fe uo, ma ka gwauru 'i fua failia wale li galona lia gi. ");
INSERT INTO lgl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ala talasi fo, Fanana ala Daofae Liu na Jiu gi li 'e garani lo. ");
INSERT INTO lgl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus ka lio galia ma ka lesia logona ba'ela rasua gera dao mae 'i so'ela, ma ka sae 'uri 'e fala Filip, “'I fe golu kae folia ta fana kae totolia 'ali golu ranolia 'alia ioli 'e gi sui?” ");
INSERT INTO lgl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","'E sae 'urifo 'ali ka mailitonala Filip, 'urifo wasua 'ala 'e sai lo ala me 'are kae taua. ");
INSERT INTO lgl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma Filip ka olisia 'uri 'e, “Ta rua talanae seleni wasua ikoso totolia mola folinala ta fana 'ali gera ka ke fana wawade wasua 'ada ai.” ");
INSERT INTO lgl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma na wale ala wale li galona lia gi, Andrew walefae Simon Peter, ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Te wela 'i lifi'e, 'e too mola ala keme lima tofui berete gi failia rua lode ia gi. Wasua ma 'e 'ato ka totolia ioli afula 'e gi.” ");
INSERT INTO lgl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ma Jesus ka sae 'uri 'e fadaulu “Moulu ilia fala ioli gi, gera ka gwauru 'i fua.” 'I lifi fo fasifasi 'e afula rasua ai. Ma ioli gi sui gera ka gwauru 'i fua, ma 'e totolia lima to'oli wale gi. ");
INSERT INTO lgl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ma Jesus ka sakea tofui berete fo gi, ma ka batafea God, ma ka tolinia fala ioli gera gwauru 'i lififo gi li. Ma ka tau 'urifo lou ala lode ia fo gi. Ma 'i gera sui, gera fana la la gera ka bote sui. ");
INSERT INTO lgl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ma talasi gera bote lo, ka sae 'uri 'e fala wale li galona lia gi, “Moulu golia lo orenala fana 'ali ikoso 'ali golu fafuta'a ta me 'are.” ");
INSERT INTO lgl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma daulu ka golida sui, ma daulu ka fafonua teke akwala wala rua pera gi 'alia orenala fana ala lima tofui berete ba gera 'anida gi. ");
INSERT INTO lgl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ma talasi ioli gi gera lesia 'are mama'ala fo Jesus 'e taua, gera ka sae 'uri 'e, “Te profet ba kae dao mae 'i laola molagali kwalaimoki lo 'e!” ");
INSERT INTO lgl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ma Jesus ka la lo 'ala faasi gera fala me lifi 'e rae talifilia, sulia 'e saiai gera garani la lo mae fala suunailinala 'ali ka ura 'ali walelitalona fada. ");
INSERT INTO lgl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma 'i raurafi ala talasi da'afi kae garani suu lo, wale li galona lia gi daulu ka sifo lo 'adaulu taufofola 'osi fo. ");
INSERT INTO lgl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ma boni kae rodo lo mae. Jesus iko 'ali dao 'ua 'i soedaulu. Ma daulu ka taefia laola te baru, ma daulu ka tofolo ala 'osi fo fala te mae falua gera soia 'alia 'i Kapaneam. ");
INSERT INTO lgl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ma ala talasi fo oru ka dao mae, failia lafolafo ka taasi rasua. ");
INSERT INTO lgl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma talasi daulu fouta ka dao ala ta olu 'o ma ta fai miles 'i asi, daulu lio ko, ma daulu ka lesia Jesus 'e liu mae 'i fofola 'osi, ma ka la garania lo mae baru. Ma wale li galona lia gi daulu ka mau rasua. ");
INSERT INTO lgl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma Jesus ka sae ko 'uri 'e fadaulu, “Moulu ala mau na! 'I lau mola tae!” ");
INSERT INTO lgl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","'I burila ka tae fae daulu 'i laola baru, ma daulu ka babalafe rasua. Ma toraa wasua, daulu dao lo ala mae falua ba daulu kae la fai. ");
INSERT INTO lgl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Ma talasi 'e rafule lo mae, ioli afula gera io 'ua ala abae 'osi lobaa li, gera lio 'afia Jesus ala lifi ba Jesus batafea God fafia fana ba gi li ai, ma ka kwatea fala ioli afula ba gi li. Ma gera ka saiai Jesus falia wale li galona lia gi daulu dao sui mae 'alia teke baru mola ba. Ma gera ka sai lou ala lia Jesus iko 'ali la mola failia wale li galona lia gi 'i laola baru fo li, daulu la lo 'adaulu talifili daulu. Sui nali baru gera ka dao mae faasia 'i Taebirias, gera la mae, gera ka olo 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma talasi logona fo iko 'ali lesia lo Jesus failia wale li galona lia gi li, gera ka taefia baru gi, gera ka la, gera ka lio 'afia Jesus 'i Kapaneam. ");
INSERT INTO lgl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ma talasi gera li dao tonala ala gula 'osi fo li, gera ka soilidi 'uri 'e ala, “Wale li faalalauna, talasi taa mola 'e 'o la lou mae 'i lifi'e ai?” ");
INSERT INTO lgl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma Jesus ka olisi 'uri 'e ada, “'Are kwalaimoki la kae ilia famiu, 'amu lio 'afi lau, sulia 'amu 'ania tofui berete ba gi ma 'amu ka bote, ma iko lou dunala 'amu malinailia malutala 'are mama'ala ba lau tauda gi. ");
INSERT INTO lgl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ikoso 'ali 'amu galo ulafu lou fala fana 'e kae fulu mola 'ala. 'Amu ka galo fala fana kae kwatea maurina firi famiu. 'I lau, Wela Wale li lakae kwatea fana ala maurina firi li famiu sulia God Mama 'e fatailia 'i lia lo 'e keri lau mae.” ");
INSERT INTO lgl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","'Are la fo ioli gi gera ka soilidi 'uri 'e ala, “Ta taa God 'e oga 'ami ka taua?” ");
INSERT INTO lgl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma Jesus ka olisi 'uri 'e ada, “Kwaiogalina God 'e 'uri 'e: 'Amu ka fakwalaimoki ala wale 'e kwatea mae.” ");
INSERT INTO lgl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma gera ka soilidi lou 'uri 'e ala, “Ta 'are mama'ala 'utaa koe fulia, 'ali 'ami ka lesia ma 'ami ka fakwalaimoki amu? Ta taa koe taua? ");
INSERT INTO lgl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Koko gia gi gera 'ania berete ba gera soia 'alia “mana” 'i laola abae lifi kwasi, malaa ba gera gerea lo 'uri 'e, ‘Moses 'e kwatea berete faasia 'i nali fada fala 'aninai.’” ");
INSERT INTO lgl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ma Jesus ka sae 'uri 'e fada, “'Are kwalaimoki la kae ilia famiu, iko 'ali Moses ba 'e kwatea berete faasia 'i nali famiu. Ma Mama lau 'ala ba 'e kwatea berete kwalaimoki faasia 'i nali famiu. ");
INSERT INTO lgl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Berete kwalaimoki God 'e kwatea, lia wale 'e 'e sifo mae faasia 'i nali, ma ka kwatea maurina fala ioli gi sui 'i laola molagali.” ");
INSERT INTO lgl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma gera ka sae 'uri 'e fala, “Arai, fuli 'i tara'ela ka la 'alaa, ko kwatea berete la famami.” ");
INSERT INTO lgl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sui Jesus ka sae 'uri 'e, “'I lau lo berete ala maurina li. Ma ta ioli mola 'ala 'e la mae 'i soegu, 'i lia 'ato 'ali fiolo lou. Ma ta ioli mola 'ala 'e fakwalaimoki lau, 'i lia 'ato 'ali siligou lou. ");
INSERT INTO lgl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Lau ilia famiu ka sui lo, wasua 'amu leesi lau, iko 'ali 'amu fakwalaimoki agu. ");
INSERT INTO lgl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ioli sui lia Mama lau 'e kwateda fagu, gera kae la sui mae 'i soegu. Ma ta ioli mola 'ala 'e oga laa na mae 'i soegu, ikoso 'ali lau barasi 'alia. ");
INSERT INTO lgl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","'E 'urifo, suli lau sifo mae faasia 'i nali, iko lou fala taunala 'are sulia kwaiogalina lau 'i talagu gi. Lau la mae fala taunala 'are God 'e 'e keri lau mae li, 'e ogada gi. ");
INSERT INTO lgl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","'Are la fo God 'e oga laka dau fafia ioli 'e kwateda fagu gi sui, ma ta teke ai wasua ikoso iko, 'ali ala atoa fafu'isi laka bi taeda fala maurina firi. ");
INSERT INTO lgl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","God Mama lau 'e oga ioli gera lio raea ma gera ka fakwalaimoki agu gi, gera ka mauri firi. Ma lakae taeda fala maurina ala atoa fafu'isi.” ");
INSERT INTO lgl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ma ioli gi gera ka fuli'ae geraka nurunuru 'i burila sulia 'e sae 'uri 'e, “'I lau lo 'e berete 'e sifo mae faasia 'i nali.” ");
INSERT INTO lgl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma gera ka alaa kwailiu 'uri 'e 'i matanada “Wale 'e Jesus wela Josef mola tae, ma gia sai mola 'aga ala mama lia, failia teite lia. Ma 'utaa 'e ka ilia 'uri 'e sifo mae faasia 'i nali?” ");
INSERT INTO lgl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma Jesus ka olisi 'uri 'e ada, “'Amu mano faasia nurunuruna 'i safitamiu. ");
INSERT INTO lgl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mama lau, 'i lia 'e keri lau mae. Ma talifilia ioli Mama lau 'e talaida mae 'i soegu gi mola gerakae la mae 'i soegu. Ma lakae taeda fala maurina ala fe atoa fafu'isi. ");
INSERT INTO lgl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profet gi gera geregere 'uri 'e, ‘God kae falalaua ioli gi sui.’ Ta ioli mola 'ala 'e ronoa lo Mama, ma ka sakea lo sai 'arena faasia, gera ka la mae 'i soegu. ");
INSERT INTO lgl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma iko ta ioli 'ali lesia Mama. Talifilia mola wale 'e fuli mae faasia God mola 'e lesia Mama. ");
INSERT INTO lgl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","'Are kwalaimoki la kae ilia famiu, ioli 'e fitoo agu, 'i lia kae mauri firi. ");
INSERT INTO lgl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma 'i lau lo berete ala maurina li. ");
INSERT INTO lgl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Koko 'amiu gi gera 'ania berete ba gera soia 'alia “mana” 'i laola abae lifi kwasi, ma gera ka mae mola 'ada. ");
INSERT INTO lgl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wasua ma berete 'e sifo mae faasia 'i nali, ioli ka 'ania, 'ato 'ali mae. ");
INSERT INTO lgl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ma 'i lau lo berete ala maurina lau laa mae faasia 'i nali. Ala ta ioli ka 'ania berete 'e, 'i lia kae mauri firi. Ma berete la lo 'e filisigu, lia la kae kwatea 'ali ioli 'i laola molagali li gera ka mauri 'i osiala.” ");
INSERT INTO lgl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma ioli gi gera ka fuli'ae alafaitalili 'i safitada kwailiu, ma gera ka sae 'uri 'e, “Wale 'e kae kwate 'utaa ala filisila faga fala 'aninai?” ");
INSERT INTO lgl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma Jesus ka sae 'uri 'e fada, “'Are kwalaimoki la kae ilia famiu, ala ikoso 'amu 'ania filisigu, ma ikoso 'amu goufia 'abugu, 'e 'ato rasua 'amu ka mauri firi. ");
INSERT INTO lgl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma ite 'e 'ania filisigu, ma ka goufia 'abugu, 'i lia kae too ala maurina firi, ma lakae taea ala fe atoa fafu'isi. ");
INSERT INTO lgl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sulia filisigu lo berete kwalaimoki, failia 'abugu lo 'are li goufia kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ma ioli 'e 'ania filisigu, ma ka goufia 'abugu, 'i lia ka io agu, ma 'i lau laka io ala. ");
INSERT INTO lgl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","God 'e 'e kwatea maurina li, 'i lia 'e kwate lau mae. Ma 'i lia lau mauri lou 'i osiala. Ka 'urifo lou fala ioli 'e 'ania filisigu, 'i lia ka mauri lou 'ali lau. ");
INSERT INTO lgl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma lia lo berete 'e sifo mae faasia 'i nali. Ma 'e iko 'ali malaa lou berete ba koko gia gi gera 'ania, ma gera ka mae lo. Ma ta ioli mola 'ala 'e 'ania berete 'e, 'i lia kae mauri firi.” ");
INSERT INTO lgl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus ka ilia 'are fo gi talasi kae faalalau 'i laola luma fala foana li 'i Kapaneam. ");
INSERT INTO lgl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ma wale li galona afula lia gi gera ronoa 'are fo Jesus 'e ilida gi, ma gera ka sae 'uri 'e, “Falalauna 'e 'e 'ato rasua. Ite lo kae fakwalaimokia?” ");
INSERT INTO lgl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ma Jesus ka saiala wale li galona lia gi gera nurunuru 'i burila sulia me 'are fo, ma ka sae 'uri 'e fadaulu, “'Uri'e ma alaana fo 'e fafuta'a 'amiu? ");
INSERT INTO lgl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'E 'utaa ala 'amu leesi lau, Wela Wale li, laka oli fala lifi ba lau io io mae ai 'i lao? ");
INSERT INTO lgl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","'Are kae kwatea maurina li lo Aloe 'are Abu. Ma nanatanala ioli, me 'are gwaugwau mola 'ala. Ma alaana 'e lau ilida famiu gi lia 'e kwate 'amu ka too ala Aloe 'are Abu lia kwatea maurina. ");
INSERT INTO lgl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sui ka 'urifo wasua 'ala, nali ioli amiu iko 'ali gera fakwalaimoki mola.” Sulia fuli 'ua lo mae 'i lao, Jesus ka sai sui lo ala ite adaulu iko 'ali fakwalaimoki, ma ite kae kwate lia fala malimae lia gi. ");
INSERT INTO lgl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma ka sae lou 'uri 'e, sulia nali ioli adaulu iko 'ali gera fakwalaimoki, “Lia ba lau ilia lo famiu 'ato 'ali ta ioli 'ali la mae 'i soegu, ala Mama lau iko 'ali kaea mae 'i soegu.” ");
INSERT INTO lgl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma ka fuli ala talasi fo, wale li galona afula lia gi, gera ka bulusi lo 'ada faasia, ma iko 'ali gera donaa lo. ");
INSERT INTO lgl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma Jesus ka soilidia akwala wala rua waleli galona lia gi 'uri 'e, “'Uri'e ma moulu oga moulu ka la lou faasi lau?” ");
INSERT INTO lgl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma Simon Peter ka olisi 'uri 'e ala, “Aofia, meulu ka laa lou 'i soela ite? 'I'o lo 'o too ala alaana ala maurina firi li. ");
INSERT INTO lgl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma meulu fakwalaimoki, ma meulu ka saiai 'i'o lo Wale Abu 'o la mae faasia God.” ");
INSERT INTO lgl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma Jesus ka sae 'uri 'e, “'I lau lau fili 'amoulu lo akwala wala rua wale gi. Ma wasua ka 'urifo, teke wale amoulu 'e malaa aloe 'are ta'a.” ");
INSERT INTO lgl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ala talasi Jesus 'e sae 'urifo li, 'e sai mola 'ala ala Judas 'i lifi fo, wela Simon Iskariot. Wasua Judas na wale ala akwala wala rua wale li galona lia gi, 'i lia kae kwatea Jesus fala malimae lia gi. ");
INSERT INTO lgl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","'I burila lo 'are fo gi, Jesus ka liu galia mola 'ala mae falua 'i Galili gi, sulia iko 'ali oga 'ua laa na fala 'i Judea, sulia wale etaeta ala Jiu gi li gera oga rauninala 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma na fanana Jiu gi 'e garani lo. Fanana fo gera soia 'alia “Babala gi.” ");
INSERT INTO lgl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Walefae Jesus gi, daulu la mae 'i so'ela, ma daulu ka sae 'uri 'e fala, “'O la fala 'i Judea, 'ali 'o fatailia lou tali 'are mama'ala, 'ali wale li galona 'o gi gera ka lesia. ");
INSERT INTO lgl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sulia ala ta wale 'e oga ioli gi gera ka ronoa ratala ma gera ka saiala, ikoso 'ali tau agwaagwa ala ta me 'are. Ala 'o taua 'are ba'ela afula gi, 'e 'oka 'ali 'o la ko tau tafanae ali, 'ali molagali sui gera ka saiai.” ");
INSERT INTO lgl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Walefae lia gi gera sae 'urifo fala, sulia 'i daulu wasua iko 'ali daulu fakwalaimoki mola ala. ");
INSERT INTO lgl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma Jesus ka sae 'uri 'e fadaulu, “'E iko 'ali dao 'ua ala talasi 'ali lau laa. Ma 'i 'amiu 'amu saiai 'amu ka laa mola 'amiu ala ta tenetene talasi mola 'ala. Ma talasi gi sui 'e rada mola 'ala famiu. ");
INSERT INTO lgl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ioli 'i laola molagali 'e li iko 'ali gera too ala ta me 'are 'ali gera ka 'e'ela 'ali 'amiu 'alia. Ma 'i lau 'e, gera 'e'ela 'ali lau, sulia lau ili tafanae ala taa gi 'e gera tauda ka ta'a. ");
INSERT INTO lgl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Moulu la 'amoulu ala fana na. Ikoso 'ali lau la mola, sulia iko 'ali dao 'ua ala talasi lau.” ");
INSERT INTO lgl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","'E sae 'urifo ka sui, ka io lo 'ala 'i Galili. ");
INSERT INTO lgl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","'I buri ai burila Jesus gi gera la lo ala fanana ba'ela fo 'i Jerusalem li, Jesus ka la 'i buridaulu. Ma 'e la agwaagwa mola 'ala, taufasia ta ioli ka bi saiala. ");
INSERT INTO lgl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ma wale etaeta Jiu gi li, gera ka lio 'afia 'i laola fanana fo, ma gera ka soilidi 'uri 'e, “Wale ba 'i fe?” ");
INSERT INTO lgl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma ioli afula rasua gi, gera ka nurunuru agwaagwa sulia 'uri 'e, “Wale ba, 'i lia te wale 'oka.” Ma nali ioli gera ka ilia, “'E talaia ioli afula rasua gi fala laa na sulia kotona lia gi li.” ");
INSERT INTO lgl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Wasua gera ka sae 'urifo, iko ta ioli ada 'ali alaa tafanae mola 'alia malataeioli gera gi sulia Jesus, sulia gera mau 'alia wale etaeta ala Jiu gi li. ");
INSERT INTO lgl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fanana fo 'e la sulia fai atoa ka sui lo Jesus ka bi ruu ko 'i laola Luma Abu God, ma ka bi fuli'ae ala faalalaunala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ma wale etaeta gi, talasi gera ronoa, gera ka 'afero rasua 'alia falalaunala. Ma gera ka sae 'uri 'e, “Wale 'e iko 'ali sakea ta raerae malatana mola mae ala ta falua. Ma 'utaa 'e ka saiala 'are gi sui?” ");
INSERT INTO lgl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ala talasi Jesus 'e rono gera, ka olisi gera ka sae 'uri 'e, “Faalalauna lau iko lou 'are lau, 'are 'ala God 'e 'e kwate lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ioli 'e oga ka taua kwaiogalina God li, 'i lia kae saiai, ala 'are 'e lau faalalaua ioli 'alida gi gera la mae faasia God, 'o ma malata lau mola 'i talagu gi. ");
INSERT INTO lgl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ala wale ka faarono mola 'alia 'are sulia malata lia gi 'i talala, 'i lia 'e oga mola 'ali ioli gi gera ka tafea. Ma wale 'e oga ioli gi gera ka tafea 'ada wale fo 'e keria mae li, 'i lia wale kwalaimoki, ma iko 'ali saiala kotona.” ");
INSERT INTO lgl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Sui Jesus ka sae lou 'uri 'e, “Moses ba 'e kwatea taki gi famiu. Ma iko ta ioli amiu 'ali tau mola sulia taki fo gi. Ma 'utaa 'e 'amu ka oga 'amu ka rauni lau 'ali lau mae?” ");
INSERT INTO lgl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ma ioli fo gera logo ala lifi fo li, gera ka sae 'uri 'e, “'I'o la aloe 'are ta'a 'e io amu! Ite 'e oga rauni namu?” ");
INSERT INTO lgl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus ka olisi gera 'uri 'e, “Lau guraa te wale ala Sabat atoa ala mamalona li, ma 'amu ka kwele rasua 'alia. ");
INSERT INTO lgl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Ma 'amu saiai Moses 'e kwatea te taki famiu, fala wela wale wawade 'amiu gi fala 'ole wale na (Ma iko lou Moses 'e fuli'aea, ma koko 'ualo 'amiu gi mae 'i lao.) Ma ala talasi 'oka fala 'ole wale na ala wela 'amiu gi li 'e toli lo ala Sabati, 'amu ka taua lo 'amiu, wasua fe atoa ala mamalona li ala Sabat 'ali ikoso 'ali 'amu 'oia taki Moses sulia 'ole wale na li. Ala 'e 'oka mola 'ala famiu fala 'ole wale na ala Sabat li, ma 'utaa mola 'e 'amu ka ogata'a fagu talasi ba lau guraa wale ba ala Sabati atoa ala mamalona li? ");
INSERT INTO lgl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ikoso 'ali 'amu lokomalata sulia lioliona mola 'i maluma. Ma 'amu lokomalata sulia radana.” ");
INSERT INTO lgl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ma nali ioli 'i Jerusalem gera sae 'uri 'e, “Te wale 'e mola ba wale etaeta gi gera oga rauninala! ");
INSERT INTO lgl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Lio ga! Wale 'e 'e sae tafanae mola 'ala, ma iko 'ali gera ilia mola ta 'are olisia. Mala gera saiai tae ne, 'i lia lo Christ, wale ba God 'e filia fala faamurinala ioli gi li! ");
INSERT INTO lgl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma talasi Christ kae la mae, ikoso ta ioli 'ali saiala lifi kae la mae faasia. Ma wale 'e, gia sai mola 'aga ala lifi 'e la mae faasia.” ");
INSERT INTO lgl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ala talasi fo, Jesus ka faalalau ioli gi 'i laola Luma Abu God. Ma ka sae ba'ela 'uri 'e, “'Uri'e ma 'amu sai kwalaimoki aagu, ma 'amu ka saiala lifi lau la mae faasia? Wasua ma iko 'ali lau la mae 'alia kwalaimoki na lau 'i talagu! Ma wale 'e 'e keri lau mae, 'e ilia 'are kwalaimoki gi sui, ma iko 'ali 'amu sai mola ala. ");
INSERT INTO lgl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ma 'i lau, lau sai ala, sulia 'i lia lo 'e keri lau mae, ma laka la mae faasia.” ");
INSERT INTO lgl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ala talasi fo, wale etaeta gi gera ka oga doinala, ma ka 'ato, sulia talasi lia iko 'ali dao 'ua 'ali gera ka tau 'urifo ala. ");
INSERT INTO lgl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wasua gera ka oga taunala me 'are fo, afula nala ioli 'i laola logona fo li gera fakwalaimoki ala. Ma gera ka sae 'uri 'e, “Talifilia Christ mola 'e saiai ka fulia 'are mama'ala 'e 'i lia 'e fulida gi.” ");
INSERT INTO lgl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ma talasi Farasi gi gera ronoa ioli gi gera nurunuru 'ada sulia Jesus 'urifo li, 'i gera failia fata abu ba'ela gi, gera ka keria ko nali wale lio folo gera ka folo galia Luma Abu God, 'ali gera ka daua ala talasi fo. ");
INSERT INTO lgl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma Jesus ka sae 'uri 'e, “Lakae io mola fae 'amiu sulia keme talasi dodoko, ma lakae oli lou 'agua 'i so'ela wale 'e 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Sui 'amu kae lio 'afi lau, ma kae 'ato 'ali 'amu dao tonagu. Sulia 'e 'ato 'ali 'amu dao ala lifi lakae io ai.” ");
INSERT INTO lgl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma wale etaeta Jiu gi li gera ka lokoi malata 'ada 'i safitada kwailiu 'uri 'e, “Wale 'e kae la fala 'i fe 'e ikoso 'ali gia lesia? 'Uri'e ma kae la fala falua Grik gi li, lifi la nali ioli gia gera io ai, 'ali ka faalalauda sui? ");
INSERT INTO lgl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ma ka ilia lou gia kae lio 'afia ma ikoso 'ali gia lesia, sulia 'ato 'ali gia saiala daona ala lifi fo kae io ai. Taa 'i laola malatala talasi 'e sae 'urifo li?” ");
INSERT INTO lgl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ala fe atoa fafu'isi ala fanana fo li, fe atoa 'ilitoa ka tasa. Ma ala fe atoa fo, Jesus ka tatae ka ura, ma ka akwa ba'ela 'uri 'e, “Ta ioli mola 'ala 'e siligou, ka la mae 'i soegu 'ali ka gou 'ala. ");
INSERT INTO lgl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ma ta ioli mola 'ala ka fakwalaimoki lau, 'i lia kae malaa 'are ba Geregerena Abu 'e ilia, ‘Kwai li maurina kae afe mae faasia maurinala.’” ");
INSERT INTO lgl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ma Jesus ka ilia 'are fo, sulia Aloe 'are Abu kae la mae fala ioli gera fakwalaimoki ala gi. Ala talasi fo, God iko 'ali kwatea 'ua mae Aloe 'are Abu fala ioli gera fakwalaimoki gi, sulia Jesus iko 'ali rae 'ua 'ali oli fala 'i laola 'ilitoana lia. ");
INSERT INTO lgl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nali ioli ala logona fo, gera ronoa saenala Jesus, gera ka sae 'uri 'e, “Wale 'e 'i lia lo profet 'ilitoa ba gia maasia!” ");
INSERT INTO lgl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma nali ioli gera ka ilia, “'I lia Christ, wale ba God 'e filia fala faamurinala ioli gi li!” Ma nali ioli lou, gera ka ilia, “Wale filia ikoso 'ali la mae faasia 'i Galili! ");
INSERT INTO lgl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sulia Geregerena Abu 'e ilia Christ kae futa mae ala kwalofa David walelitalona, ma kae futa 'i Betlehem, mae falua David 'e ba'ela mae ai.” ");
INSERT INTO lgl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ma ioli fo gi, iko 'ali gera alua mola ta teke malata sulia Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ma na gula ala ioli gera oga rasua gera ka daua Jesus, wasua ma iko ta ioli 'ali taua mola ta 'are ala. ");
INSERT INTO lgl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Te wale lio folo ba gi iko 'ali gera daua mola Jesus, ma gera ka oli lo 'i so'ela fata abu ba'ela gi failia Farasi gi. Ma talasi gera dao lo, fata abu ba'ela gi failia Farasi gi gera ka sae 'uri 'e, “'Uta 'e iko 'ali moulu sakea mae?” ");
INSERT INTO lgl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma gera ka olisi 'uri 'e ada, “Meulu 'afero rasua 'alia sulia iko ta wale 'ali alaa 'urifo malaa 'i lia.” ");
INSERT INTO lgl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ma Farasi gi gera ka sae 'uri 'e fadaulu, “Mala moulu fakwalaimoki lou 'amoulu ala kotona lia gi li tae ne? ");
INSERT INTO lgl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Iko ta wale ala wale etaeta gia gi 'o ma ta Farasi, 'ali gera fakwalaimoki mola ala! ");
INSERT INTO lgl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Te logona fo mola gera fakwalaimoki ala. Ma iko 'ali gera sai mola ala taki Moses gi. 'E 'urifo ma God kae kwaida.” ");
INSERT INTO lgl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Te wale ala Farasi gi ratala Nikodimas 'i lia ba 'e la la mae 'i so'ela Jesus 'i lao, 'e sae 'uri 'e fala Farasi gi, ");
INSERT INTO lgl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Taki gia gi ba 'e ilia ikoso 'ali gia loko kwaikwaina fala ta wale ala iko 'ali gia rono 'oka ala saenala ka sui bui gia ka bi sakea mae fala loko kwaikwaina fala.” ");
INSERT INTO lgl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ma gera ka sae 'uri 'e fala Nikodimas, “'Urilali ma 'i'o lou na wale faasia 'i Galili 'e? Ala ko idumia 'oka ala Geregerena Abu, ko lesia talamu. Profet 'ilitoa 'e gia maasia ikoso ke la mola mae faasia 'i Galili!” ");
INSERT INTO lgl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ioli gi sui gera oli lo fala luma gera gi, ");
INSERT INTO lgl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ma Jesus ka rae fala gwaula fe uo la gera soia 'alia Olif. ");
INSERT INTO lgl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma 'i 'ofaedani ala fe atoa 'i buri, ka oli lou fala 'i laola Luma Abu God. Ma logona ba'ela rasua, gera ka logo galia, ma ka gwauru 'i fua, ka faalalauda. ");
INSERT INTO lgl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma wale falalau ala taki gi li, failia Farasi gi, gera ka sakea mae te geli la gera daua fafia tau wale na. Ma gera ka faa uraa 'i safitada. ");
INSERT INTO lgl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma gera ka sae 'uri 'e fala Jesus, “Wale li faalalauna, te geli 'e meulu daua fafia tau wale na. ");
INSERT INTO lgl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ma 'i laola taki Moses 'e kwatea faga gi, 'e ilia 'uri geli 'uri 'e, giaka 'uia 'alia fau 'ali ka mae. Ma ta koe ilia sulia?” ");
INSERT INTO lgl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Gera ilia 'are fo 'ali gera ka mailitonala 'ali gera ka daria ta me 'are 'ali gera suuafafia 'alia Jesus. Ma Jesus ka gwauru 'i wado, ka geregere 'alia 'u'ula 'i laola wado. ");
INSERT INTO lgl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma talasi gera soilidi mola 'ada, 'i lia ka tatae, ma ka sae 'uri 'e fada, “Ite amoulu iko 'ali taua ta 'are ta'a, 'i lia kae etae 'ui 'alia ta me fau.” ");
INSERT INTO lgl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sui, ka gwauru lou, ma ka geregere lou 'i laola wado. ");
INSERT INTO lgl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ma talasi gera ronoa me 'are fo li, io ma na ai 'e la la lo 'alaa, fuli'ae ala wale waro gi. Ma gera ka tafisia Jesus ka io lo talifilia failia geli fo 'e ura mola 'ala 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ma 'i lia ka tatae lou, ma ka sae 'uri 'e, “Geli 'e, wale ba gi, 'i gera lo 'i fe? 'E 'utaa? Iko ta wale ada 'ali ore lo 'ali ka loko kwaikwaina famu?” ");
INSERT INTO lgl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma geli fo ka olisia 'uri 'e, “Wale ba'ela, iko lo ta wale.” Ma Jesus ka sae 'uri 'e fala, “Ma 'i lau wasua, ikoso 'ali lau loko kwaikwaina lou famu. 'O laa lo 'amua, ma fuli'ae 'i tara'ela ikoso taua lo ta 'are ta'a.” ");
INSERT INTO lgl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus ka sae lou 'uri 'e fala Farasi gi, “'I lau 'e, lau malaa madakwana fala ioli gi 'i laola molagali 'e. Ioli 'e dona suli lau, ikoso 'ali liu 'i laola maerodo. 'I lia kae liu 'i laola madakwana, ma kae mauri firi.” ");
INSERT INTO lgl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma Farasi gi gera ka sae 'uri 'e fala, “'I'o 'amua 'i talamu lo 'o faarono suli 'o. Ma saenamu sulia 'o 'i talamu iko 'ali kwalaimoki.” ");
INSERT INTO lgl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus ka sae 'uri 'e, “Iko mola. Wasua laka faarono suli lau talagu, 'are 'e lau ilida gi gera kwalaimoki, sulia lau saiala lifi lau la mae faasia, ma 'i fe lakae la fai. Ma iko 'ali 'amu sai mola ala lifi lau la mae faasia, ma lifi lakae la fai. ");
INSERT INTO lgl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","'Amu lokomalata sulia malata ioli 'i laola molagali gi li mola. Ma 'i lau iko 'ali lau lokomalata ala ta ioli. ");
INSERT INTO lgl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wasua ala laka lokomalata fala ta ioli, la kae lokomalata sulia malatana rada. Ikoso lau lokomalata ala ta ioli talifili lau, ma 'i 'ameroa sui Mama lo lia 'e keri lau mae lia kae galo fae lau. ");
INSERT INTO lgl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Taki 'amiu gi gera ilia ka sui lo, ala rua wale gi daro sae fakwalaimokia ta me 'are, 'are la daro ilia 'e kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Lau faarono suli lau 'i talagu, failia Mama 'e 'e keri lau mae, 'i lia lou kae faarono suli lau.” ");
INSERT INTO lgl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sui, gera ka soilidia Jesus 'uri 'e, “'Uri'e ma mama 'o lia 'i fe?” Ma Jesus ka olisi gera 'uri 'e, “Iko 'ali 'amu saiagu 'o ma Mama lau wasua. Ala 'amu saiagu, 'amu ka sai lou ala Mama lau.” ");
INSERT INTO lgl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesus ka ilia 'are 'e gi ala talasi kae faalalaua ioli gi 'i laola Luma Abu God, 'i laola tofui luma la gera alua kukufi 'are gera alua fala kwakwatena gera gi 'i laola. Ma ala talasi fo, iko ta ioli 'ali daua mola, sulia iko 'ali dao 'ua ala talasi lia. ");
INSERT INTO lgl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus ka sae lou 'uri 'e fada, “Lakae la, ma 'amu kae lio 'afi lau. Ma 'amu kae mae, ma God ikoso kwailufa mola 'alia ta'ana 'amiu gi. Ma 'e 'ato 'ali 'amu la fala lifi 'e lakae la fai.” ");
INSERT INTO lgl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ma wale etaeta Jiu gi li gera ka sae 'uri 'e, “'E ilia 'e 'ato 'ali gia la fala lifi fo 'i lia kae la ai. 'Urifo mala kae rauni lia 'ala 'i talala tae ne?” ");
INSERT INTO lgl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus ka olisi 'uri 'e ada, “'Amu la mola mae faasia fofola wado. Ma 'i lau lau la mae faasia 'i nali. 'I 'amiu faasia molagali 'e. Ma 'i lau iko lou faasia molagali. ");
INSERT INTO lgl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","'Are la fo, lau ilia ka sui lo 'amu kae mae, ma God ikoso kwailufa 'alia ta'ana 'amiu gi. 'E kwalaimoki lo, ala iko 'ali 'amu fakwalaimokia lia 'e 'I lau 'E, God ikoso kwailufa 'alia ta'ana 'amiu gi.” ");
INSERT INTO lgl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sui gera ka soilidia 'uri 'e, “'Uri'e ma 'i'o ite 'e?” Ma Jesus ka olisida ka sae 'uri 'e, “'I lau 'e lau malaa lo lia ba lau etae ilia lo famiu 'i laola faalalauna lau gi li. ");
INSERT INTO lgl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Lau too ala 'are afula rasua gi saiai laka ilida suli 'amiu fala lokokwaikwainamiu 'alida. Wale 'e keri lau mae, 'i lia wale kwalaimoki. Ma ta 'e ilia fagu, lia lou laka ilia fala ioli gi sui.” ");
INSERT INTO lgl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma iko 'ali gera sai mola ala liafo Jesus 'e sae sulia Mama lia 'i nali li. ");
INSERT INTO lgl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Lia fo, ka sae 'uri 'e fada, “Talasi 'amu kae alu lau, Wela Wale li, 'i fofola 'ai rara folo, 'amu kae saiagu lia 'e 'I lau 'E. Ma ala talasi fo, 'amu kae bi saiai lia iko 'ali lau taua ta 'are sulia malatagu 'i talagu. Ma lau ilia mola 'are Mama 'e faalalau lau 'alida gi famiu. ");
INSERT INTO lgl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma Mama lo 'e keri lau mae, lia ka io fae lau sulia atoa gi. 'E iko 'ali 'e buri 'ali lau, dunala lau taua 'are 'e fababalafea sulia atoa gi li.” ");
INSERT INTO lgl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ma ioli afula gi gera ka fakwalaimoki ala Jesus, talasi gera ronoa 'e ilia 'are fo gi li. ");
INSERT INTO lgl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sui Jesus ka sae 'uri 'e fala ioli Jiu gera fakwalaimoki ala gi, “Ala 'amu ka tau sulia falalauna lau gi, 'i 'amiu ioli li galona kwalaimoki lau gi. ");
INSERT INTO lgl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma 'amu kae saiala 'are kwalaimoki gi sulia God, ma 'are kwalaimoki sulia God gi kae kwate 'amu kae io sakwadola.” ");
INSERT INTO lgl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Gera ka olisia Jesus 'uri 'e, “'I 'amami ioli ala kwalofa Abraham gi li. Iko 'ali 'ami ke galogalo ulafu 'ua fala ta ioli. 'Uta 'e ko ilia 'ami ka io sakwadola?” ");
INSERT INTO lgl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus ka sae lou 'uri 'e fada, “'Are kwalaimoki lakae ilia famiu. Ioli gera ronosulia falafala ta'a gi li, falafala ta'a fo gi lo 'e 'ilitoa fafida, ma gera ka galo ulafu lo 'ada 'i malula falafala ta'a fo gi. ");
INSERT INTO lgl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ma ioli fo 'e io sakwadola, 'i lia ioli 'e futa ala kwalofa, ma ka too ala kwalaimokina fala iona 'i laola luma mama lia li. Ma ioli kae galo ulafu mola 'ala, 'i lia iko 'ali ioli kwalaimoki ala kwalofa li. ");
INSERT INTO lgl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Lia fo, ala 'i lau, Wela God, laka fasakwadola 'amiu, lia lo 'amu bi sakwadola kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Lau saiai 'i 'amiu wale ala kwalofa Abraham gi li. Ka 'urifo wasua ma, 'amu oga rauninagu, sulia iko 'ali 'amu oga mola tauna sulia faalalauna lau gi li. ");
INSERT INTO lgl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Lau sae sulia ta Mama lau 'e fatailida fagu. Ma 'amu ka taua ta gii mama 'amiu 'e ilida famiu.” ");
INSERT INTO lgl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Gera olisia Jesus 'uri 'e, “Mama 'amami lo Abraham!” Jesus ka sae 'uri 'e fada, “Ala 'i 'amiu kwalofa Abraham gi kwalaimoki, 'amu taua lou 'are ba 'e tauda gi. ");
INSERT INTO lgl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Lau ilia mola 'are kwalaimoki lau ronoa faasia God gi famiu sulia atoa gi. Wasua ma 'amu oga mola 'amiu rauninagu. Ma Abraham iko 'ali taua mola ta 'are 'urifo. ");
INSERT INTO lgl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","'Amu taua mola 'amiu 'are mama 'amiu 'e tauda gi.” Gera ka sae 'uri 'e fala, “Talifilia God mola Mama 'amami, ma 'i 'amami wela kwalaimoki lia gi.” ");
INSERT INTO lgl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus olisida ka sae 'uri 'e, “Ala God mama 'amiu kwalaimoki, 'amu ka kwaima aagu, sulia lau la mae faasia God, ma laka io fae 'amiu 'i lifi'e. Iko 'ali lau la mae sulia kwalaimoki na lau 'i talagu. God lo 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","'Uta 'e iko 'ali 'amu rono raea malutala saenagu? 'E 'urifo sulia iko 'ali 'amu oga mola rononai. ");
INSERT INTO lgl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'I 'amiu 'e, mama 'amiu lo Saetan. Lia fo, 'amu ka oga lou taunala 'are lia 'e tauda gi. Saetan wale fala rau ioli na li sulia 'e fuli ka taua 'ua lo mae. Ma 'i lia ka raria kwalaimokina, sulia iko 'ali too ala ta kwalaimokina ala. Talasi kae kotofia ta ioli, falafala lia lo fo, dunala 'i lia wale fala kotona li lo, ma 'i lia lo mama ioli kotokoto gi li sui. ");
INSERT INTO lgl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ma 'are kwalaimoki lakae ilia famiu, 'are la 'e taua iko 'ali 'amu oga mola fakwalaimoki nagu. ");
INSERT INTO lgl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ma ite ioli amiu 'e saiai ka fatailia ta taa lau taua ka ta'a? Iko mola! Ma 'utaa 'e iko 'ali 'amu fakwalaimoki lau talasi lau ilia 'are kwalaimoki gi famiu? ");
INSERT INTO lgl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ioli gera fuli mae 'i so'ela God gi, gera saiai gera ka rono sulia saenala. Ma 'i 'amiu, iko 'ali 'amu fuli mae ala God. Ma lia 'e taua iko 'ali 'amu fafurono.” ");
INSERT INTO lgl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sui, gera ka sae 'uri 'e fala Jesus, “Me 'are ba 'ami ilia suli 'o 'e kwalaimoki lia ba 'ami ilia 'i'o wale faasia 'i Samaria, ma ko too ala aloe 'are ta'a.” ");
INSERT INTO lgl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus 'e olisida ka sae 'uri 'e, “Iko mola, iko 'ali lau too ala ta aloe 'are ta'a. Ma lau fa'ilitoa Mama lau, wasua iko 'ali 'amu fa'ilitoa lau mola. ");
INSERT INTO lgl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma iko 'ali lau oga mola ioli gi gera ka soi 'ilitoa agu. Mama lau 'ala 'e oga ioli gi gera ka soi 'ilitoa agu. Ma 'i lia lou kae loko kwaikwaina 'alia radana. ");
INSERT INTO lgl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","'Are kwalaimoki lakae ilia famiu, ite ioli 'e tau sulia faalalauna lau, ikoso 'ali mae.” ");
INSERT INTO lgl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sui gera olisia Jesus gera ka sae 'uri 'e, “Meulu bi saiamu, lia 'e 'o too ala aloe 'are ta'a li! Sulia koko gia Abraham 'e mae lo, failia profet gi lou gera ka mae lo. 'Uta 'e ko ilia ala ioli ka tau sulia faalalauna 'o gi, ikoso 'ali mae? ");
INSERT INTO lgl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Koko gia Abraham lia wale 'ilitoa, wasua ma 'e mae lo. Ma 'i'o 'e, 'o fia 'uri 'o 'ilitoa ka liufia Abraham wani? Ma profet gi lou ba gera mae lo, 'urila ma 'o ili 'o 'alia ite?” ");
INSERT INTO lgl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus ka olisi gera 'uri 'e, “Ala 'i lau mola lau soi 'ilitoa agu 'i talagu, 'urila 'ilitoana lau 'are gwaugwau mola 'ala. Ma wale 'e soi 'ilitoa agu lo mama lau, lia 'amu ilia 'i lia lo God 'amiu. ");
INSERT INTO lgl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wasua, iko 'ali 'amu sai mola ala God. Ma 'i lau, lau saiala. Wasua ma ala laka ilia iko 'ali lau saiala, lakae malaa lou 'i 'amiu lia 'amu sai rasua ala koto na li. Ma lau sai 'oka rasua ala, ma laka tau sulia saenala. ");
INSERT INTO lgl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ma koko 'amiu Abraham 'e babalafe rasua, sulia 'e lesia lo daonagu mae. 'E lesia ma ka babalafe rasua sulia.” ");
INSERT INTO lgl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma gera ka sae lou 'uri 'e fala, “Awale! Lima akwala fe nali gi iko 'ali sui 'ua fafia futa namu, ma ko ilia 'o lesia lo Abraham wani?” ");
INSERT INTO lgl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus ka olisi gera ka sae 'uri 'e, “'Are kwalaimoki lakae ilia famiu: Talasi Abraham iko 'ali futa 'ua, 'I lau 'E, lau io lo.” ");
INSERT INTO lgl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ala talasi fo, gera ka sakea lo fau gi fala 'uimailinala, dunala 'e sae 'urifo. Sui, ka agwa lo faasi gera, ma ka la lo faasia Luma Abu God. ");
INSERT INTO lgl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Talasi Jesus 'e liliu 'ala, ka lesia te wale la maala 'e koro fuli lo mae ala talasi 'e futa ai. ");
INSERT INTO lgl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma wale li galona lia gi gera soilidia 'uri 'e, “Wale li faalalauna, ta'ana ite 'e taua maala wale 'e ka koro fuli lo mae ala futanala? Abulo ta'ana lia 'ala 'i talala gi 'o ma abulo ta'anala mama lia failia teite lia?” ");
INSERT INTO lgl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma Jesus ka olisi 'uri 'e adaulu, “Maa koro 'e taua, iko lou 'i fofola abulo ta'ana lia 'i talala gi, ma iko lou abulo ta'anala mama lia 'o ma teite lia. Maala 'e koro 'ali 'amu ka lesia nanatana God kae galo ala. ");
INSERT INTO lgl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ala talasi 'e dani 'ua, lakae taua lo galona God 'e 'e keri lau mae, 'e oga laka taua. Sulia boni 'e garani lo, talasi ikoso ta ioli 'ali galo ai. ");
INSERT INTO lgl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Talasi lau io 'ua 'i laola molagali li, 'i lau lo madakwana fala ioli la molagali.” ");
INSERT INTO lgl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","'I burila Jesus 'e ilia me 'are fo, ka nisu 'i laola me wado, ma ka bulia mamako 'alia nisula, ma ka 'usua 'alia maala wale fo. ");
INSERT INTO lgl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma Jesus ka sae 'uri 'e fala, “'O la ko saua lo maamu 'i laola lamo 'i Saelom.” (Rata fo, fadanai “Keria.”) Ma wale fo ka la ka saua lo maala, ma ka lio lo. ");
INSERT INTO lgl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ma ioli ala falua lia li, failia ioli fo gera lesia lia ba kae suga suga 'are mola 'ala 'i lao, gera ka soilidida kwailiu, “'I lia wale ba 'e gwaugwauru ma ka suga suga 'are mola 'ala 'e?” ");
INSERT INTO lgl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ma nali ioli geraka sae 'uri 'e, “'I lia lo la.” Ma nali ioli lou gera ka sae 'uri 'e, “Iko lou 'i lia 'e, wasua ma lesinala malaa lou wale ba.” Ma wale fo 'ala 'i talala ka sae 'uri 'e, “'I lau lo wale ba 'e.” ");
INSERT INTO lgl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma gera ka soilidia, “'Uta maamu ka tafa lo 'urila wani?” ");
INSERT INTO lgl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma ka olisi 'uri 'e ada, “Te wale ba ratala Jesus lo 'e raunailia mamako, ma ka 'usua 'alia maagu. Ma ka ilia fagu laka la, laka saua lo maagu 'i laola lamo 'i Saelom. Sui laka la, ma talasi lau saua mola maagu ka lio lo.” ");
INSERT INTO lgl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma gera ka soilidia lou 'uri 'e ala, “Ma 'i lia lo 'i fe wani?” Ma ka olisi 'uri 'e ada, “Lau raria lou.” ");
INSERT INTO lgl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","'I burila, gera ka talaia lo wale fo 'i so'ela Farasi gi. ");
INSERT INTO lgl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ma fe atoa fo Jesus 'e raunailia mamako li, ma ka guraa lo maala wale fo ai, fe atoa Sabat atoa ala mamalona li. ");
INSERT INTO lgl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma Farasi gi geraka soilidia lou wale fo, “'E tau 'utaa ko lio lo.” Ma ka sae 'uri 'e fada, “Jesus 'e alua mamako fafia maagu. Sui laka saua maagu, ma maagu ka lio lo.” ");
INSERT INTO lgl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma nali wale ala Farasi gi gera ka sae 'uri 'e, “Wale 'e taua me 'are 'e li, iko 'ali la lou mae faasia God, sulia 'e 'oia taki ala Sabat li, 'alia guranala wale 'e ala Sabat.” Ma nali wale lou gera sae 'uri 'e, “Iko, ma 'utaa mola 'e wale abulo ta'a 'uri 'e ka fulia 'are mama'ala ba'ela 'urifo gi?” Ma iko 'ali gera alua mola ta teke me malata sulia me 'are fo. ");
INSERT INTO lgl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sui Farasi gi gera ka soilidi 'uri 'e lou ala wale fo, “'O ilia Jesus 'e guraa lo maamu, ta taa 'e koe ilia sulia?” Ma 'i lia ka sae 'uri 'e, “'I lia te profet.” ");
INSERT INTO lgl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma wale etaeta ala Jiu gi li, gera ka 'e'ela 'ali fakwalaimoki nala lia maala 'e korokoro mae 'i lao. Ma gera ka soia mae mama lia failia teite lia. ");
INSERT INTO lgl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma gera ka soilidi daroa 'uri 'e, “Wela 'amoroa lo 'e? Mora ilia 'uri maala 'e koro lo ala talasi 'e futa mae ai. Ma ta 'e taua ka lio lo ala talasi 'e?” ");
INSERT INTO lgl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma mama lia failia teite lia daro olisida 'uri 'e, “Mera saiai 'i lia wela 'ameroa, ma mera ka sai lou ai lia maala 'e koro 'ua lo mae ala talasi 'e futa ai. ");
INSERT INTO lgl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Wasua ma mera raria lou ta 'e kwate ma ka lio lo, 'o ma ite 'e tafalia maala. Moulu soilidi lia ko, sulia 'e ba'ela lo, ma ka talae alaa lo 'ala 'i talala!” ");
INSERT INTO lgl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ma mama lia failia teite lia daro sae 'urifo sulia daro mau 'alia wale etaeta ala Jiu gi li. Sulia gera alafafia ka sui lo, 'ali ala ta ioli ka ilia Jesus lia Christ, wale ba God 'e filia, ikoso gera ala'alia ka ruu 'i laola luma fala foana gi li. ");
INSERT INTO lgl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Lia fo mama lia failia teite lia daro ka ilia, “'E ba'ela lo. Moulu soilidia ko!” ");
INSERT INTO lgl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sui gera ka soia lou mae wale ba maala 'e koro 'i lao, ma gera ka sae 'uri 'e fala, “'O alafuu 'i maala God koe ilia 'are kwalaimoki gi! Meulu saiai wale 'e 'i lia wale ta'a.” ");
INSERT INTO lgl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma wale fo ka olisi 'uri 'e ada, “Lau raria 'i lia ta wale ta'a 'o ma iko. Me 'are lau saiai mola 'e 'uri 'e, maagu 'e koro 'i lao, ma talasi 'e lau lio lo.” ");
INSERT INTO lgl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma gera ka soilidi lou 'uri 'e ala, “Ta 'e taua amu wani? Ma ka guraa 'utaa ala maamu?” ");
INSERT INTO lgl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma wale fo ka olisi 'uri 'e ada, “Lau ilia ka sui lo famiu ba, wasua ma iko 'ali 'amu ronoa mola. 'Uta 'e 'amu ka oga lou rononai? Mala moulu oga moulu ka fakwalaimoki ma moulu ka la lou sulia 'e.” ");
INSERT INTO lgl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gera sae fafuta'a 'uri 'e ala, “'I'o waleli galona lia. Ma 'i 'ameulu waleli galona Moses gi 'ala. ");
INSERT INTO lgl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sulia meulu saiai God 'e alaa fala Moses. Ma wale 'e, 'ami raria 'e la mae faasia 'i fe!” ");
INSERT INTO lgl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma wale fo ka olisi 'uri 'e ada, “Lau kwele rasua lo 'ali 'amoulu. Sulia 'e tafalia maagu, wasua ma moulu ka ilia iko 'ali 'amu sai mola ala 'i fe 'e la mae faasia. ");
INSERT INTO lgl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","'I gia sui, gia saiai God ikoso ronoa wale ta'a gi. 'E ronoa 'ala ioli 'e gera soi 'ilitoa ala gi, ma gera ka taua 'are 'e oga 'ali gera ka tauda gi. ");
INSERT INTO lgl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka fuli 'ua lo mae ala fulinala molagali, iko 'ali gia roronoa 'ua ta ioli ka tafalia maala ioli maala 'e koro lo mae fuli ala talasi 'e futa mae ai. ");
INSERT INTO lgl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ma ala wale 'e iko 'ali la mae faasia God, 'e 'ato ka taua ta 'are 'urifo.” ");
INSERT INTO lgl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ma gera ka ogata'a rasua, ma gera ka sae 'uri 'e fala, “'O ba'ela mae 'i laola ta'ana fuli lo mae ala futanamu! 'Uta 'e ko oga koe faalalau 'ameulu 'amua?” Sui gera ka luia ikoso 'ali ruu 'i laola luma fala foana gi li. ");
INSERT INTO lgl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sui Jesus ka ronoa gera tau 'urifo ala ke wale fo. Ma ka dao tonala ka sae 'uri 'e, “'Uri'e ma 'o fakwalaimoki ala Wela Wale li?” ");
INSERT INTO lgl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma wale fo ka olisia 'uri 'e, “Arai, 'o faarono lau ite la, 'ali lau fakwalaimoki ala?” ");
INSERT INTO lgl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma Jesus ka sae 'uri 'e fala, “'O lesia ka sui lo, ma 'i lia lo koe alaa failia ala talasi 'e.” ");
INSERT INTO lgl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma wale fo ka ilia, “Aofia, lau fakwalaimoki lo amu.” Ma ka boururu 'i fua 'i maala 'aela Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus ka sae 'uri 'e, “Lau la mae 'ali lau tolinia ioli ala molagali li 'alia rua logonae ioli gi. Na logonae ioli malaa ioli maa koro gi sulia iko 'ali gera saiala 'are kwalaimoki sulia God gi. Ioli la gi, la kae kwatea gerakae lio raea 'are kwalaimoki sulia God gi. Na logonae ioli gera fia 'uri gera lio raea 'are kwalaimoki sulia God gi. Lakae fatailia iko 'ali gera saiala 'are kwalaimoki sulia God gi.” ");
INSERT INTO lgl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ma nali ioli ala Farasi gi lia gera io 'i lififo failia, gera ronoa 'e ilia me 'are fo, ma gera ka soilidia, “'Uri'e ma 'o ilia 'uri maameulu 'e koro lou 'e?” ");
INSERT INTO lgl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma Jesus ka olisi 'uri 'e adaulu, “Ala maamoulu ka koro 'urila God ikoso loko kwaikwaina famoulu, wasua 'amu ka abulo ta'a. Ma 'amu ilia 'amu lio raea 'are kwalaimoki gi. Lia lo kwatea God kae loko kwaikwaina famiu.” ");
INSERT INTO lgl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus ka sae fala wale li galona lia gi 'uri 'e, “'Are kwalaimoki la kae ilia famoulu, wale iko 'ali ruu sulia 'olofolo ala banisi sipsip gi li, ma ka ruu mola mae 'i burila banisi sipsip gi li, 'i lia wale belibeli. ");
INSERT INTO lgl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma wale 'e ruu ala 'olofolo li, 'i lia lo wale kwalaimoki kae lio sulia sipsip gi li. ");
INSERT INTO lgl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Wale lio folo ala 'olofolo li ka tafalia maala 'olofolo ala banisi li fala, ma sipsip gi gera ka rono raea linela, ma gera ka la mae 'i so'ela. 'I lia ka soia ratala sipsip lia gi, ma ka talaida 'i maluma. ");
INSERT INTO lgl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ma talasi kae talaia sipsip lia gi sui 'i maluma, 'i lia ka etaeta 'i laoada, ma gera ka liu 'i burila, sulia gera rono raea linela. ");
INSERT INTO lgl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma 'e 'ato gera ka la 'i burila ta wale mamata. Gera kae tafi faasia, sulia iko 'ali gera rono raea linela.” ");
INSERT INTO lgl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Talasi Jesus 'e alaa 'alia tarifulaana 'e fada, iko 'ali daulu malinailia mola. ");
INSERT INTO lgl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Lia fo, Jesus ka sae lou 'uri 'e, “'Are kwalaimoki la kae ilia famoulu, 'i lau lo lau malaa 'olofolo fala sipsip gi 'ali gera ruu ai. ");
INSERT INTO lgl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wale ba gera dao mae 'i lao agu gi, gera malaa wale belibeli gi, ma sipsip gi iko 'ali gera rono mola sulida. ");
INSERT INTO lgl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'I lau lau malaa maala 'olofolo fala ruuna li. Ite 'e ruu agu, lakae faamauria. 'I lia kae ruu mae ma kae latafa ma ka daria 'are 'oka gi. ");
INSERT INTO lgl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ioli belibeli, 'e dao mola mae fala beli nala 'are gi ma fala rauiolina ma failia fafuta'a 'are na. Ma 'i lau lau dao mae 'ali 'amu ka too ala maurina la 'e 'oka ka tasa. ");
INSERT INTO lgl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Lau malaa lou wale la 'e lio 'oka sulia sipsip gi. Ma laka marabe fala maena folosia sipsip lau gi li. ");
INSERT INTO lgl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma wale 'e galo mola fala folifolina li, sipsip gi iko lou 'are lia gi, talasi 'e lesia kui kwasi kae la mae, 'i lia kae tafisia lo sipsip gi, ma kae tafi lo 'ala. Ma kui kwasi ka la mae ka raunia sipsip gi, ma ka tagalae gera. ");
INSERT INTO lgl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wale fo ka tafi lo 'ala sulia 'e galo mola fala folifolina, ma iko 'ali gerea mola sipsip fo gi. ");
INSERT INTO lgl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Lau lio 'oka sulia sipsip gi, ma laka marabe fala maena folosia sipsip lau gi li. Ma gera ka saiagu, ma laka sai lou ada, malaa lou Mama 'e saiagu, ma laka sai lou ala. ");
INSERT INTO lgl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma nali sipsip agu lou iko 'ali gera io 'ua 'i laola banisi. Ma lakae sakeda lou mae. Ma gera ka rono raea linegu. Ma gera kae io ruru 'i laola teke gwaegwae sipsip lau failia sipsip 'e gera etae io lo 'i lifi'e gi. Ma lakae lio sulida sui. ");
INSERT INTO lgl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Mama 'e kwaima aagu, sulia lau marabe 'ali lau mae, ma 'ali lau mauri lou. ");
INSERT INTO lgl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ikoso ta ioli 'ali rauni lau, ala ikoso 'ali lau ala 'ali lau fai. Ma lia lo kwaiogalina lau. Lau too ala nanatana fala kwate nagu 'i talagu fala maena ma fala maurina lou. Kwaikaena Mama lau fagu lo fo.” ");
INSERT INTO lgl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ma ala talasi fo, ioli Jiu gi iko 'ali gera alua lo teke malata sulia Jesus 'i osiala 'are fo 'e ilida gi. ");
INSERT INTO lgl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Afulanada gera ilia, “Wale fo 'e kwekwe'ela, ma ka too ala aloe 'are ta'a. Ikoso 'ali 'amu ronosulia!” ");
INSERT INTO lgl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ma nali ioli ada gera ka sae 'uri 'e, “Wale 'e too ala aloe 'are ta'a li, 'e 'ato ka sae 'uri 'e! Ma wale 'e too ala aloe 'are ta'a, 'e 'ato ka guraa ioli maada koro gi, ma gera ka lio lou!” ");
INSERT INTO lgl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ala talasi ala boni la gwari li, ioli Jiu gi gera logo 'i Jerusalem fala Fanana ala fa abu nala Luma Abu God. ");
INSERT INTO lgl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ma Jesus ka io lou 'i laola Luma Abu fo, ma ka liliu mola 'ala 'i laola taofa Solomon. ");
INSERT INTO lgl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ma ala talasi ioli gi gera lesia, gera ka logo mae 'i so'ela, ma gera ka soilidia 'uri 'e, “'Ami faimaasi ka tekwa rasua lo. 'O ili rada ai famami! 'Uri'e ma 'i'o lo Christ, wale ba God 'e filia 'ali ka ranaa ioli gi li, 'o ma iko?” ");
INSERT INTO lgl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus ka olisi 'uri 'e ada, “Lau ilia famiu ka sui lo, wasua ma iko 'ali 'amu oga mola fakwalaimoki nagu. Galona 'e lau tauda gi, Mama lau lo 'e ilia laka tauda, ma gera ka fatae lau lo. ");
INSERT INTO lgl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Wasua ma ikoso 'ali 'amu oga mola fakwalaimoki na, sulia 'i 'amiu iko lou sipsip lau gi. ");
INSERT INTO lgl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip lau gi gera rono raea linela saenagu, ma laka saiada, ma gera ka dona buriagu. ");
INSERT INTO lgl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma laka kwatea maurina firi fada, ikoso gera mae. Ma ka 'ato ta ioli ka lauda faasi lau. ");
INSERT INTO lgl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mama lau 'e kwatea sipsip 'e gi fagu, 'i lia 'e nanata ka liufia 'are gi sui. Ma ka 'ato ta ioli ka laua sipsip 'e gi faasi lia. ");
INSERT INTO lgl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'I lau failia Mama, 'i 'ameroa teke 'are mola.” ");
INSERT INTO lgl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ma talasi fo, ioli gi gera ka so fau lou mae, 'ali gera ka 'uia Jesus ka mae. ");
INSERT INTO lgl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma Jesus ka soilidi gera 'uri 'e, “'Amu lesia ka sui lo galona 'oka afula gi lau tauda faasia Mama. 'Uri'e ma galona 'utaa ala galona fo gi lo 'amu oga rauninagu fafia?” ");
INSERT INTO lgl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma gera ka olisi 'uri 'e ala, “Iko 'ali 'ami 'ui 'o fafia galona 'oka 'e 'o tauda gi. 'Ami oga 'ami ka 'ui 'o 'amami fafia lia 'o sae fawawadea God. Sulia 'i'o wale mola ma ko ilia 'i'o God!” ");
INSERT INTO lgl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus ka olisi gera lou 'uri 'e, “Alaana gi gera io lo 'i laola Geregerena Abu 'amiu, God 'e sae 'uri 'e, ‘'I 'amiu god gi.’ ");
INSERT INTO lgl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ma gia saiala 'are gi sui 'i laola Geregerena Abu, 'e kwalaimoki rasua sulia talasi gi sui. Ma God iko 'ali rero talasi 'e sae fala koko gia gi, ma ka soida 'alia god gi li. ");
INSERT INTO lgl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma 'i lau wale God 'e fili lau, ma ka keri lau mae 'i laola molagali li. Ma 'e 'utaa 'e 'amu ka ilia lau sae fawawadea God, talasi lau soi lau 'alia Wela lia li? ");
INSERT INTO lgl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ala ikoso 'ali lau taua galona gi lia Mama lau 'e oga laka tauda, ikoso 'ali 'amu fakwalaimoki lau mola. ");
INSERT INTO lgl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wasua ma ala laka taua galona Mama 'e ogada gi, 'amu ka fakwalaimoki 'amiu ala galona fo gi, wasua ikoso 'ali 'amu fakwalaimoki ala 'are 'e lau ilida famiu gi. Ala 'amu ka taua 'are 'e gi, 'amu kae sai 'oka ala lia Mama 'e io agu, ma 'i lau laka io lou ala Mama li.” ");
INSERT INTO lgl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ma talasi fo lou, gera oga geraka daua Jesus, wasua ma 'e agwa faasi gera. ");
INSERT INTO lgl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma Jesus ka oli lou ala gulae kwai 'i Jodan, ma ka io 'i lififo ala lifi ba John 'e fasiuabua ioli gi ai 'i lao. ");
INSERT INTO lgl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma ioli afula rasua gi gera la mae 'i so'ela Jesus, ma gera ka alaa kwailiu ada 'i safitada 'uri 'e, “John iko 'ali taua mola tali 'are mama'ala, wasua ma 'are 'e ilia sulia wale 'e gi li, gera kwalaimoki sui mola.” ");
INSERT INTO lgl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma ioli afula gi ala lifi fo gera ka fakwalaimoki ala Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Te wale ratala Lasaros 'e matai. Ma 'e io ala falua 'i Betani failia rua gelifae lia gi, Mary failia Mata. ");
INSERT INTO lgl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mary ba 'e nikia waiwai si'ina fofo 'oka ala 'aela Jesus Aofia, ma ka 'usua 'alia ifula. ");
INSERT INTO lgl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ma rua gelifae fo gi daro kwate saena 'afia Jesus 'uri 'e, “Aofia, wale ba 'o kwaima rasua ala 'e matai.” ");
INSERT INTO lgl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma talasi Jesus 'e ronoa me 'are fo li, ka sae 'uri 'e fala wale li galona lia gi, “Lasaros ikoso 'ali 'e mae mola 'alia mataina fo. Me mataina fo 'e taua 'ali ka fatailia 'ilitoana God, ma 'ali ioli gi gera kae faa 'ilitoa lau, Wela God, 'alia.” ");
INSERT INTO lgl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ma Jesus 'e kwaima rasua ala Lasaros, failia rua gelifae lia gi Mata failia Mary. ");
INSERT INTO lgl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","'Urifo wasua 'ala, talasi Jesus 'e ronoa Lasaros 'e matai lo, ka ke io lou 'ala ala lifi fo 'e io ai, sulia na rua fe atoa. ");
INSERT INTO lgl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sui Jesus ka sae 'uri 'e fala wale li galona lia gi, “Golu oli lou fala 'i Judea.” ");
INSERT INTO lgl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma wale li galona lia gi daulu ka olisia 'uri 'e, “Waleli Falalauna, iko 'ali tekwa mola ko ba, ioli Jiu gi gera oga lo rauninamu 'alia 'uinamu 'alia fau. Ma ko oga lou koe oli lou 'i lififo?” ");
INSERT INTO lgl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma Jesus ka sae 'uri 'e, “'I laola teke fe atoa da'afi ka tala fuli'ae 'i 'ofaedani la la ka dao 'i raurafi. Ala ta ioli ka liu ala talasi da'afi 'e tala ai, 'e 'ato ka fotorae, sulia 'e lesia madakwanala molagali. ");
INSERT INTO lgl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wasua ma ala ta ioli kae liu 'i laola boni, 'i lia kae fotorae, sulia iko ta madakwana fala.” ");
INSERT INTO lgl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ma Jesus ka sae lou 'uri 'e, “Wale kwaima ba golu Lasaros, 'e mo'osu lo, ma lakae la, 'ali lau fa adaa.” ");
INSERT INTO lgl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma wale li galona lia gi daulu ka olisia 'uri 'e, “Aofia, ala 'e mo'osu mola 'ala, 'e 'oka mola 'ala.” ");
INSERT INTO lgl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ma malutala me saena fo Jesus 'e ilia Lasaros 'e mae lo fo. Wasua ma daulu fia 'uri 'e mo'osu kwalaimoki mola 'ala. ");
INSERT INTO lgl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Lia fo, Jesus ka faarono madakwa 'alia fadaulu 'uri 'e, “Lasaros 'e mae lo. ");
INSERT INTO lgl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ma fala 'okana 'amiu, lau babalafe lia iko 'ali lau io failia, 'ali 'amu ka fakwalaimoki lau. Golu la 'i so'ela.” ");
INSERT INTO lgl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas (lia gera soia 'alia 'I'iu) ka sae 'uri 'e fala wale li galona gi, “Golu la 'agaulu failia wale faalalau, 'ali golu mae lou failia!” ");
INSERT INTO lgl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ma talasi Jesus 'e dao ai, fai fe atoa gi 'e sui lo 'i burila gera alomia lo Lasaros. ");
INSERT INTO lgl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Falua 'i Betani 'e io garania 'i Jerusalem, ka totolia olu mile gi mola. ");
INSERT INTO lgl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma ioli afula 'i Judea gi gera dao fala maa toonala Mata failia Mary, fala fababatoo nadaroa, sulia ai walefae daroa 'e mae lo. ");
INSERT INTO lgl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ma talasi Mata 'e ronoa Jesus 'e dao mae ai, ka la fala lesinala. Ma Mary ka io 'ala 'i luma. ");
INSERT INTO lgl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata ka sae 'uri 'e fala Jesus, “Aofia, ala ko io io mola 'amua 'i lifi'e li, 'urilali ai walefae lau ikoso mae mola. ");
INSERT INTO lgl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Wasua ma, lau saiai talasi 'e wasua God 'e saiai ka kwatea mola 'ala ta taa koe sugaa ala.” ");
INSERT INTO lgl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma Jesus ka sae 'uri 'e fala, “Ai walefae 'o kae mauri lou.” ");
INSERT INTO lgl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma Mata ka sae 'uri 'e fala Jesus, “Lau saiai kae mauri lou ala fe atoa fafu'isi.” ");
INSERT INTO lgl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma Jesus ka sae 'uri 'e fala, “'I lau lo lakae taea ioli mae gi, ma laka kwatea lou mauri na fada. Ite mola 'ala 'e fakwalaimoki lau, 'i lia kae mauri lou, wasua ka mae lo 'ala. ");
INSERT INTO lgl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma ioli gera fakwalaimoki lau gi, gerakae too ala maurina firi, ma ikoso gera mae. 'Uri'e ma 'o fakwalaimokia me 'are 'e?” ");
INSERT INTO lgl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma Mata ka olisia 'uri 'e, “'Eo, Aofia. Lau fakwalaimokia 'i'o lo Christ, Wela God 'e la mae 'i laola molagali li.” ");
INSERT INTO lgl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma 'i burila Mata 'e ilia me 'are fo, ka oli, ma ka nurunuru fala geli fae lia Mary, ma ka sae 'uri 'e fala, “Wale li faalalauna 'e dao lo, ma 'e oga ka lesi'o.” ");
INSERT INTO lgl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ma talasi Mary 'e ronoa me 'are fo li, ka tatae, ma ka la nainali 'i so'ela. ");
INSERT INTO lgl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ma Jesus iko 'ali dao 'ua mae 'i falua, 'e io 'ua mola mae 'ala ala lifi ba Mata 'e dao tonala ai. ");
INSERT INTO lgl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ma ioli gera io 'i luma failia Mary fala fababatoonala malatala, gera la lou 'i burila talasi gera lesia 'e tatae ma ka la nainali ko 'i maluma. Gera fia 'uria kae la 'i maala bao 'ali ka ani 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ma talasi Mary 'e dao ala lifi fo Jesus 'e io ai li, ka lesia ma ka boururu 'i maala 'aela, ma ka sae 'uri 'e, “Aofia, ala ko io io mola 'amua 'i lifi'e li, ai walefae lau ikoso mae mola.” ");
INSERT INTO lgl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ma Jesus ka lesia Mary 'e ani, failia ioli gera la mae failia gi gera ani lou, ma 'i lia ka kwaimalatai rasua. ");
INSERT INTO lgl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma Jesus ka soilidi gera 'uri 'e, “'I fe 'amu alua ai?” Gera ka olisi 'uri 'e ala, “Aofia, 'o la mae, 'ali 'o lesia.” ");
INSERT INTO lgl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ma Jesus ka ani. ");
INSERT INTO lgl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma ioli Jiu gi gera ka sae kwailiu ada 'i safitada 'uri 'e, “'Amu lesia kwaimanaa ba'ela lia fala Lasaros!” ");
INSERT INTO lgl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma nali ioli ada gera sae 'uri 'e, “'E guraa ioli maada koro gi. 'Uri'e ma 'utaa iko 'ali famanoa Lasaros faasia maena?” ");
INSERT INTO lgl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus ka kwaimalatai rasua lou, ma ka la 'i maala bao. Bao fo, 'iguara la te abae fau ba'ela gera alua 'i maala. ");
INSERT INTO lgl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma Jesus ka sae nanata fada 'uri 'e, “'Amu lafua fau la!” Ma Mata gelifae wale 'e mae li, ka olisia 'uri 'e, “Aofia, fai fe atoa gi 'e sui lo 'i burila gera alua. Dao 'uri 'e, mala 'e si'ina wa'a lo!” ");
INSERT INTO lgl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma Jesus ka sae 'uri 'e fala, “Lau ilia ka sui lo famu ba ala ko fakwalaimoki lau, koe lesia 'ilitoana God.” ");
INSERT INTO lgl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ma gera ka lafua fau fo. Sui Jesus ka lio ala ala fala 'i nali ma ka foa 'uri 'e, “Mama, lau batafe 'o sulia 'o fafurono mae fagu. ");
INSERT INTO lgl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Lau saiai 'o rono lau sulia atoa gi. Lau ilia me 'are 'e, 'ali ioli 'e gi gera ka fakwalaimoki ala lia 'e 'o keri lau mae.” ");
INSERT INTO lgl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","'I burila 'e ilia alaana fo gi, ka rii ba'ela 'uri 'e, “Lasaros, 'o latafa mae!” ");
INSERT INTO lgl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ma wale fo 'e mae lo ka mauri lou, ma ka latafa lo mae 'i maluma. Ma rua 'aela gi, failia rua lima lia gi, gera buta 'alia toro fala 'afunala ioli mae gi li, failia maala gera buta lou. Ma Jesus ka sae 'uri 'e fada, “Moulu tatalia toro gi faasia, ma 'amu ka lugasia 'ali ma ka liu lo.” ");
INSERT INTO lgl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ma ioli afula Jiu gi li gera dao mae 'i so'ela Mary, gera lesia 'are fo Jesus 'e taua, ma gera ka fakwalaimoki ala. ");
INSERT INTO lgl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ma nali ioli ada, gera oli 'i so'ela Farasi gi, ma gera ka alaa sulia 'are fo Jesus 'e taua. ");
INSERT INTO lgl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ma Farasi gi, failia fata abu ba'ela gi, gera ka logo fala lokoimalatana failia wale etaeta gi, ma gera ka sae 'uri 'e, “Ta lo golu kae taua ala wale 'e? Sulia 'are mama'ala afula gi 'e fulida. ");
INSERT INTO lgl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma ala golu ka ala 'alia wale 'e ka tau mola 'ala 'uri 'e, ioli afula gi gera kae fakwalaimoki ala, ma wale ba'ela gi faasia 'i Rom, gera kae ogata'a fagaulu. Ma ala ka 'urifo lo, wale 'i Rom gi gera kae osia Luma Abu God, ma gera kae fafuta'a mae falua 'e gia!” ");
INSERT INTO lgl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma na wale ada ratala Kaeafas 'ilito'ola fata abu ala talasi fo li ka sae 'uri 'e, “Iko 'ali moulu sai mola ala ta 'are! ");
INSERT INTO lgl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Totolia moulu ka saiai lia 'e 'oka fala teke wale 'ali mae, 'ali ikoso gera raunia ioli gi sui?” ");
INSERT INTO lgl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ma alaana fo Kaeafas 'e ilia iko lou 'are 'i malatala talifilia. Sulia 'i lia lo 'ilito'ola fata abu ala talasi fo li, ma lia fo God ka alua malata fo 'i liola. Ma alaana fo 'e ilia sulia Jesus kae mae fala rananala ioli Jiu gi li. ");
INSERT INTO lgl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma ikoso 'ali mae fala ioli Jiu gi li mola talifilida. Kae mae 'ali wela God gi sui lia gera io ala tolo 'i laola molagali gi li sui, gera ka logo failia Jiu gi, 'ali ka alua teke logona. ");
INSERT INTO lgl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma fuli'ae ala fe atoa fo Kaeafas 'e ilia me saena fo li gera ka fuli'ae lo lokomalatana fala rauninala Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","'I osiala me 'are fo, Jesus iko 'ali liu tafanae lo ala provins 'i Judea. Ala talasi fo, ka la faasia lifi fo, ma ka la failia wale li galona lia gi daulu ka la, daulu ka io ala falua 'i Ifrem garania lo abae lifi kwasi. ");
INSERT INTO lgl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ala talasi fo, 'e garania lo atoa ala Fanana ala Daofae Liu na Jiu gi li. Ma ioli afula gi gera ka la ko fala 'i Jerusalem 'i laoala Fanana fo, fala fakwaganada fala fana na sulia falafala gera gi li. ");
INSERT INTO lgl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ma ioli gi gera ka lio 'afia Jesus. Ma talasi fo, gera logo sui mae 'i laola Luma Abu God, gera ka soilidi gera kwailiu 'uri 'e, “'Uri'e ma moulu fia kae dao mae ala Fanana 'e? Mala iko mola 'e!” ");
INSERT INTO lgl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Gera sae 'urifo sulia fata abu ba'ela gi, failia Farasi gi, gera alu saena 'i so'ela ioli gi 'uri 'e, “Ala ta ioli ka saiala lifi Jesus 'e io ai, 'i lia ka faarono 'ameulu 'alia 'ali meulu daua.” ");
INSERT INTO lgl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Olo fe atoa gi 'i laoala Fanana ala Daofae Liu na li, Jesus failia wale li galona lia gi daulu oli lou fala 'i Betani, mae falua Lasaros ba Jesus 'e faamauria faasia maena li. ");
INSERT INTO lgl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Gera rerei 'alia fana gi fala Jesus. Lasaros na wale lou ala ioli gera soia mae fala fana ruruna failia Jesus li. Ma Mata ka sake fana mae fada. ");
INSERT INTO lgl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma Mary ka sakea mae te be waiwai gera soia 'alia “nad,” folinai 'e ba'ela rasua. Mary ka sakea mae ka nikia 'i fofola 'aela Jesus fala faa 'ilitoanala. Sui Mary ka 'usua 'aela Jesus 'alia ifula. Ma talasi fo, luma fo ka fonu 'alia si'ina fofo nala waiwai 'oka fo. ");
INSERT INTO lgl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ma Judas Iskariot, wale li galona ba kae kwatea Jesus fala malimae lia gi li, ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“'Uta iko 'ali 'e foli 'alia waiwai 'oka fo? Te waiwai fo ala ka foli 'alia, kae sakea seleni la gi 'e totolia folifolina teke wale ka galo fai sulia teke fe falisi li. Ma seleni fo 'e totolia ko sakea ko kwatea fala ioli siofa gi.” ");
INSERT INTO lgl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas 'e iko 'ali ilia me 'are fo, sulia 'e malata fala rananala ioli gera siofa gi. Ma sulia 'ala 'i lia te wale belibeli. Ma 'i lia lou wale fala liona sulia wai seleni daulu li. Ma talasi gi sui, 'e saiai ka fafuta'a mola 'ala seleni fo gi ala 'i talala. ");
INSERT INTO lgl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ala talasi fo, Jesus ka sae 'uri 'e, “Moulu ala bolosinala geli 'e! 'E golia be waiwai 'e fala dalafinai 'alia rabegu ala talasi ala alominagu. ");
INSERT INTO lgl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma ioli siofa gi, gera kae io mola 'ada fae 'amiu sulia atoa gi. Ma 'i lau ikoso 'ali lau io tekwa fae 'amiu.” ");
INSERT INTO lgl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ioli afula gi gera ronoa Jesus 'e io 'i Betani, ma gera ka la mae 'i so'ela. Iko 'ali gera la lou 'i osiala Jesus mola talifilia 'e io 'i falua fo. Ma gera la mae fala lesinala Lasaros ba Jesus 'e faamauria faasia maena li. ");
INSERT INTO lgl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ma afulanala ioli Jiu gi, gera la lo faasia fata abu ba'ela gi, ma gera ka fakwalaimoki lo ala Jesus sulia 'e faamauria Lasaros faasia maena. Lia fo, fata abu ba'ela gi gera ka lokomalata lou fala rauninala Lasaros malaa lou lia gera naia rauninala Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sui ala ruala fe atoa, ioli afula gera la mae ala Fanana ala Daofae Liu na li, gera ronoa Jesus 'e la mae fala 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Gera la, gera ka sakea mae 'abala baibai gi, ma gera ka la mae 'ali geraka dao tonala Jesus. Ma gera ka rii 'uri 'e, “Baatafea God! God 'o 'oilakitailia wale 'e la mae 'alia nanatana 'o li! God ka fa'oka waleli talona gia 'i Israel.” ");
INSERT INTO lgl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ala talasi fo, Jesus ka sakea te dongki, ma ka tae mae 'i fofola. Me 'are fo 'e fakwalaimokia 'are ba Geregerena Abu 'e ilia 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“'I 'amiu ioli 'i Jerusalem gi, ikoso 'ali 'amu mau! 'Amu lesia waleli talona 'amiu 'e la mae 'i fofola kale dongki.” ");
INSERT INTO lgl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ma talasi fo, wale li galona gi iko 'ali gera raea 'ua me 'are fo. Sui 'i burila Jesus 'e mauri lou ma ka oli fala 'i nali, daulu bi malata tonala Geregerena Abu sulia me 'are fo gera ka taua ala. ");
INSERT INTO lgl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ma ioli gera io failia Jesus ala talasi 'e soia mae Lasaros faasia 'i laola bao ioli mae gi li ma ka kwatea ka mauri lou, gera faarono 'alia 'are fo fala ioli afula gi. ");
INSERT INTO lgl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Lia fo 'e taua ma ioli afula gi gera ka la mae, 'ali geraka dao tonala Jesus. Gera la sulia gera ronoa sui lia Jesus 'e fulia 'are mama'ala fo li. ");
INSERT INTO lgl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ma talasi fo, Farasi gi gera ka sae 'ada 'uri 'e kwailiu 'i safitada, “'Amu lesia! Wasua golu ka lokomalata 'alia lioe wale afula gi, 'e 'ato lo. Sulia ioli afula gi gera la lo sulia wale fo!” ");
INSERT INTO lgl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nali ioli faasia 'i Gris, gera io lou 'i safitala ioli fo gera la mae fala 'i Jerusalem fala foana ala Fanana ala Daofae Liu na li. ");
INSERT INTO lgl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gera la 'i so'ela Filip, wale faasia 'i Betsaeda 'i laola gulae tolo 'i Galili, ma gera ka sae 'uri 'e fala, “Meulu oga meulu ka lesia Jesus.” ");
INSERT INTO lgl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Sui Filip ka la, ma ka faronoa Andrew, ma daro ka la, daro ka faronoa Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma Jesus ka olisi 'uri 'e adaroa, “Talasi lau, Wela Wale li, 'e dao lo 'ali God ka fatailia lo 'ilitoana lau. ");
INSERT INTO lgl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","'Are kwalaimoki la kae ilia famoulu. Ala ta teke fufuae 'ai witi ikoso toli 'i laola wado ma ikoso 'ali mae, fufuae 'ai la ka io mola 'alia teke me fufuae witi. Ma ala ka mae lo, tara 'e bi alua fufuae 'are afula gi. ");
INSERT INTO lgl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ma ala ta ioli ka lio ba'ela ala maurinala 'i talala, 'i lia kae mae mola 'ala. Ma ala ta ioli iko 'ali lio ba'ela ala maurinala 'i laola molagali 'e, 'i lia kae too ala maurina firi. ");
INSERT INTO lgl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ma ta ioli 'e oga ka galo fagu, 'i lia ka liu suli lau, 'ali 'i lia ioli li galona kwalaimoki lau, ma ka io ala lifi la lau io ai. Ma Mama lau ka kwaiara ioli 'e galo fagu. ");
INSERT INTO lgl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ma talasi 'e, manogu 'e fii lau, ma ta taa 'e lakae ilia? Lakae sae 'uri 'e, ‘Mama, ikoso ala'alia 'ali talasi fo 'ali dao fafi lau’? 'E Iko. Sulia lia lo 'are lau la mae fai, 'ali lau liu lo 'i laola talasi fo ala famalifiina li. ");
INSERT INTO lgl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mama, 'o faatalofa ratamu.” Ma talasi fo, te linae 'are ka sae mae faasia 'i nali 'uri 'e, “Lau sakea sui lo talona fala ratagu, ma lakae taua lou.” ");
INSERT INTO lgl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ma logona fo gera ura 'i lififo li, gera ronoa line 'are fo, ma nali ioli ada gera ka ilia 'uria kurukuru sefo. Ma nali ioli gera ka sae 'uri 'e, “Ta eniselo te la 'e sae mae fala!” ");
INSERT INTO lgl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sui Jesus ka sae 'uri 'e fada, “Line 'are fo 'e sae mae, 'e iko 'ali sae mae fala rananagu, 'e sae mae 'ala fala rana namiu. ");
INSERT INTO lgl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ma talasii 'e dao lo fala God ka loko kwaikwaina fala ioli gi 'i laola molagali 'e. Ma ala talasi 'e, God 'e suarailia lo Saetan, wale ba'ela ala molagali 'e li. ");
INSERT INTO lgl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma talasi gera kae farae lau ala 'ai rara folo li, lakae talaia mae ioli gi sui 'i soegu.” ");
INSERT INTO lgl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","('E fatailia 'alia alaana 'e gi, me maena 'utaa kae mae 'alia.) ");
INSERT INTO lgl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ma ioli gi gera ka sae 'uri 'e, “Geregerena Abu gia 'e ilia Christ kae mauri firi. 'Urilali ma 'utaa ko ilia gera kae taea Wela Wale li ala 'ai rara folo? Ma ite lo Wela Wale li?” ");
INSERT INTO lgl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus ka olisi 'uri 'e ada, “Lau malaa madakwana ba'ela, ala talasi wawade 'e lau io 'ua fae 'amiu. Totolia 'amu ka ronosulia saenagu ala talasi 'e lau io 'ua fae 'amiu, 'ali 'amu ka lio raea tala 'oka. Sulia ioli 'e liu 'i laola mae rodo li, 'i lia 'e raria 'i fe kae la fai. ");
INSERT INTO lgl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Talasi madakwana 'e io 'ua fae 'amiu, 'amu ka fakwalaimoki ala, 'ali 'i 'amiu wela ala madakwana li.” Jesus 'e ilia 'are fo gi, sui ka la lo 'ala faasida, ma ka agwa lo 'ala faasida. ");
INSERT INTO lgl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Wasua Jesus ka taua 'are mama'ala afula gi ma gera ka lesida, iko 'ali gera fakwalaimokia mola. ");
INSERT INTO lgl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Me 'are fo gi 'e 'urifo, 'ali ka fakwalaimokia alaana Aesea te profet ba 'e ilia lo mae 'i lao, lia ba 'e sae 'uri 'e, “Aofia, iko 'ali gera fakwalaimokia mola alaana 'e 'ami faatalo 'alida gi. Ma iko 'ali gera lio raea lou nanata na 'o, lia 'o fatailia fada.” ");
INSERT INTO lgl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ioli gi iko 'ali gera fakwalaimokia Jesus, sulia Aesea 'e sae lou 'uri 'e: ");
INSERT INTO lgl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Aesea 'e ilia God 'e sae 'uri 'e, “Lau bolosia maada 'ali ikoso gera lesia ta 'e lau taua fada. Lau fanasia malatada 'ali ikoso gera saiala ta 'e lau taua fada. Lau tau 'urifo ada 'ali ikoso gera saiala bulusi na lou mae 'i soegu 'ali laka faamauri gera.” ");
INSERT INTO lgl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aesea 'e ilia 'are gi sulia 'e lesia lo talona Jesus, ma ka sae sulia. ");
INSERT INTO lgl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Wasua ka 'urifo, wale etaeta afula ala Jiu gi li gera fakwalaimoki ala Jesus. Wasua ma iko 'ali gera sae mola sulia fala ioli mamata gi, sulia gera maulia Farasi gi, tau ma gera bi luida faasia ruuna 'i laola luma fala foana gera gi li. ");
INSERT INTO lgl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gera malata 'abero rasua 'ada sulia taunala 'are fala ioli mola ka babalafe fafia. Ma iko 'ali gera malata 'abero mola sulia taunala 'are 'alia God 'ali ka babalafe fafia. ");
INSERT INTO lgl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ma Jesus ka sae ba'ela 'uri 'e, “Ala ta ioli 'e fakwalaimoki agu, 'i lia 'e fakwalaimoki lou God lia 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma ala ta ioli 'e leesi lau, 'i lia 'e lesia lo God lia 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Lau la mae 'i laola molagali 'e malaa madakwa na fala ioli gi, 'ali ite ioli 'e fakwalaimoki lau, ikoso gera io 'i laola maerodo. ");
INSERT INTO lgl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma ite ioli 'e ronoa saenagu, ma iko 'ali tau sulia, iko 'ali lau lokokwaikwaina fala, sulia iko 'ali lau la lou mae 'i laola molagali 'e fala lokokwaikwaina. Ma lau la mae 'agua fala faamurinala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ioli gera barasi 'ali lau gi, failia faalalauna lau gi, faalalauna fo gi lo kae io fala loko kwaikwaina fala ioli la gi li, ala atoa fafu'isi. ");
INSERT INTO lgl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","'Are 'e 'e kwalaimoki, sulia talasi lau sae 'alia, iko 'ali lau sae sulia 'are sulia malatagu 'i talagu gi. Wasua ma Mama lau 'e 'e keri lau mae, 'i lia 'e ilia kwaikaena gi fagu laka ilida, ma laka sae sulida. ");
INSERT INTO lgl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma lau saiai, kwaikaena Mama lau gi li 'e kwatea maurina firi fala ioli gi. 'Are lau ilida gi, 'i gera lo 'are Mama lau 'e ilia fagu gi, 'ali lau faatalo 'alida.” ");
INSERT INTO lgl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Fe atoa 'i lao ala Fanana ala Daofae Liu na li, Jesus ka sai lo ala talasi lia 'e garani dao lo 'ali ka la lo faasia molagali, ma ka oli 'i so'ela Mama lia. 'E kwaima rasua ala ioli li galona lia lia gera io lo 'i laola molagali 'e li, ma ka kwaima ada lala ka dao ala talasi 'e mae ai. ");
INSERT INTO lgl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ma Jesus failia wale li galona lia gi, daulu fana 'adaulu raurafi. Ma Saetan ka alua lo me malata fo 'i laola liola Judas, wela Simon Iskariot, 'ali ka kwatea Jesus fala malimae lia gi. ");
INSERT INTO lgl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ma Jesus 'e saiai liafo Mama lia 'e kwatea nanatana gi sui lo fala. Ma ka sai lou ai, lia 'e la mae faasia God, ma kae oli lou 'i so'ela God. ");
INSERT INTO lgl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Lia fo Jesus ka tatae faasia tarapapa, ma ka kalasua to'omi fafi lia, ma ka firia lo 'aba toro li 'usu rabe 'i abalola. ");
INSERT INTO lgl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sui ka nikia kwai 'i laola dako, ma ka saua lo 'aela wale li galona lia gi, ma ka 'usua 'aeda 'alia 'aba toro fo 'e firia 'i abalola. ");
INSERT INTO lgl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ma talasi 'e li dao ala Simon Peter, 'i lia ka sae 'uri 'e fala Jesus, “Aofia, 'uri koe saua dao 'aegu?” ");
INSERT INTO lgl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma Jesus ka olisia 'uri 'e, “Ala talasi 'e, 'o raria 'ua me 'are 'e la kae taua amu, wasua koe malinailia 'i buri.” ");
INSERT INTO lgl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ma Peter ka sae 'uri 'e, “'I lau, ikoso 'ali ma koe saua 'aegu!” Ma Jesus ka olisia 'uri 'e, “Ala ikoso 'ali lau saua 'aemu, 'i'o iko ta wale li galona lau.” ");
INSERT INTO lgl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ma Peter ka olisia 'uri 'e, “Aofia, ikoso saua mola 'aegu talifilia. Ma 'o saua lou limagu, failia gwaugu!” ");
INSERT INTO lgl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus ka sae 'uri 'e, “Ite 'e sisiu ka sui lo, rabela 'e kwaga sui lo, ma ikoso 'ali siufia lou rabela sui. 'I lia ka saua mola 'aela. Moulu kwaga sui lo, ma teke wale mola amoulu iko 'ali kwaga.” ");
INSERT INTO lgl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus 'e saiai ka sui lo ite kae foli 'alia fala malimae gi, ma lia fo ka sae 'uri 'e, “Moulu kwaga sui lo, ma teke wale mola amoulu 'e iko 'ali kwaga.” ");
INSERT INTO lgl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ala talasi Jesus 'e saua 'aeda ka sui, ka rufia lou to'omi fafi lia, sui ka oli ka gwauru failida. Ma ka soilidida 'uri 'e, “'Uri'e ma moulu saiala malutala me 'are 'e lau taua famoulu? ");
INSERT INTO lgl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Fadanai 'e 'uri 'e: Moulu soi lau 'alia Wale li Faalalauna failia Aofia 'amiu, ma 'e rada rasua 'ali 'amu ka soi lau 'urifo, sulia 'i lau wale li faalalauna failia Aofia 'amiu. ");
INSERT INTO lgl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma sulia 'i lau wale li faalalauna failia Aofia 'amiu lau saua 'aemiu. 'I 'amiu lou 'amu ka tau lou 'urifo 'i matanamiu. ");
INSERT INTO lgl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Lau taua me 'are fo famoulu 'ali 'i 'amoulu lou moulu ka taua lou malaa lia 'e lau taua amoulu. ");
INSERT INTO lgl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","'Are kwalaimoki la kae ilia famoulu, wale li galona iko 'ali 'ilitoa ka liufia wale ba'ela lia. Ma wale li sakesake saena, iko 'ali 'ilitoa liufia wale 'e keria. ");
INSERT INTO lgl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","'Amu ka sai 'oka ala 'are 'e lau ilida famiu gi. Ma ala 'amu ka tau lou sulida, 'amu kae babalafe kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Lau ilia 'are 'e gi iko lou famiu sui. Lau sai mola 'agua ala nalife ioli 'e lau filida. Ma lau saiai te wale amoulu kae kwate lau fala malimae lau gi, 'ali ka fakwalaimokia Geregerena Abu ba 'e sae 'uri 'e, ‘Te wale mera fana ruru ala berete lau li, 'i lia lou malimae lau.’ ");
INSERT INTO lgl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Me 'are 'e iko 'ali dao 'ua mae, ma 'e 'oka 'ali lau ilia famoulu ala talasi 'e, 'ali ala talasi kae dao wasua, moulu kae fakwalaimoki lia 'e 'I lau 'E. ");
INSERT INTO lgl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","'Are kwalaimoki la kae ilia famoulu, ta ioli mola 'ala 'e kwaloa ta ioli lau keria ko, 'i lia 'e kwalo lau lou. Ma ta ioli mola 'ala 'e kwalo lau, 'i lia 'e kwaloa lou God 'e 'e keri lau mae.” ");
INSERT INTO lgl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","'I burila Jesus 'e sae 'urifo ka sui, 'i lia ka kwaimalatai rasua. Ma ka faarono madakwa lo 'alia fala wale li galona lia gi 'uri 'e, “'Are kwalaimoki la kae ilia famoulu. Te wale amoulu kae kwate lau fala malimae lau gi.” ");
INSERT INTO lgl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ala talasi fo, wale li galona gi daulu ka bubu kwailiu lo fadaulu, sulia iko 'ali daulu saiala ite fo Jesus 'e sae sulia. ");
INSERT INTO lgl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ma na wale ala wale li galona lia gi, wale Jesus 'e kwaima ala, 'i lia 'e gwauru garania Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma Simon Peter ka fairalo fala wale li galona fo, 'ali ka soilidia Jesus 'afia ite fo 'e sae sulia. ");
INSERT INTO lgl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wale li galona fo ka 'idu garania ko Jesus, ma ka nurunuru 'uri 'e fala, “Aofia, ite wale laa 'o sae sulia?” ");
INSERT INTO lgl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus ka olisia 'uri 'e, “Wale lakae saua berete 'i laola teui sulu ma la kae kwatea fala. Wale lakae taua me 'are fo fala, 'i lia lo wale la.” Ma talasi Jesus 'e saua berete 'i laola teui sulu ka sui, ka kwatea fala Judas wela Simon Iskariot. ");
INSERT INTO lgl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ala talasi fo mola Judas ka sakea lo berete fo, Saetan ka rufia lo. Ma Jesus ka sae 'uri 'e fala, “'O tau nainali failia me 'are koe taua.” ");
INSERT INTO lgl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma wale li galona gera gwauru galia tarapapa gi li, gera ka raria malutala me 'are fo Jesus 'e ilia fala Judas. ");
INSERT INTO lgl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ma sulia Judas wale 'e lio sulia wai seleni daulu li, nali ai ala wale li galona gi gera fia 'uria Jesus 'e ilia fala Judas, 'ali la ka folia mae tali fana daulu boboo fai fala fanana fo, 'o ma ka la ka sakea mae tali 'are 'ali daulu ka kwatea fala ioli siofa gi. ");
INSERT INTO lgl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","'I burila Judas 'e sakea lo me berete fo, ka latafa nainali lo 'i maluma. Ma ala talasi fo 'e rodo lo. ");
INSERT INTO lgl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Talasi Judas 'e la lo, Jesus ka sae 'uri 'e, “Talasi 'e dao lo 'alia Wela Wale li ka ruu 'i laola talona 'ilitoa lia, ma God kae sakea talona ba'ela 'alia 'are kae fuli ala Wela lia li. ");
INSERT INTO lgl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma ala talona 'ilitoa God kae fatae agu, God kae fatae nainali ala talona 'ilitoa lau 'alia 'i lia talala. ");
INSERT INTO lgl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Alae wela lau, ikoso lau io tekwa lo fae 'amiu. 'Amu kae lio 'afi lau, wasua ma la kae ilia famoulu 'are ba lau ilia lo fala wale etaeta ala Jiu gi li lia ba 'e 'uri 'e, ‘'Ato 'amu ka la ala lifi 'e la kae la ai.’ ");
INSERT INTO lgl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ma taki fa'alu la kae kwatea famoulu 'e 'uri 'e: 'Amu ka kwaima amiu talamiu 'i matanamiu kwailiu, malaa lou lia 'e lau kwaima amiu. ");
INSERT INTO lgl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ma ala 'amu too ala kwaimanaa famiu talamiu kwailiu, ioli gi sui gera kae saiai lia 'i 'amiu ioli li galona lau gi.” ");
INSERT INTO lgl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sui Simon Peter ka soilidia Jesus 'uri 'e, “Aofia, 'i fe 'e koe la fai?” Jesus ka olisia 'uri 'e, “Lifi 'e lakae la fai, iko 'ali 'amu saiala laa na fae lau fai. Wasua ma ta fe atoa, 'amu kae la mae 'i burigu.” ");
INSERT INTO lgl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Sui Peter ka soilidi lou 'uri 'e, “Aofia, ta 'e taua ma ka 'ato fameulu fala laa na fae'o ala talasi 'e li? Sulia lau rerei lo fala maena bolosi 'o.” ");
INSERT INTO lgl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus 'e olisia ka sae 'uri 'e fala, “'Uri'e ma 'o rerei kwalaimoki fala maena bolosi lau wani? 'Are kwalaimoki la kae ilia famu. 'I laoala karai kae ani, koe ilia olu me talasi gi 'uri iko 'ali 'o sai agu.” ");
INSERT INTO lgl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesus ka sae 'uri 'e fala wale li galona lia gi, “Ikoso moulu malata 'abero ma malatamoulu ikoso toli. 'Amu ka fitoo ala God, ma 'amu ka fito lou agu. ");
INSERT INTO lgl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Sulia lifi afula li io gi 'i laola luma Mama lau li. Ma lakae la 'ali lau rerei 'alia lifi famiu. 'Ato 'ali lau ilia 'are 'e famiu, ala 'e iko 'ali kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma talasi lakae la, ma laka rerei 'alia lifi famiu, ka sui lakae oli mae ma laka talai 'amiu fagu 'i talagu, 'ali lifi lau io ai, 'amu kae io lou ai. ");
INSERT INTO lgl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma moulu sai mola 'amoulu ala tala 'e laa fala lifi 'e lakae la fai li.” ");
INSERT INTO lgl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma Tomas ka sae 'uri 'e, “Aofia, meulu raria lifi la koe la fai. 'Uri'e ma meulu kae sai 'utaa ala tala la wani?” ");
INSERT INTO lgl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma Jesus ka olisia 'uri 'e, “'I lau mola teke Tala li liu, teke Kwalaimokina, ma teke Maurina. Ikoso ta ioli 'ali la 'i so'ela God Mama ala iko 'ali ruu agu. ");
INSERT INTO lgl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ma ala 'amu ka sai kwalaimoki agu, 'amu sai lou ala Mama lau. Fuli ala talasi 'e ka la 'alaa, moulu sai lo ala Mama lau, ma moulu ka lesia lo.” ");
INSERT INTO lgl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma Filip ka sae 'uri 'e, “Aofia, 'ami oga ko fatailia ga Mama famami.” ");
INSERT INTO lgl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma Jesus ka olisia 'uri 'e, “Filip, lau io fae 'amoulu ka tekwa lo, ma iko 'ali 'o sai 'ua agu 'e? Ma ta ioli mola 'ala 'e leesi lau, 'i lia 'e lesia lo Mama lou. Ma 'utaa 'e ko ilia 'ali lau fatailia lou Mama lau? ");
INSERT INTO lgl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'Uri'e ma iko 'ali 'o fakwalaimokia mola lia 'e lau io ala Mama, ma Mama lou ka io agu? Alaana 'e lau ilida famiu gi, iko lou alaana lau gi 'i talagu. Mama 'e 'e io agu 'e taua galona lia gi 'ali lau. ");
INSERT INTO lgl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","'Amu ka fakwalaimoki agu talasi lau ilia lau io ala Mama li, ma Mama ka io agu. Ala iko, 'amu ka fakwalaimoki agu 'i fofola galona 'e lau tauda gi. ");
INSERT INTO lgl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","'Are kwalaimoki lakae ilia famoulu, ala ta ioli mola 'ala ka fitoo agu, 'i lia ka taua lou galona 'e lau tauda gi. Ma 'i lia ka taua lou galona la gi gera ba'ela lou, sulia la kae la 'i so'ela Mama. ");
INSERT INTO lgl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma ta 'are mola 'ala moulu ka sugaa ala Mama osiala 'i 'amoulu wale li galona lau gi, lakae taua, 'ali talasi ioli gi gera ka lesia, gera ka lio raea Mama 'e 'ilitoa ka tasa. ");
INSERT INTO lgl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ma ta 'are mola 'ala 'amu ka suga lia fai fofola 'i 'amiu ioli lau gi, lakae tauda famiu.” ");
INSERT INTO lgl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesus ka sae lou 'uri 'e, “Ala 'amu kwaima aagu, 'amu ka ronosulia kwaikaena lau gi. ");
INSERT INTO lgl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Lakae sugaa Mama, ma 'i lia kae kwatea mae Wale li kwairanai famiu, ma 'i lia kae io talau fae 'amiu. ");
INSERT INTO lgl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'I lia Aloe 'are Abu kae fatailia kwalaimokina sulia God. Ma ioli iko 'ali gera fakwalaimoki gi, ikoso gera kwaloa mola, sulia iko 'ali gera lesia, ma iko 'ali gera sai mola ala. Ma 'i 'amiu 'amu sai lo ala, sulia 'e io fae 'amiu, ma kae io 'i laola manomiu. ");
INSERT INTO lgl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Talasi lakae la, 'ato 'ali lau tafisi 'amiu malaa wela ilamae gi. Lakae oli lou mae 'i soemiu. ");
INSERT INTO lgl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Keme talasi wawade mola 'e ore, ioli 'e iko 'ali gera fakwalaimoki gi, ikoso gera leesi lau lo. Ma 'i 'amiu 'e, 'amu kae leesi lau lou 'amiu. Ma sulia lau mauri, 'amu kae mauri lou. ");
INSERT INTO lgl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ma talasi lakae mauri lou, 'amu kae saiai lia lau io 'ado failia Mama lau, ma 'amu kae io 'ado lou fae lau, ma laka io 'ado fae 'amiu. ");
INSERT INTO lgl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ma ta ioli mola 'ala 'e ronosulia kwaikaena lau gi, 'i lia lo ioli 'e kwaima aagu. Ma ta ioli mola 'ala 'e kwaima aagu, Mama lau ka kwaima lou ala, ma 'i lau wasua lau kwaima lou ala, ma la kae fatae lau talagu fala.” ");
INSERT INTO lgl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (iko lou Iskariot) ka soilidia 'uri 'e, “Aofia, 'utaa 'e 'i 'ameulu mola meulu saiala leesinamu, ma ioli 'e iko 'ali gera fakwalaimoki gi ikoso 'ali gera leesi 'o?” ");
INSERT INTO lgl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus ka olisia 'uri 'e, “Ala ta ioli 'e kwaima agu, 'i lia kae ronosulia faalalauna lau gi. Ma Mama lau kae kwaima ala, ma Mama lau, mera kae la mae 'i so'ela, ma mera ka io failia. ");
INSERT INTO lgl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma ite ioli iko 'ali kwaima agu, 'i lia ikoso ronosulia faalalauna lau gi. Ma faalalauna lau gi lia 'amu ronoda, iko lou 'are lau 'i talagu gi. Sulia gera fuli mae faasia Mama 'e 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Lau ilia 'are 'e gi famiu ala talasi lau io 'ua fae 'amiu. ");
INSERT INTO lgl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mama lau kae kwatea mae Aloe 'are Abu 'alia ratagu, 'ali 'e rana 'amiu. 'I lia kae faalalau 'amiu 'alia 'are gi sui, ma ka faalalau 'amiu 'ali 'amu malata tonala 'are lau faarono 'amiu lo 'alida 'i lao gi sui. ");
INSERT INTO lgl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Lau tafisia lo babatoona lau famiu. Babatoona 'e lau kwatea famiu, 'e iko 'ali malaa aroarona 'i laola molagali li. Lia fo, ikoso 'ali 'amu malata fiitala, ma ikoso 'ali 'amu mau. ");
INSERT INTO lgl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","'Amu ronoa sui lo saenagu ba 'uri 'e, ‘Lakae la, ma lakae oli lou mae 'i soemiu.’ Ala 'amu ka kwaima agu, 'amu ka babalafe sulia la kae la 'i so'ela Mama, sulia 'i lia 'e 'ilitoa ka tasa liufi lau. ");
INSERT INTO lgl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Lau ilia lo 'are 'e gi, sui buri gera ka bi fuli, 'ali ala talasi gera kae fuli ai, 'amu ka fakwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ikoso 'ali lau alaa tekwa lou fae 'amiu, sulia Saetan wale ba'ela ala molagali 'e li, 'e garani dao lo mae. Wasua ma 'e iko 'ali 'ilitoa fafi lau. ");
INSERT INTO lgl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma 'i lau talagu, laka taua 'are gi sui sulia ta lo Mama lau 'e ilia fagu fala taunai, 'ali ioli ala molagali 'e li gera ka saiai lau kwaima ala Mama lau. “Golu tatae, golu ka la lo faasia 'i lifi 'e.” ");
INSERT INTO lgl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesus ka sae lou 'uri 'e fala wale li galona lia gi, “'I lau tali 'ai grep kwalaimoki, ma Mama lau wale 'e galo ala raku li. ");
INSERT INTO lgl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ma 'e saiai ka tofua rarae 'ai iko 'ali gera funu gi faasi lau, ma ka galea rarae 'ai gera funu gi, 'ali gera ka funu 'oka. ");
INSERT INTO lgl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma 'i 'amoulu moulu kwaga sui lo 'alia faalalauna lau famoulu gi. ");
INSERT INTO lgl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","'Amu ka io agu, 'ali lau io lou amiu. Rarae 'ai 'e 'ato ka funu 'ala 'i talala, ala iko 'ali 'e io lado ala tali 'ai. Ma ka 'urifo lou amiu, 'e 'ato 'amu ka taua 'are 'oka gi, ala iko 'ali 'amu io agu. ");
INSERT INTO lgl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“'I lau lo tali 'ai grep, ma 'i 'amiu rarae 'ai gi. Ma ioli 'e io agu ma laka io ala 'e saiai ka funu 'alia fuae grep afula gi. Ma ala iko 'ali 'amu io agu, 'e 'ato 'amu ka taua ta 'are 'oka. ");
INSERT INTO lgl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma ioli iko 'ali io agu, 'e malaa na rarae 'ai gera 'ui 'alia ma ka mae. Ma rarae 'ai 'urifo gi, gera ka sakeda, ma gerakae 'ui 'alida 'i laola dunaa ka 'agofida. ");
INSERT INTO lgl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma ala 'amu ka io agu, ma saenagu ka io talau amiu, 'amu ka sugaa ta 'are mola 'ala 'amu oga, ma lakae kwatea famiu. ");
INSERT INTO lgl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ma galona 'oka afula 'e 'amu tauda gi, kae fatailia 'ilitoana Mama lau li. Ma kae fatailia lou 'i 'amiu wale li galona lau gi. ");
INSERT INTO lgl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Lau kwaima amiu ka malaa lou Mama lau 'e kwaima aagu. Lia fo, 'amu ka io talau 'i laola kwaimanaa lau. ");
INSERT INTO lgl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ma ala 'amu ka ronosulia kwaikaena lau gi, 'amu kae io talau 'i laola kwaimaana lau, malaa lou lia 'e lau ronosulia kwaikaena Mama lau gi li, ma laka io talau lou 'i laola kwaimaana lia li. ");
INSERT INTO lgl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Lau ilia 'are 'e gi famiu 'ali ma babalafena lau ka io amiu ma babalafena 'amiu ka 'afu. ");
INSERT INTO lgl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ma kwaikaena lau famiu 'e 'uri 'e: 'Amu ka kwaima amiu talamiu 'i matanamiu, ka malaa lou lau kwaima amiu. ");
INSERT INTO lgl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Iko ta kwaimaana 'ali liufia kwaimaana la wale ka kwatea maurinala fala kwaima lia gi, 'ali ka faamaurida. ");
INSERT INTO lgl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ma 'i 'amiu kwaima lau gi, ala 'amu ka ronosulia kwaikaena lau gi li. ");
INSERT INTO lgl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma iko 'ali lau soi 'amiu 'alia ioli li galona gi, sulia ioli li galona ikoso saiala 'are wale ba'ela lia kae tautauda gi. Lau soi 'amiu 'alia kwaima lau gi 'ala, sulia lau faarono 'amiu sui lo 'alia 'are gi sui lia lau ronoa faasia Mama lau. ");
INSERT INTO lgl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ma iko 'ali 'amu fili lau, 'i lau lo lau fili 'amiu, 'ali 'amu ka taua 'are 'oka afula gi, malaa 'ai fo 'e funu 'oka 'alia fuae 'are kae io talau. Ma Mama kae kwatea ta 'are mola 'ala 'amu ka sugaa ala, sulia 'i 'amiu wale li galona lau gi. ");
INSERT INTO lgl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ma kwaikaena lau famiu 'e 'uri 'e: 'Amu ka kwaima amiu talamiu 'i safitamiu. ");
INSERT INTO lgl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ala ioli 'i laola molagali 'e li gera ka lio ta'a amiu, 'amu ka malata tonala lia gera etae lio ta'a lou agu 'i lao. ");
INSERT INTO lgl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ala 'i 'amiu nali ioli ta'a lou 'i laola molagali 'e, gera kae kwaima amiu, suli 'amu malaa 'i gera lou. Wasua ma lau fili 'amiu sui lo, 'ali 'amu ka mamata faasia ioli ta'a gi 'i laola molagali. Ikoso 'ali 'amu io lou malaa 'i gera, ma lia 'e taua ikoso gera oga 'amiu. ");
INSERT INTO lgl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","'Amu ka malata tonala 'are ba lau ilida ka sui lo famiu gi. ‘Ioli li galona 'e iko 'ali 'ilitoa ala wale ba'ela lia.’ Sulia gera malakwaita agu, gera kae malakwaita lou amiu. Ma nali ioli gera ronosulia saenagu, ma kae 'urifo lou famiu, tali ioli kae rono lou sulia saenamiu. ");
INSERT INTO lgl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ma gerakae malakwaita amiu, sulia 'i 'amiu ioli lau gi. Gera kae tau lou 'urifo sulia iko 'ali gera saiala God 'e 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma ala ikoso lau la la mae 'i laola molagali li, ma ikoso 'ali lau faarono gera 'alia li, ikoso gera mau 'alia tau ta'ana. Ma talasi 'e, 'e 'ato lo fala ioli ka ilia iko 'ali rero, sulia lau la mae, ma laka ilia ka sui lo fada. ");
INSERT INTO lgl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma ta ioli 'e barasi 'ali lau, 'i lia 'e barasi lou 'alia Mama lau. ");
INSERT INTO lgl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Lau fulia 'are la gi iko ta wale 'ali fulida 'i lao. Gera lesia lau fulia 'are fo gi, geraka mau 'alia tau ta'ana gera gi, ma gera ka lio ta'a lo 'ada agu failia Mama lau. ");
INSERT INTO lgl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","'Are 'e 'e fuli, 'ali Geregerena ala Taki gera gi li ka kwalaimoki 'alia alaana ba 'e sae 'uri 'e, ‘Gera barasi gwaugwau mola 'ada 'ali lau.’ ");
INSERT INTO lgl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Aloe 'are Abu kae la mae ma kae rana 'amiu. Ma 'i lia kae fatailia 'are kwalaimoki gi sulia God. Lakae kwatea mae 'i soemiu faasia Mama lau. Ala talasi kae la mae, 'i lia kae sae fakwalaimoki lau famiu. ");
INSERT INTO lgl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma 'i 'amiu lou 'amu ka sae fakwalaimoki suli lau, sulia gia io ruru fuli lo mae ala talasi lau fuli'ae ala galona lau li.” ");
INSERT INTO lgl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesus ka sae lou 'uri 'e, “Lakae ilia lo 'are 'e gi famiu, 'ali fitoona 'amiu ka nasi. ");
INSERT INTO lgl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Gera kae bolosi 'amiu faasia ruuna 'i laola luma fala foana gera gi li. Ma kae dao ala talasi la, ala ta ioli ka rauni 'amiu 'amu ka mae, 'i lia ka fia 'uria 'e taua 'are la God 'e oga. ");
INSERT INTO lgl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ioli fo gi, gera kae taua 'are fo gi amiu, sulia iko 'ali gera saiala Mama lau, ma iko 'ali gera sai lou agu. ");
INSERT INTO lgl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ma lau ilia lo 'agua 'are 'e gi famiu, 'ali ala talasi gera fuli'ae fala taunala 'are 'e gi amiu, 'amu ka malata tonala alaana ba lau ilida lo famiu gi.” Jesus ka sae lou 'uri 'e, “Iko 'ali lau ilia mae 'are 'e gi famiu 'i lao, sulia lau io 'ua fae 'amiu. ");
INSERT INTO lgl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ma ala talasi 'e, lau garani oli lo 'i so'ela God 'e 'e keri lau mae. Ka 'urifo wasua iko ta ioli amoulu 'ali soilidi lau 'ua sulia 'i fe 'e lakae la fai. ");
INSERT INTO lgl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ala talasi 'e, malatamiu 'e kwaimalatai rasua, sulia lau ilia lo 'are 'e gi famiu. ");
INSERT INTO lgl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ma la kae ilia 'are kwalaimoki famiu, 'e 'oka rasua famiu 'ali lau la faasi 'amiu 'urifo. Sulia ala ikoso 'ali lau la, Aloe 'are Abu 'e kae la mae fala rananamiu, ikoso la mola mae 'i soemiu. Ma talasi lakae la, lakae keria mae 'i soemiu. ");
INSERT INTO lgl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Talasi kae dao mae, 'i lia kae bulusia malatala ioli la molagali 'alia fatailinala rerona ala tau ta'ana li, rada na, ma kwaikwaina: ");
INSERT INTO lgl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ala gulagula ala tau ta'ana li, 'i osiala ioli iko 'ali gera fakwalaimoki agu; ");
INSERT INTO lgl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ala gulagula ala rada na li, sulia lakae la 'i soela Mama ma ikoso 'ali 'amu leesi lau lou; ");
INSERT INTO lgl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ma ala gulagula ala kwaikwaina li, sulia God 'e kwaia siu lo wale ta'a 'e 'ilitoa fafia molagali 'e li. ");
INSERT INTO lgl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Lau too 'ala 'are afula rasua gi fala ilinali famiu, wasua ma iko 'ali 'amu totolia rononali sui ala talasi 'e. ");
INSERT INTO lgl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wasua ma ala talasi Aloe 'are Abu kae dao mae, 'i lia kae faalalau 'amiu 'alia kwalaimokina, ma 'i lia kae fatailia 'are gi sui famiu. Ma 'i lia ikoso sae 'ala 'i talala, ma kae sae sulia 'are 'e ronoda faasia God gi. Ma 'i lia kae sae sulia 'are kae dao mae gi. ");
INSERT INTO lgl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","'I lia ka fa'ilitoa lau, sulia kae sakea alaana lau gi, ma ka faarono 'amiu 'alida. ");
INSERT INTO lgl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ma 'are Mama lau gi sui 'are lau gi lou. Lia ba laka ilia Aloe 'are Abu kae sakea alaana lau gi ma ka faarono 'amiu 'alida.” ");
INSERT INTO lgl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesus ka sae lou 'uri 'e, “Ala keme talasi dodoko lou, ikoso 'ali 'amu leesi lau lo. Sui ala keme talasi dodoko lou, 'amu kae leesi lau lou.” ");
INSERT INTO lgl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ma nali wale li galona lia gera ka soilidi matanadaulu kwailiu 'uri 'e, “Ta 'e malutala alaana 'e 'e ilia, ‘Ala talasi dodoko ikoso 'ali 'amu leesi lau, ma ala keme talasi dodoko lou, 'amu kae leesi lau lou?’ Ma ka ilia lou, ‘Ikoso moulu leesi lau sulia la kae la 'i so'ela Mama.’” ");
INSERT INTO lgl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma wale li galona lia gi gera ka soilidi kwailiu 'i matanada, “Ta 'e malutala me alaana 'e, ‘Ala talasi dodoko?’ Golu raria ta 'e 'e sae sulia.” ");
INSERT INTO lgl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sui Jesus ka saiai daulu oga daulu ka soilidia, ma ka sae 'uri 'e fadaulu, “Moulu malata sulia 'are ba lau ilia, ‘Ala talasi dodoko, ikoso 'ali moulu leesi lau. Ma ala keme talasi dodoko lou, moulu kae leesi lau lou.’ 'Uri'e ma me 'are fo fo 'amu kae soilidi 'amiu 'i talamiu sulia? ");
INSERT INTO lgl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","'Are kwalaimoki la kae ilia famoulu. Ala talasi fo, 'amu kae 'ofii ma 'amu kae aani. Wasua ma ioli ta'a ala molagali gi li, gera kae babalafe 'ada. 'Amu kae kwaimalatai, sui 'i burila kwaimalatainamiu kae sui, 'amu kae babalafe lou. ");
INSERT INTO lgl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","'Amu saiala talasi geli kae garani faafuta ai, 'i lia kae kwaimalatai, sulia 'e dao lo ala talasi ala rabefiina li. Wasua ma talasi 'e faafutaa wela ka sui lo li, kae bulono lo 'alia rabefiina ba, sulia 'e babalafe lo 'ala sulia wela lia 'e futa lo. ");
INSERT INTO lgl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","'I 'amiu 'amu 'urifo lou. Ala talasi 'e mola 'amu kae kwaimalatai. Ma lakae leesi 'amiu lou, ma 'i laola manomiu 'amu kae babalafe rasua. Ma babalafe na la iko ta ioli 'ali totolia kae laua lou faasi 'amiu. ");
INSERT INTO lgl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ala talasi fo, ikoso 'ali amu suga lau lo fala ta 'are lou. 'Are kwalaimoki lakae ilia famiu, ta 'are mola 'ala 'amu sugaa ala Mama 'i osiala 'i 'amiu wale li galona lau gi, 'i lia kae kwatea famiu. ");
INSERT INTO lgl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Fuli 'ua mae la la ka dao 'i tara'ela, iko 'ali 'amu suga suga 'ua 'urifo ala Mama lau. 'Amu ka sugaa Mama lau 'alia ratagu, 'i lia kae kwate 'amiu, 'ali babalafena 'amiu ka 'afu.” ");
INSERT INTO lgl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesus ka sae lou 'uri 'e, “Lau ilia 'are 'e gi famiu 'alia tarifulaana gi. Ma talasi kae dao mae ikoso 'ali lau sae lou 'alia tarifulaana gi, ma la kae sae madakwa mola 'agua sulia Mama famiu. ");
INSERT INTO lgl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ala talasi fo, 'amu kae talae sugaa God lo 'amiu osiala 'i 'amiu wale li galona lau gi. Ma laka ilia famiu lia ikoso 'ali lau suga lo fala ta 'are famiu. ");
INSERT INTO lgl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Kae 'urifo lo sulia Mama 'i talala 'e kwaima amiu, sulia 'amu kwaima aagu, dunala 'amu fakwalaimokia lia 'e 'i lia lo 'e keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","'I lao, lau la mae faasia Mama fala 'i laola molagali. Ma talasi 'e, la kae la lo faasia molagali, ma la kae oli lou 'i so'ela Mama lau.” ");
INSERT INTO lgl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'Urifo wale li galona lia gi gera ka sae 'uri 'e fala, “Ala talasi 'e bui 'o bi sae madakwa lo fameulu, sulia iko 'ali 'o sae lo 'alia tarifulaana gi. ");
INSERT INTO lgl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Talasi 'e, meulu bi saiai lia 'o saiala 'are gi sui, wasua ta ioli ikoso soilidi 'o wasua, 'o saiala ta lo 'i laola malatala. Ma lia 'e kwatea ma meulu ka fakwalaimoki lia God 'e keri 'o mae.” ");
INSERT INTO lgl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ma Jesus ka sae 'uri 'e fadaulu, “'Uri'e ma moulu fakwalaimoki nanata lo 'e? ");
INSERT INTO lgl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Talasii kae dao, 'amu kae tagalae sui faasi lau. Ma 'amu kae tafi fala falua 'amiu gi, sulia 'are gerakae taua agu. Wasua ma ikoso lau io talifili lau, sulia Mama 'e io fae lau. ");
INSERT INTO lgl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Lau ilia 'are 'e gi famiu, 'ali 'amu ka too ala babatoona 'i laola manomiu, sulia 'amu io 'ado fae lau. Wasua 'amu ka io 'i laola molagali ma gera kae malakwaita rasua amiu, ikoso 'ali 'amu mau, sulia lau liufia nanatana ala molagali 'e ka sui lo.” ");
INSERT INTO lgl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Talasi Jesus 'e sae 'urifo ka sui, ka lio ala ala fala 'i nali, ma ka sae 'uri 'e, “Mama, 'e dao lo ala talasi 'ali 'o fa'ilitoa Wela 'o li, 'ali 'i lia ka fa'ilitoa 'o lou. ");
INSERT INTO lgl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sulia 'o kwatea lo nanatana fagu fafia ioli gi sui, 'ali laka ranaa ioli 'e 'o kwateda fagu gi 'ali geraka mauri firi. ");
INSERT INTO lgl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma maurina firi 'e 'uri 'e: ioli gi gera ka saiamu teke God kwalaimoki, ma gera ka saiagu, Jesus Christ, lia 'o keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Lau fatailia lo 'ilitoana 'o 'i laola molagali, ma laka faasuia lo galona ba 'o keri lau mae fala taunali gi. ");
INSERT INTO lgl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Mama, talasi 'e, ko fa'ilitoa lau lou 'alia 'ilitoana ba lau too mae ai fae 'o, 'i laoala raunailinala molagali. ");
INSERT INTO lgl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Lau faalalau suli 'o fala ioli 'e 'o kwateda lo mae fagu 'i laola molagali 'e li. 'I gera lo ioli 'o gi, ma 'o kwateda lo mae fagu. Gera rono lo sulia saenamu. ");
INSERT INTO lgl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma talasi 'e, gera sai lo ala 'are gi sui lia 'o kwateda fagu, gera la sui mae faasi 'o. ");
INSERT INTO lgl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Lau ilia lo alaana ba 'o kwateda fagu gi fada, ma gera ka fakwalaimoki lo. Ma gera ka sai kwalaimoki lo ala lia lau la mae faasi 'o, ma gera ka fakwalaimoki ala lia 'e 'o keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Lau foa fada. Iko 'ali lau foa lou fala ioli 'e iko lou ioli 'o gi li, wasua ma lau foa 'agua fala ioli 'e 'o kwateda mae fagu gi, sulia 'i gera lo ioli 'o gi. ");
INSERT INTO lgl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ioli lau gi sui 'i gera ioli 'o gi lou. Ma ioli 'o gi sui, 'i gera ioli lau gi lou. Ma gera kae fatailia lo 'ilitoana lau 'alia ionada. ");
INSERT INTO lgl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ikoso lau io tekwa lo 'i laola molagali, lakae la lo ko 'i soemu. Wasua ma 'i gera gera kae io 'ua 'i laola molagali. Mama Abu, taki sulida 'alia nanata na ba 'o kwatea fagu, 'ali gera ka alua lo teke 'are, malaa lo lia 'e 'i gora teke 'are lou. ");
INSERT INTO lgl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ma talasi ba lau io failida, lau taki sulida 'alia nanatana ba 'o kwatea fagu. Lau golida, ma iko ta ioli ada 'ali'e fulu mola, talifilia mola wale ta'a ba Geregerena Abu 'e ilia lo kae fulu. ");
INSERT INTO lgl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Lakae la ko 'i soemu, ma laka ilia 'are 'e gi ala talasi lau io 'ua 'i laola molagali li, 'ali gera ka babalafe rasua malaa babalafena lau. ");
INSERT INTO lgl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma lau kwatea lo saenamu fada. Wasua ma ioli 'i laola molagali gi li lia iko lou ioli 'o gi li, gera malimae ada, sulia 'i gera ioli 'o gi, malaa lou lia 'e 'i lau wale 'o li. ");
INSERT INTO lgl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Iko 'ali lau suga 'o 'ali 'o lafuda faasia 'i laola molagali, ma lau suga 'o 'ali 'o taki sulida faasia Wale Ta'a. ");
INSERT INTO lgl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","'I gera iko lou ioli 'i fofola wado gi li, malaa lou lia 'e 'i lau iko lou wale 'i fofola wado li. ");
INSERT INTO lgl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","'O faa abuda famu 'alia kwalaimokina. Saenamu lo kwalaimokina. ");
INSERT INTO lgl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Lakae keri gera fala faalalaunala ioli gi, malaa lou lia 'e 'o keri lau mae fala 'i laola molagali li. ");
INSERT INTO lgl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma fala 'okanada, lau fa abu lau 'i talagu famu, 'ali 'i gera lou gera ka fa abu kwalaimoki ada 'i talada famu. ");
INSERT INTO lgl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ikoso lau foa mola fada talifili gera. Wasua ma lau foa lou fala ioli la gi gerakae fitoo agu sulia faronona gera gi. ");
INSERT INTO lgl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma lau foa 'ali gera ka alua teke 'are mola. Mama, gera ka io 'ado fae gora, malaa lou lia 'e 'o io agu, ma laka io amu. Gera ka alua lo teke 'are, 'ali ioli 'i laola molagali gi li gera ka fakwalaimoki ala lia 'e 'o keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Lau kwatea lo 'ilitoana ba 'o kwatea fagu fada, 'ali gera ka alua teke 'are, malaa lou lia 'e 'i gora teke 'are mola. ");
INSERT INTO lgl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Fadanala me 'are fo 'e 'uri 'e: Lakae io ada, ma ko io agu, 'ali 'i gera sui gera ka alua teke 'are mola, ma 'ali ioli 'i laola molagali gi li gera ka saiala lia 'e 'o keri lau mae, ma ko kwaima ada, malaa lou lia 'e 'o kwaima aagu. ");
INSERT INTO lgl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mama, lau oga ioli 'e 'o kwateda fagu gi, gera ka io fae lau ala lifi la lakae io ai, 'ali gera ka lesia lo 'ilitoana lau lia 'o kwatea fagu. 'O kwatea 'ilitoana 'e fagu, sulia 'o kwaima aagu 'i laoala raunailinala molagali. ");
INSERT INTO lgl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Mama, 'i'o wale ala radana li. Ioli ta'a 'i laola molagali gi li iko 'ali gera saiamu, wasua lau sai amu, failia waleli galona lau gi, gera saiala lia 'e 'o keri lau mae. ");
INSERT INTO lgl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Lau faarono gera lo 'ali 'o. Ma lau 'idufae tau mola 'agua ai, 'ali kwaimanaa 'o fagu ka io lou 'i laola maurinada, ma 'i lau wasua, laka io talau lou failida 'i laola maurinada.” ");
INSERT INTO lgl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","'I burila Jesus 'e foa ka sui lo, 'i lia failia wale li galona lia gi, daulu ka la ko, ma daulu ka tofolo ala dodo gera soia 'alia Kidron. Ma daulu laofia ko lifi la rakui 'ai gi ai. ");
INSERT INTO lgl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma Judas, wale fo kae foli'alia Jesus fala malimae lia gi li, 'e sai lo ala lifi fo. Sulia talasi afula Jesus failia wale li galona lia gi, daulu 'idufae la 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Lia fo Judas ka talaia ko wale li ofona faasia Rom gi failia wale gera lio folo galia Luma Abu God gi li. Fata abu ba'ela gi, failia Farasi gi gera kerida ko. Wale fo gera la mae gi, gera dau ala ulu gi, failia 'are fala kwalaana gi li. ");
INSERT INTO lgl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ma sulia Jesus 'e sai sui lo ala 'are kae dao ala gi, ka liu ko folosida, ma ka soilidida 'uri 'e, “Ite 'e 'amu kae lio 'afia?” ");
INSERT INTO lgl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Gera ka olisia 'uri 'e, “Meulu kae lio 'afia Jesus, wale ba faasia 'i Nasareti.” Ma Jesus ka sae 'uri 'e, “'I lau 'e lo.” Ma Judas wale ba 'e talaida ko 'i so'ela Jesus, lia 'e ura lou 'i lififo failida. ");
INSERT INTO lgl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ala talasi Jesus 'e sae 'uri 'e, “'I lau 'e lo,” wale fo gi gera dudu faeburi, ma gera ka toli 'i wado. ");
INSERT INTO lgl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sui Jesus ka soilidi gera lou 'uri 'e, “Ite 'e 'amu kae lio 'afia?” Ma gera ka sae lou 'uri 'e, “Meulu kae lio 'afia Jesus, wale ba faasia 'i Nasareti.” ");
INSERT INTO lgl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus ka sae 'uri 'e fada, “Lau ilia ka sui lo famoulu, ‘'I lau 'e lo.’ Sulia 'i lau lo moulu kae lio 'afi lau, 'urilali moulu ka lugasia wale 'e gi 'ali geraka la lo 'ada.” ");
INSERT INTO lgl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jesus ka ilia 'are fo 'ali ka fakwalaimokia 'are ba 'e ilia ka sui lo mae suli gera, lia ba 'e sae 'uri 'e, “Mama, iko ta wale ala wale ba lau 'o kwateda fagu gi 'ali fulu.” ");
INSERT INTO lgl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ma Simon Peter 'e too ala te 'au li ofona, 'e taraa, ma ka tofu 'alia, ma ka tofu mousia anina aolo ala te wale li galona 'ilito'ola fata abu li. Wale li galona fo ratala Malakas. ");
INSERT INTO lgl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma Jesus ka sae 'uri 'e fala Peter, “'O olifailia 'amua 'au li ofona laa 'i fulila! 'Uri'e ma 'o fia 'uria ikoso 'ali lau ruu 'i laola talasi ala famalifiina 'e Mama lau 'e kwatea fagu?” ");
INSERT INTO lgl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sui wale lio folo gi, failia wale ala ofona gi li, failia wale etaeta gi, gera daua Jesus, ma gera ka firi fafia rua limala. ");
INSERT INTO lgl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ma gera ka etae talaia ko Jesus 'i so'ela 'Anas, sulia 'i lia funo Kaeafas, 'ilito'ola fata abu ala fe nali fo li. ");
INSERT INTO lgl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ma Kaeafas ba 'e sae 'uri 'e fala wale etaeta gera Jiu gi li, “'E 'oka 'ali ta teke wale ka mae, 'ali ikoso gera raunia ioli gi sui.” ");
INSERT INTO lgl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter failia na wale li galona lou, daro ka la sulia Jesus. Ma ruala wale li galona, 'ilito'ola fata abu fo 'e sai 'oka ala. Ma ruala wale li galona ka dona buri lo ala Jesus, la la ka li io mae 'i laola labata ala luma 'ilito'ola fata abu li. ");
INSERT INTO lgl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peter 'e ura mola 'ala mae 'i maluma. Sui ruala wale li galona ka latafa, ma ka alaa fala geli fo 'e lio folo sulia mala 'olofolo li, 'ali ka talaia mae Peter 'i laola. ");
INSERT INTO lgl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ala talasi Peter kae ruu mae, geli fo ka sae 'uri 'e fala, “Mala 'i'o na wale lou ala wale li galona wale fo gera sakea mae tae ne!” Peter ka olisia ka sae 'uri 'e, “'I lau iko!” ");
INSERT INTO lgl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sulia talasi fo talasi ala gwarii li, lia wale li galona gi failia wale li lio folo gi, gera ka logosia dunae leleo, ma gera ka ura 'ada galia, ma Peter ka ura lou failida 'i lififo, ma ka rara lou 'ala failida. ");
INSERT INTO lgl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","'Ilito'ola fata abu ka soilidia Jesus 'uri 'e, “Ite ioli wale li galona 'o gi? Ma ta gi 'o faalalauda 'alia?” ");
INSERT INTO lgl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ma Jesus ka olisia 'uri 'e, “Lau alaa sulia 'are gi sui fala ioli gi 'ali gera ka ronoa sui. Iko 'ali lau faagwaa mola ta 'are, talasi lau faalalaua ioli gi li. Lau taua 'are fo ala atoa gi 'i laola luma fala foana gi li, ma 'i laola Luma Abu God 'i lifi'e, 'ali ala talasi ioli gi gera logo mae, gera ka ronoa. Ma iko 'ali lau sae agwaagwa mola 'alia ta 'are. ");
INSERT INTO lgl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","'Uta 'e ko soilidi lau 'uri la? 'O soilidia 'amua ioli 'e gera ronoa 'are 'e lau ilida fada gi. 'I gera lo gera saiala 'are lau ilida fada gi.” ");
INSERT INTO lgl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Talasi Jesus 'e sae mola 'urifo, te wale ala wale li lio folo gi ka la mae, ma ka fidalia, ma ka sae 'uri 'e, “'Uta 'e ko sae 'urila fala 'ilito'ola fata abu?” ");
INSERT INTO lgl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus ka olisia ko 'uri 'e, “Ala lau ilia ta 'are 'e rero, ko ilia ga 'are la lau rero ai. Ma ala iko 'ali lau ilia mola ta 'are rero, 'utaa ko fidali lau?” ");
INSERT INTO lgl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Buri 'ala 'are fo 'Anas ka kwatea lo ko Jesus 'i so'ela Kaeafas, 'ilito'ola fata abu. Ma limala gera firi 'ua fafia. ");
INSERT INTO lgl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma talasi Peter 'e ura, ma ka rarania 'ua 'ala rabela, ioli fo gera ura 'i lififo failia gera ka sae 'uri 'e fala, “'I'o na wale ala wale li galona wale 'e gera lokokwaikwaina fala tae?” Ma Peter 'e tofe, ma ka sae 'uri 'e, “Iko dadala, 'i lau iko!” ");
INSERT INTO lgl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ma te wale ala wale li galona 'ilito'ola fata abu ka io lou 'i lififo. Wale fo 'i lia walefae wale li galona ba Peter 'e tofu mousia aninala, ma ka sae 'uri 'e, “'Eo! Talasi ba gera daua Jesus 'i laola raku ba li, lau leesi 'o failia.” ");
INSERT INTO lgl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ma Peter ka sae 'uri 'e, “Iko! Iko lou 'i lau ba.” Ala talasi fo mola karai ka ani lo. ");
INSERT INTO lgl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ma 'i 'ofaedani, gera ka talaia ko Jesus faasia luma Kaeafas, gera ka talaia fala 'i laola luma Paelat, wale 'ilitoa ala lifi fo li. Talasi fo, wale etaeta Jiu gi li gera ura 'ada ko 'i maluma, sulia ala gera ruu 'i laola luma ioli iko lou Jiu li, gera fia 'uri gera kae 'uli'uli 'i maala God. Ala talasi fo, gera oga gera ka io kwaga maasia 'aninala Fanana ala Daofae Liu na li. ");
INSERT INTO lgl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ma Paelat ka latafa mae 'i soeda 'i maluma, ma ka soilidi 'uri 'e, “'Are 'utaa 'e 'amu suuafafia 'alia wale 'e fala lokomalatana ala?” ");
INSERT INTO lgl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Gera olisia gera ka sae 'uri 'e, “Wale 'e 'e taua 'are ta'a gi lia 'e 'ami ka talaia mae 'i soemu. Ala iko, 'e 'ato 'ami ka talaia mae 'i soemu.” ");
INSERT INTO lgl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Paelat ka sae 'uri 'e fada, “Ala 'e 'urilali, moulu talaia ko, 'amu ka lokokwaikwaina fala sulia ta lo taki 'amiu gi 'e ilia.” Gera ka sae 'uri 'e, “Taki 'amiu 'i Rom 'ami io 'i malula gi, gera luia ikoso 'ali 'ami raunia ta ioli.” ");
INSERT INTO lgl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","'E 'urifo, 'ali ka fakwalaimokia 'are ba Jesus 'e ilida ka sui lo sulia maenala gi. Sulia ioli faasia 'i Rom gi, gera raunia ioli gi ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Paelat ka oli lou fala 'i laola luma lia, ma ka soia mae Jesus 'i so'ela, ma ka soilidia 'uri 'e, “'Uri'e ma 'i'o 'e walelitalona ioli Jiu gi li?” ");
INSERT INTO lgl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma Jesus ka soilidia ko 'uri 'e, “'Uri'e ma Soilidina la 'e la mae fa'asi 'o 'i talamu, 'o ma tali ioli gera faarono 'o suli lau?” ");
INSERT INTO lgl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma Paelat ka sae lou 'uri 'e, “'I lau iko lou wale 'i Jiu 'e! Ioli 'o gi, failia fata abu ba'ela gi 'i talada 'e gera talai 'o mae 'i soegu. Ta ta ta'a 'e 'o taua?” ");
INSERT INTO lgl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ma Jesus ka olisia 'uri 'e, “'Ilitoana lau iko lou 'i laola molagali 'e. Ma ala 'ilitoana lau 'are 'i laola molagali li, ioli li galona lau gi gera ka kwalaa folosi lau faasia kwatenagu fala wale etaeta Jiu gi li. 'Ilitoana lau, iko lou 'are 'i laola molagali 'e li.” ");
INSERT INTO lgl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ma Paelat ka soilidia 'uri 'e, “'Uri'e ma 'i'o na walelitalona 'e?” Ma Jesus ka olisia 'uri 'e, “'I'o 'o ilia 'i lau walelitalona. Lau futa, ma laka dao mae 'i laola molagali 'e fala teke me 'are mola, 'ali laka sae sulia kwalaimokina. Ma ioli 'e oga kwalaimokina li, 'i lia kae rono suli lau.” ");
INSERT INTO lgl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Sui Paelat ka soilidia lou 'uri 'e, “'Uri'e ma ta kwalaimokina?” Ma Paelat ka oli lou 'i maluma 'i so'ela ioli fo gi, ma ka sae 'uri 'e fada, “Iko 'ali lau daria mola ta ta'ana ala wale 'e. ");
INSERT INTO lgl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Wasua ma sulia falafala 'amiu, lakae lugasia ta teke wale famiu ala talasi ala Fanana ala Daofae Liu na li. 'Uri'e ma 'amu oga laka lugasia walelitalona Jiu gi li famiu?” ");
INSERT INTO lgl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ma gera ka akwa ba'ela 'uri 'e, “Iko! Ikoso lugasia wale la! 'Ami oga ko lugasia mae Barabas!” Barabas na wale ala wale gera kwalaa failia ioli 'i Rom gi li. ");
INSERT INTO lgl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","'Urifo mola Paelat ka kwatea lo Jesus fala wale li ofona gi, ma ka ilia gera ka rabusia. ");
INSERT INTO lgl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma gera ka galofia te 'eregwau 'alia kwalo karakaraa, ma gera ka alua 'i gwaula Jesus. Sui gera ka faaruufia 'alia to'omi melamelaa bora, malaa na walelitalona. ");
INSERT INTO lgl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sui gera ka la mae 'i so'ela, ma gera ka fa oora 'uri 'e 'alia, “'I'o walelitalona ioli Jiu gi li.” Ma gera ka fidalia. ");
INSERT INTO lgl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma Paelat ka latafa lou ko 'i so'ela ioli afula fo gera logo gi, ka sae 'uri 'e, “Lakae sakea mae wale 'e 'i soemiu, 'ali 'amu ka saiai lia 'e iko 'ali lau daria mola ta ta'ana ala.” ");
INSERT INTO lgl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sui, Jesus ka latafa mae, ma ka rufia 'eregwau ala kwalo karakaraa li, failia to'omi melamelaa borabora. Ma Paelat ka sae 'uri 'e fada “'Amu lesia wale 'e!” ");
INSERT INTO lgl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ma talasi fata abu ba'ela gi, failia wale fo gera lio folo bolosia Luma Abu God gi li, gera lesia, gera bi akwa ba'ela lou 'uri 'e, “'O raunia! Fotoia ala 'ai rara folo!” Paelat ka sae 'uri 'e, “Ala 'e 'urila, 'amu sakea, ma 'amu ka fotoia ala 'ai rara folo. Sulia iko 'ali lau daria mola ta ta'ana ala.” ");
INSERT INTO lgl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ma ioli gi gera ka sae 'uri 'e fala Paelat, “Taki 'amami 'e ilia wale 'uri 'e ka mae, sulia 'e ilia 'i lia wela God.” ");
INSERT INTO lgl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Talasi Paelat 'e ronoa me 'are fo li, ka mau rasua liufia lo 'i lao. ");
INSERT INTO lgl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ma ka oli lou 'i luma ka soilidia Jesus 'uri 'e, “'I'o wale faasia 'i fe 'e?” Ma Jesus iko 'ali ilia mola ta 'are. ");
INSERT INTO lgl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Paelat ka sae lou 'uri 'e fala, “'Uri'e ma iko 'ali 'o oga mola alaana fae lau? Iko 'ali 'o sai mola ala lia 'e lau too ala nanatana fala ilinala 'ali gera ka lugasi 'o, 'o ma ala iko, gera ka rauni 'o ala 'ai rara folo?” ");
INSERT INTO lgl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus ka olisia ka sae 'uri 'e, “'E kwalaimoki 'o too ala nanatana 'ali ko tau 'urila agu. Wasua ma God mola 'e kwatea nanatana la famu. Lia fo wale 'e 'e kwate lau famu, 'i lia me ta'ana lia 'e ba'ela ka tasa liufia me ta'ana 'o.” ");
INSERT INTO lgl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ala talasi Paelat 'e ronoa saenala Jesus, ka lio 'afia ta matolaa 'ali ka tau 'ali ka lugasia. Wasua ma Jiu gi, gera akwa ba'ela gera ka rii 'uri 'e, “Ala 'o lugasia wale 'e, iko 'ali 'o kwaima failia walelitalona 'i Rom. Sulia ala ta wale 'e ilia 'i lia walelitalona, 'e sualia walelitalona 'i Rom.” ");
INSERT INTO lgl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Talasi Paelat 'e ronoa saena fo gi sui, ka talaia ko Jesus 'i maluma, ka gwauru ala lifi ala lokokwaikwaina li 'i laola tobi la gera soia 'alia “Gwelae fau,” ma saena Jiu gi li gera ilia 'alia “Gabata.” ");
INSERT INTO lgl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","'E dao lo totolala matoula fe atoa fala rerei na li 'i laoala Fanana ala Daofae liuna li. Ma Paelat ka sae 'uri 'e fala ioli gi, “'Amu lesia ga walelitalona 'amiu.” ");
INSERT INTO lgl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma ioli gi gera ka rii, geraka sae 'uri 'e, “Raunia! Raunia! Fotoia ala 'ai rara folo!” Paelat ka soilidida lou 'uri 'e, “'Uri'e ma 'amu oga lakae fotoia walelitalona 'amiu ala 'ai rara folo?” Ala talasi fo, fata abu ba'ela gi gera ka olisia 'uri 'e, “'I lia iko lou walelitalona 'amami. Talifilia walelitalona 'i Rom mola 'i lia 'e 'ilitoa 'amami!” ");
INSERT INTO lgl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ma Paelat ka kwatea Jesus fala wale li ofona gi, 'ali geraka fotoia ala 'ai rara folo. Ma gera ka talaia lo ko Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ma ka la ka awailia 'ai rara folo lia 'i talala fala lifi la gera soia 'alia 'i Golgota ala saena Hebru. (Fadanala ratala lifi fo “Tali Gwae Ioli.”) ");
INSERT INTO lgl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","'I lififo gera ka fotoia ala 'ai rara folo. Ma rua wale gi lou gera fotoida 'i lififo, na teke wale ala gula mauli ma na wale ala gula aolo, ma gera ka fotoia Jesus ala 'ai rara folo 'e ura 'i matanadaroa. ");
INSERT INTO lgl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ma Paelat ka gerea me alaana, ma gera ka alua 'i gwaula 'ai rara folo Jesus. Alaana fo 'e gerea gi gera 'uri 'e, “Jesus faasia 'i Nasareti, walelitalona Jiu gi li.” ");
INSERT INTO lgl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lifi fo gera alua 'ai rara folo fo gera fotoia Jesus ai, iko 'ali io tatau mola faasia 'i Jerusalem. Ioli afula Jiu gi li gera idumia alaana fo. Ma alaana fo gera ka gerea lou 'alia olu me saena mamata gi. Saena ioli Jiu gi li, saena ioli 'i Rom gi li, failia saena ioli 'i Gris gi li lou. ");
INSERT INTO lgl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ma fata abu ba'ela gi, gera ka sae 'uri 'e fala Paelat, “Ikoso gerea lou ‘Walelitalona Jiu gi li’! 'O gerea mola 'uri 'e, ‘'I lia 'ala 'i talala 'e sae 'uri 'e, 'i lau walelitalona ioli Jiu gi li.’” ");
INSERT INTO lgl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Sui Paelat ka olisida ka sae 'uri 'e, “Ta lau gerea ka sui lo, ka io lo 'ala 'urifo.” ");
INSERT INTO lgl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","'I burila wale li ofona gi gera fotoia Jesus ala 'ai rara folo ka sui, gera ka sakea toro lia gi, ma gera ka tolinia 'alia fai abae 'are gi totolia lou fai wale daulu gi. Ma to'omi fafi ba'ela lia, iko ta ladona ala tainai, ma gera tai laulau mola ai. ");
INSERT INTO lgl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ma wale li ofona gi gera ka sae 'uri 'e 'i safitada, “Ikoso 'ali golu gagasia fafuta'a lou to'omi 'e. Golu daisi fai, ite daisi 'e dao ala, 'i lia lo ka sakea.” 'E 'urifo 'ali ka fakwalaimokia Geregerena Abu ba 'e sae 'uri 'e, “Gera tolinia lo toro lau gi ada, ma gera ka daisi fala to'omi fafi ba'ela lau.” 'Are fo gi wale li ofona gi fo gera tauda. ");
INSERT INTO lgl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ma teite Jesus, failia ai geli fae teite Jesus, ma Mary wateu Klopas, failia Mary geli faasia 'i Magdala lia daulu ura 'i 'aela 'ai rara folo Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ma wale li galona ba Jesus 'e kwaima ala, 'e ura lou 'i lififo failia teite Jesus. Talasi Jesus 'e lesia teite lia failia wale li galona fo 'e kwaima ala daro ura garania, ka sae 'uri 'e fala teite lia, “Teite, wela wale 'o la lo.” ");
INSERT INTO lgl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sui, ka sae lou 'uri 'e fala wale li galona fo, “'A teite 'o la lo.” Ma ka fuli'ae ala tofui atoa fo, wale li galona fo ka talaia lo teite Jesus fala luma lia 'ali ka lio sulia. ");
INSERT INTO lgl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","'I burila 'are fo gi 'e sui, Jesus 'e saiai galona lia gi 'e sui tefau lo. Ma ka sae 'uri 'e, “Lau siligou” 'ali ka fakwalaimokia alaana 'i laola Geregerena Abu li. ");
INSERT INTO lgl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma ala lifi fo, gera alua te dako la 'e fonu 'alia waen 'afae. Ma gera sakea te lumulumui asi, ma gera ka saua 'i laola dakoe waen fo, sui gera ka alua 'i maala mae 'ai gera soia 'alia “hisop”, sui gera ka kwatea fala maala nidula Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ala talasi Jesus 'e goufia ka sui, ka sae 'uri 'e, “'E sui lo.” 'I burila 'e ilia saena fo gi ka sui mola, gwaula ka gwautoli lo, ma ka mae lo. ");
INSERT INTO lgl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","'I burila 'are fo gi sui, wale etaeta Jiu gi li gera la mae, ma gera ka soilidia Paelat 'ali 'e ala'alia fala wale li ofona gi geraka la, ma geraka 'oia lo 'aela olu wale fo gera fotoida ala 'ai rara folo gi li, 'ali geraka mae nainali. Sulia gera oga geraka lafua lo rabeda faasia 'ai rara folo gi ala fe atoa fo. Sulia fe atoa fo fe atoa fala rerei na Jiu gi li masia atoa ala Sabat li. Ma iko 'ali gera oga 'ali wale mae gi gera ka gegelo ala 'ai rara folo ala Sabat atoa ala mamalona li. Sulia Sabat fo atoa 'ilitoa Jiu gi li. ");
INSERT INTO lgl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ma wale li ofona gi gera la mae, gera ka 'oia 'aela rua wale ba gera fotoida ala 'ai rara folo gi li. ");
INSERT INTO lgl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Wasua ma talasi gera li dao ala Jesus, gera ka lesia 'e mae ka sui lo. Lia fo, iko 'ali gera 'oia mola 'aela Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sui ka 'urifo wasua 'ala, te wale adaulu lia 'e oga ka fakwalaimoki 'oka ai, 'e sakea mae suapata, ma ka gasia 'alia karaola Jesus. Ma gera ka lesia lo 'abu failia kwai ka afe tafa mae. ");
INSERT INTO lgl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Lau lesia me 'are fo, ma laka alaa sulia, 'ali 'i 'amiu sui 'amu ka fakwalaimoki lou. Me 'are 'e lau ilia 'e kwalaimoki, ma laka saiai saenagu 'e kwalaimoki lou. ");
INSERT INTO lgl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ma 'are 'e gi 'e 'urifo, 'ali fakwalaimokia Geregerena Abu ba 'e sae 'uri 'e, “Ta teke me suli wasua ala ikoso 'ali moo'oi mola.” ");
INSERT INTO lgl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma na gula Geregerena Abu lou 'e sae 'uri 'e, “Gerakae bubunia wale 'e gera gasia rabela.” ");
INSERT INTO lgl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","'I burila 'are fo gi, Josef wale faasia 'i Arimetea, 'e la mae ka sugaa Paelat fala rabela Jesus, 'ali geraka sakea. Josef na wale ala wale li galona Jesus gi lou, wasua ma 'e agwa sulia 'e mau 'alia wale etaeta Jiu gi li. 'Urifo Paelat ka ala'alia, ma Joseph ka la ka sakea lo. ");
INSERT INTO lgl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ma Nikodimas ba 'e la la 'i so'ela Jesus 'i laola boni li 'i lao 'e la lou failia Josef, ma ka sakea olu akwala kilo ala 'are si'ina 'oka gi fala alunai failia rabela ioli mae. Ratala 'are fo “mira” failia “alos.” ");
INSERT INTO lgl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Rua wale fo gi, daro ka sakea rabela Jesus, ma daro ka buta 'alia 'aba toro kaka'a 'oka failia 'are si'ina 'oka fo gi. Daro taua 'are fo sulia falafala Jiu gi li fala rerei na 'alia ioli mae gi fala alunala 'i laola bao. ");
INSERT INTO lgl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ma te raku 'e io garania lifi fo gera raunia Jesus ai. Ma te bao fala alunala rabela ioli mae gi li 'e io lou ala lifi fo. Ma bao fo 'are fa'alu mola 'ala, iko 'ali gera alua 'ua ta ioli 'i laola. ");
INSERT INTO lgl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ma ala talasi fo fe atoa gera Jiu gi li fala rerei na masia Sabat atoa ala mamalona li. Ma fe atoa Sabat 'e garani lo. Ma rua wale fo gi, daro la, daro ka alua rabela Jesus 'i laola bao fo, sulia 'e io garani mola. ");
INSERT INTO lgl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'I 'ofaedani ala Sade talasi gogolafae 'ua, Mary faasia 'i Magdala ka la 'i maala bao, ma ka lesia fau ba gera alua bolosia maala, 'e 'idu lo. ");
INSERT INTO lgl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ma ka lalao nainali 'i so'ela Simon Peter, failia wale li galona ba Jesus 'e kwaima ala, ma ka sae 'uri 'e fadaroa, “Tali ioli gera sakea lo rabela Aofia faasia bao ba, ma meulu raria 'i fe lo gera alua ai.” ");
INSERT INTO lgl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sui Peter failia wale li galona fo daro ka la lo fala bao fo. ");
INSERT INTO lgl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ma daro ka lalao sui, ma wale li galona fo 'e lalao nainali ka liufia Peter, ma ka etae li dao 'i maala bao 'i lao. ");
INSERT INTO lgl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ma ka 'adaoro, ka lesia toro kaka'a ba gi sui, ma iko 'ali ruu mola 'i laola bao. ");
INSERT INTO lgl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ma Simon Peter ka dao mae 'i buri, ka dao tarosi lo fala 'i laola bao fo. Ka lesia toro kaka'a ba gi gera teo mola 'ali 'i fulida, ");
INSERT INTO lgl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","failia 'aba toro ba gera butaa 'alia gwaula Jesus. Ma 'aba toro fo iko 'ali teo mola failia 'aba toro kaka'a fo gi, ma 'e molimolia 'ala, ma ka teo lo 'ala talifilia. ");
INSERT INTO lgl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Talasi fo bui wale 'e etae dao maala bao li ka bi ruu lou ko 'i laola. 'E lesia, ma ka fakwalaimoki lo. ");
INSERT INTO lgl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma iko daro sai 'ua ala Geregerena Abu ba 'e ilia kae mauri lou faasia maena li. ");
INSERT INTO lgl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","'I burila 'are fo, rua wale li galona fo gi, daro ka oli lo 'adaroa. ");
INSERT INTO lgl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma Mary ka ura 'ua 'i maala bao, ma ka ani mola 'ala. Ma ala talasi kae ani 'ala, 'e 'adaoro ka lio ko 'i laola bao ");
INSERT INTO lgl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma ka lesia rua eniselo gi, daro rufia toro kaka'a gi. Ma rua eniselo fo gi, daro gwauru ala lifi fo rabela Jesus 'e teo teo ai 'i lao, na ai ala lifi la gwaula 'e ioio ai, ma na ai ala lifi la 'a'aela 'e ioio ai. ");
INSERT INTO lgl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Rua eniselo fo gi, daro ka soilidi 'uri 'e ala Mary, “Geli 'e, ta koe anisia?” Ma ka olisidaroa 'uri 'e, “Rabela Aofia lau gera sakea faasia 'i lifi'e, ma lau raria 'i fe lo gera alua ai.” ");
INSERT INTO lgl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","'I burila 'e sae 'urifo ka sui, ka bulusi, ma ka lesia te wale 'e ura mola 'ala, ma iko 'ali lio raea mola lia fo wale fo 'i lia Jesus. ");
INSERT INTO lgl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma Jesus ka soilidia 'uri 'e, “Geli 'e, 'utaa 'e ko ani? Ma ite 'e koe lio 'afia?” Ma Mary ka fia 'uria 'i lia wale 'e lio sulia raku fo li. Ma ka sae 'uri 'e fala, “Arai, ala 'o sakea rabela Aofia lau, lau oga ko faarono lau 'alia 'i fe lo 'o alua ai, 'ali lau la laka sakea.” ");
INSERT INTO lgl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sui, Jesus ka sae 'uri 'e fala, “Mary!” Ma Mary ka bulusi, ma ka lio ko, ka lio raea, ma ka sae 'uri 'e fala, “Raboni!” Me saena fo “Raboni” ala saena Hebru gi li fadanai “Waleli Falalauna.” ");
INSERT INTO lgl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ma Jesus ka sae 'uri 'e fala, “'O ala dauna tonagu, sulia iko 'ali lau oli 'ua 'i so'ela Mama 'i nali. 'O oli 'i so'ela walefae lau gi, ma ko farono daulu, lakae la lo 'i so'ela Mama lau, ma Mama 'amiu. 'I lia God lau, ma God 'amiu.” ");
INSERT INTO lgl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sui Mary faasia 'i Magdala ka oli, ma ka faronoa wale li galona gi lia fo 'e lesia Aofia li. Ma Mary ka alaa lou fadaulu sulia 'are fo Jesus 'e ilida fala gi. ");
INSERT INTO lgl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ma 'i raurafi ala Sade, wale li galona gi gera logo 'i laola te luma, ma daulu ka folo bolosia maala 'olofolo gi. Ma daulu ka gwaa bolosia lou maala 'olofolo gi, sulia daulu mau 'alia wale etaeta ala ioli Jiu gi li. Ma Jesus ka fatae, ma ka ura 'i safitadaulu, ma ka sae 'uri 'e, “Aroarona ka io fae 'amiu.” ");
INSERT INTO lgl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","'I burila 'e ilia me saena fo, ka fatailia lo rua limalimala failia karaola fadaulu. Ma wale li galona gi daulu ka babalafe rasua ala talasi daulu lesia Aofia ai. ");
INSERT INTO lgl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma Jesus ka sae lou 'uri 'e fadaulu, “Aroarona ka io fae 'amiu. Malaa lou lia ba Mama 'e keri lau mae, lau keri 'amiu lou.” ");
INSERT INTO lgl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jesus 'e ilia alaana fo, sui ka manofi daulu, ma ka sae 'uri 'e, “Moulu sakea Aloe 'are Abu. ");
INSERT INTO lgl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ala 'amu ka kwailufa 'alia ta'ana ioli gi li, God kae kwailufa lou 'alida, ma ta'ana gera gi kae sigi lo faasida. Ma ala iko 'ali 'amu kwailufa ada, God wasua ikoso kwailufa lou ada, ma ta'ana gera gi wasua ikoso sigi lou faasida.” ");
INSERT INTO lgl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma te wale ala akwala wala rua wale li galona fo gi li ratala Tomas lia gera soia lou 'alia 'I'iu, iko 'ali 'e io failida ala talasi fo Jesus 'e dao ai. ");
INSERT INTO lgl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ma wale li galona gera io gi, gera ka sae 'uri 'e fala Tomas, “Meulu lesia lo Aofia.” Sui Tomas ka sae 'uri 'e fadaulu, “Ala laka lesia kwana ba 'i fulila nila gi li 'i limala, ma laka dau tonala kwana fo gi 'alia limagu, ma laka alua limagu 'i laola fulila mae malaa ba 'i karaola lo, laka bi fakwalaimoki. Ma ala iko 'ali lau tau mola 'urifo, ikoso lau fakwalaimokia mola.” ");
INSERT INTO lgl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ma ala fiula fe atoa 'i buri, wale li galona gi gera logo ruru 'i laola luma ba, ma Tomas ka io lou failida. Ma gera ka gwaa lou bolosia mala 'olofolo gi. Sui Jesus ka fatae mae, ma ka ura 'i safitadaulu, ma ka sae 'uri 'e, “Aroarona ka io fae 'amiu.” ");
INSERT INTO lgl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","'Urifo Jesus ka sae 'uri 'e fala Tomas, “Tomas, 'o alua 'u'umu 'i lifi'e 'i laola limagu, ma ko lesia lou rua limagu. Sui ko tadaa mae limamu, ma ko alua limamu 'i laola fulila mae malaa 'e 'i karaogu. Ikoso malata ruarua, ko fakwalaimoki!” ");
INSERT INTO lgl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ma Tomas ka olisia 'uri 'e, “'I'o Aofia lau, ma God lau.” ");
INSERT INTO lgl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma Jesus ka sae 'uri 'e fala, “'O fakwalaimoki mola sulia 'o leesi lau. 'Oilakina fala ioli iko 'ali gera leesi lau, wasua ma gera fakwalaimoki mola 'ada agu gi.” ");
INSERT INTO lgl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","'Are mama'ala afula gi Jesus 'e tauda lou 'i maala wale li galona lia gi, wasua ma iko 'ali lau gereda mola 'i laola buka 'e. ");
INSERT INTO lgl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Lau gerea 'are 'e gi, 'ali 'amu ka fakwalaimokia Jesus lo Christ, wale ba God 'e filia fala rananala ioli gi li, ma 'i lia lo Wela God. Ma 'i osiala fitoona 'amiu ala Jesus, 'amu kae too ala maurina firi. ");
INSERT INTO lgl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","'I burila 'are fo, Jesus ka fatae lou fala wale li galona lia gi 'i rabela 'osi 'i Galili. Ma 'are fo 'e fuli 'uri 'e: ");
INSERT INTO lgl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter, ma Tomas gera soia 'alia 'I'iu, ma Nataniel wale faasia 'i Kena 'i laola provins 'i Galili, failia rua wela Sebedi gi, ma na rua wale li galona lou, daulu logo. ");
INSERT INTO lgl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ma Simon Peter ka sae 'uri 'e fala alae wale fo, “Lakae lai kwaiasi lou.” Ma daulu ka olisia 'uri 'e, “Meulu oga meulu ka la lou fae 'o.” Ma daulu ka la, daulu ka taefia lo baru. Ma ala fe boni fo, iko 'ali daulu tafoa mola ta me lode ia. ");
INSERT INTO lgl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ma 'ofaedani talasi 'e dani lo, Jesus ka ura 'i rabela 'osi. Ma wale li galona lia gi, iko 'ali daulu lio raea mola. ");
INSERT INTO lgl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sui Jesus ka sae ko fadaulu 'uri 'e, “Alae kwaima lau, moulu tafoa ta me ia?” Ma daulu ka olisia 'uri 'e, “Iko mola!” ");
INSERT INTO lgl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma 'i lia ka sae 'uri 'e, “Moulu aala 'alia fuo 'amoulu 'i gula aolo ala baru, 'ali moulu tafoa tali lode ia.” Ma daulu ka aala 'alia fuo, ma ka 'ato rasua lo fala lafunai mae, sulia ia 'e afula rasua lo 'i laola. ");
INSERT INTO lgl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sui wale li galona ba Jesus 'e kwaima ala, ka sae 'uri 'e fala Peter, “Aofia lo fo!” Ma talasi Simon Peter 'e ronoa me 'are fo li, ka ruufia to'omi tekwa lia, sulia 'e kalasua, ma ka lofo 'i laola asi, ma ka olo olo lo fala 'i rara. ");
INSERT INTO lgl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma wale li galona gi daulu ka la lo mae 'i rara 'alia baru. Ma daulu ka taraa lo mae fuo lia 'e fonu 'alia ia, sulia 'e iko 'ali daulu io tatau mola faasia 'i rara, ka totolia mola 'ala teke talanae fe alu 'ae na. ");
INSERT INTO lgl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ma talasi daulu sifo 'i rara, daulu ka lesia te dunae leleo failia ia gi 'i laola failia tofui berete gi lou. ");
INSERT INTO lgl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma Jesus ka sae 'uri 'e fadaulu, “Moulu sakea mae tali lode ia ala ia la moulu tafoda gi.” ");
INSERT INTO lgl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter ka la ko 'i laola baru, ma ka tara mae fuo fo 'i rara. Fuo fo 'e fonu 'alia ia ba'ela gi sui mola, teke talanae wala lima akwala ma olu lode ia. Wasua ia ka afula 'ala 'urifo 'i laola fuo fo, iko 'ali gaga mola. ");
INSERT INTO lgl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ma Jesus ka sae 'uri 'e fadaulu, “Moulu la mae, moulu ka fana 'amoulu.” Wasua iko ta wale adaulu 'ali soilidi mola 'uri 'e, “'I'o ite 'e?” Sulia daulu sai mola 'adaulu ai 'i lia Aofia. ");
INSERT INTO lgl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ma Jesus ka la ko ka sakea berete, ma ka kwatea fala wale li galona lia gi, ma ka tau lou 'urifo ala lode ia gi. ");
INSERT INTO lgl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ma olula talasi Jesus 'e fatae fala wale li galona lia gi 'i burila 'e tatae faasia maena li lo fo. ");
INSERT INTO lgl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ma talasi daulu fana ka sui lo, Jesus ka sae 'uri 'e fala Simon Peter, “Simon wela John 'o kwaima aagu, ka liufia kwaimaana wale li galona 'e gi gera too ai fagu?” Ma Peter ka olisi 'uri 'e ala, “'Eo, Aofia. 'O sai mola 'amua ai lau kwaima amu.” Ma Jesus ka sae 'uri 'e fala, “'O lio sulia kale sipsip lau gi.” ");
INSERT INTO lgl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ma Jesus ka sae lou 'uri 'e fala ruala me talasi, “Simon wela John, 'o kwaima aagu?” Ma Peter ka olisia 'uri 'e, “'Eo, Aofia. 'O sai mola 'amua ala lia 'e lau kwaima amu.” Sui Jesus ka sae 'uri 'e fala, “'O lio sulia sipsip lau gi.” ");
INSERT INTO lgl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ma Jesus ka sae lou 'uri 'e ala olula me talasi, “Simon wela John, 'o kwaima aagu?” Ma Peter ka kwaimalatai, sulia Jesus 'e soilidi olula talasi lo ala 'uri 'e, “'Uri'e ma 'o kwaima aagu 'e?” Ma Peter ka sae 'uri 'e fala, “Aofia, 'o sai ala 'are gi sui, ma ko sai mola 'amua ala lia 'e lau kwaima amu.” Ma Jesus ka sae 'uri 'e fala, “'O lio sulia sipsip lau gi. ");
INSERT INTO lgl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","'Are kwalaimoki la kae ilia famu, talasi 'o ulufa'alu ai, 'o toro 'amua 'i talamu, ma ko la 'amua 'i talamu ala lifi 'o oga laa na ai gi. Ma ala talasi koe waro, koe tadaa limamu, ma ta ioli mamata lo kae faruufi 'o, ma ka talai 'o fala lifi la iko 'ali 'o oga laa na ai.” ");
INSERT INTO lgl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus 'e ilia me 'are fo, 'ali fatailia maena Peter kae mae 'alia, ma kae fa'ilitoa God 'alia. Sui Jesus ka sae 'uri 'e fala, “'O ali buri lau.” ");
INSERT INTO lgl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ma Peter ka bulusi, ma ka lesia wale li galona ba Jesus 'e kwaima ala. ('I lia wale ba 'e gwauru garania Jesus ala talasi daulu fana ai li, ma ka soilidia 'uri 'e, “Aofia, ite kae foli 'ali 'o, ma ka kwate 'o fala malimae 'o gi?”) ");
INSERT INTO lgl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","'Urifo ala talasi Peter 'e lesia, ka soilidia Jesus 'uri 'e, “Aofia, uta ala wale 'e?” ");
INSERT INTO lgl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus ka olisia 'uri 'e, “Suli ala laka oga wale 'e kae mauri 'ala, la la ka li dao ala talasi lakae oli mae ai, 'e iko lou ta me 'aberona 'o fo. Ma 'o dona buri lau.” ");
INSERT INTO lgl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Alaana fo ka talo lo 'i matanala wale li galona Jesus gi. Gera ilia wale li galona fo ikoso 'ali mae. Ma Jesus iko 'ali ilia 'uri wale fo ikoso mae. 'E sae 'ala 'uri 'e ba, “Suli ala laka oga wale 'e kae mauri 'ala, la la ka li dao ala talasi lakae oli mae ai, iko lou 'aberona 'o fo.” ");
INSERT INTO lgl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ma wale li galona fo Peter 'e soilidia Jesus sulia, 'i lia lo 'e alaa sulia 'are 'e gi sui, ma ka gerea. Ma meulu saiala 'are 'e sae sulia, 'e kwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus 'e taua 'are afula rasua gi lou. Ma ala gera ka geregere sulida sui, lau fia mala molagali 'e wasua, ikoso totolia 'ali dau fafia buka gera kae gerea 'are fo gi 'i laola. ");
INSERT INTO lgl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Famu Tiofilas 'i laola etala geregerena ba lau famu, lau geregere sulia 'are Jesus 'e tauda gi sui, ma ka faalalau 'alida, ");
INSERT INTO lgl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","la la ka dao ala fe atoa ba God 'e sakea fala 'i nali. 'I laoala ka bi rae fala 'i nali, 'e kwatea alaana 'ilitoa gi 'alia Aloe 'are Abu fala wale 'e filida 'ali gera ka lifurono 'ala gi. ");
INSERT INTO lgl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ma sulia fai akwala fe atoa gi 'i burila maenala, ala talasi afula gi 'e fatae lia 'i talala fala wale li lifurono gi, ma ka fulia 'are gi, 'ali ka fakwalaimokia lia 'e mauri. Gera ka lesia, ma ka alaa failida sulia falafala God fala 'ilitoanala fafia ioli lia gi li. ");
INSERT INTO lgl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma ala na talasi ala logona gera failia Jesus, 'i lia ka kwatea kwaikaena 'uri 'e, “Ikoso moulu la faasia 'i Jerusalem. 'Amu ka maasia kwatena ba Mama lau 'e etae alafu 'alia. 'Amu ronoa lau sae lo mae sulia 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","‘John 'e fasiuabua mola ioli 'alia kwai, ma ikoso 'ali tekwa mola God kae fasiu abu 'amiu 'alia Aloe 'are Abu.’” ");
INSERT INTO lgl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ma talasi lifurono gi gera logo lou failia Jesus, gera ka soilidia 'uri 'e, “Aofia 'uri 'e ma, talasi 'e lo koe ofotailia tatalona 'i Rom, ma koe olifailia tatalona ba famami ioli 'i Israel gi?” ");
INSERT INTO lgl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma Jesus ka olisi 'uri 'e adaulu, “Iko lou ta me 'are famiu 'ali 'amu saiai fe atoa gi failia talasi 'urifo gi, sulia Mama lau 'e alua sui lo talasi 'ali 'are 'e gi kae fuli ai. ");
INSERT INTO lgl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wasua ma 'i 'amoulu, talasi Aloe 'are Abu kae dao mae fafi 'amoulu, 'amu kae too ala nanata na. Ma 'amu kae alaa suli lau 'i lifi'e 'i Jerusalem, ma ala falua gi sui 'i Judea ma 'i Samaria, ma ka dao ala falua gi sui 'i laola molagali.” ");
INSERT INTO lgl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","'I burila 'e ilia 'are fo gi sui, God ka sakea lo fala 'i nali. Ma talasi gera bubu aala aala mola 'ada 'ua, te dasa ka bolosia, ma iko 'ali gera lesia lo. ");
INSERT INTO lgl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma talasi gera bubu tootoo aala aala mola 'ada fala 'i nali fala lesinala ala talasi fo kae rae lo, gera tooraa ma te rua wale daro toro 'alia to'omi kaka'a gi li, daro ka ura lo failida. ");
INSERT INTO lgl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma daro ka soilidi 'uri 'e ada “'I 'amoulu wale 'e 'i Galili gi, 'utaa 'e moulu ka ura mola 'amoulu 'uri 'e 'i lifi'e, ma moulu ka lio ala ala mola 'amoulu fala 'i laola raloo? Jesus 'e God 'e sakea faasia 'amoulu fala 'i nali, 'i lia kae oli lou mae, malaa lou 'amu lesia 'e rae fala 'i nali.” ");
INSERT INTO lgl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sui wale li lifurono gi, gera ka oli fala 'i Jerusalem faasia gwaula fe uo fo gera soia 'alia Olif, lia 'e totolia teke tofui tala faasia 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ma talasi gera dao lo 'i Jerusalem, gera ka rae fala mae tobi gera io ai 'i nali. Ma ratala wale fo gi: Peter, John, James, Andrew, Filip, Tomas, Batolomiu, Matthew, James wela Alfeas, Simon na wale ala wale ba gera oga balinala ioli 'i Rom gi faasia 'i Israel, ma Judas wela James. ");
INSERT INTO lgl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ma gera 'idufae logo 'urifo 'alia teke lioe wale fala foana lia gera taua ala talasi gi failia nali geli lou, ma Mary teite Jesus, failia walefae Jesus gi. ");
INSERT INTO lgl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ma ala na talasi gera logo 'i lifi fo, teke talanae wala rua akwala ioli fakwalaimoki gi gera logo mae. Ma Peter ka tatae ka sae 'uri 'e fada, ");
INSERT INTO lgl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Alae walefae lau Geregerena Abu sulia Judas 'e fuli kwalaimoki lo, sulia Aloe 'are Abu ba 'e sae 'alia David sulia Judas. Jesus ba 'e filia lou Judas, 'ali 'i lia na teke wale agaulu fala taunala galona 'e fala lifurono na li, wasua ma Judas ba 'e talaia wale gi fala doinala Jesus.” ");
INSERT INTO lgl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","('Urifo Judas ka sakea seleni ba gera folia 'alia ka kwatea Jesus, ma ka folia 'alia tofui wado. Ma 'i laola wado fo, 'e toli, ma ogala ka fogaa, ma ogala ka busu tafa lo 'i maluma. ");
INSERT INTO lgl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ma wale gera io 'i Jerusalem gi, gera ka ronoa me 'are 'e fuli ala Judas, ma gera ka soia wado fo 'alia saena gera “Akeldama.” Fadanala me saena fo “Wado Ala 'Abu li.”) ");
INSERT INTO lgl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ma Peter ka alaa lou 'uri 'e, “Me 'are 'e 'e fuli lo malaa ba gera gerea 'i laola buka Sam gi li 'uri 'e, ‘Luma lia 'e gwau, ma iko ta wale 'ali io 'i laola.’ Ma na geregerena lou ba 'e sae 'uri 'e, ‘'E 'oka 'ali ta wale ka dedefulila, 'ali ka sakea galona ba lia.’ ");
INSERT INTO lgl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“'Arela fo 'e 'oka 'ali golu filia lou ta wale 'ali 'e galo ruru lou fae 'ameulu lifurono gi fala alaana sulia tataenala Aofia Jesus faasia maena. Wale 'e golukae filia, 'i lia ta wale lo ala logonae ioli ba gera liu liu ruru fae golu ala talasi ba Jesus 'e io 'ua fae golu, fuli mae ala talasi ba John fasiuabua Jesus, la la ka dao ala fe atoa ba God 'e sakea lo Jesus faasi golu fala 'i nali ai.” ");
INSERT INTO lgl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ma gera ka filia rua wale gi. Ma ratala na wale Josef, lia gera soia 'alia Barsabas, ma gera ka soia lou 'alia Justus. Ma ratala ruala wale Mataeas. ");
INSERT INTO lgl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","'Urifo gera ka foa 'uri 'e, “Aofia, 'i'o tae 'o saiala malatala ioli gi sui. 'O fatailia mae fameulu ala talasi 'e ite ala rua wale 'e gi lo 'o filia, ");
INSERT INTO lgl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","'ali 'e sakea galona 'e ala lifuronona li lia ba Judas 'e taasi 'alia, ma ka la lo 'ala fala lifi 'e totolia ka io ai.” ");
INSERT INTO lgl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","'I burila gera foa sui, gera ka none 'alia 'are malaa daisi li, 'ali geraka daria ite ala rua wale fo gi lo God 'e filia, ma gera ka filia Mataeas, 'ali ka galo failia akwala wala teke wale li lifurono fo gi. ");
INSERT INTO lgl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Fe atoa ba'ela Jiu gi gera soia 'alia Pentekos 'e dao lo mae, ma ioli gera fakwalaimoki gi, gera logo ala te lifi 'i laola falua ba'ela 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ma toraa wasua te line 'are malaa oru ba'ela li, 'e sifo mae faasia 'i nali, ma ka fonulia lo luma fo gera io ai. ");
INSERT INTO lgl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma gera ka lesia 'are malaa meamea ala dunaa gi li, ma 'are fo ka tagalae ma ka dau 'i fafia ioli gera io 'i lififo gi li sui. ");
INSERT INTO lgl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma Aloe 'are Abu ka sura ada sui, ma gera ka fuli'aea saena 'alia alaana mamata gi li, lia Aloe 'are Abu 'e fasae gera 'alida. ");
INSERT INTO lgl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ma talasi fo, wale 'i Jiu gi lia gera foasia God, gera io lou 'i Jerusalem. Gera la mae faasia mae falua tootoo ba'ela gi 'i laola molagali. ");
INSERT INTO lgl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma talasi gera ronoa line 'are fo li, ioli afula gi gera ka logo. Ma gera ka 'afero rasua, dunala ioli fakwalaimoki gi gera alaa 'alia me saena tootoo gera gi sui. ");
INSERT INTO lgl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ma sulia gera 'afero rasua, gera ka sae 'uri 'e 'i matanada 'i talada, “Wale 'e gera alaa 'uri 'e gi, 'i gera wale 'i Galili gi sui mola. ");
INSERT INTO lgl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma 'utaa 'e 'ami ka ronoa gera alaa 'alia saena 'amami gi? ");
INSERT INTO lgl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sulia 'ami la mae faasia falua 'i Partia, ma 'i Media, ma 'i Elam, ma 'i Mesopotemia, ma Judea, ma 'i Kapadosia, ma 'i Pontus, ma 'i Asia, ");
INSERT INTO lgl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma faasia 'i Frigia, ma 'i Pamfilia, ma 'i Ejipt, ma faasia falua gi 'i Libia garania 'i Saeren, ma nali wale 'ami la mae faasia 'i Rom. (Ma nali ai ameulu 'i gera ioli Jiu gi, ma nali ai ameulu gera bi ruu mola mae 'ali Jiu na 'i buri.) ");
INSERT INTO lgl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ma nali ioli gera la mae faasia 'i Krit, ma faasia 'i Arabia, ma gia ronoa lia wale 'e gi gera sae sulia 'are li 'aferona 'alia gi lia God 'e tauda, ma gia ka rono raea alaana gera gi 'alia saena kwalaimoki gia gi 'i talaga!” ");
INSERT INTO lgl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Gera ka kwele rasua, ma gera raria 'are fo gera lesia. Ma gera ka soilidi gera 'i talada 'uri 'e, “Ta lo 'e 'uri 'e wani?” ");
INSERT INTO lgl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma nali wale ada gera ka dorakwala 'uri 'e, “'Uri 'e wasua mala gera goufia rasua lo ala waen li tae 'e, ma gwauda ka lulumui.” ");
INSERT INTO lgl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sui Peter ka ura failia akwala wala teke wale li lifurono fo gi, ma ka sae ba'ela fala logona fo 'uri 'e, “'Amiu nali asigu ioli Jiu lau gi, ma 'i 'amiu ioli 'e 'amu io 'i Jerusalem gi, 'amu fafurono ga mae fagu, 'ali lau faarono 'amiu 'alia malutala 'are 'e. ");
INSERT INTO lgl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ioli 'e gi iko 'ali gera kwekwe'ela 'alia goufinala waeni, malaa lia 'e 'amu malataia. Sulia 'e bi dao mola ala sikwaala tofui matola 'i rafule. ");
INSERT INTO lgl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma 'are 'e ba profet Joel 'e sae lo mae sulia 'ualo 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God 'e sae 'uri 'e, Ala atoa fafu'isi gi, lakae kwate gwaugwau ala Aloe 'are Abu lau fala ioli lau gi sui. Ma ulufa'alu 'amiu gi, failia ulao 'amiu gi, gerakae faarono 'alia saenagu. Ma ulufa'alu 'amiu gi gerakae lesia fatae na gi, ma wale waro 'amiu gi gerakae lesia 'are gi 'alia mo'osu bolena gera gi. ");
INSERT INTO lgl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ala talasi fo, lakae kwatea lou Aloe 'are Abu lau fala ioli lau gi lia gera galo gwaugwau ma geraka fakwalaimoki, 'ali 'i gera lou geraka faarono 'alia saenagu. ");
INSERT INTO lgl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma lakae fulia 'are li 'aferona 'alida gi 'i laola raloo 'i nali, ma la kae taua 'are mama'ala gi 'i wado 'i laola molagali. 'I laola molagali ioli gi gerakae lesia ioli gi kae mae, failia dunaa, failia rasu gi. ");
INSERT INTO lgl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ma 'i nali ioli gi gerakae lesia da'afi kae rodo, ma madama kae melamelaa malaa 'abuu. 'Urifo ka sui bui fe atoa 'ilitoa rasua fo ka bi dao mae, lia God kae lokokwaikwaina fala ioli gi sui. ");
INSERT INTO lgl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ite kae suga 'afia kwairanaina ala Aofia, 'i lia kae mauri.’” ");
INSERT INTO lgl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ma Peter ka sae lou 'uri 'e, “'Amiu wale 'i Israel gi, 'amu fafuronosia alaana 'e gi! Jesus wale faasia 'i Nasareti, 'i lia wale God 'e keria mae. God ka fatailia famiu 'alia 'are mama'ala gi, failia 'are li 'aferona 'alida gi lia God 'e tauda mae 'alia. 'I 'amiu talamiu 'amu sai sui ala 'are 'e gi gera fuli 'i safitamiu. ");
INSERT INTO lgl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ma God ka saiai, ma ka naia lo Judas kae foli'alia Jesus, ma ka kwatea famiu, ma 'amu ka raunia, sui 'amu ka ala'alia fala ioli mamata faasia Jiu gi li, gera ka fotoia ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wasua ma God 'e taea lou faasia maena, ma ka lugasia faasia nanatana ala maenali, 'i osiala 'e 'ato fala maena 'ali dau fafia Jesus. ");
INSERT INTO lgl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","'I lao mae David ba 'e sae 'uri 'e suliia, ‘Lau lesia God ala talasi gi sui 'e io fae lau, ma ikoso 'ali lau mau, sulia 'e io garani lau. ");
INSERT INTO lgl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ma 'i fofola me 'are 'e, laka babalafe rasua, ma saenagu ka fonu 'alia babalafe na. Lakae fitoo ala God, ");
INSERT INTO lgl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","sulia iko 'ali 'o ala'ali lau fala lifi ala maenali, ma iko 'ali 'o lugatae lau, Wale Abu 'o ka furafura 'i laola gilu. ");
INSERT INTO lgl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ma ko fatailia fagu lakae mauri lou. Ma ala ionamu fae lau, 'o fafonu lau 'alia babalafena.’” ");
INSERT INTO lgl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ma Peter ka sae too oga lou 'uri 'e, “Alae walefae lau laka alaa madakwa famoulu sulia koko 'ualo gia David walelitalona. 'E mae, ma gera ka alua lo. Ma gigilu lia 'e io garani gia mola 'ala 'i lifi'e 'i tara'ela. ");
INSERT INTO lgl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David iko 'ali alaa lou sulia 'i lia talala talasi 'e ilia me 'are fo li. 'I lia na profet, ma ka sai mola 'ala ala alafuuna God fala. God 'e alafuu fala kae alua ta wale ala kwalofa David walelitalona, 'i lia kae 'ilitoa lou malaa 'i lia. ");
INSERT INTO lgl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David ka lesia sui lo ta 'e God kae taua, ma David ka sae sulia tataenala Christ, wale filia God, faasia maena, ma God ikoso taasi 'alia 'i laola lifi ala maenali, ma rabela ikoso wa'a. ");
INSERT INTO lgl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesus ba, God 'e taea faasia maena, ma 'i 'ameulu sui meulu lesia, ma meulu ka soi fakwalaimokia sulia 'uri'e. ");
INSERT INTO lgl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God 'e faa 'ilitoa Jesus 'alia fagwaurunala 'ali lia ka 'ilitoa failia, ma God ka kwatea Aloe 'are Abu fala, malaa ba 'e etae alafuu 'alia. Ma 'are 'e 'amu lesia, ma 'amu ka ronoa 'i tara'ela, Jesus 'e kwate gwaugwau mae ala Aloe 'are Abu famami. ");
INSERT INTO lgl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Sulia David 'e iko 'ali rae fala 'i nali. Ma David iko 'ali alaa sulia 'i lia talala talasi ba 'e sae 'uri 'e, ‘God 'e sae 'uri 'e fala Aofia lau: 'O gwauru aba aolo agu, ma ko 'ilitoa faelau, ");
INSERT INTO lgl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","maasia talasi lakae alua malimae 'o gi li gera ka ronosuli 'o.’ ");
INSERT INTO lgl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“'Arela 'e 'i 'amiu, wale 'i Israel gi, lau oga 'amu ka sai 'oka ala Jesus lia 'e lau sae sulia, lia ba 'amu fotoia ala 'ai rara folo li, ma God ka alua Jesus, 'a Christ wale filia lia, ma ka alua Jesus ka 'ilitoa!” ");
INSERT INTO lgl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma talasi ioli gi gera ronoa 'are fo gi li, gera mau, ma manoda ka boeboeta. Ma gera ka sae 'uri 'e fala Peter failia wale li lifurono gi, “Alae walefae, taa 'ami ka taua 'ali God kae kwailufa 'ali 'ami?” ");
INSERT INTO lgl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter ka olisi 'uri 'e ada, “'I 'amiu sui, 'amu bulusi faasia ta'ana 'amiu gi, ma 'amu ka sisiu abu sulia 'amu fakwalaimokia Jesus Christ 'ali God ka kwailufa 'alia ta'ana 'amiu gi, ma God ka kwatea Aloe 'are Abu lia famiu. ");
INSERT INTO lgl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God gia 'e etae alafuu kae kwatea Aloe 'are Abu fala ioli 'i lia 'e kwaloda fala 'i talala gi. Etae alafuuna 'e 'e 'afu 'amiu lo failia welamiu, failia ioli 'e gera io tatau gi lou.” ");
INSERT INTO lgl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter ka ilia 'are fo gi fada failia alaana li malata raefale afula gi lou 'uri 'e, “'Amu ka lio 'oka suli 'amiu 'i talamiu faasia kwaikwaina 'e kae la mae fala ioli ta'a gi li!” ");
INSERT INTO lgl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ma ioli afula gi, gera fakwalaimoki ala saenala, ma gera ka sisiu abu. Ma ala fe atoa fo, totolia olu to'oli ioli gi gera ruu lou mae 'i laola logonae ioli fakwalaimoki fo. ");
INSERT INTO lgl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ma ala atoa gi sui, gera ka fafuronosia falalauna wale li lifurono gi li, ma gera 'idufae io ruru, ma gera ka fana kwaima ruru, ma gera ka foa ruru. ");
INSERT INTO lgl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ma wale li lifurono gi, gera fulia 'are mama'ala afula gi, failia 'are li 'aferona 'alida gi, ma ioli gi sui gera ka kwele. ");
INSERT INTO lgl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma ioli gera fakwalaimoki ala Jesus gi, gera ka 'ado 'alia logona kwaima, ma gera ka tolinia too 'arena gera gi 'i safitada. ");
INSERT INTO lgl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ma nali talasi gera ka foli 'alia lou too 'arena gera gi, failia wado gera gi, ma gera ka tolinia seleni gera sakeda gi 'i safitada, ka totolia boboona 'ali ai ada. ");
INSERT INTO lgl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ma gera ka logo ala atoa gi sui 'i laola labuu ala Luma Abu God. Ma gera ka fana kwaima ruru 'i laola luma gera gi, ma talasi gera logo 'urifo gi li, gera ka babalafe rasua failia mamaeana 'i laola maurinada. ");
INSERT INTO lgl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ma gera ka 'aurae God, ma ioli gi sui 'i Jerusalem ka babalafe failida. Ma ala atoa gi sui, Aofia ka faamauria nali ioli lou, ma gera ka ruu mae 'i laola logonae ioli fakwalaimoki fo. ");
INSERT INTO lgl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ala na fe atoa, Peter failia John, daro kae la fala Luma Abu God ala olula tofui matola 'i raurafi, sulia tofui matola fo, talasi Jiu gi li lo fala foana li. ");
INSERT INTO lgl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ala atoa gi sui, wale gi gera 'idufae sakea mae te wale fo 'aela 'e mae fuli'ae lo mae ala futanala. Ma gera ka alua 'i mala 'olofolo ala Luma Abu God li. (Tafaa fo, gera soia 'alia “Mae 'Olofolo lio aolo.”) Ala atoa gi sui, 'e gwauru 'i lififo, 'ali ka suga seleni ala ioli fo gera ruu ko 'i laola Luma Abu God gi li. ");
INSERT INTO lgl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ma ala talasi 'e lesia Peter failia John daro kae ruu ko, ka suga daroa 'ali daro ka kwatea ta me 'are 'ala. ");
INSERT INTO lgl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ma daro ka bubu nanata fala, ma Peter ka sae 'uri 'e fala, “Lio mae fameroa.” ");
INSERT INTO lgl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ma 'i lia ka bubuni daroa ko, ka fia 'ala 'uri daro bi kwatea ta me 'are 'ala. ");
INSERT INTO lgl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma Peter ka sae 'uri 'e fala, “Iko 'ali lau too mola ala ta me seleni. Wasua ma lakae kwatea 'are lau too ai famu. 'Alia ratala Jesus Christ faasia Nasareti, 'o tatae, ma ko liu lo.” ");
INSERT INTO lgl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Mola Peter ka dau ala fili lima aolo lia, ma ka taea. Ma nainali mola 'aela sui ka nanata lo, ");
INSERT INTO lgl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ma ka lofo, ma ka ura 'alia rua 'aela gi, ma ka fuli'ae ka liu kwailiu. Ma ka ruu ko fae daroa fala 'i laola labuu ala Luma Abu God, ka fali, ma ka wae sakasaka failia 'auraeanala God. ");
INSERT INTO lgl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ma talasi wale 'i lifi fo gi li, gera lesia 'e liulo, ma kae 'auraea God, ");
INSERT INTO lgl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","gera lio raea liafo 'i lia wale suga suga ba kae gwaugwauru 'i maala 'olofolo ala Luma Abu God li. Ma gera ka kwele rasua 'alia 'are fo 'e fuli fala wale fo li. ");
INSERT INTO lgl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Talasi fo, wale fo ka biibii rasua lo 'ala sulia Peter failia John, ioli afula gi gera ka kwele rasua, ma gera ka lalao 'i soedaulu 'i laola lifi ala Luma Abu God gera soia 'alia “Taofa Solomon.” ");
INSERT INTO lgl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Talasi Peter 'e lesia ioli fo gi li, ka sae 'uri 'e fada, “'I 'amiu ioli 'i Israel gi, 'utaa 'e 'amu ka kwele 'alia me 'are 'e, ma 'amu ka bubuni 'ameroa lo 'amiu 'urila? Mala 'amu fia 'uria nanatana 'ameroa talameroa, failia io abuna 'ameroa 'e mera guraa 'alia wale 'e ma ka liulo? ");
INSERT INTO lgl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God 'e Abraham, ma Aesak, ma Jakob daulu foasia, God ba koko gia gi li, 'i lia talae faa 'ilitoa wale galona lia Jesus. Wasua ma 'amu kwatea 'amiu Jesus fala wale etaeta gi. Ma talasi Paelat 'e loko kwaikwaina fala, 'amu barasi 'alia ma 'amu ka oga ta'a rasua 'amiu ala talasi ba Paelat 'e ilia kae lugasia. ");
INSERT INTO lgl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesus wale abu ma ka rada, lia ba God 'e filia fala faamurinala ioli lia gi, wasua ma 'amu barasi 'alia, ma 'amu ka anisia 'amiu Paelat fala lugasinala wale 'e rau ioli. ");
INSERT INTO lgl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ma 'amu ka raunia Jesus wale 'e kalokalola maurina li. Wasua ma God 'e taea faasia maena, ma 'i 'ameroa mera ka lesia kwalaimokinala me 'are 'e. ");
INSERT INTO lgl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","'Amu lesia wale 'e, ma 'amu ka lio raea. 'E fakwalaimokia nanatanala Jesus lia 'e ka faamauri lia. Fitoona ala Jesus lia 'e kwatea wale 'e ka 'afu lia 'e 'amu ka lesia sui lo. ");
INSERT INTO lgl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“'Are la fo alae walefae lau, lau saiai 'i 'amiu failia wale etaeta gi 'amu tau 'urifo ala Jesus, sulia 'amu rari 'are. ");
INSERT INTO lgl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Wasua ma God 'e ilia lo mae 'ualo 'i lao 'alia profet gi sui, wale filia lia kae famalifii. Ma 'e 'urifo 'ali ka fakwalaimokia saenala God. ");
INSERT INTO lgl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","'Urifo 'amu ka bulusi lo, ma 'amu ka bulusi fala God, 'ali 'i lia ka kwailufa 'alia abulo ta'ana 'amiu gi, ma 'ali God kae fababalafea manomiu, ");
INSERT INTO lgl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ma 'i lia ka kwatea Jesus Christ wale ba 'e filia famiu. ");
INSERT INTO lgl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","'E io mae 'ala 'i nali la la ka dao ala talasi God kae fafalua 'are gi sui, malaa ba 'e ilia lo mae 'ualo 'alia profet abu lia gi li. ");
INSERT INTO lgl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sulia Moses 'e sae sulia Aofia 'uri 'e, ‘God 'amiu kae kwatea ko te profet 'i soemiu, malaa lou lia 'e 'e keri lau mae. 'I lia na wale mola amiu ioli Jiu gi. 'Amu ka ronosulia ta gi 'e ilida famiu. ");
INSERT INTO lgl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ite iko 'ali ronosulia ta profet fo 'e ilia, God kae tolinia 'i lia kae io atale faasia ioli lia gi ma kae osia.’ ");
INSERT INTO lgl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel, failia profet gi sui gera la mae 'i buri, gera too ala faronona 'e faasia God, gera ka faatalo lou 'alia me 'are 'e 'e fuli lo ala talasi 'e li. ");
INSERT INTO lgl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Alafuuna God gi famiu gera dao mae 'alia profet lia gi. Ma 'amu ka 'ado ruru failia koko 'amiu gi 'i laola alafuuna God fada, malaa 'e ilia fala Abraham 'uri 'e, ‘Lakae fa'oka ioli gi sui 'i laola molagali, sulia wale 'e futa oliolitamu.’ ");
INSERT INTO lgl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Lia fo, God ka filia ma ka kwatea mae wale galona lia Jesus 'i soemiu, 'ali 'i lia ka fa'oka 'amiu, 'alia bulusi namiu faasia ta'ana 'amiu gi.” ");
INSERT INTO lgl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ala talasi Peter failia John daro alaa 'ua fala ioli gi li ai, nali fata abu, ma nali Sadusi, failia wale etaeta ala wale gera lio folo bolosia Luma Abu God gi li, gera ka dao mae 'i soedaroa. ");
INSERT INTO lgl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gera ogata'a, sulia rua wale li lifurono fo gi daro faalalaua ioli gi lia 'e Jesus 'e tatae lo faasia maenali, ma ka fatailia ioli gera mae gi wasua gera kae tatae lou faasia maena. ");
INSERT INTO lgl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Lia fo 'e kwatea gera ka dau daroa, ma gera ka aludaroa 'i laola raraa, daro ka io 'i lififo masia ruala fe atoa, sulia 'e raurafi lo. ");
INSERT INTO lgl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma ioli afula gera ronoa alaana daroa gi li, gera fakwalaimoki. Ma ioli gera fakwalaimokia faronona 'oka ala talasi fo li, 'e totolia lima to'oli wale gi. ");
INSERT INTO lgl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ala fe atoa 'i buri, 'ilito'ola fata abu 'e logosia mae fata abu ba'ela gi, wale falalau ala taki gi li, failia nali wale ala logonae wale li lokomalata gi, ma geraka logo ala te lifi 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Gera logo failia 'Anas 'ilito'ola fata abu, ma Kaeafas, ma John, ma Aleksanda failia nali wale lou ala kwalofa ala 'ilito'ola fata abu gi li. ");
INSERT INTO lgl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Sui gera ka fa uraa Peter failia John 'i maada, ma gera ka soilididaroa 'uri 'e, “Mora guraa 'utaa ala wale 'ae mae 'e? Kwalaimokina ta 'e mora too ai, ma nanatana ala ite 'e mora guraa 'alia?” ");
INSERT INTO lgl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peter, 'e fonu ma ka sae 'alia nanatanala Aloe 'are Abu 'uri 'e fada, “'I 'amoulu wale etaeta gi, ma wale ba'ela gi, ");
INSERT INTO lgl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","'amu soilidi 'ameroa 'i tara'ela sulia 'are 'oka 'e mera taua fala wale 'aela mae 'e, ma ta 'e kwatea ka 'oka. ");
INSERT INTO lgl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mera oga 'i 'amoulu failia ioli gi sui 'i Israel 'amu ka saiala 'are 'e, wale 'e 'amu lesia, 'e 'akwaa, ma ka ura lo fae 'amiu, 'e 'akwaa 'alia nanatanala Jesus Christ wale faasia 'i Nasareti ba 'amu raunia ala 'ai rara folo li, ma God ka taea faasia maena. ");
INSERT INTO lgl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesus ba Geregerena Abu 'e sae sulia 'uri 'e, ‘'I lia lo fau, 'i 'amiu wale raunae luma gi, 'amu barasi 'alia. 'I lia lo fau 'e 'ilitoa ka liufia fau gi sui ala balibali.’ ");
INSERT INTO lgl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","“Talifilia mola 'e saiai ka faamauria ioli gi, iko lou ta ioli 'i laola molagali, lia God 'e kwatea 'ali ka faamauri gia 'alia.” ");
INSERT INTO lgl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ma wale ba'ela gi, gera ka kwele rasua 'alia Peter failia John, sulia iko 'ali daro mau 'alia sae too oga na. Ma gera ka kwele lou 'alia sai arena daroa, rua wale 'e gi iko daro saisai 'are mola. Ma gera saiai 'i daroa rua wale li kwaikwaiasi gi mola. Ma gera ka sai lou ala lia 'i daroa rua wale ba daro liuliu ruru failia Jesus gi. ");
INSERT INTO lgl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma gera ka raria lo ilinala lou ta 'are, sulia wale ba daro guraa 'e ura lou fae daroa. ");
INSERT INTO lgl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","'Urifo gera ka kwatea Peter, failia John, failia wale fo, daulu ka latafa faasia lifi li logo fo. Sui, gera ka alaa ga 'ada sulia ta lo gerakae taua ala Peter failia John. ");
INSERT INTO lgl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ma gera ka sae 'uri 'e, “Taa lo golu kae taua ala rua wale 'e gi? Sulia ioli gi sui lia gera io 'i Jerusalem, gera sai sui mola 'ada ala 'are mama'ala fo daro taua, ma iko 'ali totolia 'ali golu tofe fafia. ");
INSERT INTO lgl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ma 'ali me 'are 'e ikoso talo fala tali ioli lou, golu ilia fadaroa ikoso 'ali daro sae lou sulia Jesus fala tali ioli lou.” ");
INSERT INTO lgl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Sui gera ka rii lou mae fala Peter ma John, gera ka sae nanata 'uri 'e fadaroa, “Ikoso mora sae lou 'alia ma ikoso mora faalalau lou sulia Jesus.” ");
INSERT INTO lgl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ma Peter failia John daro ka olisi 'uri 'e ada, “'Amu malata ga, 'a ta 'e rada 'i maala God, ronona suli 'amoulu, 'o ma ronona sulia God? ");
INSERT INTO lgl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ikoso mera mano faasia saena sulia ta 'e mera talae lesia, ma mera ka ronoa, sulia mera rono sulia God.” ");
INSERT INTO lgl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ma logona fo ala wale lokomalata gi li, gera ka sae nanata lou fadaroa. Sui gera ka lugasi daroa, taufasia ioli gi bi kwalaa fafia kwai nadaroa, sulia ioli gi sui, gera batafea rasua God fafia me 'are fo daro fulia. ");
INSERT INTO lgl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sulia ioli gi gera saiai talifilia God mola 'e saiai ka guraa wale 'e matai lo sulia fai akwala fe falisi ma ka tarena ala maurinala. ");
INSERT INTO lgl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Talasi gera lugasia mola Peter failia John, daro ka oli 'i so'ela alae ioli daulu, ma daro ka farono gera 'alia 'are fo fata abu ba'ela gi, failia wale etaeta gi gera ilia. ");
INSERT INTO lgl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ala talasi gera ronoa, gera ka foasia 'uri 'e ala God, “God 'ilitoa, 'i'o lo 'o raunailia raloo, failia molagali, ma asi, failia 'are mauri gi sui 'i lifi'e. ");
INSERT INTO lgl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ma ko kwatea lo Aloe 'are Abu 'o fala koko 'ami David wale li galona 'o, 'ali ka sae 'uri 'e, ‘Ioli mamata faasia Jiu gi li, gera ogata'a fagu, ma gera ka tori malata fali rauni lau sulia malatae wale kwekwe'ela gera gi. ");
INSERT INTO lgl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Walelitalona gi gera ka rerei 'ada 'i talada failia wale 'ilitoa gi gera ka logo fala kwalaana failia God, ma Christ wale filia lia.’ ");
INSERT INTO lgl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Sulia 'are 'e fuli talasi Herod Antipas failia Pontias Paelat, daro logo 'i laola falua 'e failia ioli mamata faasia Jiu gi li ma wale 'i Israel gi lou. Gera logo fala lokokwaikwaina fala Jesus, wale galona abu 'o 'o filia lo. ");
INSERT INTO lgl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gera logo fala falalamanala 'are gi sui, malaa ba 'o naia lo mae, 'alia nanatana 'o, failia kwaiogalina 'o 'ali ka fuli lo 'urifo. ");
INSERT INTO lgl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ma talasi 'e God, 'o lesia ga alaana nanata gera gi, ma ko kwatea mae nanatana 'o fameulu ioli galona 'o gi, 'ali meulu ka sae too oga 'alia saenamu. ");
INSERT INTO lgl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","'O fatailia mae kwalaimokina ma ko guraa ioli gi, 'ali gera ka lesia fulinala 'are mama'ala gi, failia 'are li 'aferona 'alida gi, 'alia nanatana wale li galona abu 'o Jesus.” ");
INSERT INTO lgl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ma talasi gera foa ka sui mola, lifi fo gera logo ai ka 'asu lo. Ma Aloe 'are Abu ka fananata daulu sui, ma gera ka sae ramoramoa lo 'alia saenala God. ");
INSERT INTO lgl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ma ioli gi sui lia 'e gera fitoo, gera ka logo 'alia teke malata failia teke lioe ioli. Ma iko ta ioli 'ali too ala ta 'are 'ali 'i lia ka ilia 'alia 'are lia 'i talala, wasua gera tolinia 'are gera gi sui 'i safitada. ");
INSERT INTO lgl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ma wale li lifurono gi gera ka faatalo ramoramoa sulia tataenala Aofia Jesus faasia maena, ma God ka 'oilakitae gera sui. ");
INSERT INTO lgl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ma iko ta ioli faasia alae ioli ala iona gera ka boboo 'afia ta me 'are, sulia nali talasi gera boboo, nali ioli adaulu lia 'e gera too ala wado 'o ma luma, gera ka foli 'alida, sui ma gera ka sakea mae seleni fo gi, ");
INSERT INTO lgl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","gera ka kwatea fala wale li lifurono gi, gera sakea, geraka tolinida fada sulia boboo na gera gi sui. ");
INSERT INTO lgl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ma Josef te wale ala kwalofa Lifae ba futa 'i Saeprus ba wale li lifurono gi gera soia 'alia Banabas (fadanai Ulufa'alu ala Malata Raefale li), ");
INSERT INTO lgl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","'e foli 'alia me tofui wado lia, ka sakea bata fo, ka kwatea fala wale li lifurono gi. ");
INSERT INTO lgl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Wasua ma te wale ratala Ananias, failia wateu lia ratala Safira, daro io lou failia alae ioli fitoo fo. Ma daro ka foli lou 'alia na gula ala wado daroa. ");
INSERT INTO lgl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ma Ananias ka alua 'ala na gula ala bata fo fadaroa, ka sakea mola mae na gula ala bata fo ka kwatea fala wale li lifurono gi, ma ka ilia 'uri 'i gera sui lo sefo. Ma wateu lia wasua ka aala lou fafia me kotona fo. ");
INSERT INTO lgl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","'Urifo Peter ka soilidi 'uri 'e ala, “Ananias, 'utaa 'e ko aala 'alia Saetan ka talai 'o, ma ka taua ko kotofia Aloe 'are Abu 'alia faagwanala na gula ala bata ba mora sakea? ");
INSERT INTO lgl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'I laoala 'o foli 'alia wado ba, wado 'are 'o. Ma 'i burila 'o foli 'alia, bata 'o sakeda ai gi, 'i'o 'o ba'ela ali, ma ko saiai ko taua 'amua 'alia ta 'are sulia kwaiogalina 'o gi. 'Uri'e ma 'utaa 'e ko malata 'uri'e 'i laola malatamu? Iko 'ali 'o kotofia mola ioli, 'o kotofia lou God!” ");
INSERT INTO lgl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Talasi Ananias 'e ronoa me 'are fo li, ka toli 'i fua, ma ka mae lo. Ma ioli gera ronoa me 'are fo li, gera ka mau rasua. ");
INSERT INTO lgl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ulufa'alu gi gera ruu mae, gera ka butaa rabela. Ma gera ka sakea 'i maluma, ma gera ka alomia lo. ");
INSERT INTO lgl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","'E totolia olula tofui matola 'i burila, wateu lia ka ruu mae 'i laola luma ala lifi Peter 'e io ai, ma iko 'ali sai lou ala ta 'e fuli ala arai lia. ");
INSERT INTO lgl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ma Peter ka soilidi 'uri 'e ala “Faarono lau ga mae, 'uri 'e ma bata ba gi sui lo 'e lia ba arai 'o fae 'o mora sakea ala wado ba mora foli 'alia li?” Ma 'i lia ka olisia 'uri 'e, “'Eo, 'i gera sui lo la.” ");
INSERT INTO lgl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Mola Peter ka soilidia lou 'uri 'e ala “'Uta 'e arai 'o fae 'o, mora ka kotofia Aloe 'are Abu God, ma mora fia 'uria ikoso 'ali 'e loko kwaikwaina mola famoroa? Wale ba gera alomia arai 'o gi laa, gera ura mola 'ada 'i maala 'olofolo ala talasi 'e. Ma gera kae sake'o lou 'ali geraka alomi'o.” ");
INSERT INTO lgl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ma 'urifo mola geli fo ka toli lo 'i fua 'i maala 'aela Peter, ma ka mae lo. Ma ulufa'alu ba gi gera ruu mae, gera ka lesia 'e mae lo, gera ka sakea 'i maluma, ma geraka lai alomia lou 'i rabela arai lia. ");
INSERT INTO lgl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ioli fitoo gi sui, ma ioli gi sui lou lia gera ronoa me 'are fo li, gera mau rasua. ");
INSERT INTO lgl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Wale li lifurono gi, gera fulia 'are afula li 'aferona 'alida gi ma 'are mama'ala gi 'i safitala ioli gi. Ma ioli fitoo gi sui, gera ka logo 'i laola Luma Abu God ala lifi gera soia 'alia Taofa Solomon. ");
INSERT INTO lgl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ma ioli iko 'ali gera fitoo gi, iko 'ali gera too oga fala Logona failida, wasua ioli gi ka tafea ioli fito gi ma gera ka soi 'oka ada. ");
INSERT INTO lgl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wasua ma wale afula gi, failia geli afula gi lou, gera fakwalaimoki ala Aofia, ma gera ka logo lou 'i laola logonae ioli fo. ");
INSERT INTO lgl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ma 'i fofola 'are fo wale li lifurono gi gera fulida gi, ioli 'i lififo gi gera ka sakea lo ioli matai gi, ma geraka aluda sulia tala 'i fofola tafe gera gi, 'ali talasi Peter ka liu ai, lulula wasua ka liu fafida, ma gera ka 'akwaa. ");
INSERT INTO lgl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ma ioli afula gi gera ka la mae faasia maefalua galia 'i Jerusalem gi, gera sakea mae ioli gera gi lia 'e gera matai failia ioli aloe 'are ta'a gi 'e io ada gi, ma wale li lifurono gi geraka gurada, ma 'i gera sui geraka 'akwaa lo. ");
INSERT INTO lgl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ma 'ilito'ola fata abu, failia wale lia gi lia gera io 'i laola logonae ioli ala Sadusi gi li, gera ka kwaifii rasua fala waleli lifurono gi. ");
INSERT INTO lgl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ma gera ka dauda, ma gera ka aluda 'i laola raraa. ");
INSERT INTO lgl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wasua ma ala fe boni fo, eniselo God 'e dao mae, ka tafalia maala 'olofolo gi ala raraa fo, ma ka talaida 'i maluma, ma ka sae 'uri 'e fadaulu, ");
INSERT INTO lgl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Moulu la, moulu ka ura 'i laola Luma Abu God, moulu ka faronoa ioli gi sulia maurina fa'alu 'e.” ");
INSERT INTO lgl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Waleli lifurono gi gera ka rono sulia eniselo fo, ma 'i 'ofaedani daulu ka la lo 'i laola Luma Abu God, ma daulu ka fuli'ae lo ala falalauna. 'Ilito'ola fata abu failia wale lia gi, daulu ka soia mae wale etaeta ala Jiu gi li fala logonae wale lokomalata, 'ali geraka filoa waleli lifurono gi. Ma gera ka kwate saena fala wale li ofona gi, gera ka talaia mae waleli lifurono gi faasia 'i laola raraa 'i soedaulu. ");
INSERT INTO lgl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Wasua ma talasi fo wale li ofona gi gera dao ko, iko 'ali gera lesia lo ta waleli lifurono 'i laola raraa. Ma gera oli geraka faronoa wale etaeta gi 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Talasi meulu dao ko 'i laola raraa li, meulu lesia lia wale lio folo gi gera folo nasi rasua lo ala maala 'olofolo gi, ma gera ka lio folo mola 'ada 'i maala 'olofolo gi. Wasua ma talasi meulu tafa, meulu ka lio ko 'i laola luma, ma iko 'ali meulu lesia mola ta ai ala waleli lifurono gi 'i laola.” ");
INSERT INTO lgl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Talasi fo fata abu ba'ela gi, failia wale etaeta ala wale li lio folo ala Luma Abu God gi li, gera ronoa me 'are fo, gera ka soilidi filo kwailiu ada ta ta lou kae fuli. ");
INSERT INTO lgl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","'Urifo te wale ka ruu mae, ma ka sae 'uri 'e fadaulu, “Moulu fafurono ga, wale ba moulu aluda 'i laola raraa gi li gera ura lo 'i laola Luma Abu God, ma gera ka faalalaua lo ioli gi!” ");
INSERT INTO lgl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ma wale ba'ela ala wale lio folo gi li failia wale lia gi, gera la, gera ka oli mae failia lifurono gi. Iko 'ali gera suunailida 'alia kwainada fala olina mae, sulia gera mau 'alia ioli gi, taufasia gera bi 'uida 'alia fau gi. ");
INSERT INTO lgl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ma talasi gera talaia mae waleli lifurono gi li, ma gera ka faa urada 'i maala logonae wale lokomalata fo gera logo mae li, 'ilito'ola fata abu ka sae fadaulu 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Meulu lui nasi ai ikoso 'ali molu faalalau lou 'alia Jesus. Lesia me 'are 'e moulu taua Falalauna 'amoulu, 'e talofia lo 'i laola falua 'i Jerusalem. Ma moulu ka suafafi 'ameulu 'uri 'i 'ameulu lo 'e meulu raunia Jesus ka mae!” ");
INSERT INTO lgl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Sui Peter failia wale li lifurono gi gera ka olisida 'uri 'e, “Meulu kae rono sulia God, iko lou ioli. ");
INSERT INTO lgl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ma 'i burila 'amu raunia Jesus ala 'ai rara folo ka mae, God ba koko gia gi li ka taea faasia maena. ");
INSERT INTO lgl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ma God 'e taea ka 'ilitoa failia 'ali lia ka kwaitalai ma ka faamauri, 'ali ka kwatea talasi fala ioli Israel gi, 'ali geraka bulusi, ma God ka kwailufa 'alia ta'ana gera gi. ");
INSERT INTO lgl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Meulu lesia lo 'are 'e fuli fala Jesus gi, ma 'i 'ameulu failia Aloe 'are Abu meulu sae fakwalaimoki lo sulida. God 'e kwatea mae Aloe 'are Abu fala nalife ioli gera ronosulia.” ");
INSERT INTO lgl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ma talasi fo wale 'i laola logonae wale lokomalata fo gi gera ronoa 'are fo li, gera ka ogata'a rasua, ma gera ka oga rauninala waleli lifurono fo gi. ");
INSERT INTO lgl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wasua ma te wale ala logonae wale lokomalata fo li, 'i lia na ai ala logonae wale ala Farasi gi ratala Gamaliel lia wale faalalau 'alia taki li, ma 'i lia ioli gi gera soi ba'ela rasua ala, 'e tatae ka ilia gera ka olifailia ga 'ada waleli lifurono fo gi 'i maluma fala keme talasi wawade. ");
INSERT INTO lgl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Sui, ka sae 'uri 'e fala wale etaeta fo gi, “'I 'amiu ioli 'i Israel gi, 'amu ka malata 'oka sulia 'are 'e 'amu kae taua ala wale 'e gi li. ");
INSERT INTO lgl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sulia iko 'ali tekwa mola ko, Tedas 'e la mae ka ilia 'i lia wale 'ilitoa rasua, ma ka totolia fai talanae wale gi ba gera la sulia. Ma iko 'ali tekwa mola, ioli gi geraka raunia, ma waleli galona lia gi gera ka keta sui, ma galona ba 'e taua ka sui lou 'ala. ");
INSERT INTO lgl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sui 'i burila Judas wale 'i Galili ka la lou mae ala talasi gera gerea ratala ioli gi sui. Ma ioli afula gi gera la sulia ma gera ka kwalaa failia ioli 'i Rom gi, ma wale li ofona 'i Rom gi gera ka raunia lou. Ma waleli galona lia gi, gera ka keta lou 'ada. ");
INSERT INTO lgl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ma sulia 'are 'e wale li galona Jesus gi gera taua, laka ilia famoulu, ikoso 'ali 'amu taua ta 'are ada. 'Amu aala 'alida geraka la 'ada ma moulu ka la faasida. Ala malatana failia galona 'e gera taua 'are mola ala ioli li, kae fulu mola 'ala. ");
INSERT INTO lgl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma ala 'e la mae faasia God, 'e 'ato 'ali 'amu kae ura bolosia ma 'amu kae daria 'amu kwalaa failia God.” Ma logonae wale lokomalata fo, gera ka ronosulia saenala Gamaliel. ");
INSERT INTO lgl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sui gera ka oli lou mae failia wale li lifurono gi, ma gera ka ilia fala wale lio folo gi gera ka rabusida. Ma gera ka luida ikoso gera sae lou sulia Jesus. Sui, gera ka lugasida. ");
INSERT INTO lgl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ma talasi waleli lifurono gi gera la lo faasia logonae wale lokomalata fo li, gera ka babalafe rasua, sulia God 'e alafafida lia 'e gera totolia famalifiina 'i osiala Jesus. ");
INSERT INTO lgl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma ala atoa gi sui, waleli lifurono gi gera ka liu 'i laola labu ala Luma Abu God li, ma 'i laola luma ioli gi li, ma gera ka faalalau, ma geraka faatalo 'alia Faronona 'Oka 'e Jesus lia 'e 'i lia wale filia God. ");
INSERT INTO lgl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ma talasi fo, ioli gera fitoo ala Jesus gi gera afula lo. Ma 'ugana ka tatae safitala Jiu gera sae 'alia saena Hebru li failia Jiu gera sae 'alia saena Grik gi li. Nali ai ada gera sae 'alia saena Grik, gera 'uga, sulia Jiu gera sae 'alia saena Hebru li iko 'ali gera ranaa mola me 'oru gera gi ka rada failia 'oru Jiu fo gera sae 'alia Hebru 'alia fana, failia bata fo gera tolinia ala atoa gi li. ");
INSERT INTO lgl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ma akwala wala rua waleli lifurono fo gi, daulu ka soia mae ioli fakwalaimoki gi sui, daulu ka sae 'uri 'e, “Iko 'ali 'oka 'ali meulu ka 'abero lou 'alia tolininala bata golu gi, ma meulu ka malata buri lo 'ameulu 'alia fatalona 'alia saenala God. ");
INSERT INTO lgl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","'E 'urifo alae iolifuta, 'amu ka filia ta fiu wale 'oka 'i safitamiu 'amu saiada Aloe 'are Abu 'e io ada, ma gera ka liotoo, 'ali geraka lio sulia galona 'e. ");
INSERT INTO lgl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma 'i 'ameulu meulu ka galo te gula lo 'ameulu ala foana failia fatalona 'alia saenala God.” ");
INSERT INTO lgl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ma ioli fo gi, gera logo, ma geraka babalafe talasi gera ronoa me 'are fo li, ma gera ka filia Stefen, wale fitoona lia 'e nanata failia Aloe 'are Abu ka io failia. Ma gera ka filia lou Filip, Prokorus, Nikanor, Timon, Parmenas, ma Nikolaus wale faasia 'i Antiok lia 'e dau sulia faalalauna ioli Jiu gi li, wasua 'ala 'i lia iko 'ali futa ala ta ioli Jiu. ");
INSERT INTO lgl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sui, logonae ioli fakwalaimoki fo, gera ka talaia mae fiu wale fo gi 'i so'ela lifurono gi, ma lifurono fo gi daulu ka foa failida, ma daulu ka alua limadaulu fafia gwauda. ");
INSERT INTO lgl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma saenala God ka talofia sui lo 'afutala 'i Jerusalem. Ma ioli 'i Jerusalem gi gera fakwalaimoki, gera ka afula rasua failia fata abu afula gi lou, gera ka fakwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefen wale God 'e 'oilakitailia, ma ka too ala nanatana fala taunala 'are mama'ala afula gi, ma 'are li 'aferona 'alida gi 'i safitala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma nali wale gera barasi 'alia Stefen, gera io lou 'i laola logonae ioli gera soia 'alia “Luma fala foana 'ala wale gera io sakwadola gi li.” Nali wale ada gera Jiu gera la mae faasia 'i Saeren, failia 'i Aleksandria. 'I gera failia nali Jiu faasia gulae tolo 'i Silisia, ma 'i Asia gi, gera ka fuli'aea alafaitalilina failia Stefen. ");
INSERT INTO lgl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ma Aloe 'are Abu ka kwatea liotoo fala Stefen, 'ali talasi 'i lia ka sae 'alia, 'ato rasua ta ioli ka olisia. ");
INSERT INTO lgl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sui gera ka foli agwa ala nali wale 'ali gera ka ilia, “'Ami ronoa 'e sae fawawadea Moses failia God.” ");
INSERT INTO lgl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","'Urifo wale fo gi geraka suuradaia wale etaeta gi, failia wale falalau ala taki gi li, gera ka ogata'a rasua, ma gera la mae 'i so'ela Stefen, ma gera ka daua, ma gera ka talaia mae 'i so'ela logonae ioli lokomalata. ");
INSERT INTO lgl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Sui gera ka soia mae nali wale 'ali gera ka koto fafia. Gera sae 'uri 'e, “Sulia atoa gi, wale 'e 'e sae fawawadea 'ala Luma Abu God, failia taki Moses gi. ");
INSERT INTO lgl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","'Ami ronoa 'e ilia Jesus wale 'i Nasareti kae osia Luma Abu God, ma kae olisia lou falafala gia gi lia Moses 'e kwateda lo faga.” ");
INSERT INTO lgl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ma wale fo gera io 'i laola logonae ioli lokomalata fo li, gera ka alu lo maada ala Stefen, ma gera ka lesia lia maala 'e wasinosino ka malaa lo na eniselo. ");
INSERT INTO lgl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","'Urifo 'ilito'ola fata abu ka soilidia Stefen ma ka sae 'uri 'e, “'Uri'e ma 'are 'e gera sua fafi 'o 'alida gi, gera kwalaimoki 'e?” ");
INSERT INTO lgl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefen ka olisi 'uri 'e ada, “Alae walefae lau ma mama lau gi, moulu fafuronosi lau ga! God 'e 'ilitoa ma ka nanata, 'e fatae fala koko 'ualo gia Abraham talasi 'e io 'ua 'i Mesopotemia, sui ka bi lai io 'i Haran. ");
INSERT INTO lgl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","God 'e sae 'uri 'e fala, ‘'O tatae faasia fuui wale 'o, failia falua 'o, ko la fala falua la lakae ilia famu koe la fai.’ ");
INSERT INTO lgl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Sui 'i lia ka la faasia gulae tolo lia 'i Kalde, ma ka lai io 'i Haran. Ma 'i burila mama Abraham 'e mae, God ka ilia ka 'idu mae fala falua 'e 'amu io lo ai 'i tara'ela, lia gera soia 'alia 'i Kenan 'i lao. ");
INSERT INTO lgl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God iko 'ali kwatea mola ta gula ala wado 'e fala Abraham, ta gula wawade wasua 'ala 'ali Abraham ka too ai 'e iko lou. Wasua ma God 'e etae alafuu fala kae kwatea wado fo 'ali wado lia lo 'ala, failia oliolitala kwalofa lia. Ma talasi God 'e etae alafuu fala, Abraham iko 'ali too 'ua ala ta wela. ");
INSERT INTO lgl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","'I buri God ka sae 'uri 'e fala, ‘Oliolitamu gerakae io ala falua la iko lou falua gera, ma 'i lififo gera kae galo gwaugwau. Ma ioli gi gerakae malakwaita ada sulia fai talanae fe nali gi. ");
INSERT INTO lgl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wasua ma la kae kwatea kwaikwaina fala ioli fo gera galo 'ada gi. 'I burila, oliolitamu gerakae latafa mae faasia falua fo, ma gerakae foasi lau 'i laola lifi 'e.’ ");
INSERT INTO lgl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“God 'e etae alafuu fala Abraham ma ka ilia fala, ala ioli lia gi gera 'ole wale, gera alafafia sae alafuuna lia. 'Arela fo Abraham ka 'ole wale ala Aesak, kwalu atoa gi 'i burila 'e futa. 'Urifo lou, Aesak ka 'ole wale ala wela lia Jakob, ma Jakob ka 'ole wale ala akwala wala rua wela lia gi lia 'i gera lo koko gia gi. ");
INSERT INTO lgl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Josef na wale lo ala akwala wala rua wela fo Jakob 'e aluda gi. Ai 'i laoala gi sui lioda 'e kwaifi fala, ma gera ka foli 'alia fala wale gera la fala 'i Ejipt gi, 'ali lia kae galo ulafu 'i lififo. Wasua ma God 'e io failia, ");
INSERT INTO lgl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ma ka lio sulia 'i laola nanana lia gi. Talasi Josef 'e dao 'i so'ela Fero, walelitalona 'i Ejipt, God ka kwatea liotoo fala, ma ka kwairanai ala lia fo 'e kwatea ma Fero ka oga, ma Fero ka alua 'i lia ka 'ilitoa fafia iona 'i Ejipt, ma ka alua lia ka lio lou sulia too 'arena lia gi sui. ");
INSERT INTO lgl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ma talasi fo lou bonili fiolo ba'ela ka liu 'i laola falua 'i Ejipt ma 'i Kenan, lia 'e ka kwatea lo nanana ba'ela fala ioli gi. Ma talasi fo, 'e 'ato rasua fala Jakob failia wela lia gi 'ali daulu ka daria ta fana. ");
INSERT INTO lgl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","'Arela fo ala talasi Jakob 'e ronoa fana 'e afula 'i Ejipt, ka keria lo wela lia gi ('i gera koko gia gi), gera ka eta lai dao 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","'Urifo ala ruala talasi gera la lou mae, Josef ka tafanailia 'i lia talala fala ai laoala gi gera ka bi lio raea. Ma Fero wasua ka sai lou ala fuui wale Josef gera io 'i Kenan. ");
INSERT INTO lgl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ma Josef ka kwate saena 'afia mama lia Jakob, ma ka ilia 'i lia failia kwalofa lia gi sui geraka la mae fala 'i Ejipt. Ma 'i gera sui lo gera fiu akwala wala lima ioli gi. ");
INSERT INTO lgl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakob ka la fala 'i Ejipt failia wela lia gi, ma gera ka mae lo 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gera ka sakea rabeda geraka alomida 'i Sekem te falua 'i laola gulae tolo 'i Kenan, wado ba Abraham 'e folia faasia kwalofa Hamor. ");
INSERT INTO lgl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ma talasi 'e garani lo 'ali God ka falalamaa sae alafuuna 'e taua fala Abraham, ioli gia gi gera io 'i Ejipt, gera afula rasua lo. ");
INSERT INTO lgl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ala talasi fo, walelitalona fa'alu, lia iko 'ali saiala taa falafala sulia Josef, lia 'e fuli'ae ka 'ilitoa fafia 'i Ejipt. ");
INSERT INTO lgl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Lia ka 'oi'ala koko gia gi, ma ka malakwaita rasua lo ada, ma ka sae nanata fada, 'ali gera ka tasia wela gera gi 'i maluma, 'ali geraka raumailida. ");
INSERT INTO lgl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ma talasi fo Moses 'e futa mae ai, wela aolo 'oka rasua. Ma teite lia ka golia mola sulia olu madama gi 'i luma lia. ");
INSERT INTO lgl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ma talasi gera sakea ko Moses faasia luma lia li, ulao Fero 'e sakea, ma ka ranolia, ma ka golia malaa na wela lia lo. ");
INSERT INTO lgl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ioli 'i Ejipt gi gera faalalaua Moses 'alia 'are afula fo ioli 'i Ejipt gi gera oga geraka saiai. Ma 'i lia ka ba'ela lo, ma 'i lia na wale 'ilitoa 'alia saenala failia abulonala. ");
INSERT INTO lgl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ma talasi Moses 'e ba'ela mae ka dao ala fai akwala fe nali gi li, 'i lia ka malata fala daona tonala ioli lia gi li ala kwalofa 'i Israel. ");
INSERT INTO lgl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ma talasi 'e dao, ka lesia te wale Jiu lia wale 'i Ejipt 'e mala ta'a rasua lo ala. 'I lia ka la ko ka kwairanai ala, ma ka duu 'alia, ma ka raunia lo wale fo 'i Ejipt. ");
INSERT INTO lgl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ka fia 'uria ioli lia gi totolia gera ka saiai lia God 'e filia fala talainada faasia malakwaitana 'i Ejipt, wasua ma ioli gi sui iko 'ali gera sai mola ai. ");
INSERT INTO lgl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ma ala na fe atoa lou, 'e lesia rua wale Jiu gi daro kwalaa, ma ka maili tonala kwatenala aroarona 'i safitadaroa ka sae 'uri 'e, ‘Mora rono ga, 'i 'amoroa laa rua wai asila gi mola. Totolia ikoso 'ali mora kwalaa mola.’ ");
INSERT INTO lgl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ma na wale adaroa lia 'e fulia kwalaana fo li ka olisia Moses, ka sae 'uri 'e, ‘Ite 'e aalua ko 'ilitoa fameroa, ma ko gwauru li wale kwai lokomalatana 'i safitameroa? ");
INSERT INTO lgl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","'O oga ko rauni lau lou, malaa lia ba 'o raunia wale ba 'i Ejipt 'i nalafi?’ ");
INSERT INTO lgl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Talasi Moses 'e ronoa me 'are fo li, ka tafi faasia 'i Ejipt, ma ka lai io lo 'ala 'i Midia, ma ka arai lo 'i lififo, ma wateu lia ka faafutaa rua wela wale gi. ");
INSERT INTO lgl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“'I burila Moses 'e io lo 'i lififo sulia fai akwala fe nali gi, eniselo ka fatae fala 'i laola meamea ala dunaa 'e kwarufia 'ai 'e ura garania fe uo 'i Saenae, 'i laola abae lifi kwasi iko 'ali totolia ta ioli 'ali io ai. ");
INSERT INTO lgl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ka 'afero rasua 'alia me 'are fo 'e lesia, ma ka 'idu garania ko 'ai fo, 'uri 'ali lio 'oka ai. Ma ka ronoa linela God ");
INSERT INTO lgl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'uri 'e, ‘'I lau God koko 'ualo 'o gi li, God Abraham, ma Aesak, ma Jakob.’ Ma Moses ka lebelebe, ma ka barasi lio lo ko, sulia 'e mau rasua. ");
INSERT INTO lgl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ma God ka sae 'uri 'e fala, ‘'O kalasua 'ae botu 'o gi faasia 'aemu, sulia lifi 'e 'o ura ai, wado abu. ");
INSERT INTO lgl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Lau lesia malakwaitana ta'a rasua gera taua ala ioli lau gi lia gera io 'i Ejipt, ma laka ronoa linela anina gera gi. 'Arela 'e laka sifo mae 'ali lau lafuda faasia. 'O la 'i Ejipt, sulia lau fili'o lo.’ ");
INSERT INTO lgl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Moses wale ba ioli 'i Israel gi gera barasi 'alia, ma gera ka sae 'uri 'e fala, ‘Ite 'e aalua ko 'ilitoa fafi 'amami, ma ko ura fala kwai lokomalatana famami?’ Lia God 'e kwatea mae 'ali ka 'ilitoa, ma ka lugasida failia kwairanaina faasia eniselo ba 'e fatae fala ala 'ai ba dunaa 'e 'agofia li. ");
INSERT INTO lgl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ma Moses ka talaia ioli Jiu gi faasia 'i Ejipt, ma ka fulia 'are mama'ala gi ma 'are li 'aferona 'alida gi 'i Ejipt, ma 'i laola asi gera soia ‘Asi Melamelaa,’ ma 'i laola abae lifi kwasi, sulia fai akwala fe nali gi. ");
INSERT INTO lgl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses lou ba 'e sae 'uri 'e fala ioli Israel gi, ‘God kae kwatea mae te profet 'i soemiu, malaa lia 'e 'e kwate lau mae 'i soemiu, ma 'i lia na wale mola 'ala, ala wale 'amiu gi.’ ");
INSERT INTO lgl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ma Moses ka io failia ioli 'i Israel ala logona ba 'i laola abae lifi kwasi li, ka io failia koko gia gi, ma failia eniselo ba alaa failia 'i gwaula uo ba 'i Saenae. Ma ka sakea lo faronona sulia maurina faasia God 'ali ka kwatea faga. ");
INSERT INTO lgl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Wasua ma koko gia gi, gera barasi rasua 'alia ronona sulia Moses. Ma gera ka abulo 'ada faasia, ma gera oga rasua olina fala 'i Ejipt. ");
INSERT INTO lgl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Talasi Moses 'e io 'ua gwaula uo li, gera ka sae 'uri 'e fala Aaron, ‘'O raunailia mae tali lului 'are malaa tali god famami, 'ali gera ka talai 'amami. Sulia 'ami raria lo ta 'e taua ma Moses, wale ba 'e talai 'amami mae faasia 'i Ejipt, ka dole mae gwaula fe uo lo ba.’ ");
INSERT INTO lgl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ma gera ka raunailia lo lului 'are lesinai malaa buluka fada fala foasinai, ma rauninala foasina gi fala, ma gera ka taua lo fanana gi fala faba'elanala 'are fo gera raunailia 'ada 'i talada gi. ");
INSERT INTO lgl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Dunala gera tau 'urifo, God ka abulo faasida, ma ka tafisida 'ali gera ka foasia lo 'ada da'afi, failia madama, ma kwalikwali gi 'i nali, malaa ba profet gi gera gerea 'uri 'e, ‘'Amiu ioli 'i Israel gi, iko 'ali 'amu raunia lou 'are mauri 'amiu gi, failia foasina 'amiu gi fagu sulia fai akwala fe nali ba 'amu io 'i laola abae lifi kwasi li. ");
INSERT INTO lgl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Babala 'e 'amu sakea fae 'amiu, 'are fala lului 'are Molok li. 'Amu sakea lou fae 'amiu lului 'are malaa kwalikwali gera soia 'alia Refan, 'i daroa lului 'are 'amu raunailida gi fala foasinada. Ma 'i osiala 'are fo gi, lau tabali 'amiu faasia 'i Israel ka dao tarosi fala falua 'i Babilon.’ ");
INSERT INTO lgl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Koko gia gi wasua, gera sakea lou Babala Abu God failida 'i laola abae lifi kwasi. Gera raunailia Babala Abu 'e sulia ta God 'e ilia ma ka fatailia fala Moses. ");
INSERT INTO lgl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","'I burila, koko gia gi gera ka sakea lo babala fo faasia mama gera gi. Talasi gera la failia Josua, gera sakea babala. Talasi fo God 'e tabalia ioli gi faasia wado gera gi, ma ioli Israel gi ka sakeda lo 'ada. Ma babala fo ka io 'i lififo, la la ka dao ala talasi David 'e walelitalona. ");
INSERT INTO lgl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ma God ka babalafe failia David, ma David ka sugaa God 'ali ala'alia 'ali lia ka raunailia ta luma fala God 'e Jakob 'e foasia. ");
INSERT INTO lgl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wasua ma Solomon 'ala 'e kae raunailia luma fala. ");
INSERT INTO lgl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Wasua ma God 'e 'ilitoa ka tasa, iko 'ali io 'i laola babala ioli gi gera raunailida. Malaa profet Aesea ba 'e gerea saenala God fala ioli Jiu gi 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘'I lau 'e lau 'ilitoa mae 'i nali fafia 'are gi sui, failia molagali 'e lifi fala alunala 'aegu ai. Iko 'ali 'amu totolia 'ali 'amu ka raunailia ta luma 'e 'oka ka malaa lifi 'e lau io ai. Ma iko 'ali 'amu totolia 'amu ka raunailia ta luma 'e ba'ela ka totolia 'ali lau io 'i laola. ");
INSERT INTO lgl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sulia 'i lau 'e lau raunailia 'are 'e gi sui 'i nali ma 'i laola molagali.’” ");
INSERT INTO lgl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ma Stefen ka sae lou 'uri 'e, “Wasua 'i 'amiu ioli Jiu gi li, manomiu 'e nasi ka malaa 'ala ioli 'e iko 'ali gera oga ronona sulia God gi, ma manomiu ka rodo. 'Are la 'e kwatea ma iko 'ali 'amu oga rononala ma rononasulia saenala God. 'Amu malaa lo koko 'amiu gi, dunala 'amu mailia lou fala sunenena ala Aloe 'are Abu li. ");
INSERT INTO lgl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Koko 'amiu gi gera malakwaita ala profet gi sui. Sulia lia ba gera raunia wale li fatalona God gi 'i lao mae, lia gera faarono 'alia laanala mae Christ, wale ba God 'e filia fala faamurinala ioli lia gi li. Ma talasi 'e, 'amu ka kwate lia fala malimae lia gi, ma 'amu ka raunia ka mae. ");
INSERT INTO lgl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ma 'i 'amiu ba 'amu sakea lo taki God gi lia ba eniselo gi gera kwateda mae famiu, wasua ma iko 'ali 'amu rono mola sulida!” ");
INSERT INTO lgl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ma talasi wale etaeta gi 'i laola logona fo gera ronoa Stefen, malatada ka nene rasua, ma gera ka 'alaniriniri fala, sulia gera ogata'a rasua fala. ");
INSERT INTO lgl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ma 'i osiala Aloe 'are Abu 'e sura lo ala Stefen, 'i lia ka lio ala ala fala 'i nali, ma ka lesia God 'ilitoa ma ka nanata, ma ka lesia lou Jesus 'e ura ala gula lima aolo ala God ma ka 'ilitoa failia. ");
INSERT INTO lgl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ma Stefen ka sae 'uri 'e, “Lio ga! Lau lesia falua 'i nali 'e tafa, ma Wela Wale li ka ura 'i gula lima aolo ala God!” ");
INSERT INTO lgl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ma talasi wale etaeta gi gera ronoa me 'are fo li, gera ka bolosia lo aninada, ma gera ka rii ba'ela, ma gera ka lalaofia lo ");
INSERT INTO lgl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ma gera ka usulailia fala 'i maluma faasia 'i laola falua, ma gera ka fuli'ae lo ala 'uinala 'alia fau gi. Ma wale fo gera 'uia Stefen 'alia fau gi li, gera ka kalasua to'omi gera gi, ma gera ka aluda 'i 'aela te ulufa'alu la ratala Saul, 'ali gera ka abitakwa fala 'uinala. ");
INSERT INTO lgl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ma talasi gera 'uia, Stefen ka foa 'uri 'e, “Jesus Aofia lau, 'o sakea lo manogu.” ");
INSERT INTO lgl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma ka boururu 'i wado, ma ka sae ba'ela 'uri 'e, “Aofia, 'o kwailufa 'alida fafia rauninagu!” Buri 'ala 'e ilia 'are fo gi sui, ka mae lo. ");
INSERT INTO lgl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ma Saul ka alafafia maenala Stefen. Ma nali wale fitoona gera gi 'e nanata, gera sakea rabela Stefen, ma gera ka alomia, ma gera ka aani rasua failia. Ma ala fe atoa fo lou, ioli fitoo gi 'i Jerusalem gera fuli'ae geraka ruu lo 'i laola malakwaitana ba'ela rasua. Ma ioli gera fito gi sui gera ka keta sui lo fala falua laola provins 'i Judea gi ma 'i Samaria lou. Wasua ma waleli lifurono gi iko. ");
INSERT INTO lgl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saul ka tau nanata rasua fala fafuta'anala ioli fakwalaimoki gi. Ma ka ruu 'i laola luma gi fala daunala nalife ioli gera fakwalaimoki ala Jesus, wale gi failia geli gi lou, ma ka aluda 'i laola raraa. ");
INSERT INTO lgl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ma ioli fo gera fakwalaimoki gi, gera ka keta kwailiu ala falua gi sui. Ma talasi gera liu ko, gera ka faatalo 'alia Faronona 'Oka sulia Jesus. ");
INSERT INTO lgl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip ka la fala te mae falua ba'ela 'i laola gulae tolo 'i Samaria, ma ka faatalo 'alia Jesus wale faamauri, fala ioli gi 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Talasi ioli 'i lififo gi gera ronoa lo saenala Filip, ma gera ka lesia lou 'are mama'ala 'e fulida gi, gera ka fafurono kwalaimoki fala 'are Filip 'e ilida gi. ");
INSERT INTO lgl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sulia 'e balia aloe 'are ta'a gi faasia ioli afula gi, ma gera ka rii ba'ela, ala talasi gera latafa faasida. Ma ioli rabeda ka mae gi, ma ioli 'aeda mae gi, lia 'e gurada sui. ");
INSERT INTO lgl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ma ioli 'i Samaria gi, gera ka babalafe rasua failia. ");
INSERT INTO lgl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ma 'i laola falua fo, te wale 'e io lou lia ratala Simon, ma ka tekwa lo mae 'e faa 'aferoa ioli 'i Samaria gi 'alia galona 'e taua 'alia 'are malaana 'ilu lialia maka abalii. Ma gera ka ilia 'i lia na wale 'ilitoa rasua. ");
INSERT INTO lgl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ma ioli gi sui 'i laola falua fo, wale ba'ela gi, ma ke wela wawade gi lou, gera ka fafuronosia, ma gera ka ilia 'i lia wale 'e too ala nanatana faasia God, ma gera ka soia 'alia “Nanatana Ba'ela.” ");
INSERT INTO lgl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gera dona ka tekwa lo mae lia ka taua galona fo gi 'alia 'ilu lialia ma ka abalii wai. ");
INSERT INTO lgl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wasua ma ala talasi gera ronoa Filip 'e sae sulia Faronona 'Oka sulia 'Ilitoana God ma Jesus Christ li, gera ka fakwalaimokia, ma gera ka sisiu abu, wale gi failia geli gi lou. ");
INSERT INTO lgl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon wasua ka fakwalaimoki lou, ma ka sisiu abu. 'I burila, ka la lo failia Filip fala lifi 'e la fai. Ma talasi 'e lesia Filip 'e fulia 'are mama'ala gi li, failia 'are li 'aferona 'alida gi, 'i lia ka 'afero rasua. ");
INSERT INTO lgl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Waleli lifurono gera io 'i Jerusalem gi, ala talasi fo gera ronoa ioli 'i Samaria gi gera fakwalaimoki lou ala saenala God, gera ka keria Peter failia John daro ka la ko 'i soeda. ");
INSERT INTO lgl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Talasi daro li dao, daro ka foa fala ioli gera fakwalaimoki gi, 'ali gera ka too ala Aloe 'are Abu. ");
INSERT INTO lgl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Aloe 'are Abu iko 'ali sifo 'ua fafia nali ioli ada, ala talasi 'i gera sui gera sisiu abu lo, sulia gera fakwalaimoki lo ala Jesus. ");
INSERT INTO lgl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","'Urifo Peter failia John, daro ka alu limadaroa 'i fafida, bui gera ka bi too lo ala Aloe 'are Abu. ");
INSERT INTO lgl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ala talasi fo, Simon 'e lesia waleli lifurono gi daro alua limadaroa fafida, ma Aloe 'are Abu ka sifolida lo, 'i lia ka sakea seleni ka tau fala kwatenai fala Peter failia John, ");
INSERT INTO lgl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ka sae 'uri 'e, “Mora kwatea lou nanatana laa fagu, 'ali ala laka alua wasua limagu 'i fofola ta ioli, ioli la kae too lou ala Aloe 'are Abu.” ");
INSERT INTO lgl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Wasua ma Peter ka olisia 'uri 'e, “'O lonolae 'o, 'e totolia seleni 'o fae'o mora ka fulu, sulia 'o fia 'uria kwatena God 'are fala folinai 'alia bata li. ");
INSERT INTO lgl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Iko 'ali 'o totolia mola galona fae 'ameulu, sulia malatamu 'e iko 'ali rada 'i maala God. ");
INSERT INTO lgl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","'O bulusi faasia malata ta'a 'e 'o gi, ma ko foasia God 'ali 'e kwailufa 'alia malata ta'a 'o gi. ");
INSERT INTO lgl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sulia lau lesia 'o 'uga ka ta'a rasua, ma ko io 'alia guluguluna 'i malula ta'ana.” ");
INSERT INTO lgl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sui Simon ka sae 'uri 'e fala Peter failia John, “Mora foasia God ka rana lau, 'ali 'are 'e mora ilida gi ikoso dao agu.” ");
INSERT INTO lgl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","'I burila, Peter failia John daro alaa sulia ta gi daro saiai sulia Jesus, ma daro ka sae sulia saenala Aofia. Sui daro ka oli fala 'i Jerusalem. Ma ala Olinadaroa, daro ka faatalo 'alia Faronona 'Oka ala mae falua afula gi 'i Samaria. ");
INSERT INTO lgl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ma te eniselo Aofia ka alaa 'uri 'e fala Filip, “'O rerei, ko la sulia tala 'e fuli 'i Jerusalem ka lao fala maala ara li fala 'i Gasa ka liu 'i laola abae lifi kwasi iko 'ali totolia ta ioli 'ali io ai.” ");
INSERT INTO lgl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ma Filip ka rerei, ma ka la. Ma te wale 'ilitoa faasia 'i Etiopia ka la lou mae sulia tala fo, kae oli lo fala falua lia. Wale fo, 'e lio sulia bata gelilitalona 'i Etiopia. 'E io mae 'i Jerusalem fala foasinala God, sui kae oli lo 'i falua 'i laola 'are li lalana lia hosi 'e taraa. Ma talasi kae la 'ala, 'e gwauru ka idumia buka profet Aesea 'e gerea. ");
INSERT INTO lgl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Mola Aloe 'are Abu ka sae 'uri 'e fala Filip, “'O la garania wale lobaa.” ");
INSERT INTO lgl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ma Filip ka lalao ko 'i so'ela, ma ka ronoa kae idumia buka profet Aesea, ma ka soilidia 'uri 'e, “'O saiala 'are laa koe idumia?” ");
INSERT INTO lgl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ma wale 'ilitoa fo ka olisia 'uri 'e, “'Uri'e ma lakae sai 'utaa ai, ala ikoso ta ioli 'ali faamadakwa lau 'alia?” Ma ka soia mae Filip, 'ali ka rae ko 'i so'ela ma ka gwauru failia. ");
INSERT INTO lgl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Geregerena Abu 'e idumia, 'e sae 'uri 'e, “Ioli gi gera talaia fala rauninala, malaa sipsip gera talaia fala rauninai, ma iko 'ali ilia mola ta saena, ma ka malaa lo kale sipsip 'e io aroaro talasi gera suufia ifula. ");
INSERT INTO lgl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ma gera ka dorakwala fala, ma gera ka lokokwaikwaina fala 'alia kotona gi. Ma 'i lia iko 'ali too ala ta kwalofa, sulia gera raunia ka mae.” ");
INSERT INTO lgl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Mola wale 'ilitoa fo ka sae 'uri 'e fala Filip, “Faarono lau ga mae, 'uri 'e ma ite 'e profet 'e sae sulia? Suli 'i lia talala, 'o ma sulia ta wale mamata 'ala?” ");
INSERT INTO lgl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ma Filip ka fuli'ae ka alaa fala sulia Faronona 'Oka sulia Jesus, 'e fuli'ae ala Geregerena Abu fo. ");
INSERT INTO lgl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ma talasi daro la sulia tala li, daro ka liu 'i totolala te mae kwai. Ma wale 'ilitoa fo ka sae 'uri 'e fala Filip, “Kwai 'e mola lo, fasiu abu lau lo.” ");
INSERT INTO lgl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Sui wale 'ilitoa fo ka ilia 'ali hosi lia ka mano, ma Filip daro ka sifo 'i laola kwai, ma Filip ka fasiuabua lo. ");
INSERT INTO lgl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ala talasi daro rae mae faasia kwai li, Alo ala God 'e la mae ka laua lo Filip. Wasua wale 'ilitoa fo iko 'ali lesia lo Filip, 'e la lo 'ala failia babalafena ba'ela. ");
INSERT INTO lgl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ma Filip ka dao lo 'i Asotus, ma ka liu 'i laola mae falua fo gi failia faalalauna 'alia Faronona 'Oka li ala falua fo gi, la la ka dao ala falua 'i Sesarea. ");
INSERT INTO lgl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma talasi fo lou, Saul ka tau nanata failia alaana naunau lia gi fala rauninala waleli galona Aofia gi li. Ma ka la 'i so'ela 'ilito'ola fata abu, ");
INSERT INTO lgl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma ka sugaa 'ali ka gerea ta alaana fala wale etaeta gi ala luma fala foana gi li 'i Damaskas, 'ali gera ka ala'alia 'ali lia ka lio 'afia ioli gera fakwalaimoki ala Aofia gi li, ma ala ka dao tonada, ta wale 'o ma ta geli 'urifo, kae dauda, ma ka oli mae failida fala 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ma talasi kae la fala 'i Damaskas, ma ka li dao garania lo ko falua li, toraa ma kwana faasia 'i laola raloo li 'e rara lo 'afuia. ");
INSERT INTO lgl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ma ka toli 'i wado, ma ka ronoa te line 'are 'e sae 'uri 'e fala, “Saul, Saul! 'Uta 'e ko malakwaita agu?” ");
INSERT INTO lgl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sui Saul ka olisia 'uri 'e, “Arai, 'i'o ite 'e?” Ma line 'are fo ka olisia 'uri 'e, “'I lau Jesus, wale 'e koe malakwaita ala. ");
INSERT INTO lgl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","'O tatae, ko la 'i falua, ma gerakae farono 'o 'alia ta koe taua.” ");
INSERT INTO lgl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ma wale gera la failia Saul gi, gera ka ura aroaro, ma iko 'ali gera ilia lo ta 'are, gera ronoa line 'are fo, wasua ma iko 'ali gera lesia mola ta ioli. ");
INSERT INTO lgl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sui Saul ka tatae mae, ma ka kwarua maala, wasua ma iko 'ali lesia mola ta 'are. Ma gera ka dau ala limala, gera ka talaia fala 'i Damaskas. ");
INSERT INTO lgl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ma Saul iko 'ali lesia lo ta 'are, sulia maala 'e rodo sulia olu fe atoa gi. Ma sulia olu fe atoa fo gi lou, iko 'ali 'ania ta me fana, ma iko 'ali goufia lou ta me kwai. ");
INSERT INTO lgl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ma na waleli galona Jesus lou ratala Ananias, 'i lia 'e io lou 'i Damaskas, ma ka lesia Aofia ala fataena. Ma Aofia ka sae 'uri 'e fala, “Ananias!” Ma Ananias ka olisia 'uri 'e, “Aofia, 'i lau 'e.” ");
INSERT INTO lgl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Aofia ka sae 'uri 'e fala, “'O rerei, ko la fala tala 'e gera soia 'alia ‘Tala Rada,’ ma ko la fala luma Judas, ko soilidi 'afia te wale faasia 'i Tarsus ratala Saul. 'I lia kae foa 'ala 'i lififo, ");
INSERT INTO lgl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ma 'i lia kae lesi'o 'alia fataena, lia 'e koe la 'i so'ela, ma koe alua limamu fafia, 'ali rua maala gi ka lio lou.” ");
INSERT INTO lgl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sui Ananias ka olisia 'uri 'e, “Aofia, ioli afula gi gera faarono lau sulia wale 'e ma 'are ta'a afula 'e taua fala ioli 'o gi 'i Jerusalem. ");
INSERT INTO lgl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma ka la lo mae 'i lifi'e 'i Damaskas, 'ali kae daua ioli gera foasi 'o gi, sulia fata abu ba'ela gi gera ala'alia fala.” ");
INSERT INTO lgl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Wasua ma Aofia olisia ka sae 'uri 'e fala, “'O la 'amua, sulia lau filia lo 'ali kae galo 'agua, ma ka faatalo sulia lau fala ioli 'e iko lou ioli Jiu gi li, failia walelitalona gera gi, ma fala ioli 'i Israel gi lou. ");
INSERT INTO lgl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma 'i lau talagu lakae fatailia fala ta gi 'i lia kae famalifii 'alida ala talasi kae faatalo 'ali lau.” ");
INSERT INTO lgl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","'Urifo Ananias ka la, ka ruu 'i laola luma fo, ma ka alua limala fafia Saul, ma ka sae 'uri 'e, “Walefae lau Saul Jesus Aofia 'i talala 'e keri lau mae. 'I lia ba 'e fatae famu sulia tala, ala talasi ba 'o la mae 'i lifi'e li. Lia 'e 'e keri lau mae, 'ali ko lio lou, ma ko too ala Aloe 'are Abu.” ");
INSERT INTO lgl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ma nainali mola 'are malaa na ulaulala ia li ka toli faasia maala Saul, ma ka lio lou. Sui ka tatae, ma ka sisiu abu. ");
INSERT INTO lgl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ma 'i burila 'e fana ka sui lo, rabela ka bi nanata lou. Ma Saul ka io failia waleli galona gi 'i Damaskas sulia barae fe atoa. ");
INSERT INTO lgl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma ka la nainali fala luma fala foana li, ma ka fuli'ae ala alaana sulia Jesus 'uri 'e, “'I lia lo Wela God.” ");
INSERT INTO lgl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ma ioli gera ronoa gi, gera ka kwele rasua, ma gera ka soilidi kwailiu 'i safitada 'uri 'e, “Wale 'e ba 'e io io 'i Jerusalem, ma ka raunia wale gera foasia Jesus gi. Ma 'e la lo mae 'i lifi'e, 'ali kae dauda, ma ka talaida 'i so'ela fata abu ba'ela gi.” ");
INSERT INTO lgl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","God ka faramoramoa Saul, ma saenala ka nanata rasua. Ma Saul ka fatailia Jesus 'i laola Geregerena Abu lia 'e 'i lia wale God 'e filia. Ma ka 'urifo, ioli Jiu gera io 'i Damaskas gi, gera ka raria lo olisinala 'alia ta 'are. ");
INSERT INTO lgl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","'I burila fe atoa afula gi 'e sui, wale Jiu gi gera ka logo fala lokomalata na fala rauninala Saul. ");
INSERT INTO lgl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sulia atoa ma boni, gera ka lio folo bolosia maala labu ala falua fo li 'ali gera ka raunia. Wasua ma Saul 'e ronoa malata gera gi. ");
INSERT INTO lgl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ma ala na fe boni, waleli galona lia gi gera sakea, gera ka fasifoa 'i laola te 'ite ba'ela fala 'i maluma sulia mae kwakwana ala balibali ala labu gera 'uia galia 'alia falua fo li. ");
INSERT INTO lgl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ma Saul ka la 'i Jerusalem, ma ka mailia fala logona failia ioli gera fakwalaimoki ala Jesus gi. Ma iko 'ali gera fakwalaimoki ala 'uri 'i lia na wale li galona lou ala Jesus, ma gera ka mau 'alia. ");
INSERT INTO lgl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mola Banabas ka la mae, ka talaia 'i so'ela waleli lifurono gi, ma ka faarono gera 'alia lia 'e Saul 'e lesia Aofia sulia tala li, ma Aofia ka alaa lou fala. 'Urifo ka faarono daulu lou 'alia Saul 'e sae ramoramoa sulia Jesus 'i Damaskas. ");
INSERT INTO lgl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ma gera ka bi fakwalaimokia, ma Saul ka bi io lo failida, ma ka liu 'i laola 'afutala 'i Jerusalem, ma ka sae ramoramoa sulia Jesus. ");
INSERT INTO lgl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma ka sae ma ka olisusu failia wale Jiu gi lia gera sae 'alia saena Grik li, ma gera ka mailia fala rauninala. ");
INSERT INTO lgl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ma talasi ioli gera fakwalaimoki gi gera ronoa 'are fo li, gera ka talaia Saul fala 'i Sesarea, ma gera ka kwatea fala 'i Tarsus. ");
INSERT INTO lgl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ma ioli fakwalaimoki gi 'i laola gulae tolo 'i Judea, ma 'i Galili, ma 'i Samaria gi, gera ka bi io lo 'alia aroarona ala talasi fo. Ma logonae ioli fakwalaimoki fo ka nanata, ma ka ba'ela lou 'alia ioli afula gi gera fakwalaimoki. 'E 'urifo, sulia Aloe 'are Abu 'e kwairanai ada, ma gera ka fa'atoa Aofia. ");
INSERT INTO lgl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ma Peter ka la ala mae falua afula gi, ma ala te talasi ka la 'i Lida 'ali ka maa tonala ioli God gi lia gera io 'i laola mae falua fo li. ");
INSERT INTO lgl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ma 'i lififo, ka dao tonala te wale la ratala Aeneas, rabela 'e mae, ma iko 'ali tatae lo faasia tafe lia sulia kwalu fe nali gi. ");
INSERT INTO lgl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma Peter ka sae 'uri 'e fala, “Aeneas, Jesus Christ 'e gura 'o lo ala talasi 'e. 'O tatae, ko laumia tafe 'o.” Ma nainali mola Aeneas ka tatae lo. ");
INSERT INTO lgl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ma ioli gi sui lia gera io 'i Lida ma 'i Saron, gera lesia, ma gera ka fakwalaimoki ala Aofia. ");
INSERT INTO lgl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ala falua 'i Jopa, te geli 'e fakwalaimoki, 'e io lou 'i lififo, lia ratala Tabita. (Ala saena 'i Grik 'i lia Dorkas.) Lia 'e taua 'are 'oka afula rasua gi, ma ka kwairanai rasua lou ala ioli gera siofa gi. ");
INSERT INTO lgl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ma talasi fo, 'e matai, ma ka mae. Ma geraka saua rabela ka sui, gera ka 'afua, ma gera ka sakea fala mae tobi 'i nali, ma gera ka alua 'i lififo. ");
INSERT INTO lgl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ma falua 'i Jopa iko 'ali tatau mola faasia 'i Lida, ma ala talasi ioli gera fakwalaimoki gi gera ronoa Peter 'e io 'i Lida, gera ka keria rua wale gi 'i so'ela failia me alaana 'uri 'e, “'O la nainali mae 'i soemeulu.” ");
INSERT INTO lgl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","'Urifo Peter ka la fae daroa. Ma talasi 'e dao ai, gera ka talaia fala mae tobi 'i nali. 'Oru gi sui mola fo gera logo 'i so'ela Peter 'i lififo, ma gera ka ani. Ma gera ka fatailia toro afula gi lia geli fo 'e taida ala talasi 'e mauri 'ua ai. ");
INSERT INTO lgl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Sui Peter ka keri gera sui, gera ka latafa faasia mae tobi fo, ma ka boururu ka foa. Sui ka bulusi fala rabe 'are fo, ka sae 'uri 'e fala, “Tabita, 'o tatae.” Ma geli fo ka kwarua lo maala, ma talasi 'e lio ko, ka lesia Peter, ma ka tatae ka gwauru. ");
INSERT INTO lgl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ma Peter ka dau ala limala, ma ka ranaa ka tatae ka ura. Sui Peter ka soia mae me 'oru ba gi, failia ioli gera fakwalaimoki gi, ma ka fatailia Dorkas lia 'e mauri lo. ");
INSERT INTO lgl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Saena sulia me 'are fo li ka talofia 'afutala falua 'i Jopa sui, ma ioli afula gi gera ka fakwalaimoki lo ala Aofia. ");
INSERT INTO lgl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma Peter ka io 'i Jopa sulia fe atoa afula gi failia wale la ratala Simon, wale fo galonala fala galo 'are na 'alia sunasunala buluka gi li. ");
INSERT INTO lgl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ma te wale 'i Sesarea ratala Kornelius, wale etaeta ala wale li ofona 'i Rom gi li lia 'e gera soia 'alia “Logonae wale 'i Itali.” ");
INSERT INTO lgl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","'I lia wale 'e fa'ilitoa God, ma ka 'itooli foasia mola 'ala. 'I lia failia ioli 'i laola luma lia gi li sui gera foasia God, ma ka tau 'are afula 'oka gi fala rananala ioli siofa Jiu gi li lou. ");
INSERT INTO lgl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ma ka totolia olula tofui matola 'i raurafi ala na fe atoa, 'i lia ka lesia te fataena 'e fatae madakwa ala eniselo God 'e la mae, ma ka sae 'uri 'e fala, “Kornelius!” ");
INSERT INTO lgl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ma 'i lia ka alua lo maala ala eniselo fo, ma ka mau, ma ka sae 'uri 'e, “Wale ba'ela lau, taa 'o oga?” Ma eniselo fo ka olisi 'uri 'e ala, “God 'e babalafe rasua fae'o, ma ka alafafia foana 'o gi failia galona 'oka 'e 'o tauda fala rananala ioli siofa gi li, ma God kae kwaiara 'o duunali. ");
INSERT INTO lgl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ala talasi 'e lo, 'o kwatea tali wale gera ka la fala 'i Jopa 'ali daulu soia mae te wale la ratala Simon Peter. ");
INSERT INTO lgl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","'E io 'i laola luma te wale galo ala sunasunala 'are ala buluka gi li, ratala Simon lia ba luma lia 'e io sulia asi.” ");
INSERT INTO lgl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Eniselo fo 'e alaa 'urifo fala ka sui, ka la lo 'ala. Ma Kornelius ka soia mae rua wale gi ala wale gera galo 'i laola luma lia gi li 'i so'ela, failia teke wale ala wale li ofona lia gi, wale fo lou 'e foasia God. ");
INSERT INTO lgl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ma ka faarono daulu 'alia me 'are fo 'e lesia ma ka ronoa. Sui ka keri daulu fala 'i Jopa. ");
INSERT INTO lgl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ala fe atoa 'i buri, talasi wale fo gi daulu la 'ua ko, ma daulu ka garani dao lo ala mae falua 'i Jopa, ala talasi fo Peter 'e rae 'i fofola luma, 'ali ka foa 'i matoula atoa. ");
INSERT INTO lgl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ma 'e fiolo, ma ka oga ka fana. Ma talasi gera rerei 'ua 'alia fana gi li, 'i lia ka lesia te fataena. ");
INSERT INTO lgl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","'E lesia 'i nali 'e tafa, ma ka lesia 'are malaa abae toro afola gera fasifoa mae 'i wado 'i laola molagali, ma lesinai 'e malaa ta wale 'e dau ala fai susua ai gi. ");
INSERT INTO lgl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ma 'i laola abae toro fo 'are mauri gi, ma 'are too 'a'ae gi, 'are anoano gi, failia malu kwasi gi. 'Are fo gi, taki Moses 'e luia ikoso ta ioli 'ali 'ani'anida. ");
INSERT INTO lgl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Sui ka ronoa te line 'are ka sae 'uri 'e fala, “Peter, tatae, ko raunida, ma ko 'anida.” ");
INSERT INTO lgl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma Peter ka olisia ka sae 'uri 'e, “Aofia, 'ato rasua, sulia iko 'ali lau 'ani'ania ta 'are 'e 'uli'uli ma ka midia.” ");
INSERT INTO lgl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","'Urifo line 'are fo ka sae lou 'uri 'e fala, “Ikoso soi 'uli'uli ma midia ala ta 'are God 'e ilia 'e 'oka, ma ka kwaga fala 'aninai.” ");
INSERT INTO lgl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Olu talasi gi fo 'are fo 'e fatae 'urifo ka sui, gera ka olifailia lou 'ada abae toro fo failia 'are gi sui fala 'i nali. ");
INSERT INTO lgl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ma Peter ka malata sulia malutala fataena fo 'e lesia. Ma talasi fo lou, wale ba Kornelius 'e kerida mae gi, gera ka soilidi 'afia luma Simon, ma daulu ka dao lo 'i maala 'olofolo. ");
INSERT INTO lgl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ma daulu ka soilidi 'uri 'e, “'Uri'e ma te wale ratala Simon Peter 'e io 'i lifi'e?” ");
INSERT INTO lgl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ma talasi fo, Peter kae malamalata 'ua mola 'ala sulia fataena fo 'e lesia, sulia 'e oga ka saiala malutala. Ma Aloe 'are Abu ka sae 'uri 'e fala, “Fafurono ga, olu wale gi daulu dao 'i lifi'e, ma daulu kae lio 'afi'o. ");
INSERT INTO lgl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tatae, ko sifo 'i soedaulu, ma ikoso malata ruarua fala laa na faedaulu, sulia 'i lau lo lau kerida mae.” ");
INSERT INTO lgl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Sui Peter ka sifo ko 'i soedaulu, ka sae 'uri 'e, “'I lau lo wale la moulu kae lio 'afia. 'Uri'e ma moulu la mae 'utaa 'e?” ");
INSERT INTO lgl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Daulu ka olisia daulu ka sae 'uri 'e, “Kornelius wale etaeta ala wale li ofona gi li lo 'e keri 'ameulu mae. 'I lia wale 'oka, ma ka foasia lou God. Ma ioli 'i Jiu gi sui gera ka soi ba'ela rasua ala. Ma te eniselo God ka ilia fala 'ali ka soi 'o fala luma lia, ma 'ali ka ronoa ta lo koe ilia.” ");
INSERT INTO lgl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ma Peter ka kwaloa ko wale fo gi 'i luma 'e io ai, 'ali daulu ka mo'osu ga failia ala fe boni fo. Sui 'ofaedani ala ruala fe atoa, Peter ka rerei, ma ka la failidaulu ma failia nali wale lou 'i Jopa gera fakwalaimoki. ");
INSERT INTO lgl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ala fe atoa 'i buri, gera ka dao lo 'i Sesarea, lifi ba Kornelius 'e maasia ai. Ma walefae lia gi, failia iolifuta gi, ma wale kwaima lia gi lia 'e kwaloda mae, gera ka maasia lou Peter 'i soela Kornelius. ");
INSERT INTO lgl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ma talasi Peter 'uri kae ruu mola ko, Kornelius ka dao tonala, ma ka toli 'i maala 'aela Peter, ma ka faa aofia. ");
INSERT INTO lgl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Wasua ma Peter ka taea ka sae 'uri 'e, “'O tatae, sulia 'i lau 'e wale malaa 'i'o mola lou 'e.” ");
INSERT INTO lgl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ma Peter ka alaa failia Kornelius, ma daro ka ruu lo ko 'i laola luma. Ma ka lesia ioli afula rasua gi gera logo. ");
INSERT INTO lgl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ma ka sae 'uri 'e fada, “'Amiu 'amu sai 'oka lo ai sui lia 'e taki 'amami Jiu gi li, 'e luia ikoso 'ali 'ami ruu 'i laola luma 'amiu gi, ma ikoso 'ali 'ami galo 'are ruru fae 'amiu ioli mamata faasia Jiu gi li. Wasua ma God 'e fatailia fagu ikoso 'ali lau soia ta ioli 'alia ioli midia ma ka 'uli'uli. ");
INSERT INTO lgl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","'Are la 'e kwatea ma laka la mae ala talasi 'e 'o faisoi mae fagu, ma iko 'ali lau la mae failia ta malata ruaruana. 'Urilali lakae soilidi 'amiu, 'utaa 'e 'amu ka suga lau 'ali lau la mae?” ");
INSERT INTO lgl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelius ka olisia 'uri 'e, “Fai fe atoa gi sui lo ko, lau foa 'agua 'i luma lau ala olula tofui matola 'i raurafi, ma toraa ma te wale 'e toro 'alia to'omi wasinosino, 'e ura lo 'i laoagu, ");
INSERT INTO lgl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ma ka sae 'uri 'e, ‘Kornelius, God 'e ronoa foana 'o gi, ma ka lesia galona 'oka 'o gi ala rananala ioli siofa gi li. ");
INSERT INTO lgl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","'O kwatea ta wale ka la 'i Jopa 'ali kae soia mae te wale la ratala Simon Peter. 'E io failia Simon, wale ba kae galo ala sunasunala buluka gi li, ma luma lia 'e io sulia ole sulia asi li.’ ");
INSERT INTO lgl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Lia fo, lau nainali laka suga 'o mae. Ma 'e 'oka rasua lia 'e 'o la mae. 'Eo, God 'e io fae golu sui, ma 'ami ka faimaasi fala rononala ta taa God 'e oga koe ilia.” ");
INSERT INTO lgl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Peter 'e alaa ma ka sae 'uri 'e, “Lau sai 'oka ala God 'e lesia ioli gi sui ka rada mola 'ala, ma iko 'ali 'e sofili 'i matanala ioli gi. ");
INSERT INTO lgl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ma ta ioli mola 'ala 'e soi ba'ela ala God, ma ka taua 'are rada gi, 'i lia lo ioli God kae kwaloa, wasua ta kwalofa ta 'e la mae faasia. ");
INSERT INTO lgl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Lau saiai 'amu rono lo ala Faronona 'Oka ba God 'e kwatea fala Jiu gi li, faronona 'oka sulia 'ado na 'alia aroaro na li failia God lia 'e la mae 'alia Jesus Christ wale 'e Aofia fala ioli gi li sui. ");
INSERT INTO lgl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","'Amu ka sai lou ala lia ba 'are ba'ela gi gera fuli 'i Israel, fuli'ae mae 'i Galili, 'i burila talasi ba John 'e faalalaua ioli gi 'ali geraka bulusi faasia ta'ana gera gi ma geraka sisiu abu. ");
INSERT INTO lgl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ma 'amu ka sai lou ala Jesus wale 'i Nasareti, ma 'amu ka sai lou ala lia 'e God 'e kwatea Aloe 'are Abu failia nanatana fala. Jesus ka la ala lifi afula gi, ma ka taua 'are 'oka gi, ma ka guraa ioli gera io 'i malula nanatanala Saetan gi. Jesus 'e taua 'are fo gi, 'i dunala God 'e io failia. ");
INSERT INTO lgl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","'Ami lesia 'are fo Jesus 'e fulida 'i Israel ma 'i Jerusalem gi. Sui gera ka raunia ka mae 'alia fotoinala ala 'ai rara folo. ");
INSERT INTO lgl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Wasua ma, God 'e taea faasia maena ala olula fe atoa, ma ka fatae lia fameulu. ");
INSERT INTO lgl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Iko 'ali 'e fatae lou fala ioli gi sui, 'e fatae mola fameulu ioli God 'e fili 'ameulu gi meulu ka lesia, ma meulu ka soi lalamaa ala. Ma 'i 'ameulu meulu fana ma meulu ka gou failia 'i burila 'e tatae faasia maena. ");
INSERT INTO lgl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma 'i lia ka sae nasi 'alia fameulu, 'ali meulu ka sae fakwalaimokia ma meulu ka faatalo 'alia Jesus wale God 'e filia 'ali ka lokokwaikwaina fala ioli mauri gi failia ioli gera mae lo gi. ");
INSERT INTO lgl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ma profet gi sui lia 'e gera sae sulia Christ, wale 'e God 'e filia fala faamurinala ioli lia gi li. Profet gi gera ka ilia ioli gera fakwalaimoki ala gi, God kae kwailufa 'alia ta'ana gera gi, 'i fofola 'are Christ 'e taua fada.” ");
INSERT INTO lgl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ma talasi Peter kae alaa mola 'ala 'ua, Aloe 'are Abu ka sifo fafia ioli fo gera fafuronosia saenala gi. ");
INSERT INTO lgl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ma ioli Jiu fo gera fakwalaimoki ala Jesus ma gera ka la mae faasia 'i Jopa failia Peter gi, gera ka kwele rasua, sulia God 'e kwate gwaugwau lo ala Aloe 'are Abu fafia ioli mamata faasia Jiu gi li lou. ");
INSERT INTO lgl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Gera ronoa ioli mamata faasia Jiu gi li, gera sae lou 'alia saena mamata gi, ma gera ka faa 'ilitoa God. Ma Peter ka sae 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Ioli 'e gi gera too lou ala Aloe 'are Abu malaa lou 'i 'ameulu. Ma iko ta ioli 'ali totolia ka luida faasia siuabunada 'alia kwai.” ");
INSERT INTO lgl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ma Peter ka ilia gera ka sisiu abu lo, sulia gera fakwalaimoki ala Jesus Christ. Sui gera ka sugaa 'ali ka io lou failida sulia ta barae fe atoa. ");
INSERT INTO lgl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Waleli lifurono gi failia ioli gera fakwalaimoki gera io 'i Judea gi, gera ronoa ioli mamata faasia Jiu gi li gera fakwalaimoki lou ala saenala God. ");
INSERT INTO lgl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ma talasi Peter failia olo wale fakwalaimoki gi daulu li dao 'i Jerusalem faasia 'i Sesarea, ioli Jiu gera fakwalaimoki ala Jesus gi, gera ka balufia Peter, ");
INSERT INTO lgl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","gera ka sae 'uri 'e, “'O ruu 'i laola luma ioli mamata faasia Jiu gi li, ioli iko 'ali gera 'ole wale gi, ma ko fana failida!” ");
INSERT INTO lgl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ma Peter ka alaa sulia 'are 'e fuli gi sui fada 'uri 'e, ");
INSERT INTO lgl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ala talasi lau io ala falua 'i Jopa li, lau foa, ma laka lesia te fataena. Lau lesia 'are malaa abae toro afola gera fasifoa mae faasia 'i nali, malaa nali wale gera dau ala fai susua ai gi, ma ka sifo mae 'i soegu. ");
INSERT INTO lgl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ma laka lio 'i laola, ma laka lesia 'are mauri 'i laola wado gi li, 'are too 'a'ae gi, 'are anoano gi, failia malu kwasi gi. ");
INSERT INTO lgl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","'Urifo, laka ronoa line 'are ka sae 'uri 'e fagu, ‘Peter tatae, ko raunida, ma ko 'anida!’ ");
INSERT INTO lgl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ma laka sae 'uri 'e, ‘Aofia, 'ato rasua mola, sulia iko 'ali lau 'ani'ania 'ua ta 'are 'e 'uli'uli ma ka midia, 'are la gi taki Moses 'e luida ikoso ta ioli 'ali 'anida.’ ");
INSERT INTO lgl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Sui line 'are fo faasia 'i nali ka sae lou 'uri 'e, ‘Ikoso soi 'uli'uli ma midia ala ta 'are God 'e ilia 'e kwaga lo.’ ");
INSERT INTO lgl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","'Are fo 'e fatae 'urifo olu fe talasi gera ka olifailia lou 'ada 'i nali. ");
INSERT INTO lgl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ala talasi fo, olu wale gi te wale 'e kerida mae 'i soegu faasia 'i Sesarea, daulu dao lo 'i maala luma lau io ai. ");
INSERT INTO lgl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ma Aloe 'are Abu ka ilia fagu, laka la failida, ma ikoso 'ali lau malata ruarua sulia 'i gera ioli mamataa faasia Jiu gi li. Ma olo wale gera fakwalaimoki ma gera io 'i Jopa gi, gera ka la lou faelau fala 'i Sesarea, ma meulu ka ruu 'i laola luma ala Kornelius. ");
INSERT INTO lgl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ma 'i lia ka faarono 'ameulu 'alia lia 'e lesia eniselo 'e ura 'i laola luma lia ma ka ilia fala, ‘'O keria ta wale fala 'i Jopa 'ali ka soia mae wale la ratala Simon Peter. ");
INSERT INTO lgl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","'I lia kae ilia alaana gi famu, 'ali 'i'o failia kwalofa 'o 'amu ka mauri firi.’ ");
INSERT INTO lgl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ala talasi lau fuli'ae laka alaa mola fada, Aloe 'are Abu ka sifo lo mae fafida, malaa lou lia ba 'e sifo mae fafi golu ala atoa ala Pentekos li. ");
INSERT INTO lgl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ma laka malata tonala 'are ba Aofia 'e ilia ka sae 'uri 'e, ‘John 'e fasiuabua mola ioli gi 'alia kwai, wasua ma God kae siufi 'amiu 'alia Aloe 'are Abu.’ ");
INSERT INTO lgl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","God ka kwatea lou Aloe 'are Abu fala ioli mamata faasia Jiu gi li, malaa lou lia 'e kwatea fagaulu, ala talasi ba golu fakwalaimoki ala Aofia Jesus Christ. 'Urifo, 'e iko 'ali lau totolia 'ali lau luia God, talasi 'e alafafia ioli 'e gi li!” ");
INSERT INTO lgl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ma talasi gera ronoa lo 'are fo li, malata nenena gera gi ka mano lo, ma gera ka batafea lo God 'uri 'e, “God 'e ala 'alia lou ioli mamata faasia Jiu gi li wasua gera kae bulusi faasia ta'ana gera gi, ma gera kae mauri firi!” ");
INSERT INTO lgl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ma 'i osiala malakwaitana ala talasi ba gera raunia Stefen 'e 'ato rasua, lia taua ioli gera fakwalaimoki gi gera ka keta. Ma nali ai ada gera la fala gulae tolo 'i Fonisia, ma fala kokomu 'i Saeprus, ma falua ba'ela 'i Antiok, ma gera ka faarono 'alia Faronona 'Oka fala ioli 'i Jiu gi li mola talifilida. ");
INSERT INTO lgl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma nali ioli gera fakwalaimoki lia gera la mae faasia kokomu 'i Saeprus, ma te falua ba'ela 'i Saeren, gera ka la lou fala 'i Antiok, ma gera ka faarono 'alia Faronona 'Oka sulia Aofia Jesus fala ioli mamata faasia Jiu gi li lou. ");
INSERT INTO lgl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ma nanatana God ka io failia ioli fo gera fakwalaimoki gi, ma ioli afula gi, gera ka fakwalaimoki lou, ma gera ka bulusi fala Aofia. ");
INSERT INTO lgl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Alaana sulia 'are fo gi li ka talofia lo logonae ioli fakwalaimoki 'i Jerusalem gi, failia wale etaeta gera gi, ma geraka keria Banabas fala 'i Antiok. ");
INSERT INTO lgl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ma talasi 'e dao, ka lio raea lia God 'e 'oilakitailia ioli 'i lififo gi li, ma ka babalafe rasua, ma ka ani ulu fada sui 'ali gera ka ura nasi 'alia fakwalaimokina gera gi ala Aofia. ");
INSERT INTO lgl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas 'i lia wale 'oka, ma fitoona lia 'e nanata, ma Aloe 'are Abu ka io ala. Ma 'i osiala Banabas, ioli afula gi gera ka etae fakwalaimoki lo ala Aofia. ");
INSERT INTO lgl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","'Urifo Banabas ka la fala 'i Tarsus, ka lio 'afia Saul. ");
INSERT INTO lgl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ma talasi 'e daria, ka talaia, daro ka la fala 'i Antiok. Ma daro ka io 'i lififo sulia teke fe nali. Ma daro ka logo failia ioli afula gera fakwalaimoki 'i lififo gi li, ma daro ka faalalauda. Ma 'i Antiok lia ioli gi gera fuli'aea soinala ioli 'e gera fakwalaimoki gi 'alia “Ioli 'a Christ gi - Kristin gi.” ");
INSERT INTO lgl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ma talasi fo, nali profet gera la faasia 'i Jerusalem, gera ka la fala 'i Antiok. ");
INSERT INTO lgl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na wale ada ratala Agabus 'e ura, ma ka sae 'alia nanatana ala Aloe 'are Abu li, ka ilia bonili fiolo ba'ela kae liu 'i laola molagali. Kae dao mae ala talasi Klodius 'e walelitalona 'i Rom. ");
INSERT INTO lgl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ma waleli galona gi, gera ka malata fala kwate batana fala rananala ioli gera fakwalaimoki ma geraka io 'i Judea gi. Ma ioli gi sui, gera ka kwatea ta 'e totolia geraka kwatea. ");
INSERT INTO lgl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ma gera ka tau 'urifo, ma gera ka kwatea bata fo gi fala Banabas failia Saul, 'ali daro ka sakeda fala wale etaeta ala ioli fakwalaimoki 'i Jerusalem gi li. ");
INSERT INTO lgl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ma talasi fo, Herod walelitalona 'e daua nali ioli ala ioli fakwalaimoki gi, ma ka oga ka malakwaita ada. ");
INSERT INTO lgl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ma ka kwatea wale li ofona lia gi 'ali geraka raunia James, ai 'i laoala John, 'alia 'au li ofona. ");
INSERT INTO lgl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ma talasi 'e lesia lia Jiu gi gera babalafe rasua failia me 'are fo 'e taua li, ka kwatea wale li ofona lia gi, gera ka daua lou Peter. 'E taua 'are fo ala talasi ala Fanana gera soia 'alia “Fanana ala Daofae Liu na li.” ");
INSERT INTO lgl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ma 'i burila gera daua Peter ka sui lo, gera ka alua 'i laola raraa, ma fai logonae wale li ofona gi gera lio folo bolosia, ma 'i laola logonae ioli fo gi, gera alua fai wale 'ali teke logologonae ioli. Herod 'e malata fala lokokwaikwaina fala Peter 'i maala ioli gi 'i burila Fanana ala Daofae Liu na li. ");
INSERT INTO lgl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ma Peter ka io mola 'ala 'i laola raraa. Ma ioli fakwalaimoki gi, gera ka foa nanata rasua fala God sulia Peter. ");
INSERT INTO lgl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ma ala fe boni 'i laoala Herod kae lokokwaikwaina fala Peter 'i maala ioli gi li, Peter 'e mo'osu 'ala 'i safitala rua wale lio folo gi. Gera firia 'alia rua seni gi, ma wale lio folo gi gera ka lio folo lou mae 'i maala 'olofolo ala luma ala raraa li. ");
INSERT INTO lgl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ma toraa wasua eniselo Aofia 'e la mae ka ura 'i so'ela, ma madakwana ka rara 'afia 'i laola mae raraa fo 'e mo'osu ai. Ma eniselo ka dau ala gwaula 'aba'abala Peter ka faa adaa, ka sae 'uri 'e, “'O tatae nainali!” Mola, kwaloe seni ba gera firia 'alia limala gi ka toli lo faasia limala. ");
INSERT INTO lgl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","'Urifo eniselo fo ka sae 'uri 'e, “'O toro 'alia toro 'o, ma ko alua 'ae botu 'o gi 'i 'aemu.” Ma Peter ka tau sulia. Sui eniselo ka sae lou 'uri 'e, “'O rufia to'omi fafi ba'ela 'o fafi 'o, ko la mae fae lau.” ");
INSERT INTO lgl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ma Peter ka la sulia 'i maluma faasia 'i laola raraa. Ma iko 'ali saiai lia fo me 'are fo eniselo fo 'e taua ala 'uria me 'are kwalaimoki, sulia 'i lia 'e fia 'uria 'e lesia mola 'ala te fataena. ");
INSERT INTO lgl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ma eniselo fo failia Peter, daro ka la, daro ka liufia lo etala wale lio folo, sui ruala wale lou, sui daro ka bi dao ala tatafe ala 'olofolo gera raunailia 'alia aeana li, lia 'e laofia ko laola falua. Ma tatafe fo ka talae tafa mola 'ala fadaroa, ma daro ka latafa. Ma talasi daro la ko sulia tala ba'ela li, 'urifo mola eniselo fo ka la lo 'ala faasia Peter. ");
INSERT INTO lgl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ma Peter ka bi saiala 'are fo 'e fuli fala ma ka sae 'uri 'e, “'Eo lau bi saiai 'e kwalaimoki rasua. God 'e talae kwatea mae eniselo lia, ma ka rana lau faasia Herod failia wale Jiu gi li, ma iko 'ali gera rauni lau malaa lia gera lokoe malata fala taunai.” ");
INSERT INTO lgl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Talasi Peter 'e sai lo ala 'are fo li, ka la lo fala luma Mary teite John Mark. Ma ioli afula gi gera logo 'i laola luma fo, 'ali gera foa. ");
INSERT INTO lgl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Talasi Peter 'e dao mae, 'e ura 'i burila tatafe ala 'olofolo li, ka kidikidi. Ma te ulao 'e galo 'i laola luma fo li ratala Roda ka la mae. ");
INSERT INTO lgl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ma talasi 'e rono raea linela Peter, ka babalafe rasua, ma iko 'ali tafalia lou tatafe. 'E lalao oli, ka faarono ga 'alia lia Peter 'e ura 'i maluma. ");
INSERT INTO lgl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ma iko 'ali gera fakwalaimokia, ma gera ka ilia 'e kwekwe'ela. Wasua ma 'e suusuu failia ka sae 'uri 'e, “Lau sae kwalaimoki.” 'Urifo gera ka olisi 'uri 'e ala, “Mala eniselo lia tela 'e.” ");
INSERT INTO lgl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ma talasi fo lou, Peter ka galo 'ala ala kidikidi na. Ma talasi gera tafalia lo tatafe mala luma li, gera ka lesia Peter, ma gera ka kwele rasua. ");
INSERT INTO lgl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ma ka ralofafida 'alia limala 'ali gera ka io aroaro. Ma ka faarono gera 'alia lia God 'e lugasia lo faasia 'i laola raraa li. Ma ka sae 'uri 'e, “'Amu ka la ma 'amu ka faarono 'alia 'are 'e gi fala James failia wai asila ba gera fakwalaimoki gi.” 'I burila 'e ilia 'are fo gi sui, ka la lo 'ala fala na lifi mamata. ");
INSERT INTO lgl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ma 'ofaedani lo, boeboetana ba'ela ka tatae 'i safitala wale lio folo gi, sulia gera raria ta 'e fuli ala Peter. ");
INSERT INTO lgl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ma Herod ka kwatea saenala 'ali gera ka lio 'afia Peter. Wasua ma iko 'ali gera daria mola. Ma ka soia mae wale lio folo gi, ka soilidida, ma iko 'ali gera saiala ta 'e fuli ala Peter, mola ka kwatea wale li ofona lia gi, geraka raunida sui. 'I burila, Herod ka la faasia 'i Judea, ma ka lai io ga 'ala 'i Sesarea. ");
INSERT INTO lgl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ma Herod ka ogata'a rasua fala ioli 'i Taea ma 'i Saedon gi. Ma gera logo 'ada 'i talada, ma gera ka la 'i so'ela Herod. Gera etae lai dao ga 'i so'ela Blastas 'ali ka ranada, sulia 'i lia te wale ba'ela 'i laola luma Herod. Sui 'urifo bui gera ka bi la 'i so'ela Herod, gera ka sugaa fala aroarona. Gera sugaa 'urifo, sulia gera oga folinala fanaa faasia gulae tolo Herod 'e walelitalona fafia. ");
INSERT INTO lgl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ma fe atoa Herod 'e filia fala alaana fala ioli gi li 'e dao lo. 'Urifo ka rufia to'omi kwana lia gi, ma ka gwauru ala lifi li gwauru 'ala walelitalona, ma ka alaa fada. ");
INSERT INTO lgl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Talasi 'e alaa ka sui mola, ioli gi gera ka akwa ba'ela 'uri 'e, “Iko lou linela wale 'e, ma linela god 'ala 'e!” ");
INSERT INTO lgl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ma 'urifo mola eniselo God ka la mae ma ka kwaia Herod, ma ka matai, sulia iko 'ali faa 'ilitoa God. Ma wawaa gi gera ka 'ania rabela, ma 'i burila ka mae lo. ");
INSERT INTO lgl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ma saenala God ka talo ala falua afula gi, ma ioli afula gi gera ka fakwalaimoki ai. ");
INSERT INTO lgl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ma Banabas failia Saul, daro ioio 'i Jerusalem sui daro ka oli lo fala 'i Antiok 'i burila daro faasuia galona gera kwatea fadaroa. Ma daro ka sakea John Mark fae daroa. ");
INSERT INTO lgl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ma nali profet, wale gera faabasu 'alia faronona 'oka li, failia wale 