﻿USE sofia;
DROP TABLE IF EXISTS sofia.lga_vpl;
CREATE TABLE lga_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lga_vpl WRITE;
INSERT INTO lga_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pa popodalaina na Tamasa sa vapodakia sa na oka beto na abana. ");
INSERT INTO lga_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ego na abana sa na nyararana beto na ivuluna, beto na rodomo sa sa sado vailivutainia sa na arena kolo lilisina beto ko na Gagalana na Tamasa sa alea na arena na kolo. ");
INSERT INTO lga_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Beto sa paranga sa na Tamasa, <<Mi kabere tu>>, Sau poni sa sa kabereona tu. ");
INSERT INTO lga_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ego ko na Tamasa sa sa dogoria sa na kabere sa sa vavagua, poni sa vaipikatainiria na Tamasa sa na kabere beto na rodomo. ");
INSERT INTO lga_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Beto na Tamasa sa vaisongonia na Rane sa na kabere goto na rodomo sa vaisongonia na Bongi. Ego sa gore sa na vevelu beto sa sae sa na vuvugei- isa sa na rane momoe. ");
INSERT INTO lga_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Beto sa paranga sa na Tamasa, <<Mi votu kai voloso vavagalo eqa pa vaikorapaina na kolo ko mi pikataruai na kolo pa narena beto pa kauruna>>, sau. ");
INSERT INTO lga_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ko sa roitinia na Tamasa sa kai voloso vavagalo eqa ko sa vaipikatainiria sa na kolo pa kauruna na voloso vavagalo eqa beto na kolo pa narena na voloso vavagalo eqa. Ko sa gore votu sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Beto na Tamasa sa vaisongonia na <<Oka>> sa na voloso vavagalo eqa. Ego sa gore sa na vevelu beto sa sae sa na vuvugei- isa sa na rane vinarua. ");
INSERT INTO lga_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Beto sa paranga sa na Tamasa, <<Mai boko vaikamu pa kai ia sa na kolo pa kauruna na oka ko mi podaka votu na peso pidilina>>, sau. Poni sa gore votu sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Beto na Tamasa sa vaisongonia na <<Abana>> sa na peso pidilina beto na kolo vaikamuna sa vaisongonia na <<Kolo>>. Ego sa dogoria na Tamasa sa vavagua sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Beto sa paranga sa na Tamasa, <<Mi toaia na umuma sa na abana: ira na okokoto umuma qai vua kiko beto ira na gogou vuvua qai vuaniria na vua sa pore kikodi sa mai toa pa abana>>, sau. Poni sa gore votu sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ko sa vapidokoria na abana sa na umuma: ira na okokoto umuma qai vua kiko beto ira na okokoto gogou qai vuaniria na vua sa pore kikodi. Ego sa dogoria na Tamasa sa vavagua sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ego sa gore sa na vevelu beto sa sae sa na vuvugei- isa sa na rane vinaue. ");
INSERT INTO lga_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Beto sa paranga sa na Tamasa, <<Mai kole tu na kabere pa voloso vavagalo eqa pa oka ko mi vaipikatainiria na rane beto na bongi. Ko ira sa mai uleniria sira na vinagigila, ira na okokoto totoso, ira na rane beto ira na aoro, ");
INSERT INTO lga_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","beto ira sa mai kabere pa voloso vavagalo eqa pa oka ko mi vania na kabere na abana>>, sau. Poni sa gore votu sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ko na Tamasa sa roitiniria karu kabere lavata- na kabere lavatana ko mina kuta uanania na rane beto na kabere iketena ko mina kuta uanania na bongi, beto na Tamasa sa roitiniria tugu vei sira na seru. ");
INSERT INTO lga_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ko na Tamasa sa vakoleria pa voloso vavagalo eqa pa oka sa aipira ko mai vania na kabere na abana, ");
INSERT INTO lga_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","beto ko mai lalaeniria na rane beto na bongi, beto ko mai vaipikatainiria na kabere beto na rodomo sau. Ego sa dogoria na Tamasa sa vavagua sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ego sa gore sa na vevelu beto sa sae sa na vuvugei- isa sa na rane vinamade. ");
INSERT INTO lga_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Beto sa paranga na Tamasa, <<Na kolo sa mai miminete vapodakaria na minete manugu toadi, beto na mamanugu mai tatava podaka votu pa narena na abana beto pa vavagalo eqa kauruna na voloso vavagalo eqa na oka>>, sau. ");
INSERT INTO lga_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ko sa vapodakaria na Tamasa sira na mamanugu lalavata pa ivere, doru okokoto sakasa toadi qai rijo kanoko ira qai miminete vapodakaria na kolo, beto doru okokoto mamanugu tatava. Ego sa dogoria na Tamasa sa vavagua sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Na Tamasa sa mananiria sira, pira sau, <<Mu vua, mu soku, beto mu pugelia na kolo pa ivere, beto na mamanugu tatava mai soku pa abana>>, sau ");
INSERT INTO lga_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ego sa gore sa na vevelu beto sa sae sa na vuvugei- isa sa na rane vinalima. ");
INSERT INTO lga_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Beto sa paranga sa na Tamasa, <<Na abana mi vapidoko voturia na okokoto mamanugu toadi: na okokoto mamanugu papausu, na mamanugu qai gavere pa peso, beto na mamanugu pirudi pa abana>>, sau. Poni sa gore votu sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ko sa roitiniria na Tamasa sira na okokoto mamanugu pirudi pa abana, na okokoto mamanugu papausu beto doru okokoto mamanugu qai gavere pa peso. Ego sa dogoria na Tamasa sa vavagua sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Beto sa paranga sa na Tamasa, <<Aria ko ta roitinia na tinoni tutia na kireda, mai vevei puputa gita, beto mai kopuniria na igigana pa ivere, na mamanugu tatava pa vavagalo eqa, ira na mamanugu papausu, na abana doruna, beto doru mamanugu qai gavere pa peso>>, sau. ");
INSERT INTO lga_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ko na Tamasa sa vapodaka tutinia na kirena mekana sa na tinoni, Pa kirena na Tamasa sa vapodakania sisa; Sa vapodakaniria na marene beto na rereko. ");
INSERT INTO lga_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Na Tamasa sa mananiria beto pira sauniria na Tamasa, <<Mu vua, mu soku, beto mu pugelia na abana, beto mu vakaurairia beto mu kuta uananiria sira na igana pa ivere, na mamanugu tatava pa vavagalo eqa beto doru mamanugu qai gavere pa peso>>, sau. ");
INSERT INTO lga_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Beto sa paranga na Tamasa, <<Inana, qa vanigou sira doru umuma qai vua kiko pa doru ia pa abana beto ira doru gogou qai vua pore kikodi, ko ira sa mai tetekudi tamugou sira. ");
INSERT INTO lga_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Goto ira doru mamanugu pirudi pa abana beto ira doru mamanugu tatava pa vavagalo eqa beto doru mamanugu qai rijo kanoko pa peso, ira doru sakasa qai singonia na toa, ira sa qa vaniria na umuma eqequru ko mina dia tetekuna>>, sau. Poni sa gore votu sisa. ");
INSERT INTO lga_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ego na Tamasa sa doria doru sakasava sa roitiniria sa sa vavagua jola sisa. Ego sa gore sa na vevelu beto sa sae sa na vuvugei- isa sa na rane vinavonomo. ");
INSERT INTO lga_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ego ko qai taroiti vaokoto sa na oka beto na abana beto doru vaiminetai sakasa pa leodi. ");
INSERT INTO lga_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ego ko pa rane vinavitu na Tamasa sa tei vaokotia tu sa na ona roiti sa kole roitiniria, ko pa rane vinavitu sa minereniria isa sira doru ona roiti sa roitiniria. ");
INSERT INTO lga_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Beto sa manania na Tamasa sa na rane vinavitu beto sa vamadia sisa ura pa rane isa sa sa minereniria isa sira doru ona roiti vavapodaka sa roitiniria. ");
INSERT INTO lga_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Aipira sa na vavakatodi na oka beto na abana totonai qai tavapodaka. Ego totonai sa roitinia i Iahova Tamasa na abana beto na oka- ");
INSERT INTO lga_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","perangana sa qai oqoro bola votupa abana sa doru mumuqu beto doru umuma pa mumuqu qai oqoro pidoko sae, ura i Iahova Tamasa sa oqoro vagore tarinia na okoro sa na abana beto kepore na tinoni bi roitia na peso, ");
INSERT INTO lga_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ba na rovu kolo sa iolo votu pa abana ko sa vabukua sa na are doruna na peso. ");
INSERT INTO lga_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Beto sa bolobakilinia i Iahova Tamasa pa kovuruna na peso sa na tinoni beto sa singo tarinia na singo toana sa na isuna poni sa votu tinoni toana sisa. ");
INSERT INTO lga_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ego i Iahova Tamasa sa umai sa kai inuma pa Idini pa kale sagere tapo, ko ketakoi sa vasuverenia isa sa na tinoni sa bolobakilinia. ");
INSERT INTO lga_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Beto sa vapidokoria i Iahova Tamasa pa peso sa doru gogou qai babata jonga beto qai gagani jonga. Ko pa korapana na inuma isa sa turu sa na gou vaivatoana beto na gou vaivagigalaina na jongana beto na ikerena. ");
INSERT INTO lga_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ego kai ovuku sa votu koko vei pa Idini ko sa vabukua sa na inuma, beto koko ketakoi sa sa pikata ko sa made kae batu ovuku. ");
INSERT INTO lga_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Na isongona na ovuku momoe sa pa Pisoni, isa sa vividulai tututia sa na ia doruna pa Havila ketakoi sa kole na qolo. ");
INSERT INTO lga_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Na qolo pa ia ketakoi sa na qolo jongana; na duki otata umumanga jonga beto na patu jojonga ba qai kole tugu ketakoi.) ");
INSERT INTO lga_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Na isongona na ovuku vinarua sa pa Qihoni, isa sa vividulai tututia sa na ia doruna pa Kusi. ");
INSERT INTO lga_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Na isongona na ovuku vinaue sa pa Tiqirisi, isa sa rerege vei kale sagere tapona pa Asua. Beto ko na ovuku vinamade sa isa pa Eupareti. ");
INSERT INTO lga_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ego sa tekua i Iahova Tamasa sa na tinoni ko sa vasuveria pa inuma pa Idini ko mi roitia beto mi kopunia sau. ");
INSERT INTO lga_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Beto sa ule vania i Iahova Tamasa sa na tinoni, pira saunia, <<Ira doru gou pa inuma muna boka teku gaganimua vuadi sao, ");
INSERT INTO lga_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","goto pa gou vaivagigalaina na jongana beto na ikerena sa muneke teku gania na vuana, ura na ranena tugu muna teku gania ao na vuana sa muna mate sosoto>>, saunia. ");
INSERT INTO lga_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Beto sa paranga si Iahova Tamasa, <<Sake jonga sa na tinoni mina suvere meka. Mana roiti vania kai tinoni vaitokai isa mina vavaburoa sisa>>, sau. ");
INSERT INTO lga_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ego sa tei bolobakiliniria tu i Iahova Tamasa perangana pa peso sa doru mamanugu pirudi pa mumuqu beto doru mamanugu tatatava pa vavagalo eqa. Ko sa toni lameniria tana tinoni ko mi batiria beto na sa mina vakukuniria sau. Ko ai isongo sa vakukuniria na tinoni sira na okokoto mamanugu toadi sa isa tugu sa na isongodi. ");
INSERT INTO lga_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ko sa vakukuniria na isongo na tinoni sa doru mamanugu papausu, doru mamanugu tatava pa vavagalo eqa beto ko doru mamanugu mamade nene pirudi pa mumuqu. Ba na tinoni sa sake batia sa kai tinoni vaitokai bi boka vavaburoa sisa. ");
INSERT INTO lga_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ko sa vagorenia kai puta muma lavata i Iahova Tamasa sa na tinoni, ko totonai sa korapa puta isa sa sa unusu tekua sa kai pupuda pa raraqona na tinoni beto sa tako liguni masana. ");
INSERT INTO lga_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Beto sa varoitia i Iahova Tamasa sa na pupuda sa tekunia tana tinoni ko sa vavotuni rereko, beto sa toni laonia tana tinoni. ");
INSERT INTO lga_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Poni sa paranga sa na tinoni, <<Kopira tu api sa! Na pupudana na pupudaqu, Beto na masana na masaqu! Api sa mina isongona na maqota, Ura tana marene sa taunusu teku sapi>>, sau. ");
INSERT INTO lga_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ko pa ginugua vei isa sa na marene mina loai na tamana beto tinana ko mina togasa lao tana maqotana, ko mai mekarai kai tinidi sira karu. ");
INSERT INTO lga_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ego ko ira karu na tinoni beto na maqotana sa na gagadodi beto qaike vaikea sira karu. ");
INSERT INTO lga_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Ego na dole sa sa babalau vaivagona jolaniria ira doru mamanugu mumuqu sa roitiniria i Iahova Tamasa. Ko pira saunia sa na maqota, <<Ai vei? Sa sosoto tugu sa na Tamasa sa pojai, Munake isongo gania na vuana kai gou pa inuma sau?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Poni sa paranga lao tana dole sa na maqota, <<Na vuadi na gou pa inuma sa mene boka ganiria gu, ");
INSERT INTO lga_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","goto na vuana gu na gou sa turu pa vaikorapaina na inuma sa sa pojai na Tamasa munake gania beto munake ulia ura kita mu mate sau,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Poni sa paranga lao tana maqota sa na dole, <<Minake isongo apulugou na mate sagou! ");
INSERT INTO lga_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ura na Tamasa sa gigilaiona sa isa tugu na ranena muna gania agou sa na vuana na gou isa sa kode mina revanga na matamiu ko muna vei na Tamasa, isa sa gigilai na jongana beto na ikerena,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Totonai sa doria na maqota sa mina gagani jonga sa na vuana na gou beto sa babata jonga na dorona beto sa vaivanyorogua sa na gou ura sa boka vaivagigalai, poni sa sa tekuria kaki vuana ko sa gania beto sa vania tugu vei na marenena sa korapa suvere tavitia ko sa gania. ");
INSERT INTO lga_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ego beto ko sa qai revanga gu sa na matadi ira karu, ko qai gigilai sa na gagadodi gu sira karu. Ko qai mekarai vaiukinia ira karu sa na equru gou piqi beto ko qai ude vapaeniria na gagadodi. ");
INSERT INTO lga_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Beto qai nongoria ira karu sa na rarakotona i Iahova Tamasa sa korapa lelekogona pa inuma totonai sa lomoso gogore tapo na rane, ko sa ovo vapaeona pa vaikorapai gogou pa inuma sa na tinoni beto na maqotana ko mike batiria i Iahova Tamasa qarigu. ");
INSERT INTO lga_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Poni sa kukua i Iahova Tamasa sa na tinoni, <<Pai sao?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Poni pira sau, <<Na rarakotomu ao sa qa nongoria pa inuma, poni sa qa matagutu ura na gagadoqu sara ko qa ovoqua,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Poni pira sau sa i Iahova na Tamasa, <<I sei sa pojanigo sa na gagadomu sao sau? Ai vei qu gania ao sa na vuana na gou qa suqutunigo munake gania qaunigo ara?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Poni sa paranga sa na tinoni, <<Na maqota qu vasuvere tavitinisiu api sa isa sa vanisiu kaki vuana ko qa gania,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Poni sa parangia i Iahova Tamasa sa na maqota, <<Na sa sa qu roitinia ao alepi?>> saunia. Poni sa paranga na maqota, <<Na dole sa vagonasiu ko soni vei sa qa gania,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ego ko i Iahova Tamasa sa parangia sa na dole, pira saunia, <<Ura na ginugua vei qu roitinia ao sa na tapata le alepi, sa Na leleve tamu sa mina mangini jola jolaniria tadira doru papausu Beto tadira doru mamanugu mamade nene pirudi! Muna gavere gatolonia na lobamu Beto muna gani kavuru peso Doruna na rane na mua toa. ");
INSERT INTO lga_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mana vakolea ara sa kai vaikana pa vaikorapaimu ao beto na rereko, Beto pa vaikorapaina na kikomu ao beto na kikona na rereko. Isa mina vapalekai na batumu, Beto ao muna vapalekai na kikijulu nenena,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Goto na rereko sa pira saunia, <<Mana vamotai ara sa na mua vitigi, Ko pa vitigi muna vapodoria ao sa na koburu. Muna nyoroguania ao sa na marenemu, Ba isa mina lalaenigo sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Pana tana marene sa pira saunia, Ura qu nongoria ao sa na ovovelena na maqotamu ko qu gania na vuana na gou isa qa suqutunigo ara, ko munake gania qaunigo, ko <<Sa taleve sa na peso pa ginuguamu ao; Muna gosoria na vitigi beto muna gania na gagani Doruna na rane pa mua toa. ");
INSERT INTO lga_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Na buburu beto na gogou vavaioka mina vapidoko vanigo, Beto ao sa na eqequru pa mumuqu gu sa muna ganiria. ");
INSERT INTO lga_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mina ipata na isumatamu beto Muna gania na gamu gagani Tinganai muna mule lao pa peso, Ura ketakoi tugu qu tateku votu sao. Ura na kavuru peso sao Ko pa kavuru peso tugu sa muna mule lao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ko na marene sa vakukunia i Ivi sa na maqotana ura isa sa mina tinadi doruna na tinoni toadi. ");
INSERT INTO lga_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ego i Iahova na Tamasa sa roiti vania na poko vuliti manugu mamade nenena sa na marene beto na maqotana. ");
INSERT INTO lga_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Beto pira sau si Iahova na Tamasa, <<Inana ke! Na tinoni sa kopira sa vei kame gita, sa gigilai na jongana beto na ikerena. Ko kopira kita mi kaqama ko mi lokete mule sa pa gou vaivatoana ko mi gania ko mi toa kamua na kamua,>> sau ");
INSERT INTO lga_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ko i Iahova na Tamasa sa iju variua pa inuma pa Idini ko mi roitia sa na peso ketakoi sa koko lame vei sau. ");
INSERT INTO lga_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ko sa iju vavotu riua sa na tinoni beto sa vatoqoa pa inuma pa Idini pa kale sagere tapo sa na kerubimi beto kai benisi vuvurungu memea sa kapidolo lao lame ko sa kopunia na soana sa lao pa gou vaivatoana. ");
INSERT INTO lga_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ego na marene sa kole tavitia si Ivi na maqotana ko sa bogata ko sa vapodoa isa si Keni, poni pira sau sa na maqotana, <<Qa vaporea ara sa kai tinoni pa vaitokai tai Iahova,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Pa liguna lao sa vapodoa mule isa si Ebolo na tasina. Ego i Ebolo sa na tinoni kopu gogodo sipi, goto i Keni sa na tinoni umuma pa peso. ");
INSERT INTO lga_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ego sa jola kai totoso kakasana sa sa pogoso pa vuana na peso si Keni ko na ona vaivana lao tai Iahova sau. ");
INSERT INTO lga_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Poni i Ebolo ba sa pogoso tugu pa podo moedi ira nona sipi beto sa pogoso lameniria sa na gogosoto jongaidi nona sipi. Poni i Iahova sa doro tavaraguania si Ebolo beto na ona vaivana, ");
INSERT INTO lga_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","goto i Keni beto na ona vaivana sa sake doro tavaraguaniria. Ko sa iku vuvurungia si Keni ko sa titigore betona na isumatana. ");
INSERT INTO lga_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Poni pira saunia i Iahova si Keni, <<Ai sa vei ko sa iku vuvurungigo tu? Ai sa vei ko sa titigore betona tu na isumatamu? ");
INSERT INTO lga_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Vei muna roitinia ao sa na tuvisi, poni sa muna engamua gu sao? Goto vei munake roitinia ao sa na tuvisi, poni na sela sa sa korapa opo veranigo gu pa atakamana, ko ao sa na ona nyorogua isa ba ao tu sa muna lalaenia isa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ego sa parangia i Keni si Ebolo na tasina ko totonai tu qai korapa pa mumuqu, sa sa turu rajai i Keni si Ebolo na tasina ko sa vaivamate pale. ");
INSERT INTO lga_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Beto sa parangia i Iahova si Keni, <<Pai tu i Ebolo na tasimu?>> saunia. Poni pira sau si Keni, <<Koi! Qake gigilai.>> <<Na qua jujuno ara ko mana kole kopunia sa na tasiqu?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Poni pira sau si Iahova, <<Na sa qu roitinia sao? Mu vainongoro ko! Na ovovelena na orunguna na tasimu sa sa kekebo lame taqu koko pa peso. ");
INSERT INTO lga_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ko kopira ao sa, sa leve palenigo na peso isa sa mamanga ko sa bukua na orunguna na tasimu pa limamu ao. ");
INSERT INTO lga_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Tonai muna roitia ao sa na peso, sa na peso mina aru mulenia nona neqi ko minake vanigo na vagisona. Muna kai tinoni lekogo lao lame beto muna vidulai lao lame pa peso sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Poni sa paranga lao tai Iahova si Keni, <<Kei! Sa lavata jola vivitiginia na qua ngongo sa na vinakilasa qa gosoria api sa. ");
INSERT INTO lga_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Pa ngeni api qu iju votu palenisiu pa ia ko kopira mana pae pa isutamamu ao sara. Kopira mana kai tinoni lekogo lao lame beto kai tinoni vidulai lao lame pa peso sara, ko ira na tinoni mai batisiu sa kode mai vai vamate palesiu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Ba pira saunia i Iahova si Keni, <<Dai! Minake vei isa. Na tinoni mina vai vamatea i Keni sa mina gosoriagana ka vitu vinakilasa,>> sau. Beto sa sa vakolenia kai vinagigila i Iahova si Keni ko ira mai batia sa maike kotia sau. ");
INSERT INTO lga_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ko sa votu taloa pa susuverena tai Iahova si Keni beto sa lao suvere pa ia pa Nodi, pa kale sagere tapo pa Idini. ");
INSERT INTO lga_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ego i Keni sa kole tavitia sa na maqotana ko sa vabogatia ko sa vapodoa si Inoke. Pana totoso isa sa sa korapa roitinia isa sa kai gugusu ko sa vaisongo tutunia tugu i Inoke na tuna marene sa na gugusu isa. ");
INSERT INTO lga_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ego pa ti Inoke qi pore si Iradi, ko i Iradi qi vaporea si Mehujaeli, i Mehujaeli qi vaporea si Metusaeli, beto i Metusaeli qi vaporea si Lemeki. ");
INSERT INTO lga_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ego i Lemeki sa tekuria sa karu maqota, na isongona kame si Ada beto na isongona na vinaruana si Zila. ");
INSERT INTO lga_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","I Ada sa vapodoa si Jabali; isa na tamadi ira qai susuvere pa aqaqo beto ira qai papausu manugu mamade nenedi. ");
INSERT INTO lga_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Na isongona na tasina marene si Jubali; isa na tamadi ira qai rarusia na mike beto qai ivivu. ");
INSERT INTO lga_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","I Zila ba sa pore tuna marene tugu, na isongona si Tubalikeni, na tinoni sa roroiti votuniria soku gogoto sakasa roroitidi pa aeana beto na boronisi. Na luluna rereko i Tubalikeni si Naama. ");
INSERT INTO lga_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ego pira sauniria i Lemeki sa karu maqotana, <<Ada beto i Zila, mu nongoria na ovovelequ ara; Agou na maqotana i Lemeki, mu vatalinganiria na parangaqu. Qa vai vamatea ara kai tinoni sara ura sa vapalekasiu, Qa vai vamatea ara kai koburu ura sa kirususiu. ");
INSERT INTO lga_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Vei ka vitu vinakilasa mina gosoriagana Sa na tinoni sa vamatea i Keni, Poni sa na tinoni sa vamatea i Lemeki Sa mina gosoriagana ka vitungavulu vitu vinakilasa,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ego i Adama sa kole tavitia mule sa na maqotana ko sa vapodoa sa kai marene ko sa vaisongonia i Seti, <<ura na Tamasa sa vakole vanisiu mule kai koburu na beina i Ebolo, isa sa vai vamatea i Keni,>> sau sa na maqotana. ");
INSERT INTO lga_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","I Seti sa vaporea tugu vei sa kai tuna marene, ko qi vaisongonia i Enosi. Ego pa totoso isa sira na tinoni sa qai podalai gigigalia sa na isongona i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Alepi sa na vavakatona na veveina na tutina i Adama. Totonai sa vapodakia sa na tinoni sa na Tamasa, sa sa roitinia pa kirena na Tamasa. ");
INSERT INTO lga_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Na marene beto na rereko sa sa roitiniria ko sa mananiria beto sa vaisongoniria <<Na Tinoni>> totonai sa vapodakaria. ");
INSERT INTO lga_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Totonai sa kai gogoto uengavuluputa aorona si Adama, sa sa vaporea isa sa kai tuna marene pa kirena mekana, vei puputa tugu mekana, ko sa vaisongonia i Seti. ");
INSERT INTO lga_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ko pa liguna sa vaporea isa si Seti, sa sa suvere mutu vesugogoto aoro si Adama ko sa vaporeria mule isa sa kaki goto tuna marene na tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ko na vaikamuna doru rane sa suveria i Adama sa ka sia gogoto uengavuluputa aoro, beto sa sa mate. ");
INSERT INTO lga_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Totonai sa kai gogoto lima aorona si Seti, sa qi vaporea isa si Enosi. ");
INSERT INTO lga_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ko pa liguna qi vaporea isa si Enosi, sa qi suvere mutu vesugogoto vitu aoro si Seti ko qi vaporeria mule sa kaki goto tuna marene na tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Ko na vaikamuna doru rane sa suveria i Seti sa ka sia gogoto manogarua aoro, beto sa sa mate. ");
INSERT INTO lga_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Totonai sa siangavuluputa aorona si Enosi, sa qi vaporea isa si Kenani. ");
INSERT INTO lga_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ko pa liguna qi vaporea isa si Kenani, sa qi suvere mutu vesugogoto manogalima aoro si Enosi ko qi vaporeria mule isa sa kaki goto tuna marene na tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ko na vaikamuna doru rane sa suveria i Enosi sa ka sia gogoto lima aoro, beto sa sa mate. ");
INSERT INTO lga_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Totonai sa vitungavuluputa aorona si Kenani, sa qi vaporea isa si Mahalaleli. ");
INSERT INTO lga_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ko pa liguna qi vaporea isa si Mahalaleli, sa qi suvere mutu vesugogoto madengavuluputa aoro si Kenani ko qi vaporeria mule sa kaki goto tuna marene na tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ko na vaikamuna doru rane sa suveria i Kenani sa ka sia gogoto manogaputa aoro, beto sa sa mate. ");
INSERT INTO lga_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Totonai sa vonomongavulu lima aorona si Mahalaleli, sa qi vaporea isa si Jaredi. ");
INSERT INTO lga_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ko pa liguna qi vaporea isa si Jaredi, sa qi suvere mutu vesugogoto uengavuluputa aoro si Mahalaleli ko qi vaporeria mule sa kaki goto tuna marene na tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ko na vaikamuna doru rane sa suveria i Mahalaleli sa ka vesugogoto siangavulu lima aoro, beto sa sa mate. ");
INSERT INTO lga_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Totonai sa kai gogoto vonomongavulu karu aorona si Jaredi, sa qi vaporea isa si Inoke. ");
INSERT INTO lga_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ko pa liguna sa vaporea isa si Inoke, sa qi suvere mutu vesugogoto aoro si Jaredi ko qi vaporeria mule sa kaki goto tuna marene na tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ko na vaikamuna doru rane sa suveria i Jaredi sa ka sia gogoto vonomongavulu karu aoro, beto sa sa mate. ");
INSERT INTO lga_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Totonai sa vonomongavulu lima aorona si Inoke, sa qi vaporea isa si Metusela. ");
INSERT INTO lga_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ko pa liguna sa vaporea isa si Metusela, i Inoke sa rerege tavitia na Tamasa kue gogoto aoro ko qi vaporeria mule sa kaki goto tuna marene na tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ko na vaikamuna doru rane sa suveria i Inoke sa kue gogoto vonomongavulu lima aoro. ");
INSERT INTO lga_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ego i Inoke sa sa rerege tavitia na Tamasa ko qi maragutu, ura na Tamasa qi teku variua. ");
INSERT INTO lga_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Totonai sa kai gogoto vesungavulu vitu aorona si Metusela sa qi vaporea isa si Lemeki. ");
INSERT INTO lga_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ko pa liguna qi vaporea isa si Lemeki, sa qi suvere mutu vitu gogoto vesungavulu karu aoro si Metusela ko qi vaporeria mule sa kaki goto tuna marene beto tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ko na vaikamuna doruna rane sa suveria i Metusela sa ka sia gogoto vonomongavulu sia aoro, beto sa sa mate. ");
INSERT INTO lga_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Totonai sa kai gogoto vesungavulu karu aorona si Lemeki, sa qi vaporea isa sa kai tuna marene, ");
INSERT INTO lga_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ko sa vakukunia i Noa isa ura pira sau, Api sa mina vamanotogita pa oda roiti mamatadi beto na vitigina na limada sa veinia na peso sa levenia i Iahova, sau ");
INSERT INTO lga_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ko pa liguna qi vaporea Noa, sa qi suvere mutu lima gogoto sia ngavulu sia aoro si Lemeki ko qi vaporeria mule kaki goto tuna marene beto tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ko na vaikamuna doru rane sa suveria i Lemeki sa ka vitu gogoto vitungavulu vitu aoro, beto sa sa mate. ");
INSERT INTO lga_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ego totonai sa lima gogoto aorona si Noa, sa qi vaporeria i Noa sira Semu, i Gami beto i Japeti. ");
INSERT INTO lga_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ego totonai qai popodalai soku tu lalaodia pa peso sira na tinoni ko qai vaporeria na tudia rereko, ");
INSERT INTO lga_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","sa ira na marene tuni Tamasa sa qai batiria qai babata jonga sira na tudia rereko na tinoni, ko qai viledia ko qai tekuni maqotadi sa na tudia rereko na tinoni. ");
INSERT INTO lga_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Poni pira sau si Iahova, <<Na Gagalaqu ara sa minake togasa jola tana tinoni ura na masa gu sisa. Ko na ona rane susuvere sa mina kamua kai gogoto rabeteputa aoro gu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ego ira na bubutu tinoni Nepilimi sa qai korapa suvere pa peso pa totoso ira beto vei tugu pa liguna lame totonai ira na marene tuni Tamasa qai tomeria sa na tudia rereko na tinoni beto ko qai vaporeniria na koburu. Ira sira na varene pa moa, na tinoni pore isongodi. ");
INSERT INTO lga_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Ego sa doria i Iahova sa lavata sa na toa lululasana tana tinoni pa peso beto ko doru kobu rorove pa bulona sa na gagale ikerena gu doruna rane. ");
INSERT INTO lga_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ko sa roqu takulangania i Iahova sa vei isa sa roitinia sa na tinoni pa peso ko sa vitigia tu na bulona. ");
INSERT INTO lga_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ko pira sau si Iahova, <<Mana tavusu palenia ara pa narena na peso sa na tinoni isa qa vapodakia, podalai tugu tana tinoni ko kamua tadira na mamanugu mamade nenedi beto ira na mamanugu qai gavere pa peso beto ira na mamanugu tatava pa vavagalo eqa, ura qa roqu takulangania ara sa vei qa roitiniria ara sira,>> sau ");
INSERT INTO lga_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ba i Noa sa sa doro tavaraguania i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Alepi sa na vavakatona i Noa. I Noa sa kai tinoni tuvisina, kepore sa kai opopu bi tajutunia tadira na sasae tinoni sa suvere tavitiria, beto ko i Noa sa sa rerege tavitia na Tamasa. ");
INSERT INTO lga_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ego ko sa vaporeria i Noa sa ka ue tuna marene: i Semu, i Gami beto i Japeti. ");
INSERT INTO lga_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ego na peso sa sa lulasa pa dodogoro tana Tamasa beto sa pugelia na toa vavaikana. ");
INSERT INTO lga_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Na Tamasa sa doria na peso sa lulasa betona tu, ura doru masa toadi sa lulasa betona sa na dia uana pa peso. ");
INSERT INTO lga_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ko pira saunia Tamasa si Noa, Mana vamanyao beto paleniria ara sa doru masa toadi, ura sa pugele taria na peso sa na dia toa vavaikana ira ko kopira mana piara pale ara sa na peso, sau. ");
INSERT INTO lga_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ko mu roitinia kai aka pa gou tiki, mu vakoleniria na lose pa leona beto mu pokonia na tita pa leona beto peguruna. ");
INSERT INTO lga_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Pira muna roiti veinia sisa: Na aka sa mina kue gogoto kobu lima na kakasana, lima ngavulu kobu lima na revatana beto uengavulu kobu lima na ululuna. ");
INSERT INTO lga_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Muna roitinia na isuna sa na aka ko na saena sa mina kobu lima koko pa paparana na tinina na vaka. Beto muna vakolenia kai atakamana pa leona na vaka beto muna roitiniria sa ka ue sape susuverena, pa kauruna, pa kokorapana beto pa narena. ");
INSERT INTO lga_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ara kopira mana vagore tarinia na popogoso kolo ara sa na peso ko mina piararia sa doru masa toadi qai singonia na toa pa kauruna na oka, dodoru vinapodaka pa peso sa mai manyao beto. ");
INSERT INTO lga_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ba ara sa mana vatoqoa na qua vinaego tamu ko ao sa muna tome pa aka, ao beto vei tugu ira na tumu marene, na maqotamu beto ira ka ue maqotadi ira na tumu marene. ");
INSERT INTO lga_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Beto muna toni tomeniria pa leo aka sa okokoto karu pa doru minete mamanugu toadi, na marene na rereko, ko muna vatoa vasareria. ");
INSERT INTO lga_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ira okokoto karu pa kai minete mamanugu tatava, pa kai minete mamanugu mamade nenedi, beto doru kai minete mamanugu qai gavere pa peso sa mai tome lame tamu ko mai toa. ");
INSERT INTO lga_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Beto ao sa muna tekuria sa doru kai gagani qai boka tagani ko muna vatana vaikamuniria ko isa sa mina tetekuna tamu beto tadira, saunia. ");
INSERT INTO lga_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Ko i Noa sa roitiniria tugu sa doruna vei puputa sa garununia na Tamasa. ");
INSERT INTO lga_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ego pira saunia i Iahova si Noa, <<Mu tome lao pa leo aka, ao beto na mua tatamana doruna, ura ao gu sa qa batia ara na tinoni tuvisimu pa sasae tinoni alepi. ");
INSERT INTO lga_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Pana doru kai okokoto mamanugu mamade nenena liosona mu tekua karu minete vitu, na marene beto na kalena rereko, beto pa doru kai okokoto mamanugu mamade nenena nake liosona mu tekua karu, na marene beto na kalena rereko, ");
INSERT INTO lga_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","beto vei tugu pa doru kai okokoto manugu tatatava pa vavagalo eqa mu tekua karu minete vitu, okokoto kai marene na rereko, ko mai aru jokelia na kikona na toa pa arena doru eqa pa peso. ");
INSERT INTO lga_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ka vitu rane gu sa kole beto ara mana vagoreni okoro ara sa pa peso pa leona ka made ngavuluputa rane beto ka made ngavuluputa bongi, ko mana tavusu paleria ara pa arena na peso sa doru sakasava toadi qa roitiniria,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ko i Noa sa roitiniria sa doruna vei sa garununia i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ego i Noa sa ka vonomo gogoto aorona sa totonai sa gorea na popogoso kolo sa na peso. ");
INSERT INTO lga_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ko i Noa, ira na tuna marene, na maqotana beto ka ue roana sa qai lao tome pa aka ko qai ukunia sa na popogoso kolo. ");
INSERT INTO lga_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Pana mamanugu mamade nenedi liosodi beto pa mamanugu mamade nenedi nake liosodi, beto pa mamanugu tatava beto pa doru mamanugu qai gavere pa are peso ");
INSERT INTO lga_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","sa qai okokoto kakaru, kai marene beto kai rereko, sa qai tome tutia i Noa pa aka tutia tugu isa vei na Tamasa sa garununia i Noa. ");
INSERT INTO lga_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ego ko sa jola gu ka vitu rane poni sa sa gorea na popogoso kolo sa na peso. ");
INSERT INTO lga_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ego ko pa vinavonomo gogoto aorona na toa tai Noa, ko na vinarua popu ko vinamanoga vitu rane pa popu isa na rane isa sa doru vuvuguna na kuta kolo lilisina sa qai pujaka pisiri votu beto na toba pie pa oka sa qai taporaka. ");
INSERT INTO lga_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ko na okoro sa gorea sa na peso pa ka made ngavuluputa rane beto ka made ngavuluputa bongi. ");
INSERT INTO lga_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Na vavagila ranena tugu isa sa sa tomea i Noa sa na aka beto vei tugu ira na tuna marene, i Semu, i Gami, beto i Japeti, na maqotana beto ira ka ue roana rereko. ");
INSERT INTO lga_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Qai toni tome tavitiniria tugu vei sa doru okokoto mamanugu mamade nene pirudi, doru okokoto mamanugu mamade nene papausu, doru okokoto mamanugu gagavere pa peso, doru okokoto mamanugu tatava, beto doru manugu pore babanadi. ");
INSERT INTO lga_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ko qai lame tai Noa ko qai lao tome pa aka sa doru mamanugu toadi vaikaledi qai singonia na toa. ");
INSERT INTO lga_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Ira na mamanugu mamade nenedi qai tome lao sa na marene na rereko pa doru mamanugu isa tugu vei sa garununia i Noa na Tamasa. Beto sa sa patei taria i Iahova si Noa. ");
INSERT INTO lga_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ego ko ka made ngavuluputa rane sa sa iolo vaituti pa are peso sa na popogoso kolo ko totonai sa mota na kolo poni sa ovulia ko sa vaiolia pa arena na peso sa na aka. ");
INSERT INTO lga_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Ego ko sa vaituti neqi na ovuluna sa na kolo ko sa pugele vadururia sa na are peso ko na aka sa alea na vulitina na kolo. ");
INSERT INTO lga_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ko na vaituti neqina na ovuluna na kolo pa are peso sa lavata vaivagabara ko sa amuria sa doru kubo ululudi pa kauruna na oka doruna. ");
INSERT INTO lga_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Na iolo saena na ovuluna kolo sa papada manogalima kobu lima sa amuria sa na batudi na kubo. ");
INSERT INTO lga_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ko doru masa toadi qai gaveria na peso sa qai manyao beto- na mamanugu tatatava, mamanugu papausu, na mamanugu pirudi beto doruna na mamanugu qai miminetia na are peso, beto ko doru na tinoni. ");
INSERT INTO lga_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Doruna qai singonia na toa pa ia pidilina sa qai mate. ");
INSERT INTO lga_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ko sa tavusu paleria i Iahova sa doru sakasa toadi qai kole pa are peso, na tinoni, na mamanugu mamade nenedi, na mamanugu gavere beto na mamanugu tatava pa vavagalo eqa, ko qai tatavusu pale pa peso sa aipira. I Noa gu mekana beto ira qai koi tavitia pa aka sa qai tavasare. ");
INSERT INTO lga_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ko na vaituti neqina na ovuluna na kolo pa are peso sa sa sake tatana gore kai gogoto lima ngavuluputa rane. ");
INSERT INTO lga_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ego na Tamasa sa roqu kamua si Noa beto doru mamanugu mamade nene pirudi beto doru mamanugu papausu qai koi tavitia isa pa aka, ko sa ipa gorenia isa pa peso sa na gava ko sa makogore sa na kolo. ");
INSERT INTO lga_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ego ira na vuvugu pa kolo lilisi beto na toba pie pa oka sa qai tajojongo suqutu ko sa taaru vanogoto sa na okoro pa vavagalo eqa. ");
INSERT INTO lga_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Na ovuluna na kolo pa are peso sa mate vaituti gore, ko pa liguna kai gogoto lima ngavuluputa rane poni sa sa vukele gore mate sa na kolo, ");
INSERT INTO lga_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ko pa vina manoga vitu rane na popu vina vitu sa sa gore toqo makele pa batudi na kukubo pa Ararati sa na aka. ");
INSERT INTO lga_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Na kolo sa vukele vaituti gore tinganai sa kamua na vina manogaputa popu, ko pa rane momoe na vina manogaputa popu sa qai podaka votu gu sira na batudi na kukubo. ");
INSERT INTO lga_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ego pa liguna ka made ngavuluputa rane sa revangia i Noa sa na vuidana na aka sa roitinia isa ");
INSERT INTO lga_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ko sa garunu variua sa kai belama, ba sa riu kole gu tatava lelekogona ko tinganai sa pidili betona sa na kolo pa peso. ");
INSERT INTO lga_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Poni sa garunu variua mule isa sa kai kuru ko mi gigilai sa vei bi na vukele gorena na kolo sa tei kamu tu pa peso ba dai sau. ");
INSERT INTO lga_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ba na kuru sake isongo batia kai ia ketakoi bi boka toqonia na nenena ura na kolo sa korapa amua sa doru arena na peso, ko sa tatava muleona gu tai Noa pa aka. Ko i Noa sa kaqama votunia na limana ko sa teku vatomea pa aka sa na kuru. ");
INSERT INTO lga_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ko sa vera kai vitu rane mutu si Noa beto sa kai garunu vavotu riua mule koko pa aka sa na kuru. ");
INSERT INTO lga_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Totonai sa tatava mule kamu na vevelu poni sa sa garatia pa mangana isa sa kai equru olive na koni tapudokona! Poni sa gigilai i Noa sa sa tei vukele gore tu pa arena na peso sa na kolo. ");
INSERT INTO lga_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ego ko sa verania pa liguna kai vitu rane mutugu beto sa garunu variua mutu isa sa na kuru, ba kopira sake gabala mule kamu ligu sa na kuru. ");
INSERT INTO lga_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ego pa rane momoe na popu momoe pa vina vonomo gogoto kame aorona i Noa sa sa pidili beto sa na kolo pa arena na peso. Poni sa teku pale i Noa sa na pateina na aka beto mi doro sau poni sa batia sa sa pidili beto sa na arena na peso. ");
INSERT INTO lga_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ko pa vina rabete vitu rane na vina rua popu sa sa pidili gagapu gu sa na peso. ");
INSERT INTO lga_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Poni sa parangia na Tamasa si Noa, pira sau, ");
INSERT INTO lga_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","<<Mu votu pa aka ao beto na maqotamu beto ira na tumu marene beto na maqotadi. ");
INSERT INTO lga_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mu toni votuniria doru okokoto puku mamanugu masa toadi qai koi tavitigo- ira na mamanugu tatava, na mamanugu mamade nenedi, beto doru mamanugu gavere qai gaveria na are peso- ko mai miminete pa peso beto mai vua beto mai soku pa peso>>, sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ko sa votu si Noa beto na maqotana beto ira na tuna marene beto na maqotadi. ");
INSERT INTO lga_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Doruna mamanugu mamade nenedi beto doru mamanugu gavere pa peso beto doru mamanugu tatava- doruna qai gaveria na peso sa qai votu pa aka vaituti pa okokoto dia pukuna. ");
INSERT INTO lga_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ego pa liguna isa sa roitinia i Noa sa kai idi patu vavavakukuvuna tai Iahova beto sa tekuria sa kaki mamanugu mamade nene liosodi beto kaki mamanugu tatava liosodi ko sa vavakukuniria pa idi vavakukuvuna. ");
INSERT INTO lga_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Poni sa umanga jongai i Iahova sa na umanga jongana na vavakukuvu ko pira sau pa bulona, Maneke leve ligunia ara sa na peso pa ginuguana na tinoni, nake savana doru nyorogua pa bulona na tinoni sa na ikerena podalai tu na koburuna, beto maneke koti liguria ara sa doru mamanugu toadi qa roitiniria. ");
INSERT INTO lga_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","<<Ai mina kakasana vei sa na totoso tana peso, sa Na totoso vavuvusu kiko beto na totoso papaduku, Na lomoso beto na mangini Na totoso tapo beto na totoso okoro Na rane beto na bongi Sa maike minere kokoroto,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Beto poni sa mananiria na Tamasa sira Noa beto na tuna marene, pira sauniria, Mu vua, mu soku, beto mu pugelia na abana. ");
INSERT INTO lga_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mai matagutu neneqerenigou agou sa doru mamanugu mamade nene pirudi pa abana beto doru mamanugu tatava pa vavagalo eqa, doru mamanugu qai rijo kanoko pa peso, beto pa doru igana pa kolo. Qai kole lao pa limamiu agou sa aipira. ");
INSERT INTO lga_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Doruna na sakasava toadi qai rijo kanoko sa na tetekuna tamugou. Vei tugu qa vanigou ira na umuma sa, kopira qa vanigou ara sa doru sakasava. ");
INSERT INTO lga_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ba na masa isa sa korapa kolea na orungu toana, sa munake isongo tekua. ");
INSERT INTO lga_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Beto na orunguna na toa tamugou sa qa nyoroguania sosoto mana gigilai na vavakatona. Mana nyoroguania tugu vei sa na vavakato pa doru mamanugu mamade nenedi. Beto pa okokoto tinoni ba mana nyoroguania tugu sa na vavakatona na tavitina sa vamatea. ");
INSERT INTO lga_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","<<Na tinoni mina vamate tinoni, Na tinoni tugu mina vamatea sisa; Ura pa kirena na Tamasa Sa roitinia sa na tinoni. ");
INSERT INTO lga_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Goto agou sa, mu vua beto mu soku beto mu vaivapipidoko pa abana ko mu vasokua?>> sau Sisa. ");
INSERT INTO lga_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Beto sa paranga na Tamasa lao pa tai Noa tavitiria na tuna marene, pira sau, ");
INSERT INTO lga_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","<<Kopira qa vatoqoa ara sa na qua vinaego ko qa vatoqonigou agou beto ko ira na tutimiu pa liguna lao ");
INSERT INTO lga_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","beto ira na mamanugu toadi qai suvere tavitigou- na mamanugu tatava, na mamanugu papausu, beto doru mamanugu mamade nene pirudi, doruna tugu qai tuti votugou pa aka- doruna mamanugu toadi pa abana. ");
INSERT INTO lga_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Qa vatoqoa ara sa na qua vinaego ko qa vatoqonigou agou: Minake isongo tateku pale ligu pa popogosona na kolo sa doru na toa, minake isongo lame ligu sa na popogoso kolo ko mina piaria sa na abana,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Beto sa paranga mutu sa na Tamasa, <<Alepi sa na vinagigilana na vinaego qa roitinia ara tamugou beto tadira doruna mamanugu toadi qai suvere tavitigou, na vinaego tana doru sasae tinoni korapa lame. ");
INSERT INTO lga_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Qa vakolea ara pa lei sa na bibigo ko isa sa na vinagigilana na vinaego pa vaikorapaiqu ara beto na kasia abana. ");
INSERT INTO lga_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Totonai mana valamea ara sa na lei papauku pa arena na abana ko mina bola votu sa na bibigo, poni sa ");
INSERT INTO lga_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","mana roroqu kamua ara sa na qua vinaego tamugou beto ko tadira doru okokoto puku mamanugu toadi. Minake isongo lame ligu sa na popogoso kolo isa mina piaria doruna na toa. ");
INSERT INTO lga_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Totonai mina bola votu sa na bibigo pa lei, poni sa mana batia beto ko mana roroqu kamua ara sa na qua vinaego kole jolana pa vaikorapaina na Tamasa beto tadira doru okokoto gogoto mamanugu toadi pa abana,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ko na Tamasa sa parangia si Noa, <<Alepi sa na vinagigilana na vinaego qa vatoqoa ara ko qa vatoqonisiu mekaqu beto ira doruna na toa qai kole pa abana,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ira na tuna marene i Noa qai votu pa aka sira Semu, i Gami beto i Japeti. I Gami sa vaporea si Kenani. ");
INSERT INTO lga_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Aipira sira kue tuna marene i Noa, beto ko tadira qai koko lame vei sira na tinoni qai qaqatia tinganai vei eqa pa abana. ");
INSERT INTO lga_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Ego i Noa sa kai tinoni umuma, sa podalai roitinia gu sa kai inuma qurepi. ");
INSERT INTO lga_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Totonai sa bukua kaki kolona na qurepi, poni sa sa digere ko na gagadona gu sa sa kole putagana pa leona nona aqaqo. ");
INSERT INTO lga_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","I Gami isa na tamana i Kenani sa sa bati poai sa na gagadona na tamana ko sa ule vaniria sira karu tugana pa peguru. ");
INSERT INTO lga_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ba ira Semu i Japeti sa qai tekua kai poko ko qai vakole pala karovia pa varadi beto ko qai rerege togolo mule pokoto taria sa na tamadi ko qai tuki vapaea. Qai bata vasoudia ko maike batia sa na gagadona na tamadi qarigu. ");
INSERT INTO lga_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Totonai sa dorava pa liguna sa buku vadigerenia si Noa beto sa gigilai na sa qi roitinia tana na tuna marene pa ligu, ");
INSERT INTO lga_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","sa pira sau,, <<Mi taleve si Kenani! Mina pinausu tadira na pinausu sisa Ko mina vei tugu sisa tadira na tugana,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Beto pira sau, <<Mi tavatarasae si Iahova, na Tamasa tai Semu! Mi nona pinausu i Semu si Kenani. ");
INSERT INTO lga_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Na Tamasa mi varijo valavatia sa na pikata ia tai Japeti; Mi suvere pa aqaqo tai Semu si Japeti, Beto i Kenani mi nona pinausu isa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Pa liguna na popogoso kolo sa, sa suvere kue gogoto lima ngavuluputa aoro mutu si Noa. ");
INSERT INTO lga_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Ko na vaikamuna na aoro sa suveria i Noa sa ka sia gogoto lima ngavuluputa aoro, beto sa sa mate. ");
INSERT INTO lga_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Alepi sa na vavakatona i Semu, i Gami beto i Japeti, ira na tuna marene i Noa qai vapore tudia marene pa liguna na popogoso kolo. ");
INSERT INTO lga_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ira na tuna marene i Japeti sa: I Qoma, i Maqoqu, i Madai, i Javani, i Tubali, i Meseki beto i Tirasi. ");
INSERT INTO lga_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ira na tuna marene i Qoma sa: I Asikenazi, i Ripati beto i Toqama. ");
INSERT INTO lga_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ira na tuna marene i Javani sa I Elisa, i Tasisi, na tutina i Kitimi beto na tutina i Rodamini. ");
INSERT INTO lga_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Pa tadira aipira na tinoni qai susuvere tata pa babatana sa qai qaqata rijo votu lao pa dia pipikata ia pa dia gorena pa korapana na dia pukuna pa okokoto dia parangana.) ");
INSERT INTO lga_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ira na tuna marene i Gami sa: I Kusi, i Miziraimi, i Puti beto i Kenani. ");
INSERT INTO lga_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ira na tuna marene i Kusi sa I Seba, i Havila, i Sabita, i Rama beto i Sabiteka. Ira na tuna marene i Rama sa: I Seba beto i Dedani. ");
INSERT INTO lga_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","I Kusi sa vaporea si Nimirodi isa kai varene neneqina pa abana totonai sa lavata sae. ");
INSERT INTO lga_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Kai tinoni ropa neneqina tai Iahova; sa vei isa sa na paranga sa tapopoja sa, <<Mu vevei i Nimirodi kai tinoni ropa neneqina tai Iahova,>> sasau sa na paranga. ");
INSERT INTO lga_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ira na kuta gugusu lavata momoe pa ona binangara isa sa pa Babiloni, pa Ereki, pa Akadi beto pa kaline keta pa ia pa Sina. ");
INSERT INTO lga_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Beto koko pa ia isa sa lao pa Asiria ketakoi sa sa roitinia isa sa pa Ninive, pa Rehoboti Ire, pa Kala ");
INSERT INTO lga_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","beto pa Reseni isa pa vaikorapaina pa Ninive beto na gugusu lavata pa Kala. ");
INSERT INTO lga_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","I Miziraimi sa vaporeria sira na puku tinoni Ludaii, Anamai, Naputuhai, ");
INSERT INTO lga_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Paturutai, Kasulhai (ketakoi qai koko lame vei ira na puku tinoni Pilisitaini) beto Kaputorai. ");
INSERT INTO lga_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","I Kenani sa vaporea si Sidon na tuna marene pa moa beto ira na puku tinoni Hitai, ");
INSERT INTO lga_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebusai, Amorai, Qiqasai, ");
INSERT INTO lga_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivai, Akai, Sinai, ");
INSERT INTO lga_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Avadai, Zemarai beto Hamatai. Pa liguna lao na bubutu Kenani sa qai qaqatia tinganai vei eqa ");
INSERT INTO lga_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ko na voloso pa Kenani sa kamu tu koko pa Sidoni lao vei pa Qera kamu tu pa Qaza, beto poni sa lao vei pa Sodomu, pa Qomora, pa Adima beto pa Zeboimi kamu tu pa Lasa. ");
INSERT INTO lga_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Aipira sira na tuna marene i Gami pa dia gorena beto parangana pa dia pipikata ia beto pukuna. ");
INSERT INTO lga_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","I Semu isa na tasina momoe i Japeti ba sa pore tuna marene tugu. Isa sa na dia tite ira doru na marene pa tutina i Ebe. ");
INSERT INTO lga_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ira na tuna marene i Semu: I Elami, i Asu, i Apasadi, i Ludi beto i Aramu. ");
INSERT INTO lga_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ira na tuna marene i Aramu: I Uzu, i Hulu, i Qeta beto i Meseki. ");
INSERT INTO lga_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","I Apasadi sa vaporea si Sela, beto i Sela sa vaporea si Ebe. ");
INSERT INTO lga_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Karu na tuna marene si Ebe: Kame na isongona si Peleqi, ura pa totoso sa korapa suvere isa sa na abana sa sa tapikata; na tasina marene si Jokotani. ");
INSERT INTO lga_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","I Jokotani sa vaporeria sira Alimodadi, i Selepi, i Hazamaveti, i Jera ");
INSERT INTO lga_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","i Hadorami, i Uzali, i Dikila, ");
INSERT INTO lga_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","i Obali, i Abimaeli, i Seba, ");
INSERT INTO lga_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","i Opi, i Havila beto i Jobabi. Ira doru aipira sa na tuna marene i Jokotani. ");
INSERT INTO lga_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Na pikata ia qai suveria sa gogojo koko pa Mesa ko sa lao vei pa Sepa, pa ia kukubona pa kale sagere tapo. ");
INSERT INTO lga_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Aipira sira na tuna marene i Semu pa dia gorena, dia parangana, dia pipikata ia beto pukuna. ");
INSERT INTO lga_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ko aipira sa na goredi na tuna marene i Noa pa okokoto dia tututi pa korapana na dia pukuna. Koko pa goredi aipira, na pupuku tinoni sa qaqatia doru eqa pa abana pa liguna na popogoso kolo. ");
INSERT INTO lga_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ego na abana doruna sa kame gu sa na paranga ko kai paranga gu sa qai paparangania. ");
INSERT INTO lga_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Totonai qai oro lao vei pa kale sagere tapo sira na tinoni sa, qai kamua sa kai arare lavata pa Sina ko qai suvere togasa ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Qai vaiparanga lao lame sira, <<Aria, ta roiti biriki tu beto ta vamangini vamaururia,>> qarigu. Ko qaike varoitia sa na patu goto na biriki tu beto nake nyelaka peso goto na tita tu. ");
INSERT INTO lga_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Beto poni qai paranga, <<Aria ko ta roiti vanigita tu kai gugusu lavata, mi turua kai ruma ululuna ko na batuna mi iolo sae kamua tu na oka, ko mi pore isongoda kita mai vaqaqatagita tinganai vei doru eqa pa abana,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ba I Iahova sa gore lagere doria sa na gugusu lavata beto na ruma ululuna isa qai korapa roitinia ira na tinoni. ");
INSERT INTO lga_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ko sa paranga si Iahova, <<Koi! Kai puku tinoni gu sa aipira ko kai paranga gu sa qai parangania sira doru. Ko api sa qai podalai roitinia gu ko kopira sa kepore kai sakasa mai nyogua roitinia ira mina tapataria. ");
INSERT INTO lga_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ko Aria, ta gore vairurainiria sa na dia paranga ko maike vanongorainiria sa na sakasa mai pojaria,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ko sa vaqaqataria tinganai vei eqa pa abana i Iahova sira ko qai beto roitinia sa na gugusu lavata. ");
INSERT INTO lga_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ko na ginugua vei isa sa sa tavaisongonia Babeli sa na ia isa ura ketakoi i Iahova sa vairurainiria sa na paranga tana kasia abana doruna. Ko koko ketakoi sa i Iahova sa vaqaqataria tinganai vei eqa pa abana doruna sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Alepi sa na vavakatona na tutina i Semu. Karu aoro pa liguna na popogoso kolo, totonai kai gogoto aorona si Semu, qi vaporea isa si Apasadi. ");
INSERT INTO lga_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Beto pa liguna qi pore i Apasadi sa qi suvere mutugu ka lima gogoto aoro si Semu ko qi vaporeria mutugu sa kaki tuna marene na rereko. ");
INSERT INTO lga_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Totonai qi kamua ka uengavululima aorona si Apasadi, qi vaporea isa si Sela. ");
INSERT INTO lga_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Beto pa liguna qi pore i Sela sa qi suvere mutugu ka made gogoto ka ue aoro si Apasadi ko qi vaporeria mutugu sa kaki tuna marene na rereko. ");
INSERT INTO lga_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Totonai qi kamua ka uengavuluputa aorona si Sela, qi vaporea isa si Ebe. ");
INSERT INTO lga_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Beto pa liguna qi pore i Ebe sa qi suvere mutugu ka made gogoto ka ue aoro si Sela ko qi vaporeria mutugu sa kaki tuna marene na rereko. ");
INSERT INTO lga_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Totonai qi kamua ka uengavulu made aorona si Ebe, qi vaporea isa si Peleqi. ");
INSERT INTO lga_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Beto pa liguna qi pore i Peleqi sa qi suvere mutugu ka made gogoto uengavuluputa aoro si Ebe ko qi vaporeria mutugu sa kaki tuna marene na rereko. ");
INSERT INTO lga_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Totonai qi kamua ka uengavuluputa aorona si Peleqi, qi vaporea isa si Reu. ");
INSERT INTO lga_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Beto pa liguna qi pore i Reu sa qi suvere mutugu karu gogoto sia aoro si Peleqi ko qi vaporeria mutugu sa kaki tuna marene na rereko. ");
INSERT INTO lga_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Totonai qi kamua ka uengavulu karu aorona si Reu, sa qi vaporea isa si Seruqi. ");
INSERT INTO lga_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Beto pa liguna qi pore i Seruqi sa qi suvere mutugu karu gogoto vitu aoro si Reu ko qi vaporeria mutugu sa kaki tuna marene na rereko. ");
INSERT INTO lga_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Totonai qi kamua ka uengavuluputa aorona si Seruqi, qi vaporea isa si Naho. ");
INSERT INTO lga_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Beto pa liguna qi pore i Naho sa qi suvere mutugu ka aru gogotoputa aoro si Seruqi ko qi vaporeria mutugu sa kaki tuna marene na rereko. ");
INSERT INTO lga_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Totonai qi kamua ka rabete sia aorona si Naho, qi vaporea isa si Tera. ");
INSERT INTO lga_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Beto pa liguna qi pore i Tera sa qi suvere mutugu kai gogoto manogasia aoro si Naho ko qi vaporeria mutugu sa kaki tuna marene na rereko. ");
INSERT INTO lga_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Pa liguna qi kamua ka vitu ngavuluputa aorona si Tera, qi vaporeria isa sira Ebarami, i Naho beto i Harani. ");
INSERT INTO lga_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Alepi sa na vavakatona na tutina i Tera. I Tera sa vaporeria sira Ebarami, i Naho beto i Harani. Beto i Harani sa vaporea si Loti. ");
INSERT INTO lga_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Totonai korapa toana tu i Tera na tamana sa, sa mate si Harani pa Ur na gugusu tadira na tinoni Kaledia, na ia ketakoi sa podo. ");
INSERT INTO lga_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ira Ebarami beto i Naho sa qai okoto teku maqotadi. Na isongona na maqotana i Ebarami si Serai beto na isongona na maqotana i Naho si Milika; i Milika sa na tuna rereko i Harani isa na tamadi ira Milika i Isika. ");
INSERT INTO lga_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ego i Serai sa qi kepore tuna ura na egoro sisa. ");
INSERT INTO lga_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","I Tera sa tonia si Ebarami isa na tuna marene, i Loti nona mabusu isa na tuna i Harani beto i Serai na roana isa na maqotana i Ebarami beto ko qai mekarai taloa pa Ur na gugusu tadira na tinoni Kaledia ko mai lao pa Kenani qarigu. Ba totonai qai kamu pa Harani sa, qai suvere togasa gu ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Sa kamua karu gogoto lima aorona si Tera beto sa sa mate pa Harani. ");
INSERT INTO lga_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ego qi pojania i Iahova si Ebarami, <<Mu loai na mua gugusu, na tavitimu beto na mua tatamana beto ko mu lao pa ia mana vabatinigo ara. ");
INSERT INTO lga_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Mana roiti veinigo kai bubutu tinoni poreveveina ara sao Beto mana mananigo ara sao; Mana vaporeveveinaia ara sa na isongomu ao, Beto ao sa muna vuvugu vaniria na mana ira na tinoni. ");
INSERT INTO lga_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mana mananiria ara sira na tinoni mai mananigo, Isa mina levenigo ao sa ara mana levenia tugu; Beto doruna na tinoni pa abana Sa mai teku mana tamu,>> qiu sisa. ");
INSERT INTO lga_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ko sa taloa si Ebarami vei sa ule vei vania perangana i Iahova ko i Loti sa qaqiri tutia sisa. Ka vitu ngavulu lima aorona si Ebarami totonai sa taloa riu koko pa Harani ");
INSERT INTO lga_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Sa tonia si Serai na maqotana, i Loti na vabuguna, doru na isisongo qai kole tauku vaikamuniria beto ira na tinoni qai tekuria pa Harani, beto ko qai gore vei pa ia pa Kenani tinganai ko qai kamu tu ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ego sa rerege tomea i Ebarami sa na ia isa ko sa kamu tu pa ia sa kole na gou lavata pa More pa Sekemu. Na totoso isa sa ira na bubutu tinoni Kenani sa qai suvere pa ia isa. ");
INSERT INTO lga_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Sa votu tai Ebarami si Iahova ko sa paranga, <<Na vuamu ao mana vaniria ara sa na ia lani,>> saunia. Ko sa vaturua i Ebarami sa kai ia vavakukuvuna ketakoi lao tai Iahova isa qi votu tana. ");
INSERT INTO lga_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Beto koko ketakoi sa sa gogojo lao vei tu pa moedi na kukubo pa kalena pa Beteli keta pa sagere tapo ko sa vaturua nona aqaqo pa vaikorapaina pa Beteli keta pa suvu tapo beto pa Ai keta pa sagere tapo. Ketakoi sa vaturua isa sa kai ia vavakukuvuna lao tai Iahova beto sa kuku vatarasae isa sa na isongona i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Beto poni sa taloa si Ebarahami ko sa gogojo gore vei tu pa Negev. ");
INSERT INTO lga_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ego sa raja sa na songe pa ia isa, ko i Ebarami sa sa gore ko mi suvere vei kai tinoni karovona tu pa Ijipi sau ura sa raja vaneneqi sa na songe. ");
INSERT INTO lga_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Totonai sa tata tome pa ijipi poni sa pira sau si Ebarami lao tai Serai na maqotana, <<Ago! Qa gigilai qua ara sa na rereko babata jonga sao. ");
INSERT INTO lga_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Totonai mai batigo ira na tinoni Ijipi sa pira marigu, Na maqotana tugu isa sa le alepi marigu. Ko mai vaisiu sara goto ao kode maike kotigo. ");
INSERT INTO lga_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ko na luluqu ara sina munaguniria ko mai kopu vatalenisiu beto maike vamate talenisiu ara sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ko totonai sa kamu pa Ijipi si Ebarami sa, qai batia tugu ira tinoni Ijipi sa na rereko babata jonga si Serai. ");
INSERT INTO lga_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Beto totonai qai batia ira na tinoni lalavata tai Pero sisa sa qai riu vanyonyoro vania si Pero ko sa tatoni lao pa ruma tana bangara si Serai. ");
INSERT INTO lga_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pa laena i Sera sa sa kopu vatalenia i Pero si Ebarami ko sa teku isongoria na sipi, na bulumakau, na dongiki marene na rereko, na nabulu marene na rereko beto na kameli si Ebarami. ");
INSERT INTO lga_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ba pa laena i Sera na maqotana i Ebarami sa sa varajaniria na mo ikikekerena i Iahova si Pero beto ira na tinoni qai suvere pa nona ruma lavata. ");
INSERT INTO lga_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ko sa kuku vakamua i Pero si Ebarami, pira saunia, <<Na sa sa qu roiti lamenia ao taqu? Na maqotamu tu ao sina, ba ai sa vei ko quke ule vanisiu? ");
INSERT INTO lga_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ai sa vei ko qu paranga, Na luluqu ara sina qugu ko qa tekua ko qa nago veinia na maqotaqu. Ko ina! Tekua na maqotamu. Tonia ko mu riu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Beto ko sa parangaria nona tinoni si Pero pa veveina i Ebarami ko qai garunu variua sisa tavitia na maqotana beto doru sakasava sa isongoria. ");
INSERT INTO lga_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ko i Ebarami sa koko pa Ijipi ko sa mule sae pa Negev ko sa tonia isa sa na maqotana beto doru sakasava qi isongoria beto ko i Loti sa tutia sisa. ");
INSERT INTO lga_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Qi tinoni isisongona si Ebarami ko qi isongoria isa sira na mamanugu mamade nene papausu beto na siliva beto na qolo. ");
INSERT INTO lga_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Sa koko pa Negev sa, sa lao kai ia ka ia tinganai ko sa kamu pa Beteli, pa ia pa vaikorapaina pa Beteli beto pa Ai ketakoi qi vaturu aqaqo mai perangana ");
INSERT INTO lga_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","beto ketakoi qi roitinia mai kai ia vavakukuvuna. Ketakoi sa sa kuku vatarasaea i Ebarami sa na isongona i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ego i Loti isa sa kole tututia lekogo i Ebarami, ba qi isongoria tugu vei na gogodo sipi, na bulumakau beto na aqaqo. ");
INSERT INTO lga_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ba na ia sa sake padaria totonai qai mekarai suvere ura qai soku jola sa na isisongo tadira karu ko qaike boka mekarai suvere vaikamu. ");
INSERT INTO lga_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Beto qai vavaigua lao gu sira na tinoni kopu ma manugu papausu tadira Ebarami i Loti. Beto ko ira na bubutu tinoni Kenani beto na Perizai ba qai korapa tugu suvere sa ketakoi pa totoso isa. ");
INSERT INTO lga_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Ko i Ebarahami sa parangia i Loti, pira saunia, <<Tuqu! Take vavaigua gita karu babi ira noda tinoni kopu mamanugu papausu ura nake goto sa gita karu. ");
INSERT INTO lga_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ko na ia doruna sa qu batiamua gu ke. Ko ta suvere pikata tu. Vei muna lao vei pa kale meri ao sa, mana lao vei pa kale matua sara ba vei pa kale matua tu munagu sao, sa mana lao vei pa kale meri sara,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Sa enga sae si Loti, sa batia isa sa na are doruna pa Jodani sa sa lolomoso vatale, vevei na inuma tai Iahova, vevei na ia pa Ijipi lao vei pa Zoa. (Api sa tonai sa oqoro piaria pa Sodomu beto pa Qomora i Iahova.) ");
INSERT INTO lga_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ko i Loti sa vile mekana sa na are doruna pa Jodani beto ko sa taloa riu lao vei pa kale sagere tapo. Ko qai pikata sira karu. ");
INSERT INTO lga_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","I Ebarami sa suvere pa ia pa Kenani, goto i Loti sa suvere pa vaikorapaidi na gugusu lalavata pa arare lavata ko sa vaturua nona aqaqo tata pa Sodomu. ");
INSERT INTO lga_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ego ira na marene pa Sodomu sa qai kole gu roiti vaikikerai beto roiti valululasa isa vei sake qerania i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ego pa liguna qi taloa riu si Loti koko tai Ebarami, sa paranga si Iahova tana, <<Mu enga sae koko ketakoi qu korapa turu beto mu doro lao pa kale saena, pa kale gorena, pa kale sagere tapo, beto pa kale suvu tapo. ");
INSERT INTO lga_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Doru na ia qu batia sa mana vanigo ao ara beto ira na tutimu ao kamua na kamua ");
INSERT INTO lga_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Na tutimu ao sa mana roiti veiniria na kavuruna na peso ara ko na tinoni mina boka anyea na kavuruna na peso sa, mina boka anyea sa na tutimu ao. ");
INSERT INTO lga_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ko lao, mu lekogo dogoria sa na kakasana beto na revatana na ia doruna, ura qa vanigo ara ao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ko sa varijoria nona aqaqo si Ebarami ko sa lao suvere tata pa boko gogou lalavata tai Mamiri pa Heboroni, ketakoi sa roitinia isa sa kai ia vavakukuvuna lao tai Iahova. ");
INSERT INTO lga_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Pa totoso api sa i Amarapele na bangara pa Sina, i Arioki na bangara pa Elasa, i Kedolaoma na bangara pa Elami beto i Tidali na bangara pa Qoimi ");
INSERT INTO lga_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","sa qai rajai i Bera na bangara pa Sodomu, i Bisa na bangara pa Qomora, i Sinabi na bangara pa Adama, i Semeba na bangara pa Zeboimi beto na bangara pa Bela (isa pa Zoa). ");
INSERT INTO lga_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ira doru na babangara qai tapoja liligu aipira sa qai vaikamuniria sira na dia tinoni vaipera pa lolomo pa Sidimi (na solo ivere). ");
INSERT INTO lga_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ka manogarua aoro sa i Kedolaoma qi bangaraniria sira ba pa vina manogaue aoro sa qai daidia tutia sisa. ");
INSERT INTO lga_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Pa vina manogamade aoro sa, i Kedolaoma beto ira na bangara qai vaivaego ko mai mekarai vaitokai qarigu sa qai riu ko qai vakilasaria sira na bubutu tinoni Repai pa Asiteroti Kanaimi, na bubutu tinoni Zuzi pa Hami, na bubutu tinoni Emai pa Save Kiritaimi ");
INSERT INTO lga_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","beto na bubutu tinoni Hori pa kukubo pa Sei, ko lao kamu tu pa Eliparani tata pa qega. ");
INSERT INTO lga_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Beto poni sa qai vidulu mule ko qai lao pa Enimisipati (isa pa Kadesi) ko qai vakilasaria sa na pikata ia doruna tadira na bubutu tinoni Amelekai beto vei tugu ira na bubutu tinoni Amorai qai korapa suvere pa Hazazoni Tama. ");
INSERT INTO lga_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Poni na bangara pa Sodomu, na bangara pa Qomora na bangara pa Adama, na bangara pa Zeboimi beto na bangara pa Bela (isa pa Zoa) sa qai mekarai riu ko qai vaturu nanamaria sa na dia tinoni vaipera pa lolomo pa Sidimi ");
INSERT INTO lga_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ko mai rajaria qarigu sira Kedolaoma na bangara pa Elami, i Tidali na bangara pa Qoimi, i Amirapele na bangara pa Sinar beto i Arioki na bangara pa Elasa- ka made bangara qai taleria ira ka lima. ");
INSERT INTO lga_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ego na lolomo pa Sidimi sa sa pugelia na baongo oqili nyelaka tapa ko totonai qai uku tatagara riu sira na bangara pa Sodomu beto pa Qomora sa, kaki dia tinoni vaipera sa qai vukele joloponiria pa baongo oqili goto ira doru sa qai tula riu pa kukubo. ");
INSERT INTO lga_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Qai aru tekuria ira ka made bangara sa doru isisongo tadira pa Sodomu beto pa Qomora beto na gadia gagani beto ko qai riudia. ");
INSERT INTO lga_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Qai teku riunia tugu vei si Loti na vabuguna i Ebarami beto nona isisisongo ura na suverena pa Sodomu sisa. ");
INSERT INTO lga_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kame isa sa uku sa sa kamu ko sa vavakato vania si Ebarami na tinoni Hiburu. Ego i Ebarami sa na suverena tata pa gogou lalavata tai Mamiri na tinoni Amorai, na tasidi marene ira Esikolo, i Ane, ira doru vei qai baere lame taii Ebarami. ");
INSERT INTO lga_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Totonai i Ebarami qi nongoronia qai teku riu vapinausia sa na vabuguna, poni sa sa kukuria sira ka ue gogoto manoga vesu tinoni bobokadi pa vaipera qai podo lavata sae pa nona tatamana beto ko sa riu adu tututiria kamu tu pa Dani. ");
INSERT INTO lga_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Na bongi sa pikataria i Ebarami sira nona tinoni vaipera ko qai rapataria ko qai vakilasaria beto qai adu vatatagararia kamu tu pa Hoba, kale saena pa Damasikasi. ");
INSERT INTO lga_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Sa teku muleniria i Ebarami sa doruna na isisongo beto vei tugu i Loti na vabuguna beto na sakasava sa isongoria, beto tavitiria na rereko beto ira na tinoni mai tavapinausu qariguniria. ");
INSERT INTO lga_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Pa liguna sa vakilasia i Kedolaoma beto ira na bangara qai tokania isa sa, na bangara pa Sodomu sa lame gosoria si Ebarami pa lolomo pa Save (isa na lolomo tana bangara) totonai sa mule. ");
INSERT INTO lga_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Poni i Melekizedeki na bangara pa Salemi sa pogoso kamu bereti beto na vaini. Na iama tana Tamasa ululuna jola sisa, ");
INSERT INTO lga_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ko sa manania isa si Ebarami, pira sau, <<Mi tamana tana Tamasa ululuna jola si Ebarami, Na Tamasa sa vapodakia na oka beto na peso. ");
INSERT INTO lga_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Beto mi tavatarasae sa na Tamasa ululuna jola, Isa sa vakole laoria pa limamu ao sira na mua kana,>> sau sisa. Beto poni sa vania i Ebarami kame pa manoga pa doru sakasava sisa. ");
INSERT INTO lga_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sa paranga sa na bangara pa Sodomu lao tai Ebarami, <<Ira na tinoni sa mu valame vanisiu ara goto ira na sakasava sa mu kopuniria mua,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ba sa paranga tu si Ebarami lao tana bangara pa Sodomu, <<Qa tei alaka saenia tu na limaqu ko qa maulu tai Iahova, na Tamasa ululuna jola, isa sa vapodakia na oka beto na peso ");
INSERT INTO lga_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ko manake isongo tekua kai sakasava tamu, bi na loji gu sa babi na gasoro buti gu, kita vei ko ao mu paranga, <Ara qa vaisisongia si Ebarami> mugu. ");
INSERT INTO lga_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ko manake tekua tugu kai sa goto na sa vei ira na tinoni taqu qai tei gania tu beto na iadi ira na tinoni qai tutisiu ara- ira Ane, i Esikolo beto i Mamiri sa mai tekua tugu sa na iadi,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Pa liguna api, na paranga tai Iahova sa lame tai Ebarami pa dodogoro. <<Muke matagutu, Ebarami. Ara sa na mua naqe, Na mua pinia poreveveina jola,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ba sa paranga tu si Ebarami, <<Kei bangara Iahova, na sa muna boka vanisiu ura ara kepore tuqu beto isa na tinoni mina teku vakarovia na isisongo taqu sa i Elieze na tinoni Damasikasi tu?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Beto sa paranga mule si Ebarami, <<Quke vanisiu na koburu ke; ko kai nabulu gu pa qua tatamana sa mina beisiu sara,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Poni sa lame tana sa na paranga tai Iahova: <<Na tinoni api sa minake beigo ao goto kai tumu marene mekamu tu mina koko lame vei pa tinimu mekamu sa mina beigo ao,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Beto sa toni votunia pa peguru beto sa paranga, <<Mu enga saea na oka beto mu anyeria sa na seru- vei sosoto tugu muna boka anyeria ao sa,>> sau. Beto sa paranga mutu, <<Mai vei inara sa na tutimu ao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Poni i Ebarami sa vasosotoa si Iahova ko i Iahova sa pojania na tinoni tuvisina sisa. ");
INSERT INTO lga_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Beto sa paranga lao tana mutugu, <<Ara si Iahova, qa toni votunigo pa Ur tadira na tinoni Kaladia ko ma vanigo na ia api ko mu isongia qau,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ba sa paranga tu si Ebarami, <<Kei bangara Iahova, Ai vei mana boka gigilai ara mana teku isongia sisa?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Poni sa paranga si Iahova tana, <<Mu teku vakamu vanisiu kai bulumakau kokoregana, kai qoti beto kai rami okoto ka ue aorodi, tavitiria kai kuru bora beto kai kuru kavu kokoregana,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ko sa teku vakamuria i Ebarami tana sa dorudi aipira, sa kobu ruaria beto sa vakole tuturu vaikaleniria sa na kokobudi; goto ira na mamanugu tatava sa sake kobu ruaria. ");
INSERT INTO lga_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Poni qai tatava kamu sira na mamanugu tatava gagani mamanugu pa kokobu tini matedi, ba sa adu variuria i Ebarami. ");
INSERT INTO lga_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Totonai sa korapa gore suvu na tapo, sa puta mumagana tu si Ebarami, poni sa kai rodomo kukuni vaivamatagutuna sa sa toqo pa arena isa. ");
INSERT INTO lga_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Beto sa paranga si Iahova tana, <<Mu gigila vatalea ao sa ira na tutimu ao sa mai tinoni kamudi pa ia qaike isongia, mai tavapinausu beto mai tangangangulu ka made gogoto puputa aoro, sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ba mana vakilasia ara sa na bubutu tinoni ketakoi mai tavapinausu ira beto pa liguna sa mai votu riu tavitia soku isisongo poreveveidi. ");
INSERT INTO lga_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ba ao sa muna baragoso vaparoi tu beto sa muna riu vabubulemua tutiria na mua tite. ");
INSERT INTO lga_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Pana vinamade sasae tinoni sa ira na tutimu ao sa mai mule kamu lani, ura na sela tadira na bubutu tinoni Amorai sa sa oqoro jutu kamua na ikerena sosoto,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Totonai qi tei suvu tu sa na tapo ko sa tei opo tu sa na rodomo, poni sa kai raro mamanginina sa votua na tula tavitia kai gou iku vuvurungu sa sa bola votu beto sa alokata pa vaikorapaidi na kokobu tinidi na mamanugu. ");
INSERT INTO lga_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Na rane isa i Iahova sa roitinia na vinaego tai Ebarami, ko pira sau, <<Na ia api sa qa vaniria ara na tutimu ao, koko pa ovuku pa Ijipi ko mi lao kamu pa ovuku lavata pa Eupareti- ");
INSERT INTO lga_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","na ia tadira na bubutu tinoni Kenai, na Kenizai, na Kadimonai, ");
INSERT INTO lga_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","na Hitai, na Perizai, na Repai, ");
INSERT INTO lga_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","na Amorai, na Kenani, na Qiqasai beto na Jebusai,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ego i Serai, na maqotana i Ebarami sa sake boka vapore vania na koburu si Ebarami. Ba sa isongia isa sa kai nabulu rereko Ijipi na isongona i Haqa; ");
INSERT INTO lga_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ko sa pojania si Ebarami, <<I Iahova sake vabokasiu ko mana isongo koburu sara. Ko mu lao puta tavitia na nabulu rereko taqu poni; palu pa boka tana mana boka podalainia kai tatamana,>> sau. Poni sa nongoria i Ebarami sa na ovovelena i Serai. ");
INSERT INTO lga_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ko pa liguna sa suvere pa Kenani ka manogaputa aoro si Ebarami sa, sa tekua i Serai si Haqa na ona nabulu rereko beto ko sa vania na marenena ko sa veinia na maqotana. ");
INSERT INTO lga_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ko i Ebarami sa puta tavitia si Haqa ko sa pore iapana tu. Totonai sa gigilai sa bogata si Haqa, sa podalai dodogoro vagorea isa sa na ona iviva rereko lavata. ");
INSERT INTO lga_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Poni pira sau si Serai lao tai Ebarami, Na tapata ao qu roitinia sa qa korapa gosoroni vitigi ara. Qa vanagonigo sa na qua nabulu beto kopira sa gigilai sa bogata sisa sa sa dodogoro vagoresiu sara. I Iahova mi pitua sa i sei sa sa sela gita karu, saunia. ");
INSERT INTO lga_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Poni pira sau si Ebarami, <<Ao gu qu gigilai sa na mua nabulu, mu roiti laonia tana isa vei qu rovea sa jonga,>> saunia. Poni sa komiti vikeria i Serai si Haqa ko sa uku riuona. ");
INSERT INTO lga_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ego na mateana tai Iahova sa batia si Haqa tata pa kai vuvugu pie pa qega, na vuvugu pie isa sa pa keketaina na soana sa lao pa Sua. ");
INSERT INTO lga_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ko pira saunia, <<Haqa, ao na nabulu tai Serai, Pai qu koko lame vei beto pai qu korapa lao vei sao?>> sau. Sa oe lao si Haqa, <<Qa korapa ukunia i Serai na qua iviva rereko lavata,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Poni sa pojania na mateana tai Iahova, <<Mu mule lao tana mua iviva rereko lavata beto mu suvere vaiketai tana,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Beto pira saunia mule na mateana, <<Mana vavovonua ara sa na tutimu ao ko maike jonga taanye betodi,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Beto pira saunia mutu na mateana tai Iahova sisa: <<Kopira qu bogata sao Kode muna vaporea kai tumu marene. Muna vaisongonia i Isimeli, Ura i Iahova sa nongoria na mua kekebo. ");
INSERT INTO lga_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Isa sa mina kai tinoni piruna vei na dongiki; Mina komitiria gu sa doru tinoni Beto doru tinoni ba mai komitia tugu Beto mina suvere vaikanai Lao tadira doru tasina marene sisa,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Beto sa vania na isongo si Iahova isa sa parangia, <<Ao sa na Tamasa qu batisiu>> ura pira sau si Haqa, <<Kopira qa batia sa na tinoni isa sa batisiu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Isa sa na ginuana vei beto sa tavakukunia Bia Lahai Roi sa na oqili pie sa korapa tugu koleona kamua kopira, pa vaikorapaina pa Kadesi beto pa Beredi. ");
INSERT INTO lga_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Ko i Haqa sa vapodo vania kai koburu marene si Ebarami ko i Ebarami sa vaisongonia i Isimeli sa na tuna marene sa vapodo vania i Haqa. ");
INSERT INTO lga_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ka vesu ngavulu vonomo aorona si Ebarami totonai i Haqa sa vapodoa si Isimeli. ");
INSERT INTO lga_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Totonai sa kamua ka sia ngavulu ka sia aorona si Ebarami sa, sa votu tana si Iahova beto sa paranga, <<Ara sa na Tamasa neqiqu jola, mu tutia na qua paranga beto mu toania na toa tuvisina. ");
INSERT INTO lga_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Mana vatoqonigo ara ao sa na qua vinaego beto mana vavua vasosokugo ara sao,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Poni sa vukele opo gore si Ebarami, beto pira saunia na Tamasa sisa, ");
INSERT INTO lga_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","<<Ara sa na qua vinaego qa vatoqonigo sapi, Ao sa muna tamadi ira doru na bubutu tinoni. ");
INSERT INTO lga_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Minake takuku ligunia i Ebarami sa na isongomu ao, gotona isongomu kopira si Ebarahami tu, ura muna tamadi soku bubutu tinoni mana veinigo ara. ");
INSERT INTO lga_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mana vavua vasosokugo ara sao, tamu mai pidoko votu lame sa na bubutu tinoni beto ira na babangara. ");
INSERT INTO lga_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Mana vatoqonigo ara ao sa na qua vinaego kole jolana, beto ira na tutimu vuka risa tadira na sasae tinoni korapa lame, ko ara sa mina mua Tamasa ao beto tadira na tutimu ao pa ligumu. ");
INSERT INTO lga_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Na ia doruna pa Kenani, ketakoi qu korapa suvere kopira vei na tinoni karovomu sa, mana vaisongonigo ao beto ira na tutimu ao vuka risa kamua na kamua beto ara sa mina dia Tamasa ira,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Beto poni sa paranga mutu sa na Tamasa lao tai Ebarahami, <<Goto ao sa, muna kopunia sa na vinaego taqu, ao beto ira na tutimu pa liguna lao tadira na sasae tinoni korapa lame. ");
INSERT INTO lga_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ko alepi sa na vinaego taqu qa vatoqonigo ao beto ira na tutimu ao ko muna kopunia agou pa liguna lao: Doru marene korapa suvere tavitigo ao sa mai isongo tapobe beto. ");
INSERT INTO lga_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Muna pobea sa na vulitina na batu nonoimiu ko isa sa na vinagigilana na vinaego pa vaikorapaida gita karu. ");
INSERT INTO lga_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Pa dorudi na sasae tinoni korapa lame sa, doru marene sa mai isongo tapobe pa vinavesu rane liguna mai podo, tavitiria tugu vei ira mai podo lame pa miu tatamana babi mai tavai pa poata tadira na tinoni karovodi ira nake tavitimiu. ");
INSERT INTO lga_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Bai podo lame tu pa miu tatamana babi tavai tu pa miu poata ba mai isongo tapobe tugu. Na qua vinaego qa roitinia pa tinimiu sa mina kole jola kamua na kamua. ");
INSERT INTO lga_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Na marene sake tapobe na vulitina na batu nonoina sa mina tapikata pale tadira na bubutu tinoni ura sa majai na qua vinaego ara,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Na Tamasa sa parangia si Ebarahami, Pira saunia, <<I Serai na maqotamu sa munake kuku ligunia na isongona i Serai ura i Sera tu sa na isongona isa kopira. ");
INSERT INTO lga_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mana manania ara sisa ko sosoto jola sa mina vapore vanigo ao kai koburu marene. Mana manania ara sisa ko mina tinadi na bubutu tinoni beto na babangaradi na tinoni sa mai koko lame vei tana,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Poni sa vukele opo gore si Ebarahami, sa avu beto pira sau mulenia mekana, <<Mina vaporea tu kai koburu marene sa na tinoni kai gogoto aorona? Mina vapodoa tu kai koburu si Sera ka sia ngavuluputa aorona?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Beto sa paranga lao tai Tamasa si Ebarahami, <<Ai Vei i Isimeli gu sa bi toania na tavaragua tamu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Poni sa paranga na Tamasa tai Ebarahami, <<E, ba i Sera na maqotamu mina vapore vanigo tugu kai koburu marene ko muna vakukunia i Aisake. Mana vatoqonia ara i Aisake sa na qua vinaego, isa mina kole jola kamua na kamua tadira na tutina isa vuka risa. ");
INSERT INTO lga_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Goto pa kalena tai Isimeli sa, qa tei nongorigo tu: ko sosoto jola kode mana manania tugu ara sisa, mana vavua vasosokua beto mina mota tu lalaona sa na tutina isa. Isa sa mina tamadi ira ka manogarua bangara bubutu beto mina taroiti tana sa kai bubutu tinoni lavata. ");
INSERT INTO lga_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ba na qua vinaego sa mana vatoqonia tai Aisake isa mina vapodo vanigo i Sera pa totoso vei api pa aoro lame ina,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Pa liguna qi kole parangia i Ebarahami, sa taloa saeona sa na Tamasa. ");
INSERT INTO lga_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Pa vagigila rane tugu isa sa, i Ebarahami sa tekua si Isimeli na tuna marene beto dorudi ira qai podo pa nona tatamana babi sa vainiria nona poata, doru marene pa ruma tai Ebarahami beto ko sa poberia na batu nonoidi vei sa garununia na Tamasa. ");
INSERT INTO lga_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ka sia ngavulu sia aorona si Ebarahami totonai sa tapobe na vulitina na batu nonoina, ");
INSERT INTO lga_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","goto i Isimeli na tuna marene sa ka manoga ue aorona sa tonai sa tapobe na vulitina na batu nonoina. ");
INSERT INTO lga_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ko pa kai muqisi rane tugu isa sa qai tapobe beto sira Ebarahami beto i Isimeli na tuna marene. ");
INSERT INTO lga_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Beto doru marene qai suvere tana tavitiria ira qai podo pa ruma tana babi qai tavai poata tadira na tinoni karovodi sa qai somana tapobe tugu tonai tavitia isa. ");
INSERT INTO lga_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ego i Iahova sa votu tai Ebarahami tata pa gogou lavata tai Mamiri totonai sa dadanga na rane ko sa korapa toqona pa atakamanana nona aqaqo. ");
INSERT INTO lga_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Sa enga sae sau si Ebarahami sa batiria sa kue tinoni korapa turudia gu pa tatana. Ko totonai sa batiria, poni sa sa taloa tugu pa nona atakamana nona aqaqo poni ko sa abutu lao gosororia beto sa titi opo gore pa peso. ");
INSERT INTO lga_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Beto sa paranga, pira sau, <<Qua bangara, vei bu tavaraguanisiu ara sao sa muke alokata jola pale na mua nabulu. ");
INSERT INTO lga_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mai pogoso lamenia mai iqopeki pie ko mu loqaria mai na nenemiu beto mu minere mai pa kauru gou api. ");
INSERT INTO lga_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ma teku vanigou kaki sa ko mu tekua mai ko mu boka neqi ligu beto poni sa mu gojo riumiu pinakoi tugu qu kamu tana mua nabulu,>> sauniria. Qai oe lao sira, <<Koi! Jongana ropi, mu roitinia tu na sa qu pojai ao,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ko sa sisiqarai lao tome pa aqaqo kamua i Sera si Ebarahami beto sa paranga, <<Mu sisiqarai sepoa kue kapa palava liosona, mu monyoa beto mu paruguria kaki bereti,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Beto poni sa abutu lao pa gogodo bulumakau ko sa vilea kai tuni bulumakau kokoregana vavaguana beto sa vania kai ona nabulu ko sa riu sisiqarai vatunua. ");
INSERT INTO lga_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Beto poni sa pogosoria i Ebarahami sa kaki sakasa mumunyaladi beto na meleke beto na tuni bulumakau sa tavatunu ko sa lao vakole vaniria pa moedi. Beto totonai qai kole teteku ira poni sa sa lao turu tataria pa kauru gou sisa. ");
INSERT INTO lga_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Qai nanasia, <<Goto pai tu si Sera na maqotamu?>> qarigunia. Sa oe sisa, <<Koi! Korapa pa aqaqo,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Poni sa paranga si Iahova, <<Sosoto jola sa papada vei tugu pa totoso api na aoro lame poni sa mana mule kamu tamu sara sa kode i Sera na maqotamu sa mina isongia kai tuna marene,>> saunia. Ego i Sera sa totonai sa korapa gu nonongorona pa atakamanana na aqaqo pa liguna isa. ");
INSERT INTO lga_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ira Ebarahami i Sera sa qai tei baragoso qoele vapaparoi tu beto i Sera ba sa tei pidili tu sa na soanana na totoso popu tadira na rereko. ");
INSERT INTO lga_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ko i Sera sa avu golomo mekana ko pira sau, <<Karuro! Qai kajivi vei pira beto na kalequ ba sa baragoso, ko kode mana isongia tu ara kopira sa na vaileana?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Poni sa paranga si Iahova tai Ebarahami, <<Ai sa vei ko sa avu tu si Sera ko pira sau, <Sosoto tugu mana vaporea kai koburu kopira qa qoele vei pira?> sau. ");
INSERT INTO lga_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ai vei kaki sakasa sa tapatia si Iahova? Ara mana mule kamu tamu pa totoso tavilena na aoro lame poni sa i Sera mina pore kai tuna marene,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","I Sera sa matagutu ko sa oso, pira sau, <<Ara qake avu,>> sau. Ba sa paranga tu sisa, <<E, qu avu tugu sao>>, Saunia. ");
INSERT INTO lga_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Totonai qai turu ko mai riudia qarigu sira ka ue tinoni sa qai dogoro gore lao vei pa Sodomu, beto i Ebarahami sa rerege tavitiria ko mi loa variuria sau. ");
INSERT INTO lga_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Poni sa paranga si Iahova, <<Ai vei, Mana golomia tu beka tai Ebarahami ara sa na sa ma qaqiri roitinia qau? ");
INSERT INTO lga_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","I Ebarahami sa kode mina kai bubutu tinoni lavatana sosoto beto neqina jola, beto doru pupuku tinoni pa abana sa mai teku mana tana. ");
INSERT INTO lga_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ura qa tei vilea tu ara sisa ko mina gaitiria sira na tuna beto ira na tutina pa liguna isa ko mai kopunia sa na vavanau tai Iahova ko mai roitiniria na sakasava sa tuvisi beto sa garo, ko i Iahova mina vagore votua tai Ebarahami sa isa vei sa pojai isa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Beto sa paranga si Iahova, <<Na tinajutu qai tajutunia ira pa Sodomu beto pa Qomora sa sa lavata jola beto na sela qai roitiniria sa sa mamata gigiri ");
INSERT INTO lga_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ko sa vei sa ara mana gore dogoria moko vei na sa qai roitiniria ira sa sa ikerena sosoto tugu vei na vavakato sa kamusiu ara. Vei minake vei sa, ara kode mana gigilai,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Qai gabala riudia sira beto qai lao vei pa Sodomu, goto i Ebarahami sa turuona tugu pa moena i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Beto poni sa rerege tata lao tana si Ebarahami ko pira sau, <<Ai vei, muna saqu pale tavitiniria tugu ao ira na tinoni ikikeredi sira na tinoni tuvisidi? ");
INSERT INTO lga_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Palu ira ka lima ngavuluputa tinoni tuvisidi sa qai suvere pa gugusu lavata. Ai vei kode muna saqu pale tugu ao ko munake loa vatoai sa na gugusu isa pa laedi ira ka lima ngavuluputa tinoni tuvisidi qai suvere ketakoi? ");
INSERT INTO lga_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Bi maragovi tu muna roitinia ao sa vei isa ura kode muna vamate tavitiniria ira na tinoni ikikeredi sira na tinoni tuvisidi ko mina vei sa ira na tinoni tuvisidi sa qu doro vaitoto veiniria gu ira na tinoni ikikeredi. Bi maragovi tu muna roiti vei sao! Ura ai sa vei, isa mina pitua na abana doruna minake boka roitinia na tuvisi?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Poni pira sau si Iahova, <<Vei mana batiria ara ka lima ngavuluputa tinoni tuvisidi pa leona na gugusu pa Sodomu poni sa pa laedi ira mana loa vatoai ara sa na gugusu doruna,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Poni sa pira sau si Ebarahami, <<Kopira sa qa varenenia gu ara sa na parangia na bangara nake savana na kavuru peso babi na kavu gu sara, ");
INSERT INTO lga_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","palu ira na tinoni tuvisidi sa ira ka lima ngavuluputa vagore palea ka lima gu. Ai ve muna piaria tugu sa na gugusu lavata doruna pa laedi ira ka lima tinoni ikikeredi gu?>> sau. Poni sa paranga sisa, <<Dai maneke piaria ara sa na gugusu vei mana batiria ara sa ka made ngavulu lima tinoni tuvisidi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Poni sa kai paranga lao mutu tana si Ebarahami, pira sau, <<Palu ira ka made ngavuluputa tugu sa mai tabata ko ai vei?>> sau. Poni sa paranga sisa, <<Pa laedi ira ka made ngavuluputa sa, manake roitinia ara sa na pipiara,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Beto pira sau si Ebarahami, <<Mavo tu! Mike tagigirinisiu ara ao na bangara. Mi vamalumusiu ko ma paranga tu. Palu ira ka uengavuluputa gu sa mai tabata ketakoi ko ai vei?>> sau. Sa oe lao sisa, <<Manake roitinia ara sa na pipiara vei mana batiria ara sa ka uengavuluputa ketakoi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Beto pira sau si Ebarahami, <<Kopira qa varenenia gu ara sa na parangia na bangara, ko palu ira ka rabeteputa gu sa mai tabata ketakoi ko ai vei?>> sau. Sa oe sisa, <<Pa laedi ira ka rabeteputa poni, maneke piaria sa na gugusu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Beto poni sa paranga mutu si Ebarahami pira sau, <<Mavo tu! Mike tagigirinisu ara na bangara. Mi vamalumusiu tu ko ma paranga kai totoso gu mule. Palu ka manogaputa tugu sa mai tabata ko ai vei?>>, sau. Poni sa oe lao sisa, <<Pa laedi ira ka manogaputa, maneke piaria ara sa na gugusu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Pa liguna qi kole parangia i Ebarahami si Iahova sa sa taloa riuona goto i Ebarahami sa muleona pa gusu. ");
INSERT INTO lga_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ego na veveluna qai kamu pa sodomu sa karu mateana ko totonai i Loti sa sa korapa toqona pa atakamana na bara totomena na gugusu lavata. Totonai sa batiria, poni sa gasa turu ko sa lao gosororia beto sa titi opo gore pa peso. ");
INSERT INTO lga_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Beto pira sauniria, <<Koi! Karu qua bangara,>> <<Bu gabala lame mai tu pa ruma taqu. Mu boka loqaria na nenemiu, mu vajola bongi mai tu beto na vuvugei jonga mutu mu iolo riu,>> sau sisa. Ba pira tu qarigu sira karu, <<Dai!>> <<Pa kakabarena tu na ia susuverena me puta,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ba sa tepa totokaria tugu i Loti sira karu ko qai tutia lao pa nona ruma ko sa vatana vaniria na tetekuna, sa parugu bereti kepore isitina beto sa qai teteku. ");
INSERT INTO lga_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tonai qai oqoro kole pa lovu poni doruna marene pa doru kokobu ia pa gugusu lavata pa Sodomu- ikete lavata sa qai idi vailivutainia sa na ruma. ");
INSERT INTO lga_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Beto qai kukua si Loti, pira qarigunia, Pai sira na marene qai kamu tamu pa bongi api? Mu vavotu vanigei ko me puta tavitiria, qarigu. ");
INSERT INTO lga_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Poni i Loti sa votu kamuria pa peguru beto sa pateia sa na atakamana pa liguna ");
INSERT INTO lga_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","beto pira sau, <<Koi muke vei, ka visa qua baere. Muke roitinia na sakasa ikikerena api. ");
INSERT INTO lga_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Dotu, pira karu tuqu maqota ara qai oqoro laoa kai marene. Ma toni votu vanigou ko agou gu qu gigilai ai muna roiti veiniria. Goto ira gu na tinoni pira sa muke kotiria ura qai kole pa kopu taqu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ba pira tu qarigu sira, <<Balau! Muke suqutugei,>> qarigu. Beto qai paranga, <<Na tinoni le alepi sa na kamuna gu lani vei na tinoni karovona ba kopira sa nyogua lalaenigita gita! Ao tu sa mene vakilasa vatatalego agei jolaniria ira inara,>> qarigunia. Qai kole tototepia si Loti beto qai sasuru lao ko mai piaria sa na atakamana qarigu. ");
INSERT INTO lga_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ba ira karu tinoni pa leo ruma sa qai kaqama votunia na limadi ko qai bako tomenia si Loti beto qai pateia sa na atakamana. ");
INSERT INTO lga_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Beto ko qai tapala valeqa paleniria sira na tinoni, ikete lavata qai turu pa atakamana ko qaike batia sa na atakamana. ");
INSERT INTO lga_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Beto karu tinoni qai paranga lao tai Loti, pira qarigu, <<Kaki mule tamu qai korapa lani- na roamu marene, na tumu marene, na tumu rereko babi kaki mule pa leona na gugusu lavata qu isongoria ao? Mu toni votuniria pa ia api, ");
INSERT INTO lga_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ura korapa me piaria agei sa na ia api qeu. Na tinajutu sa kamu ti Iahova qai tajutunia ira na tinoni lani sa, sa jola pa pada ko sa garunugei ko mene piaria sau,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ko sa votu lao si Loti ko sa parangaria sira na roana marene qai tavatuvisi ko mai alavaria na tuna rereko, Pira sauniria, <<Sisiqarai ko mu votu riu pa ia api, ura tata gu beto mina piaria i Iahova sa na gugusu lavata api,>> sau. Ba ira na roana marene sa palu sa paranga vavaivaavuona gu sau qarigu. ");
INSERT INTO lga_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Totonai sa sae na vovola rane poni, qai paranga vaneneqia na mateana si Loti, pira qarigu, <<Sisiqarai! Mu tonia na maqotamu beto karu tumu rereko qai korapa lani, kita vei ko mu tasaqu pale totonai mina tavakilasa na gugusu lavata,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Totonai sa mamavo isa poni sa qai lao tu karu tinoni ko qai saputu tekua sa na limana beto na limana na maqotana beto na limadi ira karu tuna rereko beto ko qai toni votu vasareria pa peguruna na gugusu lavata ura i Iahova sa roroquria. ");
INSERT INTO lga_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Isa tugu qai vavoturia pa peguru poni, kame ira sa pira sau, Mu uku vasarea na miu toa! Munake doro mule, beto munake tuturumua pa doru eqa araredi pori! Goto mu uku sae pa kukubo kita vei ko mu tasaqu pale riu beto, sauniria. ");
INSERT INTO lga_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ba sa paranga tu si Loti lao tadira, pira sau, <<Mavo tu, qua bangara. ");
INSERT INTO lga_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Qu tavaraguania sa na mua nabulu, beto qu vatadogoronisiu na mua roroqu lavata ko qu vasarea na toa taqu. Kode manake boka uku sae pa kukubo kita vei ko na tapata alepi mi sae kamusiu ko ma mate. ");
INSERT INTO lga_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Do! Poni sa kai gugusu ikete sa tata ketakoi mana boka uku lao ara. Mu vamalumusiu ko ketakoi ma uku lao. Sa ikete sa oko ba ketakoi kode mina sare na qua toa,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Poni pira saunia na mateana, <<Jongana ropi. Qa vaegoa ara sa vei qu pojai ao api. Ko maneke piaria ara sa na gugusu ikete qu pojai. ");
INSERT INTO lga_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ko mu sisiqarai uku lao ketakoi, ura maneke boka roitinia kai sa sara tinganai muna kamu mai tu ao ketakoi,>> saunia. Ko sa vei sa na isongona na gugusu isa sa qai vaisongonia Zoa. ");
INSERT INTO lga_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Totonai sa iolo votu sae pa arena abana sa na tapo poni sa sa kamu pa Zoa si Loti. ");
INSERT INTO lga_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Ego beto sa vaokoro tarininiria na patu kikilava vuvurungudi i Iahova sa pa Sodomu beto pa Qomora, ko na koko lagere veidi tai Iahova pa noka sa aipira. ");
INSERT INTO lga_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ko sa piara paleria i Iahova sa na gugusu aipira beto na arare doruna beto ira doru qai suvere pa gugugusu lavata beto na gogou qai toa pa peso. ");
INSERT INTO lga_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Goto na maqotana i Loti sa sa balinga mule ko sa peluku patu solona. ");
INSERT INTO lga_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Na vuvugei jonga i Ebarahami sa dorava ko sa mule sae pa ia ketakoi sa kole turu paparangia i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ego ko sa doro gore vei sa pa Sodomu beto pa Qomora, beto pa doruna na ia pa arare sa, sa batia sa iolo votu sae sa na tulana na peso isa sa vei na kunini tula sa koko pa kai iku lavata. ");
INSERT INTO lga_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ko totonai sa piararia na Tamasa sa na gugugusu lavata pa arare sa, sa roroqu kamua isa si Ebarahami ko sa teku vaukua isa si Loti pana tapata sa piararia na gugugusu lavata ketakoi qi suvere i Loti. ");
INSERT INTO lga_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ego i Loti beto karu tuna rereko sa qai taloa pa Zoa ko qai sae suvere pa kai bevi pa kukubo ura sa matagutu suvere pa Zoa sisa. ");
INSERT INTO lga_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kai rane na tuna rereko pa moa sa pojania sa na tasina rereko, pira sau, <<Ago! Na tamada sa sa baragoso, beto kepore sa kai marene pa eqa lani vei mina kole tavitigita vei isa na tutina tugu doru eqa pa abana. ");
INSERT INTO lga_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Aria ko ta vabukunia na vaini sa na tamada beto ta kole tavitia ko mi kole sa na tutida lame vei tana tamada,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Na bongi isa sa qai vabukunia na vaini sa na tamadi beto ko sa lao tome sisa pa moa ko sa kole tavitia ba na tamadi sake isongo vagigilai sa na tomena beto na votu riuna isa. ");
INSERT INTO lga_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Sa rane neqa poni sa paranga na tuna rereko pa moa lao tana tasina, pira sau, <<Pa bongi qa kole tavitia ara na tamada. Ko kode bongi tana vabukunia mule na vaini beto ao muna tome kole tavitia mule ko mi kole sa na tutida lame vei tana tamada,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ko qai vabukunia mule na vaini sa na tamadi na bongi isa, beto na tuna rereko pa ligu sa tome kole tavitia. Sake isongo vagigilai mule isa sa na tomena beto na votu riuna na tuna rereko pa ligu. ");
INSERT INTO lga_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ko sa vabogata betoria i Loti sa karu tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Na tuna rereko pa moa sa vapodoa sa kai tuna marene, sa vaisongonia i Moabi ko isa sa na tamadi ira na bubutu tinoni Moabai pa ngeni alepi. ");
INSERT INTO lga_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Na tuna rereko pa ligu ba sa vapodoa tugu kai tuna marene, sa vaisongonia i Beni- Ami ko isa sa na tamadi ira na bubutu tinoni Amonai pa ngeni alepi. ");
INSERT INTO lga_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ego i Ebarahami sa koko ketakoi sa sa gore vei pa pikata ia pa Negevi ko sa suvere pa vaikorapaina na gugusu pa Kadesi beto pa Sua. Beto ko sa suvere vei kai tinoni karovona pa Qera. ");
INSERT INTO lga_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ego ko pira saunia i Ebarahami si Sera, <<Na luluqu ara sapi,>> sau. Ko i Abimeleki na bangara pa Qera sa vaigarunu ko qai lao toni vakamu vania si Sera. ");
INSERT INTO lga_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Poni sa votu sa na Tamasa tai Abimeleki pona putagita kai bongi, pira saunia, <<Kode muna mate talenia ao sa na rereko qu tekua ina ura na rereko pore marenena sina,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ego i Abimeleki sa oqoro ulia isa si Sera ko pira sau, <<Koi! Bangara, na bubutu tinoni sa kepore na ona sela ba muna piaria tu? ");
INSERT INTO lga_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Na luluqu rereko saunisiu ke beto na rereko ba na luluqu marene saunisiu tugu. Ko pa roroqu tuvisina beto pa lima liosona qa roitinia ara sa na sakasava alepi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Poni sa parangia na Tamasa pana putagita sisa, pira sau, <<E! Qa gigilaiqua ara sa qu roitinia pa roroqu tuvisina soni vei sa qake vamalumigo ko bu roitinia sa na sela pa moequ ara. Sa vei isa sa qake vamalumigo ko bu ulia sisa. ");
INSERT INTO lga_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ego ko mu vamulea sa na maqotana na marene ura kai tinoni kokorotai sisa, beto isa mina vavaranigo poni muna toa. Goto vei munake vamulea sisa sa, mu gigila vatalea sa ao beto ira doru pa tatamana tamu sa mai mate,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ego sa dorava ko sa turu vuvugei jonga si Abimeleki ko sa kuku vakamuria sira doru ona tinoni lalavata, ko sa vavakato vaniria sa doru na sakasava aipira, poni sa qai matagutu vivikereniria. ");
INSERT INTO lga_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Beto poni sa i Abimeleki sa kuku vatomea si Ebarahami ko pira saunia, <<Na sa sa qu roitinia ao tamigei? Na sa sa na sela qa roitinia ara tamu ko qu vakolenisiu na tapata lavata sara beto na qua binangara? Ira na sakasa qu roiti lamenia ao sa qaike pada ko bu roiti lamenia taqu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Beto sa nanasia i Abimeleki si Ebarahami, pira saunia, <<Na sa qu rovea ko qu roiti vei tu pira?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Poni pira sau si Ebarahami, Dai! Pira gu qau sa, Pa gugusu api sa kepore sosoto sa na matagutuna na Tamasa ko kode mai vai talenisiu ara sa na maqotaqu qau. ");
INSERT INTO lga_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ba kai kalena sa, na luluqu sosoto tugu sa, na tuna rereko na tamaqu gu ke ba na goto tinana tu ko sa vei sa qa alavia. ");
INSERT INTO lga_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Beto totonai qi kukusiu na Tamasa ko qa taloa pa qua tatamana sa qa pojania tugu sisa ko isa tugu sa na soana vei beto sa boka vatadogoronia nona roroqu taqu qau ko doru eqa qe lao sa ara sa na luluna marene tugu sasauniria sira, sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Beto sa pogoso kamuniria i Abimeleki sa na sipi beto na bulumakau beto na marene na rereko pinausu ko sa vania si Ebarahami, beto sa vamule vania si Sera na maqotana. ");
INSERT INTO lga_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Beto pira sau si Abimeleki, <<Na ia taqu sa qu batiamua ko mu suvere pai ia qu nyoroguania,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ego I Sera sa pira saunia, <<Doria ko qa vania kai tina poata siliva ara sa na lulumu ko isa sa na laena na tapata qa roiti laonia ara tamu pa moedi ira doru qai suvere tavitigo ko kopira qu taruvata sosoto sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Beto poni sa vavara lao tai Tamasa si Ebarahami ko na Tamasa sa salania si Abimeleki, na maqotana beto ira nona rereko pinausu ko mai boka vapodo ligu koburu, ");
INSERT INTO lga_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ura i Iahova sa patei suqutu paleria sa na iapadi doru na rereko pa tatamana tai Abimeleki pa laena i Sera na maqotana i Ebarahami. ");
INSERT INTO lga_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ego i Iahova sa lame ovikia si Sera isa vei sa pojainia perangana ko i Iahova sa roitinia tai Sera sa na sa vei sa pojai. ");
INSERT INTO lga_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Ko sa bogata si Sera beto sa vapore vania kai tuna marene si Ebarahami totonai sa baragoso isa pa totoso tugu isa vei sa pojai na Tamasa perangana tana. ");
INSERT INTO lga_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","I Ebarahami sa vaisongonia i Aisake sa na tuna marene sa vapore vania i Sera. ");
INSERT INTO lga_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Pana vinavesu rane tonai sa podo si Aisake sa, i Ebarahami sa pobea sisa vei sa garununia na Tamasa. ");
INSERT INTO lga_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Kai gogoto aorona si Ebarahami totonai sa podo i Aisake na tuna. ");
INSERT INTO lga_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ko pira sau si Sera, <<Sava avusiu ara sa na Tamasa, ko ira doru na tinoni mai nongoronia sapi ba kode mai avu vei tugu ara,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Beto sa pira sau mutu, <<Karo ko I sei mina ule vania si Ebarahami sa i Sera sa vasusu koburu? Ura ara qa vapodo vania kai koburu marene totonai sa tei baragoso tu sisa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ego sa lavata sae sa na koburu ko sa loa susu, ko sa roitinia i Ebarahami sa kai vavolo lavata na ranena sa loa susu si Aisake. ");
INSERT INTO lga_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ego i Sera sa batia sa na tuna marene i Ebarahami isa qi vaporenia tai Haqa na rereko Ijipi sa, sa gigila avavu vaivatorasa. ");
INSERT INTO lga_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Ba pira saunia si Ebarahami, <<Mu iju variua sa na rereko pinausu ina beto na tuna marene, ura na tuna marene na rereko pinausu ina sa minake somana isongo tavitia i Aisake na tuqu marene ara sa na isisongo,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Na sakasava api sa vatakulanga vivitigia si Ebarahami ura na veveina gu na tuna marene sa na ginugua alepi. ");
INSERT INTO lga_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ba pira sau sa na Tamasa tai Ebarahami, <<Muke takulangania ao na koburu marene beto na mua nabulu rereko. Doruna gu vei sa pojanigo i Sera sa mu tutia gu na ovovelena isa ura ti Aisake tu mina tagigala vei sa na tutimu ao. ");
INSERT INTO lga_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ba na tuna na nabulu rereko ba mana veinia tugu kai bubutu tinoni ara ura isa ba na tutimu tugu ao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ego sa turu vuvugei jonga si Ebarahami ko sa vatanai kaki tetekuna beto kai kukurani pie ko sa vasugaraniria pa varana i Haqa beto sa loa lao vania na koburu beto sa garunu variua. Ko sa riu si Haqa ko sa lekogo mumumaona pa qega pa Biaseba. ");
INSERT INTO lga_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Totonai sa pidili na pie pa kukurana na pie poni, sa vatoqoa sa na tuna marene pa kauruna kai leo mumuqu. ");
INSERT INTO lga_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Beto sa riu toqo pa kai ia papada souna na gonana na tupi ura sau, qake nyogua batia na matena na koburu, sau. Beto sa toqo kai ia tatana ketakoi beto sa ovulia na ovovelena ko sa vagorea na lukana. ");
INSERT INTO lga_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ego sa nongoria na Tamasa sa na ovovelena na koburu marene, ko na mateana tana Tamasa sa kukua si Haqa koko pa noka ko pira saunia, <<Na sa sa na tapata, Haqa? Muke matagutu ura sa tei nongoria tu na Tamasa sa na ovovelena na koburu tonai sa kole isa ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mu teku vaturua na koburu ko mu arua na limana, ura isa sa mina kai bubutu tinoni lavata mana veinia ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Beto sa revangia na Tamasa sa na matana i Haqa ko sa batia sa kai oqili pie takorina. Ko sa lao ko sa vutugu vapugelia sa na kukurani pie beto sa vabukua sa na koburu. ");
INSERT INTO lga_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Ego sa vavaburoa na Tamasa sa na koburu totonai sa lavata sae. Ko sa suvere pa qega ko kai tinoni gogona pa bokala sisa. ");
INSERT INTO lga_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Totonai sa korapa suvere pa qega pa Parani sisa sa, na tinana sa teku vania kai rereko Ijipi ko sa alavia. ");
INSERT INTO lga_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Pa totoso isa sa i Abimeleki beto i Pikolo na kuta tadira na tinoni vaipera tana sa qai parangia si Ebarahami, pira qarigunia, <<Na Tamasa sa suvere tavitigo sao pa doru sakasava qu roitiniria. ");
INSERT INTO lga_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ko mu maulu lame taqu kopira tugu pa moena na Tamasa vei ao sa munake roiti seseke lame taqu babi ira na tuqu babi ira na tutiqu ara. Mu vatadogoronia taqu beto tadira na tinoni pa gusu ketakoi qu korapa suvere vei na tinoni karovona sa na toa vairoqu isa vei qa roiti laonia ara tamu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Poni pira sau si Ebarahami, <<Qa maulunia ara sisa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Beto poni sa sa ququmi lao tai Abimeleki si Ebarahami veveina na oqili pie takorina qai aru tekua ira na nabulu tai Abimeleki. ");
INSERT INTO lga_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ba sa paranga tu si Abimeleki, pira sau, <<Koi! Ara qake gigilai i sei sa roitinia sa na ginugua le alepi. Ao quke vavakato vanisiu ara ko ara ba qake nongoronia tinganai pa ngeni tugu api,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ko sa tekuria i Ebarahami sa na sipi beto na bulumakau beto sa vania si Abimeleki ko qai vatoqoa ira karu sa kai vinaego. ");
INSERT INTO lga_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ka vitu tuni sipi rereko pa gogodo sipi sa sa vakole kalea i Ebarahami. ");
INSERT INTO lga_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Poni pira sau si Abimeleki tai Ebarahami, <<Na savadi sira ka vitu tuni sipi rereko qu vakole kaleria inara?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Poni pira sau si Ebarahami, <<Mu teku vakarovia pa limaqu ara sira na tuni sipi rereko aipira vei na ule votu vasosotona vei ara qa koria sa na oqili pie takorina alepi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ko sa vei sa sa tavaisongonia Biaseba sa na ia isa ura ketakoi sa qai maulu sira karu. ");
INSERT INTO lga_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Pa liguna qai vatoqoa ira sa na vinaego pa Biaseba sa, qai tavaturu sira Abimeleki i Pikolo na kuta tadira na tinoni vaipera tana ko qai muledia pa ia tadira na tinoni Pilisitia. ");
INSERT INTO lga_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","I Ebarahami sa umania sa kai gou tamarisiki pa Biaseba, beto ketakoi sa kuku vatarasaea isa sa na isongona i Iahova, na Tamasa kole jolana. ");
INSERT INTO lga_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ego na totoso kakasana sa sa suvere vei na tinoni karovona pa ia tadira na tinoni Pilisitia si Ebarahami. ");
INSERT INTO lga_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Ego kai totoso pa liguna na sakasa aipira, sa na Tamasa sa podekia si Ebarahami, pira saunia, <<Ebarahami,>> sau. Poni sa oe si Ebarahami, <<Api sara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Poni sa paranga na Tamasa, pira sau, <<Mu tekua na tumu marene, isa kai memeka tumu marene qu roroqua i Aisake ko mu lao pa pikata ia pa Moraea. Mu vavakukuvunia ketakoi sisa pa kai kukubo isa mana ule vanigo ara,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ego sa turu na vuvugei jonga si Ebarahami ko sa vatanai sa nona dongiki beto sa toniria sa karu nona nabulu beto i Aisake na tuna marene. Sa ivala vatanai na iuku vavakukuvu beto sa paja ko sa riu sa pa ia sa ule vania na Tamasa. ");
INSERT INTO lga_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Na vinaue rane sa enga sae si Ebarahami sa batia sa na ia pa souna. ");
INSERT INTO lga_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Sa pojaniria sa karu nona nabulu, <<Mu suvere lani tavitiria na dongiki goto ara beto na koburu me gogojo sae paponi. Mene vatarasae beto mene mule lagere kamugou,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ego ko sa tekuria i Ebarahami sa na iuku vavakukuvu ko sa vasugarania si Aisake na tuna marene goto mekana sa pogosia sa na iku beto na lida beto qai mekarai riu sira karu. ");
INSERT INTO lga_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Poni sa paranga lao tai Ebarahami na tamana si Aisake, pira sau, Tamaqu, sau. Sa oe si Ebarahami, Ai vei qugu tuqu? saunia. Sa paranga si Aisake tai Ebarahami na tamana, pira sau, <<Tamaqu?>> sau, Sa oe si Ebarahami, <<Avei qugu tuqu?>> sau. Poni pira sau si Aisake, <<Na iku beto na iuku sa pira goto pai sa na tuni lami tana vavakukuvunia?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Poni sa oe lao si Ebarahami, <<Na Tamasa tu mina doria mekana sa na tuni lami tana vavakukuvunia tuqu,>> saunia. Beto qai mekarai riu sira karu. ");
INSERT INTO lga_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Totonai qai kamu pa ia na Tamasa sa ule vania poni, sa roitinia ketakoi sa kai ia vavakukuvuna si Ebarahami beto sa vamakele vatanaria sa na iuku. Beto ko sa piua si Aisake na tuna ko sa vakolea pa are iuku pa arena na ia vavakukuvuna. ");
INSERT INTO lga_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ego beto sa kaqamania i Ebarahami sa na limana ko sa tekua sa na lida ko mi vamatea sa na tuna sau. ");
INSERT INTO lga_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Poni sa kuku koko vei pa noka tu sa na mateana tai Tamasa pira sau, Ebarahami! Ebarahami, saunia. Sa oe sisa, Api sara, sau. ");
INSERT INTO lga_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Pira sau sa na mateana, <<Muke avangania na limamu ao sa na koburu>> ina beto <<muke roitinia kai sa tana. Ura kopira qa gigilai ara sa ao sa qu matagutunia na Tamasa beto quke aru mulenia pana taqu sa kai memeka tumu marene,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Poni sa enga sau si Ebarahami sa batia sa kai rami sa marakapisi na keuna pa vaikamu gogou ikikete. Ko sa lao si Ebarahami ko sa tekua sa na rami beto ko sa vavakukuvunia beina na tuna. ");
INSERT INTO lga_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ko sa vakukunia i Ebarahami I Iahova mina doria sa na ia isa. Ko kamu tugu pa rane pa ngeni alepi sa na paranga pira sasau, Pa kubo tai Iahova sa kode i Iahova mina doria, sau. ");
INSERT INTO lga_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Beto sa kuku ligua mule vinarua totoso na mateana tai Iahova koko pa noka si Ebarahami ");
INSERT INTO lga_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","pira sau, <<Qa maulu mulenisiu mekaqu sara sau si Iahova ura qu roitinia ao sa na sakasava alepi ko quke aru mulenia ao sa kai memeka tumu marene, ");
INSERT INTO lga_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ko Sosoto jola mana mana vatatalenigo ara sao beto mana vavovonua ara sa tutimu ao ko mai mota vei na seru pa nulu beto mai vei na nagasa pa poanana. Ira na tutimu ao sa mai teku isongia sira na gugugusu lalavata tadira na dia kana, ");
INSERT INTO lga_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","beto pa tutimu ao sa mai tamana sa doru pupuku tinoni pa abana, ura qu vatabesiu ara sao,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Beto poni sa gabala mule kamuria nona nabulu si Ebarahami ko qai mekarai rerege mule pa Biaseba ko sa suvere ketakoi sisa. ");
INSERT INTO lga_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Pa liguna na sakasa aipira sa qai vavakato vania si Ebarahami pira qarigu, <<I Milika sa vapodo vania boko koburu marene si Naho na tasimu; ");
INSERT INTO lga_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","I Uzu pa moa, beto i Buzu na tasina, i Kemuele (na tamana i Aramu), ");
INSERT INTO lga_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","i Kesedi, i Hazo, i Pilidasi, i Jidilapi beto i Betueli,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","I Betueli qi vaporea si Ribeka. I Milika sa vapodo vania i Naho na tasina marene i Ebarahami sira ka vesu koburu marene aipira. ");
INSERT INTO lga_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kai goto maqotana nisongona i Reuma ba qi pore tuna marene tugu; i Teba, i Qahami, i Tahasi beto i Maka. ");
INSERT INTO lga_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Ego na kakasana na toa tai Sera sa sa kamua kai gogoto rabete vitu aorona. ");
INSERT INTO lga_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Beto sa mate sisa pa Kiriati Aba (isa pa Heboroni) pa ia pa Kenani, ko i Ebarahami sa takulanga ko sa lao lukania si Sera. ");
INSERT INTO lga_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Beto poni sa sa turu loai na kokobu tinina na maqotana si Ebarahami ko sa parangaria sira na tinoni Hitai, Pira sau, ");
INSERT INTO lga_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","<<Na tinoni karovoqu ko na tinoni kamu suverequ gu tamugou sara. Ko bu vanisiu tu kai ia vavaigolomona tamugou ko ma golomo vapaea na maqotaqu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Poini qai oea ira tinoni Hitai si Ebarahami, pira qarigu, ");
INSERT INTO lga_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","<<Iviva, Mu nongorogei agei. Na tuni bangara tuti Tamasa qu suvere pa vaikorapaimei agei sao. Mu vilea kai bevi vavaguana jola qu batia pa doru bevi tamigei inara ko ketakoi mu vapaea sa na maqotamu. Kepore kame agei mina rutinigo ketakoi muna vakolenia na maqotamu ao,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Poni sa turu si Ebarahami beto sa titi opo gore pa moedi ira na tinoni poredia ia, na bubutu tinoni Hitai. ");
INSERT INTO lga_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Beto pira sauniria, <<Vei muna vajonganai agou ko mana vapaea na maqotaqu sa, mu nongorosiu ko mu paranga vanisiu si Eporoni na tuna marene i Zoha ");
INSERT INTO lga_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ko bi vavai lamenia taqu sa na bevi tana pa Makapela pa uquna nona ia. Mu nanasia ko na vai okotona na bevi sa bi vavai lamenia taqu ko isa sa bi juki ia vavaigolomona taqu pa ia tamugou,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ego i Eporoni na tinoni Hitai sa korapa tugu toqona pa vaikorapaidi ira na tinoni Hitai ko sa oea gu i Eporoni si Ebarahami pa talingidi ira doru tinoni Hitai qai kamu pa vavaikamuna pa totomena na gusu lavata isa, pira sau, ");
INSERT INTO lga_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","<<Dai, iviva, Mu nongorosiu; Qa vanigo ao sa na kobu ia ko na bevi sa kole pa leona na ia isa sa qa vanigo tugu. Pa matadi ira na qua tinoni qa vanigo ao sisa. Mu vapaea gu na maqotamu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Poni sa kai titi opo gore mutu si Ebarahami pa moedi ira na tinoni poredia ia ");
INSERT INTO lga_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","beto sa pojania si Eporoni pa talingidi ira na tinoni poredia ia, pira sau, Mavo tu! <<Bu nongorosiu tu ara ao. Ara ma vainia na poata sa na kobu ia Ko ao mu teku vakarovia taqu sa na poata vaina na ia ko ma vapaea na magotaqu ketakoi,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Sa oea i Eporoni si Ebarahami, pira saunia ");
INSERT INTO lga_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","<<Iviva, mu nongorosiu. Na kobu peso sa ka made gogoto siliva na padana, ba pana tadagita karu sa kepore laona sina. Mu golomia gu na maqotamu ao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Poni sa vaegoa i Ebarahami si Eporoni ko sa pada vania i Eporoni sa na poata isa vei sa pojai pa talingidi ira tinoni Hitai: ka made gogoto siliva, tutia tugu na pada poata qai varoitia tonai. ");
INSERT INTO lga_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ko na kobu ia ti Eporoni pa Makapela tata pa Mamiri- na kobu ia beto na bevi sa kole pa leona beto doru gogou pa leo volosona vailivutaina na kobu ia isa- doru isisongo aipira sa qai tavatoqo mauru vania, ");
INSERT INTO lga_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","i Ebarahami pa matadi ira doru tinoni Hitai qai lame pa vavaikamuna pa totomena na gusu lavata. ");
INSERT INTO lga_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Beto pa liguna api sa vapaea i Ebarahami si Sera na maqotana pa bevi pa leona na kobu ia pa Makapela tata pa Mamiri (isa pa Heboroni) pa peso pa Kenani. ");
INSERT INTO lga_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ko na kobu ia beto na bevi sa kole pa leona isa sa qai tavatoqo mauru vania i Ebarahami ko jukini ia vavaigolomona isa pa ia tadira na tinoni Hitai. ");
INSERT INTO lga_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ego i Ebarahami sa kopira sa sa baragoso beto na totoso kakasana sa suvere sisa, beto i Iahova sa manania pa doru na toa. ");
INSERT INTO lga_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ego ko pira saunia i Ebarahami sa na ona nabulu, isa sa kuta uananiria doru na vei isa tana, <<Mu vakolea na limamu pa kauru avaqu, ko ");
INSERT INTO lga_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ma vamauligo ara sao pa isongona i Iahova, na Tamasa pa noka beto na Tamasa pa peso, ko munake teku vania na tudia rereko ira na tinoni Kenani ketakoi qa korapa suvere ara sa na tuqu marene ");
INSERT INTO lga_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","goto pa gugusu tu taqu beto tadira na tavitiqu tu sa muna lao beto muna teku vania kai maqota si Aisake na tuqu marene ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Poni pira tu sau sa na nabulu, Kita mi daiona tuti lamesiu ara pa ia lani na rereko. Ai vei ba tonia tu mule lao pa gugusu ketakoi qu koko lame vei ao sa na tumu marene? saunia. ");
INSERT INTO lga_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","<<Poni pira sau si Ebarahami, Mu vainongoro vatale ao ko Muke toni mulenia ketakoi na tuqu marene>> ara. ");
INSERT INTO lga_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","<<I Iahova, na Tamasa pa noka, isa sa toni votunisiu pana tatamana tana tamaqu beto pa ia ketakoi qa podo lame vei, isa sa parangasiu beto isa sa maulu lame taqu totonai pira sau, <Tadira na tutimu ao mana vaniria sa na ia alepi> sau. Isa mina garunu lao momoenia sa nona mateana ko muna boka teku vania kai maqota ketakoi sa na tuqu marene ara. ");
INSERT INTO lga_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Vei mina daiona tutigo mule sa na rereko sa, ao sa muna talegasania gu sa na maulu taqu goto na tuqu marene gu sa kita mu toni mulenia ketakoi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ego Ko na nabulu sa vakolea sa na limana pa kauru avana i Ebarahami nona iviva beto ko sa maulunia isa tana sa na sakasa api. ");
INSERT INTO lga_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Beto poni sa tekuria na nabulu sa ka manoga puta kameli tana ona iviva beto doru sakasa jojongadi tana ona iviva sa kole pa kopu tana beto sa qaqiri ko sa taloa riu lao vei pa Arami Naharaimi beto sa lao vei pa gugusu tai Naho. ");
INSERT INTO lga_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ego ko sa vatoqo minereria sa na kameli tata pa oqili pie takorina pa peguruna na gugusu ko na vevelu sa totonai, na totoso vovotu lame vutugu pie tadira na rereko. ");
INSERT INTO lga_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Beto pira sau sa na nabulu, <<Kei Iahova, na Tamasa tana qua iviva i Ebarahami, mu vabokasiu pa ngeni alepi, beto mu roiti votunia ao sa na mua vairoqu maladoruruna tana qua iviva i Ebarahami. ");
INSERT INTO lga_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Dotu, ara qa korapa turuqua pa tatana na matana na vuvugu pie api beto ira na tudia rereko ira pa gugusu sa qai korapa lalame vutugu pie. ");
INSERT INTO lga_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ego ko mina isa na rereko mana parangia ara, pira managunia, Bu vagorea mai tu na mua bogu pie ko ba buku mai, managu sara ko mina paranga sisa, Ina buku tu beto ira na kameli tamu inara ba ma vaniria tugu vei na pie ara minagu sisa sa, isa tugu sa na maqota qu vile vania ao na mua nabulu i Aisake. Pa soana vei api sa mana gigilai ara sa ao qu roiti votunia sa na mua vairoqu maladoruruna tana iviva taqu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ego ko sa oqoro tu vaokotia na paranga isa, poni sa api sa, sa bola votu lame tu si Ribeka isa na tuna rereko i Betueli ko i Betueli isa na tuna marene i Milika ko i Milika isa na maqotana i Naho ko i Naho isa na tasina marene i Ebarahami. Ko sa sugaria gu lame pa varana i Ribeka sa na bogu pie. ");
INSERT INTO lga_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ko kai maqota babata jonga jola sisa beto na poqo oqoro pore kai marene bi kole tavitia. Ko sa gore pa matana na vuvugu pie ko sa gore vutugu vapugelia nona bogu pie beto sa sagere mule sale. ");
INSERT INTO lga_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Poni sa abutu lao sa na nabulu ko sa gosoria sisa ko pira sau, <<Ai vei bu vanisiu mai iqopeki pie pa bogu pie tamu inana?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Poni pira saunia, <<Mu buku iviva,>> sau, beto sa sisiqarai vagorea pa limana sa na bogu pie ko sa vania na pie ko sa buku. ");
INSERT INTO lga_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Pa liguna sa vania na pie ko sa buku sa na nabulu sa sa paranga mutu sa na maqota, pira sau, Na kameli mule tamu sa ma vaniria na pie ko mai buku vatatalegadia, saunia. ");
INSERT INTO lga_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Beto sa siqarai vuva vakarovonia pa besini sa na pie pa bogu beto ko sa abutu mule gore pa oqili ko sa vagorea na titinuna ko sa vutugu vaniria na pie sira doru na kameli tana. ");
INSERT INTO lga_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ego ko na tinoni sa sake vagala beto sake kipuni mata sa na rereko ko mi gigilai vei i Iahova sa vabokai sa na rererege tana ba dai sau. ");
INSERT INTO lga_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Totonai qai beto buku sira na kameli sa, sa teku vavotua na nabulu sa kai ringi qolo vavatogasana pa isu na mamatana padana kai beka beto karu bokolo qolo na mamatadi padana manogaputa sekolo. ");
INSERT INTO lga_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Beto ko sa nanasia, <<Na tuna rereko i sei sao? Mu pojanisiu, ai vei koleona kaki ia pa ruma tana tamamu ko agei be vajola bongi mai ketakoi?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Poni sa oe lao sisa, <<Ara sa na tuna rereko i Betueli, na tuna marene i Milika isa sa vapodonia tai Naho,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Beto pira sau, <<Na tetekuna tadira na kameli sa soku tamigei, beto vei tugu na iaketakoi muna boka vajola bongi agou,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Poni sa titi opo gore sa na nabulu beto sa vatarasaea si Iahova, ");
INSERT INTO lga_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","beto pira sau, <<Mi tavatarasae si Iahova, na Tamasa tana qua iviva i Ebarahami, isa sake roqu mumania nona vairoqu maladoruruna beto nona rarange lao tana qua iviva. Ko ara sa toni vakamusiu i Iahova pa gusu tadira na tavitina na qua iviva,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ko sa abutu mule sa na rereko ko sa lao vavakato vaniria sira pa ruma tana tinana sira doru na sakasa aipira. ");
INSERT INTO lga_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ego i Ribeka sa koleona sa kai luluna marene nisongona si Labani, ko i Labani sa abutu votu lao sa tana nabulu pa vuvugu pie. ");
INSERT INTO lga_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Isa tugu sa batia na ringi beto ira na bokolo pa limana na luluna, beto sa nongoria sa na paranga tai Ribeka na luluna tonai sa pojai vei pira sau na nabulu sa, sa lao kamua sa na nabulu korapa turuona pa keketaina na kameli tata pa vuvugu pie. ");
INSERT INTO lga_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ko pira sau, <<Mei lame, ao sa mananigo i Iahova.>> <<Ai sa vei ko qu korapa turu goboro pa peguru lani? Qa tei vatanai tu sa na ruma beto na ia mai minere na kameli,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ko sa lao pa ruma sa na nabulu beto sa ruvataria sa na kameli. Beto sa vaniria na tetekuna sira na kameli, beto sa vaniria na pie sa na nabulu beto ira na tinoni ko mai loqaria na nenedi sau. ");
INSERT INTO lga_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Beto poni sa qai vatana vania sa na tetekuna ko mi teteku qarigu, ba pira tu sau sisa! Dai! <<Ara maneke teteku ko tinganai mana pojanigou mai tu na qua paranga,>> sauniria. Sa pira sau si Labani, <<Ego mu pojanigei tu ropi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Poni pira sau sisa, Na nabulu tai Ebarahami sara. ");
INSERT INTO lga_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","I Iahova sa mana vatatalenia sa na iviva taqu ko kai tinoni poreveveina sisa. Beto ko sa vania tugu vei na sipi beto na bulumakau, na siliva beto na qolo, ira na nabulu marene beto na rereko, beto na kameli beto na dongiki. ");
INSERT INTO lga_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","I Sera isa na maqotana na iviva taqu sa sa vapore vania kai tuna marene pa totoso sa tei qoele tu, ko doru sakasava sa isongoria isa sa sa tei vakarovo vania tu na tuna marene. ");
INSERT INTO lga_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ko sa vamaulusiu na qua iviva sara, pira saunisiu, Na tuqu marene ara sa munake teku vania na maqota tadira na tinoni Kenani tadira qa korapa suveria ara na dia ia, ");
INSERT INTO lga_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","goto muna lao tu pana tatamana tana tamaqu beto tadira na qua bubutu ko ketakoi muna teku vania kai maqota sa na tuqu marene, sau. ");
INSERT INTO lga_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Poni qa nanasia tu sa na qua iviva lavata, pira qau, Aivei Kita vei ko mi daiona tuti mulesiu ara sa na rereko? qaunia. ");
INSERT INTO lga_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Sa oesiu sisa, I Iahova, isa qa vatabea ara, sa mina garunu tutinigo nona mateana ko isa mina vabokai na mua rererege, ko muna teku vania kai maqota tadira na qua bubutu beto pana tatamana tana tamaqu sa na tuqu marene ara. ");
INSERT INTO lga_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Muna talegasania ao sa na maulu taqu vei muna lao tadira na bubutu taqu ko nake savana mai daidia vanigo sa na rereko ba ao sa muna talegasania sa na maulu taqu, sau. ");
INSERT INTO lga_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Totonai qa kamu pa vuvugu pie pa ngeni sa, pira qau sara, Kei Iahova, Ao na Tamasa tana qua iviva i Ebarahami, bu vajonganai tu ao sa, bi boka tu sa na rererege taqu isa qa kamunia ara lani. ");
INSERT INTO lga_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Dotu, Ara qa korapa turu pa tatana na matana na vuvugu pie api ko vei kai maqota mina votu lame tinu pie ko ara pira managunia, bu vanisiu iqopeki pie pa bogu tamu, bau, ");
INSERT INTO lga_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ko pira biu sisa, <<Mu buku tu ao beto ira na mua kameli ba mana tinu vaniria tugu vei na pie>> biu sisa sa, isa tugu sa na maqota sa vilea i Iahova ko mina tekua na tuna marene na iviva taqu qau. ");
INSERT INTO lga_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ko qa oqoro tugu beto paranga pa buloqu sara, sa bola votu gu lame si Ribeka ko sa sugaria isa pa varana sa nona bogu pie ko sa gore pa vuvugu pie ko sa tinu pie, poni pira qaunia, Bu vanisiu na pie ko ba buku, qau. ");
INSERT INTO lga_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Poni sa siqarai vagorea sa na bogu pie pa varana beto pira sau, Mu buku, beto ma vabukuria tugu vei na kameli tamu, sau. Ko qa buku sara beto isa sa vabukuria sa na kameli. ");
INSERT INTO lga_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","<<Beto qa nanasia, pira qau, Na tuna rereko i sei sao? qaunia. Poni sa pira sau, Na tuna rereko i Betueli isa na tuna marene i Naho sara isa sa vapodonia pa ti Milika, sau. Poni qa vatitia ara sa na ringi pa isuna beto ira na bokolo qa vasolaparia pa limana, ");
INSERT INTO lga_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","beto qa titi opo gore ko qa vatarasaea si Iahova beto qa paranga jongana lao tai Iahova, na Tamasa tana qua iviva i Ebarahami, isa sa tonisiu pana soana tuvisina ko ma tekua vania na tuna marene na iviva taqu sa na mabusu rereko tana tasina marene na iviva taqu sau. ");
INSERT INTO lga_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ego ko kopira vei muna boka roiti votunia agou sa na vairoqu maladoruruna beto vei muna rangea agou sa na iviva lavata taqu sa mu ule vanisiu agou, goto vei dai munagu sa ba mu ule vanisiu tugu agou ko ma boka gigilai sa mana gabala lao pa kale matua sa ba pa kale meri,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Poni qai oe lao sira Labani i Betueli, pira qarigu, Koi! Na sakasava le alepi sa na koko lame veina ti Iahova ko agei meneke boka pojanigo kai sa, jongana ba dai menekeu. ");
INSERT INTO lga_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Goto ina si Ribeka, <<mu tonia beto mu riu, ko mi isa sa na maqotana na tuna marene tana iviva tamu vei sa pojai i Iahova,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Totonai sa nongoria na nabulu ti Ebarahami sa na sa qai pojai ira karu, poni sa sa titi opo gore pa peso pa moena i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Beto sa teku vavoturia sa na qolo, na siliva kikilangadi beto na boko poko ko sa vania si Ribeka, beto sa vaniria tugu vei na vaivana pore laodi sa na luluna marene beto na tinana. ");
INSERT INTO lga_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Beto sa isa beto ira na tinoni qai tutia isa sa qai teteku, buku beto ko qai vajola bongi tugu ketakoi. Totonai qai dorava na vuvugei sa pira sau sa na nabulu, <<Koi kopira mu vaqaqirisiu ko ma mule tana qua iviva,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","<<Ba na luluna marene beto na tinana sa pira qarigunia tu, Na rereko sa mi suvere tavitigei mai manogaputa rane babi kaki vevei inara beto sa mi riu,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ba pira sauniria tu sisa, <<Muke aru tamanasiu ura i Iahova sa vabokai sa na rererege taqu ko agou mu vaqaqirisiu ko ma mule riu tana qua iviva,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Poni pira qarigu sira, <<Ego me kukua tu ropi na rereko ko me nanasia,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ko qai kukua si Ribeka ko qai nanasia, <<Ai vei muna tutia riu na tinoni api?>> qarigu. Sa pira sau sisa, <<E mana riu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ko qai vaqaqiri riuria si Ribeka na tasidi rereko beto nona rereko vaikopu beto na nabulu ti Ebarahami beto ira nona tinoni. ");
INSERT INTO lga_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ego ko qai manania si Ribeka, pira qarigunia. <<Ao na tasimei rereko, Mi tina na tina sa na vuamu ao, Ira na tutimu mai tomea Na toba tadira na dia kana,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Beto poni sa i Ribeka beto ira nona nabulu rereko sa qai qaqiri ko qai koi pa dia kameli ko qai tutia sa na tinoni. Ko na nabulu sa tonia si Ribeka ko sa taloa riu. ");
INSERT INTO lga_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ego i Aisake sa sa koko pa Bia Lahai Roi ura sa korapa suvere sisa pa ia pa Negev. ");
INSERT INTO lga_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kai totoso sa peluku vevelu na rane poni sa i Aisake sa votu riu pa kai ia ko mi riu roroveona sau, sa enga sae, sa batiria sa na kameli korapa lalamegadia. ");
INSERT INTO lga_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","I Ribeka ba sa enga sae tugu sa sa batia si Aisake. Ko sa gasa gore pa nona kameli ");
INSERT INTO lga_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","beto pira saunia na nabulu, <<I sei sa na tinoni poni sa korapa lelekogo pa ia poni sa korapa mi lame gosorogita gita sau?>> saunia. Poni sa pira sau sa na nabulu, <<Koi, na iviva lavata taqu>> sisa, saunia. Ko sa tekua sa nona poko udude ko sa udea na isumatana si Ribeka. ");
INSERT INTO lga_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Beto sa sa kilipuputu lao vania na nabulu ti Aisake sa doru na sakasa sa roitiniria. ");
INSERT INTO lga_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ko i Aisake sa teku vatomea pa aqaqo ti Sera na tinana si Ribeka ko isa na maqotana isa. Ko sa roroqua i Aisake sa na maqotana ko isa sa vamanotia si Aisake pa liguna sa mate na tinana. ");
INSERT INTO lga_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ego sa teku sogai i Ebarahami sa kai maqotana nisongona i Ketura. ");
INSERT INTO lga_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ko i Ebarahami sa vaporenia tai Ketura sira Zimirani, I Jokosani, I Medani, I Midiani, I Isibaki beto I Sua. ");
INSERT INTO lga_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","I Jokosani sa vaporeria sira Seba i Dedani ko na tutina i Dedani sira na tinoni Asurai, na Letusae, beto na Leumai. ");
INSERT INTO lga_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ira na tuna marene i Midiani sira Epaha, I Epe, I Hanoki, I Abida beto i Eleda. Ira doru aipira sa na tutina i Ketura. ");
INSERT INTO lga_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ego i Ebarahami sa sa loa beto vania i Aisake sa doru sakasava sa isongoria. ");
INSERT INTO lga_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Goto ira na tuna marene sa vaporeniria tadira na goto maqotana sa i Ebarahami sa vaniria na vaivana beto ko totonai tu sa korapa toaona sa sa garunu vasou riuria keta pa kale sagere tapo ko mai sou tai Aisake sau. ");
INSERT INTO lga_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ego i Ebarahami sa sa suvere kamua kai gogoto vitungavululima aorona. ");
INSERT INTO lga_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Beto sa, sa vasaenga bebeto ko sa mate si Ebarahami totonai sa baragoso vapaparoi vatale sisa ko sa tagolomo tavitiria ira nona tinoni sisa. ");
INSERT INTO lga_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ira Aisake i Isimeli karu tuna marene sa qai golomonia pa leo bevi pa Makapela tata pa Mamiri pa kobu ia ti Eporoni na tuna marene i Zoa na tinoni Hitai. ");
INSERT INTO lga_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Na kobu ia isa si Ebarahami qi pajukia tadira na tinoni Hitai ko ketakoi sa golomonia i Sera na maqotana. ");
INSERT INTO lga_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Pa liguna sa mate i Ebarahami sa, na Tamasa sa manania si Aisake na tuna marene isa ko pa totoso isa sa sa suvere tata pa Bia Lahai Roi. ");
INSERT INTO lga_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Alepi sa na vavakatona na tuna marene i Ebarahami i Isimeli isa i Haqa na rereko Ijipi isa na nabulu rereko tai Sera sa vapore vania i Ebarahami. ");
INSERT INTO lga_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Aipira sa na isongodi ira na tuna marene i Isimeli qai takuti vagore tutia tugu na vaitutidi na dia podo. I Nebaioti na tuna pa moa i Isimeli beto si keda, i Adibili, i Mibisami, ");
INSERT INTO lga_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","i Misima, i Duma, i Masa, ");
INSERT INTO lga_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","i Hadadi, i Tema, i Jetu, i Napisi beto i Kedema. ");
INSERT INTO lga_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ko aipira sa na tuna marene i Isimeli qai kopuniria ka manogarua bubutu pa okokoto dia gugusu beto na dia susuverena. ");
INSERT INTO lga_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","I Isimeli sa suvere kamua kai gogoto uengavuluvitu aorona beto sa vasaenga bebeto ko sa mate ko sa tagolomo tavitiria ira nona tinoni sisa. ");
INSERT INTO lga_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ira na tutina isa sa qai suvere pa ia koko pa Havila ko mi lao kamu pa Sua tata pa voloso pa Ijipi vei muna lao vei pa Asu. Ko qai kole suvere kanaria sira doru na tavitidi. ");
INSERT INTO lga_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Alepi sa na vavakatona i Aisake na tuna marene i Ebarahami. I Ebarahami sa vaporea si Aisake, ");
INSERT INTO lga_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","beto i Aisake sa ka made ngavuluputa aorona sa totonai sa tekua ko sa maqotana si Ribeka na tuna rereko i Betueli na tinoni Arami pa Padani Arami isa na luluna i Labani na tinoni Arami tugu. ");
INSERT INTO lga_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ego i Aisake sa vavara lao tai Iahova tokania sa na maqotana ura na egoro sisa. Poni sa oea i Iahova sisa ko sa pore iapana si Ribeka na maqotana. ");
INSERT INTO lga_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Qai vaijupe laolame pa iapana isa sa na koburu ko pira sau, <<Ai sa vei ko pira tu sa vei sa na iapaqu ara?>> sau. Ko sa lao nanasia si Iahova. ");
INSERT INTO lga_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Poni pira saunia i Iahova sisa, <<Karu puku tinoni sa pa leo iapamu ao ina, Beto karu puku tinoni ira sa mai tapikata; Kai puku tinoni sa mina neqi jolania kame, Beto isa pa moa sa mina nabulunia isa pa ligu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ko totonai sa kamua na totoso okotona ko mina vaivapodo sisa sa, na pata marene sa sa vapodoria. ");
INSERT INTO lga_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Na koburu sa podo votu lame momoe sa, sa jijimiri betona na tini doruna sa vei na poko vuvulu ko qai vaisongonia i Isoa. ");
INSERT INTO lga_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Liligu sa podo votu lame sa na tasina marene, na limana sa korapa aru tamania sa na kikijulu nenena i Isoa, ko qai vaisongonia i Jekopi. I Aisake sa ka vonomo ngavuluputa aorona sa totonai sa vapodoria ira karu i Ribeka. ");
INSERT INTO lga_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Totonai qai lavata sae sa karu koburu marene sa, i Isoa sa kai tinoni bobokana pa ropa, na tinoni lelekogo pa mumuqu, goto i Jekopi sa na tinoni nonosona, susuverona gu pa aqaqo. ");
INSERT INTO lga_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","I Aisake sa roroqua si Isoa ura sa teteku jongai na masadi na mamanugu goto i Ribeka sa roroqua si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Kai totoso totonai sa korapa vatunua i Jekopi sa kaki masa vaisomanai eqequru pa aqaqo, sa mule kamu si Isoa koko pa mumuqu sa vaia na agoso. ");
INSERT INTO lga_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ko pira saunia si Jekopi, <<Kei tasiqu! Mei ko ma ponyoloria gaqu kaki gagani jijimiri inara ura sa vaisiu na agoso.>> (Ko sa vei sa qai vaisongonia I Edomu sisa.) ");
INSERT INTO lga_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Poni pira sau si Jekopi, <<Ego mu vavai lamenia mai taqu pa ngeni api sa na mua neqi podo moa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Sa paranga si Isoa, pira sau, Doro!, Ara korapa ala lao vei gu pa mate. <<Ko na sa laona taqu sa na neqi tana podo moa api,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Poni pira sau si Jekopi, <<Ego mu maulu lame taqu pa ngeni api,>> saunia. Poni sa maulu tana sisa ko sa vavainia tai Jekopi sa nona neqi podo moa. ");
INSERT INTO lga_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ego beto sa i Jekopi sa vania sa kaki bereti beto kaki masa vaisomanai eqequru sa vatunua si Isoa, ko i Isoa sa tetekugana, sa bukugana beto sa tavaturu ko sa taloa riuona. Ko sa kilu palenia i Isoa sa na ona neqi podo moa. ");
INSERT INTO lga_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ego sa raja sa kai songe pa ia qai suveria ko i Aisake sa lao pa Qera tai Abimeleki na bangara tadira na tinoni Pilisitia. (Na songe api sa sa goto pana songe sa raja perangana pa totoso tai Ebarahami). ");
INSERT INTO lga_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ego sa votu tai Aisake si Iahova ko pira sau, <<Munake gore pa Ijipi sao goto muna suvere gu pa ia ketakoi mana ule vanigo ara. ");
INSERT INTO lga_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ko mu suvere vei mai kai tinoni karovona pa ia api ko ara mana vavaburogo beto mana mananigo. Ura tamu beto tadira na tutimu ao mana vanigou sa doruna na ia aipira beto sa mana vatoqo mauria sa na maulu qa maulunia ara tana tamamu i Ebarahami. ");
INSERT INTO lga_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mana vasoku jola veinia na seru ara pa oka sira na tutimu ao beto mana vaniria na tutimu ao sa doruna na ia aipira, beto ko mai tamanadia tadira na tutimu ao sira doru gogoto tinoni pa abana, ");
INSERT INTO lga_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ura i Ebarahami sa nongoria sa na ovovelequ ara ko sa kopunia na qua paranga, na garunu, na qua vinaturu beto na qua vavanau,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Ko sa suvere pa Qera si Aisake. ");
INSERT INTO lga_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Totonai qai nanasania ira na tinoni pa gusu isa sa veveina na maqotana sa, pira sau, <<Koi! Na luluqu sina,>> sauniria ura sa matagutu pojai isa sa na maqotaqu sapi minagu. Sa rorove, <<kita ko ira na tinoni pa gusu api sa mai vaitalenisiu ara si Ribeka ura na rereko babata jonga sisa,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Totonai qai tei suvere sovai tu ketakoi sa, sa tiro gore pa vuida sau si Abimeleki na bangara pa Pilisitia, poni sa batia sa, api sa, i Aisake sa korapa boru koti vaavavua si Ribeka na maqotana. ");
INSERT INTO lga_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Poni sa kuku tekua i Abimeleki si Aisake ko pira saunia, Qokolo! Na maqotamu sosoto gu ao sina. Ai sa vei sa qu paranga, <<Na lulumu qugunia ao?>> sau. Poni pira sau si Aisake, <<Ura kita ko ma mate talenia qau ke,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Poni pira sau si Abimeleki, <<Na sa qu roitinia tamigei sao? Iapeki tu bi kole tavitia kame ira na tinoni sa na maqotamu ao ina ko bu vagosoronigei na tapata sagei,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ko sa paranga vabalauria i Abimeleki sira doru tinoni, pira sau, <<Na tinoni mina kotia na tinoni api babi na maqotana sa mina isongo mate sosoto tugu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","I Aisake sa umuma sa pa ia isa beto ko pa aoro tugu isa sa sa paduku boboko gogoto sa na vuadi nona umuma ura i Iahova sa manania sisa. ");
INSERT INTO lga_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ko kai tinoni isisongo sisa, ko nona isisongo sa sa kovuru tu lalaona ko tinganai sa isisongo jola vivitigi sisa. ");
INSERT INTO lga_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Sa isongoria soku gogodo sipi, na godo bulumakau beto na soku tinoni roiti ko ira na tinoni Pilisitia tu ba qai konoa. ");
INSERT INTO lga_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ko doru oqili pie takorina qai koriria ira na tinoni roiti tana tamana pa totoso tai Ebarahami na tamana, sa qai suquturia ira tinoni Pilisitia beto qai vapugeleniria na peso. ");
INSERT INTO lga_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Beto sa pira saunia i Abimeleki si Aisake, <<Mu rijo votu riu tamigei sao ura kopira qu neqi jolanigei agei,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ko sa taloa ketakoi si Aisake ko sa vaturu ona aqaqo pa lolomo pa Qera ko sa suvere ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Beto sa mule si Aisake ko sa kori sogaria sira na oqili pie takoridi pa totoso tai Ebarahami na tamana, ira qai vapugeleniria na peso ira tinoni Pilisitia pa liguna sa mate i Ebarahami, beto ko sa vani sogaria na isongo qi vaisongoniria na tamana. ");
INSERT INTO lga_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ego ira na nabulu tai Aisake sa qai kori pa lolomo ko qai batia ketakoi sa kai vuvugu pie toana. ");
INSERT INTO lga_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ba ira na tinoni kopu bulumakau tadira pa Qera qai guaria sira na tinoni kopu bulumakau tai Aisake, pira qarigu, <<Na mei agei sa na pie,>> qariguniria. Ko sa vaisongonia i Aisake Eseki sa na oqili pie isa ura qai toke talenia isa. ");
INSERT INTO lga_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Poni qai koria mutu sa kai oqili pie ba qai gua taleniria mutu ko sa vaisongonia Sitina isa sisa. ");
INSERT INTO lga_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ko sa taloa ketakoi ko sa rijo lao mutugu kai ia beto ko sa koria mutugu sa kai oqili pie ba kopira sa kepotu sa kai tinoni vei bi gua taleniria Ko sa vaisongonia Rehoboti sisa, pira sau, <<Kopira sa i Iahova sa vanigita kai ia kaberena ko tana vua vatale sa gita pa ia lani,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Beto koko ketakoi sa sae pa Biaseba sisa. ");
INSERT INTO lga_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ego na bongina isa sa votu tana si Iahova beto sa pira sau, Ara sa na Tamasa tai Ebarahami na tamamu. Ko muke matagutu, ura kode mana vavaburogo. Mana mananigo beto mana vasokua ara sira na tutimu ao pa laena i Ebarahami na qua nabulu, saunia. ");
INSERT INTO lga_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ego sa roitinia i Aisake ketakoi sa kai ia vavakukuvuna beto ko sa kuku vatarasaea isa sa na isongona i Iahova. Beto ketakoi tugu sa vaturua isa sa nona aqaqo beto qai koria tugu ketakoi ira na nabulu tai Aisake kai oqili pie. ");
INSERT INTO lga_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Totonai sa I Abimeleki sa qi lame tana koko pa Qera, tavitia i Ahuzati nona tinoni totoli beto i Pikolo na kuta tadira na tinoni vaipera tana. ");
INSERT INTO lga_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Poni sa pira sauniria i Aisake, <<Ai sa vei ko qu lame tu taqu, ura qu kanasiu ara sagou beto qu iju variusiu?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Poni pira qarigu sira, <<Qe bati vakakaberiamei agei sa i Iahova sa suvere tavitigo sao ko pira qeu, Agei me vatoqoa tu kai vaivaego tamauluna pa vaikorapaida gita- agei beto ao. Ko me roitinia kai vaivaego lao tamu ");
INSERT INTO lga_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ko ao munake komitigei agei vaitoto vei tugu agei qeke komitigo ao beto vaitoto vei tugu agei qe roitinia na jongana gu lao tamu ko qe garunu variugo pa bule. Beto ko kopira i Iahova sa mananigo sao,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Beto poni sa roiti vaniria na vavolo i Aisake sira ko qai teteku beto qai buku. ");
INSERT INTO lga_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Qai turu na vuvugei jonga ko qai mekarai maulu tarinia sa na vaivaego qai roitinia beto ko i Aisake sa loa variuria sira ko ira qai taloa riu pana bule. ");
INSERT INTO lga_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Pa rane isa sa ira na nabulu tai Aisake sa qai kamu ko qai vavakato vania sa veveina na oqili pie qai koria. Pira qarigu, <<Qe batia sana pie,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Ko sa vaisongonia i Aisake Siba sa na oqili pie isa, beto kamua tu pa rane pa ngeni alepi sa na isongona na gugusu ikete sa pa Biaseba tugu. ");
INSERT INTO lga_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Totonai sa kamua ka made ngavuluputa aorona si Isoa sa tekua sa na maqotana i Jiuditi na tuna rereko i Beri na tinoni Hitai beto sa tekua tugu vei si Basemati na tuna rereko i Eloni na tinoni Hitai. ");
INSERT INTO lga_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ira karu rereko pira sa na kuta takulanga tadira Aisake i Ribeka. ");
INSERT INTO lga_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Totonai sa baragoso ko qai rodomo sa na matana ko sake babata si Aisake sa, sa kukua si Isoa na tuna marene pa moa ko pira saunia, <<Tuqu,>> sau. Poni pira sau si Isoa, <<Api sara,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Poni pira sau si Aisake, <<Ara kopira sa qa baragoso beto qake gigilai na totoso mana mate. ");
INSERT INTO lga_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Ko mu tekua na mua bokala, na tupi beto mu riu ropa vanisiu kaki mamanugu pa mumuqu. ");
INSERT INTO lga_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ko mu vatunu vanisiu na tetekuna sa teku jongasiu ara beto mu pogoso kamu vanisiu ko ma tekua ko ma mananigo tonai qa oqoro mate,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ego i Ribeka sa korapa gu nonongorona sa totonai i Aisake sa kole parangia i Isoa na tuna. Ko pa liguna sa riu ropa pa mumuqu si Isoa beto mina pogoso mule kamunia sau, poni sa ");
INSERT INTO lga_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","sa parangia i Ribeka si Jekopi na tuna, pira saunia, <<Ei! Qa mavo nongoro poai sa na tamamu pira saunia si Isoa, ");
INSERT INTO lga_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Mu riu pogoso vakamu vanisiu kaki mamanugu beto mu vatunu vanisiu na tetekuna sa teku jongasiu ko ma tekua ko ma mananigo pa moena i Iahova tonai qa oqoro mate>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ego Ko tuqu, Mu nongoria na ovovelequ ara isa vei mana garununigo ara: ");
INSERT INTO lga_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mu lao pa gogodo qoti ko mu teku vanisiu karu tuni qoti kokoregadi, ko ma roitiniria na tetekuna jongana vania na tamamu isa vei sa nyoguania isa. ");
INSERT INTO lga_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Beto mu pogoso lao vania na tamamu ko mi tekua ko mi mananigo tonai sa oqoro mate isa, saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Poni pira tu sau si Jekopi lao tai Ribeka na tinana, <<Koi! Ba i Isoa sa sa pupulu na tinina goto ara sa lilioso na tiniqu. ");
INSERT INTO lga_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kita mi ulisiu na tamaqu. Ko ara mina dogoro veinisiu kai tinoni sesekequ ko mana teku tarinisiu na leleve tu nake mana,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ba pira saunia na tinana sisa, <<Tuqu, na leleve tamu sa mi raja taqu. Goto ao mu nongoria gu na ovovelequ ara. Ko mu lao teku vanisiu sa isa qa garununigo ara,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ko i Jekopi sa lao ko sa tekua ko sa pogoso lame vania na tinana ko na tinana sa roitinia sa na tetekuna jongana sa nyoroguania na tamana. ");
INSERT INTO lga_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Beto sa tekua i Ribeka sa na poko jojongana tai Isoa na tuna pa moa, isa sa kopunia na tinana pa ruma, ko sa vasaenia si Jekopi isa na tuna pa ligu. ");
INSERT INTO lga_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Beto sa udeniria na vuliti qoti sa karu limana beto na kobu ruana kepore pupuluna. ");
INSERT INTO lga_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Beto sa kaqamania pa limana i Jekopi sa na tetekuna jongana beto na bereti sa vatanai. ");
INSERT INTO lga_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ko sa lao tana tamana si Jekopi beto pira sau, <<Tamaqu,>> saunia. Poni pira sau si Aisake, Aive qugu tuqu, i sei sao? saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Poni pira saunia na tamana si Jekopi, <<Ara Isoa na tumu moa sapi. Qa tei vatanai tu sa isa vei qu garununisiu. Mu tatakole ko mu tekua sa na tetekuna beto mu mananisiu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Poni pira saunia i Aisake sa na tuna, <<Koi Ai vei ko quke ruavo batia?>> sau. Poni pira sau si Jekopi, <<i Iahova na Tamasa tugu tamu tugu sa veinisiu ke,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Beto pira saunia i Aisake si Jekopi, <<Mu rijo lame tata ko ma uligo tuqu. Ao tuqu Isoa tugu sapi ba dai?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Poni sa rijo tata lao tai Aisake na tamana si Jekopi ko sa ulia sisa beto pira sau, <<Koi! Na ovovele sa na ovovelena tugu i Jekopi ba ira na lima sa na limana tu i Isoa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ego ko sake gigalia sisa ura ira na limana sa qai pupulu vei na limana i Isoa na tugana ba sa manania sisa. ");
INSERT INTO lga_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Beto pira sau si Aisake, <<Ao na tuqu i Isoa tugu sapi?>> saunia. Poni pira sau si Jekopi, E! <<Ara tugu sapi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Poni pira sau si Aisake, Ego, <<Mu vanisiu ko ma tekua sa na tetekuna tuqu ko ma mananigo,>> saunia. Ko i Jekopi sa vania na tetekuna ko sa teteku beto sa vania tugu vei kaki vaini ko sa buku. ");
INSERT INTO lga_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Beto poni i Aisake na tamana sa pira saunia sisa, Mu rijo tata lame lani ko mu aosiu tuqu, sau. ");
INSERT INTO lga_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ko sa rijo tata lao si Jekopi ko sa aoa. Totonai sa umangia i Aisake sa na umangana nona poko poni sa sa manania sisa, pira sau, <<Um! Na umangana na tuqu marene Sa vei na umangana na kobu ia Isa sa manania i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Na Tamasa mi vanigo na odikina na oka Beto na masuruna na peso Ko mi soku na kiko beto na vaini kokoregadi. ");
INSERT INTO lga_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ira na okokoto tinoni mai nabulunigo Beto ira na okokoto gugugusu sa mai titi opo gore tamu. Mu bangaraniria sira na tugamu na tasimu, Beto ira na marene qai podo pa kai tinamiu mai titi opo gore tamu. Ira mai levenigo ao sa mai taleve Beto ira mai mananigo sa mai tamana tugu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Pa liguna sa beto manania i Aisake si Jekopi ko i Jekopi sa koni votu loai tugu si Aisake na tamana, poni sa sa bola kamu tugu koni beto ropa si Isoa na tugana. ");
INSERT INTO lga_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ko isa sa vatunua tugu sa na tetekuna jongana ko sa pogoso lame vania na tamana. Beto pira saunia, <<Tamaqu, mu tatakole ko mu tekua na tetekuna qa riu ropai beto mu mananisiu sara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Poni pira tu sau si Aisake, <<I sei sao?>> saunia. Poni pira sau sisa, <<Ara sa na tumu marene pa moa i Isoa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Poni sa matagutu neneqerenia si Aisake ko pira sau, <<Goto i sei tu sa riu ropa mamanugu ko sa tei poso kamu vanisiu tu ara sa na tetekuna ko ara qa tei tekua tu tonai qu oqoro bola kamu ao? Ko qa tei manania tu ara sisa ko isa tugu sa mina tamana?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Totonai sa nongoria i Isoa na parangana na tamana, sa vagorea kai lukana lavata ko sa kokora vivitigi beto pira saunia sa na tamana, <<Tamaqu, ara ba mu mananisiu tugu qau,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ba pira saunia na tamana sisa, <<Na tasimu marene sa kamu roiti seseke ko sa tei tekua tu sa na mana tamu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Poni pira sau si Isoa, <<Soni vei ko qai vaisongonia i Jekopi sisa? Sa iko ligusiu karu totoso kopira: Momoe sa tei tekua mai tu sa na neqi podo moa taqu beto kopira api sa sa tekua mutugu sa na mana taqu, saunia. Beto pira saunia sa na tamana, Ai vei, quke kopu golomo vanisiu kai mana ara?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Poni sa oea i Aisake si Isoa, pira saunia, <<Qa tei udukia tu ara sisa ko mina bangara nigo sao beto qa tei udukuria tu ara sira tavitina ko mai nabulunia, beto qa tei vatana vakole vania tu ara sa na kiko beto na vaini kokoregana. Ko tamu sa, na sa beka mana boka vanigo tuqu?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Sa pira saunia i Isoa sa na tamana, <<Tamaqu! Ai vei kame tugu sa na mana qu isongia ao? Ara ba mu mananisiu tugu Tamaqu,>> sau beto sa ovulia na ovovelena beto sa vagorea sa kai lukana lavata si Isoa. ");
INSERT INTO lga_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Sa pira sau si Aisake na tamana, <<Ketakoi muna suvere ao sa Minake masuru na peso Beto minake gorea na odikina na oka. ");
INSERT INTO lga_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Muna toa pa benisi sao Beto muna nabulunia na tasimu. Ba totonai munake tavaraguania sisa, Sa muna teku visu pale ao sa na mamata sa vapakunigo,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ego ko i Isoa sa kuonia si Jekopi pa laena na tamana sa tei vania tu na ona i Jekopi sa na mana. Ko pira sau pa bulona si Isoa, <<Qai tata lame gu sira na rane tonai mana lukana loloa ara sa na tamaqu beto sa mana vaipale gu ara si Jekopi na tasiqu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Totonai qai ule vania i Ribeka sa na sakasa sa pojai i Isoa isa na tuna moa, poni sa sa kuku vakamua si Jekopi na tuna pa ligu ko pira saunia, <<Tuqu, i Isoa na tugamu sa korapa vamanoto mulenia mekana na roroquna mina vaigo sao. ");
INSERT INTO lga_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ego Ko kopira tuqu! Mu nongoria na ovovelequ ara. Mu qaqiri ko mu uku riu tai Lebani na luluqu ara pa Harani. ");
INSERT INTO lga_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Mu suvere tavitia isa mai iapeki totoso ko tinganai mina gabala sa na kokora tana tugamu. ");
INSERT INTO lga_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Totonai tu mina gabala vapele sa na kokora tana tugamu beto mina roqumumania sa na sakasa qu roiti laonia tana poni sa mana vaigarunu sara ko mai vanongorigo ko muna mule kamu. Ura sake jongana sa pa kai muqisi rane tugu sa ara mana lukanagou sagou karu tuqu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Beto pira saunia i Ribeka si Aisake, <<Kei! Ara sa qake isongo tavaraguania sa na susuvere tadira na rereko Hitai aipira. Ko vei mina tekua mule kai rereko Hitai vevei aipira pa ia lani minagu si Jekopi, poni sa na sa mule laona sa mana kole toa lalaoqua sara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ego i Aisake sa kukua si Jekopi ko sa manania beto sa garunia pira saunia sisa: <<Muke alava rereko Kenani. ");
INSERT INTO lga_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Goto mu qaqiri ko mu riu pa Padani Arami, pa tatamana tai Betueli isa na tamana na tinamu ko mu tekua kai maqotamu ketakoi tadira na tuna rereko i Lebani isa na luluna na tinamu. ");
INSERT INTO lga_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Na Tamasa neqina jola mi mananigo beto mi vavuago beto mi vasokugo ko mu vaiminetai soku tinoni. ");
INSERT INTO lga_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ko isa mi vanigo sa na mana tai Ebarahami, ao beto na tutimu ao ko mu isongia sa na ia ketakoi qu korapa suvere vei na tinoni karovomu, na ia isa na Tamasa sa vania i Ebarahami,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ko sa garunia i Aisake si Jekopi ko sa riu pa Padani Arami, tai Labani na tuna marene i Betueli na tinoni Arami, isa na tasina marene i Ribeka na tinadi ira Jekopi i Isoa. ");
INSERT INTO lga_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ego sa batia i Isoa sa I Aisake sa manania si Jekopi beto sa garunu variua pa Padani Arami ko mi tekua kai maqotana ketakoi saunia. Totonai sa manania sisa sa sa garunia, pira saunia, Munake tekua kai maqotamu tadira na rereko Kenani sao, saunia. ");
INSERT INTO lga_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ko sa nongoria i Jekopi sa na tamana beto na tinana ko sa riu pa Padani Arami. ");
INSERT INTO lga_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ego sa batia i Isoa sa ira na rereko Kenani sa qaike vatavaraguai si Aisake na tamana, ");
INSERT INTO lga_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ko sa lao tai Isimeli si Isoa ko sa tekuni maqotana si Mahalati na luluna i Nebaioti beto na tuna rereko i Isimeli isa na tuna marene i Ebarahami, ko sa tamo laonia tadira na maqotana sa tei tekuria tu perangana. ");
INSERT INTO lga_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ego ko sa taloa pa Biaseba si Jekopi ko sa riu pa Harani. ");
INSERT INTO lga_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Totonai sa kamu pa kai ia isa, poni sa mi vajola bongi mai ketakoi sau ura sa tei suvu tu sa na tapo. Ko sa tekua sa kai patu pa ia isa ko sa tarubatunia beto sa gona kole puta sa pa ia isa. ");
INSERT INTO lga_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ko sa putagita sisa, sa batia sa kai kekesana sa turu pa peso beto na batuna sa kamu tu pa noka, beto ira na mateana tai Tamasa sa qai korapa saea beto gorea sisa. ");
INSERT INTO lga_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ko pa narena isa sa turu si Iahova beto pira sau, <<Ara si Iahova, na Tamasa tai Ebarahami na tamamu beto na Tamasa tai Aisake. Na peso qu korapa kolea ao sa mana vanigo ao beto ira na tutimu ao. ");
INSERT INTO lga_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Na tutimu ao sa mai vei na kavuruna na peso, beto muna qaqatia doru eqa lao vei pa kale suvu tapo, pa sagere tapo, pa kale saena beto pa kale gorena. Ko doru miminete tinoni pa nabana sa mai tamanadia tamu beto tadira na tutimu ao. ");
INSERT INTO lga_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ko ara mana vavaburogo beto mana kopunigo pai eqa muna lao vei, beto mana toni mule kamunigo tugu pa peso api. Ura maneke loago ara sao tinganai mana roiti votunia ara sa vei qa pojanigo ao,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Tonai sa dorava pa ona puta si Jekopi sa, pira sau, <<Koi sosoto! I Iahova sa pa ia lani, ba ara qake gigilai,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ko sa matagutu ko pira sau, <<Na ia vaivamatagutuna jola sa na ia api! Ko nake goto ia goto na ruma tai Tamasa sa lani ko api sa na atakamanana pa noka,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ego sa turu vuvugei jonga si Jekopi, sa tekua sa na patu sa tarubatunia beto ko sa vaturu veinia na babara beto sa vuvani oela sa na batuna na patu. ");
INSERT INTO lga_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Beto sa vakukunia Beteli na isongona sa na ia isa ba Luzi tu sa na isongona sa na gugusu isa perangana. ");
INSERT INTO lga_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ego ko sa maulunia i Jekopi sa kai maulu, pira sau, <<Vei na Tamasa sa mina vavaburosiu beto mina kopunisiu pa qua rererege qa korapa lekogonia api beto vei mina vanisiu na tetekuna ko mana teteku beto na poko ko mana vasaea, ");
INSERT INTO lga_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","beto ko mana gabala mule pa bule pa ruma tana tamaqu, poni sa I Iahova sa mina Tamasa taqu ");
INSERT INTO lga_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ko na patu alepi isa qa patubiti vaturu veinia na babara sa mina na ruma tai Tamasa beto pa doruna na sakasava qu vanisiu sa kame pa manoga sa mana valao vanigo ao ara,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ego ko sa ovulia na nenena si Jekopiko sa taloa riu veiona pa ia tadira tinoni pa kale sagere tapo. ");
INSERT INTO lga_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ketakoi sa batia sa kai oqili pie takorina pa ia isa beto ka ue godo sipi qai korapa tugu toqo opodia tata pa oqili pie ura pa oqili pie tugu isa sa qai teku vaniria na pie sa na sipi. Ego na patu lavata sa sa kole pa mangana na oqili pie. ");
INSERT INTO lga_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Totonai qai vavaikamu doru gogodo sipi ketakoi sa, ira na sepati qai vatitolo rijoa sa na patu pa mangana na oqili pie beto qai vabukuria sa na sipi. Beto poni sa qai vakole mulea sa na patu pa mangana na baongo oqili pie. ");
INSERT INTO lga_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Sa nanasaria na sepati si Jekopi, pira sau, <<Boko tavitiqu, Pai tinonimiu sagou?>> sauniria. Poni qai oe lao sira, Koi! <<Agei na tinoni Harani gu,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Sa pira sauniria, <<Ko qu gigilaimiu tu agou si Labani na mabusu tai Naho?>> sau. Poni pira qarigu sira, <<E! Qe gigilaimei,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Poni pira sauniria mutu i Jekopi, <<Ko ai vei sa korapa gu suvere vataleona?>> sau. Poni pira qarigu, <<E! Sa korapa gu suvere vataleona.>> <<Inana tugu ko i Resolo na tuna rereko isa, sa toni lameniria na sipi,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Poni pira sauniria, <<Dotu!>> <<Korapa pa nulu tu sa na tapo ko nake totoso mai tavaikamu na gogodo sipi. Ko mu vabukuria beto mu toni mule laoniria nyaqo buburu gagani,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ba qai oe lao tu sira, Koi! <<Meneke boka,>> <<mai vaikamu beto mai tu na gogodo sipi beto mina tavatitolo rijo mai tu na patu pa manga baongo oqili pie beto sa mene vabukuria sa na sipi,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Totonai sa korapa parangaria isa poni, sa kamu tugu si Resolo toniria na sipi tana tamana ura na tinoni kopu sipi si Resolo. ");
INSERT INTO lga_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Totonai i Jekopi sa batia si Resolo na tuna rereko i Labani isa na luluna na tinana beto sa batia na sipi tai Labani, poni sa i Jekopi sa lao tata ko sa vatitolo varijoa sa na patu pa mangana na oqili pie ko sa vabukuria sa na sipi tai Labani na luluna na tinana. ");
INSERT INTO lga_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Beto sa aoa i Jekopi si Resolo beto sa ovulia na ovovelena ko sa vagorea sa kai lukana lavata si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ego beto i Jekopi sa vavakato vania si Resolo sa isa sa na tavitina na tamana beto na tuna marene i Ribeka sisa saunia. Poni sa abutu riu vavakato vania na tamana si Resolo. ");
INSERT INTO lga_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ego isa tugu sa nongoria i Labani sa na vavakatona i Jekopi na tuna marene na luluna poni sa abutu lao ko mi gosoria sau. Ko sa borua, sa aoa beto sa toni laonia pa ona ruma sisa. Beto sa vavakatonia i Jekopi tai Labani sa doru sakasa aipira. ");
INSERT INTO lga_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Beto pira saunia i Labani sisa, <<Ao sa na pupudaqu ara beto na masaqu ara,>> saunia. Ego beto sa suvere kai popu doruna tai Labani si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ego pira saunia i Labani si Jekopi, <<Na vabuguqu ara sao, ba sake jonga sa muna kole roiti goboro vanisiu ara. Ko mu ule vanisiu ka visa na tabaramu ao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ego ko koleona karu tuna rereko si Labani; na isongona isa pa moa si Lia beto na isongona isa pa ligu si Resolo. ");
INSERT INTO lga_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Na matana i Lia sa qai leduru goto i Resolo sa isongia na tini momorutuna beto na tini babata jonga. ");
INSERT INTO lga_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ba i Jekopi sa nyoroguania isa si Resolo ko pira sau, <<Ara mana roiti vanigo ka vitu aoro ko muna vanisiu i Resolo, na tumu rereko pa ligu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Sa pira sau si Labani, Koi! <<Sa vavagua jola mana vanigo ara sisa jolania vei ba vaniria kaki goto marene. Ko mu suvere taqu lani,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ko i Jekopi sa roiti ka vitu aoro na vaina i Resolo, ba qai jola vei ka vivisa rane gu tana ura sa roroqua isa si Resolo. ");
INSERT INTO lga_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Beto pira saunia Jekopi si Labani, <<Mu valame vanisiu na maqotaqu. Ura sa okoto gu sa na totoso taqu ko kopira ma lao tome nagoa sisa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ko i Labani sa kuku vakamuria sa doru na tinoni pa gusu ko sa roitinia kai vavolo. ");
INSERT INTO lga_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ba totonai sa gore na vevelu, poni sasa tekua isa si Lia ko sa toni lao vania isa si Jekopi ko mi lao tome nagoa saunia. ");
INSERT INTO lga_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Beto i Labani sa vania i Lia si Zilipa nona nabulu rereko ko mina tokania isa sau. ");
INSERT INTO lga_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ko sa sae na vuvugei ko mi doro sau si Jekopi, sa i Lia gu sa sa korapa suvere tavitia sisa. Poni sa pira saunia i Jekopi si Laban, <<Na sa qu roitinia taqu sao? I Resolo tu sa qa roiti vanigo ara ao ko muna tabaranisiu qugu. Ai sa vei ko qu sesekesiu?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Poni pira saunia i Labani, <<Dai nake tutina tamigei pa ia lani sa mene vaiia momoenia sa isa na rereko pa ligu beto mene vaiiania sisa pa moa. ");
INSERT INTO lga_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ko mu vaokotia mai ao sa na kai vuiki roiti vaialava tana kame api, beto poni sa kode tana vanigo mule sa kame le api isa na laena na roiti muna roiti vanisiu ara kai vitu aoro mutu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ego ko sa roiti vei tugu si Jekopi. Sa vaokotia isa sa na kai vuiki roiti vaialava tai Lia, beto poni i Labani sa vania ko kai maqotana mule si Resolo na tuna rereko. ");
INSERT INTO lga_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Beto i Labani sa vania tugu vei i Resolo na tuna rereko si Biliha na ona nabulu rereko ko mina tokania isa sau. ");
INSERT INTO lga_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ko i Jekopi sa kole tavitia tugu vei si Resolo ko sa roroqu vivitigia si Resolo jolania i Lia. Ko sa roiti vania kai vitu aoro mule si Labani. ");
INSERT INTO lga_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Totonai sa batia i Iahova sake tatavaragua si Lia sa, sa revangia i Iahova sa na iapana i Lia goto i Resolo sa sa egoro. ");
INSERT INTO lga_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ego sa bogata si Lia ko sa vapodoa sa kai tuna marene ko sa vakukunia i Rubeni sisa, ura pira sau, <<Pa laena i Iahova sa bationa sa na tapata taqu ko kopira na marenequ mina roroqusiu sara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ego ko sa bogata soga mule si Lia, ko sa vapodoa kai tuna marene poni pira sau, <<Sa nongoria i Iahova sa qake tatavaragua sara, sa vei sa sa vanisiu mule sa alepi,>> sau. Ko sa vaisongonia i Simioni isa sisa. ");
INSERT INTO lga_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ego ko sa bogata soga mutu si Lia, ko sa vapodoa kai tuna marene sa pira sau, <<Kopira tu sa na marenequ sa mina togasa vamauru taqu ura qa vapore vania ka ue marene,>> sau. Ko sa vei sa vaisongonia i Levi. ");
INSERT INTO lga_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ko sa bogata ligu mutugu sisa, ko sa vapodoa mutugu kai marene poni sa pira sau, <<Kopira mana vatarasaea ara si Iahova,>> sau. Ko sa vaisongonia i Jiuda. Beto sa noso teku koburu si Lia. ");
INSERT INTO lga_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Totonai i Resolo sa batia sake vapore vania na koburu si Jekopi, poni sa sa konoa sa na tugana rereko. Ko pira saunia si Jekopi, Kei! <<Mu vaporenisiu na koburu, minake vei sa kode mana matequa,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Poni sa tagigirinia i Jekopi si Resolo ko pira saunia, <<Ara sa na Tamasa isa sa aru mulenia tamu na vuana na iapa?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Poni pira sau si Resolo, <<Ego vei, ina ropi i Biliha na qua nabulu rereko. Mu tome nagoa ko mi boka vapodo vanisiu na koburu ko ara mana boka roitinia kai tatamana,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ko sa vania ko mi maqotana i Jekopi si Biliha nona nabulu rereko. Ko sa tome nagoa i Jekopi sisa, ");
INSERT INTO lga_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ko sa bogata sisa ko sa vapodo vania kai tuna marene si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Poni pira sau si Resolo, Na Tamasa sa pitu ruvatasiu beto sa nongoria tugu vei na ovovelequ ko sa vanisiu kai koburu marene, sau. Ko sa vei sa sa vaisongonia i Resolo i Dani sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Beto sa kai bogata ligu mule si Biliha na nabulu rereko tai Resolo ko sa vapodoa vania i Jekopi na vinarua marene. ");
INSERT INTO lga_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Poni pira sau si Resolo, <<Na vaitoregasa tai Tamasa sa qa toregasania na tugaqu ara ko kopira qa lenonia ara,>> sau. Ko sa vei sa sa vaisongonia i Naputali isa sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Totonai sa batia i Lia sa nogoto teku koburu sisa, sa tekua si Zilipa nona nabulu rereko ko sa vania isa si Jekopi ko mi maqotana saunia. ");
INSERT INTO lga_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Poni sa i Zilipa na nabulu rereko tai Lia sa vapore vania kai tuna marene si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Poni sa pira sau si Lia, <<Beko vavagua jola mutu,>> sau. Ko sa vei sa sa vaisongonia i Qadi isa sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ego beto sa, i Zilipa na nabulu rereko tai Lia sa vapodo vania mule na marene vinarua si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Poni sa pira sau si Lia, <<Qa qera vivitigi sara ko ira na rereko kode mai kukunisiu Qera,>> sau sisa. Ko sa vei sa sa vaisongonia i Asa isa sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Pa totoso abu vakamu vuiti, sa i Rubeni sa batiria sa kaki buburu roro pa inuma ko sa pogoso kamu vania i Lia na tinana. Poni sa pira saunia i Resolo si Lia, <<Bu vanisiu kaki buburu roro sa tekuria na tumu marene,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Sa pira sau si Lia, Ago! <<Qu tei teku variunisiu tu sa na marenequ. Ko kopira muna teku variunia mutu sa na buburu roro tana tuqu marene?>> sau. Poni pira sau si Resolo, <<Ego vei sa isa mi puta tavitigo ao kode bongi na lipuna na buburu roro tana tumu marene,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ko totonai sa tome lame si Jekopi koko pa mumuqu na vevelu poni, sa votu lao si Lia ko sa gosoria sisa beto pira saunia, <<Ara sa muna puta tavitisiu ao.>> Sau sisa. <<Ura qa tei tabaranigo tu na buburu roro tana tuqu marene ara sao,>> sau. Ko na bongina sa i Jekopi sa puta tavitia si Lia. ");
INSERT INTO lga_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ego sa nongoria na Tamasa sa na nyorogua tai Lia ko sa bogata sisa ko sa vapore vania na tuna marene vinalima si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Poni sa pira sau si Lia, <<Na Tamasa sa vanisiu na tabaraqu na laena qa vania na qua nabulu rereko sa na marenequ, sau>> sisa. Ko sa vei sa sa vaisongonia i Isika isa sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ego sa bogata soga mule si Lia ko sa vapodoa vania na tuna marene vinavonomo si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Poni sa pira sau si Lia, <<Na Tamasa sa vanisiu kai vaivana poreveveina. Kopira alepi na marenequ sa kode mina valavatasiu, ura qa vapore vania ka vonomo marene,>> sau sisa. Ko sa vei sa sa vaisongonia i Zebuluni isa sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Pa liguna lao poni sa vapodoa kai tuna rereko si Lia ko sa vaisongonia i Dina. ");
INSERT INTO lga_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ego sa roqu kamua na Tamasa si Resolo, beto sa nongoria na Tamasa sisa ko sa revangia sa na iapana. ");
INSERT INTO lga_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ko sa bogata ko sa vapodoa i sa sa kai tuna marene beto pira sau, <<Na Tamasa sa teku pale na qua kea,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Sa vaisongonia i Josepa sisa, beto pira sau, I Iahova mi tamo vanisiu mule kai tuqu marene, sau. ");
INSERT INTO lga_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Pa liguna i Resolo sa vapodoa si Josepa, sa pira saunia i Jekopi si Labani, <<Ai vei bu vamalumusiu ko ba boka mule lao pa qua ia beto pa qua peso. ");
INSERT INTO lga_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Mu vanisiu karu maqotaqu beto ira na qua koburu ira qa roiti tale vanigo ko ma taloa riu,. Ura qu gigilaimua ao sa na roiti qa roiti vanigo ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Poni pira saunia i Labani sisa, <<Vei bu qeranisiu ara sao, sa bu suvere qau. Qa batia pa vinagila ara sa, i Iahova sa mananisiu ara pa laemu gu ao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Beto pira sau, <<Mu pojanisiu na tabaramu ko ma vanigo ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Beto pira saunia i Jekopi sisa, <<Qu gigilaimua ao sa ai qa roiti veini vanigo ara sao beto ai qa vasoku veini vanigo ara sira na mua papausu. ");
INSERT INTO lga_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ura ka vivisa qu isongia ao tonai qa oqoro kamu ara lani sa kopira qai vovonu vasoku, beto i Iahova sa mananigo sao pai ketakoi sa tete na nenequ ara ko kopira ai totoso mana boka roiti vania na qua tatamana sara?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Poni pira sau si Labani, <<Na sa sa mana vanigo ao?>> sau. Sa oe si Jekopi, pira sau, <<Munake vanisiu tu kai sa.>> <<Goto isa ma tepanigo ara ao kopira sa mu roiti vanisiu, ko ara ma kole tugu dodogororia beto kopuniria ara sa na gogodo sipi tamu. ");
INSERT INTO lga_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Mu vamalumusiu ko pa ngeni alepi, ba lekogo doro betoria ara sa doru gogodo sipi tamu beto ko ba pikata varijoria sira doru sipi qai kikirikoti babi tototu, doru tuni sipi kukudedi beto doru qoti qai tototu babi kikirikoti. Mi isa gu sa na tabaraqu ara. ");
INSERT INTO lga_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Na tuvisi taqu pa ngeni sa mina ule tokanisiu vuka risa totonai muna lao kamuria ao sira vei qu tabaranisiu. Ira doru qoti vei qaike kikirikoti babi tototu beto na tuni sipi qaike kukude taqu sa muna doro veiniria na taikodi gu sira,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Poni pira sau si Labani, <<Vavagua!>> <<Mi vei isa qu pojai ao,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Pa ranena tugu isa sa varijoria i Labani sa doru qoti marene qai gagasi babi qai tototu beto doru qoti rereko kikirikoti babi qai tototu (doru kekekadi) beto doru tuni sipi kukudedi beto ko sa vakopuniria ira na tuna marene. ");
INSERT INTO lga_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Beto sa vakole vaipikatainiria padana kue rane lelekogo sa mekana beto i Jekopi beto ko i Jekopi sa kole dogoro kopuniria sa doru sipi kole joladi tai Labani. ");
INSERT INTO lga_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ba i Jekopi sa likoto tekuria sa na kae gou popola; na gou alimodi, na gou peleni beto sa lida gasi vagigilaria sa na kopodi na kae gou ko totonai sa dosi teku pale na kopodi poni sa sa votu sa na kekana na gou. ");
INSERT INTO lga_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Beto sa vakoleniria pa leona na ia bubukudi tadira na sipi sira na kae gou tadosidi pa ia vei qai lame buku poni sa qai bata tariria sosoto sau. Ko totonai qai korapa nyorogua vaipapa ko qai lao buku qarigu sa na sipi, ");
INSERT INTO lga_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","poni sa qai vaikesa pa moedi na kae gou. Poni qai vapodoria sa na tuni sipi gagasidi beto na kikirikotidi beto na tototudi. ");
INSERT INTO lga_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ko i Jekopi sa pikata kaleniria sira na tuni sipi beto ira doru kole joladi sa sa vagabala lao veiniria pana sipi gagasidi beto na kukudedi tai Labani. Ko sa pikata kaleniria isa sira nona papausu ko sake vaisomanainiria pa sipi tai Labani. ");
INSERT INTO lga_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tonai vei bai nyorogua vaipapa sira na sipi rereko sisibadi, poni sa i Jekopi sa gigila vakoleria sa na kae gou pa leo ia bubukuna tadira na sipi pa moedi na sipi ko qai vaikesa tata pa kaedi na gou sau, ");
INSERT INTO lga_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ba vei bi batiria sira na sipi mamaleidi, poni sa sake vakoleria sa na kae gou. Ko ira na sipi mamaleidi sa qai lao vei tai Labani goto ira na sisibadi sa qai lao tai Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ko pa soana vei api sa, i Jekopi sa pururu votu ko sa kai tinoni isisongona jola ko sa isongoria soku sipi, ira na nabulu rereko, ira na nabulu marene, ira na kameli beto ira na dongiki. ");
INSERT INTO lga_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ego sa nongoria i Jekopi sa na paparangadi ira na tuna marene i Labani, pira qarigu, Koi! <<Sa teku beto pale i Jekopi sa doru sakasava tana tamada ko pana sakasa gu tana tamada sa roiti votuniria isa sa doru ona isisongo,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ego beto sa batia tugu vei i Jekopi sa na beina na isumatana i Labani sa sake vevei perangana. ");
INSERT INTO lga_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Poni pira saunia i Iahova si Jekopi, <<Mu mule lao pa ia tadira na tamamu beto na tavitimu, kode ara mana vavaburogo,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Poni i Jekopi sa garunu laoniria na paranga sira Resolo i Lia ko sa kuku valameria pa ia ketakoi sa korapa kopuniria nona gogodo sipi. ");
INSERT INTO lga_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Beto pira sauniria, Qa batia ara sa na beina na isumatana na tamamiu, ko kopira sake vevei lame taqu sa vevei perangana ba na Tamasa tana tamaqu sa sa korapa suvere tavitisiu sara. ");
INSERT INTO lga_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Qu gigilaimiu agou karu sa qa roiti viviva vania na tamamiu sara, ");
INSERT INTO lga_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ba na tamamiu sa sesekesiu ara ko sa kole vavarijoa ka manogaputa totoso na tabaraqu. Ba na Tamasa sake vamalumia ko bi koti vikeresiu sara. ");
INSERT INTO lga_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Totonai sa paranga, Na kikirikotidi sa na tabaramu ao sau sa doru sipi sa qai vapodoria na kikirikotidi tugu. Totonai na gagasidi sa na tabaramu ao sau sa doru sipi sa qai vapodoria sa na gagasdi tugu. ");
INSERT INTO lga_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ko na Tamasa sa teku variunia nona papausu sa na tamamiu agou ko sa vanisiu ara. ");
INSERT INTO lga_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","<<Totonai qai vavaivapodo na papausu, qa enga sae qa batiria pana qua putagita sa na qoti marene qai korapa paparia na qoti gagasidi, na kikirikotidi beto na tototudi. ");
INSERT INTO lga_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Beto pira saunisiu sa na Tamasa pana putagita, <Jekopi>, sau. Poni pira qaunia, <Api sara,> qau. ");
INSERT INTO lga_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Poni pira saunisiu, Mu enga sae ko mu batira sa doru qoti marene qai korapa paparia na papausu sa na gagasadi, na kikirikotidi beto na tototudi, ura qa tei batiria tu ara sa doru sakasa sa roitiniria i Labani tamu. ");
INSERT INTO lga_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ara sa na Tamasa pa Beteli, ketakoi qu vuvani oela ao kai patu babara beto ketakoi qu maulu lamenia kai maulu taqu. Kopira tugu mu qaqiri ko mu taloa sa pa ia api ko mu mule lao pa ia ketakoi qu podo,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Poni pira qarigu sira Resolo i Lia, <<Kepore mutugu sa na iamei pana isisongo pana tatamana tana tamamei sagei karu. ");
INSERT INTO lga_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Sa roiti veinigei tu na tinoni karovomei sagei karu ko sa vavai palenigei, beto sa gani beto pudala pale sa na poata tamigei karu. ");
INSERT INTO lga_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ko doru isisongo tana tamamei sa teku variunia na Tamasa sa tamigei karu beto tadira na tumei. Ko kopira mu roitinia gu ao sisa vei sa pojanigo na Tamasa>>, qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Beto sa sa qaqiri si Jekopi ko sa vakoiria pa kameli sira na tuna beto ira na maqotana, ");
INSERT INTO lga_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","beto ko toni lao vamomoeria sa nona papausu, tavitiria doruna na sakasa sa kopu vaululuniria pa Padani Arami ko mi mule lao tai Aisake na tamana pa ia pa Kenani sau. ");
INSERT INTO lga_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ego totonai sa riu ngabuturia na vurungudi nona sipi si Labani sa, sa iko tekuria i Resolo sira na tamasa tai Labani na tamana. ");
INSERT INTO lga_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Beto i Jekopi sa sa vagonai si Labani na tinoni Arami ko sake pojania sa sa korapa uku riuona sisa. ");
INSERT INTO lga_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ego ko mi uku riu tavitiria doru sakasava sa isongoria sau sisa ko sa qaqiri beto sa karovia na ovuku pa Eupareti beto sa bata sae vei pa kale ia kukubona pa Qiliadi. ");
INSERT INTO lga_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ego na rane vinaue tu beto sa nongoria i Labani sa tei uku riuona tu si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ko sa toniria na tavitina qai korapa suvere tavitia beto ka vitu rane sa adu tututia si Jekopi ko sa riu kamunia pa kukubo pa Qiliadi. ");
INSERT INTO lga_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Poni sa votu tai Labani na tinoni Arami pa ona putagita na bongi sa na Tamasa ko pira saunia, <<Babana ko mu vakesania kai paranga ikerena babi jongana si Jekopi,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Totonai sa lame kamua i Labani si Jekopi poni sa i Jekopi sa sa tei vaturua nona aqaqo tu pa kukubo pa Qiliadi, ko i Labani beto ira na tavitina ba qai vaturudia aqaqo tugu ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Beto pira saunia i Labani si Jekopi, <<Na sa qu roitinia sao? Qu vagonasiu, beto qu toni uku veiniria na pinausu pa totoso vaipera sira na tuqu rereko ara. ");
INSERT INTO lga_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ai sa vei ko qu uku riu golomo ko qu ikosiu ara sao? Ai sa vei quke pojanisiu, ko ba garunu variunigou pa qeqera, pa kekera beto pa vaqorodi na tabarini beto na mike? ");
INSERT INTO lga_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Vei ba ao loloaria gu na boko qua mabusu beto karu tuqu rereko ba quke veinisiu tu. Na roiti tuturu sa qu roitinia ao. ");
INSERT INTO lga_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Sa kolesiu gu na neqi sara ko mana boka koti vikeregou sagou, ba pa bongi na Tamasa tana tamamiu sa pira saunisiu, Babana ko mu vakesania kai paranga jongana babi ikerana si Jekopi sau. ");
INSERT INTO lga_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ba kopira ko qu tei riumua tu ura qu nyorogua vivitigi ko bu mule lao tadira na tavitina na tamamu qugu ke. Ba ai sa vei ko qu ikoria tu na qua tamasa ara?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Sa oe si Jekopi, pira saunia si Labani, <<Ura qa matagutu ura kita mu teku ragata variunisiu sira karu tumu rereko qau. ");
INSERT INTO lga_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Goto vei muna batia sisa sa tekua na mua tamasa poni sa minake toa tugu sisa. Pa moedi tugu ira na tavitida aipira sa, mu nyaqoa mekamu ko bi koleona sa kaki sakasa tamu taqu lani,, poni sa mu tekua gu,>> sau. Ego i Jekopi sake gigilai sa i Resolo gu sa ikoria sa na tamasa ira. ");
INSERT INTO lga_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ego ko sa tomea i Labani sa na aqaqo tai Jekopi beto na aqaqo tai Lia beto na aqaqo tadira karu nabulu rereko, ba kepotu sa kai sa sa batia. Pa liguna sa votu pa aqaqo tai Lia sa, sa tomea mule sa na aqaqo tai Resolo. ");
INSERT INTO lga_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ego perangana tu sa tekuria i Resolo sira na tamasa tai Labani ko perangana tu sa kuraniria pa leo totoqona na ona kameli ko sa kole toqo takoria i Resolo sa na tamasa. Ko i Labani sa nyaqo betoa doru eqa pa aqaqo ba sake batia kai sa. ");
INSERT INTO lga_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ego pira saunia i Resolo sa na tamana, <<Muke tagigirinisiu ara qua tinoni lavata vei qake boka turu pa moemu ao ura sa korapa vaisiu na mo rereko,>> saunia. Ko sa kole nyaqo doru eqa ba sake batiria sa na tamasa. ");
INSERT INTO lga_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Poni sa tagigiri si Jekopi ko sa talea si Labani. Ko pira saunia i Jekopi si Labani, <<Na sa sa na tapata taqu?>> <<Na sa sa na sela qa roitinia ara ko qu nyaqo mamangini tutinisiu ara?>> ");
INSERT INTO lga_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ura qu tei nyaqo beto paleria tu ao sa doru sakasava taqu ko na sa sa qu batia isa vei na dia sakasa na tatamana tamu? Mu vakole gorea lani kopira pa moedi ira na tavitiqu ara beto na tavitimu ao ko ira mai pitua sa i sei sa sela sa gita karu. ");
INSERT INTO lga_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","<<Ka rabeteputa aoro aipira sa qa suvere tavitigo ara sao. Ba kepotu sa kai qoti babi na sipi tamu bai tajue goboro, beto ara qake isongo gania kai qoti pa papausu tamu. ");
INSERT INTO lga_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Qake pogoso bolania tamu sira na manugu qai tavapapaleka vamate: Qa tavapogosonia mekaqu ara sa na beidi. Qu nyaqonisiu ara ao sa na vaina na sakasava qai taiko na bongi beto na sakasava qai taiko na rane. ");
INSERT INTO lga_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Pira qa vei sara: Na mangini sa ganisiu na rane, na lomoso sa ganisiu na bongi beto na qua puta sa uku loa palenisiu. ");
INSERT INTO lga_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Pira qa vei sara ka rabeteputa aoro qa suvere ara pa tatamana tamu. Qa roiti vanigo ka manoga made aoro na vaidi karu tumu rereko beto ka vonomo aoro qa kopuniria na mua papausu beto ka manogaputa totoso qu kole vavarijoa sa na tabara taqu. ");
INSERT INTO lga_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ko vei bike na Tamasa tana tamaqu, na Tamasa tai Ebarahami beto na Tamasa vaivamatagutuna tai Aisake bi suvere tavitisiu sa, kopira bu garunu vamule gagale palesiu ara sao. Ba na Tamasa sa bationa na tapata taqu beto na pavuna na limaqu ko sa vei sa sa pitugo pa bongi sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Poni sa oe si Labani, pira saunia si Jekopi, <<Ira na rereko sa na tuqu rereko ara, ira na koburu sa na koburu taqu, beto ira na papausu sa na papausu taqu. Doruna qu batiria sa taqu. Ba na sa sa mana boka roitinia pa ngeni alepi veveidi ira karu tuqu rereko aipira, babi veveidi na koburu qai vaporeria? ");
INSERT INTO lga_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ko mu lame ko tavatoqoa sa kai vinaego, ao beto ara, ko isa sa na ulule pa vaikorapaida gita karu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ko sa tekua i Jekopi sa kai patu lavata beto sa vaturu veinia kai babara. ");
INSERT INTO lga_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Beto pira sauniria i Jekopi sira na tavitina, <<Mu butiria kaki patu,>> sau. Ko qai teku patu ko qai boko vaitopareniria beto sa qai teteku tugu pa kekerena na boko patu isa. ");
INSERT INTO lga_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Ego i Labani sa vakukunia Jeqa Sahaduta sa na boko patu isa, goto i Jekopi sa vakukunia Qalidi. ");
INSERT INTO lga_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Beto pira sau si Labani, <<Na boko patu api sa na ulule pa vaikorapaida gita karu pa ngeni alepi,>> sau. Ko sa vei sa sa tavakukunia Qalidi. ");
INSERT INTO lga_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ego ko sa tavakukunia tugu vei Mizipa sisa ura pira sau, <<I Iahova mi doro kopunigita sa gita karu ura kode tana okoto suvere oda. ");
INSERT INTO lga_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Vei muna nganguluria na tuqu rereko ara babu tekuria mule kaki rereko vatamo lao tadira karu tuqu ara inara, poni sa kepore sa kai tinoni sa suvere tavitigita ba mu roroqua sa na Tamasa sa na ulule pa vaikorapaida gita karu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Beto pira saunia mule i Labani si Jekopi, <<Alepi sa na boko patu beto alepi sa na babara qa vaturua ara pa vaikorapaida gita karu. ");
INSERT INTO lga_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Na boko patu alepi sa na ulule, beto na babara api sa na ulule tugu, ko ara maneke jolania sa na boko patu api ko mana karovo lao roiti vivikere tamu beto ao munake jolania sa na boko patu api beto na babara api ko muna karovo lame roiti vivikere taqu. ");
INSERT INTO lga_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Na Tamasa tai Ebarahami beto na Tamasa tai Naho, beto na Tamasa tana tamadi ira karu sa mi pitugita gita karu,>> saunia. Ko sa maulu pa isongona na Tamasa vaivamatagutuna ti Aisake na tamana si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Sa vavakukuvunia kai vavakukuvu pa kukubo si Jekopi beto sa soruria sa na tavitina ko mai teteku sau. Pa liguna qai beto teteku sa, qai vajola bongi tugu pa kukubo ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Ego sa turu vuvugei jonga si Labani ko sa ao loloaria sira nona mabusu beto karu tuna rereko beto sa mananiria. Beto poni sa taloa si Labani ko sa mule pa ona gusu. ");
INSERT INTO lga_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ego i Jekopi ba sa rerege riuona tugu, poni ira na mateana tai Tamasa sa qai gosoria. ");
INSERT INTO lga_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Totonai sa batiria i Jekopi poni, sa pira sau, <<Na ia susuverena tai Tamasa sa lani,>> sau. Ko sa vaisongonia Mahanaimi i Jekopi sa na ia isa. ");
INSERT INTO lga_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ego i Jekopi sa garunu lao momoeniria tai Isoa na tugana pa ia pa Seia pa gugusu pa Edomu sira na tinoni pogoso nongoro. ");
INSERT INTO lga_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Pira sauniria, <<Pira munagunia si Isoa na qua iviva lavata; Na mua nabulu i Jekopi sa pira sau, Qa kole suvere tai Labani kamua tu kopira sara. ");
INSERT INTO lga_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Qa isongo bulumakau beto na dongiki, na sipi, na qoti, na nabulu marene na nabulu rereko. Kopira qa korapa vanongorigo sao na qua tinoni lavata, ai vei ko ao mu qeranisiu qau,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Totonai qai mule kamu ti Jekopi sira na tinoni pogoso nongoro, sa pira qarigunia si Jekopi, <<Qe lao kamua si Isoa na tugamu, ko kopira sa korapa lame ko mi gosorigo ao sau, tavitiria ira ka made gogoto ona tinoni,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Poni sa matagutu neneqere beto sa mamata si Jekopi ko sa pikataria sa nona tinoni pa karu pukuna beto vei tugu ira na gogodo sipi, na bulumakau beto na kameli. ");
INSERT INTO lga_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Sa rovea sa, <<Vei mina lame si Isoa ko mina rapatia kai pukuna poni sa kai pukuna sa kole sa mai boka ukudia,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Beto sa vavara si Jekopi, pira sau, <<Ao na Tamasa tana tamaqu i Ebarahami beto na Tamasa tana tamaqu i Aisake, Kei Iahova, Ao pira qugunisiu, Mu mule lao pa mua gusu beto tadira na tavitimu beto ara mana roiti veinigo kai tinoni puramu qugu. ");
INSERT INTO lga_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ara sa nake garoqu ko ba isongia sa na vairoqu jongadi beto na uana tarangena qu roitinia ao taqu na mua nabulu. Na qua opata gu sa qa isongia totonai qa karovia ara sa na ovuku pa Jodani api, ba kopira sa karu pukuna tu sa qa isongia ara. ");
INSERT INTO lga_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ko mu alosiu, qa tepago, pa limana na tugaqu i Isoa ura qa matagutunia ara sisa kita mi lame rapatasiu sara beto ira na tamatina. ");
INSERT INTO lga_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Beto pira qugu tugu vei, Mana veinigo kai tinoni puramu ara sao beto na tutimu ao sa mana veinia na nagasa pa poanana qaike boka taanye na sokuna qugu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ego ko sa vajola bongi ketakoi sa na bongina isa, beto sa vileria pa sakasava sa isongoria sa na vaivana tai Isoa na tugana: ");
INSERT INTO lga_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Karu gogoto qoti rereko beto ka rabeteputa qoti marene, karu gogoto tuni sipi beto ka rabeteputa sipi marene, ");
INSERT INTO lga_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ka uengavuluputa kameli rereko taviti tudia, ka made ngavuluputa bulumakau marene beto ka manogaputa bulumakau rereko, beto ka rabeteputa dongiki rereko beto ka manogaputa dongiki marene. ");
INSERT INTO lga_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Beto sa vakopuniria nona nabulu, pa dia okokoto papausu, beto pira sauniria sa nona nabulu, <<Mu lao momoe pa moequ, goto mu vaisouniria ko mi kole sa na lolomo pa vaikorapaidi na okokoto gogodo papausu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Beto pira saunia sa na tinoni pa momoe, <<Totonai mina gosorogou si Isoa na tugaqu ko mina nanasa, <Na tinonimiu tai sei sao, pai qu korapa lao vei beto I sei sa isongoria sa doru papausu pa moemu inara?> minagu sa ");
INSERT INTO lga_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","pira munagunia, Koi! Na papausu tana mua nabulu i Jekopi sa aipira. Na vaivana sa garunu lamenia tana qua bangara i Isoa sau goto isa sa korapa lalameona pa ligumei munagu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Na tinoni vinarua, na vinaue beto doruna tugu qai tutiria na papausu ba sa vavanau veiniria tugu inara, pira sau, <<Kai muqisi paranga tugu api sa muna pojania si Isoa sa totonai muna gosoria, sauniria. ");
INSERT INTO lga_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Beto pira tugu muna poja veinia vei, Na mua nabulu i Jekopi sa korapa tututiona pa ligumei,>> munagu. Ura sa rorovea sa pira sau, <<Mana vabulenia na roquna ara sira na vaivana qa korapa garunu lao momoeniria aipira ko pa liguna tonai mana batia ara sa na isumatana sa palu mina tavaragua batia na isumataqu ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ko ira na vaivana tai Jekopi sa qai tagarunu lao momoe, goto isa sa vajola bongi pa ia ketakoi qai suvere vaikamu sa na bongi isa. ");
INSERT INTO lga_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ego na bongina isa si Jekopi sa sa qaqiri beto sa toniria sa karu maqotana, karu ona nabulu rereko, ka manogameka tuna marene beto ko sa karovia na nyonyola pa Jaboki. ");
INSERT INTO lga_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Pa liguna sa toniria ko sa vakarovoria pa kai kalena na nyonyla poni sa sa vakarovoria mule sa doru sakasava sa isongoria. ");
INSERT INTO lga_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ego ko sa taloa vamekaina si Jekopi. Beto sa lame kai tinoni ko qai vaituaragadia sira karu tinganai ko sa sae tu na vovola rane. ");
INSERT INTO lga_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Totonai sa batia na tinoni isa sake boka vagorea si Jekopi sa, sa majai sa na vaijokele pa sisikirina isa ko sa vaisela tu sa na vaijokele pa sisikirina i Jekopi totonai qai kole vaituaragadia. ");
INSERT INTO lga_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Beto pira sau sa na tinoni, <<Mu loasiu ura sa tei sae tu sa na vovola rane,>> saunia. Poni pira sau si Jekopi, <<Maneke isongo loago tinganai ko muna mananisiu mai tu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Poni sa nanasa sa na tinoni isa, <<I sei na isongomu sao?>> saunia. Poni pira sau sisa, <<I Jekopi,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Poni pira saunia na tinoni isa, <<Kopira nake i Jekopi na isongomu sao goto i Izireli tu, ura qu rajai na Tamasa beto qu rajaria ira na tinoni ba qu kilasa kare sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Sa pira saunia i Jekopi, <<Mu ule vanisiu na isongomu,>> saunia. Poni sa nanasia i Jekopi sisa, pira saunia, <<Ai sa vei ko qu nanasania tu na isongoqu?>> sau. Beto sa sa manania tugu ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ego ko sa vakukunia Peniele i Jekopi sa na ia isa, <<ura qa batini isumataqu ara sa na isumatana i Tamasa ba sake apulia kai sa na qua toa,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ego sa sagere sae pa nulu sa na tapo totonai sa jola pa Peniele si Jekopi, ko sa rerege qiqiqe gu sisa ura sa vaisela na sisikirina. ");
INSERT INTO lga_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ko sa vei sa, kamua pa rane pa ngeni alepi ira na tinoni Izireli sa qaike gania sa na masa sa vaijokelai lao pa pupuda pa kale sisikiri ura pa masa tugu pa kale sisikirina i Jekopi sa sa tamaja. ");
INSERT INTO lga_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ego enga sae sau si Jekopi sa batia si Isoa, korapa lalamegana tavitiria ira ka madegogoto ona tinoni, ko sa pikataria sa na koburu lao tadira Lia, i Resolo beto karu nabulu rereko. ");
INSERT INTO lga_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ego ira na nabulu rereko tavitiria na tudia sa sa vakoleria pa momoe, beto sa tuti si Lia beto ira na tuna, beto ira Resolo i Josepa pa liligu. ");
INSERT INTO lga_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Beto mekana sa lao pa moedi ira ko sa titi opo gore pa peso ka vitu totoso totonai sa lao tatai na tugana. ");
INSERT INTO lga_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ba i Isoa sa abutu ko sa lao gosoria si Jekopi, sa borua beto sa titia na ruana ko sa aoa. Beto ko qai vailulukana. ");
INSERT INTO lga_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Beto poni sa doro lao si Isoa, sa batiria sira na rereko beto na koburu ko sa nanasa, <<Ira sei sa qai tutigo ao aipira?>> saunia. Poni pira sau si Jekopi, <<Ira sa na koburu na Tamasa sa vatadogoronia nona roroqu tana mua nabulu sa aipira,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Beto sa qai lame tata sira na nabulu rereko tavitiria na dia koburu ko qai titi opo gore pa peso. ");
INSERT INTO lga_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Beto sa tuti lame si Lia beto ira na tuna ko qai titi opo gore pa peso. Beto liligu qai lame sira Josepa i Resolo ko qai titi opo gore tugu vei pa peso. ");
INSERT INTO lga_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Beto sa nanasa tu si Isoa, <<Na sa laodi sa doru gogodo papausu qa gosororia pori?>> sau. Sa pira sau sisa, Dai! <<Ai vei ko mu qeranisiu ao qua bangara qau sa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Poni sa pira saunia i Isoa sisa, <<Tasiqu, ara sa tei soku tu sa na qua sakasava. Mu kopuniria ko mi mua sira vei qu isongoria,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ba pira saunia i Jekopi sisa, <<Muna qeranisiu ara ao sa, mu tekuria pa limaqu ara sira na vaivana pira. Ura tonai qa batia na isumatamu ao sa, sa vei puputa qa batia na isumatana na Tamasa, kopira vei qu vakamu vatalesiu ao. ");
INSERT INTO lga_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ko bu tekua tu sa na mana taqu sa tapogoso lame tamu, ura na Tamasa sa roroqusiu ko qa isongoria gu sa doru kai sa,>> sau. Ko sa paranga jujukia i Jekopi sisa ko sa tekua i Isoa sa na vaivana. ");
INSERT INTO lga_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Beto pira sau si Isoa, Ego! <<Vatana ko aria ta mekarai riuoda. Ara kode mana vavaburogou,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ba pira saunia i Jekopi sisa, <<Ao na qua bangara qu gigilaimua sa na koburu qai oqoqanai munyala beto ko mana dodogororia tugu vei na tuni sipi beto na tuni bulumakau qai korapa susu. Ko vei mai tatoni sasasuruniria pa kai rane poni kode doru na papausu mai mate beto. ");
INSERT INTO lga_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ko muke vei ao na qua bangara, mu riu momoemua goto ara mana mavo tugu tututiqua tutiria tugu na rijodi na gogodo papausu pa momoe pira beto na rijodi na koburu, tinganai mana kamugo pa Seia,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Poni pira sau mutugu si Isoa, <<Ego mina vei sa, ma loa vanigo ropi kaki tinoni taqu ko mai vavaburogo,>> saunia. Sa nanasa tu si Jekopi, <<Ai sa vei ko mu roiti vei mutu inara qugu?>> <<Sa pada gu sa qu tavaraguanisiu ara ao na qua bangara qau,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ego ko na rane tugu isa sa gabala ko sa riuona pa Seia si Isoa. ");
INSERT INTO lga_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Goto i Jekopi sa lao pa Sukoti ko ketakoi sa vaturua kai ona ruma beto ira na papausu sa roiti vaniria na aqaqo susuverena. Ko sa vei sa, sa tavakukunia Sukoti sa na ia isa. ");
INSERT INTO lga_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Pa liguna sa koko pa Padani Arami si Jekopi, sa kamu vatale pa gugusu lavata pa Sekemi pa Kenani sisa ko sa vaturua nona ia susuverena pa moena na gugusu lavata. ");
INSERT INTO lga_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ego ko sa vai tekunia isa kai gogoto poata siliva pa limadi ira na tuna i Hamo na tamana i Sekemi sa kai kobu peso ko ketakoi sa vaturua isa sa nona aqaqo. ");
INSERT INTO lga_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ko ketakoi sa vaturua isa sa kai ia vavakukuvuna sa vakukunia El Elohe Izireli. ");
INSERT INTO lga_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ego i Dina, na tuna rereko i Lia isa sa vapore vania i Jekopi sa, sa votu lao lelekogona tadira kaki rereko pa ia isa. ");
INSERT INTO lga_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ego sa batia i Sekemi na tuna marene i Hamo na tinoni Hivai isa na tinoni mamata pa ia isa ko sa tekua sisa ko sa puta tavitia ko sa ngangulia. ");
INSERT INTO lga_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sa vatungania na bulona i Sekemi si Dina na tuna rereko i Jekopi ko sa nyoroguania ko sa paranga valolomosia sa na rereko. ");
INSERT INTO lga_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ko sa parangia i Sekemi si Hamo na tamana, pira sau, <<Mu teku vanisiu na rereko api ko mi maqotaqu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ego totonai i Jekopi sa nongoria sa tavapaji si Dina sa, ira na tuna marene sa qai korapa suvere tavitiria na papausu pa kai ia pa peguruna tu ko sake pavu vagalania tinganai qai kamu tu ira. ");
INSERT INTO lga_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Poni i Hamo na tamana i Sekemi sa sa lao ko mi vavakato tavitia si Jekopi sau. ");
INSERT INTO lga_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ego ira na tuna marene i Jekopi sa isa tugu qai nongoronia veveina na luludi rereko sa qai mule kamu pa ruma. Qai takulanga vivitigi beto sa iku vivikereria ura kai sakasa vaivakeana jola sa sa roitinia i Sekemi pa Izireli totonai sa kole tavitia na tuna rereko i Jekopi isa na sakasa pada bike taroiti. ");
INSERT INTO lga_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ba pira tu sauniria i Hamo sira, <<Sa vatungania na bulona i Sekemi na tuqu marene ara sa na tumu rereko ao ko bu vania tu isa sisa ko bi maqotana qau. ");
INSERT INTO lga_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mu vaialava lame tamigei sagou. Na tumiu rereko sa mu vanigei agei beto na tumei rereko agei sa mu tekuria agou. ");
INSERT INTO lga_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Muna boka suvere tavitigei sagei. Na ia sa revanga gu tamugou ko mu suveria, mu lekogo laolamea beto mu teku miu isisongo pa leona,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Beto pira sau si Sekemi lao tana tamana beto ira na tugana marene i Dina, <<Vei muna tavaraguanisiu ara agou sa, na sa vei muna tepai mana vanigou. ");
INSERT INTO lga_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ai tu muna valavata veini vanisiu agou sa na vaina na rereko beto na vaivana sa ara mana vanigou gu sa isa vei muna tepanisiu. Goto mu vanisiu gu sa na rereko api ko mi maqotaqu qau,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ba ira na tuna marene i Jekopi sa qai paranga vagonai si Sekemi beto i Hamo na tamana ura qai rorove sa sa taaru vapapaji si Dina na luludi rereko. ");
INSERT INTO lga_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ko pira qariguniria, <<Meneke boka roiti vei inara sagei, meneke boka vania na lulumei tana kai tinoni sake tapobe ura kai sakasa vaivakeana tamigei sa sa vei inara. ");
INSERT INTO lga_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Goto kai memeka sakasava gu api beto mene vamalumu vanigou: vei muna vei agei ko mai tapobe beto sa doruna na marene tamugou. ");
INSERT INTO lga_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Beto sa mene vanigou agou na tumei rereko beto na tumiu rereko agou mene tekuria sagei beto mene suvere tavitigou ko tana kai tinonida gu sa gita. ");
INSERT INTO lga_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Goto vei munake nongorogei sagei ko munake tapobe sagou, poni sa mene teku mulenia sa na lulumei beto ko mene riumei,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ego na paranga tadira sa qai vavagua pa dodoro tai Hamo beto pa dodoro tai Sekemi na tuna i Hamo. ");
INSERT INTO lga_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ko na koburu marene, isa sa tadogoro valavata jolaniria ira doru pa ruma tana tamana sa, sake vera mutugu goto sa roitinia gu sa na sakasa qai pojai ira ura sa nyorogua vivitiginia isa sa na tuna rereko i Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ko i Hamo beto i Sekemi na tuna marene sa qai lao pa ia vavaikamuna pa totomena na dia gugusu ko qai parangaria sira na marene pa gugusu. ");
INSERT INTO lga_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Pira qariguniria, <<Ira na tinoni aipira sa qai baere vatalegita gita>> qarigu, <<Ko ta vasuvereria pa ia ko mai lekogo laolamea. Na ia sa lavata vatalegu ketakoi mai suvere. Na tudia rereko ira sa tana tekuria gita ko mai maqotada beto ira na tuda rereko gita sa ta vaniria ira. ");
INSERT INTO lga_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Goto kai sakasava gu beto mai malumu suvere tavitigita vei kai tinoni gu sa gita sa, doruna na marene tadagita sa mai tapobe beto vei tugu ira qarigu. ");
INSERT INTO lga_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Mina vei sa na gogodo papausu tadira, na dia isisongo beto doru gogoto mamanugu tadira sa mai tadagita beto sa pira goto api gu, ta vaegoria gu gita ko ira mai suvere tavitigita,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Poni doru na marene qai lao vaikamu pa ia vavaikamuna pa totomena na gugusu sa qai nongoria si Hamo beto i Sekemi na tuna isa, ko doru marene pa leona na gugusu lavata sa qai tapobe beto. ");
INSERT INTO lga_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Pa liguna ka ue rane, totonai sa korapa vitigiria na lida tapobedi sira doru na marene sa, ira Simioni beto i Levi karu tuna marene i Jekopi ko karu luluna i Dina sa qai tekua na dia benisi beto ko qai toga vasibororia sira pa gugusu lavata ko qai vai beto paleria sa doru marene. ");
INSERT INTO lga_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ira Hamo i Sekemi na tuna sa qai vamateniria na mea benisi beto ko qai toni votunia pa ruma tai Sekemi si Dina ko qai taloa riudia. ");
INSERT INTO lga_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ego ira na tuna marene i Jekopi sa qai lame kamuria sa na vaikamu kokobu tomate beto qai vapidiliria sa doru sakasava pa gugusu lavata ketakoi sa tavapaji sa na luludi rereko. ");
INSERT INTO lga_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Qai aru tekuria sa na dia sipi, na bulumakau, na dongiki beto doruna sakasava tadira pa leona na gugusu lavata beto pa dia ia. ");
INSERT INTO lga_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Qai pogoso riuniria sa doru na isisongo tadira beto doruna na koburu beto na rereko, vapidiliria sa doru sakasava qai kole pa ruruma. ");
INSERT INTO lga_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Poni pira sauniria i Jekopi sira Simioni beto i Levi, <<Qu vanisiu na tapata sara ura qu vaumakaresiu tadira qai suvere pa ia api, ira na tinoni Kenani beto ira na tinoni Perizai. Ara sa nake ngaoloqu ko vei mai vaikamuniria na dia tinoni vaipera ko mai rajasiu sa, mana manyao gu sara beto na tatamana taqu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ba pira tu qarigu sira karu, <<Ai vei sa jongana gu sa sa roiti veinia na tugele na lulumei?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ego pira saunia na Tamasa si Jekopi, <<Mu qaqiri ko mule sae pa Beteli ko mu suvere ketakoi, beto mu roitinia ketakoi kai ia vavakukuvuna lao tai Tamasa, isa sa votu tamu totonai qu korapa ukunia na tugamu i Isoa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ko i Jekopi sa pojaniria sira nona tamatina beto ira doru qai suvere tana, pira sau, <<Mu gona paleria sira na tamasa karovodi qu isongoria beto mu valioso mulenigou beto mu beiria na miu poko. ");
INSERT INTO lga_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Beto aria, ta sae pa Beteli, ketakoi mana vaturua ara sa kai ia vavakukuvuna lao tai Tamasa, isa sa oesiu pa qua totoso takulanga beto isa sa vavaburosiu pa rererege ketakoi qa lao ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ko qai vania i Jekopi sa doru tamasa karovodi qai isongoria beto ira na ringi qai vasulingiria pa talingidi ko i Jekopi sa koriniria pa kauruna na gou Aloni pa Sekemi. ");
INSERT INTO lga_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Totonai qai taloa riu sira na minete tai Jekopi poni sa na matagutuna na Tamasa sa goreria sira na gugugusu pa vailivutaidi ko kepore sa kame bi adu tutiria. ");
INSERT INTO lga_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ego ko i Jekopi beto doru na tinoni qai tutia sa qai kamu pa Luzi (isa pa Beteli) pa ia pa Kenani, ");
INSERT INTO lga_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ketakoi sa vaturua i Jekopi sa kai ia vavakukuvuna beto sa vakukunia na ia isa El Beteli, ura ketakoi sa sa vatadogoronia mekana na Tamasa tana totonai sa ukunia na tugana. ");
INSERT INTO lga_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ego i Debora, na rereko kopu koburu tai Ribeka sa, sa mate ko sa tagolomo pa kauru gou Aloni pa Beteli. Ko sa tavaisongonia Aloni Bakuti sa na ia isa. ");
INSERT INTO lga_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ego na Tamasa sa sa votu mule tai Jekopi pa liguna sa mule koko pa Padani Arami ko sa manania sisa. ");
INSERT INTO lga_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Beto pira saunia na Tamasa sisa, <<Na isongomu si Jekopi, ba munake takuku sogania i Jekopi sao, goto na isongomu sa mina i Izireli tu,>> sau. Ko sa vaisongonia i Izireli sa na isongona. ");
INSERT INTO lga_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Beto pira saunia mutu na Tamasa, <<Ara sa na Tamasa neqiqu jola, mu vua beto mu soku. Kai puku tinoni beto kai minete bubutu tinoni sa mina koko lame vei tamu, beto ira na babangara sa mai votu lame vei pa tinimu ao. ");
INSERT INTO lga_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Na ia qa vania na mua tite i Ebarahami beto na tamamu i Aisake sa qa vanigo mutu ao beto ira na tutimu ao vuka risa qa vaniria sa na ia api,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Beto sa iolo loai na Tamasa sisa pa ia ketakoi sa parangania. ");
INSERT INTO lga_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ego sa vaturua i Jekopi sa kai babara patu pa ia ketakoi sa parangia na Tamasa, beto sa vuva vamadini vaini vaivana beto sa vuva vamadini oela tugu vei. ");
INSERT INTO lga_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ego sa vakukunia Beteli i Jekopi sa na ia ketakoi sa parangania na Tamasa isa. ");
INSERT INTO lga_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ego beto sa qai taloa pa Beteli ko qai riu. Totonai qai korapa tu tata kamu pa Eparati, sa vivitigi gu si Resolo ba sa vatapatia na vapodo koburu. ");
INSERT INTO lga_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Beto totonai sa korapa vatapatia na vapodo koburu si Resolo sa pira sau sa na rereko sa vatekuni koburu isa, <<Muke bebenyo, qu isongia mule kai marene sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Totonai sa korapa vasaenga bebeto ura sa mate gu sisa, poni sa sa vakukunia na isongona i Beni Oni sa na koburu. Ba na tamana sa vaisongonia i Benisimani sisa. ");
INSERT INTO lga_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ko sa mate si Resolo ko sa tagolomo pa soana lao pa Eparati (isa pa Betilihema). ");
INSERT INTO lga_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ego ko sa vaturua i Jekopi sa kai babara patu pa arena na bevi isa ko na babara patu isa sa na vinagigilana na bevi tai Resolo kamua tu pa rane pa ngeni alepi. ");
INSERT INTO lga_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ego ko sa rijo riu mutu si Izireli ko sa vaturua nona aqaqo kai kalena lao pa Miqidal Edea. ");
INSERT INTO lga_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Totonai tu sa korapa suvere I Izireli pa pikata ia isa sa, I Rubeni sa tome puta tavitia si Biliha na maqotana i Izireli na tamana. Ko i Izireli sa nongoria sa vei isa. Ego ko ira ka manogarua sa na tuna marene i Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ira na tuna marene i Lia sa: I Rubeni na tuna pa moa i Jekopi, I Simioni, i Levi, i Jiuda, i Isaka beto i Zebuluni. ");
INSERT INTO lga_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ira na tuna marene i Resolo sa: Ira Josepa i Benisimani. ");
INSERT INTO lga_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ira na tuna marene i Biliha na nabulu rereko tai Resolo sa: Ira Dani i Naputali. ");
INSERT INTO lga_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ira na tuna marene i Zilipa na nabulu rereko tai Lia sa: Ira Qadi i Asa. Aipira sira na tuna marene i Jekopi qai podo pa Padani Arami. ");
INSERT INTO lga_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ego i Jekopi sa mule kamu pa gusu tai Aisake na tamana pa Mamere tata pa Kiriati Aba (isa pa Heboroni), na gusu ketakoi qai suvere vei na tinoni karovodi ira Ebarahami i Aisake. ");
INSERT INTO lga_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ego I Aisake sa suvere kamua kai gogoto vesungavuluputa aoro. ");
INSERT INTO lga_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Beto sa vasaenga bebeto ko sa mate si Aisake totonai sa baragoso vapaparoi ko sa tagolomo tavitiria ira nona tinoni sisa. Ko ira Isoa i Jekopi karu tuna marene qai vapaea sa na kokobu tinina. ");
INSERT INTO lga_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Alepi sa na vavakatona i Isoa (isa i Edomu). ");
INSERT INTO lga_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ego i Isoa sa tekuria na maqotana tadira na rereko pa Kenani: I Ada na tuna rereko i Eloni na tinoni Hitai, beto i Oholibama na tuna rereko i Ana ko na mabusu rereko tai Zibion na tinoni Hivai, ");
INSERT INTO lga_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","beto i Basemati na tuna rereko i Isimeli ko na luluna i Nebaioti. ");
INSERT INTO lga_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","I Ada sa vapodonia tai Isoa si Elipazi, i Basemati sa vapodoa i Reueli, ");
INSERT INTO lga_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","beto i Oholibama sa vapodoria sira Jeusu, i Jalami beto i Kora. Aipira sira na tuna marene i Isoa sa vaporeria pa Kenani. ");
INSERT INTO lga_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ego sa toniria i Isoa sira na maqotana, na tuna marene, na tuna rereko beto doru na tinoni qai suvere tana, vei tugu nona gogodo bulumakau beto doru ona gogodo mamanugu mamade nene beto doru sakasava sa isongoria pa Kenani, ko sa rijo lao kai ia sa nyoro sou tai Jekopi na tasina. ");
INSERT INTO lga_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Na dia isisongo sa sa soku vivitigi ko qaike boka mekarai suvere ura na ia ketakoi qai suvere sa sake padaria ura sa soku na dia gogodo papausu. ");
INSERT INTO lga_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ko i Isoa (isa i Edomu) sa riu suvere pa ia kukubona pa Seia. ");
INSERT INTO lga_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Alepi sa na vavakatona i Isoa na tamadi ira na tinoni Edomai qai suvere pa ia kukubona pa Seia. ");
INSERT INTO lga_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Aipira sa na isongodi na tuna marene i Isoa: I Elipazi isa na tuna marene i Ada na maqotana i Isoa beto i Rueli isa na tuna marene i Basemati na maqotana i Isoa. ");
INSERT INTO lga_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ira na tuna marene i Elipazi sa: Ira Temani, i Oma, i Zepo, i Qatami beto i Kenazi. ");
INSERT INTO lga_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","I Elipazi na tuna marene i Isoa ba sa isongia tu sa kai maqotana na isongona i Timina ko isa sa vapodoa si Amaleki. Aipira sa na mabusu tai Ada na maqotana i Isoa. ");
INSERT INTO lga_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ira na tuna marene i Rueli sa: Ira Nahati, i Zera, i Sama beto i Miza. Aipira sa na mabusu tai Basemati na maqotana i Isoa. ");
INSERT INTO lga_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ira na tuna marene i Oholibama na maqotana i Isoa isa na tuna rereko i Ana ko na mabusu tai Zibioni, sa vapodoniria tai Isoa sira: Jeusu, i Jalami beto i Kora. ");
INSERT INTO lga_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Aipira sira na mamata tadira na tutina i Isoa: Ira na tuna marene i Elipazi na tuna pa moa i Isoa sa, i Temani, i Oma, i Zepo, i Kenazi, ");
INSERT INTO lga_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","i Kora, i Qatami beto i Amaleki. Aipira sira na mamata qai kopuniria na tutina i Elipazi pa Edomu. Aipira sa na mabusu tai Ada. ");
INSERT INTO lga_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Aipira sira na tuna marene i Rueli na tuna marene i Isoa: i Nahati, i Zera, i Sama beto i Miza. Aipira sira na mamata qai kopuniria na tutina i Rueli pa Edomu. Aipira sa na mabusu tai Basemati na maqotana i Isoa. ");
INSERT INTO lga_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Aipira sira na tuna marene i Oholibama na maqotana i Isoa: i Jeusu, i Jalami beto i Kora. Aipira sira na mamata qai kopuniria na tutina i Oholibama na maqotana i Isoa isa na tuna rereko i Ana. ");
INSERT INTO lga_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ko aipira sira na tuna marene i Isoa (isa i Edomu) beto aipira sira na dia mamata. ");
INSERT INTO lga_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Aipira sira na tuna marene i Seia na tinoni Horai qai mamatania na pikata ia pa Edomu: i Lotani, i Sobali, i Zibioni, i Ana, ");
INSERT INTO lga_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","i Disoni, i Ezea, beto i Disani. Ira na tuna marene i Seia pa Edomu aipira sa na mamata tadira na tinoni Horai. ");
INSERT INTO lga_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ira na tuna marene i Lotani sira: Hori beto i Homami. I Timina sa na luluna rereko i Lotani. ");
INSERT INTO lga_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ira na tuna marene i Sobali sira: Alivani, i Manahati, i Ebali, i Sepo beto i Onami. ");
INSERT INTO lga_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ira na tuna marene i Zibioni sira: Aia beto i Ana. Alepi si Ana isa sa bati votunia na pie bubukala manginina pa qega totonai sa korapa vagaganiria na dongiki tai Zibioni na tamana. ");
INSERT INTO lga_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ira na koburu tai Ana sira: I Disoni sa na marene goto i Oholibama sa na rereko. ");
INSERT INTO lga_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ira na tuna marene i Disoni sira: Hemidani, i Esibani, i Itirani beto i Kerani. ");
INSERT INTO lga_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ira na tuna marene i Ezea sira: Bilihani, i Zavani beto i Akani. ");
INSERT INTO lga_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ira na tuna marene i Disani sira: Uzu beto i Arani. ");
INSERT INTO lga_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ko aipira sira na mamata tadira na tinoni Horai: i Lotani, i Sobali, i Zibioni, i Ana, ");
INSERT INTO lga_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","i Disoni, i Ezea beto i Disani. Aipira sira na mamata tadira na tinoni Horai pa okokoto dia pukuna pa ia pa Seia. ");
INSERT INTO lga_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Aipira sira na babangara qai toqo bangara pa Edomu tonai oqoro lame toqo bangara kai tinoni Izireli. ");
INSERT INTO lga_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","I Bela na tuna marene i Beo sa bangara pa Edomu. Na isongona na gugusu tana sa pa Dinihaba. ");
INSERT INTO lga_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Totonai sa mate i Bela, poni sa i Jobabi na tuna marene i Zera pa Bozira sa sa bangara na beina i Bela. ");
INSERT INTO lga_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Totonai sa mate i Jobabi sa, i Husami na tinoni pa ia tadira na tinoni Temanai sa sa bangara na beina i Jobabi. ");
INSERT INTO lga_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Totonai sa mate i Husami sa, i Hadadi na tuna marene i Bedadi, isa sa vakilasia i Midiani pa ia pa Moabi, sa sa bangara na beina i Husami. Na isongona na gugusu tana sa pa Aviti. ");
INSERT INTO lga_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Totonai sa mate i Hadadi sa, i Samala na tinoni pa Masireka sa sa bangara beina i Hadadi. ");
INSERT INTO lga_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Totonai sa mate i Samala sa, i Saulu na tinoni pa Rehoboti na gusu pa ovuku Euparati sa sa bangara beina i Samali. ");
INSERT INTO lga_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Totonai sa mate i Saulu sa, i Baal- Hanani na tuna marene i Akibo sa sa bangara beina i Saulu. ");
INSERT INTO lga_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Totonai sa mate i Baal Hanani na tuna marene i Akibo sa, i Hadadi sa sa bangara. Na isongona na gugusu tana sa pa Pau beto na isongona na maqotana si Mehetabeli na tuna rereko i Matiredi isa na tuna rereko i Me- Zahabi. ");
INSERT INTO lga_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Aipira sa na isongodi na mamata pa tutina i Isoa tuti pa dia gorena beto na pikata ia qai suvere: i Timina, i Aliva, i Jetiheti, ");
INSERT INTO lga_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","i Oholibama, i Ela, i Pinoni, ");
INSERT INTO lga_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","i Kenazi, i Temani, i Mibiza, ");
INSERT INTO lga_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","i Maqidieli beto i Irami. Aipira sira na mamata pa Edomu tuti pa dia gugusu pa ia qai suveria. Ko alepi sa na vavakatona i Isoa na tamadi ira na bubutu tinoni Edomai. ");
INSERT INTO lga_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ego i Jekopi sa sa suvere pa ia sa suveria na tamana pa ia pa Kenani. ");
INSERT INTO lga_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Alepi sa na vavakatona i Jekopi. Ego i Josepa, kai koburu sae korega ka manogavitu aorona, sa kole kopuniria na gogodo sipi tavitiria na tugana, ira na tuna marene i Biliha beto ira na tuna marene i Zilipa ira karu maqotana na tamana beto i Josepa sa pogoso mule vania na tamadi sira na nongoro ikikeredi veveidi ira na tugana. ");
INSERT INTO lga_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ego i Izireli sa sa roroqu vivitigia isa si Josepa jolaniria doru gogoto tuna marene, ura sa podo sisa totonai sa tei baragoso tu ko sa piti vania sa kai poko gojo kakala babata jonga. ");
INSERT INTO lga_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Totonai ira na tugana qai batia sa na tamadi sa roroqu vivitigia sisa jolaniria ira, poni sa qai kanai beto qaike boka paranga vabubule lao tana. ");
INSERT INTO lga_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ego sa putagitania sa kai putagita si Josepa ko totonai sa vavakato vaniria sira na tugana, poni satotonai sa qai kanai tu lalaodia sisa. ");
INSERT INTO lga_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Pira sauniria, <<Mu vainongoronia na putagita qa putagitania ara. ");
INSERT INTO lga_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ego taqe korapa kokoturia na gogou kiko pa inuma sa gita poni sa sa iolo votu sale vasiboro beto sa turu vatuvisi sae sa na gou kiko taqu beto ira na gogou kiko tamugou sa qai lame vaikamu vailivutainia sa taqu beto ko qai titi opo gore pa moena na gou kiko taqu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Poni pira qarigunia ira na tugana sisa, <<Na tinoni lavata ko muna bangaranigei agei sao? Na tinoni lalae ko muna lalaenigei agei sao?>> qarigunia. Ko qai kanai tu lalaodia ira sisa pa laena nona putagita beto na sakasava sa pojaria isa. ");
INSERT INTO lga_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ego beto sa putagitania mule kai putagita sisa ko sa ule vaniria sira na tugana. Pira sau, <<Mu vainongoro ko!>> <<Qa putagitania mule ara sa kai putagita, poni sa kopira na tapo, na popu beto ka manogameka seru sa qai titi opo gore pa moequ ara,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ego totonai sa vavakato vania na tamana beto ira na tugana, poni sa sa tokea na tamana sisa pira saunia, <<Na savana sa na putagita qu putagitania ao alepi? Ai vei? Ko ara, na tinamu beto ira ka manogameka tugamu sa mene lame sosoto tugu titi opo gore pa peso pa moemu ao?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ko qai konoa ira na tugana sisa, goto na tamana sa nongoro vakolea sa na paranga alepi. ");
INSERT INTO lga_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ego ira na tugana i Josepa sa qai tei riu tu vagaganiria na gogodo sipi tana tamadi pa Sekemu, ");
INSERT INTO lga_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","ko pira saunia i Izireli si Josepa, Tuqu, <<Qu gigilaimua sa ira na tugamu sa qai korapa riu vagaganiria na gogodo sipi pa Sekemu. Ko mei, ma garunu valaogo tadira,>> saunia. Poni pira sau sisa, <<Ego jongana,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ko pira saunia sisa, <<Mu lao dororia ai qai korapa veveigadia sira na tugamu beto ai qai korapa vevei sira na gogodo sipi beto mu mule vavakato vanisiu,>> sau sisa. Beto sa garunu variua koko pa lolomo pa Heboroni. Totonai sa kamu pa Sekemu si Josepa, ");
INSERT INTO lga_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","kai tinoni sa batia korapa vividulaiona pa ia isa sisa ko sa nanasia na tinoni isa sisa, <<Na sa qu korapa nyaqoa?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Poni pira sau si Josepa, Koi, <<Qa korapa nyaqoria na boko tugaqu. Ai vei muna boka ule vanisiu pai qai korapa vagaganiria na sipi?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Sa pira sau sa na tinoni isa, <<Koi! Qai tei taloa tu lani sa, ba qa nongororia sa mai lao pa Dotani qarigu,>> sau sisa. Ko sa tuti liguria i Josepa sira na tugana poni sa sa lao batiria pa Dotani. ");
INSERT INTO lga_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ego pa souna tu qai batinia sisa ko totonai sa oqoro lao kamuria, poni sa qai mekarai vaingodonia ko mai vamatea sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ko qai vaiparanga laolame, pira qarigu, <<Sa lamegana alepi sa na tinoni puputagita.>> ");
INSERT INTO lga_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","<<Ariagada, ta vai vamate pale beto ta kurania pa kai baongo oqili api beto pira tanagu kai manugu piruna sa gani pipiaria tanagu. Beto tana doria ai mai vevei sira na putagita tana,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Totonai sa nongoria i Rubeni sapi sa sa podekia ko bi aloa sisa pa limadi ira sau. Ko pira sau, Boko tasiqu! <<Take kobua na toa tana. ");
INSERT INTO lga_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Take vaororungu kikisua. Ta gona kurania gu pa kai baongo oqili pa qega lani, goto take kotini limada,>> sau. I Rubeni sa paranga vei inara ko mi aloa tadira sisa ko mi toni mulenia tana tamana sau. ");
INSERT INTO lga_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ko totonai sa lame kamuria na tugana si Josepa sa, qai bako ririkatia sa nona poko gojo- na poko gojo kakala babata jonga sa korapa vasaea isa, ");
INSERT INTO lga_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","beto qai tekua ko qai gona kurania pa leo baongo oqil sisa. Na baongo oqili isa sa na pidili gagapuna, kepore kolo pa leona. ");
INSERT INTO lga_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Totonai qai korapa toqo tetekudia poni, qai enga sae qarigu sa, qai batia sa kai puku minete tinoni Isimeli korapa mekarai lalamedia koko pa Qiliadi. Qai surana vapugeleni sakasa vavalingi gagani beto vavaumanga jonga- na sipaesi, na bami beto na moa- sa na dia Kameli ko mai surana goreniria pa Ijipi qarigu. ");
INSERT INTO lga_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Poni pira sauniria i Jiuda sira na tasina na tugana marene, <<Na sa tana isongoniagita vei tana vaia na tasida beto tana vapaea na orunguna? ");
INSERT INTO lga_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Aria, ko ta vavai palenia tadira na tinoni Isimeli pira goto take kotini limada ura na tasida gu beto na tinida mekada sina,>> sauniria. Poni sa qai nongoria ira na tasina na tugana sisa. ");
INSERT INTO lga_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ko totonai qai jola sira na tinoni roroiti teku poata pa Midia, poni sa qai kao votunia pa leona na baongo ogili ira na tugana si Josepa beto qai vavai palenia ka rabeteputa poata siliva tadira na tinoni Isimeli ko ira qai surana gorenia pa Ijipi si Josepa. ");
INSERT INTO lga_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Totonai sa mule kamu pa baongo oqili si Rubeni, poni satei kepore tu si Josepa pa baongo ko sa bako ririkata pale sa nona poko. ");
INSERT INTO lga_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Poni sa mule lao tadira na tasina sisa beto pira sauniria, Ei! <<Na koburu sa tei kepore tu. Pai mana lao sara kopira?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Beto sa qai tekua sa na poko gojo tai Josepa, qai kubolia kai qoti beto qai vasuvunia na orungu sa na poko gojo tana. ");
INSERT INTO lga_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Qai pogoso mulenia tana tamana sa na poko gojo kakala babata jonga beto pira qarigu, <<Api gu sa qe batia agei, Doro vatalea moko! Na poko gojo tu tana tumu marene beka sapi ba dai,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Poni sa dogoro gigalia isa ko sa pira sau, <<Na poko gojo tugu tana tuqu ara sina. Kaki manugu pirudi qai tei garata pipiara pale tu si Josepa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Poni sa bako ririkata pale nona poko si Jekopi, beto sa vasaea na baiki ruruajana beto na totoso kakasana sa lukania isa sa na tuna marene ");
INSERT INTO lga_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Poni doru tuna marene na tuna rereko sa qai lame ko mai vamanotia qarigu ba sa daionania ko bai vamanotia sisa, pira sauniria, <<Daiqua!>> <<Mana kole tugu lulukanania qua ara sa na tuqu marene tinganai mana gore kamuqua pa ia tadira na tinoni matedi,>> sau. Ko na tamana sa lukania si Josepa. ");
INSERT INTO lga_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ego ko ira na tinoni Midia sa qai vavainia pa Ijipi si Josepa lao tai Potipa pa Ijipi, kame ira na tinoni lalavata tai Pero isa na kuta tadira na tinoni kopu. ");
INSERT INTO lga_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ego pa totoso isa, i Jiuda sa sa gore koko tadira na tasina na tugana ko sa gabala lao suvere tana kai tinoni pa Adulami na isongona i Hira. ");
INSERT INTO lga_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Poni sa gosoria i Jiuda ketakoi sa kai tuna rereko i Sua kai tinoni pa Kenani. Ko sa tekua sa na rereko isa ko sa tome nagoa, ");
INSERT INTO lga_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ko sa bogata sisa ko sa vapodoa kai tuna marene ko sa vaisongonia i Ere. ");
INSERT INTO lga_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ko sa bogata ligu mule sisa ko sa vapodoa mule sa kai marene ko sa vaisongonia i Onani. ");
INSERT INTO lga_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ko sa kai bogata mutu sisa ko sa vapodoa sa kai tuna marene ko sa vaisongonia i Sela. Pa Kezibi sa vapodonia isa sisa. ");
INSERT INTO lga_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ko i Jiuda sa teku vania kai rereko si Ere na tuna pa moa Ko na nisongona na rereko isa si Tama. ");
INSERT INTO lga_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ba i Ere na tuna moa i Jiuda, sa toania na toa ikikerena pa dodogoro tai Iahova, ko sa vamate pale i Iahova sisa. ");
INSERT INTO lga_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Poni sa pira saunia i Jiuda si Onani, <<Mu lao tome nagoa na nabokona na tugamu ko mu roitinia na roiti tana marenena tana ko mu vapidoko vania na tutina na tugamu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ba sa gigilaiona i Onani sa na vuana isa sa minake tapoja na tuna isa sau, ko tonai vei sa tome nagoa na nabokona na tugana poni sa sa valua gore pale pa peso isa sa na kolona ko mike pore sa na vuana na tugana sau. ");
INSERT INTO lga_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ba sa ikerena pa dodogoro ti Iahova sa na sakasava sa roitinia isa ko isa ba sa vamate pale tugu i Iahova. ");
INSERT INTO lga_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Poni sa parangia i Jiuda si Tama na roana, pira saunia, <<Mu suvere vei mai na naboko pa ruma tana tamamu tinganai mina lavata tu i Sela na tuqu marene,>> saunia. Ura sa rorove sa isa ba, <<kita mai mate vei tugu ira karu tugana>> sau. Ego ko i Tama sa lao suvere pa ruma tana tamana. ");
INSERT INTO lga_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ego na sovaina jola beto sa mate sa na maqotana i Jiuda isa na tuna rereko i Sua. Pa liguna sa manoto ligu pa ona suvere takulanga sisa sa, mi sae tadira nona tinoni roiti qai korapa ngabuturia na vurungudi na ona sipi sau. Ko isa beto na ona baere i Hira na tinoni pa Adulami sa qai sae pa Timina. ");
INSERT INTO lga_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Ego totonai qai ule vania si Tama, pira qarigu, Ago! <<Na roamu sa sa korapa sae pa Timina ko mi ngabuturia na vurungudi nona sipi,>> sau, qarigunia, poni sa ");
INSERT INTO lga_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","sa vagore pale i Tama sa nona poko naboko, sa vapaenia na udude vapaeni isumata ko mike tagigala sau, beto sa toqo pa totomena lao pa Enaimi isa na soana lao vei pa Timina. Ura sa batia si Sela kopira sa sa tei kai marene lavata tu ba qaike vania i Sela ko bi maqotana sisa. ");
INSERT INTO lga_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ko totonai sa batia i Jiuda sisa sa, sa rove veinia kai tugele gu sisa ura sa ude vapaea sa na isumatana. ");
INSERT INTO lga_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Poni sa gabala laoa sisa pa keketai soana ko pira saunia, <<Aria! Mei ko ma tome nagogo,>> sau. Ura sake gigilai isa sa na roana gu sisa. Poni sa pira saunia na rereko, <<Na sa muna vanisiu ko muna puta tavitisiu?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Sa pira sau sisa, <<Kode mana valame vanigo kai qoti kokoregana pa qua papausu,>> saunia. Poni pira saunia mule, <<Na sa sa na kejo vakole muna vanisiu mai ao tinganai muna valamea na qoti?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Sa paranga tu sisa, pira sau, <<Na sa sa na kejo vakole mana vanigo ara?>> saunia. Sa pira sau sisa, <<Na mua papaku aeana tavitia na gasorona beto na mua kolu pa limamu ina,>> saunia. Ko sa vaniria isa sa na sakasava ira beto sa tome nagoa. Ko sa bogata tu sisa. ");
INSERT INTO lga_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Pa liguna sa taloa riu, poni sa sa vagore pale sa na udude vapaeni isumata beto sa vasae liguria sa nona poko naboko. ");
INSERT INTO lga_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Pa totoso isa sa, i Jiuda sa vapogosonia nona baere pa Adulami sa na qoti kokoregana ko mi teku muleniria sa na kejo vakole sa aru tekuria na rereko sau, ba sake batia sa na rereko. ");
INSERT INTO lga_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ko pira sauniria sira na marene qai suvere ketakoi, <<Pai sa na tugele tabuna isa sa suvere pa keketaina na soana pa Enaimi?>> sau. Poni pira qarigu sira, Koi! Kepore tugele tabuna sa lani, qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ko sa mule lao tai Jiuda ko pira saunia, Qokolo! <<Qake batia sa na rereko isa. Beto ko ira na marene qai suvere ketakoi ba qai pojai sa, kepore tugele tabuna sa ketakoi qarigu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Poni pira sau si Jiuda, <<Ego mi kopuniria gu nona ropi kita ko ta vei na dia vavaivavu vavaledena ira na tinoni. Qa garunu laonia tugu ara sa na qoti kokoregana goto ao ko quke batia gu sa na rereko,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ego papada kue popu sa jola poni sa qai vavakato vania si Jiuda, pira qarigunia, Qokolo! <<Na roamu i Tama sa sa vavatugele qarigu ko na vuana sa kopira sa bogata qarigu,>> qarigunia. Poni pira sau si Jiuda, Mu vavotua pa peguru ko mu vurungu toai pa iku, sauniria. ");
INSERT INTO lga_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Totonai qai toni votunia si Tama, poni sa sa garunu valao nongoro sa tana roana, pira saunia, <<Na tinoni sa isongoria na sakasava aipira sa sa vabogatasiu ara,>> sau. Beto pira sau mutugu, <<Ko mu lame dogoro gigalaria moko ti sei sa na papaku aeana, na gasoro beto na kolu pira,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Poni sa dogoro gigalaria gu i Jiuda sa na sakasa ira ko pira sau, <<Isa sa tuvisi jolanisiu ara sisa ura ara qake vania i Sela na tuqu marene ara ko bi marenena,>> sau. Ko sake puta taviti ligua isa si Tama. ");
INSERT INTO lga_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Totonai sa kamua nona totoso popodo sisa poni, na pata marene sa qai kole pa iapana. ");
INSERT INTO lga_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Totonai sa korapa vapopodo sisa, kame ira karu sa alaka lamenia sa na limana poni sa tekua na rereko sa vatekuni koburu ko sa pikoni loji jijimiri sa na limana beto sa pira sau, Alepi sa sa podo momoe, sau. ");
INSERT INTO lga_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ba totonai sa teku mulenia na limana sa, na tasina tu sa sa votu lame poni pira sau sa na rereko, <<Ko pira tu qu pururu votu vei sao,>> sau sisa. Ko sa tavavaisongonia i Perezi sisa. ");
INSERT INTO lga_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Beto poni, sa tuti votu sa na tugana isa sa tapikonia na loji jijimiri pa limana ko sa tavaisongonia i Zera. ");
INSERT INTO lga_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ego ko sa tatoni gore pa Ijipi si Josepa. Ko i Potipa, kai tinoni pa Ijipi isa kame ira na tinoni lalavata tai Pero ko na kutadi ira na tinoni kopu pa ruma vaipiu sa vai tekua sisa tadira na tinoni Isimeli qai toni gorenia ketakoi ko nona pinausu saunia. ");
INSERT INTO lga_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Ego I Iahova sa suvere tavitia si Josepa ko kai tinoni boboka sisa totonai sa suvere isa pa ruma tana ona iviva lavata na tinoni Ijipi. ");
INSERT INTO lga_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Totonai sa gigilai nona iviva lavata sa vei I Iahova sa suvere tavitia sisa beto i Iahova sa vabobokai pa doru sakasava sa roitiniria poni, ");
INSERT INTO lga_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","I Potipa sa qerania sisa ko sa veinia nona tinoni kopu. Sa udukia sisa ko isa mina kuta uananiria sira pa ruma tana, beto sa vakole laoa pa limana isa sa dorudi na sakasava sa isongoria. ");
INSERT INTO lga_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ko podalai pa totoso isa sa udukia isa si Josepa ko sa kuta uananiria sa na tatamana tana tinoni Ijipi alepi beto pa dorudi na sakasava sa isongoria. Ego ko sa manania i Iahova sa na tatamana tana tinoni Ijipi alepi pa laena i Josepa beto na mana tai Iahova sa sa uli pa doru sakasava sa isongoria i Potipa, pa ona tatamana beto pa ona kobu ia. ");
INSERT INTO lga_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Ko sa loa laonia pa limana i Josepa sa doru sakasava sa isongoria ko sake pavu vajujuno mulenia mekana kai sa goto isatugu na ona tetekuna gu sa tekua sa sa junonia isa. Ego i Josepa sa isongia na tini momorutuna beto na tini babata jonga, ");
INSERT INTO lga_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ko nake sovaina tugu beto na maqotana na ona iviva lavata sa kole gogonani matana si Josepa ko pira saunia, <<Aria ko ta vaikole tavitioda,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ba sa daiona si Josepa ko, pira saunia sa na maqotana nona iviva lavata, <<Doru sakasava pa ruma api,>> sa <<Na iviva lavata taqu sa sa vakole lamea pa limaqu ara ko isa sake pavu vajunonia kai sa pa ruma alepi ura ara qa kuta uananiria sira. ");
INSERT INTO lga_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ko kepore mule sa kame sa poreveveina jolanisiu ara pa ruma alepi. Beto kepore mule sa kai sa sa aru mulenia isa taqu goto isatugu ao, ura na maqotana isa sao. Ko ai vei beto mana boka roitinia ara sa na sakasa ikikerena jola vei inara beto mana roitinia na sela pa moena na Tamasa?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ego ko na vaituti rane gu sa kole tepai isa si Josepa ba i Josepa sa daiona nongoria ko sa daiona kole tavitia babi daiona suvere tavitia sisa. ");
INSERT INTO lga_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Ego kai rane i Josepa sa tome pa ruma ko mi roitiniria tugu nona roiti sau, ba totonai sa kepore sosoto sa kai tinoni roiti bi suvere pa leona na ruma ");
INSERT INTO lga_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ko sa kalo tekua sa nona titivi ko pira saunia, <<Aria ko ta vaikole tavitioda,>> sau, Ba i Josepa sa uele vakole pale pa limana isa sa nona titivi beto sa uku votuona pa peguru. ");
INSERT INTO lga_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Totonai sa batia sa uele vakolea nona titivi pa limana beto sa uku votuon pa peguru si Josepa, poni sa ");
INSERT INTO lga_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","sa kuku uuiria sira nona tinoni roiti pa ruma beto pira sauniria, <<Dotu!>> <<Na tinoni Hiburu sa kamu tadagita alepi sa sa korapa vatorasagita gita. Sa tome lame taqu ko mi kole tavitisiu ara sau ba qa kuku uuinia ara. ");
INSERT INTO lga_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Totonai sa nongoria qa uuigou ara agou, poni sa sa uele loa pale sa nona titivi pa keketaiqu ara api ko sa uku votuona pa peguru,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ko sa kopu vakoleania pa keketaina isa sa na titivi tai Josepa tinganai sa mule kamu pa ruma na marenena. ");
INSERT INTO lga_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Beto sa pojania na marenena sa na vavakato api, pira saunia, <<Na pinausu tinoni Hiburu isa qu vakamua tadagita ao ina sa sa tome taqu ko sa kole torasanisiu ara. ");
INSERT INTO lga_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ba isa tugu qa uui viviva ko qa kukuku ara sa, sa uele vakolea tugu pa keketaiqu ara sa nona titivi beto ko sa uku votuona,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ego totonai sa nongoria nona iviva lavata sa na vavakato tana maqotana totonai na maqotana pira sau, <<Pira sa roiti veinisiu ara sa na pinausu tamu ina,>> saunia poni sa sa iku vuvurungia sa na iviva. ");
INSERT INTO lga_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ko na iviva lavata tai Josepa sa aru tamania si Josepa ko sa gona laonia pa ruma vaipiu, pa ia ketakoi qai takopu ira na tinoni pareseni tana bangara. Ego ba totonai sa suvere pa leo ruma vaipiu si Josepa, ");
INSERT INTO lga_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","poni si Iahova sa suvere tavitia sisa beto sa vadogoronia nona vairoqu sisa ko sa vakanokia isa sa na bulona na tinoni kopu pa ruma vaipiu ko sa dogoro tavaraguania isa si Josepa. ");
INSERT INTO lga_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ko na tinoni kopu pa ruma vaipiu sa udukia si Josepa ko isa sa na kuta tadira doru qai tapiu qai suvere pa ruma vaipiu, beto isa tugu vei sa lalaeniria sa doru sakasava qai taroiti ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ko na tinoni kopu ba sake pavu vagalaniria sa doru sakasava qai kole pa kopu tai Josepa, ura i Iahova sa suvere tavitia sisa beto doru sakasava sa roitiniria isa sa i Iahova sa vapuraria. ");
INSERT INTO lga_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ego kaki totoso pa liguna sa vei aipira sa na tinoni popogoso kapa bubukuni vaini beto na tinoni roroiti bereti tana bangara pa Ijipi sa qai vatagigiria sa na dia iviva lavata isa na bangara pa Ijipi. ");
INSERT INTO lga_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ko sa kokoraniria i Pero sira karu nona tinoni lalavata- na kutadi ira na tinoni popogoso kapa bubukuni vaini beto na kutadi ira na tinoni roroiti bereti. ");
INSERT INTO lga_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ko sa gona tomeniria pa ruma tana kutadi ira na tinoni kopu pa ruma vaipiu, isatugu pa ruma ketakoi sa takopu i Josepa. ");
INSERT INTO lga_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ko na kutadi na tinoni kopu pa ruma vaipiu sa udukia si Josepa ko isa sa kopuniria sira karu. Pa liguna qai suvere sovai pa ruma vaipiu sa, ");
INSERT INTO lga_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","kai bongi qai okoto putagita sira karu- na tinoni popogoso kapa bubukuni vaini beto na tinoni roroiti bereti tana bangara pa Ijipi qai tapiu pa ruma vaipiu, ko okoto putagita tadira karu sa koleona tugu na okoto ruvatadi. ");
INSERT INTO lga_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Totonai sa lame ovikiria i Josepa na vuvugei sa, sa batiria qai dodoro betodia sira karu. ");
INSERT INTO lga_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Poni sa nanasaria sira karu tinoni lalavata tai Pero qai tapiu ko qai suvere tavitia isa pa ruma tana ona iviva lavata, pira sau, <<Ai vei ko pa ngeni alepi qu doro takulanga tu sao karu?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Poni pira qarigunia, <<Agei karu sa qe okoto putagita beto, ba kepotu sa kame vei bi ruvata vanigei sa na ginuadi na mei putagita,>> qarigunia. Poni pira sauniria i Josepa, <<Na ruruvata sa na Tamasa gu mekana sa boka roitinia. Ko mu pojanisiu na miu putagita,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ko na kutadi ira na tinoni popogoso kapa bubukuni vaini sa vavakato vania i Josepa sa nona putagita. Pira saunia, <<Qa putagita sara sa qa batia sa kai gogou gasoro qurepi sa turu pa moequ, ");
INSERT INTO lga_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ko pa gogou gasoro isa sa kue sa na kaena. Isa tugu qai takelai poni, sa qai aruru tugu beto qai vua ko qai matua gu sa na vuvungu qurepi. ");
INSERT INTO lga_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na kapa tai Pero sa qa arua pa limaqu ara, beto qa tekuria sa na vua qurepi ko qa monyo kuraniria na kolona pa leo kapa tai Pero beto sa qa vakolea sa na kapa pa limana i Pero,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Poni pira saunia i Josepa, <<Pira sau na ruvatana,>> sisa, <<Ka ue kaedi sa ka ue rane. ");
INSERT INTO lga_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ka ue rane gu sa kole beto i Pero mina ruvatigo sao beto mina vamule beigo pa mua roitina, ko ao muna vakolea na kapa pa limana i Pero, isatugu qu vevei perangana totonai qu popogoso vania nona kapa isa. ");
INSERT INTO lga_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ko totonai mina jojongana sa na susuvere tamu sa, munake roqu mumanisiu goto muna roroqusiu beto muna pojania tu si Pero na ginugua taqu ko muna vavotusiu pa ruma vaipiu api. ");
INSERT INTO lga_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ura ara ira na tinoni gu qai teku ragata riunisiu koko pa ia tadira na tinoni Hiburu beto nake savana lani ba qake roitinia tugu ara sa kai sa pada bai vatomesiu pa ruma vaipiu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ego totonai sa batia na kutadi ira na tinoni roroiti bereti sa vavagua sa na ruruvata tai Josepa, poni sa pira saunia si Josepa, <<Ara ba qa putagita tugu. Ko pa qua putagita sa, qai kole vaitopare pa batuqu sa ka ue topa bereti. ");
INSERT INTO lga_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ko pa leo topa isa pa arena poni sa qai kole doru kai gogoto tetekuna tunudi tai Pero, ba ira na mamanugu tatava sa qai korapa gani beto pale sa na topa tetekuna isa pa batuqu ara,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Poni pira sau si Josepa, <<Pira sau sa na ruvatana isa,>> <<Ka ue topa sa ka ue rane. ");
INSERT INTO lga_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ka ue rane gu sa kole beto i Pero sa mina ruvatigo beto mina vaborugo pa gou ko ira na mamanugu tatava mai gani beto pale na tinimu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ego na rane vina uesa na rane podo tai Pero ko sa roiti vaniria isa ira nona tinoni lalavata sa kai vavolo lavata. Beto sa ruvataria isa sira karu- na kutadi ira tinoni popogoso kapa vaini tana bangara beto na kutadi ira na tinoni roroiti bereti ko sa vatururia pa moedi ira nona tinoni lalavata. ");
INSERT INTO lga_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ko sa vaaru ligunia nona roiti popogoso kapa vaini sa na kutadi ira na tinoni popogoso kapa vaini ko sa vavakole ligu kapa vaini pa limana i Pero sisa, ");
INSERT INTO lga_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","goto na kutadi ira na tinoni roroiti bereti sa sa vaborua pa gou vei puputa tugu sa ruvata veini vania i Josepa. ");
INSERT INTO lga_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ba pa liguna isa sa na kutadi ira na tinoni popogoso kapa vaini bubukuna tana bangara sa sake isongo roroqu kamua isa si Josepa goto sa roqu muma palenia sosoto. ");
INSERT INTO lga_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ego tonai sa jola karu aoro doruna poni sa putagita si Pero sa pira sa vei: sa korapa turuona pa keketaina na ovuku pa Naili sisa, ");
INSERT INTO lga_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","poni sa qai bola votu sale koko pa ovuku sa ka vitu bulumakau momorutu babata jongadi beto na nyonyobokodi ko qai korapa gagani pa leo buburu pie. ");
INSERT INTO lga_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ego ira ka vitu goto bulumakau babatikaredi beto liliqiridi sa qai votu tuti saleria sira aipira ko qai lao turu kataparia sira na nyonyobokodi pa tutuqelena na ovuku Naili. ");
INSERT INTO lga_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Beto qai lao tu na bulumakau babatikaredi beto na liliqiridi ko qai gani beto paleria sa ka vitu bulumakau momorutu bababta jongadi beto na nyonyobokodi. Beto poni sa dorava si Pero. ");
INSERT INTO lga_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Beto sa putagita mule sisa sa pira sa vei: ka vitu batu vuiti mamaladorurudi beto jojongadi sa qai toa pa kai gogou vuiti gu. ");
INSERT INTO lga_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Pa ligudi ira sa qai votu lame sa ka vitu goto batu vuiti liliqiridi beto mamaleidi sa veiniria na gava dadanga pa sagere tapo. ");
INSERT INTO lga_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Ego ko qai lao tu ira na batu vuiti liliqiridi ko qai ponyoloria sa ka vitu batu vuiti mamaladorurudi doruna. Totonai sa dorava si Pero sa gigilai sa sa putagita gu sisa. ");
INSERT INTO lga_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ego ko sa vuvugei neqa, poni sa sa takulanga na roquna, ko sa kuku vakamuria sa doru tinoni roroiti potana beto ira na tinoni gigigalai pa Ijipi ko sa ule vaniria i Pero sa karu ona putagita ba kepotu sa kame vei bi ruvata vania sa nona putagita. ");
INSERT INTO lga_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Beto isa sa na kutadi ira na tinoni popogoso kapa vaini sa parangia si Pero, pira saunia, Koi! <<Bangara, pa ngeni alepi sa qa gigila kamua ara sa na qua sela. ");
INSERT INTO lga_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kai totoso ao Pero sa qu tagigirinigei sagei na mua nabulu ko qu vatomesiu sara beto na kutadi ira na tinoni roroiti bereti pa ruma tana kutadi ira na tinoni kopu. ");
INSERT INTO lga_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kai bongi qe okoto putagita beto sagei karu, beto okoto putagita tamigei karu sa qai koledia na ruruvatadi beto tugu. ");
INSERT INTO lga_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ego kai koburu marene Hiburu sa sa suvere tavitigei ketakoi, kai nabulu tana kutadi ira na tinoni kopu pa ruma vaipiu. Ko qe ule vania sa na mei putagita, beto sa okoto ruvata vanigei, sa na ruvatadi na mei putagita. ");
INSERT INTO lga_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ko isatugu vei sa ruvata vanigei isa sa qai gore votu beto tugu. Ara sa sa vatoqo ligusiu pa qua roitina goto isa kame sa qai vaborua,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Poni sa vaigarunu si Pero ko mai sisiqarai riu tekua pa ruma vaipiu si Josepa sau. Ko pa liguna sa resa beto sa bei poko poni sa sa kamu turu pa moena i Pero. ");
INSERT INTO lga_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Poni i Pero sa parangia si Josepa, pira sau, <<Kai putagita sa qa putagitania ara ba kepotu sa kame bi ruvatia sa na putagita taqu. Ba ara qa nongoronigo sao sa tonai qu nongoria sa na putagita sa qu boka ruvatia,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Sa oea i Josepa si Pero, pira saunia, <<Nake ara sa.>> <<Na Tamasa tu mina oea na mua nyorogua sao Pero,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Beto sa pira saunia i Pero si Josepa, <<Pa qua putagita sa, qa korapa turuqua pa tutuqelena na ovuku pa Naili sara, ");
INSERT INTO lga_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","poni qai votu sale ka vitu bulumakau nyonyobokodi beto momorutu babata jongadi ko qai korapa ngoja pa buburu pie. ");
INSERT INTO lga_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Pa ligudi ira sa qai votu tuti saleria ira sa ka vitu bulumakau na mamaleidi beto qai batikare jola beto qai liqiri betodia. Qa oqoro tugu batiria ara sira na bulumakau babatikaredi vevei inara pa doru eqa pa ijipi ");
INSERT INTO lga_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Beto qai lao tu ka vitu bulumakau liliqiri batikaredi ko qai gani beto paleria sa ka vitu bulumakau nyonyobokodi qai votu sale momoe. ");
INSERT INTO lga_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ba pa liguna qai tei gani ponyoloria tu pa iapadi ba sake tadogoro pikata sa vei bai tei ponyolo gorenia tu pa iapadi, na dorodi sa korapa tugu batikare qai vei perangana. Beto sa qa dorava sara.>> ");
INSERT INTO lga_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","<<Ego beto qa batia mule pa qua putagita vinarua sa api, Qa batiria sa ka vitu batu vuiti mamaladorurudi beto na jojongadi sa qai toa votu sae pa kai gogouna gu. ");
INSERT INTO lga_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ego beto sa qai takelai votu tuti liguria mutu sa ka vitu batu vuiti mamaleidi, liliqiridi beto matedi sa veiniria na gava dadanga pa sagere tapo. ");
INSERT INTO lga_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Ira na batu vuiti liliqiridi pira sa qai poko amuria sa ka vitu batu vuiti jojongadi inara. Qa pojaniria sira na tinoni roroiti potana ba kepotu sa kame vei bi ruvata vanisiu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Poni sa pira saunia i Josepa si Pero, Ego! <<Na putagita tao Pero sa kame gu beto vaitoto gu. Na Tamasa sa vadogoronigo sa na sa tata mina roitinia isa sau. ");
INSERT INTO lga_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Ka vitu bulumakau jojongadi sa ka vitu aoro sira, beto ka vitu batu vuiti jojongadi ba ka vitu aoro tugu sira ko kame gu beto vaitoto tugu sa karu putagita inara. ");
INSERT INTO lga_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ka vitu bulumakau liliqiridi beto babatikaredi qai votu tuti saleria sa ka vitu aoro sira beto ka vitu batu vuiti ikikeredi sa vamateria na gava dadanga pa sagere tapo sa ka vitu aoro tugu sira. Ko ka vitu aoro songe sira.>> ");
INSERT INTO lga_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","<<Ko isatugu vei qa tei pojanigo tu ara ao Pero perangana sa na Tamasa sa vadogoronigo sa na sakasa mi roitinia sau. ");
INSERT INTO lga_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ka vitu aoro totoso masuru sa sa korapa lame pa doruna ia pa Ijipi, ");
INSERT INTO lga_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ba ka vitu aoro tana totoso songe sa mina tuti lameria. Ko doru na masurudi na gagani pa Ijipi sa kode mai taroqu muma pale, beto na songe sa mina piaria na ia. ");
INSERT INTO lga_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ko na masuruna na gagani sa minake taroroqu ura na songe isa mina tuti lame sa mina neqi jola sosoto. ");
INSERT INTO lga_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ko na ginuana vei beto na putagita tao Pero sa votu karu totoso sa ura na Tamasa sa tei vatoqoa tu sa na totoso mina raja ko nake sovaina gu beto mina vagore votua sisa.>> ");
INSERT INTO lga_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","<<Ko sa vei sa, kopira tugu sa ao sa mu doria sa kai tinoni sa boka rorove beto na tinoni tatavagigalana ko mu vania na neqi ko mina kuta uanania sa na ia pa Ijipi. ");
INSERT INTO lga_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ao Pero mu udukuria sira na tinoni mamata ko mai mamataniria na ia ko ira sa mai tekua sa kame pa lima pa dorudi na ababu pa Ijipi pana ka vitu aoro masuru. ");
INSERT INTO lga_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ira sa mai boko vaikamuniria sa doru na gagani pa aoro jongana qai lame aipira beto na neqi muna vaniria ao sa, mai boko vaikamuniria sa na vuiti ko mai kopuniria pa ruma vavakoleni gagani pa doru gugusu lavata. ");
INSERT INTO lga_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ko na gagani aipira sa mai tavakole kale vananama vaniria na tinoni ko mai tekuria pana ka vitu aoro songe mina kamua pa ia pa Ijipi ko na songe mike nganguluria ira na tinoni,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Poni sa rove vajonganaia i Pero beto ira doru tinoni lalavata tana sa na rorove tai Josepa. ");
INSERT INTO lga_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ko sa nanasaria i Pero sira nona tinoni lavata, pira sau, <<Ai vei tana boka batia tu gita sa kai tinoni sa vevei na tinoni api, isa sa kolea na gagalana na Tamasa?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Beto pira saunia i Pero si Josepa, <<Na Tamasa sa vabatinigo ao sa doruna na sakasava aipira ko kepore mule sa kai tinoni rorove beto tatavagigalana vevei ao. ");
INSERT INTO lga_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ao gu sa muna kuta uanania sa na ruma taqu, beto na parangamu ao sa mai tuti vaiketia sira doru tinoni taqu. Goto isa tugu na totoqona binangara sa, ara qa ululu jolanigo sao,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Beto pira saunia i Pero si Josepa, Vainongoro! <<Qa udukigo ara sao ko muna kuta uanania ao sa na ia doruna pa Ijipi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Beto sa unusu vagorea i Pero sa na ringi sa kolea na vinagigila vinaruana na bangara pa kakarusu limana ko sa vasolapania pa kakarusu limana i Josepa. Beto sa vasaenia na poko gojo kokoregana beto sa vapakunia kai papaku qolo pa ruana. ");
INSERT INTO lga_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Beto sa vakoi lekogia sisa pa totopili tana tinoni vinarua pa nona binangara beto ko qai kukuku pa moena isa sira na tinoni, pira qarigu, <<Kokotungu gore beto,>> qarigu. Ko sa vakuta uanania isa sa na ia doruna pa Ijipi. ");
INSERT INTO lga_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Beto pira saunia i Pero si Josepa, <<Ara si Pero, ba pa vinamalumu gu tamu sa mai boka ovulia na limadi beto mai vakanokia na nenedi sira na tinoni pa leona na ia pa Ijipi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Beto sa vaisongonia i Zapenati Panea si Josepa beto ko sa vania ko na maqotana isa si Asenati na tuna rereko i Potipera isa na iama pa Oni. Ko sa lekogo ovikiria i Josepa sira na ia pa Ijipi. ");
INSERT INTO lga_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ka uengavuluputa aorona si Josepa totonai sa podalai roiti sisa tai Pero na bangara pa Ijipi. Ko sa koko tai Pero si Josepa ko sa lekogia isa sa doru na ia pa Ijipi. ");
INSERT INTO lga_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ko na peso sa masuru vatatale pa leona ka vitu aoro totoso masuru. ");
INSERT INTO lga_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Sa boko vaikamuniria i Josepa sira na gagani qai vua pa leona ka vitu aoro totoso masuru pa ia pa Ijipi ko sa vakoleniria pa gugusu lalavata. Na gagani qai tavakole kale pa okokoto gugusu lavata ira sa qai tateku tugu pa ia qai kole pa vailivutaina na gugusu isa. ");
INSERT INTO lga_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ko sa boko vavaikamuniria i Josepa sa na kiko vei tu na nagasa pa poanana tinganai sa jola vivitigi ko sa nogoto tu kuti vagoreria isa ura sa jola sosoto pa pada. ");
INSERT INTO lga_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Totonai sa oqoro raja na songe, poni sa karu marene sa i Josepa sa vaporeniria tai Asenati na tuna rereko i Potipera isa na iama pa Oni. ");
INSERT INTO lga_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","I Josepa sa vaisongonia i Manase sa isa pa moa ura pira sau, <<I Tamasa sa varoqumuma palenisiu pa doru na qua tapata beto ira doru na tatamana tana tamaqu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Na vinarua marene sa sa vaisongonia i Eparemi ura pira sau, <<Na Tamasa sa vavuasiu pa ia ketakoi qa gosoro tapata,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ego ko sa lame okoto sira ka vitu aoro totoso masuru pa Ijipi, ");
INSERT INTO lga_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","beto ko sa podalai gu sa ka vitu aoro totoso songe, vei puputa tugu sa pojai i Josepa. Ko doru ia sa sa raja sa na songe ba pa ia doruna pa Ijipi sa kole gu sa na gagani. ");
INSERT INTO lga_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ba totonai qai podalai burana mamate sira na tinoni pa Ijipi, poni sa qai lukana uui lao tai Pero tepagadia gagani. Poni sa garunuria i Pero sira doru tinoni pa Ijipi, pira sauniria, <<Mu lao tai Josepa ko isa mina ule vanigou na sa muna roitinia,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Totonai sa uli kamuria na songe sa na gugugusu doruna pa vailivutaina, poni sa sa revangaria i Josepa sa doru ruma vavakoleni gagani beto ko sa vavainiria tadira na tinoni pa Ijipi sa na vuiti, ura sa neqi viva sa na songe sa raja pa ia pa Ijipi. ");
INSERT INTO lga_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ko ira doru tinoni sa qai lame pa Ijipi ko mai vai vuiti tai Josepa qarigu, ura sa neqi viva sa na songe pa doruna ia. ");
INSERT INTO lga_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ego totonai sa gigilai i Jekopi sa na kiko sa sa kole pa Ijipi poni, sa pira sauniria sira na tuna marene, <<Ai sa vei ko qu kole gu toqo vaidoke tari lana?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Beto sauniria mule, <<Qa nongoria sa na kiko sa kole pa Ijipi qarigu. Ko mu gore vai vanigita kaki kiko ketakoi, ko ta toania ko take mate,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Poni sa ira ka manogaputa tugana i Josepa sa qai gore ko mai vai kiko pa Ijipi qarigu. ");
INSERT INTO lga_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ba i Jekopi sake vatutiniria ira si Benisimani isa na tasina i Josepa ura kita vei ko mi gosoro tapata sau. ");
INSERT INTO lga_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ko ira na tuna marene i Izireli sa qai somana tutiiria sira kaki goto tinoni qai gore vai kiko pa Ijipi ura pa ia pa Kenani ba sa raja tugu sa na songe. ");
INSERT INTO lga_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ego i Josepa sa na tinoni mamata pa ia pa Ijipi, ko isa sa vavainiria tadira doru na tinoni pa ia sa na kiko. Ko totonai qai kamu pa Ijipi sira na tugana i Josepa, poni saqai lao titi opo gore pa peso pa moena isa. ");
INSERT INTO lga_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Isa tugu sa batiria na tugana si Josepa sa, sa gigalariaona ba sa roiti vei kai tinoni karovona sisa ko sa paranga sasasururia, pira sau, <<Pai qu koko lame vei sagou?>> sauniria. Poni pira qarigu sira, Koi! <<Agei na koko lame vei mei pa ia pa Kenani,>> <<Ko me vai kiko qeu,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","I Josepa sa gigalariaona sa na tugana goto ira sa qaike gigalia sisa. ");
INSERT INTO lga_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Beto isa sa sa roroqu kamua i Josepa sira nona putagita veveidi ira na tugana ko pira sauniria, <<Na tinoni qu tome golomo sagou. Mu tome ko mu doro poaria gu ketakoi mina boka pururu tome vei na kana qugu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Poni qai oea sisa, pira qarigu, Koi <<Dai! mei tinoni lavata.>> <<Agei na mua nabulu aipira sa qe kamu ko me vai kiko gu qeu sa. ");
INSERT INTO lga_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Agei doru pira sa na tuna marene beto gu kai tinoni. Na sosotona sa qe pojanigo api ko nake tinoni me lame tome golomo doro poai na miu ia qeu,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ba pira sauniria mutugu sira, <<Dai!>> <<Qu seke. Qu lame ko mu batia ketakoi mina boka pururu tome vei na kana qugu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ba pira qarigu mutugu sira, <<Agei na mua nabulu aipira sa ka manogarua tamatasi na tuna marene beto gu kai tinoni sa suvere pa Kenani. Isa pa ligu bebeto sa sa korapa suvere tana tamamei goto kame sa tei kepore tu,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Sa pira sauniria i Josepa sira, <<Isa tugu vei qa tei pojanigou tu ara. Na tinoni qu tome golomo tugu sagou. ");
INSERT INTO lga_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ba jongana, pira mana podeke veinigou ara sagou: Pa isongona i Pero na bangara toana sa, munake isongo taloa lani sagou tinganai mina kamu tu lani sa na tasimiu pa ligu. ");
INSERT INTO lga_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ko mu garunia sa kame agou ko mi riu toni vakamua sa na tasimiu goto agou doru mule sa muna takopu pa ruma vaipiu ko ta doria vei sosoto tugu sa na paranga qu pojaria ba dai, sauniria. Vei munake vei sa pa isongona i Pero na bangara toana sa, na tinoni qu tome golomo tugu sagou.>> ");
INSERT INTO lga_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Beto ko sa vatomeria pa ruma vaipiu ka ue rane. ");
INSERT INTO lga_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Pa vinaue rane poni sa pira sauniria i Josepa sira, Jongana, <<Mu roitinia gu agou sa na sakasava ma pojanigou ara api qau ko mu toa ura ara ba qa matagutunia na Tamasa. ");
INSERT INTO lga_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Vei mina tinoni tarangemiu sosoto sagou sa kame agou sa mina suvere jola pa ruma vaipiu goto agou doru mule sa mu pogoso muleniria na kiko pa miu gusu tadira na miu tatamana qai korapa burana vaivasevi. ");
INSERT INTO lga_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ba muna isongo toni kamunia taqu sa na tasimiu pa ligu bebeto soni vei tu sa na sosotona tugu sa na miu vavakato managu sara beto vei tu sa munake tavamate,>> sauniria. Poni qai vaegoa gu ira sa na sakasava sa pojaniria isa. ");
INSERT INTO lga_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Beto qai kole vaipaparanga mekadi sira ka manogaputa tamatasi, pira qarigu, <<Inana sa, taqe tekua na vinakilasa sa gita pa laena na tasida. Taqe batioda sa ai sa vitigi veinia isa sa na tapata taqe roiti laonia gita tana totonai sa tepa vivitigi gita ko take vaia sau, ba taqeke vainongoro ko sa vei sa taqe gosoronia na tapata gita sa na ginugua isa,>> qarigu mekadi. ");
INSERT INTO lga_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Poni sa oeria i Rubeni sira, pira sauniria, <<Qa pojanigou tugu sara boko tasiqu, pira qaunigou, muke kotia na koburu qaunigou. Ba agou quke vainongoro. Ko kopira sa tana isongo laea tugu gita sa na orunguna isa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Qaike gigilai ira sa i Josepa sa sa korapa nonongoriaona sa na sa qai korapa pojai ira ura isa sa kai goto tinoni tu sa sa ruruvata vakarovo vania. ");
INSERT INTO lga_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ko sa rijo vasou tadira ko sa podalai lukana, beto sa gabala muleria ko sa parangaria. Beto sa tekua si Simioni ko sa piua pa moedi ira. ");
INSERT INTO lga_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ego beto sa vaigarunu si Josepa ko qai vapugeleni kiko sa na baiki tadira, qai kura muleniria pa leo baiki sa na dia poata siliva beto qai vatana vaniria na besa pa dia rerege mule. Pa liguna sa roiti veiniria isa inara, ");
INSERT INTO lga_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","poni sa qai vamakeleria pa dia dongiki sa na dia kiko beto ko qai taloa riu. ");
INSERT INTO lga_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Pa kai ia ketakoi qai vajola bongi, poni sa kame ira sa sa revangia nona baiki ko mi vagagania nona dongiki sau sa, sa batia sa nona poata siliva pa mangana nona baiki. ");
INSERT INTO lga_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ko pira sauniria sira na tugana na tasina, Koi! <<Sa tavamule sa na poata siliva taqu.>> Dotu! <<Pa leo qua baiki api,>> sauniria. Poni sa tadungana na bulodi ko qai matagutu neneqere ko pira qarigu, <<Na sa pu vei pira ko na Tamasa sa roiti veinigita tu pira?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Totonai qai mule kamu tai Jekopi na tamadi pa ia pa Kenani sa, qai vavakato vania sa doru sakasaa sa taroiti tadira. Pira qarigu, ");
INSERT INTO lga_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","<<Na tinoni isa sa bangarania na ia isa sa sa paranga sasasurugei beto sa roiti veinigei tu kale agei qe korapa lao tome golomo doro poai na dia ia sau. ");
INSERT INTO lga_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ba pira qeunia, Na sosotona sa agei nake tinoni qe korapa tome golomo pa ia tamugou. ");
INSERT INTO lga_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ka manogarua tamatasi sagei na tuna beto gu kai tinoni. Kame sa tei kepore tu goto isa pa ligu bebeto sa sa korapa suvere tana tamamei pa ia pa Kenani qeunia,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","<<Beto pira saunigei sa na tinoni sa bangarania na ia isa, <Ego pa soana vei api sa mana gigilai ara sa na tinoni tarangemiu sagou: Kai tasimiu sa muna loai taqu goto agou doru sa mu pogoso mule vaniria na gagani na miu tatamana qai korapa burana vaivasevi. ");
INSERT INTO lga_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ba muna tonia lame taqu sa na tasimiu pa ligu bebeto ko mana vasosotoa ara sa na tinoni tarangemiu sosoto tugu sagou beto nake tinoni sa tome golomo doro poai na ia. Poni mana ruvata vamule vanigou sa na tasimiu, beto muna boka rijo lao lame pa ia lani sau>,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Totonai qai kole vuvaniria na dia baiki sa, korapa kura koledia pa okoto dia baiki sa na kukurani poata sa kolea na siliva. Ko totonai qai batia ira beto na tamadi sa na kukurani siliva, poni sa qai matagutu. ");
INSERT INTO lga_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Poni sa parangaria i Jekopi na tamadi sira, pira sau, <<Qu tei teku beto paleniria tu sira na tuqu. I Josepa sa tei kepore tu, i Simioni sa tei kepore tu ko kopira mu tekua mutu si Benisimani qugu. Doru tapata sa qai raja gu taqu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Poni sa parangia na tamana si Rubeni, pira sau, <<Vei maneke toni mulenia tamu sa na koburu sa muna boka vairia gu sa karu tuqu marene ara inara. Mu vakolea pa limaqu ara sisa beto kode ara mana toni mulenia tamu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ba pira tu sau si Jekopi, <<Na tuqu sa minake gore tavitigou ura na tugana ba sa tei mate tu ko mekana gu isa kopira sa suvere. Ko vei mina gosoro kalea kaki tapata pa soana totonai qu korapa gore sa, na takulanga gu sa kode muna vagorenisiu pa leo pou ara sagou,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ego na songe sa sa korapa neqi pa doruna na ia. ");
INSERT INTO lga_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Totonai qai teku vabetoria sa doru na kiko qai tekuria pa Ijipi, sa pira sauniria na tamadi sira, <<Mu mule gore ko mu vai vanigita mule ka visa tetekuna,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ba sa parangia tu i Jiuda sisa, pira sau, <<Na tinoni isa sa paranga vaneneqi gei sagei, Pira saunigei, <Vei munake tonia sa na tasimiu sa munake batia na isumataqu ara sagou>. ");
INSERT INTO lga_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ko vei muna garunu vatutinigei sa na tasimei sa, mene gore vai vanigo sa na tetekuna. ");
INSERT INTO lga_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Goto vei munake garunu vatutinigei sisa, meneke gore ura na tinoni isa sa pira saunigei, <vei minake tutigou sa na tasimiu sa muneke bati ligua na isumataqu saunigei>,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Poni sa nanasa si Izireli, pira sau, Ai sa vei ko qu ule vania tu sa na tinoni isa koleona kai tasimei qugunia ko qu vanisiu na tapata sara? sau. ");
INSERT INTO lga_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Poni qai oea ira sisa, pira qarigu, <<Na tinoni isa sa nanasa vivitiginia sa na veveimei agei beto na mei tatamana. Pira sau, <Na tamamiu sa korapa toaona?> <Koleona mule kai tasimiu?> saunigei. Ko agei qe oeria gu sa na sa sa nanasanigei isa. Ai vei mene gigilai agei sa isa kode pira minagu, <Muna toni lagerenia na tasimiu minagunigei>,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Beto sa pira saunia i Jiuda si Izireli na tamana, <<Mu garunu vatutinisiu ara sa na koburu ko agei me qaqiri ko me riu kopira, ko agei beto ao beto ira na tuda ta toa ko take mate. ");
INSERT INTO lga_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ara mekaqu mana tapogosonia beto ao muna boka jutunisiu gu sa na toa tana koburu. Ko vei maneke toni mulenia tamu beto munake batia lani pa moemu sa, ara mana tajutunia sisa pa moemu ao kamua na kamua. ");
INSERT INTO lga_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ko inara gu sa vei, goto vei beke vavabongi agei sa, be tei boka riu tu kopira beto ko be tei rua vidulu tu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Poni sa pira sauniria i Izireli na tamadi sira, <<Ego vei mina vei tugu isa sa, pira mu roiti vei: Mu kuraniria pa baiki sa kaki vuvua pa mumuqu beto mu pogoso gore vania na tinoni isa, na juki miu vaivana tana sa- iapeki oela beto iapeki muji, kaki oela umumanga jonga beto na moa, kaki vua ngari beto na alimoni. ");
INSERT INTO lga_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mu tamo ruai sa na poata siliva qu aruria perangana ura na poata siliva qai kole pa mangana na miu baiki sa muna kaqama muleniria pa limamiu. Palu qai kura kaleniria gu sinara. ");
INSERT INTO lga_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Beto mu tonia sa na tasimiu inana ko mu qairi ko mu mule gore tana tinoni isa. ");
INSERT INTO lga_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Beto na Tamasa neqina jola mi vanigou na jongana totonai muna turu pa moena na tinoni isa ko mina vamalumu vanigou ko mai tuti mulegou sa na tugamiu i Simioni beto na tasimiu i Benisimani. Goto ara sa, vei maneke isongoria sa, maneke isongoria tugu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ko qai teku pogosoria ira na tuna sa na vaivana beto na poata siliva tamo rua beto qai tonia si Benisimani ko qai qaqiri ko qai gore pa Ijipi ko qai lao turu pa moena i Josepa. ");
INSERT INTO lga_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Totonai sa batia i Josepa si Benisimani sa kamu tavitiria ira sa, sa pira saunia sa na tinoni kopu pa nona ruma, <<Mu toni laoniria na tinoni pira pa ruma beto mu kubolia kai papausu ko mu vatanai na tetekuna ura kode korapa rane mai teteku tavitisiu ara sira na tinoni aipira,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ko na tinoni kopu sa roitinia sisa vei sa pojania i Josepa ko sa toni laoniria pa ruma tai Josepa sa na tinoni aipira. ");
INSERT INTO lga_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ego qai matagutu sira na tinoni aipira totonai qai toni laoniria pa ruma tai Josepa. Ko pira qarigu, <<Isatugu pa laena na poata siliva qai kole pa leo oda baiki pa totoso momoe sa qai teku lamenigita lani. Ko sa nyorogua rapatagita beto vakilasagita beto mi tekunigita nona pinausu beto mi tekuria na oda dongiki sau basava,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ko qai lao kamua sa na tinoni kopu tai Josepa ko qai parangia pa totomena na ruma tana. ");
INSERT INTO lga_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Pira qarigunia, <<Koi iviva,>> be parangigo mai. <<Pa totoso momoe sa qe lagere vai kiko lani sagei. ");
INSERT INTO lga_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ba kai ia ketakoi qe puta, poni sa qe ruvataria na mei baiki qeu sa, agei doru sa qe okoto batiria pa mangana na mei baiki sa na mei poata siliva isa qe vavainiria. Ko qe pogoso muleniria pa limamei aipira. ");
INSERT INTO lga_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Na poata siliva mene vai liguni kiko sa qe posoria pa limamei aipira. Qeke gigilai i sei sa vakoleria sa na poata siliva pa leodi na mei baiki,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Poni sa pira sauniria, <<Koi jongana gu sina.>> <<Muke matagutu. Na miu Tamasa, na Tamasa tadira na tamamiu sa vakoleria pa leo baiki tamugou sa na poata inara, goto ara na poata siliva tamugou sa qa tekuria tu,>> sau. Beto ko sa vavotu vaniria si Simioni. ");
INSERT INTO lga_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Sa toni tomeniria na tinoni kopu pa leona na ruma tai Josepa sira na tinoni pira, sa vatana vaniria na pie ketakoi mai loqaria na nenedi beto sa vaniria na gagani sa na dongiki tadira. ");
INSERT INTO lga_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Qai vatanai sa na dia vaivana verania mina kamu i Josepa na korapa rane ura qai tei nongoronia tu sa kode mai teteku tavitia isa sira pa nona ruma qarigu. ");
INSERT INTO lga_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Totonai sa kamu pa ruma si Josepa sa, qai valaoa sa na dia vaivana qai pogoso tomeniria pa ruma beto qai titi opo gore pa peso pa moena isa. ");
INSERT INTO lga_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Sa nanasaria ai qai veveigadia, beto poni sa pira sauniria, <<Ai sa korapa veveigana sa na tamamiu babaragoso qu vavakato vanisiu? Ai vei sa korapa toaona?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Poni qai oe lao sira, pira qarigu, <<Na mua nabulu na tamamei sa sa korapa toaona beto sa korapa suvere vataleona gu,>> qarigunia. Beto ko qai titi opo gore ko qai valavatia. ");
INSERT INTO lga_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Totonai sa dogoro laolame ko sa batia si Benisimani na tasina isa kai tinadi gu ira karu poni sa sa nanasa, <<Isa na tasimiu pa ligu bebeto qu pojanisiu sapi?>> sauniria. Beto pira saunia, <<Na Tamasa mi mananigo tuqu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Beto sa koi vei kanoko na bulona si Josepa totonai sa batia na tasina ko, sa sisiqarai votu nyaqoa kai eqa ko mi lukana sau. Ko sa tome pa ona lose mekana ko sa lukana ketakoi. ");
INSERT INTO lga_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Pa liguna sa puqa vapidilia sa na isumatana sa sa votu lame beto sa kole aru tamana mulenia mekana sa sa paranga, pira sau, <<Mu iai na tetekuna,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Ko qai ia vania na tetekuna sisa mekana kai ia, ira na boko tamatasi sa kai ia qai toqo mekadi, beto ira na tinoni Ijipi qai teteku tavitia isa sa kai ia qai toqo mekadi, ura ira na tinoni Ijipi sa qaike boka teteku tavitiria sira na tinoni Hiburu ura na ikerena jola tadira na tinoni Ijipi sa sa vei isa. ");
INSERT INTO lga_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Beto ira na tugana na tasina sa qai vatoqoniria pa moena isa tuti pa aorodi podalai pa moa ko sa kamu tana isa pa ligu ko qai okoto vaidogoro lao lame mekadi beto qai gabara. ");
INSERT INTO lga_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Totonai qai taiania sa na tetekuna sa tavatana pa tevolo tai Josepa sa, na iana i Benisimani sa ka lima totoso sa mota jola jolaniria ira doru qai teteku. Ko qai teteku beto buku qeqera tavitia isa sira. ");
INSERT INTO lga_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ego i Josepa sa garunia sa na tinoni kopu pa nona ruma, pira saunia, <<Mu vapugeleniria na tetekuna sa na baiki tadira na tinoni inara isa vei mai boka pogosia, beto na dia poata siliva sa mu okoto kura muleniria tugu vei pa dia leo manga baiki. ");
INSERT INTO lga_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Beto sa, mu kurania sa na kapa taqu isa na kapa siliva ina pa leo manga baiki tana tinoni isa pa ligu bebeto, vei tugu nona poata siliva sa vainia na kiko,>> sau. Poni sa roitinia tugu isa sa na manugu sa garununia i Josepa. ");
INSERT INTO lga_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Totonai sa kabere vuvugei, poni sa qai loa variuria tavitiria na dia dongiki sira na tinoni ira. ");
INSERT INTO lga_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ego qai votu loai ira sa na gugusu lavata ba totonai qai oqoro taloa vasou sa, pira saunia i Josepa sa na ona tinoni kopu, <<Qaqiri ko kopira tugu mu adu tutiria sa na tinoni pori, beto totonai muna kamuria sa pira munaguniria, <Ai sa vei ko qu beinia tu na ikerena sa na jongana? ");
INSERT INTO lga_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ko isa tugu na kapa sa bubukunia na tinoni lavata taqu beto sa dodogoro votuniria na sakasava golomodi sisa. Na roiti ikikerena sa qu roitinia agou inara munaguniria>,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ko totonai sa riu kamuria, poni sa sa pojaniria tugu sa na paranga tai Josepa aipira. ");
INSERT INTO lga_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ba pira qarigu tu sira, <<Ai sa vei ko sa paranga vei tu inara sa na tinoni lavata? Bi maragovi tu mene roitinia agei na mua nabulu sa na sakasava vevei inara. ");
INSERT INTO lga_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Na poata siliva tu qe batiria pa leo mei manga baiki ba qe pogoso mule vanigo tu ao koko pa ia pa Kenani tu Ko ai vei beto mene boka iko siliva babi na qolo mutu pa ruma tana tinoni lavata tamu? ");
INSERT INTO lga_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ba vei kame agei na mua nabulu sa bi tapoa sa tekua sa, mina mate tugu sisa beto agei doru mule sa mene ona pinausu gu na tinoni lavata,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Poni pira sau sisa, <<Ego jongana ropi, kopira ta roiti vei isa qu pojai agou. Isa na tinoni sa tapoa sa tekua sa mina pinausu taqu goto agou doru sa munake tajutunia sa na tapata isa,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ko qai okoto sisiqarai vagorea pa peso sa na dia baiki beto qai okoto ruvata revangaria sa na dia baiki. ");
INSERT INTO lga_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Beto sa podalai nyaqo sa na tinoni kopu podalai tana isa pa moa ko sa kamu tana isa pa ligu bebeto, poni sa sa tabata pa leo baiki tai Benisimani sa na kapa. ");
INSERT INTO lga_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Poni qai ririkataria sa na dia poko beto qai okoto susurana pa dia kameli sa na dia sakasava ko qai mule pa gugusu lavata. ");
INSERT INTO lga_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ego i Jiuda beto ira na tugana beto na tasina sa qai tome pa ruma ti Josepa ko i Josepa sa korapa tugu ketakoi ko qai gona oponiria pa peso pa moena isa. ");
INSERT INTO lga_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Poni sa pira sauniria i Josepa, <<Na sa sa qu roitinia agou? Quke gigilai agou sa na tinoni vevei ara api sa mana boka dogoro votuniria gu sa na sakasava golomodi?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Poni pira sau si Jiuda, <<Na sa mule menegu agei tana qua tinoni lavata?>> <<Na sa mene boka pojai agei? Na sa mule mene roitinia ko mene boka talegasamei sagei? Ko kopira na Tamasa sa poai sa na sela tamigei. Ko kopira sa agei sa na pinausu gu tamu ao na qua tinoni lavata- agei doru tavitia tugu isa na tinoni sa tapoa sa tekua na kapa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ba pira tu sau si Josepa, <<Bi maragovi tu mana roitinia ara sa na roiti api. Isa gu na tinoni sa tapoa sa tekua na kapa sa mina pinausu taqu. Goto agou doru sa muna mule sae, vabubulemiu tana tamamiu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Poni sa kanoko tata lao tana si Jiuda ko pira sau, <<Muke veinisiu qua tinoni lavata. Bu vamalumusiu ko ma parangigo mai ao na qua tinoni lavata. Muke kokoranisiu ara na mua nabulu ura ao sa vaitoto vei gu i Pero sao. ");
INSERT INTO lga_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Qua tinoni lavata! Perangana qu nanasagei sagei na mua nabulu, <Ai vei korapa suvereona na tamamiu beto koleona kai tasimiu marene?> qugunigei. ");
INSERT INTO lga_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Poni pira qeunigo sao qua tinoni lavata, <E! Korapa suvereona na tamamei babaragoso beto kai tuna marene isa sa podo totonai sa tei baragoso vivitigi tu isa. Na tugana sa tei mate tu ko mekana gu isa sa korapa suvere sa ira karu kai tinadi ko na tamana sa roroqu vivitigia sisa>,>> qeunigo. ");
INSERT INTO lga_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","<<Poni pira qugunigei sagei na mua nabulu, <Mu toni lagerenia taqu ko ma batini mataqu sisa> qugunigei. ");
INSERT INTO lga_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Poni pira qeunigo sao qua tinoni lavata, <Na koburu sa tapata mina loai na tamana ura vei mina loai sisa sa kode mina mate gu sa na tamana>, qeu. ");
INSERT INTO lga_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ba pira qugunigei tu sagei na mua nabulu, <Vei mineke tuti lageregou sa na tasimiu sa munake bola bati ligua na isumataqu ara,> qugu. ");
INSERT INTO lga_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ko totonai qe mule sae kamua sa na mua nabulu na tamamei, poni sa qe vavakato vania sa doru na paranga qu pojai ao na qua tinoni lavata.>> ");
INSERT INTO lga_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ego sa sovai, <<poni sa pira sau sa na tamamei, <Mu mule gore ko mu vai vanigita mule ka visa tetekuna,> saunigei. ");
INSERT INTO lga_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ba pira qeunia, <Agei meneke boka gore. Vei mina tutigei tu na tasimei pa ligu sa mene gore. Ura agei meneke boka batia na isumatana na tinoni isa vei mineke tutigei na tasimei pa ligu>,>> qeunia. ");
INSERT INTO lga_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","<<Poni pira saunigei sa na mua nabulu na tamamei, <Qu gigilaimiu agou sa karu tuqu marene sa sa vapodo vanisiu ara na maqotaqu>.>> ");
INSERT INTO lga_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kame ira karu sa sa taloa taqu ko totonai pira qau, <<Vavagila kaki manugu pirudi qai tei garata pipiara pale tu sisa.>> Ko qake batia ara sisa kamua tugu pa ngeni alepi. ");
INSERT INTO lga_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ko vei muna teku variunisiu mule sapi ko mina gosoro kalea na tapata sisa sa na mamata takulanga gu sa, kode mina vagorenisiu pa leo pou ara, saunigei. ");
INSERT INTO lga_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ko sa vei sa, <<Vei mana mule sae tana mua nabulu na tamaqu sara ko na koburu minake tutigei sagei sa na toa tana tamana sa piulai vaikamu gu pana toa tana tuna gu api ke, ");
INSERT INTO lga_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ko totonai mina batia na tamamei kepore sa na koburu poni sa kode mina mate gu sisa. Ko na takulanga gu mene vagorenia pa leo pou agei na mua nabulu sa na mua nabulu na tamamei, ");
INSERT INTO lga_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ura ara na mua nabulu qa tapogosonia tana tamaqu sa na koburu api.>> Pira qaunia Vei maneke toni mulenia sa na koburu alepi sa ara mana tajutu tarinia pa moemu ao na tamaqu kamua na kamua qaunia. ");
INSERT INTO lga_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","<<Ko ai vei bi ara na mua nabulu ba beia sa na koburu ko ba suvere vei na pinausu tamu ao na qua tinoni lavata goto na koburu bi tuti mule saeria sira na tugana. ");
INSERT INTO lga_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ai mana boka roiti vei mana mule kamua na tamaqu vei maneke toni mulenia sa na koburu? Dai! Qake nyorogua batia na takulanga mina gosoria na tamaqu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ego sake boka sosoto aru mulenia pa moedi ira doru ona tinoni roiti si Josepa, ko sa kukuria, pira sau, <<Mu vaiolo voturia pana taqu sira doru,>> sau. Ko kepotu sa kame bi suvere sa totonai sa ule votu mulenia mekana tadira na tugana na tasina si Josepa. ");
INSERT INTO lga_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Beto sa lukana uui viviva si Josepa ko ira na tinoni tu pa Ijipi ba qai nongoria beto ira pa ruma tai Pero ba qai nongoria tugu. ");
INSERT INTO lga_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Beto pira sauniria i Josepa sira na tugana na tasina, Ara Josepa sapi! Ai vei sa korapa toaona na tamaqu? sauniria. Ba ira na tugana na tasina sa qai kununu gu koledia ura qai matagutu vivitiginiria pa moena isa. ");
INSERT INTO lga_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Beto isa sa pira sauniria i Josepa sira na tugana na tasina, <<Lame tata taqu,>> sau. Totonai qai lame tata tana sa, pira sauniria, <<Ara na tasimiu i Josepa sapi, isa qu vavai lagerenia pa Ijipi agou. ");
INSERT INTO lga_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ba munake takulangania beto munake tagigiri mulenigou mekamiu sa vei qu vavai lagerenisiu ara lani ura na Tamasa tu sa garunu valagere momoesiu sara ko mai tavasare sa na toa. ");
INSERT INTO lga_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kopira sa tei karu aoro tu sa raja pa ia sa na songe ko ka lima aoro mutu sa kole totonai mina kepore tugu sa na umuma beto na lolokete pa inuma. ");
INSERT INTO lga_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ba na Tamasa sa garunu valagere momoesiu sara ko mi kole jola sa kai minete tinoni tamugou pa nabana beto mi tavasare sa na toa tamugou pa kai soana vaivagabarana jola,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","<<Ego ko, nake agou qu garunu valageresiu lani sara, goto na Tamasa tu. Ko isa sa vatoqosiu sara ko ara sa na tamana i Pero beto na tinoni lavata tadira doru ona tatamana isa beto na tinoni mamata pa doruna ia pa Ijipi. ");
INSERT INTO lga_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ko mu sisiqarai mule sae tana tamaqu ko mu pojania sisa, Pira sau sa na tumu marene i Josepa; Na Tamasa sa vatoqosiu ko na tinoni lavata pa Ijipi sara. Ko mu gore lagere taqu, muke vavabongi. ");
INSERT INTO lga_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Muna suvere pa pikata ia pa Qoseni ko muna boka suvere tata taqu- ao, ira na tumu beto na mabusu beto ko ira na miu sipi, na qoti, na bulumakau beto doruna sakasava qu isongoria. ");
INSERT INTO lga_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ko ara mana dodogorogou ketakoi pa kalena na tetekuna ura ka lima aoro tu sa sa kole beto sa mina jola sa na songe api, kita vei ko mu malanga vaivasevi sa ao, ira na mua tatamana beto doru na vei qu isongia, munagunia.>> ");
INSERT INTO lga_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","<<Ko na matamiu mekamiu sa batisiu beto vei tugu na matana mekana i Benisimani na tasiqu alepi sa, ara Josepa sosoto tugu sa qa korapa paparangagou alepi. ");
INSERT INTO lga_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ko muna ule vania na tamaqu sa veveidi doru na vinalavata qa taiania ara pa Ijipi beto veveidi doru na sakasava qu batiria. Beto ko muna sisiqarai toni lagerenia lani sa na tamaqu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Beto isa sa sa boru lulukania si Benisimani na tasina ko i Benisimani ba sa boru lulukania tugu sisa. ");
INSERT INTO lga_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Beto sa ao memekaria na paparadi sa doru tugana beto sa lukana tatariria. Pa liguna isa poni sa ira na tugana na tasina sa qai parangia sisa. ");
INSERT INTO lga_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Totonai sa kamu pa ruma tai Pero sa na nongorona na kamudi ira na tugana na tasina i Josepa sa, i Pero beto ira doru tinoni lalavata tana sa qai qera. ");
INSERT INTO lga_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ko pira saunia i Pero si Josepa, <<Mu pojaniria sa na tugamu na tasimu ko mai surana vapugeleni tetekuna sa na dia mamanugu mamade nene beto mai mule pa ia pa kenani, ");
INSERT INTO lga_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","beto ko mai toni lagereniria lani sa na tamamiu beto na miu tatamana beto mu lagere taqu. Ara mana vanigou na ia jojongana pa Ijipi beto muna boka teteku vatale pa teteku jojongadi pa ia lani,>> munaguniria. ");
INSERT INTO lga_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Beto mu pojaniria, pira muguniria, <<Mu tekuria kaki totopili pa Ijipi ketakoi muna surananiriaira na miu koburu, na maqotamiu beto sa mu surania sa na tamamiu ko mu lagere. ");
INSERT INTO lga_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Muke pavu doro roroquria sa na miu isisongo ura doru sakasava jojongadi pa Ijipi sa kode muna isongoria gu muguniria,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ko qai roiti vei tugu sira na tuna i Izireli. I Josepa sa vaniria na totopili vei sa garununia i Pero beto vei tugu na besa pa dia rerege mule pa Kenani. ");
INSERT INTO lga_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Sa okoto vaniria na poko kokoregadi sira na tugana goto i Benisimani sa kue gogoto poata siliva beto ka lima bebei sa na poko sa vania sisa. ");
INSERT INTO lga_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Beto tana tamana sa, aipira sa sa vaigarununia mai vania: ka manogaputa dongiki marene qai vasurananiria na sakasava jojongadi pa Ijipi, beto ka manogaputa dongiki rereko qai vasurananiria na kiko, na bereti beto kaki sakasa mina arua i Jekopi totonai mina rerege gore pa Ijipi. ");
INSERT INTO lga_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Beto poni, sa garunu variuria sa na tugana na tasina, beto totonai mai taloa riu qarigu sa, pira sauniria, <<Munake vaivatorasa pa soana,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ko qai taloa pa Ijipi sira ko qai sae pa ia pa kenani kamua si Jekopi na tamadi. ");
INSERT INTO lga_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Beto qai ule vania sisa, pira qarigunia, <<Sa korapa toaona gu si Josepa! Ko isa sa na tinoni mamata pa doru ia pa Ijipi,>> qarigunia. Poni sa dugala vasiboro na bulona si Jekopi ura sake vasosotoria sira. ");
INSERT INTO lga_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ba pa liguna qai vavakato vania sa doru paranga sa pojaniria i Josepa, beto totonai sa batiria sa na totopili sa vaigarununiria i Josepa ko mai surana gorenia isa pa Ijipi sau poni sa sa ngangali ligu sa na gagalana i Jekopi na tamadi. ");
INSERT INTO lga_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Poni pira sau si Izireli, Pada gu kopira! I Josepa na tuqu sa korapa toaona. <<Ara ma gore ko ma batia sisa totonai qa oqoro mate,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ego ko sa taloa pa Kenani si Izireli pogosoria sa doru sakasava sa isongoria, ko sa gore vei pa Biaseba ko ketakoi sa vavakukuvu lao tana Tamasa tai Aisake na tamana. ");
INSERT INTO lga_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ego na Tamasa sa parangia si Izireli pana kai dodogoro na bongi, pira saunia, <<Jekopi! Jekopi,>> sau. Sa pira sau sisa, <<Api sara,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Sa pira sau sa na Tamasa, <<Ara sa na Tamasa, na Tamasa tana tamamu.>> <<Muke matagutu gore pa Ijipi, ura mana roiti veinigo kai puku tinoni lavata ketakoi ara sao. ");
INSERT INTO lga_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ara mana gore tavitigo pa Ijipi beto mana isongo toni sale mulenigo. Beto na limana tugu mekana i Josepa kode mina voporia sa na matamu ao,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ego ko sa qaqiri si Jekopi ko sa taloa pa Biaseba, ko ira na tuna marene qai tonia si Jekopi na tamadi, beto doru dia koburu beto na maqotadi pana totopili sa garunu vasalea i Pero ko mina surania i Jekopi saunia. ");
INSERT INTO lga_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Qai toniria tugu vei sa na dia papausu beto na isisongo qai teku isongoria pa Kenani ko qai gore pa Ijipi sira Jekopi beto ira doru na vuana. ");
INSERT INTO lga_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Sa toni goreniria pa Ijipi isa sira na tuna marene na tuna rereko beto doru na mabusu- doru na vuana isa. ");
INSERT INTO lga_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Aipira sa na isongodi ira na tuna marene i Izireli (i Jekopi beto ira na tuna marene isa) qai gore pa Ijipi. I Rubeni na tuna pa moa i Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ira na tuna marene i Rubeni sa: I Hanoki, i Palu, i Hezironi beto i Kami. ");
INSERT INTO lga_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ira na tuna marene i Simioni sa: I Jemueli, i Jamini, i Ohadi, i Jakini, i Zoha beto i Saulu isa na tinana sa kai rereko pa Kenani. ");
INSERT INTO lga_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ira na tuna marene i Levi sa: I Qesoni, i Kohati beto i Merari. ");
INSERT INTO lga_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ira na tuna marene i Jiuda sa: I Ere, i Onani, i Sela, i Perezi beto i Zera (ira Ere beto i Onani sa qai tei mate tu pa ia pa Kenani). Ira na tuna marene i Perezi sa: I Hezeroni beto i Hamulu. ");
INSERT INTO lga_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ira na tuna marene i Isaka sa: I Tola, i Pua, i Jasubi beto i Simironi. ");
INSERT INTO lga_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ira na tuna marene i Zebuluni sa: I Seredi, i Eloni beto i Jahaleli. ");
INSERT INTO lga_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Aipira sa na tuna marene i Jekopi sa vaporeniria tai Lia pa Padani Arami tavatia kai tuna rereko nisongona i Dina. Ko na vaikamudi ira na tuna marene na rereko sa ka uengavulu kue. ");
INSERT INTO lga_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ira na tuna marene i Qadi sa: I Zeponi, i Haqi, i Suni, i Eziboni, i Eri, i Arodi beto i Areli. ");
INSERT INTO lga_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ira na tuna marene i Asa sa: I Imina, i Isiva, i Isivi beto i Beria. Na luludi rereko si Sera. Ira na tuna marene i Beria sa: I Hebe beto i Malakiele. ");
INSERT INTO lga_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Aipira sa na tuna marene i Jekopi sa vaporeniria tai Zilipa isa na nabulu rereko i Labani sa vania i Lia na tuna rereko. Ko na vaikamudi sa ira ka manoga vonomo. ");
INSERT INTO lga_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ira na tuna marene i Jekopi sa vaporeniria tai Resolo sa: Ira Josepa i Benisimani. ");
INSERT INTO lga_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Pa Ijipi sa, ira Manase beto i Eparemi sa karu tuna marene i Josepa sa vaporeniria tai Asenati na tuna rereko i Potipera isa na iama pa Oni. ");
INSERT INTO lga_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ira na tuna marene i Benisimani sa: I Bela, i Beke, i Asibeli, i Qera, i Namani, i Ehi, i Rosi, i Mupimi, i Hupimi beto i Aradi. ");
INSERT INTO lga_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Aipira sa na tuna marene i Jekopi sa vaporeniria tai Resolo. Ko na vaikamudi sa ira ka manoga made. ");
INSERT INTO lga_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Na tuna marene i Dani sa: i Husimi. ");
INSERT INTO lga_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ira na tuna marene i Naputali sa: I Jaziele, i Quni, i Jeze beto i Sileme. ");
INSERT INTO lga_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Aipira sa na tuna marene i Jekopi sa vaporeniria tai Biliha isa na nabulu rereko i Labani sa vania i Resolo na tuna rereko. Ko na vaikamudi ira doru sa ka vitu. ");
INSERT INTO lga_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ko dorudi ira qai gore pa Ijipi tavitia i Jekopi vei ira na orunguna sosoto isa goto nake anye tavitiniria na maqotadi ira na tuna marene sa ka vonomo ngavulu ka vonomo na vaikamudi. ");
INSERT INTO lga_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ko vei mina anye tavitiniria sa karu tuna marene i Josepa qai podo pa Ijipi sa, ira na tinoni pa tatamana tai Jekopi qai gore pa Ijipi sa ka vitu ngavulu puta na vaikamudi. ");
INSERT INTO lga_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ego i Jekopi sa garunu valao momoea tai Josepa si Jiuda ko mi ule momoe vania sa na soana sa lao vei pa Qoseni sau. Ko totonai qai kamu pa pikata ia pa Qoseni sa, ");
INSERT INTO lga_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","I Josepa sa vananama vakolea sa nona totopili isa mina lao gosoronia i Izireli na tamana pa Qoseni saunia. Ko isa tugu sa lao bola votu pa moena na tamana si Josepa sa, sa boru lulukanania sisa. ");
INSERT INTO lga_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Beto pira saunia i Izireli si Josepa, <<Kopira mana boka matequa gu ura kopira qa batia mekaqu na isumatamu sa qu korapa toamua sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Beto pira sauniria i Josepa sira na tugana na tasina beto ira doru na tavitina i Jekopi, <<Ara sa mana lao parangia si Pero beto mana pojania sa agou na tugaqu na tasiqu beto doru tavitina na tamaqu qu suvere pa ia pa kenani sa qu tei kamusiu tu ara. ");
INSERT INTO lga_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ko na tinoni aipira sa na tinoni kokopu sipi, na papausu ko qai toniria tugu vei sa na dia gogodo sipi na bulumakau beto doru sakasava qai isongoria managunia. ");
INSERT INTO lga_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ko vei mina kukugou si Pero ko pira minagu, <Na sa na miu roit sagou minagu sa,> ");
INSERT INTO lga_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","pira munagunia, Agei na mua nabulu aipira sa podalai tu na iketemei sa na kokopuniria gu na papausu qai vevei ira na tamamei sa na mei roiti munagu. Poni sa kode mina malumu vasuveregou sa pa pikata ia pa Qoseni, ura na sakasava ikikerena jola tadira na tinoni Ijipi sa na roiti tadira na tinoni kokopu sipi,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Ego ko i Josepa sa lao pojania si Pero, pira sau, <<Na tamaqu beto ira na tugaqu na tasiqu tavitiria na dia gogodo sipi na bulumakau beto doru na sakasava qai isongoria sa qai tei kamu tu koko pa ia pa Kenani ko qai korapa pa Qoseni sa kopira,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Beto sa vileria sira ka lima tugana ko sa toni laoniria tai Pero. ");
INSERT INTO lga_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Sa nanasaria i Pero sira ka visa tamatasi, pira sauniria, <<Na sa sa na miu roiti sagou?>> sau. Poni pira qarigunia si Pero, <<Agei na mua nabulu aipira sa na tinoni kokopu sipi,>> <<Na roiti tugu qai roroitinia na tamamei,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Beto pira qarigunia mutu, <<Qe kamu suvere vei na tinoni karovomei lani sagei, ura na songe sa raja vaneneqi sa pa Kenani ko na mei papausu ba kepore sa na buburu vei ketakoi bai gagani. Ko sa vei sa, bu vamalumugei ko be suvere pa ia pa Qoseni sagei na mua nabulu,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Poni pira saunia i Pero si Josepa, <<Na tamamu beto ira na tugamu na tasimu sa qai kamu tamu, ");
INSERT INTO lga_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ko na ia pa Ijipi sa pa moemu inana, ko mu vasuvereria pa kai kobu ia vavaguana sa na tamamu beto ira na tugamu na tasimu mu vasuvereria pa Qoseni beto vei muna gigilaria koledia sa kaki tinoni boboka, poni sa mu udukuria ko mai tinoni kopuniria na papausu taqu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ego beto sa tonia i Josepa si Jekopi na tamana ko sa lao turu pa moena i Pero ko i Jekopi sa manania si Pero. ");
INSERT INTO lga_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Poni i Pero sa nanasia si Jekopi, pira sau, <<Ka visa na aoromu sao?>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Poni pira saunia i Jekopi si Pero, <<Na aoro qa suvere vei na tinoni karovoqu ara sa kai gogoto uengavuluputa. Qai papaka beto sa koleria na tapata sa na aoro qa toania ara beto qaike kakasa vei na aoro qai toania ira na tamaqu vei na tinoni karovodi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Beto poni sa manania i Jekopi si Pero beto sa votu taloa tai Pero sisa. ");
INSERT INTO lga_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ko sa vasuvere togasaria i Josepa pa Ijipi sira na tamana, na tugana na tasina beto sa vaniria na kobu ia vavaguana pa Ijipi isa na pikata gugugusu pa Ramisisi tutia tugu vei sa pojai i Pero. ");
INSERT INTO lga_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ko i Josepa sa kole dodogororia pa tetekuna sira na tamana, na tugana, na tasina beto pa doru na tatamana tana tamana, tutia tugu na anyedi ira na dia koburu. ");
INSERT INTO lga_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ego doruna na pipikata ia sa kepore sa na gagani ura sa raja vaneneqi sa na songe ko na ia pa Ijipi beto na ia pa Kenani sa qai burana vaivasevi beto sa veiniria na songe. ");
INSERT INTO lga_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ko i Josepa sa tekuria sa doruna poata qai kole pa Ijipi beto pa kenani qai vainiria na kiko ko sa pogoso laoniria pa ruma tai Pero. ");
INSERT INTO lga_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ko totonai sa pidili sa na poata tadira na tinoni pa Ijipi beto pa Kenani sa, doruna pa Ijipi sa qai kamu tai Josepa ko pira qarigunia, <<Mu vanigei na gagani. Ai sa vei ko mene mate vuvusu tu pa moemu ao lani ura kopira na mei poata sa beto pudala,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Poni pira sauniria i Josepa, <<Ego mu vakamuria na miu papausu ropi. Ko ara ma vanigou na gagani beina na miu papausu ura sa beto pudala na miu poata qugu,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ko qai pogoso kamuniria tai Josepa sa na dia papausu ko sa vaniria sa na gagani vaibeiniria na dia hose, na sipi, na qoti, na bulumakau beto na dongiki. Ko inara sa toka veiniria isa sa pa aoro doruna, sa vaibeiniria na gagani sa doruna dia papausu. ");
INSERT INTO lga_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Totonai sa okoto sa na aoro isa sa, qai kamu mule tana sa pa aoro pa liguna isa ko pira qarigunia sisa, <<Meneke golomia tamu na mei tinoni lavata sa, na mei poata sa beto pudala ko na mei papausu sa na mua ao na mei tinoni lavata, kepore mule sa kai sa mene vanigo ao goto na tinimei tugu beto na kobu ia tugu qe isongoria. ");
INSERT INTO lga_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ai sa vei ko mene mate vuvusu tu pa moemu ao- Agei beto na mei kobu ia. Ko mu vainigei na gagani sagei beto na mei kobu ia ko agei beto na mei kobu ia sa mene pinausu vanigo gu ao Pero. Ko mu vanigei na kiko ko me boka toa beto meke mate beto na kobu ia sa mike qasania kai sa,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ko i Josepa sa vai beto vania i Pero sa doru na ia pa Ijipi ura ira dodoru tinoni pa Ijipi sa qai vavainiria sa na dia ia ura sa raja vaneneqiria sa na songe. Ko na ia pa Ijipi sa i Pero sa isongoria, ");
INSERT INTO lga_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","beto i Josepa sa vapinausuria sira na tinoni podalai pa kai uquna pa ia pa Ijipi ko sa lao kamu pa kai kalena tu. ");
INSERT INTO lga_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Goto na ia tugu tadira na Iama sa sake vaia isa ura i Pero tugu sa vavaniria iapeki ia sira na iama ko qai boka tetekuni gagani sa ketakoi na ia sa vaniria isa. Ko sa vei sa qaike vavainia sa na dia ia sira. ");
INSERT INTO lga_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Pira sauniria i Josepa sira na tinoni, <<Kopira pa ngeni alepi sa qa vaigou ara sagou beto na miu ia ko na ona i Pero sagou. Ko aipira sa na kiko ko mu umai sa na ia. ");
INSERT INTO lga_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ba totonai mina kamua sa na totoso ababu sa, kame pa lima sa muna vania i Pero goto ka made pa lima sa muna kopuniria ko muna umuma soga beto na tetekuna tugu vei tamugou mekamiu na miu tatamana beto na miu koburu.>> ");
INSERT INTO lga_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Poni pira qarigu sira na tinoni, <<Qu aloria ao sa na toa tamigei.>> <<Qu roiti vajongana lame tamigei sao na mei tinoni lavata ko agei sa nona pinausu gu i Pero sa kopira,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ko i Josepa sa vaturua sa kai vavanau veveina na ia pa Ijipi sa korapa tugu tavaroiti kamua pa rane pa ngeni alepi. Ko na vavanau isa sa kame pa lima pa dorudi na sakasava qai tateku pa inuma sa tana na bangara i Pero. Na ia tugu qai taiania ira na Iama sa sake isongia i Pero. ");
INSERT INTO lga_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ego ko qai suvere togasa pa Ijipi pa pikata ia pa Qoseni sira na tinoni Izireli. Qai isongodia sakasava ketakoi beto qai vua ko qai soku vatatale. ");
INSERT INTO lga_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ka manogavitu aoro sa sa suvere pa Ijipi si Jekopi ko na kakasana na toa tai Jekopi sa kai gogoto made ngavulu vitu aoro. ");
INSERT INTO lga_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Totonai sa tata kamua na totoso mina mate si Izireli sa, sa kukua si Josepa na tuna beto pira saunia, <<Vei muna qeranisiu ara sao sa, mu vakolea na limamu pa kauru avaqu ara beto mu taringungutinia sa ao muna vatadogoronia na mua roroqu beto na mua rarange lame taqu ko munake golomosiu sa pa Ijipi, ");
INSERT INTO lga_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","goto totonai mana mate ko mana kamuria na tamaqu sa, muna pogoso votunisiu tu pa Ijipi beto ko muna sae golomosiu ketakoi qai tagolomo ira,>> sau. Poni pira saunia i Josepa sisa, Jongana! <<Kode mana roitinia ara sa isa vei qu pojai ina,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ko pira sau si Izireli, <<Mu maulunisiu,>> sau sisa. Ko sa maulunia i Josepa sisa beto sa titi opo gore pa batuna nona opata si Izireli ko sa vatarasaea na Tamasa. ");
INSERT INTO lga_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ego pa liguna aipira, pira qarigunia si Josepa, <<Koi sa vioro sa na tamamu,>> qarigu. Poni sa sa toniria isa sa karu tuna marene ira Manase i Eparemi. ");
INSERT INTO lga_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Totonai qai ule vania si Jekopi, pira qarigunia, <<I Josepa na tumu marene sa kamu tamu sau,>> qarigu, poni sa sa vaipera tatakole ko sa toqo pa lovu si Izireli. ");
INSERT INTO lga_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Beto pira saunia i Jekopi si Josepa, <<Na Tamasa neqina jola sa sa votu taqu pa Luzi pa ia pa Kenani, beto ketakoi sa mananisiu, ");
INSERT INTO lga_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","beto pira saunisiu, <Mana vavuago beto mana vasokugo beto mana roiti veinigo kai puku minete tinoni ara sao beto mana vanigo ara sa na ia api ko ira na vuamu ao vuka risa mai isongia kamua na kamua>.>> ");
INSERT INTO lga_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","<<Ego ira karu tumu marene ao qai podo pa Ijipi totonai qa oqoro lagere ara tamu pa Ijipi sa taqu sira ko ira Eparemi i Manase sa taqu, vaitoto puputa vei tugu ira Rubeni i Simioni sa taqu. ");
INSERT INTO lga_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ira na koburu qu vaporeria ao pa ligudi sa tamu sira goto ira karu sa na ia mai isongia vuka risa sa na isongodi sa mai taanye tavitiniria na isongodi ira na tugadi. ");
INSERT INTO lga_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Totonai qa korapa mule koko pa Padani sa, qa mamata takulanga jola sara ura sa mate si Resolo pa ia pa Kenani totonai tu qe korapa rererege lame mei, na souna iapeki koko pa Eparati. Ko qa golomonia tugu ketakoi pa keketai soana sa lao pa Eparati>> (isa pa Betilihema sisa), sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Totonai sa batiria na tuna marene i Josepa si Izireli sa, sa nanasa, <<Ira sei sa pira?>> sau. ");
INSERT INTO lga_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Poni pira saunia i Josepa sa na tamana, <<Ira na tuqu marene ara na Tamasa sa vanisiu lani sinara,>> saunia. Poni pira sau si Izireli, Mu valameria ko ma mananiria, saunia. ");
INSERT INTO lga_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ego sake kakabere vatale na matana si Izireli koi vei sa baragoso vivitigi ko sake boka batia kai sa. Ko sa toni vatata laoria tu tana i Josepa sira karu, ko na tamana sa aoria beto sa boruria. ");
INSERT INTO lga_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Beto pira saunia i Izireli si Josepa, <<Qake rove veinia mana bati ligua ara sa na isumatamu ao, ba doro kopira na vuamu tu ba na Tamasa sa vabatinisiu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Beto isa sa, sa teku varijoria i Josepa sa karu tuna pa tutungu nenena na tamana beto sa titi opo gore pa peso sisa. ");
INSERT INTO lga_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Ego i Josepa sa aruria sira karu, i Eparemi pa kale matuana lao vei pa kale lima merina i Izireli beto i Manase pa kale merina lao vei pa kale lima matuana i Izireli, beto sa sa toni laoniria tana tamana. ");
INSERT INTO lga_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ba i Izireli sa alaka laonia tu sa na lima matuana ko sa vaoponia pa batuna i Eparemi tu ba isa pa ligu sisa, beto sa vaipiqosavalania sa na limana ko na merina sa vaoponia pa batuna i Manase ba i Manase tu sapa moa. ");
INSERT INTO lga_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Beto poni sa manania si Josepa, pira sau, <<Na Tamasa isa qai rererege pa moena, Ira na tamaqu i Ebarahami beto i Aisake, Na Tamasa isa sa paususiu Pana doru na qua toa kamu pa ngeni alepi, ");
INSERT INTO lga_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Na mateana isa sa alosiu ara pa doruna na tapata Mi mananiria sa na koburu marene aipira. Mai takukunia na isongoqu ara Beto na isongodi ira na tamaqu ira Ebarahami i Aisake, Beto mai vua vasosoku pa abana,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Totonai sa batia i Josepa sa na tamana sa vaopoa sa na lima matuana pa batuna i Eparemi sa, sake qera ko sa arua sa na limana na tamana pa batuna i Eparemi ko mi vakarovo laoa pa batuna i Manase sau. ");
INSERT INTO lga_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Beto pira saunia i Josepa sa na tamana, <<Dai Tamaqu! Api tu sa pa moa! Vaoponia na lima matuamu pa batuna isa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ba sa daiona tu sa na tamana, pira sau, <<Qa gigilaiqua tuqu, qa gigilaiqua. Isa ba mina lame kai puku minete tinoni tugu beto mina kai tinoni poreveveina sisa. Ba isa tugu, na tasina sa mina tinoni poreveveina jola jolania isa, beto na vuana isa sa mai kai minete puku tinoni lavata,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Beto ko sa mananiria sa pa rane isa, pira sau, <<Pa isongomu ao sa ara Izireli qa parangania sa na mana api <Na Tamasa mi roiti veinigo ira Eparemi beto i Manase sao>,>> saunia. Ko sa vamomoea isa si Eparemi beto sa valiligua isa si Manase. ");
INSERT INTO lga_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Beto isa sa, pira saunia i Izireli si Josepa, <<Ara sa tata gu mana mate, ba na Tamasa mina vavaburogou ko mina toni mulenigou pa ia tana tamamiu. ");
INSERT INTO lga_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Beto ara qa vanigo ao jolaniria ira na tugamu na tasimu sa kai kobu ia pa Sekemu isa na ia qa teku variuniria ara ira na tinoni Amorai pa qua benisi beto na bokala,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ego beto sa, sa kukuria i Jekopi sira na tuna marene ko pira sauniria, <<Mu vaikamu ko ma ule vanigou sira na sakasava muna gosororia pa rane qai lame pori.>> ");
INSERT INTO lga_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","<<Mu vaikamu ko mu vainongoro, sagou na tuna marene i Jekopi;>> <<Mu nongoria i Izireli na tamamiu.>> ");
INSERT INTO lga_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","<<Rubeni, ao sa na tuqu moa, Na qua viva, na neqi momoe taqu, Qu iolo pana vavagua, iolo pa neqi,>> ");
INSERT INTO lga_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Qu tuara pipiara vei na kolo, Ko munake iolo sao Ura qu kesai na lovu tana tamamu, Ko qu vapajia na qua kokolena. ");
INSERT INTO lga_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","<<Ira Simioni i Levi sa na tamatasi- Na dia benisi sa na dia vavaipiaraina.>> ");
INSERT INTO lga_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Make tomea na dia vavavanau ikerena, Make somanania na dia vavaikamu, Ura pa dia kokora qai vamatea na tinoni Pa dia qeqera qai pano vapapalekaria na papausu. ");
INSERT INTO lga_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Mi taleve sa na dia kokora, ura sa manginina jola Beto na dia tagigiri ura sa iku vuvurungu! Mana vaipikatainiria tai Jekopi Beto mana vaipiarainiria pa Izireli. ");
INSERT INTO lga_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","<<Ao Jiuda, na tugamu na tasimu mai vatarasaego; Na limamu mina pidururia na mua kana. Mai titi opo gorenigo sira na tuna na tamamu.>> ");
INSERT INTO lga_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ao Jiuda sa na laione kokoregamu; pa liguna qu tekua na mua boso qu mule kamu. Vei na laione kokoregana sa gona toqo kole, Vei na laione rereko- i sei mina nyorogua vatorasia sa? ");
INSERT INTO lga_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Na kolu bangara minake taloa tai Jiuda, Ko na opata bangara mina lame pa tutina isa Tinganai mina lame kamu si Silo Beto ira na tinoni mai vatabea sisa. ");
INSERT INTO lga_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Mina piko vaturunia pa gou qurepi nona dongiki, Nona tuni dongiki pa gou qurepi vua vatatalena; Mina puaria pa kolo vaini nona poko Nona poko gojo pa kolo jimirina na qurepi. ");
INSERT INTO lga_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Na matana mina jimirini kolo vaini, Na livona mina kekani meleke. ");
INSERT INTO lga_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","<<I Zebuluni sa mina suvere pa babatana Ko mina babatana tadira na vaka; Nona voloso mina kamu pa Sidoni.>> ");
INSERT INTO lga_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","<<I Isaka sa na dongiki pupuda tuva Ba sa kole radonona pa vaikorapaidi karu ona totoqona.>> ");
INSERT INTO lga_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Totonai sa batia nona ia miminerena sa na ia vavaguana Beto nona kobu ia sa vavagua jola. Poni sa poloa na pokotona ko mi pogoso sau ko sa sugaria sa na mamata qai gona vatoparenia. ");
INSERT INTO lga_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","I Dani sa mina pituria ira nona tinoni Vei tugu kame ira na bubutu Izireli. ");
INSERT INTO lga_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","I Dani sa mina kai dole pa keketai soana, Na tuni dole poisini pa rereregena, Isa sa garatia na kikijulu nenena na hose Ko na tinoni sa koia sa vukele pelusu mulenia. ");
INSERT INTO lga_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","<<Na mua inalo ao sa qa korapa gegelenia, Iahova.>> ");
INSERT INTO lga_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","<<I Qadi sa mai rapatia ira na kana bola siborodi, Ba isa mina rapata vapelusu ukuriuria.>> ");
INSERT INTO lga_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","<<I Asa sa vamasuria na gagani lilingina; Isa mina vatanai na tetekuna bangara.>> ");
INSERT INTO lga_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","<<I Naputali sa na dia nake tapiko tarina Isa sa vaporeria na paranga vavaguadi.>> ");
INSERT INTO lga_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","<<I Josepa sa na gasoro qurepi vua vatatale, Na gasoro vua vatatale pa keketai vuvugu, Ira na kaena qai ajara karovia na bara. ");
INSERT INTO lga_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Qai vabatinia na kokora ko qai tupia; Qai tagigirinia ira na kuta tinoni anga.>> ");
INSERT INTO lga_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ba sa toqo vamauru sa nona bokala, Na limana sa sake kanoko kokomiti, Ura na limana na Tamasa neqina tai Jekopi, Ura na sepati, na patu tai Izireli, ");
INSERT INTO lga_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ura na Tamasa tana tamamu, isa sa tokanigo, Ura na Tamasa neqina jola, isa sa mananigo Na mana qai koko lagere vei pa noka, Na mana qai vuvugu votu vei pa kauru lilisina, Na mana qai lame vei pa susu beto pa iapa. ");
INSERT INTO lga_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ira na mana tana tamamiu sa qai poreveveina jolaniria, Ira na mana lame veidi pa kukubo lalavata kokoleidi. Jolaniria na vaitokai jongadi lame veidi pa kukubo kokoleidi. Ira doru sakasava aipira sa mai kole pa batuna i Josepa, Pa reana isa mina dodogororia ira na tugana na tasina. ");
INSERT INTO lga_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","<<I Benisimani sa na vulupu piruna; Na vuvugei sa gani pipiaria na mamanugu sa vamatea Na vevelu sa vaipikatainiria sa na isisongo sa tekuria,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ko dorudi aipira sa ka manogarua bubutu Izireli, ko api sa na sakasava sa pojaniria na tamadi totonai sa mananiria beto sa vaniria tugu na okokoto mana sa pada mai tekua. ");
INSERT INTO lga_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ego beto i Jekopi sa sa vaniria sa na vavanau aipira, pira sauniria, <<Ara sa sa tata gu beto mana mate beto mana taboko lao vaikamu tadira na qua tinoni. Ko totonai mana mate sa, muna golomo tavitinisiu ira na qua tite pa bevi pa ia tai Eporoni na tinoni Hitai, ");
INSERT INTO lga_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","na bevi pa ia tai Makipela isa tata pa Mamiri pa ia pa Kenani isa i Ebarahami sa vainia tai Eporoni na tinoni Hitai ko na ia vavaigolomona saunia. ");
INSERT INTO lga_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ketakoi sa qai golomoniria ira Ebarahami beto i Sera na maqotana beto ketakoi qai golomoniria ira Aisake i Ribeka na maqotana beto ketakoi tugu qa golomonia i Lia ara. ");
INSERT INTO lga_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Na kobu ia beto na bevi sa kole pa leo ia isa sa qai tavai tadira na tinoni Hitai,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Totonai sa vaokotia i Jekopi sira na vavanau tadira na tuna marene sa, sa polo saenia pa nona kokolena sa na nenena, sa vasaenga bebeto ko sa mate ko sa taboko lao vaikamu tadira nona tinoni. ");
INSERT INTO lga_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ego sa opo gore borua i Josepa sa na tamana ko sa ao lulukania. ");
INSERT INTO lga_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Beto sa garunuria i Josepa sira nona nabulu dokita ko mai roitia beto mai orani mereseni sa na kokobu tinina na tamana ko mike nyabo sauniria. Ko qai roitia beto qai orania na mereseni sa na kokobu tinina i Izireli, ");
INSERT INTO lga_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ko sa tekuniria ka made ngavuluputa rane sa na roiti isa beto sa okoto sa na roitina na kokobu tini. Beto ka vitungavuluputa rane sa qai kole lukania ira na tinoni pa Ijipi si Jekopi. ");
INSERT INTO lga_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Totonai sa jola sa na totoso qai kole lukania ira sisa sa, pira sauniria i Josepa sira na tinoni lalavata tai Pero, <<Vei muna tavaraguanisiu ara sagou sa, mu paranga vanisiu i Pero,>> pira mugunia, ");
INSERT INTO lga_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Na tamaqu sa vamaulusiu sara pira sau, <<Ara sa tata mana mate ko pa bevi ketakoi qa kori vaoqilia mekaqu pa ia pa Kenani sa ketakoi sa muna golomonisiu,>> sau. Ko kopira bi vamalumusiu ko ba sae golomia na tamaqu beto ba mule bugunia, sau. ");
INSERT INTO lga_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Poni pira sau si Pero, <<Mu sae ko mu golomia na tamamu isa vei sa vamaulunigo ko muna roitinia sau,>> saunia. ");
INSERT INTO lga_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ko sa sae golomia na tamana pa Kenani si Josepa. Doru tinoni lalavata tai Pero, ira na tinoni poreveveidi pa ruma tana beto doru tinoni poreveveidi pa Ijipi sa qai tutia sae i Josepa ");
INSERT INTO lga_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","beto ira na tatamana tai Josepa, ira na tugana na tasina beto ko ira na tavitina na tamana. Na tudia gu beto na dia papausu gu sa qai loaria pa ia pa Qoseni. ");
INSERT INTO lga_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ira qai kokoi pa totopili beto pa hose ba qai tutia sae tugu isa ko na minete lavata sosoto sa qai sae. ");
INSERT INTO lga_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Totonai qai kamu pa ia tatapuni kiko tai Atadi, tata pa Jodani, qai lukana roroma beto uui viviva sira beto ketakoi sa i Josepa sa kole suvere lukania sa na tamana ka vitu rane. ");
INSERT INTO lga_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Totonai qai batiria ira na tinoni qai lulukana pa ia tatapuni kiko tai Atadi sira na tinoni Kenani qai suvere ketakoi sa, pira qarigu, Koi! <<Ira pa Ijipi sa qai korapa roitinia na dia roiti tututi pa totoso takulanga,>> qarigu. Sa vei isa sa, na ia isa kai kalena pa Jodani sa qai vaisongonia Ebolo Miziraimi. ");
INSERT INTO lga_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ko ira na tuna marene i Jekopi sa qai tutia tugu sa na sa sa pojaniria na tamadi. ");
INSERT INTO lga_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Qai surana saenia pa ia pa Kenani beto ko qai golomonia pa bevi pa ia tai Makipela tata pa Mamiri isa i Ebarahami sa vai tavitini ia tai Eporoni na tinoni Hitai perangana ko na ia vavaigolomona saunia isa. ");
INSERT INTO lga_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Pa liguna sa golomia na tamana si Josepa sa, sa mule gore pa Ijipi sisa, ira na tugana na tasina beto ira doru tinoni qai tutia sae isa golomia na tamana. ");
INSERT INTO lga_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ego totonai qai batia ira na tugana i Josepa sa mate sa na tamadi, poni sa pira qarigu, <<Ai vei vei bi korapa tu tagigirinigita i Josepa sa gita pa doru sela taqe roiti laonia tana ko bi vaibeiona biu?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ko qai valao paranga tai Josepa, pira qarigunia, <<Na tamamu sa pira saunigei sa totonai sa oqoro mate: ");
INSERT INTO lga_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","<Pira munagunia si Josepa sau: Ara qa tepago sao tuqu ko mu taleosoniria sa na tugamu pana sela beto ira na tapata qai roiti vivikere laonia tamu.> Mu taleosoniria sa na sela qai roitiniria ira na nabulu tana Tamasa isa na Tamasa tana tamamu,>> sau, qarigu. Poni sa lukana si Josepa totonai sa lame kamu tana sa na nongoro isa. ");
INSERT INTO lga_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Beto poni qai tuti lame sira na tugana ko qai gona oponiria pa moena isa beto pira qarigu, <<Agei sa na mua pinausu gu ao,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ba pira sauniria i Josepa sira, <<Muke matagutu. Na Tamasa sara? ");
INSERT INTO lga_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Agou qu qaqirinisiu na ikerena saraba na Tamasa sa qairinia na jongana ko mi roitinia vei isa korapa taroiti pa ngeni alepi, na alodi na sosoku toa sau. ");
INSERT INTO lga_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ko vei sa muke matagutu. Ara mana dodogorogou sagou beto ira na miu koburu,>> sau sisa. Ko sa vamanotoria beto sa paranga vabubuleria sira na tugana na tasina. ");
INSERT INTO lga_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ego ko sa suvere pa Ijipi si Josepa, isa beto ira na tatamana tana tamana. Sa suvere kai gogoto manogaputa aoro sisa, ");
INSERT INTO lga_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ko sa bati kamua isa sa na vinaue popodo tadira na tuna i Eparemi beto vei tugu ira na tuna i Maki isa na tuna marene i Manase qai vakoleniria pa tutunguna i Josepa totonai qai podo. ");
INSERT INTO lga_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Ego beto pira sauniria i Josepa sira na tugana na tasina, <<Ara sa tata gu mana mate. Ba na Tamasa kode mina lame sosoto tokanigou ko mina toni votunigou pa ia api lao pa ia sa maulu tarinirianiria ira Ebarahami, i Aisake beto i Jekopi,>> sau. ");
INSERT INTO lga_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Beto ko sa vamauluria sira na tuna i Izireli, pira sau, <<Na Tamasa mina lame sosoto tokanigou ko totonai muna taloa lani sa muna pogoso vaioloria lani sa na pupudaqu ara,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ko kai gogoto manogaputa aorona si Josepa beto sa sa mate. Ko qai roitia beto qai orani mereseni sa na kokobu tinina beto qai kurania pa kai kesi vavakoleni tinoni matena pa Ijipi.");
INSERT INTO lga_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Ego ira na rane totonai qai korapa vavaitoni sira na tinoni vavaitoni sa sa raja pa peso pa Izireli sa kai songe. Ko sa taloa pa Betilihema pa Jiuda sa kai tinoni ko sa tonia sa na maqotana beto karu tuna marene ko sa oro lao suvere kai tinoni karovona pa ia pa Moabi. ");
INSERT INTO lga_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Na isongona na tinoni isa si Elimeleki, na isongona na maqotana si Naomi, na isongodi ira karu tuna marene sa ira Maloni i Kilioni. Na tinoni Eparatimi na suveredi pa Betilihema pa Jiuda sira, ko qai karovo lao pa ia pa Moabi ko qai suvere ketakoi. ");
INSERT INTO lga_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ego ketakoi sa mate si Elimeleki na marenena i Naomi, ko sa suvere meka si Naomi beto ira karu tuna marene. ");
INSERT INTO lga_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Ira karu tuna marene sa qai alavadia rereko Moabi, na isongona kame si Opa goto na isongona na vinarua si Ruti. Ko sa papada vei ka manogaputa aoro sa qai suvere ira ketakoi. ");
INSERT INTO lga_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Ego beto sa qai mate mule sira Maloni beto i Kilioni, ko kopira sa taloa vamekaina sosoto si Naomi, kepore na tuna beto kepore na marenena. ");
INSERT INTO lga_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Ego totonai sa korapa tu pa Moabi sa nongoria i Naomi sa i Iahova sa mananiria sira na ona tinoni ko sa vamasuria mule na dia gagani qarigu, poni sa qaqiri si Naomi beto karu roana rereko ko mi taloa pa Moabi sau. ");
INSERT INTO lga_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Ko sa iolo loaia isa sa na ia sa suveria ko ira karu roana rereko sa qai tutia ko qai tonia ira sa na soana ko mai mule pa peso pa Jiuda qarigu. ");
INSERT INTO lga_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Poni pira sauniria i Naomi sira karu roana rereko, <<Mu mule pa ruma tana tinamiu agou karu. I Iahova mi vajongana lao tamugou kai muqisi vei tugu agou ba qu vajongana lao tadira qai tei mate loasiu tu beto taqu. ");
INSERT INTO lga_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","I Iahova mi tokanigou ko mu boka teku marenemiu mule ko mu isongia na miminerena jongana pa ruma tana,>> sauniria. Beto i Naomi sa ao loloaria sira karu, poni qai lukana uui sira karu beto ");
INSERT INTO lga_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","pira qarigunia sisa, <<Dai, agei karu sa mene tutigo tugu mule ao lao tadira na mua tinoni,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Poni pira sau si Naomi, <<Koi, mu mule, karu tuqu maqota. Ai sa vei ko muna tutisiu tu ara? Ai vei qai korapa boka poredia pa iapaqu ara kaki tuqu marene ko mai marenemiu? Tapata! ");
INSERT INTO lga_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Mule, karu tuqu. Taloamiu, ura ara ba qa qoele ko maneke boka teku ligu marene. Vei bi koleona tugu na boka bau ko ba sogotia tugu kai marene kode bongi ko ba vapore koburu marene tugu, ");
INSERT INTO lga_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","poni ba ai vei muna kole tugu vera tinganai ko mai lavata? Ko muna kole tugu suvere naboko gagalemiu ko munake tekumiu marene? Dai, muke vei karu tuqu maqota! Ura isa qa gosoria ara sa pasa jolania isa vei qu gosoria agou karu, ura na limana i Iahova sa rajasiu sara,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Poni qai lukana uui mule sira karu. Beto i Opa sa ao loloai sa na roana, goto i Ruti sa sa boru tamana vamamauru tana roana. ");
INSERT INTO lga_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Poni pira sau i Naomi, <<Dotu! Na rereko tana tasina na marenemu ao sa sa tei muleona tu tadira nona tinoni beto tadira nona tamasa. Mu tuti mulea isa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ba pira tu sau si Ruti, <<Muke paranga jujukusiu ko ma loago babi ma gabala mule riu. Ura ketakoi muna lao ao sa ketakoi tugu mana lao sara. Ketakoi muna vajola bongi ao sa ketakoi tugu mana vajola bongi sara. Ira na tinoni tamu sa na tinoni taqu beto na Tamasa tamu sa na Tamasa taqu. ");
INSERT INTO lga_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ketakoi muna mate ao sa ketakoi tugu mana mate sara beto ketakoi tugu sa mana tagolomo sara. I Iahova mi roiti tarinisiu beto mi garunu vaitamo tatarinisiu tu na vinakilasa sara, vei kaki sakasa mai vaipikatainigita totonai sa oqoro vaipikatainigita na mate sa gita karu,>> sau. ");
INSERT INTO lga_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ego totonai sa dogoria i Naomi sa sa neqi togasa sa na roroqu tai Ruti ko mina tutia tu sisa sau, poni sa sa koroto paranga jujukia sa tonai. ");
INSERT INTO lga_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Ko qai rerege totoni soana tu riudia sira karu ko tinganai qai kamu pa Betilihema. Totonai qai kamu pa Betilihema sira karu poni sa viuveo sa na gusu doruna. Ko qai vainanasa sira na rereko, <<Karuro! I Naomi tu sa api?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Poni pira sauniria i Naomi sira na rereko, <<Muke kukunisiu i Naomi kopira. Mu kukunisiu gu i Pasa, ura na Tamasa neqina jola sa vapasa vivitigia na qua toa. ");
INSERT INTO lga_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Qa taloa riu na pugelequ sara ba i Iahova sa toni mule kamunisiu na kokobaqu. Ko ai sa vei qu kukunisiu tu i Naomi? I Iahova sa vanisiu na tapata sara; na Tamasa neqina jola sa ianisiu na ikerena sara,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ko inara sa vei beto sa qai mule kamu pa Betilihema koko pa Moabi sira Naomi beto na roana i Ruti. Ko totonai qai kamu pa Betilihema sa totonai sa na podalaina na totoso abu vaikamu bali. ");
INSERT INTO lga_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ego pa kalena tai Naomi sa koleona sa kai turana na marenena, na tinoni isa sa kai tinoni purana pa bubutu ti Elimeleki, ko na isongona isa si Boazi. ");
INSERT INTO lga_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ego kai rane i Ruti na rereko Moabi sa tepa tai Naomi, pira sau, <<Ai vei bu vamalumusiu ko ba lao pa ia umuma ko ba somana buti teku bali taloloa paledi tana tinoni bi dogoro vagosorosiu qau,>> saunia. Poni pira sau si Naomi, <<Mu lao, tuqu maqota,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ko sa taloa ko sa lao pa ia umuma ko mi buti tuti bali taloloa paledi pa ligudi ira qai kokobu teku bali sau, poni sa sa toga kale vavajonga pale tu isa sa na kobu ia umuma tai Boazi isa kai tinoni pa bubutu ti Elimeleki. ");
INSERT INTO lga_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ko i Boazi tugu sa sa bola koko pa Betilihema, ko sa paranga gogosororia sira qai kokobu teku bali, pira sau, <<I Iahova mi vavaburogou,>> sau. Poni sa pira qarigu sira, <<I Iahova mi mananigo ao,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Beto sa nanasia i Boazi sa nona nabulu sa kopuniria ira na tinoni kokobu bali, <<Na maqota tai sei sina?>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Poni sa paranga sa nona nabulu sa kopuniria ira na tinoni kokobu bali, pira sau, <<Na maqota Moabi isa sa tutia mule i Naomi koko pa Moabi sina. ");
INSERT INTO lga_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Sa tepa ko bi tutiria ira na tinoni kokobu bali ko bi somana buti vaikamuona bali taloloa paledi sau. Ko na vuvugei jonga tu sa podalai roiti tinganai sa kamua tu kopira, ko sa korapa gu minere mai iapeki totoso pa kauru aqaqo sina,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Poni sa paranga lao tai Ruti si Boazi, pira sau, <<Tuqu maqota, mu vainongoro. Munake lalao buti teku bali sa pana kai goto inuma. Munake taloa lani, goto mu togasa gu tadira na rereko roiti taqu aipira. ");
INSERT INTO lga_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Mu dodoro kopunia sa ketakoi qai korapa kokobu vakoleria na bali ira na tinoni roiti, ko mu tuti pa ligudi ira na rereko. Qa tei suquturia tugu vei sira na marene qai roiti taqu ko maike kotigo. Totonai muna kidepe poni sa muna lao buku pana bogu pie qai tei vutugu vapugeleria tu ira na marene,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Poni sa sa sori tutungu ko sa opo kamu tu pa peso si Ruti beto pira sau, <<Koi qu tavaraguanisiu ko qu doro gigalasiu tu ara- ba ara ko kai tinoni karovoqu tu,>> sau. ");
INSERT INTO lga_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Poni sa oe si Boazi, pira saunia, <<E, qa tei nongoronia tu ara sa doru sakasava qu roiti laonia ao tana roamu toto vei sa mate na marenemu. Qu loa paleria na tinamu na tamamu beto na mua gusu podona, ko qu kamu suvere tavitiria ira na tinoni quke gigilaria pa visa pira. ");
INSERT INTO lga_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ko i Iahova mi bei vanigo sa doru sakasava jojongadi qu roitiniria ao. Mi vaisisongo vapurago i Iahova Tamasa tadira pa Izireli sao ura pa kauru babanana isa qu kamu ongumua sao,>> sau. ");
INSERT INTO lga_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Poni sa paranga si Ruti, <<Qa batia qu tavaraguanisiu, bangara, ura ara qake vei kame ira na nabulu rereko tamu sara bu qu vamanotosiu beto qu paranga vakopelia na buloqu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Ego na totoso teteku sa pira sau si Boazi tai Ruti, <<Ina tekua kai kipa bereti ko mu totogolonia pana vaini,>> saunia. Ko sa toqo tavitiria i Ruti sira na tinoni kokobu bali beto sa sa tekua i Boazi sa kaki bali parugudi ko sa kaqamania. Ko sa teteku si Ruti tinganai sa pote vatale ko sa kole tari tu sa na ona tetekuna. ");
INSERT INTO lga_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ego totonai sa turu lao buti bali mule si Ruti poni sa pira sauniria i Boazi sira na ona nabulu marene, <<Munake vanosoa sisa vei mina teku bali pa boko bali taviledi, goto muna vamalumia gu ko mina tekuona. ");
INSERT INTO lga_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Beto ko mu unusuria sa kaki bali pa kokotu bali ko mu vakoleria tugu vei pa peso, ko isa mina boka buti tekuria beto munake tokea tugu vei,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Ko sa kole buti teku bali pa inuma si Ruti tinganai sa gore tu na vevelu. Beto sa sa iru tekuria sa na kiko pana batudi na bali beto sa vaikamuniria sa padana kai bita pugelena. ");
INSERT INTO lga_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Ego sa pogosoria mule pa gusu sa na bali sa tekuria ko sa vabatinia si Naomi na roana beto ko rau votunia ko sa vania tugu vei sa na gagani sa pote loaria. ");
INSERT INTO lga_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Poni sa nanasa si Naomi na roana, pira sau, <<Tuqu, pai qu buti bali pa ngeni? Pa inuma ti sei sa qu roiti? Na Tamasa mi manania sa na tinoni sa doro gigaligo ao,>> saunia. Poni sa vavakatonia i Ruti tana roana sa na veveina na tinoni sa kole roiti vania, pira sau, <<Na isongona na tinoni qa roiti vania pa ngeni si Boazi,>> sau. ");
INSERT INTO lga_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Poni pira saunia na roana si Naomi, <<Na tinoni isa sa i Iahova mi manania, isa doru totoso sa kopunia nona taringunguti tadira na tinoni toadi beto ira qai tei mate tu,>> sau. Beto pira mule sau, <<I Boazi sa na tavitimei agei ko isa sa na kopu vakarovo tadagita karu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Poni sa pira sau si Ruti na rereko Moabi, <<Ko sa pojanisiu tugu vei ko mana togasa gu tadira nona tinoni roiti tinganai mina okoto tu sa na totoso abu bali saunisiu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Poni sa pira sau lao tai Ruti na roana si Naomi, <<Vavagua, Tuqu. Mu roiti tavitiria gu ira na rereko roiti tana, ura kita mai kotigo pa inuma tana goto tinoni,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Ko i Ruti sa togasa gu tadira na rereko roiti tai Boazi ko sa kole bubuti bali tinganai sa okoto sa na totoso abu bali beto na vuiti. Ko sa suvere tavitia isa si Naomi na roana. ");
INSERT INTO lga_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ego i Naomi na roana sa pira saunia si Ruti, <<Tuqu, ara ma nyaqo vanigo tu kai ia toga miminerena sao ko na marene mi kopu vatalenigo. ");
INSERT INTO lga_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ego, i Boazi, isa qai roiti vania ira na rereko qu roiti tavitiria ao, sa na tavitina na marenequ ara. Mu vainongoro! Kode bongi kode mina ipa pipikatainiria na kiko bali pa ia kakajuruna kiko sisa. ");
INSERT INTO lga_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ko mu ogono tu ao, ko mu anyunigo kaki oela umumanga jonga, beto mu vasaea na mua poko babata jonga, beto mu gore pa ia kakajuruna kiko. Kita bola votu vakabere tana tinganai mina teteku beto mina buku beto mai tu isa. ");
INSERT INTO lga_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Totonai mina kole sa muna doro vagigilai sa na ia ketakoi mina kole. Ko muna lao takelia sa na poko pa nenena beto mu kole. Isa tu mina pojanigo sisa muna roitinia,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Poni sa paranga si Ruti, <<Kode mana roitinia ara sa doruna vei qu pojanisiu,>> sau. ");
INSERT INTO lga_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Ko sa gore sa pa ia kakajuruni kiko si Ruti ko sa roitiniria isa sa doruna vei sa garununia na roana. ");
INSERT INTO lga_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Pa liguna sa teteku beto sa buku si Boazi ko sa tolanga beto na isumatana, sa sa lao kole puta pa kekere vaikamu boko bali. Poni sa mavo rerege lao si Ruti ko sa takelia sa na uquna na poko pa nenena ko sa koleona. ");
INSERT INTO lga_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Na korapa bongi sa vamulongia kai sa ko sa siboro dorava sa na marene qokolo, ko mi peluku sau poni sa siboronia kai rereko tu sa korapa koleona pa nenena. ");
INSERT INTO lga_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Ko sa nanasa, <<I sei sao?>> sau. Poni pira sau sa na rereko, <<Ara Ruti na mua nabulu sapi. Mu radonia na uquna na mua poko ko mu tukisiu ara na mua nabulu, ura ao sa na tinoni kopu vakarovo,>> sau. ");
INSERT INTO lga_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Poni pira sau si Boazi, <<I Iahova mi mananigo, tuqu. Na vairoqu jongana tamu kopira sa sa vavagua jolania mutu isa vei qu roitinia ao tana roamu perangana: ura quke nyaqo tutia ao sa kai koburu koregana, bi isisongona babi golabana. ");
INSERT INTO lga_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ko, tuqu, muke matagutu. Isa vei qu tepai sa kode mana roiti vanigo, ura ira doru tinoni pa gugusu sa qai gigilaidia sa na rereko puramu pana uana sao. ");
INSERT INTO lga_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ko sa sosoto tugu sa ara sa kai tinoni kopu vakarovo, ba korapa suvereona tu sa kai tinoni kopu vakarovo sa tata sosoto jolanisiu ara tana marenemu ao. ");
INSERT INTO lga_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ko mu vajola bongi mai lani na bongi api, beto vuka vuvugei sa vei mina boka kopu vakarovigo minagu isa poni sa jonga isa mina kopu vakarovigo. Goto vei minake malumu kopu vakarovigo, poni, sa ara qa maulu pana isongona i Iahova na toana, ara kode mana kopu vakarovigo sao. Ko mu kolemua tinganai mina kamua vuka vuvugei,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Ko sa kole pa nenena isa tinganai sa kamua na vuvugei, beto sa iolo vuvugei rorodomo totonai sa oqoro boka tadoro gigala na isumatana na tinoni, ura i Boazi sa rovea sa kita mai nongoronia na goto tinoni sa kai rereko sa kamu pa ia kakajuruna kiko, sau. ");
INSERT INTO lga_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Pira saunia i Boazi si Ruti, <<Mu vagorea sa na poko qu pakua isa beto mu lovasia lana,>> saunia. Ko sa lovasia poni sa sa lao tu i Boazi ko sa vuva gore bali padana ko rabete puta kilo sa pana poko isa. Beto sa sa ovulu tokania ko sa pogoso mulenia pa gugusu. ");
INSERT INTO lga_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Totonai sa mule kamu tana roana, poni sa nanasa si Naomi, <<Koi, tuqu maqota, ai qu vevei gamu?>> sau. Poni sa ule vania sa doru roiti sa roitinia na marene tana ");
INSERT INTO lga_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","beto pira sau, <<Beto ko padana rabeteputa kilo bali aipira sa sa vapogosonisiu ura munake mule gagale tana roamu saunisiu,>> sau. ");
INSERT INTO lga_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Poni pira sau si Naomi, <<Mu vera, tuqu maqota, ko tinganai muna gigilai ai mina gore votu vei sa na ginugua api, ura kode minake toqo pua pa ngeni api sa na marene api tinganai mina vatoqo vatalea tugu sa na ginugua api,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ego i Boazi sa sae pa ia vavaikamuna pa totomena na gugusu ikete ko sa toqo ketakoi. Poni sa sa rerege jola tugu sa na tinoni kopu vakarovo isa sa pojai na veveina i Boazi perangaina. Poni sa kukua i Boazi sisa, <<Ei, qua tinoni, mei keqo lame toqo mai lani,>> saunia. Poni sa keqo lao toqo sisa. ");
INSERT INTO lga_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Beto sa sa kuku tekuria i Boazi sa ka manogaputa tinoni mamata pana gusu ko pira sauniria, <<Mu lame somana toqo,>> sauniria. Poni qai lao toqo. ");
INSERT INTO lga_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Beto sa parangia i Boazi sa na tinoni kopu vakarovo, pira sau, <<Koleona sa kai kobu peso tana tavitida i Elimeleki, ko i Naomi isa sa sa mule kamu koko pa Moabi sa sa nyorogua vavainia sa na kobu peso. ");
INSERT INTO lga_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ko ara qa rovea sa ma vapagala votua pa talingimu ao ko mu vai tekua pa moedi ira qai korapa toqo aipira beto pa moedi ira na tinoni mamata aipira qau. Ko vei muna kopu vakarovia sa mu kopu vakarovia, goto vei muneke kopu vakarovia sa pori vei mugunisiu ko ma gigilai, ura kepore mule sa kame mina boka kopu vakarovia goto ao gu beto ko pa ligumu ao sa ara gu mule sa mana boka kopu vakarovia,>> sau. Poni sa paranga sa na tavitina, <<Ara mana kopu vakarovia sina,>> sau. ");
INSERT INTO lga_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Poni sa paranga si Boazi, <<Ego na ranena muna vai tekua ao pa limana i Naomi beto pa limana i Ruti na rereko Moabi sa na kobu peso api, poni sa i Ruti na nabokona i Maloni ba qu tekua tugu vei ao, ko na kobu peso sa mina gore vei pana tutina na marenena sa tei mate tu ko na isongona minake lumu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Poni pira sau sa na tavitina, <<Mina vei isa sa ara manake boka vai teku kopunia sa na kobu peso, ura kita ma valumuria sira na isisongo bai gore lao vei tadira na tuqu. Ko mu tekuamua ao na qua neqi kopu vakarovo ara, ura ara manake boka kopu vakarovonia,>> sau. ");
INSERT INTO lga_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Ego pa moa sa pira sa vei sa na tututi tadira pa Izireli totonai kai tinoni bi kopu vakarovia na isisongo babi bai vaibei isisongo, poni sa kame sa unusu vagorea sa nona buti beto sa vania sa na tinoni pa kai kalena. Ko pa Izireli sa totonai qai roiti vei inara sa sa tavatoqo vamauru sa doru paparanga. ");
INSERT INTO lga_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ko sa vei sa na tinoni kopu vakarovo pira saunia si Boazi, <<Mu vai tekuamua ao,>> sau, beto sa unusu vagorea sa na ona buti. ");
INSERT INTO lga_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Poni sa pira sauniria i Boazi sira na tinoni mamata beto ko ira doru qai somana pana vaikamu, pira sau, <<Pa ngeni api qu bati vasosotoa agou sa ara qa vai teku visua pana limana i Naomi sa doru sakasava tai Elimeleki beto doru sakasava tadira Kilioni beto i Maloni. ");
INSERT INTO lga_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Beto ko i Ruti na rereko Moabi, na nabokona i Maloni, sa qa vai teku tugu vei ara ko mina maqotaqu, ko na isongona na marenena beto na ona isisongo sa minake lumu pa ona bubutu beto pa ona gugusu. Agou sa qu batini matamiu pa ngeni,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Poni pira qarigu sira doru tinoni pa ia vavaikamuna beto ira na tinoni mamata, <<E! Agei qe doroni matamei. I Iahova mi manania sa na rereko sa lame togasa pana mua tatamana, ko mi vei i Resolo beto i Lia, ira karu qai vaijokia na bubutu Izireli. Mu kai tinoni puramu pa Eperata beto mi pore isongomu pa Betilihema. ");
INSERT INTO lga_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Pana tana rereko api i Iahova mina vanigo ira na tutimu ko na mua tatamana mi vei na tatamana tai Perezi, na tuna i Jiuda qi vaporenia tai Tama,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Ko i Boazi sa tekua ko sa alavia na maqotana si Ruti. Totonai sa puta tavitia poni i Iahova sa vabokai si Ruti ko sa bogata beto sa vaporea kai koburu marene. ");
INSERT INTO lga_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Poni qai parangia i Naomi sira na rereko, pira qarigu, <<I Iahova mi tavatarasae. Pa ngeni api sake valumua na mua tinoni kopu vakarovo. Mina kai tinoni pore isongona pa Izireli sisa. ");
INSERT INTO lga_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ko isa kode mina vangangali beia na mua toa beto ko isa tugu sa mina kopunigo totonai muna qoele ao, ura na roamu isa sa roroqu vivitigigo sa sa vaporea sa na koburu api ko na roamu alepi sa sa poreveveina jolania isa bai boka roitinia ka vitu tamatasi marene,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Ko sa tekua i Naomi sa na koburu ko sa geria beto sa kopu pausia. ");
INSERT INTO lga_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Ira na rereko gugusu qai vakukunia na isongo sa na koburu, pira qarigu, <<Kopira i Naomi sa isongia kai koburu marene,>> qarigu. Ko qai vakukunia i Obedi sa na isongona. Ko i Obedi isa sa na tamana i Jese, isa i Jese na tamana i Devita. ");
INSERT INTO lga_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Api sa na tututi tai Perezi. I Perezi sa sa vaporea si Hezironi. ");
INSERT INTO lga_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","I Hezironi sa vaporea si Rami, i Rami sa vaporea si Aminadabi. ");
INSERT INTO lga_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","I Aminadabi sa vaporea si Nasoni, i Nasoni sa vaporea si Salamoni. ");
INSERT INTO lga_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","I Salamoni sa vaporea si Boazi, i Boazi sa vaporea si Opeti. ");
INSERT INTO lga_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","I Opeti sa vaporea si Jese, ko i Jese sa vaporea si Devita.");
INSERT INTO lga_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Ego sa lame tai Jona na tuna i Amitai sa na paranga tai Iahova, pira sau, ");
INSERT INTO lga_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","\"Mu qaqiri! Mu taloa sae pa gugusu lavata pa Ninive, ko mu kuku tariniagana na vinakilasa ura qai vadogoronisiu na toa ikerena,\" sau. ");
INSERT INTO lga_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Ba sa qaqiri tu si Jona ko mi uku riuona tu pa Tarasisi ko mi uku paenia si Iahova sau. Ko sa gore pa Iapo ko sa batia sa kai vaka korapa qaqiri toka riuona pa Tarasisi sau poni sa tabaria na ona pasisi beto sa gore koi pa vaka ko mi somana tuti riuria sira mai riu pa Tarasisi qarigu ko mi ukunia si Iahova sau. ");
INSERT INTO lga_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Poni sa lao tu i Iahova ko sa ipa gorenia pa kolo sa kai gava lavata ko sa toga pa kolo sa na ranebongi lavata ko na vaka tu ba mi tapipiara tu sau. ");
INSERT INTO lga_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Ko qai matagutu neneqere sira na boe pa vaka ko qai okoto kiu alili laoria sa na okokoto dia tamasa, beto qai ipa vovoleniria pa kolo sira na susurana pa vaka ko mi kopele na vaka qarigu. Goto i Jona totonai sa sa tei gore tu korapa puta mumagana pa puruna na vaka. ");
INSERT INTO lga_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Poni sa gore bati poai na kapini pa vaka sisa, ko sa pira saunia, “Qokolo! Na sa qu korapa puta nyanyalunia lani sao? Gasa tatakole! Kiu alili laoa na mua Tamasa! Kita pu na Tamasa isa mina doro roroqugita ko tanake mate manyao,” saunia. ");
INSERT INTO lga_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Ego liguna isa sa qai mekarai vaiparanga vei pira sira na boe pa vaka, “Koi, aria ko ta gonania na patu vivile ko ta nyaqo votunia moko sa i sei sa sa vagosoronigita gita sa na tapata ikerena api,” qarigu. Ko totonai qai gonania sa na patu vivile qarigu poni sa na patu vivile sa ulenia si Jona. ");
INSERT INTO lga_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Ko pira qarigunia ira sisa, “Mu siqarai ulule! I sei sa vagosoronigita sa na tapata ikerena api? Na sa na mua roiti sao? Pai na koko veimu? Pai na mua gugusu? Na tinonimu pai sao?” qarigunia. ");
INSERT INTO lga_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Poni pira sau si Jona, “Na tinoni Hiburu sara, ko i Iahova na Tamasa pa noka isa sa vapodakia na kolo beto na peso pidilina sa qa vatarasaea ara,” sau. ");
INSERT INTO lga_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Ko sa ule vaniria sa isa sa korapa ukunia si Iahova sauniria, ko qai koni gigilai sa vei isa ko qai vakamuniria na matagutu lavata sira na tinoni pa vaka, ko qai pojania sisa, “Qokolo, ai sa vei ko qu roiti vei tu inara sao?” qarigunia. ");
INSERT INTO lga_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Ego sa viva tu lalaona sa na ranebongi pa kolo, ko pira qarigunia, “Ko ai mene aru veinigo agei sao beto mina makogore sa na kolo,” qarigunia. ");
INSERT INTO lga_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Poni pira sauniria, “Mu ovulusiu sara ko mu ipa gore palenisiu pa kolo beto kode mina makogore sa na kolo, ura kopira qa gigilai ara sa ara tugu qa vagosoronigou sa na ranebongi lavata api,” sauniria. ");
INSERT INTO lga_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Ba ira na tinoni pa vaka sa qai geuru vasuvunia sa na qelu sa totonai ko mai popodeke tu mule paro pa poanana qarigu, ba qaike bobokagadia ura na ranebongi sa rajaria pa kolo sa viva tu lalaona. ");
INSERT INTO lga_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Poni qai kiu alili laoa i Iahova, pira qarigu, “Kei, muke veinigei, Iahova! Muke vagosoronigei na mate agei sa na toa tana tinoni api. Muke vateku tarinigei na tinajutu agei na orungu liaburuna, ura ao Iahova sa isa vei qu tavaraguania sa qu roitinia gu,” qarigu. ");
INSERT INTO lga_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Beto qai ovulia si Jona ko qai ipa volenia pa kolo poni sa ipuru gore mate sa na ranebongi pa kolo. ");
INSERT INTO lga_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Totonai sa vei inara poni sa kamuria na matagutu lavata sira na tinoni ko qai matagutunia si Iahova beto qai vavakukuvu beto qai maulu lao tai Iahova. ");
INSERT INTO lga_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Ego sa vatanai i Iahova sa kai igana lavata ko sa ponyolia si Jona, ko i Jona sa pa leo iapana tu na igana sa kole suvere kue rane beto kue bongi. ");
INSERT INTO lga_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Ego ko pa leo iapana tu na igana sa sa vavara lao tai Iahova na ona Tamasa si Jona, ");
INSERT INTO lga_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","pira sau, “Tonai qa gosoro tapata qa kiu alili lao tai Iahova, poni isa sa oesiu; pa puruna na ia tadira na tinoni matedi qa kekebo saea na vaitokai, poni ao qu nongoria na ovovolequ. ");
INSERT INTO lga_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Qu ipa gorenisiu pa matana na kolo lilisina ko na nyoro ranebongi sa lilonisiu, na ololobagea beto na bobogusu qu garunuria qai tapupujaka tarisiu. ");
INSERT INTO lga_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Pira qa rove vei sina, Qa tagona pale pa moemu ao sara; ai mana vei mana boka enga lao pa mua zelepade madina, qau. ");
INSERT INTO lga_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Na kolo sa amu vakujusiu, na lilisi sa ude dorurusiu. Na buburu ivere qai pilua na batuqu. ");
INSERT INTO lga_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Pa totogasadi na kuta kukubo qa gore toga; ira na toba kole jolana na peso qai patei tarisiu. Ba, ao Iahova na qua Tamasa, qu kao votunia pa pou tomate na qua toa. ");
INSERT INTO lga_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Mi loasiu gu sau na singo poni ao Iahova qa roqu kamugo. Na qua vavara sa lao tamu, sa lao pa mua zelepade madina. ");
INSERT INTO lga_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ira qai aru tamanaria na dia beku nyunyaladi sa qai kilu palenia na dia vairoqu jongana. ");
INSERT INTO lga_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Goto ara mana ovelainia na paranga jongana totonai mana vavakukuvu lao tamu. Isa qa maulu laonia tamu sa mana vagore votua. Na inalo sa na koko lame veina tai Iahova,” sau si Jona. ");
INSERT INTO lga_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Poni sa parangia i Iahova sa na igana ko sa lua votunia pa poanana si Jona. ");
INSERT INTO lga_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ego sa lame tai Jona na vinarua totoso sa na paranga tai Iahova, pira sau, ");
INSERT INTO lga_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Mu qaqiri! Mu taloa sae pa gugusu lavata pa Ninive, ko mu kuku tariniagana sa na nongoro qa ule vanigo ara,” sau. ");
INSERT INTO lga_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Poni sa turu si Jona ko sa riu pa Ninive isa vei sa pojai i Iahova. Ego pa Ninive sa na gusu lavata piru, papada kue rane tu na rerege karovona karu uquna. ");
INSERT INTO lga_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Ego sa podalai tome reregia i Jona na rane momoe sa na gugusu, ko sa kukuku vevela, pira sau, “Ka madengavuluputa rane gu sa kole beto sa mina tapipiara sa pa Ninive!” sau. ");
INSERT INTO lga_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Poni sa qai vasosotoa ira na tinoni pa Ninive sa na Tamasa, ko qai kukuku lekogonia sa na nongoro ko na ikete na lavata sa mai noso gagani beto mai udeniria na baiki rorovodi qarigu. ");
INSERT INTO lga_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ego ko totonai sa kamu tana bangara pa Ninive sa na nongoro poni sa sa iolo pana ona totoqona bangara sisa, sa ujolo vagore palea nona poko bangara beto sa udenia na baiki rorovona ko sa gona toqona pa kukudu kavuna. ");
INSERT INTO lga_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Beto sa garunu valekogia pa Ninive isa sa na nongoro, pira sau: Na sogara tana bangara beto ira nona iviva lavata sapi: Kepore kai tinoni babi na papausu made nenedi, na bulumakau babi na sipi, mina meai kai sa. Ira doru maike gagani beto maike isongo bukua na pie. ");
INSERT INTO lga_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Goto mai udeniria na baiki rorovodi sira na tinoni, na papausu made nenedi beto ko mai kiu alili viviva lao tana Tamasa, beto mai okoto gabala loa paleria sira na dia uana beto na roiti ikeredi. ");
INSERT INTO lga_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Uba tu! Kita pu gabala kale ko mi bei roquna na Tamasa ko mi balinga loai nona kokora manginina! Mina vei isa sa gita tanake manyao! sau. ");
INSERT INTO lga_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Ego ko qai gabala loa paleria ira sira na dia uana ikikeredi ko sa batia na Tamasa sa na dia roiti, poni sa bei roquna sa na Tamasa ko isa na vinakilasa ikerena mina vaganiniria saunia perangana sa sa sake roiti vagore votunia. ");
INSERT INTO lga_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Ego poni sa sa ikeria i Jona sa na ikere lavata api ko sa vatekunia kai kokora lavata. ");
INSERT INTO lga_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ko sa vavara lao sa tai Iahova, pira sau, “Notuo, Iahova! Inana sa kode mina vei qaunia ara perangana tu totonai qa korapa suverequa pa qua gusu ara! Ko sa soni vei gu sa ma uku riuqua pa Tarasisi qau! Ura qa gigila vataleaqua ara sa ao sa na Tamasa vaitavaragua, sa kolego na vairoqu jongana, quke oqani tagigiri beto qu isongia na bulo vairoqu ko qu boka beia na roqumu ko qu boka aru mulenia na vinakilasa ikerena muna garunu tariniria qugu. ");
INSERT INTO lga_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Ko, Iahova, kopira sa mu teku palenia gu ropi sa na qua toa, ura mana mate ara sa sa jongana jolania mana toa lalaoqua!” sau. ");
INSERT INTO lga_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Poni pirasau i Iahova, “Ai vei, na tuvisina tugu sa na tagigiri tamu?” sau. ");
INSERT INTO lga_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Ego sa votu lao pa peguruna na gugusu si Jona ko sa lao suvere vei pa kale sagere tapo pa gugusu isa. Ko ketakoi sa vaturua kai ona aqaqo ko sa toqo ongu pa leona ko sa verania tinganai mina batia sa isa mina vei na gugusu isa sau. ");
INSERT INTO lga_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Poni sa vatanai i Iahova na Tamasa sa kai buburu gasoro ko sa vapidokia ko sa toa sae pa narena i Jona ko sa vaongua sa na batuna i Jona ko sa vamalibua sa na vitigi ikerena sa gosoria isa. Poni sa tekunia tu kai qera lavata i Jona sa na buburu gasoro isa. ");
INSERT INTO lga_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Ego sa vatanai na Tamasa sa kai mumuno ko totonai sa sagere na vovola rane poni sa lao tu na mumuno ko sa gania sa na buburu gasoro isa ko sa malei mateona sa na buburu gasoro. ");
INSERT INTO lga_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Totonai sa sagere sae na tapo poni sa vatanai na Tamasa sa na gava dadangana koko veina pa sagere tapo beto ko na tapo sa gonai na batuna i Jona ko sa digere tabulonia tu. Poni sa tepa toa ko mi mate kikisuona sau, pira sau, “Mana mate ara sa sa jongana jolania mana toa lalaoqua!” sau. ");
INSERT INTO lga_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Poni sa paranga lao tai Jona sa na Tamasa, pira sau, “Ai vei, na tuvisina tugu sa na tagigiri tamu veveina na buburu gasoro ina?” sau. Poni pira sau i Jona, “E! Na tuvisina tugu sa na tagigiri taqu ko tinganai mana matequa,” sau. ");
INSERT INTO lga_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Poni sa paranga si Iahova, “Koi e. Ko ao qu doro roroqua na buburu gasoro api, isa quke ipata talenia beto nake ao qu valavatia, isa sa pidoko sae na bongi ko sa ipu meka gu beto sa mateona! ");
INSERT INTO lga_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Goto ara ai vei, manake doro roroqua ara sa na gugusu lavata pa Ninive ketakoi qai suvere ira soku papausu mamade nenedi beto jolania kai gogoto rabeteputa tina tinoni qaike boka doro gigalia na lima matuadi pana meridi?” sau.");
INSERT INTO lga_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Api sa na kutina na tutina i Jisu Karisito isa na tutina i Devita isa na tutina i Ebarahami. ");
INSERT INTO lga_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","I Ebarahami qi vaporea i Aisake, ko i Aisake qi vaporea i Jekopi, ko i Jekopi qi vaporea i Jiuda beto ira na tasina na tugana marene. ");
INSERT INTO lga_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","I Jiuda qi vaporeniria tai Tama sira Parezi i Zara, i Parezi qi vaporea i Gezironi, ko i Gezironi qi vaporea i Rami. ");
INSERT INTO lga_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","I Rami qi vaporea i Aminadabi, i Aminadabi qi vaporea i Nasoni, ko i Nasoni qi vaporea i Salamoni. ");
INSERT INTO lga_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","I Salamoni qi vaporenia tai Regabi i Boazi, i Boazi qi vaporenia tai Ruti i Obedi, ko i Obedi qi vaporea i Jese, ");
INSERT INTO lga_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ko i Jese sa qi vaporea i Devita na bangara. Ko i Devita qi vaporenia tana maqotana i Uria si Solomone. ");
INSERT INTO lga_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","I Solomone qi vaporea i Roboama, i Roboama qi vaporea i Abija, ko i Abia qi vaporea i Asa. ");
INSERT INTO lga_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","I Asa qi vaporea i Josapati, i Josapati qi vaporea i Jorama, ko i Jorama qi vaporea i Uzia. ");
INSERT INTO lga_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","I Uzia qi vaporea i Jotama, i Jotama qi vaporea i Agazi, ko i Agazi qi vaporea i Gezekae. ");
INSERT INTO lga_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","I Gezekae qi vaporea i Manase, i Manase qi vaporea i Amoni, ko i Amoni qi vaporea i Josia. ");
INSERT INTO lga_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","I Josia qi vaporea i Jekonia beto ira na tasina marene, totonai qai taraputu lao pa Babiloni ira na tinoni Izireli. ");
INSERT INTO lga_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pa liguna qai taraputu lao pa Babiloni ira na tinoni Izireli sa i Jekonia qi vaporea i Salatieli, ko i Salatieli qi vaporea i Zorobabele. ");
INSERT INTO lga_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","I Zorobabele qi vaporea i Abiuda, i Abiuda qi vaporea i Eliakimi, ko i Eliakimi qi vaporea i Azoa. ");
INSERT INTO lga_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","I Azoa qi vaporea i Zadoki, i Zadoki qi vaporea i Akimi, ko i Akimi qi vaporea i Eliuda. ");
INSERT INTO lga_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","I Eliuda qi vaporea i Elieza, i Elieza qi vaporea i Matani, ko i Matani qi vaporea i Jekopi. ");
INSERT INTO lga_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","I Jekopi qi vaporea i Josepa na marenena i Mere, ko tai Mere sa podo vei si Jisu isa sa tagigala na Karisito. ");
INSERT INTO lga_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ko na anyedi ira doru popodo sasae tinoni koko ti Ebarahami ko sa lame kamu tai Devita sa ka manogamade popodo, ira sa koko tai Devita ko sa lame kamu totonai qai taraputu lao pa Babiloni ira na tinoni Izireli sa ka manogamade popodo, beto sa koko totonai qai taraputu lao pa Babiloni ko sa lame kamu tana Karisito sa ka manogamade popodo. ");
INSERT INTO lga_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ego pira sa vei sa na vavakatona na podona i Jisu Karisito. I Mere, isa na tinana i Jisu, sa perangana tu sa tavaiviva vakole vania i Josepa. Ba totonai qai oqoro mekarai suvere vaikamu ira karu, sa i Mere sa sa tei vaporeni iapana tu na Gagala Tabuna. ");
INSERT INTO lga_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","I Josepa na marenena api sa kai tinoni tuvisina sisa. Ko sake nyogua vavotuni vavakato vaivakeana isa si Mere, ko sa roroqua ko bi koroto golomo palenia isa si Mere sau. ");
INSERT INTO lga_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ba totonai sa korapa rorove vei inara i Josepa, poni sa api sa votu tana pa putagita sa kai mateana tana Bangara, ko pira saunia, <<Josepa, ao na tuna i Devita! Muke matagutu tekua ao si Mere ko mi maqotamu, ura isa sa pidoko pa iapana isa sa na Gagala Tabuna tu sa veinia. ");
INSERT INTO lga_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kode mina vapodoa isa sa kai koburu marene, ko muna vakukunia ao nisongona i Jisu sisa, ura isa kode mina aloria pa dia sela sira na ona tinoni,>> sau sa na mateana. ");
INSERT INTO lga_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ego doru sakasava aipira sa qai taroiti ko qai vagore votua sa na paranga perangana tu sa pojai na Bangara tana tinoni kokorotai i Aisea, pira sau, ");
INSERT INTO lga_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Vainongoro! Kai rereko koregana mina pore iapana ko mina vapodoa kai koburu marene, ko na isongona sa mai vakukunia i Imanuela,>> sau. Na ginuana na paranga Imanuela sa Na Tamasa sa suvere tavitigita. ");
INSERT INTO lga_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pa liguna na putagita sa sa dorava si Josepa ko sa roitinia isa sisa vei sa garununia na mateana tana Bangara ko sa sa tekua isa si Mere ko na maqotana. ");
INSERT INTO lga_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ko sake puta tavitia i Josepa si Mere tinganai sa vapodoa tu isa na tuna marene. Ko sa vakukunia i Jisu isa na isongona. ");
INSERT INTO lga_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ego totonai sa podo i Jisu pa Betilihema pa Jiudia, isa na totoso sa bangara i Herodi, sa api sira kaki tinoni gigigalai qai taloa koko vei pa kale sagere tapo ko qai bola pa Jerusalema, ");
INSERT INTO lga_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ko qai nanasa, pira qarigu, <<Ai sa na koburu sa podo bangara tadira na Jiu? Qe nanasa ura qe batia pa kale sagere tapo agei sa na seru tana, ko qe kamu ko me vetarasaea isa qeu,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ego totonai sa nongoria i Herodi sa na veveina isa, sa sa takulanga sisa beto ko ira dorudi pa Jerusalema. ");
INSERT INTO lga_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ko sa kuku vaikamuniria i Herodi sira na kuta iama beto ira na tinoni vaivagigalai tadira na tinoni, ko sa nanasaria, <<Pai mina podo sa na Karisito?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Poni sa pira qarigunia, <<Pa Betilihema pa Jiudia, ura api sa sa korotonia na tinoni kokorotai, ");
INSERT INTO lga_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<Ao Betilihema pa ia pa Jiudia. Ao nake goboromu tadira na gugusu mamata pa Jiudia, ura tamu mina votu lame vei sa kai mamata isa mina pausuria sira na qua tinoni Izireli,> sau,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Poni sa kuku kaleniria i Herodi sira na tinoni gigigalai, ko sa nyaqo votunia tadira sa na totoso sa bola votu na seru. ");
INSERT INTO lga_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Beto sa sa garunu goreniria pa Betilihema, pira sauniria, <<Mu gore nyaqo votu vatalenia agou sa na veveina na koburu. Ko isa tugu muna batia, sa muna ule vanisiu, ko ara ba mana somana gore vatarasaea tugu vei,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pa liguna qai nongoria na bangara poni sa qai taloa riu sira na tinoni gigigalai aipira. Ko api sa na seru, isa qai batinia pa kale sagere tapo perangana, sa sa toniria, ko tinganai sa lao turu vanoso pa narena totona ketakoi sa kole na koburu. ");
INSERT INTO lga_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ko totonai qai batia na seru sa qai qera vivitigi. ");
INSERT INTO lga_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ko qai tome lao pa ruma poni sa qai batia sa na koburu beto i Mere na tinana. Ko qai gona toqo sori tutungu ko qai vatarasaea sa na koburu, beto sa qai raua sa na dia baiki vaivana ko qai vania na qolo, na parakenisenisi beto na moa sa na koburu. ");
INSERT INTO lga_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Beto sa voturia pana putagita sa na ule vabalau ko maike mule sae tai Herodi sauniria, ko qai tutia na goto soana tu ko qai mule riudia pa dia gugusu sira na tinoni gigigalai. ");
INSERT INTO lga_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ego pa liguna qai taloa riudia ira na tinoni gigigalai pira, poni api sa votu tai Josepa pa putagita sa na mateana tana Bangara, ko pira saunia, <<Mu turu, mu tonia sa na koburu beto na tinana ko mu uku riu pa Ijipi, ko mu suvere ketakoi tinganai mana parangigo mule ara. Ura i Herodi sa mi nyaqoa sa na koburu inana ko mi vamatea sau,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Poni sa turu si Josepa, sa tonia sa na koburu beto na tinana na bongina tugu isa, ko sa taloa riuona pa Ijipi. ");
INSERT INTO lga_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ko sa suvere ketakoi sisa ko tinganai sa mate tu i Herodi. Ko sa gore votu sa na paranga sa pojai na Bangara tana tinoni kokorotai, pira sau, <<Pa Ijipi qa kuku votunia ara sa na tuqu marene,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ego totonai sa gigilai i Herodi sa ira na tinoni gigigalai sa qai vagonai gu sisa, sa sa tagigiri vivikerenia. Ko sa vaigarunu ko mai vai vamate paleria sira doru koburu marene pa Betilihema beto pa gugugusu vailivutaina, ira koburu karu aorodi ko mi gore tadira na melalu sau. Na anyena na aorodi ira na koburu sa sa padania isa podalai tugu na totoso sa nyaqo votunia isa tadira na tinoni gigigalai. ");
INSERT INTO lga_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ko sa gore votu sa na paranga sa lame vei tai Jeremae na tinoni kokorotai, pira sau, ");
INSERT INTO lga_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Kai ovovele sa tanongoro pa Rama, na lukana uui beto na kekebo. I Resolo sa lukanaria na tuna, ko sa daiona tavamanoto ura qai manyao sira,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ego ko pa liguna sa mate i Herodi, sa api na mateana tana Bangara sa votu pa putagita tai Josepa pa Ijipi, ");
INSERT INTO lga_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","pira sau, <<Mu turu, mu tonia sa na koburu beto na tinana ko mu mule pa peso pa Izireli, ura qai tei mate tu sira qai nyaqoa na toa tana koburu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Poni sa turu si Josepa, sa tonia sa na koburu beto na tinana ko sa mule pa peso Izireli. ");
INSERT INTO lga_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ba tonai sa nongoronia i Josepa sa i Akiliasi sa sa beia si Herodi na tamana ko sa bangara pa Jiudia qarigu, sa sa matagutu mule suvere ketakoi sisa. Ko tonai sa votu pa putagita sa na ule vabalau poni sa taloa riu vei pa pikata gugugusu pa Qalili tu. ");
INSERT INTO lga_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ko sa sae suvere pa gusu na isongona pa Nazareti. Ko sa gore votu sa na paranga sa gore vei tadira na tinoni kokorotai, pira qarigu, <<Mina tagigala na tinoni Nazareti sisa,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ego ko pana rane ira sa sa votu lame si Jone Paputaiso, ko sa podalai tarae pa qega pa Jiudia, ");
INSERT INTO lga_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","pira sau, <<Mu gabala agou! Ura mi toga sau sa na binangara pa noka,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","I Jone tugu alepi sa sa korotonia i Aisea na tinoni kokorotai, tonai pira sau, <<Kai ovovele sa vevela pa qega, pira sau: <Vatanai na soana tana Bangara! Vaemeseria na soana mina reregeria isa,> sau,>> sau si Aisea. ");
INSERT INTO lga_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ego ko i Jone na ona poko sa na vurungudi gu na kameli, na ona doko sa na kopo vulitini manugu mamade nenedi gu, beto na ona tetekuna sa na kupo beto na muji pirudi gu. ");
INSERT INTO lga_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ko qai vovotu lao tana sira pa Jerusalema, ira doru pa Jiudia beto ko ira doru pa vailivutaina pa pie Jodani. ");
INSERT INTO lga_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ko qai vavaja votuniria na dia sela beto i Jone sa paputaisoria pa pie Jodani. ");
INSERT INTO lga_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ba totonai sa batiria i Jone sa na motadi ira na Parese na Sadusisi sa qai lame ko mi paputaisoria isa qarigu, poni sa pira sauniria isa sira, <<Boko tuni dole ikikeremiu! I sei sa pojanigou sa kode muna boka ukunia agou sa na vinakilasa sa korapa jojoro lame? ");
INSERT INTO lga_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mu roiti votuniria sira na vua qai ulenia na toa gabalana. ");
INSERT INTO lga_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kita mu rove sianania sa na tamamei agei si Ebarahami kita mugu. Ma pojanigou gu ara sa na Tamasa sa boka gu pelukuniria na tuna i Ebarahami sira na patu pira! ");
INSERT INTO lga_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Na rio sa sa tei tana koleona tu pa bageredi na gou. Ko doru gou qaike vuania na vua jongana sa mai taduka vagore ko mai tagona lao pale pa iku. ");
INSERT INTO lga_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ara sa qa paputaisonigou na kolo ko na vagigilana na toa gabalana, ba isa tu sa tuti ligu lamesiu ara sa sa poreveveina jolanisiu ara, ko ara ba nake padaqu mana pogoso vania na sadolo sisa. Isa tu sa mina paputaisonigou na Gagala Tabuna beto na iku. ");
INSERT INTO lga_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Na sevolo vavaipikatai sa sa tei arunia tu pa limana ko mi pikata paleniria sau sira na kopo ikika pa ia iru vaipipikatainiria ira na kiko, ko mi boko vaikamuniria pa ia vavakoleni kiko sira na kiko jongadi beto mi vurungu paleniria pa iku ilili kare sira na nyanyaodi na kiko sau,>> sau si Jone. ");
INSERT INTO lga_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ego sa kamu koko pa Qalili si Jisu ko sa gore pa pie Jodani ko mi tapaputaiso tai Jone sau. ");
INSERT INTO lga_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ba i Jone sa podeke vanosoa sisa, pira saunia, <<Ara tu sa na selaqu ko muna paputaisosiu ao, ba ai sa vei sa ao tu qu lame taqu?>> sau. ");
INSERT INTO lga_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ba sa oe laoa i Jisu sisa, <<Loai ko mi vei kopira, ura pa soana vei api tana vagore votua gita sa doru tuvisi,>> sau sisa. Poni sa vasotoa i Jone sisa. ");
INSERT INTO lga_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ko isa tugu sa tapaputaiso ko sa iolo loai na pie si Jisu, poni sa api sa tarevanga vania isa sa na oka, ko sa batia isa sa na Gagalana Tamasa sa igoro gore lagere vei kai kuru ko sa lagere togai sisa. ");
INSERT INTO lga_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Beto api sa kai ovovele sa koko lagere vei pa noka, pira sau, <<Api sa na Tuqu qa roroqua ara; isa qa qera vivitiginia ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ego pa liguna isa sa toni saenia pa qega na Gagala Tabuna si Jisu ko mi totokea na bangaradi na tomate sau. ");
INSERT INTO lga_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ko sa tatabu gagani ka madengavuluputa ranena beto madengavuluputa bongina sisa, ko sa burana. ");
INSERT INTO lga_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ko totonai sa kamu sa na bangara totoke, ko pira saunia sisa, <<Vei muna na Tuna na Tamasa sao, sa mu parangaria na patu pira ko mai peluku bereti,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ba sa oea i Jisu sisa, pira sau, <<Sa paranga sa na Kukuti Tabuna, <Nake bereti gu mekana sa toania sa na tinoni, goto doru paranga tu sa ovelainiria na Tamasa!> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ego beto sa toni laonia na bangaradi na tomate pa gusu tabuna pa Jerusalema si Jisu, ko sa vaturua pa are babanana na kakabarena zelepade, beto pira saunia, ");
INSERT INTO lga_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","<<Vei muna na Tuna na Tamasa sao, sa mu soqolo gore! Ura pira sau sa na Kukuti Tabuna, <Isa mina garununigo ira na ona mateana sao, ko mai kalonigo na limadi, ko na nenemu minake tupania pa patu,> sau,>> sau na bangaradi na tomate. ");
INSERT INTO lga_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Poni sa oea i Jisu sa na bangaradi na tomate, pira saunia, <<Pira mutu sau sa na Kukuti Tabuna, <Muke podekia na Bangara na mua Tamasa!> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Poni sa toni saenia mule na bangaradi na tomate pa kai kubo ululuna si Jisu, ko sa vabatinia doru binangara pa kasia gusu beto na dia neqi lalavatadi. ");
INSERT INTO lga_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Beto pira saunia si Jisu, <<Dorudi aipira sa ao mana vanigo, vei muna vukele gore ko muna vatarasaesiu ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Poni sa oea i Jisu sisa, <<Mu riu vasou, Setani! Ura pira tu sau sa na Kukuti Tabuna, <Na Bangara na mua Tamasa gu mu vatarasaea, beto isa gu mekana mu nabulunia!> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Poni sa sa taloa riu sa na bangaradi na tomate, ko api sira na mateana qai kamu ko qai tokania i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ego totonai sa nongoronia sa i Jone sa qai tei vatomea tu pa ruma vaipiu qarigu, poni sa sa taloa riu veiona pa Qalili si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ko sa iolo loai sa pa Nazareti ko sa gore suvere vei pa Kepaniami pa keketai ovuku pa Qalili, pa pikata ia pa Zabuloni beto pa Naputalai. ");
INSERT INTO lga_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ko sa gore votu sa na paranga sa pojai i Aisea na tinoni kokorotai, pira sau, ");
INSERT INTO lga_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Na peso Zabuloni beto na peso Naputalai, na soana vei pa ovuku, pa karovona pa Jodani, pa Qalili tadira na tinoni karovodi. ");
INSERT INTO lga_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ira na tinoni qai suvere pa rodomo qai batia kai kabere lavatana. Ira qai suveria na ia sa angovia na ongongu mate sa goreria na kabere,>> sau i Aisea. ");
INSERT INTO lga_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Podalai na totoso isa sa podalai tarae si Jisu, pira sau, <<Mu gabala agou! Ura mi togagita gu sau sa na binangara pa noka!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tonai sa korapa popoanaona pa ovuku Qalili si Jisu, poni sa batiria sira kao tamatasi ira Saimone isa sa tavaisongo i Pita beto i Aduru na tasina. Qai korapa vaqaradia pa ovuku, ura na tinoni abu sira karu. ");
INSERT INTO lga_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ko pira sauniria i Jisu sira karu, <<Mei, lame! Tutisiu, ko ma roitinigou na tinoni abu tinoni,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na totoso tugu isa qai loa paleniria ketakoi ira karu sa na dia vaqara, ko qai lao tutiadia si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ego ko sa jola lao poni sa sa batiria gu mule i Jisu sira karu goto tamatasi, ira Jekopi beto i Jone, karu tuna marene i Zebeti. Qai korapa tugu koi tavitia pa koaka sa na tamadi i Zebeti, ko qai korapa oke tuvakaria na dia vaqara, poni sa sa kukuria i Jisu sira kao tamatasi ira. ");
INSERT INTO lga_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Na totoso tugu isa sa qai loa paleniria ira karu sa na dia koaka beto na tamadi, ko qai lao tutiadia si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ego ko sa lekogoria i Jisu sa doru ia pa Qalili, ko sa kole vavaivagigalai pa dia ruma vavaikamudi, sa taraenia na nongoro jongana na binangara tana Tamasa beto sa salana paleria isa sira doru mo beto na vagauru qai koleria na tinoni. ");
INSERT INTO lga_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ko na nongorona i Jisu sa sa lekogia na doru ia pa Siria. Ko qai toni kamuniria tana sira doru sa koleria na okokoto mo vagauru, ira qai gosororia na vitigi lalavata, ira sa tomeria na tomate ikikeredi, ira qai kikirenge, beto ira sa mate kale kokobu tinidi. Ko sa salana betoria i Jisu sira doru. ");
INSERT INTO lga_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ko qai tutia i Jisu sa ira na minete lavata koko veidi pa Qalili, pa Manogagusu, pa Jerusalema, pa Jiudia, beto pa kai karovona Jodani. ");
INSERT INTO lga_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Totonai sa batiria i Jisu sira na minete tinoni, poni sa sa kesa sae pa kukubona. Ko totonai sa toqo isa poni sa qai lame vavaikamu tana sira na ona sepele. ");
INSERT INTO lga_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Poni sa sa podalai vagigalairia isa sira, pira sau: ");
INSERT INTO lga_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Qai tamana sira qai golaba pa gagala, ura tadira sa na binangara pa noka. ");
INSERT INTO lga_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Qai tamana sira qai takulanga, ura mai tavamanoto sira. ");
INSERT INTO lga_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Qai tamana sira qaike tuara, ura ira mai teku isongia na kasia abana. ");
INSERT INTO lga_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Qai tamana sira qai burana kidepenia na tuvisi, ura ira mai pote vatale. ");
INSERT INTO lga_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Qai tamana sira qai vairoqu vaitokai, ura ira mai taiania na vairoqu vaitokai. ");
INSERT INTO lga_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Qai tamana sira sa lioso na bulodi, ura ira mai batia na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Qai tamana sira na tinoni vavaivabule, ura ira mai tapoja na tuna na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Qai tamana sira qai takomitinia na tuvisi, ura tadira sa na binangara pa noka. ");
INSERT INTO lga_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Qu tamana sagou tonai qai poja vivikeregou, qai komitigou beto qai jutu seseke tarinigou doru kai ikerena pana laequ ara. ");
INSERT INTO lga_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mu qera ko mu qera vivitigi tu, ura na miu pinia pa noka sa lavata jola. Ura ira na tinoni kokorotai pa moa ba qai komiti veiniria tugu inara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","<<Agou sa na solona na kasia abana. Ba totonai mina maragutu na lilingina sa na solo, poni sa ai mule mina vei beto mina boka lilingi solo ligu sisa? Totonai sa sa kepore veveina sisa, goto na padana sa mina tagona votu pale gu pa peguru, ko mai tete anyanyunia gu na tinoni. ");
INSERT INTO lga_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Agou sa na kaberena na kasia gusu. Na gusu sa toqo pa batuna na kubo sa sake boka pae. ");
INSERT INTO lga_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kepore sa kai tinoni sa vatoaia na juke beto sa vatoqo pale pa kauru kadakita. Goto sa vatoqoa tu pa totoqona juke isa sa na juke, ko sa tolanga vaniria sira doru pa leo ruma. ");
INSERT INTO lga_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ko agou ba mi tolanga vatale tu sa na miu kabere ko ira na tinoni mai batiria na miu roiti jongadi, ko mai vatarasaea sa na Tamamiu pa noka,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<Kita mu roroqua agou sa ara qa lame ko ma jegaria sa na Vavanau tai Mosese babi na vaivagigalai tadira na tinoni kokorotai qau kita mugu. Ara qake lame ko ma jejegara goto ma vavaokoto tu qau. ");
INSERT INTO lga_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ura ma pojanigou sosoto ara sagou: tinganai mina maragutu sa na oka beto na peso, sa bi mija tu mina mumuri pa Vavanau sa kai leta ikete babi gasi ikete, tinganai mai gore votu beto mai tu sira doru sakasava. ");
INSERT INTO lga_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ko sa vei sa na tinoni sa vakeporea kame ira na kobu garunu ikete aipira beto sa vagigalainiria ira na goto tinoni ko mai veiniria tugu isa, sa mina tapoja na tinoni kepore veveina pa binangara pa noka sa na tinoni isa. Goto na tinoni sa vataberia beto sa vaivagigalainiria, sa mina tapoja na tinoni poreveveina pa binangara pa noka sisa. ");
INSERT INTO lga_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ma pojanigou ara sagou: vei na miu tuvisi minake pugele nyonyoa jolania na tuvisi tadira qai vaivagigalainia na Vavanau beto na Parese, poni sa munake isongo boka tomea agou sa na binangara pa noka,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<Qu tei nongoroniamiu tugu agou sa isa pira sau perangana tadira pa moa, <Munake varivai, beto ko isa sa varivai sa kode mina gosoria na vaituti,> sau. ");
INSERT INTO lga_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ba ara ma pojanigou sagou: na tinoni sa kokorania na tasina sa mina gosoria na vaituti. Isa pira biunia na tasina, <Ao na batu kokove,> biunia, sa mina lao pa koti tadira na tinoni Jiu. Isa pira biu, <Ao na duduvili,> biu, sa mina lao pa iku pa heli. ");
INSERT INTO lga_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ko sa vei sa vei bu korapa vaivanania pa ia vavakukuvuna ao sa na mua vaivana poni sa ketakoi tu sa bu roroqu kamua ao sa kai sela qu roitinia ao tana tasimu, ");
INSERT INTO lga_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","poni sa mu loa vakolea ketakoi pa moena na ia vavakukuvuna sa na mua vaivana ko mu mule riu bulea mai sa na tasimu beto sa mu lao vaivanania sa na mua vaivana. ");
INSERT INTO lga_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mu sisiqarai bulea na mua kana totonai qu korapa lalaomiu pa soana, kita na mua kana mi valaogo tana tinoni vaituti, ko na tinoni vaituti mi valaogo tana na nabulu kopu, ko isa mi gona tomenigo pa ruma vaipiu. ");
INSERT INTO lga_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ma poja sosotonigo ara sao: kode munake isongo votu taloa ketakoi sao tinganai muna lipu vaokotia na poata bebetona,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<Qu tei nongoroniamiu tu agou sa isa pira sau perangana, <Munake babarata,> sau. ");
INSERT INTO lga_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ba ara ma pojanigou sagou: na tinoni sa dodoro nyoroguania gu sa kai rereko iviva, sa sa tei baratia tugu pa bulona isa sisa. ");
INSERT INTO lga_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ko vei na mata kale matuamu ao sa bi vavukeligo, sa mu ujolia ko mu gona palenia. Ura vei kai kobu tinimu ao sa bi takobu pale sa isa sa jongana jolania na tini dorumu ao bi tagona lao pa heli. ");
INSERT INTO lga_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Beto vei na lima kale matuamu ao sa bi vavukeligo ao, sa mu kobua ko mu gona palenia. Ura vei kai kobu tinimu ao sa bi takobu pale sa isa sa jongana jolania na tini dorumu ao bi tagona lao pa heli,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<Ego pira sau sa perangana, <Isa mi loa pale na maqotana sau sa mi vania na pepa vailoa sa na maqotana,> sau. ");
INSERT INTO lga_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ba ara ma pojanigou: na tinoni sake vaiputa taviti goboro na maqotana ba sa loa pale goboro, sa sa vababaratia sa na rereko api beto na marene sa nagoa na rereko sa taloa pale api ba sa babarata tugu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<Qu tei nongoroniamiu mutugu agou sa isa pira sau perangana, <Munake tetea na mua maulu, goto muna vagore votua sisa qu maulu laonia tana Bangara,> sau. ");
INSERT INTO lga_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ba ara ma pojanigou: muke isongo maulu totonai mu roitinia kai taringunguti. Muke maulu lao pa noka, ura isa sa na ona totoqona bangara na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Muke maulu lao pa peso, ura isa sa na ona tetetena na nenena isa. Muke maulu lao pa Jerusalema, ura aza na gugusu tana Bangara lavata. ");
INSERT INTO lga_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Beto muke maulu lao pa batumu, ura kai lage vurungumu gu ba quke boka vakekai babi vakukudea. ");
INSERT INTO lga_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Goto na miu paranga sa mi E gu tonai mi E beto mi Dai gu tonai mi Dai. Goto vei kaki paranga mule muna jokeleniria, poni sa ira na koko veidi gu tana kutana nikerena sira,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","<<Qu tei nongoroniamiu tugu agou sa isa pira sau perangana, <Isa sa vapalekai na matamu sa mu vapalekai na matana, beto isa sa valovea na mua patu sa mu valovea na ona patu,> sau. ");
INSERT INTO lga_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ba ara ma pojanigou: muke raja beini ikerena sa na ikerena. Goto bi poaria kai tinoni na papara kale matuamu, sa mu balinga lao vania mule keta pa kale merimu ao. ");
INSERT INTO lga_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Vei bi nyorogua toni lao rajanigo pa vaituti sa kai tinoni ko mi teku variunigo na mua soti biu, sa mu vamalumu vania tugu vei na mua koti ao. ");
INSERT INTO lga_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Vei kai tinoni bi jujukigo ko mu pogoso vania kai maelo biunigo, sa mu tuti pogoso vania karu maelo tu ao. ");
INSERT INTO lga_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Na tinoni sa tepago sa mu vania, beto na tinoni sa nyorogua tekua gu mai tamu biu sa muke uku peleni tu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<Qu tei nongoroniamiu tu agou sa isa pira sau perangana: <Muna roroqua na tavitimu, beto munake tavaraguania na mua kana,> sau. ");
INSERT INTO lga_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ba ara ma pojanigou sagou: mu roroquria ira na miu kana beto mu vavara tokaniria ira qai komitigou, ");
INSERT INTO lga_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ko mu tuna na Tamamiu pa noka sagou ura isa na ona tapo sa vaalanganiria ira na tinoni ikeredi beto na tuvisidi beto na okoro sa vagoreniria ira na tinoni jongadi beto ira na seladi. ");
INSERT INTO lga_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ura vei ira gu qai roroqugou sa muna roroquria agou, poni na pinia sa muna tekua? Ira gu na tinoni teteku takisi ba qai bokadia roitinia sisa. ");
INSERT INTO lga_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Beto vei muna gosoro qeqeraniria ira na miu baere gu sagou, poni sa qu oqoro roitinia kai sa bi goto sagou. Ira gu na tinoni rodomo ba qai bokadia roitinia sisa. ");
INSERT INTO lga_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ko agou sa mi maladoruru na miu vairoqu vei tugu na Tamamiu pa noka ba sa maladoruru na ona vairoqu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","<<Mu kopunia na miu roiti tuvisina ko muke roitinia pa moedi ira na tinoni ko mu vadogoroniria gu ira. Vei muna vei isa sagou, poni sa mina kepore kai pinia muna tekua tana Tamamiu pa noka sagou,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","<<Ego tonai muna roitinia ao sa kai vaiia tokania na tinoni vaivasevina sa muke kukuvilinia pa moemu. Isa qai roroiti vei pa leo ruma vavaikamuna beto pa soana lavata sira na tinoni vavabatadi, ko mai vatarasaeria na tinoni qarigu. Ma poja sosotonigou ara sagou: ira sa qai tei tekua tu na dia pinia. ");
INSERT INTO lga_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Goto ao tonai mu roitinia sa kai vaiia tokania na tinoni vaivasevina poni sa muke vagigilania na lima kale merimu sa isa sa roitinia na lima kale matuamu, ");
INSERT INTO lga_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ko na mua vaiia tokania na tinoni vaivasevina sa mi taroiti pa paena. Ko na Tamamu sa batia isa qu roitinia pa paena sa mina vanigo na pinia,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","<<Ego tonai muna vavara sagou, sa muke vei ira na tinoni vavabatadi! Ura ira sa qai nyonyogua turu vavara pa leo ruma vavaikamuna beto pa vavaikae soana ko mai batiria na tinoni qarigu. Ma poja sosotonigou ara sagou: ira sa qai tei tekua tu na dia pinia. ");
INSERT INTO lga_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Goto ao tonai mu vavara, sa mu tome lao pa mua lose, mu pateia na mua atakamana, beto sa mu vavara lao tana Tamamu sa suvere pa paena. Ko na Tamamu isa sa batia na roiti qu roitinia pa paena sa mina vanigo na pinia. ");
INSERT INTO lga_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ko tonai mu vavara agou sa muke mijimojaniria kubo paranga qai vevei ira na tinoni rodomo, ura qai roroqua sa sa soku vatale na dia paranga ko kode mina nongororia na Tamasa qarigu. ");
INSERT INTO lga_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Muke doro tutiria sira, ura na Tamamiu sa totonai tu qu oqoro tepai sa sa tei gigilariaona tu isa sira qu qasaniria. ");
INSERT INTO lga_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ko agou sa pira mu vavara vei: <Tamamei, ao pa noka, mi tapangaga na isongomu. ");
INSERT INTO lga_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mu valamea na mua binangara. Mu vagore votua na mua nyorogua, isa sa vevei pa noka sa mu veinia pa peso. ");
INSERT INTO lga_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mu vanigei na tetekuna mene toania pa ngeni. ");
INSERT INTO lga_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mu taleosonigei ira na mei sela, vevei agei qe taleosoniria sira qai roiti lame sela tamigei. ");
INSERT INTO lga_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Muke toni laonigei pa totoke, goto mu vasaregei tana kutana nikerena,> mugu. ");
INSERT INTO lga_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ura vei muna taleosoniria agou sira na sela qai roiti lameniria ira na tinoni tamugou, poni sa na Tamamiu pa noka ba mina taleosonigou tugu sagou. ");
INSERT INTO lga_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Goto vei munake taleosoniria agou sira na tinoni, poni sa na Tamamiu ba minake taleosonigou tugu na miu sela sagou,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","<<Ego tonai muna tatabu gagani sagou, sa muke vadoro takulanga veinigou ira na tinoni vavabatadi. Ira sa qai vadoro bati karea na isumatadi ko ira na tinoni mai batiria qai korapa tatabu gagani sira mariguniria qarigu. Ara ma poja sosotonigou sagou: ira sa qai tei tekua tu na dia pinia. ");
INSERT INTO lga_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Goto ao sa tonai qu tatabu gagani, sa mu lumu vatalea na batumu beto mu subi vatalea na isumatamu. ");
INSERT INTO lga_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ko ira na tinoni maike doro gigilai sa ao qu korapa tatabu gagani, goto na Tamamu gu pa paena sa mi gigilai. Ko na Tamamu isa sa batiria na mua roiti qu roitiniria pa paena sa mina vanigo na pinia>>, sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","<<Muke boko vavaikamumiu isisongo pa peso ketakoi sa boka gani piararia na tamo beto na obu, beto ketakoi qai boka pipiara tome ikoria ira na tinoni ikikodi. ");
INSERT INTO lga_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Goto mu boko vavaikamumiu isisongo pa noka tu ketakoi qaike boka gani piararia na tamo beto na obu, beto ketakoi qaike boka pipiara tome ikoria ira na tinoni ikikodi. ");
INSERT INTO lga_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ura ketakoi sa kole na mua isisongo sa ketakoi tugu sa kole sa na bulomu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","<<Na jukena na tini sa na mata. Ko vei mina jongana sa na matamu, poni sa na tinimu doruna kode mina tolangania na kabere. ");
INSERT INTO lga_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Goto vei mina ikere sa na matamu, sa na tinimu doruna kode mina rodomo. Ko vei na kabere sa kole tamu sa na rodomo gu, poni sa kode mina rodomo kukuni sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","<<Kepore sa kai tinoni mina mekarai nabuluniria karu bangara. Kame sa minake tavaraguani goto kame sa mina roroqua, babi kame kode mina valavatia goto kame sa mina vakepore veveinai. Ko munake boka mekarai nabuluniria agou sa na Tamasa beto na isisongo. ");
INSERT INTO lga_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ko sa vei sa ma pojanigou: muke takulangania na miu toa, na sa muna gania, na sa muna bukua, babi na sa muna pokonia na tinimiu. Na toa tu sa sa poreveveina jolania na gagani, beto na tini tu sa sa poreveveina jolania na poko. ");
INSERT INTO lga_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mu dororia tu agou sira na manugu pa vavagalo eqa: ira sa qaike umuma, qaike ababu, beto qaike aqaqono vaikamu pa ruma, ba na Tamamiu pa noka sa vatetekuria gu sira. Ba agou tu sa qu poreveveina jolaniria na manugu. ");
INSERT INTO lga_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","I sei agou sa tonai sa kole takulanga poni sa tei boka vakakasia mai tu iapeki sa na ona toa? Bi mija tugu! ");
INSERT INTO lga_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ko ai sa vei qu takulangania tu agou sa na veveina na poko? Mu dororia tu agou sira na avoro beto ai qai vei qai toa ko. Ira sa qaike pavu talea na roiti beto qaike pipitidia poko. ");
INSERT INTO lga_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ba ma pojanigou ara sagou: doru poko babata jongadi tai Solomone qaike kamua na babata jongana kame avoro api. ");
INSERT INTO lga_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ko na avoro gu sa toa pa ngeni beto vuka sa mateona ko sa tagona lao pale pa iku vavavatununa ba na Tamasa sa vapopoko vababata jongai tu. Ba agou tu sa qu poreveveina jolaniria na avoro. Sa beko ikete na miu rarange! ");
INSERT INTO lga_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ko muke takulangania sa: <Na sa tana gania?> babi <Na sa tana bukua?> babi <Na sa tana popokonia?> mukeu. ");
INSERT INTO lga_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ura doru sakasava vevei aipira sa ira gu na tinoni rodomo qai kole nyaqo totoniria. Goto agou sa na Tamamiu pa noka sa tei gigilariaona tu sa qai poreveveina muna toaniria agou sa doru sakasa aipira. ");
INSERT INTO lga_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Goto mu nyaqo momoea sa na binangara tana Tamasa beto na ona tuvisi, beto isa mina tamo vanigou sira doru sakasava vevei pira. ");
INSERT INTO lga_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ko muke takulangania sa vuka, ura vuka sa mina takulangania mekana. Ira doru rane qai okoto pogosoria mekadi sa na dia tapata,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","<<Agou muke pitua na goto tinoni, ko agou ba muke tapitu mekamiu. ");
INSERT INTO lga_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ura isa tugu na soana qu pitunia na goto tinoni sa isa tugu na soana muna tapitunia sagou. Beto isa tugu na pada qu padaniria ira na goto tinoni, sa isa tugu sa muna tapadania sagou. ");
INSERT INTO lga_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ai sa vei ko qu juno dogoria tu ao sa na opopu pa matana na tasimu, ba na lomoto kokobu pa matamu sa quke pavu galania? ");
INSERT INTO lga_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ai sa vei ko pira tu qugunia ao sa na tasimu, <Mei ko ma kasi pale na opopu pa matamu,> qugu? Ba dotu! Na lomoto kokobu pa matamu! ");
INSERT INTO lga_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ao na tinoni sesekemu na vavabatamu sao! Momoe sa mu kasi palea mai tu na lomoto kokobu pa matamu, beto sa kode muna babata vatale sao ko muna boka kasi pale ao sa na opopu pa matana na tasimu. ");
INSERT INTO lga_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Muke gona vaniria na sakasava madidi sira na sie, ura kode mai gabala mule garatagou gu. Beto ko muke gona vaniria na miu patu poreveveidi sira na borogo, ura kode mai tete anyanyuniria gu pa peso,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","<<Agou mu tepa ko mu tekua, mu nyaqo ko mu batia, mu kikia ko mi tarevanga vanigou. ");
INSERT INTO lga_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ura na tinoni sa tepa sa sa tekua, na tinoni sa nyaqo sa sa batia, beto na tinoni sa kikia sa sa tarevanga vania. ");
INSERT INTO lga_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","I sei na tinoni agou, sa totonai sa tepagana meme na tuna, poni na patu doa tu sa vania? ");
INSERT INTO lga_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ba bi tepagana igana sisa, poni na dole tu sa vania? ");
INSERT INTO lga_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ko vei agou na tinoni ikikeremiu gu ba qu bokamiu ianiria na sakasava jongadi sira na tumiu, poni sa na Tamamiu pa noka sa sa jonganga jolanigou agou ko isa mina ianiria na sakasava jongana joladi sira qai tepania isa! ");
INSERT INTO lga_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ko doruna qu nyoroguania ko mai roiti lamenia tamugou ira na tinoni, sa ira tugu sa mu roiti laoniria agou tadira na tinoni. Ura api gu sa na Vavanau ti Mosese beto na vaivagigalai tadira na tinoni kokorotai,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","<<Mu tome laoa na atakamana ngijupuna agou, ura na atakamana totomena lao vei pa vinakilasa sa sa revata beto na soana laona sa sa kakabere ko ira na soku tinoni qai tome laoa. ");
INSERT INTO lga_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Goto na atakamana totomena lao pa toa sa sa ngijupu beto na soana laona sa sa karajutu, ko ira ka vivisa gu qai batia sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","<<Mu balauniria ira na tinoni kokorotai sesekedi. Qai lame tamugou popoko vei na sipi siranadi, ba na gagale vulupu pirudi sira. ");
INSERT INTO lga_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pa vuadi kode muna doro gigalaniria sira. Ai vei na tinoni qai lokete vungu qurepi pa gasoro lilivo eoro? Babi qai lokete vua piqi pa buburu vavaioka? ");
INSERT INTO lga_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sa vaitoto vei isa sa: na gou jongana sa sa vuaniria na vua jongadi, goto na gou ikerena sa vuaniria na vua ikeredi. ");
INSERT INTO lga_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na gou jongana sake boka vuaniria na vua ikeredi, beto na gou ikerena sake boka vuaniria na vua jongadi. ");
INSERT INTO lga_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Na gou sake vuania na vua jongana sa sa tario pale ko sa tagona lao pale pa iku. ");
INSERT INTO lga_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ko sa vei sa pa vuadi muna gigalaniria sira,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","<<Nake ira doru qai kukukunisiu, <Bangara, Bangara,> sa mai tomea na binangara pa noka, goto ira gu qai roitinia na nyorogua tana Tamaqu pa noka. ");
INSERT INTO lga_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ira kubo tinoni sa pira marigunisiu ara pa rane vaituti isa, <Bangara, Bangara, pa isongomu ao qe ulule votunia agei sa paranga, pa isongomu ao qe ijiju paleniria na tomate ikikeredi, beto pa isongomu ao qe roitiniria agei sa soku roiti vaivagabaradi!> marigu. ");
INSERT INTO lga_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ba pira kode mana ule votu veini vaniria ara sira, <Qake isongo gigilagou ara sagou. Mu taloa taqu sagou na gagale tinoni ikikeremiu!> managuniria,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","<<Ego ko isa sa nongororia na qua paranga aipira ko sa tutiria, sa sa vei na tinoni tavagigalana sa vaturua na ona ruma pa kuta patu. ");
INSERT INTO lga_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ko sa gore sa na qolapeso, sa nyoro sa na pie, beto sa iru sa na gava, ko sa rajai sa na ruma isa, ba sake boka tanobata sa na ruma, ura sa turu vamauru pa kuta patu sisa. ");
INSERT INTO lga_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Goto isa na tinoni sa nongororia na qua paranga aipira ba sake tutiria, sa sa vei na tinoni duduvilina sa vaturua na ona ruma pa nanagasana. ");
INSERT INTO lga_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ko sa gore sa na qolapeso, sa nyoro sa na pie, beto sa iru sa na gava, poni sa tanobata sa na ruma isa, ko sa dugala tajejegarania sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ego ko totonai sa beto vaivagigalainiria na paranga aipira si Jisu, sa qai gabara vivitiginia ira na minete tinoni sa na vaivagigalai tana, ");
INSERT INTO lga_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ura isa sa kole vaivagigalai vei na tinoni sa isongia na neqi beto sake vevei ira qai vaivagigalainia na Vavanau. ");
INSERT INTO lga_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ego totonai sa taloa pa kubo ko sa gore si Jisu, sa ira na minete tinoni lavata sa qai tutia sisa. ");
INSERT INTO lga_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ko api sa kai tinoni popoqu sa lame toqo sori tutungu pa moena isa, ko pira sau, <<Bangara, vei bu malumu ao, sa muna boka valiososiu gu sara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Poni sa kaqamania na limana ko sa ulia i Jisu sa na tinoni isa beto pira saunia, <<Qa malumu gu sara. Ko mu lioso tu ao!>> saunia. Na totoso tugu isa sa sa tataloso valioso gu sa na popoquna isa. ");
INSERT INTO lga_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Beto sa pira sa poja veinia i Jisu sisa, <<Kopunia ko munake vavavakato vania kai tinoni, goto mu lao vatuvisi tana iama ko mi doro vivilotigo beto sa muna roitinia ao sa na mua vavakukuvu vei sa vaigarununia i Mosese, ko ira doru mai gigilai sa ao qu tei lioso tu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Totonai sa tome lao pa Kepaniami si Jisu, sa sa lame tana sa kai tinoni mamata gogoto, ko sa tepa totokani vaitokai, ");
INSERT INTO lga_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","pira sau, <<Bangara, na qua nabulu sa korapa kole momoona pa ruma, sa mate kale tinina beto sa kamua na vitigi lavata,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Poni pira saunia i Jisu sisa, <<Ara mana lao salania sisa,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ba sa paranga sa na tinoni mamata gogoto isa, pira sau, <<Bangara, ara nake tinoni garoqu ko bu lame tome pa ruma taqu ara sao. Goto mu leve tarinia gu na paranga, beto kode mina tasalanaona gu sa na qua nabulu. ");
INSERT INTO lga_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ura ara ba kai tinoni qa kole kaurai tugu pa neqi tadira na qua bangara beto ko koledia sira na tinoni vaipera qai kole kaurai pa neqi taqu. Ko tonai qa parangia sapi, <Mu lao,> qaunia, poni sa laona tugu, beto qa parangia sa poni, <Mu lame,> qaunia, poni sa lameona tugu. Ko na qua nabulu isa, <Roitinia api,> qaunia, sa sa roitinia gu,>> saunia si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Totonai sa nongoria i Jisu poni sa sa gabara vivitigi, ko pira sauniria sira qai kole tututia isa, <<Ma poja sosotonigou ara sagou: oqoro pore tana kai tinoni pa Izireli ba batinia ara sa na rarange lavatana vei api. ");
INSERT INTO lga_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ko ma pojanigou ara: kode kubo tinoni sa mai lame vei keta pa sagere tapo beto pa suvu tapo, ko mai toqo tavitiria pa vavolo pa binangara pa noka sira Ebarahami, i Aisake beto ko i Jekopi. ");
INSERT INTO lga_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Goto ira na tuni binangara sa mai tagona votu pale pa peguru rorodomona. Ketakoi mai lukana uui beto mai ngingisi tu na livodi,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Beto i Jisu sa parangia na tinoni mamata gogoto, pira saunia, <<Mu riumua. Isa vei qu vasosotoa ao sa mi gore votu,>> sau sisa. Pa totoso tugu isa sa sa tasalana sa na nabulu tana tinoni mamata gogoto isa. ");
INSERT INTO lga_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ego tonai sa kamu pa ruma tai Pita si Jisu, sa sa batia sa na qoele roana i Pita sa mangini na tinina ko sa korapa kole momoona pa lovu. ");
INSERT INTO lga_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ko sa arua i Jisu sa na limana, poni sa taloa tana sa na mo mangini ko sa tatakole vatana vania na tetekuna isa si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Totonai sa gore na vevelu poni sa qai toni kamuniria tai Jisu sira na mota tinoni sa tomeria na tomate ikikeredi. Ko sa iju paleniria na ona paranga i Jisu sira na gagala ikikeredi, beto sa salanaria sira qai mo. ");
INSERT INTO lga_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ko sa gore votu sa na paranga sa pojai i Aisea na tinoni kokorotai, pira sau, <<Isa sa teku paleniria na oda mo beto sa pogoso paleniria noda vagauru,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ego ko tonai sa batia i Jisu sa na minete tinoni qai lame vailivutainia, sa sa garunu sira na ona sepele ko mai toka lao pa kai karovona na ovuku Qalili sauniria. ");
INSERT INTO lga_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ego beto kame isa sa vaivagigalainia na Vavanau sa sa lame ko pira saunia si Jisu, <<Tinoni vaivagigalai, ara mana tutigo ao doru eqa muna lao vei ao,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Poni pira saunia i Jisu, <<Ira na pokese koleona na dia baongo beto ira na manugu pa vavagalo eqa koleona na dia vovori, goto na Tuna na Tinoni sa kepore na ona ia mina vamineria na batuna,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kai goto ona sepele pira saunia sisa, <<Bangara, vamalumusiu ko ma mule lao golomia mai na tamaqu,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Poni pira saunia i Jisu sisa, <<Tutisiu ara ao. Loaria sira na matedi ko mai vaigolomo mekadi,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ego sa koi pa kai koaka si Jisu beto ira na ona sepele, ko mai toka lao pa kai karovona na ovuku Qalili qarigu. ");
INSERT INTO lga_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Poni sa raja vasiboro pa kolo sa kai ranebongi, ko sa vavapoara tarinia na ololobagea sa na koaka. Ba i Jisu sa kole putagana tugu. ");
INSERT INTO lga_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ko qai lao vadoravia ira na ona sepele sisa, pira qarigunia, Mu alogita, Bangara! Ta dururu mate taqeu sa gita! qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Poni sa oeria i Jisu sira, Ai sa vei ko qu matagutu tu sagou? Sa beko ikete na miu rarange! sauniria. Beto sa tatakole sisa ko sa tokea sa na gava beto na kolo, poni sa bule elava sa neqa. ");
INSERT INTO lga_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Poni sa qai gabara beto sira doru, ko qai kole vavaiparanga mule mekadi, Koi, ai tu tinoni veveina sapi? Ko na gava beto na ololobagea tu ba qai nongoria tu! qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ego totonai sa paro pa kai kalena tata pa gugusu pa Qadara si Jisu, sa qai koko lame vei pa bevi vavaigolomona ketakoi sa karu tinoni sa tomeria na tomate ikikeredi ko qai lame gosoria si Jisu. Qai aru tapata, ko kepore kai tinoni sa nyogua tonia sa na soana sa lao vei ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tonai qai batia ira karu si Jisu sa qai vevela votu, pira qarigu, <<Na sa qu nyogua roitinia tamigei sao, na Tuna na Tamasa? Ai vei, qu lame ko mu pipiaragei agei totonai sa oqoro kamua na mei totoso qugu?>> qarigu sira karu. ");
INSERT INTO lga_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ego nake souna pa ia isa sa kai godo borogo lavata qai korapa nyunyubelegadia. ");
INSERT INTO lga_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ko ira na gagala ikikeredi qai tepa vivitigia si Jisu, pira qarigu, <<Vei muna iju variugei, poni sa mu garunu valaonigei gu pa godo borogo pori,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Poni pira sauniria i Jisu, <<Mu lao tu!>> sauniria. Ko qai taloa riu tadira karu tinoni pira sira na tomate ikikeredi, ko qai lao tome tadira na borogo. Ura ko qai sasuru turu taloa riu gu mule sira na borogo pira, ko qai tulai gore sa na taba mamavarana, ko qai tulusu gore pa leo kolo ko qai kuju mate beto pudaladia. ");
INSERT INTO lga_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ego ko sa vei isa poni sa qai uku muledia pa gugusu sira na tinoni qai kopuniria na borogo, ko qai vavakato beto vaniria ira sira doru sakasava qari taroiti tadira karu sa tomeria na tomate ikikeredi. ");
INSERT INTO lga_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ko qai lao gosoria ira doru tinoni pa gugusu isa si Jisu. Tonai qai batia, poni sa qai tepa vivitigia sisa ko mi loai na dia gugusu isa qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ego sa koi pa koaka si Jisu ko sa toka karovo lao pa nona gugusu sosoto. ");
INSERT INTO lga_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ko qai pogoso kamunia pa ona kokolena sa kai tinoni sa mate kale tinina. Tonai sa batia i Jisu sa na rarange tadira, sa pira saunia isa sa na tinoni sa mate kale na tinina, <<Tuqu, mu varene! Ira na mua sela sa qai tei taleoso tu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ego tonai sa kaki ira qai vaivagigalainia na Vavanau sa qai kole vavaiparanga golomo mekadi, <<Na tinoni api sa vamoroania na Tamasa sapi!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ba sa tei gigilaiona tu i Jisu sisa vei qai korapa roroqua ira, ko pira sauniria, <<Ai sa vei ko qu roroquria na sakasava ikikeredi veveidi inara pa bulomiu? ");
INSERT INTO lga_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ai sa sa munyala: na poja vei, <Qai taleoso sira na mua sela,> biu, babi na poja vei, <Mu tatakole ko mu rerege,> biu? ");
INSERT INTO lga_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ba kopira ma vabatinigou ara sa na Tuna na Tinoni sa poreona neqi pa peso ko mina taleosoniria na sela,>> sau sisa. Beto pira saunia sa na tinoni sa mate kale tinina, <<Mu turu! Mu pogosia na mua kokolena ko mu riumua pa mua ruma,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Poni sa gasa turu gu sa na tinoni ko sa riuona pa ona ruma. ");
INSERT INTO lga_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Totonai qai batia sa vei inara sira na minete tinoni poni qai matagutu beto qai vatarasaea sa na Tamasa, ura na Tamasa sa vania na tinoni sa na neqi vevei inara. ");
INSERT INTO lga_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ego sa taloa pa ia isa si Jisu ko sa korapa lalaona, sa sa batia isa sa kai tinoni teteku takisi, na isongona i Matiu, sa korapa toqona pa ona ia roroitina isa. Pira saunia i Jisu sisa, <<Mei tutisiu ara,>> saunia. Poni sa turu si Matiu ko sa tutiaona i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ko tonai sa korapa toqo teteku pa ruma tai Matiu si Jisu beto ko ira na ona sepele, sa na motadi sira na tinoni teteku takisi beto ira tinoni seladi qai somana toqo teteku tavitia si Jisu beto ira nona sepele. ");
INSERT INTO lga_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ko qai batiria ira na Parese sa qai vei isa, ko qai nanasaria sira na sepele ti Jisu, <<Ai sa vei sa teteku tavitiria tu ira na tinoni teteku takisi beto ira na tinoni seladi sa na tinoni vaivagigalai tamugou?>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Poni sa nongoro vairia i Jisu, ko pira sauniria, <<Ira na tinoni toa vataledi sa qaike nyaqoa sa na tinoni vavaisalana, goto ira gu qai mo. ");
INSERT INTO lga_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mu lao ko mu nyaqoa na ginuana sa na paranga sa pojai na Tamasa pa Kukuti Tabuna, pira sau, <Na vairoroqu vaitokai sa qa nyoguania ara, nake vavavakukuvudi na manugu mamade nenedi!> sau. Ura qake lame sara ko ma kukuria na tinoni tuvisidi qau, goto ira tu na tinoni seladi,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ego qai lao sira na sepele tai Jone, ko qai nanasia si Jisu, pira qarigunia, <<Ai sa vei ko agei gu beto ko ira na Parese sa qe tatabu gagani, goto ira na sepele tamu sa qaike tatabu gagani tu?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Poni sa pira sauniria i Jisu sira, <<Ai vei, kode mai kole takulanga pa vavolo vaialava sira na tinoni tasorudi totonai sa korapa toqo tavitiria sa na tinoni vaialava? Dai! Ba sa korapa lalameona sa na rane tonai mina tateku varijo tadira sa na tinoni vaialava api, ko na totoso tu isa sa mai suvere tatabu gagani sira. ");
INSERT INTO lga_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kepore sa kai tinoni mina tuvakania na poko koregana sa na poko leluna. Vei mina vei poni sa totonai mina vijongo sa na poko koregana api, poni sa kode mina raqama valavatia sa na poko leluna. ");
INSERT INTO lga_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Beto kepore kai tinoni mina totonia na vaini koregana sa na tototoni vaini leluna. Ura mina vei isa, poni sa kode mina tapokata sa na tototoni vaini leluna, ko mina titigi kijara riuona sa na vaini. Goto na vaini koregana sa mina tatoto lao tugu pa tototona koregana ko ira karu doru sa mai takopu vatale beto,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Totonai sa korapa paranga vei inara i Jisu, sa sa kamu opo kokopo sori tutungu pa moena isa sa kai iviva mamata tadira na Jiu, ko pira sau, <<Na tuqu maqota sa koni mate gu, ba qa nyoguanigo ko bu lame vaoponia na limamu ko bi toa mule qau,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Poni sa turu si Jisu beto ira na ona sepele ko qai tutia sa na tinoni isa. ");
INSERT INTO lga_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ego kai rereko isa sa varajania na mo malea ko sa kole gu variu orungu ka manogarua aoro sa sa tuti pa liguna ko sa ulia sa na uquna na poko ti Jisu. ");
INSERT INTO lga_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sa kole paparanga golomo mekana, <<Vei ba ulia gu nona poko, poni ba ba tasalanaqua gu sara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ko sa balinga mule sau si Jisu poni sa batia sa na rereko, ko pira saunia, <<Mu varene, tuqu! Na mua rarange sa sa tei salanigo tu,>> sau sisa. Poni sa na totoso tugu isa sa sa tasalana gu sa na rereko isa. ");
INSERT INTO lga_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ego totonai sa lao kamu pa ruma tana iviva mamata si Jisu, poni sa batiria isa sira na tinoni qai lukana popoelai na roroma beto qai lukana kekebo, ");
INSERT INTO lga_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","sa pira sauniria, <<Mu taloa riumiu agou! Ura sake mate sa na rereko ikete api, goto sa korapa gu putagana!>> sau. Tonai sa paranga vei isa poni sa qai avavunia ira doru tinoni sisa. ");
INSERT INTO lga_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ko tonai qai votu beto pa peguru ira doru, sa sa tome si Jisu ko sa arua na limana na rereko poni sa tatakole sa na rereko. ");
INSERT INTO lga_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ko na nongorona na roiti api sa sa tapiara lekogia doruna na eqa isa. ");
INSERT INTO lga_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ego totonai sa taloa ketakoi si Jisu sa karu tinoni leleqadi sa qai tutia isa, ko qai vevela votu, pira qarigu, <<Tuna i Devita, mu roroqu tokanigei,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tonai sa tome pa ruma si Jisu poni sa ira karu tinoni leleqadi ba qai lao tugu tome. Poni sa nanasaria i Jisu, <<Ai vei, qu vasosotoa tugu agou karu sa ara boka salanagou agou karu?>> sauniria. Poni sa pira qarigunia, <<E, Bangara!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Poni sa uliria i Jisu sa na matadi beto pira sau, <<Isa vei qu vasosotoa agou karu sa mi gore votu vanigou!>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Poni sa qai babatadia tugu sa na matadi ira karu. Beto sa paranga vabalauria i Jisu sira karu, pira sauniria, <<Kita ule vaniria ira na tinoni sa na roiti api,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ba qai taloa riu sira karu, ko qai vavavakatonia doru eqa ketakoi sa na veveina isa. ");
INSERT INTO lga_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ego pa ligudi gu qai riu ira karu aipira, sa qai toni kamunia tana ira kaki tinoni sa kai tinoni sa tomea na tomate ikikerena ko sa poka. ");
INSERT INTO lga_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tonai sa iju palea i Jisu sa na tomate ikerena api poni sa sa podalai paranga gu sa na tinoni isa. Ko qai gabara beto sira na minete tinoni, ko pira qarigu, <<Sa oqoro pore tabata pa Izireli sa na sakasava vevei pira,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ba qai paranga sira na Parese, <<Na bangaradi gu ira na tomate ikikeredi sa vania na neqi sa sa boka iju paleria ira na tomate ikikeredi sina,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ego sa lekogo betoria i Jisu sira na gusu lalavatadi na gusu ikiketedi. Ko sa vavaivagigalai sisa pa ruma vavaikamuna, sa taraenia isa sa na nongoro jongana na veveina na binangara tana Tamasa, beto sa salanaria isa sira na tinoni qai varajaniria na okokoto mo na vagauru. ");
INSERT INTO lga_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Totonai sa doro laoria isa sira na minete tinoni, sa sa roroqu vivitigiria, ura qai vevei rerege beto qai nyunyala vei na sipi kepore na dia sepati. ");
INSERT INTO lga_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Poni pira sauniria ira na ona sepele, <<Qai matua nyanyalu sira na vuvua, ba ira na tinoni ababu sa qai vivisa gu. ");
INSERT INTO lga_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ko mu vavara lao tana Bangaradi na umuma, ko mi garunuria na tinoni roiti ko mai ababu pa ona inuma,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ego sa kuku vaikamuniria i Jisu sira ka manogarua sepele ko sa vaniria na neqi ko mai ijiju paleria na tomate ikikeredi, mai salana paleria na okokoto mo beto doru vagauru sauniria. ");
INSERT INTO lga_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ko aipira sira na isongodi ira ka manogarua tinoni tagarunudi: momoe, i Saimone (kai isongona i Pita) beto i Aduru (na tasina i Pita), i Jekopi beto i Jone na tasina (ira karu tuna i Zebeti), ");
INSERT INTO lga_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","i Pilipi, i Batolomiu, i Tomasi, i Matiu isa na tinoni teteku takisi, i Jekopi na tuna i Alepiasi, i Tadiasi, ");
INSERT INTO lga_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","i Saimone isa perangana sa somananiria ira qai raja adu palea na qavuna pa Romu, beto i Jiudasi Isikarioti isa sa gabala kanai i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ko ira ka manogarua aipira sa sa vavanauria i Jisu beto sa garunuria, pira sauniria, <<Munake lao tadira na tinoni karovodi beto munake tomeria na gugugusu tadira na tinoni Sameria. ");
INSERT INTO lga_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Goto mu lao tadira na tinoni Izireli ira qai vei na sipi mumadi. ");
INSERT INTO lga_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mu lao ko mu tarae, pira mugu, <Na binangara pa noka mi togagita gu sau,> mugu. ");
INSERT INTO lga_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mu salanaria ira qai mo, vatoa muleria ira qai mate, mu taloso valiosoria ira qai popoqu, beto mu iju paleria sira na tomate ikikeredi. Quke vaia isa qu tekua, ko muke vavainia isa qu vaiiania. ");
INSERT INTO lga_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Muke pogoso qolo, na siliva, babi kaki poata pa miu kukurani poata. ");
INSERT INTO lga_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Muke pogosia kai mane, muke pogoso varua poko, muke pogoso sadolo babi na opata pa miu rerege. Na tinoni roiti sa sa pada tugu ko mina taiania sa nona tetekuna. ");
INSERT INTO lga_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Totonai muna kamua kai gugusu lavata babi gusu ikete, sa mu tomea na gugusu isa ko mu doro nyaqoa sa kai tinoni mina qeranigou ko mina vatogagou. Muna suvere gu tana tinganai muna loai na ia isa sagou. ");
INSERT INTO lga_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tonai muna tome pa ruma sa mu gosoro qeqeraniria sira na tinoni ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Vei mai vakamu vatalegou ira pa ruma isa, sa mu tepai na Tamasa ko mi mananiria. Goto vei maike tavaraguanigou ira, sa mu teku mulenia na miu bule. ");
INSERT INTO lga_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Vei kaki ruruma babi na gugusu sa baike nyogua vakamugou beto baike nyogua nongorogou, poni sa mu turu iolo votu pa ia isa beto mu tavusu paleria pa nenemiu sa na redeni peso pa gugusu isa. ");
INSERT INTO lga_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma poja sosotonigou ara sagou: mina jolania na vaituti qai gosoria ira pa Sodomo beto pa Qomora sa na vaituti tana Tamasa mina gosoria na gusu isa na rane vaituti,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","<<Vainongoro! Qa garunu lao veinigou na sipi tadira na godo vulupu pirudi ara sagou. Mu suvere vababalau vei ira na dole beto mu lioso pa miu uana. ");
INSERT INTO lga_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mu suvere vababalauniria ira na tinoni. Ura kode mai aru tamanagou, ko mai toni laonigou pa vaituti, beto mai mamajagou pa dia ruma vavaikamuna. ");
INSERT INTO lga_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pana laequ ara sa kode mai toni ragata laonigou pa moedi ira na qavuna beto na babangara, ko muna ule votunia na nongoro jongana tadira beto tadira na tinoni karovodi. ");
INSERT INTO lga_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Totonai mai toni laonigou pa vaituti, sa munake takulangania agou sa na sa muna poja totokenigou mekamiu. Ura tonai mina kamua tu sa na totoso paranga tamugou sa muna taiania agou sisa vei muna pojaniria agou. ");
INSERT INTO lga_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ura nake agou sa muna kole paranga, goto na Gagalana na Tamamiu tu sa mina ule vanigou isa muna pojai. ");
INSERT INTO lga_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ira na tatamatasi marene sa kode mai vaivalao pa mate, na tamadi mina veiniria tugu na ona koburu, ira na koburu mai rajaria sira na tinadi na tamadi ko mai vamateria. ");
INSERT INTO lga_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Doru tinoni sa kode maike tavaraguanigou ura koko vei qu tutisiu ara. Ba isa sa vangaju kamua na bebetona sa mina taalo. ");
INSERT INTO lga_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tonai mai komiti vivikeregou ira na tinoni pa kai gugusu sa mu uku laomiu pa kai goto gugusu. Ura ma poja sosotonigou ara sagou: kode muna oqoro vaokoto betoria agou sira na miu roiti pa doru gugusu pa Izireli, sa mina mule lame gu sa na Tuna na Tinoni. ");
INSERT INTO lga_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Na sepele sake lavata jolania sa na ona tinoni vaivagigalai. Beto na pinausu sake lavata jolania sa na ona bangara. ");
INSERT INTO lga_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Sa pada gu sa na sepele mina vaitoto vei na ona tinoni vaivagigalai, beto sa pada gu sa na pinausu mina vaitoto vei na ona bangara. Vei ara na miu tinoni mamata mai gigalanisiu i Beelizebulu, poni sa agou na qua tinoni sa kode mina nongoro kare jola mutu sa na isongo mai kukunigou!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","<<Ko muke matagutuniria sira na tinoni ira. Ura doru sakasa paedi sa kode mai tabata votu beto doru sakasa golomodi sa mai tagigila. ");
INSERT INTO lga_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Isa qa ule vanigou ara pa rorodomona sa mu vavakatonia pa kakaberena, beto isa qu nongoria pa paena sa mu vevelania pa are ruma. ");
INSERT INTO lga_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Muke matagutuniria sira qai boka vamatea na tini ba qaike boka vamatea na gagala. Goto na Tamasa tu sa mu matagutunia agou. Isa sa mina boka piaria na vamateria na toa tini beto na gagalamiu ko mina boka valaogou pa heli. ");
INSERT INTO lga_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kai pene ikete gu na vaidi sa karu kiri tu, ba sake pae tu pa roroqu tana Tamasa sa totonai sa vukele pa peso kame ira karu kiri pira. ");
INSERT INTO lga_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ko agou ba doru vurungumiu pa batumiu ba sa tei anye betoria tu na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ko muke mamatagutu. Agou sa qu poreveveina jolaniria kubo ngavulu avara kiri,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","<<Isa sa ule votunia pa moedi ira na tinoni sa isa kai tinoni taqu minagu, sa ara ba mana ule votunia tugu isa pa moena na Tamaqu pa noka sisa. ");
INSERT INTO lga_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Goto na tinoni sa kilu palenisiu ara pa moedi ira na tinoni, sa ara mana kilu palenia tugu pa moena na Tamaqu pa noka sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","<<Kita mu roroqua agou sa na bule sa qa pogoso lamenia ara pa peso kita mugu. Dai, nake bule sa qa pogoso lamenia ara, goto na benete vaipikatai tu. ");
INSERT INTO lga_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Qa lame sara ko ma vaipikatainiria na tuna marene beto na tamana, na tuna rereko beto na tinana, beto na tatamaivana beto na tatamaroana qau. ");
INSERT INTO lga_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ira na kana ikeredi jola tana tinoni sa mina ira ka visa gu pa ona tatamana. ");
INSERT INTO lga_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Isa sa roroquria na tamana babi na tinana jolania sa roroqusiu ara sa sake pada ko mina sepele taqu. Isa sa roroqua na tuna marene babi na tuna rereko jolania sa roroqusiu ara sa sake pada ko mina sepele taqu. ");
INSERT INTO lga_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Isa sake pogosia na ona korosi ko mina tutisiu ara, sa nake padana tugu ko mina sepele taqu sisa. ");
INSERT INTO lga_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Isa sa kole gu jujunonia na ona toa tini, sa mina saivia tugu isa sa nona toa. Ba isa sa gona pale nona toa pa laequ ara sa mina isongia tugu sa nona toa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","<<Isa sa vakamugou agou sa sa vakamusiu tugu sara, isa sa vakamusiu ara sa sa vakamua tugu sisa sa garunusiu ara. ");
INSERT INTO lga_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Isa sa vakamua na tinoni kokorotai ura na tinoni kokorotai sisa, sa isa mina somana tekua sa na pinia tana tinoni kokorotai. Isa sa vakamua na tinoni tuvisina ura na tinoni tuvisina sisa, isa mina somana tekua sa na pinia tana tinoni tuvisina. ");
INSERT INTO lga_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Isa mina vania kai kapa pie lomoso sa kame isa nake poreveveina aipira ura isa sa na sepele taqu, poni sa ara ma poja sosotonigou sagou: isa mina tekua sosoto sa na pinia,>> sau i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Totonai sa beto vavanauria sira ka manogarua ona sepele si Jisu, poni sa sa taloa ketakoi ko sa riu vaivagigalai beto sa tarae pa gugugusu pa ia ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ego sa korapa suvere pa ruma vaipiu si Jone Paputaiso sa sa nongoronia isa sira na roiti sa roitiniria na Karisito, ko sa garunu laoniria isa tana sira kaki ona sepele, ");
INSERT INTO lga_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ko pira qarigunia, <<Ai vei, ao tugu sa isa qe korapa veverania agei na tinoni kode mina lame qeu? Ba ai vei, kai goto tu sa mene verania agei?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Poni sa oeria i Jisu sira, <<Mu mule lao ko mu ule vania i Jone sira vei qu nongororia beto qu batiria. ");
INSERT INTO lga_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na tinoni leleqadi qai babata, ira na qao qai rerege, ira sa vairia na popoqu qai tataloso valioso, na tinoni qai kiqili qai nonongoro, na tinoni matedi qai toa mule, beto na nongoro jongana tana Tamasa sa sa tatarae tadira na tinoni golabadi. ");
INSERT INTO lga_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mai tamana sira qaike nongoro nyunyalanisiu ara!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ego ko pa ligudi qai taloa riu sira na sepele tai Jone pira, sa sa pojai i Jisu tadira na minete tinoni sa na veveina i Jone, pira sauniria, <<Tonai qu lao sagou tai Jone pa qega, sa na sa sa mu lao dogoria qugu? Kai tinoni sa malei vei na equru buburu sa tajou vakakanoko lao lamenia na gava? ");
INSERT INTO lga_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ba na sa beka qu nyogua lao batia? Kai tinoni isisongo sa popoko vatatale? Dai, na tinoni qai popoko vatale vei inara sa pa ruma bangara tu qai susuvere! ");
INSERT INTO lga_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ko na sa sosoto sa qu nyogua lao dogoria agou? Kai tinoni kokorotai? E, ba ma pojanigou ara: isa sa sa poreveveina jolaniria ira na tinoni kokorotai. ");
INSERT INTO lga_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ura i Jone gu sa isa sa pojai na veveina na Kukuti Tabuna, pira sau, <Vainongoro! Ara qa garunu momoe laonia sa na qua tinoni pogoso nongoro, ko mina vatana momoea sa na soana tamu,> sau. ");
INSERT INTO lga_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ara ma poja sosotonigou sagou: sa kepore kai tinoni podona sa poreveveina jolania si Jone. Ba na tinoni sa kepore veveina jola pa binangara pa noka sa sa poreveveina jolania si Jone. ");
INSERT INTO lga_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Sa podalai totonai sa kole tarae i Jone Paputaiso ko sa kamu kopira sa na binangara pa noka sa qai rapatia ko ira na tinoni tuara ikeredi qai saputu ragata tekua. ");
INSERT INTO lga_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ira doru tinoni kokorotai beto na Vavanau ti Mosese sa qai ulule votunia tinganai qai lame kamua na totoso ti Jone. ");
INSERT INTO lga_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Vei muna nyogua vasosotoa sa, i Jone gu api sa i Elaija, isa sa korapa lalameona qarigunia ira. ");
INSERT INTO lga_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Na tinoni sa pore na talingina sa mi vainongoro vatale! ");
INSERT INTO lga_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Na sa mana vavapadaniria ara sira na sasae tinoni pira? Ira na tinoni kopira sa qai vei gu ira na koburu qai totoqodia pa ia mamaketina ko qai kole vavaikuku karovo, pira qai kuku vei, ");
INSERT INTO lga_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<Qe kekera vanigou na kera vaialava, ba agou quke peka tu! Qe kera roroma sagei, ba agou quke lukana takulanga tu!> qaqarigu. ");
INSERT INTO lga_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Totonai sa lame si Jone sa sa boboka mamadi ko sake teteku beto sake bubuku vaini sisa. Poni qai paranga sira na tinoni, <Sa kolea na tomate ikikerena sa na bangara ina!> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tonai sa lame mule na Tuna na Tinoni ko sa teteku beto sa buku, poni sa pira qarigunia, <Doro! Sa ngoja mota beto na tinoni bubukuna, na baere tadira na tinoni teteku takisi beto ira na tinoni seladi sina!> qaqarigunia. Ba na tavagigala tana Tamasa sa sa tabata votu pa vuana na toa tadira na tinoni qai vasosotoa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ego ko sa podalai tokeria i Jisu sira na gugusu ketakoi sa roitiniria na kubo roiti vaivagabaradi isa, ura qaike gabala loaria na dia sela. Pira sauniria, ");
INSERT INTO lga_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","<<Mu takulangagamiu tu sagou pa Korazini. Mu takulangagamiu tu agou pa Betiseda! Vei bai taroiti tadira na tinoni karovodi pa Turosi beto pa Sidoni sira na roiti vaivagabaradi qai taroiti tamugou kopira, sa pa moa tu bai gabala loa paleria na dia sela ko bai bibiluniria na kavu beto bai vasae poko taririkatadi sira! ");
INSERT INTO lga_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ba ma poja vatatalenigou ara sagou: na rane vaituti sa mina jolania na vaituti mai gosoria ira pa Turosi beto pa Sidoni sa na vaituti tana Tamasa muna gosoria agou. ");
INSERT INTO lga_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Goto agou pa Kepaniami! Ai vei qu roroqua agou sa kode muna taovulu saemiu pa noka? Dai, kode muna tagona vagore gu pa ia susuverena tadira na tinoni matedi! Ura bai taroiti tadira pa Sodomo sira na roiti vaivagabaradi qai taroiti tamugou kopira, sa bi korapa turu jolaona kamua tu pa rane pa ngeni sa na gugusu isa. ");
INSERT INTO lga_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ma poja vatalenigou gu ara sagou: na rane vaituti sa mina jolania na vaituti mai gosoria ira pa Sodomo sa na vaituti tana Tamasa muna gosoria agou,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ego pa totoso isa sa paranga vei pira si Jisu, <<Tamaqu, ao na Bangarana na oka beto na peso. Qa paranga jongana lao tamu sara, ura na sakasava aipira sa qu vapaeria ao tadira na tinoni gigigalaidi beto na bobokadi beto qu vadoroniria sira qaike gigalai. ");
INSERT INTO lga_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","E, Tamaqu, ura isa tugu sa vei sa na nyorogua tamu. ");
INSERT INTO lga_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na Tamaqu sa tei ianisiu tu ara doru sakasava, ko kepore sa kai tinoni bi gigilai na Tuna goto na Tamana gu, beto kepore sa kai tinoni bi gigilai na Tamana goto na Tuna gu beto ira gu sa vileria na Tuna ko sa vakabere vaniria na veveina na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mei, lame taqu sagou doru qu pavu beto qu pogoso mamata, ko ara ma vamineregou. ");
INSERT INTO lga_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mu paku pogosia na qua pajavala beto mu vainongoro lame taqu, ura ara sa qake tuara beto qa vaiketai pa bulo, ko mu teku vania na minere na miu toa. ");
INSERT INTO lga_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ura na pajavala taqu sa munyala na paku pogosona, beto na pogoso taqu sa kopele,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ego na totoso isa sa sa rerege jola vei pa kai inuma vuiti na rane Minere si Jisu. Ko ira na ona sepele sa vairia na burana ko qai podalai ravusu teku vuiti ko qai kole ngojagadia. ");
INSERT INTO lga_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ko tonai qai batiria qai roiti vei, poni sa ira na Parese pira qarigunia si Jisu, <<Doro! Ira na sepele tamu sa qai roitinia sa na roiti sake tavamalumu ko mina taroiti na rane Minere!>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Poni sa oe laoria i Jisu sira, <<Ai vei qu oqoro tiroamiu tu agou sisa na roiti sa roitinia i Devita beto ira na ona tinoni totonai qai burana ira? ");
INSERT INTO lga_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Na vavakatona isa sa sa tomea i Devita sa na ruma tana Tamasa ko sa gania sa na bereti madina, isa sake vamalumia na Vavanau ko mina gania isa babi ira qai tutia goto ira gu na iama qai tavamalumunia. ");
INSERT INTO lga_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Beto quke tiroamiu tu agou pa Vavanau sa ira na iama qai roitiniria na dia roiti na rane Minere pa zelepade sa qai majai tugu ira sa na vavanauna na rane Minere ba qaike tajutunia qai sela sira? ");
INSERT INTO lga_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ba ma pojanigou ara sagou: kame sa poreveveina jolania na zelepade sa sa korapa lani. ");
INSERT INTO lga_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aipira sau sa na Kukuti Tabuna, <Na vairoroqu vaitokai sa qa nyoguania, nake vavakukuvu,> sau. Ko vei bu gigila vataleamiu agou sa na ginuana na paranga api, sa buke jutu goboroniria na tinoni seladi agou sira na tinoni qaike sela. ");
INSERT INTO lga_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ura na Tuna na Tinoni sa na bangarana na rane Minere,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ego ko sa taloa ketakoi si Jisu, sa sa lao pa kai ruma vavaikamuna tadira na Jiu, ");
INSERT INTO lga_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ko ketakoi sa korapa sa kai tinoni sa raiqo kai kale limana. Ko ira qai korapa nyaqo rokaga ko bai jutunia kaki sela si Jisu sa pira qarigunia sisa, <<Ai vei, na tavamalumuna pa Vavanau sa na salana tinoni na rane Minere?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Poni sa oe laoria i Jisu sira, pira sau, <<I sei agou sa isongia kai sipi ko bi vukele jolopo pa oqili na rane Minere sa na sipi isa, poni sa minake bako votunia na rane tugu isa sisa? Kode na rane tugu isa muna bako votunia agou sisa! ");
INSERT INTO lga_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ba na tinoni tu sa sa poreveveina jolania na sipi! Ko sa vamalumia gu na Vavanau sa na roitinia na roiti jongana na rane Minere,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Beto poni sa sa paranga laoa sisa na tinoni sa raiqo kai kale limana, <<Mu radonia na limamu,>> saunia. Ko sa radonia isa sa na limana poni sa jonga ligu vei tugu kai kale limana. ");
INSERT INTO lga_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Poni sa qai taloa riu ko qai vaingodo roroqu sira na Parese ko mai vamatea si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Totonai sa gigilai i Jisu sa na kukiti tadira api, sa sa taloa riuona ketakoi sisa. Ko ira na minete tinoni sa qai tutia isa, ko sa salana betoria i Jisu sira doru. ");
INSERT INTO lga_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Beto sa pojaniria ko maike vavavakatonia tadira na tinoni sa na veveina isa sau. ");
INSERT INTO lga_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ko api sa na vagore votuna na paranga tana Bangara sa pojai i Aisea, na tinoni kokorotai, pira sau, ");
INSERT INTO lga_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Api sa na qua nabulu qa vilea. Isa qa roroqua beto qa qerania ara. Mana vakolenia na Gagalaqu sisa, ko ira na tinoni karovodi mina ule vaniria na inaalo. ");
INSERT INTO lga_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Minake vaitoke babi kuku vevela sisa, na ovovelena minake tanongoro pa soana. ");
INSERT INTO lga_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Minake pakata palea kai kae gou maleina, beto minake piju vamatea kai juke nonona. Ko mina toa vei isa sisa tinganai mai batia ira sa na inaalo taqu. ");
INSERT INTO lga_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ko tana mai vatogasia na dia totoravusu sira na tinoni karovodi,>> sau sa na Bangara. ");
INSERT INTO lga_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ego pa liguna isa sa qai toni kamunia mule tai Jisu ira sa kai tinoni sa tomea na tomate ikikerena ko sa valeqai beto sa vapokai tugu vei. Ko sa salania i Jisu sisa ko sa paranga beto sa babata ligu. ");
INSERT INTO lga_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ko qai gabara beto sira na miminete tinoni, ko qai kole vavainanasa, pira qarigu, <<Palu api tugu beka sa na Tuna i Devita?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ba ira na Parese sa totonai qai nongoria poni sa pira qarigu, <<I Beelizebulu isa na bangaradi gu na tomate ikikeredi sa vania na neqi sapi, ko sa vei sa sa boka ijiju votu paleria na tomate ikikeredi,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ba sa tei gigilaiona tu i Jisu sa na dia roroqu sa vei inara ko pira sauniria, <<Na binangara sa tapipikata ko qai kole vavaipera mule mekadi, sa kode minake turu vamauru sa na binangara isa. Beto ko doru gugusu babi na tatamana qai vaipipikatai sa maike boka turu vamauru. ");
INSERT INTO lga_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ko vei kai pikatana tai Setani sa bi rajai gu mule sa kai ona pikatana gu mule mekana, sa sa tei tapipikata tugu mekana si Setani, ko minake boka turu vamauru sa nona binangara isa. ");
INSERT INTO lga_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ko vei pa neqi gu ti Beelizebulu ba boka iju paleria na tomate ikikeredi sara, poni sa i sei ropi sa vaniria na neqi sira na miu sepele ko qai boka iju paleria sira na tomate ikikeredi? Ko inara sa vei sa na roiti qai roitinia ira sa ulenia sa qu sela gu sagou! ");
INSERT INTO lga_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Dai, pa neqi tu tana Gagala tana Tamasa qa boka iju pale tomate ikikeredi sara, ko na binangara tana Tamasa sa sa tei togagou tu sagou kopira. ");
INSERT INTO lga_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pira mutu mu doro veinia ko. Kepore sa kai tinoni mina boka tomea sa na leo ruma tana kai tinoni neqina ko mina teku paleria sa doru ona sakasava sa isongoria. Ba momoe sa mina piu vakolea mai tu sa na tinoni neqina api, beto tu poni sa mina soni boka tome laoa isa sa na ona leo ruma, ko mina boka tavusu betoria sira doru ona sakasava. ");
INSERT INTO lga_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Isa sake somana vei taqu sa sa talesiu ara sisa, beto isa sake vaikamu tokanisiu ara sa sa vaipipiarai sisa. ");
INSERT INTO lga_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ko sa vei isa sa ma poja veinigou pira: doru sela beto na paranga ikeredi qai vakesania na Tamasa ira na tinoni, sa mai boka taleosonia gu. Ba na paranga ikeredi qai vakesania na Gagalana na Tamasa sa maike taleosonia. ");
INSERT INTO lga_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Isa sa poja vivikeria na Tuna na Tinoni, sa mina boka taleoso gu. Ba isa sa poja vivikeria na Gagala Tabuna sa minake taleosonia pa toa kopira beto kamua na kamua,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","<<Vei mina jongana sa na gogouna na gou, sa na vuana ba mai jongadi tugu. Vei mina ikerena sa na gogouna na gou, sa na vuana ba mai ikeredi tugu. Ura pa vuana gu muna gigilania ai veveina sa na gou. ");
INSERT INTO lga_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Boko tuni dole ikikeremiu! Ko na tinoni ikikeredi vei agou sa kode maike boka paranga votuniria na sakasava jongadi. Ura isa tugu sa pugele ojojongo pa bulo sa sa tapoja votu pa manga. ");
INSERT INTO lga_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na tinoni jongana sa sa vavoturia sira na uana jongadi qai pugele pa bulona, goto na tinoni ikikerena sa sa vavoturia sira na uana ikikeredi qai pugele pa bulona. ");
INSERT INTO lga_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ba ma poja vatatalenigou ara sagou: na rane vaituti sa ira tinoni sa mai okokoto vakaberia tana Tamasa sa na ginuana qai pojaria sira doru paranga qai vavukele gobororia. ");
INSERT INTO lga_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ura doru mua paranga tugu qu pojaria ao sa kode mai tuti mulenigo. Ko na mua paranga tugu mina ulenia sa vei muna talegasania sa ba muna gosoria ao sa na vinakilasa pa vaituti tana Tamasa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pa liguna sa vei inara, sa qai lao nanasia ira kaki qai vaivagigalainia na Vavanau beto ira na Parese si Jisu, <<Tinoni vaivagigalai, qe nyogua batia agei sa kai roiti vaivagabarana jola tana Tamasa bu roiti votunia ao,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Poni sa pira sauniria i Jisu sira, <<Na sasae tinoni ikikerena beto na vavakeporea na Tamasa sa sa korapa nyoguania kai roiti vaivagabarana jola! E, ba kepore sa kai roiti vaivagabarana muna tavadogoronia, goto isa tugu mekana gu na roiti vaivagabarana sa taroiti ti Jona na tinoni kokorotai. ");
INSERT INTO lga_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kai muqisi podeke vei tugu sa suvere kue rane beto kue bongi pa leo iapana na igana si Jona, sa mina vei tugu sa na Tuna na Tinoni. Mina kue ranena tugu beto kue bongina tugu pa bevi vavaigolomona sisa, beto sa mina toa mule. ");
INSERT INTO lga_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na rane vaituti sa kode mai turu ko mai tutinigou ira na tinoni pa Ninive sagou na sasae tinoni kopira. Ura ira sa qai gabala sa totonai qai nongoria na taraena i Jona. Goto doro tu ko, sa korapa gu lani kopira sa kame isa sa poreveveina jolania i Jona. ");
INSERT INTO lga_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na rane vaituti sa kode mina turu na kalao pa Siba ko mina tutinigou sagou na sasae tinoni kopira. Ura na kakasana jola sa nona rerege koko lame vei pa nona gugusu totonai sa kamu nongoria sa na vaivagigalai bobokana ti Solomone. Goto agou sa doro tu ko, sa korapa gu lani kopira sa kame isa sa poreveveina jolania i Solomone,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","<<Totonai sa taloa tana tinoni sa kai tomate ikikerena, sa sa riu lekogia isa sa na ia kepore kai savana ko sa nyaqoa sa ketakoi mi suvere minere sau. Ba sake batia isa sa kai ia ketakoi bi boka suvere. ");
INSERT INTO lga_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Poni sa sa paranga gu, <Ma mule vatuvisi gu pa qua ruma ketakoi qa suvere perangana ara,> sau. Ko sa mule sau poni sa batia na kokobana ko sa tei tasaqu valioso na tavatana vatale tu sa na ruma. ");
INSERT INTO lga_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Poni sa mule riu sisa ko sa riu toni kamuniria sira ka vitu tomate qai ikere jolania mekana, ko qai kamu suveria sa na ruma isa. Ko tonai sa na toa tana tinoni isa sa sa ikere jolania na totoso momoe. Mina vei puputa tugu isa sa na sasae tinoni ikikeredi kopira,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tonai sa korapa paparangaria i Jisu sira na tinoni, sa kamu turu pa sesebe ruma sa na tinana beto ira na tasina marene, ko mai parangia sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ko kame ira qai korapa vaikamu ketakoi sa paranga laoa sisa, pira sau, <<Qokolo, na tinamu beto ko ira na tasimu marene sa qai korapa turu veranigo pa peguru. Qai nyogua parangigo qarigu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ba sa oe laoa i Jisu sisa, <<I sei sa na tinaqu beto ira sei sa na tasiqu marene?>> sau. ");
INSERT INTO lga_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Beto sa uduku laoria sira nona sepele beto sa paranga, <<Pira sira na tinaqu na tasiqu marene! ");
INSERT INTO lga_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ura isa na tinoni sa roitinia isa vei sa nyoguania na Tamaqu pa noka sa isa tugu sa na tasiqu marene, na luluqu rereko beto na tinaqu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ego na rane tugu isa sa sa taloa pa ruma isa si Jisu, ko sa lao pa keketaina na ovuku ko sa toqo vaivagigalai ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na minete tinoni lavata sa qai vaikamunia isa, ko sa lao tu koi ko sa toqo pa kai koaka sisa. Goto na puku minete tinoni sa qai turu gu pa parona. ");
INSERT INTO lga_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ko kubo sakasava sa sa vagigalainiria isa pa vavakato vavapada. Ko sa vavavakato vei pira sisa. <<Koleona sa kai tinoni umuma sa riu iparainiria na kiko pa ona inuma. ");
INSERT INTO lga_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Totonai sa kole iparainiria isa sira na kiko, sa kaki sa qai vukele lao pa lodaka soana pa rereregena tana tinoni, ko qai tatava kamu na manugu ko qai tobiki gani betoria na gadia. ");
INSERT INTO lga_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Goto kaki mule sa qai vukele lao pa bubuturu ketakoi sake kubo pesona. Ko qaike ruavo tugu pidokodia sa na kiko ira, ura sake kubo na peso. ");
INSERT INTO lga_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ba tonai sa sagere gu na tapo poni sa sa alanga vamaleiria, ura sa kepore na bageredi. ");
INSERT INTO lga_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Goto kaki kiko mule sa qai vukele lao pa gasoro vavaioka, ko sa pilu vamateria na gasoro vavaioka. ");
INSERT INTO lga_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Goto kaki kiko sa qai vukele lao pa peso masuruna ko qai vua vatale. Ko kaki sa qai vua gogoto, kaki sa qai vua vonomongavulu, goto kaki sa qai vua uengavulu. ");
INSERT INTO lga_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Isa sa koleona talingina sa mi vainongoro vatale!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ego isa tugu sa beto sa qai rijo lao tata ko qai nanasia ira na ona sepele si Jisu, <<Ai sa vei ko qu varoitiria tu na vavakato vavapada sao tonai qu vaivagigalai?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Poni sa oeria i Jisu sira, pira sauniria, <<Ura agou qu tei taiania tu sa na gigalai golomona na binangara pa noka ko qu gigilaimiu, ba tadira na tinoni sa sa korapa pae. ");
INSERT INTO lga_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Isa na tinoni sa tei poreona tu sa mina taia mutugu ko mina pugele nyonyoa na ona. Isa na tinoni sa keporeona sa isa tugu iapeki sa isongia ba mina tateku pale tugu. ");
INSERT INTO lga_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na ginuana qa vaivagigalainiria na vavakato vavapada sa ura qai dodogoro tugu sira ba qaike babata, qai vainongoro tugu ba qaike nonongoro beto qaike vakaberiadia kai sa. ");
INSERT INTO lga_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ko sa gore votu tugu tadira sa na kokorotai ti Aisea, isa pira sau, <Muna nongoro ko muna nongoro sagou, ba munake vakaberia. Muna dogoro ko muna dogoro sagou, ba munake batia. ");
INSERT INTO lga_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ura na bulodi na tinoni pira sa duduvili, na talingidi sa kiqili patu beto na matadi qai leqa. Kita mai babata na matadi, mai nonongoro na talingidi, beto mi tavagigala na bulodi ko mai gabala mule lame ko ara ma salanaria,> sau na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ba agou qu tamana sagou, ura qu boka dodogoro vatavagigala beto na nonongoro vakoititi. ");
INSERT INTO lga_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ura ma poja sosotonigou ara sagou: na soku sira na tinoni kokorotai beto ira na tinoni tuvisidi pa moa sa qai nyoguania ko bai batiria ba bai nongororia qarigu sira na sakasava qu batiria beto qu nongororia agou pira, ba qaike boka,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Ego mu vainongoronia sa na ginuana na vavakato vavapadana na tinoni umuma. ");
INSERT INTO lga_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Na tinoni sa nongoria na nongorona na binangara tana Tamasa ba sake vakaberia sa sa lame na kutana nikerena ko sa teku palea sa na nongoro sa tavavuvusu pa bulona. Na tinoni isa sa sa vei na kiko sa tavavuvusu pa lodaka soana. ");
INSERT INTO lga_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Goto na kiko sa tavavuvusu pa peso bubuturu, sa sa vei tugu na tinoni tonai sa nongoria na nongoro poni sake ruavo tugu teku qeqerania. ");
INSERT INTO lga_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ba sake bagere vatale pa ona toa mekana ko sake kole sovai pa ona toa. Ko tonai sa raja sa na tapata beto qai komitia na tinoni pa ginuana vei sa vasosotoa na nongoro sisa, poni sake ruavo tugu vukeleona. ");
INSERT INTO lga_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Goto na kiko sa tavavuvusu pa gasoro vavaioka, sa sa vei na tinoni sa nongoria na nongoro ba na jujuno qai kole pa toa beto na roqu totodi na isisongo pa peso sa sa pilua sa na nongoro isa ko sake vua jonga. ");
INSERT INTO lga_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Goto na kiko sa tavavuvusu pa peso masuruna sa sa vei na tinoni sa nongoria na nongoro beto sa vakaberia. Isa sa vua vatale ko sa vua gogoto, na vonomongavulu beto na uengavulu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ego sa vavakatonia mule i Jisu tadira sa kai vavakato vavapada, pira sauniria, <<Na binangara pa noka sa sa kai muqisi podeke vei tonai sa riu vavuvusia na kiko jongana pa ona inuma sa kai tinoni. ");
INSERT INTO lga_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ba kai bongi totonai qai korapa puta beto sira doru tinoni sa sa kamu sa kai ona kana, ko sa vavuvusu vavaisomanai laoniria na kiko ikikeredi sa ketakoi sa tei tavavuvusu tu sa na kiko jongadi, beto ko sa turu ko sa riuona. ");
INSERT INTO lga_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tonai qai pidoko sa na umuma ko qai podalai vua, poni sa qai tabata pikata sira na buburu ikeredi qai toa vaisomanai. ");
INSERT INTO lga_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Poni qai lao tana tinoni poreona inuma sira na pinausu, ko pira qarigu, <Bangara, beko na kiko jongadi gu sa qu vavuvusuria ao pa mua inuma, oko? Ko pai na koko lame veidi sira na buburu ikeredi qai toa pa inuma?> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Poni sa oe lao sisa, <Na kana sa sa roiti vei api,> sau sisa. Poni qai paranga sira na pinausu, <Ko ai vei qu nyoguanigei ko me riu sosobulu paleria sira na buburu ikeredi?> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ba sa paranga sa na tinoni poreona inuma, <Dai, ura vei muna sobulu paleria agou kopira, sa kode muna sobulu kale tavitiniria kaki umuma jongadi. ");
INSERT INTO lga_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Goto loaria ko mai mekarai toa vaikamudia tinganai mina kamua na totoso ababu. Totonai tu mina kamua na totoso ababu, sa kode mana garunuria ara sira na tinoni ababu, ko mai sobulu momoe paleria sira na buburu ikeredi, beto mai piu vavaikamuniria ko mai vato paleria pa niku. Beto sa mai kotu vaikamuniria sira na vua matua jongadi ko mai vakoleria pa qua ruma vavakole gaganina,> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Beto sa vavakatonia mule i Jisu tadira sa kai vavakato vavapada, pira sau, <<Na binangara pa noka sa sa kai muqisi podeke vei kai kiko masitadi sa tekua kai tinoni ko sa vavuvusia pa ona inuma. ");
INSERT INTO lga_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sa ikete jolaniria doru kiko sisa, ba totonai sa toa sa sa lavata jolaniria doru umuma pa inuma. Ko sa juki gou lavata ketakoi sisa, ko qai tatava kamu na manugu ko qai okoto roitidia vovori na alale tinganai vei okoto kakaena,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Beto sa vavakatonia mule i Jisu tadira sa kai vavakato vavapada, pira sau, <<Na binangara pa noka sa sa vei na vavakovuruni palava sa tekua kai rereko ko sa qairi vaisomanainia pa kue bakete palava, ko sa kovuru iolo beto tu sa na palava doruna,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sa kole vaivagigalai laona gu pa vavakato vavapada si Jisu totonai sa kole vaivagigalai tadira na minete tinoni. Ko kepore sa kai ona vavakato lao tadira bike vavapodeke pa vavakato vavapada. ");
INSERT INTO lga_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Sa roiti vei pira sisa ko sa vagore votua sa isa vei sa pojai na tinoni kokorotai, pira sau, <<Mana paranga pa vavakato vavapada sara. Mana uleniria na sakasava qai pae podalai tu na kasia gusu,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ego beto sa sa taloa tadira na minete tinoni si Jisu ko sa tome pa leo ruma, poni sa qai lao nanasia ira na ona sepele sisa, pira qarigunia, <<Mu ule vanigei na sa ginuana sa na vavakatona na buburu ikeredi pa inuma,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Poni sa oe laoria i Jisu sira, pira sau, <<Isa sa vavuvusia na kiko jongana sa na Tuna na Tinoni. ");
INSERT INTO lga_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Na inuma sa na kasia gusu, ira na kiko jongadi sira na tinoni pa binangara tana Tamasa, goto ira na buburu ikeredi sa ira na tinoni tana kutana nikerena. ");
INSERT INTO lga_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Na kana isa sa umaniria na buburu ikeredi sa na bangaradi na tomate. Na totoso ababu sa na vinabetona na totoso, goto ira na tinoni ababu sira na mateana. ");
INSERT INTO lga_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kai muqisi podeke vei qai takotu vaikamu sira na buburu ikeredi pira ko qai tavato pale pa iku, sa mina vei puputa tugu isa sa mina taroiti pa vinabetona na totoso. ");
INSERT INTO lga_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Na Tuna na Tinoni mina garunuria sira na ona mateana ko mai vile paleria pa ona binangara sira doru sakasava vaivatatupe beto ira qai roiti vasela. ");
INSERT INTO lga_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ko mai tagona valao pa leo iku memea sira ko ketakoi mai lukana uui beto mina ngingisi tu na livodi. ");
INSERT INTO lga_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Goto ira na tinoni tuvisidi sa mai tolanga vei na kaberena na tapo pa binangara tana Tamadi. Isa sa koleona talingina sa mi vainongoro vatale!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","<<Na binangara pa noka sa sa vei kai isisongo poreveveina kole golomona pa kai kobu peso. Totonai sa batia kai tinoni sa na isisongo api poni sa sa amu vakole golomo beia, beto ko sa taloa qeqera ko sa riu vavai betoniria sira doru sakasava sa isongoria ko sa vai tekua na ona sa na kobu peso isa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Na binangara pa noka sa sa vei mutugu kai tinoni sa nyaqo mamateria na patu jojongadi na poreveveidi. ");
INSERT INTO lga_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ko tonai sa batia kame isa sa babata jonga jola, poni sa sa lao ko sa vavai betoniria sira doru ona sakasava ko sa vaitekua na ona sa na patu babata jonga jola api,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Na binangara pa noka sa sa vei mutugu na vaqara sa taipa lao pa kolo ko kubo okokoto iganadi sa qai kura pa leona. ");
INSERT INTO lga_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Totonai sa pugelia na igana sa na vaqara, sa qai bako vaparoa pa parona ira na tino abu ko qai kole vileria sira na igana. Ira na jongadi sa qai kuraniria pa kukurana, goto ira nake jongadi sa qai gona paleria. ");
INSERT INTO lga_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ko kode inara tugu mina vei sa pa vinabetona na totoso. Ira na mateana sa mai votu lao ko mai vile paleria sira na tinoni ikikeredi qai vaisomanai tadira na tinoni tuvisidi. ");
INSERT INTO lga_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ko mai tagona valao pa leo iku memea sira ko ketakoi mai lukana uui beto mina ngingisi tu na livodi,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ego beto sa nanasaria i Jisu sira na ona sepele, pira sau, <<Ai vei, qu gigilaimiu tugu agou sira na vaivagigalai aipira?>> sau. Poni sa, <<E,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Poni pira sauniria, <<Ego ko sa vei sa, ira doru tinoni vavaivagigalai pa Vavanau ti Mosese qai tavagigalainia na veveina na binangara pa noka sa qai vei na tinoni sa vavoturia pa ona lose kokopuni sakasavana sira na vaivagigalai koregadi beto na leludi,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ego ko pa liguna sa beto vaivagigalainiria i Jisu sira doru vavakato vavapada aipira, sa sa taloa pa ia isa sisa, ");
INSERT INTO lga_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ko sa lao pa ona gugusu ketakoi sa lavata sae ko sa vaivagigalai sisa pa ruma vavaikamuna ketakoi. Ko qai gabara beto sira doru totonai qai nongoria na ona vaivagigalai. Ko qai paranga sira, <<Pai sa tekunia na bangara api sira na gigigalai beto na roiti vaivagabaradi veveidi inara? ");
INSERT INTO lga_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Taqe gigilaioda gu gita sa na tinoni api! Na tuna gu na kamada sapi! Na isongona na tinana si Mere gu ke! Ko ira na tasina marene sira Jekopi i Josepa i Saimone beto i Jiudasi gu ke! ");
INSERT INTO lga_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ko ira na luluna rereko ba qai korapa gu suvere tavitigita pira! Ko na tinoni api pai sa butiniria isa sira na vaivagigalai beto na roiti veveidi inara?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ko qai kilu pale ira sisa. Ba pira sauniria i Jisu sira, <<Na tinoni kokorotai kisa pa ona gugusu ketakoi sa lavata sae gu beto pa ona tatamana gu sa sake tatavaragua, goto pa goto gusu tu sa tatavaragua,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ko sake roitiniria soku roiti vaivagabaradi pa ia isa si Jisu, ura koko vei ira na tinoni qaike vasosotoa sisa. ");
INSERT INTO lga_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pana totoso ira sa sa nongoronia i Herodi, na bangara pa ia pa Qalili, sa na vavakatona i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ko sa pojaniria sira na ona iviva lalavata, pira sauniria, <<I Jone Paputaiso sosoto gu sapi! Sa toa mule pa mate! Ko sa vei sa sa isongia isa sa na neqi ko sa soni boka roitiniria isa sira na roiti vaivagabaradi,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Pira sa roroqu vei sisa ura perangana tu qi tei garunuria tu i Herodi sira nona tinoni ko qai piua si Jone Paputaiso ko qai vatomea pa ruma vaipiu. Qi tapiu sisa pa ginuguana gu i Herodiasi na maqotana i Pilipi na tasina. ");
INSERT INTO lga_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ura kaki totoso qai lao pori sa qi vapoja sosotonia i Jone Paputaiso si Herodi, pira qiunia, <<Sake tavamalumu pa Vavanau sa qu vei ao qu alavia i Herodiasi, ura na maqotana tu na tasimu sisa,>> qiunia. ");
INSERT INTO lga_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ko pa ginuana isa sa i Herodi qi nyogua vamatea si Jone, ba qi matagutuniria ira na tinoni Jiu ura ira na tinoni Jiu qai vasosotoa sa kai tinoni kokorotai tugu si Jone qarigu. ");
INSERT INTO lga_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ego ba totonai qi kamu sa na rane podo ti Herodi, sa na tuna rereko i Herodiasi qi lao kole pepeka pa moedi ira na tinoni qai tasoru valame pa vaikamu. Ko qi qera vivitiginia i Herodi sa na pepekana isa, ");
INSERT INTO lga_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ko qi ule votu tarinia na maulu isa sa doru sakasava mina tepai isa sa mina vania gu qiunia sa na rereko api. ");
INSERT INTO lga_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ko pa roroqu tana tinana sa qi lao tai Herodi sa na rereko ko qi tepa vei pira, <<Mu petania pa kai peleita ko mu vanisiu kopira tugu sa na batuna i Jone Paputaiso,>> qiu. ");
INSERT INTO lga_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Qi takulanga vivitigi si Herodi tonai qi nongoria na tepa tana rereko, ba qi tei maulu vakole tu pa moedi ira na tinoni qi soruria, ko qi pojaniria gu sira na ona tinoni ko mai vania gu sisa vei qi tepai na rereko qiu. ");
INSERT INTO lga_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ko qi garunuria isa sira kaki ona tinoni vaipera, ko qai lao kujukia pa ruma vaipiu si Jone Paputaiso. ");
INSERT INTO lga_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Beto sa qai petania pa kai peleita sa na batuna ko qai pogoso kamu vania sa na rereko, beto sa isa qi lao vania sa na tinana. ");
INSERT INTO lga_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pa liguna isa sa qai lao pogosia ira nona sepele sa na kokobu tinina i Jone, ko qai riu golomia. Beto sa qai riu pojania si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ego totonai sa nongoronia i Jisu sa na veveina i Jone Paputaiso, sa sa taloaona ketakoi pa kai koaka sisa ko sa riu vakaloiona pa kai ia kaloina. Ba tonai qai nongoronia ira na minete tinoni sisa, sa qai turu loaria ira sira dia gugusu ko qai arei tutia si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Totonai sa tete paro si Jisu, sa sa batia sa na puku minete tinoni lavata, ko sa roroqu vivitigiria isa sira ko sa salanaria tugu isa sira qai mo. ");
INSERT INTO lga_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Totonai sa gore sa na vevelu sa qai lao sira na ona sepele ko pira qarigunia, <<Koi, na ia kaloina kepore tinonina sa lani beto ko sa tei papaka vivitigi tu sa na rane. Ai vei bu garunu variuria tu tinganai vei gugugusu sira na tinoni pira ko bai riu vaigadia gagani mekadi,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Poni pira sauniria i Jisu sira, <<Nake padadi mai riu sira pira, goto agou mekamiu sa mu ianiria kaki tetekuna,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Poni sa qai paranga sira na ona sepele, <<Isa tugu ka lima batu bereti ikete gu beto karu igana gu sa aipira,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","<<Ego mu pogoso lameniria lani,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Beto sa pojaniria isa sira doru na tinoni ko qai toqo beto pa buburu, beto sa sa tekuria sa ka lima bereti beto karu igana, ko sa enga sae pa noka beto sa paranga jongananiria. Beto sa kikiparia sa na bereti ko sa vaniria sira na ona sepele, ko ira na sepele qai iaria sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ko qai teteku ko qai pote beto sira doru tinoni. Beto sa qai tekuria ira na sepele sa ka manogarua totopa ko qai vapugele nyonyoaniria na kikipa gagani kole joladi. ");
INSERT INTO lga_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na anyedi ira na marene qai teteku sira ka lima tina, goto ira na rereko beto ira na koburu sa qaike taanye. ");
INSERT INTO lga_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ego pa liguna tugu isa, sa sa pojaniria i Jisu sira na ona sepele ko mai koi pa koaka ko mai karovo lao momoe pa kai kale karovona na ovuku, goto isa mi suvere ko mina garunu vamuleria mai na tinoni pa okotodia gugugusu sauniria. ");
INSERT INTO lga_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Pa liguna sa variu betoria na tinoni, sa sa sagere sae pa kai kubo mekana sisa ko sa vavara. Ko totonai sa gore na vevelu, sa sa kole tugu suvereona mekana ketakoi sisa. ");
INSERT INTO lga_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ko tonai sa sa tei sou lao tu pa korapa kolo sa na koaka, ko sa vaqevulu lao lamenia na bogusu sa na koaka, ura na gava turu koimoa sa viva. ");
INSERT INTO lga_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ego ko pa vaikorapaina kue koloko vuvugei ko sa lao kamu pa vonomo koloko vuvugei jonga sa sa rerege tuti lao pa vuliti kolo si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Totonai qai batia sisa sa korapa rerege lame pa vuliti kolo, sa qai takulanga vivitigi sira, <<Koi, kai tomate sa sa lamegana api!>> qarigu, ko qai vevela gagateana. ");
INSERT INTO lga_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Poni sake ruavo tugu parangaria i Jisu, pira sau, <<Mu varene! Ara gu sapi, muke matagutu!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Poni sa paranga lao si Pita, pira saunia, <<Bangara, mina vei ao sosoto tugu sina, sa mu kukusiu ko ma rerege lao tamu pa vuliti kolo,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","<<Jongana, mu rerege lame gu,>> sau si Jisu. Poni sa taloa tugu pa koaka si Pita ko sa podalai rerege lao ti Jisu pa vuliti kolo. ");
INSERT INTO lga_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ba totonai sa vagigilai i Pita sa na giburuna na gava poni sa sa matagutu ko sa podalai dururu, poni sa uui, <<Bangara, mu alosiu!>> sau. ");
INSERT INTO lga_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Isa tugu sa paranga vei inara i Pita poni sa sa kaqama lao aru tamania i Jisu sa na limana isa beto pira saunia, <<Sa ikete jola sa na mua rarange! Ai sa vei ko qu ruarabeke sao?>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ko totonai qai koi beto pa koaka sira karu doru, sa sa noso betona sa na gava. ");
INSERT INTO lga_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ko ira na sepele pa koaka sa qai vatarasaea si Jisu, pira qarigu, <<Sosoto jola sa ao tugu sa na Tuna na Tamasa,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ego qai karovia ira sa na ovuku Qalili ko qai lao paro pa gugusu pa Qenesareti. ");
INSERT INTO lga_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ko qai doro gigalia ira na tinoni pa ia isa si Jisu, ko qai vareregia pa vailivutaina na gugusu lavata isa sa na nongorona isa, ko qai okoto toni kamuniria ti Jisu sira doru tinoni qai mo. ");
INSERT INTO lga_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ko qai tepa jujukia si Jisu ko mai boka ulia gu sa na uquna nona poko qarigu. Ko ira doru tinoni momodi qai ulia na uqu poko tana, sa qai tasalana beto tugu. ");
INSERT INTO lga_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ego pa liguna isa sa na koko veidi pa Jerusalema qai kamu sira kaki Parese beto ira qai vaivagigalainia na Vavanau ko qai lao nanasia si Jisu, pira qarigu, ");
INSERT INTO lga_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<Ai sa vei sa ira na sepele tamu qai majai na uana tututidi tadira na oda tite? Ura qaike loqa lima momoe mai beto qai teteku,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Poni sa oeria i Jisu, pira sauniria, <<Goto agou sa ai sa vei ko qu majai sa na garunu tana Tamasa ko qu tutia gu agou sa na miu uana tututidi mekamiu? ");
INSERT INTO lga_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ura sa paranga sa na Tamasa, <Mu valavatia na tinamu na tamamu,> sau, beto ko, <Isa sa poja vivikeria na tinana beto na tamana sa mina tavamate,> sau. ");
INSERT INTO lga_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ba agou sa qu paranga tu sa vei kai tinoni bi parangia na tinana babi na tamana, pira biunia, <Na sakasava api sa pada ba boka tokanigo ao, ba qa tei valao vania tu na Tamasa ara,> biu, ");
INSERT INTO lga_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","poni sa <Minake kilu valavatia isa sa na tinana na tamana ba jongana gu,> qugu sagou. Ko pa soana vei api sa qu vakeporea agou sa na paranga tana Tamasa, ko qu tutia gu agou sa na miu uana tututidi mekamiu. ");
INSERT INTO lga_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Na tinoni jola vavabatamiu na sesekemiu sagou! Sa sotona gu sa i Aisea tonai sa ululenia na veveimiu agou: ");
INSERT INTO lga_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<Ira na tinoni aipira sa qai valavatasiu sara pa beberu mangadi gu, goto na bulodi sa sou vivitigi taqu. ");
INSERT INTO lga_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na goborona gu sa na dia vinatarasaequ ara, qai vaivagigalainiria na vaivagigalaidi na vinaturu tadira na tinoni gu,> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ego beto sa kuku valameria i Jisu sira na minete tinoni, ko pira sauniria, <<Mu vainongoro ko mu vakoititia sa isa vei mana pojai ara! ");
INSERT INTO lga_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nake isa sa teku ponyolia pa mangana na tinoni sa sa vapajia sa na ona toa, goto ira tu na sakasava qai votu lame vei pa mangana sa qai vapajia sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Beto sa qai lame ti Jisu sira na ona sepele ko pira qarigunia, <<Qu gigilaimua tugu beka ao sa qaike qerania ira na Parese sira vei qu pojaria ao?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Poni sa oeria i Jisu, pira sauniria, <<Doru umuma sake umaniria na Tamaqu pa noka sa mai tasobulu gogona pale beto. ");
INSERT INTO lga_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ko muke pavu takulanganiria sira. Ira na tinoni vaitoni leleqadi sira. Ba vei na tinoni vaitoni leleqana sa mina tonia sa kai tinoni leleqana mutugu, sa kode ira karu doru sa mai mekarai vukele beto pa kai oqili,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Poni sa oe lao i Pita, pira saunia, <<Mu vakabere vatalea moko tamigei sa na vaivagigalai qu pojaniria ira na Parese api?>> sau. ");
INSERT INTO lga_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Poni pira sau i Jisu, <<Ko agou ba qu korapa tugu rururamiu sa? ");
INSERT INTO lga_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Quke vakoinonoa tu agou sa na sakasava sa gania pa mangana na tinoni sa sa gore gu kole pa borina na tinoni beto sa votu riuona gu? ");
INSERT INTO lga_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Goto ira tu qai votu vei pa manga sa na koko veidi pa bulo, ko ira tu sa qai vapajia na toa tana tinoni. ");
INSERT INTO lga_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ura na koko lame veidi pa bulo sira na roroqu ikikeredi, na varivai, na babarata, na toa lulasana, na ikiko, na jutu sesekeria na goto tinoni, beto na poja vivikereria na goto tinoni. ");
INSERT INTO lga_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aipira tu sira qai vapajia na toa tana tinoni. Goto nake loqa lima mai beto na teteku sa sake vapajia na toa tana tinoni sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ego sa iolo ketakoi si Jisu ko sa taloa riuona pa pikata ia pa Turosi beto pa Sidoni. ");
INSERT INTO lga_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ko sa taloa lame sa kai rereko Kenani na susuverena pa gugusu isa, ko sa kuku lulukana lao tai Jisu, <<Kei, Bangara! Ao na Tuna i Devita! Mei ko mu roroqu tokanisiu! Na tuqu rereko sa sa tomea na tomate ikikerena, ko sa mo vivitigi,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ba sake pavu vagalania i Jisu sisa. Beto qai lame sira na sepele ko qai kole tepa totokai pira qarigunia sisa, <<Mu iju vamule riua! Sa korapa lukana tututigita gita sina!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Poni pira sau si Jisu, <<Ara sa qa tagarunu ko mana lao tadira na tinoni Izireli gu qai muma vei na sipi,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Totonai sa sa rerege lao tu sa na rereko api ko sa lao toqo sori tutungu pa moena i Jisu ko pira sau, <<Tokanisiu, Bangara!>> sau. ");
INSERT INTO lga_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Poni sa oe i Jisu, pira saunia, <<Nake jongana sa bi tateku sa na gagani tadira na koburu ko bi tavalao vaniria na sie tapausudi pa ruma,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Poni pira sau sa na rereko api, <<Sotomua tugu Bangara, ba ira na sie pausudi kisa ba qai kole gu vera gagani vuvusudi pa tevolo tadira qai pausuria,>> sau sa na rereko. ");
INSERT INTO lga_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Poni sa oe i Jisu, pira saunia, <<Koi tinaqu, na lavatana jola sa na mua vasosoto! Mi taroiti vanigo tu ropi sa isa vei qu nyoguania ao,>> sau. Ko na totoso tugu isa sa sa tasalana sa na tuna rereko isa. ");
INSERT INTO lga_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ego sa taloa ketakoi si Jisu ko sa poana vei pa ovuku Qalili, beto sa sagere saea isa sa kai kubo ko sa toqo ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ego ko qai vaikamu lame tana sira soku pupuku minete tinoni. Qai okoto toni lameniria ira tana sira qai qao, ira sa mate kale kaki kobu tinidi, ira na leqa, ira na poka beto kubo tinoni mo mule. Ko qai lao loaria pa kekerena i Jisu, ko sa salana betoria i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ko qai gabara beto sira na tinoni tonai qai batia na poka sa paranga, ira sa mate kale na tinidi qai jonga ligu, na qao sa rerege beto na leqa ba sa babata. Ko qai vatarasaea ira sa na Tamasa tadira na tinoni Izireli. ");
INSERT INTO lga_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ego sa kuku tekuria i Jisu sira na ona sepele ko pira sauniria, <<Qa roroqu vivitigiria ara sira na tinoni pira, ura tei kue ranedi tu sa qai kole tututi taqu ko kopira sa kepore kai sava mai tekua. Qake nyoguania ara sa ba garunu variu buburanaria, ura kode mai rake ko mai tabubulo pa soana,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Poni qai parangia sira na ona sepele, <<E, ba na minete tinoni lavata sapi ko pai tana boka teku gagani ko tana vateteku vapoteniria sa pa ia kaloina vei pira?>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","<<Ka visa bereti sa qu isongia?>> sau si Jisu. <<Ka vitu gu, beto ko ka visa igana ikikete gu,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Poni sa pojaniria i Jisu sira na minete tinoni ko qai toqo beto pa peso. ");
INSERT INTO lga_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Beto sa tekuria isa sa ka vitu bereti beto vei tugu na igana, ko sa paranga jongananiria, beto sa kikiparia, ko sa vaniria ira na sepele ko ira na sepele qai ia lao vaniria na minete tinoni. ");
INSERT INTO lga_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ko qai teteku beto sira doru tinoni, ko qai pote vatale beto. Beto sa qai tekuria ira na sepele sa ka vitu totopa, ko qai vapugele nyonyoaniria na gagani kole joladi. ");
INSERT INTO lga_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ko na anyedi ira na tinoni qai teteku sira ka made tina na marene, goto ira na rereko beto ko ira na koburu sa qaike taanye. ");
INSERT INTO lga_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ego ko pa liguna sa garunu vamule riuria i Jisu sira na minete tinoni, poni sa sa lao koi pa koaka sisa, ko sa toka lao vei tu pa gugusu pa Magadani. ");
INSERT INTO lga_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ego qai lame tai Jisu sira kaki Parese beto ko na Sadusisi ko mai vagonai sisa qarigu, ko qai garunia sisa ko mi roiti vavotu vaniria kai roiti vaivagabarana jola tana Tamasa, ko vei sa mai vasosotoa na koko lamena tugu tana Tamasa sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ba sa oeria i Jisu sira, pira sauniria, <<(Totonai sa gore na vevelu, sa pira qugu sagou, <Koi, kode mina bule sa neqa, ura sa maqarea na oka!> qugu. ");
INSERT INTO lga_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Goto na vuvugei sa pira qugu, <Koi, kode mina okoro sa pa ngeni, ura sa varodomo beto sa dudurumana sa na oka,> qugu. Qu boka doro gigilai agou sa ai mina vevei na vavagalo eqa tonai qu doria na oka, goto quke boka doro gigilai agou sira na vinagigila pa totoso kopira.) ");
INSERT INTO lga_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ao na sasae tinoni ikikeremu beto na vavakeporea na Tamasa sa qu korapa nyoguania kai roiti vaivagabarana jola? E, ba kepore sa kai roiti vaivagabarana muna tavadogoronia, goto isa tugu na roiti vaivagabarana muna tavadogoronia agou sa mekana gu na roiti vaivagabarana sa taroiti ti Jona na tinoni kokorotai,>> sauniria. Beto sa sa loaria sira ko sa riuona. ");
INSERT INTO lga_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Totonai qai toka karovo lao pa kai kale karovona na ovuku sa qai roqu muma sira na sepele, ko qaike pogoso bereti besa. ");
INSERT INTO lga_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Poni sa pira sauniria i Jisu, <<Muna balaunia na vavakovuruni palava tadira na Parese beto na Sadusisi,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Totonai qai nongoria sau isa, sa qai kole vavaiparanga mule mekadi sira, pira qarigu, <<Taqeke pogoso bereti gita sa sa korapa paranga vei isa,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ba sa tei gigilaiona tu i Jisu sisa na manugu qai kole pojai ira, ko pira sauniria, <<Ai sa vei ko qu korapa vavaiparangania agou sa isa na veveina kepore gamiu bereti? Sa ikete jola na miu rarange sagou! ");
INSERT INTO lga_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ai vei, qu oqoro tugu vakoinonoa agou? Quke roqu vakoititia tu agou sa totonai qa kikiparia ka lima bereti ara, ko qa ianiria ira ka lima tina tinoni? Ka visa totopa sa qu vapugeleniria na gagani kole joladi agou totonai? ");
INSERT INTO lga_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ko ai sa vei sa ka vitu bereti tonai qa ianiria ira ka made tina tinoni? Ka visa totopa sa qu vapugeleniria na gagani kole joladi agou totonai? ");
INSERT INTO lga_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ai sa vei ko quke boka vakoinonoa tu agou sa nake bereti sa qa korapa qaunia ara? Mu kopu mulenigou pa vavakovuruni palava tadira na Parese beto na Sadusisi,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tonai sa qai gigila kamua ira na sepele sa nake veveina na vavakovuruni palava bereti sa sa korapa vabalau muleniria isa, goto na vaivagigalai tu tadira na Parese beto na Sadusisi sa saunia isa. ");
INSERT INTO lga_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ego sa taloa riu si Jisu ko sa lao pa kai ia tata pa gugusu lavata pa Sizaria Pilipae. Ko ketakoi sa sa nanasaria i Jisu sira na ona sepele, <<I sei qaqarigunia ira na tinoni sa na Tuna na Tinoni?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Poni pira qarigu sira na sepele, <<Kaki qai paranga i Jone Paputaiso qarigu, kaki i Elaija qarigu, kaki i Jeremae ba palu kame ira kaki goto tinoni kokorotai qarigu,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Poni pira sauniria, <<Goto agou sa i sei ququgunisiu sara?>> sau. ");
INSERT INTO lga_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Poni sa oe i Saimone Pita, pira sau, <<Ao sa na Karisito, na Tuna na Tamasa toana,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Poni sa oea i Jisu, pira saunia, <<Na tamanamu sao Saimone na tuna i Jona! Na sosoto isa sa nake ira na tinoni qai ule vanigo ao, goto sa ianigo sosoto na Tamaqu tu ara pa noka. ");
INSERT INTO lga_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma pojanigo ara sao: i Pita sao, na ginuana nisongomu sa na Patu, ko pa patu kokovana tugu api sa mana vaturua ara sa na qua ekelesia, ko na neqi tana mate minake boka vakilasia sa na ekelesia. ");
INSERT INTO lga_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mana vanigo ara sira na vidulu revangana na binangara pa noka, ko isa vei qu pukua ao pa peso sa mina tei tapuku tugu pa noka, beto ko isa vei qu ruvatia ao pa peso sa pa noka ba mina tei taruvata tugu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Beto sa naquria i Jisu sira na ona sepele ko maike vavaqatania sa na veveina isa tugu sa na Karisito sauniria. ");
INSERT INTO lga_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ego ko podalai tugu pana totoso isa sa sa podalai vavakato vakabere vatatalenia i Jisu tadira na ona sepele sa na veveina nona vitigi. Ko pira sauniria, <<Kode mana gore pa Jerusalema sara, ko mana gosoria na vitigi tadira na iviva mamata, na kuta iama, ira qai vaivagigalainia na Vavanau, beto ko mana tavamate. Ba pa vinaue rane mana turu mule pa mate,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Poni sa toni kalenia i Pita si Jisu ko sa tokea, pira saunia, <<Sake vamalumia na Tamasa sa vei isa, Bangara! Minake isongo taroiti tamu sa sa vei inara!>> sau si Pita. ");
INSERT INTO lga_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Poni sa bata kekeria ko pira saunia si Pita, <<Rijo riu taqu, Setani! Ao sa na kokobu vaivatatupe pa moequ ara, ura ira na roroqu pira sa nake lame veidi tana Tamasa, goto tana tinoni gu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Beto sa pira sauniria i Jisu sira na ona sepele, <<Na tinoni sa nyogua tutisiu ara, sa mi roqu muma palenia mekana, mi pogosia na ona korosi ko mi tutisiu sara. ");
INSERT INTO lga_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ura isa sa nyogua kopu vatalenia na ona toa mekana sa kode mina saivia tugu sa nona toa. Goto isa sa gona pale na ona toa pa ginuana sa tutisiu ara sa mina batia tugu na toa. ");
INSERT INTO lga_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Na sa sa mina vagavoria na tinoni vei bi gona palea na ona toa ko bi isongia sa na kasia gusu doruna? Bi julingai tu! Ko na sa sa mina roitinia isa ko mina boka teku beia sa na ona toa? Bi mija tu! ");
INSERT INTO lga_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ura nake sovaina mina lame sa na Tuna na Tinoni beto ira na ona mateana. Kode mina lame pa neqi tana Tamana ko mina okoto vaniria na pinia padana na dia roiti sira doru tinoni. ");
INSERT INTO lga_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ma poja sosotonigou ara sagou: kaki agou qu korapa turu tavitisiu ara pira sa mai oqoro mate, sa mai batia sa na lamena na Tuna na Tinoni mina lame vei na Bangara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ego sa jola gu ka vonomo rane, sa sa tonia i Jisu si Pita beto ira Jekopi i Jone kao tamatasi, ko qai sagere sae pa kai kubo ululuna ko qai kole suvere mekadi ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ko tonai qai doro laoa si Jisu sa sa dogoro goto sa na tinina. Na isumatana sa sa tolanga vei na tapo, goto na ona poko sa sa keka vavalaka. ");
INSERT INTO lga_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Beto api! Qai bola votu kamuria sira Mosese i Elaija ko qai kole paparangia si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Poni sa paranga si Pita, pira saunia i Jisu, <<Bangara, sa vavagua jola sa taqe suvere gita lani! Vei muna vajonganai ao, sa ara ma roitinia kue aqaqo; ko kame tamu, kame ti Mosese, beto kame tai Elaija,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ko sa korapa tugu paparanga vei inara i Pita, sa sa lame kai lei keala ko sa amu vapaeria sira doru. Beto qai nongoria sa kai ovovele pa leona na lei pira sau, <<Api sa na Tuqu qa roroqua beto qa qera vivitiginia ara. Mu nongoria sisa!>> sau. ");
INSERT INTO lga_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Totonai qai nongoria ira kue sepele sa na ovovele poni sa qai matagutu vivitigi, ko qai gona toqo pa peso ko qai todongo. ");
INSERT INTO lga_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Poni sa lao si Jisu ko sa uliria sira kue, beto pira sauniria, <<Turu, muke matagutu!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ko tonai mai enga qarigu sa sa kepore mule sa kai tinoni bai batia goto i Jisu gu mekana. ");
INSERT INTO lga_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tonai qai korapa mule gore na kokodi pa kubo, sa sa naquria i Jisu sira kue, pira sauniria, <<Munake vavakatonia tana kai tinoni sa na dodogoro vei qu batia agou, koi vei tu mina tavaturu mule pa mate sa na Tuna na Tinoni,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Qai nanasia ira na sepele si Jisu, pira qarigu, <<Ai sa vei ko qai paranga sira qai vaivagigalainia na Vavanau kode i Elaija tu sa mina mule lame momoe mai tonai mina oqoro kamu na Mesaea?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Poni sa oeria i Jisu sira, pira sau, <<E, i Elaija sa mina lame momoe tugu ko mina vatana vatuvisi momoeria sa doru sakasava. ");
INSERT INTO lga_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ba ma pojanigou agou: sa tei mule lame momoe tu si Elaija, ba qaike doro gigalia ira na tinoni sisa, ko qai ngangangulu veinia isa qai nyogua veinia. Ko na Tuna na Tinoni ba kode mai ngangangulu veinia mutugu ira na tinoni,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ego ko ketakoi sa qai gigila vakabere vatalea ira na sepele sa i Jone Paputaiso gu sa saunia isa. ");
INSERT INTO lga_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ego totonai qai gabala mule kamu tadira na minete tinoni sira, sa sa lao gona toqo sori tutungu pa moena i Jisu sa kai tinoni, ");
INSERT INTO lga_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ko sa paranga, <<Bangara, mu roroqu tokania na tuqu marene! Sa vavainia na mo kirenge ko sa vavaaru vikerenia ko kaki totoso sa vavukele laoa tugu pa niku beto pa kolo. ");
INSERT INTO lga_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Qa tei toni laonia tugu tadira na mua sepele ba qaike boka salania,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Poni sa oea i Jisu, pira saunia, <<Koi, agou na sasae tinoni quke vasosoto beto quke gigilai na tuvisi! Ai tu mina koi vei sovai vei sa mana kole suvere tavitigou na jujunonigou ara sagou? Mu toni lamenia taqu sa na marene ina!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Beto sa iju palea i Jisu sa na tomate ikikerena sa kole tana marene, ko sa votu riu tana, ko sa tasalana tugu na totoso isa sisa. ");
INSERT INTO lga_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Beto sa tonai qai suvere mekadi tu sa qai lame ti Jisu sira na sepele ko qai nanasa, <<Ai sa vei ko qeke boka iju votunia agei sa na tomate ina?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Poni sa pira sauniria i Jisu, <<Ura koko vei sa ikete jola na miu rarange! Ura ma poja sosotonigou ara sagou: vei bu isongia iapeki rarange bi podeke iketena vei kai kiko masitadi, sa vei bu paranga veinia gu pira sa na kubo api, <Mu rijo lao pa poni!> bugu, sa kode mina lao tugu. Kepore sa kai sava mina tapatagou. ");
INSERT INTO lga_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Na tomate ikikerena veveina ina, sa sake tasalana goboro, goto pa vavara beto pa tatabu teteku gu sa kode mina boka taiju pale,)>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Totonai qai vaikamu pa Qalili sira doru sepele, sa pira sauniria i Jisu, <<Na Tuna na Tinoni sa kode mina tavalao pa limadi ira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ko mina tavamate sisa, ba pa vinaue rane sa mina toa mule pa mate sisa,>> sauniria. Ko qai mamata vivitigi sira na sepele. ");
INSERT INTO lga_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Totonai sa kamu si Jisu beto ko ira na sepele pa Kepaniami, sa qai lao tai Pita sira na tinoni teteku takisi ruma zelepade ko qai nanasia, <<Ai sa vei sa tabaria tugu na miu tinoni vaivagigalai sa na takisi ruma zelepade?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","<<E,>> sau si Pita. Isa tugu sa tome pa leo ruma i Pita sa sa paranga si Jisu, <<Saimone, na sa sa qu roroqua ao? I sei sa tatabaria sa na takisi tadira na babangara pa kasia abana api? Ira na tudia sosoto na bangara, ba ira tu na tinoni gotodi?>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Poni pira sau si Pita, <<Ira tu na tinoni gotodi,>> saunia. <<Koi, e, jongana,>> sau si Jisu. <<Ko na ginuana isa kisa ira na tudia sosoto na bangara ko maike tabaria sa na takisi. ");
INSERT INTO lga_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ba sake jongana tana vatagigiriria na tinoni, ko ao mu riu tu pa kolo ko mu ipania na tali. Muna kao vapodakia ao sisa na igana muna vagani momoea ko tonai muna asanga vamamangai, kode muna batia sa kai poata siliva na padana na takisi ruma zelepade tadagita karu. Muna tekua, ko muna lao vaniria na takisi tadagita karu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ego pana totoso tugu isa sa qai lao sira na sepele ti Jisu ko pira qai nanasa veinia sisa, <<I sei sa na poreveveina jola pa binangara pa noka?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Poni sa kuku tekua i Jisu sa kai koburu ikete, ko sa vaturua pa moedi ira, ");
INSERT INTO lga_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","beto pira sauniria, <<Ma poja sosotonigou ara sagou: vei munake beia agou sa na miu toa ko munake toa vei ira na koburu, sa munake isongo tomea tugu agou sa na binangara pa noka. ");
INSERT INTO lga_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Isa na tinoni gu sa vaikete mule veinia na koburu ikete api, sa isa sa poreveveina jola pa binangara pa noka. ");
INSERT INTO lga_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Isa sa vatoga vatalea pa isongoqu ara sa kai koburu ikete vevei api sa sa vakamusiu tugu sara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","<<Na tinoni sa vatatupenia sa kame ira na koburu vevei api sa vasosotosiu ara, sa jongana jola sa bi pikoni patu doa lavata na ruana, beto bi riu valupi palea pa kolo lilisina sisa. ");
INSERT INTO lga_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mi takulangagana tu na kasia gusu ura sa kolea na sakasava vaivatatupe! Maike koroto na lamedi sira na sakasava vaivatatupe, ba mi takulangagana tu sa isa sa valameria ira na sakasava vaivatatupe. ");
INSERT INTO lga_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ko vei kai kale limamu babi kai kale nenemu sa bi vatatupenigo, sa mu lomoto vaqopu palea ko mu gona palea! Ura jongana jola sa nake savana sa bu toa qoqopumu gu sao beto bu tome pa toa jola. Isa bu vei sa sa jongana jolania bu tagona lao doruru karu limamu beto karu nenemu pa iku kole jolana. ");
INSERT INTO lga_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Beto vei na matamu sa bi vatatupenigo, sa mu ujolo palea ko mu gona palea! Ura jongana jola sa bu mamata kale gu tome pa toa jola. Isa bu vei sa sa jongana jolania bu isongoria karu matamu beto bu tagona lao maladorurumu pa iku pa heli,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","<<Mu kopunia ko muke doro vakepore veveinaia sa kame ira na koburu ikikete vevei api. Ura ma pojanigou: na dia mateana na suveredi doru totoso pa moena na Tamaqu pa noka sa sa kopuniria. ");
INSERT INTO lga_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Ura na Tuna na Tinoni sa sa lame ko mi aloa na tinoni mumana sau.) ");
INSERT INTO lga_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ai beka qu roroqu veinia agou sa na tinoni sa isongia kai gogoto ona sipi, ko vei kame ira nona sipi sa bi muma? Kode mina loaria mai sira ka siangavulu sia ko mai kole ngojagadi buburu pa kubo, goto isa mina riu ko mina nyaqoa sa isa na sipi sa muma. ");
INSERT INTO lga_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ko tonai mina bati ligua sa na ona sipi sa muma sa ma poja sosotonigou ara sagou: na ona qerana na sipi sa muma api sa sa jolania na ona qeradi ira ka siangavulu sia qaike muma. ");
INSERT INTO lga_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ko kai muqisi podeke vei tugu isa sa na Tamada pa noka sake nyoguania isa sa kame ira na koburu ikete vei pira ko bi muma,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","<<Ego vei bi roitinia kai sela tamu sa na tasimu, sa mu lao ko pa vaikorapaimiu gu agou karu mekamiu sa mu udukia sa na ona sela. Ko vei mina nongorigo, poni sa qu alo mulenia ao sa na tasimu. ");
INSERT INTO lga_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Goto vei mina daiona nongorigo, poni sa mu toni lao tavitinigo mule sa kame babi karu tinoni, ko isa vei sa pojai na Kukuti Tabuna sa pa moedi ira karu babi kue tinoni nonongoro tu mai tavatoqo sa doru paranga. ");
INSERT INTO lga_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ba vei minake nongororia tugu sira qu toniria, poni sa mu ule vania na ekelesia totonai. Ko vei mina daiona tugu nongoria isa sa na ekelesia, poni sa totonai sa mu doro veinia gu kai tinoni rodomo beto kai tinoni teteku takisi sisa. ");
INSERT INTO lga_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ma poja sosotonigou ara sagou: isa qu pukua agou pa peso sa mina tei tapuku tugu pa noka, beto isa qu ruvatia agou pa peso sa pa noka ba mina tei taruvata tugu. ");
INSERT INTO lga_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ma kai poja sosotonigou mule ara sagou: vei ira karu tinoni pa peso agou sa bai vaivaegonia sa kai sakasava ko bai vavarania, sa kode mina roiti vanigou gu na Tamaqu pa noka sisa. ");
INSERT INTO lga_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ura ketakoi mai suvere vaikamu karu babi kue tinoni pa isongoqu ara, poni sa ketakoi tugu qa somana suvere sara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Beto sa lao nanasia i Pita si Jisu, <<Bangara, ka visa totoso sa kai turaqu mina kole gu roiti lamenia na sela taqu beto ara mana kole gu taleosonia sisa? Ka vitu totoso?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Poni sa pira saunia i Jisu sisa, <<Dai, nake ka vitu totoso, goto ka vitungavuluputa totoso vitu. ");
INSERT INTO lga_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ura na binangara pa noka sa pira tu sa vei. Koleona sa kai bangara sa nyorogua vatuvisiria na lilipu tadira na ona tinoni roiti. ");
INSERT INTO lga_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Isa tugu sa podalai dororia isa sira na lilipu poni sa qai toni tomenia gu ira sa kai tinoni poreona lilipu, ko na soku gogoto tina poata nona lilipu tana bangara sisa. ");
INSERT INTO lga_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ba na nabulu api sa sake ngaolo na ona poata ko sake boka lipu betoria sira na ona lilipu. Ko pira sa paranga veinia na bangara sisa, <Muna tavavai vei na pinausu sao, na maqotamu, ira na tumu beto ko dorudi na mua sakasava qu isongoria, ko mina talipu sa na mua lilipu,> sau sa na bangara. ");
INSERT INTO lga_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Poni sa gona toqo sori tutungu pa moena na bangara sa na nabulu api ko pira sa tepa vei, <Koi, bangara muke veinisiu! Mu vanisiu na totoso beto kode mana lipu vaokoto betoria sira na qua lilipu tamu,> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Poni na bangara sa sa roqua gu mule sa na nabulu isa, ko sa taleosonia gu sa doruna nona lilipu beto sa sa vamalumu riua. ");
INSERT INTO lga_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ba beto totonai sa taloa ko sa votu riu sa na nabulu api, sa sa lao gu gosoria sa kai nabulu tavitina isa ka visa poata gu nona lilipu tana. Sa lao ragata tekua ko sa rae orangia na ruana, beto pira saunia, <Sisiqarai lipuria na mua lilipu taqu!> saunia. ");
INSERT INTO lga_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Poni sa gona toqo sori tutungu mutugu sa na nabulu tavitina api beto sa paranga, <Koi, muke veinisiu, mu vanisiu na totoso beto kode mana vanigo gu sira na qua lilipu,> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ba sa daiona sa na nabulu api goto sa lao gona vatome pale pa ruma vaipiu tinganai mina lipu betoria tu nona lilipu sau. ");
INSERT INTO lga_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ego ko qai dogoro vaia ira kaki nabulu tavitina sa isa sa roiti vei isa poni sa qai takulanga jola, ko qai lao ule vania na bangara sisa vei sa roitinia na nabulu isa. ");
INSERT INTO lga_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Poni sa kuku mulenia na bangara sa na nabulu isa, ko pira saunia, <Na nabulu ikeremu jola sao! Ara dorudi na mua lilipu taqu sa qa taleosonigo, ura ao qu tepa taqu. ");
INSERT INTO lga_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ba ao ai sa vei sa quke roroqu tokania sa na nabulu tavitimu ina, vei qa roroqu toka veinigo ara?> saunia. ");
INSERT INTO lga_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ko sa tagigiri vivitigi sa na bangara, ko sa valao palea pa ruma vaipiu sa na nabulu isa, ko mi tavakilasa tinganai mina lipu betoria tu isa sira dorudi nona lilipu sau. ");
INSERT INTO lga_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ko isa inara kode mina okoto veinigou na Tamaqu ara pa noka sagou doru vei munake okoto taleoso sosotoniria pa bulomiu agou sira na turamiu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ego totonai sa beto vaivagigalainiria i Jisu sira na sakasava pira, sa sa taloa pa Qalili sisa ko sa sae pa ia pikata gugusu Jiudia pa kai karovona na pie Jodani. ");
INSERT INTO lga_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ko na vaikamu tinoni lavata sa qai tutia isa, beto ketakoi tugu sa salana betoria isa. ");
INSERT INTO lga_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ego ira kaki Parese sa qai lame tana ko qai nyogua podekia sisa. Ko qai gonania na nanasa ira sisa, pira qarigu, <<Ai vei, na tavamalumuna pa Vavanau sa mina boka loa pale kai tinoni sa na maqotana pa ai ginugua vei gu sa nyoguania isa?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Poni sa oeria i Jisu, pira sauniria, <<Beko qu tei tiroamiu tu ba qu oqoro tu vakaberia agou sa na Kukuti Tabuna? Pira sau sa na Kukuti Tabuna, <Pa popodalaina sa sa tei vapodaka vamarenia beto varerekoa tu na Tamasa sa na tinoni,> sau. ");
INSERT INTO lga_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Beto pira mutu sau, <Ko pa ginuana isa sa mina boka taloa tana tinana beto na tamana sa na marene ko mina kole kame tana maqotana, ko mai kame gu sira karu,> sau. ");
INSERT INTO lga_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ko maike pikatarua sira karu, ba kame gu. Ko isa vei sa tei vaipuku tariniria tu na Tamasa sa kepore kai tinoni mi vaivisuniria,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Poni qai nanasa bei sira na Parese, <<Ba ai sa vei ko i Mosese sa vaivagarununia tu sa mina boka kutia na marene sa kai pepa vailoa, beto sa mina iju variu palea sa na maqotana?>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Poni sa oeria i Jisu sira, <<Na ginuana sa vamalumunigou i Mosese sisa sa ura koko vei sa tapata na tavavanaumiu sagou. Goto pa podalaina sa sake vei inara sa. ");
INSERT INTO lga_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ko ara sa pira ma poja veinigou: bike vavaiputa taviti goboro sa na maqotana kai marene, ba bi lao na marene ko bi loa pale sa na maqotana isa ko bi alava beia mule kai goto rereko, sa sa babarata tugu sa na marene isa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Poni qai parangia sira na ona sepele, <<Vei mina isa sa na ginuana vei na marene mina boka loai na maqotana, poni sa jongana jola sa mike pavu vaialava sa na tinoni,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Poni sa oeria i Jisu sira, <<Nake ira doru tinoni mai boka tekua sa na vaivagigalai api, ba ira gu sa tei vaniria tu na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ura koledia sa kubo okokoto ginugua vei beto qaike boka vaialava ira na tinoni: kaki na podo veidi tu, kaki na tinoni gu qai lida vaegoro veini paleria, goto kaki qaike vaialava ura qai nyogua nabulu vania na binangara pa noka. Na tinoni mina boka tekua na vavanau api sa mi tekua tugu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ego ira kaki sa qai toni laoniria ti Jisu sira na koburu ko mi vaoponiria na limana beto mi mananiria isa qarigu, ba qai tokeria ira na sepele sira na tinoni qai vaitoni lame. ");
INSERT INTO lga_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ba pira sau i Jisu, <<Mu vamalumuria sira na koburu ko mai lame taqu, muke suquturia. Ura tadira tugu vevei aipira sa na binangara pa noka,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Beto sa vaoponiria na limana isa sira na koburu ikikete ko sa mananiria, beto sa sa taloa riu. ");
INSERT INTO lga_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ego koleona sa kai tinoni sa kamu tai Jisu ko pira sau, <<Tinoni vaivagigalai, ai roiti jongana sa mana roitinia ara beto mana tekua ara sa na toa jola?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Poni sa oea i Jisu, pira sau, <<Ai sa vei ko qu nanasania ao taqu sa na veveina na jongana? Kame gu mekana sa isa sa jongana. Vei muna nyogua tekua na toa ao, sa mu kopuniria na garunu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","<<Na garunu ai veveidi?>> sau sa na tinoni api. Poni sa paranga si Jisu, <<Na garunu sa pira: munake varivai, munake babarata, munake ikiko, munake jutu seseke, ");
INSERT INTO lga_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","mu valavataria na tinamu na tamamu, muna roroqua na tavitimu kai muqisi podeke vei qu roroqu mule veinigo mekamu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Poni sa paranga sa na tinoni api, <<Doru garunu pira sa qa tei tuti betoria tu ara sira, goto na sa mule sa mana roitiniria ara?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Poni sa pira saunia i Jisu sisa, <<Vei muna nyogua nabu pa mua tuti sao, sa mu lao ko mu vavainiria na mua sakasava qu isongoria, ko na poatadi mu vaniria ira na tinoni vaivasevidi. Beto sa muna tekuria ao sira na isisongo pa noka, beto sa mu lame tutisiu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Totonai sa nongoria na tinoni koregana api sa na paranga isa sa sa takulanga ko sa riuona, ura sa soku nona isisongo sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Beto sa pira sauniria i Jisu sira nona sepele, <<Ma poja sosotonigou ara sagou: sa tapata vivitigi tana tinoni isisongo sa mina tome pa binangara pa noka sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma kai poja vatalenigou mule ara sagou: sa tapata jola tana tinoni isisongo sa mina tome pa binangara tana Tamasa sisa, sa tapata jolania na kameli bi sulingi tomea sa na talupuru nila,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Totonai qai nongoria ira na sepele sapi sa qai gabara vivitigi ko pira qarigu, <<Ko i sei gu sa mina boka taalo sa vei?>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Poni sa do tariria i Jisu sira beto pira sauniria, <<Tana tinoni sa tapata vivitigi sapi, goto tana Tamasa sa doru sakasava qaike tapata,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Poni sa oe si Pita, pira saunia, <<Doro! Agei qe tei loa paleria tu sira doru mei sakasava ko qe tei tutigomei tu ao. Ko na sa sa mene isongia agei?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Poni sa pira sauniria i Jisu sira, <<Ma poja sosotonigou ara sagou: totonai mina toqo pa nona totoqona bangara sa na Tuna na Tinoni pa totoso tana ona binangara, sa muna somana toqo pa manogarua totoqona bangara sagou ka manogarua sepele, ko muna bangaraniria sira ka manogarua bubutu Izireli. ");
INSERT INTO lga_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Beto ko ira doru qai loaria na dia ruma na tasidi marene na luludi rereko babi na tamadi na tinadi beto ira na tudia na peso na vei pa dia tutiqu ara, sa mina ia beiniria na Tamasa kai gogoto totoso mota jolaniria vei ira qai loaria ira beto mai teku isongia vei na toa jola. ");
INSERT INTO lga_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ba ira soku qai momoe sa mai liligu, beto ira soku qai liligu sa mai momoe,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","<<Na binangara pa noka sa kai muqisi podeke vei kai tinoni sa taloa votu riu vuvugei jonga ko sa lao nyaqo tinoni ko mai roiti pa nona inuma qurepi sau. ");
INSERT INTO lga_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ego ko pa liguna isa beto ira na tinoni roiti qai mekarai vaivaegonia sa isa mina tabaraniria na padana kai poata siliva pa kai rane qarigu, poni sa sa garunu variu roitiria pa nona inuma qurepi isa sira. ");
INSERT INTO lga_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ego ko sa votu riu bei mule pa ia mamaketina papada sia koloko sau sisa, sa sa batiria mule sira kaki tinoni qai korapa turu goborodia kepore kai sava bai roitinia. ");
INSERT INTO lga_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Poni sa pojaniria mule sira, <Agou ba mu lao tugu roiti pa inuma qurepi taqu. Kode mana tabaranigou tugu isa mana doro vatuvisia ara,> sauniria isa sira. ");
INSERT INTO lga_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ko qai taloa riu tugu roiti sira. Ego pa manogarua koloko, beto pa kue koloko ba sa roiti vei tugu, ko sa tekuria tugu kaki tinoni ko sa garunu variu roitiria. ");
INSERT INTO lga_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Totonai sa tei tata lima koloko tu sa sa mule bei lao pa ia mamaketina sisa, sa sa batiria mule sa kaki tinoni qai korapa turu goborodia. Poni sa parangaria, <Na sa qu turunia lani na rane doruna kepore kai sava bu roitinia sagou?> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Poni sa pira qarigunia, <Ura kepore tinoni bi vanigei na roiti,> qarigunia. <Ego, jongana, agou ba mu lao tugu roiti pa inuma qurepi taqu,> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ego totonai sa gore na vevelu, na tinoni poreona inuma sa pojania sa na tinoni sa mamatania na roiti, <Mu kuku vaikamuniria ira na tinoni roiti ko mu vaniria na dia tabara. Mu podalai tadira qai podalai liligu tinganai muna kamuria ira qai podalai momoe,> saunia. ");
INSERT INTO lga_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ego ko ira na tinoni qai podalai roiti lima koloko sa sa vaniria kai poata siliva pa kai tinoni. ");
INSERT INTO lga_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ko totonai mai lao tekudia tabara qarigu sira qai roiti momoe, sa qai kole roroqu kode mene teku vakubo qarigu. Ba totonai qai okoto teku, sa qai vaitoto vei tugu ira qai podalai roiti liligu sira. ");
INSERT INTO lga_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ko tonai qai tekuria na poata sa qai kole ququmunia ira sa na tinoni sa varoitiria pa ona inuma. ");
INSERT INTO lga_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Qai paranga sira, <Ira na tinoni qai podalai liligu sa kai aoa gu qai roiti, goto agei sa qe pogosia na mamatana na rane beto qe vaivasevi na mangini, ba ira ba qu vaitoto veinigei tugu agei,> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Poni sa oea na tinoni poreona inuma sa kame ira, pira saunia, <Baere, qake nganganguligo ara sao. Beko taqe mekarai vaivaegonia tu gita karu sa ao muna roiti na rane doruna beto ko ara mana tabaranigo kai poata siliva taqeu tu. ");
INSERT INTO lga_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mu pogosia gu na mua tabara ko mu mule riumua pa mua ruma. Isa na nyorogua taqu sa isa vei qa vania na tinoni sa roiti liligu, vei tugu isa qa vanigo ao. ");
INSERT INTO lga_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Quke gigilai ao sa na qua tuvisina mekaqu ara ko mana varoiti veinia isa qa nyorogua veinia sa na qua poata mekaqu? Ba palu qu kono beka ao ura ara na tinoni jongaqu?> saunia. ");
INSERT INTO lga_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ko inara sa vei sa ira qai liligu sa mai momoe, goto ira qai momoe sa mai liligu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tonai sa korapa rerege sae pa Jerusalema si Jisu, sa sa teku kaleniria sira na ona sepele ko sa pojaniria, pira sau, ");
INSERT INTO lga_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Mu vainongoro lame! Taqe korapa sae pa Jerusalema sa gita, ko ketakoi sa kode mina tavalao pa limadi ira na kuta iama beto ira qai vaivagigalainia na Vavanau sa na Tuna na Tinoni. Ko kode mai jutua ko mai vamatea ");
INSERT INTO lga_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","beto sa mai valaoa ira tadira na tinoni karovodi ko mai vavaledenia, mai piqolia beto mai vamatea pa korosi sisa. Ba pa vinaue rane sa mina turu mule pa mate sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pa liguna isa sa lao tai Jisu sa na maqotana i Zebeti beto karu tuna marene, ko sa todongo pa moena isa ko mi tepai kai sa tana sau. ");
INSERT INTO lga_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Poni sa nanasa si Jisu sa na rereko isa, <<Na sa sa qu nyoguania ao?>> saunia. Poni sa oe lao sisa, <<Bangara, mu vakolea na taringunguti ko ira karu tuqu marene pira mai toqo tavitigo ao pa mua binangara, kame pa kale matuamu kame pa kale merimu,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Poni sa oeria i Jisu ria, pira sauniria, <<Quke gigilai agou karu sisa qu korapa tepaia. Ai vei muna boka tugu gosoria agou sa na vitigi mana gosoria ara?>> sau sisa. Poni qai oe lao sira karu, <<E, mene boka gu,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Poni sa pira sauniria i Jisu sira karu, <<E, kode muna somana gosoria tugu agou karu sa na vitigi mana gosoria ara. Ba na neqi vei beto mina tavile i sei pa kale matua i sei pa kale meri sa nake taqu. Ira na ia veveidi pira sa na Tamaqu tu sa tei vatana vaniria ira tu sa tei vileria tu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tonai qai nongoria ira ka manogaputa sepele sa sa vei inara, sa qai tagigiriniria sira kao tamatasi. ");
INSERT INTO lga_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Poni sa kuku vaikamuniria i Jisu sira doru sepele ko pira sauniria, <<Qu gigilaimiu agou sira na bangara tadira na tinoni karovodi sa qai lalaenia sa na toa tadira na dia tinoni, beto ira na tinoni lalavata qai vatadogoronia na dia neqi tadira na dia tinoni. ");
INSERT INTO lga_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ba tamugou sa minake vei inara. Isa sa nyogua tavalavata agou, sa mina nabulunigou tu agou doru. ");
INSERT INTO lga_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Beto isa sa nyogua momoenigou agou sa mina pinausu tu tamugou doru. ");
INSERT INTO lga_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kai muqisi podeke na Tuna na Tinoni sa sake lame ko ira na tinoni mai vabangaria, goto sa lame nabulunia na tinoni beto sa vania na ona toa ko sa pajuku aloria sira kubo tinoni,>> sauniria i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ego tonai sa taloa pa Jeriko si Jisu beto ira nona sepele, poni sa kai minete puku tinoni lavata sa sa tutiria. ");
INSERT INTO lga_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ego ko qai nongoronia ira karu tinoni leleqadi qai korapa toqo pa soana sa i Jisu sa korapa rerege jola lame qarigu, sa qai kuku votu, <<Mu roroqu tokanigei ao na Tuna i Devita!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Poni qai tokeria ira na minete tinoni sira karu ko mai noso qariguniria. Ba tonai sa qai kuku vaiolo viviva tu, <<Mu roroqu tokanigei ao na Tuna i Devita!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Poni sa turu noso si Jisu ko sa kukuria beto pira sauniria, <<Na sa sa qu nyoguania agou karu ko ba roiti vanigou ara?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","<<Bangara, qe nyoroguanigo ae karu ko bu vababatagei!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Poni sa roroqu vivitigiria i Jisu sira karu ko sa lao uliria na matadi, poni sa qaike ruavo tugu na babatadia sira karu ko qai tutiadia sisa. ");
INSERT INTO lga_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Totonai mai toga pa Jerusalema qarigu ko qai kamu pa Betipezi isa pa Kubo pa Olive si Jisu beto ko ira na ona sepele, poni sa sa garunu lao momoeniria i Jisu sira karu ona sepele, ");
INSERT INTO lga_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","pira sauniria, <<Mu lao pa gugusu pa moemiu kai karovona lao poni. Ko isa tugu muna lao kamu sa kode muna batia agou karu sa kai dongiki na tapiko vaturu kolena tavitia kai tuna. Mu ruvatia sa na dongiki beto mu toni lameniria taqu. ");
INSERT INTO lga_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Vei mai parangagou kaki tinoni, poni sa pira munagu, <Na Bangara sa nyoguania,> munagu, sa kode mai vamalumu vanigou,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ko sa taroiti vei pira sapi ko sa gore votu sa na paranga tana Bangara sa lame vei tana tinoni kokorotai, isa pira sau, ");
INSERT INTO lga_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Mu pojaniria sira na gugusu tinoni pa Zaione, pira muguniria, <Dotu sa korapa lalameona sa na miu Bangara! Sake tuara beto sa koia na dongiki, sa koi pa pokotona na tuni dongiki!> muguniria,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ko qai taloa lao sira karu sepele, ko qai roitinia tugu sisa vei sa garununiria i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Qai toni kamunia ira karu sa na dongiki beto ko na tuna, beto ko qai lovasa vamakeleniria ira pa pokotodi sa na dia koti beto sa koi si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ira na minete tinoni lavata qai lovasaniria na dia koti sa na soana, goto kaki qai kaele teku gou ko qai lovasa vakoleniria pa soana. ");
INSERT INTO lga_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na puku minete tinoni sa qai rerege pa moena beto pa liguna i Jisu beto qai kukuku, Aroia na Tuna i Devita! Sa tamana isa sa lame pa isongona na Bangara. Aroia pa nulu vavagalo, qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Totonai sa tome lao pa Jerusalema si Jisu, sa sa kirikanoko sa na gugusu doruna, <<I sei sa?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Poni sa qai oe lao sira na pupuku minete qai tutia isa, <<Isa na tinoni kokorotai sapi, i Jisu pa gugusu Nazareti pa Qalili,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ego ko sa tome lao pa kakabarena na zelepade si Jisu ko sa adu vovotuniria sira doru qai korapa vavai beto qai vavainiria na sakasava pa kakabarena zelepade, beto sa peluku vaopo paleria sira na tevolo tadira na tinoni bebei poata karovodi beto ira na totoqodi tadira qai vavainiria na kuru vavakukuvudi. ");
INSERT INTO lga_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Beto sa pira sauniria sira, <<Pira sau sa na Kukuti Tabuna, <Na qua ruma sa mina takukunia na ruma vavarana,> sau, ba agou sa qu roiti veinia na bevi ovovona tadira na tinoni raja ikikodi,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ego ko qai lao tana pa kakabarena zelepade sira na leqa beto na qao, ko sa salanaria isa. ");
INSERT INTO lga_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ba ira na kuta iama beto ira qai vaivagigalainia na Vavanau sa qai tagigiri totonai qai batiria na roiti vaivagabaradi sa roitiniria i Jisu beto ko qai nongoria na kukuku irirangadi na koburu pa kakabarena zelepade pira qaqarigu, <<Aroia na Tuna i Devita!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ko pira qarigunia si Jisu, <<Qu nongororiamua tu ao sisa qai korapa pojai ira inara?>> qarigunia. Poni, <<E, qa nongororiaqua. Qu oqoro tu tiro vakaberia agou sa na Kukuti Tabuna isa pira sau? <Qu vatanai ao pa mangadi ira na koburu beto na melalu sa na vinatarasae sosotona,> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ego tonai sa taloa tadira pa kakabarena na zelepade sisa poni sa lao pa Betani ko na bongina sa puta ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tonai sa rerege mule ligu lao pa Jerusalema na vuvugei jonga si Jisu, poni sa sa vaia na burana. ");
INSERT INTO lga_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ko sa batia sa kai gou piqi pa kekete soana, ko sa lao kamua ba kepore kai vuana bi batia goto gagale equruna gu. Poni sa pira saunia sa na gou piqi, <<Na iamu sa munake vua ligu mule sao!>> saunia. Isa tugu sa paranga vei inara isa, poni sa sake ruavo tugu malei mateona sa na gou isa. ");
INSERT INTO lga_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tonai qai batia ira na sepele sa vei inara sa qai gabara vivitigi, ko qai paranga sira, <<Ai sa vei ko sake ruavo tugu malei mateona sa na gou piqi ina?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Poni sa oeria i Jisu, pira sauniria, <<Ma poja sosotonigou ara sagou: vei muna vasosoto beto muneke ruarabeke pa miu rarange sagou, sa kode muna bokai gu agou sisa vei qa roiti veinia ara na gou piqi api. Ba nake mekana gu api, goto vei muna paranga laoa na kubo, <Mu iolo ao na kubo ina ko mu lao vukele pa ivere,> bugu, sa kode mina gore votu gu. ");
INSERT INTO lga_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Beto vei muna vasosoto sagou, sa kode muna tekua gu agou sisa vei qu tepai pa vavara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ego sa mule lao pa kakabarena zelepade si Jisu ko sa korapa vaivagigalai, sa qai kamu nananasia ira na kuta iama beto ira na iviva mamata tadira na tinoni sisa, <<Na neqi sa sa qu isongia ao? I sei sa vanigo na neqi ko qu roitiniria ao sira na sakasava aipira?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Poni sa oeria i Jisu, pira sauniria, <<Ara ba ma nanasanigou mai kai nanasa. Ko vei muna oe vatalea agou sa kode mana ule vanigou ara sa ai neqi veveina qa isongia ko qa boka roitiniria ara sa na sakasava veveidi pira. ");
INSERT INTO lga_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","I sei sa vania na neqi si Jone beto sa paputaiso tinoni? Na Tamasa ba na tinoni?>> sau sisa. Totonai qai nongoria sa paranga vei inara isa, sa qai kole vaigua mekadi, <<Na sa tanagu sa tana oe laonia? Ura vei tana paranga, <Na Tamasa sa vania,> tanagu, sa kode mina paranga sisa, <Ba ai sa vei ko quke vasosotoa tu agou si Jone?> kode minagunigita. ");
INSERT INTO lga_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Goto vei tana paranga, <Na tinoni qai vania,> tanagu, sa sa vaivamatagutu mutu sa na sa marigunigita ira na tinoni. Ura ira doru tinoni sa qai tei vasosotoa tu si Jone sa kai tinoni kokorotai,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ko qai oea gu si Jisu, pira qarigunia, <<Dai, qeke gigilai i sei sa vania na neqi si Jone beto sa paputaisoria na tinoni,>> qarigu sira. Poni sa pira sauniria i Jisu, <<Ego, ko ara ba maneke ule vanigou tugu ropi sa ai neqi veveina qa isongia beto qa roitiniria na sakasava veveidi pira,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","<<Ego, ai qu roqu veinia agou sa na vavakato api? Sa koleona sa kai tinoni karu na tuna marene. Sa lao momoe sisa tana tuna moa, ko pira sa garunu veinia, <Tuqu, ao sa pa ngeni api sa mu lao roiti pa inuma,> saunia. ");
INSERT INTO lga_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","<Koi, ara daiqua,> sau sa na tuna moa, ba sa sovai poni sa bei roroqu ko sa riu tugu. ");
INSERT INTO lga_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Beto sa lao mutugu tana tuna pa ligu sa na tamadi ko sa garunu veinia mutugu isa sa poja veinia na tuna moa, poni sa pira sa oe veinia, <E, jongana, tamaqu,> saunia, beto sa sake pavu riu roiti sisa. ");
INSERT INTO lga_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","I sei ira karu pira sa sa roitinia isa sa nyoguania na tamadi?>> sau si Jisu. Poni sa qai paranga sira, <<Isa pa moa,>> qarigu sira. Poni paranga si Jisu, <<Ma poja sosotonigou ara sagou: ira na tinoni ikikeredi vevei na tinoni teteku takisi beto na tugele sa mai tome jola lao momoenigou agou pa binangara tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ura sa tei kamu tu tamugou doru si Jone ko sa vabatinigou sa na soana tuvisina ko muna tutia, ba quke vasosotoa tu agou. Goto ira tu na tinoni teteku takisi beto na tugele sa qai vasosoto. Ko qu batiriamiu tugu agou sa na gabaladi ira na tinoni pira, ba agou sa quke bei podekia tugu na roqumiu ko bu vasosotoa si Jone,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","<<Ego, mu vainongoro lamenia mule kai vavakato vavapada api. Koleona sa kai tinoni sa isongo peso, ko sa roitinia na inuma qurepi, beto sa sa bara vailivutainia. Sa ruri valolua isa sa kai patu ketakoi mina monyo vakolonia na vaini sau. Beto sa sa roitinia kai ruma gegelena ketakoi mai suvere ira na tinoni roiti ko mai kopunia na inuma sau. Ego beto sa sa riu tu soru tinoni ko qai kamu roiti ko qai kopu vania sa na inuma, beto sa sa soni riu lelekogo pa gusu souna sisa. ");
INSERT INTO lga_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Totonai mi kamua sau sa na totoso lolokete, sa sa garunu laoniria na tinoni poreona inuma sa kaki ona pinausu, ko mai lao tadira na tinoni roiti ko mai teku vania na iana pa ona vuvua pa ona inuma sauniria. ");
INSERT INTO lga_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ba qai lao tu ira na tinoni roiti ko qai aru tamanaria sira na pinausu, ko kame sa qai mamajai, kame qai vai vamatea, goto kame mutu sa qai buti tarini patu. ");
INSERT INTO lga_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pa liguna isa sa sa garunuria mutugu sira kaki ona pinausu, ira sa qai mota jolaniria ira sa garunu momoeria. Ba qai roiti veiniria mutugu ira sa garunu laoniria momoe. ");
INSERT INTO lga_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pa liligu bebeto sa sa garunu laonia tadira sa na tuna sosoto. <Na tuqu sapi ko kode mai pangagania ira,> sau sa na rorove tana. ");
INSERT INTO lga_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ba totonai qai batia ira na tinoni roiti sa na tuna, sa qai kole vavaiparanga, <Api sa na tuna mina teku vakarovoria na isisongo tana tamana! Mei, lame ko ta vai vamate pale beto ta tekua noda sa na isisongo tana!> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ko qai lao ko qai ragata tekua, beto qai gona votunia keta peguruna na inuma, ko qai vamate palea sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Beto sa sa nanasa laoria i Jisu sira, <<Ego, vei totonai mina mule lame kamu sa na tinoni poreona inuma, sa na sa beka kode mina roitinia tadira na tinoni roiti pira?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Poni sa qai oea ira sisa, <<Kode mina vamate paleniria gu isa sira na tinoni ikikeredi inara. Beto kode mina vakarovo lao vaniria tu kaki goto tinoni sa na ona inuma, ira na tinoni mai boka vania na iana totonai mai lolokete,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Poni sa parangaria i Jisu sira, <<Qu oqoro tu vakaberiamiu agou sa na Kukuti Tabuna isa pira sau? <Na patu isa qai kilu palea ira na tinoni vavaturu ruma, sa isa tugu sa na kuta patu viviso. Na Bangara sa roiti veinia sapi, ko sa vaivagabara jola pa oda dodogoro!> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","<<Ko na binangara tana Tamasa sa mina tateku varijo pale tamugou, ko mina tavalao mule tadira na tinoni karovodi mai boka roiti vavoturia na vua jongadi. ");
INSERT INTO lga_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Isa na tinoni sake vasosoto sa mina vei na tinoni sa vukele pa patu ko mina talolomoto. Goto na tinoni sa takoa na patu isa sa mina avuru bilu,)>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Totonai qai nongoria ira na kuta iama beto na Parese sa na vavakato vavapada ti Jisu, sa qai gigilai sa isa sa korapa gu pojai na veveidi ira qarigu. ");
INSERT INTO lga_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ko qai kole popodeke ko bai aru tamania qarigu, ba qai matagutuniria na minete tinoni, ura ira doru tinoni sa qai vasosotoa kai tinoni kokorotai si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ego i Jisu sa vavakato vaniria mule kaki vavakato vavapada sira. Pira sauniria, ");
INSERT INTO lga_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Na binangara pa noka sa sa vei pira. Koleona sa kai bangara sa vatanania na vavolo vaialava tana tuna marene. ");
INSERT INTO lga_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Beto sa sa garunuria sira na ona nabulu ko mai lao kuku vakamuria sira na tinoni qai tasoru ko mai somanania na vavolo sau, ba qai daidia kamu sira na tinoni tasorudi. ");
INSERT INTO lga_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Poni sa kai garunuria mule sira kaki goto ona nabulu ko pira muna paranga veinira sira qai tasoru sauniria, <Vainongoro ko! Sa tei naqiti beto tu sa na vavolo taqu kopira, qai tei takubolo tu sa na bulumakau lalavatadi beto na tuni bulumakau nyonyobokodi ko qai tei talilida vatana tu, beto doru kai sa qai tei tavatana tu. Mei, lame somanania na inevanga vaialava, munaguniria,> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ba qaike pavu vagalania ira qai tasoru sa na paranga api. Pori vei qarikeuniria tugu sira na nabulu goto qai kole gu junonia na dia roitina. Kaki qai riudia tu pa dia inuma, kaki qai riu tu nyaqodia poata, ");
INSERT INTO lga_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","goto ira doru sa qai lao tu ko qai aru tamanaria sira na nabulu tagarunudi pira ko qai komiti vivikereria beto qai vamateria. ");
INSERT INTO lga_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Poni sa tagigiri vivikereniria na bangara sira, ko sa garunuria sira na ona tinoni vaipera ko qai lao vai vamate betoria sira qai vamateria na ona nabulu, beto qai vurungu palea sa na dia gugusu. ");
INSERT INTO lga_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Beto sa sa kukuria sira kaki ona nabulu mule ko pira sauniria, <Na qua vavolo vaialava sa sa tei tana tu, ba ira na tinoni qa soruria sa nake garodi tugu ko bai lame. ");
INSERT INTO lga_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ko mu lao pa soana lalavata, ko mu soruria sira doru tinoni muna batiria pa soana, ko mai kamu somanania na vavolo,> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ko qai riu sira na nabulu ko qai kuku vakamu betoria sira na tinoni ira vei qai batiria, na tinoni jongadi beto ira nake tinoni jongadi. Ko qai pugelia ira na tinoni sa na ruma ketakoi sa taroiti na vavolo vaialava. ");
INSERT INTO lga_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ego ko tonai sa tome lao sa na bangara, ko mi dogororia sira na tinoni tasorudi sau, poni sa batia sa kai tinoni sake vasaeria na poko vaialava. ");
INSERT INTO lga_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ko sa nanasia na bangara sisa, <Baere, ai sa vei beto qu boka tome lame lani sao, ura ao sa quke vasaeria na poko vaialava?> saunia. Ba sake vagala sa na tinoni isa. ");
INSERT INTO lga_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Poni sa parangaria na bangara sira na nabulu, <Mu lao ko mu piuria na limana na nenena, ko mu gona votu lao palea pa peguru rorodomo kukunina sa na tinoni api. Ketakoi mai lukana uui beto mina ngingisi tu na livodi sira na tinoni,> sau. ");
INSERT INTO lga_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ura kubo sira qai tasoru, ba ira ka vivisa gu sa qai tavile,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ego qai vaikamu sira na Parese ko qai vaivavavakato ko mai vagonai pa kaki dia nanasa i Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Qai garunu laonia ira tana sa kaki dia sepele beto ko kaki ira na tinoni qai somana sosoria i Herodi. Ko pira qarigunia, <<Tinoni vaivagigalai, qe gigilaimei agei sa qu sotomua gu sao. Qu vaivagigalainia ao pa sosoto sa na soana tana Tamasa, beto ko sake vatakulanga podekigo ao sa na sa marigu ira na tinoni, ura quke doro laoa ao sa ai qai poreveveidi vei ira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ko mu pojanigei moko na mua roroqu. Ai vei, na tavamalumuna tugu pana Vavanau sa tana tabara laonia na oda takisi tana bangara i Siza, ba dai?>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ba sa tei batia tu i Jisu sa na dia roroqu ikikerena qai vatanania ira. Ko pira sauniria sira, <<Na tinoni jola vavabatamiu na sesekemiu sagou! Ai sa vei ko qu korapa nyogua podeke vagonasiu ara? ");
INSERT INTO lga_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mu vabatinisiu moko sa na poata siliva isa qu tatabarani takisi!>> sauniria. Ko tonai qai pogoso laonia tana sa kai poata siliva, ");
INSERT INTO lga_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","poni sa nanasaria, <<I sei na isumatana beto na isongona sa sa kole pa poata siliva ina?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Poni sa qai paranga sira, <<I bangara Siza,>> qarigu. Poni sa pira sauniria i Jisu sira, <<Ego mu valao vania i Siza sa ira tai Siza, beto mu valao vania na Tamasa sa ira tana Tamasa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Totonai qai nongoria sa na oe tana sa qai gabara sira ko qai loa pale ko riudia. ");
INSERT INTO lga_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ego pana rane tugu isa sa qai kamu tai Jisu sira na Sadusisi, ira qaike vasosotoa na veveina tinoni mina boka turu mule pa mate, ko pira qarigunia sisa, ");
INSERT INTO lga_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","<<Tinoni vaivagigalai, na Vavanau ti Mosese sa pira sau, <Bi kai iviva marene sa bi kepore tuna beto ko bi mate, sa kode na tasina marene mina teku vakarovia sa na naboko, ko ira na koburu mai vaporeria ira karu sa mina tagigalaniria na tuna tugu na marenena momoe sa mate,> sau. ");
INSERT INTO lga_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ego ko koledia sa ira ka vitu tamatasi marene. Isa pa moa sosoto ira sa sa vaialava ko sa oqoro pore na tuna beto sa mate sisa, ko sa loai sa na naboko ko sa alavia mule na tasina marene isa sa tuti tana tugana moa. ");
INSERT INTO lga_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ba isa na marene vinarua api ba sa vei tugu na tugana, sa oqoro pore na tuna beto sa mate. Na marene vinaue ba kai muqisi podeke tugu, ko qai beto pudala tugu sira ka vitu tamatasi. ");
INSERT INTO lga_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Beto sa liligu tu beto sa mate sa na rereko. ");
INSERT INTO lga_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ego, ko na rane mai turu mule pa mate sira na tinoni, sa i sei ira ka vitu tamatasi pira na maqotana sa na rereko isa? Ura ira ka vitu doru sa qai alavia sisa!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ba sa oeria i Jisu sira, pira sauniria, <<Dai, qu sela sagou! Ura quke vakaberia agou sa na ginuadi na Kukuti Tabuna babi na neqi tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ura tonai mai turu mule pa mate sira na tinoni, sa kode mai suvere vei gu ira na mateana pa noka sira ko maike vaialava. ");
INSERT INTO lga_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Goto na veveina na turu mule pa mate sa ai vei qu oqoro tu tiro vakaberia tu agou sa isa sa pojanigou na Tamasa? Pira sau sisa, ");
INSERT INTO lga_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","<Ara sa na Tamasa tai Ebarahami, na Tamasa tai Aisake, beto na Tamasa tai Jekopi,> sau sisa. Ko isa sa nake Tamasa tadira na tinoni matedi, goto tadira tu na tinoni toadi,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Totonai qai nongoria ira na minete tinoni sa api, sa qai gabara betonia ira sa nona vaivagigalai. ");
INSERT INTO lga_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ego totonai qai nongoria sa vapapakaria i Jisu sira na Sadusisi, poni sa qai vaikamu sira na Parese. ");
INSERT INTO lga_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ko kame ira na Parese isa sa vavaivagigalainia na Vavanau sa sa nyogua vagonai si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ko sa paranga <<Tinoni vaivagigalai, ai sa na garunu poreveveina jola pa Vavanau?>> sau. ");
INSERT INTO lga_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Poni sa oea i Jisu, pira saunia, <<Mu roroqua na Bangara na mua Tamasa pa doruna bulomu, pa doruna gagalamu, beto pa doruna na roqumu. ");
INSERT INTO lga_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Isa sa na garunu sa poreveveina jola beto sa momoe. ");
INSERT INTO lga_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na vinarua garunu sapi gu: Mu roroqua na tavitimu kai muqisi podeke vei qu roroqu mule veinigo mekamu. ");
INSERT INTO lga_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tadira karu garunu aipira qai titi sa na doruna na Vavanau beto na vaivagigalai tadira na tinoni kokorotai,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ego tonai qai korapa tugu vaikamu ketakoi sira na Parese, sa sa nanasaria i Jisu sira, ");
INSERT INTO lga_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Na sa qu roroqunia agou sa na Karisito? Na tuti lamena ti sei sisa?>> sau. Poni qai oe lao sira, Na tutina i Devita, qarigu. ");
INSERT INTO lga_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Poni sa parangaria i Jisu sira, <<Ba ai sa vei ko sa pojania tu na Gagala Tabuna si Devita ko sa gigalania tu na Bangara i Devita sisa? Ura i Devita sa pira tu sa paranga vei, ");
INSERT INTO lga_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<Pira sau sa na Bangara Tamasa tana qua Bangara na Karisito: Mu toqo pa kale matuaqu, tinganai tu mana vakilasaria ira na mua kana,> sau. ");
INSERT INTO lga_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ego, ko vei bi gigalania nona Bangara biunia i Devita sisa, sa ai sa vei beto mina na tuti lamena tu ti Devita sa na Karisito?>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kepore kame ira bi boka oea si Jisu. Ko podalai pa rane isa sa qaike tuma nananasa ligua ira sisa. ");
INSERT INTO lga_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ego beto sa paranga laoria i Jisu sira na minete tinoni beto ira na ona sepele, pira sauniria, ");
INSERT INTO lga_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Ira qai vaivagigalainia na Vavanau beto ira na Parese sa qai toqoa na totoqona ti Mosese. ");
INSERT INTO lga_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ko muna kopunia beto mu tutia gu agou sisa vei qai vaivagigalainia ira tamugou, ba muke tutiria sira na roiti qai roroitiniria ira. Ura ira sa qaike tutiria sira na sakasava qai vaivagigalainiria. ");
INSERT INTO lga_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pana dia ruvata vavukele paranga sa qai vamakeleniria na pogoso mamata sira na tinoni, ba kai kakarusudi gu bi uli pa pogoso mamata ko bi iapeki vakopele vaniria na tinoni ba qaike nyorogua vei tugu. ");
INSERT INTO lga_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Doru dia roiti sa qai roitiniria ira ko vei ko mai dogororia gu ira na tinoni qarigu. Qai vatogasaria pa readi beto pa limadi sa na bokese lalavata sa pugelia na paranga pa Kukuti Tabuna, beto qai piti vakakakasaria sira na uqudi na dia poko. ");
INSERT INTO lga_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Qai nyonyorogua tavatoqo pa ia poreveveidi pa vavolo beto pa totoqo poreveveidi pa leo ruma vavaikamuna. ");
INSERT INTO lga_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Qai nyoguania ko ira na tinoni mai gosoro qeqeraniria pa ia mamaketina beto mai gigigalaniria na <Rabi> mariguniria na tinoni qarigu. ");
INSERT INTO lga_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ba agou na qua tinoni sa munake tagigala na <Rabi> ura na tamatasi gu sagou, beto ko kai memekana gu sa na miu Tinoni vaivagigalai. ");
INSERT INTO lga_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Muke gigalania na <tamamiu> sa kai tinoni pa peso, ura kai memekana gu sa na Tamamiu, isa na suverena pa noka. ");
INSERT INTO lga_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Muke gigalania na tinoni mamata sa kai tinoni, ura na Karisito gu sa na miu tinoni mamata. ");
INSERT INTO lga_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Isa na tinoni sa poreveveina jola agou sa mi nabulunigou sagou. ");
INSERT INTO lga_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Isa sa valavata mulenia mekana sa kode mina tavaikete, beto isa sa vaikete mulenia mekana sa kode mina tavalavata. ");
INSERT INTO lga_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mu takulangagamiu tugu sagou qu vaivagigalainia na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Ura qu patei suqutia agou pa moedi na tinoni sa na atakamanana na binangara pa noka. Ko mekamiu quke boka tome laoa tugu beto ko qu suquturia tugu sira qai korapa popodeke ko mai tome qarigu. ");
INSERT INTO lga_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(Mu takulangagamiu tugu sagou qu vaivagigalainia na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Qu iko toaria na ruma beto na sakasava tadira na nanaboko, beto qu jola vavara vakakasamiu pa moedi na tinoni! Inara qu vei ko mina lavata jola sa na vinakilasa muna gosoria.) ");
INSERT INTO lga_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mu takulangagamiu tugu sagou qu vaivagigalainia na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Qu karovoria na kolo ka kolo beto qu reregeria na ia ka ia, ko qu vagabalia kai tinoni ko sa tutia na Vavanau, beto totonai sa gabala poni sa sa ikere jolanigou mule agou ko sa padana na gana gu pa heli sa na tinoni isa. ");
INSERT INTO lga_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mu takulangagamiu tugu sagou na tinoni vaitoni leleqamiu! Ura pira qu vavanau vei sagou, <Bi maulu gagale pa nisongona na zelepade madina sa kai tinoni, sa vei minake roiti votunia sa nona maulu ba sake vei kamea. Ba vei tu mina maulu lao sisa pa qolo qai tavakole pa zelepade madina, poni sa minake beia goto mina roiti votunia tugu isa sa na maulu sa maulunia,> qugu sagou. ");
INSERT INTO lga_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Qu duduvili na leqa sagou! Ai ira karu sa na poreveveina jola, na qolo ba na zelepade madina? Na zelepade madina gu sa sa poreveveina, ura ketakoi gu qai boka tavamadi sira na qolo qai tavaroiti pa vatarasaena na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Beto sa pira mule qu vavanau vei, <Bi maulu pa isongona na idi vavakukuvuna sa kai tinoni, sa vei minake roiti votunia nona maulu ba sake vei kamea. Ba vei tu mina maulu lao sisa pa vaivana sa makele pa idi vavakukuvuna, poni sa minake beia goto mina roiti votunia tugu sisa na maulu sa maulunia isa,> qugu sagou. ");
INSERT INTO lga_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sa iqogana tugu sa na leqa sa vaigou agou! Isa tu na idi patu vavakukuvuna sa vamadia na vaivana sa sa poreveveina jolania sa na vaivana sa tavamakele pa narena isa. ");
INSERT INTO lga_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sa vei inara sa, na tinoni sa maulu lao pa ia vavakukuvuna sa sa maulu lao tugu sa tadira doru vaivana qai tavakole pa narena. ");
INSERT INTO lga_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Beto ko na tinoni sa maulu lao pa zelepade madina sa sa maulu tavitinia tugu sa na Tamasa sa suvere pa zelepade madina. ");
INSERT INTO lga_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Beto ko na tinoni sa maulu sae pa noka, sa sa maulu lao tugu sa pa totoqona bangara, beto ko sa maulu tavitinia tugu sa na Tamasa sa toqo pa totoqona isa. ");
INSERT INTO lga_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mu takulangagamiu tugu sagou qu vaivagigalainia na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Ura qu valao vania na Tamasa sa kame pa manoga pa miu umuma qai vavalilingia na tetekuna vevei na miniti, na dili beto na kiumini. Ba qu doro paleniria agou sira na uana poreveveidi tana Vavanau, na roiti vatuvisi lao tana na tinoni, na vairoroqu vaitokai, beto na tuti vatalea na Tamasa. Pira sira na uana sa pada ko muna kopuniria na roiti tutiniria beto ko vei tugu ira kaki tuti inara. ");
INSERT INTO lga_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Na tinoni vaitoni leleqamiu sagou! Qu popodeke vivitigi ko qu teku pale sa na lango ikete sa lao pa gamiu kapa pie bukuna, ba beto qu ponyolo toaia sa na kameli tu naregogoto! ");
INSERT INTO lga_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mu takulangagamiu tugu sagou qu vaivagigalainia na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Ura qu valiosoria na pegurudi na miu kapa beto na peleita, goto pa leodi sa sa pugeleria na sakasava ikikeredi qu tekuria agou pa miu soana ngangangulu beto na muino. ");
INSERT INTO lga_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Na Parese leleqamu sao! Mu valioso momoea mai tu na leona na mua kapa, beto sa kode mina lioso mutugu sa na peguruna. ");
INSERT INTO lga_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mu takulangagamiu tugu sagou qu vaivagigalainia na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Qu kale na bevi vavaigolomoni kokobu tinoni matedi, sa tapedi vakeka ko sa babata jonga na peguruna, ba pa leona sa sa pugelia na pupuda beto na nyabo tomate. ");
INSERT INTO lga_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ko inara qu vei puputa sagou. Pa pegurumiu sa qu doro vei na tinoni tuvisimiu pa dodogoro tana tinoni, goto pa bulomiu sa sa pugelia na nyonyorava beto doru roiti ikikeredi. ");
INSERT INTO lga_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mu takulangagamiu tugu sagou qu vaivagigalainia na Vavanau beto na Parese! Na tinoni jola nyonyoravamiu! Qu roiti vataleniria beto qu vasari vababata jongaria tugu vei sira na poudi ira na tinoni kokorotai beto na memerudi ira tinoni tuvisidi pa moa. ");
INSERT INTO lga_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Qu paranga sagou, <Vei be korapa suveremei na totoso qai suvere ira na tamamei pa moa sagei, sa beke somana vamateria agei sira na tinoni kokorotai,> qugu. ");
INSERT INTO lga_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ko inara sa vei sa qu ule votunia gu pa miu uana sa agou sa na tinoni veveimiu gu ira qai vamateria na tinoni kokorotai pa moa! ");
INSERT INTO lga_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ko mu laomiu gu ko mu roiti vaokotonia tu sisa qai tei podalainia tu ira na tamamiu pa moa. ");
INSERT INTO lga_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Boko dole! Boko tuni dole ikikeremiu! Ai vei, muna boka ukunia agou sa na vinakilasa pa heli? ");
INSERT INTO lga_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ko sa vei sa mu vaingorongo! Ara qa korapa garunu lameniria ara tamugou sira na tinoni kokorotai, na tinoni gigigalai, beto ira na tinoni vaivagigalai. Kaki ira sa kode muna vamateria tugu agou, kaki mule sa kode muna vamateria pa korosi, beto kaki sa kode muna mamajaria pa ruma vavaikamuna beto ko muna adu vatatagararia pa gugugusu. ");
INSERT INTO lga_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Qu vamateria sira na tinoni tuvisidi ko na tinajutu sa muna gosoria agou. Ko ira muna gosoroni tinajutu agou sa sa podalai ti Ebolo na tinoni tuvisina ko sa lame kamu ti Zakarae na tuna marene i Barakia isa qu vai vamatea agou pa vaikorapaina na zelepade madina beto na ia vavakukuvuna. ");
INSERT INTO lga_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ma poja sosotonigou ara sagou: na vinakilasa tadira dodoru qai vai tinoni aipira, sa mai gosoria tugu ira na sasae tinoni kopira,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","<<Kei, Jerusalema, Jerusalema! Ao sa qu vai vamateria na tinoni kokorotai, beto ko qu buti tariniria na patu sira na tinoni pogoso nongoro sa garunu laoniria na Tamasa tamu! Kubo totoso sa qa nyogua teku vaikamuniria sira na mua tinoni, ba veinigou na kokorako sa vaonguria na boko tuna pa kauru babanana ko ba kopunigou qau, ba quke vamalumu podekesiu tugu! ");
INSERT INTO lga_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vainongoro! Na miu ruma sa taloa pale, sa kokoba, beto mina ivulu gogoe sa na gugusu. ");
INSERT INTO lga_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ura ma poja vatalenigou ara sagou: podalai tugu kopira sa munake bati ligusiu ara sagou, tinganai tu mina kamua sa na totoso totonai kode pira muna paranga vei sagou, <Na tamanana sisa sa lame pa isongona na Bangara,> munagu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ego tonai sa taloa pa kakabarena zelepade si Jisu, sa qai lao tana sira na ona sepele, ko qai vadogoronia isa sa na roitina na ruma zelepade. ");
INSERT INTO lga_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Poni sa sa parangaria i Jisu sira, <<Qai vagabaragou agou sa pira. Ba ma poja sosotonigou ara sagou: ira doru patu qu batiria pira sa maike kole vavaitopare lalaodia, ba kode mai taqovara beto,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ego totonai sa korapa toqona pa batu kubo pa Olive si Jisu, sa qai mavo lao mekadi tana sira na ona sepele, ko pira qarigu, <<Mu ule vanigei. Ai totoso mai podo sira doru sakasava quguniria ao inara? Beto na sa sa mina tabata vei na vinagigilana na mua bola lame beto na vinabetona na totoso?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Poni sa oeria i Jisu sira, pira sauniria, <<Mu kopu vatale gu ko maike toni vapirugou. ");
INSERT INTO lga_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ura kubo sira na tinoni kode mai lame pa isongoqu ara, ko pira marigu, <Ara sa na Karisito!> marigu, ko mai toni vapiruria sira na soku tinoni. ");
INSERT INTO lga_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kode muna nongoroniria sira na vaipera beto na vavakatodi na vaipera, ba munake matagutu. Kode mai pidoko lame tugu sa na sakasava inara, ba nake isa sa na vinabebetona. ");
INSERT INTO lga_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kai puku tinoni mina turu talea kai goto puku tinoni, beto kai binangara mina turu talea kai goto binangara. Beto na songe beto na nunu mai raja doru eqa. ");
INSERT INTO lga_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Doru sakasa pira sa vei na popodalaina na vivitigi teku koburu. ");
INSERT INTO lga_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Na totoso isa sa kode muna taaru tamana sagou ko mai toni laonigou tadira na tinoni ko muna tavakilasa beto mai vamategou. Pana ginuana qu tutisiu ara sa kode maike tavaraguanigou ira na tinoni karovodi sagou. ");
INSERT INTO lga_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kubo tinoni sa na dia rarange mina vukele ko mai taloa rijodia taqu, beto ko mai vaigabala vikere beto maike vaitavaragua sira. ");
INSERT INTO lga_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Beto kubo tinoni kokorotai sesekedi sa mai votu lame ko kode mai toni vapiruria sira soku tinoni. ");
INSERT INTO lga_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kode inara mina koi vei gigiri vei sa na reregena na toa ikikerena ko na toa vairoqu tadira na tinoni sa mina lomoso betona. ");
INSERT INTO lga_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ba isa gu sa vangaju kamua na bebetona sa mina taalo. ");
INSERT INTO lga_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ko na nongoro jongana api, isa na veveina na binangara tana Tamasa, sa mina tatarae pa kasia gusu doruna ko ira doru tinoni karovodi mai nongoria. Pa liguna tu isa sa mina lame sa na vinabebetona na totoso,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","<<Kode muna batia sa na Sakasava Ikerena Jola isa vei sa tei pojai tu i Daniela na tinoni kokorotai. Ko na Sakasava Ikerena Jola isa sa mina turu pa ia madina pa ruma zelepade (Agou qu tiroa na paranga api sa mu vakoinonoa na ginuana). ");
INSERT INTO lga_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Totonai mina vei isa sa ira qai suvere pa Jiudia sa mai uku sagereria tu sira na kubo ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Isa sa korapa suvere pa narena nona ruma sa mike mule gore qaqiriria na ona sakasava pa leo ruma. ");
INSERT INTO lga_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Isa na tinoni sa korapa pa ona inuma sa mike mule tekua na ona poko. ");
INSERT INTO lga_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Na totoso takulanga tadira na rereko qai bogata beto ko tadira qari isongo melalu sira na rane ira! ");
INSERT INTO lga_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mu vavara tepai na Tamasa, ko nake pa totoso lomoso babi na rane Minere sa mu uku agou. ");
INSERT INTO lga_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ura na tapata pa totoso isa sa mina lavata jolaniria na tapata qai jola totonai vei sa podalai na kasia gusu ko sa lame kamu kopira. Ko pa liguna sa kepore sa kai tapata mina ikerena jola vei api. ");
INSERT INTO lga_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ba sa tei vapapakia tu na Tamasa sa na anyedi na rane totonai. Goto bike vei sa kepore kai tinoni bi boka toa. Ba koko vei gu sa roroquria na ona tinoni taviledi sa na Tamasa sa soni vei sa mina vapapakia sa na anyedi na rane pa totoso tapata isa. ");
INSERT INTO lga_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Vei pira bi paranga veinigo kai tinoni totonai, <Do, poni sa na Karisito!> babi, <Inana sisa!> biu, ba kita vasotoa. ");
INSERT INTO lga_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ura kode mai vovotu lame sira na karisito sesekedi beto na tinoni kokorotai sesekedi ko mai roitiniria na roiti vaivagabara poreveveidi beto mai vavoturia na dia vinagigila, ko vei mai boka sa mai toni vapiruria tugu vei sira na tinoni taviledi tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mu vainongoro! Sa oqoro kamua na totoso isa sa qa korapa pojanigou ara sapi. ");
INSERT INTO lga_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ko vei pira bai ule veini vanigou ira na tinoni, <Poni! Korapa suvereona gu pa qega sisa!> barigu, sa kita votu lao. Babi <Ina! Korapa gu suvere pa leo ruma sisa!> barigu, sa kita vasotoria. ");
INSERT INTO lga_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ura na bola lame tana Tuna na Tinoni sa kode mina vei gu na kapi sa malara podalai pa kale sagere tapo ko sa kamu pa kale suvu tapo. ");
INSERT INTO lga_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ketakoi sa kole na kokobu tinoni matena sa kode mai vaikamu ketakoi sa na nyae,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<Mina jola sa na tapata pa rane ira, sa kode mina rodomo sa na tapo, na popu minake kabere, na seru pa noka mai vukele, beto doru sakasava pa noka mai tajou vakanoko beto. ");
INSERT INTO lga_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Beto mina tabata votu lame pa vavagalo eqa sa na vinagigilana na Tuna na Tinoni. Beto sa mai lukana tadungana beto sira doru tinoni pa kasia gusu totonai mai batia na lamena na Tuna na Tinoni pa lei pa noka, mina lame tavitia na neqi lavatana beto na kabere lavatana. ");
INSERT INTO lga_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Mina taivu vavaqoro viva sa na kuvili, beto mina garunu laoniria isa sira na ona mateana pa doru eqa pa kasia ababana, ko mai toni vaikamuniria na ona tinoni taviledi pa doru uququdi na kasia gusu. ");
INSERT INTO lga_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mu doria na gou piqi ko mu tekua kai vinakabere. Totonai mina ijoko ko mina podalai equru ko mina bu vatale, poni sa qu gigilai sa tei takelai tu sa na gou isa ko sa tata gu sa nona totoso vua. ");
INSERT INTO lga_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kode inara tugu muna vei sagou na totoso isa. Tonai muna batiria agou sira doru sakasava pira, sa kode muna gigilaimiu gu sa sa tata sa na totoso, ko sa tata vivitigi gu sa na Tuna na Tinoni. ");
INSERT INTO lga_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ara ma poja sosotonigou sa agou: doru sakasava pira sa kode mai gore votu totonai mai oqoro mate beto na sasae tinoni kopira. ");
INSERT INTO lga_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Na oka beto na peso sa mai maragutu, ba ira na qua paranga sa maike isongo maragutu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","<<Goto na veveina na rane beto na totoso isa sa sa kepore kai tinoni bi gigilai. Ira na mateana pa noka babi na Tuna ba sake gigilai, goto mekana gu na Tamana sa gigilai. ");
INSERT INTO lga_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na bola lame tana Tuna na Tinoni sa kode mina kai muqisi podeke vei tugu pa totoso tai Noa. ");
INSERT INTO lga_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ira na rane totonai sa oqoro dururu na abana, sa ira na tinoni sa qai kole gaganigadia, qai kole bukugadia, beto ira na marene na rereko sa qai vavaialavadia, tinganai ko sa kamu sa na ranena sa tome pa leo aka i Noa. ");
INSERT INTO lga_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ba qaike isongo vagigila podekia tugu ira sa na sa sa korapa taroiti, tinganai ko sa gore na nyoro ko sa pogoso variu beto paleria. Kode inara tugu mina lame vasiboro vei sa na lame tana Tuna na Tinoni. ");
INSERT INTO lga_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na totoso isa sa karu tinoni mai korapa roiti pa inuma, sa kame sa mina tateku variu goto kame sa mina taloa pale. ");
INSERT INTO lga_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Karu rereko sa mai korapa kija vaavururia na dia kiko vuiti, sa kame sa mina tateku variu goto kame sa mina taloa pale. ");
INSERT INTO lga_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ko sa vei sa mu suvere gegele, ura quke gigilai agou sa na rane mina lame na miu Bangara. ");
INSERT INTO lga_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Qu gigila vataleamiu agou sa vei bi tei gigila momoeona tu na tinoni poreona ruma sa ai totoso mina kamu na tinoni ikiko, sa kode mina suvere gegele ko minake boka pururu tomeia na tinoni ikikona sa nona ruma. ");
INSERT INTO lga_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ko sa vei sa agou mu kole suvere vanaqiti doru totoso, ura na Tuna na Tinoni sa mina lame na totoso quke rove veinia mina lame,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","<<Ego kopira ma vavakato vanigou na veveina na nabulu tarangena. Na nabulu tarangena sa isa tugu kame sa vaivivai na bangara ko sa kopu vataleniria ko sa ianiria na gagani sira pa tatamana tana bangara pa totoso sa nguti vakoleniria na bangara. ");
INSERT INTO lga_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Mina tamana sa na nabulu isa totonai mina mule na ona bangara sa mina batia sa korapa tugu roitinia isa sa na roiti sa taiania ko mina roitinia. ");
INSERT INTO lga_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma poja sosotonigou ara sagou: kode mina vaiviva lavatia sosoto na ona bangara sisa, ko mina kopu vania doru ona isisongo. ");
INSERT INTO lga_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ba vei bike nabulu jongana sisa ko bi roroqua isa sa kode minake oqani mule lame sa nona bangara biu, ");
INSERT INTO lga_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ko bi podalai mamajaria sira na nabulu tatavitina beto bi somana teteku beto bubuku tavitiria sira na tinoni bubukudi. ");
INSERT INTO lga_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ego beto mina mule kamu sa na bangara tana nabulu api na rane beto na totoso mina korapa suvere muma ko minake gigilai isa. ");
INSERT INTO lga_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na bangara mina lomoto kokobu pale sisa, beto mina vakole tavitiniria ira na tinoni sesekedi. Ketakoi sa mai lukana uui beto mina ngingisi tu na livodi sira na tinoni,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","<<Pana totoso isa sa na binangara pa noka sa kode pira mina vei. Koledia sira ka manogaputa rereko koregadi qai okoto pogosoria na dia juke ko mai lao gosoria sa na tinoni mina vaialava tonai mina lame ko mina tekua na maqotana qarigu. ");
INSERT INTO lga_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ira ka lima sa na duduvilidi goto ira ka lima sa na tavagigaladi. ");
INSERT INTO lga_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ira ka lima duduvilidi qaike pogoso vatananiria na oela sa na dia juke. ");
INSERT INTO lga_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Goto ira na tavagigaladi sa qai pogosoria na dia juke beto qai okoto toto pogoso vatananiria pa dia tototodi sa na oela. ");
INSERT INTO lga_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ego sa vavabongi na kamuna sa na tinoni vaialava, ko qai doki ko qai puta beto sira doru. ");
INSERT INTO lga_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ko sa tei vaikorapai bongi tu neqa, sa sa tanongoro sa na kuku, <Vainongoro! Api sa na tinoni vaialava! Mu votu lame gosoria!> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Poni qai okoto sasuru dorava beto sira ka manogaputa rereko koregadi ko qai okoto piju vatoaria sa na dia juke. ");
INSERT INTO lga_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Beto sa ira ka lima rereko duduvilidi pira qai paranga laoria sira ka lima tavagigaladi, pira qarigu, <Muna vanigei tu kaki miu oela, ura iapeki gu mina pidili gagapu na mei juke sagei,> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ba qai oe lao sira na tavagigaladi, <Dai, ura nake padada gita doru sira na mei oela pira. Goto mu mule lao vai beimiu tadira qai vavai oela,> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ego ko pa ligudi tu qai korapa riu nyaqo oela ira ka lima rereko duduvilidi pira, sa sa kamu gu sa na tinoni vaialava. Ko ira ka lima rereko tavagigaladi qai tei vatana vakoledia tu sa qai tome lao tavitia isa pa vavolo vaialava. Ko qai tome beto ira sa sa tapatei gu sa na atakamana. ");
INSERT INTO lga_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ko liligu tu beto sa qai kamu sira ka lima rereko koregadi duduvilidi. Ko qai kamu kole kukuku, pira qarigu, <Bangara! Bangara! Mu revanga vanigei!> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ba sa oe laoria na tinoni vaialava sira, <Ma poja sosotonigou ara sagou: qake isongo gigilagou ara sagou,> sauniria na tinoni vaialava. ");
INSERT INTO lga_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ko sa vei sa mu suvere gegele, ura quke gigilai agou sa na ranena beto na totoso tonai mina lame na Tuna na Tinoni,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","<<Ura pana totoso isa sa na binangara pa noka sa pira mina vei. Koleona sa kai tinoni sa taloa riu pa kai ona rererege. Tonai sa oqoro riu sa sa kukuria sira na ona nabulu ko sa okoto ia vaniria na ona sakasava ko mai kopu vania sauniria. ");
INSERT INTO lga_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ko tana kame sa sa vania ka lima baiki poata, tana kame sa vania karu baiki poata, beto tana kame mule sa vania kai baiki poata. Ira doru sa okoto vaniria na padana na dia boboka beto sa sa taloa riu pa ona rererege. ");
INSERT INTO lga_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ego na nabulu isa sa tekua ka lima baiki poata sa isa tugu sa tekua sa sa riu gu varoitia sa na poata, ko na vuana sa tekua sa ka lima baiki poata mutugu. ");
INSERT INTO lga_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Isa na tinoni sa tekua karu baiki poata ba sa vei tugu, ko na vuana sa tekua sa karu baiki poata mutugu. ");
INSERT INTO lga_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Goto isa na tinoni sa tekua kai baiki poata, sa sa riu gelia na peso ko sa golomo vapaea sa na poata tana ona bangara. ");
INSERT INTO lga_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ego sa sovai tu beto sa gabala mule kamu sa na bangara tadira kue nabulu pira ko mi doria ai qai varoiti veinia ira pira sira na ona poata sau. ");
INSERT INTO lga_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na nabulu sa tekua ka lima baiki poata sa tome lao, ko sa kaqama laonia isa ka lima baiki poata beto ka lima baiki poata mule na vuana. Beto sa paranga sisa, <Bangara, ka lima baiki poata sa qu vanisiu ao. Doro! Qa vavuai ko ka lima baiki poata mule sa qa tamo laonia ara,> sau. ");
INSERT INTO lga_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Poni sa parangia na bangara sisa, <Jongana jola. Na nabulu jongamu beto na tarangemu sao. Qu tarange pa kopuna ka vivisa poata pira sao, ko kopira mana vakopunigo kubo sakasava ara sao. Mei lame ko mu somanania na qeqera tana mua bangara,> saunia. ");
INSERT INTO lga_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Beto sa sa tome lao gu mule sisa na tinoni sa tekuria karu baiki poata, ko pira saunia, <Bangara, karu baiki poata sa qu vanisiu ao. Doro! Qa vavuai ko karu baiki poata mule sa qa tamo laonia ara,> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Poni sa parangia na bangara sisa, <Jongana jola. Na nabulu jongamu beto na tarangemu sao. Qu tarange pa kopuna ka vivisa poata sao, ko kopira mana vakopunigo kubo sakasava ara sao. Mei lame ko mu somanania na qeqera tana mua bangara,> saunia. ");
INSERT INTO lga_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Beto sa tome liligu lao sa na nabulu sa tekua kai baiki poata, ko sa paranga, <Bangara, qa gigilaiqua ara sa kai tinoni tapatamu sao. Ura ao qu boka ababu ketakoi quke umuma, beto qu aqaqono vaikamu ketakoi quke vavuvusia kai kiko. ");
INSERT INTO lga_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ko qa matagutuqua sara, ko qa riu geli golomo vapaea pa peso sa na mua poata. Ko, doro, api sa isa na mua,> saunia. ");
INSERT INTO lga_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Poni sa oea na ona bangara, pira saunia, <Na nabulu ikikeremu beto na ududapelumu sao! Beko qu tei gigilaimua tugu ao sa ara qa ababu ketakoi qake umuma beto qa aqaqono vaikamu ketakoi qake vavuvusia kai kiko. ");
INSERT INTO lga_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ko sa vei sa vei buke nyorogua varoitia ao sisa, sa bu vatomea gu pa banga sa na qua poata. Ko bu vei ao sa totonai ba mule kamu sa ba kamu tekua sa na qua poata taviti vuana. ");
INSERT INTO lga_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ego ko, ka visa nabulu, mu tekua sa na poata tana tinoni api, ko mu valao vania isa na tinoni sa isongia manogaputa baiki poata. ");
INSERT INTO lga_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ura na tinoni sa poreona sa mina taia mutugu ko mina pugele nyonyo na ona. Goto na tinoni sa kepore ona sa mina tateku pale sa isa vei iqona sa isongia isa. ");
INSERT INTO lga_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mu tekua sa na nabulu kepore kai sa bi vapodoa api, ko mu gona votu laonia pa peguru rorodomona. Ketakoi mai lukana uui beto mina ngingisi tu na livodi sira na tinoni,> sauniria,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","<<Tonai mina lame pana neqi tana bangara sa na Tuna na Tinoni sa kode mai tutia ira doru mateana, ko mina toqo pa ona totoqona bangara sisa. ");
INSERT INTO lga_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ko ira doru puku tinoni sa mai vaikamu lao pa moena isa. Ko isa mina vaipikainiria pa karu pikatana kai muqisi podeke vei na sepati sa vile pikata tekuria na sipi tadira na qoti. ");
INSERT INTO lga_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ko mina vakoleniria pa kale matuana sira na tinoni tuvisidi, goto ira na tinoni ikikeredi sa mina vakoleria pa kale merina. ");
INSERT INTO lga_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Beto sa mina parangaria na bangara sira na tinoni pa kale matuana, <Mei, lame agou sa mananigou na Tamaqu! Mu teku isongia na binangara, isa sa vatana vakole vanigou na Tamasa pa popodalaina tu tonai sa taroiti na kasia gusu. ");
INSERT INTO lga_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ura tonai qa burana ara sa qu iasiu, qa kidepe sara sa qu vabukusiu, na tinoni gotoqu sara ba qu vatoga vatalesiu agou pa miu ruma. ");
INSERT INTO lga_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na gagadoqu, ba qu vapopokosiu; qa mo, ba qu kopunisiu agou; tonai qa tapiu, ba qu ovikisiu tugu agou,> minagu. ");
INSERT INTO lga_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Poni mai oea ira na tinoni tuvisidi, pira marigu, <Bangara, pa visa sa qu burana ao ko qe iago agei? Toto sa sa qu kidepe ao sa qe lao vanigo na pie agei? ");
INSERT INTO lga_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Pa visa sa na tinoni gotomu qeunigo, ko qe vatogaigo pa mei ruma agei? Beto pa visa qe batigo na gagadomu ko qe vapopokogo agei? ");
INSERT INTO lga_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Toto sa sa qe batigo qu korapa momoomu ao beto ko pa visa sa na suveremu pa ruma vaipiu ko qe lalao ovikigo agei?> marigu. ");
INSERT INTO lga_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Poni mina oeria na Bangara sira, pira minaguniria, <Ma poja sosotonigou ara sagou: tonai qu roiti laonia agou kai roiti jongana tana kame ira na tasiqu nake poreveveidi aipira, sa qu korapa tugu roiti valame vanisiu ara sisa,> minagu. ");
INSERT INTO lga_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Beto sa mina paranga laoria isa sira pa kale merina, pira minagu, <Mu taloa taqu sagou, agou sa sa tei lelevenigou tu na Tamasa. Mu lao pa iku kole jolana isa sa tavatana vakole vania na bangaradi na tomate beto ko ira doru ona mateana! ");
INSERT INTO lga_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ura tonai qa burana sara, ba quke isongo ia podekesiu tugu ara sagou; tonai qa kidepe, ba quke vabukusiu; ");
INSERT INTO lga_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","tonai na tinoni gotoqu tugu sara, ba quke vatogasiu pa miu ruma ara sagou; na gagadoqu tugu, ba quke vapopokosiu ara sagou; tonai na momooqu tugu beto na tapiuqu tugu pa ruma vaipiu, ba quke galanisiu sara,> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Poni sa mai oea ira sa na Bangara, pira marigu, <Bangara, toto sa sa qe batigo agei qu kole burana, na kidepe, na tinoni gotomu, na gagadomu, qu mo, babi qu tapiu ao, beto qeke pavu galanigo na tokanigo agei?> marigu sira. ");
INSERT INTO lga_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Poni mina oeria na Bangara sira, pira minagu, <Ma poja sosotonigou ara sagou: tonai qu daimiu tokania sa kame ira nake poreveveidi aipira, sa qu daimiu tokanisiu tugu sara,> minaguniria. ");
INSERT INTO lga_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ko ira na tinoni ikeredi aipira sa mai tavalao pa vinakilasa kole jolana, goto ira na tinoni tuvisidi sa mai lao pa toa jola,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ego totonai sa beto vaivagigalainiria i Jisu sira doru sakasava pira, sa pira sauniria ira nona sepele, ");
INSERT INTO lga_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Qu tei gigilaimiu tu agou sa karu rane gu sa kole beto mina kamua sa na rane vavolo Alokata, ko totonai sa kode mina tavalao pa limadi ira na tinoni sa na Tuna na Tinoni ko mina tavamate pa korosi,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ko na totoso tugu isa sa ira na kuta iama beto ira na iviva mamata tadira na tinoni sa qai vaikamu pa ruma ti Kaiapasi isa na kuta iama lavata. ");
INSERT INTO lga_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ko qai roitiniria kaki roroqu vei beto mai aru tamana golomia ko mai vamatea si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba pira qai kole vaiparanga vei sira, <<Dai, taneke roitinia na roiti isa pa totoso vavolo Alokata, ura kita ta kole vaiperaniria ira na tinoni,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ego sa lao suvereona pa Betani si Jisu, pa ruma ti Saimone isa sa rajai na popoqu perangana. ");
INSERT INTO lga_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ko tonai sa korapa teteku i Jisu sa sa tome lao sa kai rereko sa pogosia kai tototona sa taroiti pa kai patu babata jongana. Sa pugelia na lumu umumanga jonga beto na pore vaina sa na tototona isa. Ko sa lobitia, beto sa vuvania pa batuna i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Poni ira na sepele sa totonai qai batia sa roiti vei inara isa, sa qai tagigiri sira ko qai paranga, <<Ai sa vei ko sa korapa aru vivikeria na lumu sina! ");
INSERT INTO lga_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Isa bi boka tatekuni poata lavatana sina, ko bi ianiria ira na tinoni vaivasevidi!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ba sa tei gigilaiona tu i Jisu sa na paranga qai pojai ira, ko pira sauniria, <<Ai sa vei ko qu korapa tu poja vivikeria agou sa na rereko api? Kai roiti jongana sa sa roiti lamenia isa taqu. ");
INSERT INTO lga_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ura qu suvere tavitiriamiu gu agou doru totoso sira na tinoni vaivasevidi, goto ara sa maneke suvere tavitigou lalaoqua. ");
INSERT INTO lga_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tonai sa vuvania na lumu na rereko api sa na tiniqu ara, sa sa vatanania isa ko mina tagolomo sa na tiniqu ara. ");
INSERT INTO lga_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma poja sosotonigou ara sagou: doru eqa pa kasia gusu mina tatarae na nongoro jongana api, sa mina tavavavakato tugu sa na roiti sa roitinia na rereko api taqu, ko minake tamuma sa na rereko isa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pa liguna isa sa kame ira ka manogarua sepele, na isongona i Jiudasi Isikarioti, sa sa lao tadira na kuta iama, ");
INSERT INTO lga_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ko pira sauniria, <<Na sa sa muna vanisiu ara agou, ko mana boka tokanigou ko muna boka aru tamania agou si Jisu?>> sauniria. Poni qai anye tekuria sa ka uengavuluputa poata siliva, ko qai vania. ");
INSERT INTO lga_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ko sa podalai tugu na totoso isa sa sa podalai nyanyaqoa i Jiudasi sa kai lolomo jongana vei beto mina tokaniria ko mai boka aru tamania ira si Jisu sau. ");
INSERT INTO lga_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tonai sa kamua sa na rane momoe tonai mina taroiti sa na vavolona na Bereti Nake Kovuruna, sa qai lao sira na ona sepele ko qai nanasia si Jisu, <<Pai sa qu nyoguania ao ketakoi mene vatana vanigo agei sa na vavolo Alokata?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Poni pira sauniria, <<Mu lao tana tinoni api pa Jerusalema, ko pira munagunia, <Pira sau sa na tinoni vaivagigalai, sa kamua sa na qua totoso. Ko kopira sa ara beto ira na qua sepele sa mene tekua na vavolo Alokata pa ruma tamu sau,> munagunia,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ko qai lao tugu sira na sepele ko qai vatanania sa na tetekuna Alokata isa vei sa pojaniria i Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ego ko totonai sa gore na vevelu sa sa toqo teteku tavitiria i Jisu sira ka manogarua ona sepele. ");
INSERT INTO lga_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ko tonai qai korapa teteku ira sa sa paranga si Jisu, <<Ma poja sosotonigou ara sagou: kame agou pira sa mina gabala kanasiu ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Poni sa qai takulanga beto sira na sepele, ko qai okoto nananasa memekai sisa, <<Bangara, nake ara sa qugunisiu ao, oko?>> qai okoto qarigu. ");
INSERT INTO lga_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Poni sa oeria i Jisu, pira sauniria, <<Isa sa somana totogolo tavitisiu pa baolo ara na gana bereti sa isa tugu sa mina gabala kanasiu ara. ");
INSERT INTO lga_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Na Tuna na Tinoni sa mina tavamate vei tugu isa sa pojai na Kukuti Tabuna, ba mina gana na takulanga sa na tinoni sa gabala kanai isa! Sa jongana jola sa bike pavu tavapodo sa na tinoni isa!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Poni sa paranga si Jiudasi, isa na tinoni sa malumu ko mina gabala kanai si Jisu, <<Rabi, nake ara sa qugunisiu ao, oko?>> sau. Poni sa oea i Jisu sisa, <<Isa mekamu qu pojai sisa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ego totonai qai korapa teteku ira, sa sa tekua i Jisu sa na bereti, ko sa manania, beto sa kikipai ko sa ianiria ira na ona sepele, beto sa paranga, <<Pia ko mu tekua, api sa na tiniqu,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Beto isa sa sa ovulia sa na kapa, ko sa paranga jongana laonia tana Tamasa, ko sa vaniria ira na ona sepele beto sa paranga, <<Mu bukua agou doru sapi; ");
INSERT INTO lga_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","na orunguqu sapi, isa na vamauruna na taringunguti tana Tamasa tadira nona tinoni. Na orunguqu api sa sa nyoro ko na vulasadi na sela tadira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ma poja vatalenigou: kode maneke buku ligua ara sa na vaini api, tinganai tu mina kamua na rane mana buku tavitinigou ara na vaini korega pa binangara tana Tamaqu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Beto sa jola gu sa vei inara, sa qai kerania kai kera, beto qai votu ko qai taloa lao pa kubo pa Olive. ");
INSERT INTO lga_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ego ketakoi sa parangaria i Jisu sira na ona sepele, <<Pana veveiqu ara sa kode bongi sa agou doru kode muna uku loa pale betonisiu sara, ura pira sau sa na Kukuti Tabuna, <Ara mana vamatea sa na sepati, ko na vaikamu godo sipi sa mai okoto nyanyalia na eqa,> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ba pa liguna mana turu mule pa mate sara, sa mana lao momoe pa Qalili sara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Poni sa pira sau si Pita, <<Goto ara sa vei mai uku loa palego tu ira doru, ba maneke uku loa palego sara!>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Poni sa pira saunia i Jisu aza, <<Ma poja sosotonigo ara sao: kode bongi tugu tonai mina oqoro piranga na kokorako sa kode muna kilu palenisiu kue totoso ara sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Poni sa paranga si Pita, <<Vei mana mate tavitigo tugu ao, ba maneke isongo kilu palenigo tugu sara,>> sau. Ko ira doru sepele sa qai paranga vei beto tugu inara. ");
INSERT INTO lga_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ego beto sa sa toniria i Jisu sira na ona sepele, ko qai lao pa kai ia na isongona pa Qetisemani. Beto sa poja veiniria pira, <<Mu toqo lani sagou, goto ara ma jola lao vavara pata lao pa poni,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ko i Pita gu beto karu tuna marene gu i Zebeti sa sa toniria. Sa takulanga beto sa roroqu mamata vivitigi sisa, ");
INSERT INTO lga_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ko sa parangaria sira kue, <<Sa lavata jola pa buloqu sa na takulanga api, ko kode mina boka vagojosiu tu. Mu suvere lani ko mu suvere gegele tavitisiu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Beto sa rerege rijo lao iapeki sisa, ko sa gona kole opo kokou pa peso, ko sa vavara, <<Tamaqu, bi vei bu boka ao, sa mu varijoia taqu sa na kapa vitigi api. Ba nake isa vei qa nyoroguania ara sa mina taroiti, goto isa tu vei qu nyoroguania ao,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Beto sa sa rerege mule lao tadira kue sepele, ko sa batiria qai korapa putagadia poni sa parangaria i Pita, <<Ai vei, quke boka suvere gegele tavitisiu ara kai totoso papakana sagou? ");
INSERT INTO lga_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mu suvere gegele beto mu vavara ko muke gosoria na totoke. Na gagala sa sa malumu, ba na tini sa sa munyala,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Beto sa gabala mule ligu lao vavara si Jisu, pira sau, <<Tamaqu, vei mineke boka tavarijo sa na kapa vitigi api goto mana bukua tugu ara, ba jongana gu. Isa gu qu nyoroguania ao sa mi taroiti,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Sa beto isa sa sa gabala mule ligu lame mutugu tadira kue sepele sa sa batiria qai korapa puta betogadia, ura sa ngaolo vivitigiria na nyoro puta. ");
INSERT INTO lga_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ego sa loaria mutugu i Jisu sira kue ko sa mule riu ligu vavara na vinaue totoso, ko sa kai pojaria mutugu isa sira sa tei vavaraniria tu. ");
INSERT INTO lga_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Beto sa sa gabala mule tadira kue sepele, ko pira sauniria, <<Qu korapa tugu putagamiu beto mineremiu sagou? Doro! Mi kamua gu sau sa na totoso na Tuna na Tinoni mina tavakarovo lao pa limadi ira na tinoni seladi. ");
INSERT INTO lga_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Turu ko ta lao. Doro! Sa kamu gu api na tinoni sa gabala kanasiu ara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ko sa korapa tugu paranga vei inara i Jisu sa sa bola gu si Jiudasi, isa kame ira ka manogarua sepele. Qai garunu vatutinia ira na kuta iama beto na iviva mamata tadira na tinoni sa kai puku minete tinoni lavata. Qai okoto pogoso benete vaiperana beto na kubau. ");
INSERT INTO lga_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ko sa tei poja vakoleniria tu ira i Jiudasi perangana sa kai vinagigila mina roitinia ti Jisu, pira sauniria, <<Isa na tinoni mana lao aoa ara, sa isa tugu sa na tinoni qu nyoroguania agou, ko muna lao gu aru tamania sisa,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ko sa rerege totoai lao gu i Jiudasi si Jisu, ko sa gosoro qeqerania, <<Jongana, Rabi!>> sau, beto sa sa aoa si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Poni sa pira saunia i Jisu sisa, <<Baere, na sa sa qu lamenia ao?>> sau sisa. Beto sa qai aru tamania ira si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na totoso tugu isa sa kame ira na sepele sa tutia i Jisu sa sa saputu tekua sa na ona benete vaiperana ko sa taqasa teusu palea sa kai kale talingina na pinausu tana kuta iama lavata. ");
INSERT INTO lga_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Poni sa lao i Jisu ko sa tokea sa na tinoni isa, <<Mu soba mulenia pa ona sosobana sa na mua benete ina! Ira doru qai aru benete vaipera sa mai mate tugu pa benete vaipera. ");
INSERT INTO lga_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ai sa vei quke gigilai tu ao sa nake tapatana taqu sa ara ba boka tepai gu na Tamaqu ko bi garunu lagereniria ira na joa tina mateana ko bai tokanisiu? ");
INSERT INTO lga_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ba vei mana roiti vei inara ara, sa minake boka gore votu sa isa vei sa pojai pa Kukuti Tabuna na veveina isa qa korapa gosoria ara,>> saunia i Jisu sisa. ");
INSERT INTO lga_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na totoso isa sa pira sauniria i Jisu sira na minete tinoni, <<Kai tinoni raja ikikoqu sara ko qu pogoso bola tarinisiu tu na benete beto na kubau ko muna tekusiu? Doru rane sa pa kakabarena zelepade gu qa kole suvere vaivagigalai sara, ba quke aru tamanasiu. ");
INSERT INTO lga_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ba doru sakasava pira sa qai soni taroiti ko vei tugu ko mi gore votu beto sira na kokorotai tadira na tinoni kokorotai,>> sau sisa. Beto sa ira doru sepele sa qai okoto uku loa palea sisa. ");
INSERT INTO lga_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ego ko ira tugu qai aru tamana tekua i Jisu sa qai toni laonia sisa pa ruma tai Kaiapasi, isa na kuta iama lavata. Ko ketakoi qai kole suvere vavaikamudia sira qai vaivagigalainia na Vavanau beto ko ira na iviva mamata. ");
INSERT INTO lga_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ba i Pita sa sa kole tututi vasosouona tu pa liligu, tinganai sa lame kamu pa bobole sesebena na ruma tana kuta iama lavata. Beto sa sa tome lao pa leo kakabarena na ruma ko sa lao toqo vairuraiona tadira na nabulu kopu ko mi doria isa sa na roiti mai roitinia ira tai Jisu sau. ");
INSERT INTO lga_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Qai podekia ira na kuta iama beto ko ira doru iviva pa kauniseli ko mai nyaqo votuniria sa kaki vinasosoto sesekedi, ko mai boka vamatea si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ko kubo ira sa qai turu vavovoturia na paranga sesekedi, ba kepore sa kai ginugua jongana bai batia vei bai boka vamatenia sisa. Pana vinabebetona sa qai turu sa karu tinoni, ");
INSERT INTO lga_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ko pira qarigu, <<Sa paranga sa na tinoni api, <Mana boka jegara palea ara sa na zelepade madina tana Tamasa, beto pa rane vinaue sa mana vaturu beia ara,> sau,>> qarigu sira karu. ");
INSERT INTO lga_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Poni sa turu sa na kuta iama lavata ko sa nanasia si Jisu, <<Ai vei, quke boka oeia ao sisa qai jutunigo ira karu inara?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ba sake vagala si Jisu. Poni sa paranga sa na kuta iama lavata, <<Pa korapa isongona na Tamasa toana sa qa pojanigo ara sao: mu ule vatale vanigei, ao tugu sa na Karisito na Tuna na Tamasa?>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Poni sa paranga si Jisu, <<Isa tugu qu pojai ao. Ba ma poja vatatalenigou ara sapi: podalai kopira ko mi lao kode muna batia agou sa na Tuna na Tinoni mina toqo pa kale matuana na Tamasa vivana jola, beto mina mule lame vei pa lei pa noka!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Isa tugu sa nongoria sa paranga vei inara i Jisu sa sa bako rikata palea na kuta iama lavata sa nona poko beto pira sau, <<Sa vamoroania na Tamasa sa na tinoni api! Na vinasosoto sa mule sa tana nyaqoa gita? Doro, qu tei nongoriamiu tugu agou sa sa poja vivikeria na Tamasa sapi! ");
INSERT INTO lga_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ko na sa sa na roroqu qu vatoqoa sagou ka visa bangara?>> sauniria. Poni qai oe sira na tinoni lalavata, <<Sa pada vivitigi gu ko mina tavamate sisa,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Beto poni sa qai tue taria na isumatana beto qai irirunia na vavaiiruna. Ira kaki tinoni qai kole popoaria ");
INSERT INTO lga_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","sa pira qai paranga veinia sisa, <<Ego tu, ao na Karisito! Mu ule vanigei tu moko i sei sa sa korapa majago?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ego totonai sa korapa toqona pa kakabarena na ruma tana kuta iama lavata si Pita, sa lame sa kai nabulu rereko ko sa parangia, <<Ao tugu sa kame qu tututia i Jisu na tinoni Qalili!>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ba sa kilu palenia pa moedi ira doru, pira sau, <<Qake gigilai ara sa na manugu qu korapa pojai ao ina,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tonai sa votu lao pa atakamanana na kakaberena na ruma sa sa batia mule kai nabulu rereko sisa, ko pira sauniria sira na tinoni qai suvere ketakoi, <<Na tinoni api sa sa kole tugu tututi tai Jisu na tinoni Nazareti!>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ba sa kilu pale mutugu taviti maulu si Pita, pira sau, <<Qake isongo gigila podekia tugu ara sa na tinoni ina!>> sau. ");
INSERT INTO lga_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Sa oqoro sovai gu sa vei inara, beto sa qai lao gu sira na tinoni qai kole turu ketakoi ko pira qarigunia si Pita, <<Ao sosoto gu sa kame ira qai tututia i Jisu, ura na vakerana na mua vavukele paranga sa ulenigo sosoto sao,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Poni sa paranga si Pita, <<Qa maulu sara ko qa korapa pojai na sosoto! Vei mana seseke sa mina vakilasasiu na Tamasa! Qake gigilai ara sa na tinoni qugunia agou ina!>> sau. Ego isa tugu sa poja vei inara i Pita, poni sa sa piranga gu sa na kokorako. ");
INSERT INTO lga_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Beto sa sa gigila kamua i Pita sa isa vei qi pojai perangaina i Jisu tonai pira qiunia, <<Mina oqoro piranga na kokorako, sa ao muna kilu palenisiu kue totoso,>> qiunia. Ko sa votu pa peguru si Pita ko sa lukana vapasania. ");
INSERT INTO lga_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Na vuvugei jonga sa qai vaikamu sira na kuta iama beto ira na iviva mamata, ko qai kole vaingodonia kaki roroqu vei beto mai vamatea si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Beto sa qai piua si Jisu ko qai toni laonia ti Paelati na qavuna. ");
INSERT INTO lga_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ego tonai sa gigilai i Jiudasi, isa sa gabala kanai i Jisu, sa sa tapitu ko mina tavamate si Jisu, poni sa roqu mule sisa ko sa pogoso mule laoniria tadira na kuta iama beto na iviva mamata sa ka uengavuluputa poata siliva, ");
INSERT INTO lga_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","pira sau, <<Qa sela sara, ura na tinoni tuvisina sa qa gabala kanai ara ko mina tavamate,>> sau. Poni pira qarigunia ira sisa, <<Ko ai mene veinia agei? Isa na mua ginugua tu mekamu ao sisa,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Poni sa lao gona palenia pa zelepade madina i Jiudasi sa na poata, beto sa taloa riu boru mateona. ");
INSERT INTO lga_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ko qai tekua ira na kuta iama sa na poata, beto pira qarigu, <<Na poata laona na orungu sa pira, ko nake tavamalumuna pana Vavanau za mina tavalao pa poata ruma zelepade,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ko qai vaingodonia ira sa na roroquna na poata isa ko qai vainia kai iapeki kobu peso tana tinoni sa roroiti raro patu, ko ketakoi sa na vavaigolomona tadira na tinoni gotodi. ");
INSERT INTO lga_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Inara sa vei ko na ia isa sa qai vaisongonia na Kobu Peso Orungu, ko sa korapa kole tinganai sa kamua tu pa rane pa ngeni api sisa. ");
INSERT INTO lga_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ko sa gore votu tugu sa na kokorotai isa sa lame vei ti Jeremae na tinoni kokorotai, pira sau, <<Ko qai tekuria sa ka uengavuluputa poata siliva, na vaina isa qai malumu vainia ira na tinoni Izireli, ");
INSERT INTO lga_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ko qai vainia iapeki kobu peso tana tinoni roroiti raro patu, isa sa garununisiu na Bangara ara ko mana roitinia,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ego ko sa lao turu pa moena i Paelati na qavuna si Jisu, ko sa nanasia na qavuna sisa, <<Na bangara tugu tadira na Jiu sao?>> saunia. Poni pira sau si Jisu, <<Isa tugu qu pojai ao ina,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tonai qai jutunia doru paranga ira na kuta iama beto na iviva mamata, sa sake pavu oeria i Jisu sira. ");
INSERT INTO lga_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Poni sa parangia i Paelati sisa, <<Ai vei, quke nongororia ao sa doru sakasava qai jutunigo inara?>> saunia. ");
INSERT INTO lga_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ba kepore tugu sa kai pakata paranga ikete bi oe laonia si Jisu, ko ketakoi sa sa gabara jola sa na qavuna. ");
INSERT INTO lga_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ego pa doru totoso vavolo Alokata sa na ona tutina tugu na qavuna sa sa boka ruvata vaniria ira na tinoni Jiu sa kai tinoni tapiuna mai tepai. ");
INSERT INTO lga_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ko pa totoso isa sa koleona sa kai tinoni tapiuna na tagigila vatalena sa kai tinoni ikikerena jola sisa, na isongona i Jisu Barabasi. ");
INSERT INTO lga_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ko totonai qai lao vaikamu beto sira doru tinoni sa sa nanasaria i Paelati sira, <<I sei ira karu sa qu nyoguania agou ba ruvata vanigou ara? I Jisu Barabasi ba i Jisu isa sa tapoja na Karisito?>> sau. ");
INSERT INTO lga_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ura sa gigila vataleriaona i Paelati sira ka visa iviva mamata sa qai konoa gu si Jisu ko vei sa qai loa laonia tana. ");
INSERT INTO lga_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Totonai sa korapa toqona pa nona totoqona pa ia vavaitutina si Paelati, sa sa garunu laonia na maqotana tana sa kai nongoro, pira sau, <<Muke kotia ao na tinoni tuvisina ina, ura kubo sakasava vaivatakulangadi sa qa putagitaria ara pa bongi na veveina na tinoni ina,>> sau. ");
INSERT INTO lga_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ego pa totoso isa sa ira na kuta iama beto na iviva mamata sa qai paranga sosoriria sira na minete tinoni, ko mai parangia tugu si Paelati ko mi ruvatia si Barabasi goto i Jisu sa mina tavamate tugu qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ba i Paelati sa nanasaria mule sira na minete tinoni, <<I sei ira karu pira sa qu nyoguania agou ko ba ruvata vanigou ara?>> sauniria. Poni sa, <<I Barabasi!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Poni sa parangaria i Paelati sira, <<Ko ai mana veinia ara si Jisu isa sa tapoja na Karisito?>> sau. Poni sa qai oe lao sira doru, <<Isa sa mi tavamate gu pa korosi!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ba sa nanasa liguria mutugu i Paelati sira, <<Na sela sa sa sa roitinia isa?>> sauniria. Ba totonai sa qai vevela vaiolo viviva sira, pira qarigu, <<Vamatea pa korosi!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Totonai sa doro gigilai i Paelati sa kepore mule kai sa mina boka roitinia isa goto na vaipera gu sa kode mina podo sau, poni sa lao nobu pie ko sa loqa lima pa moedi ira na minete tinoni, beto sa pira sa paranga vei, <<Ara sa qa talegasania sa na mate tana tinoni api! Kopira sa na miu ginugua tu mekamiu agou sapi,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Qai paranga sira na minete tinoni doruna, <<Jongana, agei beto ira na tumei me gosoroni vinakilasa sa na mate tana tinoni ina!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ko sa garunuria i Paelati sira na solodia ko qai ruvatia si Barabasi, beto sa pa liguna qai iruni vavaiiruna si Jisu sa sa loa lao vaniria ko mai vamatea sau. ");
INSERT INTO lga_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Beto sa qai toni laonia ira na solodia tai Paelati pa kakabarena na ruma tana qavuna si Jisu, ko qai lao turu vailivutai betonia ira na minete solodia doruna sisa. ");
INSERT INTO lga_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Qai jokolo vagore palea sa nona poko, beto qai vasae beinia kai poko gojo jijimirina. ");
INSERT INTO lga_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Beto qai tekua na kae gou vavaiokana ko qai polo vadididolai vaipipiluainia beto sa qai vasolapania pa batuna, beto qai tekua kai kolu ko qai vaarunia pa lima kale matuana. Beto sa qai kole totodongo pa moena ko qai kole vavagoreni qera, pira qarigu, <<Mi toa vakakasa tu na bangara tadira na Jiu!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Beto sa qai tue taria, beto qai majai na batuna. ");
INSERT INTO lga_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Pa liguna qai beto vavagoreni qera veinia inara, sa qai vagore pale sa na poko jimiri qai vasaenia, ko qai vasae beinia nona poko, beto sa qai toni votu laonia ko mai vamatea pa korosi qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ego totonai qai taloa riu sa qai lao gosoria sa kai tinoni pa Saerini, na isongona i Saimone. Qai juju tarinia ko qai vapogosonia isa ira na solodia sa na korosi tai Jisu. ");
INSERT INTO lga_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Qai lao kamua ira sa kai ia na isongona pa Qoloqota, na ginuana sa na Eqa Batu Tomate. ");
INSERT INTO lga_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Pa ia ketakoi sa qai vania na vaini isa qai vaisomanainia na sakasava pasana sa vamalibua na vitigi. Ba tonai sa gigilai na lilingina sa pasa poni sa sa daiona bukua. ");
INSERT INTO lga_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Qai vamatea pa korosi ira sisa, beto sa qai gonania na patu vivile ko qai vilea i sei mina tekuria sira nona poko. ");
INSERT INTO lga_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Beto poni sa qai kole toqo dodoro kopunia. ");
INSERT INTO lga_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Qai kuti vakolea pa korosi pa toto batuna pa narena isa sira na paranga sa tajutunia isa, pira sau: API SI JISU NA BANGARA TADIRA NA JIU. ");
INSERT INTO lga_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ko qai mekarai vamate tavitinia isa sa karu tinoni raja ikikodi, kame keta pa kale matuana, kame keta pa kale merina. ");
INSERT INTO lga_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ira na tinoni qai rerege jola sa qai bebegolo beto bebekuturia na batudi beto qai avavu beto poja vivikere pale si Jisu, ");
INSERT INTO lga_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","pira qarigu, <<Ao na tinoni muna jegaria na zelepade madina beto pa rane vinaue muna roiti beinia qugu! Ego tu mu alo mulenigo mekamu vei muna Tuna na Tamasa sao. Mu tavisu goremua pa korosi!>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ko ira na kuta iama, ira qai vaivagigalainia na Vavanau beto ko ira na iviva mamata ba qai kole ngangangulu veinia tugu inara si Jisu, pira qarigu, ");
INSERT INTO lga_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","<<Na goto tinoni tu sa sa aloria, goto mekana sake boka alo mulenia mekana! Na Bangara pa Izireli sisa sau ke! Ko kopira mi tavisu gore lagere tu pa korosi ko ta vasosotoa. ");
INSERT INTO lga_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Sa rangea ko na Tamasa beto mekana ba, <Ara sa na Tuna na Tamasa,> sau. Ko aria ko ta dodogoro kopunia moko! Mina nyogua tugu beka aloa na Tamasa sisa!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ira karu tinoni raja ikikodi qai titi tavitia isa pa karu kalena ba qai somana paranga ngangangulu veinia tugu aza. ");
INSERT INTO lga_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ego podalai na korapa rane sa sa udea na rodomo kukuni sa na doru eqa, ko sa kole rodomo pada kue aoa. ");
INSERT INTO lga_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ko sa kamua papada vei kue koloko sa sa kukuku lukana si Jisu, <<Elai, Elai, Lama Sabakatani?>> sau. (Na ginuana sa pira sau, <<Qua Tamasa, qua Tamasa! Ai sa vei ko qu loa palenisiu tu ao?>> sau.) ");
INSERT INTO lga_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kaki ira qai korapa turu ketakoi sa qai nongoriadia sa paranga vei inara isa, ko qai paranga sira, <<Na tinoni ina sa korapa kukua si Elaija,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ko kame ira sa sa sisiqarai abutu lao tekua kai poko, ko sa vatubulunia kai buku pasana, ko sa vakolea pa uquna na kolu, beto sa sa alaka saenia ko mi vabukua sau. ");
INSERT INTO lga_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ba qai paranga sira kaki, <<Loai ko! Ta dodogoria mai, palu kode mina kamu aloa i Elaija sina!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Beto sa kai lukana vaiolo viviva si Jisu, beto sa sa loai na singo. ");
INSERT INTO lga_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ko pana totoso tugu isa sa na toba poko babana sa titi pa zelepade madina sa sa tarikatarua, sa podalai tu pa nulu ko sa gore tu kamu pa uquna pa peso. Ko sa jojou sa na peso ko qai tapapaqala sa na patu, ");
INSERT INTO lga_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ira na bevi vavaigolomodi sa qai tajejegara ko qai tarevanga, ko na motadi ira na tinoni tana Tamasa qai tei mate tu pa moa sa qai tavatoa mule. ");
INSERT INTO lga_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ko qai turu taloa pa dia bevi, ko pa liguna sa turu mule i Jisu sa qai tome lao pa gugusu tabuna pa Jerusalema, ko qai batiria ira na mota tinoni suveredi ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na tinoni mamata gogoto beto ko ira na tinoni vaipera qai suvere tavitia isa ko qai kole kopunia i Jisu sa qai matagutu vivitigi totonai qai vagigilai na nunu beto doru sakasava qai taroiti, ko qai paranga sira, <<Sosoto na Tuna tugu na Tamasa sa na tinoni api!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ego na motadi ira na rereko qai rererege tavitia i Jisu na koko lame veidi pa Qalili ko qai totokania isa sa qai kole tugu suveredia ketakoi. Qai turu pa souna ko qai kole dodoro lao. ");
INSERT INTO lga_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ko ira Mere pa gugusu Magadalene, i Mere na tinadi ira Jekopi i Josepa, beto na maqotana i Zebeti sa qai kole tugu suvere vaisomanaidia tadira na rereko ketakoi. ");
INSERT INTO lga_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ego totonai sa gore sa na vevelu sa sa kamu si Josepa kai tinoni isisongo pa Arimatia. Kai sepele tugu tai Jisu sisa. ");
INSERT INTO lga_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Sa lao tai Paelati sisa ko sa tepai sa na kokobu tinina i Jisu. Poni sa vamalumia i Paelati ko mai loa lao vania i Josepa sa na kokobu tinina i Jisu sau. ");
INSERT INTO lga_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ko sa lao teku vagorea i Josepa sa na kokobu tinina i Jisu, ko sa udenia kai poko liosona. ");
INSERT INTO lga_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Beto sa sa lao vakolea pa ona bevi koregana, isa sa koni ruri vaoqilia pa patu. Ko sa bokili laonia kai patu lavata sa pa atakamanana na bevi, beto sa riuona. ");
INSERT INTO lga_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ko i Mere pa gugusu Magadalene, beto kai goto Mere mule sa qai kole tugu toqo bata lao veidia tugu pa bevi isa. ");
INSERT INTO lga_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ego sa rane ligu neqa, na rane Minere, sa qai mekarai lao kamua i Paelati sira na kuta iama beto na Parese. ");
INSERT INTO lga_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ko qai paranga sira, <<Bangara, qeke roqu mumania agei sa na paranga tana tinoni sesekena ina totonai sa korapa toana isa sa pojai, pira sau, <Pa rane vinaue mana toa mule pa mate sara,> sau. ");
INSERT INTO lga_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ko muna garunu laoniria tu kaki tinoni kopu sa pa bevi ko mai kopu vatalenia tinganai mina jola tu kue rane. Kita ira na ona sepele gu mai kamu iko tekua sa na kokobu tinina beto mai lao seseke tadira na tinoni, <Sa tei toa mule tu pa mate sisa,> kita marigu. Ko isa na seseke vinabebeto isa sa kita mi ikerena jolania na momoena,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Poni sa pira sauniria i Paelati, <<Mu lao tekuria kaki solodia ko mu kopu vatale veinia isa muna bokai agou sa na bevi,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Poni qai taloa riu sira ko qai lao varamata vatalea kai vinagigila pa patu pateina na bevi, beto sa qai vasuvereria na tinoni kopu ko mai kopu vatalenia qarigu. ");
INSERT INTO lga_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ego pa liguna na rane Minere ko na vuvugei jonga rane momoe pa vuiki, sa i Mere na rereko pa gugusu Magadalene beto kai goto Mere mule sa qai lao ko mai doria na bevi qarigu. ");
INSERT INTO lga_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Poni sa sa raja sa kai nunu lavata, ura kai mateana tana Bangara pa noka sa sa gore lagere beto ko sa bokili varijo palea sa na patu sa tapateinia na bevi, beto sa kesa kole toqona pa narena. ");
INSERT INTO lga_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ko na dogorona na tinoni isa sa sa vei na malarana na kapi, beto nona poko ba qai keka keala lelei. ");
INSERT INTO lga_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ira na tinoni kopu ba qai matagutu vivitiginia sisa, ko qai gona kole neneqere vei na tinoni mai mate qarigu. ");
INSERT INTO lga_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Beto sa pira sauniria na mateana sira karu rereko, <<Muke matagutu! Qa gigilaiqua ara sa qu korapa nyaqoa agou si Jisu isa sa tavamate pa korosi. ");
INSERT INTO lga_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kepore lani sisa, ura sa tei toa mule tu sisa isa mina vei sau sa tei poja vakolea tu perangana. Mei, lame ko mu doria sa ketakoi sa kole isa perangana. ");
INSERT INTO lga_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Beto sa muna siqarai lao pojaniria sira ka visa ona sepele, <Sa tei toa mule tu pa mate sisa, ko kopira sa tei lao momoe tu pa Qalili sisa. Ketakoi tu sa muna batinia agou!> munaguniria. Mu roroqua sisa qa koni pojanigou api,>> sau sa na mateana. ");
INSERT INTO lga_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ko qai taloa sisiqarai pa bevi sira karu. Qai matagutudia tugu, ba qai qera vivitigi tugu, ko qai abutu riu ko qai lao pojaniria sira na ona sepele qarigu, ");
INSERT INTO lga_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","sa sa lame tugu gosoro qeqeraniria si Jisu, <<Jongana!>> sau. Poni qai lao tana sira karu ko qai todongo aru tamana pa karu nenena, ko qai vatarasaea sisa. ");
INSERT INTO lga_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Beto sa parangaria i Jisu sira karu, <<Muke matagutu! Mu lao pojaniria sira na tasiqu ko mai lao pa Qalili. Ko ketakoi tu sa kode mai batisiu ira sara,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ego ko totonai qai korapa rerege mule riudia sira na rereko, sa kaki ira na solodia qai kopu pa bevi sa qai lao pa Jerusalema, ko qai lao vavakatoniria tadira na kuta iama sira doru ginugua qai podo aipira. ");
INSERT INTO lga_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Poni qai vaikamu sira na kuta iama na iviva mamata ko qai vatoqoa sa kai roroqu ko qai vani vasokuniria na poata sira na solodia qai kopu pa bevi, ");
INSERT INTO lga_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","beto pira qai naqu veiniria, <<Pira munagu sagou, <Qe kole puta agei na bongi sa qai kamu iko tekua ira na ona sepele sa na tinina,> munagu. ");
INSERT INTO lga_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Vei mina nongoria na qavuna sa na ginugua api, sa agei kode mene paranga valolomosia sisa ko agou muneke gosoro tapata,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ko qai aru vakarovia ira na solodia qai kopu pa bevi sa na poata, beto qai tutia tugu sisa vei muna roiti vei qariguniria ira na kuta iama. Ko na vavakato isa sa sa tavarerege tadira na tinoni Jiu tinganai sa kamua pa rane pa ngeni api. ");
INSERT INTO lga_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ego ko qai taloa lao pa Qalili sira na ona sepele pa kubo ketakoi sa poja vakoleniria i Jisu mai vera sauniria. ");
INSERT INTO lga_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ko totonai qai batia ira si Jisu sa qai vatarasaea ira sisa, ba kaki qai ruarabeke tugu. ");
INSERT INTO lga_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Beto sa rerege tata laoria i Jisu sira, ko sa parangaria, <<Qa tei taiania tu ara sa doru neqi pa noka beto pa peso. ");
INSERT INTO lga_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ko sa vei sa mu lao ko mu vasepele vanisiu sira doru puku tinoni, muna paputaisoria pa isongona na Tamana, na Tuna, beto na Gagala Tabuna. ");
INSERT INTO lga_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Beto ko muna vaivagigalainiria ko mai vataberia sira doru sakasava qa garununigou ara. Beto ko ara sa mana vavaburogou doru totoso, tinganai mina kamua na vinabetona na totoso,>> sau si Jisu.");
INSERT INTO lga_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Api sa na popodalaina na nongoro jongana na veveina i Jisu Karisito, na Tuna na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Na paranga tana Tamasa sa takuti pa kukuti tai Aisea na tinoni kokorotai sa pira sau, <<Mu vainongoro! Ara mana garunu laonia pa moemu ao sa na qua tinoni pogoso nongoro. Isa sa mina vatana vanigo na soana ao. ");
INSERT INTO lga_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kai ovovele sa korapa kukuku pa qega, pira sau, <Agou mu vatanai na soana tana Bangara. Mu vaemese vania na soana isa,> sau,>> sau si Aisea. ");
INSERT INTO lga_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ego ko i Jone sa na tinoni pogoso nongoro sa koko lame vei pa qega ko sa kole taraenia isa sa na veveina ira na tinoni mai gabala beto mai paputaiso ko na Tamasa mi taleosoniria na dia sela sauniria. ");
INSERT INTO lga_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Poni ira doru pa vailivutaina pa Jiudia beto ira doru pa Jerusalema sa qai vovotu lao tana, ko qai ule votuniria na dia sela ko isa sa paputaisoria pa leo pie Jodani. ");
INSERT INTO lga_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ego ko i Jone sa sa vasaea na poko vurungu kameli, na beleti sa doko livutunia na sisikirina, beto na kupo beto na muji pirudi na ona tetekuna. ");
INSERT INTO lga_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ko na nongoro sa kole taraenia isa sa pira sau, <<Pa liguqu ara mina tuti lame sa kai tinoni isa sa poreveveina jolanisiu ara. Ara qa ikete jola ko nake padaqu mana ovoro gore ruvata vania na pikona na ona sadolo sisa. ");
INSERT INTO lga_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ara qa paputaisonigou na kolo sagou, ba isa tu mekana sa mina paputaisonigou na Gagala Tabuna,>> sau si Jone. ");
INSERT INTO lga_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pa totoso tugu isa i Jisu sa sa kamu koko vei pa gugusu pa Nazareti pa Qalili ko sa lame tapaputaiso tai Jone pa Jodani. ");
INSERT INTO lga_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ko isa tugu sa iolo votu isa pa kolo sa sa batia isa sa na oka sa revanga beto na Gagala Tabuna sa igoro lagere vei kai kuru kavu tana. ");
INSERT INTO lga_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Beto kai ovovele sa votu lagere vei pa noka, pira sau, <<Ao sa na Tuqu qa roroqu vivitigigo ara. Ao sa qa qera jolanigo ara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ko pa liguna tugu isa, sa sa toni votu laonia pa qega na Gagala Tabuna si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ko ka madengavuluputa rane sa sa kole totokea i Setani pa qega sisa. Isa sa kole suvere tavitiria sira na manugu piru mamade nenedi, beto ko ira na mateana qai kopu vatalenia sisa. ");
INSERT INTO lga_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ego pa liguna sa tapiu si Jone, sa sa tomea i Jisu sa na ia pa Qalili ko sa kole taraenia isa sa na nongoro jongana na veveina na Tamasa, ");
INSERT INTO lga_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","pira sau, <<Sa okoto gu sa na totoso beto mi toga gu sau sa na binangara tana Tamasa. Mu gabala agou ko mu vasosotoa sa na nongoro jongana,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ego tonai sa korapa popoana pa keketaina na ovuku pa Qalili si Jisu, sa sa batiria sira Saimone beto i Aduru na tasina marene. Qai korapa vaqaradia pa ovuku sira, ura na tino abu sira karu. ");
INSERT INTO lga_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Poni sa kukuria i Jisu sira karu, pira sauniria, <<Mei, lame! Tutisiu, ko ma roitinigou na tinoni abu tinoni,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Poni totonai tugu qai turu loa pale gu ira karu sa na dia vaqara, ko qai lao tutiadia si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ko tonai sa rerege rijo lao gu mule iqona, sa sa batiria gu mule sira Jekopi beto i Jone, kao tamatasi tuna i Zebeti, qai korapa tuvaka dia vaqara pa leo dia koaka. ");
INSERT INTO lga_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Totonai tugu sa kukuria i Jisu sira karu. Poni qai turu loa pale ira karu pa koaka sa na tamadi i Zebeti beto ira na dia tinoni roiti ko qai tutiadia gu si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ego sa lao pa gugusu pa Kepaniami si Jisu beto ko ira na ona sepele. Ko tonai sa kamua sa na rane Minere poni si Jisu sa lao tome pa ruma vavaikamuna ko sa podalai vaivagigalai. ");
INSERT INTO lga_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ko qai gabara betonia ira na tinoni sa na vaivagigalai tana, ura isa sake vavaivagigalai vei ira qai vaivagigalainia na Vavanau, goto sa vavaivagigalai vei na tinoni sa poreona neqi. ");
INSERT INTO lga_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na totoso tugu isa sa korapa suvereona pa leona ruma vavaikamuna isa sa kai tinoni sa kolea na gagala ikerena ko sa lukana uui, pira sau, ");
INSERT INTO lga_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","<<Na sa na mua ginugua tamigei sa ao Jisu pa Nazareti? Qu lame ko mu piaragei agei qugu? Ara qa gigilagoqua sao! Ao sa na Liosona tana Tamasa!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Poni sa tokea i Jisu sa na gagala ikerena api, pira saunia, <<Mu noso ko mu votu riu tana tinoni ina,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Poni sa lao tu na gagala ikerena ko sa tuaria ko sa aru vivitigi palea sa na tinoni isa, beto sa uui viva beto sa votu taloa riu. ");
INSERT INTO lga_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Poni qai gabara vivitigi sira doru tinoni ko qai vaigua mekadi, pira qarigu, <<Na sa sa pu vei pira? Na vaivagigalai koregana sa tavitia na neqi sa api! Ko ira na gagala ikeredi sa iju paleniria ba qai nongoria tu ko qai vatabea tu!>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ko na nongorona na roiti ti Jisu sa sake ruavo tu tapiara rerege doru eqa pa vailivutaina pa Qalili. ");
INSERT INTO lga_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Isa tugu qai votu taloa pa ruma vavaikamuna, poni sa i Jisu beto ira Jekopi beto i Jone qai rerege vatuvisi lao pa ruma tadira Saimone i Aduru. ");
INSERT INTO lga_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na qoele roana i Saimone sa mangini na tinina, ko sa korapa kole pa lovu. Isa tugu sa kamu i Jisu sa qai ule vania gu isa sa na veveina na moona na qoele api. ");
INSERT INTO lga_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Poni sa lame arua sa na limana, ko sa bako vatatakolea. Poni sa taloa tana qoele sa na mo mangini, ko isa tugu sa vatana vaniria sa na tetekuna sira. ");
INSERT INTO lga_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ego ko totonai sa gore na vevelu tonai sa koni suvu sa na tapo, poni sa qai totoni kamuniria tana sira doru tinoni momoodi beto ko ira sa tomeria na tomate ikikeredi. ");
INSERT INTO lga_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ko na minete tinoni lavata pa gugusu isa sa qai vavaikamu pa atakamanana na ruma isa. ");
INSERT INTO lga_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ko sa salanaria i Jisu sira na tinoni sa rajaria na okokoto mo, beto sa iju votu paleniria isa sira doru tomate ikikeredi. Sake vamalumuria isa sira na tomate ikikeredi pira ko bai pojai kaki paranga, ura qai gigilaidia ira na tomate sisa. ");
INSERT INTO lga_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na vuvugei rorodomo totonai sa oqoro kabere na eqa sa dorava ko sa votu taloa lao pa kai ia kaloina si Jisu ko ketakoi sa kole vavaraona. ");
INSERT INTO lga_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Totonai sa i Saimone beto ira kaki ona baere sa qai nyaqo tututia sisa. ");
INSERT INTO lga_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ko totonai qai batia sisa poni sa pira qarigunia, <<Ira doru qai korapa doro nyanyaqogo sao,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ba pira sauniria i Jisu sira, <<Aria ko ta jola lao pa kaki gugusu pata lao lana ko ara ma tarae mule ketakoi, ura isa sa qa lamenia ara,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ko sa lekogoria isa sa doru eqa pa Qalili, ko sa tarae pa dia ruma vavaikamuna beto sa iju vovotu paleniria isa sira doru tomate ikikeredi qai kole tadira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kai tinoni sa popoqu sa sa lame ti Jisu, ko sa toqo sori tutunguna pa moena isa ko sa tepa totokai si Jisu, pira sau, <<Vei bu malumu sao, sa muna boka valiososiu gu sara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sa roroqu vivitigia i Jisu sa na tinoni api, ko sa kaqamania na limana ko sa ulia sisa, beto pira saunia, <<Ara qa malumu gu, ko mu lioso tu sao,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Na totoso tugu isa sa tataloso valioso sa na popoqu ko sa lioso sisa. ");
INSERT INTO lga_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Pa liguna isa sa i Jisu sa vania na vavanau neneqina beto sa garunu variua sisa. ");
INSERT INTO lga_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Pira sa vavanau veinia i Jisu sisa, <<Munake isongo vavakatonia ao tana kai goto tinoni sa na veveina api. Goto mu lao mekamu ko mi doro vilotigo na iama beto mu valaoa na mua vavakukuvu vuvulasa sa vaigarununia i Mosese, ko ira doru tinoni mai vasosotoa sa ao qu tei tavalioso tu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ba isa tugu sa taloa riu sa na tinoni api, sa sa podalai vevelania gu beto sa valekogia gu isa sa na nongoro api. Sa jola sosoto sa na vavakato tana tinoni api ko i Jisu sake boka rerege vakakabere lao pa gugusu, goto sa suvere vakaloiona tu pa peguruna na gugusu. Ko ira na tinoni pa doru vailivutaina ketakoi sa qai lame tana. ");
INSERT INTO lga_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ego sa jola gu ka vivisa rane tonai sa mule lao ligu pa Kepaniami si Jisu, poni sa qaike ruavo tugu nongoronia ira na tinoni sa isa sa tei korapa tu pa ruma qarigu. ");
INSERT INTO lga_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Qai kubo jola sira na tinoni qai vaikamu ko kepore tugu sa kai rora bi kole ko sa jutu lao tu pa moena na atakamana, ko ketakoi sa kole vavakatonia i Jisu sa na paranga. ");
INSERT INTO lga_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Totonai tugu sa qai pogoso kamunia ira ka made sa kai tinoni sa mate kai kale kobu tinina ko sake boka rerege. ");
INSERT INTO lga_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ba qaike boka pogoso laonia tana ira sa na tinoni api ura sa pugelia na tinoni sa na leo ruma. Ko qai kesa ko qai kakelia tu sa na arena na ruma pa totona sosoto i Jisu. Ko sa korapa tugu koleona pa nona lovu sa qai vasikulu gorea sa na tinoni isa. ");
INSERT INTO lga_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tonai sa batia i Jisu sa na koi vei lavatana na rarange tadira poni sa paranga laoa isa sa na tinoni sa mate kai kobu tinina, pira saunia, <<Tuqu, qai tei taleoso tu sira na mua sela,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ba ira kaki qai vaivagigalainia na Vavanau sa qai korapa toqo tata ketakoi ko qai kole vaiperania pa bulodi sa pira qarigu, ");
INSERT INTO lga_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<Ai sa vei ko sa paranga vei tu inara sa na tinoni api? Sa vamoroania na Tamasa sa na tinoni ina! Ura mekana gu na Tamasa sa sa boka taleosonia sa na sela!>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ba sa tei gigilaiona tu i Jisu pa totoso isa sa isa vei qai kole vaiperania ira pa bulodi, ko sa paranga laoria isa sira, pira sauniria, <<Ai sa vei ko qu vaiperania tu pa bulomiu agou sa aipira? ");
INSERT INTO lga_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ai ira karu paranga pira sa sa munyalana ko bi paranga laonia tinoni sa mate kai kale tinina ina? <Qai tei taleoso tu sira na mua sela,> biunia? Ba, <Mu turu, mu teku pogosia na mua lovu ko mu rerege!> biunia tu? ");
INSERT INTO lga_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ba vei ko mu soni gigilai agou sa na Tuna na Tinoni sa poreona neqi ko mina taleosoniria sira na sela pa peso sa pira ropi ma roiti vei sara,>> sau. Ko sa paranga laoa sa na tinoni sa mate kai kale tinina, ");
INSERT INTO lga_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","pira saunia, <<Ma pojanigo ara sao: turu, mu teku pogosia na mua lovu ko mu mule laomua pa mua ruma,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pa totoso tugu isa sa turu, sa teku pogosia na ona lovu ko sa votu riuona pa moedi ira doru sa na tinoni isa. Ko qai gabara beto sira doru beto qai vatarasaea ira sa na Tamasa, pira qarigu, <<Sa oqoro tabata tadagita sa kai sakasava vevei api!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ego i Jisu sa gore ligu lao pa poanana pa ovuku Qalili ko ira na minete tinoni qai lame vavaikamunia, ko isa sa kole vagigalairia. ");
INSERT INTO lga_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tonai sa korapa rerege jola si Jisu, sa sa batia si Livai na tuna i Alepiasi, sa korapa toqona pa ruma teteku takisina. Poni sa paranga laoia i Jisu sisa, pira saunia, <<Mei tutisiu,>> saunia. Poni sa turu ko sa tutiaona tugu i Jisu sisa. ");
INSERT INTO lga_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ko tonai sa korapa toqo tetekuona pa ruma tai Livai si Jisu, sa soku sira na tinoni teteku takisi beto ira na tinoni seladi sa qai kole toqo tavitia si Jisu beto ira na ona sepele. Ura na motadi sira qai tututia i Jisu. ");
INSERT INTO lga_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ira na Parese qai vaivagigalainia na Vavanau sa qai korapa tugu ketakoi. Ko tonai qai batia si Jisu sa korapa teteku tavitiria sira na tinoni seladi beto ira na tinoni teteku takisi, poni sa qai nanasaria sira nona sepele, pira qarigu, <<Ai sa vei ko sa teteku tavitiria tu ira na tinoni teteku takisi beto ira na tinoni seladi sa na tinoni api?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tonai sa nongoro vairia i Jisu sira poni sa pira sauniria, <<Ira na tinoni toa vataledi sa qaike nyaqoa sa na tinoni vaisalana, goto ira tu na tinoni moodi. Ara qake lame ko ma kukuria ira na tinoni tuvisidi qau, goto ira tu na tinoni seladi,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ego ira na sepele tai Jone beto ira na Parese sa qai tatabu gagani. Ko ira na tinoni sa qai lame ko qai nanasia si Jisu, pira qarigunia, <<Ai sa vei ko ira na sepele tai Jone beto ira na sepele tadira na Parese sa qai tatabu gagani, goto ira na sepele tamu sa qaike tatabu gagani tu?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Poni sa oe laoria i Jisu sira, pira sauniria, <<Ai sa vei, ira na tinoni tasorudi mai somanania na vavolo vaialava sa kode mai boka tatabu gagani tonai mina korapa suvere tavitiriaona sa na marene sa vaialava? Dai! Tonai qai korapa suvere tavitia ira sa na tinoni sa koni vaialava api sa maike boka tatabu gagani sira. ");
INSERT INTO lga_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ba sa korapa lame sa na rane tonai mina tateku variu sa na marene sa vaialava api. Ko pa liguna tu isa sa mai tatabu gagani sira. ");
INSERT INTO lga_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kepore sa kai tinoni sa tekua sa kai rikata poko koregana ko sa tuvakania na poko leluna. Ura vei mina roiti vei isa, poni sa na rikata koregana mina pijoko ko mina bako rikatia sa na poko leluna, ko na taraqama ikerena jola mutu sa sa mina taroiti. ");
INSERT INTO lga_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Beto kepore sa kai tinoni sa toto laoni vaini koregana sa na tototona leluna. Ura vei mina roiti vei isa, poni sa na vaini koregana sa kode mina pujaka pokatia sa na tototona leluna, ko mai ikere vaitakoi sa na vaini beto na tototona. Goto na vaini koregana sa sa toto laonia pa tototona koregana tugu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pana kai rane Minere totonai sa rerege lao vei pa korapa inuma vuiti si Jisu, poni sa qai podalai ravusu tekugadia kiko vuiti sira nona sepele. ");
INSERT INTO lga_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Poni qai paranga sira na Parese, pira qarigunia, <<Doro, ai sa vei ko qai roitinia tu pa rane Minere ira na sepele tamu sa na roiti sake tavamalumu pana Vavanau?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Poni sa oeria i Jisu sira, pira sau, <<Ai vei, qu oqoro tu tiro vakaberia agou sa isa vei sa roitinia i Devita beto ira nona tinoni tonai sa keporenia na gagani ko qai burana vaivasevi? ");
INSERT INTO lga_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pana totoso sa korapa kuta iama lavata i Abiata, sa sa tomea i Devita sa na ruma tana Tamasa ko sa tekua isa sa na bereti madina ko sa gania. Na vavanauna na bereti madina isa sa mekadi gu ira na iama sa qai tavamalumunia ko mai boka tekua sisa. Ba i Devita sa tekua tu beto sa ianiria mutugu vei sira na ona tinoni,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Beto pira sauniria, <<Na rane Minere sa sa taroiti vania na tinoni, nake tinoni sa sa taroiti vania na rane Minere. ");
INSERT INTO lga_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ko na Tuna na Tinoni sa na bangarana tugu vei na rane Minere,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ego tonai sa lao mule pa ruma vavaikamuna si Jisu, sa sa korapa ketakoi sa kai tinoni sa raiqo kai kale limana. ");
INSERT INTO lga_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ko ira kaki tinoni qai kole dodoro kopunia si Jisu ko vei mina salania na rane Minere sa na tinoni alepi poni sa mai jutunia sa sela sisa marigunia qarigu. ");
INSERT INTO lga_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sa paranga laoa i Jisu sa na tinoni sa raiqo na limana, pira saunia, <<Mei, mu turu sale pa momoe,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Beto sa nanasa laoria i Jisu sira na tinoni, pira sauniria, <<Na sa sa tavamalumu pana Vavanau ko mina boka taroiti pa rane Minere? Na roiti vajonga, ba na roiti vivikere? Na aloa na toa tana tinoni, ba na vamatea?>> sauniria. Ba qaike vagala. ");
INSERT INTO lga_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ego ko sa doro vailivutainiria tagigigiriniria i Jisu sira beto sa takulanga tugu vei ura sa patu na bulodi. Beto sa paranga laoa sa na tinoni api, pira saunia, <<Mu radonia na limamu,>> saunia. Ko sa varadonia sau poni sa jonga ligu sa na limana. ");
INSERT INTO lga_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Isa tugu qai taloa pa ruma vavaikamuna sira na Parese, sa qai sisiqarai lao kamuria sira qai sosoria i Herodi ko qai mekarai vaingodo roroqu ko mai vamatea si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ego ko i Jisu beto ira na ona sepele sa qai taloa riu veidia pa ovuku pa Qalili, ko kai minete tinoni lavata sa qai tuti koko vei pa Qalili, pa Jiudia, ");
INSERT INTO lga_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","pa Jerusalema, pa Idumea, pa kai karovona pa Jodani, beto pa vailivutaidi pa Turosi beto pa Sidoni. Ira doru aipira sa qai nongoroniria sira doru roiti sa roitiniria isa, ko qai vaikamu lame tana. ");
INSERT INTO lga_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ko totonai sa pojaniria i Jisu sira na ona sepele ko mai vatana vakole vania sa kai koaka sau ura qai soku jola sira na tinoni ko kita mai jupe vaiamunia ira. ");
INSERT INTO lga_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ura soku jola sira na tinoni sa salanaria isa ko ira na tinoni vagaurudi sa qai jujuku laoa sisa ko vei ko mai ulia sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ira na tinoni sa koleria na gagala ikeredi ba tonai qai batia i Jisu poni sa qai vukele kole pa moena isa beto qai vevela votu, pira qarigu, <<Ao sa na Tuna na Tamasa!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ba sa paranga suquturia i Jisu sira na gagala ikikeredi ko maike pojai ira sa na veveina isa sau. ");
INSERT INTO lga_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ego sa sagere sae pa kai kubo si Jisu beto sa kuku vaikamuniria sira sa nyoroguaniria ko mai tutia, ko qai vaikamu lao tana sira. ");
INSERT INTO lga_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ko sa vileria i Jisu sira ka manogarua beto sa gigalaniria na tinoni tagarunudi sira, ko mai suvere tavitia isa beto ko mina garunu riuniria ko mai tarae sau. ");
INSERT INTO lga_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Beto sa vaniria na neqi ko mai ijiju pale tomate ikikeredi sau. ");
INSERT INTO lga_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ko aipira sa na isongodi ira ka manogarua sa vileria i Jisu: i Saimone (isa sa vakukunia i Pita), ");
INSERT INTO lga_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","i Jekopi beto i Jone karu tuna i Zebeti (ira sa gigalaniria Boneage, na ginuana sa na tuna na paka oka), ");
INSERT INTO lga_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","i Aduru, i Pilipi, i Batolomiu, i Matiu, i Tomasi, i Jekopi na tuna i Alepiasi, i Tadaeasi, i Saimone isa perangana sa somanana talea na qavuna Romu, ");
INSERT INTO lga_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","beto ko i Jiudasi Isikarioti isa na tinoni sa gabala kanai i Jisu. ");
INSERT INTO lga_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ego tonai sa kamu pa ruma si Jisu sa qai kamu vaitakoi tugu sira na minete tinoni ko i Jisu beto ira nona sepele sa qaike boka teku totoso ko bai tetekudia. ");
INSERT INTO lga_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Totonai sa qai lame sira na turana ko mai ragata toni variua si Jisu qarigu, ura qai nongoronia sa sa tei tuturu tu sa na tinoni ina qarigu sira kaki. ");
INSERT INTO lga_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Beto ira qai vaivagigalainia na Vavanau na lagere veidi pa Jerusalema sa qai kole popojai, pira qarigu, <<Sa kolea i Beelizebulu beto pa neqi tana na bangaradi ira na tomate sa sa boka ijiju paleria na tomate sa na tinoni api,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Poni sa kuku tekuria i Jisu sira qai vaivagigalainia na Vavanau ko sa vavakato vaniria na vavakato vavapada, pira sau, <<Ai vei i Setani mina boka iju variua tu si Setani mekana? ");
INSERT INTO lga_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Na binangara sa vaipipikatai mulenia mekana sa kode minake boka turu vaneqi. ");
INSERT INTO lga_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Beto na tatamana sa vaipipikatai mulenia mekana sa kode mina tajejegara. ");
INSERT INTO lga_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ko vei i Setani mina kana mulenia mekana beto mina vaipipikatai mekana, sa minake turu vamauru sisa goto kode mina manyao gu sisa. ");
INSERT INTO lga_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Beto ko kepore sa kai tinoni mina boka soqolo tome lao pa leo ruma tana tinoni neqina ko mina iko tekuria sa na sakasava tana vei bi oqoro piu vakole momoea mai tu sa na tinoni neqina api. Momoe sa mina piu vakolea mai tu isa sa na tinoni neqina api, beto sa mina boka iko vapuputia isa sa na sakasava pa ruma tana. ");
INSERT INTO lga_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ma poja sosotonigou ara sagou: kode mai boka taleoso gu sa doru sela bai roitiniria ira na tinoni beto doru vamoroanana na Tamasa qai poja votuniria. ");
INSERT INTO lga_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ba na tinoni sa vamoroania na Gagala Tabuna sa minake taleoso kamua na kamua, ura isa sa tei roitinia tu sa na sela kole jolana,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Inara sa vaivagigalai vei si Jisu ura kaki tinoni sa pira qai kole paparanga vei, <<Sa kolea na gagala ikikerena sa na tinoni api,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ego na tinana beto ira na tasina marene i Jisu sa qai kamu. Ko qai turu pa sesebe ruma isa beto qai garunu tomenia sa na nongoro ko mi votu lame si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na vaikamu tinoni sa qai korapa toqo vavailivutainia si Jisu ko ira kaki sa qai paranga laoa sisa, pira qarigunia, <<Qokolo, na tinamu beto ira na tasimu marene sa pa peguru ko qai korapa nyaqogo sao,>> qarigunia si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Poni sa oe laoria i Jisu sira, pira sau, <<I sei sa na tinaqu beto ko ira sei sira na tasiqu marene ara?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Beto sa doro vailivutainiria sira qai toqo pa vavailivutaina beto pira sauniria, <<Doro! Aipira tugu sira na tinaqu beto na tasiqu marene ara. ");
INSERT INTO lga_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Na tinoni sa roitinia isa vei sa nyoroguania na Tamasa sa isa tugu sa na tasiqu marene, na luluqu rereko, beto na tinaqu ara,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ego sa podalai vaivagigalai mule pa poanana pa ovuku Qalili si Jisu. Ko na minete tinoni lavata sa qai vavaikamu lame tana, ko sa lao tu koi ko sa toqo pa kai koaka titina pa kolo, goto ira na minete tinoni sa qai turu pa poanana. ");
INSERT INTO lga_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ko sa kole vagigalainiria isa sa soku vavakato vavapada. Ko pa ona vaivagigalai sa pira sa vavavakato vei. ");
INSERT INTO lga_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<Mu vainongoro ko! Koleona sa kai tinoni umuma sa votu riu vavuvusuria na kiko. ");
INSERT INTO lga_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ko tonai sa kole vavavuvusu isa, sa kaki kiko sa qai vukele lao pa lodaka soana ko qai kamu na manugu ko qai tobiki gani betoria na gadia. ");
INSERT INTO lga_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kaki kiko sa qai vukele pa bubuturu ketakoi sake mota na peso, ko qaike ruavo tugu na pidokodi ura sake soku na peso. ");
INSERT INTO lga_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ba totonai sa sagere na tapo ko sa alangaria poni sa qai malei matedia, ura sake gore vakori na bageredi. ");
INSERT INTO lga_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kaki kiko sa qai vukele lao pa eqa sa kolea na gasoro vavaioka, ko tonai qai pidoko sa na kiko, sa na gasoro vavaioka sa amu tariria ko qaike vua. ");
INSERT INTO lga_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Goto kaki kiko sa qai vukele lao pa peso jongana ko qai pidoko beto qai toa sae ko qai vua vuvungu. Ko kaki qai vua uengavulu, kaki vonomongavulu, beto kaki sa kai gogoto tu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Beto sa pira sau, <<Na tinoni sa pore na talingi nonongorona sa mi vainongoro!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ego totonai sa korapa suvereona mekana si Jisu, sa qai lame sira kaki tinoni qai tututia isa beto ko ira ka manogarua sepele ko qai nanasania sa na ginuana na vavakato vavapada api. ");
INSERT INTO lga_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Poni sa oeria i Jisu sira, pira sauniria, <<Agou qu tei taiania tu sa na gigalai paena na veveina na binangara tana Tamasa, goto ira qai sou tana sa doru gigalai sa qai tekuria pa vavakato vavapada gu. ");
INSERT INTO lga_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ko sa gore votu sa na ginuana na Kukuti Tabuna: <Mai dogoro ko mai dodogoro ba maike batia, mai nongoro ko mai nonongoro ba maike vakaberia. Ura kita mai gabala ko mai taleosoniria,> sau,>> sauniria i Jisu sira. ");
INSERT INTO lga_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Beto pira sauniria i Jisu sira, <<Ai sa vei, quke vakaberia tu agou sa na vavakato vavapada api? Ego ko inara sa vei sa kode munake boka tugu vakabereria agou sa doru vavakato vavapada. ");
INSERT INTO lga_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na tinoni umuma sa sa vavuvusia sa na paranga. ");
INSERT INTO lga_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ira kaki tinoni sa qai vei ira na kiko qai vukele lao pa lodaka soana, ketakoi sa tavavuvusu na paranga. Ko tonai qai nongoria sa na paranga poni sake ruavo tugu lame teku palea i Setani sa na paranga sa tavavuvusu pa bulodi. ");
INSERT INTO lga_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ira qai vukele pa peso bubuturudi sa ira na tinoni isa tugu qai nongoria na paranga poni qaike ruavo teku ngangali qeqerania, ");
INSERT INTO lga_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","beto sa kepore na bageredi mekadi ba qai toa vakakasa tu iapeki totoso. Ba tonai qai gosoro taleni tapata beto na vaikomiti sa na paranga, poni sa qaike ruavo tugu vukeledi. ");
INSERT INTO lga_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ira kaki mule sa ira qai tavavuvusu pa vaikorapaidi na gasoro vavaioka. Pira sa ira qai nongoria na paranga, ");
INSERT INTO lga_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ba na takulangana na susuvere pa kasia gusu, na nyoroguadi na isisongo pa peso, beto na nyonyoroguadi mule kaki sakasava mule sa qai tomeria na bulodi. Ko sa amua na sakasava pira sa na paranga ko sake boka vua. ");
INSERT INTO lga_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Goto ira qai tavavuvusu pa peso jongana sa ira na tinoni qai nongoro vakoititiria beto qai teku vakatapia ira sa na paranga. Ko ira sa qai vua vuvungu: kaki uengavulu, kaki vonomongavulu, beto kaki sa kai gogoto tu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Beto pira sauniria i Jisu sira, <<Ai sa vei, na juke sa sa tapogoso tome pa ruma ko mina tavakole pa kauru kadakita babi pa kauru sape puputana? Dai! Pa ona totoqona tu sa na ona laona mina toqo sisa. ");
INSERT INTO lga_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Doru sakasava qai kole vapae sa mai bola votu, beto doru sakasava qai kole golomo sa mai votu lame pa kakaberena. ");
INSERT INTO lga_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Na tinoni sa pore talingi nonongorona sa mi vainongoro!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Beto pira sauniria, <<Mu viloto vatalea sisa qu nongoria. Isa tugu na pada qu vaiiania sa isa tugu sa na pada muna taiania agou, beto mina jolania mutugu isa sa muna tekua agou. ");
INSERT INTO lga_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ura isa sa koleona na ona sa na motana mina taia vatamonia. Goto na tinoni sa keporeona sa isa tugu iapeki sa isongia isa ba mina taragata variunia tugu sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Beto sa paranga si Jisu, <<Na binangara tana Tamasa sa sa vei puputa kai tinoni sa ipaporoniria pa peso sa na kiko, ");
INSERT INTO lga_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","beto sa puta mumagana na bongi beto sa kamua na rane poni sa dorava. Qai pidoko beto ko qai toa sa na kiko, ba isa mekana ba sake gigilai sa ai qai vei beto qai toa sira na kiko pira. ");
INSERT INTO lga_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na peso gu mekana sa vatoaia sa na umuma ko qai vua: momoe sa votu lame na equruna, beto qai lavata sa na talingidi, beto qai mamatua sa na talingidi na vuiti. ");
INSERT INTO lga_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ko tonai qai matua sa na vuvua poni sa sa garunuria isa sira na tinoni ababu ko qai lao ababu, ura sa kamua gu sa na totoso ababu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Beto sa paranga si Jisu, <<Na sa tana vavapadania gita sa na binangara tana Tamasa? Babi ai vavakato vavapada veveina sa tana vavakato vakaberenia gita sisa? ");
INSERT INTO lga_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sa vei gu kai kiko masitadi sisa. Sa ikete jolania doru kiko pa kasia gusu sa na kiko isa, ");
INSERT INTO lga_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ba tonai sa tauma pa peso poni sa toa sae ko sa lavata jolaniria sira doru umuma. Ko sa kakae lalavata ko ira na manugu qai tatava kamu ko qai roiti dia alale na vovori pa kaedi sa ongongu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Soku vavakato vavapada vevei pira sa sa vavakatoniria i Jisu tonai sa kole ule vaniria na paranga. Ko sa vavakatoniria sa isa vei qai boka nongoro vakaberia ira. ");
INSERT INTO lga_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Doru ona vaivagigalai sa sa vakoleria pa vavakato vavapada sisa tonai sa vavakato tadira doru. Totonai tu sa suvere tavitiria mekana sira na ona sepele sa sa ule vakakabere vaniria sa doru kai sa. ");
INSERT INTO lga_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ego totonai sa gore na veveluna na rane isa, sa i Jisu sa parangaria sira nona sepele, pira sauniria, <<Aria ko ta karovo lao pa kai karovona na ovuku,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ko qai loaia sa na minete tinoni ko qai koi pa koaka sira na sepele ko qai tonia si Jisu sa tei koiona tu pa koaka. Kaki koaka ba qai korapa titidia tugu ketakoi. ");
INSERT INTO lga_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tonai qai toka karovo sa kai gava lavata sa rajaria beto sa taloloku taria na ololobagea sa na koaka ko sa pugelia na kolo. ");
INSERT INTO lga_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ba i Jisu sa tarubatunia kai tarubatu ko sa korapa putagana pa tatavana na koaka. Ko qai lao jou vadoravia sisa beto pira qarigunia, <<Tinoni vaivagigalai! Ta mate taqeu sa gita! Ai vei sake vatakulangigo ao sa vei inara?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Poni sa tatakole si Jisu ko sa tokea sa na gava beto pira saunia na kolo, <<Bule! Mu noso!>> sau. Tonai sa sa noso sa na gava beto sa bule elava sa na kolo. ");
INSERT INTO lga_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Beto pira sauniria sira na ona sepele, <<Ai sa vei ko qu matagutu tu? Oqoro pore tugu na miu rarange sagou?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Qai matagutu vivitigi sira ko qai kole vavainanasa mekadi, pira qarigu, <<Ko i sei tu sa na tinoni api ko ira tu na gava beto na kolo ba qai nongoria tugu nona paranga?>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ego ko qai lao paro sa pa kai karovona na ovuku pa Qerasini. ");
INSERT INTO lga_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ko isa tugu sa taloa pa koaka ko sa paro si Jisu, sa kai tinoni sa kolea na gagala ikerena sa votu koko lame vei pa bevi vavaigolomodi ko sa lame gosoria si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Na susuverena pa bevi vavaigolomodi sa na tinoni api, ko qai podeke piuni seni tu ba kepore tugu kai tinoni bi boka piu vakolea. ");
INSERT INTO lga_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Soku totoso qai tei pikoni seni tu na nenena na limana ba sa rabutu papaleniria sira na seni pira beto sa piara paleria sira na aeana pa nenena. Kepore kai tinoni bi neqi jolania ko bi boka tale vamomosia. ");
INSERT INTO lga_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na rane na bongi sa sa kole gu biulai lao lame pa bevi vavaigolomodi beto pa kukubo ko sa kole gu lukana uui beto sa kole vapapaleka mulenia na papatu. ");
INSERT INTO lga_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ko sa batia pa souna tu isa si Jisu, poni sa abutu totoai lao opo toqo sori tutungu pa moena isa. ");
INSERT INTO lga_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ko sa vevela votu, pira sau, <<Na sa na mua ginugua taqu ara sao Jisu na Tuna na Tamasa Ululuna Jola? Pipaqu tana Tamasa, ao munake vakilasasiu ara sao!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ura perangaina tu qi tei poja veinia tu pira i Jisu sisa, <<Gagala ikeremu, mu votu riu tana tinoni api sao!>> tei qiunia tu. ");
INSERT INTO lga_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ko sa nanasia i Jisu sisa, <<I sei na isongomu sao?>> saunia. Poni sa paranga sisa, pira sau, <<I Joatina sa na isongoqu ara, ura na joa sagei,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ko sa tepa totoka vivitigia isa si Jisu ko mike iju votuniria pa gugusu isa sira na gagala ikikeredi sau. ");
INSERT INTO lga_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ego qai korapa nyunyubele gaganigadia pa kai kalena na kubo ketakoi sa kai godo borogo. ");
INSERT INTO lga_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ko qai tepa totoka vivitigia ira na gagala ikikeredi si Jisu, pira qarigunia, <<Mu garunu laonigei tadira na borogo pori, ko me lao tomeria ira,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Poni sa vamalumuria isa sira, ko qai votu taloa tana tinoni sa na gagala ikeredi ko qai lao tomeria sa na borogo. Ko na godo borogo doruna, na anyedi karu tina, sa qai tulai gore sa na taba mamavarana ko qai gore kuju mate betodia pa leo kolo. ");
INSERT INTO lga_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ko ira na tinoni qai kopuniria na borogo pira sa qai uku riudia ko qai lao vavakatonia pa gugusu beto pa vailivutaina ketakoi. Ko qai lame sira na tinoni ko mai dogoria sa na sakasava sa pidoko qarigu. ");
INSERT INTO lga_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tonai qai lame kamu tai Jisu sira, sa qai batia ira sa na tinoni perangaina qai tomea mai na joa tina gagala ikeredi. Ba kopira sa tei popoko vataleona tu beto sa tei tavagigalana tu ko sa korapa toqona sa na tinoni isa. Ko qai matagutu sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ira qai somana batia isa qai vei na godo borogo beto na tinoni sa tomea na gagala ikeredi api sa qai vavavakato vaniria sira na goto tinoni. ");
INSERT INTO lga_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ko ira na tinoni qai tepa totokai si Jisu ko mi iolo votu pa dia gugusu qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ego ko totonai mi koi pa koaka sau si Jisu, poni sa sa lame ko sa tepa totoka tai Jisu sa na tinoni qai koni loai na gagala ikeredi api ko mi tutiaona i Jisu sau. ");
INSERT INTO lga_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ba i Jisu sake vamalumia, goto pira tu saunia, <<Dai, mu mule lao pa mua gugusu tadira na turamu ko mu ule vaniria sa na roiti poreveveina sa roiti vanigo na Bangara beto na veveina na vairoqu vaitokai sa vadogoronigo,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ko sa taloa riu sisa ko sa podalai vevelania gu pa doru gugusu pa ia pa Manogagusu isa sa na roiti sa roitiniria i Jisu tana ko qai gabara beto sira doru tinoni. ");
INSERT INTO lga_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ego tonai sa karovo ligu lao pa kai kalena na ovuku si Jisu, poni sa kai minete tinoni lavata sa qai lame vaiamunia sisa pa poanana pa ovuku. ");
INSERT INTO lga_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pa totoso tugu isa sa lame sa kai tinoni mamata pa ruma vavaikamuna, na isongona i Jaerasi. Tonai sa batia isa si Jisu, sa lao gona toqonia pa nenena isa, ");
INSERT INTO lga_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ko sa tepa totokai isa sisa, pira saunia, <<Na tuqu rereko sa sa korapa ala lao vei pa mate. Mu lame vaoponia na limamu, ko mu alo mulenia nona toa!>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Poni sa tutia isa si Jisu. Ego kai minete tinoni lavata sa qai tutia isa ko qai jupe vaikalenia sisa. ");
INSERT INTO lga_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sa korapa tugu pa vaikamu tinoni ketakoi sa kai rereko sa kole variu orungu laona gu pa korapana manogarua aoro. ");
INSERT INTO lga_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na rereko api sa tei dori kole gosoria tu soku tapata pa kopu tadira na tinoni vaisalana beto doru kai ona isisongo sa gona paleniria pa kole nyaqo solata, ba sake isongo jonga podeke tu goto tonai sa sa viva tu lalaona sa na tapata tana. ");
INSERT INTO lga_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tonai sa nongoronia na rereko api sa na veveina i Jisu, sa sa tuti ligu pa leo vaikamu tinoni sisa ko sa ulia sa na poko tai Jisu. ");
INSERT INTO lga_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ura pira qi kole roroqu golomo vei pa bulona sisa, <<Vei mana ulia gu ara sa na poko tana, sa kode mana tasalanaqua gu sara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ko isa tugu sa ulia isa sa na poko tai Jisu, sa totonai tugu sa nosona sa na orungu, beto sa vagigilai pa tinina sa sa tei tasalana tu sisa pa nona mo sau. ");
INSERT INTO lga_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pa totoso tugu isa sa vagigilai mekana i Jisu sa na neqi sa votu riu pa tinina. Ko sa balinga mulea sa na vaikamu tinoni ko sa nanasaria, pira sau, <<I sei sa ulia na poko taqu?>> sau. ");
INSERT INTO lga_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Poni qai paranga tu sira nona sepele, pira qarigunia, <<Qu batiamua ao sa na rave tinoni qai jupe vavaiamunigo, ba ai sa vei ko qu nanasa tu, <I sei sa ulisiu?> qugu tu,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ba sa kole tugu doro vailivutai i Jisu ko mi batia sa na rereko sa ulia isa sau. ");
INSERT INTO lga_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Sa vagigilai na rereko api sa na salana sa gore votu pa tinina ko sa matagutu neneqere, ko sa lao gona toqonia pa moena i Jisu ko sa ulenia gu isa sa na vavakato doruna. ");
INSERT INTO lga_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Poni sa pira saunia i Jisu sisa, <<Tuqu, na mua rarange sa tei salanigo tu. Mu lao pa bule beto mu tasalanamua tu pa mua tapata,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Totonai sa korapa paranga si Jisu, sa qai bobola kamu gu sira kaki tinoni na koko lame veidi pa ruma tai Jaerasi na tinoni mamata pa ruma vavaikamuna, ko pira qarigunia si Jaerasi, <<Na tumu rereko sa kopira sa tei mate tu. Kita vapavu lame goboria na tinoni vaivagigalai,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ba i Jisu sake pavu nongoria sa na paranga qai pojai ira, goto tonai sa pira saunia gu sa na tinoni mamata pa ruma vavaikamuna, <<Muke matagutu, mu vasosoto gu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ego ko kepore sa kai tinoni sa vamalumu tutia isa, goto mekadi gu ira Pita, i Jekopi beto ko i Jone na tasina gu i Jekopi. ");
INSERT INTO lga_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tonai qai lame kamu pa ruma tana tinoni mamata pa ruma vavaikamuna, sa sa batia i Jisu sa na rura takulangadi ira na tinoni qai roroma beto qai lukana kekebo. ");
INSERT INTO lga_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ko sa tome sisa ko pira sauniria, <<Ai sa vei ko qu rura takulanga beto qu korapa kekebo roroma tu sagou? Na koburu ina sa sake mate, goto sa korapa putagana gu,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tonai sa paranga vei isa poni sa qai avavunia ira na tinoni sisa. Ego ko sa iju vavoturia i Jisu sira doru, goto na tinana gu beto na tamana na koburu beto ira kue ona sepele gu sa sa toni tomeniria ketakoi sa kole na koburu. ");
INSERT INTO lga_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Beto sa arua i Jisu sa na limana na koburu beto pira saunia, <<Talita, kumi,>> sau (Na ginuana sa, <<Ngore, qa parangigo ara sao, mu tatakole!>> sau). ");
INSERT INTO lga_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pa totoso tugu isa sa tatakole sa na rereko ikete api ko sa reregeona, ura sa tei manogarua aorona tu sa na rereko isa. Ko qai gabara vivitiginiria sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ba sa naqu vaneneqiria i Jisu sira ko maike vavakatonia tana kai tinoni sa isa vei sa taroiti alepi sau. Beto sa garunuria ko mai vania kaki sava sa na koburu rereko ko mi tetekuona sauniria. ");
INSERT INTO lga_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ego i Jisu sa taloa pa gugusu isa ko sa lao pa gugusu ketakoi sa lavata sae ko ira na ona sepele qai tutia lao sisa. ");
INSERT INTO lga_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Totonai sa kamua na rane Minere, poni sa podalai vaivagigalai pa ruma vavaikamuna sisa. Ko ira doru qai nongoria isa sa qai gabara vivitigi, ko pira qarigu, <<Pai koko veidi sa na roroqu pira? Na gigalai sa sa isongia sa na tinoni api? Ko na roiti vaivagabaradi tu ba sa roiti votuniria! ");
INSERT INTO lga_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na kamada gu sapi! Ko na tuna gu i Mere beto ko na tugadi gu ira Jekopi, Josesi, Jiudasi beto i Saimone sapi! Na luluna rereko ba qai korapa gu inara!>> qarigu sira. Ko qaike tavaraguania ira si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Poni pira sauniria i Jisu sira, <<Na tinoni kokorotai sa doru eqa sa tapangaga gu, goto pa ona gugusu ketakoi sa lavata sae gu ko tadira na turana beto pa ona tatamana gu mekana sa sake tapangaga,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ko sake boka roitiniria ketakoi isa sira na roiti vaivagabaradi, goto ira kaki tinoni qai mo gu sa vaoponiria na limana ko sa salanaria. ");
INSERT INTO lga_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ko sa gabarania i Jisu sa veveina sa keporeniria na vinasosoto ira. Ego sa lekogoria i Jisu sira na gugusu pa vailivutaina ketakoi ko sa kole vaivagigalai. ");
INSERT INTO lga_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Beto sa kuku vaikamuniria isa sira ka manogarua ona sepele ko sa okoto pikata varuaria pa kai reregena, sa vaniria na neqi ijudi ira na gagala ikeredi, beto sa garunu variuria. ");
INSERT INTO lga_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ko sa pojaniria tugu ko maike pogosia kai sa pa dia rerege lao, goto na dia opata gu. Maike pogoso besa, na mane, beto na poata ininamane sauniria. ");
INSERT INTO lga_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mai vasaeria gu na dia sadolo, goto maike vasae tamoi poko sauniria. ");
INSERT INTO lga_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Beto pira sauniria, <<Tonai muna tavakamu pa kai ruma, sa muna suvere gu ketakoi tinganai muna taloa riu pa ia isa sagou. ");
INSERT INTO lga_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ira kaki gugusu bai daidia vakamugou beto bai daidia nongorogou, sa mu turu loa pale sa na gugusu isa beto mu tavusu paleria sira na kavuru peso pa nenemiu. Ko isa sa na vinagigilana kode mai tavakilasa sira,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ko qai taloa riu taraenia sa ira na tinoni mai gabala loiria na dia sela qariguniria, ");
INSERT INTO lga_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","qai iju vovotu paleniria soku tomate ikikeredi, beto qai oraniria na oela sira na soku tinoni qai mo ko qai salanaria. ");
INSERT INTO lga_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ego sa nongoroniria i Herodi na bangara sira doru sakasava vei sa roitiniria i Jisu, ura na isongona isa sa sa tagigila doru gugusu. Ko ira kaki tinoni ba pira qai paparanga vei, <<I Jone Paputaiso sa sa tei turu mule tu qarigu. Ko sa soni vei sa qai roiti tana sira na roiti vaivagabaradi,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ba ira kaki sa aipira tu qai paranga vei, <<I Elaija sapi!>> qarigu. Beto kaki goto sa pira tu qarigu, <<Kai tinoni kokorotai sapi, kai veveina ira na tinoni kokorotai pa moa sina!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ko tonai sa nongoria inara qai paranga vei sira, sa sa paranga si Herodi, pira sau, <<Isa tugu i Jone Paputaiso qa tei kujukia tu ara sa sa turu mule!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ura i Jone sa perangaina tu i Herodi tugu mekana qi garununi tinoni ko qai piu vatomea pa ruma vaipiu. Na ginuana sa tapiunia i Jone sa na veveina gu i Herodiasi. I Herodiasi sa na maqotana tu i Pilipi isa na tasina gu mekana i Herodi, ba qi alavia tu nona i Herodi si Herodiasi. ");
INSERT INTO lga_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ko i Jone tugu qi kole manoga popojania si Herodi, pira qiunia, <<Nake tavamalumuna pana Vavanau sa vei ao qu suvere tavitia na maqotana na tasimu,>> qiunia. ");
INSERT INTO lga_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ko i Herodiasi qi puku vakolenia pa bulona sa api ko qi nyogua vamatea si Jone, ba qike boka. ");
INSERT INTO lga_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ura i Herodi ba qi matagutunia si Jone ura qi gigilaiona sa i Jone sa kai tinoni tuvisina beto na liosona sisa ko sa vei sa qi kopu vasarenia sisa. Ko tonai qi nongoria sa na paranga ti Jone sa qi rura tugu, ba qi kole nongoro qeqerania tugu sisa. ");
INSERT INTO lga_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ego tonai qi kamu sa na rane podo ti Herodi sa sa qi tekua na totoso jongana si Herodiasi. Qi roitinia i Herodi sa kai vavolo rane podo beto qi soruria sira na iviva lalavata pa qavuna, ira na kutadi ira na tinoni vaipera, beto ira na ivivadi ira na bubutu tinoni pa Qalili ko qai lao somana teteku. ");
INSERT INTO lga_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ko pa vaikamu isa qi tome lao pepeka sa na tuna rereko i Herodiasi, ko qi vaqerai si Herodi beto ira na tinoni qi soruria. Ko qi paranga lao tana koburu rereko sa na bangara, pira qiu, <<Mu tepanisiu isa qu nyoguania. Ara mana vanigo sa na mua nyorogua,>> qiunia. ");
INSERT INTO lga_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Beto qi maulu lao tana rereko, pira qiu, <<Ai tu sakasava veveina sa muna tepai ao, ba kode mana vanigo gu. Bi na kobuna na qua binangara bugu tu sao, ba jongana gu!>> qiu sisa. ");
INSERT INTO lga_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Poni qi votu lao nanasia na tinana sa na rereko api, pira qiunia, <<Na sa sa mana tepai ara,>> qiunia. Poni qi oe lao sa na tinana, pira qiu, <<Na batuna i Jone Paputaiso, mugunia,>> qiu. ");
INSERT INTO lga_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Poni qi sisiqarai mule lao tana bangara sisa ko pira qiu, <<Qa nyoguania ko mu petania pa peleita sa na batuna i Jone Paputaiso beto mu pogoso lame vanisiu kopira tugu,>> qiunia. ");
INSERT INTO lga_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Qi takulanga vivitigi tugu na bulona sa na bangara, ba qi tei maulu tu pa moedi ira na iviva lavata sisa ko qike boka dainiaona sa na tepa tana rereko. ");
INSERT INTO lga_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ko pa totoso tugu isa qi garunia i Herodi sa kai tinoni kopu tadira na solodia ko mi pogoso lamenia sa na batuna i Jone qiunia. Ko qi lao sa na tinoni isa ko qi kujukia pa ruma vaipiu si Jone, ");
INSERT INTO lga_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","beto qi petania pa peleita ko qi pogoso lame vania sa na rereko. Ko na rereko api qi tekua ko qi pogoso laonia tana tinana. ");
INSERT INTO lga_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Totonai qai nongoro sira na sepele ti Jone sa qai kamu pogosia ira sa na kokobu tinina i Jone Paputaiso ko qai lao golomia pa kai bevi vavaigolomona. ");
INSERT INTO lga_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ego qai mule vaikamu tai Jisu sira ka manogarua tinoni tagarunudi, ko qai vavakato vania isa sira doru sakasava vei qai roitiniria beto qai vaivagigalainiria. ");
INSERT INTO lga_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Poni sa pira sauniria i Jisu sira, <<Mei, aria ko ta lao pa kai ia kaloina mekada, ko agou ba mu minere mai,>> sauniria. Ura qai soku jola sira na tinoni qai kamu vaibei, ko i Jisu beto ira nona sepele ba qaike boka teku totoso ko bai tetekudia. ");
INSERT INTO lga_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ko qai koi pa kai koaka ko qai lao kai ia kaloina mekadi. ");
INSERT INTO lga_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ba ira na kubo tinoni sa qai doro gigalariadia sira tonai qai toka. Ko qai abutu poana sira na tinoni na lame veidi pa doru okoto gugugusu ko qai lao vakujeleria ko qai vera momoedia pa ia ketakoi mai korapa lao paro qarigu ira Jisu beto ira na ona sepele. ");
INSERT INTO lga_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tonai sa jorotongana pa poanana si Jisu, sa sa batia sa na minete lavata ko sa roroqu vivitigiria, ura qai vei puputa na sipi kepore na dia sepati. Ko sa podalai vaivagigalainiria soku sakasava i Jisu sira. ");
INSERT INTO lga_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ego ko tonai sa gore na vevelu sa qai lame tana sira na ona sepele ko pira qarigu, <<Na ia kaloina sa lani, beto ko sa tei gore tu sa na vevelu. ");
INSERT INTO lga_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ko mu garunuria ira na tinoni pira ko mai lao pa gugusu vailivutaidi inara ko mai vaigadia gagani mekadi,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ba sa oe laoria i Jisu sira, pira sau, <<Dai. Agou tu mu vaniria na tetekuna sira pira,>> sau. Poni qai paranga sira na sepele, <<Ai vei qu nyoguania ko me lao vaini gagani karu gogoto poata siliva beto me iaria ko mai teteku qugu?>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Poni sa sa nanasaria tu i Jisu sira, pira sau, <<Ka visa batu bereti qu pogosoria? Mu lao moko dororia,>> sauniria. Ko tonai qai batia sa pira qarigu, <<Ka lima batu bereti, beto karu igana,>> qarigunia sisa. ");
INSERT INTO lga_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Poni sa pojaniria i Jisu sira doru ko qai pipikata pa okoto pukuna beto sa qai toqo pa buburu. ");
INSERT INTO lga_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ko qai toqo vavaitivi pa okoto dia puku tinoni, kaki pupuku tinoni sa kai gogoto, kaki limangavulu. ");
INSERT INTO lga_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Beto poni sa tekua i Jisu sa ka lima batu bereti beto karu igana ko sa enga sae pa noka, sa mananiria, beto sa kikiparia sa na bereti beto sa vaniria ira nona sepele ko qai iaria sira na tinoni. Beto sa kikiparia mule sa karu igana beto sa qai iaria mutugu sira doru. ");
INSERT INTO lga_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ko ira doru sa qai teteku beto qai pote beto. ");
INSERT INTO lga_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Beto sa qai aru vavaikamuniria sira na kikipa bereti beto na igana qai kole joladi, ko qai vapugeleniria sa ka manogarua totopa. ");
INSERT INTO lga_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ko na anye vaikamudi ira doru tinoni qai teteku sira ka lima tina marene. ");
INSERT INTO lga_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ego sa pojaniria i Jisu sira nona sepele ko mai koi pa koaka ko mai toka lao momoe pa Betiseda pa kai karovona na ovuku sauniria, goto isa sa suvere jola ko sa doro variuria mai tu sira na minete tinoni. ");
INSERT INTO lga_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ko pa liguna sa loloa variuria ira poni sa sagere sae pa kai kukubo sisa ko sa vavara. ");
INSERT INTO lga_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ko totonai sa gore na vevelu sa na koaka sa tei lao tu pa kokorapa kolo, goto isa mekana sa korapa pa peso tu. ");
INSERT INTO lga_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ko sa gele laoniria sa qai korapa vaimategadia na qelu sira nona sepele, ura sa raja koimoa sa na gava. Ko papada vaikorapaina kue ko vonomo koloko vuvugei jonga sa sa rerege pa vuliti kolo ko sa lao kamuria sisa. Ko mi alokata jolaniria sau. ");
INSERT INTO lga_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ba totonai qai batia sisa sa korapa rerege pa vuliti kolo, sa palu na tomate qarigu sira ko qai lukana uui tu. ");
INSERT INTO lga_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ira doru sa qai bati betoadia ko qai matagutu neneqere beto. Ba pa totoso tugu isa sa paranga laoria isa sira, pira sauniria, <<Mu varene! Ara gu sapi, muke matagutu!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Beto sa totonai sa koi lao pa koaka sisa, sa sa bule betona sa na gava. Ko qai gabara vivitigi sira na sepele. ");
INSERT INTO lga_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ura qaike doro vakaberia ira sa na ginuana ka lima batu bereti sa vaivatetekunia i Jisu ura sa oqoro revanga na dia roroqu. ");
INSERT INTO lga_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ego tonai qai karovia ira sa na kolo sa qai lame paro pa ia pa Qenesareti, ko qai vatitia ketakoi sa na dia koaka. ");
INSERT INTO lga_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Isa tugu qai tete paro sira, sa qaike ruavo tugu doro gigalia ira na tinoni ketakoi si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ko qai abuturia ira sira na ruruma tadira na tinoni qai suvere ketakoi beto ko qai okoto pogoso kamu tavitiniria tugu na dia lovu sira na tinoni qai mo. Ketakoi qai nongoronia pa sanu sa korapa i Jisu qarigu poni sa qai vaipogoso lao beto vei tugu ketakoi. ");
INSERT INTO lga_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ko pa doruna ia ketakoi sa rijo lao vei i Jisu, bi pa gugusu ikikete babi pa gugusu lalavata, sa qai pogoso kamuniria tugu pa ia mamaketina ketakoi sira na tinoni momoodi beto qai tepa totokai ira si Jisu ko mai ulia gu na uquna nona poko ba jongana gu qarigu. Ko ira doru tinoni moodi qai ulia na uquna nona poko sa qai tasalanadia tugu. ");
INSERT INTO lga_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ego ira na Parese beto ira kaki qai vaivagigalainia na Vavanau na koko veidi pa Jerusalema sa qai vaikamu lame ti Jisu. ");
INSERT INTO lga_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Qai batiria sira kaki sepele tana qai tetekunia na limadi nake liosodi ura qaike loloqa lima vei qai vaivagigalainia ira na Parese qarigu. ");
INSERT INTO lga_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ura ira na Parese beto ira doru tinoni Jiu sa qai kopuniria sira na uana tututidia tadira na dia tite ko qaike teteku sira tonai qai oqoro loqa lima. ");
INSERT INTO lga_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Beto tonai mai mule pa maketi sa mai ogono valioso mai tu beto sa mai teteku. Beto kubo mule sira na tuti pa dia uana vavalioso vevei pa nyanyanyapa valioso kapa, na raro, na nonobudi, sa qai kopuniria tugu. ");
INSERT INTO lga_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ko ira na Parese beto ira qai vaivagigalainia na Vavanau sa qai nanasia si Jisu, pira qarigunia, <<Ai sa vei ko qaike tutia tu ira na sepele tamu sira na uana tututidi tadira na oda tite, goto qai tetekunia gu ira sa na limadi nake liosodi?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Poni sa oe laoria i Jisu sira, pira sau, <<Sa sotona gu si Aisea tonai sa ululenia sa na veveimiu agou na tinoni vavabata sesekemiu. Pira sa na paranga sa kutiria isa, <Ira na tinoni pira sa qai vatarasaenisiu na beberudi gu, ba na bulodi sa sou vivitigi taqu. ");
INSERT INTO lga_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na goborodi gu sira dia vinatarasaequ ara, qai vaivagigalainiria na vaivagigalaidi na vinaturu tadira na tinoni gu,> sau. ");
INSERT INTO lga_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Qu loa palenia agou sa na garunu tana Tamasa, ko qu kopu vatataleniria sira na uana tututidi tadira na tinoni gu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Beto pira sauniria, <<Qu gigalai jola sagou! Ko qu vakeporea ginuana agou sa na garunu tana Tamasa ko qu vaturu vaneqiria sira na miu uana tututidi mekamiu! ");
INSERT INTO lga_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pira sau si Mosese, <Mu pangaganiria ira na tinamiu beto na tamamiu, beto, na tinoni mina paranga vapirunia na tinana babi na tamana, sa mina tavamate tugu sisa,> sau. ");
INSERT INTO lga_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ba agou qu pojai tu sa vei kai tinoni pira biuniria ira na tinana na tamana, <Na sakasava ba boka tokanigou agou karu sa sa kobani,> biu (na ginuana na paranga api sa nona vaivana madina na Tamasa), ");
INSERT INTO lga_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","poni sa quke vamalumia sisa ko bi tokaniria sira karu tinana beto na tamana qai vaivasevi. ");
INSERT INTO lga_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ko pa soana vei inara sa qu vakepore veveinai agou sa na paranga tana Tamasa tonai qu tutia agou sa na miu uana tututidi qu teku isongoria. Ko kubo uana tututi vevei pira sa qu roitiniria agou,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ego sa kuku vaikamu liguniria mule i Jisu sira na minete tinoni ko pira sauniria, <<Mu vainongoro lame sagou doru, ko mu vakaberia sapi. ");
INSERT INTO lga_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kepore sa kai sava sa teku tomenia pa tinina na tinoni mina boka vapajia sisa. Goto isa tu sa koko votu lame vei tana tinoni sa sa vapajia sa na tinoni isa. ");
INSERT INTO lga_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Na tinoni sa pore talingi nonongorona sa mi vainongoro,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ego ko tonai sa loaria sira na minete tinoni ko sa lao tome pa ruma sisa, poni sa qai nanasania ira nona sepele sa na veveina na vavakato vavapada api. ");
INSERT INTO lga_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Poni sa paranga laoria isa sira, pira sau, <<Ko agou ba quke vagogovea tugu sa? Quke vakoinonoa tu agou sa? Kepore kai sava sa teku ponyolia na tinoni sa sa vapajia nona toa. ");
INSERT INTO lga_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ura sake tome pa bulona na tinoni sisa goto pa borina gu, beto sa vavotu riu pale gu,>> sau si Jisu. (Ko tonai sa paranga vei inara si Jisu sa sa vakaberia isa sa doru gagani sa qai liosodi beto.) ");
INSERT INTO lga_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Beto pira sau si Jisu, <<Isa tu sa koko votu lame vei tana tinoni sa sa vapajia sisa. ");
INSERT INTO lga_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ura pa leo bulona tu na tinoni qai koko votu lame vei sa na roroqu ikikeredi, na roroiti valulasa, na ikiko, na varivai, ");
INSERT INTO lga_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","na babarata, na muino, na roiti ikikeredi, na nyonyorava, na uana pajidi, na kokono, na vamoroana tinoni, na vatarasae mule, beto na uana duduvilidi. ");
INSERT INTO lga_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Doru sakasava ikikeredi pira sa qai votu lame vei pa leo bulona na tinoni ko qai vapajia sa na tinoni isa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ego sa taloa pa gugusu isa si Jisu ko sa lao pa gugusu pa Turosi. Ko tonai sa kamu ketakoi sisa, sa sa lao tome pa kai ruma ura sake nyoguania ko bai gigilai ira na tinoni sa na suverena isa ketakoi sau. Ba sake jonga ovo sisa. ");
INSERT INTO lga_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Koleona pa gugusu ketakoi sa kai iviva rereko sa kolea na gagala ikerena sa na tuna rereko. Ko isa tugu sa nongoronia si Jisu poni sa sa lame gona toqonia pa nenena isa, ");
INSERT INTO lga_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","sa tepai si Jisu ko mi iju pale na tomate ikikerena sa kole tana tuna rereko sau. Ego na iviva rereko api sa na tinoni karovona tu, ko na podona keta pa kale Poinikia tu pa gugusu pa Siria. ");
INSERT INTO lga_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Poni sa oe laoa i Jisu sa na rereko api, pira saunia, <<Momoe sa ira na koburu mai tu sa mai teteku, ura sake jonga sa bai tateku sira na gagani tadira na koburu ko bai tagona lao vaniria na sie,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ba sa oe lao tu sa na rereko, pira sau, <<Bangara, ira na sie pa kauru tevolo ba qai memeagadia gu sa pa vuvusu gagani qai vavukeleria ira na koburu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Poni sa pira saunia i Jisu sisa, <<Ego vei muna oe vei inana sao, sa jongana mu mule laomua pa mua ruma ropi. Na tomate ikikerena sa sa tei taloa tu tana tumu rereko,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ko tonai sa mule lao pa nona ruma sisa, sa sa batia na tuna rereko sa tei loai tu na tomate ikikerena ko sa korapa koleona pa ona lovu sisa. ");
INSERT INTO lga_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ego sa taloa pa gugusu pa Turosi si Jisu ko sa rerege vei pa gugusu pa Sidoni, beto sa gore vei pa Manogagusu ko sa lao pa ovuku pa Qalili. ");
INSERT INTO lga_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ko tonai sa qai toni kamunia ira kaki tinoni sa kai tinoni kikiqilina beto na popokana sake boka paranga vatale, ko qai tepa totokai si Jisu ko mi vaoponia na limana qarigu. ");
INSERT INTO lga_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Poni sa varijoa pa vaikamu tinoni ko sa toni kalenia mekana i Jisu sa na tinoni api, beto sa totunia pa leona karu talingina na tinoni api sa na kakarusuna, beto sa odolo taria na kakarusuna beto sa totunia pa meana na tinoni api. ");
INSERT INTO lga_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Beto sa enga sae pa noka, sa vagorea kai vasaenga lavata, beto pira saunia sisa, <<Epata!>> (na ginuana na paranga api sa <<Mu revanga tu!>> sau). ");
INSERT INTO lga_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pana totoso tugu isa sa tavonga sa na talingina na tinoni isa, beto na meana sa puku tari sa sa taruvata, ko sa paranga vataleona. ");
INSERT INTO lga_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Beto sa naquria i Jisu sira na tinoni ko maike vavavakatonia sa na roiti api sauniria. Ba tonai sa naquria i Jisu poni sa tonai sa qai gigiri tugu vavaqatania ira na tinoni sa na veveina isa. ");
INSERT INTO lga_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ko qai gabara vivitigi beto sira doru, ko pira qarigu, <<Doru sakasava sa sa roiti vajonga betoria sa na tinoni api. Ko ira tu na kiqili ba sa vanonongororia beto ira na poka ba sa vaparangaria,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ego kai totoso mule totonai sa sa vaikamu lame sa kai minete tinoni, ko kepore vavagila kai sa bai tekua. Ko sa kuku tekuria i Jisu sira na sepele ko pira sauniria, ");
INSERT INTO lga_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<Qa roroqu vitigiria ara sira na minete tinoni pira, ura tei kue ranedi tu qai suvere tavitisiu ko kopira kepore kai sa mai tekua. ");
INSERT INTO lga_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Vei mana garunu variu buburanaria ara pa dia gugugusu, sa kode mai tabubulo pa soana sa pira. Ko ira kaki pira na dia gugusu ba sa sou jola,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Poni qai oe laoa ira nona sepele sisa, pira qarigu, <<Ura pa qega vei pira sa pai mule tana boka teku gagani sa gita beto tana boka vatetekuria sira na tinoni pira?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Poni sa nanasaria i Jisu sira, pira sau, <<Ka visa bereti qu pogosoria agou?>> sau. Poni qai paranga sira, <<Ka vitu gu!>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Poni sa pojaniria sira na minete tinoni ko qai toqo pa peso. Beto sa tekuria sa ka vitu batu bereti, ko sa paranga jonganania, sa kikiparia, beto sa vaniria ira nona sepele ko mai ianiria na tinoni sau. Poni qai roiti vei tugu sira na sepele. ");
INSERT INTO lga_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ka visa igana mutugu sa qai pogosoria, ko isa sa mananiria, beto sa pojaniria mutugu ko qai ianiria sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Qai teteku ko qai pote beto sira doru tinoni. Beto sa qai aru vavaikamuniria sa doru kikipa kole joladi ko ka vitu totopa tu sa qai kukura vapugeleniria. ");
INSERT INTO lga_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ko na anyedi ira sa sa papada vei ka made tina marene. Pa liguna isa sa vamule riuria i Jisu sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Beto pa totoso tugu isa sa taloa sisa ko sa lao koi tavitiria sira nona sepele pa koaka ko qai toka lao vei pa eqa pa Dalamanuta. ");
INSERT INTO lga_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ego qai lame tai Jisu sa ira na Parese ko qai podalai vaigua lao tana sira. Qai tepai ko mi roitinia isa sa kai roiti vinagigila vaivagabarana koko lagere veina pa noka qarigu. Ko qai vei ko mai podekia qarigu. ");
INSERT INTO lga_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Poni sa vagorea kai vasaenga lavata si Jisu beto pira sauniria, <<Ai sa vei ko qu tepai tu na roiti vinagigila vaivagabaradi sagou na sasae tinoni kopira? Ma poja sosotonigou ara sagou: kepore sa kai vinagigila vinasosoto mina taroiti vaniria sira na sasae tinoni pira!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Beto sa turu loa paleria isa sira ko sa koi ligu pa koaka ko sa karovo laona pa kai kale ovuku. ");
INSERT INTO lga_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ego qai roqu mumania ko qaike pogoso vasoku bereti sira na sepele, goto kai memekana gu sa qai surania pa koaka. ");
INSERT INTO lga_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ko sa pojaniria i Jisu sira, pira sauniria, <<Mu suvere kopu! Mu balauniria sa na vavakovuruni palava tadira na Parese beto ti Herodi,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Qai kole vavaivavakato mekadi sira na sepele, pira qarigu, <<Sa kepore gada bereti sa sa poja veinigita inara isa,>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ba sa tei gigilaiona tu i Jisu sa isa qai kole pojai ira, ko pira sauniria, <<Ai sa vei ko qu korapa tu vavaivavakatonia sa kepore gamiu bereti qugu? Quke vakoinonoa beto quke vagogovea tu agou sa? Sa oqoro tu revanga sa na bulomiu? ");
INSERT INTO lga_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Na beko koleona na matamiu, ba quke boka babata tu sa? Beko pore talingimiu tu, ba qu oqoro tu tavonga? Quke roqu vakoititia tu agou sa na veveina ");
INSERT INTO lga_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","totonai qa kikiparia ara ka lima bereti ko qa ianiria ira ka lima tina tinoni? Ka visa sa na topa qu vapugeleniria na kikipa kole joladi?>> sauniria. Poni sa qai paranga sira, <<Ka manogarua,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Poni sa paranga i Jisu, <<Goto tonai qa kikiparia ka vitu bereti ko qa ianiria ka made tina tinoni ara, sa ka visa topa sa qu vapugeleniria na kikipa kole joladi?>> sauniria. Poni sa qai oe lao tu sira, <<Ka vitu,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","<<Ba ai sa vei? Qu korapa oqoro tu vagogovea agou sa?>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ego qai lame kamu pa Betiseda sira Jisu beto ira nona sepele. Ko ketakoi sa qai toni lamenia ira na tinoni sa kai tinoni leleqana, beto qai tepa vivitigia ko mi vaoponia na limana qarigu. ");
INSERT INTO lga_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Poni sa aru tekua i Jisu sa na limana na tinoni leleqana ko sa toni votunia pa peguruna na gusu. Ketakoi tu sa lao odolo taria isa sa na matana beto sa sa vaoponia na limana beto sa nanasia, pira saunia, <<Ai vei, qu batia tu kaki sakasava?>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Poni sa enga sa na tinoni api, beto paranga, <<Qa batiria sira na tinoni, ba qai vei gu na gou qai korapa rereregedia,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Beto sa sa vaopo beinia mule na limana i Jisu sa karu matana na tinoni api. Poni sa sa doro dodola beto sa jonga liguona sa na ona dodoro, ko sa doro vakakabere betoria sa doru sakasava. ");
INSERT INTO lga_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Beto sa garunu variua pa ona gugusu i Jisu sisa, pira saunia, <<Muneke lao gasa votu pa gugusu pa Betiseda,>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ego sa taloa riu si Jisu beto ira nona sepele ko qai lao vei pa gugugusu pa Sizaria Pilipae. Tonai qai korapa rerege lao pa soana sa sa nanasaria i Jisu sira nona sepele, pira sau, <<I sei qarigunisiu ara sira na tinoni?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Poni sa pira qarigu sira, <<I Jone Paputaiso sao qarigu sira kaki. Goto kaki sa i Elaija sao qarigu. Goto ira kaki mutu sa kame ira na tinoni kokorotai pa moa sao qarigunigo,>> qarigu sira na sepele. ");
INSERT INTO lga_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Beto sa sa nanasaria mule isa sira, <<Goto agou i sei qugunisiu sara?>> sauniria. Poni sa oe lao tana si Pita, pira sau, <<Ao sa na Karisito,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Beto sa naquria i Jisu sira ko maike vavakatonia tana kai goto tinoni sa na veveina isa sauniria. ");
INSERT INTO lga_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ego ko sa podalai vaivagigalainia tadira i Jisu sa na veveina na Tuna na Tinoni mina gosororia soku vitigi beto mai kilu palenia ira na iviva mamata, na kuta iama beto ira qai vaivagigalainia na Vavanau ko mina tavamate sisa, ba pa liguna kue rane sa mina turu mule pa mate sisa sau. ");
INSERT INTO lga_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ko sa poja lolodakia i Jisu tadira sa sa vei isa. Poni sa teku kalenia i Pita si Jisu ko sa podalai tokea. ");
INSERT INTO lga_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Poni sa balinga si Jisu ko sa dororia sira nona sepele beto sa tokea si Pita, pira saunia, <<Mu lao pa liguqu Setani! Ao quke korapa roroqua na sakasa tana Tamasa sao, goto tana tinoni gu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Beto sa kuku vaikamuniria i Jisu sira na minete tinoni beto ira nona sepele ko pira sauniria, <<Na tinoni sa nyorogua tutisiu ara sa mi roqu muma palenia nona toa mekana, beto mi pogosia na ona korosi ko mi tutisiu ara. ");
INSERT INTO lga_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ura na tinoni sa nyorogua kopu vasarenia nona toa mekana sa kode mina saivia tugu sa nona toa. Goto na tinoni sake rabekia na ona toa pa tutiqu ara beto pa vavakatona na nongoro jongana taqu sa mina aloa sa nona toa. ");
INSERT INTO lga_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Na sa sa mina boka vagavoria na tinoni vei bi gona pale isa sa na ona toa ko bi isongia na kasia gusu doruna? Bi julingai tu! ");
INSERT INTO lga_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ko na sa sa mina roitinia isa ko mina boka alo mulenia sa nona toa? Bi mija tu! ");
INSERT INTO lga_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Na tinoni sa keanisiu ara beto na qua paranga pa sasae tinoni ikikerena beto na selana api, poni sa na Tuna na Tinoni ba mina keania tugu sisa tonai mina lame tavitiria ira na mateana tabuna pa neqi lavata tana Tamasa na Tamana sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Beto pira sauniria i Jisu sira, <<Ma poja sosotonigou ara sagou: kaki agou qai korapa turu pira sa maike tei mate tu tinganai mai batia na binangara tana Tamasa mina lame tavitia na neqi,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ego sa jola ka vonomo rane, sa sa tekuria i Jisu sira Pita i Jekopi beto i Jone ko sa toni saeniria pa kai kubo ululuna ko qai suvere mekadi ketakoi. Ko pa moedi ira ketakoi sa bei sa na tinina i Jisu. ");
INSERT INTO lga_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na ona poko sa keka kikilanga jolaniria doru sakasava qai vakeka veiniria ira na tinoni pa peso. ");
INSERT INTO lga_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Beto qai bola votu kamuria sira Elaija i Mosese ko qai kole paparangia si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ko totonai sa paranga lao ti Jisu si Pita, pira saunia, <<Rabi, sa jongana jola sa qe korapa lani sagei! Ko me roitinia tu ropi kue aqaqo, kame tamu, kame ti Mosese, beto kame tai Elaija, uve?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ura qai matagutu vivitigi sira kue ko sake gigilai na sa sa pojai si Pita. ");
INSERT INTO lga_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Beto sa bola amuria kai lei beto totonai qai nongoria sa kai ovovele koko veina pa korapa lei, pira sau, <<Api sa na Tuqu, isa qa roroqu vivitigia ara. Mu nongoria sisa!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Poni qai siboro sira ko qai doro vailivutai ba kepore mule sa kai tinoni bai batia, goto mekana gu i Jisu sa korapa suvere tavitiria. ");
INSERT INTO lga_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ko tonai qai loai na kubo ko qai korapa oqa votu gogoredia, sa sa naquria i Jisu sira kue sepele ko maike vavakatonia sisa vei qai batia, tinganai mina turu mule mai tu pa mate sa na Tuna na Tinoni sauniria. ");
INSERT INTO lga_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ko qai kopu kole kopunia gu mekadi ira sa api, ba qai kole vaigua mekadi sa na sa beka na ginuana sa na turu mule pa mate saunia isa qarigu. ");
INSERT INTO lga_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Beto qai nanasia sisa, pira qarigu, <<Ai sa vei ko qai pojai ira qai vaivagigalainia na Vavanau sa i Elaija mai tu sa mina lame momoe?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Poni sa oe laoria i Jisu sira, pira sauniria, <<Sosoto tugu i Elaija sa mina lame momoe tu ko mina vatana vatuvisi liguria sira doru sakasava. Ba ai sa vei ko sa pojai tu na Kukuti Tabuna sa mina gosororia soku vitigi beto mina tadogoro vakepore sa na Tuna na Tinoni? ");
INSERT INTO lga_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ba ara ma pojanigou, sa tei lame tu si Elaija, ba qai tutini dia roroqu vei qai nyoroguania ira sisa, vei tugu sa tei pojai tu na Kukuti Tabuna,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ego tonai qai mule gore kamuria sira nona sepele sira Jisu beto ira kue sepele sa toniria, sa qai batia sa kai minete tinoni lavata korapa suvere ketakoi beto ira qai vaivagigalainia na Vavanau sa qai korapa vaigua lao tadira na sepele. ");
INSERT INTO lga_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Isa tugu qai batia i Jisu sira doru tinoni, sa qai gabara beto qai abutu lao gogoso qeqerania sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Beto sa sa nanasaria i Jisu sira na ona sepele, pira sau, <<Na sa sa qu kole vaiguania agou tadira?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Poni sa paranga sa kai tinoni pa vaikamu tinoni isa, pira sau, <<Tinoni vaivagigalai, na tuqu marene ara sa qa toni lamenia tamu, ura sa kolea na gagala ikikerena ko sake boka paranga. ");
INSERT INTO lga_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pai tu mina korapa sisa ba tonai mina vakamunia poni sa irunia tu pa peso ko sa dadao tu na mangana, sa garata beto sa totogeoso betona na tinina. Ko qa teparia ara sira na mua sepele ko mai iju votu palenia sa na gagala ikikerena qauniria, ba qaike bokai tu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Poni sa oe laoria i Jisu sira, pira sau, <<Agou na sasae tinoni kopira sa kepore sosoto na miu rarange! Ai tu koi vei sovaina vei sa mana kole suvere tavitigou ara sagou! Ai tu koi vei sovaina vei sa mana kole junonigou ara sagou? Mu toni lamenia taqu sa na koburu isa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ko qai toni laonia tana sa na koburu marene isa. Ko isa tugu sa doro lao sa na gagala ikerena api ko sa batia si Jisu, poni sa sasuria sa na koburu marene, ko sa vavukelia ko sa titolo bobokilai tu pa peso, beto sa dadao tu na mangana. ");
INSERT INTO lga_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Beto sa nanasia i Jisu sa na tamana na koburu, pira sau, <<Ai totoso sa sa podalai veinia isa inara?>> sau. Poni sa oe lao sa na tamana, <<Sa podalainia na melaluna tu. ");
INSERT INTO lga_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ko kubo totoso sa gona laonia tu pa niku beto pa kolo ko mi vamatea sau. Ko vei bu boka ao poni sa mu roroqugei ko mu tokanigei,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Poni sa oe lao si Jisu, pira sau, <<Vei bu boka qugu tu ao! Doru sakasava sa sa bokai gu na tinoni sa vasosoto,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Isa tugu sau i Jisu poni sa sa vevela votu sa na tamana na koburu api, pira sau, <<Qa vasosoto sara, mu tokanisiu ketakoi sake neqi na qua vinasosoto!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ego ko tonai sa batiria i Jisu qai abutu vaikamu lame sira na minete tinoni, sa sa tokea isa sa na gagala ikikerena, pira saunia, <<Ao na gagala kikiqilimu na popokamu qa parangigo ara sao ko mu votu riu tana koburu marene api beto ko muneke kamu kole ligua,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Poni sa kuku uui sa na gagala ikerena ko sa raja vaneneqeria sa na koburu marene api beto sa sa votu taloa tana. Ko sa doro vei na tinoni matena sa na koburu marene api. Ko ira soku tinoni sa qai paranga vei pira, <<Koi, sa tei mate tu sina,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ba sa arua i Jisu sa na limana na koburu ko sa bako vatatakolea poni sa turuona sa na koburu. ");
INSERT INTO lga_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ego ko totonai sa tome pa leo ruma si Jisu, sa qai mavo nanasa golomia ira nona sepele sisa, pira qarigunia, <<Ai sa vei ko qeke boka tu iju palea agei sa na gagala ikikerena?>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Poni sa oe lao si Jisu, pira sau, <<Na sakasava vevei ina sa sake taroiti goboro goto pa vavara gu beto sa boka votu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ego ko sa taloa ketakoi si Jisu beto ira na ona sepele ko qai jola vei tu pa Qalili, ura sake nyoroguania i Jisu sa bai gigilai ira na tinoni sa ketakoi sa suvere isa sau. ");
INSERT INTO lga_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ko sa kole vagigalairia isa sira nona sepele, pira sauniria, <<Na Tuna na Tinoni sa kode mina tavalao pa limadi ira na tinoni ko mai vamatea, ba pa liguna kue rane mina tavamate sa kode mina turu mule sisa,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Qai rurania ira sa na ginuana na paranga api, ba qai pangagadia ko qaike tuma nanasia ira sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ego tonai qai kamu pa Kepaniami ko qai tome pa ruma poni sa sa nanasaria i Jisu sira na ona sepele, pira sau, <<Na sa sa qu kole vaiperani paranga agou pa soana lamena?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ba qai okoto ke vagala beto sira, ura pa soana lamena sa qai kole vaiperani paranga ira sa na veveina: <<I sei sa na poreveveina jola?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Poni sa toqo ko sa kuku vaikamuniria i Jisu sira ka manogarua ona sepele beto pira sauniria, <<Na tinoni sa nyogua tavaululu sa mi kole vakaurai tadira doru ko mi nabuluniria sira doru,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Beto sa aru vakatapia isa sa kai koburu ikete ko sa vaturua pa moedi ira doru, beto sa sa aru vakatapia beto pira sauniria, ");
INSERT INTO lga_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<Na tinoni sa vakamu vatalea pa isongoqu ara sa kai koburu ikete vevei api, sa sa vakamu vatalesiu tugu sara. Ko isa na tinoni sa vakamu vatalesiu ara, sa nake ara gu mekaqu sa sa vakamusiu na tinoni isa, goto isa tugu vei sa garunusiu ara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ego sa paranga lao tana si Jone, pira sau, <<Tinoni vaivagigalai, qe batia agei sa kai tinoni sa ijiju pale tomate ikikeredi pa isongomu ao ko qe vanosoa, ura nake somanana tadagita sisa,>> sau si Jone. ");
INSERT INTO lga_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ba sa paranga si Jisu, <<Muke vanosoa! Ura kepore kai tinoni sa roitinia kai roiti vaivagabarana pa isongoqu ara mina boka poja vivikeresiu sara pa liguna. ");
INSERT INTO lga_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ura na tinoni sake kanagita sa sa kole vei tadagita sisa. ");
INSERT INTO lga_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ma poja sosotonigou ara sagou: na tinoni sa vanigou kai kapa pie pa isongoqu ara ura sa gigilai isa sa agou na tinoni tana Karisito, poni na tinoni isa sa mina tekua tugu sa na ona pinia,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","<<Na tinoni sa vatatupea ko bi varoitinia na sela sa kai koburu ikete sa rangesiu ara sa sa jongana jola sa bi pilunia kai patu doa lavata na ruana ko bi lupi pale pa kolo. ");
INSERT INTO lga_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Beto vei bi vatatupego ko bi varoitinigo na sela sa kai kale limamu, sa mu lomoto vaqopu pale! Ura sa jongana jola sa na qoqopumu ao ba bu tekua sa na toa jola. Isa sa sa jongana jolania vei bu isongo betoria karu limamu ko bai tagona lao beto pa heli na iku sa ilili kare. ");
INSERT INTO lga_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Beto vei bi vatatupego ko bi varoitinigo na sela sa kai kale nenemu sa mu lomoto vaqopu pale gu! Ura sa jongana jola sa na qoqopumu ao ba bu tekua sa na toa jola. Isa sa sa jongana jolania vei bu isongo betoria karu kale nenemu ko bai tagona lao beto pa heli. ");
INSERT INTO lga_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Beto vei bi vatatupego ko bi varoitinigo na sela sa kai kale matamu, sa mu ujolo pale gu! Ura sa jongana jola sa bi kai matamu gu bu tome pa binangara tana Tamasa. Isa sa jongana jolania vei bu isongo betoria sa karu matamu ko bai tagona lao beto pa heli, ");
INSERT INTO lga_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ketakoi qai kole na uloso qaike boka mate beto ko na iku vuvurunguna sake boka tailili vamate. ");
INSERT INTO lga_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ura doru tinoni sa mai tavaliaburu pa iku, kai muqisi podeke vei na vavakukuvu sa tavalioso pa solo. ");
INSERT INTO lga_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na jongana sa na solo. Ba vei mina maragutu sa na lilingina, sa ai mule muna roiti vei beto muna boka valilingi beia? Mu isongia na solo pa miu toa ko mu mekarai suvere vaibaere vatale,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ego sa taloa ketakoi si Jisu ko sa gore vei pa gugugusu pa Jiudia beto pa kai kalena pa pie Jodani. Ko na minete tinoni mule sa qai vavaikamu lame tana ko isa sa vagigalairia vei tugu sa tei manoga roroitinia tu doru totoso. ");
INSERT INTO lga_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ego ko ira kaki Parese sa qai nyogua vagonai si Jisu ko qai lame nanasia, pira qarigunia, <<Ai vei, na tavamalumuna tugu pana Vavanau sa na iviva marene sa mina boka loa pale sa na maqotana?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Poni sa oe laoria i Jisu sira, pira sauniria, <<Na sa sa garununigou i Mosese agou?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Poni sa pira qarigu, <<I Mosese sa sa vamalumia sa na iviva marene mina boka kutia kai pepa vailoa beto mina boka variu pale sa na maqotana sau,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ba sa parangaria i Jisu sira, pira sau, <<Ura koko vei tu sa duduvili na roqumiu agou vei sa sa kuti vanigou i Mosese sa na garunu isa. ");
INSERT INTO lga_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Goto pa popodalaina na vinapodaka sa na Tamasa sa sa roiti vamarenia beto sa varerekoa sa na tinoni. ");
INSERT INTO lga_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ko sa vei isa sa na marene sa mina loaria ira na tamana beto na tinana, ko mina kole kame tana maqotana. ");
INSERT INTO lga_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ko ira karu sa mai kame tinoni gu. Ko qaike pikatarua goto kame gu sira karu. ");
INSERT INTO lga_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ko isa sa tei vaipuku tariniria tu na Tamasa, sa na tinoni mike vaipikatainiria,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ko tonai qai mule pa ruma sa qai nanasania ira na sepele sa na ginugua api. ");
INSERT INTO lga_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Poni sa parangaria i Jisu sira, <<Na marene sa loa pale na maqotana ko sa alava ligua kai rereko gotona mule sa sa babarata tugu sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ko na rereko ba vei bi loa pale na marenena ko bi alava beia kai goto marene mule sa sa babarata mutugu sa na rereko isa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ego qai toni kamuniria ira kaki tinoni tai Jisu sira na koburu ko mi vaoponiria na limana isa qarigu, ba qai vatokeniria ira na sepele sira. ");
INSERT INTO lga_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Totonai sa batiria i Jisu qai roiti vei inara sa sa tagigiri ko pira sauniria sira, <<Mu loa valameria taqu ira na koburu. Muke suquturia, ura tadira tugu veveidi pira sa na binangara tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ma poja sosotonigou ara sagou: na tinoni sake vei kai koburu ikete pa tekuna na binangara tana Tamasa, sa minake tome lao tugu sisa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Beto sa aru vakataparia isa sira na koburu ko sa vaoponiria na limana ko sa mananiria. ");
INSERT INTO lga_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ego tonai sa taloa riu ko sa korapa lalaona pa soana si Jisu, sa sa abutu lame toqo sori tutunguna pa moena i Jisu sa kai tinoni, ko sa nanasa, pira sau, <<Tinoni vaivagigalai jongamu, na sa sa mana roitinia ara beto mana teku isongia ara na toa jola?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Poni sa pira saunia i Jisu sisa, <<Ai sa vei ko qu gigalanisiu tu na jongaqu ara sao? Kepore sa kame bi jongana, goto mekana gu na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Qu gigilariamua ao sira na garunu: <Muke varivai, muke babarata, muke ikiko, muke jutu seseke, muke teku isongo pa seseke, mu pangaganiria na tinamu na tamamu,> qarigu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Poni sa pira sau sa na tinoni api, <<Tinoni vaivagigalai, doru garunu vevei ira sa toto vei na iketequ tu qa podalai tutiria ara sira,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tonai sa doria beto sa roroqua i Jisu sisa, ko pira saunia, <<Kai sakasava gu sa oqoro okotonigo ao. Mu lao ko mu vavainiria sira doru sakasava qu isongoria, ko mu ianiria ira na tinoni golabadi ko mi pore mua isisongo pa noka. Beto sa mu lame tutisiu sara,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tonai sa paranga vei inara i Jisu poni sa titigore sisa, beto sa tabekele ko sa pogoso riunia isa sa na bulo takulangana, ura na tinoni isisongo vivitigi sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Beto sa doro vailivutai i Jisu beto pira sauniria sira nona sepele, <<Sa tapata vivitigi ko mai tomea ira na tinoni isisongo sa na binangara tana Tamasa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Poni qai gabarania ira na ona sepele sa na paranga tana. Ba sa paranga bei laoria mule i Jisu sira, <<Boko tuqu, sa tapata jola na tomena sa na binangara tana Tamasa! ");
INSERT INTO lga_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Na manugu tapatana jola sa na kameli mina sulingi tomea na lubogona na nila, ba sa tapata jolania mutu isa sa na tinoni isisongo mina tomea sa na binangara tana Tamasa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ko tonai sa qai gabara vivitigi sira na sepele ko qai okoto vavainanasa lao lame, pira qarigu, <<Ko mina vei sa i sei gu sa mina taalo?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Poni sa doro laoria i Jisu sira beto sa pira sau, <<Tana tinoni sa tapata jola sapi, ba tana Tamasa sake tapata. Ura kepore kai sakasava sa tapatia na Tamasa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Beto sa paranga si Pita, pira sau, <<Dogoro! Agei sa qe tei loa vakole paleria tu sa doru sakasava ko qe korapa tutigomei ao,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Poni sa paranga si Jisu, pira sau, <<Ma poja sosotonigou ara sagou: na tinoni sa loaria na ona ruma, na luluna marene na luluna rereko, na tamana na tinana, na tuna babi na kobu peso, pa ginuaqu ara beto na nongoro jongana, ");
INSERT INTO lga_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","sa isa sa mina tamo vasoku vania na Tamasa kopira. Ko kode mina isongoria soku gogoto jola ruruma, beto mina soku gogoto luluna marene na luluna rereko, na tinana, na tuna, na peso, beto mina tangangangulu tugu vei sisa. Beto pa totoso sa korapa lame sa mina isongia na toa jola sa na tinoni isa. ");
INSERT INTO lga_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ko ira soku qai momoe sa mai liligu, beto ira soku qai liligu sa mai momoe,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ego sa tonia i Jisu beto ko ira na ona sepele sa na soana saena pa Jerusalema ko i Jisu sa momoeniria. Ira na sepele qai gabara vivitiginia sisa beto ko ira na tinoni qai tuti liguria ba qai matagutudia tugu. Ko sa toni kaleniria mule i Jisu sira ka manogarua sepele ko sa podalai pojaniria sira na sakasava mina gosororia isa ketakoi, ");
INSERT INTO lga_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","pira sau, <<Mu vainongoro. Taqe korapa rerege sae pa Jerusalema sa gita. Ketakoi na Tuna na Tinoni sa kode mina tavalao pa limadi ira na kuta iama beto ira qai vaivagigalainia na Vavanau. Kode mina tajutu ko mina tavamate beto kode mai valaoa tadira na tinoni karovodi sisa ");
INSERT INTO lga_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ko mai vavaledenia, mai tue taria beto mai piqolia ko mai vaivamatea sisa, beto mina jola gu kue rane sa mina turu mule sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ego qai lame ti Jisu sira Jekopi beto ko i Jone karu tuna marene i Zebeti, ko pira qarigu, <<Tinoni vaivagigalai, qe nyoroguania ko na manugu be tepanigo agei karu sa bu roiti vanigei ao qeu,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Poni pira sau si Jisu, <<Na sa sa qu nyoroguania agou karu ko ba roiti vanigou ara qugunia?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Poni qai oe lao sira karu, pira qarigu, <<Dai, mu vamalumugei gu ko tonai muna toqoa ao sa na mua totoqona bangara pa mua binangara lavata, sa kame agei karu mi toqo keta pa kale matuamu goto kame keta pa kale merimu qeu,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Poni pira sauniria Jisu sira karu, <<Quke gigilai agou karu sa na manugu qu korapa tepai. Ai vei, muna boka tomeria tu agou karu sa na vitigi mana gosororia ara? Muna boka tapaputaisonia agou karu sa na paputaiso vitigi veveina mana gosororia ara?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Poni pira qarigu sira karu, <<E, mene boka gu,>> qarigu. Poni pira sauniria i Jisu sira karu, <<E, na vitigi mana tomeria ara sa muna gosororia tugu agou karu, beto ko muna tapaputaisonia gu agou karu sa isa mana tapaputaisonia ara. ");
INSERT INTO lga_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ba nake ara mana vilea sa i sei sa mina toqo pa kale matuaqu beto pa kale meriqu. Goto na Tamasa tu mina vaniria ira sa tei vatana vaniria tu sa karu totoqodi pira,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ego tonai qai nongoria ira ka manogaputa sepele sa sa vei inara, sa qai tagigiri vivikereniria sira Jekopi i Jone. ");
INSERT INTO lga_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Poni sa kuku vaikamuniria i Jisu sira na ona sepele, ko pira sauniria, <<Qu gigilaimiu agou sa ira qai tadogoro vei na bangaradi ira na tinoni karovodi sa qai lalae betoniria gu sa na toa tadira na dia tinoni, beto ira na tinoni sa koleria na neqi sa qai kole kuta uananiria sira na tinoni pa kauraidi. ");
INSERT INTO lga_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ba agou sa munake roiti vei inara. Goto na tinoni sa nyoroguania ko mina tinoni poreveveina sa mina kole nabulu betonigou tu sagou doru. ");
INSERT INTO lga_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Beto agou sa na tinoni sa nyogua momoenigou sa isa sa mi pinausu tamugou doru tu sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ura na Tuna na Tinoni sa sake lame ko mi poreona nabulu sau, goto sa nabulu tugu beto sa vania tu na ona toa ko sa pajuku aloria sira na kubo tinoni,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ego qai gore kamu pa Jeriko sira. Ko tonai mi taloa pa Jeriko sau si Jisu beto ira na ona sepele beto ko na minete lavata, sa kai tinoni leleqana na isongona i Batimiasi, na tuna marene i Timiasi, sa sa korapa toqo tetepa poata pa kekete soana. ");
INSERT INTO lga_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ko totonai sa nongoronia isa si Jisu pa Nazareti sa sa korapa rerege jola qarigu sa sa podalai kuku votu, pira sau, <<Jisu na Tuna i Devita! Mu roroqu tokanisiu!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Poni ira soku tinoni qai tokea ko mi nogoto qarigunia. Ba totonai sa sa vaiolo saea mutu sa na ona kukuku, pira sau, <<Jisu na Tuna i Devita! Mu roroqu tokanisiu,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Poni sa turu vanogoto si Jisu ko pira sau, <<Mu kuku valamea,>> sau. Ko qai kukua sa na tinoni leleqana api, pira qarigunia, <<Mu varene! Mu turu! Isa sa korapa kukugo,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Poni sa teku vagore palea sa na poko sa udenia, sa gasa turu ko sa lame tai Jisu. ");
INSERT INTO lga_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Poni sa paranga laoa i Jisu sisa, pira sau, <<Na sa sa qu nyoguania ao ko mana tokanigo ara?>> saunia. Poni sa pira sau sa na tinoni leleqana api, <<Rabi, ara qa nyoguania ko ba babata ligu qau,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Poni sa pira saunia i Jisu sisa, <<Mu lao, na mua rarange sa sa tei salanigo tu sao,>> saunia. Pa totoso tugu isa sa dodogoro ligu sisa ko sa somana tutiaona i Jisu sisa. ");
INSERT INTO lga_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Totonai qai tata pa Jerusalema sira ko qai kamu pa Betipezi beto pa Betani pa Kubo pa Olive, sa sa garunu lao momoeniria i Jisu sira karu ona sepele, ");
INSERT INTO lga_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","pira sauniria, <<Mu lao pa gusu kai karovona pa moemiu poni. Ko isa tugu muna bola lao sa kode muna batia sa kai dongiki na tapiko vaturu kolena isa oqoro koia tugu kai tinoni. Mu ruvatia sisa ko muna toni lamenia. ");
INSERT INTO lga_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Vei mai nanasagou kaki tinoni, <Ai sa vei qu korapa roiti vei ina?> marigunigou, sa pira muna oe veiniria, <Na Bangara sa nyoguania mai beto nake sovaina mina vamule lamea sau,> munaguniria,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ego ko qai taloa lao sira karu ko qai batia sa na dongiki koregana na tapiko vaturu kolena pa peguru na atakamana pa kekete soana, ko qai lao ruvatia. ");
INSERT INTO lga_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Poni sa qai paranga sira kaki tinoni qai suvere tata ketakoi, pira qarigu, <<Na sa qu korapa roitinia? Ai sa vei ko qu korapa ruvatia na dongiki ina?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Poni sa qai pojai ira karu sa isa vei sa poja veiniria i Jisu. Poni sa qai vamalumu vaniria. ");
INSERT INTO lga_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ko qai toni vakamunia tai Jisu, ko qai lovasa vamakelenia na poko sa na pokotona na dongiki, beto sa koi si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ira kubo tinoni sa qai lovasaria pa soana sa na dia poko, goto ira kaki qai kaele teku eqequru gogou ko qai lovasaniria pa soana. ");
INSERT INTO lga_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ko ira na tinoni qai rerege momoe lao beto qai tuti pa liligu sa qai kukuku, <<Aroia! Sa tamana sisa sa lame pa isongona na Bangara! ");
INSERT INTO lga_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Sa tamana sa na binangara tana tamada i Devita. Aroia pa nulu vavagalo,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ego ko sa kamu pa Jerusalema sisa ko sa lao tome pa kakabarena zelepade. Ko sa kole dogoro vailivutainiria isa sira doru sakasava ketakoi, ba sa tei gore tu sa na vevelu ko sa votu laona pa Betani sisa beto ira ka manogarua sepele. ");
INSERT INTO lga_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ego ko sa rane neqa ko qai taloa koko lame vei pa Betani, sa vaia na burana si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tonai tu sa korapa lalameona pa soana sa sa batia sa kai gou piqi sa mota jola na equruna, ko sa lao doria palu koleona na vuana sau. Ba tonai sa lao kamua sa kepore sa kai vuana bi batia goto na gagale equruna gu ura sa oqoro kamua na ona totoso vua. ");
INSERT INTO lga_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Poni pira saunia i Jisu sa na gou piqi isa, <<Kepore tugu kai tinoni mi gania na vuamu sao!>> saunia sisa. Ko qai nongoriadia tugu ira na ona sepele sa na parangana i Jisu. ");
INSERT INTO lga_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ego tonai qai kamu pa Jerusalema poni sa tome lao pa kakabarena zelepade si Jisu ko sa podalai adu vovotuniria sira qai korapa vavai beto ira qai vavainiria na sakasava pa kakabarena zelepade, beto sa peluku vaopo paleria sira na tevolo tadira qai bebei poata karovodi beto ira na totoqodi tadira na tinoni qai kole vavainiria na kuru vavakukuvudi, ");
INSERT INTO lga_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","beto sa suquturia ko kepore kame bi pogoso vaikarovainia kai sai pa karu uquna na kakabarena zelepade. ");
INSERT INTO lga_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Beto sa kole vaivagigalai, pira sauniria, <<Quke gigilai tu agou sa isa vei sa takuti pa Kukuti Tabuna? <Na ruma taqu sa mina tavaisongo na ruma vavarana tadira doru puku tinoni,> sau! Ba agou qu roiti veinia tu na bevi ovovona tadira na tinoni raja ikikodi,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ko tonai qai nongoronia ira na kuta iama beto ira qai vaivagigalainia na Vavanau sa sa vei inara i Jisu, sa qai podalai nyanyaqo soana ko mai vamatea sisa qarigu. Ba qai matagutunia sisa, ura doruna na tinoni sa qai gabarania sa na ona vaivagigalai. ");
INSERT INTO lga_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ego totonai sa gore na vevelu poni sa sa votu lao pa peguruna na gugusu si Jisu beto ira na ona sepele. ");
INSERT INTO lga_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ego totonai qai rerege jola na vuvugeina sa qai batia ira sa na gou piqi sa tei malei mate tu, sa podalai tu pa batuna ko sa gore tu kamu pa bagerena. ");
INSERT INTO lga_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Poni sa roroqu kamua i Pita sa na veveina na gou piqi api ko pira saunia si Jisu, <<Rabi, doro! Na gou piqi qu levenia ao sa sa tei mateona tu!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Poni sa paranga laoria i Jisu sira, pira sauniria, <<Mu rangea na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ma poja sosotonigou ara sagou: na tinoni sa paranga laoa sa na kubo api, <Mu tajopu ko mu gona laonigo mekamu pa ivere,> sau, beto sake ruarabeke pa bulona goto sa vasosotoa gu sa isa vei sa pojai sa mina gore votu tugu sau sisa, poni sa kode mina gore votu vei tugu sa pojai isa. ");
INSERT INTO lga_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ko sa vei isa sa ma pojanigou: doru sakasava qu vavara ko qu tepai, sa mu vasosoto sa qu tei tekua tu, beto sa kode muna isongia ao sisa. ");
INSERT INTO lga_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ko totonai muna turu vavara sa mu taleosonia sa na sela qu puku tutinia na goto tinoni, ko na Tamamiu pa noka ba mi taleosonigou na miu sela sagou,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ego sa kamu bei mule pa Jerusalema si Jisu beto ira nona sepele. Ko totonai sa korapa rerege pa kakabarena zelepade si Jisu, sa qai vaikamu lao tana sira na kuta iama beto ira qai vaivagigalainia na Vavanau beto ira na iviva mamata. ");
INSERT INTO lga_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ko qai nananasia sisa, pira qarigu, <<Ai neqi veveina sa qu isongia ao ko qu roitiniria na roiti veveidi inara? I sei sa sa vanigo na neqi ko qu roitiniria sa pira?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Poni pira sauniria i Jisu sira, <<Ego ara ba ma nanasanigou mai kai nanasa ropi sagou. Ko vei muna oesiu agou sa kode mana ule vanigou ara sa pa neqi tai sei qa roitiniria ara sira na roiti aipira. ");
INSERT INTO lga_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pai sa koko lame vei sa na neqi sa isongia i Jone ko sa paputaiso? Sa lame vei tana Tamasa pa noka, ba na koko lame veina tadira na tinoni gu? Mu oesiu moko,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Poni qai kole vaigua mekadi, pira qarigu, <<Vei tana Tamasa pa noka tanagu gita poni sa kode pira minagu, <Ba ai sa vei ko quke vasosotoa tu agou si Jone,> kode minagunigita. ");
INSERT INTO lga_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Goto vei tana paranga sa gita <Na lame veina tadira na tinoni gu,> tanagu, sa sa vaivamatagutu sa,>> qarigu. (Qai matagutuniria ira sira na tinoni, ura doru tinoni sa qai rovea si Jone sosoto sa kai tinoni kokorotai qarigu). ");
INSERT INTO lga_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ko pira gu qai oe veinia si Jisu, <<Dai, qeke gigilai agei sa!>> qarigu. Poni pira sauniria i Jisu sira, <<Ego, ko vei sa ara ba maneke ule vanigou tugu sa pai qa teku neqi beto qa roitiniria ara sira na sakasava pira,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ego sa podalai vavakato pa vavakato vavapada tadira si Jisu, pira sau, <<Koleona sa kai tinoni sa roitinia kai inuma qurepi beto sa bara vailivutainia. Sa ruri kori vaoqili valolua isa sa kai patu ketakoi mina tamuja teku sa na kolona na qurepi, beto sa vaturua isa sa kai ruma gegelena ketakoi mina takopu sa na inuma qurepi. Beto sa loa valao vaniria ira kaki tinoni roiti ko qai roiti sa pa inuma isa ko qai kopunia, beto sa taloa riu pa kai gugusu souna sisa. ");
INSERT INTO lga_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ego totonai sa kamua sa na totoso lolokete poni sa sa garunu vamulea na tinoni poreona inuma api sa kai ona pinausu ko mi lao tadira na tinoni kopu ko mi teku vania sa na iana tonai mai lolokete sau. ");
INSERT INTO lga_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ba qai lao tu ira na tinoni kopu ketakoi ko qai aru tamania sa na pinausu isa ko qai maja vivitigi pale beto qai iju vamule gagale palea. ");
INSERT INTO lga_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Poni sa garunu laonia mule na tinoni poreona inuma api sa kai goto pinausu. Ba qai lao mutugu ira na tinoni kopu ko qai maja vapapalekai sa na batuna beto qai vakea vivikere pale. ");
INSERT INTO lga_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ba sa kai garunu laonia mutugu sa kai goto pinausu mule, ba tonai sa qai vamate sosotoa sisa. Ko na motadi sira sa garunu laoniria, ba inara tugu qai veiniria, kaki qai piqoloria goto kaki qai vamateria. ");
INSERT INTO lga_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ego kai memekana gu sa sa kole jola, isa tugu na tuna sa roroqu vivitigia. Ko liligu bebeto, sa sa garunu laonia isa tadira qai kopu inuma sa na tuna api ura pira sa roroqu vei sisa, <Na tuqu sosoto gu ara sapi, ko kode isa mai pangagania,> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ba totonai sa ira na tinoni kopu inuma sa pira qai vaiparanga vei, <Isa kode mina isongo vakarovoria na isisongo tana tamana sapi! Mei, lame! Aria ko ta vai vamate pale sisa, ko na isisongo tana tamana sa tana teku vakarovoria noda gita!> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ko qai aru tamania ko qai vamate pale, beto qai gona votu pale pa peguruna na inuma sa na kokobu tinina isa. ");
INSERT INTO lga_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ko inara sa vei poni sa na sa mina roitinia sa na bangara poreona inuma api? Kode pira gu mina roiti vei sisa: mina kamu sisa, ko mina vai vamate beto paleria sira na tinoni kopu inuma beto sa mina vakarovo lao vaniria mule ira kaki goto tinoni kopu sa na ona inuma qurepi api. ");
INSERT INTO lga_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ai vei qu oqoro tugu tiro vakakaberia agou sa isa sa tapoja pa Kukuti Tabuna? Pira sau sisa, <Isa tugu na patu qai kilu pale ira na tino vavaturu ruma, isa tugu sa na kuta patu viviso. ");
INSERT INTO lga_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na roiti tana Bangara sapi ko sa vaivagabara jola pa oda dodogoro!> sau>>, sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ko qai gigilai ira na boko iviva lalavata sa na vavakato vavapada api sa sa juturia gu ira qarigu, ko qai nyaqoni soana ko mai aru tamania qarigu. Ba qai matagutunia ira sa na minete tinoni ko qai loai si Jisu ko qai riudia gu. ");
INSERT INTO lga_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ego ira kaki Parese beto ira qai sosoria i Herodi sa qai tagarunu lao tai Jisu ko mai vagonai pa kaki paranga sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ko qai lame tana sira ko pira qarigunia sisa, <<Tinoni vaivagigalai, qe gigilaimei agei sa qu sotomua gu sao, beto kepore sa kai tinoni qu matagutunia ao. Beto sa kepore veveina tamu sa na tuturuna tana tinoni, goto qu vaivagigalainia gu ao sa na soana sosotona tana Tamasa. Ai vei, na tavamalumuna tugu pana Vavanau sa mina tatabara lao tana bangara Siza sa na takisi, ba dai? Ko mene tabaria tugu agei sa na mei takisi, ba meneke pavu tabaria?>> qarigu sira. ");
INSERT INTO lga_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ba sa tei bati poai tu i Jisu sa na dia seseke, ko pira sauniria, <<Ai sa vei ko qu korapa nyorogua vagonasiu ara sagou? Valamea kai poata siliva ko ma doria ko,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ko tonai qai pogoso laonia sa kame poni pira sauniria, <<I sei na isumatana beto na isongona sa pa poata api?>> sauniria. Poni sa pira qarigunia sisa, <<Na bangara Siza,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Poni sa paranga si Jisu, <<Ego mu vania na Siza sisa tana Siza, beto mu vania na Tamasa sisa tana Tamasa,>> sauniria. Ko qai gabara sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ego qai lame tai Jisu sira na Sadusisi, ira na tinoni qaike vasosotoa na turumule pa mate, ko qai nanasia, pira qarigu, ");
INSERT INTO lga_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","<<Tinoni vaivagigalai, sa kuti vakole vanigita i Mosese gita sa vei mina mate loaia kai tinoni sa na maqotana ba bi kepore na tuna, sa mina alava beia na tasina marene sa na naboko api ko mina vapore vania na tuna vuana sa na tugana sa tei mate tu. ");
INSERT INTO lga_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ko koledia sira ka vitu tamatasi marene. Na tugadi pa moa sa alavia sa kai rereko ba kepore na tuna vuana sa na marene isa beto sa sa mateona. ");
INSERT INTO lga_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ego ko sa teku alavia na tuti vinarua sa na naboko isa, ba kepore mutugu na tuna vuana beto sa mate mutugu sisa. Ko na tasidi marene vinaue ba sa vei mutugu. ");
INSERT INTO lga_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ko ira ka vitu tamatasi doru sa qai alavia sa na rereko nanaboko isa, ba kepore beto tugu na tudia vuadi. Pa liguna qai mate beto ira ka vitu doru pira, beto sa mate sa na rereko nanaboko isa. ");
INSERT INTO lga_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ego ko pa rane turumule tonai mai turu mule ira na tinoni sa kode i sei na maqotana sa na rereko api? Ura ira ka vitu doru qai alavia sisa,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Poni sa pira sauniria i Jisu sira, <<Qu sela sagou! Ura quke gigilai agou sa na Kukuti Tabuna beto na neqi tana Tamasa! ");
INSERT INTO lga_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ura tonai mai turu mule pa mate sira qai tei matedi tu, sa kode maike vaialava lao lame sira na marene na rereko, goto kode mai suvere vei gu ira na mateana pa noka sira. ");
INSERT INTO lga_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Na veveidi ira qai turu mule pa mate sa qu oqoro tu tiro vakaberia agou pa buka sa kutia i Mosese? Pana ia ketakoi sa pojai na veveina na mumuqu toana sa vuvurungu, ketakoi sa paranga ti Mosese sa na Tamasa, pira sau, <Ara sa na Tamasa ti Ebarahami, na Tamasa ti Aisake, beto na Tamasa ti Jekopi,> sau. ");
INSERT INTO lga_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ko isa sa nake Tamasa tadira na tinoni matedi, goto tadira tu na tinoni toadi. Ko qu sela sagou!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ego kai tinoni sa vavaivagigalainia na Vavanau sa lame ko sa nongororia tugu isa sira na sakasava qai vaiguania ira. Ko tonai sa dogoria isa sa sa oe vataleria i Jisu sira na Sadusisi, poni sa sa nanasia sisa, pira sau, <<Ai garunu sa sa momoe jolaniria ira doru?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Poni sa oe lao si Jisu, pira saunia, <<Na garunu sa momoe sa api, <Vainongoro, agou na tinoni Izireli! Na Bangara na oda Tamasa, na Bangara sa kai memekana. ");
INSERT INTO lga_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ko mu roroqunia na Bangara na mua Tamasa na doruna bulomu, na doruna mua toa, na doruna roqumu, beto na doruna mua neqi,> sau. ");
INSERT INTO lga_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na vinarua garunu sa api, <Mu roroqua na goto tavitimu vei qu roroqu veinigo mekamu,> sau. Kepore sa kai garunu sa poreveveina jolaniria karu garunu pira,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Tonai sa paranga lao tai Jisu sa na tinoni sa vavaivagigalainia na Vavanau isa, pira sau, <<Vavagua, tinoni vaivagigalai! Qu sotomua gu sa isa vei qu pojai kai memekana gu sa na Tamasa, ko kepore sa kame sa varuai isa. ");
INSERT INTO lga_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Beto ko na tinoni sa mina roroqunia na Tamasa na doruna bulona, na doruna nona gigalai, beto na doruna na ona neqi, beto mina roqua na goto tavitina vei sa roroqu veinia mekana. Mina tutiria na tinoni sa karu garunu pira, sa sa jongana jolania mina valaoa na ona vaivana beto na ona vavakukuvu tana Tamasa,>> sau sa na tinoni api. ");
INSERT INTO lga_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ko tonai sa nongoria i Jisu na tuvisina sa na oe tana tinoni api poni sa pira saunia, <<Ao sa quke sou pa binangara tana Tamasa,>> saunia. Ko totonai ko mi lao sa qai pangaga nanasia mule ira sisa. ");
INSERT INTO lga_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ego totonai sa kole vaivagigalai pa kakabarena na zelepade si Jisu sa pira sa paranga vei, <<Ai sa vei ko qai vavaivagigalainia tu ira qai vaivagigalainia na Vavanau sa na Karisito sa na tuna i Devita qarigu? ");
INSERT INTO lga_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","I Devita mekana sa tonia na Gagala Tabuna sa pira tu sa paranga vei, <Sa paranga sa na Tamasa tana qua Bangara: Mu toqo lani pa kale matuaqu, ko koi vei tu mana tete vakilasaria ara sira na mua kana, sau,> sau si Devita. ");
INSERT INTO lga_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mekana i Devita sa gigalania na <Bangara> tu sisa, ko ai sa vei mina boka tuna tu i Devita sa na Karisito sa sa vei?>> sau si Jisu. Ko qai qerania ira na tinoni si Jisu tonai qai kole vainongoro. ");
INSERT INTO lga_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ko pa ona vaivagigalai sa pira sa paranga vei si Jisu, <<Mu balauniria sira qai vaivagigalainia na Vavanau, qai nyorogua popoko vakakasa beto qai lelekogo ko mai gosoro qeqeraniria ira na tinoni pa ia mamaketina qarigu. ");
INSERT INTO lga_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Beto ko qai vileria na totoqona poreveveidi pa leona na ruma vavaikamuna beto na totoqona tadira na tinoni lalavata pa ivata vavolo. ");
INSERT INTO lga_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Qai raragata variuniria na dia sakasava ira na nanaboko, beto qai vavara vavakakasa ko mai tabata tadira na tinoni qarigu. Ba na vinakilasa mai tekua ira sa mina lavatana jola,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ego tonai sa korapa toqona pa moena na loloa poatana pa leo kakabarena zelepade si Jisu, sa sa doro lao sa sa batiria isa sira na minete tinoni qai okoto lao loloaria na dia poata vaivana. Ko ira kubo tinoni isisongo sa qai okoto kole lao loaria na dia baiki poata. ");
INSERT INTO lga_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Beto sa tuti lao sa kai rereko nanaboko gogolabana ko sa lao loaia sa karu poata kopa ikete momoqasana, na padana sa kai pene gu. ");
INSERT INTO lga_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pana totoso isa sa sa kuku vaikamuniria i Jisu sira nona sepele ko pira sauniria, <<Ma poja sosotonigou ara sagou: isa sa loai na nanaboko gogolabana api sa sa soku jolania isa qai loai pa loloa poatana ira doru tinoni isisongo. ");
INSERT INTO lga_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ura ira doru sa qai teku pana dia isisongo sa pugele nyonyoa qai valao, goto na nanaboko api sa pana ona qasa sa valaoa isa sa doruna, isa doruna sa isongia ko bi toania,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tonai sa korapa taloa votu pa kakabarena zelepade si Jisu, sa kame ira na ona sepele sa paranga, <<Tinoni vaivagigalai, Doro! Na beko patu babata jonga beto na vinaturu babata jonga!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Poni pira saunia i Jisu sisa, <<Qu batiria sira vinaturu lalavata pira? Kepore sosoto kai patu qai kole makele vavaitopare lani sa mina kole jola, goto doruna sa kode ira na tinoni mai qovara betoria,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ego ko tonai sa korapa toqona pa kubo pa Olive ko sa bata lao vei pa karovona na zelepade si Jisu, sa qai mavo nanasa golomia ira Pita, i Jekopi, i Jone, beto i Aduru sisa, pira qarigunia, ");
INSERT INTO lga_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","<<Mu ule vanigei! Pa visa sa mai gore votu aipira, beto na sa sa na vinagigila beto mai raja sira doru sakasava qu koni pojaria ao inara?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Poni sa paranga laoria i Jisu sira, <<Mu suvere vabalau, ko maike toni vapirugou ira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Kubo sira na tinoni kode mai lame pa isongoqu ara ko mai paranga vei pira, <Ara sa isa,> marigu, ko mai toni vapiru paleria sira na soku tinoni. ");
INSERT INTO lga_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Tonai muna nongoroniria agou sira na vaipera beto na vavakatodi na vaipera, sa muke matagutu. Kode mai pidoko lame tugu sira na sakasava pira ba sa oqoro kamua sa na vinabetona. ");
INSERT INTO lga_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kode kai puku tinoni mina turu talea kai goto puku tinoni, beto kai binangara mina turu talea kai goto binangara. Mina nunu soku eqa beto kode mina raja na songe. Na sakasava pira sa vei na popodalaina na vivitigi teku koburu. ");
INSERT INTO lga_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ko agou mu doro kopunigou mekamiu. Ura kode mai teku valaogou pa vaikamu tadira qai vavaituti beto ko mai pipiqologou pa ruma vavaikamuna. Beto kode muna turu pa moedi ira na qavuna beto ko ira na babangara pa veveina na isongoqu ara, ko muna ule vaniria sa na veveina na nongoro jongana. ");
INSERT INTO lga_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ko momoe na nongoro jongana sa mina tatarae mai tu tadira doru puku tinoni. ");
INSERT INTO lga_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ko tonai mai toni laonigou pa ia vavaitutina sagou, sa munake takulangania na sa mene pojai kita mugu. Isa tugu na paranga muna taiania na totoso isa sa muna poja votunia. Ura nake agou sa muna paranga, goto na Gagala Tabuna tu. ");
INSERT INTO lga_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Na totoso isa ira kao tamatasi marene ba mai vaitoni valao pa mate, ira na tamadi ba mai veiniria tugu sira na tudia, beto ira na koburu sa mai raja vamamateria sira na tamadi na tinadi. ");
INSERT INTO lga_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Beto agou sa na veveiqu ara sa kode maike tavaraguanigou doru tinoni. Ba na tinoni mina vangaju kamua na vinabetona sa mina taalo,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","<<Ba tonai muna batia agou sa na beku tana tamasa seseke mina turu pa ia madina pa zelepade ketakoi sa tabunana mina lao (agou qu tiroa api sa mu vakoinonoa na ginuana sapi!), poni sa ira na tinoni qai suvere pa Jiudia sa tonai mai uku sagereria sira na okokoto kubo ketakoi. ");
INSERT INTO lga_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Isa na tinoni sa korapa suvere pa narena nona ruma sa mike mule gore qaqiriria na ona sakasava pa leona ona ruma. ");
INSERT INTO lga_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na tinoni sa korapa pa inuma sa mike mule tekua na ona poko pa ona ruma. ");
INSERT INTO lga_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Na totoso takulangadi jola tadira na rereko qai bogata beto ira qai isongo melalu sira na rane ira! ");
INSERT INTO lga_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mu vavara tetepa lao tana Tamasa, ko na sakasava aipira sa maike raja lame pa totoso sa lomoso vivitigi na eqa. ");
INSERT INTO lga_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ura na tapata mai gosoria ira na tinoni na rane ira sa mina lavata jolaniria doru tapata qai jola, podalai vei tu totonai sa vapodakia na kasia abana na Tamasa ko sa kamua kopira ko pa liguna isa sa kepore mule sa kai sakasava veveina mina raja ligu. ");
INSERT INTO lga_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Vei bike kobu vapapakaria na Bangara sira na rane ira, poni sa kepore sa kai tinoni bi toa. Goto koko vei sa roquria isa sira na tinoni taviledi sa tei vileria tu isa, sa sa vapapakaria na Bangara sira na rane ira. ");
INSERT INTO lga_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ko vei bi parangagou kai tinoni, <Doro! Api sa na Karisito!> babi <Doro! Ina sisa!> biu, sa babana vasosotoa sisa. ");
INSERT INTO lga_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ura kode mai bobola kamu sira na karisito sesekedi beto na tinoni kokorotai sesekedi. Kode mai roiti votuniria sira na dia vinagigila beto na roiti vaivagabaradi, ko vei mai boka sa kode mai toni vapiruria tugu sira na tinoni taviledi tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ko agou sa mu suvere vabalau! Qa tei poja vakolenigou tu ara sira doru sakasava aipira tonai qai oqoro tu gore votu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","<<Ba pana rane ira totonai mina kamua na totoso tapata, mina rodomo sa na tapo beto na popu sa minake kabere; ");
INSERT INTO lga_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","mai vukele sira na seru pa noka beto ira na neqi pa noka mai tajou vakanoko. ");
INSERT INTO lga_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Beto mai batia ira sa na Tuna na Tinoni mina lame vei pa lei tavitia na neqi beto na kabere lavata. ");
INSERT INTO lga_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ego beto sa kode mina garunu laoniria isa pa made uquna na kasia gusu sira na mateana ko mina vaikamuniria sira nona tinoni taviledi, podalai pa kai uquna na kasia gusu ko mai lao vaokotia pa vinabetona,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","<<Mu teku vinakabere pa gou piqi. Tonai mina takelai sa na equruna beto mai podalai ijoko ligu sa na boko kaena, poni sa qu gigilai agou sa sa tata lame sa na totoso mangini. ");
INSERT INTO lga_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ko agou ba vei tugu. Tonai muna batiria mai gore votu sira na sakasava qa pojanigou ara, sa mu gigilai sa tata vivitigi gu pa atakamana sisa. ");
INSERT INTO lga_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ma poja sosotonigou ara sagou: tonai mai oqoro maragutu ira na sasae tinoni kopira sa kode mai gore votu sa na sakasava pira. ");
INSERT INTO lga_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Na oka beto na peso sa mai maragutu, ba na paranga taqu sa maike isongo maragutu podeke,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","<<Goto na veveina na rane babi na totoso isa sa kepore kai tinoni sa gigilai. Ira na mateana ba qaike gigilai, na Tuna ba sake gigilai tugu. Mekana gu na Tamana sa gigilai. ");
INSERT INTO lga_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mu suvere vabalau beto mu suvere kopu, ura quke gigilai agou sa na totoso. ");
INSERT INTO lga_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kai muqisi podeke vei gu kai tinoni sa riu lelekogona pa kai gusu souna. Tonai sa oqoro taloa riu poni sa sa okoto ianiria na roiti sira na ona nabulu ko mai okoto roiti sau. Beto sa poja vakolenia tugu sa na tinoni sa kopu pa atakamana ko mina suvere gegelenia sa na mule lamena saunia. ");
INSERT INTO lga_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ko sa vei sa agou ba mu suvere gegele, ura quke gigilai agou sa na totoso mina mule lame na bangarana na ruma. Sake tagigila sa bi lame na vevelu sa, na korapa bongi sa, na piranga kokorako sa, babi na vuvugei jonga. ");
INSERT INTO lga_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kita mi lame kamu vasiboro, poni mi batigou mu korapa puta mumagamiu agou. ");
INSERT INTO lga_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ko isa tugu qa korapa poja veinigou agou pira, sa qa poja veiniria tugu sira doru: mu suvere gegele,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ego karu rane sa kole beto mina kamua sa na vavolo Alokata beto na vavolo Bereti Nake Kovuruna. Ko ira na kuta iama beto ira qai vaivagigalainia na Vavanau sa qai kole nyanyaqoni soana ko mai aru tamania ko mai vamatea si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pira qai kole paparanga vei sina, <<Nake totoso vavolo Alokata, tana arua, kita ta kole vaiperaniria ira na tinoni,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ego sa korapa pa Betani si Jisu ko sa korapa suvere pa ruma tai Saimone, isa na tinoni sa rajai mai na popoqu perangana. Ko tonai sa korapa teteku i Jisu sa sa pogoso kamunia kai rereko sa kai jagi patu alabasita sa pugelia na oela liosona, na oela isa sa taroiti pa gou nadi ko sa sae jola na vaina. Sa lobitia isa sa na jagi api beto sa vuvania pa batuna i Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ba kaki ira qai suvere ketakoi sa qai kole vaiparanga tagigiri mekadi, pira qarigu, <<Koi, ai sa vei ko sa korapa tavuva vivikere goboro vei inara sa na oela jojonga ina? ");
INSERT INTO lga_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Bi boka vavainia ko bi tekunia jola kue gogoto poata siliva sa na oela api beto ko bi vaniria ira na tinoni golabadi sa na poata!>> qarigu. Ko qai tagigiri vivikerenia sa na rereko isa. ");
INSERT INTO lga_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ba sa paranga si Jisu, <<Tari tu, loai! Ai sa vei ko qu korapa vatapatia? Kai roiti jongana tugu sa sa korapa roitinia isa taqu. ");
INSERT INTO lga_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ura ira na tinoni golaba vaivasevidi sa kode mai suvere tavitigou doru totoso, ko tonai muna nyorogua tokaniria sa muna boka tokaniria gu. Goto ara sa maneke suvere tavitigou doru totoso. ");
INSERT INTO lga_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Na rereko api sa korapa roitinia sa isa vei sa bokai. Sa vuvani oela umanga jonga sa na tiniqu ara, ko sa varoroqu momoenia na golomoqu ara. ");
INSERT INTO lga_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ko ma poja sosotonigou ara sagou: doru eqa pa kasia gusu mina tatarae sa na nongoro jongana api sa mina tavavakato tugu ko na varoroquna na rereko isa sisa na roiti sa korapa roiti lamenia isa taqu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ego i Jiudasi Isikarioti, kame ira ka manogarua sepele, sa sa taloa lao tadira na kuta iama ko mina toni valao vaniria isa si Jisu sau. ");
INSERT INTO lga_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ko totonai qai nongoria ira na parangana i Jiudasi sa qai qera ko qai poja vakolenia ko kode mai vania na poata sisa qarigu. Ko sa popodalai nyanyaqoa i Jiudasi sa kai lolomo jongana tonai mina boka toni valao vaniria si Jisu sau. ");
INSERT INTO lga_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ego pa rane momoena na vavolo Bereti Nake Kovuruna, totonai qai kukuboloria sira na lami vavolo Alokata, sa qai nanasia ira nona sepele si Jisu, pira qarigu, <<Pai sa na ia qu nyoroguanigei ao, ko mene vatana vanigo sa na tetekuna vavolo Alokata?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Poni sa garunuria i Jisu sira karu ona sepele, pira sa poja veinira, <<Mu lao pa gusu lavata. Kai tinoni sa sa korapa popogosiaona kai bogu pie sa kode mina gosorogou. Muna tutia sisa ");
INSERT INTO lga_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ko ketakoi mina lao tome isa sa muna parangia sa na tinoni poreona ruma isa, pira munagunia, <Na Tinoni vaivagigalai sa pira sau, Pai sa na lose ketakoi mina tekua na tetekuna vavolo Alokata isa beto ira na ona sepele? sau,> munagunia. ");
INSERT INTO lga_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ko isa kode mina ule vanigou sa kai lose lavata pa nulu sa tei tavanaqiti vakole tu. Ketakoi sa muna vatanai agou sa na tetekuna tadagita,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ko tonai qai taloa riu ko qai lao kamu pa gugusu lavata sira karu sepele, sa qai batiria sira tugu vei sa pojaniria i Jisu, ko qai vatanania sa na tetekuna vavolo Alokata. ");
INSERT INTO lga_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ko totonai sa gore sa na vevelu, sa i Jisu sa lame tavitiria ira ka manogarua ona sepele. ");
INSERT INTO lga_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tonai qai vaikamu ko qai korapa teteku, sa paranga si Jisu, <<Ma poja sosotonigou ara sagou: kame agou qu korapa teteku tavitisiu ara sa mina gabala kanasiu ara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tonai sa qai mamata sira na sepele ko qai okoto nanasa memekai si Jisu, pira qarigu, <<Ai vei, nake ara sa qugunisiu ao?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Poni sa oe laoria i Jisu sira, <<Kode kame gu agou ka manogarua pira, isa sa somana totogologana bereti pa baolo tavitisiu ara. ");
INSERT INTO lga_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Na Tuna na Tinoni sa mina tavamate vei sa tei pojai tu na Kukuti Tabuna, ba mina gania na takulanga sa na tinoni sa gabala kanai na Tuna na Tinoni! Sa jongana jola sa bike pavu gu podo sa na tinoni isa!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ego totonai qai korapa teteku sira, sa sa tekua i Jisu sa na bereti ko sa manania beto sa kikipai ko sa ianiria sira na sepele, beto pira sau, <<Pia tekua, api sa na tiniqu,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Beto sa tekua sa na kapa vaini ko sa paranga jonganania beto sa vaniria ko qai vaibukunia ira doru. ");
INSERT INTO lga_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Beto sa pira sauniria, <<Api sa na orunguqu ara na vamauruna na vinaego, sa tavuva vaniria ira na soku tinoni. ");
INSERT INTO lga_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ma poja sosotonigou ara sagou: maneke buku ligua ara sa na vaini api tinganai mina kamua na rane totonai mana bukua ara sa na vaini korega pa binangara tana Tamasa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Beto qai kerania ira sa kai kera, beto sa qai taloa votu lao pa kubo pa Olive. ");
INSERT INTO lga_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ego beto sa parangaria i Jisu ria, <<Agou doru sa kode muna uku loa palenisiu sara, ura sa paranga sa na Kukuti Tabuna, <Ara mana vamatea na sepati, ko mai okoto nyanyalia neqa sira na sipi,> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ba pa liguna mana turu mule pa mate sara, sa mana lao momoe veranigou pa Qalili,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Poni sa paranga lao tana si Pita, <<Goto ara sa mai uku loa palego tu ira doru, ba ara sa maneke isongo loago sao!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Poni sa paranga lao si Jisu, <<Pita, ma poja sosotonigo ara sao: ao sa kode bongi tugu api totonai mina oqoro piranga vinarua na kokorako sa muna kilu palenisiu kue totoso ara sao,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ba sa paranga vivivagana tugu si Pita, pira sau, <<Ara vei mana mate tavitigo tugu ao ba maneke isongo osonigo tugu sao,>> sau. Ko ira doru sepele ba qai paranga vei tugu inara. ");
INSERT INTO lga_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ego totonai qai kamu sira pa kai ia na isongona pa Qetisemani, sa pira sauniria i Jisu sira na ona sepele, <<Mu suvere vera lani, goto ara ma lao vavara,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Beto sa toniria gu sira Pita, i Jekopi, beto i Jone. Sa tei podalai mamata na takulanga vivitigi tu sisa, ");
INSERT INTO lga_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ko pira sauniria sira kue, <<Na takulanga pa buloqu sa lavata jola sara ko mi vamatesiu sau. Mu suvere lani ko mu suvere gegele agou,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Beto sa rerege lao vasou iqona si Jisu beto sa opo gore pa peso ko sa vavara ko vei bi boka sa bi tavarijo tu sa na totoso vitigi api sau. ");
INSERT INTO lga_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Beto pira sau, <<Aba, Tamaqu. Kepore sa kai sava sa tapatigo ao. Mu varijo pale taqu sa na totoso vitigi alepi, ba nake isa vei qa nyoroguania ara sa mi taroiti goto isa tu vei qu nyoroguania ao,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Totonai sa mule lame poni sa batiria qai korapa puta mumagadia tu, ko pira saunia si Pita, <<Saimone, qu korapa putagamu sao? Ai vei, quke boka sosoto tugu suvere gegele kai aoa? ");
INSERT INTO lga_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mu suvere gegele beto mu vavara ko muke vukele pa totoke. Na gagala sa malumu ba na tini sa munyala,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Beto sa kai gabala lao bei ko sa vavara vei mutugu tonai sa vavara momoe si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tonai sa mule lame ligu poni sa batiria qai korapa mutugu puta mumagadia, ura sa ngaolo vivitigiria na nyo puta. Ko qaike gigilai sa na sa mai paranga laonia. ");
INSERT INTO lga_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tonai sa mule lame na vinaue totoso, poni pira sauniria, <<Qu korapa tugu puta minere vatalemiu sagou? Kopira sa pada gu! Doro, sa kamu gu sa na totoso mina tavalao pa limadi ira na tinoni seladi sa na Tuna na Tinoni. ");
INSERT INTO lga_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Aria, turu ko ta lao gosoria. Doro! Sa kamu gu api sa na tinoni sa gabala kanasiu ara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ego ko totonai tugu sa korapa paparanga vei inara i Jisu sa sa bola gu si Jiudasi, isa kame ira ka manogarua sepele. Sa toni bolania isa sa na puku minete tinoni qai pogoso benete vavaisobena beto na maja kubau. Ira na tinoni aipira sa na tagarunudi tadira na kuta iama, ira qai vaivagigalainia na Vavanau beto ko ira na iviva mamata. ");
INSERT INTO lga_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Kai vinagigila sa sa tei poja vakoleniria tu i Jiudasi na tinoni sa gabala kanai sira na minete sa toniria, pira sauniria, <<Isa na tinoni mana lao aoia na paparana ara sa isa sa na tinoni muna lame aru tamania ko muna toni riunia,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ko isa tugu sa bola kamu si Jiudasi poni sa sa rerege tuvisi lao gu sa ti Jisu, ko sa paranga, <<Rabi!>> sau, beto sa aoa na paparana. ");
INSERT INTO lga_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Totonai tugu sa qai lao ragata tekua ko qai aru tamania si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ba kame ira qai korapa turu ketakoi sa sa saputu votunia sa na ona benete vavaisobena ko sa maja teusu palea sa kai kale talingina na pinausu tana kuta iama lavata. ");
INSERT INTO lga_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Poni sa paranga si Jisu, pira sauniria, <<Na tinoni raraja ikikoqu sara ko qu pogoso tarinisiu na benete vavaisobena beto na maja kubau ko muna teku aru tamanasiu? ");
INSERT INTO lga_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Beko doru rane sa qa kole gu suvere tavitigou pa kakabarena zelepade ko qa kole vavaivagigalai ba quke isongo aru tamanasiu agou. Ba jongana ko mi gore votu tugu sa na Kukuti Tabuna,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ego tonai sa qai uku loa palenia ira doru sepele sisa. ");
INSERT INTO lga_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ego kai koburu marene kokoregana sa popokonia kai titivi gu sa sa somana tututia tugu i Jisu. Ko isa ba mai aru tamania tugu qarigu, ");
INSERT INTO lga_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","poni sa uele vaniria gu nona poko beto na gagadona gu sa sa oqai na taba. ");
INSERT INTO lga_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ego ko qai toni laonia tana kuta iama lavata si Jisu, ko ira doru kuta iama, na iviva mamata beto ira qai vaivagigalainia na Vavanau sa qai vavaikamu beto ketakoi. ");
INSERT INTO lga_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ego i Pita sa sa kole mamavo tuti liligu pa souna tu ko sa lao tome laona pa leo kakabarena ruma tana kuta iama lavata. Ko ketakoi sa lao toqona tadira na nabulu kopu ko sa davangaona pa keketai iku. ");
INSERT INTO lga_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ko qai kole popodeke nyaqo votunia ira na kuta iama beto ira doru iviva pa kauniseli sa vei bi koleona kai vavakato vei mina boka ulenia kai roiti ikerena sa roitinia i Jisu ko mai boka vamatea si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ura na mota joladi sira qai jutu tarini seseke si Jisu, ba na dia vavakato sa qaike vavaitoto. ");
INSERT INTO lga_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Beto qai gasa turu sira kaki ko qai jutu tarini seseke si Jisu, pira qarigu, ");
INSERT INTO lga_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<Agei qe nongoriamei sa pira sa paranga vei sina, <Ara mana jegara palea sa na zelepade madina qai roitinia ira na tinoni, beto pa liguna kue rane gu sa mana vaturu ligua sa kame isa nake ira na tinoni qai roitinia,> sau,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ba ira ba sake vavaitoto tugu sa na dia vavakato. ");
INSERT INTO lga_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ego beto sa turu pa moedi ira doru sa na kuta iama lavata ko sa nanasia si Jisu, pira sau, <<Ai sa vei munake oe sao? Na sa sira na vavakato qai korapa jutu tarinigo ira pira?>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ba sa nguju puku ko sake pojai tugu kai pakata paranga si Jisu. Poni sa kai nanasa mule sa na kuta iama lavata, pira sau, <<Ao tugu sa na Karisito, na Tuna na Tamasa tamanana?>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Totonai sa oe si Jisu, <<Ara tugu. Beto kode muna batia agou sa na Tuna na Tinoni mina toqona pa kale matuana na Tamasa vivana jola beto mina lagere vei pa lei pa noka,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tonai sa paranga vei inara si Jisu poni sa sa bako rikata palea na kuta iama lavata sa na ona poko, beto pira sau, <<Na vavakato vinasosoto sa mule sa taqe korapa verania gita? ");
INSERT INTO lga_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Qu tei nongoriamiu tugu agou sa sa vamoroania na Tamasa sa na tinoni api. Ko na sa sau na miu roroqu sagou?>> sau sisa. Ko qai vaegoa ira doru sa sa pada tugu ko mina tavamate si Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pana totoso tugu isa sa ira kaki sa qai podalai tue taria si Jisu, beto qai ude pikoni poko na isumatana beto qai piqolia beto sa pira qarigunia, <<Ego mu ulenia moko i sei sa sa majago!>> qarigunia. Beto sa qai saputu tekua ira na nabulu kopu sisa ko qai kole popoaria. ");
INSERT INTO lga_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Totonai sa korapa suvereona pa leo kakabarena pa kauruna na ruma si Pita, sa sa rerege tata lao sa kai nabulu rereko tana kuta iama lavata. ");
INSERT INTO lga_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ko tonai sa batia isa si Pita sa korapa davangaona, sa sa doro taria beto sa parangia, <<Ao tugu sa kame qu sosomana tutia na tinoni Nazareti ina?>> saunia. ");
INSERT INTO lga_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ba sa kilu pale sisa, pira sau, <<Ara qake gigilai beto qake vakaberia sisa qu korapa pojai ao ina,>> sau sisa. Beto sa mavo rijo votu laona pa atakamana na kakabarena na ruma. ");
INSERT INTO lga_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ego sa bati beia mutugu na nabulu rereko ketakoi sisa, ko sa ule vaniria sira qai kole turu tavitia isa ketakoi, pira sau, <<Isa tugu sa kame ira!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ba sa kilu pale mutugu sisa. Ba sa oqoro isongo sovai sa ira mule na tinoni qai kole turu tavitia ketakoi sa qai parangia mule sisa, pira qarigu, <<Ao sosoto tugu sa kame ira! Ura na tinoni Qalili sao!>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ba tonai sa maulu tarinia mekana na leleve si Pita, pira sau, <<Qake isongo gigila podekia ara sa na tinoni qu korapa pojai agou ina!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Totonai tugu sa sa piranga vinarua gu sa na kokorako. Poni sa sa roroqu kamua i Pita sa isa sa paranga veinia i Jisu tonai pira saunia, <<Mina oqoro piranga vinarua na kokorako sa kode muna kilu palenisiu ara kue totoso sao,>> saunia. Ko tonai tugu sa takakoto gu ko sa vodangia na lukana si Pita. ");
INSERT INTO lga_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ego na vuvugei rorodomo sa qai sisiqarai vaikamu sira na kuta iama, na iviva mamata, ira qai vaivagigalainia na Vavanau beto ira doru iviva pa kauniseli, ko qai mekarai vairovenia sa na vamatena i Jisu. Qai piu vaikamuniria sa na limana i Jisu ko qai toni laonia tai Paelati sisa. ");
INSERT INTO lga_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Poni sa nanasia i Paelati sisa, <<Ao sa na bangara tadira na Jiu?>> saunia. Poni sa oe lao si Jisu, <<E, isa qu pojai ao inana!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Qai kole jutu tarinia soku sakasava ira na kuta iama si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Beto sa kai nanasia mule i Paelati sisa, <<Ai sa vei ko quke oe tu sao? Doro! Tei kubo sakasava tu sa qu tajutunia ao!>> sau. ");
INSERT INTO lga_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ba sake pojai tugu kai sa si Jisu, ko sa gabara vivitigi si Paelati. ");
INSERT INTO lga_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ego na ona tutina i Paelati sa doru totoso pa vavolo Alokata sa sa ruvatia sa kai tinoni tapiuna qai nyoroguania ira na tinoni. ");
INSERT INTO lga_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ko na totoso isa sa kai tinoni na isongona i Barabasi sa somana tapiu tavitiria ira qai rajai na qavuna beto qai vaitinoni. ");
INSERT INTO lga_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ko qai sae vaikamu tai Paelati sira na minete tinoni ko qai tepai sisa ko mi vamalumu vaniria sisa vei sa roroitinia isa pa doru vavolo Alokata qarigu. ");
INSERT INTO lga_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Poni sa oe lao si Paelati, pira sau, <<Ai vei, qu nyoroguania ko ma ruvata vanigou sa na bangara tadira na Jiu?>> sau. ");
INSERT INTO lga_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ura sa tei gigilaiona tu i Paelati sa qai kokonoa gu ira na kuta iama si Jisu, sa vei sa qai loa lamenia tana. ");
INSERT INTO lga_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ba qai soriria ira na kuta iama sira na minete tinoni, ko i Barabasi tu sa mi ruvata vaniria qarigu. ");
INSERT INTO lga_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ba sa kai nanasa ligu lao mule tadira si Paelati, pira sau, <<Ko ai tu mana aru veinia ara si Jisu, isa qu gigalania na bangara tadira na Jiu agou?>> sau. ");
INSERT INTO lga_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Poni qai kai vevela mule sira, <<Vamatea pa korosi sisa!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ba sa nanasa si Paelati, pira sau, <<Ba na sela sa sa sa roitinia isa?>> sau. Ba tonai sa qai kuku vevela viviva tugu sira na minete tinoni, <<Vamatea pa korosi sisa!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ko sa nyorogua vaqeraria i Paelati sira na tinoni ko sa ruvata valao vaniria gu si Barabasi. Goto i Jisu sa loa lao vaniria ira na solodia ko mai irirunia na vavaiiruna beto sa mai riu vamatea pa korosi sau. ");
INSERT INTO lga_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ego ko qai toni tomenia pa leo kakabarena na ruma tana qavuna ira na solodia si Jisu, beto sa qai kuku vaikamuniria sira na minete solodia doruna. ");
INSERT INTO lga_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ko qai vasaenia na poko kala davala beto qai viria kai tarapae vavaioka sa vei na tarapae bangara beto qai vasolapania na batuna. ");
INSERT INTO lga_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Beto sa qai kole vavabangara leleoniadia ira sisa, beto ko pira qarigunia, <<Mi toa vakakasa na bangara tadira na Jiu!>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Beto sa qai kole vavagore tarini kolu sa na batuna, qai tutue taria, beto qai totoqo sori tutungu vavatarasae leleoniadia ira sisa. ");
INSERT INTO lga_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Pa liguna qai beto ngangangulu veinia inara sisa, sa qai vagore palea ira sa na poko kala davala ko qai vasae ligunia na ona poko mekana, beto sa qai toni votunia ko mai lao vamatea pa korosi qarigu. ");
INSERT INTO lga_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ego tonai qai korapa lalaodia pa soana sa qai gosoria sa kai tinoni pa Saerini, na isongona i Saimone, na tamadi ira Alekezada i Ruposi. Na koko lame veina pa ona gusu ko na koni kamuna tugu pa Jerusalema sisa. Qai garunu totokai ira na solodia sisa ko sa pogosia sa na korosi ti Jisu. ");
INSERT INTO lga_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Beto sa qai tonia si Jisu ko qai lao pa kai ia na isongona pa Qoloqota, na ginuana sa na Eqa Batu Tomate. ");
INSERT INTO lga_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ketakoi sa qai vania na vaini pasana isa qai qairi vaisomanainia na moa, ba sa daiona bukua. ");
INSERT INTO lga_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Beto sa qai patania pa korosi sisa, beto sa qai kole gonania na patu vivile ko mi tagigila sa i sei mina tekua sa na okokoto ririkatana na poko tana qarigu. ");
INSERT INTO lga_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ego ko na sia koloko vuvugei tu sa qai patania pa korosi si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ko na paranga sa tajutunia isa sa pira sau: NA BANGARA TADIRA NA JIU. ");
INSERT INTO lga_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Beto qai vamate tavitinia i Jisu sira karu tinoni raja ikikodi, kame pa kale matuana beto kame pa kale merina. ");
INSERT INTO lga_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ko ira na tinoni qai rerege jola sa qai poja vivikeria beto qai bebegoloniria na batudi, <<Aha! Ao sa muna jegaria na zelepade madina beto kue rane gu muna vaturu ligua qugu! ");
INSERT INTO lga_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ego mu alo mulenigo tu mekana, mu tavisu lageremua tu pa korosi!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ko ira na kuta iama beto ira qai vaivagigalainia na Vavanau ba qai kole tugu vavagoreni qera, pira qarigu, <<Ira na goto tinoni sa aloria, goto mekana sake boka alo mulenia! ");
INSERT INTO lga_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kopira sa mi gore lagere tu pa korosi sa na Karisito, na bangara tadira na tinoni Izireli, ko gita ba ta batia ko ta vasosotoa,>> qarigu. Ira karu qai tavamate tavitinia isa ba qai paranga ngangangulia tugu sisa. ");
INSERT INTO lga_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ego totonai sa kamua na korapa rane sa sa togai na rodomo sa doruna na gugusu, tinganai ko sa kamua tu kue koloko gogore tapo. ");
INSERT INTO lga_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tonai sa kamu kue koloko poni sa sa lukana uui si Jisu, pira sau, <<Eloi, Eloi, lama sabakatani?>> sau (na ginuana sa pira sau, <<Qua Tamasa, qua Tamasa, ai sa vei ko qu loa palenisiu tu?>> sau.) ");
INSERT INTO lga_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ira kaki qai turu tata ketakoi sa qai nongoria, ko pira qarigu, <<Doro! Sa korapa kukua i Elaija sina!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tonai sa kame ira sa sa pogoso abutu laonia sa kai pupuqana ko sa vatubulunia na vaini, ko sa suninia pa uquna kai kolu, beto sa alaka saenia tai Jisu ko mi vabukunia sau. Beto sa paranga, <<Loai ko! Ta dodogoroda. Kita pu kamu visu vagorea i Elaija,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Beto sa vagorea kai uui lavata si Jisu, beto sa loai na singo. ");
INSERT INTO lga_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tonai sa sa tarikatarua sa na poko tobana na zelepade madina, sa podalai tarikata pa nulu ko sa gore kamu pa peso. ");
INSERT INTO lga_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na tinoni mamata gogoto sa sa korapa tugu turuona pa moena na korosi ko sa batiaona sa vei beto sa loaia na singo si Jisu, ko sa paranga, <<Sosoto! Na tinoni api sa na Tuna na Tamasa,>> sau. ");
INSERT INTO lga_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ego qai korapa tugu turudia pa souna ketakoi sira kaki rereko, ko qai kole dodogoro laodia. Qai kole turu vaisomanaidia tugu ketakoi sira Mere Magadalene, i Salome, beto i Mere na tinadi ira Jekopi na tinoni ikete beto i Josesi. ");
INSERT INTO lga_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tonai sa susuvere pa Qalili i Jisu sa ira na rereko pira sa qai tututia isa beto qai totokania tugu vei. Ra kaki gogoto rereko mutugu qai mekarai tutia sae i Jisu pa Jerusalema sa qai korapa tugu turudia ketakoi. ");
INSERT INTO lga_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ego sa tei gore tu sa na vevelu, ko na rane Vatana sisa beto sa mina kamua sa na rane Minere, ");
INSERT INTO lga_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ko i Josepa pa Arimatia sa turu varene ko sa lao vatuvisi tai Paelati ko sa tepai sa na kokobu tinina i Jisu (I Josepa sa kai tinoni tapangagana pa kauniseli tadira na Jiu, beto mekana ba sa korapa tugu verania sa na lamena na binangara tana Tamasa). ");
INSERT INTO lga_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Poni sa gabara si Paelati totonai sa nongoronia i Jisu sa tei mate tu qarigu. Ko sa kuku tekua sa na tinoni mamata gogoto, ko sa nanasia, <<Ai sa vei, sa tei mate sosoto tugu si Jisu?>> sau. ");
INSERT INTO lga_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ko totonai sa nongoro vatalea mai tu tana tinoni mamata gogoto sa isa sa tei mate tu sau, beto sa soni vamalumu vania i Josepa ko mina boka tekua sa na kokobu tinina i Jisu saunia. ");
INSERT INTO lga_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ego sa vai tekua i Josepa sa kai poko koregana, beto sa visu vagorea sa na kokobu tinina i Jisu ko sa udenia, beto sa lao vakolenia pa kai bevi takori vakolena pa patu mamavarana. Beto sa bokili vatitolo lao pateinia kai patu lavata sa na atakamanana na bevi. ");
INSERT INTO lga_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ko ira Mere Magadalene beto i Mere na tinana i Josesi sa qai batiadia sa na ia ketakoi sa tavakole na kokobu tinina i Jisu. ");
INSERT INTO lga_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ego totonai sa jola na rane Minere, sa qai vai vakole oela umumanga jonga sira Mere Magadalene, i Salome, beto i Mere na tinana i Jekopi, ko mai lao lumunia na kokobu tinina i Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ko pa vuvugei jonga pa rane momoe pa vuiki isa tugu sa bola sagere na tapo sa qai lao pa bevi sira. ");
INSERT INTO lga_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Totonai qai korapa rerege lalaodia sa qai kole vavainanasa mekadi, pira qarigu, <<I sei mina bokili varijo vanigita sa na patu lavata pa mangana na bevi?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ura nake patu qeqerana sisa. Ba beto mai dogoro vatale lao qarigu, sa sa tei tabokili varijo tu sa na patu. ");
INSERT INTO lga_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ko tonai qai tome lao pa leo bevi, sa qai batia sa kai tinoni kokoregana sa vasaea na poko keala gojo doruru, beto sa korapa toqona keta pa kale matuadi. Ko qai gabara na matagutu sira. ");
INSERT INTO lga_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ba sa paranga sa na tinoni isa, <<Muke matagutu na gabara! I Jisu pa Nazareti isa sa tavamate pa korosi sa qu korapa nyaqoa agou! Sa tei turu mule tu! Kepore lani sisa! Doro! Lani tugu sa na ia ketakoi qai vakolenia isa. ");
INSERT INTO lga_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Goto agou mu lao ko mu vavakato vaniria sira na ona sepele beto i Pita, pira muguniria, <Sa tei lao momoe tu pa Qalili sisa. Ko ketakoi tu sa kode muna batinia sisa, vei sa tei pojanigou tu perangana,> muguniria,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ko qai abutu votu ko qai uku loa pale sa na bevi, ura qai matagutu beto qai gabara vivikereniria. Ko qaike isongo vavakato vania tugu kai tinoni, ura qai matagutu. ");
INSERT INTO lga_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","(Ego pa liguna sa turu mule na vuvugei jonga pa rane momoe pa vuiki si Jisu, sa sa bola votu momoe tai Mere Magadalene sisa. Tana tugu na rereko api sa qi iju votuniria ka vitu tomate ikikeredi i Jisu perangana. ");
INSERT INTO lga_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ko sa lao ko sa pojaniria isa sira ka visa qai tututia i Jisu, tonai qai korapa lukana takulanga. ");
INSERT INTO lga_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Totonai qai nongoronia sa i Jisu sa tei toa mule tu beto ko i Mere ba sa batiaona tu sauniria, ba qaike vasosoto tu sira. ");
INSERT INTO lga_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pana liguna isa sa i Jisu sa bola vagoto tadira karu sepele tonai qai korapa rerege lao pa kai gugusu. ");
INSERT INTO lga_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ko ira karu qai gabala mule vavakato vaniria sira doru sepele, ba qaike vasosotoria tugu. ");
INSERT INTO lga_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pa liligu tu sa sa bola votu tadira ka manogameka sepele totonai qai korapa teteku. Ko sa tokeria, ura kepore na dia vinasosoto beto sa patu na bulodi ko qaike vasosotoria sira qai batia pa liguna sa turu mule isa. ");
INSERT INTO lga_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Beto pira sauniria, <<Mu votu lao pa doru eqa pa kasia gusu, ko mu taraenia na nongoro jongana tadira doru vinapodaka. ");
INSERT INTO lga_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Na tinoni mina vasosoto ko mina tapaputaiso sa mina taalo. Goto isa minake vasosoto sa mina tavakilasa tugu. ");
INSERT INTO lga_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Beto na vinagigila pira sa mai tuti kakataparia sira mai vasosoto: pa isongoqu ara sa kode mai ijiju pale tomate ikikeredi, beto mai paranganiria na goto parangadi. ");
INSERT INTO lga_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bai aru dole ba bai buku sakasava vaivamatedi tugu sira, ba kepore tugu kame sa mina apuluria. Kode mai vaoponiria na limadi sira na tinoni qai mo, poni sa kode mai jongadia gu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ego ko totonai sa beto parangaria i Jisu na Bangara sira nona sepele sa sa tateku sae pa noka, ko sa toqo pa kale matuana na Tamasa. ");
INSERT INTO lga_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Beto qai riu tarae doru eqa sira na sepele, ko na Bangara sa roiti tavitiria ko sa vaneqiniria ira na vinagigila vaivagabaradi sa na dia paranga. Agua.)");
INSERT INTO lga_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ego tei motadi tu sira na tinoni qai popodeke ko qai kuti vaitututiniria sira na vavakatodi na roiti qai gore votu tamigei. ");
INSERT INTO lga_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ko na roiti aipira sa na veveidi tugu qai tei ule vakarovo vanigei tu agei ira qai batini matadi sosoto podalai tu pa popodalaina beto ko ira qai nabulu kopunia na nongoro jongana isa. ");
INSERT INTO lga_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Bangara Tiopilasi, ko inara sa vei sa pa liguna tu qa tuti vikivokotoria na totoso kakasana sa doru roiti ira, poni qa rove vaporeveveinai sa ara ma kuti vaituti vatale vanigo sao qau. ");
INSERT INTO lga_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Qa korapa roiti vei pira sara ko vei ko mu gigila vataleria ao sa na sosotodi tugu sira na sakasava qai tei ule vanigo tu ao ira na tinoni qau. ");
INSERT INTO lga_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ego na totoso sa korapa suvere bangara si Herodi pa ia pikata gugusu pa Jiudia, sa sa suvereona tugu ketakoi sa kai iama, na isongona i Zakarae, ko na puku iama tuti lame veina ti Abija sisa. Ko i Elizabeti na maqotana ba kai bubutu iama lame veina tugu ti Eroni. ");
INSERT INTO lga_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ko na tinoni tuvisidi pa dodogoro tana Tamasa sira karu, qai tuti vataleria ira karu sira doru garunu beto na uana tuvisidi tana Bangara ko sa kepore na dia pake pa toa. ");
INSERT INTO lga_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ba sa kepore na tudia sira karu ura i Elizabeti sa na egoro beto ko ira karu doru sa qai tei baragoso na qoele beto tugu. ");
INSERT INTO lga_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ego kai rane totonai sa kamua sa na totoso tadira na puku iama sa somania i Zakarae, poni sa kole roitinia na roiti tana iama pa moena na Tamasa si Zakarae. ");
INSERT INTO lga_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ko pa tutina vei beto qai tavile tonai qai gonania na patu vivile sira na iama qai roiti, sa sa tauduku si Zakarae ko isa sa mina lao roitinia sa na vavakukuvu umumanga jonga pa zelepade madina. ");
INSERT INTO lga_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ko totonai sa korapa vavakukuvu sisa, sa ira na minete tinoni sa qai korapa vavara pa peguruna. ");
INSERT INTO lga_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ko pa totoso tugu isa sa sa votu sa na mateana tana Bangara, ko sa kole turuona pa kale matuana na ia vavakukuvuna na sakasava umumanga jonga. ");
INSERT INTO lga_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ko totonai sa batia sa sa vakamunia na matagutu si Zakarae. ");
INSERT INTO lga_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ba sa paranga lao tana sa na mateana, pira sau, <<Zakarae, muke matagutu! Ura sa tei nongoria tu na Tamasa sa na mua vavara. Ko kode mina vaporea na maqotamu i Elizabeti sa kai tumu marene, beto ko muna vakukunia i Jone sisa. ");
INSERT INTO lga_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ko kode muna qeqera jola sao beto ko ira na kubo tinoni sa kode mai qera tugu tonai mina podo isa. ");
INSERT INTO lga_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ura kode mina kai tinoni poreveveina pa moena na Bangara sisa. Minake isongo buku vaini babi na buku neqina sisa, beto na Gagala Tabuna sa mina kole tana podalai tu tonai mina korapa pa iapana na tinana sisa. ");
INSERT INTO lga_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kode isa mina vagabala mule laoria tana Bangara na dia Tamasa sira na motadi na tinoni Izireli. ");
INSERT INTO lga_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Isa sa mina lao momoenia na Bangara. Kode mina lao pa neqi tana Gagalana na Tamasa kai muqisi podeke vei i Elaija, ko mina vagabalaria na bulodi sira na tamadi ko mai roroquria na tudia. Beto mina vagabalaria sira na tinoni ikikeredi ko mai isongia na tavagigala tadira na tinoni tuvisidi. Kode mina roiti vei inara sisa ko mina vatana vakole vania na Bangara sira na tinoni,>> sau sa na mateana. ");
INSERT INTO lga_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Poni sa paranga lao tana mateana si Zakarae, pira sau, <<Ai vei beto mana boka gigilai ara na sosotona sa sa vei isa? Ura ara sa qa tei baragoso tu beto ko na maqotaqu ba sa tei qoele tu,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Poni sa oe lao tana sa na mateana, <<Ara Qebereli sapi! Ara sa qa turu pa moena na Tamasa. Ko ara tugu sa sa garunusiu isa ko qa parangigo beto qa ule vanigo sa na nongoro jongana aipira. ");
INSERT INTO lga_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ko doro! Na nongoro qa ule vanigo ara sa kode mina gore votu tugu pa totoso tavilena tana Tamasa. Ba quke vasosoto sao, ko kopira muna poka ko munake boka paranga sao tinganai mina kamua na rane mai gore votu sira na sakasava aipira,>> sau sa na mateana. ");
INSERT INTO lga_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ego ira na tinoni sa qai kole verania si Zakarae sa qai kole rurania sa na veveina sa tei sovainia tu pa zelepade madina sisa ba sake oqani votu lame. ");
INSERT INTO lga_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Totonai sa votu lame ko sake boka parangaria, poni sa qai gigilai sa batia kai dodogoro pa zelepade madina sisa qarigu. Ko sake boka paranga ko sa kole popodeke pokaria gu sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Totonai sa beto ko sa okoto sira na rane nabulu sa sa mule laona pa nona ruma si Zakarae. ");
INSERT INTO lga_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pa liguna sa vei isa beto sa bogata gu si Elizabeti na maqotana, ko sa kole gu suvere ovona sake kanoko pa ruma ka lima popu. Aipira sa paranga vei sisa, ");
INSERT INTO lga_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","<<Kopira na Bangara sa tokanisiu sara ko qa vei pira. Sa doro kopunisiu ko na qua kea pa moedi ira na tinoni sa sa varijo palea isa,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ego totonai sa vonomo si Elizabeti, sa sa garunia na Tamasa sa na mateana i Qebereli ko sa lao pa kai gugusu pa Qalili, na isongona pa Nazareti. ");
INSERT INTO lga_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ko sa lao sa tana kai rereko koregana, isa sa tei tavaiviva vakolena tu ko mina alavia kai marene na isongona i Josepa, kai tinoni sa podo lame vei pa tutina i Devita na bangara. Ko na isongona na rereko koregana isa si Mere. ");
INSERT INTO lga_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ko sa lao sa na mateana ko sa parangia, <<Na mana mi kole tamu! Qu tamana sao! Na Bangara mi somana tamu!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ba tonai sa nongoria sa na paranga api sa sa matagutu vivitigi si Mere, ko sa kole roroqu nyanyaqoa isa sa ai beka pararanga vaigosoro veveina sapi sau. ");
INSERT INTO lga_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ba sa paranga lao tana sa na mateana, <<Mere, muke matagutu! Ura sa qeranigo na Tamasa sao. ");
INSERT INTO lga_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ko doro! Kode muna bogata sao ko muna vaporea sa kai tumu marene ko muna vakukunia i Jisu ao sisa. ");
INSERT INTO lga_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kode mina poreveveina sisa beto mina tagigala na Tuna na Tamasa ululuna jola, beto na Tamasa isa na Bangara sa mina vania na binangara ti Devita isa na ona tite pa moa. ");
INSERT INTO lga_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ko mina bangaraniria isa sira na bubutuna i Jekopi kamua na kamua beto ko na ona binangara sa mina kepore na vinabetona,>> sau sa na mateana. ");
INSERT INTO lga_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Poni sa oe lao tana mateana si Mere, <<Ai sa vei mina boka gore votu sa vei qu pojai ao, ura qa oqoro laoa kai marene sara?>> sau. ");
INSERT INTO lga_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Poni sa oe laoa na mateana sisa, pira saunia, <<Na Gagala Tabuna mina lagere tamu ko mina ongugo sao. Ko sa vei isa sa na koburu mina podo sa mina tagigala na liosona beto na Tuna na Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Doro! I Elizabeti na tavitimu sa tei qoele tu sisa ba kopira sa tei korapa tu bogatania isa sa kai koburu marene. Sa egoro qarigunia na tinoni sisa ba kopira sa tei vonomo tu sisa. ");
INSERT INTO lga_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ura kepore sa kai sakasava sa tapatia na Tamasa,>> sau sa na mateana. ");
INSERT INTO lga_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Poni pira sau si Mere, <<Api sara na nabulu tana Bangara. Mi gore votu tu taqu sisa na paranga qu pojai ao,>> sau. Ego beto sa sa taloa tana sa na mateana. ");
INSERT INTO lga_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ego ko pa totoso isa sa sa qaqiri gu si Mere ko sa sisiqarai taloa sae pa kubo pa ia pa Jiudia. ");
INSERT INTO lga_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ko totonai sa kamu sa sa lao tome pa ruma ti Zakarae, ko sa lao gosoro qeqerania si Elizabeti. ");
INSERT INTO lga_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tonai sa nongoro tekua i Elizabeti sa na vaigosoro qeqera ti Mere, sa sa kanoko sa na koburu pa iapana, beto sa tavapugelenia na Gagala Tabuna si Elizabeti, ");
INSERT INTO lga_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ko pira sau, <<Na tamanamu jolaniria ira doru rereko sao, ko mina tamana mutugu sa na koburu sa korapa pa iapamu. ");
INSERT INTO lga_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","I sei sara ko na tinana na qua Bangara sa lame tu ovikisiu? ");
INSERT INTO lga_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ura api! Isa tugu qa nongoria na vaisogoro qeqeramu ao, poni sa kanoko gu sa na koburu pa iapaqu ura sa qeqera. ");
INSERT INTO lga_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Muna tamana jola sao Mere, ura qu vasosotoa ao sisa vei sa pojanigo na Bangara sa kode mina gore votu!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Beto pira sau si Mere, <<Na buloqu sa sa valavatia na Bangara, ");
INSERT INTO lga_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","beto na gagalaqu sa qerania na Tamasa isa na qua inaalo. ");
INSERT INTO lga_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ura sake doro palesiu sara kai ona nabulu kepore veveiqu. Doro! Kopira ko mi lao mai gigalanisiu na rereko tamanana ira doru sasae tinoni sara, ");
INSERT INTO lga_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ura na Tamasa neqina jola sa roitiniria taqu na roiti vaivagabaradi. Isa sa na liosona na isongona. ");
INSERT INTO lga_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Sa vabatiniria na ona vairoqu vaitokai sira na okokoto sasae tinoni, ira qai pangagania sisa. ");
INSERT INTO lga_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Na limana sa roitiniria na roiti neqidi jola, sa vanyanyalaniria neqa sira qai roroqu valavata muleniria mekadi. ");
INSERT INTO lga_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Sa vagore paleria isa pa dia totoqona bangara sira na mamata neqidi, beto sa valavataria isa sira na tinoni kepore veveidi. ");
INSERT INTO lga_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Sa vapugele vaniria na sakasava jongadi sira qai burana, goto ira qai isisongo sa sa iju variu gagale paleria. ");
INSERT INTO lga_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Sa tei tokania tu isa sa nona nabulu i Izireli, sake mumania isa sa nona vairoqu vaitokai. ");
INSERT INTO lga_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Isa tugu mina vei sau sa sa taringungutinia isa tadira tamada pa moa, tai Ebarahami beto tana tutina i Ebarahami kamua na kamua,>> sau si Mere. ");
INSERT INTO lga_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ego ko sa suvere mai tu tai Elizabeti kue popu si Mere, beto sa sa mule pa nona gugusu. ");
INSERT INTO lga_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ego sa kamua na ona popu okotona si Elizabeti, ko sa vapodoa isa sa kai koburu marene. ");
INSERT INTO lga_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ko totonai qai nongoronia ira qai suvere pa vailivutaina beto ira na turana sa vei sa roroqu toka veinia na Bangara isa, sa qai somana qeqera tavitia isa sira. ");
INSERT INTO lga_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ego beto sa totonai sa vesu ranena sa na koburu, sa qai lame somanania na pobena na koburu beto ko mai visongo tutinia i Zakarae na isongona na tamana qarigu. ");
INSERT INTO lga_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ba sa paranga tu sa na tinana, <<Dai! I Jone tu sa na isongona,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Poni pira qarigu sira na tinoni tana, <<Ba kepore kai turamu ao sa bi tei tavaisongonia mai tu sa na isongo isa,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Beto sa qai popodeke poka laoa ira sa na tamana na koburu, ko qai nanasia i sei beka bi vaisongonia isa sa na koburu qarigunia. ");
INSERT INTO lga_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Poni sa tepai i Zakarae sa kai patu ketakoi mina kutia na isongo, beto sa pira sau sa sa kutia, <<Na isongona sa i Jone,>> sau. Poni sa qai gabara beto sira. ");
INSERT INTO lga_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ego pa totoso tugu isa sa revanga sa na mangana beto sa munyala sa na meana, ko sa paranga vatarasaea isa sa na Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ko ira doru qai suvere ketakoi sa qai matagutu beto. Sa tapiara lekogo pa doru gugugusu pa kubo Jiudia sa na nongoro aipira. ");
INSERT INTO lga_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ko ira doru tinoni vei qai nongoria sa qai kole roroquria pa bulodi sa aipira, ko qai paranga sira, <<Ai beka kode mina koburu veveina sa na koburu api?>> qarigu. Ura sa tabata vakabere gu tana sa na neqi tana Bangara. ");
INSERT INTO lga_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ego sa tavapugelenia na Gagala Tabuna si Zakarae ko sa ulule votunia, pira sau, ");
INSERT INTO lga_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","<<Sa pada mina tavatarasae sa na Bangara na Tamasa tadira na tinoni Izireli, ura isa sa lame ovikiria beto sa ruvataria sira na ona tinoni. ");
INSERT INTO lga_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Beto ko sa tei vanigita tu isa sa kai inaalo varenena pa tutina i Devita na ona nabulu. ");
INSERT INTO lga_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Isa vei sa tei taringungutinia tu isa tadira na ona tinoni kokorotai madidi pa moa, ");
INSERT INTO lga_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","sa isa mina vasaregita tadira na oda kana beto pa neqi tadira doru qaike tavaraguanigita sau. ");
INSERT INTO lga_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ko na Tamasa sa sa vabatiniria na vairoqu vaitokai sira na oda tite, beto sake mumania isa sa nona taringunguti madina. ");
INSERT INTO lga_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Isa sa na taringunguti sa maulunia ti Ebarahami ko mina vanigita sau: ");
INSERT INTO lga_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","sa taringunguti vakolenia isa sa isa mina vasaregita tadira na oda kana, ko taneke matagutu nabulunia gita sisa sau. ");
INSERT INTO lga_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ko gita tana nabulunia sisa pa uana liosona beto na tuvisina pa moena isa doru rane pa noda toa sau. ");
INSERT INTO lga_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ko ao, na tuqu, sa muna tagigala na tinoni kokorotai tana Tamasa ululuna jola. Ura muna lao momoeni na Bangara sao, ko muna vatana vakole vania na soana, ");
INSERT INTO lga_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ko muna vagigalainiria ira na ona tinoni na veveina mai taalo sira tonai mina taleoso na dia sela. ");
INSERT INTO lga_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Isa mina roroqu tokaniria ura na oda Tamasa sa isongia na bulo vairoqu. Kode mina valamea isa tadagita sa na kabere vuvugei jonga sa koko vei pa nulu vavagalo. ");
INSERT INTO lga_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ko mina vagonaniria na kabere sira qai suvere pa rorodomona beto ira qai matagutunia na mate, ko mina gaitia na oda vakasa lao pa soana bule,>> sau si Zakarae. ");
INSERT INTO lga_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ko sa lavata sae ko sa neqi pa ona toa gagala sa na koburu. Sa suvere pa qega sisa tinganai tu sa kamua na totoso tonai sa votu vakabere tadira na tinoni Izireli. ");
INSERT INTO lga_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pana totoso isa sa sa vaturua i Siza Oqasitasi na bangara pa Romu sa kai vavanau ko mai taanye ko mai takuti beto sira doru tinoni pa ona binangara sau. ");
INSERT INTO lga_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Api sa na totoso momoe qai taanye ira na tinoni ko na anye tinoni isa sa sa taroiti tonai i Kuriniasi sa na qavuna pa pikata gugugusu pa Siria. ");
INSERT INTO lga_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ko ira doru tinoni sa qai okoto mumule riu pa dia gugusu togasadi ko mai takuti qarigu. ");
INSERT INTO lga_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ko i Josepa ba sa taloa tugu pa Nazareti kai gugusu pa Qalili, ko sa sae pa Jiudia pa gugusu Betilihema, na gusu ti Devita, ura na podo lame veina pa bubutu ti Devita sisa. ");
INSERT INTO lga_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ko sa toni saenia isa si Mere ko mai mekarai takuti sau. I Mere sa sa tei tavaiviva vakole tu ko mina alavia isa, beto ko sa tei bogata tu sa totonai. ");
INSERT INTO lga_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ko tonai qai korapa suvere pa Betilihema ira karu, sa sa kamu gu sa nona totoso okotona si Mere. ");
INSERT INTO lga_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ko sa vapodoa i Mere sa na tuna marene podo moena, ko sa udenia kai lage poko beto sa sa vakolea ketakoi qai vavavakole vaniria na gagani ira na manugu mamade nenedi, ura sa pugele sa na ruma susuverena tadira na tinoni kamudi ko kepore sa kai lose bai suveria. ");
INSERT INTO lga_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ego qai korapa suveredia tugu pa ia ketakoi sira kaki tinoni kopu sipi, qai korapa kopuniria na dia godo sipi na bongi. ");
INSERT INTO lga_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ko totonai sa sa bola vasiboro tadira sa kai mateana tana Bangara beto ko sa ude vailivutainiria sa na kabere lavata tana Bangara, ko qai matagutu vivitigi sira. ");
INSERT INTO lga_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Beto sa pira sauniria sa na mateana, <<Muke matagutu! Doro! Ura ara sa qa pogoso lame vanigou kai nongoro vaivaqerana jola ko isa mina vaqera betoria doru tinoni. ");
INSERT INTO lga_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Sa tei podo tu pa ngeni api pa gugusu tai Devita sa na miu inaalo, na Karisito Bangara! ");
INSERT INTO lga_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ko api sa na vinagigila muna batia agou. Tonai muna lao sa muna batia kai koburu, sa taudenia kai lage poko ko sa korapa koleona ketakoi qai vavavakoleniria na gagani tadira na manugu mamade nenedi,>> sau sa na mateana. ");
INSERT INTO lga_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Beto sa pa totoso tugu isa sa lagere somana tavitia na mateana isa sa kai minete mateana lavata pa noka, ko qai kera vatarasaea ira sa na Tamasa, pira qarigu, ");
INSERT INTO lga_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","<<Mi tavatarasae sa na Tamasa ululuna jola, beto na bule sa mi kole pa peso tadira sa qeraniria isa,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ego ko ligudi qai taloa mule sae pa noka ira na mateana, sa qai kole vavaiparanga sira na tinoni kopu sipi, pira qarigu, <<Aria moko ko ta lao pa Betilihema, ko ta lao doria sa na manugu sa pidoko, isa vei sa ule vanigita na Bangara,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ko qai sisiqarai taloa riu sira, ko qai lao tugu batiria ira sira Mere, i Josepa beto ko na koburu melalu. Ko na koburu sa korapa tugu koleona ketakoi qai vavavangojaniria na manugu mamade nenedi. ");
INSERT INTO lga_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ko totonai qai batia ira na tinoni kopu sipi sa na koburu, poni sa qai vavakatonia sisa sa pojaniria na mateana na veveina na koburu. ");
INSERT INTO lga_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Poni ira doru qai nongoria na vavakato tadira na tinoni kopu sipi sa qai gabara beto. ");
INSERT INTO lga_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Goto i Mere sa kopuniria ko sa kole roroquria pa bulona sira doru sakasava aipira. ");
INSERT INTO lga_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ego beto sa qai taloa mule riudia sira na tinoni kopu sipi, ko qai vatarasaea ira sa na Tamasa, ura doru sakasava qai nongororia ko qai batiria sa sake goto, goto isa tugu vei sa pojai na mateana. ");
INSERT INTO lga_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ego ko tonai sa vesu ranena ko sa tapobe sa na koburu, poni sa sa tavakukunia i Jisu na isongona sisa, isa vei sa tei poja veiniria tu na mateana totonai sa oqoro tu pidoko pa iapana i Mere. ");
INSERT INTO lga_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ego tonai sa kamua sa na totoso ko mai roitinia ira Josepa i Mere sa na vavakukuvu vuvulasa isa vei sa pojai na Vavanau ti Mosese, poni sa qai pogoso saenia tugu pa Jerusalema ira karu sa na melalu ko mai vamadia tana Bangara qarigu. ");
INSERT INTO lga_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Qai tutia ira karu sa isa vei sa takuti kolena pa Vavanau tana Bangara, pira sau, <<Doru koburu marene qai poraka moenia na kokolena koburu sa mai tavile kale vania na Bangara,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ko qai lao vavakukuvunia sisa vei sa pojai na Vavanau tana Bangara: karu kuru lavata babi karu tuni kuru, sau. ");
INSERT INTO lga_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ego ko api sa korapa suvereona pa Jerusalema pa totoso isa sa kai tinoni, na isongona i Simione, kai tinoni tuvisina beto sa isongia na pangagana na Tamasa. Ko sa korapa tugu vera vatalenia isa sa na totoso tonai na Tamasa mina vamanotoria sira na tinoni Izireli, ko sa gorea na Gagala Tabuna sisa. ");
INSERT INTO lga_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sa tei ule vamoenia tu na Gagala Tabuna isa sa minake oqani mate sisa tinganai mina batia mai tu isa sa na Karisito tana Bangara saunia. ");
INSERT INTO lga_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ko sa tonia na Gagala Tabuna si Simione ko sa lao tome pa kakabarena zelepade. Ko tonai qai geri laonia ira karu tinana na tamana pa kakabarena zelepade sa na koburu i Jisu ko mai vamadia ko mina taroiti vei isa sa tapoja pa vavanau tana Bangara qarigu, ");
INSERT INTO lga_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","poni sa sa teku geria i Simione sa na koburu ko sa vatarasaea sa na Tamasa, pira sau, ");
INSERT INTO lga_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","<<Bangara, qu tei vagore votua tu ao sa na mua taringunguti. Ko kopira mu ruvatasiu ara na mua pinausu, ko ma taloa riuqua pa bule. ");
INSERT INTO lga_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Qa tei batini mataqu tu ara sa na inaalo sa koko lame vei tamu, ");
INSERT INTO lga_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","isa qu vatana vakolea ao pa moedi ira doru tinoni. ");
INSERT INTO lga_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Isa sa na kabere sa vaniria na kabere ira na tinoni karovodi, beto na neqi ira na tinoni Izireli,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ego ko qai gabarania ira karu tinana na tamana na koburu sira na paranga veveina na koburu sa pojaria i Simione. ");
INSERT INTO lga_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Beto sa sa mananiria i Simione sira beto pira saunia si Mere, na tinana na koburu, <<Doro! Na koburu api sa na tavilena tana Tamasa ko mina vavukeleria beto mina vatururia ira kubo tinoni Izireli, beto ko isa sa kai vinagigila tana Tamasa mai kanai ira kubo tinoni. ");
INSERT INTO lga_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ko ira na roroqu qai kokole golomo pa bulodi na tinoni sa mina vavotu betoria isa pa kaberena. Goto ao mekamu sa na takulanga isa sa gea vei na likoto sa mina sobea na bulomu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ego sa suvereona tugu vei ketakoi si Hana kai rereko kokorotai, na tuna i Panuela, na bubutuna i Asa. Totonai sa tei qoele tu sisa. Na vaialavana perangana sisa, ko ka vitu aoro mai tu qai vaisuvere taviti sira karu marenena beto sa mate sa na marenena. ");
INSERT INTO lga_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ko sa suvere nanaboko tinganai sa kamua na totoso isa tonai sa vesungavulu made aorona sisa. Na rane na bongi sake selania isa sa na lalao vatarasaea na Tamasa pa kakabarena zelepade. Sa toania isa sa na toa mamadi ko nake teteku beto na toa vavara. ");
INSERT INTO lga_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ko pa totoso tugu isa sa sa kamu si Hana ketakoi, ko sa paranga jongana lao tana Tamasa, beto sa sa vaqatania isa tadira sa na veveina na koburu, tadira qai korapa verania na totoso na Tamasa mina ruvatia na gugusu Jerusalema. ");
INSERT INTO lga_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ego ko totonai qai vaokoto betoria ira Josepa i Mere sira doru ginugua qai tapoja pa vavanau tana Bangara, poni sa ira kue tatamana qai muledia pa Qalili, pa dia gugusu sosoto pa Nazareti. ");
INSERT INTO lga_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ko sa lavata sae ko sa neqi sa na koburu beto sa isongo vatatalea isa sa na gigalai tavagigala, beto ko na mana tana Tamasa sa kole somana tana. ");
INSERT INTO lga_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ego doru aoro sa ira karu tinana na tamana i Jisu sa qai sasae somanania na vaikamu vavolo Alokata pa Jerusalema. ");
INSERT INTO lga_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ko tonai sa manogarua aorona i Jisu sa qai sae mutugu somana pa vaikamu, qai vevei tugu doru totoso vavolo. ");
INSERT INTO lga_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ego ko tonai sa jola sa na vaikamu, poni sa qai gabala mule riudia sira Mere i Josepa, goto na tudia marene i Jisu sa suvere jolaona tu pa Jerusalema. Ba ira karu tinana na tamana sa qaike gigilai sa sa vei isa. ");
INSERT INTO lga_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Qai roroqua ira karu sa palu sa tei tuti tu pa minete tinoni sa qarigu. Ko sa jola tu kai doru rane poni beto sa qai kole doro nyanyaqoa tadira na tavitidi beto na dia baere. ");
INSERT INTO lga_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ba qaike batia ira karu sisa, ko qai gabala mule bei tu pa Jerusalema ko qai mule nyaqoa. ");
INSERT INTO lga_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ko na rane vinaue tu sa qai batia ira karu pa kakabarena zelepade sisa. Sa korapa toqo vaisomanai tavitiria ira na tinoni qai vavaivagigalainia na Vavanau sisa, ko sa korapa nonongoro beto sa nananasaria. ");
INSERT INTO lga_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ko ira doru qai nongoria sa qai gabara jolania sa na gigalai beto na ninanasa tana. ");
INSERT INTO lga_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ko totonai qai batia isa sira karu tinana na tamana, poni sa qai gabara, beto pira saunia na tinana, <<Tuqu, ai sa vei ko qu roiti vei tu inara? Doro! Na tamamu beto ko ara! Qe takulanga jola na kole mamalagoso nyaqogo ao sagei karu,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Poni sa oeria isa sira karu, <<Ai sa vei ko qu nyaqosiu tu? Quke gigilai tu agou sa na padaqu tugu mana suvere pa ruma tana Tamaqu sara?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ba qaike gigilai ira karu na ginuana sisa vei sa pojaniria isa. ");
INSERT INTO lga_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ego pa liguna sa vei isa sa beto sa tuti muleria isa sira karu na tinana na tamana ko qai gore pa Nazareti. Ko sa suvere vataberia isa ketakoi sira karu. Ko na tinana sa kopuniria ko sa kole roroquria pa bulona sira doru sakasava aipira. ");
INSERT INTO lga_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ego ko sa ijoko sae pa tinina beto pa gigigalai tavagigala si Jisu, ko sa qerania na Tamasa beto ira na tinoni sisa. ");
INSERT INTO lga_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ego pa vinamanogalima aorona na binangara ti Tiberiosi, isa na kuta bangara pa Romu, sa i Ponitiasi Paelati sa na qavuna pa Jiudia, i Herodi na bangara pa Qalili, goto i Pilipi na tasina sa na bangara pa Ituria beto pa Tarakonitisi, goto i Lusaniasi sa na bangara pa Abilini, ");
INSERT INTO lga_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","beto ira Hanasi i Kaiapasi sa na kuta iama lavata. Na totoso isa sa lame pa qega ti Jone, na tuna i Zakarae, sa na paranga tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ko sa lekogia i Jone sa doruna na ia pa karu kale vaikarovona na pie Jodani ko sa taraenia isa sa na veveina ira na tinoni sa mai gabala loa paleria na dia sela beto mai tapaputaiso ko na Tamasa mi taleosoniria sau. ");
INSERT INTO lga_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ko sa gore votu sa isa vei sa takuti pa buka tai Aisea na tinoni kokorotai, isa pira sau, <<Kai ovovele sa korapa kukuku pa qega, pira sau, <Mu vatanania na soana tana Bangara, vaemesia ketakoi mina rerege lao vei isa. ");
INSERT INTO lga_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Doru lolomo sa mai tavapugele, doru kubo na gogore sa mai tavaarare vaitoto. Ira na soana kekeqodi sa mai tavatuvisi, ira na soana ikikeredi sa mai tavaemese. ");
INSERT INTO lga_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ko doru tinoni sa mai batia na inaalo tana Tamasa!> sau.>> ");
INSERT INTO lga_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ego na motadi sira na puku tinoni qai vovotu lao tai Jone ko mai tapaputaiso qarigu. Poni pira sauniria isa sira, <<Boko tuni dole ikikeremiu! Qu siana sagou! I sei sa pojanigou sa muna boka ukunia agou sa na vinakilasa sa korapa jojoro lame? ");
INSERT INTO lga_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Goto mu gabala ko mai tabata sira na vua jongadi pa miu uana. Muke sianania sa na tutina i Ebarahami sagei ko kode mene taalomei gu kita mugu. Ura ma poja vatalenigou gu ara sagou: na Tamasa sa mina boka roiti vania na koburu gu i Ebarahami sira na vavaikamu patu pira! ");
INSERT INTO lga_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ko kopira na vaituti sa sa tei tavanaqiti vakole tu, sa vei na rio sa tavakole pa kutana na gou ko mi paduru paleniria na bageredi na gou sau. Ko ira na gou qaike vuania na vua jongana sa kode mai tario pale ko mai tagona lao pale pa niku!>> sau si Jone. ");
INSERT INTO lga_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Poni qai nanasa sira na minete tinoni, <<Ego ko na sa sa mene roitinia agei?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Poni sa oeria isa sira, <<Isa na tinoni sa karu na ona soti, sa mi vania kame isa kepore ona. Beto isa sa poregana gagani, sa mi iaria tugu sira sa keporeniria,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ego ko ira na tinoni teteku takisi ba qai lame ko mai tapaputaiso tana qarigu, ko qai nanasia ira sisa, <<Tinoni vaivagigalai, agei pira sa na sa mene roitinia?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Poni sa oeria isa sira, <<Na padana gu vei sa vaigarununia na qavuna sa mu tekua, goto muke teku vajolai na takisi,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ira na solodia ba qai lame mutugu tana ko qai nanasia, <<Goto agei pira sa ai mene vei? Na sa sa mene roitinia?>> qarigu. Poni sa oe laoria isa sira, <<Muke teku ragataria babu jutu goboro sesekeria ko bu teku variuniria na dia poata sira na tinoni! Mu qerania gu sa na miu tabara!>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ego totonai sa ira na tinoni sa qai kole verania kode kaki sakasava mai pidoko qarigu. Ko qai kole vaiperania ira doru pa dia roroqu sa palu api tugu sa na Karisito qarigu. ");
INSERT INTO lga_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Poni sa poja betoniria i Jone sira doru, <<Ara sa qa paputaisonigou na kolo, goto isa tu sa poreveveina jolanisiu ara sa sa korapa tuti lame. Ko ara ba nake padaqu ko mana ruvatia na pikona nona sadolo sisa. Isa tu sa mina paputaisonigou na Gagala Tabuna beto na iku. ");
INSERT INTO lga_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ura na sevolo vavaipikatai sa sa tei arunia tu pa limana sisa ko mi pikata paleniria sau sira na kopo ikika pa ia iru vaipipikatainiria ira na kiko, beto ko mi boko vaikamuniria pa ona ruma vavakoleni gagani sira na kiko vuiti sau. Goto ira na ikikadi sa mai tagona lao pale pa iku sa ilili kare,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ko soku mule sira na vavanau sa kole tarae vabalauria i Jone totonai sa taraenia isa na nongoro jongana tadira na tinoni. ");
INSERT INTO lga_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","I Jone sa kole tugu udukia vei si Herodi na bangara, na ginuana vei sa alava tekua i Herodiasi, na maqotana i Pilipi na tasina gu beto ko koledia mule kaki roiti sake vagosoro vei sa roitiniria i Herodi. ");
INSERT INTO lga_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ego beto sa sa vatamo laonia mule i Herodi sa kai roiti ikerena jola, sa vakolea isa pa ruma vaipiu si Jone. ");
INSERT INTO lga_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ego pa liguna qai beto tapaputaiso ira na tinoni sa sa lao si Jisu ko sa somana tapaputaiso tugu. Ko totonai sa korapa vavara isa sa sa tarevanga sa na oka, ");
INSERT INTO lga_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ko sa gore lagere vei na tinonina na kuru tana sa na Gagala Tabuna, ko sa gore toqo makele tana. Beto kai ovovele sa sa gore lagere vei pa noka, pira sau, <<Ao sa na Tuqu qa roroqugo ara! Qa qera jolanigo ara sao!>> sau. ");
INSERT INTO lga_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ego ko totonai sa podalainia na ona roiti si Jisu sa sa pada vei uengavuluputa aorona sisa. Pana dodogoro tadira na tinoni sa i Jisu sa na tuna gu i Josepa qarigu, isa i Josepa na tuna i Eli. ");
INSERT INTO lga_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ko i Eli sa na tuna i Matati isa na tuna i Livai, isa na tuna i Meleki, ko isa na tuna i Janai tai Josepa. ");
INSERT INTO lga_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ko i Josepa api sa na tuna i Matatiasi tai Emosi, isa na tuna i Nahumi, na tuna i Esili tai Nagai. ");
INSERT INTO lga_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ko isa i Nagai api sa na tuna i Maati, na tuna i Matatiasi, na tuna i Semeini ti Joseki, na tuna i Joda. ");
INSERT INTO lga_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ko i Joda sa na tuna i Joanani, isa na tuna i Resa, isa na tuna i Zorobabele, isa na tuna i Salatieli tai Neri, ");
INSERT INTO lga_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","isa na tuna i Meleki tai Adi, isa na tuna i Kosamu, isa na tuna i Elamadamu tai Ea. ");
INSERT INTO lga_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ko i Ea sa na tuna i Josua tai Elieza, isa na tuna i Jorimi, isa na tuna i Matati tai Livai. ");
INSERT INTO lga_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","I Livai sa na tuna i Simione, isa na tuna i Jiuda, isa na tuna i Josepa, isa na tuna i Jonamu tai Eliakimi. ");
INSERT INTO lga_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ko i Eliakimi sa na tuna i Melea tai Mena, isa na tuna i Matata tai Netani, isa na tuna i Devita. ");
INSERT INTO lga_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ego ko i Devita sa na tuna i Jese, isa na tuna i Obedi, isa na tuna i Boazi tai Salamoni, isa na tuna i Nasoni. ");
INSERT INTO lga_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ko i Nasoni sa na tuna i Aminadabi tai Adamini, isa na tuna i Ani tai Hezironi, i Hezironi sa na tuna i Perezi tai Jiuda. ");
INSERT INTO lga_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ko i Jiuda api sa na tuna i Jekopi, isa na tuna i Aisake, isa na tuna i Ebarahami, isa na tuna i Tera, isa na tuna i Nahoa. ");
INSERT INTO lga_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ko i Nahoa sa na tuna i Seruqi tai Raqau, isa na tuna i Peleqi, isa na tuna i Ebea tai Sala. ");
INSERT INTO lga_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ko i Sala api sa na tuna i Keinani, isa na tuna i Apakasadi tai Semu, isa na tuna i Noa, na tuna i Lameki. ");
INSERT INTO lga_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ko i Lameki sa na tuna i Metusela, isa na tuna i Inoke, isa na tuna i Jareti, isa na tuna i Maleleili, isa na tuna i Keinami. ");
INSERT INTO lga_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ego ko isa i Keinami api sa na tuna i Enosi tai Seti, ko i Seti sa na tuna i Adama, isa na tuna na Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ego sa pugelia na Gagala Tabuna si Jisu, ko sa taloa pa pie Jodani ko mi muleona sau. Ko tonai sa mule sa sa tonia lao pa qega na Gagala Tabuna sisa, ");
INSERT INTO lga_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ko sa kole qoqorai na bangaradi na tomate ka madengavuluputa rane sisa. Ko pa doruna na totoso isa sa kepore kai sa bi tekua sisa, ko tonai sa jola ka madengavulu rane sa sa burana. ");
INSERT INTO lga_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Beto pira saunia na bangaradi na tomate sisa, <<Vei muna Tuna sosoto na Tamasa sao, sa mu parangia na patu api ko mi peluku bereti,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Poni sa oea i Jisu sisa, <<Pira tu sau sa sa kole pa Kukuti Tabuna, <Na tinoni sa sake toania na bereti gagale mekana,> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ego beto sa na bangaradi na tomete sa toni saenia mule pa kai ia ululuna si Jisu ko sa vabatinia pa kai iapeki totoso sa doruna na binangara pa kasia gusu. ");
INSERT INTO lga_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Beto sa pira saunia na bangaradi na tomate sisa, <<Ao mana vani betogo sira dorudi na neqi aipira beto na dia isisongo, ura ara gu qa tei taianiria tu sa aipira ko na tinoni mana nyogua vania ara sa mana boka vania gu. ");
INSERT INTO lga_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ko ao sa vei muna vatarasaesiu ara, poni sa muna isongo betoria ao mana veinigo sira dorudi pira,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Poni sa oea i Jisu sisa, pira saunia, <<Ba pira tu sau sa na Kukuti Tabuna, <Na Bangara na mua Tamasa mu vatarasaea, beto ko isa gu mekana mu nabulunia,> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ego beto sa sa toni laonia na bangaradi na tomate pa Jerusalema si Jisu, ko sa toni kesa vaturua pa babanana na kakabarena zelepade, beto pira saunia, <<Vei muna Tuna na Tamasa sao, sa mu koko lani mu soqolo gore. ");
INSERT INTO lga_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ura sa paranga na Kukuti Tabuna, <Na Bangara mina garunuria sira na ona mateana ko mai kopu vasarego. ");
INSERT INTO lga_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Beto ko mai kalogo ira pa limadi ko maike isongo paleka podeke pa papatu sira na nenemu,> sau,>> sau sa na bangaradi na tomate. ");
INSERT INTO lga_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Poni sa oea i Jisu sisa, pira saunia, <<Pira tu sau sa na paranga pa Kukuti Tabuna, <Muke podeke vagonai na Bangara na mua Tamasa,> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ego ko pa liguna sa vaokotoria na bangaradi na tomate sira doru ona totoke, sa sa taloa riu gu mai tinganai sa kamua mule kai totoso jongana. ");
INSERT INTO lga_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ego totonai sa beto doru ginugua pira sa sa mule laona pa Qalili si Jisu, ko na neqi tana Gagala Tabuna sa sa kole tana. Ko na nongorona isa sa sa tapiara lekogo pa doruna na ia ketakoi. ");
INSERT INTO lga_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ko sa vavaivagigalai sisa pa okokoto ruma vavaikamuna ketakoi, ko qai vatarasae betoa ira doru tinoni sisa. ");
INSERT INTO lga_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Beto sa sa mule lao pa Nazareti si Jisu, isa na gusu ketakoi sa lavata sae. Ko pa rane Minere sa lao somana pa ruma vavaikamuna sa vevei tugu doru totoso. Ko totonai sa turu sisa ko sa tiroa na Kukuti Tabuna. ");
INSERT INTO lga_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Na buka sa kolea na paranga ti Aisea na tinoni kokorotai sa qai valao vania ira, ko sa viloto revatia isa sa ketakoi qai takuti vakole ira na paranga qai poja vei pira ko sa tiroa, ");
INSERT INTO lga_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","<<Na Gagalana na Bangara sa sa kole taqu, ura sa vilesiu isa sara ko mana taraenia na nongoro jongana tadira qai golaba. Sa garunusiu isa sara ko mana ule votunia na toa taruvatana tadira qai tapiu, beto na revangana na matadi ira qai leqa, ko mana ruvataria ira qai nganganguluria ira na tinoni, ");
INSERT INTO lga_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","beto ko mana taraenia ara na totoso mina aloria na tinoni na Bangara,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Beto sa sa polo vijongo beia isa sa na Kukuti Tabuna ko sa vamule lao vania na nabulu kopu, beto sa toqo ko mi podalai vaivagigalai tadira na tinoni sau. Ko qai doro vatotogasia ira doru tinoni pa leo ruma vavaikamuna, ");
INSERT INTO lga_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","sa sa paranga sisa, <<Pa rane pa ngeni tugu api sa sa gore votu sa na Kukuti Tabuna qu koni nongoria ina!>> sau. ");
INSERT INTO lga_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ko qai paranga vasae betoa ira doru sisa beto qai gabarania ira sira doru ona paranga vavagegoaidi sa paranga votuniria isa. Ko qai kole paranga vei pira sira, <<Bi goto sakeu ko na tuna gu i Josepa sina, oko!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Poni sa pira sauniria sira, <<Qa gigila vataleaqua ara sa kode muna gona lamenia agou taqu sa na paranga vei api, <Ao na tino vaisalana mu salana mulenigo moko! Ira na sakasava qe nongoroniria qu roitiniria pa Kepaniami sa mu roitiniria lani pa mua gusu ketakoi qu lavata sae!> munagunisiu,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Beto pira sau, <<Ma poja sosotonigou ara sagou: na tinoni kokorotai sa sake tavalavata pa nona gusu ketakoi sa lavata sae. ");
INSERT INTO lga_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na sosotona sa ma pojanigou agou. Pa totoso tai Elaija sa na motadi tugu sira na nanaboko qai suvere pa Izireli pa kue aoro kobuna tonai kepore na okoro, beto ko tonai sa raja na songe lavata pa doruna na ia ketakoi. ");
INSERT INTO lga_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ba na Tamasa sake garunu laonia tana kame ira pira pa Izireli si Elaija, goto sa tagarunu laonia tu tana kai nanaboko pa gugusu pa Sarepata, kai gusu pa pikata gugusu pa Sidoni sisa. ");
INSERT INTO lga_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Beto ko pa totoso tai Elaisa na tinoni kokorotai sa qai motadi sira na tinoni popoqudi qai korapa suveredia tugu pa Izireli, ba kepore sa kame ira bi tataloso valioso, goto i Neamani na tinoni pa Siria gu,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ko totonai qai nongoria ira doru tinoni pa leo ruma vavaikamuna sisa vei inara sa qai tagigiri vivikereniria. ");
INSERT INTO lga_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ko qai gasa turu ko qai lao ragata votunia pa peguruna na gusu sisa, beto ko qai toni sagere saenia pa narena na kubo ketakoi sa taroiti na dia gugusu, ko mai juju vatitolo palea pa taba qarigu. ");
INSERT INTO lga_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ba sa rerege sulopo votu riuona pa vaikorapai vaikamu tinoni lavata sisa ko sa riuona. ");
INSERT INTO lga_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ego i Jisu sa gore pa Kepaniami kai gugusu pa Qalili, ko sa lao vaivagigalai tadira na tinoni pa rane Minere. ");
INSERT INTO lga_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Qai gabara betonia ira doru sa nona vaivagigalai, ura sa somania na neqi sa na ona paranga sa parangania isa. ");
INSERT INTO lga_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ego pa leona na ruma vavaikamuna isa sa sa korapa sa kai tinoni sa kolea na gagalana na tomate ikikerena. Ko sa uui votu sisa, pira sau, ");
INSERT INTO lga_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","<<Kei! Na sa qu nyorogua roitinia tamigei sao Jisu pa Nazareti? Qu lame ko mu piaragei agei qugu? Qa gigilagoqua ara sao! Ao sa na Liosona tana Tamasa!>> sau. ");
INSERT INTO lga_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Poni sa tokea i Jisu sa na tomate ikikerena isa, <<Ao mu noso ko mu votu riu tana tinoni ina!>> saunia. Poni sa vavukelia na tomate ikikerena sa na tinoni api pa moedi ira na tinoni, beto sa sa riuona sisa, ba kepore tugu kamea bi veinia sa na tinoni api. ");
INSERT INTO lga_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ko qai gabara beto sira doru tinoni, ko qai vavaiparanga vei pira, <<Na paranga sa pu vei pira! Sa kolea na neqi sa na tinoni api, ko tonai sa iju paleria isa sira na tomate ikikeredi tana tinoni poni sa qai votu riudia tugu,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ko na nongorona i Jisu sa sa tapiara lekogo pa doruna na ia pa vailivutaina ketakoi. ");
INSERT INTO lga_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ego totonai sa taloa pa ruma vavaikamuna si Jisu poni sa lao pa ruma tai Saimone. Ko na qoqoele roana i Saimone sa sa vakamunia na mo mangini lavata, ko qai lao pojania si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Poni sa lao turu pa kekerena na rereko sa mo si Jisu, ko sa tokea sa na mo mangini poni sa taloa tana sa na mo. Ko pa totoso tugu isa sa tatakole sa na rereko isa ko sa vatanaria sira. ");
INSERT INTO lga_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ego totonai sa suvu na tapo sa qai totoni kamuniria ira ketakoi tai Jisu sira na tinoni sa vairia na okokoto vagauru. Ko sa vaoponiria na limana isa sira, ko sa salana betoria. ");
INSERT INTO lga_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ira na tomate ikikeredi ba qai okoto votu taloadia tadira na tinoni ko qai uui, pira qarigu, <<Ao tugu sa na Tuna na Tamasa!>> qarigu. Ba sa tokeria i Jisu sira na tomate ikikeredi, beto ko sake vamalumuria ko bai paranga, ura qai tei gigilaidia tugu ira sa isa sa na Karisito. ");
INSERT INTO lga_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ego totonai sa vuvugei rane neqa sa sa taloa pa gugusu isa si Jisu, ko sa lao pa kai ia kaloina. Ba qai lao tugu nyaqo tututia ira na tinoni sisa, ko qai lao tugu batia, beto qai aru vasuveria ko mike loaria sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ba pira sauniria sira, <<Tadira kaki goto gugusu sa ara ba mana taraenia tugu sa na nongoro jongana veveina na binangara tana Tamasa, ura isa tugu sa sa garunu lamenisiu ara na Tamasa ko mana roitinia,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ko sa kole tarae pa ruruma vavaikamuna tadira na tinoni pa Jiudia si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ego kai rane totonai sa korapa turuona pa poanana pa nole pa ovuku Qenesareti si Jisu, sa qai vaijujuku upupele lao tana sira na minete tinoni, ko mai nonongorodia pa paranga tana Tamasa qarigu. ");
INSERT INTO lga_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ko sa doro vairia isa tonai sa karu koaka qai korapa titidia pa keketai ovuku. Goto ira na tinoni abu poredia koaka sa qai korapa valiosoria na dia vaqara. ");
INSERT INTO lga_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ko sa lao koia isa sa kame, isa na koaka tai Saimone, beto sa sa garunia si Saimone ko mi iolo sae iqona pa kolona saunia. Ko sa toqo ketakoi si Jisu beto sa sa kole vaivagigalai paro tadira na minete tinoni. ");
INSERT INTO lga_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ego tonai sa beto parangaria na minete tinoni sa pira saunia i Saimone, <<Mu vaiolo jola saea pa lilisina sa na koaka, beto sa mu gonania ketakoi sa na miu vaqara,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Poni sa paranga si Saimone, pira sau, <<Qokolo! Qe tei pavu talea tu na bongi doruna sagei, ba kepotu kai tea sa be tekuamei! Ba qu paranga ao, ko jongana ara ma lao tu ropi vagorea sa na vaqara,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ko totonai qai ipa gorenia na vaqara sa sa vaivagabara sa na igana qai gona, ko na vaqara ba iapeki bi taraqama tu. ");
INSERT INTO lga_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ko qai sipu laoria sira na tavitidi pa kai goto koaka ko mai lame tokaniria qarigu. Ko qai mekarai vapugeleniria na igana ira sa karu koaka ira, ko iapeki bai dururu tu. ");
INSERT INTO lga_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ego totonai sa batia i Saimone Pita sa na roiti sa podo vei pira, sa sa lao toqo sori tutungu sisa pa moena i Jisu, beto pira sau, <<Mu taloa taqu Bangara, ura na tinoni sela sara!>> sau. ");
INSERT INTO lga_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ura sa gabara vivitiginia i Pita beto ira doru qai tutia isa sa na koi vei motadi na igana qai tekuria. ");
INSERT INTO lga_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ko ira na tino abu tavitina i Pita, ira Jekopi i Jone (karu tuna marene i Zebeti) ba qai gabara tugu. Poni sa pira saunia i Jisu si Saimone, <<Muke matagutu! Podalai kopira sa muna abu tinoni sao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ko pa liguna qai juju vaparoria sa na dia koaka, sa qai loa vakole beto paleria sira doru dia sakasava ko qai tutiadia ira si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ego kai totoso tonai sa korapa suvere pa kai gugusu si Jisu, sa api kai tinoni sa udea na popoqu. Ko totonai sa batia isa si Jisu, sa sa gona opo goreni pa peso na isumatana, ko sa tepa vivitigi, pira sau, <<Bangara, vei muna malumu ao, sa muna boka taloso valiososiu gu sara!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Poni sa kaqamania na limana ko sa ulia i Jisu sisa, beto pira sau, <<Qa malumu gu sara, ko mu lioso tu ao,>> saunia. Ko pa totoso tugu isa sa tataloso valioso tana sa popoqu. ");
INSERT INTO lga_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Beto sa sa paranga vabalaua i Jisu sisa, <<Munake lao vavavakatonia tadira tinoni sapi, goto mu rerege tuvisi lao gu tana iama ko mi doro vivilotigo. Pa liguna isa sa muna lao roitinia na vavakukuvu vuvulasa isa vei sa vaigarununia i Mosese, ko mai vasosotoa ira na tinoni sa qu tei tavalioso tu sao marigu,>> saunia sisa. ");
INSERT INTO lga_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Beto tonai sa sake mako gore na lekogona sa na nongorona i Jisu, ko ira na minete tinoni sa qai vavaikamu lao tana ko mai nonongorodia beto mai tasalanadia pa okoto dia vagauru qarigu. ");
INSERT INTO lga_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ba sa tuturu rijo riuona pa qega si Jisu ko sa kokole vavaraona. ");
INSERT INTO lga_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ego kai rane totonai sa korapa vaivagigalai si Jisu, sa na suveredi tugu ketakoi sira kaki Parese beto ira qai vaivagigalainia na Vavanau, na lame veidi pa okoto gugusu pa Qalili, pa Jiudia, beto pa Jerusalema. Ko na neqi tana Bangara sa tei koleona tu tai Jisu ko mina boka vaisalana. ");
INSERT INTO lga_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ego ko api qai pala kamunia ira kaki tinoni pa nona lovu sa kai tinoni sa mate kale tinina, ko qai popodeke ko mai pogoso tomenia pa leo ruma, ko mai vakolea pa moena i Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ba qaike boka batia ira sa na soana vei beto mai pala tomenia, ura qai pugele sira na tinoni. Ko qai poso kesa saenia pa nare ruma ko qai kakelia sa na arena na ruma, beto qai vasikulu gorea pa vaikamu tinoni pa moena i Jisu sa na tinoni isa tonai sa korapa koleona tugu pa lovu. ");
INSERT INTO lga_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ko totonai sa batia i Jisu sa na dia rarange, sa sa parangia isa sa na tinoni sa mo, <<Qua tinoni, qai tei taleoso tu sira na mua sela,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Poni qai podalai vaipera paranga mekadi sira qai vaivagigalainia na Vavanau beto ira na Parese, <<Ai tinoni veveina sapi! Sa korapa vamoroania na Tamasa sa na tinoni api! Kepore sa kai tinoni mina boka taleosonia na sela, goto mekana gu na Tamasa!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ba sa tei livutia tu i Jisu sisa vei qai kole vaiperani paranga ira, ko pira sauniria, <<Na sa sa qu kole vaiperania pa bulomiu agou? ");
INSERT INTO lga_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ai sa sa munyala na pojana? <Qai tei taleoso tu sira na mua sela!> biu, ba <Mu tatakole ko mu rerege!> biu? ");
INSERT INTO lga_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ba ma vadogoronigou ara sa na Tuna na Tinoni sa poreona neqi pa peso ko mina taleosoniria na sela,>> sau. Beto sa pira saunia sa na tinoni sa mate kai kale tinina, <<Qa parangigo ara sao, mu turu, mu pogosia na mua lovu, ko mu mule laomua pa mua ruma!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Poni pa totoso tugu isa sa gasa turu pa moedi ira doru tinoni sa na tinoni api, sa posia nona lovu isa sa kolea, ko sa mule riuona pa nona ruma, beto sa vatarasaea isa sa na Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ko qai gabara beto sira doru tinoni totonai qai batia sa vei inara. Qai vatarasaea ira sa na Tamasa, beto qai matagutu tugu vei ko qai vavaiparanga, <<Koi, na sakasava vaivagabaradi sa taqe batiria gita pa ngeni!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ego liguna isa sa sa taloa ketakoi si Jisu, ko sa lao dogoria sa kai tinoni teteku takisi na isongona i Livai, sa korapa toqona pa ruma teteku takisi. Ko sa parangia i Jisu sisa, <<Lame tutisiu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Poni sa turu loa paleria tugu i Livai sa doru ona sakasava, ko sa lao tutia si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Beto sa sa roitinia i Livai pa nona ruma sa kai vavolo lavata ko sa teteku tavitia si Jisu. Ko na motadi sira na tinoni teteku takisi tavitina beto ira kaki tinoni mule qai tasoru ko qai somana teteku. ");
INSERT INTO lga_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ba ira na Parese beto ira na dia tinoni qai vaivagigalainia na Vavanau sa qai ququminiria sira na sepele ti Jisu, ko pira qarigu sira, <<Ai sa vei ko qu teteku tavitiria tu ira na tinoni teteku takisi beto na tinoni seladi sagou?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Poni sa oeria i Jisu sira, pira sauniria, <<Ira na tinoni toa vajongadi sa qaike nyaqoa sa na tinoni sa vavaisalana, goto ira gu qai mo. ");
INSERT INTO lga_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Qake lame sara ko ma kukuria na tinoni tuvisidi qau, goto ira tu na tinoni seladi ko mai gabala qau!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Beto sa qai nanasia ira na Parese beto ira na dia tinoni qai vaivagigalainia na Vavanau si Jisu, pira qarigunia, <<Ai sa vei ko ira na sepele tai Jone beto ko ira na sepele tadira na Parese sa qai tatabu gagani beto qai vavara soku totoso, goto ira na sepele tamu sa qai kole gu teteku beto buku laodia gu?>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Poni sa pira sauniria i Jisu, <<Ai vei, muna boka vatatabu gaganiniria tu sira na tinoni tasorudi mai somanania na vavolo vaialava totonai sa korapa suvere tavitiriaona na tinoni vaialava? Dai! ");
INSERT INTO lga_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ba qai korapa lame sira na rane tonai mina tateku varijo tadira sa na tinoni sa vaialava. Ko pa totoso tu isa sa mai tatabu gagani sira,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Beto sa pojaniria mutugu i Jisu sa na vinakabere api, <<Kepore sa kai tinoni mina boka rikata tekua kai rikata poko koregana, ko mina piti valaonia pa kai poko leluna. Mina roiti vei sa kode mina tarikata sa na poko koregana, beto ko na poko leluna sa minake lao totoa sa na poko tutuvaka koregana. ");
INSERT INTO lga_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Beto kepore mutugu sa kai tinoni mina toto laonia na vaini koregana sa na tototona vaini leluna. Ura mina taroiti vei sa kode mina tapokataona sa na tototoni vaini leluna ko mina tavuva vikereona sa na vaini, beto ko na tototoni vaini ba mina taaru vikere tugu. ");
INSERT INTO lga_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Goto na vaini korega sa mina tatoto valao tugu pa tototona koregana. ");
INSERT INTO lga_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ko kepore sa kai tinoni sa bubuku vaini leluna bi nyogua bukua sa na vaini koregana. Ura sa paranga sa na tinoni isa, <Na vaini leluna tu sa sa giropo!> sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ego pa kai rane Minere tonai sa rerege jola lao vei pa leo inuma vuiti si Jisu beto ira na ona sepele, sa qai kole raravusu teku kiko vuiti sira na ona sepele, ko qai ngaja gaganigadia. ");
INSERT INTO lga_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Poni kaki ira na Parese qai nanasaria, <<Ai sa vei sa qu roitinia tu na roiti sake tavamalumu pa rane Minere?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Poni sa oeria i Jisu sira, <<Beko qu tei tiroamiu tu agou sa na roiti qi roitinia i Devita pa moa, ba qu oqoro tu vakaberia sa? Totonai qi burana si Devita beto ko ira na ona tinoni qai tutia, ");
INSERT INTO lga_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","sa qi tome lao sisa pa leona na ruma tana Tamasa, ko qi tekua isa sa na bereti madina ko qi gania beto qi vaniria tugu vei sira na ona tinoni. Ba kepore kai tinoni qi tavamalumunia ko mina boka tekua sa na bereti isa, goto ira na iama gu,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Beto sa parangaria i Jisu sira, <<Na Tuna na Tinoni sa na bangarana na rane Minere,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ego pa kai rane Minere mule tonai sa tome pa kai ruma vavaikamuna si Jisu sa sa korapa suvereona ketakoi sa kai tinoni sa raiqo na lima kale matuana. ");
INSERT INTO lga_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ko ira qai vaivagigalainia na Vavanau beto ira na Parese sa qai nyaqoa kaki soana ko mai jutunia sa sela si Jisu qarigu, ko qai kole dodoro kopu totonia sa vei mina salana tinoni tu beka pa rane Minere sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ba sa tei gigilaria tu i Jisu sira na dia roroqu, ko pira saunia sa na tinoni sa raiqo kai kale limana, <<Mu turu, ko mu rerege lame pa korapa,>> saunia. Poni sa gasa turu sa na tinoni isa ko sa lao turu ketakoi. ");
INSERT INTO lga_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Beto pira sauniria i Jisu sira na tinoni, <<Ego ma nanasagou ara agou. Ai sa sa vamalumia na Vavanau ko mina boka taroiti pa rane Minere? Na roitinia na jongana, ba na roitinia na ikerena? Na aloa na toa, ba na piara pale?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Beto sa kole doro vailivutainiria isa sira doru beto sa sa pira saunia isa sa na tinoni, <<Mu radonia na limamu!>> saunia. Poni sa sa radonia tugu, ko sa jonga ligu sa na limana isa. ");
INSERT INTO lga_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Totonai sa qai tagigiri vivitigi sira, ko qai kole vavaivavakatonia mekadi ira sa na sa mai boka roiti laonia tai Jisu qarigu. ");
INSERT INTO lga_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ego ko pa kai totoso sa sa sagere sae pa kai kubo si Jisu ko sa vavara. Ko sa suvere na bongi doruna pa batu kubo sisa ko sa kole vavara lao tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ko totonai sa vuvugei rane neqa sa sa kuku tekuria sira doru ona sepele ko sa vile tekuria isa sira ka manogarua ko ira sa sa kukuniria na tinoni tagarunudi. ");
INSERT INTO lga_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ko aipira sira sa vileria isa: i Saimone isa sa vakukunia i Pita beto i Aduru na tasina, ira Jekopi i Jone, i Pilipi i Batolomiu, ");
INSERT INTO lga_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ira Matiu, i Tomasi, i Jekopi na tuna i Alepiasi, beto i Saimone isa perangana na somanana mai tadira qai nyorogua adu palea na qavuna pa Romu, ");
INSERT INTO lga_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","i Jiudasi na tuna i Jekopi, beto i Jiudasi Isikarioti isa na tinoni sa gabala kanai i Jisu. ");
INSERT INTO lga_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ego totonai sa mule gore pa kubo tavitiria ira na ona tinoni tagarunudi si Jisu poni sa turu tavitiria isa pa kai ia ararena sira soku ona sepele. Ko na minete tinoni lavata sa tei korapa tu ketakoi, ira na lame veidi pa doru ia pa Jiudia, pa Jerusalema, beto ko vei tugu pa gugusu babatana pa Turosi beto pa Sidoni. ");
INSERT INTO lga_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ira na tinoni sa qai lame ko mai nongoria isa beto mai tasalanadia pa okoto dia vagauru qarigu. Ko ira sa koleria na gagala ikeredi ba qai tasalana tugu. ");
INSERT INTO lga_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ko ira doru sa qai kole popodeke vivitigi ko mai ulia sisa ko mai tasalanadia qarigu, ura na neqi sa votu tana ko soku tinoni qai tei tasalana tu. ");
INSERT INTO lga_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ego sa doro laoria na ona sepele si Jisu ko sa paranga, <<Qu tamana sagou qu golaba, ura tamugou sa na binangara tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Qu tamana sagou qu burana kopira, ura agou sa kode muna tavapote vatale. Qu tamana sagou qu lukana takulanga kopira, ura kode muna avu qeqera sagou. ");
INSERT INTO lga_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Qu tamana sagou tonai maike tavaraguanigou ira na tinoni beto tonai mai ijugou, mai poja vivikeregou, beto mai jutunigou na tinoni ikikeremiu pa ginuana qu tutia na Tuna na Tinoni. ");
INSERT INTO lga_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mu qera ko mu soqolo qeqera tu sa pa totoso isa, ura vainongoro! Na lavatana jola sa na miu pinia pa noka. Na roiti ngangangulu vei tugu inara sa qai roitinia ira na boko tamadi lao tadira na tinoni kokorotai pa moa. ");
INSERT INTO lga_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Goto agou na tinoni isisongo sa mu takulangagamiu tu, ura qu tei tekua tu agou sa na toa jongana. ");
INSERT INTO lga_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mu takulangagamiu tu sagou qu pote vatatalegamiu kopira, ura koleona sa na totoso muna burana sagou. Mu takulangagamiu tu sagou qu avavu kikidolo kopira, ura koleona sa na totoso tonai muna lukana takulanga sagou. ");
INSERT INTO lga_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mu takulangagamiu tu sagou tonai mai paparanga vatarasaegou ira doru tinoni, ura ira na tamadi ba qai roiti veiniria tugu sira na tinoni kokorotai sesekedi pa moa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","<<Ba ma pojanigou sagou qu nongorosiu ara: mu roroquria sira qai kanagou, mu roiti vajongana lao tadira qaike tavaraguanigou, ");
INSERT INTO lga_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","mu tepa vaniria na mana sira qai lelevenigou, beto mu vavara tokaniria sira qai ngangangulugou. ");
INSERT INTO lga_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bi tapalia kai kale paparamu sa kai tinoni, sa mu tale lao vania mule kai kalemu. Bi tekua na mua koti sa kai tinoni, sa muke suqutia ko mi tekua mutugu sa na mua soti. ");
INSERT INTO lga_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Na tinoni sa tepanigo na sakasava sa mu iai, na tinoni sa teku variunigo kai mua sakasava sa muke tepa mulenia. ");
INSERT INTO lga_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ko isa tugu vei qu nyoroguania ko ira na tinoni mai roiti lamenia tamugou sa isa tugu sa mu roiti laonia tadira na goto tinoni. ");
INSERT INTO lga_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Vei muna roroqu kakaleria gu agou sira qai roroqugou, sa kita mu kole roroqua kode muna tekunia na mana sa na roiti vei isa! Ura ira na tinoni seladi gu ba qai roroquriadia tugu sira qai roquria. ");
INSERT INTO lga_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Vei muna roiti kakale vajongana lao tadira gu qai roiti vajongana lame vanigou, sa kita mu kole roroqua muna tekunia na mana agou sa vei isa! Ura ira na tinoni seladi gu ba qai roiti vajongana lao tugu sa tadira na tinoni qai roiti vajongana lao vaniria. ");
INSERT INTO lga_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ko vei tadira gu qu gigilai kode muna boka teku muleniria na miu sakasava sa qu vamalumuria ko mai sasareniria na miu sakasava, sa kita mu kole roroqu muna tekunia na mana agou sa sa vei inara! Ura ira na tinoni seladi gu ba qai bokadia vasasareria ira na tinoni seladi vei ko mai teku muleniria sira na padana tugu isa vei qai valaoa qarigu. ");
INSERT INTO lga_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ba agou sa muke roiti vei inara! Mu roroquria tu sira qai kanagou, beto mu roiti vajongana lao tadira. Mu vaniria gu sisa na manugu mai tekua gu mai qarigunigou beto muke kole roqu totonia sa na miu sakasava isa. Muna vei sa kode mina lavatana jola sa na miu pinia pa noka beto ko tonai sa qu roiti vei na boko koburu tana Tamasa ululu jolana sagou. Ura na Tamasa sa roroqu betoria gu sira qaike boka paranga jongana lao tana beto ira na tinoni ikikeredi. ");
INSERT INTO lga_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Na Tamasa sa roroquria beto sa roiti vajongana lao tadira doru tinoni, ko agou ba mu roroquria beto mu roiti vajongana lao tugu tadira doru tinoni,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","<<Muke pituria na sela tadira na goto tinoni, ko mike pitugou na Tamasa. Muke jutu tariniria na vaituti tana Tamasa sira na goto tinoni, ko agou ba muke tajutu tarinigou tugu sa na vaituti tana Tamasa. Mu taleosoniria na goto tinoni, ko na Tamasa ba mi taleosonigou tugu. ");
INSERT INTO lga_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mu ia vataleria na tinoni, ko mi ia vatalegou na Tamasa. Isa mina ianigou isa sa na ia nabuna, mina vei na boko kiko bou sa tasaqiti ko sa tanyonyoqoro vatale ko sa pugele nyonyoa beto qu tinu boborua na miu. Ura isa tugu na pada qu ia vatale veiniria ira na goto tinoni, poni sa isa tugu mina ia vatale veinigou sa na Tamasa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Beto isa sa sa pojaniria mule i Jisu sa na vavakato vavapada api, pira sau, <<Na tinoni sa leqa sa minake boka tonia sa kai goto tinoni leleqana. Vei mina tonia sa kode mai mekarai vukele jolopo pa kai pou sira karu. ");
INSERT INTO lga_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Na sepele sa sake poreveveina jolania na ona tinoni vaivagigalai. Goto totonai mina vakoititi vataleria mai tu na sepele sira na vaivagigalai tana ona tinoni vaivagigalai sa beto sa mina kamua sa na boboka tana ona tinoni vaivagigalai. ");
INSERT INTO lga_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ai sa vei ko qu juno dogoria tu ao sa na opopu pa matana na tasimu, ba na lomoto kokobu pa matamu mekamu sa quke pavu galania? ");
INSERT INTO lga_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ai sa vei ko qu boka paranga veinia tu pira na tasimu, <Tasiqu, mei! Ma kasi pale na opopu pa matamu,> qugu tu? Ba na lomoto kokobu pa matamu quke batia! Na tinoni vavabatamu na sesekemu sao! Momoe mu kasi pale mai sa na lomoto kokobu pa matamu, beto sa muna babata vatale ko muna boka kasi pale sa na opopu pa matana na tasimu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","<<Na gou jongana sa sake vuania na vua ikerena, beto na gou ikerena sa sake vuania na vua jongana. ");
INSERT INTO lga_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Doru gou sa qai tagigila na jongadi babi na ikeredi tonai tana doria na vuadi. Munake boka lokete teku vua gou piqi sao pa gou vavaiokana, beto ko munake boka teku vuvungu qurepi sao pa gasoro vavaiokana. ");
INSERT INTO lga_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Na tinoni jongana sa sa vavoturia sira na uana jongadi qai kole pa bulona ko sa roitinia na roiti jongana, goto na tinoni ikikerena sa sa vavoturia na uana ikikeredi qai kole pa bulona ko sa roitinia na roiti ikikerena. Ura isa tugu sa pugele nyonyoa pa bulona na tinoni sa sa taparanga votunia pa mangana,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","<<Ai sa vei ko qu kukunisiu, <Bangara! Bangara!> ara sagou, beto quke tutiria isa vei qa pojanigou ara? ");
INSERT INTO lga_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Isa sa lame taqu ko sa vainongoroniria na qua paranga beto sa vataberia, sa ma ule vanigou ara ai tinoni veveina sisa. ");
INSERT INTO lga_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Na tinoni isa sa sa kai muqisi podeke vei na tinoni sa roitinia na ona ruma, sa kori valolu gore ko tinganai sa kamua na patu beto sa vatoqoa isa sa nona kokovana ruma, beto sa sa vaturua sa nona ruma. Ko totonai sa gore na qolapeso, sa nyoro na pie ko sa raja pa ruma isa ba sake boka jou kanoko sa na ruma isa, ura sa tapatu biti vamauru pa patu sisa. ");
INSERT INTO lga_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ba isa na tinoni sa nongoriaona tugu sa na qua paranga ba sake vataberia, sa sa kai muqisi podeke vei na tinoni sa roitinia na ona ruma pa peso munyalana kepore patu bitina sisa. Ko totonai sa gore na qolapeso, sa nyoro na pie ko sa raja pa ruma isa, sa sake ruavo tugu vukelena sa na ruma isa, ko sa tajegara pipiara betona!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Totonai sa beto pojaria i Jisu sira doru sakasava aipira tadira na tinoni, sa sa taloa lao pa Kepaniami sisa. ");
INSERT INTO lga_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ego na suverena tugu ketakoi sa kai tinoni mamata gogoto. Ko koleona sa kai ona nabulu isa sa roroqu vivitigia isa sa mo ko sa tata mate. ");
INSERT INTO lga_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Totonai sa nongoronia na tinoni mamata gogoto api sa na veveina i Jisu, sa sa garunuria isa sira kaki iviva tadira na tinoni Jiu ko mai lao tepai si Jisu ko mi lame salania na ona nabulu sau. ");
INSERT INTO lga_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ko tonai qai kamu sira tai Jisu sa qai tepa totokai sisa, pira qarigu, <<Na bangara api sa sa garo tugu muna lao tokania ao. ");
INSERT INTO lga_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ura isa sa roroqugita sa gita na tinoni Jiu beto isa tugu mekana sa roiti vanigita sa na oda ruma vavaikamuna,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ego jongana sau si Jisu ko sa tuti laoria sira. Ba totonai sa tata kamua gu isa sa na ruma, poni sa sa garunuria na tinoni mamata gogoto api sira kaki ona baere ko qai lao poja veinia pira si Jisu, <<Bangara, kita mu kole pavu goboro. Ara nake padaqu ko ao muna lame tome pa qua ruma. ");
INSERT INTO lga_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ko sa vei tugu isa sa ara ba qake doro vapadanisiu ko mana lame tamu! Goto mu leve lamenia gu tana sa na salana ko mi toaona sa na qua marene. ");
INSERT INTO lga_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ura ara ba ira tugu na tinoni sa koleria na neqi qai kopunisiu beto koledia mutugu sira na tinoni vaipera qai takopu pa neqi taqu, ko ara qa gigilaiqua sa ai sa vevei tonai sa isongo neqi na tinoni. Ko vei, <Lao ao!> baunia ara sa kame, poni sa sa lao gu sisa. Beto vei, <Lame!> baunia mule ara sa kame, sa sa lame tugu sisa. Vei pori mu vei qaunia na qua nabulu, poni sa sa roitinia tugu sisa. Goto ao na mua neqi sa na lavatana jola ko muna paranga gu lani, poni kode mina tasalana tugu kopira sisa,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Totonai sa nongoria i Jisu na paranga tana tinoni mamata sa vei inara sa sa gabara, ko sa gabala ko sa paranga laoria isa sira na minete tinoni qai tutia, <<Ma poja vatalenigou ara sagou: qa oqoro isongo batia ara pa Izireli sa kai tinoni sa isongia na rarange lavatana jola vevei tana tinoni api,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Beto sa qai gabala mule lao pa ruma tana tinoni mamata sira ka visa qai pogoso nongoro, ko qai lao kamu sa qai batia sa na nabulu sa tei tasalana tu. ");
INSERT INTO lga_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ego sa oqoro sovai gu sa jola sa vei inara sa sa taloa lao pa kai gugusu na isongona pa Neini si Jisu. Ko ira na ona sepele beto ko kai minete tinoni lavata sa qai tutia isa. ");
INSERT INTO lga_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ko isa tugu sa tata kamua na atakamanana na gugusu lavata isa, poni sa qai pogoso bola lamenia gu ira sa kai tinoni sa mate ko mai riu golomia qarigu. Na tinoni sa mate isa sa isa tugu kai tuna memekai kai nanaboko. Ko kai minete tinoni lavata pa gugusu lavata isa sa qai tutia votu na nanaboko. ");
INSERT INTO lga_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ego totonai sa doria na Bangara sa na naboko api sa sa roroqu vivitigia, ko pira saunia, <<Muke lukana!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Beto sa rerege lao ko sa arua sa na kokobu tomate taudena, ko ira qai pogosia na kokobu tomate sa qai turu noso. Beto sa paranga laoa isa sa na tinoni matena, <<Koburu marene korega, ara qa parangigo sao ko mu tatakole!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Poni sa toa mule ko sa tatakole toqo sa na tinoni sa mate ko sa podalai paranga. Beto sa sa toni laonia i Jisu tana na tinana sa na tinoni api. ");
INSERT INTO lga_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Qai matagutu beto sira doru, ko qai vatarasaea ira sa na Tamasa, pira qarigu, <<Kai tinoni kokorotai lavata sa sa kamugita beto na Tamasa sa sa lame ovikiria ko mi aloria na ona tinoni sau,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ko isa na nongorona na roiti sa roitinia i Jisu api sa sa tapiara lekogo pa doru eqa pa Jiudia beto ko tadira doru gugusu pa vailivutaina na ia isa. ");
INSERT INTO lga_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ego totonai qai vavakato vania ira na ona sepele si Jone sa na veveidi doru roiti sa roitiniria i Jisu, sa sa kuku tekuria isa sira karu ona sepele ");
INSERT INTO lga_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ko sa garunu laoniria tai Jisu ko pira mai nanasa veinia sauniria, <<<Ao tugu sa isa qai rorovenia na tinoni sa korapa lalameona qarigunia? Ba kai goto tu sa mene verania agei?> munagunia,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ko tonai qai lao kamu sira karu tai Jisu sa qai nanasia sisa, <<Sa garunugei i Jone Paputaiso sagei karu ko pira muna nanasa veinia saunigei, <Ao tugu sa isa qai rorovenia na tinoni sa korapa lalameona qarigunia? Ba kai goto tu sa mene verania agei?> sau,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ego totonai tugu qai korapa suveredia ira karu sa i Jisu sa salanaria sira na kubo tinoni qai mo beto qai gosororia na vagauru, beto ko ira qai rajaria na tomate ikikeredi. Beto kubo ira qai leqa sa sa vababataria isa. ");
INSERT INTO lga_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ko sa oeria isa sira karu tinoni pogoso nongoro tai Jone, pira sauniria, <<Mu mule lao ko mu vavakato vania i Jone sira vei qu batiria beto qu nongororia. Ira na leqa sa qai babata, ira na qao qai rerege, ira na popoqu sa qai tataloso valioso, ira na kiqili sa qai tavonga, ira qai mate sa qai tavatoa mule, beto ira na golabadi qai tekua na nongoro jongana. ");
INSERT INTO lga_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Qai tamana sira qaike tatupe talenisiu ara, mugunia,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pa ligudi qai mule riu sira na sepele tai Jone, sa sa podalai vavakatonia i Jisu tadira na minete tinoni sa na veveina i Jone. Sa paranga sisa, <<Totonai qu lao pa qega ko mu dogoria i Jone qugu sagou, sa na sa sa mu lao dogoria qugu? Kai tinoni sa mamalei vei na equru buburu sa jou vakakanokia na gava? Dai ke! ");
INSERT INTO lga_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ko na sa tu sa qu nyogua lao dogoria agou? Kai tinoni sa popokoniria na poko babata jongadi? Ba ira na tinoni qai popoko vatale vei inara sa qaike susuvere pa qega, goto qai kole gu susuvere vatataledia pa ruma tadira na bangara! ");
INSERT INTO lga_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ego ko na sa sosoto sa vei qu nyogua lao doria agou? Kai tinoni kokorotai? E, sosoto na tinoni kokorotai tugu sisa, ko sa poreveveina jolaniria ira na tinoni kokorotai sisa. ");
INSERT INTO lga_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Api sa sa pojai na Kukuti Tabuna na veveina isa, pira sau, <Doro! Ara qa garunu laonia pa moemu ao sa na qua tinoni pogoso nongoro. Isa sa mina vatana momoea sa na soana tamu,> sau. ");
INSERT INTO lga_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ma poja vatalenigou ara sagou: kepore sa kai tinoni sa podo lame pa kasia gusu api bi poreveveina jolania i Jone, ba isa tu sa kepore veveina jola pa binangara tana Tamasa sa sa poreveveina jolania si Jone,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ko tonai qai nongoria i Jone poni sa ira doru tinoni beto ko ira na tinoni teteku takisi qai vasosotoa sa na Tamasa sa tuvisi qarigu, ko qai tapaputaisodia tana. ");
INSERT INTO lga_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Goto ira na Parese beto ira qai vaivagigalainia na Vavanau sa qaike tavaraguania sa isa vei sa nyoroguania na Tamasa ko bai roitinia, ko qai daidia tapaputaiso ti Jone. ");
INSERT INTO lga_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ko sa paranga si Jisu, <<Ego, ko na sa mana vapopodekeniria ara sira na sasae tinoni pa rane pa ngeni api? Ai tinoni veveidi sira? ");
INSERT INTO lga_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ira na sasae tinoni pa rane pa ngeni api sa qai vaitoto vei tugu ira na koburu qai kole toqo leleodia pa ia mamaketina. Ko qai kole vavaikuku karovo, pira qarigu, <Qe mikeniria agei sira na kera vaialava, ba agou quke peka tu. Qe keraniria agei sira na kera mate, ba quke lukana roroma tu sagou!> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pira sa vei na ginuana sa na vavapada isa. Totonai sa lame si Jone Paputaiso sa sa madi ko sake teteku beto ko sake buku vaini sisa, poni pira qugu sagou, <Sa kolea na tomate ikikerena sina!> qugunia. ");
INSERT INTO lga_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ego totonai sa lame mule sa na Tuna na Tinoni ko sa teteku beto sa buku sisa, poni sa pira mule qugunia, <Doro! Na ngoja mota beto na tinoni bubukuna sina, beto na baere tadira na tinoni teteku takisi beto ira na tinoni seladi sina!> qugu mutugu. ");
INSERT INTO lga_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ba na tavagigala tana Tamasa sa sa ulule gu pa roiti uana tadira na tinoni qai tutia,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ego sa beto gu sa vei inara beto sa sa sorua kai Parese si Jisu ko mi lao teteku tavitia pa nona ruma sau. Ko sa lao tugu pa ruma tana si Jisu, ko sa kole teteku tavitia sisa. ");
INSERT INTO lga_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ego ko na suverena tugu pa gugusu isa sa kai rereko sa toania na toa selana. Tonai sa nongoronia isa si Jisu sa korapa teteku pa ruma tana Parese sa sa pogosia isa sa kai jagi alabasita sa pugelia na lumu umumanga jonga. ");
INSERT INTO lga_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Sa pogoso lao turu lulukanania pa liguna i Jisu tata pa nenena, beto sa vaoni tariniria na kolo matana isa sa karu nenena i Jisu, beto sa puqa vapidiliniria na vurunguna. Beto sa aoria sa na nenena i Jisu, beto sa sa vuva tariniria na nenena i Jisu sa na lumu umumanga jonga. ");
INSERT INTO lga_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Totonai sa batia na Parese sa vei isa inara, sa pira sau golomo mekana, <<Bi vei kai tinoni kokorotai sosoto sa na bangara api, sa bi tei gigilaiona tu ai rereko veveina sa sa korapa ulia isa ina ura na rereko selana sa ina!>> sau. ");
INSERT INTO lga_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Poni sa paranga lao si Jisu tana, <<Saimone! Ara qa nyogua pojanigo kai sava,>> saunia. <<Ego tu ao Tinoni vaivagigalai, mu pojai tu,>> sau si Saimone. ");
INSERT INTO lga_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Poni sa parangia i Jisu sisa, pira saunia, <<Koledia sa karu tinoni poredia lilipu tana kai tinoni poreona poata. Kame ira karu sa ka lima gogoto poata siliva, goto kame sa ka limangavuluputa. ");
INSERT INTO lga_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ba ira karu doru sa qaike boka vamatea na dia lilipu ko sa taleosoniria gu na tinoni poreona poata sira karu beto sa anyu paleria gu sa na dia lilipu. Ego ko ai ira karu pira sa qu roroqua ao sa kode mina roroqu vivitigia sa na tinoni poreona poata?>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Poni sa oe lao si Saimone, pira sau, <<Pana rorove taqu sa isa sa lavata jola na ona lilipu ba sa taleosonia na tinoni poreona poata,>> sau. <<Qu sotomua tugu sao,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Beto sa sa balinga mule sa tana rereko, ko sa paranga laoa si Saimone, <<Qu batiamua sa na rereko api? Qu sorusiu ara sao, ba totonai qa tome lame pa mua ruma sara, sa quke vanisiu na pie ao ko ba loqaria na nenequ. Goto na rereko api sa sa vatubulunia na kolo matana sa karu nenequ beto sa puqa vapidiliniria na vurunguna. ");
INSERT INTO lga_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ao sa quke ao vakamusiu sara, goto na rereko api sa totonai vei qa kamu ara lani sa sa oqoro beto aoria na nenequ. ");
INSERT INTO lga_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ao sa quke lumunia na oela olive na batuqu tonai qu vakamusiu, goto isa sa vuva tatariniria na lumu umanga jonga pore vaina sa na nenequ. ");
INSERT INTO lga_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ko ara pira ma poja veinigo sao Saimone: ira na sela tana qai kubo jola sa qai tei taleoso beto tu, ko na ona roroqu sa roiti votunia isa taqu sa ulenia sa sa tei taleoso tu sisa. Ba isa sake kubo ona sela sa taleoso sa nake lavatana tugu sa nona roroqu sa roiti votunia,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Beto sa pira saunia i Jisu sa na rereko, <<Qai tei taleoso tu sira na mua sela,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Totonai qai nongoria ira na tinoni qai somana teteku pa tevolo sa paranga vei inara isa sa qai kole ququmi gogolomo, pira qarigu, <<Ai na tinoni veveina sapi ko na sela ba sa taleosoniria?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Beto pira saunia i Jisu sa na rereko, <<Na mua rarange sa sa tei alogo tu. Mu lao pa bule,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ego sa jola gu sa vei inara sa sa lekogo taraeni i Jisu pa gugusu lalavata beto na ikikete sa na nongoro jongana na veveina na binangara tana Tamasa. Ko ira ka manogarua ona sepele ba qai tutia tugu isa, ");
INSERT INTO lga_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","beto ko vei tugu ira kaki rereko sa iju paleria na tomate ikikeredi pa dia toa isa beto sa salanaria tugu kaki dia vagauru. I Mere na koko veina pa gugusu Magadalene sa kame, isa perangana qai kolea mai ka vitu tomate ikikeredi ba sa iju paleria tugu i Jisu. ");
INSERT INTO lga_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Goto i Joana sa kame, na maqotana i Kuza na nabulu ti Herodi; kame i Susana, beto ko kubo mule sira na rereko. Ko ira aipira sa qai varoitiria na dia isisongo ko qai totokania si Jisu beto ira na ona sepele. ");
INSERT INTO lga_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ego ira na tinoni pa okokoto gugusu sa qaike koroto kakamu tai Jisu. Ko totonai sa vaikamu lame tana sa kai minete lavata, sa pojai isa sa na vavakato vavapada api: ");
INSERT INTO lga_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","<<Koleona sa kai tinoni umuma sa riu vavuvusuria na kiko pa ona inuma. Ko totonai sa kole iparainiria na kiko isa poni sa kaki sa qai vukele lao pa lodaka soana ko qai teteria na tinoni, beto ko qai tatava kamu tobiki betoriagadia na manugu. ");
INSERT INTO lga_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kaki sa qai vukele lao pa peso bubuturuna, ko tonai qai pidoko sa qai malei matedia ura sa pidili kepore piena sa na peso pa ia isa. ");
INSERT INTO lga_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Kaki kiko mule sa qai vukele lao pa gagasoro vavaioka, ko qai toa tavitiria tugu na gasoro vavaioka, beto ko sa pilu vamateria tugu isa. ");
INSERT INTO lga_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Goto kaki kiko sa qai vukele lao pa peso jongana, ko qai toa vajonga beto qai vua vatale ko sa vuvungu gogoto na vuana,>> sau si Jisu. Pa liguna isa sa pira sa paranga viva veiniria, <<Na tinoni sa pore talingi nonongorona sa mi vainongoro vatale,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ego qai lao nanasia ira na ona sepele na sa ginuana sa na vavakato vavapada api, ");
INSERT INTO lga_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","poni sa pira sauniria, <<Agou qu tei taiania tu sa na gigalai paena na veveina na binangara tana Tamasa, goto ira na goto tinoni sa qai tavagigalai pa vavakato vavapada sira, ko mai dodogorodia ba maike batia; mai nonongorodia ba maike vakaberia,>> sau i Jisu. ");
INSERT INTO lga_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","<<Ego na ginuana na vavakato vavapada api sa pira sa vei: na kiko sa na paranga tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ira na kiko qai vukele lao pa lodaka soana sa ira na tinoni qai nongoriadia tugu na paranga tana Tamasa, ba sa lame na bangaradi na tomate ko sa teku palea sa na paranga isa sa kole pa bulodi, kita mai vasosoto ko mai taalo sau. ");
INSERT INTO lga_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ira na kiko qai vukele lao pa peso bubuturuna sa ira isa tugu qai nongoria na paranga tana Tamasa poni qai teku vakatapia pa qeqera. Ba sake kori gore vamauru vei na bagere, ko qai vasosoto mai iapeki totoso ba totonai sa lame na totoke ko sa podekeria sa qai vukele riudia. ");
INSERT INTO lga_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ira na kiko qai vukele lao pa ia sa kolea na gasoro vavaiokana sa ira qai nongoriadia tugu na paranga tana Tamasa, ba tonai qai korapa lalaodia poni na takulangadi na roroqudi na isisongo beto na qeqera goborodi pa toa kasia gusu sa sa piluria ko qaike boka vua vamatua. ");
INSERT INTO lga_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Goto ira na kiko qai vukele pa peso jongana sa ira na tinoni qai nongoria na paranga tana Tamasa ko qai kopu vatalenia pa bulodi beto qai turu vangaju ko qai vua vatale,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","<<Kepore sa kai tinoni sa vatoai na juke beto sa vaopo tarinia na besini babi vatoqoa pa kauru sape puputana sa na juke, goto pa ona totoqona tu sa vatoqonia, ko ira na tinoni mai tome lame sa mai batia na kabere. ");
INSERT INTO lga_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Doru sakasava qai kole vapae sa kode mai tabata votu, beto doru sakasava qai kole golomo sa mai votu lame pa kakaberena. ");
INSERT INTO lga_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ko inara sa vei sa mu doro vatalea na soana qu vainongoronia na paranga tana Tamasa. Ura isa na tinoni sa isongo vasoku sa kode na motana mule sa kode mina taiania. Goto isa sake isongia kai sava sa isa tu sa rove veinia sa isongia ba mina tateku variunia tugu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ego sa lame ti Jisu sa na tinana beto ko ira na boko tasina marene, ba qaike boka kamua sisa ura sa mota jola na minete tinoni. ");
INSERT INTO lga_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ko kame ira na tinoni sa sa lao pojania si Jisu, <<Na tinamu beto ira na tasimu marene sa pori, qai korapa turu veranigo pa sesebe. Qai nyorogua dorigo qarigu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ba sa oeria i Jisu sira, pira sauniria, <<Ira qai nongoria na paranga tana Tamasa ko qai vatabea sa ira sa na tinaqu beto ko na tasiqu marene ara,>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kai rane tonai sa koi pa koaka si Jisu beto ira nona sepele poni sa pira sauniria sira na ona sepele, <<Aria ko ta karovo lao pa kai karovona na ovuku Qalili,>> sauniria. Poni sa qai toka lao. ");
INSERT INTO lga_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Totonai qai korapa tetepe lalaodia ira poni sa sa kole ko sa putagana si Jisu. Beto sa gore raja pa kolo isa sa na gava lavata, ko sa pugelia na kolo sa na koaka ko tata bai dururu. ");
INSERT INTO lga_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Poni qai lao vadoravia ira na sepele si Jisu, pira qarigu, <<Qokolo, Qokolo, taqe tata mate sa gita!>> qarigunia. Poni sa tatakole si Jisu ko sa tokea sa na gava beto na ololobagea, poni qai noso ko sa bule elava sa neqa. ");
INSERT INTO lga_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Beto sa pira sauniria i Jisu sira na sepele, <<Kepore na miu rarange sagou?>> sau. Poni qai gabara beto qai matagutu sira, ko qai kole vavaiparanga mekadi, I sei tu sa na tinoni api? Ko tonai sa parangaria na gava beto na kolo poni qai nongoria tu! qarigu. ");
INSERT INTO lga_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ego pa liguna sa vei inara sa qai tepe gore paro pa gugusu pa Qerasini pa kai kalena pa ovuku Qalili. ");
INSERT INTO lga_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Isa tugu sa tete paro si Jisu pa paparona pa gusu isa sa sa gore tugu sa kai tinoni isa sa kolea na tomate ikikeredi ko mi lao gosoria sisa sau. Na sovai jolana na gagadona sa na tinoni api, ko sake susuvere pa ruma goto pa bevi vavaigolomodi tu. ");
INSERT INTO lga_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Isa tugu sa dogoro laoa isa si Jisu sa sa uui, sa lao toqo sori tutungu pa moena i Jisu, ko sa kuku vevela vei pira, <<Na sa qu nyogua roitinia taqu sao Jisu na Tuna na Tamasa ululuna jola? Qa tepaigo ara sao, muke vakilasanisiu na vitigi!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Inara sa paranga vei sisa, ura perangana tu sa sogaria i Jisu sa na tomate ikikerena ko mi votu riu tana tinoni isa saunia. Ura kubo totoso sa vavavitulunia tu na tinoni api sa na tomate ikikerena. Ko ai tu qai piu veinia na seni na limana nenena beto qai kole kopu veinia kai tinoni tavatomena pa ruma vaipiu, ba sa kokoroto paleria tugu sa na seni beto sa toni riu pale na tomate ikikerena pa qega sisa. ");
INSERT INTO lga_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sa nanasa laoa i Jisu sa na tinoni api, <<I sei na isongomu sao?>> saunia. Poni sa pira sau, <<I Joatina,>> sau, ura qai soku sira na tomate ikikeredi qai tomea na tinoni api. ");
INSERT INTO lga_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ko qai kole tepa totokai i Jisu sira na tomate ikikeredi, ko kita mi garunu laoniria pa ia ketakoi mai tavakilasa ira na gagala ikikeredi qarigu. ");
INSERT INTO lga_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ego sake sou pa ia isa sa kai godo borogo lavata, qai korapa nyunyubele gaganigadia pa kai kalena na kubo. Ko qai tepa totokai ira na tomate ikikeredi si Jisu ko mi vamalumuria ko mai lao tomedia tadira na borogo qarigu. Poni sa vamalumuria tugu. ");
INSERT INTO lga_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ko qai votu riu tana tinoni api sira na tomate ikikeredi, ko qai lao tomedia tadira na borogo. Poni sa qai tulai gore na taba sa na godo borogo pira ko qai gore tulusu pa kolo ko qai kuju mate betodia. ");
INSERT INTO lga_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ego ira na tinoni qai kopuniria na borogo sa totonai qai batia sa vei inara poni sa qai uku. Qai lao vavakato vaniria sira pa gugusu beto ira na tinoni pa vailivutaina na gugusu isa. ");
INSERT INTO lga_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Poni qai votu lao sira na tinoni ko mai dogoria sisa na manugu sa podo qarigu. Tonai qai kamu tai Jisu sa qai batia sa na tinoni isa sa kolea na tomate ikikerena sa tei tasalana tu. Ko sa korapa toqo vataleona pa kekere nenena i Jisu sisa, sa tei vasae poko tu, beto sa tei tavagigala tu. Ko qai matagutu beto sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ko ira na tinoni qai batini matadi na manugu sa podo beto isa vei beto sa tasalana sa na tinoni isa, sa qai vavakato vaniria sira na tinoni qai koni kamu. ");
INSERT INTO lga_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Poni qai tepai ira na tinoni pa Qerasini si Jisu ko mi iolo rijo pa ia ketakoi qarigunia, ura qai matagutu vivitiginia. Poni sa qaqiri lao pa koaka si Jisu ko sa mule riuona. ");
INSERT INTO lga_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ba tonai sa oqoro toka si Jisu sa sa lao kole tepa tuti tai Jisu sisa na tinoni sa koni tasalana ani, ba sa garunu vamulea i Jisu sisa, pira saunia, ");
INSERT INTO lga_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","<<Mu mule lao pa mua gugusu, ko mu vavavakatonia sisa vei sa roiti vanigo na Tamasa,>> saunia. Poni sa mule lao sa na tinoni api, ko sa vevelania isa tadira doru pa nona gugusu sisa vei sa roitinia i Jisu tana. ");
INSERT INTO lga_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Totonai sa gabala mule lao kamu pa kai karovona na kolo si Jisu, sa qai vera vakamua ira na tinoni sisa. Ura qai kole tugu verania ira doru tinoni sisa. ");
INSERT INTO lga_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pana totoso tugu isa sa bola kamu gu sa na kuta tinoni mamata pa ruma vavaikamuna, na isongona i Jaerasi. Sa lao toqo sori tutungu pa nenena i Jisu sisa, ko sa tepa totokai ko mi lao pa ona ruma sau, ");
INSERT INTO lga_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ura kai memeka tuna ikete tata manogarua aorona sa mi mate gu sau. Ego totonai sa korapa rerege lalaona i Jisu sa qai jujupe vaikalenia ira na minete tinoni sisa. ");
INSERT INTO lga_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na somanana tugu pa vaikamu minete tinoni isa sa kai rereko sa riu gojo na orungu pa tinina ka manogarua aoro. Ira doru vei sa isongoria sa sa tei gona pale betoria tu pa solatadi ira na tinoni vavaisalana, ba kepore kame ira bi boka salania. ");
INSERT INTO lga_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ko sa somana rerege tuti pa liguna i Jisu sisa. Ko isa tugu sa lao ulia sa na uquna na poko ti Jisu, poni sa totonai tugu sa noso riu sa na orungu. ");
INSERT INTO lga_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tonai sa nanasa si Jisu, <<I sei sa ulisiu ara?>> sau sisa. Ba qai oso sira doru, <<Ura! Nake agei!>> qarigu. Poni sa pira sau si Pita, <<Qokolo, qu batiamua ao ko na vaikamu tinoni sa qai jupe vailivutainigo inara!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ba pira sau si Jisu, <<Dai, kai tinoni sa sa ulisiu ara, ura qa vagigilai ara pa tiniqu sa sa votu taloa taqu sa na neqi,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Totonai sa gigilai na rereko sa sa tei tavotu tu sa na roiti sa roitinia isa sau, poni sa matagutu neneqere vivitigi sisa, ko sa lao toqo sori tutungu pa nenena i Jisu, ko sa ule votunia isa tai Jisu pa moedi ira doru tinoni sa isa vei beto ko sa ulia na poko ti Jisu beto veveina sake ruavo tugu tasalanana sisa. ");
INSERT INTO lga_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Poni pira saunia i Jisu sisa, <<Tuqu, na mua rarange sa tei salanigo tu. Mu lao pa bule,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Totonai tugu sa korapa paranga vei inara i Jisu poni sa sa bola kamu gu sa kai tinoni pogoso nongoro, na koko lame veina pa ruma tai Jaerasi na tinoni mamata pa ruma vavaikamuna, ko pira sau, <<Sa tei mate tu sa na tumu rereko. Kita vapavu lame goboria na tinoni vaivagigalai,>> saunia si Jaerasi. ");
INSERT INTO lga_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ba tonai sa nongoria i Jisu sa na vavakato tana tinoni pogoso nongoro, poni pira saunia si Jaerasi, <<Muke matagutu. Mu vasosoto gu beto kode mina jonga gu sa na tumu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Totonai sa lao kamu sisa pa ruma tai Jaerasi, sa sake vamalumuria isa ko mai tome tavitia sira na tinoni, goto ira Pita, i Jone, i Jekopi, beto ko ira karu tinana na tamana gu na rereko. ");
INSERT INTO lga_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ira doru tinoni sa qai korapa roroma qai lukana takulangania na koburu sa mate. Poni pira sauniria i Jisu sira, <<Muke lukana! Zake mate sa na koburu inana, sa korapa putagana gu,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tonai sa paranga vei inara isa poni sa qai avavunia ira doru sisa, ura qai gigila vataleadia sa tei mate tu sa na koburu rereko. ");
INSERT INTO lga_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ba sa arua i Jisu sa na limana na koburu beto sa paranga, <<Ngore, mu tatakole!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Poni sa toa mule ko sake ruavo tugu tatakolena sa na koburu ko sa garunuria i Jisu sira ko mai vania na gagani ko mi teteku sau. ");
INSERT INTO lga_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ko qai gabara vivitigi sira karu na tamana beto na tinana, ba sa paranga vabalauria i Jisu sira ko maike vavavakatonia pa tinoni sisa vei na roiti sa taroiti. ");
INSERT INTO lga_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ego sa kuku vaikamuniria i Jisu sira ka manogarua sepele, ko sa vaniria na neqi ko mai ijiju pale tomate ikikeredi beto mai salanaria sira sa vairia na mo sau. ");
INSERT INTO lga_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Beto sa garunuria tugu vei sira ko mai taraenia na binangara tana Tamasa, beto mai salanaria sira qai mo sauniria. ");
INSERT INTO lga_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Beto sa pira sauniria, <<Munake pogosia kai sa pa miu rerege lao, munake pogoso kolu opopatana, na mane, na besa, na poata beto ko munake pogoso varua soti. ");
INSERT INTO lga_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ketakoi mai tavaragua vatogagou ko mai vasuveregou sa muna suvere gu pa ruma isa, tinganai muna taloa riu pa gugusu isa. ");
INSERT INTO lga_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ketakoi maike tavaragua vatogagou ira na tinoni sa muna turu loa pale sa na gugusu isa. Tonai muna taloa riu sa muna tavusu paleria sa na kavuruna na peso pa gugusu isa qai ramata pa nenemiu. Ko isa sa na vinagigilana kode mina vakilasaria na Tamasa sira,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ego ko qai taloa riu sira na sepele, ko qai rerege lao pa doru gugugusu, qai taraenia na nongoro jongana beto qai salanaria sira qai mo pa doru eqa qai lao vei. ");
INSERT INTO lga_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ego totonai sa nongoronia i Herodi, na bangara pa Qalili, sira doru sakasava sa roitiniria i Jisu, sa sa rura betona sisa. Ura qai pojania ira kaki tinoni sa i Jone Paputaiso sa sa tei toa mule tu qarigu. ");
INSERT INTO lga_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ira kaki mule sa qai paranga sa i Elaija sa sa tei bola tu qarigu, goto kaki ira sa qai paranga sa kame ira na tinoni kokorotai pa moa sa tei toa mule tu qarigu. ");
INSERT INTO lga_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pira sau si Herodi, <<I Jone sa qa tei kujuku pale tu na batuna ara. Goto i sei sa na tinoni isa sa roitiniria doru ginugua qa nongoroniria aipira?>> sau sisa. Ko sa nyoguania isa ko bi batia si Jisu sau. ");
INSERT INTO lga_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ego tonai qai mule kamu sira na tinoni tagarunudi sa qai vavakato vania i Jisu sira doru sakasava qai roitiniria. Poni sa toniria isa sira ko qai lao pa kai ia kaloina pa kai gugusu na isongona pa Betiseda. ");
INSERT INTO lga_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ba totonai qai gigilai ira na minete tinoni sa ketakoi sa lao vei, sa qai tuti laoia ira si Jisu. Poni sa vakamu vataleria tugu isa sira, sa taraenia tugu isa tadira sa na veveina na binangara tana Tamasa, beto ko sa salanaria tugu sira qai mo ko qai nyogua tasalana. ");
INSERT INTO lga_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ego totonai sa podalai gore sa na vevelu, sa qai lao tana sira ka manogarua sepele ko pira qarigunia, <<Mu garunu variuria pa gugusu lalavata beto ikikete pa vailivutaina sira na tinoni mai, ko mai boka nyaqogadia gagani beto mai nyaqoa ketakoi mai puta. Ura na ia taqe korapa suveria api sa na qega ko sa kepore kai savana,>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Poni pira sauniria i Jisu sira, <<Agou gu sa mu ianiria na tetekuna!>> sau. Poni pira qarigu, <<Kepore mutugu sa kai sa be vagaroa goto isa tugu ka lima bereti beto karu igana momoqasadi gu sa qai kole pira! Ko ai vei? Qu nyoguanigei ao ko me lao vai vaniria na gagani agei sira na minete tinoni lavata pira?>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Ura sa papada vei ka lima tina sa na anyedi ira na marene gu.) Poni sa pira sauniria i Jisu sira na ona sepele, <<Mu vatoqo okoto bobokoria sira na tinoni papada vei ka limangavulu pa kai pukuna,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ego ko tonai qai beto vatoqo betoria ira na sepele sira na tinoni, ");
INSERT INTO lga_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","sa sa tekuria i Jisu sa ka lima bereti beto karu igana, ko sa enga sae pa noka ko sa mananiria, beto sa kikiparia, beto sa sa vaniria ira na ona sepele, ko ira qai iaria sira na minete tinoni. ");
INSERT INTO lga_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ko qai teteku ko qai pote beto sira doru, beto sa qai buti kura vapugeleniria na kikipa gagani kole joladi ira na sepele sa ka manogarua topa lavatadi. ");
INSERT INTO lga_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ego kai rane totonai sa korapa vavara mekana si Jisu, sa qai lame vaikamunia sira na ona sepele. Poni sa nanasaria i Jisu sira, <<I sei qaqarigunisiu ira na minete tinoni sara?.>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Poni qai oea pira qarigunia, <<I Jone Paputaiso sao qarigu, goto kaki sa i Elaija sao qarigu, goto kaki mutu sa kame ira na tinoni kokorotai pa moa sao qarigu,>> qarigu sira na sepele. ");
INSERT INTO lga_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Poni sa nanasaria mule isa sira, <<Goto agou sa i sei ququgunisiu sara?>> sauniria. Poni sa oea i Pita sisa, pira saunia, <<Ao tugu sa na Karisito tavilena tana Tamasa!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Beto sa sa naquria beto sa paranga vaneneqiniria i Jisu sira na ona sepele ko maike tei vavakatonia tu tadira na tinoni sa na veveina isa sa na Karisito sauniria. ");
INSERT INTO lga_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ko sa pojaniria mutugu sira, <<Na Tuna na Tinoni sa kode mina gosororia soku vitigi, beto mai kilu pale ira na tinoni mamata, na kuta iama beto ko ira qai vaivagigalainia na Vavanau. Kode mina tavamate sisa ba pa rane vinaue sa mina tavatoa mule,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Beto sa paranga laoria ira doru sisa, <<Na tinoni sa nyogua tutisiu ara sa mi kilu pale tu sa nona toa mekana, ko mi pogosia na ona korosi doru rane ko mi tutisiu sara. ");
INSERT INTO lga_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ura na tinoni sa nyorogua kopu vasarenia nona toa mekana sa kode mina saivia tugu sa nona toa. Goto na tinoni sake rabekia nona toa pa ona tutiqu ara sa isa sa mina aloa nona toa. ");
INSERT INTO lga_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ura na sa sa mina boka vagavoria na tinoni bi gona pale na ona toa ko bi isongia na kasia gusu doruna? Bi julingai tu! ");
INSERT INTO lga_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Na tinoni sa keanisiu ara beto na qua paranga sa na Tuna na Tinoni ba mina keania tugu sisa totonai mina lame sisa pa ona neqi lavata, pa neqi tana Tamasa beto tadira na mateana tabuna. ");
INSERT INTO lga_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ma poja sosotonigou ara sagou: kaki agou qu korapa suvere aipira sa mai oqoro mate tinganai mai batia na binangara tana Tamasa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ego pa liguna sa pojaria isa sa na sakasava aipira ko pa vinavesu rane, sa sa toniria isa sira Pita, i Jone, beto i Jekopi ko qai sae pa kubo ko sa kole vavara. ");
INSERT INTO lga_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ko totonai sa korapa vavara isa, poni sa sa dogoro goto sa na isumatana beto na ona poko sa sa keka vavalaka. ");
INSERT INTO lga_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Beto api! Karu tinoni ira Mosese i Elaija ");
INSERT INTO lga_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","qai bola votu pa leo kabere noka ko qai kole paparangia si Jisu ko qai kole vavavakatonia ira karu tai Jisu sa na soana vei beto mina taloa isa sa tata kode mina gore votu pa Jerusalema. ");
INSERT INTO lga_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","I Pita beto ira karu sepele tavitina sa sa tei ngaoloria tu na nyoputa, ba qai dorava sira ko qai batia sa na tinina i Jisu sa kabere beto ko vei tugu ira karu tinoni qai turu tavitia isa. ");
INSERT INTO lga_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ego ko totonai qai korapa iolo taloa ti Jisu qarigu sira karu, sa sa paranga lao ti Jisu si Pita, <<Qokolo, sa jongana jola sa qe suvere lani sagei! Ko me roitinia kue aqaqo ropi, ko kame tamu, kame ti Mosese beto kame ti Elaija, uve?>> sau. Ba sake gigila vatalea i Pita sa na manugu sa korapa pojai isa. ");
INSERT INTO lga_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Totonai sa korapa tugu paranga vei inara i Pita sa sa lame gu sa kai lei ko sa amu vapaeria sira doru, ko qai matagutu sira na sepele totonai qai tome sae pa lei sira Mosese i Elaija. ");
INSERT INTO lga_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Beto kai ovovele sa sa votu lame vei pa lei, pira sau, <<Alepi sa na Tuqu isa qa vilea ara. Mu nongoria sisa!>> sau. ");
INSERT INTO lga_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Totonai sa noso na ovovele, sa i Jisu gu mekana sa sa suvere jola. Qaike isongo vavavakatonia tugu ira ka visa sepele aipira tadira tinoni totonai sira doru ginugua qai batiria pira. ");
INSERT INTO lga_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ego pa vuvugei ranena tonai sa taloa mule gore koko pa kubo si Jisu beto ira kue sepele, sa kai minete tinoni lavata sa sa gore gosoria i Jisu. ");
INSERT INTO lga_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ko kai tinoni pa vaikamu tinoni isa sa sa kuku vevela, pira sau, <<Tinoni vaivagigalai! Qa tepa vivitigigo ara sao ko mu lame mai dogoria na tuqu marene, ura isa tugu kai tuqu memekaina sisa. ");
INSERT INTO lga_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Sa tomea na tomate ikikerena, ko lao vei sa kamua sa sa kukuku vasiboro, beto sa gogona pedalania pa peso ko sa dadao tu na mangana. Ko sa aru vavivitigi palea mai tu beto sa taloa tana sa na tomate ikikerena. ");
INSERT INTO lga_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Qa tei pojaniria tugu sira na mua sepele ko mai iju palea sa na tomate ikikerena qauniria, ba qaike bokai,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Poni sa oea i Jisu sisa, pira saunia, <<Koi, na sasae tinoni kepore miu rarange beto na ikikeremiu sagou! Ai tu mina koi vei sovaina sa mana suvere tavitigou beto mana jujunonigou ara? Ao mu toni lamenia taqu sa na tumu ina!>> sau. ");
INSERT INTO lga_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ego ko totonai sa korapa rerege lao sa na koburu, sa sa vakamu vaikikeria mule, ko sa gona pedalania na tomate ikikerena pa peso ko sa neneqere beto sa garata tu. Ba sa lao i Jisu ko sa iju palea sa na tomate ikikerena, ko sa salania sa na koburu marene, beto sa vamule lao vania na tamana. ");
INSERT INTO lga_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ko qai gabara betonia ira doru tinoni sa na neqi lavata tana Tamasa. Totonai qai korapa gabarania ira na tinoni sa na veveidi doru sakasava sa roitiniria i Jisu, poni sa pira sauniria ira na ona sepele, ");
INSERT INTO lga_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","<<Agou mu nongoro vakoititiria sira na paranga mana ule vanigou aipira. Na Tuna na Tinoni sa kode mina tavakarovo lao pa limadi ira na tinoni,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ba qaike vakaberia ira na sepele sa na ginuana na paranga sa pojai isa. Sa tavapae tadira sa na ginuana, ko qaike gigilai, beto ko mekadi ba qai pangaga nanasania sa na ginuana na paranga sa pojai isa. ");
INSERT INTO lga_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ego kai vaitoke na veveina i sei sa na poreveveina jola qarigu sa sa poraka votu pa vaikorapaidi ira na sepele. ");
INSERT INTO lga_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ba sa tei gigilaiona tu i Jisu sa isa qai roroqu vei pa bulodi ira, ko sa aru tekua isa sa kai koburu ikete ko sa vaturua pa kekerena, ");
INSERT INTO lga_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","beto sa pira sauniria, <<Na tinoni sa vakamu vatalea pa isongoqu ara sa kame ira na koburu vevei api, sa sa vakamu vatalesiu tugu isa sara. Beto na tinoni sa vakamu vatalesiu ara sa sa vakamu vatalea tugu isa sisa sa garunusiu ara. Ura isa sa kepore veveina jolanigou agou doru sa isa tugu sa sa poreveveina jola,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Beto sa oe si Jone, pira sau, <<Qokolo, kai tinoni sa qe batia agei sa ijiju pale tomate ikikeredi pa isongomu ao, ko qe pojania agei sisa ko mi noso qeunia, ura sake somana tavitigei agei pa tutimu ao sisa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Poni pira saunia i Jisu sisa, <<Muke vanosoa! Ura na tinoni sake kanagou sa sa kole vei pa miu kalena,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ego totonai sa adanga lame na totoso beto mina mule sae pa noka si Jisu, poni sa vatoqo vatalea sa nona roroqu ko mi sae pa Jerusalema sau. ");
INSERT INTO lga_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Sa garunu momoe laoniria isa sira kaki ona tinoni pogoso nongoro ko qai lao pa kai gugusu pa Sameria ko mai vatana momoe vania sa ketakoi mai vajola bongi tonai mai kamu ketakoi sau. ");
INSERT INTO lga_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ba qai daidia vakamua ira pa gugusu isa sisa, ura qai gigilaidia ira sa pa Jerusalema tu sa korapa gore vei sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Totonai qai nongoria ira karu ona sepele, na isongodi ira Jekopi i Jone, sa sa vei inara sa pira qarigu sira karu, <<Bangara, vei jongana munagu ao, sa mu kuku vagore lageria na iku pa noka ko mi vurungu beto paleria sira na tinoni ketakoi!>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ba sa balinga i Jisu ko sa tokeria sira karu. ");
INSERT INTO lga_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Beto sa rerege jola laona pa kai goto gugusu si Jisu beto ko ira na ona sepele. ");
INSERT INTO lga_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Totonai qai korapa rerege lalaodia pa soana sa sa lame sa kai tinoni ko sa parangia si Jisu, pira sau, <<Ara mana tutigo doru eqa muna lao vei ao,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Poni pira saunia i Jisu sisa, <<Ira na pokese sa koleona na dia baongo, beto ira na manugu tatava sa koleona na dia vovori, goto na Tuna na Tinoni sa kepore na ona ia mina kole minere,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Beto pira saunia isa sa kai goto tinoni, <<Ao mu lame tutisiu ara,>> saunia. Ba pira sau sa na tinoni isa, <<Bangara, mu vamalumusiu ko ma mule golomia mai na tamaqu,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Poni pira saunia i Jisu sisa, <<Mu loaria sira na matedi ko mai vaigolomo mekadi. Goto ao sa mu lao ko mu taraenia na binangara tana Tamasa,>> saunia i Jisu sisa. ");
INSERT INTO lga_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Beto sa pira mutugu sau sa kai goto tinoni, <<Bangara, ara sa mana tutigo ao. Ba mu vamalumusiu mai ko ma mule lao loloaria ira pa qua tatamana,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ba pira saunia i Jisu sa na tinoni isa, <<Na tinoni sa tei aru tamana tu pa gegelini peso taragatana beto sa babalinga sa sake pada pa binangara tana Tamasa sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ego pa liguna sa vei pira sa sa vileria mule i Jisu sira ka vitungavulu karu tinoni, ko sa garunu variuria, kakaru tinoni pa kai reregena, ko mai lao momoe pa gugusu beto pa ia ketakoi mina laoria isa sauniria. ");
INSERT INTO lga_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ko sa pojaniria i Jisu sira, <<Sa matua nyanyalu sa na vuvua, ba ira na tinoni ababu sa qai vivisa gu. Ko mu vavara lao tana isa sa bangarania na vuvua, ko mi garunu laoniria na tinoni roiti ko mai ababu pa nona inuma. ");
INSERT INTO lga_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mu lao sagou! Doro! Qa garunu lao veinigou na tudia na sipi pa vaikorapaidi ira na vulupu pirudi ara sagou. ");
INSERT INTO lga_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Muke pogoso varua kukura poatana, babi na mane, na sadolo, beto muke vavavakato vajola goboro totoso tadira na tinoni muna gosoro qeqeraniria pa soana. ");
INSERT INTO lga_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tonai muna tome sagou pa kai ruma, sa momoe pira muna paranga vei, <Na bule beto na mana tana Tamasa mi somana tamugou pa ruma api!> munagu. ");
INSERT INTO lga_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Vei mina korapa suvereona pa ruma isa sa kai tinoni bubule poni sa mi kole tana sa na mana qu tepa vania. Goto vei minake pore sa kai tinoni bubule sa kode mina mule gu tamugou sa na mana isa. ");
INSERT INTO lga_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ko isa tugu pa ruma qai vatogagou sa muna suvere, ko muna tekuria beto muna bukuria sira vei mai kaqamanigou ira, ura na tinoni roiti sa pada tugu mina tekua na tabarana. Munake lekogo vaikarovai ruruma tinganai muna taloa riu pa gugusu isa. ");
INSERT INTO lga_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Totonai muna lao kamu sagou pa kai gugusu ko mai vakamu vatalegou, sa muna tekuria tugu sira na gagani qai vatana vanigou, ");
INSERT INTO lga_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","muna salanaria sira qai mo pa gugusu isa, beto pira muna poja veiniria, <Na binangara tana Tamasa sa mi togagou sau,> munaguniria. ");
INSERT INTO lga_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Goto totonai muna lao kamu sagou pa kai gugusu ba baike vakamugou, poni sa muna rerege votu lao pa soana, ko pira munagu, ");
INSERT INTO lga_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","<Sa kamu tu pa kavuruna na pesona na miu gugusu qai ramata pa nenemei ba qe tavusu paleria tugu. Ko isa sa na vasosotona na vinakilasa muna gosoria agou. Ba muna roroqua agou sa na binangara tana Tamasa sa mi toga gu sau!> munaguniria. ");
INSERT INTO lga_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ma poja vatalenigou ara sagou: na vinakilasa mina gosoria na gusu isa pa rane vaituti sa mina lavata jolania isa vei qai gosoria ira pa gugusu Sodomo,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","<<Mu takulangagamiu tu sagou pa Korazini! Mu takulangagamiu tu sagou pa Betiseda! Ura vei bi taroiti tadira na tinoni karovodi pa Turosi beto pa Sidoni sira na roiti vaivagabaradi qai taroiti tamugou kopira, sa pa moa tu bai gabala ko bai toqo ora bibiluniria na kavu beto bai pokoniria na poko taririkatadi sira! ");
INSERT INTO lga_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ba quke gabala sagou ko na vinakilasa muna gosoria agou pa rane vaituti sa mina lavata jolania isa vei mai gosoria ira pa Turosi beto pa Sidoni. ");
INSERT INTO lga_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Goto ao ka visa pa Kepaniami! Qu rorovea sagou na poreveveimiu ko kode muna taovulu sae pa noka vavagalo qugu? Ba dai! Kode muna tagona gore pa kauruna na kasia gusu!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","<<Na tinoni sa nongorogou agou sa sa nongorosiu tugu sara, beto na tinoni sa kilu palegou agou sa sa kilu palesiu tugu sara. Ko na tinoni sa kilu palenisiu ara sa sa kilu palenia tugu sa na Tamasa isa sa garunusiu ara,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ego ko qai mule kamu sira ka vitungavulu karu qai tagarunu variu, ko qai qeqera jola, ko pira qarigu, <<Bangara, ira na tomate ikikeredi tu ba qai nongorogei tugu totonai qe iju paleria agei pa isongomu ao!>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Poni pira sauniria i Jisu sira, <<Qa tei batia tu ara si Setani, sa vei na kapi sa vukele lagere koko pa noka. ");
INSERT INTO lga_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Doro! Qa tei vanigou tu ara sa na neqi, ko muna boka teteria gu agou sira na dole, na mede, beto muna vakilasa paleria tugu agou sira doru neqi tana kana i Setani, ko kepore sa kai sava mina apulugou. ");
INSERT INTO lga_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ba muke qerania gu agou sa na veveina ira na tomate ikikeredi qai nongorogou, goto isa tu muna qerania agou sa na veveina na isongomiu qai tei takuti tu pa noka,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ego ko pa totoso isa sa sa vapugeleni qera na Gagala Tabuna si Jisu, ko pira sau, <<Tamaqu, ao na bangarana na oka beto na peso! Qa paranga jongana lao tamu sara, ura qu tei vabatiniria tu ao ira na tinoni qaike boboka sira vei qu golomoniria ira na tinoni gigigalaidi beto na tinoni tomedi. E, Tamaqu, pa mua roroqu tugu ao sa sa taroiti vei isa. ");
INSERT INTO lga_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Doru neqi beto na gigalai sa sa tei vanisiu tu ara. Ko kepore sa kai tinoni sa gigilai na Tuna goto na Tamana gu, beto kepore sa kai tinoni sa gigilai na Tamana goto na Tuna gu beto ko ira gu sa vileria na Tuna ko mi vabatiniria sau,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ego tonai qai suvere mekadi poni sa balinga lao tadira na ona sepele si Jisu, ko pira sauniria, <<Qu tamana sagou ko qu batiria sira na sakasava qu dogororia kopira! ");
INSERT INTO lga_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ura ma pojanigou ara sagou: kubo sira na tinoni kokorotai beto na bangara pa moa qai nyogua vivitigi dogororia na nongororia sira vei qu batiria na nongororia agou pira, ba qaike boka,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ego kai tinoni gigigalai pa Vavanau sa sa turu lao nyogua podekia si Jisu, ko sa paranga sisa, <<Tinoni vaivagigalai, na sa sa mana roitinia ara beto mana teku isongia sa na toa jola?>> sau. ");
INSERT INTO lga_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Poni pira saunia i Jisu sisa, <<Na sa sa sa takuti pa Vavanau? Na sa sa qu tiroa ao ketakoi?>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Poni sa oea na tinoni api sisa, pira saunia, <<Mu roroqua na Bangara na mua Tamasa pa doruna bulomu, pa doruna mua toa, pa doruna mua neqi beto pa doruna mua roroqu; beto mu roroqua na tavitimu mekamu isa vei qu roroqu mule veinigo mekamu sau,>> sau sa na tinoni poni. ");
INSERT INTO lga_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Poni pira saunia i Jisu sisa, <<Na tuvisina sa na oe tamu. Ko mu roiti vei gu isa beto sa kode muna toa,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ba sa nyogua tadoro vei na ona nanasa sa na tuvisina sau sa na tinoni api, ko sa kai nanasa laoa mule si Jisu, <<I sei sa na tavitiqu ara?>> sau. ");
INSERT INTO lga_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Poni sa vataqolia i Jisu sa na nanasa tana, pira sau, <<Koleona sa kai tinoni sa taloa pa Jerusalema ko sa rerege gore pa Jeriko. Pana korapana na ona rerege gore isa sa qai raja vasiboria na tinoni raja ikikodi pa soana sisa, qai ragata vagorea na ona poko beto qai ikoa nona poata, beto sa qai maja vapapalekai, beto qai loa vakole pale na tata matena, beto sa qai riudia. ");
INSERT INTO lga_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pana totoso tugu isa sa gore vei ketakoi sa kai iama, ko totonai sa batia na tinoni sa tavapapaleka sa sa rerege paja riuona pa kai kale soana sisa. ");
INSERT INTO lga_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Beto na soana mutugu isa sa tonia gore sa kai tinoni na bubutu Livai. Tonai sa gore kamua sa na ia ketakoi sa korapa kole sa na tinoni sa tavapapaleka ko sa batia, poni sa rerege paja riuona pa kai kale soana mutugu. ");
INSERT INTO lga_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Beto kai tinoni Sameria sa rerege gore vei tugu ketakoi, sa sa lao kamua sa ketakoi sa kole na tinoni papalekana. Totonai sa batia sa sa roroqu vivitigia ko sa nyogua tokania. ");
INSERT INTO lga_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ko sa lao isa ko sa vuva valaoni oela beto na vaini ko sa piuria sa na palekana. Beto sa ovulu surana vamakelia pa pokotona na ona dongiki, ko sa tonia ko sa lao vakolea pa kai ruma ketakoi qai susuvere minere ira na tinoni rerege, ko sa kopunia ketakoi. ");
INSERT INTO lga_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pa liguna sa bongi ko sa rane neqa, sa sa tekua isa sa karu poata siliva ko sa vania sa na tinoni sa kopunia na ruma, beto pira sa poja veinia, <Muna kopunia sa na tinoni api, uve? Beto vei koleona mule sa kaki sa muna gona paleria ao pa kopuna isa, sa kode mana bei vanigo sira tonai mana mule lame vei lani,> saunia. ");
INSERT INTO lga_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ego, ko pa rorove tamu sa i sei ira kue tinoni pira sa sa vei na tavitina sa na tinoni qai ngangangulia ira na tinoni raja ikikodi?>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Poni pira sau sa na tinoni isa, <<Isa gu na tinoni sa roroqu tokania,>> sau. Poni pira saunia i Jisu sisa, <<Ego, ko ao ba mu lao, ko mu roiti vei tugu isa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ego totonai sa jokelia na ona rerege si Jisu beto ko ira na ona sepele sa qai kamua ira sa kai gugusu, ko kai rereko ketakoi na isongona i Mata sa sa vatogaria pa nona ruma. ");
INSERT INTO lga_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na tasina rereko, na isongona i Mere, sa sa kole toqo tata pa kekerena i Jisu, ko sa kole vainongoroniria na vaivagigalai ti Jisu. ");
INSERT INTO lga_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Goto i Mata sa kole tadungananiria beto sa junoniria na soku vinatana, ko sa lao tai Jisu ko pira saunia, <<Bangara, ai vei sa jongana tugu tamu sa sa loa tari vamekainisiu na roiti ninabulu ara na tasiqu? Mu pojania ko mi lame tokansiu,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Poni sa oea i Jisu sisa, <<Mata, Mata! Qu takulanganiria beto qu tadungananiria soku ngavulu sakasava sao! ");
INSERT INTO lga_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ba kame gu sa sa pada muna isongia, ko i Mere sa sa vilea sisa na sakasava jongana jola. Ko minake tateku variunia isa sa na sakasava isa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kai rane sa lao vavara pa kai ia si Jisu. Ko totonai sa beto vavara, sa lao sa kame ira na ona sepele ko pira sau, <<Bangara, mu vagigalainigei na vavara kai muqisi podeke vei i Jone ba sa vagigalainiria tugu na vavara sira na ona sepele,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Poni sa pira sauniria i Jisu sira, <<Tonai muna vavara sa pira mugu: <Tamamei, Mi tapangaga na isongomu liosona. Mu valamea na mua binangara. ");
INSERT INTO lga_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Doru rane mu vanigei na tetekuna mene toania na rane isa. ");
INSERT INTO lga_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mu taleosoniria sira na mei sela, ura agei ba qe taleosoniria tugu sira qai roiti lame sela tamigei. Beto muke valaogei pa totoke!> mugu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Beto sa pira sauniria sira na ona sepele, <<Vei kame agou sa bi lao na korapa bongi pa ruma tana ona baere, ko pira biunia, <Qokolo, mu vanisiu mai kue batu bereti, ");
INSERT INTO lga_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ura kai qua baere sa korapa lekogonia kai ona rerege sa sa koni kamu vasiborosiu, ko kepore na gaqu gagani mana vania!> biu. ");
INSERT INTO lga_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Poni pira biu sa na ona baere pa leo ruma, <Muke vaduvilisiu, sa tei patei tu sa na atakamana, ko ara beto ira na qua koburu ba qe tei puta tu. Maneke boka tatakole lao vanigo sisa vei qu nyoguania ao,> biu sisa. ");
INSERT INTO lga_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ba ma pojanigou ara sagou: vei minake tatakole vania tu na bereti sisa ura nona baere jonga gu ke biu tu sisa, ba pa ginuana kita mi kea talenia sa kode mai pojai ira na tinoni minagu, poni sa kode mina tatakole gu sa na tinoni sa tei kole tu api ko mina vania gu sira sa nyoguania na tinoni sa tepa ina. ");
INSERT INTO lga_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ko sa vei sa ara ma pojanigou agou: mu tepa ko mi taianigou, mu nyaqo ko mu batia, mu kikia ko mi tarevanga vanigou. ");
INSERT INTO lga_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ura na tinoni sa tepa sa sa tekua, na tinoni sa nyaqo sa sa batia, beto na tinoni sa kikia sa sa tarevanga vania. ");
INSERT INTO lga_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Agou na tamadi na koburu sa vei bi tepagana igana sa kai tumiu, sa ai vei kode muna vania na dole? ");
INSERT INTO lga_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Babi tepagana toruru sisa, sa ai vei kode muna vania na mede? ");
INSERT INTO lga_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Agou na tinoni ikikeremiu tu ba qu balaumiu vaniria tugu na sakasava jongadi sira na tumiu. Ko ai mina koi vei jongana jola sa na vaiia tana Tamamiu pa noka, ura isa sa jongana jolaniria ira na tinoni. Kode na Gagala Tabuna tu ba mina vaniria sira qai tepa lao tana!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ego kai totoso sa iju palea i Jisu sa kai tomate popokana tana kai tinoni ko totonai sa votu riu na tomate sa sa podalai paranga sa na tinoni isa. Ko tonai qai batia sa vei isa sa qai gabara beto sira doru tinoni. ");
INSERT INTO lga_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ba kaki ira sa pira qarigu, <<I Beelizebulu gu, na bangaradi na tomate, sa vania na neqi sa sa boka ijiju paleria na tomate ikikeredi sina!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Goto kaki ira sa qai nyogua podekia si Jisu ko qai tepai sisa ko mi roitinia kai roiti vaivagabarana, ko mai boka vasosotoa sa na lame veina tugu tana Tamasa sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ba sa tei gigilariaona tu i Jisu sa na dia roroqu, ko pira sauniria, <<Na binangara sa tapipikata pa okokoto pukuna ko qai vavaipera mule mekadi sa kode mina tajegara. Beto na tatamana sa pikata mulenia ko mai vaikana mekadi ba mina tajegara tugu. ");
INSERT INTO lga_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ko inara sa vei ko vei na binangara ti Setani sa bi okoto tapipikata ko bai vavaipera mekadi, sa ai mina vei beto mina boka turu vamauru? Kode minake boka! Qu paranga sagou, <I Beelizebulu gu sa vanisiu na neqi sara sa qa boka iju paleria ara sira na tomate ikikeredi,> qugu. ");
INSERT INTO lga_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ego, vei bi sosoto tugu sa pa neqi ti Beelizebulu tugu sa ba iju paleria na tomate ikikeredi sara, sa pa neqi ti sei sa qai ijiju pale tomate sira na miu sepele mekamiu sagou? Mina vei inara sa ira na miu sepele mekamiu gu ba qai pitugou sa qu sela tugu sagou! ");
INSERT INTO lga_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ba ara sa pa neqi tu tana Tamasa sa qa iju paleria sira na tomate ikikeredi, ko inara sa vei sa sa kaberena gu sa na binangara tana Tamasa sa sa tei togagou tu sagou. ");
INSERT INTO lga_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tonai sa vatana vatalenia mai tu na tinoni neqi sira na ona sakasava vaipera beto sa kole kopu vatalenia sa na ona ruma, sa maike boka tangangulu sira na ona sakasava. ");
INSERT INTO lga_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ba totonai mina kamu mule sa kai goto isa sa neqina jolania sa na tinoni neqi api ko mina raja vakilasia, poni sa mina boka teku variu betonia sira doru ona sakasava vaipera sa kole rarangeria na tinoni neqi isa ko mina ia vaipikatainiria sira doru sakasa tana. ");
INSERT INTO lga_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Isa sake somana vei taqu sa sa talesiu ara sisa, beto isa sake vaikamu tokanisiu ara sa sa vaipipiarai sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","<<Tonai sa taiju pale sa na tomate ikikerena tana kai tinoni, poni sa lekogia isa sa doruna na qega kepore na piena, ko sa kole nyaqoa na ia ketakoi mina boka minere. Totonai sake boka batia isa sa kai ia vei mina boka suveria, sa sa paranga sisa, <Ma mule ligu gu pa qua ruma ketakoi qa suvere momoe ara,> sau. ");
INSERT INTO lga_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ko totonai sa mule kamu sa sa batia sa tei tasaqu valioso tu beto sa tei tavatana vatale tu sa na ruma. ");
INSERT INTO lga_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Poni sa mule riu sisa ko sa toni kamuniria mutugu sira ka vitu tomate qai ikere jolania mekana ko qai kamu kole tana tinoni isa. Ko pa liguna qai kamu kole ira sa na toa tana tinoni isa sa sa ikere jolania na totoso momoe,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ego totonai sa korapa paranga vei inara si Jisu, sa sa kuku votu pa vaikamu tinoni sa kai rereko, pira sau, <<Sa tamana sa na rereko sa vapidokigo beto sa vasusugo ao,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Poni pira sau si Jisu, <<E, ba ira tu qai tamana jola sa ira qai nongoria beto qai tutia na paranga tana Tamasa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ego tonai qai vaikamunia ira na minete tinoni, sa sa podalai paranga sisa, <<Na sasae tinoni kopira sa sake tuvisi! Qai nyoguania bi taroiti mai tu kai roiti vaivagabarana beto bai vasosoto qarigu, ba kepore sa kai vinagigila mana vanigou ara goto isa tugu na vinagigila veveina i Jona. ");
INSERT INTO lga_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kai muqisi podeke i Jona sa na vinagigila tadira na tinoni pa Ninive, poni sa na Tuna na Tinoni ba kode na vinagigila tugu tadira na sasae tinoni kopira. ");
INSERT INTO lga_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pa rane vaituti sa kode mina turu na kalao pa Siba ko mina tokegou sagou na sasae tinoni kopira. Ura na souna jola sa nona gugusu ba sa lame mamate tugu nongoria isa sa na boboka beto na vaivagigalai ti Solomone. Ba ma pojanigou ara sagou: korapa gu kopira lani sisa kame sa lavata jolania i Solomone. ");
INSERT INTO lga_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Pa rane vaituti sa kode mai turu ko mai tokegou ira na tinoni pa Ninive sagou na sasae tinoni kopira. Ura ira sa qai gabala loaria na dia sela totonai qai nongoria na tarae ti Jona. Ba doro! Korapa gu kopira lani sisa kame sa lavata jolania i Jona,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","<<Kepore sa kai tinoni mina vatoai beto mina vatoqoa pa ia paena babi vaopo tarini kadakita sa na juke, goto mina toqoa tugu pa ona totoqona ko mina vakabereria sira doru tinoni mai tome pa leo ruma. ");
INSERT INTO lga_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na jukena na tini sa na matamu. Vei na matamu sa mina jongana, sa na tinimu doruna kode mina tolangania na kabere. Goto vei mina ikere sa na matamu, sa kode na tinimu mina rodomo. ");
INSERT INTO lga_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ko sa vei sa mu doro vatalea ko! Kita na kabere sa korapa kole pa mua toa sa na rodomo gu. ");
INSERT INTO lga_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ko vei bi kabere beto sa doru tinimu ko bi kepore vavagila kai rodomo bi kolea, poni sa kode mina kabere beto pudala sa doruna na mua toa. Ko mina vaipodekai puta na juke sa toa ko sa vanigo na kabere,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ego pa liguna sa beto paranga vei inara i Jisu, sa sa sorua kai Parese sisa ko mi lao teteku tavitia isa sau. Ko sa lao tugu pa ruma tana si Jisu, ko sa teteku tavitia. ");
INSERT INTO lga_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ba sa gabara sa na Parese api totonai sa batia sake loqa lima mai beto sa teteku si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ko pira saunia na Bangara sisa, <<Agou na Parese sa na pegurudi gu na miu kapa beto na peleita qu valiosoria, ba pa leomiu sa sa pugelia na ngangangulu beto na ikerena. ");
INSERT INTO lga_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Qu duduvili sagou! Beko qu tei gigilaimiu tu sa isa tugu na Tamasa sa roitinia na peguruna na tinina na tinoni sa sa roitinia na leo tinina na tinoni! ");
INSERT INTO lga_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mu ianiria ira qai vaivasevi sira vei qu kuraniria pa miu kapa beto pa miu peleita, beto sa kode mai tavalioso vanigou sira doru sakasava. ");
INSERT INTO lga_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Mu takulangagamiu tugu sagou na Parese! Ura qu kokole gu vaivanania agou tana Tamasa sa kakame pa manogaputa na miu vuvua pa inuma vevei na miniti, na ru, beto kaki umuma ikikete, ba quke pavunia agou sa na roiti vatuvisi lao tadira na tinoni beto na roroquna na Tamasa. Pira tu sira na kuta vaivagigalai qai garo ko bu kopuniria agou, beto liligu tu bu kopuniria mule agou sira kaki vavanau vevei na kame pa manoga ina. ");
INSERT INTO lga_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Mu takulangagamiu tugu sagou na Parese! Ura qu nyonyogua toqoria agou sira na totoqodi poreveveidi pa ruma vavaikamudi, beto qu nyonyoguania ko mai gosoro qeqeranigou ira na tinoni pa ia mamaketidi. ");
INSERT INTO lga_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mu takulangagamiu tugu sagou! Ura qu kai muqisi podeke vei ira na pou tomate qaike tavakoleniria na vinagigila ko ira na tinoni qaike batiria sa na pou ira ko qai kesaria totonai qai rerege jola,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Poni sa paranga laoa kame ira qai vavaivagigalainia na Vavanau sisa, <<Tinoni vaivagigalai, tonai inara qu paranga vei sao sa qu komiti vivikeregei tugu vei sagei!>> sau. ");
INSERT INTO lga_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Poni sa pira sau si Jisu, <<Agou na tinoni vaivagigalai qu vavaivagigalainia na Vavanau ba mu takulangagamiu tugu vei! Ura pa miu ruruvatana na Vavanau sa qu vapogosoniria na pogoso mamata agou sira na tinoni. Ko qaike boka tuti betoria. Beto mekamiu agou ba kepore kai karusumiu bi aru lao ko bu podeke vakopele vaniria na pogoso sira na tinoni. ");
INSERT INTO lga_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mu takulangagamiu tugu sagou! Ura qu roiti vasari vatataleniria agou sira na poudi ira tugu na tinoni kokorotai qai bosoniria na miu tite pa moa. ");
INSERT INTO lga_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ko sa tabata vakabere gu pa miu roiti sa agou ba qu vaegoa tugu sa na roiti ikikerena qai roitiniria ira na miu tite pa moa. Ura ira kisa qai vaivamate, goto agou gu ko qu roitiniria na poudi ira na tinoni kokorotai. ");
INSERT INTO lga_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Pana ginugua tugu api sa sa paranga sa na Tamasa pa ona gigalai tavagigala, pira sau, <Mana garunu laoniria ara sira na tinoni kokorotai beto ira na tinoni pogoso nongoro, ko kaki ira sa kode mai vamateria, goto kaki kode mai nganganguluria,> sau. ");
INSERT INTO lga_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ko inara sa vei sa kode mina tagorenia tugu na sasae tinoni kopira sa na vinakilasa lavata pa ginuana qai tavamate ira na tinoni kokorotai tonai vei sa roitinia na kasia gusu na Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ko sa podalai tugu pa vamatena i Ebolo ko sa kamu ti Zakarae isa sa tavamate pa leo ruma zelepade, pa vaikorapaidi na lose tabuna beto na ia vavavakukuvuna. E! Ma poja vatalenigou ara sagou: ira na sasae tinoni kopira sa mai gosoroni vinakilasa! ");
INSERT INTO lga_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mu takulangagamiu sagou qu vavaivagigalainia na Vavanau! Ura qu teku palea agou sa na viduluna na atakamana sa tome lao pa gigigalaina na Tamasa. Ko mekamiu ba quke tomea tugu, beto qu suquturia tugu agou sira qai korapa popodeke lao tome ketakoi,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Totonai sa taloa pa ia isa si Jisu sa qai podalai kanai ira qai vaivagigalainia na Vavanau beto ira na Parese sisa, ko qai nanasa jujukunia isa sira na veveidi soku sakasava vei ko mi paparanga sisa qarigu. ");
INSERT INTO lga_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ira qai kole gu doro kopunia sisa ko mai doro poai ketakoi mina paranga vaselaniria isa kaki paranga qarigu. ");
INSERT INTO lga_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ego totonai sa qai vavaikamu lao tana sa na minete tinoni. Na soku tina sira qai vaikamu lao ko qai korapa vavaitete kakale tu mekadi, sa sa paranga momoeria i Jisu sira na ona sepele, <<Muna balaunia agou sa na toa vavabata seseke tadira na Parese sa vei na vavakovuruni palava. ");
INSERT INTO lga_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ura na sakasava sa tatuki tari sa mina tatakele votu, beto na roroqu tagolomona sa kode mina tagigila tadira na tinoni. ");
INSERT INTO lga_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Isa qu vavaipaparangania pa rorodomona sa mu vevelania pa kakaberena ko mi tanongoro, beto ko isa qu vaimamanasania pa leo lose sa mina tavevela pa are ruma,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","<<Ego ma pojanigou, ka visa qua baere, muke matagutuniria sira qai boka vamatea na tini gu ba pa liguna isa sa qaike boka roitinia mule kai sakasava ikerena pa miu toa. ");
INSERT INTO lga_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ba ma ule vanigou ara sa isa vei mu matagutunia agou. Mu matagutunia sa na Tamasa, isa tu sa sa koleona na ona neqi ko pa liguna sa vamatea isa na tini sa kode mina boka valaogou tugu vei pa niku pa heli. Na sosotona sapi ko isa sa mu matagutunia agou! ");
INSERT INTO lga_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Na tagigilana sa na laodi ka lima pitikole sa karu memeka pene gu! Ba kepore kame ira sa sa roqu mumania na Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Goto agou sa na vurungumiu gu pa batumiu ba sa tei gigila betoriaona tu na anyedi na Tamasa. Ko sa vei sa muke matagutu. Ura agou sa qu poreveveina jolaniria joa ngavulu pitikole!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","<<Ma poja vatalenigou ara sagou: na tinoni sa ule votunisiu ara pa moedi ira na tinoni ko isa sa kame taqu sau, sa kode mina ule votunia tugu na Tuna na Tinoni pa moedi ira na mateana tana Tamasa sisa. ");
INSERT INTO lga_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Goto na tinoni sa kilu palenisiu ara pa moedi ira na tinoni, sa kode mina kilu palenia tugu pa moedi ira na mateana tana Tamasa na Tuna na Tinoni sisa. ");
INSERT INTO lga_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na tinoni sa paranga vasela laoia na Tuna na Tinoni sa mina boka taleoso gu. Goto na tinoni sa vamoroania na Gagala Tabuna sa minake isongo taleoso sosoto sisa. ");
INSERT INTO lga_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Tonai mai toni ragata laonigou pa vaituti pa ruma vavaikamuna, pa moedi ira na bangara babi na qavuna, sa munake roroqu mamatania ai mene paranga vei babi na sa mene pojai sa mene talegasa munakeu. ");
INSERT INTO lga_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ura kode na Gagala Tabuna tu mina ule vanigou pa totoso isa sira na paranga tuvisidi muna pojaria agou,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ego kai tinoni pa vaikamu minete tinoni sa pira saunia si Jisu, <<Tinoni vaivagigalai, mu pojania na tugaqu marene ko mi pikata vanisiu na isisongo sa loa vakole vanigei na tamamei,>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Poni sa pira saunia i Jisu sisa, <<Qokolo, nake qua roiti ara sa mana pitugou beto mana pikata vanigou na miu sakasava qu isongoria agou karu!>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Beto sa pira sauniria i Jisu sira doru, <<Mu kopu mulenigou! Muke vapugelenia na nyoguana na isisongo sa na miu toa. Ura na toa tana tinoni sa sake kole pana pugele nyonyoana na ona isisongo,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Beto sa pojaniria sa na vavakato vavapada api: <<Koleona sa kai tinoni isisongo ko na ona peso sa masuru vatale. ");
INSERT INTO lga_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sa kole vaipera na roquna mekana sisa, pira sau, <Kepore mule sa ketakoi vei mana vakoleniria mule kaki qua vuvua mana tekuria pa qua inuma sara. Ko na sa beka sa mana roitinia ara?> sau. ");
INSERT INTO lga_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Beto pira sau, <Jongana, pira gu mana roiti vei sara. Mana jegara paleria sira na qua ruma vavakoleni gaganina ko mana roiti valavataria. Ko ketakoi sa mana vakoleniria na gaqu gagani mana tekuniria pa qua inuma beto kaki qua sakasava mule.> ");
INSERT INTO lga_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Beto sa pira mana paranga veinisiu mekaqu, <Marene ikete! Kopira tu sa vavagua sa na mua toa! Qai kubo jola na mua sakasava jongadi na padana na kubo aoro. Mu mavonia gu, mu teteku beto mu bubuku vapopotegamu, beto mu suvere qeqeramua!> managunisiu,>> sau sa na tinoni isisongo. ");
INSERT INTO lga_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ba pira saunia na Tamasa sisa, <<Na duduvili sao! Pa bongi tugu api mina tateku pale sa na toa tamu. Ko i sei mina isongoria sira na mua sakasava qu buti vaikamuniria inara?>> saunia. ");
INSERT INTO lga_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","<<Ko inara kode mina vei sa na tinoni sa boko vaikamu ona sakasava mekana pa peso ba sake isisongo pa dodoro tana Tamasa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Beto sa pira sauniria i Jisu sira na ona sepele, <<Ko sa vei inara sa ara ma pojanigou: muke kole mamatania na miu toa beto na sa muna gania, babi na tinimiu beto na sa muna pokonia. ");
INSERT INTO lga_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Na miu toa sa sa poreveveina jolania na gagani, beto na tinimiu sa sa poreveveina jolania na poko. ");
INSERT INTO lga_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mu doro laoria sira na manugu qai tatava ko! Ira sa qaike umuma beto qaike ababu, beto sa kepore tugu vei na dia ruma vavavakoleni gaganina, ba na Tamasa sa iaria gu sinara! Ba agou tu sa qu poreveveina jolaniria na manugu tatatavadi! ");
INSERT INTO lga_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","I sei agou tonai sa kole suvere takulanga poni sa tei boka vakakasia mai tu iapeki sa na ona toa? Bi mija tugu! ");
INSERT INTO lga_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ko vei muna oqoro boka roitinia agou sa kai sakasava ikete vei inara, poni sa ai sa vei qu korapa takulanganiria mule kaki goto sakasava? ");
INSERT INTO lga_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mu dogoro laoria sira na avoro pirudi ko! Qaike pavu talenia na roiti beto qaike pipitidia poko sira. Ba ma poja vatalenigou ara sagou: pa doruna na isisongo ti Solomone na bangara, sa kepore kai poko tana sa bi babata jonga vei kame ira na avoro pira. ");
INSERT INTO lga_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ira gu na avoro qaike toa vasovai beto qai tagona lao pale pa niku ba sa vapopokoria tugu na Tamasa sira. Ba agou sa qu poreveveina jolaniria na avoro, ko sa sosoto jola sa kode mina vapopokogou isa. Sa ikete jola na miu rarange sagou! ");
INSERT INTO lga_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ko inara sa vei sa, muke nyaqo gogojoria doru totoso agou sa na sakasa muna gania na bukua beto mike rabeke na miu roroqu. ");
INSERT INTO lga_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ura ira doru sakasava pira sa ira na tinoni rodomo pa kasia gusu sa qai nyaqo vivitigiria, goto agou na tamamiu pa noka ba sa tei gigila betoriaona tu sa muna toaniria agou sira na sakasava veveidi pira. ");
INSERT INTO lga_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Goto agou sa mu nyaqo momoea mai tu na binangara tana Tamasa, beto mina vanigou isa sira doru sakasava veveidi aipira,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","<<Muke matagutu, qua minete, ura na Tamamiu pa noka sa na ona binangara tu ba sa tei vajonganai tu ko mina ianigou. ");
INSERT INTO lga_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mu vavainiria sira na miu isisongo beto na poatadi sa mu ianiria ira qai golaba. Mu tekua na pausu isa sake boka taunyara talulutu, isa sa na isisongo pa noka. Pa ia ketakoi sa mineke maragutu manyao, kepore na tinoni mai boka ikoa, beto na tamo minake boka ganiria. ");
INSERT INTO lga_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ura ketakoi qai kole na miu isisongo sa ketakoi tugu qai kole sa na bulomiu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","<<Mu suvere vanaqiti doru totoso. Mu vei ira qai saqiti vamaururia na dia poko roiti ko qai vanaqiti roiti, beto muke vakipuria na miu juke. ");
INSERT INTO lga_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mu suvere gegele vei ira na nabulu qai korapa verania na mule lamena na dia bangara sa lao somana pa vavolo vaialava. Ko totonai mina mule lame ko mina kikia pa atakamana, sa mai sisiqarai revanga vania na atakamana. ");
INSERT INTO lga_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mai qera sira na nabulu ira totonai sa lame kamu na dia bangara sa qai korapa suvere gegelenia isa! Ma poja sosotonigou ara sagou: mina vasaea isa sa nona poko ninabulu, mina valao veraria pa tevolo sira ka visa nabulu pira ko mina vatana vaniria na tetekuna ko mai teteku. ");
INSERT INTO lga_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ko vei bi na korapa bongi tu sa babi na jola korapa bongi tu sa bi mule lame batiria bai korapa gegelenia, poni sa mai qera tugu sira. ");
INSERT INTO lga_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mu nongoro vakoititia sapi! Vei bi tei gigila momoea tu na tinoni poreona ruma sa na totoso lame tana tinoni ikikona sa kode mina dorava ko mina kole verania ko mina totoke susuqutunia sa nona ruma ko minake boka pururu tome laoia na tinoni ikikona. ");
INSERT INTO lga_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ko inara sa vei sa agou ba mu kole suvere vanaqiti. Ura na Tuna na Tinoni sa kode mina mule lame pa totoso agou quke rove veinia mina lame,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Poni pira sau si Pita, <<Bangara, tamigei na sepele gu qugunia ao sa na vavakato vavapada api, ba tamigei doru tinoni tugu?>> sau. ");
INSERT INTO lga_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Poni pira sau sa na Bangara, <<I sei sa na nabulu tarangena beto na tavagigalana? Isa tugu sa na nabulu mina vaivivai na bangara ko mina kopunia na ona ruma, ko isa sa mina ianiria mule na gagani ira kaki ona nabulu pa totoso tavilena. ");
INSERT INTO lga_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mina qera sa na nabulu isa vei mina korapa roiti vatale vei inara isa totonai mina mule lame batia na ona bangara. ");
INSERT INTO lga_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ara ma poja vatalenigou sosoto: mina vaiviva lavatia na ona bangara sa na tinoni isa, beto mina vakopuniria doru ona isisongo. ");
INSERT INTO lga_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ba vei bi roroqu sa na tinoni isa, <Koi, kode minake oqani mule sa na qua bangara,> biu, ko bi podalai mamaja lalameniria sira na nabulu marene beto na nabulu rereko, beto bi kokole gu ngongoja vapopotegana beto bi kole bubuku vadidigerenia gu, ");
INSERT INTO lga_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","poni sa totonai mina korapa gu roiti vei isa inara pa rane na totoso sake rove veinia mina mule na ona bangara, sa kode mina mule kamu sa na bangara tana nabulu isa. Kode mina vakilasa vatalea na bangara sisa, beto mina gona laonia tadira qaike vakepore sosotoa na Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ko na nabulu sa gigilaiona sisa vei sa nyoroguania na ona bangara ba sake vanaqiti beto sake roitinia sisa vei sa nyoroguania nona bangara, sa mina tapipiqolo vatale sisa. ");
INSERT INTO lga_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Goto na nabulu sake gigilai na manugu sa nyoroguania na ona bangara, ko sa roitinia sisa bi boka tapiqolonia, sa kode minake loka neqina sa na piqolo mina tekua isa. Ba isa sa ia vakukubo vania na Tamasa ko mina kopuniria, sa na kukubo tugu sa sa nyoguania ko mina vaiiania na tinoni isa. Ko isa sa taiania na sokuna sa kode na sokuna tugu sa mai tepania ira na tinoni sisa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","<<Na iku tu sa qa pogoso lagerenia ara pa peso, ko na qua nyorogua sa bi oqani toa vuvurungu tu sisa qau! ");
INSERT INTO lga_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ba kai paputaiso vitigi sa kode mana tomea mai ara, ko isa sa qa korapa takulangania ara tinganai mina jola tu isa. ");
INSERT INTO lga_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kita mu roroqua agou sa na bule sa qa pogoso lamenia ara pa peso kita mugu. Dai! Ma pojanigou: nake bule sa qa pogoso lamenia ara, goto na vaipikatai tu. ");
INSERT INTO lga_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Podalai kopira sa vei ira ka lima sa pa kai puku tatamana, sa kode mai vaikana ko ira kue kode mai rajaria ira karu, ira karu mai rajaria ira kue. ");
INSERT INTO lga_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kode mai vaipikatai ko na tamadi mina kanai na tudia marene, na tudia marene mina kanai na tamadi. Na tinadi mina kanai na tudia rereko, na tudia rereko mina kanai na tinadi. Na tinadi sa mina kanai na ona roroto rereko roadi, na roroto rereko roadi sa mina kanai na roadi rereko,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Beto sa paranga laoria i Jisu sira na minete tinoni, <<Isa tugu qu batia agou sa na pauku sa lame vei pa kale suvu tapo, poni sa quke ruavo tugu paranga vei pira sagou, <Koi, kode mina lame sa na qolapeso,> qugu, poni sa okoro tugu sa neqa. ");
INSERT INTO lga_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Beto isa tugu qu turu bata lao vei pa suvu tapo ko qu vagigilai na gava sa raja keta pa kale merimiu, sa qu paranga sagou, <Koi, kode mina dadanga sa neqa,> qugu, poni sa dadanga tugu sa neqa. ");
INSERT INTO lga_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Na tinoni vavabata sesekemiu sagou! Qu boka doro gigalia agou sa na rijodi beto na kanokodi na peso beto na vavagalo eqa, ba ai sa vei ko quke boka tu doro gigilai agou sa na roiti sa roitiniria na Tamasa pa totoso api?>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","<<Beto ai sa vei ko quke boka tu doro pikatia mekamiu agou sa na roiti tuvisina? ");
INSERT INTO lga_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tonai qu korapa lalaomiu tana tinoni vaituti sa agou karu na mua kana, sa mu podeke vivitigia ko mu vatuvisi momoea ko mu popoa mai tu sa na mua tapata tonai qu oqoro lao ao pa vaituti. Ura vei tonai muna kamua ao sa na ia vavaipituna, sa kode muna tatoni lao tana tinoni sa roitinia na vavaipitu, ko na tinoni sa vavaipitu isa mina valaogo tana tinoni kopu ruma vaipiu, beto ko na tinoni kopu mina vatomego pa ruma vaipiu sao. ");
INSERT INTO lga_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ko ma poja veinigo pira ara sao: kode munake votu pa ruma vaipiu sao, tinganai muna lipu vaokotia ao sa na padana qu tavakilasania,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ego pa totoso isa sa qai lao vavakatonia ira kaki tinoni tai Jisu sa na veveidi kaki tinoni Qalili i Paelati sa vamateria ko sa qairi vaisomanainiria na dia vavakukuvu sa na orungudi. ");
INSERT INTO lga_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Poni sa oeria i Jisu sira, pira sauniria, <<Ai vei? Qu roroqua agou sa ira sa na tinoni seladi jolaniria ira doru tinoni Qalili ko sa vei sa qai tavamate pa soana ikerena vei inara? ");
INSERT INTO lga_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Dai sosoto! Ma poja sosotonigou: vei munake gabala loaria na miu sela, sa agou ba muna mate vei tugu ira! ");
INSERT INTO lga_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ai vei mule sira ka manogavesu tinoni ira sa vukele tako vamateria na ruma ululuna pa Siloami? Ai vei? Qu roroqua agou sa ira sa na tinoni ikikeredi jolaniria ira qai suvere pa Jerusalema ko sa vei sa qai mate vei inara? ");
INSERT INTO lga_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dai sosoto! Ma pojanigou: vei munake gabala loaria na miu sela, sa agou ba muna mate vei tugu ira inara sagou!>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Beto sa sa pojaniria i Jisu sa na vavakato vavapada api: <<Koleona sa kai tinoni sa isongia kai gou piqi pa ona inuma. Ko sa lao ko sa nyaqogana vuana ba sake batiaona kame. ");
INSERT INTO lga_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ko sa pojania sa nona tinoni roiti pa inuma, <Doro! Kue aoro qai jola pira qa lalame ovikia ara sa na gou piqi api, ba kepore kai vuana ba batia. Mu lao rio palea! Kepore laona mina turu jola sina, ura sa korapa gani vamate goboria na peso!> sau. ");
INSERT INTO lga_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ba sa oea ko sa paranga sa nona tinoni roiti pa inuma, <Koi, bangara! Muke vei! Vakolea mai pa aoro api. Kode mana geli amu tari vavailivutainia na peso na kutana beto mana vakole vania na teni bulumakau. ");
INSERT INTO lga_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ko vei mina vua pa aoro sa lame api, poni sa muna loai ko mina turuona. Goto vei minake vua tu isa, sa tonai sa muna soni rio pale!> sau sa na tinoni isa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kai rane Minere sa kole vaivagigalai pa kai ruma vavaikamuna si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Korapa ketakoi sa kai rereko sa varajania na tomate ikikerena ko sa mo manogavesu aoro, ko sa poguru ko sake boka turu vatuvisi vatale. ");
INSERT INTO lga_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Totonai sa batia i Jisu sisa, sa sa kuku tekua ko pira saunia, <<Tinaqu, kopira qu tasalana pa mua mo sao!>> sau sisa, ");
INSERT INTO lga_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","beto sa vaoponia na limana isa sa na rereko. Isa tugu sa vei isa sa sake ruavo tugu turu vatuvisi liguona gu sisa, ko sa vatarasaea isa sa na Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ba na kuta tinoni mamata pa ruma vavaikamuna sa sa tagigirinia sa na veveina sa salana tinoni pa rane Minere si Jisu, ko pira sauniria sira na tinoni, <<Ka vonomo rane sa sa vamalumia na Vavanau ko tana boka roiti gita na tinoni! Ko mu kamu tasalana pa rane ira, goto nake pa rane Minere!>> sau. ");
INSERT INTO lga_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Poni sa oea na Bangara sisa, pira saunia, <<Na tinoni vavabata sesekemiu sagou! Agou ba qu ruruvata tekuria tugu pa dia tuturuna pa rane Minere sa na miu bulumakau beto na dongiki ko qu toni riu vabukuria tugu pa rane isa. ");
INSERT INTO lga_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Na tuvisina gu sa sa taruvata pa ona mo pa rane Minere sisa. Ura na rereko api sa kai tuna tugu i Ebarahami sisa ba sa tapiu ti Setani ka manogavesu aoro,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Totonai sa paranga bei veiniria i Jisu inara sa qai kea sira qai kanai isa, goto ira doru tinoni sa qai qera jolaniria sira na sakasava vaivagabaradi sa roitiniria isa. ");
INSERT INTO lga_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ego ko sa nanasaria i Jisu sira, <<Ai sa vevei sa na binangara tana Tamasa? Na sa mana vavapadania ara sisa? ");
INSERT INTO lga_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Na binangara tana Tamasa sa sa vei na kiko masitadi. Kai tinoni sa sa tekua kai kiko masitadi ikete ko sa umania pa ona inuma. Ko sa pidoko sae sisa, ko sa vei kai gou lavata, tinganai qai tatava kamu na manugu ko qai roiti dia vovori na alale pa okokoto kaena,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Beto sa pira mule sau i Jisu, <<Na sa mule mana vavapadania ara sa na binangara tana Tamasa? ");
INSERT INTO lga_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Sa vevei gu na vavakovuruni palava sisa. Kai rereko sa sa tekuria kaki vavakovuruni palava ko sa qairi laonia pa kai bakete palava, tinganai ko sa kovuru sae beto sa na palava,>> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ego sa rerege lao vei pa gugusu lavatadi beto na ikiketedi si Jisu ko sa kole vavaivagigalai tadira na tinoni, totonai sa korapa jola gore vei pa Jerusalema. ");
INSERT INTO lga_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Totonai sa kame ira sa sa nanasia sisa, <<Bangara, kode ira ka vivisa tinoni gu sa mai taalo?>> saunia. Poni sa pira sauniria i Jisu sira na tinoni, ");
INSERT INTO lga_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","<<Mu vaipera viviva ko mu tome laoa na atakamana ngijupuna. Ura ma pojanigou ara sa ira na soku sa mai nyogua tome ba maike boka. ");
INSERT INTO lga_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Isa tugu mina turu lame sa na bangarana na ruma ko mina patei palea sa na atakamana, sa muna turumiu tugu pa peguru ko muna kole kikia, beto pira munagu sagou, <Bangara, mu revanga vanigei na atakamana!> munagu. Ba tonai mina oe votu sisa, <Qake gigilagou ara ketakoi na lame veimiu sagou!> minagu. ");
INSERT INTO lga_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tonai sa kode pira munagu sagou, <Koi, agei ko qe teteku tavitigo beto qe buku tavitigo ao, beto ko ao gu ko qu kamu vaivagigalai pa soana lavata pa mei gugusu!> munagu. ");
INSERT INTO lga_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ba mina paranga sisa, pira minagunigou, <Mu riu! Mu taloa taqu agou doru tinoni ikikeremiu! Ara qake gigilagou ketakoi na lame veimiu sagou!> minagunigou isa. ");
INSERT INTO lga_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ko ketakoi muna lukana uui beto mina ngingisi tu na livomiu sagou, totonai muna batiria ira Ebarahami, i Aisake, i Jekopi, beto ira doru tinoni kokorotai pa leona na binangara tana Tamasa, goto agou mekamiu sa muna tavakole pale pa peguru. ");
INSERT INTO lga_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Beto ko ira na tinoni mai lame vei pa doru eqa pa made uquna na kasia gusu sa mai tome, ko mai somana teteku pa vavolo pa binangara tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ko ira qai liligu sa mai momoe, goto ira qai momoe sa mai liligu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ego pa totoso tugu isa sa qai lao parangia ira kaki Parese si Jisu, pira qarigu, <<Mu siqarai rijo lao pa kai goto eqa ao, ura i Herodi sa korapa kuonigo ko mi vamatego sau,>> qarigunia. ");
INSERT INTO lga_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Poni pira sauniria i Jisu, <<Mu lao pojania sa na pokese nganganguluna poni, pira sau i Jisu mugunia, <Ara sa kopira qa korapa iju paleria na tomate ikikeredi beto qa vaisalana pa ngeni ko vuka, ko pa rane vinaue tu sa mana vaokotia ara sa na qua roiti sau,> mugunia. ");
INSERT INTO lga_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ba jongana, mana jokelia na qua rerege lao pa Jerusalema sara pa ngeni, vuka ko risa, ura nake pa goto eqa goto pa Jerusalema gu sa na mamatena tana tinoni kokorotai. ");
INSERT INTO lga_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Kei, Jerusalema, Jerusalema! Agou na tinoni pa Jerusalema qu vai vamateria na tinoni kokorotai beto qu buti tariniria na patu sira sa garunu laoniria na Tamasa tamugou! Kubo totoso sa qa nyogua teku vaikamunigou, ba veinigou na kokorako sa vaonguria na boko tuna pa babanana ko sa kopuniria qau, ba quke vamalumusiu tugu ko ba veinigou. ");
INSERT INTO lga_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ko inara sa vei sa, mina taloa pale ko mina ivulu gogoe sa na miu ruma zelepade. Ma poja sosotonigou ara sagou: munake isongo batisiu ara sagou, tinganai mina kamu na totoso muna paranga vei pira, <Sa tamana sisa sa lame pa korapa isongona na Bangara,> munagu,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ego pa kai rane Minere totonai sa lao teteku pa ruma tana kai iviva tadira na Parese si Jisu, sa qai kole dodoro kokopunia ira na tinoni sisa. ");
INSERT INTO lga_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ko sa korapa ketakoi pa moena i Jisu sa kai tinoni sa varajania na mo ko sa pupugele na nenena na limana. ");
INSERT INTO lga_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Poni sa nanasa laoria i Jisu sira na tinoni qai vavaivagigalainia na Vavanau beto ko ira na Parese, <<Ai vei, na tavamalumuna tugu pana Vavanau sa na vavaisalana pa rane Minere, ba dai?>> sauniria. ");
INSERT INTO lga_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ba qaike vagala sira. Poni sa aru tekua i Jisu sa na limana na tinoni sa mo ko sa salania, beto sa vamule riua. ");
INSERT INTO lga_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Beto sa pira sauniria, <<Bi vei kame agou sa bi vukele jolopo pa kai baongo lavata pa rane Minere sa na ona dongiki babi kai ona bulumakau, sa ai muna vei sagou? Munake boka sisiqarai lao bako votunia sisa pa rane Minere tugu isa?>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ba qaike boka oea ira sa na nanasa tana. ");
INSERT INTO lga_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ego sa tei doro poaria tu i Jisu sira kaki tinoni qai tasoru sa qai vivileria na totoqodi poreveveidi pa totoso teteku, ko sa parangaria sira, ");
INSERT INTO lga_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","<<Tonai bu tasoru lao pa kai vavolo vaialava sao, sa muke jojoro lao pa totoqona poreveveidi, ura kita mi koleona mule sa kai tinoni sa poreveveina jolanigo ao sa oqoro kamu. Ko vei mina kamu liligu sisa ");
INSERT INTO lga_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","sa kode mina lao tamu sa na tinoni poreona vavolo, isa sa sorugou agou karu doru, ko pira minagunigo, <Qokolo, mu vakabere vania na tinoni api sa na totoqona isa,> minagunigo. Ko tonai sa kode muna kea sao beto muna gore toqoa ao sa na totoqona tadira kepore veveidi. ");
INSERT INTO lga_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Goto tonai bu tasoru sao sa mu lao toqo pa totoqona bebetona kepore veveina. Ko totonai mina lame sa na tinoni sa sorugo sa kode pira mina paranga veinigo, <Qua baere, mu toqo kesa sae pa narena lani,> kode minagunigo. Pa totoso tu isa sa muna tavaporeveveina pa moedi ira doru qai tasoru sao. ");
INSERT INTO lga_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ura na tinoni sa vavalavata mulenia mekana sa kode mina vakeai tugu na Tamasa, goto isa sa vaikete mulenia mekana sa kode mina valavatia tugu na Tamasa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Beto sa sa parangia i Jisu sa na tinoni sa sorua isa, <<Totonai muna vatanania ao sa kai tetekuna babi na vavolo sa muke soruria gu sira na mua baere, na tasimu marene, na tavitimu babi ira na tinoni isisongo qai suvere tatago. Ura ira sa kode mai boka soru beigo mutugu kai totoso sao, ko tonai mai vei ira poni sa mina tabei gu sa na roiti jongana qu roiti laonia ao tadira. ");
INSERT INTO lga_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Goto tonai muna roitinia kai vavolo sao sa mu soruria sira tu na vaivasevidi, na qao, ira qai gavere, beto ira na leleqadi tu. ");
INSERT INTO lga_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Mina vei tu isa sa muna tamana sao, ura kode maike boka bei vanigo ira sisa na roiti jongana qu roiti laonia ao tadira. Goto ao sa na Tamasa tu mina bei vanigo pa rane turumule tadira na tinoni tuvisidi,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ego ko totonai sa nongoria kame ira qai somana teteku pa tevolo sa na paranga pira, sa paranga laoia isa si Jisu, <<Mina tamana vatale sa na tinoni mina somana teteku pa vavolo pa binangara tana Tamasa,>> sau. ");
INSERT INTO lga_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Poni sa oea i Jisu sisa, <<Kai totoso sa sa roitinia kai tinoni sa kai vavolo lavata beto sa sa soruria isa sira kubo tinoni. ");
INSERT INTO lga_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Totonai sa kamua sa na totoso vavolo sa sa garunia sa nona nabulu ko sa lao pojaniria sira na tinoni tasorudi, <Mei, lame kopira! Tei tana beto tu doru kai sa,> sau. ");
INSERT INTO lga_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ba qai okoto podalai gogona vapele sira doru. Pira sau sa na tinoni momoe, <Ara sa kai iapeki kobu peso sa qa koni vaia gu, ko ba lao tu ovikia isa qau. Ko mu vamalumusiu gu ko manake lao somana,> sau. ");
INSERT INTO lga_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Beto kai goto sa pira sau, <Ara sa ka manogaputa bulumakau mai raragatia na gegelina pa qua inuma sa qa koni vai tekuria gu, ko qa korapa nyogua lao podekeria. Ko mu vamalumusiu ko maneke lao somana,> sau. ");
INSERT INTO lga_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Beto kame mule sa pira sau, <Ara sa qa koni vaialava gu, ko pa ginugua gu isa sa maneke boka lao sara,> sau. ");
INSERT INTO lga_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Poni sa muleona gu sa na nabulu ko sa lao vavakato vania nona bangara sa na veveidi doru paranga qai pojaria ira. Ko sa tagigiri vivikerenia sa na bangara sa roitinia na vavolo, ko pira saunia sa nona nabulu, <Mu sisiqarai totoniria na soana lalavata na soana ikikete pa leo gugusu, ko mu toni lameniria sira na vavaivasevidi, na qao, na leqa, beto ira qai gavere!> sau. ");
INSERT INTO lga_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pa liguna sa roitinia sisa vei sa garununia nona bangara poni sa mule kamu sa na nabulu, ko pira sau, <Bangara, qa tei toni kamuniria tu ara sira qu garununisiu ao, ba sa oqoro tu pugele sa na ruma,> sau sa na nabulu. ");
INSERT INTO lga_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Poni sa pira saunia na bangara sa na ona nabulu, <Mu votu lao mule keta pa peguruna na gugusu lavata pa soana na eqa pa souna ketakoi qai suvere na tinoni, ko mu tepa vivitigiria sira na tinoni ko mai lame vapugelia na qua ruma. ");
INSERT INTO lga_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma pojanigou ara: kepore kame ira qa soru momoeria sa mina meai iqo gagani pa qua vavolo!> sau sa na tinoni isa,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ego totonai sa korapa lalaona si Jisu sa kai minete tinoni lavata sa tuti laoa, poni sa balinga mule sisa, ko pira sau, ");
INSERT INTO lga_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","<<Na tinoni sa lame taqu ba sake roqu loaria ira na tamana, na tinana, na maqotana, beto na tuna, ira na tasina marene na luluna rereko, beto ko nona toa tugu vei mekana sa sake pada ko mina sepele taqu sa na tinoni vevei isa. ");
INSERT INTO lga_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na tinoni sake pogosia nona korosi mekana ko sake tutisiu ara sa sake pada ko mina sepele taqu sisa. ");
INSERT INTO lga_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Vei kame agou sa bi nyogua roitinia kai ruma lavata, sa kode mina toqo mai sisa ko mina anye votunia mai sa na vaina na ruma, ko mina gigilai mai sa bi pada tugu sa nona poata na vaokotona na ruma ba dai. ");
INSERT INTO lga_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ura vei minake vei inara sisa, sa pa liguna mina vaturua na kokovana beto minake boka vaokotia isa sa na ruma, sa kode mai avavu valedenia ira doru tinoni qai batia nona roiti sisa. ");
INSERT INTO lga_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kode mai paranga sira, <Koi, na bangara api sa sa podalainia nona ruma, ba sake boka vaokotia!> kode marigunigo ira. ");
INSERT INTO lga_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ko mu nongoria mule api ko! Na bangara sa isongia ka manogaputa tina tinoni vaipera gu ba sa nyogua rajai sa kai goto bangara sa isongia ka rabeteputa tina tinoni vaipera, sa mina toqo mai ko mina roroqu vatale mai tu sisa. Mina roroqu vatale ko vei mina bokaona talea isa sa na bangara poni ba dai. ");
INSERT INTO lga_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ko vei mina gigilai minake boka sisa sa mina garunu valaoria sira kaki ona tinoni pogoso nongoro ko mai lao gogosoria sa na bangara neqina totonai sa korapa pa souna tu isa, ko mina tepai isa sa na bule. ");
INSERT INTO lga_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ko agou sa kai muqisi podeke tugu. Inara sa vei ko mu doro vatalea sa na pore laona na tutiqu ara beto mu tutisiu. Ura kepore kai tinoni agou sa mina boka na qua sepele vei minake boka loa betoria isa sa doru ona sakasava sa isongoria,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","<<Na solo sa na jongana, ba tonai mina maragutu na lilingina poni sa kode minake boka tavalilingi bei mule sisa. ");
INSERT INTO lga_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Na solo kepore lilingina sa sake pada mina tavaroiti pa peso babi pa nyanyao nyabodi ko na valaona pa umuma. Goto na padana sa mina tagona palea gu. Na tinoni pore talingi nonongorona sa mi vainongoro!>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ego ko qai kanoko lao tai Jisu sira na soku tinoni teteku takisi beto ko ira na tinoni seladi, ko mai nonongorodia tana qarigu. ");
INSERT INTO lga_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Poni qai podalai ququminia ira qai vaivagigalainia na Vavanau beto ira na Parese sisa, pira qarigu, <<Na tinoni api sa sa vatataria tu sira na tinoni seladi beto ko sa teteku tavitiria tugu vei!>> qarigu. ");
INSERT INTO lga_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Poni sa pojaniria i Jisu sa na vavakato vavapada api, pira sau, ");
INSERT INTO lga_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","<<Vei kame agou sa bi isongia kai gogoto ona sipi ko tonai kame ira na sipi pira sa bi muma, poni na sa mina roitinia sisa? Na tinoni isa sa loa vasuvereria pa qega sira ka siangavulu ka sia sipi, beto sa lao nyaqoa sisa sa muma tinganai ko sa batia tu. ");
INSERT INTO lga_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Totonai sa batia sa sa qera vivitigi, ko sa kovaria pa varana. ");
INSERT INTO lga_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Beto sa sugara mulenia pa nona ruma, sa kuku vavaikamuniria sira na ona baere beto na tavitina, ko pira sauniria, <Mei agou ko mu somana qeqera tavitisiu! Ura kopira qa tei batia tu ara sisa na qua sipi mumana,> sau. ");
INSERT INTO lga_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma pojanigou ara sa kai muqisi podeke puputa vei inara sa na qeqera pa noka sa votunia na gabala mulena kai tinoni selana sa mina jolania na qeqera sa votunia ira ka siangavulu sia tinoni tuvisidi nake padadi ko mai gabala mule,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","<<Bi koleona sa kai rereko sa isongia ka manogaputa ona poata siliva ko kame sa sa vamumai, poni na sa mina roitinia sisa? Na rereko isa sa vurungia na juke, beto sa burungia na ruma beto sa nyaqo beto palea isa sa na leo ruma ko tinganai sa batia tu. ");
INSERT INTO lga_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Totonai sa batia isa sa na poata sa vamumai, sa sa kuku vaikamuniria sira na ona baere na tavitina, ko pira sauniria, <Mei agou ko mu somana qeqera tavitisiu! Ura kopira qa tei batia tu ara sa na qua poata isa qa vamumai,> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma poja vatalenigou ara, kai muqisi podeke vei tugu isa sa ira na mateana tana Tamasa sa qai qeqera tonai sa gabala mule kai tinoni selana,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","<<Koleona sa kai tinoni karu na tuna marene. ");
INSERT INTO lga_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ko na tuna marene pa ligu sa pira saunia na tamadi, <Tamaqu, mu vanisiu gu kopira sa isa na iaqu pa mua isisongo,> sau. Poni sa okoto pikata vaniria na tamadi tadira karu tuna marene sira na ona isisongo. ");
INSERT INTO lga_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ego sa jola gu ka vivisa rane sa sa vavainiria na koburu marene pa ligu api sira doru ona sakasava, ko sa tekuniria na poata, beto sa sa taloa riu pa kai gugusu pa souna. Ketakoi sa lao vanyanyala paleria isa pa toa ikikeredi sira doru ona poata. ");
INSERT INTO lga_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Totonai sa vabetoria isa sira doru vei sa isongoria, sa sa kamu pa gugusu isa sa kai songe lavata, ko sa kepore kai sa bi boka toania sisa. ");
INSERT INTO lga_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ko sa lao tepa roiti tana kai tinoni pa gugusu isa, poni sa garunia na tinoni isa ko sa lao kopu vania na ona borogo. ");
INSERT INTO lga_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Sa vaivasevi ko sa kole dodoro nyonyoroguaniria tugu isa sira na gagani tadira na borogo, ba kepore kai tinoni bi iani gagani. ");
INSERT INTO lga_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ko totonai sa roqu kamua isa sa na roroqu tavagigala, poni pira sau, <Kei, ira doru nabulu tana tamaqu kisa ba sa pugele nyonyoa na gadi gagani goto na sa qa mate talea ko qa suvere vaivasevi burana lani ara! ");
INSERT INTO lga_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jongana, ma sisiqarai gu mule lao tana tamaqu ara, ko pira mana vavaja vei: Tamaqu, qa sela sara pa moena na Tamasa pa noka beto pa moemu ao. ");
INSERT INTO lga_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Kopira nake padaqu ko muna kukunisiu na tumu sara, goto mu veinisiu gu ira na mua tinoni roiti managu,> sau. ");
INSERT INTO lga_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ko sa gasa turu ko sa taloa mule lao tana tamana sisa. Ba totonai sa oqoro tata kamua na ruma isa sa sa dogoro vaia na tamana, ko sa roroqu vivitigia sisa, ko sa abutu lao borua beto sa aoa sa na tuna. ");
INSERT INTO lga_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Poni sa pira sau sa na tuna, <Tamaqu, qa sela sara pa moena na Tamasa pa noka beto pa moemu ao. Kopira nake padaqu ko muna kukunisiu na tumu sara,> sau. ");
INSERT INTO lga_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ba sa kuku tekuria na tamana sira na ona nabulu, <Mu sisiqarai! Tekua na poko babata jongana ko mu vasaenia, beto mu vasolapania na ringi na kakarusuna, beto mu vasaenia tugu na sadolo na nenena, ");
INSERT INTO lga_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","beto sa mu lao kubolia na tuni bulumakau nyonyobokona, ko ta vavolo qeqerania! ");
INSERT INTO lga_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ura na tuqu api sa sa tei mate tu, ba kopira sa toa mule; sa tei muma tu sisa, ba kopira sa tabata ligu!> sau. Ko qai podalai roitinia ira sa na vavolo qeqera. ");
INSERT INTO lga_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ego totonai sa korapa tu pa inuma sa na tuna marene pa moa. Ko totonai sa mule ko sa tata kamu pa ruma, sa sa nongoria sa na mimike beto na pepeka. ");
INSERT INTO lga_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Poni sa kuku tekua isa sa kai nabulu ko sa nanasia, <Na sa sa podo lani, qokolo!> saunia. ");
INSERT INTO lga_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Poni pira sau sa na nabulu, <Na tasimu sa sa koni mule kamu ko na tamamu sa sa kubolia na tuni bulumakau nyonyobokona ko qai vavolo qeqera, ura sa mule kamu vatale sisa,> saunia. ");
INSERT INTO lga_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ba sa tagigiri sa na tuna pa moa, ko sa daiona tome pa ruma. Poni sa votu sa na tamana ko sa mamana totokai ko mi tome saunia. ");
INSERT INTO lga_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ba sa oea sa na tamana, <Doro! Na kubo jola aoro pira sa qa kole pinausu vanigo ara sao beto qake isongo maja podekia tugu ara sa kai mua garunu. Ba na sa mai qu tei vanisiu tu sara? Bi kai qoti ikete gu bu vanisiu ko ba teteku tavitiria ira na qua baere, ba kepore vavagila tugu! ");
INSERT INTO lga_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Goto na tumu inana sa sa riu vamanyao betoria tadira na tugele sira na mua sakasava, ba tonai sa mule kamu sa qu kubolo vania tu na tuni bulumakau nyonyobokona ao!> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Poni pira saunia na tamana sisa, <Tuqu, ao sa na suveremu gu taqu doru totoso, ko dorudi vei qa isongoria ara sa na mua gu ao. ");
INSERT INTO lga_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ba sa jongana tugu sa taqe roiti gagani ko taqe qeqera gita, ura na tasimu api sa sa tei mate tu, ba kopira sa toa mule; sa tei muma tu sisa, ba kopira sa tabata ligu!> sau.>> ");
INSERT INTO lga_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ego sa paranga laoria i Jisu sira na ona sepele: <<Koleona sa kai tinoni isisongo sa pore kai ona nabulu ko isa sa kopuniria doru ona sakasava. Ko ira kaki qai vavakato vania na tinoni isisongo api sa na veveina sa aru vivikereria na nabulu sa kopuniria sa na ona poata. ");
INSERT INTO lga_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Poni sa kuku vatomea na tinoni isisongo sa nona nabulu api, ko pira saunia, <Na sa sisa qa nongoronia ara na veveimu ao api? Mu valamea na vavakatona na mua kopu vareregena na qua isisongo, ura kopira munake kopu vareregia na qua isisongo ara sao!> saunia. ");
INSERT INTO lga_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Poni sa kole roroqu mekana sa na nabulu kopu, <Kode mina vabetosiu na qua bangara pa qua roiti sara. Ko na sa beka sa mana roitinia ara tonai? Qake boka roiti pa inuma sara, beto na tetepa tadira na tinoni ba qa keania tugu. ");
INSERT INTO lga_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ego, jongana, pira gu sa mana roiti vei ara, ko totonai mana tavabeto pa qua roiti kopu sara ba mai koledia sira na kubo qua baere mai vatatasiu pa dia ruma,> sau. ");
INSERT INTO lga_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ko sa kuku memeka vakamuria isa sira na tinoni qai oqoro tabaria na dia lilipu tana ona bangara. Sa nanasia isa sa na tinoni momoe, <Ao ka visa sa na mua lilipu tana bangara taqu?> saunia. ");
INSERT INTO lga_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Poni pira sau sa na tinoni isa, <Kai gogoto daramu tototoni oela olive pugeledi,> sau. Poni sa paranga sa na nabulu tinoni kopu, <Ego, api sa na mua pepa lilipu. Mu sisiqarai toqo ko mu kutia ka limangavuluputa tototoni oela pugeledi mugu,> sau sisa. ");
INSERT INTO lga_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Beto sa nanasia mule sa kame, <Goto ao sa ai sa vei? Ka visa sa na mua lilipu tana bangara taqu?> saunia. Poni sa paranga sa na tinoni, <Kai gogoto baiki vuiti,> sau. Poni sa paranga sa na nabulu kopu, <Jongana, api sa na mua pepa lilipu. Mu kutia gu ka vesungavuluputa gu,> saunia. ");
INSERT INTO lga_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ko sa doro valavatia na bangara sa na nabulu sesekena api. Ura sa doro momoe laoa na totoso vuka risa sisa, ko sa vatanania na ona toa mekana. Ira na tinoni pa kasia gusu api sa qai tavagigala jolaniria ira na tinoni tana kabere pa rorove vevei inara. ");
INSERT INTO lga_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Inara sa vei ko ma pojanigou ara sagou: mu vaiianiria sira na miu isisongo pa peso ko mi pore miu baere, ko tonai mina beto pudala poni sa mai vatogagou pa gusu kole jolana. ");
INSERT INTO lga_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Isa sa tarange pa kopudi na sakasava ikikete sa mina tarange tugu pa kopudi na sakasava lalavata; goto isa sake tarange pa kopudi na sakasava ikikete sa minake tarange tugu pa kopudi na sakasava lalavata. ");
INSERT INTO lga_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Vei muneke tarange sagou pa kopudi na isisongo pa peso, sa i sei mina rangegou ko mina vakopunigou na isisongo sosoto? ");
INSERT INTO lga_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ko vei munake tarange sagou pa kopuna na isisongo tana goto tinoni, sa i sei mina rangegou ko mina vakopunigou sira na miu isisongo mekamiu? ");
INSERT INTO lga_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kepore kai nabulu mina boka mekarai nabuluniria sa karu bangara. Kode kame minake tavaraguania goto kame sa mina roroqua; kode mina valavatia kame goto kame mina vakepore veveinai. Ko munake boka mekarai nabuluniria agou sa na Tamasa beto na isisongo,>> sau si Jisu. ");
INSERT INTO lga_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ego totonai qai nongoria ira na Parese sa vei inara sa qai kole vavaledenia ira si Jisu, ura na gagale bulo poata sira. ");
INSERT INTO lga_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Poni pira sauniria i Jisu sira, <<Agou ka visa gu pira sa qu vavadoro veinigou na tinoni tuvisimiu mekamiu pa moedi na tinoni, ba na Tamasa sa gigilaiona na bulomiu. Ura ira na sakasava qai tadoro vaporeveveidi ta tinoni sa qai lulasa ikeredi jola pa dodogoro tana Tamasa. ");
INSERT INTO lga_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Na Vavanau beto na kukuti tadira na tinoni kokorotai sa qai toniria na tinoni tinganai sa kamu pa totoso tai Jone Paputaiso. Podalai pa totoso isa ko sa kamu kopira sa sa tatarae sa na nongoro jongana na veveina na binangara tana Tamasa, ko na kubo tinoni sa qai podeke vivitigia ko mai tome laoa qarigu. ");
INSERT INTO lga_vpl VALUE