﻿USE sofia;
DROP TABLE IF EXISTS sofia.lex_vpl;
CREATE TABLE lex_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lex_vpl WRITE;
INSERT INTO lex_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ler ululu noha gergera-tatiah'i ma'ta (mulaliaini) Orgahi-Orha'a Uplerlawna-Mempulwatnu Nwahi' pa Na'ohi-na'ara lyanti me, nohkerna-rai miaran di. ");
INSERT INTO lex_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Nohkeran di edon naplol ma'ta ne nahgali, melmela-kalkalma ntutuw nana-nkaduw nana hletan lawna-yoir lawna, ne Orgahi Nhiw Lululli mana Ndardarta la gergera-tatiah'i wawannu. ");
INSERT INTO lex_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Orgahi-Orha'a Nhar lirni: “Mhita-mriepra”. Noma hititni-repreparni nwo'ti wa. ");
INSERT INTO lex_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Orgahi Namkek de hititni-repreparni de samoga, noka Nnawera-nnapakia lelerni la'a melmelli. ");
INSERT INTO lex_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Noma Orgahi Nala lelerni pa nwawa lera, ne melmelli pa nwawa mela. Noka mela nla nhelma me repra nma nwo'ti wa, de lera idni hade. ");
INSERT INTO lex_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Orgahi Nhar lirni: “Tertieri-tawtawa mpuo'ti-mpuanin la gergerni-taitiah'in di letgarni, totpa muwera-mupakia gera-tah'i la gera-tah'i.” ");
INSERT INTO lex_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Noma Nhi'a tertieri-tawtaw di pa nala na Nnawera-nnapakia gera-tah'i mak kdella yawa, la'a gera-tah'i mak kdella heyanna. Noma nlola. ");
INSERT INTO lex_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Noma Nala tertieri-tawtaw de pa nwawa lyanti. Mela nla nhelma me repra nma nwo'ti wa, de lera wornu wa. ");
INSERT INTO lex_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Orgahi Nhar lirni: “Gera-tah'i mak kdella lyanti nayanni, miwok la geni id to'a totpena kerkeranni nharigota.” Noka nlola. ");
INSERT INTO lex_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Noma Nala kerkeranni de pa nwawa nohkerna ne ger mak kawoka re nwawa lora. Namkek de honona re samoga. ");
INSERT INTO lex_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Orgahi Nhar lirni: “Oruhwu-auguhwu, yawuli-yatniamin mak kodi o'olli, orwo'a-auwo'a maka wo'oni rodi o'olli mmiori-mdiaria totpa yawuli-yatniamni erla nohkerkeran di wawannu.” Noma nlola. ");
INSERT INTO lex_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tani namoria oruhwu-auguhwu, yawuli-yatniamni re honona, me ora-au maka wo'oni kodi o'olli. Orgahi Namkek de honona re samoga. ");
INSERT INTO lex_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Mela nla nhelma me repra nma nwo'ti, de lera wotellu wa. ");
INSERT INTO lex_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Orgahi Nhar lirni: “Mak kodia hititni-repreparni mua mhita-mriepar la'a lyanit maran di ralamni totpa mniawera-mniapakia lera la'a mela. La'pa miy mak kodia hititni-repreparni mhi'a kniau mak ktutga lerlalawna, me lera-mela, me me'eta-anni mak kodi liarni. ");
INSERT INTO lex_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ne emeka hititni-repreparni la lyanit marna, de mhitwah'a-mrieparwah'a nohkerna-rai miaran di wali.” Noma nlola. ");
INSERT INTO lex_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Noma Orgahi Nhi'a hititni-reprepar lawanni rora, totpa lalawanni de nodi plola-ntaryat lia lera, me kdadiahani de nodi plolli la mela, ne Nhi' wali wtiona re wali. ");
INSERT INTO lex_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Nken tiarga harella lyanit maran di totpa rhit wah'a-repar wah'a nohkerna-rai miaran di. ");
INSERT INTO lex_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ne totpa nodi plola-ntaryat lia lera me mela, ne totpa nnawera-nnapakia lelerni la melmelli. Namkek de honona re samoga. ");
INSERT INTO lex_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Lera nla nhelma me repra nma nwo'ti, de lera wogatni wa. ");
INSERT INTO lex_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Orgahi Nhar lirni: “La' gera-tah'i ralamni de, mormiorni-dardiarni mpiolwo'la-mlieklekru, ne onu-ma'nu mana mniemnema-mtiatiaiya la noha wawannu, pa mliereti-mlier lahwa darat letgara.” ");
INSERT INTO lex_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Noma Orgahi Na'ohi-na'ara i'na-ya'an lalawna mak kden la lora, ne mormiorni-dardiarni dom mak kwo'la-klekur la gera-tah'i ralamni, me onu-ma'nu. Namkeka de honona re samoga. ");
INSERT INTO lex_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Noka Nara'a-napalga i'n lora-ya'an lora, me mormiorni-dardiarni dom mak kdella gera-tah'i ralamni Niwra: “Mpieha-mliawna, mi'itra-mitapal pa mimniota tah'i lawna.” Ne Nara'a-napalga onu-ma'nu mana Niwra: “Mpieha-mliawna.” ");
INSERT INTO lex_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Lera nla nhelma me yawra nma nwo'ti, de lera wolimni wa. ");
INSERT INTO lex_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Orgahi Nhar lirni: “Ha mormiori-dardiari honona, nhiuri-wnia'ana, mak kawrika-kawriai, kawlola-kawniai'ti, ne mak kpora-kdawra honona miopilgota lia nohkerna-rai miaran di.” Noma nlola. ");
INSERT INTO lex_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Orgahi Na'ohi-na'ara mak kpora-kdawra honona, nhiuri-wnia'ana honona, me mak kawrika-kawriai honona la nohkerkeran di wawannu. Noma Namkeka de honona re samoga. ");
INSERT INTO lex_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Orgahi Nhar lirni: “Mai pia Tsi' wali rimormiori totpa emolmoll Ita, totpa rodi plola-rtaryat lia' ha mormiori honona, mak kdella nohkerkeran di uhunu-ewatni-ewatni-lahwani.” ");
INSERT INTO lex_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Noma Nhi'a rimormior die totpa emolmolan nek E'a, pa Nakoki-nayapia, de muanke'a nora patke'a. ");
INSERT INTO lex_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Orgahi Nara'a-napalga re Niwra: “Mpieha-mliawna totpa mi'upa-mi'a'na pa mhi' penga nohmaran di, ne miodi plola-mtiaryat lia hamormiori honona mak kdella nohkerkeran di uhunu-ewatni-ewatni-lahwani.” ");
INSERT INTO lex_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Orgahi Nhar lirni: “Mhioratreria, agala yawuli-yatniamni mak kodi o'olli honona me, orwo'a-auwo'a maka kodi o'olli honona la' nohkerkeran di uhunu-ewatni-ewatni-lahwani, hare er maka mhi'a la yamananmi. ");
INSERT INTO lex_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mere la'a ha mormiori-dardiari honona re, mak kdena nohkerkeran di, de nhiuri-wnia'ana me, mak kpora-kdawra me, onu-ma'nu me, mak kawrika-kawriai Agala wewna me ortawi-autiawi motmota la yamananni.” Noma nlola. ");
INSERT INTO lex_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Noma Namkeka maka Nakoki-nayap niana honona re samomuou memna. Lera nla nhelma me repra nma nwo'ti, de lera wonemni wa. ");
INSERT INTO lex_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Emkadella lyanti nora nohkerkeran di yakokni-yayapni ntut lia honi-nte'ela walli, na'itar wutu mniotni re honona. ");
INSERT INTO lex_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","La'pa lera wo'itnu Orgahi Nahoru kniarni maka Ha Nhi' nan oleka re, dewade Nwatia kniarni la ler di, ");
INSERT INTO lex_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Noka Nalernu ra'ani-pallu la lera wo'itnu di Naluli-nahona (sucikan), yoma la' ler de de Nayoli momuou kniarni maka Ha Nhi' nan oleka re. ");
INSERT INTO lex_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Emkadella la'a lyanit marna nora nohkerkeran di yakokni-yayapni. La' ler maka Orgahi-Orha'a Uplerlawna-Mempulwatnu Nhi'a lyanti nora nohkerna-rai miaran di, ");
INSERT INTO lex_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ruwnu-ahla hamonan ma'ta la noh di wawannu, yawuli-yatniamni id mana edonna rwo'ti-rwanin ma'ta la wo'or mou wawannu, yoma Orgahi edon Nalerun ma'ta otna la noha wawannu, ne riy maka kawuli-katniamni mana edonan ma'ta, ");
INSERT INTO lex_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","mere noha nodwa-rai nha'ara noka nape'er noh di wawannu tetema. ");
INSERT INTO lex_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Noma Orgahi Nakoki-nayapi rimormiori de Nnairia wuw tanwioka-lai tanmiera, ne Neug aranni mak kala mormiorni la irannu hu'ulli pa nwal lia rimormiori. ");
INSERT INTO lex_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nhi'noka Orgahi Nhi'a nhyi'a la Eden lowanni, la' walli tipru. La' gen die de Nken tiarga rimormior maka Ha Nhi' nan della hande. ");
INSERT INTO lex_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Noka Orgahi Namoria orwo'a-auwo'a la nhyi' di ralamni, maka tamkeka de samoga pa ta'an wo'oni de mikmikarni, ne au mak kodi riy la mormiori-dardiari na'itra au mak kodia rira pa rat niohora kalwiedni-paitiotni me yatni-halli rdella nhyi' di letgarni. ");
INSERT INTO lex_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ne gerlawna ida nwau pua nwatiawu Eden lowanni totpena nape'era nhyi' de, ne ntaw Eden de, gerlawan de nahniakar la nhiakra wogata. ");
INSERT INTO lex_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Idni de nwawa Pison, de de mak kwau pua kwakdiori Hawila yapatni tetema de maha genni. ");
INSERT INTO lex_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ne mah maka ktaw lowanni de samoga. La' hande de damri etla. Damri di nwawa bedola me nahuwu mikmikri. Ne watu krisopras mana etla hande. ");
INSERT INTO lex_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Nhiakarni wornu nwawa Gihon, maka kwau pua kwakdioria Kusyi yapatni tetema. ");
INSERT INTO lex_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Nhiakarni wotellu de nwawa Tigris, mak kwau lia Asyur lowanni walli tipru. Ne nhiakarni wogatni de Efrat. ");
INSERT INTO lex_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Orgahi Nodia rimormior die pa Nken tiarga la nhyi'a la Eden lowanni totpa nwahi'a-nwayodi, ne namkek la nhyi' de. ");
INSERT INTO lex_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Noka Nala lir dilla rimormior die: “Auwo' mak kdella nhyi' di ralamni honona de mu'un wewewar nek la, ");
INSERT INTO lex_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mere au mak kodi riy pa rat niohora kalwiedni-paitiotni me yatni-halli de yana mu'un wo'oni, yoma ler maka mu'un la wo'oni, de hota mmuati tioto'a.” ");
INSERT INTO lex_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Orgahi Nal lirni: “Hota rimormior di inon wamueheni de, hota yata. Aghi'a talanwalli id la pa nla' wuiwialli-tnialwialli.” ");
INSERT INTO lex_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Orgahi Nayap niana oleka ha mormiori re honona rwatiawu topi-tani. Noka Nodia honona rpa Nala la rimormior die totpa Orgahi Namkeka rimormior die nala hamormior die kotni-nanni, ne emeka nan maka rimormior die nala la hamormiori re, hota emekwali nanni re. ");
INSERT INTO lex_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Rimormior die nala nana la nhiuri-wnia'ana re honona, la'a onu-ma'nu honona, ne mak kpora-kdawra honona, mere e inon wamueheni meman nek de, edonna nlernana talanwalli wuiwialli-tnialwialli. ");
INSERT INTO lex_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Noka Orgahi Nhi'a rimormior die pa nanin hala, la'pa nanin reria, Orgahi Naul doinia ruh'anu ida, noka Nala ihi na Nahew tiarga genni de. ");
INSERT INTO lex_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ne ntawua rur miaka Na'ala la' rimormior die, noma Na'ohi-na'ara patke'a ida, noka Nod tiemna la rimormior die. ");
INSERT INTO lex_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Noka rimormior die niwra: “Inee! Hadi de ruri mak ktawu a ru'ru, ne ih miak ktawu ih'u. Hota rweta de patke'a, yoma Orgahi Na' nana la muanke'a.” ");
INSERT INTO lex_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hade pede muanke'a ida hota naltarga amni nor inni pa nora hawni rla' wutg ida, totpa rrora rla' wutu ihi ida. ");
INSERT INTO lex_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Rimormior die nora hawni rewre'wa pa ratliawihi, mere edonna rmola-rma'a. ");
INSERT INTO lex_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mere niy mak kodi pudi-akla la pora-dawra honona re, maka Orgahi Nakoki-nayapi, Nohi-na'ar nana. Lera ida ne, niy nmai pia natiana patke' de niwra: “Plolli de Orgahi Nal lirni de: “Orwo'a-auwo'a mak kdella nhyi' di ralamni honona de yana mi'in wo'oni, me?”” ");
INSERT INTO lex_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Noka patke' de nwahla niy die: “Edonna. Orwo'a-auwo' mak kdella nhyi' di ralamni de ama'ana, ");
INSERT INTO lex_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","mere la'a au mak kdella nhyi' di letgarni de Orgahi lirni de yana ma'ana me mte'la la wo'oni mana yana, de de hota ammati.” ");
INSERT INTO lex_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Mere niy die nakot la patke' de: “Hota miy edonna mmiat miano, ");
INSERT INTO lex_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","mere Orgahi Nat niohora, lerni pa miy mi'in nana, de matmi hota naphyar pa miora Orgahi mimneha, miat niohora kalwiedni-paitiotni me yatni-halli.” ");
INSERT INTO lex_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Patke' de, namkek de auwo' de mikri-liamanni, me yamkekni samomuou ne nhi' nohor walia riy ralamni nala auwo' de onnila auwo' de nala kirkira ralma-rior samomuou (pengertian). Hade pede patke' de na'ala wo'oni pa na'ana, ne nal wal lia hawni maka nor rewre'wa talla, noma muanke'eni na'an walia. ");
INSERT INTO lex_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Noma rrora matni rrepar nana pa ratga de ratliawihi, noka rla retia kar tawi pa rhi'a la wara. ");
INSERT INTO lex_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","La'pa ratlin nana Orgahi lakni yetanni mak kalala'a la nhyi' de ralamni la' lera nhierni, noma rimormior die nor hawni rade'a la'a or-au mak kdella nhyi' de ralamni hewnu. ");
INSERT INTO lex_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mere Nhar lirni pa Npolga muanke' de Niwra: “Adam ee! O' etla meni?” ");
INSERT INTO lex_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Nwahla: “La'pa a'utlin nana O' etla nhyi' di ralamni, de a'umta'ata, yoma a'utliawihi, reiniande, a'ude' a'u.” ");
INSERT INTO lex_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Lirni: “He' ed mak kakot o' de, o' e mutliawihi? Yanhi'pa o' e mu'un la auwo' mak A'ukota yan memmemna mu'un dena?” ");
INSERT INTO lex_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Muanke' de nwahla: “Patke' maka Mkienia la a o'nu di, ed mak kala au die wo'oni mai a'u, pa nhi'nande a'u'una.” ");
INSERT INTO lex_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nhor nioka Nhar lirni la patke' de: “Hya' ed maka mhi'a dina?” Patke' de nwahla: “Niy die ed mak kodia kdiori-kdieha pa a'una.” ");
INSERT INTO lex_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Noka Nhar lirni la niy die: “Onnila omhi' nan emkade, la'a ha mormiori honona re o' ed mak klernana hoptutu-hoplera. Hota muwrika-muwriai, ne mu'una koda-awu la'a mormiormu-dardiarmu. ");
INSERT INTO lex_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Aghi'a yawunu-yawenan la omuora patke' di, me la'a o duratmu-waitmu nora patke' di duratni-waitni. Duratni-waitni hota nhapar reri o'tamu la' noh marna, ne omuihi-mhuo'wa tikalli.” ");
INSERT INTO lex_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Lirni la patke' de: “Hota Aghi'u pa mumehra-mumau niohora ya'uhumu-ya'apanmu pa polpuol inmu-wakwak ammu, kennama hota o ralammu nala hapmu, ne nodi plolli tiy o' wawanmu.” ");
INSERT INTO lex_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Noka lirni la muanke' de: “Onnila omutlin nohora hapmu lirni, ne mu'un la auwo' mak Aghopna: “Yana mu'una,” nhi'nande nohkerkeran di nhoptutu-nhopler la o hihi'imu, muodia prehena-maumu pa mpuahak lola ya'anmu-yemanmu la nohmaran di la'a mormiormu-dardiarmu. ");
INSERT INTO lex_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Pu'na-kiarti, du'uta-penta ed mak kmori-kdari, ne yawuli-yatniamin mak kdena wo'orletna-kawurloini rla'a yaya'anmu, ");
INSERT INTO lex_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","muodia liwatmu-odapmu mualla muhaka yaya'anmu, nodia pa la'pa muti'ila-muwal lia eni-tani, yoma ra'na'nu la' hade, yoma o' de de eni-tani pa muwal lia eni-tani.” ");
INSERT INTO lex_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Muanke' de nanni Adama, ne nala hawni pa nwawa Hawa'a (nnia'eratni de mormiori-dardiari) yoma hade ed mak khi'a in la riy mak kmormiori-kdardiari honona. ");
INSERT INTO lex_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ne Orgahi Nala ha ulti pa Nhi'a hewewta-naniairi la rimormior die nor hawni, noka Nohoga la temni re. ");
INSERT INTO lex_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Noka Nal lirni: “Plollolli de rimormior die nwali olek emekwali Ita pa nat niohora kalwiedni-paitiotni, yatni-halli, noma yanhi'pa ntan limni pa na'ala auwo' mak kodi riy la mormiori-dardiari pa na'ana, reiniande nmori aplahwa pa nodi liarni.” ");
INSERT INTO lex_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hade pede Nhopan pa rlergot la nhyi' ralma la Eden lowanni pa, nanhyi'a-natlunnia tani. Tani ed maka Nnairi pa Nakok niana-nayap niana ir la, ne tani ed maka rimormiori ranhyi'a-ratlunnia. ");
INSERT INTO lex_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Nhokar doinia rimormior re, nhor nioka Nwau tiarga hgera la nhyi' ralma walli tipru, de Uplerlawna hopopanni-lili'irnu mak katiaka gen lululi me wehla gai mormiori maka ktipna-khewra, totpa yana rawal lia auwo'a mak kodia riy la mormiori-dardiar die mak kdella nhyi' Eden letgarni. ");
INSERT INTO lex_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nhi'noka Adam nor Hawa'a ranina, noka patke' de na'apun wa, noma nmor niana muanke'a ida rala pa nwawa Kain (nnia'eratni de, lernana a'na), noma patke' de niwra: “Orgahi Nara'a-napalga pa aliernana oleka muanke'a ida.” ");
INSERT INTO lex_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Nhor nioka na'a'na muanke'a id owa'ana rala pa nwawa Habel. Ne Habel nmori lawna noma nodi pipi-duma, Kain nmori lawna noma nhi'a mak kanhyi'a-katlunni. ");
INSERT INTO lex_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Name'et doini-na'anin doinia la, noka Kain nala limtutnu, de nala tan die wullu-we'elli oke' pa rala la Orgahi. ");
INSERT INTO lex_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habel mana nala pipni-dumni re a'nani yanulu mak kapetna me kmou-kwitna nanpa nhi'a la limtutnu la Orgahi. Noma Orgahi Nreiniana-na'nana Habel nora limtutnu. ");
INSERT INTO lex_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mere Kain nora limtutnu de Orgahi edonna Nreiniana-na'nana. Hade pede Kain ralamni namehra doin la, nhi'nande gaini mana nmaluidioin la. ");
INSERT INTO lex_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Orgahi Nal lirni la Kain: “Nihya'pa ralammu namehra doin la me gaimu nmaluidioin la? ");
INSERT INTO lex_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Hota mhi' nana kalwiedni mana gaimu ematia' emkade, toh?! Mu'ererma, la'pa mhi' nana yatni-halli de, do'a-hala nwuw rieri olek la nhiari gaini. Do'a-hala niwra nodi plolli la o'a, mere mutekal pa muodi plolli la do'a-hala.” ");
INSERT INTO lex_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Noma Kain nakot la garni Habel niwra: “Mai pia tla'awa wo'ora-kawur letanni.” Rla'awa pa la'pa rte'ela wo'ora letanni, dewade Kain nkakul wenna Habel. ");
INSERT INTO lex_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Nhor nioka Orgahi Nal lir la Kain pa Natiana: “Kain ee! Garmu Habel etla meni?” Mere Kain nwahla niwra: “A'uplinga. A' di de mak katiak ga'ru id a'u?!” ");
INSERT INTO lex_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Lirni: “Idee! Hya' maka ha mhi' nan olek dina? Garmu rarni de ndella tani wawannu pa nhaun mai A'u. ");
INSERT INTO lex_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Noma dodo'ondi nek pa nodi liarni mormiormu-dardiarmu nwal lia udi mak khoptutu me nora mak khoplera pa rhawloiyu-rhawlakru la'a geni-tien di, mak kwer wawni pa nlumu niana-ntelan nana o garmu rarni la'a o hihi'imu-yapyapmu. ");
INSERT INTO lex_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Omunhyi'a-mutlunin tan di mana, edon nala wullu-we'elli la tiy o'a. Mpual lia mak kawlari me mak kmor diada'du la nohkerkeran di wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain nakot la Orgahi: “Idee! A wutwu'tu-kokgoh'u de werta, pa takeni ukwar nana. ");
INSERT INTO lex_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Dodo'ondi Mhuokar doini a lia tan di, ne hota a'u yade'a la gaimu ralamni, riy mak kawlari me mak kmor diada'du la nohkerkeran di wawannu, yanhi'pa he' maka kwatrom nan a' die, hota rwen a'u.” ");
INSERT INTO lex_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Orgahi lirni: “Edonna. He' maka kwenna o' de wniahlani ralamni re'eni wo'itu.” Nhor nioka Orgahi Nkenia kniau la Kain, totpa he'-he' mak kwatrom nana de yana rwenna. ");
INSERT INTO lex_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Noka Kain nwadur la Orgahi gaini, noka nhol lia Noda lowanni la Eden lowanni walli tipru. ");
INSERT INTO lex_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain nor hawni ranina pa, nhi'noka patke' de na'apun wa, noma na'a'na nana muanke'a id pa rala nanni pa nwawa Henok. Ne Kain nhoi ruhuna-nwatat leta ida, pa nwawa Henok, nlernohora a'nani nanni. ");
INSERT INTO lex_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok na'a'na Irad, Irad na'a'na Mehuyael, Mehuyael na'a'na Metusel, Metusel na'a'na Lamek. ");
INSERT INTO lex_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek nmehlima patke'a woru, ida nwawa Ada, me handina de Sila. ");
INSERT INTO lex_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada na'a'na muanke'a id pa rala pa nwawa Yabal, hade ed mak khi' amni la'a mak khol lia lowna-krahana mak rhi'a la ha ulti, me mak khuri-kwa'ana nhiuri-wnia'ana. ");
INSERT INTO lex_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Garni nanni Yubal, hade ed maka khi' am la mak kahe'i gitara (kecapi) me mak keu floiti. ");
INSERT INTO lex_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Sila mana na'a'na wali, pa na'a'na nana muanke'a id pa ral nanni pa nwawa Tubal-Kain, hade ed mak khi' am la mak kwewla mnotna me pi'ra. Tubal-Kain garni patke'a de Naama. ");
INSERT INTO lex_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamek tulu-petna pede lera ida nakot la hawni rora: “Ada muora Sila mitlin la a li'ru di. A ha'wu mimrio'a, mtia'wa tlinmi pa mitlin a li'ru di. Awuen oleka muanke' ida, mere nwano' to' a'u, awuenna tuwgari ida, yoma nkaklu a'u. ");
INSERT INTO lex_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Yoma Orgahi Nakota Niwra Nwahla nan riy mak kwunu-kwenna Kain ralamni re'eni wo'it die, mere a' di de wuahla riy mak khi' yatyatni mai a'u re'eni terampwo'it wehrani wo'itu ralamni.” ");
INSERT INTO lex_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam nor hawni ranina, noka patke' de na'a'na nan owa'ana muanke'a ida, nal nanni pa nwawa Seta (nnia'eratni de, ra'a-palu) yoma niwra: “Orgahi Nara'a-napalga keke'enku' id to'a mai a'u, pa nwal lia Habel wniaunu, yoma Kain nwenan nana.” ");
INSERT INTO lex_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seta na'a'na nana muanke'a ida pa rala pa nwawa Enosa. Ler de de na'nama rimormiori ratu rwet la Uplerlawna nanni de Orgahi-Orha'a Uplerlawna-Mempulwatnu, totpa ra'uli-rawedia. ");
INSERT INTO lex_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Hadi de Adam duratni-waitni horatni-hairni. Lerni pa Orgahi-Orha'a Na'ohi-na'ara rimormior die, de Nhi'a pa nal emolmolan neka E'a. ");
INSERT INTO lex_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Na'ohi-na'ara hare de, muanke'a me patke'a. Nara'a-napalga rpa ra'upa-ra'a'na, ne Nal nanni rpa rwawa rimormiori, la'a lera Ha Na'ohi-na'ara re. ");
INSERT INTO lex_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","La'pa Adam nmor niana anni rahu ida terampwotelu dewade, na'a'na nana muanke'a id maka nal emolmolla e'a, noka nala pa nwawa Seta. ");
INSERT INTO lex_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","La'pa na'a'na nana Seta pa nhorwua noma Adam nmormior mia'ta pa anni rahu wo'awa owa'ana, de na'a'n owa'ana muanke'a me patke'a. ");
INSERT INTO lex_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Pede Adam nte'ela mormiorni anni rahu wosiewa terampwotelu dewade, nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","La'pa Seta nmor niana anni rahu ida wehrani wolim wa dewade, na'a'na Enos. ");
INSERT INTO lex_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ne Seta nmormior niekpa nahor dioinia anni rahu wo'awa wehrani wo'itu. Na'a'na Enos pa nhorwua dewade, na'a'n owa'ana muanke'a me patke'a. ");
INSERT INTO lex_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Pede Seta nte'ela mormiorni anni rahu wosiewa termida wehrani woru, noka nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","La'pa Enos nmor niana anni terampwosiew pa dewade, na'a'na Kenan. ");
INSERT INTO lex_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ne Enos nmormior mia'ta pa nte' nana anni rahu wo'awa termida wehrani wolima, la'pa na'a'na nan Kenan wa dewade, na'a'n owa'ana muanke'a me patke'a. ");
INSERT INTO lex_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Pede Enos nte' nana mormiorni anni rahu wosiewa wehrani wolim wa dewade, nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","La'pa Kenan nmormior pia nte'ela anni terampwo'it wua dewade, na'a'na nana Mahalaleel. ");
INSERT INTO lex_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ne Kenan nmormior niekpa nte'ela anni rahu wo'awa terampwogata, la'pa na'a'na nana Mahalaleel dewade, na'a'n owa'ana muanke'a me patke'a. ");
INSERT INTO lex_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Pede Kenan nte'ela mormiorni anni rahu wosiewa termid wa dewade, nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","La'pa Mahalaleel nmor niana anni terampwonema wehrani wolim wa dewade, na'a'na nana Yared. ");
INSERT INTO lex_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ne Mahalaleel nmormior niekpa nte'ela anni rahu wo'awa terampwotelu, la'pa na'a'n nan Yared pa nhorwua dewade, na'a'n owa'ana muanke'a me patke'a. ");
INSERT INTO lex_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Pede Mahalaleel nte'ela anni rahu wo'awa terampwosiewa wehrani wolim wa dewade, nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","La'pa Yared nmormior niana anni rahu ida terampwonema wehrani woru, dewade na'a'na Henok. ");
INSERT INTO lex_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ne Yared nmormior niekpa nte'ela anni rahu wo'awa, la'pa na'a'na nan Henok wa dewade, na'a'n owa'ana muanke'a me patke'a. ");
INSERT INTO lex_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Pede Yared nmormior pia nte' nana anni rahu wosiewa terampwonema wehrani woru dewade, nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","La'pa Henok mormiorni anni terampwonema wehrani wolim wa dewade, na'a'na Metusala. ");
INSERT INTO lex_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ne Henok nala' nohora Uplerlawna la'a mormiorni-dardiarni ralamni pa nte' nana anni rahu wotelg owa'ana, la'pa na'a'na nana Metusala pa nhor diewade na'a'n owa'ana muanke'a me patke'a. ");
INSERT INTO lex_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Pede Henok mormiorni nte' nana anni rahu wotelu terampwonema wehrani wolima. ");
INSERT INTO lex_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ne Henok mormiorni de, nala' nohora Uplerlawna, noma edonna nden olek la wa, yoma Uplerlawna Nran doini oleka la nohkeran di wawannu. ");
INSERT INTO lex_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","La'pa Metusala nmor niana anni rahu ida terampwo'awa wehrani wo'it wua dewade, na'a'na Lamek. ");
INSERT INTO lex_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ne Metusala nmormior mia'ta pa nte' nana anni rahu wo'itu, terampwo'awa wehrani woru, la'pa na'a'na Lamek pa nhorwua dewade, na'a'n owa'ana muanke'a me patke'a. ");
INSERT INTO lex_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Pede Metusala mormiorni la nte' nana anni rahu wosiewa terampwonema wehrani wosiew wa dewade, nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","La'pa Lamek nmor niana anni rahu ida terampwo'awa wehrani woru, dewade, na'a'n owa'ana muanke'a ida. ");
INSERT INTO lex_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Noma nal nanni pa nwawa Nuh, yoma niwra: “Keke'en di hota nala ralam yahepru mai ita la' ita tulanni-kniarni, maka penpuenu-nanah nohora mehrani-maunu la tan miaka Orgahi Nhi'a pa nhoptutu-nhopler de.” ");
INSERT INTO lex_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ne Lamek nmormior mia'ta pa nte' nana anni rahu wolima terampwosiewa wehrani wolima, la'pa na'a'na nan Nuh dewade, na'a'n owa'ana muanke'a me patke'a. ");
INSERT INTO lex_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Pede Lamek mormiorni nte' nana anni rahu wo'itu terampwo'itu wehrani wo'itu wa dewade, nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","La'pa Nuh nmor niana anni rahu wolim wa de, na'a'na Sema, Yafeta me Ham. ");
INSERT INTO lex_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","La'pa rimormiori re rpeha-rlawan pa mutnu lawna la'a nohkerkeran di wawannu, ne ra'a'na nana a'na patke'a, ");
INSERT INTO lex_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","noma Uplerlawna upni-a'nani ramkeka de rimormiori upni-a'nani re samou-samoga re, dewade ra'ala hawni la'a patke'a re, he' maka ralamni rala. ");
INSERT INTO lex_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Orgahi Nhar lirni: “Nhi'wu hota edonna nden nek la rimormiori ralamni pa nodi liarni, yoma rimormiori de ihi-rara to' hade, ne mormiorni hota nla' nan to'a anni rahu ida terampworu rmeh'a.” ");
INSERT INTO lex_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ler de pa Uplerlawna upni-a'nani rora rimormiori a'na patke'a rmehlima. Ne patke'a re ra'upa-ra'a'na rimormiori mota (raksasa). Ler de de, ne la'pa ler li'ir rimormiori mota ri rdella noha wawannu. Hari de riy wedlu-wedlu, riy maka ra'ululi-rawedwedia la lerni de. ");
INSERT INTO lex_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","La'pa Orgahi Namkeka de, rimormiori yatni-halli lawan rehia la nohkeran di wawannu, ne ralma-riorni re honona rawo' mamainia yatni-halli, ");
INSERT INTO lex_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","dewade, Orgahi Na'ahankeran doin la, nihya'pa Nakoki-nayap niana oleka rimormior mak kdella nohkeran di wawannu, pa rodia ralam mehra-ralam mau lia. ");
INSERT INTO lex_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Orgahi Nal lirni: “Akuh dioini-gho'or doin momuou mormiorni maka Agohi-ga'ar nan oleka la nohkeran di wawannu, la'pa rimormiori, me nhiuri-wnia'ana, hapora-dawra, mak kawrika-kawriai, onu-ma'nu, onnila A ralam meh'ru, nihya'pa Agohi-ga'ar nana oleka re.” ");
INSERT INTO lex_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mere Orgahi Napal niana Nuha. ");
INSERT INTO lex_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuh tuini-wedni hadi. Nuh di de rimormiori ploloi-plele'era, nakleha do'a-hala la'a rimormior wialli la' ler de. Ne Nuh di de natu natlina-natailla Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuh na'a'n nana muanke'a riy wotelu, Sem, Yafeta, me Ham. ");
INSERT INTO lex_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Mak kdella nohkerkeran di de, rhi'a yatni-halli olek la Uplerlawna gaini, de rhi'a maka maklekla-makdiaini mak kpenpuenu-knanahala nohkerna wawannu. ");
INSERT INTO lex_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Uplerlawna Namkek eti-lahwa nohkerkeran di, de plola pa yatni-halli lawan rehia, yoma rimormiori honona rhi'a yatni-halli la noh di wawannu. ");
INSERT INTO lex_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Uplerlawna Nhar lirni la Nuh: “Aget tiarg oleka de Awuenna rimormiori honona, yoma nohmaran di npenpuenu-nanah olek la maklekla-makdiaini re, pede hota Awueyata-wuaniawua honona re, ra'itar wutu nohkeran di. ");
INSERT INTO lex_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Mere muyap niana aupual liawna id totpa hota miodia, mniairi au gofira. Konkon die mhi'a de nodia tertierni-tawtawni, ne miala pakla ma mhioda la tio'orni me ralamni. ");
INSERT INTO lex_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Emkadilla konkonmu de yakokni-yayapni: plahwani re'a terampwo'awa wehrani wosiewa, weranni re'a termida wehrani wolima, ne tullu re'a wosiewa. ");
INSERT INTO lex_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Mhi'a aupual liawna de romni pa murita, ne muhorga aupual liawan de, de la'pa akti woru rehenu la walli heyanna, ne mkenia nhiarni la heini, mhi'a aupual liawan de pa nodi darni heyanna, letgara me yawa. ");
INSERT INTO lex_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Yoma plollolli de, hota Atiowru gera me opli nhia'a la noh di, totpa nweyata-nwaniawua mormiorni-dardiarni honona, hya'a-hya' to' pa mak kdella noh di wawannu, de hota rmat momuou. ");
INSERT INTO lex_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mere A gor o' de Aghi'a nnio'u ne hota omlia'awa aupual liawan de ralamni, omuora hapmu, a'namu, me yananmu. ");
INSERT INTO lex_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ne la'a mak kmormiori-kdardiari re honona, la'a hari honona de muodia tnialli id pa mlia'awa aupual liawna ralamni, totpa rmor niohor rewre'w o'a, muod miemna! ");
INSERT INTO lex_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","La'a onu-ma'nu re honona, nhiuri-wnia'ana re honona, hapora-dawra honona, la'a mak kawrika-kawriai, la'a hari honona de hota tnialli nenenna rmai tiemn o'a, totpa rmormiori. ");
INSERT INTO lex_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Muwoka-mule'ega ya'ana-yemnu maka rimormiori ra'ana-remnu nor wutga maka nhiuri-wnia'ana ra'ana-remnu. ");
INSERT INTO lex_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noka Nuh nhi'a hare honona, emeka Uplerlawna lirni la, noma nhi' momuoga. ");
INSERT INTO lex_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Noka Orgahi Nhar lirni la Nuh: “Mlier la aupual liawan de ralamni, omuora rommu mniotni honona, yoma Alina-muat o' nanpena muplola-mumneha la'a tuw di. ");
INSERT INTO lex_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","La'a hamormiori maka ha ra'ana me maka ra rhoi-rtania (dipersembahkan) de, mua'ala tnialli wo'itu, mere la' maka edonna rnairia de, mua'ala tnialli ida. ");
INSERT INTO lex_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nor wali onu-ma'nu tnialli wo'itu, totpa ramoria duratni-waitni la'a nohkeran di wawannu. ");
INSERT INTO lex_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Yoma tre' lera wo'it owa'an de, Atiowru gera me opli nhia'a la noh di wawannu pa lera-mela terampwogata, ne hota Akuhi-gho'or doin momuou mormiorni-dardiarni maka ghi' nan oleka la nohkeran di wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noka Nuh nhi'a hya' maka Orgahi Nakot targa la. ");
INSERT INTO lex_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nuh mormiorni anni rahu wonema, ler di maka gera ktiowru-opli nhia'a npen niana noha wawannu. ");
INSERT INTO lex_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuh nhi'a emeka Orgahi Nakot la, de nora hawni-a'nani me yananni pa rla'awa aupual liawna ralamni, yoma gera ktiowru-opli nhia'a npenpuen liola. ");
INSERT INTO lex_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","La'a hamormiori maka ha ra'ana me maka ra rhoi-rtania me maka edonna, la hamormiori honona ");
INSERT INTO lex_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","tnialli nenenna rma rwatroma Nuh pa rler la aupual liawna ralamni, emeka Orgahi Nakot targa la Nuh. ");
INSERT INTO lex_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","La'pa lardoini lera wo'it lia dewade, gera ktiowru-opli nhia'a npenpuen liola noha wawannu tetema. ");
INSERT INTO lex_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","La'pa Nuh mormiorni anni rahu wonema, la'a wolla wornu, la'a ler mak kod lia termida wehrani wo'itu, ler de de gera ktiowru-opli nhia'a. ");
INSERT INTO lex_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ne otan lawna mana ema rhuriernia nkaduw nana noha, lera-mela terampwogata. ");
INSERT INTO lex_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","La' ler de meman pa Nuh nora hawni-a'nani me yananni rewre'wa pa na'nama rla'awa aupual liawan de ralamni, ");
INSERT INTO lex_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","me hapora-dawra honona, me nhiuri-wnia'ana re honona, me mak kawrika-kawriai re honona, me onu-ma'nu re honona. ");
INSERT INTO lex_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","La'a hamormiori re honona de tnialli nenenna rma rwatrom Nuh pa rla'awa konkon die ralamni. ");
INSERT INTO lex_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Hamormiori ri honona rler la rialma emeka Uplerlawna Nakot targa la Nuh, noka Uplerlawna Nho'la aupual liawna nhiarni lola tio'ora. ");
INSERT INTO lex_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Lera-mela terampwogata ne gera ktiowru-opli nhia'a npenpuen liola noha, gera nha'at la heyanan pa nran nana aupual liawna, nhi'nande npal pia tullu la'a nohkerna wawannu. ");
INSERT INTO lex_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","La'pa gera ktiowru-opli nhia' de na'ititar rer lia pa nha'at pa narehi nan noha, dewade aupual liawan de lolioi-palpialia la'a gera wawannu. ");
INSERT INTO lex_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ne ger de nopli-nha' pa na'ititar to'ola wa pa npen niana noha, ne narehi dioini wo'or tutullu re honona, ");
INSERT INTO lex_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Gera ktiowru-opli nhia'a di npupniahala wo'or tutullu na'nama npenu owa'ana pa nha'at nana re'a wolima. ");
INSERT INTO lex_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Hamormiori re honona rmat miomuou wua, ra'itar wutu rimormiori honona re. ");
INSERT INTO lex_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Mormiorni-dardiarni re rmat miomuou wa, mak kden keranni honona. ");
INSERT INTO lex_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Emkadella Orgahi Nkuh dioinia-nho'or doinia Napo'oma-napaumu momuoga honona mak kdella noh di wawannu, eneknek to'a Nuh nora maka ha nodi rewre'wa re rmormior lia aupual liawna ralamni. ");
INSERT INTO lex_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ne ger de npen nian la noha wawannu lera rahu ida terampwolima. ");
INSERT INTO lex_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Noma Uplerlawna Nhorat reria-nehla reria aupual liawna mniotni, noka Orgahi Nhi'a anni pa nten lia noha wawannu, nhi'nande gera ktiowru-opli nhia' de nho'owa. ");
INSERT INTO lex_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Gera ktiowru-opli nhia' nho'owa, ne otan lawna mana npargetia la'a lyanti, ");
INSERT INTO lex_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ne gera la' noha wawannu mana nkerkeran lol wa. Emkadella la'a ger de knieranni nla' nana lera rahu ida terampwolima. ");
INSERT INTO lex_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ndella wolan mak kod lia wo'itnu ralamni, la'a lera termida wehrani wo'itnu la' wolan de, dewade aupual liawan de nnen lia'a wo'ora tutnu la'a Ararata lowanni. ");
INSERT INTO lex_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","La'pa wolan mak kod lia termidni dewade ger de nkerkeran lola. Wolan mak kod lia termidni, la'a lera yanullu la wolan de, noma wo'ora wurannu rde rhar wia. ");
INSERT INTO lex_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Lardoini lera terampwogat wa dewade, Nuh nhar dioini aupual liawna de folanni. ");
INSERT INTO lex_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Noka nolin doinia akaka id la, ne ma'nu de nnem la'a-nnem mai, nhi'pa gera nkeran meman la noha wawannu. ");
INSERT INTO lex_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nhor nioka nolli owa'ana lmo'ma maru (merpati) ida totpa namkeka, yana ger de nkern olekwa la'a noha wawannu. ");
INSERT INTO lex_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mere lmo'ma maru (merpat) die edonna nlernana tniai genni, noka nawal wia pa nwatroma owa'ana Nuh la aupual liawan de ralamni, yoma la' noha wawannu de gergera-tatiah'ia, noka Nuh ntan limni pa ntoran nan ma'nu de, pa nodia nla'awa konkon ralamni. ");
INSERT INTO lex_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nwei nan owa'an lera wo'itu, nhor nioka nolli owa'ana lmo'ma maru (merpat) diella. ");
INSERT INTO lex_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Rehgoru lera lia'ani na'nama lmo'ma maru die nawal pia nwatroma Nuh, ne nmai die ntotan nana saitun taw id maka na'nama net niana! La'a hade pede Nuh natga de gera nkern olekwa. ");
INSERT INTO lex_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nhi'noka nwei owa'an lera wo'it ralamni, noka nolin doini owa'ana lmo'ma maru diella, mere ma'nu de edon nawal wia. ");
INSERT INTO lex_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","La'pa Nuh umarnu rahu wonema wehrani ida, la' lera mulaliaini la wolla mulaliaini la' anin de, de gera nkeran lololwa la'a noha wawannu, noma Nuh nhar dioinia aupual liawan de kniaduwnu pa namkek la'a-namkek mai, plola pa noha wawannu nhi'pa nkeran wa. ");
INSERT INTO lex_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","La' wolla mak kod lia wornu, la'a lera mak kod lia terampworu wehrani wo'itnu, de noha wawannu nkern memn olekwa. ");
INSERT INTO lex_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Noka Uplerlawna Nhar lirni la Nuh niwra: ");
INSERT INTO lex_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Hononmi mliergot la konkon di ralamni, omuora hapmu-a'namu mior wutga yananmu. ");
INSERT INTO lex_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Miodgiota hapora-hadawra honona, me mhiuri-wnia'ana re honona, mak kawrika-kawriai honona me onu-ma'nu honona totpena honona re rpeha-rlawan la noh di wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Noka hare honona rlergot wa, ");
INSERT INTO lex_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","rima-rima rora mutwualli rlergot la aupual liawan de ralamni. ");
INSERT INTO lex_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noka Nuh nariria katri'ana id la Orgahi, na'ala id la hamormiori honona maka ha ra'ana re pa rhi'a la nhioi-tniani, pa rtunu-rharna la katri'ana wawannu. ");
INSERT INTO lex_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","La'pa Orgahi Na'irun nana nhioi-tniani re huwnu mikarni-liamanni dewade, Orgahi Nakot la ralamni Niwra: “Hota A'g edonna wueyat owa'ana nohkeran di onnila rimormiori tototni-rerieini. Rimormiori rwaror nana yotni-yatni la'a lera kuku'a-keke'a loloha-tawtiaw ma'ta la'pa nhamto'a-nhape'ewa mere hota A'g edonna wueyata-wuaniaw owa'ana mormiorni-dardiarni tetema, emeka ghi' nan-yap nian oleka diwa. ");
INSERT INTO lex_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","La'pa noh di ed ma'ta la, de lera yawuli-yatniamni me lera rieiki-wnio'ora, woki lerni-ha'ara lerni, lerwarnu me otna lerni, lelera me melmela edon eti nho' taru-ntaw tiaru.” ");
INSERT INTO lex_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Noka Uplerlawna Nara'a-napalga Nuh nora likatni mniotni pa Nakot la re Niwra: “Midurti-miwaiti me mpieha-mliawna pa mimniot nohkerkeran di. ");
INSERT INTO lex_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ne hota nhiuri-wnia'ana, me onu-ma'nu, maka kawrika-kawriai, hapora-dawra, me i'na-ya'an lora honona re ra'unni-ramta'ata miy. Atieman targ olek harella limmi ralamni. ");
INSERT INTO lex_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ha mormiori-dardiari hota rla'a yamananmu. Agal olek hare honona tiy miy, emekwali orwo'a-auwo'a, yawuli-yatniamin motmota. ");
INSERT INTO lex_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Toto'a de yana mi'ina ha'anna maka rarni ed ma'ta la, yoma mormiori nwatiawua rar de. ");
INSERT INTO lex_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mere la'a miy mormiormi de, he' maka ktowru miy rarmi de hota atio'ona wniahlani, ne la'a hamormiori mak klihira-knaiya miy die hota atio'ona. Hamormiori me rimormiori mak kwenna rimormiori wialli de, atio'ona nhiwni. ");
INSERT INTO lex_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","He' ed mak ktowur rimormiori rarni de, rarni mana hota rimormiori rtowria, yoma Aghi'a rimormiori rde emolmolannek A'u. ");
INSERT INTO lex_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ne miy midurti-miwaiti, mpieha-mliawna, nhi'nande ta'eni rwet nana liawanmi la nohkerkeran di wawannu. ");
INSERT INTO lex_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","17","Dodo'ondi de Aghi' wutga nnio'a-niatu pamuli-payala la miora duratmi-waitmi pa nodi liarni re, ror wutga hamormiori honona, mak kpora-kdawra, nhiuri-wnia'ana, mak kawrika-kawriai, onu-ma'nu, la'a hare honona mak klergot la aupual liawna ralamni di. Nnio' di de ndella dodo'ondi pa nodi liarni de A'g edonna tiowru gera me opli nhia'a pa nweyat noha-nwaniawu riai, ne mormiorni-dardiarni mana edon tiowru gera pa nweyata wa. Hota Awuahgera-wualai lyanit marna de Agala ohni, la'pa tamkek hade de itsorat nan A nnio'u di mak kdella pa nodi liarni. Hadi de kniau la A nnio'u, maka Aghi' tar oleka la mormiorni-dardiarni honona mak kden noha wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuh a'nani mak khargot la aupual liawan de, de Sema, Yafeta me Ham. Ham de Kana'ana amni. ");
INSERT INTO lex_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ne Nuh a'nani wotelu re, er mak kapeha-kalawna rimormiori la noh di wawannu tetema. ");
INSERT INTO lex_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noma Nuh nanhyi'a-natlunni. E' mak kanhyi' ulu lokrahi tniamni (anggur). ");
INSERT INTO lex_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Lera ida ne nemnu lokrahi turnu pa nhor nioka nma'wu pa nhi'nande natliawihi lia hoiwiali nayanni maka rnairi ha ulti. ");
INSERT INTO lex_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Noma Ham namkek nana amni molli-ma'ani, noka nla nwahauru la hyalli rora la tio'ora. ");
INSERT INTO lex_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Nhi'noka Yafeta nora Sem ra' nana kok lawna id pa rta'ara la rrora wawayanni na'nama rrora rala' pa rod tio'orni, rrora ralla rahewu amni molli-ma'ani mere rrora edon rapal niana, nhi'pa rrora edon ramkek nana amni molli-ma'ani. ");
INSERT INTO lex_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","La'pa Nuh ma'wanu ngaidioin la, ne natlina hya' maka a'nani gari nakota de, ");
INSERT INTO lex_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","dewade niwra: “Kana'ana nhoptutu-nhoplera, nhi'a ata-wa'ara kdedeheni la'a hyalli re. ");
INSERT INTO lex_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Mere lilili-maumuau Orgahi-Orha'a, Sema Uplerlawanni, mere Kana'ana nhi'a at la Sema. ");
INSERT INTO lex_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Uplerlawna pena Nala Yafeta lowanni-ahlani nawerna-naplahwa, me rden la Sema krahanni. Ne Kana'ana nhi' wali at la Yafeta” ");
INSERT INTO lex_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nuh nmormior mia'ta anni rahu wotelu terampwolima la'a gera ktiowru-opli nhia'a nhio'oni. ");
INSERT INTO lex_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Pede Nuh mormiorni nla' nana anni rahu wosiewa terampwolima, noka nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hadi de Sem, Yafeta nora Ham duratni-waitni. La'pa gera ktiowru-opli nhia'a nlardoinla, dewade rayor niana a'na muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafeta duratni-waitni de: Gomer, Magog, Madai, Yawan, Tubal, Mesek, nora Tiras. ");
INSERT INTO lex_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer duratni-waitni de: Askenas, Rifat, nora Togarma. ");
INSERT INTO lex_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yawan duratni-waitni de: Elisa, Tarsis, makden Kitim, nora makdena Dodanim. ");
INSERT INTO lex_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Nwatiawua hari pa noha-rai lalawna mak kdena eni wawannu re rpeha-rlawna. Yafeta duratni-waitni hari pa ntikil reri lia yeheni me, nhapar rer lia hlorni (rima-rima ndella nohananni-taniaratni, ra'itar nohora yawalli, nlernohora luwnu-a'nani re). ");
INSERT INTO lex_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hama duratni-waitni rde: Kusyi, Misraim, Put, nora Kana'an. ");
INSERT INTO lex_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusyi duratni-waitni de: Seba, Hawila, Sapta, Ra'ema nora Sapteka, Ra'ema a'nani rde, Syeba nora Dedan. ");
INSERT INTO lex_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusyi duratni-waitni id de nwawa Nimrota (nnia'eratni de malawna). Hadi ed maka kala' ul pua kodi plola-ktaryat lia nohkerkeran di wawannu. ");
INSERT INTO lex_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Rimormiori me Orgahi mana ramkeka de, hadi de mak khiti ahu-kler lowna na'iwra-namuanu la nohkeran di wawannu, hade pede riy rwedi ltieri riwra: “Emolmolla Nimrota, mak khiti ahu-kler lowna.” ");
INSERT INTO lex_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ululu de Nimrota lodna lie'enu me hairi liowni de, Babela, Ereka, nora Akada, honona rdella Sinear lowanni. ");
INSERT INTO lex_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Nimrota ndella lowan de pa nla'awa Asyur, noka nwatatu lieta wolima, de Niniwe, Rehobot-Ira, Kala, ");
INSERT INTO lex_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","me leta Resen, mak kdella Niniwe nora Kala rletni, ne Niniwe de letlawna inhatta. ");
INSERT INTO lex_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim na'ana nana makdella Ludim, makdella Anamim, makdella Lebahim, makdella Naftuhim, ");
INSERT INTO lex_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","makdella Patrusim, makdella Kaftorim nora makdella Kasluhim. Makdella Kasluhim de, er mak kadurit nana makdella Filistin. ");
INSERT INTO lex_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kana'an na'a'na nana Sidon, a'nani yanulu, nora Heta, ");
INSERT INTO lex_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","me makden Yebusi, makdena Amori nora makdena Girgasi, ");
INSERT INTO lex_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","makden Hewi, makden Arki, makden Sini, ");
INSERT INTO lex_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","makdena Arwadi, makdena Semari, nora makdena Hamati. Rwatiawua hari pa makdena Kana'ana rpeha-rlawna. ");
INSERT INTO lex_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Makdena Kana'ana lowanni-ahlani ndella Sidon pa nokru Gerar pa nokru Gasa, Sodom, Gomora, Adma nora Seboim nla tut lia Lasa. ");
INSERT INTO lex_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hare de Ham duratni-waitni pa ntikil reri lia yeheni me, nhapar rer lia hlorni (rima-rima ndella nohananni-taniaratni, ra'itar nohora yawalli, nlernohora luwnu-a'nani re). ");
INSERT INTO lex_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Yafeta kakni de Sem. Mere Sem ed mak kadurit nana Eber (makdella Yahudi) nor Eber duratni-waitni honona. ");
INSERT INTO lex_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem duratni-waitni de: Elam, Asyur, Arpaksad, Lud, nora Aram. ");
INSERT INTO lex_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram duratni-waitni de: Us, Hul, Geter, nora Masa. ");
INSERT INTO lex_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad na'a'na nana Sela, noka Sela na'a'na nana Eber. ");
INSERT INTO lex_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber na'a'na nana muanke'a woru, id nanni Peleg (nnia'eratni de, rhakre'era), yoma la'a lerni de rhakre'era noh di. Peleg hyalli de nanni Yoktan. ");
INSERT INTO lex_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan na'a'na nana Almodad, Selef, Hasar-Mawet nora Yerah, ");
INSERT INTO lex_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Usala, nora Dikla, ");
INSERT INTO lex_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obala, Abimaela nora Syeba, ");
INSERT INTO lex_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Hawila, Yobab. Hare honona rde, Yoktan duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Lowanni-ahlani rde ema rweran nana la Mesa la walli warta pa nokru Sefar, de wo'ora-kawru mak kdella walli tipru. ");
INSERT INTO lex_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hari honona rde Sem duratni-waitni pa ntikil reri lia yeheni me, nhapar rer lia hlorni (rima-rima ndella nohananni-taniaratni, ra'itar nohora yawalli, nlernohora luwnu-a'nani re). ");
INSERT INTO lex_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hare de Nuh upni-a'nani honona, duratni-waitni re, nlernohora hairni re, ne nwatiawua hari pa nawer nana-napak niana rimormior noh keran di honona la' lera gera ktiowru-opli nhia'a nhio'tarnu. ");
INSERT INTO lex_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ler de noh di mniotni de yawalli ida. ");
INSERT INTO lex_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Noka rwaran pa rla'awa walli tipru, pa rlernana riwni-rai mtatanni la'a Sinear, noka rhol lia hande wa. ");
INSERT INTO lex_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Lera ida rna'ohma pa idma nakot la ida: “Mai pia itsoi lieta-twatat ruhuna la'pa ttutin awru-tsaran watu.” Edon rnairi watu me smen pa rhi'a mere rnairi tanmiera nor tera. ");
INSERT INTO lex_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Lera ida pa rna'ohma owa'ana riwra: “Mai pia tsoi lieta-twatat ruhuna, me itwatatu ili nhioli liarni me watu diena pidarni pa ntut lia lyanti pa itahak kota-nana, totpa it yana tdurmue'era-tsakrie'era it la noh di uhunu-ewatni-ewatni-lahwani.” ");
INSERT INTO lex_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Noka Orgahi Nerun pa Namkeka letlawan dena me il tutullu-gen lolo'oni maka rimormiori rwatat nana. ");
INSERT INTO lex_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Noka Nhar lirni: “Hari de hairi ida me yawala ida pa honona rnairia. Hadi de na'nama kniarni re yanullu, dodo'ondi, hya' maka ha rtetwiana-rtaiwian nana de, hota nla nlola, hadom edon ta'eni la' ira. ");
INSERT INTO lex_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Nhi'p Iterun pa tiwru-tgora yawalli re, totpa idma edon rna'erit nan id yaltierni.” ");
INSERT INTO lex_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Emkade pa Orgahi Ntiwrie'era-nhawrie'era rpa rokru noh di uhunu-ewatni-ewatni-lahwani, nhi'nande tulla-kniarni mana edonna ntutu-nte'ela honi. ");
INSERT INTO lex_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Hade nariei pede, nmai wia dodo'ondi mana let de nanni de rweta de riwra Babel (nnia'eratni de, tiwru-tgora), yoma la' hande de Orgahi Ntiwrie'era-nhawrie'era rimormiori wokni-le'enu, ne ntaw hande pa Orgahi Ne'era-nhakra rla noh di uhunu-ewatni-ewatni-lahwani. ");
INSERT INTO lex_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hadi de Sema duratni-waitni. La'pa Sema umarnu anni rahu id wa noma nayor niana Arpaksad, de anni wornu rlardoini la gera ktiowru-opli nhia'a. ");
INSERT INTO lex_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sema nmormior mia'ta pa anni rahu wolima, la'pa nayor niana Arpaksad pa nhorwua dewade nayor niana Arpaksad wuliodani patke'a rora muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","La'pa Arpaksad umarnu anni terampwotelu wehrani wolim wa, dewade nayor niana Sela. ");
INSERT INTO lex_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpaksad nmormior niekpa aninni rahu wogata wehrani wotelu. La'pa nayor niana Sela pa nhorwua dewade, nayor niana Sela wuliodani patke'a rora muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","La'pa Sela umarnu anni terampwotel wua dewade, nayor niana Eber. ");
INSERT INTO lex_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sela nmormior mia'ta pa aninni rahu wogata wehrani wotelu. La'pa nayor niana Eber pa nhorwua dewade, nayor niana Eber wuliodani patke'a rora muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","La'pa Eber umarnu anni terampwotelu wehrani wogat wa dewade, nayor niana Peleg. ");
INSERT INTO lex_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber nmormior niekpa aninni rahu wogata terampwotelu. La'pa nayor niana Peleg pa nhorwua, dewade nayor niana Peleg wuliodani patke'a rora muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","La'pa Peleg umarnu anni terampwotel wua dewade, nayor niana Rehu. ");
INSERT INTO lex_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Peleg nmormior niekpa aninni rahu woru wehrani wosiewa. La'pa nayor niana Rehu, dewade nayor niana Rehu wuliodani patke'a rora muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","La'pa Rehu umarnu anni terampwotelu wehrani wor wua dewade, nayor niana Serug. ");
INSERT INTO lex_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rehu nmormior niekpa aninni rahu woru wehrani wo'itu. La'pa nayor niana Serug pa nhorwua dewade, nayor niana Serug wuliodani patke'a rora muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","La'pa Serug umarnu anni terampwotel wua dewade nayor niana Nahor. ");
INSERT INTO lex_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug nmormior niekpa aninni rahu woru. La'pa nayor niana Nahor pa nhorwua, dewade nayor niana Nahor wuliodani patke'a rora muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","La'pa Nahor umarnu anni terampworu wehrani wosiew pa dewade, nayor niana Terah. ");
INSERT INTO lex_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nahor nmormior mia'ta pa aninni rahu ida termida wehrani wosiewa. La'pa nayor niana Terah pa nhorwua dewade, nayor niana Terah wuliodani patke'a rora muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","La'pa Terah umarnu anni terampwo'it wua de nayor nian Abram, Nahor nora Haran. ");
INSERT INTO lex_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Hadi de Terah duratni-waitni. Terah nayor niana Haran, Abram, nora Nahor, ne Haran nayor niana Lot. ");
INSERT INTO lex_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","La'pa Terah nmormior mia'ta de Haran, Terah a'nani yanulu nmat tiar lia leta Ur, geni miaka Kasdima rdella, me leta maka rmor tiarga Haran la. ");
INSERT INTO lex_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram nor Sarai rmehlima me, Nahor nor hyalli yanulu Haran a'nani patke'a nanni Milka rmehlima. Milka elli de, Yiska. ");
INSERT INTO lex_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai di nkerna (nakleha a'na). ");
INSERT INTO lex_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Noka Terah nodia Abram nora hawni Sarai me hyalli a'nani Lot pa rla'awa. Rla'awa pa rewre'wa rto'or doinia leta Ur, gen miaka Kasdim rdella pa totpa rla'awa Kana'an lowanni, mere edon rodi liarni, ne rte'ela' leta Haran, noma rholi hande wa. ");
INSERT INTO lex_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah umarnu anni rahu woru wehrani wolima, noka nmat tiar lia Haran. ");
INSERT INTO lex_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Orgahi-Orha'a Nhar lirni pa Nakot la Abram: “Abram ee! Mtio'or la hupmu-woinmu genni-tienni pa mlia'awa noh mak A'upili-uhniari lia o'a. ");
INSERT INTO lex_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Pena A'ura'a-upa'lu, Atiera-die'mu pa mlier la pripanni-fa'anni pa mpial lia pepan mutu-le'u lialawna. Hota mhi' orkotkotni-ornananni la'a rimormiori, me la o' nanpena rimormiori rlernana ra'a-palu. ");
INSERT INTO lex_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Hota A'ura'a-upalga mak kara'a-kapal o'a, ne ghoptutu-ghoplera mak khoptutu-khopler o'a (Aghi'a samomuou riy mak khi' samomuou o'a, ne Aghi'a yatyata riy maka khi' yatyat o'a). Yoma Awualiri o'a, ne onnila o' na'nama rimormior niohkeran di rlernana yara'a-yapalu.” ");
INSERT INTO lex_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Noka Abram nla'awa, nlernohora hya' maka Orgahi Nakot targa la, ne Lot mana nlernohor rewre'wa. Abram mormiorni anni terampwo'itu wehrani wolima, la' ler maka ha nwaran la Haran. ");
INSERT INTO lex_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram nodia hawni Sarai, nora hyalli a'nani Lota, me re'eni-tniarnu honona me ata-wa'ara mak ha rlernana la'a Haran. Rwaran pa rla'awa Kana'ana nohananni-taniaratni, noka rdella hande wa. ");
INSERT INTO lex_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram nala' pa nleretia lowan de, pa nte'ela geni id la Sikhem onni, la ora-au liawna la'a gen miak ha rweta la More. Mere la' ler de, de Makden Kana'ana re rhol lia lowan de. ");
INSERT INTO lex_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ler ida ne Orgahi Ntutga rupni la Abram, noma Nakot la: “Abram! Noh di, hota duratmu-waitmu ra'an lola-remun lola.” Noma Abram nariri katri'ana id la Orgahi, mak na'nama ktutg oleka rupmi la' e'ewa. ");
INSERT INTO lex_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Nhi'noka nwaran la hande pa nla'awa wo'or mak kdella leta Betel walli tipru. Noma nkeni hoiwiali maka rnairi ha ulti la gen die. Leta Betel ndella walli warta me leta Ai ndella walli tipru. Noka nwatatga katri'ana id la Uplerlawna gaini, ne nhoi lia kotni-nwet la nanni. ");
INSERT INTO lex_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Nhor nioka Abrama nwaran wa pa nla' lolola olietni-patounu, pa nlorlor la Negep Lowanni. ");
INSERT INTO lex_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Lerni pa lara nwewar nan noh de, dewade Abrama nla'awa Mesir pa ndella hande emeka do'ona-dakna, onnila lara lawna la noha. ");
INSERT INTO lex_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ler maka niwa nler la Mesir yapatni dewade nakot la hawni Sarai: “Sarai, o' di de mu'irnu hlioi-mat lawruru pa ");
INSERT INTO lex_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","hota la' de makden Mesir ramkek o' pa rpi'u-rga'u lia o'a pa rakota riwra hadi de e hawni noka rwen a'u me rayori o'a. ");
INSERT INTO lex_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Mukot la ira miwra a patke'u atia' o'a mere a na'ru o'a, totpa ralewna a'u.” ");
INSERT INTO lex_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","La'pa Abrama nler la Mesir noha ralamni, dewade makden Mesir ramkeka de patke' de na'irnu hlioi-mat lawruru, ");
INSERT INTO lex_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ne la'pa Firaun tniutnu-nhianni-nhielli-liarni ramkek nana Sarai, noma ra'ulia la'a Firaun gaini ralamni, riwra: “Abram narni de, samounu di!” Nhi'nande patke' de rodia la ray likatni, de de Firaun likatni. ");
INSERT INTO lex_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Firaun nhi' samomuou lia Abrama, yoma ralamni etla Sarai pede nala ata-wa'ara patke'a rora muanke'a ra'itra pipi-duma, sapi, keledai pata-muanu, me onta la Abram. ");
INSERT INTO lex_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mere Orgahi Nalernu nnieni-nhiena lawna la' Firaun, emkade wal lia ray romni mniotni, onnila Sarai, Abrama hawni de. ");
INSERT INTO lex_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Hade pede Firaun npolga Abrama pa nakot la: “Hya' ed maka mhi' nana mai a'u dina de? Nihya'pa edon mukota plele'era, hade de hapmu? ");
INSERT INTO lex_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nihya'pa mukota miwra narmu, pa reiniande aga'ala pa ghi'a la ha'wu? Dodo'ondi, mua' owa'an hapmu pa mlia'awa.” ");
INSERT INTO lex_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Noka Firaun nhopna hopopanni pa rla rottiarga Abrama, nor rewre'wa hawni me hyonni-hyanni re honona. ");
INSERT INTO lex_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Noma Abrama ndella Mesir pa nla'awa Negep lowanni, nora hawni me re'eni-tniarnu honona, ne Lot mana nora talla. ");
INSERT INTO lex_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram de pare'a-patniarga la nhiurni-wnia'anni, mahani, me maha wawahra harahu. ");
INSERT INTO lex_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Nala' pa ndella gen id pa nokru gen dioma, ndella Negep pa nawal pia ndella Betel onni, gen miaka la' ler ululu de nkeni hoiwiali maka rnairi ha ulti, la'a Betel nora Ai rletni, ");
INSERT INTO lex_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","la' gen miaka ha nhi' nana katri'ana mak kala' ulia hande. La hande dewade Abrama npol lia Orgahi nanni. ");
INSERT INTO lex_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot mana nor walia Abrama talla, me ntaru pipi-duma, hayori-orpau (sapi) me hoiwiali. ");
INSERT INTO lex_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Mere gen die naklierta, pa edonna ntu'tu nana rrora pa rhol wut rewre'wa, yoma re'eni-tniarnu re harahu rehia, reiniande ta'en niana rhol wut rewre'wa. ");
INSERT INTO lex_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Nhi'pede Abram hopopanni mak kodi pipni-dumni rora Lota hopopanni mak kodi pipni-dumni re rawo'ora. La' ler de de makdena Kana'ana me makdena Feris rhol lia lowan de wali. ");
INSERT INTO lex_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Hade pede Abrama nakot la Lota: “Yanpa itro'a tler la yawunu-yawenna, ne la'pa mak kodi pi'pu-du'mu rora mak kodi pipmu-dummu re rawo'ora, yoma it di de riy id ita. ");
INSERT INTO lex_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Gen di tetema nawnierne'era la tiy o'a. Samounu de itro'a twahakar wa. La'pa omuokur malwir die, agokur malganna, la'pa omuokur malganan de, agokur malwiru. ");
INSERT INTO lex_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Noka Lota nran gaini pa namkek lolda-lolda, de rai mtatanni la Yordan la' pa nokru Soar, de gerni harahu, emolmolla Orgahi nhyi'ini la' Eden, me emolmolla Mesir lowanni. Mere hadi namtemn ulu, ler maka Orgahi edonna Nweyat ma'ta leta Sodom nora leta Gomora. ");
INSERT INTO lex_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Nhi'pede Lota nwaliria rai mtatan la Yordana honona pa gahani, noka nwaran pa nokur tipru, pede rwahakar wa. ");
INSERT INTO lex_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abrama ndella Kana'ana nohananni-taniaratni, ne Lota ndella leta-let mak kdella rai mtatan la Yordan, pa rehgorgor Sodoma. ");
INSERT INTO lex_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Mere makden Sodom re de riy kapliahan mera, ne rhi' do'a-ryap hiala la' Orgahi-Orha'a. ");
INSERT INTO lex_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","La'pa Lota nto'or targa Abrama dewade Orgahi Nakot la Abrama: “Mumkek lolda-lolda, ne mtia'wa matmu la gen miaka ha mtiutrier lia di, pa nokur tipru, warta, ra'i me tranna, ");
INSERT INTO lex_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","yoma gen di tetema maka mumkek nande hota Agala tiy o'a me gal wal lia duratmu-waitmu, pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ne hota Aghi'a duratmu-waitmu liawanni pa emeka en liu'wu-tan miakmu, la'pa he' mak krekan nana en liu'wu-tan miakum de, de rrekan nan wali duratmu-waitmu. ");
INSERT INTO lex_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Mpuahi'a-mpuayod wia, mula' etia noh di ewatni-lahwani, yoma hota la o' nanpa Agala nohanna-taniarat di.” ");
INSERT INTO lex_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Nhor nioka Abrama nwaran pa nawal wia pa nla nhol lia ora-au liawna aratni la'a Mamre, Hebron onni, noka nariria katri'ana id la Orgahi-Orha'a. ");
INSERT INTO lex_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Lera ida pa ray wogata mak kdella nohanna-taniarta la walli tipru rmai pia rora ray wolima handina ra'ara. Ray wolim di, rodi plola-rtaryat lia leta-leta rehgorgoru geni miaka Lota, Abram hyalli a'nani ndella. Ray wogat mak kwatiawu tipru de, de Kedorlaomer, Elam rayni, Amrafel, Sinear rayni, Ariok, Elasar rayni, me Tideal, Goyim rayni pa rmai pia rora ");
INSERT INTO lex_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ray wolim di, Sodom rayni Bera, Gomora rayni Birsya, Adma rayni Syinab, Seboim rayni Syemeber, Bela rayni (Soar rayni), pa ra'ara. ");
INSERT INTO lex_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Sodom rayni Bera nora talanwalli rawok la rai mtatan nwawa Sidim mak edon nagera-natah'i ma'ta. (Mere dodo'ondi nagera-natah'i oleka pede nanni Tah'i Mahana.) ");
INSERT INTO lex_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Rawok la pa ra'ara, yoma anni termida wehrani wor die ray ri ratlina-ratailla Kedorlaomer, mere la'a anin mak kod lia termida wehrani wotellu dewade edonna ratlina-ratailla (rmalawna). ");
INSERT INTO lex_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","La'a anin mak kod lia termida wehrani wogatni dewade Kedorlaomer na'itra ray-ray miak kor rewre'wa e' pa rmai wia, noka ralernu riy harahu la' ar ralma, de makden Refaim la Asyterot-Karnaim, makden Susim la Hama, makden Emim la Syawe-Kiryataim ");
INSERT INTO lex_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ne makden Hori la'a wo'orni-kawarnu mak kwawa Seir, me makden Hori mak kawlar pia nla'gennia El Paran, la'a wewan mou aratni. ");
INSERT INTO lex_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Nhor nioka Kedorlaomer nor talanwalli re rawal pia rla'awa En Mispat, de Kadesy, ne ralernu momuou makden Amalek lowanni-ahlani, ne makden Amori, de mak kdella Haseson Tamar. ");
INSERT INTO lex_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Emkade pa ray Kedorlaomer ralernu riy harahu mere Sodom rayni, de edon ralernu ma'ta. Noka Sodom rayni nora talanwalli, de ray-ray rwatiawu hairi wogata dom to'a de ray ror wutga mak klernohora re rlergot pa rohon ara pa rlewru ray Kedorlaomer nor talanwalli la' rai mtatan la Sidim. Talanwalli re ray-ray ror wutga mak klernohora re rwatiawu hairi wotelu dom to'a. ");
INSERT INTO lex_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Mere la'a rai mtatan la Sidim de nlol meni-meni nekpa rlernana loka kdieldelma-da'ala metmetma. (Sodom rayni rapal lia Kedorlaomer mere ta'eni ra'ar nana pa rawlari). La'pa Sodom rayni nora talanwalli rawlar wia, dewade riy dom rtopur tar lia loka kdelma-da'ala metma ralamni, ne dom rawlar pia rla'awa wo'ora hananni. ");
INSERT INTO lex_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Sodom nora Gomora re'eni-tniarnu, ya'anni-yemannu re arwalli rheri-rhewat nana pa rla'awa. ");
INSERT INTO lex_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lota ndel wal lia Sodom pede Lota na'itar neka re'eni-tniarnu pa arwalli rodia pa rla'awa. ");
INSERT INTO lex_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mere Abrama, makdena Ibran die, nkeni oleka hoiwiali la ora-au liawna onni maka Mamre, makdena Amori gahani. Mamre di nora hyalli Eskol me Anera, de Abram nor ira rodia ihru ida-ralm ida. Noka mak kawlar pia nlewan la arralma nmai pia nwahauru hadella Abram niwra: “Abram ee! Rodi wlari oleka Lot wa.” ");
INSERT INTO lex_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","La'pa Abram natlina rtoran nana hyalli a'nani, dewade npolu limni-rorni mak katu ka'ara, maka rmoria la romni nayanni, riy rahu wotelu termida wehrani wo'awa nhor nioka nor limni-rorni re rhokra arwalli rpa rodi liarni la Dan lowanni. ");
INSERT INTO lex_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Ne la'pa lera nmella dewade nora limni-rorni rhakar talan pa rlewria arwalli re. Ralernu arwalli me rhokra pa rla'gennia Hoba, Damsik walli ra'i. ");
INSERT INTO lex_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Rodia re'a-tniaru re honona pa rawal wia. Rodia Lot wali nora hawni na'itra atni-wa'arni me re'eni-tniarnu pa rodi rawal wia. ");
INSERT INTO lex_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","La'pa Abrama nalernu Kedorlaomer nora ray-ray miak kor rewre'wa talla pa nawal wia dewade, Sodom rayni nlergot pa nwatroma la rai mtatan la Syawe, maka rwet walia de Ray. ");
INSERT INTO lex_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melkisedek, Salem (Yerusalem) rayni, nodia roti me anggur turnu la Abram. Melkisedek di, makpolu-makwaka la (imam) Uplerlawna mak kdella tutullu-lolo'oni. ");
INSERT INTO lex_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Noka nwak la Uplerlawna pa Nara'a-napalga Abrama niwra: “Orgahi mak kdella tutullu-lolo'oni, maka'ohi-maka'ara lyanit marna nohkerna-rai miaran di pena Nara'a-napa'lu. ");
INSERT INTO lex_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ne ya'uli-yawed lia Orgahi mak kdella tutullu-lolo'oni mak kala arwalmi la o limmu ralamni.” Noka Abrama nal doini nhiakra id la termidni la re'eni-tniarnu re honona la Melkisedek. ");
INSERT INTO lex_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom rayni nwaka pa ntuwu-nhaiya nhernu-nwauga Abram ya'arni pa nakot la Abrama niwra: “Muala a rimormio'ru (li'mu-ro'ru) re mai a'u, ne mliernana re'a-tniaru ri honona.” ");
INSERT INTO lex_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Mere Abrama nakot la Sodom rayni de: “Aliokar la'a Orgahi mak kdella tutullu-lolo'oni, makohi-maka'ara lyanti me nohmaran di. ");
INSERT INTO lex_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Hota A'g edon ga'ala hya'a-hya'a la re'emu-tniarmu re, nhor lawra patpati ida me, lakmu wniowni talli id mana edonna, totpa yana omiwra: “Aghi'a Abrama pa pare'a-patniarga.” ");
INSERT INTO lex_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Pa eitnek wa, hya' maka am ma'an nana-memun nana la'pa ama'ara de ndella. Ne la'a a talanwa'lu de, Aner nora Eskola me Mamre, muollia pa rima-rima pena ra'ala nhiakarni.” ");
INSERT INTO lex_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Lera ida ne Abrama ndarat nan de Orgahi-Orha'a Nhar lirni la Niwra: “Yan mumta'ata Abram. A' di de tiokmu-nhiepmu, onnila omliernohora A' di de wniahlamu hota inponni memna. ");
INSERT INTO lex_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abrama nwahla: “Matroma, O' nanpena mak kodi plola-ktaryatu, hya' maka hota Muala mai a'u, yoma hota muat die ukleha upa-a'na, ne mak kodi plolli la ro'mu di de Elieser, makden Damsika mniotni de. ");
INSERT INTO lex_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","O' edon Muala durti-wait mai a'u, nhi'nande a hopopnu ida nhi'a mak kodi plol la re'a-tnia'ru.” ");
INSERT INTO lex_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Mere Orgahi lirni: “Edonna, Elieser di edon nhi' mak kodi plolli la re'emu-tniarmu, mere a'na raralammu. E' nanpena mak kodi plol la re'emu-tniarmu.” ");
INSERT INTO lex_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Noka Orgahi Nodia Abram pa nlergot la tio'ora, na'nama Nal lir la: “Mpuatniar la heyanna. Wtion mak kden heyanna taken niana mriekan nana. Emkade wal lia hota o duratmu-waitmu.” ");
INSERT INTO lex_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Lira re honona Abram npesiaya pa nha'ar aranni la. Hade pede Orgahi Nreiniana-na'nan Abram de, mak kaplol la E yamkekni. ");
INSERT INTO lex_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Noma Orgahi lirni owa'an la: “A' di de Orgahi-Orha'a Uplerlawna-Mempulwatnu mak kodi o' pa mliergot la leta Ur (gen miaka Kasdim rdella) totpa Agala geni di la o'a pa mhi'a la nhiakarmu.” ");
INSERT INTO lex_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Mere Abrama nakot la: “Matroma, O' mak kodi plola-ktaryatu. Mere emkameni totpena agat niohora hari honona a gah'u?” ");
INSERT INTO lex_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Orgahi lirni la: “Agala kniau id tiy o'a. Mua'ala sapi rara ida, umarnu anni wotelu, pipi rara mak umarnu anni wotelu, duma ltiata id maka umarnu anni wotelu, loktieru ida me lmo'ma maru (merpati) trapriapi ida pa muodia mai A'u.” ");
INSERT INTO lex_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Noka Abram na'ala hare honona pa nala la Orgahi, nhartietia la woru, na'nama nwatemna deullu nenenan pa nken tiemna la deul walli onni, mere onu-ma'nu rde edonna nhartia. ");
INSERT INTO lex_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","La'pa onu-ma'nu dawra, rtailia nhiuri-wnia'ana re ananni, dewade Abrama nawohora re. ");
INSERT INTO lex_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","La'pa lera nmel wa de Abram nanin hal memna. Noka melmela-kalkalma nma kaduw nana nhi'nande Abrama namta'at wenna. ");
INSERT INTO lex_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Orgahi Nhar lirni la Abrama: “Plollolli de, de duratmu-waitmu hota rhi' do'ona-dakan la noh meheni ida, maka gahani atia'a, ne hota rwa'ata-rwa'ara me ramuki-rama'ala, la'pa anni rahu wogata ralamni. ");
INSERT INTO lex_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mere hairi meni mak kwa'ata-kwawa'ara hare, hota Aghi'a pa hoptutu-hoplera totpena hota ir rlergot la hande, de rodi miemna-ral memna re'eni-tniarnu. ");
INSERT INTO lex_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Mere o' di de hota muodi kalwiedni-paitiotni pa mlia' temna up ulmu-tgar ulmu mak kmati olekwa. De la'pa moratmu nhamra me nihimu ntuini nanpa omuerun la ketarmu me retru la lumanmu. ");
INSERT INTO lex_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Mere tuwu wogatni nanpa hota duratmu-waitmu rawali owa'an mai handi, onnila makden Amori do'oni-halli edonna ntu'tu ma'ta pa Aghoptutu-ghoplera.” ");
INSERT INTO lex_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","La'awa lera nmel wa noma Abram namkek de ai woka ida mokalli nlergot la ralamni nor wutga hulu nmormiori nlola nhiuri-wnia'ana ananni letgarni. ");
INSERT INTO lex_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","La' ler de de, Orgahi Nhi'a nnio'a id la Nora Abrama, lirni: “Agala gen dilla duratmu-waitmu. Noha di nden nek la Mesir gerlawanni de nodi liarni la gerlawlawan de, de gerlawna Efrata, ");
INSERT INTO lex_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ne makden Keni re nohananni-taniaratni, makden Kenas, makden Kadmon, ");
INSERT INTO lex_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","makden Heta, makden Feris, makden Refaim, ");
INSERT INTO lex_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","makden Amori, makden Kana'ana, makden Girgasi, me makden Yebusi re nohananni-taniaratni de. Honona re Agala tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Noma Sarai, Abrama hawni de nakleh a'na. Mere gahani ata patke'a ida nwatiawua Mesira, nanni Hagar, ");
INSERT INTO lex_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","pede Sarai nakot la Abrama: “Omuat niohora de Orgahi edonna Nal a' pua a'u'a'na. Hade pede pena omuora a'tu de mininmi. Matiala hade nanpa aliernana durti id mai a'u. Ne Abrama natlin la hawni lirni. ");
INSERT INTO lex_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Nhi' pede Sarai na'ala atni Hagar noka nala la Abrama totpa nhi'a la hawa liahunu. La' ler de de Abram nhol lia Kana'ana anni termid olekwa. ");
INSERT INTO lex_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abrama nora hawa liahunu ranina, noka patke' de na'apun wa. La'pa na'eram nan de na'apun wa dewade edon natota-nawaw etia upni-matromni Sarai. ");
INSERT INTO lex_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Noka Sarai nakot la Abrama: “Papa, erierannu-padpa'danu mak atiutulu-ukwar di de o kwarmu hade. A'g ed mak kala a'tu della riwpmu wawannu, mere na'nama na'eram nan de na'apun olekwa, dewade edon natota-nawaw nan a'u. Orgahi ed mak khi'a plola-mneha mai a'u me o'a.” ");
INSERT INTO lex_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abrama nakot la hawni Sarai: “Atmu de etla limmu ralamni, mhi' to' hya'a-hya' maka ompuarora de samoga la wawannu.” Mere Sarai nhi' yatyata Hagar pa reiniande nawlar wia pa nto'or doinia la. ");
INSERT INTO lex_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Noka Uplerlawna Ntutga rupni emolmolan neka Uplerlawna hopopanni-li'irnu pa Nwatroma la'a gera ormata id onni la'a gen mak kerkerna, de de gera ormata mak kdella talan mak kokru Syur. ");
INSERT INTO lex_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Niwra: “Hagar, Sarai atni nee, ompuatiawu meni pa omlia'awa la hanmeni?” Wniahlani: “Matroma, a'uwlar pia atio'or la a matro'mu patke'a.” ");
INSERT INTO lex_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Noka Orgahi hopopanni-lili'irnu Nakot la: “Muwal lia matrommu patke'a, nhi'in della pa la'pa mutlina-mutailla. ");
INSERT INTO lex_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Hota Aghi'a duratmu-waitmu pa harahu, nhi'nande ta'eni rrekan nana, yoma liawanni memna. ");
INSERT INTO lex_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","O' e mu'apnu, ne hota mu'a'na nana muanke'a ida, ne mual nanni pa nwawa Ismail (nnia'eratni de, Orgahi Natlin nana) yoma Orgahi Nat niohora o ralam mehramu. ");
INSERT INTO lex_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","A'namu de hota yehwani o'ta-watnu emeka keledai pora, ne hota nhi'inde nora riy rawenna, reiniande hota nor inni-amni amni-hyalli rawenna.” ");
INSERT INTO lex_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Nhor nioka Hagar nal nana la Uplerlawna niwra: “O' de El Roi (nnia'eratni de Uplerlawna mak kamkek a'u).” Yoma lirni: “La' handi de a'umkek oleka Uplerlawna mak kamkek a'u mere a'g edonna muati miano!” ");
INSERT INTO lex_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Hade pede ger de riy rala pa nwawa gera Ber Lahai-Roi (nnia'eratni de ger maka Uplerlawna mak kmormiori die Namkek a'u.) Ger di ndell ma'ta la leta Kadesy nora leta Bered rletni. ");
INSERT INTO lex_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nla'awa noma lera ida ne Hagar na'a'na nana muanke'a id la Abram, ne Abram nweta a'nani maka Hagar ntor doin de nanni Ismail. ");
INSERT INTO lex_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","La' ler de de Abram umarnu anni terampwo'awa wehrani wonema. ");
INSERT INTO lex_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","La'pa Abram aninni terampwosiewa wehrani wosiew wa, dewade Orgahi Ntutga rupni la, Nal lir la: “A' di de Orgahi-Orha'a Uplerlawna-Mempulwatnu mak kodi plola-ktaryatu, muor liola A ga'yu ralamni de yana mpua'eini-mpuahala. ");
INSERT INTO lex_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Hya' maka A'ukot oleka de, dodo'ondi A'ukot owa'ana, de hota Aghi' nana nnio'a id mai A'u gor o'a, ne hota Aghi'u pa liawanmu.” ");
INSERT INTO lex_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Noka Abram nwaltior pa nuh' idma-nrama lia'ara, noka Orgahi Nal lirni la: ");
INSERT INTO lex_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","6","“Hade pede hota itro'a tsi'a nnio'a ida, hota omhi'a am la hairi liawanni. Duratmu-waitmu harahu memna pede hota rhi'a hairi liawanni ne hairi-hairi rayni. Hade pede o nanmu de hota edonna rwet hadella Abram, mere hota rwet hadella Abrahama (nnia'eratni de hairi-hairi rora rimormiorni amni.) ");
INSERT INTO lex_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Agora o'a me duratmu-waitmu tsoratreria A nnio'u di la'pa nodi liarni totpena Aghi' Uplerlawan la omuora duratmu-waitmu re. ");
INSERT INTO lex_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","La'pa Kana'ana tetema, geni mak omdiella emolmolla do'ona-dakan di, de Aghi' pa muora duratmu-waitmu miy hanmi la'pa nodi liarni. Ne Aghi' Uplerlawan la duratmu-waitmu re. ");
INSERT INTO lex_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Omuora duratmu-waitmu tuwu la' tuwu mtiorrer pitpitu nnio'u. ");
INSERT INTO lex_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Hadi de nnio'u: de muanke'a meha-meha la' miy die de rsunta. ");
INSERT INTO lex_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Rteti molli-ma'ani ulatni de, hade ed mak khi'a kniau la'a A nnio'u gor miy totpena rat niohora mliernohora A'u. ");
INSERT INTO lex_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Muanke'a mak lerni wo'awa rde nhi'de rsunta, de muanke'a meha-meha tiy miy, tuwu la' tuwu, mak kmor lia rommi nayanni, me maka ral kupna ra rawel niana la do'ona-dakna. ");
INSERT INTO lex_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Muanke'a honona rde nhi'de rsunta totpena kniau mak A nnio'u de nayamkek toto'ola inonmi pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ne muanke' maka edonna rsunta, de riy mak emkare de, rhoiya la Uplerlawna mutnu atia'a. Yoma nhoitio'ora oleka nnio'u. ");
INSERT INTO lex_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","La'a hapmu Sarai, yana mpuet nanni de Sarai, mere nanni de Sara (nnia'eratni de, ray a'nani patke'a.) ");
INSERT INTO lex_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Plollolli de hota A'ura'a-upalga pa gala a'na muanke'a id tiy, me hota Aghi'a pa nhi'a in la hairi liawanni me duratni-waitni rhi' ray-ray lia hairi liawanni.” ");
INSERT INTO lex_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Noka Abraham nuh idma-nrama lia'ara mere namali, ne nwarora-nwalai: “Emkade wal pia riy maka mormiorni nla nte' nana anni rahu id de na'a'na ma'ta, ne emkade wal lia Sara mak kmor niana anni terampwosiewa de nmor niana a'na ida?!” ");
INSERT INTO lex_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Noma Abrahama nakot la Uplerlawna: “Matroma, samounu de Omhi' wutga nnio'omu la Ismaila.” ");
INSERT INTO lex_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mere Orgahi Nhar lirni: “Edon emkade, yoma Sara mak ka'a'n nana muanke'a id tiy o'a, ne hota mual nanni de Isak, ne hota Aghi' wutu A nnio'u la pa nla nodi liarni la Isak duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","La'a Ismail de, A'utlin oleka wakwakmu. Plollolli de hota Agala ra'a-palu la, pa Aghi'a pa na'upa-na'a'na, ne duratni-waitni harahu. Hota nadurit nana ray termida wehrani woru, ne hota Aghi'a pa nla'a hair lalawna. ");
INSERT INTO lex_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mere nnio'u hota Aghi' wutga la Isaka, mak hota Sara na'a'na nana tiy o'a la'a anin li'iru la'a wenu-wolla emolmolla ler di.” ");
INSERT INTO lex_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","La'pa Orgahi Nahor lirni la Abrahama dewade, Orgahi Nha'at la Ilyamou-Watyatoha pa Nto'or doinia Abrahama la. ");
INSERT INTO lex_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Nhor nioka Abrahama npolga Ismail ne riy honona maka rmor niana la romni nayanni rora maka ha nal kupan la nawel niana re, de muanke'a meha-meha la romni ralamni, noka nteti molli-ma'ani re tutnu la' ler de meman neka, emolmolla maka Orgahi Nakot targa la. ");
INSERT INTO lex_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham nmor nian oleka anni terampwosiewa wehrani wosiewa la' ler maka ha rsunta. ");
INSERT INTO lex_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ne Ismail aninni termida wehrani wotelu, la'a ler maka ha rsunta, ");
INSERT INTO lex_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","pa rora muanke'a honona re rtet wutga molli-ma'ani re tutnu. ");
INSERT INTO lex_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Lera ida ne Abrahama namtatan reria la hoiwiali nhiarni gaini la'a ora-au Tarbantin no'a Mamre genni onni, de lera nwawuau ro'onni. Noka Orgahi Ntutga rupni la, de ");
INSERT INTO lex_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abraham nran gaini, namkek nana riy wotelu rtutrier lia gaini ralamni. Namkek nana dewade nawlar pia ntawu hoiwiali nhiarni gaini pa nla nwatroma re, noka nwaltiora-nwaltiemna. ");
INSERT INTO lex_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Noma niwra: “Am miy re, la'pa ralammi nal a'u die, awuak de yana mtio'or mai a'u. ");
INSERT INTO lex_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Pena rala gera oke' pa mialla miohma doin lakmi la, pa tren kuku' la au di nayanni. ");
INSERT INTO lex_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Mai pia temnu pleini pa miruri-milai owa'ana nhor nianpena mila' pa miodi liarmi. Miy mmiai olek la gen di pa aghoi-tiania miy.” Rwahla riwra: “Ampayowa.” ");
INSERT INTO lex_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Noka Abrahama plet pa nla'awa hoiwiali pa nwatroma Sara pa nakot la: “Sara, mua'ala wetra' hota sak ida mak samomuou. Plet pa mriahmia la rot piopo'ola.” ");
INSERT INTO lex_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Noka Abraham nawlar tiemna nhiurni-wnia'anni re, noma na' nana sapi a'na molmola ida, pa nala la hopopanni re riy ida, noka pleta-plet pa nwenna na'nama ntunu-nahaga. ");
INSERT INTO lex_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Nhor nioka Abraham na'ala uhu tiuru mak kami'na me uhu tiuru mak kmilu na'itar wutu sapi a'na, noka nhoiya la hare gaini. Me Abraham ntutrier niohora re la'a au nayanni, de e rara'an reri. ");
INSERT INTO lex_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Noka ratiana Abrahama riwra: “O hapmu etla meni?” Noka Abrahama niwra: “Etla hoiwiali nayanni.” ");
INSERT INTO lex_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Noka Orgahi Nal lirni: “Mhoratreria me! Hota Amuai owa'an la anin li'iru pa itwatroma, de hapmu hota nmor nian muanke'a ida olekwa.” Ne Sara e natlin reria la'a nhiar miak della Abraham to'orni. ");
INSERT INTO lex_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Mere Sara nora Abraham rhamto'a-rhape' wal wia, ne Sara mana edon nlernan oleka karorta-kdeh wal wia. ");
INSERT INTO lex_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Pede Sara namali ne ralamni niniha pa nwarora: “Agora Abraham mhamto'a-mhape'ewa ne hota a'u'a'na emkameni?” ");
INSERT INTO lex_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Noka Orgahi Nhar lirni la Abrahama: “Nihya'pa Sara namali pa niwra: “Plola pa hota a'u'a'na, mere aghape' olekwa?” ");
INSERT INTO lex_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Hya' to' maka rimormiori ta'eni rhi'a de, Orgahi Nhi' nana. La'a ler maka Aget tiarga de, anin li'iru, A'uwali owa'an pa itwatrom de Sara nmor nian a'na muanke'a ida olekwa.” ");
INSERT INTO lex_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Mere Sara nreher doinia, niwra: “A'g edon umali.” Yoma namta'ata. Mere Orgahi Niwra: “Edonna, omumal tioto'a!” ");
INSERT INTO lex_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Noka riy mantetelu re rwaran la gen die, ne ramkek la leta Sodom. Ne Abrahama nala' wut lia re pa nod niohora. ");
INSERT INTO lex_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Noka Orgahi-Orha'a Nwarora: “Nhi'pa A'ude'a la Abraham, hota Awueyata Sodom letni me yana? ");
INSERT INTO lex_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Samounu de A'ukot nohora hadilla Abraham yoma Abraham di nla' nana hair lalawna mak kodi plolli-ktaryatnu, ne tototni-rerieini pa rimormiori nohkeran di wawannu rlernana ra'a-palu. ");
INSERT INTO lex_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Awualir nian Abraham oleka wa, totpa nhopna duratni-waitni, totpa rlernohora talan mak Atiut tiarg oleka, de rhi' nana plola-mneha totpa A nnio'u de ntutu-nte'ela Abraham nor wutga duratni-waitni. Hade pede A'ukot nohora hya' maka Agiwa ghi'a di.” ");
INSERT INTO lex_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Nhor nioka Orgahi Nhar lirni: “Abraham! Plola pa riy rahu rpolpuolu-rwakwak mai A'u die, riwra, riy mak kdella leta Sodom nora Gomora do'oni-halli werat rehia. ");
INSERT INTO lex_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Pede Amueh'a gerun pa A'umkek memna totpena Agat niohora de, plola pa hihi'ini-yapyapni nhiolli-lietni emolmolla maka riy rakot la mai A'u, me edonna.” ");
INSERT INTO lex_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Noka riy maroro'a re rhoitio'or la hande wa pa rala' pa rokru Sodom, mere Abraham naprir rier mia'ta la Orgahi gaini. ");
INSERT INTO lex_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abrahama nma nrehgor pua niwra: “Matromlawnu ne! Plola pa hota Omkuh dioinia-mhuo'or doini riy plollola ra'itar wutu mak khi' do'a-kyap hiala? ");
INSERT INTO lex_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Emkameni la'pa riy plollola terampwolima mak erla let de ralamni? Plollola pa hota Omkuh dioini-mhuo'or doini gen diella, ne edonna Mual targa yariwa-yahai la, onnila riy plollola teram matlimlimni mak kdella ralamni? ");
INSERT INTO lex_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Olie'tu la hihi'a-yapyapia mak emkade, Mpuenan wutu riy dodo'a-halala rora riy plollola-mneneha, nhi'nande mak kaplola re emekwali mak khi' hala! Olie'tu la hihi'a-yapyapia mak emkare tiy O'a! Yanhi'pa O' mak ktorna watghudi lokarni-tatiaili lahannu la noheri woru-lyanti nayanni edonna Muodi plollolli pa Mukmua?” ");
INSERT INTO lex_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Orgahi Nhar lirni: “La'pa Aliernana riy plollola terampwolim la Sodom ralamni, de Agho' li'mu me Ariei ro'ru la gen die tetema, onnila hare.” ");
INSERT INTO lex_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahama nwahla niwra: “Plola pa a'g e ghi' parania ino'nu pa ultier wut lia Orgahi, emkameni ho'mana koda-awu a'u. ");
INSERT INTO lex_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","La'pa nho' nana riy wolim la riy teram matlimlima mak kaplola rde, hota Mpueyata-mpuaniawua let de onnila riy matlimlima rena?” Lirni: “A'g edonna wueyata-wuaniawua, la'pa Aliernana terampwogata wehrani wolim la hande.” ");
INSERT INTO lex_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahama nhauri owa'an lirni pa nakot la: “La'pa Omliernan to'a terampwogat la hande de?” Lirni: “A'g edonna wueyata-wuaniawua, onnila teram mandadatni re.” ");
INSERT INTO lex_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Lirni owa'ana: “Yana Matro'mu Nawunu-nawenan mai a'u, la'pa a'ultier nian ralamni owa'ana. La'pa Omliernan to'a terampwotel lia hande de?” Lirni: “A'g edonna ghi' nan emkade, la'pa Aliernana teram mantetellu re la hande.” ");
INSERT INTO lex_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Lirni: “Plollolli de, aghi' parania ino'nu pa ultier wut lia Matro'mu. La'pa Omliernan to'a terampwor lia hande de?” Lirni: “A'g edonna wueyata-wuaniawua, onnila teram maroro'oni re. ");
INSERT INTO lex_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Lirni: “Matro'mu yan Nawunu-nawenan mai a'u la'pa a'ultier nian ralamni to' owa'an di pa onanwa. La'pa Omliernan to'a termid la hande de?” Lirni: “A'g edonna wueyata-wuaniawua, onnila teram memeheni de.” ");
INSERT INTO lex_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Noka Orgahi Nla'awa, la'pa Nahor dioinia lirni la Abrahama. Ne Abraham mana nawal pia nla'awa genni-tienni. ");
INSERT INTO lex_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Noka Orgahi hopopanni-lili'irnu rora rte'ela leta Sodom la lera lia'ani. Lota e nora ina-ama leta ramtatan wutga la Sodom puohrani gaini, ne la'pa Lota namkek nana re dewade naprir pia nwatroma, noka nwaltiora-nwaltiemna la hare gaini. ");
INSERT INTO lex_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Noma niwra: “Am miy re, mai pia itwarini pleini totpa miroha-mirarmi pa repardoin nanpa mila' doin yala'ami la.” Rwahla riwra: “Yan nek wa, pena amanin la wewan mou wawannu la let di letgarni.” ");
INSERT INTO lex_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mere onnila Lota nwakwak memna noma rlernohora pa rla rlola likatni, nhi'noka rhoiya yamanna nora rot miaka na'nama rtunga mak edon rnairia tgo'a (ragi) la pa ra'ana. ");
INSERT INTO lex_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Mere la'pa edon ranin ma'ta, dewade muanke' mak kdella Sodom re, ntawua trapriapni pa nodia la hamtoto'oni, la'pa leta tetema, id mana edonan nden hala, rma rpe'pa likit de. ");
INSERT INTO lex_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Noka rhaun la Lota riwra: “Lot ee! Riy mak kmai lia o'ola mel di erla meni? Muodgiota mai am lia tio'or di, totpa amora mpadu'ul wutu.” ");
INSERT INTO lex_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Noka Lota nlergot pa naprir lia nhiari gaini na'nama nho'la taru nhiari la to'orni pa nakot la re, ");
INSERT INTO lex_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","niwra: “Ama-hyal miy re, yana mhi'a do'a-hala yatni-halli mai let di ralamni. ");
INSERT INTO lex_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mere mitlina, yana mi'ala muanke'a ri mere mi'ala a a'nu patke'a worg era ri, de muanke' id mana edonna nheik ma'ta la inonni, pena agodgiota tiy miy die, mhi' to'a hya'a-hya'a la wawannu re, plolli nek tiy miy wia. Hornama yan memmemna mhi' hadomdom la muanke'a ri, yoma ha rma ruwnu inonni la a liktu di.” ");
INSERT INTO lex_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mere riwra: “Mriei lia walli! Ommuai handi de emek do'ona-dakna, ne miwra mhi'a mak kodi plola-mneha mai ami?! Dodo'ondi amhi' yatyatni-halalli tiy o'a nareh liawna riy maroro'a re!” Noka ratek la Lota, ne rwakrian pia totpa rleran doini nhiari la. ");
INSERT INTO lex_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mere riy maroro' mak kdella likti ralamni rtan limni pa rtoran Lot na'nama rodia pa rla'awa likti ralamni ne rho'la nhiari. ");
INSERT INTO lex_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Dewade rwenta riy rahu mak kdella likti nhiarni gaini re matni, ntawua trapriapni pa nodia la hamtoto'oni, reiniande rlol to'a hgalli la nhiari yahakni. ");
INSERT INTO lex_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Noka riy maroro'a re rakot la Lota: “Lupmu-rommu he' ed ma'ta la let dina? Yananmu, a'namu patke'a, a'namu muanke'a la'pa he'-he' to'a lupmu-rommu la' let di, muodia pa mliergot la gen di, ");
INSERT INTO lex_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","yoma hota ampeyata-mpaniawua gen di, yoma riy rahu rakot nohora oleka la Orgahi gaini, de riwra riy mak kdella handi de do'oni-halli de lawan rehia. Hade pede Orgahi-Orha'a Nhopan pa ama mpeyata-mpaniaw doinia la.” ");
INSERT INTO lex_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lota nlergota, pa naltier wut lia panin raralamni re rora, mak hota kora a'nani patke'a rora rmehlima, niwra: “Mimata, plet pa mliergot la gen di, yoma Orgahi hota Nweyata-nwaniawu let di.” Mere panin raralamni rora rwarora de panin Lota nkakrom to'a. ");
INSERT INTO lex_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","La'pa nmer la tipru dewade Orgahi hopopanni-lili'irnu rora rtekua Lota, totpa pleta, riwra: “Ple'etu! Mumat pa muodia hapmu me a'namu rora mak erla handi, totpa yana mmiati-mmiolu lia let di do'oni-halli wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","La'pa Lota nhi' kuke' ma'ta dewade Orgahi hopopanni-lili'irnu rora rte'la la Lota nor hawni-a'nani limni noka rodia rla'awa leta to'orni onnila Orgahi Nal ralam kalwiedni rla. ");
INSERT INTO lex_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","La'pa ha rora rodia rla leta to'orni pa nhorwua dewade id niwra: “Miwlari, plet pa milewna inonmi. Yan mikillia to'ormi, ne yan memmeman neka mtiut tiarg lia meni-meni la rai mtatan la Yordana lowanni, mere plet pa miwlar lia wo'ora hananni, totpa yana mmiati-mmiolu.” ");
INSERT INTO lex_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lota nakot la re: “Tuna, awuak pa yana emkade! ");
INSERT INTO lex_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Plola pa aliernan oleka ralam kalwiedmu la' gaimu ralamni, ne mhi' oleka ra'a-pal liawna mai a'u, onnila mhilpai-mianatga a mormio'ru, mere hota a'uwlar mieman la wo'ora hananni de matmiat die nhapartikil nan a'u, pa nhi'nande hota amuati. ");
INSERT INTO lex_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Mumkeka, let ku' ida e rehgorgoru lia hande. Ompuayow pa a'uwlar pia liawa let ku' de. A'uwlar lia let de, de mormio'ru hota ralewan nana.” ");
INSERT INTO lex_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Orgahi hopopanni de nakot la: “Wakwakmu de arieinian samomuoga, de let maka ha mukot de hota a'g edonna wuatiri-wualiakra. ");
INSERT INTO lex_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pletmi, miwlar lia hande, yoma la'pa o' edonna mlia' ma'ta hande, de a'g edonna ghi' nana hya'a-hya' doma.” Hade pede let de nanni de rweta la Soar (nnia'eratni de, kuku'a). ");
INSERT INTO lex_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lera matni npah'a wa pa nhitwah'a noha wawannu, de Lota nte'ela Soar. ");
INSERT INTO lex_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Nhorwua dewade Orgahi Nalernu otan lali me ai la'a Sodom nora Gomora wawannu, nwatiawu lyanti. ");
INSERT INTO lex_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Dewade Nwatiri-nwaliakra leta-leta rena me rai mtatan la Yordan lowanni, me leta mniotni honona re, ra'itar wutu ora-au yawuli-yatniamni honona. ");
INSERT INTO lex_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mere Lota hawni mak kala'pa nlernohora nakillia to'orni, dewade nwaltiar lia riri kio'a ida. ");
INSERT INTO lex_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","La'pa yawyawar ma'ta pa Abraham nla'awa gen miaka wonyira ha ntutrier lia Orgahi gaini. ");
INSERT INTO lex_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Noka namkek la leta Sodom nora leta Gomora me rai mtatan la Yordan lowanni tetema, de namkek nana ai miokla ntawua tani wawannu pa nhopul la heyanna, emolmolla ai miokal mak ktutni auwru. ");
INSERT INTO lex_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Emkadella lerni la Orgahi Nweyata-nwaniawua leta-let no'a rai mtatan la Yordan lowanni, ne Nwatiri-nwaliakra leta-let maka Lota ha ndella, noma Orgahi Nhoratnana Abrahama, noka Nodgiota Lota pa nlergot la gen miaka Ha nwatiri-nwaliakar de letgarni. ");
INSERT INTO lex_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Noma lera ida ne Lota nlergot la leta Soar pa nora a'nani rora rhol lia wo'ora wurannu, yoma edonna nparan pia nhol lia Soar pede la nhol lia liena ida, nora a'nani patke'a rora. ");
INSERT INTO lex_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lera ida ne, yanulu nakot la gari: “It amni di nhamto'owa, ne a'na muanke'a hadamonan la gen di pa ratian ita, emeka noh tetema illu-yehwani samoga. ");
INSERT INTO lex_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Samounu de tsi' pa tala lokrahi turnu (anggur) la pa it amni nemnu, totpa tora tanina, ne totpa tsauru it amni duratni-waitni.” ");
INSERT INTO lex_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Mel de pa rala lokrahi turnu la amni nemnu, noka yanulu nala' ul pua nla nora amni ranina. Ne e' mana naplin niohora nor a'nani ranina. ");
INSERT INTO lex_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Repar noka yanulu nakot la gari niwra: “Worawia agor oleka it amni manin wutu. Nhi'pa mel di de tala lokrahi turnu la nemni owa'ana. Mlia'a rialam pa muora minin wutu, totpa tsauru it amni duratni-waitni.” ");
INSERT INTO lex_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Emkade wal lia mel de, pa rala lokrahi turnu la amni nemnu, na'nama gari namat pa nla nora amni ranin wutu. Ne amni naplin niohora nor a'nani ranina. ");
INSERT INTO lex_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Noka Lota a'nani rora ra'apun wa. ");
INSERT INTO lex_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Yanulu na'a'na nana muanke'a ida, ral nani pa nwawa Moab. Hadi ed mak kadurit nan makdena Moab. ");
INSERT INTO lex_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Gari mana na'a'na nana muanke'a ida noka ral nani pa nwawa Ben Ami. Hadi ed maka kadurit nan makden Amon. ");
INSERT INTO lex_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Noka Abrahama nwaran la Mamre lowanni pa nokru Negep lowanni, ne nhol lia leta Kadesy nora Syura rletni. Nhor nioka ndella leta Gerar pa emeka do'ona-dakna. ");
INSERT INTO lex_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Onnila Abrahama nakot nohora Sara, hawni de niwra: “E'a de na'ru”, reiniande Gerar rayni de, nanni Abimelek nhopan pa ra'ala Sara. ");
INSERT INTO lex_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mere mela ida Orgahi Nmai lia Abimelek, la mi'ini id ralamni, pa nakot la: “Abimelek, toto' memna hota mmuati, onnila patke' mak omua'ala de, yoma ha nmehlim olekwa.” ");
INSERT INTO lex_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Mere Abimelek edon nor ma'ta Sara ranina-radera. Niwra: “Uplerlawna! Ompuenna riy mak kakleh do'a-hala?! ");
INSERT INTO lex_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham nakota mai a'u die: Hade de de e narni. Ne patke' de nmeh'a nekpa nakot walia de: Abraham de e narni, reiniande nden nek la a ralma plele'eru pa aghi'a hadi, ne a li'mu mana edon lok ma'ta la.” ");
INSERT INTO lex_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Orgahi Nhar lirni: “Agat niohor walia, de omhi'a la hade de ralammu naplele'era, pede A'u muana Aghoratre'ru pa yana mhi' do'a-myap hial mai A'u. Hade pede A'g edonna golin doinia la pa mtie'la la inonni. ");
INSERT INTO lex_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Pede dodo'ondi meman pa mpuolan doinia riy de hawni, yoma hade de makwohorulu-ktatrulu id hade. Hade ed mak pena nsumbaini totpa ommuormiori aplahwa. Mere mhoratreria, o' edonna mpuolla-mpue'era hade, de hota omuora he'a-he'a mak klidan nohora o'a mmiati momuou.” ");
INSERT INTO lex_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Repardoin yawyawar ma'ta de Abimeleka npolg awoka hopopanni-lili'irnu re pa nwahaur nohora hihi'a-yapyap diella honona re, noka riy rahu re ramta'at wenna. ");
INSERT INTO lex_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Nhor nioka Abimelek npolga Abrahama pa nakot la niwra: “Hya'a nhiol miaka omhi'a mai am dina, ne hya'a do'a-hal mak aghi' oleka tiy o'owa, nhi'nande omrieiniana do'a-hal matmiat liawna la a ino'nu me a hai'ru? Nhiol miaka emkade de, de yana omhi'a. ");
INSERT INTO lex_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","O ralma-riormu emkameni pede mhi' nan hadena?” ");
INSERT INTO lex_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Noka Abrahama niwra: “Awuarora de ya'unni-yamta'ata Orgahi hadamonan la gen di. Toto'ola riy hota rwen a lia a ha'wu wawannu. ");
INSERT INTO lex_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Nhi'wali ne, e'a de a na'ru de, a'mu a'nani, toto'a i'nu a'nani atia'a, mere ler li'ir na'nama nla' a ha'wu. ");
INSERT INTO lex_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lerni pa Orgahi Nhopna pa aliergot la a'mu romni pa a'u la' wuewewar de, a'ukot la ha'wu: “Mtiutga ralam kalwiedmu mai a'u, itte'ela geni meni de, mukota la makden la gen die miwra: “Abraham di de a na'ru.”” ");
INSERT INTO lex_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Nhi'noka Abimelek na'ala duma, sapi, ata patke'a rora muanke'a, noka nal momuoga la Abrahama. Hawni Sara mana napolla-nawe'er owa'ana la. ");
INSERT INTO lex_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ne Abimelek niwra: “Gen di agharia tiy o'a. Mhuol lia gen mieni mak o ralammu nala.” ");
INSERT INTO lex_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Noka lirni la Sara: “Agal oleka kupna maha wawahra riwnu id la narmu totpena mak kpoi rieri-kek reri rat niohora o plolmu-mnehemu.” ");
INSERT INTO lex_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Noka Abrahama npolu-nwak la Orgahi, noma Orgahi Nhi' kalwieda Abimelek nora hawni me atni-wa'arni patke'a, pa nhi'nande hota ra'upa-ra'a'na. ");
INSERT INTO lex_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Yoma hya' maka Abimelek nhi'a la Sara nreiniande wonyira-melulu Orgahi Nhi'a pat mak kdena Abimelek re a'na genni ratniutwu (rakleh a'na). ");
INSERT INTO lex_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Emolmolla hya' maka Orgahi Nakottarg oleka la de, Orgahi Nhi' samomuou Sara, ne Nhi'a pa ");
INSERT INTO lex_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara na'apun wa pa na'a'na nana muanke'a id la Abrahama, la'a mto'oni-pe'eni lerni, la'a ler maka ha ret tiarga la nlernohora Orgahi lirni la. ");
INSERT INTO lex_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Noka Abrahama nala a'nani mak na'nama ha rmor nian de pa nwawa Isaka (nnia'eratni de namali). ");
INSERT INTO lex_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Nhor nioka Abrahama nsunta Isaka, la' lerni wo'awni, emolmolla hya' maka Orgahi Nhopan targa la. ");
INSERT INTO lex_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ne Abrahama umarnu anni rahu ida, la'a ler maka rmor dioinia a'nani Isak. ");
INSERT INTO lex_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sara niwra: “Orgahi Nhi' olek a' pua a'uhepru pa umali, nhi'nande riy mak katlin nana hadi mana honona ramali, onnila rahepru ror a'u. ");
INSERT INTO lex_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","He' ed mak wonyira-melulu nakot la Abrahama de Sara hota na'uhu keke'enku'a?! Mere plola pa a'u'a'na nan oleka muanke'a id la e'a la'a lera mto'oni-pe'eni.” ");
INSERT INTO lex_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Keke'enku' de nlawlawan lol wa pa Abrahama nhi'a ya'anlawna-yemunlawna la'a ler maka rollia uhu la Isaka. ");
INSERT INTO lex_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","La' ler maka rhi' ya'anlawna-yemunlawna de Sara namkek nana, Ismail nora Isak, rahehe'i rieri. ");
INSERT INTO lex_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sara nawenna pa nakot la Abrahama: “Mhuokar doinia hopopanmu pat de na'itar wutu a'nani, yoma ata de a'nani ta'en niana nor wutu a'nu rla'a mak kodi plolli la re'emu-tniarmu.” ");
INSERT INTO lex_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Sara lirni nhi'nande Abraham ralamni nmawal doin la onnila Ismail mana, Abraham a'nani walia. ");
INSERT INTO lex_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mere Orgahi Nal lir la Abrahama: “Yan ralammu nmawal doin la onnila at de nor a'nani. Mere la'a hya'a-hya' maka dodo'ondi Sara nakot nohora tiy o' de, mliernohora honona re, de mhuokra hare pa rla'awa. Mhuokra pa rla'awa, yoma hota Isak to' pa ed maka kadurti-kawait nana durti-waiti maka A'uno'targa tiy o'a. ");
INSERT INTO lex_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mere duratmu-waitmu mak ktaw atmu de mana, pena ghi' walia pa nla'a hairi ida, yoma Ismail mana a'namu wali.” ");
INSERT INTO lex_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Repardoin yawyawar ma'ta de Abrahama na'ala yamanna me ger la ger geni ida maka ha rhi'a la ha ulti pa nala la' Hagar, nha'ar wutu wareher della Hagar wawayanni, nhor nioka nhopan pa patke' de nor a'nani rwaran wa. Noka Hagar nwaran wa pa nala' wewewar nekpa nla'awa gen mak kerkerna, edon oliet la Bersyeba. ");
INSERT INTO lex_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","La'pa ger maka nodia de nhorwua, dewade na'ala keke'enku' de pa nkenia la ruwnu-ahla id ralamni, ");
INSERT INTO lex_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","ne namtatan la olietkota, yoma niwra: “Nee! A'g edonna tiahan nan pa umkek rer a a'nu di nmati.” La'pa patke' de namtatan reria ne nkakur doin la, nhi'nande lirni nhar miemna. ");
INSERT INTO lex_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Orgahi Natlin nana keke'enku' de nkakru, noka Orgahi hopopanni-lili'irnu Nhaun la Hagar nwatiawu lyanti, Nakot la Niwra: “Hya' ed maka ralammu nmawal nohora Hagar e? Yan mumta'ata, yoma Orgahi Natlin nan oleka a'namu nkakru la'a gen miaka ha mudud tiarga de. ");
INSERT INTO lex_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Mumata, mu'ala a'namu de, yoma hota Aghi'a pa duratni-waitni nla'a hair lawna ida.” ");
INSERT INTO lex_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Noka Orgahi Nwera Hagar matni, nhi'nande namkek nana gera ida. Noka nla nahara ger la ger geni, nhor nioka nala la a'nani de nemnu. ");
INSERT INTO lex_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Emkade pa Orgahi Nlin reri-nmat reria keke'enku' de la'pa nla'awa tuw geni-lawan geni. Nhol lia gen mak kerkerna, ne nwalia mak katu nwara'pa pa nahaka ya'ana. ");
INSERT INTO lex_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Nden nek la gen mak kerkerna la Paran lowanni, ne inni na' nana pat Mesir id pa nora rmehlima. ");
INSERT INTO lex_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lera ida ne ray Abimelek nora hopopanni Pikhol, de mak kod keki-rautu re o'tani, rmai pia rakot la Abrahama riwra: “Abraham ee! Omlia' meni-meni de Orgahi Nor o' talla. ");
INSERT INTO lex_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Hade pede mpuet la Orgahi nanni pa mliokar mai a'u, de edonna mputra-mpualk a'u, onde a durtu-waitu. Itsi' nnio'a id totpa omhi'a samomuou mai a'u, me mhi'a samomuou lia riy honona mak kdella gen di, gen miaka omdiella emolmolla do'ona-dakna, emekwalima aghi' olek samomuounu tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Noka Abrahama niwra: “Aliokra.” ");
INSERT INTO lex_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mere Abrahama naltieri niohora ralam mehrani la Abimeleka, la'a gera ida, maka Abimelek hopopanni re rwarui nian oleka. ");
INSERT INTO lex_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimeleka nwahla: “A'uplin niohora he' ed maka khi' nan hade. Nhor wuali ne o' edon mukota ma'ta mai a'u, ne la'pa ler di meman mana a'g edon utlin ma'ta.” ");
INSERT INTO lex_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Noka Abrahama na'ala duma me sapi pa nala la Abimelek totpa rrora rhi'a nnio'a ida. ");
INSERT INTO lex_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Na'nama Abrahama ntau dioinia dum a'na rara wo'itu la'a dumni re honona. ");
INSERT INTO lex_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Noka Abimelek natiana Abrahama: “Rhi'a dum a'na mandidit muaka mtiau dioini rella hya'a?” ");
INSERT INTO lex_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Nwahla: “Dum a'na mandiditu ri, Agala tiy o'a totpa nla'a kniau id la, de a'g ed mak kahi ger de.” ");
INSERT INTO lex_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Hade pede riy rweta gen diella Bersyeba (nnia'eratni de gera wo'itu onde gera rwalokra), onnila riy marororo'a ri rwalokr olek la hande. ");
INSERT INTO lex_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","La'pa rhi' oleka nnio'oni rla Bersyeba dewade Abimelek nora Pikhola rawal lia makdena Filistina re genni. ");
INSERT INTO lex_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Noka Abrahama ntamin targa au tamariska onni id la Bersyeba, ne nkola tieru-nawur nehla la Orgahi-Orha'a Uplerlawna-Mempulwatnu mak kden pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ne Abrahama nholi mahnek memna la Filistin re geni. ");
INSERT INTO lex_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Lera ida ne Orgahi Niwra Nat niohora memna Abraham pesiayni pede Nakot la Niwra: “Abraham ee!” Nwahla niwra: “Hya'a Matroma.” ");
INSERT INTO lex_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","“Mua'ala Isaka, a'namu muanke' memeh mak o ralammu nala de, pa mlia'awa Moria lowanni, ne mhi'a Isaka di pa nhi'a hoihoi-tantiani la wo'ora id wawannu, maka pena Atiutga tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Repardoin yawyawar ma'ta de Abrahama namat wa, nkenia keledaini wniowni, na'nama npolga hopopanni riy woru me Isaka. Noka naklihir targa au pa nodi wal lia hoihoi-tantiani re tniunnu-nhiaranni, noka rwaran pa rla'awa gen miaka Orgahi Nakot targa la. ");
INSERT INTO lex_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","La'pa lera wotellu de, Abrahama nran matni pa namkek nana gen die ndella olietni. ");
INSERT INTO lex_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Noka Abrahama nakot la hopopanni re rora niwra: “Miora keledai di pa mdien nek la handi. Agora a a'nu di pa amla'awa hande. Amla mtunga hoihoi-tantiani la Orgahi, nhor diemade amawal tiy miy.” ");
INSERT INTO lex_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Noka Abrahama na'ala au maka ralla rtunga hoihoi-tantiani re, pa nlapra la a'nani wawayanni wawannu, mere la' limni ralamni de Abraham nih'ru nana ai me ta'wa. Emkadella pa rrora rala' wut rewre'wa. ");
INSERT INTO lex_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Noka Isaka nakot la amni: “Ama.” Abrahama nwahla: “Hya' ame?” Noma natiana niwra: “Mai handi de ai nora au er olek la wa, mere dum a'na etla meni pa rhi'a la hoihoi-tantiani tniunu-nhiarna?” ");
INSERT INTO lex_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahama nwahla: “Ama, Orgahi pena Nalla dum a'na pa rhi'a la hoihoi-tantiani tniunu-nhiarna la Orgahi.” Emkadella pa rrora rala' rewre'wa. ");
INSERT INTO lex_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Rte'ela gen miaka Orgahi Nakot targa la. Noka Abraham nariria katri'ana la' hande, nwatiernu au me nwutga a'nani, noka nlapra la katri'ana wawannu la'a au wawannu. ");
INSERT INTO lex_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Nhor nioka Abraham netar limni pa na'ala ta'wa na'nama niwa nala rotna Isaka tiernu. ");
INSERT INTO lex_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mtatande nekpa Orgahi hopopanni Nden nek la lyanti pa Nhaun nohora Abraham, Niwra: “Hei! Abraham ee!” Abraham lirni niwra: “Hya' Uplerlawne!” ");
INSERT INTO lex_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Noka Orgahi hopopanni Nal lirni: “Yana! Yana mpuenna a'namu de, yana mhi' la'a-mhi' maiya. Dodo'ondi de Agat niohor oleka wa, de mu'unni-mumta'ata A'u, yoma ralammu edon werwerta la muala a'na memehemu de mai A'u.” ");
INSERT INTO lex_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Noka Abraham nran gaini pa namkek nana duma ltiata ida mak dudallu nha'ar tar lia ruwnu-ahla ralamni. Abrahama la na'ala dum de pa nhi'a la hoihoi-tantiani, na nhernia a'nani. ");
INSERT INTO lex_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Hade pede Abrahama nhi' gen die pa nwawa: “Orgahi Nwahi' targa olek wa.” Onnila hade pede la'pa nmai lia dodo'ondi mana riy riwra: “La'a wo'or hananni mak Orgahi Nhopan pa Abraham nala hoihoi-tantiani de, hota Uplerlawna Nwahi' targa hya' maka rakleha.” ");
INSERT INTO lex_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","La'pa re'eni wornu wa, pa Orgahi hopopanni Ndella lyanti pa Nhaun la Abrahama, ");
INSERT INTO lex_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Niwra: “Aliokar de Awuet la A na'nu, de yoma onnila omliernohora A li'ru, ne ralammu edon werwerta la muala a'na memehemu de mai A'u, ");
INSERT INTO lex_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","pa hota Agala ra'u-pa'lu tiy o' pa harahu, ne ghi'a duratmu-waitmu re harahu memna emolmolla wtion no'a lyanti me emeka en nio'a eni wawannu, ne duratmu-waitmu hota rodi plolli-rtaryatnu la arwalli re letni-ruhunni. ");
INSERT INTO lex_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Onnila o duratmu-waitmu na'nama rimormiori nohkeran di rlernana yara'a-yapalu. Hari honona hota Aghi'a onnila omutlina-mutailla li'ru-tu'nu.” ");
INSERT INTO lex_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Nhor nioka Abrahama nawal lia hopopanni re rora, noka rewre'wa pa rawal lia Bersyeba. Noma Abrahama nhol lia hande wa. ");
INSERT INTO lex_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Lera ida ne Abrahama nlernana kota-de'eta riwra: “Yermu Milka mana na'a'na nan walia a'na muanke'a la hyalmu Nahora. ");
INSERT INTO lex_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","23","De Nahora a'nani yanulu de nwawa Usa, mak klernohora Usa de, Busa, mak klernohora Busa, Kemuel, mak klernohora Kemuel de, Kesed, mak klernohora Kesed, Haso, mak klernohora Haso, Pildasy, mak klernohora Pildasy, Yidlaf, mak klernohora Yidlaf, Betuel, gari hoho'a hade. Hari honon rde Milka na'a'na nan la Nahora. Ne Kemuel nlawlawan lola pa hota nhi' am la makdena Aram.” Noka Betuel na'a'na Ribka. ");
INSERT INTO lex_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ne Nahora hawa liahunu Reuma na'a'na nan wali a'na muanke'a re doma, yanulu nwawa Tebah, mak klernohora Tebah, Gaham, mak klernohora Gaham, Tahasy, mak klernohora Tahasy, Maakha. ");
INSERT INTO lex_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara nmormior niana anni rahu ida terampworu wehrani wo'itu. ");
INSERT INTO lex_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Noka Sara nmat lia Kiryat Arba, maka dodo'ondi de nwawa Hebrona, la'a noha Kana'ana. Noka Abrahama nko'a-nkakru. ");
INSERT INTO lex_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Nhor nioka Abrahama naprir pia nhoitio'or la hawni mak kmat die, noka nakot la ina-ama la Heta duratni-waitni niwra: ");
INSERT INTO lex_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“A' di de do'ona-dakn a'u, ne la'a miy hononmi di, a' di de mak klaunu id a'u (pede ge'nu-tie'nu hadamonna pa atiamnia ha'wu). Mtiulan pa mi'olu lienmi mai let di mai a'u, totpa agodia ha'wu pa tiamnia la.” ");
INSERT INTO lex_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Noka riy id la ina-ama re nwahla Abrahama niwra: ");
INSERT INTO lex_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Ama, mutlina! Amat niohora o' di de riy lawna ida la Uplerlawna gaini ralamni pa la mtiamnia hapmu della a hoi miamni-ketar mamni maka mpualir niana. Riy id mai am di ta'en niana nwayotil pa rala ketarni tiy o' pa mtiamnia hapmu de.” ");
INSERT INTO lex_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Nhi'noka Abrahama nwaltiora-nwaltieman la ina-ama re, ");
INSERT INTO lex_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","ne nakot la re: “La'pa miy mpiayow pa agodia ha'wu pa atiamnia la hande, de mrieiniana-mia'nana a wakwa'ku di pa mpiak lilili-maumuau lia Efron, Sohar a'nani, ");
INSERT INTO lex_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","totpa nala lienni no'a Makpela, mak kdella nhyi'ini onni de. Samounu de nal neka pa a'uwelia pa aghi'a la a lu'wu-a'nu ketarni la'a miy letgarmi, ne welli de apuair tetema.” ");
INSERT INTO lex_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","La' ler de de Efrona e namtatna la Heta duratni-waitni ina-ama re letgarni. Noka Efrona de nwahla Abrahama, de ina-ama mak kawok la leta puohrani gaini re ratlin reria. ");
INSERT INTO lex_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Efron niwra: “Edonna ama, mutlin mai a'u. Nhyi' de agala tiy o'a, me lien de mana agal walia tiy o'a. Ne ina-ama rlin reri-rmat reri mak a'ukot di pede hota mtiamnia hapmu la gen die.” ");
INSERT INTO lex_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Noka Abrahama nwaltiora-nwaltieman la ina-ama re, ");
INSERT INTO lex_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ne nakot la Efron, de honona e ratlin reria, niwra: “Mitlin rerio! La'pa ompuayow de, apuairia nhyi'imu de welli. Mrieiniana hade mai a'u, totpena atiamni ha'wu la hande.” ");
INSERT INTO lex_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efrona nwahla Abrahama: ");
INSERT INTO lex_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ame, yan muwenna me, mutlin pa ukota hadi. Plol toto'a de nohanna-taniarta di welli werta, de welli maha wawahra rahu wogata. Mere it mamaini pede emkadella pa mpuair niek wa. Mpuairia pa mtiamin neka hapmu la hande.” ");
INSERT INTO lex_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Noka Abrahama nreiniana Efrona wakwakni, noma npairia maha wawahra la Efrona, liawanni emekwali maka ha nakot oleka re. Ina-ama mana ratlin reria de, maha wawahra rahu wogata, emolmolla mak kwadakna nhi'inde ret tiar lia. ");
INSERT INTO lex_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Emkade nek la Efron nhyi'ini, nora lienni, na'itar wutu or-au ona mak kdella nhyi' di ralamni, lowan di honona mak kdella Makpela, la'a Mamre walli tipru ");
INSERT INTO lex_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","rala la Abrahama emolmolla tani ya'olu-yala'a, la'a Heta duratni-waitni gaini ralamni, de ina-ama mak kmai lia puohra leta gaini. ");
INSERT INTO lex_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nhor nioka Abrahama ntamnia hawni la'a liena mak kdella nhi'a Makpela, la'a Mamre walli tipru. Mamre de rwet walia la leta Hebron, ne etla Noha Kana'ana. ");
INSERT INTO lex_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Emkadella la'a Heta duratni-waitni re rala la' Abraham nhyi'a nora lien mak kdella hande pa nhi'a la hoini-kietar wamueheni. ");
INSERT INTO lex_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Orgahi-Orha'a Nara'a-napalga Abraham la'a hya'a-hya' to'owa, ne Abraham mana nhamto' wal wia. ");
INSERT INTO lex_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Noka lera ida ne Abrahama nakot la hopopanni mak khi' ulu-o'ta la re'eni-tniarnu honona niwra: “Samounu de mkienia limmu la a lennu onni (emeka nhi'inde itsi' pa twalokra), ");
INSERT INTO lex_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","totpa mliokar la Orgahi-Orha'a, Uplerlawan maka gahani lyanit marna-nohkeran di, de o' edon mua'ala patke'a Kana'ana mniotni mak adiella letgarni riy id pa mhi'a la a'nu hawni. ");
INSERT INTO lex_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mere omlia' meman la a le'tu-ruhunu, me lu'wu-a'nu, totpa mua'ala patke'a id la a'nu Isaka. ");
INSERT INTO lex_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Noma hopopanni de nakot la: “Matroma, yanhi'pa patke' de nahmena nlernohor a pua mai let di pa nhi'de agodia a'namu di pa uwal lia letmu-ruhunmu mak ha mliergot la?” ");
INSERT INTO lex_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Mere Abrahama nakot la: “Yana! Yana muodia keke'en de pa muwal lia hande. ");
INSERT INTO lex_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Uplerlawna mak kodi plolli la lyanti, mak kpolg a lia a'mu romni me lu'wu-a'nu letni, maka Nlokar pa Nala nnio'oni mai a'u emkadi: “Pena Agal noh dilla duratmu-waitmu.” Uplerlawan di hota ed maka khopna hopopanni-li'irnu nala' ul lia o'a totpa mua' nana patke'a id la la' hande pa mumehlima la a'nu. ");
INSERT INTO lex_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Mere la'pa patke' de nahmen nor o' talla de o kwarmu la'a liokarmu mai a'u de nhorwua, hornama yan memmemna muodi a'nu pa mlia' hande.” ");
INSERT INTO lex_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Noka hopopan de nlapar limni la matromni Abrahama lenanni onni na'nama nlokra-nhaut niohora hade. ");
INSERT INTO lex_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nhor nioka hopopan de na'ala matromni ontani termida, ne rla'awa pa rodia yohya'a samomuou harahu maka matromni nala. Emkadella nwaran pa nokru Aram-Mesopotamia, la'a Nahora letni. ");
INSERT INTO lex_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","La hande, dewade nhi' pa ontani re rrena la leta to'orni, la'a gera id onni, la'a lera lia'ani, la'pa patke'a re rlergot pa rla rtip gera. ");
INSERT INTO lex_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Noma hopopan de nsumbaini niwra: “Orgahiya, Uplerlawnu ne! O' ed mak khi' Uplerlawna la matro'mu Abrahama, Mhi' totpena ler di de aliernana a maimia'yu di onni-matni. Mtiutu ralam kalwiedmu la matro'mu Abrahama. ");
INSERT INTO lex_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","La' handi de a'g e tiutrier lia gera matni onni, ne hararar mak kdella let di rlergot pa rma rtip gera. ");
INSERT INTO lex_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Mhi' pa nla nlol emkadi de, hararar meni mak a'ukot la giwra: “Mpuatir kuku' nana kekanmu pa totpa agemun la”, noma nwahla: “Muemun la, ne ontamu re mana agalla remun wali,” hade ed maka Mtiutmuata-mkiewra' nana pa rala la hopopanmu Isaka. La'pa emkade de agat niohora de Omtiutg oleka ralam kalwiedmu la matro'mu de.” ");
INSERT INTO lex_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","La'pa edon nahor mua'ta lirni dewade Ribka nmai de nakwar nana kekanni. Noka Ribka nla ntip ger pa nahar la kekanni, na'nama nafia'at pa nmai owa'ana. Mere Ribka di, Betuela a'nani. Betuel di, Milka nor Nahor a'nani muanke'a, ne Nahor de Abrahama hyalli. Patke' hararar de samounu ne, hararara molanni. ");
INSERT INTO lex_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Nmai nioka hopopanni plet pa la nwatroma pa nakot la: “Ine, mtiulan pa muala ger mak kden la kekan de oke' pa agemnia.” ");
INSERT INTO lex_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Nwahla: “Muemun la, tuna.” Noma pleta-plet pa nalernia kekanni della limni wawannu na'nama nala nemnia. ");
INSERT INTO lex_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","La'pa nala hopopan de nemun pa nhorwua dewade nakot la: “Nhi'pa atip wuali ger la ontamu re remnia totpa honona re tiernu pe'era.” ");
INSERT INTO lex_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nhor nioka pleta-plet pa nhuria ger mak kdella kekanni de la'a yemun geni, noka nawlari owa'an pa nokru ger de pa ntip gera, ntip lia hopopan de ontani honona. ");
INSERT INTO lex_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ne hopopan de namolmuolga pa nlina-nmata patke' de, totpa namkeka nana de Orgahi Nhi'a yala'ani pa na'eni me edonna. ");
INSERT INTO lex_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","La'pa onta re remun pa tiernu rpe'er wa dewade hopopan de na'ala krap muaha ida maka rnairi la'a irannu, de weratni syikal id rehennu, me lel miaha tnialli id de weratni syikal termida, ");
INSERT INTO lex_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","noma natiana: “Ina, he' a'nani o'a? La' ammu romni de geni erla pa amanin ami?” ");
INSERT INTO lex_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Noka nwahla niwra: “Nara, a'mu de Betuela, Milka nora Nahora a'nani. ");
INSERT INTO lex_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Wewan kerna harahu etla am die la' pa onta ra'ana me ranin la wawannu. Geni pa mininmi mana erla.” ");
INSERT INTO lex_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Noka hopopan de nwaltiora-nwaltieman me na'uli-nawedia Orgahi-Orha'a, ");
INSERT INTO lex_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","niwra: “Matroma! U'uli-uwedi O'a, mak khi' Uplerlawna la matro'mu Abrahama, O' maka Mual owa'an la nhol kalwiedwedni la'a matro'mu de, ne mak kodi olek a lia talan mak kokru matro'mu inni-narni amni-hyalli romni di.” ");
INSERT INTO lex_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nhor nioka hararar de nawlar pia nla nwahaur nohora hopopan della inni romni mniotni. ");
INSERT INTO lex_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ribka narni ida nwawa Labana. La'pa Laban namkek nana krapu la narni irannu me leli re la'a limni, ne natlin nana narni nwahaur nohora hya' maka hopopan de nakot la, noma Laban nawlari got pa nla nwatroma hopopan de, la'a gera wawannu. La'pa nlernana hopopan de e ntutrier mia'ta la onta-ontani re onni, la'a gera onni, ");
INSERT INTO lex_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","noma niwra: “Mmuai hyalia, o' maka Orgahi Nala ra'ani-pallu, nihya'pa omtiutrier lia tio'ora? Awuahi' targ oleka roma tiy o'owa, me geni la onta-ontamu ri.” ");
INSERT INTO lex_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hopopan de nla'awa Laban romni nayanni. Ralernia onta-ontani re wniowni me hya' maka rodia, ne rala wewan kerna rwa'ana onta-onta rena me rala gera pa hopopan de nora riy mak kor rewre'wa talla re ralla rohma doini lakni kdeheni. ");
INSERT INTO lex_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Mere la'pa rhoiya yamanna la gaini ralamni, dewade hopopan de niwra: “Pap miy re, a'g edonna ukot ma'ta a yala'u onni, de a'g edon u'un ma'ta.” Laban nwahla: “Demade mukota hyalia.” ");
INSERT INTO lex_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Noka niwra: “A' di, de Abrahama hopopanni a'u. ");
INSERT INTO lex_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Orgahi Nala ra'ani-pallu la matro'mu de pa nre'a-ntaru. Nara'a-napalga de, Nala nhiuri-wnia'ana, leli-maha, ata-wa'ara patke'a rora muanke'a. ");
INSERT INTO lex_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ne Sara, matro'mu de hawni, la'pa nhape'ewa na'nama na'a'na nana muanke'a ida. Matro'mu de natemna re'eni-tniarnu re honona la a'nani de limni ralamni. ");
INSERT INTO lex_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Matro'mu de na' olek la a liokru: “Yana mua'ala patke'a id la a'nu hawni la'a patke'a Kana'ana, maka aghol lia letni di, ");
INSERT INTO lex_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","mere mlia'awa a'mu romni me lu'wu-a'nu pa mua'ala patke'a id pa mumehlima la a'nu.” ");
INSERT INTO lex_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Mere awuahla giwra: “Yanhi'pa patke' de nahmen nor a' tialla pa ammai la handi?” ");
INSERT INTO lex_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Mere lirni mai a'u die: “Orgahi maka amuor lia gaini ralamni, pena Nhopna hopopanni-lili'irnu pa ror o' talla, ne pena rhi'a yalolmu-yala'amu pa nawulu-nawe'ela, nhi'nande pena omua' nana patke'a id la a'nu hawni la'a lu'wu-a'nu me a'mu romni ralamni. ");
INSERT INTO lex_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Mere la'pa omlia'awa la lu'wu-a'nu de ne mak kdella a'mu romni rahmena rala patke'a id tiy o'a, de omuaul doinia liokarmu de mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Pede alia'awa. Ler di na'nama amuai pa tie' tar lia ger di matni, noka asiumbaini giwra: “Orgahi-Orha'a, maka khi' Uplerlawna la matro'mu Abrahama, Mpuayow nohor de Muala wulu-we'el la yalola-yala' mak a'ulohor nan di. ");
INSERT INTO lex_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mai handi pa atiutrier lia ger di matni onni. Wuakwak de la nlol emkadi, de hararara ida nlergot pa nma ntip gera, ne a'ukot la giwra: “Mtiulan pa muala ger no' kekanmu de oke' pa agemnu”, ");
INSERT INTO lex_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ne nwahla niwra: “Muemun la, ne pena atip wal ger la onta-ontamu remnia, emkade pa O'a Mtiutga patke'a id pa nla'a matro'mu a'nani hawni.” ");
INSERT INTO lex_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","A li'ru la' ralmu edonna nhor mua'ta, dewade Ribka nmai pia nakwar nana kekanni, noma nla ntip gera. Li'ru la: “Mtiulan pa mual pa agemnu.” ");
INSERT INTO lex_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Pleta-plet pa nalernu kekanni della wawayanni, noma lirni: “Muemun la, ne onta-ontamu re mana pena agalla remun wali.” Noka agemnu, me onta-onta re mana nalla remun wali. ");
INSERT INTO lex_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Nhor nioka a'utiana giwra: “He' a'nani o'a?” Wniahlani: “A'mu Betuel, Nahor a'nani, mak Milka na'a'na nana.” Noma akenia krapu la irannu me leli re la limni. ");
INSERT INTO lex_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Nhor nioka aguh idma-riama lia'ar pa u'uli-uwedia Orgahi-Orha'a mak khi' Uplerlawna la matro'mu Abrahama, mak kodi a lia talla plollola pa ga'ala matro'mu hyalli upni pat di pa gala la a'nani. ");
INSERT INTO lex_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Pede dodo'ondi, la'pa ralam kalwiedmi me wnia'ama-wniahyalmi la matro'mu de pa muala patke' di, de mikot memna mai a'u. Ne la'pa edonan mana mikot memna mai a'u, totpa hota awuaror nohora hya'a maka aghi' dina.” ");
INSERT INTO lex_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Noka Laban nora Betuel rwahla: “Hari honona de nwatiawua Orgahi-Orha'a. Ami edon mak kot nohora plolli-halli. ");
INSERT INTO lex_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Mumkek la, hya' mak etla gaimu ralamni de, muodia pa mlia'awa, totpa nhi' haw la matrommu a'nani, emolmolan maka Orgahi-Orha'a Nakot targ oleka.” ");
INSERT INTO lex_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","La'pa Abrahama hopopanni de natlin nana hare lirni-tunnu, dewade nuh' idma-nrama lia'ar la Orgahi-Orha'a. ");
INSERT INTO lex_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Nhi'noka hopopan de nalgota leli-maha, me naniairia noma nal hare honona la Ribka. Nal walia limtutu-limho'a mak welli werta la Ribka narni me inni. ");
INSERT INTO lex_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nakot momuoga yala'ani onni pa nhorwua dewade, nor talanwalli re ra'ana-remnu, noka ranin la hande wa. Repardoin yawyawra pa ramatgot wa dewade hopopan de niwra: “Miolin doin a lia pa uwal lia matro'mu.” ");
INSERT INTO lex_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Mere Ribka narni me inni riwra: “Mualtarga hararar di pa amora mparin niana lera termid owa'ana, nhor niampena muora mlia'awa.” ");
INSERT INTO lex_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Mere hopopan de nwahla re: “Yana mineti a'u, yoma Orgahi Nhi' oleka yalo'lu-yala'u pa nawulu-nawe'ela. Miolli a lia, totpa a'uwal lia matro'mu.” ");
INSERT INTO lex_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ribka narni me inni riwra: “Samounu de tpolu pleinia hararar de pa tatian nohora ralma-riorni.” ");
INSERT INTO lex_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Noka rpol Ribka pa rakot la: “Ompuayow pa muora riy di talan pa mlia'awa?” Nwahla niwra: “Wuayowa.” ");
INSERT INTO lex_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Noma rollia Ribka nora in mak katiak e'a, me Abrahama hopopanni de nora talanwalli rpa rla'awa. ");
INSERT INTO lex_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Noma rwaka pa Orgahi-Orha'a Nara'a-napalga Ribka. Lirni rla: “Nara, ampakwak de ompueha-mliawan pa riwnu-riwnu, ne mpakwak de duratmu-waitmu rodi plolli la arwalli re letni-ruhunni.” ");
INSERT INTO lex_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Noma Ribka nora hopopanni-lili'irnu patke'a re rwahi'a-rwayod wia, noka rha'at la ontani re pa rlernohora hopopan de. Emkadella hopopan de nodia Ribka pa rawal wia. ");
INSERT INTO lex_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Lera ida ne Isaka nmai olek pa ntawua gera nwawa Lahai-Roi. Yoma ndella Negep lowanni. ");
INSERT INTO lex_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lera ida de lera nhi'pa nheria wa noma Isaka nlergot pa nalala'a la wewna wawannu pa nwarora-nwalai. Nwatul gaini pa namkek de onta-onta e rmai nieka. ");
INSERT INTO lex_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribka mana nwatul gaini pa la'pa namkek nana Isak wa, dewade nerun la onta wawannu. ");
INSERT INTO lex_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Nakot la hopopan de: “He' ed muanke' mak kala'a la wewna wawannu pa kharan rer it dina?” Hopopan de nwahla niwra: “Matro'mu eda de.” Noka Ribka nahew gaini (emolmolan neka patke'a mak kekeneka rmehlima nhi'inde rhi'a). ");
INSERT INTO lex_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nhor nioka hopopan de nwahaur nohora honona maka nhi' nana oleka la Isaka. ");
INSERT INTO lex_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Noka Isaka nodia Ribka pa rla'awa inni hoiwialli, ne nora rmehlima. Isaka ralamni nal memna, ne ralamni mana namtierun wa, nhoratdoini inni matmiatni. ");
INSERT INTO lex_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Lera ida ne Abrahama nmehlima owa'ana patke'a ida de nanni Ketura. ");
INSERT INTO lex_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Patke' de a'na yanulu de Simran, mak klernohora Simran de, Yoksan, mak klernohora Yoksan, Medan, mak klernohora Medan de, Midian, mak klernohora Midian, Isybak, mak klernohora Isybak de, Suah. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Noka Ketura a'nani Yoksana nlawlawan lol pa na'a'na nana a'na yanulu rala pa nwawa Syeba, mak klernohora Syeba de, Dedan. Dedan di duratni-waitni de makden Asyura, makden Letusyi, ne makden Leuma. ");
INSERT INTO lex_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ketura a'nani nwawa Midian de, a'nani yanulu de Efa, mak klernohora Efa, de Efer, mak klernohora Efer, Henok, mak klernohora Henok, Abida, mak klernohora Abida, Elda'a. Gari hoho'a hade. Hare honona rde Abrahama nora Ketura duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Mere Abrahama nala re'eni-tniarnu honona rla Isaka. ");
INSERT INTO lex_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mere Abrahama nmormior mia'ta de nal to'a limtutnu-limho'oni la Ketura a'nani me a'nani maka Abraham nlernana la hawa liahunu, ne nhopna rhoitio'or la a'nani Isaka, ne rwaran pa rla'awa la' lowan la walli tipru. ");
INSERT INTO lex_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahama mormiorni nla' nana anni rahu ida terampwo'itu wehrani wolima. ");
INSERT INTO lex_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Noka nmat wia. Nmat lia, mto'oni-pe'eni, la'a mormiorni de ralamni penpuenu-tetema, noma rawok wutga la upni-tgarni. ");
INSERT INTO lex_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Noka a'nani re, Ismaila nora Isaka rkenia la liena Makpela, la'a Sohar a'nani Efron nhyi'ini, nhyi' mak kdella Mamre walli tipru. ");
INSERT INTO lex_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Nhyi' di, ed maka Abrahama nawel niana la Efron, makden Heta. La' hande de rtamin targa Abrahama nora hawni Sar la. ");
INSERT INTO lex_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","La'pa Abrahama nmat wia dewade Uplerlawna Nara'a-napalga Isaka, ne Isaka nhol lia gera mak kwawa Ber Lahai-Roi. ");
INSERT INTO lex_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hadi de Ismaila, Abrahama a'nani, mak Hagara pat Mesira, Sara atni na'a'na nan de, duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Hari de Ismaila a'nani nanni. Ismaila a'nani yanulu de, Nebayot, mak klernohora Nebayot, de Kedara, mak klernohora Kedara, Adbeel, mak klernohora Adbeel de, Mibsama, ");
INSERT INTO lex_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","mak klernohora Mibsama, Misyma, mak klernohora Misyma, Duma, mak klernohora Duma, Masa, ");
INSERT INTO lex_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","mak klernohora Masa, de Hadada, mak klernohora Hadada, Tema, mak klernohora Tema, Yetura, mak klernohora Yetura, Nafisyi, mak klernohora Nafisyi, Kedma. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Hare de rlawan pa rwal lia ray termida wehrani woru. Rima-rima rora duratni-waitni, letni-ruhunni, likatni-larni. ");
INSERT INTO lex_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaila mormiorni de anni rahu ida terampwotelu wehrani wo'itu. Nhor nioka nmat wia. Nmat wia noka rawok wutga la upni-tgarni. ");
INSERT INTO lex_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismaila duratni-waitni ri rhol lia nohanna-taniarta nden nek la leta Hawila pa nodi liarni la Syura, mak kdella Mesir walli tipru pa nokru Asyur lowanni. Mere nhi'inde rora inni-amni amni-hyalli rawenna. ");
INSERT INTO lex_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hadi de Abrahama a'nani Isaka duratni-waitni tuini-wedni. ");
INSERT INTO lex_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaka aninni terampwogata, lerni la maka nor Ribka rmehlima. Ribka di narni nwawa Labana, ne amni nwawa Betuel. Betuel di, makdena Arama nwatiawua Padan Aram. ");
INSERT INTO lex_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaka nsumbain la Orgahi, yoma hawni de nakleha a'na. Orgahi Nreiniana polpuollu-wakwakni, nhi'nande hawni Ribka na'apun wa. ");
INSERT INTO lex_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Mere apannu mniotni rwayotli pede niwra: “A su'ku tia'ala pa a apnu ralamni emkadi. Nihya'pa emkadina?” Noka nwaka rorora-laliai la Orgahi niwra: “Matromlawnu ne! Nihya'pa apnu mniotni rwayotli?” ");
INSERT INTO lex_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Orgahi lirni la: “Papay worga erla apanmu de ralamni, ne hota gari nadurit pa narehia yanulu hairni, ne a'na yanulu hota natlin la a'na gari.” ");
INSERT INTO lex_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","La'pa lerni ntu'tu pa nmor wia, de ntor doinia a'nani de radio'a. ");
INSERT INTO lex_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Rtor doinia yanulu de, wullu mermera emeka rala rain wulwulu la inonni tetema, nhi'nande rala pa nwawa Esau (nnia'eratni de, wulwulga). ");
INSERT INTO lex_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Noka garni nlernohora, limni nte'la rer lia yanulu tikalli, nhi'nande rweta la Yakopa (nnia'eratni de, tikalli. Ha nnia'eratni dom de, pudi-akla.) La'a ler maka ha ra'a'na rde Isak umarnu anni terampwonema. ");
INSERT INTO lex_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Noma keke'enku'a rora rlawlawan lol wa. Yanulu nhi'a mak khiti ahu-kler ahla, riy maka heparnu de ndella wo'ora-kawru, mere gari de riy id maka muli-mtie'ela, ne heparnu de ndella hoiwiali nayanni. ");
INSERT INTO lex_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaka ralamni nala yanulu, yoma heparnu de na'ana hiti ahu-lier ahla eni, mere Ribka de ralamni nala gari. ");
INSERT INTO lex_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lera ida ne gari npipara wora mermera, noka yanulu nwatiawu wo'ora pa nmai die, de naplar memna. ");
INSERT INTO lex_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Yanulu nakot la gari: “Ple'etu, muala pipar mermermu de oke' pa a'u'una, yoma a'uplar memna.” Emkade pede nanni de rweta la Edom (nnia'eratni de, mermera.) ");
INSERT INTO lex_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Mere gari nakot la niwra: “Ompuayow de, it amni nmat wia de, omuala yodmu mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Yanulu niwra: “Yowa, pena agala. Yoma a'uplar memna, ne hota amuat die, a yo'du re rodia hya' unut mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Gari niwra: “Mliokra plein mai a'u puena!” Noka yanulu nlokar la Orgahi totpa gari na'ala yodni. ");
INSERT INTO lex_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Noka gari nala roti me wora della yanulu, nhor nioka na'ana-nemun pa nhorwua dewade naprir pia nla'awa. Emkadella, yanulu edon nwarei-nwadan nohora yodni de. ");
INSERT INTO lex_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Noma rehka-lara nwewar la gen de. Mere hadi de rehka-lara Abraham lerni atia'a. Rehka-lar di nhi'nande Isaka nla'awa Gerar makden Filistin rayni geni, la'a Abimelek Filistin rayni. ");
INSERT INTO lex_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Noma Orgahi Ntutga rupni la, pa Nakot la: “Isaka! Yana mlia'awa Mesira, mere mhuol lia gen meni maka pena A'ukota tiy o'a. ");
INSERT INTO lex_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mdiella gen di emeka do'ona-dakna, pena Ago'ru talla, ne A'ura'a-upa'lu, yoma Agala gen di tiy o'a me duratmu-waitmu, ne hota A'ugeni a liokru maka Aget tiarga la ammu Abrahama. ");
INSERT INTO lex_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Pena Aghi'a duratmu-waitmu pa emolmolla wtion mak kdena lyanti, totpa Agala noha-rai di tetema la duratmu-waitmu, ne onnila duratmu-waitmu, nhi'nande rimormior nohkeran di rlernana ra'a-palu. ");
INSERT INTO lex_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Hari honona hota ntutu-nte'ewa onnila Abrahama natlina-natailla A li'ru, ne nlernohora nhiopnu-li'iru, nnie'eru-tniatru me deulu-tatru tetema.” ");
INSERT INTO lex_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Pede Isaka nhol lia Gerar. ");
INSERT INTO lex_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Noka makden hande ramkek de hawni samoga nhi'nande ratian nohora la Isaka, noma nakot nohora hawni niwra hade de e narni, yoma namta'ata nakota niwra hade de e hawni, yoma wniarorni: “Yanhi'pa let di mniotni rwenan nan a'u, onnila Ribka tototni-rerieini, yoma patke' de irnu hlioi-mat lawruru.” ");
INSERT INTO lex_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ndella hande pa lardoinia wenu-wolla, me'eta-anni dom la, noma lera ida ne Filistin rayni Abimeleka namkek lola folla de Isak nora hawni Ribka rwamuri-rwale'era! ");
INSERT INTO lex_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Noka Abimelek npolga Isaka pa nakot la: “Plollolli de hade de hapmu hade, mere mukot oleka miwra: Hade de o narmu.” Isaka nwahla niwra: “A'ukot emkade yoma wniaro'ru: Yanhi'pa natota-nariei pia nhi'nande rwen a'u.” ");
INSERT INTO lex_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Mere Abimelek niwra: “Hya'a nhiol miaka omhi' nan oleka mai am dina? Emkameni la'pa riy id la makden gen di nora hapmu ranin wutu, nhi'nande pena ha natota-nariei pia omuodi am lia do'a-hala ralamni.” ");
INSERT INTO lex_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Noma Abimelek nala titni-kaini la limni-rorni honona, niwra: “He' maka nhi' yatyat la riy di nor hawni de hota rwenan toto'a.” ");
INSERT INTO lex_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Noka Isaka nawuli-natniamin la lowna-ahla no' hande. La'a anin de neka, pa nlernana wullu-we'elli rahu id ralamni, yoma Orgahi Nala ra'ani-pallu la. ");
INSERT INTO lex_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Pare'a-patniarga, ne la'pa re'eni-tniarnu nlawlawan lol to'owa pa ler la pripanni-fa'anni. ");
INSERT INTO lex_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ntarga nhiuri-wnia'ana, me hopopanni-lili'irnu liawanni, nreiniande makdena Filistin re ra'andoin gahani rla. ");
INSERT INTO lex_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Hade pede gera honona re maka amni hopopanni-lili'irnu rah niana la amni Abrahama lerni, makden Filistin re rnakduran momuou ral tani. ");
INSERT INTO lex_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Noma Abimelek nakot la Isaka: “Mpuaran pa mlia'awa meni-meni pa mtio'or doini am lia, yoma omurehi olek la re'emu-tniarmu. O limmu-rormu nek de harahu wali.” ");
INSERT INTO lex_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Pede Isaka nwaran la hande wa pa nhor nioka nkeni krahanni la Gerar mtatanni, noka nhol lia hande wa. ");
INSERT INTO lex_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Nhi'noka Isaka nahi owa'ana ger maka rah niana la amni Abrahama lerni maka Filistina mniotni rnakdurn oleka la lera Abrahama nmat wia de, rnairi owa'ana gera re nanni, rlernohora nan maka amni nala re. ");
INSERT INTO lex_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","La'pa Isaka hopopanni-lili'irnu rahai lia lowan de, de rlernana gera matni nopli-nopli. ");
INSERT INTO lex_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Noma Gerar mniotni mak kodi pipi-duma re rora Isaka limni-rorni mak kod pipi-duma re rawo'ora, riwra: “Ger di de a han mamni.” Noka Isaka nweta ger della Esek (nnia'eratni de, rawo'or nohora), yoma hare ror e rawo'or la hande. ");
INSERT INTO lex_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nhi'noka rahi owa'ana gera id owa'ana, mere rahankeran pa rawo'or wali. Noma Isaka nweta ger della Sitna (nnia'eratni de, rahankeran reri). ");
INSERT INTO lex_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Rwaran la hande noka rahi ger id owa'ana, mere la'a ger di wawannu de edonna rawo'ora. Nala ger di pa nwawa Rehobot (nnia'eratni de, geni hgal liawna), ne niwra: “Dodo'ondi Orgahi Nal oleka geni ghal liawan di mai it pa totpa ta'upa-ta'a'na la gen di.” ");
INSERT INTO lex_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ndella hande pa nla'awa Bersyeba. ");
INSERT INTO lex_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nmel wa noma Orgahi Ntutga rupni la Isaka, me niwra: “Isaka! A' di de Uplerlawna la ammu Abrahama. Yan mumta'ata, yoma Agor o' talla. Pena Agala ra'u-pa'lu tio'a, upe'era-ulawna duratmu-waitmu onnila Abrahama mak klernohora A'u.” ");
INSERT INTO lex_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Nhor nioka Isaka nariria katri'ana id la hande, ne na'uli-nawedia Uplerlawna-Mempulwatnu, nkeni krahanni la hande, ne hopopanni-lili'irnu re mana rahi ger la hande. ");
INSERT INTO lex_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Lera ida ne Abimeleka nwatiawua Gerar pa nma nwatroma, nor rewre'wa kniarwialli Ahusat (mak kano'a-ka'atg e'a), me nor walia mak kodi keki-rautu o'tani Pikhol. ");
INSERT INTO lex_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Mere Isaka nakot la re: “Nihya'pa mia mpiatrom a'u? La ler mak itto'or la de, ralammi ramehra mai a'u pa mhiopan pa aliergot la genmi de.” ");
INSERT INTO lex_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Rwahla riwra: “Ameh'a mat niohora de Orgahi Nor o' talla pede amiwra: Samounu de itla' wutu liokra ida pa itsi' nnio'a ida totpa it idma nhi' samomuou ida. ");
INSERT INTO lex_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Lerni pa mdiella Gerar de ami edon mhi' yatyatni la miy mere amhi' pa mdiella mtiertierannu la'pa ntutu-nte' meman la ler maka ampak pa mliergot la a gen mamni, pede mpak pa miy mhi' emkade wali mai ami. Yoma amatga de Uplerlawna Nal oleka ra'ani-pallu tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Nhor nioka Isaka nhi'a ya'anlawna-yemunlawna re, noma ra'ana me remun wa. ");
INSERT INTO lex_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Repardoin yawyawar ma'ta de rhi'a liokar wutu-nhiaut wutu. Nhor nioka Isaka nolin doinia rpa rla'awa, ne Isak mana nwarin liola kalwiedni-paitiotni mtiertierannu. ");
INSERT INTO lex_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ler de, de Isaka hopopanni-lili'irnu rma rwe'er nohora ger maka ha rahi oleka wa, pa rakot la riwra: “Amlernan olek gera wa.” ");
INSERT INTO lex_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Noma Isak nweta ger della Syeba (nnia'eratni de, liokra). Nhi'nande let de nanni Bersyeba, nodia pa dodo'ondi. ");
INSERT INTO lex_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","La'pa Esau umarnu anni terampwogat wa dewade na'ala Yudita, Beeri makden Heta a'nani, me Basmata, Elon makden Heta a'nani pa nhi'a la hawni rora. ");
INSERT INTO lex_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Patke'a rora rodia ihru mehra-ralam pahna la Isak nora Ribka. ");
INSERT INTO lex_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","La'pa Isaka nhamto'owa pa matni npon wa, dewade npolga a'nani yanulu Esau pa nakot la: “Ama!” Esau nwahla niwra: “Ee, papa!” ");
INSERT INTO lex_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaka naltier lia niwra: “Omuat niohora de aghamto' olekwa, nhi'nande hota a'uplin niohora a matmia'tu onni la' ler meni. ");
INSERT INTO lex_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Hade pede la' ler di de, mua'ala ra'pa, la muhak nana porni-dawarni la'a wewna wawannu pa ");
INSERT INTO lex_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","mpuatunu-mpuatah'a la mikmikarni-lamliamanni emeka a ralmu nwakwaka totpena la'pa a'g edonna muat mia'ta de agala ra'a-pal tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","La'pa Isaka naltier lia a'nani Esau, de Ribka natlin reria. Ne la'pa Esau nla'awa wo'or pa nhokra porni-dawarni ida totpa nodia la amni, de ");
INSERT INTO lex_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribka npolga a'nani: “Yakopa mmuai! A'utlin nan ammu e na'ohma hyalmu Esau ha nlolola. ");
INSERT INTO lex_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","E na'ohma pa la nahaka pip piora-waw diawra mai pia rwatunu-rwatah'a pa ammu na'ana totpena nala ra'a-palu, re'a-tniaru, geni-tiena mak kwatiawua Orgahi-Orha'a, yoma namta'at yanpa hota edon nalo'on wali ne nmati. ");
INSERT INTO lex_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Pede dodo'ondi de, mutlina-mutailla li'ru mak aghopan targa tiy o'a. ");
INSERT INTO lex_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Mlia'awa it genni mak it pipni-dumni rawok tar lia, ne mua'ala pipi a'na samomuou woru, pa atiunu-niahaga la mikmikarni-lamliamanni, emeka ha ralamni nwakwaka. ");
INSERT INTO lex_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Muodia la ammu pa na'ana, totpena la'pa edonna nmat mia'ta de nara'a-napa'lu.” ");
INSERT INTO lex_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Noka gari nakot la inni Ribka: “Mere ka'ku, de riy wulwulga, mere a' di de ulti namdiddidni. ");
INSERT INTO lex_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Yanhi'pa la'pa nteman nan a'u nwarora de aghi' pudi-akla. La'pa emkade de a'g edonna liernana ra'a-palu, mere liernana hoptutu-hoplera.” ");
INSERT INTO lex_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mere inni nakot la niwra: “A'g ed mak kakwara hoptutu-hopler de ama. Mutlina-mutailla a li'ru, mlia la'pa mua'ala pipi a'na maroro'a re pa muodi muai pia awuahi'a-wuayodia pa mikmikri-lamliamni.” ");
INSERT INTO lex_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Noka gari nlernohora. ");
INSERT INTO lex_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Nhor nioka Ribka na'ala Esau naniayarni mak samomuou muemna, maka namoin taru re la roma nayanni, noka nhopna Yakopa nnairia. ");
INSERT INTO lex_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ne pipi a'na de ulatni, de na'ala pa newan wutga la limni rora me tiernu la' geni mak kamdiddidin de. ");
INSERT INTO lex_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Noka nala yamanna mikmikri-lamliamni me rot miaka ha nwatah' oleka de pa nala Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Emkadella gari nla'awa amni genni, noka nakot la niwra: “Ama!” Amni nwahla niwra: “Ee! He' o' e?” ");
INSERT INTO lex_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Nwahla: “Esau a'u. Awuahi'a-wuayodi oleka maka ompuakwaka. Mumat pa ma mu'una totpena nhor die mura'a-mupalg a'u.” ");
INSERT INTO lex_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Noka Isaka nakot la Yakopa: “To'a, o fiekatmu?” Nwahla niwra: “Yoma Orgahi-Orha'a, Uplerlawanmu de, Nhi' a' pua aliernana awuahakaka.” ");
INSERT INTO lex_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Noka Isaka nakot la: “Mua mriehgoru ama, totpena atieman la inonmu, toto' pa o' di de Esau me edonna.” ");
INSERT INTO lex_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Noka gari nrehgoru amni, noma amni nteman la inonni, noma niwra: “La'a lirmu di Yakopa lirni, mere limmu di Esau limni.” ");
INSERT INTO lex_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Nhi'nande Isaka edonna nat niohora, yoma limni wulwulga emolmolla a'nani Esau limni. Mere Isaka nwahi' pa nara'a-napalga. ");
INSERT INTO lex_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Mere natian ma'ta: “Plola pa o' di de a'nu Esau o'a?” Nwahla niwra: “Yowa!” ");
INSERT INTO lex_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Noka Isak nakot la niwra: “Muala yamanan de pa rehgoru, totpa a'u'una ha anna hiti ahu-lier ahla enmu, totpena agala ra'a-pal tiy o'a.” Noma nala yamanna rpa rehgorgoru amni, noka na'ana. Nod walia anggur pa nemun walia. ");
INSERT INTO lex_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Noka Isak nakot la niwra: “Mua mriehgorgoru, pa mkinni a' wua ama.” ");
INSERT INTO lex_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Noka Yakopa nma nrehgorgoru na'nama nkinnia amni. La'pa Isaka na'irun nana naniayarni huwnu, dewade nwaka Uplerlawna pa Nara'a-napalga Yakop niwra: “Plollola la a'nu huwnu emolmolla wo'ora-kawru maka Orgahi Nara'a-napalu huwnu. ");
INSERT INTO lex_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Orgahi-Orha'a Uplerlawna-Mempulwatnu, awuaka pa ler di lyanit marna ntowria otanni, nohkerna-rai miarna nmoria wullu-we'elli pripanni-fa'anni. ");
INSERT INTO lex_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Awuak pa hairi-hairi pena ratlina-ratailla a'nu, ne mak kdella noha-rai re hota rwaltior la nayanni. Nla'a upa-matrom la amni-hyalli, ne inni a'nani re hota ratlina-ratailla e'a, he' ed mak kala hoptutu-hopler la' e' de, de O'a Mhuoptutu-mhuoplera, ne he' mak kala ra'a-pal la' e' de, de O'a hota Mura'a-mupalga.” ");
INSERT INTO lex_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","La'pa Isaka nala ra'a-palu pa nhorwua, ne na'nama a'nani gari nlergot pa naltarga amni, dewade Esau nmai pia nodia hiti ahu-lier ahla enni. ");
INSERT INTO lex_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","E' mana npipar walia ha'anna hiti ahu-lier ahla enni maka mikmikarni-lamliamanni, noka nodia la amni. Nakot la amni: “Ama, mumat pa mu'una ha'anna hiti ahu-lier ahla enni, totpa mura'a-mupalg a'u.” ");
INSERT INTO lex_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Mere amni niwra: “He' ed o' dina de?” Nwahla niwra: “A' di de a'namu yanulu Esau.” ");
INSERT INTO lex_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Dewade amni nheduma, noka nakot la niwra: “He' ed mak khokar nana porni-dawarni de pa nodi oleka mai a'u wua? La'pa edonna mmuai mia'ta de a'un doini oleka, ne a'ura'a-upalg oleka wa, ne riy maka a'ura'a-upalga oleka de, hade ed maka klernana ra'a-palu.” ");
INSERT INTO lex_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","La'pa Esau natlin nana amni lirni di, dewade napolu-natnian mieman la ralam mehrani ralamni, noka nakot la amni: “Ama, mura'a-mupal wali a'u mue!” ");
INSERT INTO lex_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Amni nwahla: “Garmu nma nodi oleka pudi-akla, pa nlernan oleka ra'amu-palmu de.” ");
INSERT INTO lex_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Mere Esau nwahla niwra: “Inee! Nanni de naplol pa rweta la Yakopa (nnia'eratni de, pudi-akla), yoma nalahar nana olek a'u re'eni woru. A yo'du nte'la nan oleka wa, ne dodo'ondi, de nte'la nan owa'ana yara'u-yapa'lu wali. Ama, mukleha yara'a-yapalu dom to' mai a'u?” ");
INSERT INTO lex_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Noka amni nakot la: “Plollolli de arian oleka garmu pa nla'a matrom la o wawanmu, ne amni hyalli-inni narni honona re agala pa rla'a ata-wa'ar la, ne agal oleka pa hota nlernana metma nora anggur turnu narehi-nalawna. Noma hota hya' ma'ta etla pa agala tiy o'a a'nu ne?” ");
INSERT INTO lex_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Nwahla: “Toto' pa ra'a-pal die ida nmemeh'a taru? Muala ra'a-pal mai a'u ama!” Dewade Esau lirni naprahka la kniakru. ");
INSERT INTO lex_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Noka amni nakot la niwra: “Plollolli de nhiol genmu hota olieta-patoga la nohanna-taniarat mak kawuli-kawe'el la noh di wawannu, ne geni miaka lyanit marna ntowria otanni mana olieta-patoga. ");
INSERT INTO lex_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Hota muor lia wehlamu wawannu pa mu'ara, ne omlia' ata-wa'ar la garmu. Mere hota omurur matmiat pia muaul doinia kwar dilla wawayanmu.” ");
INSERT INTO lex_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esau natatahana ralam mehrani la garni Yakopa, onnila ra'a-pal muaka amni nal oleka la, noma nakot la ralamni: “Lera-mela yaluli-yahon nohora a'mu matmiatni edon nalo'on wa. Ler yaluli-yahon nohora nhor niampena awuenna ga'ru.” ");
INSERT INTO lex_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","La'pa rwahaur nohora Esau lirni la inni Ribka, dewade nhopan pa rpolga a'nani gari, na'nama nakot la: “Hyalmu yanulu nwaror pa nwen o'a pa na natepra hankeranni (ralam mehrani). ");
INSERT INTO lex_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Pede dodo'ondi, mutlina-mutailla a li'ru ama, mpuahi'a-mpuayod pia muwlar pia mlia'awa yeimu Laban, la' Harana, ");
INSERT INTO lex_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ne muora mhiol wut lia hande pa me'eta-anni naya'ida-nayaworu, la'pa hyalmu yanulu ahankeranni me ");
INSERT INTO lex_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ralmha'arni namdiar wua, ne nhoratdoini-nehla doini hya' maka omhi' nana nhi'nanpena aghopna riy rtiy ra'lu la hande. Inee! Yanpa idma nwunu-nwen id la a ga'yu ralamni.” ");
INSERT INTO lex_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hade pede Ribka nakot la Isaka: “A ralmu edon nala patke'a Heta re. La'pa Yakopa na' nana patke' Heta id mak kden gen di pa nora rmehlima, de samounu di amuat niek wa!” ");
INSERT INTO lex_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ribka lirni nrei pia Isaka npolga a'nani gari pa nano'a niwra: “Ama, memieheni me, yana mua'ala patke'a Kana'ana pa mhi'a la hapmu. ");
INSERT INTO lex_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mere mlia'awa Padan Aram la'a upmu Betuela romni, ne mua'ala yeimu Laban a'nani id la hande pa muora mmiehlima.” ");
INSERT INTO lex_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Nano'a pa nhor nia'nama nara'a-napalga pa niwra: “Awuakwak de Uplerlawna mak kodi plolli-ktaryatnu pena Nara'a-napa'lu, Nhi'u pa mu'upa-mu'a'na, mpueha-mliawna, totpa rawal lia hairi ida prirni. ");
INSERT INTO lex_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Awuakwak de Uplerlawna Nala Abrahama ra'ani-pallu tiy omuora duratmu-waitmu, nhi'nande mliernana gen di pa gahamu, gen miaka miy mhiol lia emeka do'ona-dakna maka Uplerlawna Nal oleka la Abrahama.” ");
INSERT INTO lex_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Emkadella pa Isaka nolin doinia Yakopa, noka Yakopa nwaran pa nla'awa Padan Aram, nla'a yeini Laban romni. Laban di, Betuel makden Aram de a'nani. Laban narni de Ribka. Ribka a'nani de, Esau nor Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","7","La'pa Esau nat niohora amni nano'a garni pa yana na'ala pat Kana'ana pa nhi'a la hawni, noma amni nara'a-napalga garni, nhor nia'nama garni nla'awa Padan Arama totpa na'ala patke'a id la hande pa nhi'a la hawni, nlernohora inni-amni lirni, ");
INSERT INTO lex_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","nhi'nande Esau natga de amni ralamni edon nala patke'a Kana'ana re. ");
INSERT INTO lex_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hade pede nla'awa yeini Ismail, noka na'ala Ismail a'nani Mahalat pa nhi'a la hawni, na'itar wutu hawni rora. Ismail di de Abrahama a'nani, noka Ismaila na'a'na nana Nebayot nora garni Mahalat. ");
INSERT INTO lex_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Noma emkade pa Yakopa nwaran la Bersyeba pa nla'awa Haran. ");
INSERT INTO lex_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","La la'pa ntut tiar lia geni id la, yoma lera mana la nmel wa. Na'ala watu id la hande pa nhi'a la klunu, noka nanina la gen die. ");
INSERT INTO lex_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Noma nmi'a. La mi'ini ralamni de, la'a noha wawannu de retna ida ntutrieri, wuwannu nla'gennia Ilyamou-Watyatoha, ne namkek nana Orgahi hopopanni-lili'irnu rernu-rha'at la retan de! ");
INSERT INTO lex_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Orgahi Ntutrier lia retan de walli heyanna! Na'nama Nakot la: “Yakopa! A' di de Orgahi-Orha'a, mak kla' Uplerlawna la upmu-tgarmu Abrahama me la'a ammu Isaka. Ne gen miaka ha munin la di, de hota Agala tiy o'a, muora duratmu-waitmu. ");
INSERT INTO lex_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Duratmu-waitmu emolmolla en liu'wu-tan miakmu, ne hota re'era-rhakra la tipru, ra'i, warta me tranna, ne onnila omuora duratmu-waitmu pa nohkerkeran di mniotni rlernana ra'a-palu. ");
INSERT INTO lex_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Plollolli de Agor o' talla. Mlia' lol meni-meni de, Atiokreri-gheprie'ru, ne hota Ago'du pa muwal lia noh di, yoma A'g edon galtar o'a, mere Aghi'a hya'a-hya' maka A'uno'targa tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","La'pa Yakopa namat la yaninni, namta'at pa niwra: “Plollolli de Orgahi etla gen di, mere a'uplin niohora pa unin la. Gen di narehi-nalawan memna pa toto' meman pa Uplerlawna romni, Ilyamou-Watyatoha puohrani.” ");
INSERT INTO lex_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Repardoin yawyawar ma'ta de Yakopa na'ala wat muaka ha naklun die, nariria pa nhi'a la lairiri, noka nhuria wu'ru la watu wawannu. ");
INSERT INTO lex_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yakopa nweta gen diella Betel (nnia'eratni de, Uplerlawna romni). Mere Yakopa edon nanin ma'ta la hande de, de let mak rehgorgoru gen die rweta pa nwawa Lus. ");
INSERT INTO lex_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Noka Yakopa nlokra: “Orgahi-Orha'a Uplerlawna-Mempulwatnu. La'pa O' pena Mtiok reri-mhiep rier a lia talan mak aliolola, Muala rot pia u'una, ne naniair pa aniairia, ");
INSERT INTO lex_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","la'pa agodia kalwieda-paitiota uwal lia a'mu romni, de pena O' ed maka aghi'a la a Uplerlawnu. ");
INSERT INTO lex_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ne wat muaka upriria pa nla'a lairir di de pena nla'a geni miaka ra'uli-rawedi O' nanmu. La'a hare honona maka Omuala mai a'u rde agala nhiakra id la nhiakra termid ralamni (sepersepuluh) tiy O'a.” ");
INSERT INTO lex_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Nhi'noka Yakopa nwaran la hande pa nokru noha Bani tipru. ");
INSERT INTO lex_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Lera ida ne namkek nana gera id la wo'or letgarni, ne duma wokni wotelu ranin la onni, yoma la'a ger de wawannu de riy ralla dumni remnu. Ger de, tniutawnu de wat liawna ida. ");
INSERT INTO lex_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ne la'pa duma re wokni rheria la hande, demade mak kodi re rwaklol dioini wat diella ger de nurnu, demade ralla duma re remnu, nhor diemade rkeni owa'an wat diella ger de nurnu. ");
INSERT INTO lex_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Noka Yakopa la' pa natiana la mak kodi re: “Ama-hyal miy re, miy mpatiawu meni?” Rwahla riwra: “Ampatiawua Haran.” ");
INSERT INTO lex_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Natian owa'an la re: “Miy miat niohora Nahor upni Labana?” Rwahla riwra: “Yowa, amatga.” ");
INSERT INTO lex_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Nhi'noka nakot la re: “Enkalwiedweda?” Rwahla riwra: “Nkalwiedweda. Mere mumkek la, Labana a'nani patke'a Rahela nmai niek di, nodia dumni.” ");
INSERT INTO lex_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Noka Yakop niwra: “Hyal miy re, ler lawan ma'ta pa edon rawok ma'ta nhiuri-wnia'ana. Mialla dummu re remun pleini, nhor diemade mlia miodi owa'ana re. ");
INSERT INTO lex_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Mere rwahla riwra: “La'pa nhiuri-wnia'ana re wokni-wokni edon rawok momuou ma'ta de, ami edonna mhi' nan hade. Nanpena rwaklol dioini wat diella gera nurnu, demade amalla dum mamni re remnu. ");
INSERT INTO lex_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","La'pa nor ma'ta re raltiertier rier de, Rahela nmai wia pia nodia amni dumni, yoma e' mak kodia re. ");
INSERT INTO lex_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","La'pa Yakopa namkek nana Rahela, yeini Laban a'nani, nor wut lia dumni, dewade nma nwakriania, noma nwaklol dioini watu la gera nurnu, na'nama nalla Rahela dumni re remnu. ");
INSERT INTO lex_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Dewade Yakopa nkinnia narni Rahela pa nkakur wah'a lirni. ");
INSERT INTO lex_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Noka Yakopa nwahaur nohor la Rahela, e' de de Rahela amni narni Ribka, a'nani. Noma Rahela nawlar pia nla nwahaur la amni. ");
INSERT INTO lex_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","La'pa Laban natlin nana Yakopa, narni a'nani, dewade nawlar pia nla nwatroma, nrehgorga pa nkolla na'nama nkinnia, nhor nioka nodia pa nla'awa romni nayanni. Noma Yakopa nwahaur nohora inni-amni mormiorni-dardiarni la Labana. ");
INSERT INTO lex_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban nakot la: “Ame, plollolli de o' di de ihyida-rar id wut mai a'u.” Noma Yakopa nden wut lia pa nla' nana wolla id tututu. ");
INSERT INTO lex_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Nhor nioka Laban nakot la Yakopa: “Hya' pa o' di de na'ru a'nani nekane hota omkiari momuou mai a'u. Mukot mai a'u hya' maka agala la prehenmu.” ");
INSERT INTO lex_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban a'nani patke'a woru. Yanulu nanni Lea, ne gari nanni Rahela. ");
INSERT INTO lex_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea matni edonna samoga, mere Rahel de inonni, gaini honona samounu di! ");
INSERT INTO lex_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Hade pede Yakopa ralamni nala Rahela, reiniande niwra: “Ame, akar tiy o' pa anni wo'itu totpa aliernana Rahela, a'namu gar die pa aghi'a la ha'wu. ");
INSERT INTO lex_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban nwahla: “Ame, wakwakmu di, a'g edon wuayotlia. Samounu di, omuora mmiehlima totpa yanpa nor riy doma rmehlima. Mdien wut mai a lia gen di.” ");
INSERT INTO lex_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Pede Yakopa nkar niana anni wo'itu totpa nlernana Rahela, pa nhi' la hawni, mere anin mandiditu re nwarora de emekto'a lera wo'ira rmeh'a, onnila ralamni nal toto'a Rahela. ");
INSERT INTO lex_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Nhor nioka Yakopa nakot la Labana: “Ame, awuak pa muala a pa'tu de mai a'u, totpa agora manin wutu yoma lera nnielu ntu'tu wa.” ");
INSERT INTO lex_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Noka Laban npolg awoka mak kden hande honona rpa rhi'a ya'anlawna-yemunlawna. ");
INSERT INTO lex_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Mere la'pa nmella, dewade na'ala a'nani Lea pa nla nala la Yakopa. Noma Yakopa nor Lea ranin wutu. ");
INSERT INTO lex_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban mana nal wali atni patke'a Silpa la'a a'nani Lea pa nhi'a la atni. ");
INSERT INTO lex_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Mere repardoin de namkek de maka nora ranin wutu de, Lea. Noka Yakopa la nakot la Laban: “Hya' maka omhi'a mai a'u dina?! Akar tiy o' de totpa aliernana Rahela. Nihya'pa omuakal nan a'u?!” ");
INSERT INTO lex_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban nwahla: “Ame, riy edonna rhi' tar tiarga nhiol mak emkarella a gen miamni di, de ramehlima gari nala' ulu yanulu. ");
INSERT INTO lex_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Mupenu pleinia lera wo'it lia muora a'nu di mehlimmi, nhor diemade a'nu handina mana agala tiy o' pa emeka prehenmu nhierannu, hornama mkiari mai a'u pua anni wo'itg owa'ana.” ");
INSERT INTO lex_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Noma Yakopa nhi' emolmoll emkade, de napenga lera mandiditnu nora Lea mehlimni, nhor nioka Laban nal owa'an a'nani Rahel pa nhi'a la hawni. ");
INSERT INTO lex_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban mana nal wali Bilha, atni patke'a la a'nani Rahela, totpa nhi'a la atni. ");
INSERT INTO lex_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Noka Yakopa nor Rahel ranin wut wali. Mere rereh wiali ralamni nal memna Rahela, ematia'a Lea. Emkade nekpa nkari owa'an la Laban anni wo'itu. ");
INSERT INTO lex_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","La'pa Orgahi Namkek de Yakopa ralamni edon nala Lea, dewade Nhi'a Lea pa na'a'na, mere Rahel de nakleh a'na. ");
INSERT INTO lex_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea na'apnu pa nmor niana muanke'a ida, nala nanni pa nwawa Rubena (nnia'eratni de, mumkeka, a'nu muanke'a hadi), yoma niwra: “Orgahi Ntolwiah'a-ntakarwah'a a meh'ru mai a'u. Plollolli la' ler di ha'wu hota ralamni nala a'u.” ");
INSERT INTO lex_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Na'apun owa'ana pa nmor niana muanke'a ida, noka niwra: “Orgahi Natlin nana de, a ha'wu di, ralamni edon nal a'u, pede Nal owa'ana keke'en di mai a'u.” Noma nala keke'en de pa nwawa Simeona (nnia'eratni de, natlin nana). ");
INSERT INTO lex_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Na'apun owa'ana pa nmor niana muanke'a ida, noka niwra: “Ralamni di, de ha'wu ralamni hota naknioholia mai a'u, yoma a'u'a'na nana muanke'a wotel lia.” Nhi'nande nala keke'en de pa nwawa Lewi (nnia'eratni de, ralamni nakniohu). ");
INSERT INTO lex_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Na'apun owa'ana pa nmor niana muanke'a ida noma niwra: “Ralamni di de a'u'uli-uwedia Orgahi-Orha'a,” nhi'nande nala keke'en de pa nwawa Yehuda (nnia'eratni de, ra'uli-rawedia). Nhorwua dewade edon na'apun wa. ");
INSERT INTO lex_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rahela nwarora edon nlernana a'na, noka ralamni namehra doin la kakni, nhi'nande Rahela nakot la hawni Yakopa niwra: “Papa, mual a'na mai a'u. Er edonande amuati.” ");
INSERT INTO lex_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Noka Yakopa ahankeranni-ralmha'arni la'a Rahela, noka natiana: “A' di de Uplerlawna wniaunu a'u, pa atieri-tia'wu pa edon mu'a'na?!” ");
INSERT INTO lex_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rahela niwra: “La'pa emkade de, mua'ala Bilha di, a'tu patke'a hadi, omuora minin wutu totpa na'a'na totpena onnila Bilha aliernana durti-waiti.” ");
INSERT INTO lex_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Noma nala atni della Yakopa pa nhi'a la hawa liahunu. Noka Yakopa nora at de ranin wutu. ");
INSERT INTO lex_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","At de na'apnu pa na'a'na nana muanke'a id la Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahela nakota la: “Uplerlawna Ntutg oleka de, a'g ed mak kaplola, yoma Natlina-nataili oleka a polpuo'lu-wakwa'ku, ne Nala muanke'a id mai a'u.” Hade pede nala keke'en de pa nwawa Dan (nnia'eratni de, nakota mak kaplola). ");
INSERT INTO lex_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rahela atni pat di, Bilha na'apun owa'ana, noka nmor niana muanke'a wornu la Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel nakot niwra: “Agora ka'ku mparehi matmiati, ne a'ulernia la yawa.” Noma nala keke'en de pa nwawa Naftali (nnia'eratni de, mparehi). ");
INSERT INTO lex_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","La'pa Lea namkek de e' edon na'a'na wal wia, dewade na'ala atni Silpa pa nala la Yakop pa nhi'a la hawa liahunu. ");
INSERT INTO lex_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Noka Silpa, (Lea atni patke'a) na'a'na nana muanke'a id la Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea niwra: “Yara'a-yapalu nmai wia.” Noma nala keke'en de pa nwawa Gad (nnia'eratni de, pripanni-fa'anni). ");
INSERT INTO lex_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ne Lea atni Silpa na'a'n owa'ana muanke'a wornu la'a Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea niwra: “A' di de uhepru! Plollolli de patke'a hota riwra a' di de uhepuepru.” Noma nala keke'en de pa nwawa Asyer (nnia'eratni de, muki-hepru). ");
INSERT INTO lex_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","La'pa metma rieiki-wnio'ora lerni, pa Rubena nala'a la wo'ora, nlernana orwo'a-auwo'a Dudaima (maka ra'ana plet pa ra'apun wa) noka nodia pa nala la inni Lea. Mere Rahela nakot la Lea: “Ela, mtiulan pa mual nana orwo'a-auwo'a Dudaima mak a'namu nlernana re dom mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Mere Lea nwahla: “Mua' nana ha'wu de edonna ntu'tu ma'ta?! Dodo'ondi miwra mua' owa'ana orwo'a-auwo'a Dudaima mak a'nu de nodia?!” Rahel nakot la: “Ela, emkade de mel di de muora Yakop minina, totpa ralla rhernu orwo'a-auwo'a mak a'namu nodia re.” ");
INSERT INTO lex_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","La'pa lera nla'a, pa Yakopa nwatiawu wo'or pa nmai wia, dewade Lea nla' pa nwatroma noka nakot la: “Ee! Mai pia itanin la mel di, yoma plollolli de agal oleka orwo'a-auwo'a gala uweli o'a.” Reiniande Yakopa nora Lea ranin wut lia mel de. ");
INSERT INTO lex_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Noka Uplerlawna Natlin la Lea polpuollu-wakwakni, Lea na'apnu pa nmor niana a'na muanke'a mak wolimni la Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Noka Lea niwra: “Uplerlawna Nal oleka a prehenu nhierannu, yoma agal oleka a'tu patke'a la ha'wu.” Noma nala keke'en de pa nwawa Isakar (nnia'eratni de, prehenu nhierannu). ");
INSERT INTO lex_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nhor nioka Lea na'apun owa'ana pa nmor niana muanke'a mak wonemni la Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lea niwra: “Uplerlawna Nal oleka ra'a-pal samomuou mai a'u. Ralamni di de, ha'wu hota na'unni-namta'at a'u, yoma a'u'a'na nana a'na muanke'a wonem la.” Noma nala keke'enku' de pa nwawa Sebulon (nnia'eratni de, ra'unni-ramta'ata). ");
INSERT INTO lex_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Nhor nioka na'a'n owa'ana patke'a ida, ne nal nanni pa nwawa Dina. ");
INSERT INTO lex_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Noka Uplerlawna Nhorat reri Rahela pa Natlin la polpuollu-wakwakni noka Nhi'a Rahela pa na'apun wa. ");
INSERT INTO lex_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rahela na'apun pa nmor niana muanke'a ida. Niwra: “Uplerlawna Nhap doini oleka a molmola-mama'u.” ");
INSERT INTO lex_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Noma nala keke'en de pa nwawa Yusupa (nnia'eratni de, awuak pa liernana owa'ana a'na ida) yoma niwra: “Wuakwak de Orgahi Na'itr owa'ana a'na muanke'a id mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","La'pa Rahela nmor niana Yusup dewade Yakopa nakot la Laban: “Ama, mhur dioini a lia pa uwal lia le'tu-ruhunu maka rteti a horu-rki'ira a kliawtu. ");
INSERT INTO lex_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Muala ha'wu-a'nu re mak kla'a a prehenu nhierannu totpa amla'awa, yoma la'a me'eta-anin maka akari oleka tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Mere Laban nakot la niwra: “La'pa aliernana ralam kalwiedmu de, omdien nek la handi. A'umkek olek la ihriehera de Orgahi Nala ra'a-pal mai a'u onnila o'a. ");
INSERT INTO lex_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Muetlia prehenmu maka apuairia tiy o'a, totpena agala.” ");
INSERT INTO lex_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakopa nwahla niwra: “Omueh'a muat niohora de emkamenila a knia'ru tiy o'a, ne emkameni la nhiurmu-wnia'anmu la'a li'mu ralamni, ");
INSERT INTO lex_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","yoma re'emu-tniarmu edon harahu plollola, la'a ler maka amuai tiy o'a, mere dodo'ondi de rpeha-rlawna toto'a, ne Orgahi Nala ra'ani-pallu tiy o'a la'a lera-ler mak adiella handi, pede hota mowen nianpena akar lia ha'wu-a'nu re tiernu-apannu?” ");
INSERT INTO lex_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban niwra: “Hya' mak agala tiy o'a, Ame?” Yakopa nwahla: “Yana mual neka hya'-hya'a mai a'u, agiwra godi owa'ana pipmu-dummu, ne utiaka re, hornama omhur niohora hadi mai a'u. ");
INSERT INTO lex_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ler di hota aliola pipmu-dummu re letgarni, ne awuakei dioinia pipi me duma mak roriou-ponpona hongonu-laklaka, me dum a'na memetma, honona rde muala la a prehenu. ");
INSERT INTO lex_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ne plo'lu-mneh'u pena ralharia la ler li'iru, ler meni pa mua mtioli-mtiakar la a prehenu. La'pa pipi-duma mak edonna roriou-ponpona hongonu-laklaka me dum a'na maka edon memetma la temni rde, muat niohor neka de akamna' nana re.” ");
INSERT INTO lex_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Nhor nioka Laban niwra: “Itlernohor lirmu.” ");
INSERT INTO lex_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Mere ler de Laban nwakeiya pipi muan muaka roriou-ponpona, hongonu-laklaka me pipi rar mak roriou-ponpona, hongonu-laklaka, me maka memetamni la dum a'na re honona, nala la a'nani re ratiaka. ");
INSERT INTO lex_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nhor nioka Labana netlia genni olietni yala' laka lera wotel ralamni la'a enora Yakopa, noma Yakopa nod nieka pipi-dum mak kwarini re. ");
INSERT INTO lex_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Mere Yakopa na'ala au akni la ora-au wotelu maka wo'rani wawahra emekto'a au knumu, nwih dodioinia au aki re ulatni pa hongonu-laklaka, nhi'nande wo'rani re nayamkeka. ");
INSERT INTO lex_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Nkenia au aki rella yemun geni honona ralamni, la'pa rdella pipi-duma re matni taranni. Pipi-duma re la'pa rma remun de rmahru yalohora. ");
INSERT INTO lex_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","La'pa pipi-duma re ralohor la au aki re onni, de a'nani mana roriou-ponpona, hongonu-laklaka. ");
INSERT INTO lex_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Nhor nioka Yakopa nker doinia pipi a'na-dum a'na rella pa rmemeh'a. Mere Yakopa nhi' pa pipi-duma mak kalohora re rapal lia pipi roriou-ponpona, hongonnu-laklakni re, me duma memetma la Laban pipni-dumni. Emkade pa nlernana pipni-dumni wokni-wokni pa nmeh'a gahani, ne edonna nkenia la Labana pipni-dumni. ");
INSERT INTO lex_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ne la'pa ler meni pa pipi tei mak karuri-ka'orta re rma ralohora, de Yakopa nkenia au aki rella pipi-dum mak kalohora re matni taranni, totpa ralohor de rehgorgorga ha'aki re. ");
INSERT INTO lex_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mere la'pa pipi-dum mak kakleh ruri rmai, de edonna nkenia ha'aki rella hande. Nhi'nande nhiuri-wnia'an mak kakleh ruri de Labana gahani, ne mak karuri de e gahani. ");
INSERT INTO lex_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Dewade Yakopa re'eni-tniarnu na'ititar lol to'owa, ne ntarga ata-wa'ara patke'a rora muanke'a, pipi-duma rahu, onta me keledai. ");
INSERT INTO lex_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakopa natlin nana Laban a'nani re rakot emkadi la: “Yakopa na' momuou oleka it amni re'eni-tniarnu re honona, ne la'a it amni re'eni-tniarnu re, pa namoria re'eni-tniarnu. ");
INSERT INTO lex_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakopa namkek nan walia Laban gaini de Labana ematia'a ululu wut lia e'a. ");
INSERT INTO lex_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Noka Orgahi Nakot la Yakopa: “Muwal lia upmu-tgarmu letni-ruhunni, me lupmu-a'namu, ne pena Ago'ru talla.” ");
INSERT INTO lex_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Nhor nioka Yakopa nhopan pa rpolga Rahela nora Le' pa rmai lia wo'ora wawannu, la'a pipni-dumni genni. ");
INSERT INTO lex_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Noka nakot la re: “A ha'wu miy re! A'umkek nan la ammi gaini de ematia'a ululu, mere a'mu Uplerlawanni e Nor a tialla. ");
INSERT INTO lex_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ne miy mieh' mana miat niohora, de akar tioto'ola ammi. ");
INSERT INTO lex_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Mere ammi nakot nan a'u re'eni termid olekwa, de hota npairi a prehenu, mere re'eni termida olek hadi, de nalahar nan olek a wua, edon npairi a prehenu tetema emekto'a nakot targa olek mai a'u. Mere Uplerlawna edon Nolin doinia, pa nhi' yotyotni-yatyatni mai a'u. ");
INSERT INTO lex_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","La'pa Laban niwra: “Maka roriou-ponpona, hongonu-laklaka rde rhi'a la prehenmu”, dewade pipi-duma re honona ra'a'na de roriou-ponpona hongonu-laklaka. ");
INSERT INTO lex_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Emkadella pa Uplerlawna Na'ala ammi nhiurni-wnia'anni pa Nala mai a'u. ");
INSERT INTO lex_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ler ida ne la'a ler maka pipi-duma re ralohora, de ami'a, ne umkek nana ltiata maka kalohora re roriou-ponpona, hongonu-laklaka. ");
INSERT INTO lex_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ne Uplerlawna hopopanni Nakot mai a'u lia mi'u de ralamni: “Yakopa.” Noma awuahla: “Yowa Matroma.” ");
INSERT INTO lex_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Noka Naltieri: “Mrian gaimu ne mumkeka, ltiata mak kalohora pipi-duma rde roriou-ponpona, hongonu-laklaka. Aghi'a pa pipi-duma re harahu yoma A'umkek oleka hya'a-hya' maka Laban nhi' oleka tiy o'a. ");
INSERT INTO lex_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","A' di de Uplerlawna mak khari inonni tiy o' la Betel de, la' meni maka mual wu'ru la lairiri, ne maka mhi'a liokarmu mai a'u. Pa dodo'ondi de mpuahi'a-mpuayod pia mpuaran la' let di, muwal lia ammu-hyalmu inmu-narmu letni-ruhunni.”” ");
INSERT INTO lex_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Noka Lea nor Rahela ratlina Yakopa wniahaurnu pa nhorwua dewade riwra: “Papa, hota ami edon mlernana nhiakar la am mamni re'eni-tniarnu. ");
INSERT INTO lex_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Am mamni mana nrekan nana ami emolmolla do'ona-dakna pa na'olu ami olekwa, me kupna maka nlernana la inon mamni wawannu de, nhorwua olekwa. ");
INSERT INTO lex_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Plollolli de re'a-tniaru maka Uplerlawna Na' nana la am mamni, honona rde amora a'na mamni gahani. Emkade pa samounu de, hya'a mak Uplerlawna Nakot targa de, omliernohora.” ");
INSERT INTO lex_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Noka Yakopa nwahi'a-nwayod pia nhor nioka nkenia re'eni-tniarnu ror wutga hawni-a'nani pa rha'at la onta wawannu, noka nher niana nhiurni-wnia'anni re honona pa nlernohor reria. Nodia re'eni-tniarnu, nhiurni-wnia'anni honona maka nlernana la Padan Arama, nwaror nana nla'awa amni Isak de, la'a Kana'ana nohananni-taniaratni. ");
INSERT INTO lex_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","La'pa Laban nla ntoria dumni re wullu la' ler de de, Rahela nte'la nana amni atiehrani (patung). ");
INSERT INTO lex_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nhi'wal pia Yakopa ntot wunwunmua Laban yoma edon nakot nohora wniarorni-wnialaini pa nawlar wia. ");
INSERT INTO lex_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Emkadella pa nawlar niohora re'eni-tniarnu honona re. Nla la'pa nleretia gerlawna Efrata, na'nama rala' pa rokru Gilead wo'orni. ");
INSERT INTO lex_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","La'a lera mantetellu pa rakot nohora Laban de Yakopa nawlari olekwa, ");
INSERT INTO lex_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","dewade nodia amni-hyalli rpa rhokra Yakopa, yala'a lera wo'it ralamni, noka ndamit nana la Gilead wo'orni. ");
INSERT INTO lex_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Lera nmella dewade Uplerlawna Ntutga rupni la Laban la' mi'ini id ralamni, noma Nakot la: “Labana! Mutiak samomuoga, totpa yana mukot liryata-tunyata id la Yakopa.” ");
INSERT INTO lex_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban ndamit nana Yakopa la'a hoiwialli mak kdena wo'ora Gilead hananni, ne Laban nora amni-hyalli re mana rkeni hoiwialli la wo'or de wali. ");
INSERT INTO lex_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban nakot la Yakopa: “Ame, hya' ed maka omhi' nana dina?! Mhuap nian a'u me mtitni-mtiauru a'nu patke'a re emeka mak ka'ara ra'ala riy pa rwutu-rkohoga! ");
INSERT INTO lex_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nihya'pa omliergot de muwunmua pa o' edonna mukot targ a'u, totpa agodi o' la muki-hepru, nhieka-tniapra tiwla-prai, ya'ana-yemnu komkoma-lewlewarni. ");
INSERT INTO lex_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ne edonna muala lera id pa akinnia u'pu rena me a'nu patke'a re. Hihi'imu-yapyapmu de podku-padku kniarni hade. ");
INSERT INTO lex_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Agodi ruri-lai pia aghi' nana yotyotni-yatyatni tiy o'a, mere Uplerlawna maka ammu nkola tieru-nawur nehla, de Nakot mai a'u la'a mel worawi: “Mutiak kalwiedweda, yana mukota lir yata id la Yakopa”. ");
INSERT INTO lex_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Miwlar wia, onnila ralammu nakota nawal lia ammu romni, mere nihya'pa mkiamna'a a atieh'ru (patung)?!” ");
INSERT INTO lex_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Noka Yakopa nwahla Laban: “Ame, a'uwlari yoma umta'ata, yoma wniaro'ru, yanhi'pa mua' owa'an la a'namu re. ");
INSERT INTO lex_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mere la'pa atiehramu re, muhaka samomuoga la handi, ne it amni-hyalli rlin reri-rmat reri yahakmu. La'pa omliernana atiehramu la handi, mu'ala, ne riy maka nkamna'a de itwenna.” Nakot emkade yoma naplin niohora de, hawni Rahela ed maka na'ala atiehra re. ");
INSERT INTO lex_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Emkadella pa Labana nler la Yakopa hoiwialli, la'a Lea hoiwialli, ne la'a hawa liahunu rora hoiwialli, mere edonna nlernana atiehra re. La'pa nhargot la Lea hoiwialli dewade nla'awa Rahel hoiwialli. ");
INSERT INTO lex_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Mere Rahela na' olek la atiehra re pa nkenia la ontani wniowni nayanni, na'nama namtatan la wawannu. Laban nahak la hoiwiali honona de, mere edon nlernana atiehra re. ");
INSERT INTO lex_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Noka Rahela nakot la amni: “Yana a'mu nawenna, yoma ta'en niana a'uprir lia gaimu ralamni, yoma a'g e liernana karorta-kdeha.” Ne Laban nahak samomuoga, mere edonna nlernana atiehra re. ");
INSERT INTO lex_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Noka Yakopa na'ahankeran pa nora Laban rawo'or wa. Nakot la Laban: “A do'a-ha'lu hya' pa ");
INSERT INTO lex_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ompuahak la a hyo'nu-hya'nu re honona?! Mere hya' ed maka omliernana la'a yohya'a no' a hoiwia'lu ralamni?! Mkenia la it amni-hyalli gaini, totpa rawerta-ratailia itro'a. ");
INSERT INTO lex_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","La'pa anni terampwornu de agor o' talla, ne pipi-duma rara edon eti ralamni rwasioru ne pipmu-dummu ltiata mana a'g edonna u'un nan ida. ");
INSERT INTO lex_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nhiuri-wnia'ana mak kpora-kdawra rwenna pa rlihir matmata de a'g edon godia tiy o'a, mere amueh'a ghernia. Ne maka riy ha rkamna'a la lelerni me melmelli de ompuaka nhierannu mai a'u. ");
INSERT INTO lex_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kniari nodia a lia ler pitu-ler pahna, howna-kgar, unina-umat nohora kniari, ");
INSERT INTO lex_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","la'pa nte' nana anni terampworu die mak adiella rommu nayanni. Akar lia o'a anni termida wehrani wogata totpa liernana a'namu re rora, ne anni wonem pa totpa liernana nhiurmu-wnia'anmu, ne re'eni termida ralamni o' edon mpuairi a prehenu emekto'a mukot targa olek mai a'u. ");
INSERT INTO lex_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","La'pa Orgahi-Orha'a mak khi' Uplerlawan la a u'pu Abrahama ne mak a'mu Isaka na'unni-namta'ata de edon Nor a tialla, de omuolin doinia a' pua uwal niohora lima hgal tioto'a. Mere Uplerlawna Nlinwah'a-nmatwah'a a prehenu-ma'u, meh'ru-ma'u ne Neti olek la worawi die Nawenan la tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Noka Laban nwahla Yakopa: “Patke'a ri a'nu, ne ha a'nani re a u'pu, ne nhiuri-wnia'ana ri de nhiuri-wnia'anu, la'pa hya' maka mumkek nan la handi de a gah'u. Mere emkameni pa a'unetia a'nu rina me a u'pu ri honona?! ");
INSERT INTO lex_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Pede dodo'ondi mai pia tsi' wutu nnio'a ida, totpa nla'a lin reri-mat rer tiy o'a mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Nhi'noka Yakopa na'ala wat liawna id pa nohor targa-nwau tiarga pa na'etga la hgera-lairiri. ");
INSERT INTO lex_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Nhor nioka Yakopa nakot la amni-hyalli re pa rawok watu. Noka rla ral watu pa rhi'a katri'ana, noma ra'an la katri'an de onni. ");
INSERT INTO lex_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Labana nala katri'an de pa nwawa Yegar-Sahaduta (yoma Laban yawalli de, nnia'eratni, lin reri-mat reri), mere Yakopa nakota Galeda (yoma Yakopa yawalli de nnia'eratni, lin reri-mat reri). ");
INSERT INTO lex_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Noka Labana niwra: “Katri'an di ed mak kla' lin reri-mat rer lia omuor a'u la' ler di.” Hade pede nweta katri'an della Galed. ");
INSERT INTO lex_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ne nala katri'an de wal pia nwawa Mispa (nnia'eratni de, geni mkek reri) yoma niwra: “Orgahi Natiak reria itro'a la'pa it idma olieta la ida. ");
INSERT INTO lex_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","La'pa omhi' yatyat la a'nu patke'a ri ne omua'ala hapmu dom to'a la a'nu re onni, de mhuoratreria, la'pa riy edonna rdella it onni, Uplerlawna ed mak klin reri-kmat rer a'u me o'a.” ");
INSERT INTO lex_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Nhi'noka Laban nakot la Yakopa: “Hadi de katri'ana, ne hadin de hgera-lairiri mak aghor taru-wuau tiarga la itro'a. ");
INSERT INTO lex_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Katri'an di nora hgera-lairir di mak kla'a lin reri-mat reri, a'g edonna lieretia gen di pa alia o' de, la'pa ghi'a yotyotni-yatyatni, emekwalia o' mana edonna mlieretia handi pa omua mhi'a yotyotni-yatyatni mai a'u. ");
INSERT INTO lex_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Awuakwak de Orgahi-Orha'a mak khi' Uplerlawan la upmu Abrahama me Nahor nora Terah uplerni totpena reti plollolli-rdawra mneneha mai ita.” (Terah de, Abrahama nor Nahor amni). Noka Yakopa nlokar la Uplerlawna maka amni Isak na'unni-namta'at de nanni wawannu. ");
INSERT INTO lex_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Noma Yakopa ndella wo'or de pa rotan pipi-rkoki diuma la'a Uplerlawna. Npolg awoka amni-hyalli pa nora ra'an wutu, noma ra'an pa nhorwua noma ranin la wo'or de. ");
INSERT INTO lex_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Repardoin yawyawar ma'ta de Laban nkinnia upni-a'nani re, me nwak pa Uplerlawna Nara'a-napalga re, nhor nioka Laban nawal lia gen miak ha ndella. ");
INSERT INTO lex_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakopa nala' pa nodi liarni, noka nwatrom nana Uplerlawna hopopanni-lili'irnu. ");
INSERT INTO lex_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","La'pa Yakopa namkek nana re, dewade niwra: “Hadi de Uplerlawna kekni-rautnu rien genni.” Nhi'nande nweta gen diella Mahanaim (nnia'eratni de, rien geni woru). ");
INSERT INTO lex_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Nhor nioka Yakopa nhopna hopopanni re rala' ul pua rwatroma kakni Esau, la'a Seir lowanni-ahlani, la'a Edom yapatni. ");
INSERT INTO lex_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nhopna re niwra: “Emkadilla, la'pa mikot la matro'mu Esau de miwra: “Emkadilla atmu Yakopa lirni: Adiella Labana emolmolla do'ona-dakna, me aghol lia hande pa nma ntut nian ler di. ");
INSERT INTO lex_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Atiarg oleka ata-wa'ara patke'a rora muanke'a, hayori, keledai, pipi-duma, ne aghopan pa rwahaur nohor hadilla matro'mu, totpa aliernana ralam kalwiedwedmu.”” ");
INSERT INTO lex_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Hopopanni rlernohora lirni nhor nioka hopopna re rawal lia Yakopa pa riwra: “Amla' leka kakmu Esau. Dodo'ondi e' mana etla talan letgar pa nma nwatro'mu, nodia riy rahu wogata.” ");
INSERT INTO lex_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Noka Yakopa namta'at matmiati, noma nhakr etia riy mak kora e' talla, pipni-dumni, hayorni, keledaini me ontani rla'a wok lawanni woru. ");
INSERT INTO lex_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yoma wniarorni: “La'pa Esau nma nala wokni ida pa la' yaw de, de wokni id etla pa nlewna.” ");
INSERT INTO lex_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Noka Yakopa nhaut la: “Orgahi-Orha'a! Mak khi' Uplerlawna la u'pu Abrahama nora a'mu Isaka, maka kakot olek lirmu mai a'u: “Muwal lia letmu-ruhunmu, me ammu-hyalmu, inmu-narmu, lupmu-a'namu, ne pena Aghi'a samomuo'u” ");
INSERT INTO lex_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Hopopanmu a' di, rimormiori tio' a'u pa emkameni pa aliernana ralam kalwiedmu? Mere ralam kalwiedmu aliernana oleka me Mdienrer lia mai a'u pede la'a ler maka alieretia gerlawna Yordan de, agod tio' a lie'enu mere ler di de, rimormio'ru rora nhiuri-wnia'anu mana riwnu-halli pede aghi'a la nhiakra woru. ");
INSERT INTO lex_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Dodo'ondi mhedga a lia gera tlinni me mtiau a lia ai aratni totpena yana Esau wehlani latan nan a'u me terni ntuin nana agora ha'wu rora ri, me la' u'pu-a'nu re. ");
INSERT INTO lex_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Yoma Mukot targ oleka mai a'u: “Toto' pa Aghi'a kalwieda-paitiot tiy o'a, ne Aghi'a duratmu-waitmu pa emeka eni mak kdena en hu'ula-ga'a laini, la'pa lawan rehia pa takeni rrekan nana.”” ");
INSERT INTO lex_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Noka mel de de ranin la gen miaka Yakop nsumbain de. Nhi'noka na'ala hya' maka nodia pa nhi'a la limtutnu-limho'oni la'a kakni Esau, ");
INSERT INTO lex_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","pipi rara rahu woru me pipi ltiata terampworu, duma rara rahu woru me duma ltiata terampworu, ");
INSERT INTO lex_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","onta maka kuh mua'ta a'nani terampwotelu ra'itar wutu a'nani, sapi rara terampwogata me sapi ltiata termida, keledai rara terampworu me keledai ltiata termida. ");
INSERT INTO lex_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nal momuog harella atni-wa'arni re pa ratiaka, wokni-le'enu re meha-meha, ne nakot la re: “Mila' ul lia, me mitiaka wokni ida rletni la wokni handina.” ");
INSERT INTO lex_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Nano'a mak kdella gai kenkenna: “La'pa ka'ku de nwatrom miy ne natian miy die niwra: “Matrommi he'a? Miokur meni? He' gahani nhiuri-wnia'an mak kala' ul lia gaimi rena?” ");
INSERT INTO lex_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","De mpiahla miwra: “Garmu mak khi' hopopna tiy o' de, gahani. Hari de limtutnu maka nala la matro'mu Esau, ne Yakopa nmeh'a ed ma'ta la li'iru.”” ");
INSERT INTO lex_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Emkade walia nnio'oni la hopopanni mak kodi wokni wornu, me wotelu la'pa riy honona maka klernohora nhiuri-wnia'ana. ");
INSERT INTO lex_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Mere nano'a meman pa rakot la Esau de garni mak khi' hopopan la e'a ed ma'ta la li'iru pa nmai nieka. Yoma Yakopa nwarora: “Samounu de agala limtut muaka ha rodi rala' ulu re galla ghi' kalwied ralamni, nhor niampena a'umkek gaini, de ka'ku nod ralam kalwied pa nreinian a'u me edonna.” ");
INSERT INTO lex_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Pede limtutnu rde rodia rala' ulu, mere enmeh'a nanin la hoiwialli la mel de. ");
INSERT INTO lex_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","La'a mel de de Yakopa namat pa nodia hawni re rora, hawa liahu rora me a'nani termida wehrani ida re, rleretia gerlawna Yabok la geni miaka nhi'inde riy rleretia. ");
INSERT INTO lex_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","La'pa nodia rpa rleret wia, dewade nod wialia maka gahani honona rpa nlereti. ");
INSERT INTO lex_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Noka Yakopa nmeh'a o'ta watnu pa nwarini, ne muanke'a ida nora rwa'uta-rwatorna nek la mel tetema nodia pa lera matni npah'a. ");
INSERT INTO lex_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","La'pa riy de natga de ta'en niana nalernu Yakopa, dewade nrauti apitga Yakopa kowarni mak kod lia lenanni, nhi'nande kowarni toptopni natiaulu la, la'a rrora wnia'utni. ");
INSERT INTO lex_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Noka riy de nakot la niwra: “Muolin doini a lia pa alia'awa, yoma lera matni npah'a oleka wa.” Mere Yakopa nwahla niwra: “A'g edon golli o' la pa mlia'awa, la'pa o' edonna muala ra'a-palu mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Riy de natiana niwra: “O nanmu he'a?” Nwahla niwra: “Yakopa.” ");
INSERT INTO lex_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Noka riy de niwra: “Nanmu yan neka rweta la Yakopa, mere rweta la Israel, yoma omuora Uplerlawna me rimormiori mpia'uta-mpiatorna ne omualernia re.” (Yakop nnia'eratni de, pudi-akla mere Israel nnia'eratni de maka nor Uplerlawna rwa'uta-rwate'la). ");
INSERT INTO lex_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakopa natiana: “Awuak pa mukot walia nanmu mai a'u.” Mere nwahla niwra: “Nihya'pa omutiana a na'nu?” Noma nala ra'a-pal lia Yakopa la' gen die. ");
INSERT INTO lex_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakopa nweta gen diella Peniel (nnia'eratni de, Uplerlawna gaini), yoma lirni niwra: “A'umkek oleka Uplerlawna gaini mere a'g edonna muati!” ");
INSERT INTO lex_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","La'pa nto'or doini Peniel de namkek de lera matni npah'a wa, ne Yakopa nala' teka-teka onnila kowarni natiaulu. ");
INSERT INTO lex_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Hade pede makdena Israel re edon ra'ana ih miaka kaduw reria kowarni nodia pa ler di, yoma Enraut nana Yakopa diaini. ");
INSERT INTO lex_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakopa nran matni pa namkek de Esau nmai nieka, ne riy rahu wogata e rlelernohora. Noma Yakopa nhakra a'nani re dom pa rora Lea rala' rewre'wa, dom pa ror Rahela rala'a, ne dom pa rora hawa liahunu rora rala'a. ");
INSERT INTO lex_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Nhopan pa hawa liahunu re rora, rora a'nani pa rdella gaini, nhor nioka Lea nora a'nani rdella to'orni, nhor nia'nama Rahel nora Yusupa rdella li'ir memna. ");
INSERT INTO lex_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ne Yakopa nmeh'a nala'a la gai kenkenna, ne nwaltiora-nwaltieman re'eni wo'it lia tani wawannu, nodia pa nla' nana kakni gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mere Esau nawlar pia nwatroma, nkolla pa nkinnia, noka rrora rko'a-rkakru. ");
INSERT INTO lex_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Nhor nioka Esau nran matni pa namkeka patke'a re rora a'nani re noka natiana: “Hyalia, he'a riy mak kora o' talla rina?” Yakopa nwahla niwra: “Upa-a'na maka Uplerlawna Nara'a-napalga la a' di, hyalia.” ");
INSERT INTO lex_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Nhor nioka hawa liahunu rora a'nani re rrehgor pua rwaltiora-rwaltieman la. ");
INSERT INTO lex_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lea nora a'nani re mana rrehgor pua rwaltiora-rwaltieman la. Nhor nioka Yusup nora Rahel mana rrehgor pua rwaltiora-rwaltieman la. ");
INSERT INTO lex_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau nakot la re: “O wniarormu emkameni pede mhuopan pa rodia nhiuri-wnia'ana rpa rwatrom ulg a lia dodo'ona?” Nwahla niwra: “Totpa rlernana matro'mu ralam kalwiedwedni.” ");
INSERT INTO lex_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mere Esau nakot la: “A gah'u harahu garia, mua' reria hya' mak kdella limmu ralamni.” ");
INSERT INTO lex_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Mere Yakopa niwra: “Yana. Wuakwak de yan emkade. La'pa aliernan oleka ralam kalwiedmu, de mrieiniana-mua'nana a limtu'tu ri, yoma la'pa umkek nana gaimu de emolmolla umkek nana Uplerlawna gaini, onnila mpuayow pa mrieinian a'u. ");
INSERT INTO lex_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Awuak de mrieiniana nhiu'ru-nhielmu di, mak agodi oleka tiy o'a, yoma Uplerlawna Nal oleka ra'ani-pallu mai a'u, ne atiarga haneka-harahu.” Noka noria Esau pa nhi'nande nreiniana. ");
INSERT INTO lex_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau niwra: “Samounu de twaran pa tla' rewre'wa, ago'ru talla.” ");
INSERT INTO lex_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Mere Yakopa nakot la: “Matro'mu natga de keke'enku'a ri rakleh ma'ta ruri, ne pi'pu-du'mu, me sapi re doma ruruh rer mia'ta, la'pa tmahrur rer lia lera id de hota honona re rmat miomuou. ");
INSERT INTO lex_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Samounu de matro'mu nala' ul niek a lia, ne aghi' kuke' pa mnapla-mnapal pa godia ulakra nhiuri-wnia'ana mak kala'a la ga'yu, ne ulakra keke'enku'a re nodia pa atie'ela matro'mu genni la Seir.” ");
INSERT INTO lex_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Noka Esau niwra: “Emkade de agaltarga hopopnu-lili'iru re dom tiy o'a.” Mere Yakopa niwra: “Yan nek wa! Hornama aliernan oleka matro'mu ralam kalwiedni.” ");
INSERT INTO lex_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Pede ler de meman pa Esau nawal pia nokru Seir wa. ");
INSERT INTO lex_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mere Yakopa nwaran pa nla'awa Sukota, noka nariria likti, ne nhi' walia larma la nhiurni-wnia'anni. Nreiniande gen die rweta la Sukot (nnia'eratni de, larma). ");
INSERT INTO lex_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Rwatiawu Padan Aram pa rmai wia, de rodia kalwiedni-paitiotni pa rte'ela leta Sikhema la Kana'ana nohananni-taniaratni, noka Yakopa nkeni hoiwialli la let de onni. ");
INSERT INTO lex_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Nhor nioka nawel niana nohanna id la Hemor upni-a'nani. Hemor di, de Sikhema amni. Gen di miaka ha nawel niana pa nariria hoiwialli la, de welli maha wawahra rahu ida. ");
INSERT INTO lex_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Nariria katri'ana la hande, ne nweta pa nwawa El Elohe Israel (nnia'eratni de, Uplerlawna mak kodi plolli-ktaryatnu die, Nhi' Uplerlawna la Israel). ");
INSERT INTO lex_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ler ida ne Dina, Lea a'nani patke'a maka na'a'na la Yakopa, nla ntomra-nnah'a patke' walli la'a leta Sikhem. ");
INSERT INTO lex_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ler de de tuwgari ida nwawa Sikhem namkek nana. Sikhem di de Hemor makden Hewi a'nani ida. Ne Hemor di de mak kla' ray la let de. Noka Sikhem namkek nana Dina dewade nodia wlaria pa nareta-nahawa dawdawra. ");
INSERT INTO lex_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikhema ralamni nal matmiati hararar de nhi'nande naltier samomuou lia, totpena harar di ralam nal nan e'a. ");
INSERT INTO lex_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ralamni nal matmiatia pede Sikhem nakot la amni Hemor niwra: “Ama, mpaka hararar di pa aghi'a la ha'wu.” ");
INSERT INTO lex_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Noma Yakopa natlin nana de Sikhema nareta-nahaw dawdawra a'na pat di. Mere a'nani re er ma'ta la wo'ora pa ratiaka nhiurni-wnia'anni, pede Yakopa nheriaplin nieka hihi'a-yapyap die nodia pa hare rawali. ");
INSERT INTO lex_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Noka Sikhem amni Hemora nla pa nwatroma Yakopa pa naltier niohora Sikhem wakwakni de. ");
INSERT INTO lex_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Yakopa a'nani re rdella wo'ora pa ratlin nana Sikhem nareta-nahaw dawdawra ir narni pede plet pa rmai die ralamni ramehra ne rawenan doin la. Yoma Sikhema nhi' nan oleka kdeheni-ktiahlani la makden Israela. Nhiol miak emkade de yana rhi'a-ryapia. ");
INSERT INTO lex_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Noka Hemora naltier lia Yakopa, ne Yakop a'nani re e ratlin reria. Hemora niwra: “Ama, a'nu Sikhem ralamni nala a'namu. Awuakwak de miala pa nhi'a la hawni. ");
INSERT INTO lex_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ne samounu de twahal keliau, miala harararmi mai ami, ne mia'ala a hararar mamni. ");
INSERT INTO lex_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Mai pa itden wut lia handi pa mi'olu-mila' lola kperanni.” ");
INSERT INTO lex_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Noka Sikhem nakot la hararar de amni me narni re: “Pap miy re, awuakwak de aliernana ralam kalwiedwedmi, pena agala hya' to'a maka mpiaka. ");
INSERT INTO lex_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ne mikota agala leli-maha wo'ira-wo'ir mana pena agala tiy miy, mere miala hararar de pa aghi'a la a ha'wu.” ");
INSERT INTO lex_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Noka Yakopa a'nani re rwahla Sikhem nora amni Hemora de de rnairia pudi-akla. Yoma Sikhema nhi'a kdeh oleka ir garni Dina. ");
INSERT INTO lex_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Noma rakot la Sikhem nora amni: “Ami edonna mhi' emkade, de mala a nar mamni la muanke' maka edonna rsunta, yoma nhiol miak emkade de molmola-mama'a mai ami. ");
INSERT INTO lex_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","La'a hadi nmeh'a to'owa de amreiniana wakwakmu, omuor ami tamneh wutu, de muanke'emi re honona rde rsunta. ");
INSERT INTO lex_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nhi'nanpena amala hararar mamni tiy miy, ne miala gahami mai ami, ne amora miy tsol wiutu, ne hota ita tla' wutu hairi ida. ");
INSERT INTO lex_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mere la'pa miy edon mitlin la a lir mamni, ne miy edonna rsunta, de hota ma' owa'an la nar mamni de pa amla'awa.” ");
INSERT INTO lex_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Noka Hemor nora a'nani rwayow nohora wakwakni re. ");
INSERT INTO lex_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sikhem de ralamni nalmatmiati Yakopa a'nani, pede edon nalo'on pa nlernohora Yakopa wakwakni. Sikhem mana orkotkotni-ornananni la luwnu-a'nani ");
INSERT INTO lex_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","pede nor amni rla'a letni puohrani gaini, na'nama raltier lia ina-ama leta riwra: ");
INSERT INTO lex_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Pap miy re! Yakopa nor upni-a'nani riwra ror ita tsol wiutu la'a kalwiedni-paitiotni, miollia rpa rdella gen di, me rala' wewewar la ralamni. Gen di mana inponni ma'ta pa rdella toh?! Nhi'pa ta'ala harararni pa tsi'a la ita hawni, ne ital wali ita harararni la ira. ");
INSERT INTO lex_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Onnila tatar di to' pa hare rwayow pa rora ita tden wutu totpa tla' wutu hairi ida, de de ita muanke'eni meha-meha mai it de, rsunta emekwali ir rhi'a gahani re. ");
INSERT INTO lex_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nhiurni-wnia'anni, re'eni-tniarnu re mana hota rla'a it gahani toh?! Hornama ita twayow nohora wakwakni re, totpa rora it tsol wiutu-tlet wutu.” ");
INSERT INTO lex_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Noma Hemor nora a'nani Sikhema wakwakni de, ina-ama mak kma kawok la let de puohrani gaini re rreiniana, noka rsunta muanke'a honona la' let de. ");
INSERT INTO lex_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","La'pa lera wotellu de, leta mniotni ramehra-ramau niohora ir sunatni, dewade Dina narni woru, Simeon nora Lewi rmai die, mak kdella leta raplin niohora. Simeon nora Lewi rmai pia ra'ala wehlani pa rwenan nana muanke'a honona la' let de. ");
INSERT INTO lex_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ne Hemor nora a'nani Sikhem mana, Simeon nor Lewi rala wehlani rwenan nan walia, noka ra'ala narni Din la Sikhem romni pa rodia rla'awa. ");
INSERT INTO lex_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Nhor nioka Yakopa a'nani doma rmai. Iramkek nana mak kmati re inonni na'nama reyahru let de mniotni hyonni-hyanni, hewewatni-naniayarni pa rhi'a la ir gahani yoma rhi'a kdeh oleka ir narni Dina. ");
INSERT INTO lex_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Nhiurni-wnia'anni, ne hya' mak kdella let de ralamni me to'orni de ra'ala pa rodi momuoga. ");
INSERT INTO lex_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","A'na patke'a, upni-a'nani, re'eni-tniarnu, rheri-rhewta, la'pa hya'a-hya' mak kdella roma ralamni. ");
INSERT INTO lex_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Noka Yakopa nakot la Simeon nor Lewi: “A'na miy re, miy mhi' nana oleka matmiati-molmuol mai a'u, ne mhi' weyata a na'nu la noh di mniotni, la'a makdena Kana'ana me makdena Feris. Kennama it di riy doma rmeh' ita. La'pa rawok pa ral mai it de, toto' memna ral it la yawa, ne rahoru momuou ita, agora ro'mu mniotni.” ");
INSERT INTO lex_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mere rwahla riwra: “Nihya'pa a gari miamni la rhi'a emolmolla patke' yata?” ");
INSERT INTO lex_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Uplerlawna Nhar lirni la Yakopa: “Yakopa! Mpuaran pa mlia'awa la'a Betel, mdiella hande, ne muriria katri'ana id la A'u, mak kalhari inonni tiy o'a, la' ler maka omuwlar lia kakmu Esau.” ");
INSERT INTO lex_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Noka Yakopa nakot la romni mniotni me hare honona mak kora e' talla niwra: “Ina-nara ama-hyali miy re, mihal doini atiehra (patung) mak kdella letgarmi, mimou-miwitna inonmi me mhiernu naniayarmi. ");
INSERT INTO lex_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Mai pia tla'awa Betel, totpa la'pa aghi'a katri'ana la Uplerlawna maka katlin la a wakwa'ku la'a lera alier la klieratni onnila a'uwlar lia hya'lu Esau. Alia'a la meni-meni de, Uplerlawna Nor a' tialla.” ");
INSERT INTO lex_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Noka ra'ala atiehrani meheni re, pa rala la Yakopa, me krap mak della tlinni re (maka rnairia pa rpolu-rwak la atiehrani), noka Yakopa ntamnia la au lawna id nayanni makden leta Sikhem. ");
INSERT INTO lex_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Nhorwua dewade rwaran wa, ne Uplerlawna Nhi'pa riy mak kdella let paheli-ruhun patarna re, ramta'at pa nhi'nande edonna rhokra Yakopa upni-a'nani. ");
INSERT INTO lex_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Noka Yakopa nor mak kor e' talla rte'ela leta Betel, la'a Kana'ana nohananni-taniaratni. Let di, rwet wal pia nwawa Lusa. ");
INSERT INTO lex_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Nariria katri'ana la hande ne nweta gen diella El Betel (nnia'eratni de, Uplerlawna, mak kdella Betel). Yoma Uplerlawna Ntutga rupni la'a e'a la hande, la'a ler maka nawlar dioini kakni la. ");
INSERT INTO lex_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","La'pa Ribka in liahunu nanni Debora nmati, dewade rtamnia la'a Betel tawnu, la'a au lawna ida nayanni, pede riy rweta la au lawna yapolu-yatniani. ");
INSERT INTO lex_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","10","La'pa Yakopa nma nwatiawua Padan Arama, noma Uplerlawna Ntutga rupni la, ne Nal nanni warwuaru me Nara'a-napalga, Niwra: “Yakopa! Nanmu Yakopa, mere dodo'ondi de nanmu atia' Yakopa, mere Israel.” Emkadella pa Uplerlawna Nala pa nwawa Israel. ");
INSERT INTO lex_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Uplerlawna lirni: “A' di de Uplerlawna mak kodi plolli-ktaryatnu. Mu'upa-mu'a'na, mpueha-mliawna hairi ida, la'pa hairi-hairi wokni-le'enu ida nwatiawu o'a, ne ray-ray mana rwatiawu o'a. ");
INSERT INTO lex_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ne noh di maka Agal oleka la Abrahama me Isaka, hota Agala tiy o'a me la'a duratmu-waitmu.” ");
INSERT INTO lex_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Uplerlawna Naltieri pa nhorwua noka Nha'at la Ilyamou-Watyatoha, Naltarga Yakopa la gen miaka Ha Nal lirni la. ");
INSERT INTO lex_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nhor nioka Yakopa nohor targa hgera watu lairiri la gen die, noka nala himima-rere'a anggur pa rhuria me nhuria wu'ru la wawannu. ");
INSERT INTO lex_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakopa nweta gen die; la' meni mak Uplerlawna na'nama Nhar lirni de, la Betel (nnia'eratni, Uplerlawna romni). ");
INSERT INTO lex_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Nhorwua dewade rwaran pa rto'or doinia Betel la. La'pa ir edon oliet ma'ta la Efrat wa dewade, Rahela namehra-namau niohora yayori a'nani mak kodi klieratni la. ");
INSERT INTO lex_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","La'a klieratni la ya'a'nani di, mak kodi mak ka'a'na niwra: “Mama, yan mumta'ata, ralamni di mliernan ma'ta a'na muanke'a.” ");
INSERT INTO lex_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","La'pa nhi'pa nwaran doinia aranni honi pa nmati nala keke'en de pa nwawa Ben Oni (nnia'eratni de, a'nu umoria la meh'ru-ma'u ralamni), mere amni nal nanni pa nwawa Benyamina (nnia'eratni de, a'nu mak alililia). ");
INSERT INTO lex_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Emkadella Rahela nmat wia noka rtamnia la talan mak kokru Efrata aratni. Efrat de, rwet wal pia nwawa Betlehema. ");
INSERT INTO lex_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Nhor nioka Yakopa nohor targa hgera la hoini wawannu. Hade de Rahela ketarni lairirni nodia pa ler di. ");
INSERT INTO lex_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nhor nioka Yakopa (de, Israel) nwaran pa nla nkenia hoiwialli la gen miak edon oliet la yatiak geni nio' Eder. ");
INSERT INTO lex_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","La'pa Yakopa nhol lia let di de nhi'noka Ruben nora amni hawa liahunu Bilha ranina, noma Yakopa natlin nana hihi'a-yapyapi die. Yakopa a'nani muanke'a rde termida wehrani woru. ");
INSERT INTO lex_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Yakopa hawni Lea, a'nani yanulu de, Rubena, mak klernohora Rubena de, Simeona, mak klernohora Simeona de, Lewi, mak klernohora Lewi de, Yehuda, mak klernohora Yehuda de, Isakar, mak klernohora Isakar de, Sebulon. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Yakopa hawni Rahela, a'nani yanulu Yusupa, mak klernohora Yusupa de, Benyamina. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ne Yakopa hawa liahunu, de Bilha, Rahela atni patke'a, a'nani yanulu de, Dan, mak klernohora Dan de, Naftali. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ne Yakopa hawa liahunu, de Silpa, Lea atni patke'a, a'nani yanulu de, Gad, mak klernohora Gad, de Asyer. Gari hoho'a hade. Hare de Yakopa a'nani muanke'a, maka ra'a'na la'a Padan Arama. ");
INSERT INTO lex_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Noka Yakopa nla'awa la' amni Isak la'a Mamre la'a Kiryat Arba onni. Mere dodo'ondi rweta de Hebron. Hebron di gen miaka Abrahama nora Isaka rdella emeka do'ona-dakna. ");
INSERT INTO lex_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak mormiorni nla' nana anni rahu ida terampwo'awa. ");
INSERT INTO lex_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Noka Isak mana nmat wia pa rtamin wutga la upni-tgarni re. Isaka nhamto' kolkuolu, la'pa umarnu ntutu'tu noma a'nani Esau nora Yakopa rtamnia. ");
INSERT INTO lex_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hadi de Esau duratni-waitni. (Esau mana rweta pa nwawa Edoma). ");
INSERT INTO lex_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau na'ala patke'a Kana'ana wotelu pa nhi'a la hawni. Idni de nwawa Ada, Elona makden Heta a'nani. Hawa wornu de nwawa Oholibama, Ana a'nani. (Ana di amni de Sibeon makden Hewi a'nani.) ");
INSERT INTO lex_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ne hawni wotellu de, Ismail a'nani nwawa Basmat. Basmat di, Nebayot garni. ");
INSERT INTO lex_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada na'a'na Elifas la Esau, me Basmata na'a'na Rehuela, ");
INSERT INTO lex_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","me Oholibama a'nani yanulu de, Yeusi, mak klernohora Yeusi de, Yaelam, mak klernohora Yaelam de, Korah. Gari hoho'a hade. Hari de Esau a'nani maka rmor niana la Kana'ana yapatni. ");
INSERT INTO lex_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau nodia hawni rena me a'nani patke'a rora muanke'a, me riy honona mak kdella romni nayanni, nhiurni-wnia'anni, me re'eni-tniarnu re honona maka nlernana la Kana'ana, noka nla'awa nohananni-taniaratni meheni pa naltarga garni Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Onnila ir re'eni-tniarnu harahu rehi, nhi'nande ta'en niana rawok wutu, de gen miaka rahulti-rahamar la ta'en niana nawoka-nale'u niana re, yoma nhiurni-wnia'anni harahu rehia. ");
INSERT INTO lex_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Noma Esau nhol lia Seir wo'orni. ");
INSERT INTO lex_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esau die, makdena Edom amni. Esau duratni-waitni makdena Edom, mak kdella la'a Seir wo'orni rweta la emkadi: ");
INSERT INTO lex_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau hawni Ada a'nani de Elifasa. ");
INSERT INTO lex_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifas di a'nani yanulu de Teman, mak klernohora Teman de, Omar, mak klernohora Omar de Sefo, mak klernohora Sefo de, Gatam, mak klernohora Gatam de, Kenas. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Ne Elifasa hawa liahunu nanni Timna na'a'na nana Amalek. Hari de Esau hawni Ada upni re. ");
INSERT INTO lex_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Esau hawni Basmata a'nani de Rehuel. Rehuela a'nani yanulu de, Nahata, mak klernohora Nahat de, Serah, mak klernohora Serah, Syama, mak klernohora Syama, Misa. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau hawni Oholibama a'nani yanulu de, Yeusi, mak klernohora Yeusi de, Yaelam, mak klernohora Yaelam de, Korah. Gari hoho'a hade. Oholibama di amni, de Ana. Ana amni de, Sibeon. ");
INSERT INTO lex_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Mak kla' o'ta-mata la Esau duratni-waitni luwnu-a'nani emkadi: Mak kla' o'ta-mata la Esau a'nani yanulu Elifasa duratni-waitni luwnu-a'nani re, de Teman, Omara, Sefo, Kenasa, ");
INSERT INTO lex_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatama, me Amalek. Hari de luwu-a'na Elifasa o'tani-matni, la'a Edom nohananni-taniaratni. Hari honona Esau hawni Ada duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Mak khi' o'ta-mata la Esau a'nani Rehuel duratni-waitni luwnu-a'nani re, emkadille: Nahata, Serah, Syama, Misa. Hari honona re Esau hawni Basmata duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Mak khi' o'ta-mata la Esau hawni Oholibama a'nani muanke'a luwnu-a'nani re, emkadille: Yeusi, Yaelam, Korah. Hari honona Oholibama duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Hari de luwu-a'na Esau, ne hare de luwnu-a'nani o'tani-matni. ");
INSERT INTO lex_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Makden Hor ida nwawa Seir. Seir di a'nani mak kdella Edom lowanni-ahlani la Kana'an yapatni, de: a'na yanulu Lotana, mak klernohora Lotan de, Syobala, mak klernohora Syobal de, Sibeona, mak klernohora Sibeon, de Ana, ");
INSERT INTO lex_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","mak klernohora Ana de, Disyona, mak klernohora Disyon de, Esera, mak klernohora Eser de, Disyana. Gari hoho'a hade. Hare de ed maka kla' o'ta-mata la Seir a'nani ri makden Hori. ");
INSERT INTO lex_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan di a'nani yanulu de, Hori, mak klernohora Hori de, Hemana. Gari hoho'a hade. Ne Lotan narni de Timna. ");
INSERT INTO lex_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Syobal a'nani yanulu de, Alwana, mak klernohora Alwana de, Manaheta, mak klernohora Manahet de, Ebala, mak klernohora Ebal de Syefo, mak klernohora Syefo de, Onama. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeon a'nani yanulu de, Aya, mak klernohora Aya de, Ana. Gari hoho'a hade. Ana di ed mak klernana ger pahna matni la wo'orletna-kawurloini, la'a ler maka ha natiaka amni Sibeon keledaini. ");
INSERT INTO lex_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana a'nani yanulu de, Disyon, mak klernohora Disyon de, Oholibama. Gari hoho'a hade. Oholibam di, Ana a'nani patke'a. ");
INSERT INTO lex_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disyon a'nani yanulu de, Hemdan, mak klernohora Hemdan de, Esyban, mak klernohora Esyban de, Yitran, mak klernohora Yitran, de Keran. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eser a'nani yanulu de, Bilhana, mak klernohora Bilhan de, Saawan, mak klernohora Saawan de, Akan. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disyan a'nani yanulu de, Us, mak klernohora Us de, Aran. Gari hoho'a hade. ");
INSERT INTO lex_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Mak kla' o'ta-mata la makden Hori, de Lotan, Syobal, Sibeon, me Ana, ");
INSERT INTO lex_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disyon, Eser, me Disyan. Hari de makden Hori luwnu-a'nani o'tani-matni, la luwu-a'na honona la Seir lowanni-ahlani. ");
INSERT INTO lex_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ray-ray miaka kodi plolli la Edoma, la' ler maka ray id mana edon nodi plolli ma'ta la Israela de: ");
INSERT INTO lex_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","de Beor a'nani Bela, ne letni nwawa Dinhaba. ");
INSERT INTO lex_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","La'pa Bela nmat wia dewade Serah a'nani Yobab makdena Bosra nwauga pa nhi' ray. ");
INSERT INTO lex_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","La'pa Yobaba nmat wia, dewade Husyama makdena Teman nwauga pa nhi' ray. ");
INSERT INTO lex_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","La'pa Husyama nmat wia Bedad a'nani Hadad nwauga pa nhi' ray. Hadi ed mak kalernu makden Midian la Moab lowanni, ne letni nwawa Awit. ");
INSERT INTO lex_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","La'pa Hadad nmat wia dewade Samla makdena Masreka nwauga pa nhi' ray. ");
INSERT INTO lex_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","La'pa Samla nmat wia, dewade Saula makdena Rehobot la'a gerlawna aratni nwauga pa nhi' ray. ");
INSERT INTO lex_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","La'pa Saula nmat wia dewade Ba'al-Hanan, Akbor a'nani nhi' ray pia nwauga. ");
INSERT INTO lex_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","La'pa Ba'al-Hanan nmat wia dewade Hadar nhi' ray pia nwauga. Letni nwawa Pahu, ne hawni nwawa Mehetabel. Mehetabel di, inni de Matred. Matred inni de, Mesahab. ");
INSERT INTO lex_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esau upni-a'nani luwnu o'tani-matni nanni, rlernohora luwnu-a'nani me letni-ruhunni, rnairi rima-rima nanni, de: Timna, Alwa, Yetet, ");
INSERT INTO lex_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinona, ");
INSERT INTO lex_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mipsar, ");
INSERT INTO lex_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, me Iram. Hari de luwu-a'na Edom o'tani-matni, rlernohora letni-ruhunni la'a nohananni-taniaratni. Emkadella Esau makden Edom amni duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakopa nhol lia gen miaka amni nhi' do'ona-dakan la de, la'a Kana'ana yapatni. ");
INSERT INTO lex_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Emkadilla Yakopa duratni-waitni tuini. Yusup, la'pa umarnu termida wehrani wo'itu, tuwarwiar mia'ta de, nhi'de nora hyalli rodia pipi-duma. Yusup hyalli ri de, Yusup amni patke'a liahunu rora, Bilha nora Silpa, a'nani. Noka Yusup nwahauru hyalli re illu-wniehwa yatyatni la amni. ");
INSERT INTO lex_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yakopa (mak Uplerlawna Nal wal pia nwawa Israel) ralamni nala Yusup la'a a'nani re korni, yoma Yusup de a'nani maka rmor niana la mto'oni-pe'eni lerni, ne nhopna rhi'a rain samomuou lia pa nnairia, maka naplalahwa me limni mana naplalahwa. ");
INSERT INTO lex_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","La'pa hyalli re ramkeka de amni ralamni nal rehi Yusup la hyalli korni, reiniande sukni tia'ala pa edonna rora raltier samomuou. ");
INSERT INTO lex_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ler ida ne Yusup nmi'a, noka mi'ini de nwahauria la hyalli re, nhi'nande hare yeher to' pa sukni tia'ala. ");
INSERT INTO lex_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yoma lirni rla: “Hyal miy re, mitlin teka mi'u dina. ");
INSERT INTO lex_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Umkek de it erla nhyi' ralma, ne twutwut rieri metma wnioranni, noka plin-plinnianama a gah'u rapriri, na'nama miy hononmi gahami rma rtuk lia a gah'u.” ");
INSERT INTO lex_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Noka hyalli re rakot la: “Hyalia, yanhi'pa omiwra mla' ray pa muodi plolli mai ami?” Pede yeher to'a Yusup hyalli re sukni tia'ala onnila mi'ini me lirni de. ");
INSERT INTO lex_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Noka nmi' nan owa'ana mi'ini ida, pa nwahauru la hyalli re niwra: “Hyalia, mitlin mai a'u. A'g e mui' owa'ana, de lera, wolla me wtiona termida wehrani ida rtuk pua rru'u lia mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","La'pa nwahauru hadella amni me hyalli re, dewade amni nal lir la: “Ame, mi'a hya' maka omi' nan dena? Pena a'u me inmu me hyalmu re toto'a pa ampaltiora-ampaltieman la o'a?!” ");
INSERT INTO lex_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Dewade hyalli re ra'andoin gahani rla, mere amni nhi' targa hadella ihranu-ralamni. ");
INSERT INTO lex_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","La'pa ler ida ne hyalli re e rodia amni pipni-dumni la'a leta Sikhem onni. ");
INSERT INTO lex_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Noka Yakopa nakot la Yusup niwra: “Ama, muat niohora de hyalmu re e rodia pipi-duma la Sikhem onni. Mai pia mlia'a re.” Yusup nwahla niwra: “Yowa ama.” ");
INSERT INTO lex_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yakopa nano'a: “Mlia' pa mumkeka, la'pa hyalmu rena me pipni-dumni e rkalwieda-rpaitiota me edonna, de muodia kota mai a'u.” Noka Yusup nlernohora amni nnio'oni pa nlergot la Hebron lowanni lala'pa nte'ela leta Sikhem onni. ");
INSERT INTO lex_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","La'pa Yusup nala' wewewar la wewna wawannu, dewade nwatrom nana muanke' ida, noka muanke' de natiana: “To'a, he' maka ompuahaka?” ");
INSERT INTO lex_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Nwahla: “A'uhaka hya'lu re. Mtiulan pa mukot mai a'u, hare e rodi pipni-dumni la hanmeni?” ");
INSERT INTO lex_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Noka muanke' de niwra: “Rwaran olek la handi wa, yoma a'utlin nana riwra rla'awa Dotana.” Noka rwahaur pa nhorwua dewade Yusup nlernohora hyalli re pa ndamit nana rla leta Dotana onni. ");
INSERT INTO lex_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Mere oliet ma'ta de ramkek nan oleka wa. Mere la'pa edonna rehgor mua'ta dewade ra'an lira-remun waw pa rahak talan pa rwenna. ");
INSERT INTO lex_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Idma nakot la id pa riwra: “Mimkeka, it mak kmi'ini de nmai nieka. ");
INSERT INTO lex_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Dodo'ondi mai pia twenna, ne tnakul targa la gera id ralamni, demade takota tiwra pora-dawra ida nlihir oleka. Ne hota nhi'nanpena tamkek de, mi'ini edon nagengeni.” ");
INSERT INTO lex_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","La'pa Ruben natlin nana hare lirni die, nwaror pa nalewna Yusup la hare limni ralamni pa niwra: “Yana twenna. ");
INSERT INTO lex_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Yana mtiowur rarni! Mhiopliala ger di mak kdella wo'orletna-kawurloini, mere yan memmemna mpiano'a.” Ruben wniarorni de niwra nalewan Yusup la hare limni ralamni pa nodi nawal lia amni. ");
INSERT INTO lex_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Emkadella pa Yusup nte' wut lia hyalli re dewade rlehwa doini Yusup rain samomuounu de. ");
INSERT INTO lex_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Noma rodia pa rla rnakul targa la gera ralamni. Gera niahi mak kerna ida. ");
INSERT INTO lex_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Nhor nioka ramtatna pa ra'ana. Noka rran gaini na'nama ramkek nana mutu ida, de Ismail duratni-waitni makden Midian, mak ka'olu-kala'a. Rwatiawua Gilead pa rokru Mesira. Hare ontani re e rodia damri rora ortawi-autiawi huwua mikmikri maka welli werta. ");
INSERT INTO lex_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Noka Yehuda nakot la hyalli re: “Hyal miy re, ita unutnu hya'a, la'pa it twenna wunwunmua it garni dena?! ");
INSERT INTO lex_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Mai pia ita'olga la Ismail duratni-waitni re, mere yana itwano'a, yoma ita hyalli me ita ihini-rarni walli.” Ne hyalli re ratlin la lirni de. ");
INSERT INTO lex_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","La'pa makdena Midian re rlereti, dewade rran doinia Yusup la ger de ralamni ne ra'olga la hare, de welli maha wawahra (peraka) terampworu. Noka rod Yusup pa rla'awa Mesir wa. ");
INSERT INTO lex_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Rodi Yusup rla'awa Mesir noka, la'pa Ruben nawal lia ger de, de namkek de Yusup edonna nden olek la ger de ralamni, dewade ralamni nmawal doin la pa nlihir'er rayanni, ");
INSERT INTO lex_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","noka nawal lia hyalli re pa niwra: “Hyal miy re, it garni de edonna nden olek la wa, pa dodo'ondi de aghi' hya'a?” ");
INSERT INTO lex_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nhor nioka ra'ala Yusup rayanni, noka rotna pipi ida tiernu na'nama rto'a rain della rara ralamni. ");
INSERT INTO lex_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Rain plalahwa samomuou liawan de rhopna rla rottiarga la amni na'itra nnio'a: “Ama, hadi amlernana, pa mlioha-mlil tieka, yanhi'pa rain di de a'mu a'nani gahani me edonna?” ");
INSERT INTO lex_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","La'pa Yakopa nloha-nlili rain di dewade niwra: “Hadi de a'nu rayanni, pora-dawra ra'an nan oleka wa, toto' pa rlihir nana-rnai nian oleka Yusup wa.” ");
INSERT INTO lex_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Dewade Yakopa nlihir'era rayanni, ne nnairi naniairi yaluli-yahon la nehlani mak kwatiawu pipi ulti, noka naluli-nahona lera-mela onnila a'nani de. ");
INSERT INTO lex_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A'nani honona, patke'a rora muanke'a rhi' pa totpa ralamni makdudu, mere nwayotli niwra: “Edonna, a'ulul niekpa la'pa amuat nianpena awuatrom a'nu.” Emkadella amni nkakur nohora Yusup. ");
INSERT INTO lex_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Mere makden Midiana ra'olga Yusup de la makden Mesira ida, nwawa Potifara. Potifar di nkar lia Firaun romni ralamni, de de mak khi' o'ta la mak katiaka Firaun romni. ");
INSERT INTO lex_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","La' ler de maka ra'olga Yusup de, Yehuda nto'or doinia hyalli rella pa nhol wut lia makden Adulam ida, nwawa Hira. ");
INSERT INTO lex_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","La' hande de makden Kana'ana ida nanni Syura. Noka Yehuda namkek nana Syur di a'nani hararara ida. Noka Yehuda nora hararar di rmehlima noka ranin wutu. ");
INSERT INTO lex_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Patke' de na'apun wa pa na'a'na nana muanke'a ida pa rala pa nwawa Er. ");
INSERT INTO lex_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Nhor nioka patke' de na'apun owa'ana noma na'a'na nana muanke'a id pa rala pa nwawa Onana. ");
INSERT INTO lex_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Nhor nioka patke' de na'ana nan owa'ana muanke' ida, noma rala pa nwawa Syela. Yehuda nden ma'ta la Kesib de rmor dioini Syela. ");
INSERT INTO lex_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Keke'enku'a re rlawlawan lol pa lera ida ne Yehuda na'ala patke'a ida nwawa Tamra pa namehlim wutga la a'nani yanulu Era. ");
INSERT INTO lex_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mere Era, Yehuda a'nani yanul die kapliahana la Orgahi gaini, nhi'nande Orgahi Nwenna. ");
INSERT INTO lex_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Noka Yehuda nakot la Onana: “Ama, omuora yermu de muora mmiehlima, yoma o kwarmu hade la'a kakmu nhierannu totpena mimrio'a miwannia (mhi'a) kakmu duratni-waitni.” ");
INSERT INTO lex_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mere Onan natga de hota e' edonna nlernana durti-waiti nhi'nande la'pa nor kakni hawni de ranin de, de nhopliala kotnu la tani wawannu totpa yana nala durit la kakni. ");
INSERT INTO lex_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Mere maka ha nhi' nan de, de yata la Orgahi gaini, noma Orgahi Nwenan walia. ");
INSERT INTO lex_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Noka Yehuda nakot la yananni Tamra niwra: “Ina, mdien nek la ammu romni emeka mak kapalu, mpuei niekpa a'nu Syela nlawna,” yoma Yehuda wniarorni: “Yanhi'pa nmat wial pia emeka kakni rora.” Noma Tamra nla'awa pa ndella amni romni. ");
INSERT INTO lex_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","La'pa anni ida-woru nlardoin la, dewade Yehuda hawni nmat wia. Nalul pia nhorwua dewade Yehuda nor wutu talanni Hira makdena Adulam de pa rla'awa Timna, la'a mak ktoria dumni wullu re genni. ");
INSERT INTO lex_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","La'pa rod kiota la Tamra riwra: “Yananmu e nala' pa nokru leta Timna pa nla ntoria dumni wullu!” ");
INSERT INTO lex_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Noma Tamra no'lu doinia naniairi palpuallu na'nama nnairia o'tani kniaduwni me wutnu, noka nla namtatna la nhiari mak kapal rieri leta Enaima, la'a talan mak kokru Timna, yoma namkek de Syela lawn olekwa mere edon rala e'ela Syela pa nhi'a la hawni. ");
INSERT INTO lex_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","La'pa Yehuda namkek nana dewade nwarora de patke' yatyata ida de, yoma nahew gaini. ");
INSERT INTO lex_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Noka Yehuda nla napal lia patke' mak kdella talla aratni de na'nama niwra: “Mai pia agiwra gor o' manin wutu”, yoma naplin niohora patke' de de yananni. Patke' de natiana: “Hya' maka omuala mai a'u la'pa itro' tanin wutu?” ");
INSERT INTO lex_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Nwahla niwra: “Pena aghopan pa rodia pipi a'nu id la pi'pu-du'mu tiy o'a.” Patke' de niwra: “Hornama omualtarga nhia'argeni (hadom la a'u), nodia pa la'pa rodia pipi a'na de mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Natiana niwra: “Hya' maka agaltarga tiy o'a?” “Patke' de nwahla niwra: “Kniaumu (capmu), wuimu, me lie'en mak kdella limmu ralamni de.” Noka Yehuda nal momuou harella na'nama ranin wutu. Noka patke' de na'apun wa. ");
INSERT INTO lex_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Patke' de namat pa nla'awa la'pa no'lu doinia gaini kniaduwni me nnairi owa'ana naniairi palpuallu. ");
INSERT INTO lex_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Noma Yehuda nala pipi a'na della talanni Hira totpa la npairia la patke' de, totpa na' owa'an la hyonni-hyanni re, mere edonna nlernan patke' de wa. ");
INSERT INTO lex_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hira natiantan nohora la'a patke' de genni la mak kdella gen die niwra: “Hyal miy re, patke' yatyat mak nhi'in della patung geni, mak dodo'on namtatan la talla mak kokru Enaim aratni de, etla meni?” Rwahla riwra: “Hyalia, patke' yatyata emkade edonan mai handi.” ");
INSERT INTO lex_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Nawal lia Yehuda na'nama niwra: “A'g edonna wuatrom nana, ne makden hande mana riwra patke' yatyata edonan la hande.” ");
INSERT INTO lex_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Noka Yehuda niwra: “Nhi'in della pa ntorreria yohya'a re, totpa yana itla'a riy wniarerni-wniahaurnu rahe'i-ramal lia. Plola pa agiwra gal oleka pipi a'na de mere o' edonna mpuatrom nana.” ");
INSERT INTO lex_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","La'pa lardoini wolla wotel wua dewade ralde'et la Yehuda riwra: “Yananmu Tamra, nahawyata, ne na'apnu olek la yahawyatni de.” Noka Yehuda niwra: “Miodia patke' de totpa rtunga.” ");
INSERT INTO lex_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","La'pa rodia pa rwenna, dewade patke' de nhopna riy rla'a yananni Yehuda pa rakot la: “Nwatiaga muanke' maka hyonni-hyanni ri pede a'u'apnu. Mlioha-mlilia, he' gahani kniau me wui di nora lie'en dina?” ");
INSERT INTO lex_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yehuda nloha-nlilia yohya'a re noka niwra: “A'g edonna, mere patke' de ed mak kaplola, yoma a'g edonna gala la a'nu Syela.” Ne Yehuda edon nora patke' de ranin wutu owa'ana. ");
INSERT INTO lex_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","La'pa patke' de nmor wia, de na'a'na dio'a. ");
INSERT INTO lex_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ne la'pa nayor wia, de a'nani re ida limni nlergot ulu noka mak kodi nte'la la limni, na'nama nala ahwa mermera nkoh tiarga, na'nama niwra: “Hadi ed mak kala' ul pua klergota.” ");
INSERT INTO lex_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","La'pa keke'en de nrei dioin limni, dewade hyalli nlergot wa dewade mak kodi niwra: “Omurur matmiat pia mpuakdieh'a la tio'ora.” Noma rala keke'en de pa nwawa Peres (nnia'eratni de, nwakdieh'a pa nlergota). ");
INSERT INTO lex_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nhor nia'nama hyalli maka ha rala ahwa mermera rkoh limni de nlergota, noma rala pa nwawa Serah (nnia'eratni de, nlipa). ");
INSERT INTO lex_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ne Yusup de Ismail duratni-waitni rodi oleka la Mesir pa makden Mesir ida nwawa Potifara nawel niana. Potifar di de de nhi' o'ta la mak katiaka Firaun (ray Mesir) romni. ");
INSERT INTO lex_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Noma ndella upni-matromni makden Mesir di romni. Mere Orgahi-Orha'a nora Yusup talla, nhi'nande nla'a riy mak kniarni la'a ga'a. ");
INSERT INTO lex_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","La'pa upni-matromni nat niohora de Orgahi nora Yusup talla, ne Orgahi Nhi'a hya' maka ha nkari pa nla' ga'a, ");
INSERT INTO lex_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","dewade Yusup nlernana upni-matromni ralam kalwiedni, ne nala plola-mneha la Yusup pa nodi plolli la romni me re'eni-tniarnu honona. ");
INSERT INTO lex_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","La'a ler maka ha nala plolli-mneheni la Yusup pa namkek la romni me re'eni-tniarnu, Orgahi Nala ra'ani-pallu la makden Mesir de rom de onnila Yusup rerieini, nhi'nande Orgahi ra'ani-pallu etla re'eni-tniarnu wawannu, la'a mak kden roma nayanni, me mak kden nhyi' ralma. ");
INSERT INTO lex_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Hade pede re'eni-tniarnu honona rde Potifara nala la Yusup nodi plolli la. La'pa Yusup nodi plolli de, Potifara edonna ne'era-ntatra hadomdom pa, enekneka ya'anni-yemannu to'a. Yusup de inonni namuanmuanu me gaini mana samoga. ");
INSERT INTO lex_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Lardoini lera wo'ira-wo'ir wa noka upni-matromni hawni namkeka Yusup de dewade nakot la: “Mai pia itro' tanin wutu.” ");
INSERT INTO lex_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mere Yusup nwayotlia noka nakot la upni-matromni hawni de niwra: “La'a agodi plolli la handi, de u'pu-matro'mu de edon ne'era-ntatra hadomdom la rom di nayanni, ne nolin doinia re'eni-tniarnu honona la a li'mu ralamni. ");
INSERT INTO lex_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","La'a rom di nayanni mana edon narehi a lia plola-mneha, ne edonna nanetia hya'a-hya' to'ola li'mu ralamni, eneknek o'a, yoma o' de hawni o'a pa a'g edon liolla. Emkameni pa la'pa nhi'pa aghi' nana do'a-hal matmiat liawan dilla' Uplerlawna?” ");
INSERT INTO lex_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","La'a lera-ler to' pa patke' de naga'aga, mere Yusup edon natlin la gaga'anu de pa nanin la onni totpa rrora rdudu-rnei, ne e' mana edon nor wali upni-matromni hawni de nor wutga la kamri ida. ");
INSERT INTO lex_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lera ida ne Yusup nler la roma ralamni namkek la kniarni, ne la' rom de nayanni de hopopna riy id mana edonna ndella. ");
INSERT INTO lex_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Noka patke' de nte'la la Yusup rayanni pa nakot la: “Mai pia muor a' pua tanin wutu.” Mere Yusup no'lu dioini rain plalahwani pa nawlar pia nla'awa tio'ora, de patke' de nte'la reri rayanni. ");
INSERT INTO lex_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","La'pa patke' de namkeka Yusup no'lu dioini rain plalahwani pa nawlar pia nla'awa tio'or wa, ne e nte'la reri Yusup raini, ");
INSERT INTO lex_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","dewade npolga hopopna-li'iru honona la rom de pa nakot la re: “Mimkek la, Potifara nla nodia makdena Ibrani mniotni di totpa nahe'i-namal ita. Riy di nwakriani a'u totpa amro'a mdudu-mnei, mere aghaunu matmiati. ");
INSERT INTO lex_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ne la'pa natlin nana aghaun prakrahka dewade no'lu dioini rayanni la a o'nu pa nawlar pia nla'awa tio'ora.” ");
INSERT INTO lex_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Ne naltarga Yusup rayanni della onni pa nwei hawni nawali. ");
INSERT INTO lex_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Lir mak edon kaplol de nekpa patke' de la nwahaur nohora la hawni Potifar niwra: “Ee! Ata Ibran miaka omuodi mmuai die, nmai lia a' pua naga'ag a'u. ");
INSERT INTO lex_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mere la'pa aghaunu matmiati dewade no'lu dioini rayanni la a o'nu na'nama nawlar pia nhargot wa. ");
INSERT INTO lex_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Mtatan di pa Yusup upni-matromni natlin nana lir maka hawni ha nwahaur nohor de, emkade-emkadilla atmu de nhiolli mai a'u, dewade ahankeranni nha'at wa. ");
INSERT INTO lex_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Noka upni-matromni nhopan pa rtorna Yusup pa rkenia la roma nhio'la ralamni, la'a ray ha nwutu-nkohu re genni ralamni. Emkadella Yusup ndella roma nhio'la ralamni la hande. ");
INSERT INTO lex_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mere Orgahi Nora Yusup talla, ne Nala ra'ani-pallu la, ne Nhi'a mak katiaka roma nhio'la o'tani pa ralamni nala Yusup. ");
INSERT INTO lex_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Pede mak katiaka roma nhio'la o'tani nala mak kla'a roma nhio'la ralamni rella Yusup, ne tulla-kniari hya' mak kdella hande, de rala la ne'era-ntatra. ");
INSERT INTO lex_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ne mak katiaka roma nhio'la o'tani de edonna nhe'du nohora hya'a-hya' maka ha nateman targa la Yusup, yoma Orgahi Nor e' talla, ne hya' maka nhi'a rde nler la ga'a. ");
INSERT INTO lex_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","La'pa hari honona re rla rlola, de mak khi' o'tani la mak katiaka ray Mesir yemyemannu me mak khi' o'tani la rotni, rhi'a Firaun (de raiya Mesir) pa rawenan la. ");
INSERT INTO lex_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Noma Firaun nawenan doin la limni-rorni re rora pede ");
INSERT INTO lex_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","nhopna rho'la la mak kla' o'ta la mak katiaka ray, de romni, gen miaka ha rho'la Yusup la. ");
INSERT INTO lex_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Mak khi' o'ta la mak katiaka ray nhopna Yusup totpa nhoi-ntania re. Emkadella pa rho'la nana la anni id nor woru. ");
INSERT INTO lex_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","La' mela id de, ray limni-rorni re rora rmi'a, ne rima-rima mi'ini rde nnia'eratni de to'a-to'a. ");
INSERT INTO lex_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","La'pa repardoin ma'ta, dewade Yusup nmai tiemna re, namkek nana rde e rmahru la ralam mawla. ");
INSERT INTO lex_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Noka natiana la Firaun limni-rorni maka ha rho'la rewre'wa wutga la matromni romni de: “Nihya'pa ler di de gaimi rmaluidioinla?” ");
INSERT INTO lex_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Rrora rwahla riwra: “Ami'a mere riy mak kwet nana nnia'eratni de hamonna.” Dewade Yusup nakot la re niwra: “Edon miatga de Uplerlawna ed mak kakota mi'a ida nnia'eratni? Mikot mi'imi re mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Nhi'noka mak khi' o'tani la mak khoi-ktania yemyemnu de nwahaur nohora mi'ini la Yusup, niwra: “To'a, la a mi'u de umkek nana anggur onni ida etla a ga'yu ralamni. ");
INSERT INTO lex_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Anggur on de, de akni wotelg erla, ne na'nama onni de na'uhwu, deutnu nhargot wa ne unnu npenpuenu-nanahala gawarni. ");
INSERT INTO lex_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ne la'a li'mu ralamni de Firaun larni de, atiorreria. Anggur wo'a re aga'ala pa ariahmia la Firaun larni ralamni, na'nama agala la Firaun.” ");
INSERT INTO lex_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusup nakot la: “Hyalia, emkadilla mi'imu di nnia'eratni. Aki mantetelu rde, nnia'eratni de lera wotelu. ");
INSERT INTO lex_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Lardoini ler mantetelu ri, de Firaun hota nhopan pa rodi o' pa mhuargot la nhio'la geni, ne nal owa'ana o'ola mtatangen ululu, ne hota o' ed mak kala Firaun larni emekto'a mak ler de la'a ler maka omlia'a mak khi'a yemyemannu. ");
INSERT INTO lex_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mere mhoratreri a'u, la'pa mlier la kalwiedni-paitiotni, de mtiutga ralam kalwiedmu mai a'u, de mpuahaur nohora a yeh'wu la Firaun totpena nalgota a lia nhio'la gen di ralamni. ");
INSERT INTO lex_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Yoma a' di de ha kniamna' nan a'u, rwur niana-rgalam nana a lia makdena Ibrani re nohoni, ne la' handi mana a'g edonna ghi' nana hya'a-hya' maka kpa'eini-kpahala, mak kreinian de plola pa rodi a lia nhio'la gen di lienni ralamni.” ");
INSERT INTO lex_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","La'pa mak khi' o'ta la mak karia roti natlin nana mi'ini de nnia'eratni samou wa, dewade nakot la Yusup niwra: “A'u muana amui' wali. Umkek de a'g e tiutul niana kriou wotel die rpenpuen lia kuksi. ");
INSERT INTO lex_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","La'a kriou nio'a heyanna de Firaun kukasni rupni-rupni erla ralamni, maka mak khi' roti nhi' nana, mere onu-ma'nu ra'an doinia la la'a kriou nio'a a o'tu wawannu de.” ");
INSERT INTO lex_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusup nwahla: “Hyalia, emkadilla mi'imu de nnia'eratni, de kriou wotelu re, de lera wotelu, ");
INSERT INTO lex_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","La'a ler wotel ralamni di de Firaun nhopan pa rodi o' pa mhuargot la nhio'la geni, ne nwairi o'ola au riri ida, ne hota onu-ma'nu rtotna ihimu no' inonmu.” ");
INSERT INTO lex_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Noka la'pa lera wotellu dewade la nlola, de Firaun lera ha rmoria, pa Firaun nhi'a ya'anlawna-yemunlawna la mak khi' o'tani la kniarni ralamni. Na'nama nodgiota mak katiaka yemyemnu de nor wutga mak katiak roti die la ir honona gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Mak katiaka yemyemun de, nal owa'ana pa nawal lia mtatangenni, nhi'nande nla nodi owa'ana Firaun larni la, ");
INSERT INTO lex_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","mere mak khi' o'ta la mak katiak roti die, rla rwairia emolmolla lira maka Yusup nakot oleka rla. ");
INSERT INTO lex_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Mere mak khi' o'ta la mak katiak yemyemnu de edonna nhorat nan et miemna Yusup wa. ");
INSERT INTO lex_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","La'pa lardoini anni wor lia (ler maka Yusup nwet nana Firaun hopopanni rora mi'ini) noma Firauna nmi'a, de e ntutrier lia gerlawna Nila aratni. ");
INSERT INTO lex_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Namkek la gerlawna Nila ralamni de hayori wo'itu mak kapetna me klita-kwora. Noka rlergot la gerlawna ralamni pa ra'an wewan no'a gerlawan de aratni. ");
INSERT INTO lex_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Nhor nioka namkek nan owa'ana hayori dom pali, liawanni wo'itu rlergot la gerlawna Nila de ralamni. Hayori ri rpo'ora-rpaiti me inonni re yotyata. Noka rla rtutrier lia hayori mandiditu mak kala' ulu re onni, la'a gerlawan de aratni. ");
INSERT INTO lex_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Hayori maka kpo'ora-kpaiti me inonni yotyata re ra'ana hayori mandidit muaka kapetna me mak inonni klita-kwora re. Dewade Firaun namat wa. ");
INSERT INTO lex_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nhor nioka nanin owa'ana noka nmi' owa'an re'eni wornu, namkek de metma harni wo'itu rhargot la onni ida de na'unu-nayeha. ");
INSERT INTO lex_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mere nhor nioka namkek nan owa'ana metma harni wo'itu dom to'a, maka anin tipru rhi'a pa rapliau. ");
INSERT INTO lex_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Harni mak kilta re rtelan nan hare mandiditnu mak ka'unu-kayeha re. Dewade Firaun namat wa. Mere hadi e nmi' to'a. ");
INSERT INTO lex_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","La'pa yawyawar ma'ta de ralamni edon namtemna, noka nhopan pa rpolg awoka mak katga khi' ukru-rehera Mesir re honona. Firaun nwahaur nohora mi'ini rla mere riy id mana edon nala nnia'eratni la. ");
INSERT INTO lex_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Noka mak khi' o'ta la mak katiaka yemyemun de nakot la Firaun: “Ler di de na'nama aghoratnana a do'u-ha'lu mak ululu. ");
INSERT INTO lex_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ler maka matro'mu nawenan la am die, noma rho'la agora mutwua'lu la mak katiaka ray romni ralamni, ");
INSERT INTO lex_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","de, la mela ida amro'a mi'a, mere rima-rima nor mi'ini me nnia'eratni. ");
INSERT INTO lex_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","La hande de, tuwgari Ibrani id nor rewre'w ami, mak katiaka ray romni hopopanni de, ampahaur nohora ami' mamni la, noka nwahaur nohora rima-rima mi'ini na'itra nnia'eratni memna. ");
INSERT INTO lex_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ne emolmolla maka ha nakota mai ami, emkadella pa la nlola de a'uwali owa'an la a mtatange'nu ne a mutwua'lu mana rla rwairi wenna.” ");
INSERT INTO lex_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Nwahauru pa nhorwua noka, Firaun nhopan pa rpolga Yusup. Pleta-plet pa ralgota la nhio'la geni ralamni, ni'ir doini nurnu wullu, me nhernu naniayarni noka nla'awa Firaun gaini. ");
INSERT INTO lex_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Rla' noka Firaun nakot la Yusup: “A'g e mi'a, ne riy id mana ta'en niana nwet nana nnia'eratni, mere a'utlin nan olek o'owa, riwra hornama mutlin nan to'a mi'a, dewade omukota nnia'eratni.” ");
INSERT INTO lex_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yusup nwahla Firaun: “Matroma, edonan toto'a mai a'u, mere Uplerlawna ed maka hota kade'et nohora lira wniahla kalwied la matro'mu Firaun.” ");
INSERT INTO lex_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Noka Firaun nakot la Yusup: “La mi'u di ralamni de a'g e tiutrier lia gerlawna Nila aratni, ");
INSERT INTO lex_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Noka umkek de la'a gerlawna Nila ralamni de hayori wo'itu rhargot de rapetna me inonni rlita-rwora, ne ra'an wewan no'a gerlawan de aratni. ");
INSERT INTO lex_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mere nhi'noka umkek nan owa'ana hayori wo'itu rhargot de ulatni rwow rer tio'a rurni, ne rpo'ora-rpaiti, a'g edon umkek ma'ta maka yatni emkarella la'a noh Mesir di wawannu. ");
INSERT INTO lex_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Hayori maka yata me kpo'ora re ra'ana hayori mandiditnu mak kapetna me mak klita-kwora re. ");
INSERT INTO lex_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Mere apannu edonna rmarna, me ndella genni. Noka a'umat wa. ");
INSERT INTO lex_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Amui' wali de metma harni wo'itu mak klipa-ka'ma rlergot la onni ida. ");
INSERT INTO lex_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mere nhi'noka umkek nan metma harni mak kerna me mak anin tipru nhi' apliaga de wo'itu, rhargota. ");
INSERT INTO lex_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Harni mak kahgali me kilta re rlumu hare mandiditnu mak ka'unu-kayeha re. Ukot olek hadella mak katu re honona, mere id mana ta'eni nwet nana nnia'eratni mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Noka Yusup nakot la Firaun: “Matro'mu Firaun mi'ini rora re ramneneha. Uplerlawna Nakot oleka la matro'mu Firaun hya' maka Uplerlawna Niwra Nhi'a-nyapia. ");
INSERT INTO lex_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Hayori mandiditnu mak klita-kwora rde anni wo'itu, ne metma har mandiditnu re mana anni wo'it wuali, mi'a rora, ramneneha. ");
INSERT INTO lex_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Hayori mandiditu mak kpo'ora me yata maka khargot la li'iru rde, de nnia'eratni de anni wo'itu, emekwali metma har mandiditnu mak kapliau me kahgali onnila anin tipru rde, nnia'eratni de hota anni wo'it die rehka-lara. ");
INSERT INTO lex_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Emekto'a a'ukot olek la matro'mu Firauna, Uplerlawna Ntutga la matro'mu Firaun hya' mak pena Nhi'a. ");
INSERT INTO lex_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hota la'a anni wo'it ralamni de pripanni-fa'anni la noh Mesir di wawannu tetema. ");
INSERT INTO lex_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Nhor diemade hota anni wo'it die rehka-lara, nreiniande hota rhorat doini anin mandiditu muaka kodi pripanni-fa'anni re, yoma lar de nhi'a noh di pa nkerna-nhau. ");
INSERT INTO lex_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Hota edon ramkek nan etia pripanni-fa'anni korni-tre'eni onnila lar de, yoma lar matmiat miemna di. ");
INSERT INTO lex_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","La'pa Ntut lia mi' de re'eni wor lia matro'mu de nnia'eratni de, hade de Uplerlawna Net tiarg oleka, de edon nalo'ona ne Uplerlawna Nhi'a. ");
INSERT INTO lex_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Hade pede samounu de matro'mu Firaun nwahak nana riy mak katu me maka wniarora plalahwani ida, pa mriana pa nhi'a mak kodi plolli la noh Mesir di wawannu. ");
INSERT INTO lex_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Samounu wal die Matro'mu Firaun nhi' emkadi, de de mpuagamtatna mak katu klina-kmat la noh di, ne la'a anni mandidit muaka pripanni-fa'anni de rawoka id la nhiakra wolim la'a Mesir di wullu-we'elli. ");
INSERT INTO lex_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Rawok memna yamanna hya'a-hya' to'a la'a anni-anni pripanni-fa'anni mak hota nala' ulu ri, ne la'a matro'mu Firaun plolli-mneheni de raniutnia metma wo'oni la leta-let lawna re emeka ha yaya'ana pa rwatierun targa. ");
INSERT INTO lex_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Emkadella yaman ara re rla'a yamanna wniaho'a-wniatiernu totpa hota ra'ana la noh di la'a anin mandidit muaka lara ha nwewar nan la Mesir di tetema, totpa noh di yana npohra-niata onnila la lara.” ");
INSERT INTO lex_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Firaun nora tniutnu-nhianni-nhielli-liarni honona re rwayow nohora wakwak de yoma rlina-rmata de samoga. ");
INSERT INTO lex_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Noka Firaun nakot la tniutnu-nhianni-nhielli-liarni re: “Ama-hyal miy re, hota it edon tlernana riy dom mak emekto'a Yusup di, de riy maka Uplerlawna Nhiwni Npenpuenu-nanahala ralamni.” ");
INSERT INTO lex_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Firaun nakot la Yusup: “Ama, onnila Uplerlawna Nakot momuou oleka hari tiy o'a, mak katu me mak ktarga wniarora-wnialai samomuou id mana ematia' o'a. ");
INSERT INTO lex_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","O' ed mak kla'a mak kodi plola-ktaryat lia ro'mu nayanni, ne lima-rora honona re ratlina-ratailla hopopna-lili'irmu, mere enekneka a' tio' pa a'g edon utlin la tiy o'a. ");
INSERT INTO lex_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","La hadi wawannu pede, atiutmuata-kiewra'u pa mlia'a mak kodi plola-ktaryat lia noha Mesir wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Nhor nioka Firaun nur dioinia kdieli maka nhi'inde ndidnia pa nodi plolli la kniarni wawannu, na'nama nohoga la Yusup okarni. Nhor nioka nala koka mnurnuhru la Yusup nnairia, ne nwairia wui miaha la tiernu. ");
INSERT INTO lex_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Noka Firaun nhopan Yusup pa la nha'ata kereta, ne riy riarin nohor la Yusup de rhaun pa niwra: “Kalwiedoo!” Emkadella la'a Firauna nrana me ntutmuata-nkewra'a Yusup pa ndella Firaun walli malganna pa nodi plolli la Mesir wawannu. ");
INSERT INTO lex_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Firaun nakot la Yusup: “Ama, omuatg olekaw de, a' di de ray Mesir, mere la'pa o' edon mpuayow nan riy, de riy id mana ta'en niana nwo'la-nlekur la Mesir di ralamni.” ");
INSERT INTO lex_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Noka Firaun nala Yusup pa nwawa Safnat-Pa'aneah, ne na'ala Potifera a'nani Asnat pa Yusup nhi'a la hawni. Potifer di, de makpolwunu-kwaklera no'a leta Ona. Emkade pa Yusup de emeka mak kodi plola-ktaryat lia noha Mesir. ");
INSERT INTO lex_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yusup aninni terampwotelu la'a ler maka Firaun nhi'a la hopopanni, noka Yusup naltaru Firaun pa la nwakdior momuou Mesir uhunu-ewatni-ewatni-lahwani. ");
INSERT INTO lex_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Lowan de, nala wullu-we'elli nniutni-nniutni la'a anin mandidit muaka kodi pripanni-fa'anni de. ");
INSERT INTO lex_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Noka Yusup nawoka yamanna hya'-hya' to'a maka ha rara'ana la Mesir wawannu la'a anin mandiditu re, na'nama rwaho'a-rwatiernia la leta-letlawna re. Lowan mak kdella letlawna re onni de wullu-we'elli rawoka la leta-leta re ralamni. ");
INSERT INTO lex_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Emkade pa Yusup naniutnia metma rde harahu rehia pa emeka en liu'wu-tan miakum no' eni wawannu, nreiniande edon nrekn owa'ana, onnila harahu rehi pa ta'eni rrekan nana. ");
INSERT INTO lex_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","La'pa anni mandidit muaka kodi rehka-lara edonna nmai mia'ta de, Yusup hawni Asnata na'ana nana muanke'a wor lia Yusupa. ");
INSERT INTO lex_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yusup nweta a'nani yanul die Menasye, (nnia'eratni de, nhoratdoini), yoma niwra: “Uplerlawna Nhi' a' pua ghoratdoin memna a ralam meh'ru la a a'mu romni.” ");
INSERT INTO lex_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ne a'nani gari de nweta la Efraima (nnia'eratni de, pripanni-fa'anni liawanni) yoma niwra: “Uplerlawna Nhi' a' pua liernan pripanni-fa'anni la gen miaka aghoptutu-ghopler la.” ");
INSERT INTO lex_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","La'pa anni mandidit muaka kodi pripanni-fa'anni la' Mesir de nlardoinla, ");
INSERT INTO lex_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","dewade anni mandidit muaka kodi rehka-lara nmai wia, la' noha-rai korni re lara nwewar nana, mere la' Mesir de yamanna erla emeka hya' maka Yusup nakot oleka la. ");
INSERT INTO lex_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","La'pa Mesir noh tetema nler la lara ne lima-rora rwak meman la Firaun pa nala yamanna, dewade Firaun nakot la makden Mesir re: “Mlia'awa Yusup de pa mhi'a hya' maka ha nakota tiy miy.” ");
INSERT INTO lex_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Lar de na'ititar lol to'owa pa nwewar nan noh Mesir tetema, pede Yusupa nhari dudanni (gudang) re honona pa na'olu metam la makden Mesir. ");
INSERT INTO lex_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ne la'a riy mak kdella noheri-woru lyanti nayanni mana rmai Mesir pa rawelia metam la Yusup, yoma lar de lawan rehi la nohkerna-rai miaran tetema. ");
INSERT INTO lex_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","La'pa Yakopa natlin nana kota-de'et de metma harahu la Mesir, dewade nakot la a'nani re: “A'nami re! Nihya'pa miy idma namkek rer tio' ida?! ");
INSERT INTO lex_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","A'utlin oleka, de metma harahu la Mesir, mlia'awa hande pa miwelia metam mai ita, totpa it tmormiori, yana tmati.” ");
INSERT INTO lex_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Noka Yusup hyalli termida rla'awa pa rla rawelia metam la Mesir. ");
INSERT INTO lex_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mere Yakopa edon nolin Yusup garni Benyamin pa nor hyalli re talla, yoma nwarora de: “Yanhi'pa la'pa nler la yatyatni.” ");
INSERT INTO lex_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Pede la'a riy mak kma kawelia metma ri, de Yakopa (Israel) a'nani mana erla' wali, yoma lara mana nwewar nan wali noha Kana'ana. ");
INSERT INTO lex_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ler de de Yusup ntorn oleka Firaun limni walli malganna la'a noha Mesir. E' mak ka'olu metam la noha re mniotni. Pede la'pa Yusup hyalli rmai, rla rwaltior la e gaini ralamni na'nama ruh' idma-rrama lia'ara. ");
INSERT INTO lex_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","La'pa Yusup namkek nana hyalli rde, plet pa natga re, mere nhi' yehwani la hyalli re emolmolla riy meheni. Noka Yusup nhok temna re, niwra: “Mimpiatiawua hanmeni?” Rwahla riwra: “Ampatiawua Kana'ana pa ma mawelia yamanna matroma.” ");
INSERT INTO lex_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Plola pa Yusup natga re, mere ir edon ratga e'a. ");
INSERT INTO lex_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Noka Yusup nhoratnana mi'ini la'a hare. Noma nakot la re: “Miy di de mak kwuw miy, miy e mihaka geni miaka makodi keki-rautu edon ratiaka.” ");
INSERT INTO lex_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Noma rwahla riwra: “Edonna matroma! Toto' memna ma mawelia ha yaya'ana to'a. ");
INSERT INTO lex_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Am di nek de riy ida a'nani a hononami, ne am di de mak kwuw atia'a, mere riy ploloi-plele'era ami.” ");
INSERT INTO lex_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Mere Yusup nakot la re: “Edonna! Miy mmiai di de, miy e mimkeka noh di, yanhi'pa edon ratiaka.” ");
INSERT INTO lex_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Noka rwahla: “Edonna matroma! Atmu am di de riy termida wehrani worg ami, ampahyali, riy id la Kana'ana a'nani ami, mere gari hoho'a e nwarin wut lia a am mamni, ne riy id demade nmolg olekwa.” ");
INSERT INTO lex_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Noka Yusup nakot la re: “Edonna! Agatga de miy di de mak kwuw miy emeka a'ukot oleka tiy miy. ");
INSERT INTO lex_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Aliokra la Firaun nanni, de hota atia'u miy, de de hota miy edon mpiaran la handi, la'pa hyalmi gari hoho' de edon miodia mai handi. ");
INSERT INTO lex_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mhiopna riy id tiy miy nla nala garmi de, mere miy korni de mpiarin pia rho'la miy la roma nhio'la. Totpa la'pa rwerta-rtaili lirmi plolli, plola pa naplola, me edonande plollolli de miy di de mak kwuw miy.” ");
INSERT INTO lex_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Noma rho'la rewre'wa rla lera wotel ralamni. ");
INSERT INTO lex_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","La'a lera nla'awa wotellu dewade Yusup nakot la re: “A'u'unni-umta'ata Uplerlawna pede aghopan pa mhi' emkadi, totpa miy di mmiormiori aplalahwa. ");
INSERT INTO lex_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","La'pa miy di de riy ploloi-plele'er miy, mialtarga riy id pa rho'la targa la nhio'la geni ralamni, mere miy mlia'awa pa miodia metma rpa ralla radarga lara la rommi mniotni. ");
INSERT INTO lex_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Mere hyalmi gar die miod miemna mai a'u, totpa agatga de lirmi re plola pa naplola, ne yana rwenan miy.” Emkadella pa rhi' nana. ");
INSERT INTO lex_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Mere idma nakot la ida: “Toto' pa it takwara it do'oni-halli la it garni de. Itamkeka emkameni la ler ululu Yusup ralam mehrani, la'a nwak it ralam kalwiedwedni mai ita, mere it tahmena tatlin la polpuollu-wakwakni. Hade pede dodo'ondi de itlernan ralam mehrani wniahlani.” ");
INSERT INTO lex_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Noka Rubena nwahla re: “Hyal miy re, miat niohora de ukot oleka la ler ululu de: “Yana mhi' do'a-myap hial la tuwgar de”, mere mihmen mitlin la li'ru-tu'nu. Ler di de Uplerlawna Nwaka rarni wniahlani mai ita.” ");
INSERT INTO lex_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Rakot emkade mere raplinga, de Yusup e nat niohora yawalli re, yoma nnairia mak kla'a lirletgara ida (juru bahasa). ");
INSERT INTO lex_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Noma Yusup nwadur la gaini ralamni re na'nama nmeh'a nkakru. Nhor nioka nawali owa'an la re, ne nora rwahauru. Noka na'ala Simeon la ir mutnu de, noka nhopna rwutga Simeon la hare gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nhor nioka Yusup nhopna rahara metam la kadnu re, ne rima-rima kupanni re rkeni owa'ana la kadnu ralamni, ne wareherni la talan letgara mana ral walia hare. Emkadella ha rhi' nana rla. ");
INSERT INTO lex_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Nhor nioka rrana metamni rella keledaini wawannu noka rwaran la hande wa. ");
INSERT INTO lex_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Mela pa rden la rien geni, de la'pa riy ida newar kadnu pa niwra nalla keledaini na'ana, namkek de kupanni etla kadnu ralamni. ");
INSERT INTO lex_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Noka nakot la hyalli re: “Mimkeka, rpolla a kupnu, etla ka'du ralamni.” Noka ralamni re worworga, noma idma namkek la ida, de de rdiwra-rda'ala ne riwra: “Nee! Hya' ed mak Uplerlawna Nhi' nana mai it dina?” ");
INSERT INTO lex_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","La'pa rla'awa amni Yakopa la noha Kana'ana, dewade rwahaur nohora hya' maka rlernana, riwra: ");
INSERT INTO lex_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Riy mak kla'a upa-matrom la noha Mesir de nhoktemn ami ne nhi' am die emolmolla mak kla kwuw gen de. ");
INSERT INTO lex_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mere a lir mamni la, am di de riy ploloi-plele'er ami, mak kwuwu atia' ami. ");
INSERT INTO lex_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Am di de riy termida wehrani woru ampahyali, mere riy ida nmolu olekwa, ne gari miamni e nora am mamni pa erla Kana'ana.” ");
INSERT INTO lex_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Noka riy de niwra: “La hadi wawannu de nanpa agatga de miy di riy ploloi-plele'er miy me edonna, la'a mak kwahyali miy, mialtarga riy id mai a'u, nhor nianpena miodia metammi ri pa mlia'awa pa midarga lara la rommi mniotni. ");
INSERT INTO lex_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Dewade miodia hyalmi gar die mai a'u, nanpa agatga de miy di de mak kwuw atia'a mere riy ploloi-plele'er miy, ne pena apuolla hyalmi di tiy miy ne nhi'nanpena miy e mila' wewewar la noh di ralamni pa mpiadakna.”” ");
INSERT INTO lex_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Raltieri pia nhorwua noka la'pa rahgali kadnu rde ramkek de rima-rima kupanni genni erla kadnu ralamni, la'pa rora amni ramkek rewre'wa kupna re genni, dewade ramta'ata. ");
INSERT INTO lex_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ne amni Yakopa nakot la re: “A'na miy re, miy mhi' a' pua a'umolga a'nu re, Yusup edonan wa, pa Simeon mana edonan wa, dodo'ondi miwra miod wialia Benyamina. Rhi'a kwar lawan mai a'u.” ");
INSERT INTO lex_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Noka Ruben nakot la amni: “Papa, a'nu muanke'a rora pena mpuenna, la'pa a'g edon godia Benyamin tiy o'a. Mutiemna Benyamin la a li'mu ralamni, la' pena agodi uwal tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Mere Yakopa nwahla niwra: “Ama, a'nu di edon nor miy tialan pa mlia' rewre'wa, yoma kakni nmati olekwa, ne tre' ma'ta e nmemeh'a to'a, ne la'pa nlernana yatyatni-halalli yatlorni-yatra'ani la talan maka mliola, de de miy di ed mak kariei pia aghamtoto' nohor pa gerun la hoi-kietra ralamni de godia ralam mehra.” ");
INSERT INTO lex_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Mere lar de lawan rehi ma'ta. ");
INSERT INTO lex_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Pede la'pa metam maka ha rodia la Mesir de ra'ana pa nhorwua, dewade amni nakot la re: “A'nami re, mlia miweli owa'ana yamanna oke'a mai ita.” ");
INSERT INTO lex_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Noka Yehuda nwahla: “Ama, riy de nwagahniort ami niwra: “Miy di yana mimkek a ga'yu, la'pa garmi de edon nor rewre'wa miy talla.” ");
INSERT INTO lex_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Hade pede la'pa omuala gar miamni pa nor amtialla, de ampayow pa amla' hande ne amaweli yamanan tiy o'a. ");
INSERT INTO lex_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mere la'pa omuhmena mhuria pa nla'a, de am miana amahmena mla' hande, yoma riy de nakot olek la ami de: “Miy di yan mimkeka a ga'yu la'pa garmi de edon nor rewre'wa miy talla.”” ");
INSERT INTO lex_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Noka Yakopa niwra: “A'na miy re, nihya'pa miy miala wniarora-wnialai liawna mai a'u, onnila mikot la riy de, de garmi ida edama?” ");
INSERT INTO lex_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Rwahla riwra: “Yoma riy de natiana plu'wu-plehu ami la'a a inon mamni me a am mamni-hyali miamni, lup muamni-rom mamni, de natiana emkadi mai am die niwra: “Ammi nmormior mia'ta? Garmi erla?” Ne amakot momuou oleka honona la emeka plollolli. Emkameni pa amla mparor nana de, pena nhopan pa amodia gar mamni de pa mla e'a?” ");
INSERT INTO lex_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Noka Yehuda nakot la amni niwra: “Ame, muolin doin tuwgar die pa nor a' tialla, totpa ampahi'a-ampayod pia mla'awa, totpa tmormiori aplahwa, yana it hononita tmati. ");
INSERT INTO lex_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","A'g ed mak kakwar hade, la' pena mtio'ona hade mai a'u, la'pa a'g edon godia hade tiy o'a me awuagamtatna la gaimu ralamni, de a'g ed mak khi' do'a-kyap hial tiy o'a pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","La'pa it edon palo'on it mana, it talanni re'eni worg olekwa.” ");
INSERT INTO lex_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Noka amni nakot la re: “La'pa hade emkade de, mhi' emkadi: Mia'ala noh di wullu-we'elli mak samomuou muemna la'a kadmi ralamni, ne miodia la riy de emeka limtutmi. Miala ortawi-autiawi oke'a pa rala ratiaka mehrani, me oke'a mak huwnu mikmikri, me gani oke'a, na'itra duhru-lawruru wo'oni. ");
INSERT INTO lex_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ne miod kupna, mi'itar la pa liawanni re'eni woru. Kupan maka npolla la kadmi nurnu re, miodi owa'ana pa miwali, yanhi'pa nhiortaplin tio'a. ");
INSERT INTO lex_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Miod wialia garmi de, pa plet pa miwal lia riy de. ");
INSERT INTO lex_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Awuakwak de, Uplerlawna mak kodi plolli-ktaryatnu Nhi'a riy de ralamni pa nakwali, totpa ralam kalwiedwedni tiy miy, demade nolin doini hyalmi handin de nora Benyamina pa rawali. Mere la'pa rmol wua de, ah! Ariorta'ru olek hadewa.” ");
INSERT INTO lex_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Noka Yakop a'nani re ra'ala limtutnu rena, me kupna liawanni re'eni woru ralamni, na'itar wutu Benyamin wali pa rla'awa Mesir wa. La' noka rla rtutrier lia Yusup gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","La'pa Yusup namkek nana Benyamina nora re talla, noka nakot la mak khi' o'ta la e romni niwra: “Muodia riy ri, pa mlia'awa a ro'mu nayanni, mriotna nhiuri-wnia'ana id pa mpuahi' targa, yoma riy ri hota ror pa ma'an rewre'wa la lera pniahnani di.” ");
INSERT INTO lex_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Riy de nhi' emolmolla maka Yusup nakot targa la, de nodia riy re rla'awa Yusup romni nayanni. ");
INSERT INTO lex_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Noka riy re ramta'at wenna, yoma rodia pa rla'awa Yusup romni nayanni. Riwra: “Mak katota-kariei pia rod it la handi, de la' kupan maka ha rpolla la'a it kadnu la ululu de. Rod it mai handi totpa rtorn ita pa rhi' it la ata-wa'ara, me it keledaini re mana ra'ala.” ");
INSERT INTO lex_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Hade pede rrehgoru mak khi' o'tani la Yusup romni. Riy de etla romni de nhiarni gaini, noma rakot la: ");
INSERT INTO lex_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Ampak pa maltieri matroma. Am di ululu de ma mawelia yamanna. ");
INSERT INTO lex_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Mere la'pa am mte'ela gen miaka amanin la, ne am mpe'era kadu muamni nurnu, de mamkek nana rima-rima kupanni erla kadu nurnu de edonna npa'eini-npahala la maka ampairi oleka. Mere dodo'ondi amodia pa mawal wia. ");
INSERT INTO lex_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Kupna handina re mana amod wialia pa ralla rawel yamanna, amaplin niohora he' ed mak kenia kupna rella a kad muamni.” ");
INSERT INTO lex_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Mere nwahla niwra: “Mmiolmiolmi, yan mimta'ata, mak kla' Uplerlawna la miy miora ammi, Nal oleka tiy miy re'a-tniaru mak kdella kadmi ralamni, kupanmi re aliernan oleka la dodo'ona.” Raltieri pia nhorwua noka nalgota Simeon pa nod wutga rla. ");
INSERT INTO lex_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","La'pa riy de nodia rpa rla'awa Yusup romni nayanni, dewade nala gera pa ralla rohma lakni, ne keledaini re mana ralla ra'an wali. ");
INSERT INTO lex_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nhor nioka rwahi' targa limtutnu re, rweiya Yusup nmai lia lera pniahnani, yoma ratlin nan oleka de hota ra'an la hande. ");
INSERT INTO lex_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","La'pa Yusup npolan wa dewade rala limtutnu re rella Yusup la'a roma nayanni, noka rwaltiora-rwaltieman la. ");
INSERT INTO lex_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Nhor nioka natiana re niwra: “Miy e mkialwiedweda? Emkameni la ammi de e nkalwiedwed pa edama?” ");
INSERT INTO lex_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Rwahla riwra: “Matroma, atmu de, e nkalwiedweda.” Nhor nioka ruh' idma-rrama lia'ar la Yusup wa. ");
INSERT INTO lex_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","La'pa Yusup nakillia de, namkek nana garni Benyamina maka rrora inni ida, noka niwra: “Hadi de gari hoho'omi maka ha mikotkota mai a'u hadina?” Noka lirni la Benyamina niwra: “Awuakwak de Uplerlawna Nala ra'ani-pallu tiy o'a ama!” ");
INSERT INTO lex_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Noka plet pa Yusup nwaran la hande, yoma ralamni nmawal doin la, onnila ralamni nmayo'odoin la garni. Noma nahak gen pia la nkakur la. Noka nla'awa rialam la kamri pa nko'a-nkakur la hande. ");
INSERT INTO lex_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nhor nioka nla narar gaini noka nlergot wa. Natahan ralamni na'nama niwra: “Mhioi-mtian lia mei wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Noka rkenia Yusup ya'ana-yemannu la' genni ida, ne la'a hyalli re mana rwamueh' geni, ne makden Mesir mak ka'an rewre'wa re mana rwamueh' geni. Yoma makden Mesir re yana ra'an wut lia makden Ibrani, yoma yehwa mak emkade makden Mesir makriarni. ");
INSERT INTO lex_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yusup nhopan pa hyalli re ramtatna la Yusup gaini ralamni, ntawua yanulu pa nodia pa ntut lia gari, nhi'nande idma ramkek la id de ema rtaplelleltarga. ");
INSERT INTO lex_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Noka ra'ala ya'ana-yemun mak kdella Yusup meini wawannu pa rkenia la hare meini wawannu. Mere maka Benyamina nlernana rde liawanni narehi re'eni wolim ralamni la hyalli re. Noka ra'an wutu-remun wut lia e'a, me ramuki-rahepur wut rewre'wa la. ");
INSERT INTO lex_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nhor nioka Yusup nhopna mak kla' o'ta la mak kar lia romni niwra: “Muahar metam la hare kadnu, wo'ira-wo'ir de nlernohor rurni pa rodia, ne mkienia rima-rima kupanni maka ral oleka a' die, la rima-rima kadnu nurnu. ");
INSERT INTO lex_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ne lari maha wawahra maka aniair de, mkienia la gari kenkenna kadnu ralamni la metma walli heyanna, ne kupna metamni welli wali.” Noma nhi' emolmolla Yusup nhopan targa la. ");
INSERT INTO lex_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","La'pa lera matni npah'a, de riy rma rollia pa rla'awa ra'itar wutu keledaini re. ");
INSERT INTO lex_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Mere la'pa na'nama rhargot la let de, edon oliet ma'ta, dewade Yusup nakot la mak kla o'ta la e romni de niwra: “Mlia' pa mhuokra riy re, ne la'pa mdiamit nana rde, mukot la re: “Nihya'pa miala yatni ma mpiahla riy kalwiedni? ");
INSERT INTO lex_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Edon miatga de, lari die matro'mu nnairia pa nemun la, ne nhi' de nnairia pa nhi' rehera? Miy e mhi'a nhiol yatyata la ilu-yehwa mak emkare.”” ");
INSERT INTO lex_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Noka nla'awa. La'pa ndamit nana re dewade nakota hya' maka Yusup nakot targa la. ");
INSERT INTO lex_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Rwahla riwra: “Matrome! Nihya'pa matro'mu nakota hihi'a-yapyap miak emkadena? Oliet am lia nhiol miak emkade. ");
INSERT INTO lex_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kupan makden kadu nurnu mana amodia mtawua Kana'ana pa mpolla! Nhi'wal pia amla mkamna'a maha-maha wawahra la matrommu romni?! ");
INSERT INTO lex_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","La'pa mliernana lari diella he'-he'ela atmu am di, de ndella pa nmati, ne am di pena am la'a atmu-wa'armu.” ");
INSERT INTO lex_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Noka Yusup hopopanni de nakot la re: “Yowa, hyal miy re, wakwakmi de samoga, mere la'pa aliernana lar diella he' de, hade nmeh'a nla' a'tu, ne korni miy die rolin miy lia' hala wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Noka pleta-plet pa rima-rima ralernia kadnu re nhor nioka rharia. ");
INSERT INTO lex_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Noma mak kla' o'tani la rom de nloha-nlil samomuoga, nala' ul lia yanulu pa nod lia gari, dewade rlernana lari maha wawahra della Benyamina kadnu ralamni. ");
INSERT INTO lex_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Dewade rlihirrawria rayanni re (yoma ralamni re rmawaldoinla), ne rima-rima rran owa'ana kadnu la keledaini re wawannu, ne rawal lia Yusup letni. ");
INSERT INTO lex_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","La'pa Yehuda nora hyalli re rte'ela Yusup romni ralamni, de Yusup ed ma'ta la hande, dewade honona rwaltiora-rwaltieman la gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusup nakot la re: “Hya'a nhiol miaka ha mhi' nan dina? Miy edon miat niohora la'a riy ida emek a' di, de agatu ghi' rehera totpa agat niohora hya' maka miy mhi'a de?” ");
INSERT INTO lex_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Nhor nioka Yehuda naltier pia niwra: “Hya' mak hota amakota la matro'mu, hya' maka hota ampahla, ne amala hya'a la ma mhi'a plola a inon mamni? Uplerlawna Nalhari oleka atmu a do' mamni-hal mamni. Noma am di de matro'mu atni ami, ami me riy maka rlernana lari diella.” ");
INSERT INTO lex_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mere Yusup nwahla niwra: “Olieta mai a'u lia hihi'a-yapyap miak emkade. La'pa rlernana lari diella he' de, hade ed mak kla'a a a'tu, mere miy di mliol kalwiedni pa miwal lia ammi.” ");
INSERT INTO lex_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Noka Yehuda naprir pia nwakriania Yusup na'nama niwra: “Mtiulan pa mrieililili-mua'mamuau atmu a li'ru, awuak de yana muwenna yoma matro'mu de emekwali Firaun. ");
INSERT INTO lex_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Matro'mu natian olek la atmu ri: “Hyalmi me ammi ed ma'ta la?” ");
INSERT INTO lex_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Noma ampahla matro'mu miwra: “Amtaru mua'ta ama mak khamto' olekwa, ne a'nani gari mana ed wal lia, maka rmor niana la mto'oni-pe'eni. Kakni nmati olekwa, tre' ma'ta to'a ha nmeh'a la ir maka inni ida, nhi' pede a am mamni ralamni nal ralam kalwiedwedni nal toto'ola”. ");
INSERT INTO lex_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Noka matro'mu nakot la atmu am di niwra: “Miodia mai a'u totpa ma'tu namkek memna”. ");
INSERT INTO lex_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Mere ampahla matro'mu: “Tuwar die ta'en niana naltarga amni, yoma la'pa naltarga amni, de hota amni de nmat tioto'a”. ");
INSERT INTO lex_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Noka matro'mu nakot owa'an la atmu ami niwra: “La'pa garmi de edonna ma miora talla, de yana mia mimkeka ga'yu di owa'ana”. ");
INSERT INTO lex_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","La'pa amawal lia atmu a am mamni, dewade ampahaur nohora matro'mu lirni della. ");
INSERT INTO lex_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Noka lera ida a am mamni niwra: “A'na miy re, miwal pia miwel niana yamanna oke'ela mai ita”. ");
INSERT INTO lex_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Mere ampahla: “Ami edonna mla' hande. La'pa a gari miamni nor am tialla pa amla' rewre'wa, nanpena amla' hande, yoma am di ta'en niana amamkeka matro'mu gaini, la'pa gari hoho' mamni edon nor rewre'w amtialla”. ");
INSERT INTO lex_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Nhor nioka atmu a am mamni nakot mai ami: “A'na miy re, miat niohora de, ha'wu na'a'na nan keke'eni woru mai a'u. ");
INSERT INTO lex_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ida naltarg a'u olekwa, ne a'ukot olekaw de: “Toto' meman pa porni-dawarni rlihira-rnai oleka wa ne la'pa dodo'ondi mana edon umkek owa'ana.” ");
INSERT INTO lex_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","La'pa mia' owa'an la keke'en di, ne hota nlernana yatyatni-halalli yatlorni-yatra'ani, hota miy mhi' a' pua aghamto' olekwa di pa muati, agodi ralam meh'ru.” ");
INSERT INTO lex_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Noma dodo'ondi, la'pa atmu alia'awa a a'mu, mere a gar miamni de edon nor rewre'wa am tialla, de la'pa a a'mu namkeka gari miamni de edon nora de hota nmati, yoma a'mu ta'en niana nmormior la'pa a gar miamni edon nora. Hota atmu am di mariei pia a' am mamni mak hamto'a de nmat die nodia ralam mehrani. ");
INSERT INTO lex_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mere atmu a' di, ukwar oleka gar mami della a'mu nora li'ru: “La'pa a'g edon godia pa uwal niohora la a'mu, de a'g ed mak khi' do'a-kyap hial la a'mu pa nodi liarni”. ");
INSERT INTO lex_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Hade pede, samounu de, atmu a' di wuarin pia ghi'a at la matro'mu, aghernia a gari miamni di, ne muollia gari miamni de nora hya'lu re pa rawal wia. ");
INSERT INTO lex_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Yoma emkameni pa a'uwal lia a'mu la'pa tuwgar die edon nor a'u tialla? A'g edonna tiahan pa umkek reria yatyatni-halalli yatlorni-yatra'ani ntuin nan a'mu.” ");
INSERT INTO lex_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","La' ler de de, Yusup ta'eni ntahan nana ralamni la'a hopopanni-lili'irnu rahu mak ktutrier lia onni, noka nhaun pa niwra: “Mhuopna riy honona ri rlergot la handi.” Hade pede riy dom id mana edon nora Yusup rden rewre'wa hande, la'a ler maka ntutga rupni la hyalli re. ");
INSERT INTO lex_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Mere nkakur doin la, nhi'nande makden Mesir ratlin nana, me ray romni mniotni ratlin nohor wal lia. ");
INSERT INTO lex_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ne Yusup nakot la re: “Hyal miy re! A' di Yusup a'u! It amni e nmormior mia'ta?” Mere hyalli re ta'en niana rwahla, yoma rdella gaini ralamni de ramta'at wenna. ");
INSERT INTO lex_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Noka Yusup nakot la hyalli re: “Mia mriehgorgorga.” Noka rma rrehgoru. Nakot owa'an la re: “Hyal miy re, a' di de Yusup a'u, hyalmi a'u, maka mi'olga la Mesir de. ");
INSERT INTO lex_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Mere ler di, de yana mimawal ralammi, ne yana miehela inonmi, yoma mi'olg a lia handi. Yoma Uplerlawna Nhopna a'ula' ul lia handi, totpa Nalewna riy mormiorni-dardiarni. ");
INSERT INTO lex_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yoma nala' nohora anni wornu la lar dilla noha di, ne tre' ma'ta anni wolim ma'ta de, riy ta'en niana rwal tiani me rreiki-rwo'ora. ");
INSERT INTO lex_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Hade pede Uplerlawna Nhopn oleka a'ula' ul miy, totpa duratmi-waitmi ler li'iru mai noh di wawannu de ed ma'ta la, ne totpa ralewna mormiormi-dardiarmi, nhi'nande liawanni tiy miy mliernana mormiori-dardiari. ");
INSERT INTO lex_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Pede plolli de, miy edonna mhiopn amuai lia handi, mere Uplerlawna mak khopna a'u. E'a ed mak kwagamtatna a'u emeka ama id la Firaun, ne matrom la romni nayanni honona, ne mak kodi plola-ktaryat lia Mesir noh tetema. ");
INSERT INTO lex_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Plet pa mlia'awa it amni, ne mikot la: “A'namu Yusup lirni hadi, de Uplerlawna Nkeni olek Yusup pa emeka Mesir tetema matromni, omlia' pa mpuatrom Yusup, yana prei-pre'eta. ");
INSERT INTO lex_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Hota mdiella Gosyen lowanni, ne hota mriehgorgorga Yusup, omuora upmu-a'namu, nhiurmu-wnia'anmu me re'emu-tniarmu honona. ");
INSERT INTO lex_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","La' hande pena Yusup ntera-ndem ita yoma lar di tre' ma'ta anni wolim ma'ta, totpa yana itler la rehka-lara, de de muor wutga rommu mniotni, ne it hononita mak kor o' talla.” ");
INSERT INTO lex_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Hyal miy re, mieh'a miala matmi mimkek oleka, ne la'pa ga'ru Benyamin wali, de de a' di de Yusup nmeh'a maka nakot oleka tiy miy. ");
INSERT INTO lex_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Hade pede mpiahaur la'a it amni, de Mesir mniotni di ruh' idma-rrama lia'ara mai Yusup, me haneka-harah muaka mimkek oleka, nhor diemade plet pa miodia it amni mmiai wia.” ");
INSERT INTO lex_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Noka nkolla garni Benyamina tiernu, noka nkakur doin la, ne Benyamin mana nkakur la Yusup wawayanni wawannu. ");
INSERT INTO lex_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yusupa nkinnia hyalli re honona re, ne nkakur pa nkolla re. Nhor nia'nama hyalli re rora rwahauru. ");
INSERT INTO lex_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","La'pa rod kiota-ral de'et la Firaun romni ralamni de Yusup hyalli re rmai, Firaun nora tniutnu-nhianni-nhielli-liarni re rreiniana-ra'nana la'a kalwieda-paitiota ralamni. ");
INSERT INTO lex_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Noka Firaun nakot la Yusup: “Mukot la hyalmu re pa rhi' emkadi. Rkenia ya'ana-yemun la nhiurni-wnia'anni re wawannu pa rla'awa Kana'an wa, ");
INSERT INTO lex_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Rpolu amni, me romni mniotni honona rpa rma rwatrom a'u, pena agala gen miaka samounu meman la Mesir dilla miy, nhi'nande ir ror pa mi'in la noh di wullu-we'elli. ");
INSERT INTO lex_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Aghopan wal pia mukot la re, miwra rhi' emkadi, irodia keretni no' Mesir re pa rodia hawni-a'nani, ra'ala ammi la hande pa rodi rmai wia handi. ");
INSERT INTO lex_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Yana ralamni rmawal nohora hyonni-hyanni maka ha raltaru re, yoma hya' maka samounu meman la Mesir lowanni di de ir gahani hare.” ");
INSERT INTO lex_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Emkadella hya' maka Yakopa (Israel) a'nani re rhi'a-ryapia. Yusup nala kereta la, nlernohora Firaun nhiopanni, ne nal wali wareherni. ");
INSERT INTO lex_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","La'a hyalli re Yusup nala rima-rima gahani naniairi ida, Mere la' Benyamin de rala kupna harahu, de maha wawahra rahu wotelu me naniairi ananni wolim la. ");
INSERT INTO lex_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ne la' amni de na'enyatga keledai termida, rkenia hya' maka samounu meman la'a Mesir dilla wawannu, ne keledai rara termida, rodia metma, me roti la amni wareherni ne hya' hya' to'owa pa ra'ana la talan letgara. ");
INSERT INTO lex_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Nhor nioka nolin doinia hyalli re na'nama nano'a niwra: “Yana miwo'or la talan letgara.” ");
INSERT INTO lex_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Emkadella rwaran la Mesir pa rla'awa Kana'an wa, la amni Yakopa. ");
INSERT INTO lex_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Rla' pa rwahaur la amni riwra: “Ama, Yusup e nmormior mia'ta, yaho'ma e' mak kodi plolli la Mesir noh tetema.” Mere Yakopa ralamni nwoktiltilu, yoma edonna npesiay hare. ");
INSERT INTO lex_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Mere la'pa rwe'er nohor samomuou Yusup lirni honona, ne la'pa namkek nana keret maka Yusup na'enyatu re totpa ralla rwatroma pa rodia, dewade Yakopa ralamni nmori owa'ana. ");
INSERT INTO lex_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Yakopa naltieri niwra: “Dodo'ondi na'nama agat wua de, a'nu Yusup e nmormior mia'ta, agiwra lia umkeka, la'pa a'g edonna muat mia'ta di.” ");
INSERT INTO lex_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yusup nnio'oni na'itra hya' maka ha na'enyatga la amni, nreiniande Yakopa nwaran pa nodia re'eni-tniarnu honona noma rte' tar lia Bersyeba, noka nwunu-nwenan pa nhi'a la nhioi-tniani la mak kla' Uplerlawna la amni Isaka. ");
INSERT INTO lex_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Noma mela ida Yakopa ndarat nana Uplerlawna lirni Niwra: “Yakopa! Yakopa!” Nwahla niwra: “Hya'a Matroma.” ");
INSERT INTO lex_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Noka Uplerlawna lirni: “A' di de mak khi' Uplerlawna la ammu A'u, yana mumta'ata mlia'awa la'a Mesir, yoma hota Aghi'u pa omuor duratmu-waitmu mlia'a hair lawna id la hande. ");
INSERT INTO lex_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Amueh'a gor o' talan pa mlia'awa Mesir, ne A'g ed mak kodi o' pa kawali, ne Yusup limni ed mak kato'ma matmu ulatni.” ");
INSERT INTO lex_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Noka Yakopa nwaran la Bersyeba ne Yakopa a'nani re rodia amni ra'itar wutu ir hawni-a'nani, ne honona rnairia keret maka Firaun na'enyatua pa Yusup amni rodi rla'awa Mesir. ");
INSERT INTO lex_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Rod wialia nhiurni-wnia'anni honona me re'eni-tniarnu maka ha rlernana la Kana'ana yapatni. Noka rte'ela Mesir wa de Yakopa nora duratni-waitni re honona. ");
INSERT INTO lex_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Upni-a'nani re patke'a rora muanke'a, duratni-waitni re honona rodi momuoga la Mesir. ");
INSERT INTO lex_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yakopa, mak Uplerlawna Nwet walia nanni de Israel, duratni-waitni mak kmai lia Mesira de kotni-nanni emkadille: Yakopa a'nani yanulu de Rubena, ");
INSERT INTO lex_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben a'nani de: Henoka, Palu, Hesron ne Karmi. ");
INSERT INTO lex_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Mak klernohora Ruben de, Simeon. Simeon a'nani rde: Yemuel, Yamin, Ohad, Yakhin me Sohar na'itra Saula. Mere Saul di, patke'a Kana'ana id a'nani. ");
INSERT INTO lex_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Mak klernohora Simeon de, Lewi. Lewi a'nani de: Gersona, Kehat me Merari. ");
INSERT INTO lex_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Mak klernohora Lewi, de Yehuda. Yehuda a'nani de: Er, Onan, Syela, Peres me Serah. Mere Er nora Onana rmat tiar lia Kana'ana. Peres a'nani de, Hesron nora Hamul. ");
INSERT INTO lex_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Mak klernohora Yehuda de, Isakar. Isakar a'nani de: Tola, Pua, Ayup me Simron. ");
INSERT INTO lex_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Mak klernohora Isakar de, Sebulon. Sebulon a'nani de: Sered, Elon, me Yahle'el. ");
INSERT INTO lex_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hare honona de, Yakopa hawni Lea duratni-waitni, maka nayor niana la'a Padan Aram na'itra Dina, de a'nani patke'a wali. Pede patke'a rora muanke'a honona de, liawanni de, terampwotelu wehrani wotelu. ");
INSERT INTO lex_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","(Yakopa hawa liahunu Silpa, a'nani yanulu Gad.) Noka Gad a'nani de: Sifyon, Hagi, Syuni, Esbon, Eri, Arodi me Areli. ");
INSERT INTO lex_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Mak klernohora Gad, Asyera. Asyera a'nani de: Yimna, Yiswa, Yiswi me Beria. Serah de, hare narni patke'a. Noma Beria a'nani rde, Heber me Malkiel. ");
INSERT INTO lex_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hari honona de Silpa duratni-waitni de mak kayoria upa-a'na la Yakopa. Silpa de ata pat maka Laban nala la a'nani Lea. Silpa duratni-waitni honona de termida wehrani wonema. ");
INSERT INTO lex_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakopa hawni Rahela a'nani de: Yusup nora Benyamina. ");
INSERT INTO lex_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","La'pa Yusup ndella Mesir, Yusup hawni Asnata na'a'na nana Menasye nora Efraim, la' ler maka Asnata amni Potifera nhi' rieher la leta Ona. ");
INSERT INTO lex_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamina a'nani de: Bela, Bekher, Asybel, Gera, Na'aman, Ehi, Rosyi, Mupim, Hupim me Ared. ");
INSERT INTO lex_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hari de Rahela duratni-waitni, maka na'a'na nana la Yakopa, honona re liawanni termida wehrani wogata. ");
INSERT INTO lex_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","(Yakopa hawa liahunu Bilha, a'nani yanulu de Dan). Dan a'nani de: Husima. ");
INSERT INTO lex_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Mak klernohora Dan, Naftalia. Naftalia a'nani de: Yahseel, Guni, Yeser me Syilem. ");
INSERT INTO lex_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hari honona de Bilha duratni-waitni mak kayor niana rella Yakopa. Bilha de ata pat maka Laban nala la a'nani Rahela. Bilha duratni-waitni honona de, liawanni riy wo'itu. ");
INSERT INTO lex_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Riy honona mak kora Yakop pa rla'awa Mesir de a'na raralamni, edonna rrekan wutga la Yakopa a'nani re hawni. Liawanni honona de terampwonema wehrani wonema. ");
INSERT INTO lex_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Yusup a'nani maka rayor niana la' Mesir de woru. Pede Yakopa luwnu mak kdella Mesir de honona, liawanni terampwo'itu. ");
INSERT INTO lex_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Noka Yakopa nhopna Yehuda nala' ul pua nwatroma Yusup, totpa natiana Gosyen etla walli meni? Nhor nioka rte'ela Gosyen wa. ");
INSERT INTO lex_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Noka Yusup nwahi'a keretni noka nla'awa Gosyen wa, nwatroma amni. La'pa nwatrom nana, dewade nkolla amni tiernu ne nkakur la amni wawayanni pa nodia pa mahneka. ");
INSERT INTO lex_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yakopa (Israel) nakot la Yusup: “Ama, dodo'ondi de awuayow pa muat wia, yoma a'umkek nana gaimu me agatga de o' e mmuormior mia'ta.” ");
INSERT INTO lex_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Nhor nioka Yusup nakot la hyalli rena me amni luwnu-a'nani re: “Ama-hyal miy re, a'ukotiwra lia'a Firaun de pa ukot targa la'a hya'lu me a'mu luwnu-a'nani mak kdella noha Kana'ana rmai olekwa, ");
INSERT INTO lex_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","hare de mak kodi pipi-duma, yoma hare honona rde maka khuri-kwa'ana nhiuri-wnia'ana. Nhiurni-wnia'anni me re'eni-tniarnu honona de rodi momuoga. ");
INSERT INTO lex_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","La'pa Firauna npolu pua natian miy die, hota niwra: “Mimkiari hya'a?” ");
INSERT INTO lex_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Mpiahla miwra: “Atmu am di de a kniaria tnietihor mamni de amhuri-mpa'ana, la'a a kuku' memn ami, nodia pa dodo'ondi, emeka up mamni-tgar mamni rhi'a.” Mikot emkade totpena Firaun nolin doin pa mdiella Gosyen lowanni. Yoma makodi pipi-duma de makden Mesir rmakriarnia re.” ");
INSERT INTO lex_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Nhor nioka Yusup nla nod kiota-nal de'eta la Firaun de: “Matrome, a'mu nor hya'lu re me nhiurni-wnia'anni me re'eni-tniarnu re honona, rtawua Kana'ana pa rmai olekwa, dodo'ondi de erla Gosyen lowanni.” ");
INSERT INTO lex_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","La amni-hyalli re Yusup ntutg oleka riy wolim pa nodia rla rharlira-rgotgai la Firauna. ");
INSERT INTO lex_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Firaun natiana Yusup hyalli re niwra: “Ama-hyal miy re, miy kniarmi hya'a?” Rwahla Firauna: “Matroma, atmu am di de mak kodia nhiuri-wnia'ana, emeka up mamni-tgar mamni. ");
INSERT INTO lex_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ammai pia mdella noh di emeka do'ona-dakna, yoma la hande lowan poti-wewan mota nkerna-nhau niana ami pa mala mpua'ana nhiuri-wnia'an mamni ri, onnila lar de lawan rehia la Kana'ana. Hade emkade pede ler di de a wakwak mamni de, matro'mu nwayow nohor am pia, amdella Gosyen lowanni.” ");
INSERT INTO lex_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Noka Firauna nakot la Yusup niwra: “Ammu me hyalmu re rmai tiemn olek tiy o'owa. ");
INSERT INTO lex_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Noha-rai Mesir nahniarniar tiy o'a. Mtiutga la ammu me hyalmu re gen miaka samounu muemna pa rdella' noha-rai di, de rdella la'a Gosyen lowanni. Ne la'pa omuatga de la' hare de riy mak katu ktorna nhiuri-wnia'ana, muala pa rhi'a mak katiaka nhiu'ru-wnia'anu.” ");
INSERT INTO lex_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yusup nodia amni Yakop pa rla rhari lira-rgot gai lia Firauna. Noka Yakopa nwak pa Uplerlawna Nala ra'a-palu la Firauna. ");
INSERT INTO lex_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Nhor nioka Firaun natian Yakopa: “Ame, mormiormu di anni wo'ir olekwa?” ");
INSERT INTO lex_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakopa nwahla Firauna: “Anni-anni maka alioldoi-lioldai emeka do'ona-dakna de liawanni anni rahu ida terampwotelu. Anni mormio'ru ri, de hota edon naplahwa ne npenpuenu-nanahala ihru mehra-ralam mehra, edon nora u'pu-tga'ru re anin mormiorni rella lioldoini-lioldaini ramneneha.” ");
INSERT INTO lex_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Noka Yakopa nwaka Uplerlawna Nala ra'ani-pallu la Firauna, nhor nioka nwadur la Firaun gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yusup ntutga la amni me hyalli re, gen miaka ha rdella la'a noha Mesir, ne nala nohanna-taniarat dilla re, emolmolla Firaun ne'er targa. Gen di samomuou memna, ne nwawa Gosyen lowanni-ahlani, mak ler li'ir di rweta de Rameses. ");
INSERT INTO lex_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ne Yusup npiara-nlakoi amni, hyalli me romni mniotni re, nhakra yaya'anni de nlernohora a'nani re liawanni. ");
INSERT INTO lex_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","La' noha-rai de uhunu-ewatni-ewatni-lahwani de ha yaya'ana hamonna, yoma lar de lawan rehia, nhi'nande Kana'ana nora Mesir mniotni re rmatloi-rmatlawra. ");
INSERT INTO lex_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Noka Yusup nawoka kupna mak kdella Mesir me Kana'ana honona, de kupna metma welli. Noka Yusup nodia kupna re honona la Firauna romni. ");
INSERT INTO lex_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","La'pa kupan no'a Mesir me Kana'ana rhorwua, dewade makden Mesir re honona rma rawok la Yusup gaini na'nama riwra: “Matrome, muala ha yaya'an mai ami! Nihya'pa hota ammat lia gaimu ralamni?! Yoma kupna hamon et wia.” ");
INSERT INTO lex_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusup nwahla niwra: “Ina-nara ama-hyal miy re, la'pa kupanmi rhorwua, miala nhiurmi-wnia'anmi, nanpena agala ha yaya'an tiy miy emeka nhiurmi-wnia'anmi re yawahlani.” ");
INSERT INTO lex_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Noka rodia nhiurni-wnia'anni rla Yusup, ne Yusup nala ha yaya'an la re, nala nawahla kuda-keledai, pipni-dumni, hayorni-orpaunu (sapi), pede nwahi' taru ha yaya'an la re, de de anin de ha yaya'an etla pa hare ra'ana yoma Yusupa nala yamanna nwahla nhiurni-wnia'anni honona. ");
INSERT INTO lex_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Lardoini anin della, dewade rmai owa'an la, la'a anin mak kod lia wornu, noma rakot la: “Yana amade'a la matro'mu, la'pa a kupan mamni rhorwua ne la'pa a nhiuri-wnia'an mamni rla matro'mu gahani, de hya' mana edonna rwarin pia amala la matro'mu, enekneka a inon mamni me nohanna-taniarat mamni. ");
INSERT INTO lex_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Amahmena ammati, amahmena a nohanna-taniarat mamni niata. Muwel ami me, nohanna-taniarat mamni, emeka ya'ana-yemnu nhierannu, noma ami me, nohanna-taniarat mamni rla'a ata-wa'ar la Firauna. Muala wini totpa ammormiori, yana ammati, ne totpa tani re yana rkerna-rkaulu.” ");
INSERT INTO lex_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Hade pede Yusup nawelia makden Mesir re tanni re honona rla Firauna, yoma makden Mesir re rima-rima ra'olga nhyi'ini, yoma lar lawan de nwewar nana re. Emkadella pa tani re Firaun nhi'a la gahani. ");
INSERT INTO lex_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ne la'a Mesir lowanni ntawua honi id pa nokru honi de, Yusup nwa'ata-nwa'ara riy honona. ");
INSERT INTO lex_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Eneknek to' pa makpolwunu-kwaklera makden Mesir re nohananni-taniaratni de, Yusup edon nawelia, yoma makpolwunu-kwaklera rde rlernana nhiakra la'a Firauna, ne rmor lia nhiakra wawannu, hade pede edon ra'olga tanni re. ");
INSERT INTO lex_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusup nakot la leta-leta mniotni re: “Ina-nara ama-hyal miy re! La' ler di, de a'uweli olek miy, me tanmi rella Firauna. Dodo'ondi, de agala wini tiy miy totpa mtiamnia la nhyi'imi re. ");
INSERT INTO lex_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","La'a wullu-we'elli, mhiakra la nhiakra wolima, nhor nioka miala ida la'a Firauna ne nhiakra wogat de rdella pa rla' win lia nhyi'imi re, me rla'a ha yaya'anmu la rommu mniotni honona.” ");
INSERT INTO lex_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Noka rakot la: “Matroma, ndella pa amla'a ata-wa'ar la Firauna, hornama amlernan oleka matro'mu ralam kalwiedni pa mtiera-mdiema a mormior miamni.” ");
INSERT INTO lex_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Emkadella pa Yusup nhi'a hadella tita ida, la'a Mesir lowanni-ahlani nodia pa dodo'ondi de, de nhiakra id la nhiakra wolimni nala la'a Firaun gahani, eneknek to'a makpolwunu-kwaklera re nohananni-taniaratni nanpa edonna rla'a Firaun gahani. ");
INSERT INTO lex_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Noma makden Israel re, de Yakop nor duratni-waitni rden nek la Mesir la'a Gosyen lowanni, ne raweli tanni la hande. Ra'upa-ra'a'na ne rpeha-rlawan pa harahu. ");
INSERT INTO lex_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ne Yakopa nmormior mia'ta pa umarnu na'itar la anni termida wehrani wo'it lia Mesir nohananni-taniaratni, noma Yakopa anni-anni mormiorni-dardiarni ntut niana anni rahu ida terampwogata wehrani wo'itu. ");
INSERT INTO lex_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","La'pa ntut lia lerni pa Yakopa nwahi' pa nmat wia, dewade npolga a'nani Yusup pa nakot la: “Ame, la'pa aliernana ralam kalwiedmu de mkien limmu la a kowru onni ne mliokar mai a'u, de de omtiutga ralam kalwiedmu me, yehwa ploloi-plele'ermu mai a'u, de yana midera a lia liena ralamni la Mesir di. ");
INSERT INTO lex_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mere la'pa amuat pia uwok wutu u'pu-tga'ru, de mrian a lia Mesir di pa midera la liena la u'pu-tga'ru re hoini-kietarni.” Nwahla niwra: “Yowa ama, pena aghi'a hya' maka mukot oleka re.” ");
INSERT INTO lex_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Nhor nioka Yakopa niwra: “Mliokar mai a'u.” Noma Yusup nlokar la. Noka Yakopa nwaltior la lewnu o'tani walli pa na'uli-nawedia Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Lera ida ne riy doma rakot la Yusup: “Ammu e namehra!” Hade pede nodia a'nani re rora, Menasye nora Efraima pa rla'awa amni genni. ");
INSERT INTO lex_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","La'pa rod kiota la Yakopa riwra: “A'namu Yusup e nmai o' de.” Noka Yakopa nawoka rurni-laini korkorni honona pa namtatna la yanin genni wawannu. ");
INSERT INTO lex_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yakopa nakot la Yusupa: “Ama, Uplerlawna mak kodi plolli-ktaryatnu Ntutg oleka rupni mai a'u, me Nara'a-napalg a'u la'a leta Lusa (maka awuet la, de Betel), la'a Kana'ana yapatni. ");
INSERT INTO lex_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Na'nama Nhar lirni de mai a'u Niwra: “A'g ed maka khi' o' pa mu'upa-mu'a'na, ne pena A'u ghi'u pa mu'itra-mulawna, ne duratmu-waitmu rla'a hairi wokni ida. Agala noha-rai di la omuora duratmu-waitmu pa mhi'a la gahami pa nodi liarni.”” ");
INSERT INTO lex_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Yakop nakot owa'an la Yusup niwra: “Ama, a'namu rora maka rayoria la Mesir di, la'pa a'g edonna mmuai mia'ta la Mesir di, de a gah'u hare, a gah'u Efraim nora Menasye emolmolla Ruben nora Simeona. ");
INSERT INTO lex_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ne a'namu maka omliernana la' li'iru, de gahamu hare, mere rlernana durmu-nhiakra re'a-tniaru de, la'a re'a-tniaru mak agala la ir hyalli Efraim nora Menasye. ");
INSERT INTO lex_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Yoma ler ululu de, itwatiawu Padan Aram pa tmai, de itden ma'ta la talan letgara, la Kana'ana lowanni, rehgorga leta Efrata. Noka a ralmu nmawal doin la yoma a ha'wu Rahela nmati. Nhor nioka atiamnia la talan mak kokru Efrata aratni,” de Betlehema. ");
INSERT INTO lex_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Nakot pa nhorwua, noka la'pa Yakopa namkek tutga Yusup a'nani re, dewade natiana: “He' era rina?” ");
INSERT INTO lex_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yusup nwahla amni: “Hari de a a'nu maka Uplerlawna Nala mai a lia handi, ama.” Noka Yakopa niwra: “Muodi mmuai a'u totpa awuaka Uplerlawna Nala ra'a-pal lia re.” ");
INSERT INTO lex_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ne Yakop de matni npona, onnila nhamto'owa, pede ta'eni namkek nan samomuou. Noka Yusup nala pa rehgorga amni, noma amni nkolla rpa nkinnia re. ");
INSERT INTO lex_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Noka Yakopa nakot la Yusup: “Ame, ler ululu de a'g edonna wuaror nana, de hota a'umkek nan owa'ana gaimu, mere ler di, de Uplerlawna Nal a' pua umkek o'a na'itar neka a'namu wali.” ");
INSERT INTO lex_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Noka Yusup nodgiota a'nani rella amni torni rletni, na'nama Yusup nwaltiora-nwaltieman la. ");
INSERT INTO lex_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Nhor nioka Yusup ntorreria a'nani rora, limni malganna ntorreria Efraima, de Yakopa walli malwiru, ne Yusup limni malwiru ntorreria Manasye la'a Yakopa walli malganna, noka notlia rpa rwakriani. ");
INSERT INTO lex_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Mere Yakopa netra limni malganan pa nlapra la Efraim o'tani wawannu, kennama a'na garia, ne limni walli malwir lia'a Manasye o'tani wawannu pede limni nhawlakra, kennama Manasye de a'na yanulga. ");
INSERT INTO lex_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nhor nioka nwaka Uplerlawna Nala ra'ani-pal lia Yusup niwra: “U'pu Abrahama me a'mu Isaka rmori olek la Uplerlawna gaini ralamni. Uplerlawan di emolmolla Uplerlawna mak kla'a makodi a'u la'a mormio'ru la ululu pa nod nieka pa dodo'ondi. ");
INSERT INTO lex_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ne Uplerlawna Ntutga rupni emolmolan neka Uplerlawna hopopanni-lili'irnu maka namori-nalewna a lia yatyatni-halalli yatlorni-yatra'ani honona. Awuakwak de Uplerlawan di ed mak kara'a-kapalga tuwgari ri, nhi'nande na'nu na'itra a'mu Isaka nor u'pu Abrahama nanni rwewar noha onnila hari, ne Nreiniande hari duratni-waitni ra'ititar rer lia pa rla'a wok lawna-le'u liawna la nohkeran di wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","La'pa Yusup namkek de amni nlapra limni malganan la a'nani Efraima o'tani wawannu, nwarora de emkade de yata, noka nte'la la amni limni totpa nwareiya limni la'a Efraim o'tani wawannu pa nkenia la Manasye o'tani wawannu. ");
INSERT INTO lex_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Nakot la amni: “Yana mhi' emkade ama, yoma hadi de yanulga, pa mliapra limmu malganan la o'tani.” ");
INSERT INTO lex_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mere amni nwayotlia niwra: “Edonna. Agat muemna de hadi de yanulu, ne hade mana duratni-waitni hota nla'a hairi ida ne hota lawna la plola-mneha, emkameni mana garni plolli-mneheni narehi-nalawan la, ne garni de duratni-waitni hota nla'a hairi-hairi liawanni.” ");
INSERT INTO lex_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Noka nwak pa Uplerlawna Nala ra'ani-pallu la niwra: “La'pa makden Israel hota riwra rwaka Uplerlawna pa Nala ra'a-palu, de riwra: “Uplerlawna Nala ra'a-palu emeka Efraim nora Manasye ra'ani-pallu.”” Emkadella pa nala gari Efraim pa nala' ulu yanulu Manasye. ");
INSERT INTO lex_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nhor nioka Yakopa nakot la Yusupa niwra: “Ame, edon nalo'on wali de hota amuat wia, mere pena Uplerlawna Nor miy talla, ne Nod miy pia miwal lia upa-tgarmi re nohananni-taniaratni. ");
INSERT INTO lex_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ne dodo'ondi, agala wo'ora id wurannu la o'a, mak agala wehla me ra'pa la galla uwo'or nana la makdena Amori limni ralamni, yoma o' mak kodi plolli la hyalmu re wawannu.” ");
INSERT INTO lex_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Nhor nioka Yakopa npolg awoka a'nani re na'nama niwra: “A'na miy re, mia miwoka, totpa arior taru-liai tiarga miy mormiormi. ");
INSERT INTO lex_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Miwoka pa mitlina, a a'nu miy, mitlin la ammi a'u. ");
INSERT INTO lex_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubena, o' de a'nu yanulu o'a. La'pa riy ramkek o' de, ramkek nana a ru'ru-la'yu, me wuhuru teklu. O' ed mak kala' ul lia ruri-lai ralamni me la' yatota-yawawa. ");
INSERT INTO lex_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ompuo'la-mliekru de emeka gera matni mak kopli, nhi'nande o' edon mumtemna. Hota o' edonna mugengen wia, yoma, o' ed mak kor oleka hawa liah'u minin la a le'wu wawannu. La ler maka omhi' emkade, de mhi' akdeha-aktiahli leka a le'wu wawannu. ");
INSERT INTO lex_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon nora Lewi, mimrio'a kekmi-rautmi de maklekla-makdiaini wuhura-tekla. ");
INSERT INTO lex_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","A'g edon gor la tnietwianmi-tniaiwianmi, yana agor la wokmi-le'emi re, yoma la'a yawunmi-yawenanmi ralamni de mpienna rimormiori, ne miy sukmi mriahi etia hayori orat lawanni. ");
INSERT INTO lex_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Hota mimrio'a yawunmi-yawenanmi di de emolmolla nora nhoptutu-udi nhoplera. Yoma hankeranmi re tehra me kapliahana. Hota age'era-ghakra miy lia a u'pu-a'nu re. ");
INSERT INTO lex_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yehuda, hyalmu re hota ra'uli-rawe'du, limmu naterna arwalmu du'urnu, ne hyalmu re hota nwaltiora-nwaltieman la o'a. ");
INSERT INTO lex_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Hota o' de emolmolla singa, la'pa nlernana ya'anni pa nla'aw la genni. Emeka riy ramta'ata rla ramata singa mak ka'a'na, de riy edon paran pia ror o'a ra'ara. ");
INSERT INTO lex_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Lodna-hairi mana edonna nwadur la o' limmu ralamni, edonan demade tita-kai kniaunu la'a lakmu rletni, nodia pa nmai maka Uplerlawna Ntutga pa nodi plola-ntaryat lia wawannu, nhi'nande riy mak kdella hairi-hairi re ratlina-ratailla. ");
INSERT INTO lex_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Hota mlier la pripanni-fa'anni, de mkioh tiarga keledaimu la anggur ona onni, la anggur on maka rwalir niana. Ne hota muala anggur turnu mpuah'i naniayarmu. ");
INSERT INTO lex_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Mlier la pripanni-fa'anni pede matmu hota nmermera rehi anggur, me nihimu re rwawahra, rehi uhu tiuru. ");
INSERT INTO lex_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon, hota o' de omhuol lia eni hu'ula-ga'a laini, mhi'a loi-puou loi genni-pnial genni, ne tiemmu-lianmu hota nora leta Sidon rpahelieli. ");
INSERT INTO lex_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar, hota o' de emolmolla keledai maka rurni karuri, mak kakowa la yohya'a maka e nodia rletni, ");
INSERT INTO lex_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","mere la'pa mutlin nana-muat nana de, letni-ruhunni de samoga, noka mdiella la hande ne mhi' ata-wa'ar la hande yoma la gen die samoga. ");
INSERT INTO lex_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan, hota o' de mak keti plollolli-kdawra mneneheni la limmu-rormu, yoma omlia' am la Israela luwnu ida. ");
INSERT INTO lex_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Emolmolla niy miakdella talla aratni de nho'wa kuda tikalli, nhi'nande mak kha'a ntuin la li'irnu, o' de riy dom to'a mere murehi ara. ");
INSERT INTO lex_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Uplerlawnu ne! Awuewiei-niarnara O ra'amu-palmu pa Omulewna a'u. ");
INSERT INTO lex_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, O' di hota riy yatyata wokni ida, rhokr o'a pa rwe'nu. Mere hota mpualdioinia pa mhuokra re. ");
INSERT INTO lex_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asyer, hota omliernana ya'anmu-yemanmu mikmikri me pripanni-fa'anni pa omuala la ray-ray ra'ana. ");
INSERT INTO lex_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naftali, hota o' emolmolla rusa rara mak katiewar doin la. Hota nayoria upa-a'na maka samomuou. ");
INSERT INTO lex_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yusup, hota o' de emolmolla orwo'a-auwo'a mak kamnornora mak kdella gera matni onni, tutnu-akni ntut lia lyanit pa narehia lutur lawna. ");
INSERT INTO lex_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","La'pa mak kwara'pa re rhokru pa rra'pa, ");
INSERT INTO lex_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","mere ra'pamu naruri-nalai, ne limmu rora naruri-na'orta onnila Uplerlawna mak karuri-kalai, maka apuesiaya Ntulan la o'a. Uplerlawan di mak kodia Israel, emeka riy ida mak kodi pipni-dumni. Uplerlawan Mak emeka ili-watu la Israel. ");
INSERT INTO lex_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Yusup, mururi-mulai onnila mak kla' Uplerlawan la ammu Ntulan la o'a, de mak kodi plola-ktaryatu Nara'a-napa'lu, de Nala ra'a-palu mak kden lyanti me ra'a-palu mak kdella nohkerna nora ra'a-palu ya'uhu-ya'apnu. ");
INSERT INTO lex_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","A' di de ra'u-pa'lu narehi wo'ora-kawru re ra'ani-pallu la ululu-plialiaini, de samomuou meman la'a wo'ora-kawru maka ululu-plialiaini. Hare honona rerun la o'tamu wawannu, o' mak kodi plolli la hyalmu re. ");
INSERT INTO lex_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyamina, emolmolla ahu puor maka naplar memna, yawyawar de na'ana lierenni, ne la'a lera lia'ani de nhakra hya' maka nwarui nana, hota o' de murehi ara.” ");
INSERT INTO lex_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Emkadella pa Yakop nror targa la upni-a'nani re mormiorni re. Rima-rima nlernana ra'a-palu maka nror taru-nlai tiarga la. Hare de rla' Israel luwnu-a'nani honona, de luwnu-a'nani termida wehrani woru. ");
INSERT INTO lex_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Nhor nioka Yakopa nano'a-na'atga a'nani re: “A'nami re, edon nalo'on ma'ta de, amuat pia uwok wutg a lia u'pu-tga'ru. La'pa amuat die midera a lia u'pu-tga'ru re onni la'a lien mak kdella Heta mniotni, nwawa Efrona nhyi'ini ralamni, ");
INSERT INTO lex_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","La'a hu'ula-liena no'a Makpela nhyi'ini ralamni, Mamre walli tipru, la'a Kana'ana lowanni-ahlani, nhyi' maka Abrahama nawel niana la Efrona, pa rhi'a la hoi-kietra wamueheni. ");
INSERT INTO lex_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Rkenia Abrahama nora hawni Sara la' hande, rkenia Isaka nora hawni Ribka la' hande, ne a'udera Lea wal lia hande. ");
INSERT INTO lex_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nhyi'a nora lien de, de rawel niana la makden Heta.” ");
INSERT INTO lex_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","La'pa Yakopa nano'a-na'atga a'nani rpa nhorwua dewade nran lakni la lewnu wawannu dewade nwaran doinia aranni la pa nmat wia. ");
INSERT INTO lex_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Noka Yusup nlawra inonni la amni gaini wawannu, na'nama nkakru me nkinnia. ");
INSERT INTO lex_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ne Yusup nhopna hopopanni-lili'irnu mak khi'a koda-atiawi re, totpa rala koda-atiawi rtomna amni inonni. Noma rlernohora Yusup lirni. ");
INSERT INTO lex_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Ir ralla koda-atiawi, pa rtomna inonni na'an lera terampwogata, rlernohora hya' maka nhi'inde makden Mesir rhi'a, ne makden Mesir rkakur nohora Yakopa mahnekni lera terampwo'itu. ");
INSERT INTO lex_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","La'pa lardoinia lera lului-nurnuhru re, dewade Yusup nakot la Firauna nhiutni-nhianni-nhielli-liarni: “Ama-hyal miy re, la'pa aliernana ralam kalwiedmi de mikot la Firaun, ");
INSERT INTO lex_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","de a'mu nhopna aliokar la, niwra: “Edon nalo'on de amuat wia, la'a ho'yu-kietru maka a'uwte'ta oleka la Kana'an de, midera a lia' hande.” Hade pede miolli a lia pa lia'awa hande totpa a'udera a'mu la lien de, nhor diemade a'uwali owa'ana.” ");
INSERT INTO lex_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Noka Firauna nakot la: “Mlia'awa hande pa midera ammu la liena, emeka ha nhopna omliokar la.” ");
INSERT INTO lex_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Noka Yusup nala' pa nla'awa hande totpa nadera amni, ne nor rewre'wa Firauna tniutnu-nhianni-nhielli-liarni re honona wali, ina-ama mak kdella istanni ralamni, ne ulu-o'ta no'a Mesir re honona re, ");
INSERT INTO lex_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","na'itra Yusup romni mniotni, hyalli rena me amni romni mniotni, eneknek to'a a'nani me nhiurni-wnia'anni re, raltarga rla Gosyen lowanni. ");
INSERT INTO lex_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","La'pa kereta me mak kha' kuda, de de makodi keki-rautu, ror wal pia rla'awa hande, nhi'nande mutnu-taurnu re plahwani. ");
INSERT INTO lex_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","La'pa rte'ela Goren Ha'atad, la'a gerlawna Yordan walli, noma rhi'a yapolu-yatniani matmiati id la hande, ne Yusup nalul niana lera wo'itu lia amni de. ");
INSERT INTO lex_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","La'pa noh de mniotni, makdena Kana'ana ramkeka yaluli-yahon la Goren Ha'atad de, dewade riwra: “Hadi de makdena Mesir yalulli-yahonni maka kokokna-rariarin matmiati.” Hade pede rweta gen mak kdella Yordan walli de, Abel Misraim (nnia'eratni de, makden Mesir yalulli-yahonni). ");
INSERT INTO lex_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Emkade pa Yakopa a'nani re rhi'a emeka amni nano' targa la ira. ");
INSERT INTO lex_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","A'nani re rrana pa rodia rla'awa Kana'ana lowanni ne rkenia la hu'ula-liena ralamni la'a Makpela, nhyi'ini maka Abrahama nawel nian oleka la Efrona makdena Heta de, pa rhi'a la hoi-kietra wamueheni, de nhyi' mak kdella Mamre walli tipru. ");
INSERT INTO lex_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","La'pa rkenia amni pa nhorwua dewade Yusup nawal lia Mesir wa, nora amni-hyalli rena me riy honona mak kor rewre'wa rla' hande pa rla rkenia amni la liena ralamni. ");
INSERT INTO lex_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","La'pa Yusup hyalli re rat niohora oleka de amni nmati olekwa dewade riwra: “Yanhi'pa Yusup naun targ ita! Pa nwahla ita nhiol yatni la e'a.” ");
INSERT INTO lex_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Hade pede rhopan pa rla rwe'era nnio' dilla Yusup: “La'pa it amni edonna nmat mia'ta de nano'targ oleka: “Emkadilla la'pa mikota la Yusup: Mhuoratdoini hyalmu re do'oni-halli, yoma rhi' oleka nhiol yata-liet yat la o'a. Noma dodo'ondi de, mhuoratdoini mak khima-kre'a ammu Uplerlawanni re do'oni-halli.”” Yusup natlin nana hare lirni, de: “Mhuoratdoini hyalmu re do'oni-halli”, de nkakur wa, (yoma hyalli re raplin ma'ta de nhoratdoin oleka ir do'oni-halli). ");
INSERT INTO lex_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","La'pa hyalli re rmeh'a rmai pia rwaltiora-rwaltieman la riwra: “Ammai pia mla' atmu-wa'armu.” ");
INSERT INTO lex_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mere Yusup nakot la re: “Yan mimta'ata. Uplerlawna edon a'u. ");
INSERT INTO lex_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Plollolli de miy e mpiarora-mpialaiya yotyotni-yatyatni mai a'u mere Uplerlawna Nwarora-nwalai niana kalwiedni-paitiotni, totpa Nhi' nana hya' maka Nhi'a la ler di, de Nalewna riy harahu mormiorni-dardiarni. ");
INSERT INTO lex_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Pede yan mimta'ata, hota agala yaya'anmi me a'nami re yaya'anni re.” Emkadella pa naltier samomuou la ira totpa nhi' ralamni re pa rahepru, totpa yana ralamni re worworga owa'ana. ");
INSERT INTO lex_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ne Yusup de nden nek la Mesir pa na'itar wutu luwnu-a'nani, ne Yusup nmormior niana anni rahu ida termida. ");
INSERT INTO lex_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Pede Yusup nre'ela namkek nohora Efraima upni-a'nani la'pa ndait nana tuwu wotellu, me la' walia Yusup nakerna-nagatna Manasye upni (Makhir a'nani) la riwni wawannu. ");
INSERT INTO lex_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yusup nakot la hyalli re niwra: “Edon nalo'on ma'ta de amuat wia, plollolli de hota Uplerlawna Nlin reri-nmat rermi me Nod miy pia mhiargot la'a gen di pa mlia'a la gen miaka Nano'targa de Nnairi liokra la Abrahama me Isaka me Yakopa.” ");
INSERT INTO lex_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yusup nakot la hyalli re honona niwra: “Plollolli de hota Uplerlawna Nlin reri-nmat rer miy pa mlia'awa Kana'ana. Hade pede dodo'ondi mliokar pa la' ler de de, miodgiota a ru'ru-kliaklu mak kdella handi pa mlia'awa.” ");
INSERT INTO lex_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nhorwua dewade Yusup nmat wia, de mormiorni anni rahu ida termida. Rala koda-atiawi la inonni, ne rkenia la lumni la'a Mesir. ");
INSERT INTO lex_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","La' ululu ma'ta, la' ler maka maktorna deulu-tatra rodi plolli la Israel, de rehka-lar lawna la' hande. La' ler de de a'na muanke' id nanni Elimelek nor patke'eni nanni Naomi rwatiawua luwu-a'na Efrata. Ira nhiol genni Betlehem la'a riy Yehuda yapatni. Yoma la'a rehka-lar lawan de pede nora patke'eni Naomi rla'awa la Moab rora a'nani rora, Mahlon nora Kilion pa honona rden la hande. ");
INSERT INTO lex_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Noma lera ida ne Na'omi muanke'eni Elimelek nmat wia. Pa enekneka Na'omi napatyat nohora a'nani muanke'a rora la hande. ");
INSERT INTO lex_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","A'nani re rmehlim pa rora pat harara makden la Moab de, ida nwawa Orpa, me ida nwawa Rut. La'pa edon nhal de, nalo'on nana anni termid wa la hande ");
INSERT INTO lex_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","dewade Na'omi a'nani muanke'a rora rmat wial wia. Ne Na'omi napatyata inon muanmuanu. ");
INSERT INTO lex_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Rden la hande pa lera ida ne Na'omi natlin nana ORGAHI-ORHA'A Ntera-ndem oleka riy Israel la'a riekni-wnio'orani. Dewade Na'omi nora yananni patke'a rora rwahi'a-rwayod pia rlergot la' Moab totpa rawal lia Israel. ");
INSERT INTO lex_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Irlergot rewre'wa pa rawal lia' Yehuda yapatni. La' pa ralala' rer mia'ta ");
INSERT INTO lex_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","noma Na'omi nakot la yananni patke'a rora niwra: “Yananmi re! Samomuounu de mimrio' miwal lia miy inmi romni. Pena awuak la ORGAHI-ORHA'A pa Ntutga E ralam kalwiedni tiy miy, emeknekama mtiutg oleka la miy hapmi mak kmati oleka re me mimtiutg oleka la mai a'u. ");
INSERT INTO lex_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Pena wuak la ORGAHI-ORHA'A totpa Nal miy pia mmiehlim owa'ana, totpena mimlier owa'an la mtierterannu.” La'pa Na'omi nano'a rpa nhorwua dewade nkinnia re pa niwra nawliohorwa dewade rolindoinia kniakru ");
INSERT INTO lex_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","pa rakot la yananni Na'omi riwra: “Yannie! Omliol meni-meni pa muwal wia nohomu de, amlernohorre'ru pa ita tden wut lia o lupmu-a'namu de.” ");
INSERT INTO lex_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Mere rora yananni Na'omi nhar lirni nakot la niwra: “A'nami re! Samomuounu de mimrio' miwal lia rommi. Nihya' pede miwra mliernohora a'u? A'ukleha upa-a'na, pa hota mimiora mmiehlim owa'ana. Ne hota a'g edonna liernan owa'an a'na. ");
INSERT INTO lex_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Pede a'na miy re, mimrio'a miwal niek la inmi romni. A' di de ghape'ewa pa hota he' ed mak kor a pua mmehlim owa'ana totpena aliernan a'na?! Ne la'pa emkade ho'mana aliernan talan pa agor muanke' id mmehlim la' mel di memna, totpa pleta-plet pa aliernan a'na muanke'a rora, ");
INSERT INTO lex_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","de plol toto'a de mimpiei niana keke'enku'a re rlawan totpena miora mmiehlima?! Hota a'a'nu nanpena mimiora mmiehlima ne la' riy dom to'a de taken niana miora mmiehlima?! Yan mimrio'a mpiaror emkare! A'na miy re, mimrio' miwal niek wa yoma ORGAHI-ORHA'A Ntutga hankeranni mai a' pua mernu-kapalli maka aliernan dena nareh dioin hya' maka mimliernana.” ");
INSERT INTO lex_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Noma rpolpuolu-kakakria, dewade Orpa nkinnia yananni na'nama nwak kalwieda pa nla'awa. Mere yananni handina Rut de nkorreri pitpit lia Na'omi pa nahmena nwadur nan oke'a. ");
INSERT INTO lex_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Na'omi nakot la niwra: “Ruta! Mumkek to'ola raurmu nla' olekwa de pa hota nler wut lia lupwalli-a'na walli re pa rkola tieru-rawur nehla la uplerni-upmatni re wa nee! Mlia' pa mliernohora raurmu e nla' olek de!” ");
INSERT INTO lex_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Mere Ruta nahmena ne niwra: “Yanie, yana mhuopn alia'awa pa atio'or doinia o' la. Hota omliol meni to' de alier nohorre'ru! La'pa omdiella hanmeni de adiel wal lia pa la'pa amuat nioho'ru la hande. O lupmu-a'namu erla hanmeni de alier wut lia. Uplerlawna maka omkuola tieru-muawur nehla la de a' muana kola tieru-gawur nehla wal lia. ");
INSERT INTO lex_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ommuori-mmuat lia hanmeni, de amuori-muat nioho'ru pa rtamin wali a lia' hande. La'pa a'uwlar dioinia o la de pena Uplerlawna Nal a lia yatyatni-halalli yatlorni-yatra'ani. Ommuati onde amuat nianpena itro' idma oliet la ida!” ");
INSERT INTO lex_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","La'pa Na'omi nat niohora hota Rut nahmen memna nlernohora e lirni dewade edon nakot owa'an pa rpahakar talla. ");
INSERT INTO lex_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Rrora rla'awa pa rodi liarni la Betlehem. La'pa rte'ewa la hande, de let de ralamni kokan nohora-po'on nohora la Na'omi. Hapepe'a-hararara let mniotni idma natian id la riwra: “Mak ha riwra Na'omi inhati hadina?” ");
INSERT INTO lex_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Noma Na'omi e nhar lirni pa nwalola re niwra: “In-el miy ree! Yan mpiet a lia Na'omi (nnia'eratni de nahepru). Mere mpiolga a na'nu la Mara (nnia'eratni de mernu-kapalli) yoma Uplerlawna-Mempulwatnu makodi plolli Nhur dioinia a lia pa alier la mernu-kapalli. ");
INSERT INTO lex_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","La' lerni aliergot la handi pa alia'awa la'a Moab de agod miemna-gal memna. Mere ORGAHI-ORHA'A Npolla-nwe'era alia la'a noh maka a ra'ru ntur lia di agodi hgalia a li'mu. La' hade pede yana mpiolga a lia Na'omi (nahepru) yoma ORGAHI-ORHA'A mak kodi plolli ktaryatlia la'a hanek-harahu wuawannu ed mak kto'on reri a' pua muori-diar lia kropanni-krieutnu!” ");
INSERT INTO lex_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Emkadel la'a Na'omi tuini la' lera nwatiawua Moab pa nawal niohora yananni Ruta, riy Moab de. La' lera rte'ela la'a Betlehem de, de rlernana mdududga rieik lawna la noha wullu-we'elli. ");
INSERT INTO lex_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Na'omi hawni Elimelek mak kmati oleka de, rimormiorni ida nwawa Bo'as, maka nh'inde riy ra'unni-ramta'ata yoma la'a re'eni-tniarnu. ");
INSERT INTO lex_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Noma la'awa lera id na'nama Rut makden Moab de nakot la Na'omi niwra: “Awuak pa alia teka nhyi' ralma totpena arie'ela uwoka wetra' lawna harni maka riy rtetia pa ktuini. Pena alia uwoka wetra' lawan de la' gen mieni maka riy e rsaini a pua edonna rwayotlia a lia hande.” Noma Ruta wniakni de, yananni Na'omi nreiniana pa nhopna nla'a. ");
INSERT INTO lex_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Dewade Ruta nla'a nhyi' ralam id pa nawoka wetra' lawna harni maka mak kreiki-kwo'ora rhi' atuinia. La'a nhyi' maka ha nla nawoka wetra' lawna har la de, Elimelek hyalli Bo'as de gahani, mere Rut naplin niohora de. ");
INSERT INTO lex_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","La'pa lardoinia jam ida-woru dewade Bo'as nwatiawua Betlehem pa nmai wia noma nwak kalwieda la makreiki-kwo'ora re niwra: “Awuak pa ORGAHI-ORHA'A Nor miy tialla.” Noma rwak walia kalwieda la Bo'as ora nhyi' de riwra: “Ne ampak wal pia ORGAHI-ORHA'A Ntera-ndem o'a.” ");
INSERT INTO lex_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Noma Bo'as natian nohora Rut la'a makhi' o'tani la mak kreiki-kwo'ora re niwra: “Hararar de ha nwatiawua he' genni-tienni luwnu-a'nani?” ");
INSERT INTO lex_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Noma o'tani de nwalolla niwra: “Pat Moab id hadi! Na'nama ha nora Na'om pia rwatiawu Moab pa rmai. ");
INSERT INTO lex_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ha nwak ma'u pua nre'ela natopla wetra' lawna harni maka mak kreiki-kwo'ora rtolkiai yeti re, la'a wetra' lawna mak ha ra niutin taru oleka re onni! Ha natopal nek la yawyawar pa na'nama nren la hoiwial die nayanni.” ");
INSERT INTO lex_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","Noma Bo'as nla' pa nakot la Ruta niwra: “Nara, mitlina! Yana mlia mutopla riy meheni dom to'a wetra' lawna harni, mere mlia mutopla la gen miaka mumkek nan de a'na muanke'a mak kar lia handi e rreiki-rwo'ora. Ne pena muor wutga a'na pat mak kar lia handi pa muliria mak ktuini re. Irlol meni-meni de mliernohor reria re. La'pa o tiermu kerna, de muemun nek la'a kekna maka a'na muanke'a mak kar die rhi'targ oleka re wa. A'ukot olek la ir pa yana muanke' ida nkakrom o'a.” ");
INSERT INTO lex_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","La'pa Rut natlin nana Bo'as lirni re dewade nwaltiora-nwalteman la na'nama nakot la niwra: “Amee! A' di de hya' id a' pua a'mu ntutga kalwiedwed lawan de mai a'u?! A' di de dakn id a'u. Nihya' pede a'mu nma nkokan nohora a'u?!” ");
INSERT INTO lex_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Mere Bo'as nakot la niwra: “A'utlin momuog oleka o nhiolmu-lietmu maka ha mtiutga la yananmu, la'a ler maka o muanke'emu nmat pia la'pa ntutu-nte'ela dodo'ondi. Agat niohora olek walia de omultarga inmu-ammu la'a o nohomu-raimu pa ma mdien wut lia'a makden Israel ri maka ha muplin niohor ma'ta. ");
INSERT INTO lex_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Pena wuak la ORGAHI-ORHA'A pa E' ed mak kwahla nhioli-liet samomuoumu maka ha mtiutg oleka re. Pen neka ORGAHI-ORHA'A, riy Israel re Uplerlawanni de Nhuri-ntowria pripanni-fa'anni la tiy o'a onnila miy hihi'imu-yapyapmu re, yoma omua pia muiwra mmuori-mdiar lia E nayanni.” ");
INSERT INTO lex_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Noma Ruta nwahla lirni niwra: “A' di de mak kakleha weli id a'u. Hopopna-lili'iru ata-wa'ara mak kar lia a'mu nek de a'g edon gor la. Mere a'mu nhar lirni mai o hopopanmu a' di, nheik la a ralam kalwiedwe'du pa a ralmu namtiertierun wa. Ne awuakwak pa hota aghi' reri hya' maka kla'nan a'mu ralamni de.” ");
INSERT INTO lex_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","La'pa riwra ra'an wa dewade Bo'as npolga Rut pa niwra: “Ruta! Mmuai pia ta'ana! Mua'ala rot di oke' pa mtio'a la' sidu.” Dewade Ruta nor rewre'wa makreiki-kwo'ora re pa ra'ana-remun wutu. Bo'as ntania wetra' lawna mak radarni pa Ruta na'an pa npepuehera. La'pa rwairwa mere Ruta ta'ennian na'an momuoga gahani pa nhi' targa. ");
INSERT INTO lex_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","16","Nhorwua noma Ruta nla pa nalir owa'ana wetra' lawna harni maka ha ratuin doinia la. La'pa Ruta nto'or wa noma Bo'as nakot la mak kari re niwra: “La'pa patke' de nalir niana wetra' lawna dom makden la har maka ha ra niutin taru oleka onni mana, de yan mia'ala! Onde yana mpiolliohora, yanhi'pa nmola-nma'a ne yan memmemna miwenan la. Rerehniana mtiotpa mhi' atuinia maka ha mteti oleka re oke'e-oke'ela totpena natopal nana.” ");
INSERT INTO lex_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Pede Ruta nru'rer niek yatopla pa nodia la lera nheria. La'pa nwaliwra maka ha nawok nana re honona noma nlernana wetra' lawna (jelai) la'pa edonna nhal de kilu termida. ");
INSERT INTO lex_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","19","Nhor pua nla'awa leta noma nala yodni rella la'a yananni, me nal wal lia yamananni maka takenniana na'ana la dodo'ona. La'pa yananni Na'omi namkek memna wetra' lawna maka nlernan oleka de dewade natian nohora niwa: “Inee! Omliernan hari honona la hanmeni? Me omkar lia' he'a nhyi'ini-elawni? Uplerlawnu nee! Pena Mhilpai-muanatga riy maka khi'a nhioli-liet dilla mai ami.” Noma Ruta nakot la niwra: “La'a nhyi' maka a'uliria wetra' lawan la de, matromni nwawa Bo'as.” ");
INSERT INTO lex_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Noma Na'omi ema rtaplelertarga pa niwra: “Hota Bo'as de it nek hade. La' plollolli de e' ed maka kamkek mita. Awuak pa ORGAHI-ORHA'A Ntera-ndem a nar mamni de! Yoma E ed mak ktut reria E ralam kalwiedni la'a mak kmati oleka me mak kmormior mia'ta di.” ");
INSERT INTO lex_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Noma Ruta nakot nohor wal lia yananni Na'omi niwra: “Ina, hade edon nmeh'a, mere riy de enano'tar wualia a'u niwra pena, agor rewre'wa makreiki re pa a'ulir pia nodi liarni la'pa rieik-wnio'or lerni de nhor muemna.” ");
INSERT INTO lex_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Noma Na'omi nakot la Ruta niwra: “Ineee! Talan samomuog olek hade tiy o'owa! Totpena nhi'inde omuor wutga inmu-elmu re pa mkiar riere'wa la'a Bo'as nhyi'ini de. Yoma la'pa omkar lia' riy meheni nhyi'ini de yanpa riy rarie'yu.” ");
INSERT INTO lex_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Pede lera-ler nekpa Rut nlernohor reria patke' mak kar lia la'a Bo'as nhyi'ini pa nodia la'pa rieiki-wnio'or lerni nhorwua. Ne Rut mana edonna nhoitio'or la yananni Na'omi mere rrora rhol wiutu la'a roma ida. ");
INSERT INTO lex_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Lera ida ne Na'omi nakot la Ruta niwra: “Yannie, a'g e wuahak meman pa plet pa omuehlim owa'ana, totpena muanke'emu natiak o'a, me nkar pia nala ya'ana-yemnu hewewta-naniairi totpena ralammu nlerla mtiertierannu. ");
INSERT INTO lex_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","O' e muora inmu-elmu re e mkiar lia'a Bo'as nhyi'ini toh! Ne Bo'as de it neka de pede mitlina me! Hota la' mel di de enor mak kari re rkar lia gen miaka nhi'inde rataiya wetra' lawna harni ");
INSERT INTO lex_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Pa plet pa mlia muroh'u nanpena mhid wu'ru-mhid gania inonmu pa muhuwu-muwoinia mikmikarni me mniairia naniayarmu maka samomuounu. Totpena mel di de mlia'a gen mieni maka Bo'as nora mak kari re ha rataiya wetra' lawan la de. Mere mpieiwiei niek la hande la'pa ena'ana-nemnu pa nhorwua. Me mutiak reria, yanhi'pa enatg o' etla hande. ");
INSERT INTO lex_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Mumkek nek pa nla nanina hanmeni, dewade muwrik temna nanpena mkeiya nhiekarnu tawnu me mlie'eru la lakni onni. Hota la'pa na'eram nan o' wa de, mutlin neka la hya' maka nhopan pa omhi'a.” ");
INSERT INTO lex_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","“Yowa ina! Hya' maka omukota de hota aghi' momuou lia.” ");
INSERT INTO lex_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Dewade Ruta nla'awa la'a gen miaka ha rataiya wetra' lawna har la de dewade nhi' momuoga hya' maka yananni ha nakota re. ");
INSERT INTO lex_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","La'pa Bo'as na'an pa nhorwua demade ralamni nahepru lia (wniarora-wnialai la'a hare honona maka Uplerlawna ha Nal la e'a) pa edon nalo'on wali ne nla nanina la'a wetra' lawna ola maka ha ramou pua raniutin taru re, onni. Dewade Ruta nawrik temna Bo'as, na'nama nkei mnapnapla nhiekarnu tawnu na'nama nanina la lakni onni. ");
INSERT INTO lex_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","La'pa mela letargara ne Bo'as nhedgamata pa nwalia inonni noma namkek memna Ruta inonni, dewade nhedma noma ");
INSERT INTO lex_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","natiana niwra: “Patke' meni o'a?” Noma Ruta nwalola niwra: “A'u, o hopopanmu Ruta ama! La' a'mu o' nanpena ed mak kodi plolli la a mormio'ru yoma it di de riy meheni atia' ita. Mtiulan pa mhi' a lia patmu!” ");
INSERT INTO lex_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Noma Bo'as nakot la niwra: “Awuak de pena ORGAHI-ORHA'A ed maka kala ra'ani-pallu tiy o'a de ina! La'pa itawalliohora hya' maka ha mhi'a la yananmu, de hota nhiolmu di mana ntutga la dodo'ondi de o kalwiedmu narehi owa'ana. Yoma o' di de muatu muodia inonmu pede, o' edon muhaka muanke'a id maka tuwuar mia'ta, la'a riy maktaru onde riy mak kakleha-kaplara totpena omuora mmiehlima, mere omliernohora yananmu wniakni. ");
INSERT INTO lex_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","La' hade pede yan mumta'ata, yoma la'a let di liewnu de riy rat niohora o' di de pat kalwiedwed id o'a, pa ra'uli o'a. Pena hya' maka ha mpuaka re, a'g ed maka hota khi'a re. ");
INSERT INTO lex_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Hota o lirmu de plola. A'g ed maka kodi plolli la o mormiormu, yoma it di de riy id ita. Mere la it di de, riy id ed ma'ta la. La e' nanpena ed maka kodi plolli meman tiy o'a. ");
INSERT INTO lex_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Mel di de yana mlia'a pleini. Repar doin nanpena apuolga ononni mak kodi plolli tiy o'a pa utiana totpena tat muemna hota toto'a pa ena'aw niana o' me edonna. La'pa enwayow de, inhatta, mere nwayotlia de pena aliokar meman la ORGAHI-ORHA'A mak kodi plolli de hota a'g ed maka ka'aw nian o'a. Lira emkade nek wa pa taninit wa pa repar pena!” ");
INSERT INTO lex_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Dewade Ruta nanina la Bo'as lakni onni pa nodia pa repra. Repreparreri loka-lak ma'ta dewade Ruta ema rhedgamata yanpa riy ratga. Yoma Bo'as nahmen pa yan riy ida nat niohora Ruta nma nanin la Bo'as onni la'a gen miaka ha rataiya wetra' lawan de. ");
INSERT INTO lex_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Noma Bo'as nakot la Ruta niwra: “Muo'ludoinia kok no' wawainmu de (selendang) pa mpueran targa la handi”. Noma Ruta no'lu doinia kok no' wawayanni de pa nweran targa la hande wa. Dewade Bo'as na'ala kok de na'nama ntoman nana wetra' lawna, edonna nhal de kilu terampwotelu na'nama nrana la Rut wawayanni pa nakwar la pa nla'awa! Nhorwua noma Bo'as nla'awa la leta. ");
INSERT INTO lex_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","La'pa Ruta nte'ewa la ir romni nayanni, dewade yananni natiana niwra: “Yannie! Emkameni la it niaoh'mani la' orawi?” Noma Ruta nwahaur momuoga hya' maka Bo'as ha nhi'a la. ");
INSERT INTO lex_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ne Ruta nakot wal lia yananni niwra: “Wetra' lawna ri honona re, e' ed mak kala, yoma niwra: “Omlia'wa de yana limmu nahgallia la it inni de!”” ");
INSERT INTO lex_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Noma Na'omi nhar lirni pa nakot la Ruta niwra: “Itwei niek wa ine! La' ler di meman pa Bo'as nhi' memna hya' maka ha nakottarg oleka de, pede mpueiwiei niekpa tamkek memna hya' maka ha rhi' nana!” ");
INSERT INTO lex_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","La' ler de Bo'as nla'a gen miaka nhi'inde ha rawoka-rale' lia la'a leta puohra lawna gaini. La'pa namtatna la hande na'nama nta'wa rer miatni la a'na muanke'a mak klol hande totpena namkek nana Elimelek rimormiorni maka enakot nohora oleka la' Ruta, totpena npolga. Edon nalo'on wali ne hyalli de mak kodi plolli pa ntulan la ir Naomi, maka Bo'as ha nwei rieria inhatta pa ed mak klereti. Noma Bo'as npolga hyalli de pa nma namtatna la' hande. ");
INSERT INTO lex_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Na'nama Boas nla npolg awok walia ama-yei riy termid pa ramtatan walia pa rhi' nohora la'a hya' maka ha niwra nakot nohora. ");
INSERT INTO lex_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Noma Bo'as nakot la riy maka enor wutga la luwu-a'na de niwra: “It honnonita tatg oleka de Na'omi nwatiag oleka Moab pa nmai wia. Dodo'ondi de niwra na'olga nohanna maka Elimelek, it rimormiorni mak kmati olek de gahani. ");
INSERT INTO lex_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","La a wniaro'ru de ononni o' pa samomuounu de a'ukot nohora totpena omuat niohor memna. Emkameni la o wniarormu la' tan diena? La'pa omiwra muwelia pa mtieman reria de mukota totpena ama-yei lieta ri la'pa riy honona mai handi rat niohor memna. Mere la'pa muhmen de mukota, totpena tat niohora momuoga! Yoma itro' nanpena todi plolli la nohanna-taniarta re. Mere o' edonan nanpena a'u.” Noma hyalli de niwra: “Yowa a'uwelia wa!” ");
INSERT INTO lex_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Noma Bo'as nakot la niwra: “Samoga! Mere mutlina, la'pa muwelia tan die la'a it inni Na'omi, de mliernan walia pat Moab maka Na'omi a'nani Mahlon ha nto'or nan de. Hota omuora mmiehlima totpena mliernan a'na muanke'a ida mak hota klernan tan die, totpena tan die ha nden nek la'a Mahlon de rimormiorni.” ");
INSERT INTO lex_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Noma riy de mak kodi plolli pa ntulan la Na'omi nakot la Bo'as niwra: “La'pa o e mpuapan wutga pat Moab de la'a tani die, de yan nek wa. La dodo'ondi de plola a'g ed mak plollolli pa a'uwelia, mere ta'en niana aghi' nana pede omua' nek la wa. Yoma la'pa a'uwel hade mana hota a durtu-waitu edonna rlernan walia tan die. La'pa emkameni de omuwel nieka wa.” ");
INSERT INTO lex_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Mere la' ler ululu la'a makden Israel re, de hameni mak ka'olu-kala'a hanni hadoma, onde ra rwahernia, de nhi'inde riy id la ira no'lu doinia lakni wniowni, pa nala la ida. Makden la Israel re deullu-tatarni emkade totpena riy rat niohora plola pa ra'olu onde rwahernia oleka. ");
INSERT INTO lex_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","La' hade pede riy de nakot la Bo'as niwra: “Itro' gahani hade mere o' ed maka kawelia la Na'omi pa agolin lim la ne omuala a la'ku wniowni di!” ");
INSERT INTO lex_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Noma Bo'as nhar lirni pa nakot la ama-yei re ror wutu riy maka khopnu-kpepan la hande pa niwra: “La' ler di de hononmi mimkek memna a'g ed mak kawelia la' Na'omi, la'a hare honona maka Elimelek nora a'nani Kilion nora Mahlon ha rto'or nan oleka re honona. ");
INSERT INTO lex_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Me la' walia aghi' walia pat mak kwawa Rut, riy Moab maka Mahlon ha nto'or nan de pa agora mmehlima. La' hade pede tan miaka a'uweli olek de ho'mana nden owa'an la genni pa orgah miak kmati olek me luwnu-a'nani mak kmormiori rteman reri owa'an genni. Totpena hota Mahlon mak kmati oleka de, duratni-waitni rhoratreria e'a, me makden handi mana rhoratreri e tuini-wedni. Mhioratreria! Ama-yei lieta, me ama-hyali miy hononmi e mtiutrier wial pia ami e makot nohor hari honona kalwiedoo!” ");
INSERT INTO lex_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Dewade ama-yei lieta ror neka riy honona makden la hande honona mana rharlirni pa riwra: “Yowe! Am e rwal di le (saksi)! Ampakwak de pena ORGAHI-ORHA'A Ntera-ndema patke'emu pa emekwalima Rahel nora Lea rayor niana upa-a'na rahu la Yakob pa nadurit nana mutga Israel, totpena o' mana mliernana pripanni-fa'anni, pede makden Efrata re rwetwet la nanmu la mai leta Betlehem di. ");
INSERT INTO lex_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Ampak de upa-a'na maka ORGAHI-ORHA'A Nala tiy o' pa pat hararar de nayori-nadar niana re, hota rhi'a miy lupmi-a'nami re pa riy liawanni emeknekama Peres, Yehuda nora Tamar a'nani de!” ");
INSERT INTO lex_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","La'pa Bo'as nora Ruta rmehlimpa noma ORGAHI-ORHA'A Nala a'na muanke'a id pa Ruta na'uhu-na'apun nana. La'pa Ruta nmoria a'nani muanke' de, ");
INSERT INTO lex_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","dewade a'na patke'a makden la hande rakot la Na'omi riwra: “Na'omia! Pen ta'uli-tawed reria ORGAHI-ORHA'A, yoma Enal oleka a'na muanke'a id pa o mhi'a la up ku'umu pa hota e' ed maka ktera-klahg o'a, elee! Twakwak de pena makden Israel re rwetweta la upmu de nanni. ");
INSERT INTO lex_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","O yananmu patke' de ralamni kalwieda la o'a. Ha nal tiy o' de narehi lawna hya' maka a'na muanke'a harahu hota ha rala la amni. Dodo'ondi de enal oleka keke'enku id pa mpua'upa, pa hota o ralammu namtiertierun owa'ana me hota keke'en de ed maka ktera-klahg o'ola la'a tormu ntutu-onmu nwa'a (masa tua).” ");
INSERT INTO lex_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Noma Na'omi na'ala upni de pa nakauga. Noma keke'enku' de nalawlawan lola de Na'omi ed mak ka'oka-kakania. ");
INSERT INTO lex_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","A'na patke'a la'a rom heiwiali re riwra: “Na'omi nlernan oleka a'na muanke'a id wa!” Dewade rala keke'en de pa nwawa Obed. Obed di, ed maka hota ka'a'ana nana Isai, me Isai ed mak ka'an nana ray Daud. ");
INSERT INTO lex_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Ray Daud upni-tgarni de Peres. Yoma Peres kotnu-turnu gerni-wniaunu (upni-a'nani duratni-waitni) nani ertile: Peres na'a'n nana Hesron, Hesron na'a'n nan Rama, Ram na'a'na nan Aminadaba, Aminadab na'a'n nan Nahason, Nahason na'a'n nana Salmona, Salmon na'a'n nana Bo'as, Bo'as na'a'n nan Obed, Obed na'a'n nan Isai, Isai na'a'n nana ray Daud. ");
INSERT INTO lex_vpl VALUES ("ET1_1","018_1_1","EST","1","1","1","La' ler ululu de Ray Aswerus nodi plolli la propinsi rahu ida terampworu wehrani wo'itu de nwaga la'a India pa nla ntut lia la'a Etiopia. ");
INSERT INTO lex_vpl VALUES ("ET1_2","018_1_2","EST","1","2","2","La' ler de de ray de nden la letlawna Susan pa nodi plolli la'a e kruwun gen makden hande. ");
INSERT INTO lex_vpl VALUES ("ET1_3","018_1_3","EST","1","3","3","La'pa nodi plolli nana anni la'pa wotellu, dewade ray Aswerus nhopan pa rhi'a yahepur lawna la o'ta-mat lalawna ror wutga E'a niutnu-nhianni nhielli-liarni. Makodi ahu namni (kepala perang) la'a Persia nora Media ror wal pia rma ra'ana-remun la la'a mei yamuki-yahepur de, me emkade wal lia'a gubernura re honona ror wutga tniutnu-nhianni nhielli-liarni re honona. ");
INSERT INTO lex_vpl VALUES ("ET1_4","018_1_4","EST","1","4","4","La'a wolan tetem wonema ray Aswerus ntutga re'eni-tniarnu mak kareh mieman de la'a makden la E kruwun genni (istana) me la'a e' inponni nor wutga e tullu-petanni la'a e lodani-hairni. ");
INSERT INTO lex_vpl VALUES ("ET1_5","018_1_5","EST","1","5","5","La'pa wolan wonema re nhorwua noma ray nhi' walia ya'ana-yemun lawna la'a lima-rora makden la Susan, la'pa kuku'uni-lalawanni honona re rmai momuou pua rre'ela ra'ana-remun la mei wawannu. Ra'ana-remun nan la'a lera wo'itu, la'a ray krwuwn genni herni walli-walli mak ha rtamnia ora-au lia hande me ndella' lutru-lutru ralamni. ");
INSERT INTO lex_vpl VALUES ("ET1_6","018_1_6","EST","1","6","6","Rala koka maka mnurnu'ru maka yamkekni motmota me wawahra pa rwairia la'a kruwun gen die herni-gaini walli-walli de. Rala tali mnurnurhu maka yamkekni wawahra me ponpona pa rwahtiera wutga kok de la'a le'u muaka ha rhi' nan la perak, totpa rwanin targa la riri maka ha rhi'a la watu wawahra mak klitlit memna. La' walli yaw de rken wutwutga lewu ku'a maka ha rhi' nan la maha nor peraka, maka nhi'inde rnairia pa ra'ana-remnu la wawannu. Rkeni lewu ku'a la'a tehel wawannu maka ha rhi'a la mutiar ulti mak klipa-ka'ma, me watu wawahra nor wutga watu-watu dom to'a mak kwelli werta me mak klipa-ka'ma. ");
INSERT INTO lex_vpl VALUES ("ET1_7","018_1_7","EST","1","7","7","Ray nhur tiar wutwutga anggur tur liawanni maka ha rhoi tiar wutwutga la lari niemun geni maka ha rhi' nana la maha. Me la niemun geni re to'a-taiya. ");
INSERT INTO lex_vpl VALUES ("ET1_8","018_1_8","EST","1","8","8","Mak ha rpolu-rwak nana re, anggur tur rla'a-rmai lia re. Yoma ray nhar lirni la'a riy maka ktulla-kar lia ray kruwannu de niwra: “Mhioi-mtan lia makhopnu-kpepna re de mlier nohora ir wakwakni.” ");
INSERT INTO lex_vpl VALUES ("ET1_9","018_1_9","EST","1","9","9","Wasti, ray patni de mana, nhi' walia ya'ana-yemun nhioi-tniani la'a pata-mapra mak kahnioi-kapniepan la'a ray kruwungenni de ralamni. ");
INSERT INTO lex_vpl VALUES ("ET1_10","018_1_10","EST","1","10","10","La'pa nte'ela lera wo'itnu la'a ya'an lawan de, dewade Ray nemun nande ralamni nahepuepur memna, noma npolga riy mandidit muaka rtut tiarga pa ray nhi'inde ha nakot nohora la'a hya' maka ha niwra nhi'a. La' ir wo'itu de Mehuman, Bista, Harbona, Bigta, Abagta, Setar, me Karkas. ");
INSERT INTO lex_vpl VALUES ("ET1_11","018_1_11","EST","1","11","11","Noma nhopan pa rla rala ratu Wasti pa rodia la e' de de nawutu-nalai nian memna wutu-lai lodna-hairi. Ratu Wasti gaini maka samomuounu de ray niwra ntutga la'a o'ta-mata lalawna ror wutga mak ha npolniana-nwak nana re. ");
INSERT INTO lex_vpl VALUES ("ET1_12","018_1_12","EST","1","12","12","Mere la'pa mak ha nhopna re rakot nohora ray lirni la ratu Wasti, mere ratu Wasti edonna nwayow nan ray polpuollu de pa nahmena nmai, reiniande ray nahankeran memna! ");
INSERT INTO lex_vpl VALUES ("ET1_13","018_1_13","EST","1","13","13","Nhi'inde la'pa rler la emkade de ray nwahak lir la'a makat niohora deulu-tatra riorni-liaini. La hade pede rpolga makano'a-ka'atlia la' ray genni-tienni nanpena er makat niohora hota hya' ed maka ha retia la lir makemkare. ");
INSERT INTO lex_vpl VALUES ("ET1_14","018_1_14","EST","1","14","14","Maka nhi'inde ray ha npolpuol nieka de: Karsna, Setar, Admata, Tarsis, Meres, Marsena, me Memukan. Hare er maka kano'a-ka'atga ray Persia nora Media pede rhi'a o'ta mata tutullu la'a lodna-hairi. ");
INSERT INTO lex_vpl VALUES ("ET1_15","018_1_15","EST","1","15","15","Noma ray nakot la riy mandiditu re niwra: “A'g e ghopan pa mak khima-kre' a'u re rla rpolga ratu Wasti pa nmai a' di, mere nahmena nmai! Pa la'a deulu-tatra de hota hadi lol hya' talla?” ");
INSERT INTO lex_vpl VALUES ("ET1_16","018_1_16","EST","1","16","16","Noma Memukan nhar lirni pa nakot la ray nora o'ta mat lalawna korni pa niwra: “Hota la'a nhioli-liet mak emkare de ray edonna nmeh'a nlernana molmola-mama'a la'a ratu Wasti hihi'ini-yapyapni di, mere la'a o'ta-mata honona ror wutga a'na muanke'a honona la'a lodna-hair di nek de hota rru' rieri-rtowar rer wial lia'a ratu Wasti hihi'ini-yayapni di. ");
INSERT INTO lex_vpl VALUES ("ET1_17","018_1_17","EST","1","17","17","Yoma ratu Wasti nhiolli de hota nayatlin la'a a'na patke'a re honona, ne hota rakleha ya'unni-yamta'at la'a rima-rima muanke'eni. Hota patke'a re riwra: “Ray npolga ratu Wasti pa nma ntut gaini la ray nek de ratu Wasti nahmena nmai”. ");
INSERT INTO lex_vpl VALUES ("ET1_18","018_1_18","EST","1","18","18","Hya' ho'me ami! La' dodo'ondi mana mak kla o'ta-mata lalawani la hairi Media me Persia, a pat mamni mana ratlin nan oleka ratu de hihi'ini, pede hota a pat mamni re edon ratlin owa'an la mai ami. Pa hota narieiniande pata-mapra re honona edonna ratlin la hawni, me a'na muanke'a honona mana rahankeran rer lia'a patke'eni re mai ita lodanni-hairni! ");
INSERT INTO lex_vpl VALUES ("ET1_19","018_1_19","EST","1","19","19","La' hade pede ampak de hota tuna netlia totpa taken niana ratu Wasti nma ntutg owa'an gaini la tuna. Maka tuna hota ha netlia de rhi'a la riora-liai warwuaru id pa rnairia la mai Persia nora Media di lodanni-hairni totpena hya' maka tuna ha netlia de plollolli inhatta pa rnairia. Taken niana rherun doin riora-liai die. Nhor nianpena muala ratu Wasti mtatangenni della la' patke'a dom to'a maka nhiolli de nareh dioin Wasti nhiolli. ");
INSERT INTO lex_vpl VALUES ("ET1_20","018_1_20","EST","1","20","20","La'pa hya'a maka tuna ha netlia de nwewar la'a lodna-hair di liewnu, de hota a'na patke'a re honona ratu rhu'ru-rhelam la hawni muanke'a nayanni, la'pa rlernana kuku'uni-lalawanni ho'mana ra'unni-ramta'ata deulu-tatar de.” ");
INSERT INTO lex_vpl VALUES ("ET1_21","018_1_21","EST","1","21","21","Lir maka Memukan ha nakot de ray nora o'ta-mata re honona rwayow pa rnairia me ray mana nlernohora! ");
INSERT INTO lex_vpl VALUES ("ET1_22","018_1_22","EST","1","22","22","Dewade na'enyat horta-hairi pa nwewar la'a propinsi re honona la'a lodna-hairni de, de nnairia yawala nora nhiorta la'a leta-leta honona yawal wamueheni. La'a ray titni de lirni emkadi: “La'a roma nihi-lewu-nhiaiti wa, de hawa muanke'a ed maka khi'a o'tani la hade, me la' e' nanpena ed maka ketlia' hare honona.” ");
INSERT INTO lex_vpl VALUES ("ET2_1","018_2_1","EST","2","1","1","La'pa nto'or la' lera-mela re wa dewade ray ralamni mana edon nawen owa'an la Wasti, ne nhoratreria ratu Wasti. E nhioratni de enod rer mia'ta hihi'a-yapyap miaka ratu Wasti ha nhi'a la e'a me la walia' hya' maka e na nukmu oleka la ratu Wasti. ");
INSERT INTO lex_vpl VALUES ("ET2_2","018_2_2","EST","2","2","2","La hade pede maka nhi'inde kala lira-nio'a la ray re rwaror owa'an ralma-rior id owa'an de riwra: “La'pa tun ray nwayowa de tun ray nhopan pa rwahak owa'ana hararar mak gaini samomuou dom owa'ana, mak edon kora ma'ta muanke'a dom ranina, pa rala la tun ray. ");
INSERT INTO lex_vpl VALUES ("ET2_3","018_2_3","EST","2","3","3","Nhi' pa tun ray nrana mak ktulla-kar lia lodna-hairi la'a propinsi re honona totpena rwahaka pat harara samomuou honona re pa rma rottiarga la mai tun ray patke'eni re kruwungenni mai Susan di. La hande de Hegai mak khi' o'tani la mak ktulla-kar pa khima-kre'a tun ray patke'eni re, hota ed maka kwarora-kwalai niohora pat harara rwarora la'a yaroha-yararu, wu'ru-lena maka raneuga onde hya'-hya' to' maka rhi' ir pa gaini samouga (kecantikan) totpena yeher to' pa ir samounu na'ititar rer lia. ");
INSERT INTO lex_vpl VALUES ("ET2_4","018_2_4","EST","2","4","4","La'pa nhor nianpena tun ray ed maka namkek samomuou hameni ed maka kla tun-ray ralamni nanpena tun ray na'ala pa nwauga ratu Wasti.” Dewade ray nwayow nohora memna yano'a-yanat die pede pleta-plet pa nlernohora. ");
INSERT INTO lex_vpl VALUES ("ET2_5","018_2_5","EST","2","5","5","La' leta Susan de, de riy Yahudi ida nwawa Mordekai, Yair a'nani de. E' de Simei nora Kis duratni-waitni de la'a upa-tgara Benyamin, ");
INSERT INTO lex_vpl VALUES ("ET2_6","018_2_6","EST","2","6","6","maka ha rtoran nan hadella' lera Nebukatnesar, ray Babel nal makden Yerusalem la' yawa. La' ler de de ray Nebukatnesar ntoran nan wali Yehuda rayni Yekhonya pa rodia nor wutga makden Yehuda harahu pa rmai lia Babel. ");
INSERT INTO lex_vpl VALUES ("ET2_7","018_2_7","EST","2","7","7","Mordekai di de inni-narni raralamni ida de pat harara samomuou muaka inonni nawniaknaka, nanni Ester, mere nana tnietohora Ibrani de Hadasa. Ester inni-amni rmati olekwa la' ler ululu pede Mordekai na'ala pa nhi'a la a'na raralamni, ne Ester nlawlawan lola la'a Mordekai romni. ");
INSERT INTO lex_vpl VALUES ("ET2_8","018_2_8","EST","2","8","8","La'pa rakot nohora ray lirni la'a noha uhunu-ewatni, dewade pat hararara re mana, leta-leta rwaro'ona re pa rodia la Susan pa Hegai nhima-nre'a ir honona, me la'a ler de wal pia e ral walia Ester pa nor wali. La'pa rodia Ester la ray kruwun genni noma rala la Hegai mak khi' o'tani la ray patni kruwun genni de. ");
INSERT INTO lex_vpl VALUES ("ET2_9","018_2_9","EST","2","9","9","Hegai ralamni nayod reria Ester pede pleta-plet pa nhi' samomuou lia. Ntaw dioinia Ester pa rawu'ru-ralena rnairia hya'-hya' to' maka ha rhi' samuou gaini, me nwaliria Ester ya'an wamueheni. Ntaw dioinia Ester la'a harara dom pa nkenia la gen samomuou memna, la'a pata-mapra kruwungenni de, ne notil targa la pat harara mandiditu mak kwatiau ray kruwun genni pa rhoi-rtania Ester. ");
INSERT INTO lex_vpl VALUES ("ET2_10","018_2_10","EST","2","10","10","Mere Mordekhai nano' targ olek Ester de yan memmemna nalaharia Ester de Yahudi id e'a me yan nakot nohora enwatiawa he' luwnu-a'nani, pede Ester nlernohora e lirni. ");
INSERT INTO lex_vpl VALUES ("ET2_11","018_2_11","EST","2","11","11","Ne la' lera-ler nekpa Mordekhai nlola patke'a re kruwun genni gaini, totpa natiantan reria emkameni la Ester. ");
INSERT INTO lex_vpl VALUES ("ET2_12","018_2_12","EST","2","12","12","Maka lodna-hairi ha ror taru-rlai tiaru de: Pat harar maka ha rwaro'on nana re, de rawu'ru-ralena harella la'a anni ida. La wolla wonema de rnairia wu'ru maka ha rawah'a wutga la mur nanpena la' wolla wonem owa'an demade rnair targho'a wu'ru hup mikmikri dom owa'an to'a. La'pa nhorwua nampena rwei niek lerni maka ha rtutga pa harara re nenenan rla' ray Aswerus de. ");
INSERT INTO lex_vpl VALUES ("ET2_13","018_2_13","EST","2","13","13","La'pa hararar meni maka ha rpolga pa nla' ray die, nla' de plolli nek la pat de la' e naniayarni. ");
INSERT INTO lex_vpl VALUES ("ET2_14","018_2_14","EST","2","14","14","Rodi pat harara de la ray, de rwei nmel wa nanpena rodia la'a ray totpena ray nora ranin wutu la' mel de memna, nhor diemade repardoin nanpena rodia pat della la'a kruwun geni dom to'a, totpena Saasgas, riy mak kar lia hande, e' nanpena ed maka kamkek la'a ray hawni honona re. Hota pat harara de edonna rawali owa'an la ray. Yan to'a, ray nwet owa'an la nanni yoma ralamni nala pa npolg owa'ana. ");
INSERT INTO lex_vpl VALUES ("ET2_15","018_2_15","EST","2","15","15","Dewade nmai wia Ester nhiakarni pa rodia la ray. La' ler de de Ester, de Abihaila a'nani maka Abihail hyalli a'nani Mordekhai nhi'a la a'na raralamni, nlernohora hya' to' maka Hegai mak khi' o'tani la kruwnu patke'a de ed maka kano'a-ka'atga la'a naniairi maka ha nniar pa niwra nla ray. La'pa rodia Ester la' ray, de he'-he' to' mak kamkek e'a la ler de, rta'u-rta'g o'tani yoma ra'ulia la samounu. ");
INSERT INTO lex_vpl VALUES ("ET2_16","018_2_16","EST","2","16","16","Emkadella la' ler maka irodia Ester la ray Aswerus kruwun genni la'a wolla termidni maka ha riwra wolla Tibet la'a anni wo'it ralamni maka Aswerus nodi plolli la'a lodna-hair die. ");
INSERT INTO lex_vpl VALUES ("ET2_17","018_2_17","EST","2","17","17","La'pa rodi Ester de, Ester ed maka kla'nana ray ralamni pede ray nhioratni ndawarrer miamain la e'a. Ray sukni la e'a nareh mieman la'a ray patke'eni re honona me la'a hararara korni wali maka ha rwalir nian wutga la Ester. Noma ray Aswerus nala wutu-lai lodna-hairi pa nawutu-nalaiya, nherun doinia ratu Wasti la. ");
INSERT INTO lex_vpl VALUES ("ET2_18","018_2_18","EST","2","18","18","Nhorwua dewade ray nhi'a he'i-hepur lawna la'a wniatet mei pa na na'uli-nawedia Ester la geni-tienni me npolg awoka o'ta-mat lalawna ror wutga tniutnu-nhiani nhielli-liarni pa rma rhopnu-rpepan la mei wniatetni de wawannu. Ray nhopan pa rhaun la'a e lodanni-hairni de liewnu pa riy honona rrena la tulla-kniari. La' ler de wal pia rlernana ray limtutnu maka ray die niwra nala. ");
INSERT INTO lex_vpl VALUES ("ET2_19","018_2_19","EST","2","19","19","La' ler maka ha rawoka hararar re la re'eni wornu, de ray nran oleka Mordekhai pa nre'ela nkar lia' lodna-hairi. ");
INSERT INTO lex_vpl VALUES ("ET2_20","018_2_20","EST","2","20","20","Ester edon nakot nohor ma'ta la e' de de riy Yahudi id e'a me nwatiauga luwnu-a'nani meni, yoma Mordekhai nawewal targa Ester pa nhi' emkade. Ester nlernohor ma'ta Mordekhai lirni. E' edon nran inonni de narehi Mordekhai, mere nhi' inonni de emeknekama lera e kuku' ma'ta la'a Mordekhai mak ha nwanar de limni ralamni. ");
INSERT INTO lex_vpl VALUES ("ET2_21","018_2_21","EST","2","21","21","La' ler ida ne Mordekhai e nkarkiar rier lia ray kruwun genni, dewade riy woru mak katiak reri ray kruwun genni, id nanni Bigtan, me' id wal die nanni Teres, rora rna'ohma pa riwra rwenna ray Aswerus, yoma rora rahankeran rer lia ray die. ");
INSERT INTO lex_vpl VALUES ("ET2_22","018_2_22","EST","2","22","22","Rora nnia'ohmani de Mordekhai natlin nan nohora dewade nla' pa nakota la Ester. La'pa Ester natlin nana dewade nleretniekla nla nakota la ray la'a hya' maka Mordekhai nla nakot la e'a me nakot wal lia niwra Mordekhai ed mak kakot hade la e'a. ");
INSERT INTO lex_vpl VALUES ("ET2_23","018_2_23","EST","2","23","23","Noma ray nhopan pa rwata'wa nohora, de edonna nhal kuku' la, la'a Mordekhai ha nakota re. Noma ray netlia pa rla rwair wenna riy maroro'a re. Ne ray ed mak khopan pa rhorat targa hihi'a-yapyapi rella la'a puka tui-wedia lodna-hairi ralamni de, la'a ray die gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("ET3_1","018_3_1","EST","3","1","1","Noma rto'or doin lera-mela re wa dewade lera ida ne ray Aswerus niwra nhi' samomuou lia riy id mak kwawa Haman. Haman di de Hamedata a'nani la'a Agag duratni-waitni. Ray Aswerus niwra nhi' samomuou lia Haman pede nrana Haman pa nhi'a o'ta lawanni la o'ta-mata lalawanni re honona la' lodna-hairi die. La' talan emkade pede Haman nlernana ya'uli-yawedi nhiu'ru-nhielamni onnila ray hihi'ini-yapyapni de. ");
INSERT INTO lex_vpl VALUES ("ET3_2","018_3_2","EST","3","2","2","Noma ray nal titni la'a o'ta-mata korni honona totpena honona re rhu'ru-rhelam la Haman me rwaltiora-rwaltieman la e gaini ralamni. O'ta-mata re honona mak kar lia ray lodanni-hairni ratu ratlina-ratail la' ray titni de, eneknek to'ama Mordekhai nanpena mak kahmena katlina-katailla ray titni. ");
INSERT INTO lex_vpl VALUES ("ET3_3","018_3_3","EST","3","3","3","Noma o'ta-mata dom mak kar lia ray lodanni-hairni la'a ray kruwun genni de rma pa ratian la'a-mai Mordekhai niwra: “Hya'a nariei pia o' edonna mutlin la' ray titni dena?!” ");
INSERT INTO lex_vpl VALUES ("ET3_4","018_3_4","EST","3","4","4","Ne la' lera-ler nekpa riy rakot la pa natlina-natailla tit de mere Mordekhai edonna nha'wa nan etia lira ida. Mordekhai nakot la re niwra: “Ama-hyal miy re, a' di de riy Yahudi id a'u, pede taken niana aghi' nana.” Dewade rla rod lir la Haman, totpena rat muemna hota Haman nawenan pa nhukmua Mordekhai onnila hihi'ini-yapyapni de me edonna? ");
INSERT INTO lex_vpl VALUES ("ET3_5","018_3_5","EST","3","5","5","La' hade na'nama Haman e nat niohora de Mordekhai edonna nhu'ru-nhelma onde nwaltiora-nwalteman la, dewade Haman nahankeran rer lia. ");
INSERT INTO lex_vpl VALUES ("ET3_6","018_3_6","EST","3","6","6","La'pa natga de Mordekhai di de riy Yahudi ida di, dewade netlia pa rukum Mordekhai hota edonna nmeh'a, mere Mordekhai nor wutga riy Yahudi honona de, rwunu-rwenna pa rkuhi-rho'or doin momuoga la'a ray Aswerus lodanni-hairni. ");
INSERT INTO lex_vpl VALUES ("ET3_7","018_3_7","EST","3","7","7","La'pa ray Aswerus nodi plolli nana anni termida wehrani wor wua, la'pa nwaga la wolla yanulu la anin de, mak ha rweta la wolla Nisan, dewade Haman nhopna pa riy rhedga lotre (undi) la' e gaini ralamni totpena rat niohora ler meni-wolan meni ed maka ha rnairia pa rhi'a ira wniarora yatyatni de. Lotre di de makden hande rweta la purim. Dewade tniu'tu nerun la mei pa hota rhi'a la lera termidni wehrani wotellu, la' wolla termida wehrani wornu maka ha rweta la wolla Adar. ");
INSERT INTO lex_vpl VALUES ("ET3_8","018_3_8","EST","3","8","8","Noma Haman nla' pa nakot la ray niwra: “Tun ray, la'a it lodanni-hairni di de luwu-a'na (suku) id edama maka kanie'er la propinsi honona la lodna-hair di ralamni. Luwu-a'na de deullu-tatarni me hihi'ini-yapyapni nlol to'a la luwu-a'na korni. Ira nhiolli-lietni de rahmena rlernohora nie'era-tniatra la'a lodna-hair wawannu. Hade pede awuak de yana tuna nanin-namat niohora nhioli-liet mak emkade. Yoma luwu-a'na de edon nod untu hadom la tuna. ");
INSERT INTO lex_vpl VALUES ("ET3_9","018_3_9","EST","3","9","9","La'pa tun ray nwayowa de tun ray hota nhi'a horta id mak ha rodia la' meni-meni totpena rhopna rira pa rkuhi-rho'ora luwu-a'na de la noha wawannu. Ne la'pa tun ray nwayow nohora a ralma rio'ru di de pena agala perak talenta riwnu termida (perak kilu riwnu rahu wotelu terampwogat) pa agala la maktorna lodna-hairi di re'eni-tniarnu re pa rkenia la kah noha.” ");
INSERT INTO lex_vpl VALUES ("ET3_10","018_3_10","EST","3","10","10","La'pa ray natlin nan lir de dewade ray orgahani naul doinia kdielli mak kodia ray plolli-mneheni na'nama nala la Haman totpena hota Haman nto'a la hadom pa ndain wutwutga la horta-hair maka Haman ha nwahaka. Haman di, Hamedata a'nani la Agag duratni-waitni pede nhi' arwalli la riy Yahudi re honona. ");
INSERT INTO lex_vpl VALUES ("ET3_11","018_3_11","EST","3","11","11","Noma ray nakot la Haman niwra: “Luwu-a'na mak ha mukota re nor wut nieka kupan mutliawanni re de agala pa omuemueh'a muetlia. Plolli nek la hya' maka omuiwra mhi'a la ir wa!” ");
INSERT INTO lex_vpl VALUES ("ET3_12","018_3_12","EST","3","12","13","La'pa nte'ela lerni la'a wolla yanullu, lerni termida wehrani wotellu, noma Haman npolga riy mak khi'inde rhorta ray horatni-hairni, na'nama nhopna honona rhorta e lirni de rnairia rima-rima yawalli nora nhioratni la'a propinsi me luwu-a'na honona makden la lodna-hairi Persia. Rhorta horta re lirni de rweta la ray Aswerus nanni, me Haman mana nnairia ray kdielli de pa ndain wutga la horta-hair die. La' horta lirni de e niwra: “La'a lera termidni wehrani wotellu, la' wolla termida wehrani wornu maka ha rweta la wolla Adar dewade rwunu-rwenan momuoga riy Yahudi re honona kuku'uni-lalawanni, lokmera-papay onde mak kler olek la mto'oni-ppe'eni lerni, la'pa patke'a onde muanke'a mana, yana ha rlewan la wehla gai liokarni, ne re'eni-tniarnu honona mana reyahru momuoga. La' ler de meman pa rwunu-rwenan momuoga re.” Noma horta-hairi de, Haman nhopan pa riy pleta-plet pa rla' pa rodia la'a gubernur-gubernur ror wutga o'ta-mata re honona la'a propinsi re me luwu-a'na honona o'tani-matni totpena honona ratga. ");
INSERT INTO lex_vpl VALUES ("ET3_14","018_3_14","EST","3","14","14","La'pa rsampe oleka de hota o'ta-mata rhopan pa marinu nhaunia tit della la'a leta-ruhuna honona makden la propinsi re honona totpena rira rat niohor memna me rwahi' pa rwunu-rwenna Yahudi re la' ler mak ha rtutg oleka de! ");
INSERT INTO lex_vpl VALUES ("ET3_15","018_3_15","EST","3","15","15","Pede mak kodi horat re radil doin la pa rla rottiarga horta-hairi rella la'a propinsi makden la'a lodna-hair de yoma ray nhiopanni olek hade wa. Noma marinu nhaun wali pia nakot nohora tit della la'a leta Susan, Persia let lawanni de. Nhorwua noma ray nora Haman rla' pa rtepartarlia tgo' arka niemanu, mere tatlin la'a leta Susan de rkokna-rrarin nohora lir maka loda ha nhauni olek de. ");
INSERT INTO lex_vpl VALUES ("ET4_1","018_4_1","EST","4","1","1","La'pa Mordekhai natlin nana horta-hairi lirni emkade dewade nlihira-nnaiya polla-rainni la' temni na'nama nhu'ru la kadu (raini yaluli-yahona) yoma ralamni nmayo' pa emeknekama mak kaluli-kahona. Nkenia aw lia' o'tani na'nama nloh leta pa polpuolu-hawaunia la kniakru napolu-natniani. ");
INSERT INTO lex_vpl VALUES ("ET4_2","018_4_2","EST","4","2","2","La'pa nler la ray kruwungenni puohra lawanni gaini, dewade ntut tiar wua yoma riy mak knairia kadu de rwayotlia pa yana nler la rialma. ");
INSERT INTO lex_vpl VALUES ("ET4_3","018_4_3","EST","4","3","3","Ne la'a propinsi meni-meni to'a de la'pa titni nlergot wa dewade riy Yahudi re rapolu-ratnian wia. Ratahan lar pa koko'a-herera, me liawanni re rkenia awu nor kadu la tani wawannu pa ranin la wawannu totpa rtutga ralam mayo'oni. ");
INSERT INTO lex_vpl VALUES ("ET4_4","018_4_4","EST","4","4","4","La'pa patke'a rora muanke'a mak khi'inde khima-kre'a ratu Ester la'a kruwun genni de, rodia kot la Ester la'a hya'a maka Mordekhai ha nhi'a re, dewade Ester ralamni nmolu-nhelam doin la. Noma nhopan pa rla rottiarga pola-rain samomuou lia Mordekhai totpena na nherun doinia kad muaka ha nnairi re, mere Mordekhai nahmena na'ala. ");
INSERT INTO lex_vpl VALUES ("ET4_5","018_4_5","EST","4","5","5","Noma Ester npolga Hatah maka ray Aswerus ntutga pa nhima-nre'a Ester, pa nla natiana hya' ed mak kariei pia Mordekhai nhi' emkadena de? ");
INSERT INTO lex_vpl VALUES ("ET4_6","018_4_6","EST","4","6","6","Noma Hatah nla' pa natiana Mordekhai la'a ray kruwun genni puohrani gaini, la gen miaka kahgali (lapangan kota). ");
INSERT INTO lex_vpl VALUES ("ET4_7","018_4_7","EST","4","7","7","Dewade Mordekhai nakot momuoga e halli la Haman pede Haman niwa nwahla la e'a, me la' walia kupna-kai wo'ir maka Haman ha nano' tar pua hota nkenia la kah noha totpena riy Yahudi re honona la' meni-meni de rtipna-rwatna pa rkuhi-rho'or momuoga la'a lodna-hairi Persia wawannu. ");
INSERT INTO lex_vpl VALUES ("ET4_8","018_4_8","EST","4","8","8","Mordekhai nal walia horta maka ray ha nal de nhialanni mak kakot nohora hota rkuhi-rho'ora riy Yahudi noha wawannu. Mordekhai nano'a Hatah la' pa nala horat della Ester me nakot nohora lir de onni-ga'arni, me nano' wal pia Ester nmeh'a nla nwak lilili-mamuau lia ray totpena ntulla-nsaynia ir luwnu-a'nani Yahudi re. ");
INSERT INTO lex_vpl VALUES ("ET4_9","018_4_9","EST","4","9","9","Dewade Hatah nla'awa pa nakot nohora Mordekhai nnio'oni rella Ester. ");
INSERT INTO lex_vpl VALUES ("ET4_10","018_4_10","EST","4","10","10","Noma Ester nhopn owa'ana nawal pia nla nakot owa'ana emkadilla la' Mordekhai niwra: ");
INSERT INTO lex_vpl VALUES ("ET4_11","018_4_11","EST","4","11","11","“Mai handi de a'na muanke'a onde a'na patke'a maka edonna rpolga pa nma lola ray gaini, mere orgahani nekpa nla'a ray kruwungen de ralamni, de hota rukum penna, yoma deulu-tatr olek hade pa riy honona la'a mak kla' tniutnu-nhiani nhielli-liarni, la'pa lima-rora makden la propinsi re honona mana rat niohor oleka deulu-tatar de wa. Enekek to'ama talla id etla, pa ita edonna tlernan niukmu, de la'pa ray nrana lie'en mahani pa ntutga la riy de, la'pa ray nhi' emkade de nnia'eratni de riy de edonna nlernan niukmu. Mere la' wolla id ralamni di de ray edonna npol mua't a'u.” ");
INSERT INTO lex_vpl VALUES ("ET4_12","018_4_12","EST","4","12","12","Noma Hatah nla' pa nakot Ester nnio'oni della la' Mordekhai. ");
INSERT INTO lex_vpl VALUES ("ET4_13","018_4_13","EST","4","13","13","Dewade Mordekhai nwahla owa'ana Ester nnio'oni de pa niwra: “Yana mpuarora de hota o' edon mlier la wniunu-wnienan de yoma omdiella kruwun gen die, mere o' edon mha'wu nohora hupmu-woinmu Yahudi re pa honona e rmakokan wenna! ");
INSERT INTO lex_vpl VALUES ("ET4_14","018_4_14","EST","4","14","14","Hota o' molmuol tio'u la' genmu de pa edonna mpwo'la nohora nohwalmu re, mere emkade ho'mana hota riy Yahudi rlernan talan dom to' pa rler la mormiori-lewlewna, mere omuora ammu huwnu-woyanni hot tmat miomuou! Mere yanpa rtutg o' pa omlia ratu la' lera-mela ri totpena mhi' talan kalwiedwed id hadella pa Yahudi it tlerla yamori-yalewna?!” ");
INSERT INTO lex_vpl VALUES ("ET4_15","018_4_15","EST","4","15","15","Dewade Ester nal owa'an nnio'a la' Mordekhai de niwra: ");
INSERT INTO lex_vpl VALUES ("ET4_16","018_4_16","EST","4","16","16","“Ama, muwoka-mule'ga riy Yahudi honona makden la Susan di pa mukot la re totpa yan memmemna ra'ana-remun la' lera-mel pa wotelu totpa rsumbain mai a'u. Pena agor walia a hararar wa'lu maka nhi'inde khima-kre' a'u mana pena matahan walia lara. Nhor nioka a' orgahu lia' ray de, la'pa nwaghal ag ho'mana takot pa! Amuati-muor die la a rimormio'ru wawannu!” ");
INSERT INTO lex_vpl VALUES ("ET4_17","018_4_17","EST","4","17","17","Dewade Mordekhai nla' pa nhi' momuoga hya' maka Ester ha nano'a la e'a. ");
INSERT INTO lex_vpl VALUES ("ET5_1","018_5_1","EST","5","1","1","La'pa ntut meman la' lera wotellu la ler maka Ester natahan larni, dewade na'ala naniairi ratnu na'nama nnairia pa nler la ray kruwun geni la' rialma na'nama ntutrer lia ray genni gaini mere edon nla' ma't la rialma eneknek to'a e ntutrer mia'ta la nhiar mak kapal reria ray liwan genni de. Ne ray mana enaliwan targa la liwan genni mak kapal tiarga nhiar die gaini. ");
INSERT INTO lex_vpl VALUES ("ET5_2","018_5_2","EST","5","2","2","La'pa namkek nan Ester ntutrer lia tio'ora, dewade ralamni nahepru pa narieinian de nran nan lie'eni mahani pa ntutga la. Dewade Ester nala'a temna pa nheik la lie'eni de tutnu. ");
INSERT INTO lex_vpl VALUES ("ET5_3","018_5_3","EST","5","3","3","Noma ray natiana niwra: “Hya'a nhi o'a nare? Omuiwra mpuaka hya'a nare? Mukota! Ompuaka hya' to'a de hota agala. La'pa ompuatetar la'a a lodna-hai'ru di enawera la' woru muana hota agala tiy o'a!” ");
INSERT INTO lex_vpl VALUES ("ET5_4","018_5_4","EST","5","4","4","Noma Ester nwahla lirni niwra: “La'pa tun ray nwayow de, tun ray nora Haman rtiy pa rre'ela ra'an la'a maka agiwra ghoiya la tun ray ra'ana la' ler di.” ");
INSERT INTO lex_vpl VALUES ("ET5_5","018_5_5","EST","5","5","5","Dewade ray nhopan pa rpolga Haman pa nma natlin walia Ester polpuollu-wakwakni de totpena rewre'wa rla rod niohora. Noma rla'awa la Ester genni. ");
INSERT INTO lex_vpl VALUES ("ET5_6","018_5_6","EST","5","6","6","La'pa remremun reria arka noma ray natiana Ester niwra: “Hya'a maka ha muiwra mpuaka de mukot teka. La'pa hya' to' maka ha mpuaka de hota agala. La'pa ompuatetar la'a a lodna-hai'ru di de enawera la' wor muana hota agala tiy o'a!” ");
INSERT INTO lex_vpl VALUES ("ET5_7","018_5_7","EST","5","7","7","Noma Ester nwalolla niwra: ");
INSERT INTO lex_vpl VALUES ("ET5_8","018_5_8","EST","5","8","8","“La'pa tun ray nwayow nana a li'ru me alia' nana tun-ray ralamni, de tun ray nora Haman rmai owa'an pa rre'ela ra'an la'a mei maka agiwra ghoi lia' repar de nanpena a'ukot nohora a wakwa'ku la tun ray.” ");
INSERT INTO lex_vpl VALUES ("ET5_9","018_5_9","EST","5","9","9","La' lera Haman nora ray ra'an la' Ester meini pa nawal wia de Haman nahepur memna yoma Ester nhu'ru-nhelma enora ray pa npolu-nwaka ir totpena ra'an rewre'wa la mei wawannu. Mere la'pa nkil tiutga Mordekhai la'a ray kruwungenni puohra lawanni gaini de Mordekhai edonna ntutrier lia Haman gaini totpa ntutga nhiu'ru-nhielamni la e'a. Ya'unni-yamta'ata kuku' id mana edon ntutga la Haman, pa nhi'nande Haman na'andoin gahani la. ");
INSERT INTO lex_vpl VALUES ("ET5_10","018_5_10","EST","5","10","10","Mere emkade ho'mana Haman natahan neka ralam mehrani pa nod liarni la romni nayanni. Noma Haman nhopan pa rpolg awoka romhei wialli re ror wutga e patni Seres totpena honona rewre'wa rpa ratlin walia e wniahaurnu. ");
INSERT INTO lex_vpl VALUES ("ET5_11","018_5_11","EST","5","11","11","Haman nleretniekla npo'ona-npei nohora re'eni-tniarnu nor wutga upni-a'nani muanke'a harahu me la' walia ray ntutmuata-nkewra'a pa nareh momuoga ray limni malwiru-malgana re honona pede riy ra'uli e'a. ");
INSERT INTO lex_vpl VALUES ("ET5_12","018_5_12","EST","5","12","12","Me mak kreh mieman de, ratu Ester nahak e orgahi nmeh'a pa nora ray ra'an la ratu meini la' ler de. Ne ratu Ester npolg owa'an e' pa repar de nora ray ra'an la'a e meini wawannu owa'ana. ");
INSERT INTO lex_vpl VALUES ("ET5_13","018_5_13","EST","5","13","13","Mere emkade ho'mana a ralmu edon nahepur nohora hya'a maka aliernana re yoma a ralmu e namehra ma'ta la umkek Mordekhai riy Yahudi die namtatan rer nieka la'a nhiar liawna ray kruwungenni ralamni!” ");
INSERT INTO lex_vpl VALUES ("ET5_14","018_5_14","EST","5","14","14","La'pa ratlin nana hya' maka Haman nwahauria la ira, dewade Haman patke'eni nora rom heiwialli re honona rakot la pa riy rhi'a riri liawair geni id de tullu meter terampworu wehrani wolima, totpena repar yawyawar ma'ta de nla nwak la ray totpena rla rwairia Mordekhai la'a rir die hananni nampena hankeranni namdiaru totpena hota nor rewre'wa ray me ratu Ester ra'an wut lia la'a mei wawannu, de Haman ralamni namtierun wa. La' Haman wniarorni de lir maka ha rakota re de talanni inhatta, pede nhopan pa rhi'a riri liawair tutul die. ");
INSERT INTO lex_vpl VALUES ("ET6_1","018_6_1","EST","6","1","1","La' mel tetem de ray edonna nanina irannu-matni. Pede nhopan pa rla rala puka tui-wedi lodna-hairi maka e rhorta ray die hihi'ini-yapyapni la' ler maka e nodi plolli, demade rpaikia pa natlina. ");
INSERT INTO lex_vpl VALUES ("ET6_2","018_6_2","EST","6","2","2","La' puk de ralamni de e rhorat targa de e rakot nohor walia Mordekhai la' lera e ed maka kakota la ray la'a Bigtan nora Teres maka nhi'inde katiak reria ray kruwungenni, mere la' ler de de e riwra rwenna ray. ");
INSERT INTO lex_vpl VALUES ("ET6_3","018_6_3","EST","6","3","3","Pede ray e natian nohora la' hade, de rhi' hya'a la Mordekhai pa ra rwahla Mordekhai nhioli-liet kalwiedwedni, me rhu'ru-rhelma de emkameni la yala'ani? Mak khima-kre' ray re rwalolla ray riwra: “E edonna nlernan ma'ta hadomdoma.” ");
INSERT INTO lex_vpl VALUES ("ET6_4","018_6_4","EST","6","4","4","Noma ray nakot la re niwra: “La' dodo'ondi de he' etla a kruwun ge'nu ralamni dina?” Haman na'nama nmai pia ed olek la la'a ray kruwun genni la' rialma, yoma niwra nwak la ray pa rla rwairia Mordekhai la'a rir tiulul muaka ha rarir tiarga olek de wa. ");
INSERT INTO lex_vpl VALUES ("ET6_5","018_6_5","EST","6","5","5","Pede mak khima-kre' ray re rwalolla ray riwa: “Tun raya, Haman e nmai pia niwra nora tun ray rwatroma!” Noma ray niwra: “Mikot la pa nmai.” ");
INSERT INTO lex_vpl VALUES ("ET6_6","018_6_6","EST","6","6","6","La'pa Haman nler la rialam pa dewade ray natiana niwra: “Hota la' dodo'ondi de agiwra ghi'a nhiu'ru-nhielam lawna la riy ida. La o wniarormu de hota agala hya'a pa aghi' nan emkade?” Mere la Haman wniarorni de: “Hota he' ho' ed maka ha nakot dena? Nahmenmen nanama a' nianpena ed maka ray nakot de.” ");
INSERT INTO lex_vpl VALUES ("ET6_7","018_6_7","EST","6","7","8","Pede nakot la ray niwra: “Tun ray, mhuopan pa riy rodia tun ray nainiar plalahwani. Ne rod walia tun ray kudni id maka ha rkeni wutu-lai la wawannu totpena riy maka ray niwra nhu'ru-nhelam la de nha'at la kud de. ");
INSERT INTO lex_vpl VALUES ("ET6_9","018_6_9","EST","6","9","9","Noma o'ta-mat lawna id la'a lodna-hair de ed maka kapola-karainia riy maka tun ray ha niwra nhu'ru-nhelam la de, nhor nianpena nala' ulga pa nhaunu-nhaunu nohora la'a talla leta ralamni pa niwra: “Tuna ray ed maka khi' emkadilla la'a riy maka ha niwra nhu'ru-nhelam la de!” ");
INSERT INTO lex_vpl VALUES ("ET6_10","018_6_10","EST","6","10","10","Noma ray nakot la Haman de niwra: “Demade pleta-plet pa mlia mhu'ru-mhuelam la Mordekhai, riy Yahudi de. Mhi'a hya' honona maka omukot oleka re wa, de yana mhuoratdoin hadomdom maka omukot oleka re wa. Muala a rain plalahwanu nor wutga kud de. Hota omliernan Mordekhai la'a nhiar liawna gaini de e namtatan reria.” ");
INSERT INTO lex_vpl VALUES ("ET6_11","018_6_11","EST","6","11","11","Dewade Haman nla' pa na'ala naniair de nora kuda na'nama napola-naraini Mordekhai, nhorwua noma Mordekhai nhelia kuda hananni pa Haman ni'it la kuda talli na'nama nloha talla leta ralamni ne nhaun pa niwra: “Mia mimkeka! Tuna ray ed mak khi' emkadilla la'a riy maka ha niwra nhu'ru-nhelam la de!” ");
INSERT INTO lex_vpl VALUES ("ET6_12","018_6_12","EST","6","12","12","La'pa nhorwua dewade Mordekhai nawal lia la'a nhiar liawna ray kruwungenni de owa'ana. Mere Haman nti'il doinia pa nla'awa. Nmolu-nma'a pede npupun gaini pa nla'awa. ");
INSERT INTO lex_vpl VALUES ("ET6_13","018_6_13","EST","6","13","13","Noma Haman nakot nohora la patke'eni nora rom heiwialli re honona hya' maka ha nhi' oleka re honona. Nhor nia'nama hawni nora rom heiwialli mak khi'inde kano'a-ka'atga e'a rakot la Haman riwra: “Inee! La' dodo'ondi de Mordekhai nalernu olek o'owa, pa hota emkade pa nodi liarni. Hade de riy Yahudi ida de pede omhi' emkameni ho'mana ta'enniana omureh'i e'a. E' nanpena hota ed mak kal o' la yawa!” ");
INSERT INTO lex_vpl VALUES ("ET6_14","018_6_14","EST","6","14","14","La'pa rtepartarlia wniahauru ma'ta dewade mak kar lia'a ray kruwannu re rmai die rmahrur rier pia rodi Haman rla rwalliewan nohora Ester wniahihi'ini-wniayodin la'a meini wawannu. ");
INSERT INTO lex_vpl VALUES ("ET7_1","018_7_1","EST","7","1","2","Nhor nioka ray nora Haman rla pa ror Ester ra'an nana re'eni wornu la'a Ester mei wawannu. La'pa e remun reria arka noma ray natiana Ester niwra: “Nara, yanpa omuiwra mukot hadom de, mukota wa! La' hya'a maka ompuaka pa nahniakar worg ho'ola la'a lodna hairi di mana, hota gala tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("ET7_3","018_7_3","EST","7","3","3","Noma ratu Ester nakot la niwra: “La'pa tun ray nwayow nohora a'u die me alia' nana tun ray ralamni, de awuak pa agora a lu'wu-a'na wa'lu re yana rlernana wniunu-wnienna. ");
INSERT INTO lex_vpl VALUES ("ET7_4","018_7_4","EST","7","4","4","Yoma agor wut nieka a lu'wu-a'na wa'lu re honona de ha yaweli-yapar oleka am pia pa hota rwunu-rwenna doin meman ami. Mere la'pa ra'olga am pia rhi' am lia ata-wa'ara de awuarora de hade edon nhi' hadoma, ne a' muana hota a'g edonna mua ukot nohora owa'an la tun ray pa tun ray nwarora rupni-rupni. Mere la' hadi de hota rwunu-rwenan momuog ami!” ");
INSERT INTO lex_vpl VALUES ("ET7_5","018_7_5","EST","7","5","5","Dewade ray Aswerus natiana ratu Ester niwra: “He' nparan pia nhi' emkade tiy miy? Riy de etla hanme?” ");
INSERT INTO lex_vpl VALUES ("ET7_6","018_7_6","EST","7","6","6","Noma Ester niwra: “Haman e orgahani mak kamtatan di. Merni-metamni e inhatti maka khi' am lia arwalli, me e' ed maka knahora-knala' ami!” Dewade Haman namta'at nande gaini nwahra la ray nora ratu gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("ET7_7","018_7_7","EST","7","7","7","Ray nahankeran nande naprir dioin la mei maka e nemun reria arka la, ne nlergot wa, pa nla'awa la kruwun genni walli tio'ora. Haman nat muemna de ray hota nwaror oleka pa nwunu-nwen e'a, pede Haman edonna nwarei lia'a ratu Ester onni, totpena nwak pa Ester nalewn e'a. ");
INSERT INTO lex_vpl VALUES ("ET7_8","018_7_8","EST","7","8","8","Haman namta'at pa narieiniande nhoplia inonni la'a Ester lew ku'uni wawannu pa niwra nwak pa Ester nhuria e la'a hal wawna. Mere la'pa nhoplia inonni la' Ester lew ku'unu wawannu maka Ester etla wawannu dewade ray mana nhu'ru walia nmai rialam pa. La'pa nkillia Haman de la' Ester lewnu de wawannu, noma ray nkamota pa niwra: “Hya'a? Ha nparan pia niwra naga'aga ratu la handi la a ga'yu ralamni mai a kruwunge'nu di memna?!” La'pa ray nakot emkade, dewade mak khima-kre'a ray re rmai pia rpupnia Haman gaini. ");
INSERT INTO lex_vpl VALUES ("ET7_9","018_7_9","EST","7","9","9","Noma mak khima-kre'a ray id de mak kwawa Harbona nakot la ray niwra: “Tun ray, la'a Haman romni onni de orgahani enarir tiarg oleka rira liawair geni id de tullu metra terampworu wehrani wolima pa niwra hota nla nwairia Mordekhai maka kalewan nana oleka tun ray la'a ler de loo!” Dewade ray nal titni de niwra: “Mlia mpiairia Haman la'a riri die hananni!” ");
INSERT INTO lex_vpl VALUES ("ET7_10","018_7_10","EST","7","10","10","Pede rla rwair wenna Haman la'a riri liawair maka ha nhi'a pa niwra nla nwairia Mordekhai. La'pa rhi' emkade na'nama ray Aswerus hankeranni namdiaru. ");
INSERT INTO lex_vpl VALUES ("ET8_1","018_8_1","EST","8","1","1","La' ler de meman pa ray Aswerus nala Haman, riy Yahudi arwalli mak kmati oleka de re'eni-tniarnu nor wutga hopopani-lili'irnu me tani la'pa hare honona maka Haman gahani re la'a ratu Ester. Ester nakot nohor walia Mordekhai la' ray, niwra enor Mordekhai die de rwa'ina-rwanara pede la'awa ler de noma Ray npolga Mordekhai pa nmai. ");
INSERT INTO lex_vpl VALUES ("ET8_2","018_8_2","EST","8","2","2","Noma ray naul dioinia kdielli mak kodi ray plolli-mneheni. Kdiel de ed maka ray na' nan owa'an la Haman de pa nala la Mordekhai nnairia. Ne Ester nrana Mordekhai pa nodi plolli la'a hare honona maka Haman gahani re. ");
INSERT INTO lex_vpl VALUES ("ET8_3","018_8_3","EST","8","3","3","Nhorwua noma Ester nhoplia inonni la ray lakni noma nkakur pa nwak lilili-mamuau lia ray niwra: “Mtiulan pa mhuria ralammu totpena yan muod niohora Haman, Agag duratni-waitni de wniarora-wnialaini maka ha nakot oleka wa de hota rwunu-rwenan momuoga luwu-a'na Yahudi re honona.” ");
INSERT INTO lex_vpl VALUES ("ET8_4","018_8_4","EST","8","4","4","Dewade ray nrana lie'eni mahani la' Ester. Noma Ester naprir pia nakot la niwra: ");
INSERT INTO lex_vpl VALUES ("ET8_5","018_8_5","EST","8","5","5","“La'pa alia' nan tun ray ralamni de, me tun ray nwayow nan a wakwa'ku di yoma tun ray la'pa nwarora de talan plollol inhat hade, de tun ray nalgota horta-hairi ida totpena nherun doin horat maka Haman nhi' nan de pa na nakot nohora hota ha rwunu-rwenna luwu-a'na Yahudi mai lodna-hair di. ");
INSERT INTO lex_vpl VALUES ("ET8_6","018_8_6","EST","8","6","6","Hota awuarora emkameni la a ralmu la'pa umkek rer nieka a i'nu-na'ru ror wut nieka hu'wu-woinu re rwunu-rwenna la a ga'yu ralamni?!” ");
INSERT INTO lex_vpl VALUES ("ET8_7","018_8_7","EST","8","7","7","Noma ray Aswerus nakot la ratu Ester nora Mordekhai makden Yahudi de niwra: “Plola a'g ed maka kla wairi Haman, yoma eniwra nkuhi-nho'ora riy Yahudi rella ne agal oleka e gahani hya'a-hya'a honona la'a Ester wa. ");
INSERT INTO lex_vpl VALUES ("ET8_8","018_8_8","EST","8","8","8","Nah, dodo'ondi de a'g ed mak khopan pa mial horat totpena riy Yahudi re ramori-ralewna, de plolli nek la ha mimkeka pa samoga de mhiorta la' horat de ralamni. Miala na'nu me mniairia a kdie'lu de pa mkenia lodna-hairi ya'udalli (cap). Yoma horta-hairi maka ha ralgot de e rwet hadella ray nanni, me la' walia ray ed maka ka'udlia kdielli la'a horat de pa hota taken niana rhernia owa'an horat de.” ");
INSERT INTO lex_vpl VALUES ("ET8_9","018_8_9","EST","8","9","9","La ler de nekpa la' wolla wotellu, maka ha rweta la wolla Siwan, la lerni terampworu wehrani wotellu, de Mordekhai npolga makhorat ray horatni-hairni na'nama nhopan pa rhorta horta la gubernura re rora o'ta-mata la'a propinsi rahu ida terampworu wehrani wo'itu re la nwau lia India pa nla ntut lia Etiopia. Horta re, de rhorta la propinsi re nor leta-leta honona re rima-rima yawalli ror wutga nhioratni wamueheni. Rhorat walia horta rella la'a riy Yahudi re honona de rnairia ir yawalli nor wutga ira nhioratni. ");
INSERT INTO lex_vpl VALUES ("ET8_10","018_8_10","EST","8","10","10","Mordekhai nalgota horat de nwet la ray nanni ne nnairi ray kdielli pa ntapal wut wualia lodna-hairi hiwliai la horta re (cap kerajaan). Nhorwua de Mordekhai nhopan pa mak ha rtut niana pa rodi horta, pa rla rottiarga la propinsi re honona de rnairia ray kud wamueheni mak kawlari mermerni. ");
INSERT INTO lex_vpl VALUES ("ET8_11","018_8_11","EST","8","11","11","La' horta re lirni de e riwra ray orgahani e nhuria olek lirni pa riy Yahudi makden la' leta-leta re rawoka pa rod nian inonni. Ne la'pa hameni to' pa mak kwatiawua luwnu-a'na la'a propinsi meni-meni to'a, rmai pia rnairia keki-rautu pa riwra rwahak ya'arni la makden Yahudi re de, de hota Yahudi re rora la ya'ara totpena rwunu-rwenan wutga hawni-a'nani re honona nampena reyahru momuoga re'eni-tniarnu re. ");
INSERT INTO lex_vpl VALUES ("ET8_12","018_8_12","EST","8","12","12","Ler maka Yahudi re hota rod nian inonni la'a propinsi meni-meni la'a Aswerus lodanni-hairni de, de la'a lera-mela termida wehrani wotellu la'a wolla termida wehrani woru die, maka ha rwet la wolla Adar de. ");
INSERT INTO lex_vpl VALUES ("ET8_13","018_8_13","EST","8","13","13","Horta-hair maka ha rtapla hiwliwi lia de rala pa rwewar la propinsi re liewnu honona totpena luwu-a'na honona re ratga, totpena riy Yahudi re mana rta'wa matni re la arwalli maka kneltiarg olek de pa rma rwahak ya'ara la' ler de. ");
INSERT INTO lex_vpl VALUES ("ET8_14","018_8_14","EST","8","14","14","Dewade mak kodia horta-hairi re radil doin la ror wutga kudni re onnila ray nhiopanni pa rhakre'era la Babel propinsi honona. Ne la' letlawna Susan de mana rpaikia horat de pa rakot nohor walia hihi'a-yapyap die. ");
INSERT INTO lex_vpl VALUES ("ET8_15","018_8_15","EST","8","15","15","La'pa nhorwua noma Mordekhai nhoitio'or la ray ne nlergot wa nnairia wutu-lai miaha mak sapona. Ennair walia raini motmota me wawahra emekwalima maka ray nhi'inde rnairia, nor wut nieka rain plalahwani maka ha rhi'a la koka mnurnuhru maka ponpona. La'pa makden la leta Susan liewnu de ratlin nan horat de lirni dewade rahepur nohora. ");
INSERT INTO lex_vpl VALUES ("ET8_16","018_8_16","EST","8","16","16","Riy Yahudi makden hande mana ramuki-rahepur nohor memna. ");
INSERT INTO lex_vpl VALUES ("ET8_17","018_8_17","EST","8","17","17","Yahudi re la'a propinsi la'a meni-meni to'a mak katlinan olek horat re lirni rahepur memna pa rhi'a ya'an lawna-yemun lawna. Me Yahudi atia' mana rler wut lia Yahudi mutnu yoma ramta'at wenna Yahudi re mutnu. ");
INSERT INTO lex_vpl VALUES ("ET9_1","018_9_1","EST","9","1","1","La'pa ntutu-nte' meman la wolla termida wehrani wornu de wolla Adar, la'a lera termida wehrani wotellu. La' ler de ed maka hota ha rhi' nohora ray titni. La' ler de Yahudi arwalli re riwra rodi plolli la riy Yahudi re. Mere la'pa nwaldioinia noma riy Yahudi nanpena maka karehi ir la'a ar ralamni. ");
INSERT INTO lex_vpl VALUES ("ET9_2","018_9_2","EST","9","2","2","La' leta-leta re honona la'a ray Aswerus lodanni-hairni de, riy Yahudi rawok pa rna'ohma totpena rtutria riy meni mak kiwra kwunu-kwenna ira. Luwu-a'na la' meni-meni to' pa takeni ral ir la' yawa yoma ramta'at nande rmakuk tiarga. ");
INSERT INTO lex_vpl VALUES ("ET9_3","018_9_3","EST","9","3","3","Nahmenmen nanama o'ta-mat la luwu-a'na re honona makden la propinsi me o'ta-mat makden la'a bupati ne la' walia gubernur-gubernur la'a lodna-hairi rwaldioinia pa rhima-rre' owa'an riy Yahudi re yoma ramta'at la Mordekhai. ");
INSERT INTO lex_vpl VALUES ("ET9_4","018_9_4","EST","9","4","4","Yoma Mordekhai di de riy inponni la'a kruwun genni me makden la'a lodna-hairi liewnu de ratg oleka Mordekhai nanpena ed maka ktorna-kraut la'a ray kruwungenni de pahna (berkuasa). Ne e plolli-mneheni de e na'ititar rer lia liawanni. ");
INSERT INTO lex_vpl VALUES ("ET9_5","018_9_5","EST","9","5","5","Emkadella la'a plolli nek la riy Yahudi hihi'ini-yapyapni la'a ir arwalli honona, ne rhapartiklia pa edonna rlewan la wehla ara gai liokarni. ");
INSERT INTO lex_vpl VALUES ("ET9_6","018_9_6","EST","9","6","6","La'a kruwun genni onni la' leta Susan de, nek de riy Yahudi rwenan nana riy rahu wolima. ");
INSERT INTO lex_vpl VALUES ("ET9_7","018_9_7","EST","9","7","10","Maka ha rwenna re, de e rwenan nan walia Haman upni-a'nani muanke'a riy termida. Haman di de Hamedata upni-a'nani makla' riy Yahudi arwalli re. Ne Haman a'na muanke' termida mak ha rwenan nana re de nanni de Parsandata, Dalfon, Aspata, Porata, Adalia, Aridata, Parmasta, Arisai, Aridai, me Waisata. Mere la' ar de ralamni de riy Yahudi id mana edonna reyahru hadomdoma. ");
INSERT INTO lex_vpl VALUES ("ET9_11","018_9_11","EST","9","11","11","La' ler de wal pia rmai pia rodia kot la ray, la'a riy wo'ir maka ha rwunu-rwenan nan oleka la Susan kruwungenni onni de. ");
INSERT INTO lex_vpl VALUES ("ET9_12","018_9_12","EST","9","12","12","Noma tun ray nakot la ratu Ester niwra: “Mai Susan kruwungenni onni di nmeh'a nek de riy Yahudi rwen oleka riy rahu wolimpa, ne e rwenan wut wualia Haman a'nani riy termida re. Hya' ho'ame la'a propinsi korni ho'a, de matialo'onama rhi' emkade wal lia hande. Nara, hya' maka hota ha mpuak owa'an mai a'u, yan mumta'ata nara! Hota gala re!” ");
INSERT INTO lex_vpl VALUES ("ET9_13","018_9_13","EST","9","13","13","Noma Ester nwahla lirni niwra: “La'pa tuna nwayow de, riy Yahudi mak kden la Susan di, de repar ir rhi' owa'an la'a hya' maka ha rhi'a la ler di, mere hota rhi'a la letlawna Susan uhunu-ewatni. Me totpena ra'ala Haman upni-a'nani maka ha rwenan nan oleka re pa rla rwairi la'a riri au liawair geni re.” ");
INSERT INTO lex_vpl VALUES ("ET9_14","018_9_14","EST","9","14","14","Dewade ray nleretniekla nal titni pa rhi'a hya' maka Ester ha nwaka la ray, noma horta hiwliai ralgota totpa makden la Susan rwahi'a-rwayod pia ra'ara, me Haman a'nani termida mak ha rwenan nana re de rla rwair momuoga re! ");
INSERT INTO lex_vpl VALUES ("ET9_15","018_9_15","EST","9","15","15","La'pa repar pa la' wolla Adar lerni termida wehrani wogat wa noma Yahudi re rawokwok owa'an pa rwunu-rwen nan owa'an riy rahu wotelu la let Susan uhunu-ewatni de neka, mere edonna reyahru hadomdom la' let de ralamni. ");
INSERT INTO lex_vpl VALUES ("ET9_16","018_9_16","EST","9","16","17","Ne la'a wolla Adar lerni termida wehrani wotellu de riy Yahudi maka kden la'a propinsi re honona mana rawokwok wal pia rod nian inonni la yawunu-ya'ara totpena yana ir arwalli re rhi' yatyatni la ira. Ne irwunu-rwenan nan arwalli riy riwnu terampwo'itu wehrani wolima. Mere edonna reyahru arwalli hyonni-hyanni. Wniunu-wnienan lawan de, la'a wolla Adar lerni termida wehrani wotellu. Mere la'awa repar pa wolla lerni termida wehrani wogat wa dewade ir edonna rwunu-rwenna rimormior wia mere nrena pa ramuki-rahepur rhi' ya'anlawna-yemunlawna la'a ler de. ");
INSERT INTO lex_vpl VALUES ("ET9_18","018_9_18","EST","9","18","18","Mere la'a letlawna Susan de riy Yahudi ramuki-rahepur rhi'a ya'anlawna-yemunlawna la'a lera termida wehrani wolimni la' wolan de ralamni, de emaknekama lerlalawna ida, yoma rwunu-rwen oleka arwalli la'a lera termida wehrani wotellu me la' walia lera termida wehrani wogatni la' wolan de, na'nama rwair la ara la'a lera termida wehrani wolimni la' wolan de wali. ");
INSERT INTO lex_vpl VALUES ("ET9_19","018_9_19","EST","9","19","19","Mere makden la'a let kuku'a rhi'a wniunu-wnienan lawna la'a wolla lerni termida wehrani wotellu demade ramuki-rahepur nohora la'a lerni termida wehrani wogatni. La' hade pede riy Yahudi makden la let kuke'a re rhoratreria wolla Adar lerni termida wehrani wogata pa ramuki-rahepur nohora, me idma nara'a-napalg id la'a ya'ana-yemnu. ");
INSERT INTO lex_vpl VALUES ("ET9_20","018_9_20","EST","9","20","20","La'pa ha rhorwua dewade Mordekhai nhorat tar momuoga hare honona la'a puka id ralamni na'nama nhi' horta pa na'enyatga la riy Yahudi re honona la'a ray Aswerus lodanni-hairni uhunu-ewatni-ewatni-lahwani. ");
INSERT INTO lex_vpl VALUES ("ET9_21","018_9_21","EST","9","21","21","Horat de lirni de totpena la'awa la' wolla Adar lerni termida wehrani wogatni me wehrani wolimni, de rhoratreria pa rhi'a ler maroro'a rella la'a lerlalawna, la' anni-anni. ");
INSERT INTO lex_vpl VALUES ("ET9_22","018_9_22","EST","9","22","22","Yoma la lera-mella re ed maka irareh niana ira arwalli pa nhi'nande ir luini-nuhranu me mehrani-maunu nwaltiargho'ola lewliewru-tartiarni nora muki-hepru. Hade ed mak kariei pia nhi'inde ramuki-rahepur la'a lera re, me rhi'a ya'anlawna-yemunlawna me la' walia rod wialia rira wra'u nhioini, nor wutga rodia limtut lia'a a'na riy patyata. ");
INSERT INTO lex_vpl VALUES ("ET9_23","018_9_23","EST","9","23","23","Riy Yahudi honona re ratu rhu'ru-rhelam la Mordekhai lirni-tunnu mak ha nakota, pede rhi'a lera he'i-hepru maka ha rakot oleka re de emekwalima ira deullu-tatarni la'a anni-anni. ");
INSERT INTO lex_vpl VALUES ("ET9_24","018_9_24","EST","9","24","24","Yoma ir rareh nian oleka ir arwalli Haman, Hamadata a'nani la'a Agag duratni-waitni de maka nhi'inde kora riy Yahudi honona emeknekama hunkadkiadia. E' ed mak kwaror pa kiwra kwunnu-kwenna riy Yahudi honona. Nwahedg oleka lotre totpena ret tiar lia ler maka ha riwra rwunu-rwenna riy Yahudi re. Lotre di nhi'inde makden hande ha rweta la purim. ");
INSERT INTO lex_vpl VALUES ("ET9_25","018_9_25","EST","9","25","25","Mere la'pa ray natlin nan nohora hade noma ray nala horta maka ha rnairia hiwliai lia, pa narieiniande Haman wniaror yatyat de ntuin tar targho'ola Haman nor a'na wamueheni re. Ne ir er maka klernan ira liawair geni hananni. ");
INSERT INTO lex_vpl VALUES ("ET9_26","018_9_26","EST","9","26","26","Lotre maka Haman nnairia re de rweta la purim. La' hade pede la'a lerlalawna re, de makden Yahudi re rweta la Purim. Mordekhai horatni me la' walia hya' maka riy Yahudi ha rlernana me ramkek oleka ");
INSERT INTO lex_vpl VALUES ("ET9_27","018_9_27","EST","9","27","27","ed mak katota-kariei niande ir orgahi rmeh'a rhi' nan owa'ana riora-liai id owa'an la'a ir rora duratni-waitni, me la' walia riy honona maka kiwra kler wut lia riy Yahudi luwnu-a'nani. La'a riora-liai miaka ha rhi'nande hota la' anni-anin nekpa ir honona ramuki-hahepur la' lera rora maka Mordekhai e nror targ oleka re wa. ");
INSERT INTO lex_vpl VALUES ("ET9_28","018_9_28","EST","9","28","28","Erakot tar wualia de la' lera Purim de de riy Yahudi rora duratni-waitni honona yana rhoratdoinia yahe'i-yahepru la pa nodia pa noh niata. Me makden Yahudi honona la'a luwu-a'na honona, la'a leta-leta re honona la'pa propinsi re honona mana yana rhoratreria yahe'i-yahepru la' ler de la'pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("ET9_29","018_9_29","EST","9","29","29","Noma Ester, Abihaila a'nani de nnairi e plolli-mneheni pa emeka ratu pa nhi'a horta id owa'ana. Nor wutga Mordekhai riy Yahudi die rhort owa'an horta id totpena rhi' aruri horat maka Mordekhai ha nhi' a de pa na nakot nohora lerlalawna Purim. ");
INSERT INTO lex_vpl VALUES ("ET9_30","018_9_30","EST","9","30","30","Ra'enyatga horat rella la'a riy Yahudi honona la'a propinsi rahu ida terampworu wehrani wo'itu makden la'a ray Aswerus lodanni-hairni. Rhi'a horta re de rwaka totpena riy Yahudi re rmori-rdar lia kalwiedni-paitiotni, de ernairi lir mak kaplollola. ");
INSERT INTO lex_vpl VALUES ("ET9_31","018_9_31","EST","9","31","31","La' horat de, de eriwra Yahudi re la' meni-meni to' de hota retlia pa ir ror walia ira duratni-waitni yana rhoratdoinia rahe'i-rahepur la' lera-lera Purim, la' ler maka Mordekhai nora ratu Ester rakot oleka de la' horatni ralamni. Ne hota ramuki-rahepru la lera maroro'a re la'a anni-anni nekpa rlernohora hya' maka nhi'inde Yahudi re rhi' nohora oleka la' lera-lera re maka ha rtutg olek pa ratahan lara nora raluli-rahona, totpena rpolu-rwak la Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("ET9_32","018_9_32","EST","9","32","32","Ester horatni de narur niana Mordekhai horatni mak kakot nohora Purim riorni-liaini, ne ratu Ester nhopan pa rhorta riora-liai re la'a lodna-hairi pukni ralamni. ");
INSERT INTO lex_vpl VALUES ("ET10_1","018_10_1","EST","10","1","1","Ray Aswerus nhopan pa limni-rorni honona rpairi blastena, de edonna ntot nan to'a riy maka kholi-kletla la noha gaini, mere nawniatniat momuoga leta-ruhuna honona, makden la enhu'ula-ga' laini, pa nwewar la'a makden la wo'ora-kawru. ");
INSERT INTO lex_vpl VALUES ("ET10_2","018_10_2","EST","10","2","2","Ne rhorat targa la lodna-hairi Persia rora Media pukni ralamni la'a hare honona maka ray de nhi' nana de nodia preheni-mkaini inponni. Me rhorat tar wual momuoga la'a Mordekhai nla'a o'ta-mata tutulu-pepetna la lodna-hair die, onnila ray Aswerus nran e'a. ");
INSERT INTO lex_vpl VALUES ("ET10_3","018_10_3","EST","10","3","3","Mordekhai riy Yahudi miaka ha rrana pa ktorna-krauti olek de, eneknek to'ama natlin la ray Aswerus. E' de genni-tienni nareh dioin makden Yahudi re honona. Mere makden Yahudi re ratu rhu'ru-rhelam nohor la Mordekhai yoma honona ralamni rapliorlior la' nohwalli de. Yoma Mordekhai die nkar toto' meman pa namkek la'a e nohwalli honona re mormiorni-dardiarni totpena rler la kalwiedni-paitiotni. ");
INSERT INTO lex_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","La' lera ida, plinu-plinnianama ORGAHI-ORHA'A Nhar lirni pa nakot la Yunus, Amitai a'nani de, ");
INSERT INTO lex_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","Niwra: “Yunus ee! Pleta-pleta pa mlia'awa la' letlawna de mak ha rweta la Niniwe, pa mukot la ira de hota Agukmua re yoma Agat niohora makden Niniwe re yatni-halli lawan rehi'a.” ");
INSERT INTO lex_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Mere Yunus nahmena nlernohora pede nawlar targho'ola pa nokria Tarsis totpena olieta la ORGAHI-ORHA'A. La' noma enlola leta Yopa. La' hande nlernana kapli id niwra nwair watnu pa nokria Tarsis. Noma nleretniekla npair doinia kapli siewni pa nlernohora a'na kapli pa rokria Tarsis totpena olieta la ORGAHI-ORHA'A. ");
INSERT INTO lex_vpl VALUES ("JH1_4","033_1_4","JON","1","4","5","La'pa kapli nwaran wa dewade Yunus nerun la la' kapli wikwikni na'nama nanin hala. Edon nalo'on wali ne ORGAHI-ORHA'A Nala anin lawna pa nreiniande kakmoran lawna niwra nweyata-nwaniaga kapil de. A'na kapli re rdiwra-rda'al nande rpolpuol inni-rwakwak amni la'a rima-rima uplerni-upmatni. Noma rte'la la yohya' makden la kapli wawannu pa rhopliergernia totpena kapli nahgali pa nariana. ");
INSERT INTO lex_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","La'pa yormudi la kapil de nerun pa nla namkek la kapli wikni, de nhortiut niana Yunus e naninhala la hande. Noma yormudi de nakot la Yunus niwra: “Hoi! Emkameni la o wniaromu pede o mumkek reria anin lawan di mana o' emuni'nu mai handina?! Mumat pa mpuolu-mpuak tek la la'a o uplermu totpena yanpa e sniayanni demade itler targho'ola kalwiedwedni.” ");
INSERT INTO lex_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","La'pa Yunus nor yormudi de rha'at la heyanan wa, noma a'na kapli idma nakot la ida riwra: “Mai pia it twahedge lotre (undi) lia it hononita totpena tat muemna he' ed mak khala pede itler la kropna-krieutu mak emkadi!” La'pa rwahedga lotre wa noma rhed niana la Yunus limni ralamni. ");
INSERT INTO lex_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Noma honona ratiana Yunus riwra: “Hota he' hihi'ini ed mak karei piede itler la kropan lawan dina? O kniarmu hya'a? Ompuatiawu hanmeni? Hya' noha mniotni me luwnu-a'nani meni o' pede omua muor amtialla?” ");
INSERT INTO lex_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Noma Yunus nwalolla niwra: “A' di de riy Ibrani miaka kkola tieru-kawur nehla la ORGAHI-ORHA'A de Uplerlawna makdella Ilyamou-Watyatoha. E' ed mak kakoki-kayap niana gera-tahi' la'pa nohkerna-rai miaran di honona.” ");
INSERT INTO lex_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Me nwahaur momuoga hya' ed mak karei pia enawlar dioinia inonni la ORGAHI-ORHA'A. La' a'na kapli re ratlin nana hya' maka ha nwahauru re de honona ema rtaplele'er targa ne rdiwra-rda'al nohora yamta'atni, pa rakot la Yunus riwra: “Riy yatyat id o' di lee! Hya' mak karei piede omhi' nan emkadena?!” ");
INSERT INTO lex_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","La'pa rtepartarlia yaltieri mere yeher to'ama kakmor lahu orloi-orta'ara lol walli-walli pede rakot la Yunus riwra: “Inee! Hota amhi' emkameni la o'a totpena kakmoran di nalina-nalera?” ");
INSERT INTO lex_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Noma Yunus nwalolla re niwra: “Mpialiakar nek alia la'a hletan lawan di wa, totpena nalina-nalera. Yoma agat memna la a'g ed mak karei piede mimlier hletan lawan maka kayo'ora-ka'anin di.” ");
INSERT INTO lex_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Mere la'pa nakot emkade ho'mana a'na kapli re rodia rur miatmiata la wniain nohor la kapli pa rler la liwu ralamni (rler la keranni). Hade ho'mana taken niana rler la hande, yoma yeher to'ama yo'or tutulu ema rkanaini-rkanainia pa nwakloli-nwaklalia ir la kapli. ");
INSERT INTO lex_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","La' hade pede honona re rpolu-rwak la ORGAHI-ORHA'A riwra: “Orgahi-Oraha'anu ne! Ampolu-ampak pa yan Mual am pia amler la matmiati-molmuolu yoma hota amakwara riy di nhiwni. Yanpa riy di edon nhala. Mere ampakwak pa yana Mukmua ami, Orgahiya! Yoma Orgahi-Orha'anu ne, O orghamu ed maka khi' oleka hya' maka orgahamu Mpuaror nana.” ");
INSERT INTO lex_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Dewade ra'ala Yunus pa ratrernia la hletan lawna ralamni. Dewade nalina-nalera. ");
INSERT INTO lex_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Honona re rleretniekla ramta'at wenna la ORGAHI-ORHA'A, ne rala hoihoi-tantiani la ORGAHI-ORHA'A me rakot targa de hota rhi' hadomdom pa rhi' amikria ORGAHI-ORHA'A ralamni. ");
INSERT INTO lex_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","La'pa rhi' hare wa noma ORGAHI-ORHA'A Nala upwornu pa nma lum niana Yunus pa nden nek la upworun de apannu pa nla' nana lera-mela wotelu. ");
INSERT INTO lex_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","La'a up wornu apannu ralamni de Yunus nsumbain la ORGAHI-ORHA'A, e Uplerlawanni ");
INSERT INTO lex_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","niwra: “Orgahi-Orha'anu ne! A'g etla klieratni di pa apuol oleka tiy O'a, ne Mpuahla nan a li'ru. A'g etla noh mati-rai miolu pa awuaka tniulan tiy O'a. Ne Mhueri tlinmu-mpual miatmu olek la'a a polpuo'lu. ");
INSERT INTO lex_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","O ed maka kwaliakra alia la'a geni kdieldelma la'a hletan lawna wikwikni. Gera tahi' nora wawuau liawna rado'y a'u. Yo'or tah'i lawna mak Omuala re nwakloli-nwaklali a'u. ");
INSERT INTO lex_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Awuaror la' a ralmu giwra: “ORGAHI-ORHA'A Nhokr olek alia la' E gaini ralamni we! Mere hota alina-muat owa'an la E roma nayanni mak kmou-kwitna dena!” ");
INSERT INTO lex_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","La'pa tahi' lola tieru de a'g etlia hletna-yoiri letgara-mneneheni. Illu-retre'eta nawniotra-natniallia la' a o'tu. ");
INSERT INTO lex_vpl VALUES ("JH2_6","033_2_6","JON","2","6","7","Awuakliolli erun la' wo'or tutulu nayanni la'a noha wikni-ray gerni. Awuarora de alier olek la noha mati-rai miolu me hota a'g edon liergot owa'ana yoma pinta puohrani erayahro'pa pa nodi liarni. La'pa nhi'pa awaran doin a arnu na'nama aghoratna'nu pa a puol tiy O'a, Orgahi-Orha'anu ne! Dewade a sniumbainu de O e Mutlin reria la'a O genmu-tienmu mak kmou-kwitna. Dewade O' orgahamu ed maka kamori-kalewan a lia' noha mati-rai miolu. Oo ORGAHI-ORHA'A Uplerlawnu nee! ");
INSERT INTO lex_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Riy mak kden rer lia kniola tieru-niawur nehla la hya' mak kakleha ruri-lai, de la'a uplera-upmati, rawlar dioin olek O'o wa, mak ktutga O ralam kalwiedmu la'a rimormiori! ");
INSERT INTO lex_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Mere a' di de hota agal hoihoi-tantiani la' O'a de awuatunu-wahniar pa ga'uli-uwed re'ru. Ne la'a hya' maka a'g wuettar tiy O'a de hota gala. ORGAHI-ORHA'A, plollolli de O' inhatta ed maka kamori-kalewn rimormiori.” ");
INSERT INTO lex_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Nhorwua dewade ORGAHI-ORHA'A ed mak khopan pa worunlawan de nadewar gota Yunus la'a keranni. ");
INSERT INTO lex_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Noma ORGAHI-ORHA'A Nhar lirni la re'eni wornu la'a Yunus. ");
INSERT INTO lex_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","Niwra: “Yunus pleta-plet pa mlia'awa la Niniwe, la letlawan de, pa mukot nohora ir la hya' maka A'ukot tiy o'a re.” ");
INSERT INTO lex_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Noma Yunus natlin la ORGAHI-ORHA'A lirni pa nler pa nla'awa la Niniwe. Let de let sapon lawna id hade. Pede la'pa itiwra tawloh nana hota tala'a la lera wotelu memna. ");
INSERT INTO lex_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","La' ler tetema id ralamni de Yunus nala' pa nlola let de plahwani, na'nama nharlini pa nakot nohora Uplerlawna lirni niwra: “Tre' ma'ta lera terampwogat pa hota Niniwe namkoha-namnanni!” ");
INSERT INTO lex_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Noma let de mniotni rpesiaya Uplerlawna nnio'oni de. Dewade leta mniotni honona retlia pa hota honona ratahan ya'ana, me kuku'uni-lalawanni rnairia rainia yaluli-yahona totpena rtutga de iriwra rhoitio'or doini-rtahnei dioin ir do'oni-halli. ");
INSERT INTO lex_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","La'pa ray Ninwe natlin tutga kot de dewade nerun la liwangenni. Noma no'lu doinia rain lawna lodna-hairi, na'nama nohga rain yaluli-yahona la inonni, me namtatna la awu li'ina wawannu. ");
INSERT INTO lex_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Noma nala tita ida me nhopan pa riy rla rakot nohora riwra: “Tit di de ray Ninwe nora mentrini re ed mak kalgota. De totpena rimormior rora nhiurni-wnia'anni honona la' let di de yan ra'ana-remnia hadomdoma. ");
INSERT INTO lex_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Rimormiori rnairia naniayarni la inonni mak ktutga de rhoitio'or doin-rtahnei dioin oleka do'oni-halli, ne rweran targa nainiayarni mak emkade la nhiurni-wnia'anni wawannu wali. Riy honona hota rpolu-rwak rer lia' Uplerlawna. Honona re rhopliala hihi'ini-yapyapni yatyatni-halalli la'a ir rimormior wialli la'pa do'oni-halli honona re. ");
INSERT INTO lex_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Twakwak de Uplerlawna pen neka Nhuria ralamni pa edonna Nwahla it do'oni-halli. Twakwak de Enherun doin hya' mak E Neti olek wa totpena yana tler la yatyatni-halalli yatlorni-yatra'ani!” ");
INSERT INTO lex_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Uplerlawna Nlin reri-nmat reria hya' maka ha rhi'a re. E orgahani Namkeka de honona rolin doini oleka nhiolli-lietni mak khala re olekwa. Dewade E orgahani Nherun doinia hya' maka E Neti oleka wa, me edonna Nukmua re. ");
INSERT INTO lex_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Mere Yunus ralamni edonna nreiniana hya' maka Uplerlawna ha Nhi'a, ne yeher to'ama ralamni namehra. ");
INSERT INTO lex_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Noma nsumbian pa nakot la ORGAHI-ORHA'A niwra: “Orgahi-Orha'u ne! La' lerni la a'g edon liergot ma'ta la' a noh'u, de agatg oleka wa de hota Omhi' mak emkade. La' hade pede pleta-plet pa a'uwlar pia liawa la' Tarsis wa! Agatga de O' de Uplerlawna maka ksayni onni O'a. Omhur niohora plalahwa rira do'oni-halla la O'a, me Omherun doinia hya' maka Omueti olek la wa pa edonna Mukmua owa'an ira, onnila Omtiutga ralam kalwiedmu la'a riy honona. ");
INSERT INTO lex_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Pede Matroma, samuounu de Mhi' a pua amuat niek wa totpena yana amuormiori pia a'umkek O hihi'imu de.” ");
INSERT INTO lex_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Noma ORGAHI-ORHA'A Nakot la Niwra: “O' mukleha nhiapargen pia omuwenna emkade.” ");
INSERT INTO lex_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Nhor nioma Yunus nla'awa la leta Niniwe walli tipru na'nama nhi' nana hoiwiali id pa namtatna la' hande totpena nwei tieka hota hya'a ed maka Uplerlawna Nala la'a leta Niniwe. ");
INSERT INTO lex_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Dewade ORGAHI-ORHA'A Uplerlawna-Mempulwatnu Nala au id pa nmor die akni plo'a-plahwa me npoti-nkadwu totpena Yunus ndella nayanni de nayahew samomuou pa yana pahna rehia. Ne Yunus ralamni nahepuepru onnila au die. ");
INSERT INTO lex_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Mere la'pa repardoin yawyawar ma'ta noma Uplerlawna Nhi'a orna id pa na'ana au die ga'arni pa leretniekla napliau. ");
INSERT INTO lex_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","La'pa lera nhit wa noma Uplerlawna Nala anin panpahna pa nten die nwatiawu tipru. Tre' kuku' pa Yunus niwra napru'wu la yawa yoma lera pahnani emeknekama ai kwiari la o'tani. Nakot la Uplerlawna de edonna nwaror nan oleka mormiori wa, samouounu de enmat niek wa. ");
INSERT INTO lex_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Mere Uplerlawna Nakot la Niwra: “Omukleha nhiapargen pia omuwenna onnila au die napliawua.” Noma Yunus nakot la niwra: “Nihya'pa a'g edon uwenna, la'a plolloli de awuenan meman pa agiwra muati.” ");
INSERT INTO lex_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Noma ORGAHI-ORHA'A Nakot la Niwra: “Yawulla-yatniamin de ha nmor ti'ola' mela ida, me hota napliau lia' mel mak kmai. Taken niana omhi'a pa nmori me o' edonna mtiera. La'pa emkade ho'mana o ralammu e ntuindoin la yoma au die napliau wa?! ");
INSERT INTO lex_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Mere Ompuarora de hota A'g edonna wuaror nana Niniwe letlawan dena?! Mai Niniwe di, de rimormiori e narehi lawan wal lia riwnu rahu ida terampworu mak kaplinu-kaplo' nohora hameni ed mak kalwieda me hameni mak kyata, ne nhiuri-wnia'ana liawanni er wal lia! Meman nek la A ralam ntiundoin la' hade, de lol talanni.” ");
INSERT INTO lex_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Puk di de e rhorat targa Yesus Kristus upni-tgarni kotni-nanni. Yesus de, Daud di'nani-lohorni duratni-waitni me Abraham kotnu-turnu gerni-wniaunu (duratni-waitni upni-a'nani). ");
INSERT INTO lex_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham na'a'na nana Isaka, Isaka na'a'na Yakopa, Yakop na'a'na nana Yehuda nora amni-hyalli, ");
INSERT INTO lex_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehuda nora Tamara ranina pede ra'a'n nana Peres me Serah. Peres na'a'na nana Hesron Hesron na'a'na Rama. ");
INSERT INTO lex_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram na'a'na nana Aminadaba, Aminadab na'a'n nana Nahasona, Nahason na'a'na Salmona, ");
INSERT INTO lex_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon nora Rahab rmehlima pede ra'a'na Boas, Boas nora Rut ra'a'n nana Obed. Obed na'a'na Isai, ");
INSERT INTO lex_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ne Isai na'a'n nana ray Daud. Daud na'ala Uria hawni pa nora rmehlim pa ra'a'na Salomo. ");
INSERT INTO lex_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo na'a'n nana Rehabeama, Rehabeam na'a'na Abia, Abia na'a'n nana Asa, ");
INSERT INTO lex_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa na'a'n nana Yosafata, Yosafat na'a'na Yorama, Yoram na'a'na Usia, ");
INSERT INTO lex_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia na'a'n nan Yotama, Yotam na'a'na Ahasa, Ahas na'a'n nan Hiskia, ");
INSERT INTO lex_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskia na'a'na Manasye, Manasye na'a'na Amona, Amon na'a'na Yosia, ");
INSERT INTO lex_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosia na'a'na Yekonya na'itra amni-hyalli demade rhopliala' Babel. ");
INSERT INTO lex_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","La'a lerni la rhoplia Israel mutnu rella Babel de: Yekonya na'a'n nana Sealtiela. Dewade Sealtiel na'a'n nan Serubabel, ");
INSERT INTO lex_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel na'a'na Abihud, Abihud na'a'n nan Elyakima, Elyakim na'a'na Asura, ");
INSERT INTO lex_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asur na'a'na Sedok, Sedok na'a'n nan Akima, Akim na'a'na Eliuda, ");
INSERT INTO lex_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud na'a'na Eliasara, Eliasar na'a'n nan Matana. Matan na'a'na Yakopa, ");
INSERT INTO lex_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakopa na'a'na Yusup. Noka Yusup nor Maria rmehlima. Maria ed mak kayor niana Yesus, maka ha rwet la de, Ray maka Uplerlawna Nano'taru pa Namori-nalewna rimormiori. ");
INSERT INTO lex_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pede la Abrahama pa nma ntut tiar lia Daud, de tuwu nernu-nha' nana re'eni termida wehrani wogata. La'pa nwatiawua Daud pa la nte'ela Israel mutnu maka ha rhopliala' Babel, de tuwu termida wehrani wogat wali. Ne la'a lerni la ha rhopliala mutu Israel la'a Babel pa nmai wia la'a ler maka ha rmoria Yesus maka Uplerlawna Nano'taru pa Namori-nalewna rimormiori die mana, tuwu termida wehrani wogat wali. ");
INSERT INTO lex_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Emkadille la'a maka ha rayoria Yesus Kristus. De la'pa inni Maria nora Yusup ra'an lira-remun waw pa hota rmehlim pa, mere edonna rawok ma'ta la yaninni pa emeka muanke' id nor hawni, dewade Maria na'apun wa onnila Uplerlawna Nhiwni ed mak kodi plolli. ");
INSERT INTO lex_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusup mak kora Maria kanyah'a de, de riy ida maka ralamni kaplele'era. La' hade pede la'pa Yusup nat niohora Maria na'apnu mere e a'nani atia' hade dewade Yusup niwra nahmen doinia niah'ani Maria mere niwa nhi'a mtiel nekpa totpena yana nhi' amola-ma'a Maria la'a riy rahu gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","La'pa Yusup ntepartar mua'ta la wniarora-wnialai la' hade, dewade nanina noma nmi' nana emkadi: Nmi' nande Orgahi-Orha'a hopopanni ida nma nakot la niwra: “Yusup ee, Daud duratni-waitni id o'a. Yana mumta'ata muora Maria mmiehlima. Yoma papay mak kden la Maria apannu de, de Uplerlawna Nhiwni mak kodi plolli pa Nhi' nan hade. ");
INSERT INTO lex_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hota Maria nayor niana a'n muanke'a ida. Ne hota o' ed mak kala papay die pa nwawa Yesus (nnia'eratni de Itmatromlawanni makamori-kalewna). Yoma hota E' ed mak kamori-kalewan nana E mutnu-rahanu la'a do'a-hala ralamni.” ");
INSERT INTO lex_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hare honona re rtutu-rte'ewa, totpena naplol la'a hya' ed maka Orgahi-Orha'a lirni ha nakota de pa makwohorulu-ktatrulu re rakot ulg oleka mai ita riwra: ");
INSERT INTO lex_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Hota pat hararara mak edon nor wut mua'ta muanke'a ranin wutu na'apun pa nayor niana a'na muanke'a ida de hota rala pa nwawa Imanuel maka la'a yawal Ibrani de nnia'eratni de: Uplerlawna Nor it talla.” ");
INSERT INTO lex_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","La'pa Yusup namat wa noma nlernohora hya' ed maka Orgahi-Orha'a hopopanni nakot la e'a. De hota nora Maria rmehlim pa. ");
INSERT INTO lex_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mere Yusup edon nor eti Maria pa ranin wut lia' lera Maria na'apun pa edonna nayor mia'ta. Ne la'pa Maria nayoria papay die dewade Yusup nweta la Yesus. ");
INSERT INTO lex_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria nmor tiarga Yesus la' leta Betlehem la'a Yudea nohananni-taniaratni la' lera ray Herodes nodi plolli pa nkukmu-nto'ma. La' ler de, de maka kwata'wa nohora wtiona lyanti lipni-laini rwatiawua tipur pa rmai lia Yerusalem. ");
INSERT INTO lex_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Rmai die ratiantian lola riwra: “Ee, keke'enku'a maka na'nama rmor niana totpena nla'a ray lia riy Yahudi re, etla hanmeni? Amamkek nan oleka wtionni la'a walli tipru pede ammai totpena amhu'ru-mhelam la gaini ralamni.” ");
INSERT INTO lex_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","La'pa ray Herodes natlin nana lir de dewade nhedum pa namta'at wenna, me riy honona mak kden la Yerusalem emkade wali. ");
INSERT INTO lex_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","La'pa Herodes npolg awok imam-imam re o'tani-matni honona nor wutga mak kwatutu agama deullu-tatarni pa natiana: “La hanmeni hota rmor tiarga Ray Makamori-Kalewna maka Uplerlawna Nano'targa deno?” ");
INSERT INTO lex_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Noma rwalolla riwra: “Ama, la'a Betlehem, let mak kden la Yudea nohananni-taniaratni de. Yoma la' Puka ralamni de makwohorulu-ktatrulu ida e nhorat targa de niwra: ");
INSERT INTO lex_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Betlehema mak kdena Yudea ne, o kuku'a-keke'u la'a leta-let no'a Yehuda ri, mere plollolli de mureh dioin ir la yoma hota o letmu de ed maka kalgot nana mak ktorna-krautu ida mak ktera-kdema A u'pu-a'nu Israel re.”” ");
INSERT INTO lex_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","La'pa nlernana lir maka ha rakot oleka re dewade Herodes nade'a ralma-riorni pa npolga mak kwata'wa nohora wtiona lipni-laini re pa nmeh'a natiana re pa nakot la niwra: “Moweni mimkek nan ulga wtion de?” Noka rwalol nohora ");
INSERT INTO lex_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","dewade Herodes nhopna mak kwata'wa nohora wtiona re rodi liarni la Betlehem pa rwahakhak papay die. Herodes nalahar pa niwra: “Mlia'a pa mpiahaka plu'unu-plehenu keke'enku' de mere mhioratreria la'pa mliernana keke'enku' de miwal pia ma mikot mai a'u totpena a' muana lia' pa ghu'ru-ghelam la'a lakni nayanni wali.” ");
INSERT INTO lex_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Noma mak kwata'wa nohora wtiona lipni-laini re rla'awa, de rahepuepur memna yoma ramkek nana wtion maka ha ramkek ulg oleka la tipur matni. Wtion de nala ulg ir pa la la'pa ntut tiarga reparni la'a keke'enku' de genni walli heyanna. ");
INSERT INTO lex_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Noma rhu'ru la likit de nayanni de ramkek nana keke'en de nora inni Maria. Noma rwaltiora-rwaltieman la keke'en de nayanni, na'nama rhar dioinia wareher genni pa rala maha, ayalli nora mur la'a keke'en de. ");
INSERT INTO lex_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ne hota la'a Uplerlawna Nano' targa ir la mi'ini ralamni totpena yana rawal lia' ray Herodes de, pede rwotar lol to'a talla dom pa rla'awa nohoni-raini. ");
INSERT INTO lex_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","La'pa mak kwata'wa wtiona re rla'awa dewade Orgahi-Orha'a hopopanni nma nami'a Yusup niwra: “Yusup ee! Mumata! Plet pa mua'ala keke'enku' de nor inni pa mpiatitin pa mlia'awa Mesir, yoma hota Herodes e nahak reri keke'en de pa nwenna. La'pa mdien nek la hande pa mpiei rer nieka pa a'ukot la tiy miy nampena miwali owa'ana.” ");
INSERT INTO lex_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Dewade Yusup namat doin la pa nodia keke'enku' de nor inni pa rwatitin la Mesir, la' mel de memna. ");
INSERT INTO lex_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ha rhol nieka la Mesir la'pa Herodes nmati. La' hade pede plola la hya' ed maka Orgahi-Orha'a Nakot oleka la makwohorulu-ktatrulu de lirni niwra: “Apuolga A A'nu de mak kdella Mesir pa nhargota.” ");
INSERT INTO lex_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","La'pa Herodes nat niohora mak kwata'wa wtiona mak kwatiawu tipru re ralahar olek e' wa dewade enawenan doin la. Noma nahak pa nwenna keke'enku' de pede enhopan pa rwunu-rwenan momuoga lokmera-papay muanke'a, maka ha rmor niana la ler de me la'pa rhol nian oleka noha wawannu anni wor tiututu. Yoma Herodes nlernohora ler meni maka mak kwata'wa wtiona re rakota la'a ler maka ha ramkek ulga wtiona. Rhi'a wniunu-wnienan lawan de la Betlehem (Rahel letni de) uhunu-ewatni nor wutga leta-leta mak rehgorgoru re wali. ");
INSERT INTO lex_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","La' hade hota plola la hya' maka makwohorulu-ktatrulu Yermia nakota niwra: ");
INSERT INTO lex_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“La'a leta Rama de hota tatlin nana yapolu-yatniani mak ko'a-kakru lol etnu liolli. Tatlin nana Rahel polpuolu-hawaun nohora upni-a'nani maka ha rwen oleka re. Riy riwra rhi' Rahel pa ralamni namtiern owa'ana, mere Rahel edonna nhe'du et miemna ir lirni.” ");
INSERT INTO lex_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","La'pa Herodes nmat wia de Yusup ed ma'ta la Mesir, noma Orgahi-Orha'a hopopanni nma nami'a Yusup owa'ana ");
INSERT INTO lex_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","niwra: “Yusup ee! Herodes nor rimormiorni mak kiwa kwenna keke'en de rmati oleka wa pa mumat doin pa mua'ala keke'enku' de nor inni pa miwal lia Israel wa.” ");
INSERT INTO lex_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Dewade Yusup namat doin la pa nora keke'en de nor inni pa rawal lia Israel wa. ");
INSERT INTO lex_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mere la'pa Yusup natlin nan de Arkelaus ed mak kwau dioinia amni Herodes pa nhi' ray lia' Yudea, noma Yusup namta'ata nla'a. La'pa nlernan owa'ana talan la Orgahi-Orha'a la' mi' ralma noma rla'awa Galilea yapatni. ");
INSERT INTO lex_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","La Galilea de rhol lia let mak kwawa Nasareta. La hade de hota plola la lir maka makwohorulu-ktatrulu re rakotkota la'a keke'en de, riwra: “Hota rwet E la riy mak kwatiawu Nasareta.” ");
INSERT INTO lex_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Noma la' nte'ela lerni pa Yohansi makharani riy nma nlola wo'orletna-kawurloini la' Yudea yapatni. Enhar lirni pa ");
INSERT INTO lex_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","niwra: “Ina-nara ama-hyali ee! Mhioitio'or doin-mtiahnei dioin do'omi-halmi re yoma hota edon nalo'on wali ne Uplerlawna Nwal lia Ray pa Nodi plolli la riy mormiorni!” ");
INSERT INTO lex_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Makwohorulu-ktatrulu Yesaya nakot nohora Uplerlawna lirni la'a Yohanis di niwra: “Hota riy ida e polpuolu-hawaunia la wo'orletna-kawurloini pa niwra: “Mpiahi' targa talla la Orgahi-Orha'a, mpiale'era loini-talanni!”” ");
INSERT INTO lex_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohansi naniayarni de ra' nana la onta wullu me rewni de ra' nana la ha ulti me ya'anni-yemannu de kongoha nora gani turnu. ");
INSERT INTO lex_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Riy rahu rwatiawua Yerusalem, Yudea nohoni-raini re honona, me la' walia gerlawna Yordan plahwani honona rriw niana pa rmai pia ratlin la Yohansi ha nakotkota. ");
INSERT INTO lex_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Noka ir rakota plele'er momuoga do'oni-halli re, ne Yohansi nharania re la' gerlawna Yordan. ");
INSERT INTO lex_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Riy Parisi mana liawanni ror wutga Saduki rmai lia Yohansi totpena rharania. Mere la'pa namkek tut niana rmai wia noma Yohansi nakot la re: “Hoi! Miy di de emolmolan nekama niy mak kodi nhienni yoma mhi' tukla-wahla. He' ed mak kiwra la'pa rharan nek miy demade hota Uplerlawna niukum lawanni mak kmai niek de hota edon nal miy?! ");
INSERT INTO lex_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mere mtiutga la nhioli-liet kalwiedwedmi totpena riy ratga de plol toto'a mhioitio'or doin-mtiahnei dioin oleka do'omi-halmi re wa. ");
INSERT INTO lex_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Yana mpiarora de hota miy edonna mliernan niukum lawna yoma upmi-tgarmi de Abraham. Yoma Uplerlawna nekane Nodi plolli pa Na'ala watu-watu ri pa Nhi'a la Abrahama duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mhioratreri ee! Uplerlawna e Nwahi' meman targa pa Nukmua he' to'a mak edon kolin doinia do'oni-halli. Yoma emeknekama Nwahi' targa wro'onni pa na Netan dodioinia ora-au onni pa la ntut lia ga'arni re honona. La'pa ora-au muaka edon kawo'a samomuounu de hota Nhoi wro'onni la pa Nnaklia la ai ralamni. ");
INSERT INTO lex_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","A' di Agala gera ga gharani miy, totpena ntutga de miy mhioitio'or doin-mtiahnei dioin oleka miy do'omi-halmi, mere mak hota kmai pia klernohor a' di, de hota Nala Uplerlawna Nhiwni tiy miy me emekwalima Nala ai na Nharani miy. E Nareh dioin a'u. Hota awue'er doin lakni wniowni ho'mana a'g edonna puar nana. ");
INSERT INTO lex_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ne hota emolmolan nekama E' ed maka ktorreria totopa maka ra ralipra-ratai metma-wetra' lawna (gandum). Metma-wetra' lawan de hota rawoka la'a dudnu (kliala) ralamni, mere hota kownu re honona de rwalia la ai miaka takeni rwarum nana.” ");
INSERT INTO lex_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","La' lerni de, Yesus Nwatiawua Galilea pa Nla'awa gerlawna Yordan pa Nma Nwak Yohansi pa nharani E'a. ");
INSERT INTO lex_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Mere Yohansi edonna nreiniana wakwakni de. Yohansi nakot la: “Ame, la'a plollolli de A'mu nanpena ed maka kharania a'u. Mere la' dodo'ondi de he' nakota de hota A'mu Nmai pia agharania?” ");
INSERT INTO lex_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mere Yesus Nakot la: “Hyalia, emkadella la' dodo'ondi to'a. Yoma la emkade de hota itsi' momuog oleka hya' mak kaplol la Orgahi-Orha'a yamkekni.” Dewade Yohansi nharania Yesus. ");
INSERT INTO lex_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","La'pa rharania la gera ralamni pa nhorwua noma Yesus Nrei lia gera aratni emkadi de, plin-plinnianama lyanti ema rhar dioinia, ne Yesus Namkek de Uplerlawna Nhiw Lululli Nerun de emolmolla ma'nu lmo'ma maru (merpati) pa Ntai lia E wawannu. ");
INSERT INTO lex_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nhor nioma ratlin de Uplerlawna Nhar lirni la'a lyanti Niwra: “A A'nu maka Asiayni inhatti. E' ed maka kla' nana A ralmu.” ");
INSERT INTO lex_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nhor nioma Uplerlawna Nhiwni Nodia Yesus pa Nla'awa wo'orletna-kawurloini totpena hegana amlawanni nta'aga. ");
INSERT INTO lex_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesus edonna Na'an nana lera terampwogata, mela terampwogata, pa Naplarlar memna. ");
INSERT INTO lex_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Noma hegana amlawanni maka rweta la mak kta'aga nmai pia nakot la: “Hoi! Uplerlawna A'nani O'a toh?! Mhuopan teka watgau ri rwal tiek la yamanna pa Omu'una.” ");
INSERT INTO lex_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Noma Yesus Nakot la: “Hota A'g edon liernohora o lirmu de, yoma la' Puka ralamni de nakot nohor oleka de: “Rimormiori edonna rmormior die yoma la'a yamanna nmeh'a mere rimormiori rlernana mormiori, yoma la'a Uplerlawna lirni-tunnu honona.”” ");
INSERT INTO lex_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nhorwua demade hegana nodia Yesus pa nla'awa la Yerusalem, na'nama nkenia Yesus la Uplerlawna roma kreini wuwannu pa Ntutrier lia hande, ");
INSERT INTO lex_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na'nama hegana nakot la Yesus Niwra: “Plola O' di de Uplerlawna A'nani O'a de Mniehgerun tek la! Yoma la'a Puka ralamni de e niwra: “Hota Uplerlawna Nhopna hopopanni pa rkim o'a totpena yana mtiuini ne watgau mana hota edonna rtai o'a.”” ");
INSERT INTO lex_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Noma Yesus Nakot la Niwra: “Mere la'a Puka ralamni wal miana e niwra: “Yan memmemna rimormiori rta'aga Orgahi-Orha'a mak kla' ir Uplerlawanni (yoma ir rhi' hihi'a-yapyapi mak kpodpodku-kpadpadku dewade rwak la Orgahi-Orha'a pa Namori-nalewn ira).”” ");
INSERT INTO lex_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nhor nioma hegana nodi owa'ana Yesus pa rla'awa wo'or tutul liawna id hananni, na'nama ntut momuoga hairi-hairi (noha-rai) honona ror wut nieka re'eni-tniarnu re honona. ");
INSERT INTO lex_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Noma hegana nakot la Yesus niwra: “Hota agala hari honon tiy O'a, mere Ompuayow pa Mriu'u-mtiowar plein la a la'ku nayanni.” ");
INSERT INTO lex_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Mere Yesus Nakot la: “Rho'orgo'tu la a ga'yu ralamni hega'nu ne! La' Puka de e rhorat targ oleka: “Riy honona rhu'ru-rhelam la Orgahi-Orha'a ir Uplerlawanni me ratlina-ratail tio'ola Ha Nakotkota.”” ");
INSERT INTO lex_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nhorwua noma hegana nhoitio'or la Yesus, ne Uplerlawna hopopanni re rma ramkek la E'a. ");
INSERT INTO lex_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Noma lera ida ne, Yesus Natlin nana rtorn oleka hyalli Yohansi pa rkenia la roma nhio'la ralamni pede Yesus Nwadur la Yudea yapatni pa Nwarei lia Galilea yapatni. ");
INSERT INTO lex_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","La' hande de Yesus Nlola leta Nasaret (de E geni ulullu) pa Nla' pa Ndella leta Kapernaum la'a danau Galilea aratni la'a Sebulon nora Naftali nohoni-raini. ");
INSERT INTO lex_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Maka Yesus Nhi' nana re honona de ntutga de Uplerlawna lirni maka makwohorulu-ktatrulu Yesaya e nhorat targa de naplola, yoma Uplerlawna lirni emkadille: ");
INSERT INTO lex_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulon nor Naftali nohananni-taniaratni mak kden la talan mak klola danau Galilea aratni, la'a gerlawna Yordan walli warta, de Galilea gen miaka Yahudi atia'a rdel wal lia. ");
INSERT INTO lex_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","De lupmu-a'namu mak kden la melli-kalamni, rler olek la lelerni. La'pa mak kden la leta-ruhuna maka do'oni-halli harahu mak kodia matmiati-molmuolu, de rat niohora oleka talla pa rlernana mormiori-lelewanni.” ");
INSERT INTO lex_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","La'pa nte'ela lera-mela re wa, dewade Yesus Nmeh'a ed mak Nakota Niwra: “Ina-nara ama-hyali, mhioitio'or doin-mtiahnei dioin do'omi-halmi, yoma ntutu-nte' olek pa hota Uplerlawna Nodi plolli la riy emeka ir Rayni.” La' ler de pa nodi liarni nhi'inde Nakot emkade la' rira. ");
INSERT INTO lex_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","La'pa lera ida ne Yesus Nalala' rer mia'ta la danau aratni la Galilea dewade Namkek nana riy woru, de Simon maka ha rpol walia la Petrus nor hyalli Andarias ratialtial reria i'na la'a danau de, yoma hare kniarni hade. ");
INSERT INTO lex_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Noma Yesus Nakot la re: “Ee, ma mliernohor A'g ee! Mai pia Awuatut miy totpena la' emkameni la miy mitial reri i'na la dodo'ondi, de hota emkade wal pia mihak rimormiori totpena hota rpesiay mai A'u.” ");
INSERT INTO lex_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Noma rleretniekla rteman taru tialli, ne rlernohora Yesus. ");
INSERT INTO lex_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesus Nodi liarni noma Namkek nana riy id nanni Yakowsi nor hyalli Yohansi ror wut nieka amni Sebedeus pa e rwalola tiala la puounu ralamni. Noma Yesus Npol walia re: “Mmiai ee!” ");
INSERT INTO lex_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Rleretniekla Yakowsi nor hyalli raltarga amni la puounu ralamni pa rlernohor walia Yesus lidanni de. ");
INSERT INTO lex_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Noma Yesus Nwaloha-nwalakat la Galilea liewnu uhunu-ewatni Nwatutu-nwaye'ela roma-lewu maka nhi'inde Yahudi re rhi' kreini-iskolli re. Enakot nohora Kot Kalwieda-Paitiot de Niwra hota Uplerlawna Nodi plolli pa emeka Ray. Ne E Nhi' wal pia rira nnienni-nhienni mehrani-maunu honona rkalwieda. ");
INSERT INTO lex_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Makden la Siria uhunu-ewatni ratlin nana Yesus hihi'ini-yapyapni, pa nhi'nande rira rhorat la pa rmai. Rma rodia riy mak klernana nnieni-nhiena, mehra-mau, no'a-rara, maka hegana nhu'r ralma, kapiphyaya'ala, riy mak inonni kmati. Rodi mak ksaki re honona pa Yesus Nhi'a pa rkalwieda momuou. ");
INSERT INTO lex_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Riy rahu rlernohor reria Yesus la' ler de. Dom de rwatiawu Galilea liewnu, dom de rwatiawua gen miaka ha rweta Leta Termida (Dekapolis), dom de rwatiawua letlawna Yerusalem. Dom de rwatiawua Yudea lowanni me dom mana e rwatiawu wal lia gen miaka kden la gerlawna Yordan walli. ");
INSERT INTO lex_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lera ida ne, la'pa Yesus Namkek nana riy rahu rma rawoka dewade Enha'at la wo'ora hananni pa Namtatna pa Niwa Nwatutu-nwaye'a. Mak nhi'inde ha Nwatutu-nwaye'a re rlernohora reria E'a pa rmai pia rwakriania. ");
INSERT INTO lex_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Noma Yesus Nna'ona wniatutnu-wniaye'eni la'a ir honona Niwra: ");
INSERT INTO lex_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ina-nara ama-hyali mitlina, hota unut lawna la riy maka edon kpar la lirni-yatnu wamueheni mere rawniair to'ola Orgahi-Orha'a yoma riy mak emkare rre' temn olek la Uplerlawna horatni-hairni limni-rorni maka Enodi plolli la emeka Ray. ");
INSERT INTO lex_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ina-nara, hota unut lawna wal lia' riy maka ralamni kmayo'a-kmata'u yoma hota Uplerlawna ed maka khi' ralamni re pa rahepru. ");
INSERT INTO lex_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Hota unut lawna wal lia'a riy maka khu'ru-khelma (rendah hati) la'a rimormior wialli yoma hota Uplerlawna ed mak kala hare honona maka Enakot targa la e'a. ");
INSERT INTO lex_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Hota unut lawna la riy maka ralamni nwahak nekpa nhi' mak kaplol la Uplerlawna yamkekni, yoma hota Uplerlawna ed mak kapenu-kalawna ir ralamni wakwakni de. ");
INSERT INTO lex_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hota unut lawna wal lia'a riy maka ktutga ralam kalwiedni la rimormior wialli yoma hota Uplerlawna mana Ntutga ralam kalwiedni wal lia ira. ");
INSERT INTO lex_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Hota unut lawna wal lia'a riy maka ralamni kaple'er reri, yoma hota riy de hota nor Uplerlawna la' geni ida. ");
INSERT INTO lex_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Hota unut lawna wal lia'a riy maka kpolliohora rimormior wiali la'a yahuri-yawo'ora totpa rkalwieda owa'ana, yoma hota riy de Uplerlawna ed mak khor wut wualia ir la E upni-a'nani. ");
INSERT INTO lex_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ina-nara, hota unut lawna la'a riy maka kler la kropanni-krieutnu yoma nhi' mak kaplol la Uplerlawna yamkekni, yoma hota riy de nanni ed walia Uplerlawna limni-rorni mutnu-rahanu, maka Enodi plolli la' emeka Ray. ");
INSERT INTO lex_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Unut lawna wal lia'a miy maka klernana nniahora-nniala'a yapolu-yaliella wniohora weyata-wniatra weyata yoma mliernohora Uplerlawna lirni-tunnu maka A'ukota tiy miy. ");
INSERT INTO lex_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Makwohorulu-ktatrulu la'a miy upmi-tgarmi lerni ho'mana rlernan oleka yamuki-yama'ala re, pede la'pa mimlier la yamuki-yama'ala yapupu-yaheri, de mimuki-mihepur meman nohora, yoma miy siepmi-kaimi inpona la'a Ilyamou-Watyatoha (Sorga) maka hota Orgahi-Orha'a Nala tiy miy.” ");
INSERT INTO lex_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ina-nara ama-hyali, miy di de emeka kio' nohkerna wawannu. Mere la'pa kio' de edonna nmahana, de ta'en niana ra'itr owa'ana ha mahanni toh?! Kio' de hota nwalia hamamuamua. Edon rnair nan owa'ana noka rhopliala, pa riy rwatei-rwahapra la' tani wawannu. ");
INSERT INTO lex_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ne miy di mana emolmolan nekama repreparni mak khita-krepra la noha wawannu pede riy ramkeka. Miy emekwalima let maka kden la wo'ora wawannu, de edonna nayade'a. ");
INSERT INTO lex_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","It edonna tatlin etia de riy rtutni wa'du nanpena rala ktopra ra rkadwua pitpitga. Mere nhi'inde rkenia wa'du della wniatatgenni totpena lelera la riy honona mak kden la roma nayanni. ");
INSERT INTO lex_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Emkade wal lia mormiormi de nrepar nana rimormior wialmi herni-gaini, totpena riy ramkek nana nhioli-liet kalwiedwedmi demade ra'uli-rawedia Amlawanmi la'a Ilyamou-Watyatoha.” ");
INSERT INTO lex_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Ina-nara ama-hyali, yana mpiarora de Amuai pia hota ghap dioinia Musa deullu-tatarni nor wut walia makwohorulu-ktatrulu re wniatutnu-wniaye'eni, mere Amuai die totpena deulu-tatra re rtutu-rte'ewa la'a hya' maka Aghi' nana-yap niana re. ");
INSERT INTO lex_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hya' maka A'ukota di naplol memna. La' hade pede mhioratreria me! Lyanti nora nohkeran di e nayamkek ma'ta, de hota mak ha rhorat targa la Puka ralamni, hurpu nora titikni id mana hota taken niana rhap dioinia la deulu-tatra, la'pa rwei niek la lera maka hare honona maka Uplerlawna ha Nakotkota rtutu-rte'ewa. ");
INSERT INTO lex_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","La' hade pede la'pa riy ida edon nlernohora deulu-tatra re kuku' id ho'mana me nwatutga riy dom pa yana rlernohora deulu-tatar de, de hota nwal lia riy mak edon rwetwet la nanni la'a Uplerlawna mutnu-rahanu re, maka Uplerlawna Nodi plolli la pa emek ir Rayni. Mere la'pa rwaldioinia de, la riy maka klernohora deulu-tatra re, me nwatutu-nwaye'a riy dom pa rhi' emekwalima e'a, de hota nwal lia riy maka ha rwetwet la nanni la' Uplerlawna mutnu-rahanu re honona. ");
INSERT INTO lex_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","La' hade pede mhioratreria! Makwatutu-kwaye'a deulu-tatra agama re ror wutga riy Parisi re rlernohor walia agama deullu-tatarni mere edon rhi' mak kaplol la Uplerlawna yamkekni. Mere riy mak kla' Uplerlawna mutnu-rahanu maka Uplerlawna Nodi plolli la pa emeka ir Rayni de rala ralamni tetema pa rhi' mak kaplol la Uplerlawna yamkekni.” ");
INSERT INTO lex_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Miy e miat niohor oleka wa la' it upni-tgarni lerni rlernan oleka deulu-tatar di, de yana mpiunu-mpienna yoma he'a e nwunu-nwenna de hota nler la niukamnu. ");
INSERT INTO lex_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mere dodo'ondi de A'ukot tiy miy, la'pa riy ida nawenan la rimormior wialli de hota nlernan wali niukamnu, me he' maka kwohora weyata-ktatar weyata riy niwra: “O' di de riy podku-padku!” de hota rodia la letgar lawawna la'a mak khudi-kpar la agama deullu-tatarni. Ne he' ed mak kwarenna riy pa niwra: “Mak kaplinu-kaplo'a o'a!” de hota rrinnia la ai mormiori ralamni. ");
INSERT INTO lex_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","La'pa it idma nor ida tawenna, de hade edon nla' nana Uplerlawna ralamni. La hade pede la'pa miy mana e miwra miala prehenmi-maumi dom la Uplerlawna la'a katri'ana wawannu, noma mhioratnana riy e rahankeran la miy ");
INSERT INTO lex_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","de yana miala pleinia prehenmi-maumi de mere mlia' pa miora pleinia riy de mkialwieda, nanpena miwal pia la'pa miala prehenmi-maumi de la Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","La'pa yanhi'pa riy doma e raklak miy, de miora riy de mpiak pa mkialwieda pleini la'a talan letgar memna totpena yana mlia' nek la letgar lawan de la'a makhudi-makpara gaini. Yoma la'pa edonan de hota riy de nal miy lia makhudi-makpara mak hota nal owa'an miy lia hgei mak kodi hapa'pani (polisi o'tani), noma hota hgei nho'la miy lia roma nhio'la ralamni. ");
INSERT INTO lex_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ne mhioratreria! Hota miy edon mliergot la roma nhio'la de ralamni, la'pa rwei pia mpiair dioinia papiairmi honona.” ");
INSERT INTO lex_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Miy e miat niohora oleka deulu-tatar di, de e niwra: Yana milira-miliai. ");
INSERT INTO lex_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mere dodo'ondi de A'ukot tiy miy, la'pa mimkek nan tututga patke' id pa na'hira-nadadia miy die, de miy die emekwalima miliai oleka patke' de wa, yoma mtieltel aparmi la'a patke' de. ");
INSERT INTO lex_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","La'pa matmi malganna nod miy lia do'a-hala de, de hota mkiopil doinia matmi della pa mhiopliala. Miolin doin neka matmi mak kodi miy lia do'a-hal de. Yanpa matmi de narieiniande miy inonmi honona rnaklia la ai mormiori ralamni (naraka). ");
INSERT INTO lex_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","La'pa limmi malganna ed maka khi' do'a-kyap hiala de mdieul dioinia pa mhiopliala. Miolin doinia la wa. Yanpa limmi wali de narieiniande inonmi tetema rnaklia la' ai mormiori ralamni.” ");
INSERT INTO lex_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Deulu-tatar dom maka mitlin oleka de emkadi wali, de la'pa riy id niwra nhopliala patke'eni, de hota nala horta yapie'era la hawni patke' de. ");
INSERT INTO lex_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mere dodo'ondi de A'ukot tiy miy ta'en niana muanke' id nhopliala patke'eni eneknek to'ama hawa patke' de nor muanke' dom de ralira-raliai. Mere la'pa hawa patke' de edon nalira-naliai mere emkade ho'mana muanke'eni de enhoplial nek e' wa, hawa muanke' hihi'ini de nareiniande hawni patke' de pa nalira-naliai. Yoma la'pa hawni patke' de nmehlim owa'an de, hade de yalira-yaliai la Uplerlawna yamkekni. Ne muanke' mak kmehlimpa kora patke' maka kpaletan nohora muanke'eni, de nhi' wali yalira-yaliai lia Uplerlawna yamkekni!” ");
INSERT INTO lex_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ina-nara ama-hyali, mimiat niohor wal lia' it upni-tgarni lerni de rlernan oleka deulu-tatar di, de hya' ed maka mikot targ oleka la Orgahi-Orha'a, la'pa mliokar nohora oleka wa, de mliernohora honona. Yana mpiera-mdiaiti hare. ");
INSERT INTO lex_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mere la'pa dodo'ondi mana A'ukot nohor la miy, de yan memmemna mliokra onde mpialokra pa ma miplol nohora lirmi-tunmi. Yana mliokra pa mpiet la lyanit lawna, yoma lyanit de Uplerlawna yaliwangenni (tahkta) inhatte! ");
INSERT INTO lex_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","La walia yana mpiet la nohkerna pa mliokra onde mpialokra, yoma nohkeran di de Uplerlawna E Nhapar reria nohkeran di. Onde mliokar de mpiet walia Yerusalem, yoma Yerusalem de mana, Uplerlawna mak kla' Ray Lialawna de genni-tienni. ");
INSERT INTO lex_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yana mliokra onde mpialokra de mniairia o'ta-wat wuamuehemi yoma morat lihirmi id ho'mana miy mieh'a nek de taken niana mhierun doinia pa nwawahra onde nmetmetma yoma it moratnu metmetma onde wawahra hota emkade pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mere mpiet nek la: “Yowa aghi'a hade,” onde “A'g edonna ghi' hade,” totpena yana milahara rimormior wialmi. Mere la'pa miala hya'-hya' pa ma mpiayow nammi de hade de hegana amlawanni karkiarni hare.” ");
INSERT INTO lex_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Miatg olek walia deulu-tatar di niwra: Mata nherun mata, niha mana nherun niha. ");
INSERT INTO lex_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mere A'ukota la miy, yana mpiahla hankerna-ralmha'ara maka riy rhi'a tiy miy. La'pa riy rpahara kilmi malganna, de miala kilmi walli malwiru pa rpahar walia. ");
INSERT INTO lex_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ne la'pa riy rod miy lia letgar lawawna totpena rwarui-rwate'la naniair no' inonmi, de hota miy rain plalahwa samomuoumi de mial walia naniayarmi mak yatyat no' inonmi mak ha nwahaka de. ");
INSERT INTO lex_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","La'pa riy dom nmai pia namer matni pa nhopna mikwara e hyonni-hyanni pa mila' nana kilu id olietni, de mitahan rer lia pa mila' nana kilu woru. ");
INSERT INTO lex_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","La'pa riy rwak hadom tiy miy, de yan mitawra. Ne yana mpiayotlia rira mak kwak pa riwra ra'otna-ra'ar la tiy miy.” ");
INSERT INTO lex_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Miy e miat walia deulu-tatar di, de e niwra: Mhi' kalwiedweda rimormior wialmi ne mpiahla riy yatyata hihi'ini tiy miy. ");
INSERT INTO lex_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mere A'ukot hadi tiy miy lia' dodo'ondi de, mihaka mak khi' yatyat tiy miy pa mhi' samomuou rer lia. Msiumbainia riy maka kamuki-kama'ala miy. ");
INSERT INTO lex_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Totpena mtiutga la ilu-wniehwami de, Uplerlawna mak kden la Ilyamou-Watyatoha upni-a'nani miy. Yoma Uplerlawna Nwer rer miatni la riy maka kyata-khala ror wutga riy maka kwehwa ploi-ple'era. E' ed maka khuriernia otna me nhi' lera pa nhit la'a riy mak kaplola ror wal lia riy mak khala. ");
INSERT INTO lex_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yoma la'pa miy mtiulla-msiayni to'a riy maka nhi'inde khi' kalwiedwed tiy miy de hota Uplerlawna edon Na'uli miy pa Nala hihi'imi de wniahlani. Yoma miy miatg olek de, riy yatyata emeka mak kawoka blastena, nek de e rtulla-rsayni walia mak khi' samomuou ira toh! ");
INSERT INTO lex_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne la'pa miy makpesiay mtiutga nhiu'ru-nhielammi la miy mutwualmi to'a, de hihi'imi re edon nareh dioin riy mak kaplin niohora ma'ta Uplerlawna yoma rimormior mak kaplin niohor Uplerlawna nek de rhi' wali emkare. ");
INSERT INTO lex_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","La' hade pede mliernohora miy Amlawanmi la Ilyamou-Watyatoha yehwani mak kara'a-kapalga riy honona edonna nkei-nhelta rira gaini, yoma wniehwa-liakat de plol toto'a la Uplerlawna yamkekni.” ");
INSERT INTO lex_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ina-nara ama-hyali, mhioratreria, yana mtiutga hihi'imi-yapyapmi mak kalwiedweda re la'a riy gaini ralamni. La'pa mimhi' emkade de hota miy edonna mliernana liwatmi-odapmi wniahlani la'a Uplerlawna miy Amlawanmi makdella Ilyamou-Watyatoha. ");
INSERT INTO lex_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pede la'pa miy miala hadom la riy mak kakleha-kaplara, de yana mpio'on nohora emekneka riy yatyata rhi' nana yoma riwra rtot inonni la riy kalwiedweda. Yana mliernohora riy maka rhi' harella gen miaka Yahudi re rhi' kreini-iskolli la me la' walia la'a loi liawna-talan lawna totpena riy ra'ulia re. Mitlina, mak emkare de ha rlernan oleka siewni la'a riy ya'ulli-yawedni. Mere ya'ulli-yawedni olek hadewa. Hota Uplerlawna edon Na'uli-nawed ira. ");
INSERT INTO lex_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mere la'pa miy miala hadom la riy mak kakleha-kaplara de, yana mkiokan nohora totpena miy mutwualmi ho'mana yana ratga. ");
INSERT INTO lex_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mhierer nohora neka hya' maka ha mhi'a re totpena yana riy ratga. Mak kat niohora de enekneka Amlawanmi no' Heyanan to'a. Enamkek oleka hya' maka ha mhierer nohora pa mhi'a re pede hota E' ed mak kala siepmi-kaimi.” ");
INSERT INTO lex_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“La'pa msiumbaini de yana mliernohor riy mak ktutga yehwa mak kaplola mere la' ralamni de yatyatni-halalli ed ma'ta la (munafik). Ir suksukni de rsumbain de raprir lia riy gaini ralamni la'a krei me la' wal lia loi-talla aratni totpena plet pa riy ratg ira. Mhioratreria! Riy mak emkade rlernan oleka siewni-kaini la'a riy ya'ulli-yawedni. Mere ya'ulli-yawedni olek hade wa. Hota Uplerlawna edon Na'uli-nawedi ira. ");
INSERT INTO lex_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mere la' miy die, la'pa mimsiumbaini de, mhio'la rommi nhiarni nanpena mpiol lia Amlawanmi maka edon kayamkeka. Pede hota Amlawanmi Namkek reria miy hihi'imi-yapyapmi mak edonna kayamkek la rimormior wialmi re, ne E' ed mak kala miy kaimi. ");
INSERT INTO lex_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","La'pa mimsiumbain de yana miti'ila-miwal hya' maka mikota re pa plo'a-plahwa rehia, emeknekama riy mak kaplin niohora ma'ta Uplerlawna. Ha ratniekame ir wakwakni re hota nayatlin nan olekwa yoma ira sniumbaini re plahwa. ");
INSERT INTO lex_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Yana mliernohora re. Yoma miy edonna mpiak ma'ta hade wa de, Amlawanmi no' Heyanna Nat niohor olek hya' maka mikleh ma'ta. ");
INSERT INTO lex_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pede msiumbain de emkadilla: A Am mamni la Ilyamou-Watyatoha. O' de Mueh'a Mupriri-mukded la genmu-tienmu. Ampak de nhiu'ru-nhielma ya'unni-yamta'ata nmai reri O' dee! ");
INSERT INTO lex_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ampei-mnar reria lodanmu-hairmu. Ampaka pa O ralma-riormu de, mak kden la noha wawannu rlernohor reria pa emekwalima maka ha rhi'a la Ilyamou-Watyatoha. ");
INSERT INTO lex_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mhi' apehera a apun mamni la' yamanan mak Omual pa ama'an la' ler di. ");
INSERT INTO lex_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mumou-muwitna a do'a-hal mamni emekwalima am miana mhoratdoinia riy do'oni-halli mai ami. ");
INSERT INTO lex_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Yana Muolin doin limmu-mpue'er rormu mai ami, yanpa la'pa hegana-kawnu rta'ag am die, hota amler la do'a-hala ralamni. Mere Muwohor doinia hegana rurni-karatni mai ami. O' ed mak ktoran reria lodna-hairi me Mumrehi-mumda'ar nohora hititmu-repreparmu pa nodi liarni. Amin (Plola). ");
INSERT INTO lex_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","La'pa mhioratdoinia rira yatyatni-halalli do'oni-halli maka ha rhi' nan tiy miy die hota miy Amlawanmi no'a Ilyamou-Watyatoha ho'mana Namou-nawitna do'a-hala maka ha mhi' nan oleka re. ");
INSERT INTO lex_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mere la'pa miy edon mhioratdoinia rira do'oni-halli maka ha rhi' nan tiy miy die, de hota miy Amlawanmi mak kden la Ilyamou-Watyatoha mana edonna Namou-nawitna do'omi-halmi.” ");
INSERT INTO lex_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“La'pa mitahan lara, de yana mtiot pa mhi' malului gaimi pa riy ratga emeknekama riy mak kiwra ktutga yehwa mak kaplola mere la ralamni de yatyatni-halalli ed ma'ta la (munafik). Yana mliernohora ira yoma ir er maka khi' herni-gaini re totpena rtutga de ir ratahan lara. Mhioratreria, rimormiori ya'ulli-yawedni to'a ed maka khi' hare siewni-kaini. ");
INSERT INTO lex_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mere la'pa mitahan lara, de mirarga gaimi pa nmomuou, ne mhiola-mkia'ata moratmi, ");
INSERT INTO lex_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","totpena riy raplinga de miy e mitahan lara. Eneknek to'ama Amlawanmi no' Heyanna mak edonna kayamkek de nanpena Enat niohora miy e mitahan lara. E' ed maka kamkek reria hihi'imi-yapyapmi mak kayade'a pede hota Nal miy siepmi-kaimi.” ");
INSERT INTO lex_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Yana miakokan nohora re'a-tniaru mak kden la nohkeran di wawannu yoma hota erieri nora karte'a ra'ana re, ne hota mak kamna'a rma rwuri-rgalam nana re. ");
INSERT INTO lex_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","La samomuounu de miwoka-mile'ega re'a-tniaru mak kdella Ilyamou-Watyatoha yoma erieri nora karte'a hota edonna ra'ana re. Me mak kamna'a re ho'mana edonna rmai pia rkamna' nana re. ");
INSERT INTO lex_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Miwoka re'a-tniaru la'a Ilyamou-Watyatoha yoma hota la meni pa miy re'emi-tniarmi erla de hota miy ralammi et wal lia hande.” ");
INSERT INTO lex_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“It matni nhi' wa'du mormiori la it inonni. La'pa matmi yamkekni lelera, de inonmi tetema mana hitita-reprepra. ");
INSERT INTO lex_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mere la'pa matmi npon wa, de inonmi tetema mana melmela-kalkalma. Ne la'pa wa'du mak kden la inonmi ralamni de melmela de hota mel'uta-malien memna.” ");
INSERT INTO lex_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ina-nara ama-hyali, riy ida ta'en niana natlin la matroma riy woru. Yoma hota natlin samomuou lia ida ne la handina de edonna natlin kalwiedwed la. Emkade wal lia miy. Hota ta'en niana mimpiaror to'a re'a-tniar nohkerna gahani me mial wal'sia ihrami tetema pa mhima-mrie'a Uplerlawna kniarni. ");
INSERT INTO lex_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","La' hade pede mhioratreria, yana mimta'at nohora hya' maka hota ha mi'ina-miemnia onde la'a hya' ed maka ha mhiewta-mniairia. Miplinga de mormior die narehia ya'ana-yemnu, ne inonmi de nareh niana hewewta-naniairi?! ");
INSERT INTO lex_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mimkek tek la onu-ma'nu nemnema re. Ir edonna rawuli-ratniamni, me ir edonna rreiki-rwo'ora, me ira edonna rdudnu rieiki-wnio'orni re. La'pa emkade ho'mana Amlawanmi mak kden la Ilyamou-Watyatoha Ntera-ndem wali ira. Miplinga de Uplerlawna Nsaynia miy die nareh dioinia onu-ma'nu rena?! ");
INSERT INTO lex_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Rimormiori maka ralamni worwuorga onde namta'ata matmiatni ho'mana takeni nhaur nan aranni oke' nmeh'a totpena edonan nmati. ");
INSERT INTO lex_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Hya'a nariei pia ralammi worworga la hewewta-naniayarmi? Mimkek la kihir mak kadeutu mak kmor lia rai mtatanni re. Kihir mak kadeutu re edonna rkari me edonna ratenni-ramairi. ");
INSERT INTO lex_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mere mhioratreria, ray Salomo mak kre'a-ktar die nek de edonna nhewta-nnairia naniairi samomuounu pa emeknekama kihir mak kadeutu re. ");
INSERT INTO lex_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wewna mak kden la rai mtatanni re rmor lia ler di mere repar dewade rrinnia la ai ralamni. Wewan nek de Uplerlawna Nahowna-nakgara pede samoga la yamkekni. Mere miy die edon mpiesiaya de wewna nekane Uplerlawna Ntera-ndema ne, yaho'ma miy?! ");
INSERT INTO lex_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ina-nara ama-hyali, Uplerlawna hota Ntera-ndem miy pede yan mimta'at nande miwra: “Adoh hota ama'ana hya'a, me amemnu hya' ee? Onde hota amhewta-mnairia hya'a?” ");
INSERT INTO lex_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","33","Riy maka kaplin mua'ta Uplerlawna nekane er mak kahakhak nohora hare honona. Mere miy die Amlawanmi no'a Ilyamou-Watyatoha Nat niohora oleka miy e mpiaka (perlu) hare honona. La' hade pede mihak ulga totpena Uplerlawna Nodi plolli la'a mormiormi-dardiarmi, me totpena mhi' hya' mak kaplol la E yamkekni, ne hota hya' maka mikleha de hota Enal momuoga tiy miy. ");
INSERT INTO lex_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Hade pede yana ihrami ntepul nohora repar lerni yoma repar lerni de nodi wniaror warwuaru dom owa'an to'a. Ler di nodi oleka mehra-maunu pa twaror nohora.” ");
INSERT INTO lex_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ina-nara ama-hyali, yana plet pa mpiaghala rimormior wialmi totpena Uplerlawna mana edonna Nhudi-npar (Nukmua) wali miy. ");
INSERT INTO lex_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Yoma la' emkameni la miwerta-mitailia riy doma demade Uplerlawna Nawerta-nataili miy emkade wali. Ne nhio'ota-liewta maka itnairia pa ta talewta it rimormior wialli demade Uplerlawna Nal hade pa na Nlewat wali ita. ");
INSERT INTO lex_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hya' mak karei pia mpiaghala rimormior wialmi onnila do'oni-halli mak edon kwerta, mere miy do'omi-halmi re nekane lawan rehia. La'pa mhi' emkade, de emekwalima miy e mimkek nana ai liu'wu mak kdella mutwualmi de matni ralamni, ne ai dieulu naniewat la miy mat wamueheni ralamni mere miy edonna mimkek nana. ");
INSERT INTO lex_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ralma-riormi emkameni pa mikot la mutwualmi miwra: “Mai pia agal doinia ai liu'wu mak kden la o matmu de,” mere miplin niek la ai dieulu de e naniewat la orgahami matmi ralamni?! ");
INSERT INTO lex_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hoi! Yana mtiota miy inonmi la riy kalwiedweda mere plollolli de riy yatyat miy. Milgot ulga ai dieulu mak kden la miy matmi de totpena mimkek samomuoga ai liu'wu mak kden la mutwualmi de matni pa milgota.” ");
INSERT INTO lex_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Yana miala hya' ed maka Uplerlawna gahani la'a riy mak kahmen memna kreiniana. Yoma itsi' emkade, de emolmolan nekama itala yamanna la ahu na'ana de hota ah die nwaldioinia pa ntowr ita. Ne emolmolan nek wali me tnaklia mutiara la wawi gaini noka hota nwatei-nwahapra mutiara de.” ");
INSERT INTO lex_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ina-nara ama-hyali, la'pa mpiak la Uplerlawna, hota mliernana, mpiahaka, de hota mia' nana, mtiet la nhiari hota rhari nhiari tiy miy. La' hade pede mipe'el pa mpiak rer lia Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Yoma riy mak kwaka de hota nlernana, mak kwahaka hota na' nana me riy maka ktet la nhiari de hota rhari nhiari la. ");
INSERT INTO lex_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","La' miy hononmi re, de la'pa ama-hyali id a'nani nwak yamanna la amni, dewade amni nal watu lia e'a?! ");
INSERT INTO lex_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Onde la'pa nwak i'na dewade amni nal niy lia e'a?! ");
INSERT INTO lex_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","La'pa rimormiori miy maka khi'inde khi' do'a-kyap hiala nekane miatu miala ha samomuounu la miy a'nami re, yaho'ma miy Amlawanmi mak kden la Ilyamou-Watyatoha. Hota E' ed mak kalkal reria ha samomuou lia'a riy mak kwak la E'a.” ");
INSERT INTO lex_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“La'a hya'-hya'a honona de mhi' samomuou rira de emekwalima mimiwra irhi' samomuou tiy miy. Hade de Musa deullu-tatarni me makwohorulu-ktatrulu ha rwatutu-rwaye'a ononni.” ");
INSERT INTO lex_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ina-nara ama-hyali, la mormiormi ralamni de mliola nhiar miaka kakmamah'a pa mlia'awa la mormiori-dardiari genni. Yana mliola talan mak kawerna-katpoini, yoma nhiar die ed maka tlol pa tla'awa ai mormiori ralamni (naraka). Ne riy rwakdie'da lola. ");
INSERT INTO lex_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mere talan lihir maka itlola pa itla'awa mormiori-dardiari genni de nhiarni nakmamah'a rehia pa nhi'nande riy doma rmeh'a mak kla' nana.” ");
INSERT INTO lex_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ina-nara ama-hyali, mi'ererma la riy mak ktot pa khi' inonni la emolmolla mak kakot nohora Uplerlawna lirni-tunnu. Hota rmai miy die rwehwa-rlakta emeka duma, mere erammi, ohpora-ahdiawra irhatta. ");
INSERT INTO lex_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hota la'a wniehwani-liakatni nekane miy e miat niohora ira kniarni plolli-halli. Itala au nor wo'oni pa tsi'a la yawalliohora. Ruwnu-penta de edon nawo'a lokrahi wio'a, ne ruwnu-ahla rurni-karkiaratni, de edonna tlernana kar wo'a. ");
INSERT INTO lex_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","La'a au muaka kpoti-kadwu de tlernana orwo'a-auwo' samomuou, ne la'a ora-au muaka khoptutu-khoplera de itlernana wo' maka kilta-kwatra. ");
INSERT INTO lex_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Au muaka kpoti-kadwu, de edonna nawo'a kilkilta-kwatwatra ne au muaka khoptutu-khoplera edonna na'unu-nayeh nohora wo' samomuou. ");
INSERT INTO lex_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ne orona-augona maka edonna ka'unu-kayeha, de hota retan doinia pa rnaklia la ai ralamni. ");
INSERT INTO lex_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ora-au re emekwalima mak ktot pa khi' inonni de emeknekama mak kakot nohor Uplerlawna lirni-tunnu. Hota la' ira wniehwani nekane miy e miat niohora ir kniarni plolli-halli.” ");
INSERT INTO lex_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Riy harahu makpolu-makwak la A na'nu riwra: “Matromlawna, Orgahi-Orha'u ne!” Mere hota riy doma rmeh'a to'a mak rre' teman la Uplerlawna mutnu-rahanu maka Enodi plolli la emeka ir Rayni. Uplerlawna mutnu-rahanu re eneknek to'ama riy meni maka klernohora A A'mu mak kden la Ilyamou-Watyatoha ralma-riorni. ");
INSERT INTO lex_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ne la'pa nte'ela A maimia'yu la re'eni wornu pa Aghudi-puar rimormiori de hota rira liawanni maka edonna katlina-katailla Uplerlawna rakot mai A'u riwra: “Matroma, O edonna Mutlin ma'ta amodia O nanmu pa ma makot nohora Uplerlawna nnio'oni-niatnu? Ne la' walia ami e mpet walia Orgahi-Orha'a nanni pa ma mhokar doinia hegana-kawnu, me totpena amtutga hihi'a-yapyapi mak kamehi-kayona (mujizat).” ");
INSERT INTO lex_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mere hota Awualola plele'er la giwra: “A'g e uplin niohora miy ee! Rho'orgot miy la handi! Miy er maka khi'a yatyatni-halalli!” ");
INSERT INTO lex_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Pede la'pa riy ratlin nana A li'ru ri pa hota rlernohora, de ir emekwalima riy mak katu kwatatga romni rirni la watu wawannu. ");
INSERT INTO lex_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","La'pa otna nturu-anni nten pia nmai die nodia ihini-turnu pa nwayotil la rom de, mere rom de hota edonna nwalera yoma nawniatat lia watu wawannu. ");
INSERT INTO lex_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ne la'pa he' ed maka katlina A li'ru maka ukota ri, mere edonna nlernohora de emeknekama riy mak kpodku-kpadku maka kariria nek romni la eni wawannu. ");
INSERT INTO lex_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","La'pa nmai wia otna lerni de hota nodia anin lawna nor wut nieka ihini-turnu pa la'pa nwayotil la rom de, de hota rom de napru'wu la yawa, me rirni-awnu kdieulu-kliatna.” ");
INSERT INTO lex_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nhorwua noma Yesus Nwati kniarni la wniatutnu-wniaye'eni re, ne rirahu mak kden la hande, rwer rer wiawni la'a wniatutnu-wniaye'eni re, ");
INSERT INTO lex_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","yoma Nodi plolli pa Nwatutu. Pede wniatutnu de ematia'a makwatutu-kwaye'a agama Yahudi wniatutnu. ");
INSERT INTO lex_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","La'pa Yesus Nerun la wo'ora hananni, ne riy rahu rlernohora reria. ");
INSERT INTO lex_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","La' ler de nekpa riy mak kanieni ulityata-temyata nmai noma nwaltior tar lia Yesus gaini ralamni na'nama nwak la niwra: “Amee! Mtiulan mai a'u. Agat niohora de Omuodi plolli pa Mhi' kalwied nan a'u, hornama Ompuayow nohora a wakwa'ku, up matro'mu nee!” ");
INSERT INTO lex_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Noma Yesus Nran limni pa Nteman la riy de, pa Nakot la: “Arieiniana o wakwakmu pa omkialwied wa!” Mtatande nekpa nnienni de nmolu. ");
INSERT INTO lex_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Noma Yesus Nakot la: “Mhuoratreria! Yana mukot harilla' riy dom owa'ana. Mere mliernohora hya' maka Musa ha ne'era-ntatar targ oleka, de mlia'a imam ida pa mpuak la totpena namkek memna de omkialwied olekwa. Me muala limtutnu emeka Musa nwatut tiarg oleka de totpa riy honona rat niohora de omkialwied olek wa.” ");
INSERT INTO lex_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","La' noma Yesus Nler la Kapernaum, noma o'ta-mat la makodi keki-rautu rahu ida nma nwatroma, pa nwaka tniulan la pa nhi' kalwied nana e hopopanni mak kamehra la roma nayanni. ");
INSERT INTO lex_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Perwira Roma nakot la Yesus Niwra: “Ame! A hopopnu id la roma nayanni e naliu'ut nohora mehrani la'a genni.” ");
INSERT INTO lex_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesus Nakot la Niwra: “Hyalia, pen Atiy pia ghi' kalwieda ha nnienni della rommu nayanni.” ");
INSERT INTO lex_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","“Yan nek wa Tuna! Perwira id a'u mere a'g edon lia' nana Tuna lewatni pa Tuna Nmai lia a ro'mu nayanni. Pen neka Tuna Nden nek la handi mere Nodi plolli pa Nhopna a hopopnu de nkalwieda la roma nayanni. ");
INSERT INTO lex_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yoma a' niek de utlin la mak kodi plolli mai a'u. Ne la'a a tniornu de ratlin mai a'u. Aghopan pa makodi keki-rautu ida nla'awa de hota nler pa nla'awa. Apuolga dom de, hota rmai. Ne la' walia aghopan pa a hopopnu de nhi' hya' to'a, de hota nlernohora.” ");
INSERT INTO lex_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","La'pa Yesus Natlin nana ha lirni de, noma Yesus Nwer rer wiawni yoma makodi keki-rautu o'tani de pesiayni de. Noma Yesus Nakot la mutlialawna maka e rlernohor E'a Niwra: “Ina-nara ama-hyali, riy di de riy Israel atia'a id walia di me! Mpiesiaya! La'a riy Israel maka Awuatrom nan oleka re de A'g edonna liernan ma'ta maka pesiayni naruri emeka riy mak Israel atia' di! ");
INSERT INTO lex_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Plola rirahu mak edon rwatiawu Israel mere rwatiawu tipru, warta pa rmai die, hota rora Abraham, Isak me Yakop rewre'wa pa ramuki-rahepru la'a ya'anlawna-yemunlawna la gen miaka Uplerlawna Ntorna-nraut de! ");
INSERT INTO lex_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mere makden Israel re, maka Uplerlawna Ntutga la ululu pa hota rre' teman la Uplerlawna horatni-hairni limni-rorni, de harahu re hota ema rwaldioinia pa rnaklia la melmelli-kalkalamni, la'a Uplerlawna genni de walli tio'ora. Hota la' hande de rpolpuol inni-rwakwak amni.” ");
INSERT INTO lex_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mere Yesus Nakot la perwir de: “Mlia'a nek wa! Hya' ed maka ompuesiay die pen mumkek memna.” La'a mtatan de nekpa perwir de hopopanni nkalwied wa. ");
INSERT INTO lex_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Noma Yesus Nokria Petrus likatni. La' hande de Yesus Namkek de Petrus yananni ruru npahna nohora tema pniahnani la'a lewu wawannu. ");
INSERT INTO lex_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Noma Yesus Nteman la patke' de limni, dewade nnienni de nmolu. Noma namat pa nwahi'a-nwayodia ya'ana-yemnu pa Yesus Na'ana. ");
INSERT INTO lex_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","La'pa lera ntuinia, dewade riy rmai die rodia rirahu maka hegana nhu'ru ralma. Noma Yesus Nhopan pa hegana-kawnu re rlergot la re, me Nhi'a riy honona pa rkalwied la nnienni-nhienni. ");
INSERT INTO lex_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hya' maka Yesus Nhi' nana re honona de ntutga de makwohorulu-ktatrulu Yesaya lirni naplola. Yoma Yesaya nhorat targa Uplerlawna lirni emkadille: “E' ed mak kolin doin ita mehrani-maunu. Ne Nal it pa tkalwieda.” ");
INSERT INTO lex_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","La lera ida ne rirahu rle'lu nana Yesus pede Yesus Nhopan pa maka ha Nwatutu-nwaye'a re rwahi' pa rleretia danau. ");
INSERT INTO lex_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Yesus edon la' ma'ta, dewade makwatutu-kwaye'a Musa deullu-tatarni ida nmai pia nakot la niwra: “Am tungkurge, a'g e giwra liernohor rer nek O' Ama pa tlol meni-meni.” ");
INSERT INTO lex_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Noma Yesus Nakot la Niwra: “Hyalia, Ohpora-ahdiawra hu'ulli-lienni erla, me onu-ma'nu nekane puonni erla, mere Rimormiori A'na A'u, A' die hota A'g edon liernan gen pia A'udera A o'tu. Ne hota omliernohor A' die hota o e mukleh wali geni.” ");
INSERT INTO lex_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Noma mak klernohor reria E'a id nakot wal lia: “Tuna, Muolin doin a' pua ula' ulia la'pa arie'ela tiamnia a'mu nampena aliernohor reri O'a.” ");
INSERT INTO lex_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mere Yesus Nakot la: “Hyalia, dodo'ondi de mliernohor reri A'u niek wa ne muolin doinia riy mak edon kpesiay A'u pede emekneka rmati olekwa pa orgahani rtamnia mak kmati re.” ");
INSERT INTO lex_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","La'pa Yesus Nha'at la puou, noma maka ha Nwatutu-nwaye'a re ror wali noma rhopal wa. ");
INSERT INTO lex_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Noma plinu-plinnianamde anin lawna mak kodia kakmoranni nten pia nhi'nande nayo'ora la' danau pa yo'or mana rriw lia puou ralamni. Emkade ho'mana Yesus e nanin hala la puou ralamni. ");
INSERT INTO lex_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dewade maka ha Nwatutu-nwaye'a re rla' pa ramat doin Yesus riwra: “Tuna, Mtiulan mai ita, hota puou di ntepar wa! Hota itmat wie!” ");
INSERT INTO lex_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesus Niwra: “Nihya'pa mimta'at wenanmi emkadena?! Miy edonna mpiesiay A'u.” Dewade Yesus Namat pa Nkamot targa yo'ora-anin lawan de na'nama nleretniekla nalina-nalera la'a danau de ralamni. ");
INSERT INTO lex_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dewade maka Yesus ha Nwatutu-nwaye'a re honona rwer rer wiawni pa riwra: “Riy meni hadina de pa yo'ora-anni nek de ratlina-ratailla?” ");
INSERT INTO lex_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","La'pa Yesus Nte'ela danau walli, la'a Gadara yapatni, noma riy woru maka yatni-rha'ani rhu'ru ralma rmai pia rwatroma Yesus. Riy maroro'a re rawuwuhura, nhi'nande riy ramta'ata rlol hare onni. Rrora rlergot la hu'ula-liena la'a tniamin mat geni ralamni pa ");
INSERT INTO lex_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","rpolpuolu-rhawaunia pa riwra: “Oi, Uplerlawna A'nani nee! Hota Omhi' nan ami emkameni ee! Yanhi'pa Omiwra Mukmua ami, mere lerni edonna ntutu-nte' ma'ta pa Uplerlawna Nhudi-npar ami.” ");
INSERT INTO lex_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Gen di edon oliet la wawi wiok lawna mak kwayowar pa kahaka ya'ana-yemannu. ");
INSERT INTO lex_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Noma yatni-rha'ani re rwak lilili-mamuau lia Yesus pa riwra: “La'pa Omulgot am die, ampak pa Mhuopan pa am mhu'ru ralam la'a wawi re.” ");
INSERT INTO lex_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Noma Yesus Niwra: “Mlia'awa!” Dewade yatni-rha'ani re rlergot la'a riy maroro'a re inonni, pa rla' rhu'ru ralma wawi re, na'nama wawi honona re rawlar pia rla rlererun la weran teti pa rwuwul wenwenna la' danau de ralamni. ");
INSERT INTO lex_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mak khuri-kwa'ana wawi re rawlar pia rla rakot nohora wawi re rora riy maroro'a re la leta ralamni. ");
INSERT INTO lex_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ha narieiniande riy honona la let de ralamni rla rwahaka Yesus pa rora rwatrom memna. Noma rwak lilili-mamuau pua Yesus yan memmemna Nalo'on la' gen die ne plet pa Nwaran nek wa. ");
INSERT INTO lex_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Noma Yesus Nha'at la puou na'nama rleretia danau pa rawal lia E letni-ruhunni. ");
INSERT INTO lex_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","La hande, riy rodia mak kaliu'uta ida de rran nan wut tio'a la u'tani maka nanin la pa rodia la Yesus de. La'pa Yesus Namkek tutga riy mak kmai re pesiayni raruri, noma Yesus Nakot la riy mak kaliu'ut de Niwra: “Yana mumta'ata ama! Dodo'ondi de A'umou-uwitn oleka do'omu-halmu.” ");
INSERT INTO lex_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Makwatutu-kwaye'a agama dom mak kden la hande rwaror E' de rimormior niek E' wa pa rwaror la ralamni de riwra: “Inee! La'pa Enakot emkade de, riy de e Napolu-naliella Uplerlawna yoma Uplerlawna Nmeh'a Nodi plolli pa Namou-nawitna do'oni-halli!” ");
INSERT INTO lex_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mere ira ralma-riorni re, Yesus Nat niohora momuoga, pede Nakot la: “Ee, hya' ed mak kariei pia mimpiaror nana ralma yatyata-halal dena?! ");
INSERT INTO lex_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","La'pa plet pa A'ukot nek la e'a giwra e do'oni-halli ramou-rawitn oleka de, miplin niohor ma'ta plollola pa e do'oni-halli ramou-rawitn oleka me edonna, mere la'pa Apuaran pia A'ukot la e' pa namat pa nala'awa de mimiat niohor memna A ru'ru-la'yu etla yoma mimkek nan memna. ");
INSERT INTO lex_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pede hota la' dodo'ondi de Agiwra tiut muemna tiy miy, la'a noh di wawannu de Rimormiori A'nani A'g ed mak kodi plolli pa umou-uwitna riy do'oni-halli.” Noma Yesus Nakot la mak kaliu'ut de Niwra: “Hyalia, mumat doin la pa mpuopna u'tamu de pa mlia'awa rommu.” ");
INSERT INTO lex_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Dewade mak kaliu'ut de namat doin pa nla'awa la romni nayanni. ");
INSERT INTO lex_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","La'pa riy rahu re ramkek memna hihi'a-yapyap die noma honona rwer rer wiawni, ne ra'uli-rawedia Uplerlawna yoma Uplerlawna Nal oleka plolli-mneheni mak emkadi la rimormiori mak kdella nohkerna wawannu. ");
INSERT INTO lex_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","La' noma Yesus Nhoitio'or la gen diewa. La'pa Yesus Nalala' rer mia'ta noma Namkek nana mak kawoka blastena id de nanni Matius. La' ler de de Matius e namtatna la gen miaka nhi'inde enawoka blasten la. Noma Yesus Npol lia: “E! Mua mliernohor A'g ee!” Noma Matius naprir pia nlernohora Yesus. ");
INSERT INTO lex_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","La'pa Yesus e Nana'an rer lia Matius romni dewade riy harahu maka nhi'inde leta mniotni sukni atia'ala re, emeka mak kawoka blastena me riy mak ha riwra riy dodo'a-halala rmai pia rora Yesus me maka ha Nwatutu-nwaye'a re pa ra'an rewre'wa. ");
INSERT INTO lex_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Riy Parisi mana ramkek wali hare. Noma ratiana riy maka Yesus ha Nwatutu-nwaye'a re riwra: “Oi! Nihya'pa miy tungkurmi de Nora mak kawoka blastena, ror wutga mak khi' do'a-kyap hiala dom to'a re ra'an wutu?!” ");
INSERT INTO lex_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","La'pa Yesus Natlin nana yatianni re noma Yesus Nakot la re Niwra: “Mak edonna kanieni edonna rma rwahaka dokter. Eneknek to'a mak kamehra nanpena ed mak kwahaka dokter. ");
INSERT INTO lex_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mpiaror kalwiedweda Puka lirni makden la tatar di: “Rimormiori maka ktutga ralam kalwiedni la rimormior wialli khi' A ralmu pa uhepru de nareh dioin meman la riy mak kala prehenni-maunu mai A'u.” Yoma A maimia'yu di de A'g e edonna mua puolga riy mak kiwra irakleha do'a-hala, mere Amuai di totpa Apuolga riy dodo'a-halala pa rhoitio'or doini do'oni-halli re.” ");
INSERT INTO lex_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","La'pa nhorwua noma lera ida ne mak klernohora Yohansi mak kharani rmai lia Yesus pa ratiana riwra: “Nihya'pa amora riy Parisi re matahan lara (puasa), ne mak klernohora Tuna de ra'ana?” ");
INSERT INTO lex_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Noma Yesus Nakot la Niwra: “Emkameni la miy wniarormi dena de?! A' di de emeknekama muanke'a mak kiwra kmehlima. Riy maka rpol niana-rwak nana pa ra'ana-remun la yawoka-yale'u la mehlima-marya'a, de hota ralamni edonna rmolu-rhelam nohora muanke' maka kmehlima mak ktepartar mua't la ya'ana la' mei wawannu toh! Hade yala'ani atia' hade! Mere hota la'pa nte'ela la' lerni, nanpena ira'ala muanke'a maka kmehlim della mak ka'an wutu re onni. La' ler de nampena iratahan lara. ");
INSERT INTO lex_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Riy edonna rga' pua rala kokanan warwuaru ra rlowna rain mak kawniali. Yoma kokanan warwuar die hota napliu'uta-napdiedan nana rain mak kawnial de ne hota na'itar la pritni. ");
INSERT INTO lex_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Emkade wal lia riy edonna rga' pua rhuria anggur turu warwuarnu la' ha ulit mak mahneka. Yoma hota ulit mak emkade de hota npah'a pa ntowur doinia anggur tur diella me ulit de ho'mana ta'en niana rnair owa'ana. Anggur tur warwuarnu de rhuria la ha ulit warwuaru totpena rrora yana riata.” ");
INSERT INTO lex_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","La'pa Yesus Nora mak klernohor reri Yohansi mak kharani e rwahagaur reri, o'ta-mata ida nmai pia nwaltior tar lia Yesus gaini ralamni. Na'nama nakot la Yesus: “Tuna, a a'nu patke'a na'nama nmati. Mere awuak de, Mtiulan pa Mlia Mtieman la e'a totpena nmori owa'ana.” ");
INSERT INTO lex_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Noma Yesus Naprir dioin la pa Nor rewre'wa maka ha Nwatutu-nwaye'a re pa rora riy mak kpol die pa rla'awa. ");
INSERT INTO lex_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Rla' pa rden ma'ta la talla letgarni, dewade patke'a mak khur riara la'a anni termida wehrani woru, nma nlernohora Yesus. Nwaror la ralamni: “Hornama atieman to'ola raini plalahwani de, de hota akalwied wa.” Noma nlol Yesus to'orni pa na'nama nteman la Yesus raini plalahwani de tawnu. ");
INSERT INTO lex_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Dewade Yesus Nkillia patke' de pa Nakot la: “Yan mumta'ata. O pesiaymu e narur mai A'u ina, pa mkialwied wa!” Mtatande nekpa nnienni nmolu. ");
INSERT INTO lex_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nhor nioma Yesus Nodi liarni la o'ta-mat de romni. La'pa Namkek nan mak keu floiti, me riy rahu mak ko'a-kakur nohora mat die, noma ");
INSERT INTO lex_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesus Nakot la re: “Ee, hononmi mliergota! Yoma hararar de edonna nmati, hade e nanin to'a.” La'pa ratlin nana Yesus lirni de, noma honona riarin taru la yamalli. ");
INSERT INTO lex_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","La'pa honona re rlergot wa onnila Yesus nhiopanni dewade Yesus Nla'awa hararar de genni la'a rialma, na'nama na Ntorreria hararar de limni dewade nleretniekla nmori owa'an wa. ");
INSERT INTO lex_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nhor diewade riy rla' pa rodia kot della leta-leta la Galilea uhunu-ewatni-ewatni-lahwani honona. ");
INSERT INTO lex_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","La'pa Yesus Nto'or la gen die, pa Nalala' reri ne riy mak matni kyata worga e rlernohora reria Yesus. Rrora rhaun la Yesus riwra: “Ray Daud upni-a'nani ne! Mtiulla-msiayn nan mai ami ee!” ");
INSERT INTO lex_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","La'pa Yesus Nte'ela roma ralamni dewade rrora rmai pia rwatroma Yesus. Noma Yesus Natiana re: “Mimpiesiaya de hota Aghi' kalwied miy matyatmi rena?” Noma rrora rwahla Yesus lirni: “Ampesiay O' Tuna!” ");
INSERT INTO lex_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Dewade Yesus Nteman la rrora matni. Nakot la re Niwra: “Yoma la' miy pesiaymi pa hya' ed maka ha mihaka de hota mliernana.” ");
INSERT INTO lex_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nleretniekla matni re ramkek wa. Noma Yesus Nano'a re Niwra: “Mhioratrer memieheni memna A nnio'u di. Mlia' pa yan mikotkot harilla' he' to'a.” ");
INSERT INTO lex_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mere ir edon ratlin la lirni de mere rla'awa, pa rwahaur nohor momuoga re la'a leta-ruhuna la Galilea uhunu-ewatni-ewatni-lahwani honona. ");
INSERT INTO lex_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","La'pa riy maroro'a re rlergot pa riwra rla'awa dewade riy rodia riy maka hegana-kawnu nhu'ru ralma id pa rmai lia Yesus. Riy de naplinu naltieri. ");
INSERT INTO lex_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesus Nleretniekla Nhokar doinia hegana-kawnu de, ne mtatande nekpa riy de naltier kalwiedwed wa. Riy honona rwer rer wiawni pa riwra: “La' a mormior miamni di, de ami edon mamkek ma'ta hihi'a-yapyap mak emkadi la'a Israel di.” ");
INSERT INTO lex_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mere riy Parisi riwra: “Hegana amlawanni ed mak kala ruri-lai la Hade pede na Nhokra-nlai hegana-kawnu re.” ");
INSERT INTO lex_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Emkade mamain nek la Yesus Nla' pa Nler la leta-leta re honona. Nwatutu-nwaye' la'a roma-lewu miaka Yahudi re rhi' kreini-iskolli, me Nakot nohora Kot Kalwieda-Paitiota de hota Uplerlawna Nodi plolli emeka Ray. Enhi' kalwieda rirahu maka klernana nnieni-nhiena, mehra-mau hya'a-hya'a to'a. ");
INSERT INTO lex_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","La'pa Yesus Namkek la rirahu re, de Yesus ralamni ntuin doin la pa Niwra Ntulan la ira. Yoma honona re meh'a nalerlera, yoma rakleha riy mak ktutga talla mak kaplollol la' ira. Honona re emolmolla pipi-duma mak kakleha riy mak kodi. ");
INSERT INTO lex_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Noma Yesus Nakot la talanwalli maka ha Nwatutu-nwaye'a re, Nnairia yawalliohora id pa Niwra: “Emolmolan nekama wetra' harahu maka nkern olek la nhyi' ralma, mere mak kreiki-kwo'ora, edonna rtu'tu, emkade walia mak edon katlin ma'ta Uplerlawna lir kalwiedni de harahu wali mere mak kakot nohora Uplerlawna lir kalwiedni riy doma rmeh'a. ");
INSERT INTO lex_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","La' hade pede emolmolan nekama rwak la ora nhyi' de totpena nhopna mak kreiki-kwo'ora pa rla rreiki-rwo'ora, mpiak wal lia Uplerlawna totpena Ntutga riy pa rre'ela rakot nohora Uplerlawna lir kalwiedni la rimormiori mak edon katlin ma'ta.” ");
INSERT INTO lex_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nla' pa nte'ela lera ida, noma Yesus Npol wutga maka ha Nwatutu-nwaye'a re riy termida wehrani woru. Noma Yesus orgahani Nala ruri-lai la ir honona totpena rnairia pa ra rhokra-rlaiya hegana-kawnu me la' walia totpena ra rhi' kalwieda mak kler la nnieni-nhiena mehra-mau honona. ");
INSERT INTO lex_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Riy maka Yesus ha Nwatutu-nwaye'a re maka Enhopan pa rodia Uplerlawna Kot Kalwiedni-Paitiotni de, riy termida wehrani woru. Hare nanni de: Simon maka ha rpol wual lia Petrus, nor walia hyalli Andarias, me Sebedeus a'nani Yakowsi nor hyalli Yohansi, ");
INSERT INTO lex_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ra'itra Pilipsu, nora Bartolomeus me Tomsa me Matiusu maka kawoka blastena, me Yakowsi, Alpius a'nani, me Tadeus, ");
INSERT INTO lex_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","la'pa Simon mak kwayotil memna Romawi rodi plolli la Israel, la'pa Yudas Iskariot mak ka'olga Yesus. ");
INSERT INTO lex_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Riy termida wehrani woru mak kodia Uplerlawna Kot Kalwiedni re, Yesus Nhopn ir pa rhi'a hya'a maka Ha Nakota ri, de Niwra: “Hyal miy re! Yana mlia'a riy maka edon kdella Yahudi genni, me yana mlia' wal lia riy Samaria genni-tienni. ");
INSERT INTO lex_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mere mlia' riy Israel re. Yoma Israel rwaltio'or doin olek Uplerlawna pa emolmolan nekama duma mak kawlar dioin oleka la'a matromni. ");
INSERT INTO lex_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Mikot la re miwra edon nalo'on wali ne lerni ntutu-nte'ewa pa Uplerlawna Nodi plolli pa emeka Ray ida. ");
INSERT INTO lex_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mhi' kalwieda riy mak kamehra-kamau, mimoria riy mak kmati-kmolu, mhi' kalwieda riy maka kanienia ulityata-temyata me mhiokra-mliai dioinia hegana-kawnu. Miy edon mial hadomdom pa mliernan ruri-lai die, mere Uplerlawna ed mak kal nek rurni-laini honona tiy miy. Pede, la emkade walia mtiulan la rimormiori wialmi, de yana mhiopan pa rala miy kaimi. ");
INSERT INTO lex_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yana ma miodia kupan maha, kupan wawahra, onde kupan pi'ra. ");
INSERT INTO lex_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yan miod walia arkai onde naniayarmi ida-woru onde laka wniopmi woru totpena mhiernu la' talan ralma. Ne yan miod walia lie'enmi. Yoma riy mak kar lia Uplerlawna kniarni de rlernan liwatnu-odawni nhierannu la'a riy maka e rhima-rre' reria. ");
INSERT INTO lex_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","La'pa mtie'ela leta-ruhuna dom de mihak nana riy maka enreinian miy pia mpiak la pa miora mhiol wiutu. Mdien neka la ir romni la'pa kniarmi la' let de la nhorwua nanpena mpiaran la' rom de ");
INSERT INTO lex_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","La'pa mtie'ela romni nayanni de mpiak pa Orgahi-Orha'a Nala kalwieda-paitiot la. ");
INSERT INTO lex_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","La'pa rom de mniotni rreinian miy die hota plola pa hota rlernan Uplerlawna kalwiedni-paitiotni. Mere la'pa edonna rreinian miy die, mhiedg owa'an lirmi re maka mpiaka Uplerlawna Nhima-nre' ira. ");
INSERT INTO lex_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","La'pa mlier la roma-lewu onde leta-ruhuna maka edonna kreinian miy onde edonna katlina-katail tiy miy die mtio'or doin gen die, me mkiakan doinia awu mak kden la lakmi lia'armi totpa mtiutga de Uplerlawna Nwayotlia ira. ");
INSERT INTO lex_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mhioratreria! La'pa nte'ela' lera-mela hohoni maka Uplerlawna Nhudi-npara rimormiori la watghudi lokarni-tatiaili lahannu, de riy mak kden la leta-ruhuna maka edon kreinian miy er maka klernana Uplerlawna niukamnu mak kareh dioin miemna niukamnu maka riy yatyata-halala mak kden la leta Sodom nora Gomora hota rlernana.” ");
INSERT INTO lex_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Mhioratrer hadi! A'g e ghopan pa mlia'awa A arwa'lu geni pede hota miy die emeknekama pipi-duma mak kakleh ruri-lai pia mlier tar lia ohpora-ahdiawra letgarni mak kiwra klihir matmata-khaw riarara. Pede erammi la' temmi pa emeknekama niy, me mtiutga nhioli samomuou emeknekama lmo'ma maru. ");
INSERT INTO lex_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mi'ererma yoma hota riy mak edon kpesiay re rte'la miy pia rod miy lia mak khudi-kpara gaini. Hota rliwar miy lia' roma-lewu miaka Yahudi re rhi' kreini-iskolli la. ");
INSERT INTO lex_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ne hota ra'it miy lia'a o'ta-mat lalawna me la'a ray-ray re gaini ralamni yoma la' A rerie'yu. Hota emkade totpena mimliernan talan pa mikot nohor Kot Kalwieda-Paitiota la ira, ne la' walia totpena mak kaplin niohor Uplerlawna re ratlin nan A na'nu. ");
INSERT INTO lex_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Mere la'pa rod miy pia rhudi-rpar miy, de yan memmemna ihrami rteplu yoma mpiarora hya' maka hota miy mikota? Yoma hota la'pa ha ratian miy nanpena miy Amlawanmi Uplerlawna Nal miy pia miat nohora hya' ed maka ha mikota de. Yoma hya' mak ha mikota de edon nwatiawua miy wniaror wamuehemi, mere ha nwatiawu Uplerlawna Nhiw Lululli. ");
INSERT INTO lex_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Hota la' ler de riy rala inni-narni makpesiay A'u pa rwenna. Emkade wal lia ama nek de nala a'nani makpesiay pa rwenna. Me upa-a'na nek de hota edon ratlin la inni-amni makpesiay pede rala inni-amni pa riy rwunu-rwenna. ");
INSERT INTO lex_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Riy la' meni-meni to'a hota rahankeran rer tiy miy yoma miy mliernohor reri A'u. Mere la'pa he' ed maka ktorrer pitpitga pesiayni pa la ntutu-nte'ela honi de hota nlernana mormiori-lewlewna plalahwa pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pede la'pa ramuki-rama'al miy lia leta ida, de mlia'awa la' leta id owa'ana. Mimpiesiaya, la'pa miy edonna mlia' ahor mua'ta leta-ruhuna re honona la'a Israel, de hota Rimormiori A'na Amuai wia. ");
INSERT INTO lex_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","A'n iskola edonna nareh dioin tungkurnu me maka ha rhopna-rli'iru mana edonna narehelia upni-matromni. ");
INSERT INTO lex_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","La'pa hota a'n iskola rlernan walia hya' ed maka tungkurnu de nlernana. Me hopopna-li'iru ida nlernana hya' ed maka upni-matromni nlernan walia. Emkade wal lia' Agor miy die. A'g ed maka emolmolan nekama mak khi' o'tani la romau ida me miy die emeknekama rom de mniotni. Ne mak edon kpesiay re rhoi A lia Be'elsebul (de hegana amlawanni), dewade hota emkameni owa'an la' miy?! Hota ha rhoi nanmi re de npohra-ngehpa memn owa'ana.” ");
INSERT INTO lex_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ina-nara, yan mimta'at rira, yoma mak kayade'a id mana la'a Uplerlawna lirni-tunnu hota edonna nayade' owa'ana. Ne maka kayawunmu hota rat niohora momuou. ");
INSERT INTO lex_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hya' ed maka A'ukot targa tiy miy la yawunamnu de mikot nohor momuoga totpena riy rat niohora. Ne hya' maka A'upupua la miy tlinmi ralamni me mak Awuahaur walia la mel'utni-malienni, de hota repra rauria de mkiakna la lol meni-meni to'a totpena riy rat niohora. ");
INSERT INTO lex_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Yan mimta'ata hota riy rwunu-rwenan miy inonmi, yoma miy inonmi de hota riy rwenan nana, mere ta'en niana ir rhi' yawuhi-yawe'et la miy aranmi (jiwa) pa rla' Ilyamou-Watyatoha. Mimta'at la Uplerlawna, yoma E' ed mak kodi plolli pa kwenna inonmi dewade Nrinnia miy aranmi la'a ai mormiori ralamni (naraka). ");
INSERT INTO lex_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ma'nu prowta mak kakleh weli nekane, hota id mana edonna ntuin la tani wawannu, yoma Amlawanmi edonna Nwayow nohora. ");
INSERT INTO lex_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Morat lihirmi la' o'tami ho'mana Uplerlawna Nat niohora momuoga. ");
INSERT INTO lex_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","La' hade pede yan mimta'ata. Uplerlawna Nsayn miy me Ntera-ndem miy nareh dioin meman la ma'nu prowta re.” ");
INSERT INTO lex_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“La'pa he' ed maka kwayow nohor pesiayni mai A'u la'a rimormiori gaini ralamni de, hota A' muana wuayow nohora e'a la'a A A'mu mak kden la Ilyamou-Watyatoha gaini ralamni wali, Agiwra A mu'tu-rah'u id e'a. ");
INSERT INTO lex_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mere la'pa hameni ed mak kreher pa kiwra e' edonna nlernohor A lia rimormiori gaini ralamni, A muana hota Arieher doini wali e'a la'a A A'mu mak kden la Ilyamou-Watyatoha gaini ralamni.” ");
INSERT INTO lex_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Yana mpiarora de Amuai die Agod niek riy mak kden la nohkeran di wawannu pa rora rimormior wialli re rkalwieda. Mere onnila A rerie'yu pede riy id nor rimormior wialli re rahuri-rawo'ora. ");
INSERT INTO lex_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","A maimia'yu di mak kariei pia “a'na muanke'a nahal amni, me a'na patke'a nparwah'a inni me ina nora yananni patke'a idma nwohora-ntatr ida. ");
INSERT INTO lex_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Yah! Mak khi' nana yawunu-yawenna yawunu-ya'ara de e nawniair meman la roma ralamni.” ");
INSERT INTO lex_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yoma riy maka khoratreria inni-amni pa nhortapling A' die, de riy de ta'en niana nre'ela' riy mak klernohor A'u, yoma nhiol die edonna nla' nana Uplerlawna ralamni. Emkade wal lia riy maka ralamni kod rer lia upni-a'nani ne edonna nken A lia nhioratni. ");
INSERT INTO lex_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ne la' walia riy mak edonna kre'ela pa kor wut A' pua tler la yamuki-yama'ala onde matmiati pa emolmolan nekama nhoi wawayanni la auwlakra pa nlernohor A'u, de hota nhiolli de edon naplola emeka riy mak klernohor reri A'u. ");
INSERT INTO lex_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Riy maka nhoratrer tio'a mormiorni la nohkerna wawannu hota e' edon nler la mormiori-dardiari plalahwa pa nodi liarni. Mere la'pa riy maka khoratdoinia mormiorni la' noh di wawannu pa nlernohor reri A'u hota nlernana mormiori-dardiari pa nodi liarni.” ");
INSERT INTO lex_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Riy meni ed maka kreinian miy, de hade emekwalima e nreinian olek A' wuali. Ne la'pa hameni nreinian A'u de emekwalima e nreinian oleka Uplerlawna mak khopan pa Amuai. ");
INSERT INTO lex_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Riy maka kreiniana makwohorulu-ktatrulu ida, yoma niwa ntulan la e'a onnila makwohorulu-ktatrulu id hade, riy de hota nlernana siewa-kai emekwalima makwohorulu-ktatrulu re rlernana. Ne he' ed mak kreiniana-ka'nana riy id mak kaplol la Uplerlawna yamkekni yoma eniwra ntulan la e'a onnila riy mak kaplola hade, hota riy de nlernan wali siewa-kai emekwalima riy mak kaplola re rlernana. ");
INSERT INTO lex_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ne mpiesiayo! La'pa hameni ed mak kal ger la riy mak kakleha weli remnia pa na nawe'era tiernu yoma e nhoratreria makpesiay A'u id wali hade, riy mak kal ger de nek de hota nlernan memna siewni-kaini la'a Uplerlawna.” ");
INSERT INTO lex_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","La'pa Yesus Nwatutga riy termida wehrani woru re pa nhorwua dewade Nhoitio'or la gen diewa pa la'pa Nodi liarni la Nwatutu-nwaye'a, ne Nakot nohora Uplerlawna lirni-tunnu la' leta-ruhuna la Galilea yapatni. ");
INSERT INTO lex_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","La' ler de Yohansi mak kharani etla roma nhio'la ralamni pa la'pa natlin tutga Yesus Kristus maka Uplerlawna Nano'targa de hihi'ini-yapyapni ");
INSERT INTO lex_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","noma nhopan doinia mutwualli doma mak klernohor reria e'a pa rla' pa ratian nohora Yesus plollolli. Riwra: “Tuna, O di ed maka Uplerlawna Nano'targa O maimiaimu? Me yanpa maka ampei-mnara de riy dom to'a?” ");
INSERT INTO lex_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Noma Yesus Nakot la: “Hyal miy re, miwali owa'an la Yohansi pa mpiahaur nohora hya' ed maka ha mimkeka me mitlina. ");
INSERT INTO lex_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","De riy maka matni kyata ramkeka, maka lakni nmati, rala'awa, maka ulatni temni yata rkalwied wa, maka hatilu mana ratlina, mak kmati olekwa mana rmori owa'ana, me Kot Kalwieda-Paitiota mak kwatiawua Uplerlawna mana rakot nohora la maka kakleha-kaplara. ");
INSERT INTO lex_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ne la'pa riy honona mak edonna kwayotli A'u, mere rpesiay niek wa, hota rlernana unut lawna.” ");
INSERT INTO lex_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","La'pa riy maka Yohansi mutwualli re rawal wia. Dewade Yesus Nwahaur nohor Yohansi la'a riy rahu mak kden hande. Yesus Niwra: “La' ler ululu de miy e mlia'a wo'orletna-kawurloini totpena mimkeka hya'a? Mpiahaka riy id maka o'tani wolwo'la pa emeknekama wewna lihira maka anni ha nten dioinia rena? ");
INSERT INTO lex_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mlia' pa mpiahaka hya'a pa mimkeka? Mpiahaka riy ida maka naniairi samoga? Riy mak emkare de ha rden la tuna ray romni-lewnu! ");
INSERT INTO lex_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pede mlia' de mpiahaka hya' pa mimkeka? Mlia' pa mpiahaka makwohorulu-ktatrulu ida toh?! Ha naplola. Ne Yohansi nek de nareh dioinia makwohorulu-ktatrulu re. ");
INSERT INTO lex_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yoma la' Puka ralamni de Uplerlawna Nakot nohora Yohansi kniarni, Niwra: “Mhioratreria! Hadi ed maka Aghopna. Hota Aghopna hade pa nala' ulg O'a totpena nwahyar tialan pa Omliola.” ");
INSERT INTO lex_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mhioratreria! La' ululu la'pa ntutu-nte'ela ler di la' nohkeran di wawannu de riy id mana edonna nareh dioinia Yohansi makharani. Mere la'pa la' lera-mela ri maka Uplerlawna Nodi plolli pa emeka Ray, de E mutnu-rahanu mak kakleh weli id ho'mana nlernan yara'a-yapalu nareh dioinia maka Yohansi nlernana. ");
INSERT INTO lex_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","La' lera Yohansi nwaga kniarni pa nakot nohora de hota Uplerlawna Ntorna-nrautu pa emeka Ray pa la'pa nte'ela ler di, de riy maklekla-makdiaini rwahak talan pa rweyata-rwaniaga e wniatutnu de totpa rodi plolli la. ");
INSERT INTO lex_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","La'pa edon nte' ma'ta Yohansi maimiaini de, ha nahniort olek wal lia la'a Musa deullu-tatarni me la' wal lia makwohorulu-ktatrulu wniatutnu-wniaye'eni la'a hya' maka hota kayamkeka la' ler di, de hota Uplerlawna Nodi plolli pa emeka Ray. ");
INSERT INTO lex_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ne la'pa mimiwra mimpiesiaya hya' mak kaplola, hota miatga de Yohanis de Elia eda de maka ha rhorat targa la Puka ralamni de hota nmai. ");
INSERT INTO lex_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","La'pa miy tlinmi erla de mitlin reri! ");
INSERT INTO lex_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Hota Agala yawalliohora hya' pa ga' ukot nohora rimormiori mak edon kpesiay A'u la lera-mela rina? Ir de emolmolla keke'enku'a woka woru mak kamtatna la'a ya'olgeni pa wokni ida npol lia wokni dom to'a yoma idma edonna nlernohora id lirni pede riwra: ");
INSERT INTO lex_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Amnairi floiti me tiwla-prai pa amahe'i-mahepur nohor miy mere miy edonna mlioi-mhieka! Ampahniar nohor miy lia'a nhiara matmiati-molmuolu mere miy edonna mkio'a-mkiakru!” ");
INSERT INTO lex_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Hade emekwalima Yohansi mak kmai noma natahan lara (puasa) me edonna nemnia anggur turnu noma riy riwra hegana e nhu'ru ralma e'a.” ");
INSERT INTO lex_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Noma dodo'ondi Rimormior A'na A' Muai wia pa A'una-gemnu noma riy riwra: “Mimkek to'ola hade. Ya'ante'eni ne, ma'wanu de, pa la' nor wutga mak kawoka blastena, me riy yatyata-halala rwatamputu.” Mere la'pa miy mpiayotlia Agora Yohansi hihi'ini-yapyapni ho'mana Uplerlawna kirkirni-ralma-rior samomuounu mak amlernohora de hota nayamkek la mak klernohora A wniatut muamni re nhiolli-lietni ilu-wniehwa samomuounu.” ");
INSERT INTO lex_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Noma Yesus Nhar lirni pa Nwaghala rimormiori mak kden la leta-ruhun maka Yesus Nhi' nan hihi'a-yapyapi mak kamehi-kayona (mujizat) harahu. Yoma ramkek memna hihi'a-yapyapi mak kamehi-kayona harahu re mere rahmen to'owa rhoitio'or doini-rtahnei dioin la ir do'oni-halli. ");
INSERT INTO lex_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Yesus Niwra: “Hoi! Makden Korasim nora Betsaid miy ree! Hota mlier la yatlorni-yatra'ani! Yoma miy edonna mpiadan nohora hihi'a-yapyapi mak kamehi-kayona maka ha mimkek oleka re. Makden la Tirus me Sidon edon ramkek nana hihi'a-yapyapi mak emkare la' ler ululu, mere la'pa Aghi' hihi'a-yapyapi mak kamehi-kayona mak emkare la mak kden la leta Tirus nora Sidon la' ler ululu, de ramkek nana neknanama plol toto' pa rnair oleka naniairi yaluli-yahona pa ra rtutga ralamni mawla la do'oni-halli me rhoitio'or doini-rtahnei dioini oleka do'oni-halli re. ");
INSERT INTO lex_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mhioratreria, la'pa ntutu-nte'ela watghudi lokarni-tatiaili lahannu la lera noha niatni de hota Uplerlawna niukamnu la' miy wawanmi nareh dioin la mak kden la leta Tirus nora Sidon re. ");
INSERT INTO lex_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne hota mak kden la Kapernaum miy, la' wniarormi de hota rran tutul miy nanmi la tulu-lyanti? Hade edon emkade. Hota reriehenu rrinnia miy lia ai mormiori ralamni (naraka). Makden la Sodom edon ramkek nana hihi'a-yapyapi mak kamehi-kayona maka Aghi' nana re, mere la'pa hihi'a-yapyapi maka Aghi' oleka pa mimkek nana re, de Aghi' la' ler ululu pa makden Sodom ramkeka nana neknanama plol toto' pa rhoitio'or doin olek do'oni-halli. La'pa emkade de ir letni de edonna rtutin doinia la pede ed neka mla' dodo'ondi. ");
INSERT INTO lex_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mhioratreria! La'pa ntutu-nte'ela Uplerlawna maimiaini la' ler noha niatni, de Uplerlawna niukamnu la miy wawanmi, de nareh dioin la makden la Sodom re.” ");
INSERT INTO lex_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","La' ler de Yesus Nsumbain pa Niwra: “Ama, Orgahi-Orha'a mak ktorna-krautia nohmarna nora lyanti tulu. A'uli-uwedi O'a yoma wniarormu-wnialaimu, hihi'imu-yapyapmu, de O e Muwunmua la'a riy miaka kakriahlu la iskola me rwarora ir er mak katu, mere Omukota la riy maka nhiolli-lietni emeka keke'enku'a pa rlol yawa. ");
INSERT INTO lex_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yoma plol toto'a pa hade ed mak kla' nana A'mu O ralma-riormu.” ");
INSERT INTO lex_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nsumbain pa nhorwua noma Nakot owa'an la mak kden hande Niwra: “A A'mu Nal oleka plolli-mneheni kirkira-ralma-rior samomuounu mai A' wua. Riy id mana edon nat niohora A'u eneknek to'ama A A'mu. Me riy id mana edonna nat niohora A A'mu eneknek to'ama E A'nani A'u, ne riy mak Agiwra ukot wahyaria A A'mu la ira.” ");
INSERT INTO lex_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ina-nara, mmiai wia mai A' di wa, miy hononmi mak kakleha oleka ruri-lai wia la'a hya' ed maka ha mikwara re. Mai pia utih liwatmi me uwrien aranmi. ");
INSERT INTO lex_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mliernohora hya' ed maka A'ukota ne mitlin pa wuatutga tiy miy. Yoma A nhiolu-lie'tu de mnapla pa Agatu ghu'ru-ghelma, ne hota miy ralammi namtiertiernu. ");
INSERT INTO lex_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yoma hya' ed maka A'ukota, de nla' nana miy ralma-riormi, me kwar maka Aghopan pa ha mikwara re, rapranrana.” ");
INSERT INTO lex_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lera ida la' Sabat lerni (ler maka Yahudi yana rkar lia) de Yesus Nora maka ha Nwatutu-nwaye'a re rala'a la nhyi' wetra' lawna ida ralamni, noma maka ha Nwatutu-nwaye'a re rkura wetra' lawna re harni pa ra'ana emkade to'owa yoma raplara olek wa. ");
INSERT INTO lex_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","La'pa riy Parisi ramkek nana noma rakot la Yesus riwra: “Mumkek la me! Maka Mpuatutu-mpuaye'a re rpera-rdaiti olek la it agamni deullu-tatarni, yoma ir e rkar lia'a Sabat lerni.” ");
INSERT INTO lex_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Noma Yesus Nakot la re Niwra: “Miy mpiaik nan olek la'a hya' maka Daud nhi'a la' lera e nora talanwalli re raplara toh! ");
INSERT INTO lex_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Enler la Uplerlawna roma kreini ralamni pa enora mutu korni re ra'ana rot miaka rala oleka la Uplerlawna, kennama la'a it agamni deullu-tatarni de mak ka'ana roti re de eneknek to'ama imam-imam rmeh'a. ");
INSERT INTO lex_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ne miy mpiaik nan olek wal lia Musa deullu-tatarni toh! E rhorat targa la Musa pukni de imam-imam re rtepartarlia kniarni la'a Uplerlawna roma kreini nayanni la'a Sabat lerni. Emkade pede emekto'ama rpera-rdaitia deulu-tatra la'a Sabat lerni, mere Uplerlawna edonna Nwaghala ira. ");
INSERT INTO lex_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Mere mhioratreria hya' maka ukota ri. La' handi de Ed maka Enreh wialia Uplerlawna roma kreini. ");
INSERT INTO lex_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ne la' Puka ralamni de e riwra: “Rimormiori maka ktulla-ksayni rimormior wialli khi' A ralmu pa uhepru de nareh dioin meman la riy mak kala prehenni-maunu mai A'u.” La'pa plola pa miy e mnia'erit nan oleka lira re, de hota taken niana mpiaghala riy maka edonna khala. ");
INSERT INTO lex_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","A'ukot hari honona yoma Rimormiori A'nani A' die ed mak kodi plolli pa A'ukot nohora hya' ed mak kaplola onde nhala pa itsi'a la Sabat lerni.” ");
INSERT INTO lex_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesus Nto'or la hande ne Nla Nokria gen miaka nhi'inde Yahudi re rhi'a kreini-iskolli. ");
INSERT INTO lex_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Nla' noma Nlernana riy maka limni walli kmati. La hande de riy doma e rahak kahelli-kaha'arni la Yesus totpena Nhi' de rodia la letgara lawawna, pede rmai pia ratiana Yesus riwra: “Tuna, la' O wniarormu de itsi' kalwieda riy mak kamehra la'a Sabat lerni de lol talanni?” ");
INSERT INTO lex_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Noma Yesus Nwahla Niwra: “La'pa miy pipmi-dummi ida e ntuin tiar lia'a hu'ula-tpopoini id ralamni la'a Sabat lerni, de hota mimkek rer nieka dum de polpuolu-hawaunu la hu'ul de ralamni?! Edonan toh! ");
INSERT INTO lex_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ne rimormiori re, Uplerlawna Nsaynia hare pa nareh dioin pipdiuma. Pede itsi' kalwiedweda riy la Sabat lerni de ed mak klernohora Uplerlawna deullu-tatarni.” ");
INSERT INTO lex_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nhorwua noma Yesus Nakot la riy maka limni walli kmat die Niwra: “Mpuetar limmu!” Noma riy de nwetar limni de mtatande nekpa nnienni nmolu pa emekwalima limni walli mak kmormiori die. ");
INSERT INTO lex_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mere riy Parisi re rhoitio'or la gen miaka Yahudi rhi' kreini-iskolli de, na'nama rna'ohma pa rwenna Yesus. ");
INSERT INTO lex_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesus Nat niohor meman la'a Parisi re nnia'ohma yatyatni la E'a. Pede plet pa Yesus Nwaran la'a gen die ne rirahu rlernohor reria. Ne Yesus Nhi'a mak ksaki re honona pa rkalwied la nnienni-nhienni nora mehrani-maunu. ");
INSERT INTO lex_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mere Yesus Nahmen pa riy rla rwahaur nohora E'a. ");
INSERT INTO lex_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Mere la' Yesus Nwatutu me Enhi' kalwieda rira la nnieni-nhiena pede nhi' aplola Uplerlawna lirni, maka makwohorulu-ktatrulu Yesaya ha nhorat targa la Puka niwra: ");
INSERT INTO lex_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Hadi de A hopopnu maka Awualir niana. Riy maka Asiayni inhatta me khi' A ralmu pa nahepru. Hota Agala A Nhi'wu la E wawannu pede hota E' ed mak kakot nohora la'a rimormiori la'a noheri woru-lyanti nayanni de Niwra hota Enhi' riy pa ror owa'an Uplerlawna rkalwieda. ");
INSERT INTO lex_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hota E edonna Nhi' yawo'ora, onde polpuolu-hawaunu E tullu-petanni la'a loi liawna-talan lawna. ");
INSERT INTO lex_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Emolmolan nekama au dieutu mak kerna mere edonna rtewar doinia la, me wa'du maka mormiorni nhelelma ho'mana edon rwenan nana, emkade wal lia A hopopnu de wniehwani-liakatni mnapal la' riy mak kakleha ruri-lai. Mere hota Ntekal rer niekpa totpa rimormiori ror owa'an Uplerlawna pa rkalwied owa'ana. ");
INSERT INTO lex_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pa hota rimormiori la noheri woru-lyanti nayanni rha'ara aranni la E'a.” ");
INSERT INTO lex_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","La'pa nhorwua dewade riy rodia riy mat yata ida, me naplinu naltieri wiali yoma hegana-kawnu nhu'ru ralma. Noka Yesus Nhokar doin hegana-kawnu mak khu'r ralma pede riy de naltieri me namkek samomuou owa'ana. ");
INSERT INTO lex_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nhor nioma riy honona rwer rer wiawni pa riwra: “Yanpa hadi ed maka ha riwra Daud duratni-waitni inhatta maka Uplerlawna Nano'taru?” ");
INSERT INTO lex_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","La'pa riy Parisi ratlin nan hare noma riwra: “Oi! Riy di enekneka Nhokar doin to'a hegana-kawnu rella yoma Be'elsebul, hegana amlawanni de, ed mak kala ruri-lai la E'a.” ");
INSERT INTO lex_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mere Parisi ralma-riorni re Yesus Nat niohor momuoga. Noma Yesus Nakot la re Niwra: “Hegana re emeknekama hairi ida. La'pa la hairi ida rimormiorni ema rhakre'era la wokni-wokni mak kahuri-kawo'ora, de hota hair de edonna namteman plalahwa. Me luwu-a'na ida onde leta-ruhuna la'pa rden rer lia yahuri-yawo'ora de hota rweyata-rwaniawua. ");
INSERT INTO lex_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Emkade walia la hegana amlawanni tnioranni-riautnu. La'pa hegana woka-le'u ida, nhokra hegana woka-le'u dom to'a, de hota hegana tnioranni-riautnu ema reyapie'era. ");
INSERT INTO lex_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","La'pa mikot emkade mai A'u nnia'eratni de hota mak klernohora miy niek de rnairia hegana amlawanni plolli-mneheni pa Nhokar doinia hegana-kawnu. Mere mak klernohor miy nek de rat niohora wniarormi de nhala. ");
INSERT INTO lex_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mere Aghokra-liaiya hegana-kawnu yatni-rha'ani re de Aniairia Uplerlawna Nhiwni plolli-mneheni. Ne hade e ntut mueman de Uplerlawna ed mak kodi plolli pa emeka Ray, ne miy e mimkek nan oleka E rurni-laini. ");
INSERT INTO lex_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Itala mak karuri-kalai ida pa itsi' la yawalliohora. De la'pa riy riwra reyahru mak karuri-kalai ida re'eni-tniarnu, pa'etnu de nwutu-nkohg ulga mak karuri-kalai die nanpena nler la mak karuri-kalai die romni ralamni pa na'ala hade re'eni-tniarnu. Hade emekwali Aghi'a la hegana amlawanni. ");
INSERT INTO lex_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Riy mak edonna klernohor reri A'u de ir er mak khoklira-kpah'a waw mai A'u. Ne riy mak edonna ktulan mai A'u, de e' ed mak kweyata-kwaniawua A tulla-knia'ru. ");
INSERT INTO lex_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","La' hade pede totpena miatga, de la'pa riy nhi'a do'a-hala me napolu-naliella Uplerlawna, de hota Uplerlawna Namou-nawitna do'oni-halli re. Mere la'pa riy meni ed mak kapolu-kaliella Uplerlawna Nhiwni, de riy de, hota Uplerlawna edon Namou-nawitan la do'oni-halli de. ");
INSERT INTO lex_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ne la'pa riy ida nakot hadom pa na nweyata Rimormior A'na de nanni de hota Uplerlawna Namou-nawitna do'oni-halli de. Mere la'pa riy meni ed mak kapolu-kaliella Uplerlawna Nhiw Lululli, de Uplerlawna edon Namou-nawitna riy de do'oni-halli de la dodo'ondi, pa nden nek la pa Uplerlawna noh warwuarnu lerni Ntutu-nte'ewa.” ");
INSERT INTO lex_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Miy miwra mliernana ha wo' samomuou, de mpiak la yawuli-yatniamin maka onni kpoti-kadwu. La'pa au muaka khoptutu-khoplera, de hota wo'oni mana yat walia. Orwo'a-auwo'a mak kyata onde samounu, de tamkek nek la wo'oni. ");
INSERT INTO lex_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Miy die riy yatyat memna miy pede emkameni la hota miy mikot nohora hya' mak kalwiedweda?! Hya' ed maka klergot la it nurnu, de hade ed mak kwatiaga it ihranu ralamni. ");
INSERT INTO lex_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Riy maka ralamni kalwieda-paitiota, de nhi'inde rakot nohora hya' ed mak kalwiedweda yoma ihranu ralamni npenpuen lia kalwiedwedni. Ne riy yatyata-halala, nanpena rakot nohora yatyatni-halalli. Yoma yatyata-halala nagengen lia ira. ");
INSERT INTO lex_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hade pede mhioratreria! La' pa nte'ela lera-mela noha niatni maka Uplerlawna Ntorna watghudi (Nukum rimormiori), de rima-rima hota nwalol nohora orgahani lirni-tunnu la' Uplerlawna gaini ralamni. La'pa lirni-tunnu maka riy edon rwaror nohora mere pleta-plet pa rakot nek wa, hade ho'mana rwalol nohora la Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yoma hota miy lirmi-tunmi maka mpiet la' lera-mela ri, er maka khi' aplol miy onde miy lirmi-tunmi re nekpa rwaghal miy lia' ler maka Uplerlawna Nhudi-npara rimormiori it la watghudi lokarni-tatiaili lahannu.” ");
INSERT INTO lex_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","La lera ida noma makwatutu-kwaye'a agama ror wut nieka riy Parisi re rakot la Yesus riwra: “Tungkurga, Mhi' teka hihi'a-yapyapi mak kamehi-kayona totpena ntutga de Uplerlawna ed mak kala plolli-mneheni tiy O'a.” ");
INSERT INTO lex_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesus Nwahla: “Adoh! Tuw di, de rimormiori yatyata-halala mak kahmena kpesiay A'u. Mhiopan pa Aghi'a hihi'a-yapyapi mak kamehi-kayona totpena mpiesiaya. Mere hihi'a-yapyapi mak kamehi-kayona kuku' nek ho'mana A'g edon tiutga tiy miy! Eneknek to'ama mak makwohorulu-ktatrulu Yunus ha nlernan de. ");
INSERT INTO lex_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yunus nhol niek la up worum lawna apannu ralamni la lera-mel pa wotelu. Emkade wal lia Rimormiori A'nani A' die hota ghol niana lera-mel pa wotelu la'a noha-rai apannu. ");
INSERT INTO lex_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","La' noha niatni, la' ler maka Uplerlawna lerni ntutu-nte'ela pa Nhudi-npara rimormiori la watghudi lokarni, de hota makden la Niniwe rtutrier pia hota rto'ona riy tuwu di. Yoma mak kden la leta Niniwe rhoitio'or doin-rtahnei dioinia do'oni-halli la' lera Yunus nakot nohora Uplerlawna lirni-tunnu la' ira. Mere la dodo'ondi de Agetla miy gaimi mere miy edon mitlin la A li'ru pa mhioitio'or doin-mtiahnei dioin do'omi-halmi re, kennama A' di de ureh dioinia Yunus de. ");
INSERT INTO lex_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ne la'pa nte'ela lera noha niatni, la' ler maka Uplerlawna Nhudi-npara rimormiori la watghudi lokarni de hota pat maran mak kwatiawua weli tranna (mata angin selatan) ntutrieri pia nto'on reria riy tuwu di. Yoma pat maran de nwatiawua noha honi-rai tawnu (olietlet) pa nmai pia natlin nana wniatutu-wniaye'a Salomo mak katu die. Mere la' dodo'ondi de Agetla miy gaimi ralamni mere miy edon mitlin A li'ru pa mhioitio'or doin-mtiahnei dioin do'omi-halmi, kennama A'ureh dioinia Salomo.” ");
INSERT INTO lex_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“La'pa yatni-rha'ani nahniokar doin la'a riy ida ralamni, de loldoi-loldai lia wo'or kerkerna totpena nahak geni id owa'ana totpena nhu'ru ralma, mere hota edonna nlernana. ");
INSERT INTO lex_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","La' hade pede yatni-rha'ani de wniarorni de hota nawali owa'an la riy de. La'pa nawal wia de namkek de riy de nahgal tetema, ne nmou-nwitna emeka likti id maka ha rwahyar momuoga ne rwahi'a-rwayod tiarga. ");
INSERT INTO lex_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Noma nla' owa'an pa nmai die nodia yatni-rha'ani wo'itu de yatni-halli nareh dioin memn owa'an la e'a. Dewade ha rler la riy de ralamni owa'ana. Pede la'awa hohoni, de riy de nler la polpuol inni-wakwak amni mak karehi owa'an la' ulul genni. Hota hade ed maka tamkek nan wal lia' riy yatyata-halala tuwu di.” ");
INSERT INTO lex_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","La'pa Yesus entepartar mua'ta la wniahauru Nora riy mutlialawna re dewade inni nora a'nani re korni rmai wia. Noma rtutrier lia tio'or pa riwra rma rwatroma Yesus pa rwahaur wutu. ");
INSERT INTO lex_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Noma riy id la riy mutlialawna re nakot la Yesus Niwra: “Tuna, Tuna inni nora ammu-hyalmu e rtutrier lia tio'ora. Riwra rmai pia ror Tuna rwahauru.” ");
INSERT INTO lex_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Noma Yesus Nnairia yawalliohora pa Nakot nohor plein la riy de, Niwra: “A i'nu-na'ru a'mu-hya'lu la Uplerlawna yamkekni de he'a?” ");
INSERT INTO lex_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Noma Yesus Ntutga mak klernohor reri e'a re, na'nama Nakot la Niwra: “Hari, er maka a i'nu-na'ru a'mu-hya'lu. ");
INSERT INTO lex_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Riy maka khi' nana A A'mu la'a Ilyamou-Watyatoha ralma-riorni, de hare er mak kla' A i'nu-na'ru a'mu-hya'lu.” ");
INSERT INTO lex_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","La' ler de nekpa Yesus Nto'or la rom de pa Nodi liarni la' danau aratni pa Namtatna la' hande. ");
INSERT INTO lex_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Riy harahu rwayotil pa rma rpepan nana Yesus, pa narieiniande Yesus Nwatitin genni la puou mak kapniali id wawannu pa Namtatna la' hande. Ne riy rariahu re rtutrier lia eni wawannu. ");
INSERT INTO lex_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Noma Yesus Nnairia yawalliohora pa Nwatutu-nwaye'a la'a lira nnio'a-niatu harahu la'a riy rariahu re. Niwra: “Mak kanhyi'a-katlunni ida nla' pa nrinnia winni-hgonni la nhyi'ini. ");
INSERT INTO lex_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","La'pa nrinnia wini-hgona re dom de rtuin la talla ralamni, noma onu-ma'nu rmai pia rtotan nan momuoga. ");
INSERT INTO lex_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Dom de rtuin la watgau ralamni pa ntai tani oke' to'a. Plet pa nmor wia yoma tani mniha. ");
INSERT INTO lex_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mere la'pa lera nhit wa dewade rmakulli-rmarella pa rmat wia yoma ga'arni edonna nler plollol la tani ralamni. ");
INSERT INTO lex_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Wini-hgon de, dom de rtuin la pu'na-kiarti pa nhi'nande ruwnu-ahla rururni-karkiaratni re rmor pia natolaw wenwenna pede ta'en niana ha rmori plollola. ");
INSERT INTO lex_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mere dom pal die rtuin la tan ihi wawannu pa rpoti-rkadwua pede dom de ra'unu-rayeh nohora wo'oni rahg ida, me dom pal die terampwonema. Ne la dom pal owa'an de rawo' nana terampwotelu. ");
INSERT INTO lex_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pede ina-nara, miy hononmi mhioratreria! La'pa miy tlinmi erla de, mitlin reri!” ");
INSERT INTO lex_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nhor nioma maka Yesus ha Nwatutu-nwaye'a re rma ratiana Yesus riwra: “Ama, nihya'pa A'mu Naltier lia nhiopun lawna ralamni de A'mu Nnairia yawalliohora?” ");
INSERT INTO lex_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Noma Yesus Nakot la Niwra: “Aghi' emkade, yoma Uplerlawna edon Nal mutlialawna honona re pa rna'erit nan la' Uplerlawna tnioranni-riautnu pa emeka Ray. Mere miy die nanpena er maka Uplerlawna Nhu'ula tlinmi-nwe'er matmi totpena miat niohora la hya' ed maka riy raplin niohor ma'ta la'a Uplerlawna tnioranni-riautnu. ");
INSERT INTO lex_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yoma la' he' mak kiwra kna'erit nana de hota ra'itr owa'an la wniarorni-wnialaini pede hota nnia'eratni de narehi-nalawna. Mere la'pa riy mak kahmena kna'erit nana Uplerlawna lirni, de hya' mak enatg oleka de hota Uplerlawna Na' owa'ana. ");
INSERT INTO lex_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","La' hade pede Aniairia yawalliohora la'a nhiopun lawna gaini totpena mak kahmena rlernohora A'u, la'pa ramkek nana A hihi'u-yapya'pu ho'mana ta'en niana rna'erit nana. Ne la'pa ratlin nana A li'ru de mana raplinu-raplo' nohora. ");
INSERT INTO lex_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","La' hade de hota plola la Uplerlawna lirni maka makwohorulu-ktatrulu Yesaya nakot nohora niwra: “Hota ir e ratlin reria mere raplinu-raplo'a. Ne la'pa ramkek reria ho'mana hota edon rna'erit nana. ");
INSERT INTO lex_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Yoma ir ralma-riorni emeka ha kniukmu. Tlinni-matni mana ratniutwu. Ir rhi' emkade totpena yan ratlina, yan ramkeka, yan rna'erit nana totpena yan neka rawal mai A'u totpa hota A'g ed maka khi' ir pa rler la kalwiedni.” ");
INSERT INTO lex_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mere miy di de mliernan oleka unut lawna. Yoma rhu'ula tlinmi me rwe'er matmi pede mnia'erit nan oleka wa. ");
INSERT INTO lex_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mhioratreria, makwohorulu-ktatrulu harahu me la' walia riy doma maka khi' mak kaplol la Uplerlawna yamkekni la' ler ululu rwahak pa ramkek walia hihi'a-yapyap miak Aghi' nana, me rwahak pa ratlin wal lia' hya' ed maka Awuatut niohor di, mere A maimia'yu lerni edon ntutu-nte' ma'ta pede ta'en niana ramkeka onde ratlina.” ");
INSERT INTO lex_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pede mitlina yawalliohora la'a mak kwarinnia wini-hgona nnia'eratni. ");
INSERT INTO lex_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wini-hgona mak ktuin la talla ralamni de emeknekama riy maka katlin olek la' Uplerlawna tnioranni-riautnu mere edonna rna'erit nana. Noma hegana amlawanni nmai pia nwarui-nwate'la nana lir maka ed olek la'a hare ihranu ralamni. ");
INSERT INTO lex_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Wini-hgon mak ktuin la watwuatnu nnia'eratni de riy mak katlin nana lir kalwied de dewade leretniekla ralamni naplele'er pa nreiniana. ");
INSERT INTO lex_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Mere lir kalwied de edonna naga'ar la' ihranu ralamni pede nhi'nande edon nalo'on wali ne nwal lia hamamuamua. La'pa nler la kropanni-krieutnu, onde yamuki-yama'ala yoma la'a kot de rerieini, dewade nleretniekla nwadur la pesiayni. ");
INSERT INTO lex_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wini-hgon mak ktuin la ruwnu-ahla pu'na-kiarti, de emeknekama riy mak katlin nana lir kalwied de, mere ralamni mak kod rer lia nohkerna rororni-lailiaini, hihi'ini-yapyapni me re'a-tniaru, tototni-wudwiudni emeka nutni-ndahla lir kalwied de nhi'nande nakleh wo'a. ");
INSERT INTO lex_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ne la'pa wini-hgon maka ktuin la tan ihi, de emeknekama riy mak katlin nana kot de pa rna'erit nana dewade rlernohor reria pede mormiorni re rdella plol wawna. Riy mak katlina dom de emeknekama wini-hgon mak kawo'a liawanni pa rlernana wo'oni nti'il nana ralamni re'eni rahu ida, dom pal die terampwonema, ne la' wal diom de terampwotelu.” ");
INSERT INTO lex_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesus Nakot nohora yawalliohora id owa'an la'a nhiopun lawna id letgarni Niwra: “Ina-nara ama-hyali, la'pa Uplerlawna tnioranni-riautnu la E rimormiorni de emekwalima yawalliohor di. De la' mak kanhyi' ida, ne'era wini-hgon samomuou la'a nhyi'ini id ralamni. ");
INSERT INTO lex_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ne hota la' mela nayaplin niohora, noma mak kanhyi' de eriaini nma nrinnie'era wewnihi winni la' wutga wini-hgon maka ora nhyi' de ne'er targ oleka re wawannu, dewade nmol wua. ");
INSERT INTO lex_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Noma la'pa nte'ela lerni pa wini-hgona re rmor wia ne harni re mana rpoka-rpah'a wa, mere ramkek de, wewnihi mana rpoti-rkaduw wali. ");
INSERT INTO lex_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Dewade ora nhyi' de hopopanni-lili'irnu rmai pia rakot la riwra: “Matroma, o' edonna mtiamin neka wewnihi la o nhyi'imu, ne hya' nrei piede wewnihi e ndeha nana wetra' lawna, wini-hgon samomuou rena?” ");
INSERT INTO lex_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Noma ora nhyi' de nwalolla niwra: “A eria'yu kniarni hade.” Noma hopopanni re rakot la ora nhyi' de owa'ana riwra: “La'pa Tuna nwayow de, amla' pa mpuh dioinia wewnihi rello?” ");
INSERT INTO lex_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Mere ora nhyi'a nahmena ne niwra: “Yoma hota la'pa mimpiuh dioinia wewnihi re de hota wetra' lawna re mana hota rawniuh wiali. ");
INSERT INTO lex_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Miolin doinia la pa wewnihi nor wutga wetra' lawna re rmor wiutu totpena la'pa nte'ela lerni pa rreikia nanpena a'ukot la mak kreiki pa rwuhia wok momuoga wewnihi re ne rwatiehra totpena rhoklai la, nanpena rawok kalwiedweda wetra' lawanni re pa rkenia la dudnu.”” ");
INSERT INTO lex_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesus Nwahaur nohor owa'ana yawalliohora id la'a nhiopnu ralamni Niwra: “Itala sasawi ola ida maka rtamnia la nhyi'ini pa twahaur nohora Uplerlawna tnioranni-riautnu la E rimormiorni. ");
INSERT INTO lex_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sasawi ol de ha luwlu'wu id hade la'a ha'ola korni mak kden la nohkeran di wawannu. Mere la'pa nmori, de hota npoti-nkadwu, pa nareh niana yawuli-yatniamni re korni. Hota olli-tapalli re rpoti-rkadwu pa nhi'nande onu-ma'nu rma rapuon la'a sasaw die tutnu-akni.” ");
INSERT INTO lex_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesus Nakot nohor wal lia yawalliohora dom to'a la'a nhiopnu ralamni, Niwra: “Ina-nara ama-hyali, la'pa Uplerlawna Ntorna-nraut de emeknekama tgo' maka a'na patke'a ida na' nana pa la nawotra-nawah'a wutga la wetra' ota kilu terampwogata pa nha'ata mneneha.” ");
INSERT INTO lex_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","La' wniatutnu honona la'a rirahu re, Yesus Nnairi mamainia yawalliohora. ");
INSERT INTO lex_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Wniatutu-wniaye'a emkade naplol nohora Uplerlawna lirni maka makwohorulu-ktatrulu ida nhorat targa de: “La'pa Agora ira mpahaur de Agala yawalliohora. Ne hota A'ukot nohora la'a hya' maka riy raplin niohor ma'ta la' ler maka Uplerlawna Na'ohi-na'ara nohkerna-rai miaran di la'pa ntutu-nte'ewa la ler di.” ");
INSERT INTO lex_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nhor nioma Yesus Nhoitio'or la riy rariahu re pa nhu'ru la roma ralamni. Noma maka Yesus ha Nwatutu-nwaye'a re rmai pia rakot la riwra: “Tuna, ampak pa Mukot nohora teka yawalliohora wewnihi die nnia'eratni la' mai ami.” ");
INSERT INTO lex_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Noma Yesus Nakot la re Niwra: “Riy maka krinnie'era wini-hgon samomuou, de Rimormiori A'nani A'u inhatti. ");
INSERT INTO lex_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nhyi'a de nohkerna wawannu inhatte. Wini-hgona kalwiedweda, emeknekama Uplerlawna mutnu-rahanu. Wewnihi de riy maka klernohora hegana-kawnu ralma-riorni. ");
INSERT INTO lex_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Eriai miak ktamnia wewnihi de hegana amlawanni inhatte. Ler maka ha rreiki-rwo'ora de rtut niohora lera hohoni inhatta maka Uplerlawna Nhudi-npara rimormiori la watghudi lokarni-tatiaili lahannu. Ne la'a riy maka kreiki-kwo'ora de Uplerlawna hopopanni-lili'irnu inhatte. ");
INSERT INTO lex_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ne la'pa wewnihi maka rwuh dioin la pa rhoklai la de emekwalima hota la'a hya' ed maka Aghi'a la'a lera hohoni. ");
INSERT INTO lex_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","De hota Rimormiori A'nani A'u ghopan pa A hopopnu re rawoka-rale'ga riy maka ktot pa khi'a A mu'tu-rah'u mak Agodi plolli pa emeka Ray ida, mere plollolli de ir er maka karei pia riy rler la do'a-hala ralamni, me ir er mak khi' yatyatni-halalli. ");
INSERT INTO lex_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Hota hare honona re nekpa A hopopnu re ra'ala pa rrinnia la li'ina mak kdudmu-klairi ralamni ne la hande de tatlin nan to'a rpolpuol inni-rwakwak amni. ");
INSERT INTO lex_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mere la'pa riy mak kaplol la Uplerlawna yamkekni, de hota liplipa-kamka'ma, hitita-reprepra emeknekama lera la'a Uplerlawna, ir Amlawanni de genni maka Ntorna-nrautu emeka Ray. La' hade pede mniair tlinmi pa ma mitlina.” ");
INSERT INTO lex_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Hyal miy re, la'pa itmormior lia Uplerlawna tnioranni-riautnu ralamni de, it di de emeknekama riy ida mak kmai pia klernana re'a-tniar la tani niahi ralamni. Noma nahmena riy rlernana pede nade' owa'an re'a-tniar die la kdieldelamni. Nhorwua dewade nahepur nande nla' pa na'ol momuoga hyonni-hyanni honona na'nama nawal pia nma nawel tani nora re'a-tniar die. ");
INSERT INTO lex_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yawalliohor di mana nakot nohora la'a itmormior lia Uplerlawna tnioranni-riautnu ralamni. Lera ida mak ka'olu-kala'a ida nwahaka mutiara mak kalweli. ");
INSERT INTO lex_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","La'pa nlernana mutiara mak kalwel die noka nla' pa na'ol dioin momuoga hyonni-hyanni honona na'nama nma nawelia mutiara de.” ");
INSERT INTO lex_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Hyal miy re, itnairia tiala maka ha rrinnia la'a danau ralamni pa ta takot nohora owa'ana it mormiorni la Uplerlawna tnioranni-riautnu ralamni. Makatiala ida nrinni tialli la'a gera ralamni dewade nlernana i'na-ya'ana palmuarnia (rupni-rupni). ");
INSERT INTO lex_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","La'pa tial de npen lia i'na-ya'ana noma makatial de nwe'eta tial della keranni. Nhor nia'nama nora riy dom to'a ramtatna pa ramou-ratoha i'na-ya'ana re honona. Samomuounu de ral to'a ne yatyatni de rhopliala. ");
INSERT INTO lex_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Emkade wal lia la'pa lera hohoni ntutu-nte'ewa, de hota Uplerlawna hopopanni re rla ramou-ratoha riy yatyata la'a riy kalwiedweda mak kaplol la Uplerlawna yamkekni. ");
INSERT INTO lex_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nhor nia'nama riy yatyata re, hota Uplerlawna Nnaklia harella la'a li'ina maka klomlomra, ne la hande de tatlin nan to'a rpolpuol inni-rwakwak amni.” ");
INSERT INTO lex_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesus Natiana maka ha Nwatutu-nwaye'a re Niwra: “Dodo'ondi de, miy e mnia'erit nan nohora yawalliohora maka A'ukot nohora rina?” Noma rwahla Yesus lirni riwra: “Yowa Tuna, Ami e matga re.” ");
INSERT INTO lex_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Noma Yesus Nakot la re Niwra: “Emkade pede miy emeknekama makwatutu-kwaye'a Musa deullu-tatarni ida maka kmormior olek la Uplerlawna tnioranni-riautnu ralamni yoma nat niohora Uplerlawna wniatutnu la' ululu gahani, me nat niohor walia A wniatut warwua'ru di. Emkade pede miy die emekwalima orroma ida mak kalgota re'eni-tniarnu, de warwuarnu nor wutga gakgakamnu.” ");
INSERT INTO lex_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","La'pa Yesus Nwatia lirni la yawalliohora re honona, noma Nhoitio'or la gen die. ");
INSERT INTO lex_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Noma Nawal lia' E letni-ruhunni. La hande de, Nla' pa Nwatutu-nwaye'ela gen miaka Yahudi re rhi' kreini-iskolli la. Ne la'pa riy ratlin nana Yesus wniatutnu de, riy honona rwer rer wiawni pa riwra: “Ha Nlernana kirkira-ralma-rior samomuou (hikmat) rilla' hanmenio? Ne Ha Nlernan walia plola-mneha pa Nhi' nana hihi'a-yapyapi mak kamehi-kayona rilla' hanmeni walio? ");
INSERT INTO lex_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Itat niohora de makawte'ta-kaprahni id a'nani to'a Hade pa edonna nhal de Ha inni nwawa Maria, ne hyalli re de Yakowsi, Yusup, Simon nor Yudasa? ");
INSERT INTO lex_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ne Ha narni patke'a honona re nek de rden wal lia handi. Ne Ha Nlernan harella la' hameni ho'a?” ");
INSERT INTO lex_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","La' emkade pede honona re rwayotlia Yesus. Noma Yesus Nakot la re Niwra: “La'a makwohorulu-ktatrulu maka klol meni-meni to' mana, rira rhu'ru-rhelam la, mere hota la' letni-ruhunni me luwnu-a'nani meman nek de riy id mana edonna natlin la.” ");
INSERT INTO lex_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","La' hade pede Yesus Nhi' hihi'a-yapyapi mak kamehi-kayona ida-woru tio'ola' hande yoma irakleh pesiay. ");
INSERT INTO lex_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","La' lera-wolla re de Herodes mak kodi plolli la Galilea la'pa natlin nana Yesus hihi'ini-yapyapni ");
INSERT INTO lex_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","dewade nakot la tniutnu-nhianni-nhielli-liarni niwra: “Matialo'onama Yohansi mak kharani e inhatti! Enmati olek pa nmori owa'an pede nhi' neka hihi'a-yapyapi mak kamehi-kayona hya' to'owa.” ");
INSERT INTO lex_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Enakot emkade yoma la ler ululu la'a Yohansi nmormior ma'ta de Herodes nhopan pa rtorna Yohansi na'nama rwutga pa rla rwi'it targa la roma nhio'la ralamni. Herodes nhi' emkade yoma la'a e hawni Herodias rerieini. Yoma Herodes hawni Herodias de, de Herodes hyalli Pilipsu haw ulullu. ");
INSERT INTO lex_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Pede nhi'inde Yohansi nakot la Herodes niwra: “Yan memmemna omuora Herodias mmiehlima. Hade edon lol deulu-tatra.” ");
INSERT INTO lex_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","La'a plollolli de Herodes niwra nwenna Yohansi mere namta'at rer lia rira yoma rwarora de Yohanis de makwohorulu-ktatrulu id eda de. ");
INSERT INTO lex_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","La'pa Herodes ler kalwiedni noma Herodias a'nani patke'a nloi lia makhopnu-makpepna gaini ralamni. Lioini-nhiekni de nla' nan meman la Herodes ralamni. ");
INSERT INTO lex_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nreiniande Herodes nlokar meman la pat harara mak kloi die gaini ralamni pa niwra hota enal hya'a-hya' to'ola hararar de wakwakni. ");
INSERT INTO lex_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nla' pa natlin la inni yawewalli noma hararar de nakot la Herodes niwra: “Tuna, awuak pa mkien tio'a Yohansi makharani o'tani la totopa, pa muala mai a'u.” ");
INSERT INTO lex_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","La'pa Herodes natlin nana hararar de wakwakni dewade ralamni ntuin doin la. Mere takotpa, nlokar pa lira olek hadewa ne mak kmai pia kor wutga Herodes pa ra'an de ratlin momuoga oleka re. Herodes nhar lirni totpena rla rotan doinia Yohansi makharani die o'tani la'a roma nhio'la ralamni na'nama rkenia o'tani la totopa pa rma rtemna la hararar de limni. ");
INSERT INTO lex_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","La'pa edon nalo'on ma'ta de rken nian Yohansi o'tani la totopa ralamni pa rma ralla pat hararar de. Nhor nioma pat hararar de nodia Yohansi o'tani pa nod tiargho'a la inni. ");
INSERT INTO lex_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","La'pa maklernohor reria Yohansi makharani ratlin nana, noma rma ra'ala Yohansi inonni pa rla rhuwria. Nhor nioka rla' pa rwahaur nohor momuoga harella Yesus. ");
INSERT INTO lex_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","La'pa Yesus Natlin nana hyalli Yohansi nmati olekwa noma Nhoitio'or la' hande, ne Nmeh'a Nha'at la puou pa Nla'awa geni hgalgali ida. Mere la'pa rirahu ratlin nohora de Yesus Nhi' emkade dewade mak kwatiawua leta-ruhuna re rlidan lol keranni la eni plahwani pa rlernohora Yesus. ");
INSERT INTO lex_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","La'pa Yesus Nerun la puou pa namkek la riy rariahu re, de ralamni ntuin doin la pa Niwra Ntulan la ira. Noma Nhi' kalwieda riy mak kanieni-kahniena mak kden wut lia riy mutlialawna re. ");
INSERT INTO lex_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ne lera nheria pa mak Yesus ha Nwatutu-nwaye'a re rma rakot la Yesus riwra: “Tuna, lera nheria wa. Ne la' gen di ho'mana olieta la leta pede Mhuopan nekpa ir orgahani rla rawelia ya'ana-yemnu la'a leta-leta re.” ");
INSERT INTO lex_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mere Yesus Nahmen pa Niwra: “Pena mialla ra'ana.” ");
INSERT INTO lex_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Noma rwalolla Yesus riwra: “Tuna, a wareher mamni ri eneknek to'ama roti deulu wolima, me i'na wor tiututu.” ");
INSERT INTO lex_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesus Nakot la re: “Miod tieka mmiai!” ");
INSERT INTO lex_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nhor nia'nama Nhopan pa riy honona re ramtatn apitga la genni la' wewna wawannu. Noma Yesus Na'ala rot dieulu re wolima, me i'na rora, na'nama Nwatniar la heyanan, pa Na'uli-nawedi Uplerlawna. Na'nama Nhawi-nhawia roti re, me Nwikria i'na re noma Nala la maka ha Nwatutu-nwaye'a re pa rdurmu-rhakra la'a riy mutlialawna re honona. ");
INSERT INTO lex_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Honona re ra'an pa rpehera. Ra'an pa rwair wa, noma maka Yesus ha Nwatutu-nwaye'a re, rwaho'a-rwatierun wa de rawok nana mak ha ra'an atre'a, de kriou penpuenu termida wehrani woru. ");
INSERT INTO lex_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mak ka'an momuou lia hande, la'pa edon nhal de muanke'a riwnu wolima, me edonna rhor wut mua'ta la patke'a ror wutga upni-a'nani. ");
INSERT INTO lex_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nhor nioma Yesus Nhopan pa maka ha Nwatutu-nwaye'a re rodi puou rleretia danau pa rala' ulia ne Nhopan pa riy mutlialawna re rawal wia. ");
INSERT INTO lex_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","La'pa honona re rla'awa dewade Yesus Nha'at la wo'ora id hananni totpa Nmemeh'a Nsumbaini. Yesus Nden nek la hande pa la' pa mela ndamit nana. ");
INSERT INTO lex_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ne tamkek la puou muaka Yesus mutwualli ha rodi re nner pa ed olek la danau letgarni, ne yo'ora-anni mak klol gaini newat nana. ");
INSERT INTO lex_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","La'pa repreparreria de Yesus Nala' lola tah'i ulti wawannu pa Nla Nlernohora puou mak oliet olek la E'a. ");
INSERT INTO lex_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","La'pa ir honona la puou die ramkek tutga E maimiaini de lola tah'i ulti wawannu, dewade honona re rhedu noka ramta'at wenna. Rhaun pa riwra: “Ee! Hegan lora nmai niek ee!” ");
INSERT INTO lex_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Mere Yesus Nleretniekla Nakot la re Niwra: “Mmiolmiolmi, Yesus A'g inhatti. Yan mimta'ata.” ");
INSERT INTO lex_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Noma Petrus nakot la: “Matroma, la'pa plola pa Yesus O'a de Mhuopan pa a'ula' lola tah'i ulti pa atiy O'a!” ");
INSERT INTO lex_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Mmuai ee! Yesus A'g hadi.” Dewade Petrus nerun la puou na'nama nala' lola tah'i ulti pa nla nwatroma Yesus. ");
INSERT INTO lex_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mere la'pa Petrus namta'at wenna la anni meranni mak kten lia danau de, reiniande Petrus nhudgauriernu, ne nhaun pa niwra: “Mtiulan mai a'u Matrom ee!” ");
INSERT INTO lex_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Noma Yesus Nleretniekla Nhoi limni pa Ntoran reria na'nama niwra: “Petrusa o pesiaymu, wekwek ma'ta. Nihya'pa o ralammu worwuoru niohor A'u?!” ");
INSERT INTO lex_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Noma rrora rha'at rewre'wa la puou ne anin lawan de mana namtie'ela wa. ");
INSERT INTO lex_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Noka maka Yesus ha Nwatutu-nwaye'a re honona ra'uli-rawedia Yesus. Honona rakot la: “Plola, O' di de Uplerlawna A'nani inhatti!” ");
INSERT INTO lex_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","La' pa rleretia danau pa rte'ela danau aratni la'a leta Genesaret. ");
INSERT INTO lex_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ne la'pa makden hande ramkek tut niana mak kmai die Yesus inhatta, dewade rpo'on-rde'et nohora Yesus la leta-leta mak rehgorgoru honona re riwra: “Ee Yesus Nmai niek ee!” Noma riy harahu rawoka maka kanieni-kahniena re honona pa rodia la Yesus. ");
INSERT INTO lex_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mak kodia mak kamehra-kamau re rpolpuol inni-rwakwak amni la Yesus pa riwra: “Amee! Ampaka pa makamehra-kamau re rteman to'ola rayanmu tawnu, totpena rkalwieda!” Demade he'-he' mak kteman nan to'a rayanni tawnu re, honon rnek pa rler la kalwiedni-paitiotni. ");
INSERT INTO lex_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lera ida ne Parisi wokni id nor wutga makwatutu-kwaye'a agama re rwatiawu Yerusalem pa rma rwahaka Yesus. Noma ratian Yesus riwra: ");
INSERT INTO lex_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nihya'pa riy maka Ompuatutu-mpuaye'a re rpera-rdaitia it upni-tgarni deullu-tatarni?! Ira'an de edonna rohma ulga limni.” ");
INSERT INTO lex_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Noma Yesus Nakot la re Niwra: “Ne hya'a nrei pia miy mpiera-mdiaitia Uplerlawna lirni-tunnu, la'a mtiot nan to'a upmi-tgarmi deullu-tatarni nanpena mliernohora?! ");
INSERT INTO lex_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yoma Uplerlawna Niwra: “Mhiu'ru-mhielam la inmi-ammi,” ne “la'pa hameni nwohora-ntatra inni-amni, de hota nlernana niukum matmiati.” ");
INSERT INTO lex_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mere mpiatutu-mpiaye' de edon nhala pa riy id nakot la inni-amni niwra: “Agiwa galla miy, mere agal olek la Uplerlawna.” ");
INSERT INTO lex_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Emkade pede mhiur niohora riy de, pa hota edon na'unni-namta'ata inni-amni. La' talan emkade pede miy edon mliernohora Uplerlawna lirni de, mere mliernohor to'a miy upmi-tgarmi deullu-tatarni. ");
INSERT INTO lex_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Miy di mtiot pa mpial lia riy plollola mere plollolli de riy yatyat miy. Hota plol memna la' lir wowohorni maka Yesaya nakot nohora miy niwra: ");
INSERT INTO lex_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Emkadilla Uplerlawna lirni: Rimormiori ri eneknek to'ama ral nurnu tutnu ra rha'wa nan to' A na'nu, mere ralamni re olieta mai A'u. ");
INSERT INTO lex_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hare kniola tiernu-niawur nehlani mai A' die hamamuamua re yoma ira rwatut tio'a rimormiori wniatutnu-wniaye'eni.”” ");
INSERT INTO lex_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nhor nioma Yesus Npol lia riy rahu mak kden handi pa rma rawoka ne Nakot la re Niwra: “Mitlina totpena miatga. ");
INSERT INTO lex_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mak ita'ana edon nhi' akdieha-aktiahl ita. Eneknek to'ama yatyatni-halalli maka itakot nohora me tsi' nana. Hade ed maka khi' pa takdieha-taktiahli.” ");
INSERT INTO lex_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Noma maka Yesus ha Nwatutu-nwaye'a re rmai pia ratiana Yesus riwra: “Tuna, O e Muat niohora me edonna? Lira-tun muaka Omukota re de e nheik nana Parisi re nhiolli-lietni pa dodo'ondi de e rawenna.” ");
INSERT INTO lex_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Noma Yesus Nwahla lirni re pa Nakot la re: “Hyal miy re, yana mkienia riy Parisi rella nhioratmi. Yoma ir emolmolan nekama yawuli-yatniamin maka A A'mu makden la Ilyamou-Watyatoha limni enni atia'a, pa hota rwuh dioinia la. Ha rhi'a o'ta-mata mak ktut tialla la riy dom to'a mere, ha rmeh'a nekane e rlola melli-kalamni, yoma emeka matni re yata. Ne la'pa riy mat yata ida ntut tialan la mat yat walli, de hota rewre'wa pa rtuin la hu'ula ralamni.” ");
INSERT INTO lex_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus nakot la Yesus niwra: “Tuna, Mtiulan pa Mukot nohora yawalliohora de nnia'eratni mai ami.” ");
INSERT INTO lex_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesus Niwra: “Emkameni pede miy edonna miat mua'ta lira re nnia'eratni?! ");
INSERT INTO lex_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Miy e miplin mua'ta de mak itlumu-ttella de hota ha nla'awa it apannu ne hota nlergot owa'ana?! ");
INSERT INTO lex_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mere mak klergot lola it nurnu, de ha nwatiawua it ralamni ne hade ed maka khi' rira pa rakdieha-raktiahli. ");
INSERT INTO lex_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Yoma it ihranu ralamni ed mak kodia ralma-rior yotyota-yatyata, pa nhi'nande riy rwunu-rwenna, ralira-raliai, rkamnelu-rkamna'a, rod niana riy mak khala, la'pa rapolu-raliella rira. ");
INSERT INTO lex_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hare er maka khi' rira pa rakdieha-raktiahli ne edon riwra it edonna tohma ma'ta it limni pa ta'ana de hota nodi it la kdeha-ktiahli.” ");
INSERT INTO lex_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nhor nioma Yesus Nhoitio'or la' gen die, ne Nla'awa leta Tirus nora Sidon yapatni. ");
INSERT INTO lex_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Patke'a Kana'an ida nwatiawu hande pa nma nwahaka Yesus, ne nmai die nhaun lola niwra: “Matroma, ray Daud upni-a'nani nee, Mtiulla-msiayn nan a'g ee! A a'nu patke'a hegana e rhu'ru ralma pa nler la polpuol inni-wakwak amni.” ");
INSERT INTO lex_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mere Yesus edonna Nwahla nana patke' de lirni. Noma maka Yesus ha Nwatutu-nwaye'a re rmai pia rakot la Yesus riwra: “Tuna, Mhuopan pa patke' de nla'awa. Hade e nmemeh'a nekpa npeha retlia it to'orni di.” ");
INSERT INTO lex_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Noma Yesus Nakot la patke' de Niwra: “Uplerlawna Nhopna Amuai di, de Nhorat la riy Israel maka kler la klieratni, emeka duma ida mak kawlar dioinia matromni. A'g edon Muai lia mak Israel atia' re rerieini.” ");
INSERT INTO lex_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pat de nmai pia nwaltior la Yesus gaini ralamni na'nama niwra: “Matrom ee, Mtiulan nan mai a'u ee!” ");
INSERT INTO lex_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesus Nnairi yawalliohora pa Nakot la: “Ine! Taken niana ra'ala papay ya'anni-yemannu pa rhopliala ahu gaini, ina.” ");
INSERT INTO lex_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Noma patke' de nakot la Yesus niwra: “Plola, plola Matroma. Mere ahu mana na'an walia yamanan lu'wu mak ktuin la matromni meini nayanni.” ");
INSERT INTO lex_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Noma Yesus Nakot la patke' de Niwra: “Ina, o pesiaymu e naruri. Emkade nek la'a hya' ed maka o ralammu nwaka.” Mtatande nekpa patke' de a'nani nkalwied wa. ");
INSERT INTO lex_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Noma Yesus Nhoitio'or la gen die na'nama Nawloh nohora eni la danau Galilea. Nhor nioma Nla' pa Nha'at la wo'ora id hananni pa Namtatna. ");
INSERT INTO lex_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Riy rahu rmai pia rodia mak kala' waini-waini, mak matni kyata, mak lakni kmati, mak kaplinu kaltieri, me mak kamehra-kamau harahu wali. Rhoi tiaru-retar targa hare honona la Yesus gaini ralamni dewade Nhi' rpa rkalwied momuou. ");
INSERT INTO lex_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Riy honona makden la hande, rwer rer wiawni la'pa ramkek tutga mak kaplinu kaltieri re raltieri, mak lakni kmati me mak kala' waini-waini re rarur wia pa rala'a wa, mak matni kyata re ramkek wa, dewade mak kden hande honona ra'uli-rawedia makden Israel re Uplerlawanni. ");
INSERT INTO lex_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nhorwua noma Yesus Npol lia maka ha Nwatutu-nwaye'a re pa rma rawoka na'nama Niwra: “A ralmu ntuin doin la' rimormior miutlialawna ri. Hari e rlernohor rer A lia lera wotelu mere ha rakleha yamanna. A'g edonna ga' pua golin doin hare pa rla' de apannu rahgali. Yanhi'pa gaini rmokal lol talan letgara.” ");
INSERT INTO lex_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Noma maka ha Nwatutu-nwaye'a re ratiana: “La'a gen hgal di de hota itlernana yamanan la hanmeni, pa itala la riy mutlialawna ri ra'ana?!” ");
INSERT INTO lex_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“La'a wareher genmi, rot wo'ir erla?” Noma rakot la Yesus riwra: “Roti erla, mere eneknek wo'itu tiututu, me temtemanni i'na prowta ida-woru.” ");
INSERT INTO lex_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Noma Yesus Nhopan pa riy mutlialawna re rakpernernia la tani wawannu. ");
INSERT INTO lex_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Dewade Yesus Na'ala roti mieha re wo'itu nor wutga i'na re na'nama Na'uli-nawedia Uplerlawna. Nhor nia'nama Nhawi-nhawia re pa Nala la maka ha Nwatutu-nwaye'a re rhakre'era la rimormioria niutni-mdierna re. ");
INSERT INTO lex_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Honona re ra'an pa rpehera, na'nama maka ha Nwatutu-nwaye'a re rwaho'a-rwatierun de rlernana maka ha ra'an atre'a, de kriou penpuenu wo'itu. ");
INSERT INTO lex_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Rhor momuoga muanke' mak ka'ana re de riy riwnu wogata. Ne edonna rhor nohor ma'ta patke'a mak kor wutga upni-a'nani. ");
INSERT INTO lex_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nhorwua dewade Yesus Nhopan pa honona rawal lia' genni-tienni. Ne Yesus Nha'at la puou pa rla'awa Magadan yapatni. ");
INSERT INTO lex_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Lera ida ne riy Parisi ror wutga riy Saduki dom pa rma rtota Yesus la klieratni. Noma rhopan pa Yesus Ntutga hihi'a-yapyapi mak kamehi-kayona id totpena irat muemna de Yesus plolli-mneheni nwatiawua Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Noma Yesus Nakot la re Niwra: “La'pa lera nhi'pa ntopal la tah'i, noma miwra repar de otna edonan nturu yoma lyanti yamkekni nmera-nlairi. ");
INSERT INTO lex_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ne la' ler dom de la'pa yawyawar ma'ta demade lyanti yamkekni nmera-nlairi, mere nayawowta, de miwra hota otna ntur lia ler di, yoma lyanti nayawowta. Miatu mikwiet nana hota lera id de otna nturu me edonna, onnila mimkek la lyanti wowta-kakamni onde mounu-wahrani. Mere A wniatu'tu me hihi'a-yapyapi mak kamehi-kayona maka Aghi' nan oleka la' lera-mela ri, de ta'en niana mnia'erit nan walia. ");
INSERT INTO lex_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Adoh! Tuwu di, de rimormiori yatyata-halala mak kahmena kpesiay A'u. Mhiopan pa Aghi'a hihi'a-yapyapi mak kamehi-kayona totpena mpiesiaya. Mere hihi'a-yapyapi mak kamehi-kayona kuku' nek ho'mana, A'g edon tiutga tiy miy! Eneknek to'ama mak makwohorulu-ktatrulu Yunus ha nlernan de.” La'pa Nakot emkade dewade Nto'or ir la hande pa Nla'awa. ");
INSERT INTO lex_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","La'pa Yesus Nora maka ha Nwatutu-nwaye'a re rte'ela' danau walli, na'nama honona rheduma, yoma rhoratdoinia roti pa edonna rod wialia. ");
INSERT INTO lex_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Noma Yesus Nakot la re Niwra: “Hyalia, mhioratreria! Hota miy ererma la'a tgo'a Parisi rora Saduki.” ");
INSERT INTO lex_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","La'pa ratlin nana Yesus lirni de dewade idma nakot la ida riwra: “Nakot emkade yoma ita edonna todia roti.” ");
INSERT INTO lex_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesus Nat niohora hya' ed maka ha rakotkota pede Nakot la re: “Nihya'pa miakokan nohora roti hadamonna?! Pesiaymi edon naruri mia'ta. ");
INSERT INTO lex_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Miy ralma-riormi edonna nla' nan ma'ta?! Miy edonna mhioratnan ma'ta la' lera maka Aghawierie'er roti wolima pa Agaitiutur nana riy riwnu wolim dewade miy orgahami miwok nan korni kriou penpuenu re, maka ha ra'an atre'a?! ");
INSERT INTO lex_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Miy edonna mhioratnan walia rot mieha wo'itu maka Agala tiutria riy riwnu wogata dewade miwok rehenu de kriou penpuenu re?! ");
INSERT INTO lex_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ne la'a hya' ed mak kriei pia miy edonna mnia'erit nana A li'ru, la'a A'g edonna muakokan nohora rot miaka ha miakokan nohora re?! Mere A'ukot nohora tiy miy die, nhiorta la' temmi la' tgo' riy Parisi rora riy Saduki re.” ");
INSERT INTO lex_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesus Nakot emkadewa na'nama maka Yesus ha Nwatutu-nwaye'a re rat niohora, E edonna Ntut tiarga lir della' tgo'a maka ha rawnyah'a la roti mak kreiniande rot die nha'ata, mere Hade e ntarg hadella la'a riy Saduki rora riy Parisi wniatutnu-wniaye'eni mak kreiniande riy rahu rler la klieratni. ");
INSERT INTO lex_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesus Nor mutwualli re rla'a gen mak edon oliet la Kaisarea Pilipi. La hande noma Enatiana mutwualli mak ha Nwatutu-nwaye'a re Niwra: “Nhi'inde riy e riwra Rimormiori A'na A' die he'o?” ");
INSERT INTO lex_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Noma mutwualli re rwet la riwra: “Tuna, riy dom de riwra Yohansi makharani O'a, mak kmori owa'ana, dom de riwra makwohorulu-ktatrulu Elia. Dom de riwra makwohorulu-ktatrulu Yermia O'a onde makwohorulu-ktatrulu dom to'a.” ");
INSERT INTO lex_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Noka Yesus Natian owa'ana: “Mere A'utian tek miy. La' miy wniarormi de, A' di de he' A'u?” ");
INSERT INTO lex_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Noma Simon Petrus nwet la: “Matro'mu de, Uplerlawna-Mempulwatnu maka kden pa nodi liarni, A'nani. O' di de Ray mak kodi mormiori-lewlewna maka Uplerlawna Nano'taru (Mesias) O inhatti!” ");
INSERT INTO lex_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesus Nwahla Niwra: “Petrusa, Yunus a'nani o'a, omliernana unut lawna yoma A A'mu mak kden la Ilyamou-Watyatoha Nmeh'a nek ed maka kwe'era tiy o'a de A' di de Uplerlawna A'nani maka Nano'taru, yoma wniarora-wnialai die edon nwatiawu eti lia rimormiori nohkeran di. ");
INSERT INTO lex_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nanmu de Petrus (nnia'eratni de watu muetam kerna). A'ukot hadi totpa muatga, riy maka pesiayni naruri emekwali pesiaymu de hota rwal lia A mu'tu-rah'u. Emkade pede o' emeknekama watu maka ha rariria roma-lewu la'a wawannu totpa taken niana nlitri. Ne hota matmiati ho'mana taken niana rodi A mu'tu-rah'u re la yawa. ");
INSERT INTO lex_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Hota A'g ed maka tiemna konsi mak kwatiawua Uplerlawna lodanni-hairni la o limmu ralamni pa hya' maka omliaran la mai nohkeran di wawannu de hota Uplerlawna mak kden la Ilyamou-Watyatoha Nwayow nohora. Ne la'pa ompuayow nan hadella noha wawannu, de hota Uplerlawna Nwayow nan wali hade.” ");
INSERT INTO lex_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","La'pa Nakot emkade pa nhorwua dewade Yesus Nwagahniorta maka ha Nwatutu-nwaye'a re totpena yan memmemna rwahaur nohor E'a la'a riy, riwra E' de Ray miak kodia mormiori-lewlewna maka Uplerlawna Nano'targa. ");
INSERT INTO lex_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","La' ler de de pa nodi liarni Yesus Nwe'er doin meman la maka ha Nwatutu-nwaye'a re, de Uplerlawna ralma-riorni totpena Nla' pa hota ntutu-nte'ela Yerusalem de Entutulu-nlelewua kropna-krieutu, yamuki-yama'ala yoma la'a ina-ama Yahudi ror wutga imam-imam o'tani-matni me makwatutu-kwaye'a agama. Uplerlawna Nala pa hota rwen E'a mere hota nodia lera wotellu owa'an de Uplerlawna Namori owa'an E la matmiatni ralamni. ");
INSERT INTO lex_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Noma Petrus nheduma pa nte'la la Yesus pa rla'awa walli na'nama npolliohora Yesus pa nakot la: “Matroma, awuakwak de Uplerlawna Nter dioini-nhal doinia mak Omukot de!” ");
INSERT INTO lex_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Hya' maka Petrus rakota de edon nlernohora Uplerlawna ralma-riorni pede Yesus Nkillia Petrus na'nama Nakot la Niwra: “Eh, mlia'awa walli hega'nu ne! Yana mhi'a yawuhi-yawe'et la A'u. Petrus, la'pa mukot emkade de mliernohora hegana amlawanni pa miwra mtiot nek A lia klieratni. La'pa omiwra hota A'g edon lier la yamuki-yama'ala de wniarormu de wniarora rimormioria de. Wniaror de edonna nwatiawua Uplerlawna.” ");
INSERT INTO lex_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nhor nioma Yesus Nakot la mak ha Nwatutu-nwaye'a re Niwra: “Hyal miy re, mitlina. Riy meni mak kiwra klernohora A'u, de nhoratdoinia momuoga hya' ed maka e ralamni nod rer lia, ne nre' wut lia A' pua nler la yamuki-yama'ala onde matmiati pa emolmolan nekama nhoi wawayanni la auwlakra pa nlernohor A'u. ");
INSERT INTO lex_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yoma la'pa hameni maka edon nhoratdoinia mormiorni noh di wawannu de hota e' edon nler la mormiori-dardiari plalahwa pa nodi liarni. Mere la'pa riy maka khoratdoinia mormiorni la noh di wawannu, de hota nlernana mormiori-dardiari pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","La'pa riy mak klernana nohkeran di re'eni-tniarnu honona mere hota edonna nlernana mormiori-dardiari plalahwa pa nodi liarni, de hota re'eni-tniarnu re nodi untu hya' la' riy dena?! Nohkeran di re'eni-tniarnu honona, ta'en niana nawel niana mormiori-dardiari plalahwa de mai rimormiori ita toh! ");
INSERT INTO lex_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Hyalmi re, mial ralammi tetema pa mliernohor A'u yoma hota la' ler noha niatni de Rimormiori A'na A' die gor wutga Uplerlawna hopopanni-lili'irnu ammai die Agodia A A'mu plolli-mneheni. Hota la' ler de Amuai pia Awuahla rima-rima hihi'ini-yapyapni maka rhi' nana oleka wa. ");
INSERT INTO lex_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mhioratreria! Hota la'a miy hononmi la handi de riy dom de mak edonna rmati mia'ta mere hota ramkek ulu Rimormiori A'na A'u mak ktorna-krautia lodna-hairi maimia'yu.” ");
INSERT INTO lex_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Noma la'pa lera wonema rlardoinla noma Yesus Nodia Petrus nor Yakowsi me hyalli Yohansi pa rmeh'a rla'awa wo'or tutulu id hananni. ");
INSERT INTO lex_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","La'pa rwatniar temna Yesus de gaini to'ama. Yesus gaini emeknekama lera mak kreprepra me naniayarni liplipa-kamka'ma. ");
INSERT INTO lex_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Plin-plinnianamde maka Yesus ha Nwatutu-nwaye'a re ramkek nan walia Musa, Elia, rora Yesus rwahauru. ");
INSERT INTO lex_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Noma Petrus nakot la Yesus Niwra: “Matroma, itden la handi de samoga, pa hota Matroma Nwayowa, de a'uriria hoiwiali wotel lia handi totpena id la Matro'mu, id la Musa, ne id wal lia Elia.” ");
INSERT INTO lex_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","La'pa Petrusa naltiertier mia'ta dewade kakam lawn ida mak khita-krepra npupun nana re noka ratlin nana lira ida nwatiawua kakam de ralamni pa niwra: “A A'nu maka Asiayn memna inhatti. E' ed maka khi' nana A ralmu pa nahepru. Mitlin la E lirni.” ");
INSERT INTO lex_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","La'pa maka ha Nwatutu-nwaye'a re ratlina lir de dewade honona re rwaltiora-rwaltieman la tani wawannu yoma ramta'at wenna. ");
INSERT INTO lex_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Mere Yesus Nmai pia Nkamit la re pa Niwra: “Hyal miy re, Yan mimta'ata, mipriri!” ");
INSERT INTO lex_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","La'pa rkillia walli-walli mere edonna ramkek nana riy doma, eneknek to'ama Yesus Nmeh'a. ");
INSERT INTO lex_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","La'pa rwatiawua wo'ora pa rerun wa noma la'a talla ralamni de Yesus Nano'a re Niwra: “La' de yan memmemna mikotkot nohora hya'a maka mimkeka re la'a riy. Mpiei niekpa nte'ela lerni mak Rimormiori A'na A' die hota ramori A lia matmiati ralamni.” ");
INSERT INTO lex_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Noma maka ha Nwatutu-nwaye'a re ratiana riwra: “Hya'a nrei pia makwatutu-kwaye'a agama re e riwra hota Elia nmai ulu nampena Ray maka Uplerlawna Nano'tar pua Namori-nalewna rimormiori Nmai?” ");
INSERT INTO lex_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Noma Yesus Nakot la re Niwra: “Plola Elia nmai ulu pa nwaho'a-nwatiernia hare honona. ");
INSERT INTO lex_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mere A'ukot tar tiy miy. Elia nmai olekwa mere riy id ho'mana edonna nat niohora de, ne irlernohora ir ralam wamueheni pa rhi' yatyat e'a. Ne hota rhi'a emkade wal lia' Rimormior A'na A' pua Alier la kropna-krieutu, yamuki-yama'ala, nniahora-nniala'a.” ");
INSERT INTO lex_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Dewade maka ha Nwatutu-nwaye'a re rat niohor oleka Yesus lirni la'a Elia mak kmai olek de, de nnia'eratni Yohansi makharani. ");
INSERT INTO lex_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","La'pa Yesus Nora maka ha Nwatutu-nwaye'a re wotelu rawal pia rla rler teman la riy rariahu re, noma muanke' ida nma nwaltiora-nwaltieman la Yesus gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Nma nakot la niwra: “Tuna, Mtiulla-msiayn nan la a a'nu yoma enapiphyaya'ala. Nler la polpuol inni-wakwak amni yoma la'a hegana-kawnu nhu'ru ralma pa nhi'inde e ntuin la ai ralamni onde la' gera ralamni. ");
INSERT INTO lex_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Agodi oleka la maka A'mu ha Nwatutu-nwaye'a mere ir takeni ratowar nana (rhokar doinia).” ");
INSERT INTO lex_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Noma Yesus Nakota Niwra: “Hoi, Miy mak khi' do'a-kyap hiala me mak kakleha pesiay. Hota lera wo'ir owa'an pa Agor miy tialla me Agod niohor miy, nanpena mimpiesiay A'u?! Miodia keke'en de mmiai!” ");
INSERT INTO lex_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Dewade Yesus Nhokar doinia hegana-kawnu mak khu'ru ralma pa la' ler de meman pa keke'en de nkalwied wa. ");
INSERT INTO lex_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nhorwua dewade maka Yesus ha Nwatutu-nwaye'a re rla' pa rora Yesus rmemeh'a la' gen ida na'nama ratiana Yesus riwra: “Tuna, hya' nrei piede taken niana amhokar doinia hegana-kawun della?” ");
INSERT INTO lex_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Noma Yesus Nakot la re Niwra: “Yoma mikleh pesiay. Mhioratreria, la'pa miy pesiaymi de kuku'a emeknekama sasawi ola ida ho'mana de hota mikot la wo'or di pa nwarei genni de hota nwarei genni. Ne la'pa miy pesiaymi etla, de hya' to' mana hota miy e mhi' nana. ");
INSERT INTO lex_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Mere eneknek to'ama miy e mitahan lara me msiumbain pleini, nanpena mliernana plolli-mneheni pa mhiokar doinia hegana-kawnu mak emkadi.” ");
INSERT INTO lex_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","La'pa Yesus Nor wutga maka ha Nwatutu-nwaye'a re rawok tar lia' Galilea, noma Yesus Nakot la re Niwra: “Rimormiori A'nani A' die, hota ral A lia rimormiori limni ralamni. ");
INSERT INTO lex_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ne rwen A'u mere hota Uplerlawna Namori-nalewna owa'an A lia matmiati ralamni, la'a lera wotellu.” La'pa honona ratlin nana Yesus lirni de dewade rleretniekla ralamni rmawal doin la. ");
INSERT INTO lex_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","La'pa Yesus Nora talanwalli maka Nwatutu-nwaye'a re rte'ela leta Kapernaum noma mak kwahora krei yuranni re rmai pia ratiana Petrus riwra: “O tungkurmu de nhi'inde Nala yuranni la krei toh?!” ");
INSERT INTO lex_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Noma Petrus nwalolla: “Yopme! Nhi'inde Npairia.” La'pa Petrus nmai lia roma nayanni pa edon nakot ma'ta krei yuranni dewade Yesus Nakot la Niwra: “Petrusa, emkameni la o ralma-riormu? Hota he' ed maka ray-ray nohkeran di rhopan pa rpairi blastena? Ir mutnu-rahanu onde do'ona-dakna?” ");
INSERT INTO lex_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus niwra: “Do'ona-dakna.” Yesus Niwra: “Hade emkade demade yana itpair nek wa yoma ir mutnu-rahanu ita. ");
INSERT INTO lex_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mere totpena yanpa ralamni re ramehra (yoma it edon tpairi), pede mlia mnia'aili la danau de. Mu'ala kupan makdella i'n maka mliernan ul die wawni ralamni, ne hota mliernana dirham wogata. Kupan dirham de hota ntu'tu pa muala pa mla mpuairia itro'a yuranni la'a Uplerlawna roma kreini.” ");
INSERT INTO lex_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","La' ler de de maka Yesus ha Nwatutu-nwaye'a re rmai pia ratiana Yesus riwra: “Tuna, hota he' ed maka inponni kreh dioini la'a Uplerlawna mutnu-rahanu mak kmormior lia Uplerlawna tnioranni-riautnu ralamni?” ");
INSERT INTO lex_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Noma Yesus Npol lia keke'enku' ida na'nama Nala pa ntutrier lia ir honona gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Noma Yesus Nakot la re Niwra: “Mhioratreria, eneknek to'ama mhiernu nhiolmi-lietmi me mpiali owa'an emekneka keke'enku'a mak klol yawa, de hota miy edon mrie' wut lia Uplerlawna mutnu-rahanu re. ");
INSERT INTO lex_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hade pede he' mak katu klol yawa pa emeknekama keke'enku'a di, hota riy de ed mak karehi-kalawan la'a Uplerlawna mutnu-rahanu ralamni. ");
INSERT INTO lex_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ne la'pa he' ed mak edon katulu-kapetan inonni me nreiniana-na'nana riy mak kakleha weli emolmolan nekama keke'enku' di, onnila A rerie'yu, de emekwalima e nreinian olek A wua.” ");
INSERT INTO lex_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mere la'pa he' ed mak kariei pia riy mak kakleha weli emeknekama keke'enku' di pa edonna rpesiay owa'an mai A'u, de Uplerlawna niukamnu la' riy de nareh dioin meman la'pa riy rkohg watga werwerta id la e tiernu totpa ntepar wenna la hletan lawna. ");
INSERT INTO lex_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Inee! Hota nohkeran di nler la yatyatni-halalli yatlorni-yatra'ani yoma totota-wudwiudi yapi'u-yaga'u mak kodi riy la do'a-hala ralamni. Meman neka la totota-wudwiudi yapi'u-yaga'u honona erla, mere hota he' mak knairia hare pa ntota riy la do'a-hala ralamni, de riy de ed mak kler la yatyatni-halalli yatlorni-yatra'ani. ");
INSERT INTO lex_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","La'pa limmi-lakmi ed mak kodi miy lia do'a-hala de mdieul dioinia la pa misrala. Yanpa miodi limmi-lakmi re tetema pa rnakulta'ru la ai mormiori ralamni mak ta'eni rwarum nana. Samomuounu de miod lima-lak memehemi re pa mior tieman Uplerlawna la Ilyamou-Watyatoha. ");
INSERT INTO lex_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne la'pa miy matmi ed mak kariei pia mlier la do'a-hala ralamni de mkiopil doinia la'pa mhiopliala. Yanpa matmi rora tetema pa rnaklia miy lia ai mormiori ralamni. Samomuounu de miod nieka matmi id pa mior tieman la Ilyamou-Watyatoha.” ");
INSERT INTO lex_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hyal miy re, mitlina, yan memmemna mpiarwah'a makpesiaya A'u maka nhiolli-lietni de emeknekama keke'enku'a mak kakleha weli. Mhioratreria, yan mhi' emkade yoma Uplerlawna hopopanni-lili'irnu (malaikat) mak katiaka ira, nhi'inde rtutrier lia A A'mu Uplerlawna gaini ralamni la'a Ilyamou-Watyatoha pa rwak pa Uplerlawna Ntulan la ira. ");
INSERT INTO lex_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Me Rimormiori A'na A' die Amuai totpena A'umori-ulewna rimormiori la'a do'oni-halli ralamni. Ir emolmolan neka duma mak kawlar dioinia matromni. ");
INSERT INTO lex_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Emkameni la miy wniarormi? La'pa riy ida hanni pipdiuma rahu ida, noma ida nmolu de hota emkameni la makhuri-kwa'an de hihi'ini-yapyapni? Nahmenmen nana, nteman targa pipdiumni terampwosiewa wehrani wosiewa re la'a wo'ora pa rwahak wewna pa ra'ana, ne nla nahak memna dum memeh mak kmol die. ");
INSERT INTO lex_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne la'pa nlernana mak kmol die de plol toto' pa hota nahepur nohora dum memeh de, ne la' ler de edonna nhoratnana dum rariahu mak edonna kmolu re. ");
INSERT INTO lex_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","De hade emekwalima miy Amlawanmi mak kden la Ilyamou-Watyatoha, hota Nahmen meman pa riy rler la klieratni. Mak kakleh weli emekneka keke'enku'a re ho'mana edonna.” ");
INSERT INTO lex_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“La'pa miy mutwualmi makpesiay ida nhi'a do'a-hal tiy miy, de mlia' pa miora riy de mikot nohora do'oni-halli mak ha nhi'a, de yana riy ratga. La'pa enwayow nohora hya'a maka ha mikota la e'a, de hota miy e miple'er olekwa. ");
INSERT INTO lex_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mere la'pa edonna natlin la miy lirmi de mior owa'an riy ida onde wor pua mlia'a. Yoma la'a Puka ralamni e niwra hota riy ida onde woru rtutrier niohor miy nanpena mtiut halli de naplola. ");
INSERT INTO lex_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mere la'pa edonna nwayow nana hare lirni-tunnu demade mikot nohora halli la makpesiay wokni-le'enu. Ne la'awa hohoni pa edonna nwayow nan wal lia makpesiay wokni-le'enu, de yana miora mpiahaur wutu pa emeknekama nhi'inde miy mhi'a la mak kawoka blastena me riy mak kaplin niohora Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mhioratreria, hya' maka mliaran la nohkerna wawannu, de Uplerlawna la Ilyamou-Watyatoha ed mak kwayow nohor walia hade. Ne hya' maka mpiayow nohora la' nohkeran di de hota Uplerlawna la Ilyamou-Watyatoha Nwayow nohor walia hade. ");
INSERT INTO lex_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Totpa miatga la' nohkeran di wawannu de la'pa riy woru rna'ohma la' hadom wawannu pa rsumbain nohora, de hota A Amlawnu mak kden la Ilyamou-Watyatoha Nreiniana-na'nana sniumbain de pa hota Nwahla. ");
INSERT INTO lex_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yoma la' meni to' pa riy woru-wotelu rawok pa rkola tieru-rawur nehla la'pa rwet la A na'nu, de A'g e rie' wal lia mtatan de.” ");
INSERT INTO lex_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","La' noma Petrus nmai pia nakot la Yesus Niwra: “Matroma, la'pa a'mu-hya'lu i'nu-na'ru rhi' do'a-ryap hial nan memna re'eni wo'ir la mai a' die, noma aghoratdoinia do'oni-halli, hota aghoratdoinia do'oni-halli la'pa re'eni wo'it muemna?” ");
INSERT INTO lex_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesus Nakot la: “Edon emkade! Yoma edonna ntut tio'ola re'eni wo'itu mere lera-lera nekpa mhuoratdoinia e do'oni-halli. La'pa ntut lia re'eni terampwo'itu nti'il nana la re'eni wo'itu mana, hota mhuoratdoini e do'oni-halli la o'a. ");
INSERT INTO lex_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yoma hota la'pa Uplerlawna Ntorna-nrautu la mutnu-rahanu mormiorni, de hota emeknekama wniahauru la'a yawalliohor di. De la'pa ray ida niwra nwatetar nohora hopopanni-lili'irnu re otanni-arni. ");
INSERT INTO lex_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Demade rodia hopopna maka otanni-arni riwnu-halli. ");
INSERT INTO lex_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Mere hopopan de taken niana npairi ahorga. Pede ray die nhopan pa ra'ol dioinia hopopna-lili'ir di nor wutga hawni-a'nani nor wut wualia hyonni-hyanni totpena ra rhernia otanni-arni re. ");
INSERT INTO lex_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Noma hopopan de nuh' idma-nrama lia'ar la ray die, na'nama nwak la niwra: “Matroma, awuak lilili-mamuau tiy o'a pa muala lera-mela mai a'u totpena apuair nana a otnu-a'ru re honona.” ");
INSERT INTO lex_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Noma ray die ralamni ntuin doin nohora hopopan de wakwakni pa nhi'nande nhap dioinia hopopan de otanni-arni honona, ne nolin doinia pa nla'awa. ");
INSERT INTO lex_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","La'pa hopopan de nlergot wa, noka nwatrom nana e kniarwialli id maka na'otna dinar rahg ida la e'a. Onnila kupna oke' nmeh'a de pede nrahmia maka otan de tiernu pa nakot la: “Hoi, mpuairia otanmu re mai a'u!” ");
INSERT INTO lex_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Noma maka otan de nuh' idma-nrama lia'ar la, na'nama nwak lir la niwra: “Heiwialia, awuak lilili-mamuau tiy o'a totpena mpuei pia repra-walin nanpena agherun momuoga re.” ");
INSERT INTO lex_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mere hopopan de nwayotli kniarwialli de wakwakni pa nreiniande nla nho'la targa la roma nhio'la ralamni, pa la'pa npair dioinia otanni re honona. ");
INSERT INTO lex_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Mere la'pa hopopan de kniarwialli dom wal pia ramkek nana hihi'a-yapyap die, de ralamni rtuin doin la pa nreiniande rla rakot momuoga la'a ray. ");
INSERT INTO lex_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Noma ray nhopan pa rpolga hopopan maka yatyata-halal de na'nama nakot la niwra: “Hoi riy yatya'tu ne, ompuak lir mai a' puede agal o' pa yana mpuairia otanmu re. ");
INSERT INTO lex_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mere o ralammu edonna nolin doin nohora o kniarwialmu de wakwakni tiy o'a pa emekwalima aghi'a tiy o' de?!” ");
INSERT INTO lex_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pa reiniande ray die nahankerna, pa nhopan pa rken tiargho'a hopopan ralam yatyat della roma nhio'la ralamni totpena mak katiaka roma nhio'la ramuki-rama'ala pa la'pa npair nana momuoga otanni-arni honona. ");
INSERT INTO lex_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pede hyalmi re mitlina! Hota hya' maka ray die nhi'a la hopopan ralam yatyat de, emekwalia A A'mu makden la Ilyamou-Watyatoha hihi'ini-yapyapni tiy miy, la'pa miy edon mhioratdoinia rimormior wialmi do'oni-halli tiy miy.” ");
INSERT INTO lex_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","La'pa Yesus Nwahaur nohor momuoga hare honona noma Nwatitin la Galilea yapatni pa Nla'awa Yudea yapatni la' gerlawna Yordan walli. ");
INSERT INTO lex_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Riy rahu rlernohora reria Yesus pede Yesus Nhi' kalwieda ir la nnienni-nhienni. ");
INSERT INTO lex_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Noma riy Parisi rmai lia hande pa rtota-rwudia. Ratiana Yesus riwra: “Tuna, it agamni deullu-tatarni niwra riy rhopliala hawni patke'a de rlernohora neka ir ralma-rior wamueheni?” ");
INSERT INTO lex_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Noma Yesus Nakot la re Niwra: “Hoi, miy edonna mpiaik nan ma'ta la Puka ralamni de enakot nohora la' ler maka Uplerlawna Nakoki-nayapi nohkerna?! E ed maka khi'a-kyap niana rimormiori, de muanke'a nora patke'a. ");
INSERT INTO lex_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","E rhorat targa Uplerlawna lirni la' Puka ralamni de Niwra: “La hade pede hota a'na muanke'a ida naltarga inni-amni pa la nora hawni patke'a rla' wutg ida totpa rla' ihyida-ralmida.” ");
INSERT INTO lex_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nhi'nande hare de riy worg atia'a, mere riy id to'a. La hade pede la'a patke'a rora muanke'a maka Uplerlawna Nwatiehra oleka, de yan memmemna riy ida ntota pa nreiyapie'era.” ");
INSERT INTO lex_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Noma riy Parisi re ratian owa'ana riwra: “Tuna, la'pa emkade, de hya'a ed mak krei piede Musa nhopan pa tala horta yapie'era la hawa patke'a maka it tahmen doinia la?” ");
INSERT INTO lex_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Noma Yesus Nakot la re Niwra: “Musa nhur niohora pa mihmen doinia miy patke'emi yoma miy o'ta tehrami lawan rehia. Mere Uplerlawna ralma-riorni la' ululu, mak Enakoki-nayapi nohkerna de ematia'a hade. ");
INSERT INTO lex_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mitlin A li'ru ri, muanke'a ida hawni edonna nalira-naliai, de muanke' de nakleha tnikilgeni pia nhopliala patke' de. Mere la'pa patke' de edon nalira-naliai, noma muanke' de nhopliala hawni pa nla nora patke'a id owa'an rmehlima, de emeknekama nalira-naliai lia Uplerlawna yamkekni.” ");
INSERT INTO lex_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","La' noma maka Yesus ha Nwatutu-nwaye'a re riwra: “Matroma la'pa hota emkade, yana tmehlim nek wa.” ");
INSERT INTO lex_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Noma Yesus Nwahla lirni re Niwra: “Hota riy liawanni nekane edonna rwayow nohora miy wniarormi-wnialaimi de. Eneknek to'ama riy maka Uplerlawna Nal ruri-lai lia de pa yan rmehlima (me la'pa edon rmehlima edon ralira-raliai wiali). ");
INSERT INTO lex_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Yoma la' riy doma, de edonna rmehlima, yoma ha niod miemna hade la inni apannu ralamni. La' dom pal die edonna rmehlima, yoma riy doma to'a rerieini. Ne dom pal die orgahi rahmena rmehlima, totpena yana nodia yawuhi-yawe'eta la ira kniarni la Uplerlawna mak kodia riy totpena rla' Uplerlawna mutnu-rahanu mak Enodi plolli la pa emeka ir Rayni. Pede riy maka Uplerlawna Nala ruri-lai lia de pa yana rmehlima, ir er maka kreiniana-ka'nana miy wniarormi de.” ");
INSERT INTO lex_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Riy rmai die rodia keke'enku'a la' Yesus totpena Yesus Nran limni la ir wawannu pa Nwak la Uplerlawna pa na Nhilpai-nmanatga re. Mere maka Yesus ha Nwatutu-nwaye'a re rawenan la mak kodia upa-a'na re. ");
INSERT INTO lex_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mere Yesus Nakot la maka ha Nwatutu re Niwra: “Miolin doinia keke'enku'a re pa rmai A' die. Yana mpiayotlia re, yoma riy mak edon katulu-kapetna inonni mere plet pa rpesiay pia emeknekama keke'enku'a re er maka Uplerlawna Nwaliria pa rler teman la riy mak kmormior lia E tnioranni-riautnu ralamni.” ");
INSERT INTO lex_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Noma Yesus Nran limni la keke'enku'a re o'tani wawannu pa Nhilpai-nmanatga re, nhor nia'nama Nwatitin la gen die. ");
INSERT INTO lex_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","La' lera ida ne tuwari ida nmai pia natiana Yesus Niwra: “Am tungkurga, ilu-wniehwa samomuou hya' ed maka hota aghi'a totpena aliernana mormiori-dardiaria plalahwa pa nodi liarni?” ");
INSERT INTO lex_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Noma Yesus Nakot la Niwra: “Hya'a nrei piede o ma mutian nohora A' di la hya' mak samoga? Mutlina, mak plollol pa samomuou die enekneka Uplerlawna Nmemeh'a to'a. La'pa omuiwra mlier la mormiori plalahwa de mliernohora deulu-tatra maka Uplerlawna ha Nakotkota.” ");
INSERT INTO lex_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Noma riy de natiana: “Deulu-tatra meni ed maka hota aliernohor reria?” Noma Yesus Nakot la Niwra: “Yana mpunu-mpuenna, yana mulira-muliai, yana mkiamnelu-mkiamna'a, yana muod niana riy mak khala, ");
INSERT INTO lex_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","muatu mu'unni-mumta'ata inmu-ammu, me muatu mtiulla-msiayni mura'a-mupal walia rimormior wialmu pa emekwalima mumkek rer lia inon wamuehemu.” ");
INSERT INTO lex_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Noma tuwar die nwalolla Yesus pa niwra: “Tuna, maka Mukot taru honona de, a'g e liernohor momuog oleka re. Ne hya' owa'ana ed maka a'g edon ghi' ma'ta?” ");
INSERT INTO lex_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Noma Yesus Nakot la: “La'pa omuiwra mlia' riy plollola-plele'er la Uplerlawna yamkekni, de mlia' pa mu'ol dioin momuoga re'emu-tniarmu re honona, pa muala welli kupna-kai la'a riy mak kakleha-kaplara, a'na ri'ini patyatni, ne hota omliernana re'a-tniaru la Ilyamou-Watyatoha. Mhi' hare honona nanpena ma mliernohor reri A'u.” ");
INSERT INTO lex_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","La'pa tuwar die natlin nana lira-tunu re dewade nla'awa de ralamni nmolu-nhelam doin la, yoma re'eni-tniarnu harahu rehia. ");
INSERT INTO lex_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yesus Nhar lirni la maka ha Nwatutu-nwaye'a re Niwra: “Mhioratreria, hota riy makre'a-maktaru riwra rre' teman la Uplerlawna mutnu-rahanu, de rler la yawuhi-yawe'et lawna. ");
INSERT INTO lex_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mitlina, riy maka kre'a-ktaru mak kiwa rre' teman la Uplerlawna mutnu-rahanu mak Enodi plolli la emeka Ray, de hota emeknekama hayori lawna niwra nlola nhior lawra hu'ulli, mere taken niana.” ");
INSERT INTO lex_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","La'pa maka Yesus ha Nwatutu-nwaye'a re ratlin nana Yesus lirni-tunnu re dewade honona rwer rer wiawni. Noma rakot la: “La'pa makre'a-ktaru re ta'en niana rla' Uplerlawna mutnu-rahanu de hota he' ed maka klernana mormiori-dardiari plalahwa de ho'a?” ");
INSERT INTO lex_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesus Namkek la honona na'nama Nakot la Niwra: “Ta'en niana rimormiori ramori-ralewna inonni. Mere Uplerlawna Nodi plolli pa Namori-nalewna ira, yoma Uplerlawna plolli-mneheni etla pa Nhi' nana-nyap niana hare honona.” ");
INSERT INTO lex_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Noma Petrus nhar lirni pa nakot la Yesus Niwra: “Matroma, a hononam di de ami e mto'or momuou lia haneknek wawannu pa ami e mlernohor O'a. Ne hota hya' ed maka amlernana?” ");
INSERT INTO lex_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesus Nwahla lirni re Niwra: “Mpiesiaya, hota la'a noh warwuar die Rimormiori A'nani A' die hota ed maka kaliwna la mtatangeni mak kamrehi-kamda'ar nohora liplipni-kamka'mani me la' ler de hota miy maklernohor reri A' muana mimtatan la ray liwangeni termida wehrani woru re hananni, totpena miodi plolli la Israel luwnu-a'nani termida wehrani woru re. ");
INSERT INTO lex_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ne la' pa he' ed mak kaltarga romni, nor wutga hawni-a'nani inni-amni inni-narni onde nhyi'ini, yoma la' A rerie'yu de hota riy de nlernan owa'ana rahu ida tni'illi. Ne hota nlernan walia mormiori-dardiari plalahwa pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Mere hota riy mutlialawna mak kla' orkotkota-ornanana onde mak kre'a-ktaru hota rtawli'iru ne mak kakleh weli onde mak edon kre'a-ktaru hota rala' ul tiargho'a.” ");
INSERT INTO lex_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Uplerlawna hihi'ini-yapyapni la E mutnu-rahanu mak Enodi plolli la pa emeka Ray, de hota emeknekama lira yawalliohor di. De or nhyi' ida, la'pa yawyawar ma'ta de, la' pa nla nahaka riy mak kar lia nhyi'ini-tlunanni. ");
INSERT INTO lex_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nla' pa nlernana riy mak kari, de net mieman la siewni-kaini dinar ida emeka nhi'inde riy rlernana la lera ida, ne rrana kniari la' ler de memna. ");
INSERT INTO lex_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","La'pa riy e rtepartarlia kniari la ler panpahna, mere ora nhyi'a-tlun de nla pa namkek de mak kakleha kniari dom de e rtepartarlia yahe'i la ya'olgeni. ");
INSERT INTO lex_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Noma nakot la: “Oi, mai pia mlia mkiar lia a nhyi'a-tlunnu. Pena agala siepmi-kaimi de lol talanni.” ");
INSERT INTO lex_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Noma rlernohora pa rla'awa. La'pa lera nwawuau ro'onni (jam 12) noma ora nhyi' de nlergot pa npolg owa'an riy dom pa rma rkar lia nhyi'ini. Ne la'pa lera nhierni (jam 3) nhi' owa'an emkade. ");
INSERT INTO lex_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","La'pa la'awa lera nher wiarta (jam 5) nhi' owa'an emkade pa nla namkek de riy doma e rmeh'a raheiye'eya. Noma natiana re: “Oi, hya'a nrei pia la' ler lawan di de miy edon mkiari mere mtiutrier niek wa?” ");
INSERT INTO lex_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Noma mak kmeh'a katuttutrieri re rwalolla riwra: “Ami edonna mlernana kniari.” “Oi! La'pa emkade, de mai pia mlia mkiar lia a nhyi'a-tlunnu.” ");
INSERT INTO lex_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nla' pa lera nmella wa (jam 6) noma or nhyi' de nakot la mak kodia mat la kniar die niwra: “Muwoka mak kari re pa mpuairia rima-rima siewni-kaini, de mpuau ulia la mak na'nama kar lia lera nhierni de, pa lorlor la mak kar lia yawyawra re honona.” ");
INSERT INTO lex_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Noma mak kar lia lera nhierni re rala' ul pua rma ra'ala dinar ida (de kupna-kaini la' ler id gahani). ");
INSERT INTO lex_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lala'pa nhorwua noma mak kar lia yawyawra re rmai pia ra' walia kaini. Irwarora de ir rrana kniari la yawyawar ma'ta pede hota ir siewni-kaini re rarehelia mak na'nama kma kari re. Yah! Neknanama ha rlernan to'a kupna emekwali maka na'nama kari re. ");
INSERT INTO lex_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Rla' pa ra'ala kupna re, de ha raltier yat la'a ora nhyi'-tlunni de. ");
INSERT INTO lex_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Mak kar lia yawyawra re riwra: “Hya'a nrei pia mak na'nama kar lia lera nhierni re rkar nian toto'a lera ho'ke'eni nmeh'a mere am die amkar lia ler pahna matmiat liawan de, ne a papiair mamni ramneneha?” ");
INSERT INTO lex_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Noma ora nhyi' de nwalolla riy id la ira niwra: “Harya, a'g edonna ghal nohora o'a. Yoma dodo'ona itwatetar la o kaimu de kupna dinar ida mere o' edonna mpuayotlia toh! ");
INSERT INTO lex_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mua' nek la kaimu di pa mlia'a nek wa. A ralmu naplele'er pa agala mak na'nama kari re kaini, de ror miy ramneneha. ");
INSERT INTO lex_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hya' ed mak krei pia taken niana age'era-ghakra a re'u-tniar wamueh'u?! Yanpa la' o wniarormu de yana aghi'a ralam kalwied la rira?!”” ");
INSERT INTO lex_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesus Nwat lirni de pa Niwra: “Pede miy miak katlin la yawalliohor di mhioratreria! Emeknekama mak kar lia' lera nhierni rlernana siewa-kaini ulu, emkade walia riy mak ktawli'iru hota rwal lia' mak kala' ulu, me mak kala' ulu rwal tiargho'ola mak ktawli'iru.” ");
INSERT INTO lex_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","La' lera ida pa Yesus Niwa Nla'awa la Yerusalem, noma Nden nek la talan letgar pa Npolg awoka maka ha Nwatutu-nwaye'a riy termida wehrani woru pa rmeh'a la' gen ida na'nama Nakot la Niwra: ");
INSERT INTO lex_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mitlina! Dodo'ondi de itsortut niana Yerusalem. Hota la hande de ra'ol Rimormiori A'na A' die la imam-imam o'tani-matni me la' walia makwatutu-kwaye'a agama pa ra'anlira-remunwawa pa hota ha rukum pen A'u. ");
INSERT INTO lex_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nhor niampena ral A lia riy maka Yahudi atia'a. Hota rhi' A lia hamalmialia, me rliwra-rkaklia A'u na'nama rla rwairi A lia auwlakar hananni pa Alier la matmiati-molmuol die. Mere hota la'pa lera nodia wotellu de hota Uplerlawna Namori-nalewan owa'an A lia matmiati ralamni.” ");
INSERT INTO lex_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nhor nioma Sebedeus patke'eni nor wutga upni-a'nani, Yakowsi nor Yohansi, rmai Yesus de. Noma pat de nler la Yesus gaini ralamni na'nama nwaltior la gaini pa npolu-nwak la. ");
INSERT INTO lex_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesus Natiana: “Ompuaka hya'a ine?” Noma pat de nwahla lirni niwra: “Amee, awuak de la'pa Omlia' Ray de a a'nu rora ramtatna pa rhapetre'ru la'a O liwangenmu de totpa amlernan wali ya'uli-yawedi.” ");
INSERT INTO lex_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesus Nakot la pat de a'nani rora Niwra: “Miy miplin niohora miy wakwakmi de. Hota miy di de mpiaran pia mitahan nana kropna-krieutu nniahora-nniala'a maka Aliernan dena?” Noma rwahla Yesus yatianni de riwra: “Hota amtahan nana.” ");
INSERT INTO lex_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesus Nakot la re Niwra: “Plola hota mlier la kropna-krieutu maka Aliernan de mere hota la'pa mak kamtatan la A wa'lu malwiru-malganna pa rhapet reri A' die, A'g edonna godi plolli pa wuet la riy meni ed mak kamtatan la gen die. La' geni-tiena re, de A A'mu nanpena ed mak kodi plolli pa Entutg he' ed mak kamtatan la. Ne Enwalir nian oleka hare la' ululu.” ");
INSERT INTO lex_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","La'pa riy mak ha Nwatutu-nwaye'a re korni riy termida re ratlin Yakowsi nora Yohansi wakwakni de ralamni ramehra la riy maroro'a mak kwahyali re. ");
INSERT INTO lex_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hade pede Yesus Npolg awoka momuoga honona na'nama Nakot la Niwra: “Hyal miy re, miatg oleka de o'ta-mat lalawna me mak klernana gen tiutullu maka kodi plolli la' luwu-a'na mak raplin niohora Uplerlawna, de rtern apitga limni-rorni. ");
INSERT INTO lex_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yana mhi'a nhioli-liet mak emkare. Mpialdioinia de, la'pa he' mak kiwra klernana gen tiutullu, talanni, de nhoi-ntania rimormior wialli pa emeknekama hopopna ida nhoi-ntania matromni. ");
INSERT INTO lex_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ne la riy mak kiwra kala' ul miy, de nwahyar tialan pa makpesiay wialli rlola pa emolmolan nekama ata-wa'ara ida nhi'a la matromni. ");
INSERT INTO lex_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pa emekwalima Rimormiori A'na A' wuali. Yoma Amuai die, A wniaro'ru de totpa edonna rhoi-rtani A'u, mere Amuai die ghoi-tiania rimormiori, me gal ino'nu emeka tniuwu-nhiaiya pa A'ulewna rimormiori harahu mak kwatiawua hairi-hairi honona.” ");
INSERT INTO lex_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","La'pa Yesus Nor maka ha Nwatutu-nwaye'a re rwatitin la Yeriko de riy harahu rlernohor reria. ");
INSERT INTO lex_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mere riy woru mak matni kyata ramtatna la talan lawna aratni. La'pa ratlin nan tutga de Yesus e Nlola hande dewade rrora rhaun pa riwra: “Matrome, Ray Daud upni-a'nani ne! Mtiulla-msiayn nan mai ami ee!” ");
INSERT INTO lex_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Riy mutlialawan makden la hande rawenan la riy maroro'a re riwra: “Hoi! Mmiolmiolmi!” Mere riy mat yata rora yeher to'ama rarur lia nhiaunu pa riwra: “Matroma, Ray Daud upni-a'nani ne! Mtiulan-msiayn nan mai ami ee!” ");
INSERT INTO lex_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Noma Yesus Ntut tiaru na'nama Npol lia mak matni kyata re pa Natiana re Niwra: “Hya' ed maka mpiaka mai A'u?” ");
INSERT INTO lex_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Noma rrora rwahla Yesus lirni riwra: “Matrome, amiwra mamkek owa'ana!” ");
INSERT INTO lex_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesus ralamni ntuin doin la' irrora yamkekni dewade Nteman la rrora matni pa mtatan de nekpa matni re raphyar wia. Noma rlernohor Yesus pa rla'awa. ");
INSERT INTO lex_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","La'pa Yesus Nora maka ha Nwatutu-nwaye'a re rhi' pa rwakriania Yerusalem noma rlola Betfagi la'a wo'ora Saitun hananni. Noma Yesus Nhopan pa maka ha Nwatutu-nwaye'a riy woru rala' ulu ");
INSERT INTO lex_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","pua rla'a let maka ir rwakrian olek de. Yesus Nano'a re Niwra: “Hota la' de mimkek nan memna keledai ida e naknioh wut lia a'nani. Mlia' pa mlieretniekla miewar doinia pa miodi mmiai. ");
INSERT INTO lex_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","La'pa riy ida npolliohor miy, de mikot la miwra: “Itmatromlawanni e Nwaka (perlu).” Ne hota riy de edonna nakotkot hadom la'a keledai re wawannu mere plet pa nollia pa miodi mmiai.” ");
INSERT INTO lex_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","La hade de hota ntuin tar lia makwohorulu-ktatrulu lirni niwra: ");
INSERT INTO lex_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mikot nohora harella Sion mniotni miwra: “Mimkek ee! Hota Raymi e Nmai die, Entutga yehwa mnapnapla me nhiu'ru-nhielma pa Nha' nan to'a keledai a'na ida.”” ");
INSERT INTO lex_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nhor nioma talanwalli rora re rla'awa pa rhi'a hya' ed maka Yesus Nakota re. ");
INSERT INTO lex_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","La'pa rmai die rodia keledai de nor wutga a'nani de rewre'wa. Noma irrora ral walia rain plalahwani re ra rwowa keledai a'na to'orni totpena Yesus Nha'a nana. ");
INSERT INTO lex_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Riy harahu la mutlialawna re rtutga nhiu'ru-nhielma la'a rala naniair plalahwa ra rwowa la' talla, me korni rtuhia ora tawi-au tiawi motmota pa ra re'era la talla, totpena keledai re rlola wawannu. ");
INSERT INTO lex_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Riy rahu re la'pa rlol gaini me mak ktawli'iru pa rletgar nana Yesus. Ne rhaunu-rhaun pa riwra: “Ya'uli-yawedi nden rer tiy O' ee! Ray Daud upni-a'nani maka Uplerlawna Nano'taru die! Ta'uli-tawedia tsu'ru-tselma O mak kmai pia kodia Orgahi-Orha'a nanni. Ta'uli-tawedi, tlilili-tmamuau Uplerlawna la tutullu-lolo'oni!” ");
INSERT INTO lex_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","La'pa Yesus Nler la leta Yerusalem ralamni dewade let de nler la kokokna-rariarin lawna. Leta Yerusalem mniotni riwra: “He'a di?” ");
INSERT INTO lex_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Riy rahu mak kor Yesus talan pa rmai re rwalolla riwra: “Yesus makwohorulu-ktatrulu inhatta, Nwatiawua leta Nasaret la' Galilea yapatni oo!” ");
INSERT INTO lex_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nhorwua noma Yesus Nla'awa Uplerlawna roma kreini herni-gaini pa Nhokra-nlaiya mak ka'olu-kala'a kaweli-kaphar la hande. Nte'la la mei-kader maka ha rwahernia kupna me mak ha ra'olu-rala'a ma'nu loktieru, pa Nkowa-nwalia. ");
INSERT INTO lex_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na'nama Nakot la mak ka'olu-kala'a kaweli-kaphara re Niwra: “E rhorat targ olek la Puka ralamni Uplerlawna lirni de Niwra: “Hota rweta A ro'mu de roma sniumbain geni de, mere miy mhi'a la roma kamnelu-kamna' geni!”” ");
INSERT INTO lex_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Dewade riy maka matni kyata ror wutga maka lakni ktu'u-kwaini, rma rahaka Yesus la'a roma-krei. Ne Yesus Nhi' honona rpa rler la kalwiedni. ");
INSERT INTO lex_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Mere imam re o'tani-matni rora makwatutu-kwaye'a agama deullu-tatarni re ralamni ramehra la Yesus hi'ini-yapyapni mak kamehi-kayona maka khi' kalwieda mak kamehra re. Ne rahankeran wal lia keke'enku'a re riarni-riarin la'a krei herni-gaini pa riwra: “Mmuori-mdiari ray Daud duratni nee!” ");
INSERT INTO lex_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Noma ratiana Yesus riwra: “Omutlin oleka lir maka ha rakota rena?” Yesus Nakot la re: “Yowa, A'g e utlin wal lia. Oi, miy edonna mpiaik nan ma'ta harella' Puka ralamni?! De e rakot nohora Uplerlawna lirni mak Eniwra: Enwatutg oleka upa-a'na lokmera-papay re pa rat niohora ra'uli-rawedi E'a.” ");
INSERT INTO lex_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nhor nioma Yesus Nhoitio'or la hare pa Nlergot la letlawna Yerusalem pa Nokria leta Betania me Nanin tar lia hande. ");
INSERT INTO lex_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","La'pa repar yawyawar noma Yesus Nor mutwualli re rawal lia letlawna Yerusalem, ne Yesus Naplar oleka wa. ");
INSERT INTO lex_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Noma Namkek nana kar ona id la' talla aratni, noma Nla Nwahak wo'oni pa Na'ana, mere kar on de nakleh wo'a. Mere tawni mamaini. Noma Yesus Nhar lirni la kar on de Niwra: “Dodo'ondi mkieran wa pa hota omukleh wo' owa'an wa!” Noma kar on de nleretniekla napliau lia genni. ");
INSERT INTO lex_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","La'pa mak Yesus ha Nwatutu-nwaye'a re ramkek hade noma honona re rwer rer wiawni. Noma ratiana: “Hya'a nrei pia kar on de nleretniekla nmat wia?” ");
INSERT INTO lex_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesus Niwra: “Mhioratreria, la'pa miy pesiaymi edonna nwalera de hota miy niek de mhi' walia hya' maka Aghi' oleka la'a kar on de. Ne hota hade edonna nmeh'a mere la'pa mikot to'ola wo'or di pa nwarei lia tah'i lawna hota narinni la' tah'i lawna ralamni. ");
INSERT INTO lex_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Hya' to' pa mimpiaka la'a miy sniumbainmi de hota mimliernana, hornama pesiaymi yana nwalera.” ");
INSERT INTO lex_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","La' noma Yesus Nawali owa'an la Uplerlawna roma kreini pa Nwatutu-nwaye'a. La'pa Ntepartarlia wniatutu-wniaye'a, dewade imam-imam o'tani-matni re ror wutga Yahudi in letni-am letni rmai pia ratiana Yesus riwra: “Tuna, he' ed mak ktemna plola-mneh della O limmu ralamni pede Omhi' nan hihi'imu-yapyapmu rena?” ");
INSERT INTO lex_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Noma Yesus Nwahla lirni re Niwra: “A'g e giwra utian tek wali miy, la'pa mimpiet nana, de hota Awuahla miy la'a he'a plolli pede Aghi'a hihi'a-yapyapi re. ");
INSERT INTO lex_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pede A'utian tek miy, de hota Yohansi makharani de ha nlernana plol della he'a? Uplerlawna onde rimormiori?” Dewade honona re rwahu'ru ralma-riora wamueh'a pa riwra: “La'pa itwet la Uplerlawna ed mak kala plolli la Yohansi de hota Eniwra: “Ne hya'a nrei pia miy edonna mpiesiay e'a?” ");
INSERT INTO lex_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mere la'pa it twet la tiwra: “Rimormiori plolli-mneheni hade,” de hota itamta'at rer lia rirahu yoma honona rpesiaya de Yohansi de makwohorulu-ktatrulu id hade.” ");
INSERT INTO lex_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pede honona rla' lir id pa rwahla Yesus riwra: “Ami e maplinga.” Noma Yesus Nakot la re Niwra: “Hade emkade de hota A' muana, edonna ukot wahyaria tiy miy la'a he'a mak kala plolli mai A' pua Aghi' hihi'a-yapyapi re.” ");
INSERT INTO lex_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Noma Yesus Nakot owa'an la o'ta-mata re Niwra: “Dodo'ondi de A'utian teka miy ralma-riormi la lira yawalliohor mak A'ukot di. De la' lera id pa muanke'a ida a'nani muanke'a riy woru. Noma muanke' de nla nakot la a'nani yanulu niwra: “Ama, mlia mkiar lia nhyi'a-tlunni ralamni la ler di.” ");
INSERT INTO lex_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Noma a'nani yanul die nahmena mere nwaror owa'ana, noma nla'a nhyi'-tlunni de ralamni. ");
INSERT INTO lex_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nhor nioma muanke' de nla nakot wal lia a'nani gari de emkade wali. Noma a'nani gar die nwayowa mere hota edonna nla'a. ");
INSERT INTO lex_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Noma la'a keke'enku'a rora de he' ed maka klernohora amni nhiopanni?” Noma rwet la riwra: “A'na yanulu.” Dewade Yesus Nakot la ir honona Niwra: “Mpiesiaya, hota riy mak kawoka blastena, ror patke' yatyata, rala' ul miy pia rler wut lia Uplerlawna mutnu-rahanu mak Enodi plolli la pa emeka Ray. ");
INSERT INTO lex_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yoma Yohansi makharan die nmai pia nwatutu-nwaye' miy lia hya' mak kaplol la Uplerlawna yamkekni mere miy (emolmolan nekama a'na gari la'a yawalliohor de pa) edonna mliernohora Yohansi wniatutnu-wniaye'eni. Mere mak kawok blastena rora patke' yatyata rpesiaya me rlernohora Yohansi wniatutnu-wniaye'eni. Ne mimkek walia hare rhern oleka nhiolli mere miy ralammi edon nakwali et pia mliernohora Yohansi lirni de.” ");
INSERT INTO lex_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Noma Yesus Nakot owa'an la ira: “Mitlina yawalliohora id owa'an hadi. Ornoha ida nawuli-natniamin anggur wo'a la nhyi'ini-tlunanni ralamni. Nteman riwta la nhyi' de walli-walli. Ne nahia hu'ula maka rahmi anggur turnu la ralamni. Nhor nia'nama nariria yatiak geni. Nwahi'a pa nhorwua noma nala nhyi'-tlunni anggur della riy rtimnia. Ne nla nalaun la riy ornoha. ");
INSERT INTO lex_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","La'pa lerni nwakrian wia pa riwra rreiki-rwo'or wa, dewade ora nhyi' de nhopna hopopanni-lili'irnu re pa rmai pia ra'ala e nhiakarni la timanni-daharni. ");
INSERT INTO lex_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mere maktimni-kdahara re rwaldioin targho' pa rtorna ora nhyi'a hopopanni-lili'irnu re. Rwanalga riy ida, me rwenan nan ida. Ne rala watu ra rwatliewur wen id wali. ");
INSERT INTO lex_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Noma ora nhyi' de nhopn owa'ana hopopanni-lili'irnu dom owa'ana, de narehia mak kala' ulu re. Mere mak ktimni-kdahara re rhokra-rlai rwunu-rwen owa'ana. ");
INSERT INTO lex_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hohoni dewade ora nhyi'-tlun de nhopna e a'nani yoma la'a wniarorni de: “Matialo'onamde ha rhu'ru-rhelma a a'nu.” ");
INSERT INTO lex_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mere la'pa ramkek tut niana ora nhyi'-tlunni a'nani dewade idma nakot la ida riwra: “Maka hota kodi plolli la ononni e inhatti! Mai pia itatuinia aranni totpena itlernana nhyi'a-tlunan di!” ");
INSERT INTO lex_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dewade rtorna riy de pa rnaklia la nhyi' de to'orni na'nama rwenna.” ");
INSERT INTO lex_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Noma Yesus Natiana o'ta-mata re Niwra: “La'pa hota ora nhyi' de nawal lia hande de hota nhi'a hya'a la maktimni-makdahara reno?” ");
INSERT INTO lex_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Noma rwah'a lirni riwra: “Tuna, hota ora nhyi' de nwunu-nwenna riy yatyata-halala re pa ir matmiatni nhi' it pa tamta'ata, ne nla nal targho'a nhyi'ini-tlunanni della riy dom to' pa rtimni-rdahar samomuoga pa rala ora nhyi' de nhiakarni la timanni-daharni.” ");
INSERT INTO lex_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Noma Yesus Nakot la re: “Miy edonna mpiaik ma'ta la maka rhorat targa la Puka ralamni (la'a wat muaka ha rtot nohora la Ray Makamori-Kalewna maka Uplerlawna Nano'tar dena)? De niwra: “Wat muaka tukna edonna rnair nana pa rhi'a roma-lewu, mere rhopliala, de Uplerlawna Nnairi oleka pa Nhi'a la watu liar pianulu. Hadi ed mak Orgahi-Orha'a Nhi'a. Adoh ha samounu nee!” ");
INSERT INTO lex_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yahudi o'tani-matni miy, miy er mak edon mrieinian Ray Makamori-Kalewna. Hade pede mhioratreria! Hota miy edon mior wutga Uplerlawna mutnu-rahanu, mak Enodi plolli la pa emeka Ray. Mere hota Agala hairi dom pa rre'ela Uplerlawna mutnu-rahanu. Ir er mak klernohora Uplerlawna lirni-tunnu. ");
INSERT INTO lex_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Mere riy maka kahmena kreinian A'u de hota rler la yatyatni-halalli yatlorni-yatra'ani pa emolmolan nekama riy mak ktuin pa ktaiya watu onde riy mak watu nwaklol niana, de hota ramkoha-ramnana pa rwal lia en liu'wu-tan miakmu.” ");
INSERT INTO lex_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","La'pa imam re o'tani-matni ror wutga riy Parisi re ratlin tutga yawalliohora maka Yesus Nakota re, de irat muemna Yesus lirni de e ntai ira. ");
INSERT INTO lex_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hade pede rwahak talan pa rtorna Yesus. Mere ramta'at rer lia' rirahu yoma rira liawanni rpolga Yesus la'a makwohorulu-ktatrulu id hade. ");
INSERT INTO lex_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesus Nnairia yawalliohora id owa'an pa na Nwahaur la o'ta-mata re, Niwra: ");
INSERT INTO lex_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“La'a Uplerlawna mutnu-rahanu, mak Enodi plolli la pa emeka Ray, de Uplerlawna hihi'ini yala'ani emeknekama yawalliohor di. De Uplerlawna emolmolan nekama ray id mak kiwra khi'a he'i-hepur nohora a'nani muanke'a mehlimni-marya'ani. ");
INSERT INTO lex_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","De ray die nhopan pa mak ktulla-kar lia e'a rla pa rpolga riy maka ray die ha npol niana-nwak nana oleka pa rma ramtatna. Mere maka rpol niana-rwak nana re rahmena rmai. ");
INSERT INTO lex_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Noma ray die nhopan pa mak ktulla-kar lia E'a re dom to'a rla rhu'ru-rhelam la mak ha rpol niana-rwak nana re riwra: “Mia mimtatanmi yoma nhioi-tniani la' mei wawannu namtemtemn olekwa. A pipi-du'mu mak kden la lowna-krahanu raknioki-ratnia'awa momuog olekwa me er olek la mei wawannu. Mai pia tamkek la it gaini.” ");
INSERT INTO lex_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mere mak ha rpol niana re edonna rga' niohor polpuolu-wakwak de pede rla'awa la'a kniar genni me dom de rla'awa nhyi' ralma. ");
INSERT INTO lex_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ne korni de rtoran targho'a ray die hopopanni-lili'irnu pa ralla yetni warna na'nama rliwar wenwenna re. ");
INSERT INTO lex_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","La'pa ray die natlin nan hare de nawenan doin la. Pa nreiniande nhopan pa ralgota limni-rorni mak ka'ara pa rwunu-rwenna riy yatyat mak kwunu-kwenna ray hopopanni re, na'nama rhoklai la ir letni. ");
INSERT INTO lex_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nhor nia'nama ray die npolga mak ktulla-kar lia e'a re pa niwra: “Itwahi' oleka he'i-hepru la'a mehlima-marya' di mere maka apuolu-wuak ulu re ta'en niana ra'an wut mai a'u la mehlima-marya' di. ");
INSERT INTO lex_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Pede mliergot pa mpiolu-mpiak he' to'a mak kden la loi liawna-talan lawna pa rma rahepur pa ra'ana-remun la handi.” ");
INSERT INTO lex_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Dewade mak ktulla-kari re rla'awa pa rla rawoka-rale'ga riy mak kden la loi liawna-talan lawna re pa rriw niana momuoga pa rma rapenga geni-tiena maka ha rhi' targ oleka re. Riy kalwieda nor wutga riy yatyata er momuou lia hande. ");
INSERT INTO lex_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nhor nia'nama ray die nmai pia nlina-nmata mak kmai re honona la hande. La hande de ray namkek nana riy ida edonna nnairi naniair maka riy rnairia pa rahe'i-rahepur la mehlima-marya'a. ");
INSERT INTO lex_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Noma ray nakot la riy de niwra: “Hyalia, nihya'pa Ommuai handi de o' edonna mniairia naniairia muki-hepru la'a mehlima-marya' dina?” Mere riy de edonna nwalol hadoma. ");
INSERT INTO lex_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Noma ray nakot la maktulla-makar lia hande niwra: “Mpiutu-mkiohoga ha limni-lakni ne mrinnia la melmelli-kalkalamni la' lutur lawna to'orni. Hota la' hande de riy e rpolpuol inni-rwakwak amni.”” ");
INSERT INTO lex_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Noma Yesus Nwatia lirni la'a yawalliohor de pa Niwra: “La'a emkade wal pia polpuolu la' riy harahu pa rler teman la Uplerlawna mutnu-rahanu, mere mak ha rwaliri, de riy doma rmeh'a.” ");
INSERT INTO lex_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nhorwua noma riy Parisi rla' pa rawok pa rwahu'ria ralma-riora, totpena rna'aili Yesus. ");
INSERT INTO lex_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Noma rhopan doinia ir mutwualli doma ror wut wualia riy mak kher lia Herodes totpa rla'a Yesus de pa ratiana riwra: “Tungkurga, amatga de riy plele'er id O'a. O' e Mpuatut die, Mukot nohor plollolli la Uplerlawna ralma-rior kalwiedwedni la'a rimormiori. O' edonna Mhue'du nan etia riy ralma-riorni, yoma riy lalawna onde riy kuku'uni ho'mana O' edon Mpuadan nohora. ");
INSERT INTO lex_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","La' hade pede Mukot teka la mai ami, de la' O wniarormu de, la' it agamni deullu-tatarni de nakot am pia ampairia blastena la'a mak ktorna horta-hairi (Kaisar) onde yana?” ");
INSERT INTO lex_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mere yatianni re de Yesus Nat niohora ira nnia'ohma yatyatni honona. Pede Yesus Nwahla re: “Oi riy kdior miera miy! Mtiut inonmi emeka riy mak samomuou mere plollolli de riy yatyat miy. Hya'a nrei pia miwra mtiot A'u?! ");
INSERT INTO lex_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mi'al tek la kupan maka ma mpiairia blasten la pa mtiut tieka la mai A'u.” Dewade rala kupan dinar id pa rtutga la Yesus. ");
INSERT INTO lex_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Noma Yesus Natiana re: “La kupan de he'a herni-gaini me he' nanni mak kden la kupan dena?” ");
INSERT INTO lex_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Noma rwet la riwra: “Ray mak ktorna horta-hairi Romawi (Kaisar) o'tani inhat ee!” Noma Yesus Nakot la re: “Hade emkade, miala kupan maka ray herni-gaini etla de la'a ray, yoma hanni hade. Ne miala la Uplerlawna hya' maka Uplerlawna gahani wali.” ");
INSERT INTO lex_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","La'pa ratlin nana lira wniahla re honona, de honona rwer rer wiawni. Noma honona rwatitin la gen diewa pa rto'or la Yesus. ");
INSERT INTO lex_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","La' ler de nekpa riy Saduki doma rmai pia ratian nohora Yesus la'a emkameni riy mak kmati hota rmori owa'ana, yoma Saduki re er mak edonna kpesiay riy mak kmati hota rmori owa'ana. ");
INSERT INTO lex_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Riwra: “Tungkurga, Musa wniatutnu-wniaye'eni la ita de emkadi: de la'pa muanke'a ida nmati me nakleh ma'ta a'na, de muanke'a mak mat die hyalli nor owa'ana yerni patyat de rmehlima, totpena rlernana hyalli mak kmati olek de duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","La' lera ida de muanke'a riy wo'itu rwahyal riaralma mak kdella it nohoni. Noma yanulu nmehlima mere nakleh ma't a'na dewade nmat wia. Pede hawni patke' maka ha nto'or nan de nora yerni muanke'a ida rmehlima. ");
INSERT INTO lex_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","La'pa edonna rlernan ma'ta a'na, de muanke' de nmat wia. Noma patke' de nor yerni id owa'ana. Mere emkade to' pa nodi liarni pa la ntut mueman la gari hoho'a. ");
INSERT INTO lex_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","La'awa hohoni noma pat de nmat wia mere nakleh etia a'na ida. ");
INSERT INTO lex_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pede la'pa la'awa lerni pa mak mati honona rmori owa'ana, de hota he' hawni patke'a dena? Yoma mak kwahyali re wo'itu meman pa rora pat de rmehlima.” ");
INSERT INTO lex_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Noma Yesus Nwahla yatianni re Niwra: “Oi, miy wniarormi nhala, yoma miplin niohora Puka lirni, me miplin wualia Uplerlawna plolli-mneheni. ");
INSERT INTO lex_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yoma riy mak kmati re hota rmori owa'ana, de hota edonna rmehlima, mere hota rmori-rdar lia Ilyamou-Watyatoha, emolmolan nekama Uplerlawna hopopanni (malaikat) la' Ilyamou-Watyatoha mak edon rmehlima. ");
INSERT INTO lex_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nah, la'a miy wniarormi de mak miwra riy hota edon rmori owa'an la matmiatni ralamni, de emeknekama miy edonna mpiaik nan ma'ta hya' maka Uplerlawna Nakot nohora la'a mak hota kmori owa'an la matmiati ralamni. ");
INSERT INTO lex_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Yoma la' ler maka Abrahama, Isaka, me Yakopa rmati olek de Uplerlawna Niwra: “A' di, de Abraham, Isak, me Yakop Uplerlawanni ma'ta A'u.” Ha nnia'eratni de Uplerlawna mutnu-rahanu mak kmati rmori owa'ana me Uplerlawna de ir Uplerlawanni. Uplerlawan de, riy mak kmati Uplerlawanni atia'a hade. E' de de, mak kmormiori Uplerlawanni E'a.” ");
INSERT INTO lex_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","La'pa riy mutlialawna re ratlin nana Yesus lirni-tunnu re, de honona re rwer rer wiawni. ");
INSERT INTO lex_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","La'pa riy Parisi ratlin tutga Yesus Nhi' nana riy Saduki re de rakleha lira waw la temni, dewade Parisi re rawok owa'an pa rna'ohma. ");
INSERT INTO lex_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Noma tungkurga agama deullu-tatarni id la ira la nala yatiana id pa na nta'aga Yesus. ");
INSERT INTO lex_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Niwra: “Tungkurga, lira nhiopan meni ed maka khi' ononni la'a agama deullu-tatarni?” ");
INSERT INTO lex_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Noma Yesus Nwahla lirni Niwra: ““Miala miy rurmi-laimi, ralma-riormi, ihrami-ralammi tetema pa mhima-mrie'a Uplerlawna Matromlawanmi de.” ");
INSERT INTO lex_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lira nhiopna, nhiedu tniehra ononni inhatta hade. ");
INSERT INTO lex_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","La' wornu mana emekwalima idni de. De niwra: “Miatu mtiulla-msiaynia, mira'a-mipal wualia rimormiori wialmi pa emekwalima mimkek rer lia inon wamuehemi.” ");
INSERT INTO lex_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Deulu-tatra agama maka Musa nor wutga makwohorulu-ktatrulu rwatutu re, on petanni-ga'ar lawanni (ononni) nwatiawua lira nhiopna ri.” ");
INSERT INTO lex_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","La'pa riy Parisi rden ma'ta la hande noma Yesus Natiana re: ");
INSERT INTO lex_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“A'utian tek miy. La'a miy wniarormi de Ray maka kamori-kalewan mak Uplerlawna Nano'tar die, de he' duratni-waitni hadena?” Noma riwra: “Ray Daud duratni hade.” ");
INSERT INTO lex_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Noma Yesus Niwra: “Hade emkade, de hya' ed mak krei piede Uplerlawna Nhiwni Narialmua Daud pa nwet la Ray miaka kamori-kalewna de e Matromlawanni? Yoma Daud niwra: ");
INSERT INTO lex_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Orgahi-Orha'a Nakot la a Matromlawnu (Yesus) Niwra: Muliwnu (Mumtatnu) la' A wa'lu malganna, la'pa A'utowra arwalmu pa ratniowar la O nayanmu.” ");
INSERT INTO lex_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","La'pa ray Daud nwet la Ray Makamori-Kalewna, niwra e Matromlawanni, nihya'pa mikota ray Daud duratni E'a?” ");
INSERT INTO lex_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Dewade Yesus Nwatia lirni mere riy id mana edonna naltieri eti la Yesus gaini ralamni. Ne la' ler de pa nodi liarni de riy id mana edonna nparan pia nhar lirni pa natiana Yesus. ");
INSERT INTO lex_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Noma Yesus Nakot la maka ha Nwatutu-nwaye'a re ror wutga riy rahu re Niwra: ");
INSERT INTO lex_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Makwatutu-kwaye'a agama me riy Parisi rodi plolli pa ra rwatutga Musa deullu-tatarni re. ");
INSERT INTO lex_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","La' hade pede miy e mliernohora hya' ed maka ha rwatutu-rwaye'a la'a Musa deullu-tatarni honona re. Mere yan memmemna mtiolliohora hya' maka ha rhi'a re. Yoma irmeh'a nek de edonna rlernohor hya' maka ha rwatutu-rwaye'a re. ");
INSERT INTO lex_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hare wniatutnu-wniaye'eni re emolmolan nekama rkeni kwar werwerta la riy wawannu, mere edon rtulan nan etia riy totpena rlernohora wniatutnu-wniaye'eni re. ");
INSERT INTO lex_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Hya' maka ha rhi'a re de totpena riy ramkek ira. Ralma-riorni de totpa riy ramkek ir de emeka riy mak kape'el la agama. La' hade pede rhorta Itmatromlawanni lirni na'nama rkenia la geni sapona-sapona dewade rtapla la limni me reranni, ne rnairia rain plalahwa nor tawnu plalahwani. ");
INSERT INTO lex_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","La'pa ramtatna la' yawoka-yale'u he'i-hepru la'a ya'anlawna-yemunlawna de rwahak genia samomuou totpa riy ra'uli ira, me rla'a Yahudi kreini-iskolli de rwahak geni mak kden la gaini. ");
INSERT INTO lex_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ir rahepru yoma mak kden la ya'olgeni rhi' ir la rekna-waiti me rhoi ir la “Tungkuru”. ");
INSERT INTO lex_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mere miy die yan memmemna mtiolliohor ira yoma mtiot pa riy ra'uli-rawedi miy pa rhoi miy lia Tungkuru. Yoma miy Tungkurmi inhatta id to'a, ne miy hononmi de mpia'ina-mpianara. ");
INSERT INTO lex_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ne yan memmemna mi'uli-miwedia riy mak kden la nohkeran di pa mhioiya la Am plollola, yoma miy Amlawanmi mak kaplollola de ida nmemeh'a to'a, mak etla Ilyamou-Watyatoha. ");
INSERT INTO lex_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Me yan memmemna mpiayow nohor pa ra'uli-rawedi miy pia rhoiya miy lia Matroma la'a noha wawannu, yoma Matroma eneknek to'ama riy ida, de A'g e inhatti maka ha rweta la Ray mormiori-lewlewna maka Uplerlawna Nano'taru. ");
INSERT INTO lex_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Riy maka inponni karehi la'a wokmi-le'emi, de riy mak katu khoi-ktani la rimormior wialli. ");
INSERT INTO lex_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Riy maka katulu-kapetna inonni la heyanan de hota Uplerlawna Nalernia, ne riy maka klol yawa de hota Uplerlawna Nrana la heyanna.” ");
INSERT INTO lex_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tungkuru-tungkurga agama miora riy Parisi miy, adoh! Hota mlier la yatyatni-halalli yatlorni-yatra'ani. Miy mtiutga inonmi emeknekama riy samomuou, mere plollolli de riy yatyat miy (munafik). Miy e mtierteri-mtiatawa riy mak kiwra kler la Uplerlawna mutnu-rahanu. Mere miy mieh'a nekane mihmena mlier la Uplerlawna mutnu mak Enodi plolli la pa emeka ir Rayni. Ne riy mak kiwa kler la Uplerlawna mutnu demade mtieri-mtiawa. ");
INSERT INTO lex_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Tungkuru-tungkuru agama miora riy Parisi miy, adoh! Hota mlier la yatyatni-halalli yatlorni-yatra'ani. Mtiutga inonmi de emeka riy kalwiedweda mere plollolli de riy yatyat miy (munafik). Miy e miohpa-milahara a'na riy patyata me mrieyahru romni-lewnu. Ne msiumbain de plo'a-plahwa la riy rahu gaini ralamni totpa ma mtiutwua miy do'omi-halmi. Mere hade mak kariei pia mliernana niukum mak hota kwerwerta nareh dioinia mak riy dom to'a rlernana. ");
INSERT INTO lex_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Tungkuru-tungkuru agama me riy Parisi miy, adoh! Hota mlier la yatyatni-halalli yatlorni-yatra'ani. La'pa mimihak riy id to' pa nlernohora miy agammi deullu-tatarni de ho'mana miy e mlieretia hletna-yoiri me miy mhia'ata wo'ora-kawru. Mtiutga inonmi emeka riy kalwiedwed miy. Mere hota miy mrieiniande riy de do'oni-halli nareh dioin miy do'omi-halmi la re'eni woru totpena hota nler meman la ai mormiori ralamni. ");
INSERT INTO lex_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","O'ta-mata miy, de miy emolmolan nekama riy mak mat yata mak ktutga talla la riy dom to'a. Adoh! Hota mlier la yatyatni-halalli yatlorni-yatra'ani. Miy mpiatutga riy miwra la'pa rwet la Uplerlawna roma kreini pa rlokra de edonna nawniatiehra. Mere la'pa rwet la maha no' krei ralamni pa rlokra de ha nawniatiehra nohora liokarni. ");
INSERT INTO lex_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Miy die mpiodku me matmi yata. Hota ha meni ed mak karehi? Maha no' krei ralamni onde krei die mak khi' pa maha de, Uplerlawna gahani?! ");
INSERT INTO lex_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mimpiatut walia hadilla rira. De la'pa rwet la katri'ana pa rlokra de edon nawniatiehra la liokar de. Mere la'pa rwet la prehena-mau maka rkenia la katri'ana wawannu pa rlokra de ha nawniatiehra nohora liokarni. ");
INSERT INTO lex_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Adoh matmi re yatni ne ee! Hameni ed maka karehi, prehena-mau, onde katri'ana mak khi'a prehena-mau pa nwal lia Uplerlawna gahani?! ");
INSERT INTO lex_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","La' hade pede la' pa riy ida nlokar pa nano'taru hadom la katri'ana, nnia'eratni de e nano'targa hadella katri'ana nor wutga hya' mak kden la katri'ana wawannu de honona. ");
INSERT INTO lex_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ne la'pa hameni nlokra hadom nwet la roma-krei, nnia'eratni de enakot oleka hade la roma-krei nor wutga Uplerlawna mak kden la' roma-krei die. ");
INSERT INTO lex_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ne la'pa riy ida nlokra pa nwet la Ilyamou-Watyatoha, nnia'eratni de nlokra hadella Uplerlawna mtatangenni ne la' walia Uplerlawna mak kamtatan la' hande. ");
INSERT INTO lex_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Tungkuru-tungkuru agama miora riy Parisi, adoh! Hota mlier la yatyatni-halalli yatlorni-yatra'ani. Mtiutga inonmi emeka riy kalwiedweda mere plollolli de riy yatyat miy. Yawuli-yatniamanmi emeknekama kio'a-kamlaka de nhi'inde miala nhiakra id ralamni la termida (sepersepuluh) la'a Uplerlawna. Miala de naplola mere miy edonna mpiadan nohora agama deullu-tatarni ononni emeknekama mtiulla-msiayni rimormior wialmi, mhioli-mliet la plol wawna, la'pa ida edon nollia ida. Maka plollola pa mhi' nana de, de hota mliernohor ononni maka ha rwahakhaka inhatta re nor wut wualia yana mhioratdoin wal pia miala nhiakra id ralamni la termida (sepersepuluh) la'a Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","O'ta-mata miy, miy die emeka riy mak mat yata mak ktutga talla la riy dom to'a. Yoma hya'a maka agama ononni de miy edon mpiadan nohora, mere hya' maka edon kwerat la Uplerlawna yamkekni de mimihakhak reria. Pa hota emolmolan nekama mi'na potpota mak kdella miy niemun genni ralamni demade mimtia'i doinia la, mere hayori demade mliumu-mtielan nana. ");
INSERT INTO lex_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Tungkuru-tungkuru agama me riy Parisi miy, adoh! Hota mlier yatyatni-halalli yatlorni-yatra'ani. Mtiutga inonmi la riy kalwiedweda mere plollolli de riy yatyat miy. Mhi' emeknekama riy maka kwuri-kohma lola-wra'u wali to'orni mere ralamni re edonna rohma pa nakdeha-naktiahli ma'ta, yoma mtiot pa mpiehwa-mliakta emekneka riy kalwiedweda mere mimatmer la rira hyonni-hyanni me mimpiaror to' inon wamuehemi. ");
INSERT INTO lex_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Parisi miy die, mpiaho'a-mpiahai niohora matmi yamkekni. Hota mhioitio'or doin-mtiahnei dioinia nhiolmi yatyata re, ne plol toto'a pa mpial lia riy kalwied wa. Totpa hota miy die emolmolan nekama riy mak ka'ala lolli-wra'nu me larni-kanni, pa nwuri-nohma momuoga ralamni re, totpena honona mana nmomuou. Yoma la'pa it ihranu ralamni nmou-nwitna de hota it wniehwani-liakatni hihi'ini-yapyapni mana rkalwiedwed wali. ");
INSERT INTO lex_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Tungkuru-tungkuru agama miora riy Parisi miy, adoh! Hota mlier la yatyatni-halalli yatlorni-yatra'ani, yoma mtiutga inonmi emeka riy kalwiedweda mere plollolli de riy yatyat miy. Miy emeknekama hoi-kietra mak ha roh aur la pa yamkekni de samoga la tio'ora. Mere la' ralamni de npenpuen niohora riy rurni-kliakallu mak kahuwu-kawoini. ");
INSERT INTO lex_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hota emeknek walima mtiot pa mpiehwa-mliakat emekneka riy kaplele'era mere nhiolmi-lietmi de to'a yoma nhiolmi npenpuen niohora yatyatni-halalli. ");
INSERT INTO lex_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Tungkuru-tungkuru agama me riy Parisi miy die, adoh! Hota mlier la yatyatni-halalli yatlorni-yatra'ani, yoma mtiutga inonmi de emeka riy ploi-ple'era, mere plollolli de riy yatyata-halal miy. Nhi'inde mpiedia hoi-kietra la'a makwohorulu-ktatrulu ululu me mhi' samomuou wat tiutulu-au pidara (tugu) la'a riy mak kaploloi-kaplele'era. ");
INSERT INTO lex_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Me miwra: “La'pa amor wut lia a up mamni-tgar mamni lerni mana, ami edonna mre' wut pua mpunu-mpenna makwohorulu-ktatrulu re.” ");
INSERT INTO lex_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mere la' miy lirmi re, mtiutga de miy di de riy mak kwunu-kwenna makwohorulu-ktatrulu duratni-waitni miy. ");
INSERT INTO lex_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pede ndella pa mhiaur nohora upmi-tgarmi do'oni-halli pa nodi liarni (totpena hota mlier la Uplerlawna niukamnu). ");
INSERT INTO lex_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Miy die riy yatyat miy! Pa hota emkameni totpena miy orgahami milewna inonmi la'a niukmua ai mormiori ralamni?! ");
INSERT INTO lex_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mitlin samomuoga me! Hota A'u'enyatga makwohorulu-ktatrulu me riy maka ka'o'ta-kakriahlu me tungkuru-tungkuru totpa rwahak pa mhioitio'or doin-mtiahnei dioini do'omi-halmi. Mere hota mtiollia dom pa mpienna, me hota dom de mlia mpiairia la auwlakra hananni. Ne dom de hota miala ha ulti pa mliwra la'a Yahudi re kreini-iskolli genni me mtiota pa mhiokar reria la' leta id pa la' leta ida. ");
INSERT INTO lex_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","La' hade pede hota miy er mak kakwara wniunu-wnienna nwauga la ler maka upmi-tgarmi rwunu-rwenna Habel, ne rodi liarni la'a wniunu-wnienna la riy korni honona mak khi' mak kaplol la Uplerlawna yamkekni la' pa ntutu-nte'ewa la' ler maka rwenan walia makwohorulu-ktatrulu Sakaria, Berekia a'nani de, la'a Uplerlawna roma kreini nora katri'ana letgarni. ");
INSERT INTO lex_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pede mhioratrerio! Nee! Plol toto'a pa wniunu-wnienna honona re, de hota tuwu di rakwar reria do'a-hala re honona.” ");
INSERT INTO lex_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Neee! Makden Yerusalem miy ee! Miy er mak kwunu-kwenna makwohorulu-ktatrulu me mpiatliewur wenna riy maka Uplerlawna Nhopna rtiy miy die. Makden Yerusalem miy ee! A'g e uhak memna olek la re'eni wo'ir meman pa Agiwra ghi' miy pia emeknekama hiwi tei mak kreka-krek a'nani la liwarni nayanni, mere mihmena mitlin la A polpuo'lu. ");
INSERT INTO lex_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","La' hade pede mitlino! Hota Uplerlawna Nolin limni la miy letmi. ");
INSERT INTO lex_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pena miatgo, la' ler di pa ntutu-nte'ela ler mak Amuai owa'ana, de hota, miy edon mimkek eti A'u. La' A maimia'yu lerni de nampena miwra: “Makodia Orgahi-Orha'a nanni Nmai wiee! Mai pia ta'uli-tawedi tlilili-tmamuawua!”” ");
INSERT INTO lex_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","La'pa Yesus Nran lakni la Uplerlawna roma kreini noma maka ha Nwatutu-nwaye'a re rmai pia rakot la: “Tuna, Mumkek tek la Uplerlawna roma kreini de inponni me naruri.” ");
INSERT INTO lex_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Noma Yesus Nakot la re Niwra: “Yowa, Uplerlawna roma kreini de inpona me naruri. Mere totpena miatga, hya' maka mimkeka ri, hota rweyata-rwaniawu momuoga. Wat muaka kapnidara re de hota id mana edonna nalliapar la id wawannu.” ");
INSERT INTO lex_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nhor nioma Yesus Nla'awa wo'ora Saitun noma Namtatna la hande. Noma maka ha Nwatutu-nwaye'a re rod tiemna pa ror Yesus rwahaur rewre'wa pa riwra: “Tuna, Mpue'er nohor tek hare, mai ami hota mowen die itamkek mak Omukota re? Me hota hya' ed maka tamkek ulga totpena nwagahniort it la O maimiaimu me noha niatni nrehgor wua?” ");
INSERT INTO lex_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesus Nakot la re Niwra: “Mi'ererma! Yanpa riy rhi' aklierat miy la'a A maimia'yu de. ");
INSERT INTO lex_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Hota rirahu rmai die rnairia A na'nu pa riwra: “Ray Makamori-Kalewna maka Uplerlawna Nano'taru A'g inhatti!” Hota rirahu rpesiaya ir pa rler la klieratni. ");
INSERT INTO lex_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hota mitlina poka hidara yetni warna me mliernana kota-de'eta de rira riwra wunu-ara e nwewr olek la noha-rai, mere emkade ho'mana yan mimta'ata. Yoma hota hare honona de plollola pa itamkeka me itatlina, mere noha niatni edon ntutu-nte' ma'ta. ");
INSERT INTO lex_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Hota hairi nor hairi rawunu-rawenna, me noha-rai nora noha-rai rawo'ora. Ne hota rehka-lara nwewar la noha-rai, me noha nruru (upkarururu) lol meni-meni. ");
INSERT INTO lex_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hare honona de tamkeka pleinia mere edon rler ma't la noha niatni. Ler maka mimkek la hare de eneknek to'ama mulaliaini, pa emekto'ama patke'a maka apannu namehra la mulaliaini, mere lerni edon ntu'tu ma'ta pa nayor a'nani. ");
INSERT INTO lex_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Hota la' ler de rwatoran miy miak klernohor A'u pa ral miy lia riy yatyata-halala pa rnahora-rnala'a nanpena rwunu-rwenan miy. Hota la' noha wawannu de noha-rai honona rahankeran rer tiy miy yoma mimliernohor reri A'u. ");
INSERT INTO lex_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","La' ler de mana rirahu rhoitio'or doin-rtahnei dioin la pesiayni la A'u. Ne rwaldioinia pa rtorna riy makpesiay mia'ta yoma sukni tia'ala na'nama rala la riy yatyata re pa ramuki-rama'ala. ");
INSERT INTO lex_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","La' ler de wal pia riy rahu hota ralahar pa riwra ir de makwohorulu-ktatrulu ira pa rodi rirahu la klieratni. ");
INSERT INTO lex_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yatyata-halala na'ititar la liawanni pa narieiniande rirahu rakleha sniayni la rimormior wialli me edon ratlina-ratailla Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mere la'pa miy e mtiorrer pitpitga pesiaymi, de hota mliernana mormiori-lewlewna plalahwa pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ne Kot Kalwieda-Paitiota la'a emkameni la Uplerlawna Nodi plolli pa emeka Ray, de hota rakotkot lola pa nwewar la noheri woru nayanni totpena riy honona ratga, nhor nianpena noha niata.” ");
INSERT INTO lex_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Makwohorulu-ktatrulu Daniela nakot nohora la' ululu memna la'a hya' mak khi' akdeha-aktiahlia gen lululi la Uplerlawna roma kreini ralamni narieiniande Uplerlawna Nawenna. Pede la'pa hya' maka Daniela nakot nohora ntutu-nte'ela de, miy miaka mpiaik nana e lirni de mnia'erit nana lirni de nnia'eratni! ");
INSERT INTO lex_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pa miy mak kden la Yudea miwlar lia wo'ora hananni. ");
INSERT INTO lex_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Me maka kateni anni la likti wawannu plet pa miwlari. Yana mhioratreria hya' mak kden la roma ralamni pa miodia. ");
INSERT INTO lex_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","La'pa miy mak kden la nhyi' ralma de yana miwali pia miala lawarmi-rayanmi la'a roma nayanni. ");
INSERT INTO lex_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Adoh! La' ler de pat mak ka'uhu-ka'apnu, ne la'a pat mak nuh reria a'nani re rpolpuol inni-rwakwak amni. ");
INSERT INTO lex_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Msiumbaini totpena yanpa miwlar liola otna-anni ralamni onde yanpa la'a Sabat lerni. ");
INSERT INTO lex_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yoma lera-mela mak kodi kropna-krieutu, nniahora-nniala'a, yamuki-yama'ala mak emkade, de it edon tlernan etia la'a ler maka Uplerlawna Na'ohi-na'ara nohkerna la'pa ntutu-nte'ela' ler de. Ne la'pa itleretia de, it edon tlernan emkade owa'ana. ");
INSERT INTO lex_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","La'pa Uplerlawna Nala ler de pa naplahwa de hota riy id mana edonna ntuin tar lia noha wawannu yoma rmat miomuou. Mere onnila Uplerlawna sniayanni la mutnu-rahanu maka Nwalir niana re to'a, maka nhi'nande ler de edonna nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","La' ler de la'pa riy riwra: “Mai pia tamkek ee! Ray Makamori-Kalewna maka Uplerlawna Nano'taru ed olek diwa,” onde dom e riwra: “Ee, Ray Makamori-Kalewan de etla handelloo!” Yan mitlin la lirni re. ");
INSERT INTO lex_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Yoma hota la lera re de rirahu ralahar pa riwra ir de de Ray Makamori-Kalewna maka Uplerlawna Nano'taru onde rtot inonni emeka makwohorulu-ktatrulu pa rnairia hihi'a-yapyapi mak kamehi-kayona mak riy edon ramkek taru pa rtutga rurni-laini totpa ra ra'ohpa-ralahara rira. Uplerlawna mutnu-rahanu maka Enwalir niana nekane, riwra rtot pa rler la klieratni. ");
INSERT INTO lex_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Hade pede mhioratreria! Dodo'ondi de A'ukot oleka hari tiy miy wia totpena hota la'pa hare honona rtutu-rte'ewa de miy edon mlier la klieratni. ");
INSERT INTO lex_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pede la'pa riy rma rpo'on tiy miy riwra: “A'g e wuatrom nana Ray Makamori-Kalewan della' wo'orletna-kawurloini,” de yana miora pa mlia'a. Onde la'pa riwra: “Mai pia mlia mimkeka, e nade'a la rom id ralamni.” Yan memmemna mitail nohora. ");
INSERT INTO lex_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yoma hota Rimormiori A'na A maimia'yu de riy honona plet pa rat niohora. Yoma Amuai die, emeknekama hita-tlena nkaili la'a tipur matni, lairni ndain la warat matni. ");
INSERT INTO lex_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ne emeknekama tamkek nana iha lakma e ntapoi reria re, pa nahe' niohora ya'ana, tat niohora mak kmati-kmolu etla hande, de emkade walia la'pa Amuai owa'an de riy honona rat niohor memna.” ");
INSERT INTO lex_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“La'pa ler maka riy rler la kropna-krieutu, nniahora-nniala'a de nlardoinla dewade leretniekla: “lera nwamuela ne wolla mana nakleh lair wia. Hota wtiona mana pala tuinia. Ne maka kodi plolli la darta-lyanti mana hota nawniatiri-nawnialiakra.” ");
INSERT INTO lex_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nhor nianpena hya' mak ktutga Rimormiori A'na A maimia'yu de nayamkek la lyanti ne hota la' ler de noha-rai honona polpuolu-kakakria la noha wawannu. Hota honona ramkek reria Rimormiori A'na A' Muai pia Adien la kakma wawannu, de Agodia A plo'lu-mneh'u, A preh'u-mka'yu mak kamehi-kayona la liplipni-kamka'mani. ");
INSERT INTO lex_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hota Uplerlawna hopopanni neuga noknok lawna, ne Rimormiori A'na A' die ghopan pa A hopopnu mak kden la Ilyamou-Watyatoha rawoka-rale'ga A mu'tu-rah'u maka Uplerlawna Nwalir nian oleka, mak kdella noha uhunu-lyanti ewatni.” ");
INSERT INTO lex_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mia'ala wniatutu-wniaye'a la kar on de. La'pa mtiamnia olli demade nmor wia, de miatg oleka lerwarnu nwakrian wia. ");
INSERT INTO lex_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hota emkade wal lia mimkeka hare honona mak A'ukot nohor olek diwa, de miatg oleka de lerni-melli nhi' pa nwakrian wia. ");
INSERT INTO lex_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Totpa miatga! Riy la' tuwu di edon rmat mia'ta, de hare honona mak ukot nohor oleka di hota rtutu-rte'ewa. A li'ru ri raplola. ");
INSERT INTO lex_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hota lyanti nora nohkeran di mana rmolu-rhelam wa mere A li'ru-tu'nu de ndella pa nodi liarni.” ");
INSERT INTO lex_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Riy id ho'mana hota naplin niohora la'a hya' lera-hya' mela Rimormioria A'na A maimia'yu owa'ana. Uplerlawna hopopanni nekane raplinga, Uplerlawna A'nani A' ho'mana uplinga. Eneknek to'ama, A'mu la Ilyamou-Watyatoha nampena ed mak katga. ");
INSERT INTO lex_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","La'pa Rimormiori A'na A maimia'yu de rimormiori yehwani emolmolan nekama la it upni Nuh tuwnu la' ler ululu. ");
INSERT INTO lex_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","La' lera ger wawuau edonan ma'ta, de rimormiori rtepartarlia ya'ana-yemnu la lera-lera, me rmehlima-rmarya'a. Emkade nekpa nodi liarni pa la'pa nte' meman la Nuh nler la aupual liawna (batra) ralamni. ");
INSERT INTO lex_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","La'pa nte'ela ger wawuau liawan de nmai wia dewade nwau dioin rimormiori mak edon kla' teman la Nuh nor upni-a'nani, na'nama nhioratni rla' temni. Hota emkade walia la'awa lerni maka Rimormiori A'na A' Muai owa'ana. ");
INSERT INTO lex_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hota la' ler de de riy worg e rtepartarlia kniari la'a nhyi' ralma, de hota ralewna riy mak klernohor A'u mere mutwualli de edonna ralewan nana yoma edon npesiay A'u. ");
INSERT INTO lex_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ne la'pa patke'a worg e rtepartarlia rwotra wetra' lawna, de hota mak klernohor A' die ralewna, mere rhoitio'or doin mutwualli mak edon klernohora A'u. ");
INSERT INTO lex_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Hade pede orahnioratmi! Yoma miy e miplinga Orgahi-Orha'a maimiaini. ");
INSERT INTO lex_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mhioratreria! Itala orrom id pa tsi'a la yawalliohora. La'pa orroma nat niohora hya'a lera-mela mak kamna'a nma nkamna'a la e romni, de hota edon nanina, me e natiak reri totpena mak kamna' de yana na'unut nan e'a. ");
INSERT INTO lex_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","La' hade pede miy miana emkade wali. Mitiak reria! Mitlin reri-mitail rer lia Uplerlawna lirni, yoma Rimormiori A'nani hota Amuai owa'an de, miy e miplin niohora ler meni-mel meni.” ");
INSERT INTO lex_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“La' hade pede mhi' inonmi pa emeka hopopna-lili'iru maka riwra natu nhu'ru-nhelma me natu natlina-nataili. Hopopna mak emkade upni-matromni mana nran e' pa nla' o'tani la' hopopanni-lili'irnu korni totpena e' ed mak khakra mutwualli re ya'anni-yemannu la'a lelera-melmela. ");
INSERT INTO lex_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Hota hopopan mak kdenrer lia kniarni de hota nlernan unut lawna, yoma matromni nawal pia nmai die nlernan entepartarlia tulla-kniari. ");
INSERT INTO lex_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mpiesiayo, hota upni-matromni de npesiaya riy de pede nran e' pa nwal lia mak klina-kmata la e re'eni-tniarnu honona. ");
INSERT INTO lex_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mere hopopan mak kyata-khala de hota nwarora la ralamni hota upni-matromni mahneka nanpena nawali. ");
INSERT INTO lex_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Pede nliwra-nkaklia hopopan walli re, ne na'ana-nemun wut lia riy mak ktepartarlia kpehera-kma'wu. ");
INSERT INTO lex_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Dewade upni-matromni de nawal pia nmai wia la'a lera-mel maka hopopan de naplin niohora. ");
INSERT INTO lex_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pa nhi'nande upni-matromni nukmua werwerta riy de ne nhokar doinia pa nre' wut lia riy mak ktot pa nhi'a plolli mere plollolli de riy yatyat ira (munafik). Hota honona re rpolpuol inni-rwakwak amni.” ");
INSERT INTO lex_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“La'pa nte'ela Rimormiori A'na A maimia'yu de, de hota Orgahi-Orha'a yehwani la'a mutnu-rahanu maka Enodi plolli la ira pa emeka Ray, de emeknekama la'a yawalliohor di. De hota hararara termida maka ha rwalir tiar pua klernohor reria mak kmehlima, rla' pa rima-rima ra'al wa'danu pa rla' pa rwatroma a'na muanke'a mak kmehlim de. ");
INSERT INTO lex_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ne la'a harara termida re de riy wolima e rpodku ne riy wolim de ratu. ");
INSERT INTO lex_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Harara matlimlima mak podku re rodia wa'danu genni mere edonna rodia wu'ru ya'itarni. ");
INSERT INTO lex_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mere harara matlimlimni mak katu re rodia wa'danu me rod wialia wu'ru ya'itarni. ");
INSERT INTO lex_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","La'pa a'na muanke'a maka kmehlim de nmai die mela nlawna, pa nreiniande hararar re rhoki-rtemna me ranina. ");
INSERT INTO lex_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","La'pa mela nletargara na'nama rira riarni-riarin nohora mak kmehlim de nmai wia. Riarin pa riwra: “Nmai wia, muanke'a mak kmehlima nmai wio! Mai pia twatrome!” ");
INSERT INTO lex_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Harara re termida ema rhedga mata pa ra'itra wu'ru la wa'danu re. ");
INSERT INTO lex_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Noma harara mak podku re rakot la mak katu re riwra: “Oi, mtiulan pa miwe'er nana a wa'du mamni ri, yoma a wa'du mamni ri wu'ranu nhi'pa nkeran wa.” ");
INSERT INTO lex_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mere harara mak katu re rakot la riwra: “El miy re, yan miwenna mere taken niana yoma hota mal tiy miy, mere hota he' nal mai ami? Mlia miwelia la'a riy mak ka'olu wu'ru.” ");
INSERT INTO lex_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Noma mak kpodku re rla rawelia la' mak ka'olu. La'pa ralala' ma'ta de muanke'a mak kmehlim de nte'ewa pa hararar mak katu re ror wutga mak kmehlima re pa rler la rialam la mak kmehlim de genni pa rho'la rwenta pinta puohra. ");
INSERT INTO lex_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Nhor nia'nama hararar podku re rmai wia pa rtet la nhiari riwra: “Tuna, tuna mhuar niana nhiari mai ami ee!” ");
INSERT INTO lex_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mere muanke'a muaka kmehlim de niwra: “Plollolli de, a'uplin niohor miy.”” ");
INSERT INTO lex_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Noma Yesus Nwatia lirni la lira yawalliohor de Niwra: “La' hade pede yan mininmi mere mitiaktiaka, yoma miy edonna miat niohora lera-mel maka hota A maimia'yu de ntutu-nte'ewa.” ");
INSERT INTO lex_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesus Nakot owa'ana Niwra: “Orgahi-Orha'a kniarni la'a mutnu-rahanu re maka Enodi plolli la pa emeka Ray, de hota emekwalima yawalliohor di wali. Yoma hota Rimormiori A'na A maimia'yu de emolmolan nekama hota a'na muanke'a ida niwra nla nhopal la olietleta pa hota nmai owa'ana. Edon nla nhopal ma'ta demade npolga hopopanni re na'nama nakot la re niwra: “Mitiak reria a re'u-tnia'ru ri honona me mi'ititar la.” ");
INSERT INTO lex_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Noma nala re'eni-tniarnu re la'a hopopanni re de nlernohora rima-rima rurni-laini. La' riy idni de nala talenta wolima (kupna 170 kilu). Ne la riy wornu de nala talenta woru (kupna 68 kilu). Ne la riy wotellu de nala talenta ida (kupna 34 kilu). Nhor nioma nhopal wa. ");
INSERT INTO lex_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dewade mak klernana kupna talenta wolima de nleretniekla nla na'olu-nala'a wa pa na'unut nana ralamni re'eni woru. ");
INSERT INTO lex_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Emkade wal lia mak klernana kupna talenta wor die pa nlernana unatnu ralamni re'eni wor wuali. ");
INSERT INTO lex_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mere mak klernana kupna talenta ida, nla' pa nah tiani na'nama nhuwria kupan maha maka upni-matromni nala re! ");
INSERT INTO lex_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","La'pa mahnek meman na'nama upa-matrom de nawali pia rakot nohora maha re. ");
INSERT INTO lex_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Noma maka klernana talenta wolim de nmai pia nala kupna talenta termid la upni-matromni de. Noma nakot la matromni niwra: “Tuna, kupna talenta wolim maka omuala re de a'g e liernana untu talenta wolima pa erti.” ");
INSERT INTO lex_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Noma matromni nakot la: “Samoga! O' di de hopopna mak katlina-kataili pa o samo'wu. Yoma la' kuku'uni di de apuesiay olek o wa. Hota mak inponni ho'mana a'g e puesiay wialia o'a. Mmuai wia rialma pa ta'an wutu-temun wutu pa tamuki-tahepru.” ");
INSERT INTO lex_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Noma hopopan mak klernana kupna talenta wor die mana nler walia rialam pa nakot la matromni de niwra: “Tuna, kupna talenta woru mak omuala re de a'g e liernana owa'ana untu talenta woru pa erti!” ");
INSERT INTO lex_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Noma tun die niwra: “Samoge! O' di de hopopna mak katlina-kataili pa o samo'wu. Yoma la' ha kuku' di mere apuesiay olekwa pa hota la ha lalawna mana a'g edonna umta'ata. Mmuai wia rialma pa ta'an wut lia handi pa tamuki-tahepru.” ");
INSERT INTO lex_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nhor nioma hopopan mak klernana kupan talenta id de nmai pia nakot la upni-matromni de niwra: “Tuna yan muwenna me. Agatga de riy o'ta tehra id o'a. Hota tuna nleretniekla netia ha wo'a maka tuna edonna ntamin nana, me tuna nwokwiok niekpa na'ana hawo'a-hawehra maka edonna mrieiki-mpuo'ora. ");
INSERT INTO lex_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pede a'umta'ata yanpa tuna nawenan mai a'u. Kupan maka tuna nala re de a lia gahia tani na'nama aghuwria pa orgahamu mumkek memna kupna talenta memeh'a maka omuala mai a' di, de edonna nayawo'a ne erti pa orgahamu mua'ala.” ");
INSERT INTO lex_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tun de nakot la: “Hoi riy inon wertu ne, riy yatyata id o'a me! O' e muat wualia de a'g edonna uwuli-utniamni mere agetlia ha wo'a?! Me a'g e rieiki-wuo'ora la'a gen miaka awokwiok niekpa arieik wa?! ");
INSERT INTO lex_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","La'a plollolli mana omkienia a kupnu rella noha luwuaunu wniatierun lawanni (bank) totpena amuai emkadi de orgah'u ga' nana kupan de nor wutga rehenu-lawanni (bunga).” ");
INSERT INTO lex_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Noma nakot la hopopanni dom to'a niwra: “Oi, mua'ala kupna re la' e'a pa muala la riy maka gahani kupan talenta termida re. ");
INSERT INTO lex_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Yoma he' mak khima-kre' a lia kalwiedwedni de ir er maka klernan owa'an pa ra'itar rer lia liawanni. Mere maka edon nhima-nre' a lia kalwiedwedni, de hota ha kuku' id etla limni ralamni ho'mana ra' momuou lia. ");
INSERT INTO lex_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ne hopopan maka edon kdenreri de ratra la'a melmelli-kalkalamni mak kden la pliorni, totpena nler la polpuol inni-wakwak amni.”” ");
INSERT INTO lex_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“La'pa Rimormiori A'na A Muai owa'an de hota Agodi plo'lu-mneh'u. Ne hota A hopopna-lili'iru honona rlidan nohora-rtaur nohora A'u. Hota A'umtatn A lia liwange'nu-mtatange'nu, maka hitita-homomra. ");
INSERT INTO lex_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Hota rimormiori honona mak kwatiawua hairi-hairi honona rawowioin la A ga'yu ralamni. Nhor nianpena Awuahakra rimormiori honona re la'a nhiakra woru, de hota emeknekama makhuri-kwa'ana ral to'a duma wokni la'a pipi wokni. ");
INSERT INTO lex_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hota mak klernohora Uplerlawna ralma-riorni de Akenia la walli malganna ne mak edon klernohora re de Akenia la malwiru. ");
INSERT INTO lex_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nhor nia'nama Agodi plolli emeka Ray pa A'ukot la mak kden la A wa'lu malganna pa giwra: “Hononmi mmiai, yoma A A'mu Nara'a-napalga miy. Mai pia mliola rialam la'a Uplerlawna gen warwuarnu maka Ha Nwahi' targa tiy miy la'a ler maka Uplerlawna Na'ohi-na'ara nohkerna-rai miaran di. ");
INSERT INTO lex_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yoma la' lerni la A'uplara, de mimial pa A'una, me A tie'ru kerna de mial pa Agemnu. Me la' lerni A'uhulti-uhamra, de mhiaria nhiari mai A'u. ");
INSERT INTO lex_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","A'uniki-ulai mere miala naniair mai A'u. Alier la nnieni-nhiena, miy er mak kodi atiawi mai A'u. Alier la roma nhio'la ralamni de ma mtiomra-mniah'a pa mtiulan mai A'u.” ");
INSERT INTO lex_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Noma riy mak kholi-kleta la plol wawna rakot ma A'u, riwra: “Matroma, mowenia mamkek nana Matro'mu Narehka-naplara pa amalla Matro'mu Na'ana-nemnu? ");
INSERT INTO lex_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ne mowenia itwatrom de, Matro'mu emeknekama mak kahulti-kahamra pa amreiniana Matro'mu la a rom mamni? Ne la' hanmeni la amlernana Matro'mu de Muniki-mulai piede amala naniair pa Omhu'ru la? ");
INSERT INTO lex_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Me mowen pia amamkek nana Matro'mu temni nhi'a onde Mdiella roma nhio'la pede am tiy mtulan tiy O'a Matrome?” ");
INSERT INTO lex_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Noma A'ukot la re: “Totpena miatga, la'a hya' ed maka ha mhi'a la A i'nu-na'ru mak kakleha weli ho'mana hade emekwalima mhi' oleka harella mai A'u.” ");
INSERT INTO lex_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Noma hota A'ukot la mak kden la A wa'lu malwiru re giwra: “Ratar doin miy lia A wa'lu malwir di! Hota mlier la nhiorghala-wniaghala ralamni la ai mormiori mak kmormior pia nodi liarni maka ha rhi' targa la hegana amlawanni nor wutga hopopanni re, pa mior wutga la hande. ");
INSERT INTO lex_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yoma la' lerni la A'urehka-uplara de miy edonna mial pa a'una-gemnu. ");
INSERT INTO lex_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","La' lerni la A'uhulti-uhamra mana miy edonna mrieinian A lia miy likatmi. Uniki-ulai miana miy edonna mhierun nana A naniai'ru la A te'mu, me Adiella roma nhio'la me Alier la mehra-mau mana miy edonna mtiomra-mniah'a pa mtiulla-msiayn A'u.” ");
INSERT INTO lex_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Noma mak kden la malwiru re rakot la riwra: “Matroma, mowenia amamkeka Omuplara me tiermu kerna pa ami edonna mal pa Mu'una-muemnu? Onde O' emolmolan neka mak kahulti-kahamra onde mak kaniki-kalai onde mak kamehra-kamau me maka kden la roma nhio'la ralamni pa ami edonna mtomra-mnah'a pa mtulla-msayn O'a?” ");
INSERT INTO lex_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Noma A'ukot la giwra: “Totpena miatga, la'pa miy edonna mhima-mrie'a A i'nu-na'ru mak kakleh weli, de emekwalima miy edon mhima-mrie' olek A'u.” ");
INSERT INTO lex_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pede hota rala niukum lawna ra rukmua hare pa nodi liarni, mere la'pa riy mak kaplol la Uplerlawna yamkekni de hota rmormiori lia mormiori plalahwa pa nodi liarni.” ");
INSERT INTO lex_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","La'pa Yesus Nwatutga hare honona pa nhorwua noma Nakot la maka ha Nwatutu-nwaye'a re Niwra: ");
INSERT INTO lex_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Hyal miy re, miatg oleka wa tre' ma'ta lera woru na'nama lerlalawna Yahudi ntutu-nte'ewa, de Paska lerni (maka Yahudi re rhoratreria tuini-wedni la' ler maka ha rlergot la Mesir). Ne hota la' ler de Rimormiori A'na A' die, ral A' pua la'pa rwairia A lia auwlakra hananni.” ");
INSERT INTO lex_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","La' ler de imam-imam o'tani-matni ror wutga Yahudi in letni-am letni rawok la Kayafas likatni, la'a imam lawna Kayafas genni. ");
INSERT INTO lex_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","E rawok pa rna'ohma Yesus pa rtorna wunwunmua totpena rwenna. ");
INSERT INTO lex_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mere riwra: “Yan memmemna rhi'a la'a lera maka ha riwra ramuki-rahepur la re, yoma hota lima-rora kokokna-rariarni.” ");
INSERT INTO lex_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","La'pa Yesus Nden la leta Betania, la'a Simon maka ululu de klernana nnienia ulityata genni. ");
INSERT INTO lex_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Noma patke' ida nmai Yesus de, de nodia potla ida maka ha rhi' nana la watu-watu mak welli werta, de npenpuen lia wu'ru huwua mikmikri mak welli werwerta wali. La'pa Yesus Nana'an reri dewade pat de nwalia wu'ru della Yesus o'tani wawannu. ");
INSERT INTO lex_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","La'pa maka Yesus ha Nwatutu-nwaye'a re ramkek nana hade dewade rawenna. Riwra: “Hya' ed mak krei piede nhuri-nwal dioinia wu'ru mak kalwel wierwerat dena?! ");
INSERT INTO lex_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","La'pa na'olga wu'ru de ho'mana nlernan kupna harahu pa welli de hota rala la riy maka kakleha-kaplara.” ");
INSERT INTO lex_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Mere Yesus Natg oleka hya' maka irakota noma Nakot la re: “Hyal miy re, nihya'pa mikot emkade la patke' dina?! Hade nhi'a ha samomuou mai A'u. Miolin doin e' pa nhi' samomuou A lia dodo'ondi to'a ");
INSERT INTO lex_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","yoma A'g edon gor miy pia nodi liarni. Mere riy makakleha-kaplara re nhi'inde e ror wutga miy totpa mtiulan la' ira. ");
INSERT INTO lex_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ha nwalia wu'ru de pa na nwahi' A' pua rtamni A'u. ");
INSERT INTO lex_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mpiesiayo, la'pa rakot nohora Uplerlawna Kot Kalwiedni la noh di wawannu uhunu-ewatni, de irakot nohor walia patke' de hihi'ini-yapyapni totpa rira rhoratrereria e'a.” ");
INSERT INTO lex_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Noma la' riy id la'a riy termida wehrani woru maka Yesus ha Nwatutu-nwaye'a re de nwawa Yudas Iskariot nla imam re o'tani-matni pa ");
INSERT INTO lex_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","nod lir la re niwra: “Am miy re, hota hya' ed maka miala mai a'u totpena agala Yesus tiy miy?” Noma rpair nieka kupan pi'ra terampwotelu tututu pa rala la Yudas. ");
INSERT INTO lex_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Noma Yudas nla nwahakhak talla emkameni pa ntorna Yesus totpena nala la Yahudi o'tani-matni re. ");
INSERT INTO lex_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","La'a lera yanullu la lerlalawna maka Yahudi re ha ra'ana roti mak kakleha tgo'a, noma maka Yesus ha Nwatutu-nwaye'a re rmai pia rakot la Yesus riwra: “Tuna, hota ampahi' targa ya'anlawna-yemunlawna itodi itsoratreria it tuini-wedni la' Mesir de la' hanmeni?” ");
INSERT INTO lex_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Noma Yesus Nakot la re Niwra: “Mlia' letlawna pa mikot la riy ida maka A'ukot targ oleka tiy miy, pa mikot la miwra: “Hyalia, it tungkurnu Niwra Ntu'tg olek la lerni pa hota Enmat wia. Pede Eniwra Nora maka ha Nwatutu-nwaye'a re rhi'a ya'anlawna-yemunlawna Paska la'a o rommu di.”” ");
INSERT INTO lex_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Noma maka Yesus ha Nwatutu-nwaye'a re rhi'a hya' ed maka Yesus Nakota rella. Noma rla' pa rwahi'a-rwayod tiarga ya'ana-yemnia Paska. ");
INSERT INTO lex_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","La'pa nmel wa, noma Yesus Nora maka ha Nwatutu-nwaye'a termida wehrani woru re ra'an wut lia mei wawannu. ");
INSERT INTO lex_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","La'pa rtepartarlia ya'ana dewade Yesus Nakot la re: “Mpiesiayo! Hota la' riy id tiy miy die hota eniwra na'olga A'u.” ");
INSERT INTO lex_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","La'pa ratlin nan hade de honona rmalui-rmaher doin la. Dewade rima-rima ratiana Yesus riwra: “Matroma, hota a'g edonno?” ");
INSERT INTO lex_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesus Niwra: “Riy maka kor rewre'wa A' pua mto' wutga roti la'a lari niemun geni pa emeka tema raralamni nhi'inde rhi'a, de hota e' ed mak ka'olg A'u. ");
INSERT INTO lex_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Plola, hota Rimormiori A'na A' die hota Amuati, emeknekama e rhorat targa la Puka ralamni. Mere hota la'pa he' ed mak ka'olga Rimormior A'na de, adoh! Riy de hota nler meman la yatyatni-halalli yatlorni-yatra'ani. Samomuounu de edon ra'a'n nan walia e' la noh di wawannu.” ");
INSERT INTO lex_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Noma Yudas mak kiwra na'olga Yesus nakot la Yesus niwra: “Tungkurga, a' niek de edonno?” Noma Yesus Nakot la: “Plollolli de o'a!” ");
INSERT INTO lex_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","La'pa rara'an reri noma Yesus Na'ala roti, na'nama Na'uli-nawedia Uplerlawna. Nhor nioma Nhawi-nhawia rot die na'nama Nhakre'era la maka ha Nwatutu-nwaye'a re na'nama Niwra: “Mia'ala pa mi'ina. Hadi de A ino'nu inhatti.” ");
INSERT INTO lex_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nhor nia'nama Na'ala lari maka rkeni anggur turnu na'nama Na'uli-nawedia Uplerlawna na'nama Nala maka ha Nwatutu-nwaye'a re, me Niwra: “Hononmi mnimit la (miemnu). ");
INSERT INTO lex_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yoma A ra'ru inhatti maka khi'a aplola Uplerlawna nnio' warwuarnu me rar maka ha rhuria pa Namou-nawitna riy liawanni. ");
INSERT INTO lex_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mpiesiaya, hota A'g edonna gemnu owa'ana anggur turnu pa la'pa nte'ela' lerni Agor miy pia temun wutga anggur tur warwuarnu la'a A A'mu genni maka Ntorna-nrautu emeka Ray.” ");
INSERT INTO lex_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nhorwua noma rwahniara nhiara ya'uli-yawedi id la Uplerlawna. Nhor diewade rla'awa la'a wo'ora Saitun. ");
INSERT INTO lex_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Noma Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: “Hota la' mel di nekpa miy hononmi miwlar dioinia A lia yoma la'a rira hihi'ini yatyatni mai A'u. Yoma Puka ralamni de e nakot nohora Uplerlawna lirni niwra: “Hota Awuenna makhuri-kwa'an de ne hota nhiuri-wnia'anni knunu-knera.” ");
INSERT INTO lex_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mere la'pa ramori-ralewna A'g owa'ana de hota A'g e ula' ul miy lia Galilea.” ");
INSERT INTO lex_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Noma Petrus nakot la Yesus: “Pen neka mutu korni hota rawlar dioinia O la Tuna, mere a' di de akti id mana a'g edonna wuadur la O' onmu.” ");
INSERT INTO lex_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","“Mhuoratreria Petrusa. Plola la' mel di memna de hota hiwi lallu edonna nkukule' ma'ta de, hota omueh'a nekpa mrieher doin A lia' re'eni wotelu.” ");
INSERT INTO lex_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mere Petrus nakot la Yesus Niwra: “La'pa it rewre'wa tler la wniunu-wnienna ho'mana hota a'g edonna ga' pua rieher doinia O'a Am ee!” Ne maka ha Nwatutu-nwaye'a re honona mana lirni emekwalima Petrus lirni. ");
INSERT INTO lex_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nhor nioma Yesus Nora maka ha Nwatutu-nwaye'a re pa rla'awa geni ida mak kwawa Getsemani. La'pa rden la hande noma Enakot la ira: “Mpiei pia mimtatan la handi. Pena A lia siumbaini.” ");
INSERT INTO lex_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Noma Nakot la Petrus nora Sebedeus a'nani rora, de Yakowsi nor Yohansi pa rmemeh'a ror rewre'wa E' pa rla'a. La' mel de Yesus ralamni Nmayo'a-nmataw dioin la. ");
INSERT INTO lex_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Noma Nakot la mutwualli re Niwra: “A ralmu emeka nmolu-nhelma pa emeknekama hota Amuat mie! Mdien nek la handi pa mimatmat pa msiumbaini.” ");
INSERT INTO lex_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Noma Yesus Nla oliet kuku'a la'a gen die na'nama Nler inonni pa Nwaltiora-nwaltieman la tani wawannu pa Nsumbain Niwra: “Am ee! Awuak pa Ompuayow de, Muhal doinia kropna-krieutu mak hota Atiutulu-lielew niana ri. Mere yana Mliernohor maka A ralmu ha nwaka mere plolli nek tiy O'owa Ama!” ");
INSERT INTO lex_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nhor nioma Yesus Nawal pia Nla Ntomar la mutwualli re wotelu, mere Nla' de wotelu e ranin hala. Noma Yesus Nakot la Petrus Niwra: “Eneknek to'ama jama id ho' pa taken niana mimatar nohor A'u?! ");
INSERT INTO lex_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mimatmat pa msiumbaini totpena yana hegana amlawanni nreh nian miy pia mlier la do'a-hala ralamni. Yoma plolli pa miy miwra mliernohor A ralma-rio'ru mere ta'en niana mhi' nana.” ");
INSERT INTO lex_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Noma Yesus Nla Nsumbaini owa'ana pa Niwra: “Ame! La'pa Omiwra yawuhi-yawe'et di ntut nian A'u, de taken niana Awuaniklia-wuayotlia de, mere nden nek la O wa Ama.” ");
INSERT INTO lex_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Noma Yesus Nawali owa'an pa Nla Ntomar la mutwualli re wotelu mere e rtepartar yanina yoma matni werat rehia. ");
INSERT INTO lex_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pede Yesus Nal targ owa'ana la re'eni wotellu pa lirni la Amni de emkade wali. ");
INSERT INTO lex_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nhor nioma Nawali owa'an pa Nmai pia Nakot la mutwualli re Niwra: “Minin ma'ta miy?! Mitlina! Nte'ela lerni wa pa Rimormiori A'na A' die ra'olga A lia riy maka khi' do'a-hala. ");
INSERT INTO lex_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mimata, mai pia tla' pa twatroma riy mak ka'olga A'u, nmai wia dee!” ");
INSERT INTO lex_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","La'pa Yesus Ntepartar mua'ta la yaltieri, dewade Yudas maka nhi'inde kre'ela maka Yesus ha Nwatutu-nwaye'a la riy termida wehrani woru re, enmai wia, de nor wutga riy mutlialawna woka ida, de rodia wehla plalahwa, me aukakaklu. Imam o'tani-matni re me Yahudi in letni-am letni er mak khopan pa mutu rmai pia rtorna Yesus. ");
INSERT INTO lex_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Me Yudas mana Nakot targ oleka la mutnu re hota hya' ed maka ha nhi'a, niwra: “Mitlina, tla' de, de la'pa hameni ed maka akinnia de E' inhatta pa mtiorna!” ");
INSERT INTO lex_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pa la'pa rte'ela gen die, dewade Yudas nod tiemna Yesus pa nakot la: “Kalwiedo tungkurge!” Dewade nkinnia Yesus. ");
INSERT INTO lex_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Noma Yesus Nakot la: “Temana, pleta-plet pa omliernohora o ralma-riormu mak kariei pia ommuai handi!” Dewade riy mutlialawna re rma rwarui Yesus pa rtorna. ");
INSERT INTO lex_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Noma Yesus mutwualli ida nleh dioinia wehlani pa ndawar doinia riy ida tlinni. Riy de nhi' hopopna la imam-imam re o'ta lawanni. ");
INSERT INTO lex_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Noma Yesus Nakot la mutwualli de Niwra: “Hoi! Mkieni owa'an wehlamu della paro'oni. Yoma riy meni mak kahe'iya wehla de hota wehla na'an owa'ana e'a. ");
INSERT INTO lex_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Omuat niekame ta'en niana Agharia A li'ru la A A'mu totpena Nalewan nan A'u?! Hota Nleretniekla Na'enyatga hopopna (malaikat) mak ka'ara lidna termida wehrani woru rehenu totpa hopopanni-lili'irnu re rmai pa rtulan mai A'u. ");
INSERT INTO lex_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mere la'pa hota emkade, de hota emkameni la Puka lirni mak kakot nohora A matmia'tu mak emkadi, de hota ntutu-nte'ewa?” ");
INSERT INTO lex_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Noma Yesus Nakot la riy mutlialawna re Niwra: “Hoi hya' nrei pia miodia wehla ara me kakaklu re ma mtiorn A'u?! Yanpa la' miy wniarormi de A' di de riy yatyata-halala id A'u?! Lera-ler de A'g e wuatutu-wuaye'ela Uplerlawna roma kreini mere miy edonna mtiorn A'u. ");
INSERT INTO lex_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mere ha rhi' emkade totpa naplol nohor la makwohorulu-ktatrulu lirni la' Puka ralamni.” Nhor nioma maka Yesus ha Nwatutu-nwaye'a re honona rawlar dioin E' pa kni'ini-kniewarni. ");
INSERT INTO lex_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mak ktorna Yesus re rodia Yesus pa rla'a imam-imam o'ta lawanni Kayafas de. La' hande de makwatutu-kwaye'a agama ror wut nieka Yahudi in letni-am letni re rawok tar momuog olekwa. ");
INSERT INTO lex_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus de nlernohor reria Yesus, mere edon nwakriania. Noma Petrus nwakdie'da wal pia nodi liarni la riwta ralamni la'a imam lawna romni, pa nre' pa namtatan wutga la' riy mak katiak la' hande. Petrus ralma-riorni de nlernohora, totpena nat muemna hya' maka hota ha rhi' nana la Yesus. ");
INSERT INTO lex_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Imama re o'tani-matni la'pa mak ktorna agama watghudni honona, rahak riy mak kaprir niohora ira totpa ralahar pa rwaghal Yesus totpena rlernan talan pa rukum penna E'a. ");
INSERT INTO lex_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Riy harahu rmai pia rakot nohora hya' ed maka edon kaplola, mere o'ta-mata re edonna rlernana wniatikilgeni totpena rwaghala Yesus. Noma la hohoni dewade riy woru rler la gaini. ");
INSERT INTO lex_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Na'nama riwra: “Hadi de ed mak kiwra E' ed mak karuri-kalai pia kweyata-kwaniawua Uplerlawna roma kreini de, me hota E rurni-laini etla pa Nariri owa'ana krei die la'a lera wotellu.” ");
INSERT INTO lex_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Noma imam lawna naprir pia nakot la Yesus Niwra: “Hoi, hota O edonna Mukot hadom pa Mpuahla nana lira mak kwatiawua etnu-liolli rena? Lira re raplola me edonna?” ");
INSERT INTO lex_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mere Yesus edon Nakot hadomdoma. Noma imam lawna nhari owa'an lirni pa niwra: “Aliokar la Uplerlawna mak kden la Ilyamou-Watyatoha pa nodi liarni, totpa Mutlina. Mpuer tek nurmu la a yatia'nu dina! Hota O' di de Ray Makamori-Kalewna O'a maka Uplerlawna ha Nano'taru, de, Uplerlawna A'nani?” ");
INSERT INTO lex_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Noma Yesus Nakot la: “Emeknekama o lirmu de. Mere miy hononmi mpiesiayo! Hota la' ler id de hota mimkek memna, Rimormiori A'na A'umtatan la Uplerlawna-Mempulwatnu mak kodi plolli walli malganna ne hota Amuai die Agodia kakma la'a lyanti tutulu.” ");
INSERT INTO lex_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Dewade imam lawan de nawenan pa nlihira-nnaiya rain plalah wamueheni yoma nwarora de Yesus de rimormior tio' E'a, na'nama niwra: “Adoh! Riy di e nalernu-naha'a Uplerlawna kotni-nanni yoma Enakot Niwra Uplerlawna A'nani E'a. Yan itwei pia riy rakot nohora E halli. Miy hononmi e mitlin walia E lirni de e Napolu-naliella Uplerlawna toh?! ");
INSERT INTO lex_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Pa emkameni la miy ralma-riormi. Mietlia wa.” Noma honona riarin pa riwra: “Ha Nhi' oleka do'a-hal la Uplerlawna! Niukamnu mak klol talanni de totpa rwunu-rwenna!” ");
INSERT INTO lex_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Dewade krurui-kpirpir la Yesus gaini ralamni na'nama rdupla. Ne riy dom to'a rmai pia rpahara malwiru-malganna Yesus killi. ");
INSERT INTO lex_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Rahe'i-ramal niohor E'a pa riwra: “Hoi Ray Makamori-Kalewna nek O'a maka Uplerlawna Nano'taru demade Mpuet tek la, he' ed mak kpahara O'a dena!” ");
INSERT INTO lex_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ne Petrus namtatan nek la'a riwta ralamni la'a imam lawna romni (totpa nat niohora hota rhi'a hya'a la Yesus). Dewade pat makhoi-ktani ida nmai pia nakot la Petrus niwra: “Nhi'inde omuor wutga riy mak kor Yesus riy Galilea de mila' wutu.” ");
INSERT INTO lex_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mere Petrus nreher la' honona re gaini ralamni niwra: “A'g e uplin niohora lirmu-tunmu de lie'erni.” ");
INSERT INTO lex_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Noma Petrus nwatitin la hande pa nla'awa riwta nhiarni onni. Noma pat makhoi-ktani id to'a nlol hande pa namkeka dewade nakot la riy mak kden hande niwra: “Emekneka riy di dodo'ona e nor walia Yesus mak kwatiawua Nasaret de talla.” ");
INSERT INTO lex_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Noma Petrus nreher owa'an pa nlokra-nhautu niwra: “Itmatromni Enamkek reri me a'g edonna gat niohora riy de halolola.” ");
INSERT INTO lex_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Edon nalo'on wali ne riy mak kden hande rmai pia rakot la Petrus riwra: “O inhatti manoo! Yana mriehera, yoma ami e matlina o niareimu-wniahaurmu pede o'a di mak klernohora Yesus inhatti!” ");
INSERT INTO lex_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Noma Petrus ntan limni la heyanan pa nlokra-nhautu niwra: “Uplerlawna Namkek reria me a'g edonna gat niohora riy de. Uplerlawna nhiakar lokarni mai a'u la'pa agat niohora riy de ha lolola.” Plinu-plinnianamde hiwi lallu nkukule'ewa ");
INSERT INTO lex_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","na'nam de Petrus nhioratni nko'i nana Yesus lirni de Niwra: “Hota la hiwi lallu edon nkukule' ma'ta de hota omrieher nan olek A lia re'eni wotel wua.” Noma Petrus nlergot la gen die na'nama nahedge'du la kniakru. ");
INSERT INTO lex_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","La'pa yawyawar ma'ta dewade imam-imam o'tani-matni honona rora Yahudi in letni-am letni rwahu'ru lira totpena retlia Yesus wnienanni. ");
INSERT INTO lex_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Noma rwutga Yesus limni na'nama rodia la Pilatus, mak kla'a gubernur it la Yudea la horta-hairia Romawi. ");
INSERT INTO lex_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","La'pa Yudas mak ka'olga Yesus de namkek de ir reti olek la Yesus niukamnu de hota rwenna, dewade Yudas ralamni nwaldioinia pa nmawal doinia la' Yesus. Noma Yudas npolan doin owa'ana kupan pi'ra terampwotelu rella imam re o'tani-matni rora riy Yahudi re in letni-am letni ");
INSERT INTO lex_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","pa nakot la re: “Aghi' oleka do'a-hal wa yoma a'u'olga Yesus mere hade edon nhala. Ne dodo'ondi de rukum penna.” Mere honona riwra: “Amaplin niohora oleka hade wa. O yat wuamuehemu to' hade.” ");
INSERT INTO lex_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Noma Yudas nrinnia kupna rella krei ralamni na'nama nla' pa orgahi nla nwair wen inonni. ");
INSERT INTO lex_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Imama re o'tani-matni ratopla kupna re pa riwra: “Kupna ri de, rara welli. Ne hota agama deullu-tatarni de niwra yana tal wutga la kupna krei.” ");
INSERT INTO lex_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Noma honona rwayow pa rnairia kupna pi'ra re pa ra rawelia tan miaka riy mak kayapi kekna-rana, gahani de. Rawelia tan die pa rhi'a la do'ona-dakna tniamin matgenni. ");
INSERT INTO lex_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","La' hade pede la'awa dodo'ondi mana rweta tan die nanni de Rar Tani. ");
INSERT INTO lex_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ir hihi'ini-yapyapni de emekwalima la hya' maka, makwohorulu-ktatrulu Yermia lirni la Puka ralamni e niwra: “Ira' nan neka kupan pi'ra terampwotelu tututu pa ra raweli E'a. Riy Israel nekane rwayow nohora E welli de. ");
INSERT INTO lex_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ne kupan de irnairia pa ra rawel tiani maka riy mak kayapi kekna-rana gahani pa emeknekama Orgahi-Orha'a Nakota mai a'u.” ");
INSERT INTO lex_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","La' pa Yesus Ntutrier lia Pilatus makla' gubernur la hande, gaini ralamni. Noma Pilatus natiana Yesus Niwra: “Plola O' di de ray Yahudi id O'a?” Noma Yesus Nwalolla Niwra: “Emek lir mak omukot de!” ");
INSERT INTO lex_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mere la'pa imama re o'tani-matni me Yahudi in letni-am letni re rwaghal E' la Pilatus gaini mere Yesus lir ta'a-waw ta'a. ");
INSERT INTO lex_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Noma Pilatus nakot la niwra: “O e Mutlin nana irwaghal o'ola lira-tunu harahu me edonna?!” ");
INSERT INTO lex_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mere ir yaklakni emkade ho'mana, Yesus lir ta'a-waw ta' to'owa, pede gubernur Pilatus de nwer rer memna wawni. ");
INSERT INTO lex_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","La'a Yahudi lerlalawanni di maka ha rhoratreria tuini-wedni, de gubernur hairi Roma, Pilatus de, nhi'inde nolin doinia Yahudi id la'a roma nhio'la totpena nhi' ahepru Yahudi ralamni. Enolin doinia riy maka Yahudi mutlialawna re ha rwalir niana. ");
INSERT INTO lex_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","La' ler di, de riy maka Yahudi liawanni rwalir niana de Barabas. E' de mak kmalawna ray Romawi me Yahudi re rwetwet la e nanni. ");
INSERT INTO lex_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pede la'pa rirahu rawok taru, noma Pilatus natiana re niwra: “Hota mimpiayow de he' ed maka agolin doinia pa nawok temn owa'an tiy miy, Barabas, onde Yesus maka ha rweta la Makamori-Kalewna maka Uplerlawna Nano'taru?” ");
INSERT INTO lex_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus natian emkare la rirahu re yoma Pilatus e nat niohora ina-ama leta re mniotni rala Yesus la e'a, yoma honona re ralamni ramehra la Yesus. ");
INSERT INTO lex_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mere la'pa Pilatus namtatan ma'ta la liwangeni nhiudi-pniara, de Pilatus patke'eni na'enyatga nnio' id la Pilatus de niwra: “Yan memmemna omrie'ela riy mak kwaghala riy di maka edonna khala. Yoma la' hade pede a'g e liernana mi'a-lo'a maka khi' amta'at a lia' orawi.” ");
INSERT INTO lex_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mere imama re o'tani-matni rora riy Yahudi in letni-am letni rtekal rer tio' la totpena rirahu rwaka Pilatus rolin doinia Barabas, ne rwahak pa rukum penna Yesus. ");
INSERT INTO lex_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Noma Pilatus natian owa'ana re niwra: “La' ha rora ri de mimpiak hameni pa a'ulgota?” Noma honona rhaunu: “Barabas!” ");
INSERT INTO lex_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Hade emkade, aghi'a hya'a la Yesus maka ha rweta la Ray Makamori-Kalewna maka Uplerlawna Nano'taru dina?” Noma honona rhaunu pa riwra: “Mpuairia la auwlakra hananni!” ");
INSERT INTO lex_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Mere halli hya'a pede?” Noma honona re yeher to' pa rhaunu-rhaunu riwra: “Mpuairia la auwlakra hananni!” ");
INSERT INTO lex_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","La'awa hohoni de Pilatus nat muemna de taken niana e nhi' hadomdoma, onnila riy riwra rhi' kokokanni. Noma na'al gera pa nohma limni la rirahu re gaini ralamni (pa ntutga de, e' edon nre' wut pua nwaghala riy mak edon khal di), na'nama niwra: “Hota a'g edonna ukwara hihi'a-yapyapi matmiat di la' hadi wawannu. Miy yat wamuehemi to' hade.” ");
INSERT INTO lex_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Noma riy honon re rhaun pa riwra: “Muolin doin nek la pena amor up mamni-a'na mamni mak kwara matmiatni de.” ");
INSERT INTO lex_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Noma Pilatus nolin doinia Barabas la pa nala la ira, ne nhopan pa riy rliwra Yesus. Na'nama nala pa rla rwairia la auwlakra hananni. ");
INSERT INTO lex_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","La' noma makodi keki-rautu la'a Pilatus genni-tienni rodia Yesus pa rler la gubernur Pilatus romni na'nama rpolg awoka makodi keki-rautu korni re lidna-lidan pa rma rpepan reria Yesus. ");
INSERT INTO lex_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Rte'la la Yesus naniayarni pa ro'lu dioinia, ne rohoga emeka ray-ray naniayarni plalahwa mak ungu la Yesus. ");
INSERT INTO lex_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Noma rhi'a wutu-lai ida de rnairia pu'na-kiarit ruri pa rkow nana la Yesus o'tani. Nhor nia'nama rkenia lie'ena id la limni walli malganna, na'nama rwaltiora-rwaltieman la gaini ralamni pa rahe'i-ramalia pa rakot la riwra: “Mmuormiori plalahwa Ray Yahu'du ne!” ");
INSERT INTO lex_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Honona rakrui-rakpira na'nama ra'ala lie'en de pa ra rliwar reri o'tani. ");
INSERT INTO lex_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","La'pa rahe'i-ramalia na'nama ral doinia naniairia ungu della pa rohog owa'ana naniair wamueheni. Nhor nioma rodgiota pa rla rwairia la auwlakra. ");
INSERT INTO lex_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Makodi keki-rautu re rodgiota Yesus pa rler la talan letgara de rwatrom nana riy ida nwatiawua Kirene, nwawa Simona. Noma ha rhopan pa riy de nakwara Yesus auwlakarni. ");
INSERT INTO lex_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","La' noma rte'ela gen miaka ha rweta la Golgota, nnia'eratni de: Riy Ruri-Kliaklu Genni. ");
INSERT INTO lex_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","La' hande noma rala atiaw mak kmermeru id mak rawniah'a la anggur turnu pa rala Yesus Nemnia totpena mehrani nmolu. Mere la'pa Yesus Ndihmia anggur tur die, noma Nahmena Nemnia. ");
INSERT INTO lex_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nhor nia'nama rwairia Yesus la auwlakra hananni. Na'nama rdurmu-rhakra Yesus naniayarni de rnairia patui (undi). ");
INSERT INTO lex_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Nhor nia'nama ramtatna pa ratiak reria la hande. ");
INSERT INTO lex_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","La Yesus o'tani wawannu de rhorat targa la auganna ida, de rakot nohora hya' maka Yahudi o'tani-matni re rto'on reri E halli pa rhorat de riwra: “Hadi de Yesus, Yahudi Rayni inhatti.” ");
INSERT INTO lex_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","La' hande wali pia e rken wialia riy wor lia auwlakra yoma rrora rpera-rdaitia deulu-tatra hairi Roma. Rkenia id la Yesus walli malganna ne id la'a Yesus walli malwiru, ne Yesus Nden la letgara. ");
INSERT INTO lex_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mak klola hande rdik o'tani la me rwohora-rtatra me rahe'i-ramal lia Yesus. ");
INSERT INTO lex_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Rakot la Yesus riwra: “Oi! O ed mak kiwra kwaye'er doinia Uplerlawna roma kreini nampena Omuriria owa'ana la' lera wotellu. La' pa plola pa Uplerlawna A'nani O'a de Muerun la auwlakar de hananni, ne Mulewna inonmu.” ");
INSERT INTO lex_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Emkade walia imama re o'tani-matni rora makwatutu-kwaye'a agama me riy Yahudi re in letni-am letni rapolu-raliella Yesus ");
INSERT INTO lex_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","riwra: “E' de Namori-nalewna riy meheni, mere inon wamueheni de takeni Nalewan nana. La'pa ray Israel id E'a de tamkek teka hota Nerun la auwlakar de hananni totpena tpesiaya. ");
INSERT INTO lex_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Enpesiaya Uplerlawna me Niwra E' de Uplerlawna A'nani E'a. Ne mai pia tamkek teka hota Uplerlawna Namori-nalewna E' me edonna?” ");
INSERT INTO lex_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Riy maroro'a re la auwlakra re ho'mana rapolu-ralielan walia Yesus la auwlakra hananni. ");
INSERT INTO lex_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","La lera nwawuau ro'onni (jam termida wehrani woru) mere la'a noh de tetema nekpa mel'uta-maliena nodia pa lera nher miemna (jam wotellu). ");
INSERT INTO lex_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","La'pa edon nhal de jama wotelu, dewade Yesus Nhaun pa Niwra: “Eli, eli lama sabaktani?” Ha nnia'eratni de niwra: “Uplerlawnu ne, Uplerlawnu ne nihya'pa Omuolin limmu-mpue'er rormu mai A'u?” ");
INSERT INTO lex_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Riy wo'ir mak erla hande e ratlin nana Yesus lirni, na'nama riwra Yesus e Npolga Elia. ");
INSERT INTO lex_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Noma ir mutwualli ida plet pa nawlar pia nla na'ala kuliai, na'nama nto'a la anggur turnu mak milmilu na'nama nkenia la au tutnu pa ntania la Yesus nurnu totpena Nemnia. ");
INSERT INTO lex_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mere mak kden hande korni riwra: “Twei pleini. Yanpa Elia nma ntulan la E'a?” ");
INSERT INTO lex_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nhor nioma Yesus Nhaunu owa'an dewade Nwaran doinia aranni. ");
INSERT INTO lex_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","La mtatande nekpa kok lawna maka ra rahew tiarga liolgeni la'a gen mak kmou-kwitna la Uplerlawna roma kreini ralamni totpa riy edon rler la rialam de, ema rlihirwah'a la' woru la' heyanna pa ntut mueman la yawa. Ne noha nruru me watu lialawna mana poka-pah'a. ");
INSERT INTO lex_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Hoi-kietra ratpopoini ne Uplerlawna mutnu-rahanu harahu mak kmati olekwa re, de rmori owa'ana. ");
INSERT INTO lex_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Rlergot la hoi-kietarni. Ne la' ler maka Yesus Nmori owa'an la matmiatni de ralamni, de mak kmori owa'ana re rodi liarni la'a Yerusalem, de Uplerlawna letni de. Ne la' hande mana rirahu ramkek ir wali. ");
INSERT INTO lex_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","La' ler de mak khi' o'tani la lidna makodi keki-rautu rahu ida me mak katiak reria Yesus la hande honona rdiwra-rda'ala yoma noha nruru die nor wut nieka hare honona mak ha ramkek nana re. Noma idma nakot la ida: “Hadi plola! E' de de, Uplerlawna A'nani E'a.” ");
INSERT INTO lex_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","La' hande de patke' rahu e ror wal pia rden nek la oliet pa e ramkek reria. Ir de ed maka klernohor reria Yesus la' ler maka Nwatiawua Galilea pa Nmai totpena ramkek la ya'anni-yemannu, rpo'a-rpahi'a Yesus hyonni-hyanni. ");
INSERT INTO lex_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","La' ir mutnu de, Maria Magdalena, me Maria, de Yakowsi me Yusup inni, ror wut wualia Sebedeus hawni, de Yakowsi me Yohansi inni, e rtutrieri. ");
INSERT INTO lex_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","La' lera ntuini de riy mak ktaru ida mak kwatiawua Arimatea nmai lia Pilatus. Nanni de Yusup. E' mana nhi'inde nlernohor reria Yesus. ");
INSERT INTO lex_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nmai pia nla nwak la Pilatus totpena na'ala Yesus inonni mak kmati olek de. Noma Pilatus nhopan pa rla rala Yesus inonni della. ");
INSERT INTO lex_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Noma Yusup nla na'ala Yesus inonni na'nama nala kok lawna warwuaru mak kamnurnuhru pa na ntomna. ");
INSERT INTO lex_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Na'nama nle'er targa la'a liena maka na'nama Yusup ha nawte'ta nande totpa hota nmeh'a nnairia. Mere hoi-kietar de edonna rnairi et mia'ta la'a mati doma. Nhor nia'nama nwaklol tiarga wat liawna id pa na nherit targa lien de nhiarni pa nhor nioma nla'awa. ");
INSERT INTO lex_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Magdalena nora Maria id wal pia ramtatan la oliet kuku'a la hande pa ramkek rer lia lien de. ");
INSERT INTO lex_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","La'pa repra wa, de Sabat lerni noma imama re o'tani-matni me riy Parisi re, rla' rewre'wa pa rla'a Pilatus de. ");
INSERT INTO lex_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Noma rakot la Pilatus riwra: “Tuna, ami e mhoratreri mia'ta la'a Yesus makalahar de Nmormiori mia'ta, de Nalahar pa Niwra la'pa lera wotellu de hota Enmori owa'ana. ");
INSERT INTO lex_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","La' hade pede ampak pa tuna nala mak katiaka re de ratiak toto' memna la'a lien de pa la'pa lera wotellu nlardoinla. Yanhi'pa la'awa lera wotellu noma maka ha Nwatutu-nwaye'a re rkamna'a mak kmat die inonni, totpena riwra Enmori olekwa. Ne hota putra-palka hohoni di de narehi owa'an la mulaliaini la' Eniwra E' de Ray maka Uplerlawna Nano'taru inhatta.” ");
INSERT INTO lex_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Noma Pilatus nakot la re: “Miodia makodi keki-rautu mak katiaka. Hononmi la mitiak apitga.” ");
INSERT INTO lex_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pede rla'awa la'a lien de wa pa rahro'pa targa lien de nhiarni me yatiaka npitu-nkor la totpena yana riy rma ra'ala mak kmat die inonni la'a lien de. ");
INSERT INTO lex_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","La'pa Sabat lerni lardoin wa dewade yawyawar ma'ta la krei lerni, la'pa lera matni npah'a, de Maria Magdalena nora riy id wali mak kwawa Maria, rla' pa ramkek la lien de. ");
INSERT INTO lex_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Dewade plinu-plinnianama noha nruru (upkarururu) mak karur miemna. Yoma Orgahi-Orha'a hopopanni ida nwatiawua Ilyamou-Watyatoha pa nernu. Nmai pia nwaklolia wat muaka ra rherit targa liena nhiarni de na'nama namtatn apitga la wat die wawannu. ");
INSERT INTO lex_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hopopan de gaini de emeknekama tlena, me naniayarni lelera. ");
INSERT INTO lex_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ne makodi keki-rautu mak katiak reria lien de rdiwra-rda'al nohora yamta'atni pa nhi'nande rtuini pa emekto'a riwra rmati. ");
INSERT INTO lex_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Noma Uplerlawna hopopanni de nakot la patke'a re niwra: “Yan mimta'ata. A'g e gatga de miy mia mihaka Yesus maka ha rwairia me inonni nmat lia auwlakra hananni. ");
INSERT INTO lex_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Hade edonna Nden olek la handi wa. Ha Nmori olekwa emeka E lirni maka Ha Nakot oleka tiy miy lia ler ululu. In miy re, mai pia mimkek tek la gen miaka ha retar targa Yesus inonni de. Mimkeka, Ha inonni edon nden olek la wa. ");
INSERT INTO lex_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pede pena mlia' meman wa la pa mlia mikot nohora la E mutwualli maka nhi'inde ha Nwatutu-nwaye'a re, miwra: “Yesus Nmori olekwa. Ne hota Enala'ul miy lia Galilea totpena miora mpiatrom la hande.” Hya'a ed maka a'ukota ri, de E nnio'oni tiy miy.” ");
INSERT INTO lex_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pleta-plet pa patke'a re rto'or la hoi die pa rawal wia. Ramta'at wenna mere la' ralamni re rahepuepru memna pa rawlar pia rla pa rakot nohora harella' riy maka Yesus Nwatutu-nwaye' oleka re. ");
INSERT INTO lex_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Er ma'ta la talan ralma de plinu-plinnianama Yesus Nhar gaini la patke'a re pa Niwra: “Kalwieda nar miy re!” Noma rmai pia rwakriania Yesus pa rwaltiora na'nama rkolla lakni pa ruh' idma-rrama lia'ar la. ");
INSERT INTO lex_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Noma Yesus Nakot la re Niwra: “Yan mimta'ata. Mlia pa mikot la A a'mu-hya'lu pa rla'awa la Galilea totpena twatrom la hande pa ramkek A'u.” ");
INSERT INTO lex_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","La'pa patke'a re ralala' rer mia'ta dewade mak katiaka re doma rla rod kiot la leta la imama re o'tani-matni la'a hya'a maka ha ramkek oleka re. ");
INSERT INTO lex_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Noma imam o'tani re rora riy Yahudi re in letni-am letni rna'ohma pa rala kupna riwnu-riwnu la mak katiak reria lien de. ");
INSERT INTO lex_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ne rano'a re riwra: “Pen mikota miwra: “Maklernohor reri Yesus re rma rwuri-rgalma melmel nana Yesus inonni, yoma amanin hal ami.” ");
INSERT INTO lex_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ne la'pa gubernur Pilatus natlin nan de pena am ma'ursia pa yana gubernur de nukum miy.” ");
INSERT INTO lex_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Noma mak katiak reria liena re, ra'al kupna-kai re wa ne rhi' emeka hya' ed maka o'ta-mata rakot la ira. Rla' rakot nohora riwra: “Maklernohora Yesusa rma rwuri-rgalum nana Yesus inonni.” Ne lir de ed maka Yahudi rodi pa nwewar la noha uhunu-ewatni pa nma nte'ela ler di. ");
INSERT INTO lex_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Maka Yesus ha Nwatutu-nwaye'a termida wehrani ida re rla'awa la' wo'ora mak kden la Galilea pa emek la'a hya' ed maka Yesus Nano'taru re. ");
INSERT INTO lex_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","La'pa rwatroma Yesus la hande, noma rru'u-rtowar pa ruh' idma-rrama lia'ar la Yesus. Mere la ir de dom mana emeknekama edonna rpesiaya. ");
INSERT INTO lex_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Noma Yesus Nwakriania na'nama Nakot la re Niwra: “Plola-mneha la'a Ilyamou-Watyatoha nora nohkerna de ral oleka mai A wua. ");
INSERT INTO lex_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","La' hade pede mlia'awa pa miodkiota-mialde'et nohor A lia noheri woru-lyanit nayanni totpena riy mak kwatiawua noha-rai honona hota rpesiaya me rlernohor reri A'u. Mhiarania re de mpiet la Ama, A'na me Uplerlawna Nhiw Lululli nanni totpena riy ratga de ha rre' olek la A mu'tu-rah'u. ");
INSERT INTO lex_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Mpiatutu-mpiaye'a re pa rlernohor hya' to'a maka A'ukot targa tiy miy. Ne mhioratreria, hota A'g edonna golin miy lia la'pa nodia la noha hohoni.” ");
INSERT INTO lex_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","La' hadi de rakot nohora Uplerlawna Kot Kalwiedni-Paitiotni maka rakot nohora Yesus Kristus, Uplerlawna A'nani. La' mulaliaini de Yohansi nwaga la kniari. ");
INSERT INTO lex_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Enhi' emekto'a hya' ed maka makwohorulu-ktatrulu Yesaya ha nhorat targ olek wa. Yoma makwohorulu-ktatrulu Yesaya ha nhorat targa Uplerlawna lirni maka e Nakot nohora Yohansi kniarni, de Niwra: “Mhioratreria! Hadi ed maka Aghopna. Hota Aghopna hade pa nala' ulg O'a totpena nwahyar tialan pa Omliola. ");
INSERT INTO lex_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Hota e' de polpuolu-hawaunia la wo'orletna-kawurloini pa niwra: “Mpiahi' targa talla la Orgahi-Orha'a, mpiale'era loini-talanni!” ");
INSERT INTO lex_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Emekto'a hya'a maka Yesaya nhorat targa nohora hopopna-lili'iru de, emkade pa Yohansi maka kharani riy nhar lia wo'orletna-kawurloini. Yohansi nhaun pa niwra: “Hoi! Mhioitio'ora-mtiahnei dioinia do'omi-halmi re pa mai pia rharan miy ee! Totpena hota Uplerlawna Namou-nawitan miy lia do'omi-halmi!” ");
INSERT INTO lex_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Riy rahu rehi rwatiawua Yerusalem, me Yudea liewnu rriw niana pa rmai pia ratlin la Yohansi ha nakotkota. Noka ir rakota plele'er momuoga do'oni-halli re, ne Yohansi nharania re la' gerlawna Yordan. ");
INSERT INTO lex_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohansi naniayarni de ra' nana la onta wullu me rewni de ra' nana la ha ulti me ya'anni-yemannu de kongoha nora gani turnu. ");
INSERT INTO lex_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Lir di de Yohansi ed maka nakot niwra: “Hota Riy id mak kreh nian a'u Nmai pia klernohor a' di. Hota awue'er doin lakni wniowni ho'mana a'g edonna puar nana. ");
INSERT INTO lex_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A' di agala gera ga gharani miy mere hota riy mak kmai die, Nala Uplerlawna Nhiwni tiy miy. ");
INSERT INTO lex_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ler maka Yohansi nharanania riy de, Yesus Nmai de Nwatiawua Nasaret la Galilea. Nmai noka Yohansi nharani Yesus la gerlawna Yordan ralamni. ");
INSERT INTO lex_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","La'pa rharania la gera ralamni pa nhorwua noma Yesus Nrei lia gera aratni emkadi de, plin-plinnianama Namkeka lyanti nahniarti ne Uplerlawna Nhiw Lululli Nerun de emolmolla ma'nu lmo'ma maru (merpati) pa ntai lia wawannu. ");
INSERT INTO lex_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Noma ratlin de Uplerlawna Nhar lirni la'a lyanti Niwra: “O' de A A'nu mak Asiayni inhatti. O' ed maka kla' nana A ralmu.” ");
INSERT INTO lex_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nhor nioma Uplerlawna Nhiwni Nodia Yesus pa Nla'awa wo'orletna-kawurloini. ");
INSERT INTO lex_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","La wo'orletna-kawurloini de Yesus Nor wutga pora-dawra, ne hegana amlawanni nta' niana la lera-mela terampwogata. Mere Uplerlawna hopopanni re rma ramkek la E'a. ");
INSERT INTO lex_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","La'pa rtoran nana Yohanis wa pa rkenia la roma nhio'la ralamni dewade Yesus Nla'awa la Galilea lowanni pa Nakot nohora Uplerlawna Kot Kalwiedni-Paitiotni. ");
INSERT INTO lex_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Niwra: “Ina-nara ama-hyali, lerni ntu'tu olekwa di! Ntutu-nte' olek pa hota Uplerlawna Nodi plolli la riy emeka ir Rayni. Pede mhioitio'or doini-mtiahnei dioini do'omi-halmi ne, mpiesiaya Uplerlawna Kot Kalwiedni-Paitiotni.” ");
INSERT INTO lex_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","La'pa lera ida ne Yesus Nala' lola danau aratni la Galilea dewade Namkek nana Simon nor hyalli Andarias ratialtial reria i'na la'a danau de, yoma hare kniarni hade. ");
INSERT INTO lex_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Noma Yesus Nakot la re: “Ee, ma mliernohor A'g ee! Mai pia Awuatut miy totpena la' emkameni la miy mitial reri i'na la dodo'ondi, de hota emkade wal pia mihak rimormiori totpena hota rpesiay mai A'u.” ");
INSERT INTO lex_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Noma rleretniekla rteman taru tialli, ne rlernohora Yesus. ");
INSERT INTO lex_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesus Nodi liarni noma Namkek nana riy id nanni Yakowsi nor hyalli Yohansi e rwalola tiala la puounu ralamni. ");
INSERT INTO lex_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Plet pa Yesus Npolga re Niwra: “Mmiai ee!” Noma raltarga amni Sebedeus la puounu ralamni na'itar wutu Sebedeus hopopanni-lili'irnu re, ne irrora rla rlernohora Yesus lidanni de. ");
INSERT INTO lex_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nhor nioma rla'awa la leta Kapernaum. La'pa Sabat lerni, maka Yahudi re edonna rkar lia, ntutu-nte'ewa, dewade Yesus Nla'awa la gen miaka Yahudi nhi'inde rhi' kreini-iskolli pa Nwatut lia hande. ");
INSERT INTO lex_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Riy rwer rer wiawni la wniatutnu-wniaye'eni de, yoma Nodi plolli (wibawa) pa Nwatutu. Pede wniatutnu de ematia'a makwatutu-kwaye'a agama Yahudi wniatutnu. ");
INSERT INTO lex_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","La'a gen miaka nhi'inde Yahudi rhi' kreini-iskolli la, de riy ida maka hegana nhu'ru ralma. Nhaunu-nhaunu pa niwra: ");
INSERT INTO lex_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus Nasartu ne! Hota Omhi' nan emkameni mai ami oo! Ommuai pia mpieyat ami? A'g e gat niohora he' O'a! O' di de maran yamou-wuhur yatoha (yang suci) maka Uplerlawna Nwalir niana pa Nhopan pa Ommuai lia nohkerna wawannu!” ");
INSERT INTO lex_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Dewade Yesus Nkamota Niwra: “Rhodal nurmu! Rhokargo'tu la'a riy di!” ");
INSERT INTO lex_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Noma yatni-rha'ani de nkahyoi-nkada'al meman neka riy de, na'nama nhaun matmiati dewade nhargot meman la ralamni. ");
INSERT INTO lex_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Riy honona rwer rer wiawni pa idma nakot la ida riwra: “Wniatut warwuaru hya'a eda dina? Naltier die Nodi plolli-ntaryatnu pa Nwatutu. Ne la'pa Nhokargota hegana-kawnu, yatni-rha'ani mana, ratlina-ratailla pa rlergota!” ");
INSERT INTO lex_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","La' hade pede pleta-plet pa Yesus kotni-nanni ema reyapie'era la Galilea uhunu-ewatni-ewatni-lahwani. ");
INSERT INTO lex_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","La'pa rhoitio'or la gen id maka Yahudi re rhi' kreini-iskolli de, noma Yesus Nora Yakowsi me Yohansi rodi liarni la Simon nora Andarias likatni. ");
INSERT INTO lex_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","La' de Simon yananni entepartarlia yanina yoma temni npahna, noma rakot nohora patke' de mehrani la Yesus. ");
INSERT INTO lex_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pede Yesus Nla Nwakriania patke' de yanin genni, na'nama Nte'la la patke' de limni pa Nwagamata, dewade nnienni de nmolu. Noma nla nwahi'a-nwayodia ya'ana-yemun pa honona ra'ana-remnia. ");
INSERT INTO lex_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","La'pa lera ntuinia, dewade rodia riy honona mak kamehra me maka hegana ha nhu'ru ralma pa rla'awa Yesus. ");
INSERT INTO lex_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Rirahu re rmai lia likit de pa rawok la nhiari gaini. ");
INSERT INTO lex_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Noma Yesus Nhi'a riy harahu pa rkalwied la nnieni-nhiena, mehra-mau, me Nhokar dodioinia hegana-kawnu, yatni-rha'ani liawanni. Edon Nhur niohora hegana-kawnu re pa raltieri yoma rat niohora de Ray Makamori-Kalewna maka Uplerlawna Nano'targa E inhatta. ");
INSERT INTO lex_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Repreparrer mia'ta, mela loka-lak ma'ta de, Yesus Namat pa Nla'awa tio'ora. Nla'awa la geni maka hgali, la'a leta to'orni na'nama Nsumbain la hande. ");
INSERT INTO lex_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mere Simon nora talanwalli rla rwahaka. ");
INSERT INTO lex_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","La'pa rwatrom nana dewade rakot la riwra: “Rirahu e rahak O'a.” ");
INSERT INTO lex_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesus Nwahla re Niwra: “Mai pia tokur geni dom to'a, tla'a let mak rehgorgoru re, totpena la' hande mana A'ukot nohora Uplerlawna Kot Kalwiedni-Paitiotni yala'ani, yoma maka katota-kariei pede Amuai olekwa di, de A'ukot nohora Kot Kalwieda-Paitiota della leta honona re.” ");
INSERT INTO lex_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Noma la'pa Nala' doinia Galilea uhunu-ewatni-ewatni-lahwani, me Nakot nohora Uplerlawna lir kalwiedni-paitiotni la roma-lewu maka Yahudi re rhi' kreini-iskolli, ne Nhokar dodioinia hegana-kawnu mak khu'ru ralma riy. ");
INSERT INTO lex_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lera ida ne riy mak kanieni ulityata-temyata nmai noma nwaltior tar lia Yesus gaini ralamni na'nama nwak la niwra: “Amee! Mtiulan mai a'u. Agat niohora de Omuodi plolli pa Mhi' kalwied nan a'u, hornama Ompuayow nohora a wakwa'ku di.” ");
INSERT INTO lex_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesus Nsaynia riy de pede Nran limni pa Nteman la riy de pa Nakot la: “Arieiniana o wakwakmu pa omkialwied wa!” ");
INSERT INTO lex_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mtatan de nekpa nnienni de nmolu. ");
INSERT INTO lex_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Noka pleta-plet pa Nhopna riy de nla'awa ne Nano' matmiat memna riy de ");
INSERT INTO lex_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Niwra: “Hyalia, mhuoratreria! Yana mukot harilla' riy dom owa'ana. Mere mliernohora hya' maka Musa ne'era-ntatar targ oleka, de mlia'a imam ida pa mpuak la totpena namkek memna de omkialwied olekwa. Me muala limtutnu emeka Musa ha nwatut tiarg oleka de totpa riy honona rat niohora de omkialwied olek wa.” ");
INSERT INTO lex_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mere riy de nla'awa la'pa nwe'era Yesus hihi'ini de la he'a-he'a to'a. Hade ed mak karei pia Yesus ta'en niana Nhari wawah'a la leta-ruhuna re ralamni. Ndella leta to'orni, la'a gen miaka hgali. Mere riy rwatiawua meni-meni to' pa rma rapur temna. ");
INSERT INTO lex_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","La'pa lera woru-wotelu rlardoinla dewade Yesus Nmai owa'an la leta Kapernaum, noma rod kiota-ral de'eta de E' etla roma nayanni. ");
INSERT INTO lex_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Noma riy rahu rma rawok la hande pa reiniande geni hamonna, la'a nhiari gaini ho'mana geni npenu. Dewade Yesus Nakot nohora Uplerlawna lirni la rirahu re. ");
INSERT INTO lex_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Noma riy doma rmai die e rodia mak kaliu'uta id la E'a, de riy wogata rhim nana. ");
INSERT INTO lex_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mere la' ler de de riy rahu rehia, pede edonna rlernan talan pa rodia la'a rialma. Noka rwaye'er doinia roma ritni mak kden la Yesus o'tani wawannu, nhorwua dewade ralernu mak kaliu'uta de na'itar neka u'tani maka enanin la wawannu. ");
INSERT INTO lex_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","La'pa Yesus Namkek tutga riy mak kmai re pesiayni raruri, noma Yesus Nakot la riy mak kaliu'uta de Niwra: “Ama, dodo'ondi de A'umou-uwitn oleka do'omu-halmu.” ");
INSERT INTO lex_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dewade makwatutu-kwaye'a agama mak kamtatna la hande rwarora-rwalai la ralamni riwra: ");
INSERT INTO lex_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nihya'pa riy di Naltieri emkadena? Enapolu-naliella Uplerlawna! Yoma atiaru Uplerlawna nanpena Namou-nawitna rira do'oni-halli.” ");
INSERT INTO lex_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","La' ler de meman pa ira ralma-riorni re, Yesus Nat niohora momuoga, pede Nakot la: “Ee, hya' ed mak kariei pia mimpiaror nana yatiana rena?! ");
INSERT INTO lex_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","La'pa plet pa A'ukot nek la mak kaliu'uta di giwra e do'oni-halli ramou-rawitn oleka de, miplin niohor ma'ta plollola pa e do'oni-halli ramou-rawitn oleka me edonna, mere la'pa Apuaran pia A'ukot la e' pa namat pa npopna u'tani pa nala'awa de mimiat niohor memna A ru'ru-la'yu etla yoma mimkek nan memna. ");
INSERT INTO lex_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pede hota la' dodo'ondi de Agiwra tiut muemna tiy miy, la'a noh di wawannu, de Rimormiori A'nani A'g ed mak kodi plolli pa umou-uwitna riy do'oni-halli.” Noma Yesus Nakot la mak kaliu'ut de ");
INSERT INTO lex_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Niwra: “Hyalia, mumat doin la pa mpuopna u'tamu de pa mlia'awa rommu.” ");
INSERT INTO lex_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Dewade mak kaliu'ut de namat doin na'nama npopna u'tani pa nla'awa la'a hare gaini ralamni. Riy honona la hande mana rwer rer wiawni, ne ra'uli-rawedia Uplerlawna. Rwer rer wiawni pia riwra: “It edonna tamkek ma'ta hihi'a-yapyapi maka itamkeka la' ler di!” ");
INSERT INTO lex_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Noma Yesus Nla' owa'an la danau aratni, ne riy harahu rmai tiemna dewade Nwatutga re. ");
INSERT INTO lex_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","La'pa Yesus Nalala' rer mia'ta noma Namkek nana mak kawoka blastena id de nanni Lewi, Alpius a'nani. La' ler de de Lewi e namtatna la gen miaka nhi'inde enawoka blasten la. Noma Yesus Npol lia: “E! Mua mliernohor A'g ee!” Noma Lewi naprir pia nlernohora Yesus. ");
INSERT INTO lex_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","La'pa Yesus e Nana'an rer lia Lewi romni dewade riy harahu maka nhi'inde leta mniotni sukni atia'ala re, emeka mak kawoka blastena me riy mak ha riwra riy dodo'a-halala rmai pia rora Yesus me maka ha Nwatutu-nwaye'a re pa ra'an rewre'wa, yoma riy harahu mak emkare nhi'inde rlernohor reri Yesus. ");
INSERT INTO lex_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Riy Parisi dom makla' walia makwatutu-kwaye'a agama ramkek wali hare. Noma ratiana riy maka Yesus ha Nwatutu-nwaye'a re riwra: “Oi! Nihya'pa miy tungkurmi de Nora mak kawoka blastena, ror wutga riy mak khi' do'a-kyap hiala dom to' pa re ra'an wutu?!” ");
INSERT INTO lex_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","La'pa Yesus Natlin nana yatianni re noma Yesus Nakot la re Niwra: “Mak edonna kanieni edonna rma rahaka dokter. Eneknek to'a makamehra nanpena ed mak kwahaka dokter. Amuai die A'g edonna mua puolga riy mak kiwra irakleha do'a-hala, mere Amuai di totpa Apuolga riy dodo'a-halala pa rhoitio'or doini do'oni-halli re.” ");
INSERT INTO lex_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ler ida ne, maklernohora Yohansi makharani rora Parisi mniotni ratatahan reri lara, ne riy rmai pia ratiana Yesus riwra: “Nihya'pa maklernohora Yohansi re rora riy Parisi ratahan lara, ne maklernohor reri O'a de ra'ana?” ");
INSERT INTO lex_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Noma Yesus Nakot la Niwra: “Emkameni la miy wniarormi dena de?! A' di de emeknekama muanke'a mak kiwra kmehlima. Riy maka rpol niana-rwak nana pa ra'ana-remun la yawoka-yale'u la mehlima-marya'a, de hota edonna ratahan lara la'pa muanke'a muaka kmehlima ntepartar mua't la ya'ana la' mei wawannu toh?! Hade yala'ani atia' hade! ");
INSERT INTO lex_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mere hota la'pa nte'ela la' lerni, nanpena ira'ala muanke'a muaka kmehlim della mak ka'an wutu re onni. La' ler de nampena iratahan lara.” ");
INSERT INTO lex_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Riy edonna rga' pua rala kokanan warwuaru ra rlowna rain mak kawniali. Yoma la'pa emkade de kokanan warwuar die hota napliu'uta-napdiedan nana rain mak kawnial de ne hota na'itar la pritni. ");
INSERT INTO lex_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Emkade wal lia riy edonna rga' pua rhuria anggur tur warwuarnu la'a ha ulit mak mahnek oleka. Yoma anggur tur warwuarnu de hota nhi' nana ha ulit mahnek de ema reye'era pa anggur tur de rhur dioinia ne ha ulit de ho'mana ta'en niana rnair owa'ana. Anggur tur warwuaru de rhuria la ha ulit warwuaru.” ");
INSERT INTO lex_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","La lera id la' Sabat lerni, de Yesus Nora maka ha Nwatutu-nwaye'a re rala'a la nhyi' wetra' lawna ida ralamni, ne maka ha Nwatutu-nwaye'a re rkura wetra' lawna re harni pa ra'ana. ");
INSERT INTO lex_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Noma riy Parisi rakot la Yesus riwra: “Mumkek la me! Nihya'pa maka Mpuatutu-mpuaye'a re rpera-rdaitia it agamni deullu-tatarni yoma ir e rkar lia'a Sabat lerni?!” ");
INSERT INTO lex_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Noma Yesus Nakot la re Niwra: “Miy mpiaik nan olek la'a hya' maka Daud nhi'a la' lera e nora talanwalli re raplara mere rakleha yamanna toh! ");
INSERT INTO lex_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","La' ler maka Abiatar nhi' imam o'ta lawanni, de Daud nler la Uplerlawna roma kreini ralamni na'nama na'ana rot miaka ha ral oleka la Uplerlawna. Nhor nia'nama nal walia roti rella' mutu korni pa ra'an wal lia. Mere la'pa deulu-tatra agama, de mak ka'ana roti re de eneknek to'a imam-imam rmeh'a. ");
INSERT INTO lex_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Uplerlawna Nhi'a Sabat lerni totpa Ntulan la rimormiori. E' edonna Nhi'a Sabat de emeka ler mak kla kwar lawna la rimormiori wawannu. ");
INSERT INTO lex_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","La hade pede Rimormiori A'nani A' die mana, A'g ed mak kodi plolli pa A'ukot nohora hya' ed mak kaplola onde nhala pa itsi'a la Sabat lerni.” ");
INSERT INTO lex_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","La lera id de Yesus Nla owa'an la gen miaka nhi'inde Yahudi rhi'a kreini-iskolli. La' noma Namkek nana riy ida etla hande de limni walli nmati. ");
INSERT INTO lex_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","La hande de riy doma riwra rahaka kahelli-kaha'arni la' Yesus totpena Nhi' de rodia la letgara lawawna (hakim). Pede honona rkil rer lia hota Nhi' kalwieda makamehra-kamau la Sabat lerni me edonna? ");
INSERT INTO lex_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Noma Yesus Nakot la riy maka limni walli kmat die Niwra: “Mai pia mtiutrier lia riy honona gaini ralamni.” ");
INSERT INTO lex_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nhor nia'nama Yesus Natiana riy mak kden la' hande niwra: “La'a agama deullu-tatarni de rakot targa hota it tsi'a hya'a la Sabat lerni? Hota it tsi'a samomuounu me onde tsi'a yatyatni? Tamori-talewna rimormior me onde twaror nohora wniunu-wnienna la it rimormior wialli?” Mere ir rherier tio'owa. ");
INSERT INTO lex_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesus ralamni nmawal doin la onnila hare o'ta watu, noma nod niek ralmha'arni pa Namkek la riy nenenan gaini na'nama Nakot la riy de Niwra: “Mpuetar limmu!” Noma riy de nwetar limni de mtatande nekpa nnienni nmolu. ");
INSERT INTO lex_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nhor nioka riy Parisi re rhoitio'or la gen miaka Yahudi rhi' kreini-iskolli de wa, na'nama ror wut nieka Herodes mniotni rna'ohma pa rwenna Yesus. ");
INSERT INTO lex_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Noma Yesus Nora maka ha Nwatutu-nwaye'a re rwadur la danau aratni, mere mak kdena Galilea harahu rma rlernohora re, ra'itar mak kdena letlawna Yerusalem ror wutga Yudea korni re wali, makden Idumea, makden Yordan walli, me mak kwatiawu Tirus me Sidon. Honona re rmai tiemna yoma ratlin nan oleka hya'-hya' maka Yesus Nhi' nana. ");
INSERT INTO lex_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Noka Nhopan maka ha Nwatutu-nwaye'a re rwahi'a puou id la, yoma riy rahu re nhi'pa rma rhopun E'a. ");
INSERT INTO lex_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yoma Nhi' riy rahu pa rkalwieda, reiniande makamehra-kamau honona rma rwayotli-rwadahla la onni pa riwra rho'a-rhaiya Yesus totpa ir inonni meheni rkalwied walia. ");
INSERT INTO lex_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Riy maka hegana nhu'ru ralma ramkek nan Yesus, dewade rma rwaltiora-rwaltieman la gaini ralamni na'nama hegana re rhaun matmiati: “O' de Uplerlawna A'nani inhat O'a!” ");
INSERT INTO lex_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mere Nano' matmiati pia yan memmemna rakot nohora he' E'a. ");
INSERT INTO lex_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Lera ida Yesus Nafia'at la wo'ora id hananni, noka Npolg awoka riy maka Eniwa Nhi'a la maka ha Nwatutu-nwaye'a re. ");
INSERT INTO lex_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nwaliri-nwalioh nan walia riy termida wehrani woru la' hare honona. Noma Npolga hare la “Mak Ha Nwalir niana pa rodia Uplerlawna lirni-tunnu.” Yesus Nakot la: “Awualiri miy totpena Alia' meni-meni to' de miy miora A' tialla, totpena Aghopna mlia mikot nohora Uplerlawna lirni ");
INSERT INTO lex_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ne Agala A ru'ru-la'yu totpena miy mhiokargota hegana-kawnu.” ");
INSERT INTO lex_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Riy mak termida wehrani woru ri nanni: Simon mak Yesus Nal walia nani Petrus, ");
INSERT INTO lex_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedeus a'nani Yakowsi nora hyalli Yohansi mak Yesus Nala nanni Boanerges maka nnia'eratni de kukru-gauru a'nani, ");
INSERT INTO lex_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andarias, Pilipsu, Bartolomeus, Matius, Tomsa, Yakowsi, de Alpius a'nani, Tadeus, Simon maka ha rweta la riy mak kwayotil memna hairi Romawi rodi plolli la Israel, ");
INSERT INTO lex_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","la'pa Yudas Iskariot maka na'olga Yesus. ");
INSERT INTO lex_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nhor nioka Yesus Nla'awa roma id ralamni. Noma riy rahu rma rhopun temna, nhi'nande Yesus Nora maka ha Nwatutu-nwaye'a re edon ra'an eti. ");
INSERT INTO lex_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","La'pa luwnu-a'nani ratlin nana Yesus edade, noka rmai pia riwra ra'ala, yoma riy rakota riwra: “O'tani leplep olekwa.” ");
INSERT INTO lex_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Makwatutu-kwaye'a agama mak kwatiawua Yerusalem riwra: “Riy di, Be'elsebul nhu'ru ralma. Enhokar doin hegana-kawnu rella yoma Be'elsebul, hegana amlawanni de ed mak kala ruri-lai la E'a.” ");
INSERT INTO lex_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesus Npolg awoka re na'nama Nnairia yawalliohora pa Nakot la re: “Hegana woka-le'u ida edon nhokra hegana woka-le'u dom to'a toh?! ");
INSERT INTO lex_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Hegana re emeknekama hairi ida. La'pa la hair ida rimormiorni ema rhakre'era la wokni-wokni mak kahuri-kawo'ora, de hota hair de edonna namteman plalahwa. ");
INSERT INTO lex_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Me luwu-a'na ida nden rer lia yahuri-yawo'ora de hota rweyata-rwaniawua luwu-a'na de. ");
INSERT INTO lex_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Emkade walia la hegana amlawanni tnioranni-riautnu. La'pa hegana woka-le'u ida, nhokra hegana woka-le'u dom to'a, de hota hegana tnioranni-riautnu ema reyapie'era ne nanewar doin la, pa hota edon nodi plolli owa'an wa. ");
INSERT INTO lex_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Itala mak karuri-kalai ida pa itsi' la yawalliohora. De la'pa riy riwra reyahru mak karuri-kalai ida re'eni-tniarnu, pa'etnu de nwutu-nkohg ulga mak karuri-kalai die nanpena nler la mak karuri-kalai die romni ralamni pa na'ala hade re'eni-tniarnu. Hade emekwali Aghi'a la hegana amlawanni. ");
INSERT INTO lex_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Mitlina, A'ukot hadi totpa mhioratreria, de la'pa riy rhi'a do'a-hala me napolu-naliella Uplerlawna, de hota Uplerlawna Namou-nawitna do'oni-halli re. ");
INSERT INTO lex_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mere la'pa riy meni ed mak kapolu-kaliella Uplerlawna Nhiw Lululli, de riy de, hota Uplerlawna edon Namou-nawitan la do'oni-halli de, mere rwaghala onnila nhi' do'a-nyap hial maka kodi liarni.” ");
INSERT INTO lex_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesus Nakot emkade yoma rakot olekwa riwra: “Yesus de, hegana nhu'ru ralam nana.” ");
INSERT INTO lex_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Noka Yesus inni me a'nani korni rmai wia. E rtutrier mia'ta la tio'or wa dewade, rhopna riy rla rpolu Yesus. ");
INSERT INTO lex_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Rirahu e ramtatna pa rpepan reria Yesus, noma rakot la: “Tuna, Tuna inni nora amni-hyalli e rtutrier lia tio'ora, rwahak talan pa rwatro'mu.” ");
INSERT INTO lex_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Noma Yesus Nnairia yawalliohora pa Nakot nohor pleini, Niwra: “A i'nu-na'ru a'mu-hya'lu la Uplerlawna yamkekni de he'a?” ");
INSERT INTO lex_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Namkek la riy mak kamtatna pa kpepan reria re, noma Nakot la ira: “Hari, er maka a i'nu-na'ru a'mu-hya'lu. ");
INSERT INTO lex_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Riy maka khi' nana Uplerlawna ralma-riorni, de hare er mak kla' A i'nu-na'ru a'mu-hya'lu.” ");
INSERT INTO lex_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Noma Yesus la Nwatut owa'an la danau aratni. Riy harahu rwayotil pa rma rpepan nana Yesus, pa narieiniande Yesus Nwatitin genni la puou mak kapniali id wawannu pa Namtatna la' hande. Ne riy rariahu re rtutrier lia eni wawannu. ");
INSERT INTO lex_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Noma Yesus Nnairia yawalliohora pa Nwatutu-nwaye'a la'a lira nnio'a-niatu harahu la'a riy rariahu re. La' wniatutnu de ralamni E Niwra: ");
INSERT INTO lex_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mitlina! Mak kanhyi'a-katlunni ida nla' pa nrinnia winni-hgonni la nhyi'ini. ");
INSERT INTO lex_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","La'pa nrinnia wini-hgona re dom de rtuin la talla ralamni, noma onu-ma'nu rmai pia rtotan nan momuoga. ");
INSERT INTO lex_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Dom de rtuin la watgau ralamni pa ntai tani oke' to'a. Plet pa nmor wia yoma tani mniha. ");
INSERT INTO lex_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Mere la'pa lera nhit wa dewade rmakulli-rmarella pa rmat wia yoma ga'arni edonna nlera plollola tani ralamni. ");
INSERT INTO lex_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Wini-hgon de, dom de rtuin la pu'na-kiarti pa nhi'nande ruwnu-ahla rururni-karkiaratni re rmor pia ratolaw wenwenna pede ta'en niana ha rmori plollola pede rakleh wo'a. ");
INSERT INTO lex_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mere dom pal die rtuin la tan ihi wawannu pa rmori samomuou. Rpoti-rkaduw pede dom de ra'unu-rayeh nohora wo'oni terampwotelu, me dom pal die terampwonema. Ne la dom pal owa'an de rawo' nana rahg ida. ");
INSERT INTO lex_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","La'pa miy tlinmi erla de, mitlin reri!” ");
INSERT INTO lex_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","La'pa Yesus Nora maka ha Nwatutu-nwaye'a re termida wehrani woru ror wutga maklernohor reri E'a riy dom to'a rmeh'a taru, dewade ratian nohor E'a la'a yawalliohor re. ");
INSERT INTO lex_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Noma Yesus Niwra: “Uplerlawna Nhu'ula tlinmi-nwe'er matmi totpena miat niohora la hya' ed maka riy raplin niohor ma'ta la'a Uplerlawna tnioranni-riautnu. Mere eneknek to'a rala yawalliohora re rwatutga riy mak kakleha pesiay. ");
INSERT INTO lex_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Totpa: “Hota ramkek reria mere emkade ho'mana edonna rna'erit nana. Ira e ratlin reria mere emkade ho'mana raplinu-raplo' nohora totpa yana rwaldioinia pa Uplerlawna Namou-nawitna do'oni-halli.” ");
INSERT INTO lex_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","“Noma Yesus Nakot la re: “Edonna mnia'erit nana lira yawalliohor dina?! La'pa miy edonna mnia'erit nana de hota emkameni pede miy mnia'erit nana lira yawalliohora re korni?! ");
INSERT INTO lex_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mak ke'er wini-hgona re emeknekama riy mak kakot nohora Uplerlawna lirni. ");
INSERT INTO lex_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wini-hgona mak ktuin la talla ralamni de emeknekama riy maka katlin oleka Uplerlawna lirni na'nama hegana amlawanni nmai pia nwarui-nwate'la nana lira-tun diella mak katlin oleka re. ");
INSERT INTO lex_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Wini-hgon maka ktuin la watwuatnu nnia'eratni de riy dom maka katlin nana lir kalwied de dewade rleretniekla ralamni naplele'er pa rreiniana. ");
INSERT INTO lex_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mere lir kalwied de edonna naga'ar la'a ir ihranu ralamni pede nhi'nande edon nalo'on wali ne nwal lia hamamuamua. La'pa rler la kropanni-krieutnu, onde yamuki-yama'ala yoma la'a lir de rerieini, dewade rleretniekla rwadur la pesiayni. ");
INSERT INTO lex_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wini-hgon maka ktuin la ruwnu-ahla pu'na-kiarti, de emeknekama riy dom maka katlin nana lir kalwied de, ");
INSERT INTO lex_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","noma nohkerkerna rororni-lailiaini, hihi'ini-yapyapni me re'a-tniaru tototni-wudwiudni la'pa ralam mak kod rier lia hihi'a-yapyapi korni nmai pia nutni-ndahla lira di, de nhi'nande nakleh wo'a. ");
INSERT INTO lex_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ne la'pa wini-hgon maka ktuin la tan ihi, de emeknekama riy dom maka katlin nana lir de noma rreiniana pa rlernohor reri, pede mormiorni re rdella plol wawna. Riy mak katlin dom de emeknekama wini-hgon mak kawo'a liawanni pa wo'oni nlernana nti'il nana ralamni re'eni terampwotelu, dom pal die terampwonema, ne la' wal diom de rahu ida.” ");
INSERT INTO lex_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Noka Yesus Nakot la re: “Riy edonna raltarga ktopra ra rtutwua wa'du mormiori, onde rwatatga wa'du della' lewnu nayanni. Wa'du de rkeni hadella la'a wniatatgenni. ");
INSERT INTO lex_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Emkade wal lia' Uplerlawna lirni-tunnu, yoma E lirni mak kayade'a honona re mana hota rakot nohora, me mak kayawunmu momuou hota nawnie'era ne rat niohor memna. ");
INSERT INTO lex_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","He'a tlinni erla de totpa ratlina! ");
INSERT INTO lex_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mpiahniorat la hya' maka A'ukota ri, yoma la riy mak klernohora hya' maka enatlina de, hota ra'itr owa'an la wniarorni-wnialaini. ");
INSERT INTO lex_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Riy mak kiwra kna'erit nana, de hota ra'itr owa'an la wniarorni-wnialaini mere la'pa riy mak kahmena kat niohora Uplerlawna lirni, de hya' mak enatg oleka de hota Uplerlawna Na' owa'ana.” ");
INSERT INTO lex_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Noka Yesus Nakot la re Niwra: “Ina-nara ama-hyali, la'pa Uplerlawna Ntorna-nrautu de emekwalima yawalliohora di. De la' mak kanhyi' ida, ne'era winni-hgonni la tani ralamni. ");
INSERT INTO lex_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Noma nmela de nanina me, leler demade namata, ne winni-hgonni re rmor pia ral uhwu, ral uhwanu pa ratultul liola, riy de naplin niohora liawanni re. ");
INSERT INTO lex_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nohkerkeran di mana nmeh'a nekpa nal wo'oni, nhiwni ulu, noka wo'oni, nhor demade o'olli mak kden la harni ralamni. ");
INSERT INTO lex_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","La'pa wo'oni de ngatan wa, dewade matromni de nma nhei dioinia la, yoma reiki lerni nma ntutu-nte'ewa.” ");
INSERT INTO lex_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesus Nakot owa'ana: “Tnairi hya'a ta twatutu niohora Uplerlawna tnioranni-riautnu la E rimormiorni wawannu, onde tnairi yawalliohora hya' pa takot nohora? ");
INSERT INTO lex_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Sasawi ola ida maka rtamnia la nhyi'ini de emolmolan nekama Uplerlawna tnioranni-riautnu la E rimormiorni. Sasawi ol de ha luwlu'wu id hade la'a ha'ola korni mak kden la nohkeran di wawannu. ");
INSERT INTO lex_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mere la'pa nmori, de hota npoti-nkadwu, pa nareh niana yawuli-yatniamni re korni. Hota sasawi olli-tapalli re rpoti-rkadwu pa nhi'nande onu-ma'nu rma rapuon la'a sasaw die tutnu-akni.” ");
INSERT INTO lex_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesus Nnairia lira yawalliohora mak emkade mamaini totpa Nakot nohora Uplerlawna lirni la riy rahu re. La'pa Nwatutu de E Nlernohora hya' maka irna'erit nana. ");
INSERT INTO lex_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","La' wniatutnu honona la'a rirahu re, Yesus Nnairi mamainia yawalliohora. Mere la'pa E nor wutga maka ha Nwatutu-nwaye'a re rmeh'a de Enwe'er doin momuoga totpena rna'erit nana. ");
INSERT INTO lex_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ler de pa la'pa lera nheria dewade, Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: “Mai pia todia puou pa tla'awa danau de walli.” ");
INSERT INTO lex_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yesus Namtatan ma'ta la puou ralamni de, dewade maka ha Nwatutu-nwaye'a re rto'or doinia rirahu re pa rha'at la puou pa ror rewre'wa Yesus la puou ralamni. Puou dom mana ror ir pa rhopal wa. ");
INSERT INTO lex_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Noma anin lawna mana nten wia ne, yo'ora mana rriw lia puou ralamni nhi'nande puou npenpuen la tah'i. ");
INSERT INTO lex_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ler de de Yesus Nanin hala, Naklun reria la'a puou li'ir tutnu. Noma maka ha Nwatutu-nwaye'a re ramata noka rakot la: “Tuna O edonna Mhe'du nana ita, tsi' pa tepar wa?!” ");
INSERT INTO lex_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Noma Namat pa nkamot targa anni me Nakot la tah'i de: “Hadewa, mulina-mule'ru!” Dewade anni mana edon nteni ne tah'i de mana nalina wa. ");
INSERT INTO lex_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Noma Nakot la re: “Nihya'pa mimta'at wenan miy emkadena?! Edonna mpiesiaya ma't A'u?!” ");
INSERT INTO lex_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ir honona ramta'at wenna, noma idma nakot la ida riwra: “Riy di de he'a pede yo'ora-anni nek de ratlina-ratailla?” ");
INSERT INTO lex_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesus Nora maka ha Nwatutu-nwaye'a re rhopal pa rodi liarni la' danau Galilea walli, la'a riy Gerasa genni-tienni. ");
INSERT INTO lex_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","La'pa Yesus Nerun la keranni, dewade muanke' maka yatni-rha'ani ha rhu'ru ralma ida nlergot la hu'ula-liena la'a tniamin mat geni ralamni pa nma nler temna. ");
INSERT INTO lex_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Riy de nhol lia hu'ula-liena mak kden la tniamin mat geni ralamni, ne riy id ho'mana edon narur pia nwut niana, rnairi wutwutu mnotna ho'mana ta'eni. ");
INSERT INTO lex_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yoma nhi'inde riy e rwutu-rkohog e limni-lakni, de rnairia wutwutu mnotna, mere na'ed lia inonni pa nwuhi eti-lahwa re la'a limni, me nweyata ranti la'a lakni. Riy id mana ta'en niana ntoran nana. ");
INSERT INTO lex_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Lelera-melmel de, nden to'ola tniamin mat geni ralamni me la'a wo'ora-kawru pa nhaunu-nhaunu me nal watu na ntu'tu nlakwehi tio' inonni. ");
INSERT INTO lex_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","La'pa namkek nana Yesus Nwatiawua oliet pa Nmai wia dewade nawlar pia la nwatroma. Noka nwaltiora-nwaltieman la Yesus gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Yesus Nakot la Niwra: “Hega'nu ne! Mhuargot la riy di ralamni!” Dewade riy de nhaunu-nhaunu pa niwra: “Yesus ee! O' de Uplerlawna mak kden la tutullu-lolo'oni A'nani O'a! Hota Omhi' nana a'g emkameni ee! Omliokar pa mpuet la Uplerlawna nanni totpena yana Mukmua a'u.” ");
INSERT INTO lex_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Noma Yesus Natiana riy de Niwra: “O nanmu he'a?” Noma riy de nwalolla niwra: “A na'nu Legion yoma am di de yatni-rha'ani liawanni. (Nanni de nnia'eratni keki-rautu woka liawanni). ");
INSERT INTO lex_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Noma nwakwak rer lia Yesus totpena Yesus yana Nhokar gota hare pa rhoitio'or doini la lowan de. ");
INSERT INTO lex_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","La' hande de e rehgorgorga gen miaka wawi wok lawna e rwayowar pa rahak pa ra'ana-remun la wo'ora hananni. ");
INSERT INTO lex_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Noma yatni-rha'ani re rwak lilili-mamuau lia Yesus totpena Nhopan nekpa irler la wawi re inonni ralamni. ");
INSERT INTO lex_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesus Nwayowa, dewade rlergot la riy de inonni, pa rla' rhu'ru ralma wawi re, na'nama honona re rawlar pia rla rlererun la weran teti pa ema rwuwul wenwenna la' danau de ralamni. Wawi honona re la'pa edon nhal de riwnu woru. ");
INSERT INTO lex_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nhor nioka mak khuri-kwa'ana wawi re rawlar pia rla rod kiota la'a ir letni me gen miaka rehgorgoru. Noma riy rlergot pa rma rpoi-rkeka (ramkeka) hya' maka ha rakota re. ");
INSERT INTO lex_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Riy rawok la Yesus onni pa ramkek memna riy maka yatni-rha'ani rlergot la de, e namtatan reria, nnairi oleka pola-raini me wniaror samomuou ed olek la ihranu ralamni. Noma riy honona re ramta'at wenna. ");
INSERT INTO lex_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Riy mak kden hande maka ramkek oleka Yesus Nhokar doinia yatni-rha'ani re, rwahaur nohor hadel la'a riy mak kmai re, ne rwahaur nohor walia wawi re. ");
INSERT INTO lex_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nhor na'nama riy mak kden hande rwak lilili-mamuau pua Yesus yan memmemna Nalo'on la' gen die ne plet pa Nwaran nek wa. ");
INSERT INTO lex_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","La'pa Yesus Nha'at owa'an la' puou ralamni de, riy mak yatni-rha'ani re ha rlergot la de, nwak la Yesus totpena nlernohor rer wialia Yesus. ");
INSERT INTO lex_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mere Yesus Nahmena, pa Nakot la Niwra: “Samomuounu de muwal lia genmu-tienmu, me mukot nohora Orgahi-Orha'a ralam kalwiedni tiy o'a, me la'a hare honona mak samomomuou memna maka Enhi'a-nyapi la o'a.” ");
INSERT INTO lex_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Dewade riy de nla'awa la'pa nakot nohora hare honona la mak kdena Dekapolis la'a hya'a maka Yesus ha Nhi'a la e'a. Ne riy honona mak katlin nan de rwer rer wiawni. ");
INSERT INTO lex_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Noma Yesus Nodi puou pa Nlereti owa'an la danau walli, dewade riy rahu lidna-lidan pa rmai pa rpe'pa reri E'a la gera aratni. ");
INSERT INTO lex_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Noma edon nalo'on wali ne Yairus makhi' o'tani la'a gen maka Yahudi re rhi' kreini-iskolli de nmai wia. La'pa namkek nana Yesus dewade nwaltior la Yesus nayanni ");
INSERT INTO lex_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na'nama nwak lilili-mamuau lia Yesus, niwra: “Tuna, a a'nu patke'a namehra pa trema-trema hota nmat wia. Awuak de, Mtiulan pa Mlia Mtieman la e'a totpena nkalwied owa'ana, totpa yana nmati.” ");
INSERT INTO lex_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Noka Yesus Nor riy de pa rla'awa. Riy rahu lidna-tauru rlernohora pa idma rde'da la'a rde'da mai ida. ");
INSERT INTO lex_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","La' riy rahu re, de patke' mak khur riara la'a anni termida wehrani woru, e nor wali. ");
INSERT INTO lex_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","La'pa tilti'ila-walwial tiarga la yakrui-yagapnu la mak katu kakrui-kagapnu (dokter) pa nareiniande nahor dioini momuoga re'eni-tniarnu pa npair la makakrui-kagapnu, mere mehrani de edon nkalwied eti, mere yeher to' pa na'itar la. ");
INSERT INTO lex_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Natlin oleka hya'a mak Yesus Nhi'a, noma nwakriania Yesus la mutu letgarni. Ndella Yesus to'orni na'nama nteman la Yesus raini plalahwani. ");
INSERT INTO lex_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yoma nwaror la ralamni: “Hornama atieman to'ola raini plalahwani de, de hota akalwied wa.” ");
INSERT INTO lex_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","La'pa mtatande nekpa rarni mak kawdiadia'i de nkeran wa, ne nat niohor memna inonni nkalwied wa. ");
INSERT INTO lex_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mtatande nekpa Yesus Na'eram nana de rurni-laini nlergota la inonni, noka Nheri gaini pa Namkek la riy rahu re, na'nama Natiana re: “He' ed maka kteman la A rainu?” ");
INSERT INTO lex_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Maka ha Nwatutu-nwaye'a re rwahla: “Omumkeka de riy rahu ri rpakdie'da la'a O hermu-gaimu, mere Mutian owa'ana he' ed mak kteman la O rayanmu?!” ");
INSERT INTO lex_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Noka Namkek la'a-Namkek mai totpena Nahaka he' ed maka khi' nana hihi'a-yapyap di. ");
INSERT INTO lex_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Patke' de namta'ata pa nruru yoma nat niohora hya' ed maka khi' olek la inonni, dewade nla nwaltiora-nwaltiemna la Yesus gaini ralamni na'nama nakota plele'er nohora hya'a maka nhi' oleka wa. ");
INSERT INTO lex_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Noma Yesus Nakot la Niwra: “O pesiaymu e narur mai A'u ina pa mkialwied wa! Mlia'awa pa mmuori-mdiar lia kalwiedni-paitiotni.” ");
INSERT INTO lex_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","La'pa Yesus enaltiertier mia'ta de dewade riy dom rwatiawu Yairus romni pa rmai rakot la Yairus de niwra: “Tuna, a'namu nmati olekwa pa yana mpuaka Tungkur die pa nla'a o rommu nayanni.” ");
INSERT INTO lex_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mere Yesus edonna nhe'du nohora lirni re mere Nakot la Yairus Niwra: “Yan mumta'ata. Mpuesiay niek wa.” ");
INSERT INTO lex_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Noma Yesus edonna Nhur niohora riy id wali pa Nora talla, atiaru Petrus, Yakowsi nor wutga hyalli Yohansi. ");
INSERT INTO lex_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","La'pa rte'ela Yairus romni, ramkek nan de riy rahu mak kokna-krarnia. Rko'a-rkakur nohora mat die. ");
INSERT INTO lex_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Noma Yesus Nla'awa rialam pa Nakot la re: “Nihya'pa mimkiokna-mriarni mkio'a-mkiakru?! Hararar de edonna nmati, hade e nanin to'a.” ");
INSERT INTO lex_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","La'pa ratlin nana Yesus lirni de, noma honona riarin taru la yamalli. Noma Nhokar doin hare honona, na'nama Nod hararar de inni-amni ror wutga Petrus, Yakowsi me Yohansi pa ror rewre'wa rla'awa la hararar de genni la'a rialma, ");
INSERT INTO lex_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","na'nama Ntorreria hararar de limni na'nama Nakot la Niwra: “Talita kum”, nnia'eratni de: “Ina, A'ukot tiy o' de, mumat wa!” ");
INSERT INTO lex_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mtatande nekpa hararar de naprir pia nala'awa. Hararar de umurnu termida wehrani woru olek wa. Riy mak kden la hande rwer rer wiawni la'a hihi'-yapyap die. ");
INSERT INTO lex_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mere Yesus Nlaran pa yan memmemna rakota hadella hehe'a. Na'nama Yesus Nhopan pa ralla harar de pa na'ana. ");
INSERT INTO lex_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Noma Yesus Nor wutga maka ha Nwatutu-nwaye'a re Nhoitio'or la gen die noma rawal lia' Yesus letni-ruhunni. ");
INSERT INTO lex_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","La'awa Sabat lerni dewade la Nwatutu-nwaye'ela gen miaka Yahudi re rhi' kreini-iskolli. Ne la'pa ratlin nana Yesus wniatutnu de, riy harahu rwer rer wiawni pa riwra: “Ha Nlernana wniatutnu-wniaye'eni rilla' hanmenio? Kirkira-ralma-rior samomuou hya' hadina? Nlernana plola-mneha pa Nhi' nana hihi'a-yapyapi mak kamehi-kayona la hanmeni? ");
INSERT INTO lex_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Itat niohora de mak kawte'ta-kaprahni id to'a hade pa edonna nhal de Ha inni nwawa Maria, ne hyalli re de Yakowsi, Yoses, Yudas nora Simona? Ne ha narni patke'a re nek de rden wal lia handi.” La' emkade pede honona re rwayotlia Yesus. ");
INSERT INTO lex_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Noma Yesus Nakot la re Niwra: “La'a makwohorulu-ktatrulu maka klol meni-meni to' mana, rira rhu'ru-rhelam la, mere hota la' letni-ruhunni me luwnu-a'nani meman nek de riy id mana edonna natlin la.” ");
INSERT INTO lex_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ne onnila irakleha pesiay pede Yesus ta'en niana Nhi' hihi'a-yapyapi mak kamehi-kayona la' hande, enekneka Enlapar limni la'a makamehra doma pa Nhi'a pa rkalwieda. ");
INSERT INTO lex_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mere Yesus Nwarora: “Wah! Nihya'pa riy korni mak kdella A le'tu ri rahmena rpesiaya A'u?!” Noma Yesus Nalala'a la'pa Nwatutu-nwaye'ela leta ida nhor diemade leta ida. ");
INSERT INTO lex_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Noma Yesus Npol wutga maka ha Nwatutu-nwaye'a re riy termida wehrani woru. Noma Yesus orgahani Nala ruri-lai la ir honona totpena rnairia pa ra rhokra-rlaiya hegana-kawnu, nhor nioka Nhopna rla'a de riy maroro'a rala' wutu. ");
INSERT INTO lex_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yesus Nakot la re Niwra: “Hyal miy re, yana miodia hadomdoma la' yala'ami de eneknek to'ama lie'ena. Yan miodia ya'ana-yemnu, arkai, onde kupna. ");
INSERT INTO lex_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mniairia laka wniowa mere yan miodia hewewta-naniairi ida-woru pa mhiernu miy rayanmi la' talan ralma. ");
INSERT INTO lex_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hota la roma-lewu maka riy rreiniana-ra'nan miy, de mdien nek la ir romni la'pa kniarmi la' let de la nhorwua nanpena mpiaran la' rom de. ");
INSERT INTO lex_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","La'pa mlier la gen ida maka edonna kreinian miy onde edonna katlina-katail tiy miy die, mtio'or doin gen die, me mkiakan doinia awu mak kden la lakmi lia'armi totpa mtiutga de Uplerlawna Nwayotlia ira.” ");
INSERT INTO lex_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesus Naltier pa Nhorwua noma riy maka ha Nwatutu-nwaye'a re rla rod kiota-ral de'eta Uplerlawna lirni riwra: “Mhioitio'or doin-mtiahnei dioini do'omi-halmi re!” ");
INSERT INTO lex_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Rhokar gotgota hegana-kawnu rahu, ne rawu'ru-ralena la riy rahu makamehra-kamau re, ne rhi'a pa rkalwieda. ");
INSERT INTO lex_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ray Herodes mak kwenna Yohansi, mana natlin nohor walia Yesus, yoma nanni nwewar noha. Riy doma rakot nohora Yesus riwra: “Matialo'onama Yohansi mak kharani e inhatti! Enmati olek pa nmori owa'an pede nhi' neka hihi'a-yapyapi mak kamehi-kayona hya' to'owa.” ");
INSERT INTO lex_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Dom de rakot nohora Yesus riwra: “Hade de Eli edade,” me dom de owa'ana riwra: “Makwohorulu-ktatrulu edade, emekwalima makwohorulu-ktatrulu la'a ululu genni.” ");
INSERT INTO lex_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mere la' pa Herodes natlin nana lir de, dewade niwra: “Hade de Yohansi maka Aghopan pa riy rdawr eti tiernu, mere nmori owa'ana!” ");
INSERT INTO lex_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Enakot emkade yoma la ler ululu la'a Yohansi nmormior ma'ta de Herodes nhopan pa rtorna Yohansi na'nama rwutga pa rla rwi'it targa la roma nhio'la ralamni. Herodes nhi' emkade yoma la'a e hawni Herodias rerieini. Yoma Herodes hawni Herodias de, de Herodes hyalli Pilipsu haw ulullu. ");
INSERT INTO lex_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Pede nhi'inde Yohansi nakot la Herodes niwra: “Yan memmemna omuora hyalmu hawni de mmiehlima. Hade edon lol deulu-tatra.” ");
INSERT INTO lex_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Lirni de narieiniande Herodias, Herodes hawni de, na'andoin gahani la Yohansi, ne nwaror pa nwenna, mere ta'en niana, ");
INSERT INTO lex_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","yoma hawni Herodes napili-nahniari Yohanis di onnila natga de, Yohanis di de riy plollola-mneneha, nakleha do'a-hala, pa nhi'nande nliwan reria. Mere la'pa Herodes natlin nana Yohansi lirni noma Herodes namta'ata, mere ralamni nahepur to'ola yatlina la Yohansi lirni. ");
INSERT INTO lex_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mere Herodias nwewiei-nnarnara lerni pa nwunu-nwenna. Lerni nmai wa la' Herodes ler kalwiedni. La' ler de Herodes nhi'a muki-hepru ya'anlawna-yemunlawna la tniutnu-nhianni-nhielli-liarni, o'ta-mata mak kodi kekni-rautnu, me riy lalawna la Galilea. ");
INSERT INTO lex_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","La' ler de de Herodias a'nani patke'a nloi lia makhopnu-makpepna gaini ralamni. Lioini-nhiekni de nla' nan meman la Herodes nora makhopnu-makpepna re ralamni. Nreiniande Herodes nakot la hararar de niwra: “Ralammu nwaka hya'a-hya'a to'a, pena agala tiy o'a.” ");
INSERT INTO lex_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Noma Herodes nlokar memna la pat hararar de gaini ralamni niwra: “Hya'a-hya' to' maka mpuaka de agala tiy o'a, la'pa a plo'lu-mneh'u (hai'ru) di walli mano omliernana!” ");
INSERT INTO lex_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Harar de la' pa natian nohora inni niwra: “Hya' ed maka hota awuaka?” Inni nwahla niwra: “Yohansi makharani de o'tani!” ");
INSERT INTO lex_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Noma harar de pleta-plet pa nla'awa ray Herodes pa nwaka: “Tuna, awuak pa la' dodo'ondi de mkien tio'a Yohansi makharani o'tani la totopa, pa muala mai a'u.” ");
INSERT INTO lex_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","La'pa Herodes natlin nana hararar de wakwakni dewade ralamni ntuin doin la. Mere takotpa, nlokar pa lira olek hadewa ne mak kmai pia kor wutga Herodes pa ra'an de ratlin momuoga oleka pa nhi'nande Herodes nahmena nwayotlia wakwakni. ");
INSERT INTO lex_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Herodes pleta-plet pa nhar lirni totpena rla rotan doinia Yohansi makharani die o'tani la'a roma nhio'la ralamni na'nama rkenia o'tani la totopa pa rma rtemna la hararar de limni. ");
INSERT INTO lex_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","La'pa edon nalo'on ma'ta de rken nian Yohansi o'tani la totopa ralamni pa rma ralla pat hararar de. Nhor nioma pat hararar de nodia Yohansi o'tani pa nod tiargho'a la inni. ");
INSERT INTO lex_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","La'pa maklernohor reria Yohansi makharani ratlin nana, noma rma ra'ala Yohansi inonni pa rla rhuwria. ");
INSERT INTO lex_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","La'awa lerni pa maka Yesus ha Nhopan pa rodia Uplerlawna lirni-tunnu re rawal pia rakot nohora hya'a maka ha rwatutu me rhi' nana re honona la Yesus. ");
INSERT INTO lex_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Noka Yesus Nakot la re: “Mai pia tla'awa gen miaka hgali totpa tmeh'a, ne tren kuku' it la' hande.” Yoma riy rahu maka kla'a-kmai re, nhi'nande ya'ana mana ta'en niana. ");
INSERT INTO lex_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Noma irmehmeh'a rodi puou pa rla'awa gen miaka hgali. ");
INSERT INTO lex_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mere la'pa rwaran wa dewade, riy rahu ramkek nohora pa rat niohora gen miaka ir rokria de. Pede riy rahu pleta-pleta pa rlol keranni totpa rmai tiemna, rwatiawua letni-ruhunni la meni-meni pa rala' ulga re. ");
INSERT INTO lex_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","La'pa Yesus Nerun la puou pa namkek la riy rariahu re, de ralamni ntuin doin la pa Niwra Ntulan la ira yoma ir rakleha riy mak ktutga talla mak kaplollol la' ira. Honona re emolmolla pipi-duma mak kakleha riy mak kodi. Noma Nwatutga ir la'a nnio'a-niatu harahu. ");
INSERT INTO lex_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ne lera nheria pa mak Yesus ha Nwatutu-nwaye'a re rma rakot la Yesus riwra: “Tuna, lera nheria wa. Ne la' gen di ho'mana olieta la leta ");
INSERT INTO lex_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","pede Mhuopan nekpa ir orgahani rla rawelia ya'ana-yemnu la'a leta-leta re mak rehgorgoru.” ");
INSERT INTO lex_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mere Yesus Nakot la: “Pena mialla ra'ana.” Noma rakot la riwra: “Ita'ala kupna-kai maka riy nhi'inde rlernana la wolla wo'awa gahani memna pa itaweli roti totpa talla ra'ana?!” ");
INSERT INTO lex_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Noka Nakot la: “Roti wo'ir mak miy miodi rena? Mimkek teka!” La'pa ramkeka pa nhor nioka riwra: “Roti wolima me i'na woru.” ");
INSERT INTO lex_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nhor nia'nama Nakot la maka ha Nwatutu-nwaye'a re pa rhopna riy honona re ramtatna momuoga la wewna motmota wawannu, ne rnawera la wokni-wokni. ");
INSERT INTO lex_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Noka hare mana rawok pa ramtatna. Wokni dom de, terampwolima me wokni dom owa'an de rahu ida. ");
INSERT INTO lex_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Noma Yesus Na'ala rot dieulu re wolima, me i'na rora, na'nama Nwatniar la heyanan pa Na'uli-nawedia Uplerlawna. Na'nama Nhawi-nhawia roti re na'nama Nala la maka ha Nwatutu-nwaye'a re rhakre'era la'a riy mutlialawna re honona. Nal walia i'n de pa Nhakre'era la riy rahu re. ");
INSERT INTO lex_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Honona re ra'an pa rpehera. ");
INSERT INTO lex_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ra'an pa rwair wa, noma maka Yesus ha Nwatutu-nwaye'a re, rwaho'a-rwatierun wa de rawok nana roti me i'na mak ha ra'an atre'a, de kriou penpuenu termida wehrani woru. ");
INSERT INTO lex_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mak ka'an momuou lia hande, la'pa edon nhal de muanke'a riwnu wolima, me edonna rhor wut mua'ta la patke'a ror wutga upni-a'nani. ");
INSERT INTO lex_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nhor nioma Yesus Nhopan pa maka ha Nwatutu-nwaye'a re rodi puou rleretia danau pa rala' ulu E'a la Betsaida, ne Nhopan pa riy mutlialawna re rawal wia. ");
INSERT INTO lex_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Dewade Yesus Nha'at la wo'ora id hananni totpa Nsumbaini. ");
INSERT INTO lex_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mere la'pa mela ndamit nana, de maka Nwatutu-nwaye'a re puounu ed olek la danau letgarni, ne Yesus Nmemeh'a Ndella keranni. ");
INSERT INTO lex_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Noma Namkek de, maka Nwatutu-nwaye'a re ta'eni rwain nana puounu, yoma anni mak klol gaini newat nana. La'pa repreparreria de Yesus Nala' lola tah'i ulti wawannu pa Nla Nlernohora puou mak oliet olek la E'a. Nalala'a pa Nwakriania na'nama Ntot pa Nala' ulu ira. ");
INSERT INTO lex_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","La'pa ir honona la puou die ramkek tutga E maimiaini de lola tah'i ulti wawannu de rhoiya la hegan lora, reiniande honona re polpuollu-hawaunnu, ");
INSERT INTO lex_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","yoma honona re ramta'at wenna onnila hya' maka ha ramkek nan de. Mere Yesus Nleretniekla Nakot la re Niwra: “Yan mimta'ata, Yesus A'g inhatti.” ");
INSERT INTO lex_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Noka Nha'at la ira puounu, ne anin lawan de mana namtie'ela wa, dewade maka ha Nwatutu-nwaye'a re rwer rerer wiawni, ");
INSERT INTO lex_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","yoma raplin niohora la' emkameni la Yesus Nhi' nan hade. Yoma la' ler ululu maka ramkeka roti maka rehenu la riy riwnu wolima re mana raplin nohor yala'ani, mere ralamni ratehra to'owa. ");
INSERT INTO lex_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","La' pa rleretia danau pa rte'ela danau aratni la'a leta Genesaret na'nama rapnial lia hande. ");
INSERT INTO lex_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","La'pa rerun la puou, mak kden hande ramkek tut niana mak kmai die Yesus inhatta. ");
INSERT INTO lex_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Noma rawlar pia rla'awa leta-ruhun maka rehgorgoru pa rhim nana mak kamehra-kamau, mak kanin rer tio'ola u'ti wawannu re, pa rodia la Yesus la'a geni-tien maka ratlin nana Ndella. ");
INSERT INTO lex_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","La' meni-meni maka Yesus Nla'a de, la'a let paheli-ruhun patatra re, de rken tiarga mak kamehra-kamau re la ya'olu-yala'a geni ralamni. Mak kodia makamehra-kamau re rwak lilili-mamuau lia Yesus totpa makamehra-kamau re rteman to'ola Yesus rayanni tawnu totpena rkalwieda. Dewade he'-he' mak kteman nan to'a Yesus rayanni tawnu re, honona rnek pa rler la kalwiedni-paitiotni. ");
INSERT INTO lex_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lera ida ne Parisi wokni id nor wutga makwatutu-kwaye'a agama re rwatiawua Yerusalem pa rma rwahaka Yesus. Rma rpepan reria noma ");
INSERT INTO lex_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ramkek de maka Yesus ha Nwatutu-nwaye'a dom de ra'ana mere edon rohma limni emeka hya' maka upni-tgarni rwatut tiarga la' ululu. ");
INSERT INTO lex_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Parisi mniotni ra'itra Yahudi re korni rlernohora hya' mak upni-tgarni rdeul taru-rtatar targ oleka wa pa ra'ana de rohma limni. ");
INSERT INTO lex_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ne la'pa rwatiawua ya'olu-yala' geni de edon rohma limni ma'ta de, ta'en nian ra'ana. Nhioli-lieta, pa'etu-parahmani korni maka upni-tgarni rwatut tiarga oleka re, rlernohora momuoga, emekto'a rohma lari (niemun geni), kekna-rana, me hewewta-naniair pi'ra. ");
INSERT INTO lex_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","La' hade pede Parisi mniotni rora makwatutu-kwaye'a agama ratiana Yesus: “Nihya'pa riy maka Ompuatutu-mpuaye'a re edon rmor niohora it upni-tgarni deullu-tatarni?! Ira'an de edonna rohma ulga limni.” ");
INSERT INTO lex_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesus Nwahla re Niwra: “Plol memna la' lir wowohora maka Yesaya nakot nohora miy miak mtiot pa mpial lia riy plollola mere plollolli de riy yatyat miy. Niwra: “Emkadilla Uplerlawna lirni: Rimormiori ri eneknek to'ama ral nurnu tutnu re rha'wa nan to' A na'nu, mere ralamni re olieta mai A'u. ");
INSERT INTO lex_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hare kniola tiernu-niawur nehlani mai A' die hamamuamua re yoma ira rwatut tio'a rimormiori wniatutnu-wniaye'eni.” ");
INSERT INTO lex_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Uplerlawna lirni-tunnu de, miy edon mhie'du nana, mere rimormiori deullu-tatarni nanpena mtie'la rer pitpitga. ");
INSERT INTO lex_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Miy edon mliernohora Uplerlawna lirni de, mere mimliernohor to'a miy upmi-tgarmi deullu-tatarni. ");
INSERT INTO lex_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Yoma Musa niwra: “Mhiu'ru-mhielam la inmi-ammi, ne la'pa hameni nwohora-ntatra inni-amni, de hota nlernana niukum matmiati.” ");
INSERT INTO lex_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mere mpiatutu-mpiaye' de edon nhala pa riy id nakot la inni-amni niwra: “Agiwa galla miy, mere agal oleka la Uplerlawna.” ");
INSERT INTO lex_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Noma mhiur niohora riy de, pa hota edon na'unni-namta'ata inni-amni. ");
INSERT INTO lex_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","La' talan emkade pede miy edon mliernohora Uplerlawna lirni de, mere mliernohor to'a miy upmi-tgarmi deullu-tatarni maka mpiatutu-mpiaye'a re. Ne mpiatutu deulu-tatra harahu mak emkade wali mak kreiniande riy edon ratlina-ratailla Uplerlawna lirni.” ");
INSERT INTO lex_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nhor nioma Yesus Npol lia riy rahu mak kden handi pa rma rawoka ne Nakot la re Niwra: “Hononmi mitlina totpena miatga. ");
INSERT INTO lex_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mak ita'ana edon nhi' akdeha-aktiahl ita. Eneknek to'ama yatyatni-halalli maka itakot nohora me tsi' nana. Hade ed maka khi' pa takdeha-taktiahli. ");
INSERT INTO lex_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","He' tlinni erla de, totpa natlin reri!” ");
INSERT INTO lex_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nhor nioka Yesus Nhoitio'or doin riy rahu re pa Nla'awa roma ida nayanni, na'nama maka Nwatutu-nwaye'a re ratiana riwra: “Tuna, Mtiulan pa Mukot nohora yawalliohora de nnia'eratni mai ami.” ");
INSERT INTO lex_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesus Niwra: “Miy die emek ir wal pia edonna miat mua'ta lira re nnia'eratni?! Miy e miplin mua'ta mak itlumu-ttella de edon khi' akdeha-aktiahl ita?! ");
INSERT INTO lex_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Yoma maka itlumu-ttella de edonna la'awa it ihranu ralamni mere, la'awa it apannu ralamni ne hota nlergot owa'ana!” Emkade de Yesus Nakot Niwra ya'ana-yemnu honona de, raya'ana-rayemun momuou. ");
INSERT INTO lex_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesus Nakot la: “Mak kwatiawua it ralamni ed maka khi' rira pa rakdeha-raktiahli. ");
INSERT INTO lex_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yoma it ihranu ralamni ed mak kodia ralma-rior yotyota-yatyata, pa nhi'nande riy ralira-raliai, rkamnelu-rkamna'a, rwunu-rwenna, ");
INSERT INTO lex_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","riy ralamni rapal niana re'a-tniaru kupna-kai, rahankerna-raralmha'ara, pudi-akla ohpa-lahara, pareta-pahawa, ihru yata-ralam yata, rapolu-raliella rira, tulu-petna, raplin niohora talan plollola. ");
INSERT INTO lex_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Do'a-hala honona re rwatiawua riy ihranu ralamni, pa rhi' rira pa rakdeha-raktiahli.” ");
INSERT INTO lex_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nhor nioma Yesus Nhoitio'or la' gen die, ne Nla'awa leta Tirus yapatni. Nla'awa roma ida nayanni, ne nahmen pa riy rat niohora, mere maimiaini de ta'en niana rawunmua. ");
INSERT INTO lex_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Noka patke'a ida maka a'nani patke'a hegana nhu'ru ralma, natlin nana Yesus etla hande, noka plet pa nmai pia nwaltiora-nwaltiemna la Yesus lakni onni. ");
INSERT INTO lex_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Patke' de Yahudi atia'a, mak kwatiawua Fenisia yapatni la'a Siria. Nwak la Yesus niwra: “Tungkurg ee, Mtiulan pa Mhuokar doini hegan mak khu'ru ralma a a'nu.” ");
INSERT INTO lex_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesus Nnairi yawalliohora pa Nakot la: “Ndella pa papay ra'an pa rpeher ulu, yoma taken niana ra'ala papay ya'anni-yemannu pa rhopliala ahu gaini, ina.” ");
INSERT INTO lex_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Noma patke' de nakot la Yesus niwra: “Plola, plola Matroma. Mere ahu mak kdella mei nayanni mana na'an walia yamanan lu'wu maka keke'eni re ratunia.” ");
INSERT INTO lex_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Noka Yesus Nakot la patke' de: “Onnila lirmu di, mlia' meman la dodo'ondi, yoma hegan de ema ratargot oleka la a'namu ralamni.” ");
INSERT INTO lex_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Patke' de nawal lia roma nayanni. La' de nlernana a'nani e nanina la lewu wawannu, ne hegan de ema ratargot oleka wa. ");
INSERT INTO lex_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Noma Yesus Nwaran la Tirus, ne la Nlola Sidon nhor diewade Nlola Dekapolis lowanni pa Nokria danau Galilea. ");
INSERT INTO lex_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","La' hande de riy rodia mak khatilu-khamanu id la, ne rwak la riwra: “Tungkurg ee, Mtiulan pa Mliapar limmu la riy di wawannu.” ");
INSERT INTO lex_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","La'pa Yesus Nahala la riy rahu re totpa rmeh'a, na'nama Ntuwnu okarni la riy de tlinni hu'ulli, na'nama Nakrui la pa Nteman la'a riy de namni. ");
INSERT INTO lex_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nhor nioka Yesus Nwatniar rer lia lyanti, ne Nhedga aranni na'nama Nakot la: “Efata!” nnia'eratni de “Muphyar wia.” ");
INSERT INTO lex_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Noma riy de tlinni naphyar wia ne, mtatan de nekpa namni wniutnu mana natiewar doin la, ne naltier samomuou wa. ");
INSERT INTO lex_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Dewade Yesus Nano'a mak kdella hande pa totpa yana rwahaur nohora la riy. Mere yeher to' pa Nano'a la ira, yeher neka rla rwahaur nohora la'a meni-meni. ");
INSERT INTO lex_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Riy mak katlin nan de rwer rer wiawni pa riwra: “Yesus hihi'ini-yapyapni honona re, samomuou memna! Mak khatilu mana Nhi'a pa ratlina, me maka khamanu mana Nhi' pa raltieri.” ");
INSERT INTO lex_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lera ida ne riy rahu rawoka owa'an la Yesus onni. Riy rahu re rakleh yamanna pede Yesus Npol lia maka ha Nwatutu-nwaye'a re pa rma rawoka na'nama Niwra: ");
INSERT INTO lex_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“A ralmu ntuin doin la' rimormior mutlialawna ri. Hari e rlernohor rer A lia lera wotelu mere ha rakleha yamanna. ");
INSERT INTO lex_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","La'pa Agolin doin hare pa rla'awa de apannu rahgali, yanhi'pa gaini rmokal lol talan letgara, yoma dom de rwatiawua geni-tiena mak olieta.” ");
INSERT INTO lex_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Noma maka ha Nwatutu-nwaye'a re ratiana: “La'a gen hgal di de hota itlernana yamanan la hanmeni, pa itala la rirahu ri ra'ana?!” ");
INSERT INTO lex_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“La'a wareher genmi, rot wo'ir erla?” Rwahla riwra: “Wo'itu.” ");
INSERT INTO lex_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Noma Yesus Nhopan pa riy mutlialawna re rakpernernia la tani wawannu. Dewade Yesus Na'ala roti mieha re wo'itu na'nama Na'uli-nawedia Uplerlawna. Nhor nia'nama Nhawi-nhawia re pa Nala la maka ha Nwatutu-nwaye'a re rhakre'era la rimormioria niutni-mdierna re. ");
INSERT INTO lex_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Maka Yesus ha Nwatutu-nwaye'a re rodia i'na prowta ida-woru wali. Dewade Yesus Na'uli-nawedi owa'an Uplerlawna, nhor nia'nama Nhopan pa rhakra i'na rella. ");
INSERT INTO lex_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Rirahu re ra'an pa rpehera, na'nama maka ha Nwatutu-nwaye'a re rwaho'a-rwatierun de rlernana maka ha ra'an atre'a, de kriou penpuenu wo'itu. ");
INSERT INTO lex_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Rhor momuoga mak ka'ana re la'pa edon nhal de riy riwnu wogata. Nhorwua dewade Yesus Nhopan pa honona rawal lia' genni-tienni. ");
INSERT INTO lex_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na'nama Yesus Nora maka ha Nwatutu-nwaye'a re rha'at la puou pa rla'awa Dalmanut yapatni. ");
INSERT INTO lex_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Noma riy Parisi rma ratian la'a-ratian mai Yesus. Riwra rtota Yesus la klieratni pede rhopan pa Yesus Ntutga hihi'a-yapyapi mak kamehi-kayona id totpena irat muemna de Yesus plolli-mneheni nwatiawua Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Noma Yesus Nhedga aranni Niwra: “Adoh! Nihya'pa rimormiori la lera-mela ri rhopan pa Aghi'a hihi'a-yapyapi mak kamehi-kayona?! Mere mitlino! Hihi'a-yapyapi mak kamehi-kayona kuku' nek ho'mana, A'g edon tiutga tiy miy.” ");
INSERT INTO lex_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nhor nioka Nto'or doinia ir la hande pa Nha'at owa'an la puou pa rleret lia walli. ");
INSERT INTO lex_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","La' noma maka Yesus ha Nwatutu-nwaye'a re rhortaplin pa edon rodi wareherni (roti), enekneka ida nmeh'a la puou ralamni. ");
INSERT INTO lex_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Noma Yesus Nwagahniorta re Niwra: “Hyalia, mhioratreria! Hota miy ererma la'a tgo'a Parisi rora ray Herodes.” ");
INSERT INTO lex_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Noma rwarora pa idma nakot la ida riwra: “Nakot emkade yoma itakleh roti.” ");
INSERT INTO lex_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesus Nat niohora hya' ed maka ha rakotkota pede Nakot la re: “Nihya'pa miakokan nohora roti hadamonna?! Miy ralma-riormi edonna nla' nan ma'ta?! Ralammi ratehra to'owa. ");
INSERT INTO lex_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Matmi reprepra mere edon mimkek nana, ne mtiaru tlina mere edon mitail nana. Miy edonna mhiorat nan ma'ta?! ");
INSERT INTO lex_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","La' lera maka Aghawierie'er roti wolim pa Agaitiutur nana riy riwnu wolima, de miy orgahami miwok nan korni kriou penpuen re, maka ha ra'an atre'a re wo'ira?” Rwahla riwra: “Kriou termida wehrani woru.” ");
INSERT INTO lex_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ne la' walia rot mieha wo'itu maka Agala tiutria riy riwnu wogata, dewade miwok rehenu de kriou penpuenu re wo'ira?” Rwahla riwra: “Kriou wo'itu.” ");
INSERT INTO lex_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Noma Nakot la re: “Miy ralma-riormi edonna nla' nan ma'ta?!” ");
INSERT INTO lex_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nhor nioka Yesus Nora maka ha Nwatutu-nwaye'a re rte'ela leta Betsaida. La' hande de, riy rodia maka matni yata id pa rla rwak la Yesus pa, totpa Nteman nana la. ");
INSERT INTO lex_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesus Nte'la la mat yata de limni pa Nodgiota la leta to'orni. Noma Nakrui lia riy de matni, ne Nteman limni la riy de matni, noma Natiana Niwra: “Mumkek oleka hadomdoma?” ");
INSERT INTO lex_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Riy de namkek la gaini, nhor nioka niwra: “A'umkek nan riy, yoma a'umkeka riy ralala'a, mere yamkekni emolmolan to'a orona-augona.” ");
INSERT INTO lex_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesus Ntemn owa'an limni la riy de matni, dewade riy de ntot pa niwra namkeka na'nama riy de matni nkalwied wa, nhi'nande namkek nana hya'a-hya' de reprepra. ");
INSERT INTO lex_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nhor nioka Yesus Nhopan pa riy de nla'awa romni mere Nakot la: “Mlia' de yana mliola leta de ralamni pa mpiahauria hadi!” ");
INSERT INTO lex_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Noma Yesus Nor mutwualli re rla'a leta-ruhun mak kdella leta Kaisarea Pilipi onni. La' talan letgara Enatiana mutwualli mak ha Nwatutu-nwaye'a re Niwra: “Nhi'inde riy e riwra A' die he'o?” ");
INSERT INTO lex_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Noma mutwualli re rwet la riwra: “Tuna, riy dom de riwra Yohansi makharani O'a, mak kmori owa'ana, dom de riwra makwohorulu-ktatrulu Eli. Dom de riwra makwohorulu-ktatrulu dom to'a.” ");
INSERT INTO lex_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Noka Yesus Natian owa'ana: “Mere A'utian tek miy. La' miy wniarormi de, A' di de he' A'u?” Noma Petrus nwet la: “Matro'mu, O' di de Ray mak kodia mormiori-lewlewna maka Uplerlawna Nano'taru (Mesias) O inhatti!” ");
INSERT INTO lex_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Noma Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: “Maka Petrus nakota de naplol memna mere yan memmemna mikot nohor ma'ta hadella riy doma.” ");
INSERT INTO lex_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","La' ler de de pa nodi liarni Yesus Nwe'er doin meman la maka ha Nwatutu-nwaye'a re, de Uplerlawna ralma-riorni totpena Rimormiori A'na E' de hota Ntutulu-nlelewua kropna-krieutu, yamuki-yama'ala, me hota ina-ama Yahudi rora imam-imam re o'tani-matni, me makwatutu-kwaye'a agama rwayotli E'a. Ne Uplerlawna Nala pa hota rwen E'a mere la'pa nodia la lera wotellu owa'an de Enmori owa'an la E matmiati ralamni. ");
INSERT INTO lex_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nakota ploloi-plele'era lir di. Noma Petrus nheduma pa nte'la la Yesus pa rla'awa walli na'nama npolliohora Yesus pa nakot la: “Matroma, awuakwak de Uplerlawna Nter dioini-nhal doinia mak Omukot de!” ");
INSERT INTO lex_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Hya' maka Petrus nakota de edon nlernohora Uplerlawna ralma-riorni pede Yesus Nkillia maka ha Nwatutu-nwaye'a re na'nama Nawenan la Petrus Niwra: “Eh, mlia'awa walli hega'nu ne! La'pa omiwra hota A'g edon lier la yamuki-yama'ala de wniarormu de wniarora rimormioria de. Wniaror de edonna nwatiawua Uplerlawna.” ");
INSERT INTO lex_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Noka Yesus Npolga riy mutlialawna rora maka ha Nwatutu-nwaye'a re pa Nakot la Niwra: “Riy meni mak kiwra klernohor A'u, de nhoratdoin momuoga hya' ed maka e ralamni nod rer lia, ne nre' wut lia A' pua nler la yamuki-yama'ala onde matmiati pa emolmolan nekama nhoi wawayanni la auwlakra pa nlernohor A'u. ");
INSERT INTO lex_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yoma la'pa hameni maka edon nhoratdoinia mormiorni noh di wawannu de hota e' edon nler la mormiori-dardiari plalahwa pa nodi liarni. Mere la'pa riy maka khoratdoinia mormiorni la noh di wawannu onnila A'u me Uplerlawna Kot Kalwiedni-Paitiotni rerieini, de hota nlernana mormiori-dardiari pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","La'pa riy mak klernana nohkeran di re'eni-tniarnu honona mere hota edonna nlernana mormiori-dardiari plalahwa pa nodi liarni, de hota re'eni-tniarnu re nodi untu hya' la' riy dena?! ");
INSERT INTO lex_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nohkeran di re'eni-tniarnu honona, ta'en niana nawel niana mormiori-dardiari plalahwa de mai ita toh?! ");
INSERT INTO lex_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","La'pa he' maka kmola-kma' pa kreinian A'u me kwayow nana A li'ru-A tu'nu la' riy yatyata-halala mak kahmena pesiay gaini ralamni la'a lera-mela ri, de hota Rimormiori A'na A' muana, muola-mua' wal pia rieinian riy della, la' ler maka hota Amuai owa'an de godia A A'mu plolli-mneheni hititni-repreparni pa Agor wutga Uplerlawna hopopanni (malaikat) mak edon kheik la do'a-hala ralamni Ammai die.” ");
INSERT INTO lex_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","“Mhioratreria! Hota la'a miy hononmi la handi de riy dom de mak edonna rmati mia'ta mere hota ramkek ulu Uplerlawna Nodi plolli pa emeka mak ktorna-krautu.” ");
INSERT INTO lex_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Noma la'pa lera wonema rlardoinla noma Yesus Nodia Petrus nor Yakowsi me Yohansi pa rmeh'a rla'awa wo'or tutulu id hananni. La'pa rwatniar temna Yesus de gaini to'ama. ");
INSERT INTO lex_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ne naniayarni hitita-reprepra. Riy id la nohkerkeran di wawannu mana edonna namkek taru naniair wawahra mak emkade. ");
INSERT INTO lex_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Plin-plinnianamde maka Yesus ha Nwatutu-nwaye'a re ramkek nan walia Elia, Musa rora Yesus rwahauru. ");
INSERT INTO lex_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Noma Petrus nakot la Yesus Niwra: “Tungkurga, itden la handi de samoga, pa hota Ompuayowa de amariria hoiwiali wotel lia handi totpena id la O'a, id la Musa, ne id wal lia Elia.” ");
INSERT INTO lex_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nakot emkade yoma naplin niohora hota hya' maka ha nakota yoma ramta'at wenna. ");
INSERT INTO lex_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Dewade kakam lawn ida npupun nana re noka ratlin nana lira ida nwatiawua kakam de ralamni pa Niwra: “A A'nu maka Asiayn memna inhatti. Mitlin la E lirni.” ");
INSERT INTO lex_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Plin-plinnianamde la'pa rkillia walli-walli ir edonna ramkek owa'ana riy doma, eneknek to'ama Yesus Nmeh'a. ");
INSERT INTO lex_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","La'pa rwatiawua wo'ora pa rerun wa noma la'a talla ralamni de Yesus Nano'a re Niwra: “La' de yan memmemna mikotkot nohora hya'a maka mimkeka re la'a riy. Mpiei niekpa nte'ela lerni mak Rimormiori A'na A' die hota muori owa'an la matmiati ralamni.” ");
INSERT INTO lex_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pede ir edon rakot nohor memna hade la'a riy doma, mere idma rwahu'ru ralma-riora la ida riwra: “Yesus lirni Niwra: “Ramori E la matmiati ralamni” nnia'eratni de hya'o?” ");
INSERT INTO lex_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Noma maka ha Nwatutu-nwaye'a re ratiana riwra: “Hya'a nrei pia makwatutu-kwaye'a agama re e riwra hota Elia nmai ulu nampena Ray maka Uplerlawna Nano'tar pua Namori-nalewna rimormiori Nmai?” ");
INSERT INTO lex_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Noma Yesus Nakot la re Niwra: “Plola hota Elia nmai ulu pa nwaho'a-nwatiernia hare honona. Mere nihya' pede ha rhorat targa la Puka ralamni riwra Rimormior A'na A'u hota Alier la kropna-krieutu, yamuki-yama'ala, nniahora-nniala'a me rwayotlia A'u? ");
INSERT INTO lex_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mere A'ukot tar tiy miy. Elia nmai olekwa, ne irlernohora ir ralam wamueheni pa rhi' yatyat e'a, rlernohora hya'a maka ha rhorat targa la Puka ralamni la'a e wawannu.” ");
INSERT INTO lex_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Noma Yesus Nor wutga ir wotelu rawali owa'an la riy maka ha Nwatutu-nwaye'a re korni. Na'nama ramkek de riy harahu er walia la hande, ne makwatutu-kwaye'a agama e rora maka ha Nwatutu-nwaye'a re rawo'or nohora. ");
INSERT INTO lex_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","La'pa riy rahu re ramkek nana Yesus wa dewade rheduma, noka rmahrur pua rwatroma. ");
INSERT INTO lex_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Dewade Yesus Natiana re: “Hya'a mak miwo'or nohora?” ");
INSERT INTO lex_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","La'a riy woklawan de ralamni de muanke' ida niwra: “Tungkuru, a a'nu di agodia tiy O'a, yoma hegana nhu'ru ralma pa naplinu naltieri. ");
INSERT INTO lex_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ne la'pa hegan de nhu'ru ralma, a'nu di de nalitria pa lakweheiya la nohmarna, aparni nou-natna, nut nihini me inonni nweher wenna. Awuak olek la maka Ompuatutu-mpuaye'a re totpa rhokar doinia hegana-kawun della mere taken niana irhokar doinia la.” ");
INSERT INTO lex_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Noma Yesus Nakota Niwra: “Hoi, miy mak kakleha pesiay. Hota lera wo'ir owa'an pa Agor miy tialla me Agod niohor miy, nanpena mimpiesiay A'u?! Miodia keke'en de mmiai!” ");
INSERT INTO lex_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Noma rodi keke'en de. La'pa hegan de namkek nan Yesus dewade, plet pa nkarwa'ga keke'en de la tani wawannu pa limni-lakni totok la wewehera, nwakloli-nwaklali, ne aparni mana nou-natna. ");
INSERT INTO lex_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Noka Yesus Natiana keke'enku' de amni niwra: “Anni wo'ir olek la hadi nlernana hadina?” Wniahlani: “Nlernana hadi la' ler maka kuku' ma'ta. ");
INSERT INTO lex_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nhi'inde hegan de na'ita la ai ralamni onde la' gera ralamni pa ntota pa nwenna. Hade pede la'pa Tuna Nodi plolli pa Mtiulan mai ami, de Mtiulan-msiayn nan ami ee!” ");
INSERT INTO lex_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesus Nakot la: “Lirmu miwra: “La'pa Agodi plolli?!” Uplerlawna Nodi plolli pa Nhi' nana hya'a-hya' to'owa, hornama riy rpesiay E'a.” ");
INSERT INTO lex_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na'nama keke'en de amni nhaun pa niwra: “Apuesiay olekwa. Mere Mtiulan la a pua a ralmu yana worwuorga mere yeher to'a a pesia'yu naruri.” ");
INSERT INTO lex_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","La'pa Yesus Namkeka riy harahu rma rhopnu-rpepan wa dewade, Nhok temna hegan de Niwra: “Hega'nu na maka khi' riy pa rhatilu-rhamanu, Aghopnu, mhuargot la la keke'en di, ne yan muwali owa'an la ralamni!” ");
INSERT INTO lex_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Noka hegan de nhaunu-nhaunu me nkahyoi-nkada'ala nan memna keke'en de na'nama nlergot la ralamni. Keke'en de, tamkek de emek mati, nhi'nande riy rahu riwra: “Nmati olekwa!” ");
INSERT INTO lex_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mere Yesus Nte'la la keke'enku' de limni pa namata, dewade nmeh'a naprir wia. ");
INSERT INTO lex_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","La'pa Yesus ed olek la roma nayanni, ne maka ha Nwatutu-nwaye'a re rmeh'a rora, dewade ratiana riwra: “Tuna, hya' nrei piede taken niana amhokar doinia hegana-kawun della?” ");
INSERT INTO lex_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nwahla re Niwra: “Eneknek to'ama msiumbaini plein, nanpena mliernana plolli-mneheni pa mhiokar doinia hegana-kawnu mak emkadi.” ");
INSERT INTO lex_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yesus Nora maka Nwatutu-nwaye'a re rwaran la hande pa rlola Galilea lowanni, ne Yesus Nahmena riy rat niohora eda de, ");
INSERT INTO lex_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","yoma entepartarlia wniatutu-wniaye'ela maka ha Nwatutu-nwaye'a re. Nakot la re: “Rimormiori A'nani A' die, hota ral A lia rimormiori limni ralamni. Ne rwen A'u mere hota Amuori owa'an la matmiati ralamni, la'a lera wotellu.” ");
INSERT INTO lex_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mere maka ha Nwatutu-nwaye'a re edonna rna'erit nana Yesus Nakotkota re. Ne ir nek de ramta'at wali pia edonna ratian la'a-maiya Yesus ralma-riorni. ");
INSERT INTO lex_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","La' noka Yesus Nora maka ha Nwatutu-nwaye'a re rmai lia leta Kapernaum. La'pa Yesus ed olek la roma ralamni, dewade Natian nohora maka ha Nwatutu-nwaye'a re: “Hya'a maka miwo'or nohora la talla letgarni dena?” ");
INSERT INTO lex_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mere ir edon rwahla E lirni yoma la'a talan letgar de rawo'or nohora he' ed maka inponni narehi lia ir mutnu ralamni. ");
INSERT INTO lex_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Noma Yesus Namtatna na'nama Npol wutu maka ha Nwatutu-nwaye'a termida wehrani woru re pa Nakot la re: “He' mak katu klol yawa me natu nhima-nre'a e rimormior wialli ed maka inpon rehia la Uplerlawna yamkekni.” ");
INSERT INTO lex_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Noma Yesus Ntorreri keke'enku' ida limni na'nama Nala pa ntutrier lia ir honona gaini ralamni, nhor nioka Nkorreri keke'enku' de pa Nakot la re: ");
INSERT INTO lex_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Hyal miy re, hota he' mak kreiniana-ka'nana keke'enku'a emeka hadi onnila A rerie'yu de emekwalima nreinian olek A wua. Ne la hameni mak kreiniana A'u, de emekwalima nreinian olek walia Uplerlawna mak khopn A'u.” ");
INSERT INTO lex_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohansi Niwra: “Tungkurga, ami e mamkeka riy ida nhokra hegana-kawnu, de e nwet la Tuna nanni pede ami e mlarna de yoma it mutwualli atia'a hade.” ");
INSERT INTO lex_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Noma Yesus Niwra: “Yana mliarna de, yoma hameni mak khi' hihi'a-yapyapi mak kamehi-kayona, de e rwet la A na'nu edonna plet pa rwaldioinia pa napolu-naliella A na'nu. ");
INSERT INTO lex_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yoma hameni mak edonna khoklira-kpah'a wawa la ita de nnia'eratni de ir er maka ktulan la ita. ");
INSERT INTO lex_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mhioratreri, plolli pa he'a nala gera pa miy miemnu totpa natihliutu-nawriena aran miy onnila miy di de maklernohor Kristus, hota nlernan memna siewni-kaini la'a Uplerlawna.” ");
INSERT INTO lex_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“He' ed mak kariei pia riy mak kakleha weli emeknekama keke'enku' di pa edonna rpesiay owa'an mai A'u, de Uplerlawna niukamnu la' riy de nareh dioin meman la'pa riy rkohg watga werwerta id la e tiernu totpa ratepar wenna la hletan lawna. ");
INSERT INTO lex_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","La'pa limmi ed mak kodi miy lia do'a-hala de mdieul dioinia la. Yanpa miodi limmi rora re pa rnakulta'ru la ai mormiori ralamni maka ta'eni rwarum nana me oranni mak kden hande mana edonna nmati. Samomuounu de miod lim memehemi pa mior tiemna Uplerlawna la Ilyamou-Watyatoha. ");
INSERT INTO lex_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","La'pa lakmi ed mak kodi miy lia do'a-hala de mdieul dioinia la. Yanpa miodi lakmi re rora pa rnakulta'ru la ai mormiori ralamni. Samomuounu de miod lak memehemi pa mior tieman Uplerlawna la Ilyamou-Watyatoha. ");
INSERT INTO lex_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yoma ai mormiori die ta'eni rwarum nana me oranni mak kden hande mana edonna nmati. ");
INSERT INTO lex_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne la'pa miy matmi ed mak kariei pia mlier la do'a-hala ralamni de mkiopil doinia. Yanpa matmi rora tetema pa rnaklia miy lia ai mormiori ralamni. Samomuounu de miod nieka matmi id pa mior tieman la Uplerlawna la lodanni-hairni. Yoma: ");
INSERT INTO lex_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“Ai mormior die ta'eni rwarum nana me oranni mak kden hande mana edonna nmati.” ");
INSERT INTO lex_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Rima-rima de rala ai ra rakio'a. ");
INSERT INTO lex_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kio' de plola pa samoga, mere la'pa kio' de edonna nmahana, de ta'en niana ra'itr owa'ana ha mahanni toh?! La' mormiormi ralamni de mhi'a-myapia de emolmolan nekama kio'a, me yana idma nawo'or nohor ida.” ");
INSERT INTO lex_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","La'pa Yesus Nwahaur pa nhorwua noma Nwatitin la leta Kapernaum de pa Nla'awa noha Yudea, me la' gerlawna Yordan walli. Ne la' hande mana riy rahu rmai tiemna, ne emekwali yehwa ululu de Nwatutg owa'an ira. ");
INSERT INTO lex_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Noma riy Parisi rmai lia hande pa rtota-rwudia. Ratiana Yesus riwra: “Tuna, la'pa muanke'a ida nhopliala hawni patke'a de, lol tatra me edonna?” ");
INSERT INTO lex_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mere Nwahla Niwra: “Hya' ed maka Musa ne'er taru-ntatar targa tiy miy?” ");
INSERT INTO lex_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rwahla riwra: “Musa nwayow nohor pa tsi'a horta yapie'era la hawa patke'a maka it tahmen doinia la.” ");
INSERT INTO lex_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Noma Yesus Nakot la re Niwra: “Onnila o'ta tehrami lawan rehi nreiniande Musa nhorat taru nnie'era-tniatar de tiy miy. ");
INSERT INTO lex_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Mere la' ler maka Uplerlawna Nakoki-nayapi nohkerna E' ed maka khi'a-kyap niana rimormiori, de muanke'a nora patke'a.” ");
INSERT INTO lex_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“La hade pede hota a'na muanke'a ida naltarga inni-amni pa la nora hawni patke'a rla' wutg ida ");
INSERT INTO lex_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","totpa rla' ihyida-ralmida.” Nhi'nande hare de riy worg atia'a, mere riy id to'a. ");
INSERT INTO lex_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","La hade pede la'a patke'a rora muanke'a maka Uplerlawna Nwatiehra oleka, de yan memmemna riy ida ntota pa nreiyapie'era.” ");
INSERT INTO lex_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","La'pa ira rmai lia roma nayanni, dewade maka ha Nwatutu-nwaye'a re ratian wali Yesus la'a mak kapie'er la mehlima-marya'a. ");
INSERT INTO lex_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Noma Yesus Nakot la: “La'pa muanke' ida nhopliala hawni de pa nla nora patke'a id owa'an rmehlima, enhi' do'a-hala la hawni patke'a de, yoma nhopliala hawni patke' de emeknekama nalira-naliai lia Uplerlawna yamkekni. ");
INSERT INTO lex_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ne la'pa patke' ida nhopliala hawni muanke'a pa nla nora muanke'a dom to' id owa'ana rmehlima, hade de yalira-yaliai lia Uplerlawna yamkekni.” ");
INSERT INTO lex_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Doma rmai die rodia upni-a'nani la Yesus totpena Nran limni pa na Nhilpai-nmanatga re, mere maka ha Nwatutu-nwaye'a re rawenan la re. ");
INSERT INTO lex_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","La'pa Yesus Namkek nana hihi'ini re dewade Nawenna pa Nakot la re: “Miolin doinia keke'enku'a re pa rmai A' die. Yana mpiayotlia re, yoma riy mak edon katulu-kapetna inonni mere plet pa rpesiay pia emeknekama keke'enku'a re er maka Uplerlawna Nwaliria pa rler teman la riy mak kmormior lia E tnioranni-riautnu ralamni. ");
INSERT INTO lex_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mhioratreria, riy maka edonna kpesiay Uplerlawna pa emeknekama keke'enku'a rpesiay, de hota edonna rler wut lia Uplerlawna mutnu-rahanu.” ");
INSERT INTO lex_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Noma Yesus Nkolla keke'enku'a re, na'nama Nran limni la wawannu re pa na Nhilpai-nmanatga. ");
INSERT INTO lex_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ler maka Yesus Nwaran pa Nodi liarni la yala'ani de, riy ida nawlar niohora pa nwatroma, na'nama nwaltior la gaini ralamni pa natiana niwra: “Am tungkurga, mak kalwiedweda O'a! Hota aghi'a hya' totpena aliernana mormiori-dardiaria plalahwa pa nodi liarni?” ");
INSERT INTO lex_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Noma Yesus Nakot la Niwra: “Hya'a nrei piede omhuari lirmu mai A die muiwra A' di de riy kalwied id A'u? Riy honona edonna rkalwieda, eneknek to'ama Uplerlawna Nmeh'a nanpena Nkalwiedweda. ");
INSERT INTO lex_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ne orgahamu muat niohora Uplerlawna riorni-liaini (deullu-tatarni) niwra: “Yana mpunu-mpuenna, yana mulira-muliai, yana mkiamnelu-mkiamna'a, yana muod niana riy mak khala, ne mputra-mpalka, muatu mu'unni-mumta'ata inmu-ammu.”” ");
INSERT INTO lex_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Noma riy de nakot la Yesus niwra: “Tungkuru, maka Mukot taru honona re de aliernohora momuog oleka la'a adien ma'ta la tuwari-laweru lewatni la'pa ntutu-nte'ela' ler di.” ");
INSERT INTO lex_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesus Namkek tertehra riy de ne Nsaynia. Nakot la: “Hyalia, id edama pa yana mhuoratdoinia. Hota mlia'awa pa mu'ol dioin momuoga re'emu-tniarmu pa muala welli kupna-kai la'a riy mak kakleha-kaplara, a'na ri'ini patyatni, ne hota omliernana re'a-tniaru la Ilyamou-Watyatoha. Mhi' hare honona nanpena ma mliernohor reri A'u.” ");
INSERT INTO lex_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mere la'pa riy de natlin nana lira-tunu re dewade gaini nwahra pa nla'awa de ralamni nmolu-nhelam doin la, yoma re'eni-tniarnu harahu rehia. ");
INSERT INTO lex_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesus Namkek la maka ha Nwatutu-nwaye'a mak kdella walli-walli re na'nama Nhar lirni la re Niwra: “Riy mak kre'a-ktaru riwra rre' teman la Uplerlawna mutnu-rahanu, de rler la yawuhi-yawe'et lawna.” ");
INSERT INTO lex_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Maka ha Nwatutu-nwaye'a re rheduma yoma lirni de. Mere Yesus Nakot owa'ana: “U'pu-a'nu miy re, riy mak kha'ar aranni la'a re'a-tniaru riwra rre' teman la Uplerlawna mutnu-rahanu, de rler la yawuhi-yawe'et lawna. ");
INSERT INTO lex_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yoma riy mak kre'a-ktaru mak kiwa rre' teman la Uplerlawna mutnu-rahanu mak Enodi plolli la emeka Ray, de hota emeknekama hayori lawna niwra nlola nhior lawra hu'ulli, mere taken niana.” ");
INSERT INTO lex_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","La'pa maka Yesus ha Nwatutu-nwaye'a re ratlin nana Yesus lirni-tunnu re yeher to'a pa honona re rwer rer wiawni. Noma rakot la: “La'pa makre'a-ktaru re ta'en niana rla' Uplerlawna mutnu-rahanu de hota he' ed maka klernana mormiori-dardiari plalahwa de ho'a?” ");
INSERT INTO lex_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesus Namkek la honona na'nama Nakot la Niwra: “Ta'en niana rimormiori ramori-ralewna inonni. Mere Uplerlawna Nodi plolli pa Namori-nalewna ira, yoma Uplerlawna plolli-mneheni etla pa Nhi' nana-nyap niana hare honona.” ");
INSERT INTO lex_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Noma Petrus nhar lirni pa niwra: “Matroma, a hononam di de ami e mto'or momuou lia haneknek wawannu pa ami e mlernohor O'a!” ");
INSERT INTO lex_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesus Nwahla lirni de Niwra: “Mpiesiaya, la' pa he' ed mak kaltarga romni, nor wutga hawni-a'nani inni-amni inni-narni onde nhyi'ini, yoma la' A rerie'yu me la'a Kot Kalwieda rerieini ");
INSERT INTO lex_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","de hota riy de nlernan memna wniahlani la Uplerlawna la' lera-mela ri. De nlernana rahu ida tni'illi la'a romni nor wutga hawni-a'nani inni-amni inni-narni la'pa nhyi'ini, me nlernan walia yamuki-yama'ala. Ne hota la' ler maka kmai die e nlernan walia mormiori-dardiari plalahwa pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mere hota riy mutlialawna makla' orkotkota-ornanana onde mak kre'a-ktaru hota rtawli'iru ne mak kakleh weli onde mak edon kre'a-ktaru hota rala' ul tiargho'a.” ");
INSERT INTO lex_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Noma Yesus Nora maka ha Nwatutu-nwaye'a re e ralala' rer pia rokru Yerusalem, ne Yesus Nala'a la gaini. Pede maka Yesus ha Nwatutu-nwaye'a re ema rtaplelleltarga, ne riy rahu maka klelernohora pa ktawli'iru re, ramta'at wali. Ralamni owa'ana Yesus Nawoka-nale'ga maka ha Nwatutu-nwaye'a re riy termida wehrani woru pa rmeh'a la' gen ida na'nama Nakot nohora la'a hya'a maka hota riy rhi' nana la E'a. ");
INSERT INTO lex_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Lirni: “Mitlina! Dodo'ondi de itsortut niana Yerusalem. Hota la hande de ra'ol Rimormiori A'na A' die la imam-imam o'tani-matni me la' walia makwatutu-kwaye'a agama pa ra'anlira-remunwawa pa hota ha rukum pen A'u. Nhor niampena ral A lia riy maka Yahudi atia'a re. ");
INSERT INTO lex_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Hota rhi' A lia hamalmialia, me rakrui lia A ga'yu ralamni. Hota rliwra-rkaklia A'u me rwen A'u mere la'pa lera nodia wotellu, noma hota Amuori owa'an la matmiati ralamni.” ");
INSERT INTO lex_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Noka Yakowsi nora Yohansi, Sebedeus a'nani re rmai tiemna Yesus pa rakot la: “Tungkuru, ampak de Omhur niohora a wakwak mamni ida!” ");
INSERT INTO lex_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Nwahla re Niwra: “Hya' ed maka mpiaka pa Aghi'a tiy miy?” ");
INSERT INTO lex_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Noka riwra: “Mpuayow nohor pa amor O'a mamtatan pa mhapetre'ru la geni hitita-homomarmu ralamni, totpa amlernan wali ya'uli-yawedi.” ");
INSERT INTO lex_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mere Yesus Nakot la re: “Miy miplin niohora miy wakwakmi de. Hota miy di de mpiaran pia mitahan nana kropna-krieutu nniahora-nniala'a maka Aliernan dena?” ");
INSERT INTO lex_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Noma rwahla Yesus yatianni de riwra: “Hota amtahan nana.” Yesus Nakot la re Niwra: “Plola hota mlier la kropna-krieutu maka Aliernan de, ");
INSERT INTO lex_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","mere hota la'pa mak kamtatan la A wa'lu malwiru-malganna pa rhapet reri A' die, A'g edonna godi plolli pa wuet la riy meni ed mak kamtatan la gen die. Mere he' ed mak kamtatan la geni-tien de, Uplerlawna Nwalir nian oleka hare la' ululu.” ");
INSERT INTO lex_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","La'pa riy mak ha Nwatutu-nwaye'a re korni riy termida re ratlin Yakowsi nora Yohansi wakwakni de ralamni ramehra la riy maroro'a re. ");
INSERT INTO lex_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hade pede Yesus Npolg awoka momuoga honona na'nama Nakot la Niwra: “Hyal miy re, miatg oleka de maka ha rhoiya la o'ta-mat lalawna me mak klernana gen tiutullu maka kodi plolli la' luwu-a'na mak kaplin niohora Uplerlawna, de rtern apitga limni-rorni. ");
INSERT INTO lex_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yana mhi'a nhioli-liet mak emkare. Mpialdioinia de, la'pa he' mak kiwra klernana gen tiutullu, talanni, de nhoi-ntania rimormior wialli pa emeknekama hopopna ida nhoi-ntania matromni. ");
INSERT INTO lex_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne la riy mak kiwra kala' ul miy, de nwahyar tialan pa rimormior wialli rlola pa emolmolan nekama ata-wa'ara ida nhi'a la matromni. ");
INSERT INTO lex_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yoma Rimormiori A'na A'u nek de Amuai die A wniaro'ru totpa edonna rhoi-rtani A'u, mere Amuai die ghoi-tiania rimormiori, me gal ino'nu emeka tniuwu-nhiaiya pa A'ulewna rimormiori harahu mak kwatiawua hairi-hairi honona.” ");
INSERT INTO lex_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Noma Yesus Nora maka ha Nwatutu-nwaye'a re ralala'a pa rte'ela leta Yeriko, de riy rahu lidna-tauru. La'pa rwaran la Yeriko, de riy ida mak matni kyata e namtatan pa nmeh'a nawakwaka la talla aratni. Riy di de, nanni Bartimeus, Timeus a'nani. ");
INSERT INTO lex_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","La'pa natlin nana riy mak kmai, de Yesus mak kwatiawua Nasaret, dewade mak matni kyat de nhaun pa niwra: “Yesus, Ray Daud upni-a'nani ne! Mtiulla-msiayn nan a'g ee!” ");
INSERT INTO lex_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Riy harahu mak kden la hande rawenan la riwra: “Hoi! Molmuo'lu!” Mere yeher to'a ma narur lia nhiaunu pa niwra: “Ray Daud upni-a'nani nee! Mtiulan-msiayn nan a'g ee!” ");
INSERT INTO lex_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Noma Yesus Ntut tiaru na'nama Nhopan pa rla rpolga mak matni kyat de. Dewade rla rpolga riwra: “Ee! Mutetehra ralammu pa muprir pia mmuai, yoma Npolg o'a.” ");
INSERT INTO lex_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Noka mat yat de no'lu dioinia rain plalahwani, na'nama naprir pia la nwatroma Yesus. ");
INSERT INTO lex_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesus Natiana Niwra: “Hya' ed maka mpuaka mai A'u?” Noma mat yat de nakot la Yesus Niwra: “Tungkurga, awuak de a'umkek owa'ana!” ");
INSERT INTO lex_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Noma Yesus Nakot la Niwra: “Hademkade de mlia'awa. Yoma ompuesiay A'u pede mkialwied wa!” La'a mtatan de nekpa matni re raphyar wia, noma riy de nlernohor reri Yesus la talla ralamni. ");
INSERT INTO lex_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","La'pa Yesus Nora maka ha Nwatutu-nwaye'a re rhi' pa rwakriania Yerusalem noma rlola Betfagi nora leta Betania mak kdella wo'ora Saitun hananni. Noma Yesus Nhopan pa maka ha Nwatutu-nwaye'a riy woru rala' ulu ");
INSERT INTO lex_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","pua rla'a let maka ir rwakrian olek de. Yesus Nano'a re Niwra: “Hota la'pa mimtie'ela hande de hota mimkek nan memna keledai a'nani ida e nakniohu. Keledai de edonna rwatutu ma'ta nhia'ani. Ne mlieretniekla miewar doinia la pa miodia la handi. ");
INSERT INTO lex_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","La'pa riy ratian miy lia hya'a nrei pia mimpie'er doinia keledai dena? De mikot la miwra: “Itmatromlawanni e Nwaka (perlu) de! Ne hota Nnairia pa nhorwua de plet pa Enhopan pa amodi mai owa'ana.”” ");
INSERT INTO lex_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Dewade riy maroro'a re rla'awa, la' pa rlernana keledai trapriapi ida nakniohu lia puohra gaini walli tio'ora, la' talla aratni. La'pa e rewar rer mia'ta keledai a'na de, ");
INSERT INTO lex_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","noma riy dom mak ktutrier lia hande ratiana re: “Hoi! Hya'a nrei pia mimpie'er doini keledai a'na dena?” ");
INSERT INTO lex_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Noka rwahla re rlernohora hya' maka Yesus Nakot targ oleka la ira. Noma riy re rollia ir pa rwe'er doini keledai de pa rodia. ");
INSERT INTO lex_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nhor nioka rodia keledai della Yesus nhor nia'nama rala ir rain plalahwani ra rwowa keledai de to'orni totpena Yesus Nha'a nana. ");
INSERT INTO lex_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Riy harahu rtutga nhiu'ru-nhielma la'a rala naniair plalahwa ra rwowa la' talla, me korni rtuhia ora tawi-au tiawi motmota la'a nhyi'ini pa ra re'era la talla, totpena keledai de nlola wawannu. ");
INSERT INTO lex_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Riy rahu re la'pa rlol gaini me mak ktawli'iru pa rletgar nana Yesus. Ne rhaunu-rhaun pa riwra: “Ya'uli-yawedi nden rer tiy O' ee! Ta'uli-tawedi, tsu'ru-tselma O' mak mai pia kodia Orgahi-Orha'a nanni! ");
INSERT INTO lex_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ya'uli-yawedi la ray Daud upni-a'nani mak kmai pia Ntorna-nrautu! Ta'uli-tawedi, tlilili-tmamuau Uplerlawna la tutullu-lolo'oni!” ");
INSERT INTO lex_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","La' pa rte'ela Yerusalem dewade Yesus Nla'awa la Uplerlawna roma kreini. La' hande de Nlili-nloh momuoga, mere yoma lera nhi'pa nmel wa de Nlergot pa Nora maka ha Nwatutu-nwaye'a termida wehrani woru re rokru leta Betania. ");
INSERT INTO lex_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","La'pa repar wa noma Yesus Nor mutwualli re rhoitio'or la leta Betania pa rla'awa dewade Yesus Naplar olek wa. ");
INSERT INTO lex_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Noma Yesus Ndella oliet pa Namkek nana kar ona ida mak katawi olek wa, noma Nla Nwahak wo'oni pa Na'ana, mere kar on de nakleh wo'a. Mere tawni mamaini yoma kar wo'a lerni edon ntut ma'ta. ");
INSERT INTO lex_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Noma Yesus Nhar lirni la kar on de Niwra: “Dodo'ondi mkieran wa pa hota omukleh wo' owa'an wa!” Ne maka ha Nwatutu-nwaye'a re mana e ratlin reria. ");
INSERT INTO lex_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","La'pa rte'ela la'a Yerusalem noma Yesus Nla'awa Uplerlawna roma kreini herni-gaini na'nama Nhokra-nlaiya mak ka'olu-kala'a kaweli-kaphar la hande. Nte'la la mei-kader maka ha rwahernia kupna me mak ha ra'olu-rala'a ma'nu loktieru, pa Nkowa-nwalia. ");
INSERT INTO lex_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ne edonna Nhur dioinia riy pa rodia yohya' maka ha ra'olga pa rleret lia Uplerlawna roma kreini herni-gaini. ");
INSERT INTO lex_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Noma Nakot la mak ka'olu-kala'a kaweli-kaphara re Niwra: “Edon miat niohora hya' maka ha rhorat targa la Puka ralamni la'a Uplerlawna lirni?! De Niwra: “Hota rweta A ro'mu de roma sniumbain geni la'a noha-rai honona la'a nohkerna-rai miaran di.” Mere miy e mhi'a la roma kamnelu-kamna' geni!” ");
INSERT INTO lex_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Imam-imam o'tani-matni rora makwatutu-kwaye'a agama ratlin nan hade dewade rahak talan pa rwenna Yesus, yoma ramta'at E'a, onnila ramkeka riy rahu e rwer rer wiawni la E wniatutnu de. ");
INSERT INTO lex_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lera la nhelma dewade Yesus Nor wutga maka ha Nwatutu-nwaye'a re rwaran la let de. ");
INSERT INTO lex_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Repardoin de Yesus Nora maka ha Nwatutu-nwaye'a re ralala' reri de ramkek de kar on de nkern olekwa, nla meman la ga'arni. ");
INSERT INTO lex_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Noma Petrus nhoratnana Yesus Nlokar oleka kar on de, noka nakot la Yesus: “Tungkuru mumkek la kar on maka Mliokar de nmati olekwa.” ");
INSERT INTO lex_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesus Nakot la re: “Miy pesiaymi narur lia Uplerlawna! ");
INSERT INTO lex_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mhioratreria, he' nakot to'ola wo'or di pa nwarei lia tah'i lawna hota narinin la' tah'i lawna ralamni, hornama pesiayni edonna nwalera mere npesiay toto'a. ");
INSERT INTO lex_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mhioratreria! Hya' to' pa mimpiaka la'a miy sniumbainmi de hota mimliernana, hornama pesiaymi de yana nwalera. ");
INSERT INTO lex_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ne la'pa msiumbaini, de mhioratdoini riy do'oni-halli, hihi'ini-yapyapni tiy miy, totpa Ammi mak kdella Ilyamou-Watyatoha mana Namou-nawitna do'omi-halmi. ");
INSERT INTO lex_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Mere la'pa miy edon mhioratdoinia rira do'oni-halli tiy miy die, Amlawanmi mak kden la Ilyamou-Watyatoha mana edonna Namou-nawitna do'omi-halmi.” ");
INSERT INTO lex_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Noka Yesus Nora maka ha Nwatutu-nwaye'a rte' owa'an la Yerusalem. La'pa Yesus Nalala'a la Uplerlawna romni herni-gaini dewade, imam-imam o'tani-matni re me makwatutu-kwaye'a agama, ror wutga Yahudi in letni-am letni rmai pia ");
INSERT INTO lex_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ratiana Yesus riwra: “Tuna, he' ed mak ktemna plola-mneh della O limmu ralamni pede Omhi' nan hihi'imu-yapyapmu rena?” ");
INSERT INTO lex_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Noma Yesus Nwahla lirni re Niwra: “A'g e giwra utian tek miy la'pa mimpiet nana, de hota Awuahla miy, de la'a he'a plolli pede Aghi'a hihi'a-yapyapi re. ");
INSERT INTO lex_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pede A'utian tek miy, de hota Yohansi makharani de ha nlernana plol della he'a? Uplerlawna onde rimormiori?” ");
INSERT INTO lex_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dewade honona re rwahu'ru ralma-riora wamueh'a pa riwra: “La'pa itwet la Uplerlawna ed mak kala plolli la Yohansi de hota Eniwra: “Ne hya'a nrei pia miy edonna mpiesiay e'a?” ");
INSERT INTO lex_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mere yana it twet la tiwra: “Rimormiori plolli-mneheni hade.”” Rakot emkade yoma ramta'at rer lia rirahu yoma honona rpesiaya de Yohansi de makwohorulu-ktatrulu id hade. ");
INSERT INTO lex_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pede honona rla' lir id pa rwahla Yesus riwra: “Ami e maplinga.” Noma Yesus Nakot la re Niwra: “Hade emkade, de A' muana edonna ukot wahyaria tiy miy la'a he'a mak kala plolli mai A' pua Aghi'a hihi'a-yapyapi re.” ");
INSERT INTO lex_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Noka Yesus Nwahaur la imam o'tani-matni, makwatutu deulu-tatra, ror wutga ina-ama leta re Nnairia lira yawalliohora. Niwra: “Ornoha ida nawuli-natniamin anggur wo'a la nhyi'ini-tlunanni ralamni. Nteman riwta la nhyi' de walli-walli. Ne nahia hu'ula maka rahmi anggur turnu la ralamni. Nhor nia'nama nariria yatiak geni. Nwahi'a pa nhorwua noma nala nhyi'-tlunni anggur della riy rtimnia. Ne nla nalaun la riy ornoha. ");
INSERT INTO lex_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","La'pa ntutu la lerni-melli pa riwra rreiki-rwo'or wa noma ora nhyi' de nhopna e hopopanni-li'irnu id pa nmai pia na'ala ora nhyi'a nhiakarni la timanni-daharni. ");
INSERT INTO lex_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mere mak ktimni-kdahara re rwaldioin targho' pa rtorna ora nhyi'a hopopanni-li'irnu de, rwanalga me rhopan pa nawal die nhapirteum nan to'a. ");
INSERT INTO lex_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Noma ora nhyi' de nhopn owa'ana hopopanni id owa'ana. Mere emkade walia rliwra-rkaklia o'tani na'nama rahe'i-ramalia. ");
INSERT INTO lex_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Noma ora nhyi'-tlunni de na'enyat owa'ana hopopanni id to' pa nmai owa'ana, ne riy di mana rwenan nana. Ne korni mana harahu wali, dom de rliwra-rkaklia, dom de rwunu-rwenna. ");
INSERT INTO lex_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Korkorni de tre' ma'ta to'a a'na mak nsayn memna o'ta wat memeheni. Dewade ora nhyi'-tlunni de nhopna e a'nani yoma la'a wniarorni de: “Matialo'onamde ha rhu'ru-rhelma a a'nu.” ");
INSERT INTO lex_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mere mak ktimni-kdahara re idma nakot la ida riwra: “Maka hota kodi plolli la ononni e inhatti! Mai pia itatuinia aranni totpena hota nhyi'a-tlunan di it gahani!” ");
INSERT INTO lex_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dewade rtorna riy de na'nama rwenna pa rnaklia la nhyi' de to'orni.” ");
INSERT INTO lex_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Noma Yesus Natiana la mak katlina re Niwra: “Nah! La'pa ora nhyi' de nawal pia nmai de hota hya' ed maka ha nhi'a la maktimni-makdahara reno? Hota nma nhapartikil nohora re ne hota nwenna re, totpena nal to'a la riy doma rtimnia.” ");
INSERT INTO lex_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Noma Yesus Nakot la re: “Miy edonna mpiaik ma'ta la maka ha rhorat targa la Puka ralamni (la'a wat muaka ha rtot nohora la Ray Makamori-Kalewna maka Uplerlawna Nano'tar dena)?! De niwra: “Wat muaka tukna edonna rnair nana pa rhi'a roma-lewu, mere rhopliala, de Uplerlawna Nnairi oleka pa Nhi'a la watu liar pianulu. ");
INSERT INTO lex_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hadi ed mak Orgahi-Orha'a Nhi'a. Adoh ha samounu nee!”” ");
INSERT INTO lex_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yahudi o'tani-matni rat niohora la yawalliohora maka Yesus Nakota de, de Enakot nohor ira, pede rwahak talan pa rtorna Yesus. Mere ramta'at rer lia' rirahu pede rhoitio'or doin la Yesus pa rla'awa. ");
INSERT INTO lex_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nhorwua noma rhopna Parisi dom ror wutga riy mak kher lia Herodes dom totpa rla'a rna'aili Yesus. ");
INSERT INTO lex_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","15","Rmai pia ratiana riwra: “Tungkurga, amatga de riy plele'er id O'a. O' edonna Mhue'du nan etia riy ralma-riorni, yoma riy lalawna onde riy kuku'uni ho'mana O' edon Mpuadan nohora. Mere O' e Mpuatut die, Mukot nohor plollolli la Uplerlawna ralma-rior kalwiedwedni la'a rimormiori. La' hade pede Mukot teka la mai ami, de la O wniarormu de, la' it agamni deullu-tatarni de nakot am pia ampairia blastena la'a mak ktorna horta-hairi Romawi (Kaisar) onde yana?” Mere Yesus Nat niohora irtutga inon emeka riy mak samomuou mere plollolli de riy yatyat ira pede Nakot la re: “Hya'a nrei pia miwra mtiot A'u?! Mi'al tek la kupan dinar id pa A'umkek teka!” ");
INSERT INTO lex_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Dewade rala kupan pi'ra id pa rtutga la Yesus. Noma Yesus Natiana re: “La kupan de he'a herni-gaini me he' nanni mak kden la kupan dena?” Noma rwet la riwra: “Ray mak ktorna horta-hairi Romawi (Kaisar) o'tani inhat ee!” ");
INSERT INTO lex_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Noma Yesus Nakot la re: “Hade emkade, miala kupan maka ray herni-gaini etla de la'a ray, yoma hanni hade. Ne miala la Uplerlawna hya' maka Uplerlawna gahani wali.” La'pa ratlin nana lira wniahla re honona, de honona rwer rer wiawni. ");
INSERT INTO lex_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Noma Saduki riy doma rmai pia ratian nohora Yesus la'a emkameni la riy mak kmati hota rmori owa'ana, yoma Saduki re er mak edonna kpesiaya riy mak kmati hota rmori owa'ana. ");
INSERT INTO lex_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Riwra: “Tungkurga, Musa e nhorat targa mai ita, de emkadilla: La'pa muanke' ida nmati mere nakleh ma'ta a'na, de muanke'a mak kmat die hyalli nor owa'an yerni patyat de rmehlima, totpena rlernana hyalli mak kmati olek de duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Mere la' lera ida, de muanke'a riy wo'itu rwahyal riaralma. Noma yanulu nmehlima, mere edonna nlernan ma'ta a'na, ne nmat wia. ");
INSERT INTO lex_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Noma garni mak klernohor hyalli nora yerni rmehlima mere edonna nlernan wal mia'ta a'na noma nmati owa'ana. La'pa emkade walli la'a hyalli re korni re ror owa'an yerni de rmehlima mere id mana nakleh ma'ta a'na de rmat wia pa emkade mamain pa nodi liarni pa la ntutu mueman la gari hoho'a. La'awa hohoni noma pat de mana nmat wia, mere nakleh etia a'na ida. ");
INSERT INTO lex_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Hota la'pa la'awa lerni pa mak kmati honona rmori owa'ana, de hota he' hawni patke'a dena? Yoma mak kwahyali re wo'itu meman pa rora pat de rmehlima.” ");
INSERT INTO lex_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Noma Yesus Nwahla yatianni re Niwra: “Oi, miy wniarormi de nhala, yoma miplin niohora Puka lirni, me miplin wualia Uplerlawna plolli-mneheni. ");
INSERT INTO lex_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yoma riy mak kmati re hota rmori owa'ana, de hota edonna rmehlima, mere hota rmori-rdar lia Ilyamou-Watyatoha, emolmolan nekama Uplerlawna hopopanni (malaikat) la' Ilyamou-Watyatoha mak edon rmehlima. ");
INSERT INTO lex_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nah, la'a miy wniarormi de mak miwra riy hota edon rmori owa'an la matmiatni ralamni, de emeknekama miy edonna mpiaik nan ma'ta Orgahi-Orha'a lirni maka Musa nhorat taru, maka enatlin nana la' ler maka nlernan ai la'a pu'na-kiarti ralamni de. Orgahi-Orha'a lirni emkadi: “A' di de Abraham, Isak me Yakop Uplerlawna ma'ta A'u.” Nakot emkade kennama Abraham, Isak me Yakopa rmati olekwa. ");
INSERT INTO lex_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ha nnia'eratni de Uplerlawna mutnu-rahanu maka kmati rmori owa'ana me Uplerlawna de ir Uplerlawanni. Uplerlawan de, riy mak kmati Uplerlawanni atia'a hade. E de de, mak kmormiori Uplerlawanni E'a. Pede miy wniarormi de nhal toto'a.” ");
INSERT INTO lex_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Noma tungkurga agama ida maka kmai pia natlin nana Yesus nora Saduki mniotni rawahla lira, ne nat niohora Yesus Nala wniahlani naplollol meman la riy re, dewade natiana Yesus niwra: “Tungkurga, lira nhiopan meni ed maka khi' ononni la'a agama deullu-tatarni?” ");
INSERT INTO lex_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesus Nwahla: “Lira nhiopna, nhiedu tniehra ononni inhat de emkadi: “Mitlina, Israel mniotni miy, Orgahi-Orha'a Uplerlawna-Mempulwatnu id to'a. Enekneka E'a makla' it Matromni. ");
INSERT INTO lex_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Miala miy rurmi-laimi, ralma-riormi, ihrami-ralammi tetema pa mhima-mrie'a Uplerlawna Matromlawanmi de.” ");
INSERT INTO lex_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","La' wornu de emkadi, de niwra: “Miatu mtiulla-msiaynia mira'a-mipal wualia rimormiori wialmi pa emekwalima mimkek rer lia inon wamuehemi.” Lira nhiopna dom de edon rarehia lira nhiopna ri.” ");
INSERT INTO lex_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Noka makwatutu-kwaye'a agama de nakot la Yesus: “Plollolli hade Tungkuru, lirmu de plola, Uplerlawna de ida Nmeh'a to'a. Enekneka E'a makla' it Matromni. ");
INSERT INTO lex_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ne plola pa itala it rurni-laini, ralma-riorni, ihranu-ralamni tetema pa tsima-tre'a Uplerlawna it Matromlawanni de, me tatu ttulla-tsaynia, tara'a-tapal wualia it rimormior wialli pa emekwalima itamkek rer lia it inon wamueheni. Itsi'a hade de narehi-nalawan meman la it prehenni-maunu honona maka itiwra talla Uplerlawna.” ");
INSERT INTO lex_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesus Nwarora riy de lira wniahlani de nodia wniarora-wnialai samomuou, noma Nakot la: “O edon oliet la riy maka Uplerlawna Nodi plolli la emeka ir Rayni.” Ne riy id mana edonna nparan pia nhar lirni pa natiana Yesus. ");
INSERT INTO lex_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesus Nwatut mua't la Uplerlawna roma kreini. La wniatutnu ralamni de Yesus Niwra: “Hya'a nariei pia makwatutu-kwaye'a agama re riwra Ray Makamori-Kalewan maka Uplerlawna Nano'taru, de Daud duratni-waitni hade? ");
INSERT INTO lex_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Daud nmeh'a nek de, Uplerlawna Nhiwni Narialmua pa nakot nohora Uplerlawna lirni la Ray Makamori-Kalewan de niwra: “Orgahi-Orha'a Nakot la a Matromlawnu (Yesus) Niwra: “Muliwnu (Mumtatnu) la' A wa'lu malganna, la'pa A'utowra arwalmu pa ratniowar la O nayanmu.” ");
INSERT INTO lex_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","La'pa ray Daud nmeh'a neka nwet la Ray Makamori-Kalewna, niwra e Matromlawanni, de nihya'pa mikota ray Daud duratni E'a?” Riy mutlialawan re rahepur nohora yatlin la. ");
INSERT INTO lex_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","La'a wniatutnu ralamni de Yesus Niwra: “Erammi la'a tungkurga agama re! Nhi'inde rala' nohora raini plalahwani totpena riy ramkek de riy mak inponni ira me ir suksukni de riy ral ir la rekna-waiti la'a ya'olu-yala' geni. ");
INSERT INTO lex_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Rler la Yahudi kreini-iskolli ralamni de rtota gen miak kden la gaini me la'a he'i-hepru la'a ya'anlawna-yemunlawna, de rahak geni samomuou totpa riy ra'uli ira, nanpena ramtatna la' hande. ");
INSERT INTO lex_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rhi' aplinu-aplo' neka palpuallu, ne rwarui-rwate'la hyonni-hyanni honona. Mere rsumbain de plahwani, totpena riy rwarora riy samomuou ira. Hota riy mak emkare ed maka klernan niukum maka reh miemna la riy dom to'a.” ");
INSERT INTO lex_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Noma Yesus Namtatna pa Napal reria krei ktoparni, pa Namkek de riy rahu rkenia kupan la krei ktoparni. Namkek la mak ktar kupna-kai rala pripan narehi-nalawna. ");
INSERT INTO lex_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Noma a'na riy patyata ida nmai pia nken wialia sena wor lia'a ktopar de ralamni. ");
INSERT INTO lex_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Noma Npolga maka ha Nwatutu-nwaye'a re na'nama Nakot la re: “Mitlina, patyat di ed mak kenia liawanni la'a riy honona. ");
INSERT INTO lex_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Yoma rirahu mak keni olekwa re narehi-nalawna yoma re'eni-tniarnu harahu. Mere patyat di de nakleha-naplara mere mak ha nala re de, eneknek hare to'a pede nwatul nana pa nal momuoga.” ");
INSERT INTO lex_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","La'pa Yesus Nran lakni la Uplerlawna roma kreini noma maka ha Nwatutu-nwaye'a ida nakot la: “Tungkurga, Mumkek tek la Uplerlawna roma kreini de samomuounu, me watgau lawna maka ha rnairia pa rariria roma krei die!” ");
INSERT INTO lex_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Noka Yesus Nakot la Niwra: “Yowa, Uplerlawna roma kreini de inpona me naruri. Mere hya' maka mimkeka ri, hota rweyata-rwaniawu momuoga. Wat muaka kapnidara re de hota id mana edonna nalliapar la id wawannu.” ");
INSERT INTO lex_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nhor nioma Yesus Nla'awa wo'ora Saitun noma Namtatna pa Napal rer lia Uplerlawna roma kreini. Dewade Petrus, Yakowsi, Yohansi me Andarias rmai pia ror Yesus rwahaur rewre'wa pa riwra: ");
INSERT INTO lex_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Tuna, Mpue'er nohor tek hare, mai ami hota mowen die itamkek mak Omukota re? Me hota hya' ed maka tamkek ulga totpena nwagahniort it la hota lera-mela inhatta?” ");
INSERT INTO lex_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesus Nakot la re Niwra: “Mi'ererma! Yanpa riy rhi' aklierat miy la'a A maimia'yu de. ");
INSERT INTO lex_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Hota rirahu rmai die rnairia A na'nu pa riwra: “Makamori-Kalewna maka Uplerlawna Nano'taru A'g inhatti!” Hota rirahu rpesiaya ir pa rler la klieratni. ");
INSERT INTO lex_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","La'pa mitlina poka hidara yetni warna me mliernana kota-de'eta de rira riwra wunu-ara e nwewr olek la noha-rai, yan mimta'ata. Yoma hota hare honona de plollola pa itamkeka me itatlina, mere noha niatni edon ntutu-nte' ma'ta. ");
INSERT INTO lex_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Hota hairi nor hairi rawunu-rawenna, me noha-rai nora noha-rai rawo'ora. Ne hota noha nruru (upkarururu) lol meni-meni, me rehka-lara nwewar la noha-rai. Hare honona de tamkeka pleinia mere edon rler ma't la noha niatni. Ler maka mimkek la hare de eneknek to'ama mulaliaini, pa emekto'ama patke'a maka apannu namehra la mulaliaini, mere lerni edon ntu'tu ma'ta pa nayor a'nani. ");
INSERT INTO lex_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mi'ererma yoma hota riy mak edon kpesiay re rte'la miy pia rod miy lia mak khudi-kpara gaini. Hota rliwar miy lia' roma-lewu maka Yahudi re rhi' kreini-iskolli la. Ne hota ra'it miy lia'a riy o'ta-mat lalawna me la'a ray-ray gaini ralamni yoma la' A rerie'yu. Hota emkade totpena mimliernan talan pa mikot nohor Kot Kalwieda-Paitiota la ira. ");
INSERT INTO lex_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ne Kot Kalwieda-Paitiota de hota rakotkot lola pa nwewar la noheri woru-lyanti nayanni totpena noha-rai honona ratga nhor nianpena noha niata. ");
INSERT INTO lex_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ne la'pa rtoran nan miy pia rod miy lia watghudi lokarni, de yan memmemna ihrami rteplu yoma mpiarora hya' maka hota miy mikota? Mere la'pa ratian miy, mikot neka hya' ed maka Uplerlawna Nal miy la' ler de memna pa mikota. Yoma hya' mak mikota de edon nwatiawua miy wniaror wamuehemi, mere ha nwatiawu Uplerlawna Nhiw Lululli. ");
INSERT INTO lex_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Hota la' ler de riy rala inni-narni makpesiay A' pua rwenna. Emkade wali ama nek de nala a'nani makpesiay pa rwenna. Me upa-a'na nek de hota edon ratlin la inni-amni makpesiay pede rala inni-amni pa riy rwunu-rwenna. ");
INSERT INTO lex_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Riy la' meni-meni to'a hota rahankeran rer tiy miy, yoma miy mliernohor reri A'u. Mere la'pa he' ed maka ktorrer pitpitga pesiayni pa la ntutu-nte'ela honi, de hota nlernana mormiori-lewlewna plalahwa pa nodi liarni.” ");
INSERT INTO lex_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“La'pa mimkek nana hya' mak khi' akdeha-aktiahlia gen lululi la Uplerlawna roma kreini ralamni narieiniande Uplerlawna Nawenna de napriri-nakded la genia mak yan memmemna ha naprir lia, de miy miaka mpiaik nan hadi de mhioratreria! Miy mak kden la Yudea miwlar lia' wo'ora hananni. ");
INSERT INTO lex_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Me maka kateni anni la likti wawannu plet pa miwlari. Yana mhioratreria hya' mak kden la roma ralamni pa miodia. ");
INSERT INTO lex_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","La'pa miy mak kden la nhyi' ralma de yana miwali pia miala lawarmi-rayanmi la'a roma nayanni. ");
INSERT INTO lex_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Adoh! La' ler de de pat mak ka'uhu-ka'apnu, ne la'a pat mak nuh reria a'nani re rpolpuol inni-rwakwak amni. ");
INSERT INTO lex_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Msiumbaini totpena yanpa miwlar liola otna-anni ralamni. ");
INSERT INTO lex_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yoma lera-mela mak kodi kropna-krieutu, nniahora-nniala'a, yamuki-yama'ala mak emkade, de it edon tlernan etia la'a ler maka Uplerlawna Na'ohi-na'ara nohkerna la'pa ntutu-nte'ela' ler de. Ne la'pa itleretia de, it edon tlernan emkade owa'ana. ");
INSERT INTO lex_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","La'pa Orgahi-Orha'a Nala ler de pa naplahwa de hota riy id mana edonna ntuin tar lia noha wawannu yoma rmat miomuou. Mere onnila Orgahi-Orha'a sniayanni la E mutnu-rahanu maka Nwalir niana re to'a, maka nhi'nande ler de edonna nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","La' ler de la'pa riy riwra: “Mai pia tamkek ee! Ray Makamori-Kalewna maka Uplerlawna Nano'taru ed olek diwa”, onde dom e riwra: “Ee, mimkek teka! Ray Makamori-Kalewan de etla handelloo!” Yan mitlin la lirni re. ");
INSERT INTO lex_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Yoma hota la lera re de rirahu ralahar pa riwra ir de de Ray Makamori-Kalewna maka Uplerlawna Nano'taru onde rtot inonni emeka makwohorulu-ktatrulu pa rnairia hihi'a-yapyapi mak kamehi-kayona pa rtutga rurni-laini totpa ra ra'ohpa-ralahara rira. Uplerlawna mutnu-rahanu maka Enwalir niana nekane riwra rtot pa rler la klieratni. ");
INSERT INTO lex_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Hade pede mhioratreria! Dodo'ondi de A'ukot oleka hari tiy miy totpena hota la'pa hare honona rtutu-rte'ewa de miy edon mlier la klieratni.” ");
INSERT INTO lex_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mere la'pa ler maka riy rler la kropna-krieutu, nniahora-nniala'a de rlardoinla dewade: “lera nwamuela me wolla mana nakleh lair wa. ");
INSERT INTO lex_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Hota wtiona mana pala tuinia. Ne mak kodi plolli la darta-lyanti mana hota nawniatiri-nawnialiakra.” ");
INSERT INTO lex_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","La'awa ler de dewade rimormiori ramkek reria Rimormiori A'na Amuai owa'ana pa Adiella kakma wawannu, de Agodia A plo'lu-mneh'u, A preh'u-mka'yu mak kamehi-kayona la liplipa-kamka'mani. ");
INSERT INTO lex_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Hota Rimormiori A'na A die ghopan pa A hopopnu mak kden la Ilyamou-Watyatoha rawoka-rale'ga A mu'tu-rah'u maka Uplerlawna Nwalir nian oleka de, mak kdella noha uhunu ewatni-lyanti nayanni. ");
INSERT INTO lex_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mia'ala wniatutu-wniaye'a la kar on de. La'pa mtiamnia olli demade nmor wia, de miatg oleka lerwarnu nwakrian wia. ");
INSERT INTO lex_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hota emkade wal lia mimkeka hare honona mak A'ukot nohor olek diwa, de miatg oleka de lerni-melli nhi' pa nwakrian wia. ");
INSERT INTO lex_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Totpa miatga! Riy la'a tuwu di de edon rmat mia'ta, de hare honona mak ukot nohor oleka di hota rtutu-rte'ewa. A li'ru ri raplola. ");
INSERT INTO lex_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hota lyanti nora nohkeran di mana rmolu-rhelam wa mere A li'ru-tu'nu de ndella pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Riy id ho'mana hota naplin niohora la'a hya' lera-hya' mela Rimormioria A'na A die maimia'yu owa'ana. Uplerlawna hopopanni nekane raplinga, Uplerlawna A'nani A' die ho'mana uplinga. Eneknek to'ama, A'mu la Ilyamou-Watyatoha nampena ed mak katga.” ");
INSERT INTO lex_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Hade pede orahnioratmi! Yoma miy edonna miat niohora lera-mel maka hota A maimia'yu de ntutu-nte'ewa. ");
INSERT INTO lex_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Alia'awa la' Ilyamou-Watyatoha pa Amuai owa'an de, emolmolla riy id nhopal la olietleta. Nto'or la romni-lewnu ne naltarga la hopopanni-lili'irnu limni ralamni, rima-rima nora kniarni. Ne nano' taru mak katiaka nhiari totpa natiak samomuou e maimiaini. ");
INSERT INTO lex_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Emkade walia orahnioratmi pa mimtiaka yoma miy miplin niohora ler meni pa Matrommi Nati'ila-nawal wia, la'pa lera nmel wa, edonan de mel letgara, edonan de mela nhawulla walli, edonan de yawyawar melmel ma'ta. ");
INSERT INTO lex_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yanpa plinu-plin pa Amuai die, Aliernana mtieparla yanina. ");
INSERT INTO lex_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Hya' maka A'ukota tiy miy di, A'ukot targa la riy honona: Orahnioratmi!” ");
INSERT INTO lex_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tre' ma'ta lera woru de lerlalawna Paska (de la'a ler maka Yahudi re rhoratreria ir tuini-wedni la ler maka ralewan la'a kokohoga la'a Mesir), me lerlalawna Yahudi maka ra'ana rot miaka edonna rnairia tgo'a nhi' pa nrehgor wua. Noma imam-imam o'tani-matni re rora makwatutu-kwaye'a agama rwahak talan pa rtorna Yesus pa rwenna la'a wunwunamnu. ");
INSERT INTO lex_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mere riwra: “Yan memmemna rhi'a la'a lera maka ha riwra ramuki-rahepur la re, yoma hota lima-rora kokokna-rariarni.” ");
INSERT INTO lex_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","La'pa Yesus Nden la leta Betania, pa Na'an rerer lia'a Simon maka ululu de klernana nnienia ulityata de genni. Noma patke' ida nmai Yesus de, de nodia potla ida maka ha rhi' nana la watu-watu mak welli werta, de npenpuen lia wu'ru huwua mikmikri narwastu, mak welli werwerta wali. Noka patke' de nhi' wah'a potal de nurnu na'nama nwalia wu'ru della Yesus o'tani wawannu. ");
INSERT INTO lex_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Riy dom mak kden handi rawenna pa idma nakot la ida, riwra: “Hya' ed mak krei piede nhuri-nwaldioinia wu'ru mak kalweli wierwerat dena?! ");
INSERT INTO lex_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","La'pa na'olga wu'ru de ho'mana nlernan kupna nareh dioin kupna-kai (gaji) la anni ida gahani, pa welli de hota rala la riy mak kakleha-kaplara.” Dewade rpolliohor memna patke' de onnila hihi'ini de. ");
INSERT INTO lex_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mere Yesus Nakot la re: “Nihya'pa mikot emkade la patke' dina?! Miolin doin e' pa nhi' samomuou A lia dodo'ondi to'a, ");
INSERT INTO lex_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","yoma A'g edon gor miy pia nodi liarni. Mere riy makakleha-kaplara re nhi'inde e ror wutga miy totpa la' lera-lera nekpa mtiulan la' ira mliernohor to' neka miy sukmi. ");
INSERT INTO lex_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Patke' di nhi' nan hya' mak samomuou mai A'u nlernohora e rurni-laini. De enwalia wu'ru de pa na nwahi' A' pua rtamni A'u. ");
INSERT INTO lex_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mpiesiayo, la'pa rakot nohora Uplerlawna Kot Kalwiedni la noh di wawannu uhunu-ewatni, de irakot nohor walia patke' de hihi'ini-yapyapni totpa rira rhoratrereria e'a.” ");
INSERT INTO lex_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Noma la' riy id la'a riy termida wehrani woru maka Yesus ha Nwatutu-nwaye'a re de nwawa Yudas Iskariot nla imam re o'tani-matni, yoma nwaror nana nla na'olga Yesus la ira. ");
INSERT INTO lex_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Honona re ralamni re rahepru la'pa ratlin nan edade, ne rwanel tiar pua pena rala kupan la Yudas. Noma Yudas nla nwahakhak talla emkameni pa ntorna Yesus totpena nala la Yahudi o'tani-matni re. ");
INSERT INTO lex_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","La'a lera yanullu la lerlalawna maka Yahudi re ha ra'ana roti mak kakleha tgo'a, ler de wal pia nhi'inde rteti-rlaiya dum a'na maka ha riwra ra'an la'a Paska lerni de, noma maka Yesus ha Nwatutu-nwaye'a re rakot la Yesus riwra: “Tuna, hota ampahi' targa ya'anlawna-yemunlawna itodi itsoratreria it tuini-wedni la' Mesir de la' hanmeni?” ");
INSERT INTO lex_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Noma Yesus Nakot la maka Nwatutu-nwaye'a re riy woru Niwra: “Mlia' pa la'pa mlier la leta ralamni, de muanke'a ida na nodia ger kekna ida hota nwatrom nan miy. Enlol meni-meni mana mimrio'a mliernohor reria. ");
INSERT INTO lex_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ne mikot la orrom maka ha mtawniokur nan de miwra: “A tungkur mamni Natian o'a la'a gen mieni ed mak rwahi' targ olek pa Enora maka ha Nwatutu-nwaye'a re rewre'wa pa ra'an yamanan Paska?” ");
INSERT INTO lex_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","hota orrom de ntutga gen liawna mak kden la roma la' heyanna, de npenpuen niohora meini-kaderni me lola-wra'u pa nwahi'a-nwayod tiarg oleka. Pena mpiahi'a ya'ana mai it la' hande.” ");
INSERT INTO lex_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Noma maka Nwatutu-nwaye'a re rora rla'awa ne la'pa irte' tar lia letlawan de rlernana hya' maka Yesus ha Nakotkota re! Noma rrora rwahi'a-rwayod tiarga ya'ana-yemnia Paska. ");
INSERT INTO lex_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","La'pa nmel wa, noma Yesus Nora maka Nwatutu-nwaye'a termida wehrani woru re rmai rewre'wa. ");
INSERT INTO lex_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","La'pa ra'an wut lia mei wawannu dewade Yesus Nakot la re: “Mpiesiayo! Hota la' riy id tiy miy mak ka'an wut mai A'u hota eniwra na'olga A'u.” ");
INSERT INTO lex_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","La'pa ratlin nan hade de honona rmalui-rmaher doin la. Dewade rima-rima ratiana Yesus riwra: “Hota a'g edonno?” ");
INSERT INTO lex_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesus Niwra: “Riy maka hota na'olga A'u, de riy id tiy miy termida wehrani woru miy maka kor rewre'wa A' pua mto' wutga roti la'a lari niemun geni pa emeka tema raralamni nhi'inde rhi'a. ");
INSERT INTO lex_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Plola, hota Rimormiori A'na A' die hota Amuati, emeknekama e rhorat targa la Puka ralamni. Mere hota la'pa he' ed mak ka'olga Rimormior A'na de, adoh! Riy de hota nler meman la yatyatni-halalli yatlorni-yatra'ani. Samomuounu de edon ra'a'n nan walia e' la noh di wawannu.” ");
INSERT INTO lex_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","La'pa rara'an reri noma Yesus Na'ala roti, na'nama Na'uli-nawedia Uplerlawna. Nhor nioma Nhawi-nhawia rot die na'nama Nhakre'era la maka ha Nwatutu-nwaye'a re na'nama Niwra: “Mia'ala pa mi'ina. Hadi de A ino'nu inhatti.” ");
INSERT INTO lex_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nhor nia'nama Na'ala lari maka rkeni anggur turnu na'nama Na'uli-nawedia Uplerlawna na'nama Nala maka ha Nwatutu-nwaye'a re, ne honona remun wut lia lar die. ");
INSERT INTO lex_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Noma Nakot la re: “A ra'ru inhatti maka khi'a aplola Uplerlawna nnio' warwuarnu me rar maka ha rhuria yoma riy liawanni rerieini. ");
INSERT INTO lex_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mpiesiaya, hota A'g edonna gemnia anggur turnu owa'ana la'pa nte'ela' lerni Agemun anggur tur warwuarnu la'a A A'mu genni maka Ntorna-nrautu emeka Ray.” ");
INSERT INTO lex_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nhorwua noma rwahniara nhiara ya'uli-yawedi id la Uplerlawna. Nhor diewade rla'awa la'a wo'ora Saitun. ");
INSERT INTO lex_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Noma Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: “Hota miy hononmi miwlar dioinia A lia. Yoma Puka ralamni de e nakot nohora Uplerlawna lirni niwra: “Hota Awuenna makhuri-kwa'an de ne hota nhiuri-wnia'anni knunu-knera.” ");
INSERT INTO lex_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mere la'pa ramori-ralewna A'g owa'ana de hota A'g e ula' ul miy lia Galilea.” ");
INSERT INTO lex_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Noma Petrus nakot la Yesus: “Pen neka mutu korni hota rawlar dioinia O la Tuna, mere a'g edonna wuadur la O' onmu.” ");
INSERT INTO lex_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Noma Yesus Nakot la Niwra: “Mhuoratreria Petrusa, plollolli de la' ler di, la'a mel di memna hota hiwi lallu edonna nkukule'a re'eni wor mua'ta de hota omueh'a nekpa mrieher doin A lia' re'eni wotelu.” ");
INSERT INTO lex_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mere Petrus ntekal reria Niwra: “La'pa it rewre'wa tler la wniunu-wnienna ho'mana hota a'g edonna ga' pua rieher doinia O'a Am ee!” Ne maka ha Nwatutu-nwaye'a re korni mana lirni emekwalima Petrus lirni. ");
INSERT INTO lex_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nhor nioma Yesus Nora maka ha Nwatutu-nwaye'a re pa rla'awa geni ida mak kwawa Getsemani. La'pa rden la hande noma Enakot la ira: “Mpiei pia mimtatan la handi. Pena A lia siumbaini.” ");
INSERT INTO lex_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Noma Nakot la Petrus, Yakowsi nor Yohansi pa rmemeh'a ror rewre'wa E' pa rla'a. La' mel de Yesus ralamni Nmayo'a-nmataw dioin la. ");
INSERT INTO lex_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Noma Nakot la mutwualli re Niwra: “A ralmu emeka nmolu-nhelma pa emeknekama hota Amuat mie! Mdien nek la handi pa mimatmat pa msiumbaini.” ");
INSERT INTO lex_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Noma Yesus Nla oliet kuku'a la'a gen die na'nama Nler inonni pa Nwaltiora-nwaltieman la tani wawannu, na'nama Nwakwak pa la'pa Uplerlawna Nwayowa de hota E' edon Nler la kropna-krieutu maka Uplerlawna Nwaror nan-nwalai nian oleka de. ");
INSERT INTO lex_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Niwra: “Am ee! Hadom edon ta'eni tiy O'a. Awuak pa Muhal doinia kropna-krieutu mak hota Atiutulu-lielew niana ri. Mere yana Mliernohor maka A ralmu ha nwaka mere plolli nek tiy O'owa Ama!” ");
INSERT INTO lex_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nhor nioma Yesus Nawal pia Nla Ntomar la mutwualli re wotelu, mere Nla' de wotelu e ranin hala. Noma Yesus Nakot la Simon Petrus Niwra: “Simon omuninha'lu? Eneknek to'ama jama id ho' pa taken niana mumatar?!” ");
INSERT INTO lex_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Noma Nakot la ir honona Niwra: “Mimatmat pa msiumbaini totpena yana hegana amlawanni nreh nian miy pia mlier la do'a-hala ralamni. Yoma plolli pa miy miwra mliernohor A ralma-rio'ru mere ta'en niana mhi' nana.” ");
INSERT INTO lex_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Noma Yesus Nla Nsumbaini owa'ana pa lirni la Amni de emeka dodo'on de wali. ");
INSERT INTO lex_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Noma Yesus Nawali owa'an pa nla ntomar la mutwualli re wotelu mere e rtepartar yanina yoma matni werat rehia. La'pa ramata de raplin niohora rala lira hya'a la ralla rwahla Yesus lirni. ");
INSERT INTO lex_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nhor nioma Yesus Nla' owa'an pa Nmai re'eni wotelu, na'nama Nakot la mutwualli re Niwra: “Minin ma'ta miy?! Hadella wa! Nte'ela lerni wa pa Rimormiori A'na A' die ra'olga A lia riy maka khi' do'a-hala. ");
INSERT INTO lex_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mimata, mai pia tla' pa twatroma riy mak ka'olga A'u, nmai wia dee!” ");
INSERT INTO lex_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","La'pa Yesus Ntepartar mua'ta la yaltieri, dewade plinu-plinnianama Yudas maka nhi'inde kre'ela maka Yesus ha Nwatutu-nwaye'a la riy termida wehrani woru re, enmai wia, de nor wutga mutu ida, de rodia wehla plalahwa, me aukakaklu. Imam o'tani-matni re ror wutga makwatutu-kwaye'a agama me ina-ama leta Yahudi er mak khopan pa mutu rmai pia rtorna Yesus. ");
INSERT INTO lex_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Me Yudas mana Nakot targ oleka la mutnu re hota hya' ed maka ha nhi'a, niwra: “Mitlina, tla' de, de la'pa hameni ed maka akinnia de E' inhatta pa mtiorna la'pa miodia de mitiaktiak reria!” ");
INSERT INTO lex_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pa la'pa rte'ela gen die, dewade Yudas nod tiemna Yesus pa nakot la: “Tungkurga!” Dewade nkinnia Yesus. ");
INSERT INTO lex_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Dewade riy mutlialawna re rma rwarui Yesus pa rtorna. ");
INSERT INTO lex_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Noma Yesus mutwualli ida mak ktutrier lia hande nleh dioinia wehlani pa ndawar doinia riy ida tlinni. Riy de nhi' hopopna la imam-imam re o'ta lawanni. ");
INSERT INTO lex_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Noma Yesus Nakot la riy mutlialawna re Niwra: “Hoi hya' nrei pia miodia wehla ara me kakaklu re pa ma mtiorn A'u?! Yanpa la' miy wniarormi de A' di de riy yatyata-halala id A'u?! ");
INSERT INTO lex_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","La' lera-ler nek de A'g e gor miy pia it rewre'wa la'a Uplerlawna roma kreini, de A'g e wuatutu-wuaye' miy, mere miy edonna mtiorn A'u. Mere ha rhi' emkade totpa naplol nohor la Puka lirni.” ");
INSERT INTO lex_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nhor nioma maka Yesus ha Nwatutu-nwaye'a re honona rawlar dioin E' pa kni'ini-kniewarni. ");
INSERT INTO lex_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","La ler de tuwgari ida e nlernohor reri Yesus, de nnair nan to'a kok lenan ananni id pa nahewu inonni. Riy maka rodi wehla-kakaklu re rtota pa rtoran nana, ");
INSERT INTO lex_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mere naul doinia kok della pa natliawih pia nawlar wia. ");
INSERT INTO lex_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Noma rodia Yesus pa rla'a la imam-imam o'ta lawanni gaini. Ne imam-imam o'tani-matni ror wut nieka ina-ama Yahudi me makwatutu-kwaye'a agama re rawok momuou wal lia hande. ");
INSERT INTO lex_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus de nlernohor reria Yesus, mere edon nwakriania. Noma Petrus nwakdie'da wal pia nodi liarni la riwta ralamni la'a imam lawna romni, pa nre' pa namtatan wutga la' riy mak katiak la' hande pa nor wali ir pa namriri ai. ");
INSERT INTO lex_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Imama re o'tani-matni la'pa mak ktorna agama watghudni honona, rahak riy mak kaprir niohora ira (saksi) totpa ralahar pa rwaghal Yesus totpena rlernan talan pa rukum penna E'a mere o'ta-mata re edonna rlernana wniatikilgeni totpena rwaghala Yesus. ");
INSERT INTO lex_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Riy harahu rmai pia rakot nohora hya' ed maka edon kaplola, mere lirni-tunnu re idma edon nora ida ramneneha. ");
INSERT INTO lex_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Noma riy dom rtutrier pia ralahar pa rwaghal Yesus, riwra: ");
INSERT INTO lex_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Amatlin nana oleka riy di Nakota Niwra hota E' ed maka Nweye'era Uplerlawna roma kreini maka rimormiori limni enni die, me hota E Nariri krei id owa'ana la'a lera wotellu, maka rimormiori limni enni atia' hade.” ");
INSERT INTO lex_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","La' handi mana lirni re edon ramneha. ");
INSERT INTO lex_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Noma imam lawna naprir lia woka-le'u die letgarni pa nakot la Yesus Niwra: “Hoi, hota O edonna Mukot hadom pa Mpuahla nana lira mak kwatiawua etnu-liolli rena? Lira re raplola me edonna?” ");
INSERT INTO lex_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mere Yesus Nherer tio'owa. Noma imam lawna nhari owa'an lirni pa niwra: “O' di de Ray Makamori-Kalewna O'a maka Uplerlawna Nano'taru, de Uplerlawna maka ha ra'uli-rawedia A'nani?” ");
INSERT INTO lex_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Noma Yesus Nakot la: “A'g e inhatti. Ne hota la' ler id de hota mimkek memna, Rimormiori A'na A'umtatan la Uplerlawna-Mempulwatnu mak kodi plolli walli malganna ne hota Amuai die Agodia kakma la'a lyanti tutulu.” ");
INSERT INTO lex_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Dewade imam lawan de nawenan pa nlihira-nnaiya rain plalah wamueheni yoma nwarora de Yesus de rimormior tio' E'a, na'nama niwra: “Yan itwei pia riy rakot nohora E halli. ");
INSERT INTO lex_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Miy hononmi e mitlin walia E lirni de Enapolu-naliella Uplerlawna yoma Enakot Niwra Uplerlawna A'nani E'a toh?! Pa emkameni la miy ralma-riormi? Mietlia wa.” Noma honona rla' lir id pa retlia de niukamnu mak klol talanni de totpa rwunu-rwenna. ");
INSERT INTO lex_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Dewade dom de krurui-kpirpir la Yesus ne rtutwu apitga Yesus matni pa rdupla, na'nama rakot la riwra: “Makwohorulu-ktatrulu O'a, pa Mpuet tek la he' ed maka kdupla O'a dena!” Noma mak katiaka re mana rdupla E'a. ");
INSERT INTO lex_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ne Petrus namtatan ma'ta la yawa, la'a riwta ralamni la'a imam lawna romni (totpa nat niohora hota rhi'a hya'a la Yesus). Dewade pat mak khoi-ktani ida nmai wia. ");
INSERT INTO lex_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","La'pa namkek nana Petrus namriri ai noma namkek tertehra na'nama nakot la niwra: “Nhi'inde omuor wutga riy mak kor Yesus riy Nasaret de mila' wutu.” ");
INSERT INTO lex_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mere Petrus nrehera, niwra: “Eee! A' niek de uplinu-uplo' nohora riy de me a'uplin niohora lirmu-tunmu de lie'erni.” Noma Petrus nwatitin la hande pa nla'awa riwta nhiarni onni dewade hiwi mana nkukule'ewa. ");
INSERT INTO lex_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Noma pat makhoi-ktani de nlol hande pa namkek owa'an Petrus dewade nakot owa'an la riy mak kden hande niwra: “Emeknekama dodo'ona riy di nor walia Yesus talla.” ");
INSERT INTO lex_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Noma Petrus nreher owa'ana. Edon nalo'on wali ne riy mak kden hande rakot la Petrus riwra: “O inhatti manoo! Yana mriehera, yoma riy Galilea id o'a.” ");
INSERT INTO lex_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Noma Petrus ntan limni la heyanan pa nlokra-nhautu niwra: “Uplerlawna Namkek reria me a'g edonna gat niohora riy maka omukotkot nohora de. Uplerlawna nhiakar lokarni mai a'u la'pa agat niohora riy de ha lolola.” ");
INSERT INTO lex_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Plinu-plinnianamde hiwi lallu nkukule' nan re'eni wornu wa na'nam de Petrus nhioratni nko'i nana Yesus lirni de Niwra: “Hota la hiwi lallu edon nkukule' ma'ta re'eni wornu de hota omrieher nan olek A lia re'eni wotel wua.” Noma Petrus nahedge'du la kniakru. ");
INSERT INTO lex_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Repreparrer mia'ta de, imam-imam o'tani-matni ror wutga Yahudi in letni-am letni me makwatutu-kwaye'a agama la'pa mak ktorna watghudi agama Yahudi honona re rwahu'ru lira totpena retlia Yesus wnienanni. Noma rwutga Yesus limni na'nama rodia la Pilatus. ");
INSERT INTO lex_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Noma Pilatus natiana Yesus Niwra: “Plola O' di de ray Yahudi id O'a?” Noma Yesus Nwalolla Niwra: “Emek lir mak omukot de!” ");
INSERT INTO lex_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Imama re o'tani-matni rwaghal E' la'a lira-tunu harahu. ");
INSERT INTO lex_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatus natian owa'ana niwra: “O' Edonna Muala lira wniahlani?! Mutlin la irwaghal O'ola lira-tunu harahu.” ");
INSERT INTO lex_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mere Yesus lir ta'a-waw ta' to'owa, pede Gubernur Pilatus de nwer rer wiawni. ");
INSERT INTO lex_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","La'a Yahudi lerlalawanni maka ha rhoratreria tuini-wedni, Pilatus nhi'inde nolin doinia Yahudi id la'a roma nhio'la totpena nhi' ahepru Yahudi ralamni. Enolin doinia riy maka Yahudi mutlialawna re ha rwalir niana. ");
INSERT INTO lex_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ne ler de riy ida nwawa Barabas, e rho'la wutga la riy mak kmalawna horta-hairi Romawi doma. Barabas nor talanwalli re rmalawna ray ne rwunu-rwenan riy la kokokna-rariarni id ralamni. ");
INSERT INTO lex_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Noma riy rahu rmai pia rwak totpena Pilatus nolin doinia riy ida emekto'a nhi'inde de e nhi' taru-nyap tiarga la lerlalawan de. ");
INSERT INTO lex_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatus natiana re: “Hota miy mpiayow de agolin doinia Ray Yahudi di tiy miy?” ");
INSERT INTO lex_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatus natian emkare la rirahu re yoma Pilatus e nat niohora imam-imam o'tani-matni re rala Yesus la e'a, yoma honona re ralamni ramehra la Yesus. ");
INSERT INTO lex_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mere imama re o'tani-matni rtekal rer tio' la totpena rirahu rwak la Pilatus pa nolin doinia Barabas nek wa. ");
INSERT INTO lex_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Noma Pilatus natiana niwra: “Hade emkade, aghi'a hya'a la Yesus maka mpieta la Yahudi Rayni dina?” ");
INSERT INTO lex_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Noma rhaunu pa riwra: “Mpuairia la auwlakra hananni.” ");
INSERT INTO lex_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Noka Pilatus nakot la re: “Mere halli hya'a pede?” Noma honona re yeher to' pa rhaunu-rhaunu riwra: “Mpuairia la auwlakra hananni!” ");
INSERT INTO lex_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Noma Pilatus niwra nhi' amikri riy rahu re ralamni pede nolin doinia Barabas la pa nala la ira, ne nhopan pa riy rliwra Yesus. Na'nama nala pa rla rwairia la auwlakra hananni. ");
INSERT INTO lex_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","La' noma makodi keki-rautu rodia Yesus pa rler la gubernur Pilatus romni na'nama rpolg awoka makodi keki-rautu korni re lidna-lidan pa rmai wia. ");
INSERT INTO lex_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Rohoga emeka ray-ray naniayarni plalahwa mak ungu la Yesus. Noma rhi'a wutu-lai ida de rnairia pu'na-kiarit ruri pa rkow nana la Yesus o'tani. ");
INSERT INTO lex_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nhor nioka rhaunu riwra: “Mmuormiori plalahwa Ray Yahu'du ne!” ");
INSERT INTO lex_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ra'ala lie'ena pa rliwar reri o'tani me rakrui-rakpira, na'nama rwaltiora-rwaltieman la gaini ralamni pa rahe'i-ramalia Yesus. ");
INSERT INTO lex_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","La'pa rahe'i-ramalia na'nama ral doinia naniairia ungu della pa rohog owa'ana naniair wamueheni. Nhor nioma rodgiota pa rla rwairia la auwlakra. La'pa rodgiota pa rla rwairia la auwlakra. ");
INSERT INTO lex_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","de rwatrom nana riy Kirene ida, nwawa Simona, de Aleksander nora Rufus amni. La' ler de Simon etla' talan letgara pa niwa nla'awa la' letlawna Yerusalem. Noma ha rhopan pa riy de nakwara Yesus auwlakarni. ");
INSERT INTO lex_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Rodia Yesus pa rla'awa gen miaka ha rweta la Golgota, nnia'eratni de: Riy Ruri-Kliaklu Genni. ");
INSERT INTO lex_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Noma rala atiaw maka ha rweta la mur, mak rawniah'a la anggur turnu pa rala Yesus Nemnia totpena mehrani nmolu. Mere Nahmena Nemnia. ");
INSERT INTO lex_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nhor nia'nama rwairia Yesus la auwlakra hananni. Na'nama rdurmu-rhakra Yesus naniayarni de rnairia patui (undi) totpena ratetra rima-rima nhiakarni. ");
INSERT INTO lex_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Lera nha'at la jama wosiewni dewade, rwairia wa. ");
INSERT INTO lex_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Rhorat targa la auganna ida, de rakot nohora hya' maka Yahudi o'tani-matni re rto'on reri E halli pa rhorat de riwra: “Yahudi Rayni inhatti.” ");
INSERT INTO lex_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","La' hande wali pia e rken wialia riy wor lia auwlakra yoma rrora rpera-rdaitia deulu-tatra hairi Roma. Rkenia id la Yesus walli malganna ne id la'a Yesus walli malwiru, ne Yesus Nden la letgara. ");
INSERT INTO lex_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Totpa naplola la Puka lirni mak kiwra: “Ratniekame E' de riy mak kpera-kdaiti deulu-tatra.” ");
INSERT INTO lex_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mak klola hande rdik o'tani la me rwohora-rtatra me rahe'i-ramal lia Yesus. Rakot la Yesus riwra: “Oi! O' ed mak kiwra kwaye'er doinia Uplerlawna roma kreini nampena Omuriria owa'ana la' lera wotellu. ");
INSERT INTO lex_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Muerun la auwlakar de hananni, ne Mulewna inonmu.” ");
INSERT INTO lex_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Emkade walia imama re o'tani-matni rora makwatutu-kwaye'a agama rapolu-raliella Yesus pa idma nakot la ida riwra: “E' de Namori-nalewna riy meheni, mere inon wamueheni de takeni Nalewan nana. ");
INSERT INTO lex_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tamkek teka hota riy di maka ha rhoiya la riy makamori-kalewna maka Uplerlawna Nano'taru, Israel Rayni de hota Nerun la auwlakar de hananni totpena tpesiaya.” Riy maroro'a re la auwlakra re ho'mana rapolu-ralielan walia Yesus la auwlakra hananni. ");
INSERT INTO lex_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","La lera nwawuau ro'onni (jam termida wehrani woru) mere la'a noh de tetema nekpa mel'uta-maliena nodia pa lera nher miemna (jam wotellu). ");
INSERT INTO lex_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","La'pa jama wotelu, dewade Yesus Nhaun pa Niwra: “Eloi, eloi lama sabaktani?” Ha nnia'eratni de niwra: “Uplerlawnu ne, Uplerlawnu ne nihya'pa Omuolin limmu-mpue'er rormu mai A'u?” ");
INSERT INTO lex_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Riy wo'ir mak erla hande e ratlin nana Yesus lirni, na'nama riwra: “Idee! Ha e Npolga Elia.” ");
INSERT INTO lex_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Noma riy ida nawlar pia nla na'ala kuliai, na'nama nto'a la anggur turnu mak milmilu na'nama nkenia la au tutnu pa ntania la Yesus nurnu totpena Nemnia. Niwra: “Twei pleini. Yanpa Elia nma nalernia E'a.” ");
INSERT INTO lex_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nhor nioma Yesus Nhaunu owa'an dewade Nmati wia. ");
INSERT INTO lex_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Noma plinu-plinnianamde kok lawna maka ra rahew tiarga liolgeni la'a gen mak kmou-kwitna la Uplerlawna roma kreini ralamni totpa riy edon rler la rialam de, ema rlihirwah'a la' woru la' heyanna pa ntut mueman la yawa. ");
INSERT INTO lex_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","La' ler de mak khi' o'tani la lidna makodi keki-rautu rahu ida, e naprir pia napal reri Yesus. La'pa namkek nana Yesus matmiatni emkade dewade niwra: “Hadi plola! E' de de, Uplerlawna A'nani E'a.” ");
INSERT INTO lex_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","La' hande de patke' dom e ror wal pia rden nek la oliet pa e ramkek reria. La' ir mutnu de, de Maria Magdalena, me Maria, Yakowsi mak tuwgar de me Yoses inni, nor wali Salome e rtutrieri. ");
INSERT INTO lex_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ir de ed maka klernohor reria Yesus la Galilea totpena ramkek la ya'anni-yemannu, rpo'a-rpahi'a Yesus hyonni-hyanni. Me patke' harahu er wal lia hande mak kor rewre'wa Yesus pa rmai lia Yerusalem. ");
INSERT INTO lex_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","La ler de ntuin tar la' ler maka rwahi' targa hare honona pa rwei-rnara Sabat lerni (ler maka Yahudi re edon rkar lia) yoma repar de Sabat de ntutu-nte'ewa. Pa la'pa lera ntuini de ");
INSERT INTO lex_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","noma riy id la hande de nanni Yusup nhi' parani inonni pa nla nwak la Pilatus totpena na'ala Yesus inonni mak kmati olek de. Yusup de riy mak kwatiawua leta Arimatea, maka nhi'inde nre' wal pia nla'a riy mak ketlia lira-tunu la agama hanni, ne riy maka ha rwetwet la nanni. Nhi'inde ralamni nod rer lia wniei la Uplerlawna hota Ntorna-nrautu emeka Ray. ");
INSERT INTO lex_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus nwer rer wiawni la'pa natlin nana Yesus Nmati olekwa. Noma npolga makodi keki-rautu o'tani de pa natiana de plollolli de Yesus Nmati olekwa me edonna? ");
INSERT INTO lex_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","La'pa natlin nana makodi keki-rautu o'tani lirni niwra Yesus Nmati olek wa, dewade nwayow pa nala mat diella Yusup. ");
INSERT INTO lex_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusup la nawelia kok lawan wawahra mak kamnurnuhru nhor nia'nama nla nalernia Yesus mak kmati olek della la'a auwlakra hananni. Na'nama nala kok lawan wawahra mak kamnurnuhru na ntomna. Nhor nia'nama nla nle'er targa la'a liena maka ha rawte'ta nande. Nhor nia'nama nwaklol tiarga wat liawna id pa na nherit targa lien de nhiarni. ");
INSERT INTO lex_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalena me Maria, Yoses inni, ramkek nohora nle'er targa Yesus la' hoi-kietra meni ralamni. ");
INSERT INTO lex_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","La'pa Sabat lerni nlardoinla dewade Maria Magdalena nor wutga Maria, Yakowsi inni, me Salome pa rla rawelia wu'ru mikmikri lamliamni pa rodia la lien maka ha rkenia Yesus inonni totpa ralla rawu'ru Yesus inonni. ");
INSERT INTO lex_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","La'pa yawyawar ma'ta la krei lerni, de lera matni ri'ini npah'a nana dewade a'na patke'a re rla'a Yesus hoini. La'a talla ralamni de ");
INSERT INTO lex_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","idma nakot la ida: “Hota he' ed maka kwaklol dioini wat liawna maka ralla rherit targa hoi de nhiarni mai ita?” ");
INSERT INTO lex_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mere la' pa rwakriania hoi die onni dewade ramkek de wat liawan maka ha ra rherit targa hoi die nhiarni ema rwaklol dioin oleka wa. ");
INSERT INTO lex_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Noka rler la hoi de ralamni, ramkeka tuwgari ida nnairi rain wawahra plalahwa pa e namtatna la walli malganna, nhi'nande rheduma. ");
INSERT INTO lex_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mere tuwgar die nakot la patke'a re niwra: “Yan mimta'ata. Miy mia mihaka Yesus makden Nasaret, maka ha rwairia me inonni nmat lia auwlakra hananni. Ha Nmori olekwa pa edonna Nden olek la handi wa. In miy re, mimkek tek la gen miaka ha retar targa Yesus inonni de. ");
INSERT INTO lex_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pena mlia' pa mikot nohora la Petrus me e mutwualli korni maka nhi'inde Yesus Nwatutu-nwaye'a re, miwra: “Hota Yesus Nala' ul miy lia Galilea totpena miora mpiatrom la hande, nlernohora hya' maka Enakot targa tiy miy.”” ");
INSERT INTO lex_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Noma patke'a re rlergot wa pa rawlar pia rto'or doinia hoi diella, de ramta'at wenna pa honona rdiwra-rda'ala me ralamni worwuorga. Edon rakot eti hya'a-hya'a la he'-he'a, yoma ramta'at wenna la hya'a maka ramkek nana. ");
INSERT INTO lex_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","La'pa Yesus Nmori owa'an olekwa la' pa yawyawar ma'ta la krei lerni de, noma Nala' ul pua Ntutga inonni la Maria Magdalena, maka la' ler ululu de Yesus Natargota hegana wo'it lia ralamni. ");
INSERT INTO lex_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Noka patke' de nla nwahaur nohora la maka klelernohor reri Yesus. Hare de ertepartarlia kniakru me yaluli-yahona. ");
INSERT INTO lex_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mere la'pa ratlin nana de, Yesus Nmori owa'ana ne patke' de namkek nan oleka de, edonna rpesiaya. ");
INSERT INTO lex_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Noma Yesus Ntutga inonni la maklernohor reri E'a riy woru la' ler maka ralala' rer lia leta-leta to'orni re, Nherun doinia gaini la. ");
INSERT INTO lex_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Noma rawal pia rwahaur nohora la mutwualli re korni, mere mutwualli re mana edonna rpesiaya. ");
INSERT INTO lex_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nhor nioka Entutga gaini la maka Nwatutu-nwaye'a termida wehrani ida re de, e rara'an reri, noka Npolliohora yoma rakleha pesiay me ralamni re tehrani pede rahmena rpesiaya riy maka kamkek ulga E'a la'pa Nmori owa'ana la matmiatni ralamni, de lirni. ");
INSERT INTO lex_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Noma Yesus Nakot la re: “Mlia'awa la nohkerkeran di uhunu-ewatni-ewatni-lahwani pa mikot nohora Uplerlawna Kot Kalwiedni-Paitiotni dilla rimormiori honona. ");
INSERT INTO lex_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","He' ed maka kpesiaya pa rharania de, hota nler la mormiori-dardiari plalahwa, mere he' maka edonna kpesiaya de nlernana matmiati plalahwa la'a ai mormiori ralamni. ");
INSERT INTO lex_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Riy maka kpesiaya de hota rhi'a hihi'a-yapyapi mak kamehi-kayona mak ktutga Uplerlawna rurni-laini, de hota rala A na'nu rahokra hegana-kawnu, ne raltier die rnairia yawala maka riy raplinga. ");
INSERT INTO lex_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hota rte'la la niy mere edon nhi' hadoma, ne la'pa ra'an nana-remun nana ya'an molmuolu-yemun matmiati ho'mana edon nhi' hadoma mere naprir rer mia'ta. Hota rtan limni la mak kamehra-kamau wawannu de rkalwied wa.” ");
INSERT INTO lex_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","La'pa Itmatromni Yesus Naltier lia pa nhorwua dewade, ema rran nana pa Nokru Ilyamou-Watyatoha, la'pa Namtatan la Uplerlawna walli malganna. ");
INSERT INTO lex_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nhor nia'nama maka Yesus ha Nwatutu-nwaye'a re rla rwe'er nohora Orgahi lirni la nohkerkeran di uhunu-ewatni-ewatni-lahwani, ne Orgahi mana Ntulan wutu-Nkar wiut lia ira, ne Nala ruri-lai lia ira pa rhi'a hihi'a-yapyapi mak kamehi-kayona totpena Nhi' aplola E lirni. ");
INSERT INTO lex_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Topilsu, maka agatu ghu'ru-ghelma. Riy rahu rhorat targ oleka Yesus hihi'ini-yapyapni maka Enhi' nan la a letgar mamni. Rhorat de rlernohora hya' maka ami makpesiay die matlin nan olekwa la'a riy mak kamkek memna Yesus hihi'ini la mulaliaini me rakot nohora E lirni-tunnu. ");
INSERT INTO lex_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pa a' muana awuarora de hota samoga pa aghi' wali horta pa ga ukot nohor kalwiedweda hare honona la' Tuna, yoma a'utiana prorowta memna hare honona ndella onni pa la ntut lia hohoni, pede dodo'ondi de agat niohor memna. ");
INSERT INTO lex_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Pede agiwa ghi'a horat di, totpena la'a hya' maka ha rwatutu-rwaye' olek la Tuna, la'a Yesus hihi'ini-yapyapni, de dodo'ondi de Tuna nat niohor memna ha raplol momuou. ");
INSERT INTO lex_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tuna, la' lerni la Herodes Nhi' ray lia Yudea, de makpolu-makwak la Uplerlawna la rimormiori rerieini (de imam) ida nwawa Sakaria. Enkar wut lia la imam-imam re maka ha rweta la Abia tatarwalli (golongan). Patke'eni nanni Elisabeta ne Elisabet mana Harun (de imam mak kala' ul muemna de) duratni-waitni id e'a. ");
INSERT INTO lex_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Irrora mormiorni-dardiarni de naplol la Uplerlawna yamkekni, yoma irrora ratu rhu'ru-rhelam (ratlina-rataili) la Orgahi-Orha'a lirni-tunnu me deullu-tatarni. ");
INSERT INTO lex_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mere irrora rakleh a'na yoma Elisabeta nkerna, ne rrora rhamto'a-rhape'ewa. ");
INSERT INTO lex_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","La' lera ida ne, maka ha rweta la Abia tatarwalli (golongan) rlernana nhiakra yatiaka, noma Sakaria nala'a kniarni de emeknekama makpolu-makwaka la Uplerlawna gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","La' ler de imam-imam re rhedga patui (cabut undi) totpa rwalir niana he' ed mak hota ktutnia ayalin la Orgahi-Orha'a roma kreini ralamni pa emeknekama nhi'inde ha rhi'a de. Noma Sakaria nlernana. ");
INSERT INTO lex_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pa la' pa ntepartarlia ntutnia ayalin la rialam de, ne riy rahu e rsumbain la pliorni. ");
INSERT INTO lex_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Noka plinu-plinnianama Orgahi-Orha'a hopopanni ntutu gaini la Sakaria. Hopopan de ntutrier lia katri'ana maka ha rtutnia ayalin la de, walli malganna. ");
INSERT INTO lex_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","La'pa Sakaria namkek nana hopopan de, dewade nhedum pa namta'at wenna. ");
INSERT INTO lex_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mere hopopan de nakot la niwra: “Hei! Sakaria yan mumta'ata! Uplerlawna e Natlin oleka o sniumbainmu. Hota o patke'emu Elisabeta nmor nian a'na muanke'a ida, ne mual nanni de Yohansi. ");
INSERT INTO lex_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hota omumuki-muhepur toto' meman nohora de, ne la'pa rmoria de riy rahu hota rahepur nohor walia. ");
INSERT INTO lex_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yoma hota la'a Orgahi-Orha'a yamkekni, de a'namu de nla'a riy orkotkota-ornanan ida. Hota yan memmemna nemnia anggur turnu onde arka. Ne hota Uplerlawna Nhiw Lululli Nodi plolli la e'a, la' meman la' ler maka ha rmor nian memna e'a. ");
INSERT INTO lex_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ne hota Israel mutnu liawanni ratlina-ratailla e lirni-tunnu pa rapali owa'an la Uplerlawna, ira Matromlawanni dee! ");
INSERT INTO lex_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Hota nlernohora makwohorulu-ktatrulu (nabi) Elia yehwani la' ler delloo! Yoma Uplerlawna Nhiw Lululli Naruri-nalai nian e'a. Pa hota enala' ul pua nwalipra-nwahyaria Orgahi-Orha'a talanni totpena Israel rimormiorni re rwahi' targa la Orgahi-Orha'a maimiaini. De e' ed maka khi'a pa riy maka kor inni-amni onde upni-a'nani rahuri-rawo'ora hota rkalwied owa'ana. Ne riy mak edonna katlina-katailla Orgahi-Orha'a de Enwatut pua ratu ratlina-ratail owa'an la Orgahi-Orha'a, pa emeknekama riy mak kaplol la Uplerlawna yamkekni.” ");
INSERT INTO lex_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaria nakot la hopopan de niwra: “Hota emkameni la agat memna hya' mak omukot de naplola? Yoma aghamtoto'owa ne pa'tu mana nhape'ewa.” ");
INSERT INTO lex_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Noma Uplerlawna hopopanni de nwahla lirni niwra: “A' di de Gabriel a'u. A'g ed maka khi' hopopan la Uplerlawna. A'g ed mak khima-kre' (melayani) memn E'a la' gen tutullu-lolo'oni. Me E' ed maka khopn a' pua agodia kot kalwied dilla mai o'a. ");
INSERT INTO lex_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mhuoratreria! Hota ompual lia mak khakamu yoma o' edonna mpuesiay a li'ru. La'pa nte'ela lerni maka Uplerlawna Nakot targa pa a li'ru ri ntutu-nte'ewa, nanpena multieri owa'ana.” ");
INSERT INTO lex_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","La'pa palo'on ho'a mana riy rtepartarlia wniei Sakaria. Honona re rwarora riwra: “Sakaria mahnek rehia la'a Uplerlawna roma kreini ralamni. Nihya'pa emkadeno?” ");
INSERT INTO lex_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ne la'pa nlergot wa de ta'en niana nakot hadomdom la' mak kwei re. Mere nal to' limni na nawal hatilu. Yoma nwali olek la mak khakamu. La'pa ramkek emkade noma ratg oleka Sakaria, de matni ri'ini npah'a nan hadom la'a krei ralamni. ");
INSERT INTO lex_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","La'pa yatiakni nhorwua la'a Uplerlawna roma kreini ralamni noma Sakaria nawali owa'an la e romni nayanni. ");
INSERT INTO lex_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","La'pa edon nalo'on wali ne hawni Elisabet na'apnu, dewade edonna nlergot nana wolla wolim la roma nayanni. ");
INSERT INTO lex_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Noma niwra: “Hota la'awa hohoni di, de Orgahi-Orha'a Ntutga ralam kalwiedni pa Ntulan la mai a'u yoma Nhi' a pua a'u'a'na pede a'g edonna muola-mua'a owa'an la'a rira gaini ralamni.” ");
INSERT INTO lex_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","La'pa lerni la Elisabeta na'apun wa, ne la'pa wolanni wonem pa noma Uplerlawna Nhopan pa hopopanni Gabriel nla'a Nasaret, let mak kden la Galilea nohoni. ");
INSERT INTO lex_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nhopan doinia Gabriel nmaiya hararara mak kwawa Maria mak kor Yusup, ray Daud duratni-waitni, de ranyah'a tar oleka. Ra'an lira-remun waw pa hota rmehlima, mere Maria edon nor muanke' id mana rawok ma'ta la yaninni. ");
INSERT INTO lex_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hopopan de nma nakot la Maria niwra: “Maria ee! Kalwiedo! Orgahi-Orha'a Nara'a-napa'lu ne hota E Nor o' talla!” ");
INSERT INTO lex_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","La'pa natlin nana hopopan de lirni dewade Maria ralamni worwuorga pa nwaror la'a-mai lia ihranu ralamni niwra: “Ha wniak kalwiedni de nnia'eratni emkamenio?” ");
INSERT INTO lex_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Noma hopopan de nakot la niwra: “Yan mumta'ata Maria, yoma Uplerlawna Nara'a-napa'lu! ");
INSERT INTO lex_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hota omu'uhu-mu'apun nana a'na muanke'a ida, ne muala pa nanni Yesus. ");
INSERT INTO lex_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Hota nwal lia riy lalawna ida, ne hota rweta la Uplerlawna mak kden la tutullu-lolo'oni A'nani. Orgahi-Orha'a Uplerlawna-Mempulwatnu hota Nhi' E' pa Nla' Ray, pa emekwalima E upni-tgarni ray Daud. ");
INSERT INTO lex_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Me hota plol toto'a pa Enodi plolli la'a Israel duratni-waitni pa nodia liarni.” ");
INSERT INTO lex_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Noma Maria nakot la Uplerlawna hopopanni de niwra: “Mere, a'g edon gor ma'ta muanke'a ida manin wutu pa hota emkameni pede a'u'a'na?” ");
INSERT INTO lex_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Noma hopopan de nakot la niwra: “Hota Uplerlawna Nhiw Lululli Nmai tiemn o' de. Ne Uplerlawna mak kden la tutullu-lolo'oni plolli-mneheni hota nwewarna'nu. La' hade pede hota papay miaka mu'uhu-mu'apun de rweta la Uplerlawna A'nani. Ne hota Enakleha do'a-hala. ");
INSERT INTO lex_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Mhoratreria! Hota Elisabet, elmu mak nhape' olek de, na'apn olek pa wolanni wonem pa. E' ed maka ha riwra nkeran pa nakleh a'na mere hota nayori a'na. ");
INSERT INTO lex_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yoma hadoma edonna ta'enia la Uplerlawna.” ");
INSERT INTO lex_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Noma Maria nakot la niwra: “A' di de Orgahi-Orha'a hopopanni a' pua nden nek la Uplerlawna lirni mak omukota re.” Noma Uplerlawna hopopanni de nhoitio'or la Maria pa nla'awa. ");
INSERT INTO lex_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Noma Maria nwahi'a-nwayodia pa nhorwua noma pleta-plet pa nokria leta ida mak kden la Yudea, la'a gen miaka kden la wo'ora hananni. ");
INSERT INTO lex_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nla' noma nokria Sakaria romni pa nwak kalwieda la elli Elisabet. ");
INSERT INTO lex_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ne la'pa Elisabet natlin tutga Maria wniak kalwiedni dewade papay mak kden la Elisabet apannu ralamni de nlekru hmuakmuakru. Dewade Elisabeta ihranu ralamni npenpuen olek la Uplerlawna Nhiw Lululli. ");
INSERT INTO lex_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Noma Elisabet nhar lirni pa niwra: “O' di de mlier la pripanni-fa'anni (berkat) mak karehi-kalawan la'a maka patke'a honona rlernana. Tertera-demdema (berkat) nwewar nana a'na maka ha muor nian de! ");
INSERT INTO lex_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","A' di de he' a'u pede Uplerlawna Nhi' a pua aliernan nhiu'ru-nhielam di maka a Matromlawnu inni nmai a' diena?! ");
INSERT INTO lex_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Agat niohora a Matromlawnu eda de la apanmu ralamni yoma la'pa utlin nana ompuak kalwieda, dewade papay mak kden la a apnu di nlekru hmuakmuakru yoma nre'ela nahepru. ");
INSERT INTO lex_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mlier la unut lawna yoma mpiesiay oleka de maka Orgahi-Orha'a Nakot tiy o'a hota nayamkeka.” ");
INSERT INTO lex_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria na'uli-nawedia Uplerlawna pa niwra: “A'u'uli-uwedia O'a Matroma. ");
INSERT INTO lex_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ne a ralmu nahepuepru yoma Uplerlawna O'a ed mak kamori-kalewn a'u. ");
INSERT INTO lex_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yoma O' ed mak khoratreri a'u, hopopanmu a' di, maka kakleha weli. La' ler di pa hota tuwu nernu-nha'ata de hota rimormiori nohkerna wawannu riwra a'g e lier la unut lawna. ");
INSERT INTO lex_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Yoma Uplerlawna-Mempulwatnu mak kodi plola-ktaryat O'a Mhi'a-myap nieka hihi'a-yapyap miaka samomuou memna mai a'u. Nanmu nden la mounu-wahrani hitni-lomarni yoma O' de mak kakleha do'a-hala. ");
INSERT INTO lex_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tuw nernu-nha'ata, mere Orgahi-Orha'a O'a ed mak ktutga ralam kalwiedmu la' riy maka ka'unni-kamta'ata O'a. ");
INSERT INTO lex_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Mniairia limmu mak karuri-ka'orat de pa na Nwekapie'era riy mak katulu-kapetna. ");
INSERT INTO lex_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mulernia ray-ray rella la' mtatangenni mere Mrian tultulga riy mak klol yawa. ");
INSERT INTO lex_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Omuala mak kalwiedwed la mak kakleha-kaplara, mere makre'a-maktaru de edon rlernan hadom mere Mhuokar doinia la. ");
INSERT INTO lex_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Orgahiya, O' edonna Mhuortaplinga hya' ed maka Muno' taru la makden Yahudi upni-tgarni Abraham, Isak, me Yakop. Pede Omtiutga ralam kalwiedmu la Abraham nora duratni-waitni makden Israel ami makhi' hopopanmu-lili'irmu. Ralam kalwiedmu de nodi pa nodi liarni.” ");
INSERT INTO lex_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria naltier pa nhorwua noma nden wut lia Elisabeta la'pa edon nhal de wolla wotelu nhor diewade nla'awa. ");
INSERT INTO lex_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nte'ela lerni pa Elisabeta nmoria a'nani, noma nmor niana muanke' ida. ");
INSERT INTO lex_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabeta rom heiwialli re ror wutga inni-narni re ratlin nana de Orgahi kalwiedni mak kreh mieman de la'a Elisabet, noma honona re rmai pia rahepur nohora Elisabeta. ");
INSERT INTO lex_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","La'pa keke'en de umarnu lera wo'awa noma rom heiwialli ror wutga inni-narni rmai totpena rsunta keke'eni de, noma inni-narni riwra ral nanni pa nlernohora amni Sakaria. ");
INSERT INTO lex_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mere inni nahmena niwra: “Rwet neka la Yohanis wa.” ");
INSERT INTO lex_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Noma riy rakot la riwra: “Nihya'pa emkadena? La miy upmi-tgarmi de riy id mana edonna nwawa nan de.” ");
INSERT INTO lex_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Noma rawala hakamu lia Sakaria riwra rala hya' nan la a'namu dina? ");
INSERT INTO lex_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Noma Sakaria nwaka watu-le'g id pa nhorat la, de nhorta: “Nanni de Yohansi.” Honona re rwer rer wiawni. ");
INSERT INTO lex_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","La'pa nwet nanni la Yohansi dewade Sakaria mana lirni nawali owa'an la genni pa na'uli-nawedia Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Rom heiwialli re honona ramta'at wenna. Ne riy harahu mak kden la Yudea la wo'ora re uhunu-ewatni idma rwahaur nohor ida la' papay die. ");
INSERT INTO lex_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Riy honona rwarora la' ralamni, riwra: “Hota keke'en de lawan de la'a hya' o?” Yoma ramkek de Orgahi-Orha'a e Natiak reria de! ");
INSERT INTO lex_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Uplerlawna Nhiwni Nodi plolli la Yohansi amni Sakaria pa nwahaur nohora hya' maka Orgahi-Orha'a Nakot targa la e'a niwra: ");
INSERT INTO lex_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Mai pia ta'uli-tawedia Orgahi-Orha'a Israel Uplerlawna-Mempulwatnu. Yoma Enmai pia Ntuwu-nhai (menebus) mutnu-rahanu re. ");
INSERT INTO lex_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Hota Nala de muanke' ida metam keranni (mak karuri-kalai pa) Nma Namori-nalewn ita. E' de Uplerlawna hopopanni Daud di'nani-lohorni duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pa hota emekneka Orgahi-Orha'a Nano'targ oleka la ululu memna lola makwohorulu-ktatrulu (nabi) maka Ha Nwalir niana pa rakot nohora re. ");
INSERT INTO lex_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Totpena hota Nma Namori-nalewn it la'a ita arwalli mak ktern ita. ");
INSERT INTO lex_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nmai pia Ntutga ralam kalwiedni la it upni-tgarni Abraham, Isak, me Yakopa yoma E' edonna Nhortaplinga nnio' maka Enmemeh'a Nano'targa la ira, pa dodo'ondi de Nmai pia Nhi' memna. ");
INSERT INTO lex_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nnairi liokra pa naplol nohora nnio'oni de la it amni Abrahama, ");
INSERT INTO lex_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","de hota Nalewn it la'a it arwalli, totpena yan tamta'ata la tsima-tre' E'a, ");
INSERT INTO lex_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","totpena itwal lia E rimormiorni mak kakleha do'a-hala me mak kden la plol wawna pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Mere la'pa Yohansi a a'nu o'a de hota rhoi o la makwohorulu-ktatrulu makhi' hopopna-lili'iru la'a Uplerlawna mak kden la tutullu-lolo'oni. Yoma hota o' e mula'ul pua mpualipra-mpuahyaria Orgahi-Orha'a loini-talanni. ");
INSERT INTO lex_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Hota mhi' emkade la'a mukot nohora la E mutnu-rahanu ita, miwra hota Uplerlawna Namou-nawitn it do'oni-halli, ne emkade pede hota tler la yamori-yalewna. ");
INSERT INTO lex_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ne hota tler la yamori-yalewan de yoma it Uplerlawanni, ralam kalwiedni mak kareh mieman de mai ita. Yoma hota la' E kalwiedni de pede hota Ray Makamori-Kalewna ida Enwatiawua Ilyamou-Watyatoha (Sorga) pa Nmai pia emeknekama lera mak khitit la yawyawra. ");
INSERT INTO lex_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Totpena riy mak kden la melmelli-kalkalamni me ramta'ata hota rmati, de hota rlernana lelerni. Pa hota emkade pede E' ed mak kodia it la'a loi-talla maka kod it pa itora Uplerlawna tkalwieda owa'ana.” ");
INSERT INTO lex_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Sakaria naltier pa nhorwua noma la' pa Sakaria a'nani de nlawlawan lol wa me pesiayni la'a Uplerlawna mana narur wia, noma nmeh'a ndel la'a wo'orletna-kawurloini. Nden nek la' hande pa nte'ela lerni-melli dewade ntutga rupni la'a riy Israel re wa. ");
INSERT INTO lex_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","La' ler (maka na'nam ha rmor nian Yohanis) de Kaisar Agustus (makhi' ray lia lodna-hairi Romawi) nakot lirni pa mak kden la Romawi lodanni-hairni totpena honona rma rakot nanni pa rhorta totpa rhor (rekna) momuoga kuku'uni-lalawanni honona (sensus). ");
INSERT INTO lex_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sensus di ed mak kala' ulu la' ler maka Kirenius nhi'a gubernur la' Siria na'nama rhi'a sensus di. ");
INSERT INTO lex_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","La' ler de de riy honona rawal lia letni-ruhunni, totpena rhorta nanni la mak ktoran leta horta hairni. ");
INSERT INTO lex_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pa hota Yusup mana nden la Nasaret la' noha Galilea pa nokria noha Yudea, pa nla' let Betlehem maka ha rmor tiarga ray Daud, yoma Yusup nwatiawua Daud luwnu-a'nani. ");
INSERT INTO lex_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Noma Yusup nor niah'ani Maria mak ka'apuapun rer die rmai rewre'wa pa rhorat walia nanni la hande. ");
INSERT INTO lex_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","La'pa rdella Betlehem dewade Maria wolanni ntu'tu wa pa hota nayor wia. ");
INSERT INTO lex_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Noma nayor dioinia a'na yanullu muanke'a ida, de nala koka na ntomna na'nama nadud tiarga la duma ya'an genni maka ha rala wewnihi ra rwowa, yoma ir edonna rlernana geni-tiena la' geni miaka ha rpairi pa ranin la hande. ");
INSERT INTO lex_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","La' mel de de makodi duma ertepartarlia yatiaka dumni re la'a wewna wawannu mak edon olieta la Yusup nor Maria genni. ");
INSERT INTO lex_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Noma plinu-plinnianama Orgahi-Orha'a hopopanni Ntutga rupni la ira, ne Orgahi-Orha'a hitititni reprepar nana ir honona pa reiniande honona ramta'at wenna. ");
INSERT INTO lex_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Mere hopopan de nakot la re niwra: “Yan mimta'ata! Yoma a'g e godia kot kalwiedweda id tiy miy! Hota hadi de nodia hepuepru la riy honona. ");
INSERT INTO lex_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","La' ler di de rayori oleka papay id la Daud letni (leta tniet ohorni), mak kodia miy lia mormiori-lewlewna. E' ed maka ha riwra Ray Makamori-Kalewna maka Uplerlawna Nano'taru, de Itmatromni. ");
INSERT INTO lex_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne hota la' hadi pede hota miat niohora memna a li'ru ri raplola: de hota mlia' pa mliernana papay ida de e rala koka ra rtoman targa me radud tiarga la duma ya'an geni maka ha rala wewnihi ra rwowa.” ");
INSERT INTO lex_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Plin-plinnianamde Uplerlawna hopopanni re ema riw niana pa nor wutga hopopna mak kala' ul die raloi lirni pa ra'uli-rawedi Uplerlawna riwra: ");
INSERT INTO lex_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Uplerlawnu nee! Ama'uli-mawed reri O la O genmu-tienmu la' tutullu-lolo'oni. Hota kalwieda-paitiota la'a nohkerna wawannu la'a rimormiori miaka Uplerlawna ralamni nala.” ");
INSERT INTO lex_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Dewade Uplerlawna hopopanni-lili'irnu re honona rwarei lia gen die wa pa rawal lia Ilyamou-Watyatoha, noma makodi duma re idma nakot la ida riwra: “Mai pia tla' teka Betlehema pa tamkeka maka Orgahi-Orha'a Nakot mai ita rena!” ");
INSERT INTO lex_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pede honona radil doin la (ririri pa rla'awa) pa rla de rhor niana mdududga Maria nora Yusup me papay die maka e radud tiarga la dum ya'an gen die. ");
INSERT INTO lex_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","La'pa ramkek nana papay die noma rla' rwahaur nohora la' riy, la'a hya' maka hopopna re rakota la ira la'a ke'enku' de. ");
INSERT INTO lex_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ne riy honona mak katlin nana de rwer rer wiawni la mak ha rwahauru re. ");
INSERT INTO lex_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mere Maria nwarora-nwalai niohora hare honona pa nwatierun targa la ihranu ralamni. ");
INSERT INTO lex_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Noma makodi duma re honona rawal pia rla ramkek la nhiurni-wnia'anni. Ne ra'uli-rawedia rlilili-rmamuawua Uplerlawna kotni-nanni, yoma la'a hya' maka hopopna rakota la ira pa rla' pa rlina-rmat (ramkek) meman oleka de. Hya' maka ha ramkeka de emekwalia maka Uplerlawna hopopanni-li'irnu nakota la' ira. ");
INSERT INTO lex_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","La'pa Yesus Nler la lera wo'awni dewade o'ta-mata krei rma rsunta. Ne inni-amni rhi' nanni pa nwawa Yesus. Yoma nan de ed maka Uplerlawna hopopanni ha rakota la' lera Maria edonna na'apnu ma'ta. ");
INSERT INTO lex_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Noma la la'pa nte'ela la' lerni pa Yusup nor Maria rlernohora Musa deullu-tatarni pa rhi' amou-awitna inonni re la'a Uplerlawna roma kreini, pede rod walia a'nani Yesus la Yerusalem pa ral wali a'na de la Orgahi-Orha'a la' hande, ");
INSERT INTO lex_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","pa emekneka Orgahi-Orha'a nnio'oni maka Nakot taru la' Musa deullu-tatarni de Eniwra: “Riy honona a'na muanke'a yanullu de ed maka rala la Orgahi-Orha'a orgahani.” ");
INSERT INTO lex_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ir mana e riwra ral walia himima-rere'a la Orgahi-Orha'a la E roma kreini totpa rhi' amou-awitna inonni rlernohora maka ha rakot targa olek la'a Orgahi-Orha'a deullu-tatarni ralamni de niwra la'pa rhi' amou-awitna inonni (mere rakleha-raplara), hota ral neka ma'nu loktieru id nora tnialwialli, onde lmo'ma maru trapriapi woru. ");
INSERT INTO lex_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","La' ler de wal pia riy id etla la' Yerusalem de, nwawa Simeon. Hade ed maka nhi'inde ntutga nhiolia samomuou la rimormior wialli, me natu na'unni-namta'ata Uplerlawna lirni-tunnu, deullu-tatarni, ne nwei rer niek la' lerni-melli maka hota Uplerlawna Namori-nalewna Israel. Uplerlawna Nhiw Lululli Nor reria talan wutu. ");
INSERT INTO lex_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ne Uplerlawna Nhiw Lululli Nakot olek la wa Niwra hota e' edonna nmat mia'ta yoma edonna namkek ma'ta Ray Makamori-Kalewna maka Orgahi-Orha'a Nano'tar die! ");
INSERT INTO lex_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","La' ler de Uplerlawna Nhiw Lululli niodni pa Simeon nler la Uplerlawna roma kreini, dewade nwatrom tut niana Yusup nora Maria rod wialia a'nani Yesus maka lokmermer ma'ta de pa rma rlernohora Musa deullu-tatarni. ");
INSERT INTO lex_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Dewade Simeon na'ala keke'en de na'nama nakiria pa na'uli-nawedia Uplerlawna niwra: ");
INSERT INTO lex_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Orgahi-Orha'a nu ne! Uplerlawna-Mempulwatnu mak kdella tutullu-lolo'oni mak kodi plola-ktaryatu, hya' maka Omukottaru mai a'u ntutu-nte'ewa, pede ndella pa hopopanmu a' di alier la matmiati yoma a ralmu di namtiertiernu olekwa. ");
INSERT INTO lex_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yoma agal memna ma'tu olli rora pa ga umkeka riy maka Omtiutga olek pa Nma Namori-nalewna rimormiori de! ");
INSERT INTO lex_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Makamori-Kalewan de, O' e Mpuahi'a-mpuayod tiarg oleka wa totpena Nma Nod tiemna luwu-a'na mak kden la lodna-hairi re honona totpa honona re ramkek nan memn E'a. ");
INSERT INTO lex_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pa emeknekama hulu mak kodia lelerni la Yahudi atia'a totpena rat niohora O'a. Ne onnila hihi'ini pede riy honona rhu'ru-rhelam la mutmu-rahamu Israel.” ");
INSERT INTO lex_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Keke'en de inni-amni rwer rer wiawni la'a hya' maka Simeon ha nakota la keke'en de riorni-liaini. ");
INSERT INTO lex_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon nwaka Uplerlawna totpa Nala tertera-demdema la ira, noma nakot la Maria niwra: “La' keke'en di de Uplerlawna Ntutmuata-nkewra'a oleka E' pa hota la'pa nlawan oleka de, Nalernia Israel uhunu-riwni (harahu) dom mak kahmena rpesiaya me Israel uhunu-riwni dom de Nrana pa rwakriania Uplerlawna. Hota riy ramkek nana E hihi'ini-yapyapni onde ratlin nan E lirni mak ktutga Uplerlawna ralma-riorni mere rimormiori liawanni hota rwayotlia E'a. ");
INSERT INTO lex_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ne hota la' hade pede Uplerlawna Nalharia riy harahu ralma-riorni pa riy dom to'a rat niohora ir ralma-riorni wali. Ne hota Maria, o ihramu-ralammu mana nmawal doin meman la pa emeknekama wehla ploklokra maka ha ra rteti-rlaiya pa ra rkokia la ihramu-ralammu.” ");
INSERT INTO lex_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Me la' hande de patke'a makwohorulu-ktatrulu id etla nhape' olekwa, nanni Hana. Fanuel, Asyera duratni-waitni, de a'nani. Nmehlim pa mahnekni anni wo'itu mere hawni nmati. ");
INSERT INTO lex_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pa napatyata, me nmormior nan oleka anni terampwo'awa wehrani wogata, ne nhi'inde nhol lielera-melmel to'ola' Uplerlawna roma kreini. Lelera-melmela de nden nek la hande pa nkola tieru-nawur nehla la Uplerlawna me natahan lara. ");
INSERT INTO lex_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon naltier pa nhorwua na'nama hape' de nma nhuru nana harella hande, pa na'uli-nawedia Uplerlawna me naltier niohor la keke'en de la'a riy honona mak kden la hande maka rwewiei niohora hota Uplerlawna Nwe'er doin mak kden Israel re la'a wutwutu-kokgohu. ");
INSERT INTO lex_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","La'pa Yusup nor Maria rhi' ahorga deulu-tatra Orgahi-Orha'a hanni, noma rawal lia Nasaret, ir let wamueheni de la Galilea lowanni. ");
INSERT INTO lex_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Keke'en de na'ititar rer lia liawanni nora rurni-laini, me la' wniarora-wnialai samomuounu, ne Uplerlawna Nara'a-napalga! ");
INSERT INTO lex_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","La' anni-anni nekpa Yesus inni-amni rla'a Yerusalem totpena rhi' nohora Yahudi lerlalawna Paska (maka rhoratreria tuini-wedni la'a ler maka rlergot la Mesir). ");
INSERT INTO lex_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","La'pa Yesus Nmormior niana anni termida wehrani woru noma nor rewre'wa inni-amni rla'a Yerusalem totpena rhi' nohora lerlalawan de pa emekwalima la anni-anni inni-amni rhi'a de. ");
INSERT INTO lex_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","La' pa lerlalawan de nhorwua noma rpolan wa. Mere Yesus, keke'enku' de, Nwarin mia'ta la Yerusalem mere inni-amni raplin niohora. ");
INSERT INTO lex_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Inni-amni ratniekame Enor la mutlialawna re pa rala' wutu pede rodi liarni la'a yala'a la'a lera ida. Dewade inni-amni rwahak la'a-mai nieka Yesus la'a mutlialawan de la'a inni-narni ror wutg riy maka irat niohor oleka. ");
INSERT INTO lex_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mere inni-amni edonna rlernana ha lolola. Pede la' lera wornu de inni-amni rawali owa'an la' Yerusalem pa rwahaka. ");
INSERT INTO lex_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","La' lera wotellu la'a wniahakni de na'nama rlernana E' la Uplerlawna roma kreini de Enora makwatutu-kwaye'a agama ramtatan wut pua Natlina-natailla re, ne Natian la'a-mai makwatutu-kwaye'a agama re. ");
INSERT INTO lex_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Riy honona mak katlin reria re rwer rer wiawni la keke'enku' de, yoma Nwet la mak ha ratiana la E'a, de kriahi-kriahaya. ");
INSERT INTO lex_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Inni-amni mana rwer rer wiawni la' a'nani de. Noma inni nakot la niwra: “Ama, nihya'pa Omhi'a-myapia emkadilla mai ami? Agor ammu mdiwra-mda'al la o yahakmu.” ");
INSERT INTO lex_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Noma Yesus Nakot la Niwra: “Ina, nihya'pa omuora a'mu mihak A'u la meni-meni? Miy e miplinga de hota A'g etla A A'mu romni nayanni?!” ");
INSERT INTO lex_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mere inni-amni raplin niohora a'nani de lirni nnia'eratni. ");
INSERT INTO lex_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nhor nioma Yesus nor rewre'wa inni-amni re pa rla'awa la Nasaret ne natu natlina-natailla inni-amni. Ne hare honona de er momuou lia inni ihranu ralamni. ");
INSERT INTO lex_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus la' pa Nlawlawan lol wa ne Na'ititar rer lia wniarora-wnialai samomuounu me yeher to' pa Nla' nana Uplerlawna Nor walia rimormiori ralamni. ");
INSERT INTO lex_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","La'pa Kaisar (ray) Tiberius nodi plolli nana anni termida wehrani wolim pa, Pontius Pilatus nhi'a gubernur la Yudea, ray Herodes nod plolli la Galilea. Ne Pilipsu, Herodes hyalli, de nodi plolli la noha Iturea me Trakonitus, la'pa Lisanias demade nodi plolli la'a Abilene. ");
INSERT INTO lex_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ne la'a makla' o'ta tutulu la imam-imam honona re, de Hanas nor Kayafas. La' anin de ralamni nekpa Uplerlawna Nhar lirni la Yohansi, Sakaria a'nani mak kden la wo'orletna-kawurloini. ");
INSERT INTO lex_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Noma Yohansi nlol meni-meni to'owa la'a gerlawna Yordan uhunu-ewatni-lahwani pa nakot nohora Uplerlawna lirni. Yohansi nhaun pa niwra: “Hoi! Mhioitio'ora-mtiahnei dioinia do'omi-halmi re pa mai pia rharan miy ee! Totpena hota Uplerlawna Namou-nawitan miy lia do'omi-halmi!” ");
INSERT INTO lex_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yohansi hihi'ini-yapyapni mak emkade de hota emolmolan nekama mak ha rhorat targa la makwohorulu-ktatrulu Yesaya Pukni ralamni de e riwra: “Hota riy ida e polpuolu-hawaunia la wo'orletna-kawurloini pa niwra: “Mpiahi' targa talla la Orgahi-Orha'a, mpiale'era loini-talanni. ");
INSERT INTO lex_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Mtiwria pen tani la elaw maka katro'a-kakdielma re, me mtiurwaneha wo'ora tutulu kyawyawa re. Me loi-talan maka koili-kaili mana mhi' wale'era, me talan maka katro'a-kakdielma mana mpianeha wawannu. ");
INSERT INTO lex_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Totpena rimormior nio' nohkerna wawannu honona ramkek memna, la emkameni Uplerlawna Namori-nalewna rimormior la noha wawannu.”” ");
INSERT INTO lex_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Noma riy harahu ema rtiwur nana pa rma rahaka Yohansi pa rharania. Noma Yohansi nakot la dom de niwra: “Hoi! Miy di de emolmolan nekama niy mak kodi nhienni yoma mhi' tukla-wahla. He' ed mak kiwra la'pa rharan nek miy demade hota Uplerlawna niukum lawanni mak kmai niek de hota edon nal miy?! ");
INSERT INTO lex_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mere mtiutga nhioli-liet kalwiedwedmi, totpena riy ratga de plol toto'a mhioitio'or doin-mtiahnei dioin oleka do'omi-halmi re wa. Yana mpiarora de hota miy edonna mliernan niukum lawna yoma upmi-tgarmi de Abraham. Yoma Uplerlawna nekane Nodi plolli pa Na'ala watu-watu ri pa Nhi'a la Abraham duratni-waitni. ");
INSERT INTO lex_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mhioratreri ee! Uplerlawna e Nwahi' meman targa pa Nukmua he' to'a mak edon kolin doinia do'oni-halli. Yoma emeknekama Nwahi' targa wro'onni pa na Netan dodioinia ora-au onni pa la ntut lia ga'arni re honona. La'pa ora-au muaka edon kawo'a samomuounu, de hota Nhoi wro'onni la pa Nnaklia la ai ralamni.” ");
INSERT INTO lex_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Noma riy lia mutlialawna re ratiana Yohansi riwra: “Hade emkade, de hota amhi'a hya'a wa?” ");
INSERT INTO lex_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Noma Yohansi nakot la re niwra: “La riy maka hanni raini woru, de nal id la'a riy mak kakleh raini. Ne la' riy maka ya'anni-yemannu erla de nhakra la mak kakleha.” ");
INSERT INTO lex_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Me mak kawoka blastena mana rmai pia totpena Yohansi nharania re. Noma ratiana Yohansi riwra: “Tungkurga! Hota emkameni wal miai ami?” ");
INSERT INTO lex_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Noma Yohansi nakot la niwra: “Yan memmemna mimpiak de narehi-nalawan la maka miy o'tami ha nhopan pa mlia miwoka.” ");
INSERT INTO lex_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","La' hande mana makodi keki-rautu ratian nohor walia emkameni la ira? Noma Yohansi nakot la re niwra: “Yan memmemna mpiarui-mpiate'la rira kupanni-kaini yoma mtiota-mpiud riy de la hal wawna. Mere mi'ina-miemun neka kaimi la' liwatmi-odapmi welli!” ");
INSERT INTO lex_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","La' ler de riy rwei rieri Ray Makamori-Kalewna maka Uplerlawna Nano'taru pa rwarora: “Yanpa Yohanis di, de ed maka ha rakota riwra Ray Makamori-Kalewna maka it twei-tnara inhattio?” ");
INSERT INTO lex_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Noma la' hade pede Yohansi nakot la re niwra: “Ina-nara ama-hyali, a' di agala gera ga gharani miy, mere hota riy mak kmai die, Nala Uplerlawna Nhiwni tiy miy me emekwalima Nala ai na Nharani miy. E Nareh dioin a'u. Hota awue'er doin lakni wniowni ho'mana a'g edonna puar nana. ");
INSERT INTO lex_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ne hota emolmolan nekama E' ed maka ktorreria totopa maka ra ralipra-ratai metma-wetra' lawna (gandum). Metma-wetra' lawan de, hota rawoka la'a dudnu (kliala) ralamni, mere hota kownu re honona de rwalia la ai miaka takeni rwarum nana!” ");
INSERT INTO lex_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Pa emkade mamain la Yohansi nano'a-na'atga rira la'a hya' to'a, la' ler maka ha nakot nohora Kot Kalwieda-Paitiota de la' ira. ");
INSERT INTO lex_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Mere Herodes mak kodi plolli la Galilea de, Yohansi namer matni pa npolliohora, yoma nor owa'ana yerni Herodias rmehlima, me npolliohor walia Herodes yatni-halli dom to'a honona maka ha nhi' oleka wa. ");
INSERT INTO lex_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Mere Herodes edonna nmaltier eti, ne yeher to'ama nhi' rereria yatni-halli la'a enken tiarga Yohansi la roma nhio'la ralamni. ");
INSERT INTO lex_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","La'pa edon rken mia'ta Yohansi la roma nhio'la ralamni, de la'pa Yohansi entepartar ma't la nhiarania riy harahu re, noma Yesus Nmai wial pia rharania wa! Ne la'pa Yohansi nharania Yesus pa nhorwua noma Yesus Nsumbain reri dewade lyanti nhar dioinia. ");
INSERT INTO lex_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pa Uplerlawna Nhiw Lululli Nerun de emolmolla ma'nu lmo'ma maru (merpati) pa ntai lia wawannu. Noma ratlin de Uplerlawna Nhar lirni la'a lyanti Niwra: “O' de A A'nu mak Asiayni inhatti. O' ed maka kla' nana A ralmu.” ");
INSERT INTO lex_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","La' lera Yesus Nwau kniarni de tuwnu la'pa edonna rhal de anni terampwotelu. La'a rira wniarorni de E' de Yusup a'na raralamni. Yusup amni de Eli. ");
INSERT INTO lex_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli amni de Matat, Matat amni de Lewi, Lewi amni de Malki, Malki amni de Yanai, Yanai amni de Yusup. ");
INSERT INTO lex_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusup amni de Matica, Matica amni de Amos, Amos amni de Nahum, Nahum amni de Hesli, Hesli amni de Nagai, ");
INSERT INTO lex_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai amni de Maat, Maat amni de Matica, Matica amni de Simei, Simei amni de Yosek, Yosek amni de Yoda, ");
INSERT INTO lex_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda amni de Yohanan, Yohanan amni de Resa, Resa amni de Serubabel, Serubabel amni de Sealtiela, Sealtiel amni de Neri, ");
INSERT INTO lex_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri amni de Malki, Malki amni de Adi, Adi amni de Kosam, Kosam amni de Elmadam, Elmadam amni de Er, ");
INSERT INTO lex_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er amni de Yesua, Yesua amni de Elieser, Elieser amni de Yorim, Yorim amni de Matat, Matat amni de Lewi, ");
INSERT INTO lex_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi amni de Simeon, Simeon amni de Yehuda, Yehuda amni de Yusup, Yusup amni de Yonam, Yonam amni de Elyakim, ");
INSERT INTO lex_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyakim amni de Mela, Mela amni de Mina, Mina amni de Matata, Matata amni de Natan, Natan amni de Daud, ");
INSERT INTO lex_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daud amni de Isai, Isai amni de Obed, Obed amni de Boas, Boas amni de Salmon, Salmon amni de Nahason, ");
INSERT INTO lex_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahason amni de Aminadab, Aminadab amni de Admin, Admin amni de Arni, Arni amni de Hesron, Hesron amni de Peres, Peres amni de Yehuda, ");
INSERT INTO lex_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehuda amni de Yakop, Yakop amni de Isak, Isak amni de Abraham, Abraham amni de Terah, Terah amni de Nahor, ");
INSERT INTO lex_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor amni de Serug, Serug amni de Rehu, Rehu amni de Peleg, Peleg amni de Eber, Eber amni de Salmon, ");
INSERT INTO lex_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salmon amni de Kenan, Kenan amni de Arpaksad, Arpaksad amni de Sem, Sem amni de Nuh, Nuh amni de Lamek, ");
INSERT INTO lex_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek amni de Metusala, Metusala amni de Henok, Henok amni de Yared, Yared amni de Mahalaleel, Mahalaleel amni de Kenan, ");
INSERT INTO lex_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan amni de Enos, Enos amni de Set, Set amni de Adam, ne Adam amni Uplerlawna-Mempulwatnu. ");
INSERT INTO lex_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Uplerlawna Nhiw Lululli Nodi plolli la Yesus la' ler maka Nlergot la gerlawna Yordan. Noma Uplerlawna Nhiwni Nodia Yesus la wo'orletna-kawurloini. ");
INSERT INTO lex_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","La'pa Nden la hande noma hegana amlawanni nta' niana la lera-mela terampwogata. La lelera-melmel de Yesus edonna na'ana hadomdoma, pede la'a lera terampwogata hohoni de Naplar memna. ");
INSERT INTO lex_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Noma hegana nakot la Yesus niwra: “Hoi! Uplerlawna A'nani O'a toh?! Mhuopan teka watgau di pa nwal lia yamanna pa Omu'una.” ");
INSERT INTO lex_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Noma Yesus Nakot la Niwra: “Hota A'g edon liernohora o lirmu de, yoma la' Puka ralamni de nakot nohor oleka de: “Rimormiori edonna rmormior die yoma la'a yamanna nmeh'a.”” ");
INSERT INTO lex_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Noma hegan de nodia Yesus la wo'or tutul liawna id hananni, ne mtatande nekpa hegana ntutga hairi-hairi (kerajaan) mak kden la noha wawannu honona la' Yesus, ");
INSERT INTO lex_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","na'nama niwra: “Hota agala pa Muodi plolli la hairi-hairi re me Mliernana hairi-hairi re re'eni-tniarnu, yoma la' hare honona rala oleka mai a'u pede agiwa gala la he' to' de plolli nek ma' a wua. ");
INSERT INTO lex_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Hairi-hairi honona re hota agala tiy O'a pa Omuodi plolli la, hornama Omtiuk pua Mhu'ru la a la'ku nayanni.” ");
INSERT INTO lex_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Noma Yesus Nakot la Niwra: “Mere etla Puka ralamni de e niwra: “Riy honona rhu'ru-rhelam la Orgahi-Orha'a Uplerlawanni, me ratlina-ratail to'ola Ha Nakotkota.”” ");
INSERT INTO lex_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","La'pa nhorwua noma hegana amlawanni de nodia Yesus pa nla'awa la'a Yerusalem na'nama nkenia la Uplerlawna roma kreini wuwannu pa Ntutrier lia hande na'nama hegana nakot la Yesus niwra: “Plola O' di de Uplerlawna A'nani O'a, de Mnieh gerun tek la handina! ");
INSERT INTO lex_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yoma la'a Puka ralamni de e niwra: “Hota Uplerlawna Nhopna pa hopopanni ratiak reri o'a. ");
INSERT INTO lex_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hota rkim o'a totpena yana mtiuini ne watgau mana hota edonna rtai o'a.”” ");
INSERT INTO lex_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Noma Yesus Nakot la: “Mere etla Puka ralamni de e niwra: “Yan memmemna rimormiori rta'aga Orgahi-Orha'a mak kla' ir Uplerlawanni (yoma ir rhi' hihi'a-yapyapi podpodku-padpadku dewade rwak la Orgahi-Orha'a pa Namori-nalewn ira)!”” ");
INSERT INTO lex_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","La'pa hegana amlawanni de ntot la'a-maiya Yesus dewade nto'or la pa nwei lerni-melli dom to' owa'ana. ");
INSERT INTO lex_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nhor nioma Yesus Nawal lia Galilea ne Uplerlawna Nhiwni Nodi plolli la. Nwewar la gen die uhunu-ewatni-lahwani, de npe'era-npah'a la Yesus kotni-nanni. ");
INSERT INTO lex_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Enwatutu-nwaye'a la'a roma-lewu muaka nhi'inde Yahudi rhi' kreini-iskolli, ne riy honona ra'uli-rawedia E'a. ");
INSERT INTO lex_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Noma Yesus Nla' owa'an la leta Nasaret, la'a gen miaka Enor inni-amni rdella la' ler maka Ha Nlalawan lola de. La'a Sabat lerni maka Yahudi edon rkar lia de, de Yesus Nla'a gen miaka nhi'inde Yahudi rhi' kreini-iskolli, pa emeknekama nhi'inde Enhi' nana. Noma Enaprir pia Npaikia Puklawna. ");
INSERT INTO lex_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ne rala makwohorulu-ktatrulu Yesaya Pukni. La'pa Enweran doinia Puka pniopan della dewade Nahak pa Nlernana ayat id totpena Npaikia la rira gaini ralamni. Ayat de lirni emkadi: ");
INSERT INTO lex_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Orgahi-Orha'a Nhiwni etla A ino'nu. Yoma E' ed mak ktutmuata-kewra' A'u totpena ukot nohora Kot Kalwied della mak kakleha-kaplara. E' ed mak khopn a pua ukot nohora la'a riy maka rwutu-rkoh tiaru hota rolin doin ir la, me rwe'era aphyaria mak matni kyata, me rolin doinia la maka rutni-rdahla re. ");
INSERT INTO lex_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ne totpena ukot nohora Orgahi-Orha'a wennu-wolanni maka kmai nieka di maka hota Entutga ralam kalwiedni la E mutnu-rahanu.” ");
INSERT INTO lex_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesus Npaik pa nhorwua noma Npopn owa'ana Puk della genni, ne Nal owa'ana la' mak ktorna Puka re, nhor nioma Namtatna totpa Nwatutu-nwaye'a re. Riy honona mak khi'a krei re rwatniar reria Yesus. ");
INSERT INTO lex_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Dewade Nakot emkarella Niwra: “Hya' maka Apuaik oleka ri de Aghi' olek la dodo'ondi memna.” ");
INSERT INTO lex_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lira-tun muaka Ha Nakota re narieiniande irwer rer wiawni la ne rwarora de samoga re pede irarian la heyanna pa rre'ela rhi' nohor walia E'a (menyokong). (Mere nhorwua noma emeknekama ralamni re rakwali pa edon rpesiaya,) pa idma nakot la ida: “Hade de Yusup a'nani to' neka hadi toh?!” ");
INSERT INTO lex_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Noma Yesus Nakot la re Niwra: “Agatga de miy miwra mikot la mai A lia hya' mak riy nhi'inde riwra: “La'pa plollolli de dokter o'a de orgahamu mhi' kalwied teka orgahamu.” Yoma miy wniarormi de la'pa plollolli de Agodi plolli pa ghi' oleka hihi'a-yapyapi mak kamehi-kayona (mujizat) la Kapernaum emeka mitlin nana oleka, de hota Atiut walia A plo'lu-mneh'u pa ghi' tek walia hihi'a-yapyapi mak kamehi-kayona la'a A let wamueh'u dina. ");
INSERT INTO lex_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mere mhioratreria me! Hota la' makwohorulu-ktatrulu ida, riy edon rreiniana-ra'nana la' e let wamueheni, yoma mak kden la e letni re edonna rpesiaya. ");
INSERT INTO lex_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mimpiesiay A li'ru di! La'a Elia lerni, de otna edonna ntur niana anni wotel riehenu, pa nhi'nande lar lawna nwewar noha. La' ler de patyata harahu la'a Israel. ");
INSERT INTO lex_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","La' emkade ho'mana Uplerlawna edonna Nhopna Elia nla'a riy id la'a patyata re, mere eneknek to'ama nla' patyata id la'a Sarfat la'a genia Sidon. ");
INSERT INTO lex_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Emkade walia la'a makwohorulu-ktatrulu Elisa lerni de mak kden la Israel liawanni rlernana nhieni ulityata-temyata ho'mana riy id edonna nkalwied eti eneknek to'ama Na'aman, de riy Siria ida.” ");
INSERT INTO lex_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","La'pa iratlin E lirni mak emkade dewade hare honona la'a gen die ralamni rawenan doin la. ");
INSERT INTO lex_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Honona raprir pia rhokar doinia Yesus la'a leta to'orni, pa ra rpuitia la'a tuini werna ida, maka ha rariria letni de. La ralma-riorni totpena rotliernia Yesus la'a tuini werna kdieldelam de ralamni. ");
INSERT INTO lex_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mere Yesus Nala'a la riy mutlialawna re letgarni pa nadil doin la (Nla'awa). ");
INSERT INTO lex_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nhor nioma Yesus Nla'awa la leta Kapernaum la Galilea. La hande de Enwatutga riy rahu la'a Sabat lerni, maka Yahudi edon rkar lia de. ");
INSERT INTO lex_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Riy rwer rer wiawni la wniatutnu-wniaye'eni de, yoma Nodi plolli (wibawa) pa Nwatutu. ");
INSERT INTO lex_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","La'a gen miaka nhi'inde Yahudi rhi' kreini-iskolli la, de riy ida maka hegana nhu'ru ralma. Nhaunu-nhaunu pa niwra: ");
INSERT INTO lex_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hoi, Yesus Nasartu ne! Hota Omhi' nan emkameni mai ami oo! Ommuai pia mpieyat ami? A'g e gat niohora de he' O'a! O' di de maran yamou-wuhur yatoha (yang suci) maka Uplerlawna Nwalir niana pa Nhopan pa Ommuai lia nohkerna wawannu!” ");
INSERT INTO lex_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Dewade Yesus Nkamota Niwra: “Rhodal nurmu! Rhokargo'tu la'a riy di!” Noma yatni-rha'ani de nhi' riy de pa ntuini la tani wawannu la'a riy honona gaini ralamni, nhor nia'nama yatni-rha'ani de nhargot wa, mere riy de edonna na'eram nana mehra-mau kuku' eti. ");
INSERT INTO lex_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Riy honona rwer rer wiawni me idma nakot la ida riwra: “Ha yaltierni de Nodi plolli la hegana-kawnu, yatni-rha'ani pa ema rho'or dodioinia!” ");
INSERT INTO lex_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","La' hade pede yeher to'ama Yesus kotni-nanni ema reyapie'era la geni-tiena re honona mak rehgorgoru. ");
INSERT INTO lex_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","La'pa Yesus Nhoitio'or la gen miaka Yahudi re rhi' kreini-iskolli de, noma Nodi liarni la Simon romni. La' de Simon yananni entepartarlia riuru npahna nohora tema pniahnani, noma rwaka Yesus pa Ntulan la. ");
INSERT INTO lex_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pede Yesus Nla Nwakriania patke' de yanin genni, na'nama Nkamota ruru pniahna della' patke' de, dewade nnienni de nmolu. Noma namat meman pa nla nwahi'a-nwayodia ya'ana-yemnu pa honona ra'ana-remnia. ");
INSERT INTO lex_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","La'pa lera ntuinia dewade riy rahu rodia inni-narni honona maka kler la nnieni-nhiena mehra-mau pa rma rahaka Yesus. La' pa Yesus Nran limni la mak kanieni re riy nenenna wawannu, dewade honona re nnienni rkalwied wa. ");
INSERT INTO lex_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Yatni-rha'ani, hegana-kawnu re mana rlergot momuou lia riy harahu me yatni-rha'ani polpuolu-hawaunia riwra: “Amatg oleka de Uplerlawna A'nani O' ee!” Mere Yesus Nkamota re totpena yana rakot nohor E'a, yoma hegana-kawnu re rat niohora de Ray Makamori-Kalewna maka Uplerlawna Nano'targa E inhatta. ");
INSERT INTO lex_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","La'pa lera matni nra'pa gota dewade Yesus Nhoitio'ora la let de wa, ne Nokria geni hgali ida. Riy rahu rtepartarlia yahakni, pa la'pa rlernana de honona rwak memna E'a totpena yana Nwarei lia ir onni. ");
INSERT INTO lex_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mere Yesus Nakot la Niwra: “Kot Kalwieda-Paitiota maka rakot nohora emkameni la Uplerlawna Nodi plolli la riy pa emeka ir Rayni, de hota A'ukot nohora la miy edonna mieh'a mere A'ukot nohor walia la leta-leta korni dom to' wali. Yoma la hade pede Uplerlawna ed mak khopan pa Amuai lia nohkeran di wawannu!” ");
INSERT INTO lex_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","La' hade pede Yesus Nla' pa Nokru roma-lewu dom to'a maka Yahudi re rhi' kreini-iskolli la, la'a Yudea liewnu, pa Nakot nohora Uplerlawna Kot Kalwiedni la' hande. ");
INSERT INTO lex_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","La lera ida, Yesus Enaprir rier lia danau Genesaret eni wawannu pa Nakot nohora Uplerlawna Kot Kalwiedni, ne riy rahu rwakdieh'a pa rmai pia ratlina E lirni. ");
INSERT INTO lex_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Noma Yesus Namkek de mak kla' lora puounu worga rapniali ne matromni re rerun oleka pa rtepartarlia ramoga tialli rella eni wawannu. ");
INSERT INTO lex_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","La' noma Yesus Nha'at la puou id de, maka riy ida nwawa Simon gahani, na'nama Yesus Nwak pa Simon nahlera puounu de keke'ela' lora. Na'nama Yesus Namtatna la puou die ralamni pa Nwatutu-nwaye'a riy rariahu re. ");
INSERT INTO lex_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","La'pa Yesus Nwatut pua nhorwua. Noma Nakot la Simon Niwra: “Mpuehelia pupallu pa mutial i'na.” ");
INSERT INTO lex_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Noma Simon nakot la niwra: “Tuna, orawia mel matmiat liawan de amahak i'na mere ami edonna mliernan et hya' doma! Mere yoma Tuna e Nhopna, pede agiwa lia' tieka.” ");
INSERT INTO lex_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","La'pa ir Simon rinni tialli, dewade tialli nma nwenna la i'na, pa reiniande tiala natpoini-nahliawra. ");
INSERT INTO lex_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pede rkawlia mutwualli puou handina de pa rma rre'ela, ramoga i'na la tiala. Noka rmai pia rwatierun nana la puou re pa narieiniande nhi'pa rtepra. ");
INSERT INTO lex_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","La'pa Simon Petrusa nlina-nmata (namkeka) hare honona dewade nwaltiora-nwaltieman la Yesus nayanni na'nama nakot la niwra: “Yan muor nek a' tialan wa Matroma, yoma a' di de, riy dodo'a-halal id a'u.” ");
INSERT INTO lex_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nakot emkade yoma Simon nor neka mutwualli la' puounu de, rwer rer wiawni la i'n mutlialawna maka rlernana re. ");
INSERT INTO lex_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Emkade walia Simon mutwualli la' puou handina, de Yakowsi nor Yohansi, Sebedeus upni-a'nani re. Noma Yesus Nakot la Simon Niwra: “Yan mumta'ata Simona! Mai pia Awuatut o'a totpena emkameni la omultial reri i'na la dodo'ondi, de hota emkade wal pia muhak nohor rimormiori totpena hota rpesiay mai A'u.” ");
INSERT INTO lex_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Dewade Simon nora mutwualli re rtitin targa loini-puounu dewade raltarga hare honona pa rla rlernohor reria Yesus. ");
INSERT INTO lex_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","La'awa lera ida, de Yesus Nden la leta ida la geni dom to'a. Muanke' ida ed walia la hande la' inonni tetema de nanienia ulityata-temyata (lepra). La'pa mak kanienia ulityat de namkek tut niana Yesus dewade nwaltiora-nwaltieman la Yesus na'nama nwak la Yesus niwra: “Amee! Mtiulan mai a'u. Agat niohora de Omuodi plolli pa Mhi' kalwied nan a'u, hornama Ompuayow nohora a wakwa'ku, up matro'mu nee!” ");
INSERT INTO lex_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Noma Yesus Nran limni pa Nteman la riy de pa Nakot la: “Arieiniana o wakwakmu pa omkialwied wa!” Mtatande nekpa nnienni de nmolu. ");
INSERT INTO lex_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Noma Yesus Nawewla eda riy de Niwra: “Mlia'awa, mere yana mpuahauria la riy meni-meni. Mere mlia' mliernohora hya' maka Musa ha ne'era-ntatar targ oleka, de mlia'a imam ida, pa mpuak la totpena namkek memna omkialwied olekwa. Me muala limtutnu emeka Musa nwatut tiarg oleka de totpa riy honona rat niohora de omkialwied oleka la nnienmu.” ");
INSERT INTO lex_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mere Nlarna pa naltieri ho'mana, kota la Yesus hihi'ini-yapyapni re yeher to'ama nayapie'er la wniahauru. La' hade pede rirahu rmai totpena ratlin la Yesus wniatutnu me rwak pa Yesus Nhi' kalwieda ir la nnienni-nhienni. ");
INSERT INTO lex_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ne lera dom de Yesus Nla Nsumbain la geni-gen miaka namtiertiernu. ");
INSERT INTO lex_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","La'awa la' lera ida, de Yesus e Nwatutu-nwaye' rer lia gen ida, ne riy Parisi dom rora tungkurga agama re e ramtatan walia la hande. Parisi rora makwatutu-kwaye'a agama re rmai die dom de rwatiawua Yerusalem, dom de rwatiawua leta-let honona mak kden la Yudea, me Galilea. La' ler de de Orgahi-Orha'a plolli-mneheni e npenpuen lia Yesus pa Nhi'a mak kanieni re honona rpa rler la kalwiedni. ");
INSERT INTO lex_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","La' ler de wali pia riy doma rma rodia riy maka kaliu'uta ida de rran nan wut tio'a la u'tani maka nanin la. Riy mak kodia re rwahak talan pa rler la roma ralamni totpena rle'er memna mak kaliu'ut della, la'a Yesus gaini ralamni. ");
INSERT INTO lex_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mere la' ler de de riy rahu rehia, pede edonna rlernan talan pa rodia la'a rialma, pa narieiniande rodia pa rha'at la roma wuwannu na'nama rwaye'er doinia roma ritni. Na'nama ralernu mak kaliu'uta de na'itar neka u'tani totpa nle'era la Yesus gaini raralamni la'a mutu letgarni. ");
INSERT INTO lex_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","La'pa Yesus Namkek tutga riy mak kmai re pesiayni raruri, noma Yesus Nakot la riy de Niwra: “Hyalia, dodo'ondi A'umou-uwitn olek o do'omu-halmu!” ");
INSERT INTO lex_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dewade makwatutu-kwaye'a agama rora riy Parisi rwarora-rwalai la ralamni riwra: “He' eda riy dina de pede Enparan pia Enaltier emkade pa Napolu-naliella Uplerlawna?! Yoma atiaru Uplerlawna nanpena Namou-nawitna rira do'oni-halli.” ");
INSERT INTO lex_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mere Yesus Natg oleka hya' ed maka ha ratiana re pede Nakot la re Niwra: “Ee, hya' ed mak kariei pia mimpiarora-mpialai yatiana rena?! ");
INSERT INTO lex_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","La'pa plet pa A'ukot nek la e'a giwra e do'oni-halli ramou-rawitn oleka de, miplin niohor ma'ta plollola pa e do'oni-halli ramou-rawitn oleka me edonna, mere la'pa Apuaran pia A'ukot la e' pa namat pa nala'awa de mimiat niohor memna A ru'ru-la'yu etla yoma mimkek nan memna. ");
INSERT INTO lex_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pede hota la' dodo'ondi de Agiwra tiut muemna tiy miy, la'a noh di wawannu, de Rimormiori A'nani A'g ed mak kodi plolli pa umou-uwitna riy do'oni-halli.” Noma Yesus Nakot la mak kaliu'ut de Niwra: “Hyalia, mumat doin la pa mpuopna u'tamu de pa mlia'awa rommu.” ");
INSERT INTO lex_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mtatande nekpa riy de namat doin la'a riy mutlialawna re gaini ralamni pa npopna u'tani dewade nla'awa la roma nayanni. Ntiy die na'uli-nawed reri Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ne riy honona la hande mana rwer rer wiawni, ne ra'uli-rawedia Uplerlawna la' genni-tienni Ilyamou-Watyatoha. Noma ramta'at pa riwra: “It edonna tamkek ma'ta hihi'a-yapyapi maka itamkeka la' ler di!” ");
INSERT INTO lex_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","La'pa Yesus Nlergot wa noma Namkek nana mak kawoka blastena id de nanni Lewi. La' ler de de Lewi e namtatan la gen miaka nhi'inde enawoka blasten la. Noma Yesus Npol lia Niwra: “E! Mua mliernohor A'g ee!” ");
INSERT INTO lex_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Noma Lewi naltarga re'eni-tniarnu honona na'nama nlernohora Yesus. ");
INSERT INTO lex_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","La'pa nhorwua noma Lewi nhi'a ya'anlawna-yemunlawna pa rora Yesus ra'an wutu. Maka nhi'inde kawoka blastena re liawanni rmai wial pia rora riy rahu mak kden la hande rawok pa ra'ana-remun rewre'wa la hande. ");
INSERT INTO lex_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Mere riy Parisi makla' makwatutu-kwaye'a agama ror wutga Parisi doma ramkek nana Yesus hihi'ini-yapyapni de pa rwaror la ralamni de mehra rehia pede rpolliohora maklernohor reria Yesus riwra: “Oi! Nihya'pa miy hononmi miora maka kawoka blastena ror wutga riy mak khi' do'a-kyap hiala doma mi'in wutu-miemun wutu?!” ");
INSERT INTO lex_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Noma Yesus Nakot la re Niwra: “Mak edonna kanieni edonna rma rahaka dokter. Eneknek to'a makamehra nanpena ed mak kwahaka dokter. ");
INSERT INTO lex_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Amuai die A'g edonna mua puolga riy mak kiwra irakleha do'a-hala, mere Amuai di totpa Apuolga riy dodo'a-halala pa rhoitio'or doini do'oni-halli re.” ");
INSERT INTO lex_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Noma riy Parisi re rakot la Yesus riwra: “Maklernohora Yohansi ror maklernohor riy Parisi la' lera dom de ratahan lara me rsumbaini. Mere maklernohor reri O'a re ra'ana-remun to'owa.” ");
INSERT INTO lex_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Noma Yesus Nakot la re Niwra: “A' di de emeknekama muanke'a mak kiwra kmehlima. Riy maka rpol niana-rwak nana pa ra'ana la yawoka-yale'u la mehlima-marya'a, de hota edonna ratahan lara mere ra'ana-remnu ramuki-rahepru. ");
INSERT INTO lex_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mere hota la'pa nte'ela la' lerni, nanpena ira'ala muanke'a maka kmehlim della mak ka'an wutu re onni. La' ler de nampena iratahan lara.” ");
INSERT INTO lex_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Dewade Yesus Nwahaur nohora yawalliohora id owa'an la ira, Niwra: “Riy edonna rga' pua rlihira kokanan warwuaru pa ra rtapla la rain mak kawniali. Yoma rweyat oleka kokanan warwuar die. Me kokanan warwuar die la'pa rlowan wutga la pola-rain mak kawniali de hota nmeh'a namemieheiya. ");
INSERT INTO lex_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Emkade wal lia riy edonna rga' pua rhuria anggur tur warwuarnu la'a ha ulit mak mahnek oleka. Yoma anggur tur warwuarnu de hota nhi' nana ha ulit mahnek de ema reye'era pa anggur tur de rhur dioinia ne ha ulit de ho'mana ta'en niana rnair owa'ana. ");
INSERT INTO lex_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Anggur tur warwuaru de rhuria la ha ulit warwuaru. ");
INSERT INTO lex_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ne riy honona mak nhi'inde remun anggur tur mak gakmu de rahmena remun owa'ana anggur warwuaru yoma rwarora de mak gakmu ed mak samomuou rehi. ");
INSERT INTO lex_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","La lera id la' Sabat lerni, de Yesus Nora maka ha Nwatutu-nwaye'a re rala'a la nhyi' wetra' lawna ida ralamni, noma maka ha Nwatutu-nwaye'a re rkura wetra' lawna unnu-unnu pa rwakliaria la limni na'nama ra'ana. ");
INSERT INTO lex_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Noma riy Parisi dom mak kden la hande rakot la riwra: “Hoi! Nihya'pa mpiera-mdiaitia it agamni deullu-tatarni yoma miy e mkiar lia'a Sabat lerni?!” ");
INSERT INTO lex_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Noma Yesus Nakot la re Niwra: “Miy mpiaik nan olek la'a hya' maka Daud nhi'a la' lera e nora e talanwalli re raplara toh?! ");
INSERT INTO lex_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Enler la Uplerlawna roma kreini na'nama na'ala rot miaka ha ral oleka la Uplerlawna, na'nama na'ana. Nhor nia'nama nal walia roti rella' mutu korni pa ra'an wal lia. Mere la'pa deulu-tatra agama, de mak ka'ana roti re de eneknek to'a imam-imam rmeh'a. ");
INSERT INTO lex_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A'ukot hari honona yoma la'a Rimormiori A'nani A' die, A'g ed mak kodi plolli pa A'ukot nohora hya' ed mak kaplola onde nhala pa itsi'a la Sabat lerni.” ");
INSERT INTO lex_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","La lera id la' Sabat lerni id to' wali, ne Yesus la Nwatutu-nwaye'ela' gen miaka nhi'inde Yahudi rhi'a kreini-iskolli. La' noma Namkek nana riy ida etla hande de limni walli malganna nmati. ");
INSERT INTO lex_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tungkurga agama dom rora riy Parisi riwra rahaka kahelli-kaha'arni la' Yesus totpena Nhi' de rodia la letgara lawawna (hakim). Pede honona rkil rer lia hota Nhi' kalwieda makamehra-kamau la Sabat lerni me edonna? ");
INSERT INTO lex_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mere la'a ira wniarorni-wnialaini re, de Yesus Natg oleka re! Dewade Yesus Nakot la riy maka limni walli kmat die Niwra: “Ee! Muprir pia mua mtiutrier lia riy honona gaini ralamni!” Noma riy de naprir pia nma ntutrier lia hande. ");
INSERT INTO lex_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nhor nia'nama Yesus Nakot la riy mak kden la' hande Niwra: “Hota A'utian tek miy, la'a agama deullu-tatarni de rakot targa hota it tsi'a hya'a la Sabat lerni? Hota it tsi'a samomuounu me onde tsi'a yatyatni? Tamori-talewna rimormior me onde twaror nohora wniunu-wnienna la it rimormior wialli?” ");
INSERT INTO lex_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nhor nia'nama Yesus Namkek la riy nenenan gaini ne Nakot la riy de Niwra: “Mpuetar limmu!” Noma riy de nwetar limni, dewade mtatande nekpa nnienni nmolu. ");
INSERT INTO lex_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mere, yeher to'ama makwatutu-kwaye'a agama re rora riy Parisi re humra-kailia la yawenna, ne rawok pa rna'ohma Yesus la' yatyatni wa. ");
INSERT INTO lex_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","La'awa ler id de noma Yesus Nafia'at la wo'ora id hananni pa Nsumbaini. La' mel tetem de Ensumbain nek la Uplerlawna pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nsumbain nekpa la'pa repra rauria, noma Npol lia maka klernohor reri re na'nama Nwaliri-nwalioh nana riy termida wehrani woru la' hare honona. Noma Npolga hare la Mak Ha Nwalir niana pa rodia Uplerlawna lirni-tunnu. La' hare honona nanni de erti la: ");
INSERT INTO lex_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, mak Yesus Nal walia nanni Petrus, me Simon hyalli de Andarias. Nwalir walia Yakowsi me Yohansi, Pilipsu, me Bartolomeus, ");
INSERT INTO lex_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matius, me Tomsa, Yakowsi, de Alpius a'nani, me Simon maka ha rweta la riy mak kwayotil memna hairi Romawi rodi plolli la Israel, ");
INSERT INTO lex_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","la'pa Yudas, de Yakowsi a'nani, me Yudas Iskariot, maka na'olga Yesus. ");
INSERT INTO lex_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nhorwua noma Yesus Nora makodia E lirni-tunnu re rerun rewre'wa pa rtutrier lia la'a mtatanni ida. La' hande mana rirahu maklernohor reria liawanni er wal lia me rira liawanni mak kwatiawua meni-meni to'a, la'a Yudea liewnu, Yerusalem, me la leta-let mak kden la Tirus me Sidon la eni wawannu. ");
INSERT INTO lex_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Honona rmai totpena ratlin la Yesus me totpena nnienni re mana Yesus Nhi' kalwied walia. Me la'a riy meni maka hegana-kawnu, yatni-rha'ani rhu'ru ralma mana Yesus Nhokar doinia la. ");
INSERT INTO lex_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Riy honona rahak pa rho'a-rhaiya Yesus, yoma la' inonni de e Nodialgota plola-mneha pa Nhi' kalwieda ir honona. ");
INSERT INTO lex_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus Nlina-nmata maka ha Nwatutu-nwaye'a re noma Nakot la re Niwra: “Hyal miy re, hota unut lawna la'a miy mak kler la kleha-lara, yoma miy di de mrie' teman la Uplerlawna horatni-hairni limni-rorni maka Enodi plolli la emeka Ray. ");
INSERT INTO lex_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Hyal miy re, hota unut lawna la'a miy miak kakleha-kaplara, yoma hota mliernana penpuenu-tetema la'a Uplerlawna pa ralammi namtiernu! Hota unut lawna la mak ko'a-khera miy de yoma hota Uplerlawna Nal miy pia mimlier la he'i-hepru. ");
INSERT INTO lex_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Hyal miy re, hota mlier la unut lawna yoma riy rahankeran tiy miy, rwayotil miy, riy rahe'i-ramal miy, onde rapupu-raher miy, yoma la' Rimormior A'nani A rerie'yu. ");
INSERT INTO lex_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Yoma la' ululu nek de Yahudi upni-tgarni rhi' emkade wali la makwohorulu-ktatrulu. Pede la'pa hihi'a-yapyapi re rodi liarni pa mimliernan walia, de yana ralammi rmawla, mere mlioi-mhiek nohora he'emi-heparmi, yoma miy siepmi-kaimi inpona la'a Ilyamou-Watyatoha (Sorga) maka hota Orgahi-Orha'a Nala tiy miy. ");
INSERT INTO lex_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mere makre'a-ktaru miy lia' dodo'ondi, de hota mimlier la yatyatni-halalli yatlorni-yatra'ani, yoma mimliernan oleka rehenu lawanni. ");
INSERT INTO lex_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mak kler la ya'an penpuenu-tetema la' dodo'ondi de hota mlier la yatyatni-halalli yatlorni-yatra'ani yoma rehka-lara. Miy maka kahepuepru la dodo'ondi de hota mlier la yatyatni-halalli yatlorni-yatra'ani, yoma hota mlier la ralam mawla, ne koko'a-kakakarmi. ");
INSERT INTO lex_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","La'pa rirahu ra'uli miy, de hota mlier la yatyatni-halalli yatlorni-yatra'ani, yoma emkade walia, la ululu de miy upmi-tgarmi ra'uli makwohorulu-ktatrulu putputra-palpalka.” ");
INSERT INTO lex_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mere la'pa mak katlin la A lia dodo'ondi, de mitlina A nnio'u di! Hota mira'a-mipalga miy arwalmi me mhi' samomuoga riy maka kahankeran rer tiy miy. ");
INSERT INTO lex_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mpiak la Uplerlawna pa Ntera-ndema maka klokra-khaut miy me msiumbainia riy maka khi' yatyat miy. ");
INSERT INTO lex_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","La'pa riy rpahara kilmi malganna, de miala kilmi walli malwiru pa npahar walia. La'pa rwak nana miy raini plalahwami de miolin doin walia rain rialammi pa ra' wal lia. ");
INSERT INTO lex_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","La'pa riy rwak hadom tiy miy, de miala la, ne la'pa rwarui miy gahami, de yana mpiak neka wa. ");
INSERT INTO lex_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mhi' samomuou rira de emekwalima mimiwra irhi' samomuou tiy miy. ");
INSERT INTO lex_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yoma la'pa mira'a-mipalga, mtiulla-msiayn to'a maka nhi'inde kara'a-kapalga, ktulla-ksayn miy de hota Uplerlawna edonna Na'uli-nawedi miy. Riy maka khi' do'a-hala nek de rara'a-rapalu, rtulla-rsayn walia riy maka kara'a-kapalga, ktulla-ksayni ira toh! ");
INSERT INTO lex_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne la'pa mimhi' samomuounu to'ola riy maka khi' samomuou tiy miy, de hota Uplerlawna edonna Na'uli-nawedi miy. Riy mak khi'a do'a-hala nek de rhi' samomuou wal lia mutwualli toh! ");
INSERT INTO lex_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne la'pa mimial to'a kupan la' riy maka ka'otan pa hota nhernia, de hota Uplerlawna edonna Na'uli-nawedi miy. Riy maka khi' do'a-hala nek de nal walia kupan pa mutwualli ra'otna, nanpena nwak owa'an nhierannu la! ");
INSERT INTO lex_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mere rwaldioinia de, miatu mira'a-mipalga miy arwalmi ne mhi' kalwiedweda re. Mialla ra'otna me miy edon mpiaror nana hota nherni owa'ana. Yoma la'pa emkade, de hota miy siepmi-kaimi inponni ne hota mtiutga la ilmi-wniehwami de Uplerlawna mak kden la tutullu-lolo'oni, upni-a'nani miy. Yoma Uplerlawan de Ntutga ralam kalwiedni la riy maka kaplinu kwak kalwieda la E'a me la' walia riy yatyatni. ");
INSERT INTO lex_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pede mhi'a nhioli-lieta kalwiedwed la'a rimormior wialmi pa emekwalima Uplerlawna, miy Amlawanmi de mak kden la Ilyamou-Watyatoha Nden rer lia kalwiedwedni.” ");
INSERT INTO lex_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Yana plet pa mpiaghala rimormior wialmi totpena Uplerlawna mana edonna Nhudi-npar miy. Yana mtio'on reria riy la do'a-hala wawna totpena Uplerlawna mana yana Nto'on wali miy! Mere mhioratdoinia rira do'oni-halli tiy miy totpena miy miana, Uplerlawna Namou-nawitna miy la do'omi-halmi. ");
INSERT INTO lex_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mialla' rira totpena Uplerlawna mana Nal tiy miy de narehi-nalawna. Hota rtailia penpuenu tetem oleka miy gahami wa, yoma tatiaili maka ha mniairi pa ma mtiail pa mialla rira, de hota Uplerlawna na Ntail pa Nala tiy miy.” ");
INSERT INTO lex_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nhorwua noma Yesus Nakot nohor owa'ana yawalliohora id owa'an la ira totpena yana plet pa rwaghal rimormior wialli, Niwra: “La'pa mak matni kyata ida ni'it la mat yat walli, de hota nahmenmen nanama, rora rewre'wa pa rtuin la hu'ula ralamni. ");
INSERT INTO lex_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A'n iskola edonna nareh dioin tungkurnu. Mere la'pa a'n iskol de nhi' ahorga iskolli de hota emekwalima e tungkurnu. ");
INSERT INTO lex_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hya' mak karei pia mpiaghala mutwualmi onnila do'oni-halli mak edon kwerta mere miy do'omi-halmi nekane lawan rehia. La'pa mhi' emkade, de emekwalima mimkek nana ai liu'wu mak kdella mutwualmi de matni ralamni, ne ai dieulu naniewat la miy mat wamueheni ralamni mere miy edonna mimkek nana. ");
INSERT INTO lex_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ralma-riormi emkameni pa mikot la mutwualmi miwra: “Mai pia agal doinia ai liu'wu mak kden la o matmu de,” mere miy orgahami miplin niek la ai dieulu de e naniewat la miy matni mere miy edon mimkek nana?! Hoi! Yana mtiota miy inonmi la riy kalwiedweda mere plollolli de riy yatyat miy. Milgot ulga ai dieulu mak kden la miy matmi de totpena mimkek samomuoga ai liu'wu mak kden la mutwualmi de matni pa milgota.” ");
INSERT INTO lex_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Au muaka kpoti-kadwu de edonna nawo'a wo' kilta-watra me emkade walia au muaka khoptutu-khoplera, edonna na'unu-nayeh nohora wo' samomuou. ");
INSERT INTO lex_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","La'pa tlernana au id wo'oni de itat niohor oleka ha onni wa. Edonna rlernana kar wo'a la' au rururi-karkiarti ralamni, me edonna rlernan walia lokrah wio'a la'a ruwnu-penta ralamni. ");
INSERT INTO lex_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Hota emkade walia riy maka ralamni kalwieda-paitiota, de hota ntutga nhioli-lieta kalwieda-paitiota yoma ihranu ralamni npenpuenu tetema la kalwieda-paitiota. Ne riy yatyata-halala nampena nodgiota nhioli-lieta yatyata yoma yatyatni-halalli nagengen lia e'a. Yoma la'a hya' maka klergot la it nurnu de ha nwatiawua it ihranu ralamni.” ");
INSERT INTO lex_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nihya'pa mimpiolga A' die: “Matroma, Matroma!” Mere miy edonna mliernohora hya' ed maka A'ukota tiy miy?! ");
INSERT INTO lex_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Hota Agala yawalliohora id pa A'ukot nohora riy mak kmai A'u re, ne la'pa ratlina A li'ru de rlernohor reria. ");
INSERT INTO lex_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Maklernohor reri A li'ru re, de emekwalima riy mak hota kariria roma de nahia kdieldelma, na'nama nwatatga la watu wawannu. Pa la'pa gera nwau me ger wawuau liawna nwayotil la rom de, de edonna nwo'la-nwaini, yoma e rwatatga la watu wawannu. ");
INSERT INTO lex_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mere riy maka katlina A li'ru-tu'nu ne edonna nlernohora, de emekwalia riy maka kariria romni de edonna e rwatatga la watu wawannu, pede la'pa ger wawuau liawna nwayotil la roma de nleretniekla napru'wu la yawa ne pala patia!” ");
INSERT INTO lex_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","La'pa Nwatia lirni la'a hya' maka Ha Nakot nohora la'a riy harahu re, dewade Yesus Nla'awa la leta Kapernaum. ");
INSERT INTO lex_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","La' hande de, de riy ida makhi' o'ta-mat la makodi keki-rautu Roma rahu ida. Riy de lili'irnu-hopopanni maka nhi'inde ha nsayni ida e namehra werwerta. ");
INSERT INTO lex_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","La'pa makodi keki-rautu o'tani de natlin nan de Yesus etla hande, dewade nhopna Yahudi in letni-am letni wo'ir pa rla rpolga Yesus totpena Nmai pia Nhi' kalwieda e hopopanni de. ");
INSERT INTO lex_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","La'pa rte'ela Yesus de noma rhu'ru-rhelam pa rwak toto' meman la Yesus totpa Nla Ntulan la makodi keki-rautu o'tani de. Rakot la Yesus riwra: “Amee! Hota lol talanni pa Mtiulan la makodi keki-rautu o'tani de yoma riy samomuou e'a! ");
INSERT INTO lex_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yoma hade ed maka khi' samomuoga it luwnu-a'nani ne nariria roma id maka itsi' krei-iskola.” ");
INSERT INTO lex_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pede Yesus Nor rewre'wa re pa rla'awa. La'pa Yesus Nhi' pa Nwakrian lia rom de, noma makodi keki-rautu o'tani de nhopan doinia e mutwualli rla' rwatroma pa ratutga Yesus totpa yana Yesus Nla'a makodi keki-rautu o'tani romni de. Makodi keki-rautu o'tani lirni de emkadilla Yesus: “Tuna, yana miodi liarmu la a ro'mu nayanni yoma a'g edon lia' nana Tuna lewatni pa Tuna Nmai lia a ro'mu nayanni. ");
INSERT INTO lex_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","La' hade pede a'u mana edon puaran pia ama wuatrom Tuna. Pen neka Tuna Nden nek la handi mere Nodi plolli pa Nhopna a hopopnu de nkalwieda la roma nayanni. ");
INSERT INTO lex_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yoma a' niek de utlin la mak kodi plolli mai a'u. Ne la'a a tniornu de ratlin mai a'u. Aghopan pa makodi keki-rautu ida nla'awa de hota nler pa nla'awa. Apuolga dom de, hota rmai. Ne la' walia aghopan pa a hopopnu de nhi' hya' to'a de hota nlernohora.” ");
INSERT INTO lex_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","La'pa Yesus Natlin ha lirni de Yesus mana Nwer rer wiawni yoma makodi keki-rautu o'tani pesiayni de. Noma Nkillia mak kden hande honona mak klernohor reria na'nama Nakot la Niwra: “Ina-nara ama-hyali, riy di de riy Israel atia'a id walia di me! Mpiesiaya! La'a riy Israel re honona nekane A'g edonna liernan ma'ta riy maka pesiayni naruri emeka riy mak Israel atia' di!” ");
INSERT INTO lex_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","La'pa mak ha rhopna re rawali owa'an la makodi keki-rautu o'tani romni de li'iru-hopopan de mana nkalwied olekwa. ");
INSERT INTO lex_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","La'pa edonna nalo'on wali ne Yesus Nora maka ha Nwatutu-nwaye'a re, me riy rahu wal pia ror rewre'wa Yesus pa rokria leta Nain. ");
INSERT INTO lex_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","La'pa Yesus Nhi' pa Nte'ela letlawna puohrani onni de rwatrom nan neka riy rakwar nana loi mati pa rlergot wal lia puohra leta. Matia maka ha riwra rla rtamin de, de patyata ida a'nani muanke'a memeh'a inhatta toto'a. Rira liawanni mak kden la let de, rlernohor reria patyat de. ");
INSERT INTO lex_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","La'pa Itmatromni Yesus Namkek tutga patke' de dewade Yesus ralamni nmolu-nhelam doin la pa nakot la Niwra: “Yana Nkakru ina!” ");
INSERT INTO lex_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","La' noma Yesus Nla Nwakriania mak kgolan mati re na'nama Nteman la loi miat die, dewade mak kgolan mati re mana rtut tiaru. Dewade Niwra: “Hei! Tuwari-lawe'ru nee, A'g e umat o'a!” ");
INSERT INTO lex_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Dewade plin-plinnianamde tuwari-lawer muaka kmati olekwa de namat pa namtatna ne nwahaur wa. Noma Yesus Nakot la inni Niwra: “Ina, o a'namu nmori oleka di pa muodi mlia'awa!” ");
INSERT INTO lex_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Riy honona mak kden la hande ramta'at wenna ne rleretniekla ra'uli-rawedia Uplerlawna. Noma idma nakot la ida riwra: “Hadi de makwohorulu-ktatrulu inponni id hadi, pa Nhari oleka inonni mai it wa! Ee! Uplerlawna Ntutg olek plolli-mneheni pa Ntulan la mutnu-rahanu it wa.” ");
INSERT INTO lex_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Rakot nohora Yesus hihi'ini-yapyapni la Yudea uhunu-ewatni-lahwani me nodi liarni la' geni-tien mak kden la hande pa lolda-lolda. ");
INSERT INTO lex_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Maklernohor reria Yohansi rma rakot la Yohansi la'a hya' maka Yesus Nhi'a-nyapia. ");
INSERT INTO lex_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Noma Yohansi nhopan doinia riy wor pua rla ratian nohora Itmatromni Yesus. E' de maka Uplerlawna Nano'taru onde rwei mia'ta riy dom to'a? ");
INSERT INTO lex_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Noma rla' pa rlernohora Yohansi lirni pa riwra: “Tuna, Yohansi makharani nhopna ama matian O'a, de O' di ed maka Uplerlawna Nano'targa O maimiaimu? Me yanpa maka ampei-mnara de riy dom to'a?” ");
INSERT INTO lex_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","La' ler de, de Yesus e Nhi' kalwieda rirahu mak kanieni-kahniena mak kamehra-kamau, me Nhokar doinia yatni-rha'ani la' riy me Nhi'a rirahu matni mak kyata pa ramkek owa'ana. ");
INSERT INTO lex_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pede Yesus Nwalolla mak ha rhopan doinia Niwra: “Hyal miy re, miwali owa'an la Yohansi pa mpiahaur nohora la'a hya' ed maka mitlin me mimkeka, de riy maka matni kyata ramkeka, maka lakni nmati rala'awa, maka ulatni temni yata rkalwied wa, maka hatilu mana ratlina, mak kmati olekwa mana rmori owa'ana, me Kot Kalwieda-Paitiota mak kwatiawua Uplerlawna mana rakot nohora la maka kakleha-kaplara. ");
INSERT INTO lex_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ne la'pa riy honona mak edonna kwayotli A'u, mere npesiay niek wa, hota rlernana unut lawna.” ");
INSERT INTO lex_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nhorwua noma maka Yohansi nhopna re rawal wia, noma Yesus Nwahaur nohora Yohansi la'a riy rahu mak kden hande. Yesus Niwra: “La' ler ululu de miy e mlia'a wo'orletna-kawurloini totpena mimkeka hya'a? Mpiahaka riy id maka o'tani wolwo'la pa emeknekama wewna lihira maka anni ha nten dioinia rena? ");
INSERT INTO lex_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mlia' de mpiahaka hya'a pa mimkeka? Mpiahaka riy ida maka naniairi samomuounu me nmori-ndar niohora re'eni-tniarnu? Riy mak emkare, ha rden la tuna ray romni-lewnu! ");
INSERT INTO lex_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pede mlia' de mpiahaka hya' pa mimkeka? Mlia' pa mpiahaka makwohorulu-ktatrulu ida toh?! Ha naplola. Ne hota Yohansi nek de nareh dioinia makwohorulu-ktatrulu re. ");
INSERT INTO lex_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yoma la' Puka ralamni, de Uplerlawna Nakot nohora Yohansi kniarni, Niwra: “Mhioratreria! Hadi ed maka Aghopna. Hota Aghopna hade pa nala' ulg O'a totpena nwahyar tialan pa Omliola.” ");
INSERT INTO lex_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mhioratreria! La' ululu la'pa ntutu-nte'ela ler di la' nohkeran di wawannu de riy id mana edonna nareh dioinia Yohansi makharani. Mere la'pa la' lera-mela ri, maka Uplerlawna Nodi plolli pa emeka Ray de, E mutnu-rahanu mak kakleha weli id ho'mana nlernan yara'a-yapalu nareh dioinia maka Yohansi nlernana.” ");
INSERT INTO lex_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Riy harahu re la'pa ratlin nana Yesus lirni de ir er maka kreiniana Uplerlawna lirni-tunnu. Mak kawoka blastena nekane rreinian walia. Ir honona rreiniana yoma ir er maka Yohansi nharania re la' ler ululu! ");
INSERT INTO lex_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mere riy Parisi rora makwatutu-kwaye'a agama rahmena-rapraiya Uplerlawna wniarorni-wnialaini la'a ir inonni. Yoma ir er maka rahal olek inonni la Yohansi yanpa nharania ira. ");
INSERT INTO lex_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Noma Yesus Nakot owa'ana Niwra: “Hota Agala yawalliohora hya' pa ga' ukot nohora rimormiori mak edon kpesiay A'u la lera-mela rina? ");
INSERT INTO lex_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ir de emolmolla keke'enku'a woka id mak kamtatna la'a ya'olgeni pa rpol lia wokni handina yoma idma edonna nlernohora id lirni, pede riwra: “Amnairi floiti me tiwla-prai pa amahe'i-mahepur nohor miy mere miy edonna mlioi-mhieka! Ampahniar nohor miy la'a nhiara matmiati-molmuolu mere miy edon mkio'a-mkiakru!” ");
INSERT INTO lex_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Hade emekwali Yohansi makharani nmai die noma natahan lara (puasa). Me edonna nemni anggur turnu. Ne mimiwra hegana e nhu'ru ralma. ");
INSERT INTO lex_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Noma dodo'ondi Rimormior A'na A' Muai die, de A'una-gemnu. Noma mikot la mai a'u miwra: “Tamkek to'ola hade. Ya'ante'eni, ne ma'wanu de, pa la' nor wutga mak kawoka blastena me riy yatyata-halala rwatamputu.” ");
INSERT INTO lex_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mere la'pa miy mpiayotlia Agora Yohansi hihi'ini-yapyapni ho'mana Uplerlawna kirkirni-ralma-rior samomuounu mak amlernohora de hota nayamkek la riy mak klernohora A wniatut mamni re nhiolli-lietni ilu-wniehwani samomuounu.” ");
INSERT INTO lex_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Lera ida ne Simon, riy Parisi ida, npolu-nwaka Yesus pa Nma pa ra'an rewre'wa. Noma Yesus Nla'a Simon romni nayanni pa rawok pa ra'ana-remun wutu. ");
INSERT INTO lex_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","La'a let de, de patke' yatyata ida nhol wial lia hande. La'pa patke' de natlin tutga Yesus entepartarlia ya'ana-yemnu la'a riy Parisi die romni nayanni, noma nmai die nod miemna wu'ru hup mikmikri la'a potla id ralamni mak ha rhi' nana la watu-watu mak welli werta. ");
INSERT INTO lex_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nmai nioma ntutrier lia Yesus to'orni la' lakni onni na'nama nko'a-nkakur pa luini-nuhranu nape'era-napahia Yesus lakni, noma nala moratnu na naha kerna luini-nuhranu della Yesus lakni nhorwua noma nkinnia na'nama nhuria wu'ru della. ");
INSERT INTO lex_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","La'pa riy Parisi mak kpolu-kwaka Yesus ramkek nana patke' de hihi'ini-yapyapni de noma nwaror la ralamni niwra: “La'pa Yesus de plol toto'a makwohorulu-ktatrulu id hade, de hota Natg oleka patke' meni ed maka kheik la E de! Yoma patke' yatyata ida de.” ");
INSERT INTO lex_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Noma Yesus Nakot la Simon Niwra: “Simon, A'g e giwra ukot hadom tiy o'a.” Noma Simon niwra: “Mukota tungkurga!” ");
INSERT INTO lex_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Dewade Yesus Nakot la Niwra: “Riy worga e ra'otan kupan la'a riy ida. Riy id e na'otna kupna-kai (gaji) la lera rahu wolima gahani, ne mutwualli de na'otan walia kupna-kai la lera terampwolima gahani. ");
INSERT INTO lex_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","La'pa nte'ela lerni maka ha rakot taru pa rpolla kupna re noma edonna rpolan nana yoma rakleh kupan wa. Mere orgahi edonna nto'ona ne nleretniekla nhap dioinia otanni re. Pede ompuaror teka! Hota hameni ed maka ralamni etla riy maka kal otan kupna rena?” ");
INSERT INTO lex_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Noma Simona nwet la niwra: “La' a wniaro'ru de, mak ralamni etla riy de wa de mak ka'otna kupna liawanni.” Noma Yesus Niwra: “O ralma-riormu plola!” ");
INSERT INTO lex_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Dewade Yesus Nkillia pat de, na'nama nakot la Simon Niwra: “Mumkek to'ola patke' de, Simona. Ompuak pa Amuai, mere o edonna mpuahi' ger dom pa Agalla wuri-gohma A la'ku pa emeknekama nhi'inde itsi' nana, mere pat di nala luini-nuhranu na nohma A la'ku ne nala moratnu na naha kerna. ");
INSERT INTO lex_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dodo'ona Amuai die, o' edonna mkinni A'u pa mpuak kalwieda mai A'u pa emeknekama nhi'inde itsi' nana. Mere pat di nkinin la'a-mai A la'ku la' dodo'on memna. ");
INSERT INTO lex_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","O edonna mhu'ru-mhuelam la mai A lia muala wu'ru dom pa ma muneg A'u, mere pat di nhuri oleka wu'ru hup mikmikri la' A la'ku. ");
INSERT INTO lex_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pede, ompuesiaya, plola la hade nhiolli-lietni kalwiedwed de mai A'u, ntutga de do'oni-halli mutliawanni re ramou-rawitna olekwa! Yoma hota la'pa rira do'oni-halli oke'a nmeh'a noma rhap dioinia de hota riy die ntutga ralam kalwieda oke'a nmeh'a. Mere la'pa rira do'oni-halli mutliawanni re e ramou-rawitna, de riy de ntutga ralam kalwiedwed meman wa.” ");
INSERT INTO lex_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Noma Yesus Nakot la pat de Niwra: “Ina, o' do'omu-halmu ramou-rawitna momuog oleka wa.” ");
INSERT INTO lex_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Dewade riy honona mak ka'an wut lia Yesus la hande idma nakot la ida riwra: “Hota he' eda riy di pede Nparan pia Niwra Namou-nawitna do'a-halo?” ");
INSERT INTO lex_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mere Yesus Nakot la patke' de Niwra: “Yoma la o pesiaymu mai A'u ina, pede omlier olek la mormiori-lewlewna. Mlier olek la kalwiedni-paitiotni pa mlia'awa!” ");
INSERT INTO lex_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Noma la la'pa Yesus Nokria leta-ruhuna re, pa Nakot nohora Uplerlawna Kot Kalwiedni-Paitiotni, Niwra Uplerlawna hota Nodi plolli emekneka Ray. Ne maka Yesus ha Nwatutu-nwaye'a riy termida wehrani woru re, ror rewre'wa E' talla. ");
INSERT INTO lex_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Emkade walia la'a patke' dom maka Yesus Nhi' kalwied oleka la yatni-rha'ani ha rhu'ru ralma, me mak kler la nnieni-nhiena korni, pa rkalwied olekwa. Patke' mak kler nohor reria de Maria maka nhi'inde ha rpol wualia la Magdalena, maka Yesus Nhokar doinia yatni-rha'ani wo'itu la inonni, ");
INSERT INTO lex_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","me Yohana, Khusa makla' o'tani la mak kar lia ray Herodes nhiol genni, hawni de, me Susan, ror wut wualia patke' liawanni dom pali. Rlernohor Yesus de rnairia kupna-kai wamueheni pa ra rhima-rre' nohora Yesus Nora maka ha Nwatutu-nwaye'a re. ");
INSERT INTO lex_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Rira liawanni rwatiawua leta-leta re rapur pa rma rahaka Yesus. Ne la'pa rawok taru, na'nama Yesus Nakot nohora yawalliohor dilla, Niwra: ");
INSERT INTO lex_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mak kanhyi'a-katlunni ida nla' pa nrinnia winni-hgonni la nhyi'ini. La'pa nrinnia wini-hgona re dom de rtuin la talla ralamni. Pa wini die riy rhapar nana, dewade onu-ma'nu rmai pia rtotan nan momuoga. ");
INSERT INTO lex_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ne la' dom de rtuin la watwuatnu pa la'pa rmor die nleretniekla rapliau yoma tani pahna. ");
INSERT INTO lex_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","La' walia dom de rtuin tar lia pu'na-kiarti ralamni pede rmor riewre'wa wut lia pa narieiniande idma natolaw wenwen ida pede ta'en niana rmori plollola. ");
INSERT INTO lex_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mere dom de rtuin la tan ihi pa rmor die rpoti-rkadwu me ra'unu-rayeh nohora wo'oni rahg ida.” La'pa Nakot nohora yawalliohor de pa nhorwua noma Yesus Nakot owa'an la Niwra: “La'pa miy tlinmi erla de, mitlin reri!” ");
INSERT INTO lex_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Maka Yesus ha Nwatutu-nwaye'a re ratiana riwra: “Tuna, la' yawalliohora di nnia'eratni de emkame?” ");
INSERT INTO lex_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Noma Yesus Niwra: “Uplerlawna Nhu'ula tlinmi-nwe'er matmi totpena miat niohora la hya' ed maka riy raplin niohor ma'ta la'a Uplerlawna tnioranni-riautnu. Mere rala yawalliohora ra rwatutga riy mak kakleha pesiay, totpena: “Hota iramkek reria, mere emkade ho'mana edonna rna'erit nana hota hya' ed maka ha ramkeka, hota iratlin reria mere emkade ho'mana raplinu-raplo' nohora.”” ");
INSERT INTO lex_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Mere la'a yawalliohora de nnia'eratni de emkadilla: Wini-hgona, de Uplerlawna lirni-tunnu irhatta. ");
INSERT INTO lex_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Wini-hgon maka ktuin la talla ralamni de emekwalima mak katlin oleka lira-tun diewa, mere hota hegana amlawanni nmai pia nwarui-nwate'la nana lira-tun diella mak katlin oleka re totpa yana rpesiaya pa hota edonna rlernan walia mormiori-lewlewna. ");
INSERT INTO lex_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mak ktuin la watwuatnu de emeknekama riy maka katlin nana lira kalwiedwed de dewade leretniekla ralamni raplele'er pa rreiniana mere edonna naga'ara la'a ir ihranu ralamni. Rpesiay tio'ola lera ho'ke'eni de to'a, ne la'pa hegana amlawanni nma nta'aga dewade rwaldioinia pa edonna rpesiay owa'ana. ");
INSERT INTO lex_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wini-hgon mak ktuin la ruwnu-ahla pu'na-kiarti de emeknekama riy maka katlin nana lir de, mere ralamni worwuorga yanpa hota e ruk lia re'eni-tniarnu la noha wawannu onde rwaror nohor mamaini la hya' maka ir ralamni nala pa narieiniande ir pesiayni edon la' ga'a, pa emeknekama wini-hgon mak edon rawo' nan walia ha'ola-hawo'a mak kerna-kgatna. ");
INSERT INTO lex_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mere wini-hgona mak ktuin la tan ihi, hota emeknekama riy maka plele'era me kalwiedweda. Iratlin nan Uplerlawna lirni de ne rkenia la ralamni, ne rhi' nohor neka pa rlol kalwiedwedni.” ");
INSERT INTO lex_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Edonna rlernan ma'ta riy rtutin wa'du nanpena rala ktopra ra rkadwua pitpitga, onde rwatatga wa'du della' lewnu nayanni. Wa'du de rkeni hadella la'a wniatatgenni totpena hameni maka kler la roma ralamni de namkek reria lelerni. ");
INSERT INTO lex_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Emkade walia la Uplerlawna lirni-tunnu, yoma E lirni mak kayade'a honona re mana hota nayamkek wa, me mak kayawunmu momuou hota nawnie'era ne nat niohor memna. ");
INSERT INTO lex_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","La' hade pede mpiahniorat la hya'a maka A'ukota ri, yoma la riy mak kiwra kna'erit nana, de hota ra'itr owa'an la wniarorni-wnialaini mere la'pa riy maka kahmena kat niohora Uplerlawna lirni, de hya' mak ha nwarora de enatg oleka de hota Uplerlawna Na' owa'ana.” ");
INSERT INTO lex_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesus inni nora a'nani korni rmai Yesus de, mere ta'en niana rwakriania Yesus yoma riy rahu rehia. ");
INSERT INTO lex_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Noma riy dom de e rakot la Yesus riwra: “Tuna, Tuna inni nora ammu-hyalmu e rtutrier lia tio'ora! E riwra rora O'a rwatroma.” ");
INSERT INTO lex_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Mere Yesus Nnairia yawalliohora pa Nakot nohora pleini la ira. Niwra: “Riy meni maka katlina-katailla Uplerlawna lirni-tunnu, me nlernohora, de ir er maka Aghi'a la A i'nu-na'ru a'mu-hya'lu.” ");
INSERT INTO lex_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","La'pa la'awa lera ida noma Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: “Mai pia todia puou pa tla'awa danau de walli.” Noma honona rha'at la puou pa rla'awa. ");
INSERT INTO lex_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","La' pa rhopopal reri ne Yesus nanin hala. Plinu-plinnianama kakmoran lawna nte'prernia la' danau de, pa yo'orni-ananni nwakloli-nwaklalia puou me yo'or mana rriw lia puou ralamni pa npenpuen lia tah'i. ");
INSERT INTO lex_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Dewade maka Yesus ha Nwatutu-nwaye'a re rla ramat doin Yesus riwra: “Tungkurga ee! Hota itmati!” Dewade Yesus Namat pa Nkamot targa yo'ora-anin lawan de dewade nleretniekla nalina-nalera la'a danau de ralamni. ");
INSERT INTO lex_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Noma Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: “Nihya'pa miy edonna mpiesiay A'u?” Ir honona rwer rer wiawni me ramta'at wenna, noma idma nakot la ida riwra: “Riy di de he'a pede lirni-yatnu natutga yo'ora-anni me yo'ora-anni mana ratlina-ratailla?” ");
INSERT INTO lex_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesus Nora maka ha Nwatutu-nwaye'a re rhopal pa rodi liarni la'a riy Gerasa genni-tienni, la' danau Galilea walli. ");
INSERT INTO lex_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","La'pa Yesus Nerun la keranni, dewade muanke' maka yatni-rha'ani ha rhu'ru ralma ida nma nler temna. Riy de mak kwatiawu leta maka rehgorgor die, mere edonna napola-naraini me nahmena namteman la roma nayanni la mahnek memna. Nhi'inde nhol tio'a hu'ula-liena mak kden la tniamin matgeni. ");
INSERT INTO lex_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","La'pa namkek nana Yesus dewade nhaunu-nhaunu na'nama nwaltiora-nwaltieman la Yesus gaini ralamni na'nama nhaun pa niwra: “Yesus ee! O' de Uplerlawna mak kden la tutullu-lolo'oni A'nani O'a! Hota Omhi' nana a'g emkameni ee! Awuakwak pa yana Mukmua a'u.” ");
INSERT INTO lex_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Riy de Nakot emkade yoma Yesus Nhopan pa nhiw yatni-rha'ani de nlergot la e'a. Yoma nhi'inde nhiw yatni-rha'ani de nma nhu'ru ralma pede riy e rwutu-rkohog e limni-lakni, de rnairia wutwutu mnotna ne yatiaka npitu-nkor la ho'mana, na'ed lia inonni pa nwuhi eti-lahwa re la'a limni-lakni, dewade nhiwa-nhion yatni-rha'ani de nodia la wo'orletna-kawurloini. ");
INSERT INTO lex_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Noma Yesus natiana eda riy de Niwra: “O nanmu he'a?” Noma riy de nwalolla niwra: “A na'nu Legion.” Nanni de nnia'eratni makodi keki-rautu woka liawanni yoma nhiwa-nhion yatni-rha'ani liawanni rler olek la la'a e ihranu ralamni. ");
INSERT INTO lex_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Noma nhiwa-nhion yatni-rha'ani re rwakwak rer lia Yesus totpena Yesus yana Nho'or targ ir la'a hu'ula-liena matmiati-molmuolu mak kodia niukum lalawna pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","La' hande de e rehgorgorga gen miaka wawi wok lawna rwayowar pa rahak pa ra'ana-remun la wo'ora hananni. Noma nhiwa-nhion yatni-rha'ani re rwak lilili-mamuau lia Yesus totpena rhopan nekpa irler la wawi re inonni ralamni. Noma Yesus Nwayowa. ");
INSERT INTO lex_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Dewade rlergot la riy de inonni, pa rla' rhu'ru ralma wawi re, na'nama honona re rawlar pia rla rlererun la weran teti pa ema rwuwul wenwenna la' danau de ralamni. ");
INSERT INTO lex_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mak khuri-kwa'ana wawi re rlina-rmat memna hya' maka wawi re rhi' oleka re wa. Nhor nioka rawlar pia rla rod kiota la'a ir letni me gen miaka rehgorgorga. ");
INSERT INTO lex_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Noma riy rlergot pa rma rpoi-rkeka (ramkeka) hya' maka ha rakota re. Riy rawok la Yesus onni pa ramkek memna riy maka nhiwa-nhion yatni-rha'ani ha rlergot la de, e nawiatur targa la Yesus lakni onni pa natlin rer lia. Ramkek de riy de nnairi oleka pola-raini me wniaror samomuou ed olek la ihranu ralamni. Noma riy honona re ramta'at wenna. ");
INSERT INTO lex_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ne riy mak kden hande pa ramkek oleka Yesus Nhokar doinia nhiwa-nhion yatni-rha'ani re, de rwahaur nohor hadel la'a riy mak kmaiya re, riwra Yesus Nhi' emkameni pede riy de nler la kalwiedni-paitiotni. ");
INSERT INTO lex_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nhor na'nama riy honona mak kden la Gerasa uhunu-ewatni rwak lilili-mamuau pua Yesus yan memmemna Nalo'on la' gen die ne plet pa Nwaran nek wa, yoma riy rahu ramta'at wenna. La' hade pede Yesus Nha'at la puou pa Nla'awa. ");
INSERT INTO lex_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mere edon Nla' ma'ta de riy maka kalwied olekwa de nwak la Yesus totpena nlernohor rer wialia Yesus. Mere Yesus Nakot la Niwra: ");
INSERT INTO lex_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Yana, mere samomuounu de muwal lia genmu-tienmu, me mukot nohora la'a hare honona mak samomuou memna maka Uplerlawna Nhi'a-nyapi la o'a.” Dewade riy de nla'awa la'pa nakot nohora hare honona la letni uhunu-ewatni-lahwani honona la'a hya'a maka Yesus Nhi'a la e'a. ");
INSERT INTO lex_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus Nwatiawu danau walli pa Nmai owa'ana, noma riy harahu mak kden hande rhimlolioi-rlakdardara yoma rwei niek E'a. ");
INSERT INTO lex_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Noma edon nalo'on wali ne Yairus makhi' o'tani la'a gen maka Yahudi re rhi' kreini-iskolli de nmai pia nwaltior la Yesus nayanni na'nama nwak lilili-mamuau lia Yesus, totpena Yesus Nodi liarni la' e romni nayanni. ");
INSERT INTO lex_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yoma a'nani pat hararara memeh'a maka na'nama tuwnu anni termida wehrani woru, trema-trema hota nmat wia. Ne la'pa Yesus Enalala' rer mia'ta pa edonna nte' ma'ta la Yairus romni nayanni, ne rira liawanni rpakdie'da lola etnu-liolli pa rma rherit nana Yesus walli-walli. ");
INSERT INTO lex_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","La' riy rahu re, de patke' mak khur riara la'a anni termida wehrani woru, e nor wali. Nnienni-nhienni de narieiniande nahor dioin momuoga re'eni-tniarnu pa na npair la makakrui-kagapnu (dokter) mere edonna nkalwied eti. ");
INSERT INTO lex_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Noma pat de nlernohora Yesus pa nwakrian pa ndella Yesus to'orni na'nama nteman la Yesus raini plalahwani tawnu. La'pa mtatande nekpa rarni mak kawdiadia'i de nkeran wa pa nkalwied wa. ");
INSERT INTO lex_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Noma Yesus Natiana Niwra: “He' ed maka kteman la A rainu tawnu?” Mere mak kden hande honona rwair wawayanni pa riwra: “Ami edonna.” Noma Petrus niwra: “Tuna, rirahu e rlernohora rer lia' O to'ormu pa rpakdie'da.” ");
INSERT INTO lex_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Noma Yesus Nakot la re Niwra: “Mere hota riy doma rtot A' pua rteman la A rainu tawnu. A'g e gat niohora de yoma emeknekama A ru'ru-la'yu e nlergot la A ino'nu ralamni.” ");
INSERT INTO lex_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Noma pat de namta'at pa ndiwdiwra yoma ratg oleka e hihi'ini-yapyapni, pede nleretniekla nmai pia nwaltiora-nwaltieman la Yesus nayanni na'nama nwahaur nohora la'a rirahu re gaini ralamni la'a maka ha nhi'a re pede nnienni nleretniekla nkalwied wa. ");
INSERT INTO lex_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Noma Yesus Nakot la Niwra: “O pesiaymu e narur mai A'u ina pa mkialwied wa! Mlia'awa pa mmuori-mdiar lia kalwiedni-paitiotni.” ");
INSERT INTO lex_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","La'pa Yesus e Naltiertier mia'ta de dewade riy ida nwatiawu Yairus romni pa nmai nakot la Yairus de niwra: “Tuna, a'namu nmati olekwa pa yana mpuaka Tungkur die pa Nla'a o rommu nayanni.” ");
INSERT INTO lex_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","La'pa Yesus Natlin nana noma Nakot la Yairus Niwra: “Yan mumta'ata. Mpuesiay niek wa. Ne hota a'namu de nler la kalwiedni.” ");
INSERT INTO lex_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","La'pa rte'ela Yairus romni nayanni noma Yesus Nlaran pa riy id mana yana nler la rialma, eneknek to'ama Petrus, Yohansi, Yakowsi ne keke'en mak kmati olek de inni nor amni nanpa rler la rialma. ");
INSERT INTO lex_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","La' ler de riy honona mak kden la hande ertepartar olek la knio'a-kniakru la patke' de matmiatni. Mere Yesus Nakot la Niwra: “Yana mkiakru. Yoma hararar de edonna nmati, hade e nanin to'a!” ");
INSERT INTO lex_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Riy honona riarin taru la yamalli yoma ratg oleka de hararar de nmati olekwa. ");
INSERT INTO lex_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mere Yesus Ntorreria hararar de limni na'nama Nakot la Niwra: “Ina, mumata!” ");
INSERT INTO lex_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hararar de aranni la' owa'an la temni, pa mtatande nekpa namat doin la wa. Na'nama Yesus Nhopan pa ralla na'ana. ");
INSERT INTO lex_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Inni-amni rwer rer wiawni la'a keke'en de! Mere Yesus Nlaran pa yana rakota hadella hehe'a. ");
INSERT INTO lex_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus Npol wutga maka ha Nwatutu-nwaye'a re riy termida wehrani woru, na'nama Nala plolli-mneheni me rurni-laini la ir honona re, totpena ra rhokra-rlaiya hegana-kawnu yatni-rha'ani me ra rakalwieda mak kanieni-kahniena. ");
INSERT INTO lex_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nhor nia'nama Nhopan pa rla rhi' kalwieda riy mak kanieni-kahniena, ne rla' pa rakot nohora emkameni la hota Uplerlawna Nodi plolli pa emekwalima Ray. ");
INSERT INTO lex_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yesus Nakot la re Niwra: “Hyal miy re, yan miodia hadomdoma la' yala'ami de. De yana miodia lie'ena onde arkai. Yana miodia ya'ana-yemnu, onde kupna, onde hewewta-naniairi ida-woru pa mhiernu miy rayanmi la' talan ralma. ");
INSERT INTO lex_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hota la roma-lewu maka riy rreiniana-ra'nan miy, de mdien nek la ir romni la'pa kniarmi la' let de la nhorwua nanpena mpiaran la' rom de. ");
INSERT INTO lex_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne la'pa la let id de riy edonna rreiniana-ra'nan miy, de mtio'or doin let de, mkiakan doinia awu mak kden la lakmi lia'armi totpa mtiutga de Uplerlawna Nwayotlia ira.” ");
INSERT INTO lex_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesus Nakot pa nhorwua noma maka ha Nwatutu-nwaye'a re rwaran wa pa rla'awa la' leta-ruhuna re pa rakot nohora Kot Kalwieda-Paitiota me rhi' kalwieda mak kamehra-kamau mak kden la meni-meni, la'a nnienni-nhienni re. ");
INSERT INTO lex_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","La'awa lerni pa Herodes maka kodi plolli la Galilea natlin nana Yesus hihi'ini-yapyapni re honona. Dewade Herodes nwarora la'a-mai nohora Yesus di he'a? Yoma natlin de riy doma rakot nohora Yesus riwra: “Yohansi makharani die e nmori owa'an la matmiatni ralamni eda de.” ");
INSERT INTO lex_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Dom de mana riwra: “Elia nayamkek owa'ana eda de,” me dom de owa'an riwra: “Makwohorulu-ktatrulu la'a ululu genni mak kmati olekwa re e rmori owa'ana eda de.” ");
INSERT INTO lex_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Noma Herodes niwra: “Mere a'g ed mak khopan pa riy rdawr eti oleka Yohanis de tiernu ne he' targho' riy de maka ha rakot nohora Nhi' hihi'a-yapyapi mak kamehi-kayona dino?” Noma Herodes nwahak talan pa namkeka Yesus. ");
INSERT INTO lex_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","La'awa lerni pa maka Yesus Nhopan pa rodia Uplerlawna lirni-tunnu re rawal pia rakot nohora hya'a maka ha rhi' nana re honona la Yesus. Noma Yesus Nhopan pa ir honona rora E' pa rla' rewre'wa la leta Betsaida onni, totpa rmeh'a rden to'ola la'a gen hgalgali. ");
INSERT INTO lex_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mere la' pa riy harahu re rat niohora, noma rmai pia rlernohor reria Yesus, noma Enreiniana re. Dewade Nakot la re la'a hota emkameni pa Uplerlawna Nodi plolli de emeknekama Ray. Ne E' wal pia Nhi' mak kamehra-kamau re pa rler la kalwiedni. ");
INSERT INTO lex_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","La'pa lera niwa ntuinia, noma maka ha Nwatutu-nwaye'a re termida wehrani woru rmai pia rakot la Yesus riwra: “Tuna, gen di olieta la leta! Mhuopan nekpa riy harahu ri rla'awa totpena rwahak ya'ana-yemannu me yanin genni la'a leta-ruhuna la'a gen miaka itdella di walli-walli dom to'a.” ");
INSERT INTO lex_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mere Yesus Nakot la: “Pena mialla ra'ana.” Noma maka ha Nwatutu-nwaye'a re rakot la Yesus riwra: “Tuna, a wareher mamni ri eneknek to'ama roti deulu wolima, me i'na wor tiututu. Yanpa Omiwra amla mawelia yamanan pa riy mutlialawna ri ra'ana?” ");
INSERT INTO lex_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","La'pa edon nhal de rrekan nana muanke' mamaini, de riy riwnu wolima. Noma Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: “Mhiopan pa honona re ramtatan momuoga ne rnawera la wokni-wokni. La'pa edon nhal de, rima-rima wokni, de riy terampwolima.” ");
INSERT INTO lex_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Noka maka Yesus ha Nwatutu-nwaye'a re rhi'a hya'a maka Yesus Nakota la ira. La'pa rirahu re ramtatna momuoga, ");
INSERT INTO lex_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","noma Yesus Na'ala rot dieulu re wolima, me i'na rora, na'nama Nwatniar la heyanan pa Na'uli-nawedia Uplerlawna. Na'nama Nhawi-nhawia roti re, me Nwikria i'na re noma Nala la maka ha Nwatutu-nwaye'a re rhakre'era la'a riy mutlialawna re honona. ");
INSERT INTO lex_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Honona re ra'an pa rpehera. Ra'an pa rwair wa, noma maka Yesus ha Nwatutu-nwaye'a re rawok nana mak ra'an atre'a, de kriou penpuenu termida wehrani woru. ");
INSERT INTO lex_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","La'pa lera ida ne Yesus Nora maka ha Nwatutu-nwaye'a re rmemeh'a taru, ne Yesus e Nsumbain reri. Nhorwua noma Yesus Natiana re Niwra: “Nhi'inde riy e riwra A' die he' o?” ");
INSERT INTO lex_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Noma mutwualli re rwet la riwra: “Tuna, riy dom de riwra Yohansi makharani O'a, dom de riwra makwohorulu-ktatrulu Elia, mak kmori owa'ana, me dom to' owa'an riwra O' de makwohorulu-ktatrulu dom to'a la ululu geni pa kmori owa'ana.” ");
INSERT INTO lex_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Noka Yesus Natian owa'ana: “Mere A'utian tek miy. La' miy wniarormi de, A' di de he' A'u?” Noma Petrus nwet la: “Matro'mu, O' di de Ray mak kodia mormiori-lewlewna maka Uplerlawna Nano'taru (Mesias) O inhatti!” ");
INSERT INTO lex_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Noma Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: “Maka Petrus nakota de naplol memna mere yan memmemna mikot nohor ma'ta hadella riy doma. ");
INSERT INTO lex_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mere mhioratreria! Uplerlawna ralma-riorni olek pa Rimormiori A'na A' die hota tiutulu-lielewua kropna-krieutu, yamuki-yama'ala, me hota ina-ama Yahudi rora imam-imam re o'tani-matni, me makwatutu-kwaye'a agama rwayotli A'u. Ne Uplerlawna Nala pa hota rwen A'u mere la'pa nodia la lera wotellu de Uplerlawna Namori owa'an A lia matmiati ralamni.” ");
INSERT INTO lex_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nhor nioma Yesus Nakot la riy honona mak kden la hande Niwra: “Riy meni mak kiwra klernohor A'u, de nhoratdoin momuoga hya' ed maka e ralamni nod rer lia, ne lera-ler nekpa nre' wut lia A' pua nler la yamuki-yama'ala onde matmiati pa emolmolan nekama nhoi wawayanni la auwlakra pa nlernohor A'u. ");
INSERT INTO lex_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yoma la'pa hameni maka edonna nhorat doinia mormiorni noh di wawannu de hota e' edon nler la mormiori-dardiari plalahwa pa nodi liarni. Mere la'pa riy maka khoratdoinia mormiorni la noh di wawannu pa nlernohor reri A'u hota nlernana mormiori-dardiari pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","La'pa riy mak klernana nohkeran di re'eni-tniarnu honona mere hota edonna nlernana mormiori-dardiari plalahwa pa nodi liarni, de hota re'eni-tniarnu re edon nodi unut hadom la' riy de. ");
INSERT INTO lex_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","La'pa he' maka kmola-kma' pa kreinian A'u me kwayow nana A li'ru-A tu'nu la' lera-mela ri, de hota Rimormiori A'na A' muana, muola-mua' wal pia rieinian riy della, la' ler maka hota Amuai owa'an de godia A plol wamueh'u me la' walia A A'mu plolli-mneheni hititni-repreparni pa Agor wutga Uplerlawna hopopanni (malaikat) mak khita-krepra me edonna kheik la do'a-hala ralamni Ammai die. ");
INSERT INTO lex_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mhioratreria! Hota la'a miy hononmi la handi de riy dom de mak edonna rmati mia'ta mere hota ramkek ulu Uplerlawna Nodi plolli pa emeka mak ktorna-krautu.” ");
INSERT INTO lex_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","La'pa Yesus Nwatutu-nwaye' nana hare honona pa nhorwua, noma lera wo'itu-wo'awa rlardoinla na'nama Yesus Nodia Petrus, Yohansi me Yakowsi pa rha'at la wo'ora id hananni totpa la'pa rsumbaini. ");
INSERT INTO lex_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","La'pa Yesus e Nsumbain reri dewade plinu-plinnianama Yesus gaini to'a me naniayarni hitita-reprepra. ");
INSERT INTO lex_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Na'nama riy worga rayamkek la' hitita-reprepra mak kwatiawu Ilyamou-Watyatoha, de Musa nor Elia pa ror rewre'wa Yesus rtepartarlia wniahaur nohora la'a Yesus matmiatni maka nwakrian wia, la'a leta Yerusalem. Hota Yesus Nler la matmiat die totpa Uplerlawna wniarorni-wnialaini la' ululu de ntutu-nte'ewa. ");
INSERT INTO lex_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","La' ler de, Petrus nora mutwualli re rleretniekla ranina wa, mere plinu-plinnianama ramat doin la wa pa ramkek de Yesus inonni nhita-nrepra ne Musa nora Elia rtutrier niohora. ");
INSERT INTO lex_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ne la'pa Musa nora Elia riwra rhoitio'or la Yesus pa rla'awa, noma Petrus nakot la Yesus Niwra: “Tuna, itden la handi de samoga, pa hota Tuna Nwayowa de amariria hoiwiali wotel lia handi, totpena id la Tuna, id la Musa me id wal lia Elia.” La'pa Petrus Naltier emkade edonna nwarora pleinia ne nanni nekpa naltier wia. ");
INSERT INTO lex_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","La'pa Petrus naltiertier rieri, dewade kakam woka de nmai pia npupun nana ira pa ramta'at wenna. ");
INSERT INTO lex_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Noma ratlin nana lira id nwatiawua kakam de ralamni pa niwra: “Hadi de A A'nu maka Awualir nian inhatti, pa mitlin la' E lirni.” ");
INSERT INTO lex_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","La'pa lir de nhorwua dewade ramkek de Yesus Nmeh'a Nden la hande. La' ler de de, riy maka Yesus ha Nwatutu-nwaye'a wotelu re edonna rakot nohora la riy ida hya' maka ir ramkek nana la'pa la ntutu meman la ler maka Yesus Nmori owa'ana. ");
INSERT INTO lex_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","La'pa repar wa dewade Yesus Nora maka ha Nwatutu-nwaye'a wotelu re rerun la wo'or de pa rmai wia, noma rirahu rma rahaka Yesus. ");
INSERT INTO lex_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","La'a riy woklawan de ralamni de muanke' ida nhaun pa niwra: “Tungkurga Mtiulan pa Mkil nian la a'nu! A a'nu ha nmemeh'a to'a, Tungkurga! ");
INSERT INTO lex_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","La'pa hegana-kawnu rhu'ru ralma, dewade nhaunu klellelu, ne inonni toktokla wewuehera me aparni nou-natna. Hegana-kawnu de nahmena nollia la, ne niwra nweyata-nwaniawua! ");
INSERT INTO lex_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Awuak olek wal lia maka Ompuatutu-mpuaye'a re totpa rhokar doinia hegana-kawun della mere taken niana irhokar doinia la.” ");
INSERT INTO lex_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Noma Yesus Nakot la Niwra: “Hoi! Miy mak khi' do'a-kyap hiala me mak kakleha pesiay. Hota lera wo'ir owa'an pa Agor miy tialla me Agod niohor miy, nanpena mimpiesiay A'u?! Muodia a'namu de pa mmuai!” ");
INSERT INTO lex_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","La'pa keke'en de nala' pa nma nwakriania Yesus, de hegana-kawnu de mana nkarwa'ga keke'eni de la tani wawannu pa limni-lakni totok la wewuehera. Mere Yesus Nakot la: “Hoi! Hegana-kawnu ne mliergota la'a keke'en de ralamni!” Mtatande nekpa hegana-kawnu nlergot la wa pa keke'enku' de nkalwied wa. Noma Yesus Nal owa'an keke'en della la amni. ");
INSERT INTO lex_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Riy honona rawera-rawer wawni la Uplerlawna plolli-mneheni maka ha ramkek nana la Yesus hihi'ini-yapyapni de. La ler de rimormiori honona la hande e rwer rer mia'ta wawnia la'a hare honona maka Yesus Nhi' nana-nyap niana re, mere Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: ");
INSERT INTO lex_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mtia'wa kalwiedweda tlinmi me yana mhioratdoinia A li'ru-tu'nu ri. Rimormiori A'na A' die hota ral A lia rimormiori limni ralamni.” ");
INSERT INTO lex_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mere maka ha Nwatutu-nwaye'a re edonna rna'erit nana Yesus ha Nakotkota re. E lirni de, e rkukum tar mua'ta nnia'eratni totpena yana rat niohora Yesus lirni de lie'erni. Ne ir nek de ramta'at wali pia edonna ratian la'a-maiya Yesus ralma-riorni. ");
INSERT INTO lex_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Noma maka Yesus ha Nwatutu-nwaye'a re rahuri-rawo'or nohor lir mak kiwra hota ir he' ed maka inponni nrehi? ");
INSERT INTO lex_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus Natg oleka honona re ralma-riorni, la' hade pede Ntorreri keke'enku' ida limni na'nama Nala pa ntutrier lia E onni. ");
INSERT INTO lex_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Noma Nakot la maka ha Nwatutu-nwaye'a re Niwra: “Hyal miy re, hota he' mak kreiniana-ka'nana keke'enku'a emeka hadi onnila A rerie'yu de emekwalima nreinian olek A wua. Ne la hameni mak kreiniana A'u, de emekwalima nreinian oleka Uplerlawna mak khopn A'u. Yoma riy maka khima-kre'a riy mak kakleh weli de ir er maka inpona la Uplerlawna yamkekni.” ");
INSERT INTO lex_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohansi Niwra: “Matroma, ami e mamkeka riy nhokra hegana-kawnu, de e nwet la Matro'mu nanni pede ami e mlarna de yoma it mutwualli atia'a hade.” ");
INSERT INTO lex_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Noma Yesus Niwra: “Yana mliarna de, yoma hota hameni mak edonna khoklira-kpah'a wawa la riy id de nnia'eratni de ir er maka ktulan la riy de.” ");
INSERT INTO lex_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","La'pa nhi'pa nte'ela lerni pa Yesus Narian pa Nla'awa Ilyamou-Watyatoha dewade orgahani Netlia lirni de emkameni ho'mana Nla'a Yerusalem. ");
INSERT INTO lex_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Noma la'pa Nalala' rer mia'ta Nhopan pa riy rala' ulg E'a. Riy maka Ha Nhopan pa kala' ulu re totpena rla rwahi'a-rwayod lia Yesus maimiaini la'a let id mak kden la Samaria. ");
INSERT INTO lex_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mere riy mak kden la let de rahmena-rapraiya Yesus maimiaini la' hande yoma ratga de, Yesus e Nharan reria Yerusalem. ");
INSERT INTO lex_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Mere la'pa maka ha Nwatutu-nwaye'a re, de Yakowsi nor Yohansi namkek nan hade noma rakot la riwra: “Matroma, Ompuayow de ampaka ai pa nwatiawua lyanti pa nernu totpena nram doinia let di nora rimormiornio?” ");
INSERT INTO lex_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Noma Yesus Nkillia re na'nama Nawenan la re. ");
INSERT INTO lex_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nhor nioma rla rlol to'a leta dom to'a. ");
INSERT INTO lex_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","La'pa Yesus Nora maka ha Nwatutu-nwaye'a re rala' pa rodi liarni, noma riy doma nakot la Yesus niwra: “Tuna, a'g e giwra liernohor rer nek O' Tuna pa tlol meni-meni.” ");
INSERT INTO lex_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Noma Yesus Nakot la Niwra: “Hyalia, Ohpora-ahdiawra hu'ulli-lienni erla me onu-ma'nu nekane puonni erla, mere Rimormiori A'na A' die hota A'g edon liernan gen pia A'udera A o'tu. Ne hota omliernohor A' die hota o e mukleha wali geni.” ");
INSERT INTO lex_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Noma Yesus Nakot wal lia riy id to'a Niwra: “Mliernohora A'u.” Mere riy de niwra: “Tuna, Muolin doin a' pua la'pa arie'ela tiamnia a'mu nampena aliernohor rer O'a.” ");
INSERT INTO lex_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Noma Yesus Nakot la Niwra: “Muolin doinia riy mak edon kpesiay A'u pede emeknekama rmati olekwa pa orgahani rtamnia mak kmati. Mere o'a de mlia' pa mukot nohora la riy honona miwra Uplerlawna emeknekama Ray miaka kodi plolli.” ");
INSERT INTO lex_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","La' riy id mana nwak pa nakot la Yesus niwra: “Tuna, a ralmu naplele'er pa aliernohor Tuna mere Ompuayowa agora pleini a i'nu-a'mu wair nanpena amuai!” ");
INSERT INTO lex_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Noma Yesus Nakot la riy de Niwra: “La'pa riy ida ntepartarlia wnial tani, ne nkillia to'orni, de hota e kniarni de edon naplola. Ne hota emkade walia la riy mak kiwra kla' Uplerlawna mutnu-rahanu maka Enodi plolli la emeka Ray. La'pa riy de nwaror to'a neka inni-narni onde re'eni-tniarnu de hota kniarni la Uplerlawna edon naplola.” ");
INSERT INTO lex_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","La'pa nhorwua noma Itmatromlawanni Nwalir niana, maklernohor E'a riy terampwo'itu, na'nama Nhopan doinia pa rala' ulga E' pa rla'a geni-tien honona maka Yesus hota Niwra Nla'a. Rla'a de rima-rima nor talanwalli id pa rala' wutu. ");
INSERT INTO lex_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nakot la re Nnairia yawalliohora id pa Niwra: “Emolmolan nekama wetra' harahu maka nkern olek la nhyi' ralma, mere mak kreiki-kwo'ora, edonna rtu'tu, emkade walia mak edon katlin ma'ta Uplerlawna lir kalwiedni de harahu wali mere mak kakot nohora Uplerlawna lir kalwiedni riy doma rmeh'a. La' hade pede emolmolan nekama rwak la ora nhyi' de totpena nhopna mak kreiki-kwo'ora pa rreiki-rwo'ora, mpiak wal lia Uplerlawna totpena Ntutga riy pa rre'ela rakot nohora Uplerlawna lir kalwiedni la rimormiori mak edon katlin ma'ta. ");
INSERT INTO lex_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Dodo'ondi mirian wa! Mere mhioratreria! A'g e ghopan pa mlia'awa A arwa'lu geni pede hota miy die emeknekama pipi-duma mak kakleh ruri-lai pia mlier tar lia ohpora-ahdiawra letgarni mak kiwra klihir matmata-khaw riarara. ");
INSERT INTO lex_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mlia' de yan mia miodia kupna genni, onde arkai onde lakmi wniowni pa ma mhierun doin maka ha mniairia de, ne yana mrien mahneka la talan letgar yoma miora riy mpiahauru. ");
INSERT INTO lex_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","La'pa mimlier la roma id ralamni, de mhiar ulga lirmi pa miwra: “Kalwieda la miy hononmi!” ");
INSERT INTO lex_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","La'pa mliernana riy maka kreinian miy lia nhiolia samomuou, de hota plol toto'a pa riy de nlernana kalwieda-paitiota. Mere la'pa edonan de Uplerlawna edon Nal kalwiedni la' riy de. ");
INSERT INTO lex_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","La'pa riy rreinian miy, de mdien nek la la rom de wa. Mi'ina-miemnia hya' maka ha nhoi-ntania tiy miy, yoma riy meni mak ktulla-kari de hota nlernan siewni-kaini la'a liwatnu-odawni. Yana mpiatitin la'a-mai genmi-tienmi. ");
INSERT INTO lex_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","La'pa mimlier la leta ida, ne let de mniotni rreiniana-ra'nan miy, mi'ina-miemun de yana mmiakriarnia. ");
INSERT INTO lex_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mhi' kalwieda riy mak kamehra-kamau la'a let de ne mikot la let de mniotni miwra: “Ntutu-nte' olek pa hota Uplerlawna Nodi plolli pa emeknekama Ray.” ");
INSERT INTO lex_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mere la'pa miy mmiai wia la' leta ida, ne let de mniotni edonna rreiniana-ra'nan miy, demade mlia'awa la talla ralamni, ne mikot la miwra: ");
INSERT INTO lex_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Hoi! La'pa miy kodmi-awmi re nek de e ratniapal la'a lak mamni, amkakan doinia totpena nwagahniorat miy la'a Uplerlawna Nwayotli miy, yoma mikleha pesiay. Mere mhioratreria! Ntutu-nte' olek pa hota Uplerlawna Nodi plolli pa emeknekama Ray.” ");
INSERT INTO lex_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mhioratreria! La'a lera-mela nte'ela noha niatni, leta-ruhuna maka edon kreinian miy er maka klernana Uplerlawna niukamnu mak kareh dioin miemna niukamnu maka riy yatyata-halala mak kden la leta Sodom hota rlernana.” ");
INSERT INTO lex_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Hoi! Mak kden Korasim nora Betsaid miy ree! Hota mlier la yatlorni-yatra'ani. Yoma miy edonna mpiadan nohora hihi'a-yapyapi mak kamehi-kayona maka ha mimkek oleka re. Mak kden la Tirus me Sidon edon ramkek nana hihi'a-yapyapi mak kamehi-kayona mak emkare la' ler ululu, mere la'pa Aghi' hihi'a-yapyapi mak kamehi-kayona mak emkare la mak kden la leta Tirus nora Sidon la' ler ululu de ramkek nana neknanama plol toto' pa rnair oleka naniairi yaluli-yahona pa ra rtutga ralamni mawla la do'oni-halli me rhoitio'or doini-rtahnei dioini oleka do'oni-halli re. ");
INSERT INTO lex_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mere la'a miy die hota la'pa ntutu-nte'ela la'a lera noha niatni, de hota Uplerlawna niukamnu la' miy wawanmi nareh dioin la mak kden la leta Tirus nora Sidon re. ");
INSERT INTO lex_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne hota mak kden la Kapernaum miy, la' wniarormi de hota rran tutul miy nanmi lia Ilyamou-Watyatoha? Hade edon emkade. Hota reriehenu rrinnia miy lia ai mormiori ralamni (naraka).” ");
INSERT INTO lex_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Noma Yesus Nakot la maka ha Nwatutu-nwaye'a re Niwra: “La'pa he' mak katlin tiy miy, de hota riy de natlin mai A'u. Ne la riy maka kwayotil miy, de hare e rwayotlia A'u. Ne la'a riy maka kwayotlia A'u, de hare er maka kwayotlia Uplerlawna maka khopan pa Amuai.” ");
INSERT INTO lex_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Noma riy teram mandiditu (terampwo'itu) re rla' rhi' kniarni nhor diewade rawali pia rmai die, rahepuepur reri pa riwra: “Matrom ee! Amla' de nhiw yatni-rha'ani mana ema rdopal dodioinia yoma ampet la Orgahi-Orha'a O nanmu!” ");
INSERT INTO lex_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Noma Yesus Nakot la re Niwra: “Yowa ne, A'umkek nana hegana amlawanni ema rwaliernia la'a lyanti, de emeknekama tlena. ");
INSERT INTO lex_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ne totpena miatga, de Agal oleka ruri-lai tiy miy wia totpena ma mpiahapra niy nora hodai, me la' walia miy arwalmi de hegana amlawanni mana, mtiewra rurni-laini. Hota hadoma ta'en niana nhi' wano'a-warar miy. ");
INSERT INTO lex_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","La'pa emkade ho'mana yana mihepur nohora yatni-rha'ani e rlola miy nayanmi. La' samomuounu de mihepru, yoma miy nanmi e rahniorat la'a Ilyamou-Watyatoha.” ");
INSERT INTO lex_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","La' ler de meman pa Yesus Nahepuepru yoma Uplerlawna Nhiwni ed mak kodi plolli la E'a, pa Nhar lirni la Uplerlawna. Niwra: “Ama, Orgahi-Orha'a mak ktorna-krautia nohmarna nora lyanti tulu! A'u'uli-uwedi O'a yoma wniarormu-wnialaimu hihi'imu-yapyapmu de O e Muwunmua la'a riy maka kakriahlu la iskola me rwarora ir er mak katu, mere Omukota la riy maka nhiolli-lietni emeka keke'enku'a pa rlol yawa. Yoma plol toto'a pa hade ed mak kla' nana A'mu O ralma-riormu.” ");
INSERT INTO lex_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nsumbain pa nhorwua noma Yesus Nakot la mak kden hande Niwra: “A A'mu Nal oleka plolli-mneheni kirkira-ralma-rior samomuounu mai A' wua. Riy id mana edon nat niohora A'u eneknek to'ama A A'mu. Me riy id mana edonna nat niohora A A'mu eneknek to'ama E A'nani A'u, ne riy mak Agiwra ukot wahyaria A A'mu la ira.” ");
INSERT INTO lex_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Noma Yesus Nkillia maka ha Nwatutu-nwaye'a re rmemeh'a pa Nakot la Niwra: “Miy e mliernana oleka unut lawna, yoma miy e mimkek oleka A hihi'u-yapya'pu re. ");
INSERT INTO lex_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mpiahniorta, A'ukot emkade yoma makwohorulu-ktatrulu harahu me la' walia ray-ray la' ler ululu rwak pa ramkek walia hihi'a-yapyap miaka Aghi' nana, me rwak pa ratlin walia la'a hya' ed maka Awuatut niohor di, mere A maimia'yu lerni edon ntutu-nte' ma'ta pede ta'en niana ramkeka onde ratlina.” ");
INSERT INTO lex_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","La' lera ida noma makwatutu-kwaye'a agama deullu-tatarni ida nta'aga Yesus. Ntutrieri pa natiana Yesus niwra: “Tungkurga, aghi'a hya'a totpena aliernana mormiori-dardiar plalahwa pa nodi liarni?” ");
INSERT INTO lex_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Noma Yesus Nakot la Niwra: “O ralma-riormu emkameni la hya' maka ha rakota la Puka ralamni?” ");
INSERT INTO lex_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Noma riy de nwet la niwra: “E rhorat targa la Puka ralamni totpa agala a ru'ru-la'yu, ralma-rio'ru la'pa a ih'ru-ralmu tetema pa aghima-rie'a Uplerlawna Matromlawnu de. Me totpa agatu tiulla-siaynia ura'a-upal wualia rimormior wia'lu pa emekwalima a'umkek rer lia a inon wamueh'u.” ");
INSERT INTO lex_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Noma Yesus Nakot la Niwra: “Mak ompuet la re raplola pa mliernohora re, totpena mliernan mormiori-dardiari.” ");
INSERT INTO lex_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mere tungkur agam de niwra ntot pa riy rwaror de, riy samomuou id e'a. Pede natiana Yesus niwra: “Hota rimormior he' ed maka atiulla-siaynia?” ");
INSERT INTO lex_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Noma Yesus Nakot la Niwra: “Muanke' Yahudi ida nwatiawua Yerusalem pa niwra nla'a Yeriko. Nla' pa nler la talan letgar wa noma riy rwuri-rgalmua lawra-rayanni hyonni-hyanni honona me rliwra-rkakul nan de tete'-omiomia pa na'uhi-naklela la genni. ");
INSERT INTO lex_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ne edon nalo'on wali ne Yahudi kreini o'tani-matni (imam) ida nleret liola hande. La'pa namkek nana riy de, dewade nwotar doin la talla walli pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Emkade wal lia riy Lewi ida mak khi'inde khima-kre'a Yahudi kreini o'tani-matni la Uplerlawna roma kreini nayanni, nlol wal lia hande, ne nma nwakriania pa la'pa namkek nana riy de namno'a-namrara dewade nwotar doin la talla walli owa'an pa nodi liarni. ");
INSERT INTO lex_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mere edon nalo'on wali ne riy Samaria ida (maka nhi'inde Yahudi re rmakriarnia) la'a yala'a plalahwa nleret liola hande noma la'pa nkil tiar la riy Yahudi de dewade ralamni ntuin doin la pa ");
INSERT INTO lex_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","nwakriania na'nama nala arka me wu'rg atiawi na nagapnia no'oni-rarni na'nama newan pitga nhor nioma nkenia la keledai hananni pa nodi liarni la rom maka riy rpairia pa ranin la, na'nama nhapo'a-nhakal lia hande. ");
INSERT INTO lex_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","La'pa repar noma nala kupan pi'ra (dinar) woru, de lera woru kaini, la'a ora roma sniew de, na'nama nakot la niwra: “Mhi' kalwiedwed hadi ne la'pa hya' to' maka ka'an kupna, de hota a'uwali owa'an pa mua puairia.”” ");
INSERT INTO lex_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","La'pa nhorwua noma Yesus Nwati ltierni la yawalliohor de na'nama Natiana hadilla riy de Niwra: “La'a riy mantetellu re de hameni ed maka khi'a rimormior wialli pa emolmolan neka e nhi' la inon wamueheni?” ");
INSERT INTO lex_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Noma makwatutga agama mak katian de nwet la niwra: “Riy maka ktulla-ksaynia la riy de!” Noma Yesus Niwra: “La'pa emkade demade mlia'awa, ne mhi' walia emkadella la he'-he' to'a” ");
INSERT INTO lex_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nhor nioma Yesus Nora maka ha Nwatutu-nwaye'a re rodi liarni noma rte'ela la' leta ida. La' let de, de patke' ida nwawa Marta nmai pia npolu-nwaka Yesus totpena Nla e romni nayanni. ");
INSERT INTO lex_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta elli id ed wal lia nanni Maria. Maria di, e namtatan nohora Itmatromni Yesus pa natlina-natailla Yesus lirni-tunnu. ");
INSERT INTO lex_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mere Marta nmakokan nohora tulanni-kniarni la romni nayanni. Noma Marta nla' pa nakot la Yesus niwra: “Matroma, O edonna Mpuolliohora Maria pa nma nor a'u pua amkari? Enamtatan rer tio'a. Mhuopan pa nma nor a'u pua amkar lia handi.” ");
INSERT INTO lex_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Noma Itmatromni Nakot la Marta Niwra: “O e muakokan nohora haneknek wawannu, Marta. ");
INSERT INTO lex_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Mere maka Uplerlawna Nwahaka de nwal tio'ola ida nmeh'a taru, de hya' maka Maria ha nwalir nian de. Pa hota A'g edonna wuayotil targ e' pa edonna natlin rer lia A li'ru-tu'nu ri.” ");
INSERT INTO lex_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","La'awa la lera ida noma Yesus Nsumbain la geni ida. Nsumbain pa nhorwua noma maka ha Nwatutu-nwaye'a ida nakot la niwra: “Matroma, Mpuatut tiek am lia sniumbaini pa emekwalima Yohansi nwatutga la maka ha nwatutu-nwaye'a re pa rsumbaini.” ");
INSERT INTO lex_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Noma Yesus Nakot la re Niwra: “La' miy sniumbainmi de mikot emkadilla: “A Am mamni la Ilyamou-Watyatoha! O' de Mueh'a Mupriri-mukded la genmu-tienmu. Ampak de nhiu'ru-nhielma ya'unni-yamta'ata nmai reri O' dee! Ampei-mnar reria lodanmu-hairmu. Ampaka pa O ralma-riormu de, mak kden la noha wawannu rlernohor reria pa emekwalima maka ha rhi'a la Ilyamou-Watyatoha. ");
INSERT INTO lex_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mhi' apehera a apun mamni la' yamanan mak Omual pa ama'an la' lera-lera. ");
INSERT INTO lex_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mumou-muwitna a do'a-hal mamni yoma am miana mhoratdoinia riy do'oni-halli mai ami. Ne yana Muolin doin limmu-mpue'er rormu mai ami, yanpa la'pa hegana-kawnu rta'ag am die, hota amler la do'a-hala ralamni.”” ");
INSERT INTO lex_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Noma Yesus Nakot owa'an la maka ha Nwatutu-nwaye'a Nnairi yawalliohora Niwra: “La'pa riy id tiy miy nla'a mutwualli romni la' mela letargara, pa niwra: “Hyalia, mual nana roti meheni wotel pa ama'ana pleinia, ");
INSERT INTO lex_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","yoma a mutwua'lu id nwatiawu gen olieta pa nma nlola a ro'mu nayanni mere a yamanan mamni nhorwua!” ");
INSERT INTO lex_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Taplin niohora mutwualmi maka mimlia' mpiak la de nwalol tiy miy niwra: “E! Yana muriei a'u! Agho'la wuent oleka a ro'mu nhiarni pa agora u'pu-a'nu manin olek am pia. A'g edonna ga' pua umat nohora miy polpuolmi-wakwakmi re!” ");
INSERT INTO lex_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","La'pa emkade de hota emkameni tiy miy? La'pa miy mutwualmi ir ho'mana hota edonna namat pa nal hadom tiy miy. Mere mimpiesiaya, la'pa miy edonna mmiola-mmia'a mpiakwak to'owa, de hota namat pa nala hare honona mak ha mpiaka re. ");
INSERT INTO lex_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Pede Awuagahniorat miy Agiwra, mpiaka la Uplerlawna, hota mliernana, mpiahaka hota mia'nana. Mtiet la nhiari hota rhari nhiari tiy miy. ");
INSERT INTO lex_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yoma riy mak kwaka de hota nlernana, mak kwahaka hota na' nana me riy maka ktet la nhiari de hota rhari nhiari la. ");
INSERT INTO lex_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","La' miy hononmi re, ama-hyali id a'nani nwaka pa na'ana i'na, de amni edon nal niy lia toh! ");
INSERT INTO lex_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Onde rwaka hiwi ternu pa ra'ana, miy edonna miala hodai! ");
INSERT INTO lex_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","La'pa rimormiori miy mak khi'inde khi' do'a-hala nekane miatu miala ha samomuounu la miy a'nami re, yaho'ma miy Amlawanmi mak kden la Ilyamou-Watyatoha! Hota E' ed mak kala E Nhiwni la'a riy maka kwak la E'a.” ");
INSERT INTO lex_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","La' lera ida ne Yesus Nhokar doinia hegana-kawnu la'a riy mak kaplinu kaltieri (hakamu). La'pa hegana-kawnu de nlergot wa dewade riy de naltier kalwiedwed wa pa rirahu re rwer rer wiawni la. ");
INSERT INTO lex_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mere la' dom de e riwra: “Be'elsebul, hegana amlawanni de ed mak kala ruri-lai la Hade pede na Nhokra-nlai hegana-kawnu re.” ");
INSERT INTO lex_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Me riy dom de rtota Yesus la klieratni pede rhopan pa Yesus Ntutga hihi'a-yapyapi mak kamehi-kayona totpena irat muemna de Yesus plolli-mneheni nwatiawua Uplerlawna. ");
INSERT INTO lex_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mere ira ralma-riorni re, Yesus Nat niohor momuoga. Pede Nakot la re Niwra: “Hegana re emeknekama hairi ida. La'pa la hairi ida rimormiorni ema rhakre'era la wokni-wokni mak kahuri-kawo'ora, de hota hair de edonna namteman plalahwa. Me luwu-a'na ida nden rer lia yahuri-yawo'ora de hota rweyata-rwaniawua luwu-a'na de. ");
INSERT INTO lex_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Emkade walia la hegana amlawanni tnioranni-riautnu. La'pa hegana woka-le'u ida, nhokra woka-le'u dom to'a, de hota hegana tnioranni-riautnu ema reyapie'era. A'ukot emkade yoma miy e miwra A'g e ghokar doinia yatni-rha'ani Aniairi Be'elsebul plolli-mneheni. ");
INSERT INTO lex_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","La'pa mikot emkade mai A'u nnia'eratni de hota mak klernohor miy niek de rnairia hegana amlawanni plolli-mneheni pa Nhokar doini hegana-kawnu. Mere maklernohor miy niek de rat niohora wniarormi de nhala. ");
INSERT INTO lex_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mere Aghokra-liaiya hegana-kawnu yatni-rha'ani re de Aniairi Uplerlawna plolli-mneheni. Ne hade e ntut mueman de Uplerlawna ed mak kodi plolli pa emeka Ray ne miy e mimkek nan oleka E rurni-laini. ");
INSERT INTO lex_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Itala mak karuri-kalai ida pa itsi' la yawalliohora. Hegana amlawanni de emeknekama mak karuri-kalai ida mak knairia keki-rautu penpuenu-tetema na natiaka romni, totpa yana riy ra'ala re'eni-tniarnu. ");
INSERT INTO lex_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mere A' die de emeknekama riy ida mak kmai, mak rurni-laini nareh mieman la e'a pa Atiowar nana na'nama Awuarui-wuate'la momuoga e kekni-rautnu maka enwarora de hota ed mak katiak nana e re'eni-tniarnu me Age'era-ghakre'era hyonni-hyanni re honona. ");
INSERT INTO lex_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mhioratreria! Riy mak edonna rlernohor reri A'u, de nnia'eratni de ir er maka khoklira-kpah'a waw (malawna) mai A'u. Ne riy edonna rhima-rre' A'u, nnia'eratni de hare er maka rweyata-rwaniawua A tulla-knia'ru!” ");
INSERT INTO lex_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“La'pa yatni-rha'ani nahniokar doin la'a riy ida ralamni, de loldoi-loldai lia wo'or kerkerna totpena nahak geni id owa'ana totpena nhu'ru ralma mere hota edonna nlernana. La' hade pede yatni-rha'ani de wniarorni de hota nawali owa'an la riy de. ");
INSERT INTO lex_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","La'pa nawal wia, de namkek de riy de nmou-nwitna olekwa emeka likti id maka ha rwahyar momuoga ne rwahi'a-rwayod tiarga. ");
INSERT INTO lex_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Noma nla' owa'an pa nmai die nodia yatni-rha'ani wo'itu de yatni-halli nareh dioin memn owa'an la e'a. Dewade ha rler la riy de ralamni owa'ana. Pede la'awa hohoni, de riy de nler la polpuol inni-wakwak amni mak karehi owa'an la' ulul genni.” ");
INSERT INTO lex_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","La'pa Yesus Naltier rereri die dewade patke' ida la rirahu re letgarni nhaunu pa nakot la Yesus niwra: “Eee! Inmu maka ka'uhu-ka'apnu O'a la' ler ululu, de nlernan unut lawna!” ");
INSERT INTO lex_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Mere Yesus Nakot la Niwra: “La' plollolli de la'a riy ma