﻿USE sofia;
DROP TABLE IF EXISTS sofia.leu_vpl;
CREATE TABLE leu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES leu_vpl WRITE;
INSERT INTO leu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","A sising ina matafebun si Yesus Krais aava buna lava na Devit. E na Devit si a buna lava na Abrahem. ");
INSERT INTO leu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","A toxan a mu yaan ina matafebun sangafilu saxa pana talafaat ti lana yaan si Abrahem fefexaxaas na Devit: na Abrahem na tama Aisaak, na Aisaak na tama Yaakop, na Yaakop na tama Juda xuvul pana mu tina; ");
INSERT INTO leu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","na Juda na tama Peres nare Sira (na ninare na Tamar), na Peres na tama Esron, na Esron na tama Ram, ");
INSERT INTO leu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","na Ram na tama Aminadap, na Aminadap na tama Naason e na Naason na tama Salmon; ");
INSERT INTO leu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","na Salmon na tama Boas (na ninana na Rehaap), na Boas na tama Obet (na ninana na Ruut), na Obet na tama Jesi aava na tama King Devit. ");
INSERT INTO leu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","E a mu matafebun ti lana yaan si Devit fefexaxaas a yaan a mu Juda ri fevipis la bina Babilon: na Devit na tama Solomon (na ninana a tefin si Uraia paamua), ");
INSERT INTO leu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","na Solomon na tama Rehoboam, na Rehoboam na tama Abiya, na Abiya na tama Aasa, ");
INSERT INTO leu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","9","na Aasa na tama Jahosafaat, na Jahosafaat na tama Yeꞌoram, na Yeꞌoram na tama Usiaa, na Usiaa na tama Jotam, na Jotam na tama Ehas, na Ehas na tama Esakaia, ");
INSERT INTO leu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","na Esakaia na tama Manaasa, na Manaasa na tama Emon, na Emon na tama Josaia ");
INSERT INTO leu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","e na Josaia na tama Jehoiakin xuvul pana mu tina. ");
INSERT INTO leu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","E a mu matafebun ti lana yaan a mu Juda ri taꞌulan na Babilon fefexaxaas a yaan si Yesus: na Jehoiakin na tama Seltiel, na Seltiel na tama Serubabel, ");
INSERT INTO leu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","15","na Serubabel na tama Ebiut, na Ebiut na tama Ilaiakim, na Ilaiakim na tama Esor, na Esor na tama Sadok, na Sadok na tama Akim, na Akim na tama Eliud, na Eliud na tama Eliesar, na Eliesar na tama Mataan, na Mataan na tama Yaakop ");
INSERT INTO leu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","e na Yaakop aave na tama Yosep aava tamai si Maria na nina Yesus e na Yesus naang va ri xalie pana Mataa Failai sina Piran. ");
INSERT INTO leu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","E voxo a toxan a mu yaan ina mu matafebun sangafilu saxa pana talafaat ti la yaan si Abrahem fefexaxaas a yaan si Devit e sangafilu saxa pana talafaat ti la yaan si Devit fefexaxaas a yaan ina vipisan pe Babilon e sangafilu saxa pana talafaat ti la yaan aave fefexaxaas a luluuxan sina Mataa Failai. ");
INSERT INTO leu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","A luluuxan si Yesus Krais a savat malaan: na ninana, na Maria, ri fo fakalimaane rao i taa tamai si Yosep. Taasaxa re pife mati xuvul lunai e nane texaas o a tiva sena gutan sina Vovau Xaradak. ");
INSERT INTO leu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Na Yosep aava na lavana, a mataa xaradak paaliu e nane bai famangil na Maria la matana mu rabuna. E voxo nane lamon o i taa laxao kasam a kuus fanaian ina tamaian sirie. ");
INSERT INTO leu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Na Yosep fo lamon xo pana mo aanabeꞌ taasaxa lana mifan a angelo sina Piran a savat sina e a kuus, “Yosep, lak si Devit, muta lamon faaxaves pana tamaian sime Maria senaso a Vovau Xaradak fo savat sina e nane taxa tiva sena. ");
INSERT INTO leu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I taa luk a lak tomexaan e no taa xalie pa Yesus senaso i taa fakaxup a mu rabuna sina xasena vilaana saat siri.” ");
INSERT INTO leu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","A maana mo xapiak aanabeꞌ ri savat xena faxalit famatavasaana ferawaian aava Piran a kuus pana la ngusuna mu rabuna ina kuus fatuxai sina. ");
INSERT INTO leu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ri kuus malaan: “Langai, a tefin palau aava pife mati xuvul pana saxa mataa lunai, i taa tiva e i taa luk a lak tomexaan e ri taa xalie pa Imaanuel.” (A malasuf ina isin aanabeꞌ a malaan: Piran taxa waan xuvul pataara.) ");
INSERT INTO leu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Layaan na Yosep a para ti la matefan sina, nane usi a fefasaian aava angelo sina Memai a xuuse pana. E nane xel na Maria e lisane xe la lifu sina e i taa tefin sina ");
INSERT INTO leu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","taasaxa nane pife mati xuvul pana fefexaxaas a yaan nane luk a lak tomexaan aave. E nane xalie pa Yesus. ");
INSERT INTO leu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Na Yesus a luxan pe la bina Betlihem lana bina lava Judia layaan na Herot a paamuian a mu Israel. Lamina luluuxan sina saxano rabuna pana texaasan ti paa lasuun paaliu ri filimaan xe pe Jerusalem ");
INSERT INTO leu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","e ri fiai, “A popo aava paamua king sina mu Juda, fo luxan faa? Maam xalum a vapara aava fakalimaan a savatan sina la nobina simaam e maam filimaan xena nangusaana.” ");
INSERT INTO leu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Layaan na Herot aava paamua king, a langai pana, nane e maana rabuna pe Jerusalem vaxa ri lalamon faaxaves sena. ");
INSERT INTO leu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nane xel faxuvul a mu memai priis e mu rabuna ina fepitaa pana vuputkai e fin nari, “A Mataa Failai i taa luxan faa?” ");
INSERT INTO leu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","E ri suie, “Pe Judia la bina Betlihem, senaso a mataa ina kuus fatuxai a kala malaan: ");
INSERT INTO leu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘E nano, Betlihem aava waan la nobina si Juda, no bina modak taasaxa mu rabuna xapiak ri taa pife maluf nano senaso saxa paamua lava aava i taa paamuian a mu rabuna siak, a mu Israel, i taa luxan move.” ");
INSERT INTO leu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Lumui, na Herot a xel fun a mu rabuna pana texaasan xena fin nari pana so ta yaan a vapara aave savat e ri xuus fatexaase. ");
INSERT INTO leu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","E mui nane feng nari xe pe Betlihem e a xuus nari, “Mi fe seng faagutan a lak aave e layaan mi fo tingine mi maa xuusau talo nenia sait ne taa fe nanguse.” ");
INSERT INTO leu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","E voxo lana faletan siri ri xalum fulan a vapara naang aava savat pe paa e ri bas paaliu pana faamamaasan. A vapara aave a paamuian nari e fe waan fatak laaꞌui xuluna lifu aava lak taxa waan lana. ");
INSERT INTO leu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Layaan ri laak la lifu aave ri xalum a lak xuvul pa ninana, na Maria. E ri bukaak e ri nangus a lak aave. E mui ri kas a fafanaian siri e ri tatavai xe sina lak pana ‘gol’, e vebit pana lasan roxo e a vulut pana lasan roxo aava ri xalie pana ‘mur’. ");
INSERT INTO leu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","E lana mifan a Piran a xuus fatexaas nari o ri muta ulaa xe si Herot. E voxo ri usi a salan patak xe la bina siri. ");
INSERT INTO leu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Lamina faletan siri a saxa angelo sina Memai a savat si Yosep lana mifan e a kuus, “Na Herot i taa feng a rabuna sina xena sengaana lak talo ri taa punuxe. Tamasiak xo, siak a lak xuvul pa ninana e mutul sinuf xe pe Isip. Mutul taa waan pave fefexaxaas a yaan ne xuus namutul pana.” ");
INSERT INTO leu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Na Yosep a tamasiak e a xel a rofenan sina e rutul taꞌulan a bina pave la xunavung naang xena falet xe pe Isip. ");
INSERT INTO leu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nane waan pave fefexaxaas a yaan ina maatan si Herot. A maana mo aanabeꞌ a savat xena famatavas a ferawaian sina Memai la ngusuna mataa ina kuus fatuxai. A kuus malaan: “Ne fo xel a Lak Tomexaan siak ti pe Isip.” ");
INSERT INTO leu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Layaan na Herot a texaas o mu rabuna pana texaasan ti paa ri fo bit nane, nane marala faagut. E nane fasei faagutan a mu rabuna ina rawen sina o ri taa punuk a mu rafulak tomexaan aava ri toxan a mariaas taragua e lapia e ri waan pe Betlihem e la mu bina faasilak. Nane lamon o i taa vil malaane senaso a rabuna pana texaasan ri fo xuuse pana so ta yaan a vapara fo savat. ");
INSERT INTO leu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","E pana vilaana malaan, a mo aava mataa ina kuus fatuxai, na Jeramaia, a kuus pana, a savat la matavas. Nane kuus: ");
INSERT INTO leu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A mu rabuna pe la bina Rama ri langai a taangiisan molava sina saxa tefin, na Resel aava i taxa tangiis soxot a mu rafulak sina. Ri fo maat e i taa pife taxapus pana taangiisan sina.” ");
INSERT INTO leu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Lamina maatan si Herot, a angelo sina Memai, lana mifan, a savat si Yosep pe Isip ");
INSERT INTO leu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","e a kuus, “Tamasiak, xel a lak xuvul pa ninana e ulaa xe la bina sina mu Israel senaso nari aava ri seng a lak xena punuxaana, ri fo maat xo.” ");
INSERT INTO leu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","E nane tamasiak e lisan faꞌuli a lak xuvul pa ninana xe la bina sina mu Israel. ");
INSERT INTO leu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Taasaxa layaan na Yosep a langai o na Aakilas taxa paamuian a rabuna pe Judia la vepen si tamana, na Herot, nane bai falet xe Jerusalem senaso a mataut. E a Piran, lana mifan, a xuus fatexaase o i taa falet xe pe Galili. ");
INSERT INTO leu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nane fe waan la saxa bina pe Galili aava ri xalie pa Nasaret. E voxo a mo aava mu rabuna ina kuus fatuxai ri kuus pana sena Mataa Failai, a savat la matavas. Ri kuus malaan: “A rabuna ri taa kuus o nane ve a mataa ti Nasaret.” ");
INSERT INTO leu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Lana yaan aave, pe la xobingil pe Judia, na Jon ina Fasufan a falet xolai xena kuusan fasavat a lagasai sina. Nane kuus, “Puk a lamonan simi e taꞌulan a vilaana saat simi senaso a yaan ina savatan sina fatataganan sina Piran i taxa waan faasilak.” ");
INSERT INTO leu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Na Aisaia aava mataa ina kuus fatuxai, a ferawai sena mataa aave malaan: “A ling ina saxa mataa pe la xobingil i taa kel, ‘Faigotan a salan xana Memai, vil faxaradak a salan sina.” ");
INSERT INTO leu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","A maana marapi si Jon ri vesane pana fui ina ‘kaamel’ e a fakaliuan nane xa pana yowang ina vipin ina tiir. E nane fuuna ngan a sakawa e vevoi. ");
INSERT INTO leu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","A mu rabuna ri falet xe sina ti pe Jerusalem e a mu bina pe Judia e ti pe la mu bina faasilak la Raarum Jordan. ");
INSERT INTO leu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ri kuusan fasavat a mu vilaana saat siri e nane fasuf nari la Raarum Jordan. ");
INSERT INTO leu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Taasaxa, layaan nane kaalum o a mu Ferasi xuvul pana mu Sedusi ri maa savat la bina ina fasufan, a xuus nari, “Nami ve mi tiui pana neng! Naseꞌ pebukan nami pana sinufanaana fakasanaman lava aava i taa savat? ");
INSERT INTO leu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tamo mi fo puk tapin nami xa xasena vilaana saat simi lavaxa, faxalite pana vilaana e faisok faꞌui. ");
INSERT INTO leu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","E muta lamon o mi taa xuus nami xa, ‘Na Abrahem ve na tamataara.’ Senaso ne xuus nami o a Piran a fexaxaas sena fasavat a rafulak xa Abrahem pana mu faat aanabeꞌ! ");
INSERT INTO leu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","A yaamu i taxa waan xo la funa mu wai e a maana wai aava ri pife fasavat a xalana roxo a Piran taa tei tapin nari xe lana fata. ");
INSERT INTO leu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ne fasuf nami pana raarum senaso mi puk a lamonan simi. Taasaxa, saxa i taa savat la miak e a gutan sina a molava sega e senaso nenia, ne mataa palau paaliu ne pife fexaxaas sena tao a ‘slipa’ sina. Nane xo i taa fasuf nami pana Vovau Xaradak e fata. ");
INSERT INTO leu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A ‘fok’ xena fepatoxan a xawa xasena mu kam i taxa waan la mana e i taa gon a bina ina fepatoxan a xawa aave e i taa faxuvul a mu kam ina ‘wiit’ la lifu ina fawaanaana e i taa faram a xawa pana fata aava i taa pife maat.” ");
INSERT INTO leu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na Yesus xo maa savat la Raarum Jordan ti Galili talo na Jon i taa fasufe. ");
INSERT INTO leu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Taasaxa na Jon a tafang taraa pana ti votanaana e a kuus, “A roxo naak nano, no taa fasufau, malaafaa si nano, no maa savat siak xena fasufaan nano?” ");
INSERT INTO leu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","E na Yesus a suie, “Naboxo, i taa waan malaan. A roxo taare taa vil malaane xena faxalit a vilaana fatak paaliu.” E mui na Jon a turoxo pana. ");
INSERT INTO leu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Layaan na Jon fo fasufe, na Yesus a taꞌulan a raarum. E monabeꞌ mon a xunavata talakas e a xalum a vovau sina Piran i taxa sivimaan xuluna malaan sena vaalus. ");
INSERT INTO leu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","E a ling ti laaꞌui la xunavata a kuus, “Nane na natuk, ne vubuxan xasingite, nane fafaamamaasau.” ");
INSERT INTO leu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","E mui a Vovau sina Piran a paamuian lisan na Yesus xe la xobingil talo na Setan i taa valame. ");
INSERT INTO leu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","E na Yesus a falfaal pana yaan sangafilu talafaat xurul e felagai. ");
INSERT INTO leu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na Setan aava saxa xena valamaana, a savat sina e kuus, “Tamo nano ve no Natuna Piran, xuus a mu faat o ri taa savat bret.” ");
INSERT INTO leu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","E na Yesus a suie, “A Xakalayan Taap a kuus: ‘A mataa i taa pife siak a gutan sena bret sang mon taasaxa i taa siaxe sena maana ferawaian aava savat ti la valana Piran.” ");
INSERT INTO leu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","E mui na Setan a lisane xo xe la bina taap, na Jerusalem, e fatigineie laaꞌui paaliu xuluna tang lifu lotu e a kuus, ");
INSERT INTO leu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Tamo nano, no Natuna Piran, tapin fasivi nano xa senaso a Xakalayan Taap a kuus: ‘Nane taa xuus a mu angelo sina pama e nari, ri taa yaas nano xe laaꞌui pana mari talo a kaam i taa pife du sui a faat.” ");
INSERT INTO leu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na Yesus a suie, “E vaxa a Xakalayan Taap a kuus: ‘Muta valam a Memai, a Piran siim.” ");
INSERT INTO leu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","E fulaa, na Setan xo a lisane xe laaꞌui xuluna put modus e faxalite pana mu fatataganan la xavala e a roxoyan siri e a kuus, ");
INSERT INTO leu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Ne taa tavai nano pana maana mo aanabeꞌ tamo no taa bukaak e nangusau.” ");
INSERT INTO leu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","E na Yesus a suie, “Faapalau sega, Setan! Senaso a Xakalayan Taap a kuus: ‘Nangus a Memai, a Piran siim e no taa sisiak sina mon.” ");
INSERT INTO leu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","E mui na Setan a taꞌulane e a mu angelo xo ri maa savat sina e ri xavange. ");
INSERT INTO leu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Layaan na Yesus a langai o na Jon fo vipis, nane ulaa xe Galili. ");
INSERT INTO leu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nane taꞌulan na Nasaret e fe taagul pe Kapanam aava waan la itina raarum pe Sebulan e Naaptali. ");
INSERT INTO leu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","E malaanabeꞌ a ferawaian si Aisaia savat la matavas. Nane kuus: ");
INSERT INTO leu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“A mu rabuna ti pe la ro bina Sebulan e Naaptali, a bina la xasing ina salan aava sivi xe la laman e a bina la vangana Raarum Jordan, a ro bina aave re waan pe Galili e pave a toxan a rabuna xaves aava ri pife Juda- ");
INSERT INTO leu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","a mu rabuna aave xo ri fo taagul la suk e naboxo ri xalum a malang molava; e a malang fo savat xuluri aava ri taagul lapaana xaxaalua ina maatan.” ");
INSERT INTO leu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ti la yaan aave na Yesus a tangpat pana kuusan fasavat a ferawaian sina Piran malaan, “Puk tapin nami xa xasena vilaana saat simi senaso a yaan ina savatan sina fatataganan sina Piran a faasilak.” ");
INSERT INTO leu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","La fena sangasan sina la vangana Laman Galili nane xalum a ro fetinan, na Saimon aava ri xalie pa Pita nare Endru. Re taxa tapin fasivi a vana sire la taas senaso re fuuna faadinan. ");
INSERT INTO leu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","E na Yesus a kuus, “Me maa usiau e ne taa fapiti name pana pataasaana rabuna.” ");
INSERT INTO leu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","E fataapus re taꞌulan a vana sire e re usie. ");
INSERT INTO leu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","A falet famodak fulaa e xalum a xasa rofetinan fulaa, na Jems nare Jon xuvul pa tamare, na Sebedi. Rutul taxa waan xuluna xaati e rutul taxa faigotan a vana sirutul. E na Yesus a xel nare. ");
INSERT INTO leu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","E fataapus re taꞌulan a xaati e na tamare e re usie. ");
INSERT INTO leu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Na Yesus a falet xolai pe Galili e nane fepitaa la maana lifu ina faxuvulan siri e kuusan fasavat a Lagasai Roxo sena fatataganan sina Piran. E a maana buk giisan aava fo sip a rabuna, nane vil faroxoie. ");
INSERT INTO leu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A mu rabuna aave ri xuus fatexaas a xasanofuna pana e mui a mu rabuna xapiak pe Siria ri texaas sena e ri maa lisan a rabuna aava ri giis xe sina: nari pana maana buk giisan e pana maasaxan molava, nari aava vovau saat fo vao nari e nari aava ri gaga e nari aava mari o kari maat. E nane xo a vil faroxoi nari. ");
INSERT INTO leu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A tang malila ti Galili, Jerusalem, Judia e ti la bina Dekaapolis sina mu rabuna aava ri pife Juda e ti la bina la xasa paxasing ina Raarum Jordan, nari xapiak ri usie. ");
INSERT INTO leu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Layaan nane xalum a malila aave, nane laak fadak xe xuluna put e nane nai suꞌ e mu fefeng sina ri maa savat ");
INSERT INTO leu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","e nane fapiti nari malaan: ");
INSERT INTO leu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nari aava ri texaas o ri pife tigina fatak la matana Piran sena mu vilaana siri xa, naboxo a naian siri a roxo paaliu senaso a fatataganan sina Piran va siri. ");
INSERT INTO leu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nari aava ri mimilisaat, naboxo a naian siri a roxo paaliu senaso Piran i taa famalulum nari. ");
INSERT INTO leu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nari aava ri lamon fasivi a isiri xa, naboxo a naian siri a roxo paaliu senaso Piran i taa tavai nari pana xavala xapiak. ");
INSERT INTO leu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nari aava ri lamon vulai pana mu vilaana fatak, malaan sena mataa aava lagai a lamon vulai pana fanganan, naboxo a naian siri a roxo paaliu senaso Piran i taa famasi nari. ");
INSERT INTO leu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nari aava ri muluk a xasanofuna e ri xavang nari, naboxo a naian siri a roxo paaliu senaso Piran i taa muluk nari vaxa. ");
INSERT INTO leu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nari aava vulai ri vubuk sisiak xe sina Piran, naboxo a naian siri a roxo paaliu senaso ri taa xalum a Piran. ");
INSERT INTO leu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nari aava ri lisan a luaian la palou ina rabuna xuvul pana Piran, naboxo a naian siri a roxo paaliu senaso a Piran taa xali nari pana mu rafulak sina. ");
INSERT INTO leu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nari aava rabuna ri vil pengan nari sena usiaana vilaana fatak sina Piran, naboxo a naian siri a roxo paaliu senaso a fatataganan sina Piran va siri. ");
INSERT INTO leu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“A naian simi a roxo paaliu layaan a rabuna ri ferawai fasaat semi e ri vil pengan nami e ri bit tifi nami pana maana bitan saat senaso mi namkai sega. ");
INSERT INTO leu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mi merao e mi faamamaas senaso a sepirigus xami la xunavata a mo molava paaliu. Paamua ri vil pengan a mu rabuna ina kuus fatuxai e naboxo ri taxa vil malaane xe simi sait. ");
INSERT INTO leu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nami aava mi namkai, mi malaan sena sol la palou ina mu rabuna. Taasaxa tamo sol a pife xakaarik malaafaa mi taa faxakaarik fulane? E tamo pife xakaarik a piau ta faisok ina fulaa e a rabuna ri taa tapine e ri paas xolane. ");
INSERT INTO leu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Nami ve mi malang xana mu rabuna la xavala. A bina laaꞌui xuluna put pife fexaxaas sena fufunai. ");
INSERT INTO leu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","E vaxa mu rabuna ri taa pife faram a laam siri e fune lapaana bi o lana vuk ina xariu, bo? Piau! Ri taa faneie xuluna ivin ina talo mu rabuna xapiak la lifu, ri taa fexaxaas sena kaalum. ");
INSERT INTO leu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","E malaanabeꞌ mi taa faxalit a mu rabuna pana malang simi talo ri taa xalum a maana faisok roxo simi e ri taa kuus faatulan na Tamami laaꞌui la xunavata. ");
INSERT INTO leu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Muta lamon o ne fo savat xena kawaasan a mu vuputkai o ferawaian sina mu rabuna ina kuus fatuxai, ne pife savat xena kawaasanaan nari, piau, ne savat xena vil fexaxaasan nari la matavas. ");
INSERT INTO leu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ne xuus tuunei nami, fefexaxaas a yaan a xunavata xuvul pana xavala ri taa malit, piau ta nekalayan modak ti lana xakalayan ina vuputkai i taa malit fefexaxaas a yaan a maana mo aanabeꞌ ri taa savat la matavas. ");
INSERT INTO leu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Naseꞌ laxao a saxa vuputkai modak e fapiti a xasanofuna xena laxawe, i taa mataa palau paaliu lana fatataganan sina Piran. Taasaxa, nane aava langai sena vuputkai e fapiti a xasanofuna pana langaiaana i taa matalava lana fatataganan sina. ");
INSERT INTO leu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Senaso ne xuus nami, tamo a mu vilaana fatak simi ri pife xasliu a mu vilaana sina mu Ferasi e nari aava ri fepitaa pana vuputkai, mi taa pife laak la fatataganan sina Piran. ");
INSERT INTO leu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Lokavai mi fo langai o mu priis ri xuus a rabuna: ‘Muta punuk mataa e naseꞌ a punuk a mataa i taa tigina lapaana tiisan.’ ");
INSERT INTO leu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Taasaxa nenia, ne xuus nami o naseꞌ ta mataa a maraleian na tina i taa waan lapaana tiisan. E fulaa, naseꞌ ta mataa a xuus na tina o ‘A putum a faat!’ nane, a mu matalava ri taa tiise. Taasaxa, naseꞌ ta mataa a kuus pana ‘No vavagai!’, i taa fakasanaman lana fata aava i taxa raam vulai. ");
INSERT INTO leu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“E voxo tamo no taxa laak la lifu lotu xena lisan a tatavai siim xe sina Piran e no lamon faꞌuli a saxa tiam a maraleian nano, ");
INSERT INTO leu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taꞌulan a tatavai siim la nona ivin ina faramaana tatavai e falet paamu xe si tiam e vil faroxoi a waanan sime e mui no taa fe lotu pana tatavai siim. ");
INSERT INTO leu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Tamo saxa mataa rao i lisan nano xe la bina ina tiisan, vil faroxoi fatapusan a lagafan sina. Vile layaan me taxa falet xe la bina ina tiisan ulaa i tamaa lisan nano xe sina mataa ina tiisan e nane xo i taa lisan nano xe sina mataa ina faxatang a mu vipis e naak i taa pis nano. ");
INSERT INTO leu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ne xuus tuunei nano o no taa pife mulus tapinan fefexaxaas no taa sui xapin a maana faat xapiak. ");
INSERT INTO leu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Nami, mi texaas o paamua ri kuus, ‘Muta mati xuvul pana saxa aava fo tamai.’ ");
INSERT INTO leu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Taasaxa nenia, ne xuus nami o naseꞌ ta mataa a kaalum xe sina tefin xena nanoman a vilaana saat xuvul pana, nane fo mati xuvul pana xo lana lamonan sina. ");
INSERT INTO leu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","E tamo a mataam pamuaan a fasavat a vilaana saat malaan, put tapine. Senaso tamo i taa waan i taa kawaasan a toyan xapiak siim. A mo roxo o a xavil modak ina taam i taa malit talo a taam xurul i taa pife waan la vaaꞌul ina fakasanaman pana fata. ");
INSERT INTO leu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","E malaan sena mataam, tamo a maam pamuaan a fasavat a vilaana saat, patal tapine. A mo roxo a xavil modak ina taam i taa malit talo a taam xurul i taa pife waan la vaaꞌul ina fakasanaman pana fata. ");
INSERT INTO leu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ri fo kuus o naseꞌ ta mataa a taꞌulan na naasana i taa tavaie pana lagasai xena fataxapin a tamaian sire. ");
INSERT INTO leu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Taasaxa, ne xuus nami o a mataa a fexaxaas sena taꞌulan na naasana pana fufuna saxa mon: tamo a tefin xo a mati xuvul pana xasafuna. Tamo a mataa a taꞌulan a tefin sina e a tefin aave a tamai fulaa, a mataa aave fo vil favupunoie sena tamaian faꞌui aava saat. E nane aava tamai sina tefin aave, i taxa vil a vilaana saat sait. ");
INSERT INTO leu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Lokavai mi fo langai o ri xuus a rabuna, ‘Muta bit sena fakalimaanan simi. Taasaxa vil fasavat a maana mo aava mi fakalimaan pana xe sina Memai.’ ");
INSERT INTO leu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Taasaxa nenia, ne xuus nami, muta fakalimaan pana isina saxa mo. Muta fakalimaan pana xunavata senaso Piran taxa nai paamuian a rabuna pave ");
INSERT INTO leu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","e muta fakalimaan pana xavala senaso a vena vaapaas sina o pa Jerusalem senaso a bina sina King Lava. ");
INSERT INTO leu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","E muta fakalimaan pana putum senaso no pife fexaxaas sena lamon faati o a fui siim i taa savat pasak o maxata. ");
INSERT INTO leu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Layaan no ferawai, kuus mon pana ‘aang’ o ‘piau’. A so ta mo no kuus pana fulaa a savat sena saxa aava saat paaliu, na Setan. ");
INSERT INTO leu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mi fo langai pana ferawaian malaan: ‘Tamo a mataa i taa kawaasan a matana saxa mataa, lavaxa a matana mataa aave i taa kawaasanan. E tamo saxa i taa kawaasan a fana xasa mataa, a fana mataa aave i taa kawaasanan sait.’ ");
INSERT INTO leu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Taasaxa nenia, ne xuus nami, muta susuaa xe sina mataa aava bilai fasaat xe simi. Tamo saxa i taa tavaf a yaavaam, ti tapuk e lisan a xasa payaavaam. ");
INSERT INTO leu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","E tamo saxa taa lisan nano xe lana lifu ina tiisan xena siak a ‘siot’ siim lavaxa, tavaie pana marapi ina xakaafutan sait. ");
INSERT INTO leu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","E tamo ta saxa taa xuus faagutan nano pana yaasaana mo matafan sina xe lasuun fadak, falet xuvul pana xe lasuun paaliu. ");
INSERT INTO leu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","E layaan ta mataa taa nung nano panꞌ ta mo, tavaie pana. Layaan ta mataa a vubuxan a mo siim, muta kuus o piau. ");
INSERT INTO leu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mi texaas sena xakalayan aava kuus malaan: ‘Vubuxan xasingit a mu pabung simi e baian faagutan a mu xaiyaas.’ ");
INSERT INTO leu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Taasaxa nenia, ne xuus nami, vubuxan xasingit a mu xaiyaas simi e fenung xe sina Piran talo i taa xavang nari aava ri vil pengan nami. ");
INSERT INTO leu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","A vilaana malaan i taa faxaalit o nami, mi rafulak si Tamami pe la xunavata. Senaso nane a vil falak a ngaas xena malang la mu bina xapiak sina mu rabuna roxo e saat. E a lisan a raafui xena xavang a mu rabuna xapiak, nari aava ri bilai faroxo e nari aava ri bilai fasaat. ");
INSERT INTO leu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Xenaso a Piran i taa fasepirigus nami tamo mi vubuxan xasingit a rabuna aava ri vubuxan xasingit nami mon? A mu rabuna ina siak taakis xana paamua lava ti Rom vaxa, ri vil malaane. ");
INSERT INTO leu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","E tamo mi fasusui a mu timi mon mi pife vil ta mo roxo sena xasafuna, bo? A mu rabuna aava ri pife namkai sena Piran, nari vaxa ri vil malaane. ");
INSERT INTO leu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","E voxo nami xo mi taa tigina fatak vulai malaan sena Tamami pe la xunavata i taxa tigina fatak vulai.” ");
INSERT INTO leu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Na Yesus a ferawai fulaa e pebukan nari, “Faxatang! Muta vil a maana faisok roxo la matavas talo a mu rabuna ri taa xalume. Senaso tamo mi vil malaane na Tamami pe la xunavata i taa pife tavai nami pana sepirigus. ");
INSERT INTO leu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“E voxo, layaan mi xavang a mu valagof, muta kuusane pana piifaana tafiu malaan sena mataa xalemana maranga. Senaso nari, ri vil malaane la lifu ina faxuvulan siri e la salan talo a mu rabuna aava ri xalum nari, ri taa faatulan nari. Ne xuus tuunei nami o a Piran taa pife tavai nari panꞌ ta sepirigus fulaa. ");
INSERT INTO leu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Taasaxa, layaan mi xavang a valagof, vil fune talo piau ta mataa fulaa i taa texaas sena. ");
INSERT INTO leu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","E a Piran, na Tamami aava xalum a maana mo mi vil fune, i taa fasepirigus nami. ");
INSERT INTO leu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Layaan mi fenung, muta vile malaan sena mu xalema maranga. Senaso nari, ri buk fenung la lifu ina faxuvulan e pe la femarangaian ina salan talo maana rabuna xaves ri taa xalum nari. Ne xuus tuunei nami o a Piran taa pife tavai nari panꞌ ta sepirigus fulaa. ");
INSERT INTO leu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Taasaxa, layaan mi fenung, laak la nobina simi talo mi taa waan nami sang mon; xao a matana nobina aave e fenung xe si Tamami aava waan pave xuvul pami. E na Tamami aava xalum a so ta mo mi vile pave, i taa fasepirigus nami. ");
INSERT INTO leu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Layaan mi fenung, muta ferawai pana maana vapaling palau malaan sena mu rabuna aava ri pife Juda. Nari, ri lamon o a Piran taa sui a fenungan siri senaso ri ferawai faaxaves. ");
INSERT INTO leu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Muta usi a vilaana siri senaso na Tamami, nane texaas sena so ta mo mi xaxaalif pana paamuina yaan mi fine pana. ");
INSERT INTO leu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Mi taa fenung malaanabeꞌ: ‘Tamamaam pe la xunavata, a isaam a xaradak paaliu e maam suai faagut sena. ");
INSERT INTO leu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","A fatataganan siim i taa savatmaan e a mu vubuxanan siim ri taa savat la matavas la palou imaam malaan seꞌ ri savat la xunavata. ");
INSERT INTO leu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tavai nemaam pana fanganan a fexaxaas xe tanin. ");
INSERT INTO leu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","E lamon tapin a maana vilaana saat simaam malaan semaam xo maam fo lamon tapin a mu vilaana saat sina xasanofuna xe simaam. ");
INSERT INTO leu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","E muta lisan nemaam xe lana vavalam taasaxa tivotan nemaam xasena gutan ina saatan.’ ");
INSERT INTO leu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tamo mi lamon tapin a vilaana saat sina xasanofuna aava ri vile xe simi, na Tamami pe la xunavata, i taa lamon tapin a vilaana saat simi vaxa. ");
INSERT INTO leu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Taasaxa tamo mi pife lamon tapin a vilaana saat sina xasanofuna lavaxa, na Tamami i taa pife lamon tapin a vilaana saat simi. ");
INSERT INTO leu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Layaan mi falfaal, muta falet xolai pana nonau kanamsaat malaan sena mu xalema maranga. Ri falet xolai pana nonau vusiit talo mu rabuna ri taa xalum nari o ri taxa falfaal. Ne xuus tuunei nami o a Piran i taa pife tavai nari panꞌ ta sepirigus fulaa. ");
INSERT INTO leu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Layaan mi falfaal, xamak a nonau imi e salei fati a fui simi ");
INSERT INTO leu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","talo a rabuna ri taa pife xalum a falfaalan simi. Na Tamami sang mon aava mi pife fexaxaas sena xalume, nane xa taa texaas. E nane aava xalum a maana mo fufunai mi fuuna vile, i taa fasepirigus nami. ");
INSERT INTO leu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nabeꞌ la xavala, muta faxuvul a fafanaian senaso nabeꞌ a yainiit e vusulai re kawaasan a maana mo aave e mu rabuna ina fenau ri taa kas a lifu e ri fenoue. ");
INSERT INTO leu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Taasaxa laaꞌui la xunavata mi taa faxuvul a maana fafanaian roxo senaso pave a yainiit e vusulai re taa pife kawaasan a maana mo aave e mu rabuna ina fenau ri taa pife laak lana xena fenau. ");
INSERT INTO leu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Senaso la so ta bina mi faxuvul a maana fafanaian roxo simi lana, a bina aave mi taa lamon fatie. ");
INSERT INTO leu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“A ro matami ve re ro laam xena famalang a tami. Tamo a matami a tateak e matavas, a tami xurul i taa bas pana malang. ");
INSERT INTO leu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Taasaxa, tamo a matami a saat e gagaali, a tami xurul i taa bas pana suk. E tamo a malang aava waan la tami a suk, a suk aave a molava temasaat. ");
INSERT INTO leu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“A mataa a pife fexaxaas sena yaasok lapaana ro mataa piran, piau. Senaso i taa baian a saxa e vubuxan a saxa o i taa faisok faagut lapaana saxa e langai pesalai sena saxa. Mi pife fexaxaas sena faisok lapaana Piran e la yaan naang faisok xena faxuvulaana faat xaanum xa. ");
INSERT INTO leu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“E voxo ne xuus nami, muta lalamon faaxaves sena toyan simi: sena so ta mo mi taa ngane o nume o sena so ta marapi mi taa xafut a tami pana. A toyan simi a molava sena fanganan e a tami a molava sena marapi, bo? ");
INSERT INTO leu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kaalum pana mu maanu la tavegof: ri pife xapis a kam o faxuvul a fanganan xena timine la lifu ina fawaanaana. Taasaxa na Tamami pe la xunavata, nane faxatang faroxoi nari. E nami, lana lamonan sina Piran, mi pelalava sena maanu, bo? ");
INSERT INTO leu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","E naseꞌ a fexaxaas sena famodus a waanan sina nabeꞌ la xavala pana lalamon faaxaves? ");
INSERT INTO leu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Xenaso mi taxa lalamon faaxaves sena marapi? Lamon pana mu fur pe la yi, ri pife faisok o vesan a mo xena xafut nari. ");
INSERT INTO leu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Taasaxa ne xuus nami o na King Solomon aava toxan a fafanaian xaves, nane pi ta marapi magaaf malaan seri. ");
INSERT INTO leu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tamo a Piran i taa famaus a yi aava waan tanin e mafu ri sung a fata pana, naak i taa tamana tavai nami pana marapi xena xafut nami xa, bo? Ai, a namkaian simi a modak paaliu! ");
INSERT INTO leu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","E voxo muta lalamon faaxaves e kuus malaan: ‘A fanganan siak i taa savat ti faa? o a numan siak? o marapi siak?’ ");
INSERT INTO leu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","A mu rabuna aava ri pife namkai sena Piran, ri fuuna lalamon faaxaves sena maana mo malaan. Taasaxa na Tamami pe la xunavata, nane texaas o mi vubuxan a maana mo aave. ");
INSERT INTO leu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","E voxo nami, mi taa seng paamuin a fatataganan sina Piran e a vubuxanan fatak sina e layaan mi vil malaane, nane xo i taa tavai nami pana maana mo xapiak aave vaxa. ");
INSERT INTO leu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","E voxo, muta lalamon faaxaves pana so ta mo i taa savat mafu. A yaan mafu a toxan a lagafan sina xa. A lagafan ti tanin mon a fexaxaas, muta falavaie. ");
INSERT INTO leu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Muta tiis a xasanofuna talo no taa pife tiisan. ");
INSERT INTO leu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Senaso no taa tiisan malaan seꞌ no tiis a xasanofuna. E so ta buk ngangai aava no tiis a xasanofuna pana no taa tiisan pana vaxa. ");
INSERT INTO leu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Senasou no xalum a wai modak la mata tiam taasaxa no pife lamon pana wai modus aava waan la mataam? ");
INSERT INTO leu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Xenaso no taa xuus na tiam, ‘Man, ne taa siak tapin a newai modak la mataam’ layaan nano xa no toxan a wai modus la mataam. ");
INSERT INTO leu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mataa xalema maranga! Paamua xo, siak tapin a wai modus la mataam xa e mui, layaan no kaalum famatavas, no taa siak tapin a wai modak la mata tiam. ");
INSERT INTO leu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Muta tavai a mu piu pana mo motaap; muta tapalan a mo roxo paaliu malaan sena xixiut la nona mu vio. Tamo no vil malaane, ri tamaa paas xolane e ti tapuk faꞌulaa xena falou nano. ");
INSERT INTO leu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Fin a Piran pana maana mo aava no vubuxane e no taa siaxe, seseng e no taa tingine, vipit la matana lifu sina Piran e i taa kase xe siim. ");
INSERT INTO leu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Senaso naseꞌ ta mataa i taa fiai i taa siaxe; naseꞌ ta mataa i taa seseng i taa tingine; naseꞌ ta mataa i taa vipit la matana lifu sina Piran i taa kase xe sina. ");
INSERT INTO leu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nami mu tamana rafulak, mi taa pife tavai a lak simi pana faat layaan a fin nami pana bret, bo? ");
INSERT INTO leu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O tamo a fin nami pana din mi taa pife tavaie pana tiui, bo? ");
INSERT INTO leu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","E tamo nami aava mi rabuna saat, mi tavai a mu rafulak simi pana maana mo roxo, tuuna paaliu na Tamami pe la xunavata, i taa tavai nari aava ri fine, pana maana mo roxo. ");
INSERT INTO leu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","E voxo, lana maana mo xapiak bilai xe sina xasanofuna malaan seꞌ no vubuk o ri taa bilai xe siim: a vilaana aanabeꞌ a fufuna mu vuputkai e mu fepitaian sina mu rabuna ina kuus fatuxai. ");
INSERT INTO leu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","“A salan aava falet xe la bina ina kawaas vulai a molava e a matana yalaxau xe pave a talakas falava e maana rabuna xaves ri sangas usi a salan aave. Taasaxa matana yalaxau xe sina toyan tuuna a modak e a salan xe pave a modak paaliu e piau ta rabuna xaves ri tingin a salan aave. Taasaxa nano, no taa laak xe lana matana yalaxau aave xena siak a toyan vulai. ");
INSERT INTO leu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Faxatang sena mu rabuna ina kuus fatuxai bit. Ri savat simi pana vilaana mam malaan sena sipsip taasaxa lana xunus iri ri malaan sena piu vupung. ");
INSERT INTO leu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mi taa taraxali nari sena vilaana siri. A yeis tuturuk pife fasavat a xalana wain marafut e a yi palau pife fasavat a xalana xakaap. ");
INSERT INTO leu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","A wai roxo e tateak i taa fasavat a xalana marafut taasaxa a wai aava pife boak faroxo i taa fasavat a xalana mopaak aava pife roxo. ");
INSERT INTO leu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A wai roxo e tateak pife fexaxaas sena fasavat a xalana mopaak aava pife roxo e a wai aava pife boak faroxo pife fexaxaas sena fasavat a xalana marafut e roxo. ");
INSERT INTO leu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","E ta wai aava pife fasavat a xalana roxo i taa tei tapinan xe lana fata. ");
INSERT INTO leu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","E voxo, mi taa taraxali a mu rabuna ina kuus fatuxai bit sena vilaana siri. ");
INSERT INTO leu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Pife nari xapiak aava ri fuuna xali vulanau pana Memai siri, ri taa laak la fatataganan sina Piran, piau. Nari aava ri usi fatak a vubuxanan si Tamaang pe la xunavata mon, ri taa laak lana. ");
INSERT INTO leu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Layaan a yaan ina tiisan taa savat a maana rabuna ri taa xuusau, ‘Memai, Memai! Maam kuusan fasavat a Lagasai sina Piran lapaana gutan ina isaam, bo? E maam gei tapin a maana vovau saat e vil a maana mo faꞌipul lapaana gutan ina isaam, bo?’ ");
INSERT INTO leu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","E nenia, ne taa xuus nari, ‘Ne ngalngolan nami. Faapalau sega, nami aava mi vil a mu vilaana saat.’ ");
INSERT INTO leu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“E voxo naseꞌ ta mataa a langai a ferawaian siak e usie, i taa malaan sena mataa pana texaasan aava vesan a lifu sina xuluna faat tateak. ");
INSERT INTO leu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","E a raafui a molava e a ulim molava a savat e a reref a fiit faagutan a lifu aave e pife poxo senaso a fufuna tateak. ");
INSERT INTO leu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Taasaxa naseꞌ ta mataa a langai pesalai sena ferawaian siak, nane malaan sena mataa vungut aava vesan a lifu sina la gun tataavus. ");
INSERT INTO leu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","E a raafui a molava e a ulim molava a savat e a reref a fiit faagutane e poxo. E a lifu aave a tagalas xapiak.” ");
INSERT INTO leu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Layaan na Yesus fo fataxapin a ferawaian aanabeꞌ a malila ri ipulan a fepitaian sina. ");
INSERT INTO leu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Senaso nane pife fepitaa malaan sena mu rabuna ina fepitaa pana vuputkai, piau, a fepitaian sina a toxan a gutan ina. ");
INSERT INTO leu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Layaan na Yesus a sivimaan ti xuluna put a malila ri usie. ");
INSERT INTO leu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","E lana yaan naang a mataa tana tapak maa bukaak la ka Yesus e kuus, “Memai, tamo no vubuxane no fexaxaas sena vil faroxoiau.” ");
INSERT INTO leu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na Yesus a talangai xe sina pana mana e tawe e a suie, “Aang, ne vubuxane. Savat roxo!” A tana mataa aave a savat roxo faꞌipul sena giisan sina. ");
INSERT INTO leu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","E na Yesus a xuuse, “Langai! Muta xuus ta mataa pana. Falet fatak xe sina priis talo i tafe taxan faroxoi a taam, e mui no taa tatavai pana mo aava na Moses a kuus pana xena faxalit a rabuna pana vil faroxoiaan nano.” ");
INSERT INTO leu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Layaan na Yesus a laak la bina Kapanam a saxa paamua ina rawen ti Rom a savat sina e fenung pana xakaavangan sina malaan, ");
INSERT INTO leu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Matalava, a sisiak siak pe la lifu, a giis la ivin sina. A pife fexaxaas sena falet xolai e taxa maasak faagut.” ");
INSERT INTO leu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Na Yesus a kuus, “Ne taa fe vil faroxoie.” ");
INSERT INTO leu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Taasaxa paamua aave a suie, “Piau Matalava, no taa pife savat la lifu siak senaso nano, no matalava e nenia, ne mataa palau. No taa kuus mon e a sisiak siak i taa roxo fulaa. ");
INSERT INTO leu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nenia sait, ne waan lapaana tateaxan ina paamua siak e ne toxan a rabuna ina rawen lapaana tateaxan iga. Ne taa xuus a saxa pana ‘Falet!’ e a falet; ne xuus a saxa pana ‘Man’ e a filimaan e ne xuus a saxa yaasok siak pana ‘Vil a mo aanabeꞌ’ e nane vile.” ");
INSERT INTO leu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Layaan na Yesus a langai pana mo aanabeꞌ a ipul faagut sena e a kuus xe sina mu rabuna aava ri waan xuvul pana, “Ne xuus tuunei nami, ne pi titingin ta saxa pe Israel pana namkaian malaanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ne xuus nami o maana rabuna ri taa savat ti paa e ti kol e taa nai la fenamo molava lana fatataganan sina Piran xuvul pa Abrahem, Aisaak nari na Yaakop. ");
INSERT INTO leu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Taasaxa, nari aava Piran a siak fati nari paamua, ri taa tapinan xe lana suk e pave ri taa taangiis faagut e faxakengat a fari.” ");
INSERT INTO leu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","E mui na Yesus a xuus a paamua ti Rom, “Falet xe la lifu siim e a so ta mo no namkai sena i taa savat la matavas xe siim.” E a sisiak sina paamua aave a savat roxo monabeꞌ mon. ");
INSERT INTO leu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Layaan na Yesus a laak la lifu si Pita, nane xalum na imu Pita taxa mati la ivin pana tana lalagaf. ");
INSERT INTO leu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nane tao a mana e a lalagaf a malit faꞌipul e a tana feroxo e nane tamasiak e faigotan a fanganan xana. ");
INSERT INTO leu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","La vung aave a rabuna ri lisanmaan a mu rabuna pana vovau saat xe si Yesus. E na Yesus pana ferawaian mon a gei tapin a mu vovau saat e a vil faroxoi nari xapiak aava ri toxan a maana buk giisan. ");
INSERT INTO leu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","E malaanabeꞌ nane fasavat famatavas a maana mo aava na Aisaia, saxa mataa ina kuus fatuxai, fo ferawai pana. A kuus, “Nane xa a siak tapin a giisan sitaara e mulus tapin netaara sena maasaxan.” ");
INSERT INTO leu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lavaxa, layaan na Yesus a kaalum o a malila ri fakaliuane, nane fasei faagutan a mu fefeng sina o ri taa falet fatak xe la xasa paxasing ina raarum. ");
INSERT INTO leu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","E saxa mataa ina fepitaa pana vuputkai maa savat sina e a kuus, “Mataa ina Fepitaa, ne taa usi nano tamo no falet xe faa.” ");
INSERT INTO leu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","E na Yesus a suie, “A mu piu vupung ri toxan a liing siri e mu maanu la tavegof ri toxan a singa siri, taasaxa a Natuna Mataa piau ta nobina xena mati fangaafus.” ");
INSERT INTO leu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A saxafuna aava usi na Yesus, a kuus, “Memai, paamua turoxo o ne taa fe xaafan na Tamaang.” ");
INSERT INTO leu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Taasaxa na Yesus a suie, “Usiau e taꞌulan a mu rabuna aava ri fo maat xena xaafan a mamaat siri xa.” ");
INSERT INTO leu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Layaan na Yesus a xawas xuluna xaati a mu fefeng sina ri xawas sait. ");
INSERT INTO leu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","E a tang reref molava xuvul pana raafui re savat faꞌipul la laman e a xaati aave faasilak i lus. Taasaxa na Yesus i taxa matef. ");
INSERT INTO leu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A mu fefeng sina ri fe faparaye e ri kuus, “Memai! Fakaxup netaara ulaa taara tamaa xarak!” ");
INSERT INTO leu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na Yesus a sui nari, “Xenaso mi mataut temasaat? A namkaian simi a modak paaliu, bo?” E mui a tamasiak e fasei a reref e tof molava pana re taa taxapus e a reref e tof molava re mararol. ");
INSERT INTO leu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","E nari xapiak ri ipul e ri kuus, “Nane naseꞌ? Nane ve a so ta buk mataa? A reref e tof molava re langaie.” ");
INSERT INTO leu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Layaan na Yesus maa savat la xasa paxasing ina raarum la bina ri xalie pa Gadarin, a rovaat tomexaan pana maana masalai re savat ti la matana xawaa e re fesuaian na Yesus. A rovaat aave re toxan a gutan molava e a rabuna ri pife fexaxaas sena sangas liu et la salan aave. ");
INSERT INTO leu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","E layaan re xalum na Yesus re xukulai faagut, “Rao no sivin nemaame, Natuna Piran? No fo savat xena fakasanamaan nemaame paamuina yaan fatak ina tiisan, bo?” ");
INSERT INTO leu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","A toxan a tagaan vio taxa waan faasilak e ri taxa fangan. ");
INSERT INTO leu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","E a mu masalai ri nung na Yesus, “Tamo no feng tapin nemaam xasena rovaat aanabeꞌ feng nemaam xe lana tagaan vio aapave.” ");
INSERT INTO leu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","E na Yesus a xuus nari, “Falet!” E voxo ri taꞌulan a rovaat aave e ri fe vao a tagaan vio. A mu vio xapiak ri fala sivi ti la xasing ina put xe lana raarum aave e ri fexarak e ri maat. ");
INSERT INTO leu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","A mu tomexaan aava ri fuuna faxatang a tagaan vio aave ri sinuf xe la bina faasilak e pave ri kuusan a xuuskuus xurul e a so ta mo a savat sina rovaat tomexaan aava mu masalai fo taꞌulan nare. ");
INSERT INTO leu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","E voxo a mu rabuna xapiak ti la bina ri fesuaian na Yesus. Layaan ri xalume, ri nung faagutane o i taa taꞌulan a bina siri. ");
INSERT INTO leu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Lavaxa, na Yesus a xawas xuluna xaati e fe ulaa xe la xasa paxasing ina raarum xe la bina fatak sina. ");
INSERT INTO leu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","E pave, ri lisan a mataa maalapen aava mati la ivin xe sina. Layaan a xalum nari, a texaas o a namkaian siri a tateak e a kuus xe sina mataa maalapen, “Muta mataut, ka fesing! A mu vilaana saat siim fo lamon tapinan.” ");
INSERT INTO leu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","E saxano rabuna ina fepitaa pana vuputkai ri fexuus nari xa, “A mataa aanabeꞌ a lamon o nane ve a Piran! I taxa sarak sena Piran!” ");
INSERT INTO leu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Taasaxa na Yesus a texaas sena so ta mo ri taxa lamon pana e a kuus, “Xenaso mi taxa lamon pana maana mo mosaat malaan? ");
INSERT INTO leu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ne fexaxaas sena kuus, ‘A vilaana saat siim fo lamon tapinan,’ o ‘tamasiak e sangaset’. A so ta mo a malui sega xena ferawai pana? ");
INSERT INTO leu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Taasaxa ne taa faxalit nami o a Natuna Mataa a toxan a tateaxan xena lamon tapin a vilaana saat nabeꞌ la xavala.” E nane xuus a mataa maalapen, “Tamasiak, yaas a ivin siim e no ulaa xe la lifu siim!” ");
INSERT INTO leu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A mataa aave a tamasiak e ulaa xe la lifu sina. ");
INSERT INTO leu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Layaan a rabuna ri xalume, ri mataut e ri kuus faatulan a Piran senaso nane tavai a rabuna pana tateaxan malaan. ");
INSERT INTO leu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Layaan na Yesus i taxa taꞌulan a bina aave a xalum a mataa ina siak taakis i taxa nai la nobina faisok sina, a isina na Matiu. E na Yesus a xuuse, “Usiau.” E na Matiu a tamasiak e usie. ");
INSERT INTO leu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","E lumui layaan na Yesus taxa fangan xuvul pa Matiu, a maana rabuna xaves ina siak taakis xuvul pana xasano rabuna saat ri maa nai fangan xuvul pa Yesus e mu fefeng sina. ");
INSERT INTO leu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Saxano Ferasi ri xalum a vilaana aanabeꞌ e ri fin a fefeng si Yesus, “Xenaso a matalava simi a fangan xuvul pana rabuna saat malaanabeꞌ?” ");
INSERT INTO leu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","E na Yesus a langai e sui nari, “A mataa ina irin a pife xavang nari aava ri piau ta giisan taasaxa i taa xavang nari aava ri giis. ");
INSERT INTO leu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Falet e lamon pana malasuf ina ferawaian sina Piran aava kuus, ‘Ne vubuxan a vilaana ina fangaasik e pife vilaana ina tatavai pana mu tiir.’ Ne fo savat xena xelaana rabuna saat talo ri taa usiau e pife xena xelaan nari aava ri roxo.” ");
INSERT INTO leu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","E mui a mu fefeng si Jon ina Fasufan ri maa savat si Yesus e ri fine, “Xenaso nemaam e mu Ferasi maam fuuna falfaal faaxaves taasaxa mu fefeng siim ri pi ri falfaal?” ");
INSERT INTO leu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na Yesus a sui nari, “Mi lamon o a mu fesing sina mataa aava i taa tamai, ri taa kanamsaat layaan ri taxa waan xuvul pana fesing siri, bo? Piau, ri taa pife kanamsaat. Taasaxa a yaan i taa savat layaan a mataa aava tamai, i taa pife fexaxaas sena waan xuvul pari e lana yaan aave ri taa falfaal. ");
INSERT INTO leu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Piau ta mataa i taa kap a marapi ina vupung xavai pana nemarapi faꞌui. Senaso, layaan i taa xamak a marapi faꞌui i taa gat e i taa ririk falavai a valof ina vupung aave. ");
INSERT INTO leu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","E vaxa, piau ta mataa i taa timin a raarum ina xalana wain lana saxa mo aava ri vesane pana vipin xavai ina meme aava pagala senaso, layaan a raarum ina xalana wain aave i taa siak vuvusen lana, i taa tuguput a vipin pagala aave. E a raarum ina xalana wain aave i taa talatiu e a mu vipin ri taa kawaasanan. Taasaxa ri taa timin a raarum ina xalana wain lana mo ina vipin aava faꞌui e i taa fadatan talo nare xapiak re taa waan faroxo.” ");
INSERT INTO leu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Layaan na Yesus i taxa ferawai xe siri pana maana mo aanabeꞌ a saxa paamua sina mu Juda maa savat sina e bukaak la nona e a kuus, “A lak tefin siak fo maat monabeꞌ mon. Taasaxa tamo no taa tao a putuna i taa to faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","E na Yesus a tamasiak e usie xuvul pana mu fefeng sina. ");
INSERT INTO leu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Layaan na Yesus taxa sangas et a tefin aava toxan a lagafan pana ragei lava pana mariaas sangafilu saxa pana taragua, a savat la mina senaso a ilisai, “Naak ne taa tao a marapi sina mon e ne taa roxo fulaa.” E voxo a tao a xasing ina marapi sina. ");
INSERT INTO leu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na Yesus a tapuk faꞌulaa e a xalume e a kuus, “Muta mataut, tefin! A namkaian siim fo vil faroxoi nano.” E monabeꞌ mon a tefin aave a roxo. ");
INSERT INTO leu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","E mui na Yesus a laak la lifu sina paamua aave. Layaan a xalum a rabuna ri taxa piif farawei a tungaal ina xaxaafai e mu rabuna ri taxa tangiis a mamaat ");
INSERT INTO leu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","a kuus, “Faapalau, a lak tefin aave pife maat, i taxa matef mon.” E nari, ri nangan xuluna. ");
INSERT INTO leu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Taasaxa layaan a paamua aave fo feng tapin a malila xe lamalei na Yesus a laak xe la nobina aava lak tefin taxa mati lana e fe tao a mana e nane tamasiak. ");
INSERT INTO leu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A kuusanaana mo aave a falet xolai la mu bina xapiak. ");
INSERT INTO leu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","E na Yesus a taꞌulan a bina aave e lana sangasan sina a rovaat aava matare piif, re usie e re xukulai, “Natu Devit, Muluk nemaame!” ");
INSERT INTO leu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Layaan nane fo laak la lifu, a rovaat aave re maa savat sina e nane fin nare, “Me namkai o ne fexaxaas sena vil faroxoi name, bo?” E re suie, “Aang, Matalava.” ");
INSERT INTO leu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","E na Yesus a tao a matare e a kuus, “I taa savat malaan sena namkaian sime!” ");
INSERT INTO leu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","E re fexaxaas sena kaalum fulaa. Na Yesus a xuus faagutan nare, “Muta xuus fatexaas ta mataa pana.” ");
INSERT INTO leu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Taasaxa layaan re falet, re fexuus a maana rabuna xaves la maana mu bina xapiak, pana. ");
INSERT INTO leu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Layaan a rovaat aave re taxa falet, saxano rabuna ri lisan a mataa aava po sena vovau saat, xe si Yesus. ");
INSERT INTO leu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","E layaan na Yesus a gei tapin a vovau saat aave a mataa aava tamu po a ferawai. A mu rabuna ri ipul e ri kuus, “Taara pi xaxalum ta mo malaanabeꞌ pe Israel.” ");
INSERT INTO leu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Taasaxa mu Ferasi ri kuus, “Nane fuuna gei tapin a mu vovau saat lapaana gutan sina paamua lava ina mu vovau saat.” ");
INSERT INTO leu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na Yesus a falet xe la maana mu bina lava e modak e fepitaa la mu lifu ina faxuvulan siri e kuusan fasavat a Lagasai Roxo sena fatataganan sina Piran e vil faroxoi a rabuna pana maana buk giisan xapiak. ");
INSERT INTO leu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Layaan a xalum a malila, a muluk nari senaso ri lamon faaxaves sena maana mo e ri piau ta saxa xena xavang nari. Ri malaan sena mu sipsip aava ri piau ta mataa xena faxatang nari. ");
INSERT INTO leu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","E a xuus a mu fefeng sina, “A mu rabuna aanabeꞌ ri malaan sena fanganan la uma aava matoxol. Taasaxa rabuna ina faisok ri pife xaves fexaxaas xena faxuvule. ");
INSERT INTO leu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Fenung xe sina Piran aava mataa tafuna uma aave o i taa feng a maana rabuna ina faisok xe la uma xena faxuvul a fanganan aava matoxol.” ");
INSERT INTO leu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na Yesus a xel faxuvul a mu yaamut sangafilu saxa pana taragua sina e tavai nari pana tateaxan xena gei tapin a mu vovau saat e vil faroxoi a rabuna pana maana buk giisan xapiak. ");
INSERT INTO leu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","A isina mu yaamut sangafilu saxa pana taragua aave a malaan: paamua, na Saimon aava ri xalie pa Pita xuvul pa tina, na Endru e na Jems xuvul pa tina, na Jon aava re ro lak si Sebedi. ");
INSERT INTO leu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","E na Filip nare Baatalamiu, na Tomas nare Matiu aava mataa ina siak taakis; na Jems aava lak si Elfias e na Taadius, ");
INSERT INTO leu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na Simon aava waan la parabuna ri xalie pana Selot e na Judas Iskeriot aava pet lisan na Yesus. ");
INSERT INTO leu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Na Yesus a feng a mu yaamut sangafilu saxa pana taragua aanabeꞌ e a xuus nari, “Muta falet xe lanꞌ ta bina sina mu rabuna aava ri pife Juda o xe lanꞌ ta bina sina mu Sameria. ");
INSERT INTO leu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Taasaxa, mi taa falet xe sina mu Israel senaso ri malaan sena mu sipsip aava ri milung. ");
INSERT INTO leu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Falet e kuus fasavat malaan, ‘A fatataganan sina Piran i taxa waan faasilak.’ ");
INSERT INTO leu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Vil faroxoi a mu rabuna aava ri giis, fatatoi faꞌuli a mu mamaat, vil faroxoi nari pana tari tapak e gei tapin a mu masalai. Mi fo siak xatam a tateaxan xena faisok aanabeꞌ e voxo mi taa xavang xatam a rabuna. ");
INSERT INTO leu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Muta siak ta faat, ");
INSERT INTO leu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","muta yaas a bi pana maana mo pami; muta siak a marapi ina vupungan o ‘slipa’ o xipa fulaa. A rabuna ri taa fakas a mataa ina faisok pana fanganan e a maana mo xana. ");
INSERT INTO leu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Layaan mi savat la bina lava o modak, laak lana e seng a mataa roxo aava i taa kas a lifu sina xe simi e waan xuvul pana fefexaxaas a yaan mi taꞌulan a bina aave. ");
INSERT INTO leu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Layaan mi laak lana lifu aave fasusui nari malaan, ‘A luaian i taa waan xulumi.’ ");
INSERT INTO leu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","E tamo a rabuna ti lana lifu aave ri kas a lifu siri xe simi, fin a Piran o i taa faluai nari. Tamo piau, a luaian aave i taa ulaa xe simi. ");
INSERT INTO leu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","E tamo a rabuna lana saxa lifu o bina ri taa pife kas a lifu siri xe simi o langai simi, taꞌulan a bina aave e saf tapin a pof la kami. ");
INSERT INTO leu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne kuus tuuna, lana yaan ina tiisan lava sina Piran, a Piran i taa faxalit a mu rabuna saat ti Sodom nare Gomora pana mamaaluxan molava sena rabuna ti la maana bina aave. ");
INSERT INTO leu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Langaiau! Ne taxa feng nami xe la mu bina xaves malaan sena mu sipsip aava ri pife fexaxaas sena vil votan nari xa xasena mu piu vupung aava ri lagai faagut. Mi taa faxatang seri e muta tigina xuvul pari. ");
INSERT INTO leu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Faxatang! Senaso a toxan a rabuna ri taa pis nami e fatiginei nami la matana rabuna ina tiisan ti la mu bina e ri taa inis faagutan nami pana yeis lana lifu ina faxuvulan siri. ");
INSERT INTO leu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ri taa fatiginei nami la matana mu paamua ti Rom e mu paamua ti la mu bina lava senaso mi namkai sega e mi taa kuus xakaavang sega xe sina mu paamua aave e mu rabuna aava ri pife Juda. ");
INSERT INTO leu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Layaan a mu rabuna aave ri pis lisan nami xe lana bina ina tiisan, muta lamon faaxaves pana so ta mo mi taa ferawai pana o malaafaa mi taa kuusan famatavase senaso layaan a yaan fatak i taa savat a Piran i taa xuus nami pana so ta mo mi taa ferawai pana. ");
INSERT INTO leu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","A maana vapaling aava mi ferawai pana ri taa pife mu vapaling simi fatak. A Vovau si Tamami pe la xunavata, i taxa ferawai la ngusumi. ");
INSERT INTO leu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“A mu rabuna tomexaan ri taa pet lisan a mu tiri xa xena punuxaan nari e a tamana rafulak ri taa vil malaane sena rafulak siri. E mu rafulak ri taa taaluugan na ninari e tamari xena punuxaan nare. ");
INSERT INTO leu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","A mu rabuna xapiak ri taa baian nami senaso mi namkai sega. Taasaxa naseꞌ ta mataa i taa lo tigina fatateak lana namkaian sina fefexaxaas a yaan fataxapiak, i taa kaaxup. ");
INSERT INTO leu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Layaan ri vil pengan nami la saxa bina, sinuf xe la xasa bina. Ne kuus tuuna o mi taa pife lisan a lagasai siak xe la mu bina xapiak pe Israel paamuina filimaanan sina Natuna Mataa. ");
INSERT INTO leu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“A rabuna uꞌusi ri pife matalava sena rabuna ina fepitaa siri e a yaasok a pife matalava sena mataa tafuna. ");
INSERT INTO leu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","E voxo a mataa uꞌusi i taa faamamaas layaan i taa malaan sena mataa ina fepitaa sina e a yaasok layaan i taa malaan sena mataa tafuna. Tamo ri fo xali a paamua ina matafetama pana Bilsibul, naak ri taa xali a mu rabuna la matafetama sina pana vaxa. ");
INSERT INTO leu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“E voxo muta mataut seri senaso a maana mo xapiak aava fufunai i taa savat la matavas talo a mu rabuna ri taa texaas sena. ");
INSERT INTO leu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“A so ta mo ne xuus nami sang mon pana mi taa kuusane la palou ina mu rabuna e so ta mo taara fo ferawai pana la palou itaara mon, mi taa xukulai pana talo a mu rabuna xapiak ri taa langaie. ");
INSERT INTO leu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Muta matautan nari aava ri taa punuk a vipin simi taasaxa ri pife fexaxaas sena punuk a xunus imi. Taasaxa mi taa mataut sena Piran aava fexaxaas sena kawaasan xapin a vipin xuvul pana xunus ina mataa la bina ina fata aava i taxa raam vulai. ");
INSERT INTO leu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","A tuuna, mi taa maraan a ro maanu modak pana fomirak faat taragua taasaxa tamo na Tamami a pife turoxo pana, pi ta saxa siri i taa poxo xe lapia e maat. ");
INSERT INTO leu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","E fulaa, a Piran xa a texaas sena xakatan ina fui simi a talavisan. ");
INSERT INTO leu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","E voxo muta mataut senaso nami, mi pelalava sena mu maanu xaves la matana Piran. ");
INSERT INTO leu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Layaan a mataa i taa kuus fasavat la palou ina rabuna o nane namkai sega, nenia, ne taa xuus na Tamaang la xunavata o nane aave a usiau. ");
INSERT INTO leu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Taasaxa, naseꞌ ta mataa a faaxolusanau la palou ina rabuna, ne taa xuus na Tamaang la xunavata o ne ngalngolane. ");
INSERT INTO leu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Muta lamon o ne fo savat la xavala xena lisan a luaian, piau. Ne pife savat xena lisan a luaian taasaxa fevisan. ");
INSERT INTO leu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ne savat xena ‘fati taaluugan a mu rafulak tomexaan xasena mu tamari e mu rafulak tefin xasena mu ninari e mu enari. ");
INSERT INTO leu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","A mu matafetama sina mataa ri taa xaiyaas sina.’ ");
INSERT INTO leu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ne piau ta vepen la palou ina rabuna siak xanꞌ ta mataa aava vubuxan xasingitan sina xe si tamana o ninana a molava sena vubuxan xasingitan sina xe siak. E ne piau ta vepen la palou ina rabuna siak xanꞌ ta mataa aava vubuxan xasingitan sina xe sina lak tomexaan o lak tefin sina a molava sena vubuxan xasingitan sina xe siak. ");
INSERT INTO leu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","E naseꞌ ta mataa a pife yaas a bolo sina e usiau, i taa piau ta vepen la palou ina rabuna siak. ");
INSERT INTO leu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nane aava lalamon vulai xena tao fatateak a toyan sina, i taa pife waan lana toyan tuuna. Taasaxa nane aava lamon fepalauan a toyan sina senaso i taxa namkai sega, i taa siak a toyan tuuna xe vulai. ");
INSERT INTO leu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Nane aava kas a lifu sina xe simi, a kase vaxa xe siak e nane aava kas a lifu sina xe siak, a kase xe sina Piran aava fengau. ");
INSERT INTO leu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nane aava kas a lifu sina xe sina mataa ina kuus fatuxai senaso a taraxali a vepen sina, i taa siak a sepirigus malaan sena mataa ina kuus fatuxai aave. E nane aava kas a lifu sina xe sina saxa aava usi fatak a vubuxanan sina Piran, i taa siak a sepirigus malaan sena saxa aave. ");
INSERT INTO leu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","E tamo saxa taa tavai a mataa palau ti la palou ina mu rabuna siak pana raarum marafut senaso a usiau, a sepirigus sina i taa pife malit.” ");
INSERT INTO leu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Layaan na Yesus a fapiti xapin a mu rabuna sangafilu saxa pana taragua sina, a taꞌulan a bina pave e falet xena fepitaa e kuusan fasavat a Lagasai Roxo la maana bina pe Galili. ");
INSERT INTO leu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Layaan na Jon ina Fasufan pe la bina ina vipisan, a langai pana maana mo na Krais taxa vile, a feng a saxano fefeng sina xe sina. ");
INSERT INTO leu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","E ri fe fin na Yesus, “Xuus nemaam, nano, no saxa aava na Jon a kuus o i taa savat o maam taa waan bang a xasafuna?” ");
INSERT INTO leu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","E na Yesus a sui nari, “Ulaa xe si Jon e xuuse pana so ta mo mi fo langaie e xalume: ");
INSERT INTO leu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","a mu rabuna aava ri tamu piif ri kaalum fulaa; a mu rabuna aava ri tamu maalapen ri sangas; nari aava tari tamu tapak ri roxo paaliu. Nari aava ri tamu vaang, ri langai. Nari aava ri tamu maat ri to faꞌulaa e a mu valagof ri taxa langai a Lagasai Roxo. ");
INSERT INTO leu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nari aava namkaian siri sega pife milung, ri taxa faamamaas.” ");
INSERT INTO leu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","La fena faletan sina mu fefeng si Jon na Yesus a ferawai xe sina malila se Jon, “Layaan mi falet xe si Jon pe la xobingil, mi lamon o mi taa xalum a so? A yi i taxa lep la reref? ");
INSERT INTO leu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mi falet xena xalum a so? A mataa pana marapi roxo malaan sena paamua king? Piau, a rabuna aava ri falak a marapi malaan ri fuuna taagul la tang lifu sina king! ");
INSERT INTO leu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Xuusau, no falet xena xalum a so? A mataa ina kuus fatuxai, bo? Tuuna paaliu, mi xalum a mataa ina kuus fatuxai taasaxa nane a matalava sena mu rabuna ina kuus fatuxai xapiak. ");
INSERT INTO leu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Lana Xakalayan Taap a Piran a ferawai pa Jon layaan a kuus: ‘Ne taa feng a fefeng siak xena lisan a lagasai paamuin nano e nane i taa faigotan a salan xaanum.’ ");
INSERT INTO leu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Tuuna, ne xuus nami o na Jon ina Fasufan a matalava senꞌ ta mataa aava taxa to. Taasaxa nane aava mataa palau la palou ina rabuna sina Piran a matalava se Jon. ");
INSERT INTO leu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ti la yaan na Jon ina Fasufan a kuusan fasavat a lagasai sina, fefexaxaas a yaan aanabeꞌ a maana rabuna aava ri baian a Piran, ri taxa faisok faagut xena tivotanaana savatan sina fatataganan sina. ");
INSERT INTO leu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Paamuina yaan si Jon, a mu vuputkai si Moses e mu rabuna ina kuus fatuxai ri ferawai pana yaan layaan a Piran i taa fasavat a fatataganan sina. ");
INSERT INTO leu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","E tamo mi buk namkai sena lagasai siri o piau, na Jon ve na Ilaija aava ri fo kuus o i taa savat. ");
INSERT INTO leu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Langai, tamo a tangami a talakas. ");
INSERT INTO leu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“A mu rabuna ti tanin, ri malaan sena so? Ne taa ferawai seri malaafaa? Ri malaan sena mu rafulak aava ri nai la bina ina faasot. Saxa parafulak ri xukulai xe sina saxanofuna ");
INSERT INTO leu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Maam piif a tungaal ina faamamaasan taasaxa mi pife tia! Maam tangiis a mamaat e nami, mi pife taangiis.’ ");
INSERT INTO leu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Layaan na Jon a savat, nane falfaal e pife num a raarum ina xalana wain e a mu rabuna ri kuus o a masalai fo vawe. ");
INSERT INTO leu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Layaan a Natuna Mataa a savat, nane xo a fangan e num e mu rabuna ri kuus, ‘Kaalum! nane fangan vulai e num temasaat e fesing sina mu rabuna ina siak taakis e xasanofuna aava ri bilai fasaat.’ Taasaxa mi taa texaas sena texaasan tuuna layaan mi xalum a malangiis ina.” ");
INSERT INTO leu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","A mu rabuna lana maana bina aava na Yesus fo vil a maana mo faꞌipul lana, ri pife puk tapin nari xa xasena vilaana saat siri e nane baras faagutan nari sena. ");
INSERT INTO leu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","22","Nane kuus, “Kaari, nami mu Korasin e mu Betsaida, senaso a fakasanamaan nami i taa saat paaliu sena mu Tair e mu Saidan senaso tamo a maana mo faꞌipul aava mi fo xalume, ri fo savat pe la ro bina Tair e Saidan, a mu rabuna saat pave ri tafo falak a marapi maxata e tapalan a vebit ina fata la puturi xena faxaalit o ri fo puk tapin nari xa xasena vilaana saat siri. ");
INSERT INTO leu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","E nami mu Kapanam mi faatulan nami xa e mi lamon o a mu rabuna pe la xunavata vaxa ri taxa faatulan nami, bo? Piau, a Piran i taa tapin fasivi nami xe la bina ina fakasanaman vulai. E tamo a maana mo faꞌipul aava mi fo xalume, ri fo savat pe la bina Sodom, tanin nari tafo waan lunai. ");
INSERT INTO leu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ne xuus tuunei nami o la yaan ina tiisan lava a fakasanamaan nami i taa molava seri mu Sodom.” ");
INSERT INTO leu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","La yaan aave na Yesus a kuus, “Tamaang, nano, no Memai ina xavala e xunavata xapiak e ne kuus faasiroxo xe siim senaso no fo fun a maana mo xasena rabuna pana texaasan e masaman taasaxa no fo faxalit famatavas a mu rabuna palau pana maana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tuuna paaliu, Tamaang, no vubuk rao i taa savat malaan e no faamamaas pana. ");
INSERT INTO leu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Na Tamaang fo tavaiau pana maana mo xapiak. Pi ta mataa a texaas se Natuna, na Tamana sang mon, e pi ta mataa a texaas se Tamana, na Natuna e nari aava na Natuna a siak fati nari xena texaas sena. ");
INSERT INTO leu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Filimaan xe siak nami aava mi maare pana yaasaana maana lagafan e ne taa fafangaafus nami. ");
INSERT INTO leu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Turoxo o nenia, ne taa paamuian nano e taare taa fepaꞌusan a lagafan siim e ne taa fapiti nano. Senaso ne fuuna lo usi a vilaana mam e ne pife xalum fasivi ta mataa. Layaan no waan lapaana tateaxan iga no fexaxaas sena fangaafus. ");
INSERT INTO leu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Senaso ne taa paamuian nano lana salan aava pife lagaf xena usiaana e a so ta mo ne tavai nano pana xena yaasaana a pife matafan temasaat sema.” ");
INSERT INTO leu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","La yaan aave na Yesus taxa sangas falet lana saxa uma ‘wiit’ e a yaan aave a Yaan ina Fangaafusan sina mu Juda. A mu fefeng sina ri lagai e ri vuak a putuna ‘wiit’ e ri ngan a mu kam ina. ");
INSERT INTO leu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Layaan a mu Ferasi ri xalume, ri kuus xe si Yesus, “Kaalum, a mu fefeng siim ri taxa kawaasan a vuputkai sitaara senaso a vuputkai sitaara a kuus votan a faisok la Yaan ina Fangaafusan.” ");
INSERT INTO leu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","E nane sui nari, “Tuuna, mi fo kat lana Xakalayan Taap sena so ta mo na Devit fo vile layaan nane, xuvul pana rabuna sina, ri lagai, bo? ");
INSERT INTO leu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nane xo a laak xe la lifu marapi ina lotu sina Piran e siak a bret ina tatavai xana Piran e nari, ri ngane naapalaan a vuputkai a kuus votan nari sena bret aave, senaso a fanganan sina mu priis sang mon. ");
INSERT INTO leu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","E tuuna, mi fo kat lana vuputkai si Moses o a maana Yaan ina Fangaafusan, a mu priis lana tang lifu lotu sina Piran vaxa ri fuuna kawaasan a vuputkai sena faisok siri taasaxa ri pife vupuno, bo? ");
INSERT INTO leu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ne xuus nami o a saxa aava molava sena tang lifu lotu taxa waan. ");
INSERT INTO leu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","A Xakalayan Taap a kuus, ‘Ne vubuxan a vilaana ina mamaaluxan e pife vilaana ina tatavai pana mu tiir.’ Tamo mi texaas tuuna sena malasuf ina ferawaian aanabeꞌ mi taa pife xali a rabuna aava ri pife vupuno pana vupuno. ");
INSERT INTO leu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Senaso nane aava Natuna Mataa, nane ve a Memai ina Yaan ina Fangaafusan.” ");
INSERT INTO leu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Na Yesus a taꞌulan a bina pave e laak lana lifu ina faxuvulan siri ");
INSERT INTO leu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","e pave a mataa mana maat taxa waan. Saxano rabuna ri buk bit tifi na Yesus panꞌ ta vilaana saat e voxo ri fine, “I taxa tisui a vuputkai sitaara xena vil faroxoi a mataa la Yaan ina Fangaafusan, bo?” ");
INSERT INTO leu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","E na Yesus a sui nari, “Tamo saxa la palou imi a toxan a sipsip saxa mon e a poxo du lana vaaꞌul molava la Yaan ina Fangaafusan, tuuna i taa yuuf falaxe ti lana vaaꞌul, bo? ");
INSERT INTO leu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","E a mataa a molava paaliu sena sipsip. E voxo a vuputkai sitaara a turoxo o taara taa xavang a mataa la Yaan ina Fangaafusan.” ");
INSERT INTO leu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","E mui a kuus xe sina mataa mana maat, “Talangaian a maam.” E nane talangaiane e fo roxo, malaan sena xasa mana. ");
INSERT INTO leu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","E a mu Ferasi ri falet e ri fexuus kasam o ri taa punuxe malaafaa. ");
INSERT INTO leu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na Yesus a texaas sena lamonan siri e voxo taꞌulan a bina aave. A maana rabuna xaves ri falet xuvul pana e nane xo a vil faroxoi nari xapiak aava ri giis ");
INSERT INTO leu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","e a pebukan nari o ri taa pife xuus fatexaas a saxanofuna pana. ");
INSERT INTO leu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A kuus malaan talo ferawaian sina Piran la ngusu Aisaia, a mataa ina kuus fatuxai, i taa savat la matavas: ");
INSERT INTO leu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kaalum, ne fo siak fati a mataa aanabeꞌ xena sisiak siak. Ne vubuxan xasingite e ne faamamaas pana. Ne taa fabase pana Vovau siak e i taa xuus a mu rabuna xapiak pana vilaana ina tiisan tuuna. ");
INSERT INTO leu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I taa pife fegagelai o xukulai faagut e i taa pife sangas la salan xena ti ferawai. ");
INSERT INTO leu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I taa pife vuak a yi aava tamaalun e i taa pife famaat a fata aava pife rangat faagut, fefexaxaas a yaan a vilaana ina tiisan tuuna i taa onam a saatan. ");
INSERT INTO leu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","E a mu rabuna xapiak ri taa lamon fanei a maana mo aave la isina.” ");
INSERT INTO leu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","E bak saxano rabuna ri lisan a mataa xe si Yesus. A mataa aave a piif e po senaso a masalai fo vawe. Na Yesus a vil faroxoie e nane fexaxaas sena kaalum e ferawai fulaa. ");
INSERT INTO leu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","A malila ri ipul pana maana mo na Yesus fo vile. E ri fefiai, “Naak nane ve na Natu Devit, bo?” ");
INSERT INTO leu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Layaan a mu Ferasi ri langai pana, ri sui nari, “Nane taxa gei tapin a mu masalai senaso a faisok lapaana gutan sina paamua siri, na Bilsibul.” ");
INSERT INTO leu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Na Yesus a texaas sena lamonan siri e a kuus xe siri, “A bina lava aava fepatoxanan xena fevisanaan nari, i taa kawaasanan. A bina modak o matafetama aava fepatoxanan xena fevisanaan nari i taa pife waan. ");
INSERT INTO leu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","E mi kuus o nenia, ne taxa gei tapin a mu masalai lapaana gutan si Setan e voxo a fatataganan sina a fepatoxanan e i taa waan malaafaa? ");
INSERT INTO leu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","E tamo ne gei tapin a mu masalai lapaana gutan si Bilsibul, a mu rabuna simi ri gei tapin nari lapaana gutan siseꞌ? Lavaxa, a faisok siri i taa faxaalit o a gelan simi xulok pife tuuna. ");
INSERT INTO leu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tuuna, pife tateaxan i Bilsibul taasaxa Vovau sina Piran aava tavaiau pana gutan xena gei tapin a mu masalai. E a mo aanabeꞌ a faxaalit tuuna o a fatataganan sina Piran fo savat xo. ");
INSERT INTO leu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Pi ta mataa i taa laak lana lifu sina mataa tateak e fe fenou a maana mo sina tamo a pife bugut paamuine. E mui i taa siak tapin a maana mo sina. ");
INSERT INTO leu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Naseꞌ ta mataa pife tigina xuvul paga, nane taxa gilisau. Naseꞌ ta mataa pife xavangau pana faxuvulaana rabuna siak, i taxa tapalan nari. ");
INSERT INTO leu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","E voxo ne xuus nami o a Piran xo i taa lamon tapin a maana vilaana saat sina rabuna e maana mo saat aava ri ferawai xasena taasaxa i taa pife lamon tapin a faasaalan sinꞌ ta mataa aava ferawai fasaat xasena Vovau Xaradak sina. ");
INSERT INTO leu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Naseꞌ ta mataa a ferawai fasaat sena Natuna Mataa, a Piran taa lamon tapine taasaxa naseꞌ ta mataa aava ferawai fasaat xasena Vovau Xaradak, i taa pife lamon tapinan, la yaan aanabeꞌ e la mu yaan i taa savat. ");
INSERT INTO leu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Tamo wai a tateak mi taa siak a xalana roxo taasaxa tamo wai a malmal e saat a xalana vaxa i taa saat. Mi taa taraxali a so ta buk wai mi toxane sena xalana. ");
INSERT INTO leu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nami mu lamavaang, mi pife fexaxaas sena ferawai pana mo roxo senaso mi rabuna saat. A so ta lamonan a fabas a xunus imi i taa savat la matavas layaan mi ferawai. ");
INSERT INTO leu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","A mataa roxo a lisan a maana roxoyan ti la faxuvulan ina maana roxoyan sina. A mataa saat a lisan a maana mo mosaat ti la faxuvulan ina maana mo mosaat sina. ");
INSERT INTO leu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ne xuus nami, lana yaan ina tiisan a mu rabuna xapiak ri taa tigina la nona Piran xena gel votai sena maana miraxana ferawaian saat xapiak. ");
INSERT INTO leu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","E a Piran xa i taa xali nami pana vupuno o piau, sena ferawaian simi.” ");
INSERT INTO leu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","E mui saxano rabuna ina fepitaa pana vuputkai xuvul pana saxano Ferasi ri ferawai e ri kuus, “Mataa ina Fepitaa, maam vubuk o no taa vil a mo faꞌipul.” ");
INSERT INTO leu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Taasaxa nane sui nari, “Nami ve mi mu rabuna saat e mi langai pesalai sena Piran taasaxa mi buk xalum a mo faꞌipul. Piau! Mi taa xalum a fakalimaanan i Jona aava mataa ina kuus fatuxai. ");
INSERT INTO leu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Na Jona waan la xuna tang din pana yaan talatul xurul e malaan se Jona a Natuna Mataa i taa waan la bina mamaat pana yaan talatul xurul. ");
INSERT INTO leu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","La yaan ina tiisan a mu rabuna ti Niniveꞌ ri taa tigina e gel tifi nami senaso nari, ri puk tapin nari xa xasena vilaana saat siri layaan ri langai a lagasai si Jona. E ne xuus nami, naboxo, a saxa aava molava se Jona taxa waan. ");
INSERT INTO leu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","E lana yaan naang, a Paamua Tefin ti Siba i taa tigina e gel tifi nami senaso nane taꞌulan a bina sina e falet lasuun xena langai a ferawaian sina Paamua King, na Solomon aava toxan a texaasan e masaman molava e tuuna ne xuus nami o a saxa aava molava se Solomon taxa waan. ");
INSERT INTO leu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tamo a vovau saat i taa taꞌulan a mataa, i taa sou? I taa falet xolai la xobingil xena sengaana bina ina fangaafus, taasaxa piau. ");
INSERT INTO leu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","E mui a ilisai, ‘Naak ne taa ulaa xe la lifu siak.’ A ulaa e xalume ri fo gone e vil faroxoie taasaxa lana gof. ");
INSERT INTO leu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nane fe xel a maana vovau pisiguak aava ri saat paaliu sena e nari xapiak ri maa taagul pave. A waanan sina mataa aave a saat paaliu sena waanan sina paamua. E i taa savat malaan sena mu rabuna saat ti tanin. A waanan siri i taa pemamosaat sena waanan ti paamua.” ");
INSERT INTO leu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Na Yesus taxa ferawai xe sina mu rabuna aave lunai e na ninana xuvul pana mu tina ri maa savat. Ri tigina lamalei e ri kuus o ri buk ferawai xuvul pana. ");
INSERT INTO leu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Saxa la palou iri a xuus na Yesus, “Kaalum, na ninaam e mu tiam ri taxa waan lamalei e ri buk rao ri taa ferawai xuvul pama.” ");
INSERT INTO leu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","E na Yesus a suie, “Naseꞌ na ninaang? E naseꞌ a mu tiak?” ");
INSERT INTO leu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Mui a talangai xe sina mu rabuna sina e a kuus, “Kaalum! na ninaang e mu tiak ri taxa waan nabeꞌ. ");
INSERT INTO leu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Naseꞌ ta mataa a usi fatak a vubuxanan si Tamaang la xunavata, nane ve a tiak e vasaak e ninaang.” ");
INSERT INTO leu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","La yaan naang, na Yesus a taꞌulan a lifu aave e fe nai la vangana Laman Galili xena fepitaa. ");
INSERT INTO leu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nane xawas xuluna xaati senaso a malila ri ti fakaliuane xena langai sina. Nane nai la xaati e mu rabuna ri tigina la gun. ");
INSERT INTO leu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nane fapiti nari pana maana mo xaves e xavang famasam nari pana maana ferawaian paap. Nane kuus, “Saxa yaan a mataa tataraꞌuma a falet la uma sina xena tapalan a mu kam. ");
INSERT INTO leu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E layaan i taxa tapalan a mu kam, saxano kam ri poxo la salan e mu maanu ri maa ngan xapine. ");
INSERT INTO leu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Saxanofuna ri poxo lapi la bina faat e piau ta xavala xaves. E a mu kam aave ri boak fataapus. ");
INSERT INTO leu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Taasaxa layaan a ngaas a savat fulaa, a nuk a maana mo xurul e ri femaiyang senaso a xarei iri pife fexaxaas. ");
INSERT INTO leu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Saxanofuna fulaa ri poxo la xavala xuvul pana kam ina yeis tuturuk. E mu tuturuk aave ri boak fataapus e a kam ina ‘wiit’ pife fexaxaas sena faꞌoname. ");
INSERT INTO leu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Taasaxa saxano kam ri poxo la xavala roxo e ri fasavat a mu kam xaves: saxanofuna a kam xaves e saxanofuna a kam xaves paaliu.” ");
INSERT INTO leu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","E na Yesus a kuus, “Langai, tamo a tangami a talakas.” ");
INSERT INTO leu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","E mui a mu fefeng sina ri fe waan la tana e ri fine, “Senasou no fuuna lo ferawai paap xe sina mu rabuna?” ");
INSERT INTO leu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","E na Yesus a sui nari, “A Piran fo tavai nami pana masaman sena mo fufunai ina fatataganan sina, taasaxa xe siri, piau. ");
INSERT INTO leu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","A mo aanabeꞌ a tuuna, senaso a mataa aava toxan a masaman i taa toxan a masaman molava. E a masaman sina i taa fexaxaas sena e i taa pesasoliu. E nane aava piau ta mo, a so ta mo modak aava nane toxane i taa siak tapinan. ");
INSERT INTO leu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nabeꞌ ve a fufuna ferawaian paap siak: ‘Ri kaalum taasaxa ri pife taraxali a so ta mo ri taxa xalume. E ri langai a maana vapaling ri laak la tangari taasaxa ri bai langai e ri pife masam.’ ");
INSERT INTO leu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","E voxo a kuus fatuxaian si Aisaia a ferawai seri malaan: ‘A mu rabuna aanabeꞌ ri taa langai taasaxa ri taa pife masam, ri taa kaalum taasaxa ri taa pife taraxali a so ta mo ri taxa xalume ");
INSERT INTO leu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","senaso a lamonan siri a sopat e ri pife fexaxaas sena siak a texaasan. Ri vil votan a tangari talo ri taa pife langai e ri xafut a matari talo ri taa pife kaalum. Tamo ri pife vil malaane ri tamaa kaalum pana matari, langai pana tangari e masam la xunus iri e puk a vilaana siri e ne taa vil faroxoi nari.’ ");
INSERT INTO leu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Taasaxa waanan simi a roxo paaliu senaso a Piran fo tiuan a roxoyan sina xulumi. E a matami ri kaalum famatavas e tangami ri langai pana masaman. ");
INSERT INTO leu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A tuuna, ne xuus nami o mu rabuna ina kuus fatuxai e maana rabuna sina Piran ti kavai, ri buk xalum a maana mo mi xalume e langai a maana mo mi langaie, taasaxa piau. ");
INSERT INTO leu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Langai xo e masam sena malasuf ina ferawaian paap sena mataa tataraꞌuma. ");
INSERT INTO leu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nari aava ri langai a lagasai ina fatataganan sina Piran taasaxa ri pife masam xapine, ri malaan sena mu kam aava ri poxo la salan. Na Setan, a Mataa Saat, maa savat e pagas tapin a lagasai aave ti lana xunus iri. ");
INSERT INTO leu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","E nari aava ri tao a lagasai pana faamamaasan layaan ri langaie, ri malaan sena mu kam aava ri poxo la bina faat. ");
INSERT INTO leu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Taasaxa a lagasai aave pife waan fatateak la xunus iri e ri usi famodaxe mon. Layaan a lagafan o vil penganan a savat la toyan siri senaso ri namkai sena lagasai aave, ri taꞌulan fatapusane. ");
INSERT INTO leu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","E nari aava ri langai a lagasai aanabeꞌ ri malaan sena mu kam aava ri poxo la palou ina mu yeis tuturuk. Taasaxa ri lamon faaxaves pana maana mo ina toyan siri e ri vubuxan temasaatan a faat e maana mo ri taa maraane e mu vilaana aanabeꞌ ri kawaasan a lagasai aave talo i taa pife fasavat a vilaana roxo. ");
INSERT INTO leu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","E nari aava ri langai a lagasai aave pana masaman, ri malaan sena mu kam aava mataa tataraꞌuma tapalane la xavala roxo. Ri taa fasavat a maana faisok roxo malaan sena kam aava fuaa pana mu kam xaves e xaves paaliu.” ");
INSERT INTO leu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Na Yesus a xuus nari pana xasa ferawaian paap fulaa: “A fatataganan sina Piran a malaanabeꞌ. A mataa tataraꞌuma a tapalan a mu kam roxo la uma lava sina. ");
INSERT INTO leu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Saxa vung xo layaan a mu rabuna ri taxa matef, a xaiyaas sina mataa aave maa savat xena xapis a latan la palou ina kam roxo e falet faapalau. ");
INSERT INTO leu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Layaan a mu kam ri boak e fuaa, a latan vaxa a boak e fuaa. ");
INSERT INTO leu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“E a mu sisiak sina mataa aave ri maa savat sina e ri fine, ‘Matalava, no xapis a uma lava siim pana kam roxo. A latan a savat ti faa?’ ");
INSERT INTO leu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“E nane sui nari, ‘Saxa xaiyaas siak fo vile.’ E ri fine, ‘No vubuk rao maam taa fe put tapin a latan aave?’ ");
INSERT INTO leu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Taasaxa a sui nari, ‘Piau, layaan mi put a latan mi tamaa put a kam roxo aava fo boak vaxa. ");
INSERT INTO leu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Taꞌulan a kam roxo e a latan xena savat faxuvul fefexaxaas a yaan ina faxuvulaana. E lana yaan aave ne taa xuus a mu rabuna ina faisok siak o ri taa put tapin a latan paamua e pis faxuvule xena farame, e mui ri taa faxuvul a kam ina ‘wiit’ e faneie la lifu ina fawaanaana fanganan.” ");
INSERT INTO leu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Na Yesus a xuus nari pana ferawaian paap fulaa: “A fatataganan sina Piran a malaan sena kam ina mastaat aava mataa a siaxe e fe xapise la uma sina. ");
INSERT INTO leu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A kam ina wai mastaat a pemamodak sena xasano buk kam taasaxa layaan fo boak a pemolava sena maana buk latan e fasavat a wai talo mu maanu ri maa vesan a mu singa siri la raxana.” ");
INSERT INTO leu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Na Yesus a xuus nari pana ferawaian paap fulaa laa: “E a fatataganan sina Piran a malaan sena yiis aava tefin a siaxe e salate pana flaua lana bi titifai talatul fefexaxaas a flaua xurul fesul.” ");
INSERT INTO leu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Na Yesus a ferawai paap xe siri xena xuus nari pana maana mo xapiak aanabeꞌ. Nane pife ferawai xe siri pana piau ta ferawaian paap. ");
INSERT INTO leu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A savat malaan xena faxalit a mo aava mataa ina kuus fatuxai fo ferawai pana: “Layaan ne ferawai xe siri ne taa ferawai paap mon. Ne taa xuus nari pana maana mo aava waan fufunai la tangpat ina maana mo xapiak.” ");
INSERT INTO leu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Layaan na Yesus fo taꞌulan a malila e fe laak la lifu, a mu fefeng sina ri savat sina e ri kuus, “Xuus famatavas nemaam pana malasuf ina ferawaian paap sena latan la uma lava.” ");
INSERT INTO leu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","E na Yesus a sui nari, “A mataa aava tapalan a mu kam roxo la uma sina, nane ve a Natuna Mataa. ");
INSERT INTO leu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","A uma lava va xavala e a kam roxo va mu rabuna aava ri waan la fatata- ganan sina Piran. A latan va mu rabuna aava ri waan la fatataganan sina mataa saat ");
INSERT INTO leu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","e a xaiyaas aava xapis a latan, nane ve na Setan. A yaan ina faxuvulan ve a fataxapiak ina yaan e a mu rabuna ina faisok lana faxuvulan aave va mu angelo. ");
INSERT INTO leu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“E malaan sena latan a put tapinan e faraman lana fata, lana yaan fataxapiak i taa malaan: ");
INSERT INTO leu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","a Natuna Mataa i taa feng a mu angelo sina e ri taa put tapin nari aava ri vil familung a rabuna e nari xapiak aava ri vil a mo mosaat ti lana fatataganan sina. ");
INSERT INTO leu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","E ri taa tapin fasivi nari lana vaaꞌul pana fata lava e pave ri taa taangiis faagut e faxakengatan a fari. ");
INSERT INTO leu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","E mui a rabuna fatak ri taa rarapak malaan sena ngaas lana fatataganan si Tamari. Langai xo tamo tangami a talakas. ");
INSERT INTO leu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“A fatataganan sina Piran a malaan sena fafanaian roxo paaliu aava funan la uma. Saxa mataa a tingin a fafanaian aave e fun fulane. Nane faamamaas paaliu e fe faasot pana maana mo xapiak sina xena maraan a uma aave. ");
INSERT INTO leu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“E vaxa, a fatataganan sina Piran a malaan sena saxa mataa ina faasot aava i taxa seng a mu xixiut roxo paaliu aava ri xalie pana ‘purl’. ");
INSERT INTO leu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","E layaan a tingin a saxa aava roxo paaliu marasaxa, a fe faasot pana maana mo xapiak sina xena maraan a xixiut aave. ");
INSERT INTO leu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“E fulaa a fatataganan sina Piran a malaan sena saxano rabuna ina faadin aava ri tapin fasivi a vana siri pe la laman e a maana buk din xaves ri fai lana. ");
INSERT INTO leu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Layaan a vana siri a bas pana din ri yuuf falaxe xe la gun e ri maa fepatoxan a mu din. A maana din roxo ri fawaane lana mu bi e maana din aava ri pife fexaxaas sena ngane ri tapine. ");
INSERT INTO leu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","I taa waan malaan la fataxapiak ina yaan. A mu angelo ri taa falet xolai xena fepatoxan a mu rabuna saat xasena mu rabuna fatak. ");
INSERT INTO leu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","E ri taa tapin nari xe lana vaaꞌul pana fata lava e pave ri taa taangiis faagut e faxakengatan a fari.” ");
INSERT INTO leu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Na Yesus a fiai, “Mi fo masam pana maana mo aanabeꞌ, bo?” E ri suie, “Aang!” ");
INSERT INTO leu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","E a sui nari, “Lavaxa, a rabuna ina fepitaa pana vuputkai aava ri fawaan nari xa lapaana tateaxan ina fatataganan sina Piran, ri malaan sena mataa tafuna lifu aava siak fasavat a maana mo faꞌui e maana mo xavai ti lana nobina ina fawaanaana maana mo sina.” ");
INSERT INTO leu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","E layaan na Yesus fo taxapus pana mu ferawaian paap aanabeꞌ a taꞌulan a bina aave ");
INSERT INTO leu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","e ulaa xe pe la fufubina sina. E fe lo fapiti nari lana mu lifu ina faxuvulan siri e nari aava ri langaie, ri ipul sena e ri fiai, “Nane siak a texaasan molava faa? Nane vil a maana mo faꞌipul malaafaa? ");
INSERT INTO leu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Taara texaas sena. Nane a lak sina mataa ina vavesai. E na ninana, na Maria e mu tina ve na Jems, Yosep, Simon e na Juut ");
INSERT INTO leu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","e mu vasaana vaxa ri taxa waan iau. Nane siak a texaasan e gutan aanabeꞌ ti faa?” ");
INSERT INTO leu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","E voxo ri gigirane. Taasaxa na Yesus a xuus nari, “A mu rabuna la xasano bina ri taa suai sena mataa ina kuus fatuxai taasaxa nari ti la fufubina sina e la matafetama sina, piau.” ");
INSERT INTO leu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","E nane pife vil a maana mo faꞌipul pave senaso ri pife namkai sena. ");
INSERT INTO leu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lana yaan aave na Herot taxa paamuian a mu bina pe Galili e a langai pana maana mo na Yesus taxa vile ");
INSERT INTO leu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","e a kuus xe sina mu rabuna faisok sina, “Nane toxan a gutan xena vil a maana mo faꞌipul senaso nane ve na Jon ina Fasufan aava to faꞌulaa ti la maatan.” ");
INSERT INTO leu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Na Herot a lamon malaanabeꞌ senaso paamua nane fo xuus a mu rabuna sina o ri taa tao na Jon e pis fawaane la bina ina vipisan. Nane vil malaane senaso a tamai si Herodias aava naasa tina, na Filip. ");
INSERT INTO leu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","E na Jon ina Fasufan fo xuuse, “Pife roxo no taa tamai si Herodias.” ");
INSERT INTO leu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Na Herot a buk punuk na Jon taasaxa piau. A mataut senaso a mu Juda ri lamon o na Jon ve a mataa ina kuus fatuxai. ");
INSERT INTO leu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Taasaxa layaan na Herot xo a toxan a matafanganai sena yaan ina luluuxan sina, nane punuxe. A savat malaanabeꞌ: a lak tefin si Herodias a tia faamamaas la matana rabuna pave e na Herot a faamamaas paaliu sait ");
INSERT INTO leu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","e nane kuus fanai xe sina malaan, “Ne kuus tuuna, ne taa tavai nano pana so ta mo no taa finau pana.” ");
INSERT INTO leu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na ninana lak a xuuse pana so ta mo i taa fin na Herot pana, e nane kuus, “Tavaiau monabeꞌ mon, pana putu Jon ina Fasufan xuluna ‘plet’.” ");
INSERT INTO leu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Na Herot a kanamsaat, taasaxa nane fo kuus fanai la matana rabuna pave la matafanganai e voxo a xuus a rabuna faisok sina o ri taa tavai a tefin aave pana vubuxanan sina. ");
INSERT INTO leu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","E voxo a feng a rabuna sina e ri fe patal tapin a putu Jon la bina ina vipisan. ");
INSERT INTO leu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","E ri lisanmaan a paat aave xuluna ‘plet’ e tavai a lak tefin pana e nane lisane xe si ninana. ");
INSERT INTO leu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","A mu rabuna si Jon ri maa yaas tapin a vipin sina e ri fe xaafane. E mui ri fe xuus na Yesus pana. ");
INSERT INTO leu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Layaan na Yesus a langai se Jon, nane xawas xuluna xaati e taꞌulan a bina aave e fe paan xe la xobingil. A mu rabuna ri langai pana faletan sina e ri taꞌulan a mu bina siri e ri sangas usie. ");
INSERT INTO leu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Layaan na Yesus a du ti xuluna xaati, nane xalum a malila molava e a muluk faagutan nari e a vil faroxoi nari aava ri giis. ");
INSERT INTO leu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","La leaaf a mu fefeng xo ri maa savat sina e ri xuuse, “Faasilak a ngaas i taa rul e piau ta bina ina maraan fanganan nabeꞌ. Feng tapin et nari talo ri taa laak la nu bina faasilak xena maraan fanganan pari xa.” ");
INSERT INTO leu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Na Yesus a sui nari, “A roxo ri taa pife falet xolai, nami xa mi taa fafangan nari.” ");
INSERT INTO leu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","E ri suie, “Maam toxan a fomirak bret pama e ro din mon.” ");
INSERT INTO leu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","E nane xuus nari, “Lisanmaane.” ");
INSERT INTO leu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","E a xuus a mu rabuna o ri taa nai suꞌ lapia e nane tao a fomirak bret e ro din aave e kaalum xe laaꞌui la xunavata e kuus faasiroxo xe sina Piran pana. Nane viak a mu bret e tavai a mu fefeng sina pana e nari, ri tavai a mu rabuna pana. ");
INSERT INTO leu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","E a mu rabuna xapiak ri fangan e ri femaasi. E mui a mu fefeng sina ri faxuvul a maana xavil ina fanganan e ri tifi a maana bi titifai sangafilu saxa pana taragua pana. ");
INSERT INTO leu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A xakatan ina mu tomexaan aava ri fangan, a faasilak 5,000 e maana lutefin xuvul pana mu rafulak vaxa ri fangan sait. ");
INSERT INTO leu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","E mui na Yesus a xuus a mu fefeng sina o ri taa xawas xuluna xaati pave e ri taa falet paamuine xe la xasa paxasing ina Laman Galili e nane xa a feng tapin a mu rabuna. ");
INSERT INTO leu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","E layaan a mu rabuna ri fo falet, na Yesus sang mon a laak xuluna put xena fenung. E layaan a bina xo suk na Yesus sang mon taxa waan ");
INSERT INTO leu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","taasaxa a xaati aave taxa waan lasuun sena gun. A reref taxa fiit faagut e a tof taxa pitai xuluri. ");
INSERT INTO leu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","La paanen lolof na Yesus a sangas laaꞌui xuluna laman e fe savat siri. ");
INSERT INTO leu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Layaan ri xalume i taxa sangasmaan xe siri laaꞌui xuluna laman, ri mataut e ri xukulai faagut e ri kuus, “A rongan ve!” ");
INSERT INTO leu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","E fataapus na Yesus a ferawai xe siri, “Fagut nami xa, muta mataut! Nenia move.” ");
INSERT INTO leu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","E na Pita a kuus, “Memai, tamo nano fatak, xelau xe siim xuluna laman.” ");
INSERT INTO leu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","E na Yesus a xuuse, “Man!” E na Pita a taladu xuluna xaati e sangaset xe si Yesus xuluna laman. ");
INSERT INTO leu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Taasaxa, layaan a xalum a reref taxa fiit faagut, nane mataut faagut e tangpat pana du lana laman e a xukulai, “Memai, fakaxupau!” ");
INSERT INTO leu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","E fataapus na Yesus a talangai xe sina e tao fatateaxe e a kuus, “A namkaian siim a modak temasaat! Xenaso no lamon maranga?” ");
INSERT INTO leu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","E nare xapiak re xawas xuluna xaati e a laman a mararol. ");
INSERT INTO leu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","E mui nari aava ri waan la xaati aave, ri nangus na Yesus e ri kuus, “Tuuna, nano ve no Natuna Piran.” ");
INSERT INTO leu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ri xaul patal a laman e ri fe ung pe Genasaret. ");
INSERT INTO leu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","E a mu rabuna pave ri taraxali na Yesus. E voxo ri feng a rabuna xe la nu bina faasilak xena xel faxuvul a mu rabuna aava ri giis e lisanmaan nari xe si Yesus. ");
INSERT INTO leu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ri nunge o i taa turoxoian a rabuna giis xena tao mon a xasing ina marapi ina vupungan sina e nari xapiak aava ri tawe, ri roxo. ");
INSERT INTO leu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","E mui saxano Ferasi e mu rabuna ina fepitaa pana vuputkai ri falet xe si Yesus ti Jerusalem e ri fine, ");
INSERT INTO leu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Xenaso a mu fefeng siim ri langai pesalai sena fepitaian sina mu butaara? Ri pife usi a vilaana sitaara layaan rao ri fangan e ri pife xamak a mari.” ");
INSERT INTO leu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","E nane sui nari, “E xenaso mi langai pesalai sena fefasaian sina Piran xena usi fatak a fepitaian simi xa? ");
INSERT INTO leu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Senaso a Piran a kuus, ‘Suai se ninami e tamami.’ E vaxa, ‘Naseꞌ ta mataa a fatatul a saat xulu ninana o tamana i taa punuxan.’ ");
INSERT INTO leu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Taasaxa nami, mi kuus o tamo mataa a toxan a mo xena xavang na ninana o tamana pana taasaxa a xuus nare, ‘A so ta mo ne fexaxaas sena xavang nami pana, ne fo tatavai xe sina Piran pana xo,’ ");
INSERT INTO leu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","i taa pife ‘suai se tamana’ pana. E voxo mi taaluugan a fefasaian sina Piran xena usi a fepitaian simi xa. ");
INSERT INTO leu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nami mu xalema maranga! A kuus fatuxaian si Aisaia a tuuna layaan a ferawai semi malaan: ");
INSERT INTO leu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘A mu rabuna aanabeꞌ ri suai sega pana ferawaian siri mon taasaxa la xunus iri ri lamon fepalau sega. ");
INSERT INTO leu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","A lotu siri xe siak a mo palau senaso ri fepitaa pana usiaana vuputkai siri mon malaan sena mu vuputkai siak.” ");
INSERT INTO leu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na Yesus a xel faxuvul a malila e xuus nari, “Langai pana mo aanabeꞌ e masame! ");
INSERT INTO leu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A mo aava mataa taa nume o ngane i taa pife falalosaate la matana Piran, piau. Taasaxa, a ferawaian aava savat ti la valana, i taa falalosaate la matana Piran.” ");
INSERT INTO leu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","E mui a mu fefeng sina ri filimaan xe sina e ri kuus, “No texaas o a mu Ferasi ri baian a ferawaian siim, bo?” ");
INSERT INTO leu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","E nane sui nari, “A so ta mo aava na Tamaang pe laaꞌui la xunavata pife xapise, i taa put tapinan. ");
INSERT INTO leu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Muta lamon faaxaves seri! Nari mu matalava aava ri malaan sena mataa piif e layaan ri taa paamuian a xasafuna aava piif, nare xapiak re taa poxo lana vaaꞌul.” ");
INSERT INTO leu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Taasaxa na Pita a kuus, “Xuus famatavas nemaam pana ferawaian paap aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","E na Yesus a xuus nari, “Mi pife matavas lunai, bo? ");
INSERT INTO leu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mi pife masame, bo? A so ta mo a laak la valana mataa e du la xuna, i taa pesanan. ");
INSERT INTO leu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Taasaxa so ta mo a mataa ferawai pana, a savat ti la xunus ina e a maana mo aanabeꞌ ri falalosaat a mataa. ");
INSERT INTO leu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Senaso ti la xunus ina, a maana lamonan saat, a ngaapunuxan, a femilungai sena tamaian, a fenau, a kuus xakaavangan bit e a kuus penganaana isina mataa, ri savat. ");
INSERT INTO leu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","A maana vilaana aanabeꞌ ri falalosaat a mataa. E voxo layaan a mataa taa pife xamak a mana paamuina fanganan, a pife falalosaate.” ");
INSERT INTO leu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Na Yesus a taꞌulan a bina aave e falet xe pe la ro bina Tair e Saidan. ");
INSERT INTO leu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","E saxa tefin ti pave aava waan lana parabuna ri xalie pana mu Kenan, maa savat sina e xukulai, “Matalava! Natu Devit, xavangau! A masalai fo vao faagutan a lak tefin siak.” ");
INSERT INTO leu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Taasaxa na Yesus pife suie. A mu fefeng sina ri maa seie, “Feng tapine! Nane taxa usi netaara e i taxa xukulai faagut temasaat.” ");
INSERT INTO leu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","E na Yesus a sui nari, “A Piran fo fengau xe sina mu rabuna ti Israel senaso ri malaan sena mu sipsip aava ri milung.” ");
INSERT INTO leu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Taasaxa tefin aave maa bukaak e turung la kana e kuus, “Matalava, xavangau!” ");
INSERT INTO leu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","E na Yesus a suie, “A pife roxo xena siak tapin a fanganan xana mu rafulak e tavai a mu piu pana.” ");
INSERT INTO leu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","E nane suie, “A tuuna Memai, taasaxa mu piu mon ri ngan a tamirak modak aava ri poxo la ivin sina mataa siri.” ");
INSERT INTO leu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","E na Yesus a suie, “Nano, no tefin pana namkaian lava! A Piran i taa tavai nano pana vubuxanan siim.” E lana yaan fatak aave a lak tefin sina moxo a roxo. ");
INSERT INTO leu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Na Yesus a taꞌulan a bina pave e sangas la itina Laman Galili. A laak xulu put e nai suꞌ. ");
INSERT INTO leu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","A malila molava ri lisanmaan a mu maalapen, mu rabuna piif, rabuna pana mari o kari tapil, mu po e maana xasanofuna xe si Yesus e fanei nari la kana e nane xo vil faroxoi nari xapiak. ");
INSERT INTO leu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","E a malila aave ri ipul faagut layaan ri xalum a rabuna aava ri tamu po, ri taxa ferawai; nari pana mari o kari tapil ri roxo fulaa; a rabuna aava ri tamu maalapen, ri taxa sangas e mu rabuna aava ri tamu piif, ri taxa kaalum. E nari xapiak ri faatulan a Piran sina mu Israel. ");
INSERT INTO leu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","E na Yesus a xel faxuvul a mu fefeng sina e a kuus, “Ne muluk a mu rabuna aanabeꞌ senaso ri fo waan xuvul paga pana yaan talatul e naboxo ri piau ta fanganan. Ne bai feng tapin nari pana ri lagai senaso ri tamaa maat la faletan siri.” ");
INSERT INTO leu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","E mu fefeng sina ri xuuse, “Taara taxa waan la xobingil e maam taa siak a bret fexaxaas seri xapiak faa?” ");
INSERT INTO leu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","E na Yesus a fin nari, “Mi toxan a bret talavisan?” E ri suie, “A bret pisiguak e nu din modak.” ");
INSERT INTO leu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","E voxo na Yesus a fasei faagutan a malila aave o ri taa nai suꞌ lapia. ");
INSERT INTO leu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","E nane siak a bret pisiguak e nu din aave e kuus faasiroxo xe sina Piran pana. A viak nari e tavai a mu fefeng sina pana e ri tavai a mu rabuna pana. ");
INSERT INTO leu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nari xapiak ri fangan e ri femaasi. E mui a mu fefeng sina ri siak faxuvul a maana xavil e ri tifi a bi titifai pisiguak pana. ");
INSERT INTO leu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A mu tomexaan 4,000 ri fangan e maana lutefin e rafulak vaxa. ");
INSERT INTO leu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","E mui na Yesus a feng a mu rabuna xe la mu lifu siri e xawas xuluna xaati e falet xe pe Magadan. ");
INSERT INTO leu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","E mui saxano Ferasi xuvul pana saxano Sedusi ri savat si Yesus. Ri buk familunge e voxo ri fine o i taa vil a mo faꞌipul xena faxalit nari o i taxa faisok lapaana tateaxan ina Piran. ");
INSERT INTO leu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","E nane sui nari, “La leaaf layaan a ngaas i rul mi kuus, ‘Mafu i taa roxo senaso a tavegof a vuung.’ ");
INSERT INTO leu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","E la paanen ‘I taa raafui tanin senaso a tavegof a vuung e suk’. Mi texaas sena so ta mo a tavegof taxa faxalit nami pana, taasaxa mi pife fexaxaas sena masam famatavas pana maana fakali- maanan ri taxa savat monabeꞌ mon. ");
INSERT INTO leu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nami ve mi mu rabuna saat e mi langai pesalai sina Piran taasaxa mi buk xalum a mo faꞌipul. Piau! Mi taa xalum a fakalimaanan i Jona mon.” E nane taꞌulan nari e falet patak. ");
INSERT INTO leu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Layaan a mu fefeng sina ri falet fatak xe la xasa paxasing ina raarum aave, ri maluf a bret. ");
INSERT INTO leu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","E na Yesus a kuus xe siri, “Faxatang! Kaalum votai sena yiis sina mu Ferasi e mu Sedusi.” ");
INSERT INTO leu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","E a mu fefeng sina ri ferawai la palou iri e ri kuus, “Naak nane kuus malaan senaso maam pife lisanmaan ta bret.” ");
INSERT INTO leu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Na Yesus a texaas sena ferawaian siri e fin nari, “Senasou e mi taxa ferawai o mi pife siak ta bret? A namkaian simi a modak lunai. ");
INSERT INTO leu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mi pife masam lunai, bo? Mi fo maluf xo a yaan ne viak a fomirak bret pama xena fafangan a mu rabuna tomexaan 5,000, bo? A bi titifai talavisan mi fo fabase? ");
INSERT INTO leu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","E mi lamon faꞌuli a bret pisiguak? A mu rabuna tomexaan 4,000 ri fangan e fo maasi. E a bi titifai talavisan mi fo fabase? ");
INSERT INTO leu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Senasou e mi pife masam o ne pife ferawai pana bret? Taasaxa faxatang faroxoi nami xa xasena yiis sina mu Ferasi e mu Sedusi.” ");
INSERT INTO leu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","E mui ri masam o a pife ferawai pana yiis ina fasul a flaua, taasaxa, a ferawai pana fepitaian sina mu Ferasi e mu Sedusi. ");
INSERT INTO leu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Na Yesus a falet xe pe Sesaria Filipai e pave a fin a mu fefeng sina, “A mu rabuna ri lamon o a Natuna Mataa ve naseꞌ?” ");
INSERT INTO leu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ri suie, “Saxanofuna ri kuus o ‘na Jon ina Fasufan’ e saxanofuna ri kuus o ‘Na Ilaija’ e saxanofuna laa ri kuus o ‘Na Jeramaia o saxa mataa patak ina kuus fatuxai.” ");
INSERT INTO leu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","E na Yesus a fin nari, “E nami, mi kuus malaafaa sega?” ");
INSERT INTO leu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Na Saimon Pita a suie, “Nano ve a Mataa Failai, a Natuna Piran aava to vulai.” ");
INSERT INTO leu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","E na Yesus a xuuse, “Saimon, no natu Jona, no taa faamamaas senaso pi ta mataa a fapiti nano pana tuunayan aanabeꞌ, piau. Na Tamaang pe la xunavata, nane xa a xuus fatexaas nano pana. ");
INSERT INTO leu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","E ne xuus nano, Pita, nano ve no faat lava e layaan ne xel faxuvul a mu rabuna aava ri taa namkai sega, nano ve no faat aava fufuna faxuvulan aave e a gutan ina maatan i taa pife faꞌonam a faxuvulan aave. ");
INSERT INTO leu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ne taa tavai nano pana xakap talo a so ta mo no pis votane nabeꞌ la xavala a Piran pe la xunavata, i taa turoxo pana. E a so ta mo no muluse nabeꞌ la xavala a Piran pe la xunavata, i taa turoxo pana vaxa.” ");
INSERT INTO leu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","E na Yesus a pebukan a mu fefeng sina o ri muta kuus fasavat o nane ve a Mataa Failai sina Piran. ");
INSERT INTO leu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti lana yaan aave na Yesus a tangpat pana xuus famatavasaana mu fefeng sina o a Piran a vubuk rao i taa laak xe Jerusalem. E pave a mu paamua priis, mu matalava e mu rabuna ina fepitaa pana vuputkai ri taa fasavat a maasaxan molava xuluna. E ri taa xuus faagutan a rabuna o ri taa punuxe taasaxa la fatalatulaana yaan a Piran i taa fatatoi faꞌulie ti la mamaat. ");
INSERT INTO leu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","E na Pita a xele xe la xasing xena barase sena ferawaian sina e a kuus, “Piau, a mo aanabeꞌ i taa pife savat siim, Memai.” ");
INSERT INTO leu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Na Yesus xo a tapuk e kuus xe si Pita, “Faapalau sega, Setan! Nano, no mo ina sopitaian siak. A Piran pife tavai nano pana lamonan siim, piau, ri savat sina mataa.” ");
INSERT INTO leu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","E na Yesus a kuus xe sina mu fefeng sina, “Naseꞌ ta mataa a buk usiau, i taa faaxolusan nane xa e i taa yaas a bolo sina e i taa usiau. ");
INSERT INTO leu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Naseꞌ ta mataa a lamon o a toyan sina a mo molava i taa piau ta toyan tuuna. Taasaxa naseꞌ ta mataa a lamon o a toyan sina pife mo molava senaso a vubuk usiau, nane xo i taa toxan a toyan tuuna paaliu. ");
INSERT INTO leu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tamo mataa taa siak a maana mo roxo aava waan la xavala taasaxa, a toyan tuuna sina a malit, a maana mo aave ri taa xavange malaafaa? Piau, ri taa pife xavange. Piau ta mo nane fexaxaas sena tatavai pana xena maraan faꞌuli a toyan sina. ");
INSERT INTO leu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ne kuus malaanabeꞌ senaso faasilak a Natuna Mataa i taa savat. I taa filimaan lana miridingan sina Piran xuvul pana mu angelo sina. E mui, i taa fasepirigus a maana rabuna fexaxaas malaan sena vilaana siri. ");
INSERT INTO leu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ne xuus tuunei nami o saxanofuna la palou imi ri taa pife maat lunai e ri taa xalum a Natuna Mataa taxa savat xuvul pana fatataganan sina.” ");
INSERT INTO leu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","A yaan pisaxa lumui na Yesus a xel patak na Pita e ro fetinan Jems nare Jon e a paamuian narutul xe laaꞌui paaliu la put e ri waan nari sang mon. ");
INSERT INTO leu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Layaan rutul taxa faalim, a xakaaluman si Yesus a puk: a nonau ina a lang malaan sena ngaas e a marapi sina a rarapak malaan sena yaamit. ");
INSERT INTO leu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","E rutul ipulan na Moses nare Ilaija re taxa ferawai xuvul pa Yesus. ");
INSERT INTO leu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","E na Pita a kuus xe si Yesus, “Memai, a mo roxo taara taxa waan nabeꞌ. Tamo no vubuxane ne taa vesan a sawat talatul nabeꞌ, saxa xanum, saxa xa Moses e saxa xa Ilaija.” ");
INSERT INTO leu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","La fena ferawaian sina a vata rarapak maa xafut nari e a ling ti la vata aave a ferawai malaan, “Nabeꞌ ve a lak siak aava ne vubuxan xasingite. Nane fuuna fafaamamaasau. Langaie!” ");
INSERT INTO leu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Layaan rutul langai a ling aave rutul mataut temasaat e rutul poxo turung xe lapi la xavala. ");
INSERT INTO leu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Taasaxa na Yesus maa tao narutul e a kuus, “Tamasiak, muta mataut.” ");
INSERT INTO leu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","E rutul saraak xe laaꞌui e xalum na Yesus mon, pi ta mataa fulaa. ");
INSERT INTO leu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Layaan ri taxa sivi ti xuluna put na Yesus a xuus faagutan narutul, “Muta xuus ta mataa pana xakaaluman aanabeꞌ aava mutul fo xalume fefexaxaas a yaan a Piran i taa fatatoi faꞌuli a Natuna Mataa ti la mamaat.” ");
INSERT INTO leu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","E a mu fefeng aave ri fine, “Senasou a mu rabuna ina fepitaa pana vuputkai ri kuus o na Ilaija i taa filimaan paamua?” ");
INSERT INTO leu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","E nane sui nari, “A tuuna, na Ilaija i taa ulaamaan e i taa faigotan a maana rabuna. ");
INSERT INTO leu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Taasaxa ne xuus nami o na Ilaija fo filimaan xo e a mu rabuna ri ngalngolane e ri vil a saat xe sina. E malaanabeꞌ ri taa vil a saat vaxa xe sina Natuna Mataa.” ");
INSERT INTO leu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","E a mu fefeng ri masam o i taxa ferawai paap xe siri se Jon ina Fasufan. ");
INSERT INTO leu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Layaan ri sivi ulaa xe sina malila, saxa mataa maa savat si Yesus e bukaak la nona, ");
INSERT INTO leu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","e nane kuus, “Matalava, muluk na natuk. Nane toxan a giisan la putuna e fuuna gaga e maana yaan fuuna poxo xe lana fata o raarum. ");
INSERT INTO leu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","E ne lisanmaane xe sina mu fefeng siim taasaxa ri pife fexaxaas sena xavange.” ");
INSERT INTO leu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","E na Yesus a suie, “Nami mu rabuna, mi pi namkai e mi milung vulai! Mi famaareau. Ne taa waan xuvul pami pana yaan talavisan fulaa? Lisanmaan a lak xe siak.” ");
INSERT INTO leu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na Yesus a baras a vovau saat e a vovau saat aave taꞌulan a lak aave e monabeꞌ mon nane roxo fulaa. ");
INSERT INTO leu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","E mui, layaan pi ta rabuna fulaa ri taxa waan, a mu fefeng ri maa fin na Yesus, “Senasou e maam pife fexaxaas sena gei tapin a vovau saat aave?” ");
INSERT INTO leu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","E nane sui nari, “Senaso a namkaian simi pife fexaxaas. Ne kuus tuuna, tamo a namkaian simi a fexaxaas malaan sena fomirak kam ina wai mastaat, mi taa kuus xe sina put aanabeꞌ, ‘Talaput nabeꞌ e falet xe pave!’ e i taa falet. Piau ta mo mi pife fexaxaas sena vile.” ");
INSERT INTO leu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Taasaxa a buk mo aanabeꞌ i taa pife falet palau. Mi taa falfaal e fenung xena gei tapine.” ");
INSERT INTO leu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Layaan a mu fefeng ri waan xuvul pa Yesus pe Galili, na Yesus a xuus nari, “Faasilak, saxano rabuna ri taa pet lisan a Natuna Mataa xe sina mu rabuna aava ");
INSERT INTO leu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ri taa punuxe. Taasaxa lamina yaan talatul a Piran i taa fatatoi faꞌulie ti la maatan.” E a mu fefeng ri kanamsaat sena ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Layaan na Yesus xuvul pana mu fefeng sina ri savat pe Kapanam a mu rabuna ina siak taakis ina tang lifu lotu ri maa savat si Pita e ri fine, “A mataa ina fepitaa simi, nane maraan a taakis ina tang lifu lotu, bo?” ");
INSERT INTO leu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Na Pita a sui nari, “A tuuna, nane fuuna maraane.” Layaan na Pita a laak la lifu, na Yesus a ferawai paamuine, “Saimon, no lamon malaafaa? Naseꞌ maraan a taakis aava paamua ti la xavala a ferawai pana? A mu rafulak sina o mu topen?” ");
INSERT INTO leu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","E na Pita a suie, “A mu topen.” E na Yesus a xuuse, “Lavaxa, a mu rafulak xo ri taa pife maraane. ");
INSERT INTO leu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Taasaxa taara bai kawaasan a waanan sitaara xuvul pari. E voxo, falet xe la raarum e fadui a yeis ina ngaulaana din. A din mata aava no ngaule, kas a valana e no taa tingin a faat xena maraan a taakis siak e siim sait. Lisan a faat aave xe siri xena maraan a taakis sitaare.” ");
INSERT INTO leu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","E lana yaan aave a mu fefeng ri maa fin na Yesus, “Naseꞌ a matalava lana fatataganan sina Piran?” ");
INSERT INTO leu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","E na Yesus a xelmaan a saxa lak xe sina e fatigineie la palou iri ");
INSERT INTO leu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","e a kuus, “Ne xuus tuunei nami o tamo mi buk laak xe lana fatataganan sina Piran, mi taa xul a vilaana simi e mi lamon malaan sena mu rafulak. ");
INSERT INTO leu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nane aava matalava lana fatataganan sina Piran, i taa lamon fasivi nane xa malaan sena lak aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“E naseꞌ ta mataa a kas a lifu sina xe sina saxa aava namkai sega malaan sena lak aanabeꞌ, nane i taxa kas a lifu sina xe siak sait. ");
INSERT INTO leu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Taasaxa naseꞌ ta mataa familung a saxa aava namkai sega malaan sena lak aanabeꞌ, a mo roxo naak ri taa xiute pana faat lava paaliu e tapin faxaraxe la bina tu pe la laman. ");
INSERT INTO leu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“I taa pife falet faroxo pami mu rabuna la xavala senaso toxan a valaman aava familung nami e kawaasan a namkaian simi! A maana mo aave, vulai ri taa savat taasaxa i taa pife falet faroxo panꞌ ta mataa aava familung a xasa mataa! ");
INSERT INTO leu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tamo a maam o kaam a fasavat a vilaana saat la toyan siim, patal tapine; a mo roxo no taa laak lana toyan vulai pana maam o kaam a malit sena toxanaana ro maam o ro kaam e waan la bina ina fata i taxa raam vulai. ");
INSERT INTO leu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","E tamo a mataam a fasavat a vilaana saat la toyan siim, xival tapine. A mo roxo no taa laak lana toyan vulai pana pamata saxa mon sena toxanaana ro mataam e waan la bina ina fata i taxa raam vulai.” ");
INSERT INTO leu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","E na Yesus a ferawai et, “Muta lamon fasivi xulunꞌ ta saxa lak aava namkai sega senaso ne xuus nami o mu angelo pe la xunavata aava faxatang nari, vulai ri fexaxaas sena savat la nona Tamaang pave la xunavata, pari. ");
INSERT INTO leu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Senaso a Natuna Mataa a savat xena fakaxup nari aava ri milung. ");
INSERT INTO leu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mi lamon malaafaa? Tamo mataa toxan a mu sipsip sangafilu sangafilu e saxa milung, i taa vil a so? I taa taꞌulan a xasano sipsip aava taxa waan xuluna put xena fangan e i taa fe seng a saxa aava fo milung, bo? ");
INSERT INTO leu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A mataa ina faxatangaana sipsip aave a faamamaas sena mu sipsip aava taxa waan taasaxa ne xuus nami, i taa faamamaas paaliu layaan a tingin a saxa aava tamu milung. ");
INSERT INTO leu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","E malaanabeꞌ na Tamaang pe la xunavata a baian ta saxa ina mu rafulak sina ri taa milung. ");
INSERT INTO leu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Layaan na tiam lana namkaian i taa vil a saat xe siim, falet xe sina e xuus famatavase pana faasaalan sina. Taasaxa, muta vile la matana rabuna, piau, vile la palou ime mon. Tamo a langai lavaxa, no fo vil faroxoi fulan a fetuwaanan sime. ");
INSERT INTO leu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Taasaxa, tamo i taa pife langai siim, falet fulaa xe sina xuvul pana mataa saxa o taragua. Layaan no vil malaane no taxa usi a xakalayan sina Piran e nare aava re falet xuvul pama re taa ferawai xakaavang pana maana mo aava no gel tifie pana. ");
INSERT INTO leu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","E tamo nane taa pife langai sire lavaxa, kuusane xe sina mu rabuna lana lotu. E tamo nane bai langai siri lunai, bilai xe sina malaan seꞌ nane ve a mataa ina siak taakis o ta xasa mataa aava pife namkai. ");
INSERT INTO leu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“E voxo, ne xuus tuunei nami xapiak o a so ta mo mi pis votane nabeꞌ la xavala, a Piran pe lana xunavata i taa turoxo pana. E so ta mo mi muluse nabeꞌ la xavala, a Piran pe la xunavata i taa turoxo pana vaxa. ");
INSERT INTO leu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","E ne xuus fulan nami, layaan nami nabeꞌ la xavala, mi fenung turoxo pana mo, na Tamaang pe la xunavata, i taa tamana vile. ");
INSERT INTO leu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Senaso layaan a nutuvaat ri faxuvul lapaana isaak, nenia, ne waan xuvul pari.” ");
INSERT INTO leu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","E mui na Pita a falet xe si Yesus e fine, “Memai, tamo na tiak taxa lo vil a saat sega, a yaan talavisan ne taa lamon tapin a vilaana sina? Pisiguak?” ");
INSERT INTO leu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","E na Yesus a suie, “Piau, pife yaan pisiguak mon, taasaxa mu yaan sangafilu pisiguak faapisiguak. ");
INSERT INTO leu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Senaso a fatataganan sina Piran a malaan sena saxa piran king aava lamon o i taa kaalum pana faisok sina mu sisiak lava sina. ");
INSERT INTO leu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Layaan a tangpat pana xalumaana, a rabuna ina faisok sina ri lisanmaan a saxa sisiak lava aava fo siak palou a maana faat xaves paaliu marasaxa. ");
INSERT INTO leu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","A sisiak aave pife fexaxaas sena lisan faꞌuli xapine e voxo a piran a kuus o ri taa faasot pana sisiak aave e pana tefin e mu rafulak sina xuvul pana maana mo sina xena fasoxul a faat aava nane fo siak paloue. ");
INSERT INTO leu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“E voxo a sisiak aave a poxo tapiturung la xavala e nung a piran, ‘Matalava, tavaiau pana yaan fulaa e ne taa lisan faꞌuli a maana mo xapiak siim.’ ");
INSERT INTO leu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","E a piran xo a muluxe e lamon tapine e muluse sena sui faꞌuliaana faat xaves aave. ");
INSERT INTO leu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“E mui a sisiak naang a xalum a saxa aava sisiak xuvul pana e nane vaxa fo siak palou a fomirak faat modak mon sena sisiak aave. Taasaxa a sisiak naang a tao vingit a kolumana e a kuus, ‘Lisan faꞌuli a faat siak aava no fo siak paloue.’ ");
INSERT INTO leu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“E a sisiak aanabeꞌ a poxo tapiturung la xavala e nunge, ‘Tavaiau pana yaan fulaa e ne taa lisan faꞌuli a maana mo xapiak siim.’ ");
INSERT INTO leu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Taasaxa nane kuus, ‘Piau!’ e a xuus faagutan a mu rabuna o ri taa pise lana lifu ina vipisan fefexaxaas a yaan i taa lisan faꞌuli a maana mo xapiak sina. ");
INSERT INTO leu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Layaan a xasano sisiak ri xalum a so ta mo a savat ri kanamsaat e ri fe xuus fatexaas a mataa piran siri pana. ");
INSERT INTO leu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“E voxo a piran aave a xelmaan a sisiak aava nane fo lamon tapine e xuuse, ‘Nano, no sisiak saat. Nenia, ne lamon tapin a vilaana saat siim e ne kuus o no taa pife lisan faꞌuli a maana mo siak senaso no nungau pana. ");
INSERT INTO leu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nenia, ne muluk nano e voxo a mo roxo nano xo, no taa muluk a saxa aava faisok xuvul pama.’ ");
INSERT INTO leu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","E a piran a marala faagut e a kuus, ‘Pis a sisiak aave talo a rabuna ina faxatang a mu vipis ri taa sip pengane fefexaxaas a yaan i taa lisan faꞌuli a maana mo xapiak.” ");
INSERT INTO leu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","E na Yesus a fataxapin a xuuskuus aanabeꞌ malaan: “Na Tamaang pe la xunavata, i taa bilai malaan sena piran king aave xe simi tamo mi pife lamon tapin tuunei a vilaana saat sina mu timi.” ");
INSERT INTO leu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Layaan na Yesus a fataxapin a maana ferawaian aanabeꞌ a taꞌulan a bina Galili e falet xe pe Judia la xasa paxasing ina Raarum Jordan. ");
INSERT INTO leu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","E a malila molava ri usie e nane vil faroxoi nari pave. ");
INSERT INTO leu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Saxano Ferasi ri maa savat sina xena tafange pana fiaian siri. Ri fine, “A tuuna a vuputkai sitaara a turoxoian a mataa xena fataxapin a tamaian sina xuvul pa naasana xena usi a so ta buk vubuxanan sina, bo?” ");
INSERT INTO leu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","E na Yesus a sui nari, “Mi pife kat lunaian a xakalayan sina Piran aava kuus o ti la tangpat a Piran ina Vavesai a vesan a mu rabuna xapiak, nari mu tomexaan e nari lutefin, bo? ");
INSERT INTO leu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","E a Piran a kuus laa, ‘Sena fufuna aanabeꞌ a mataa taa taꞌulan na tamana e na ninana e i taa fexuvulai xuvul pa naasana, e re taa savat vipin saxa mon.’ ");
INSERT INTO leu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","E voxo re pife rovaat taragua fulaa, piau, nare, re saxa mon. Piau ta mataa i taa fepatoxan a rofelavaan senaso Piran fo faxuvul nare.” ");
INSERT INTO leu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","E ri kuus xe sina, “Senasou e na Moses a turoxoian a mataa xena tavai na naasana pana lagasai ina fataxapinaana tamaian sire e feng tapine?” ");
INSERT INTO leu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","E na Yesus a sui nari, “Na Moses a turoxoian nami xena fataxapinaana tamaian xuvul pa naasami senaso mi fatavanat a lamonan simi e mi bai langai. Taasaxa ti la tangpat a pife malaanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ne xuus nami o layaan a naasana mataa a waan fatak la tana e pife mati xuvul pana saxa mataa patak, tamo na lavana a fataxapin a tamaian sire e tamai xuvul pana saxa tefin patak, i taxa milung pana vilaana ina tamaian.” ");
INSERT INTO leu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A mu fefeng sina ri kuus xe sina, “Tamo a malaanabeꞌ la palou ina rofelavaan naak a mo roxo re taa pife tamai.” ");
INSERT INTO leu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Taasaxa na Yesus a suie, “Pi ta rabuna xapiak ri fexaxaas sena turoxo pana fepitaian aanabeꞌ taasaxa nari aava Piran a kas a lamonan siri, ri taa tawe. ");
INSERT INTO leu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ne taa kuus famatavas; a toxan a fufuna xaves sena mataa aava pife tamai: saxanofuna ri pife fexaxaas sena tamai ti lana luluuxan siri; saxanofuna ri pife fexaxaas sena tamai senaso a rabuna ri patal tapin nari e saxanofuna ri lamon faati o ri taa pife tamai senaso ri buk sisiak faroxo xe sina Piran. Tamo mi fexaxaas sena turoxo pana fepitaian aanabeꞌ lavaxa, langaie.” ");
INSERT INTO leu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Saxano rabuna ri lisan a rafulak modak xe si Yesus talo i taa tao nari e fenung xe sina Piran pari. Taasaxa mu fefeng sina ri baras nari. ");
INSERT INTO leu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","E na Yesus a kuus, “Turoxoian a mu rafulak xena filimaan xe siak, muta ti votan nari. Senaso a fatataganan sina Piran ve a nobina sina rabuna malaan sena mu rafulak aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E nane yot nari e fenung pari e mui a taꞌulan a bina aave. ");
INSERT INTO leu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Saxa yaan a mataa faꞌui a filimaan xe si Yesus e fine, “Mataa ina Fepitaa, a so ta mo roxo ne taa vile xena siak a toyan vulai?” ");
INSERT INTO leu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","E na Yesus a suie, “Senasou e no finau pana so ta mo a roxo? A Piran sang mon a roxo. No taa usi fatak a mu vuputkai tamo no buk laak lana toyan vulai.” ");
INSERT INTO leu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","E a mataa aave a fine, “A so ta vuputkai?” E na Yesus a suie, “Muta punuk mataa; muta femilungai pana vilaana ina tamaian; muta fenau; muta bit tifi ta mataa; ");
INSERT INTO leu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","suai se tamaam e ninaam e vubuxan xasingit a xasano rabuna malaan seꞌ no vubuxan xasingit nano xa.” ");
INSERT INTO leu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","A mataa faꞌui aave a kuus, “Ne fuuna usi fatak a maana vuputkai aave. A so ta mo fulaa ne taa vile?” ");
INSERT INTO leu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","E na Yesus a xuuse, “Tamo no vubuk usi fatak a vubuxanan sina Piran no taa fe faasot pana maana mo siim e a faat ina, tatavai xe sina mu valagof pana e no taa toxan a maana fafanaian roxo pe la xunavata; e mui, maa usiau.” ");
INSERT INTO leu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Layaan a mataa faꞌui aave a langaie, nane kanamsaat paaliu e falet patak senaso a toxan a maana fafanaian xaves. ");
INSERT INTO leu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na Yesus a kuus xe sina mu fefeng sina, “Ne xuus tuunei nami, a mo lagaf paaliu sena mataa piran xena laak la fatataganan sina Piran. ");
INSERT INTO leu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A tuuna, a ‘kaamel’ aava tiir molava sena hos, a fexaxaas sena laak xe lana valof ina niil paamuina mataa piran i taa laak xe lana fatataganan sina Piran Tuuna.” ");
INSERT INTO leu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Layaan a mu fefeng ri langaie, ri ipul faagut e ri fine, “Naseꞌ taa fakaxupan xena to vulai?” ");
INSERT INTO leu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Na Yesus a kaalum fatak xe siri e sui nari, “A mataa pife fexaxaas sena vil a mo aanabeꞌ taasaxa Piran a fexaxaas sena vil a maana mo xapiak.” ");
INSERT INTO leu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","E na Pita a suie, “Kaalum, maam fo taꞌulan a maana mo xapiak xena usi nano. Maam taa toxan a so ta mo?” ");
INSERT INTO leu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","E na Yesus a xuuse, “A tuuna, lana yaan mui layaan a maana mo xapiak i taa faꞌui, a Natuna Mataa i taa nai lana malang la vepen ina nai piranan sina. E nami aava mi fuuna usiau, mi taa nai la mu vena naian roxo simi xena paamuian a mu pabung sangafilu saxa pana taragua ti Israel. ");
INSERT INTO leu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","E naseꞌ ta mataa aava taꞌulan a mu tina o vasaana, tamana, ninana o rafulak, lifu o xavala xena usiau, i taa siak a maana mo xaves paaliu sena maana mo aave e vaxa a Piran i taa tavaie pana toyan vulai. ");
INSERT INTO leu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Taasaxa nari aava ri waan paamua naboxo, ri taa waan la fataxapiak e nari aava ri waan la fataxapiak naboxo, ri taa waan paamua.” ");
INSERT INTO leu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","E na Yesus taxa lo ferawai malaan: “A Fatataganan sina Piran a malaanabeꞌ. Saxa yaan a toxan a mataa piran aava taꞌulan a lifu sina la paanen lolof e fe xel a saxano rabuna xena faisok la uma wain sina. ");
INSERT INTO leu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nane turoxo o i taa maraan a faisok siri pana mamareiai fatak aava saxa faat ‘silva’ pana yaan saxa e feng nari xena faisok la uma sina. ");
INSERT INTO leu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Faasilak la yaan ina num ti, a falet fulaa xe la bina ina faasot e xalum a saxano rabuna ri taxa waan palau, ");
INSERT INTO leu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","e a xuus nari, ‘Nami vaxa, mi falet xena faisok la uma siak e ne taa tavai nami pana mamareiai aava roxo.’ ");
INSERT INTO leu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","E ri falet. “Fulaa, layaan a ngaas a waan laaꞌui e la yaan ina num ti la paanaas nane vil malaane. ");
INSERT INTO leu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","E faasilak leaaf a falet fulaa xe la bina ina faasot e xalum a saxanofuna laa ri taxa nai palau. Nane fin nari, ‘Senasou mi taxa waan palau la yaan xurul?’ ");
INSERT INTO leu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","E ri suie, ‘Piau ta mataa a maraan nemaam.’ “E nane kuus xe siri, ‘Lavaxa, nami vaxa, mi fe faisok la uma siak.’ ");
INSERT INTO leu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Layaan a yaan ina maraan a mu rabuna ina faisok a savat a mataa tafuna uma a xuus a paamua ina faisok, ‘Xel faxuvul a mu rabuna ina faisok e tavai nari pana mamareiai ina faisok siri. Tangpat pari aava ri savat la fataxapiak e taxapus pari aava ri savat la paanen lolof.’ ");
INSERT INTO leu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Nari aava ri tangpat faisok leaaf nari saxa saxa, ri siak a faat ‘silva’ aava mamareiai roxo. ");
INSERT INTO leu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","E layaan a rabuna aava ri tangpat faisok la paanen lolof ri savat xena siak a mamareiai siri ri ilisai, o naak ri taa siak a mamareiai molava taasaxa nari vaxa ri siak a faat ‘silva’ saxa aava mamareiai roxo. ");
INSERT INTO leu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ri siak a faat siri e ri fefinaasan a mataa tafuna uma aava maraan nari. ");
INSERT INTO leu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ri kuus, ‘A mu rabuna aava ri savat leaaf ri fo faisok pana yaan modak mon e nemaam, maam faisok a yaan xurul lana ngaas lalagaf taasaxa no tavai nari pana mamareiai a fexaxaas sena mamareiai simaam.’ ");
INSERT INTO leu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Taasaxa mataa tafuna uma a sui a saxa siri, ‘Langai ka fesing, ne pife bit nano. No turoxo o no taa faisok a yaan saxa pana mamareiai fatak. ");
INSERT INTO leu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Naboxo, siak a mamareiai siim e falet xe la lifu siim. Ne buk tavai a mataa fataxapiak pana mamareiai roxo sait. ");
INSERT INTO leu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A roxo ne taa usi a vubuxanan siak pana faat siak, bo? Naak nano, no taxa tarasui nari senaso nenia, ne mataa ina fetavai?” ");
INSERT INTO leu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","E na Yesus a fataxapin a xuuskuus aave malaanabeꞌ: “E voxo a mu rabuna aava ri waan la fataxapiak ri taa waan paamua e nari aava ri waan paamua ri taa waan la fataxapiak.” ");
INSERT INTO leu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Na Yesus xuvul pana mu yaamut sina ri taxa laak saa xe Jerusalem e layaan ri taxa sangas et na Yesus a xel faxuvul nari xe sina e a ferawai xe siri mon. ");
INSERT INTO leu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","A xuus nari, “Langaiau, taara taxa laak xe Jerusalem e pave a mu rabuna ri taa lisan a Natuna Mataa xe sina mu paamua priis e mu rabuna ina fepitaa pana vuputkai. E nari xo ri taa turoxo pana punuxaana. ");
INSERT INTO leu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","E ri taa lisane xe sina mu rabuna aava ri pife Juda e nari xo ri taa suaxane e inise pana yeis tuturuk e niil fataxutane xuluna bolo xena punuxe taasaxa la fatalatulaana yaan mui a Piran i taa fatatoi faꞌulie ti la maatan.” ");
INSERT INTO leu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","E lana yaan aave a tefin si Sebedi a filimaan xe si Yesus xuvul pana ro lak tomexaan sina. Nane bukaak la nona rao i taa fine pana saxa mo. ");
INSERT INTO leu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","E na Yesus xo a kuus xe sina, “No vubuxan a so?” E nane suie, “Kuus fanai o layaan no taa piran king no taa fanei a ro lak tomexaan siak la taam: saxa la pamuaan siim e saxa la paxaiya.” ");
INSERT INTO leu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Taasaxa na Yesus a sui a ro lak aave, “Me pife texaas sena so ta mo me taxa finau pana. Name, me fexaxaas sena num lana lisa ina maasaxan aava ne taa nume, bo?” E re suie, “Maame fexaxaas.” ");
INSERT INTO leu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","E na Yesus a xuus nare, “Tuuna, me taa num lana lisa siak taasaxa nenia, ne pife fexaxaas sena siak fati naseꞌ i taa nai la pamuaan e naseꞌ la paxaiya siak. A ro naian aave a Piran, na Tamaang, fo faigotane xana rovaat aava nane fo siak fati nare.” ");
INSERT INTO leu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Layaan a mu yaamut sangafilu ri langai pana fenungan aanabeꞌ, ri marala faagut sere. ");
INSERT INTO leu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","E na Yesus a xel faxuvul nari e kuus, “Mi texaas, a mu piran king sina mu topen ri paamuian nari pana gutan e a mu paamua siri ri toxan a tateaxan xapiak. ");
INSERT INTO leu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Taasaxa mi taa pife bilai malaan la palou imi. Tamo saxa la palou imi a vubuk rao i taa matalava simi lavaxa, i taa sisiak simi xapiak. ");
INSERT INTO leu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","E tamo saxa la palou imi a vubuk rao i taa tigina paamua, i taa waan fepalau e taa sisiak simi ");
INSERT INTO leu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","malaan sena Natuna Mataa aava pife filimaan talo a rabuna ri taa sisiak xe sina taasaxa, a filimaan xena sisiak e xena tatavai pana toyan sina xena mulus tapin a maana rabuna xaves xasena vilaana saat siri.” ");
INSERT INTO leu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Layaan na Yesus e mu fefeng sina ri taꞌulan na Jeriko a malila ri usie. ");
INSERT INTO leu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E rovaat a matare piif re taxa nai la xasing ina salan e re langai o na Yesus i taxa sangas paaliu et nare e voxo re xukulai, “Memai, Natu Devit, muluk nemaame!” ");
INSERT INTO leu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Saxanofuna la palou ina malila ri baras nare e ri xuus nare o re taa nai kasam. Taasaxa re xukulai faagut paaliu laa, “Memai, Natu Devit, muluk nemaame!” ");
INSERT INTO leu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","E na Yesus a tigina e xel nare e fin nare, “A so ta mo me vubuk rao ne taa vile pame?” ");
INSERT INTO leu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","E re xuuse, “Memai, kas a matamaame talo maame taa kaalum.” ");
INSERT INTO leu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Na Yesus a muluk nare e tao a matare e monabeꞌ mon re kaalum fulaa e re usie. ");
INSERT INTO leu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Layaan na Yesus xuvul pana mu fefeng sina ri filimaan faasilak la bina Jerusalem ri savat pe la bina Betfas aava waan la Put Olif. E pave na Yesus a feng a ro fefeng sina ");
INSERT INTO leu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","e xuus nare, “Falet paamuin nemaam xe lana bina aapave e me taa tingin a ‘donki’ tefin xuvul pana natuna. Ri fo pis a ‘donki’ tefin aave. Muluse e lisanmaane xe siak. ");
INSERT INTO leu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tamo ta mataa taa ferawai xe sime pana, me taa xuuse, ‘A Memai a vubuxan nare’ e a mataa aave i taa feng nare xuvul pame.” ");
INSERT INTO leu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A mo aanabeꞌ a savat xena faxalit famatavasaana ferawaian aava lokavai mupiis a Piran a kuus pana, la ngusuna mataa ina kuus fatuxai sina: ");
INSERT INTO leu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Xuus a mu rabuna la bina Jerusalem pana, ‘Kaalum, a piran king simi i taxa filimaan xe simi! Nane a mataa mam e a falet xolai xuluna ‘donki’, tuuna nane taxa nai laaꞌui xuluna natuna ‘donki’.” ");
INSERT INTO leu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","E a ro fefeng aave re fe vil a mo aava na Yesus a xuus nare pana. ");
INSERT INTO leu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Re lisanmaan a ‘donki’ aave xuvul pana natuna e re timin a marapi ina vupungan sire xulure e na Yesus a nai laaꞌui xuluna. ");
INSERT INTO leu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","A malila ri tapalan a marapi ina vupungan siri la salan e saxanofuna ri patal a maana raxana wai e ri tapalane la salan. ");
INSERT INTO leu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","A malila aava ri sangas paamuin na Yesus e nari aava ri sangas lumui lamina ri xukulai, “Faatulan a Natu Devit. A piran king aava savat lapaana isi Memai, a naian sina a roxo paaliu. Taara xapiak taara kuus faatulan a Piran sena fakaaxupan sina.” ");
INSERT INTO leu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Layaan na Yesus a laak la bina Jerusalem, a mu rabuna pave ri faamamaas faagut paaliu sena e ri fiai, “Nane ve naseꞌ?” ");
INSERT INTO leu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","E a malila aava ri waan xuvul pa Yesus ri sui nari, “Nane ve na Yesus ti la bina Nasaret pe Galili. Nane a mataa ina kuus fatuxai aava Piran a kuus fanai pana.” ");
INSERT INTO leu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na Yesus a laak xe pe la lifu lotu e xup tapin nari aava ri faasot xuvul pari aava ri maraan a maana mo ina tatavai xe sina Piran. Nane puk a maana ivin sina mu rabuna ina xulaana faat e a mu ivin siri aava ri faasot pana vaalus. ");
INSERT INTO leu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Nane kuus xe siri, “Lana Xakalayan sina Piran a kuus, ‘Ri taa xali a lifu siak pana lifu ina fenungan.’ Taasaxa nami, mi taxa bilai malaan sena lifu aanabeꞌ ve a nobina ina fufunai sina mu rabuna fafenau.” ");
INSERT INTO leu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","A mu rabuna piif e nari aava kari tapil ri savat xe sina lana lifu lotu aave e nane vil faroxoi nari. ");
INSERT INTO leu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","A mu paamua priis e mu rabuna ina fepitaa pana vuputkai ri xalum a maana mo roxo aava na Yesus taxa vile e layaan ri langai a mu rafulak pe la lifu aave ri taxa xukulai malaan, ‘Kuus fati na natu Devit!’ ri marala ");
INSERT INTO leu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","e ri xuuse, “Nano, no langai pana ferawaian sina mu rafulak aanabeꞌ, bo?” E na Yesus a sui nari, “Aang, ne langai nari. E nami, mi pife kat a mo aanabeꞌ lana Xakalayan Taap? ‘No fo fapiti a mu rafulak e mu popo talo ri taa kuus faatulai fatak.” ");
INSERT INTO leu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na Yesus a taꞌulan nari e falet xe la bina Betani xena matef. ");
INSERT INTO leu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","A yaan mui la paanen lolof, layaan i taxa ulaa xe la bina lava, nane lagai. ");
INSERT INTO leu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","E nane xalum a wai xakaap la xasing ina salan e falet soxote taasaxa pi ta xalana, a paxana mon. E nane kuus xe sina wai, “No taa pife fuaa fulaa!” E a wai xakaap a maiyang faꞌipul. ");
INSERT INTO leu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","A mu fefeng sina ri ipul faagut layaan ri xalume e ri fine, “A wai xakaap a maiyang faꞌipul malaafaa?” ");
INSERT INTO leu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","E na Yesus a sui nari, “Ne xuus tuunei nami, tamo mi namkai e mi muta lamon maranga, mi fexaxaas sena vil a so ta mo ne fo vile xe sina wai aanabeꞌ. E pife mo aanabeꞌ mon, piau, mi fexaxaas sena ferawai xe sina put modak nabeꞌ ‘Tamasiak e fe tapin nano xa la laman!’ e i taa vil malaane. ");
INSERT INTO leu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tamo mi namkai e mi fenung xe sina Piran panꞌ ta mo, nane xo i taa vil a so ta mo mi fenung pana.” ");
INSERT INTO leu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na Yesus a ulaa xe pe la tang lifu lotu e layaan i taxa fepitaa pave a mu paamua priis e mu matalava ri fe savat sina e ri fine, “No taxa vil a maana mo aanabeꞌ lapaana tateaxan iseꞌ?” ");
INSERT INTO leu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","E na Yesus a sui nari, “Ne taa fin nami pana fiaian saxa mon e tamo mi fexaxaas sena suiau, ne taa xuus nami lapaana tateaxan iseꞌ ne taxa faisok. ");
INSERT INTO leu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Na Jon xo nane fasuf a rabuna lapaana tateaxan ina Piran o ina mataa?” E nari, ri fexuus la palou iri e saxanofuna ri kuus, “Taara taa kuus panaso? Tamo taara suie o ‘Ina Piran,’ i taa fin netaara ‘Tamo ina Piran, senasou mi pife namkai sena lagasai si Jon?’ ");
INSERT INTO leu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Taasaxa tamo taara kuus, ‘Ina mataa,’ taara taa mataut sena malila senaso ri lamon o na Jon a saxa mataa ina kuus fatuxai.” ");
INSERT INTO leu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","E voxo ri sui na Yesus, “Maam pife texaas sena.” E na Yesus a kuus xe siri, “E nenia vaxa ne taa pife xuus nami o naseꞌ tavaiau pana tateaxan xena vil a maana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Lavaxa, mi lamon malaafaa? A toxan a mataa aava toxan a ro lak tomexaan. Nane falet xe sina lak tuaan e xuuse, ‘Kalak, fe faisok la uma siak tanin.’ ");
INSERT INTO leu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","E a lak aave a suie, ‘Ne bai.’ Taasaxa mui nane xul a lamonan sina e falet. ");
INSERT INTO leu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“E mui na tamare a falet xe sina xasa lak e kuus pana mo naang. E a lak aave xo a suie, ‘Aang, ne taa falet’ taasaxa pife falet xena faisok.” ");
INSERT INTO leu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","E na Yesus a fin a mu paamua priis e mu matalava, “Naseꞌ ta lak a usi a vubuxanan si Tamare?” E nari, ri suie, “A lak tuaan.” E na Yesus a kuus xe siri, “Ne xuus tuunei nami o a mu rabuna ina faxuvul a taakis e lutefin ina lisan xolanaan nari, ri taa laak paamuin nami xe la fatataganan sina Piran. ");
INSERT INTO leu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Senaso na Jon ina Fasufan maa savat simi e faxalit nami o mi taa bilai malaafaa xena fafaamamaas a Piran e nami, mi bai namkai sena lagasai sina. Taasaxa mu rabuna ina faxuvul a taakis e lutefin ina lisan xolanaan nari, ri namkai sena. Naapalaan mi xalum a mo aanabeꞌ mi pife xul a lamonan simi xena namkai sena.” ");
INSERT INTO leu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Na Yesus a kuus, “Langai sena saxa ferawaian paap fulaa. A toxan a mataa tafuna xavala a xapis a uma sina pana yeis ina xalana wain. E nane fakaliuane pana vaafa e xaf a vaaꞌul xena mimit a xalana aave. E nane vesan a lifu modus xe laaꞌui xana rabuna ina faxatangaana uma sina. E mui nane tingin a saxano rabuna xena faisok e faxatang a uma e nane xo a taꞌulan a lifu sina xena falet xe pe la saxa bina lasuun. ");
INSERT INTO leu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Layaan a yaan ina faxuvulaana mu xalana wain a savat a mataa tafuna uma aave a feng a mu sisiak sina xena siak a saxano xalana wain xana. ");
INSERT INTO leu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“E a mu rabuna ina faxatangaana uma ri yot a mu sisiak sina e ri sip a saxa e ri ngaapunuk a saxa e ri soxoi punuk a saxa pana faat. ");
INSERT INTO leu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","E mui fulaa, nane feng a xasano sisiak pexaxaves e a mu rabuna ina faxatangaana uma ri bilai fasaat xe siri malaan sena xasanofuna paamua. ");
INSERT INTO leu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","E lumui lamina a mataa tafuna uma aave a feng a lak tomexaan sina xe siri senaso a ilisai, ‘Naak, ri taa suai faagut sena lak siak.’ ");
INSERT INTO leu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Taasaxa layaan a mu rabuna aave ri xalum a lak tomexaan, ri fexuus, ‘A lak tuaan aanabeꞌ i taa siak a maana mo si tamana. Man, taara taa punuxe xena siak a maana mo xapiak sina.’ ");
INSERT INTO leu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ri yote e tapine ti lana uma xe lamalei e ri ngaapunuxe.” ");
INSERT INTO leu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","E na Yesus a fin nari, “Lavaxa, layaan a mataa tafuna uma aave i taa savat, i taa vil a so xe siri mu rabuna ina faxatangaana uma?” ");
INSERT INTO leu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","A mu paamua priis ri suie, “I taa punuk nari mu rabuna saat e seng a xasano rabuna aava ri taa tavaie pana saxano xalana wain xana, xena faxatangaana uma.” ");
INSERT INTO leu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","E na Yesus a kuus xe siri, “Mi pife kat paamuin a Xakalayan Taap aava kuus: ‘A Faat aava mu rabuna ina vavesai ri gilise malaan sena mo palau, a faat aave a pelalava sena xasano faat xapiak. A mo aanabeꞌ aava maam pangaa pana ve a faisok sina Memai.” ");
INSERT INTO leu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","E na Yesus a kuus fulaa, “E voxo ne xuus nami, a Piran i taa ti votan nami xasena laaxan la fatataganan sina e i taa kase xe siri aava ri vil a faisok roxo. ");
INSERT INTO leu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Naseꞌ ta mataa a poxo xuluna faat naang i taa tugurum sena e tamo a faat naang i taa poxo xulunꞌ ta mataa i taa mimite e a mataa aave i taa malaan sena pof.” ");
INSERT INTO leu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Layaan a mu paamua priis e mu Ferasi ri langai a ferawaian paap si Yesus ri texaas o i taxa ferawai pari. ");
INSERT INTO leu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","E voxo ri vubuk rao ri taa pise taasaxa ri mataut sena malila aava ri lamon o na Yesus a mataa ina kuus fatuxai. ");
INSERT INTO leu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","E na Yesus a ferawai paap fulaa xe siri e a kuus, ");
INSERT INTO leu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“A fatataganan sina Piran a malaanabeꞌ: A toxan a paamua king aava faigot pana fenamo ina tamaian sina lak tomexaan sina. E nane fin a saxano rabuna o la yaan fatak ri taa filimaan xe lana. ");
INSERT INTO leu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Layaan a maana mo fo faigotanan nane feng a mu sisiak sina xena xuus a mu rabuna aave pana yaan fatak naboxo, taasaxa ri bai filimaan. ");
INSERT INTO leu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“E nane feng a xasano sisiak sina pana lagasai aanabeꞌ xe siri naang, ‘A fenamo a tamasiak xo; maam fo punuk a mu bulmakau e mu natuna bulmakau aava ri palak faroxo. A maana mo ina fenamo taxa waan naboxo. Filimaan xe lana fenamo ina tamaian!’ ");
INSERT INTO leu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Taasaxa nari aave ri lamon fepalauane e saxanofuna ri falet xe la lifu ina faisok siri e saxanofuna ri falet xe la uma lava siri. ");
INSERT INTO leu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","E xasanofuna ri yot a mu sisiak aave e sip faagutan nari e punuk nari. ");
INSERT INTO leu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A paamua king a marala faagut e voxo feng a mu rabuna ina rawen sina xena kawaasan a mu rabuna ina ngaapunuk e faram a bina siri. ");
INSERT INTO leu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“E mui a xel faxuvul a mu sisiak sina e kuus xe siri, ‘A maana mo fo faigotanan naboxo, taasaxa nari aava ne fo fin nari pana filimaan xe lana, ri pife roxo xena filimaan. ");
INSERT INTO leu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Lavaxa, naboxo falet xe la mu salan lava lana bina e fin naseꞌ ta rabuna mi tingin nari xena laak lana fenamo siak.’ ");
INSERT INTO leu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","E voxo a mu sisiak aave ri falet xe la bina e faxuvul a mu rabuna xapiak aava ri tingin nari xena laak la fenamo, nari aava ri roxo e nari aava ri saat. E a lifu ina fenamo a bas pana rabuna. ");
INSERT INTO leu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Taasaxa layaan a paamua king a falet xena xalum a mu rabuna aava ri fo filimaan, a xalum a saxa aava pife mawas pana marapi roxo. ");
INSERT INTO leu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","E a kuus xe sina, ‘Fesing, no pife mawas pana marapi roxo xena fenamo ina tamaian, xenaso no taxa waan iau?’ Taasaxa mataa aave a nai kasam senaso piau ta fufuna. ");
INSERT INTO leu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“E a paamua king a xuus a mu rabuna ina sisiak la fenamo, ‘Pis a mana e kana e tapine xe lamalei la suk.’ Pave a mu rabuna ri taa taangiis faagut e faxakengat a fari.” ");
INSERT INTO leu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","E na Yesus a fataxapin a ferawaian sina malaan, “A Piran a fin a mu rabuna xaves o ri taa filimaan xe sina taasaxa siak fati a nutuvaat mon.” ");
INSERT INTO leu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","A mu Ferasi xo ri fexuus kasam pana malaafaa ri taa fulung na Yesus pana fiaian siri. ");
INSERT INTO leu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","E ri feng a saxano fefeng siri xuvul pana saxano rabuna aava ri xali nari pana mu rabuna si Herot, xe si Yesus. A rabuna si Herot ri vubuk rao a mu Rom ri taa paamuian nari. E ri favupuule, “Mataa ina Fepitaa, maam texaas o nano, no ferawai tuuna. No fepitaa pana tuunayan ina salan sina Piran. E no pife lamon faaxaves pana lamonan sina xasanofuna senaso no lamon fepalauan a lavayan sina mataa. ");
INSERT INTO leu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","E voxo, xuus nemaam pana lamonan siim. A vuputkai sitaara a turoxo o taara taa maraan a taakis aava paamua lava ti Rom a ferawai pana o piau?” ");
INSERT INTO leu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Na Yesus fo texaas sena lamonan saat siri e a kuus, “Nami mu xalema maranga! Xenaso mi rao mi fulungau? ");
INSERT INTO leu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Faxalitau pana faat aava mi maraan a taakis aave pana.” E ri lisan a faat aave xe sina. ");
INSERT INTO leu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","E nane fin nari, “A vaveseꞌ e a isiseꞌ taxa waan xuluna faat aanabeꞌ?” ");
INSERT INTO leu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","E ri suie, “A paamua lava ti Rom.” E na Yesus a kuus xe siri, “Lavaxa, tavai a paamua lava ti Rom pana maana mo sina e tavai a Piran xo pana maana mo sina.” ");
INSERT INTO leu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Layaan ri langai a mo aanabeꞌ ri ipul faagut e ri taꞌulane e ri falet fepatok. ");
INSERT INTO leu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","La yaan naang, saxano Sedusi aava ri pife namkai o a rabuna ri taa to faꞌulaa ti la maatan, ri filimaan xe si Yesus e ri kuus, ");
INSERT INTO leu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Mataa ina Fepitaa, na Moses a kuus, ‘Tamo a mataa a maat e piau ta rafulak, na tina i taa tamai sina tefin nakmaal aave xena fasavat a rafulak xa tina aava fo maat.’ ");
INSERT INTO leu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","A toxan a mu fetinan pisiguak ri waan la palou imaam. A lak tuaan fo tamai e maat e piau ta lak e voxo na tina a tamai sina tefin nakmaal aave. ");
INSERT INTO leu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A savat malaan se tina mui e mui lamina fefexaxaas a fataxapiak. Nari xapiak ri fo maat. ");
INSERT INTO leu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","E lumui lamiri a tefin vaxa a maat. ");
INSERT INTO leu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Lana yaan ina to faꞌulaian a tefin aave i taa tefin siseꞌ? Nari pisiguak ri fo tamai sina.” ");
INSERT INTO leu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Taasaxa na Yesus a sui nari, “Nami, mi fo milung faagut sena to faꞌulaian ti la maatan! Mi pife texaas faroxo sena Xakalayan Taap o sena gutan sina Piran. ");
INSERT INTO leu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Layaan a mu mamaat ri taa to faꞌulaa, a mu rabuna, a lutefin e mu tomexaan xapiak, ri taa taagul malaan sena mu angelo la xunavata; ri taa pife tamai. ");
INSERT INTO leu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","E tamo nami, mi lamon maranga sena rabuna ri taa to faꞌulaa ti la maatan naak mi pi xakaat sena so ta mo a Piran a kuus pana lana Xakalayan Taap sina. Nane kuus, ");
INSERT INTO leu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nenia ve a Piran aava na bumi, na Abrahem, Aisaak e na Yaakop, rutul lotu xe sina.’ Nane ve a Piran sina mu rabuna aava ri taxa to, pife siri aava ri maat.” ");
INSERT INTO leu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","E layaan a malila ri langaie ri ipul faagut sena fepitaian sina. ");
INSERT INTO leu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Layaan a mu Ferasi ri langai o na Yesus fo fakasam a mu Sedusi ri falet xe sina ");
INSERT INTO leu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","e saxa mataa ina fepitaa pana vuputkai siri a tafange pana fiaian ");
INSERT INTO leu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","malaan, “Mataa ina Fepitaa, a so ta fefasaian lana vuputkai a pelalava?” ");
INSERT INTO leu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","E na Yesus a suie, “Mi taa vubuxan xasingit a Memai aava Piran simi pana xunus imi, pana lamonan xapiak simi e pana vubuxanan xapiak simi.’ ");
INSERT INTO leu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","A fefasaian aanabeꞌ a pelalava. ");
INSERT INTO leu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","E a saxa lamina a malaanabeꞌ: ‘Mi taa vubuxan xasingit a xasanofuna malaan seꞌ mi vubuxan xasingit nami xa.’ ");
INSERT INTO leu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","A ro vuputkai aanabeꞌ re fufuna maana mu vuputkai si Moses e a mu fepitaian sina mu rabuna ina kuus fatuxai.” ");
INSERT INTO leu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Layaan a mu Ferasi ri taxa waan faxuvul lunai, na Yesus a fin nari, ");
INSERT INTO leu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mi lamon malaafaa sena Mataa Failai? Na Natuseꞌ?” E ri xuuse, “Na Natu Devit.” ");
INSERT INTO leu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","E nane xuus nari, “Senasou na Devit, layaan a Vovau sina Piran a fagute, a xalie pana “Memai” e kuus malaan: ");
INSERT INTO leu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“A Memai a kuus xe sina Memai siak, nai suꞌ la pamuaan siak fefexaxaas a yaan ne timin a mu xaiyaas siim lapaana kaam.” ");
INSERT INTO leu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Tamo na Devit a xalie pana “Memai” malaafaa ve nane na natu Devit?” ");
INSERT INTO leu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pi ta saxa a fexaxaas sena sui na Yesus e ti lana yaan aave pi ta saxa a lamon o i taa fine panꞌ ta fiaian fulaa. ");
INSERT INTO leu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","E mui na Yesus a ferawai xe sina malila e mu fefeng sina ");
INSERT INTO leu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","e nane kuus, “A mu rabuna ina fepitaa pana vuputkai e mu Ferasi ri taxa nai la vepen si Moses e ri toxan a tateaxan xena kuusan famatavasaana vuputkai xe sina rabuna. ");
INSERT INTO leu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","E mi taa langai faagut sena fepitaian siri e usi fataxe; taasaxa muta usi a vilaana siri senaso ri pife vil a so ta mo ri fepitaa pana. ");
INSERT INTO leu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Layaan ri xuus nami pana maana mo xaves o mi taa vile xena usiaana vuputkai, ri taxa tavai nami pana matafanan molava aava lagaf xena vile. Taasaxa nari, ri pife talangaian a mari xena xakaavang. ");
INSERT INTO leu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“A maana mo aava ri vile, ri fuuna lo vile xena faxalit a mu rabuna pana vubuxan xasingitaana Piran siri; ri falak a mo la puturi e la mari malaan sena maaxui pana mu vapaling sina Piran lana e a mu sisingim la itina marapi ina vupungan siri, xalum a lavayan e modusan siri. ");
INSERT INTO leu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ri vubuxan a nobina lava lana fenamo e lana lifu ina faxuvulan talo mu rabuna xapiak ri taa xalum nari. ");
INSERT INTO leu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","E ri vubuk o a mu rabuna ri taa suai faagut seri pe la bina ina faasot e ri taa xali nari pana ‘Mataa ina Fepitaa.’ ");
INSERT INTO leu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Taasaxa muta turoxoian a rabuna xena xali nami pana ‘Paamua’ senaso nami ve mi mu fetinan e mi toxan a Paamua saxa mon. ");
INSERT INTO leu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","E muta xali ta saxa nabeꞌ la xavala pana ‘Tamaang.’ Mi toxan na Tamami saxa mon e nane taxa waan la xunavata. ");
INSERT INTO leu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","E muta turoxoian a rabuna xena xali nami pana ‘Mataa ina Fepitaa.’ Mi toxan a Mataa ina Fepitaa saxa mon e nane ve na Krais. ");
INSERT INTO leu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nane aava pelalava la palou imi, i taa sisiak xe simi xapiak. ");
INSERT INTO leu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tamo saxa la palou imi i taa lamon falavai nane xa, a Piran i taa fasivie e naseꞌ ta mataa i taa lamon fasivi nane xa, a Piran i taa fatiginei fataxe. ");
INSERT INTO leu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Nami mu rabuna ina fepitaa pana vuputkai e nami mu Ferasi, mi mu xalema maranga! Faxatang! A waanan simi i taa pife falet faroxo senaso mi xao a matana lifu xe lana Fatataganan sina Piran talo xasanofuna aava ri buk laak xe lana, ri pife fexaxaas e nami xa mi pife laak lana vaxa. ");
INSERT INTO leu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nami mu rabuna ina fepitaa pana vuputkai e nami mu Ferasi, mi mu xalema maranga! Faxatang! A waanan simi i taa pife falet faroxo senaso mi bit a lutefin nakmaal xena siak palou a lifu siri e mui mi ti fenung pana fenungan modus talo a rabuna ri taa xalum nami. Sena vilaana aanabeꞌ a fakasanamaan nami i taa molava. ");
INSERT INTO leu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Nami, mu rabuna ina fepitaa pana vuputkai e nami mu Ferasi, mi mu xalema maranga! Faxatang! A waanan simi i taa pife falet faroxo senaso mi falet lasuun la laman e xe la bina lasuun xena yuuf a mataa xe lana namkaian simi mu Juda. E layaan nane namkai sena vilaana simi i taa siak a fakasanaman fataragua semi. ");
INSERT INTO leu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Nami mu paamua aava mi piif, faxatang, a waanan simi i taa pife falet faroxo senaso mi fepitaa malaan, ‘Tamo saxa i taa kuus fakalimaan pana lifu lotu nane fexaxaas sena sinufan a kuus fakalimaanan aave. Taasaxa tamo i taa kuus fakalimaan pana ‘gol’ aava waan la lifu lotu, lavaxa i taa pife sinufane.’ ");
INSERT INTO leu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nami mu lamavaang aava mi piif! A so ta mo a molava, a ‘gol’ o a lifu lotu aava timin patak a ‘gol’ xena mo taap sina Piran? ");
INSERT INTO leu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","E mi fuuna fepitaa malaan, ‘Tamo saxa i taa kuus fakalimaan pana ivin ina faraaman nane fexaxaas sena sinufan a kuus fakalimaanan aave. Taasaxa tamo i taa kuus fakalimaan pana tatavai xuluna ivin aave i taa pife sinufane.’ ");
INSERT INTO leu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nami, mu mataa aava mi piif! A so ta mo a molava, a tatavai o a ivin aava timin patak a tatavai xena mo taap sina Piran? ");
INSERT INTO leu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nane aava kuus fakalimaan pana ivin ina faraaman, a kuus fakalimaan pana ivin aave xuvul pana maana mo aava waan xuluna ");
INSERT INTO leu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","e layaan a kuus fakalimaan pana lifu lotu, i taxa kuus fakalimaan pana lifu lotu aave e vaxa pana Piran aava taagul lana. ");
INSERT INTO leu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","E nane aava kuus fakalimaan pana xunavata, a kuus fakalimaan pana naian lava sina Piran e pana Saxa aava nai xuluna. ");
INSERT INTO leu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Nami, mu rabuna ina fepitaa pana vuputkai e nami mu Ferasi, mi mu xalema maranga! Faxatang! A waanan simi i taa pife falet faroxo senaso mi tatavai xe sina Piran pana saxa xavil la palou ina sangafilu ina maana paxana kaliu, o muli o xalana lobo aava mi faxuvule ti lana uma simi. Taasaxa mi langai pesalai sena maana fepitaian lava lana vuputkai aava malaan: mi taa bilai faroxo xe sina xasanofuna, mi taa tiis faroxoi a rabuna e mi taa muluk nari e mi taa waan fatateak lapaana Piran. A mo roxo tamo mi kanisai pana maana mo aapave e pife milung pana maana mo aanabeꞌ vaxa. ");
INSERT INTO leu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nami mu paamua aava mi piif! Mi timin votan a mo modak malaan sena tibaan ti lana mo mi nume taasaxa mi xanam xapin a ‘kaamel’ aava saxa tiir lava, malaan seꞌ mi pife xalume. ");
INSERT INTO leu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Nami, mu rabuna ina fepitaa pana vuputkai e nami mu Ferasi, mi mu xalema maranga! Faxatang! A waanan simi i taa pife falet faroxo senaso mi xamak a tana mu lisa e ‘plet’ taasaxa a lana a bas pana fanganan e maana mo aava mi siaxe pana vilaana ina naixaam e fenau. ");
INSERT INTO leu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nami mu Ferasi, matami piif! Paamua, xamak a lana mo talo i taa fatak e piau ta lalosaat e mui a tana i taa roxo sait. ");
INSERT INTO leu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Nami mu rabuna ina fepitaa e nami mu Ferasi, mi mu xalema maranga! Faxatang! A waanan simi i taa pife falet faroxo senaso mi malaan sena nobina ina mamaat aava ri vule pana raarum e laas e a kaalum famangaal faroxo taasaxa lana a bas pana mu tun e mu vipin aava ri fo miit. ");
INSERT INTO leu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","E nami, mi malaan sena nobina ina mamaat aanabeꞌ: layaan a rabuna ri xalum nami, ri lamon o a vilaana simi a fatak. Taasaxa lana lamonan e xunus imi, mi xalema maranga e mi bas pana vilaana saat. ");
INSERT INTO leu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Nami mu rabuna ina fepitaa pana vuputkai e nami mu Ferasi, mi mu xalema maranga! Faxatang! A waanan simi i taa pife falet faroxo senaso mi vesan a nobina ina mamaat roxo xana mu rabuna ina kuus fatuxai e xasanofuna aava ri sisiak xe sina Piran e mi fuuna lo famaus a maana nobina aave, ");
INSERT INTO leu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","e mi kuus, ‘Tamo maam tafo waan lana yaan sina mu bumaam, maam taa pife punuk a mu rabuna ina kuus fatuxai malaan seri.’ ");
INSERT INTO leu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sena ferawaian aanabeꞌ mi ferawai xavang nami xa o mi malaan sena mu bumi aava ri punuk a mu rabuna ina kuus fatuxai! ");
INSERT INTO leu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Lavaxa, vil roxol a faisok aava mu bumi ri fo tangpate! ");
INSERT INTO leu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Nami, mi malaan sena tiui pana neng tateak! A Piran i taa fakalimaan nami xena waan la bina ‘Hel’. Muta lamon o mi taa sinufane. ");
INSERT INTO leu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Langaiau! Ne taa feng a mu rabuna ina kuus fatuxai, a rabuna pana texaasan e a rabuna ina fepitaa pana vilaana sina Piran xe simi e saxanofuna mi taa punuk nari, saxanofuna mi taa niil fataxutan nari laaꞌui xuluna bolo, saxanofuna mi taa inis nari pana yeis lana lifu ina faxuvulan simi e taa seng xolan nari la maana mu bina xena vil pengan nari. ");
INSERT INTO leu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ne taa feng nari malaanabeꞌ talo a fakasanaman sena punuxaana mu rabuna fatak i taa waan xulumi: ti la yaan ina punuxaan na Ebal aava mataa fatak, fefexaxaas a yaan ina punuxaan na Sekaraia na natu Barakaia. Mi punuk na Sekaraia la palou ina tang lifu lotu e a ivin ina faraaman sina Piran. ");
INSERT INTO leu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ne kuus tuuna xe simi, a fakasanaman aanabeꞌ i taa savat xe sina mu rabuna ti tanin. ");
INSERT INTO leu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Nami mu Jerusalem, nami mu Jerusalem! Mi punuk a mu rabuna ina kuus fatuxai e mi soxoi famaat a mu fefeng sina Piran pana faat! A maana yaan xaves ne vubuk fakaliuan nami pana maak malaan sena pura tefin a faxuvul a mu rafulak sina lapaana ro xakavena taasaxa mi pife turoxoianau xena vile. ");
INSERT INTO leu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kaalum, a Piran a taꞌulan a tang lifu lotu simi e i taxa gof. ");
INSERT INTO leu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","E voxo ne xuus nami o mi taa pife xalum fulanau fefexaxaas a yaan mi kuus, ‘A Piran i taa tavai a mataa aava savat lapaana tateaxan ina Memai pana roxoyan.” ");
INSERT INTO leu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Layaan na Yesus i taxa taꞌulan a lifu lotu, a mu fefeng sina ri maa savat sina e ri talangai xe la maana nobina ina tang lifu lotu aave xena yuuf a lamonan sina. ");
INSERT INTO leu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","E nane xuus nari, “Aang, xalum a maana mo aanabeꞌ. Taasaxa ne xuus tuunei nami: piau ta faat saxa i taa waan la nobina ina. Senaso a yaan i taa savat layaan a mu xaiyaas simi ri taa galas tapin a maana faat xapiak.” ");
INSERT INTO leu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Layaan na Yesus taxa nai xulu Put Olif, a mu fefeng sina sang mon ri savat sina e ri kuus, “Xuus nemaam laso ta yaan a maana mo aanabeꞌ ri taa savat e a so ta mo i taa fakalimaan a yaan ina filimaanan siim e a fataxapiak ina yaan.” ");
INSERT INTO leu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Na Yesus a sui nari, “Faxatang, talo pi ta mataa i taa bit nami. ");
INSERT INTO leu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","A maana rabuna xaves ri taa savat lapaana isaak e ri taa kuus, ‘Nenia ve ne Mataa Failai’ e ri taa bit a maana rabuna. ");
INSERT INTO leu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mi taa langai a felingaian ina fevisan aava waan faasilak e mi taa langai pana maana fevisan ri waan lasuun, taasaxa muta mataut. A maana mo malaanabeꞌ ri taa savat taasaxa ri pife faxaalit o a fataxapiak ina yaan fo savat. ");
INSERT INTO leu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","A maana mu bina ri taa fevis; a mu fatataganan ri taa fefalouan nari xa. E i taa toxan a yaan ina song e a maana maraꞌulia la maana mu bina. ");
INSERT INTO leu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","A maana mo aanabeꞌ ri malaan sena maasaxan sina tefin paamuina luluxan. ");
INSERT INTO leu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Lamina yaan a maana mo aanabeꞌ fo savat, a mu rabuna pana tateaxan ri taa pis nami e a mu xaiyaas simi ri taa vil pengan nami e punuk nami. A mu rabuna xapiak ri taa baian nami senaso mi waan xuvul paga. ");
INSERT INTO leu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A maana rabuna xaves ri taa taꞌulan a namkaian siri lana yaan aave; ri taa pet lisan nari xa e febaian nari. ");
INSERT INTO leu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","E a mu rabuna xaves ina kuus fatuxai bit, ri taa savat xena bit a maana rabuna. ");
INSERT INTO leu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","E senaso a saatan sina rabuna tafe molava, a maana rabuna xaves ri taa pife vubuxan xasingitan nari xa. ");
INSERT INTO leu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Taasaxa nane aava tigina fatateak fefexaxaas a fataxapiak i taa fakaxupan. ");
INSERT INTO leu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A mu rabuna ri taa falet xolai la maana mu bina la xavala e ri taa kuusan fasavat a Lagasai Roxo sena fatataganan sina Piran. E muibak a fataxapiak ina yaan i taa savat. ");
INSERT INTO leu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mi taa xalum a mo mosaat paaliu aava mataa ina kuus fatuxai, na Daniel, a kuus pana. A mo aave i taa nai falalosaat a Nobina Taap Xasingit sina Piran. (Nami aava mi kat a mo aanabeꞌ mi taa masam sena.) ");
INSERT INTO leu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Lana yaan aave nami aava mi waan pe Judia mi taa sinuf falet xe xulu put. ");
INSERT INTO leu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","E nane aava waan laaꞌui la putuna lifu i taa pife sivi xe lana lifu xena siak a maana mo sina. ");
INSERT INTO leu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","E nane aava i taxa faisok la uma sina i taa pife ulaa xena siak a marapi ina vupungan sina. ");
INSERT INTO leu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","E lana yaan aave muluk a lutefin pana lak la xuri o mu ninana lak ri taxa fasus a lak siri! ");
INSERT INTO leu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Fenung xe sina Piran o a yaan aave i taa pife savat la yaan ina Maat Bung o la Yaan ina Fangaafusan! ");
INSERT INTO leu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Senaso a mu lagafan aava ri taa savat lana yaan aave, ri taa pemamosaat senꞌ ta lagafan ti paamua; ti la tangpat ina xavala fefexaxaas tanin. E pi ta mo malaan sena i taa savat fulaa. ");
INSERT INTO leu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Taasaxa, a Piran xo fo faxaxaalif a yaan ina mu lagafan aanabeꞌ. Tamo nane pife vil malaane pi ta rabuna ri fexaxaas sena sinufane. Taasaxa Piran a muluk a mu rabuna tatagan sina e voxo nane faxaxaalif a mu yaan aave. ");
INSERT INTO leu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“E tamo ta mataa taa xuus nami, ‘Kaalum, a Mataa Failai ve!’ o ‘Nane waan pave!’ muta namkai sena ferawaian siri. ");
INSERT INTO leu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Senaso maana mataa failai bit e maana rabuna ina kuus fatuxai bit ri taa savat. Ri taa vil a maana mo faꞌipul molava e maana faisok ina gutan xena yuuf familung a mu rabuna tatagan sina Piran tamo a fexaxaas. ");
INSERT INTO leu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Langai! Ne fo xuus nami pana maana mo aanabeꞌ paamuina savatan siri. ");
INSERT INTO leu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“E voxo tamo a rabuna ri taa xuus nami, ‘Kaalum, nane waan pe la bina xobingil!’ — muta falet xe pave. O tamo ri kuus, ‘Kaalum, i taxa fufunai nabeꞌ!’ — muta namkai sena. ");
INSERT INTO leu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Layaan a Natuna Mataa i taa savat i taa malaan sena yaamit; i taa savat faꞌipul e taa fabas a tavegof pana malang talo a mu rabuna xapiak ri taa xalume. ");
INSERT INTO leu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Mi taa tingin a mamaat layaan mi xalum a maana kor ri taxa faxuvul. ");
INSERT INTO leu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Faasilak, lamina yaan ina mu lagafan aave, a ngaas i tafe suk; a fulun i taa pife rarapak fulaa; a mu vapara ri taa poxo ti la finavata; e a Piran i taa faradakui a maana mo la finavata. ");
INSERT INTO leu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“E mui a fakalimaanan ina Natuna Mataa i taa savat la finavata e mu rabuna xapiak la xavala ri taa taangiis faagut pana matautan layaan ri xalum a Natuna Mataa i taxa filimaan xuluna mu vata la tavegof. E lana filimaanan sina, mu rabuna ri taa xalum a gutan sina e a miridingan aava Piran a tavaie pana. ");
INSERT INTO leu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","E layaan a angelo a piif faagutan a tang tafiu, a Natuna Mataa i taa feng a mu angelo sina xe la maana mu bina xapiak la xavala xena faxuvul a mu rabuna tatagan sina. ");
INSERT INTO leu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“A wai xakaap i taa fapiti nami malaan: Layaan mi xalum a raxana xakaap ri fungus e a paxari faꞌui ri savat, mi texaas o a yaan ina matoxolan a waan faasilak. ");
INSERT INTO leu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","E malaanabeꞌ layaan mi xalum a maana fakalimaanan aanabeꞌ mi taa texaas o a yaan ina savatan sina a faasilak paaliu. ");
INSERT INTO leu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Lamon faꞌulaa! A maana mo aanabeꞌ ri taa savat paamuina yaan a mu rabuna xapiak ti tanin, ri taa maat. ");
INSERT INTO leu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","A xunavata e xavala ri taa taxapus taasaxa a ferawaian siak i taa pife taxapus. ");
INSERT INTO leu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Taasaxa pi ta saxa i taa texaas sena yaan ina filimaanan sina Natuna Mataa; pife mu angelo la xunavata o na Natuna. A Piran, na Tamataara, nane sang mon a texaas sena. ");
INSERT INTO leu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Layaan a Natuna Mataa i taa filimaan, a yaan aave i taa malaan sena yaan si Noyeꞌ. ");
INSERT INTO leu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Lana yaan aave, paamuina ulim molava piis, a mu rabuna ri taxa fangan e num e ri taxa fetamaian xolanari. A falet malaan fefexaxaas a yaan na Noyeꞌ a laak lana xaati. ");
INSERT INTO leu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","A mu rabuna ti la yaan aave ri pife texaas sena so ta mo i taa savat fefexaxaas a yaan a ulim a filimaan e a vak xapin nari xapiak. I taa malaan layaan a Natuna Mataa i taa filimaan. ");
INSERT INTO leu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Lana yaan aave tamo a rovaat tomexaan re taxa faisok la uma, a Natuna Mataa i taa siak a saxa xe sina e saxa i taa waan pave. ");
INSERT INTO leu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","E tamo a rovaat tefin re taxa faisok faxuvul pana mimit a mu kam ina ‘wiit’ sire, i taa siak a saxa xe sina e saxa i taa waan pave. ");
INSERT INTO leu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Kaalum votai! Senaso mi pife texaas sena so ta yaan a Memai simi i taa filimaan. ");
INSERT INTO leu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tamo a mataa tafuna lifu fo texaas sena yaan a mataa ina fenau i taa filimaan i tafo kaalum votai e ti votan a mataa ina fenau sena laak la lifu sina. ");
INSERT INTO leu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","E voxo nami vaxa mi taa tamasiak vulai e faxatang senaso a Natuna Mataa i taa savat layaan mi pife faigot! ");
INSERT INTO leu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Lavaxa, mi taa malaan sena sisiak pana texaasan aava fuuna langai faroxo sina paamua sina. Nane aave a paamua sina a siak fatie xena paamuianaana xasano sisiak e tavai nari pana fanganan siri lana yaan fatak. ");
INSERT INTO leu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","E tamo a paamua sina, lana filimaanan sina, a xalume o i taxa vil faroxoi a faisok sina, a sisiak aave i taa faamamaas. ");
INSERT INTO leu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ne xuus tuunei nami o a paamua sina i taa fakalimaane pana mataa ina faxatangaana maana mo xapiak sina. ");
INSERT INTO leu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Taasaxa tamo nane ve a sisiak saat i tamaa ilisai, ‘Naak saxa mo taxa tivotan a paamua siak e i taa pife ulaamaan fataapus.’ ");
INSERT INTO leu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","E voxo a sip pengan a xasano sisiak e fangan e num xuvul pana rabuna aava ri nunum temasaat. ");
INSERT INTO leu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Taasaxa, saxa yaan, layaan a sisiak aave a pife lalamon pana, a paamua sina i taa ulaamaan. ");
INSERT INTO leu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","E i taa fakasanam faagutan a sisiak aave e taa tavaie pana nobina sina la palou ina mu xalema maranga. Pave a mu rabuna ri taa taangiis faagut e faxakengatan a fari.” ");
INSERT INTO leu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","E na Yesus a kuus fulaa laa, “Ne fo xuus nami pana maana mo aanabeꞌ e layaan ri savat, a fatataganan sina Piran i taa malaanabeꞌ. Saxa yaan a toxan a lutefin palau sangafilu aava ri siak a laam siri e ri fe bang xena fasusui a mataa aava xena tamai. ");
INSERT INTO leu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","A lutefin pama ri tefin lamavaang e pama ri tefin pana lamonan. ");
INSERT INTO leu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Senaso layaan a lutefin lamavaang ri siak a laam siri ri pife siak a saxano wel fulaa xuvul pari. ");
INSERT INTO leu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Taasaxa lutefin pana lamonan ri siak a laam siri e ri lisan xuvul a paxiis aava bas pana xasano wel. ");
INSERT INTO leu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","A mataa aava xena tamai, pife filimaan fataapus e voxo lutefin xo ri maare e ri matef. ");
INSERT INTO leu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Taasaxa la xunavung, saxa a xukulai, ‘A mataa aava xena tamai i taxa filimaan naboxo! Man, taara fe fasusuie!’ ");
INSERT INTO leu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“A lutefin sangafilu ri para xena faigotan a mu laam siri. ");
INSERT INTO leu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","E a lutefin lamavaang ri nung nari pana lamonan, ‘Filung a laam simaam pana wel senaso mu laam simaam faasilak rao ri maat.’ ");
INSERT INTO leu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Taasaxa lutefin pana lamonan ri sui nari, ‘Piau paaliu! Maam piau ta wel fexaxaas setaara xapiak, falet xe la lifu ina faasot pana wel e maraan ta xami.’ ");
INSERT INTO leu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“E voxo a lutefin lamavaang ri falet xena maraan a saxano wel e layaan ri taxa malit lunai a mataa aava xena tamai a savat. A lutefin pama aava ri fasusuie, ri laak lana maraanaana tefin xuvul pana e a mu sisiak ri xawei a matana lifu. ");
INSERT INTO leu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“E mui a lutefin lamavaang ri maa savat vaxa e ri kuus, ‘Matalava, Matalava, kas a matana lifu xe simaam!’ ");
INSERT INTO leu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","A mataa aava xena tamai a sui nari, ‘Piau paaliu! Ne pife texaas semi.” ");
INSERT INTO leu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","E na Yesus a fataxapin a ferawaian sina malaan, “Faxatang senaso mi pife texaas sena yaan o xavil ina yaan layaan a Natuna Mataa i taa filimaan.” ");
INSERT INTO leu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“E fulaa, lana yaan aave a fatataganan sina Piran i taa malaanabeꞌ: A toxan a mataa aava rao i taa taꞌulan a lifu sina xena falet xe lasuun; nane xel faxuvul a mu sisiak sina e lisan tuunei a maana mo sina xe siri xena faxatangaana. ");
INSERT INTO leu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nane lisan a faat xe siri fexaxaas sena vilaana siri; xe sina saxa a lisan a faat 5,000 e xe sina saxa a lisan faat 2,000 e xe sina saxa fulaa a faat 1,000. E mui a falet xe lasuun. ");
INSERT INTO leu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nane pana faat 5,000, a faisok pana mu faat aave e fasavat a xasa 5,000. ");
INSERT INTO leu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","E pana vilaana malaan a sisiak pana faat 2,000 fe faisok pana mu faat aave e fasavat a xasa 2,000. ");
INSERT INTO leu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Taasaxa sisiak pana faat 1,000 fe xaf a vaaꞌul e fun a faat sina paamua sina. ");
INSERT INTO leu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Lamina maana yaan xaves fo falet xo, a paamua sirutul a ulaamaan e fin narutul pana so ta mo rutul fo vile pana mu faat aave. ");
INSERT INTO leu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","A saxa pana faat 5,000 maa tavaie pana xasa faat 5,000 e xuuse, ‘No tavaiau pana faat 5,000, Matalava, e naboxo ne fo fasavat a xasa 5,000. Kaalum! A faat xapiak siim nabeꞌ.’ ");
INSERT INTO leu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“E a paamua sina a xuuse, ‘A faisok roxo paaliu! Nano ve no sisiak roxo aava langai faroxo vulai. No fo faxatang faroxoi a maana mo modak nabeꞌ e voxo ne taa lisan tuunei a maana mo xaves xe siim xena faxatangaana. Laakmaan xe lana fenamo siak e faamamaas.’ ");
INSERT INTO leu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“E mui a sisiak pana faat 2,000 a laakmaan e xuuse, ‘No tavaiau pana faat 2,000, Matalava, e naboxo ne fo fasavat a xasa 2,000. Kaalum! A faat xapiak siim nabeꞌ.’ ");
INSERT INTO leu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“E a paamua sina a kuus, ‘A faisok roxo paaliu! Nano ve no sisiak roxo aava langai faroxo vulai. No fo faxatang faroxoi a maana mo modak e voxo ne taa lisan tuunei a maana mo xaves xe siim xena faxatangaana. Laakmaan xe lana fenamo siak e faamamaas.’ ");
INSERT INTO leu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“E mui a sisiak pana faat 1,000 a laakmaan e xuuse, ‘Matalava, ne texaas sena vilaana tateak siim; no siak a fanganan ti lana uma aava no pife xapise e no faxuvul a fanganan ti lana nobina aava no pife tapalan a kam lana. ");
INSERT INTO leu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","E voxo ne mataut sema e ne fe fun a faat siim lana vaaꞌul. A faat siim nabeꞌ ne taxa tawe.’ ");
INSERT INTO leu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“E a paamua a xuuse, ‘Nano ve no sisiak saat e no maragap. Nano, no texaas o ne siak a fanganan ti lana uma aava ne pife xapise, bo? E ne faxuvul a fanganan ti lana nobina aava ne pife tapalan a kam lana, bo? ");
INSERT INTO leu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Lavaxa, xenaso no pife fanei a faat siak lana lifu ina fawaanaana faat talo ne taa siak faꞌuli a faat siak xuvul pana saxano faat fulaa? ");
INSERT INTO leu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘Naboxo, siak a faat xasena e tavai a saxa aava toxan a faat 10,000 pana. ");
INSERT INTO leu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","A Piran i taa tavai nari aava ri toxan a mo pana xasano mo fulaa e voxo i taa toxan a maana mo a pesasoliu sena taasaxa xe sina saxa aava piau ta mo, a Piran i taa siak tapin a so ta mo modak aava nane toxane. ");
INSERT INTO leu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","E sena sisiak palau aanabeꞌ, tapine xe lamalei lana suk e pave i taa taangiis faagut e faxakengat a fana.’ ");
INSERT INTO leu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Layaan a Natuna Mataa a filimaan pana gutan e malang molava piis sina, xuvul pana mu angelo, i taa nai lana miridingan molava xuluna nai piranan sina. ");
INSERT INTO leu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","E a mu rabuna ti la mu bina xapiak ri taa faxuvul la nona. E nane xo i taa fepatoxan nari lana parabuna taragua malaan sena mataa ina faxatangaana mu sipsip a fepatoxan a mu sipsip xasena mu meme. ");
INSERT INTO leu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","I taa fawaan a mu rabuna fatak la nobina roxo la pamuaan e a xasanofuna la paxaiya. ");
INSERT INTO leu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“E mui a King aave i taa kuus xe siri mu rabuna la pamuaan sina, ‘Filimaan, nami aava na Tamaang a ferawai fararoxo semi. Filimaan, siak a maana roxoyan ina fatataganan sina aava nane faigotane xami paamuina yaan nane vesan a xavala. ");
INSERT INTO leu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Senaso nenia, ne lagai e mi tavaiau pana fanganan, ne maꞌiu e mi tavaiau pana raarum, ne saxa topen e mi kas a lifu simi xe siak, ");
INSERT INTO leu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ne piau ta marapi e mi tavaiau pana marapi, ne giis e mi maa faxatangau, ne mataa vipis e mi maa xalumau.’ ");
INSERT INTO leu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“E a mu rabuna fatak ri taa suie, ‘Memai, laso ta yaan maam xalum nano no lagai e maam fafangan nano o no maꞌiu e maam tavai nano pana raarum? ");
INSERT INTO leu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","E laso ta yaan maam xalum nano no topen e maam kas a lifu simaam xe siim o no piau ta marapi e maam tavai nano pana marapi? ");
INSERT INTO leu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","E laso ta yaan maam xalum nano, no giis o no waan la lifu ina vipisan e maam fexalum nano?’ ");
INSERT INTO leu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“E a king aave i taa sui nari, ‘Tuuna, ne xuus nami, layaan mi xavang a saxa tiak o vasaak naapalaan nane pife matalava, mi taxa xavangau vaxa!’ ");
INSERT INTO leu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“E mui i taa kuus xe siri la paxaiya, ‘Faapalau sega nami aava mi waan lapaana fatutulan sina Piran! Falet xe la bina ina fata i taxa raam vulai aava Piran a faigotane pa Setan e mu angelo sina! ");
INSERT INTO leu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Senaso nenia, ne lagai taasaxa mi pife tavaiau pana fanganan, ne maꞌiu e mi pife tavaiau pana raarum; ");
INSERT INTO leu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ne saxa topen e mi pife kas a lifu xe siak, ne piau ta marapi e mi pife tavaiau pana marapi, ne giis e ne waan la lifu ina vipisan taasaxa mi pife xalumau.’ ");
INSERT INTO leu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“E nari ri taa suie, ‘Memai, laso ta yaan maam xalum nano no lagai o maꞌiu, no saxa topen o piau ta marapi, no giis o no waan la lifu ina vipisan e maam pife xavang nano?’ ");
INSERT INTO leu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“E i taa sui nari, ‘Ne xuus tuunei nami, layaan mi bai xavang a saxa aava mataa palau mon, mi bai xavangau vaxa.’ ");
INSERT INTO leu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“E nari xo a Piran i taa feng tapin nari xe la bina ina fakasanaman aava piau ta taxapusan ina. Taasaxa mu rabuna fatak aava ri usi a vubuxanan sina Piran, ri taa siak a toyan vulai xe vulai.” ");
INSERT INTO leu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Layaan na Yesus fo fataxapin a maana fepitaian aanabeꞌ a kuus xe sina mu fefeng sina malaan, ");
INSERT INTO leu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Nami, mi texaas o lamina yaan taragua i taa yaan ina Fenamo ina Paaliuan. Lana yaan aave ri taa lisan a Natuna Mataa xe sina mu xaiyaas sina e ri taa fataxutane e i taa maat xuluna bolo.” ");
INSERT INTO leu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","E pe la lifu lava si Kaiafas aava memai sina mu priis, mu paamua priis e mu matalava ri faxuvul ");
INSERT INTO leu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","e ri taxa ferawai pana malaafaa ri taa yot fun na Yesus e punuxe. ");
INSERT INTO leu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Taasaxa ri kuus o ri taa pife vile lana yaan ina fenamo ulaa mu rabuna ri tamaa marala e fevis. ");
INSERT INTO leu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na Yesus fo falet xe la bina Betani e pave a waan la lifu sina saxa mataa aava tana tamu tapak, a isina, na Saimon. ");
INSERT INTO leu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Layaan na Yesus taxa fangan, saxa tefin maa savat sina pana fomirak paxiis ri vesane pana faat aava ri xalie pana ‘alabasta’. A paxiis modak aave a bas pana wel aava musung ina a roxo e a mamareiai ina a molava paaliu e a tefin aave a tiuane la putu Yesus layaan i taxa fangan. ");
INSERT INTO leu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Taasaxa layaan a mu fefeng sina ri xalume, ri marala e ri kuus, “Xenaso nane fataxapin palou a wel pave? ");
INSERT INTO leu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nane fexaxaas sena faasot pana xena siak a faat xaves talo i taa xavang a mu valagof!” ");
INSERT INTO leu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Taasaxa na Yesus a texaas sena ferawaian siri e kuus, “Senasou mi taxa ferawai falagaf a tefin aanabeꞌ? Nane fo vil a mo roxo paaliu xaanak. ");
INSERT INTO leu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","A mu valagof ri taa waan vulai xuvul pami, taasaxa nenia, ne taa pife waan vulai xuvul pami. ");
INSERT INTO leu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","A tefin aava tiuan a wel roxo la taak nane taxa faigotan a vipin siak xena xaafanaana. ");
INSERT INTO leu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","E naboxo, ne kuus tuuna xe simi, laso ta yaan a rabuna ri taa kuusan fasavat a Lagasai Roxo aanabeꞌ ri taa kuusan vaxa a faisok roxo sina tefin aanabeꞌ. E voxo a mu rabuna xapiak ri taa lamon faꞌulie.” ");
INSERT INTO leu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","E mui saxa la palou ina mu yaamut sangafilu saxa pana taragua, na Judas Iskeriot, a falet xe sina mu paamua priis ");
INSERT INTO leu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","e fin nari, “Tamo ne taa pet lisan na Yesus xe simi mi taa tavaiau pana so ta mo?” E ri kat a mu faat ‘silva’ sangafilu talatul e ri tavaie pana. ");
INSERT INTO leu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","E ti la yaan aave na Judas taxa lo seng a yaan roxo xena pet lisanaan na Yesus. ");
INSERT INTO leu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","La yaan mata ina Fenamo ina Bret Aava Piau Ta Yiis, a mu fefeng ri maa savat si Yesus e ri fine, “No vubuk o maam taa faigotan a fanganan xena Fenamo ina Paaliuan xanum faa?” ");
INSERT INTO leu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","E a kuus, “Falet xe sina saxa mataa pe la bina e xuuse, ‘A Mataa ina Fepitaa a kuus: A yaan fatak siak fo savat; nenia xuvul pana mu fefeng siak, maam taa nai pana Fenamo ina Paaliuan pe la lifu siim.” ");
INSERT INTO leu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","E mu fefeng ri usi fatak a ferawaian si Yesus e ri fe faigotan a fanganan xena Fenamo ina Paaliuan. ");
INSERT INTO leu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","A yaan xo fe leaaf e na Yesus xuvul pana mu yaamut sangafilu saxa pana taragua sina, ri nai xena fangan. ");
INSERT INTO leu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Layaan ri taxa fangan na Yesus a xuus nari, “Ne xuus nami, saxa la palou imi i taa pet lisanau.” ");
INSERT INTO leu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","E ri kanamsaat paaliu e ri fine, saxa lamina saxa, “Memai pife nenia, bo?” ");
INSERT INTO leu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na Yesus a sui nari, “Nane aava sugup a bret sina lana ‘plet’ xuvul paga, nane taa pet lisanau. ");
INSERT INTO leu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A Natuna Mataa i taa maat malaan sena Xakalayan Taap a ferawai pana, taasaxa i taa pife falet faroxo pana saxa aava pet lisan a Natuna Mataa! I taa mo roxo paaliu pana mataa aave tamo na ninana pife luxe!” ");
INSERT INTO leu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Na Judas aava mataa ina pet lisanaan na Yesus a kuus, “Memai, a tuuna no pife ferawai fatak sega, bo?” E na Yesus a suie, “Aang, nano mon.” ");
INSERT INTO leu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Layaan ri taxa fangan, na Yesus a siak a nebret e a kuus faasiroxo xe sina Piran pana e viaxe e tavai a mu fefeng sina pana e a kuus, “Siaxe e ngane, a vipin siak ve.” ");
INSERT INTO leu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","E nane siak a lisa pana raarum wain e kuus faasiroxo xe sina Piran pana e tavai nari pana e a kuus, “Num sena, nami saxa saxa ");
INSERT INTO leu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","senaso a raarum wain aanabeꞌ ve a ria iga aava tiuanan talo Piran i taa lamon tapin a mu vilaana saat sina mu rabuna xapiak. A ria aanabeꞌ a fakalimaan fatateak a turoxoian sina Piran. ");
INSERT INTO leu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ne xuus nami, ne taa pife num fulan a raarum wain fefexaxaas a yaan ne num a raarum wain faꞌui xuvul pami la fatataganan si Tamaang.” ");
INSERT INTO leu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","E mui ri yangan a saxa yanganan xena nangus a Piran e ri taꞌulan a nobina aave xena falet xe la Put Olif. ");
INSERT INTO leu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","E na Yesus a kuus xe siri, “La vung naang nami xapiak xo mi taa sinuf e taꞌulanau e voxo ne taa waan nenia sang mon senaso a Xakalayan Taap a kuus, ‘Nenia, ne taa punuk a mataa ina faxatangaana sipsip e nari mu sipsip ri taa falet fepatok’. ");
INSERT INTO leu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Taasaxa lamina yaan a Piran a fatatoi faꞌuliau ne taa falet paamuin nami xe pe Galili.” ");
INSERT INTO leu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na Pita a kuus faagut xe si Yesus, “Nenia, ne taa pife taꞌulan nano naapalaan a xasanofuna xapiak ri taa taꞌulan nano!” ");
INSERT INTO leu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","E na Yesus a xuus na Pita, “Ne kuus tuuna, la vung aanabeꞌ paamuina yaan a pura i taa rawei, nano, no taa kuus faatalatul o no pife texaas sega.” ");
INSERT INTO leu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","E na Pita a suie, “Ne taa pife kuus malaan naapalaan tamo ne taa maat xuvul pama.” E xasano fefeng vaxa ri kuus malaan. ");
INSERT INTO leu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Na Yesus xuvul pana mu fefeng sina ri falet xe la bina Getsemani e nane xuus nari, “Nai nabeꞌ e ne taa falet patak famodak xena fenung.” ");
INSERT INTO leu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nane xel faxuvul na Pita e a ro lak tomexaan si Sebedi e ri falet patak famodak e nane mimilisaat falet e maasak faagut lana xunus ina. ");
INSERT INTO leu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","E nane kuus xe siri, “A mimilisaatan la xunus iga a faasilak i taa punuxau. Waan nabeꞌ e mutul faalim xuvul paga.” ");
INSERT INTO leu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","E nane falet patak famodak fulaa e poxo xe lapia e fenung, “Tamaang, tamo no fexaxaas sena, ne vubuk rao no taa siak tapin a lisa ina maasaxan aanabeꞌ xasega. Taasaxa, a so ta mo i taa savat i taa usi a vubuxanan siim e pife vubuxanan siak.” ");
INSERT INTO leu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","E mui a ulaamaan xe sina fefeng talatul aave e tingin narutul taxa matef e a xuus na Pita, “Mutul pife fexaxaas sena faalim xuvul paga pana awa saxa, bo? ");
INSERT INTO leu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mutul taa faalim e fenung talo mutul taa pife poxo lana tatafangan. A vovau simi a roxo, mi buk vil a moroxo, taasaxa a vipin simi a malmal.” ");
INSERT INTO leu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","E fulaa na Yesus a falet patak e fenung, “Tamaang, tamo no taa pife siak tapin a lisa ina maasaxan aanabeꞌ fefexaxaas a yaan ne fo num lana lavaxa, a vubuxanan siim i taa savat.” ");
INSERT INTO leu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E a ulaamaan fulaa e tingin narutul taxa matef: rutul pife fexaxaas sena para senaso a matarutul a matafan. ");
INSERT INTO leu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","E fulaa laa na Yesus a taꞌulan narutul e falet patak xena fenung la fatalatulaana yaan e kuus pana mu vapaling naang. ");
INSERT INTO leu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","E mui nane ulaamaan xe sirutul e a kuus, “Mutul taxa matef e fangaafus lunai, bo? Kaalum! A yaan fatak naboxo, a Natuna Mataa i taa pet lisanan xe sina mu rabuna saat. ");
INSERT INTO leu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tamasiak, taara taa falet. Kaalum, nane aava xena pet lisanau naboxo, i taxa filimaan.” ");
INSERT INTO leu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Na Yesus taxa ferawai lunai layaan na Judas, a saxa ti la palou ina fefeng sangafilu saxa pana taragua, maa savat. E a malila aava ri toxan a mu pinis modus ina fevis e mu vam, ri savat xuvul pana senaso a mu paamua priis e mu matalava ri fo feng nari. ");
INSERT INTO leu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","A mataa ina pet lisan na Yesus fo xuus nari, “Nane aava ne taa nguse, nane a saxa aava mi vubuxane. Pise!” ");
INSERT INTO leu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Na Judas a falet fatak xe si Yesus e a kuus, “Lavung roxo, Mataa ina Fepitaa.” E nane nguse. ");
INSERT INTO leu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Na Yesus a suie, “Ka fesing, vil fatapusane!” E nari pana maana mo ina fevis, ri pise. ");
INSERT INTO leu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Saxa fefeng si Yesus a yuuf mulus a pinis modus ina fevisan sina e sip a yaasok sina memai priis e patal tapin a saxa patangana. ");
INSERT INTO leu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na Yesus a xuuse, “Timin faꞌuli a pinis siim la nobina ina. Naseꞌ ta mataa a fevis pana pinis modus i taa maat sena sait. ");
INSERT INTO leu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ne fexaxaas sena fin na Tamaang pana xakaavangan sina e fataapus paaliu i taa feng a mu pabung sangafilu saxa pana taragua ina angelo ina fevisan xe siak. ");
INSERT INTO leu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Taasaxa tamo ne taa vil malaane, a maana mo aava Xakalayan Taap a ferawai pana, ri taa savat la matavas malaafaa? ");
INSERT INTO leu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","E lana yaan aave na Yesus a ferawai xe sina malila, “Mi fo savat pana pinis modus ina fevis e mu vam xena pisau malaan seꞌ nenia, ne mataa saat, bo? A maana yaan xapiak ne nai fepitaa pe la tang lifu lotu e mi pife pisau pave. ");
INSERT INTO leu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Taasaxa, a maana mo aanabeꞌ fo savat talo a xakalayan sina mu rabuna ina kuus fatuxai i taa savat tuuna la matavas.” E mui a mu fefeng ri taꞌulane e ri sinufane. ");
INSERT INTO leu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","E nari aava ri pis na Yesus ri lisane xe la lifu si Kaiafas aava memai priis. Pave a mu rabuna ina fepitaa pana vuputkai e nari mu matalava ri fo faxuvul xo. ");
INSERT INTO leu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na Pita xo a usie ti lasuun fefexaxaas a yaan ri savat pe la lifu lava sina memai priis. Nane fe nai la nobina aave xuvul pana mu rabuna ina fevisan xena falim a so ta mo taa savat si Yesus. ");
INSERT INTO leu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","A mu paamua priis xuvul pana xasanofuna aava ri waan la Saniidrin, ri seng a rabuna xena kuus xakaavang bit tifi na Yesus talo ri fexaxaas sena punuxe ");
INSERT INTO leu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","taasaxa ri seng maat, naapalaan a maana rabuna ri filimaan xena bit tifie. E mui a rovaat re filimaan ");
INSERT INTO leu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","e re kuus, “A mataa aanabeꞌ a kuus, ‘Nenia, ne fexaxaas sena ngas tapin a tang lifu lotu sina Piran e vesan fulane lana yaan talatul.” ");
INSERT INTO leu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","E a memai priis a tigina e kuus xe si Yesus, “E nano, no taa pife gel votai sena ferawaian sire xasema?” ");
INSERT INTO leu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Taasaxa na Yesus a waan kasam. E fulaa a memai priis a ferawai xe sina, “Ne fakalimaan nano o no taa kuus tuuna: nano ve no Mataa Failai? No Natuna Piran?” ");
INSERT INTO leu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na Yesus a suie, “Nano, no fo kuus malaan. Taasaxa ne xuus nami xapiak: ti lana yaan aanabeꞌ mi taa xalum a Natuna Mataa aava nai la pamuaan sina Piran pana Gutan Xapiak, i taxa filimaan xe lapia la xavala xuluna mu vata.” ");
INSERT INTO leu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Layaan na Yesus a ferawai malaan a memai priis a ririk a marapi sina e kuus, “Nane xo pife suai faroxo sena Piran pana ferawaian saat aave! Maam taa pife seng ta xasano rabuna xena gel tifie. Monabeꞌ mon mi fo langai a ferawaian saat sina! ");
INSERT INTO leu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mi lamon malaafaa sena?” E ri suie, “Nane a vupuno e i taa maat.” ");
INSERT INTO leu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","E ri xanus a nonau ina e ri sipe e nari aava ri tavafe ");
INSERT INTO leu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ri kuus, “Kuus fatuxai pamaam, Mataa Failai! Naseꞌ sip nano?” ");
INSERT INTO leu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Na Pita i taxa nai lamalei sena lifu aave e saxa yaasok tefin a savat sina e a kuus, “Nano vaxa no waan xuvul pa Yesus ti Galili.” ");
INSERT INTO leu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Taasaxa na Pita a faaxolus la matana mu rabuna e a kuus, “Ne pife texaas sena so ta mo no taxa ferawai pana.” ");
INSERT INTO leu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","E a falet xe la matana yalaxau ina nobina aave. E xasa yaasok tefin a xalume e a kuus xe sina mu tomexaan pave, “Nane waan xuvul pa Yesus ti Nasaret.” ");
INSERT INTO leu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","E fulaa a faaxolusane e a kuus fakalimaan, “Ne pife texaas sena mataa aave!” ");
INSERT INTO leu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","E mui fadak a mu tomexaan aava ri waan faasilak ri savat si Pita e ri kuus, “Nano xo no saxa siri. No filimaan ti Galili. Maam langai taraxali a lingaam.” ");
INSERT INTO leu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","E na Pita a xelmaan a fatutulan xe xuluna xa e a kuus fakalimaan fulaa, “Ne pife texaas sena mataa aave.” E lana yaan fatak aave a pura a rawei ");
INSERT INTO leu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","e na Pita a lamon faꞌuli a ferawaian si Yesus: “Paamuina yaan a pura i taa rawei, nano, no taa kuus faatalatul o no pife texaas sega.” E na Pita taꞌulan a nobina aave e falet xe lamalei e a taangiis faagut pana mimilisaatan. ");
INSERT INTO leu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","La paanen lolof a mu paamua priis xuvul pana mu matalava ri lalamon pana punuxaan na Yesus. ");
INSERT INTO leu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ri pise e ri lisane xe si Pailat aava paamuian a bina pave lapaana paamua lava ti Rom. ");
INSERT INTO leu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Layaan na Judas aava pet lisan na Yesus, a texaas o a mu paamua ri fo kuus o na Yesus a vupuno e i taa maat, a mimilisaatan molava a siaxe e nane lisan faꞌuli a faat ‘silva’ sangafilu talatul xe sina mu priis. ");
INSERT INTO leu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","E a xuus nari, “Nenia, ne fo faasaal faagut pana pet lisanaana mataa aava pife vupuno!” E nari, ri kuus, “A lagafan siim xo pife mo simaam.” ");
INSERT INTO leu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Na Judas a tapin fasivi a mu faat aave la nobina ina tang lifu lotu e falet xena xiut fatofan nane xa e a maat. ");
INSERT INTO leu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Taasaxa mu paamua priis ri siak a mu faat aave e ri kuus, “A mu faat aanabeꞌ a mamareiai ina ria e a mu vuputkai sitaara a kuus o pife roxo xena fawaane xuvul pana mu faat sina lifu lotu.” ");
INSERT INTO leu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ri ferawai pana e ri lamon o ri taa maraan a xavala sina mataa ina vavesai pana xavala. Ri maraane xena xaafanaana mu topen. ");
INSERT INTO leu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","E fefexaxaas tanin ri xali a xavala aanabeꞌ pana “Xavala ina Ria”. ");
INSERT INTO leu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","E layaan a mu paamua priis ri vil malaane, a ferawaian sina mataa ina kuus fatuxai, na Jeramaia, a savat tuuna la matavas: “Ri siak a faat ‘silva’ sangafilu talatul, a mamareiai aava saxano rabuna Juda ri turoxo pana ");
INSERT INTO leu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","e ri maraan a xavala sina mataa ina vavesai pana xavala malaan sena Memai a xuusau pana.” ");
INSERT INTO leu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Na Yesus i taxa tigina la mata Pailat aava paamua lava ina bina e nane xo a fin na Yesus, “Nano ve no paamua king sina mu Juda, bo?” E na Yesus a suie, “Nano, no kuus malaan.” ");
INSERT INTO leu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Taasaxa layaan a mu paamua priis xuvul pana mu matalava ri gel tifie, nane pife sui nari. ");
INSERT INTO leu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","E voxo na Pailat a kuus xe sina, “No langai a maana gelan siri, bo?” ");
INSERT INTO leu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Taasaxa na Yesus a pife sui ta saxa fiaian. E a paamua aave a ipul faagut sena. ");
INSERT INTO leu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","La maana Fenamo ina Paaliuan a paamua lava aave fuuna mulus tapin ta saxa mataa vipis aava malila ri vubuxane. ");
INSERT INTO leu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lana yaan aave a toxan a mataa vipis aava mu rabuna xapiak ri texaas sena vilaana saat sina, a isina na Baraabas. ");
INSERT INTO leu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","E layaan a malila ri fo faxuvul, na Pailat a fin nari, “Naseꞌ ta mataa vipis mi vubuk rao ne taa mulus tapine xe simi? Na Baraabas o na Yesus aava ri xalie pa Krais?” ");
INSERT INTO leu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nane texaas o a mu paamua sina mu Juda ri fo lisan na Yesus xe sina senaso ri tarasuie. ");
INSERT INTO leu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","E fulaa, layaan i taxa nai la nobina ina tiisan, a tefin sina fo lisan a lagasai xe sina, “Muta vil ta mo xasena mataa fatak aave senaso la vung ne fo mif fasaat sena.” ");
INSERT INTO leu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Taasaxa mu paamua priis xuvul pana mu matalava, ri yuuf a lamonan sina malila e voxo ri fin na Pailat o i taa mulus tapin na Baraabas e punuk na Yesus. ");
INSERT INTO leu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Taasaxa na Pailat a fin a malila, “Naseꞌ la palou ire mi vubuk rao ne taa mulus tapine xe simi?” E ri suie, “Na Baraabas!” ");
INSERT INTO leu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","E na Pailat a fin nari, “Lavaxa, taasaxa ne taa vil a so pa Yesus aava ri xalie pa Krais?” E nari xapiak ri kuus, “Niil fataxutane!” ");
INSERT INTO leu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","E na Pailat a fiai, “A so ta vilaana saat nane fo vile?” E nari, ri xukulai faagut, “Niil fataxutane!” ");
INSERT INTO leu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Layaan na Pailat a texaas o a pife fexaxaas sena vil ta mo fulaa e a mu rabuna ri tamaa fegagelai e fasavat a fevisan, nane siak a raarum e xamak a mana la matana malila e a kuus, “Nenia, ne taa pife vupuno sena ria ina mataa fatak aanabeꞌ! A mo aanabeꞌ a faisok simi.” ");
INSERT INTO leu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","E a malila xapiak ri suie, “A vupuno ina maatan sina i taa waan xulumaam e mu yaya simaam!” ");
INSERT INTO leu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","E na Pailat a mulus tapin na Baraabas xe siri e xuus a mu rabuna ina rawen sina o ri taa inis na Yesus pana yeis tuturuk e mui ri taa niil fataxutane. ");
INSERT INTO leu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","E mui a mu rabuna ina rawen si Pailat ri lisan na Yesus xe lana lifu ina fawaan a maana mo ina fevisan e xasano rabuna ina rawen xapiak ri fakaliuane. ");
INSERT INTO leu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ri ririk tapin a marapi sina e ri falaxe pana marapi vuung ina xakaafut. ");
INSERT INTO leu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","E ri fi a ligilot pana yeis tuturuk e faneie la putuna e ri timin a newai la pamamuaan sina. E mui ri bukaak la nona e ri suaxane e ri kuus, “Maam suai sema, ‘King’ sina mu Juda!” ");
INSERT INTO leu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","E ri kaanus la tana e ri siak a newai aave e sipe la putuna. ");
INSERT INTO leu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Layaan ri fataxapin a xurauan saat siri, ri siak tapin a marapi vuung e falaxe pana marapi sina xa e ri lisane xena niil fataxutane. ");
INSERT INTO leu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Layaan ri taxa taꞌulan a bina aave ri savat sina saxa mataa ti la bina Sairiin, a isina na Saimon, e a mu rabuna ina rawen ri fatuaiane xena yaas a bolo si Yesus. ");
INSERT INTO leu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","E layaan ri savat la bina Golgaata, a malasuf ina isin aanabeꞌ ve “A bina ina veng”, ");
INSERT INTO leu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ri tavai tarei na Yesus pana wain aava toxan a mo mopaak lana ri xalie pana ‘gaal’ xena nume taasaxa layaan a tafang tareie, a bai nume. ");
INSERT INTO leu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Layaan ri fo niil fataxutane xena punuxaana, ri tapin a faat xena texaas o naseꞌ taa siak a marapi sina. ");
INSERT INTO leu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","E mui ri taxa nai faxatange. ");
INSERT INTO leu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","E laaꞌui la putuna bolo ri timin a lagasai aava kuus pana gel tifiaana, “A mataa aanabeꞌ na Yesus aava King sina mu Juda.” ");
INSERT INTO leu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","E mui ri niil fataxutan a rovaat tomexaan ina fenau xuvul pa Yesus, saxa la pamuaan sina e saxa la paxaiya. ");
INSERT INTO leu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nari aava ri liu ete, ri liitan a puturi e ri ferawai fasaat xe si Yesus ");
INSERT INTO leu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","e ri kuus, “Nano, no kuus o no taa ngas tapin a tang lifu lotu e vesan faꞌulie lana yaan talatul, lavaxa fakaxup nano xa. Tamo nano ve no Natuna Piran sivimaan ti xuluna bolo aave!” ");
INSERT INTO leu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","E mu paamua priis, mu matalava e mu rabuna ina fepitaa pana vuputkai ri vil malaane sait e ri kuus, ");
INSERT INTO leu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nane fakaxup a xasanofuna taasaxa pife fexaxaas sena fakaxup nane xa! Tamo nane ve a piran king tuuna sina mu Israel i taa sivimaan ti xuluna bolo e taara taa namkai sena. ");
INSERT INTO leu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nane namkai o a Piran i taa xavange e a kuus o nane ve a Natuna Piran. Tamo Piran a vubuk rao i taa fakaxupe naak i taa vile naboxo.” ");
INSERT INTO leu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","E a rovaat ina fenau aava ri niil fataxutan nare xuvul pana, nare vaxa re ferawai fasaat sena. ");
INSERT INTO leu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","La paanaas, faasilak la belo, a bina xapiak fesuk pana awa talatul. ");
INSERT INTO leu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","La 3 oklok na Yesus a xukulai faagut, “Eloi, Eloi lama sabaatani!” a malasuf ina, “Piran siak, Piran siak, xenaso no lamon taꞌulanau?” ");
INSERT INTO leu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","E saxanofuna aava ri ti faasilak, ri langaie e ri kuus, “Nane taxa xel na Ilaija!” ");
INSERT INTO leu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","E saxa mataa ina rawen a falapukmaan e siak a pel, timine lana wain mopaak e pise la ngusuna wai e tavaie pana xena num. ");
INSERT INTO leu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Taasaxa xasanofuna ri kuus, “Naboxo maam taa texaas tamo na Ilaija i taa fakaxupe.” ");
INSERT INTO leu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na Yesus a xukulai faagut fulaa e a mulus tapin a vovau sina e a maat. ");
INSERT INTO leu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","E lana yaan aave a marapi aava tofai la tang lifu lotu a tiririk xapiak ti laaꞌui xe lapia. A Piran a faradakui a xavala e gurum a maana faat. ");
INSERT INTO leu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","E a maana bina ina mamaat ri talakas e maana rabuna xaradak sina Piran aava ri fo maat, ri to faꞌulaa ti la mamaat ");
INSERT INTO leu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","e ri taꞌulan a bina mamaat. Lamina yaan a Piran a fatatoi faꞌuli na Yesus ti la maatan, ri laak la Bina Xaradak, na Jerusalem, e pave a maana rabuna xaves ri xalum nari. ");
INSERT INTO leu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Layaan a paamua sina rabuna ina rawen e mu rabuna ina rawen aava ri waan xuvul pana xena faxatang na Yesus ri xalum a maraꞌulia e xasano mo aava savat, ri mataut faagut e ri kuus, “Tuuna paaliu, nane ve a Natuna Piran.” ");
INSERT INTO leu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A toxan a lutefin xaves pave aava ri fo falet xolai xuvul pa Yesus ti la bina Galili xena xavange. Ri taxa ti falim a maana mo aanabeꞌ ti lasuun fadak. ");
INSERT INTO leu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","La palou iri na Maria ti Mekdala, na Maria aava na nina Jems nare Joses e a tefin si Sebedi, rutul taxa waan. ");
INSERT INTO leu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Faasilak a bina i suk e a mataa piran ti Erimatia fe savat si Pailat. A mataa aave a isina na Yosep e nane vaxa a saxa fefeng si Yesus. ");
INSERT INTO leu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nane laak soxot na Pailat e fine pana vipin i Yesus. E na Pailat a kuus o ri taa tavaie pana. ");
INSERT INTO leu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","E voxo na Yosep a siak a vipin i Yesus e pise pana marapi faꞌui ");
INSERT INTO leu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","e famatie lana liing ina mamaat sina xa aava ri fo taxe lana faat. E a tivotan a matana liing aave pana tang faat e taꞌulan a bina. ");
INSERT INTO leu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na Maria ti Mekdala xuvul pa xasa Maria re taxa nai kaalum xe la matana liing aave. ");
INSERT INTO leu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","A yaan mui aava Yaan ina Fangaafusan, a mu paamua priis xuvul pana mu Ferasi ri falet faxuvul xena ferawai xuvul pa Pailat ");
INSERT INTO leu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","e ri kuus, “Matalava, maam lamon faꞌuli a ferawaian sina mataa ina bitan aave. Layaan i taxa to lunai a kuus, ‘Lamina yaan talatul ne taa to faꞌulaa.’ ");
INSERT INTO leu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Xuus a mu rabuna ina rawen siim o ri taa kaalum votai sena liing ina mamaat aave fefexaxaas a fatalatulaana yaan talo a mu rabuna sina ri taa pife fenou a vipin ina e xuus a mu rabuna o nane taxa to faꞌulaa. A bitan fataxapiak aanabeꞌ i taa mo mosaat sena bitan mata.” ");
INSERT INTO leu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Na Pailat a kuus xe siri, “Lavaxa, ne taa tavai nami pana rabuna ina rawen xena kaalum votai sena liing ina mamaat. Faxaꞌusi a vubuxanan simi.” ");
INSERT INTO leu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","E voxo ri fe timin a fakalimaanan xuluna tang faat aave e ri feng a mu rabuna ina rawen xena kaalum votai. ");
INSERT INTO leu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Lamina Yaan ina Fangaafusan, la paanen lolof la yaan mata ina ‘wiik’, na Maria ti Mekdala xuvul pana xasa Maria, re falet xe la liing ina mamaat aave. ");
INSERT INTO leu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","E fataapus a toxan a maraꞌulia lava senaso a saxa angelo sina Memai a sivimaan ti laaꞌui la xunavata e fe pul tapin a tang faat aava ti votan a liing e a nai xuluna. ");
INSERT INTO leu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A kaaluman sina a malaan sena yaamit e a marapi sina a pasak paaliu marasaxa. ");
INSERT INTO leu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","E mu rabuna ina rawen ri poxo xe lapia pana matautan e ri mati fatak malaan sena mu mamaat. ");
INSERT INTO leu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","A angelo aave a ferawai xe sina rovaat tefin e a kuus, “Muta mataut, ne texaas o me taxa seng na Yesus aava ri niil fataxutane. ");
INSERT INTO leu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nane pife waan nabeꞌ; a Piran fo fatatoi faꞌulie ti la maatan malaan sena fo ferawai pana. Man, xalum a bina aava nane fo mati lana ");
INSERT INTO leu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","e falet fataapus e me xuus a mu fefeng sina, ‘A Piran fo fatatoi faꞌulie ti la maatan e naboxo i taxa falet paamuin nami xe pe Galili e mi taa xalume pave.’ Lavaxa, falet, ne fo xuus name pana.” ");
INSERT INTO leu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","E voxo re taꞌulan fatapusan a liing ina mamaat aave. Re mataut taasaxa re bas pana faamamaasan e re fala fataapus xena xuus a mu fefeng pana. ");
INSERT INTO leu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","E na Yesus a savat faꞌipul sire e a kuus, “Paanen Roxo name.” Re falet faasilak xe sina e re bukaak xe lapia e tao a kana e re nanguse. ");
INSERT INTO leu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","E na Yesus a xuus nare, “Muta mataut, me fe xuus a mu fetinan siak xena falet xe puaa Galili e pave ri taa xalumau.” ");
INSERT INTO leu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Layaan a rovaat tefin re taxa falet xe sina mu fefeng sina, saxano rabuna ina rawen aava ri taxa faxatang a liing ina mamaat xo, ri laak ulaa xe la bina lava e ri xuus a mu paamua priis pana maana mo xapiak aava fo savat. ");
INSERT INTO leu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","E mu priis aave ri faxuvul xuvul pana mu matalava xena lamon pana so ta mo ri taa vile. Ri maraan a mu rabuna ina rawen pana mamareiai lava ");
INSERT INTO leu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","e ri kuus, “Mi taa kuus o a mu fefeng sina ri savat la xunavung e ri fenou a vipin ina layaan mi taxa matef. ");
INSERT INTO leu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","E tamo a paamua lava ti Rom i taa langai pana fenouaana, maam taa faxaradaxe talo mi taa piau ta lagafan sena.” ");
INSERT INTO leu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","E voxo a mu rabuna ina rawen ri siak a mamareiai aave e ri usi fatak a ferawaian sina mu paamua priis. E a xuuskuus aanabeꞌ fuuna lo falet xolai la palou ina mu Juda fefexaxaas tanin. ");
INSERT INTO leu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A mu fefeng sangafilu saxa pana saxa xo, ri falet xe puaa Galili, xe la put aava na Yesus a feng nari xe xuluna. ");
INSERT INTO leu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Layaan ri xalume pave ri lotuie naapalaan saxanofuna ri pife texaas tuuna o nane ve na Yesus. ");
INSERT INTO leu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","E na Yesus maa savat la tari e kuus xe siri, “A Piran fo tavaiau pana tateaxan xapiak xena paamuianaana maana mo xapiak la xunavata e la xavala. ");
INSERT INTO leu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Falet xo xe sina mu rabuna xapiak la xavala e fapiti nari talo ri taa namkai xena usiau. Fasuf nari lapaana isi Tamaang, a Natuna e a Vovau Xaradak ");
INSERT INTO leu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","e fapiti nari xena langai fatak a maana vuputkai aava ne fo tavai nami pana. E nenia xo, ne taa waan vulai xuvul pami fefexaxaas a yaan a xavala aanabeꞌ i taa taxapus.” ");
INSERT INTO leu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","A Lagasai Roxo se Yesus Krais aava lak sina Piran, a tangpat malaan: ");
INSERT INTO leu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","na Aisaia, a saxa mataa ina kuus fatuxai sina Piran ti kavai a xalei a ferawaian sina Piran pa Yesus. “Langaiau, ne taa feng a mataa ina lisan a ferawaian siak, i taa savat paamuin nano e i taa faigotan a salan siim. ");
INSERT INTO leu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","A ling ina mataa aave i taa kel pe la bina vingil, ‘Faigotan a salan xana Memai. Vil faxaradak a salan sina.” ");
INSERT INTO leu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na Jon xo, a mataa ina fasufan, a savat pe la bina vingil e a xuus a mu rabuna o ri taa puk a xunus iri e a fasuf nari talo a Piran i taa lamon tapin a vilaana saat siri. ");
INSERT INTO leu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","E a maana mu rabuna ti Judia e ti Jerusalem ri paan xe si Jon e ri fe kuusan fasavat a maana vilaana saat siri e nane fasuf nari lana Raarum Jordan. ");
INSERT INTO leu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Na Jon a mataa valagof e vesan a marapi sina pana fui ina ‘kaamel’. E nane pis nane xa pana yowang aava vesanan pana vipin ina ‘kaamel’ e fuuna ngan a sakawa e vevoi ti la latan. ");
INSERT INTO leu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na Jon xo, a kuus famatavas malaan, “A toxan a mataa i taa filimaan lumui lamiak, a mataa aave a faagut sega e nenia vaxa ne suai faagut sena. Ne pife fexaxaas sena mulus a ‘slipa’ ti la kana. ");
INSERT INTO leu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naboxo ne taxa fasuf nami pana raarum tuuna taasaxa nane, i taa fasuf nami pana Vovau Xaradak.” ");
INSERT INTO leu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mui famodak na Yesus xo a savat ti la bina Nasaret pe Galili e na Jon a fasufe lana Raarum Jordan. ");
INSERT INTO leu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Layaan nane laakmaan ti la raarum a xalum a xunavata a talakas e a Vovau Xaradak, malaan sena vaalus, a sivi xuluna. ");
INSERT INTO leu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","E saxa ling aava savat ti pe laaꞌui lana vata a kuus malaan: “Nano, no natuk, ne vubuxan xasingit nano, a xunus iga a roxoian nano!” ");
INSERT INTO leu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","E fataapus temasaat a Vovau Xaradak a feng na Yesus xe la bina vingil. ");
INSERT INTO leu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","E nane waan pave fefexaxaas sena yaan sangafilu talafaat e na Setan a valame. A waan la palou ina mu vupung taasaxa mu angelo ri maa xavange. ");
INSERT INTO leu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Na Jon fo vipis xo e na Yesus a paan xe pe Galili e fe kuusan fasavat a Lagasai Roxo sina Piran. ");
INSERT INTO leu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nane kuus, “A yaan tuuna fo savat xong. A fatataganan sina Piran fo savat faasilak naboxo. Mi taa puk a xunus imi e mi taa namkai sena Lagasai Roxo.” ");
INSERT INTO leu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Saxa yaan na Yesus taxa lo sangas et la vangana Laman Galili e nane xalum na Saimon xuvul pa tina, na Endru. Narie, re taxa fati a vana pe la taas senaso re fuuna faasot pana din. ");
INSERT INTO leu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na Yesus moxo, a xuus nare, “Usiau e nenia, ne taa fapiti name pana vilaana ina pataasaana rabuna.” ");
INSERT INTO leu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","E fataapus re taꞌulan a vana sire e re usie. ");
INSERT INTO leu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","E rutul falet famodak fulaa e na Yesus a xalum na Sebedi e a ro lak sina, na Jems e na tina na Jon. Narutul taxa nai lana xaati e rutul taxa faxaradak a vana sirutul. ");
INSERT INTO leu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","E nane xel nare e re taꞌulan na tamare lana xaati xuvul pana mu sisiak siri e re usi na Yesus. ");
INSERT INTO leu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","E nari xapiak, ri falet xe la bina Kapanam. Layaan a Yaan ina Fangaafusan sina mu Juda a savat, na Yesus xuvul pana mu rabuna, ri laak xe la lifu ina faxuvulan sina mu Juda e nane fepitaa tapang. ");
INSERT INTO leu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A mu rabuna ri langai a ferawaian sina e ri ipul senaso a ferawaian sina toxan a gutan, pife malaan sena fepitaian sina xasano rabuna aava ri masam pana vilaana si Moses. ");
INSERT INTO leu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","E monabeꞌ mon ri ipul sena mataa pana vovau saat moxo, a laak saa la lifu ina faxuvulan e maa barak xuluri malaan, ");
INSERT INTO leu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesus ti Nasaret, no vubuk vil a so semaam? Naak no vubuk vil pengan nemaam! Ne texaas sema, nano, no Mataa Failai sina Piran.” ");
INSERT INTO leu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Na Yesus moxo, a maraleiane e a kuus, “No waan kasam e no taꞌulan a mataa aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","E a vovau saat a vil faradakui a mataa e a kuup faagut e nane taꞌulane. ");
INSERT INTO leu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","E mui a mu rabuna pave, re ipulan na Yesus e ri fefiaian nari e ri kuus, “A so ta mo nabeꞌ? A fepitaian faꞌui pana gutan, bo? A mataa aanabeꞌ a farawei a mu vovau saat e ri langai sina.” ");
INSERT INTO leu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Lavaxa, a lagasai pana vilaana si Yesus a falet fataapus xe la maana mu bina pe Galili. ");
INSERT INTO leu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Lumui na Yesus e mu fefeng sina, ri savat xe lamalei e ri fe paan xe la lifu si Saimon narie Endru. Na Jems e na Jon, re falet xuvul pari sait. ");
INSERT INTO leu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na imu Saimon i taxa mati xuluna ivin e toxan a giisan pana tana lalagaf. E fataapus ri xuus fatexaas na Yesus pana. ");
INSERT INTO leu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Na Yesus a paan xe sina e tao a mana e fatamasiaxe. A giisan sina a taxapus e nane tavai nari pana fanganan xari. ");
INSERT INTO leu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","La leaaf layaan a ngaas a rul, a mu rabuna ti la bina, ri lisan a maana rabuna aava ri toxan a giisan xuvul pana maana rabuna ri toxan a vovau saat xe si Yesus. ");
INSERT INTO leu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A mu rabuna xapiak ti la bina, ri faxuvul pe la matana lifu. ");
INSERT INTO leu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","E nane vil faroxoi a rabuna aava ri toxan a mu giisan e a gei tapin a mu vovau saat. A mu vovau saat xo, ri texaas sena taasaxa nane ti votan nari sena ferawai. ");
INSERT INTO leu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","La paanen lolof, nane tamasiak xe lamalei e fe paan xe la saxa nobina gof rao i fenung xe sina Piran. ");
INSERT INTO leu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","E na Saimon xuvul pana mu fefeng sina ri seng na Yesus. ");
INSERT INTO leu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ri fe tingin xo nane e ri xuuse, “A maana rabuna, ri taxa fiaian nano.” ");
INSERT INTO leu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Taasaxa na Yesus a susuaa malaan, “Naapalaan, taara taa paan xe la saxano bina faasilak, rao ne ferawai pari. Nabeꞌ a fufuna filimaanan siak.” ");
INSERT INTO leu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nane falet xe la maana mu bina pe Galili e a ferawai lana mu lifu ina faxuvulan e gei tapin a mu vovau saat la tana rabuna. ");
INSERT INTO leu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","La saxa yaan, saxa mataa aava tana tapak, a savat si Yesus. Nane bukaak e fenung xe si Yesus e kuus malaan, “Tamo no vubuxane, no taa vil faroxoiau.” ");
INSERT INTO leu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na Yesus xo muluk nane e tao a tana e xuuse, “Aang, ne vubuxane, naboxo a giisan siim a taxapus.” ");
INSERT INTO leu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","E fataapus a tapak sina mataa aave a malit e nane fo roxo. ");
INSERT INTO leu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Na Yesus a pebukan faagutane e feng faꞌulie. ");
INSERT INTO leu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","A xuuse malaan, “Muta kuus fepuk pana faroxoiaan nano. No taa falet e no fe faxalum a taam xe sina priis e no taa tavai a Piran pana tatavaian siim. A tatavaian aave i taa usi a vilaana si Moses. ");
INSERT INTO leu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Taasaxa mataa aave a falet e kuusan fasavat a roxoiaana aava na Yesus fo vile. Pevoxo na Yesus pife fexaxaas sena laak la bina saxa ulaa rabuna ri tamaa fatagule. E voxo nane paan xe pe la xobingil e maana mu rabuna xaves ri taxa falet xe sina pave. ");
INSERT INTO leu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","La saxanu yaan fo falet e nane ulaa fulaa xe Kapanam. A rabuna ri langai o nane i taxa waan lana saxa lifu pave. ");
INSERT INTO leu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","E a malila ri savat faxuvul e a lana lifu febas e faasilak la matana lifu sait. E nane ferawai xe sina rabuna pana Lagasai Roxo. ");
INSERT INTO leu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","A saxanu tuvaat talafaat, ri lisan a saxa mataa a kana e mana maat e ri yaase pana ivin. ");
INSERT INTO leu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ri pife fexaxaas sena yaase xe si Yesus senaso a malila. E voxo ri laak xe laaꞌui xuluna lifu e ri ngas a nobina xena faduiaana mataa. E ri fasivie pana ivin xe si Yesus. ");
INSERT INTO leu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na Yesus a xalum a namkaian siri e a xuus a maalapen malaan, “Lak siak, ne lamon tapin a vilaana saat siim.” ");
INSERT INTO leu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Taasaxa xasano rabuna aava ri masam sena Vuputkai si Moses, ri taxa nai lamon lana lalamonan siri sena ferawaian si Yesus e ri lamon malaan, ");
INSERT INTO leu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Xenaso a mataa aanabeꞌ a kuus fasaat malaan? Naseꞌ ta mataa fexaxaas sena lamon tapin a vilaana saat sina mataa? A faisok sina Piran sang mon! Naak nane taxa bit!” ");
INSERT INTO leu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Fataapus paaliu na Yesus fo texaas sena lalamonan siri e a kuus, “Nami, mi lamon fasaat! Xenaso mi lamon malaan pana nobina siak ina lamon tapin a vilaana saat sina mataa aanabeꞌ? ");
INSERT INTO leu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","A so ta ferawaian a malui sena kuusanaana? Tamo ne taa kuus xe sina maalapen, ‘Ne taa lamon tapin a vilaana saat siim!’ o tamo ne taa xuuse, ‘No tamasiak e no siak a ivin siim e no falet.’ ");
INSERT INTO leu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Talo mi taa texaas sega, a Natuna Mataa aava toxan a gutan xena lamon tapin a mu vilaana saat sina rabuna, ne taa vile malaan.” E nane kuus xe sina maalapen, ");
INSERT INTO leu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nenia, ne xuus nano, tamasiak, siak a ivin siim e no paan xe la lifu siim!” ");
INSERT INTO leu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","E a maalapen a tamasiak marasaxa e siak a ivin sina e savat xe lamalei. A mu rabuna xapiak ri xalume e ri ipul e ri kuus fati a isina Piran. E ri kuus malaan, “Taara pi xaxalum a buk vilaana malaan lumua.” ");
INSERT INTO leu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na Yesus a sangas ulaa fulaa xe la vangana Laman Galili e a malila ri paan xe sina e nane fapiti nari pana lagasai sina Piran. ");
INSERT INTO leu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Layaan nane taxa sangas falet, a xalum na Matiu Livai, a lak si Elfias, i taxa nai la lifu ina maraan taakis. Na Yesus a xuuse, “No usiau!” E nane tamasiak e usi na Yesus. ");
INSERT INTO leu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mui xo na Yesus fe fangan lana lifu si Matiu Livai e a mu rabuna ina siak taakis e mu rabuna pana vilaana saat, nari xapiak, ri taxa fangan xuvul pa Yesus e mu fefeng sina. A mu rabuna aava ri mangil sena vilaana saat siri, ri vubuk langaie e voxo ri usi xolane. ");
INSERT INTO leu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","E saxano rabuna aava ri usi a vilaana sina mu Ferasi, ri xalum na Yesus i taxa nai fangan xuvul pana mu rabuna pana vilaana saat e mu rabuna ina siak taakis. E ri fin a mu fefeng sina, “Xenaso nane taxa fangan xuvul pana mu rabuna ina siak taakis e mu rabuna pana vilaana saat? Naak a vilaana aanabeꞌ pife roxo.” ");
INSERT INTO leu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na Yesus a langai a ferawaian siri e xuus nari, “A rabuna aava ri piau ta giisan, ri pife paan xe sina mataa iꞌirin. Piau! Nenia, ne pife filimaan nabeꞌ xena xelaana mu mataa aava ri lamon o ri taxa waan faroxo. Ne savat xena xelaana mu rabuna aava ri texaas o a vilaana siri a saat.” ");
INSERT INTO leu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Xasano Ferasi e mu rabuna aava ri usi na Jon, a mataa ina fasufan, nari xapiak, ri fuuna falfaal e saxano rabuna ri savat si Yesus e ri fiai malaan, “Senasou a fefeng si Jon e mu Ferasi ri fuuna falfaal taasaxa mu rabuna siim ri pi falfaal?” ");
INSERT INTO leu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Na Yesus a xuus nari, “Naak a mu fesing sina saxa mataa aava rao i tamai, ri taa faalaan pana fanganan layaan a mataa aave i taxa waan xuvul pari? Piau! Tamo mataa aava rao i tamai i taxa waan xuvul pari, ri taa pife falfaal. A yaan ina merawan mon! ");
INSERT INTO leu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tamo mataa naang i taa paan tapin a mu fesing sina, lavaxa la yaan aave bak, ri taa falfaal xena fakalimaan a mimilisaatan siri.” ");
INSERT INTO leu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","E nane fin nari, “Naseꞌ ta mataa i taa kap a valof ina marapi xavai pana pamarapi faꞌui? Tamo no taa vil malaane a marapi faꞌui i taa gat faxuvule e a valof i taa tiririk falava. ");
INSERT INTO leu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","E piau ta mataa i taa xapis a uma lana vaafa xavai. Tamo i taa vil malaane a vio i taa laak lana e i taa kawaasan a fanganan. A fanganan e vaafa taa kawaasanan. A rabuna masam, ri taa pai a vaafa faꞌui xena uma faꞌui. ");
INSERT INTO leu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","La saxa Yaan ina Fangaafusan na Yesus a sangas lana uma e mu rabuna aava ri taxa usie ri lagai e ri taxa murul a fanganan pave e ri taxa ngane. ");
INSERT INTO leu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","E saxano Ferasi ri xuus na Yesus, “Xalum nari, ri taxa vil a faisok la Yaan ina Fangaafusan. A vuputkai sitaara a kuus votan a vilaana ina faisok la Yaan ina Fangaafusan. A pife roxo ri taa vil malaane la yaan aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Na Yesus a xuus nari, “Naak mi pife texaas sena xuuskuus ina vilaana a savat se Devit layaan nane xuvul pana mu rabuna sina ri piau ta fanganan e ri lagai? ");
INSERT INTO leu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","La yaan si Abaiata aava saxa paamua ina mu priis sina Piran, na Devit a laak lana lifu lotu sina Piran e nane ngan a bret taap aava mu priis sina Piran sang mon ri fexaxaas sena ngane. Taasaxa na Devit a ngane e tavai a rabuna sina pana.” ");
INSERT INTO leu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ne Yesus a xuus nari fulaa, “A Piran pife timin a mataa xena xavang a Yaan ina Fangaafusan, piau! Nane timin a Yaan ina Fangaafusan xena xavangaana mataa. ");
INSERT INTO leu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","E voxo, a Yaan ina Fangaafusan xo, a Natuna Mataa a paamuiane.” ");
INSERT INTO leu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","La saxa Yaan ina Fangaafusan fulaa na Yesus a laak lana lifu ina faxavulan e a mataa mana tapil i taxa waan. ");
INSERT INTO leu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","E saxano rabuna ri waan bang na Yesus pana senaso ri vubuk texaas tamo nane i taa vil faroxoi a mataa aave la Yaan ina Fangaafusan talo ri taa tiise sena. ");
INSERT INTO leu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","E na Yesus moxo, xuus a mataa aava mana tapil, “Tamasiak e no tigina la nona rabuna.” ");
INSERT INTO leu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","E na Yesus a fin a rabuna, “A vuputkai si Moses a kuus o taara taa vil a vilaana roxo la Yaan ina Fangaafusan o taara taa vil a vilaana saat? A kuus o taara taa xavang a mataa talo i taa waan faroxo o taara taa punuk a mataa?” E nari, ri pife sui a ferawaian sina, ri nai kasam mon. ");
INSERT INTO leu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","E na Yesus a xalum nari e a vilauna a kasal taasaxa muluk nari senaso ri vungut sena mamaaluxan sina Piran. E nane xuus a mataa, “No faxaradak a maam!” E a mataa faxaradaxe e a mana fo roxo. ");
INSERT INTO leu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","E fataapus a mu Ferasi ri tamasiak e ri fe savat faxuvul sina nutuvaat si Herot. Nari, ri ferawai faxuvul xena seng ta nobina xena punuxaan na Yesus. ");
INSERT INTO leu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Na Yesus xuvul pana mu fefeng sina, ri falet e ri fe nai la vangana raarum e saxano rabuna ti Galili e ti Judia ri usie. ");
INSERT INTO leu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","A rabuna ti Jerusalem, ti Idumia e ti lu paa paaliu se Jordan e ti la saxa ro bina Tair e Saidan, a malila molava paaliu ri langai pana faisok na Yesus a vile e voxo ri savat faxuvul. ");
INSERT INTO leu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na Yesus a xuus a mu fefeng malaan, “A malila aava ri taxa waan, ri tamaa fatalinau. Ne vubuxan ta saxa xaati i taa waan bangau e ne taa xawas xuluna.” ");
INSERT INTO leu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lumua nane fo vil faroxoi a malila e ri naixaam soxote rao ri taa tao tuunei a tana senaso ri taxa vubuxan a roxoyan. ");
INSERT INTO leu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","E layaan a mu vovau saat ri xalume, ri turung xe sina e ri xukulai faagut malaan, “Nano ve no Natuna Piran!” ");
INSERT INTO leu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","E nane ferawai faagut xe siri o ri muneta fasavat a isina la matavas. ");
INSERT INTO leu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mui na Yesus a laak xuluna put e xel nari aava nane vubuxan nari o ri taa filimaan xe sina. E ri savat. ");
INSERT INTO leu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","E nane siak fati a sangafilu saxa pana taragua e a fasoxot nari pana mu Yaamut. Nane xuus nari, “Ne fo fati nami rao mi taa waan xuvul paga. Ne taa feng nami vaxa xena kuusan fasavat a Lagasai Roxo ");
INSERT INTO leu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","e vaxa mi taa toxan a gutan xena gei tapin a mu vovau saat.” ");
INSERT INTO leu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A mataa sangafilu saxa pana taragua aave voxo: na Saimon aava ri xalie pana xasa isin, na Pita, ");
INSERT INTO leu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","e na Jems, a lak si Sebedi xuvul pa tina, na Jon. Nane xali nare pana saxa isin, Boanesis, a malasuf ina isin aanabeꞌ ‘natuna vabarak.’ ");
INSERT INTO leu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","E na Endru, na Filip, na Baatalamiu, na Matiu Livai, na Tomas e na Jems a lak si Elfias, na Taadius, na Simon ti la parabuna Selot, ");
INSERT INTO leu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","e na Judas Iskeriot, a mataa aava pet lisan na Yesus xe sina mu rabuna saat xena punuxaana. ");
INSERT INTO leu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Layaan na Yesus a ulaamaan xe la lifu siri, a mu rabuna ri savat faxuvul fulaa xe sina. E voxo na Yesus xuvul pana mu fefeng sina ri piau ta yaan xari xena fanganan. ");
INSERT INTO leu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","A mu pabung si Yesus, ri langai o nane taxa waan fulaa e ri paan rao ri taa xel faꞌulie senaso a rabuna, ri xuus nari, “Naak na Yesus taxa ngong.” ");
INSERT INTO leu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","A saxano rabuna aava ri masam pana mu vilaana ti Israel e ri fuuna waan pe Jerusalem, ri sivimaan xe Galili. Ri ferawai se Yesus malaan, “Na Bilsibul a vawe e i taxa waan sina. Naak, nane taxa gei tapin a mu vovau saat pana gutan sina matalava sina mu vovau saat.” ");
INSERT INTO leu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na Yesus a xel faxuvul nari xe sina e ferawai xe siri pana saxano ferawaian paap malaan: ");
INSERT INTO leu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","“Tamo a faxatangan sina rabuna i taa tapagal fepatok e ri taa fevis, a vilaana ina faxatangan i taa pife waan fatateak! ");
INSERT INTO leu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tamo a pabung taa tapagal fepatok e ri taa fevis, a pabung aanabeꞌ i taa pife waan faroxo. ");
INSERT INTO leu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tamo na Setan i taa vis faꞌuli nane xa e saxano saxa sina ri taa faapalau sena, nane i taa pife gut fulaa, piau! Nane fo taxapus! ");
INSERT INTO leu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tamo ta saxa mataa rao i taa fenau, nane pife fexaxaas xena laak palau lana lifu sina mataa tateak, piau! Paamua i taa pis fatateak a mataa aave e mui i taa siak tapin a maana mo sina ti la lifu. ");
INSERT INTO leu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ne xuus tuunei nami, a Piran sang mon i taa lamon tapin a mo mosaat e mu ferawaian saat aava mu rabuna ri vile. ");
INSERT INTO leu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Taasaxa naseꞌ ta mataa i taa ferawai fasaat pana Vovau Xaradak, a Piran i taa pife lamon tapin a vilaana saat sina naboxo e lumui sait, piau! A vilaana saat sina mataa aave i taa waan vulai xe vulai!” ");
INSERT INTO leu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Na Yesus a kuus malaan senaso a rabuna ri fo kuus o nane toxan a vovau saat paaliu. ");
INSERT INTO leu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","La saxa yaan na nina Yesus xuvul pana mu ti Yesus ri savat. Ri tigina lamalei e ri xuus fatexaase rao i taa langai siri. ");
INSERT INTO leu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A malila aava ri taxa nai fakaliuane ri xuuse, “No langai? Na ninaam e mu tiam ri taxa waan lamalei e ri taxa xel nano.” ");
INSERT INTO leu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","E nane sui a ferawaian siri malaan, “Naseꞌ ve na ninaang e mu tiak?” ");
INSERT INTO leu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","E na Yesus a kaalum fepuk la palou ina rabuna aava ri taxa nai fakaliue e a xuus nari malaan, “Mi xalum na ninaang e mu tiak, ");
INSERT INTO leu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","a mu rabuna aava ri usi a ferawaian sina Piran, nari ve ri mu tiak e vasaak e ninaang!” ");
INSERT INTO leu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na Yesus a faisok fulaa pana fapitiaana rabuna la vangana Laman Galili. E nane xawas xuluna xaati senaso a mu rabuna xaves ri savat faxuvul sina. E nane nai xuluna xaati aava taxa waan lana raarum e mu rabuna xapiak ri taxa nai langai pe la gun e faasilak la vangana raarum. ");
INSERT INTO leu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na Yesus a tavai nari pana mu ferawaian paap. Nane ferawai xe siri malaanabeꞌ: ");
INSERT INTO leu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mi langai! A saxa mataa a falet e fetapalan xolan a kam ina ‘wiit’ la uma. ");
INSERT INTO leu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nane tapinete e saxano kam ina ‘wiit’ ri poxo lana salan e mu maanu ri maa ngan xapine. ");
INSERT INTO leu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","E xasano kam ri poxo la nobina toxai faat. A xavala pife temasaat xuluna e pife sivi temasaat lapia e a kam a fadui a xarei fataapus. ");
INSERT INTO leu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Taasaxa ngaas a lange e a kam aanabeꞌ pife boak faroxo, a piloxos e femaiyang. ");
INSERT INTO leu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","E xasano kam ina ‘wiit’ ri poxo lana yeis tuturuk. E a yeis aanabeꞌ a palak e fe xafute e a ‘wiit’ pife fuaa. ");
INSERT INTO leu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Taasaxa xasano kam ina ‘wiit’ ri poxo lana xavala roxo e ri palak faroxo e ri fuaa. Saxanofuna ri fuaa faroxo, xasanofuna ri toxan a kam xaves e saxanofuna ri toxan a kam xaves paaliu.” ");
INSERT INTO leu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","E na Yesus a xuus nari, “Tamo mataa i taa lamon pana ferawaian siak i taa tingin a malasuf ina.” ");
INSERT INTO leu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mui, lamina malila fo paan, a mu fefeng sina xuvul pana xasano rabuna ri fine pana mu ferawaian paap sina. ");
INSERT INTO leu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na Yesus a xuus nari, “A Piran a vubuk o mi taa masam faroxo sena ferawaian sina e ne fo xuus fatexaas nami o a fatataganan sina fo savat xo. Taasaxa mu rabuna aava ri waan lamalei ri taa langai a mu ferawaian siak lana ferawaian paap sang mon.” ");
INSERT INTO leu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","E voxo na Aisaia a kala malaan, “Naapalaan ri kaalum taasaxa ri taa pife taraxalie. E ri langai taasaxa ri taa vungut sena fufuna. E voxo malaan ri taa pife puk a xunus iri. Tamo ri taa puk a xunus iri a Piran i taa vil tapin a vilaana saat siri.” ");
INSERT INTO leu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na Yesus a fin nari fulaa, “Nami, mi pife texaas pana ferawaian paap aanabeꞌ e bo? Malaafaa mi taa texaas sena xasano ferawaian paap? ");
INSERT INTO leu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","A mataa aava xapis a kam ina ‘wiit’, nane xapis a ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","A ferawaian aava poxo lana salan a malaan sena mu rabuna aava ri texaas sena langaian taasaxa na Setan a filimaan e siak tapin a mu ferawaian aava Piran fo xapise la xunus iri. ");
INSERT INTO leu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","E saxano rabuna ri malaan sena kam ina ‘wiit’ a poxo lana xavala a toxai faat. Ri langaie e ri faxaꞌusie e ri faamamaas pana. ");
INSERT INTO leu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Taasaxa ri piau ta xarei ina lamon faagut, ri taxa waan famodak mon! Lumui xasano mataa rao ri tafang a gutan siri e ri taa fakasal nari, a lalamonan roxo siri i taa pife tateak fulaa, i taa malit. ");
INSERT INTO leu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","E saxano rabuna ri malaan sena kam ina ‘wiit’ aava ri poxo lana yeis tuturuk. A mu rabuna aanabeꞌ ri texaas sena langaian ");
INSERT INTO leu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","taasaxa ri lalamon temasaat pana mo ti la xavala e ri kanamsaat pana vubuxanaana tangop e maana mo xapiak. Ri taramangal a xasano mo. A maana buk mo aanabeꞌ a paasan a ferawaian sina Piran e mu rabuna aanabeꞌ ri pife vil fasavat a roxoyan. ");
INSERT INTO leu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Taasaxa saxano rabuna ri malaan sena kam ina ‘wiit’ aava poxo lana xavala roxo. Ri langai e ri tao fatateaxe. E a ferawaian sina Piran i taa fasavat a roxoyan lana toyan siri malaan sena kam ina ‘wiit’ roxo aava fuaian a kam xaves e a kam xaves paaliu.” ");
INSERT INTO leu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","E nane xuus nari, “Naak a mataa i taa timin a laam lapaana bi o lapaana ivin, bo? Piau! Nane taa timine laaꞌui talo i taa lang lana lifu. ");
INSERT INTO leu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A so ta maana mo aava waan fufunai, lumui ri taa savat la matavas. E maana mo xafutan, lumui i taa savat la matavas. ");
INSERT INTO leu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Naseꞌ ta mataa a tangana talakas i taa langai a ferawaian aanabeꞌ e i taa masame.” ");
INSERT INTO leu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","E na Yesus a xuus nari, “Ai, nami, mi taa lalamon pana ferawaian mi langaie. Tamo mi taa lalamon faagut pana, a Piran i taa tavai nami pana masaman fexaxaas sena lalamonan simi. ");
INSERT INTO leu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Naseꞌ ta mataa a toxan a masaman, lavaxa a masaman sina i taa savat molava sena. E naseꞌ ta mataa piau ta masaman, a texaasan modak sina i tafe malit.” ");
INSERT INTO leu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","E mui nane kuus, “A fatataganan sina Piran, i taa savat molava malaan sena saxa mataa a tapalan a kam lana uma. ");
INSERT INTO leu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","La maana vung a mataa aave i taxa matef e la paanaas nane i taxa lo ti sangas. A kam aave, a boak e femolava malaafaa? Nane pife texaas. ");
INSERT INTO leu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","A xavala sang mon a fapalak a mo lana uma. Paamua a paxana a savat e mui a putuna a savat e lumui a xalana a savat molava la putuna o la unguna. ");
INSERT INTO leu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","E lumui layaan a xalana fo matoxol a mataa aanabeꞌ a faisok e murule. Naboxo a yaan ina faxuvulaana fanganan a savat.” ");
INSERT INTO leu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na Yesus a sei nari, “Netaara taa kuusan famatavas a fatataganan sina Piran malaafaa talo mi taa masame? E taara taa ferawai paap malaafaa xena xalie? ");
INSERT INTO leu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nane a malaan sena saxa wai taara xalie pana mastaat. A kam ina pife malaan sena kam ina saxano wai o fanganan ti la uma, piau! A kam ina mastaat a modak paaliu. ");
INSERT INTO leu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tamo mataa i taa xapise e lumui a molava, nane a peraroxo sena xasano fanganan lana uma. A raxan ina a molava e mu maanu ri maa nai xuluna senaso a lana marafut.” ");
INSERT INTO leu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Na Yesus a ferawai xe sina rabuna pana mu ferawaian paap malaan fexaxaas sena lalamonan siri. ");
INSERT INTO leu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nane pife kuusan famatavas a malasuf ina ferawaian sina xe siri, piau! Nane ferawai pana mu ferawaian paap mon. E layaan a mu fefeng sang mon ri taxa waan xuvul pana, lavaxa nane kuusan xapin a fufuna maana ferawaian paap. ");
INSERT INTO leu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","E leaaf lana yaan naang xo, nane xuus a mu fefeng sina malaan, “Taara taa falet xe la paxasing ina laman.” ");
INSERT INTO leu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ri paan tapin a mu rabuna e ri xawas xuluna xaati aava na Yesus taxa waan xuluna e ri falet xuvul pana. E saxano xaati ri falet xuvul pari sait. ");
INSERT INTO leu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","E a reref molava a tamasiak e a tof a laak lana xaati e fataapus a xaati febas pana raarum. ");
INSERT INTO leu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Taasaxa na Yesus si, taxa mati matef pe xuluna xaati. E ri xel fapungane e ri xuuse, “Rao taara xarak naboxo, naak no pife lamon semaam.” ");
INSERT INTO leu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","E na Yesus moxo, a tamasiak e farawei a reref e taas, a kuus malaan, “Fo taxapus xong!” E fataapus a reref a taxapus e taas a luai fulaa. ");
INSERT INTO leu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","E na Yesus a sei a mu fefeng, “Xenaso mi taxa mataut malaan? E xenaso mi piau ta namkaian tuuna?” ");
INSERT INTO leu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","E ri femataut paaliu e ri fefiaian nari xa malaan, “A mataa aanabeꞌ ve naseꞌ? A reref e taas re langaie!” ");
INSERT INTO leu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","E ri savat la saxa paxasing ina laman, la bina sina mu Gerasa. ");
INSERT INTO leu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na Yesus a du ti lana xaati e fataapus a saxa mataa aava toxan a vovau saat a savat sina. A mataa aanabeꞌ fuuna taagul vulai la matana xawaa. ");
INSERT INTO leu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nane fuuna matef la matana xawaa e pi ta mataa a fexaxaas i taa pise. A ‘sein’ sait pife fexaxaas sena pisaana. ");
INSERT INTO leu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Faaxaxaves ri pis a mana e kana pana ‘sein’ taasaxa fuuna piit a ‘sein’ o saxano mo ri pis fatateaxe pana. A gutan sina a molava faagut e piau ta mataa fexaxaas sena yot fatateaxe. ");
INSERT INTO leu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Vulai la paanaas e lavung, nane fuuna taagul la matana xawaa e xuluna put e fuuna faati kuup e i taxa putuk vulan a tana pana fisa o pana faat. ");
INSERT INTO leu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nane xalum na Yesus i taxa sangasmaan lasuun e falapuk e fe bukaak la no Yesus. ");
INSERT INTO leu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nane ferawai faagut malaan, “Yesus, nano, no Natuna Piran Laaꞌui! No vubuk vil a so sega? Ne fenung xe siim pana isina Piran, no muta tavaiau pana maasaxan!” ");
INSERT INTO leu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A ferawai malaan senaso na Yesus a xuuse, “Nano, no vovau saat, no taꞌulan a mataa aanabeꞌ!” ");
INSERT INTO leu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","E na Yesus a fin a vovau saat aava vao a mataa aanabeꞌ, “A isaam naseꞌ?” E a vovau saat a sui a fiaian sina, “Na Aami, senaso nemaam, ma malila.” ");
INSERT INTO leu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","E nane nung faagutan na Yesus o i taa muta feng tapin nari, mu vovau saat, xe la xasano bina patak. ");
INSERT INTO leu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Faasilak seri a tagaan ina vio xaves ri taxa fangan xuluna fomirak put. ");
INSERT INTO leu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","E a mu vovau saat ri fenung faagut xe si Yesus malaan, “A fexaxaas no taa feng nemaam xe sina mu vio aapave?” ");
INSERT INTO leu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","E na Yesus a turoxo xe siri rao ri taa falet saa. E mu vovau saat ri taꞌulan a mataa aave e ri paan xe sina mu vio. A mu vio aanabeꞌ moxo, ri fefalayai saa xe la talasaafan sina bina. A mu vio ri fexaxaas malaan sena 2,000! Ri lalaas du xe lana raarum e nari xapiak ri xarak e ri maat. ");
INSERT INTO leu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","A mu rabuna ina faxatangaana mu vio ri sinuf e ri fe lisan a lagasai lana bina lava faasilak e lana mu bina xapiak. E maana rabuna ri paan xe pave xena xalumaana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ri fesavat si Yesus e ri xalum a mataa aava mu vovau saat ri mo vawe e ri taagul xuvul pana. Naboxo i taxa falak a marapi e a lalamonan sina a matavas e i taxa nai faroxo. E a mu rabuna ri xalume e ri mataut. ");
INSERT INTO leu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","A rabuna ina faxatangaana mu vio, ri xuus a xasano rabuna pana mo aava fo savat sena mataa aava mu vovau saat mo waan la tana paamua. E ri kuusan a mu vio siri sait. ");
INSERT INTO leu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","A mu rabuna, ri kuus faagut rao na Yesus i taa taꞌulan a bina siri e i taa paan xe la saxa nobina patak. ");
INSERT INTO leu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Layaan na Yesus i taxa xawas fulaa xuluna xaati a mataa aava vovau saat mo waan la tana, a fin na Yesus rao i taa falet xuvul pana. ");
INSERT INTO leu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Taasaxa na Yesus a pife kuus turoxo pana, a xuuse, “No paan saa xe la lifu siim e xe sina mu fesing siim. E no xuus nari pana maana mo a Memai fo vile sema e malaafaa a muluk nano.” ");
INSERT INTO leu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Lavaxa, a mataa aanabeꞌ a falet e taxa kuusan fasavat a mo na Yesus fo vesane sena la maana mu bina pe Dekaapolis. E mu rabuna, ri ipul faagut pana e ri lamon faaxaves sena. ");
INSERT INTO leu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na Yesus a ulaa fulaa xe pe la saxa paxasing ina Laman Galili. E a malila ri savat xe sina pe la vangana raarum. ");
INSERT INTO leu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","E saxa matalava ti la lifu ina faxavulan a savat, a isina na Jairus. Nane xalum na Yesus e filimaan e maa bukaak faasilak la ka Yesus. ");
INSERT INTO leu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","E nane fenung faagut xe si Yesus malaan, “A lak tefin siak faasilak rao i maat. Ne vubuk o no taa falet e no taa tao a tana talo i taa roxo fulaa.” ");
INSERT INTO leu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Na Yesus a falet xuvul pana e a malila ri usie e ri ivung faasilak paaliu lamina. ");
INSERT INTO leu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","A saxa tefin la palou ina malila aanabeꞌ, nane a xaxalum a fulun vulai la maana yaan. Nane fo toxan a giisan aanabeꞌ pana mariaas sangafilu saxa pana taragua. ");
INSERT INTO leu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","E mu rabuna iꞌirin ri famasaxe pana maana buk irin xaves e a tefin a maraan nari pana tangop xapiak sina taasaxa giisan sina pife taxapus famodak, piau paaliu! ");
INSERT INTO leu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","A tefin aanabeꞌ a langai sena faisok si Yesus e nane fe laak la palou ina rabuna aava ri taxa usi na Yesus e nane sangas faasilak lumui la mi Yesus e a tao a marapi sina. ");
INSERT INTO leu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Senaso a ilisai malaan, “Naak tamo ne taa tao a marapi sina mon ne taa roxo faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lavaxa, nane vil malaane e fataapus paaliu a ria la tana a pagala e nane nasam a giisan ti la tana fo taxapus paaliu. ");
INSERT INTO leu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","E na Yesus a texaas o saxano gutan fo falet, e voxo nane ti tapuk e fiai, “Naseꞌ tao a marapi siak?” ");
INSERT INTO leu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","E a mu fefeng si Yesus ri sui a fiaian sina malaan, “Ai, no xalum a malila ri taxa pitai xolai la taam e xenaso no fiai malaan: naseꞌ tao a marapi la taam?” ");
INSERT INTO leu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Na Yesus a kaalum xolai e a vubuk texaas o naseꞌ fo tao a marapi sina. ");
INSERT INTO leu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Taasaxa, a tefin aave nane texaas o nane fo vil a mo aanabeꞌ e a mataut e radakui faagut. E nane falet e fe bukaak la ka Yesus e kuusan xapin a maana mo nane fo vile. ");
INSERT INTO leu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","E na Yesus a xuuse, “Lak siak, a namkaian siim fo vil faroxoi nano. No taa falet e a xunus ima i taa malui, a giisan siim fo taxapus!” ");
INSERT INTO leu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Na Yesus i taxa ferawai lunai e saxanu sisiak sina matalava ina lifu ina faxavulan aave ri savat e ri xuus a matalava, “A lak siim fo maat xong, xenaso no taxa lo fasorak a mataa ina fepitaa aanabeꞌ?” ");
INSERT INTO leu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Taasaxa na Yesus fo texaas sena so ta mo ri kuusane. Nane a xuus a matalava ina lifu ina faxuvulan malaanabeꞌ, “No muta mataut naboxo. No taa namkai mon.” ");
INSERT INTO leu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E na Yesus a ti votan a xasano rabuna ri taa pife paan xuvul pare. Na Saimon Pita, Jems e na Jon a saxa ti Jems, narutul sang mon rutul usi na Yesus. ");
INSERT INTO leu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","E ri fe savat la lifu sina matalava aave e na Yesus a xalum nari pave, ri taxa felingai faagut senaso ri taxa fetaangiis. ");
INSERT INTO leu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","E na Yesus a laak la lifu e fin nari, “Senasou mi felingai faagut pana taangiisan simi? A lak aanabeꞌ pife maat paaliu. Nane taxa matef move.” ");
INSERT INTO leu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","E mu rabuna ri fenangon xuluna. Taasaxa nane feng tapin nari xe lamalei. E nane xel mon a tamana lak e ninana o re taa laak xuvul pana e a fefeng talatul sina. E ri laak xe la nobina aava lak taxa mati lana. ");
INSERT INTO leu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","E na Yesus a tao a mana lak e xuuse malaan, “Talita Kum!” A malasuf ina paferawaian aanabeꞌ a malaan, “Lak tefin, ne xuus nano, no tamasiak!” ");
INSERT INTO leu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","E fataapus a lak tefin aanabeꞌ a tamasiak e sangas. A mariaas sina lak a sangafilu saxa pana taragua. E na ninana e tamana e fefeng talatul sina ri ipul faagut paaliu sena gutan si Yesus. ");
INSERT INTO leu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","E na Yesus a xuus faagutan nare o re muta xuus ta saxa mataa pana mo aanabeꞌ. E nane xuus nare sait o re taa tavai a lak pana fanganan. ");
INSERT INTO leu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E nane taꞌulan a bina aapave e falet xe Nasaret, a bina sina e mu fefeng sina ri usie. ");
INSERT INTO leu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Layaan a Yaan ina Fangaafusan a savat, nane laak lana lifu ina faxuvulan e i taxa fapiti a mu rabuna pave e ri ipul sena e ri kuus, “A siak a texaasan sina ti faa? A so ta masaman nabeꞌ? Nane naseꞌ e a toxan a gutan molava xena vilaana maana mo faꞌipul malaan? ");
INSERT INTO leu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nane a mataa ina faisok mon, bo? A lak si Maria? A mu tina va na Jems, Yosep, Juut e na Simon, ri taxa waan xuvul pataara, bo? E mu vasaana sait, a sou ri pife waan la palou itaara?” E voxo ri marala pana. ");
INSERT INTO leu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","E na Yesus a xuus nari, “A rabuna ti lasuun ri taa suaian a mataa aava i taxa xuus nari pana ferawaian sina Piran. Taasaxa rabuna ti la bina sina e mu tauna sait, ri taa pife suaiane.” ");
INSERT INTO leu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E nane fexaxaas sena tao faroxoiaana saxanu rabuna mon, pife xaves. A mu rabuna ti Nasaret, ri langai pesalai sina e nane pife fexaxaas sena vil a mo ina gutan pave. ");
INSERT INTO leu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nane ipul senaso a rabuna pave ri pife toxan a namkaian e voxo nane falet xe la xasano bina patak xena fepitaa. ");
INSERT INTO leu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","E nane xel faxuvul a mu yaamut sangafilu saxa pana taragua e feng nari o ri taa falet taragua pa taragua. E nane tavai nari pana gutan xena gei tapin a mu vovau saat. ");
INSERT INTO leu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","E nane xuus fatexaas nari o ri muta siak ta fanganan, bi o faat xena sangasan siri. Ri taa siak a wai ina xipa sang mon. ");
INSERT INTO leu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","E a fexaxaas ri taa siak a ‘slipa’ siri taasaxa piau ta xuxulan taragua. ");
INSERT INTO leu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","E nane xuus nari sait, “Layaan a saxa mataa i taa tavai name pana nobina xena taagul, me taa taagul pave fefexaxaas sena yaan me taa falet xe la xasano bina fulaa. ");
INSERT INTO leu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","E tamo mu rabuna ti la saxano bina ri taa pife suaian name o taa langai pesalai seme, me taa taꞌulan a bina aave e layaan me taa falet me taa saf tapin a pof ti xuluna kame. Senaso a pof aave i taa fakalimaan o vilaana saat siri taxa waan lunai.” ");
INSERT INTO leu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","E nari xapiak ri falet e ri fasei a mu rabuna o ri taa puk a xunus iri e taꞌulan a vilaana saat siri. ");
INSERT INTO leu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","E a mu yaamut ri gei tapin a mu vovau saat sina malila e ri noxol a rabuna aava ri giis e ri savat faroxo fulaa. ");
INSERT INTO leu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na King Herot a langai sena faisok si Yesus senaso a saxanu tuvaat ri kuusan malaane, “Na Jon ina Fasufan fo to faꞌulaa. A savat fulaa ti la mamaat e voxo a gutan ina vesanaana maana mo faꞌipul taxa waan sina!” ");
INSERT INTO leu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","E xasano rabuna taxa kuus malaan: “Na Ilaija xo!” E xasanofuna ri kuus, “Piau, a saxa mataa ina kuus fatuxai xo! Malaan sena mu rabuna ina kuus fatuxai ti kavai!” ");
INSERT INTO leu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Taasaxa layaan na Herot a langai pana faisok si Yesus nane taxa lo kuus, “Na Jon xo! Ne fo patal tapin a putuna taasaxa to faꞌulaa ti la mamaat.” ");
INSERT INTO leu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Senaso paamua na Herot a feng a rawen sina e ri fo pis na Jon. Nane a vil malaane senaso na naasana, na Herodias, a toxan a marala se Jon. Paamua na Herodias a tefin si Filip, a ti Herot. ");
INSERT INTO leu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","E na Jon fo xuus na Herot, “Ai, no taxa vil a vilaana saat ve. Pife roxo no taa tamai si naasa tiam.” Senaso na Filip taxa to lunai. ");
INSERT INTO leu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","E na Herodias a xaiyaasaan na Jon e nane vubuk rao i taa punuxe taasaxa nane pife fexaxaas ");
INSERT INTO leu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","senaso na Herot a mataut se Jon. Nane texaas o na Jon a mataa roxo e a mataa sina Piran e voxo nane tao fatateaxe lana vipis e vaxa na Herot a vubuk langai a ferawaian sina, taasaxa saxano ferawaian sina nane vungut sena malasuf ina. ");
INSERT INTO leu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","E saxa yaan a savat, a yaan lava si Herot, a yaan ina luluuxan sina. E na Herot a vil a fenamo xana mu matalava sina: mu rabuna fefasaa, mu rabuna ina paamuian a mu rawen e mu matalava ti Galili, nari xapiak, ri savat. ");
INSERT INTO leu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","E a lak tefin si Herodias a filimaan e taxa tia la matana rabuna e ri nanam temasaat pana tian sina. E na Herot a xuuse, “Finau pana a so ta vubuxanan siim e nenia, ne taa tavai nano pana!” ");
INSERT INTO leu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","E na Herot a kuus fakalimaan, “A so ta mo no taa nungau pana fexaxaas sena xavil molava ina xavala siak, ne taa tavai nano pana!” ");
INSERT INTO leu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","E a lak tefin si Herodias a falet e fin na ninana, “Ne taa nung na Herot panaso?” E na Herodias a xuuse, “Fiai pana putu Jon, a mataa ina fasufan.” ");
INSERT INTO leu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","E a lak tefin a fala xe si Herot e nunge malaan, “Ne vubuk o no taa tavaiau, monabeꞌ mon, pana putu Jon, a mataa ina fasufan. Lisanmaane lana ‘plet’.” ");
INSERT INTO leu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na Herot a mimilisaat paaliu pana fiaian sina lak taasaxa nane fo fakalimaan o i taa vil a vubuxanan sina e a mu rabuna si Herot sait, ri fo langai a ferawaian sina e voxo nane kuus turoxo pana. ");
INSERT INTO leu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","E fataapus na Herot a feng a mataa i taa fe patal tapin a putu Jon e i taa lisanmaane. E voxo a mataa a falet e fe punuxe lana lifu ina vipisan ");
INSERT INTO leu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","e lisan a putu Jon lana ‘plet’ e tavai a lak tefin pana. Mui a lak tefin a tavai na ninana, na Herodias, pana. ");
INSERT INTO leu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Layaan a mu fefeng si Jon ri langai sena, ri falet xe si Herot xena siak a vipin si Jon. Ri siaxe e ri fe xaafane lana liing. ");
INSERT INTO leu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","E a mu yaamut aava na Yesus a feng nari taragua pa taragua, ri maa savat faꞌulaa si Yesus e ri kuusan a maana mo ri fo vile e a maana mo ri fo fepitaa pana. ");
INSERT INTO leu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","E nane a xuus nari, “Filimaan xuvul paga xe la bina vingil xena maagus famodak.” Nane kuus malaan senaso a malila ri taxa lo savat vulai e a mu yaamut ri piau ta yaan ina fanganan e maagusan. ");
INSERT INTO leu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","E voxo nari xapiak, ri xawas xuluna xaati e ri falet xe la xasa bina xobingil. ");
INSERT INTO leu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Taasaxa saxano rabuna ri xalum taraxali nari xuluna xaati e voxo a malila ti la maana nu bina pave ri fala paamuin nari e ri fe savat paamua seri. ");
INSERT INTO leu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Layaan na Yesus a ung nane xalum a tang malila aanabeꞌ e a vilauna a muluk nari senaso ri piau ta mataa xena paamuianaan nari. Ri taxa milung malaan sena sipsip aava piau ta mataa xena faxatangaan nari. E voxo nane fapiti nari fulaa pana maana mo xaves. ");
INSERT INTO leu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","E faasilak naboxo a ngaas taa rul e a mu fefeng sina ri xuuse, “Ai, a bina aanabeꞌ ve a vingil e faasilak i taa suk, ");
INSERT INTO leu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","feng tapin et nari talo ri taa paan saa xe la saxano bina aava toxai fanganan xena mamareiai.” ");
INSERT INTO leu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Taasaxa nane sui a mu fefeng sina e kuus, “Nami, mi taa tavai nari pana fanganan.” E ri fine, “Bo? A mataa taa faisok pana fulun pisiktul xena faxuvul a faat fexaxaas sena maraan a bret xari. Taara taa fe tapin a faat malaan xena maraan bret a fexaxaas sena malila aanabeꞌ?” ");
INSERT INTO leu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","E nane xuus nari, “Fe kaalum, mi toxan a bret talavisan taxa waan?” E ri fe fakate e ri suie, “A bret pama e fomirak din taragua taxa waan.” ");
INSERT INTO leu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na Yesus a xuus a malila o ri taa nai faxuvul lapia. ");
INSERT INTO leu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","E voxo ri nai lana maana xoxovulaian. ");
INSERT INTO leu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","E nane siak a bret pama e din taragua e nane kaalum xe laaꞌui la xunavata e fenung pana fanganan. Nane viak a bret e taxa lo tavai a mu fefeng pana xena fepatoxanaana xe sina rabuna. E a viak tavai nari pana ro din sait. ");
INSERT INTO leu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","A maana mu rabuna xapiak, ri fangan e ri maasi. ");
INSERT INTO leu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","E mu fefeng ri tifi a bi sangafilu saxa pana taragua pana xavil ina fanganan. ");
INSERT INTO leu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","E a rabuna tomexaan aava ri fangan a fexaxaas sena 5,000. ");
INSERT INTO leu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","E fataapus na Yesus a faxawas a mu fefeng xuluna xaati e feng nari xe la paxasing ina Laman Galili, xe la saxa bina Betsaida. La yaan aave, nane sang mon a feng faꞌuli a rabuna. ");
INSERT INTO leu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Layaan a mu rabuna fo falet nane laak xe xuluna put xena fenung xe sina Piran. ");
INSERT INTO leu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","A bina xo suk e a mu fefeng aave ri taxa falet xuluna xaati la palou ina Laman Galili. E na Yesus ve, i taxa waan pe xuluna put. ");
INSERT INTO leu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","E nane xalum nari, ri taxa xaul faagut pana fos senaso a reref a fiit faagut. La xunavung nane filimaan faasilak la tari e taxa sangas xuluna laman e rao i taa paaliu nari. ");
INSERT INTO leu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Taasaxa ri xalume taxa sangas xuluna laman e ri kuup faagut senaso ri lamon o a rongan. ");
INSERT INTO leu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nari xapiak ri xalume e ri mataut. E fataapus nane ferawai xe siri, a kuus malaan, “Muta mataut; nenia move.” ");
INSERT INTO leu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","E nane xawas xuluna xaati siri e a reref a taxapus. E nari, ri ipul paaliu sena gutan sina. ");
INSERT INTO leu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ri fo mo xalum a faisok sina pana viak tavaiaana malila pana fanganan taasaxa ri pife lamon faroxo sena. ");
INSERT INTO leu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","E nari, ri falet xuluna xaati xe la bina Genasaret e ri ung e pis fatateak a xaati pave. ");
INSERT INTO leu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Layaan a mu rabuna ri xalum taraxali na Yesus ");
INSERT INTO leu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ri falet xe la maana nu bina faasilak e ri fe xuus a mu rabuna e ri xelmaan nari aava ri giis xe si Yesus. ");
INSERT INTO leu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","E la maana yaan layaan nane savat la saxa bina, modak o molava, a mu rabuna pave ri fuuna xel faxuvul a mu rabuna pana giisan xe la bina ina faasot e ri fe nung na Yesus rao a rabuna giis ri taa tao mon a marapi sina. E naseꞌ ta mataa i taa tawe a giisan sina i taa taxapus e i taa roxo fulaa. ");
INSERT INTO leu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","E saxa nutuvaat Ferasi e saxano mataa aava ri fepitaa pana vuputkai si Moses, ri filimaan ti Jerusalem e ri maa savat si Yesus. ");
INSERT INTO leu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","E ri xalum a saxano fefeng si Yesus ri taxa fangan pana mari vusiit senaso ri pife xamak a mari paamuina fanganan. ");
INSERT INTO leu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","A mu Ferasi e maana xasano Juda ri taa pife fangan tamo a raarum xena xamaxaana mari pife waan. A mu buri ti kavai ri fapiti nari o layaan ri pife xamak a mari a lalosaat taa waan la toyan siri e voxo ri taxa usi a vilaana malaan. ");
INSERT INTO leu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","E layaan ri filimaan ti la bina ina maraan fanganan ri pife fexaxaas sena fangan tamo ri pife xamak a mari. E maana vilaana aava ri langaie sina mu buri, ri faxaꞌusie, malaan sena gonaana ‘kaap’ e xamaxaana mu ‘dis’ o ‘sospen’ siri. ");
INSERT INTO leu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","E a mu Ferasi aave ri maa savat si Yesus e ri fine, “Senasou a mu fefeng siim ri pife usi a vilaana ti kavai e ri taxa lo fangan pana mari aava vusiit?” ");
INSERT INTO leu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","E na Yesus a sui a fiaian siri, “A tuuna paaliu ne xuus nami, na Aisaia fo xalei a maana bitan sina mu butaara e nami vaxa mi mu rabuna ina bitan malaan seri. Na Aisaia a xalei a ferawaian sina Piran malaan: ‘A rabuna aanabeꞌ ri suai sega pana ferawaian siri taasaxa lamonan siri a patak paaliu. ");
INSERT INTO leu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","A tuuna, ri fenung taasaxa ri fenungmaat. Ri taxa fepitaa pana vilaana sina mataa mon, ri pife usi a lalamonan siak.” ");
INSERT INTO leu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Na Yesus a sei nari, “Nami, mi langai pesalai sena ferawaian tateak sina Piran e mi usi a vilaana sina rabuna mon!” ");
INSERT INTO leu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","E nane kuus fulaa, “Mi texaas faagut tuuna pana vilaana ina vil tapin a ferawaian sina Piran xena usi a lalamonan simi. ");
INSERT INTO leu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Na Moses a kuus malaanabeꞌ, ‘Suai se tamaam e ninaam’ e fulaa, ‘Naseꞌ ta mataa i taa kuus fasaat se ninana o tamana, lavaxa a mataa aave a mu rabuna ri taa soxoi punuxe pana faat.’ ");
INSERT INTO leu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Taasaxa nami, mi kuus malaan, ‘Tamo ta mataa taa xuus na ninana o tamana malaan “Ai, a maana mo siak ne fo tavai a Piran pana, ne pife fexaxaas xena xavang name. A maana mo xapiak siak a koban.” (A malasuf ina vapaling ‘koban’ a malaan: a maana mo ri fo faatataap pana.) ");
INSERT INTO leu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","E nami, mi ti votan a mataa aava kuus malaan: nane taxa rawetan na ninana o tamana. ");
INSERT INTO leu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","E voxo mi vil tapin a ferawaian tateak sina Piran e mi usi a lalamonan simi e vilaana sina rabuna ti kavai. E a buk vilaana saat malaanabeꞌ a pife saxa mon!” ");
INSERT INTO leu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","E na Yesus a xel a mu rabuna e nane xuus nari, “Mi langaiau! Langai nabeꞌ e mi taa masam! ");
INSERT INTO leu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Piau ta mo i taa laak lana mataa i taa vil falalosaate, piau! Taasaxa maana mo a mataa taa vile, a maana mo aanabeꞌ ri falalosaat a mataa. ");
INSERT INTO leu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Langaiau e lamon pana ferawaian siak!” ");
INSERT INTO leu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Layaan na Yesus a taꞌulan a mu rabuna nane laak lana lifu e mu fefeng ri fine pana ferawaian paap sina. ");
INSERT INTO leu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","E nane xuus nari, “Nami sait, mi vungut sena malasuf ina ferawaian aanabeꞌ? Nami, mi pife masam o a mo aava i taa laak la valana mataa, tamo i taa ngane, a pife fexaxaas sena vil falalosaat a mataa. ");
INSERT INTO leu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Senaso a mo aava nane taa ngane, a sivi la vilau ina e nane taa pesane.” (Pana ferawaian aanabeꞌ na Yesus a vil tapin a faati votaian xuluna saxano fanganan aava mu Juda ri pife fexaxaas sena ngane.) ");
INSERT INTO leu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","E nane kuus fulaa, “A mo aava i taa savatmaan ti la lamonan sina mataa ve, i taa kawaasan a naian sina. ");
INSERT INTO leu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Senaso ti lana mataa, ti lana lalamonan sina e lana xunus ina a vilaana saat a sasavat. A vilaana saat malaan sena fenauan, paruxan, punuk mataa, siaxan a tefin sina xasa mataa, ");
INSERT INTO leu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","naixaaman, saatan e fasaamaatan, piilaana saxa mataa, lamon falavaiaan nano e pife kuus fati a isina Piran. ");
INSERT INTO leu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","A maana mo malaan a savat ti lana mataa e kawaasan a vilaana sina.” ");
INSERT INTO leu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Na Yesus a tamasiak xuvul pana mu fefeng sina e ri falet xe kol lana nu bina faasilak Tair. Layaan ri laak lana lifu pave nane baian a mu rabuna taa texaas o nane taxa waan. Taasaxa nane pife fexaxaas sena fufunai. ");
INSERT INTO leu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Saxa tefin a langai sena e fataapus a filimaan e maa bukaak la no Yesus senaso a lak tefin sina a toxan a vovau saat. ");
INSERT INTO leu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","E a tefin aave a pife Juda, a fufubina sina pe Fonisia pe Siria. E nane xo taxa lo fin na Yesus pana vil faroxoiaana lak tefin sina. ");
INSERT INTO leu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","E na Yesus a xuus nane pana ferawaian paap, “Maam pife siak a fanganan sina mu rafulak e tavai a mu piu pana. A roxo sena mu rafulak taa fangan maasi paamua.” ");
INSERT INTO leu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Taasaxa a tefin a sui a ferawaian sina malaan, “Ai, Matalava, no kuus tuuna taasaxa layaan a rafulak ri taxa fangan, a mu piu aave ri taxa waan faasilak e ri piak a xavil ina fanganan i taxa lo poxo.” ");
INSERT INTO leu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","E na Yesus a xuuse, “Tefin no sui faroxoi a ferawaian siak e voxo a fenungan siim fo fexaxaas. A lak siim fo roxo fulaa xo. A vovau saat fo taꞌulane.” ");
INSERT INTO leu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","E a tefin a ulaa fataapus xe la lifu sina e tingin a lak tefin sina i taxa mati xuluna ivin e a vovau saat fo paan sena. ");
INSERT INTO leu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","E mui na Yesus e mu fefeng sina, ri sivi xe puaa la saxa bina Saidan e ri falet ulaa xe la Laman Galili, xe la mu bina Dekaapolis. ");
INSERT INTO leu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","E saxano rabuna, ri lisan a saxa mataa aava vaang xe sina. A mataa vaang aanabeꞌ pife fexaxaas sena ferawai faroxo sait. E ri fenung xe si Yesus rao i taa timin a mana xuluna putuna talo i taa roxo. ");
INSERT INTO leu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na Yesus a sangas tapin a malila xuvul pana mataa vaang. E nane timin a vipirigum ina mana la tangana mataa aave. E na Yesus a kaanus xe la mana e tao a xalemana mataa pana. ");
INSERT INTO leu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","E nane kaalum xe laaꞌui la xunavata e maagus e kuus, “Efefaata!” (A malasuf ina: talakas) ");
INSERT INTO leu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A tangana mataa a matavas e xalemana pife pasak fulaa. E a mataa aanabeꞌ a fexaxaas sena ferawai faroxo. ");
INSERT INTO leu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na Yesus a ferawai faagut xe siri xapiak o ri taa muneta xuus fatexaas a mu rabuna pana. Taasaxa la maana yaan nane taxa lo xuus votan nari, ri taxa lo kuusan fasavat a faisok sina. ");
INSERT INTO leu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","E a mu rabuna aava ri langai sena, ri ipul paaliu e ri kuus malaan, “A mataa aanabeꞌ a vil faroxoi a maana faisok xapiak sina. Nane fexaxaas xena fatalakasaana tangana mataa e vil faferawai a mataa po.” ");
INSERT INTO leu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","La saxa yaan fulaa a malila ri savat xe si Yesus e ri piau ta fanganan. E voxo nane xel a mu fefeng sina e a xuus nari malaan, ");
INSERT INTO leu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ne muluk a malila aanabeꞌ senaso ri fo waan xuvul paga pana yaan talatul e naboxo ri piau ta fanganan. ");
INSERT INTO leu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tamo ne taa feng faꞌuli nari xe la mu lifu siri ri taa giis pana lagaian senaso saxano rabuna ri filimaan ti lasuun paaliu.” ");
INSERT INTO leu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A mu fefeng sina ri fine malaan, “A bina aanabeꞌ a bina vingil. Maam taa maraan a bret faa xena famasiaana malila aanabeꞌ?” ");
INSERT INTO leu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","E nane fin nari, “Mi toxan a bret talavisan?” E ri xuuse, “A pisiguak.” ");
INSERT INTO leu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nane xuus a malila o ri taa nai lapia. E nane siak a bret pisiguak e fenung xe laaꞌui pana e viaxe. E mui a lisane xe sina mu fefeng sina xena tavaiaana malila pana. ");
INSERT INTO leu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ri toxan a xasanu miraxan a din sait e na Yesus a fenung pana nu din e mui a xuus a mu fefeng rao ri taa tavai a mu rabuna pana sait. ");
INSERT INTO leu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","E a malila ri fangan e ri maasi. Lamina fanganan a toxan a fanganan a soliu taxa waan e voxo a mu fefeng ri tifi a bi molava pisiguak pana mu xavil ina. ");
INSERT INTO leu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","E a malila aava ri fo fangan ri fexaxaas sena 4,000. E na Yesus a feng faꞌuli nari. ");
INSERT INTO leu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","E nane xawas xuluna xaati fulaa xuvul pana mu fefeng sina e ri falet xe la nobina Dalmanuta. ");
INSERT INTO leu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","E saxano Ferasi ri savat xena fepialai xuvul pana senaso ri vubuk rao i taa faꞌipul nari pana saxano vilaana xena fakalimaan a gutan sina Piran. Ri fo filimaan xena tafangaana. ");
INSERT INTO leu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","E nane a maagus faagut la vilau ina e kuus malaan, “Xenaso a mu rabuna malaan seꞌ mi vubuk seng a fakalimaanan? Ne kuus tuuna paaliu o piau ta fakalimaanan i taa savat xe simi.” ");
INSERT INTO leu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","E nane taꞌulan nari e xawas xuluna xaati e ri fe paan fulaa xe la saxa paxasing ina Laman Galili. ");
INSERT INTO leu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","E a mu fefeng lana xaati xo, ri lamamaaluf paaliu pana maraan bret. Ri toxan a bret saxa mon lana xaati. ");
INSERT INTO leu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","E na Yesus a xuus nari, “Mi taa faxatang faroxo pana yiis sina mu Ferasi e sina nutuvaat si Herot.” ");
INSERT INTO leu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","E nari, ri fefiai la palou iri o ri piau ta bret. ");
INSERT INTO leu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","E na Yesus a texaas sena ferawaian siri e nane fin nari, “Xenaso mi ferawai o mi piau ta bret? Mi piau paaliu ta texaasan e piau paaliu ta masaman lunai? A lalamonan simi a vungut paaliu sait malaan sena mu Ferasi? ");
INSERT INTO leu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A saxa mataa ina kuus fatuxai ti kavai fo kuus malaan: ‘Mi toxan a mata taasaxa mi pife xakaalum! Mi toxan a tanga taasaxa mi pife langai!’ Mi fo lamamaaluf? ");
INSERT INTO leu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Layaan ne viak a bret pama xana rabuna 5,000, mi tifi a maana xavil lana bi talavisan?” E ri xuuse, “A bi sangafilu saxa pana taragua!” ");
INSERT INTO leu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“E layaan ne viak a bret pisiguak xana rabuna 4,000 mi faxuvule e mi tifi a bi molava talavisan?” E ri xuuse, “A pisiguak.” ");
INSERT INTO leu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","E nane fin nari fulaa, “E vaxa mi taxa lo vungut lunai, bo?” ");
INSERT INTO leu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","E ri falet e ri ung la saxa bina, a isina na Betsaida. E mu rabuna pave, ri maa lisan a saxa mataa piif xe si Yesus e ri fenung xe sina rao i taa vil faroxoie. ");
INSERT INTO leu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nane tao a mana mataa piif e re falet lasuun famodak sena bina. Nane kaanus xe la matana mataa piif e tao a putuna e fine, “No xalum ta mo vaxa? A so ta mo no xalume?” ");
INSERT INTO leu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","E a mataa a kaalum xolai e sui a fiaian sina, “Ne xalum a rabuna taasaxa ri kaalum malaan sena mu wai aava taxa sangas xolai.” ");
INSERT INTO leu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","E na Yesus a tao a matana fulaa e a mataa fexaxaas sena kaalum faroxo. A xakaaluman sina a roxo fulaa e matavas xe lasuun paaliu sait. ");
INSERT INTO leu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","E na Yesus a feng a mataa aave xe la bina sina e xuuse, “Muta ulaa xe la bina aamove.” ");
INSERT INTO leu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na Yesus e mu fefeng sina ri falet xe la maana nu bina faasilak se Sesaria Filipai. La fena sangasan siri nane fin nari malaan, “A mu rabuna ri lamon malaafaa sega?” ");
INSERT INTO leu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","E ri xuus fatexaas nane, “Saxano rabuna ri kuus o nano, na Jon ina Fasufan aava to fulaa. E xasanofuna ri kuus o nano, na Ilaija e xasanofuna ri kuus o no malaan sena saxa mataa ina kuus fatuxai ti kavai.” ");
INSERT INTO leu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","E nane fin fulan nari, “E nami xa, mi lamon malaafaa sega? Nenia naseꞌ?” E na Pita a sui a fiaian sina malaan, “Nano, no Mataa Failai sina Piran, na Krais!” ");
INSERT INTO leu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","E na Yesus a pebukan nari o ri muneta kuus famatavas pana isina lunai. ");
INSERT INTO leu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","E nane tangpat pana fapiti nari o a Natuna Mataa taa yaas a maana maasaxan: a mu rabuna taa bilai fasaat xe sina e mu paamua sina mu Juda e mu matalava siri ri taa gigirane e ri taa punuxe. Taasaxa lamina yaan talatul i taa tamasiak fulaa ti la maatan. ");
INSERT INTO leu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","E nane xuus famatavas nari. Taasaxa na Pita a xele xe la xasing e a ferawai xuvul pana, narie sang mon. Na Pita a baian a ferawaian si Yesus e a barase pana. ");
INSERT INTO leu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Taasaxa na Yesus a ti tapuk e xalum a xasano fefeng sina e baras na Pita malaan, “Setan, no paan patak. Pita, a xunus ima pife usi a vilaana sina Piran. A lalamonan siim a malaan sena mataa palau mon!” ");
INSERT INTO leu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","E nane xel faxuvul a malila xuvul pana mu fefeng sina e nane xuus nari, “Naseꞌ ta mataa rao i usiau i taa taꞌulan a maana mo sina e i taa yaas a maasaxan sina e i taa usiau. ");
INSERT INTO leu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Senaso naseꞌ ta mataa rao i tao fatateak a toyan sina, a toyan sina i taa malit. E naseꞌ ta mataa aava i taa punuxan sega o sena Lagasai Roxo sina Piran, a toyan sina i taa waan vulai. ");
INSERT INTO leu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","A so ta roxoyan a mataa i taa toxane tamo nane taa toxan a maana mo xapiak nabeꞌ lapia la xavala e a vovau ina i taa malit? Naak pife roxo malaan! ");
INSERT INTO leu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","A so ta mo nabeꞌ lapia a fexaxaas xena maraan faꞌuli a vovau ina mataa? Piau ta mo fexaxaas sena. ");
INSERT INTO leu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Naseꞌ ta mataa i taa mangil sega o sena ferawaian siak tanin la palou ina mu rabuna xaves aava ri taxa usi a vilaana saat, lavaxa mui a Natuna Piran i taa mangil sena layaan i taa savat pana malang molava sina Piran la palou ina mu angelo.” ");
INSERT INTO leu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","E nane xuus nari, “Ne xuus tuunei nami, saxano rabuna aava ri taxa tigina la palou itaara tanin, ri taa pife maat lunai layaan a fatataganan sina Piran taa savat pana gutan.” ");
INSERT INTO leu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lamina yaan pisaxa na Yesus a xel na Pita, Jems e na Jon. E narutul sang mon rutul fe laak xuvul pana xe laaꞌui xuluna put lava e a xakaaluman ina fepuk la matarutul. ");
INSERT INTO leu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A marapi sina a savat pasak paaliu e a rarapak faagut. Piau ta mataa fexaxaas sena ruk fararapak a marapi malaan. ");
INSERT INTO leu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","E na Ilaija, saxa matalava ina kuus fatuxai ti kavai xuvul pa Moses aava paamua lava sina mu Juda, re savat si Yesus e rutul taxa ferawai. ");
INSERT INTO leu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","E na Pita a xukulai, “Ai Memai, nemaatul taxa waan, a roxo naak maatul taa vesan a sawat talatul xamutul; saxa xaanum, saxa xa Ilaija e saxa xa Moses.” ");
INSERT INTO leu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nane xukulai malaan senaso rutul mataut paaliu e rutul pife texaas o rutul taa kuus panaso. ");
INSERT INTO leu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","E mui a vata a savat xuluri e a ling a ferawai ti lana vata, a kuus malaan, “Nabeꞌ ve a Lak Siak! Mi taa langai sina.” ");
INSERT INTO leu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","E rutul kaalum xolai e piau ta saxa mataa fulaa taxa waan. Na Yesus sang mon taxa tigina. ");
INSERT INTO leu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Layaan ri taxa sivi ti laaꞌui xuluna put nane xuus faagutan narutul o rutul taa pife kuusan xolan a mo rutul fo xalume fefexaxaas sena yaan a Natuna Mataa i taa to faꞌulaa ti la maatan. ");
INSERT INTO leu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","E voxo rutul usi a vubuxanan sina taasaxa la palou irutul, rutul taxa lo ferawai pana malasuf ina ‘to faꞌulaa ti la maatan.’ ");
INSERT INTO leu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","E mui rutul fine pana saxa mo, rutul kuus malaan, “Senasou a rabuna aava ri masam sena xakalayan ti kavai, ri kuus o na Ilaija i taa savat paamuin a Mataa Failai sina Piran?” ");
INSERT INTO leu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","E nane xuus narutul, “Na Ilaija i taa savat paamua xena faigotan a vepen sina Mataa Failai. Taasaxa a xakalayan sena Natuna Mataa a kuus sait o a mu rabuna ri taa vil pengane e ri taa pife suai sena. Mutul lamon malaafaa pana ferawaian aanabeꞌ? ");
INSERT INTO leu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Taasaxa, ne xuus nami na Ilaija fo savat xong e a mu rabuna ri fo bilai fasaat xe sina malaan sena xakalayan ti kavai fo kuus.” (Nane taxa ferawai se Jon ina Fasufan.) ");
INSERT INTO leu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Layaan ri savat fulaa pe sina xasano fefeng, a malila taxa waan fakaliuan nari e saxano rabuna aava ri masam pana vuputkai si Moses ri taxa fetok xuvul pari. ");
INSERT INTO leu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Layaan a malila aave ri xalum na Yesus ri ipul marasaxa e ri fala fataapus xe sina xena fasusuie. ");
INSERT INTO leu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","E nane fin a mu fefeng sina, “Mi taxa fetoxan a so?” ");
INSERT INTO leu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A saxa mataa ti lana malila a sui a fiaian sina, “Mataa ina Fepitaa, ne lisanmaan a lak siak xe siim. A vovau saat a vawe e nane pife fexaxaas sena ferawai. ");
INSERT INTO leu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","E saxano yaan a vovau saat i taa tapine xe lapia e a vuvusen fuuna savat ti la valana e a faxakengat a fana e tana tateak saxa. E ne nung a mu fefeng siim o ri taa vil tapin a vovau saat aave taasaxa ri pife fexaxaas.” ");
INSERT INTO leu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","E na Yesus a xuus a mu rabuna malaan, “Nami xapiak, mi taxa lo vungut lunai! Ne taa taagul xuvul pami pana yaan talavisan? Ne taa fapiti nami malaafaa? Siakmaan a lak xe siak!” ");
INSERT INTO leu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","E ri lisan a lak xe sina e layaan nane xalum na Yesus nane poxo marasaxa xe lapia e radakui faagut e sapul xolai e a vuvusen a savat ti la valana. ");
INSERT INTO leu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","E na Yesus a fin na tamana, “A mariaas talavisan a mo aanabeꞌ taxa lo savat?” E tamana lak a sui a fiaian sina, “A savat la modaxan sina xa. ");
INSERT INTO leu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Faaxaves fo tapin falaxe xe lana fata e xe lana raarum xena punuxe. Tamo no fexaxaas sena xavang nemaam lavaxa, muluk nemaam e no xavang nemaam monaboxo.” ");
INSERT INTO leu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","E na Yesus a xuuse, “Piau, nano fatak no fexaxaas! A mataa pana namkaian tateak a fexaxaas sena vil a maana mo xapiak.” ");
INSERT INTO leu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","E tamana lak a xukulai faagut e kuus malaan, “A namkaian siak i taa tateak tamo no taa xavangau.” ");
INSERT INTO leu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na Yesus a xalum a malila ri taxa faxuvul fataapus maan e nane baras a vovau saat aava vao a lak aave, a kuus malaan, “Nano, no vovau po e vaang, ne xuus nano, no taꞌulan a lak aanabeꞌ e muneta vawe fulaa.” ");
INSERT INTO leu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","E a vovau saat a xukulai faagut e vil faradakui faagutan a lak e a taꞌulane. E a lak xo, a mati malaan sena fo maat. E a rabuna xaves ri kuus o fo maat xo. ");
INSERT INTO leu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Taasaxa na Yesus a siak a mana e yuuf fatigineie e nane tigina faroxo fulaa. ");
INSERT INTO leu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mui layaan na Yesus a laak lana lifu, a mu fefeng ri fine, “Senasou maam pife fexaxaas sena gei tapin a vovau saat aave?” ");
INSERT INTO leu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Nane sui a fiaian siri, “A fenungan sang mon a fexaxaas sena gei tapin a buk vovau saat malaanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","E nari, ri taꞌulan a bina pave e ri sangas xe pe Galili taasaxa na Yesus a baian a malila ri taa usie ");
INSERT INTO leu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","senaso nane vubuk fapiti a mu fefeng sina. Nane xuus nari malaan, “A Natuna Mataa xo, i taa pet lisanan e a rabuna ri taa punuxe e i taa waan la bina ina maatan fefexaxaas sena yaan talatul. Taasaxa lamina yaan talatul i taa to faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","A mu fefeng ri vungut sena fufuna ferawaian sina taasaxa ri mataut sena fine pana. ");
INSERT INTO leu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","E nari, ri savat pe Kapanam e layaan ri laak lana saxa lifu nane fin nari, “A so ta mo mi taxa fegagelai pana la fena sangasan sitaara?” ");
INSERT INTO leu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Taasaxa ri pife sui a fiaian sina senaso ri fo fegagelai o naseꞌ ta fefeng a pelalava la palou iri. ");
INSERT INTO leu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","E nane nai e xel faxuvul a mu yaamut e xuus nari, “Naseꞌ ta mataa rao i paamua, lavaxa i taa fasivi nane e i tafe savat sisiak sina maana xasano rabuna.” ");
INSERT INTO leu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","E nane tao fatiginei a saxa lak la palou iri, a yote e xuus nari, ");
INSERT INTO leu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Naseꞌ ta mataa i taa xavang a lak malaan sena lak aanabeꞌ lana isaak, lavaxa nane taxa xavangau. E naseꞌ ta mataa a vubuxan xasingitau, nane pife vubuxan xasingitau sang mon taasaxa i taxa vubuxan xasingit vaxa a saxa aava fengau.” ");
INSERT INTO leu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","E na Jon, na ti Jems, a xuuse, “Mataa ina Fepitaa, maam xalum a saxa mataa i taxa gei tapin a vovau saat lana isaam e maam pebukane senaso nane pife usi nano xuvul pamaam.” ");
INSERT INTO leu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","E na Yesus a xuus nari, “Muta pebukane. Senaso tamo saxa mataa i taa vil a faisok malaan lana isaak, nane pife fexaxaas sena ferawai fasaat sega lumui. ");
INSERT INTO leu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Senaso naseꞌ pife tisui netaara, i taxa tigina xuvul pataara. ");
INSERT INTO leu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","E naseꞌ ta mataa i taa tavai a saxa la palou imi pana raarum marafut senaso mi usiau, na Krais, a mataa aave i taa siak tuunei a sepirigus xana. ");
INSERT INTO leu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tamo ta saxa mataa i taa paamuian a saxano mataa o lak malaan sena lak aanabeꞌ talo i taa pife langai a ferawaian siak, lavaxa a roxo naak i taa pis fatofan a faat molava la kolumana e i taa tapin faduian pe la laman. (A fakasanaman sina Piran a faagut paaliu sena xaraxan aave.) ");
INSERT INTO leu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tamo a maam a pasak fatateak lana fulung si Setan, lavaxa patal tapine. Senaso a roxo no taa waan pana ma saxa lana bina sina Piran sena waanan pana ma taragua lana fata aava taxa raam vulai e pi ta taxapusan ina. ");
INSERT INTO leu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Pe la bina aave, a xunus ina mataa i taa pife maat e a fata ina fakasanaman i taa raam vulai, vulai. ");
INSERT INTO leu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tamo a kaam a pasak fatateak lana fulung si Setan, lavaxa patal tapine senaso a roxo pana ka saxa pe la bina sina Piran sena waanan pana ka taragua lana fata aava taxa raam vulai e pi ta taxapusan ina. ");
INSERT INTO leu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Pe la bina aave, a xunus ina mataa taa pife maat e a fata ina fakasanaman i taa raam vulai, vulai. ");
INSERT INTO leu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","E tamo a xasa pamataam i taa vil fapoxoi nano, lavaxa put tapine. A roxo pana laaxan xe lana bina sina Piran pana mata saxa sena duian xe lana fata aava pi ta taxapusan ina pana mata taragua. ");
INSERT INTO leu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Pe la bina aave, a xunus ina mataa taa pife maat e a fata ina fakasanaman i taa raam vulai, vulai. ");
INSERT INTO leu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","A mu Juda ri fuuna timin a sol xuluna mu tatavai siri xena kai tapin a lalosaat ina. E malaan sena sol a mu lagafan taa savat la toyan sina mu rabuna xena kai tapin a lalosaat siri. ");
INSERT INTO leu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A sol a mo roxo taasaxa tamo a xakaarixan ina i taa taxapus malaafaa mi taa vil faxakaarik fulane? Lavaxa, mi taa toxan a sol la toyan simi e a luaian la palou imi. ");
INSERT INTO leu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","E na Yesus a tamasiak pe Kapanam e fe paan xe pul Judia, e mui ri sivi xe paa la Raarum Jordan. E a malila ri maa savat fulaa sina pave e nane fapiti fulan nari. ");
INSERT INTO leu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","E saxano Ferasi ri maa savat sina senaso ri vubuk tafange pana saxa vuputkai sina mu Juda. E voxo ri fine, “A roxo tamo a saxa mataa i taa taꞌulan tapin a tefin sina?” ");
INSERT INTO leu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","E na Yesus a fin nari, “Lana vuputkai si Moses a kuus malaafaa?” ");
INSERT INTO leu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","E ri sui a fiaian sina malaan, “Na Moses a kuus turoxo pana mataa i taa xalei a lagasai ina fataxapin a tamaian sire. E a fexaxaas sena feng faꞌuli na naasana xe la pabung sina.” ");
INSERT INTO leu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","E na Yesus a xuus nari, “Na Moses a xalei malaane senaso a xunus imi a tateak malaan sena mu bumi. ");
INSERT INTO leu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Taasaxa la tangpat, a Piran a vesan a mataa e a tefin e re waan faxuvul. ");
INSERT INTO leu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","E voxo a mataa i taa taꞌulan a lifu si ninana e tamana ");
INSERT INTO leu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","e nane e a tefin sina re taa waan faxuvul malaan sena saxa. Re taa pife waan fepatok e a Piran i taa kat nare malaan seꞌ re saxa mon. ");
INSERT INTO leu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","E voxo a so ta mo a Piran fo vil faxuvule, a pife fexaxaas senꞌ ta saxa mataa taa vil fepatoxan fulane.” ");
INSERT INTO leu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mui fulaa lana lifu, a mu fefeng ri fine pana ferawaian aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","E nane xuus nari, “Naseꞌ i taa taꞌulan tapin na naasana e mui a tamai sina saxa tefin patak, i taxa kawaasan na naasana lana vilaana ina tamaian. ");
INSERT INTO leu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","E tamo ta saxa tefin i taa taꞌulan tapin na lavana e mui a tamai sina saxa tomexaan patak, nane sait vaxa, i taxa kawaasan na lavana lana vilaana ina tamaian.” ");
INSERT INTO leu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","E a mu rabuna ri savat pana mu rafulak siri xe si Yesus senaso ri vubuk i taa tao faroxoi nari. Taasaxa mu fefeng si Yesus ri marala e ri tivotan nari. ");
INSERT INTO leu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Layaan na Yesus a xalum a mu fefeng sina ri taxa vil malaane nane a maraleian nari e xuus nari malaan, “Siakmaan a mu rafulak xe siak. Muta tivotan nari! Ri taxa waan lana fatataganan sina Piran. ");
INSERT INTO leu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tuuna paaliu ne xuus nami, naseꞌ ta mataa i taa pife lamon pana laak lana fatataganan sina Piran malaan sena mu rafulak aanabeꞌ, i taa pife laak lana.” ");
INSERT INTO leu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","E nane xel a mu rafulak xe sina e yot nari e tao faroxoi nari. E nane fenung xe sina Piran o i taa tavai a rafulak aanabeꞌ pana roxoyan. ");
INSERT INTO leu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Layaan na Yesus tangpat pana sangas fulaa a saxa mataa a falamaan xe sina e maa turung la nona e fine, “Mataa roxo ina Fepitaa, ne taa vil a so xena siaxaana toyan vulai xe vulai?” ");
INSERT INTO leu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","E na Yesus a sui a ferawaian sina malaan, “Senasou no xaliau pana mataa roxo? Piau ta saxa mataa fe roxo, a Piran sang mon a roxo! ");
INSERT INTO leu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nano, no texaas sena mu vuputkai si Moses: Muneta punuk a mataa Muneta xaakaam soxotan a tefin sina xasa mataa Muneta fenau Muneta kawaasan a isina saxa mataa Muneta bitaana mataa Suai se ninaam e tamaam” ");
INSERT INTO leu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","E nane xuus na Yesus, “Ne fo faxaꞌusi a maana vilaana aanabeꞌ ti la yaan ne taxa lak modak.” ");
INSERT INTO leu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","E na Yesus a xalume e vubuxane e xuuse, “No taa vil a saxa mo lunai; falet e no fe faasot pana maana mo xapiak siim e no taa tavai a mu valagof pana fafanaian xapiak siim. E mui filimaan xe siak e no usiau. Tamo no taa vil malaane no taa toxan a maana mo xaves laaꞌui la bina sina Piran.” ");
INSERT INTO leu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Layaan a mataa aanabeꞌ a langai a ferawaian si Yesus a vilauna kanamsaat paaliu senaso nane toxan a maana mo xaves e maana xavala sait. E voxo nane falet pana mamaxusan molava paaliu. ");
INSERT INTO leu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","E na Yesus a kaalum xolai e a xuus a mu fefeng sina, “A lagaf paaliu xana mataa aava toxan a fafanaian xaves xena laak lana fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","E a mu fefeng sina ri ipul pana ferawaian aanabeꞌ taasaxa na Yesus a sui a fiaian siri e kuus fulaa, “Kamu rafulak, a laaxan xe lana fatataganan sina Piran a mo lagaf paaliu. ");
INSERT INTO leu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Naak a malui sena vio xena laak la valof ina matana maiyang sena mataa aava toxan a fafanaian xaves xena laak xe lana fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","E nari, ri ipul faagut paaliu e ri fine, “Naseꞌ voxo fexaxaas sena laak lana fatataganan sina Piran?” ");
INSERT INTO leu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","E na Yesus a xalum nari e kuus, “A mataa sang mon pife fexaxaas taasaxa xuvul pana Piran a maana mo xapiak a fexaxaas. Senaso a Piran sang mon a fexaxaas sena vilaana maana mo xapiak.” ");
INSERT INTO leu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","E na Pita a kuus malaan, “Ai, nemaam, maam fo taꞌulan a maana mo xapiak simaam e maam taxa usi nano.” ");
INSERT INTO leu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","E na Yesus a sui a ferawaian aanabeꞌ, “Ne kuus tuuna, naseꞌ ta mataa i taa taꞌulan a lifu sina e i taa taꞌulan a vasaana o tina o ninana o tamana o mu rafulak sina e i taa taꞌulan a bina sina o xavala sina e i taa taꞌulan a maana mo xapiak soxotau e xana Lagasai Roxo; ");
INSERT INTO leu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","a mataa aava vil malaane, i taa siak a maana mo xaves paaliu la yaan aanabeꞌ e vaxa la maana yaan i taa filimaan sait. I taa siak a maana mo malaan sena mu lifu e fetinan e fevasaanan, e tauna e rafulak, e xavala xena uma. I taa siak a maasaxan sait xuvul pana xasano mo roxo senaso saxano rabuna ri taa vil pengan a mataa aave. Taasaxa lumui lana yaan faꞌui i taa siak a toyan vulai. ");
INSERT INTO leu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Taasaxa nari aava ri taxa waan paamua naboxo, lumui ri taa waan lana fataxapiak ina xakatan.” ");
INSERT INTO leu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Layaan na Yesus e a mu fefeng sina, ri taxa laak xe kol Jerusalem nane ve taxa sangas paamuin nari. E a mu fefeng ri ipul pana vilaana aanabeꞌ e nari lamina mu fefeng ri mimilisaat e ri mataut. E voxo nane xel patak a mu yaamut sina e xuus fatexaas nari fulaa pana so ta mo i taa savat sena. ");
INSERT INTO leu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Nane xuus nari malaan, “Mi langai. Layaan taara taa laak saa xe Jerusalem a mu rabuna ri taa yot a Natuna Mataa e ri taa lisane xe sina mu paamua ina faxatangaana lotu. E nari, ri taa sei pana punuxaana e ri taa lisane xe sina paamua sina mu Rom. ");
INSERT INTO leu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","A mu rabuna ina rawen ti Rom ri taa fesuaxane e ri taa xanuse. Ri taa sipe e ri taa punuxe. Taasaxa lamina yaan talatul i taa to faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","E a ro lak si Sebedi, na Jems nare Jon re savat si Yesus e re xuuse, “Mataa ina Fepitaa, maame vubuk o no taa vil a mo aava maame taa fin nano pana.” ");
INSERT INTO leu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","E nane xuus nare malaan, “Me vubuk ne taa vil a so xaame?” ");
INSERT INTO leu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","E re fenung malaan, “Maame vubuk o maame taa nai la vena nai Piranan siim xuvul pama, saxa la pamuaan e saxa la paxaiya.” ");
INSERT INTO leu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Taasaxa na Yesus a xuus nare, “Name, me pife texaas sena so ta mo me taxa fiai pana. Me fexaxaas sena siak a maasaxan ne taa siaxe? O me fexaxaas vaxa sena siak a maxarafan ne taa siaxe?” ");
INSERT INTO leu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","E re kuus malaan, “Nemaame, maame fexaxaas.” E na Yesus a xuus nare, “A maasaxan aava ne taa siaxe, name sait, me taa siaxe. E a maxarafan aava ne taa siaxe, name sait, me taa siaxe. ");
INSERT INTO leu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Taasaxa pife faisok siak xena kuus turoxo pana nobina ina naian sime. Na Tamaang sang mon a fexaxaas xena faigotan a vepen xana mataa.” ");
INSERT INTO leu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Layaan a xasano yaamut sangafilu ri langai sena mo aanabeꞌ, ri kasalan na Jems nare Jon. ");
INSERT INTO leu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","E na Yesus a xel faxuvul nari xapiak e xuus nari, “Mi texaas sena vilaana sina saxano memai sina rabuna, ri pi lalamon sena rabuna siri. E mu matalava sait ri taxa siak fati mon a isiri saxa saxa. ");
INSERT INTO leu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Taasaxa semi, i taa piau! Naseꞌ rao i taa siak a isin lava la palou imi i taa vil fasivie xe lapia. ");
INSERT INTO leu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","E naseꞌ rao i taa tigina paamua semi i taa sisiak simi xapiak ");
INSERT INTO leu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","senaso a Natuna Mataa pife savat talo a rabuna taa sisiak sina, piau! Nane savat xena xavang a rabuna e xena tavai a malila pana toyan sina. A maatan sina i taa faroxoi a mu rabuna xapiak.” ");
INSERT INTO leu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","E na Yesus xuvul pana mu fefeng xo ri fe savat pe Jeriko. E layaan ri taꞌulan na Jeriko xena laak xe kol Jerusalem a malila ri falet xuvul pari. E saxa mataa piif, a isina na Baatimeas a lak si Timeas, i taxa nai fenung pana faat la itina salan. ");
INSERT INTO leu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Layaan na Baatimeas a langai o na Yesus ti Nasaret taxa filimaan faasilak, nane xukulai faagut malaan, “Ai, Yesus, Lak si Devit, muluxau!” ");
INSERT INTO leu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","E a rabuna xaves ri pebukane o i taa nai kasam. Taasaxa nane pe xukulai faagut fulaa saa malaan, “Ai, Lak si Devit, muluxau!” ");
INSERT INTO leu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","E na Yesus a tigina e kuus, “Xelmaane.” E a rabuna ri xele e ri xuuse, “Faamamaas, tamasiak, senaso nane taxa xel nano.” ");
INSERT INTO leu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","E a mataa piif aave a tapin a marapi ina vupungan sina e tamasiak fataapus e falet xe si Yesus. ");
INSERT INTO leu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","E na Yesus a fine, “No vubuk ne taa vil a so xaanum?” E a mataa piif a xuuse, “Ai, matalava ne vubuk kaalum fulaa.” ");
INSERT INTO leu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","E na Yesus a ferawai xe sina, “Falet, a namkaian siim fo vil faroxoi nano.” E a mataa aave a fexaxaas sena kaalum e nane usi na Yesus. ");
INSERT INTO leu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","La fena sangasan siri xe Jerusalem, faasilak a ro bina Betani e Betfas, la xasing ina Put Pana mu Wai Olif, na Yesus a feng paamuin a ro fefeng taragua. ");
INSERT INTO leu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","E nane xuus nare malaan, “Falet xe la bina aapave e layaan me taa savat lana me taa xalum a fomirak ‘donki’ aava ri pi nanai xuluna lunai. Muluse e me lisanmaane. ");
INSERT INTO leu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","E tamo saxa mataa i taa fin name malaan, ‘Xenaso me taxa siak a ‘donki’ aamove?’ Me taa sui a fiaian malaan, ‘A Memai a vubuxane e mui i taa lisan faꞌulie xe nabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","E nare, re falet e re tingin a fomirak ‘donki’ aave a palei fatian pe la salan faasilak la matana lifu e re muluse. ");
INSERT INTO leu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","E saxano rabuna aava ri taxa tigina faasilak, ri fin nare, “Ai, me taxa mulus a ‘donki’ xenaso?” ");
INSERT INTO leu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","E re xuus nari malaan se Yesus fo xuus nare e a rabuna ri kuus turoxo e ri feng nare pana. ");
INSERT INTO leu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","E ro fefeng re lisan a ‘donki’ xe si Yesus e re timin a marapi sire xuluna ‘donki’ e na Yesus a nai xuluna. ");
INSERT INTO leu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","E a rabuna xaves ri sului a marapi siri pe la salan e xasano rabuna ri siak a raxana wai pana paxana aava ri fo siaxe pe lalatan e ri timine la salan. ");
INSERT INTO leu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","E a mu rabuna ri sangas paamua e lumui la mi Yesus e ri taxa xukulai faagut malaan, “Hosaana! Faamamaas pana mataa i taa siak fati a isina Piran. ");
INSERT INTO leu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Faamamaas sena fatataganan malaan se butaara Devit i taa savat xo. Hosaana, laaꞌui la xunavata!” ");
INSERT INTO leu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","E nane laak xe pe Jerusalem e falet xe la tang lifu lotu sina mu Juda. E na Yesus xuvul pana mu rabuna, ri laak lana e ri sangas kaalum xolai. E mui na Yesus e mu fefeng sina ri ulaa xe Betani senaso faasilak a bina i suk. ");
INSERT INTO leu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A yaan saxa lumui la paanen, ri taꞌulan a bina Betani rao ri taa ulaa fulaa xe Jerusalem e na Yesus xo, a lagai. ");
INSERT INTO leu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","E nane xalum a wai malaan sena xakaap a toxan a paxana xaves. E nane falet xe pave rao i taa murul a xalana. Taasaxa layaan nane fe savat pe la funa wai e xalume, piau ta xalana senaso pife yaan ina fuaian sina lunai. ");
INSERT INTO leu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","E nane faraweie malaan, “A rabuna taa pife fangan sema fulaa!” E mu fefeng ri langaie. ");
INSERT INTO leu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","E mui ri savat pe Jerusalem e ri laak lana tang lifu lotu pave. E na Yesus a xup tapin a mu rabuna aava ri taxa faasot pana mu bulmakau e sipsip lana lifu lotu. E nane puk tapin a mu ivin sina rabuna aava ri taxa fesoxulai pana maana buk faat ina maraanan o ri taxa faasot pana mu maanu. ");
INSERT INTO leu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","E nane ti votan a rabuna rao ri muta yaas falak a maana mo xena faasot lana nobina ina lifu lotu. ");
INSERT INTO leu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","E nane fasei nari, a kuus malaan, “A Xakalayan sina Piran a kuus malaan, bo? ‘A lifu siak i taa waan a lifu ina fenungan siak xana mu rabuna xapiak.’ Taasaxa nami, mi fo vile malaan sena nobina ina fenauan.” ");
INSERT INTO leu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","A mu matalava sina rabuna aava ri faisok lana lifu lotu e mu rabuna aava ri masam pana mu vuputkai siri, ri langai a ferawaian sina e ri lalamon pana punuxaana taasaxa ri mataut se Yesus e sena rabuna vaxa, senaso a rabuna xo, ri ipul pana fepitaian sina. ");
INSERT INTO leu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","E la maana leaaf na Yesus e mu fefeng sina ri fuuna taꞌulan Jerusalem e ri ulaa xe pe la bina Betani. ");
INSERT INTO leu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","La paanen lolof ri falet fulaa xe Jerusalem e ri xalum a wai aava na Yesus fo kuus fatutule. A wai naang fo maiyang ti la xarei ina xe laaꞌui. ");
INSERT INTO leu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","E na Pita a lamon faꞌuli a ferawaian si Yesus e xuuse, “Mataa ina Fepitaa, kaalum, a wai aava no fo fatutule, pevoxo, fo maiyang xo.” ");
INSERT INTO leu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","E na Yesus a xuus nari, “Mi taa namkai faagut pana Piran. ");
INSERT INTO leu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ne xuus tuunei nami, tamo ta mataa pana namkaian tateak faroxo i taa farawei a put aanabeꞌ malaan, ‘Falet e lalaas du xe pe la laman’ e a put i taa vile. Naseꞌ ta mataa rao i taa vil malaane, tamo i taa namkai faagut pana, a vubuxanan sina i taa savat. ");
INSERT INTO leu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","E voxo ne xuus nami layaan mi taa fenung xe sina Piran mi taa namkai faagut sena mo aava mi fenung pana e i taa savat. ");
INSERT INTO leu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","E fulaa, layaan mi taxa fenung xe sina Piran mi taa lamon tapin a mu vilaana saat aava xasano rabuna ri fo vile xe simi talo a Piran vaxa i taa lamon tapin a vilaana saat simi. ");
INSERT INTO leu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Taasaxa tamo mi pife lamon tapin a vilaana saat sina xasano rabuna, lavaxa na Tamami pe laaꞌui, i taa pife lamon tapin a vilaana saat simi.” ");
INSERT INTO leu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","E ri savat fulaa pe Jerusalem e ri laak pe lana tang lifu lotu. E mu paamua ina lotu e mu rabuna aava ri masam pana mu vuputkai e mu matalava sina mu Juda, nari xapiak, ri filimaan xe sina ");
INSERT INTO leu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","e ri fine, “No taxa vil a faisok siim lapaana isin siseꞌ? Naseꞌ tavai nano pana gutan xena faisok malaan?” ");
INSERT INTO leu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","E na Yesus a xuus nari, “Paamua ne taa fin nami pana fiaian saxa e layaan mi suie ne taa xuus nami o ne taxa faisok lapaana gutan siseꞌ. ");
INSERT INTO leu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A fiaian siak a malaan: A faisok ina fasufan aava na Jon fo vile, a mo sina Piran ti laaꞌui o mo sina mataa mon? Mi xuusau!” ");
INSERT INTO leu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","E nari, ri ferawai faxuvul e ri kuus malaan, “Tamo taara taa kuus ‘ti laaꞌui’ nane i tamaa kuus: ‘Lavaxa, senasou mi pife namkai sena?’ ");
INSERT INTO leu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Taasaxa, taara mataut xena xuuse, o sina mataa mon.” Ri taxa mataut senaso a rabuna, ri taxa lamon se Jon o nane a mataa ina kuus fatuxai tuuna. ");
INSERT INTO leu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pevoxo, ri sui a fiaian si Yesus malaan, “Nemaam, maam vungut.” E na Yesus a xuus nari, “Lavaxa, ne taa pife xuus fatexaas nami sait pana gutan nenia, ne taxa faisok lapaana.” ");
INSERT INTO leu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","E na Yesus a tangpat pana ferawai xe sina mu matalava pana ferawaian paap malaan: “Saxa mataa a xapis a uma wain e fakaliuane pana vaafa faat. E nane xaf a vaaꞌul lapaana nobina ina paamimitaana xalana wain. E nane vesan a lifu modus faasilak la tana uma. Taasaxa nane pife waan pave. Nane xuus fatexaas a xasano rabuna rao ri taa faxatang a uma aave e ri taa lisan a saxano wain ri vesane xe sina lumui xena maraan a uma sina. E nane xo falet xe pe lasuun. ");
INSERT INTO leu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Layaan a mu xalana wain ri fo matoxol a mataa aave, a feng a saxa sisiak sina xe la uma talo a mu rabuna aapave ri taa tavaie pana wain. ");
INSERT INTO leu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Taasaxa mu rabuna ina faxatangaana uma ri fesipane e ri feng faꞌulie. ");
INSERT INTO leu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","E fulaa a mataa aave, a feng a xasa sisiak xe siri. E nari, ri sip pengane la putuna e ri famangile pana xasano vilaana saat. ");
INSERT INTO leu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","E a mataa aave, a feng a saxa sisiak fulaa e ri sip punuxe. Lumui nane feng a saxano sisiak fulaa taasaxa rabuna pave la uma, ri sip a saxanofuna e ri ngaapunuk xasanofuna. ");
INSERT INTO leu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","La fataxapiak, senaso piau ta sisiak fulaa, nane feng a lak tomexaan sina aava nane vubuxan xasingite. A mataa aave a lamon malaan, ‘Tuuna naak ri taa suai sena lak siak.’ ");
INSERT INTO leu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Taasaxa mu rabuna ina faxatangaana uma, ri fexuus la palou iri, ‘Ai, a lak sina naboxo, tamo taara taa punuxe, a uma aanabeꞌ i taa xataara, bo?’ ");
INSERT INTO leu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","E ri yot a lak sina mataa e ri punuxe e ri tapine xe pe lamina uma. ");
INSERT INTO leu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","A mataa aave i taa vil a so? I taa savat pe la uma e i taa sip punuk a mu rabuna aapave e mui i taa xel a xasano rabuna xena faxatangaana uma sina.” ");
INSERT INTO leu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Na Yesus a fin nari, “Mi pife xalum a xakalayan aava kuus malaan, bo? ‘A faat aava mu rabuna ri bai vesan a lifu pana, a faat naang, a savat xaaxaak mata ina lifu, a faat pana faisok molava paaliu. ");
INSERT INTO leu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","A faisok aanabeꞌ a savat sina Piran. E a faisok sina, taara taa ipulane.” ");
INSERT INTO leu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","A mu matalava ri langai si Yesus e ri texaas o nane taxa ferawai paap seri e ri vubuk yote taasaxa ri mataut sena malila aava ri taxa ti langaie. E voxo a mu matalava aave ri tamasiak e ri falet. ");
INSERT INTO leu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lumui a mu matalava sina mu Juda, ri feng a saxanu Ferasi e saxanu tuvaat si Herot xe si Yesus senaso ri vubuk o i taa faasaal pana ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ri savat sina e ri fiai malaan, “Mataa ina Fepitaa, maam texaas o no kuus tuuna vulai e no pife mataut sena mataa e voxo no fepitaa tuuna pana ferawaian sina Piran sang mon. Lavaxa, no lamon malaafaa? A roxo maam taa tavai a Paamua sina mu Rom pana taakis o piau? ");
INSERT INTO leu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Maam taa maraan a taakis sina o piau?” Taasaxa na Yesus a texaas o ri taxa bite e xuus nari, “Senasou mi taxa tafangau? Tamo toxan a faat move, siakmaane.” ");
INSERT INTO leu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","E ri siak a saxa e ri tavai na Yesus pana. E nane fin nari malaan, “A xaxaalua siseꞌ e a xakalayan siseꞌ nabeꞌ taxa waan xuluna faat aanabeꞌ?” E ri sui a ferawaian sina o a xaxaalua e xakalayan si Sisaa, a paamua ti Rom. ");
INSERT INTO leu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","E na Yesus a xuus nari, “Lavaxa, tavai a Paamua ti Rom pana maana mo sina e tavai a Piran laaꞌui pana maana mo sina.” E nari, ri ipul faagut. ");
INSERT INTO leu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","E saxanu Sedusi (nari aava ri kuus o piau ta toyan lamina maatan) ri savat si Yesus e ri fine malaan, ");
INSERT INTO leu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Mataa ina Fepitaa, na Moses a xalei a saxa vuputkai sitaara, a kala malaan, ‘Tamo ta mataa i taa maat e na naasana taxa waan pana piau ta lak, lavaxa na tina mataa aava fo maat i taa tamai sina tefin aave xena fasavataana mu rafulak xa tina.’ ");
INSERT INTO leu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Voxo, a matafetinan ve ri pisiguak, ri taxa waan e saxa, a lak tuaan, a tamai e maat taasaxa nare, re piau ta lak. ");
INSERT INTO leu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","E mui a saxa tina ti lamina a tamai sina tefin aave e nane sait a maat e piau ta lak. E saxa fulaa a malaan sait. ");
INSERT INTO leu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","E nari pisiguak xapiak ri tamai sina tefin aanabeꞌ e ri maat pana piau ta lak. E mui a tefin sait a maat. ");
INSERT INTO leu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lavaxa, layaan a Piran i taa fatatoi a mu rabuna fulaa, a tefin aave i taa waan na naasaseꞌ senaso nane fo tamai siri xapiak?” ");
INSERT INTO leu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","E na Yesus a xuus nari, “Naak mi vungut, senaso mi pife texaas sena ferawaian sina Piran e mi vungut sena gutan sina. ");
INSERT INTO leu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Layaan a Piran i taa fatatoi a mu rabuna fulaa ri taa pife tamai e ri taa pife vubuk siak a tefin o tomexaan. Ri taa waan malaan sena mu angelo ti laaꞌui. ");
INSERT INTO leu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Taasaxa lamon fulaa pana toyan ti la maatan siri. Nami, mi pife texaas sena xakalayan si Moses pana xuuskuus ina latan taxa raam e a Piran a xuus fatexaase malaan, “Nenia, ne Piran si Abrahem e si Aisaak e si Yaakop.” ");
INSERT INTO leu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","E voxo a Piran pife Piran sina mamaat, piau! Nane ve a Piran sina mu rabuna to. Naak mi fo milung faagut.” ");
INSERT INTO leu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","E saxa mataa aava masam sena mu vuputkai si Moses a savat e nane langai a ferawaian siri e nane texaas o na Yesus fo sui faroxoi a maana ferawaian siri. E nane fin na Yesus malaan, “A so ta vuputkai a fufuna maana vuputkai xapiak?” ");
INSERT INTO leu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","E na Yesus a xuuse, “Langaiau nami Israel. A vuputkai paamua a malaan, ‘A Piran, a Matalava sitaara, a Piran saxa mon. ");
INSERT INTO leu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","E nami, mi taa usie e suai sena vilaana sina pana vilau xapiak simi, pana xunus imi xapiak, lana lalamonan xapiak simi e pana maana gutan xapiak simi. ");
INSERT INTO leu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","E fulaa, a fataraguiaana vuputkai a malaan, “Mi taa vubuxan a xasano rabuna malaan seꞌ mi vubuxan nami xa. Piau ta vuputkai molava sere.” ");
INSERT INTO leu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","E a mataa aave a xuuse, “Ai, tuuna paaliu Mataa ina Fepitaa. No kuus tuuna o a Piran a saxa paamua e piau ta saxa malaan sena. ");
INSERT INTO leu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","E taara taa suai sena pana xunus itaara xapiak e pana masaman xapiak e pana maana gutan sitaara. E taara taa vubuxan a xasano rabuna sait. A vilaana aanabeꞌ a molava sena mu tatavaian xana Piran e mu falfaalan sait.” ");
INSERT INTO leu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na Yesus a texaas o nane ferawai faroxo e a xuuse, “No taxa xaveak masam a vilaana ina fatataganan sina Piran.” E mui xo, a mu matalava ri mataut sena tafang fulane. ");
INSERT INTO leu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Lumui, la tang lifu lotu, na Yesus a fapiti a malila e a fiai malaan, “Senasou a mu rabuna aava ri masam pana xakalayan ti kavai ri kuus o a Mataa Failai ve a lak si Devit? ");
INSERT INTO leu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na Devit sang a ferawai lapaana Vovau Xaradak: ‘A Piran a kuus xe sina Memai siak: no nai suꞌ la pamuaan siak fefexaxaas a yaan ne timin a mu xaiyaas siim lapaana kaam.’ ");
INSERT INTO leu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","E na Devit xo a xali a Mataa Failai pana Memai sina e malaafaa a Mataa Failai a fexaxaas sena waan a natu Devit?” E a rabuna ri faamamaas pana ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","E fulaa nane fapiti nari malaan, “Faxatang! Xalum a vilaana sina mu rabuna aava ri fepitaa pana mu vuputkai taasaxa muta pok nari. Ri vubuk sangas lana marapi modus siri e ri vubuk siak a suaian lava pe la nobina ina faxuvulan. ");
INSERT INTO leu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","E ri vubuk nai paamua la nobina sina matalava lana lifu ina faxuvulan e pe lana fenamo. ");
INSERT INTO leu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","E nari, ri siak palou a mu lifu sina lutefin aava tomexaan siri fo maat. E ri fenung xe sina Piran pana fenungan modus paaliu talo rabuna taa suai seri. A buk rabuna aanabeꞌ a Piran i taa tavai nari pana fakasanaman molava paaliu.” ");
INSERT INTO leu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","E mui nane nai kaalum faasilak la bina ina tatavai pana faat lana lifu lotu. E nane xalum a mu rabuna ri timin a maana faat lana mo ina tifiaana. E a mu matalava ri timin a faat xaves. ");
INSERT INTO leu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","E a saxa tefin nakmaal, a tomexaan sina fo maat xo, a savat e tatavai pana toea taragua mon. ");
INSERT INTO leu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","E na Yesus a xel a mu fefeng sina e xuus nari malaan, “Ne kuus tuuna paaliu xe simi, a tefin aapave a tavai a Piran pana faat molava sena maana xasano rabuna. ");
INSERT INTO leu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Senaso nari, ri toxai faat xaves taxa waan lunai taasaxa nane fo timin a faat xapiak sina e piau ta faat fulaa taxa waan la tana. ");
INSERT INTO leu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Layaan na Yesus a taꞌulan a tang lifu lotu saxa fefeng sina a xuuse, “Mataa ina Fepitaa, xalum a maana faat ri molava paaliu. A maana mu lifu aanabeꞌ ri roxo sang.” ");
INSERT INTO leu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","E nane sui a ferawaian sina malaan, “No xalum a maana mu lifu lava, bo? Ne xuus nano o lumui, piau ta faat saxa i taa waan xuluna xasa faat. Xasano rabuna ri taa ngas tapin a mu faat xapiak aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","E lumui lamina, layaan nane taxa nai kaalum fasivi xe la matana tang lifu lotu ti pe xuluna Put Olif, a matafetuaan, na Pita narie Endru e na Jems narie Jon, ri savat sina e ri fine malaan, ");
INSERT INTO leu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Xuus fatexaas nemaam o laso ta yaan a maana mo aanabeꞌ i taa savat e pana fakalimaanan ina savatan sina mo aave.” ");
INSERT INTO leu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","E na Yesus a fapiti nari e kuus malaan, “Faxatang semi, ulaa rabuna tamaa bit nami. ");
INSERT INTO leu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lumui a rabuna xaves ri taa savat e ri taa kuus o ri savat lapaana isaak. Ri taa xali nari xa pana isaak, a Mataa Failai, e voxo a rabuna xaves ri taa usi nari. ");
INSERT INTO leu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","E vaxa layaan mi langai sena mu rawen e maana ferawaian ina rawen, muta mataut. A vilaana malaan ri taa savat taasaxa taxapusan ina maana mo xapiak i taa pife savat lunai. ");
INSERT INTO leu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","A mu bina ri taa fevis e a mu fatataganan ri taa rawen. E a maraꞌulia xaves taa savat la maana mu bina e a yaan ina song taa savat sait. Taasaxa maana mo aave, ri taa savat malaan sena maasaxan sina tefin paamuina luluxan. ");
INSERT INTO leu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","E nami, mi taa faxatang, senaso xasanu tuvaat ri taa yot lisan nami xe sina rabuna ina tiisan e ri taa sip nami lana lifu ina faxuvulan. E mi taa tigina la nona mu matalava e mu piran sina rabuna sena isaak. E mi taa xuus fatexaas nari paga. ");
INSERT INTO leu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Taasaxa paamuina mo aave taa savat, a Lagasai Roxo i taa fepitaianan pe la maana mu bina xapiak. ");
INSERT INTO leu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Layaan ri taa yot lisan nami xe sina mu matalava, muta lalamon mimilisaat pana so ta ferawaian mi taa xuus nari pana senaso a Vovau Xaradak i taa fatexaas nami pana so ta ferawaian mi taa kuusane. ");
INSERT INTO leu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","E la yaan aapave a mu fetinan ri taa yot lisan a tiri e mu fetama ri taa yot lisan a lak siri e mu rafulak ri taa yot lisan a ninari e tamari e ri taa lisan nari xe lana maatan. ");
INSERT INTO leu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","E nami, a maana rabuna taa baian nami senaso mi paa xolai pana isaak. Taasaxa tamo ta mataa siak i taa tigina fatateak fefexaxaas la yaan fataxapiak, ne taa fakaxupe.” ");
INSERT INTO leu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Layaan mi taa xalum a saxa vilaana mosaat paaliu malaan: a mataa i taxa tigina pe lana Nobina Taap Xasingit (lamon pana e no taa masame), la mu yaan aave a mu rabuna pe Judia ri taa sinuf e ri taa paan fataapus xena fufunai laaꞌui xuluna put. ");
INSERT INTO leu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","E tamo ta mataa i taxa tigina xuluna lifu i muta sivi xe lana xena siak a mo sina, piau! Falet fataapus! ");
INSERT INTO leu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","E tamo ta mataa i taxa faisok pe lana uma, i muta ulaa xena siak a marapi sina, piau! ");
INSERT INTO leu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Muluk a lutefin aava ri tiva e muluk a lutefin aava ri taxa fasus a lak siri lana mu yaan aave. ");
INSERT INTO leu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Fenung xe sina Piran pana mu yaan aave ri taa pife savat la mu yaan vutung. ");
INSERT INTO leu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","A mu yaan aava ri taa savat ve a yaan ina fakasanaman. A yaan saat malaan pife savat paamua ti la yaan ina tangpat e fefexaxaas tanin. E a buk yaan aanabeꞌ i taa pife savat fulaa. ");
INSERT INTO leu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tamo Piran i taa pife faxalif a mu yaan ina fakasanaman aave a mu rabuna xapiak ri taa maat taasaxa Piran a faxalife senaso nane lalamon pana mu rabuna tatagan sina.” ");
INSERT INTO leu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pevoxo, tamo ta mataa i taa xuus nami pana, ‘Xalume, na Krais naboxo!’ o kuus malaan, ‘Nane taxa waan pave!’ muta langaie. ");
INSERT INTO leu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Senaso a mu krais bit ri taa savat xuvul pana mu mataa ina xuus fatuxai bit siri e ri taa vil a maana mo faꞌipul e ri taa vil a maana buk fakalimaanan aava xena tafang pana familungaana mu rabuna tatagan sina Piran. ");
INSERT INTO leu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Taasaxa lalamon faagut paaliu pana mo aanabeꞌ aava nenia, ne fo xuus fatexaas nami pana. ");
INSERT INTO leu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Lana mu yaan aapave, lana yaan ina fakasanaman: ‘A ngaas i taa pife lang faagut e fulun i tafe suk ");
INSERT INTO leu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","e mu vapara ri taa poxo ti laaꞌui e maana mo faagut pe laaꞌui ri taa radakui.’ ");
INSERT INTO leu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","E mui a rabuna ri taa xalum a Natuna Mataa, i taxa filimaan lana vata pana gutan e malang sina. ");
INSERT INTO leu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","E i taa feng a mu angelo e ri taa xel faxuvul a mu rabuna tatagan sina ti puaa, ti paa, ti pul, ti kol, ti la mu bina lasuun xuluna xavala e ti la mu bina lasuun pe laaꞌui. ");
INSERT INTO leu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Naboxo lamon pana ferawaian paap sena nuaa: layaan a raxana i taxa fungus, mi texaas o a mu yaan roxo ri taa savat. ");
INSERT INTO leu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","E malaan sait, layaan mi taa xalum a maana mo aava ne fo xuus nami pana, lavaxa mi taa texaas o a Natuna Mataa i taxa waan faasilak, i taxa tigina lamalei la matana lifu simi. ");
INSERT INTO leu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tuuna, ne xuus tuunei nami o a saxano rabuna aanabeꞌ ri taa pife maat lunai e maana mo aava ne fo xuus nami pana, ri taa savat. ");
INSERT INTO leu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Pe laaꞌui la finavata e nabeꞌ la xavala a maana mo xapiak ri taa taxapus, taasaxa ferawaian siak i taa pife taxapus. ");
INSERT INTO leu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Piau ta mataa i taa texaas sena yaan o mariaas a maana mo aave ri taa savat. A mu angelo e a Natuna Mataa sait ri pife texaas. Na Tamaang sang mon a texaas. ");
INSERT INTO leu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pevoxo, lalamon faagut, mi taa faxatang vulai senaso mi pife texaas sena yaan ina savatan sina. ");
INSERT INTO leu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","E voxo nami, mi malaan sena ferawaian paap aanabeꞌ: saxa mataa a tamasiak xena ulut e a xuus fatexaas a mu sisiak sina pana mu faisok xari saxa saxa. E nane a fasei a mataa saxa o i taa faxatang faagut vulai pana matana lifu. ");
INSERT INTO leu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","E voxo, faxatang vulai senaso mi pife texaas sena yaan a matalava i taa ulaamaan xe simi. Mi pife texaas o leaaf paaliu o la xunavung o la paanen lolof o la paanaas. ");
INSERT INTO leu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ulaa i tamaa savat faꞌipul maan e nami, mi taxa matef. ");
INSERT INTO leu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ne fasei faagutan nami xapiak, faxatang vulai!” ");
INSERT INTO leu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","La yaan taragua paamuina yaan molava sina mu Juda, a Yaan ina Paaliuan e a fenamo ina Bret A Piau Ta Yiis, mu matalava ina lotu e rabuna ina fepitaa pana mu vuputkai, ri taxa lo lalamon pana so ta vilaana ri taa vil kasame xena yotaan na Yesus e punuxaana. ");
INSERT INTO leu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","E ri kuus malaan, “La fena fenamo piau! Senaso a malila ri tamaa marala e ri taa fevis.” ");
INSERT INTO leu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","La yaan naang ve, na Yesus taxa waan pe Betani lana lifu si Saimon aava tana tamu tapak. E layaan nari xapiak, ri taxa mati fafangan, saxa tefin a savat pana fomirak ‘botol’ pana mo lalas aava musung ina roxo paaliu e a mamareiai ina molava temasaat. Ri xali a mo lalas aanabeꞌ pana Naart. E a tefin aave a gurum a ‘botol’ e tiuan a naart la putu Yesus. ");
INSERT INTO leu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","E saxano rabuna aava ri xalume, ri marala faagut e ri riis a tefin e ri kuus, “Xenaso no kawaasan a naart pana tiuanaana xulu Yesus? ");
INSERT INTO leu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tamo no taa faasot pana, a faat ina a fexaxaas xena maraan a mataa ina faisok lana mariaas saxa. Naak i taa roxo tamo taara taa faasot pana xena tavaiaana mu rabuna valagof pana faat ina.” E voxo ri taxa lo riis malaan a tefin aave pana. ");
INSERT INTO leu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Taasaxa na Yesus a sei nari, “Naapalaan! Muta riise! Xenaso mi maraleiane? Nane fo vil a mo roxo xaanak. ");
INSERT INTO leu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","A mu valagof ri waan xuvul pami vulai e mi fexaxaas xena xavangaan nari pana vilaana roxo vulai. Taasaxa nenia, ne taa pife waan xuvul pami vulai. ");
INSERT INTO leu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A tefin aanabeꞌ fo vil a mo roxo paaliu, nane fo fasufau pana mo lalas paamuina xaxaafaian siak. ");
INSERT INTO leu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A tuuna paaliu ne xuus nami, a so ta bina aava Lagasai Roxo siak i taa savat lana, a mu rabuna ri taa langai a vilaana roxo a tefin aanabeꞌ fo vile. A vilaana sina i taa pife malufan.” ");
INSERT INTO leu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","E na Judas Iskeriot aava saxa yaamut, a falet xe sina mu memai priis senaso rao i taa pet lisan na Yesus xe siri. ");
INSERT INTO leu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","E layaan ri langaie ri faamamaas paaliu e ri kuus o ri taa tavai na Judas pana faat ‘silva’. E nane a lalamon o laso ta yaan e pana so ta vilaana a fexaxaas nane i taa pet lisan na Yesus xe siri pana. ");
INSERT INTO leu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","A paanen ina yaan mata ina fenamo molava sina mu Juda, a yaan ina Bret A Piau Ta Yiis, e a yaan ri fuuna punuk a mu sipsip xena fenamo ina Paaliuan a savat. La yaan aave a mu rabuna si Yesus ri fine, “Maam taa faigotan a nobina xena fanganan sitaara faa? No lalamon malaafaa?” ");
INSERT INTO leu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","E nane feng a fefeng taragua talo re taa faigotan a vepen xena fanganan e xuus nare, “Falet xe Jerusalem e layaan me taa xalum a mataa i taxa yaas a raarum, usie. ");
INSERT INTO leu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","E layaan i taa laak lana lifu me taa fin a mata tafuna lifu malaanabeꞌ, ‘A Mataa ina Fepitaa a fiai malaan: A lifu xaanak faa? A palifu rao ne taa fangan xuvul pana mu fefeng siak xena fakalimaanaana yaan ina Paaliuan.’ ");
INSERT INTO leu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","E a mata aave i taa faxalit name pana palifu molava roxo aava nane fo faigotane. Name, me taa faigotan a fanganan sitaara pave.” ");
INSERT INTO leu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","E a rovaat sina re falet e re fe laak lana Jerusalem e a maana mo ri savat malaan sena ferawaian si Yesus. E voxo re faigot xena fenamo ina Paaliuan. ");
INSERT INTO leu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","E la nona leaaf na Yesus e maana xasano fefeng sina ri savat sirie. ");
INSERT INTO leu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","E layaan nari xapiak ri taxa mati fafangan na Yesus a xuus nari, “Ne kuus tuuna, a saxa mataa nabeꞌ la palou itaara i taa pet lisanau xe la mana mu matalava sina mu Juda. A saxa ti la palou imi aava i taxa fangan xuvul paga.” ");
INSERT INTO leu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","E nari xapiak ri mimilisaat sena ferawaian sina e ri taxa lo xuuse, “A tuuna, pife nenia!” ");
INSERT INTO leu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","E nane xuus nari, “A toxan a saxa mataa aava i taxa sugup a bret lana ‘dis’ xuvul paga, i taa vile. ");
INSERT INTO leu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Senaso a Natuna Mataa i taa punuxan malaan sena Xakalayan ti Kavai fo xuus netaara pana. Taasaxa muluk a mataa aava i taa pet lisan a Natuna Mataa xe sina mu rabuna saat. A roxo naak a buk mataa malaan i taa pife luxan. ");
INSERT INTO leu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","E layaan ri taxa fangan, na Yesus a siak a xavil ina bret e fenung pana e viaxe e tavai nari pana e a kuus, “Siaxe e mi ngane, nabeꞌ ve a meska siak.” ");
INSERT INTO leu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","E nane siak a lisa pana wain e fenung pana sait e tavai nari pana. E nari xapiak ri nume. ");
INSERT INTO leu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","E nane xuus nari, “Nabeꞌ ve a ria iga. I taxa kuus turoxo sena ferawaian sina Piran. A ria iga i taa talatiu xana mu rabuna xaves. ");
INSERT INTO leu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ne kuus tuuna o ne taa pife num a wain fulaa fefexaxaas ne taa num a wain faꞌui xuvul pami lana fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Lumui ri yangan a yanganan, ri tavaalak e ri falet e fe laak xuluna Put Olif. ");
INSERT INTO leu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Layaan ri taxa sangas lunai na Yesus a xuus nari, “Nami xapiak, mi taa sinuf e mi taa taꞌulanau senaso fo xaleian malaan: ‘Ne taa sip punuk a mataa ina faxatangaana mu sipsip e a mu sipsip ri taa falet fepatok.’ ");
INSERT INTO leu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Taasaxa layaan ne taa savat fulaa ti la maatan ne taa falet paamuin nami xe Galili.” ");
INSERT INTO leu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Taasaxa na Saimon Pita a xuuse malaan, “Tamo a maana xasano rabuna siim ri taa sinuf tapin nano, nenia, ne taa pife sinuf.” ");
INSERT INTO leu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","E na Yesus a suie malaan, “Ne kuus tuuna, tanin, lana vung aanabeꞌ nano sang mon no taa kuus o no pife texaas sega. E no taa kuus malaan faatalatul paamuina pura i taa rawei faataragua.” ");
INSERT INTO leu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Taasaxa na Pita i taxa lo kuus, “Naapalaan ri taa punuxau xuvul pama, ne taa pife faaxolusan nano.” E nari xapiak sait ri taxa kuus malaan sena. ");
INSERT INTO leu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","E ri savat la saxa bina, isina Getsemani, e nane xuus a mu fefeng sina, “Nai bang nabeꞌ talo ne taa fenung xe sina Piran.” ");
INSERT INTO leu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","E nane xel na Pita, Jems e namaa Jon e rutul sangas falet famodak fulaa e nane femimilisaat e femamaxus lana xunus ina ");
INSERT INTO leu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","e a xuus narutul, “A vilau iga a mamaxus temasaat paaliu faasilak rao ne taa maat. Mutul nai nabeꞌ e mutul faxatang.” ");
INSERT INTO leu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","E nane sangas famodak fulaa et e fe poxo lapia e fenung faagut xe sina Piran rao i taa siak tapin a matafanan molava aava i taa savat sina. ");
INSERT INTO leu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","E nane taxa lo kuus, “Aaba, Tamaang! Nano, no fexaxaas sena vil a maana mo xapiak. Tamo a fexaxaas, muta tavaiau pana maasaxan aanabeꞌ. Taasaxa muta usi a vubuxanan siak. No texaas tuuna sena so ta mo a roxo.” ");
INSERT INTO leu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","E nane ulaamaan xe la nobina sirutul e rutul taxa matef e nane ferawai xe si Pita malaan, “Saimon, no taxa matef? A sou no pife fexaxaas sena faxatang pana awa saxa? ");
INSERT INTO leu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Faxatang e fenung vulai talo a tatafangan i taa pife savat xe siim. A xunus ina mataa a tateak taasaxa a vipin ina, piau!” ");
INSERT INTO leu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","E fulaa na Yesus a falet famodak xena fenung xe si Tamana malaan paamua. ");
INSERT INTO leu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","E lamina nane savat fulaa sirutul e rutul taxa lo matef senaso a matarutul a matafan temasaat. E nane ferawai xuvul parutul taasaxa rutul pife texaas o rutul taa sui a ferawaian sina malaafaa. ");
INSERT INTO leu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","La fatalatulaana savatan sina, na Yesus a fin narutul, “Mutul taxa lo matef lunai? Lavaxa, taxapus! A yaan fo savat xo. Naboxo ri taa pet lisan a Natuna Mataa xe la mana mu rabuna saat. ");
INSERT INTO leu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Para! Taara taa falet. Kaalum, a mataa ina pet lisanau naboxo fo savat!” ");
INSERT INTO leu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","A mu matalava e mu paamua ina lotu e mu rabuna aava ri fepitaa pana vuputkai, ri feng a malila pana pinis e pana vam xe si Yesus. Layaan na Yesus i taxa ferawai lunai a malila aanabeꞌ ri savat xuvul pa Judas Iskeriot, saxa yaamut si Yesus, xena yotaana. ");
INSERT INTO leu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na Judas fo xuus fatexaas nari pana saxa fakalimaanan nane taa vile, “Naseꞌ ta mataa ne taa fe nguse, nane ve na Yesus. Mi yote e mi tao fatateaxe e mi xele saa xuvul pami.” ");
INSERT INTO leu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","La filimaanan si Judas, nane sangas soxot et na Yesus e a kuus, “Mataa ina Fepitaa” e fe nguse. ");
INSERT INTO leu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","E a mu rabuna ri yot marasaxain na Yesus e ri tao fatateaxe. ");
INSERT INTO leu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Taasaxa saxa fefeng si Yesus aava i taxa tigina faasilak, a siak a pinis sina e rao i punuk a saxa sisiak sina memai ina lotu. Taasaxa faasaal e a patal tapin a tangana mon. ");
INSERT INTO leu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","E na Yesus a fin nari, “Senasou mi savat la vung pana vam e pana pinis xena yotau? Mi lamon o nenia, ne mataa ina fenau? ");
INSERT INTO leu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","La maana yaan xapiak ne waan xuvul pami lana lifu lotu. E ne taxa fepitaa taasaxa mi pife yotau pave. Mi fo vil malaane senaso a Xakalayan ti Kavai fo kuus pana.” ");
INSERT INTO leu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","E a mu fefeng sina ri taꞌulane e ri sinuf. ");
INSERT INTO leu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","E saxa mataa xulau aava usi na Yesus, nane toxan a marapi pasak sang mon la tana. E a rabuna rao ri yote e ri tao fatateak a marapi sina ");
INSERT INTO leu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","taasaxa nane taꞌulan a marapi sina e sinuf pana tana gof. ");
INSERT INTO leu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","E a malila ri lisan na Yesus xe la lifu sina memai ina lotu. E mu paamua ina lotu, mu matalava sina mu Juda e mu rabuna ina fepitaa pana mu vuputkai, nari xapiak ri savat faxuvul pave. ");
INSERT INTO leu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","E na Saimon Pita xo, taxa lo usi na Yesus lasuun famodak e fe laak lana tavatau xuvul pana mu rawen sina memai ina lotu e fe nai maari la vangana fata. ");
INSERT INTO leu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","E mu matalava e mu paamua aave, ri langai a mu kuusan sina rabuna rao ri taa punuk na Yesus taasaxa piau ta ferawaian siri fefexaxaas. ");
INSERT INTO leu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A rabuna xaves ri bit tifi na Yesus taasaxa mu ferawaian siri pife saxa. ");
INSERT INTO leu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","A saxa a tigina e a bit tifi na Yesus pana ferawaian sina malaan: ");
INSERT INTO leu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ne langai na Yesus a kuus malaan, ‘Ne taa ngas tapin a lifu lotu aava mi vesane pana mami e lana yaan talatul ne taa vesan faꞌulie taasaxa ne taa pife vesane pana maak.” ");
INSERT INTO leu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Taasaxa xasano rabuna ri kuus patak e piau ta ferawaian siri fexaxaas xena kuus turoxo. ");
INSERT INTO leu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Taasaxa na Yesus a pife malaan seri, a tigina kasam mon. E a memai priis a tamasiak e sangas falet xe sina e fine, “No pife langai a maana ferawaian sema? A sou no pife sui a ferawaian siri?” ");
INSERT INTO leu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","E na Yesus a tigina kasam fatateak. E a memai a fine fulaa, “Nano, no Natuna Piran, a Mataa Failai?” ");
INSERT INTO leu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","E na Yesus a xuuse, “Tuuna, nenia! E mi taa xalum a Natuna Mataa i taa nai la pamuaan pana gutan e i taa filimaan xuluna vata ti laaꞌui.” ");
INSERT INTO leu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","E layaan a memai ina lotu a langai a ferawaian aanabeꞌ nane kasal e ririk a mu marapi sina xena faxaalit o nane lamon a ferawaian si Yesus a saat paaliu senaso a siak tifi nane pana isina Piran. E nane xukulai faagut e kuus, “Naapalaan, taara taa kuus panaso fulaa! ");
INSERT INTO leu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Netaara xapiak fo langai a ferawaian saat sina, mi lamon a so pana?” E nari xapiak ri ferawai malaan, ri kuus, “Fo faasaal xo! I taa punuxan!” ");
INSERT INTO leu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","E saxanofuna ri kaanus xuluna e ri pis votan a matana e ri tuxe e ri fine, “Tamo no Natuna Piran Tuuna no xali naseꞌ fo sip nano?” E a mu rabuna ina kaalum votai ri yote e ri sip fulane. ");
INSERT INTO leu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","E na Pita taxa nai maari lana tavatau e saxa sisiak tefin sina memai priis a filimaan ");
INSERT INTO leu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","e nane xalum na Pita aava taxa nai maari la vangana fata e taxa lo falime e a xuuse, “Nano sait no fuuna waan xuvul pa Yesus ti Nasaret.” ");
INSERT INTO leu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Taasaxa na Pita a faaxolus malaan, “Ne pife texaas sena so ta mo no taxa ferawai pana.” E nane falet xe la matana yalaxau. ");
INSERT INTO leu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","E mui a tefin aave a xalume fulaa e a kuusane xe sina mu rabuna ri taxa tigina pave, “Nane sait a saxa siri.” ");
INSERT INTO leu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","E na Pita a faaxolus fulaa. Lumui famodak a mu rabuna faasilak ri fin fulane, “Kuus tuuna, naak no saxa fefeng si Yesus senaso no ferawai pana pok bina ti Galili?” ");
INSERT INTO leu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","E nane ferawai vavotai faagut, a kuus fatateak malaan, “Nenia, ne pife texaas sena mataa mi taxa ferawai pana.” ");
INSERT INTO leu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","E fataapus lamina faaxolusan sina saxa pura a fataragui a raweian sina. E na Pita a lamon faꞌulaa o na Yesus a xuuse malaan, “Paamuina pura i taa rawei faataragua no taa kuus faaxolusanau faatalatul.” E na Pita a mimilisaat faagut e a savat xe lamalei e fetaangiis. ");
INSERT INTO leu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","La paanen lolof a mu paamua ina lotu, mu matalava sina mu Juda e mu rabuna ina fepitaa pana vuputkai, nari xapiak ina faxuvulan lava sina mu Juda, ri ferawai faxuvul o ri taa vil a so pa Yesus. E ri lalamon rao ri taa pise e ri taa lisane xe si Pailat. E voxo ri vil malaane. ");
INSERT INTO leu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","E na Pailat a fine malaan, “Nano, no piran king sina mu Juda?” E na Yesus a suie, “Nano, no fo kuus pana.” ");
INSERT INTO leu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","E a mu paamua ina lotu ri fexuusan pengane. ");
INSERT INTO leu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","E voxo na Pailat a fin fulane, “Ri kuusan pengan nano taasaxa no pife sui a ferawaian siri. No langai, ri taxa tiis nano pana mu vuputkai xaves?” ");
INSERT INTO leu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Taasaxa na Yesus a pife ferawai fulaa e na Pailat a ipul faagut. ");
INSERT INTO leu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na Pailat a toxan a saxa vilaana malaan: la palou ina fenamo nane fuuna mulus tapin a saxa mataa ti lana vipis, ta so ta mataa a mu rabuna ri taa kuus pana. ");
INSERT INTO leu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","E saxa mataa i taxa waan, isina Baraabas, a mataa ina rawen, e nane fevis xuvul pana xasano rabuna e fe punuk a mataa. ");
INSERT INTO leu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","E a malila ri savat xe si Pailat e ri fine rao i taa mulus tapin a saxa mataa ti lana vipis. ");
INSERT INTO leu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","E na Pailat a fin nari malaan, “Mi vubuk ne taa mulus tapin a ‘king’ sina mu Juda xe simi?” ");
INSERT INTO leu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","A fin nari malaan senaso nane texaas o a mu matalava ri lisan na Yesus lapaana taraafesuaian siri. ");
INSERT INTO leu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Taasaxa mu matalava priis ri fo farawei a malila o ri taa fin na Pailat i taa mulus tapin na Baraabas xe siri. ");
INSERT INTO leu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","E na Pailat a fiai malaan, “E ne taa vil a so pana mataa mi xalie pana ‘king’ sina mu Juda?” ");
INSERT INTO leu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","E mu rabuna ri xukulai faagut, “Niil fataxutane!” ");
INSERT INTO leu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Taasaxa na Pailat a fin nari, “Xenaso? A so ta vilaana saat nane fo vile?” E nari, ri xukulai faagut paaliu, “Niil fataxutane!” ");
INSERT INTO leu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","E voxo xena famatakasamaan nari na Pailat a mulus tapin na Baraabas xe siri. E nane farawei a mu rawen sina o ri taa inis na Yesus pana yeis e ri taa niil fataxutane. ");
INSERT INTO leu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","E a mu rawen ri xel falak na Yesus xe lana tang lifu sina gavamen (ri xali a lifu aanabeꞌ pana ‘Pretorium’) e ri fe faxuvul a mu rawen sina mu Rom pave. ");
INSERT INTO leu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","E ri famause pana marapi raf malaan sena marapi sina ‘king’. E ri favapoi a kaat sina ‘king’ pana yeis tuturuk e ri timine la putuna. ");
INSERT INTO leu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","E ri taxa lo suaxan na Yesus pana ‘king’ e ri xukulai malaan, “Suai sena ‘king’ sina mu Juda!” ");
INSERT INTO leu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","E ri taxa lo sipe la putuna pana newai e ri kaanus xuluna e ri turung e bukaak la nona. ");
INSERT INTO leu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","E lamina suaxanaana siri ri siak tapin a marapi raf sena e ri tavai faꞌulie pana marapi sina e ri xele xe la bina ina niil fataxutane. ");
INSERT INTO leu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Layaan ri savat lamalei a saxa mataa i taxa sangas la palou ina rabuna, a isina na Simon ti Sairiin, na tama Aleksanda nare Rufus. E a mu rabuna ina rawen ri xele xena yaas xavang na Yesus pana bolo sina. ");
INSERT INTO leu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","E ri savat pe la bina Golgaata, a malasuf ina malaan: ‘a bina ina veng’. ");
INSERT INTO leu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","E rao ri fanume pana wain aava toxan a saxa buk titiwai xena ti votan a maasaxan lana, ri xalie pana ‘mur’ taasaxa nane bai nume. ");
INSERT INTO leu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","E voxo ri niil fataxutane xuluna bolo. E ri fepatoxan a mu marapi sina pana fetafangai pana faat, talo naseꞌ i taa savat paamua i taa siak a saxa mo. ");
INSERT INTO leu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ri niil fataxutane la paanen malaan sena 9 oklok. ");
INSERT INTO leu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","E ri xalei a lagasai xena kuus fakalimaan malaan, “A ‘King’ sina mu Juda.” E ri niile laaꞌui la putuna bolo. ");
INSERT INTO leu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ri niil fataxutan a ro mataa ina fenau la nu itina. ");
INSERT INTO leu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","E voxo a Xakalayan ti Kavai a kuus tuuna layaan a kuus malaan: “Ri timine xuvul pana mu rabuna saat.” ");
INSERT INTO leu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","E a rabuna xaves aava ri taxa sangas falet faasilak, ri ferawai fasaat sena e ri liliitan a puturi e ri kuus malaan: “Ai, nano aava no fo kuus o no taa ngas tapin a lifu lotu e no taa vesan faꞌulie lana yaan talatul, ");
INSERT INTO leu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","xavang nano xa e no sivimaan ti laaꞌui xuluna bolo.” ");
INSERT INTO leu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","E a mu memai priis sait xuvul pana mu rabuna aava fepitaa pana mu vuputkai, ri merao e ri fesuaxan pengane malaan, “Nane fexaxaas sena xavang a xasano rabuna taasaxa a sou pife fexaxaas sena xavang nane xa?” ");
INSERT INTO leu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","E ri kuus fulaa, “Tamo a Mataa Failai aanabeꞌ a King ti Israel, xenaso a pife sivimaan ti xuluna bolo talo taara taa xalume e taara taa texaas sena?” E a ro mataa saat sait aava ri niil fataxutan nare vaxa re taxa lo suaxane sait. ");
INSERT INTO leu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","E faasilak la belo la paanaas, a bina suk fefexaxaas leaaf. ");
INSERT INTO leu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","E la leaaf na Yesus a xukulai faagut malaan, “Eloi, Eloi lama sabaatani.” Lana pok bina ti pave, Erameik, a malasuf ina a malaan, “Piran siak, Piran siak, xenaso no lamon taꞌulanau?” ");
INSERT INTO leu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","E layaan a mu rabuna aava ri taxa tigina faasilak ri langaie, ri feferawai, “Langaie, nane taxa xel na Ilaija.” ");
INSERT INTO leu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","E saxa mataa a fala e fe siak a pel e fapirause pana wain e timine la ngusuna newai talo i taa nume e a kuus malaan, “Taara taa xalum tareie ulaa na Ilaija i tamaa savatmaan xena muluse.” ");
INSERT INTO leu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","E na Yesus a xukulai faagut fulaa e mui a maat. ");
INSERT INTO leu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","E pave lana tang lifu lotu, a marapi molava aava taxut la palou ina Nobina Taap Xasingit e a nobina xana mu priis, a tiririk la palou e piau ta mataa fe vile. A tiririk ti laaꞌui xe lapia marasaxa. ");
INSERT INTO leu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pe Golgaata, a saxa paamua sina mu rabuna ina rawen i taxa tigina faasilak la ka Yesus e a langai a ferawaian sina e falim a maatan sina e a kuus malaan, “Tuuna paaliu a mataa aanabeꞌ a Natuna Piran!” ");
INSERT INTO leu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","E saxano lutefin sait ri taxa lo ti kaalum lasuun famodak e ri xalum a maana vilaana ina maatan si Yesus. Nari na Maria Mekdala, Salomi e na Maria na nina Jems modak nare Joses, rutul taxa waan la palou iri. ");
INSERT INTO leu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Paamua la maana yaan na Yesus fuuna waan pe Galili a lutefin aave ri fuuna usie e ri xavange pana maana faisok sina. E narutul xuvul pana xasano lutefin sait ri fo sangas xuvul pana xe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","La leaaf faasilak a ngaas i rul e faasilak a tangpat ina Yaan ina Fangaafusan sina mu Juda sait, ");
INSERT INTO leu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","a saxa matalava sina mu Juda, na Yosep ti Erimatia aava namkai sena fatataganan sina Piran, nane a fagut a lamonan sina e fe fin na Pailat pana vipin i Yesus. ");
INSERT INTO leu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","E na Pailat a ipul o na Yesus fo maat senaso pife xavai ri niil fataxutane e voxo nane xel a saxa paamua sina mu rabuna ina rawen e maa fine o na Yesus xo fo maat. ");
INSERT INTO leu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Layaan a paamua aave a kuus o na Yesus fo maat, na Pailat a kuus turoxo o na Yosep i taa siak saa a vipin i Yesus. ");
INSERT INTO leu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","E na Yosep xuvul pana saxano rabuna ri maraan a marapi pasak e ri vil fadui a vipin i Yesus e ri xafute pana marapi pasak aave e ri timine lana liing. (A liing aanabeꞌ ve a mataa fo taxe lana faat xena xaafaian.) E ri vil votan a matana liing pana faat molava. ");
INSERT INTO leu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","E na Maria Mekdala narie Maria na nina Jems nare Joses, re taxa ti falim nari senaso rao re texaas sena matana xawaa. ");
INSERT INTO leu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Layaan a Yaan ina Fangaafusan fo taxapus na Maria Mekdala, Salomi e na Maria na nina Jems, rutul siak a mu mo lalas xena timine xuluna vipin i Yesus. ");
INSERT INTO leu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","La paanen lolof la yaan mata ina ‘wiik’ (la Sande), rutul falet xe la liing ina mamaat e rutul fe savat la yaan a ngaas fo laak. ");
INSERT INTO leu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","E rutul taxa lo fefiai malaan, “Naseꞌ i taa pul tapin a faat aava ti votan a matana liing?” Senaso a faat aave a molava paaliu. ");
INSERT INTO leu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","E ri kaalum et e a matana liing fo talakas xo! ");
INSERT INTO leu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","E layaan rutul laak lana liing, rutul xalum a saxa xulau i taxa nai la nobina aava ri timin na Yesus lana e a marapi sina a pasak paaliu e rutul ipul faagut e rutul mataut. ");
INSERT INTO leu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","E nane a xuus narutul, “Muta mataut! Mutul taxa seng na Yesus ti Nasaret aava ri fo niil fataxutane. Nane fo malit. Nane fo to faꞌulaa. Xalum a nobina aava ri fo famatie lana nabeꞌ e naboxo fo malit. ");
INSERT INTO leu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Taasaxa mutul falet e mutul fe xuus fatexaas a mu rabuna sina e na Pita sait, malaan, “Nane i taa sivi paamuin nami xe pe Galili. E pave mi taa xalume malaan sena fo xuus nami paamua.” ");
INSERT INTO leu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","E layaan rutul savat lamalei, rutul sinuf fataapus senaso ri ipul faagut pana matautan e ri radakui. Taasaxa rutul pife xuus fatexaas a xasano fefeng senaso rutul mataut faagut. ");
INSERT INTO leu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Layaan na Yesus a to faꞌulaa, la yaan mata ina ‘wiik’, (la Sande) nane savat paamua si Maria Mekdala aava nane fo gei tapin a mu vovau saat pisiguak xasena. ");
INSERT INTO leu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","E nane falet fataapus e fe xuus fatexaas a xasano fefeng aava ri taxa lo taangiis e mamaxus lunai. ");
INSERT INTO leu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","E layaan ri langai o nane fo to faꞌulaa e a tefin aanabeꞌ a xalume, ri lamon o pife tuuna e ri bai langaie. ");
INSERT INTO leu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Taasaxa lumui layaan a ro fefeng re taxa sangas la salan, nane savat sire taasaxa re pife taraxalie. ");
INSERT INTO leu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Lumui re texaas sena e re ulaa fataapus fulaa xe sina xasano fefeng e re fe xuus nari. Taasaxa ri lamon o nare sait re taxa bit. ");
INSERT INTO leu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","E muibak nane savat xe sina mu yaamut layaan ri taxa mati fafangan e fe gil nari sena vungutan siri e sena lamonan vaang siri. Senaso ri pife langai faroxoi a kuusan sina fesing siri e ri pife lamon faroxo pana ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","E nane xuus nari, “Falet xe la maana mu bina xapiak e mi tavai a mu rabuna xapiak pana Lagasai Roxo siak. ");
INSERT INTO leu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Naseꞌ ta mataa i taa namkai sega e i taa fasufan, nane ve, ne taa fakaxupe. Taasaxa naseꞌ i taa pife namkai sega a toxan a fakasanaman xana. ");
INSERT INTO leu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","E voxo a mu fakalimaanan aanabeꞌ ri taa falet xuvul pana mu rabuna aava ri namkai: ri taa gei tapin a mu vovau saat pana gutan lana isaak, ri taa ferawai pana maana pok bina faꞌui ");
INSERT INTO leu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","e tamo ri taa tao a tiui i taa pife xet punuk nari, ri taa num a neng taasaxa ri taa pife maat e ri taa vil faroxoi a mu rabuna pana giisan.” ");
INSERT INTO leu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Pevoxo, layaan na Memai Yesus a taxapus pana ferawaian aanabeꞌ a Piran ti laaꞌui a xel faꞌulie e nane fe nai la pamuaan lana vepen sina Piran. ");
INSERT INTO leu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E a mu fefeng sina ri falet xe la maana mu bina xapiak e ri xuus fatexaas a mu rabuna lana mu bina pana Lagasai Roxo. E a Vovau Xaradak a xavang nari pana faisok siri e a fagut a faisok siri pana fakalimaanan ina gutan. ");
INSERT INTO leu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","A maana rabuna xaves ri fo kala sena maana mo aava Piran fo fasavate la matavas la palou itaara. ");
INSERT INTO leu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","A maana mo aave a mu rabuna aava ri fefeng sina Piran ri xuus fatexaas netaara pana senaso ri xalume ti la tangpat. ");
INSERT INTO leu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Naboxo a toxan a maana xakalayan xaves. E nenia na Luuk, ne fo fiai faaxaves pana maana mo xapiak aava fo savat ti la tangpat e voxo ne lamon rao ne taa kala xena faxuvul faroxoi a maana xuuskuus aave xena lisanaana xe siim, matalava Tiofilas. ");
INSERT INTO leu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","E layaan no taa kate, no taa texaas sena tuunayan ina maana mo ri fo fapiti nano pana. ");
INSERT INTO leu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lana yaan si Herot aava paamua lava pe Judia, a toxan a saxa priis a isina na Sekaraia. Nane a saxa bu Eron ti la pabung si Abiya. A mu bu Eron ri fuuna vil a faisok ina priis lana lifu ina nangusaana Piran. A tefin si Sekaraia, isina na Elisabet, nane vaxa a bu Eron. ");
INSERT INTO leu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nare xapiak re waan fatak la matana Piran senaso re usi faroxoi a maana fefasaian e mu vuputkai sina Memai e re piau ta lalosaat. ");
INSERT INTO leu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Taasaxa re piau ta lak senaso na Elisabet ve a tefin mala. E nare xapiak vaxa re fo vaiak xo. ");
INSERT INTO leu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Saxa yaan layaan a parabuna priis si Sekaraia ri taxa vil a faisok ina priis siri la lifu lotu, na Sekaraia taxa sisiak la matana Piran. ");
INSERT INTO leu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","E pana vilaana ina tapin a faat ri siak fati na Sekaraia xena laak la lifu lotu sina Memai talo i taa faram a vulut pana lasan roxo. ");
INSERT INTO leu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","La yaan ina faramaana xo a savat e mu rabuna aava ri savat xena nangus a Piran, ri taxa faxuvul lamalei e ri taxa fenung. ");
INSERT INTO leu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","E lana yaan fatak aave a angelo sina Memai moxo a savat xe si Sekaraia e a tigina la pamuaan ina nobina ina faramaana vulut aave. ");
INSERT INTO leu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Layaan na Sekaraia a xalume, nane ipul marasaxa e femataut faagut. ");
INSERT INTO leu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Taasaxa angelo aave a xuuse, “Muta mataut, Sekaraia. A Piran a langai a fenungan siim e na naasaam, na Elisabet, i taa luk a lak tomexaan e no taa faꞌisine pa Jon. ");
INSERT INTO leu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","I taa vil fafaamamaas name. E maana rabuna xaves ri taa faamamaas sena luluuxan sina senaso i tafe lava la matana Memai. E i taa pi nunum a raarum tateak o xasano mo malaan e i tafe bas pana Vovau Xaradak ti la yaan ina luluuxan sina. ");
INSERT INTO leu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","I taa lisan faꞌuli a maana rabuna ti Israel xe sina Memai aava Piran siri. ");
INSERT INTO leu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","E i taa falet paamuin a Memai lana vilaana e gutan si Ilaija. I taa puk faꞌuli a vubuxanan sina mu tamana rafulak xe sina mu rafulak siri e a rabuna aava ri langai pesalai xe sina texaasan ina mu vilaana fatak. Nane taa vil malaane xena faigotanaana rabuna aava ri taa bang a savatan sina Memai.” ");
INSERT INTO leu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Na Sekaraia a fin a angelo aave, “Ne taa texaas sena tuunayan ina malaafaa? Nenia, ne mataa vaiak e a tefin siak sait a toxan a mariaas xaves.” ");
INSERT INTO leu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A angelo xo a suie, “Nenia ve na Gebriel e ne fuuna tigina la matana Piran. Nane xa a fengau xena xuus fatexaas nano pana lagasai roxo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","E naboxo, senaso no pife namkai sena ferawaian siak, no taa po. No taa pife ferawai fefexaxaas a yaan aave fo savat. E i taa savat tuuna lana yaan fatak ina.” ");
INSERT INTO leu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Lavaxa, a mu rabuna pe lamalei si, ri taxa lo waan bang na Sekaraia. Ri taxa lalamon pana senaso fo waan a yaan modus paaliu lana lifu lotu. ");
INSERT INTO leu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Layaan nane savatmaan xe lamalei ri texaas o nane xalum a saxa mo lana lifu lotu senaso pife fexaxaas sena ferawai taasaxa fakalimaan mon pana mana. ");
INSERT INTO leu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lamina fulun saxa, layaan a yaan ina faisok sina xo a taxapus, nane ulaa xe la lifu sina. ");
INSERT INTO leu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","E mui lamina, a tefin sina, na Elisabet moxo fetiva e pana fulun pama a waan fufunai mon pe la lifu sina. ");
INSERT INTO leu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Na Elisabet a kuus, “A Memai fo vil a mo aanabeꞌ xaanak. Lana yaan aanabeꞌ nane faxalitau pana xakaavangan xatam sina. Nane siak tapin a mangilan siak la matana mu rabuna.” ");
INSERT INTO leu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","La fapisaxayaana fulun si Elisabet, a Piran a feng a angelo naang, na Gebriel, xe pe Nasaret, a saxa bina pe Galili. Nane fe savat sina saxa tefin palau aava ri fakalimaane rao i taa tamai si Yosep aava bu Devit. A tefin aave a isina na Maria. ");
INSERT INTO leu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","A angelo aave xo a savat sina e a xuuse, “A luaian xulum. A Piran a waan xuvul pama e a xafut nano pana roxoyan sina.” ");
INSERT INTO leu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Na Maria a mamaxus sena ferawaian sina e a lalamon faaxaves pana so ta buk fasusuian va malaan. ");
INSERT INTO leu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Taasaxa, a angelo a xuuse, “Muta mataut Maria, a Piran a faamamaas paaliu pama. ");
INSERT INTO leu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","No taa tiva e no taa luk a lak tomexaan. E no taa faꞌisine pa Yesus. ");
INSERT INTO leu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nane tafe lava e ri taa xalie pana Lak Tomexaan sina Piran pana Isin Molava Paaliu. E a Memai Piran i taa faneie la vena naian lava si buna lava, na Devit. ");
INSERT INTO leu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","I taa tagan vulan a matafetama si Yaakop. E a fatataganan sina i taa pife taxapus.” ");
INSERT INTO leu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Na Maria a fin a angelo, “I taa savat malaafaa senaso nenia, ne tefin palau.” ");
INSERT INTO leu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","A angelo aave a suie, “A Vovau Xaradak i taa savat siim e a gutan sina Piran pana Isin Molava Paaliu i taa xafut nano. E no taa luk a Lak Xaradak e ri taa xalie pa Natuna Piran. ");
INSERT INTO leu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A tauma, na Elisabet, i taa luk a lak e nane ve a tefin vaiak. Nane piau ta lak lunai, taasaxa i taxa waan xo lana fulun pisaxa sina. ");
INSERT INTO leu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Piau ta mo a Piran pife fexaxaas sena vile.” ");
INSERT INTO leu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Na Maria a suie. “Nenia xa ne sisiak sina Memai. E ne kuus turoxo pana ferawaian siim.” E a angelo xo a taꞌulane. ");
INSERT INTO leu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","La yaan aave xo na Maria tamasiak e fe laak fataapus xe la bina put pe Judia. ");
INSERT INTO leu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Pave nane fe laak la lifu si Sekaraia e fesuai se Elisabet. ");
INSERT INTO leu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Layaan na Elisabet a langai a ferawaian si Maria, a popo la xuna a lalaas marasaxa. E na Elisabet febas paaliu pana Vovau Xaradak ");
INSERT INTO leu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","e a ferawai falava paaliu e kuus, “Nano, no faamamaas paaliu sena maana lutefin e a roxoyan i taa xafut a lak aava no taa luxe. ");
INSERT INTO leu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Taasaxa, xenaso nano, nina Memai siak, no filimaan xena xalumau? ");
INSERT INTO leu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Layaan ne langai a ferawaian siim a lak la xuak a lalaas pana faamamaasan. ");
INSERT INTO leu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nano, no fo namkai o a lagasai sina Memai xe siim i taa savat tuuna e voxo no taa faamamaas.” ");
INSERT INTO leu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","E na Maria a yangan e a kuus, “A xunus iga a nangus a Memai ");
INSERT INTO leu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","e a vovau siak a faamamaas pana Piran aava Nges Ina Vil Fatato siak. ");
INSERT INTO leu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nane fo lamon faꞌuliau, ne sisiak palau sina. E naboxo a mu rabuna aava ri taa savat mui, ri taa xaliau pana tefin pana faamamaasan. ");
INSERT INTO leu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","A Piran pana Maana Gutan Xapiak fo vil a maana mo roxo paaliu paga e a isina a taap e xaradak. ");
INSERT INTO leu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nane tiuan a mamaaluxan sina xuluna mu rabuna aava ri suai faagut sena, a mu rabuna xapiak lana mu yaan xapiak. ");
INSERT INTO leu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Pana mana, nane fo vil a maana buk faisok ina gutan: nane fo tapalan xolan a mu rabuna aava ri vil falavai nari xa lana lamonan fufunai siri. ");
INSERT INTO leu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nane fo fapoxoi a mu paamua la venanai piranan siri e a faꞌisin a mu rabuna palau pana isin lava. ");
INSERT INTO leu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nane fo famasi a rabuna aava ri lagai pana maana mo roxo taasaxa feng tapin a mu rabuna piran malaan sena valagof. ");
INSERT INTO leu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","E malaan sena kuus fanaian sina, nane fo xavang a sisiak sina aava na Israel. E nane lamon faꞌuli na Abrahem e mu buna xapiak pana mamaaluxan sina.” ");
INSERT INTO leu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Lavaxa, na Maria a waan xuvul pa Elisabet pana fulun talatul e mui nane ulaa xe la lifu sina. ");
INSERT INTO leu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","A yaan ina luluuxan xo a savat si Elisabet e nane luk a lak tomexaan. ");
INSERT INTO leu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A mu fesing sina e mu tauna ri langai o a Piran fo faxalite pana mamaaluxan molava e ri faamamaas xuvul pana. ");
INSERT INTO leu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","La fapisiktulaana yaan sina lak aave ri savat xena putuxaana e ri buk faꞌisine sait pana isi tamana, na Sekaraia. ");
INSERT INTO leu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Taasaxa na ninana a kuus, “Piau, a isina na Jon.” ");
INSERT INTO leu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ri fiai, “Xenaso? Piau ta tauma pana isin malaan.” ");
INSERT INTO leu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","E ri talangai pana mari xe sina tamana lak xena fine pana so ta isin rao i vubuk faꞌisin a lak pana. ");
INSERT INTO leu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Nane fiai pana mo ina kala e nane faꞌipul nari xapiak layaan a kala malaan, “A isina ve na Jon.” ");
INSERT INTO leu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Fataapus paaliu a valana talakas e a xalemana tamulus e nane tangpat pana kuus fati a isina Piran. ");
INSERT INTO leu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A mu fesing siri, ri ipul marasaxa. E pe Judia, lana bina put aave, a mu rabuna ri taxa lo ferawai pana maana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Naseꞌ ta mataa a langai pana mo aanabeꞌ a lalamon pana e a fiai, “A lak aanabeꞌ i taa so ta buk mataa?” Senaso ri texaas o a gutan sina Piran a waan xuvul pana. ");
INSERT INTO leu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","A tamana lak, na Sekaraia, a bas pana Vovau Xaradak e a kuus fatuxai malaan: ");
INSERT INTO leu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nangus a Memai aava Piran sina mu Israel senaso nane fo filimaan xena maraan faꞌuli a mu rabuna sina. ");
INSERT INTO leu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nane fo fasavat a Saxa ina Gutan xena fakaxup netaara, a saxa aave a bu Devit aava sisiak sina. ");
INSERT INTO leu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Lokavai mupiis nane kuus, la ngusuna rabuna ina kuus fatuxai, o nane taa fakaxup netaara xasena mu xaiyaas sitaara e xasena gutan siri xapiak aava ri baian netaara. ");
INSERT INTO leu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","75","Nane xa a kuus o i taa muluk a mu butaara e i taa lamon faꞌuli a turoxoian taap sina aava nane kuus fanai pana xe sina butaara, na Abrahem. Nane kuus o i taa fakaxup netaara xasena xaiyaas sitaara talo taara taa savat sisiak sina lana roxoyan e xaradaxan la maana yaan xapiak sitaara e taara taa pife mataut. ");
INSERT INTO leu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","E nano xanatuk, ri taa xali nano pana mataa ina kuus fatuxai sina Piran pana Isin Molava Paaliu senaso no taa falet paamuin a Memai xena faigotanaana salan xana. ");
INSERT INTO leu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","No taa fapiti a rabuna sina pana fakaaxupan aava savat sena lamon tapinaana mu faasaalan siri. ");
INSERT INTO leu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","A Piran sitaara a bas pana mamaaluxan e fananapan. Nane vil famatavas a texaasan ina fakaaxupan talo nari aava ri taagul lana bina ina maatan, ri taa tamulus sena, xena sangas la matavas aava savat ti laaꞌui la xunavata. Nane taa vil malaane xena paamuian netaara xe lana salan ina luaian.” Nabeꞌ ve a yanganan si Sekaraia. ");
INSERT INTO leu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","E a lak aave a palak e fesavat tateak lana vovau ina vaxa. E nane taagul la bina vingil fefexaxaas a yaan nane savat la matavas xe sina mu Israel. ");
INSERT INTO leu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lana mu yaan aapave, na Sisaa Agastas a lisan a fefasaian faꞌui xe la mu bina. Nane kuus o a mu rabuna xapiak la mu bina ri taa timin a isiri lana buk ina xakatan. ");
INSERT INTO leu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(A xakatan aanabeꞌ a savat la yaan na Kwirinius taxa paamua ina bina Siria.) ");
INSERT INTO leu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A mu rabuna xapiak ri taxa paan xe la fufubina siri talo ri taa fakat nari. ");
INSERT INTO leu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","E voxo na Yosep sait a taꞌulan a bina Nasaret pe Galili e fe laak xe la bina Betlihem, a bina si Devit, pe la bina Judia senaso nane waan lana pabung si Devit. ");
INSERT INTO leu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nare Maria re paan xe pave xena timin a isire lana buk. Na Maria i taa tefin sina e a tiva. ");
INSERT INTO leu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Layaan re taxa waan pave a yaan ina luluuxan sina a savat. ");
INSERT INTO leu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","E nane luk a lak tuaan sina, a lak tomexaan. Nane xafute pana marapi e famatie lana nobina ina fanganan sina bulmakau senaso piau ta nobina xare lana lifu saxong. ");
INSERT INTO leu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","E la vung a mu rabuna ina faxatangaana sipsip ri waan pe la vangana bina lana yi e ri taxa faxatang a mu sipsip siri pave. ");
INSERT INTO leu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","A angelo sina Memai a savat siri e a miridingan molava piis sina Piran a xafut nari e ri femataut faagut. ");
INSERT INTO leu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Taasaxa angelo a xuus nari, “Muta mataut. Ne lisanmaan a lagasai roxo pana faamamaasan molava paaliu xe simi e mu rabuna xapiak. ");
INSERT INTO leu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tanin, lana bina si Devit, a Nges Ina Vil Fatato simi fo luxan. Nane ve a Mataa Failai e a Memai simi. ");
INSERT INTO leu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","A mo aanabeꞌ ve a fakalimaanan xe simi: Na ninana a xafute pana marapi e mi taa tingine lana nobina ina fanganan sina bulmakau.” ");
INSERT INTO leu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Fataapus paaliu a mu angelo xaves ti laaꞌui ri maa savat xuvul pana matalava angelo aave e ri kuus fati a isina Piran malaan, “A Piran aava waan laaꞌui paaliu, nane xa a toxan a isin molava piis e lapi la xavala, a luaian i taa waan xuluri aava ri waan lapaana roxoyan sina.” ");
INSERT INTO leu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Layaan a mu angelo ri fo taꞌulan nari, a mu rabuna ina faxatangaana sipsip ri fexuus, “Taara taa falet xe Betlihem xena xalum a mo aanabeꞌ aava Piran fo xuus netaara pana.” ");
INSERT INTO leu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","E voxo ri falet fataapus e ri fe tingin na Maria narie Yosep e a lak popo aava i taxa mati lana nobina ina fanganan sina bulmakau. ");
INSERT INTO leu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Layaan ri fo xalume ri xuus fatexaas a mu rabuna pana ferawaian sina mu angelo sena lak aave. ");
INSERT INTO leu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","E layaan a rabuna xapiak ri langaie ri ipul faagut sena. ");
INSERT INTO leu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Taasaxa na Maria a fawaan fatateak a mu ferawaian xapiak la xunus ina e lamon fatie. ");
INSERT INTO leu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A mu rabuna ina faxatangaana sipsip ri ulaa. E ri fe kuus fati a isina Piran pana maana mo ri fo xalume e ri fo langaie senaso a maana mo aave fo savat fatak malaan sena matalava angelo fo kuusane. ");
INSERT INTO leu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","A fapisiktulaana yaan lamina luluuxan sina, a yaan ina putuxaana e re faꞌisine pa Yesus. A isin aave a angelo fo faꞌisine pana paamuina luluuxan sina. ");
INSERT INTO leu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Re usi a vuputkai si Moses e layaan a mu yaan ina vil tapinaana lalosaat sire a taxapus, na Yosep nare Maria re lisan na Yesus xe Jerusalem xena tatavai xe sina Memai Piran pana senaso a vuputkai si Moses a kuus malaan: “A mu rafulak tuaan xapiak aava ri tomexaan, mi taa noxol nari xana Piran.” ");
INSERT INTO leu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","E re laak vaxa xena tatavai pana mo aava vuputkai sina Memai Piran a kuus pana; “A ro Vaalus o a ro Titibu faꞌui.” ");
INSERT INTO leu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","A toxan a saxa mataa pe Jerusalem a isina na Simeon. Nane ve a mataa xaradak e a vubuxan xasingit a Piran. Nane taxa waan bang a Mataa Failai sina Memai. E a Vovau Xaradak a fabase. ");
INSERT INTO leu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","A Vovau Xaradak aave a faxalite o i taa xalum a Mataa Failai sina Piran paamuina maatan sina. ");
INSERT INTO leu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","28","A Vovau xo a paamuian na Simeon xena laak la tang lifu lotu. Layaan na nina Yesus e na tamana re lisanmaane xena vilaana malaan sena vuputkai a kuus pana, na Simeon a favavol a lak aave la mana e a kuus fati a isina Piran malaan: ");
INSERT INTO leu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Memai aava paamuian a maana mo xapiak, no fo fasavat famatavas a mo no fo kuus fanai pana. Naboxo a yaan ina maatan siak fo savat. Feng tapinau pana luaian. ");
INSERT INTO leu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","A ro mataak re fo xalum a fakaaxupan siim aava no fo faigot pana la matana mu rabuna xapiak. ");
INSERT INTO leu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","A malang xena famatavas a mu rabuna aava ri pife Juda e xena tavai a mu rabuna siim aava mu Israel, pana isin lava.” ");
INSERT INTO leu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na tamana e ninana re ipulan a ferawaian aava na Simeon a kuusane pana lak. ");
INSERT INTO leu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Na Simeon a fenung xe sina Piran pari e a xuus na Maria, a ninana lak, malaan, “A lak aanabeꞌ a Piran a siak fatie xena kawaasanaana saxanofuna ti Israel e xena fakaxup a saxanofuna. Nane ve a fakalimaanan aava maana rabuna ri taa tisuie e voxo a lamonan fufunai siri taa savat la matavas. E a matafanan malaan sena pinis modus i taa xi a viuma.” ");
INSERT INTO leu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","A toxan a tefin ina kuus fatuxai, a isina na Ana. Nane a lak si Fanuel lana pabung si Aasur e nane a tefin vaiak. Nane waan xuvul pa lavana pana mariaas pisiguak mon e na lavana maat tapine. ");
INSERT INTO leu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","E mui a waan a tefin nakmaal fefexaxaas a mariaas sangafilu pisiktul pana talafaat. Nane pi taꞌulan a tang lifu lotu aave, nane naangus la maana vung e la maana yaan xapiak pana falfaalan e fenungan. ");
INSERT INTO leu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Monabeꞌ mon nane maa savat xe sire e kuus faasiroxo xe sina Piran pana roxoyan sina e a ferawai pana lak aave xe siri xapiak aava ri taxa waan bang pana mulus tapinaana mu rabuna ti Jerusalem. ");
INSERT INTO leu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Layaan na Yosep nare Maria re vil xapin a mo aava vuputkai sina Memai a kuus pana, re ulaa xe pe Galili, xe la nobina sire, na Nasaret. ");
INSERT INTO leu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","E a lak aave a palak e fetateak: nane bas pana texaasan e a xakaavangan xatam sina Piran a waan xuluna. ");
INSERT INTO leu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","La maana mariaas xapiak a tamana e ninana re fuuna laak xe pul Jerusalem la Fenamo ina Paaliuan. ");
INSERT INTO leu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Layaan nane xo toxan a mariaas sangafilu saxa pana taragua, rutul usi a vilaana sire e rutul laak xe la fenamo aave. ");
INSERT INTO leu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","A fenamo fetaxapus e na tamana nare ninana re taxa ulaa xo xe la bina sire. A lak aave, na Yesus, a waan soxo mui pe Jerusalem taasaxa ninana nare tamana re pife texaas sena waanan sina. ");
INSERT INTO leu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Re lamon o i taxa waan xuvul pari e re falet pana yaan saxa. E mui re tangpat pana sengaana la palou ina mu taure e mu fesing sire. ");
INSERT INTO leu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Re seng maat e re fe ulaa fulaa xe Jerusalem xena sengaana. ");
INSERT INTO leu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Lamina yaan talatul re tingine pe la tang lifu lotu. Nane xo taxa irimai xuvul pana mu rabuna ina fepitaian. Nane langai siri e fin nari pana saxano mo. ");
INSERT INTO leu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nari aava ri taxa langaie ri ipul faagut paaliu pana masaman e susuaa sina. ");
INSERT INTO leu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Layaan a tamana nare ninana re xalume re ipul vaxa. Na nina lak a xuuse, “Natuk, xenaso no vilai malaave xasemaame? Nemaame tamaam, maame fo seng nano pana matautan.” ");
INSERT INTO leu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","E nane fine, “Senasou me taxa sengau? Me pife texaas o ne taa waan la lifu si tamaang, bo?” ");
INSERT INTO leu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Taasaxa re pife masam sena fufuna ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","E mui nane sivi xe puaa Nasaret xuvul pare e a langai faroxo paaliu sire. Taasaxa na ninana a fawaan a maana mo aanabeꞌ la xunus ina. ");
INSERT INTO leu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","E na Yesus a palak e felava pana texaasan e a Piran xuvul pana maana rabuna xapiak ri vubuxan faagutane. ");
INSERT INTO leu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Layaan na Taibirius Sisaa fo paamuian a rabuna ti Rom pana mariaas sangafilu saxa pana pama e na Ponsus Pailat a paamua pe Judia e na Herot a paamua pe Galili e na tina, na Filip, a paamua pe Ituria e Trakonitis e na Lisanias a paamua pe Abilene ");
INSERT INTO leu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","e vaxa lana yaan na Aanas nare Kaiafas re memai priis, lana yaan aave xo a ferawaian sina Piran a savat si Jon aava lak si Sekaraia pe la bina vingil. ");
INSERT INTO leu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nane falet xolai pe la nu bina la vangana Raarum Jordan. E lana sangasan sina nane kuus fasavat o a mu rabuna ri taa mamaxus e ri taa puk tapin nari xa xasena vilaana saat siri e ri taa fasufan talo a Piran i taa lamon tapin a vilaana saat siri. ");
INSERT INTO leu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","A xakalayan si Aisaia, a mataa ina kuus fatuxai, a kuus malaanabeꞌ: “A ling ina saxa mataa pe la xobingil i taxa kel ‘Faigotan a salan xana Memai, Vil faxaradak a salan sina. ");
INSERT INTO leu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Raful a mu matana mui e faxaradak a mu put lava e modak. A mu salan xaxoling, vil faxaradak nari e tifi a mu vaaꞌul lana salan. ");
INSERT INTO leu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","E a mu rabuna xapiak ri taa xalum a fakaaxupan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","E na Jon a xuus a malila aava ri maa savat sina xena fasufan malaan, “Nami ve, mi tiui pana neng! Naseꞌ pebukan nami o mi taa sinuf sena fakasanaman lava i taa savat? ");
INSERT INTO leu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tamo mi fo puk tapin nami xa xasena maana vilaana saat simi lavaxa, fasavat a maana faisok roxo xena faxalitaana. E muta lamon o mi taa xuus nami xa, ‘Na Abrahem ve na Tamataara.’ Ne xuus nami o a Piran a fexaxaas sena fasavat a rafulak xa Abrahem pana mu faat aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","A yaamu i taxa waan xo la funa wai e a wai aava pife fasavat a xalana roxo, a Piran i taa tei tapine xe lana fata.” ");
INSERT INTO leu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","A malila ri fine, “Maam taa vil a so?”. ");
INSERT INTO leu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","E na Jon a sui nari, “A mataa pana marapi taragua i taa tavai a saxa aava piau, pana saxa e a saxa pana fanganan vaxa i taa vil malaane.” ");
INSERT INTO leu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A mu rabuna ina siak taakis vaxa ri savat xena fasufan e ri fine, “Mataa ina fepitaa, maam taa vil a so?” ");
INSERT INTO leu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Nane xuus nari, “Siak faxuvul fatak a faat ina taakis taasaxa muta siak ta faat a moxaves temasaat sena vuputkai a kuus pana.” ");
INSERT INTO leu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","E mui a saxano rabuna ina rawen ri fine, “E maam taa vil a so?” E nane sui nari, “Muta famataut a rabuna pana sipaan nari xena siaxaana mo siri e muta bit tifi a mataa e vaxa mi taa faamamaas pana faat mi siaxe sena faisok simi.” ");
INSERT INTO leu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","A maana rabuna ri taxa falim fatateak na Jon senaso ri lamon o naak na Jon a saxa aava Piran a siak fatie xena fakaxup a mu Israel, a Mataa Failai sina. ");
INSERT INTO leu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Na Jon a sui nari xapiak, “Nenia, ne fasuf nami pana raarum. Taasaxa saxa pana gutan aava molava sena gutan siak i taa filimaan e nenia, ne pife fexaxaas sena mulus a ‘slipa’ sina senaso ne mataa palau mon. Nane xo i taa fasuf nami pana Vovau Xaradak e fata. ");
INSERT INTO leu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A toxan a gagala la mana e i taa gon a bina sina, i taa faxuvul a fanganan lana nobina ina fawaanaana fanganan e a xawa i taa farame pana fata aava piau ta taxapusan ina.” ");
INSERT INTO leu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","E pana maana saxano ferawaian fulaa na Jon a fagut a rabuna e kuusan fasavat a Lagasai Roxo xe siri. ");
INSERT INTO leu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Taasaxa na Jon a baras na Herot aava paamua lava ti Rom senaso nane fo tamai xuvul pa Herodias aava tefin si tina. E na Herot fo vil a maana vilaana saat fulaa e layaan na Jon a barase pana ");
INSERT INTO leu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","nane falavai a vilaana saat sina pana pisaan na Jon. ");
INSERT INTO leu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Layaan na Jon taxa fasuf a mu rabuna, na Yesus maa savat sina e na Jon a fasufe vaxa. E layaan na Yesus i taxa fenung, a xunavata a talakas ");
INSERT INTO leu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","e a Vovau Xaradak a sivimaan xuluna lana vipin ina vaalus. E a ling a ferawai ti laaꞌui la xunavata, “Nano, no natuk, ne vubuxan xasingit nano e a xunus iga a roxoian nano.” ");
INSERT INTO leu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Layaan na Yesus a toxan a mariaas sangafilu talatul nane tangpat pana faisok sina. A maana rabuna ri lamon o nane a lak si Yosep e na Yosep a lak si Heli e ");
INSERT INTO leu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","na Heli a lak si Matat e na Matat a lak si Livai e na Livai a lak si Melki e na Melki a lak si Yanai e na Yanai a lak si Yosep e na Yosep ");
INSERT INTO leu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","a lak si Matatias, e na Matatias a lak si Emos, e na Emos a lak si Nahum e na Nahum a lak si Esli, e na Esli a lak si Nagai e na Nagai ");
INSERT INTO leu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","a lak si Maat, e na Maat a lak si Matatias, e na Matatias a lak si Semen e na Semen a lak si Josek, e na Josek a lak si Joda e na Joda ");
INSERT INTO leu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","a lak si Joanan e na Joanan a lak si Resa e na Resa a lak si Serubabel e na Serubabel a lak si Seltiel e na Seltiel a lak si Neri e na Neri ");
INSERT INTO leu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","a lak si Melki e na Melki a lak si Adi e na Adi a lak si Kosam e na Kosam a lak si Elmadam e na Elmadam a lak si Er e na Er ");
INSERT INTO leu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","a lak si Jaasua, e na Jaasua a lak si Eliesar e na Eliesar a lak si Jorim e na Jorim a lak si Matat, e na Matat a lak si Livai e na Livai ");
INSERT INTO leu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","a lak si Simeon e na Simeon a lak si Juda e na Juda a lak si Yosep e na Yosep a lak si Jonam e na Jonam a lak si Eliakim e na Eliakim ");
INSERT INTO leu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","a lak si Melea e na Melea a lak si Mena e na Mena a lak si Matata e na Matata a lak si Natan e na Natan a lak si Devit e na Devit ");
INSERT INTO leu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","a lak si Jesi e na Jesi a lak si Obet e na Obet a lak si Boas e na Boas a lak si Salmon e na Salmon a lak si Naason e na Naason ");
INSERT INTO leu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","a lak si Aminadap e na Aminadap a lak si Ram e na Ram a lak si Esron e na Esron a lak si Peres e na Peres a lak si Juda e na Juda ");
INSERT INTO leu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","a lak si Yaakop e na Yaakop a lak si Aisaak e na Aisaak a lak si Abrahem e na Abrahem a lak si Teraa e na Teraa a lak si Neor e na Neor ");
INSERT INTO leu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","a lak si Seruk e na Seruk a lak si Reu e na Reu a lak si Pelek e na Pelek a lak si Eber e na Eber a lak si Selaa e na Selaa ");
INSERT INTO leu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","a lak si Kainan e na Kainan a lak si Arfasat e na Arfasat a lak si Sem e na Sem a lak si Noyeꞌ e na Noyeꞌ a lak si Lemek e na Lemek ");
INSERT INTO leu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","a lak si Metusalaa e na Metusalaa a lak si Inok e na Inok a lak si Jaaret e na Jaaret a lak si Mahalalel e na Mahalalel a lak si Kenan e na Kenan ");
INSERT INTO leu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","a lak si Inos e na Inos a lak si Set e na Set a lak si Aadam e na Aadam a lak sina Piran. ");
INSERT INTO leu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Na Yesus xo aava bas xapiak pana Vovau Xaradak, a taꞌulan a Raarum Jordan e lapaana paamuian sina Vovau Xaradak nane sangas xolai la bina vingil. Nane waan pave a yaan sangafilu talafaat e lana mu yaan aanabeꞌ ve na Setan a valame. Nane pi fafangan la maana yaan aave e lamina nane lagai. ");
INSERT INTO leu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Na Setan a ferawai xe si Yesus e a kuus, “Tamo no lamon o nano, no Lak sina Piran lavaxa, fasavat a bret pana faat aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Na Yesus a suie, “Lana Ferawaian sina Piran a kuus ‘A mataa i taa pife siak a gutan sena bret sang mon.” ");
INSERT INTO leu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Na Setan a lisan falaxe xe la nobina laaꞌui e lana yaan aava malaan sena yaamit, a faxalite pana maana mu bina xapiak. ");
INSERT INTO leu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","E nane xuus na Yesus, “A maana mu bina aave ri siak e ne paamuiane. Ne fexaxaas sena tavai naseꞌ ta mataa ne vubuxane, pana maana mu bina aave. ");
INSERT INTO leu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tamo no taa faꞌisinau pana Piran siim ne taa pisingan nano pana.” ");
INSERT INTO leu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Na Yesus a suie, “Lana Ferawaian sina Piran a kuus, ‘Nangus a Memai, a Piran siim, e no taa sisiak sina mon.” ");
INSERT INTO leu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Na Setan a lisane xe Jerusalem e fatigineie laaꞌui paaliu xuluna tang lifu lotu e a kuus, “Tamo nano, no Natuna Piran, no taa tapin fasivi nano xa. ");
INSERT INTO leu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Senaso lana Ferawaian sina Piran a kuus, ‘Nane taa feng a mu angelo sina xena faxatang faroxoi nano. ");
INSERT INTO leu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ri taa yaas nano xe laaꞌui pana mari talo a kaam i taa pife du sui a faat.” ");
INSERT INTO leu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Na Yesus a suie, “A Ferawaian sina Piran a kuus, ‘Muta valam a Memai aava Piran siim.” ");
INSERT INTO leu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Layaan na Setan fo fataxapin a mu valaman aanabeꞌ nane taꞌulane fefexaxaas a yaan faꞌui ina valaman i taa savat. ");
INSERT INTO leu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","E voxo, na Yesus a taꞌulan a bina vingil e ulaa xe pe Galili lapaana gutan sina Vovau Xaradak e maana rabuna lana mu bina pave ri ferawai sena. ");
INSERT INTO leu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nane fepitaa lana lifu ina faxuvulan sina mu Juda e a mu rabuna xapiak ri faatulane. ");
INSERT INTO leu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nane falet xe puaa Nasaret, a bina aava nane a lak dak lana, e malaan sena vilaana sina, lana Yaan ina Fangaafusan a laak lana lifu ina faxuvulan e nane tigina xena kat. ");
INSERT INTO leu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ri tavaie pana xakalayan si Aisaia. Nane siaxe e a muluse e layaan a tingin a xakalayan aava kuus malaan a kate: ");
INSERT INTO leu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“A vovau sina Piran a xafutau senaso nane fo noxolau xena kuusan fasavat a Lagasai Roxo xe sina mu valagof. Nane fengau xena kuus fatexaas o nari aava ri vipis ri taa mulus tapinan; a mu mata piif ri taa kaalum fulaa e a mu rabuna aava ri waan lapaana gutan sina xaiyaas siri ri taa taꞌulai xaseri ");
INSERT INTO leu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","e xena kuus o lana mu yaan aanabeꞌ a Piran i taa faxalit netaara pana roxoyan sina.” ");
INSERT INTO leu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lamina kataana, nane fulus a Lagasai aave e a tavai a saxa fefeng la lifu ina faxuvulan pana. E bak a nai xena fepitaa. A mu rabuna xapiak lana lifu ina faxuvulan ri kaalum fatateak xe sina. ");
INSERT INTO leu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nane tangpat pana fepitaian sina malaan, “Tanin xo, a Ferawaian sina Piran aanabeꞌ aava mi fo langaie, fo savat la matavas.” ");
INSERT INTO leu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","A mu rabuna ri ferawai faroxo sena fepitaian sina e ri ipul pana ferawaian marafut aava savat la valana. E ri fiai, “Nane a lak si Yosep, bo?” ");
INSERT INTO leu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na Yesus a kuus xe siri, “Tuuna paaliu, mi taa xuusau pana ferawaian paap aanabeꞌ, ‘Mataa ina iꞌirin, vil faroxoi nano xa’ e mi taa kuus fulaa, ‘Maam fo langai o no fo vil a maana mo faꞌipul pe Kapanam lavaxa, fasavat a mo malaan, nabeꞌ la fufubina siim.” ");
INSERT INTO leu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nane ferawai fulaa e a kuus, “Ne kuus tuuna, a mataa ina kuus fatuxai xo, a mu rabuna ti la fufubina sina, ri taa tisuie. ");
INSERT INTO leu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ne xuus tuunei nami, lana yaan si Ilaija, layaan piau ta raafui pana mariaas talatul e xavil e a song molava a savat pe Israel, a toxan a maana lutefin nakmaal xaves. ");
INSERT INTO leu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Taasaxa Piran pife feng na Ilaija xe siri, piau, nane fenge xe sina saxa tefin pe Serafet la bina Saidan. ");
INSERT INTO leu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","E vaxa, a rabuna xaves pe Israel a tari tapak lana yaan si Ilaisa, a xasa mataa ina kuus fatuxai, taasaxa pi ta mataa tapak ti Israel a savat roxo faꞌulaa, piau, na Neman ti Siria mon.” ");
INSERT INTO leu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Layaan a rabuna lana lifu ina faxuvulan ri langaie ri marala faagut. ");
INSERT INTO leu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ri fasangas na Yesus xe laaꞌui xuluna put la nobina aava masasaaf xena tapin faduie lapi la matana mui. ");
INSERT INTO leu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Taasaxa nane sangas fatak la palou iri e taꞌulan nari. ");
INSERT INTO leu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","E bak nane sivi xe kol Kapanam, saxa bina pe Galili e la Yaan ina Fangaafusan a tangpat pana fapitiaana mu rabuna pave. ");
INSERT INTO leu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nari, ri ipul pana fepitaian sina senaso a toxan a gutan. ");
INSERT INTO leu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pave lana lifu ina faxuvulan, a toxan a saxa mataa aava vovau saat a vawe. Nane xukulai faagut pana matautan malaan, ");
INSERT INTO leu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Yesus ti Nasaret, no taa vil a so xe simaam? No savat xena kawaasan xapin nemaam, bo? Ne texaas sema, nano, no Mataa Failai sina Piran.” ");
INSERT INTO leu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na Yesus a sui faagutane, “Kasam! Taꞌulane!” E a vovau saat moxo a tapin fasivi a mataa aave la matari e a taꞌulane taasaxa pife fasope. ");
INSERT INTO leu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","A mu rabuna xapiak ri ipul faagut e ri fiai, “A so ta buk ferawaian va nabeꞌ? Pana gutan e texaasan nane fuuna fasei faagutan a mu vovau saat e ri savat taꞌulan a mataa.” ");
INSERT INTO leu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","E lana maana nu bina aava faasilak se Kapanam a rabuna ri langai pana mu faisok si Yesus. ");
INSERT INTO leu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na Yesus a taꞌulan a lifu ina faxuvulan aave e a falet xe la lifu si Saimon. Na imu Saimon a giis pana tana lalagaf e ri fin na Yesus rao i taa xavange. ");
INSERT INTO leu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nane tigina la tana e a baras a giisan e a giisan a taꞌulane. A tefin aave a tamasiak fataapus e a faigotan a kas xari. ");
INSERT INTO leu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Layaan a ngaas i taxa rul e a Yaan ina Fangaafusan a taxapus, a rabuna ri lisan a mu rabuna aava ri giis xe si Yesus. Nane tao nari saxa saxa pana mana e ri feroxo faꞌulaa. ");
INSERT INTO leu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","E vaxa, a mu vovau saat ri taꞌulan a maana rabuna xaves. Ri taꞌulan nari e ri xukulai faagut malaan, “Nano, no Lak sina Piran.” Taasaxa nane baras nari talo ri taa pife ferawai senaso ri texaas o nane ve a Mataa Failai sina Piran. ");
INSERT INTO leu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","La paanen lolof na Yesus a falet xe la bina gof talo i taa waan nane sang. A rabuna ri senge e layaan ri tingine ri rao ri tivotane o i muta taꞌulan nari. ");
INSERT INTO leu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Taasaxa nane kuus, “Ne taa kuusan fasavat a Lagasai Roxo sena fatataganan sina Piran la xasano bina sait. Nabeꞌ ve a faisok aava Piran a fengau xena vile.” ");
INSERT INTO leu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","E nane sangas xolai e a ferawai lana maana lifu ina faxuvulan xaves pe Judia. ");
INSERT INTO leu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","2","Saxa yaan layaan na Yesus taxa tigina la itina raarum Genasaret, a malila ri maa fakaliuane xena langaiaana ferawaian sina Piran. I taxa tigina pave e a xalum a ro xaati re taxa nai la vangana raarum. A mu rabuna ina faadinan ri taꞌulan fanei a xaati pave xena xamaxaana mu vana siri. ");
INSERT INTO leu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nane laak xuluna saxa aava si Saimon e a xuuse rao i taa sasagen famodaxe sena gun. E bak nane nai lana xaati xena fapiti a rabuna. ");
INSERT INTO leu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Layaan nane fataxapin a fepitaian sina, nane xuus na Saimon, “Falet la nobina aava tu e mi tapin fasivi a mu vana xena siak din.” ");
INSERT INTO leu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na Saimon a suie, “Matalava, maam fo faisok faagut la vung xurul e piau ta din. Taasaxa nano, no ferawai e ne taa langai siim e ne taa tapin fadui a vana.” ");
INSERT INTO leu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Layaan ri vil malaane, a mu din aava ri siaxe a matafan temasaat e a mu vana siri rao ri tiririk. ");
INSERT INTO leu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Re talangai pana mare xe sina saxano taure aava re taxa waan la xasa xaati e re maa savat xena xakaavang. Lana ro xaati aave a matafanan ina din a molava paaliu e faasilak a ro xaati aave re taa lus. ");
INSERT INTO leu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Layaan na Saimon Pita a xalum a mo aanabeꞌ nane bukaak la ka Yesus e a kuus, “Faapalau sega Memai, nenia, ne mataa mosaat.” ");
INSERT INTO leu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A ferawai malaan senaso nane e mu tauna ri ipul faagut paaliu pana maana din ri fo siaxe. ");
INSERT INTO leu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Na Jems e na tina Jon, a ro lak si Sebedi aava re faisok xuvul pa Saimon, nare vaxa re ipul. E na Yesus a xuus na Saimon, “Muta mataut. Ti la yaan aanabeꞌ no taa pataas a rabuna.” ");
INSERT INTO leu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","E voxo ri yuuf falak a ro xaati siri xe xuluna gun e ri taꞌulan faneie suꞌ xuvul pana maana mo siri e ri fe usie. ");
INSERT INTO leu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Layaan na Yesus a waan la saxa bina, saxa mataa tana tapak xapiak a savat sina. Layaan a xalum na Yesus, nane poxo pana nonau ina xe lapia e a nunge, “Memai, tamo no vubuxane no fexaxaas sena vil faroxoiau.” ");
INSERT INTO leu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na Yesus a talangai xe sina, a tawe e a kuus, “Ne vubuxane. Savat roxo.” E fataapus paaliu a giisan tapak a taꞌulane. ");
INSERT INTO leu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","E na Yesus a xuuse, “Muta xuus a rabuna pana. Falet e no fe faxalit a mu priis pana taam e tatavai xe sina Piran sena roxoyan siim pana mo aava na Moses a kuus pana. A tatavai aanabeꞌ i taa faxalit a mu rabuna pana roxoyan siim.” ");
INSERT INTO leu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Taasaxa maana rabuna xaves fulaa ri langai pana e a malila ri maa savat xena langaiaana talo i taa vil tapin a maana giisan siri. ");
INSERT INTO leu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Na Yesus a taꞌulan nari e a falet xe la bina vingil xena fenung. ");
INSERT INTO leu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Saxa yaan layaan i taxa fepitaa, a mu Ferasi e rabuna ina fepitaa pana vuputkai, ri maa savat ti la maana mu bina pe Galili e ti Judia. E a gutan sina Memai a waan xuluna xena vil faroxoiaana rabuna pana giisan. ");
INSERT INTO leu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Saxano rabuna ri yaasmaan a saxa mataa maalapen xuluna ivin xena lisan falaxe xe la lifu aava na Yesus i taxa waan lana. ");
INSERT INTO leu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Taasaxa ri pife fexaxaas senaso a malila ri fabas a lifu aave. E voxo ri laak xe laaꞌui la putuna lifu e ri ngas a xavil ina putuna lifu aave xena faduiaana xe lapia xuvul pana ivin sina. E ri timine la no Yesus la palou ina rabuna. ");
INSERT INTO leu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Layaan na Yesus a xalum a mo ri fo vile sena namkaian siri, a kuus, “Fesing, a mu vilaana saat siim fo lamon tapinan.” ");
INSERT INTO leu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A mu Ferasi e mu rabuna ina fepitaa pana vuputkai, ri ilisai, “A mataa aanabeꞌ aava ferawai fasaat sena Piran, nane a so ta buk mataa? Naseꞌ fexaxaas sena lamon tapin a vilaana saat? A Piran sang mon.” ");
INSERT INTO leu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Na Yesus a texaas sena lamonan siri e a fiai, “Xenaso mi taxa lo lalamon malaan lana xunus imi? ");
INSERT INTO leu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","A so ta vapaling a peraroxo xena kuusanaana, ‘A vilaana saat siim fo lamon tapinan’ o ‘Tamasiak e no sangas?’ ");
INSERT INTO leu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ne vubuk rao mi taa texaas o a Natuna Mataa a toxan a gutan nabeꞌ la xavala xena lamon tapinaana vilaana saat.” E voxo nane kuus xe sina maalapen, “Ne xuus nano, tamasiak, siak a ivin siim e no falet xe la lifu siim.” ");
INSERT INTO leu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Fataapus paaliu nane tigina la matari e a siak a ivin sina e fe paan xe la lifu sina e taxa lo faatulan a Piran. ");
INSERT INTO leu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nari xapiak ri ipul e ri faatulan a Piran sait. Ri bas pana matautan e ri kuus, “Tanin, taara fo xalum a maana mo faꞌipul roxo.” ");
INSERT INTO leu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lamina mo aanabeꞌ na Yesus a savat xe lamalei e fe xalum a mataa i taxa nai la lifu ina taakis, a isina na Matiu Livai. E na Yesus a xuuse, “Usiau.” ");
INSERT INTO leu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nane tamasiak e taꞌulan a maana mo xapiak aave xena usiaan na Yesus. ");
INSERT INTO leu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Na Livai moxo a vil a saxa matafanganai molava la lifu sina xena faxalitaana suaian sina se Yesus. A mu rabuna ina siak taakis e xasano rabuna fulaa aava nane xel nari vaxa, ri maa fangan xuvul pare. ");
INSERT INTO leu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Taasaxa mu Ferasi e mu rabuna ina fepitaa pana vuputkai aava ri taxa waan lapaana mu Ferasi, nari xapiak ri fefinaas xe sina mu fefeng si Yesus e ri kuus, “Xenaso mi taxa fangan e num xuvul pana mu rabuna ina siak taakis e nari aava ri fuuna vil a saat?” ");
INSERT INTO leu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","E na Yesus a sui nari, “A rabuna aava ri giis sang mon ve ri vubuxan a mataa xena irin faroxoi nari taasaxa rabuna aava ri pi ta giisan ve, piau. ");
INSERT INTO leu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ne pife savat xena xelaana rabuna roxo, piau. Ne savat xena xelaana rabuna pana vilaana saat talo ri taa puk tapin nari xa xasena vilaana saat siri.” ");
INSERT INTO leu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","E ri fine, “A malaafaa mu rabuna aava ri usi na Jon ri fuuna fenung e ri falfaal e mu rabuna aava ri usi a mu Ferasi vaxa ri vivil malaane. Taasaxa mu rabuna aava ri usi nano va sou ri fuuna fangan e num?” ");
INSERT INTO leu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","E na Yesus a sui nari, “A mu fesing sina mataa aava tamai, ri pi falfaal la yaan ina maraan tefin senaso a yaan aave ve a yaan ina faamamaasan. ");
INSERT INTO leu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Taasaxa yaan i taa savat layaan a mataa aava tamai i taa siak tapinan seri e bak ri taa falfaal.” ");
INSERT INTO leu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nane xuus nari pana ferawaian paap aanabeꞌ, “Piau ta mataa i taa ririk a marapi faꞌui xena kap a marapi xavai. Tamo a vil malaane i taa kawaasan a marapi faꞌui e a xavil aave i taa pife fexaxaas sena marapi xavai. ");
INSERT INTO leu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","E piau ta mataa i taa xapis a fanganan lana vaafa xavai. Tamo i taa vil malaane a vio i taa laak lana e i taa kawaasan a vaafa xuvul pana fanganan xapiak lana. ");
INSERT INTO leu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Piau, nane taa xapis a fanganan lana vaafa faꞌui. ");
INSERT INTO leu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","E saxanofuna ri taa kuus, ‘Ne vubuxan a fanganan ti lana uma xavai, a fanganan aave a fexaxaas sega.” ");
INSERT INTO leu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","La saxa Yaan ina Fangaafusan na Yesus xuvul pana mu fefeng sina, ri sangas lana uma baali e a mu fefeng sina xo ri taxa lo vuak a putuna baali e ri ruruxe la mari xena nganaana. ");
INSERT INTO leu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Saxano Ferasi aava ri taxa waan pave ri fiai, “Xenaso mi taxa vil a mo aava mu vuputkai ina Yaan ina Fangaafusan a kuus votai pana?” ");
INSERT INTO leu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na Yesus a sui nari, “Mi pife kat lunaian a vilaana si Devit layaan nane xuvul pana mu fesing sina ri lagai, bo? ");
INSERT INTO leu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nane laak la lifu sina Piran e siak a bret taap aava fanganan sina mu priis sang mon e a ngane e tavai vaxa mu fesing sina pana.” ");
INSERT INTO leu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na Yesus moxo a xuus nari, “A Natuna Mataa ve a Memai ina Yaan ina Fangaafusan.” ");
INSERT INTO leu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","La xasa Yaan ina Fangaafusan nane laak la lifu ina faxuvulan e i taxa fepitaa. E lana lifu aave a toxan a mataa aava mana muaan a maat. ");
INSERT INTO leu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","A mu Ferasi e mu rabuna ina fepitaian pana vuputkai aava ri taxa waan pave, ri taxa seng ta mo xena gel tifiaan na Yesus. E voxo ri falim fatateaxe tamo i taa vil faroxoi ta mataa la Yaan ina Fangaafusan. ");
INSERT INTO leu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Taasaxa, na Yesus fo texaas sena lamonan siri e a kuus xe sina mataa aava mana maat, “Tamasiak, e no tigina la matari.” Nane tamasiak e fe tigina. ");
INSERT INTO leu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","E na Yesus xo a kuus xe siri, “Ne fin nami, la Yaan ina Fangaafusan taara taa usi a vuputkai sitaara malaafaa: taara taa vil a mo roxo o a mo mosaat, taara taa fakaxup a mataa o taara taa kawaasane?” ");
INSERT INTO leu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nane kaalum xolai xe siri xapiak e a kuus moxo xe sina mataa aave, “Faxaradak a maam.” Nane langai e a mana moxo roxo faꞌulaa. ");
INSERT INTO leu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Taasaxa nari, ri marala faagut e ri fefiai la palou iri o ri taa vil malaafain na Yesus. ");
INSERT INTO leu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lana yaan aanabeꞌ na Yesus a laak xe xuluna put xena fenung xe sina Piran. A fenung pave la vung xapiak. ");
INSERT INTO leu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Layaan a bina xo paanen a xel faxuvul a mu fefeng sina e siak fati a sangafilu saxa pana taragua siri e a faꞌisin nari pana yaamut sina: ");
INSERT INTO leu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","na Saimon aava faꞌisine pa Pita, na Endru aava ti Pita, na Jems, Jon, Filip, Baatalamiu, ");
INSERT INTO leu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomas, a xasa Jems aava lak si Elfias, Simon aava xasa isina na Selot ");
INSERT INTO leu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Judas a lak si saxa Jems fulaa e na Judas Iskeriot aava pet lisan na Yesus. ");
INSERT INTO leu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nane sivi xuvul pari e fe tigina la bina xaradak. A malila aava ri usie ri waan e maana rabuna xaves ti la mu bina pe Judia, ti Jerusalem, Tair e na Saidan vaxa ri waan. ");
INSERT INTO leu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ri fo savatmaan xena langaie e talo i taa vil faroxoi a maana giisan siri. Nari aava ri giis pana vovau saat nane vil faroxoi nari vaxa. ");
INSERT INTO leu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","E a mu rabuna rao ri tawe senaso a gutan ina faroxoiaan nari a waan la tana. ");
INSERT INTO leu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nane kaalum xe sina mu fefeng sina e a kuus, “Faamamaas, nami aava mi valagof senaso mi waan lana fatataganan sina Piran. ");
INSERT INTO leu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Faamamaas, nami aava mi lagai naboxo senaso mi taa maasi. Faamamaas, nami aava mi taangiis naboxo senaso mi taa nangan. ");
INSERT INTO leu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Faamamaas nami aava rabuna ri baian nami e ri feng tapin nami e ri ferawai fakasal nami e ri gilis a isimi malaan sena isin saat senaso mi usi fatak a Natuna Mataa. ");
INSERT INTO leu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","A mu bumi, ri rabuna saat e ri vil malaane xe sina mu rabuna ina kuus fatuxai sina Piran vaxa. E voxo mi taa lalaas pana faamamaasan layaan a maana mo aanabeꞌ a savat la taagulan simi senaso a sepirigus molava taxa waan bang nami laaꞌui la xunavata. ");
INSERT INTO leu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Taasaxa kaari, nami aava mi toxan a fafanaian xaves senaso mi fo siak xapin xo a maana mo roxo. ");
INSERT INTO leu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kaari, nami aava mi fo maasi pana maana buk fanganan naboxo senaso mi taa lagai. Kaari, nami aava mi faamamaas e nangan naboxo senaso mi taa taangiis e mi taa mamaaluk. ");
INSERT INTO leu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Layaan a mu rabuna xapiak ri suaian nami kaari, senaso a mu buri, ri vil malaane xe sina mu rabuna ina kuus fatuxai bit. ");
INSERT INTO leu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Taasaxa ne xuus nami aava mi langaiau: vubuxan xasingit a mu xaiyaas simi e bilai faroxo xe sina rabuna aava ri baian nami. ");
INSERT INTO leu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ferawai faroxo sena rabuna aava ri fatutul nami e fenung pari aava ri bilai fasaat xe simi. ");
INSERT INTO leu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tamo mataa taa sip nano la yaavaam lavaxa, puk lisanet a xasa payaavaam. Tamo mataa taa siak a marapi ina vupungan simi, muta ti votane sena siaxaan ta saxa marapi simi fulaa. ");
INSERT INTO leu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tamo rabuna ri fin nami pana mo, tavai nari pana so ta buk mo ri vubuxane. E tamo mataa a siak a mo simi, muta nung faꞌulie. ");
INSERT INTO leu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Bilai xe sina xasanofuna malaan seꞌ mi vubuk o ri taa bilai xe simi. ");
INSERT INTO leu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Malaafaa mi taa siak a roxoyan tamo mi vubuxan xasingit mon nari aava ri vubuxan xasingit nami? Senaso a mu ‘rabuna saat’ vaxa ri fuuna vubuxan naseꞌ aava vubuxan nari. ");
INSERT INTO leu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","E tamo mi bilai faroxo xe siri aava ri bilai faroxo xe simi, malaafaa mi taa siak a roxoyan? Senaso a mu ‘rabuna saat’ vaxa ri fuuna vil malaane. ");
INSERT INTO leu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","E tamo mi taa tavai a mataa pana mo e nane fexaxaas sena suie, malaafaa mi taa siak a roxoyan. Senaso a mu ‘rabuna saat’ vaxa ri fuuna vil malaane. ");
INSERT INTO leu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Taasaxa nami, mi taa vubuxan xasingit a mu xaiyaas simi, vil a faisok roxo xe siri, tavai nari pana mo e muta lamon pana yaan ri taa lisan faꞌulie. Tamo mi taa vil malaane a sepirigus simi i tafe molava e mi taa savat rafulak sina Piran Laaꞌui Paaliu, senaso nane vaxa fangasik nari aava ri vil a saat e ri pife kuus faasiroxo. ");
INSERT INTO leu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nami, mi taa muluk a rabuna malaan se Tamami a muluk nari. ");
INSERT INTO leu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Muta tiis a mataa e no taa pife waan lapaana tiisan. Muta xalum fasivi a saxa mataa e pi ta saxa i taa xalum fasivi nano. Lamon tapin a mu vilaana saat sina xasano rabuna e a mu vilaana saat simi ri taa lamon tapinan. ");
INSERT INTO leu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Tatavai e no taa saaxam. Tamo no taa tifi fasoliu a bi pana maana mo xena tatavai e no pife faxarang ta mo, no taa saaxam malaan sait. Pana vilaana aava mi tatavai pana mi taa saaxam malaan.” ");
INSERT INTO leu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","E nane ferawai paap xe siri, “A mataa piif vaxa fexaxaas sena paamuian a xasa mataa piif, bo? Piau, nare xapiak re taa poxo lapi la vaaꞌul. ");
INSERT INTO leu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","A lak aava nai lapaana saxa mataa ina fepitaa, pife lava sena saxa aava fapitie, taasaxa naseꞌ ta mataa a toxan a texaasan xapiak a malaan sena mataa ina fepitaa sina. ");
INSERT INTO leu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Xenaso no xalum a pof la mata tiam e no pife lamon pana wai lava aava i taxa waan la mataam? ");
INSERT INTO leu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Malaafaa no taa xuus na tiam, ‘Tiak, ne taa siak tapin a fomirak xawa la mataam’ layaan nano xa no pife xalum a wai lava la mataam? Nano, no xalema maranga, paamua no taa siak tapin a wai lava la mataam e mui no taa kaalum faroxo xena siak tapinaana fomirak xawa la mata tiam. ");
INSERT INTO leu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Pi ta wai roxo a fufuain a xalana wai saat e pi ta wai saat a fufuain a xalana wai roxo. ");
INSERT INTO leu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mi taa texaas sena mu wai roxo e saat pana xalana. Pi ta mataa i taa murul a xakaap xuluna yeis tuturuk o siak a xalana wain xuluna yeis tuturuk. ");
INSERT INTO leu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","E malaan, a mataa roxo i taa lisan fasavat a maana vilaana roxo aava waan la xunus ina. E a mataa saat i taa fasavat a maana vilaana mosaat aava waan la xunus ina. E voxo a mataa i taa ferawai pana maana mo aava fabas a xunus ina. ");
INSERT INTO leu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Senasou mi xaliau pana ‘Memai, Memai.’ taasaxa mi langai pesalai? ");
INSERT INTO leu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","A mataa aava savat siak xena langaiau e a usi a ferawaian siak, nane malaan sena ");
INSERT INTO leu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","saxa mataa aava vesan a lifu. Nane kaaf fasivi talo a fufuna lifu i taa nai xuluna faat. Layaan a raafui e reref molava savat, a gutan ire a fiit faagutan a lifu naang e a tigina fatateak paaliu senaso nane vesan faroxoie. ");
INSERT INTO leu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Taasaxa saxa aava langaiau e pife usi a ferawaian siak a malaan sena mataa aava vesan fatapusan a lifu sina e a fufuna pife tateak. Layaan a ulim a vaxe, a poxo e a kawaasan xapinan.” ");
INSERT INTO leu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","A maana rabuna xaves ri langai a ferawaian aanabeꞌ si Yesus e layaan fetaxapus nane laak xe pe la bina Kapanam. ");
INSERT INTO leu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","E pave a sisiak sina saxa matalava ina rawen a giis fasaat e faasilak rao i taa maat. E a sisiak aave, a mataa tafuna a lalamon faroxo pana. ");
INSERT INTO leu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","E a mataa naang a langai se Yesus e a feng a saxano matalava sina mu Juda xe sina xena fine o i taa filimaan xena vil faroxoi a sisiak sina. ");
INSERT INTO leu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Layaan ri savat si Yesus ri nung faagutane e ri kuus, “A mataa aanabeꞌ a vubuxan xasingit a mu Juda e fo vesan a lifu ina faxuvulan sitaara. E voxo i taa roxo paaliu tamo no taa xavange.” ");
INSERT INTO leu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","E voxo na Yesus a falet xuvul pari. Nane taxa waan lasuun famodak lunai sena lifu e a mataa ina rawen aave a feng a mu fesing sina xe si Yesus xena xuuse, “Memai, nenia, ne mataa palau mon, muta laak la lifu siak. ");
INSERT INTO leu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ne pife savat xe siim senaso ne texaas o nenia, ne mataa palau. Taasaxa no kuus mon e a sisiak siak i taa roxo fulaa. ");
INSERT INTO leu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ne texaas sena tateaxan senaso nenia xa ne waan lapaana tateaxan ina paamua siak e vaxa ne toxan a xasanofuna fulaa aava ri waan lapaana tateaxan iga. Ne xuus a saxa ‘Falet!’ e nane falet e xe sina xasafuna, ‘Filimaan!’ e nane filimaan. Ne xuus a sisiak ‘Vile!’ e nane vile.” ");
INSERT INTO leu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Layaan na Yesus a langaie nane ipul sena e a puk nane xe sina malila aava ri taxa usie e a kuus, “Ne pife tingin ta mataa pe Israel pana namkaian aava molava sena namkaian aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","E a mu fefeng sina paamua ti Rom ri ulaa xe la lifu e ri fe tingin xo a sisiak naang a roxo mon. ");
INSERT INTO leu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Na Yesus a taꞌulan a bina aave e fe paan xe la bina Nein e mu fefeng sina xuvul pana malila ri falet xuvul pana. ");
INSERT INTO leu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","I taxa waan lunai la nonamalei e a rabuna ti pave ri taxa yaas fasavat a saxa mamaat e nane ve a lak tomexaan saxa mon sina saxa tefin nakmaal. E a malila ti la bina ri waan xuvul pana. ");
INSERT INTO leu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Layaan a Memai a xalume, nane muluxe e a kuus, “Muta taangiis.” ");
INSERT INTO leu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nane fe tao a ivin ina mamaat e nari aava ri taxa yaase, ri tigina. Nane kuus, “Mataa faꞌui, ne xuus nano, tamasiak!” ");
INSERT INTO leu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","E a mamaat naang moxo nai saa e i taxa ferawai. E na Yesus a lisan faꞌulie xe si ninana. ");
INSERT INTO leu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nari xapiak, ri bas pana ipulan e ri kuus fati a isina Piran e ri kuus, “A mataa ina kuus fatuxai fo savat la palou itaara. A piran fo filimaan xena xavang a rabuna sina.” ");
INSERT INTO leu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","A lagasai aanabeꞌ pa Yesus a falet xolai pe Judia e la nu bina faasilak. ");
INSERT INTO leu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","A mu fefeng si Jon ri kuusan a maana mo aanabeꞌ xe si Jon layaan nane taxa vipis. E nane xel a xasa rovaat e a feng nare xe si Memai xena finaana, “Nano va no saxa aava maam taxa waan bange o maam taa kaalum sena xasafuna?” ");
INSERT INTO leu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Layaan a rovaat aave re savat si Yesus re xuuse, “Na Jon ina Fasufan a fengmaan nemaame xena fin nano o nano ve no saxa aava i taa filimaan o maam taa waan bang a xasafuna?” ");
INSERT INTO leu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lana yaan naang na Yesus a vil faroxoi a maana rabuna aava ri giis o maasak o nari aava vovau saat a vao nari. E a vil faroxoi a rabuna matari piif. ");
INSERT INTO leu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","E voxo nane sui a mu fefeng aave, “Ulaa xe si Jon e mi fe xuuse pana maana mo mi fo xalume e mi fo langaie: a rabuna piif ri kaalum fulaa, a rabuna kari tapil ri sangas fulaa, nari pana tari tapak ri toxan a vipin faꞌui fulaa, a rabuna vaang ri langai fulaa, nari aava ri maat ri to faꞌulaa e a mu rabuna valagof ri langai a Lagasai Roxo. ");
INSERT INTO leu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","A rabuna aava ri pife puk tapin nari xa xasega ri taa faamamaas.” ");
INSERT INTO leu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Lamina faletan sina ro fefeng si Jon, na Yesus a ferawai xe sina malila pa Jon. “Layaan mi falet xe la xobingil mi lamon o mi taa xalum a so ta buk mo? A yi aava reref taxa falep xolane, bo? ");
INSERT INTO leu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","E tamo piau, mi fe xalum so ta buk mo? A mataa pana marapi roxo paaliu? Piau, nari aava ri falak a marapi pana mamareiai molava e ri toxan a maana mo xaves, ri fuuna taagul lana lifu sina mu piran king. ");
INSERT INTO leu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Taasaxa, mi fe laak xena xalum a so ta buk mo? A mataa ina kuus fatuxai? Aang, ne xuus nami a mataa aave, na Jon, a pelalava sena mu rabuna ina kuus fatuxai xapiak. ");
INSERT INTO leu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Lana Xakalayan sina, a Piran a kuus pa Jon layaan a kuus malaanabeꞌ: ‘Paamuina savatan siim ne taa feng a fefeng siak xena faigotan a salan xaanum.’ ");
INSERT INTO leu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne xuus nami o a lutefin ri fo luuk a maana rafulak xaves taasaxa na Jon a pelalava seri. E fulaa, a saxa xiufamaak lana fatataganan sina Piran a pelalava se Jon.” ");
INSERT INTO leu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(A mu rabuna ina siak taakis e xasanofuna layaan ri langai a ferawaian si Yesus, ri turoxo o a vilaana e lamonan sina Piran, re roxo. Ri turoxo pana senaso na Jon fo fasuf nari. ");
INSERT INTO leu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Taasaxa mu Ferasi e mu rabuna ina fepitaa pana vuputkai ri tisui a vubuxanan sina Piran xari senaso ri baian a fasufan si Jon.) ");
INSERT INTO leu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","E na Yesus a kuus, “A mu rabuna aava ri taxa to naboxo, ri malaafaa? Ne taa ferawai paap pari malaafaa? ");
INSERT INTO leu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nari, ri malaan sena rafulak aava ri taxa nai la bina ina faasot e ri taxa felingai malaan: ‘Maam piif a tungaal xe simi e mi pife tia. Maam tangiis a mamaat e mi pife taangiis.’ ");
INSERT INTO leu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Naak piau ta mo i taa fafaamamaas nami, bo? Senaso na Jon ina Fasufan pife ngan a bret o num a wain e nami, mi kuus o a vovau saat a vawe. ");
INSERT INTO leu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","E a Natuna Mataa maa fangan e num e mi kuus, ‘Nane a mataa ina fangan e num vulai e a fesingan a mu rabuna ina siak taakis e xasanofuna pana vilaana saat. ");
INSERT INTO leu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Taasaxa mu rafulak pana texaasan tuuna ri taa turoxo pana mu vilaana roxo.” ");
INSERT INTO leu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","A saxa Ferasi xo a fin na Yesus rao i taa fangan xuvul pana e nane falet xe la lifu sina Ferasi aave e fe mati fapet la ivin. ");
INSERT INTO leu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pe la bina aave a toxan a saxa tefin aava fo taagul lana vilaana saat. E layaan a langai o na Yesus taxa fangan la lifu aave nane siakmaan a wel aava lasan ina a roxo paaliu e a mamareiai ina vaxa a molava temasaat. ");
INSERT INTO leu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nane maa tigina taangiis la ka Yesus e a xamak a kana pana raarum ti la matana. E a fapagalaye pana fui sina e a nguse e mui tiuan a mo lalas aave xuluna kana. ");
INSERT INTO leu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Layaan a Ferasi naang aava fo xel na Yesus xe la lifu sina, a xalum a vilaana aanabeꞌ nane ilisai, ‘Tamo a mataa aanabeꞌ a mataa ina kuus fatuxai tuuna i taa texaas seꞌ naseꞌ taxa tawe e nane a so ta buk tefin- a tefin pana vilaana saat.’ ");
INSERT INTO leu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Na Yesus fo texaas sena lamonan sina e a xuuse, “Saimon, a toxan a mo ne buk xuus nano pana.” E nane suie, “Ferawai saa, Mataa ina Fepitaa.” ");
INSERT INTO leu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","E na Yesus a kuus, “A mataa taragua re toxan a faat re siaxe sina saxa mataa ina faasot pana faat. Saxa fo siak a faat fexaxaas sena K2,000 e a xasa siak K200. ");
INSERT INTO leu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Nare xapiak re piau ta faat xena sui faꞌuli a faat re fo siaxe e voxo a mataa ina faasot pana faat a fataxapin a faat re siaxe sena. E naboxo, a vubuxanan siseꞌ i taa pelalava?” ");
INSERT INTO leu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Na Saimon a suie, “Naak a saxa aava fo siak a faat moxaves.” Na Yesus a kuus, “No fo lamon faroxo.” ");
INSERT INTO leu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","E nane puk nane xa xe sina tefin aave e a kuus xe si Saimon, “No xalum a tefin aanabeꞌ? Nenia, ne laak la lifu siim e no pife tavaiau pana raarum xena xamaxaana kaak taasaxa nane xamak a kaak pana raarum ti la matana e fapagalaye pana fui ina. ");
INSERT INTO leu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Layaan ne laak la lifu siim no pife ngusau. Taasaxa tefin aanabeꞌ taxa lo ngus faxavesan a kaak. ");
INSERT INTO leu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","No pife timin a wel la putok taasaxa nane fo tiuan a wel pana lasan roxo la kaak. ");
INSERT INTO leu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","E voxo ne xuus nano o a maana vilaana saat sina ri fo lamon tapinan. E a vubuxan xasingitan molava sina a faxalit nami pana. Taasaxa saxa aava fo lamon tapinan pana mo modak mon, a vubuxan xasingitan sina i taa modak mon.” ");
INSERT INTO leu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","E na Yesus moxo a kuus xe sina tefin aave, “A mu vilaana saat siim ri lamon tapinan.” ");
INSERT INTO leu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A xasanofuna aava ri taxa waan la lifu, ri fefiaian nari xa, “Nane a so ta buk mataa aava lamon tapin a vilaana saat?” ");
INSERT INTO leu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","E na Yesus a kuus xe sina tefin aave, “A namkaian siim fo fakaxup nano, falet lana luaian.” ");
INSERT INTO leu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Lamina, na Yesus taxa falet xolai la mu bina xena kuusan fasavat a Lagasai Roxo sena fatataganan sina Piran. E a mu yaamut sangafilu saxa pana taragua ri falet xuvul pana. ");
INSERT INTO leu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","E saxano lutefin vaxa aava nane vil faroxoi nari sena giisan e sena vovau saat aava vao nari, ri doxote: Maria (a xasa isina na Mekdala) aava toxan a mu vovau saat pisiguak e ri fo taꞌulane, ");
INSERT INTO leu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","na Joaana, a tefin si Susa aava paamuian a maana mo la lifu si Herot, na Susaana e xasanofuna. A lutefin aanabeꞌ ri xavang na Yesus e mu yaamut sina e ri tavai nari pana mu faat. ");
INSERT INTO leu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Layaan a malila ti la mu bina xaves ri maa faxuvul xena langaiaan na Yesus, nane xuus nari pana ferawaian paap aanabeꞌ: ");
INSERT INTO leu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“A mataa ina taraꞌuma a falet xena xapis a mu kam sina. Layaan nane taxa tapalan a mu kam la uma, saxano kam ri poxo la salan; a rabuna ri paasane e mu maanu ri ngane. ");
INSERT INTO leu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Saxano kam ri poxo la nobina toxai faat e layaan ri boak ri femaiyang senaso piau ta raarum. ");
INSERT INTO leu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xasano kam ri poxo lana yeis tuturuk aava boak fataapus e fexafut nari e ri pife fuaa. ");
INSERT INTO leu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Xasanofuna ri poxo la xavala roxo e ri palak faroxo paaliu e ri fuaa faroxo. Ri fasavat a kam xaves paaliu liu nari aava xapisan.” Layaan nane fo kuus malaan, a xukulai, “Nami aava mi pife rabuna vaang, lalamon pana mo mi fo langaie e mi taa masame.” ");
INSERT INTO leu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","A mu yaamut sina ri fine pana malasuf ina ferawaian paap aave. ");
INSERT INTO leu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","E nane sui nari, “A texaasan sena mo fufunai sina fatataganan sina Piran ne taa xuus famatavas nami pana taasaxa xe sina xasanofuna ne taa ferawai paap mon talo: ‘Ri fexaxaas sena xalume taasaxa ri taa pife taraxalie, ri fexaxaas sena langaie taasaxa ri taa pife masam.” ");
INSERT INTO leu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Nabeꞌ ve a malasuf ina ferawaian paap aave: a kam a malaan sena ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nari aava la salan, ri langai taasaxa na Setan i taa siak tapin a Ferawaian la xunus iri e ri taa pife namkai xena fakaxupan. ");
INSERT INTO leu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Nari aava la bina faat, ri langai e ri faamamaas pana Ferawaian aave taasaxa ri piau ta xarei. Ri namkai pana lou modak mon e mui layaan a vavalam a savat ri poxo lana namkaian siri. ");
INSERT INTO leu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","A kam aava poxo lana yeis tuturuk a malaan seri aava ri langai e ri usie taasaxa mu mamaxusan, fafanaian e a vubuxanan siri, ri punuk a namkaian e ri pife palak. ");
INSERT INTO leu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Taasaxa mu kam aava la xavala roxo ri malaan seri aava xunus iri a xaradak e roxo. Ri langai a Ferawaian e ri tao fatateaxe e ri faisok faagut vulai xena fasavat a maana vilaana roxo. ");
INSERT INTO leu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Pi ta mataa i taa faram a laam e fune lana xariu o timine lapaana ivin, piau, i taa fatofane la xok talo nari aava ri laak la lifu ri taa xalum a malang ina. ");
INSERT INTO leu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","A maana mo aava xaweian ri taa talakas e a maana mo aava fufunai ri taa waan la matavas e mu rabuna ri taa texaas sena. ");
INSERT INTO leu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","E voxo lamon faroxo pana so ta mo no fo langaie. A mataa aava toxan a maana mo xaves i taa tavaian pana maana mo fulaa e a mataa aava pi ta mo, a so ta mo modak aava nane toxane, i taa siak tapinan xasena.” ");
INSERT INTO leu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","A malila ri kaliuan na Yesus e layaan na ninana e mu tina xo ri savat xena xalumaana ri pife fexaxaas sena laak soxote. ");
INSERT INTO leu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","E saxa mataa xo a xuuse, “Na ninaam e mu tiam ri taxa tigina pe lamalei, rao ri xalum nano.” ");
INSERT INTO leu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","E nane suie, “Na ninaang e mu tiak movoxo nari aava ri langai a Ferawaian sina Piran e ri usie.” ");
INSERT INTO leu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Saxa yaan na Yesus a xuus a mu fefeng sina, “Taara taa falet xe la xasa paxasing ina raarum.” E voxo ri xawas xuluna xaati e ri fepaan. ");
INSERT INTO leu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","La fena faletan siri nane matef. A reref a sivimaan ti xuluna put e a fasavat a xaing molava. A raarum a laak lana xaati e faasilak paaliu ri taa lus. ");
INSERT INTO leu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A mu fefeng ri faparaye e ri kuus, “Memai, Memai, taara taa xarak.” Nane tamasiak e baras a reref e xaing e re feluai e a raarum femararol. ");
INSERT INTO leu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","E nane fin a mu fefeng sina, “A namkaian simi faa?” Lana matautan e ipulan siri, ri fefiaian nari xa, “Nane ve a so ta buk mataa? Nane kuus faagut e a reref e raarum re langaie?” ");
INSERT INTO leu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ri falet xe la nobina sina mu Gerasin aava waan la paxasing ina Laman Galili. ");
INSERT INTO leu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Layaan na Yesus a ung, a mataa ti la bina aave aava bas pana mu vovau saat, maa savat sina. Pana mariaas xaves nane pi falak ta nemarapi e pife taagul lanꞌ ta saxa lifu. Nane fuuna taagul si pe la matana xawaa. ");
INSERT INTO leu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Layaan a xalum na Yesus, a taangiis falava e bukaak la kana e xukulai faagut, “Rao no sivinau Yesus, Lak Tomexaan sina Piran Laaꞌui Paaliu? Ne nung nano o no muta fakasanamau.” ");
INSERT INTO leu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","A ferawai malaan senaso na Yesus a xuus faagutan a mu vovau saat rao ri taa taꞌulan a mataa aave e ri savat lamalei. A maana yaan xaves a vovau saat a yote naapalaan a mu rabuna ri fo bugut a mana e kana pana ‘sein’ e ri faxatange. Taasaxa layaan a mu vovau saat aave ri fagute nane fuuna piit a ‘sein’ sina e mu vovau saat aave ri xupe xe pe la bina vingil. ");
INSERT INTO leu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Na Yesus a fine, “A isaam naseꞌ?” E nane suie, “Aami” senaso maana vovau saat ri fo vawe. ");
INSERT INTO leu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","E ri nung faxavesane rao i muta feng tapin nari xe lana vaaꞌul aava piau ta taxapusan ina. ");
INSERT INTO leu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","A toxan a tagaan vio ri taxa fangan pave la xasing ina put. E mu vovau saat ri nung na Yesus rao i taa feng falak nari xe lana mu vio aave e nane turoxoian nari. ");
INSERT INTO leu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Layaan a mu vovau saat ri taꞌulan a mataa aave ri felaak lana mu vio e nari, ri fala ti laaꞌui xuluna put xe lapi la raarum e ri fexarak. ");
INSERT INTO leu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Layaan nari aava ri fuuna faxatang a mu vio, ri xalum a mo aava fo savat ri sinuf e ri fe kuusane lana maana mu bina faasilak. ");
INSERT INTO leu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","E a maana rabuna ri falet xena xalumaana so ta buk mo fo savat. Layaan ri savat si Yesus, ri maa tingin xo a mataa aava mu vovau saat ri fo taꞌulane. E nane fo mawas pana marapi e i taxa nai la ka Yesus e a lamonan sina fo roxo faꞌulaa. E nari, ri mataut. ");
INSERT INTO leu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nari aava ri fo xalum a vil faroxoiaana mataa aave ri kuusane. ");
INSERT INTO leu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","E a mu rabuna xapiak ti la bina sina mu Gerasin ri xuus na Yesus o i taa taꞌulan nari senaso a matautan molava fo siak nari. E voxo nane fe xawas xuluna xaati e ri fe paan. ");
INSERT INTO leu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A mataa aava mu vovau saat ri fo taꞌulane, a nung na Yesus o i taa falet xuvul pana taasaxa na Yesus a feng faꞌulie e xuuse, ");
INSERT INTO leu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ulaa xe la bina siim e no fe kuusan a maana mo roxo aava Piran fo vile sema.” E voxo a mataa aave a falet e fe kuusan xolan a maana mo roxo na Yesus fo vile sena. ");
INSERT INTO leu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Layaan na Yesus a savat fulaa pe Galili a malila ri maa fesuaiane senaso ri texaas o i taa savatmaan. ");
INSERT INTO leu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","A saxa paamua ina lifu ina faxuvulan, a isina na Jairus, maa poxo la ka Yesus e nung faagutane o i taa falet xe la lifu sina ");
INSERT INTO leu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","senaso nane toxan a lak tefin saxa mon pana mariaas sangafilu saxa pana taragua e nane giis fasaat e faasilak i taa maat. Layaan na Yesus i taxa falet xuvul pana, a malila ri fakaliuane. ");
INSERT INTO leu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","E la palou iri a toxan a saxa tefin aava toxan a lagafan pana ragei lava pana mariaas sangafilu saxa pana taragua e pi ta mataa a fexaxaas sena vil faroxoie. ");
INSERT INTO leu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","A tefin aave a sangasmaan lami Yesus e maa tao a itina marapi sina e a giisan aave moxo malit paaliu et sena. ");
INSERT INTO leu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na Yesus a fiai, “Naseꞌ fo tawau?” Layaan nari xapiak ri faaxolus, na Pita a kuus, “Memai, a rabuna xaves ri taxa fakaliuan nano e ri taxa sot la taam.” ");
INSERT INTO leu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Taasaxa na Yesus a kuus, “Saxa fo tawau. Ne texaas o a gutan fo falet xasega.” ");
INSERT INTO leu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Layaan a tefin aave a texaas o a pife fexaxaas sena fufunai sena, a radakuimaan e maa tapiit turung la kana. E la matana mu rabuna xapiak a kuusan fasavat a giisan sina e a vil faroxoiaana. ");
INSERT INTO leu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","E na Yesus a xuuse, “Xalak tefin, a namkaian siim fo vil faroxoi nano. Falet pana luaian.” ");
INSERT INTO leu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Layaan na Yesus i taxa tigina ferawai lunai saxa mataa a savatmaan ti la lifu si Jairus e maa xuuse, “A lak tefin siim fo maat. Muta lo fasorak a mataa ina fepitaa.” ");
INSERT INTO leu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Layaan na Yesus a langai a mo aanabeꞌ nane xuus na Jairus, “Muta mataut, namkai mon e i taa roxo faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Layaan nane savat la lifu si Jairus, na Pita, Jon e na Jems xuvul pana ninana lak e tamana, nari sang mon ri laak xuvul pa Yesus. ");
INSERT INTO leu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","E lana lifu aave xo, a mu rabuna ri taxa lo tangiis a mamaat e na Yesus a kuus, “Mi muta taangiis, mi nai kasam, a tefin a pife maat, i taxa matef mon.” ");
INSERT INTO leu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ri nangan xuluna senaso ri texaas sena maatan sina lak aave. ");
INSERT INTO leu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Taasaxa nane tao a mana lak e a kuus, “Xalak, no tamasiak!” ");
INSERT INTO leu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A vovau sina lak aave a ulaamaan fulaa e nane tigina faꞌipul. E na Yesus a xuus nari o ri taa tavaie pana fanganan. ");
INSERT INTO leu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","A ninana lak e tamana re ipul faagut taasaxa nane xuus faagutan nare o re muta kuusan a mo aanabeꞌ xe sina mu rabuna. ");
INSERT INTO leu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Layaan na Yesus fo xel faxuvul a mu yaamut sangafilu saxa pana taragua nane tavai nari pana gutan sina e a tateaxan xena gei tapin a mu vovau saat e xena vil faroxoiaana maana rabuna aava ri giis. ");
INSERT INTO leu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nane feng fepatoxan nari xena kuusan fasavat a fatataganan sina Piran e xena vil faroxoiaana mu giisan. ");
INSERT INTO leu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nane xuus nari, “Muta siak ta mo xena faletan simi, muta siak ta xipa o ta bi, e muta siak fanganan o faat o xasa marapi, piau. ");
INSERT INTO leu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","A so ta lifu no laak lana, matef pave fefexaxaas no taꞌulan a bina aave. ");
INSERT INTO leu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Tamo pi ta rabuna ri suai sema, layaan no taꞌulan a bina siri lavaxa, saf tapin a pof la kaam. I taa malaan sena gel tifiaan nari.” ");
INSERT INTO leu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","E voxo nari aave ri tamasiak e ri fe kuusan fasavat a Lagasai Roxo e ri vil faroxoi a rabuna la mu bina xaves. ");
INSERT INTO leu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","A maana rabuna xaves ri ferawai se Yesus e vilaana sina. E saxanofuna ri kuus o nane ve na Jon aava fatatoi faꞌulian ti la mamaat. E xasanofuna ri kuus o nane ve na Ilaija aava fo savat fulaa e xasanofuna fulaa ri kuus o nane ve a mataa ina kuus fatuxai ti kavai aava to faꞌulaa. E layaan na Herot aava paamua ti Galili, a langai pana maana mo aanabeꞌ a lamonan sina a tavanat e a kuus, “Nenia, ne fo patal tapin a putu Jon. Naboxo ne taxa langai paseꞌ?” E nane vubuk xalum na Yesus. ");
INSERT INTO leu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Layaan a mu yaamut ri fo ulaa, ri kuusan a maana faisok siri xe si Yesus. E nane lisan nari xe la bina Betsaida xena fangaafus. ");
INSERT INTO leu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Taasaxa malila ri langai sena e ri usie. Nane fasusui nari e a ferawai xe siri pana fatataganan sina Piran e a vil faroxoi nari aava ri giis. ");
INSERT INTO leu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","La leaaf xo a mu yaamut ri savat sina e ri kuus, “Feng tapin et a maana mu rabuna aanabeꞌ talo ri tafe seng fanganan e ta nobina xena matefan siri la maana nu bina faasilak senaso taara waan nabeꞌ la bina xobingil.” ");
INSERT INTO leu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","E nane sui nari, “Mi tavai nari pana fanganan.” E ri suie, “Maam toxan a fomirak bret pama e din taragua mon nabeꞌ. Naak maam taa fe maraan bret xari xapiak, bo?” ");
INSERT INTO leu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Faasilak a mu rabuna tomexaan 5,000 ri taxa waan pave la noyaan aave.) Taasaxa nane xuus a mu fefeng sina, “Fanei fepatoxan nari lana maana xuvulaian ina rabuna sangafilu pama.” ");
INSERT INTO leu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A mu fefeng ri vil malaane e nari xapiak ri nai suꞌ. ");
INSERT INTO leu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nane siak a fomirak bret pama e a ro din e a kaalum xe laaꞌui la xunavata e kuus faasiroxo xe sina Piran pana e viaxe. E a tavai a mu fefeng sina pana, xena fepatoxanaana la palou iri. ");
INSERT INTO leu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nari xapiak ri fangan e ri maasi. A mu fefeng sina ri siak faxuvul a maana xavil ina fanganan aava waan e ri tifi a maana bi titifai sangafilu saxa pana taragua pana. ");
INSERT INTO leu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Saxa yaan, layaan na Yesus taxa fenung e mu fefeng sina ri taxa waan xuvul pana, nane fin nari, “A mu rabuna ri kuus o nenia naseꞌ?” ");
INSERT INTO leu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ri suie, “Saxanofuna ri kuus o na Jon ina Fasufan, xasanofuna ri kuus o na Ilaija e xasanofuna fulaa ri kuus o a mataa ina kuus fatuxai ti kavai aava fatatoi faꞌulian ti la mamaat.” ");
INSERT INTO leu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","E na Yesus a fin nari, “E nami, mi lamon malaafaa? Nenia naseꞌ?” E na Pita a suie, “Nano, no Krais, a Mataa Failai sina Piran.” ");
INSERT INTO leu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Na Yesus a pebukan faagutan nari o ri muta xuus a rabuna pana. ");
INSERT INTO leu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","E a kuus, “A Natuna Mataa i taa maasak faagut pana maana mo xaves e mu paamua priis, mu matalava e a mu rabuna ina fepitaa pana vuputkai, ri taa tisuie e punuxe. E la fatalatulaana yaan i taa fatatoi faꞌulian.” ");
INSERT INTO leu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","E nane kuus xe siri xapiak, “Naseꞌ ta mataa i taa usiau i muta lamon paamuin a taagulan sina e la maana yaan xapiak i taa yaas a bolo sina e i taa usiau. ");
INSERT INTO leu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Naseꞌ ta mataa a vubuk tao fatateak a toyan sina, a toyan aave i taa malit taasaxa naseꞌ ta mataa i taa taꞌulan a toyan sina xena usiau, i taa fakaxupan. ");
INSERT INTO leu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","A mataa i taa toxan a so ta malangiis tamo i taa siak faxuvul a maana mo xaves lana taagulan sina la xavala e mui a toyan tuuna sina i taa malit? ");
INSERT INTO leu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tamo mataa taa mangil sega e sena ferawaian siak, a Natuna Mataa i taa mangilane vaxa layaan i taa filimaan lana malang molava piis sina e na Tamana e mu angelo xaradak. ");
INSERT INTO leu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ne kuus tuuna xe simi, saxanofuna aava ri taxa tigina nabeꞌ ri taa pife maat paamuina yaan ri taa xalum a fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na Yesus a ferawai malaanabeꞌ e lamina mu yaan pisiktul fo falet a xel faxuvul na Pita narutul Jems e na Jon e ri fe laak xuluna put talo na Yesus i taa fenung. ");
INSERT INTO leu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Layaan i taxa fenung a xakaaluman ina nonau ina a puk e a marapi sina ferarapak faagut malaan sena yaamit. ");
INSERT INTO leu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","A rovaat tomexaan aava na Moses nare Ilaija ");
INSERT INTO leu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","re sivimaan lana malang molava ti laaꞌui la xunavata e re maa ferawai xuvul pa Yesus. Rutul ferawai pana faisok sina aava i taa fataxapine pe Jerusalem layaan i taa taꞌulan a xavala. ");
INSERT INTO leu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Na Pita narutul xo, rutul matef maat taasaxa layaan rutul para faꞌulaa rutul xalum a malang molava sina e rovaat aava re taxa waan xuvul pana. ");
INSERT INTO leu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Layaan a rovaat aave re taxa taꞌulan na Yesus, na Pita a kuus xe sina, “Memai, a mo roxo maatul taxa waan nabeꞌ. Maatul taa vesan a sawat talatul; saxa xanum, saxa xa Moses e saxa xa Ilaija.” (Nane ipul faagut sena maana mo aava savat e pife ferawai pana masaman.) ");
INSERT INTO leu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Layaan i taxa ferawai a vata a savat e maa xafut nari. E ri mataut layaan ri laak lana vata aave. ");
INSERT INTO leu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Saxa ling a ferawai ti lana vata aave e a kuus, “Nabeꞌ ve a Lak Tomexaan siak. Ne fo siak fatie, langai sina.” ");
INSERT INTO leu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Layaan a ling fo ferawai xapiak ri xalum na Yesus sang mon i taxa waan. A mu fefeng talatul aave, rutul waan kasam sena e lana yaan aave ri pife xuus fatexaas a rabuna pana maana mo ri fo xalume. ");
INSERT INTO leu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A yaan mui xo, layaan ri sivi ti xuluna put, a malila molava ri fefasusuie. ");
INSERT INTO leu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","E saxa mataa la palou iri a kuus falava, “Mataa ina Fepitaa, ne nung nano o no taa xalum a lak tomexaan siak, ne pi ta saxa fulaa, nane sang mon. ");
INSERT INTO leu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","A vovau saat a vawe e nane fuuna xukulai faꞌipul; a fuuna tapin fasivie e nane fuuna gaga e a reng fuuna savat ti la valana. I taxa lo waan xuvul pana e i taxa kawaasane. ");
INSERT INTO leu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ne nung a mu fefeng siim o ri taa vil tapine taasaxa ri pife fexaxaas.” ");
INSERT INTO leu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","E na Yesus a suie, “Aa, nami ve mu rabuna aava mi pife namkai e mi fuuna fatavanat a lamonan simi, ne taa waan xuvul pami pana yaan talavisan? Ne taa yaas a matafanan simi pana yaan talavisan? Lisanmaan a lak siim.” ");
INSERT INTO leu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","E layaan a lak aave taxa filimaan, a vovau saat a tapin fasivie xe lapia pana radakuian. Taasaxa na Yesus a baras a vovau saat aave e a vil faroxoi a lak e lisan faꞌulie xe si tamana. ");
INSERT INTO leu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","E nari xapiak ri ipul faagut pana gutan lava sina Piran. Layaan a mu rabuna ri taxa ferawai pana maana mo aava na Yesus a vile, nane xuus a mu fefeng sina, ");
INSERT INTO leu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Langai faroxoi a maana mo ne taxa xuus nami pana: a Natuna Mataa xo, saxa i taa pet lisane xe sina mu rabuna saat.” ");
INSERT INTO leu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Taasaxa mu fefeng ri pife masam sena malasuf ina ferawaian sina senaso a funan seri talo ri pife fexaxaas sena lamon texaasane. E ri mataut sena fin fulane. ");
INSERT INTO leu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","A mu yaamut xo ri taxa lo fegagelai o naseꞌ ve a pelalava. ");
INSERT INTO leu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","E na Yesus fo texaas sena lamonan siri e siak fatiginei a saxa lak la tana ");
INSERT INTO leu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","e xuus nari, “Naseꞌ ta mataa i taa fakas a lak modak aanabeꞌ lana isaak a fakasau e naseꞌ ta mataa a fakasau, a fakas nane aava fengau. Senaso nane aava sisiak xe simi xapiak, nane xo a pelalava.” ");
INSERT INTO leu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","E na Jon a kuus, “Memai, maam xalum a saxa mataa i taxa gei tapin a mu vovau saat lana isaam e maam pebukane senaso nane pife waan xuvul pamaam.” ");
INSERT INTO leu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Na Yesus a suie malaan, “Muta pebukane senaso nari aava ri pife faisok patak semi ri taxa faisok xuvul pami.” ");
INSERT INTO leu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","A yaan ina laaxan sina xe laaꞌui la xunavata i taxa savatmaan faasilak e na Yesus a lamon fatateak o i taa laak xe Jerusalem e a falet xo. ");
INSERT INTO leu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","E nane feng paamuin a mu fefeng sina e ri fe laak xe la saxa bina pe Sameria xena faigotan a maana mo xana. ");
INSERT INTO leu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Taasaxa mu rabuna pave ri bai fakase senaso i taxa laak xe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","E layaan a ro yaamut, na Jems nare Jon, re xalum a vilaana aanabeꞌ, re fine, “Memai, no vubuk o maame taa xel fasivi a fata ti laaꞌui la xunavata xena kawaasan xapin nari?” ");
INSERT INTO leu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Taasaxa na Yesus a tapuk e baras nare ");
INSERT INTO leu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","e ri falet xe la xasa bina. ");
INSERT INTO leu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ri taxa sangas la salan e saxa mataa a kuus xe sina, “Ne taa usi nano tamo no falet xe faa.” ");
INSERT INTO leu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","E na Yesus a xuuse, “A mu vupung ri toxan a mu liing siri e mu maanu laaꞌui la tavegof ri toxan a mu singa siri taasaxa Natuna Mataa a pi ta nobina xena mati lana.” ");
INSERT INTO leu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nane kuus xe sina xasafuna, “Usiau.” Taasaxa mataa aave a xuuse, “Memai, ne tafe xaafan na tamaang xalak e mui ne taa usi nano.” ");
INSERT INTO leu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na Yesus a xuuse, “Nari aava ri maat lana namkaian siri, ri taa xaafan suꞌ a mamaat. E nano, no fe kuusan fasavat a fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","E a xasafuna a kuus, “Ne taa usi nano, Memai, taasaxa paamua ne ulaa xalak ne xuus a matafetama siak pana faletan siak.” ");
INSERT INTO leu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Na Yesus a xuuse, “Tamo Piran fo xel a mataa xena vil a faisok sina e nane kaalum faꞌulaa xe sina maana mo sina ti la xavala, nane pife fexaxaas sena faisok lana fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","E mui lamina a Memai a siak fati a sangafilu pisiguak pana taragua fulaa e a feng tapin nari, taragua pa taragua. Ri falet paamuine xe la mu bina aava nane buk laak lana. ");
INSERT INTO leu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nane xuus nari, “A maana mo la uma ri fo matoxol taasaxa piau ta rabuna xena siak faxuvule. Fin a Memai ina uma o i taa feng a mu rabuna ina faisok sina xena siak faxuvulaana maana mo sina. ");
INSERT INTO leu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Falet! Ne taxa feng tapin nami. Mi taa malaan sena sipsip la palou ina mu piu kai. ");
INSERT INTO leu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Muta siak ta bi o faat o marapi; falet fataapus e muta fasusui ta mataa la salan. ");
INSERT INTO leu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Layaan mi laak la saxa lifu mi taa kuus, ‘A luaian xe simi xapiak.’ ");
INSERT INTO leu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tamo mataa ina luaian taxa waan pave a luaian simi i taa waan xuluna. Tamo piau, i taa ulaa xe simi. ");
INSERT INTO leu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Taagul pave la lifu ina luaian, fangan e num a so ta mo ri tavai nami pana senaso a mataa ina faisok i taa siak a mamareiai ina faisok sina. Muta falet xolai xe la lifu xaves. ");
INSERT INTO leu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Layaan mi laak la bina e a rabuna ri fakas nami, ngan a so ta mo ri tavai nami pana. ");
INSERT INTO leu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Vil faroxoi a mu rabuna aava ri giis pave e xuus nari malaan, ‘A fatataganan sina Piran fo filimaan faasilak paaliu.’ ");
INSERT INTO leu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Taasaxa layaan mi laak la bina e rabuna ri pife fakas nami, savat xe lamalei la mu salan siri e mi kuus, ");
INSERT INTO leu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘A pof la salan simi aava doxot la kamaam, maam taa saf tapine malaan sena fakalimaanan xe simi. Taasaxa texaas faroxo: a fatataganan sina Piran fo waan faasilak xo.’ ");
INSERT INTO leu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ne xuus nami, lana yaan ina tiisan a mu rabuna ti Sodom, ri taa pife siak a fakasanaman aava molava sena rabuna ti la bina aave. ");
INSERT INTO leu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kaari, nami mu Korasin, kaari, nami mu Betsaida, senaso tamo maana mo faꞌipul aava ri savat simi ri tafo savat xapiak pe la ro bina Tair nare Saidan, re taa puk tapin fatapusan nare xasena mu vilaana saat sire e re taa nai lana vebit ina fata pana marapi ina mimilisaatan. ");
INSERT INTO leu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Taasaxa mu rabuna ti Tair nare Saidan, a fakasanaman xari i taa pife molava semi lana yaan ina tiisan. ");
INSERT INTO leu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","E nano, bina Kapanam, naak a isaam i taa laak xe laaꞌui la xunavata vulai, bo? Piau, a bina siim i taa kawaasanan e a isaam lava i taa taxapus. ");
INSERT INTO leu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Naseꞌ ta mataa a langai simi, a langai siak sait. E naseꞌ ta mataa a tisui nami a tisuiau vaxa, taasaxa nane aava tisuiau a tisui nane aava fengau.” ");
INSERT INTO leu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","A mu fefeng sangafilu pisiguak pana taragua ri ulaamaan pana faamamaasan e ri kuus, “Memai, layaan maam ferawai lana isaam a mu vovau saat xo ri langai nemaam.” ");
INSERT INTO leu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","E nane sui nari, “Ne xalum na Setan a poxo ti laaꞌui la xunavata malaan sena yaamit. ");
INSERT INTO leu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Langai, ne fo tavai nami pana gutan xena paasan a mu tiui e pungup e xena faꞌonam a gutan xapiak sina mu xaiyaas sitaara, pi ta mo i taa kawaasan nami. ");
INSERT INTO leu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Taasaxa, muta faamamaas o a mu vovau saat ri langai nami, piau, faamamaas senaso a mu isimi fo xaleian laaꞌui la xunavata.” ");
INSERT INTO leu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lana yaan aapave xo a Vovau Xaradak a fabas na Yesus pana faamamaasan e a kuus, “Ne nangus nano, Tamaang aava Memai ina xunavata e xavala, senaso no fo fun a maana mo aanabeꞌ xasena mu rabuna ina texaasan ti la xavala e no kuusan famatavase xe sina rafulak modak. Aang, Tamaang, nabeꞌ ve a vubuxanan siim. ");
INSERT INTO leu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Na Tamaang a tavaiau pana maana mo xapiak. Pi ta mataa a texaas faroxo paaliu sena Lak Tomexaan taasaxa na Tamana sang mon. E pi ta mataa texaas faroxo paaliu vaxa se Tamana taasaxa na Natuna sang mon, e nari aava na Natuna a buk xuus famatavas nari pana.” ");
INSERT INTO leu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","E nane titapuk xe sina mu fefeng sina e a xuus kasam nari, “Mi taa faamamaas sena maana mo mi fo xalume. ");
INSERT INTO leu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Senaso ne xuus nami o a maana rabuna ina kuus fatuxai e maana piran king, ri vubuk o ri taa xalum a maana mo aava mi taxa xalume taasaxa piau. E ri buk langai a maana mo aava mi taxa langaie taasaxa piau.” ");
INSERT INTO leu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Saxa yaan a saxa mataa aava texaas faagut sena vuputkai a tigina xena valam na Yesus e a fine, “Mataa ina Fepitaa, a so ta mo ne taa vile xena siak a toyan xe vulai, vulai?” ");
INSERT INTO leu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","E na Yesus a suie, “A so ta mo a waan la vuputkai? No lamon malaafaa pana?” ");
INSERT INTO leu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","E a mataa aave a suie, “Vubuxan xasingit a Memai aava Piran siim, pana xunus xapiak siim, pana gutan xapiak siim e pana lamonan xapiak siim e vubuxan xasingit a mu tauma malaan seꞌ no vubuxan nano xa.” ");
INSERT INTO leu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Na Yesus a suie, “No fo sui faroxoi paaliuane. Vil malaane e no taa to.” ");
INSERT INTO leu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Taasaxa mataa aave a vubuk rao a mu rabuna ri taa lamon faroxo pana e voxo a fin na Yesus, “E naseꞌ ve a mu tauga?” ");
INSERT INTO leu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na Yesus a suie pana xuuskuus aanabeꞌ, “A toxan a saxa mataa pe Jerusalem i taxa sivi xe puaa Jeriko. La fena faletan sina a mu rabuna ina fenau ri faloue. Ri turirik tapin a marapi sina, ri sip fasaate e ri taꞌulan faneie suꞌ e nane faasilak i maat. ");
INSERT INTO leu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Saxa priis xo, i taxa sangas sivi xe puaa la salan naang e layaan a xalum a mataa aave a sangas liue la xasa paxasing. ");
INSERT INTO leu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","E vaxa a Livai aava faisok la lifu lotu, layaan a xalum a mataa aave nane vaxa a sangas liue la xasa paxasing. ");
INSERT INTO leu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Taasaxa mataa ti Sameria, lana faletan sina xo, a savat sina mataa aave e layaan a xalume a muluxe. ");
INSERT INTO leu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nane falet xe sina e a irine pana wel e wain. E a yaas faneie xuluna ‘donki’ sina e lisane xe la lifu sasaxong e fe faxatang faroxoie. ");
INSERT INTO leu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A yaan mui nane siak a K20 e tavai a mataa ina lifu sasaxong pana e a xuuse, ‘Faxatang faroxoie. Layaan ne ulaamaan ne taa sui faꞌuli a faat aava no fo fataxapine xena faxatangaana.’ ");
INSERT INTO leu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Fetaxapus e na Yesus a kuus, “No lamon malaafaa? Naseꞌ ve a tauna mataa aava rabuna ina fenau ri sipe?” ");
INSERT INTO leu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","A mataa ina texaasan xo a suie, “A saxa aava muluxe e fangasixe.” Na Yesus a xuuse, “Falet e no fe vil malaane.” ");
INSERT INTO leu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Na Yesus e mu yaamut sina ri taxa sangas falet e ri fe savat la saxa bina. E pave a saxa tefin, a isina na Marta, a fakas nari la lifu sina. ");
INSERT INTO leu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","A tefin aave a toxan a saxa tina, a isina na Maria. E nane fe nai faasilak la ka Yesus xena langai a maana ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Taasaxa na Marta a mamaxus pana faigotanaana maana mo ina matafanganai. Nane maa savat si Yesus e a fine, “Memai no pife muluxau, bo? Na tiak pife xavangau e nenia sang mon ne taxa faisok. Fengmaane i xavangau!” ");
INSERT INTO leu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A Memai a suie, “Marta, Marta, no taxa mamaxus faagut pana maana mo xaves ");
INSERT INTO leu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","taasaxa saxa mo mon a molava. Na Maria fo siak a mo peraroxo paaliu e ne taa pife siak tapine xasena.” ");
INSERT INTO leu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Saxa yaan na Yesus taxa fenung pe la saxa bina. E layaan a fataxapin a fenungan sina, saxa mataa aava fuuna usie, a fine, “Memai, fapiti nemaam pana vilaana ina fenungan malaan se Jon a fapiti a mu rabuna aava ri fuuna usie.” ");
INSERT INTO leu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","E nane xuus nari, “Layaan no fenung, no taa ferawai malaan: Tamamaam, a isaam a pelalava sena mu isin e maam suai faagut sena; a fatataganan siim i taa savatmaan. ");
INSERT INTO leu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tavai nemaam pana fanganan a fexaxaas xe tanin. ");
INSERT INTO leu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Lamon tapin a mu vilaana saat simaam senaso nemaam vaxa maam lamon tapin nari aava ri bilai fasaat xasemaam. E no tivotan nemaam sena mu vavalam.” ");
INSERT INTO leu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","E nane moxo xuus nari, “Tamo mataa a toxan a fesing e a falet xe sina la xunavung e fe xuuse, ‘Ka fesing, tavaiau pana bret talatul ");
INSERT INTO leu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","senaso saxa fesing siak, i taxa falet xe la saxa bina e monabeꞌ mon maa savat siak e ne pi ta fanganan xena tavaiaana.’ ");
INSERT INTO leu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“E nane lana lifu aave a suie, ‘Muta fatatalau. Ne fo xawei a matana lifu xo e nemaam, mu rafulak siak, maam taxa mati la ivin. Ne pife fexaxaas sena tamasiak fulaa xena tavaiaan nano.’ ");
INSERT INTO leu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ne xuus nami o a mataa aave i taa pife tamasiak xena tavaiaana fesing sina pana bret taasaxa i taa tamasiak e i taa tavaie pana so ta mo nane vubuxane senaso a mataa aave taxa lo famasasaafe. ");
INSERT INTO leu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“E voxo ne xuus nami, fiai e mi taa siaxe, seseng e mi taa tingine, vipit la matana lifu e i taa talakas xe simi. ");
INSERT INTO leu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Senaso naseꞌ ta mataa aava fenung i taa siaxe, nane aava seseng, i taa tingine e nane aava vipit la matana lifu, i taa talakas xe sina. ");
INSERT INTO leu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nami mu tamana rafulak, tamo ta lak tomexaan siim i taa fiai pana din, naak no taa tavaie si pana tiui, bo? ");
INSERT INTO leu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O tamo a fin nano pana xatuluk, naak no taa tavaie si pana piraksoxomaat, bo? ");
INSERT INTO leu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tamo nami, naapalaan mi rabuna saat, mi fexaxaas sena tavai a mu rafulak simi pana tatavai roxo, mi lamon o na Tamami la xunavata i taa pife tavai nami aava mi fuuna fenung xe sina, pana Vovau Xaradak?” ");
INSERT INTO leu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na Yesus taxa gei tapin a masalai aava pife fexaxaas sena ferawai. Layaan a masalai aave a taꞌulai, a mataa aava tamu po moxo a ferawai e a malila ri ipul faagut. ");
INSERT INTO leu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Taasaxa saxanofuna ri kuus, “Pana gutan si Bilsibul aava memai ina mu masalai, nane taxa gei tapin a mu masalai.” ");
INSERT INTO leu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Xasanofuna ri tafange pana i taa faxalit nari pana saxa mo faꞌipul ti laaꞌui la xunavata. ");
INSERT INTO leu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Na Yesus fo texaas sena lamonan siri e a xuus nari, “Tamo a gavamen a pife tigina faxuvul, a gavamen aave i taa pife waan xe kavai e tamo a saxa matafetama o pabung ri tigina fepatok a matafetama o pabung aave i taa kawaasanan. ");
INSERT INTO leu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tamo na Setan a fepatoxanan, a gutan sina i taa tigina malaafaa? Ne ferawai malaanabeꞌ senaso mi kuus o nenia, ne taxa gei tapin a mu masalai pana gutan sina memai siri, na Bilsibul. ");
INSERT INTO leu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tamo nenia xa, ne taxa gei tapin a mu masalai pana gutan si Bilsibul lavaxa mu rabuna simi ri fuuna gei tapine pana gutan siseꞌ? Lavaxa, pana faisok siri mi taa tiis a faisok siak. ");
INSERT INTO leu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Taasaxa tamo ne taxa gei tapin a mu masalai pana gutan sina Piran, a fatataganan sina Piran fo savat naboxo la palou imi. ");
INSERT INTO leu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Layaan a saxa mataa tateak pana tol e pinis sina, i taxa faxatang a lifu sina, a maana mo sina ri taa waan faroxo e pi ta mataa i taa fenoue. ");
INSERT INTO leu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Taasaxa, layaan a xasa mataa aava petateak sena, i taa faloue e faꞌoname i taa siak tapin a maana mo aava mataa tafuna lifu i taxa lisan tuunei a lamonan sina xuluna xena xavangaana e i taa fepatoxan a maana mo sina. ");
INSERT INTO leu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nane aava pife waan xuvul paga, i taxa tisuiau e nane aava pife faxuvul xuvul paga, nane, i taxa tapalai. ");
INSERT INTO leu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Layaan a vovau saat i taa taꞌulan a mataa, i taa sangas falet la bina pagala xena seng a maagusan e seng maat e kuus, ‘Ne taa ulaa xe la lifu aava ne fo taꞌulane.’ ");
INSERT INTO leu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","E layaan a savat pave a tingin a lifu naang fo roxo e pife vusiit. ");
INSERT INTO leu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","E nane fe xel faxuvul a xasano vovau saat pisiguak aava ri pemamosaat paaliu sena e nari xapiak, ri fe laak la lifu naang e ri fe taagul pave. E naboxo a toyan sina mataa aave xo a pesasaat paaliu sena waanan sina paamua.” ");
INSERT INTO leu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Layaan na Yesus taxa ferawai malaanabeꞌ a saxa tefin la palou iri moxo kuus falava malaan, “A tefin aava luk nano e fasus nano, nane i taa faamamaas.” ");
INSERT INTO leu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","E nane suie, “Piau, nari aava ri langai a ferawaian sina Piran e ri usie, nari xo, ri taa faamamaas.” ");
INSERT INTO leu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","A malila ri taxa ivungmaan na Yesus e nane kuus, “A mu rabuna saat ti tanin, ri fiai fasoraak pana mo faꞌipul taasaxa i taa piau, ri taa toxan a fakalimaanan aava na Jona mon. ");
INSERT INTO leu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Malaan se Jona ve a fakalimaanan xe sina mu Niniveꞌ, a Natuna Mataa ve a fakalimaanan xe sina mu rabuna ti tanin. ");
INSERT INTO leu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","La yaan ina tiisan a matalava tefin ti paa, i taa tigina xuvul pana mu rabuna ti tanin e i taa gel tifi nari. Senaso nane filimaan ti lasuun paaliu xena langaiaana fepitaian roxo si Solomon e naboxo saxa aava pelalava se Solomon i taxa waan e nami, mi pife langaie. ");
INSERT INTO leu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","E a mu rabuna ti Niniveꞌ vaxa ri taa tigina la yaan ina tiisan xuvul pami e ri taa gel tifi nami senaso nari, ri puk tapin nari xa xasena vilaana saat siri layaan ri langai a ferawaian si Jona e naboxo saxa aava pelalava se Jona i taxa waan nabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Pi ta mataa i taa faram a laam e timine la bina fufunai o lapaana piing ina maiyang, piau. I taa fatofane laaꞌui xuluna xok talo nari aava ri filimaan, ri taa xalume. ");
INSERT INTO leu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","A mataam ve a malaan sena laam ina taam. Layaan re kaalum famatavas, a taam xapiak i taa bas pana malang. Taasaxa layaan a mataam re kaalum fasaat a taam xapiak a bas pana suk. ");
INSERT INTO leu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Faxatang faroxo! Pife roxo tamo a malang ina taam i taa suk. ");
INSERT INTO leu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","E voxo tamo taam xapiak a bas pana malang e pi ta suk modak fe votane, lavaxa i taa bas xapiak pana malang malaan sena yaan a malang ina laam a lang xulum.” ");
INSERT INTO leu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Layaan na Yesus a fataxapin a ferawaian sina, saxa Ferasi fine o re taa fe fangan xuvul. E voxo nane laak e fe nai fangan xuvul pana. ");
INSERT INTO leu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Taasaxa Ferasi aave a xalum na Yesus pife xamak a mana paamuina fanganan e a ipul. ");
INSERT INTO leu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","E a Memai a kuus xe sina, “Nami mu Ferasi xo mi fuuna xamak faroxoi a tana maana mo taasaxa xunus imi va bas pana saatan e naixaaman. ");
INSERT INTO leu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nami mu lamavaang! Nane aava vesan a tana mo, a vesan a lana vaxa, bo? ");
INSERT INTO leu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tavai a mu valagof pana so ta mo i taxa waan lana fafanaian siim e maana mo xapiak i taa piau ta lalosaat xe siim. ");
INSERT INTO leu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Nami mu Ferasi, faxatang! Senaso mi fuuna tatavai xe sina Piran pana fasangafiluaana maana mo modak ti la uma taasaxa mi pife lamon faroxo pana vilaana ina tiisan roxo e vilaana ina vubuxan xasingitaana Piran. Muta lamon pana mu tatavai simi mon, piau, mi taa tapal pana mu vilaana xapiak aave. ");
INSERT INTO leu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Nami mu Ferasi, faxatang! Senaso mi vubuk nai lupaamu lana lifu lotu talo mu rabuna ri taa xalum nami. E mi vubuxan a mu rabuna aava ri falet la maana nobina ina faasot e lana lifu ina faxuvulan, ri taa fasusui nami. ");
INSERT INTO leu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Faxatang! Senaso nami, mi malaan sena mu bina ina mamaat aava ri piau ta fakalimaanan xuluna e mu rabuna lana vungutan siri, ri vaapaas xolai xuluna.” ");
INSERT INTO leu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Saxa mataa aava texaas sena vuputkai a suie, “Mataa ina Fepitaa, layaan no ferawai malaan no fakasal nemaam sait.” ");
INSERT INTO leu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","E na Yesus a suie, “E nami aava mi texaas sena vuputkai, faxatang nami xa senaso mi fuuna fayaas a mu rabuna pana faisok lalagaf aava ri pife fexaxaas sena yaasaana e nami xa mi pife xavang fadak nari, piau paaliu. ");
INSERT INTO leu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Faxatang! Senaso mi vesan a maana nobina roxo paaliu ina mamaat xana mu rabuna ina kuus fatuxai aava kavai a mu bumi ri fo punuk nari. ");
INSERT INTO leu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","E layaan mi vil malaane mi turoxo pana mo a mu bumi ri vile: ri punuk a mu rabuna ina kuus fatuxai e nami, mi vesan a bina ina mamaat xari. ");
INSERT INTO leu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Mi fo vil malaane e a Piran, lana texaasan sina, a kuus, ‘Ne taa feng a mu rabuna ina kuus fatuxai e mu yaamut xe siri. Ri taa punuk a saxanofuna e saxanofuna ri taa vil pengan nari.’ ");
INSERT INTO leu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","E voxo, a mu rabuna ti tanin, ri taa waan lapaana vupunoian ina maatan sina mu rabuna xapiak ina kuus fatuxai, ti la tangpat ina xavala ");
INSERT INTO leu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","layaan na Kein a punuk na tina, na Ebal, fefexaxaas a yaan ri punuk na Sekaraia la palou ina ivin ina faraaman e nobina taap sina Piran lana lifu lotu. Tuuna ne xuus nami, a mu rabuna ti tanin ri taa waan lapaana vupunoian ina maana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Faxatang! Nami aava mi texaas faagut sena mu vuputkai senaso mi fo siak tapin a fufuna texaasan. Nami xa mi pife texaas faroxo e mi tivotan nari aava ri taxa xaveak texaas.” ");
INSERT INTO leu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na Yesus a taꞌulan a lifu aave e a mu Ferasi e mu rabuna ina fepitaa pana vuputkai ri marala faagut e ri tisui a fepitaian e faisok sina. E ri fine pana maana fiaian bit ");
INSERT INTO leu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","senaso ri lamon o i taa milung lana susuaa sina. ");
INSERT INTO leu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lana yaan aanabeꞌ a tang malila ri maa faxuvul. Ri malila temasaat e ri taxa fepaasan xolan a kari. Lana yaan aave na Yesus a ferawai xe sina mu fefeng sina e kuus, “Faxatang votan nami xa sena vilaana ina lalama maranga sina mu Ferasi. ");
INSERT INTO leu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","A maana mo xapiak aava fufunai naboxo a mu rabuna ri taa texaas sena e maana mo aava xafutan ri taa savat la matavas. ");
INSERT INTO leu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","A so ta mo mi ferawai pana la suk a mu rabuna ri taa langaie la paanaas e so ta buk ferawaian mi fefinaasan kasame la lifu, a mu rabuna ri taa texaas sena malaan seꞌ ri taxa xukulaiane laaꞌui xuluna putuna lifu. ");
INSERT INTO leu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Ne xuus nami kamu fesing, muta matautan a rabuna aava ri fexaxaas sena punuxaana tana mataa mon e ri pife fexaxaas sena vil ta mo fulaa. ");
INSERT INTO leu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Piau, ne taa faxalit nami o naseꞌ mi taa mataut sena: mi matautan mon a saxa aava lamina punuxaana mataa a fexaxaas sena tapin fasiviaana xe la bina ina fata aava i taxa raam vulai. Langaiau, suai faagut sena saxa pana gutan malaan. ");
INSERT INTO leu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A Piran a lamon faꞌuli a maana miraxana maanu mi maraane, a mamareiai iri va 2 toea lapaana pama. Tuuna, a maana maanu aanabeꞌ ri modak paaliu taasaxa Piran pife maluf paaliuan ta saxa. ");
INSERT INTO leu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","E voxo mi lamon o a Piran i taa maluf nami, bo? Piau. Nane texaas sena fui talavisan xapiak i taxa waan la putumi. Muta mataut, i taa faxatang faroxoi nami. Nami, mi pelalava sena maana maanu la matana. ");
INSERT INTO leu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ne xuus nami o naseꞌ i taa kuusan famatavasau la palou ina mu rabuna, a Natuna Mataa vaxa i taa kuusan famatavase sait la matana mu angelo sina Piran. ");
INSERT INTO leu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Taasaxa, nane aava faaxolusanau la palou ina mu rabuna, a Natuna Mataa sait vaxa i taa faaxolusane la matana mu angelo sina Piran. ");
INSERT INTO leu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","E naseꞌ ta mataa a ferawai fasaat sena Natuna Mataa, a Piran i taa lamon tapin a saatan sina, taasaxa naseꞌ ta mataa a pet pengan a Vovau Xaradak e pife suai fatak sena, a Piran taa pife lamon tapin a saatan sina. ");
INSERT INTO leu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“E layaan ri lisan nami xe sina mu paamua ina lotu o mu matalava o paamua ina bina, muta mamaxus pana so ta mo mi taa ferawai pana o malaafaa mi taa kuusan famatavas a namkaian simi ");
INSERT INTO leu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","senaso lana yaan fatak aave a Vovau Xaradak i taa fapiti nami pana susuaa roxo.” ");
INSERT INTO leu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Saxa la palou iri a kuus xe sina, “Mataa ina Fepitaa, xuus na tiak o i taa fepatoxan a maana mo si tamamaame e i taa tavaiau pana xavil xanak.” ");
INSERT INTO leu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Na Yesus a suie, “Matuvaat, naseꞌ fo siak fatiau xena mataa ina tiisan la palou ime?” ");
INSERT INTO leu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","E mui nane xuus nari, “Faxatang faroxo! Muta lamon fati vulan a maana mo mi vubuxane talo mi taa pife naixaam; a toyan tuuna sina mataa pife waan lana maana mo sina.” ");
INSERT INTO leu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","E nane xuus nari pana ferawaian paap aanabeꞌ: “A saxa mataa piran a toxan a xavala xaves. A xavala aanabeꞌ a xavala roxo e a fasavat a fanganan xaves. ");
INSERT INTO leu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","A mataa aave a ilisai, ‘Ne taa vil a so? Ne pi ta nobina aava fexaxaas xena faxuvulaana maana fanganan xaves aanabeꞌ.’ ");
INSERT INTO leu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Nane moxo kuus, ‘Ah! Ne taa ngas tapin a mu lifu ina fawaanaana fanganan siak e ne taa vesan a mu lifu faꞌui aava molava sena. Tuuna ne taa vil malaane e ne taa timin a fanganan e maana mo siak lana.’ ");
INSERT INTO leu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","E mui ne taa kuus, ‘Naboxo ne toxan a maana mo xaves. Ne taa pife faisok fulaa lana xasano mariaas aava ri taa filimaan. Tuuna, ne taa waan faroxo paaliu; ne taa fangan e num e ne taa faamamaas.” ");
INSERT INTO leu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Taasaxa Piran a xuuse, ‘Nano, no mataa lamavaang paaliu! Monabeꞌ mon la vung i taa yaan ina maatan siim. E naseꞌ taa siak a maana mo no fo faxuvule xaanum?’ ");
INSERT INTO leu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“I taa savat malaanabeꞌ xe sina saxa aava faxuvul a maana mo ti la xavala xena fafaamamaasaana tana e pife faxuvul a maana mo aava xena fafaamamaasaana Piran.” ");
INSERT INTO leu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","E mui na Yesus a kuus xe sina mu fefeng sina, “Naboxo ne xuus nami, muta mamaxus soxot a maana mo xena toyan simi malaan sena fanganan o maana mo xena xafutaana tami. ");
INSERT INTO leu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","A toxan a maana mo molava sena fanganan lana toyan simi e maana mo molava sena marapi ina xafutaan nami. ");
INSERT INTO leu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Lalamon faagut pana mu maanu: ri pi ri xakaapis la uma o siak faxuvul a fanganan ti lana, ri piau ta bina xena fanei faxuvul a fanganan xe la xasa yaan, piau. A Piran sang mon a fafangan nari. E nami, mi pelalava sena mu maanu la matana Piran! ");
INSERT INTO leu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Naseꞌ a fexaxaas sena famodusaana toyan sina pana mamaxusan? ");
INSERT INTO leu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mi pife fexaxaas sena vil a mo modak aanabeꞌ e voxo xenaso mi mamaxus pana xasano mo fulaa? ");
INSERT INTO leu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Lalamon faagut pana malaafaa a mu fur ri boak. Ri pife faisok o bis xena boak, piau. Taasaxa ne xuus nami o a xakaaluman sina mu fur a peraroxo se Solomon layaan a falak a maana marapi ina piran king sina. ");
INSERT INTO leu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Lavaxa, a Piran xo a famaus a yi pana fur e a yi aave taxa waan tanin e mafu ri taa farame. Tamo Piran a faxatang faroxoi a yi malaan, mi lamon o i taa pife faxatang faroxoi nami malaan sait, bo? Naak a namkaian simi a modak paaliu. ");
INSERT INTO leu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Muta mamaxus pana so ta mo mi taa ngane o nume. ");
INSERT INTO leu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","A mu rabuna aava ri pife namkai, ri fuuna sei soxot a maana mo aave e na Tamami ti laaꞌui la xunavata, nane fo texaas sena vubuxanan simi. ");
INSERT INTO leu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Sei soxot a maana mo ina fatataganan sina Piran e mi taa siak a maana mo mi vubuxane sait. ");
INSERT INTO leu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kamu rafulak modak, na Tamami fo tavai nami pana maana mo aava ri waan la fatataganan sina e voxo muta mataut. ");
INSERT INTO leu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Faasot pana maana mo simi e tatavai xe sina mu valagof. Tamo mi usi a salan aanabeꞌ a malaan seꞌ mi taa siak a bi aava i taa pife miit e vaxa a malaan sena fafanaian la xunavata aava i taa pife taxapus. E pave a mataa saat i taa pife laak xena fenouaana e pi ta mo i taa kawaasane. Piau. ");
INSERT INTO leu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Faxuvul a maana fafanaian simi la xunavata senaso mi taa lamon fati vulan a nobina aava fafanaian simi i taxa waan lana. ");
INSERT INTO leu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Tamasiak vulai xena faisok e faram a laam simi i taa raam vulai. ");
INSERT INTO leu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tamo mi taa vil malaane mi taa malaan sena rabuna sisiak aava ri taxa waan bang a ulaian sina mataa tafuri ti la maraanaana tefin. Layaan i taa vipit la matana lifu a mu sisiak sina ri taa kas fatapusan a matana lifu xe sina. ");
INSERT INTO leu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Layaan a mataa tafuna mu sisiak i taa savatmaan i taa mo roxo paaliu tamo mu sisiak sina ri taxa waan bange e ri pife matef. Ne xuus tuunei nami o i taa falak a marapi ina sisiak e i taa fanei nari la ivin ina fanganan e i taa faigotan a fanganan xari e taa sisiak siri. ");
INSERT INTO leu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","A mu sisiak aava ri faxatang vulai, ri taa pife mangil tamo mataa tafuri taa savat la xunavung o laso ta yaan nane savat.” ");
INSERT INTO leu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","E na Yesus a kuus fulaa, “Famatavas a lamonan simi: tamo mataa tafuna lifu fo texaas sena so ta yaan a mataa ina fenau i taa savat, a mataa tafuna lifu aave i taa faxatang a lifu talo mataa saat i taa pife laak lana. ");
INSERT INTO leu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nami sait, mi taa faxatang vulai senaso a Natuna Mataa i taa savat la yaan mi pife texaas sena.” ");
INSERT INTO leu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na Pita a fiai, “Memai, no taxa kuus pana ferawaian paap aanabeꞌ xe simaam o xe sina mu rabuna xapiak?” ");
INSERT INTO leu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A Memai a suie, “A sisiak aava usi a vilaana roxo e faisok faagut vulai, a mataa tafuna i taa tavaie pana ngavuk ina paamuian a xasano sisiak e xena tavai nari pana fanganan la yaan fatak ina fanganan. ");
INSERT INTO leu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tamo sisiak aave taxa lo vil a vubuxanan sina mataa sina, a mataa aave i taa faamamaas pana layaan a ulaamaan. ");
INSERT INTO leu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ne kuus tuuna, i taa siak fati a sisiak aave xena paamuian a maana mo xapiak sina. ");
INSERT INTO leu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Taasaxa tamo sisiak aave a ilisai, ‘A mataa tafuga i taa pife ulaamaan fataapus,’ e voxo nane sip xolan a mu sisiak xapiak, a tomexaan e tefin sait, e fangan e num temasaatan a raarum tateak, ");
INSERT INTO leu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","a mataa tafuna i taa ulaamaan a saxa yaan a sisiak aave a pife lalamon pana e lana yaan naang a pife tamasiak bange. E a mataa tafuna i taa putuk xapin a sisiak aave e timin faxuvule xuvul pana mu rabuna aava ri pife namkai. ");
INSERT INTO leu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“A sisiak aava texaas sena vubuxanan sina mataa tafuna taasaxa pife tamasiak xena vile, a mataa sina i taa inis faagutane. ");
INSERT INTO leu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Taasaxa nane aava pife texaas faroxo sena vubuxanan sina mataa sina e a vil a mo mosaat, a fakasanamaana i taa pife lava, ri taa pife sip faxavesane. Senaso tamo mataa a toxan a texaasan, xasanofuna ri taa lamon o i taa faisok lapaana texaasan aave e i taa pife bilai malaan sena mataa ngong e tamo toxan a ngavuk lava, xasanofuna ri lamon o i taa vil xapin a maana faisok sina e xasliue pana maana faisok fulaa. ");
INSERT INTO leu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ne fo savatmaan xe lapi la xavala xena lisan a fata ina tiisan e ne vubuk rao i taa raam xo! ");
INSERT INTO leu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Taasaxa lagafan molava i taxa xafutau e ne taxa maasak faagut fefexaxaas i taa taxapus. ");
INSERT INTO leu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mi lamon o ne savatmaan xena lisan a luaian, bo? Piau, ne pife lisanmaan a luaian taasaxa ne savat xena fepatoxan nami. ");
INSERT INTO leu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tamo saxa matafetama a toxan a rabuna pama ri taa fepatok, taragua xasena talatul. ");
INSERT INTO leu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ri taa fepatok, na tamana lak nare na lak tomexaan re taa ti patak, na ninana lak tefin nare na lak tefin re taa ti patak e mu enana vaxa ri taa ti patak.” ");
INSERT INTO leu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nane kuus xe sina malila, “Layaan mi xalum a vata i taxa falaak pe kol, fataapus mi kuus, ‘I taa raafui’ e a raafui a savat. ");
INSERT INTO leu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","E layaan a reref a savat ti pul mi kuus, ‘A bina i taa lagaf,’ e bina lagaf. ");
INSERT INTO leu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nami, mu lalama maranga! Mi texaas faagut sena fakalimaanan ina xavala e tavegof taasaxa maana fakalimaanan ti tanin mi vungut sena, bo? ");
INSERT INTO leu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Xenaso nami xa, mi pife tiis a so ta mo a roxo? ");
INSERT INTO leu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Layaan name ro xaiyaas, me taxa falet xe sina mataa ina tiisan, no taa faisok faagut xena vil faroxoi a fegagelaian sime ulaa mataa aave i tamaa lisan nano xe lana bina ina tiisan lava. E a mataa ina tiisan aave i tamaa tavai a mataa ina faxatangaana mu vipis, pama e nane aave i taa tapin fasivi nano lana bina ina vipisan. ");
INSERT INTO leu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ne xuus nami o mi taa pife taꞌulan a bina aave fefexaxaas mi maraan xapin a mamareiai aava ri tavai nano pana.” ");
INSERT INTO leu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Saxanofuna la palou ina malila aave ri xuus na Yesus pa Pailat e malaafaa nane punuk a mu rabuna ti Galili e a ria iri fefaxuvul pana ria ina mu tatavai taap siri. ");
INSERT INTO leu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","E na Yesus a sui nari, “Mi lamon o a mu Galili aava ri maat malaan, a vilaana siri a pesasaat sena xasano Galili, bo? ");
INSERT INTO leu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ne xuus nami piau! Taasaxa tamo nami, mi pife puk tapin nami xa xasena vilaana saat simi, nami xapiak, mi taa maat vaxa. ");
INSERT INTO leu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Lamon sena rabuna sangafilu saxa pana pisiktul aava ri maat layaan a lifu modus xe laaꞌui pe Siloam a poxo punuk nari. Mi lamon o nari, ri vupuno temasaat sena xasanofuna aava ri waan pe Jerusalem, bo? ");
INSERT INTO leu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ne xuus nami piau! Taasaxa tamo mi pife puk tapin nami xa xasena vilaana saat simi, nami vaxa, mi taa maat.” ");
INSERT INTO leu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","E na Yesus a kuus pana saxa ferawaian paap malaan: “Saxa mataa a toxan a falaang aava waan la uma sina. Nane fe seng a xalana taasaxa seseng maat. Piau ta xalana. ");
INSERT INTO leu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","E a kuus xe sina mataa ina faxatangaana uma, ‘Pana mariaas talatul xo ne fo seng a xalana wai aanabeꞌ taasaxa piau. Tei tapine! Xenaso i taa waan nabeꞌ lana xavala roxo?’ ");
INSERT INTO leu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","A mataa ina faxatangaana uma a kuus, ‘Matalava, mune! I taa waan pana mariaas saxa fulaa e ne taa xaf fakaliuan a funa e ne taa timin a xawa lana. ");
INSERT INTO leu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tamo i taa fuaa la mariaas mui, a roxo. Tamo piau, lavaxa tei tapine.” ");
INSERT INTO leu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","La saxa Yaan ina Fangaafusan na Yesus taxa fepitaa lana saxa lifu ina faxuvulan ");
INSERT INTO leu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","e a toxan a tefin aava maalapen senaso a vovau saat fo vawe. Pana mariaas sangafilu saxa pana pisiktul i taxa lo waan malaan e pife fexaxaas sena tigina faroxo. ");
INSERT INTO leu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Layaan na Yesus a xalume, a xelmaane e kuus xe sina, “Tefin, ne fo mulus nano xasena giisan siim.” ");
INSERT INTO leu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","E mui a timin a mana xuluna e monabeꞌ mon a tefin aave a tigina fatak e a kuus fati a Piran. ");
INSERT INTO leu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","A paamua ina lifu ina faxuvulan a marala senaso na Yesus a vil faroxoi a tefin la Yaan ina Fangaafusan e nane kuus xe sina rabuna, “A toxan a yaan pisaxa mon xena faisok. Savat xena vil faroxoiaan nami lana mu yaan aave e pife la Yaan ina Fangaafusan.” ");
INSERT INTO leu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","A Memai a suie, “Nami xalema maranga! Nami saxa saxa, mi fuuna mulus tapin a ‘donki’ o bulmakau simi la Yaan ina Fangaafusan, bo? E mi lisan fasavate xe lamalei talo i fexaxaas sena num, bo? ");
INSERT INTO leu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lavaxa, a tefin aanabeꞌ ve a lak tefin si Abrahem aava na Setan fo bugute pana mariaas sangafilu saxa pana pisiktul. E nami, mi lamon o pife roxo nane vaxa taa mulusan xasena mo aava fo bugutmaane la Yaan ina Fangaafusan, bo?” ");
INSERT INTO leu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Layaan a kuus malaan nari aava ri gilise, ri mangil taasaxa mu rabuna si, ri faamamaas pana maana mo roxo nane taxa vile. ");
INSERT INTO leu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","E voxo na Yesus a fiai, “A fatataganan sina Piran a malaan sena so? Ne taa ferawai paap pana malaafaa? ");
INSERT INTO leu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","A malaan sena fomirak kam ina mastaat aava mataa fe xapise la uma sina. A boak e femolava e a mu maanu ti la tavegof ri maa vesan a singa siri la raxana.” ");
INSERT INTO leu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","E a fiai fulaa, “Ne taa ferawai paap pana fatataganan sina Piran malaafaa? ");
INSERT INTO leu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A malaan sena yiis aava tefin a timin a kaamodak ina lana flaua xaves e fe fasul xapin a flaua.” ");
INSERT INTO leu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na Yesus, la fena faletan sina xe pe Jerusalem, a laak lana mu bina xaves e fepitaa pave. ");
INSERT INTO leu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","E saxa mataa fine, “Memai, a mu rabuna talavisan ri taa fakaxupan? Pife xaves, bo?” ");
INSERT INTO leu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","E nane kuus xe siri, “Tatalai faagut xena laak lana fomirak matana lifu senaso ne xuus nami o a maana rabuna xaves ri taa laak taraa taasaxa ri pife fexaxaas sena. ");
INSERT INTO leu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Layaan a mataa tafuna lifu a tamasiak e xawei a matana lifu, mi taa tigina vipit maat lamalei e fenung, ‘Memai, kas a lifu xe simaam.’ “Taasaxa i taa sui nami, ‘Ne ngalngolan nami e ne pife texaas o mi filimaan ti faa!’ ");
INSERT INTO leu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“E nami, mi taa kuus, ‘Maam fangan e num xuvul pama e no fepitaa la bina simaam.’ ");
INSERT INTO leu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Taasaxa i taa suie, ‘Ne ngalngolan nami e ne pife texaas o mi filimaan ti faa? Faapalau sega, nami mu rabuna saat.’ ");
INSERT INTO leu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Layaan mi xalum na Abrahem, Aisaak nare Yaakop e a mu rabuna ina kuus fatuxai, ri taxa waan la fatataganan sina Piran, mi taa taangiis e mamaxus senaso nami xa mi taxa waan lamalei e mi pife fexaxaas sena laak xe pave. ");
INSERT INTO leu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","A mu rabuna ti pul, ti kol, ti puaa e ti paa ri taa nai la matafanganai sina Piran la fatataganan sina. ");
INSERT INTO leu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","A tuuna, nari aava ri taxa waan la fataxapiak naboxo ri taa tigina paamua e nari aava ri taxa waan paamua naboxo, ri taa waan la fataxapiak.” ");
INSERT INTO leu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lana yaan aave saxano Ferasi ri maa savat si Yesus e ri xuuse, “Taꞌulan a bina aanabeꞌ e no paan patak. Na Herot a vubuk rao i taa punuk nano.” ");
INSERT INTO leu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Na Yesus a sui nari, “Fe xuus a mataa ina suaxan aave o ne taa feng tapin a mu vovau saat e vil faroxoi a mu rabuna tanin e mafu e la fatalatulaana yaan ne taa fataxapin a faisok siak. ");
INSERT INTO leu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ne taa lo falet tanin, mafu e la yaan mui lamina senaso pi ta mataa ina kuus fatuxai aava i taa maat patak xolai xaseꞌ Jerusalem. ");
INSERT INTO leu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Nami mu Jerusalem, nami mu Jerusalem, mi punuk a mu rabuna ina kuus fatuxai e mi soxoi a mu fefeng aava ri savat simi pana faat taasaxa ne fuuna vubuk faxuvul a rafulak simi malaan sena pura tefin a faxuvul a mu natuna lapaana xakavena taasaxa mi bai! ");
INSERT INTO leu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kaalum, a bina simi i taa kawaasanan. Ne xuus nami o mi taa pife xalum fulanau fefexaxaas a yaan mi taa kuus, ‘A Piran i taa tavai a mataa aava savat lapaana tateaxan ina Memai pana roxoyan.” ");
INSERT INTO leu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","La saxa Yaan ina Fangaafusan, layaan na Yesus a laak la lifu sina saxa Ferasi lava xena fangan, a rabuna xaves ri falime. ");
INSERT INTO leu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Pave la nona, a saxa mataa pana giisan lava taxa nai. ");
INSERT INTO leu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na Yesus a fin a mu Ferasi e mu rabuna aava ri texaas sena vuputkai malaan, “A mu vuputkai sitaara ri turoxo pana vil faroxoiaana mataa la Yaan ina Fangaafusan, bo?” ");
INSERT INTO leu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Taasaxa ri nai kasam. E voxo na Yesus a tao a mana mataa aave e a vil faroxoie e feng tapine. ");
INSERT INTO leu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","E mui nane fin nari, “Tamo a lak tomexaan siim o a bulmakau siim i taa poxo la vaaꞌul la Yaan ina Fangaafusan no taa yuuf falak fatapusane, bo?” ");
INSERT INTO leu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Taasaxa ri nai xanakuut. ");
INSERT INTO leu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","A mu rabuna aava ri waan la fenamo aave ri fuuna buk nai la nobina lava e layaan na Yesus a xalume nane ferawai paap xe siri malaan: ");
INSERT INTO leu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Layaan a saxa mataa a xel nano xena filimaan xe la fenamaraan tefin sina, muta nai la nobina lava senaso ulaa saxa mataa aava pelalava sema tamaa savat. ");
INSERT INTO leu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","E tamo savat malaan, a mataa aava xelmaan name xapiak xe lana matafanganai, i taa xuus nano ‘Tavai a mataa aanabeꞌ pana nobina siim.’ E nano, no taa mangil e no taa fe nai lumui paaliu. ");
INSERT INTO leu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Taasaxa layaan no laak lana fenamo, nai lumui talo a memai ina fenamo, layaan i taa savat, i taa xuus nano, ‘Ka Fesing, no maa nai la nobina lava.’ E a mu rabuna la fenamo ri taa suai sema. ");
INSERT INTO leu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Naseꞌ ta mataa i taa vil falavai nane xa i taa poxo e femangil. E naseꞌ i taa vil fasivi nane xa i taa faꞌisinan pana isin lava.” ");
INSERT INTO leu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na Yesus a xuus a memai ina fenamo aave malaan, “Layaan no faigotan a fenamo muta xel a mu fesing siim o mu tiam o mu tauma o mu piran, xena filimaan, piau. Tamo no vil malaane, mui ri taa xel nano vaxa e no taa siak faꞌuli a malangiis ina faisok roxo siim. ");
INSERT INTO leu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Taasaxa layaan no faigotan a fenamo xel a mu valagof, mu ka tapil, mu mata piif e mu maalapen. ");
INSERT INTO leu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Vil malaane e no taa faamamaas. Nari, ri pife fexaxaas sena maraan faꞌuli a roxoyan siim taasaxa no taa siak a roxoyan ina layaan a mu rabuna fatak ri taa to faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Layaan a saxa aava waan xuvul pa Yesus la fenamo naang a langaie, a kuus, “A mataa aava i taa nai fangan la fenamo la fatataganan sina Piran i taa faamamaas.” ");
INSERT INTO leu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Na Yesus a suie, “Saxa mataa xo a faigotan a fenamo molava e fin a rabuna xaves xena filimaan. ");
INSERT INTO leu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","La yaan ina fenamo xo savat e a mataa aave xo a feng a sisiak sina xena xuus fatexaas a mu rabuna aava ri fo siak a lagasai xena filimaanan, pana, ‘Filimaan, senaso a maana mo ina fenamo ri fo faigotanan xo.’ ");
INSERT INTO leu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Taasaxa nari xapiak ri favavof a malitan siri. Saxa a kuus, ‘Monabeꞌ mon ne fo maraan a nexavala e ne taa fe xalume. Kaari, ne pife fexaxaas sena falet.’ ");
INSERT INTO leu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“A xasafuna a kuus, ‘Monabeꞌ mon ne maraan a mu bulmakau sangafilu e ne taa fe tafang nari. Kaari, ne pife fexaxaas sena falet.’ ");
INSERT INTO leu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“A xasafuna fulaa a kuus, ‘Naboxo ne fo maraan a tefin e voxo ne pife fexaxaas sena falet.’ ");
INSERT INTO leu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“A sisiak aave a ulaamaan xo e maa xuus fatexaas a mataa tafuna pana. E a mataa tafuna xo a marala e a xuus faagutan a sisiak sina, ‘Fataapus, falet la maana xasing xapiak ina bina e no lisanmaan a mu valagof, mu maalapen, mu rabuna piif e a mu rabuna kari saat.’ ");
INSERT INTO leu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“E mui, lamina ulaamaanan sina, a sisiak aave a kuus, ‘Matalava, ne fo usi fatak a ferawaian siim taasaxa toxan a maana vepen lunai ri taxa waan palau.’ ");
INSERT INTO leu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“A mataa tafuna fenamo xo a xuus a sisiak sina, ‘Falet xe la mu salan lava e mu salan la latan e lisanmaan nari xapiak aava ri waan pave talo lifu siak i taa bas pana rabuna. ");
INSERT INTO leu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ne xuus nano, pi ta saxa la palou iri aava ri siak a lagasai xena filimaanan, ri taa fangan famodak la fenamo siak.’” ");
INSERT INTO leu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","A malila ri taxa sangas xolai xuvul pa Yesus e nane tapuk xe siri e kuus, ");
INSERT INTO leu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Naseꞌ ta mataa a filimaan xe siak xena usi fataxau i taa baian na ninana e tamana, a tefin e mu rafulak sina, mu tina e mu vasaana e i taa baian a toyan sina vaxa. Tamo pife vil malaane i taa pife fefeng siak. ");
INSERT INTO leu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","E tamo i taa pife yaas a bolo sina a pife fexaxaas sena usi fataxau. ");
INSERT INTO leu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Tamo saxa mataa a buk vesan a lifu modus xe laaꞌui, paamua i taa lalamon pana mamareiai ina vesanaana tamo nane toxan a faat a fexaxaas sena fataxapine, bo? ");
INSERT INTO leu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tamo i taa timin a fufuna lifu aave taasaxa pife fexaxaas sena fataxapine, a mu rabuna ri taa nangan xuluna ");
INSERT INTO leu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","e ri taa kuus, ‘A mataa aanabeꞌ a tangpat pana vesanaana lifu e pife fexaxaas sena fataxapine.’ ");
INSERT INTO leu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O tamo saxa ‘king’ i taa falet xena fevisan a xasafuna i taa nai lalamon pana kataana mu rabuna ina rawen sina tamo ri fexaxaas sena faꞌonam a rabuna sina xasafuna. ");
INSERT INTO leu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tamo pife fexaxaas sena, layaan a xasafuna i taxa lasuun lunai i taa feng a mu matalava sina xena fadaarum nari. ");
INSERT INTO leu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","E a malaanabeꞌ, nano, no taa lalamon faagut pana mamareiai ina usiaan nenia, senaso tamo no taa pife puk tapin nano xa xasena maana mo xapiak ti la xavala, no taa pife usi fataxau. ");
INSERT INTO leu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“A sol a mo roxo taasaxa tamo a xakaarixan ina i taa malit malaafaa i taa roxo fulaa? ");
INSERT INTO leu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","I taa pife roxo xena timine la xavala o la xawa; ri taa tapin pataxe. “Langai, tamo a tangami a talakas.” ");
INSERT INTO leu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lana yaan aanabeꞌ a mu rabuna ina siak taakis xuvul pana mu ‘rabuna sasaat’ ri maa faxuvul la ta Yesus xena langaiaana. ");
INSERT INTO leu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Taasaxa mu Ferasi e mu rabuna ina fepitaa pana vuputkai ri ferawai kasam e fefinaas malaan, “A mataa aanabeꞌ a fesing xuvul pana mu rabuna saat e fangan xuvul pari.” ");
INSERT INTO leu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Na Yesus moxo a xuus nari pana ferawaian paap aanabeꞌ: ");
INSERT INTO leu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","5","“A saxa la palou imi a toxan a mu sipsip sangafilu sangafilu e saxa femalit. Nane taꞌulan nari aava ri taxa waan lunai la nobina matavas xena seng a sipsip aave. I taa seseng fefexaxaas i taa tingine e i taa famasaxe la kolumana e ulaa xe la lifu sina. ");
INSERT INTO leu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","E mui a xel faxuvul a mu fesing sina e kuus, ‘Faamamaas xuvul paga; ne fo tingin a sipsip siak aava malit paamua.’ ");
INSERT INTO leu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ne xuus nami, malaan sena mataa aave a faamamaas sena sipsip sina, a toxan a faamamaasan molava la xunavata pana saxa mataa saat aava puk tapin nane xa xasena vilaana saat sina. A faamamaasan sena saxa aave a molava sena faamamaasan sena rabuna xaves aava ri roxo e ri pi ta mo xena puk tapin nari xa xasena.” ");
INSERT INTO leu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","E fulaa na Yesus a ferawai, “E tamo a tefin a toxan a mu faat ‘silva’ sangafilu e saxa a malit, i taa vil a so? Nane taa faram a laam, gon a lifu e seng faroxo fefexaxaas i taa tingine, bo? ");
INSERT INTO leu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","E layaan a tingine, i taa xel faxuvul a mu fesing sina e kuus, ‘Faamamaas xuvul paga senaso ne fo tingin xo a faat aava malit.’ ");
INSERT INTO leu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","E malaan sena faamamaasan sina tefin aanabeꞌ, ne xuus nami o a mu angelo sina Piran ri fuuna faamamaas faagut layaan a saxa mataa saat a puk tapin nane xa xasena vilaana saat sina.” ");
INSERT INTO leu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na Yesus a kuus saa fulaa pana, “Saxa mataa toxan a ro lak tomexaan taragua. ");
INSERT INTO leu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A lak ti lumui a xuus na Tamana ‘Fepatoxan a maana mo siim xe simaame rofetinan.’ Lavaxa, na Tamana xo a fepatoxane. ");
INSERT INTO leu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“A lak ti lumui xo a faxuvul a maana mo sina e fe paan xe la bina lasuun. Layaan i taxa waan pe la bina lasuun aave a fataxapin a faat sina pana maraanaana maana vilaana saat. ");
INSERT INTO leu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Layaan a faat sina fetaxapus, a song molava a savat la bina aave e nane xo lagai. ");
INSERT INTO leu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nane paan e fesavat sina saxa mataa e fine pana saxa faisok xolai. A mataa aave a tavaie pana faisok xena fafangan a tagaan vio sina. ");
INSERT INTO leu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Layaan nane taxa fafangan a mu vio pana vapak ina ‘biin’ nane lagai fasaat xo e vubuk rao i taa fangan xuvul pana mu vio. Taasaxa pi ta mataa a tavaie panꞌ ta fanganan. ");
INSERT INTO leu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“E voxo a nai xo e a lamonan roxo savat fulaa sina e nane lamon malaan, ‘A maana mu sisiak si Tamaang ri toxan a fanganan xaves taasaxa nenia, ne taxa maat pana lagaian. ");
INSERT INTO leu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Naak a roxo ne taa tamasiak naboxo e ne taa ulaa. Layaan ne falet ne taa fe savat si Tamaang e ne taa xuuse, “Tamaang, naboxo ne fo vil a saat la matana Piran e la mataam. ");
INSERT INTO leu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","A pife roxo no taa xaliau pana lak siim. A roxo naak no taa xaliau mon pana saxa sisiak siim.” ");
INSERT INTO leu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Lavaxa, layaan i taxa filimaan lasuun lunai na Tamana fo xalume e a vilauna sei soxote e a muluxe. E nane fala xe sina e feyot fatateaxe e nguse. ");
INSERT INTO leu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Na natuna xo a xuuse, ‘Tamaang, ne fo vil a saat la matana Piran e la mataam. E pife roxo fulaa no taa xaliau pana lak siim.’ ");
INSERT INTO leu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Taasaxa, na Tamana a xuus a mu sisiak sina, ‘Mi siakmaan a saxa ligilot siak e mi siakmaan a saxa maaxui e maa timine la mana. Mi timin a xiut la kolumana. ");
INSERT INTO leu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","E mi paan e mi siak a saxa lak bulmakau palak e mi punuxe setaara taa fangan e taara taa faamamaas. ");
INSERT INTO leu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Senaso a lak siak fo maat taasaxa nabeꞌ fo to faꞌulaa, a malit e naboxo fo savat faꞌulaa.’ E ri vil a fenamo molava. ");
INSERT INTO leu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Taasaxa, lak tuaan va taxa waan la uma. Layaan nane maa savat faasilak la lifu, a langai a rabuna ri taxa faamamaas e ri taxa merao. ");
INSERT INTO leu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","E nane xel a saxa sisiak si Tamana e fine, ‘A rabuna aapave ri taxa sou?’ ");
INSERT INTO leu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","E a sisiak aave a xuuse, ‘Na tiam xo fo ulaa e na Tamaam a punuk a saxa fomirak bulmakau senaso a lak aave sina fo ulaa faroxo.’ ");
INSERT INTO leu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“A lak tuaan xo a marala e a vilauna kasal e a bai laak xe lana lifu. E na Tamana xo savatmaan xe lamalei e maa nung faagutane o i taa laak xena faamamaas xuvul pari. ");
INSERT INTO leu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Taasaxa, a sui a ferawaian si Tamana e xuuse, ‘A mariaas xaves ne tao a maana faisok siim nabeꞌ malaan sena saxa sisiak palau. Ne pife ket sui ta saxa vapaling siim taasaxa no pi vupunuk ta saxa fomirak meme talo ne taa faamamaas xuvul pana saxano fesing siak, piau paaliu. ");
INSERT INTO leu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Taasaxa, layaan a lak siim aava tapin palou a maana mo siim xe sina lutefin pana vilaana saat, a ulaamaan fulaa, nano, no muluxe e no punuk a saxa bulmakau xana.’ ");
INSERT INTO leu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“E na Tamana a xuuse, ‘Natuk, vulai, vulai taare taxa waan faxuvul. A maana mo xapiak siak ve xanum. ");
INSERT INTO leu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Taasaxa, no taa faamamaas. A vilauma i taa roxo vulai. Na tiam aanabeꞌ va fo maat taasaxa naboxo a to faꞌulaa; fo malit taasaxa naboxo a savat faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Na Yesus a xuus a maana mu fefeng sina, “A toxan a saxa mataa piran e a rabuna ri maa xuuse o a mataa aava fuuna faisok pana faxatangaana maana mo sina, a pife faisok faroxo. Nane fuuna tapin palou a maana mo. ");
INSERT INTO leu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","E voxo nane a xel a mataa aave e fine, ‘A maana ferawaian ne fo langaie pama ve so? Xuus famatavasau pana faisok siim senaso no pife fexaxaas sena faisok fulaa la lifu siak.’ ");
INSERT INTO leu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“A mataa faisok aave a ilisai, ‘Naboxo ne taa vil a so? A mataa siak naboxo i taa fataxapinau sena faisok siak. Ne pi ta gutan xena kaaf vaaꞌul, e ne mangil sena fenung vulai. ");
INSERT INTO leu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Aa! Ne texaas sena so ta mo ne taa vile talo a rabuna ri taa kas a lifu siri xe siak layaan ne pi ta faisok fulaa.’ ");
INSERT INTO leu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“E nane xel faxuvul a mu rabuna aava ri siak palou a mo sina mataa tafuna. E nane fin a saxa, ‘No siak palou a mo talavisan sina paamua siak?’ ");
INSERT INTO leu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“A mataa aave suie, ‘A vaan sangafilu saxa pana pama ina wel’. “E a mataa faisok a xuuse, ‘Nai, fataapus, e no xule. Xalei a vaan pisiktul mon.’ ");
INSERT INTO leu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“E a fin a xasafuna, ‘No siak palou a mo talavisan sina paamua siak?’ “E nane suie, ‘A bi titifai sangafilu sangafilu pana kam ina ‘wiit’.’ “E a xuuse, ‘Fataapus, no xalei a sangafilu pisiktul mon.’ ");
INSERT INTO leu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“A mataa piran aave a ferawai faroxo sena mataa faisok sina aava bit senaso a faigotan a maana mo xena taagulan sina. A mu rabuna aava ri sangas lana mu salan ti la xavala ri fuuna faigotan a maana mo xena toyan siri. Taasaxa mu rabuna aava ri sangas lana malang, ri pife malaan seri. ");
INSERT INTO leu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ne xuus nano, lamon pana toyan siim xe vulai. Nabeꞌ la xavala, tapin a faat e maana mo siim xena xavang a mu rabuna talo ri taa fesing siim e layaan a mu faat aave ri taxapus, a mu rabuna aave ri taa faamamaas pana xalumaan nano la xunavata. ");
INSERT INTO leu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Naseꞌ fexaxaas sena faxatang faroxoi a mo modak a fexaxaas sena faxatang a mo molava vaxa. E naseꞌ a faisok bit pana faat modak taa vil malaane vaxa pana faat molava. ");
INSERT INTO leu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tamo no pife faxatang faroxoi a maana fafanaian ti la xavala, naseꞌ taa tavai nano pana fafanaian tuuna sina Piran? ");
INSERT INTO leu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","E tamo no pife faxatang faroxoi a mo sina xasafuna, naseꞌ taa tavai nano pana maana mo xaanum? ");
INSERT INTO leu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Pi ta mataa faisok a fexaxaas sena faisok lapaana ro piran taragua, piau. I taa baian a saxa e vubuxan xasingit a saxa o i taa suai sena saxa e lamon fasaat sena saxa. No pife fexaxaas sena faisok lapaana Piran e lamon soxot a faat sait.” ");
INSERT INTO leu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A mu Ferasi aava ri vubuxan xasingit a faat, ri langaie e ri suaxan a ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","E nane xuus nari, “Nami, mi kuusan famatavas a maana vilaana simi la matana mu rabuna, taasaxa Piran a texaas sena vubuxanan simi. A maana mo aava rabuna ri vubuxan temasaatane, a Piran a baiane. ");
INSERT INTO leu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“A mu vuputkai e maana ferawaian sina rabuna ina kuus fatuxai fo kuusan fasavatan fefexaxaas a yaan na Jon a savat. Naboxo, lamina yaan si Jon, a Lagasai Roxo ina fatataganan sina Piran i taxa kuusan fasavatan. E a maana rabuna xaves ri taxa vubuk paaliu o ri taa laak xe lana. ");
INSERT INTO leu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","A fexaxaas o a xunavata e xavala re taa malit taasaxa piau ta xavil modak ina xakalayan ina vuputkai i taa malit. ");
INSERT INTO leu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“E naseꞌ ta mataa a taꞌulan a tefin sina xena tamai sina xasa tefin i taxa laxao a vuputkai ina tamaian e a mataa aava tamai sina saxa tefin aava lavana taꞌulane, i taxa laxao a vuputkai ina tamaian sait. ");
INSERT INTO leu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“A toxan a saxa mataa piran aava fuuna falak a maana marapi raf aava roxo e fuuna ngan a maana buk fanganan roxo sang mon. ");
INSERT INTO leu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","E faasilak la matana lifu sina a saxa mataa valagof taxa mati, isina na Lasarus. Nane fuuna lamon pana piak a maana xavil ina fanganan aava poxo lapi lapaana ivin sina mataa piran aave e a viis la tana ri xaves. ");
INSERT INTO leu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","E maana piu ri fuuna filimaan e ri maarimit a maana viis sina pana xalemari. ");
INSERT INTO leu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Lumui a mataa valagof a maat e a mu angelo ri yaas falaxe xe laaꞌui e ri faneie xuvul pa Abrahem. E a mataa piran vaxa a maat e ri xaafane. ");
INSERT INTO leu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","E nane xo a waan la bina ina fata aava raam vulai e a toxan a maasaxan vulai. Nane kaalum laak xe laaꞌui e xalum na Abrahem nare Lasarus re taxa waan lasuun temasaat. ");
INSERT INTO leu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A mataa piran xo a kel e kuus, ‘Tamaang Abrahem, muluxau e feng na Lasarus i sivimaan xena timin a vipirigum ina mana lana raarum e maa fapiraus famodak a xalemaak. Ne nasam penganau lana fata aanabeꞌ.’ ");
INSERT INTO leu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Taasaxa na Abrahem a kuus, ‘Natuk, naboxo lamon faꞌuli a mo aanabeꞌ: lumua lana toyan siim, no siak a maana mo roxo e na Lasarus a siak a maana mo mosaat. Taasaxa naboxo, lana bina aanabeꞌ nane xo a famaluluman e nano, no toxan a maasaxan. ");
INSERT INTO leu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","E saxa mo vaxa, la palou itaara a Piran a timin a saxa mamata talo rabuna simaam ri pife fexaxaas sena falet xe move e a rabuna simi vaxa ri pife fexaxaas sena filimaan xe nabeꞌ.’ ");
INSERT INTO leu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“E a mataa piran a kuus, ‘Ka Tamaang Abrahem, ne fin nano o no taa feng na Lasarus i paan xe la lifu si tamaang. ");
INSERT INTO leu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ne toxan a mu tiak pama e na Lasarus taa lisan a ferawaian tateak xe siri ulaa nari sait ri tamaa filimaan xe la bina ina maasaxan lava aanabeꞌ.’ ");
INSERT INTO leu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Taasaxa na Abrahem a kuus, ‘Ri toxan a ferawaian aava na Moses e mu rabuna ina kuus fatuxai ri fo kuusane e ri taa langaie.’ ");
INSERT INTO leu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“E a mataa piran a kuus, ‘Piau, Tamaang Abrahem, a pife fexaxaas, taasaxa tamo saxa mataa aava fo maat e a to faꞌulaa ti lana mamaat i taa falet xe siri voxo ri taa puk a xunus iri.’ ");
INSERT INTO leu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Na Abrahem a xuuse, ‘Tamo ri pife langai sena ferawaian si Moses e sena rabuna ina kuus fatuxai, lavaxa naapalaan tamo saxa mataa i taa to faꞌulaa ti la mamaat ri taa pife namkai sena.” ");
INSERT INTO leu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na Yesus a kuus xe sina mu fefeng sina, “A maana mo xaves xena fafaasaal a mu rabuna ri taa savat, taasaxa muluk a mataa aava fasavate. ");
INSERT INTO leu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","A mataa aave i taa mimilisaat temasaat tamo i taa vil fafaasaal a saxa lak modak. A mo roxo ri taa xiute pana faat matafan e tapine la laman. ");
INSERT INTO leu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Faxatang faroxoi nano xa. “Tamo na tiam a faasaal, barase e tamo a puk tapin nane xa xasena vilaana saat sina, lamon tapine. ");
INSERT INTO leu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tamo, lana yaan saxa, i taa bilai fasaat fapisiguak xe siim e i taa ulaa fapisiguak xe siim e kuus, ‘Ne muluk a vilaana saat siak.’ Lavaxa, no lamon tapine.” ");
INSERT INTO leu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A mu yaamut ri kuus xe sina Memai, “Memai, falavai a namkaian simaam.” ");
INSERT INTO leu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nane sui nari, “Tamo a namkaian simi a molava malaan sena fomirak kam ina mastaat, a fexaxaas mi taa kuus xe sina wai aanabeꞌ, ‘Put tapin nano xa e no fe boak la laman’ e i taa langai nano. ");
INSERT INTO leu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Lalamon faagut! Saxa mataa a toxan a mataa faisok aava fuuna faisok la uma o faxatang a mu sipsip sina. Layaan a mataa faisok aave i taa savat, no lamon o a mataa tafuna taa ferawai xe sina malaan, ‘Filimaan, nai e no fangan.’ Piau! ");
INSERT INTO leu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","I taa ferawai malaan, ‘Faigotan a fanganan xaanak, tamasiak e no lisanmaan a fanganan xe siak e lamina bak no taa fangan e num.’ ");
INSERT INTO leu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Naak i taa kuus faasiroxo xe sina mataa faisok sina senaso a vil a faisok sina? Piau! ");
INSERT INTO leu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","E layaan mi fataxapin a maana faisok aava ri xuus nami pana vesanaana, mi taa kuus, ‘Maam pife mu rabuna faisok roxo temasaat senaso maam fo vil a faisok simaam mon e piau ta mo fulaa.” ");
INSERT INTO leu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Lana sangasan sina xe Jerusalem, na Yesus a falet la itina fafalas la palou i Sameria e Galili. ");
INSERT INTO leu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Layaan i taxa laak la saxa bina, a mu rabuna tomexaan sangafilu a tari tapak, ri maa fesuaiane. Ri tigina lasuun famodak ");
INSERT INTO leu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","e ri taxa xukulai faagut, “Yesus, Memai, muluk nemaam!” ");
INSERT INTO leu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Layaan nane xalum nari, a kuus, “Falet, faxalum a mu priis pana tami.” E lana faletan siri, a tari feroxo. ");
INSERT INTO leu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Saxa la palou iri, layaan a xalum a roxoian sina, a ulaa e maa kuus fati a isina Piran pana ling molava. ");
INSERT INTO leu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","A tapiit turung la ka Yesus e kuus faasiroxo xe sina e nane ve a mataa ti Sameria. ");
INSERT INTO leu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Na Yesus a fiai, “Ne lamon o a mataa sangafilu ve tari tapak e ri fo roxo. A xasanofuna ri paan xe faa? ");
INSERT INTO leu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","A saxa mon a ulaa xena kuus fati a isina Piran e nane ve a mataa topen, bo?” ");
INSERT INTO leu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","E a xuuse, “No falet, a namkaian siim fo vil faroxoi nano.” ");
INSERT INTO leu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Saxa yaan a mu Ferasi ri fine pana fatataganan sina Piran taa savat laso, e na Yesus a sui nari, “A fatataganan sina Piran i taa pife savat la matavas. I taa pi ta fakalimaanan talo a rabuna ri taa xalume ");
INSERT INTO leu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","senaso a fatataganan sina Piran taxa waan la xunus imi. Pi ta rabuna ri taa kuus o ‘I taxa waan nabeꞌ’ o ‘I taxa waan pave.” ");
INSERT INTO leu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","E mui a xuus a mu fefeng sina, “A yaan taa savat layaan mi taa vubuk xalum a filimaanan sina Natuna Mataa taasaxa mi taa pife xalume. ");
INSERT INTO leu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","A rabuna taa xuus nami, ‘I taxa waan pave!’ o ‘I taxa waan nabeꞌ!’ Muta fala xolai xena xalum nari. ");
INSERT INTO leu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","A filimaanan sina Natuna Mataa i taa savat malaan sena yaamit. I taa rarapak e famalang a xunavata xapiak, ti paa xe kol. ");
INSERT INTO leu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Taasaxa paamua, i taa maasak faagut lapaana maana mo xaves e a mu rabuna ti tanin ri taa tisuie. ");
INSERT INTO leu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“A mu yaan sina Natuna Mataa ri malaan sena yaan si Noyeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","A mu rabuna lana yaan aave ri pife tamasiak: ri fangan, num e ri tamai. Ri taxa lo fetamai fefexaxaas a yaan na Noyeꞌ laak xe lana xaati aava malaan sena lifu. La yaan aave a ulim molava piis a savat e faxarak xapin nari xapiak aava ri taxa waan lamalei. ");
INSERT INTO leu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lana mu yaan si Lot a malaan vaxa. A mu rabuna ri taxa fangan e num, mamareiai e faasot, kaapis e vavesai. ");
INSERT INTO leu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Taasaxa lana yaan na Lot a taꞌulan na Sodom, a fata e salfa re poxo sivi ti laaꞌui malaan sena raafui e kawaasan xapin nari xapiak. ");
INSERT INTO leu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“E a mu rabuna ti tanin vaxa ri taa pife tamasiak la yaan a Natuna Mataa taa savat la matavas. ");
INSERT INTO leu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lana yaan aave a mataa aava taxa waan laaꞌui la putuna lifu sina, i taa pife sivi e laak xe la lifu xena siak faxuvul a maana mo sina. E a mataa aava taxa faisok la uma vaxa i taa pife ulaa xe la bina xena siak faxuvul a maana mo sina. ");
INSERT INTO leu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lamon faꞌuli a tefin si Lot. ");
INSERT INTO leu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Naseꞌ ta mataa a vubuk tao fatateak a toyan sina nabeꞌ la xavala, i taa pi ta toyan vulai xe vulai. E naseꞌ ta mataa i taa lamon fepalauan a toyan sina nabeꞌ i taa siak a toyan vulai xe vulai. ");
INSERT INTO leu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ne xuus nami o la vung aave layaan ro mataa taxa matef la ivin saxa; saxa i taa malit e saxa i taa waan. ");
INSERT INTO leu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","A ro tefin aava re taxa mimit a mu kam; saxa i taa malit e saxa i taa waan.” ");
INSERT INTO leu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","A rovaat aava re taxa faisok la uma; saxa i taa malit e saxa i taa waan. ");
INSERT INTO leu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","E ri fine, “I taa savat faa, Memai?” E nane sui nari, “Laso ta bina aava toxan a mamaat a mu kor ri taa faxuvul lana.” ");
INSERT INTO leu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","E mui na Yesus a ferawai paap xena fapiti nari talo ri taa fenung vulai e ri taa pife taxapus. ");
INSERT INTO leu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nane kuus, “La saxa bina a toxan a mataa ina tiisan aava pife mataut sena Piran e pife lamon faroxo sena mu rabuna. ");
INSERT INTO leu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","E lana bina aave toxan a tefin nakmaal aava taxa lo savat xena fenung xe sina malaan, ‘Tiis faroxoiau xasena mu xaiyaas siak.’ ");
INSERT INTO leu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Pana maana yaan xaves nane pi lalangai sina tefin aave. Taasaxa nane mamaxus pana fenungan sina e a ilisai, ‘Naapalaan ne pife mataut sena Piran e ne pife lamon faroxo sena mu rabuna ");
INSERT INTO leu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ne taa xavang a tefin nakmaal aanabeꞌ pana tiisan roxo talo i taa pife fasoraxau.” ");
INSERT INTO leu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","E a Memai a kuus, “Lalamon pana ferawaian sina mataa saat ina tiisan. ");
INSERT INTO leu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","A Piran i taa xavang tuunei a mu rabuna sina layaan ri taangiis e fenung xe sina la maana yaan e vung sait, bo? I taa pife waan, waan, waan, xena xavangaan nari, bo? ");
INSERT INTO leu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ne xuus nami o a Piran i taa tavai fatapusan nari pana xakaavangan sina. Taasaxa layaan a Natuna Mataa i taa savat fulaa naak i taa tingin a maana rabuna xaves aava ri taxa namkai o piau, bo?” ");
INSERT INTO leu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na Yesus a ferawai paap malaanabeꞌ xe sina saxano rabuna aava ri lamon o a faisok siri a xaradak e ri xalum fasivi a xasano rabuna ");
INSERT INTO leu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","e a kuus, “A rovaat tomexaan re laak xe lana tang lifu lotu xena fenung xe sina Piran. A saxa mataa ve a Ferasi e a xasafuna ve a mataa ina siak taakis. ");
INSERT INTO leu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","A Ferasi aave a ti fenung pana xa malaan, ‘Piran ne kuus faasiroxo xe siim senaso nenia, ne pife malaan sena xasanofuna aava ri fenau o ri tamai xolai o ri vivil a saat e vaxa ne pife malaan sena mataa ina siak taakis aamove. ");
INSERT INTO leu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nenia, ne fuuna falfaal a yaan taragua ti lana yaan pisiguak e ne tatavai xe siim pana fasangafiluaana maana mo xapiak aava ne siaxe.’ ");
INSERT INTO leu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Taasaxa mataa ina siak taakis a tigina lasuun fadak. Nane tigina pana mangilan e pife kaalum xe laaꞌui la xunavata. Nane sip a famarena e a kuus, ‘Piran muluxau, ne mataa saat.’ ");
INSERT INTO leu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Lavaxa, ne xuus nami o a mataa aanabeꞌ ina siak taakis, nane sang mon a taꞌulan a lifu lotu pana luaian la xunus ina. Senaso nane aava lamon falavai nane xa, a Piran i taa lamon fasivie e nane aava lamon fasivi nane xa, a Piran i taa fatiginei fataxe.” ");
INSERT INTO leu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Saxano rabuna ri taxa lisan a mu rafulak siri xe si Yesus talo i taa tao nari. Layaan a mu fefeng sina ri xalume, ri baras nari. ");
INSERT INTO leu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Taasaxa na Yesus a xel a mu rafulak xe sina e a kuus, “Turoxoian a mu rafulak xena filimaan xe siak e muta ti votan nari senaso a fatataganan sina Piran ve siri. ");
INSERT INTO leu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ne kuus tuuna, naseꞌ ta mataa a pife namkai malaan sena lak dak, i taa pife waan lana fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","A saxa matalava a fine, “Mataa roxo ina fepitaa ne taa vil a so xena siak a toyan xe vulai?” ");
INSERT INTO leu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na Yesus a suie, “Xenaso no xaliau pana mataa roxo? Pi ta mataa roxo, a Piran sang mon a roxo. ");
INSERT INTO leu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","No texaas sena mu vuputkai: muta femilungai pana vilaana ina tamaian, muta punuk mataa, muta fenau, muta kuus xakaavang bit e suai faagut se ninaam nare tamaam.” ");
INSERT INTO leu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","E a matalava aave a kuus, “Nenia, ne fo vil malaan maane ti lana modaxan siak.” ");
INSERT INTO leu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Layaan na Yesus a langaie, a suie, “Saxa vilaana a malit lunai. Faasot pana maana mo xapiak siim e tavai a mu valagof pana faat ina e nano, no taa toxan a fafanaian xaves paaliu la xunavata. E mui, maa usiau.” ");
INSERT INTO leu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Layaan a mataa aave a langaie, nane kanamsaat senaso nane ve a mataa piran pana fafanaian xaves paaliu. ");
INSERT INTO leu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na Yesus a kaalum xe sina e a kuus, “A mo lagaf paaliu layaan a mataa piran a vubuk waan lana fatataganan sina Piran Tuuna. ");
INSERT INTO leu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","A tuuna, a ‘kaamel’ aava tiir molava sena ‘hos’, a fexaxaas sena laak xe lana valof ina niil paamuina mataa piran i taa laak xe lana fatataganan sina Piran Tuuna.” ");
INSERT INTO leu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nari aava ri langaie ri fine, “Naseꞌ a fexaxaas sena fakaxupan?” ");
INSERT INTO leu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","E na Yesus a sui nari, “A so ta mo a matatuuna a pife fexaxaas sena vile a Piran a fexaxaas sena vile.” ");
INSERT INTO leu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na Pita a xuuse, “Maam fo taꞌulan a maana mo simaam xena usiaan nano.” ");
INSERT INTO leu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","E na Yesus a kuus xe siri, “Ne kuus tuuna, naseꞌ ta mataa a taꞌulan a lifu o tefin o mu tina o mu vasaana o mu rafulak sina xena vil a faisok sina Piran ");
INSERT INTO leu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","i taa siak a maana mo xaves naboxo lana yaan aanabeꞌ e mui vaxa lana toyan vulai xe vulai.” ");
INSERT INTO leu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na Yesus a xel patak a mu yaamut sangafilu saxa pana taragua sina e a xuus nari, “Taara taa laak xe Jerusalem e a maana mo aava mu rabuna ina kuus fatuxai fo kala pana sena Natuna Mataa, ri taa savat la matavas. ");
INSERT INTO leu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A mu rabuna aava ri pife Juda ri taa tao fatateaxe e ri taa sarak sena; ri taa kuusan pengane; ri taa xanuse; ri taa inise e ri taa punuxe. ");
INSERT INTO leu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","E la fatalatulaana yaan i taa to faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","A mu fefeng aave ri pife masam pana ferawaian aanabeꞌ senaso a malasuf ina a funan xaseri e a lamonan siri a sotuk. ");
INSERT INTO leu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Layaan na Yesus taxa savatmaan pe Jeriko, a saxa mataa matana piif taxa nai la xasing ina salan. E i taxa fenung faat o xasano mo. ");
INSERT INTO leu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Layaan nane langai a ling ina malila aava ri taxa sangas et, nane fiai ri taxa so. ");
INSERT INTO leu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","E ri xuuse, “Na Yesus ti Nasaret i taxa filimaan.” ");
INSERT INTO leu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","E nane xukulai, “Yesus, Lak si Devit, muluxau.” ");
INSERT INTO leu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nari aava ri sangas paamuin a malila, ri barase e ri xuuse o i taa nai kasam. Taasaxa nane xukulai faagut maan, “Lak si Devit, muluxau.” ");
INSERT INTO leu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Na Yesus a tigina e a xuus faagutan a rabuna o ri taa lisanmaane. Layaan a maa savat faasilak la tana, na Yesus a fine, ");
INSERT INTO leu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“No vubuk rao ne taa vil a so xaanum?” E nane suie, “Memai, ne buk kaalum.” ");
INSERT INTO leu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na Yesus a xuuse, “Monabeꞌ mon kaalum. A namkaian siim fo vil faroxoi nano.” ");
INSERT INTO leu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Fataapus nane fexaxaas sena kaalum e a usi na Yesus e i taxa lo kuus fati a isina Piran. Layaan a mu rabuna ri xalume, nari vaxa ri kuus fati a isina Piran sait. ");
INSERT INTO leu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na Yesus a laak la bina Jeriko e i taxa falet vuak lana. ");
INSERT INTO leu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Saxa mataa piran aava paamua ina mu rabuna ina siak taakis, i taxa waan pave, isina na Sekias. ");
INSERT INTO leu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nane buk xalum na Yesus taasaxa nane ve a mataa xaxaalif e pife fexaxaas sena xalume sena malila. ");
INSERT INTO leu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nane texaas sena salan aava na Yesus i taa sangas et lana e voxo nane fala paamu e fe fani a wai sikamo xena xalumaana. ");
INSERT INTO leu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Layaan na Yesus a savatmaan lapaana wai aave a kaalum xe laaꞌui e a kuus xe sina, “Sekias, sivimaan monabeꞌ mon. Ne taa waan xuvul pama tanin.” ");
INSERT INTO leu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nane sivimaan fataapus e a kas a lifu sina xe si Yesus pana faamamaasan. ");
INSERT INTO leu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","A mu rabuna xapiak ri xalum a vilaana si Yesus e ri ferawai lilimugai, “Nane fo laak xe lana lifu sina saxa ‘mataa fafasaal’.” ");
INSERT INTO leu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Taasaxa na Sekias a tigina e a ferawai xe sina Memai, “Kaalum Memai, monabeꞌ mon ne taa tavai a mu valagof pana xavil ina maana mo siak. E tamo ne fo suaxan a mataa e ne siak a maana mo sina, ne taa lisan faꞌuli fatalafaatan a mo aave.” ");
INSERT INTO leu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na Yesus a xuuse, “Tanin, a mu rabuna lana lifu aanabeꞌ ri fo fakaxupan senaso a mataa aanabeꞌ vaxa a lak si Abrahem. ");
INSERT INTO leu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","A Natuna Mataa maa savat nabeꞌ xena sengaana mu rabuna aava ri fo milung xena fakaxup nari.” ");
INSERT INTO leu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na Yesus taxa savat faasilak xo la bina Jerusalem e a mu rabuna ri lamon o a fatataganan sina Piran i taa savat monabeꞌ mon. E voxo layaan a malila ri taxa langai faagut lunai na Yesus a ferawai paap xe siri. ");
INSERT INTO leu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nane kuus, “A saxa mataa piran a falet lasuun xe la xasa bina talo i taa siak a ngavuk ina paamua king. E mui i taa ulaamaan. ");
INSERT INTO leu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Paamuina paanan sina nane xel faxuvul a mu sisiak sangafilu sina e tavai nari saxa saxa pana K1000 e a xuus nari o ri taa faisok pana e falavaie fefexaxaas a yaan i taa ulaa. ");
INSERT INTO leu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Taasaxa mu rabuna la fatataganan sina ri baiane e ri feng a mu matalava siri o ri taa usie xe la bina lasuun xena kuus o ri baian nane i taa paamuian nari. ");
INSERT INTO leu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Taasaxa mataa piran aave a faꞌisinan pana paamua king siri e a ulaa xe la bina sina. Layaan nane savat, a xel faxuvul a mu sisiak sina xena texaas o ri fo faisok malaafaa pana mu faat sina. ");
INSERT INTO leu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Saxa maa xuuse, ‘Matalava, no tavaiau pana K1000 e naboxo ne fo siak a K10,000 xaanum.’ ");
INSERT INTO leu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“E a mataa piran aave a xuuse, ‘A faisok roxo paaliu! Nano, no sisiak roxo. No fo faxatang faroxoi a valafaat siak e voxo ne texaas o ne fexaxaas sena tavai tuunei nano pana faisok lava ina paamuian a bina sangafilu.’ ");
INSERT INTO leu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“A fataraguiaana sisiak maa savat e a xuuse, ‘Matalava, pana K1000 siim ne fo fasavat a K5000 xaanum.’ ");
INSERT INTO leu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“E a mataa piran aave a kuus, ‘Lavaxa nano, no taa paamuian a bina pama.’ ");
INSERT INTO leu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“E a xasa sisiak maa savat sina e a kuus, ‘Matalava, ne fo tao fatateak a K1000 siim. Ne fune lana marapi. ");
INSERT INTO leu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ne mataut sema senaso nano ve no mataa tateak. No siak tapin a mo aava pife siim e no siak faxuvul a mo no pife xapise.’ ");
INSERT INTO leu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“A mataa piran sina a suie, ‘Ne taa tiis nano pana ferawaian siim! Nano, no sisiak saat. No texaas o ne mataa tateak, bo? Ne fuuna siak tapin a maana mo aava pife siak e ne fuuna siak faxuvul a maana mo ne pife xapise, bo? ");
INSERT INTO leu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Xenaso no pife fawaan a faat siak lana lifu ina faat talo layaan ne ulaamaan ne taa siaxe pana mamareiai ina?’ ");
INSERT INTO leu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“E nane ferawai xe siri aava ri taxa tigina faasilak, ‘Siak tapin a K1000 sina e tavai a sisiak aava toxan a K10,000 pana.’ ");
INSERT INTO leu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“E nari, ri kuus, ‘Taasaxa Matalava, a sisiak aave xo fo toxan a K10,000.’ ");
INSERT INTO leu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“E a mataa piran a kuus, ‘Ne xuus nami o naseꞌ ta mataa a toxan a mo i taa siak a xasano mo fulaa. Taasaxa, nane aava piau ta mo, a mo modak aava nane toxane, i taa siak tapinan xasena. ");
INSERT INTO leu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","E naboxo, a mu xaiyaas siak aava ri bai o nenia, ne taa paamuian nari, lisanmaan nari e punuk nari la mataak.” ");
INSERT INTO leu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Layaan na Yesus fo kuus xapiak malaan nane sangas laak paamua xe la bina Jerusalem. ");
INSERT INTO leu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Layaan i taxa savatmaan xe la ro bina, Betfas nare Betani aava re waan la put modak ri xalie pana Put Olif, nane feng a ro fefeng sina e a kuus xe sire, ");
INSERT INTO leu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Falet fatak xe la bina aapave e layaan me laak lana me taa tingin a saxa ‘donki’ aava piau ta mataa fo nai xuluna. Muluse e lisanmaane xe nabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tamo ta mataa i taa fin name, ‘Xenaso me taxa mulus tapine?’ Me taa xuuse, ‘A Memai a vubuxane.” ");
INSERT INTO leu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nare aava nane fo feng nare, re tingin a maana mo malaan sena kuusan sina. ");
INSERT INTO leu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","E layaan re taxa mulus a natuna ‘donki’, a mu mataa tafuna ‘donki’ aave ri fin nare, ‘Xenaso me taxa mulus a ‘donki’?’ ");
INSERT INTO leu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","E re suie, ‘A Memai a vubuxane.’ ");
INSERT INTO leu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Re ulaamaan pana xe si Yesus e re xafut a mina natuna ‘donki’ pana marapi ina xakaafutan sire e re fanei na Yesus xuluna. ");
INSERT INTO leu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Layaan i taxa falet, a mu rabuna ri sului a marapi siri la salan. ");
INSERT INTO leu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Layaan nane maa savat faasilak la salan aava sivi xe la Put Olif, a malila ina mu fefeng sina ri tangpat pana kuus fati a isina Piran. Ri xukulai faagut pana faamamaasan sena maana mo faꞌipul ri fo xalume. ");
INSERT INTO leu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ri kuus, “A Piran King aava savat lapaana isi Memai, a naian sina i taa roxo paaliu.” “A luaian taxa waan la xunavata e a suaian molava piis xe sina Piran aava waan la xunavata.” ");
INSERT INTO leu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Saxano Ferasi la palou ina malila ri xuus na Yesus, “Mataa ina Fepitaa, baras a mu fefeng siim.” ");
INSERT INTO leu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Taasaxa na Yesus a sui nari, “Ne xuus nami o tamo nari, ri taa kasam a mu faat la xavala ri taa xukulai pana faamamaasan.” ");
INSERT INTO leu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nane taxa sivi xe pe Jerusalem e layaan a xalume, nane tangiis soxote ");
INSERT INTO leu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","e a kuus, “Monabeꞌ mon a luaian xe vulai fo savat la taam. Taasaxa nano, no pife texaas sena. No tisuie e naboxo fo liu nano. ");
INSERT INTO leu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Lana yaan xe mui a mu xaiyaas siim ri taa xaf faxuvul a xavala la tana vaabat siim. E ri taa fakaliuan nano e ri taa tivotan a xakaavangan sina xasano rabuna xasema. ");
INSERT INTO leu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ri taa kawaasan nano e a mu rabuna aava ri taxa waan lana vaabat siim. Piau ta faat i taa waan xuluna xasa faat senaso no ngalngolan a yaan layaan a Piran a savat xena fakaxup nano.” ");
INSERT INTO leu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","E mui nane laak la tang lifu lotu e fe xup tapin a mu rabuna ina faasot lana. ");
INSERT INTO leu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","E a kuus, “Lana Xakalayan Taap a kuus, ‘A lifu siak ve a lifu ina fenungan.’ taasaxa ‘sena vilaana simi ri xalie pana nobina ina fufunai sina mu rabuna fafenau.’ ");
INSERT INTO leu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","A maana yaan xapiak nane taxa fepitaa lana lifu lotu aave. Taasaxa mu paamua priis, mu rabuna ina fepitaa pana vuputkai e mu matalava, ri taxa lo seng ta salan xena punuxaana. ");
INSERT INTO leu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Taasaxa ri pife fexaxaas sena vile senaso a mu rabuna ri buk langai vulan a ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Saxa yaan pe la lifu lotu, layaan na Yesus i taxa fapiti a mu rabuna e kuusan famatavas a Lagasai Roxo, a mu paamua priis e mu rabuna ina fepitaa pana vuputkai xuvul pana mu matalava, ri maa savat sina ");
INSERT INTO leu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","e ri xuuse, “Xuus tuunei nemaam, lapaana tateaxan iseꞌ no taxa vil a maana mo aanabeꞌ? Naseꞌ tuuna a tavai nano pana tateaxan aanabeꞌ?” ");
INSERT INTO leu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nane sui nari, “Nenia vaxa, ne buk fin nami pana saxa mo. Xuusau, ");
INSERT INTO leu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","a fasufan si Jon a savat ti laaꞌui la xunavata o sina matatuuna?” ");
INSERT INTO leu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ri feferawai la palou iri e ri kuus, “Tamo taara taa kuus o a savat ti laaꞌui la xunavata, i taa fin netaara, ‘Xenaso mi pife namkai sena?’ ");
INSERT INTO leu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Taasaxa tamo taara taa kuus o ‘sina matatuuna’ a mu rabuna ri tamaa soxoi netaara pana faat senaso ri namkai se Jon va mataa ina kuus fatuxai.” ");
INSERT INTO leu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","E voxo ri suie, “Maam pife texaas o a savat ti faa.” ");
INSERT INTO leu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","E na Yesus a kuus, “E nenia vaxa ne taa pife xuus nami o ne taxa vil a maana mo aanabeꞌ lapaana tateaxan iseꞌ.” ");
INSERT INTO leu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na Yesus a xuus a mu rabuna pana ferawaian paap aanabeꞌ: “Saxa mataa a xapis a uma wain sina e a turoxoian a xasano rabuna xena faxatange. E nane fe paan xe lasuun la saxa bina e fe waan pana mariaas xaves. ");
INSERT INTO leu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","La yaan ina siak faxuvul a mu xalana wain nane feng a saxa sisiak sina xe siri xena siaxaana saxano xalana wain xana. Taasaxa rabuna ina faxatangaana uma aave, ri sipe e ri feng tapin paloue. ");
INSERT INTO leu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A mataa aave a feng a xasa sisiak sina fulaa e nane vaxa ri fesipe e ri vil famangile. E ri feng tapin paloue. ");
INSERT INTO leu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A mataa aave a feng a fatalatulaana sisiak sina e ri sip faagutane e ri tapine. ");
INSERT INTO leu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“E a mataa tafuna uma aave a kuus, ‘Ne taa vil a so? Aa! ne taa feng a lak tomexaan siak aava ne vubuxan xasingite. Naak ri taa suai sena.’ ");
INSERT INTO leu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Taasaxa layaan a mu rabuna ina faxatangaana uma ri xalume ri ferawai e ri kuus, ‘A lak tomexaan aanabeꞌ ve a lak tuaan. I taa siak a maana mo xapiak si tamana. Taara taa punuxe xena siaxaana maana mo aave.’ ");
INSERT INTO leu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","E voxo ri tapine xe lamalei e ri ngaapunuxe.” E na Yesus a fin nari, “A mataa tafuna uma aave i taa vil a so xe siri aava ri taxa faxatang a uma? ");
INSERT INTO leu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ne xuus nami, a mataa tafuna uma aave i taa ngaapunuk nari e i taa tavai a xasano rabuna pana uma wain sina.” Taasaxa layaan a rabuna ri langaie, ri kuus, “Piau, i muta vil malaane!” ");
INSERT INTO leu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Na Yesus a kaalum fatak xe siri e a fiai, “Lavaxa, lana Xakalayan Taap a so ta malasuf a waan lapaana ferawaian aanabeꞌ: “A faat aava mu rabuna ina vavesai ri baiane, a faat naang xo fo savat pelalava.” ");
INSERT INTO leu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A mu rabuna sasaxayai aava ri poxo xuluna faat aave ri taa tugurum taasaxa nane aava faat aave a poxo xuluna, i taa tamimit.” ");
INSERT INTO leu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","A mu rabuna ina fepitaa pana vuputkai xuvul pana mu paamua priis, ri seng a salan xena pis fatapusan na Yesus senaso ri texaas o nane fo ferawai seri pana ferawaian paap aanabeꞌ. Taasaxa ri matautan a mu rabuna. ");
INSERT INTO leu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ri taxa waan bang a yaan fatak xena pisaan na Yesus e voxo ri feng a rabuna xena falet xe sina malaan sena rabuna roxo. Ri vubuk rao ri taa familung na Yesus pana ferawaian sina. Tamo nane taa vil malaane ri fexaxaas sena lisane xe sina paamua siri ti Rom talo i taa waan lapaana gutan sina. ");
INSERT INTO leu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","E voxo ri fin na Yesus, “Mataa ina Fepitaa, maam texaas o no fuuna ferawai e fepitaa pana maana mo aava fatak e no fapiti fatak a rabuna pana salan tuuna sina Piran e no pife lamon o naseꞌ pana isin lava. ");
INSERT INTO leu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Xuus nemaam, a mo roxo taara taa maraan a taakis si Sisaa o piau?” ");
INSERT INTO leu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Na Yesus fo texaas sena bitan siri e a kuus xe siri, ");
INSERT INTO leu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Faxalitau pana saxa faat. A xaxaalua xuvul pana xakalayan siseꞌ taxa waan xuluna?” ");
INSERT INTO leu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ri suie, “Si Sisaa.” E nane xuus nari, “Lavaxa, tavai na Sisaa pana maana mo sina e tavai a Piran pana maana mo sina.” ");
INSERT INTO leu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ri pife fexaxaas sena familunge pana ferawaian sina la matana rabuna. E ri ipul sena susuaa sina e ri fexanakut. ");
INSERT INTO leu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saxano Sedusi ri maa savat si Yesus. (Nari, ri fuuna kuus o piau ta to faꞌulaian ti la maatan.) E ri kuus, ");
INSERT INTO leu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Mataa ina Fepitaa, na Moses fo xalei a vuputkai aanabeꞌ xataara: tamo mataa a maat tapin a tefin e piau ta rafulak, a tina aava taxa to lunai, i taa tamai sina tefin aave e i taa fasavat a lak xa tina aava fo maat. ");
INSERT INTO leu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Lavaxa, a toxan a fetinan pisiguak e saxa a tamai sina saxa tefin. Nane maat tapine pana piau ta lak. ");
INSERT INTO leu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A fataraguiaana tina a tamai sina tefin aave e nane vaxa a maat pana piau ta lak. ");
INSERT INTO leu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A fatalatulaana tina vaxa a maat tapine e malaan seri pisiguak xapiak ri maat e ri piau ta lak. ");
INSERT INTO leu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","E mui a tefin naang xo a maat. ");
INSERT INTO leu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lavaxa, lana yaan ina to faꞌulaian ti la maatan a tefin aave i taa naasaseꞌ tuuna? Nari pisiguak xapiak aave ri tamai sina.” ");
INSERT INTO leu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na Yesus a sui nari, “A mu rabuna ti tanin ri taxa tamai. ");
INSERT INTO leu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Taasaxa nari aava Piran a lamon faroxo pari xena fatatoi faꞌuli nari ti la maatan lana yaan i taa savat, ri taa pife tamai. ");
INSERT INTO leu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nari, ri malaan sena mu angelo senaso ri taa pife maat taasaxa ri mu rafulak sina Piran senaso ri fo to faꞌulaa ti la maatan. ");
INSERT INTO leu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Na Moses a faxaalit famatavas pana to faꞌulaian ti la maatan. Lana xuuskuus ina latan i taxa raam, nane ferawai pana Piran malaan: ‘Nane ve a Piran si Abrahem, a Piran si Aisaak e a Piran si Yaakop.’ ");
INSERT INTO leu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nane pife Piran sina mu mamaat, piau. Nane ve a Piran sina mu rabuna aava ri taxa to e la matana Piran a mu rabuna xapiak ri taxa to.” ");
INSERT INTO leu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Saxano rabuna ina fepitaa pana vuputkai ri kuus, “A susuaa roxo, Mataa ina Fepitaa!” ");
INSERT INTO leu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","E pi ta saxa a fine panꞌ ta mo fulaa. ");
INSERT INTO leu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","E na Yesus a kuus xe siri, “Malaafaa a rabuna ri kuus o a Mataa Failai a lak si Devit? ");
INSERT INTO leu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Senaso lana mu Yanganan, na Devit xa a kuus: ‘A Memai a kuus xe sina Memai siak, “Nai suꞌ la pamuaan siak ");
INSERT INTO leu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","fefexaxaas a yaan ne timin a mu xaiyaas siim lapaana kaam malaan sena vena vaapaas.” ’ ");
INSERT INTO leu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na Devit a xalie pana ‘Memai’. Malaafaa nane a lak si Devit?” ");
INSERT INTO leu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Layaan a mu rabuna taxa langai, na Yesus a xuus a mu yaamut sina, ");
INSERT INTO leu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Faxatang sena mu rabuna ina fepitaa pana vuputkai. Ri fuuna famaus a tari pana marapi modus xena sangas xolai e ri vubuk o a mu rabuna ri taa suai seri. E vaxa ri buk nai la vepen lava lana lifu ina faxuvulan e lana mu fenamo. ");
INSERT INTO leu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ri pife lamon faroxo pana lutefin nakmaal e ri kawaasan a waanan siri e mui ri ti fenung faxaarus talo a rabuna ri taa xalum nari. A mu rabuna malaan, a Piran i taa fakasanam faagutan nari.” ");
INSERT INTO leu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Layaan nane kaalum xolai, nane xalum a mu mataa piran aava ri taxa timin a tatavai siri lana mo ina tifiaana maana tatavaian la lifu lotu. ");
INSERT INTO leu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nane xalum a saxa tefin nakmaal vaxa i taxa tatavai pana ro faat modak paaliu. ");
INSERT INTO leu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na Yesus a kuus, “Ne xuus tuunei nami, a tefin nakmaal aanabeꞌ a tatavai pana mo molava paaliu sena xasanofuna xapiak. ");
INSERT INTO leu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Senaso nari mu piran, ri tatavai pana xavil mon ti lana fafanaian siri. Taasaxa nane ve a tefin valagof e a tatavai pana maana mo xapiak sina.” ");
INSERT INTO leu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Saxano fefeng si Yesus ri taxa lo ferawai pana xakaaluman aava magaaf faroxo ina lifu lotu. A lifu aave ri famaus faroxoi paaliuane pana maana faat roxo e pana maana tatavaian roxo malaan sena ‘gol’. ");
INSERT INTO leu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Taasaxa na Yesus a kuus, “A mo mi taxa xalume naboxo, saxa yaan i taa filimaan e mi taa pife xalum ta saxa faat ina i taa mati laaꞌui xulunꞌ ta xasa faat, nari xapiak ri taa tagalas xe lapia.” ");
INSERT INTO leu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","E ri fine, “Mataa ina Fepitaa, laso ta yaan tuuna a maana mo aanabeꞌ ri taa savat? E a so ta mo i taa fakalimaan a yaan layaan a maana mo aanabeꞌ ri taa savat?” ");
INSERT INTO leu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","E nane sui nari, “Faxatang faroxo ulaa ri tamaa bit nami. Senaso a maana rabuna xaves ri taa filimaan lapaana isaak e ri taa kuus o ‘Nenia ve ne Mataa Failai’, e ‘A yaan ina kawaasanan ve i taxa faasilak.’ Ai, taasaxa muta usi nari. ");
INSERT INTO leu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","E layaan mi taa langai pana maana fevisan, muta mataut. A maana mo aanabeꞌ ri taa savat paamua taasaxa fataxapiak ina yaan i taa pife savat monabeꞌ mon.” ");
INSERT INTO leu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","11","E mui nane kuus xe siri, “A maana mu bina ri taa fevisan nari. Ri taa toxan a maana maraꞌulia molava, a song molava e a maana buk giisan lava ri taa savat la maana mu bina. E ti laaꞌui la xunavata a maana mo famataut e maana fakalimaanan molava ri taa savat. ");
INSERT INTO leu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Paamuina yaan aave ri taa yot nami e ri taa vil pengan nami. Ri taa lisan nami xe lana mu lifu ina faxuvulan e lana bina ina vipisan. Ri taa fatiginei nami la nona mu king e mu paamua ina gavamen sena isaak mon. ");
INSERT INTO leu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","E voxo mi fexaxaas sena xuus nari pana maana faisok sina Piran. ");
INSERT INTO leu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Taasaxa, lana lamonan simi mi muta lamon faaxaves pana so ta mo mi taa kuusane. ");
INSERT INTO leu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Senaso ne taa tavai nami pana ferawaian e texaasan aava mu xaiyaas simi ri taa pife faaxolusane. ");
INSERT INTO leu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","A mu tamami e mu ninami, mu timi e mu fesing simi ri taa pet lisan nami e saxanofuna imi ri taa punuk nami. ");
INSERT INTO leu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","A mu rabuna xapiak ri taa baian nami senaso mi namkai sega. ");
INSERT INTO leu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Taasaxa mi taa waan faroxo; piau ta fui la putumi i taa malit. ");
INSERT INTO leu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tamo mi taa tigina fatateak vulai lana namkaian simi, mi taa siak a toyan xe vulai.” ");
INSERT INTO leu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Layaan mi xalum a mu rabuna ina rawen, ri taxa kaliuan na Jerusalem, mi taa texaas o a yaan ina kawaasanaana fo faasilak. ");
INSERT INTO leu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Lana yaan aave a mu rabuna ti la maana mu bina pe Judia aava ri taxa fakaliuan na Jerusalem, ri taa sinuf xe xuluna maana mu put e nari aava ri waan pe Jerusalem, ri taa taꞌulan a bina aave. Nari aava ri taxa waan lamalei se Jerusalem ri taa pife laak xe lana. ");
INSERT INTO leu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Senaso a yaan ina fakasanaman aanabeꞌ a yaan aava mu rabuna ina kuus fatuxai, ri fo ferawai pana. ");
INSERT INTO leu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","A lagafan molava paaliu i taa savat sina lutefin ri tiva e nari aava ri taxa fasus a rafulak siri. Sena maraleian sina Piran xe siri mu Juda i taa toxan a maana lagafan molava paaliu ri taa savat. ");
INSERT INTO leu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ri taa punuk nari lana fevisan. E ri taa yot nari e lisan nari xe la bina ina vipisan la maana bina xapiak. A rabuna aava ri pife Juda, ri taa paasan xolan na Jerusalem fefexaxaas a yaan aava Piran fo kuusane. ");
INSERT INTO leu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“I taa toxan a maana fakalimaanan lana ngaas, fulun e la maana vapara. Xuluna xavala a mu rabuna ri taa mataut e ri taa pife texaas o malaafaa a xaing i taxa tibur falava. ");
INSERT INTO leu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","A mu rabuna xapiak ri taa maat faxavil pana matautan layaan ri xalum a maana mo ti laaꞌui la vata ri taxa radakui senaso ri pife texaas sena so ta mo i taa savat la xavala. ");
INSERT INTO leu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Lana yaan aave ri taa xalum a Natuna Mataa i taxa filimaan lana vata pana gutan e pana malang molava paaliu. ");
INSERT INTO leu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Layaan a maana mo aanabeꞌ ri taxa savat, tigina fatateak lana namkaian simi senaso a fakaxupaan nami i taxa filimaan faasilak.” ");
INSERT INTO leu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","30","Nane xuus nari pana ferawaian paap aanabeꞌ: “Layaan mi xalum a novala taxa rul mi texaas o a yaan ina fenamo i taa savat. ");
INSERT INTO leu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","E layaan mi xalum a maana mo aave ri taxa savat, mi taa texaas o a fatataganan sina Piran fo faasilak. ");
INSERT INTO leu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ne kuus tuuna xe simi o a mu rabuna xapiak aanabeꞌ ri taa pife malit xapiak paamuina yaan a maana mo aanabeꞌ ri taa savat. ");
INSERT INTO leu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","A xunavata e xavala re taa taxapus, taasaxa maana ferawaian siak ri taa waan vulai. ");
INSERT INTO leu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Faxatang faroxo! A pife roxo tamo no taa lalamon faagut sena maana mo ti la xavala malaan sena mu fenamo, numaana raarum tateak e a maana lagafan ina toyan nabeꞌ e a yaan aave i taa savat faꞌipulan nano malaan sena vio aava sangas vaang laak marasaxa lana filung. ");
INSERT INTO leu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","A maana mo aanabeꞌ i taa savat e piau paaliu ta mataa i taa sinufane. ");
INSERT INTO leu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","E voxo, faxatang faroxo vulai e fenung talo no fexaxaas sena sinufan a maana mo aava i taa savat e no taa tigina la nona Natuna Mataa.” ");
INSERT INTO leu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Maana yaan xapiak na Yesus taxa fepitaa la lifu lotu e maana vung nane taꞌulai xena falet xe xuluna Put Olif. ");
INSERT INTO leu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","E la paanen lolof a maana rabuna xaves ri fuuna savat soxote xena langaiaana fepitaian sina pe lana lifu lotu. ");
INSERT INTO leu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Faasilak naboxo a yaan ina Fenamo ina Bret A Piau Ta Yiis aava ri xalie pana Paaliuan, i taa savat. ");
INSERT INTO leu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","A mu paamua priis e mu rabuna ina fepitaa pana vuputkai, nari xapiak ri mataut sena malila e voxo ri vubuk rao ri taa punuk fun na Yesus. ");
INSERT INTO leu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","E mui na Judas aava ri xalie pa Iskeriot, a saxa ti la palou ina mu yaamut sangafilu saxa pana taragua, na Setan a lam la xunus ina. ");
INSERT INTO leu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","E voxo na Judas a falet e fe ferawai xuvul pana mu paamua priis e mu matalava aava ri faxatang a lifu lotu. Ri ferawai pana malaafaa i taa pet lisan na Yesus xe siri. ");
INSERT INTO leu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nari, ri faamamaas e ri kuus o ri taa tatavai xe sina pana faat. ");
INSERT INTO leu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na Judas a turoxo pana e seng xo ta salan xena pet lisanaan na Yesus xe siri talo rabuna ri taa vungut sena. ");
INSERT INTO leu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","La fena Paaliuan a yaan ina punuk a sipsip xena fenamo a savat. ");
INSERT INTO leu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","E na Yesus a feng na Pita nare Jon pana fefasaian aanabeꞌ, “Falet e fe faigotan a fenamo ina Paaliuan talo taara fexaxaas sena fangan.” ");
INSERT INTO leu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","E re fine, “Maame taa faigotane faa?” ");
INSERT INTO leu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","E nane sui nare, “Layaan me taxa laak la bina, saxa mataa aava i taxa yaas a mo ina raarum, i taa fasusui name, usie e laak lana lifu aava i taa laak lana ");
INSERT INTO leu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","e xuus a mataa tafuna lifu, ‘A Mataa ina Fepitaa i taxa fiai pana faa ta nobina ina nganaana Paaliuan xuvul pana mu yaamut siak?’ ");
INSERT INTO leu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","E nane taa faxalit name pana nobina roxo e pave me taa faigotan a maana mo.” ");
INSERT INTO leu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Re falet e a maana mo a savat fexaxaas malaan se Yesus fo xuus nare pana e re faigotan a fenamo ina Paaliuan. ");
INSERT INTO leu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A yaan fatak xo a savat e na Yesus a nai la vepen sina la ivin xuvul pana mu yaamut. ");
INSERT INTO leu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Nane xuus nari, “Ne vubuk temasaat o ne taa fangan lana fenamo ina Paaliuan aanabeꞌ xuvul pami paamuina maasaxan siak. ");
INSERT INTO leu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Senaso ne xuus nami, ne taa pife ngan fulan a fanganan malaan fefexaxaas taara taa fangan faxuvul fulaa la fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","E mui na Yesus a siak a lisa e fenung xe sina Piran pana e a kuus, “Siak a lisa ina wain aanabeꞌ e fepatoxane la palou imi. ");
INSERT INTO leu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ne xuus nami o ne taa pife num fulan a wain aanabeꞌ fefexaxaas a yaan a fatataganan sina Piran i taa savat la matavas.” ");
INSERT INTO leu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","E mui nane siak a nebret e fenung xe sina Piran pana e viaxe e tavai nari pana e a kuus, “Nabeꞌ ve a vipin siak aava ne taxa tatavai pana xami. Usi a vilaana aanabeꞌ xena lamon faꞌuliau.” ");
INSERT INTO leu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","E lamina fanganan, nane tao a lisa ina wain e a kuus, “A lisa ina wain aanabeꞌ a kuus turoxoian faꞌui sina Piran e ne taxa kuus turoxo sena pana ria iga aava i taa talatiu xami. ");
INSERT INTO leu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Taasaxa kaalum, a saxa aava i taa pet lisanau naboxo i taxa waan nabeꞌ la palou itaara. ");
INSERT INTO leu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","A Natuna Mataa i taa maat senaso a Piran xa fo lamon faati pana, taasaxa ne taxa muluk marasaxain a saxa aava i taa pet lisanau.” ");
INSERT INTO leu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","E mui ri fefiai xolai naseꞌ tuuna ti la palou iri i taa vil a mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A mu yaamut ri fegagelai o naseꞌ ti la palou iri i taa matalava siri. ");
INSERT INTO leu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","E na Yesus a xuus nari, “A mu piran sina rabuna ri fuuna paamuian a rabuna pana gutan e a mu paamua pana tateaxan ri xalian pana ‘Fesing sina Rabuna’. ");
INSERT INTO leu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Taasaxa vilaana aanabeꞌ pife vilaana simi, piau! A matalava simi i taa malaan sena lak e a paamua simi i taa xakaavang malaan sena sisiak. ");
INSERT INTO leu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Naseꞌ a matalava? A saxa aava nai fangan o a saxa aava tigina faasilak xena sisiak xe sina? A mataa aava taxa nai fangan, bo? Taasaxa nenia, ne waan la palou imi malaan sena sisiak mon. ");
INSERT INTO leu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nami, mi fo waan xuvul paga lana matafanan siak. ");
INSERT INTO leu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na Tamaang a tavaiau pana ngavuk ina Memai e voxo ne fexaxaas ne taa tavai nami pana sait. ");
INSERT INTO leu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","E mi taa fangan e num la ivin lana fatataganan siak e vaxa mi taa nai la vena Memai xena tiisaana pabung sangafilu saxa pana taragua sina mu Israel. ");
INSERT INTO leu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon, Saimon, langai! Na Setan a vubuk rao i taa valam nano; i taa fepatoxan nano malaan sena kam e a xawa, a xavil ina i taa waan e a xavil ina no taa tapine. ");
INSERT INTO leu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Taasaxa ne fo fenung pama, Saimon, talo a namkaian siim i taa pife poxo. E layaan no ulaa xe siak, fagut a mu tiam.” ");
INSERT INTO leu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Taasaxa na Pita a suie, “Memai, ne taa vipis e maat xuvul pama.” ");
INSERT INTO leu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na Yesus a suie, “Ne xuus nano, Pita, a pura taa pife taliskukuk lunai e no taa faaxolusanau faatalatul.” ");
INSERT INTO leu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","E na Yesus a fin nari, “Layaan ne feng nami xe la nu bina e mi piau ta faat o marapi o ‘slipa’, a maana mo simi a fexaxaas o piau?” E ri suie, “A fexaxaas.” ");
INSERT INTO leu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","E nane xuus nari, “Taasaxa naboxo, tamo no toxan ta faat, siaxe e taaxanum ta bi, e tamo no piau ta pinis, faasot pana marapi siim xena maraan taaxanum. ");
INSERT INTO leu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","A Xakalayan Taap a kuus, ‘Ri xalie pana mataa fafaasaal.’ A mo aanabeꞌ i taa savat la matavas sega. Aang, a lagasai sega i taxa savat la matavas monabeꞌ mon.” ");
INSERT INTO leu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","E a mu yaamut ri kuus, “Kaalum Memai, a toxan a pinis taragua.” E nane sui nari, “A fexaxaas.” ");
INSERT INTO leu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na Yesus a taꞌulan a bina e falet xe la Put Olif malaan sena vilaana sina e a mu yaamut sina ri usie. ");
INSERT INTO leu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Layaan ri savat pave a xuus nari, “Fenung talo mi taa pife poxo lana tatafangan.” ");
INSERT INTO leu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nane taꞌulan nari, taasaxa pife lasuun temasaat, e fe bukaak e fenung, ");
INSERT INTO leu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Tamaang, tamo no vubuxane, siak tapin a lisa ina maasaxan aanabeꞌ i taa savat xulok. Taasaxa pife vubuxanan siak i taa savat, a vubuxanan siim.” ");
INSERT INTO leu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","A angelo ti laaꞌui la xunavata a savat xe sina e fagute. ");
INSERT INTO leu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","E lana mimilisaatan molava paaliu sina nane fenung faagut fulaa e a maxarafan sina, malaan sena ria, taxa poxo xe lapia. ");
INSERT INTO leu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nane fataxapin a fenungan sina e tamasiak e ulaa xe sina mu yaamut e fe tingin nari ri taxa matef senaso ri maagus pana mimilisaatan siri. ");
INSERT INTO leu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Nane fin nari, “Senasou mi taxa matef? Para e mi fenung talo mi taa pife poxo lana tatafangan.” ");
INSERT INTO leu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","La fena ferawaian sina a malila ri savat xuvul pa Judas, a saxa ti la palou ina mu yaamut sangafilu saxa pana taragua, e i taxa paamuianmaan nari. Nane sangasmaan xe si Yesus xena ngusaana. ");
INSERT INTO leu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Taasaxa na Yesus a fine, “Judas, no taxa pet lisan a Natuna Mataa pana fengusan, bo?” ");
INSERT INTO leu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Layaan a fefeng si Yesus ri xalum a so ta mo i taxa savat, ri kuus, “Memai, taara taa fevis pana pinis sitaara?” ");
INSERT INTO leu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","E a saxa a sip a sisiak sina priis lava e patal a tangana la pamuaan. ");
INSERT INTO leu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Taasaxa na Yesus a suie, “Mune.” E nane tao faroxoi a tangana sisiak aave. ");
INSERT INTO leu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","E mui na Yesus a ferawai xe sina mu paamua priis, mu paamua sina rabuna ina faxatang a lifu lotu e mu matalava, nari xapiak aava ri savat xena pisaana e a kuus, “Mi filimaan pana tol e vam xena pisaan nenia malaan sena paamua ina rabuna mosaat paaliu, bo? ");
INSERT INTO leu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","La maana yaan xapiak ne waan xuvul pami la maana nobina pe la lifu lotu e mi pife pisau. Taasaxa yaan aanabeꞌ a yaan simi, a yaan si Setan.” ");
INSERT INTO leu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ri pis na Yesus e ri lisan falaxe xe la lifu sina priis lava. Na Pita xo usi saa taasaxa waan lasuun famodak. ");
INSERT INTO leu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","A fata taxa raam la xunamalei e na Pita maa nai xuvul pari aava ri taxa nai maari. ");
INSERT INTO leu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Layaan a saxa tefin sisiak a xalume taxa nai maari nane kaalum fatak xe sina e kuus, “A mataa aanabeꞌ sait fuuna waan xuvul pana.” ");
INSERT INTO leu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Taasaxa na Pita a faaxolus, “Tefin, ne vungut sena.” ");
INSERT INTO leu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","E mui fadak a xasafuna a xalume e fine, “Nano sait, no saxa siri, bo?” E na Pita a suie, “Au, nenia ve, ne piau.” ");
INSERT INTO leu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A awa saxa a falet e xasafuna a kuusan faagutane, “A mataa aanabeꞌ fuuna waan xuvul pana senaso nane ti Galili.” ");
INSERT INTO leu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","E na Pita a suie, “Au, ne vungut paaliu sena so ta mo no taxa ferawai pana.” La fatalatulaana faaxolusan sina a pura rawei. ");
INSERT INTO leu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","A Memai a gilim e kaalum fatak xe si Pita. E mui na Pita a lamon faꞌuli a ferawaian sina Memai sena: “A pura i taa pife rawei lunai e no taa faaxolusanau faatalatul.” ");
INSERT INTO leu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","E na Pita a savat xe lamalei e taangiis faagut. ");
INSERT INTO leu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","A rabuna ina fevis aava ri faxatang na Yesus, ri suaxane e ri sipe. ");
INSERT INTO leu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ri pis votan a matana pana marapi e ri kuus, “Mataa ina kuus fatuxai, xuus nemaam; naseꞌ sip nano?” ");
INSERT INTO leu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","E ri suaxane pana xasano mo fulaa. ");
INSERT INTO leu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","La paanen paaliu a mu matalava sina mu Juda e mu paamua priis e mu rabuna ina fepitaa pana vuputkai ri filimaan faxuvul e ri xel na Yesus xe siri. ");
INSERT INTO leu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","E ri kuus, “Tamo nano, no Krais, no Mataa Failai sina Piran, xuus fatexaas nemaam.” E na Yesus a sui nari, “Tamo ne xuus nami, mi taa pife namkai sega ");
INSERT INTO leu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","e tamo ne fin nami, mi taa pife suiau. ");
INSERT INTO leu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Taasaxa ti la yaan aanabeꞌ a Natuna Mataa i taa nai la pamuaan sina Piran pana Gutan Xapiak.” ");
INSERT INTO leu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","E nari xapiak ri fine, “Nano, no Natuna Piran?” E nane sui nari, “Mi kuus fatak layaan mi ferawai malaan.” ");
INSERT INTO leu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","E mui nari, ri kuus, “Xenaso maam taa seng ta rabuna xena kuus fulaa? Maam fatak, maam fo langai a ferawaian sina.” ");
INSERT INTO leu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","E mui a faxuvulan ina rabuna aave ri tamasiak e ri lisan na Yesus xe si Pailat. ");
INSERT INTO leu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ri gel tifie e ri kuus, “Maam texaas o a mataa aanabeꞌ i taxa yuuf a mu rabuna simaam. Nane xuus nari o ri muta mamareiai xe si Sisaa e nane kuus o nane ve a Mataa Failai e a piran.” ");
INSERT INTO leu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","E voxo na Pailat a fin na Yesus, “Nano, no piran sina mu Juda, bo?” E na Yesus a suie, “Aang, a malaan sena ferawaian siim.” ");
INSERT INTO leu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","E mui na Pailat a xuus a mu paamua priis e malila, “Ne pife tingin ta saxa mo xena pisaana mataa aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Taasaxa, ri kuus fulaa, “Nane taxa vil faraak a rabuna lana maana nobina pe Judia pana fepitaian sina. Nane tangpat pe Galili e naboxo a savat iau.” ");
INSERT INTO leu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Layaan na Pailat a langai a mo aanabeꞌ nane fiai tamo a mataa aave ti Galili. ");
INSERT INTO leu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","E layaan nane langai o na Yesus a filimaan ti la fatataganan si Herot, nane feng na Yesus xe si Herot aava taxa waan pe Jerusalem la yaan aapave. ");
INSERT INTO leu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Layaan na Herot a xalum na Yesus nane faamamaas paaliu senaso la maana yaan xaves nane vubuk xalume. Na Herot fo langai a maana mo se Yesus e nane buk xalume i taa vil a mo faꞌipul. ");
INSERT INTO leu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nane fin na Yesus pana fiaian xaves taasaxa na Yesus a pife suie. ");
INSERT INTO leu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","A mu paamua priis e mu rabuna ina fepitaa pana vuputkai ri taxa tigina pave e ri gel tifi faagutane. ");
INSERT INTO leu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","E mui na Herot e mu rabuna ina fevis, ri suaxan na Yesus. Ri fafalaxe pana marapi ina piran e ri feng faꞌulie xe si Pailat. ");
INSERT INTO leu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lana yaan aapave xo, na Herot nare Pailat re fesing faꞌulaa senaso paamuina mo aanabeꞌ re fuuna femaraleiai. ");
INSERT INTO leu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Na Pailat a xel faxuvul a mu paamua priis, mu matalava e mu rabuna ");
INSERT INTO leu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","e a xuus nari, “Mi lisanmaan a mataa aanabeꞌ e mi kuus o nane taxa yuuf a mu rabuna. Nenia, ne fine pana maana fiaian xaves la matami e ne pife tingin ta mo xena pisaana. ");
INSERT INTO leu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","E na Herot vaxa malaan, senaso nane feng faꞌuli a mataa aanabeꞌ xe sitaara. A matavas o na Yesus a pife vil ta mo xena punuxaana. ");
INSERT INTO leu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","E voxo ne taa sipe e mui ne taa mulus tapine.” ");
INSERT INTO leu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Na Pailat a toxan a toxolan xena mulus tapinaana mataa la fenamo ina Paaliuan. ");
INSERT INTO leu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pana ling saxa a malila ri xukulai, “Siak tapin a mataa aanabeꞌ e punuxe e mulus tapin na Baraabas xe simaam!” ");
INSERT INTO leu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Na Baraabas a vipis sena fevisan e ngaapunuk.) ");
INSERT INTO leu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Na Pailat a vubuk rao i taa mulus tapin na Yesus e nane ferawai fulaa. ");
INSERT INTO leu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Taasaxa ri taxa xukulai lunai, “Niil fataxutane, niil fataxutane.” ");
INSERT INTO leu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A fatalatulaana yaan nane ferawai xe siri, “Xenaso? Nane fo vil a so ta vilaana saat? Ne pife tingin ta mo xena punuxaana. E voxo ne taa sipe mon e ne taa mulus tapine.” ");
INSERT INTO leu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Taasaxa, pana xukulaian molava ri kuus faagut o i taa niil fataxutanan. E a xukulaian siri a molava temasaat sena ferawaian si Pailat. ");
INSERT INTO leu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","E voxo na Pailat a lamon o i taa tavai nari pana vubuxanan siri. ");
INSERT INTO leu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nane mulus tapin a saxa aava waan la vipis sena fevisan e ngaapunuk, a saxa aava ri vubuxane e nane tavai nari pa Yesus xena faxaꞌusi a lamonan siri. ");
INSERT INTO leu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ri taxa paamuian et na Yesus e ri fe saxam na Simon ti Sairiin aava filimaan ti la bina ina uma e ri timin a bolo si Yesus la mina xena yaasaana. E nane usi na Yesus pana. ");
INSERT INTO leu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","A malila ri usie e la palou iri a toxan a saxano lutefin aava ri muluk na Yesus. ");
INSERT INTO leu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Na Yesus a gilim xe siri e a kuus, “Lutefin ti Jerusalem, muta muluxau taasaxa muluk nami xa e mu rafulak simi. ");
INSERT INTO leu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Senaso a yaan saat taa savat layaan a rabuna ri taa kuus, ‘A lutefin aava ri pi luluk o pi fasus ta lak, ri taa faamamaas.’ ");
INSERT INTO leu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","E mui lana yaan saat naang a rabuna ri taa kuus xe sina mu put, ‘Poxoi nemaam’ e xe sina put modak ‘xafut nemaam.’ ");
INSERT INTO leu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Senaso tamo rabuna ri taa vil a mo mosaat xe siak a so ta mo ri taa vile xe simi?” ");
INSERT INTO leu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ri lisanmaan vaxa a rovaat ina fenau xena punuxaan nare xuvul pa Yesus. ");
INSERT INTO leu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Layaan ri savat la bina aava ri xalie pana veng, ri niil fataxutan na Yesus xuluna bolo e a ro mataa saat la nu itina, saxa la pamuaan e saxa la paxaiya. ");
INSERT INTO leu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","E na Yesus a kuus, “Tamaang, lamon tapin a vilaana saat siri senaso ri vungut sena so ta mo ri taxa vile.” Saxano rabuna ina fevisan ri tapin a faat xena siak a marapi si Yesus. ");
INSERT INTO leu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Maana rabuna ri taxa ti falime. E a mu paamua ri suaxane e ri kuus, “Nane fakaxup a xasanofuna, tamo nane a Mataa Failai, a saxa aava Piran fo bure, naak nane taa fakaxup fatak nane xa.” ");
INSERT INTO leu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","A mu rabuna ina fevis, ri tavaie pana wain mopaak xena num. E ri filimaan faasilak xena suaxane e ri kuus, ");
INSERT INTO leu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Tamo nano, no piran sina mu Juda fakaxup fatak nano xa.” ");
INSERT INTO leu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A toxan a lagasai laaꞌui xuluna bolo aava kuus, “Nabeꞌ ve a piran sina mu Juda.” ");
INSERT INTO leu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","A saxa mataa saat a kuus pengan a isina Piran e a kuus, “Nano, no Mataa Failai, bo? Fakaxup fatak nano xa e nemaame sait.” ");
INSERT INTO leu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Taasaxa xasa mataa saat a barase, “Nano, no pife mataut sena Piran, bo? A fakasanaman siim a fexaxaas sena fakasanaman si Yesus. ");
INSERT INTO leu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ri vil fakasanam netaare senaso taare vil a maana mo mosaat. Taasaxa mataa aanabeꞌ a pife vil ta mo mosaat.” ");
INSERT INTO leu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","E mui nane kuus, “Yesus, layaan no siak a vepen ina piran siim, lamon faꞌuliau.” ");
INSERT INTO leu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","E na Yesus a suie, “Ne xuus tuunei nano, tanin mon no taa waan xuvul paga la bina roxo, Paradais.” ");
INSERT INTO leu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","A faasilak la belo la paanaas e a malang ina ngaas a malit e a bina fe suk fefexaxaas leaaf. ");
INSERT INTO leu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","A marapi aava fuuna tofai lana tang lifu lotu a tiririk la palou ina ti laaꞌui xe lapia. ");
INSERT INTO leu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","E na Yesus a xukulai faagut, “Tamaang, ne tavai nano pana vovau iga.” Nane ferawai malaan e a maat. ");
INSERT INTO leu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","A saxa paamua sina rabuna ina fevisan a xalum a maana mo ri fo savat e a kuus fararoxo xe sina Piran e a kuus, “A tuuna paaliu, a mataa aanabeꞌ a mataa xaradak.” ");
INSERT INTO leu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Layaan a rabuna aava ri faxuvul xena falime, ri xalum a so ta mo fo savat, ri ulaa xe la lifu siri pana matafanan molava. ");
INSERT INTO leu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Taasaxa lutefin aava ri usi na Yesus ti Galili, xuvul pana xasano fesing fulaa sina, ri tigina lasuun famodak e ri falim a maana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","A saxa mataa, isina na Yosep, a filimaan ti la saxa bina lana Judia ri xalie pa Erimatia. Nane a mataa pana vilaana roxo aava rabuna ri suai sena. E nane taxa waan bang a savatan ina fatataganan sina Piran. Nane waan la palou ina mu paamua sina mu Juda taasaxa nane pife turoxo pana lamonan e vilaana siri. ");
INSERT INTO leu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nane falet xe si Pailat e fe fine pana mamaat i Yesus. ");
INSERT INTO leu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","E mui nane siak faduie e pise pana marapi faꞌui e famatie lana liing aava ri taxe lana faat. A nobina aanabeꞌ a faꞌui paaliu e ri pife timin a saxa mamaat lana lunai. ");
INSERT INTO leu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A yaan aanabeꞌ a yaan ina faigotan a maana mo xena Yaan ina Fangaafusan aava i taa tangpat faasilak. ");
INSERT INTO leu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","A lutefin aava ri fo usi na Yesus ti Galili, ri usi na Yosep e ri xalum a liing ina mamaat e malaafaa nane famati a mamaat i Yesus lana. ");
INSERT INTO leu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","E mui ri falet xe la lifu siri xena faigotan a mo lalas ina xaxaafai. Ri usi a vuputkai siri e lana Yaan ina Fangaafusan aave ri nai palau mon. ");
INSERT INTO leu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Taasaxa la yaan mata ina ‘wiik’, la paanen lolof, a lutefin ri falet xe la liing ina mamaat pana maana mo lalas aava ri fo faigotane. ");
INSERT INTO leu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ri xalum a faat molava a pife ti votan fulan a liing ina mamaat. ");
INSERT INTO leu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ri laak lana taasaxa ri pife tingin a mamaat i Memai Yesus. ");
INSERT INTO leu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Layaan ri taxa lalamon pana mo aanabeꞌ, fataapus paaliu, a rovaat tomexaan lana marapi aava rarapak malaan sena yaamit re maa tigina la tana lutefin aave. ");
INSERT INTO leu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nari, ri mataut faagut e ri bukaak xe lapia, taasaxa a rovaat aave re xuus nari, “Xenaso mi taxa seng a saxa aava fo to faꞌulaa nabeꞌ, la palou ina mu mamaat? ");
INSERT INTO leu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nane pife waan iau, i taxa to! Lamon faꞌuli a ferawaian sina. Layaan i taxa waan xuvul pami pe Galili nane xuus nami o ");
INSERT INTO leu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","a Natuna Mataa, ri taa tavai a mu rabuna saat pana e ri taa niil fataxutane e lamina, la fatalatulaana yaan i taa to faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","E mui ri lamon faꞌuli a ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Layaan ri ulaa ti la liing ina mamaat ri xuus fatexaas a mu yaamut sangafilu saxa pana saxa xuvul pana xasanofuna. ");
INSERT INTO leu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Na Maria Mekdala, na Joaana e na Maria na nina Jems, rutul xuvul pana xasano lutefin, ri xuus fatexaas a mu yaamut pana maana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nari, ri lamon o a ferawaian sina lutefin a ferawaian palau mon. ");
INSERT INTO leu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Taasaxa na Pita xo a tamasiak e fala xe la liing ina mamaat. Nane xewai e xalum a marapi ina mamaat mon taxa waan e nane ulaa e lalamon pana so ta mo fo savat. ");
INSERT INTO leu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lana yaan aanabeꞌ a rovaat aava re fuuna usi na Yesus, re taxa sangas sivi xe la bina Imeas, pife lasuun se Jerusalem, faasilak 12 kilomita mon, ");
INSERT INTO leu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","e re taxa ferawai pana maana mo aava fo savat. ");
INSERT INTO leu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","La fena sangasan sire na Yesus fatak xa maa savat e sangas xuvul pare. ");
INSERT INTO leu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","A saxa mo tivotan a masaman sire e re ngalngolane. ");
INSERT INTO leu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nane fin nare, “A so ta mo me taxa paa fexuusane?” Re tigina kasam, a nonau ire a nanosaat. ");
INSERT INTO leu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","A saxa sire, isina na Kiapas, a fine, “Nano, no taxa waan pe Jerusalem e no pife texaas sena maana mo aava fo savat iau lana mu yaan aanabeꞌ, bo?” ");
INSERT INTO leu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","E na Yesus a fiai, “A so ta mo?” Nare, re suie, “A maana mo se Yesus ti Nasaret. Nane ve a mataa ina kuus fatuxai aava toxan a gutan lana ferawaian e vilaana sina la matana Piran e mu rabuna xapiak. ");
INSERT INTO leu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","E mu paamua priis e mu matalava sitaara ri yot lisane xe sina paamua ti Rom xena punuxaana e nari, ri niil fataxutane. ");
INSERT INTO leu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Taasaxa maam fo lamon o nane a saxa aava i taa maraan faꞌuli na Israel. E naboxo a yaan talatul fo falet xo. ");
INSERT INTO leu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","E vaxa, saxano lutefin simaam ri faꞌipul nemaam. La paanen lolof ri falet xe la liing ina mamaat, ");
INSERT INTO leu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","taasaxa ri pife xalum a vipin ina. Ri maa xuus nemaam o ri fo xalum a ro angelo aava kuus o nane fo to faꞌulaa. ");
INSERT INTO leu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Saxanofuna imaam, ri falet xe la liing ina mamaat e ri tingin a maana mo malaan sena lutefin ri fo kuusane taasaxa ri pife xalum nane.” ");
INSERT INTO leu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","E na Yesus a ferawai xe sire, “A lamonan sime a tavanat, me pife matavas sena maana mo a mu rabuna ina kuus fatuxai ti kavai ri fo kuusane. Me pife masam lunaiane, bo? ");
INSERT INTO leu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","A mu rabuna ina kuus fatuxai ri fo kuus o a Mataa Failai i taa maasak pana maana mo aanabeꞌ e mui i taa laak lana malang molava sina, tuuna?” ");
INSERT INTO leu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","E nane tangpat pana xakalayan si Moses e maana rabuna ina kuus fatuxai xapiak e a xuus famatavas nare pana maana mu palagasai aava waan lana Ferawaian sina Piran sena. ");
INSERT INTO leu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Rutul fe savat faasilak la bina sire e na Yesus a sangas ludalet e bilai malaan sena i taxa falet xe lasuun. ");
INSERT INTO leu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Taasaxa re bukane o i taa waan xuvul pare e re kuus, “Faasilak a ngaas i rul e a bina taxa rao i suk, no waan xuvul pamaame xalak.” E voxo nane fe laak la lifu sire xena waan xuvul pare. ");
INSERT INTO leu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Layaan nane taxa nai xo xuvul pare la ivin, nane siak a bret e fenung pana e viaxe e a tavai nare pana. ");
INSERT INTO leu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","E mui a matare talakas e re kaalum pana masaman e re taraxalie. Taasaxa nane malit palau la matare. ");
INSERT INTO leu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","E re fefiaian nare, “A tuuna, a malaan sena fata taxa raam la xunus itaare layaan nane taxa kuusan famatavas a ferawaian sina Piran xe sitaare la fena sangasmaanan sitaare.” ");
INSERT INTO leu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Re tamasiak fataapus e re ulaa xe Jerusalem. Pave re tingin a mu yaamut sangafilu saxa pana saxa e saxanofuna ri taxa faxuvul ");
INSERT INTO leu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","e nari, ri taxa kuus, “A tuuna, a Memai fo to faꞌulaa. Nane fo savat si Saimon.” ");
INSERT INTO leu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","E mui a rovaat aave re xuus nari pana so ta mo fo savat la fena sangasan sire e malaafaa re taraxali na Yesus layaan nane viak a bret. ");
INSERT INTO leu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Layaan ri taxa ferawai pana maana mo aanabeꞌ na Yesus fatak xa maa tigina la palou iri e a kuus, “A luaian xe xulumi.” ");
INSERT INTO leu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nari, ri ipul e ri mataut senaso ri lamon o a rongan. ");
INSERT INTO leu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","E nane xuus nari, “Xenaso mi ipul e xenaso sait mi taxa lamon xolai? ");
INSERT INTO leu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xalum a maak e a kaak. Nenia move. Tao nenia e mi taa texaas, a rongan piau ta meska e tun malaan sega.” ");
INSERT INTO leu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nane kuus malaan e mui nane faxalit nari pana mana e kana. ");
INSERT INTO leu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ri pife fexaxaas sena lamon fatak senaso ri faamamaas fasaat paaliu e nane fiai, “Mi toxan ta fanganan ve taxa waan?” ");
INSERT INTO leu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ri tavaie pana nedin aava ri fo suluxe ");
INSERT INTO leu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","e nane ngane la matari. ");
INSERT INTO leu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","E mui nane xuus nari, “Ne fo xuus fatexaas nami pana maana mo aanabeꞌ layaan ne taxa waan xuvul pami lunai; a maana mo aava ri xaleie lana vuputkai si Moses sega e lana xakalayan sina mu rabuna ina kuus fatuxai e lana mu yanganan sega, ri fo savat la matavas.” ");
INSERT INTO leu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","E mui nane ferawai fatalakas a lamonan siri talo ri taa masam faroxo pana Ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nane xuus nari, “Ri fo kala malaan: A Mataa Failai i taa maasak e taa to faꞌulaa ti la maatan la fatalatulaana yaan, ");
INSERT INTO leu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","e lana isina, a rabuna ri taa kuusan a lagasai o a Piran i taa lamon tapin a vilaana saat tamo ri taa puk tapin nari xa xasena vilaana saat siri e ri usi na Yesus. A lagasai aanabeꞌ ri taa fapiti a mu rabuna xapiak pana e ri taa tangpat nabeꞌ Jerusalem. ");
INSERT INTO leu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nami, mi fo xalum a maana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","E ne taa feng a so ta mo na Tamaang fo kuus fanai pana xe simi. Taasaxa mi taa waan la bina fefexaxaas a gutan ti laaꞌui i taa sivimaan xulumi.” ");
INSERT INTO leu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Layaan nane paamuian nari xe pe Betani, nane talangai xe laaꞌui e kuus fararoxo xuluri. ");
INSERT INTO leu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Layaan i taxa ferawai malaan nane taꞌulan nari e a xel falaxan xe laaꞌui la xunavata. ");
INSERT INTO leu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","E ri nanguse e mui ri fe ulaa xe Jerusalem pana faamamaasan molava paaliu marasaxa. ");
INSERT INTO leu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","E ri waan vulai lana lifu lotu e ri fuuna kuus faasiroxo vulai xe sina Piran. ");
INSERT INTO leu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Layaan a maana mo xapiak ri tangpat, na Ferawaian fo waan. Na Ferawaian a taagul xuvul pana Piran e narie, na Ferawaian e a Piran, re saxa. ");
INSERT INTO leu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nane taxa waan xuvul pana Piran ti la tangpat. ");
INSERT INTO leu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","4","Nane fasavat a maana mo xapiak e piau ta saxa mo aava fo savat, a savatmaan ti lana xasa salan, piau! Nane a fufuna toyan ina maana mo xapiak aava fo waan, nane sang mon. E a toyan sina ve a malang xana mu rabuna. ");
INSERT INTO leu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","E a malang aave a lang lana bina suk taasaxa suk pife fexaxaas i taa xasliue. ");
INSERT INTO leu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","A toxan a saxa mataa aava Piran a fenge, a isina na Jon. ");
INSERT INTO leu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nane filimaan malaan sena xasa mataa ina kuus xakaavang. Nane maa kuusan fasavat a lagasai sena malang talo pana kuus xakaavangan sina, a maana rabuna ri taa namkai sena malang aave. ");
INSERT INTO leu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nane xa pife malang aave taasaxa nane maa savat xena kuus xakaavang sena malang. ");
INSERT INTO leu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A malang tuuna naang aava famalang a maana rabuna xapiak, i taxa filimaan xena sangas xolai la xavala. ");
INSERT INTO leu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pevoxo, nane savat la xavala taasaxa naapalaan nane fo vesan a xavala e maana mo xapiak, a maana rabuna ri pife taraxalie. ");
INSERT INTO leu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nane fo savat xe sina maana rabuna sina, taasaxa ri pife fesuaiane. ");
INSERT INTO leu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Taasaxa saxano rabuna xo, ri fesuaiane e nari aava ri namkai sena isina, nane turoxoian nari, ri taa savat rafulak sina Piran, ");
INSERT INTO leu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","a rafulak malaan seꞌ ri fo luxan taasaxa pife sena matatuuna o a vubuxanan sina mataa o sena tamaian, piau! A fufuna savatan siri ve a vubuxanan sina Piran. ");
INSERT INTO leu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na Ferawaian xo, fesavat mataa e taagul la palou itaara e taara fo xalum a malangan sina, a malangan sina saxa fatak sina Piran, na Tamana. Nane a bas pana xakaavangan xatam e ferawaian tuuna. ");
INSERT INTO leu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","A kuusan si Jon sena a malaan. Nane xukulai faagut, “Nabeꞌ ve, a mataa ne fo ferawai sena layaan ne kuus: ‘Nane aava savat lamiak, i taa xasliuau senaso nane fo waan paamuin nenia.” ");
INSERT INTO leu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ti lana xakaavangan xatam sina, nane fo tavai netaara pana maana mo roxo; saxa mo roxo xuluna saxa mo roxo fulaa maan. ");
INSERT INTO leu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Na Moses a lisanmaan a vuputkai sina Piran taasaxa na Yesus Krais a lisan a xakaavangan xatam e ferawaian tuuna. ");
INSERT INTO leu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Piau ta mataa fo xalum a Piran taasaxa, a Saxa aava fuuna waan faasilak se Tamataara, nane ve a Piran e Lak Fatak Mon e fo waan la xasing ina. Nane fo faxalit a Piran xe sitaara. ");
INSERT INTO leu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Saxa yaan xo, a mu matalava sina mu Juda pe Jerusalem ri feng a saxanu priis e saxanu rabuna lana pabung si Livai xe si Jon rao ri taa fine, “Nano naseꞌ?” Ri vil malaane e na Jon a xuus nari malaan, “Nenia, ne pife Krais, a Mataa Failai.” Nane kuus famatavas e pife bit nari. ");
INSERT INTO leu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","E ri fin fulane, “A isaam naseꞌ? Nano, no Ilaija?” E nane xuus nari, “Pife nenia ve.” E ri fin fulane, “Nano, no matalava ina kuus fatuxai, bo?” E nane sui nari, “Piau.” ");
INSERT INTO leu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","E mui ri fine, “Nano naseꞌ? Sui nemaam senaso maam taa lisan faꞌuli a ferawaian siim xe siri aava ri feng nemaam. Nano fatak no kuus o nano naseꞌ?” ");
INSERT INTO leu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","E na Jon a sui nari pana ferawaian si Aisaia, saxa mataa ina kuus fatuxai sina Piran. A kuus malaan: “Nenia a saxa ling aava taxa kel lana xobingil, ‘Faxaradak a salan xana Memai.’” ");
INSERT INTO leu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","E saxanu Ferasi aava fengan xuvul pari, ri fine, “Tamo no pife Krais e no pife Ilaija e no pife mataa ina kuus fatuxai xenaso no taxa lo fasuf a maana rabuna?” ");
INSERT INTO leu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","E na Jon a sui nari, “Nenia, ne fasuf a mu rabuna pana raarum taasaxa la palou imi a saxa taxa tigina e mi pife texaas sena. ");
INSERT INTO leu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nane ve a Saxa aava fo savat lamiak taasaxa a toxan a isin lava sega. Nane ve, ne pife roxo fexaxaas sena mulus a ‘slipa’ sina.” ");
INSERT INTO leu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","A maana vilaana aanabeꞌ a savat faasilak la bina Betani aava waan la xasing ina Raarum Jordan, layaan na Jon taxa fasuf a mu rabuna pave. ");
INSERT INTO leu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","La yaan mui na Jon a xalum fulan na Yesus i taxa sangasmaan e nane kuus, “Kaalum, a Natuna Sipsip sina Piran aava i taa siak tapin a lalosaat sina maana mu rabuna. ");
INSERT INTO leu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nane ve a saxa ne ferawai sena layaan ne kuus, ‘A mataa aava savat lamiak i taa xasliuau senaso nane waan paamuin nenia.’ ");
INSERT INTO leu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Lumua ne pife texaas sena taasaxa, a fufuna faisok siak pana fasufaana mu rabuna a malaan: xena vil fasavat nane la matana mu rabuna Israel.” ");
INSERT INTO leu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","E mui na Jon a kuus, “Ne xalum a Vovau Xaradak, a xakaaluman ina malaan sena vaalus, a sivimaan ti la xunavata e maa waan xuluna. ");
INSERT INTO leu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ne pife fexaxaas sena taraxalie taasaxa, a Saxa aava fengau xena fasuf a mu rabuna pana raarum a xuusau: ‘A mataa aava no xalum a Vovau Xaradak a sivimaan e maa nai xuluna, nane ve a Saxa aava i taa fasuf a mu rabuna pana Vovau Xaradak.’ ");
INSERT INTO leu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ne fo xalum a fakalimaanan aanabeꞌ e ne kuus faagut o nane ve a Natuna Piran.” ");
INSERT INTO leu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Xe mafu saa xo, na Jon taxa tigina fulaa la xasa nobina pave xuvul pana ro fefeng sina. ");
INSERT INTO leu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","E layaan nane xalum na Yesus a sangas liu ete nane kuus, “Xalume, a Natuna Sipsip sina Piran!” ");
INSERT INTO leu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Layaan a ro fefeng sina re langai a ferawaian sina, re usi moxo na Yesus. ");
INSERT INTO leu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na Yesus a gilim e xalum nare e fin nare, “Rao me sou?” E re kuus, “Raabai, (A malasuf ina vapaling aanabeꞌ ve ‘Tisa’ o Mataa ina Fepitaa) nano, no taxa mamatef faa?” ");
INSERT INTO leu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Nane sui nare, “Filimaan e me taa xalume.” E rutul paan e rutul fe savat la lifu aava nane mamatef lana e re waan xuvul pana la vung aave senaso a yaan ve faasilak 4 oklok la leaaf. ");
INSERT INTO leu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","E saxa ire aava fo langai a kuusan si Jon e mui a usi na Yesus, isina na Endru, na ti Saimon Pita. ");
INSERT INTO leu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Nane fe tingin na tina, na Saimon, e xuus malaane, “Maame fo tingin a Mataa Failai, na Messia.” ");
INSERT INTO leu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","E nane lisan ete xe si Yesus. Na Yesus a xalume e kuus, “Nano, no Saimon, a lak si Jon taasaxa ri taa xali nano pa Sifas.” (Layaan no taa puk a isin aanabeꞌ i taa fe savat ‘Pita’ e voxo taara xalie pa Saimon Pita) ");
INSERT INTO leu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Xe mafu saa xo, na Yesus a buk rao i taa paan xe Galili. Nane tingin na Filip e xuuse, “Usiau!” ");
INSERT INTO leu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","A fufubina si Filip ve pe Betsaida, malaan se Endru narie Saimon Pita. ");
INSERT INTO leu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na Filip fe tingin na Nataaniel e a xuuse, “Nemaam fo tingine xo, nane aava na Moses fo kala sena lana mu vuputkai e lana xakalayan sina mu rabuna ina kuus fatuxai, na Yesus a lak si Yosep ti Nasaret.” ");
INSERT INTO leu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","E na Nataaniel a fine, “Ai, a fexaxaas ta mo roxo i taa savat ti Nasaret?” E na Filip a xuuse, “Filimaan xuvul paga e no maa xalume.” ");
INSERT INTO leu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Na Yesus a xalum na Nataaniel i taxa filimaan e nane kuus sena, “Kaalum, nabeꞌ ve saxa mataa Israel tuuna e nane pi vibit.” ");
INSERT INTO leu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na Nataaniel a fine, “Malaafaa no texaas sega?” E na Yesus a suie, “Paamuin na Filip fe xel nano ne fo xalum nano, no taxa nai lapaana wai xakaap.” ");
INSERT INTO leu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Na Nataaniel a suie, “Mataa ina Fepitaa, nano, no Natuna Piran; nano, no Piran King sina mu Israel.” ");
INSERT INTO leu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Na Yesus a xuuse, “Nano, no namkai sega senaso ne xuus nano o ne fo xalum nano lapaana wai xakaap? Ai, no taa xalum a maana mo lava sena mo aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E mui a xuus fulane, “Tuuna paaliu, no taa xalum a xunavata i taa talakas e mu angelo sina Piran ri taxa laak xe pave e sivimaan xuluna Natuna Mataa.” ");
INSERT INTO leu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","A yaan talatul lamina, a fenamo ina tamaian a savat la bina Kena pe Galili. E nari, ri xel na nina Yesus o i taa fe waan pave. ");
INSERT INTO leu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ri xel na Yesus xuvul pana maana fefeng sina, rao ri taa waan pave sait la fenamo. E voxo nari xapiak ri fe waan. ");
INSERT INTO leu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","E layaan a wain a taxapus na nina Yesus a xuuse, “Nari, ri fo piau ta wain!” ");
INSERT INTO leu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","E na Yesus a suie, “Aang, taasaxa xenaso no taxa xuusau pana? A yaan siak pife savat lunai.” ");
INSERT INTO leu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Taasaxa na ninana a xuus a mu sisiak pave, “A so ta mo i taa fasei nami pana, mi taa vile.” ");
INSERT INTO leu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","La faasilak, a toxan a mu vaan pisaxa ina raarum aava ri vesane pana faat, ri taxa tigina. Ri toxan a raarum xena xamak a mari mu Juda malaan sena vilaana ina lotu siri a kuus pana. E mu vaan ri molava e nari saxa saxa ri toxan a ‘lita’ 100 o 150. ");
INSERT INTO leu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","E na Yesus xo a xuus nari mu sisiak, “Fabas a mu vaan pave pana raarum.” E voxo ri fabas nari e ri fe bas soliu. ");
INSERT INTO leu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","E nane fasei nari, “Lavaxa, pituf saa e lisane xe sina mataa aava paamuian a mu tatavai.” E ri pituf lisane xe sina. ");
INSERT INTO leu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Layaan a paamua ina fenamo fo num a wain aava fo mo raarum nane xelmaan a mataa faꞌui aava tamai. A paamua ve a vungut sena fufuna wain aave, taasaxa mu sisiak ri texaas. ");
INSERT INTO leu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","E a paamua a xuus a mataa faꞌui, “A mu matalava, ri fuuna tavai a mu rabuna pana wain roxo paamua e layaan ri fo num temasaat ri taa tavai nari pana wain a pife roxo temasaat; taasaxa nano, no fo faxarang a wain roxo paaliu e mo nabeꞌ mon no fasavate.” ");
INSERT INTO leu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nabeꞌ ve a mo faꞌipul mata aava na Yesus a vesane e nane vile la bina Kena pe Galili. Nane faxalit famatavas a roxoyan sina e voxo a mu fefeng sina ri namkai sena. ");
INSERT INTO leu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Lumui nane sivi xe paa Kapanam, nane e na ninana xuvul pana mu tina e mu fefeng sina, nari xapiak ri fe taagul pave pana saxano yaan. ");
INSERT INTO leu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Layaan a Fenamo ina Paaliuan sina mu Juda a savat faasilak, na Yesus a laak xe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lana nobina aava fakaliuan a Tang lifu lotu pave nane xalum a mu rabuna ri taxa faasot pana bulmakau e sipsip e vaalus. E saxanofuna ri taxa nai la mu ivin xena xul faat sina mu rabuna. ");
INSERT INTO leu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","E voxo nane vesan a mo ina fesipan pana mu yeis e nane fexup nari xapiak ti lana nobina ina lifu lotu. A xup a mu bulmakau e sipsip e nane tapin xolan a faat sina mu rabuna ina xul faat e puk tapin a mu ivin siri. ");
INSERT INTO leu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","E ferawai faagut xe siri aava ri faasot pana vaalus, “Siak tapin et a mo aanabeꞌ! Malaafaa mi fexaxaas sena vil a Lifu si Tamaang malaan sena lifu ina faasot?” ");
INSERT INTO leu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","A mu fefeng sina ri lamon faꞌuli a xakalayan aanabeꞌ: “A sei soxotaana Lifu siim i taa vawau.” ");
INSERT INTO leu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","A mu matalava Juda ri fine, “A so ta fakalimaanan no taa faxalit nemaam pana xena turoxo pana vilaana siim?” ");
INSERT INTO leu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","E na Yesus a sui nari, “Kawaasan xapin a lifu lotu aanabeꞌ e lana yaan talatul mon ne taa siak fati fulane.” ");
INSERT INTO leu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","E mui a mu Juda ri kuus, “Ai, ri fo faisok pana mariaas sangafilu talafaat pana pisaxa xena vesan a lifu lotu aanabeꞌ e nano, no taa vil fatigineie lana yaan talatul, bo?” ");
INSERT INTO leu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Taasaxa nane taxa ferawai sena vipin sina, a lifu lotu sina Piran. ");
INSERT INTO leu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Layaan nane fo to faꞌulaa ti lana mamaat, a mu fefeng sina ri lamon faꞌuli a kuusan sina e voxo ri namkai sena mu xakalayan e ferawaian aava na Yesus fo kuusane. ");
INSERT INTO leu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Layaan na Yesus a taagul pe Jerusalem la Fenamo ina Paaliuan a mu rabuna xaves ri namkai sena layaan ri xalum a maana fakalimaanan aava nane taxa vile. ");
INSERT INTO leu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Taasaxa nane pife turoxoian a mu lamonan siri sena, senaso nane masam faroxo sena vilaana sina mu rabuna ");
INSERT INTO leu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","e nane pife langai ta ferawaian sina mataa sena rabuna senaso nane fatak a texaas sena so ta lamonan taxa waan sina mu rabuna. ");
INSERT INTO leu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Saxa Ferasi aava saxa piran sina mu matalava Juda, a isina na Nikodimaas ");
INSERT INTO leu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","a savat si Yesus la vung e kuus malaan, “Mataa ina Fepitaa, maam texaas o no fo filimaan xe nabeꞌ ti la bina sina Piran xena vil a faisok ina fepitaian. Maam lamon malaan senaso a mataa sang mon pife fexaxaas sena vil a maana mo faꞌipul malaan sema, tamo Piran pife waan xuvul pana.” ");
INSERT INTO leu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Na Yesus a suie, “Tuuna paaliu ne xuus nano, tamo ta mataa i taa pife luxan fulaa ti laaꞌui, i taa pife xalum a fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Na Nikodimaas a fine, “Malaafaa a mataa vaiak i taa luxan fulaa? Fexaxaas i taa laak fulaa la xu ninana e taa luxan fulaa?” ");
INSERT INTO leu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","E na Yesus a sui fulane, “Tuuna paaliu ne xuus nano, tamo ta mataa a pife luluk pana raarum e pana Vovau nane pife fexaxaas sena laak lana fatataganan sina Piran. ");
INSERT INTO leu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lamon pana ferawaian aanabeꞌ: layaan a tefin taa luk a lak i taa savat mataa tuuna, bo? Taasaxa, a Vovau i taa luluk pana mo ina Vovau. ");
INSERT INTO leu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Muta ipul sena ferawaian ne xuus nano pana. Nami xapiak mi taa luxan fulaa ti laaꞌui. ");
INSERT INTO leu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","A reref i taxa fiit xolai laso ta bina a vubuxane e nami, mi langaie taasaxa mi vungut o a reref fo savatmaan ti faa o a so ta bina i taa falet xe lana. E voxo a mu rabuna aava ri luxan sena Vovau, ri fexaxaas paaliu malaan sena reref.” ");
INSERT INTO leu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Na Nikodimaas a fiai malaan, “Maana mo aanabeꞌ, ri taa savat malaafaa?” ");
INSERT INTO leu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Na Yesus a xuuse, “Nano, no Mataa ina Fepitaa ti Israel e no pife masam sena maana mo aanabeꞌ? ");
INSERT INTO leu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tuuna paaliu ne xuus nano, maam ferawai sena maana mo maam texaas sena e kuus pana maana mo maam fo xalume taasaxa piau ta saxa simi fesiak tuunei a kuusan simaam. ");
INSERT INTO leu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tamo ne ferawai tuuna xuvul pami sena maana mo ti la xavala e mi pife namkai sena ferawaian siak malaafaa mi fexaxaas sena namkai layaan ne ferawai pana mo ti la xunavata? ");
INSERT INTO leu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","A Natuna Mataa, nane sang mon a sivimaan ti laaꞌui la xunavata e piau ta mataa fulaa fo waan pe laaꞌui. ");
INSERT INTO leu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Na Moses fo yaas fati a tiui ‘braas’ pe la bina vingil e mui a Natuna Mataa i taa yaas fatian malaan ");
INSERT INTO leu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","talo a mu rabuna xapiak aava ri namkai sena, ri taa toxan a toyan vulai, vulai. ");
INSERT INTO leu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Senaso, a Piran a vubuxan xasingit a mu rabuna xapiak la xavala e voxo nane turoxo pana maatan sina Lak Tomexaan Fatak sina talo naseꞌ ta mataa aava i taa namkai sena, i taa pife maat, taasaxa i taa toxan a toyan vulai, vulai. ");
INSERT INTO leu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","A Piran pife feng a Lak Tomexaan sina xena lisan a fakasanaman xe sina mu rabuna xapiak, piau. Nane tavaie pana faisok xena fakaxupaana mu rabuna. ");
INSERT INTO leu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Naseꞌ ta mataa aava namkai sena i taa pife tiisan; nane aava bai namkai sena, a mataa aave fo tiisan xo senaso nane pife namkai sena Lak Saxa Fatak sina Piran. ");
INSERT INTO leu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","E a tiisan taa savat malaan: a malang fo savat xuluna xavala, taasaxa mu rabuna xapiak ri vubuxan a suk e ri baian a malang senaso a mu vilaana siri, ri saat paaliu. ");
INSERT INTO leu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","A mu rabuna aava ri bilai fasaat, ri baian a malang e ri pi sasangas lana malang senaso ri mataut o mu vilaana saat siri taa savat la matavas. ");
INSERT INTO leu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Taasaxa nari aava ri fuuna taagul lana tuunayan, ri sasangas lana malang e voxo a malang taa faxaalit o a Piran va fufuna mu vilaana roxo siri.” ");
INSERT INTO leu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Lamina mu yaan aanabeꞌ na Yesus nari mu fefeng sina ri falet xe la xobingil pe Judia e pave nane irimai xuvul pari e fasuf a saxano rabuna. ");
INSERT INTO leu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","E na Jon vaxa, taxa fasuf a mu rabuna sait e nane taxa taagul pe Enon faasilak se Selam senaso a raarum molava taxa waan pave e mu rabuna xaves ri fuuna savat xena fasufan. ");
INSERT INTO leu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(A yaan aanabeꞌ ve paamuina vipisan si Jon.) ");
INSERT INTO leu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","E saxano fefeng si Jon xuvul pana saxa matalava sina mu Juda ri fetok sena vilaana ina fasufan lana vuputkai siri. ");
INSERT INTO leu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ri fe savat si Jon e ri xuuse, “Mataa ina Fepitaa, a mataa aava waan xuvul pama la xasa paxasing ina Raarum Jordan — nane aava no fo kuusane — nane vaxa, i taxa fasuf a mu rabuna e nari xapiak, ri taxa lo falet xe sina.” ");
INSERT INTO leu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Na Jon a sui nari, “A Piran pe la xunavata i taa lamon pana so ta mo i taa tavai a mataa pana e a mataa taa siak a maana mo aave. ");
INSERT INTO leu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nami fatak mi texaas o ne kuus malaan: ‘Nenia, ne pife Krais, a Mataa Failai, taasaxa nenia, ne fo fengan paamuine.’ ");
INSERT INTO leu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","A tefin va mo sina lavana. A fesing sina lavana aava fuuna fangasixe, a waan bang xena langaiaana e layaan a langai a ling ina, nane i taa faamamaas. A faamamaasan aave ve siak e naboxo ne fo bas paaliu pana. ");
INSERT INTO leu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","A mo roxo o a isina i tafe molava e isaak tafe modak. ");
INSERT INTO leu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“A Saxa aava savat ti laaꞌui i taa paamuian a maana mo xapiak e nane aava savat ti lapia nane a mo ti la xavala e nane ve taxa ferawai malaan sena saxa ti la xavala. Ne kuus fulaa o nane aava savat ti la xunavata i taa paamuian a maana mo xapiak. ");
INSERT INTO leu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nane taa kuusan a maana mo xapiak nane fo xalume e fo langaie taasaxa mu rabuna ri bai langai a kuusan sina. ");
INSERT INTO leu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Taasaxa mataa aava langai e namkai sena, nane taxa faxaalit o a ferawaian sina Piran a tuuna. ");
INSERT INTO leu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nane aava Piran fo fenge, nane taxa ferawai pana ferawaian sina Piran e a Piran fuuna feng a Vovau sina e a Vovau sina i taa pife taxapus. ");
INSERT INTO leu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Na Tamana pe la xunavata nane vubuxan xasingit a Natuna e voxo fo tavaie pana maana mo xapiak. ");
INSERT INTO leu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Naseꞌ ta mataa i taxa namkai se Natuna a toxan a toyan vulai, taasaxa naseꞌ ta mataa i taa baian a Natuna i taa pife siak a toyan senaso a maraleian sina Piran taa waan xuluna mataa aave.” ");
INSERT INTO leu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nari mu Ferasi ri langai o a mu rabuna aava ri siak a fasufan si Yesus e ri usie, ri rabuna xaves paaliu seri aava ri usi na Jon ");
INSERT INTO leu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","taasaxa pife na Yesus ve taxa fasuf nari, a mu fefeng sina ri taxa fasuf nari xapiak. ");
INSERT INTO leu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","E layaan na Yesus a texaas sena lalamonan siri mu Ferasi, nane taꞌulan a maana mu bina Judia e fe ulaa fulaa xe la mu bina pe Galili. ");
INSERT INTO leu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Layaan ri taxa ulaa saa, nane e mu fefeng sina, ri fe sangas dal a bina Sameria. ");
INSERT INTO leu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","E ri fesavat la saxa bina pe Sameria ri xalie pa Saikar. A bina ve taxa waan faasilak la bina aava na Yaakop fo tavai a lak sina, na Yosep, pana. ");
INSERT INTO leu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","A raakaaf ina raarum na Yaakop fo xafe, taxa waan pave. A bina xo fo paanaas e na Yesus a maagus fadak sena sangasan sina e voxo maa nai la vangana raakaaf. ");
INSERT INTO leu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Layaan a saxa tefin ti Sameria a savat xena pituf raarum na Yesus a fine, “A fexaxaas no taa tavaiau pana raarum?” ");
INSERT INTO leu_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(A mu fefeng sina ri fo laak xe lana bina aapave xena maraan fanganan.) ");
INSERT INTO leu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","A tefin ti Sameria a xuuse, “Nano, no mataa ti Judia e nenia, ne tefin ti Sameria. Xenaso no nungau pana raarum?” (A mu Juda ri pi fesingan a mu Sameria.) ");
INSERT INTO leu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Na Yesus a suie, “Tamo no texaas sena tatavaian sina Piran e no masam faroxo seseꞌ fo nung nano pana raarum, naak no tamaa nunge e i taa tavai nano pana raarum aava toxan a toyan.” ");
INSERT INTO leu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","E a tefin a xuuse, “Matalava, no piau ta mo xena pituf raarum e a raakaaf aanabeꞌ a tu. No taa pituf raarum ina toyan faa? ");
INSERT INTO leu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nano, no matalava molava sena butaara na Yaakop aava tavai netaara pana raakaaf aanabeꞌ, bo? Nane fatak fo num a raarum ti lana e fulaa a mu rafulak sina e mu tiir, sipsip e bulmakau sina vaxa, ri num ti lana.” ");
INSERT INTO leu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","E na Yesus a suie, “Naseꞌ ta mataa aava num a raarum aanabeꞌ i taa maꞌiu fulaa, ");
INSERT INTO leu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","taasaxa naseꞌ ta mataa i taa num a raarum ne tavaie pana, i taa pife maꞌiu fulaa. Tuuna a raarum ne tavaie pana i tafe savat malaan sena matana raarum pe la xunus ina e a mataa aave i tafe bas pana toyan vulai, vulai.” ");
INSERT INTO leu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","E a tefin a nunge, “Matalava, tavaiau pana raarum aanabeꞌ talo ne taa pife maꞌiu e ulaa xe nabeꞌ xena pituf raarum fulaa.” ");
INSERT INTO leu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","E nane xuuse, “Falet, fe xel na lavaam e me ulaamaan.” ");
INSERT INTO leu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","E nane suie, “Nenia, ne piau ta lavaak.” E na Yesus a xuuse, “No kuus tuuna layaan no kuus o no piau ta lavaam. ");
INSERT INTO leu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A mo tuuna o no fo toxan a mu lavaam pama e a mataa aava no taxa taagul xuvul pana naboxo a pife lavaam. Aang, a ferawaian no kuusane monabeꞌ mon a tuuna paaliu.” ");
INSERT INTO leu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","“Ai, matalava” a tefin a kuus, “Naboxo ne texaas o nano, no saxa mataa ina kuus fatuxai. ");
INSERT INTO leu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A mu bumaam ri naangus xuluna put aanabeꞌ, taasaxa nami mu Juda mi kuus faagut o a bina ina naangusan tuuna sitaara i taxa waan pe Jerusalem.” ");
INSERT INTO leu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","E na Yesus a kuus xe sina, “Langai faroxoiau; saxa yaan i taa savat e a naangusan xe sina Tamataara i taa pife waan xuluna put aanabeꞌ o pe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nami, mi nangus a mo mi pife masam sena; maam nangus a saxa maam texaas sena, senaso a fufuna fakaaxupan a savat la palou ina mu Juda. ");
INSERT INTO leu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Taasaxa a yaan i taa savat e naboxo taxa waan faasilak, layaan a mu rabuna aava ri namkai tuuna ri taa nangus na Tamataara pana vovau e pana lamonan tuuna. E voxo na Tamataara taxa seng a mu rabuna ri fexaxaas xena nangus tuuneie. ");
INSERT INTO leu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","A Piran ve a vovau e nari aava rao ri nanguse, ri taa nanguse pana vovau e pana lamonan tuuna.” ");
INSERT INTO leu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","A tefin a xuuse, “Ne texaas o a Mataa Failai (nane aava ri xalie pa Krais) i taxa filimaan. E layaan i taa savat i taa xuus fatexaas netaara pana maana mo xapiak.” ");
INSERT INTO leu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","E na Yesus a xuuse, “Nenia mon ne mataa aave; naboxo taare taxa irimai.” ");
INSERT INTO leu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","E monabeꞌ mon a mu fefeng si Yesus ri savat e ri maa ipulane taxa irimai xuvul pana tefin, taasaxa piau ta saxa a fine o “A so to mo no vubuxane?” o “Xenaso no irimai xuvul pana?” ");
INSERT INTO leu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","A tefin xo, a taꞌulan a vuk ina pituf raarum e falet xe la bina e fe xuus a mu rabuna, ");
INSERT INTO leu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Filimaan e mi maa xalum a mataa aava xuus fatexaasau pana maana mo xapiak aava ne fo mo vile. Naak, nane ve a Mataa Failai?” ");
INSERT INTO leu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nari, ri savat xe lamalei sena bina e ri fepaan xe sina. ");
INSERT INTO leu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","La noyaan aave xo, a mu fefeng ri xuuse, “Mataa ina Fepitaa, no fangan saa xalak.” ");
INSERT INTO leu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","E nane sui nari, “Nenia, ne toxan a fanganan aava mi vungut sena.” ");
INSERT INTO leu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","E mu fefeng ri ferawai la palou iri xa o “Naak, a saxa mataa fo tavaie pana fanganan?” ");
INSERT INTO leu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Na Yesus a xuus nari, “A fanganan siak a malaan, ne taxa vil a vubuxanan sina Saxa aava fo fengau e vaxa xena fataxapin a faisok sina. ");
INSERT INTO leu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mi fuuna ferawai malaan bo? ‘A fulun talafaat e a yaan ina faxuvul a fanganan taa savat.’ Taasaxa ne xuus nami: kaalum xolai, xalum a mu uma, naboxo ri fo matoxol e ri fo fexaxaas sena faxuvulan. ");
INSERT INTO leu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","E naboxo a mataa ina siaxaana fanganan i taxa faisok pana faxuvulaana e i taa siak a mamareiai sina. E a mo nane taxa faxuvule ve a toyan vulai, vulai. E voxo a mataa aava xapis a kam ina fanganan e a mataa aava siak faxuvul a fanganan re taa faamamaas xuvul. ");
INSERT INTO leu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","E voxo a ferawaian ti kavai aanabeꞌ a tuuna o saxa i taa xapis a kam ina fanganan e xasafuna i taa faxuvul a fanganan ina. ");
INSERT INTO leu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nenia, ne feng nami xena siak faxuvul a fanganan aava paamua mi pife faisoxane. Saxanofuna ri fo faisok faagut pana e nami, mi taxa faisok xuvul pari layaan mi taxa siak faxuvul a fanganan aave. ");
INSERT INTO leu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","A mu Sameria xaves ti la bina aave ri namkai se Yesus sena ferawaian sina tefin aave layaan nane kuus, “Nane xuus fatexaasau pana maana mo xapiak aava ne fo mo vile.” ");
INSERT INTO leu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Layaan a mu Sameria ri savat si Yesus ri nunge o i taa taagul xuvul pari. E nane taagul la palou iri fefexaxaas sena yaan taragua. ");
INSERT INTO leu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","E a rabuna xaves ri namkai senaso ri langai a ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","E ri xuus a tefin aave, “Maam namkai naboxo taasaxa fufuna namkaian simaam pife sena ferawaian siim. Nemaam fatak fo langaie e maam texaas tuuna o a Mataa aanabeꞌ ve i taa fakaxup a mu rabuna la xavala. ");
INSERT INTO leu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Lamina yaan taragua aave nane taꞌulan nari xena falet xe puaa Galili. ");
INSERT INTO leu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Paamua na Yesus fatak fo kuus sena mu rabuna ina kuus fatuxai o a mu rabuna ti la fufubina siri ri taa pife suaian nari.) ");
INSERT INTO leu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Layaan nane savat pe Galili, a mu Galili ri faamamaas sena, senaso nari vaxa ri fo falet xe Jerusalem e ri waan pave la Fenamo ina Paaliuan. E ri fo xalum a maana mo xapiak nane fo vile pave. ");
INSERT INTO leu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","E nane savat faꞌulaa la bina Kena pe Galili, a bina aava nane fo puk a raarum e fasavat a wain. E pave saxa matalava sina piran king taxa waan bange e a lak sina taxa mati giis pe Kapanam. ");
INSERT INTO leu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","A mataa aave a langai o na Yesus fo savat pe Galili ti Judia. E nane falet xe sina e nung faagutane o i taa fe vil faroxoi a lak sina aava faasilak i taa maat. ");
INSERT INTO leu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","E na Yesus a kuus, “Nami mu rabuna mi lamon malaan: tamo mi tamaa xalum a mo faꞌipul o a mo ina gutan mi taa namkai.” ");
INSERT INTO leu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Taasaxa matalava sina piran king a xuuse, “Piran, filimaan ulaa lak siak i tamaa maat.” ");
INSERT INTO leu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Na Yesus a xuuse, “Ulaa saa. A lak siim i taa to.” E a matalava a namkai pana ferawaian na Yesus a xuuse pana e falet. ");
INSERT INTO leu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Layaan nane taxa falet e pife savat lunai, a mu sisiak sina ri maa fesuaiane la salan e ri xuuse o a lak sina i taxa waan faroxo. ");
INSERT INTO leu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","E nane fin nari, “Laso ta yaan a lak siak fo savat faroxo?” E ri suie, “Lanef, faasilak la paanaas, a giisan sina taꞌulane.” ");
INSERT INTO leu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","E a tamana lak a texaas o a yaan aapave a yaan fatak aava na Yesus fo xuuse, “A lak siim i taa to.” E voxo a mataa aave e maana rabuna lana lifu sina ri namkai se Yesus. ");
INSERT INTO leu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","A mo aanabeꞌ a fataraguiaana fakalimaanan aava na Yesus a vile layaan nane falet xe Galili ti Judia. ");
INSERT INTO leu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Saxanu yaan lumui na Yesus a laak xe Jerusalem xe la fenamo lava sina mu Juda. ");
INSERT INTO leu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","E pave la bina Jerusalem, faasilak la matana bina ri xalie pana Yalaxau sina mu Sipsip, ri toxan a bina pana raarum xena susuuf, lana pok bina Erameik ri fuuna xalie pana Betesda. E a bina raarum aanabeꞌ a toxan a ‘veraanda’ pama a fakaliuane. ");
INSERT INTO leu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","La bina aapave, a mu rabuna pana matafanan ri fuuna faxuvul, a maana buk rabuna malaan: a mataa piif, mataa pana kana tapil, o a mataa pana kana o mana maat. Nari, ri fuuna waan bang a faburaaxan ina raarum. ");
INSERT INTO leu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Senaso la saxano yaan a angelo i taa sivi xe pave e i taa faburaak a raarum. E naseꞌ ta mataa i taa du paamua lana raarum lamina faburaaxan ina, a mataa aave i tafe roxo fulaa sena so ta giisan aava fo sipe. ");
INSERT INTO leu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Lavaxa, saxa mataa taxa mati pave fo toxan a giisan pana mariaas sangafilu talatul pana pisiktul. ");
INSERT INTO leu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Layaan na Yesus a xalume, nane texaas o a mataa aave fo waan lokavai paaliu e a xuuse, “No vubuk roxo fulaa?” ");
INSERT INTO leu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","E a mataa pana giisan a suie, “Matalava, ne piau ta mataa xena xavang faduiau lana raarum layaan a angelo fo faburaaxe, la yaan ne taxa rao ne du a xasa mataa fo du paamuin nenia.” ");
INSERT INTO leu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","E na Yesus a xuuse, “Tamasiak, siak a ivin siim e no sangas.” ");
INSERT INTO leu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","E monabeꞌ mon a mataa aave a savat roxo e nane siak a ivin sina e sangas. A yaan aanabeꞌ ve a Yaan ina Fangaafusan. ");
INSERT INTO leu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","E voxo a mu matalava Juda ri xuus a mataa aava fo roxo fulaa, “Nabeꞌ ve a Yaan ina Fangaafusan, pife roxo no taxa yaas a ivin siim!” ");
INSERT INTO leu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","E nane sui nari, “A mataa aava vil faroxoiau a xuusau, ‘Siak a ivin siim e no sangas.” ");
INSERT INTO leu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","E ri fine, “Naseꞌ ta mataa a xuus nano, ‘Siak a ivin siim e sangas?” ");
INSERT INTO leu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Taasaxa, a mataa aava vil faroxoian, a vungut o naseꞌ ve fo vil faroxoie. E na Yesus fo laak malit senaso a malila molava ri waan la bina aapave. ");
INSERT INTO leu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mui xo, na Yesus a tingin a mataa aave lana tang lifu lotu e xuuse, “Kaalum, no fo vil faroxoian, muta faasaal fulaa, tamo no bilai fasaat naak a mo saat sena giisan siim tamaa savat la toyan siim.” ");
INSERT INTO leu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","E a mataa aave a paan e fe xuus a mu matalava Juda o na Yesus mon fo vil faroxoie. ");
INSERT INTO leu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","E voxo lamina yaan aanabeꞌ a mu matalava Juda ri vil pengan na Yesus senaso nane fo vil a mo faꞌipul aanabeꞌ la Yaan ina Fangaafusan. ");
INSERT INTO leu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","E na Yesus a xuus nari mu matalava Juda, “Mi lamon o na Tamaang taxa fangaafus sena faisok sina, bo? Piau! Naboxo nane taxa faisok e nenia vaxa, ne taxa faisok malaan sena.” ");
INSERT INTO leu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","E voxo nari mu matalava Juda ri faagut paaliu pana punuk na Yesus senaso ri lamon o i taxa kawaasan a Yaan ina Fangaafusan e fulaa ri baian nane kuus o a Piran ve na Tamana. Layaan nane kuus malaan ri texaas o nane kuus o nane e a Piran, re fexaxaas. ");
INSERT INTO leu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Na Yesus a xuus fulan nari, “Tuuna paaliu ne xuus nami, na Natuna mon, a pife fexaxaas sena vil ta saxa mo. Nane a fexaxaas i taa vil a mo aava nane fo xalum na Tamana vile. E voxo so ta vilaana na Tamana taxa vile, na Natuna taa usie sait. ");
INSERT INTO leu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Senaso na Tamana a vubuxan xasingit na Natuna e nane taxa faxalite pana maana mo xapiak aava nane taxa vile. A mo faꞌipul mi fo xalume, na Tamana taa faxalit na Natuna pana maana mo molava sena e voxo mi taa ipul temasaat seri. ");
INSERT INTO leu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Na Tamana a fexaxaas sena yaas fatiginei a mu mamaat e tavai nari pana toyan, bo? E na Natuna vaxa taa tavai nari aava nane taa siak fati nari, pana toyan. ");
INSERT INTO leu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ne kuus tuuna, na Tamana taa pife tiis ta saxa mataa. A maana mo xapiak ina tiisan na Tamana fo tavai na Natuna pana ");
INSERT INTO leu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","talo nari mu rabuna xapiak taa suai se Natuna malaan seꞌ ri suai se Tamana. Na Tamana fo feng na Natuna e naseꞌ ta mataa i taa pife suaiane, i taa pife suaian sait na Tamana. ");
INSERT INTO leu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ne xuus tuunei nami, tamo ta mataa aava langai a ferawaian siak e namkai sena Saxa aava fo fengau, a mataa aave a toxan a toyan vulai. E nane aave i taa pife xalum a yaan ina tiisan senaso nane fo xasliu a maatan e taxa to. ");
INSERT INTO leu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ne xuus tuunei nami fulaa: saxa yaan taxa filimaan e fo savat naboxo, e la yaan aave a mu mamaat ri taa langai a ling i Natuna Piran e nari aava ri langai faroxo ri taa to. ");
INSERT INTO leu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Na Tamana a fufuna toyan, bo? E vaxa nane siak fati na Natuna talo i taa waan a fufuna toyan sait. ");
INSERT INTO leu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","E saxa mo fulaa, nane fo tavaie pana ngavuk ina tiisaana maana mo xapiak senaso nane ve a Natuna Mataa. ");
INSERT INTO leu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Muta ipul sena ferawaian aanabeꞌ, senaso a yaan taxa filimaan e lana yaan aave a maana rabuna aava ri fo maat e ri taxa waan la bina mamaat, ri taa langai a ling i Natuna, ");
INSERT INTO leu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","e ri taa savat xe sina. Nari aava mu vilaana siri roxo ri taa siak a toyan vulai e nari aava mu vilaana siri pife roxo ri taa siak a fakasanaman. ");
INSERT INTO leu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nenia, ne piau ta gutan xena vil ta saxa mo; ne taxa titiis fexaxaas sena ferawaian sina Tamaang e a tiisan siak a fatak senaso ne pife usi a vubuxanan siak, ne taxa usi a vubuxanan sina Saxa aava fo fengau. ");
INSERT INTO leu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Tamo nenia fatak ne kuusanau, a kuusan siak a pife fexaxaas. ");
INSERT INTO leu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Taasaxa toxan a saxa fulaa aava kuusanau e nenia, ne texaas o a kuusan sina sega a tuuna. ");
INSERT INTO leu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Mi fo fin na Jon e nane fo ferawai fatak. ");
INSERT INTO leu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nenia, ne pife lalamon faagut sena kuusan siri mu rabuna mon, taasaxa ne xuus nami pana talo mi taa fakaaxupan. ");
INSERT INTO leu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Na Jon a malaan sena laam aava taxa raam e lang faagut e mi fo faamamaas pana malangan sina pana saxano yaan mon. ");
INSERT INTO leu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Taasaxa a kuusan sega a molava sena kuusan si Jon. A mu faisok aava na Tamaang fo tavaiau pana xena fataxapine, a maana faisok aave nenia, ne taxa vile. A mu faisok aanabeꞌ ri kuusanau sait e ri faxalit nami o na Tamaang fo fengau. ");
INSERT INTO leu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","E na Tamaang aava fo fengau, nane vaxa fo kuusanau. Mi pi lalangai a ling ina e mi pi xaxalum a vipin ina. ");
INSERT INTO leu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","A ferawaian sina a pife taagul la xunus imi senaso mi pife namkai sena saxa aava nane fo fenge. ");
INSERT INTO leu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mi taxa seng, seng vulai lana Xakalayan ina Ferawaian sina Piran senaso mi lamon o a toyan vulai taxa waan lana, taasaxa a Xakalayan aanabeꞌ taxa kuusanau ");
INSERT INTO leu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","e mi bai filimaan xe siak xena siak a toyan aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Nenia, ne pife lalamon temasaat pana suaian sina mu rabuna, ");
INSERT INTO leu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","taasaxa ne texaas o nami, mi piau ta vubuxan xasingitan sena Piran la xunus imi. ");
INSERT INTO leu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ne fo savat nabeꞌ lapaana isina Tamaang e mi pife suaian nenia. Tamo ta saxa mataa i taa savat lapaana isin sina fatak mon, mi taa suaian nane, bo? ");
INSERT INTO leu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Malaafaa mi fexaxaas sena namkai layaan mi lalamon temasaat sena suaian simi e mi pife seng a suaian aava Piran fatak a fexaxaas sena tavai nami pana. ");
INSERT INTO leu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Muta lamon o nenia, ne taa gel tifi nami la mata Tamaang, piau. Na Moses aava mi lamon o i taa xavang nami, nane ve i taa gel tifi nami. ");
INSERT INTO leu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tamo mi fo namkai sena Xakalayan si Moses mi taa namkai sega senaso nane fo kala sega. ");
INSERT INTO leu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tamo mi pife namkai sena Xakalayan sina, malaafaa mi taa namkai sena ferawaian siak?” ");
INSERT INTO leu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Lumui na Yesus a laak xuluna xaati e falet xe la xasa paxasing ina Laman Galili; ri xalie pana Raarum Taibirius. ");
INSERT INTO leu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","A toxan a tang malila taxa usie senaso ri fo xalum a maana mo faꞌipul aava nane fuuna vile xena vil faroxoi a mu rabuna pana giisan. ");
INSERT INTO leu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Na Yesus a ung e laak xe xuluna put e fe nai pave xuvul pana mu fefeng sina. ");
INSERT INTO leu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","A fenamo molava sina mu Juda, a Yaan ina Paaliuan, fo faasilak. ");
INSERT INTO leu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na Yesus a kaalum e xalum a tang malila taxa savatmaan xe sina e nane fin na Filip, “Taara taa maraan a bret fexaxaas xena fafangan a mu rabuna aapave faa?” ");
INSERT INTO leu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nane kuus malaan senaso nane buk tafang mon na Filip, taasaxa nane fatak xa a texaas o so ta mo nane i taa vile. ");
INSERT INTO leu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Na Filip a suie, “Ai, tamo ne faisok pana fulun pisiktul, ne pife fexaxaas sena maraan a bret fexaxaas xena fafangan nari xapiak pana xavil modak, modak.” ");
INSERT INTO leu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Taasaxa saxa fefeng, na Endru, na ti Saimon Pita, a kuus, ");
INSERT INTO leu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“A toxan a saxa lak modak nabeꞌ pana bret baali pama e a din taragua; taasaxa fanganan modak malaan a pife fexaxaas xena fafanganaan nari xapiak.” ");
INSERT INTO leu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Na Yesus a kuus, “Xuus a mu rabuna o ri taa nai.” A bina aave ve toxan a yi e mu tomexaan xo ri nai suꞌ e a xakatan siri ve faasilak 5,000. ");
INSERT INTO leu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Na Yesus a siak a bret baali e fenung e kuus faasiroxo paaliu xe sina Piran. Mui nane viak a bret e tavai a mu rabuna aava ri nai xolai pana e nane vil malaane pana din sait. E mu rabuna xapiak ri siak fanganan fefexaxaas sena vubuxanan siri. ");
INSERT INTO leu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Layaan ri fo maasi xo, na Yesus a xuus a mu fefeng sina, “Faxuvul a mu xavil xapiak aava ri taxa waan senaso ne buk o piau ta saxa xavil i taa milung.” ");
INSERT INTO leu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Lavaxa, ri faxuvule e ri fabas a bi sangafilu saxa pana taragua pana mu xavil ina bret baali aava waan lamina fanganan. ");
INSERT INTO leu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","A mu rabuna ri xalum a mo faꞌipul aava na Yesus fo vile e ri kuus, “A tuuna, nane ve a Mataa ina Kuus Fatuxai aava kavai ri fo kuus o i taa filimaan xe la xavala.” ");
INSERT INTO leu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","E voxo na Yesus fo texaas o nari rao ri taa yote e ri taa fatigineie malaan sena ‘king’ siri e nane sang mon fe laak fufunai xe xuluna put. ");
INSERT INTO leu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Lavaxa, a bina xo leaaf paaliu e mu fefeng si Yesus ri sivi xe la gun. ");
INSERT INTO leu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ri xawas xuluna xaati e rao ri taa falet xe Kapanam. A bina xo suk e na Yesus a pife savat siri lunai. ");
INSERT INTO leu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ri taxa falet e a tof a savat siri senaso a reref molava taxa tigina. ");
INSERT INTO leu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Lamina yaan ri xaul, xaul naak faasilak a kilomita pama o pisaxa, ri xalum na Yesus i taxa sangasmaan xuluna laman. Nane savat faasilak la tana xaati e ri mataut fasaat paaliu. ");
INSERT INTO leu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nane xuus nari, “Nenia move, muta mataut!” ");
INSERT INTO leu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","E ri vubuk o i taa xawas xuluna xaati e fataapus paaliu ri savat la bina aava rao ri ung lana. ");
INSERT INTO leu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","La yaan lamina a malila aava ri waan pave la xasing ina laman, ri texaas o a xaati saxa mon fo waan pave e mu fefeng si Yesus sang mon ri fo falet taasaxa nane pife xawas xuluna xaati xuvul pari. ");
INSERT INTO leu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Xasano xaati ti Taibirius ri savat xe la bina aapave; a bina aave a malila fo ngan a bret aava Memai fo fenung xuluna ");
INSERT INTO leu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","e voxo, layaan a malila ri texaas o na Yesus e a mu fefeng sina ri pife waan fulaa, nari sait ri xawas xuluna maana xaati e ri falet xena seng na Yesus pe Kapanam. ");
INSERT INTO leu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Layaan ri tingine la xasa paxasing ina laman ri fine, “Ai, Mataa ina Fepitaa, laso ta yaan no fo savat nabeꞌ?” ");
INSERT INTO leu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Na Yesus a sui nari malaan, “Tuuna paaliu ne xuus nami, mi pife sengau senaso mi xalum a mo faꞌipul ne vile. Taasaxa mi sengau senaso mi fo ngan a bret pave e mi maasi. ");
INSERT INTO leu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Muta faisok pana maana buk fanganan aava i taa masiik, piau. Taasaxa faisok pana fanganan aava i taa waan vulai e i taa lisan a toyan xe vulai. A fanganan naang ve a Natuna Mataa i taa tavai nami pana senaso a Piran Tamataara fo siak fatie e tavaie pana gutan xena vil malaane.” ");
INSERT INTO leu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","E ri kuus, “A so ta mo maam taa vile xena vil a faisok aava Piran a vubuxane?” ");
INSERT INTO leu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Na Yesus a sui nari, “A faisok sina Piran a malaan: ‘Mi taa namkai sena saxa aava Piran fo fenge.” ");
INSERT INTO leu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","E ri xuus fulane, “Lavaxa, a so ta fakalimaanan no taa vile talo maam taa xalume e namkai sema. No taa vil a so? ");
INSERT INTO leu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","A mu butaara ri ngan a mo taara xalie pana ‘maanaa’ pe la xobingil, malaan sena Ferawaian sina Piran aava kuus: ‘Nane tavai nari pana bret ti la xunavata xena fanganan.” ");
INSERT INTO leu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Na Yesus a xuus nari, “Ne taa xuus tuunei nami pana fufuna ferawaian aave, na Moses pife tavai nami pana bret ti la xunavata, taasaxa a malaan, na Tamaang i taxa tavai nami pana bret tuuna ti la xunavata. ");
INSERT INTO leu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Senaso a bret sina Piran a mo aava sivimaan ti la xunavata e i taa tavai a mu rabuna la xavala pana toyan.” ");
INSERT INTO leu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","E ri nunge, “Memai, tavai nemaam pana bret aanabeꞌ vulai.” ");
INSERT INTO leu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Na Yesus a xuus nari, “Nenia xa, ne bret ina toyan, naseꞌ i taa filimaan xe siak i taa pife lagai e vaxa nane aava i taa namkai sega i taa pife maꞌiu fulaa. ");
INSERT INTO leu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ne xuus nami o mi fo xalumau taasaxa mi pife namkai lunai sega. ");
INSERT INTO leu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","A maana rabuna aava Piran a tavaiau pana, ri taa tamana filimaan xe siak e ne taa pife feng tapin ta saxa mataa aava i taa savat xe siak. ");
INSERT INTO leu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Senaso ne pife sivimaan ti la xunavata xena vil a vubuxanan siak, piau. Ne fo sivimaan xena vil a vubuxanan sina saxa aava fengau. ");
INSERT INTO leu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","E a vubuxanan sina saxa aava fengau a malaan: nari mu rabuna aava nane fo tavaiau pari, ne taa pife taꞌulan ta saxa iri. Taasaxa ne taa fatatoi faꞌuli nari xapiak lana Yaan Fataxapiak. ");
INSERT INTO leu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","A vubuxanan si Tamaang a malaan: a maana mu rabuna aava ri xalum tuunei na Natuna e ri namkai sena, nari xo ri taa siak a toyan vulai, vulai, e fulaa ne taa fatatoi faꞌuli nari lana Yaan Fataxapiak.” ");
INSERT INTO leu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","E nari mu Juda ri fefinaas xolai se Yesus senaso nane kuus, “Nenia, ne Bret aava sivimaan ti la xunavata.” ");
INSERT INTO leu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","E ri kuus, “Nane na Yesus, bo? A lak si Yosep? Na tamana narie ninana, taara texaas sere, bo? Malaafaa nane kuus: ‘Nenia, ne fo sivimaan ti la xunavata?” ");
INSERT INTO leu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Na Yesus a xuus nari, “Muta lo fefinaasai malaave. ");
INSERT INTO leu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Piau ta saxa a fexaxaas sena filimaan xe siak tamo na Tamataara aava fengau, a pife xele. E naseꞌ ta mataa aava fo xelan, ne taa fatatoie la Yaan Fataxapiak. ");
INSERT INTO leu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","A xakalayan aanabeꞌ taxa waan lana Xakalayan sina mu rabuna ina kuus fatuxai: ‘E nari xapiak, a Piran taa fapiti nari.’ A maana rabuna xapiak aava ri fo langai a ferawaian si Tamataara e ri fo siak a texaasan sena, nari ve ri taa filimaan xe siak. ");
INSERT INTO leu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Piau ta mataa fo xalum na Tamataara taasaxa saxa aava fo sivimaan ti laaꞌui sina Piran, nane sang mon fo xalum na Tamataara. ");
INSERT INTO leu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ne xuus tuunei nami, nane aava namkai i taa toxan a toyan vulai, vulai. ");
INSERT INTO leu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nenia ve ne Bret ina Toyan. ");
INSERT INTO leu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","A mu bumi ri ngan a ‘maanaa’ pe la bina xobingil, taasaxa ri femaat. ");
INSERT INTO leu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nabeꞌ ve si a bret aava sivimaan ti la xunavata e voxo layaan ta mataa taa ngane i taa pife maat. ");
INSERT INTO leu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nenia xa, ne bret i taxa to aava sivimaan ti la xunavata. Tamo ta mataa taa ngan a bret aanabeꞌ i taa to vulai. A bret aanabeꞌ ve a vipin iga aava ne taa lisane xena maraan faꞌuli a maana rabuna ti la xavala.” ");
INSERT INTO leu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","E voxo mu Juda ri fetok faagut la palou iri, “Malaafaa a mataa aanabeꞌ a fexaxaas sena tavai netaara pana vipin ina xena nganaana?” ");
INSERT INTO leu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","E na Yesus a xuus fulan nari, “Ne taxa xuus tuunei nami, tamo mi pife ngan a meska ina Natuna Mataa e mi pife num a ria ina, mi taa piau ta toyan tuuna. ");
INSERT INTO leu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Naseꞌ ta mataa taa ngan a meska iga e num a ria iga, nane ve, a toxan a toyan vulai e ne taa tamana fatatoie la Yaan Fataxapiak. ");
INSERT INTO leu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Senaso a meska iga a fanganan tuuna e a ria iga a mo ina numan tuuna. ");
INSERT INTO leu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Naseꞌ ta mataa i taa ngan a meska iga e i taa num a ria iga, i taa taagul lapaana gutan siak e nenia, ne taa taagul xuvul pana. ");
INSERT INTO leu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ta mataa aava i taa ngan vulanau i taa to senaso nenia, ne taxa to. A mo aanabeꞌ a fexaxaas senaso na Tamataara fo fengau e ne taxa to vulai lapaa Tamataara. ");
INSERT INTO leu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nabeꞌ ve a bret aava sivimaan ti la xunavata. A pife malaan sena ‘bret maanaa’ a mu bumi fo ngane, piau. A bret siri a pife ti votan a maatan seri. Taasaxa nane aava i taa ngan a bret aanabeꞌ i taa siak a toyan vulai, vulai.” ");
INSERT INTO leu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Na Yesus a kuus malaan layaan nane taxa fapiti nari lana lifu ina faxuvulan pe Kapanam. ");
INSERT INTO leu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","E xaves ina mu fefeng si Yesus, layaan ri langai a ferawaian aanabeꞌ ri kuus malaan, “A ferawaian aanabeꞌ a lagaf temasaat. Naseꞌ fexaxaas i taa langaie?” ");
INSERT INTO leu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Na Yesus a texaas lana xunus ina o a mu fefeng sina ri taxa fefinaas sena mo aanabeꞌ e a xuus nari, “A ferawaian aanabeꞌ naak i taxa fakasal temasaatan nami, bo? ");
INSERT INTO leu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","A so ta mo i taa savat tamo mi taa xalum a Natuna Mataa i taxa laak faꞌulaa xe la bina aava nane waan lana paamua? ");
INSERT INTO leu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A Vovau a tatavai pana toyan; a vipin o meska, re mo palau mon. A mu vapaling aava ne fo xuus nami pana, nari ve ri vovau e ri toyan xana mataa. ");
INSERT INTO leu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Taasaxa saxanofuna imi, mi pife namkai.” Senaso na Yesus fo texaas ti la tangpat o naseꞌ ta mu fefeng sina ri pife namkai tuuna e nane texaas o naseꞌ i taa pet lisane. ");
INSERT INTO leu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","E nane kuus fulaa, “A vilaana aanabeꞌ a fufuna ferawaian siak layaan ne xuus nami o piau ta mataa fefexaxaas sena filimaan xe siak tamo na Tamataara a pife xele.” ");
INSERT INTO leu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tangpat la yaan aanabeꞌ e falet, saxano fefeng sina ri taꞌulane e ri pife sangas xuvul pana fulaa. ");
INSERT INTO leu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","E na Yesus a fin nari mu yaamut sangafilu saxa pana taragua, “Nami vaxa, mi buk paan patak?” ");
INSERT INTO leu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","E na Saimon Pita a suie, “Memai, maam taa falet xe siseꞌ? Nano, no toxan a ferawaian ina toyan vulai ");
INSERT INTO leu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","e maam fo namkai e masam tuuna o nano, no Saxa Mataa Taap sina Piran.” ");
INSERT INTO leu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","E na Yesus a suie, “Ne fo siak fati nami bo, nami Sangafilu Saxa pana Taragua? Taasaxa saxa la palou imi ve si Setan.” ");
INSERT INTO leu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nane taxa ferawai se Judas, na natu Simon Iskeriot senaso nane a saxa sina mu Sangafilu Saxa pana Taragua e nane ve i taa pet lisan na Yesus. ");
INSERT INTO leu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Lamina mu yaan aanabeꞌ na Yesus a falet e fe sangas xolai pe Galili. Nane vil malaane senaso a mu Juda pe Judia rao ri punuxe. ");
INSERT INTO leu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mui xo, saxa fenamo sina mu Juda a faasilak, a Fenamo ina Sawat. ");
INSERT INTO leu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","E voxo nari mu ti Yesus ri xuuse, “Taꞌulan a bina aanabeꞌ e no falet xe Jerusalem talo a mu fefeng siim pave ri taa xalum a mu faisok lava aava no taxa vile. ");
INSERT INTO leu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Senaso tamo ta mataa a vubuk o a mu rabuna xaves ri taa texaas sena, i taa pife fun a faisok sina. Nano, no fuuna vil a maana mo aanabeꞌ e voxo faxalit a mu rabuna la xavala pana.” ");
INSERT INTO leu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ri kuus malaan senaso nari, mu fetinan vaxa, ri pife namkai sena. ");
INSERT INTO leu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Na Yesus a xuus nari, “A yaan roxo siak a pife savat lunai taasaxa nami a maana yaan xapiak ri roxo semi. ");
INSERT INTO leu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","A mu rabuna ti la xavala ri pife fexaxaas sena baian nami, taasaxa ri baianau senaso ne fuuna kuus o a maana mu vilaana ri vivile ri saat sang. ");
INSERT INTO leu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mi laak saa xe la fenamo aapave. Ne taa pife laak lunai senaso a yaan roxo xanak pife savat lunai.” ");
INSERT INTO leu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nane kuus malaan e a waan suꞌ pe Galili. ");
INSERT INTO leu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Taasaxa lamina yaan ri fo paan xe la fenamo, nane sait a laak saa taasaxa pife sangas la matavas, nane falet fufunai mon. ");
INSERT INTO leu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pave la fenamo a mu Juda ri taxa lo senge e ri kuus, “Faa ta mataa aave?” ");
INSERT INTO leu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","La palou ina tang malila aave ri taxa lo fefinaas xolai sena. Saxanofuna ri kuus, “Nane a mataa roxo!” E xasanofuna ri sui nari, “Piau, nane taxa familung a rabuna xaves!” ");
INSERT INTO leu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Taasaxa nari xapiak ri pife ferawai sena la matavas senaso ri mataut sena mu matalava Juda. ");
INSERT INTO leu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","La palou ina Fenamo, na Yesus a laak xe la tang lifu lotu e fefepitaa. ");
INSERT INTO leu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A mu matalava Juda ri ipul e ri kuus, “A mataa aanabeꞌ, piau taa mataa fe fapitie, bo? E malaafaa nane fo siak a texaasan aapave?” ");
INSERT INTO leu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","E na Yesus a sui nari, “A fepitaian aanabeꞌ a pife mo siak taasaxa mo sina Saxa aava fo fengau. ");
INSERT INTO leu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Layaan ta mataa a buk usi a vilaana sina Saxa aave, i taa texaas sena fufuna fepitaian aanabeꞌ, tamo fo savat sina Piran o tamo nenia, ne ferawai lapaana gutan siak fatak. ");
INSERT INTO leu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","A mataa aava taxa ferawai lapaana gutan sina fatak nane buk siak fati a isina xa; taasaxa nane aava buk siak fati a isina Saxa aava fenge, nane ve, a mataa ina tuunayan e piau ta lalosaat fe waan sina. ");
INSERT INTO leu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Na Moses fo tavai nami pana mu vuputkai, bo? Taasaxa piau ta saxa simi fe usi fatak a maana vuputkai. Xenaso mi taxa lo tafang pana punuxau?” ");
INSERT INTO leu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","E mu rabuna pave ri suie, “Ai, a masalai fo vao nano. Naseꞌ taxa rao i punuk nano?” ");
INSERT INTO leu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Na Yesus a xuus nari fulaa, “A toxan a saxa faisok ne fo vile la Yaan ina Fangaafusan e mi taxa lo lamon fatateak lunai sena. ");
INSERT INTO leu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Na Moses fo fapiti nami pana vilaana ina vuputuk (taasaxa pife savat si Moses, a savat paamua sina mu butaara ti kavai) e a vilaana aanabeꞌ nami vaxa mi fuuna vile la Yaan ina Fangaafusan. ");
INSERT INTO leu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tamo mi taa putuk a lak la Yaan ina Fangaafusan talo mi taa pife faasaal sena vuputkai si Moses, xenaso mi taxa marala sega layaan ne vil faroxoi xapin a saxa mataa la Yaan ina Fangaafusan? ");
INSERT INTO leu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Muta lo tiis a maana mo pana xakaaluman mon taasaxa lamon faroxoie e tiis faxaradaxe.” ");
INSERT INTO leu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Lavaxa, saxano rabuna pe Jerusalem ri fefiai malaan, “A saxa aanabeꞌ mon ve, a mataa aava ri taxa tafang pana punuxaana, bo? ");
INSERT INTO leu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Taasaxa kaalum, nane taxa ferawai la matavas e ri piau ta vapaling xena suiaana. A fexaxaas a mu matalava sitaara ri masam o nane a Mataa Failai? ");
INSERT INTO leu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Taasaxa taara texaas sena fufubina sina mataa aanabeꞌ e layaan a Mataa Failai i taa savat, piau ta mataa i taa texaas sena fufubina sina.” ");
INSERT INTO leu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Layaan na Yesus taxa fepitaa pe lana tang lifu lotu nane xukulai, “Aang, mi texaas sega e mi texaas sena fufubina siak. Taasaxa ne pife filimaan lapaana gutan siak fatak. Nane aava fo fengau, nane ve a tuunayan e nane xo, mi vungut sena. ");
INSERT INTO leu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nenia, ne texaas sena senaso ne savatmaan ti la bina sina e nane fo fengau.” ");
INSERT INTO leu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sena ferawaian aanabeꞌ rao ri pise taasaxa piau ta mataa fe tawe senaso a yaan sina pife savat lunai. ");
INSERT INTO leu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","A mu rabuna xaves lana malila, ri namkai sena e ri kuus, “Layaan a Mataa Failai taa savat, i taa vil a maana fakalimaanan xaves sena mataa aanabeꞌ?” ");
INSERT INTO leu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","A mu Ferasi ri langai sena maana mo a malila ri taxa fefinaas pana. E voxo a mu memai priis e mu Ferasi ri feng a mu sisiak, a rabuna ina kaalum votai siri xena pise. ");
INSERT INTO leu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Na Yesus a kuus, “Ne taa waan xuvul pami famodak fulaa lunai e mui ne taa paan xe sina aava fengau. ");
INSERT INTO leu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Mi taa sengau taasaxa mi taa pife tinginau e la bina ne taa taagul lana mi pife fexaxaas sena savat pave.” ");
INSERT INTO leu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","A mu Juda ri fefiaian nari xa, “Ai, a mataa aanabeꞌ rao i taa paan xe faa e taara pife fexaxaas sena tingine? Naak nane taa falet xe la mu bina sina mu tautaara aava ri taxa taagul la palou ina mu Griik, bo? I taa fe fapiti nari, mu Griik, bo? ");
INSERT INTO leu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","A so ta malasuf ina ferawaian aanabeꞌ sina: ‘Mi taa sengau taasaxa mi pife fexaxaas sena tinginau senaso la bina ne taagul lana mi pife fexaxaas sena savat lana’?” ");
INSERT INTO leu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","La yaan fataxapiak ina fenamo aanabeꞌ ve, a yaan molava ina e na Yesus a tigina e kuus, “Naseꞌ ta mataa taxa maꞌiu, a fexaxaas i taa filimaan xe siak e num. ");
INSERT INTO leu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Naseꞌ ta mataa namkai sega malaan sena xakalayan fo kuus: a raarum ina toyan i taa liu savat ti pe la xunus ina.” ");
INSERT INTO leu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nane ferawai malaan, sena Vovau Xaradak senaso a mu rabuna aava ri namkai se Yesus, ri taa siak a Vovau Xaradak. Taasaxa la yaan naang, la yaan ina ferawaian sina, a Vovau Xaradak a pife lisanan lunai senaso na Yesus pife siak a maasaxan sina lunai e pife laak xe la bina sina Piran. ");
INSERT INTO leu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Layaan a saxano rabuna la palou ina malila ri langai a ferawaian aanabeꞌ ri kuus, “Ai fatak ve, a mataa aanabeꞌ ve a saxa Matalava ina Kuus Fatuxai.” ");
INSERT INTO leu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","E xasanofuna ri kuus, “Nane ve a Mataa Failai.” Taasaxa saxanofuna ri fefiai, “Naak a Mataa Failai i taa pife savat ti Galili. ");
INSERT INTO leu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","A xakalayan sitaara a kuus malaan: a Mataa Failai i taa savat ti lana pabung si Devit e Betlihem ve a bina si Devit, bo?” ");
INSERT INTO leu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","E voxo a malila ri toxan a lamonan taragua sena. ");
INSERT INTO leu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Saxanofuna ri vubuk pise taasaxa piau ta mataa fe timin ta ma laaꞌui xuluna. ");
INSERT INTO leu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nari, mu rabuna ina kaalum votai, ri ulaa xe sina mu memai priis e mu Ferasi e ri fin nari, “Ai, xenaso mi pife lisanmaan na Yesus?” ");
INSERT INTO leu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","E mu rabuna ina kaalum votai ri sui nari, “Piau ta mataa xa fe ferawai malaan sena mataa aapave taxa ferawai.” ");
INSERT INTO leu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","E mu Ferasi ri xuus nari, “E nami sait nane fo familung nami? ");
INSERT INTO leu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Naak, ta saxa matalava sitaara o ta saxa Ferasi fo namkai sena? Piau! ");
INSERT INTO leu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Taasaxa malila aanabeꞌ ri pife texaas faroxo sena Vuputkai sitaara e nari xo, a kuus fatutulan taxa waan xuluri.” ");
INSERT INTO leu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","E na Nikodimaas aava fo savat xe si Yesus paamua, nane a saxa siri e a xuus nari malaan, ");
INSERT INTO leu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Naak, a vuputkai sitaara i taxa timin a fakasanaman xuluna mataa paamuina yaan i taa savat la tiisan, la yaan i taa kuusan fasavat a so ta mo nane taxa vile?” ");
INSERT INTO leu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","E ri suie, “Nano vaxa, nano ti Galili, bo? Kaalum lana xakalayan sitaara e no taa masam o piau ta mataa ina kuus fatuxai i taa savat ti pe Galili.” ");
INSERT INTO leu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","E nari xapiak ri ulaa xe la lifu siri saxa saxa. ");
INSERT INTO leu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Taasaxa na Yesus fe laak xe xuluna Put Olif. ");
INSERT INTO leu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","La paanen lolof nane sivi e fe laak fulaa xe lana tang lifu lotu. A maana rabuna xaves ri savat xe sina e nane nai e tangpat pana fapitiaan nari. ");
INSERT INTO leu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","A mu rabuna ina fepitaa pana mu vuputkai e mu Ferasi ri lisanmaan a saxa tefin tamai aava ri fo yote layaan i taxa mati xuvul pana saxa mataa patak. Ri fatigineie la palou iri e na Yesus ");
INSERT INTO leu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","e ri xuuse, “Mataa ina Fepitaa, a tefin aanabeꞌ maam tingine layaan nane taxa mati xuvul pana saxa mataa patak. Layaan re taxa vilai fasaat. ");
INSERT INTO leu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Lana mu vuputkai, na Moses a kuus o taara taa punuk a lutefin malaan pana soxoiaan nari pana faat. Nano, no kuus malaafaa?” ");
INSERT INTO leu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ri xuuse malaan xena tafangaana senaso rao ri taa tiise sena ferawaian sina. Taasaxa na Yesus a sonai suꞌ e taxa kala la xavala pana vipirigum ina mana. ");
INSERT INTO leu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Layaan ri taxa lo fine, nane tamasiak e xuus nari, “Lavaxa, naseꞌ la palou imi aava pi fafaasaal, nane fexaxaas sena soxoin paamuin a faat sina.” ");
INSERT INTO leu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","E nane sonai suꞌ fulaa e kala la xavala. ");
INSERT INTO leu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Layaan ri langaie nari saxa saxa ri taꞌulane, nari mu vaiak paamua e nari xapiak lamiri. E ri falet xe lamalei e na Yesus narie na tefin re taxa lo waan pave. ");
INSERT INTO leu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Na Yesus a tamasiak e xuuse, “Tefin, faa nari? Piau ta mataa taxa tiis nano?” ");
INSERT INTO leu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","E nane kuus, “Matalava, piau ta saxa.” E na Yesus a xuuse, “Nenia vaxa, ne taa pife tiis nano. Falet xo e muta poxo fulaa.” ");
INSERT INTO leu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Mui fulaa na Yesus a kuus xe siri, “Nenia, ne malang xana maana rabuna xapiak la xavala. Naseꞌ aava usiau, i taa pife sangas la suk taasaxa i taa toxan a malang ina toyan.” ");
INSERT INTO leu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A mu Ferasi ri tisuie, “Nano, no taxa kuus xakaavang sema fatak. A kuusan siim pife tuuna.” ");
INSERT INTO leu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Na Yesus a sui nari, “Tamo ne kuus xakaavang sega fatak a kuusan siak a tuuna senaso ne texaas sena fufubina siak e ne texaas o nenia, ne taa falet xe faa. Taasaxa nami, mi pife texaas o laso ta bina ne filimaan ti lana o laso ta bina ne taxa falet xe lana. ");
INSERT INTO leu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mi taxa titiis pana lalamonan sina mataa mon; nenia, ne pife tiis ta saxa mataa. ");
INSERT INTO leu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Tamo ne taa titiis, a tiisan siak i taa tuuna senaso pife nenia sang mon ne taxa vile. Na Tamaang aava fengau, taxa waan xuvul paga. ");
INSERT INTO leu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lana mu vuputkai simi fo xaleian malaan: a kuus xakaavangan sina ro mataa taragua a tuuna. ");
INSERT INTO leu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Lavaxa nenia, ne saxa aava ne taxa kuus xakaavang sega fatak, a xasafuna aava i taxa kuus xakaavang sega ve na Tamaang aava fengau.” ");
INSERT INTO leu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","E nari, ri fine, “E na tamaam faa?” Na Yesus a sui nari, “Mi pife texaas sega e se Tamaang. Tamo mi texaas sega mi taa texaas sena Tamaang sait.” ");
INSERT INTO leu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nane kuus pana ferawaian aanabeꞌ layaan nane waan lana bina ina faxuvulaana tatavai la tang lifu lotu pave la fena fepitaian sina e piau ta mataa fe pise senaso a yaan sina pife savat lunai. ");
INSERT INTO leu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nane xuus fulan nari, “Nenia, ne taa paan patak e mi taa sengau taasaxa mi taa maat lapaana vilaana saat simi. A bina ne taa falet xe lana mi pife fexaxaas sena laak lana.” ");
INSERT INTO leu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A mu Juda ri fefiai, “A sou, i taa punuk nane xa, senaso nane taxa kuus, ‘A bina ne taxa falet xe lana mi pife fexaxaas sena laak lana.” ");
INSERT INTO leu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nane xuus nari, “Nami, mi mu rabuna ti lapia; nenia, ne ti laaꞌui. Nami, mi maana mo ti nabeꞌ la xavala; nenia, ne pife mo ti nabeꞌ la xavala. ");
INSERT INTO leu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","E voxo nabeꞌ a fufuna ferawaian siak xe simi o mi taa maat lapaana faasaalan simi; tamo mi pife namkai o nenia, ne Saxa aava molava, mi taa femaat lapaana mu vilaana saat simi.” ");
INSERT INTO leu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Lavaxa, ri fine, “E nano naseꞌ?” Na Yesus a xuus nari, “Ne fo xuus faxavesan nami xo! ");
INSERT INTO leu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ne toxan a mo xaves paaliu xena kuusanaana e xena tiisaan nami, taasaxa nane aava fengau, nane fatak a Tuunayan e a maana mo xapiak nane xuusau pana, ne taxa kuusane xe simi maana rabuna ti la xavala.” ");
INSERT INTO leu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nari, ri vungut o nane taxa ferawai xe siri pa Tamana. ");
INSERT INTO leu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Na Yesus a kuus, “Layaan mi taa siak fati a Natuna Mataa, lavaxa mi taa texaas o nenia, ne Saxa aava molava e vaxa ne pife vil ta saxa mo lapaana gutan siak, taasaxa ne taxa ferawai pana so ta mo na Tamaang fo fapitiau pana. ");
INSERT INTO leu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","E nane aava fengau i taxa waan xuvul paga. Nane pife taꞌulanau e ne fenakmaal, piau. Senaso ne taxa vil vulan a maana mo xena fafaamamaase.” ");
INSERT INTO leu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","E layaan nane taxa ferawai lunai a rabuna xaves ri namkai tapang sena. ");
INSERT INTO leu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Na Yesus a xuus nari mu rabuna Juda aava ri fo namkai tapang sena, “Tamo mi vubuk waan fefeng tuuna siak mi taa sangas vulai lapaana ferawaian siak; ");
INSERT INTO leu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","vil malaane e mi taa taraxali a tuunayan e voxo a tuunayan aave i taa mulus nami.” ");
INSERT INTO leu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ri suie, “Nemaam, maam mu bu Abrahem e maam pi taagul malaan sena yaasok sinꞌ ta xasa mataa. Malaafaa no taxa kuus o maam taa mulusan?” ");
INSERT INTO leu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Na Yesus a xuus fulan nari, “Tuuna paaliu ne xuus nami, naseꞌ ta mataa a faasaal, nane ve a sisiak sina faasaalan. ");
INSERT INTO leu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","A yaasok sina mataa a pife waan tuuna lana pabung sina mataa aave taasaxa, a natuna ve taxa waan la pabung sina vulai. ");
INSERT INTO leu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","E voxo tamo a Natuna taa mulus nami, a tuuna mi fo mulusan. ");
INSERT INTO leu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ne texaas o nami, mi mu bu Abrahem, taasaxa nami, mi vubuk punuxau senaso mi piau ta nobina la xunus imi xana ferawaian siak. ");
INSERT INTO leu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nenia, ne taxa kuus pana so ta mo ne fo xalume se Tamaang, taasaxa nami, mi taxa lo vil a so ta mo na tamami fo xuus nami pana.” ");
INSERT INTO leu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ri suie, “Na Tamamaam ve na Abrahem!” Na Yesus a xuus nari, “Tamo mi mu rafulak si Abrahem, naak, mi taa usi a vilaana si Abrahem, bo? ");
INSERT INTO leu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nenia, ne fo kuusan a tuunayan aava ne langaie sina Piran e mi taxa seng ta salan xena punuxau, na Abrahem a pife vil malaane. ");
INSERT INTO leu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nami, mi taxa usi a vilaana si tamami.” E ri suie, “Muneta lamon o maam piau ta pabung! A Piran sang mon a Tamamaam e Memai simaam.” ");
INSERT INTO leu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Na Yesus a xuus nari, “Tamo Piran a Tamami, mi taa vubuxanau senaso ne fo filimaan sina Piran e naboxo ne taxa waan nabeꞌ. Ne pife savatmaan lapaana gutan siak taasaxa nane fo fengau. ");
INSERT INTO leu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Xenaso mi pife masam a lagasai siak? Naak, mi pife fexaxaas sena langai a mo ne taxa kuusane, bo? ");
INSERT INTO leu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mi fo savat ti la bina si tamami, na Setan, e voxo mi vubuk vil a maana mo aava nane xuus nami pana. Paamua paaliu ti la tangpat, nane a mataa ina ngaapunuk. E nane pife fexaxaas sena tigina lana kuus tuunayan senaso a piau paaliu ta tuunayan. Layaan nane taxa kuus bit i taxa ferawai lana pok bina sina senaso nane a mataa vibit e na tamana maana bitan xapiak. ");
INSERT INTO leu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nami, mi pife fexaxaas sena namkai sega senaso ne taxa ferawai pana tuunayan mon. ");
INSERT INTO leu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","A fexaxaas ta saxa imi i taa tiisau pana so ta faasaalan? Tamo ne taxa kuus tuuna sang mon, xenaso mi pife namkai sena ferawaian siak? ");
INSERT INTO leu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Naseꞌ sina Piran ve i taa langai a ferawaian sina Piran. A fufuna lamavaangan simi ve a malaan: mi pife rabuna sina Piran!” ");
INSERT INTO leu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A mu matalava Juda ri xuuse, “Naak maam taxa ferawai fatak, bo? Nano, no saxa Sameria e a vovau saat fo vao nano, bo?” ");
INSERT INTO leu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Na Yesus a sui nari, “Piau ta vovau saat fe vawau, taasaxa ne suaian na Tamaang e mi pife suaian nenia. ");
INSERT INTO leu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ne pife seng ta isin lava paga fatak; a toxan a xasafuna falak ve taxa senge e nane ve a saxa ina tiisan. ");
INSERT INTO leu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ne xuus tuunei nami, layaan ta mataa i taa usi fatak a ferawaian siak a maatan i taa pife siaxe.” ");
INSERT INTO leu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","E nari mu matalava Juda ri xuuse, “Naboxo maam texaas tuuna o a vovau saat fo vao nano. Na Abrahem fo maat e vaxa mu rabuna ina kuus fatuxai sait e nano, no taxa kuus o tamo ta mataa taa usi fatak a ferawaian siim a maatan i taa pife siaxe? ");
INSERT INTO leu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Naak, nano, no matalava se tamamaam, na Abrahem aava fo maat? A mu rabuna ina kuus fatuxai vaxa ri fo maat. No lamon o nano naseꞌ, no xali nano paseꞌ?” ");
INSERT INTO leu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Na Yesus a sui nari, “Tamo nenia fatak mon ne taxa siak fati a isaak, a isin lava siak a mo palau. Na Tamaang aava mi kuus o a Piran simi, nane ve i taxa siak fatiau. ");
INSERT INTO leu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mi pife texaas sena taasaxa nenia, ne texaas sena. Tamo ne taa kuus o ne pife texaas sena, nenia, ne taa mataa vibit malaan semi, taasaxa piau. Ne texaas sena e ne sasangas vulai lapaana ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Na tamami, na Abrahem, a faamamaas layaan a xalum a yaan siak, nane fo xalume e taxa nanam.” ");
INSERT INTO leu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A mu matalava Juda ri xuuse, “A sou, no pife mariaas sangafilu pama lunai e no fo xalum na Abrahem, bo?” ");
INSERT INTO leu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Na Yesus a xuus nari, “A tuuna paaliu, ne xuus nami: paamuina luluuxan si Abrahem nenia, ne fo waan!” ");
INSERT INTO leu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","E fataapus ri siak a mu faat xena soxoiaana taasaxa na Yesus a fufunai xaseri e nane taꞌulan a tang lifu lotu. ");
INSERT INTO leu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na Yesus e mu fefeng sina ri taxa sangaset e nane xalum a saxa mataa matana piif ti la yaan ina luluuxan. ");
INSERT INTO leu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","E mu fefeng ri fin na Yesus, “Ai Mataa ina Fepitaa, naseꞌ fo faasaal, a mataa aanabeꞌ o na ninana nare tamana e voxo nane maa luxan pana matana piif?” ");
INSERT INTO leu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Na Yesus a sui nari, “A mo aanabeꞌ pife savat sena faasaalan sina o si ninana nare tamana, piau. Nane fo luxan malaan talo Piran i taa faxalit a gutan sina sena. ");
INSERT INTO leu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Layaan a bina taxa paanaas lunai taara taa vil a maana faisok sina saxa aava fengau. A vung i taxa filimaan e piau ta saxa a fexaxaas sena faisok. ");
INSERT INTO leu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Layaan nenia, ne taxa waan la xavala, nenia xa ne malang xana mu rabuna la xavala.” ");
INSERT INTO leu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Layaan nane fo ferawai malaan nane kaanus xuluna xavala e vesan a fomirak ruruveak e timine la ro matana mataa aave ");
INSERT INTO leu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","e xuuse, “Falet e no fe suf la Raarum ti Siloam (a malasuf ina vapaling, siloam ve: fengan).” E voxo nane falet e fe susuuf e layaan nane ulaa nane fexaxaas sena kaalum. ");
INSERT INTO leu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","A mu rabuna aava ri fuuna taagul faasilak sena e nari aava ri fo xalume paamua layaan fuuna taaxanak xolai, ri kuus, “Ai, a mataa aanabeꞌ mon ve fuuna lo taaxanak, bo?” ");
INSERT INTO leu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Saxanufuna ri kuus, “Aang” e xasanofuna ri kuus, “Piau, nane kaalum fexaxaas malaan sena mon.” Taasaxa nane fatak a kuus, “Nenia move!” ");
INSERT INTO leu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","E ri fine, “A ro mataam, re talakas malaafaa?” ");
INSERT INTO leu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Nane sui nari, “A mataa ri xalie pa Yesus, nane vesan a ruruveak e timine xuluna ro mataak e xuusau, ‘Falet e no fe suuf pave Siloam.’ E voxo ne falet xe pave e ne fe susuuf e naboxo ne fexaxaas sena kaalum.” ");
INSERT INTO leu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","E ri fine, “E faa ta mataa aave?” Nane sui nari, “Ne pife texaas.” ");
INSERT INTO leu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ri lisan et a mataa aava fo mo piif xe sina mu Ferasi. ");
INSERT INTO leu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Senaso la yaan aava na Yesus a vesan a ruruveak e vil fatalakas a matana mataa aave ve la Yaan ina Fangaafusan. ");
INSERT INTO leu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","E nari mu Ferasi ri fin fulane o malaafaa nane fexaxaas sena kaalum. E nane xuus nari, “Nane timin a ruruveak xuluna ro mataak e ne fe suuf e naboxo ne fexaxaas sena kaalum.” ");
INSERT INTO leu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Saxanu Ferasi ri kuus, “A mataa aava vil malaane ve, pife sina Piran senaso nane pife usi a vuputkai ti la Yaan ina Fangaafusan.” E saxanofuna ri kuus, “A fexaxaas vaxa saxa mataa saat i taa vil a mo faꞌipul malaan?” E ri fegagelai xolai sena. ");
INSERT INTO leu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ri fin fulan a mataa aava fo mo piif, “No kuus malaafaa sena mataa aapave, senaso no kuus o nane fo fatalakas a ro mataam?” E nane kuus, “Nane a mataa ina kuus fatuxai.” ");
INSERT INTO leu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","A mu matalava Juda xaves ri pife namkai sena ferawaian sina layaan nane kuus o nane fo mo piif e naboxo nane fexaxaas sena kaalum. E voxo ri xel na ninana nare tamana, ");
INSERT INTO leu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","e ri fin nare, “A lak sime nabeꞌ bo? Me kuus o nane piif ti la yaan ina luluuxan, bo? Malaafaa nane fexaxaas sena kaalum naboxo?” ");
INSERT INTO leu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Na ninana nare tamana re kuus, “Maame texaas o nane a natumaame e vaxa nane piif ti la yaan ina luluuxan. ");
INSERT INTO leu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Taasaxa maame pife texaas malaafaa nane fexaxaas sena kaalum naboxo o naseꞌ fo kas a ro matana. Nane a matalava, fine; nane fexaxaas i taa ferawai pana fatak.” ");
INSERT INTO leu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nare, re kuus malaan senaso re matautan a mu matalava Juda. Nari mu matalava Juda ri fo turoxo o tamo ta mataa taa kuus o na Yesus ve a Mataa Failai, lavaxa ri taa ti votan a mataa aave i muta laak lana mu lifu ina faxuvulan. ");
INSERT INTO leu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Malaan e na ninana nare tamana ri kuus o fine suꞌ senaso nane a matalava. ");
INSERT INTO leu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","La yaan naang xa, ri xel fulan a mataa aava fo mo piif. E ri xuuse, “Kuus tuuna. Maam texaas o a mataa aave a mataa ina faasaalan.” ");
INSERT INTO leu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nane sui nari, “Ne pife texaas tamo nane a mataa fafaasaal o piau. Saxa mo ne texaas sena ve, nenia ne luxan pana mataak a piif e naboxo ne fexaxaas sena kaalum.” ");
INSERT INTO leu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","E ri fin fulane, “A so ta mo nane fo vile sema? Malaafaa nane fo fatalakas a mataam?” ");
INSERT INTO leu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nane sui nari, “Ne fo xuus nami pana e mi langai pesalai. Xenaso mi buk langai fulane? Naak nami vaxa, rao mi savat fefeng sina sait?” ");
INSERT INTO leu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","E ri sei pengane, “Nano, no fefeng sina, taasaxa nemaam, maam mu fefeng si Moses. ");
INSERT INTO leu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Maam texaas o a Piran fo ferawai xe si Moses, taasaxa mataa aanabeꞌ maam vungut sena so ta bina nane filimaan ti lana.” ");
INSERT INTO leu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","A mataa aave a sui nari, “Ai, a mo faꞌipul nabeꞌ, nami, mi vungut o nane filimaan ti faa taasaxa nane xo, fo fatalakas a mataak. ");
INSERT INTO leu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Taara texaas o a Piran i taa pife langai a mu rabuna saat, taasaxa naseꞌ ta mataa i taa suaian fatak a Piran e i taxa usi a vubuxanan sina, a Piran i taa langai a mataa malaan. ");
INSERT INTO leu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Taara pi lalangai maan ti paamua xa pana saxa mataa fo vil fatalakas a matana mataa aava fo luxan pana matana piif. ");
INSERT INTO leu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","A mataa aanabeꞌ a savat sina Piran, tamo piau, nane pife fexaxaas sena vil ta saxa mo!” ");
INSERT INTO leu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","E nari, ri suie, “Nano, no fo taagul lapaana vilaana saat ti la yaan ina luxaan nano, malaafaa no taxa lamon o no fexaxaas sena fapiti nemaam?” E ri ti votane i muta laak lana mu lifu ina faxuvulan. ");
INSERT INTO leu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Na Yesus a langai o nari, ri fo ti votan a mataa aave e layaan nane tingine, a fine, “Nano, no namkai sena Natuna Mataa?” ");
INSERT INTO leu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","E nane suie, “Ai, Matalava, nane naseꞌ? Xuusau talo ne taa namkai sena.” ");
INSERT INTO leu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Na Yesus a xuuse, “No fo xalume. Nane xo, i taxa ferawai xuvul pama.” ");
INSERT INTO leu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nane kuus, “Matalava, ne namkai.” E nane tapiit turung faasilak la ka Yesus. ");
INSERT INTO leu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Na Yesus a kuus, “Ne sivimaan xe nabeꞌ la xavala xena tiisaana mu rabuna talo nari aava ri piif ri taa kaalum e nari aava ri xakaalum, ri tafe piif.” ");
INSERT INTO leu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","E saxano Ferasi aava ri taxa waan xuvul pana, ri langaie e ri fine, “Nemaam vaxa, maam piif?” ");
INSERT INTO leu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Na Yesus a xuus nari, “Tamo mi rabuna piif, mi taa pife vupuno. Taasaxa mi fo kuus o mi fexaxaas sena kaalum e voxo mi taxa vupuno lunai. ");
INSERT INTO leu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“A ferawaian aanabeꞌ a tuuna, a mataa aava pife laak la matana vaafa xe lana nobina ina mu sipsip taasaxa nane fani a vaafa o laak la xasano bina patak, nane ve a mataa ina fenau e a saat. ");
INSERT INTO leu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","A mataa aava laak la matana bina, nane ve a mataa tuuna ina faxatang a mu sipsip. ");
INSERT INTO leu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","A mu rabuna ina faxatang a nobina aapave ri taa kas a matana vaafa xe sina. E mu sipsip sina ri fuuna langai taraxali a lingina. Nane fuuna xel a mu sipsip sina pana isiri saxa saxa e fuuna lisan nari xe lamalei. ");
INSERT INTO leu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","E layaan nari xapiak ri fo waan lamalei nane fuuna sangas paamuian nari. E mu sipsip sina ri usie senaso ri texaas sena lingina. ");
INSERT INTO leu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Taasaxa ri taa pife usi a mataa patak, piau. Ri taa sinufane senaso ri pife langai taraxali a lingina.” ");
INSERT INTO leu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Na Yesus a xuus nari pana ferawaian paap aanabeꞌ taasaxa ri pife masam sena mo aava nane vubuk fapiti nari pana. ");
INSERT INTO leu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","E voxo na Yesus a kuus fulaa, “Ne xuus tuunei nami, nenia ve ne matana bina sina mu sipsip. ");
INSERT INTO leu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nari xapiak aava ri savat paamu sega ri mu rabuna ina fenau e nari aava ri fuuna famataut a mu rabuna xena siak palou a maana mo siri, taasaxa nari mu sipsip ri pife langai nari. ");
INSERT INTO leu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nenia, ne matana bina e ne yalaxau; tamo ta mataa taa laak lapaaga i taa fakaxupan e nane fexaxaas sena laak e sivi e i taa tingin a fanganan roxo. ");
INSERT INTO leu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","A mataa ina fenau a filimaan mon xena fenau, ngaapunuk, e ngaagalas. Nenia xo, ne fo savat xena tavai a mu rabuna pana toyan e ri taa bas paaliu marasaxa pana. ");
INSERT INTO leu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nenia, ne mataa roxo ina faxatang a mu sipsip. A mataa roxo ina faxatang i taa lisan a tana xena xavang a mu sipsip naapalaan a so ta mo taa savat sina. ");
INSERT INTO leu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","A sisiak mon pife mataa ina faxatang a sipsip o mataa tafuna sipsip e layaan a mo saat malaan sena piu vupung i taa savat, nane i taa sinuf tapin a mu sipsip. E a piu vupung aave i taa xup fepatoxan a mu sipsip e taa xet punuk a saxanofuna. ");
INSERT INTO leu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A sisiak aave i taa vil malaane senaso nane taxa faisok xena siak faat mon e pife muluk temasaatan a mu sipsip. ");
INSERT INTO leu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Nenia xo, ne mataa roxo ina faxatang a mu sipsip; ne texaas sena mu sipsip siak e nari, ri texaas sega, ");
INSERT INTO leu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","malaan seꞌ nenia, ne texaas se Tamaang e nane texaas sega. E ne taxa lisan a toyan siak xana mu sipsip siak. ");
INSERT INTO leu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ne toxan a xasano sipsip sait e ri pife waan lana tagaan aanabeꞌ. Ne taa lisanmaan nari sait senaso ri taa langai a lingaak. E i taa toxan a tagaan saxa mon lapaana mataa saxa xena faxatang nari. ");
INSERT INTO leu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na Tamaang a vubuxanau senaso ne taa lisan a toyan siak talo ne taa siak faꞌulie. ");
INSERT INTO leu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Piau ta mataa i taa siak tapin a toyan siak, piau. Nenia fatak xa, ne turoxo pana. Ne toxan a gutan fexaxaas xena lisan a toyan siak e ne toxan a gutan fexaxaas xena siak faꞌulie vaxa. A mo aanabeꞌ na Tamaang a xuusau o ne taa vile.” ");
INSERT INTO leu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","E mui nari mu Juda ri fetok faagut sena ferawaian sina. ");
INSERT INTO leu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xaves ri kuus, “Nane toxan a vovau saat fo vawe e vil fangonge. Mi taxa langaie xenaso?” ");
INSERT INTO leu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Saxanofuna ri kuus, “Ai, a ferawaian aanabeꞌ pife ferawaian sina mataa pana vovau saat. A vovau saat vaxa fexaxaas sena vil fatalakas a matana mataa piif? Piau!” ");
INSERT INTO leu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","A Fenamo ina Kasaana Lifu (o a Fenamo ina Malang) a savat pe Jerusalem. A bina xo vutung. ");
INSERT INTO leu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","E na Yesus taxa sangas pe la nobina lana tang lifu lotu aava ri xalie pana ‘Veraanda’ si Solomon. ");
INSERT INTO leu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","E mu matalava Juda ri fakaliuane e ri fine, “Maam taa waan vungut sema fefexaxaas a so ta yaan? Tamo nano, no Mataa Failai no xuus famatavas nemaam.” ");
INSERT INTO leu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","E na Yesus a sui nari, “Ne fo xuus nami, taasaxa mi pife namkai sega. A maana mo ne faisoxan nari lapaana isi Tamaang, nari vaxa ri kuusan fasavatau sait. ");
INSERT INTO leu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Taasaxa nami xo, mi pife namkai sega senaso mi pife sipsip siak. ");
INSERT INTO leu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","A mu sipsip siak ri fuuna langai a lingaak, ne texaas seri e ri fuuna usiau. ");
INSERT INTO leu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ne tavai nari pana toyan xe vulai e nari, ri taa pife maat e piau ta mataa a fexaxaas sena paxai tapin nari ti lana maak. ");
INSERT INTO leu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na Tamaang a molava sena maana mo xapiak e a mu rabuna nane fo tavaiau pana, piau ta saxa a fexaxaas sena paxai tapin nari ti la ma Tamaang. ");
INSERT INTO leu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na Tamaang e nenia maame saxa.” ");
INSERT INTO leu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","A mu Juda ri siak faat fulaa xena soxoiaana pana. ");
INSERT INTO leu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","E na Yesus a fin nari, “Ne fo faxalit nami pana mu fakalimaanan roxo aava filimaan sina Tamaang. A so ta fakalimaanan ve rao mi soxoiau pana faat sena?” ");
INSERT INTO leu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","A mu Juda ri suie, “Piau, pife sena fakalimaanan roxo maam taa soxoi nano pana faat, taasaxa no ferawai fasaat sena Piran aava taap. E vaxa nano, no mataa mon e no taxa xali nano xa o no fexaxaas malaan sena Piran. A mo aanabeꞌ ve a fufuna soxoiaan nano.” ");
INSERT INTO leu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","E na Yesus a xuus nari, “Saxa xakalayan lana mu vuputkai simi a malaan, bo? ‘Nenia, ne fo kuus o nami, mi mu piran’ ");
INSERT INTO leu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nane xali nari aava ferawaian sina Piran a savat xe siri, pana mu piran. E mi pife fexaxaas sena vis tapin a ferawaian sina Piran, bo? ");
INSERT INTO leu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","E naboxo xe sina mataa aava Piran fo bure e fo fenge xe la xavala, naboxo mi xuuse o ‘No ferawai fasaat sena Piran aava taap’ senaso ne kuus o ‘Nenia ne Natuna Piran?’ ");
INSERT INTO leu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tamo ne pife vil a faisok sina Tamataara, lavaxa muta namkai sega. ");
INSERT INTO leu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Taasaxa layaan ne taxa vil a faisok sina, naapalaan mi bai namkai sega, namkai sena mu faisok senaso a mu faisok aave ri taxa faxalit nami e fatexaas nami o na Tamataara taxa waan xulok e ne taxa taagul lapaa Tamataara.” ");
INSERT INTO leu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","E fulaa rao ri saxame taasaxa nane sinuf seri. ");
INSERT INTO leu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Na Yesus a ulaa fulaa e fe paaliu a Raarum Jordan xe la bina aava na Jon tamu fasuf a rabuna lana e fe taagul pave. ");
INSERT INTO leu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","E a rabuna xaves ri savat xe sina e ri kuus, “Na Jon a pife vil ta saxa mo ina fakalimaanan taasaxa maana mo xapiak aava na Jon fo kuusane sena mataa aanabeꞌ, ri tuuna.” ");
INSERT INTO leu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","E a mu rabuna xaves ti la bina aave ri namkai sena. ");
INSERT INTO leu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","A toxan a mataa a isina na Lasarus, i taxa giis e nane ve ti Betani, a bina si Maria narie tina na Marta. ");
INSERT INTO leu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Na Maria aave mon ve, mo tiuan a mo musung roxo la ka Yesus e saf fapigalipe pana fui sina e na vasaana, na Lasarus ve, taxa giis. ");
INSERT INTO leu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","E ro fetinan aave re lisan a lagasai xe si Yesus e re xuuse, “Matalava, a fesing siim taxa giis.” ");
INSERT INTO leu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Layaan na Yesus a langai sena nane kuus, “A giisan aanabeꞌ i taa pife taxapus lana mamaat. Taasaxa giisan aanabeꞌ fo savat xena faxalit a gutan sina Piran e fulaa xena vil famalang a Natuna Piran pana.” ");
INSERT INTO leu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Na Yesus a vubuxan xasingit na Marta e na tina e na Lasarus. ");
INSERT INTO leu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Taasaxa layaan nane langai o na Lasarus taxa giis, nane taagul suꞌ la nobina aapave pana yaan taragua fulaa, ");
INSERT INTO leu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","e mui nane xuus a mu fefeng sina, “Taara taa sangas ulaa xe Judia fulaa.” ");
INSERT INTO leu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","E mu fefeng ri xuuse, “Mataa ina Fepitaa, piau ta yaan xaves feliu lunai layaan a mu matalava Juda ri tafang pana soxoiaan nano pana faat e rao no ulaa xe pave fulaa?” ");
INSERT INTO leu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Na Yesus a sui nari pana ferawaian aanabeꞌ, “A ngaas fuuna waan pana awa sangafilu saxa pana taragua mon, bo? Layaan a mataa taa sangas xolai la matavas i taa pife poxo senaso nane fexaxaas sena kaalum lana malang ina ngaas. ");
INSERT INTO leu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Taasaxa, tamo ta mataa taa sangas xolai la vung nane taa kalaxoi senaso nane piau ta malang xena kaalum.” ");
INSERT INTO leu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nane kuus malaan e mui a xuus nari, “A fesing sitaara, na Lasarus, i taxa matef maat, taasaxa nenia, ne taa falet xe pave xena faparayaana.” ");
INSERT INTO leu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Taasaxa mu fefeng ri xuuse, “Ai Matalava, nane i taa roxo tamo i taxa matef.” ");
INSERT INTO leu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Taasaxa na Yesus taxa ferawai pana maatan sina e ri lamon o nane taxa ferawai pana matefan mon. ");
INSERT INTO leu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","E na Yesus a xuus famatavas nari, “Na Lasarus fo maat! ");
INSERT INTO leu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","E a mo roxo nenia, ne pife waan pave senaso ne vubuk xavang a namkaian simi. Taara taa falet xe pave.” ");
INSERT INTO leu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","E voxo na Tomas, a xasa isina na ‘tauna lua’, a xuus a xasano fefeng, “Lavaxa, taara xapiak taa falet vaxa talo taara taa femaat xuvul pana.” ");
INSERT INTO leu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","La yaan na Yesus a savat pave, ri xuuse o ri fo timin na Lasarus lana liing ina mamaat e a yaan talafaat fo liu xuluna. ");
INSERT INTO leu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","A bina Betani ve waan faasilak se Jerusalem, malaan sena kilomita talatul mon. ");
INSERT INTO leu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","E a mu rabuna Juda xaves ri maa savat si Marta narie Maria xena famalulum nare sena maatan si vasaare. ");
INSERT INTO leu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Layaan na Marta xo, a langai o na Yesus taxa filimaan nane falet xena fesuaiane, taasaxa na Maria a waan suꞌ pave lana lifu. ");
INSERT INTO leu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Na Marta a xuus na Yesus, “Memai, naak tamo no waan nabeꞌ na vasaak i taa pife maat. ");
INSERT INTO leu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","E ne texaas o monabeꞌ mon a Piran taa tavai nano pana so ta mo no taa fenung xe sina pana.” ");
INSERT INTO leu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Na Yesus a xuuse, “Na vasaam i taa tamasiak faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","E na Marta a suie, “Ne texaas o i taa tamasiak faꞌulaa lana To Faꞌulaian la Yaan Fataxapiak.” ");
INSERT INTO leu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Na Yesus a xuuse, “Nenia ve ne To Faꞌulaian e ne Toyan Tuuna. Naseꞌ aava namkai sega, naapalaan a maat, i taa to. ");
INSERT INTO leu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","E ta mataa aava i taxa to e i taxa namkai sega, a mataa aave i taa pife xalum a maatan. Nano, no namkai sena ferawaian aanabeꞌ?” ");
INSERT INTO leu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","E nane suie, “Aang Memai, ne namkai o nano, no Mataa Failai, no Natuna Piran, nane aava i taa savatmaan xe la xavala.” ");
INSERT INTO leu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Layaan nane kuus malaan nane falet e fe xel na tina, na Maria e a xuuse, “A Mataa ina Fepitaa fo savat e taxa xel nano.” ");
INSERT INTO leu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Layaan na Maria a langai malaan nane tamasiak fataapus e falet xe sina. ");
INSERT INTO leu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Na Yesus a pife laak lana bina lunai taasaxa nane taxa waan xa la nobina aava na Marta fo fesuaiane lana. ");
INSERT INTO leu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","La yaan aave saxano rabuna Juda ri taxa waan xuvul pa Maria lana lifu e ri taxa fetaangiis xuvul pana e ri xalum nane tamasiak fataapus e falet xe lamalei. E ri usie senaso ri lamon o i taa paan xe la bina ina mamaat xena taangiis pave. ");
INSERT INTO leu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Layaan nane savat si Yesus nane poxo la kana e xuuse, “Memai, naak tamo no waan nabeꞌ na vasaak i taa pife maat.” ");
INSERT INTO leu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na Yesus a xalum na Maria taxa taangiis e a mu rabuna Juda aava ri savatmaan xuvul pana vaxa ri taxa taangiis. E a xunus ina nasam a mamaxusan e a vovau ina piau ta luaian. ");
INSERT INTO leu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","E a fin nari, “Mi fo timine faa?” E ri suie, “Matalava, filimaan xuvul pamaam e no taa xalume.” ");
INSERT INTO leu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","E na Yesus a taangiis. ");
INSERT INTO leu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Nari mu rabuna Juda ri ferawai sena, “Kaalum, nane vubuxan xasingite.” ");
INSERT INTO leu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Taasaxa saxanofuna iri, ri piile, “Nane fo kas a matana mataa piif; a sou pife fexaxaas sena ti votan a mataa aanabeꞌ sena maatan?” ");
INSERT INTO leu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Na Yesus nari, ri fe savat la bina ina mamaat e fulaa a xunus i Yesus a mamaxus. A bina ina mamaat sina mataa aave ve a liing e ri timine lana e ri xaweie pana faat molava. ");
INSERT INTO leu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","E na Yesus a xuus nari, “Pul tapin a faat aapave.” E na Marta, a vasaana mataa aava maat, a xukulai, “Memai, nane fo maat e a yaan talafaat fo liu xuluna naboxo, i taa mafiu faagut ve.” ");
INSERT INTO leu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Na Yesus fine, “Ne fo xuus nano paamua e bo, o tamo no taa namkai sega no taa xalum a gutan sina Piran?” ");
INSERT INTO leu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","E voxo ri pul tapin a faat e na Yesus a kaalum xe laaꞌui e kuus, “Tamaang, ne kuus faasiroxo xe siim senaso no fo langaiau. ");
INSERT INTO leu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ne texaas o no fuuna langai vulanau, taasaxa xana mu rabuna xaves aanabeꞌ aava ri taxa ti langai, ne kuus malaan talo ri taa masam e namkai o nano, no fo fengau.” ");
INSERT INTO leu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","A kuus malaan e xukulai faagut, “Lasarus, savatmaan!” ");
INSERT INTO leu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","A mataa aava maat a tamasiak e savat xe lamalei pana nu mana e nu kana pisan pana marapi e a toxan a marapi la nona sait. E na Yesus a xuus nari, “Mulus tapin a marapi sena talo i taa sangas.” ");
INSERT INTO leu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","E voxo xaves sina mu rabuna Juda aava ri fo savat xena famalulum na Maria, ri xalum a mo ina gutan na Yesus fo vile e ri namkai sena. ");
INSERT INTO leu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Taasaxa saxano rabuna Juda aava ri waan pave sait ri falet xe sina mu Ferasi e ri fe xuus fatexaas nari pana so ta mo na Yesus fo vile. ");
INSERT INTO leu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","E voxo mu memai priis e mu Ferasi ri xel faxuvul a mu piran Israel xe lana Faxuvulan Lava. E ri kuus, “A mataa aanabeꞌ i taxa vil a mu fakalimaanan xaves. E taara taxa vil a so? ");
INSERT INTO leu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tamo taara taa nai fe palau sena, malaan naboxo, naak a mu rabuna xapiak ri taa namkai sena e voxo a mu Rom ri taa savat xena galas a tang lifu lotu sitaara e ri taa siak tapin a isin sitaara e a bina sitaara.” ");
INSERT INTO leu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","E saxa siri, na Kaiafas aava memai priis la mariaas aave, a xuus nari, “A texaasan simi a mo palau. ");
INSERT INTO leu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mi pife lamon o a mo roxo paaliu tamo saxa mataa i taa maat xana mu rabuna xapiak. A mo aanabeꞌ a roxo sena maana rabuna Israel xapiak ri taa maat.” ");
INSERT INTO leu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nane pife kuusan a ferawaian aanabeꞌ lapaana gutan sina fatak, taasaxa nane a memai priis la mariaas aave e voxo nane kuus fatuxai o na Yesus i taa maat xana mu rabuna Israel. ");
INSERT INTO leu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","E pife xana mu Israel mon, i taa maat xena faxuvul a maana mu rafulak sina Piran talo ri taa waan lana pabung saxa. ");
INSERT INTO leu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","E voxo la yaan aapave nari mu Juda ri lamon faagut o ri taa punuk na Yesus. ");
INSERT INTO leu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","E nane xo pife sangas fulaa la matavas la palou ina mu rabuna Juda. Taasaxa, a taꞌulan a bina aapave e falet xe la bina Efriam, faasilak la xobingil. E pave nane taagul xuvul pari aava ri fuuna usie. ");
INSERT INTO leu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","A Yaan ina Paaliuan sina mu Juda a faasilak e a rabuna xaves ri laak ti la mu bina siri xe Jerusalem paamuina fenamo xena vil tapin a lalosaat siri. ");
INSERT INTO leu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","E nari, ri taxa seng na Yesus e ri taxa fefiai la palou iri layaan ri taxa irimai lana tang lifu lotu, “Ai, mi lamon malaafaa? Naak, i taa pife savat la Fenamo aanabeꞌ, bo?” ");
INSERT INTO leu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Senaso a mu memai priis e mu Ferasi ri fo fasei a mu rabuna o tamo ta mataa a texaas o na Yesus taxa waan faa i taa xuus fatexaas nari talo ri taa fe pise. ");
INSERT INTO leu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","A yaan pisaxa paamuina fenamo na Yesus a savat pe Betani, a bina si Lasarus aava nane fo xel fatatoi faꞌulie ti la mamaat. ");
INSERT INTO leu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Narutul aave rutul faigotan a fanganan xana. Na Marta fetavai pana fanganan e na Lasarus vaxa a saxa la palou iri aava ri taxa nai xuluna ivin xuvul pana. ");
INSERT INTO leu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Na Maria a siak a fomirak vuk pana mo musung roxo lana, ri xalie pana naart e a mamareiai ina molava temasaat. E nane maa xamak a ro ka Yesus pana e mui a fapigalipe pana fui sina. A lifu aave a las faagut paaliu pana lasan roxo ina naart. ");
INSERT INTO leu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Na Judas Iskeriot, a saxa yaamut si Yesus aava i taa pet lisane, a kuus, ");
INSERT INTO leu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Xenaso a mo musung roxo aanabeꞌ, no pife faasot pana? Naak a mamareiai ina a molava sena K1,000 e mui no taa tavai a mu valagof pana!” ");
INSERT INTO leu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nane pife kuus malaan senaso nane lalamon temasaat sena mu valagof, piau. Taasaxa nane fuuna faxatang a maana faat siri e fuuna fenou a mo aava mu rabuna ri tavai nari pana. ");
INSERT INTO leu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Taasaxa na Yesus a kuus, “Muta riise! Naapalaan; i taa tao a mo musung roxo aanabeꞌ xena fasufau la yaan ina xaxaafaian siak. ");
INSERT INTO leu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","A mu valagof ri taxa waan vulai, taasaxa nenia, ne taa pife waan vulai xuvul pami.” ");
INSERT INTO leu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A mu matalava Juda xaves ri fetexaas o na Yesus taxa waan pave e a tang malila ri savat xena xalume. E pife nane sang mon ri buk xalume, ri savat xena xalum na Lasarus sait aava na Yesus fo fatatoi faꞌulie ti la maatan. ");
INSERT INTO leu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","E voxo nari mu memai priis ri fo lamon faati o ri taa punuk na Lasarus sait, ");
INSERT INTO leu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","senaso a mu rabuna Juda xaves paaliu ri taxa taꞌulan nari e ri taxa namkai se Yesus sena mo faꞌipul aava nane fo vile se Lasarus. ");
INSERT INTO leu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","A yaan lamina, a tang malila molava aava ri savat la fenamo, ri langai o na Yesus taxa sangasmaan xe Jerusalem ");
INSERT INTO leu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","e ri siak a mu paxana nunui e xasano mo e ri fe paan xena fasusuie. E ri taxa lo xukulai: “Hosaana! Fakaaxup! Nane aava i taxa savatmaan lapaana isina Piran i taa faamamaas! Faamamaasan xuluna Piran King ti Israel!” ");
INSERT INTO leu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Na Yesus a siak a ‘donki’ e nai xuluna e a savat malaan sena xakalayan a kuus pana: ");
INSERT INTO leu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Muta mataut, lak tefin ti Saion. Kaalum. A Piran King siim i taxa filimaan e nane taxa nai xuluna natuna ‘donki’.” ");
INSERT INTO leu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","A mu fefeng sina ri pife masam sena vilaana aanabeꞌ paamua, taasaxa lamina yaan na Yesus fo siak a miridingan sina, ri lamon faꞌuli a xakalayan sina mu Juda aava kuusan fasavat a mo aanabeꞌ se Yesus. E fulaa ri lamon faꞌulie o a mu rabuna pave, ri fo vil a maana mo lana kuus fatuxaian pa Yesus. ");
INSERT INTO leu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","A mu rabuna aava ri xalume layaan nane fo xel na Lasarus ti lana liing ina mamaat e fatatoi faꞌulie ti la maatan, ri kuus xakaavang sena mo aave. ");
INSERT INTO leu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","E voxo a tang malila ri falet soxote senaso ri fo langai sena mo faꞌipul aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","E mu Ferasi ri fefiaian nari, “Xalume, taara taa vil a so? A maana rabuna xapiak ri taxa usie naboxo.” ");
INSERT INTO leu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","A toxan a saxano rabuna ‘Griik’ ri taxa waan la palou ina tang malila aava ri savat xena nangus a Piran la Fenamo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","E ri savat si Filip ti Betsaida pe Galili e ri xuuse, “Matalava, maam vubuk ferawai xuvul pa Yesus.” ");
INSERT INTO leu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Na Filip fe xuus na Endru e na Endru narie Filip re fe xuus na Yesus. ");
INSERT INTO leu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nane sui narie, “A yaan fo savat naboxo, a Natuna Mataa i taa siak a isin lava. ");
INSERT INTO leu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ne xuus tuunei nami, a kam ina ‘wiit’ i taa pife xaves tamo i taa pife poxo xe lana xavala e maat. Taasaxa layaan i taa du lana xavala i taa boak e fuaa pana kam xaves. ");
INSERT INTO leu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ta mataa aava vubuxan temasaatan a toyan sina, i taa pife siak a toyan tuuna; ta mataa aava baian a toyan sina xuluna xavala aanabeꞌ, i taa siak a toyan tuuna aava i taa waan xe vulai. ");
INSERT INTO leu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tamo ta mataa rao i sisiak siak, nane i taa usi tuuneiau e a so ta bina ne taxa waan lana, a sisiak aave sait i taa waan lana. Layaan a mataa taa sisiak siak, na Tamaang taa suaiane. ");
INSERT INTO leu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Taasaxa naboxo a xunus iga a pife luai, ne taa kuus malaafaa: Tamaang, fakaxupau sena yaan aanabeꞌ? Piau! A yaan aanabeꞌ mon ve a fufuna savatan siak. ");
INSERT INTO leu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tamaang, siak fati a isaam!” E a ling a savat ti laaꞌui la xunavata e a kuus, “Ne fo siak fati a isaak paamua e ne taa siak fati fulane.” ");
INSERT INTO leu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A rabuna xaves lana malila aava ri taxa tigina pave ri langai a ling aave e ri kuus o a tang vabarak fo tuung. Saxanofuna ri kuus, “Piau, saxa angelo fo ferawai xuvul pana.” ");
INSERT INTO leu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Na Yesus a xuus nari, “A ling aanabeꞌ pife ferawaian xanak taasaxa a ferawaian xami. ");
INSERT INTO leu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","A mu rabuna xapiak ti la xavala ri taxa tigina lapaana tiisan e matalava ti la xavala aanabeꞌ i taa xup tapinan. ");
INSERT INTO leu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","E la yaan ri taa yaasau ti lapia xe laaꞌui, ne taa yuuf a maana rabuna xe siak.” ");
INSERT INTO leu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Nane kuus malaan xena faxalit nari pana so ta buk maatan nane taa siaxe. ");
INSERT INTO leu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","A rabuna lana malila ri fine, “Lana mu vuputkai a xuus nemaam o a Mataa Failai i taa waan xe vulai. Malaafaa no taxa kuus o a Natuna Mataa ri taa yaase? A Natuna Mataa aave ve naseꞌ?” ");
INSERT INTO leu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Na Yesus a sui nari, “A malang i taa waan la palou imi famodak lunai mon. E layaan mi taxa toxan lunaian a malang, sangas saa lana talo suk i taa pife xasliu nami. Nane aava sangas xolai la suk pife texaas o i taxa paan xe faa. ");
INSERT INTO leu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Layaan mi toxan lunaian a malang, namkai sena malang aave talo mi tafe savat mu rafulak sina malang.” Layaan na Yesus fo ferawai malaan nane taꞌulan nari e fe fufunai seri. ");
INSERT INTO leu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nane fo vil a maana fakalimaanan xaves la matari taasaxa ri pife namkai sena, ");
INSERT INTO leu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","e voxo a ferawaian sina mataa ina kuus fatuxai, na Aisaia, a savat tuuna. A kuus malaan: “Piran, naseꞌ fo namkai sena lagasai sitaare? E naseꞌ fo masam o a gutan sina Piran ve fo savat xo?” ");
INSERT INTO leu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ri pife fexaxaas sena namkai senaso na Aisaia a kuus fulaa: ");
INSERT INTO leu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nane fo fapiif a matari e fatavanat a lamonan siri. A vil malaane talo ri taa pife kaalum faroxo pana matari e ri taa pife lamon faroxo la xunus iri. Tamo ri taa kaalum faroxo e lamon faroxo ri tamaa taꞌulan a vilaana saat siri e ne taa vil faroxoi nari.” ");
INSERT INTO leu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Na Aisaia a kuus malaan senaso nane fo xalum a malangan si Yesus e nane taxa ferawai sena. ");
INSERT INTO leu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Lavaxa, a rabuna xaves e saxanu matalava sina mu Juda sait, ri fo namkai se Yesus taasaxa ri pife kuusane la matavas senaso ri matautan a mu Ferasi ulaa ri tamaa ti votan nari, ri muta laak lana mu lifu ina faxuvulan. ");
INSERT INTO leu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","A rabuna aave, ri lamon o a kuus faatulaian sina mu rabuna a pelalava sena kuus faatulaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Na Yesus a xukulai faagut, “Nane aava namkai sega i taa pife namkai sega sang mon, piau. Nane i taxa namkai vaxa sena Saxa aava fengau. ");
INSERT INTO leu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Layaan mi taxa xalumau, mi fo xalum sait nane aava fengau. ");
INSERT INTO leu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nenia, ne malang e ne fo savatmaan xe nabeꞌ la xavala talo mataa aava namkai sega i taa pife waan la suk. ");
INSERT INTO leu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Tamo a mataa i taa langai a ferawaian siak taasaxa a bai usie, lavaxa ne taa pife tiise senaso ne pife savatmaan xena tiis a mu rabuna la xavala, ne filimaan xena fakaxup nari. ");
INSERT INTO leu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Naseꞌ i taxa tisuiau e taxa lamavaang sena mu ferawaian siak, nane toxan a mo ina tiisaana. A mo aanabeꞌ ve a lagasai ne fo kuusane, a lagasai siak i taa tiis a mu rabuna malaan la Yaan Fataxapiak. ");
INSERT INTO leu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Muta lamon o nenia, ne taxa ferawai lapaana gutan siak fatak, piau. Taasaxa nane aava fo fengau, na Tamataara fatak, a fasei faagutanau pana so ta maana mo ne taa ferawai pana. ");
INSERT INTO leu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ne texaas o a fefasaian sina i taa fasavat a toyan vulai. Nenia, ne kuus fatak pana ferawaian aava na Tamataara fo xuusau pana.” ");
INSERT INTO leu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A yaan ina Fenamo ina Paaliuan xo, a faasilak. E na Yesus a texaas o a yaan ina taꞌulan a xavala xena ulaa xe si Tamana fo faasilak. Nane vubuxan xasingit a mu rabuna sina la xavala e naboxo i taa faxalit nari pana vubuxanan molava paaliu sina. ");
INSERT INTO leu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","3","Na Yesus a texaas o na Tamana fo tavai nane fatak pana maana mo xapiak e vaxa nane fo filimaan ti pave sina Piran e i taa ulaa fulaa xe sina. Na Setan xo, fo lamon faati o na Judas, a lak si Saimon Iskeriot, i taa pet lisan na Yesus. ");
INSERT INTO leu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Xe la vung xo, la fena fanganan, na Yesus a tamasiak e mulus a saxanu marapi sina e siak a marapi ina sasak e fai yowange pana. ");
INSERT INTO leu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","E mui a tiuan a raarum lana ‘dis’ e xamak a kana mu fefeng sina e saf fapigalip nari pana marapi aava nane fo fai yowang nane xa pana. ");
INSERT INTO leu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nane filimaan xe si Saimon Pita e na Pita fine, “Memai, rao no xamak a kaak?” ");
INSERT INTO leu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Na Yesus a suie, “A mo ne taxa vile naboxo mi pife texaas sena, taasaxa muibak mi taa masam faroxo sena.” ");
INSERT INTO leu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Na Pita xuuse, “No muta xamak a kaak!” Na Yesus a sui fulane, “Tamo ne taa pife xamak nano, no taa piau ta nobina lana faisok siak.” ");
INSERT INTO leu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","E na Saimon Pita xuuse, “Ai Memai, muta xamak a ro kaak mon, xamak a ro maak e putok sait.” ");
INSERT INTO leu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Na Yesus a xuuse, “Nane aava fo suf, i taa pife suf fulaa senaso a tana pife vusiit, taasaxa i taa xamak tapin a vusiit ti la kana mon; e nami, mi fo roxo, taasaxa, a saxa piau.” ");
INSERT INTO leu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Senaso nane fo texaas seseꞌ i taa pet lisane. E voxo nane kuus malaan o a saxa a vusiit lunai. ");
INSERT INTO leu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Layaan nane xamak xapin a mu kari, nane falak faꞌuli a marapi sina e fe nai la vepen sina xuluna ivin. E nane fin nari, “Mi masam sena mo ne fo vile semi? ");
INSERT INTO leu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mi fuuna xaliau pana ‘Mataa ina Fepitaa’ e ‘Memai’ e mi kuus tuuna senaso nenia, ne Mataa ina Fepitaa e ne Memai simi. ");
INSERT INTO leu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Taasaxa layaan nenia aava Mataa ina Fepitaa e Memai simi, ne taa xamak a mu kami lavaxa, nami sait mi taa fexamaxan a mu kami xa. ");
INSERT INTO leu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ne fo tavai nami pana saxa vilaana talo mi taa usie. A roxo nami xapiak mi taa usi a mu vilaana siak. ");
INSERT INTO leu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ne kuus tuuna, a yaasok pife lava sena mataa tafuna e a fefeng pife lava sena mataa aava fo fenge. ");
INSERT INTO leu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tamo mi masam sena fufuna mo aanabeꞌ mi taa faamamaas layaan mi taa vile. ");
INSERT INTO leu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ne pife ferawai semi xapiak, ne texaas seri aava ne fo xel nari. Taasaxa Ferawaian sina Piran aanabeꞌ i taa savat tuuna: ‘Nane aava fo fangan xuvul paga, nane ve fo paas fasiviau.’ ");
INSERT INTO leu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ne taxa xuus nami pana mo aanabeꞌ paamuina yaan i taa savat talo mi taa masam o nenia ve ne saxa aava i taa savat. ");
INSERT INTO leu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tuuna paaliu ne xuus nami, ta mataa aava i taa suaian a mataa aava ne fenge, nane ve taxa suaianau. E ta mataa aava i taxa suaianau, i taxa suaian vaxa a Saxa aava fo fengau.” ");
INSERT INTO leu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Layaan na Yesus a kuus malaan a xunus ina a nasam a mamaxusan e nane kuus, “Ne kuus tuuna paaliu, a saxa simi i taa pet lisanau.” ");
INSERT INTO leu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","A mu fefeng sina ri taxa fexalumai senaso ri vungut o nane taxa ferawai paseꞌ. ");
INSERT INTO leu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","E saxa yaamut sina, a saxa aava na Yesus a vubuxan marasaxaine, taxa nai la xasing i Yesus. ");
INSERT INTO leu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","E na Saimon Pita a kaaluf xe sina o i taa fin na Yesus o nane taxa ferawai paseꞌ. ");
INSERT INTO leu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nane fakaiak fulaa saa xe la ta Yesus e fine, “Memai, no taxa ferawai paseꞌ?” ");
INSERT INTO leu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Na Yesus a suie, “A bret aanabeꞌ ne taa sugup fadaxe lana nim aanabeꞌ e ne taa tavaie pana.” Na Yesus a sugup famodak a xavil ina bret lana nim e tavai na Judas, a lak si Simon Iskeriot, pana. ");
INSERT INTO leu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Layaan a ngane na Setan a vawe. Na Yesus a xuuse, “Vil fatapusan a so ta mo no taa vile.” ");
INSERT INTO leu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","E nari xapiak aava ri taxa nai pave ri vungut sena so ta mo nane fo ferawai xe sina pana. ");
INSERT INTO leu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Saxanufuna ri ilisai o naak na Yesus fo xuuse, “Fe maraan a mo talo taara taa faigotan a fenamo.” E xasanofuna ri lamon o naak a xuuse o i taa tavai a mu valagof pana saxano mo senaso na Judas fuuna faxatang a maana fafanaian siri. ");
INSERT INTO leu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Lamina siaxaana xavil ina bret nane tamasiak e falet. E a bina xo fo suk. ");
INSERT INTO leu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","La yaan na Judas fo falet xo, na Yesus a kuus, “Naboxo a Natuna Mataa i taa siak a isin lava sina e xuvul pana, a Piran sait i taa siak a isin molava. ");
INSERT INTO leu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Lavaxa, layaan a Piran i taa siak a isin lava se Natuna, a Piran i taa vil falavai a isina lana nobina ina waanan sina e i taa vile monabeꞌ mon. ");
INSERT INTO leu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Mu rafulak, ne taa waan xuvul pami pana lou modak mon. Mi taa sengau taasaxa malaan seꞌ ne fo xuus a mu matalava Juda, ‘Ne taa falet xe la saxa bina e nami, mi pife fexaxaas sena falet xe lana.’ E nami vaxa ne xuus nami o mi pife fexaxaas sena falet xe lana sait. ");
INSERT INTO leu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ne taa tavai nami pana vuputkai faꞌui malaan: ‘Fevubuxan xasingit nami xa.’ Mi taa fevubuxan xasingit nami xa malaan seꞌ ne vubuxan xasingit nami. ");
INSERT INTO leu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","A fevubuxaian xasingitan simi i taa faxalit a xasano rabuna o nami, mi mu fefeng siak.” ");
INSERT INTO leu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Na Saimon Pita a fine, “Memai, no taa falet xe faa?” Na Yesus a suie, “A bina ne taa falet xe lana naboxo mi pife fexaxaas sena usiau xe lana, taasaxa muibak mi taa usiau.” ");
INSERT INTO leu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Na Pita a xuuse, “Memai, xenaso ne pife fexaxaas sena usi nano xe lana naboxo? Ne taa solisan a taak xena xavang nano.” ");
INSERT INTO leu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Na Yesus a suie, “No kuus tuuna o no taa solisan a taam xena xavangau? Tuuna paaliu a pura taa pife taliskukuk lunai e no taa kuus faatalatul o no pife texaas sega. ");
INSERT INTO leu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Muta fanasam a mamaxusan la xunus imi. Mi namkai sena Piran e mi taa namkai sega sait. ");
INSERT INTO leu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","La bina sina Tamaang a toxan a lifu xaves. Tamo pife tuuna, ne taa pife xuus nami o ne taxa falet xe pave xena faigotan a nobina xami, bo? ");
INSERT INTO leu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ne taa falet xena faigotan a nobina xami e ne taa ulaamaan xena xel nami talo mi taa fe taagul xuvul paga. ");
INSERT INTO leu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mi texaas sena salan xe la bina aava ne taa falet xe lana.” ");
INSERT INTO leu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Na Tomas a fine, “Memai, maam pife texaas sena so ta bina no taa falet xe lana, malaafaa maam taa texaas sena salan aave?” ");
INSERT INTO leu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Na Yesus a suie, “Nenia ve, ne Salan, ne Tuunayan, e ne Toyan. Piau ta saxa mataa taa savat sina Piran lana xasa salan patak, nenia sang mon ne Salan. ");
INSERT INTO leu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tamo no texaas sega no taxa texaas se Tamaang sait. Monabeꞌ mon mi texaas sena e mi fo xalume.” ");
INSERT INTO leu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Na Filip a xuuse, “Memai, faxalit nemaam pa Tamataara e mo aave i taa fexaxaas semaam.” ");
INSERT INTO leu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Na Yesus a suie, “Ne fo waan xuvul pami pana yaan xaves paaliu Filip e mi pife taraxaliau lunai? Nane aava fo xalumau fo xalum na Tamataara. Xenaso no taxa finau, ‘Faxalit nemaam pa Tamataara?’ ");
INSERT INTO leu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","A sou, mi pife namkai o nenia, ne taxa waan xuvul pa Tamataara e na Tamataara taxa waan xuvul paga? A ferawaian aava ne xuus nami pana ne pife kuusane lapaana gutan siak, piau. Na Tamataara aava taagul xuvul paga a vile, nane fatak taxa vil a faisok sina. ");
INSERT INTO leu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Namkai sena ferawaian siak o ne taxa waan xuvul pa Tamataara e na Tamataara taxa waan xuvul paga; tamo piau, namkai sena maana faisok faꞌipul ne taxa vile. ");
INSERT INTO leu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A tuuna paaliu ne xuus nami, nane aava taxa namkai sega, nane vaxa a fexaxaas sena vil a mu faisok faꞌipul aava nenia, ne taxa vile. E vaxa naak i taa vil a mo faꞌipul molava seri senaso ne taxa falet xe si Tamataara. ");
INSERT INTO leu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","E a so ta mo mi taa fenung pana lapaana isaak, ne taa vile talo a Natuna i taa siak fati a isina Tamataara. ");
INSERT INTO leu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Aang! A so ta mo mi taa nungau pana lapaana isaak, ne taa vile. ");
INSERT INTO leu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Tamo mi vubuxan xasingitau mi taa usi fatak a vuputkai siak ");
INSERT INTO leu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","e nenia ve ne taa nung na Tamataara e nane i taa tavai nami pana xasafuna fulaa ina xakaavangan aava i taa waan xuvul pami vulai, vulai. ");
INSERT INTO leu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nane ve a Vovau ina Tuunayan aava nari mu rabuna ti la xavala ri pife fexaxaas sena siaxe senaso ri pife xalume e ri pife texaas sena. Nami, mi texaas sena senaso nane taxa waan xuvul pami e i taa waan la xunus imi. ");
INSERT INTO leu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ne taa pife taꞌulan nami xena waan nakmaal, piau. Ne taa savat xe simi. ");
INSERT INTO leu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Famodak fulaa mon e a rabuna ti la xavala ri taa pife xalumau fulaa, taasaxa nami, mi taa xalumau. Nenia, ne taxa to vulai e voxo nami sait mi taa to vulai. ");
INSERT INTO leu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","La yaan aapave mi taa texaas tuuna o nenia, ne taagul lana Tamaang e fulaa mi taa texaas o mi waan xuvul paga e ne taxa waan xuvul pami. ");
INSERT INTO leu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nane aava masam sena mu vuputkai siak e taxa usi nari, nane ve i taxa vubuxan xasingitau e nane aava vubuxanau, na Tamaang i taa vubuxane e nenia sait ne taa vubuxane e ne taa savat sina xena faxalite pana maana mo siak.” ");
INSERT INTO leu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Na Judas (pife na Iskeriot taasaxa xasa Judas) a xuuse, “Memai, malaafaa no taa faxalit nemaam pana maana mo siim e no taa pife faxalit a maana rabuna la xavala pana?” ");
INSERT INTO leu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Na Yesus a suie, “Tamo ta mataa i taxa vubuxan xasingitau i taa usi a ferawaian siak e na Tamaang i taa vubuxane. E nemaame taa savat xe sina e taa taagul la xunus ina. ");
INSERT INTO leu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nane aava pife vubuxanau i taa pife usi a ferawaian siak; a ferawaian aanabeꞌ aava mi fo langaie, pife ferawaian siak mon, piau, taasaxa ferawaian si Tamaang aava fo fengau. ");
INSERT INTO leu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Naboxo ne taxa waan xuvul pami lunai e ne taxa xuus nami pana maana mo aanabeꞌ ");
INSERT INTO leu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","taasaxa Saxa ina xakaavangan, a Vovau Xaradak aava na Tamataara taa fenge lapaana isaak, nane ve i taa fapiti nami pana maana mo xapiak e i taa falamon faꞌuli nami pana maana ferawaian aava ne fo xuus nami pana. ");
INSERT INTO leu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","A tatavai siak xena taꞌulanaan nami a malaan: ne tavai nami pana luaian. Pife malaan sena luaian ti la xavala, piau, taasaxa ne tavai nami pana luaian siak. Muta mimilisaat la xunus imi e muta mataut! ");
INSERT INTO leu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Mi fo langaiau layaan ne xuus nami, ‘Ne taa taꞌulan nami taasaxa ne taa savat faꞌulaa xe simi.’ Tamo mi vubuxan xasingitau naak mi taa faamamaas paaliu o ne taxa falet xe si Tamataara senaso na Tamataara a lava sega. ");
INSERT INTO leu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Monabeꞌ mon paamuina savatan siri, ne fo xuus nami pana maana mo aanabeꞌ e voxo layaan ri savat mi taa namkai. ");
INSERT INTO leu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Naboxo ne pife fexaxaas sena ferawai temasaat xuvul pami senaso a piran ti la xavala i taxa filimaan. Taasaxa piau ta mo la toyan siak nane fexaxaas sena yotau pana. ");
INSERT INTO leu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","A maana vilaana aava ri taa savat naboxo ri taa faxalit a maana rabuna xapiak o nenia, ne vubuxan xasingit na Tamataara e vaxa a maana vilaana ne taxa vile, na Tamataara fo faseiau pana. “Tamasiak, taara taa taꞌulan a bina aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nenia, ne yeis ina wain tuuna e na Tamaang ve, a mataa ina faxatang a yeis ina wain. ");
INSERT INTO leu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","I taa tilip tapin a maana raxan iga aava ri pife fuaa e nane taa sapit gon faroxoi a maana raxan iga aava ri fuaa talo ri taa fuaa faagut. ");
INSERT INTO leu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nami, ne fo faisoxan faroxoi nami xo pana ferawaian aava ne xuus nami pana. ");
INSERT INTO leu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Taagul xuvul paga, malaan seꞌ ne taxa taagul xuvul pami. Tamo raxan pife boak faxuvul xuluna wai ina, a pife fexaxaas sena fuaa, bo? E nami vaxa, tamo mi pife taagul xuvul paga, mi taa pife fuaa sait. ");
INSERT INTO leu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nenia, ne funa yeis e nami, mi mu raxan ina. Nane aava taagul xuvul paga, lavaxa nenia, ne taxa taagul xuvul pana e i taa fuaa faagut. Tamo mi waan patak sega a faisok simi i taa mo palau. ");
INSERT INTO leu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Naseꞌ ta mataa pife taagul xuvul paga ri taa tapin fapalauane malaan sena raxan ina wai aava mu rabuna ri tapine talo i tafe maiyang. Mui ri faxuvul a mu raxan naang e ri timin nari lana fata xena faramaana. ");
INSERT INTO leu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tamo mi taagul xuvul paga e a ferawaian siak i taxa waan la xunus imi, mi taa fenung pana so ta mo mi vubuxane e a mo aave mi taa siaxe. ");
INSERT INTO leu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","A isi Tamaang a siak fatian layaan mi taxa fuaa faagut e layaan mi waan mu fefeng tuuna siak. ");
INSERT INTO leu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Na Tamataara taxa vubuxan xasingitau e malaan, nenia xo, ne taxa vubuxan xasingit nami. Taagul lapaana vubuxanan siak. ");
INSERT INTO leu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","A malaanabeꞌ: ne fo usi fatak a vuputkai si Tamaang e voxo ne taagul lapaana vubuxanan sina; tamo mi taxa usi fatak a vuputkai siak mi taxa taagul lapaana vubuxanan siak. ");
INSERT INTO leu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ne fo xuus nami pana ferawaian aanabeꞌ talo a faamamaasan siak i taa waan la xunus imi e mi taa bas paaliu pana faamamaasan. ");
INSERT INTO leu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","E a vuputkai siak a malaan: Mi taa vubuxan xasingit nami xa malaan sena vubuxanan siak xami. ");
INSERT INTO leu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","A vubuxan xasingitan molava paaliu sina mataa a malaan: nane i taa kuus turoxo sena maatan sina xana mu fesing sina. ");
INSERT INTO leu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","E nami, mi mu fesing siak layaan mi taxa usi fatak a mu vuputkai siak. ");
INSERT INTO leu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ne taa pife xali nami pana fefeng o sisiak siak fulaa, piau. Senaso a mu fefeng ri pife texaas sena so ta mo a mataa tafuri taxa vile. Taasaxa ne fo faꞌisin nami pana ‘fesing siak’ senaso ne fo xuus fatexaas nami pana maana mo xapiak aava na Tamaang a xuusau pana. ");
INSERT INTO leu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nami, mi pife siak fatiau, piau. Ne fo siak fati nami e fo bur nami o mi taa falet e malaan sena mu wai roxo mi taa fuaa faroxo. Mi taa fuaa pana xalana aava i taa waan vulai, e voxo a so ta mo mi taa nung na Tamataara pana lapaana isaak, i taa tavai nami pana. ");
INSERT INTO leu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nabeꞌ ve a vuputkai siak: ‘Mi taa fevubuxan xasingitan nami xa.’ ");
INSERT INTO leu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Tamo a mu rabuna ti la xavala ri taa baian nami, muta ipul, senaso ri fo baianau paamuin ri baian nami. ");
INSERT INTO leu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","A tuuna a mu rabuna ti la xavala ri taa baian nami senaso mi pife malaan seri. Tamo mi saxa siri ri taa vubuxan nami senaso mi malaan seri. Taasaxa ne fo xel nami ti la palou iri xe lana pabung siak. ");
INSERT INTO leu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Lamon faꞌuli a ferawaian siak xami, ‘A sisiak a pife lava sena mataa tafuna.’ Saxanofuna aava ri vil penganau, ri taa vil pengan nami sait e saxanofuna aava ri langai a ferawaian siak, ri taa langai a ferawaian simi sait. ");
INSERT INTO leu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Taasaxa ri taa vil a maana mo aanabeꞌ xe simi sena isaak. Senaso ri pife texaas sena Saxa aava fengau. ");
INSERT INTO leu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tamo nenia, ne taa pife savat xena fasei nari, ri taa pife texaas o ri toxan a lalosaat la tari. Taasaxa naboxo ri fo texaas e voxo ri pife fexaxaas sena kuus vof a saatan siri. ");
INSERT INTO leu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nane aava baian faagutanau, nane taxa baian faagutan na Tamaang sait. ");
INSERT INTO leu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tamo ne taa pife vil a maana mo faꞌipul aava piau ta mataa fulaa fexaxaas sena vile, ri taa pife texaas o ri toxan a lalosaat. Taasaxa ri fo xalum a maana mo faꞌipul siak e ri baian faagutan nemaame Tamaang. ");
INSERT INTO leu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","E voxo a xakalayan lana Vuputkai siri a savat tuuna paaliu: ‘Ri baian faagutanau e ri piau ta fufuna xena vil malaane.’ ");
INSERT INTO leu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“A toxan a Saxa ina xakaavangan, a Vovau ina Tuunayan aava na Tamataara taxa fenge. E la yaan ne taa fengmaane xe simi ti pave sina Tamataara, i taa kuusan fasavatau. ");
INSERT INTO leu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nami vaxa, mi mu rabuna xena ferawai xakaavang sega senaso mi fo waan xuvul paga ti la tangpat. ");
INSERT INTO leu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ne fo xuus nami pana maana mo aanabeꞌ talo mi taa pife milung. ");
INSERT INTO leu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A rabuna ri taa ti votan nami sena mu lifu ina faxuvulan. Tuuna paaliu a yaan i taa savat layaan ta mataa aava i taa punuk nami i taa lamon o nane taxa vil a faisok fatak ina lotu sina. ");
INSERT INTO leu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ri taa vil malaane senaso ri pife texaas se Tamataara e ri pife texaas sega. ");
INSERT INTO leu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Taasaxa ne fo xuus nami pana maana mo aanabeꞌ talo layaan ri taa savat tuuna mi taa lamon faꞌulaa o ne fo xuus fatexaas nami pari. A saxano mo aanabeꞌ ne pife xuus nami pana la tangpat layaan ne waan xuvul pami paamua. ");
INSERT INTO leu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Taasaxa naboxo ne taa falet xe sina aava fo fengau e piau ta saxa simi a finau o ‘No taxa falet xe faa?’ ");
INSERT INTO leu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Naboxo a xunus imi a bas pana mimilisaatan senaso ne fo xuus fatexaas nami pana maana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Taasaxa ne xuus tuunei nami o a mo roxo taa savat sena faletan siak. Tamo ne pife falet a Saxa ina xakaavangan i taa pife filimaan taasaxa layaan ne falet ne taa fenge xe simi. ");
INSERT INTO leu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","E layaan i taa savat i taa faxalit a mu rabuna ti la xavala pana malasuf ina faasaalan, a malasuf ina mu vilaana fatak e a malasuf ina vilaana ina tiisan e voxo mu rabuna ri taa masam sena saatan siri. ");
INSERT INTO leu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nane i taa famasam nari o layaan ri pife namkai sega ri taxa faasaal. ");
INSERT INTO leu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","E pana ulaian siak xe si Tamaang talo mi taa pife xalumau fulaa, i taa faxalit nari o a mu vilaana siak ri fatak paaliu. ");
INSERT INTO leu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","E fulaa i taa faxalit nari o a yaan ina tiisan fo savat xo, senaso a saxa aava piran ti la xavala aanabeꞌ, taxa waan lapaana tiisan. ");
INSERT INTO leu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ne toxan a mo xaves fulaa ne buk xuus nami pana taasaxa mi pife fexaxaas sena langaie naboxo. ");
INSERT INTO leu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Taasaxa layaan a Vovau ina Tuunayan i taa savatmaan i taa faxalit nami pana maana mo xapiak aava ri tuuna sega. Nane i taa pife ferawai lapaana gutan sina sang mon taasaxa maana mo nane langaie i taa xuus nami pana e i taa xuus fatexaas nami pana mu vilaana aava ri pife savat lunai. ");
INSERT INTO leu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","I taa siak fati a isaak senaso a maana mo aava i taa xuus fatexaas nami pana ve, ri maana mo sega. ");
INSERT INTO leu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","A maana mo xapiak na Tamataara a toxane ri mo siak sait e voxo ne fo xuus nami o a maana mo a Saxa ina xakaavangan taa xuus fatexaas nami pana ve, ri maana mo sega. ");
INSERT INTO leu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Famodak mon e mi taa pife xalumau. E famodak fulaa mi taa xalum fulanau.” ");
INSERT INTO leu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Saxanu fefeng sina ri fefiai, “A so ta malasuf ina ferawaian sina ‘Famodak mon e mi taa pife xalumau e famodak fulaa mi taa xalum fulanau?’ E a so ta malasuf ina ‘Senaso ne taxa falet xe si Tamaang?” ");
INSERT INTO leu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","E voxo ri taxa fexuus, “A so ta malasuf ina ferawaian sina aave: ‘Famodak mon?’ Taara pife texaas sena so ta mo nane taxa ferawai pana.” ");
INSERT INTO leu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Na Yesus a texaas o ri buk fine pana e a xuus nari, “A so ta mo mi taxa fefiaiane la palou imi? Sena ferawaian siak: ‘Famodak mon e mi taa pife xalumau e famodak fulaa mi taa xalum fulanau?’ ");
INSERT INTO leu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ne xuus tuunei nami, mi taa mamaaluk e mi taa taangiis taasaxa a mu rabuna ti la xavala ri taa faamamaas; mi taa nasam a mamaxusan la xunus imi taasaxa mamaxusan simi taa fasavat a faamamaasan molava. ");
INSERT INTO leu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Layaan a tefin rao i luluk, nane toxan a maasaxan faagut senaso a yaan sina fo savat, taasaxa lamina luluuxan, nane faamamaas o a mataa faꞌui fo savat la xavala e voxo a maluf tapin a maasaxan sina. ");
INSERT INTO leu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Naboxo mi toxan a mamaxusan, taasaxa ne taa xalum nami fulaa e a xunus imi taa faamamaas e piau ta mataa a fexaxaas sena siak tapin a faamamaasan semi. ");
INSERT INTO leu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","La yaan aapave mi taa bai finau pana saxano fiaian. Ne xuus tuunei nami layaan mi taa fenung xe si Tamataara pana saxa mo lapaana isaak, i taa tavai nami pana mo aave. ");
INSERT INTO leu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Paamua fefexaxaas tanin mi pife fenung pana saxa mo lapaana isaak, taasaxa naboxo mi fenung saa e mi taa siaxe talo mi taa bas paaliu pana faamamaasan. ");
INSERT INTO leu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ne fo xuus nami pana maana mo aanabeꞌ lana ferawaian paap. Taasaxa a yaan i taa savat layaan ne taa pife ferawai xe simi pana ferawaian paap fulaa taasaxa ne taa xuus fatexaas nami se Tamataara pana ferawaian fatak. ");
INSERT INTO leu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","La yaan aapave mi taa fenung lapaana isaak e ne pife kuus o ne taa fenung xe si Tamataara xami, piau. ");
INSERT INTO leu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Na Tamataara fatak i taxa vubuxan xasingit nami senaso mi taxa vubuxan xasingitau e mi namkai o nenia, ne fo filimaan ti pave sina Piran. ");
INSERT INTO leu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ne filimaan ti pave si Tamataara e ne maa savat la xavala e naboxo ne taa taꞌulan a xavala e ne taa ulaa xe si Tamataara fulaa.” ");
INSERT INTO leu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nari mu fefeng sina ri kuus, “Aang, naboxo no taxa ferawai fatak e no pife ferawai paap. ");
INSERT INTO leu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Naboxo maam texaas o no masam sena maana mo xapiak e no fo texaas vaxa sena mu fiaian paamuin ta mataa i taa fiai pana; pana vilaana aanabeꞌ siim maam namkai o nano, no savat ti pave sina Piran.” ");
INSERT INTO leu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Na Yesus a sui nari, “Tuuna, mi namkai sega? ");
INSERT INTO leu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Faxatang! A yaan i taa savat, naak naboxo taxa waan, e ri taa xup tapin nami e nami saxa saxa mi taa sinuf xe la lifu simi e mi taa taꞌulanau e ne taa waan nakmaal. Taasaxa ne taa pife waan pasaxa senaso na Tamataara i taxa waan xuvul paga. ");
INSERT INTO leu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ne fo xuus nami pana maana mo aanabeꞌ talo lapaana isaak a xunus imi taa luai. La palou ina mu rabuna ti la xavala mi taa toxan a matafanan taasaxa muta mataut, ne fo xasliu a maana vilaana ti la xavala.” ");
INSERT INTO leu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Na Yesus a ferawai xapiak pana mo aanabeꞌ e mui nane kaalum xe laaꞌui la xunavata e kuus, “Tamaang, a yaan fo savat xo; siak fati a isi Natum talo na Natum taa siak fati a isaam. ");
INSERT INTO leu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","No fo tavaie pana gutan e ngavuk ina paamuian a maana rabuna xapiak ti la xavala e i taa tavai nari aava no fo siak fati nari, pana toyan vulai. ");
INSERT INTO leu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","E a toyan vulai aanabeꞌ ve a malaan: ri taa texaas sema, o nano sang mon no Piran tuuna e sena saxa vaxa aava no fo fenge, na Yesus Krais sait. ");
INSERT INTO leu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ne fo siak fati a isaam nabeꞌ la xavala senaso ne fo fataxapin a faisok aava no fo tavaiau pana. ");
INSERT INTO leu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Naboxo Tamaang, tavaiau fulaa pana malangan aava taare fo toxane paamuina tangpat ina xavala. ");
INSERT INTO leu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ne fo vil fasavat a isaam xe sina mu rabuna aava no fo tavaiau pari nabeꞌ la palou ina mu rabuna ti la xavala. Nari, ri mu rabuna siim e no fo tavaiau pari e ri fo usi fatak a ferawaian siim. ");
INSERT INTO leu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Naboxo ri texaas tuuna o nano, no fufuna maana mo xapiak aava no fo tavaiau pana, ");
INSERT INTO leu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","senaso ne fo xuus nari pana maana ferawaian aava no xuusau pana. E ri fo langai a mu ferawaian aanabeꞌ e naboxo ri masam tuuna o nenia, ne savatmaan ti pave siim e ri namkai o no fo fengau. ");
INSERT INTO leu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ne taxa fenung pari aanabeꞌ; ne pife fenung pari mu rabuna ti la xavala taasaxa ne taxa fenung pari aava no fo tavaiau pari senaso nari, ri mu rabuna siim. ");
INSERT INTO leu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","A maana mo xapiak aava ri mo siak, ri mo siim sait e a maana mo siim, ri mo siak. E nari, ri fo tavaiau pana isin lava. ");
INSERT INTO leu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Naboxo ne taa pife waan fulaa la xavala, taasaxa nari, ri waan nabeꞌ la xavala e ne taxa falet xe siim. Tamamaam Taap, faxatang nari lapaana gutan ina isaam, a isin aava no fo burau pana, talo nari, ri taa saxa malaan sena waanan sitaare. ");
INSERT INTO leu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Layaan ne waan xuvul pari ne tagan faroxoi nari pana gutan ina isaam aava no tavaiau pana. Ne tagan faagutan nari aanabeꞌ e ri pife tapigis fepatok, taasaxa saxa xo tapigis seri, nane aava no fo lamon sena o i taa milung e i taa kawaasanan talo a xakalayan sena i taa savat tuuna. ");
INSERT INTO leu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Naboxo ne taxa falet xe siim e ne taxa kuus pana ferawaian aanabeꞌ talo nari, ri taa masam tuunei a faamamaasan siak e ri taa faamamaas sait. ");
INSERT INTO leu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ne xuus nari pana ferawaian siim e mu rabuna ti la xavala ri baian nari senaso naboxo nari aanabeꞌ ri pife mo ti la xavala malaan sega vaxa, ne pife ti la xavala. ");
INSERT INTO leu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ne pife fenung talo no taa siak tapin nari ti la palou ina mu rabuna ti la xavala, piau. Taasaxa ne fenung xe siim o no taa faxatang nari e no taa kuus votan nari xasena saxa aava saat paaliu. ");
INSERT INTO leu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nari, ri pife ti la xavala malaan sega vaxa ne pife ti la xavala. ");
INSERT INTO leu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Bur nari lapaana tuunayan. A tuunayan aave ve a ferawaian siim. ");
INSERT INTO leu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nenia, ne taxa feng nari xe la palou ina mu rabuna ti la xavala malaan seꞌ no fo fengau xe la palou ina mu rabuna ti la xavala. ");
INSERT INTO leu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","E nenia, ne waan fatak lapaana tuunayan talo nari vaxa ri taa waan fatak sait lapaana tuunayan. ");
INSERT INTO leu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ne pife fenung pari aanabeꞌ sang mon, piau. Ne taxa fenung vaxa pari mu rabuna aava ri taa namkai sega lapaana kuus xakaavangan siri aanabeꞌ ");
INSERT INTO leu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","talo nari xapiak ri taa faxuvul lapaana lamonan saxa xuvul pataare. Tamaang, no taxa waan la xunus iga e ne taxa waan la xunus ima e ne vubuk o ri taa waan malaan setaare. E voxo a mu rabuna ti la xavala ri taa namkai o no fo fengau. ");
INSERT INTO leu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne fo timin a malang aava no tavaiau pana xuluna mu rabuna aanabeꞌ talo ri taa waan faxuvul lapaana lamonan saxa malaan setaare. ");
INSERT INTO leu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ne taa waan la xunus iri malaan seꞌ no taxa waan la xunus iga talo ri taa waan faxuvul faagut lapaana lamonan saxa e voxo a mu rabuna ti la xavala ri taa texaas o nano, no fo fengau e vaxa ne vubuxan xasingit nari aanabeꞌ malaan sena vubuxanan siim xanak. ");
INSERT INTO leu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Tamaang, no fo tavaiau pari e ne vubuk o ri taa waan xuvul paga la bina siak xena xalum a miridingan siak; a miridingan aava no fo faneie xulok. No fo vile senaso paamuina faisok siim ina vesanaana maana mo ti la xavala aanabeꞌ no vubuxan xasingitau. ");
INSERT INTO leu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Tamaang a maana vilaana siim ri xaradak e a mu rabuna ti la xavala ri pife texaas sema taasaxa nenia, ne texaas sema e nari aanabeꞌ ri texaas o no fo fengau. ");
INSERT INTO leu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ne fo faxalit nari pana isaam e ne taa lo faisok vulai xena siak fati nano talo a vubuxan xasingitan aava no toxane xanak i taa waan xuluri sait e vaxa nenia, ne taa waan la xunus iri.” ");
INSERT INTO leu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Layaan na Yesus a fataxapin a fenungan sina, nane xuvul pana mu fefeng sina ri taꞌulan a lifu aave e ri fe sangas liu a lana mui Kitron. A toxan a nobina ri xapis a wai olif lana e nane xuvul pana mu fefeng sina ri laak pe lana. ");
INSERT INTO leu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Na Judas aava xena pet lisane, a texaas sena nobina aapave senaso na Yesus fuuna waan pave faxaves xuvul pana mu fefeng sina. ");
INSERT INTO leu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Lavaxa, na Judas a savat la nobina aapave xuvul pana mu rabuna ina rawen aava mu matalava Juda ri feng nari e saxanu fefeng sina memai priis e mu Ferasi vaxa. E nari xapiak ri toxan a lamak e laam e maana mo ina fevisan: a tol, vam e pinis. ");
INSERT INTO leu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Na Yesus a texaas sena maana mo aava ri taa savat e a sivi xena fasusui nari e a fin nari, “Mi taxa seng naseꞌ?” ");
INSERT INTO leu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","E ri suie, “Na Yesus ti Nasaret.” “Nenia monabeꞌ” na Yesus a xuus nari. E na Judas vaxa aava xena pet lisane, i taxa tigina la palou iri. ");
INSERT INTO leu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","E layaan nane kuus malaan, monabeꞌ mon nari xapiak ri poxo suꞌ xe lapia. ");
INSERT INTO leu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","E nane fin fulan nari, “Mi taxa seng naseꞌ?” E ri xuus fulane, “Na Yesus ti Nasaret.” ");
INSERT INTO leu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Na Yesus a kuus, “Ne fo xuus nami o nenia monabeꞌ. Lavaxa mi taa pife yot nari xapiak aanabeꞌ senaso mi fo tinginau e nenia va ne saxa aava mi taxa senge.” ");
INSERT INTO leu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nane kuus malaan xena vil fasavat a ferawaian sina layaan nane fo kuus, “Ne pife taꞌulan tapin a saxa siri aava no fo tavaiau pana.” ");
INSERT INTO leu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Na Saimon Pita a toxan a pinis e nane siaxe e sip a saxa sisiak sina memai priis pana, a isina na Melkas. Nane patal tapin a tangana pamuaan. ");
INSERT INTO leu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Taasaxa na Yesus a baras na Pita, “Timin faꞌuli a pinis siim! No lamon o ne taa pife num ti lana lisa aava na Tamaang fo tavaiau pana?” ");
INSERT INTO leu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","E nari mu rabuna ina rawen e paamu siri e nari mu fefeng sina mu matalava Juda ri yot na Yesus. E ri pise ");
INSERT INTO leu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","e ri lisan paamuiane xe si Aanas. Nane va imu Kaiafas aava paamua priis la mariaas aave. ");
INSERT INTO leu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Na Kaiafas a saxa aava fo fasei a mu Juda o a vilaana roxo tamo a mataa saxa taa maat xana mu rabuna xapiak. ");
INSERT INTO leu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Na Saimon Pita narie xasa fefeng si Yesus re taxa usi nari xuvul pa Yesus. E xasa fefeng xo, fe laak xe lana bina sina memai priis senaso nari pave ri taraxalie. ");
INSERT INTO leu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Taasaxa na Pita pife fexaxaas sena laak e nane waan suꞌ pe lamalei la matana bina aave. E a fefeng aava memai priis a texaas sena, nane ulaa e fe ferawai xuvul pana tefin aava fuuna faxatang a yalaxau aave e xel falak na Pita xe lana. ");
INSERT INTO leu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","E a tefin aave a fin na Pita, “Nano, no saxa fefeng sina mataa aapave, bo?” E na Pita a suie, “Au, pife nenia!” ");
INSERT INTO leu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","A bina a vutung e mu sisiak e mu fefeng sina mu matalava ri tigina fakaliuan a fata aava ri sunge xena maari. E na Pita sait taxa tigina maari xuvul pari. ");
INSERT INTO leu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","La yaan aanabeꞌ a memai priis i taxa fin na Yesus pana mu fefeng sina e sena fepitaian sina. ");
INSERT INTO leu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Na Yesus a suie, “Ne fo ferawai la matavas la matana mu rabuna. Vulai ne fuuna fepitaa lana mu lifu ina faxuvulan o lana tang lifu lotu, a mu bina aava nari mu Juda ri fuuna faxuvul lana. Ne pife kuus fufunai. ");
INSERT INTO leu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Muta finau! Mi fin nari aava ri fo langaiau. Ri texaas faroxo sena ferawaian siak.” ");
INSERT INTO leu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Layaan na Yesus a kuus malaan a saxa paamua aava i taxa tigina faasilak sena a tavafe la yaavana e xuuse, “A pife vilaana roxo ina sui a memai priis ve malaan, bo?” ");
INSERT INTO leu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Na Yesus a xuuse, “Tamo ne fo ferawai fasaat no taa kuusane, tamo ne ferawai fatak sena tuunayan xenaso no fo tavafau?” ");
INSERT INTO leu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","E na Aanas a lisan na Yesus aava taxa vipis lunai, xe si Kaiafas, xasa memai priis. ");
INSERT INTO leu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Layaan na Saimon Pita taxa maari la xasing ina fata a saxa mataa fulaa a fine, “Nano, no saxa ina mu fefeng sina mataa aapave, bo?” E na Pita a kuus malaan, “Piau! Pife nenia.” ");
INSERT INTO leu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","E saxa sisiak sina memai priis, a tauna mataa aava na Pita patal tapin a tangana, a tisui faagutane, “Naak, ne fo xalum nano xuvul pana pave la nobina ina olif?” ");
INSERT INTO leu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","E na Pita a faaxolus fulaa e la noyaan aave xa a pura a taliskukuk. ");
INSERT INTO leu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Lavaxa, la paanen lolof xo a mu Juda ri taꞌulan a lifu si Kaiafas e ri lisan na Yesus xe la lifu sina paamua lava ti Rom. A mu Juda ri bai laak lana lifu la yaan aapave senaso ri lamon tamo ri taa laak a lalosaat sina mu topen i taa waan la tari e ri pife fexaxaas sena fangan la Fenamo ina Paaliuan. ");
INSERT INTO leu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","E voxo na Pailat a savat xe siri lamalei e fin nari, “A so ta vilaana mi taxa gel tifi a mataa aanabeꞌ pana?” ");
INSERT INTO leu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","“Tamo nane pife mataa saat maam taa pife lisanmaane xe siim” ri suie. ");
INSERT INTO leu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Na Pailat a xuus nari, “Lavaxa, nami fatak, mi xele saa e mi fe tiise lapaana vuputkai simi.” E ri sui fulane, “Taasaxa maam piau ta ngavuk ina punuk a mataa.” ");
INSERT INTO leu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","A mo aanabeꞌ a savat talo a ferawaian na Yesus fo xuus nari pana sena so ta buk maatan sina, i taa savat tuuna. ");
INSERT INTO leu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Na Pailat a xel na Yesus e re taꞌulan nari. Re laak lana lifu lava sina e nane fine, “Nano, no piran king sina mu Juda?” ");
INSERT INTO leu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Na Yesus a suie, “A fiaian aave ve siim fatak o xasanofuna ri xuus nano pana?” ");
INSERT INTO leu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Na Pailet a xuuse, “No lamon o nenia, ne mataa ti Judia? A mu rabuna siim e mu memai priis siim ri fo lisanmaan nano e ri nungau o ne taa tiis nano. A so ta mo no fo vile?” ");
INSERT INTO leu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Na Yesus a xuuse, “A fatataganan siak pife waan nabeꞌ la xavala. Tamo i taxa waan nabeꞌ a mu fefeng siak ri taa fevis xena ti votan a mu Juda sena pisaan nenia. Taasaxa fatataganan siak taxa waan pe lana bina patak.” ");
INSERT INTO leu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","E voxo na Pailat a fine, “Nano, no saxa piran king, bo?” Na Yesus a suie, “No taxa kuus tuuna layaan no kuus o nenia, ne saxa piran king. A tuuna paaliu a fufuna luluuxan siak e a fufuna savatan siak nabeꞌ la xavala ve xena kuusan fasavat a tuunayan. A maana rabuna xapiak aava ri vubuxan a tuunayan ri taa langaiau.” ");
INSERT INTO leu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Na Pailat a fine, “A tuunayan ve a so ta mo?” E nane savat faꞌulaa xe sina mu matalava Juda, pe lamalei e xuus nari, “Ne pife tingin ta fufuna ferawaian xena tiisaana mataa aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Taasaxa mi toxan a saxa vilaana malaan: ne fuuna mulus tapin a saxa mataa vipis la Yaan ina Paaliuan. Mi vubuk o ne taa mulus tapin a piran king sina mu Juda?” ");
INSERT INTO leu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","E ri xukulai faagut, “Piau! A mataa aave piau. Maam vubuxan na Baraabas!” Na Baraabas a mataa saat paaliu ina fenauan. ");
INSERT INTO leu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Lavaxa na Pailat a lisan na Yesus xe sina mu rabuna ina rawen ti Rom e ri inis fakasaname. ");
INSERT INTO leu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","E ri fi a mo malaan sena ligilot sina ‘king’ pana yeis tuturuk e ri timine la putuna. E ri fafalaxe pana marapi raf malaan sena piran king ");
INSERT INTO leu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","e ri taxa lo suaxane pana tigina la nona e kuus, “Kaalum, a piran king sina mu Juda” e ri taxa lo tuxe la nona. ");
INSERT INTO leu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mui na Pailat a xel na Yesus e re savat fulaa xe siri lamalei e xuus nari, “Xalume, ne taxa lisanmaane xe simi talo mi taa masam o nenia, ne pife tingin ta saxa fufuna ferawaian xena tiise pana.” ");
INSERT INTO leu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Layaan na Yesus a savat xe siri pana maana mausan ina piran king aava ligilot ina yeis tuturuk e marapi raf, na Pailat a xuus nari, “Kaalum! A mataa naang naboxo!” ");
INSERT INTO leu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Layaan a mu memai priis e mu fefeng siri ri xalume, ri xukulai faagut, “Niil fataxutane! Niil fataxutane!” Taasaxa na Pailat a sui nari, “Mi xele saa e mi fe niil fataxutane. Nenia, ne pife texaas sena saxa fufuna ferawaian xena tiis nane pana!” ");
INSERT INTO leu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A mu Juda ri xuuse, “Maam toxan a vuputkai e lapaana vuputkai aanabeꞌ maam taa punuxe senaso nane kuus o nane a Natuna Piran.” ");
INSERT INTO leu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Layaan na Pailat a langai a ferawaian aanabeꞌ nane xo mataut paaliu. ");
INSERT INTO leu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","E nane xel faꞌuli na Yesus xe lana lifu lava aave. E a fine, “No filimaan ti faa?” Taasaxa na Yesus a tigina kasam. ");
INSERT INTO leu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“No bai ferawai xuvul paga, bo?” na Pailat a fine. “No pife texaas o nenia, ne toxan a gutan xena mulus nano o xena niil fataxutan nano?” ");
INSERT INTO leu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Na Yesus a suie, “No taa piau ta gutan xulok tamo a Saxa pe laaꞌui a pife tavai nano pana. E voxo nari aava ri lisanau xe siim ri taa toxan a tiisan molava.” ");
INSERT INTO leu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","A tangpat la yaan aanabeꞌ e lamina na Pailat a tafang pana mulus na Yesus taasaxa mu Juda ri taxa lo xukulai, “Tamo no mulus a mataa aanabeꞌ no pife fesing si Sisaa. Naseꞌ ta mataa a kuus o nane saxa piran king, nane ve vubuk xasliu na Sisaa.” ");
INSERT INTO leu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Layaan na Pailat a langai nari nane lisan na Yesus xe lamalei e nane fe nai xuluna ivin ina tiisan la nobina ri xalie pana ‘A Veraanda Faat.’ (Lana pok bina Erameik ri kuus, “Gabaata”) ");
INSERT INTO leu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A yaan aanabeꞌ a Yaan ina Faigotan a Fanganan Xena Fenamo ina Paaliuan e a faasilak a fapisaxayaana awa. E na Pailat a xuus a mu Juda, “A piran king simi nabeꞌ!” ");
INSERT INTO leu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Taasaxa ri xukulai, “Gei tapine! Gei tapine! Niil fataxutane!” Na Pailat a fin nari, “Ne taa kuus pana niil fataxutan a piran king simi?” Nari mu memai priis, ri kuus, “Maam piau ta xasa ‘king’ fulaa, na Sisaa sang mon!” ");
INSERT INTO leu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","E voxo na Pailat a kuus turoxo o ri taa xele xena niil fataxutane. E ri yot na Yesus ");
INSERT INTO leu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","e ri timin a bolo sina xuluna xena yaasaana xe la bina ri xalie pana Bina ina Veng; lana pok Hibru ri kuus ‘Golgaata’. ");
INSERT INTO leu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","E pave ri niil fataxutane. Ri niil fataxutan a xasaro mataa sait e ri fatiginei nare la ro xasing ina bolo si Yesus. ");
INSERT INTO leu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Na Pailat a xalei a lagasai e ri timine xuluna bolo si Yesus. A xakalayan aave a kuus malaan: “Na Yesus ti Nasaret, a piran king sina mu Juda” ");
INSERT INTO leu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A maana Juda xaves ri xalum a lagasai aanabeꞌ senaso a bina aava ri niil fataxutan na Yesus lana a waan faasilak la xasing ina bina lava aave e a lagasai a xaleian lana pok bina talatul: a pok Hibru, a pok Laatin, e a pok Griik. ");
INSERT INTO leu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","E mu memai priis sina mu Juda ri tisui fadak na Pailat e ri xuus, “Muta kala malaan: ‘A piran king sina mu Juda,’ taasaxa no taa kala malaan: ‘nane kuus o nenia, ne piran king sina mu Juda.” ");
INSERT INTO leu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Na Pailat a sui nari, “Piau, a lagasai ne fo xaleie, ne fo xaleie!” ");
INSERT INTO leu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Layaan a mu rabuna ina rawen ri fo niil fataxutan na Yesus ri siak a mu marapi sina e ri fepatoxane pana xavil talafaat, saxa xavil xana saxa mataa ina rawen. E ri siak a mo malaan sena ‘siot’ sina sait, taasaxa mu rabuna aava ri vesane, ri vesan xurule pana piau ta nobina ina ferumaiane. ");
INSERT INTO leu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","E voxo ri ferawai sena, “Taara taa pife ririxe taasaxa taara taa fetafangai pana faat talo taara taa texaas o naseꞌ taa siaxe.” Ri vil malaane e voxo ri fasavat tuunei a xakalayan aava kuus malaan: “Ri fepatoxan a mu marapi siak la palou iri e ri fetafangai pana faat xena texaas o naseꞌ i taa siak a ‘siot’ siak.” ");
INSERT INTO leu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lavaxa, na nina Yesus narie tina xuvul pa Maria, a tefin si Klopas e xasa Maria, na Maria ti Mekdala, nari, ri taxa tigina faasilak la tana bolo si Yesus. ");
INSERT INTO leu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Na Yesus a xalum a ninana nare na saxa yaamut aava nane vubuxan xasingite, re taxa tigina faxuvul e nane xuus na ninana, “Ninaang, kaalum, na natum ve taxa tigina.” ");
INSERT INTO leu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","E mui nane xuus a yaamut sina, “Kaalum, na ninaam ve taxa tigina.” E voxo a tangpat la yaan naang a yaamut aave a xel na nina Yesus i taa taagul la lifu sina vulai. ");
INSERT INTO leu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Na Yesus a texaas o nane fo vil fataxapin a maana mo xapiak sena. E mui xena fasavat tuunei a Xakalayan nane kuus, “Ne taxa maꞌiu.” ");
INSERT INTO leu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Saxa vuk taxa waan faasilak e a bas pana wain aava mopaak famodak. E nari mu rabuna ina rawen ti Rom ri timin a pel lana wain aave e ri timine xuluna newai ‘isop’ e ri laxat falaxe xe la valana. ");
INSERT INTO leu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nane num a wain mopaak aave e a kuus, “Fo taxapus, xo!” E nane turung e mulus tapin a vovau sina. ");
INSERT INTO leu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","A yaan aave a yaan paamuina Yaan ina Fangaafusan e voxo mu Juda ri nung na Pailat o a mu rabuna ina rawen ri taa vuak a nu karutul xena famaat fatapusan narutul talo ri taa siak tapin a mu vipin sirutul. Senaso a Yaan ina Fangaafusan aanabeꞌ a yaan lava paaliu e pife roxo o a mu vipin sirutul taa tofai xuluna bolo la Yaan ina Fangaafusan. ");
INSERT INTO leu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","E voxo mu rabuna ina rawen ri savat e ri vuak a kana ro mataa aava ri niil fataxutan nare xuvul pa Yesus. ");
INSERT INTO leu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Layaan ri savat la tana bolo si Yesus, ri xalume o nane fo maat xo e voxo ri pife vuak a ro kana. ");
INSERT INTO leu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Taasaxa saxa mataa ina rawen a xie la usik ina pana tol. E la noyaan aave xa, a ria e a raarum a talatiu xe la pia. ");
INSERT INTO leu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","A mataa aava fo xalum a maana mo aanabeꞌ a kuus xakaavang sena e nane texaas o fo kuus tuuna. E a kuus malaan xena xavang a namkaian simi. ");
INSERT INTO leu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","A mu vilaana aave ri savat senaso a Xakalayan ti Kavai a kuus malaan: “E piau ta saxa tun ina taa vuaxan.” ");
INSERT INTO leu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","E a xasa paferawaian ina Xakalayan a kuus: “Ri taa xalum nane aava ri fo xie.” ");
INSERT INTO leu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Mui na Yosep ti Erimatia fe nung na Pailat pana vipin i Yesus. Na Yosep a saxa matalava aava namkai se Yesus taasaxa mataut sena mu matalava Juda e a namkai fufunai. Na Pailat a kuus turoxo o i taa siak a vipin i Yesus e nane fe siak faduie. ");
INSERT INTO leu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nare Nikodimaas re faisok faxuvul. Na Nikodimaas va mataa aava fo savat si Yesus la saxa vung. E nane siakmaan a maxi aava fuuna las faroxo. A maxi aanabeꞌ ri vesane pana ro mo ‘aalou’ e ‘mur’ e fexaxaas sena 34 kilogram. ");
INSERT INTO leu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","E re siak a vipin i Yesus e ri pis falak a marapi ‘linen’ xuluna xuvul pana maxi aave. Layaan ri vil malaane ri taxa usi fatak a mu vilaana ina xaxaafaian sina mu Juda. ");
INSERT INTO leu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Faasilak latana nobina aava ri niil fataxutan na Yesus lana, a toxan a fomirak nobina roxo e lana nobina aave a toxan a liing faꞌui ina mamaat aava ri pife xaafan ta mataa lana lunai. ");
INSERT INTO leu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Re taxa faisok fataapus senaso a yaan aave ve a Yaan ina Faigotan a Fanganan ina Fenamo sina mu Juda, e voxo re famati a vipin i Yesus pave senaso a liing ina mamaat aave a faasilak. ");
INSERT INTO leu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","La paanen lolof la yaan mata ina ‘wiik’, a bina suk lunai e na Maria ti Mekdala a savat la bina ina mamaat aave. Nane xalum a faat ina xawei a liing ina mamaat, ri fo pul tapine e a matana talakas. ");
INSERT INTO leu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","E voxo nane fala fataapus xe si Saimon Pita narie na xasa yaamut aava na Yesus a vubuxan xasingite e fe xuus nare, “Ri fo siak tapin a Memai ti lana mamaat e maam pife texaas o ri timine faa.” ");
INSERT INTO leu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","E voxo na Pita nare na xasa yaamut aave re falet xe la bina ina mamaat. ");
INSERT INTO leu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nare, re fala fataapus taasaxa xasa yaamut a fala liu na Pita e fe savat la bina ina mamaat paamua. ");
INSERT INTO leu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A sonai xena kaalum lana liing e a xalum a mu marapi ‘linen’ taxa waan pave taasaxa nane pife laak lana. ");
INSERT INTO leu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mui na Saimon Pita aava savat lamina, a laak lana liing ina mamaat. E nane vaxa a xalum a mu marapi ‘linen’ taxa mati. ");
INSERT INTO leu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","E a marapi aava ri pis a putu Yesus pana, pife waan xuvul pana xasanu marapi ‘linen’ taasaxa pulum faroxoian e mati patak famodak. ");
INSERT INTO leu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mui a xasa yaamut aava savat la bina ina mamaat paamua a laak lana. Nane xalum a maana mo aave e namkai sena maana ferawaian si Yesus. ");
INSERT INTO leu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Taasaxa nare xapiak re pife masam faroxo pana Xakalayan ti Kavai aava kuus o na Yesus i taa to faꞌulaa sena maatan. ");
INSERT INTO leu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","E a ro yaamut re ulaa fulaa xe la lifu sire. ");
INSERT INTO leu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Na Maria ti Mekdala taxa tigina lunai faasilak la bina ina mamaat e taxa taangiis. I taxa taangiis e sonai suꞌ xena kaalum lana liing ina mamaat ");
INSERT INTO leu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","e nane xalum a ro angelo aava re falak a marapi pasak. E re taxa nai la nobina aava vipin i Yesus fo mati xuluna, saxa la putuna e saxa la kana. ");
INSERT INTO leu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","E re fine, “Tefin, no taxa tangiis a so?” Nane sui nare, “Ri fo siak tapin a vipin ina Memai siak e ne pife texaas o ri timine faa.” ");
INSERT INTO leu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","I taxa kuus malaan e tapuk famodak e xalum na Yesus taxa tigina faasilak taasaxa nane pife texaas o na Yesus ve. ");
INSERT INTO leu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nane xuuse, “Tefin no taxa tangiis a so? No taxa seng naseꞌ?” Na Maria a lamon o nane a mataa tataraꞌuma e voxo a fine, “Ai matalava, tamo no fo yaase xe la saxa nobina, xuusau pana nobina aava no timine lana talo ne taa fe siaxe.” ");
INSERT INTO leu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Na Yesus a xele, “Maria.” Nane tapuk xe sina e xukulai lana pok Erameik, “Raaboni!” (A malasuf ina malaan: Mataa ina Fepitaa) ");
INSERT INTO leu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Na Yesus a xuuse, “Muta yotau, senaso ne pife laak faꞌulaa xe si Tamaang lunai. Taasaxa no taa falet xe sina mu fetinan siak e no taa xuus nari malaan: ‘Ne taxa laak xe si Tamaang aava Tamami sait e xe sina Piran siak aava Piran simi sait.’” ");
INSERT INTO leu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","E voxo na Maria ti Mekdala a falet e fe xuus a mu fefeng si Yesus malaan, “Nenia, ne fo xalum na Memai” e a xuus fatexaas nari pana maana mo aava na Yesus a xuuse pana. ");
INSERT INTO leu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","A bina xo fevung la yaan naang xa, a yaan mata ina ‘wiik’ e mu fefeng si Yesus ri taxa waan faxuvul lana saxa lifu e ri fo xawei fatateak a maana matana lifu senaso ri matautan a mu Juda. E na Yesus a savat e maa tigina la palou iri e kuus, “Ne vubuk rao a luaian i taa waan la xunus imi.” ");
INSERT INTO leu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nane kuus malaan e faxalit nari pana ro mana e usik ina. Layaan a mu fefeng ri xalume ri faamamaas temasaat. ");
INSERT INTO leu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","E na Yesus a xuus fulan nari, “Ne vubuk rao a luaian i taa waan la xunus imi. Malaan se Tamaang fo fengau, nenia, ne taxa feng nami.” ");
INSERT INTO leu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","E nane vipiif laaꞌui xuluri e kuus, “Siak a Vovau Xaradak. ");
INSERT INTO leu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Layaan mi taa lamon tapin a vilaana saat sina mataa, lavaxa ne taa lamon tapin a vilaana saat sina. E layaan mi taa pife lamon tapin a vilaana saat sina saxa mataa ne taa pife lamon tapin a vilaana saat aave.” ");
INSERT INTO leu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Na Tomas aava ri xalie pa Didimas o tauna lua, a saxa yaamut ti la palou iri mu yaamut Sangafilu Saxa pana Taragua, e nane pife waan xuvul pari layaan na Yesus a savat. ");
INSERT INTO leu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Layaan a xasanu fefeng ri xuuse o ri fo xalum a Memai, nane kuus, “Tamo ne pife xalum a vavena ‘niil’ la mana e pife tawe pana maak e ne pife salen falak a maak lana usik ina, ne taa pife namkai sena mo aanabeꞌ mi taxa ferawai pana.” ");
INSERT INTO leu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","A saxa ‘wiik’ mui lamina, a mu fefeng si Yesus ri faxuvul fulaa lana lifu aave e na Tomas taxa waan xuvul pari. A mu matana lifu ri xawei fatateaxe taasaxa na Yesus a savat e maa tigina la palou iri e kuus, “Ne vubuk rao a luaian taa waan la xunus imi.” ");
INSERT INTO leu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lavaxa, nane xuus na Tomas, “Tawau nabeꞌ, xalum a ro maak. Filimaan faasilak nabeꞌ e no timin a vipirigum lana usik iga. Muta lamavaang, namkai sega!” ");
INSERT INTO leu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","E na Tomas a suie, “Nano, no Memai siak. No Piran siak.” ");
INSERT INTO leu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Na Yesus a xuus fulane, “Nano, no namkai naboxo senaso no fo xalumau? Nari aava ri pife xalumau taasaxa ri namkai sega, ri taa faamamaas paaliu.” ");
INSERT INTO leu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","La matana mu fefeng sina, na Yesus a vil a maana fakalimaanan faꞌipul xaves aava ne pife xaleie lana xakalayan aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Taasaxa maana mo aava ri waan lana xakalayan aanabeꞌ ne xaleie talo mi taa namkai o na Yesus a Mataa Failai (na Messia) e a Natuna Piran. E layaan mi taa namkai sena mi taa siak a toyan sina lapaana gutan ina isina. ");
INSERT INTO leu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Lumui na Yesus a savat fulaa xe sina saxano fefeng sina la xasing ina Laman Taibirius. A savat malaan: ");
INSERT INTO leu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Na Saimon Pita, Tomas (aava ri xalie pa Didimas o tauna lua), Nataaniel ti Kena pe Galili, a ro lak si Sebedi e xasaro fefeng ri taxa waan faxuvul. ");
INSERT INTO leu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","E na Saimon Pita a xuus nari, “Ne taa paan, ne faadin.” E nari, ri xuuse, “Maam taa falet xuvul pama.” E voxo ri falet e ri xawas xuluna xaati, taasaxa la vung naang ri pife siak fapes ta saxa din. ");
INSERT INTO leu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","La paanen lolof na Yesus i taxa tigina la gun taasaxa mu fefeng sina ri pife texaas o na Yesus ve taxa tigina. ");
INSERT INTO leu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nane xel nari, “Kamu fesing, mi pife siak ta din?” E ri suie, “Piau paaliu marasaxa.” ");
INSERT INTO leu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","E nane xuus nari, “Tapin a vana simi xe la xasing la pamuaan ina xaati e mi taa siak a din xaves.” Layaan ri vil malaane ri pife fexaxaas sena yuuf falak a vana aave senaso a mu din lana ri xaves paaliu. ");
INSERT INTO leu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","E a yaamut aava na Yesus a vubuxan xasingite a xuus na Pita, “A Memai ve!” Layaan na Saimon Pita a langai, ‘A Memai ve’, fataapus paaliu nane falak a ‘siot’ sina (senaso nane muluse la yaan ina faisok) e lalaas du lana laman. ");
INSERT INTO leu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","A xasano fefeng ri usie pana xaati e ri taxa yuuf a vana aava bas pana din senaso ri pife lasuun temasaat sena gun, a faasilak 100 mita mon. ");
INSERT INTO leu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Layaan ri ung ri xalum a fata taxa rangat e saxanu din nane taxa suluxe pave e a bret sait. ");
INSERT INTO leu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Na Yesus a xuus nari, “Lisanmaan a saxano din aava mi fo siaxe monabeꞌ mon.” ");
INSERT INTO leu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","E na Saimon Pita a laak xuluna xaati e yuuf falak a vana xe la gun. A vana a toxan a din molava xaves, a xakatan siri ve 153, taasaxa vana pife tiririk. ");
INSERT INTO leu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","E na Yesus a xuus nari, “Filimaan taara fangan xo.” E nari, ri mataut sena fine, “Nano naseꞌ?” senaso ri texaas o a Memai mon. ");
INSERT INTO leu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Na Yesus a filimaan faasilak xe siri e siak a bret e tavai nari pana e a vil malaane pana mu din vaxa. ");
INSERT INTO leu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","A yaan aave a fatalatulaana savatan si Yesus xe sina mu fefeng lamina to faꞌulaian sina ti la maatan. ");
INSERT INTO leu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Layaan ri fangan xapiak na Yesus a xuus na Saimon Pita, “Saimon, natu Jon, a tuuna o a vubuxanan siim xanak a molava sena vubuxanan siim xana maana xasano mo?” E nane suie, “Aang Memai, no texaas o ne vubuxan nano.” Na Yesus a xuuse, “Tavai a mu sipsip siak pana fanganan.” ");
INSERT INTO leu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Na Yesus a fin fulane, “Saimon, natu Jon, no vubuxan xasingitau tuuna?” E nane sui fulane, “Aang Memai, no texaas o ne vubuxan nano.” Na Yesus a xuuse, “Faxatang faroxoi a mu sipsip siak.” ");
INSERT INTO leu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","E na Yesus a fatalatul a fiaian sina, “Saimon, natu Jon, a tuuna no vubuxanau?” Na Pita a mamaxus senaso na Yesus a fin faatalatulane pana ‘Tuuna no vubuxanau?’ E voxo nane suie, “Memai, no texaas sena maana mo xapiak; no texaas o ne vubuxan nano.” Na Yesus a xuus fulane, “Tavai a mu sipsip siak pana fanganan. ");
INSERT INTO leu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ne xuus tuunei nano, layaan no pife matalava no falak a marapi siim xa e no fo paan xe la so ta bina no vubuxane; taasaxa layaan no taa vaiak no taa ngangai a maam e xasa mataa taa fafalak nano pana marapi siim e i taa paamuian nano xe la saxa bina aava no bai falet xe lana.” ");
INSERT INTO leu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Na Yesus a kuus malaan xena fasavat a so ta buk maatan na Pita taa nangus a Piran pana. E mui nane xuuse, “Nano, no usiau!” ");
INSERT INTO leu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Na Saimon Pita a gilim e xalum a fefeng aava na Yesus a vubuxan xasingite, i taxa usi nare. Nane ve, a saxa aava femati la xasing i Yesus la yaan ina fanganan fataxapiak e fine, “Memai, naseꞌ ta mataa i taa pet lisan nano?” ");
INSERT INTO leu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Layaan na Pita a xalume, a fin na Yesus, “Memai a so ta mo taa savat sena?” ");
INSERT INTO leu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","A Memai a suie, “Tamo ne vubuk i taa waan fefexaxaas sena yaan ina ulaian siak, pife mo siim. Nano, no taa usiau.” ");
INSERT INTO leu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Sena ferawaian aanabeꞌ a mu fetinan ri fuuna fexuusane o a fefeng aave i taa pife maat. Taasaxa na Yesus a pife kuus o i taa pife maat; nane kuus mon, “Tamo ne vubuk i taa waan to fefexaxaas sena ulaian siak, pife mo siim.” ");
INSERT INTO leu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A fefeng naang ve nabeꞌ fo kuus xakaavang pana maana mo aanabeꞌ e fo xaleie. E maam texaas o a kuus xakaavangan sina a tuuna. ");
INSERT INTO leu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","A toxan a maana mo xaves fulaa maan sait na Yesus a vile. Tamo ri taa xalei sasaxain nari xapiak, naak, i taa piau ta nobina la xavala xapiak fefexaxaas xena maana mu buuk aava ri taa xalei fasavate sena. ");
INSERT INTO leu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ka fesing Tiofilas: Lana lagasai mata siak, ne fo kala pana maana mo xapiak na Yesus fo vile e fapiti a mu rabuna pana fefexaxaas a yaan nane laak xe laaꞌui la xunavata. ");
INSERT INTO leu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Paamuina laaxan sina nane tavai a mu yaamut aava nane fo siak fati nari, pana fepitaian lapaana gutan sina Vovau Xaradak. ");
INSERT INTO leu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Lamina maasaxan e maatan sina, na Yesus xo a to faꞌulaa. E nane faꞌipul nari pana xasano vilaana ri pi xaxalume xena faxalit nari o i taxa to tuuna e pife rongan. Lana yaan sangafilu talafaat ri xalum faxavesane e nane xuus nari pana fatataganan sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Saxa yaan layaan na Yesus xo i taxa fangan xuvul pari, nane tavai nari pana fefasaian aanabeꞌ, “Muta taꞌulan na Jerusalem, taasaxa waan bang fatateak a tatavai aava na Tamaang fo kuus fanai pana xe simi e nenia vaxa, ne fo xuus nami pana. ");
INSERT INTO leu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Na Jon a fasuf a rabuna pana raarum, taasaxa faasilak xo, a Piran i taa fasuf nami pana Vovau Xaradak sina.” ");
INSERT INTO leu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Layaan a mu yaamut ri waan xuvul pa Yesus ri fine, “Memai, lana yaan aanabeꞌ no taa kawaasan a mu paamua ti Rom e fati faꞌuli a fatataganan sina Piran nabeꞌ la xavala, bo?” ");
INSERT INTO leu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Na Yesus xo a sui nari malaan, “Nabeꞌ ve a faisok si Tamaang sang mon. Nane xa a texaas sena mu yaan e mariaas e i taa pife xuus fatexaas nami pana. ");
INSERT INTO leu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Taasaxa mi taa siak a gutan layaan a Vovau sina i taa savat xulumi. E nami, mi taa ferawai xavang a mu rabuna pe Jerusalem e lana Judia e Sameria e pe la mu bina xapiak la xavala, paga.” ");
INSERT INTO leu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Lamina ferawaian aanabeꞌ a Piran a xel falak na Yesus xe laaꞌui. Layaan a mu rabuna ri taxa saraak xena xalumaana laaxan sina xe laaꞌui, a vata a sivimaan e maa xafute xaseri. ");
INSERT INTO leu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ri taxa kaalum xe laaꞌui e a ro mataa pana marapi pasak re maa savat faꞌipul nari. ");
INSERT INTO leu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","E re fiai, “Ai, mu Galili, xenaso mi taxa lo ti kaalum xe laaꞌui? Lamon faꞌuli na Yesus naang aava Piran fo xele xasemi xe la bina sina, i taa ulaamaan fulaa malaan seꞌ mi fo xalum a laaxan sina xe laaꞌui.” ");
INSERT INTO leu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","A rovaat aave re taꞌulan a mu rabuna. E mui, a mu rabuna aave ri taꞌulan a Put Olif e ri sangas famodak xe la bina lava, Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Layaan ri maa savat pe Jerusalem ri paan fatak xe la nobina laaꞌui lana lifu aava ri fuuna nai fangaafus lana. Pave, a mu yaamut; na Pita nari Jon, Jems, Endru, Filip, Tomas, Baatalamiu, Matiu, xasa Jems aava lak si Elfias, Saimon aava vubuk o a mu memai siri xa ri taa paamuian nari e na Juut a lak sina saxa Jems, ri waan pave. ");
INSERT INTO leu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Vulai, ri waan xuvul pana saxano lutefin e na Maria, na nina Yesus, e a mu tina xena fenung xe sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Saxa yaan, faasilak a rabuna 120 ri waan xuvul xena nungaana Piran. E na Pita a ti ferawai la palou iri e ");
INSERT INTO leu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","a kuus malaan, “Mu fetinan, a paferawaian sina Piran aanabeꞌ a savat tuuna la matavas, a ferawaian se Judas aava Vovau sina Piran a kuus fatuxai pana la ngusu Devit. Na Judas aanabeꞌ a paamuian a mu rabuna aava ri yot na Yesus. ");
INSERT INTO leu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nane waan xuvul pataara senaso na Yesus xa fo siak fatie pana faisok sina malaan setaara.” ");
INSERT INTO leu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Pana mu faat aava mu paamua ri tavai na Judas pana sena vilaana saat sina, nane maraan a xavala e pave nane poxo e maat. A xuna a tuguput e a vilau ina a turuvil xe la pia. ");
INSERT INTO leu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","A mu rabuna xapiak pe Jerusalem, ri langai pana maatan si Judas e voxo ri xali a xavala pave, lana pok bina siri, pana “Akeldama”, a malasuf ina “A xavala pana ria”.) ");
INSERT INTO leu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Na Pita a kuus fulaa, “A ferawaian sina Piran a kuus se Judas lana mu Yanganan malaanabeꞌ, “A nobina sina taa gof, pi ta mataa i taa taagul lana.” e xasa saxa fulaa, “A xasa mataa fulaa i taa siak a vepen sina.” ");
INSERT INTO leu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","E voxo, taara taa siak fati a saxa mataa ti la palou itaara aava waan xuvul pataara la mu yaan xapiak layaan na Memai Yesus sitaara a waan xuvul pataara; ");
INSERT INTO leu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","a mataa aava fo waan xuvul pataara ti la tangpat, layaan na Jon a fasuf a mu rabuna, fefexaxaas a yaan a Piran a xel falak na Yesus xasetaara. Senaso saxa la palou itaara i taa kuus xakaavang pana to faꞌulaian sina, xuvul pataara.” ");
INSERT INTO leu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ri kuus pana rovaat taragua: na Matias e na Yosep Basaabas, a xasa isina na Justus. ");
INSERT INTO leu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Nari xapiak xo ri fenung xe sina Piran e ri kuus, “Piran, nano xa no texaas sena so ta mo a waan la xunus imaam, e voxo fasavat a faat pana isina mataa no mo lamon faati o i taa vil a faisok ina yaamut aava na Judas a taꞌulane xena paan xe la bina ina fakasanamaan nane.” ");
INSERT INTO leu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ri xalei a isin xuluna faat saxa saxa. Ri tapin a ro faat e a faat pana isi Matias a savat paamua. E voxo, na Matias a waan xuvul pana mu yaamut. ");
INSERT INTO leu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Layaan a Yaan ina Pentakos a savat, a mu rabuna aava ri usi na Yesus, ri waan faxuvul lana saxa lifu. ");
INSERT INTO leu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","A mo malaan sena reref molava a savat faꞌipul ti la xunavata e maa tifi a lana lifu aava ri taxa nai lana. ");
INSERT INTO leu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","E bak ri xalum a mo malaan sena radaam ina fata a savat e maa fala fepatok e maa nai xuluna mu rabuna saxa saxa. ");
INSERT INTO leu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","E nari xapiak, ri febas pana Vovau Xaradak e ri ferawai lapaana gutan sina lana pok bina xaves aava ri pife texaas sena. ");
INSERT INTO leu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","E pe Jerusalem vaxa, a mu rabuna Juda xaves aava ri nangus a Piran, ri taxa waan. Ri filimaan ti la mu bina la xavala. ");
INSERT INTO leu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Layaan ri langai a reref aave, a malila ri fesavat pave e ri fetavanat senaso nari saxa saxa ri langai a mu rabuna aava ri usi na Yesus, ri taxa ferawai pana pok bina tuuna siri. ");
INSERT INTO leu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ri ipul faagut e ri kuus, “A mu rabuna aava ri ferawai malaan, ri mu Galili, bo? ");
INSERT INTO leu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Malaafaa taara langai nari, ri taxa ferawai lana pok bina sitaara saxa saxa? ");
INSERT INTO leu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Taara mu rabuna ti la mu bina xaves: ti Patia, Midia e Ilam e Mesopotemia, ti Judia e ti Kapadosia e Pontus e Esia, ");
INSERT INTO leu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","e Fridia e Pemfilia, ti Isip e saxano bina lana Libia faasilak la bina lava Sairiin, e saxanofuna ti Rom, ");
INSERT INTO leu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","a mu Juda xuvul pana rabuna aava ri puk a lamonan siri xena usi a vilaana ina lotu sina mu Juda, e a rabuna ti Kriit e Erebia sait. Taasaxa, netaara xapiak, taara langai nari, ri kuusan fasavat a maana mo roxo paaliu aava Piran a vesane. E ri taxa ferawai lana mu pok bina sitaara.” ");
INSERT INTO leu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","A mu rabuna aave ri pife masam faroxo sena maana mo aava fo savat e ri fefiai la palou iri, “A so ta mo nabeꞌ fo savat?” ");
INSERT INTO leu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Taasaxa saxanofuna ri suaxan nari e ri kuus, “Ri fo num temasaat.” ");
INSERT INTO leu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Na Pita a tigina xuvul pana mu yaamut sangafilu saxa pana saxa e a ferawai xe sina malila. Nane xukulai malaanabeꞌ, “Ai, mi Juda e nami aava mi taxa waan fataalin nabeꞌ Jerusalem, ne taa xuus fatexaas nami pana so ta mo fo savat iau, langaiau. ");
INSERT INTO leu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Nemaam nabeꞌ, maam pife num malaan seꞌ mi lamon pana. Naboxo faasilak 9 oklok la paanen mon e mi texaas o taara pi nunum la paanen. ");
INSERT INTO leu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Piau, lokavai mupiis, lana Xakalayan Taap, na Joel, a mataa ina kuus fatuxai, a ferawai pana maana mo aava savat tanin malaanabeꞌ: ");
INSERT INTO leu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","A Piran a kuus, ‘La fataxapiak ina yaan, nenia xa, ne taa tamana tiuan a Vovau Xaradak siak. E ne taa fabas a mu rabuna xapiak pana. A mu rafulak simi ri taa kuus fatuxai; a mu xulau simi ri taa xalum a xaxaalua e a mu matalava simi ri taa mif. ");
INSERT INTO leu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Aang, lana mu yaan aapave, xuluna mu sisiak siak, a mu tomexaan e lutefin xapiak, ne taa tamana tiuan a Vovau Xaradak siak e nari, ri taa kuusan fasavat a ferawaian siak. ");
INSERT INTO leu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","E ne taa faxalit a maana mo faꞌipul laaꞌui la finavata e a maana fakalimaanan malaan sena ria, fata e vata maxata lapi la xavala. ");
INSERT INTO leu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","E vaxa a ngaas i taa maat e a matana fulun i taa vuung malaan sena ria. A maana mo aanabeꞌ ri taa savat xena fakalimaan a yaan lava ina ulaamaanan sina Memai. ");
INSERT INTO leu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Lana yaan aave, naseꞌ ta rabuna ri taa fenung xe sina Piran pana mamaaluxan sina, ri taa kaaxup.’ ");
INSERT INTO leu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Nami mu Israel, langaiau: na Yesus ti Nasaret, a Piran a turoxoian nane. E pana gutan sina Piran, nane xo fo vil a maana faisok ina gutan e mo faꞌipul la palou imi. A maana mo aanabeꞌ ri faxalit fatexaas nami o a Piran fo fenge. ");
INSERT INTO leu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","E a Piran xo lana texaasan e vubuxanan sina, a texaas o mi taa yot na Yesus. E nami, pana xakaavangan sina mu rabuna saat, mi punuxe layaan mi niil fataxutane laaꞌui xuluna bolo. ");
INSERT INTO leu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Nami xa, mi punuxe. Taasaxa Piran xo a fatatoi faꞌulie e mulus tapine sena maasaxan ina maatan senaso a maatan a pi ta gutan fexaxaas xena tao fatateak vulan na Yesus. ");
INSERT INTO leu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Lana Xakalayan Taap, a butaara, na Devit, a kuus pa Yesus malaanabeꞌ, ‘Nenia, ne xalum a Piran a waan vulai lanoga. Senaso nane waan la pamuaan siak, ne taa pife mataut.’ ");
INSERT INTO leu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","E vaxa ferawai fulaa malaan, ‘A viuga a nanam e ne ferawai pana faamamaasan. Ne taa pife mataut sena maatan ");
INSERT INTO leu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","senaso no taa pife taꞌulanau lana bina ina mamaat.’ E vaxa malaan laa, ‘A mataa failai siim taa pife masiik. ");
INSERT INTO leu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","No faxalit famatavasau pana vilaana ina toyan e no taa fabasau pana merawan la mataam.’ ");
INSERT INTO leu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Naboxo, mu fetinan, ne taa xuus tuunei nami pa butaara, na Devit. Nane xo fo maat e a mu rabuna ri fo xaafane. A bina ina mamaat sina taxa waan fefexaxaas a yaan aanabeꞌ tanin. ");
INSERT INTO leu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Na Devit ve a mataa ina kuus fatuxai e a texaas o a Piran a kuus fanai lapaana isin sina xa o a saxa yaya si Devit i taa nai la vavena nai piranan sina, malaan sena. ");
INSERT INTO leu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Senaso na Devit a texaas sena maana mo aava ri taa savat, nane ferawai pana to faꞌulaian si Krais layaan a kuus o a Piran i taa pife taꞌulane lana bina ina mamaat e vaxa a vipin ina i taa pife masiik pave. ");
INSERT INTO leu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","E lana yaan aanabeꞌ a Piran a fatatoi faꞌuli na Yesus e nemaam xapiak xa, maam xalume. ");
INSERT INTO leu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","E vaxa a Piran a siak falak na Yesus xe la pamuaan sina e nane xo saxam a Vovau Xaradak aava na Tamana fo xuus faneie pana. E a maana mo aanabeꞌ aava mi xalume e langaie tanin, ri savat sena Vovau Xaradak sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Na Devit xo pife laak xe laaꞌui la xunavata taasaxa nane kuus, ‘A Piran a xuus a Memai siak, “Nai la pamuaan siak fefexaxaas ");
INSERT INTO leu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ne taa timin a mu xaiyaas siim lapaana kaam malaan sena mo ina vaapaas.” ");
INSERT INTO leu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“E voxo, nami mu Israel, mi taa texaas se Yesus aava mi fo niil fataxutane laaꞌui xuluna bolo, o a Piran a faꞌisine pana ro isin molava paaliu; a Memai e na Mataa Failai.” ");
INSERT INTO leu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Layaan a rabuna ri langaie, ri lamon tifi nari xa pana vilaana saat siri. E ri fin na Pita e mu yaamut, “Ai, mu timaam, maam taa vil a so?” ");
INSERT INTO leu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Na Pita a sui nari, “Mi taa muluk a maana vilaana saat simi e mi taa puk a lamonan saat simi. E nami xapiak mi taa fasufan lapaana isi Yesus talo a Piran i taa lamon tapin a maana vilaana saat mi fo mo vile. E mui, mi taa siak a tatavai sina Piran aava Vovau Xaradak. ");
INSERT INTO leu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","A kuus fanaian aanabeꞌ ve xami e mu rafulak simi e xana mu rabuna la mu bina xapiak aava Piran a siak fati nari xena namkai.” ");
INSERT INTO leu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","E mui na Pita a nung faagutan nari e a kuus, “Fakaxup nano sang xasena fakasanaman aava i taa savat lumui xuluna mu rabuna saat.” ");
INSERT INTO leu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","E voxo nari aava ri kuus turoxo pana ferawaian si Pita, ri fasufan. E a xakatan iri fexaxaas sena 3,000. ");
INSERT INTO leu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Lavaxa, ri waan xuvul pana mu yaamut xena siaxaana masaman. Ri fangaasik e ri fangan faxuvul e ri fenung xe sina Piran lana waanan siri. ");
INSERT INTO leu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","A mu rabuna xapiak ri ipul sena maana mo faꞌipul e maana mo ina gutan aava mu yaamut ri vesane. ");
INSERT INTO leu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","A mu rabuna aava ri namkai, ri taagul xuvul e ri femiraaxan a maana mo siri. ");
INSERT INTO leu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ri faasot pana maana mo siri e ri maa lisan a faat ina xena xavang nari aava ri piau ta faat. ");
INSERT INTO leu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","La maana yaan ri taxa lo faxuvul pe la tang lifu lotu e ri fangan xuvul pe la lifu siri pana vilau roxo. ");
INSERT INTO leu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ri kuus fati a isina Piran pana merawan. E xasano rabuna ri faamamaas pana vilaana siri. A Piran i taxa lo falak a xakatan iri la maana yaan. ");
INSERT INTO leu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Saxa yaan faasilak leaaf, la 3 oklok, na Pita nare Jon re taxa laak xe lana tang lifu lotu xena fenung xe sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pave la matana vaabat lava ina tang lifu lotu aava ri xalie pana Yalaxau Magaaf, a toxan a maalapen. Nane toxane ti la modaxan sina e la maana yaan xapiak saxanu tuvaat ri fuuna yaase xe la Yalaxau Magaaf aave e faneie pave xena nung faat sina rabuna aava ri taxa laak xena naangus. ");
INSERT INTO leu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Layaan nane xalum na Pita nare Jon re taxa laak vaxa, nane fin nare panꞌ ta faat. ");
INSERT INTO leu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","E na Pita xuvul pa Jon re xalum fatateaxe e na Pita a xuuse, “Xalum fatateak nemaame.” ");
INSERT INTO leu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","E voxo, a maalapen a xalum fatateak nare senaso nane lamon o re taa tavaie pana saxa mo. ");
INSERT INTO leu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","E mui na Pita a kuus laa, “Ne pi ta faat, taasaxa ne taa tavai nano pana xasa mo, lana gutan ina isi Yesus Krais ti Nasaret— sangas.” ");
INSERT INTO leu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","E na Pita a tao a pamamuaan sina mataa aave e xavang fatiginei a maalapen. E fataapus, a ro kana xapiak re fo roxo. ");
INSERT INTO leu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nane xo tigina faroxo e sangas tapang xolai. Nane sangas e lalaas faagut e a kuus fati a isina Piran. E mui, nane laak xe la tang lifu lotu xuvul pa Pita nare Jon. Nane sangas e lalaas e kuus fati a isina Piran. ");
INSERT INTO leu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","A mu rabuna pe la lifu aave ri xalum nane taxa sangas xolai e kuus fati a isina Piran. ");
INSERT INTO leu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","E ri xalum taraxali nane a mataa tamu maalapen aava fuuna nai la Yalaxau Magaaf xena fenung faat xe sina rabuna. E nari, ri ipul faagut e ri pangaa senaso ri pife texaas o nane a roxo malaafaa. ");
INSERT INTO leu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Lavaxa, a mataa tamu maalapen i taxa doxot xolan na Pita nare Jon e a mu rabuna ri ipul faagut e ri falapukmaan xe sirutul lana saxa nobina ina tang lifu lotu aava ri xalie pana Bina si Solomon. ");
INSERT INTO leu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Layaan na Pita a xalum a ipulan sina mu rabuna, nane xuus nari, “Mu Israel, senasou mi xalum fatateak nemaatul? Naak mi lamon o maame fo vil fasasangas a mataa aanabeꞌ pana gutan o roxoyan simaame, bo? Piau! ");
INSERT INTO leu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","A Piran si Abrahem, Aisaak e na Yaakop ve a Piran sina mu butaara, nane tavai a sisiak sina, na Yesus, pana isin lava layaan nane fatatoi faꞌulie ti la maatan. Nami, mi tavai a mu paamua simi pana xena punuxaana. E na Pailat, a memai ti Rom, nane tafo mulus tapine, taasaxa mi bai. ");
INSERT INTO leu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Na Yesus naang, a vilaana sina a xaradak, taasaxa mi baiane. Mi fin na Pailat o i taa mulus tapin a saxa mataa ina punuk mataa la vepen sina. ");
INSERT INTO leu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","E mi punuk a mataa aava tavai netaara pana toyan tuuna, taasaxa Piran a fatatoi faꞌulie ti la maatan. E maam xalum tuuneie. ");
INSERT INTO leu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","A mataa aanabeꞌ xo, a mataa tamu maalapen aava mi texaas sena, a gutan si Yesus a vil faroxoie. Lana gutan e namkaian se Yesus, a mataa aanabeꞌ i taxa tigina faroxo la matami. ");
INSERT INTO leu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Naboxo mu fetinan, ne texaas o nami e mu paamua simi, mi fo vil a mo mosaat aanabeꞌ lana vungutan simi. ");
INSERT INTO leu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Taasaxa lumua, a mu rabuna ina kuus fatuxai ri fo kuus o a Mataa Failai sina Piran i taa maasak faagut.” E tanin a mo aanabeꞌ fo savat tuuna la matavas. ");
INSERT INTO leu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","E voxo tanin, muluk a vilaana saat simi e puk a lamonan simi talo a Piran i taa lamon tapin a maana vilaana saat simi e a Yaan ina Fangaafusan Tuuna i taa savat sena Memai ");
INSERT INTO leu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","e a Piran i taa feng a Mataa Failai, na Yesus aava nane fo siak fatie, xe simi. ");
INSERT INTO leu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Taasaxa nane xo taa waan la xunavata fefexaxaas a yaan a Piran i taa vil fafaꞌui a maana mo xapiak malaan sena mu rabuna ina kuus fatuxai ri fo kuusan famatavase. ");
INSERT INTO leu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Na Moses aava mataa ina kuus fatuxai sait, a kuus pa Yesus malaan: ‘A Memai, a Piran simi, i taa feng fasavat a saxa mataa ina kuus fatuxai ti la palou imi malaan sena fo fengau. E a mataa aave mi taa langai faagutan a maana mo i taa xuus nami pana.’ ");
INSERT INTO leu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Naseꞌ ta rabuna ri langai pesalai, a Piran i taa ti votan nari xasena mu rabuna sina e ri taa maat.” ");
INSERT INTO leu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Aang, na Samwel e a mu rabuna ina kuus fatuxai lamina, ri fo kuusan famatavas a yaan ina savatan sina Mataa Failai sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","A mu kuus fanaian sina Piran aava mu rabuna ina kuus fatuxai ri fo mo kuusane, nari va xataara xapiak. E vaxa, a kuus fanaian sina aava nane tavai a mu bumi pana, i taa xafut netaara xapiak sait. A Piran a xuus na Abrahem pa Yesus malaan: ‘A mu rabuna xapiak la xavala ri taa siak a roxoyan sena yaya siim.’ ");
INSERT INTO leu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Layaan a Piran a siak fati a sisiak sina, nane fenge xe simi paamua. E nane taa fafaamamaas nami layaan a puk tapin nami xasena maana vilaana saat simi.” ");
INSERT INTO leu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Saxano paamua ina lotu Juda xuvul pana memai keptin sina mu rabuna ina faxatangaana tang lifu lotu e saxano Sedusi sait, ri savat si Pita nare Jon layaan na Pita taxa ferawai xe sina mu rabuna. ");
INSERT INTO leu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nari, ri marala senaso a rovaat naang re taxa lo fapiti a mu rabuna pa Yesus e to faꞌulaian ti la maatan sina. E vaxa re xuus a malila o a mu rabuna taa to faꞌulaa lamina maatan siri senaso na Yesus a to faꞌulaa. ");
INSERT INTO leu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nari mu matalava aave ri marala faagut e ri yot na Pita nare Jon. Taasaxa ngaas faasilak i rul e voxo ri timin nare lana lifu ina vipisan fefexaxaas a yaan mui. ");
INSERT INTO leu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Taasaxa maana rabuna xaves, faasilak 5,000, ri langai se Yesus e ri namkai. ");
INSERT INTO leu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","A yaan mui, a mu paamua e mu matalava xuvul pana mu rabuna ina fepitaa pana vuputkai sina Piran, ri faxuvul pe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Na Aanas, a memai priis, a taagul pave, e na Kaiafas, Jon e na Aleksanda e saxano tau Aanas, ri taagul pave sait. ");
INSERT INTO leu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nari, ri xel fasavat na Pita nare Jon e re maa tigina lanori la bina ina tiisan. Re tigina pave e saxano tau Aanas ri fin nare, “Me vil faroxoi a maalapen aanabeꞌ malaafaa? Pana so ta gutan? Lapaana gutan ina isiseꞌ?” ");
INSERT INTO leu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Na Pita, pana gutan sina Vovau Xaradak, a sui nari, “Nami, mu paamua sina rabuna e mu memai, ");
INSERT INTO leu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","tanin, mi taxa xel fatiginei nemaame sena faisok roxo maame fo vile sena maalapen aanabeꞌ e mi taxa fin nemaame, ‘Nane naboxo a roxo malaafaa?’ ");
INSERT INTO leu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Lavaxa, maame vubuk o nami e mu rabuna xapiak ti Israel, mi taa texaas o mi fo punuk na Yesus Krais ti Nasaret, taasaxa Piran a fatatoi faꞌulie ti la maatan. E lapaana gutan si Yesus naboxo a mataa naang taxa tigina la matami e fo roxo xapiak. ");
INSERT INTO leu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","A xakalayan sina Piran a ferawai pa Yesus malaan layaan i taxa kuus pana newai: ‘Nami mu rabuna ina vavesai, mi baian a wai aave taasaxa a Piran fo famati faꞌulie la vepen ina pungan fataxapiak.’ ");
INSERT INTO leu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Pi ta xasa mataa fulaa a fexaxaas sena fakaxup netaara, na Yesus sang mon. A Piran a siak fatie xena fakaxup netaara e nane sang mon a salan ina roxoyan.” ");
INSERT INTO leu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Layaan ri xalum na Pita nare Jon re pife mataut, ri ipulan a vilaana sire senaso ri texaas o nare, re pi ta texaasan, re rovaat palau mon. E mui, ri lamon faꞌuli a rovaat aave o re fo waan xuvul pa Yesus. ");
INSERT INTO leu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","E vaxa ri xalum a mataa tamu maalapen taxa tigina lanori e ri matakasam palau mon. ");
INSERT INTO leu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","E voxo, ri feng nare xe lamalei talo ri taa ferawai faxuvul. ");
INSERT INTO leu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ri fefiai, “Taara taa vil a so pana rovaat aanabeꞌ? A mu rabuna xapiak pe Jerusalem ri texaas sena mo faꞌipul molava re fo vile e taara pife fexaxaas sena kuus o a bitan. ");
INSERT INTO leu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Taara baian a xasanofuna ri taa langai sena. Lavaxa, taara taa kuus bukan nare talo re taa pife ferawai fulaa pana isi Yesus.” ");
INSERT INTO leu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","E bak, ri xel fulan nare e ri fasei faagutan nare o re taa muta ferawai o fepitaa fulaa pana isi Yesus. ");
INSERT INTO leu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Taasaxa na Pita nare Jon re sui nari e re kuus, “La matana Piran, nami sang mi lamon faati o a peraroxo naak, maame taa langai simi e pife sina Piran? ");
INSERT INTO leu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Maame taa lo ferawai pana maana mo xapiak maame fo xalume e langaie.” ");
INSERT INTO leu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Fulaa, a mu paamua ri fasei faagutan nare e mui, na Pita nare Jon re taꞌulan nari. Ri pife lamon pana fakasanamaan nare senaso a mu rabuna ri kuus faasiroxo xe sina Piran pana faisok roxo nane fo vile ");
INSERT INTO leu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","senaso a mataa tamu maalapen a toxane pana mariaas sangafilu talafaat. ");
INSERT INTO leu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Layaan na Pita nare Jon re taꞌulan a mu paamua aave, re fe xuus fatexaas a mu fesing sire pana fefasaian sina mu memai priis e mu matalava. ");
INSERT INTO leu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Layaan ri langaie, a xunus iri a faxuvul e ri fenung xe sina Piran e ri kuus, “Piran pana Gutan Xapiak, nano sang mon no fo vesan a vata, xavala, laman e a maana mo xapiak lana. ");
INSERT INTO leu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","E sena Vovau Xaradak siim no fo ferawai la ngusuna sisiak siim, na tamamaam, na Devit malaan: “Xenaso a mu rabuna aava ri pife Juda ri sarak? Xenaso a mu Israel ri lamon faagut pana mo ri vungut sena? ");
INSERT INTO leu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","A mu memai king la mu bina, ri faigotan nari xa e a mu paamua ri faxuvul xena tisui a Piran e a saxa aava nane fo noxole, a Mataa Failai sina.” ");
INSERT INTO leu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","A tuuna, na Herot nare Ponsus Pailat, a ro memai ti Rom, re fesavat sina mu Rom e mu rabuna ti Israel pe Jerusalem e ri fexuus kasam xena fasivi a Sisiak Xaradak siim, na Yesus aava nano Piran, no fo noxole. ");
INSERT INTO leu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Lana gutan e texaasan siim a so ta mo no lamon faati o i taa savat, nari xo, ri fo fasavate. ");
INSERT INTO leu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","E naboxo, Memai, langai a kasalan siri e fagut a xunus imaam, mu sisiak siim, xena kuusan fasavat a Lagasai Roxo siim. ");
INSERT INTO leu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Talangaimaan xe simaam pana gutan xena vil faroxoiaana rabuna e xena vil fasavat a mo faꞌipul e maana fakalimaanan lapaana isin sina Sisiak Xaradak siim, na Yesus.” ");
INSERT INTO leu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Lamina fenungan siri a nobina aava ri faxuvul lana a radakui e a Vovau Xaradak a fabas nari e ri fexuusan fasavat a ferawaian sina Piran pana gutan. ");
INSERT INTO leu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","A mu rabuna aava ri namkai, ri faxuvul lana lamonan e nasaman siri. Pi ta mataa felamon saxaie pana maana mo xapiak sina. Taasaxa ri femiraaxan a maana mo siri. ");
INSERT INTO leu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pana gutan molava paaliu, a mu yaamut si Yesus ri lo kuusan a to faꞌulaian si Memai Yesus e a Piran a tavai nari pana xakaavangan xatam molava sina. ");
INSERT INTO leu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Piau ta saxa la palou iri fe piau ta mo, senaso a rabuna pana maana mo xaves ri faasot pana xavala o lifu siri e siak a maana faat ina ");
INSERT INTO leu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","e ri maa tatavai pana xe sina mu yaamut. E nari, ri tavai a mu valagof pana. ");
INSERT INTO leu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Na Yosep, a saxa ti lana pabung si Livai aava ri luxe pe Saipras, i taxa waan. A mu yaamut ri xalie pana xasa isin, na Baanabas, a malasuf ina a malaan: a mataa ina fagutaana rabuna. ");
INSERT INTO leu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nane faasot pana xavala sina e tavai a mu yaamut pana mu faat xapiak ina. ");
INSERT INTO leu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Taasaxa saxa mataa, isina na Ananaias, xuvul pa naasana, na Safaira, re faasot pana saxa nexavala sire. ");
INSERT INTO leu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nane tavai a mu yaamut pana faat, taasaxa nane pife tavai nari pana faat xapiak. Nane faxarang a saxano faat e na naasana a texaas sena. ");
INSERT INTO leu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Layaan na Ananaias fe lisan a faat xe si Pita, na Pita a fine, “Ananaias, xenaso no langai si Setan talo i taa fabas a xunus ima e voxo no bit a Vovau Xaradak pana mamareiai ina xavala? ");
INSERT INTO leu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Paamuina yaan no faasot pana, a nexavala aave ve siim e lamina yaan no faasot pana, a mu faat aave ve siim. A so ta mo a valam nano e no felamon malaan e voxo no vil a vilaana saat malaanabeꞌ? No pife bit a rabuna, no fo bit a Piran.” ");
INSERT INTO leu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Layaan na Ananaias a langaie nane poxo e femaat marasaxa. Nari aava ri langaie, ri mataut faagut sena fakasanaman aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","E mui a mu xulau ri filimaan e ri maa xafute e ri yaase e ri fe xaafane. ");
INSERT INTO leu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lamina awa talatul, na naasana savat. Taasaxa pife texaas sena so ta mo fo savat se lavana. ");
INSERT INTO leu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Na Pita fine, “Nabeꞌ a faat xapiak ina xavala aava me fo faasot pana, bo?” E nane suie, “Aang, a mamareiai ina xavala movoxo.” ");
INSERT INTO leu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","E na Pita a xuuse, “Xenaso me faxuvul pana lamonan malaan? Naak rao me tafang a Vovau Xaradak sina Piran? Kaalum, a mu xulau aava ri xaafan na lavaam, naboxo ri taxa ulaamaan e ri taa xaafan nano sait.” ");
INSERT INTO leu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","E fataapus, nane poxo maat. Nari mu xulau ri tingin nane maat e ri yaase e ri fe xaafane la ta lavana. ");
INSERT INTO leu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","A mu rabuna aava ri namkai e xasano rabuna sait, ri langai sena e ri mataut faagut paaliu. ");
INSERT INTO leu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","A mu yaamut ri taxa lo vil a maana mo faꞌipul e maana mo ina gutan la palou ina rabuna. E mu rabuna aava ri namkai, ri fuuna faxuvul lana saxa nobina ina tang lifu lotu aava ri faꞌisine pana Bina si Solomon. ");
INSERT INTO leu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","E nari aava ri pife namkai xo, ri pife lalamon temasaat pana faxuvul xuvul pari, senaso ri mataut ulaa ri tamaa maat. A tuuna, ri suai faagut sena mu rabuna aava ri namkai e ri pife kawaasan a faxuvulan siri. ");
INSERT INTO leu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","E la maana yaan xapiak, a xakatan ina mu rabuna aava ri namkai, taxa lo molava et. ");
INSERT INTO leu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","A mu rabuna ti Jerusalem ri langai sena maana mo a mu yaamut ri fo vile e voxo ri siak fasavat a maana rabuna aava ri giis e ri fe famati nari la vangana salan talo a xaxaalua i Pita i taa poxo xuluri layaan i taxa sangas et e ri taa roxo fulaa. ");
INSERT INTO leu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","E a mu rabuna ti la nu bina falet la xasing vaxa ri lisanmaan a mu rabuna aava ri giis e nari aava mu vovau saat fo vao nari, xe si Pita e mu yaamut talo ri taa roxo e nari xapiak ri roxo. ");
INSERT INTO leu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","A memai priis xuvul pana mu tauna aava mu Sedusi, ri savat sina mu yaamut xena tivotanaana faisok siri. A mu paamua ina lotu ri xinaas senaso a xakatan ina rabuna aava ri namkai, taxa lo molava et. ");
INSERT INTO leu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","E voxo ri maa yot a mu yaamut e timin nari lana lifu ina fakasanaman. ");
INSERT INTO leu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Taasaxa la xunavung, a angelo sina Piran a savat siri e kas a matana lifu aave e lisan nari xe lamalei. ");
INSERT INTO leu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","E a xuus nari o ri taa falet xe la tang lifu lotu xena xuus fatexaas a mu rabuna pana toyan xe vulai. ");
INSERT INTO leu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nari, ri faxaꞌusi a kuusan sina angelo aanabeꞌ e ri laak xe lana tang lifu lotu la paanen paaliu e ri tangpat pana fepitaa fulaa. Layaan a mu paamua ina lotu xuvul pana mu tauri, nari aava ri xali nari pana Saniidrin, ri maa savat la lifu ina tiisan, ri feng a saxanofuna xe la lifu ina vipisan xena xelaana mu yaamut. ");
INSERT INTO leu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","A rabuna ina faxatang a tang lifu lotu, ri fe savat pave, taasaxa mu yaamut ri malit. Ri fe xuus fatexaas a mu matalava e memai keptin siri pana ");
INSERT INTO leu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","e ri kuus, “Maam fe savat pave la matana lifu ina vipisan e a matana xaxawa e a mu rabuna ina faxatang a lifu aave ri taxa waan. E layaan ri kase, piau ta rabuna lana.” ");
INSERT INTO leu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Layaan a mu memai priis e memai keptin ri langai a ferawaian siri, ri lalamon pana so ta mo naboxo i taa savat. ");
INSERT INTO leu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Layaan a mu matalava ri taxa fexuus, saxa mataa maa savat siri e a xuus fatexaas nari, “A mu rabuna aava mi fo yot nari lanef, ri taxa waan la tang lifu lotu laa e ri taxa fapiti fulan a rabuna.” ");
INSERT INTO leu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","A mu rabuna ina faxatang a tang lifu lotu xuvul pana memai keptin siri ri falet e ri fe xel faroxoi a mu yaamut ulaa mu rabuna aava ri taxa langai sina mu yaamut, ri tamaa marala e tamaa soxoi nari mu Saniidrin pana faat. ");
INSERT INTO leu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ri fatiginei a mu yaamut la matana mu matalava ti la Saniidrin e a memai priis a xuus nari, ");
INSERT INTO leu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Maam fo kuus bukan nami o mi muta fepitaa fulaa pana isin aanabeꞌ. Taasaxa mi fo yuuf a rabuna xaves ti Jerusalem pana fepitaian simi. Naak mi taxa vubuk timin a maatan sina mataa aanabeꞌ xulumaam, bo?” ");
INSERT INTO leu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Na Pita e mu yaamut ri sui a ferawaian siri, “Nemaam taa usi a ferawaian sina Piran e pife sina mataa malaan setaara. ");
INSERT INTO leu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","A Piran sina mu tamataara fo fatatoi faꞌuli na Yesus ti la maatan, nane aava nami fo punuxe layaan mi niile xuluna bolo. ");
INSERT INTO leu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","E a Piran a xel faneie la pamuaan sina e tavaie pana vepen xena paamuian a maana mo xapiak e faꞌisine pana Nges ina Vil Fatato talo a mu Israel ri taa toxan a yaan xena puxaana vilaana siri. E nane taa lamon tapin a mu vilaana saat siri. ");
INSERT INTO leu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nemaam xuvul pana Vovau Xaradak aava Piran a tavai a mu rabuna aava ri namkai pana, nemaam xapiak, maam xalum a maana mo aanabeꞌ e maam taxa fepitaa pana sait.” ");
INSERT INTO leu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Layaan ri langai a ferawaian sina mu yaamut ri marala faagut e ri buk punuk nari. ");
INSERT INTO leu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Taasaxa saxa Ferasi, a isina Gameliel, a mataa ina fepitaa pana vuputkai sina Piran, nane tigina la palou iri. A rabuna, ri suai sena e voxo ri fuuna langaie e nane kuus, “Feng nari xe lamalei.” ");
INSERT INTO leu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ri falet xe lamalei e mui na Gameliel a kuus, “Mu Israel, mi taa lalamon faroxo pana so ta mo mi taa vile pari. ");
INSERT INTO leu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Lumua, na Teudas a savat e a kuus o nane sang a matalava e faasilak a mu rabuna 400 ri usie. Taasaxa, xasanofuna ri punuxe e a mu rabuna aava ri usie ri tapisi fepatok e a faisok sina xo malit. ");
INSERT INTO leu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Lami Teudas, lana yaan ina fakataana rabuna, na Judas ti Galili a savat e paamuian a saxano rabuna e ri tisui a gavamen ti Rom. Nane sait, ri punuxe e a mu fangaasik sina, ri sinuf. ");
INSERT INTO leu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","E voxo, ne taa fasei nami, taꞌulan a mu rabuna aanabeꞌ. Tamo ri taxa faisok lapaana gutan sina mataa mon, malaan sena rovaat aava taara mo kuusane, a faisok siri i taa poxo. ");
INSERT INTO leu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Taasaxa tamo ri taxa faisok lapaana gutan sina Piran, mi pife fexaxaas sena faꞌonam nari senaso mi taa tingin nami xa mi taxa tisui a Piran.” ");
INSERT INTO leu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","E voxo, a mu rabuna ri langai a ferawaian si Gameliel e ri xel falak fulan a mu yaamut e ri saaxan nari. Lamina saaxanaan nari, a mu matalava ri fasei faagutan nari o ri muta fepitaa fulaa pana isi Yesus e ri feng tapin nari. ");
INSERT INTO leu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","A mu yaamut ri taꞌulan a lifu ina tiisan e ri merao. Ri texaas o a Piran a faamamaas pana vilaana siri senaso nane turoxo o nari, ri taa siak a maasaxan malaan sena vilaana a rabuna ri mo vile se Yesus. ");
INSERT INTO leu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","La maana yaan lana tang lifu lotu e la maana mu lifu sina rabuna, a mu yaamut ri taxa lo fepitaa e ri kuusan fasavat a Lagasai Roxo o na Yesus ve a Mataa Failai sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lana yaan aapave, layaan a xakatan ina rabuna aava ri usi na Yesus taxa lo laak saa, a mu Juda ti la bina Griik, ri ferawai faaxaves sena mu Juda ti Judia, senaso a lutefin nakmaal siri aava mu tomexaan siri fo maat tapin nari, ri pi sisiak faroxoi a fanganan lana yaan ina tatavai pana fanganan. ");
INSERT INTO leu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","E voxo, nari mu yaamut sangafilu saxa pana taragua, ri xel faxuvul a mu rabuna aava ri namkai e ri kuus, “Maam taa pife faisok pana tavaiaan nami pana fanganan senaso maam toxan a faisok xaves xena fepitaa pana maana ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","4","Mu fetinan, siak fati ta nu mataa pisiguak xena tavai nami pana fanganan. Mi taa fati nari aava ri bas pana Vovau Xaradak e ri masam pana vilaana roxo. E maam taa tavai nari pana ngavuk ina tatavai talo maam taa toxan a yaan fexaxaas sena fenung xe sina Piran e fapiti a mu rabuna.” ");
INSERT INTO leu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","A mu rabuna ri turoxo pana ferawaian siri e voxo, ri siak fati na Stefan, a mataa aava bas pana Vovau Xaradak e namkaian tuuna. E vaxa, ri fati na Filip, Prokos, Nikano, Timon, Pamenas e namaa Nikolas ti Antiaak, a mataa ti Griik aava puk a vilaana sina e fesavat saxa Juda sait. ");
INSERT INTO leu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mui, ri lisan a nutuvaat aanabeꞌ xe sina mu yaamut e ri xuus nari, “Nabeꞌ a nutuvaat maam fo siak fati nari pana ngavuk ina tavaiaana rabuna sitaara pana fanganan.” E a mu yaamut ri turoxo pana e ri timin a mari la putuna nutuvaat pisiguak aanabeꞌ e ri fenung xe sina Piran pari. ");
INSERT INTO leu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","E voxo, a ferawaian sina Piran a fala fepatok fataapus e a xakatan sina mu rabuna aava ri usi na Yesus taxa lo laak fataapus. E mu paamua xaves ina lotu Juda sait, ri puk a lamonan siri e ri usi a vilaana si Yesus. ");
INSERT INTO leu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Na Stefan aava bas pana xakaavangan xatam e gutan sina Piran, a vil a maana mo faꞌipul e mu faisok ina gutan la palou ina mu rabuna. ");
INSERT INTO leu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Taasaxa saxano rabuna Juda ti Aleksandria e Sairiin, nari aava ti lana lifu ina faxuvulan ri xali nari pana ‘nari aava ri tamu sisiak’, nari xuvul pana xasano Juda ti Silisia e Esia, ri fegagelai xuvul pa Stefan. ");
INSERT INTO leu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Taasaxa ri pife fexaxaas sena tisuie senaso nane ferawai pana texaasan lapaana gutan sina Vovau Xaradak. ");
INSERT INTO leu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","E voxo, ri maraan fun a saxano rabuna e ri xuus nari malaan, “Mi taa falet e mi taa fe kuus o mi fo langai nane suaxan na Moses e a Piran.” ");
INSERT INTO leu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ri fe kuus malaan e a ferawaian aanabeꞌ a vil fatamasiak a maraleian sina mu rabuna e mu matalava e a mu rabuna ina fepitaa. E ri yot na Stefan e ri fe fatigineie lana lifu ina tiisan. ");
INSERT INTO leu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ri xel fasavat a rabuna ina kuus xakaavang bit e nari, ri bit tifi na Stefan e ri kuus, “A mataa aanabeꞌ taxa lo ferawai fasaat vulai sena tang lifu lotu aanabeꞌ e sena vuputkai si Moses. ");
INSERT INTO leu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","E vaxa maam langai nane kuus o na Yesus ti Nasaret i taa kawaasan a bina aanabeꞌ e i taa puk a maana vilaana na Moses fo xuus netaara pana.” ");
INSERT INTO leu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nari aava ri taxa nai la lifu ina tiisan, ri xalum fatateak na Stefan senaso ri xalum a nonau ina a rarapak malaan sena angelo. ");
INSERT INTO leu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","E mui a memai priis a fine, “A ferawaian aanabeꞌ a tuuna, bo?” ");
INSERT INTO leu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","E na Stefan a suie, “Mu fetinan e mu matalava, langaiau. A Piran Pana Miridingan Molava a savat xe si tamataara, na Abrahem, layaan nane waan pe Mesopotemia, paamuina waanan sina pe Haran. ");
INSERT INTO leu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","E a Piran a xuuse, ‘Taꞌulan a bina aanabeꞌ e mu rabuna siim e no paan xe la bina aava ne taa faxalit nano pana.’ ");
INSERT INTO leu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“E voxo, na Abrahem a tamasiak e taꞌulan a bina Saaldia aava waan pe Mesopotemia e fe taagul pe Haran. Lumui lamina maatan si tama Abrahem, a Piran a fenge xe la bina aanabeꞌ aava mi taxa taagul lana tanin. ");
INSERT INTO leu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Nane pife tavai na Abrahem pa ta xavala o maana mo, taasaxa nane kuus fanai xe sina o nane e a mu buna lamina, ri taa toxan a xavala aanabeꞌ. Naapalaan lana yaan aapave na Abrahem pi ta lak lunai. ");
INSERT INTO leu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","A Piran a xuuse malaan, ‘A mu bum, ri taa waan la bina patak malaan sena mu topen e ri taa sisiak pave. E a mu paamua ina bina aave ri taa vil pengan nari fefexaxaas a mariaas 400 fo taxapus.’ ");
INSERT INTO leu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","A Piran a kuus fulaa, ‘Taasaxa, ne taa fakasanam a rabuna aava ri fayaasok a mu Juda. E lumui a mu Juda ri taa taꞌulan a bina aave e ri taa filimaan xe siak e ri taa nangus nenia nabeꞌ.’ ");
INSERT INTO leu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","E vaxa a Piran a tavai na Abrahem pana vilaana ina vuputuk sait. A vilaana aanabeꞌ a faxaalit o na Abrahem a turoxo pana kuus fanaian sina Piran. Na Abrahem a fasavat a lak tuaan sina, na Aisaak. E lamina luluuxan sina, la fapisiktulaana yaan, na Abrahem a usi a ferawaian sina Piran e a putuk na natuna. E lumui na Aisaak a fasavat na Yaakop e na Yaakop a fasavat a mu rafulak tomexaan sangafilu saxa pana taragua. Nari ve ri tamana mu pabung ti Israel. ");
INSERT INTO leu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“A mu tamana Israel ri xinaasan a tiri, na Yosep, e ri faasot pana xe sina rabuna ti Isip. Pave, nane sisiak siri, taasaxa lana yaan aapave, a Piran a waan xuvul pana ");
INSERT INTO leu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","e xavange lana maana lagafan sina. Nane tavai na Yosep pana texaasan molava e voxo a siak a roxoyan sina piran king ti Isip, na Fero. E lumui a piran king aave a siak fatie xena faxatangaana maana mo sina. ");
INSERT INTO leu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“E mui, a song molava a savat lana bina Isip e Kenan. A mu matalava sitaara ri lagaf paaliu pana sengaana fanganan. ");
INSERT INTO leu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Layaan na Yaakop a langai o ri toxan a fanganan pe Isip, nane feng a mu tamataara xe pave. ");
INSERT INTO leu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","La fataraguiaana ulaian siri xe pe Isip, na Yosep a xuus fatexaas a mu tina o nane ve a saxa ti la palou iri. E vaxa na Fero a siak a texaasan sena mu matafetama si Yosep. ");
INSERT INTO leu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","E lumui, na Yosep a fefeng pa tamana, na Yaakop, e a mu tina xuvul pa ninari. Nari xapiak, ri sangafilu pisiguak pana pama. ");
INSERT INTO leu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Na Yaakop xuvul pana mu pabung sina, ri sivi xe kolapi Isip e ri fetaagul pave fefexaxaas sena yaan ri matalava e ri maat pave. ");
INSERT INTO leu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","E ri lisan a vipin siri xe pe Sekam e xaafanan pave lana saxa liing ina mamaat aava na Abrahem fo maraan faneie xasena matafetuaan si Amor pana saxano faat. ");
INSERT INTO leu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“A mariaas 400 fo falet xo e faasilak la yaan a Piran taa fasavat a kuus fanaian sina xe si Abrahem, a xakatan sitaara pe Isip femolava piis. ");
INSERT INTO leu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","A xasa piran king patak aava pife texaas se Yosep a paamuian na Isip. ");
INSERT INTO leu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","E nane vil pengan paaliuan a mu rabuna sitaara e a xuus faagutan a mu butaara o layaan ri taa luk a mu popo ri taa tapin nari talo ri taa maat. ");
INSERT INTO leu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“La yaan aave na nina Moses a luxe e nane pife nelak palau mon. Pana fulun talatul ri faxatange pe lana lifu si tamana. ");
INSERT INTO leu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","E layaan ri timine pe lamalei a lak tefin si Fero a tingine e faxatange malaan sena lak tuuna sina. ");
INSERT INTO leu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ri fapiti na Moses pana maana texaasan xapiak ti Isip fefexaxaas nane matalava lana ferawaian e vilaana sina. ");
INSERT INTO leu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Layaan a mariaas sangafilu talafaat sina a savat, nane vubuk rao i paan i ti xalum a mu tina aava mu Juda. ");
INSERT INTO leu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na Moses a xalum a saxa Isip aava vil pengan a saxa Juda e voxo nane ti votan a Juda e nane xa punuk a saxa Isip aave. ");
INSERT INTO leu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","E na Moses a lamon o a mu rabuna sina ri taa texaas o a Piran fo fenge xena xavangaan nari, taasaxa ri pife texaas sena. ");
INSERT INTO leu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","A yaan mui na Moses a falet e fe savat sina ro Juda aava re taxa fevis. Nane vubuk rao i taa fadaarum nare e voxo a xuus nare, ‘Name, me ro fetinan mon, xenaso rao me fesopan name?’ ");
INSERT INTO leu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Taasaxa saxa Juda aava vil pengan a xasafuna, a sasagen tapin na Moses e a kuus, ‘Naseꞌ fo siak fati nano xena paamuian nemaam? ");
INSERT INTO leu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Naak rao no punuxau malaan sena saxa Isip lanef?’ ");
INSERT INTO leu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Layaan na Moses a langaie a mataut e sinuf fataapus xe pe Midian e fe taagul pave malaan sena saxa topen. A tamai pave e a fasavat a ro lak tomexaan taragua. ");
INSERT INTO leu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Lamina mariaas sangafilu talafaat fe taxapus e na Moses a toxan a mariaas sangafilu pisiktul, a angelo a savat sina lana radaam ina fata, lana nolatan pe la xobingil la tana Put Sainai. ");
INSERT INTO leu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Layaan na Moses a xalume, a ipulan a xakaaluman ina. E a falet faasilak rao i xalum faroxoie e a langai a ling i Piran a kuus, ");
INSERT INTO leu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nenia ve a Piran sina mu bum, a Piran si Abrahem, na Aisaak e namaa Yaakop.’ Na Moses a radakui pana matautan e a bai kaalum. ");
INSERT INTO leu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“A Piran a seie, ‘Siak tapin a ro ‘slipa’ siim. A bina aamove no taxa tigina lana, a bina failai. ");
INSERT INTO leu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ne fo xalum tuunei a vilaana saat aava ri vile xe sina mu rabuna siak pe Isip. E ne fo langai a taangiisan siri e naboxo ne sivimaan xena mulus tapin nari. Filimaan faasilak, ne vubuk o ne taa feng faꞌuli nano xe pe Isip.’ ");
INSERT INTO leu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Na Moses aanabeꞌ ve a saxa naang aava mu Juda fo tisuie e ri kuus, ‘Naseꞌ fo siak fati nano xena paamuian nemaam?’ A Piran fatak xa a siak fati na Moses e a fenge xena paamuian nari e mulus tapin nari. E a angelo aava savat la nolatan aave a xuus fatexaase pana. ");
INSERT INTO leu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nane a paamuian fasavat nari ti pe Isip e a fasavat a maana mo faꞌipul e maana faisok ina gutan pe Isip e la tana Taas Vung e pana mariaas sangafilu talafaat fulaa lana bina vingil. ");
INSERT INTO leu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Na Moses naang a xuus a mu Israel, ‘A Memai, a Piran simi, i taa feng fasavat a saxa mataa ina kuus fatuxai ti la palou imi malaan seꞌ nane fo fengau. E i taa fenge xe simi.’ ");
INSERT INTO leu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Na Moses a waan xuvul pana mu Israel pe la xobingil. Nane waan xuvul pana mu butaara e xuvul pana saxa angelo laaꞌui la Put Sainai. E a Piran a tavaie pana lagasai ina toyan xataara. ");
INSERT INTO leu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Taasaxa langaiau, a mu butaara, ri fo fepalauan a ferawaian sina. E ri gigirane e lana lamonan siri ri lamon faꞌulaa xe pe Isip. ");
INSERT INTO leu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ri xuus na Eron, na ti Moses, malaan, ‘Vesan ta piran xena paamuian netaara. Na Moses aava paamuian netaara ti pe Isip, maa vungut sena pevoxo fo falet. Taara vungut o a so ta mo a savat sina.’ ");
INSERT INTO leu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Lana yaan aave ri vesan a maaradaang ina bulmakau e ri tatavai xe sina pana fanganan. E ri vesan a matafanganai xena faamamaas pana mo aava nari xa ri fo vesane. ");
INSERT INTO leu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","E a Piran a ti taaluugan nari. E voxo, ri nangus a mu vapara e xasano maana mo malaan. E nabeꞌ a turoxo pana xakalayan sina mu rabuna ina kuus fatuxai. ‘Ai, mu Israel, naak mi fo tatavai xe siak pana maana fanganan e meska lana vingil pana mariaas sangafilu talafaat? ");
INSERT INTO leu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Piau! Nami, mi nangus a piran vavesai simi, na Molok e a piran vapara, na Refan. Mi yaas nare xuvul pami lana faletan simi e voxo ne taa feng tapin nami malaan sena topen xe lumui lamina bina Babilon.’ ");
INSERT INTO leu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“A mu butaara ri toxan a lifu marapi ina naangusan xuvul pari pe la vingil. Ri fo vesane malaan sena xaxaalua aava Piran a tavai na Moses pana. ");
INSERT INTO leu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Lumui, layaan na Jaasua taxa paamuian nari, a mu butaara ri lisan a lifu marapi ina naangusan aanabeꞌ e ri faaguun xolai pana fefexaxaas sena yaan a Piran a xup tapin a mu xaiyaas siri e tavai nari pana xavala ina kuus fanaian. E a lifu marapi aave a waan lana bina aapave fefexaxaas sena yaan si Devit. ");
INSERT INTO leu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Na Devit aava Piran a turoxoiane, a fin a Piran o lana vubuxanan sina i taa vesan taxana Piran si Yaakop ta lifu lotu tuuna malaan. ");
INSERT INTO leu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Taasaxa, na Solomon, na natu Devit, fo vesan tavai a Piran pana lifu aave. ");
INSERT INTO leu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Taasaxa a Piran Laaꞌui Paaliu a pife taagul lana lifu aava mu rabuna ri vesane, bo? Nane fo kuus pana la ngusuna mu rabuna ina kuus fatuxai malaan: ");
INSERT INTO leu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘A xunavata pave a vepen ina nai piranan siak e a xavala a vavena vaapaasan siak. A so ta buk lifu mi vubuk vesan tavaiau pana? A so ta buk nobina mi vubuk o ne taa nai fangaafus lana? ");
INSERT INTO leu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nenia sang ne vesan a maana mo xapiak aanabeꞌ bo?” ");
INSERT INTO leu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","E na Stefan a ferawai fulaa, “Nami ve mi rabuna vaang bit. A lamonan simi a tavanat. Mi usi a vilaana sina Piran e mi putuk nami taasaxa mi pife usi soxot a Piran sang mon. Vulai nami, mi vile malaan sena mu bumi, mi taaluugan a Vovau Xaradak. ");
INSERT INTO leu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","A mu bumi ti kavai ri vil pengan a mu rabuna ina kuus fatuxai saxa saxa, bo? E ri punuk nari aava ri kuusan fasavat a filimaanan sina Sisiak Xaradak sina Piran aava na Yesus. E naboxo, nami, mi malaan seri, mi pet lisane e mi punuxe. ");
INSERT INTO leu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nami xo, mi toxan a vuputkai sina Piran aava mu angelo fo tavai nami pana taasaxa mi pife usie.” ");
INSERT INTO leu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","E nari, ri langaie e ri marala e ri faxakengatan a fari. ");
INSERT INTO leu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Taasaxa na Stefan aava bas pana Vovau Xaradak, a kaalum xe laaꞌui e xalum a miridingan molava ina Piran e na Yesus i taxa tigina la pamuaan sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","E na Stefan a kuus, “Kaalum, ne kaalum saa e ne xalum a xunavata a talakas e a Natuna Mataa i taxa tigina la pamuaan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sena ferawaian aanabeꞌ a mu paamua ri marala faagut e vil votan a tangari, ri taxa xukulai faagut temasaat e ri faloue. ");
INSERT INTO leu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ri raagan fasavat na Stefan xe lamalei e ri soxoie pana faat. E voxo, nari aava ri taxa ti kaalum, ri mul fanai faxuvul a maana marapi ina vupungan siri la kana saxa mataa faꞌui, a isina, na Sol. ");
INSERT INTO leu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Layaan ri taxa soxoi na Stefan pana faat nane fenung xe sina Piran e a kuus malaan, “Memai Yesus, siak a vovau siak.” ");
INSERT INTO leu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Lumui nane bukaak e poxo turung xe lapia e a kuus faagut, “Memai, muta sui pengan nari.” E lumui nane poxo e femaat. ");
INSERT INTO leu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Na Sol a turoxo pana maatan si Stefan. La yaan aapave a lagafan molava a savat xe sina mu rabuna aava ri namkai. E voxo ri sinuf fepatok xe la mu bina xapiak pe lana Judia e Sameria. Taasaxa mu yaamut ri waan pe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Saxano rabuna sina Piran ri xaafan na Stefan e ri tangiis a mamaat sina. Pevoxo. ");
INSERT INTO leu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Taasaxa na Sol fe yot a mu rabuna aava ri namkai, a mu tomexaan e lutefin, e raagan nari ti lana lifu siri e timin nari lana lifu ina vipisan rao i taa kawaasan a lotu siri. ");
INSERT INTO leu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Taasaxa nari aava ri falet xolai xe la mu bina, ri taxa lo kuusan fasavat a Lagasai Roxo se Yesus. ");
INSERT INTO leu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","A saxa ti la palou iri, na Filip, a sivi xe puaa la saxa bina pe Sameria e a tangpat pana fepitaa pave pana Mataa Failai sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Layaan na Filip a ferawai xe sina malila pave, ri langai faagut senaso nane fo vil a maana mo faꞌipul xaves. ");
INSERT INTO leu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nane gei tapin a maana vovau saat e vil faroxoi a saxano maalapen. ");
INSERT INTO leu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","E voxo, a toxan a faamamaasan lava lana bina aapave. ");
INSERT INTO leu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","A saxa mataa ina neng, isina na Saimon, a waan pe la bina aave e a faꞌipul a mu Sameria pana gutan sina. Nane ferawai falalava o nane saxa matalava pana gutan. ");
INSERT INTO leu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","A mu rabuna xapiak, ri langai sina e ri kuus, “A mataa aanabeꞌ ve a siak a gutan sina piran aava ri xalie pana ‘Gutan Molava Paaliu.” ");
INSERT INTO leu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ri usie senaso maana yaan xaves nane vil faꞌipul nari pana gutan sina. ");
INSERT INTO leu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Taasaxa layaan a mu rabuna ri langai a ferawaian si Filip pana fatataganan sina Piran e isi Yesus Krais, a mu rabuna tomexaan e lutefin xapiak ri namkai e ri fasufan. ");
INSERT INTO leu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Na Saimon sait a namkai. Lamina fasufan sina nane waan faasilak la ta Filip senaso nane ipul sena maana fakalimaanan e maana mo faꞌipul aava nane xalume. ");
INSERT INTO leu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Layaan a mu yaamut pe Jerusalem si ri langai o a mu Sameria ri namkai sena ferawaian sina Piran, ri feng na Pita nare Jon xe siri. ");
INSERT INTO leu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lamina savatan sire, re fenung xe sina Piran talo nane taa tavai a mu Sameria pana Vovau Xaradak sina. ");
INSERT INTO leu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","A Vovau Xaradak a pife sivimaan xuluri lunai. Ri fo fasuf nari pana isi Yesus Krais mon. ");
INSERT INTO leu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","E mui, na Pita nare Jon re timin a mare xuluri e a mu rabuna aave ri siak a Vovau Xaradak. ");
INSERT INTO leu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Layaan na Saimon a kaalum o a rabuna ri fo siak a Vovau Xaradak layaan a ro yaamut re timin a mare xuluri, nane tavai nare pana faat e a kuus, ");
INSERT INTO leu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Tavaiau pana gutan aave sait talo ne taa timin a maak xuluna rabuna e ri taa siak a Vovau Xaradak.” ");
INSERT INTO leu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","E na Pita a suie, “Falet saa pana xama faat aave senaso no lamon o no fexaxaas sena maraan a tatavai sina Piran pana. ");
INSERT INTO leu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","No piau ta nobina lana faisok aanabeꞌ senaso a lamonan siim a pife roxo la matana Piran. ");
INSERT INTO leu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Xul a lamonan siim aava rao no taa maraan a tatavai sina Piran e fenung xe sina. Naak i taa muluk nano e taa lamon tapin a lamonan saat siim. ");
INSERT INTO leu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ne texaas o nano, no bas pana xinaasan e no sisiak sina mo mosaat.” ");
INSERT INTO leu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","E mui na Saimon a suie, “Fenung xe sina Piran paga talo maana mo aava no fo kuus pana ri taa pife savat tuuna xe siak.” ");
INSERT INTO leu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Layaan re fo xuus fatexaas nari pana faisok sina Piran lana toyan sire e re ferawai pana lagasai si Memai, na Pita nare Jon re ulaa xe pul Jerusalem. La fena ulaian sire, re fepitaa pana Lagasai Roxo lana maana mu bina pe Sameria. ");
INSERT INTO leu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Na Filip taxa waan pe Sameria lunai e saxa angelo a xuuse, “Tamasiak e no paan xe pul la salan aava falet xe pe Gasa ti Jerusalem, a salan lana xobingil.” ");
INSERT INTO leu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nane tamasiak e falet. E pave a fesuai pana saxa mataa ti Itiopia aava i taxa ulaa xe la bina sina. Nane a matalava aava fuuna faxatang a maana mo xapiak sina piran tefin lava sina mu Itiopia, ri xalie pa Kaadis. A mataa aanabeꞌ fo falet xe Jerusalem xena nangus a Piran. ");
INSERT INTO leu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","La fena faletan sina xuluna ‘kaaris’, i taxa nai kat falavai a xakalayan si Aisaia, a mataa ina kuus fatuxai sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","A Vovau Xaradak a xuus na Filip, “Falet xe la ‘kaaris’ aapave e no waan faasilak la tana.” ");
INSERT INTO leu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","E mui, na Filip a falet faasilak la tana ‘kaaris’ e a langai a mataa taxa kat a xakalayan si Aisaia. E na Filip a fine, “No masam sena maana mo no taxa kate?” ");
INSERT INTO leu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","E nane suie, “Ne taa texaas malaafaa tamo ne pi ta mataa xena xuus famatavasau pana?” E voxo nane xel falak na Filip e fe nai xuvul pana. ");
INSERT INTO leu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","A mataa Itiopia ve i taxa kat a paxakalayan sina Piran aanabeꞌ: “Nane malaan sena sipsip aava waan kasam layaan ri lisane xe lana bina ina punuxaana o malaan sena sipsip aava waan kasam layaan ri taxa sapiit a fui ina. ");
INSERT INTO leu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nane famangilan e ri pife tafang faroxoie lana lifu ina tiisan. E i taa piau taa buna senaso a toyan sina fo taxapus nabeꞌ la pia.” ");
INSERT INTO leu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","A mataa Itiopia a fin na Filip, “Xuus fatexaasau, a mataa ina kuus fatuxai i taxa ferawai paseꞌ, nane fatak o xasa mataa fulaa?” ");
INSERT INTO leu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","E mui na Filip a tangpat pana ferawaian aave e a xuus fatexaase pana Lagasai Roxo se Yesus. ");
INSERT INTO leu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Layaan re taxa faxaꞌusi et a salan, re savat la xasing ina raarum e a mataa Itiopia a kuus, “Kaalum, a raarum. Xenaso ne taa pife fasufan xo?” ");
INSERT INTO leu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Na Filip a xuuse, “No taa fasufan tamo no namkai lana xunus ima.” E nane suie, “Ne namkai o na Yesus Krais ve a Natuna Piran.” ");
INSERT INTO leu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","A matalava aave a sei fatiginei bang a ‘kaaris’ sina e nare Filip re sivi xe lana raarum pave. E na Filip a fasufe. ");
INSERT INTO leu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Layaan re laak ti lana raarum, fataapus, a Vovau ina Piran a siak tapin moxo na Filip e a mataa Itiopia pife xalum fulane taasaxa nane falet fulaa pana faamamaasan. ");
INSERT INTO leu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Na Filip xo a savat pe Asotus e a falet xe Sesaria. E la fena sangasan sina nane kuusan fasavat a Lagasai Roxo la maana mu bina xapiak. ");
INSERT INTO leu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Taasaxa na Sol i taxa lo vubuk faagut o i taa punuk a mu rabuna aava ri usi a Memai. E voxo nane savat sina memai priis ");
INSERT INTO leu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","e fine rao i taa kuus turoxo pana faletan sina xe puaa Damaaskas. Nane vubuk o i taa yot a mu rabuna tomexaan e lutefin aava ri usi a lotu faꞌui aanabeꞌ xena lisanmaan nari xe pe Jerusalem. E a memai priis a tavaie pana lagasai ina turoxoian xena tavai a mu rabuna Juda lana mu lifu ina faxuvulan pe Damaaskas. ");
INSERT INTO leu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Lana sangasan sina xe puaa Damaaskas, a yaamit a sivi faꞌipul e fakaliuan nari. ");
INSERT INTO leu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","E nane poxo xe lapia e langai a ling a xuuse, “Sol, Sol, xenaso no vil penganau.” ");
INSERT INTO leu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Na Sol a fiai, “Memai, nano naseꞌ?” A ling aave a suie, “Nenia ve na Yesus aava no taxa vil pengane. ");
INSERT INTO leu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Naboxo, tamasiak e no falet xe pe Damaaskas e pave ri taa xuus fatexaas nano pana so ta mo no taa vile.” ");
INSERT INTO leu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","A mu rabuna aava ri taxa sangas xuvul pa Sol, ri tigina xapat senaso ri langai a ling taasaxa ri pife xalum ta mataa. ");
INSERT INTO leu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Na Sol a tamasiak ti lapia, taasaxa layaan nane rao i kas a matana, a matana piif. E voxo ri tao a mana xe pe Damaaskas. ");
INSERT INTO leu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Pana yaan talatul nane piif e la nu yaan aave a pife fangan o num. ");
INSERT INTO leu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Pe Damaaskas a toxan a saxa mataa aava usi a vilaana si Yesus, a isina na Ananaias. A Memai a savat xe sina lana saxa xaxaalua e kuus, “Ananaias!” Nane suie, “A so Memai, nenia nabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","E a Memai a xuuse, “Falet xe la lifu si Judas, lana salan aava ri xalie pana ‘xaradak’ e no fiai pana saxa mataa ti Taasus, a isina na Sol, senaso nane taxa fenung. ");
INSERT INTO leu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Lana saxa xaxaalua nane fo xalum a mataa, a isina na Ananaias, e nane xo maa timin a ro mana xuluna xena lisan faꞌuli a xakaaluman sina.” ");
INSERT INTO leu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Na Ananaias a suie, “Memai, ne fo langai a maana ferawaian sena mataa aanabeꞌ e malaafaa nane famasak a mu rabuna fatak siim pe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","E nane savat iau lapaana tateaxan ina mu paamua ina lotu Juda xena yotaana mu rabuna aava ri fenung xe siim.” ");
INSERT INTO leu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Taasaxa a Memai a xuus na Ananaias, “Falet, ne fo siak fati a mataa aanabeꞌ xena sisiak siak e i taa lisan a texaasan sena isaak xe la maana mu bina sina mu rabuna aava ri pife Juda e xe sina mu piran siri e xe sina mu Israel. ");
INSERT INTO leu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ne taa faxalite pana maasaxan molava aava i taa savat sina sena faisok lapaana isaak.” ");
INSERT INTO leu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","E mui na Ananaias a falet xe la lifu aave e a laak lana xena timin a ro mana xulu Sol e a kuus, “Tiak Sol, na Memai Yesus aava savat xe siim la salan layaan no taxa filimaan xe iau, nane fengau talo no taa kaalum fulaa e no taa bas pana Vovau Xaradak.” ");
INSERT INTO leu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","E a mo malaan sena xunuf ina din a faapalau faꞌipul sena mata Sol e nane moxo kaalum faroxo fulaa. Nane tamasiak e a fasufan ");
INSERT INTO leu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","e mui a fangan. E lamina fanganan nane siak fulan a gutan sina. Na Sol a taagul pe Damaaskas pana valayaan xuvul pana mu rabuna aava ri namkai. ");
INSERT INTO leu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nane falet fatak xe la mu lifu ina faxuvulan e a fapiti nari o na Yesus ve a Natuna Piran. ");
INSERT INTO leu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","E a maana rabuna aava ri langaie, ri ipul e ri fiai, “Nane a saxa aava pe Jerusalem a punuk a mu rabuna aava ri namkai sena isin aanabeꞌ, bo? Nane savat nabeꞌ xena yot lisan a mu rabuna aave xe sina mu paamua priis, bo?” ");
INSERT INTO leu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Taasaxa, a fepitaian si Sol taxa lo savat faagut paaliu. E na Sol a faxalit tuunei nari o na Yesus ve a Mataa Failai e a mu Juda pe Damaaskas ri pife fexaxaas sena tisuie. ");
INSERT INTO leu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","A maana yaan xaves fo falet e a mu Juda ri fexuus kasam xena punuxaana. ");
INSERT INTO leu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","La maana paanaas e vung ri falim a yalaxau ina bina xena punuxaana. Taasaxa, na Sol a texaas sena lamonan siri. ");
INSERT INTO leu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","E la saxa vung a mu fesing si Sol ri xele e ri faduie lana bi xe lamina vaabat ina bina. ");
INSERT INTO leu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Layaan nane savat pe Jerusalem a vubuk faxuvul xuvul pana mu rabuna aava ri namkai taasaxa nari, ri matautane senaso ri lamon o nane pife puk tuunei a vilaana sina. ");
INSERT INTO leu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Taasaxa na Baanabas a xel lisane xe sina mu yaamut e xuus fatexaas nari pana malaafaa a Memai fo savat tuuna si Sol la fena sangasan sina e ferawai sait xe sina e vaxa, malaafaa na Sol a pife mataut pana kuusanaana isi Yesus pe Damaaskas. ");
INSERT INTO leu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","E voxo na Sol a taagul xuvul pari e a falet xolai xena kuus fasavat lapaana isi Memai. ");
INSERT INTO leu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nane ferawai e tisui a mu Juda ti Griik e voxo nari sait, ri buk punuxe. ");
INSERT INTO leu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Layaan a mu fetinan ri texaas sena, ri xel lisane xe kolapi Sesaria e mui ri fenge xe puaa Taasus. ");
INSERT INTO leu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","E voxo a mu rabuna aava ri namkai pe Judia, Galili e Sameria, ri toxan a fangaafusan sena lagafan siri. Ri fegutai lana namkaian siri, ri suai faagut sena Piran e senaso a Vovau Xaradak a fagut nari, a xakatan iri taxa lo molava et. ");
INSERT INTO leu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Layaan na Pita taxa sangas xolai la nu bina, nane fe tixalum a mu rabuna aava ri namkai pe Lita. ");
INSERT INTO leu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Pave, nane xalum a saxa mataa, a isina na Eneas. Nane ve a maalapen aava mati la vem sina pana mariaas pisiktul. ");
INSERT INTO leu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Na Pita a xuuse, “Eneas, na Yesus Krais a vil faroxoi nano. Tamasiak e pulum a vem siim.” Fataapus, na Eneas a tamasiak. ");
INSERT INTO leu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","A mu rabuna aava ri taagul pe Lita e Seron, ri xalum a mataa tamu maalapen e nari xapiak, ri puk a lamonan siri e ri namkai se Memai. ");
INSERT INTO leu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pe la xasa bina, na Jaapa, a toxan a saxa tefin aava namkai, a isina na Tabita. (A isina lana pok bina Griik, na Dokas). Nane vil vulan a maana mo roxo xena xavang a mu rabuna valagof. ");
INSERT INTO leu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","La fena yaan na Pita taxa waan pe Lita, na Tabita a giis e femaat. Ri fasufe e ri timine la nobina laaꞌui lana lifu. ");
INSERT INTO leu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Na Lita a pife lasuun se Jaapa e layaan a mu rabuna aava ri namkai, ri langai o na Pita i taxa waan pe Lita, ri feng a saxa rovaat xe sina pana fenungan aanabeꞌ, “Filimaan fataapus xe simaam.” ");
INSERT INTO leu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","E voxo na Pita a tamasiak e a falet xuvul pare e layaan nane savat pave ri xele xe la nobina aave laaꞌui lana lifu. A lutefin nakmaal ri tigina fakaliuan na Pita. Ri taxa taangiis e ri faxalite pana maana mo xaves aava na Dokas fo vesane layaan nane taxa waan. ");
INSERT INTO leu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Na Pita a feng tapin nari xapiak xe lamalei e mui nane tapiit turung e a fenung. Nane tapuk xe sina tefin aava fo maat e a kuus, “Tabita, tamasiak.” Nane tafaangun e layaan a xalum na Pita a nai fatak. ");
INSERT INTO leu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Na Pita tao a mana e xavang fatigineie. E mui nane xel a mu rabuna aava ri namkai e lutefin nakmaal e a lisan faꞌuli na Tabita xe siri pana toyan fulaa. ");
INSERT INTO leu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ri toxan a texaasan sena pe Jaapa e a maana rabuna xaves ri puk a lamonan siri e ri namkai se Memai Yesus. ");
INSERT INTO leu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Na Pita waan pe Jaapa pana saxano yaan fulaa xuvul pa saxa Saimon aava fuuna faisok pana vipin ina tiir. ");
INSERT INTO leu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pe Sesaria a toxan a mataa, a isina na Kornilius. Nane ve a saxa paamua, a sensurian lana parabuna ina fevisan aava ri xali nari pana ‘Regimen ti Itali’. ");
INSERT INTO leu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nane e mu matafetama sina ri suai faagut sena Piran e nane fenung vulai xe sina e vaxa nane fuuna tatavai xe sina mu Juda valagof. ");
INSERT INTO leu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Saxa paanaas, faasilak leaaf, nane xalum a xaxaalua. Nane xalum famatavas saxa angelo sina Piran aava savat sina e a kuus, “Kornilius!” ");
INSERT INTO leu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Na Kornilius a xalum fatateaxe pana matautan e a fiai, “Rao no sou Memai?” A angelo a suie, “A fenungan siim e mu tatavaian siim xe sina mu rabuna valagof, ri fo fafaamamaas a Piran e nane lamon faꞌuli nano. ");
INSERT INTO leu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Naboxo, feng a rabuna xe pul Jaapa xena xel a mataa, isina na Saimon Pita. ");
INSERT INTO leu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nane taxa waan xuvul pa xasa Saimon fulaa aava fuuna faisok pana vipin ina mu tiir. A lifu sina taxa tigina la gun.” ");
INSERT INTO leu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Layaan a angelo aave fo malit, na Kornilius a xel a ro sisiak sina e saxa mataa ina fevisan aava mataa tuuna ina lotu ");
INSERT INTO leu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","e nane xuus narutul pana maana mo aava ri fo savat. E mui a feng narutul xe pul Jaapa. ");
INSERT INTO leu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","La paanaas a yaan mui, layaan rutul taxa savat faasilak la bina Jaapa, na Pita a laak laaꞌui xuluna putuna lifu xena fenung. ");
INSERT INTO leu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nane lagai e buk fangan. Layaan ri taxa faigotan a fanganan nane pe laaꞌui si toxan a mifan a savat sina. ");
INSERT INTO leu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nane xalum a finavata a talakas e a mo malaan sena marapi a sivimaan pana ngusuna talafaat. ");
INSERT INTO leu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A maana tiir pana kana talafaat e maana mo malaan sena tiui ti la xavala e maana maanu ti la tavegof sait, ri taxa waan lana marapi aave. ");
INSERT INTO leu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","E mui a ling a xuuse, “Tamasiak Pita. Tamo no vubuxan ta meska ti la palou ina mu vupung aanabeꞌ punuxe e no ngane.” ");
INSERT INTO leu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","E na Pita a suie, “Piau Memai, a vuputkai si Moses a xuus fatexaas nemaam pana saxano buk meska maam pife fexaxaas sena ngane e a mo lalosaat pi lalaak la valaak. Ne pi ngangan a mo lalosaat o maana buk meska maam pi ngangane.” ");
INSERT INTO leu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","A ling a kuus fulaa, “Muta xali a maana mo pana lalosaat aava Piran fo xalie pana mo roxo.” ");
INSERT INTO leu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","A mo aave savat faatalatul e fataapus a marapi a siak faꞌulian xe laaꞌui la xunavata. ");
INSERT INTO leu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Layaan na Pita taxa lalamon pana malasuf ina mifan aave, narutul aava na Kornilius a feng narutul, rutul fo tingin a lifu si Saimon e rutul taxa tigina la matana lifu sina xo. ");
INSERT INTO leu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Rutul kel e fiai tamo na Saimon aava ri xalie pa Pita, i taxa waan pave. ");
INSERT INTO leu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Laaꞌui la putuna lifu na Pita taxa lalamon fulaa pana mifan. E a Vovau Xaradak a xuuse, “Saimon, a rutuvaat talatul la pia, rutul taxa seng nano. ");
INSERT INTO leu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tamasiak e no sivi. Muta lamon fepuk, taasaxa falet xuvul parutul senaso nenia, ne fo feng narutul.” ");
INSERT INTO leu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Na Pita a sivi e xuus narutul, “Nenia ve a saxa aava mutul taxa senge. Senasou mutul fo filimaan?” ");
INSERT INTO leu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","A rutuvaat aave ri suie, “Nemaatul, maatul filimaan ti pe si Kornilius, a sensurian. Nane ve a saxa mataa roxo aava fuuna nangus a Piran e a mu rabuna Juda ri suai sena. A angelo xaradak a xuuse pana xelaan nano xe la lifu sina talo i taa langai a ferawaian siim.” ");
INSERT INTO leu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","E mui na Pita a xel falak narutul xe lana lifu e ri matef pave. La paanen na Pita xuvul pa saxano fetinan ti Jaapa, ri falet xuvul parutul. ");
INSERT INTO leu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A yaan mui ri fe savat pe puaa Sesaria. Na Kornilius a texaas sena savatan siri e fo xel faxuvul a mu tauna e mu fesing sina. ");
INSERT INTO leu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Na Pita a laak lana matana lifu e na Kornilius a piit turung e bukaak la nona pana suaian. ");
INSERT INTO leu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Taasaxa na Pita a xel fatamasiaxe e a xuuse, “Tamasiak! Ne pife piran, ne mataa tuuna mon malaan sema.” ");
INSERT INTO leu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Na Pita nare Kornilius re taxa ferawai laak saa pe la lifu e na Pita xalum a mu rabuna xaves aava ri taxa waan bang pave. ");
INSERT INTO leu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Nane xuus nari, “Mi texaas o lapaana vuputkai simaam mu Juda maam pife fexaxaas sena laak xe lana lifu sina rabuna aava ri pife Juda o tixalum nari. Taasaxa Piran fo faxalitau o ne taa pife xali ta mataa pana lalosaat. ");
INSERT INTO leu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","E voxo layaan mi xelau, ne filimaan e ne pife kuus o ne bai. E naboxo ne buk fiai, senasou mi vubuxanau?” ");
INSERT INTO leu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Na Kornilius a kuus, “A yaan talatul fo falet e nenia, ne taxa fenung la lifu siak la leaaf e lana fenungan siak a mataa pana marapi pasak paaliu a tigina faꞌipul la noga ");
INSERT INTO leu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","e a kuus, ‘Kornilius, a Piran a langai a fenungan siim e lamon a tatavaian siim xe sina mu valagof. ");
INSERT INTO leu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Xel na Saimon aava ri xalie pa Pita, ti pul Jaapa. Nane taxa taagul la lifu si xasa Saimon aava fuuna faisok pana vipin. A lifu sina taxa waan pe la gun.’ ");
INSERT INTO leu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","E voxo fataapus, ne feng narutul xena xelaan nano. E nano lana roxoyan siim, no filimaan xeau. Naboxo, nemaam xapiak maam taxa waan bang nabeꞌ la matana Piran xena langai pana so ta mo a Piran a xuus fatexaas nano pana.” ");
INSERT INTO leu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","E mui na Pita a tangpat pana ferawai, “Naboxo ne texaas tuuna o a vilaana sina Piran xe sina mu rabuna xapiak a fexaxaas. Nane pife tavai a mu Juda sang mon pana tatavai sina, piau. ");
INSERT INTO leu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nane turoxoian a mu rabuna ti la mu bina aava ri namkai sena e ri usi a vilaana roxo. ");
INSERT INTO leu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mi texaas sena lagasai aava Piran a lisane xe sina mu rabuna ti Israel. A Lagasai Roxo ina luaian aava savat xe sina mu rabuna aava ri namkai se Yesus Krais, nane aava vesan a maana mo xapiak. ");
INSERT INTO leu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mi texaas sena so ta mo fo savat pe Judia: a tangpat pe Galili lamina fasufan aava na Jon a fepitaa pana. ");
INSERT INTO leu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mi texaas o a Piran a noxol na Yesus ti Nasaret pana Vovau Xaradak e gutan. E na Yesus a falet xolai pana vilaana roxo e nane mulus tapin a mu rabuna xapiak aava ri sisiak si Setan. Nane vile senaso a Piran a waan xuvul pana. ");
INSERT INTO leu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Nemaam, maam xalum tuunei a maana mo xapiak nane vile la bina sina mu Juda e pe Jerusalem. Nari, ri punuxe pana niil fataxutane laaꞌui xuluna bolo ");
INSERT INTO leu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","taasaxa Piran a fatatoi faꞌulie ti la maatan la fatalatulaana yaan e fasavate la matavas. ");
INSERT INTO leu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pife mu rabuna xapiak ri xalume, piau. A Piran a siak fati a saxano rabuna xena xalumaana, nemaam xo, maam fangan e num xuvul pana lamina fatatoi faꞌuliaana ti la maatan. ");
INSERT INTO leu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Na Yesus a fasei nemaam o maam taa fapiti a mu rabuna pana Lagasai Roxo e maam taa kuus xakaavang o nane ve a saxa aava Piran a fatie xena tiis a mu rabuna xapiak, nari aava ri taxa to e nari aava ri fo maat. ");
INSERT INTO leu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","A mu rabuna ina kuus fatuxai, ri ferawai xakaavang pana. Ri kuus o pana gutan ina isina i taa lamon tapin a vilaana saat sina rabuna aava ri puk a lamonan siri e ri namkai se Yesus.” ");
INSERT INTO leu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","La fena ferawaian si Pita, a Vovau Xaradak a sivimaan xuluna mu rabuna xapiak aava ri taxa nai langai a lagasai aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","A mu Juda aava ri namkai e ri filimaan xuvul pa Pita, ri ipul senaso Piran a tavai a mu rabuna aava ri pife Juda pana Vovau Xaradak sina vaxa. ");
INSERT INTO leu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ri texaas sena senaso ri langai nari, ri taxa ferawai lana saxano pok bina e ri kuus faasiroxo xe sina Piran. E mui na Pita a kuus, ");
INSERT INTO leu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Naseꞌ taa ti votan a rabuna aanabeꞌ sena fasufan pana raarum? Ri fo siak xo a Vovau Xaradak malaan semaam.” ");
INSERT INTO leu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","E voxo nane fasei nari o ri taa fasufan lana isi Yesus Krais. E lamina ri fin na Pita o i taa waan xuvul pari pana valayaan. ");
INSERT INTO leu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","A mu yaamut e mu fetinan pe Judia, ri langai o a mu rabuna aava ri pife Juda sait ri fo langai a ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","E layaan na Pita a laak saa xe Jerusalem, a mu rabuna vuputuk aava ri namkai, ri ferawai fasaat sena. ");
INSERT INTO leu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ri fine, “No fo laak xe lana lifu sina rabuna aava ri pife vuputuk e no fangan xuvul pari, bo?” ");
INSERT INTO leu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Na Pita a xuus fatexaas nari pana maana mo xapiak aava ri fo savat. A kuus malaan, ");
INSERT INTO leu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nenia xo, ne taxa fenung pe la bina Jaapa e ne xalum a mifan. Ne xalum a mo malaan sena marapi lava pana ngusuna talafaat taxa sivimaan ti la xunavata xe siak. ");
INSERT INTO leu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ne kaalum lana e maana buk tiir xaves ri taxa waan: a mu tiir pana kana talafaat, a mu vupung e a maana mo fafaalis e lilif. ");
INSERT INTO leu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","E mui, ne langai a ling a xuusau, ‘Tamasiak Pita, tamo no vubuxan ta meska ti la palou ina mu vupung aanabeꞌ, punuxe e no ngane.’ ");
INSERT INTO leu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","E ne suie, ‘Piau move Memai! A vuputkai si Moses a xuus fatexaas nemaam pana so ta buk meska maam taa pife ngane e a mo lalosaat aanabeꞌ a pi lalaak la valaak. Ne pi ngangan a mo lalosaat o saxano buk meska maam pi ngangane.’ ");
INSERT INTO leu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“A ling a kuus fulaa ti lana xunavata, ‘Muta xali a maana mo pana lalosaat aava Piran fo xalie pana mo roxo.’ ");
INSERT INTO leu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A mo aanabeꞌ a savat faatalatul e mui a marapi a siak faꞌulian xe laaꞌui la xunavata. ");
INSERT INTO leu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Lavaxa, a rutuvaat talatul aava ri sengau ti Sesaria, ri maa savat la lifu ne taxa waan lana. ");
INSERT INTO leu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","A Vovau a xuusau, ‘Muta kuus “ne bai”, falet xuvul parutul.’ A nutuvaat pisaxa aanabeꞌ vaxa ri falet xe puaa Sesaria xuvul paga e maam felaak xe lana lifu si Kornilius. ");
INSERT INTO leu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Nane xuus nemaam o pe la lifu sina nane fo xalum a angelo aava xuuse, ‘Feng a mataa xe pul Jaapa xena xelaan na Saimon, a xasa isina na Pita. ");
INSERT INTO leu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nane taa lisanmaan a lagasai aava i taa fakaxup nano e mu tauma.’ ");
INSERT INTO leu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ne taxa tangpat pana ferawai xe siri e monabeꞌ mon a Vovau Xaradak fo sivimaan xuluri malaan sena sivimaan xulutaara lumua. ");
INSERT INTO leu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","E mui ne lamon faꞌuli a ferawaian si Memai, ‘Na Jon a fasuf a rabuna pana raarum tuuna, taasaxa nami, mi taa fasufan pana Vovau Xaradak.’ ");
INSERT INTO leu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Lavaxa, tamo a Piran xa a tavai nari pana tatavai sina aava Vovau Xaradak, malaan sena tavai netaara pana layaan taara puk a lamonan sitaara e usi na Memai Yesus Krais, mi lamon o ne taa ti votan nari e tisui a Piran, piau!” ");
INSERT INTO leu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Layaan ri langai a mo aanabeꞌ ri pife kuus fasaat fulaa e ri kuus faasiroxo xe sina Piran malaan, “Naboxo a Piran fo tavai a mu rabuna aava ri pife Juda pana yaan xena puxaana lamonan siri talo ri taa to vulai.” ");
INSERT INTO leu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Lamina maatan si Stefan, nari aava ri namkai, ri paan fepatok sena vil penganaan nari. Ri falet fefexaxaas Fonisia, Saipras e na Antiaak e ri fepitaa pana Lagasai Roxo xe sina mu Juda mon. ");
INSERT INTO leu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Saxano rabuna ti Saipras e Sairiin ri sivi xe puaa Antiaak e ri fe ferawai xe sina mu Griik vaxa. Ri fapiti nari pana Lagasai Roxo se Memai Yesus. ");
INSERT INTO leu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","A gutan sina Piran a waan xuluri e maana rabuna xaves ri namkai e ri usi a vilaana sina Memai. ");
INSERT INTO leu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","E pe Jerusalem si, a mu rabuna aava ri namkai, ri langai pana e ri feng na Baanabas xe puaa Antiaak. ");
INSERT INTO leu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nane fe savat pave e a xalum a Piran fo tatavai xe siri pana roxoyan sina. E na Baanabas a faamamaas e fagut nari talo ri taa waan fatateak vulai e ri taa pife lamon xolai se Memai. ");
INSERT INTO leu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Senaso na Baanabas a mataa roxo aava bas pana Vovau Xaradak e lamonan tuuna, a mu rabuna xaves ri puk a lamonan siri xena usi na Memai Yesus. ");
INSERT INTO leu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","E mui, na Baanabas a taꞌulan nari xena sengaan na Sol pe kol Taasus. ");
INSERT INTO leu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Layaan nane tingine nare xapiak re falet xe paa Antiaak. Lana mariaas saxa re waan xuvul pana mu rabuna aava ri namkai e re fapiti a maana rabuna xaves. Pe Antiaak a mu rabuna aava ri usi na Yesus, ri siak a isin, ‘Kristian.’ ");
INSERT INTO leu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","La fena yaan aanabeꞌ saxano rabuna ina kuus fatuxai, ri sivi xe puaa Antiaak ti Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","A saxa ti la palou iri, a isina na Aagabas, a tigina e lana gutan sina Vovau Xaradak a kuus o a yaan ina song molava i taa savat lana mu xavala xapiak. (A mo aanabeꞌ fo savat layaan na Klodias ve taxa piran king.) ");
INSERT INTO leu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","A mu rabuna aava ri namkai, ri lamon faati o ri taa lisan ta saxano faat, fexaxaas malaan seri, xena xavang a mu fetinan pe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","E ri vil malaane e ri siak fati na Baanabas nare Sol xena lisanaana xe sina mu matalava pe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lana yaan aanabeꞌ na Herot, a memai ti Rom, a yot a saxano rabuna aava ri namkai xena punuxaan nari. ");
INSERT INTO leu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nane patal a putu Jems, na ti Jon ");
INSERT INTO leu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","e layaan nane texaas o a vupunuxan aanabeꞌ a vil fafaamamaas a mu Juda, nane yot na Pita vaxa. A mo aanabeꞌ a savat la yaan ina fenamo lava ri xalie pana ‘Fenamo Ina Bret Aava Piau Ta Yiis.’ ");
INSERT INTO leu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Lamina yotaan na Pita nane timine lana lifu ina vipisan. A rabuna ina fevisan, talafaat pa talafaat, ri faxatange senaso na Herot a vubuk o i taa tiis na Pita la matana mu rabuna lamina Paaliuan. ");
INSERT INTO leu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Na Pita taxa waan lana lifu ina vipisan e a mu rabuna aava ri namkai, ri taxa lo fenung xe sina Piran pana. ");
INSERT INTO leu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","La vung, paamuina yaan na Herot taa xel na Pita xe la lifu ina tiisan, na Pita taxa matef la palou ina saxa rovaat ina faxatang votai. Re pis fatateaxe pana ‘sein’ taragua e xasa rovaat re ti faxatang la matana lifu ina vipisan. ");
INSERT INTO leu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Saxa angelo sina Piran a savat faꞌipul e a malang a lating a lana lifu ina vipisan. A angelo aave a sip fapungan na Pita. Nane kuus, “Fataapus, tamasiak!” e a ro ‘sein’ tateak aava ri pis a mana pana re tamulus palau ti pave la mana. ");
INSERT INTO leu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","E mui, a angelo a xuuse, “Falak a marapi e a ‘slipa’ siim.” E na Pita a vile. E a angelo a xuus fulane, “Xafut a taam pana marapi ina vupungan siim e no usiau.” ");
INSERT INTO leu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Na Pita a usie ti lana lifu ina vipisan, taasaxa nane pife texaas o a maana mo aanabeꞌ ri taxa savat la matavas senaso nane lamon o i taxa mif. ");
INSERT INTO leu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Re falet e fe xasliu a saxa rovaat ina faxatang votai e a saxa rovaat fulaa e re fe savat la matana lifu ina vipisan aava xakas xe la matana bina lava. A matana a talakas palau e re savat et xe lamalei. Re taxa sangas falet la salan e fataapus a angelo moxo a malit palau se Pita. ");
INSERT INTO leu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","E mui a lamonan si Pita a ulaa e a felamon, “Naboxo ne texaas o a Piran fo feng a angelo sina xena siak tapinau se Herot e sena maana mo xaves aava mu Juda ri buk rao ri taa vile sega.” ");
INSERT INTO leu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Layaan nane texaas faroxo nane falet xe la lifu si Maria, na nina Jon Maak. Pave, a rabuna xaves ri taxa fenung faxuvul. ");
INSERT INTO leu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Na Pita a pit a matana lifu ti lamalei e a sisiak tefin, a isina na Roda, a savat xena tatexaas o naseꞌ ve lamalei. ");
INSERT INTO leu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Layaan nane taraxali a ling i Pita, nane faamamaas faagut. Nane rao i ulaa xena xuus fatexaas a mu rabuna pana, taasaxa pife kas a matana lifu. Nane xukulai et xe siri lana lifu, “Na Pita pe taxa tigina la matana lifu.” ");
INSERT INTO leu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","E ri xuuse, “No ngong.” Taasaxa nane fasasong faagut pana e ri xuuse, “Pife nane, naak a angelo sina pave.” ");
INSERT INTO leu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","La matana lifu, na Pita taxa lo vipit lunai e layaan ri kase, ri ipul faagut sena. ");
INSERT INTO leu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Na Pita a talangai xe siri rao ri taa matakasam e a xuus fatexaas nari malaafaa a Piran fo siak tapine ti lana lifu ina vipisan. Na Pita a kuus, “Xuus fatexaas na Jems e mu fetinan pana.” E mui nane taꞌulan nari e falet xe la xasa bina fulaa. ");
INSERT INTO leu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","La paanen a mu rabuna ina faxatang votai ri felagafai xolai e ri fiai, “Faa na Pita?” ");
INSERT INTO leu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Na Herot a fasei a mu rabuna ina faxatang votai o ri taa seng faagutan na Pita, taasaxa ri seng maat. E mui na Herot a fin faxavesan a mu rabuna ina faxatang votai pana e a fasei nari o ri taa maat tamo ri pife tingin na Pita. Lamina, na Herot a taꞌulan na Judia e fe taagul pe Sesaria. ");
INSERT INTO leu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Nane fo mo fepialai xuvul pana mu rabuna ti la ro bina, Tair e Saidan. E naboxo, ri fevubuxan o nari, ri taa ferawai xuvul pa Herot. Ri feng a saxano rabuna ti la palou iri xe sina. E nari, ri xel na Balasus, saxa sisiak lava si Herot, rao i taa xavang nari pana fenungan siri xena faluai a xunus i Herot senaso a mu rabuna ti pe la ro bina siri, ri fuuna siak fanganan ti la bina si Herot. ");
INSERT INTO leu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","La yaan fatak, na Herot pana marapi ina piranan sina a nai la vena nai piranan sina e a ferawai xe sina mu rabuna. ");
INSERT INTO leu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nari, ri xukulai faavupuul, “A ling aanabeꞌ a ling ina piran, pife ling ina mataa mon.” ");
INSERT INTO leu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Fataapus, saxa angelo sina Piran a sip tuunei na Herot pana giisan lava senaso nane pife suai sena Piran. A mo malaan sena xanipit ri ngane e nane maat. ");
INSERT INTO leu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","A ferawaian sina Piran taxa lo fala fepatok e a xakatan ina mu rabuna aava ri namkai taxa lo molava et. ");
INSERT INTO leu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Pevoxo, na Baanabas nare Sol re fo lisan a faat xe sina mu fetinan pe Jerusalem e layaan re fataxapin a faisok sire re taꞌulan a bina aave e re ulaa xe puaa Antiaak. Na Jon Maak a falet xuvul pare. ");
INSERT INTO leu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","La palou ina rabuna aava ri namkai pe Antiaak, saxano rabuna ina kuus fatuxai e mu rabuna ina fepitaa ri taxa waan; nari ve na Baanabas e na Simeon, ri xalie pa Maxata, na Lusias ti Sairiin, na Manen aava fo molava xuvul pa Herot aava putuna gavamen e na Sol. ");
INSERT INTO leu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Layaan ri taxa nangus a Piran e falfaal pana fanganan, a Vovau Xaradak a xuus nari, “Fanei patak na Baanabas nare Sol xaanak xena ngavuk aava ne fo xel nare pana.” ");
INSERT INTO leu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Lamina fenungan e falfaalan siri, ri timin a mari xulure e ri feng tapin nare. ");
INSERT INTO leu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","A Vovau Xaradak a feng fasivi nare xe kol Salusia. E re xawas xuluna xaati xe la xurunusa, Saipras. ");
INSERT INTO leu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Layaan re savat pe Salamis, saxa bina pe Saipras, re fepitaa pana ferawaian sina Piran lana mu lifu ina faxuvulan sina mu Juda. E na Jon Maak sait, i taxa waan xuvul pare xena xavang nare pana faisok sire. ");
INSERT INTO leu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ri sangas la xurunusa xurul fefexaxaas ri savat pe Pafos. Pave, ri fesuai sena saxa Juda a isina na Ba-Jesus. Nane a mataa ina neng e mataa ina kuus fatuxai bit sait. ");
INSERT INTO leu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nane a fesing sina paamua ina xurunusa pave, a isina na Sirgius Polas. Nane ve a mataa pana masaman e xel fasavat na Baanabas nare Sol senaso nane buk langai a ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Taasaxa, a mataa ina neng aave, a xasa isina na Ilimas lana pok bina Griik, nane tisui nare senaso nane buk tivotan a paamua sena namkai. ");
INSERT INTO leu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","E mui na Sol, xasa isina na Pol, a bas pana Vovau Xaradak e a kaalum fatak xe si Ilimas e a xuuse, ");
INSERT INTO leu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nano, no lak si Setan e no xaiyaas sina maana mo roxo. No bas pana bitan e vulai no vubuk o a mu ferawaian tuuna sina Piran i taa malaan sena bitan mon. ");
INSERT INTO leu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Naboxo a fakasanaman molava sina Piran taa sip nano e mataam taa piif. La saxano yaan no taa pife xalum a malang ina ngaas.” E fataapus, a mo malaan sena vata maxata a xafut a matana e nane taxa sangas xolai xena seng ta mataa xena tao a mana. ");
INSERT INTO leu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Layaan a paamua aave a xalum a maana mo aava fo savat, nane namkai e a ipul paaliu pana fepitaian sena Piran. ");
INSERT INTO leu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Na Pol nari mu fesing sina, ri taꞌulan na Pafos pe lana xurunusa Saipras e ri fe xawas xuluna xaati xe Perga pe lana Pemfilia e pave na Jon Maak a taꞌulan nari e fe ulaa xe pe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nari, ri taꞌulan na Perga e ri sangas xe pe Antiaak pe Pisidia. La Yaan ina Fangaafusan ri laak lana lifu ina faxuvulan sina mu Juda e ri fe nai pave. ");
INSERT INTO leu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","A mu Juda ri fuuna kat ti lana mu vuputkai si Moses e maana Xakalayan sina mu rabuna ina kuus fatuxai. E lamina, a mu matalava ina lotu, ri fin nare pa ta lagasai malaan, “Mu fetinan, tamo mi toxan ta lagasai xena fagutaana mu rabuna, a roxo, ferawai saa.” ");
INSERT INTO leu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Na Pol a tamasiak e talangai xe siri e a kuus, “Mu rabuna ti Israel e nami, mu rabuna aava mi nangus a Piran taasaxa mi pife Juda, langaiau! ");
INSERT INTO leu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","A Piran tuuna sina mu rabuna ti Israel a siak fati a mu bumaam e a vil faaxaves nari layaan ri taagul pe Isip malaan sena topen. A Piran a siak faꞌuli nari ti Isip pana gutan molava sina ");
INSERT INTO leu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","e faxatang nari pana mariaas sangafilu talafaat pe la xobingil. ");
INSERT INTO leu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Nane kawaasan tapin a mu pabung pisiguak aava ri fuuna taagul la bina Kenan e a tavai a mu rabuna sina pana xavala ina kuus fanaian aave. ");
INSERT INTO leu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Nane faxatang nari pana mariaas 450. “Lamina yaan aapave, nane tavai nari pana mu rabuna ina tiisan fefexaxaas a yaan si Samwel, saxa mataa ina kuus fatuxai. ");
INSERT INTO leu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","E layaan ri vubuxan a Memai King, a Piran a tavai nari pa Sol, a lak si Kis ti lana pabung si Benyamin. E nane paamuian nari pana mariaas sangafilu talafaat. ");
INSERT INTO leu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Taasaxa Piran a siak tapin na Sol e fati na Devit xena Memai King siri. A Piran a kuus malaan se Devit: “Ne texaas se Devit, a lak si Jesi, i taxa usi fataxau e i taa vil a maana mo xapiak ne vubuk rao i taa vile.” ");
INSERT INTO leu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“E a Piran a fati na Yesus, a bu Devit, xena fakaxup a mu Israel, malaan sena kuus fanaian sina. ");
INSERT INTO leu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Paamuina faisok si Yesus, na Jon a xuus fatexaas a mu Israel rao ri taa puk a maana saatan siri e ri taa fasufan. ");
INSERT INTO leu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","E layaan na Jon taxa fataxapin a faisok sina nane xuus a rabuna, ‘Mi lamon malaafaa? Nenia va naseꞌ? Nenia, ne pife Mataa Failai sina Piran aava mi taxa waan bange taasaxa kaalum, nane taa savat lamiak e nenia, ne pife fexaxaas sena mulus tapin a ‘slipa’ sina senaso ne mataa palau.’ ");
INSERT INTO leu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Mu fetinan, nami mu bu Abrahem e nami mu rabuna aava mi pife Juda e mi nangus a Piran, a Piran a lisan a lagasai ina kaaxupan xe sitaara. ");
INSERT INTO leu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","A rabuna ti Jerusalem e a mu paamua siri, ri ngalngolan na Yesus e vaxa ri pife masam sena ferawaian sina mu rabuna ina kuus fatuxai aava ri fuuna kate la maana Yaan ina Fangaafusan saxa saxa. Taasaxa ri fasavat a ferawaian sina mu rabuna ina kuus fatuxai layaan ri punuxe. ");
INSERT INTO leu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ri pi ta fufuna tuuna xena punuxe taasaxa ri fin na Pailat pana i taa punuxan. ");
INSERT INTO leu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","E ri vil tuunei a maana mo xapiak aava Ferawaian sina Piran fo ferawai pana. E mui ri lisan fasivi a tana ti xuluna bolo e timine lana liing ina mamaat. ");
INSERT INTO leu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Taasaxa Piran a fatatoi faꞌulie ti la maatan. ");
INSERT INTO leu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","E la maana yaan xaves, nane savat siri aava ri fuuna sangas xuvul pana ti Galili xe Jerusalem. Nari naboxo ri rabuna ina kuus xakaavangan xe sina mu Israel. ");
INSERT INTO leu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Nemaam, maam xuus nami pana Lagasai Roxo: a so ta mo a Piran a kuus fanai pana xe sina mu butaara ");
INSERT INTO leu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","nane fo vil fasavate xo pataara layaan a fatatoi faꞌuli na Yesus ti la maatan. A toxan a xakalayan pa Yesus lana fataraguiaana Yanganan a malaanabeꞌ: ‘Nano, no lak tomexaan siak, tanin ne fo savat tamaam’ ");
INSERT INTO leu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","E vaxa, layaan a Piran a fatatoi faꞌuli na Yesus ti la maatan talo i taa pife masiik, nane kuus malaan, ‘Ne taa tavai nano pana roxoyan xaradak siak aava ne fo kuus fanai pana xe si Devit.’ ");
INSERT INTO leu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","E fulaa a Piran a kuus pana la ngusu Devit ‘A sisiak xaradak siim i taa pife masiik senaso no taa pife kuus turoxo pana.’ ");
INSERT INTO leu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Senaso layaan na Devit a fataxapin a faisok aava Piran a tavaie pana, nane maat. Ri xaafane la ta buna e a tana masiik pave. ");
INSERT INTO leu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Taasaxa, a saxa aava Piran a fatatoi faꞌulie ti la maatan, a pife masiik. ");
INSERT INTO leu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","“E voxo mu fetinan, ne vubuk rao mi taa texaas tuuna o a vuputkai si Moses pife fexaxaas sena mulus tapin nami sena mu vilaana saat xapiak simi, piau. Na Yesus sang mon a fexaxaas sena lamon tapin a mu vilaana saat simi. E naseꞌ ta mataa a namkai se Yesus, i taa xalian pana ‘Xaradak’. ");
INSERT INTO leu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Faxatang, talo a ferawaian aanabeꞌ sina mu rabuna ina kuus fatuxai ri taa pife savat la matavas xe simi; ");
INSERT INTO leu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Kaalum, nami aava mi suak, mi taa maat faꞌipul senaso ne taxa vesan a mo tanin e mi taa pife namkai sena naapalaan tamo saxa taa xuus famatavas nami pana.” ");
INSERT INTO leu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Layaan na Pol nare Baanabas re taxa guun ti la lifu ina faxuvulan a mu rabuna ri fin nare rao re taa ulaamaan fulaa la Yaan ina Fangaafusan mui xena xuus fatexaas fulan nari pana maana mo aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","A mu rabuna ri taxa taꞌulan a faxuvulan e saxano rabuna Juda e saxano rabuna aava ri pife Juda taasaxa ri usi a lotu Juda, nari xapiak ri usi na Pol nare Baanabas. Re ferawai xuvul pari e re fagut nari talo a taagulan siri i taa waan vulai pana roxoyan sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lana Yaan ina Fangaafusan mui, faasilak a mu rabuna xapiak ti la bina ri savat xena langaiaana Ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Layaan a mu Juda ri xalum a malila, ri tarasuie e ri ferawai fasaat sena ferawaian si Pol. ");
INSERT INTO leu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Taasaxa na Pol nare Baanabas re tisui faagutan nari e re kuus, “Paamua, a mo roxo maame xuus tuunei nami pana ferawaian sina Piran. E senaso mi gigirane e mi baian a toyan vulai, lavaxa maame taa taꞌulan nami xena falet xe sina mu rabuna aava ri pife Juda ");
INSERT INTO leu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","senaso a Piran a fasei nemaame malaanabeꞌ: ‘Ne fo vesan nano rao no taa malaan sena malang xena paamuian a mu rabuna aava ri pife Juda talo a kaaxupan siak taa savat la mu bina xapiak.” ");
INSERT INTO leu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Layaan a mu rabuna aava ri pife Juda ri langai sena, ri faamamaas e ri kuus faasiroxo pana Ferawaian si Memai. E nari xapiak aava Piran a xel nari xena laak lana fatataganan sina talo ri taa to vulai, nari, ri namkai. ");
INSERT INTO leu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","A Ferawaian si Memai a falet fepatok xe la maana mu bina xapiak. ");
INSERT INTO leu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Taasaxa mu Juda ri ferawai xe sina mu paamua ina bina e saxano matalava tefin aava ri nangus a Piran talo ri taa tisui na Pol nare Baanabas. E ri bilai fasaat xe sire e ri feng tapin nare sena nobina aapave. ");
INSERT INTO leu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","E voxo nare xo re saf tapin a pof la kare. A vilaana aanabeꞌ a fakalimaan votan nari. E re falet xe Aikoniam. ");
INSERT INTO leu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","A mu fetinan pe Antiaak ri bas pana faamamaasan e pana Vovau Xaradak. ");
INSERT INTO leu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pe Aikoniam na Pol nare Baanabas re laak lana lifu ina faxuvulan sina mu Juda. E pave re ferawai lapaana gutan sina Piran e voxo maana rabuna xaves ti la palou ina mu Juda e mu rabuna aava ri pife Juda, ri namkai se Yesus. ");
INSERT INTO leu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Taasaxa mu Juda aava ri bai namkai, ri ferawai fasaat se Pol nare Baanabas e ri fatamasiak a lamonan sina mu rabuna aava ri pife Juda talo ri taa tisui a mu rabuna aava ri namkai. ");
INSERT INTO leu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na Pol nare Baanabas re waan pave pana maana yaan xaves. E lana waanan sire, re ferawai faagut pana xakaavangan xatam sina Memai. A Memai a turoxoian a ferawaian sire e tavai nare pana gutan xena vil a maana buk faisok ina gutan e a maana mo faꞌipul. ");
INSERT INTO leu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A mu rabuna ti la bina ri lamon fepatok. Saxano rabuna ri usi a mu Juda e saxanofuna ri usi nare ro yaamut. ");
INSERT INTO leu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Saxano rabuna aava ri pife Juda e saxano Juda ri fexuus kasam e nari xuvul pana saxano paamua siri, ri lamon o ri taa bilai fasaat xe sire e ri taa soxoi nare pana faat. ");
INSERT INTO leu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Taasaxa nare, re texaas sena e re taꞌulan fatapusan a bina aave e re sinuf xe la ro bina pe Laikonia, ri xali nare pa Listra e Daabe. ");
INSERT INTO leu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Pave e lana nu bina faasilak, re taxa lo ferawai pana Lagasai Roxo. ");
INSERT INTO leu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lavaxa, pe Listra a toxan a mataa kana maalapen. Nane a malaanabeꞌ ti lana modaxan sina e pi sasangas. ");
INSERT INTO leu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nane langai layaan na Pol taxa ferawai e na Pol a xalum fatateaxe e texaas o a namkaian sina a fexaxaas sena vil faroxoiaana. ");
INSERT INTO leu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","E na Pol a kuus falava, “Tigina fatak xuluna ro kaam!” E voxo a mataa aave a tigina e tangpat pana sangas. ");
INSERT INTO leu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Layaan a malila ri xalum a mo na Pol fo vile ri xukulai lana pok bina siri, a pok bina ti Laikonia, e ri kuus, “A mu piran ri fo sivimaan la palou itaara malaan sena matatuuna.” ");
INSERT INTO leu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Na Baanabas ri xalie pa Seus e na Pol ri xalie pa Irmiis senaso nane fuuna tigina paamua e ferawai. ");
INSERT INTO leu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","A lifu lotu si Seus a tigina faasilak lamalei sena bina e a priis ina lotu aave a siak lisan a maana bulmakau e maana fur xe la yalaxau ina bina senaso nane xuvul pana mu rabuna ri vubuk tavai a ro yaamut pana tatavaian siri. ");
INSERT INTO leu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Taasaxa layaan na Pol nare Baanabas re langaie re ririk a marapi sire xa e re fala xe la palou ina malila e re xukulai, ");
INSERT INTO leu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Mi rabuna, xenaso mi taxa vil malaane? Nemaame xo maame rabuna malaan semi mon. Maame taxa lisan a Lagasai Roxo xe simi e maame taxa xuus nami o mi taa taꞌulan a maana mo palau aanabeꞌ e mi taa usi a Piran aava vesan a vata e xavala e laman e a maana mo xapiak aava ri waan lana. ");
INSERT INTO leu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","La yaan kavai a rabuna pe lana mu bina ri usi a vilaana siri saxa saxa e a Piran a kuus turoxo pana. ");
INSERT INTO leu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Taasaxa, nane pife fepalauan nami. Nane tavai nami pana raafui ti laaꞌui e a faboak a fanganan lana uma simi e vaxa a tavai nami pana maana buk fanganan xaves e a fabas a xunus imi pana faamamaasan.” ");
INSERT INTO leu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Naapalaan a ro yaamut re ferawai malaan a mu rabuna ri vubuk tatavai pana fanganan xe sire. ");
INSERT INTO leu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","E mui saxano Juda ti Antiaak e Aikoniam ri savat e ri yuuf a malila pana ferawaian siri. Ri soxoi na Pol pana faat e ri raagan fasavate xe lamalei senaso ri lamon o nane fo maat. ");
INSERT INTO leu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Taasaxa mu rabuna aava ri namkai, ri tigina fakaliuane e nane tamasiak e ulaa fulaa xe la bina. E a yaan mui, nare Baanabas re falet xe pul Daabe. ");
INSERT INTO leu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Re ferawai pana Lagasai Roxo pe Daabe e maana rabuna ri puk a lamonan siri e ri namkai. E mui re ulaa fulaa xe pe Listra, Aikoniam e na Antiaak. ");
INSERT INTO leu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Re ferawai xe sina mu fetinan xena fagutaan nari talo ri taa waan fatateak lana namkaian tuuna siri. Re fepitaa malaan, “Taara taa falet tuuna xe lana lagafan xaves xena laak la fatataganan sina Piran.” ");
INSERT INTO leu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Na Pol nare Baanabas re siak fati a mu paamua lana mu lotu saxa saxa. E lamina fenungan e falfaalan re timin nari lapaana xakaavangan xatam sina Piran senaso ri fo lisan tuunei nari xa xe sina. ");
INSERT INTO leu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Lamina faletan sire pe Pisidia re falet xe Pemfilia. ");
INSERT INTO leu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Layaan re fo fepitaa pana Lagasai Roxo pe la bina Perga re sivi xe Atalia. ");
INSERT INTO leu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pave re xawas xuluna xaati e re ulaa xe Antiaak a fufubina ina faisok sire. ");
INSERT INTO leu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Layaan re savat pe Antiaak re xel faxuvul a mu rabuna aava ri namkai. E re xuus fatexaas nari pana maana mo xaves aava Piran fo vile sere e malaafaa nane faigotan a salan talo a mu rabuna aava ri pife Juda, ri taa puk a lamonan siri xena namkai. ");
INSERT INTO leu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","E re taagul pave pana maana yaan xaves xuvul pana mu rabuna aava ri namkai. ");
INSERT INTO leu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Saxano rabuna ri sivimaan ti Judia xe puaa Antiaak e ri taxa fapiti a mu fetinan pave malaan: “Nami, mi taa vuputuk malaan sena vuputkai si Moses fo kuus pana e tamo piau mi taa pife kaaxup.” ");
INSERT INTO leu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Na Pol nare Baanabas re fepuxai xuvul pari sena fepitaian aanabeꞌ. E voxo mu rabuna ri feng na Pol nare Baanabas xuvul pana xasano rabuna aava ri namkai xe pul Jerusalem xena ferawai xuvul pana mu yaamut e mu matalava pana lagafan aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","A mu rabuna sina Piran, ri feng nari e la fena faletan siri, ri sangas falet pe Fonisia e Sameria. E pave ri xuus fatexaas a mu fetinan o a mu rabuna aava ri pife Juda ri fo puk a lamonan siri xena namkai. E a lagasai aanabeꞌ a vil fafaamamaas nari. ");
INSERT INTO leu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","A mu yaamut, mu matalava e mu rabuna sina Piran pe Jerusalem, ri faamamaas pana savatan siri. E na Pol nari, ri kuusan a maana mo xaves aava Piran fo vile seri. ");
INSERT INTO leu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Taasaxa saxano fetinan aava ri waan lana pabung sina mu Ferasi, ri tigina e ri kuus, “A mu rabuna aava ri pife Juda ri taa vuputuk e ri taa usi a mu vuputkai si Moses vaxa.” ");
INSERT INTO leu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","A mu yaamut e mu matalava ri faxuvul xena ferawai pana fiaian aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Lamina ferawaian xaves na Pita a tamasiak e ferawai xe siri, “Mu fetinan, mi texaas o maana yaan xaves lumua a Piran a fatiau xena ferawai famatavas pana Lagasai Roxo sina xe sina mu rabuna aava ri pife Juda talo ri taa langaie e namkai sena. ");
INSERT INTO leu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","A Piran aava texaas sena lamonan sina mataa, a faxaalit o nane vubuxan a mu rabuna aava ri pife Juda sait senaso nane tavai nari vaxa pana Vovau Xaradak malaan setaara. ");
INSERT INTO leu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","E nane pife lamon patak seri taasaxa senaso ri namkai tuuna malaan setaara nane gei tapin a lalosaat la xunus iri. ");
INSERT INTO leu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Senasou mi taa tafang tarei a Piran pana timinaana matafanan aanabeꞌ xuluna mu rabuna aava ri namkai, a matafanan aava netaara xa e mu butaara, taara pife fexaxaas sena yaase? ");
INSERT INTO leu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Piau! Taara namkai o taara fo kaaxup pana xakaavangan xatam si Memai Yesus malaan seri.” ");
INSERT INTO leu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","A mu rabuna aave ri nai kasam e ri langai si Baanabas nare Pol layaan re kuusan a maana buk faisok pana gutan sina Piran aava nare fo vesane la palou ina mu rabuna aava ri pife Juda. ");
INSERT INTO leu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Layaan re fataxapin a ferawaian sire na Jems a kuus, “Mu fetinan, langaiau! ");
INSERT INTO leu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Na Saimon a xuus fatexaas netaara o malaafaa a Piran a siak fati a saxano rabuna ti la palou ina mu rabuna aava ri pife Juda talo ri taa rabuna sina. E malaanabeꞌ a faxalit nari pana faxatangaan nari sina. ");
INSERT INTO leu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","A mu xakalayan sina mu rabuna ina kuus fatuxai ri turoxo pana vilaana aanabeꞌ. Senaso a ferawaian sina Piran a kuus malaan, ");
INSERT INTO leu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“Lamina mo aanabeꞌ ne taa ulaamaan e ne taa fatiginei a pabung si Devit aava ri fo poxo. E ri taa tigina fatateak fulaa. ");
INSERT INTO leu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","E voxo xasano rabuna xaves aava ri pife Juda, ne fo xel nari xe siak e ri taa seng faagutan a Memai. ");
INSERT INTO leu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","A Piran aava fasavat a maana mo aanabeꞌ la matavas, fo kuus malaan.” ");
INSERT INTO leu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Na Jems a kuus fulaa, “A lamonan siak a malaan: taara taa pife famatafan a mu rabuna aava ri pife Juda e ri puk a lamonan siri xena namkai sena Piran. ");
INSERT INTO leu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Taasaxa, taara taa xalei a lagasai xena xuus nari malaan: ‘Muta ngan a mo aava lalosaat senaso ri falfaal xe sina saxa piran bit pana, muta paruk e vaxa muta ngan ta ria o meska ri fo xiute.’ ");
INSERT INTO leu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Taara taa ferawai malaan senaso ti lumua paaliu, la maana Yaan ina Fangaafusan ri fo kuusan fasavat a maana vuputkai si Moses la mu lifu ina faxuvulan. E a mu vuputkai naang ri ferawai sena maana mo aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","E mui, a mu yaamut e mu matalava xuvul pana mu rabuna xapiak ina lotu, ri lamon o ri taa siak fati a saxano rabuna ti la palou iri xena fengaan nari xe puaa Antiaak xuvul pa Pol nare Baanabas. E ri siak fati na Judas, xasa isina na Basaabas e na Sailas, a rovaat aava mu fetinan ri suai sere. ");
INSERT INTO leu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","E ri lisan a lagasai aanabeꞌ sait: Nemaam mu yaamut, mu matalava e mu fetinan, maam lisan a lagasai ina fasisian xe simi aava mi pife Juda e mi namkai pe Antiaak, Siria e Silisia; ");
INSERT INTO leu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","maam fo langai o saxano rabuna ri taꞌulan nemaam e ri fe falagaf a lamonan simi pana ferawaian siri. Taasaxa nemaam, maam pife feng nari. ");
INSERT INTO leu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","E voxo nemaam xapiak, lapaana lamonan saxa, maam fo siak fati a saxanofuna xena fengaan nari xe simi xuvul pana ro fesing sitaara, na Pol nare Baanabas ");
INSERT INTO leu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","aava faasilak re maat soxot a isi Memai Yesus Krais sitaara. ");
INSERT INTO leu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","E voxo maam taxa feng na Judas nare Sailas rao re taa ferawai xakaavang pana lagasai aava maam fo xaleie. ");
INSERT INTO leu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","A Vovau Xaradak e nemaam, maam fo turoxo o maam taa pife falagaf nami pana maana vuputkai xaves taasaxa maam toxan a nu vuputkai aanabeꞌ mon: ");
INSERT INTO leu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","muta ngan a fanganan ri tatavai xe sina mu piran bit pana, muta ngan ta ria o meska ri fo xiute e muta paruk. Tamo mi taa faapalau sena maana mo aanabeꞌ mi taa waan faroxo. Nane sang mon. ");
INSERT INTO leu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","E mui ri feng tapin a mu rabuna fefeng e ri fe sivi xe puaa Antiaak. E pave, ri xel faxuvul a mu rabuna ina lotu e ri tavai nari pana lagasai aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","A mu rabuna ri kate e ri faamamaas pana lagasai xena fagutaan nari. ");
INSERT INTO leu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Na Judas nare Sailas aava ro mataa ina kuus fatuxai, re fagut a mu fetinan. ");
INSERT INTO leu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Re waan pave pana valayaan e mui, a mu fetinan ri feng tapin nare pana roxoyan e luaian talo re taa ulaa fulaa xe siri aava ri feng nare. ");
INSERT INTO leu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Taasaxa na Sailas a vubuk taagul pave.) ");
INSERT INTO leu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Na Pol nare Baanabas re waan pe Antiaak e nare xuvul pana xasanofuna, ri fepitaa e ri ferawai pana Lagasai Roxo, a Ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Lumui na Pol a xuus na Baanabas, “Taare taa ulaa xe la nu bina aava taare fo kuusan fasavat a Ferawaian sina Piran lana xena tixalum a mu fetinan talo taare taa texaas tamo ri waan faroxo o piau.” ");
INSERT INTO leu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","E na Baanabas a vubuk o na Jon Maak i taa falet xuvul pare. ");
INSERT INTO leu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Taasaxa na Pol a lamon o pife roxo senaso paamua na Jon Maak fo taꞌulan nare pe Pemfilia e pife falet xuvul pare lana faisok xapiak sire. ");
INSERT INTO leu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Re fegagelai faagut e re falet fepatok. Na Baanabas a xel na Maak e re xawas xuluna xaati e re falet xe Saipras. ");
INSERT INTO leu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Taasaxa na Pol a siak fati na Sailas e a mu fetinan ri feng tapin nare lapaana roxoyan sina Memai. ");
INSERT INTO leu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Nare, re falet xe Siria e Silisia xena fagut a mu fetinan pave. ");
INSERT INTO leu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","E mui re falet laa xe Daabe e Listra. Pe Listra a toxan a mataa faꞌui aava namkai se Yesus, isina na Timoti. Na ninana a tefin Juda aava namkai taasaxa na tamana ti Griik. ");
INSERT INTO leu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","A mu rabuna aava ri namkai pe Listra e Aikoniam ri ferawai faroxo se Timoti e ri kuus o a vilaana sina a roxo. ");
INSERT INTO leu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","E na Pol a vubuk rao i taa falet xuvul pare e voxo nane putuk na Timoti senaso a mu Juda ti la nu bina pave ri texaas o na tama Timoti a mataa ti Griik. ");
INSERT INTO leu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","La fena faletan siri ri savat la mu bina saxa saxa e ri xuus fatexaas a mu rabuna aava ri namkai pana nu vuputkai sina mu yaamut e mu matalava pe Jerusalem. E ri xuus nari o ri taa langai sena nu vuputkai aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","E voxo a lagasai aanabeꞌ a fagut a mu rabuna aava ri namkai e a xakatan iri taxa lo molava et lana yaan saxa saxa. ");
INSERT INTO leu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Na Pol e mu fesing sina, ri falet xe la maana nu bina pe Fridia e Galesia senaso a Vovau Xaradak a xuus votan nari sena kuusan fasavat a Lagasai Roxo pe Esia. ");
INSERT INTO leu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Layaan ri savat la fafalas ti Misia, ri laak taraa xe la nobina Bisnia. Taasaxa a Vovau si Yesus pife kuus turoxo pana. ");
INSERT INTO leu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","E voxo ri sangas liu na Misia e ri falet xe kol Troas. ");
INSERT INTO leu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","La xunavung na Pol a toxan a mifan e lana, saxa mataa ti Mesidonia a ti fenung xe sina malaan, “Filimaan xe Mesidonia xena xavangaan nemaam.” ");
INSERT INTO leu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Lamina mifan si Pol, maam tamasiak xena falet xe Mesidonia senaso maam texaas o a Piran fo xel nemaam talo maam taa xuus nari pave pana Lagasai Roxo. ");
INSERT INTO leu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pe Troas maam xawas xuluna xaati e falet fatak xe puaa Samotres e la yaan lamina maam falet fulaa xe puaa Niapolis. ");
INSERT INTO leu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ti pave maam sangas laak xe kol Filipai, saxa bina ti Rom e a bina lava lana provins ti Mesidonia. E maam waan pave pana nu yaan. ");
INSERT INTO leu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","La Yaan ina Fangaafusan, maam falet xe lamina yalaxau ina bina la vangana raarum senaso maam lamon o a bina ina fenungan sina mu Juda taxa waan pave. E maam nai ferawai xe sina lutefin aava ri faxuvul pave. ");
INSERT INTO leu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Saxa tefin aava langai nemaam, isina na Lidia, a tefin ti Taiataira. Nane fuuna faasot pana marapi raf e vaxa a lotu xe sina Piran. E a Memai a kas a xunus ina tefin aave e voxo nane langai faroxo sena ferawaian si Pol e a namkai. ");
INSERT INTO leu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","E lamina fasufan sina e sina matafetama sina, nane fiai rao maam taa falet xe la lifu sina. Nane fiai malaan, “Tamo mi lamon tuuna o nenia, ne namkai se Memai, filimaan xe la lifu siak.” E nane bai o maam taa kuus pana piau. ");
INSERT INTO leu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Saxa yaan layaan maam taxa falet xe la bina ina fenungan, maam fesuai sena saxa yaasok tefin. A vovau saat fo vawe e voxo nane fexaxaas sena xali fasavataana mo. Nane fuuna siak a faat xaves xana mu mataa tafuna layaan nane xali fasavat a mo. ");
INSERT INTO leu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","A tefin aanabeꞌ a usi nemaam Pol e a xukulai, “A rovaat tomexaan aanabeꞌ re sisiak sina Piran Laaꞌui Paaliu. Re taxa xuus nami pana salan ina kaaxupan.” ");
INSERT INTO leu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nane vil malaane pana maana yaan xaves e voxo na Pol a marala e a tapuk xe sina e xuus faagutan a vovau saat aave, “Lana isi Yesus Krais ne fasei nano, taꞌulan a tefin aanabeꞌ.” E fataapus a vovau aave a taꞌulane. ");
INSERT INTO leu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Layaan a mu mataa tafuna yaasok tefin ri texaas o a vilaana ina siaxaana faat xaves fo piau, ri yot na Pol nare Sailas e ri yuuf raagan nare xe la bina ina mamareiai talo ri taa fatiginei nare la matana mu paamua ina bina. ");
INSERT INTO leu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ri lisan nare xe la nona mu rabuna ina tiisan e ri kuus, “A rabuna aanabeꞌ ri mu Juda e ri taxa falagaf a mu rabuna nabeꞌ la bina sitaara ");
INSERT INTO leu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","pana fepitaian sena vilaana aava netaara mu Rom, taara pife kuus turoxo pana senaso ri pife vuputkai sitaara.” ");
INSERT INTO leu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","E a malila ri falou na Pol nare Sailas. E a mu rabuna ina tiisan ri fasei nari o ri taa ririk tapin a marapi sire xena inis nare. ");
INSERT INTO leu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","E lamina inisaan nare, ri tapin falak nare lana lifu ina vipisan e ri xuus a mataa ina faxatangaana vipis o i taa pis faagutan nare. ");
INSERT INTO leu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Layaan nane langai a fefasaian aanabeꞌ nane timin nare lana nobina la palou ina lifu ina vipisan e pis faagutan a kare pana wai matafan. ");
INSERT INTO leu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","La xunavung naang na Pol nare Sailas re taxa lo fenung e yangan xe sina Piran. Xasanofuna lana lifu ina vipisan sait ri taxa langai nare. ");
INSERT INTO leu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","A toxan faꞌipul a maraꞌulia molava aava faradakui a funa lifu ina vipisan. E faasaxa maana ‘dua’ xapiak ri talakas e mu ‘sein’ ina mu vipis lana lifu ri poxo patak seri. ");
INSERT INTO leu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","A mataa ina faxatang nari a para. Layaan nane xalum a mu yalaxau ina lifu ina vipisan a talakas nane siak a pinis lava sina rao i taa punuk nane xa senaso a lamon o a mu vipis lana lifu aave ri fo sinuf. ");
INSERT INTO leu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Taasaxa na Pol a xukulai, “Muta famasak nano! Maam xapiak taxa waan nabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","E a mataa ina faxatangan a kel pana mu laam e fala fataapus xe si Pol nare Sailas e a poxo radakui la nore. ");
INSERT INTO leu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","E mui nane lisan nare xe lamalei e a fin nare, “Matalava, a so ta mo ne taa vile xena kaaxupan siak?” ");
INSERT INTO leu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","E re suie, “Namkai se Memai Yesus e no taa fakaxup nano e a matafetama siim.” ");
INSERT INTO leu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","E mui re fapiti nari xapiak aava ri taagul lana lifu sina, pana Ferawaian sina Memai. ");
INSERT INTO leu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Lana yaan aanabeꞌ xo, a mataa ina faxatangan a xamak a mu viis sire e mui nane e mu matafetama sina ri fasufan. ");
INSERT INTO leu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","A mataa ina faxatangan a lisan nare xe lana lifu sina e tavai nare pana fanganan. E mu matafetama ri bas pana faamamaasan senaso ri namkai xo sena Piran. ");
INSERT INTO leu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","La paanen mui, a mu rabuna ina tiisan ri feng a vusul siri xe sina mataa ina faxatangan pana fefasaian aanabeꞌ, “Mulus tapin a rovaat aave.” ");
INSERT INTO leu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","A mataa ina faxatangan a xuus na Pol, “A mu rabuna ina tiisan ri kuus o ne taa mulus tapin nano e na Sailas. Naboxo me taa falet saa. Falet lana luaian.” ");
INSERT INTO leu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Taasaxa na Pol a xuuse, “Nari, ri inis nemaame, a rovaat ti Rom, la matana rabuna. Ri pife tiis nemaame e ri timin nemaame lana lifu ina vipisan. E naboxo ri vubuk o maame taa falet palau, bo? Piau, nari xa ri taa savat xena lisanaan nemaame xe lamalei.” ");
INSERT INTO leu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Layaan a mu vusul ri xuus a mu paamua ina tiisan o na Pol nare Sailas re rovaat ti Rom, ri mataut. ");
INSERT INTO leu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","E voxo ri savat xena fadaarum nare e ri faxakan nare e ri nung nare o re taa taꞌulan a bina. ");
INSERT INTO leu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Lamina mulus tapinaan nare, na Pol nare Sailas re falet xe la lifu si Lidia e pave re faxuvul xuvul pana mu fetinan e re fagut nari pana ferawaian sire. E mui re taꞌulan nari. ");
INSERT INTO leu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Layaan re fo sangas falet la ro bina Amfipolis e Apalonia, re savat pe Tesalonaika e pave a toxan a lifu ina faxuvulan sina mu Juda. ");
INSERT INTO leu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","E malaan sena vilaana sina, na Pol a laak lana lifu aave e la nu Yaan talatul ina Fangaafusan nane ferawai xuvul pari. ");
INSERT INTO leu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nane xuus famatavas nari pana Ferawaian sina Piran talo ri taa texaas tuuna pana Mataa Failai e a maasaxan sina e pana to faꞌulaian sina ti la maatan. E nane kuus, “Na Yesus aanabeꞌ ve a Mataa Failai aava ne taxa xuus fatexaas nami pana.” ");
INSERT INTO leu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Saxano Juda ri xaveak namkai e ri faxuvul xuvul pa Pol nare Sailas e vaxa xaves ina mu Griik aava ri namkai sena Piran e maana matalava tefin sait. ");
INSERT INTO leu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Taasaxa saxano Juda ri tarasui nare e ri xel faxuvul a saxano rabuna saat ti la bina ina mamareiai e ri farawei fasorak a malila. E faasilak, mu rabuna xapiak pe la bina, ri felagafai. Ri falet fataapus xe la lifu si Jeson xena sengaan na Pol nare Sailas senaso ri vubuk o ri taa lisan nare xe la matana malila. ");
INSERT INTO leu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Taasaxa ri pife tingin nare. Ri raagan na Jeson xuvul pana xasanofuna aava ri namkai xe la matana mu paamua ina bina e ri xukulai, “A rovaat aava re fo puk a lamonan sina mu rabuna pe la nu bina, naboxo, re fo savat iau. ");
INSERT INTO leu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","E na Jeson a kas a lifu sina xe sire. Nari xapiak ri taxa kawaasan a vuputkai sina king lava simaam, na Sisaa, layaan ri kuus o a toxan a xasa king, isina na Yesus.” ");
INSERT INTO leu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Layaan ri langai pana, a malila e mu paamua ina bina, ri felagafai pana ferawaian aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","E mui nari aava ri waan xuvul pa Jeson ri mamareiai xe sina mu paamua ina bina e voxo ri mulus tapin nari. ");
INSERT INTO leu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Leaaf layaan a bina fesuk a mu fetinan, ri feng tapin na Pol nare Sailas xe Beria. Layaan re savat pave re laak la lifu ina faxuvulan sina mu Juda. ");
INSERT INTO leu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","A mu rabuna pe Beria xo ri vubuk langai a lagasai, nari ve ri peraroxo sena mu Tesalonaika. La yaan saxa saxa ri lalamon pana Ferawaian sina Piran talo ri taa texaas o a ferawaian si Pol a tuuna o piau. ");
INSERT INTO leu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","E maana Juda xaves ri namkai e maana Griik vaxa, a mu matalava tefin e tomexaan sait. ");
INSERT INTO leu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Taasaxa layaan a mu Juda pe Tesalonaika ri langai o na Pol taxa fapiti a mu Beria sait pana Ferawaian sina Piran, ri falet xe pave xena falagaf a xunus ina rabuna talo ri taa pife langai. ");
INSERT INTO leu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Fataapus a mu fetinan ri feng tapin na Pol xe paa la gun, taasaxa na Sailas nare Timoti re waan fatateak pe Beria. ");
INSERT INTO leu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","A nutuvaat aava ri falet xuvul pa Pol, ri fe lisane xe Etens. E mui ri ulaa fulaa xe Beria pana fefasaian si Pol o na Sailas nare Timoti re taa filimaan fataapus xe sina. ");
INSERT INTO leu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Layaan na Pol taxa waan bang nare pe Etens nane kanamsaat faagut senaso a xalum a bina siri a bas pana maaradaang ina mu piran bit. ");
INSERT INTO leu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","E voxo nane ferawai xe sina mu Juda e mu Griik aava ri suai sena Piran, lana lifu ina faxuvulan siri. E vaxa nane ferawai xe siri aava ri sangas la bina ina mamareiai. ");
INSERT INTO leu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","E saxano rabuna ina fepitaian aava ri toxan a texaasan molava, ri fegagelai xuvul pa Pol. E saxanofuna ri kuus, “A mataa vungut aanabeꞌ i taxa kuus panaso?” E xasanofuna ri kuus, “Nane taxa ferawai pana saxano piran patak paaliu.” Ri kuus malaan senaso na Pol taxa ferawai pa Yesus e a to faꞌulaian sina. ");
INSERT INTO leu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","E mui ri xel lisan na Pol xe la bina ina faxuvulan aava ri xalie pa Erapagas e pave ri xuuse, “Maam buk texaas sena fepitaian faꞌui siim. ");
INSERT INTO leu_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nano, no taxa ferawai pana maana mo patak e maam vubuk texaas sena.” ");
INSERT INTO leu_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","A mu rabuna ti Etens e mu topen aava ri taagul pave, vulai ri buk irimai xena fetalisan a maana lalamonan faꞌui. ");
INSERT INTO leu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Na Pol a tigina la palou ina bina ina faxuvulan aave e a kuus, “Rabuna ti Etens! Ne texaas o mi suai sena mu piran lana maana vilaana xapiak simi. ");
INSERT INTO leu_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Senaso layaan ne sangas xolai la bina simi, ne xalum a nu bina mi taxa lo lotu lana e ne tingin vaxa a nobina saxa pana xakalayan aanabeꞌ: “Xe Sina Piran Aava Maam Vungut Sena”. E voxo a so ta mo mi taxa lotu xe sina lana vungutan simi, a mo aave ne taa xuus fatexaas nami pana. ");
INSERT INTO leu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","A Piran aava vesan a xavala e maana mo lana, nane ve a Memai ina xunavata e xavala. E nane pife taagul lana lifu lotu aava rabuna ri vesane. ");
INSERT INTO leu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Piau ta mo nane vubuxane aava faisok sina mataa mon a fexaxaas sena tavaie pana senaso nane sang mon fuuna tavai a mu rabuna xapiak pana toyan e reref e a maana mo xapiak. ");
INSERT INTO leu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Nane vesan a mataa saxa e maana rabuna xapiak ri savat sena. E nane xa tavai nari pana nobina siri. Lumua nane lamon sena tangpat e fataxapiak ina rabuna e maana fafalas ina nobina ri taa taagul lana. ");
INSERT INTO leu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","E nane vil malaane talo ri taa seng ta salan xe sina e naak ri taa tingine senaso a Piran pife lasuun paaliu setaara. ");
INSERT INTO leu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","A saxa fo kuus, “Pana gutan sina Piran taara taagul e sangas e siak a reref” e saxano rabuna pana texaasan ti la palou imi, ri kuus malaan: “Nemaam sait maam rafulak sina.” ");
INSERT INTO leu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","E voxo tamo taara xapiak ve taara mu rafulak sina Piran, taara taa pife lamon o a Piran a malaan sena maaradaang pana ‘gol’ o ‘silva’ o faat aava mataa fo vesane pana texaasan sina. ");
INSERT INTO leu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Lumua, layaan a mu rabuna ri vungut sena vilaana sina, a Piran a pife fakasanam nari, taasaxa naboxo, nane fasei a mu rabuna xapiak lana mu bina o ri taa puk tapai sena vilaana saat siri. ");
INSERT INTO leu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Senaso nane fo lamon faati sena yaan layaan a mataa aava nane fo fatie, i taa tiis a mu rabuna xapiak pana roxoyan. Nane fo faxalit a mu rabuna xapiak pana layaan nane fatatoi faꞌuli a mataa aave ti la maatan.” ");
INSERT INTO leu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Layaan na Pol a ferawai pana to faꞌulaian ti la maatan, saxano rabuna ri suaxane taasaxa saxanofuna ri kuus, “Maam vubuk langai fulan a ferawaian siim pana mo aanabeꞌ.” ");
INSERT INTO leu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","E voxo na Pol a taꞌulan a faxuvulan aave. ");
INSERT INTO leu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","E saxanu tuvaat aava ri buk waan xuvul pa Pol, ri namkai. La palou iri a saxa mataa, isina na Dionisus aava saxa ti lana Erapagas e saxa tefin, a isina na Damaris, re waan e saxanofuna sait. ");
INSERT INTO leu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Lamina, na Pol a taꞌulan na Etens e a falet xe Korin. ");
INSERT INTO leu_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","E pave nane suai sena saxa Juda ti Pontus, isina na Akwila. Nane savat ti Itali xuvul pa naasana, na Prisila, senaso a memai king Klodias a fasei a mu Juda o ri taa taꞌulan na Rom. Na Pol fe xalum nare ");
INSERT INTO leu_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","e nane taagul e faisok xuvul pare senaso nane fuuna faisok pana vapak ina tiir xena vesanaana lifu, malaan sere. ");
INSERT INTO leu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","E la Yaan saxa saxa ina Fangaafusan, nane laak lana lifu ina faxuvulan e ferawai pana texaasan rao i taa famasam nari mu Juda e mu Griik sait se Yesus. ");
INSERT INTO leu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Layaan na Sailas nare Timoti re savat ti Mesidonia, na Pol a kuusan fasavat vulan a Lagasai Roxo e a xuus fatexaas a mu Juda o na Yesus ve a Mataa Failai sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Taasaxa layaan a mu Juda ri tisuie e ferawai fasaat sena, nane saf tapin a pof ti lana marapi sina xena fakalimaan votan nari e a xuus nari, “Tamo mi taa milung sena Piran, a mo simi mon. Nenia, ne fo fataxapin faroxoi a faisok siak semi. Naboxo ne taa paan xe siri aava ri pife Juda.” ");
INSERT INTO leu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","E mui na Pol a taꞌulan a lifu ina faxuvulan e falet xe la lifu latana, a lifu si Taitus Justus, a saxa aava fuuna lotu xe sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Na Krispas aava paamua ina lifu ina faxuvulan, nane e a matafetama xapiak sina, ri namkai sena Piran. E maana mu Korin sait aava ri langai si Pol, ri namkai e ri fasufan. ");
INSERT INTO leu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Saxa vung a Memai a ferawai xe si Pol lana mifan e a kuus, “Muta mataut, taasaxa no lo ferawai, muta matakasam ");
INSERT INTO leu_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","senaso ne taxa waan xuvul pama. Piau ta mataa i taa falou nano xena famasak nano. A toxan a rabuna xaves lana bina aanabeꞌ, ri rabuna siak.” ");
INSERT INTO leu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","E voxo na Pol a waan pave pana mariaas saxa e xavil xena fapitiaan nari pana Ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Layaan na Galio, a mataa ti Rom, i taxa paamua pe Griik, a mu Juda ri faxuvul e ri yot lisan na Pol xe lana lifu ina tiisan ");
INSERT INTO leu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","e ri kuus, “A mataa aanabeꞌ i taxa fepitaa o a mu rabuna ri taa lotu xe sina Piran pana vilaana aava ri pife waan lana vuputkai sitaara.” ");
INSERT INTO leu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Na Pol i taxa rao i tangpat pana ferawaian e na Galio moxo a xuus a mu Juda, “Langaiau nami mu Juda, tamo mi taxa fefinaas senaso a mataa aanabeꞌ fo mo milung o fo vil a mo mosaat, lavaxa ne taa langai nami. ");
INSERT INTO leu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Taasaxa tamo mi buk fegagelai pana mu vapaling e mu isin e maana vuputkai simi, lavaxa nami xa, mi taa faxaradaxe. Ne taa pife tiis nami pana.” ");
INSERT INTO leu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","E voxo nane feng tapin nari ti lana lifu ina tiisan. ");
INSERT INTO leu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","E mui ri yot fatateak na Sostenis, a saxa paamua ina lifu ina faxuvulan e ri saaxane la matana lifu ina tiisan. Taasaxa na Galio a lamon fepalau mon sena. ");
INSERT INTO leu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","E lamina waanan sina pe Korin pana xasa valayaan, na Pol a taꞌulan a mu fetinan e sangas xe paa Sensaria e xawas xuluna xaati xe pe Siria. Na Prisila nare Akwila re falet xuvul pana. Paamuina faletan sina ti Sensaria nane sapiit a fui sina xena fakalimaan a kuus fanaian sina xe sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Rutul savat pe Efasis e na Pol a taꞌulan na Prisila nare Akwila pave. Nane laak lana lifu ina faxuvulan e a ferawai xuvul pana mu Juda pave. ");
INSERT INTO leu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","E layaan ri fine o i taa waan xuvul pari, nane pife turoxo pana. ");
INSERT INTO leu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Taasaxa layaan a taꞌulan nari nane kuus fanai malaan, “Tamo a Piran i taa kuus turoxo pana ne taa ulaamaan.” E mui nane xawas xuluna xaati e taꞌulan na Efasis. ");
INSERT INTO leu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Layaan nane ung pe Sesaria, nane laak xe paa laaꞌui Jerusalem e fe luxurau siri aava ri namkai e mui a sivi xe puaa Antiaak. ");
INSERT INTO leu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","E lamina waanan sina pe Antiaak, na Pol a guun ti pave e a falet xolai la ro bina Galesia e Fridia xena fatateak a namkaian sina mu rabuna pave. Pevoxo. ");
INSERT INTO leu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Lavaxa, a saxa Juda ti Aleksandria, isina na Apolas, a savat pe Efasis. Nane a mataa ina ferawai faroxo aava texaas fatak sena Ferawaian sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ri fo fapitie pana vilaana sina Memai e nane xo a ferawai faagut e a ferawai fatak se Yesus. Taasaxa nane texaas se Jon e a vilaana ina fasufan sina mon. ");
INSERT INTO leu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nane tangpat pana ferawai faagut la lifu ina faxuvulan. Layaan na Prisila nare Akwila re langaie re xele xe la lifu sire e re xuus famatavase pana vilaana sina Piran talo i taa masam faroxo sena. ");
INSERT INTO leu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","E mui layaan na Apolas rao i paan xe Griik a mu rabuna aava ri namkai, ri kuus turoxo pana e ri xalei a lagasai xe sina mu rabuna aava ri namkai pave rao ri taa suai sena. Layaan nane savat pave nane xavang nari aava ri namkai lapaana xakaavangan xatam sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Senaso nane fuuna ferawai fatak, a ferawaian sina a xasliu a ferawaian sina mu Juda layaan ri fetok la palou ina mu rabuna. E nane faxalit tuunei nari ti lana Ferawaian sina Piran o na Yesus ve a Mataa Failai. ");
INSERT INTO leu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Layaan na Apolas taxa waan pe Korin, na Pol a falet e fe savat pe Efasis. E pave nane tingin saxano rabuna aava ri namkai ");
INSERT INTO leu_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","e fin nari, “A Vovau Xaradak fo sivi xulumi layaan mi namkai, bo?” E ri suie, “Piau, maam pife texaas sena Vovau Xaradak.” ");
INSERT INTO leu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","E na Pol a fiai, “Mi langai a fepitaian siseꞌ e mi fasufan?” E ri kuus, “A fepitaian si Jon e a fasufan sina.” ");
INSERT INTO leu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","E na Pol a kuus, “A fasufan si Jon ve xena kuusan fasavataana maana vilaana saat sina rabuna e nane xuus a rabuna ti Israel o ri taa namkai sena saxa aava i taa savat lamina, a saxa aanabeꞌ ve na Yesus.” ");
INSERT INTO leu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Layaan ri langaie ri namkai se Memai Yesus e ri fasufan lana isina. ");
INSERT INTO leu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Layaan na Pol a timin a mana xuluri, a Vovau Xaradak a sivimaan xuluri e ri ferawai lana maana pok bina patak e vaxa ri kuus fatuxai. ");
INSERT INTO leu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Faasilak a rabuna sangafilu saxa pana taragua ri waan la yaan aave. ");
INSERT INTO leu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","E na Pol a laak lana lifu ina faxuvulan e fepitaa pave pana fulun talatul. Nane ferawai famatavas se Yesus e pana fatataganan sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Taasaxa saxano rabuna ri langai pesalai e ri bai namkai sena e ri ferawai fasaat paaliu pana salan si Memai la matana rabuna. E voxo na Pol a taꞌulan nari. Nane xuvul pana mu rabuna aava ri usie, ri fe faxuvul la lifu ina fepitaian si Tiranus e la yaan saxa saxa ri fuuna ferawai faxuvul pave. ");
INSERT INTO leu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","La fena mariaas taragua ri vil malaane e voxo a Ferawaian sina Piran a falet fepatok xe la nu bina xapiak pe Esia e a mu rabuna pave, a mu Juda e nari mu Griik, ri langai sena. ");
INSERT INTO leu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pana gutan sina Piran na Pol a vil a maana mo faꞌipul malaan: ");
INSERT INTO leu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","a maana marapi modak aava na Pol a tawe, ri lisan nari xe sina mu rabuna aava ri giis. E layaan nari, ri tawe, a giisan siri o a vovau saat siri, ri malit. ");
INSERT INTO leu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","A toxan a saxano Juda aava ri falet xolai xena gei tapin a mu vovau saat sina rabuna e rao ri tafang tareie lapaana isi Memai Yesus. Ri kuus, “Lana isi Yesus aava na Pol a kuusan fasavate, ne fasei nano o no taa taꞌulane.” ");
INSERT INTO leu_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","A mu rafulak tomexaan pisiguak sina saxa memai priis, a isina na Siva, ri fuuna vil malaane. ");
INSERT INTO leu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Saxa yaan a vovau saat a sui nari, “Na Yesus, ne texaas sena e ne texaas se Pol, taasaxa nami ve naseꞌ?” ");
INSERT INTO leu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","E bak a mataa pana vovau saat aave a falou nari pana gutan molava e faꞌonam nari e sip faagutan nari e voxo ri sinuf pana tari a xavuul e ria. ");
INSERT INTO leu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Layaan a mu Juda e mu Griik sait aava ri taagul pe Efasis, ri langai sena, nari xapiak, ri mataut e ri suai faagut pana isi Memai Yesus. ");
INSERT INTO leu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","A maana rabuna aava ri namkai, ri maa savat xo e ri kuusan fasavat a maana vilaana saat siri. ");
INSERT INTO leu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","E a maana rabuna aava ri fuuna neng, ri siak lisan a maana lagasai ina neng siri e ri timin faxuvule la matana rabuna e ri farame. E voxo a mamareiai ina mu lagasai aanabeꞌ a xakatan ina faasilak K10,000,000. ");
INSERT INTO leu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Sena vilaana aanabeꞌ a Ferawaian sina Piran a falet fepatok e fegut paaliu. ");
INSERT INTO leu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Lamina yaan a mo aanabeꞌ savat, na Pol a lamon o i taa sangas falet pe Mesidonia e Griik xena ulaa xe Jerusalem. E nane kuus, “Lamina waanan siak pave ne taa falet xe pe Rom sait.” ");
INSERT INTO leu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nane feng a rovaat aava re xavange, na Timoti nare Eraastus, xe Mesidonia e nane waan famodak fulaa pe la nobina lava, Esia. ");
INSERT INTO leu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","La fena yaan aanabeꞌ a toxan a lagafan molava a savat sena parabuna lana lotu ri xalian pana “Salan sina Memai”. ");
INSERT INTO leu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Saxa mataa ina vavesai pana ‘silva’, isina na Demitrius, nane fuuna vesan a xaxaalua ina lifu lotu sina saxa piran tefin siri, isina na Artemis. A faisok aanabeꞌ fuuna lisan a faat xaves xe sina mu rabuna faisok sina. ");
INSERT INTO leu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","E voxo nane xel faxuvul a mu rabuna ina vavesai aava ri vil a faisok malaan sena e a xuus nari, “Nami mu rabuna, mi texaas o a faat sitaara a savat pana faisok aanabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mi kaalum e mi langai sena faisok si Pol. Nane kuus o a piran aava rabuna ri vesane, pife piran tuuna. E a rabuna ti Efasis e ti la xasano bina pe Esia ri langaie. ");
INSERT INTO leu_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","E faisok sitaara naak i taa savat palau e i taa piau ta isin roxo. E vaxa a lifu lotu sina piran tefin lava, na Artemis, i taa savat palau sait e a piran tefin naang aava rabuna pe la nu bina pe Esia e pe la mu bina xapiak la xavala sait ri lotu xe sina, a isina xo i taa kawaasanan.” ");
INSERT INTO leu_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Layaan ri langai a mo aanabeꞌ ri femarala faagut e ri xukulai, “Na Artemis sang mon sitaara mu Efasis a pemamolava.” ");
INSERT INTO leu_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Faasilak, a mu rabuna pe la bina ri felagafai pana. E ri yot na Gaius e na Eristukus, a rovaat ti Mesidonia aava re sangas xuvul pa Pol e nari xapiak, ri fala fataapus xe la bina ina faxuvulan. ");
INSERT INTO leu_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Na Pol a vubuk o i taa tigina la matana rabuna xena ferawai taasaxa mu rabuna aava ri namkai, ri ti votane. ");
INSERT INTO leu_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","E vaxa saxano paamua ina bina, mu fesing si Pol, ri lisan a lagasai xe sina e ri nung faagutane o i muta savat pave la bina ina faxuvulan. ");
INSERT INTO leu_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A rabuna lana faxuvulan aave ri fevungutai: saxano rabuna ri kuus pana saxano mo e xasanofuna ri kuusan saa xasano mo. E maana rabuna xaves, ri pife texaas senaso ri fo faxuvul pave. ");
INSERT INTO leu_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","A mu Juda ri sagen na Aleksanda xe la nori malaan sena paamua siri e saxanofuna ti la palou ina malila ri xukulai pana fefasaian. E mui nane talangai xe sina malila xena vil fakasam nari talo i taa gel votai sena so ta mo fo savat. ");
INSERT INTO leu_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Taasaxa layaan a malila, ri texaas o nane vaxa saxa Juda, ri fexukulai faxuvul pana awa taragua: “Na Artemis sang mon sitaara mu Efasis a pemamolava!” ");
INSERT INTO leu_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Layaan saxa paamua lava ina bina a vil fakasam nari nane kuus, “Nami mu rabuna ti Efasis, mu rabuna pe la mu bina xapiak ri texaas o mu rabuna ti Efasis ri fuuna faxatang a lifu lotu si Artemis lava e vaxa a xaxaalua ina aava sivimaan ti laaꞌui la xunavata, bo? ");
INSERT INTO leu_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Lavaxa, piau ta rabuna ri taa kuus o a bitan. E voxo mi taa waan kasam e mi muta bilai malaan sena lamavaang. ");
INSERT INTO leu_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mi fo lisanmaan a rovaat aanabeꞌ taasaxa re pife fenau lana lifu lotu o ferawai fasaat sena piran tefin sitaara. ");
INSERT INTO leu_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tamo na Demitrius e mu rabuna faisok sina xo ri vubuk tiis ta saxa mataa, a mu lifu ina tiisan ri talakas e mu paamua ina tiisan ri taxa waan. E voxo nari xo, ri taa fe gel tifie pave. ");
INSERT INTO leu_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tamo mi buk ferawai panꞌ ta saxa mo, mi taa kuusan fasavate lana saxa faxuvulan tuuna pe la bina. ");
INSERT INTO leu_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","E naak netaara xo taara taa tiisan sena maana mo aava savat tanin. E tamo ri taa tiis netaara taara taa pi ta fufuna vilaana sitaara. E taara taa gel malaafaa?” ");
INSERT INTO leu_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","E lamina ferawaian sina nane feng tapin nari. ");
INSERT INTO leu_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Lamina lagafan aanabeꞌ na Pol a xel faxuvul a mu rabuna aava ri namkai e fagut nari. E mui nane taꞌulan nari e falet xe Mesidonia. ");
INSERT INTO leu_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nane falet xolai la mu bina pave e a fagut nari aava ri namkai pana ferawaian sina e mui nane fe savat pe Griik. ");
INSERT INTO leu_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Pave nane waan pana fulun talatul. E mui nane tamasiak rao i taa xawas xuluna xaati xena falet xe Siria. Taasaxa nane texaas o a mu Juda ri fexuus kasam xena punuxaana e voxo nane ulaa fulaa xe Mesidonia. ");
INSERT INTO leu_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Na Sopataa, a lak si Piras ti Beria, na Eristukus e na Sekundas ti Tesalonaika, na Gaius ti Daabe e na Timoti e a rovaat ti Esia, na Tisikas e na Trofimas, nari xapiak, ri vubuk rao ri taa falet xuvul pa Pol. ");
INSERT INTO leu_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ri falet paamuin nemaam e ri waan bang nemaam pe Troas. ");
INSERT INTO leu_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","E nemaam, maam xawas xuluna xaati pe Filipai lamina Fenamo ina Bret Aava Piau Ta Yiis. E lamina yaan pama, maam faxuvul xuvul pari pe Troas. Maam taagul pave pana mu yaan pisiguak. ");
INSERT INTO leu_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lavung, la yaan mata ina ‘wiik’ maam faxuvul xena femiraaxan a matafanganai sina Memai. E senaso na Pol a vubuk rao i taa paan a yaan mui nane fapiti a mu rabuna. A ferawai paan, paan, paan xe la xunavung. ");
INSERT INTO leu_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Maam waan laaꞌui la lifu e a toxan a mu laam xaves pave. ");
INSERT INTO leu_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","A saxa lak faꞌui, isina na Yutikas, a nai la matana lifu e nane fematef. Nane matef maat e poxo ti la matana lifu aave xe lapia. Ri siaxe pana fo maat. ");
INSERT INTO leu_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Taasaxa na Pol a sivi xe lapia e mati xuluna lak e fakaliuane pana mana. E nane kuus, “Muta mataut, i taxa to.” E nane feroxo fulaa. ");
INSERT INTO leu_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","E mui ri laak laaꞌui fulaa e ri viak a bret e ri ngane. E na Pol a ferawai xuvul pari fefexaxaas a paanen lolof e bak a taꞌulan nari. ");
INSERT INTO leu_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","E a mu rabuna ri lisan a lak faꞌui aava to faꞌulaa xe la lifu sina e ri faamamaas pana. ");
INSERT INTO leu_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","E mui maam xawas xuluna xaati e maam falet xe Aasos e pave na Pol taa xawas xuluna xaati xuvul pamaam. Maam vil malaane senaso na Pol rao i taa sangas xe pave. ");
INSERT INTO leu_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","E layaan maam fesuai pe Aasos, nane xawas e nemaam xapiak, maam falet xe Mitalin. ");
INSERT INTO leu_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","A yaan mui maam taꞌulan a bina pave e maam savat faasilak xe Kios. E a yaan mui lamina maam savat pe Samos. La fatalafaataana yaan maam ung pe Miletus. ");
INSERT INTO leu_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Na Pol a lamon o maam taa liu et na Efasis senaso nane bai maam taa waan pe Esia pana yaan xaves. Nane vubuk faagut o maam taa falet fataapus talo maam fexaxaas sena savat pe Jerusalem la Yaan ina Pentakos. ");
INSERT INTO leu_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Maam waan pe Miletus e na Pol a lisan a lagasai xe pe Efasis rao a mu matalava ina tinoxolan ri taa faxuvul xuvul pana. ");
INSERT INTO leu_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","19","E layaan ri savat sina nane xuus nari, “Nami, mi texaas sena vilaana siak layaan ne waan xuvul pami. Ti la yaan mata layaan ne savat pe Esia fefexaxaas naboxo ne mo sisiak sina Memai pana vilaana ina lamon fasivi nenia xa e pana taangiisan. E mi texaas o naapalaan a mu Juda ri fasavat a lagafan e maasaxan xulok, ne sisiak vulai. ");
INSERT INTO leu_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","E vaxa mi texaas o ne pife faatasu sena kuusan fasavat a so ta mo i taa xavang nami e ne fapiti nami la matana rabuna e lana lifu saxa saxa simi. ");
INSERT INTO leu_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ne xuus faagutan a mu Juda e mu Griik xapiak o ri taa puk tapin a vilaana saat siri pana mimilisaatan xe sina Piran e ri taa namkai sena Memai simaam, na Yesus. ");
INSERT INTO leu_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","A Vovau Xaradak a fengau xe Jerusalem e naboxo ne taxa falet. Taasaxa ne pife texaas sena so ta mo i taa savat sega pave. ");
INSERT INTO leu_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ne texaas o lana nobina saxa saxa, a Vovau Xaradak fo xuus fatexaasau o a yaan ina matafanan e vipisan ri taa savat siak. ");
INSERT INTO leu_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Taasaxa ne pife muluk a toyan siak, ne vubuk mon o ne taa fataxapin a faisok siak aava Memai Yesus a tavaiau pana, a faisok ina ferawai xakaavang sena Lagasai Roxo ina xakaavangan xatam sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","E ne fo falet xolai la palou imi xena fapiti nami pana fatataganan sina Piran. E naboxo ne texaas o piau ta mataa ti la palou imi i taa xalum fulanau. ");
INSERT INTO leu_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","E voxo tanin, ne xuus nami o tamo a mataa i taa pife kaaxup, lavaxa pife sena faisok siak. ");
INSERT INTO leu_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Senaso ne fo xuus nami pana vubuxanan e lamonan xapiak sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Faxatang nami e a malila aava Vovau Xaradak a tavai nami pana xena faxatangaan nari. Faxatang faroxoi a mu rabuna sina Piran aava nane maraane pana ria ina. ");
INSERT INTO leu_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Lamina faletan siak ne texaas o a mu rabuna malaan sena vupung saat, ri taa savat la palou imi rao ri taa kawaasan nami, mu rabuna sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","E vaxa ti la palou imi, saxano rabuna ri taa ferawai bit xena yuufaana rabuna aava ri namkai, xe siri. ");
INSERT INTO leu_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Faxatang! Lamon faꞌuli a mariaas talatul aava ne fo taagul xuvul pami. A mu yaan xapiak aave nenia, pana taangiisan, ne pebukan nami. ");
INSERT INTO leu_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","E naboxo ne timin tuunei nami lapaana Piran e a lagasai ina xakaavangan xatam sina aava fexaxaas sena fagutaan nami e tavai nami aava mi tigina patak xuvul pana Piran pana maana roxoyan. ");
INSERT INTO leu_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ne pife sei soxot a ‘silva’ o ‘gol’ o marapi sina mataa. ");
INSERT INTO leu_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Nami, mi texaas o ne fo faisok pana maak xena maraan a maana mo nenia e mu fesing siak, maam vubuxane. ");
INSERT INTO leu_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","E lana maana mo ne fo vile ne faxalit nami o taara taa xavang a mu rabuna marurupak e taara taa lamon faꞌuli a ferawaian si Yesus layaan a kuus, ‘A mataa aava tatavai pana maana mo i taa toxan a faamamaasan molava sena saxa aava saxam a mo.” ");
INSERT INTO leu_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Layaan na Pol a fataxapin a ferawaian sina, nari xapiak ri tapiit turung e ri fenung. ");
INSERT INTO leu_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","E nari xapiak ri taangiis e ri feyotan na Pol e ri fengusane. ");
INSERT INTO leu_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","A mo aava famamaxus paaliuan nari ve a paferawaian sina o ri taa pife xalum fulane. E voxo ri falet xuvul pana xe la xaati. ");
INSERT INTO leu_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Maam taꞌulan nari pana mimilisaatan lava e maam xawas xuluna xaati e xol fatak xe pe Kos. A yaan mui maam savat pe Rods e maam taꞌulan a bina pave e savat pe Patara. ");
INSERT INTO leu_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pe Patara maam tingin a xaati rao i falet xe Fonisia e maam xawas xena falet. ");
INSERT INTO leu_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Lana faletan simaam maam xalum na Saipras e maam liue xe pul e maam fe xol fatak xe Siria. Maam ung pe Tair e pave ri siak tapin a maana mo aava waan lana xaati simaam. ");
INSERT INTO leu_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Maam tingin a mu rabuna aava ri namkai e maam waan xuvul pari pana yaan pisiguak. A Vovau Xaradak a ferawai xe siri e ri xuus na Pol o i muta falet xe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Taasaxa layaan a mu yaan simaam a taxapus et, maam taꞌulan nari e falet fulaa. A mu rabuna si Yesus nari lutefin e mu rafulak siri sait, ri falet xuvul pamaam xe lamalei la bina. E pave la gun maam tapiit turung xena fenung. ");
INSERT INTO leu_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Maam ferawai fesuai e mui maam xawas xuluna xaati e nari, ri ulaa xe la bina siri. ");
INSERT INTO leu_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Maam falet fulaa e maam taꞌulan a bina Tair e maam fe ung pe Tolimas. E pave maam fasusui a mu fetinan e maam waan xuvul pari pana yaan saxa. ");
INSERT INTO leu_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","A yaan mui maam taꞌulan nari e fe savat pe Sesaria. E maam waan la lifu sina saxa mataa ina kuusan fasavat a Lagasai Roxo, na Filip. Nane saxa ti la palou ina pisiguak aava ri siak fati nari pe Jerusalem xena xavang a mu yaamut. ");
INSERT INTO leu_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nane toxan a lak tefin talafaat aava ri pife tamai lunai e nari, ri fuuna kuus fatuxai. ");
INSERT INTO leu_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Maam fo mo waan pave pana valayaan layaan a mataa ina kuus fatuxai, isina na Aagabas, a sivimaan ti Judia. ");
INSERT INTO leu_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","A maa savat simaam e siak a yowang si Pol e a pis a mana e kana xa pana e a kuus, “A Vovau Xaradak a kuus, ‘A mu Juda pe Jerusalem ri taa pis a mataa tafuna yowang aanabeꞌ malaan e tavai a mu rabuna aava ri pife Juda pana.” ");
INSERT INTO leu_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Layaan maam langaie nemaam xapiak maam nung faagutan na Pol o i taa pife laak xe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","E na Pol moxo a suie, “Senasou mi taxa taangiis faagut e mi kawaasan a lamonan siak? Ne fo faigotanau naapalaan ri taa pisau e vaxa ne taa maat pe Jerusalem sena isi Memai Yesus.” ");
INSERT INTO leu_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Layaan i taa pife xul a lamonan sina maam turoxo pana e maam kuus, “A vubuxanan sina Memai i taa savat la matavas.” ");
INSERT INTO leu_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Maam taagul pave pana valayaan e mui maam tamasiak e maam guun xe Jerusalem. ");
INSERT INTO leu_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Saxano rabuna ti Sesaria aava ri namkai, ri falet xuvul pamaam e ri lisan nemaam xe la lifu sina saxa mataa ti Saipras, isina na Naason. Nane a mataa aava namkai ti kavai. ");
INSERT INTO leu_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Layaan maam savat pe Jerusalem a mu rabuna sina Piran, ri fasusui faagutan nemaam. ");
INSERT INTO leu_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","E a yaan mui nemaam Pol, maam fe tixalum na Jems. A mu matalava ina lotu vaxa ri waan faxuvul pave. ");
INSERT INTO leu_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","E na Pol a fasusui nari e a xuus nari pana maana mo xaves a Piran fo vile la palou ina mu rabuna aava ri pife Juda sena faisok sina. ");
INSERT INTO leu_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Layaan ri langaie ri kuus faasiroxo xe sina Piran. E mui ri xuus na Pol, “Nano, timaam, no texaas o a maana Juda xaves aava ri namkai, ri usi faagutan a vuputkai sitaara. ");
INSERT INTO leu_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","E ri fo langai o no fo fapiti a mu Juda aava ri taagul la bina sina mu rabuna aava ri pife Juda o ri taa taꞌulan a vuputkai si Moses. E vaxa no xuus nari o ri taa pife putuk a rafulak siri o usi a mu vilaana sina mu Juda. ");
INSERT INTO leu_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","E voxo maam taa vil a so? Tuuna ri taa langai pana savatan siim, ");
INSERT INTO leu_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","e voxo maam vubuk o no taa vil a maana mo aava maam taa xuus nano pana. A toxan a mataa talafaat nabeꞌ e ri fo fakalimaan nari xa xe sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Falet xuvul pari e vil a vilaana ina xakaamak e maraan a faisok ina xangat a fui siri. Sena vilaana aanabeꞌ a mu rabuna xapiak ri taa texaas o nano fatak xa no usi a vuputkai si Moses e piau ta mo tuuna lana ferawaian sema. ");
INSERT INTO leu_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","E sena mu rabuna aava ri pife Juda e ri namkai, maam fo lisan a lagasai xena xuus nari pana lamonan simaam o ri taa pife ngan a meska aava ri tatavai xe sina mu piran bit pana o ta ria, o ta meska aava fo xiutan e vaxa ri taa pife paruk.” ");
INSERT INTO leu_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Lavaxa, a yaan mui na Pol xuvul pana nu tuvaat aave, ri vil a vilaana ina xakaamak. E mui nane laak xe la tang lifu lotu xena kuusan a yaan i taa fataxapin a yaan ina xakaamak e ri taa lisan a tatavai siri saxa saxa. ");
INSERT INTO leu_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Layaan a yaan pisiguak ina xakaamak a faasilak ri taxapus, saxano Juda ti Esia ri xalum na Pol lana tang lifu lotu e ri falalagaf a malila e voxo ri yot na Pol. ");
INSERT INTO leu_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","E ri xukulai, “Mi rabuna ti Israel, xavang nemaam! A mataa aanabeꞌ a falet xolai xena fapiti pengan a xasanofuna sena mu rabuna ti Israel e a vuputkai si Moses e a tang lifu lotu nabeꞌ. E naboxo nane lisanmaan a saxanofuna aava ri pife Juda xe lana tang lifu lotu sitaara xena kawaasan a nobina xaradak!” ");
INSERT INTO leu_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Ri kuus malaan senaso ri fo xalum na Trofimas ti Efasis pe Jerusalem xuvul pa Pol e ri lamon o na Pol fo xel falaxe xe lana tang lifu lotu, taasaxa piau.) ");
INSERT INTO leu_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","A mu rabuna xapiak pe la bina ri felagafai e ri falamaan ti la maana nobina e ri yot na Pol e ri raagane ti lana tang lifu lotu. E fataapus, ri xawei a matana yalaxau. ");
INSERT INTO leu_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","E layaan a malila ri taxa tafang pana sip punuxaan na Pol, a memai sina rabuna ina fevisan ti Rom a siak a lagasai o a mu rabuna pe Jerusalem rao ri fevis. ");
INSERT INTO leu_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Fataapus, a memai aanabeꞌ xuvul pana saxano paamua e mu rabuna ina fevisan ri fala sivi xe sina malila. Layaan a rabuna ri xalum a memai aave e mu rabuna sina, ri pife sip fulan na Pol. ");
INSERT INTO leu_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","A memai a filimaan e maa yot na Pol e fasei nari o ri taa pise pana ‘sein’ taragua. E mui nane fiai o nane naseꞌ e nane fo vil a so ta mo? ");
INSERT INTO leu_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Saxanofuna ri xukulai pana saxa mo e saxanofuna ri xukulai pana xasa mo. E a memai a pife fexaxaas sena siak tuunei a fufuna xukulaian siri. E voxo nane fasei a rabuna sina o ri taa lisan falak na Pol xe lana bina sina rabuna ina fevisan. ");
INSERT INTO leu_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Layaan na Pol a savat la sangas laaxan a maraleian sina rabuna femolava temasaat e voxo a mu rabuna ina fevis ri yaas na Pol. ");
INSERT INTO leu_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","E a malila aava ri usi soxote, ri taxa lo xukulai faagut, “Punuxe!” ");
INSERT INTO leu_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Layaan a mu rabuna ina fevisan ri buk lisan na Pol xe lana bina siri nane fin a memai siri, “A fexaxaas ne taa ferawai xe siim?” E a memai a xuuse, “No ferawai lana pok bina Griik, bo? ");
INSERT INTO leu_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nano, no saxa ti Isip aava saxano yaan lumua no paamuian a rabuna saat 4,000 xe la xobingil, bo?” ");
INSERT INTO leu_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","E na Pol a suie, “Nenia ve ne saxa Juda ti Taasus pe Silisia, a fufubina siak a toxan a isin lava. A fexaxaas ne taa ferawai xe sina malila?” ");
INSERT INTO leu_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Layaan a memai a kuus turoxo pana, na Pol a talangai xe siri talo ri taa waan kasam. E layaan ri waan kasam nane ferawai xe siri lana pok bina Erameik. ");
INSERT INTO leu_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Nane ferawai malaan, “Mu fetinan e mu matalava, naboxo langai a gel votaian siak.” ");
INSERT INTO leu_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Layaan ri langai o nane ferawai xe siri lana pok bina Erameik ri ti kasam paaliu. E mui na Pol a ferawai fulaa. ");
INSERT INTO leu_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nenia ve ne saxa Juda ti Taasus pe Silisia taasaxa ne fo molava nabeꞌ Jerusalem. E na Gameliel a fapiti faroxoiau pana mu vuputkai sina butaara e ne usi fatak a Piran malaan semi nabeꞌ. ");
INSERT INTO leu_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","E vaxa ne fo kawaasan xapin nari aava ri usi a ‘Salan’ aanabeꞌ. Ne yot a mu rabuna tomexaan e lutefin xapiak e ne tapin falak nari xe lana lifu ina vipisan. ");
INSERT INTO leu_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","E a memai priis e mu matalava ri texaas o a ferawaian siak a tuuna. E vaxa ne siak a lagasai siri xe sina mu Juda pe Damaaskas e voxo ne falet xe pave xena yot lisan a mu rabuna aave malaan sena mu vipis xe Jerusalem xena fakasanamaan nari. ");
INSERT INTO leu_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Faasilak la belo ne fe savat pe Damaaskas e fataapus a malang molava piis ti la xunavata a rarapak fakaliuanau. ");
INSERT INTO leu_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","E ne poxo lapia e ne langai a ling aava xuusau, ‘Sol, Sol xenaso no taxa vil penganau?’ ");
INSERT INTO leu_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","E ne fiai, ‘Memai nano naseꞌ?’ E nane kuus, ‘Nenia ve na Yesus ti Nasaret aava no taxa vil pengane.’ ");
INSERT INTO leu_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","E mu rabuna aava ri sangas xuvul paga ri xalum a malang aave taasaxa ri pife masam a ling aava ferawai xe siak. ");
INSERT INTO leu_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","E ne fiai, ‘Ne taa vil a so?’ E a Memai a kuus, ‘Tamasiak e no falet xe Damaaskas e pave no taa texaas sena maana mo aava Piran a vubuk o no taa vile.’ ");
INSERT INTO leu_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","E mu fesing siak ri tawi la maak e ri lisanau xe Damaaskas senaso a malang rarapak fo fapiifau. ");
INSERT INTO leu_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“E pave saxa mataa, isina na Ananaias, maa xalumau. Nane usi fatak a mu vuputkai sitaara e mu Juda pave ri suai sena. ");
INSERT INTO leu_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Nane tigina la taak e a kuus, ‘Tiak Sol, kaalum fulaa!’ E monabeꞌ mon ne fexaxaas sena xalume. ");
INSERT INTO leu_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“E mui nane xuusau, ‘A Piran sina mu butaara fo siak fati nano talo no taa texaas sena vubuxanan tuuna sina e no taa xalum a Saxa aava xaradak e no taa langai a ferawaian ti la ngusuna fatak. ");
INSERT INTO leu_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","E no taa kuus xakaavang pana maana mo aava no fo xalume e langaie xe sina mu rabuna xapiak. ");
INSERT INTO leu_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","E naboxo no taxa nai bang a so? Tamasiak e no taa fasufan e gei tapin a mu vilaana saat siim lana isi Yesus.’ ");
INSERT INTO leu_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ne ulaa xe Jerusalem e layaan ne taxa fenung pave la tang lifu lotu ne toxan a xakaaluman. ");
INSERT INTO leu_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","E lana xakaaluman aanabeꞌ a Memai taxa ferawai xe siak malaan, ‘Fataapus, taꞌulan na Jerusalem, senaso nabeꞌ ri taa pife turoxo pana ferawaian siim, sega.’ ");
INSERT INTO leu_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“E ne kuus, ‘Memai, a mu rabuna nabeꞌ ri texaas o lumu ne fuuna lo falet xolai xe lana mu lifu ina faxuvulan e ne sip nari e ne pis nari aava ri namkai sema. ");
INSERT INTO leu_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","E layaan a ria ina sisiak fatak siim, na Stefan, a tiuanan, nenia, ne kuus turoxo pana e ne tigina faasilak xena faxatang a marapi siri aava ri taxa punuxe.’ ");
INSERT INTO leu_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“E mui a Memai a xuusau, ‘Falet, ne taa feng nano xe lasuun xe sina mu rabuna aava ri pife Juda.” ");
INSERT INTO leu_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lavaxa, a malila ri langai si Pol fefexaxaas a ferawai malaan. E mui ri xukulai faagut paaliu, “Punuxe, a xavala taa peraroxo tamo i taa maat.” ");
INSERT INTO leu_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ri taxa xukulai e falep a marapi siri e ri taxa tapin falak a pof xe laaꞌui ");
INSERT INTO leu_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","e voxo a keptin a kuus faagut o ri taa lisan falak na Pol xe lana bina sina rabuna ina fevisan. E nane fasei nari o ri taa inis na Pol talo ri taa texaas tuuna sena fufuna maraleian sina mu rabuna sena. ");
INSERT INTO leu_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Taasaxa layaan ri fo pise xena inise, na Pol a fin a sensurian, “Naak mi taa inis a saxa ti Rom aava ri pife tiis lunaiane, bo?” ");
INSERT INTO leu_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","E layaan a sensurian a langaie, nane fe kuusane xe sina keptin sina. E a fine, “A so ta mo no taxa vile, a mataa aapave a saxa tuuna ti Rom.” ");
INSERT INTO leu_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","E voxo a keptin fe fin na Pol, “Xuusau, nano, no saxa ti Rom, bo?” E na Pol a suie, “Aang!” ");
INSERT INTO leu_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","E mui a keptin a kuus, “Nenia, ne maraan a vepen ina taagulan siak pana maana faat xaves.” E na Pol a suie, “Taasaxa, nenia, ne fo siaxe ti la yaan ina luluuxan siak.” ");
INSERT INTO leu_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","E nari aava ri vubuk o ri taa fin na Pol pana maana fiaian xaves, ri taꞌulai fataapus mon. A keptin a mataut layaan a texaas o nane fo pis na Pol, saxa tuuna ti Rom. ");
INSERT INTO leu_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","A keptin aave a buk texaas sena so ta mo a mu Juda ri taxa gel tifi na Pol pana. E voxo a yaan mui nane mulus na Pol e fasei a mu paamua priis e mu matalava ina Saniidrin o ri taa faxuvul. E bak nane siak lisan na Pol e fatigineie la nori. ");
INSERT INTO leu_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","E na Pol a kaalum fatateak xe sina mu matalava ina Saniidrin e a kuus, “Mu fetinan, la toyan xapiak siak ne fo tigina la matana Piran pana nasaman roxo.” ");
INSERT INTO leu_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","E na Ananaias, a memai priis, a fasei a rabuna la ta Pol o ri taa tavaf a yaavana. ");
INSERT INTO leu_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","E na Pol a xuuse, “Tuuna a Piran i taa tavaf a yaavaam. Nano, no malaan sena mamaat aava kaalum faroxo taasaxa pe lana a maana mo fo miit. No nai pave xena tiisau lapaana vuputkai e nano xa no milung sena layaan no fasei nari o ri taa tavafau.” ");
INSERT INTO leu_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","E a rabuna la ta Pol ri xuuse, “No taxa suaxan pengan a memai priis sina Piran.” ");
INSERT INTO leu_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","E na Pol a kuus, “Mu fetinan, ne pife texaas o nane a memai priis. Ne texaas sena paxakalayan sina Piran aava kuus, ‘No taa pife suaxan pengan a memai priis sina Piran.” ");
INSERT INTO leu_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","E mui na Pol a kaalum xolai e a xalum a saxanofuna ti lana parabuna aava ri xalie pana Sedusi, ri waan pave e vaxa saxanofuna ti lana parabuna aava ri xalie pana Ferasi. E voxo nane kuus falava malaan, “Mu fetinan, nenia ve ne Ferasi e ne lak sina saxa Ferasi. E mi taxa tiisau senaso ne taxa waan bang fatateak a to faꞌulaian ti la maatan.” ");
INSERT INTO leu_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Layaan nane kuus malaan a mu Ferasi e mu Sedusi ri fegagelai e a malila ri lamon fepatok. ");
INSERT INTO leu_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(A mu Sedusi aave, ri kuus o piau ta to faꞌulaian ti la maatan e vaxa piau ta angelo o mu vovau. Taasaxa mu Ferasi ri namkai serutul xapiak.) ");
INSERT INTO leu_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","A xukulaian felava e saxano rabuna ina fepitaa pana vuputkai aava ri Ferasi, ri tigina e ri kuus faagut, “Nemaam, maam lamon o a mataa aanabeꞌ a pife vil ta mo mosaat. Naak a angelo o saxa vovau a ferawai xe sina.” ");
INSERT INTO leu_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","E mu Ferasi e mu Sedusi ri fegagelai faagut talo a memai ina fevisan a lamon o ri taa famasak faagutan na Pol pana feyuufan xolane. E voxo nane feng fasivi a rabuna sina xena xel patak na Pol xaseri e lisan falaxe xe lana lifu ina waanan sina rabuna ina fevisan. ");
INSERT INTO leu_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","E a vung mui a Memai Yesus a tigina la ta Pol e a xuuse, “Muta mataut! No fo kuusanau nabeꞌ Jerusalem e vaxa no taa vile pe Rom.” ");
INSERT INTO leu_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","E a paanen mui saxano Juda ri fexuus kasam pana punuxaan na Pol. Ri kuus fanai o ri taa pife fangan o num fefexaxaas a yaan ri punuxe. ");
INSERT INTO leu_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","A rabuna moxaves sena sangafilu talafaat ri kuus fanai faxuvul malaan. ");
INSERT INTO leu_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","E ri fe xuus a mu paamua priis e mu matalava malaan, “Maam fo kuus fanai o maam taa falfaal fefexaxaas maam taa punuk na Pol. ");
INSERT INTO leu_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","E voxo nami e mu Saniidrin, mi taa nung a memai ina fevisan o i taa lisanmaan na Pol xe simi talo mi taa siak a texaasan fulaa sena vilaana saat sina. Taasaxa maam taa punuxe paamuina savatan sina.” ");
INSERT INTO leu_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Taasaxa a lak tomexaan si vasaa Pol a langai kasam a ferawaian siri. E voxo nane fe laak xe la lifu ina vipisan e a xuus fatexaas na Pol pana. ");
INSERT INTO leu_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","E bak na Pol a xel a saxa sensurian e a kuus, “Lisan a mataa faꞌui aanabeꞌ xe sina memai siim senaso nane buk xuuse pana saxa mo.” ");
INSERT INTO leu_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nane lisan a mataa faꞌui aave xe sina memai sina e a kuus, “A mataa vipis, na Pol, a xelau e a finau rao ne taa lisanmaan a mataa faꞌui aanabeꞌ xe siim senaso nane buk xuus fatexaas nano pana saxa mo.” ");
INSERT INTO leu_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","E a memai a tao a mana mataa faꞌui e a xel pataxe talo pi ta mataa i taa langai a ferawaian sire e a fine, “Rao no xuusau pana so?” ");
INSERT INTO leu_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","E a lak a kuus, “A mu paamua sina mu Juda ri turoxo xena fin nano o mafu no taa lisanmaan na Pol xe siri talo ri taa fin fulane pana vilaana saat sina. ");
INSERT INTO leu_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Taasaxa ri taxa bit. Muta turoxo pana senaso a rabuna sangafilu talafaat ri taxa funai bang xena punuxaana. Ri fo kuus fanai o ri taa falfaal fefexaxaas ri punuxe. E naboxo ri taxa waan bang a susuaa siim.” ");
INSERT INTO leu_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","E a memai a xuuse, “Muta xuus a rabuna o no fo xuusau pana maana mo aanabeꞌ.” E nane feng tapin a mataa faꞌui aave. ");
INSERT INTO leu_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","E mui a xel a ro sensurian sina e a fasei nare, “Xel faxuvul a rabuna ina fevisan 200 e nari xuvul pana mu rabuna sangafilu pisiguak aava ri fuuna nai xuluna ‘hos’ e vaxa a mu rabuna ina fevisan pana tol 200 e ne vubuk o mi taa falet xe Sesaria la 9 oklok tanin la vung. ");
INSERT INTO leu_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","E vaxa, siak a nu ‘hos’ talo na Pol i taa falet xuluna e lisan faroxoi na Pol xe si Felik, a Matalava pe Sesaria.” ");
INSERT INTO leu_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","E nane lisan a lagasai malaanabeꞌ: ");
INSERT INTO leu_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Ti Klodias Laisias Xe si Matalava Roxo, Felik Paanen Roxo, ");
INSERT INTO leu_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","A mataa aanabeꞌ xo, a mu Juda ri fo yote xena punuxaana. Taasaxa ne langai o nane ve a mataa fatak ti Rom e voxo ne savat pave xuvul pana rabuna ina fevisan siak xena fakaxupe xaseri. ");
INSERT INTO leu_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ne buk texaas senasou tuuna ri buk punuxe e voxo ne lisane xe sina mu Saniidrin. ");
INSERT INTO leu_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","E ne fo siak a texaasan o a maana gel tifian siri aave ri maana fiaian ina mu vuputkai fatak siri e nane pife vil a mo mosaat talo i taa fakasanaman o punuxan. ");
INSERT INTO leu_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Layaan a saxa maa xuus fatexaasau pana saxa lamonan ri buk vile sena, fataapus mon ne fenge xe siim. E vaxa ne fasei a mu rabuna aava ri tisuie o ri taa savat xe siim xena xuus fatexaas nano pana fufuna tisuiaan na Pol siri. Nane sang movoxo. ");
INSERT INTO leu_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","E voxo a mu rabuna ina fevisan ri langai e la vung ri xel na Pol e ri lisane xe pe Antipatris xuvul pari. ");
INSERT INTO leu_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","A yaan mui a mu rabuna aava ri nai xuluna ‘hos’ ri falet fulaa xuvul pa Pol e mu rabuna ina fevisan, ri ulaa xe la lifu ina waanan siri. ");
INSERT INTO leu_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Layaan a rabuna aave pana mu ‘hos’, ri savat pe Sesaria ri fe lisan a lagasai xe si Felik, a matalava ina bina aave e ri kuus, “Naboxo, na Pol taxa waan lapaana faxatangan siim.” ");
INSERT INTO leu_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Layaan a matalava fo kat xapin a lagasai si Laisias a fin na Pol, “No filimaan ti faa?” Na Pol a suie, “Ti Silisia.” ");
INSERT INTO leu_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Na Silisia a bina lasuun paaliu e voxo na Felik a xuuse, “Ne taa langai a gel votaian siim layaan a mu rabuna ina tisuiaan nano ri maa savat.” E mui nane fefasaa o ri taa faxatang na Pol lana lifu lava aava na Herot fo vesane. ");
INSERT INTO leu_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","A yaan pama fo taxapus e a memai priis, na Ananaias, fe sivi xe pe Sesaria xuvul pana saxano matalava e saxa mataa ina vuputkai, isina na Tertulis. Nari xapiak ri maa savat si Felik xena xuus fatexaase pana mu vilaana saat si Pol. ");
INSERT INTO leu_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ri xel fasavat na Pol e mui na Tertulis a tangpat pana ferawaian sina xe si Felik pana gelan siri, “Maam faamamaas pana paamuian siim senaso a tavai nemaam pana maana yaan xaves ina luaian. E pana texaasan siim no puk a maana mo simaam talo a waanan simaam feroxo. A maana mo aanabeꞌ a roxo e maam faamamaas pana. ");
INSERT INTO leu_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Lana mu bina xapiak maam turoxo pana maana vilaana siim e maam kuus faasiroxo xe siim. ");
INSERT INTO leu_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Taasaxa, maam bai famamaxus nano pana ferawaian simaam e voxo tamo no taa langaiau ne taa ferawai famodak mon. ");
INSERT INTO leu_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Maam texaas sena mataa aanabeꞌ. Nane a mataa saat senaso nane vil falagaf a rabuna la mu bina xapiak. E vaxa, nane ve a saxa paamua sina mu Nasaret, saxa lotu bit. ");
INSERT INTO leu_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Nane rao i taa vil a saat sena lifu lotu sina mu Juda e voxo maam fo yote. ");
INSERT INTO leu_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Maam buk tiise lapaana vilaana simaam taasaxa na Paamua Laisias maa savat e xel fatuaiane xasemaam. ");
INSERT INTO leu_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","E na Laisias a fasei a mu rabuna aava ri tisui na Pol o ri taa savat xe siim. Tamo no taa fine pana no taa texaas tuuna sena maana gelan maam taxa kuusane.” ");
INSERT INTO leu_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","A mu Juda sait ri kuus o a maana mo aanabeꞌ a fatak. ");
INSERT INTO leu_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Na Matalava Felik a talangai xe si Pol talo i taa ferawai saa e na Pol a gel votan a vilaana sina malaan, “Ne texaas o nano, no fo paamuian a rabuna simaam la maana yaan xaves e voxo ne faamamaas pana gel votai la mataam. ");
INSERT INTO leu_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","No fexaxaas sena fin a rabuna xena texaas tuuna o la yaan sangafilu pana taragua lumua ne laak xe kol Jerusalem xena lotu xe sina Piran. ");
INSERT INTO leu_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","A mu rabuna nabeꞌ aava ri tisuiau, layaan ri tinginau, ne pife ti fegagelai panꞌ ta mataa, piau. E ne pife fatamasiak a mu rabuna pe la nobina ina fepitaa o ta xasano bina xena maraaxan nari. ");
INSERT INTO leu_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","E naboxo ri pife fexaxaas sena faxalit tuunei a maana mo ri taxa gel tifiau pana. ");
INSERT INTO leu_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Taasaxa a tuuna, ne nangus a Piran si tamamaam layaan ne usi a Salan aava ri xalie pana lotu bit. Ne namkai sena mu vuputkai xapiak aava na Moses a tavai nemaam pana e maana mo aava mu rabuna ina kuus fatuxai sina Piran ri fo xaleie. ");
INSERT INTO leu_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","E vaxa malaan sena mu rabuna aanabeꞌ, ne taxa waan bang fatateak a Piran aava vil fatatoi a mu rabuna roxo e mu rabuna saat ti la maatan. ");
INSERT INTO leu_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","E voxo, ne vil vulan a maana mo xapiak talo a nasaman siak i taa matavas la matana Piran e mu rabuna. ");
INSERT INTO leu_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Ne pife savat pe Jerusalem la maana mariaas e ne laak xe kol pave xena lisan a tatavai xe sina Piran e mu valagof. ");
INSERT INTO leu_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","“Ne taxa waan lana lifu lotu sina mu Juda sena tatavaian aanabeꞌ layaan ri tinginau. Ne fo mo vil a roxo: nenia xa ne fo xakaamak xena usi a vuputkai simaam e piau ta malila xuvul paga e piau ta felingaian. ");
INSERT INTO leu_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Taasaxa saxano Juda ti Esia, ri waan pave e naak nari sang ri taa savat iau la mataam xena xuus fatexaas nano pana so ta mo ri tisuiau pana. ");
INSERT INTO leu_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Taasaxa kalak, a mu Juda aanabeꞌ ri waan pave layaan ne gel votan a maana mo aanabeꞌ la matana Saniidrin. Fin nari pana so ta mo mosaat ne fo vile tamo ri fexaxaas sena xuus tuunei nano pana. ");
INSERT INTO leu_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Naak a saxa mo mon nabeꞌ ne xukulai pana, ‘Ne waan nabeꞌ la matana rabuna xena gel votai senaso ne namkai o a mu mamaat ri taa to faꞌulaa.” ");
INSERT INTO leu_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Na Felik fo texaas sena vilaana sina rabuna ina Salan aave, e voxo a fataxapin a tatafangai. Nane kuus, “Layaan na Laisias aava paamua sina rabuna ina fevisan, i taa savat ne taa lamon faati sena tiisaan nano.” ");
INSERT INTO leu_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nane fasei a saxa sensurian o i taa faxatang faagutan na Pol taasaxa i taa pife ti votan a mu fesing sina tamo ri maa savat xena xavangaana. ");
INSERT INTO leu_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Lamina valayaan na Felik nare tefin sina, na Drusila aava saxa Juda, re maa savat. Nane xel na Pol xena langai a ferawaian sina pana namkaian se Yesus Krais. ");
INSERT INTO leu_vpl VALUES ("AC24_25","074_24_2