﻿USE sofia;
DROP TABLE IF EXISTS sofia.ldb_vpl;
CREATE TABLE ldb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ldb_vpl WRITE;
INSERT INTO ldb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ubvur unang Uyesu Ukiristo, ungwɛ̃ Udauda uwuruwi aka awu ungwɛ̃ Uibrahim. ");
INSERT INTO ldb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Uibrahim unga awu utɛ Uishaku, Uishaku unga awu utɛ Uyakubu, Uyakubu unga awu utɛ Uyahuda nu angwɛ̃mbɔ, ");
INSERT INTO ldb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Uyahuda unga awu utɛ Ufereza nu Uzera, uyisumbɔ aka awu Utamar, Ufereza unga awu utɛ Uhezuron, Uhezuron unga awu utɛ Uaram, ");
INSERT INTO ldb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Uaram unga awu utɛ Uamminadab, Uamminadab unga awu utɛ Unashon Unashon unga awu utɛ Usarhmon, ");
INSERT INTO ldb_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Usarhmon unga awu utɛ Ubo'aza. Urahab unga amar Ubo'aza, Ubo'aza unga awu utɛ Uobida. Urut unga amar Uobida, Uobida unga awu utɛ Ujesse, ");
INSERT INTO ldb_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ujesse unga awu utɛ Uyɛrhe Udauda. Udauda unga awu utɛ Usorhomon. Utsɛrha Uriya unga amar Usorhomon, ");
INSERT INTO ldb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Usorhomon unga awu utɛ Urhehobowam, Urhehobowam unga awu utɛ Uabijah, Uabijah unga awu utɛ Uasa, ");
INSERT INTO ldb_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Uasa unga awu utɛ Uyehoshafat, Uyehoshafat unga awu utɛ Uyoram, Uyoram unga awu utɛ Uazariya, ");
INSERT INTO ldb_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uazariya unga awu utɛ Uyotam, Uyotam unga awu utɛ Uahaz, Uahaz unga awu utɛ Uhezekiya, ");
INSERT INTO ldb_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Uhezekiya unga awu utɛ Umanasse, Umanasse unga awu utɛ Uaman, Uaman unga awu utɛ Uyosiya, ");
INSERT INTO ldb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Uyosiya unga awu utɛ Uyekoniya nu angwɛ̃mbɔ ri ivangyɛ umbɔ aka akarha umbɔ azĩ abĩ akase ru Ubabirha. ");
INSERT INTO ldb_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Umbɔ aka akarha umbɔ azĩ atsĩ abĩ akase ru Ubabirha, Uyekoniya unga awu utɛ Usheyarhtiyerh, Usheyarhtiyerh unga awu utɛ Uzerubaberh, ");
INSERT INTO ldb_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Uzerubaberh unga awu utɛ Uabihudu, Uabihudu unga awu utɛ Uerhiyakim, Uerhiyakim unga awu utɛ Uazor, ");
INSERT INTO ldb_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Uazor unga awu utɛ Uzadak, Uzadak unga awu utɛ Uakim, Uakim unga awu utɛ Uarhiyud, ");
INSERT INTO ldb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Uarhiyud unga awu utɛ Uerhiyeza, Uerhiyeza unga awu utɛ Umatana, Umatana unga awu utɛ Uyakubu, ");
INSERT INTO ldb_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Uyakubu unga awu utɛ Uyusuf utsaka Umaryamu, uya Uyesu, umbɔ aki iyisa Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kishoo andanna udzur ri Uibrahim uba utsĩ Udauda awu usɔka na anaa. Udzur nu Udauda uba utsĩ ri ivangyɛ umbɔ aka akarha abi Uisrairha azĩ abĩ akase ru Ubabirha, andanna awu usɔka na anaa. Udzur umɔ uba utsĩ Ukiristo, andanna awu usɔka na anaa. ");
INSERT INTO ldb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Imar Uyesu Ukiristo iwe riminɛ. Uyanga Umaryamu awu ukarh Uyusuf. Umbɔ anasi ipfunumbɔ, nu umbɔ anyã unga awu ra anaa ru ubok Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ukarhnga Uyusuf arhiku uner asi ibeenga idzowe unga atsa ra asu anera, unga akaifɛrhkɔ iyiki ibɔre unga ri iwɔk. ");
INSERT INTO ldb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bɔr unga ana akaifɛrhkɔ akɛrɛ ha na arheyirhɔ anyã ipfu itser Uteijee kapɛɛng ru unga ni igɔr unga igɛ, <<A Uyusuf ungwɛ̃ Udauda, niba ugũo iwei iyɛi Umaryamu unga awu utsɛ̃ngo, ubinkutsu anaa hã unga aka akɔ̃ adzeki Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Awuri imar ungwɛ̃ nu ungo utare itsoknga igburh Uyesu, ubinkutsu unga awuri ifɔrh anernga ra arhimmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kishoo akɛrɛ ha akorhe rimi ngge itsuifɛr ubinkpi Uteijee aka arherhe ra angwĩ uwuku usɔm Arherhu-Num agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","<<Unakugbĩrhĩ awuri ikɔ̃ anaa na amar ungwɛ̃ umbɔ ayisi itsoknga Uimmanuwerh,>> agbena agburh <<Unum awu nggu umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ivangyɛ Uyusuf aka azir ru urhɔ, unga adɔsa arherhe ha ipfu itser Uteijee iki irherhe na ayɛi Umaryamu unga awea utsɛ̃nga. ");
INSERT INTO ldb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bɔr asi irhaa nggu unga utsɛku unga aka amar ungwɛ̃nga. Uyusuf atare itsoknga igburh Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ivangyɛ umbɔ aka amar Uyesu ru uteu Ubaitarhami ru Uyahudiya ri ivang Uhiridu aka awu uyɛrhe, abika ahwɛng ídzɛɛr adzeki igɔ̃kpee aba Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Na arhusa agɛ, <<Ungwɛ̃ hã umbɔ aka amar awe rinɛɛ uyɛrhe abi Uyahuda? Umɛn inyãmɛn idzɛrnga ri igɔ̃kpee nu umɛn ĩba idzowe unga igɔng.>> ");
INSERT INTO ldb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ivangyɛ Uyɛrhe Uhiridu aka agũ rimi, amɛnnga adake nu kishoo abi Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ivangyɛ unga aka akɔng kishoo ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem, unga arhusa umbɔ anangkɛ umbɔ aka imar Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Umbɔ agɔr unga agɛ, <<Ru uteu Ubaitarhami ru Uyahudiya. Ubinkpi uwuku usɔm Arherhu-Num aka atsɛng, ");
INSERT INTO ldb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","<< <Bɔr ungo, Ubaitarhami ra abĩ Uyahuda, ungo usi iweɔ uwuku uci ri iteu Uyahuda. Ubinkutsu awu ru ungo uyɛrhu uwɔɔ aka idzeka, uwuruwi aka idarh anermum Uisrairha.> >> ");
INSERT INTO ldb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Mɔcɛ Uhiridu aghɔ̃rhã ayisa abika ahwɛng ídzɛɛr ha arhusa abee ihwɛng ivangyɛ umbɔ aka anyã idzɛɛr ha. ");
INSERT INTO ldb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mɔcɛ unga adene umbɔ azĩmbɔ Ubaitarhami agɔr umbɔ agɛ, <<Àka azĩ angwɛ̃dzɛn na arhisuwa irheng ungwɛ̃ hã. Ivangyɛ umbi aka anyãmbi unga, umbi aba asɔma umum nu umum igamum izĩ indzowe unga igɔng.>> ");
INSERT INTO ldb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Umbɔ aka agũ arherhe uyɛrhe amaa, umbɔ azĩmbɔ udĩmbɔ. Idzɛɛr ha umbɔ aka anyã ri igɔ̃kpee ha izɛ̃rhã ra asumbɔ, umbɔ adɔsa ngge utsɛku ngge iki iba idɛ̃ɛ̃ ra anangkɛ ungwɛ̃ hã aka awe. ");
INSERT INTO ldb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ivangyɛ umbɔ aka anyã idzɛɛr ha, umbɔ agɔm anggɔm akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Umbɔ aka atsĩ ri iya ha, umbɔ anyã irheng ungwɛ̃ hã nggu uyanga Umaryamu, umbɔ atararhu ra anangnga adzowe unga igɔng. Mɔcɛ umbɔ agarha akpokambɔ adzowe ízũwã uzinarhi nu atsei umbɔ iki iyisa ufirankisen nu umur. ");
INSERT INTO ldb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Umbɔ aka awu ri irheyirhɔ, Unum adɛyika umbɔ niba ibvui azĩmbɔ ru Uhiridu. Umbɔ adɔsu udĩ ukpɔɔ azĩmbɔ abĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Umbɔ aka azĩmbɔ, Uyusuf arheyirhɔ anyã ipfu itser Uteijee iki igɔr unga igɛ, <<Usisok, ushupu irheng ungwɛ̃ hã nu uyanga na atĩ azĩmbi abĩ Umasar. Àka asei nggɔɔ ha utsɛku umum iki indɛyiwa umbi. Uhiridu awuri ibeenga irheng ungwɛ̃ hã na afɛre unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nggee unga asok ashupu irheng ungwɛ̃ hã nu uyanga ru untsuuka akũ azĩã Umasar. ");
INSERT INTO ldb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Umbɔ asei nggɔɔ ha utsɛku Uhiridu aka akpe. Akɛrɛ ha akorhe rimi ngge itsuifɛr ubinkpi Uteijee aka arherhe ra angwĩ uner uwuku usɔm Arherhu-Num agɛ, <<Umum iyisu ungwɛ̃mum adzek ru Umasar.>> ");
INSERT INTO ldb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ivangyɛ Uhiridu aka ahwɛng ugɛ abika ahwɛng ídzɛɛr ha arhɛm unga, unga agũ avɔm akarhãrhã. Unga atsu umbɔ afɛyiwe irheng awɛkatsa kishoo ru Ubaitarhami nu ikãwãngge, udzur ra awɛkatsa abi imɛka ivaa uba ra andzing. Unga akorha akɛrɛ ha ubinkutsu udzur ri ivang hã abika ahwɛng ídzɛɛr ha aka asɔme unga imar ungwɛ̃ hã iki iwe imɛka ivaa. ");
INSERT INTO ldb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ivang hã niyɔ ngge iki itsuifɛr ubinkpi uner uwuku usɔm Arherhu-Num Uirimiya aka arherhe agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","<<Agũmbɔ urhɛm ru Urama, ididɔng nu ifakpe irhɛirhɛ, Urahirha unga adɛ̃ɛ̃ iciu akpe angwɛ̃nga, na akpɛ̃ɛ̃ iyɛi idɔngamɛn ru unera, ubinkutsu aka ashembɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Uhiridu aka akpe, Uyusuf arheyirhɔ ru Umasar anyã ipfu itser Uteijee iki igɔr unga igɛ, ");
INSERT INTO ldb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","<<Usok ushupu irheng ungwɛ̃ hã nu uyanga ukũ uzĩ abĩ Uisrairha. Abika abee ifɛr ungwɛ̃ hã aka akpembɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nggee unga asok, ashupu ungwɛ̃ nu uyanga akũ azĩã abĩ Uisrairha. ");
INSERT INTO ldb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bɔr unga aka agũ ugɛ Uarkirhayu ungwɛ̃ Uhiridu aka anyangu ukam utɛnga awu uyɛrhe Uyahudiya, unga agũã iwei izĩ nggɔɔ ha. Bɔr unga aka arheyirhɔ umbɔ agbiite atonga, unga atsĩã ru Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Azĩ aseisa ru uteu ukpɔɔ umbɔ iki iyisa Unazarat. Ngge itsuifɛr ubinkpi abika asɔm Arherhu-Num aka arherhe agɛ, <<Awuri iyisa unga uner Unazarat.>> ");
INSERT INTO ldb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ivang hã niyɔ Uyohana Uner Ubɔtisima aka aba adzowe isarhe ra arhum Uyahudiya, ");
INSERT INTO ldb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","anu igɔr agɛ, <<Àka adzipa, Iyɛrhe afã iki iyongge!>> ");
INSERT INTO ldb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Uner ha nuwɔ uwuku usɔm Arherhu-Num Uishaya aka arherhe ra arherhanga agɛ, <<Urhɛm uwɔɔ uyisa ra arhum ugɛ, <Àka agbishuwe udĩ Uteijee, àka avii atsĩndĩã uku urhirhiki ru unga!> >> ");
INSERT INTO ldb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Atorho Uyohana awu igwar urhakumi, abow ikpɔm ubvur nu upfurhsĩnga. Ubinghanga uwu asusu nu utoo arhum. ");
INSERT INTO ldb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mɔcɛ aner Urusharhima nu abi Uyahudiya kishoo nu abĩ akɔɔ ru ugbɛr Azɛ̃ Urdun adzeyi aba ru unga. ");
INSERT INTO ldb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Adɛ̃ɛ̃ asɔm arhimmbɔ nu unga asorhuwe umbɔ ubɔtisima ra Azɛ̃ Urdun. ");
INSERT INTO ldb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bɔr unga aka anyã abi Ufarisi nu abi Usaduki arhɛrhɛ aka aba ra anangkɛ unga aka adɛ̃ɛ̃ isorhu ubɔtisima, unga agɔr umbɔ agɛ, <<Umbi angwɛ̃ íbvui! Ungaa adɛyiwa umbi itĩ avɔm Unum aka iba unuma? ");
INSERT INTO ldb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Àka atɔ̃ itseryɛ iki idɛyiwe idzidzipambi. ");
INSERT INTO ldb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Àka aneke ikaifɛrhkɔ ra amɛnmbi agɛ, <Uibrahim unga awu utɛmɛn.> Umum idɛyiwa umbi Unum awea ri ijee unga aka itsu atarh akɛrɛ ake awe awɛkaci ru Uibrahim. ");
INSERT INTO ldb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Aka atsumbɔ anggãi ru unang acucii. Ubɛn ucucii uku usi ighwɛrmgbɔ ikpũrhã iyiki ize, awuri igbɛr umgbɔ atsu ru urha. ");
INSERT INTO ldb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","<<Umum ikorhuwa umbi ubɔtisima nggu amɛ̃ utsar idzidzipambi. Bɔr uwuruwi aka ananga umum ijee nggawɔ awuri iba ru undzingmum, abadaknga umum isi ímɛ̃ɛ̃mum ishipa. Unga awuri isorhuwa umbi ubɔtisima nggu Ipfu Isarsatangge nu urha. ");
INSERT INTO ldb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Akpɔm nggu utaknga, awuri itsɛki ishaa itsemnga na akarha ngge atsuku ungbanga na akpĩĩwe uhweenga ru urhakpi uku usi írhimkpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mɔcɛ Uyesu aka adzeku Ugarhirhi aba ru Uyohana asorhuwe unga ubɔtisima ra Azɛ̃ Urdun. ");
INSERT INTO ldb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Uyohana abee ikɛn unga, agɔr agɛ, <<Umum ibee ungo usorhuwa umum ubɔtisima, ungo usok uba ru umum?>> ");
INSERT INTO ldb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bɔr Uyesu agɔr unga agɛ, <<Uneke ngge iwe rimi icɛrɛ. Azea umɛn ikorhe ri iminɛ ngge itsuifɛr kishoo ubinkpi Unum aka abee.>> Mɔcɛ Uyohana abemuwe unga. ");
INSERT INTO ldb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Umbɔ aka asorhuwe Uyesu ubɔtisima, unga adzeka ra amɛ̃. Kanying afã ayanga, unga anyã Ipfu-Num iki icipuwa ru nyaku unurhɛu, iba isei nu unga. ");
INSERT INTO ldb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mɔcɛ urhɛm udzeka afã ugɔr ugɛ, <<Uwɛrɛ unga awu Ungwɛ̃mum ukpekũ iki ibema. Nggu unga umum igũibɛn akarhãrhã.>> ");
INSERT INTO ldb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mɔcɛ Ipfu-Num idarh Uyesu izĩngge ra arhum ru Undenggũ adeya unga. ");
INSERT INTO ldb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Uyesu akpem igha ubin inuma isɔka inaa nu utsuu nu atenum. Unga aka amaa, imerh ifɛr unga. ");
INSERT INTO ldb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Mɔcɛ Undenggũ aba agɔr unga agɛ, <<Ungo uba uwu Ungwɛ̃ Unum, utsu atarh akɛrɛ awu uborodi.>> ");
INSERT INTO ldb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Uyesu agɔr unga agɛ, <<Itsɛng Arherhu-Num igɔr igɛ, <Asi iwea ubingha ukpekũ itsu unera abɛk, bɔr ubɛn urhɛm arherhe uku udzeka ra angwĩ Unum.>>> ");
INSERT INTO ldb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mɔcɛ Undenggũ ashupa unga azĩ adɛ̃ɛ̃ afafã nu usarkasar uteu ni itsi uvi Iya-Num. ");
INSERT INTO ldb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Agɔr unga agɛ, <<Ungo uba uwu Ungwɛ̃ Unum, utersha ugba nu abĩ. Ubinkutsu itsɛng Arherhu-Num igɔrngge ugɛ, << <Unga awuri itsu ípfu itsernga ngge ingwɛ̃dzɛn ni ikaa ungo, ngge iwuri ikpɔm ungo ra afafã ra abokngge, utsur ungo ukwɛrɔ undaidakngo nu utarh.> >> ");
INSERT INTO ldb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Uyesu agɔr unga agɛ, <<Itsɛng Arherhu-Num igɔrngge ikɛi ugɛ, <Ungo niba ivirungo Uteijee Unumngo!>>> ");
INSERT INTO ldb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Undenggũ ashupa unga ikɛi aden ni itsi igũ iyɔɔ iderdetangge, adɛyiwe unga iyɛrhe upfung nu igɔngngge. ");
INSERT INTO ldb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Unga agɔr unga agɛ, <<Kishoo abina akɛrɛ umum iwuri idzaamum ungo, ungo uba utararhu nu udzaango umum igɔng.>> ");
INSERT INTO ldb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Uyesu agɔr unga agɛ, <<Usɔkɔ ru umum, Ushaitan! Ubinkutsu itsɛng Arherhu-Num igɔrngge ugɛ, <Udzowe igɔng ru Uteijee Unumngo, nu uwu ugãrhãnga ukpekũ.>>> ");
INSERT INTO ldb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mɔcɛ Undenggũ abɔruka unga, nu ípfu itser-Num iba itɔ̃we unga itser. ");
INSERT INTO ldb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Uyesu aka agũ ugɛ umbɔ aka atsuke Uyohana ru ugborzĩ, unga abvui azĩã Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Abɔruka Unazarat, azĩ asesa ru Ukafanahum, ukpurukpi uku uwe nggɔɔ ra angwĩ ukau ukugɔng ra abĩ Uzeburhun nu Unaftarhi. ");
INSERT INTO ldb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ngge itsuifɛr ubinkpi uner uwuku usɔm Arherhu-Num Uishaya aka arherhe agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","<<Abĩ Uzeburhun nu abĩ Unaftarhi, aka awu utsĩndĩ ukau ukugɔng, ugar Azɛ̃ Urdun, Ugarhirhi aka awu atsen abi Uyahuda, ");
INSERT INTO ldb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","umɔ abika asei ru uzĩ aka anyãmbɔ nggaa irhirhang. Nu abirabɛ aka asei ra abĩ aki uzirhzĩ akpe, irhirhang iki irhangngge ru umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Udzur ri ivang hã Uyesu aka atirhi idzowe isarhe, agɔr agɛ, <<Àka adzipa, Iyɛrhe afã iki iyongge!>> ");
INSERT INTO ldb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Uyesu azɛ̃rhã nu ubang Ukau Ugarhirhi nukpi, unga anyã inera ivaa angwɛ̃yi, Usiman uwuruwi umbɔ aki iyisa Ubitru nu Uandarawu ungwɛ̃mbɔ. Anu itang igber ru ukau, ubinkutsu umbɔ awu abika adzui abɛrh. ");
INSERT INTO ldb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Uyesu agɔr umbɔ agɛ, <<Àka aba adɔsa umum, nu umum iwuri itsu umbi awu abika adzui anera.>> ");
INSERT INTO ldb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ivanga unying umbɔ aneke igbermbɔ na adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Unga aka abɔre anang hã na azĩ anyã inera ivaa angwɛ̃yi ikɛi, Uyaku ungwɛ̃ Uzabadi nu Uyohana ungwɛ̃mbɔ. Awu ru ukhukhɔɔ amɛ̃ nggu utɛmbɔ Uzabadi, adɛ̃ɛ̃ igbishi ígbermbɔ. Uyesu ayisa umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kanying umbɔ anekukumbɔ ukhukhɔɔ ha ru utɛmbɔ na adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Uyesu azɛ̃rhã amaa Ugarhirhi, amesuwe ra abã ifɛn-Nummbɔ, adzowe Isarhe Iyiki Ize iyi Iyɛrhe Unum, na akerhuwe ubɛn irhãrhã nu ikpũ ighighong anera. ");
INSERT INTO ldb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Isarhe ri itsinga itɛ̃rhã imaangge abĩ Usuriya, anera akũ abika agũ ighighong akarhãrhã na ahwa ayetnum nggu ikpũ írhãrhã, nu abi ípfu iyiki ibewe, nu abi irhãrhĩ izurh, nu abika afɔr uzɛ̃rhã adambɔ, unga akerhuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Anera arhɛrhɛ aka adzeku Ugarhirhi, nu iteu usɔka umbɔ iki iyisa Udikaforhi, nu Urusharhima, nu Uyahudiya nu ugar Azɛ̃ Urdun adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ivangyɛ Uyesu aka anyã ikikɔng anera arhɛrhɛ, unga afũ asei ni itsi igũa. Angwɛ̃ imesanga aba ru unga. ");
INSERT INTO ldb_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Unga atirha amesuwe umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","<<Idorh iwu iyi abirabɛ aka awe atsũwã ri ipfumbɔ, ubinkutsu Iyɛrhe afã iwu iyimbɔ ");
INSERT INTO ldb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Idorh iwu iyi abi ighongamɛn, ubinkutsu awuri idɔngukumbɔ amɛnmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Idorh iwu iyi abika adɔɔr, ubinkutsu ukam upfung uwuri iwe ukpumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Idorh iwu iyi abirabɛ aka agũ imerh nu ugɔ̃ irhirhika, ubinkutsu umbɔ awuri ishurmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Idorh iwu iyi abika acucorhe, ubinkutsu awuri icorhukumbɔ umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Idorh iwu iyi abi amɛn aka atɛn, ubinkutsu umbɔ awuri inyãmbɔ Unum. ");
INSERT INTO ldb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Idorh iwu iyi abika atsu ididɔɔr, ubinkutsu awuri iyisa umbɔ angwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Idorh iwu iyi abika ahwa uver ri irhirhika, ubinkutsu Iyɛrhe afã iwu iyimbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","<<Idorh iwu iyimbi ivang anera iki irhena umbi, ayɔm umbi, na arherhuwa umbi ikpũ iki ibewe ri itsimum. ");
INSERT INTO ldb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Àka agɔm akarhãrhã, ubinkutsu umbi awuri ikpo itosa irhɛirhɛ ra afã, ubinkutsu rimi hã umbɔ aka ayɔm abika asɔm Arherhu-Num abi inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","<<Umbi awu angwã abĩã. Bɔr angwã aba ashike nu itonga ake, awuri ikorha aguse na atsu ake awe angwã ikɛi? Awuri ishike ru ugarh, awuri ititare ake na anera azɛ̃rhã nu ake. ");
INSERT INTO ldb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","<<Umbi awu irhirhang upfung. Uteukpi uku udzin nu igũ asi ídɛ̃ɛ̃ awɔmbɔ ukpɔ. ");
INSERT INTO ldb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Unera asi ítsu irhirhang na awɔka ngge ri ikikĩĩ. Nu ngge iki iwe rimi, awuri idene ngge idɛ̃ɛ̃ ra anang idɛ̃ɛ̃ngge nu ngge irhange ubɛn unera ri iya. ");
INSERT INTO ldb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Rimi hã, àka aneke irhirhangmbi irhang ra anera, ngge ítsu umbɔ anyã itser iyiki izembi na akpoi Utɛmbi uwu afã. ");
INSERT INTO ldb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","<<Niba akaimbi ifɛrhkɔ ugɛ umum ĩba ififɔ̃rhuwe Íkpem Umusa use itsɛng abika asɔm Arherhu-Num. Umum isi ĩbamum ififɔ̃rhuwe ngge, bɔr umum ĩba itsu ngge itsuifɛr. ");
INSERT INTO ldb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Umum indɛyiwa umbi idzidzɛrhe, utsɛku afã nu abĩ awuri imaa, uko ishia ra arherhe Íkpem Umusa isi ífɔ̃rhũngge utsɛku umbɔ aki itsu abina kishoo atsuafɛr. ");
INSERT INTO ldb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Uwuruwi aka azharhuwe ungwɛ̃rhi ishia unying ri Ikpem na amesuwe anera akorha ngge, awuri iyisa unga uku ucia ri Iyɛrhe afã, bɔr uwuruwi aka adɔsa ngge na amesuwe ngge, awuri iyisa unga nggaa uner ri Iyɛrha afã. ");
INSERT INTO ldb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Umum idɛyiwa umbi ugɛ irhirhikambi iba isi inangngge iyi abika amesuwe Ikpem nu abi Ufarisi, umbi asi ítsĩmbi ri Iyɛrhe afã. ");
INSERT INTO ldb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","<<Umbi aka agũmbi umbɔ aka adɛyiwe atokamɛn isha agɛ, <Àka niba afɛrmbi unera, nu uwuruwi aka afɛr uner awuri itsu uvau nu unga.> ");
INSERT INTO ldb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bɔr umum idɛyiwa umbi uwuruwi aka agũ avɔm nggu undɔkanga awuri itsu uvau nu unga. Ikɛi uwuruwi aka ayisu undɔkanga agɛ, <Ibɛm,> umbɔ awuri ikũna unga azĩ ra anang aka atsu uvau. Bɔr uwuruwi aka agɔr undɔkanga agɛ, <Ugugge!> unga awuri itsĩ ri igbaigba idzũũ urha. ");
INSERT INTO ldb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","<<Nggee, ungo uba udɛ̃ɛ̃ngo idzowe izũwã nu uyitta ugɛ uwɔɔ awu ra avɔm nggu ungo, ");
INSERT INTO ldb_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","uneke izũwã hã ra asu ubeu ha kata. Ugbaashia uzĩ umbi agbisha nggu uner ha. Mɔcɛ nu uba adzowe izũwãngo. ");
INSERT INTO ldb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","<<Unera aba atsuka arherhe ri itsingo ru udzepurhe uku uvarha arherhe, àka agbisha nu utsĩndĩ ifetem, iba ishingge rimi unga awuri igbopuwe ungo nggu uwuku atsu uvau, uwuku utsu uvau atsuke ungo ra abok ambow umbɔ agbange ungo ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Umum indɛyiwa ungo idzidzɛrhe, ungo usi ídzekɔ umɔ utsɛku ungo iki ifai umaa ukobo ha umbɔ aka atsu ungo ififai. ");
INSERT INTO ldb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","<<Umbi aka agũmbi umbɔ aka agɔr agɛ, <Niba utomungo-dak.> ");
INSERT INTO ldb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bɔr umum idɛyiwa umbi ugɛ ubɛn unera aba arhisa ukutsɛrh irhi anyɔna, unga aka atomunga-dak nggu utsɛrh ha ra amɛnnga. ");
INSERT INTO ldb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Usungo ukpu ubok ugha uba uwuri itsuka ungo ra arhim, uhor ukpɔ utare. Ugba ungo ushiɔ ru ugau ukpɔɔ ukpu iyorngo nu umbɔ aka itare iyorngo kishoo ri idzũũ urha. ");
INSERT INTO ldb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ubok ughango uba itsukakpɔ arhim ru ungo, uzharha ukpɔ utare. Ugba ungo ushiɔ ru ugau ukpɔɔ ri iyorngo nu iyorngo kishoo iki itsĩ ri idzũũ urha. ");
INSERT INTO ldb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","<<Aka agɔrmbɔ ugɛ, <Uwuruwi aka itsũwe utsɛ̃nga, awu ufang unga adzowe ubvur izharhuwe itsɛrh.> ");
INSERT INTO ldb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bɔr umum idɛyiwa umbi ugɛ ubɛn unera aka atsũwe utsɛ̃nga ri ida iwe ru uvau itoma-dak, atsuke unga ru utsĩndĩ itoma-dak. Nu uwuruwi aka apfunu utsɛrh uwuku uwuwayi ha, uner ha atoma-dak. ");
INSERT INTO ldb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","<<Ikɛi umbi aka agũmbi umbɔ aka adɛyiwe atokamɛn agɛ, <Àka niba azharhukumbi uyirh, bɔr imɛ̃ɛ̃ngge ungo utsufɛr ubinkpi ungo uku uyirhe Uteijee.> ");
INSERT INTO ldb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bɔr umum idɛyiwa umbi ugɛ niba ayirhmbi uyirh. Niba ayirhmbi nggu afã, ubinkutsu afã awu anang isei Unum. ");
INSERT INTO ldb_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Niba ayirhmbi nggu upfung, ubinkutsu awu ubin uku utsorhe andaidaknga, use nggu Urusharhima, ubinkutsu awu uteu Uyɛrhe Ukugɔng. ");
INSERT INTO ldb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Niba uyirhɔ nggu itsingo, ubinkutsu ungo usi ídɛ̃ɛ̃ utsu igwar unying iwengge iki iterha use iki ifĩrhã. ");
INSERT INTO ldb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Imɛ̃ɛ̃ngge umbi agɔr agɛ <Ĩĩ> use <Ĩ'ĩ>. Ubɛn ubinkpi uku utɔngkpɔ rimi idzeku uwuku ubewe ha. ");
INSERT INTO ldb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","<<Umbi aka agũmbi umbɔ aka agɔr agɛ, <Unera aba atsũwũka usungo, umbɔ atsũwe usu ukpunga, nu unera aba atsũwũka unyĩĩngo, umbɔ atsũwe unyĩĩ ukpunga.> ");
INSERT INTO ldb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bɔr umum idɛyiwa umbi ugɛ niba afaimbi iyiki ibewe nggu iyiki ibewe. Unera aba akwɛra ungo nu utam ubok ugha, udzipuwe utam ukpu uvaa ikɛi. ");
INSERT INTO ldb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Unera aba atsuka arherhango ra anang aka atsu uvau na abeenga ivur atorhango, udzowe nggu atorho akagɔnga ikɛi. ");
INSERT INTO ldb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Unera aba atsu ungo uzɛ̃rhũngo ru ukirhomita unying, uzĩ nggu unga akirhomita avaa. ");
INSERT INTO ldb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Udzowe uwuruwi aka aba ibibee ru ungo, niba udzipukɔ undzing nu uwuruwi aka abee ikɔw ru ungo. ");
INSERT INTO ldb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","<<Umbi aka agũmbi umbɔ aka agɔr agɛ, <Ubemu undɔkango nu ukpɛ̃ɔ uwuku ukpɛ̃ ungo.> ");
INSERT INTO ldb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bɔr umum idɛyiwa umbi ugɛ, àka abemu uwuku ukpɛ̃ umbi na afɛne-Num ru abika adzaa umbi uver. ");
INSERT INTO ldb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Rimi hã umbi awuri iwe ru nyaka angwɛ̃ idzidzɛrhe abi Utɛmbi ra afã. Unga atsu unum urhang ra abika aze nu abika abewe, na atsu inai idoi ra abika arhurhika nu abirabɛ aka asi irhikumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Umbi aba abema abirabɛ aka abema umbi ukpekũ, umbi awuri ikpo ikpũ ugbɛtu ukusong? Use abika ayɛi ikirbi abĩ asi ikorhumbɔ rimi? ");
INSERT INTO ldb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Umbi aba akpurha aghwe anermbi, umbi akorhu use anang abɔɔ? Abi uzĩ asi ikorhumbɔ rimi hã? ");
INSERT INTO ldb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Àka awe andzumunga ri irhirhika, ru nyaku Utɛmbi uwu afã aka awu undzumunga ri irhirhika. ");
INSERT INTO ldb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","<<Àka angwɛ̃dzɛn utsur itser iyi irhirhikambi iwengge iyi anera aka inyã. Umbi aba akorhe rimi, umbi asi íkpombi itosa ru Utɛmbi uwu afã. ");
INSERT INTO ldb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","<<Ngge itsu ivangyɛ ungo uku uwuri idzowe abika abubee, niba urherhungo ake ra awiya, ru nyaka abi ukpukpeta aki ikorhe ra abã ifɛn-Num nu atsĩndĩ ngge itsú anera akpoi umbɔ. Umum indɛyiwa umbi idzidzɛrhe, umbɔ aka ayɛi itosambɔ niyɔ. ");
INSERT INTO ldb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Bɔr ivangyɛ ungo uku iyike uner uwuku ububee, niba uneke uner uwɔɔ ahwɛnga ubinkpi ungo uku ikorhe. ");
INSERT INTO ldb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ngge ítsu izũwã ungo ima iwe ri iwɔk. Mɔcɛ Utɛngo, uwuku unyã ri iwɔk, ama adzaa itosango. ");
INSERT INTO ldb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","<<Ivang ifɛn-Nummbi, àka niba awembi ru nyaka abi ukpukpeta, umbɔ abemi idɛ̃ɛ̃ na afɛn-Num ra abã ifɛn-Num nu atsĩndĩ ru anera anyã umbɔ. Umum indɛyiwa umbi idzidzɛrhe, umbɔ aka ayɛimbɔ undzumu itosambɔ. ");
INSERT INTO ldb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bɔr ivangyɛ ungo iki ifɛn-Num, utsĩ ru ubãngo nu ufɔme angwĩ ubãã, ufɛnu Utɛngo uwuku uwe ri iwɔk. Utɛngo uwuku unyã ri iwɔk awuri idzidzaanga itosango. ");
INSERT INTO ldb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ivangyɛ umbi aka ifɛn-Num, àka niba adarhumbi ider arherhe ru nyaka abirabɛ aka asi ihwɛngmbɔ Unum. Umbɔ akaifɛrhkɔ ugɛ arherhe urhɛrhɛ uwuri itsu umbɔ agũ. ");
INSERT INTO ldb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Niba awembi ru nyaka umbɔ. Utɛmbi ahwɛnga ubinkpi umbi aka abee nu umbi adɔrha afɛna unga. ");
INSERT INTO ldb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","<<Àka afɛn-Num riminɛ, << <A Utɛmɛn ra afã, atsam itsokngo isarsatake. ");
INSERT INTO ldb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Iyɛrhango iba, ubinkpi ungo uku ubee umbɔ akorhe ru upfung ru nyaka umbɔ iki ikorhe ra afã. ");
INSERT INTO ldb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Uma udzaa ubinghamɛn ukpu irherɛ. ");
INSERT INTO ldb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Uma utsũwe arhimmɛn, ru nyaka umɛn iki isaki itsũwe abika ashɔng umɛn. ");
INSERT INTO ldb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Niba udarh umɛn uzĩɔ ru undeya, bɔr ufɔrh umɛn ri iyiki ibewe.> ");
INSERT INTO ldb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Umbi aba atsũwũkumbi anera aka ashɔng umbi, Utɛmbi uwu afã awuri itsũwãnga umbi. ");
INSERT INTO ldb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bɔr umbi aba asi itsũwũkumbi anera aka ashɔng umbi, rimi hã Utɛmbi asi ítsũwũka arhimmbi. ");
INSERT INTO ldb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","<<Ivangyɛ umbi aka ikpem ighabin, niba asherhumbi unyɛ̃ɛ̃mbi ru nyaka abi ukpukpeta aki ikorhe, umbɔ aka isaka asherhu unyɛ̃ɛ̃mbɔ ra anera anyã umbɔ aka akpem ighabin. Umum indɛyiwa umbi idzidzɛrhe, umbɔ aka ayɛimbɔ undzumu itosambɔ. ");
INSERT INTO ldb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bɔr ivangyɛ ungo uku ukpemɔ̃ ighabin, usorh asungo nu ukpai itsingo nu udzuka atsei, ");
INSERT INTO ldb_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","utsur anera ahwɛngmbɔ ungo uku ukpem ighabin, bɔr Utɛngo ukpekũ, aka awu ri iwɔk. Nu unga, Utɛngo aka anyã ri iwɔk, awuri idzidzaanga itosango. ");
INSERT INTO ldb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","<<Niba akɔng abin angwɛ̃mbi ru upfung, anangkɛ adzurh nu ivivɔ̃ɔ̃ iki idakuwe ake, nu avɛu aki itsĩ avɛu ivɛu. ");
INSERT INTO ldb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Bɔr àka atsu amɛnmbi ri ikpo ugbɛta ra afã, anangkɛ adzurh nggu ivivɔ̃ɔ̃ asi ídakuke ake, anangkɛ avɛu asi ítsĩ avɛumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ubinkutsu, anangkɛ abinmbi aka awe, umɔ amɛnmbi aka iwe ikɛi. ");
INSERT INTO ldb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","<<Asu ake awu irhirhang iyor. Asungo aba akerke, iyorngo kishoo iwuri itɔk nggu irhirhang. ");
INSERT INTO ldb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bɔr asungo aba asi ikerke, iyorngo kishoo iwuri iwe ru uzĩ. Uba irhirhang ru ungo iwu uzĩ, nggaa uzĩ hã uwu uguse! ");
INSERT INTO ldb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","<<Unera asi ídɛ̃ɛ̃ atɔ̃wũka itser ra ateiya avaa. Unga awuri ibema unying na akpɛ̃ɛ̃ uwɔrɔ, unga awuri idzowe itsinga ru unying na akpɛ̃ɛ̃ uwɔrɔ. Ungo usi ídɛ̃ɛ̃ udzowukɔ itsingo ru Unum nu uhwɛk. ");
INSERT INTO ldb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","<<Nggee umum idɛyiwa umbi, niba agũmbi ighong ru ibibɛkmbi nu ubinkpi umbi aka igha, use ubinkpi umbi aka ihwa, use atorhakɛ umbi aka itsim nu ayormbi. Urhɛ usi inangmgbɔ ubingha? Iyor isi inangge atorho? ");
INSERT INTO ldb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Àka anyã anunu afã. Asi idoike asi igbɛrke asi ikɔng atsuke ra angban. Bɔr Utɛmbi uwu afã unga adzowe ighigha ake. Umbi asi iwu ru ugarh anangmbi ake? ");
INSERT INTO ldb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ungamɔ ru umbi igũ ighongnga idɛ̃ɛ̃ itomungge ivanga unying ri inumyɛ unga aka ibɛk? ");
INSERT INTO ldb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","<<Awu use utsu umbi agũ ighong atorho? Àka arhi ífur arhum iki iseng. Isi itɔ̃ngge itser use inuw abin. ");
INSERT INTO ldb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Bɔr umum idɛyiwa umbi, uyɛrhe Usorhomon ri igɔngnga kishoo unga anasi igbɛra idzam ru nyaki ifur unying. ");
INSERT INTO ldb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Unum aba agbɛruka idzam nu ubĩĩ arhum rimi, uku uwe irherɛ nu udã umbɔ akpĩĩwe ru urha, asi ígbɛranga umbi idzam, umbi abi imangmang iyiki ici? ");
INSERT INTO ldb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nggee niba agũmbi ighong agɛ, <Umɛn igha usee?> use <Umɛn ihwa usee?> use <Umɛn itsim usee?> ");
INSERT INTO ldb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Abi uzĩ abee ikpũ abin akɛrɛ ha. Rimi hã Utɛmbi uwu afã ahwɛnga umbi abeembi abin hã. ");
INSERT INTO ldb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bɔr àka agbaashia abee Iyɛrhe Unum nu irhirhikanga, nu abin hã kishoo awuri idzaambɔ umbi ikɛi. ");
INSERT INTO ldb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nggee niba agũmbi ighong iyi udã, ubinkutsu udã uwu nggu ayetnumkpɔ. Ubɛn unuma ayetnum amɛ̃ɛ̃ke nggu ukpɔ. ");
INSERT INTO ldb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","<<Àka aneke itsu uvau ra anera, utsur umbɔ atsukambɔ umbi uvau. ");
INSERT INTO ldb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ikpũ uvauwi umbi aki itsuke anera, ikpũ iyi ha umbɔ aka itsuka umbi. Ugbiuwi umbi aka akũ amei, awuri ikũ umgbɔ ha amei adzaa umbi. ");
INSERT INTO ldb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","<<Awu use utsu ungo urhi umbumbin ru usu undɔkango nu usi inyãɔ̃ ungbũngkũ uku uwe ru usungo? ");
INSERT INTO ldb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ungo ukorhu uguse nu ugɔr undɔkango ugɛ, <Uneke umum itsũwã umbumbin ru usungo,> nggayɛ ungbũngkũwi uwu ru usu ukpungo? ");
INSERT INTO ldb_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ungo uner ukpukpeta, utirhu utsũwe ungbũngkũ ru usungo, mɔcɛ nu urhi utai nu utsũwe umbumbin ru usu undɔkango. ");
INSERT INTO ldb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","<<Àka niba adzowukumbi íjui abin aka asar. Niba atarkumbi abinarhɔ aki imang ra arhede. Ake awuri ijang adak na adzipa anayiwa umbi. ");
INSERT INTO ldb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","<<Àka afɛna awuri idzaambɔ umbi. Àka abee umbi awuri ikpikpombi. Àka akwɛr angwĩ ubã awuri itsuruwambɔ umbi. ");
INSERT INTO ldb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ubɛn unerwi aka afɛna awuri iyɛisa, unga uwuku ububee awuri ikpoa, nu unga uwuku ukwɛr angwĩ ubã awuri itsurukumbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","<<Awu ungamɔ ru umbi, ungwɛ̃nga aba arhusa uborodi, unga awuri idzowe unga utarh? ");
INSERT INTO ldb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Use unga aba arhusu ubɛrh, unga awuri idzowe unga ibvui? ");
INSERT INTO ldb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Umbi abi amɛn aka abewe aba ahwɛngmbi idzowe angwɛ̃mbi abin aka aze, iwuri iwe iguse Utɛmbi ra afã aka idzowe abin aka aze ra abirabɛ aka ifɛna unga! ");
INSERT INTO ldb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Nggee ubɛn ubinkpi umbi aka abee anera akorhuwa umbi, àka akorhuwe umbɔ rimi hã. Akɛrɛ kishoo ake awu Íkpem Umusa nu abika asɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","<<Àka atsĩ ra angwĩ ubã aka apare. Ubinkutsu anera arhɛrhɛ abika atsĩ ra angwĩ aka atɛi nu utsĩndĩ uwuku uzĩ itsitsĩm, utɛi. ");
INSERT INTO ldb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bɔr angwĩ ubã akika apare nu utsĩndĩ uwuku uzĩ ibibɛk ughong uzãrhã. Abika adɔsa umgbɔ asi irhɛmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","<<Àka angwɛ̃dzɛn nggu abika asɔm Arherhu-Num igbɛrangwĩ. Umbi awuri inyã umbɔ ru nyaki ídɔi, bɔr idzidzɛrhe umbɔ awu íjui ngbako iyɛ imerh iki ifɛr akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Umbi awuri ihwɛng umbɔ ri ikpũ itsermbɔ. Awuri idɛ̃ɛ̃ akɔɔrmbɔ ikpũrhã inebi ru ucucii ididɔk, use awuri ikpombɔ uvorhvo ri ididɔk? ");
INSERT INTO ldb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Rimi hã ubɛn ucucii uwuku uze uku usaku ughwɛr ikpũrhã iyiki ize, bɔr ucucii uku ubewe uku usaku ughwɛr ikpũrhã iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ucucii uwuku uze usi ídɛ̃ɛ̃ ughwɛrmgbɔ ikpũrhã iyiki ibewe, rimi hã ucucii uwuku ubewe usi ídɛ̃ɛ̃ ughwɛrmgbɔ ikpũrhã iyiki ize. ");
INSERT INTO ldb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ubɛn ucucii uku usi íghwɛrmgbɔ ikpũrhã iyiki ize, umbɔ awuri igbɛr atsuku urha. ");
INSERT INTO ldb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nggee, awu ikpũrhãke awuri itsu umbi ahwɛng ake. ");
INSERT INTO ldb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","<<Asi iwea ubɛn unera aka igɔr umum agɛ, <A Uteijee, a Uteijee,> awuri itsĩ ri Iyɛrhe afã, bɔr awu uwuruwi ukpekũ aka akorhu ubinkpi Utɛmum uwuku uwu ra afã aka abee. ");
INSERT INTO ldb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ru unum hã anera arhɛrhɛ awuri igɔr umum agɛ, <A Uteijee, a Uteijee! Umɛn isi isɔmmɛn Arherhu-Num ri itsokngo, nu ri itsokngo umɛn iki iwayiwe ípfu iyiki ibewe ri ikorha abin idzeu arhɛrhɛ?> ");
INSERT INTO ldb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mɔcɛ umum iki igɔr umbɔ ugɛ, <Umum isi ihwɛng umbi. Àka asombi ru umum, umbi abika akorhe iki ibewe.> ");
INSERT INTO ldb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","<<Nggee uwuku ugũ arherhamum na atɔ̃ itser nggu ake, unga awu ru nyaku uner itsoi uwuruwi aka adzin iyanga ni ifa. ");
INSERT INTO ldb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mɔcɛ inai idoi, amɛ̃ adzek, ugba uso ukwɛr iya ha. Ike isi igbake ubinkutsu, adzin ike ni ifa. ");
INSERT INTO ldb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bɔr uwuku ugũ arherhamum na akpɛ̃ɛ̃ itɔ̃ itser nggu ake, unga awu ru nyaku ugugge uwuruwi aka adzin iyanga nu uzuzeu. ");
INSERT INTO ldb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Inai idoi, amɛ̃ adzek, ugba uso ukwɛr iya ha, igbigba ike ibewungge.>> ");
INSERT INTO ldb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ivangyɛ Uyesu aka amaa irherhe abin akɛrɛ, ikikɔnga idzedzeu imesanga, ");
INSERT INTO ldb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ubinkutsu unga amesuwe umbɔ ru nyaku unerwi aka awe ru ijee, asi iwea ru nyaka abika amesuwe Ikpemmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ivangyɛ Uyesu aka acipuwa ri igũ hã, anera arhɛrhɛ aka adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Uner ingbim uwɔɔ aba atararhu ra anangnga na agɔr agɛ, <<A uteiya, ungo uba ubemungo, ungo udɛ̃ɛ̃ usarango umum.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Uyesu aberu uboknga abanga unga na agɛ, <<Umum ĩbeemum, usar!>> Kanying ingbimnga ikerhungge. ");
INSERT INTO ldb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Mɔcɛ Uyesu agɔr unga agɛ, <<Niba udɛyikɔ unera. Bɔr uzĩ, udɛyiwe itsingo ru uwuku udzowe idɛm-Num, nu udzowe izũwã ru nyaki Íkpem Umusa iki itsu. Ngge iwe ideka ru umbɔ ugɛ ungo uku ukerhungo.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ivangyɛ Uyesu aka atsĩ ru Ukafanahum, uteiya abi iwa Uroma uwɔɔ aba ashɔ̃rhũ Uyesu ama ayike unga. ");
INSERT INTO ldb_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Agɛ, <<A uteiya, ugãrhãmum ashai iyor awe ri iya, anu igũ ighong akarhãrhã.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Uyesu agɔr unga agɛ, <<Umum iwuri iba ikerhukũ unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Unggbaashi abi iwa Uroma ha agɔr agɛ, <<A uteiya, umum isi imɛ̃ɛ̃mum ungo iki iba ri iyamum. Bɔr urherhu urhɛm ukpekũ, ugãrhãmum hã awuri ikerhunga. ");
INSERT INTO ldb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Umum iwe ru ubok ijee, abi iwa abɔɔ awu ru ubokmum. Igɔr uwɛrɛ inggɛ, <Uzĩ,> unga azĩã, nu uwɔrɔ inggɛ, <Uba,> unga abanga. Umum iba igɔr ugãrhãmum inggɛ, <Ukorhe riminɛ,> unga akorhe.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ivangyɛ Uyesu aka agũ rimi, unga adzeidzeu na agɔr abika adɔsa unga agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, ru Uisrairha kishoo umum inasi ikpomum uwuku uwe ru imangmang ikerketangge ru nyaki iyɛrɛ ha. ");
INSERT INTO ldb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Umum igɔr umbi ugɛ anera arhɛrhɛ awuri idzeki igɔ̃kpee nu udiku urhɛɛ, aba asei nggu Uibrahim, Uishaku nu Uyakubu agha irhowa ri Iyɛrhe afã. ");
INSERT INTO ldb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bɔr awuri itare irhɛ abi Uisrairha ra awiya ru uzĩ, anangkɛ umbɔ aka iciu akpe nggu itãi anyĩ.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Mɔcɛ Uyesu agɔr uteiya abi iwa Uroma hã agɛ, <<Uzĩ! Iwuri ikorhungge ru nyaka ungo uku uwe ru imangmango.>> Kanying ugãrhãnga akerhunga ri ivang hã. ");
INSERT INTO ldb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ivangyɛ Uyesu aka atsĩ ri iya Ubitru, unga anyã uya utsɛrha Ubitru anu nu ukoma iyora imani. ");
INSERT INTO ldb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Unga abangu uboknga imani iyor ha inekungge unga. Uya ha asok akorhuwe unga ubingha. ");
INSERT INTO ldb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Urhɛɛ uku uwe, umbɔ akũ anera arhɛrhɛ abika awe ru ípfu iyiki ibewe aba ru unga. Unga akũ irhɛm awayiwe ngge na akerhuwe abi irhãrhã kishoo. ");
INSERT INTO ldb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Akorha akɛrɛ ngge itsuifɛr ubinkpi umbɔ aka arherhe ra angwĩ uner uwuku usɔm Arherhu-Num Uishaya agɛ, <<Unga nyanguwe irhãrhãmɛn, unga akerhuwe ighongamɛn.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ivangyɛ Uyesu aka anyã nggaa ikikɔng anera iki idzipa unga, unga atsu umbɔ agar ukau ha azĩ ugar ukpɔrɔ. ");
INSERT INTO ldb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mɔcɛ uner uwuku umesuwe Ikpem aba agɔr unga agɛ, <<A umarhem, umum idɔsa ungo izĩ ubɛn anang ungo iki izĩ.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Uyesu adzipa agɔr unga agɛ, <<Íjui ngbako iyiki ici iwengge ri ingwĩngge, anunu ikɛi aweke ra ashiyake, bɔr Ungwɛ̃-Ner ashia ra anangkɛ unga aka itsu itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ungwɛ̃ imesa uwɔɔ agɔr unga agɛ, <<A uteiya, uneka umum inggbaashia izĩ ĩdzake utɛmum.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bɔr Uyesu agɔr unga agɛ, <<Udɔsa umum, uneke abika akpe adzake abika akpembɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mɔcɛ unga atsĩ ukhukhɔɔ amɛ̃, angwɛ̃ imesanga adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kanying ugba ukerketakpɔ usoyi ru ukau amɛ̃ hã, amɛ̃ asoyi atsĩrhã ru ukhukhɔɔ ha. Bɔr Uyesu awu ru urhɔ. ");
INSERT INTO ldb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Angwɛ̃ imesa azĩ azita unga, agɔr agɛ, <<A uteiya, ufɔrha umɛn! Umɛn iki iwuri itsĩmmɛn!>> ");
INSERT INTO ldb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Unga agɔr umbɔ agɛ, <<Umbi abi imangmang iyiki ici, awu use utsu umbi agũ iwei rimi?>> Mɔcɛ unga asok atsɛrhu ugba nu ubvun ukau ha. Ukpɔ kishoo udɔɔr uku utata. ");
INSERT INTO ldb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Anera adzeidzeu na arhusa agɛ, <<Awu ikpũ uner uwukusong nuwi? Ugba nu ubvun ukau ikɛi agũna unga!>> ");
INSERT INTO ldb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ivangyɛ unga aka atsĩ ugar ukpɔrɔ ra abĩ abi Ugadara, inera ivaa abi ipfu iyiki ibewe aka adzek ra anang adzak anera agbopa unga. Umbɔ awu ubin iwei akarhãrhã, ngge itsu anera asi idɛ̃ɛ̃ adɔsumbɔ utsĩndĩ hã. ");
INSERT INTO ldb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Umbɔ atsu ivum agɛ, <<A Ungwɛ̃ Unum, ungo uba itser use ru umɛn? Ungo uba idzaa umɛn uver ri ivanga idɔrhi iwe?>> ");
INSERT INTO ldb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ukhapa ru umbɔ, ukpui arhede arhɛrhɛ udɛ̃ɛ̃ ughãwã. ");
INSERT INTO ldb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ípfu iyiki ibewa ha ishɔ̃rhũ Uyesu igɛ, <<Ungo uba uwayikɔ umɛn, utsu umɛn itsĩ ru ukpui arhede ukpɔrɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Mɔcɛ unga agɔr ngge agɛ, <<Àka azĩ!>> Ngge idze izĩ ru ukpui arhede ha, ake asok atĩ acipa nu ughoghor abang ukau ha agba atsĩ ra amɛ̃ akpeke. ");
INSERT INTO ldb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abi ughãwã arhede ha atĩ atsĩ ru utepa adzowe isarhe ha kishoo, nu ubinkpi uku ukorhe ra abi ipfu iyiki ibewa ha. ");
INSERT INTO ldb_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Mɔcɛ kishoo anera ru utepa adzek agbangu Uyesu. Ivangyɛ umbɔ aka anyã unga, umbɔ ashɔ̃rhã unga ama asoka ra abĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Uyesu atsĩ ukhukhɔɔ amɛ̃, agar azĩ uteunga. ");
INSERT INTO ldb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Aner abɔɔ akũ uner ishayi iyor aba ru unga, anu nu ufar. Ivangyɛ Uyesu aka anyã imangmangmbɔ, unga agɔr ushayi iyor ha agɛ, <<Niba ugũo ighong ungwɛ̃ ha, umbɔ aka atsũwãmbɔ arhimngo.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Mɔcɛ abɔɔ abika amesuwe Ikpem agɔr adɔkambɔ agɛ, <<Utsak uwurɛ arhenu Unum!>> ");
INSERT INTO ldb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Bɔr Uyesu ahwɛnga ubinkpi umbɔ aka akaifɛrhkɔ, unga agɛ, <<Awu use utsu umbi akaifɛrhkɔ iyiki ibewe ra amɛnmbi rimi? ");
INSERT INTO ldb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Akasong asi ighongke irherhe, igɔr ugɛ, <Umbɔ aka atsũwãmbɔ arhimngo,> use igɔr ugɛ, <Usisok uzɛ̃rhã?> ");
INSERT INTO ldb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bɔr umum ibee umbi ahwɛng ugɛ Ungwɛ̃-Ner awea ri ijee iyiki itsũwe arhim ru upfung.>> Mɔcɛ unga agɔr ushayi iyor ha agɛ, <<Usisok ufetu ufarngo uzĩ ri iya.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nu utsa ha asok azĩã ri iyanga. ");
INSERT INTO ldb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ivangyɛ ikikɔng anera iki inyã rimi iwei ifɛr umbɔ. Umbɔ akpoi Unum, aka adzowe anera ikpũ ijee ha. ");
INSERT INTO ldb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Uyesu awu ru azɛ̃rhã na anyã utsawɔɔ agburh Umatiyu asei ra anang aka ayɛi ikirbi abĩ. Uyesu agɔr unga agɛ, <<Udɔsa umum.>> Mɔcɛ Umatiyu asok adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Uyesu asei ighabin ri iya Umatiyu, abika ayɛi ikirbi abĩ nu abirabɛ umbɔ aka anyanga umbɔ awu abi arhim arhɛrhɛ, aba agha nggu unga nu angwɛ̃ imesanga. ");
INSERT INTO ldb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ivangyɛ abi Ufarisi aka anyã rimi, umbɔ arhusa angwɛ̃ imesanga agɛ, <<Awu use utsu umarhemmbi asei igha ubingha nggu abika ayɛi ikirbi abĩ nu abi arhim?>> ");
INSERT INTO ldb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ivangyɛ Uyesu aka agũ rimi, unga agɛ, <<Abika aker asi ibeembɔ uner agɔu, bɔr abi irhãrhã abee. ");
INSERT INTO ldb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Àka azĩ amesa agben itsɛng Arherhu-Num akirakɛ aka agɔr ugɛ, <Umum ibee umbi awe ra atorh, isi ĩbeemum idɛm-Num.> Umum isi ĩbamum iyisa abika akaifɛrhkɔ ugɛ umbɔ arhika, umum ĩba iyisa abirabɛ aka ahwɛng ugɛ umbɔ awu abi arhim.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mɔcɛ angwɛ̃ imesa Uyohana aba arhusa unga, agɛ, <<Umɛn nggu abi Ufarisi ikpemmɛn ighabin, bɔr awu use utsu angwɛ̃ imesango asi ikpemmbɔ?>> ");
INSERT INTO ldb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mɔcɛ Uyesu agɔr umbɔ agɛ, <<Awu use itsu awɛrhu uner utsɛrh uwuku ufa awe ru idamɛn nu uner ha ana awe nggu umbɔ? Ivanga niyɔ ibarɔ awuri inyãnguwe uner utsɛrh uwuku ufa ha na abɔre umbɔ. Ivang hã niyɔ umbɔ aka ikpem ighabin. ");
INSERT INTO ldb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","<<Unera asi íkũ atorho aka afa asɔr abipa atorho aka agbe. Ubinkutsu, aka afa ha awuri ishĩrhã avaate aka agbe ha. Ivivaar ha iwuri inangge iyi inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ikɛi unera asi ítsuka amɛ̃ inebi aka afa ra ambãĩ aka agbe. Umbɔ aba akorhumbɔ, ambãĩ hã awuri iyar. Amɛ̃ inebi ha awuri igba, ambãĩ hã awuri iwe ibɛm. Ĩ'ĩ, aka isaka atsu amɛ̃ inebi aka afa ra ambãĩ aka afa, nu ake asi íyarke ra amɛ̃ inebi adzek agbake.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Uyesu anu isɔme umbɔ akɛrɛ ha, unggbaashi uwɔɔ ru ubã ifɛn-Nummbɔ aba atararhu ra anangnga na agɛ, <<Unapmum anai ikpe. Bɔr uba utsorhu ubokngo nu unga awuri ibɛka.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Uyesu asok azĩã nggu unga, nu angwɛ̃ imesanga adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mɔcɛ utsɛrh uwɔɔ aka atsĩã imɛka usɔkdũmɛn nggu irhãrhã umɛ̃ɛ̃ aba ra andzing aba abangu ifɛn atorho Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Unga agɔr ra amɛnnga agɛ, <<Umum ĩba ĩbangumum ifɛn atorhanga umum iwuri ikerhumum.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ivangyɛ Uyesu aka adzipa anyã unga. Unga agɛ, <<Niba ugũo ighong unapmum. Imangmangngo ngge ikerhuwa ungo.>> Kanying utsɛrh ha akerhunga. ");
INSERT INTO ldb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ivangyɛ Uyesu aka aba atsĩ ri iya unggbaashi ha, anyã abika abar aserhwa nu ikikɔng anera iki igwarha arherhe. ");
INSERT INTO ldb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Unga agɛ, <<Àka asombi. Una hã anasi ikpea bɔr awe ru urhɔ.>> Bɔr umbɔ anyĩrhã unga. ");
INSERT INTO ldb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Anera aka adzek amaa, unga atsĩ adzur ubok una hã, una hã asok adɛ̃ɛ̃. ");
INSERT INTO ldb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Isarhe arherhe ha itɛ̃rhã imaangge abĩ hã. ");
INSERT INTO ldb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Uyesu aka azɛ̃rhã aneke anang hã, abi ibvuta avaa adɔsa na atsarhi irhakmbɔ agɔr agɛ, <<Ucorhuwa umɛn Ungwɛ̃ Udauda!>> ");
INSERT INTO ldb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ivangyɛ Uyesu aka atsĩ ri iya, abi ibvuta ha aba ru unga, unga arhusa umbɔ agɛ, <<Umbi awembi ri imangmang ugɛ umum idɛ̃ɛ̃ ikorhuwamum akɛrɛ?>> Umbɔ agɔr unga agɛ, <<Ĩĩ, Uteijee.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Unga abanga asumbɔ na agɛ, <<Ri imangmangmbi neke ngge ikorhe ru umbi.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Asumbɔ ayanguke. Uyesu agbiite atombɔ akarhãrhã agɛ, <<Niba adɛyikumbi unera akɛrɛ ha.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bɔr umbɔ adzek atɛ̃rhã arherhe ha amaa kishoo abĩ hã. ");
INSERT INTO ldb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Umbɔ aka adzek ra awiya, umbɔ akũ uner uwɔɔ aka awe ru ipfu iyiki ibewe iki ikɛnngge unga arherhe aba ru Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ivangyɛ umbɔ aka awayiwe ipfu iyiki ibewe ha idze, uner igbau ha atirhunga arherhe. Ikikɔng anera idzedzeu ni igɔr igɛ, <<Anasi inyãmbɔ ikpũ ifɛrhɛ rimi ru Uisrairha.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bɔr abi Ufarisi agɛ, <<Nggu ijee uyɛrhe ípfu iyiki ibewe unga iki ikũ atsusuwe ípfu iyiki ibewe.>> ");
INSERT INTO ldb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Uyesu adɔsi iteu iyiki igɔng nu iyiki ici kishoo, amesuwe ra abã ifɛn-Nummbɔ. Adzowe Isarhe Iyiki Ize iyi Iyɛrhe afã, na akerhuwe anera ru kishoo ikpũ irhãrhã nu ighighong. ");
INSERT INTO ldb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ivangyɛ unga aka anyã anera aka akɔng arhɛrhɛ, unga agũ atorh umbɔ, ubinkutsu, umbɔ awe ru uver akarhãrhã na ashimbɔ ru uner uwuku uyike. Umbɔ awe ru nyaki ídɔiyɛ iki ishingge ru uner idzɛu. ");
INSERT INTO ldb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Mɔcɛ unga agɔr angwɛ̃ imesanga agɛ, <<Igbɛra abin iwe irhɛirhɛ, bɔr abi itsera awe ukunjiir. ");
INSERT INTO ldb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Àka ashɔ̃rhũ Uteijee uwu igbɛra abin, unga adene abi itser ri icang igbɛra abinnga.>> ");
INSERT INTO ldb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Unga aka ayisa angwɛ̃ imesa usɔkdũmɛn aba ru unga, unga adzowe umbɔ ijee iyiki itsũwe ípfu iyiki ibewe na akerhuwe ubɛn ikpũ irhãrhã nu ighighong. ");
INSERT INTO ldb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Atsok abi itser Uyesu ha akɛ usɔkdũmɛn hã, uwu inbgaashia, Usiman uwu umbɔ iki iyisa Ubitru, nu Uandarawu ungwɛ̃mbɔ, Uyaku ungwɛ̃ Uzabadi nu Uyohana ungwɛ̃mbɔ, ");
INSERT INTO ldb_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ufirhibu, Ubatorhomi, Utoma nu Umatiyu uner uwuku uyɛisu ikirbi abĩ, Uyaku ungwɛ̃ Uharhfa, Utaddiyu, ");
INSERT INTO ldb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Usiman uner Ukan'ana nu Uyahuda Uiskariyoti, uwuku ugha adaknga. ");
INSERT INTO ldb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Uyesu adene usɔkdũmɛn hã agɛ, <<Niba azĩmbi ra atsen abi Uyahuda use atsĩ ru ubɛn uteu Usamariya. ");
INSERT INTO ldb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Àka azĩ ri ídɔi iyiki igwir iyi Uisrairha. ");
INSERT INTO ldb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ri izizĩmbi, àka adzowe isarhe iyɛrɛ agɛ, <Iyɛrhe afã iki iyongge.> ");
INSERT INTO ldb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Àka akerhuwe abi irhãrhã, àka azituwe abika akpe, àka asare abi ingbim, àka atsusuwe ípfu iyiki ibewe. Umbi ayɛi ijee ha izũwã, àka atɔ̃ itser nggu ngge izũwã. ");
INSERT INTO ldb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Niba akpɔmmbi uzinarhi use uazurhfa use ubinkpi uku uwu ru nyaku uhwɛk ri ibvukmbi. ");
INSERT INTO ldb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Niba nyangumbi ukpoka ru uzɛ̃rhã hã, use atorho avaa, use abadak avaa use igbong, ubinkutsu, uner itser amɛ̃ɛ̃ ikpo ubingha. ");
INSERT INTO ldb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","<<Ubɛn uteu ukugɔng use uku uci umbi aka itsĩ, àka abee uner uwuku urhurhika umɔ. Àka asei ri iyanga utsɛku isisokmbi. ");
INSERT INTO ldb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ivangyɛ umbi aka itsĩ ri iya ha, àka aghwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Iya ha iba ibemuke umbi, neke ididɔɔrambi iwe umɔ, bɔr ike iba isi ibemuke, ididɔɔrambi ibvui iba ru umbi. ");
INSERT INTO ldb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Unera aba asi iyɛisa umbi use akpea ato ra arherhambi, àka awashuwe uzurhu uwu adakmbi ivangyɛ umbi aka idze ri iya ha use uteu ha. ");
INSERT INTO ldb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Umum indɛyiwa umbi idzidzɛrhe, uver uteu ha use iya ha uwuri unangkpɔ ukpu aner Usɔdɔm nu Ugomora ru unum ukpuku uvarha arherhe. ");
INSERT INTO ldb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","<<Umum idena umbi adzek ru nyaka ídɔi ra ateu íjui ngbako. Nggee àka awe ru itsoi ru nyaki íbvui na ashimbi ri iki ibewe ru nyaka anurhɛu. ");
INSERT INTO ldb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","<<Àka akpɔm amɛnmbi nggu anera, umbɔ awuri iden umbi ra ateu akakũ na akwɛr umbi ra abã ifɛn-Nummbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ri itsimbi aka adɔsa umum, umbɔ awuri ikũna umbi azĩ ra asu agomna nu ayɛrhe ru nyaka abi idekamum ru umbɔ nu atsen abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Bɔr ivangyɛ umbɔ aka idzur umbi, niba agũmbi ighong ubinkpi umbi aka irherhe use umbi irherhe uguse. Ri ivang hã awuri idzaambɔ ubinkpi umbi aka irherhe. ");
INSERT INTO ldb_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Asi íwea umbi irherhe, bɔr Ipfu Utɛmbi ngge irherhe ra angwĩmbi. ");
INSERT INTO ldb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","<<Ungwɛ̃yi awuri idzowe ungwɛ̃mbɔ umbɔ afɛre, utei ikɛi awuri idzowe ungwɛ̃nga. Awɛkaci ikɛi awuri iwu ri igamtsak nggu ateimbɔ utsɛku umbɔ aka itsu umbɔ afɛre umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Anera kishoo awuri ikpɛ̃na umbi ri itsokmum. Bɔr kishoo uwuku ubima utsɛku imimasha awuri ikpoa ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Umbɔ aba adzaambɔ umbi uver ra anang akɔɔ, àka atĩ azĩ anang akɔɔ. Umum indɛyiwa umbi idzidzɛrhe, Ungwɛ̃-Ner awuri ibanga nu umbi anasi imaambi itsĩrhĩ iteu Uisrairha kishoo. ");
INSERT INTO ldb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","<<Ungwɛ̃ imesa asi inanga umarhemnga, use ugãrhã ananga uteiyanga. ");
INSERT INTO ldb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ungwɛ̃ imesa awe ra anggɔm unga aka awe ru nyaku umarhemnga nu ugãrhã ru nyaku uteiyanga. Umbɔ aba ayisa umum iki iwe uteiyambi ugɛ Uba'arhzaburh uyɛrhe ípfu iyiki ibewe, awuri iyisa umbi nggu itsok ha anangmbɔ umum! ");
INSERT INTO ldb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","<<Nggee niba agũmbi iwei umbɔ. Ubin ushikpɔ umbɔ aka afɔm, ukpɔ uku usi ídzekpɔ, use ri iwɔk umbɔ aka asi íhwɛngmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Abinkɛ umum iki isɔma umbi ru uzĩ, àka asɔme ake ri irhirhang. Abinkɛ aka akhɛwa ra atombi, àka adũwã ake ra atsi uvi. ");
INSERT INTO ldb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Niba agũmbi iwei abika afɛre iyor bɔr asi ídɛ̃ɛ̃ afɛrmbɔ ipfu. Nu ngge iki iwe rimi, aka agũ iwei uwuruwi aka idɛ̃ɛ̃ afɛre iyor nu ipfu kishoo ri idzũ urha. ");
INSERT INTO ldb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Asi iwea ahwirhgɔm avaa umbɔ aki igoshe ukobo unying? Nggee unying usi ígbamgbɔ ra abĩ Utɛmbi aka asi íhwɛnga umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nu uko ígwar itsimbi umbɔ aka avuvarha ngge. ");
INSERT INTO ldb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nggee niba agũmbi iwei, umbi anangmbi ahwirhgɔm ugarh idiki irhɛirhɛ. ");
INSERT INTO ldb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","<<Ubɛn unera aka adɛyiwe itsinga ugɛ unga awu uwu umum ra asu anera, umum iwuri idɛyikũ unga awu uwu umum ra asu Utɛmum ra afã. ");
INSERT INTO ldb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bɔr ubɛn unera aka atsɛyinga ihwɛng umum ra asu anera, umum iwuri itsitsɛyimum ihwɛng unga ra asu Utɛmum ra afã. ");
INSERT INTO ldb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","<<Niba akaimbi ifɛrhkɔ ugɛ umum ĩba itsu ididɔɔr ru upfung. Umum isi ĩbamum itsu ididɔɔr, bɔr ikũ ifuw. ");
INSERT INTO ldb_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ubinkutsu, umum ĩba itsu ifuw ru, << <ungwɛ̃ nu utɛnga, unai nu uyanga, utsɛn ungwɛ̃ nu ukokanga. ");
INSERT INTO ldb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Anggamtsak unera awuri iwe abi iyanga.> ");
INSERT INTO ldb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","<<Uwuruwi aka abemu uyanga use utɛnga ananga umum asi imɛ̃ɛ̃ iwe uwu umum. Uwuruwi aka abemu ungwɛ̃nga use unapunga ananga umum, asi imɛ̃ɛ̃ iwe uwu umum. ");
INSERT INTO ldb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ubɛn unera aka asi ishupu igãrhãmau ucuciianga adɔsunga umum, asi imɛ̃ɛ̃ iwe uwu umum. ");
INSERT INTO ldb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Uwuruwi aka akpo urhɛnga, unga awuri igwirhe umgbɔ, nu uwuruwi aka agwirhuwe urhɛnga ri itsimum, awuri ikpoa umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","<<Uwuruwi aka ayɛi umbi, ayɛi umum. Uwuruwi aka ayɛi umum ayɛi uwuku udena umum. ");
INSERT INTO ldb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Uwuruwi aka ayɛi uwuku usɔm Arherhu-Num ri itsernga, awuri iyɛisa itosa uner uwuku usɔm Arherhu-Num. Nu ubɛn uwuku uyɛi uner uwuku urhika ri irhirhikanga awuri iyɛisa itosa iyi uner uwuku urhika. ");
INSERT INTO ldb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nu uwuruwi aka adzowe uko ukpɛwa amɛ̃ aka aghɛnga ru ubɛn unera ra abɛrɛ aka awe angwɛ̃ imesamum, umum indɛyiwa umbi idzidzɛrhe, awuri ikpoa itosanga.>> ");
INSERT INTO ldb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Uyesu aka amaa imesuwe angwɛ̃ imesanga usɔkdũmɛn hã, unga adzek umɔ azĩ amesuwe na adzowe isarhe ra abĩ Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ivangyɛ Uyohana ru ugborzĩ aka agũ abinkɛ Ukiristo aka akorhe, unga adene angwɛ̃ imesanga ");
INSERT INTO ldb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","azĩ arhusa unga agɛ, <<Awu ungo uwu uwuku ububa ha, use umɛn itsu asumɛn ru uwɔɔ?>> ");
INSERT INTO ldb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Uyesu adzipa agɛ, <<Àka abvui azĩ adɛyiwe Uyohana ubinkpi umbi aka agũ na anyã. ");
INSERT INTO ldb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Abi ibvuta anyãmbɔ, akatarhu azɛ̃rhũmbɔ uzɛ̃rhã, abi ingbim akerhumbɔ, abi igbau agũmbɔ, ikom isongge nggu urhɛ, adzowukumbɔ Isarhe Iyiki Ize ra atsũwã. ");
INSERT INTO ldb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Idorh iwu iyi uwu ha aka asi ikpɛ̃ɛ̃ umum ri itsi abinkɛ umum iki ikorhe.>> ");
INSERT INTO ldb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ivangyɛ awɛ imesu Uyohana aka azĩmbɔ, Uyesu atirha arherhe nggu ikikɔnga ri itsi Uyohana agɛ, <<Umbi azĩ izɛrhu use ra arhum? Ubĩĩ uku uder ugba iki ifɛu? ");
INSERT INTO ldb_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Iba ishingge rimi, ude umbi adzek azĩ izɛrhu use? Utsa uwɔɔ aka atsim atorho aka aze? Ĩ'ĩ, abika atsim atorho aka aze asei ra adzepurhe iyɛrhe. ");
INSERT INTO ldb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ude umbi adzek azĩ izɛrhu use? Uwuku usɔm Arherhu-Num? Ĩĩ, umum idɛyiwa umbi, ananga uwuku usɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Unga hã uwi umbɔ aka atsɛng ra Arherhu-Num ri itsinga agɛ, << <Umum iwuri idene ungwɛ̃ itsermum agbaashia ru ungo. Unga awuri igbishuwa atsĩndĩngo.> ");
INSERT INTO ldb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Umum indɛyiwa umbi idzidzɛrhe, ra abirabɛ akatsɛrh aka amar asi itsĩmbɔ Uyohana Uner Ubɔtisima. Bɔr uwuruwi aka awu uku ucia ri Iyɛrhe afã, ananga unga. ");
INSERT INTO ldb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Udzur ri ivang Uyohana Uner Ubɔtisima uba utsĩ irherɛ, Iyɛrhe afã iwe ru uver, abika adzowe uver ha umbɔ abee ivur ngge ri iker. ");
INSERT INTO ldb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ubinkutsu kishoo itsɛng abika asɔm Arherhu-Num nu Íkpem Umusa irherhungge arherhe akɛrɛ utsɛku ivang Uyohana. ");
INSERT INTO ldb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Umbi aba ibemumbi ubinkpi umum iki irherhe, Uyohana unga awu Uirhiya ha umbɔ aka arherhe ugɛ unga awuri ibanga. ");
INSERT INTO ldb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Neke uner uwuku uwu ra ato aka agũ, unga agũ. ");
INSERT INTO ldb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","<<Umum ikpangu udan ukpirɛ nggu use? Awu ru nyaka awɛkaci iki isei ra anang izɛɛ na ayisa abɔɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","<< <Umɛn ibara umbi aserhuwa, umbi akpɛ̃mbi izer. Umɛn itsũ ubom akpe, umbi akpɛ̃mbi iciu akpe.> ");
INSERT INTO ldb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Uyohana aka aba, asi itsuka amɛnnga ri ighigha nu ihwihwa, umbɔ agɛ, <Unga awe ru ipfu iyiki ibewe.> ");
INSERT INTO ldb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ungwɛ̃-Ner aka aba agha na ahwa, umbɔ agɛ, <Àka anyã uner uwuku ubvun igha abin nu ihwihwa akarhãrhã, uwɛrhɛ abika ayɛi ikirbi abĩ nu abi arhim!> Bɔr awu itser unera iwuri idɛyiwe ugɛ unga awea ri itsoi.>> ");
INSERT INTO ldb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Mɔcɛ Uyesu aka atirhi itsɛyi iteuyɛ unga aka akorhe irhɛ abin idzeu ri ngge, ubinkutsu, anera asi idzipumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","<<Atorhngo, Ukorazin! Atorhngo Ubetsaida! Agɛ itser idzeu ha umbɔ aka atɔ̃ ru umbi, umbɔ atɔ̃mbɔ ngge ru Utaya nu Usidon, umbɔ awuri idzipumbɔ iki ifitem, umbɔ awuri itsim ashaka atorho, na asei ra atɔɔ. ");
INSERT INTO ldb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bɔr umum idɛyiwa umbi, ru unum ukpuku uvarha arherhe, uvermbi uwuri inangkpɔ ukpu Utaya nu Usidon. ");
INSERT INTO ldb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ungo igango, Ukafanahum, ungo ukaifɛrhkɔ ugɛ awuri ibera ungo afũ afã? Ĩ'ĩ, awuri ikũna ungo acipa ra anang isei abika akpukpe. Itser idzeuyɛ umbɔ aka atɔ̃ ru ungo umbɔ aba atɔ̃ ngge ru Usɔdɔm, ukpɔ uba uwe umɔ utsɛku irherɛ. ");
INSERT INTO ldb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Bɔr umum idɛyiwa umbi ru unum ukpuku uvarha arherhe, uvermbi uwuri inangkpɔ ukpu Usɔdɔm.>> ");
INSERT INTO ldb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ri ivang hã Uyesu awu ra anggɔm ri Ipfu Isarsatangge, agɔr agɛ, <<Umum ikpoi ungo Utɛ, Uteijee uwu afã nggu abĩ, ungo uku uwɔkɔ ifɛrhɛ iyɛrɛ ru abi itsoi nu abi idzursu, nu usɔme ake ra awɛkaci. ");
INSERT INTO ldb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A Utɛ, akɛrɛ ha awu ubinkpi ungo uku ugũibɛn ikorha ukpɔ. ");
INSERT INTO ldb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","<<Utɛmum adzaa abina kishoo ru umum. Unera asi ihwɛnga amɛn Ungwɛ̃ɛ̃, Utɛ ikiyikanga ahwɛng. Unera asi ihwɛngnga amɛn Utei, Ungwɛ̃ɛ̃ ukpekũ nu uwuruwi Ungwɛ̃ hã aka isɔme unga. ");
INSERT INTO ldb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","<<Àka aba ru umum, kishoo umbi abika agũ azhe na agũ imor, umum iwuri idzaamum umbi iwiwosha. ");
INSERT INTO ldb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Àka adzowe atsimbi na amesa ru umum, ubinkutsu, umum iwu uner inna nu ididɔɔr ra amɛnmum, nu umbi awuri ikpombi iwiwosha ra amɛnmbi. ");
INSERT INTO ldb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ubinkutsu, idzowe itsimbi ru umum asi iwea ubin uku ughong, abinmum asi imorke.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ri ivang hã Uyesu azɛ̃rhã atɔng ri ícang uarhkama ru unum ukpuku uwosha. Angwɛ̃ imesanga agũ imerh umbɔ atirhi igbiu isha arhkama hã atãi. ");
INSERT INTO ldb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ivang abi Ufarisi aka anyã rimi, umbɔ agɔr unga agɛ, <<Unyã! Angwɛ̃ imesango aka azharhuwe Ikpem unum ukpuku uwosha.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Unga agɔr umbɔ agɛ, <<Umbi anasi ivarhumbi ubinkpi Udauda aka akorhe ri ivangyɛ unga nggu awɛrhu uzɛ̃rhãnga aka agũ imerh? ");
INSERT INTO ldb_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Unga aka atsĩ ru Iya-Num anyangu usarkasar uborodi atãi nggu awɛrhu uzɛ̃rhãnga, ukpurukpi ri Ikpem awu abika adzowe idɛm-Num ukpekũ iki itãi. ");
INSERT INTO ldb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Use umbi anasi ivarhumbi ri Íkpem Umusa ugɛ abika adzowe idɛm-Num ri itser unum ukpuku uwosha ri Iya-Num aka adakuwe unum ukpuku uwosha na ishimbɔ ru uvau? ");
INSERT INTO ldb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Umum idɛyiwa umbi uwuruwi aka ananga Iya-Num awu nggimi. ");
INSERT INTO ldb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Umbi aba ahwɛngmbi agben itsɛng Arherhu-Num hã iki igɔr igɛ, <Umum ibee umbi awe ra atorh, isi ĩbeemum idɛm-Num,> Umbi aba asi itsumbi uvau ra abika asheru uvau. ");
INSERT INTO ldb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ubinkutsu Ungwɛ̃-Ner awu Uteijee unum ukpuku uwosha.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Adzeka anang hã unga atsĩã ru ubã ifɛn-Nummbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Uner uwɔɔ uboka uku ushayi awu umɔ. Umbɔ abee udĩkpi umbɔ aka ikpo Uyesu nggu uvau, umbɔ arhusa unga agɛ, <<Ri Ikpem imɛ̃ngge umbɔ akerhuwe ru unum ukpuku uwosha?>> ");
INSERT INTO ldb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Unga agɔr umbɔ agɛ, <<Unera ru umbi aba awuri idɔi ngge igba ru ughwee ru unum ukpuku uwosha, uner idɔi ha asi ídzur akpɔm ngge atsũwũka? ");
INSERT INTO ldb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Unera ananga idɔi akarhãrhã! Nggee asi iwea izharhuwe Ikpem ri ikorhi iyiki ize ru unum ukpuku uwosha.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Mɔcɛ unga agɔr utsak ha agɛ, <<Unamu ubokngo udzek.>> Nggee unga anamu uboknga udzek, ukpɔ ukerhe uwe ru nyaku ukpu uvaa. ");
INSERT INTO ldb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bɔr abi Ufarisi adzek akɛki itsũwã umbɔ aka ifɛre Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ivang Uyesu aka ahwɛng rimi, unga abɔruka anang hã. Arhɛrhɛ aka adɔsa unga, unga akerhuwe irhãrhãmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Unga agbiite atombɔ ugɛ niba adɛyikumbɔ iwiwenga ru unera. ");
INSERT INTO ldb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Akɛrɛ ake atsuafɛr ubinkpi uku urherhe ra angwĩ uwuku usɔm Arherhu-Num Uishaya agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","<<Unyã ugãrhãmum uwi umum iki isɛng, uwu umum iki ĩbema, ru unga umum iki igũibɛn. Umum iwuri itsuke Ipfumum nu unga, nu unga atsu abĩã ahwɛng irhirhika. ");
INSERT INTO ldb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Asi ísoyinga isa use itsuyi ivum, asi ígũmbɔ urhɛmnga nu atsĩndĩ. ");
INSERT INTO ldb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Asi íbvũã ugamwi uku uwuri ibvũ, utɔngviwi uku uwuri irhim, unga asi írhĩwũka. Unga awuri ikorha akɛrɛ utsɛku unga aka itsu irhirhika igha inggbaashi. ");
INSERT INTO ldb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Abĩã awuri ifosa ri itsoknga.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mɔcɛ umbɔ akũ uner ibvuta aka afɔr arherhe adaka awe ru ipfu iyiki ibewe aba. Uyesu akerhuwe unga, ngge itsu unga arherha arherhe na anyã ikɛi. ");
INSERT INTO ldb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Anera kishoo adzeidzeu na agɛ, <<Awu Ungwɛ̃ Udauda nuwi?>> ");
INSERT INTO ldb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bɔr abi Ufarisi aka agũ akɛrɛ ha, umbɔ agɛ, <<Nggu ijee Uba'arhzaburh uyɛrhe ípfu iyiki ibewe utsak uwurɛ aka isaka akũ atsusuwe ípfu iyiki ibewe ha.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Uyesu ahwɛnga ifɛrhkɔmbɔ unga agɔr umbɔ agɛ, <<Ubɛn iyɛrhe iki igau agbɛra avaa iwuri itsĩm, nu ubɛn uteu use iya iki igau nggu adɔkake isi ídɛ̃ɛ̃ke. ");
INSERT INTO ldb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ushaitan aba atsũwũka Ushaitan, awe ri ifuw nggu itsikamnga. Iyɛrhanga idɛ̃ɛ̃ iguse? ");
INSERT INTO ldb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Umum iba ikũ ijee Uba'arhzaburh itsusuwe ípfu iyiki ibewe, abimbi akũ ijee iyikisong atsusuwe? Angwɛ̃ imesambi awuri itsuka umbi uvau ra arherhe akɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Umum ĩba ikũ ijee Ipfu-Num itsusuwe ípfu iyiki ibewe, mɔcɛ Iyɛrhe Unum iki ibangge ru umbi. ");
INSERT INTO ldb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","<<Use ikɛi, unera awuri ikorha aguse na adɛ̃ɛ̃ atsĩ ri iya uner uwuku uker avur abinnga? Awuri igbaashia abow unga kata na adɛ̃ɛ̃ akarha abin iyanga. ");
INSERT INTO ldb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","<<Uwuruwi aka asi iwea nggu umum, akpɛ̃ɛ̃ umum. Uwuruwi aka asi ikɔnga nggu umum, asusituwe. ");
INSERT INTO ldb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nggee umum ĩdɛyiwa umbi, awuri itsũwũkumbɔ anera ru kishoo ikpũ arhim nu urhena ru Unum, bɔr uwuruwi aka arhenu Ipfu-Num, asi ítsũwũkumbɔ arhimnga. ");
INSERT INTO ldb_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ubɛn unera aba arherhunga urhɛm uku ubewe ri itsi Ungwɛ̃-Ner, awuri itsũwũkumbɔ unga, bɔr uwuruwi aka arheni Ipfu Isarsatangge, asi ítsũwũkumbɔ unga icɛrɛ use ivang iyiki ibiba. ");
INSERT INTO ldb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","<<Ucucii uku uze uku isaku ughwɛr ikpũrhã iyiki ize, ucucii uku ubewe uku isaku ughwɛr ikpũrhã iyiki ibewe. Aka isaka ahwɛng ucucii ri ikpũrhãngge. ");
INSERT INTO ldb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Umbi abi amɛn íbvui, umbi awuri ikorha uguse na adɛ̃ɛ̃ arherhe iyiki ize nggu amɛn aka abewambi? Ubinkpi uku uwe ra amɛn, ukpɔ uku idzeyiwa ra angwĩ. ");
INSERT INTO ldb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Uner uwuku uze aka isaka akũ abin aka aze adzeka ra anang aka aze unga aka angwɛ̃ ru unga. Uner uwuku ubewe aka isaka akũ abin aka abewe adzeka ra anang aka abewe unga aka angwɛ̃ ru unga. ");
INSERT INTO ldb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Umum idɛyiwa umbi ugɛ ru unum ukpuku uvarha arherhe, awuri ivarhukumbɔ ubɛn unera ra arherhe akatãrhãkɛ unga aka arherhe. ");
INSERT INTO ldb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ubinkutsu, irhɛm arherhango ake itsu ungo ushɔɔr, ake itsu ungo utsĩm.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Mɔcɛ abi Ufarisi abɔɔ nu abika amesuwe Ikpem agɔr unga agɛ, <<A umarhem, umɛn ibee inyã utsar idzeu ru ungo.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Unga agɔr umbɔ agɛ, <<Abika abewe, abika asheru Unum, abi undan ukpirɛ arhusu utsar idzeu! Bɔr asi ídɛyikumbɔ umbɔ utsar, akpurha adɛyiwe utsar ukpu uwuku usɔm Arherhu-Num Uyunana. ");
INSERT INTO ldb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ru nyaku Uyunana aka amaa inuma itaar utsuu nu atenum ra anaa ubɛrh ukugɔng, rimi hã Ungwɛ̃-Ner aka imaa inuma itaar utsuu nu atenum awe ru anɔnɔr abĩ. ");
INSERT INTO ldb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Aner Unineba awuri iso adɛ̃ɛ̃mbɔ ru unum ukpuku uvarha arherhe nggu udan ukpirɛ na awuri itsu uvau ru ukpɔ, ubinkutsu, umbɔ adzipumbɔ ri udũwã Uyunana. Icɛrɛ uwuku unang Uyunana uwi nggimi. ");
INSERT INTO ldb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ru unum ukpuku uvarha arherhe Usarauniya uwu Unɔr awuri iso adɛ̃ɛ̃ nggu undan ukpirɛ na atsuke uvau ru ukpɔ, ubinkutsu unga adzeka anang akika ader aba igũ itsoi Usorhomon. Nggayɛ uwuruwi aka anangnga Usorhomon awu nggimi. ");
INSERT INTO ldb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","<<Ivangyɛ ipfu iyiki ibewe iba idzek ru unera, iki isaki iyarhe ri inang iyiki ikoi ibee ikpo iwiwosha ni isi ikpongge. ");
INSERT INTO ldb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ngge igɔr igɛ, <Umum ibvui izĩ ri iyakɛ umum iki idzek.> Ngge iba ikpo unera ashia umɔ ri iya ha, ngge inyã umbɔ aka ayar na agbishumbɔ iya ha. ");
INSERT INTO ldb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Mɔcɛ ngge ibvui izĩ ikarhe ípfu iyiki ibewe iyɔɔ utɔɔva, iyiriyɛ iki ibewe inangngge ngge, ngge kishoo iba isei umɔ. Isisei utsa ha iyi imaataka iwuri ibewe inangge iyi inggbaashia. Iwuri iwe rimi nggu undan ukpuku ubewe ukpirɛ.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Uyesu aka awe ra arherhe nggu ikikɔng, uyanga nu angwɛ̃mbɔ aba adɛ̃ɛ̃ ra awiya, abee arherha arherhe nggu unga. ");
INSERT INTO ldb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Uwɔɔ agɔr unga agɛ, <<Uyango nu angwɛ̃mbi adɛ̃ɛ̃ ra awiya, abee irherha arherhe nggu ungo.>> ");
INSERT INTO ldb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Unga agɔr unga agɛ, <<Uwukusong awu uyamum, nu abikasong awu angwɛ̃mɛn?>> ");
INSERT INTO ldb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ayottu uboknga ra angwɛ̃ imesanga agɛ, <<Unyã uyamum uwi nu angwɛ̃mɛn. ");
INSERT INTO ldb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ubɛn unerwi aka akorhu ubinkpi Utɛmum ra afã aka abema, unga awu ungwɛ̃mɛn nu unapumɛn nu uyamum.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ru unum hã Uyesu adzeki iya azĩ aseisa ru ubang ukau. ");
INSERT INTO ldb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ikikɔng anera irhɛirhɛ iki ikɔng idziranga, itsu unga atsĩ ru ukhukhɔɔ amɛ̃ asei umɔ. Ikikɔnga idɛ̃ɛ̃ ru ubang ukau ha. ");
INSERT INTO ldb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Mɔcɛ unga adɛyiwe umbɔ abina arhɛrhɛ ru unyaka arherhe agɛ, <<Uner irham azĩ inna ikpũnga. ");
INSERT INTO ldb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Unga adɛ̃ɛ̃ inna ikpũ hã, ikpũ iyɔɔ igbei nu utsĩndĩ anunu aba akpɔuke iyi ha kanying. ");
INSERT INTO ldb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Iyɔɔ igbei ru ukpɔrha, abĩ asi iweke akarhãrhã. Ngge imɛr kanying ubinkutsu, abĩ anang hã asi ighorke. ");
INSERT INTO ldb_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bɔr ivangyɛ unum uku umani iyi ha ikoingge, ubinkutsu, ngge iki ishingge ra anũnang. ");
INSERT INTO ldb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ikpũ iyɔɔ igbei ri ididɔk, ngge isɛng itong ngge iyi ha. ");
INSERT INTO ldb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ikpũ iyɔɔ igba ra abĩ aka aze, anangkɛ ngge iki ighwɛr ikpũrhã ananaka, iyɔɔ isɔka utɔ̃tɔ̃ĩ use isɔka itaitaar. ");
INSERT INTO ldb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Unga uwuku awe ra ato, neke unga agũ.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Angwɛ̃ imesa ha aba arhusa unga agɛ, <<Awu use utsu ungo urherhuwe anera arherhe ru unyaka arherhe?>> ");
INSERT INTO ldb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Unga agɔr umbɔ agɛ, <<Ihwɛng abinkɛ aka awɔk aki Iyɛrhe afã aka adzaa ru umbi, bɔr asi iwea umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Uwuruwi aka awe ru ihwihwɛng awuri itomuwe unga akpo arhɛrhɛ. Uwuruwi aka ashia, awuri iyɛse ungwɛ̃rhĩ ihwihwɛng ha unga aka awerangge. ");
INSERT INTO ldb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Umum irherhuwe umbɔ arherhe nggu unyaka arherhe ubinkutsu, <<Umbɔ awuri irhimbɔ, bɔr asi ínyãmbɔ, na awuri igũmbɔ, bɔr asi íhwɛngmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Irhɛm uwuku usɔm Arherhu-Num Uishaya iki itsuifɛrngge ra atsimbɔ. Iki igɔr igɛ, << <Umbi awuri igũmbi na asi íhwɛngmbi, umbi awuri irhimbi na asi ínyãmbi. ");
INSERT INTO ldb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ubinkutsu, amɛn anera abɛrɛ awe akerketake, aghong umbɔ agũ nggu atombɔ, aka abvurkumbɔ asumbɔ. Iba isi iwengge rimi, umbɔ awuri anyãmbɔ nggu asumbɔ, umbɔ awuri igũmbɔ nggu atombɔ, na ahwɛngmbɔ nggu amɛnmbɔ, na adzipa aba ru umum ikerhuwe umbɔ.> ");
INSERT INTO ldb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Bɔr idorh iwe iyi asumbi ubinkutsu, ake adɛ̃ɛ̃ anyãke, nu atombi ubinkutsu ake adɛ̃ɛ̃ agũke. ");
INSERT INTO ldb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Umum indɛyiwa umbi idzidzɛrhe, abika asɔm Arherhu-Num nu abika arhurhika arhɛrhɛ aka abee inyã ubinkpi umbi aka anyã bɔr asi inyãmbɔ, use agũ ubinkpi umbi aka agũ, bɔr asi igũmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","<<Àka akpeto na agũ agben unyaka arherhe uner uwuku unna ikpũ abin hã. ");
INSERT INTO ldb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ivangyɛ ubɛn unera aka agũ arherhe Iyɛrhe afã na asi ihwɛnga ake, Undenggũ unga aka isaka aba avur ubinkpi umbɔ aka adoi ra amɛnnga. Iwu ikpũ iyiki igba ru utsĩndĩ. ");
INSERT INTO ldb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Iyiriyɛ iki igba ra ukpɔrha, iwe ru nyaku uwuku ugũ arherhe ha na ayɛi nggu anggɔm. ");
INSERT INTO ldb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bɔr unga aka ashia ra anũnang, asi idãrhũnga. Ivang arherhe ha aki ikũ uver nggu ayetnum uba, unga awuri izĩ ra andzing. ");
INSERT INTO ldb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Iyiriyɛ iki igba ra anang ididɔk ngge iwe ru nyaku uwuku ugũ arherhe ha, bɔr iwãrhãna abin upfung ri ibee iwe ru ubin ibɛrh ni ikɛnngge arherhe ha ighwɛr ikpũrhã. ");
INSERT INTO ldb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Bɔr iyiriyɛ iki igba ra abĩ aka aze iwe ru nyaku uwuku ugũ arherha ha na ahwɛnga ake. Unga aghwɛr ikpũrhã, ananaka, isɔka utɔ̃tɔ̃ĩ, use isɔka itaitaar idikunga nggu ubinkpi umbɔ aka adoi.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Uyesu abvui adzowe umbɔ unyaka arherhe akɔɔ agɛ, <<Iyɛrhe afã iwu ru nyaku unerwi aka anna ikpũ iyiki ize ri icangnga. ");
INSERT INTO ldb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bɔr ivangyɛ anera kishoo aka awu ru urhɔ, unggamtsaknga azĩ adoi ikpũ ubĩĩ ri icang itsem hã na azĩã. ");
INSERT INTO ldb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ivangyɛ ikpũ abin hã iki imɛr, umɔ ubĩĩ igakpɔ umɛr. ");
INSERT INTO ldb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","<<Agãrhũ uner icang hã aba agɔr unga agɛ, <A uteiya, ungo usi idosɔ ikpũ iyiki ize ri icangngo? Ubĩĩ udzekɛ ukpɔ?> ");
INSERT INTO ldb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","<<Unga agɛ, <Awu unggamtsakmum unga akorha aki ha.> <<Agãrhã ha agɛ, <Ungo ubeengo umɛn izĩ izɔnge ubĩã hã?> ");
INSERT INTO ldb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","<<Unga agɛ, <Ĩ'ĩ, ubinkutsu, umbi aba awuri izɔngmbi ubĩĩ ri itsem hã, umbi adɛ̃ɛ̃ abvurhkumbi itsema nggu ubĩã hã. ");
INSERT INTO ldb_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Àka aneke ake aseng urhɔnga utsɛku ivang iyiki ititeng. Ri ivang hã umum iwuri ĩdɛyikũ abi aka ateng hã, umbɔ agbaashia ateng ubĩã hã apfuma, aboyi atsã atsã, umbɔ akpĩĩwe, bɔr akarhi itsema aba atsuku ungbanmum.> >> ");
INSERT INTO ldb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Unga abvui adɛyiwe umbɔ unyaka arherhe akɔɔ agɛ, <<Iyɛrhe afã iwe ru nyaki ishaa ikpũ iyiki ici, utsa uwɔɔ aka anyanga adoi ri icangnga. ");
INSERT INTO ldb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ngge iwu iyiki icia ri ikpũ abin, bɔr ngge iki imɛr iseng, ngge iwu ucucii uwuku ugɔng, anunu akang ashiyake ra aboka.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Unga abvui adzowe umbɔ unyaka arherhe akɔɔ agɛ, <<Iyɛrhe afã iwu ru nyaku ungwɛ̃rhũ uga ukutsɛrh aka akayi nggu agbiu isɔka ivaa aki akɔ̃ abvurh, umgbɔ ufuyiwe kishoo agbiu ha.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Uyesu adɛyiwe ikikɔng anera kishoo abin akɛrɛ nggu unyaka arherhe. Unga asi irherhunga ubin ukpɔɔ umɔ uku usi iwekpɔ unyaka arherhe. ");
INSERT INTO ldb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngge itsuifɛr ubin uwuku usɔm Arherhu-Num aka arherhe agɛ, <<Umum irherha arherhe nggu unyaka arherhe, abinkɛ aka awɔk utirhi ri imimunu upfung.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mɔcɛ unga abɔre ikikɔng anera na atsĩã ri iya. Angwɛ̃ imesanga aba agɔr unga agɛ, <<Udɛyiwa umɛn agben unyaka arherhe ubĩĩ ri icang itsem.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Unga agɛ, <<Uwuruwi aka adoi ikpũ iyiki ize awu Ungwɛ̃-Ner. ");
INSERT INTO ldb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Icang hã ngge iwe upfung, ikpũ iyiki ize ha iwe angwɛ̃ Iyɛrhe afã. Ubĩĩ uwe angwɛ̃ Undenggũ. ");
INSERT INTO ldb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nu unggamtsak uwuku udoi ubĩĩ hã, awu Undenggũ. Ivang iyiki iteng hã, awe imimaa upfung, abika atuteng hã awe ípfu itser-Num. ");
INSERT INTO ldb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","<<Ru nyaka umbɔ iki ikarhu ubĩĩ akpĩĩwe ru urha, iwuri iwe rimi ri imimaa upfung. ");
INSERT INTO ldb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ungwɛ̃-Ner awuri idene ípfu itsernga ngge idze, iwuri ikpotuwe Iyɛrhe afãnga ubɛn ubin uku utsu igba ra arhim nu kishoo abika akorhi iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Umbɔ awuri itare abika abewunga ri ikon urha, ra anangkɛ umbɔ aka iciu akpe na atãi anyĩ. ");
INSERT INTO ldb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mɔcɛ abika arhika awuri irhang ru nyaki ishaa unum ri Iyɛrhe Utɛmbɔ. Unga uwuku awe ra ato, neke unga agũ. ");
INSERT INTO ldb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","<<Iyɛrhe afã iwu ru nyaka abin ugarh aka awɔk ri icang. Ivangyɛ unera aka akpo ake, unga awɔke ake ikɛi, agɔm na azĩ agoshe kishoo abinnga na agoi icang hã. ");
INSERT INTO ldb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","<<Iyɛrhe afã iwu ru nyaku uner igoi uwuku ubee atarhkɛ aka awu ru ugarh. ");
INSERT INTO ldb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ivangyɛ unga aka akpo utarh ugarh ha akarhãrhã, unga azĩ agoshuka kishoo abinkɛ unga aka awe ra ake na agoi utarh ugarh ha. ");
INSERT INTO ldb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","<<Iyɛrhe afã iwe ru nyaki itang igber iyiki idzui abɛrh. Umbɔ iki itang ru ukau ukugɔng ngge idzui kishoo ikpũ abɛrh. ");
INSERT INTO ldb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ivangyɛ ngge iki itɔk, abi udɛm agbiir azĩ ru ubang ukau ukugɔng hã. Mɔcɛ umbɔ asei na atɛng abɛrh aka azea atsuku uzing na atare akika abewe. ");
INSERT INTO ldb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Iwuri iwe rimi ri imimashu upfung. Ípfu itser-Num iwuri iba igashuwe abika abewe nggu abika arhurhika. ");
INSERT INTO ldb_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Umbɔ awuri itare abika abewunga ri ikon urha, ra anangkɛ umbɔ aka iciu akpe na atãi anyĩ.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Uyesu arhusa agɛ, <<Umbi ahwɛngmbi akɛrɛ ha kishoo?>> Umbɔ agɛ, <<Ĩĩ.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Unga agɔr umbɔ agɛ, <<Nggee ubɛn uwuku umesuwe Ikpem umbɔ aka adɛyiwe unga Iyɛrhe afã, awe ru nyaku utei iya aka akũ abin adzeka ru angbannga aka afa nu aka agbe.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ivangyɛ Uyesu aka amaa unyaka arherhe akɛrɛ, unga abɔruka anang hã. ");
INSERT INTO ldb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ivangyɛ unga aka aba utepunga, unga atirhi imesuwe anera ru ubã ifɛn-Nummbɔ. Umbɔ adzeidzeu na arhusa agɛ, <<Utsak uwurɛ akpo itsoi iyɛrɛ rinɛɛ rimi nu ijee iyiki ikorha abin idzeu? ");
INSERT INTO ldb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Asi iwea uwɛrɛ ha awu ungwɛ̃ ukapinta ha? Asi iwea uyanga umbɔ iki iyisa Umaryamu? Asi iwea angwɛ̃mbɔ rabɛ, umbɔ Uyaku nu Uyusuf nu Usiman nu Uyahuda? ");
INSERT INTO ldb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Asi iwea kishoo anapumbɔ rabɛ nggu umɛn? Awu rinɛɛ unga aka akpo kishoo abin akɛrɛ ha?>> ");
INSERT INTO ldb_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mɔcɛ umbɔ agũ avɔm nggu unga. Bɔr Uyesu agɔr umbɔ agɛ, <<Awu ru ubɛn unera aka adzowe uner uwuku usɔm Arherhu-Num igɔng, bɔr asi iwea abi utepunga, nu abi iyanga.>> ");
INSERT INTO ldb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Awu ida imangmangmbɔ itsu unga asi ikorhunga abin idzeu arhɛrhɛ nggɔɔ ha. ");
INSERT INTO ldb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ri ivang hã Uyɛrhe Uhiridu aka agũ arherhe ri itsi Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Unga agɔr abika atɔ̃we unga itser agɛ, <<Awu Uyohana Uner Ubɔtisima unga asok ra akpe! Ngge itsu unga awuri ijee iyiki ikorha abin idzeu akɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ubinkutsu Uhiridu aka adzur Uyohana agbang ru ugborzĩ ri itsi Uhirudiya utsɛrha ungwɛ̃mbɔ Ufirhibu. ");
INSERT INTO ldb_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ubinkutsu Uyohana adɛyiwe Uhiridu agɛ, <<Isi imɛ̃ngge ungo uku upfunu Uhirudiya!>> ");
INSERT INTO ldb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Uhiridu abee ifɛre Uyohana, bɔr agũ iwei anera, ubinkutsu umbɔ aka anyangu Uyohana awu uwuku usɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Unum imar Uhiridu uku uba uwe, unapa Uhirudiya azer azer ri irhowa ha atsu Uhiridu agũibɛn akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nggee unga ayirh na abemuwe idzowe una hã kishoo ubinkpi unga aka ifɛna. ");
INSERT INTO ldb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Uyisa una hã adzowe itsũwã, agɛ, <<Udzaa umum itsi Uyohana Uner Ubɔtisima ri itɛ̃rhãzɔu.>> ");
INSERT INTO ldb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Amɛn uyɛrhe aghong, bɔr ri itsi atsen irhowa ha nu uyirh ha utsu unga atsu umbɔ adzowe ubinkpi una hã aka abee. ");
INSERT INTO ldb_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Unga adene umbɔ azĩ azharhukumbɔ itsi Uyohana ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Akũ itsi ha nu itɛ̃rhãzɔu aba adzowe ru una hã, unga atsã akowuka uyanga. ");
INSERT INTO ldb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Angwɛ̃ imesu Uyohana aba ashupu ukomnga adzake. Mɔcɛ umbɔ azĩ asɔme Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ivang Uyesu aka agũ rimi, unga asok atsĩ ukhukhɔɔ amɛ̃ agar azĩã anangkɛ anera aka ashimbɔ awe ikiyikanga. Bɔr ikikɔng anera iki igũ rimi, umbɔ adzeka ri íteu adɔsa unga ra adak. ");
INSERT INTO ldb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ivangyɛ unga aka adzeku ukhukhɔɔ ha anyã anera aka akɔng arhɛrhɛ, unga agũ atorh umbɔ na akerhuwe abi irhãrhãmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Urhɛɛ uku uwe, angwɛ̃ imesanga aba agɔr unga agɛ, <<Anang akɛrɛ ashike ru uner, nggayɛ urhɛɛ uku uwekpɔ. Usoyiwe ikikɔnga umbɔ azĩmbɔ, ngge itsú umbɔ atsĩ ri iteu azĩ agoi ubingha.>> ");
INSERT INTO ldb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Uyesu agɛ, <<Isi imɛ̃ngge umbɔ azĩmbɔ. Àka adzowe umbɔ ubin umbɔ agha.>> ");
INSERT INTO ldb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Umbɔ agɔr agɛ, <<Umɛn ikpurhi iwe ru ípo uborodi itɔ̃ɔ̃ nu abɛrh avaa.>> ");
INSERT INTO ldb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Unga agɛ, <<Àka akũwã ake ru umum nggimi.>> ");
INSERT INTO ldb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na agɔr anera asei nu ubĩĩ. Unga anyangu ípo uborodi atɔ̃ɔ̃ hã na abɛrh ha ikivarhake. Abera asunga arhi afã, atar uwɛɛ ru Unum. Unga atsɔka adzowe ra angwɛ̃ imesanga, umbɔ agashuwe ra anera. ");
INSERT INTO ldb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Umbɔ kishoo agha ashur, nu angwɛ̃ imesanga arhɔ̃yĩ awushunga. Ake atɔk azĩnga usɔkdũmɛn. ");
INSERT INTO ldb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Irhɛɛ anera aka agha ubingha ha akatsak atsĩmbɔ anaka agɔnga atɔ̃ɔ̃, asi ivarhumbɔ akatsɛrh nu awɛkaci. ");
INSERT INTO ldb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kanying Uyesu atsu angwɛ̃ imesanga abɔre unga na atsĩ ukhukhɔɔ amɛ̃ agbaashia azĩmbɔ ugar ukpɔrɔ. Unga asoyiwe ikikɔnga. ");
INSERT INTO ldb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Unga aka asoyiwe umbɔ amaa, unga afũã ni itsi igũa ikiyikanga azĩã ifɛn-Num. Urhɛɛ uwekpɔ, unga awe ru nggɔɔ ha ikiyikanga. ");
INSERT INTO ldb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ri ivang hã ukhukhɔɔ ha uku uzĩ udermgbɔ ru ukau ukugɔng hã, ugba unyaikpɔ utsu amɛ̃ uni ikwɛr umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ivanga iwu akara ataar aki utsuu, umbɔ anyã Uyesu aka azɛ̃rhã nu amɛ̃ ukau ukugɔng azĩã ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ivang angwɛ̃ imesanga aka anyã unga azɛ̃rhã nu afafã amɛ̃, umbɔ agũ iwei. Agɛ, <<Awu imãrhã!>> Atsu ivum iwei iki ifɛrmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kanying Uyesu agɔr umbɔ agɛ, <<Àka aker amɛnmbi! Awu umum. Niba agũmbi iwei.>> ");
INSERT INTO ldb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mɔcɛ Ubitru agɔr unga agɛ, <<A Uteijee, aba awu ungo, utsu umum izɛ̃rhã nu afafã amɛ̃ ĩba ru ungo.>> ");
INSERT INTO ldb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Uyesu agɛ, <<Uba.>> Mɔcɛ Ubitru adzeku ukhukhɔɔ ha, atirhu uzɛ̃rhã nu afafã amɛ̃ azĩã ru Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bɔr unga aka anyã ugba, unga agũ iwei na atirhunga ididɛɛ. Unga atsu ivum, agɛ, <<A Uteijee, ufɔrh umum!>> ");
INSERT INTO ldb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kanying Uyesu anamu uboknga adzur unga, agɛ, <<Ungo uner imangmang iyiki ici, awu use utsu ungo ucang?>> ");
INSERT INTO ldb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ivangyɛ umbɔ aka atsĩ ukhukhɔɔ ha, ugba ha ukpe unu. ");
INSERT INTO ldb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mɔcɛ abirabɛ aka awe ru ukhukhɔɔ ha adzowe unga igɔng, agɛ, <<Idzidzɛrhe ungo uwu Ungwɛ̃ Unum.>> ");
INSERT INTO ldb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ivangyɛ umbɔ aka agar ukau ha, umbɔ acipa ru abĩ Ujanisarat. ");
INSERT INTO ldb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Aner ha ahwɛngmbɔ ugɛ Uyesu awu umɔ, umbɔ adene umbɔ adɛyiwe anera aka awu ra abĩ hã. Umbɔ akũ kishoo abi irhãrhã aba ru unga. ");
INSERT INTO ldb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Umbɔ ashɔ̃rhã unga aneke abi irhãrhã amaa abangu ifɛn atorho akagɔnga. Nu kishoo abirabɛ aka abanga ake, akerhumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mɔcɛ abi Ufarisi abɔɔ nu abika amesuwe Ikpem adzeku Urusharhima aba ru Uyesu arhusa agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","<<Awu use utsu angwɛ̃ imesango azharhuwe agbeyi atokamɛn? Asi isorhmbɔ abokmbɔ na adɔrha agha ubingha.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bɔr Uyesu agɔr umbɔ agɛ, <<Awu use utsu agbeyambi atsu umbi azharhuwe Ikpem Unum? ");
INSERT INTO ldb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ubinkutsu Unum agɛ, <Udzowe imor ru utɛngo nu uyango,> nu <Ubɛn unera aka arhenu utɛnga use uyanga awu ufang umbɔ afɛre unga.> ");
INSERT INTO ldb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bɔr umbi amesuwe ugɛ ubɛn unera aba awea ru ubinkpi unga aka iyike utɛnga use uyanga, na adɛ̃ɛ̃ agɔr umbɔ agɛ, <Ubin hã uwu izũwã iyi Unum.> ");
INSERT INTO ldb_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Rimi hã umbi agɛ asi iwea ufang unga idzowe imor utɛnga nggu ukpɔ. Agbeyambi atsu umbi anyanga Arherhu-Num awe ibɛm. ");
INSERT INTO ldb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Umbi abi ukpukpeta! Irhikungge uwuku usɔm Arherhu-Num Uishaya aka asɔm arherhe ri itsimbi agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","<< <Aner abɛrɛ adzaa umum igɔng nggu angwĩmbɔ ukpekũ, bɔr amɛnmbɔ aderke nggu umum. ");
INSERT INTO ldb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Umbɔ adzaa umum igɔng ibɛm, anu imesuwe ikpem anera ugɛɛ Unum adzowe umbɔ.> >> ");
INSERT INTO ldb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Uyesu ayisi ikikɔnga iba ru unga agɔr umbɔ agɛ, <<Àka akpeto na ahwɛng. ");
INSERT INTO ldb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Asi iwea ubinkpi iki itsĩ ra angwĩ unera itsu unga asi isara, bɔr ubinkpi uku idzeka ra angwĩnga, ukpɔɔ utsu unga <asi isara.> >> ");
INSERT INTO ldb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Mɔcɛ angwɛ̃ imesanga aba ru unga arhusa agɛ, <<Ungo uhwɛngngo abi Ufarisi agũ avɔm umbɔ aka agũ arherha akɛrɛ?>> ");
INSERT INTO ldb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Unga agɛ, <<Ubɛn ubinkpi Utɛmum ra afã aka asi idosa, awuri ibvurhuwe. ");
INSERT INTO ldb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Àka aneke umbɔ, umbɔ awu abi ibvuta abika adarh abi ibvuta. Uner ibvuta aba adarha uner ibvuta, umbɔ ikivarhambɔ awuri igba ru ughwee.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ubitru agɔr unga agɛ, <<Usɔma umɛn agben unyaka arherhe ha.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Mɔcɛ Uyesu agɛ, <<Umbi anasi ihwɛngmbi? ");
INSERT INTO ldb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Umbi asi ihwɛngmbi ubɛn ubinkpi uku utsĩ ra angwĩ unera, utsĩ ra ananga nu udzekpɔ ri iyornga? ");
INSERT INTO ldb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bɔr ubinkpi uku idzeka ra angwĩ, udzeka ra amɛnnga, ukpɔɔ ha utsu unera asi isara. ");
INSERT INTO ldb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ubinkutsu, ifɛrhkɔ iyiki ibewe iki isaki idzeyiwa ra amɛn unera, ifɛr uner, itoma-dak, iyiki itãrhã, ivɛu, igbɛrangwĩ, nu idakuwe itsok unera. ");
INSERT INTO ldb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Akɛrɛ atsu unera asi isara, bɔr igha ubin nggu abok aka ada isisorh asi ítsu unera asi isara.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Uyesu aka abɔre anang hã na azĩã abĩ Utaya nu Usidon. ");
INSERT INTO ldb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Utsɛrh Ukan'ana aka asei ra abĩ hã aba ru unga, na atsarhi irhaknga agɛ, <<Ucorhuwa umum! Uteijee, Ungwɛ̃ Udauda, ipfu iyiki ibewe inu idzowe unapmum uver.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Uyesu asi iyanuka urhɛm. Nggee angwɛ̃ imesanga aba ashɔ̃rhã unga agɛ, <<Udene unga azĩã, ubinkutsu arharuwe atomɛn nggu ivum adɔsa umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mɔcɛ Uyesu agɔr utsɛrh ha agɛ, <<Adena umum ri ídɔi Uisrairha iki igwir ukpekũ.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Bɔr utsɛrh ha aba atararhu ru unga, agɛ, <<A Uteijee, uma uyika umum!>> ");
INSERT INTO ldb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Uyesu agɛ, <<Isi irhikungge umbɔ anyangu ubingha awɛkaci atsuke íjui.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Unga agɛ, <<Ĩĩ, Uteijee, bɔr íjui iki isaki ighangge awushu ubingha aki idzeku utebur iyi uteiya agbei nu abĩ.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Mɔcɛ Uyesu agɔr unga agɛ, <<A atsɛrh ha, imangmango iwe akarhãrhã! Ibibeeango ikpongge.>> Kanying unapunga akerhunga. ");
INSERT INTO ldb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Uyesu abɔre umɔ na adɔsu udiku ubang Ukau Ugarhirhi. Mɔcɛ unga afũ igũ aseisa. ");
INSERT INTO ldb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nggaa ikikɔng iba ru unga, akũ akatarhu, nu abi ibvuta, nu abika akaikai, nu abika afɔr arherhe adambɔ, nu abɔɔ arhɛrhɛ, aden umbɔ ra adaknga, nu unga akerhuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Anera adzeidzeu umbɔ aka anyã agbau arherha arherhe, abika akaikai ayormbɔ akerhuke, akatarhu azɛ̃rhũmbɔ uzɛ̃rhã, abi ibvuta anyãmbɔ. Nu umbɔ kishoo akpoi Unum uwu Uisrairha. ");
INSERT INTO ldb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Uyesu ayisa angwɛ̃ imesanga aba ru unga na agɛ, <<Umum icorhuwe aner abɛrɛ. Awu unum untaar nukpi umbɔ aka awe nggu umum ashimbɔ ru ubingha. Umum isi ĩbeemum isoyiwe umbɔ nggu imerh, utsur umbɔ agbeimbɔ ru udĩ.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Angwɛ̃ imesanga agɛ, <<Umɛn ikpo ubingha ri inɛɛ ra arhum akɛrɛ uku imɛ̃ ifuka arhɛrha anera abɛrɛ?>> ");
INSERT INTO ldb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Uyesu arhusa umbɔ agɛ, <<Umbi awe ru ípo uborodi isong?>> Umbɔ agɛ, <<Utɔɔva nu ungwɛ̃rhã abɛrh ukunjiir.>> ");
INSERT INTO ldb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Unga atsu ikikɔnga iseisa abĩ. ");
INSERT INTO ldb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mɔcɛ unga anyangu ípo uborodi ha utɔɔva nu abɛrh ha, unga aka atar uwɛɛ ru Unum. Mɔcɛ na atsɔka ukpɔ adzowe angwɛ̃ imesanga, umbɔ agashuwe ikikɔng anera. ");
INSERT INTO ldb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kishoo agha ashur. Angwɛ̃ imesanga arhɔ̃yĩ awushunga ra abĩ ake atɔk azĩnga utɔɔva. ");
INSERT INTO ldb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Abirabɛ aka agha akatsak awu anakagɔnga anaa, asi ivarhumbɔ akatsɛrh nu awɛkaci. ");
INSERT INTO ldb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Uyesu aka asoyiwe ikikɔng anera amaa, unga atsĩ ukhukhɔɔ amɛ̃ azĩã abĩ Umagadan. ");
INSERT INTO ldb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Abi Ufarisi nu abi Usaduki aba aviru Uyesu, arhusa unga ugɛ unga akorhu ubin idzeu ukpu uwu utsar uku udzeka afã. ");
INSERT INTO ldb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Unga agɛ, <<Urhɛɛ uba uwekpɔ, umbi aka isaka agɔr agɛ, <Ananga awuri izeke udã, afã awe uku uzhããĩ.> ");
INSERT INTO ldb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nu unkpeeka umbi aba anyã afã awe uku uzhããĩ na atsir nggu ufin inai, umbi aka isaka agɔr agɛ, <Irherɛ inai iwuri idoingge.> Umbi adɛ̃ɛ̃ ahwɛngmbi agben afã, bɔr umbi asi ihwɛngmbi atsarkɛ aka idɛyiwe agben abinkɛ aka anu ikorhe inum iyɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Abika abewe, abika asheru Unum, abi undan ukpirɛ arhusu utsar idzeu! Bɔr asi ídɛyikumbɔ umbɔ utsar, akpurha adɛyiwe utsar ukpu uwuku usɔm Arherhu-Num Uyunana.>> Uyesu abɔre umbɔ na azĩã. ");
INSERT INTO ldb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ivangyɛ umbɔ aka agar ukau ha, angwɛ̃ imesa ayirukumbɔ ikpɔm uborodi. ");
INSERT INTO ldb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Uyesu agɔr umbɔ agɛ, <<Àka angwɛ̃dzɛn, àka akpɔm amɛnmbi nggu uga abi Ufarisi nu abi Usaduki.>> ");
INSERT INTO ldb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Umbɔ arherhe nggu adɔkambɔ agɛ, <<Unga arherhe rimi ubinkutsu, awu umɛn iki isi ikpɔmmɛn uborodi.>> ");
INSERT INTO ldb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Uyesu ahwɛnga ubinkpi umbɔ aka anu irherhe unga arhusa agɛ, <<Umbi abi imangmang iyiki ici, awu use utsu umbi arherhe nggu adɔka ugɛ umbi ashimbi ru uborodi? ");
INSERT INTO ldb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Utsɛku icɛrɛ umbi anasi ihwɛngmbi? Umbi aka ayirukumbi umum iki ikũ ípo uborodi itɔ̃ɔ̃ ifuka anera anakagɔnga atɔ̃ɔ̃? Azĩnga asong umbi aka arhɔ̃yĩ atɔk? ");
INSERT INTO ldb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ikɛi ípo uborodi utɔɔva uku uwe ubingha anera anakagɔnga anaa. Azĩnga asong umbi aka arhɔ̃yĩ atɔk? ");
INSERT INTO ldb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Awu use utsu umbi asi idɛ̃ɛ̃ ahwɛngmbi ugɛ umum isi irherhumum arherhe uborodi? Umum igɔr ugɛ àka akpɔm amɛnmbi nggu uga abi Ufarisi nu abi Usaduki.>> ");
INSERT INTO ldb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mɔcɛ umbɔ aka ahwɛng ugɛ asi igɔra umbɔ ikpɔm amɛn ru uga uborodi, bɔr agɔr umbɔ ikpɔm amɛn ri imesa abi Ufarisi nu abi Usaduki. ");
INSERT INTO ldb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ivangyɛ Uyesu aka aba ra abĩ abi Ukaisariya Ufirhibi, unga arhusa angwɛ̃ imesanga agɛ, <<Anera ani igɔr ugɛ Ungwɛ̃-Ner awu ungamɔ?>> ");
INSERT INTO ldb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Umbɔ agɛ, <<Abɔɔ agɔr ugɛ Uyohana Uner Ubɔtisima, abɔɔ agɛ Uirhiya, abɔɔ agɛ Uirimiya use uwɔɔ ra abika asɔm Arherhu-Num.>> ");
INSERT INTO ldb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Unga arhusa umbɔ agɛ, <<Bɔr umbi agɔr ugɛ umum iwu ungamɔ?>> ");
INSERT INTO ldb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ubitru agɛ, <<Ungo uwu Ukiristo Ungwɛ̃ Unum uwu urhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Uyesu agɔr unga agɛ, <<Ungo uwu uner idorh, Usiman ungwɛ̃ Ujona! Asi iwea unera adɛyiwa ungo akɛrɛ ha, awu Utɛmum uwuku uwe ra afã. ");
INSERT INTO ldb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Umum idɛyiwa ungo ugɛ ungo uwu Ubitru, agbena agɛ ifa. Nu ifa iyɛrɛ umum iki idzin ikikɔng abika adɔsa, iyiriyɛ ijee akpe isi ínangge ingge. ");
INSERT INTO ldb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Umum iwuri ĩdzaamum ungo ijee iki idzeki Iyɛrhe afã. Ubɛn ubinkpi ungo iki ibow ru upfung, awuri ibow ukpɔ ra afã. Ubɛn ubinkpi ungo iki igarhuwe ru upfung, awuri igarhuwe ukpɔ ra afã.>> ");
INSERT INTO ldb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Mɔcɛ unga agbiite ato angwɛ̃ imesanga utsur umbɔ adɛyikumbɔ unera agɛ unga awu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Udzur ri ivang hã Uyesu atirhi idɛyiwe angwɛ̃ imesanga ugɛ awu ufang unga awuri izĩ Urusharhima na ahwa ayetnum ra abina arhɛrhɛ ru abok akakũ, nu ateiya abika adzowe idɛm-Num, nu abika amesuwe Ikpem. Awu ufang umbɔ afɛre unga, ru unum untaar unga awuri isok abɛka. ");
INSERT INTO ldb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ubitru agbiira unga azĩ ri ifɛna atirhi itsɛrha unga agɛ, <<Ishingge Uteijee! Akɛrɛ asi íkorhuke nggu ungo!>> ");
INSERT INTO ldb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Uyesu adzipa agɔr Ubitru agɛ, <<Usɔkɔ ru umum Ushaitan! Ungo uwu utarh ukpuku ukwɛr itok ru umum, ifɛrhkɔngo iwe ru nyaki iyi anera, isi iwengge ru nyaki iyi Unum.>> ");
INSERT INTO ldb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Mɔcɛ Uyesu agɔr angwɛ̃ imesanga agɛ, <<Uba unera abeenga idɔsa umum, awu ufang unga akpɛ̃ɛ̃ itsikamnga, na ashupu igãrhãmau ucuciianga adɔsa umum. ");
INSERT INTO ldb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ubɛn unerwi aka abee ifɔrh urhɛnga, umgbɔ uwuri igwirmgbɔ. Bɔr uwuku ugwirhuwe urhɛnga ru umum awuri ikpoa umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Awu use izea unera aki ikpo abin upfung kishoo na ashia ru urhɛ uwu ugbagbaa? Use unera awuri ikũ use afaru urhɛnga uwu ugbagbaa? ");
INSERT INTO ldb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ungwɛ̃-Ner awuri ibanga nggu ikpikpoi Utɛnga nggu ípfu itsernga, mɔcɛ unga aka ifai ubɛn unera itsernga aka atɔ̃. ");
INSERT INTO ldb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Umum indɛyiwa umbi idzidzɛrhe, abɔɔ rabɔ adɛ̃ɛ̃ nggimi asi íkpembɔ utsɛku umbɔ aka inyã ibiba Ungwɛ̃-Ner ri Iyɛrhanga.>> ");
INSERT INTO ldb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Inuma utɔ̃ĩ iki imaa Uyesu akũ Ubitru, Uyaku nu Uyohana ungwɛ̃mbɔ Uyaku, umbɔ azĩ ni itsi igũ iyɔɔ iderdetangge, anangkɛ umbɔ aka awe ikiyikambɔ. ");
INSERT INTO ldb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Umɔ unga adzipa awuwea ra asumbɔ. Asunga arhang ru nyaki ishaa unum, atorhanga awe aka aterha uku upɛ̃rhɛng ru nyaki irhirhang. ");
INSERT INTO ldb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kanying Umusa nu Uirhiya akapɛɛng ru umbɔ, adɛ̃ɛ̃ arherhe nggu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ubitru agɔr Uyesu agɛ, <<A Uteijee, izengge umɛn iki iwe nggimi. Ungo uba ubeengo, umum itar atsurha ataar nggimi, unying uwu ungo, unying uwu Umusa nu unying uwu Uirhiya.>> ");
INSERT INTO ldb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Adɛ̃ɛ̃ ra arherhe nukpi nggaa amɛɛ aka arhang atsire umbɔ, nu urhɛm ra amɛɛ ha uku ugɔr ugɛ, <<Uwɛrɛ awu Ungwɛ̃mum, uwuruwi umum iki ibema. Amɛnmum agũibɛn nggu unga akarhãrhã. Àka akpeto ru unga!>> ");
INSERT INTO ldb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ivang angwɛ̃ imesa ha aka agũ rimi, iwei ifɛr umbɔ, umbɔ akwɛr asumbɔ atsim ra abĩ. ");
INSERT INTO ldb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bɔr Uyesu aba abanga umbɔ agɛ, <<Àka asisok. Niba agũmbi iwei.>> ");
INSERT INTO ldb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Umbɔ aka abera atsimbɔ asi inyãmbɔ uner uwɔɔ, akpurha anyã Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Umbɔ aka awe ru utsĩndĩ uwuku ucipuwa ni itsi igũ hã, Uyesu atsu umbɔ agɛ, <<Niba adɛyikumbi unera ubinkpi umbi aka anyã utsɛku Ungwɛ̃-Ner aka isok ra akpe.>> ");
INSERT INTO ldb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Angwɛ̃ imesa ha arhusa unga agɛ, <<Awu use utsu abika amesuwe Ikpem agɔr ugɛ awu ufang uner uwuku usɔm Arherhu-Num Uirhiya aka igbaashia aba?>> ");
INSERT INTO ldb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Unga agɔr umbɔ agɛ, <<Awu idzidzɛrhe Uirhiya aka iba, unga igbishu ubɛn ubin. ");
INSERT INTO ldb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bɔr umum idɛyiwa umbi, Uirhiya aka abanga, bɔr umbɔ asi ihwɛngmbɔ unga, na akorhuwe unga ubinkpi umbɔ aka abee. Rimi hã Ungwɛ̃-Ner aka ihwa ayetnum ru ubokmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Mɔcɛ angwɛ̃ imesa ha ahwɛng ugɛ unga arherhe arherha ha ri itsi Uyohana Uner Ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ivangyɛ umbɔ aka azĩ atsĩ ra anang ikikɔnga, uner uwɔɔ aba ru Uyesu atararhu ra anangnga. ");
INSERT INTO ldb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Na agɛ, <<A Uteijee, uma ugũ atorh ungwɛ̃mum, awuri irhãrhĩ unggbunggbuwa, aka ahwa uver akarhãrhã. Idikunga irhɛirhɛ unga iki igbei ru urha use ra amɛ̃. ");
INSERT INTO ldb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Umum iki ikũna unga izĩ ra angwɛ̃ imesango, bɔr umbɔ asi idɛ̃ɛ̃ akerhukumbɔ unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Uyesu agɛ, <<Umbi abi udan ukpirɛ, abika asheri imangmang, abi amɛn aka abewe. Umum iki isei ĩdãrhũmum nggu umbi, ukang umbi aka awe ru imangmang ru umum? Utsɛku ukang umum iki ibima nggu ida imangmangmbi? Ukũ ungwɛ̃ hã uba nggɛɛ ru umum.>> ");
INSERT INTO ldb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Uyesu atsɛrhi ipfu iyiki ibewa ha idzengge ru ungwɛ̃ hã. Kanying ungwɛ̃ hã akerhunga. ");
INSERT INTO ldb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mɔcɛ angwɛ̃ imesa ha aba ru Uyesu ri ivangyɛ anera aka ashimbɔ nggu unga, agɔr unga agɛ, <<Awu use utsu umɛn ifɔr itsũwe ipfu iyiki ibewa ha idamɛn?>> ");
INSERT INTO ldb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Uyesu agɔr umbɔ agɛ, <<Imangmangmbi iwe ukunjiir ngge itsu. Umum indɛyiwa umbi idzidzɛrhe, umbi aba awembi ri imangmang ukunjiir ru nyaki ishaa umastad, umbi adɛ̃ɛ̃ agɔrmbi igũ iyɛrɛ agɛ, <Usoku nggɛɛ uzĩ ru nggɔɔ,> ngge iwuri iso izĩngge. Ubin usi ínangkpɔ umbi.>> ");
INSERT INTO ldb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ivangyɛ angwɛ̃ imesa ha aka akɔng ra abĩ Ugarhirhi, unga agɔr umbɔ agɛ, <<Awuri ighambɔ adak Ungwɛ̃-Ner adzowe unga ra abok anera. ");
INSERT INTO ldb_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Umbɔ awuri ifɛre unga, ru unum untaar unga awuri isok abɛka.>> Amɛn angwɛ̃ imesa ha aghong. ");
INSERT INTO ldb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Uyesu nu angwɛ̃ imesanga aka atsĩ ru Ukafanahum, abika ayɛi ikirbi Iya-Num akpo Ubitru arhusa unga agɛ, <<Umarhemmbi asi ífaisa ikirbi Iya-Num?>> ");
INSERT INTO ldb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Unga agɛ, <<Afasa.>> Ivangyɛ Ubitru aka aba ri iya, Uyesu atirhi arherha arherhe nggu unga agɛ, <<Ungo unyã uguse Usiman? Ayɛrhe ayɛi ikirbi abĩ ru ungamɔ, ra awɛkacimbɔ use ra abikase?>> ");
INSERT INTO ldb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ubitru agɛ, <<Ra abikase.>> Mɔcɛ Uyesu agɛ, <<Awɛkacimbɔ asi ífaimbɔ nukpɔ. ");
INSERT INTO ldb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bɔr utsur umɛn iwemɛn ru uvau ra anera abɛrɛ, uzĩ ru ukau ukugɔng utang igber. Uyanga angwĩ ubɛrh ha ungo uku utirhu udzur. Ungo ikpoɔ ishaa imang uazurhfa. Ukũ ishaa imang uazurhfa ha ufai imang iyi Iya-Numngo nggu iyi umum.>> ");
INSERT INTO ldb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ri ivang hã angwɛ̃ imesa ha aba arhusu Uyesu agɛ, <<Ungamɔ awu uwuku ugɔnga ri Iyɛrhe afã?>> ");
INSERT INTO ldb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Unga ayisu ungwɛ̃rhũ uwɛkuci atsu unga adɛ̃ɛ̃ ra ateumbɔ, ");
INSERT INTO ldb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na agɛ, <<Umum idɛyiwa umbi idzidzɛrhe umbi aba asi idzipa awembi ru nyaka awɛkaci, umbi asi ítsĩmbi Iyɛrhe afã. ");
INSERT INTO ldb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nggee, uwuruwi aka arhɛrhi itsinga ru nyaku ungwɛ̃ uwurɛ unga awu uwuku ugɔnga ri Iyɛrhe afã. ");
INSERT INTO ldb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","<<Ubɛn unera aka ayɛisa ungwɛ̃rhũ uwɛkuci ru nyaku uwɛrɛ ri itsokmum, ayɛi umum. ");
INSERT INTO ldb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Bɔr uwuruwi aka atsu unying ra awɛkaci abɛrɛ abika awe ru imangmang ru umum atsĩã ra arhim, ugba umbɔ abope nggaa ukɔ igɔ ru urhɔknga na atare unga atsĩ ru ukau ukugɔng. ");
INSERT INTO ldb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","<<Atorh upfung ri itsi abinkɛ aka atsu anera atsĩ ra arhim! Awu ufang abin hã aka iba, bɔr atorh uwu ha aka itsu ake aba. ");
INSERT INTO ldb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Uba ubokngo use udakngo uni itsu ungo utsĩ ra arhim, uzharha ukpɔ utare. Ugba ungo utsĩ ru urhɛ ukpu ugbagbaa nggu ubokngo unying use udakngo unying nu umbɔ aka itare ungo utsĩ ru urha ukpu ugbagbaa nggu aboka avaa use adaka avaa. ");
INSERT INTO ldb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nu usungo uba itsu ungo utsĩ ra arhim, ukhor utare. Ugba ungo utsĩ ru urhɛ ukpu ugbagbaa nggu usua unying nu umbɔ aka itsuke ungo ri idzũ urha nggu asua avaa. ");
INSERT INTO ldb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","<<Àka arhi anyã niba akwɛɛrkumbi unying ra angwɛ̃rhã awɛkaci abɛrɛ. Umum idɛyiwa umbi, ípfu itsermbɔ ubɛn unum ini irhi asu Utɛmum uwuku uwe ra afã. ");
INSERT INTO ldb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","<<Umbi akaifɛrhkɔ aguse? Unera aba awe ru ídɔi unaka, unying igwirngge, unga asi ínekuka isɔka utɔɔrha nu utɔɔrha ra abang igũa na azĩã abee unying hã iki igwir? ");
INSERT INTO ldb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Unga aba anyã ngge, umum indɛyiwa umbi idzidzɛrhe, unga awuri igɔm iyi ha iki iyikangge ananga isɔka utɔɔrha nu utɔɔrha iki isi igwirngge. ");
INSERT INTO ldb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Rimi hã asi iwea ibibemu Utɛmbi ra afã unying ra awɛkaci abɛrɛ agwir. ");
INSERT INTO ldb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","<<Ungwɛ̃mbi use unapumbi aba agbaa uvau ru ungo, uzĩ usɔme unga uvaunga, ungo nu unga ukpekũ. Unga aba agũã, ungo uku ubvui ukũ unga ubango ri iwɛrhɛ nggu ungo. ");
INSERT INTO ldb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bɔr unga aba asi igũã, ungo ubee unera unying use ivaa umbi azĩ, ngge itsú ideka iyi inera ivaa use itaar imɛ̃ngge ifɛr arherhe. ");
INSERT INTO ldb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ungwɛ̃mbi aba akpɛ̃ɛ̃ igũ umbɔ, ungo udɛyiwe ikikɔng abika adɔsa, unga aba akpɛ̃ɛ̃ igũ ikikɔng abika adɔsa ha, unyanga unga ru nyaku unerwi aka asi idɔsunga Unum use uwuku uyɛi ikirbi abĩ. ");
INSERT INTO ldb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","<<Umum indɛyiwa umbi idzidzɛrhe, ubɛn ubinkpi umbi aka abow ru upfung awuri ibow ukpɔ ra afã. Ikɛi ubɛn ubinkpi umbi aka agarhuwe ru upfung awuri igarhuwe ukpɔ ra afã. ");
INSERT INTO ldb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","<<Umum ibvui idɛyiwa umbi, inera ivaa ru umbi ru upfung ukpirɛ aba ibema ifɛnu ubin ru Utɛmum uwu afã, awuri ikorhuka umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ubinkutsu inera ivaa use ataar aba akɔngmbɔ ri itsokmum, umum iwu nggu umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mɔcɛ Ubitru aba agɔr Uyesu agɛ, <<A Uteijee, idikunga isong ungwɛ̃mɛn aka igba uvau ru umum, umum itsũwe unga? Awu idikunga utɔɔva?>> ");
INSERT INTO ldb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Uyesu agɔr unga agɛ, <<Umum idɛyiwa ungo, asi iwea idiku utɔɔva, bɔr isɔka utɔɔva nu utɔɔva. ");
INSERT INTO ldb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","<<Nggee, Iyɛrhe afã iwe ru nyaku uyɛrhe uwɔɔ aka abee ivarha abinnga aka awe ra abok agãrhãnga abee umbɔ afase. ");
INSERT INTO ldb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Uyɛrhe ha aka atirhi avarhe, umbɔ akũ uner uwɔɔ aba ru unga, uwuruwi aka angwɛ̃ uvɛrh nggaa ibɛi uazurhfanga iyi anaka agɔnga usɔka. ");
INSERT INTO ldb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Unga aka afɔr ifai adaka, uyɛrhe ha agɛ agoshe unga nu utsɛ̃nga, nu awɛkacinga, nu kishoo abinkɛ unga aka awurake na akũ afase uvɛrhnga. ");
INSERT INTO ldb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","<<Ugãrhã hã atararhu ra asu uyɛrhe ha ashɔ̃rhã agɛ, <Umaa udɔng amɛnngo nggu umum, umum iwuri ifasamum abina kishoo.> ");
INSERT INTO ldb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Uyɛrhe ha agũ atorh unga, afɔ̃rhũwe uvɛrh ha na atsũwe unga azĩã. ");
INSERT INTO ldb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","<<Bɔr utsak ha aka adzek, anyã ugãrhũ itsernga aka angwɛ̃ uvɛrh unga íshaa imang unaka unying ukpekũ. Unga adzur urhɔk utsak ha akpɔm na agɛ, <Ufai ubinkpi umum iki idɔsa ungo.> ");
INSERT INTO ldb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","<<Udɔki itsernga atararhu na ashɔ̃rhã unga agɛ, <Udɔng amɛnngo nggu umum, umum iwuri ifasamum uvɛrhngo.> ");
INSERT INTO ldb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","<<Bɔr unga akpɛ̃ɛ̃. Akũ utsak ha azĩ agbanguka ru ugborzĩ utsɛku unga aka ifai uvɛrh ha. ");
INSERT INTO ldb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ivangyɛ andɔki itsernga abɔɔ aka anyã ubinkpi unga aka akorhe, umbɔ asi igũmbɔ ibɛn, umbɔ azĩ asɔmukumbɔ uyɛrhe ha kishoo ubinkpi uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","<<Mɔcɛ uyɛrhe ayisu ugãrhã hã agɛ, <Ungo uwu ugãrhũ uwu amɛn aka abewe, umum itsũwũkũ kishoo uvɛrhngo ri ishishɔ̃rhãyɛ ungo uku ushɔ̃rhã umum. ");
INSERT INTO ldb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Isi imɛ̃ngge ungo uku igũ atorh udɔki itserngo ru nyaka umum iki igũ atorh ungo?> ");
INSERT INTO ldb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Uyɛrhe agũ avɔm akarhãrhã, atsu umbɔ adzowe unga ayetnum utsɛku unga aka ifai uvɛrh ha. ");
INSERT INTO ldb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","<<Rimi hã Utɛmum ra afã aka ikorhe nggu uwuku ukpɛ̃ɛ̃ itsũwe undɔka ra amɛnnga.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ivangyɛ Uyesu aka amaa irherha akɛrɛ, unga abɔruka abĩ Ugarhirhi na azĩã abĩ Uyahudiya aka awu ugar Azɛ̃ Urdun. ");
INSERT INTO ldb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Nggaa ikikɔng anera idɔsa unga, unga akerhuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Abi Ufarisi abɔɔ aba ru unga avira unga. Arhusa unga agɛ, <<Ri ikpemmɛn imɛ̃ngge unera awayiwe utsɛ̃nga ri ikorhe ubɛn ubin?>> ");
INSERT INTO ldb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Unga agɔr umbɔ agɛ, <<Umbi anasi ivarhumbi itsɛng Arherhu-Num? Atsɛng ri inggbaashia ugɛ, <Unum amuna umbɔ ukutsak nggu ukutsɛrh,> ");
INSERT INTO ldb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","na agɛ, <Ngge iki iwe rimi, unera awuri ineke utɛnga nu uyanga na awu nggu utsɛ̃nga, umbɔ ikivarhambɔ awuri iwu iyora unying>? ");
INSERT INTO ldb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nggee umbɔ asi iwembɔ ivaa, bɔr umbɔ awe iyora unying. Nggee, ubinkpi Unum aka agbopa, unera niba agashuka.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Umbɔ arhusa agɛ, <<Awu use utsu Umusa atsu ugɛ adzowe ubvur uwuku ufɛr itsɛrh awayiwe utsɛrh ha azĩã?>> ");
INSERT INTO ldb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Uyesu agɔr umbɔ agɛ, <<Umusa abemuwa umbi igau itsɛrh ubinkutsu amɛn aka akermbi atsu. Bɔr isi iwengge rimi ri inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Umum idɛyiwa umbi ugɛ ubɛn unera aka awayiwe utsɛ̃nga aka asi itomunga-dak, na apfunu utsɛrh uwukuse, atoma-dak.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Angwɛ̃ imesa ha agɔr unga agɛ, <<Iba iwe rimi arherhe ukutsak nggu utsɛ̃nga, ida ipfuna ngge inang.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Uyesu agɔr umbɔ agɛ, <<Asi iwea ubɛn unera awuri idɛ̃ɛ̃ ayɛi arherhe akɛrɛ, bɔr abirabɛ Unum aka adzowe ngge. ");
INSERT INTO ldb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ubinkutsu abɔɔ awu akpirh, amar umbɔ rimi. Abɔɔ, anera akorhuwe, asi idɛ̃ɛ̃ apfunumbɔ. Abɔɔ Iyɛrhe afã itsu umbɔ akpɛ̃mbɔ ipfuna. Uwuku udɛ̃ɛ̃ ayɛi arherhe akɛrɛ unga ayɛi.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Mɔcɛ umbɔ akũ angwɛ̃rhã awɛkaci aba ru Uyesu atsorhuwe aboknga nu umbɔ na afɛne-Num ru umbɔ. Bɔr angwɛ̃ imesanga atsɛrha abika akũ awɛkaci ha aba. ");
INSERT INTO ldb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Uyesu agɛ, <<Àka aneke angwɛ̃rhã awɛkaci aba ru umum. Àka niba akɛnmbi umbɔ, Iyɛrhe afã iwu iyi ikpũmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Unga atsorhuwe umbɔ aboknga, mɔcɛ unga azĩã. ");
INSERT INTO ldb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mɔcɛ uner uwɔɔ aba ru Uyesu arhusa agɛ, <<A umarhem, ubin uku uze ukusong umum iki ikorhe ni ikpo urhɛ uwu ugbagbaa?>> ");
INSERT INTO ldb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Uyesu agɔr unga agɛ, <<Ungo urhusa umum ubin uwuku uze? Ubin uwuku uze uwu unying. Ungo uba ubeengo ikpo urhɛ uwu ugbagbaa, ungo udɔsi íkpem.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Unga arhusu Uyesu agɛ, <<íkpem iyikisong?>> Uyesu agɛ, << <Niba ufɛrɔ unera, niba utomungo-dak, niba uvɛpɔ ivɛu, niba ugbɛrɔ angwĩ utsukukɔ unera, ");
INSERT INTO ldb_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","udzowe imor ru utɛngo nu uyango,> nu <ubemu udɔkango ru nyaki itsikamngo.> >> ");
INSERT INTO ldb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Uwɛdzɛm hã agɛ, <<Umum iki idɔsumum akɛrɛ kishoo. Umum ĩbɔr use?>> ");
INSERT INTO ldb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Uyesu agɔr unga agɛ, <<Ungo uba ubeengo iwe undzumunga, ungo uzĩ, ugoshe abinngo, udzowe uhwɛka ra atsũwã, nu uba udɔsa umum. Mɔcɛ ungo iweɔ ru ugbɛta urhɛrhɛ ra afã.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ivangyɛ uwɛdzɛm ha aka agũ rimi, unga azĩ nggu ighongamɛn, ubinkutsu awe ru ubin akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Mɔcɛ Uyesu agɔr angwɛ̃ imesanga agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, aghong uner ubin aka itsĩ ri Iyɛrhe afã. ");
INSERT INTO ldb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ikɛi umum idɛyiwa umbi, ugba urhakumi utsĩ ra angwĩ inepurha nu uner ubin aka itsĩ ri Iyɛrhe-Num.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ivang angwɛ̃ imesa ha aka agũ rimi, umbɔ adzeidzeu akarhãrhã, na arhusa agɛ, <<Ungamɔ awuri idɛ̃ɛ̃ akpo ififɔrh?>> ");
INSERT INTO ldb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bɔr Uyesu arhi umbɔ na agɛ, <<Anera asi ídɛ̃ɛ̃ akorhumbɔ akɛrɛ, bɔr Unum adɛ̃ɛ̃ akorhunga abina kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ubitru agɔr unga agɛ, <<Nggayɛ umɛn ineke abina kishoo ni idɔsa ungo! Umɛn iwuri ikpo usemɛn?>> ");
INSERT INTO ldb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Uyesu agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, ru unumkpi umbɔ aka itsu abina kishoo awe aka afa, ivang Ungwɛ̃-Ner aka isei ru anang isei aki ijee iyi ikpikpoi, umbi abika adɔsa umum, awu umbi awuri isei nu anang isei ijee usɔkdũmɛn, umbi awuri itsu uvau anui usɔkdũmɛn aki Uisrairha. ");
INSERT INTO ldb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nu ubɛn unerwi aka aneke iyanga, use angwɛ̃mbɔ, use anapumbɔ, utei use uyi, use awɛkaci, use ícang ri itsimum awuri ikpo ananga rimi hã idikunga unaka, ikɛi unga awuri ikpoa urhɛ uwu ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bɔr anera arhɛrhɛ aka awu anggbaashi, awuri iwe amaata, amaata ikɛi awuri iwe anggbaashi. ");
INSERT INTO ldb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","<<Iyɛrhe afã iwe ru nyaku uteiya icang aka adzek ru unkpeeka atsu abi itser imang ri icangnga. ");
INSERT INTO ldb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Unga abemuwe ifai ishaa imang iki iwe imang itser unuma unying, na adene umbɔ azĩmbɔ ri icangnga. ");
INSERT INTO ldb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","<<Ra akara utɔɔrha aki ukpee ikɛi unga adzek anyã abɔɔ aka asei ibɛm ra angwĩ izɛɛ, ");
INSERT INTO ldb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","unga adɛyiwe umbɔ agɛ, <Umbi ikɛi àka azĩ atɔ̃ itser ri icangmum, umum ifasũ umbi ubinkpi uku umɛ̃ɛ̃.> ");
INSERT INTO ldb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nggee umbɔ azĩmbɔ. <<Unga adzek ra atenuma ra akara usɔkdũmɛn, ikɛi ra akara ataar akorhe rimi hã. ");
INSERT INTO ldb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ra akara atɔ̃ɔ̃ unga abvui adzek anyã abɔɔ aka adɛ̃ɛ̃ ibɛm. Unga arhusa umbɔ agɛ, <Awu use utsu umbi adɛ̃ɛ̃ asi itɔ̃mbi itser?> ");
INSERT INTO ldb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","<<Umbɔ agɔr unga agɛ, <Unera asi idzaanga umɛn itser iyiki itɔ̃.> <<Unga agɔr umbɔ agɛ, <Umbi ikɛi àka azĩ atɔ̃ itser ri icangmum.> ");
INSERT INTO ldb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","<<Urhɛɛ uku uwe, uteiya icang hã ayisu uwuku uyike unga agɛ, <Uyisa abi itser icang hã, ufase umbɔ imang itsermbɔ. Utirhi ra amaataka uzĩ ra anggbaashia.> ");
INSERT INTO ldb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","<<Abi itserbɛ aka azĩ ra akara atɔ̃ɔ̃ aba, umbɔ afai umbɔ ishaa imang. ");
INSERT INTO ldb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Abirabɛ aka agbaashia azĩ, afosi iyɛi anangmbɔ rimi. Bɔr ubɛn unera ayɛi ishaa imang. ");
INSERT INTO ldb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ivangyɛ umbɔ aka ayɛi ngge, umbɔ abvun arherhe ru uteiya icang hã. ");
INSERT INTO ldb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Agɛ, <Abirabɛ aka aba ri imaata, atɔ̃ itser iyi ukara unying ukpekũ, nu ungo ufai umbɔ uku kpengkpeng nggu umɛn iki ihwa uver itɔ̃ itser ru imani unuma.> ");
INSERT INTO ldb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","<<Bɔr unga agɔr unyinga umbɔ agɛ, <A uwee, umum isi ighamum urha ungo. Umɛn isi ikpangmɛm umum ifai ungo ishaa imang? ");
INSERT INTO ldb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Uyɛi imangngo uzĩɔ. Umum ibee ifai abika aba imaata uku kpengkpeng nggu ungo. ");
INSERT INTO ldb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Use ishimum ri ijee iyiki ikorhu ubinkpi umum iki ibee nggu imangmum? Use ungo ugũ unyɛ̃ɛ̃ umum iki idzise izũwã akarhãrhã?> ");
INSERT INTO ldb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","<<Rimi hã amaataka aka awe anggbaashia, nu anggbaashia awe amaataka.>> ");
INSERT INTO ldb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Uyesu nu angwɛ̃ imesanga aka azɛ̃rhã azĩ ufã Urusharhima. Unga agbiira umbɔ azĩ ri ifɛna ikiyikambɔ, agɔr umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","<<Umɛn izĩ ifũrhũwe Urusharhima. Awuri ighadak Ungwɛ̃-Ner adzowe unga ru ubok ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem. Umbɔ awuri itsu unga ufai akpe. ");
INSERT INTO ldb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mɔcɛ umbɔ aka idzowe unga ra atsen abi Uyahuda. Umbɔ ayɛia unga, akũ asharhe akwɛr unga, anyapuwe unga. Ru unum untaar unga awuri isoka ra akpe.>> ");
INSERT INTO ldb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mɔcɛ uya angwɛ̃ Uzabadi aba ru Uyesu nggu angwɛ̃nga, atararhu ra anangnga na afɛnu ubin ukpɔɔ. ");
INSERT INTO ldb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Unga arhusa unga agɛ, <<Ungo ubee use?>> Unga agɛ, <<Utsu awɛkaci abɛrɛ ikivarhambɔ asei, unying ru ubok ughango, uwu uvaa nu ubok uferango ri Iyɛrhango.>> ");
INSERT INTO ldb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bɔr Uyesu agɔr umbɔ agɛ, <<Umbi asi ihwɛngmbi ubinkpi umbi aka afɛna. Umbi adɛ̃ɛ̃ ahwambi ru ukpɛwa ha uwu ayetnumkɛ umum iki ihwa?>> Umbɔ agɔr unga agɛ, <<Umɛn imɛ̃mɛn.>> ");
INSERT INTO ldb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Uyesu agɔr umbɔ agɛ, <<Idzidzɛrhe umbi awuri ahwambi ru ukpɛwamum, bɔr isei ru ubok ugha nu ubok uferamum asi iwea umum itsũ idzowe. Anang hã awe aki abi Utɛmum ra afã aka agbishuwe.>> ");
INSERT INTO ldb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ivang angwɛ̃ imesa abɔrɔ usɔka aka agũ, umbɔ agũ avɔm abɔrɔ ha ikivarhambɔ. ");
INSERT INTO ldb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Bɔr Uyesu ayisa umbɔ ananga unying na agɛ, <<Umbi ahwɛngmbi ayɛrha atsen abi Uyahuda aki isaka adɛyiwe iyɛrhe ri itsi anermbɔ, anggbaashimbɔ adɛyiwe umbɔ ijee. ");
INSERT INTO ldb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bɔr isi íwengge rimi ru umbi. Ubɛn uwuku ubee igɔng ru umbi awu ufang unga awu ugãrhãmbi. ");
INSERT INTO ldb_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Nu uwuruwi aka abee iwu unggbaashi ru umbi, awu ufang unga awu ugãrhãmbi. ");
INSERT INTO ldb_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ru nyaku Ungwɛ̃-Ner asi ibanga umbɔ atɔ̃we unga itser, bɔr unga awuri iwu ugãrhã, na adzowe urhɛnga afɔrh anera arhɛrhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Uyesu nu angwɛ̃ imesanga aka abɔre Ujeriko, nggaa ikikɔng anera adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Abi ibvuta avaa aka asei nu ubang utsĩndĩã. Ivangyɛ umbɔ aka agũ ugɛ Uyesu unga atɔng, umbɔ atsarhi irhakmbɔ agɛ, <<A Uteijee, Ungwɛ̃ Udauda! Ugũ atorh umɛn!>> ");
INSERT INTO ldb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ikikɔnga itsɛrha umbɔ ugɛ umbɔ anukutata, bɔr umbɔ atoma atsarhi irhakmbɔ agɛ, <<A Uteijee, Ungwɛ̃ Udauda! Ugũ atorh umɛn!>> ");
INSERT INTO ldb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Uyesu adɛ̃ɛ̃ na ayisa umbɔ agɛ, <<Umbi abee umum ikorhuwa umbi use?>> ");
INSERT INTO ldb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Umbɔ agɔr unga agɛ, <<A Uteijee, umɛn ibee inyã anang.>> ");
INSERT INTO ldb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Uyesu agũ atorh umbɔ na abanga asumbɔ. Kanying umbɔ anyã ananga na adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Umbɔ aka akhapa ru Urusharhima aba atsĩ Ubetafaji nú Igũ Acucii Uzaitun. Uyesu adene angwɛ̃ imesanga avaa, ");
INSERT INTO ldb_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","agɔr umbɔ agɛ, <<Àka atsĩ ru uteu uku uci ha ra asumbi, utɛm itsitsĩmbi, umbi awuri inyãmbi uzhika umbɔ aka abow nggu ungwɛ̃mgbɔ. Àka agarha ake akũwã ru umum. ");
INSERT INTO ldb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Unera aba arhusunga umbi, àka adɛyiwe unga agɛ, <Uteijee unga abee ake,> awuri idzaanga ake kanying.>> ");
INSERT INTO ldb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Akɛrɛ akorhe rimi ngge itsuifɛr ubinkpi uner uwuku usɔm Arherhu-Num aka arherhe agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","<<Àka asɔme aner Urusharhima, <Àka anyã, uyɛrhambi uwi aba ru umbi! Unga adɔɔr, awu idzui uzhika, nú undzing ungwɛ̃ uzhika.> >> ");
INSERT INTO ldb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Angwɛ̃ imesa ha azĩ akorhe ru nyaka Uyesu aka agɔr umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Umbɔ akũ uzhika ha nggu ungwɛ̃mgbɔ aba, abɛtuwe atorhambɔ nú ungwɛ̃ɛ̃, Uyesu afũ asei. ");
INSERT INTO ldb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Anera arhɛrhɛ aka abɛtuwe atorhambɔ nú utsĩndĩã, abɔɔ agbɛyi abok acucii abɛtuwe nú utsĩndĩã. ");
INSERT INTO ldb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Anera abika awu ra asunga nu abirabɛ aka adɔsa unga ra andzing atsarhi irhakmbɔ agɛ, <<Ikpikpoi iwe nggu Ungwɛ̃ Udauda! Idorh iwe nggu uwuku uba ri itsok Uteijee! Ikpikpoi iwe afafã ra afã!>> ");
INSERT INTO ldb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ivangyɛ Uyesu aka atsĩ Urusharhima, utepa kishoo udzunukpɔ nu urhusa ugɛ, <<Awu ungamɔ nuwi?>> ");
INSERT INTO ldb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Anera agɛ, <<Uwɛrɛ awu Uyesu uwuku usɔm Arherhu-Num aka adzeku Unazarat ukpu Ugarhirhi.>> ");
INSERT INTO ldb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Uyesu atsĩ ri Iya-Num awayiwe kishoo abika agoyiwe nu abika agugoyi umɔ. Ayii atebur iyi abika afaru uhwɛk akwɛr atsĩme, nu atebur abika agoyiwe anurhɛu iya. ");
INSERT INTO ldb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Agɔr umbɔ agɛ, <<Itsɛng Arherhu-Num igɔr igɛ, <Awuri iyisi iyamum iwu iya ifɛn-Num,> bɔr umbi adzipa ake iwe anang awoi avɛu.>> ");
INSERT INTO ldb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Abi ibvuta nu akatarhu aba ru unga ri Iya-Num, unga akerhuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Bɔr ivang ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem anyã abin idzeukɛ unga aka akorhe, na anyã awɛkaci atsui ivum ri Iya-Num agɛ, <<Ikpikpoi iwe nggu Ungwɛ̃ Udauda,>> umɔ umbɔ agũ avɔm. ");
INSERT INTO ldb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Agɔr unga agɛ, <<Ungo ugũo ubin awɛkaci abɛrɛ aka adɛ̃ɛ̃ arherhe?>> Uyesu agɔr umbɔ agɛ, <<Ĩĩ, umbi anasi ivarhumbi ri itsɛng Arherhu-Num iki igɔr ugɛ, << <Awu ungo umesuwe angwɛ̃rhã awɛkaci nu írheng awɛkaci umbɔ akpoi ungo?>>> ");
INSERT INTO ldb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mɔcɛ unga abvui azĩã Ubetani, anangkɛ unga aka arha nu untsuua ha. ");
INSERT INTO ldb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ri igɔ̃kpeeka, unga awu ru utsĩndĩ uwuku ubvui uba utepa, imerh ifɛr unga. ");
INSERT INTO ldb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Unga aka anyã ucucii uvorhvo nu ibang utsĩndĩã, unga azĩ ru ucucii ha asi ikpoa ubin akpurha anyã ayerhe. Mɔcɛ unga agɔr ucucii ha agɛ, <<Ungo usi íbvui ughwɛrɔ ikpũrhã!>> Kanying ucuciia ha ukoyimgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ivang angwɛ̃ imesanga aka anyã rimi, umbɔ adzeidzeu akarhãrhã. Agɛ, <<Awu use utsu ucuciia ha udiki ikoyi iki ifefetem?>> ");
INSERT INTO ldb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Uyesu agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, umbi aba awembi ri imangmang na asi icangmbi, umbi adɛ̃ɛ̃ akorha anangmbi ubinkpi umum iki ikorhuwe ucucii uvorhvo uwurɛ. Uko umbi adɛ̃ɛ̃ agɔrmbi uko igũ iyɛrɛ agɛ, <Ugɔ̃rhũ itsingo utsĩ ru ukau ukugɔng,> ngge iwuri ikorhungge. ");
INSERT INTO ldb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Umbi aba awembi ri imangmang, ubɛn ubina umbi aka ifɛna ri ifɛn-Num, umbi awuri ikpombi.>> ");
INSERT INTO ldb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Uyesu aka atsĩ ru ufɔm Iya-Num na adɛ̃ɛ̃ imesuwe, mɔcɛ ateiya abika adzowe idɛm-Num nu akakũ anera aba ru unga. Arhusa unga agɛ, <<Ungo ukũ ijee iyikisong ukorha abin akɛrɛ? Ungaa adzaa ungo ijee ha?>> ");
INSERT INTO ldb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Uyesu agɔr umbɔ agɛ, <<Umum irhusa umbi ubina unying. Umbi aba adɛyiwambi umum, umum idɛyiwamum umbi ijee iyikisong umum iki ikũ ikorha abin hã. ");
INSERT INTO ldb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ubɔtisima Uyohana udzek ri inɛ̃ɛ̃ umgbɔ? Udzek ra afã, use udzek ra anera?>> Umbɔ arherhe nggu adɔka agɛ, <<Umɛn iba igɔr ugɛ, <Udzek ra afã,> unga awuri irhusa umɛn agɛ, <Awu use utsu umbi ashimbi ri imangmang ru unga?> ");
INSERT INTO ldb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Bɔr umɛn iba igɔr ugɛ, <Udzek ra anera,> umɛn igũ iwei anera abɛrɛ, ubinkutsu, umbɔ anyangu Uyohana awu uner uwuku usɔm Arherhu-Num.>> ");
INSERT INTO ldb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nggee umbɔ agɔr Uyesu agɛ, <<Umɛn isi ihwɛngmɛn.>> Mɔcɛ unga agɔr umbɔ agɛ, <<Umum igamum isi ídɛyiwamum umbi umum ikũ ijee iyikisong ikorha abin hã. ");
INSERT INTO ldb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","<<Umbi anyã aguse? Unera nuwɔ awu ra awɛkaci avaa akatsa. Unga azĩ ru uwu inggbaashia agɛ, <A ungwɛ̃mum, irherɛ uzĩ utɔ̃itser ri icang inebi.> ");
INSERT INTO ldb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","<<Ungwɛ̃ hã agɛ, <Umum isi ízĩmum,> bɔr unga abvui akaifɛrhkɔ ra amɛnnga na asok azĩã. ");
INSERT INTO ldb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","<<Mɔcɛ utɛmbɔ azĩã ru uwu uvaa, arherhe rimi hã. Ungwɛ̃ hã agɛ, <Ĩĩ, umum izĩmum,> bɔr asi izĩã. ");
INSERT INTO ldb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","<<Uwukusong akorhu ubinkpi utɛmbɔ aka abee?>> Umbɔ agɛ, <<Uwu inggbaashia.>> Uyesu agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, abika iyɛi ikirbi abĩ nu anggoyi awuri igbaashia atsĩmbɔ ri Iyɛrhe afã ru umbi. ");
INSERT INTO ldb_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ubinkutsu, Uyohana aba adɛyiwa umbi utsĩndĩ uwuku urhurhika, umbi ashimbi ri imangmang ru unga, bɔr abika ayɛi ikirbi abĩ nu anggoyi awembɔ ri imangmang ru unga. Umbi uko umbi aka anyã akɛrɛ, asi idzipumbi na iwembi ri imangmang ru unga. ");
INSERT INTO ldb_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","<<Àka akpeto ru unyaka arherhe akɔɔ. Unera nuwɔ akau icang inebi. Adzin ufɔm adzipu icanga, asim ughwee ri ifa ukpuku upayi amɛ̃ inebi ha ri ngge, na atar akang utsurha udedetamgbɔ uwu idzɛu. Adzowe icanga ra abi irham imang, na azĩã uzɛ̃rhã. ");
INSERT INTO ldb_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ivang iyiki igbigbɛr iki iwe, unga adene agãrhãnga umbɔ azĩmbɔ ra abi irham imang hã ayɛise ikpũrhã icangnga. ");
INSERT INTO ldb_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","<<Abi irham imang hã adzur agãrhũ utsak ha akwɛr unying, na afɛre unying, na atang atarh ru uwu untaar. ");
INSERT INTO ldb_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mɔcɛ unga abvui adene agãrhã abɔɔ ru umbɔ aka anangmbɔ abi inggbaashia. Bɔr abi irham imang hã akorhe ru nyaka umbɔ aka akorhe nggu abi inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ri imimasha kishoo, unga adene ungwɛ̃nga, agɛ, <Awuri idzowukumbɔ imor ru ungwɛ̃mum.> ");
INSERT INTO ldb_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","<<Bɔr abi irham imang hã aka anyã ungwɛ̃ hã, umbɔ agɔr adɔkambɔ agɛ, <Uwɛrɛ unga awu ru ukam icang hã. Umɛn ifɛre unga ni icanga iwu iyimɛn!> ");
INSERT INTO ldb_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nggee umbɔ adzur unga, atare unga ru undzing ufɔm icang hã, afɛre unga. ");
INSERT INTO ldb_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","<<Nggee, ivang uner icang hã aba abanga, unga awuri ikorha aguse nggu abi irham imang hã?>> ");
INSERT INTO ldb_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Umbɔ agɔr unga agɛ, <<Awuri ifɛruka abika abewa ha, na adzowe icanga ra abi irham imang abɔɔ, abirabɛ aka awuri idzowe ugau ikpũrhã icangnga ri ivangngge.>> ");
INSERT INTO ldb_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Uyesu agɔr umbɔ agɛ, <<Umbi anasi ivarhumbi ri itsɛng Arherhu-Num? Igɔr ugɛ, << <Utarhkpi abi idzin aka akpɛ̃, ukpɔ uwu utarh ãgboki idzina. Akɛrɛ awu ubinkpi Uteijee aka akorhe, na awu ubin idzeu ra asumɛn.> ");
INSERT INTO ldb_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","<<Nggee umum idɛyiwa umbi, awuri ivurmbɔ Iyɛrhe Unum ru umbi na adzowe abika aghwɛr ikpũrhã iyi Iyɛrhe Unum. ");
INSERT INTO ldb_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Uner ha aka igba ni itsi utarh iyɛrɛ, akpurha ashaka. Nu uwuruwi utarh ha uku igba nú unga, ukpurhu ugɔke unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ivang ateiya abika adzowe idɛm-Num nu abi Ufarisi aka agũ unyaka arherhe Uyesu aka adzowe, umbɔ ahwɛngmbɔ ugɛ arherhe ri itsimbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Umbɔ abee udĩ ukpuku udzur unga, bɔr umbɔ agũ iwei, ubinkutsu, ikikɔng anera anyanga unga awu uner uwuku usɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Uyesu abvui arherhuwe umbɔ unyaka arherhe agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","<<Iyɛrhe afã iwu ru nyaku uyɛrhe uwɔɔ aka akorhuwe irhowa ipfuna ru ungwɛ̃nga. ");
INSERT INTO ldb_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Adene agãrhãnga azĩ ayisuwe abirabɛ umbɔ aka aghwi umbɔ ipfuna hã aba, bɔr umbɔ akpɛ̃mbɔ ibibanga. ");
INSERT INTO ldb_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","<<Mɔcɛ unga abvui adene agãrhã abika arhɛɛ agɛ, <Àka adɛyiwe abirabɛ umbɔ aka aghwi ugɛ umum iki ikorhumum ubinghaa. Iki ingwã ínak iyiki itsak nggu angwɛ̃ inak aka agɔnga, abina kishoo iki igbisha imaamum. Àka aba irhowa ha!> ");
INSERT INTO ldb_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","<<Bɔr umbɔ asi inyãmbɔ ngge iwengge ifɛrhɛ, na azĩmbɔ. Uwɔɔ azĩã usinga, uwɔɔ azĩã igoyi igoi ri izɛɛ. ");
INSERT INTO ldb_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Abɔɔ adzur agãrhãnga, ayɔm na afɛre umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Uyɛrhe ha agũ avɔm. Unga adene abi iwanga, umbɔ afɛrkumbɔ umbɔ abika afɛyi aner ha na akpĩĩwe uteumbɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","<<Mɔcɛ unga agɔr agãrhãnga agɛ, <Aka amaambɔ izek irhowa ha, bɔr abirabɛ umum iki ighwi isi imɛ̃ngge umbɔ aba. ");
INSERT INTO ldb_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Àka adzek adɔsa atsĩndĩ aka agbopa ayisa kishoo abirabɛ umbi aka akpo, umbɔ aba irhowa ha.> ");
INSERT INTO ldb_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Nggee agãrhã hã adzek adɔsa atsĩndĩã ayisa kishoo abirabɛ umbɔ aka akpo, abika aze nu abika abewe, anang irhowa ha atɔk nggu atsen. ");
INSERT INTO ldb_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","<<Bɔr ivangyɛ uyɛrhe aka atsĩ abee inyã abi irhowa ha, umɔ unga anyã uner uwɔɔ aka asi itsima atorho irhowa. ");
INSERT INTO ldb_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Uyɛrhe arhusu uner ha agɛ, <A uwee, ungo ukorhu uguse nu utsĩwã nggimi ushiɔ ra atorho irhowa?> Bɔr uner ha asi idzipunga urhɛm. ");
INSERT INTO ldb_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","<<Mɔcɛ uyɛrhe agɔr abi itsernga agɛ, <Àka abow aboknga nu adaknga, na atare unga adzek atsĩ ru uzĩ, anangkɛ anera aka iciu akpe na atãi anyĩ.> ");
INSERT INTO ldb_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","<<Ubinkutsu awuri ighwi anera arhɛrhɛ, bɔr ukunjiir umbɔ aka isɛng.>> ");
INSERT INTO ldb_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mɔcɛ abi Ufarisi adzek akɛki itsũwãyɛ umbɔ aka ideya unga ru irhɛmnga. ");
INSERT INTO ldb_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Umbɔ adene angwɛ̃ imesambɔ nggu aner Uhiridu agɛ, <<A umarhem, umɛn ihwɛngmɛn ungo uwu uner idzidzɛrhe, ikɛi ungo uni imesuwe ubinkpi Unum aka abee nggu idzidzɛrhe. Ubinkutsu ungo usi itsukɔ amɛnngo ri ifɛrhkɔ anera use ubinkpi umbɔ aka awe. ");
INSERT INTO ldb_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Udɛyiwa umɛn, imɛ̃ngge umɛn ifai ikirbi abĩ ru Ukaisar, use isi imɛ̃ngge?>> ");
INSERT INTO ldb_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bɔr Uyesu ahwɛnga ifɛrhkɔ iyiki ibewambɔ, unga agɔr umbɔ agɛ, <<Umbi abi ukpukpeta, awu use utsu umbi adeya umum? ");
INSERT INTO ldb_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Àka adɛyiwa umum ishaa imangyɛ umbi iki ikũ afai ikirbi abĩ.>> Umbɔ akowe unga ishaa imang hã, ");
INSERT INTO ldb_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","unga arhusa umbɔ agɛ, <<Uzirhzĩ ukpi nu itsok ikɛrɛ iwu iki ungaa?>> ");
INSERT INTO ldb_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Umbɔ agɛ, <<Iki Ukaisar.>> Mɔcɛ unga agɔr umbɔ agɛ, <<Àka adzowe Ukaisar abinkɛ aka awe aki Ukaisar, ikɛi àka adzowe Unum abinkɛ aka awe aki Unum.>> ");
INSERT INTO ldb_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Umbɔ aka agũ rimi, umbɔ adzeidzeu. Nggee umbɔ abɔre unga na azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ru unum hã abi Usaduki, abika agɔr ugɛ isok ra akpe ishingge, aba ru unga arhusa agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","<<A umarhem, Umusa agɔr agɛ, <Unera aba akpe na ashia ra awɛkaci, awu ufang ungwɛ̃mbɔ apfunu utsɛrh ha amare awɛkaci ru unga.> ");
INSERT INTO ldb_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Umɔ abɔɔ rabɔ awu angwɛ̃yi utɔɔva ru umɛn. Uwu inggbaashia apfuna na akpea, asi imara awɛkaci, abɔruka utsɛrh ha ru ungwɛ̃mbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Rimi hã iki iwe nggu ungwɛ̃mbɔ uwu uvaa nu uwu untaar, uzĩ itsĩ ru uwu utɔɔva. ");
INSERT INTO ldb_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ri imimasha utsɛrh ha akpea. ");
INSERT INTO ldb_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ru unumkpi abika akpe aka isok ra akpe, utsɛrh ha awuri iwu uwu ungaa ru umbɔ utɔɔva ha? Ubinkutsu, kishookambɔ utɔɔva aka apfuna unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Uyesu agɔr umbɔ agɛ, <<Umbi agba irhak, ubinkutsu, umbi asi ihwɛngmbi itsɛng Arherhu-Num use ijee Unum. ");
INSERT INTO ldb_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ri isok ra akpe anera asi ípfunumbɔ, asi ídzowukumbɔ ipfuna. Anera awuri iwe ru nyaka ípfu itser-Num ra afã. ");
INSERT INTO ldb_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bɔr arherhi isisok abika akpukpe, umbi anasi ivarhumbi ubinkpi Unum aka adɛyiwa umbi? ");
INSERT INTO ldb_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Unga agɔr agɛ, <Umum iwu Unum uwu Uibrahim, Unum uwu Uishaku, nu Unum uwu Uyakubu.> Unga asi iwea Unum uwu abika akpukpe bɔr awu Unum uwu abi urhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ivangyɛ ikikɔnga iki igũ rimi, umbɔ adzeidzeu imesanga. ");
INSERT INTO ldb_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Abi Ufarisi aka agũ ugɛ Uyesu aka atsu abi Usaduki awu uku uvep, umbɔ akɔng. ");
INSERT INTO ldb_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Unying ru umbɔ uwuku uhwɛng Ikpem akarhãrhã, avira arhusa unga agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","<<A umarhem, ikpem iyikisong iwu iyiki igɔnga ri Íkpem Umusa?>> ");
INSERT INTO ldb_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Uyesu agɔr unga agɛ, << <Ubemu Uteijee Unumngo nggu amɛnngo kishoo nu ipfungo kishoo nu adzɛnngo kishoo.> ");
INSERT INTO ldb_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ikpem iyɛrɛ ngge iwu iyi inggbaashia nu iyiki igɔnga. ");
INSERT INTO ldb_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nu iyi uvaa iwu ru nyaki iyi unggbaashi ha igɛ, <Ubemu undɔkango ru nyaki itsikamngo.> ");
INSERT INTO ldb_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kishoo Íkpem Umusa nu imesa abika asɔm Arherhu-Num iyurhi nú atsi íkpem iyɛrɛ ikivarhangge.>> ");
INSERT INTO ldb_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ivangyɛ abi Ufarisi aka akɔng ananga unying, Uyesu arhusa umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","<<Ifɛrhkɔ umbi iwu use ri itsi Ukiristo? Unga awu ungwɛ̃ ungamɔ?>> Umbɔ agɛ, <<Ungwɛ̃ Udauda.>> ");
INSERT INTO ldb_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Unga agɔr umbɔ agɛ, <<Awu use utsu Udauda ri ijee Ipfu-Num ayisa unga agɛ, <Uteijee>? Ubinkutsu, unga agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","<< <Uteijee agɔr Uteijeemum agɛ, <<Usei ru ubok ughamum, utsɛku umum iki itsu anggamtsakngo ru andaidakngo.>> > ");
INSERT INTO ldb_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Udauda aba ayisu Ukiristo agɛ, <Uteijee,> awu use utsu Ukiristo awu ungwɛ̃nga?>> ");
INSERT INTO ldb_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Unera asi idɛ̃ɛ̃ adzipuka unga urhɛm. Udzur ru unum hã, asi ikpombɔ unera aka abvui arhusa unga arherhe. ");
INSERT INTO ldb_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Mɔcɛ Uyesu agɔr ikikɔnga nu angwɛ̃ imesanga agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","<<Abika imesuwe Ikpem nggu abi Ufarisi asei nú anang isei Umusa. ");
INSERT INTO ldb_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nggee awu ufang umbi adɔsa umbɔ na akorhe ubɛn ubinkpi umbɔ aka amesuwa umbi. Bɔr àka aneke ikorhe abinkɛ umbɔ iki ikorhe. Umbɔ asi ikorhumbɔ abinkɛ umbɔ iki imesuwe. ");
INSERT INTO ldb_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Umbɔ aka isaka abow abin aka amor atsake nú acɛi anera, bɔr umbɔ nibikambɔ asi ikũ itokmbɔ ayikukumbɔ umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","<<Ubɛn ubinkpi umbɔ aka ikorhe abee anera anyã. Abinkɛ umbɔ aka aboyi nú ashimbɔ nu abokmbɔ awe aki Arherhu-Num, unyã umbɔ aka akorha ake agɔgɔng. Nu arhurhukɛ umbɔ aka asɔr ri ifɛn atorhambɔ, atsu ake adeder. ");
INSERT INTO ldb_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Umbɔ abee anang isei akagɔng ri irhowa nu ra abã ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na agɔm anera aghwe umbɔ ri inang izɛɛ, na agɔm umbɔ ayisa umbɔ agɛ, <Amarhem.> ");
INSERT INTO ldb_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","<<Bɔr umbi, awu ufang umbɔ asi íyisumbɔ umbi <Amarhem,> ubinkutsu, umbi awu ru uwuku umesuwe unying, umbi awu angwɛ̃yi. ");
INSERT INTO ldb_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Àka niba ayisumbi unera ra abĩ agɛ, <Utɛ,> ubinkutsu, umbi awu ru Utɛ unying, unga awu ra afã. ");
INSERT INTO ldb_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Use ayisa umbi agɛ, <Uwuku umesuwe,> ubinkutsu, umbi awu ru uwuku umesuwa umbi unying, Ukiristo ha. ");
INSERT INTO ldb_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Uwuruwi aka uwu ukugɔnga ru umbi, awu ufang unga awu ugãrhãmbi. ");
INSERT INTO ldb_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ubɛn unerwi aka aberi itsinga, awuri irhɛrhuwe ike. Bɔr uwuruwi aka arhɛrhuwe itsinga, awuri ibiberuwe ike. ");
INSERT INTO ldb_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","<<Atorhmbi, abika amesuwe Ikpem nu abi Ufarisi, abi ukpukpeta! Umbi afɔmukumbi angwĩ aka atsĩ ru Iyɛrhe afã ra asu anera. Umbi nibikambi asi itsĩmbi, na akɛnmbi abika abee itsitsĩ. ");
INSERT INTO ldb_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","<<Atorhmbi, abika amesuwe Ikpem nu abi Ufarisi, abi ukpukpeta! Umbi aka isaka azɛ̃rhã ra akau akagɔng nú abĩ azĩmbi ibee uner uwuku udzipa unying. Ivangyɛ umbi aka ikpo unying, umbi atsu unga ada idiki ivaa ananga umbi aka awe abi idzũũ urha. ");
INSERT INTO ldb_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","<<Atorhmbi, abi ibvuta abika adarh anera! Umbi iki igɔr agɛ, <Ubɛn uwuku uyirh Iya-Num, asi iwea ifɛrhɛ. Bɔr ubɛn uwuku uyirh nggu uzinarhi ukpu Iya-Num, awu ufang unga iki ikorhu ubinkpi unga aka ayirh.> ");
INSERT INTO ldb_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Umbi agugge abi ibvuta! Ukpuku usong unang, uzinarhi use Iya-Num iki isare uzinarhi hã? ");
INSERT INTO ldb_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ikɛi umbi aki igɔr agɛ, <Ubɛn uwuku uyirh nggu ubeu Iya-Num, asi iwea ifɛrhɛ. Bɔr ubɛn uwuku uyirh nggu izũwãyɛ umbɔ aka angwɛ̃ nú ubeu ha, awu ufang unga akorhu ubinkpi unga aka ayirh.> ");
INSERT INTO ldb_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Umbi abi ibvuta! Uwukusong anang, izũwã, use ubeu uwuku utsu izũwã isar? ");
INSERT INTO ldb_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nggee, uwuku uyirh nggu ubeu ayirh nggu umgbɔ nu ubɛn ubin uku unu umɔ. ");
INSERT INTO ldb_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nu unga uwuku uyirh nggu Iya-Num, ayirh nggu ike nu unga uwuruwi aka asei umɔ. ");
INSERT INTO ldb_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nu ubɛn uwuku uyirh afã, ayirh anang isei Unum nu uwuku usei nú ake. ");
INSERT INTO ldb_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","<<Atorhmbi, abika amesuwe Ikpem Umusa nu abi Ufarisi, abi ukpukpeta! Umbi aka isaka adzowe izũwã abin akaci, ru nyaka ayerhu udzau akaci. Na akwɛɛrkumbi abin aka amora ri Íkpem Umusa, ru nyaki izharha arherhe idzidzɛrhe, atorh, nu imangmang. Imɛ̃ɛ̃ngge umbi akorha abina akɛrɛ na asi ikwɛɛrkumbi akɔɔ. ");
INSERT INTO ldb_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Umbi abika adarh anera ri ibvuta, umbi aki isaka asɛkmbi amurhu, bɔr angurhũmbi arhakumi! ");
INSERT INTO ldb_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","<<Atorhmbi, abika amesuwe Ikpem nu abi Ufarisi, abi ukpukpeta! Umbi aka isaka asorhe andzing akpɛwa nu atɛ̃rhãzɔu. Bɔr ru unɔrkang atɔk nggu abinkɛ umbi aka akpo ri inggang nu ibemitsi. ");
INSERT INTO ldb_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ungo uner ibvuta, Ufarisi! Ugbaashia usorh unɔrkang ukpɛwa nu itɛ̃rhãzɔu. Ungo uba ukorhungo rimi, awiya awuri iwu atɛtɛn. ");
INSERT INTO ldb_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","<<Atorhmbi, abika amesuwe Ikpem nu abi Ufarisi, abi ukpukpeta! Umbi awe ru nyaka adzakɛ umbɔ iki itsu abĩ aka aterha, aka aze izɛrhe ra awiya, bɔr ru unɔrkang atɔk nggu apfupfu ikom anera nu ubɛn ikpũ arhim. ");
INSERT INTO ldb_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Rimi hã, anera aka isaka anyã umbi awu abika arhurhika ra awiya, bɔr ru unɔrkang umbi awu abi ukpukpeta nu iki ibewe. ");
INSERT INTO ldb_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","<<Atorhmbi, abika amesuwe Ikpem nu abi Ufarisi, abi ukpukpeta! Umbi aka isaka adzin adzak aki abika asɔm Arherhu-Num na agberhe idzam adzak abika arhurhika. ");
INSERT INTO ldb_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Nu umbi aka isaka agɔr agɛ, <Agɛ umɛn iwe ri ivang atokamɛn, umɛn ĩba isi itsĩmɛn ubok ri ifɛr abika asɔm Arherhu-Num.> ");
INSERT INTO ldb_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Rimi hã umbi adekuwe atsimbi ugɛ umbi awu angwɛ̃ abika afɛr abika asɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Àka amasha amɛn aka atãrhã aki atokambi aka atirhi! ");
INSERT INTO ldb_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","<<Umbi íbvui! Umbi angwɛ̃ ighwɛr! Umbi awuri ikorha aguse na adzek ru uvau idzũ urha? ");
INSERT INTO ldb_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nggee umum idene abika asɔm Arherhu-Num nu abi itsoi nu abi imesa aba ru umbi. Abɔɔ umbi awuri ifɛr na anyapuwe, abɔɔ umbi awuri ikwɛr ra abã ifɛn-Nummbi na akɛn umbɔ atsĩrhĩ íteu. ");
INSERT INTO ldb_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nggee awuri itsuke adzirh abika arhurhika kishoo umbɔ aka afɛr ru upfung abvui aba ra atsimbi, udzur ra adzirh Uhabirha uner uwuku urhika uba utsĩ Uzakariya ungwɛ̃ Uberikiya, uwuruwi umbi aka afɛr ra ateu Iya-Num nu ubeu idɛm-Num. ");
INSERT INTO ldb_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Umum indɛyiwa umbi idzidzɛrhe, kishoo akɛrɛ awuri ikorhe nggu aner ivang iyɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","<<Oka Urusharhima, Urusharhima! Ungo ufɛr abika asɔm Arherhu-Num nu utang atarh ra abirabɛ umbɔ aka adene umbɔ aba ru umbi. Idiki isong umum iki ibee ikɔng angwɛ̃mbi ananga unying, ru nyaki inũ iki isaki ikɔng angwɛ̃ngge ra afɛkngge, bɔr umbi akpɛ̃mbi. ");
INSERT INTO ldb_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Unyã ucɛ, aneke iyambi arhanga. ");
INSERT INTO ldb_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Umum idɛyiwa umbi, umbi asi íbvui anyãmbi umum utsɛku umbi aka igɔr agɛ, <Idorh iwe nggu uwuku uba ri itsok Uteijee.> >> ");
INSERT INTO ldb_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Uyesu aka adzek ri Iya-Num azɛ̃rhã azĩã, ri ivang hã angwɛ̃ imesanga aba ru unga, adɛyiwe unga ídzin Iya-Num. ");
INSERT INTO ldb_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Unga agɔr umbɔ agɛ, <<Umbi anyãmbi abin akɛrɛ kishoo? Umum indɛyiwa umbi idzidzɛrhe, utarh unying asi íneke ukpɔ utsorhukpɔ nú udɔka. Ubɛn unying awuri isisipuwe.>> ");
INSERT INTO ldb_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Uyesu aka asei ni Igũ Acucii Uzaitun, angwɛ̃ imesanga ikiyikambɔ aba agɔr unga agɛ, <<Usɔma umɛn, ifɛrhɛ ha iwu ri ivang iyiki isong? Awu use uwu utsar ibibango nu imimaa upfunga?>> ");
INSERT INTO ldb_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Uyesu agɔr umbɔ agɛ, <<Àka arhi, utsur unera arhɛma umbi. ");
INSERT INTO ldb_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Anera arhɛrhɛ awuri iba ri itsokmum, awuri igɔr agɛ, <Umum iwu Ukiristo,> awuri irhɛm anera arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Umbi awuri igũmbi isarhe iwa nu ugbugbewangge, bɔr niba agũmbi iwei. Awu ufang ikpũ abin hã akorhe, bɔr imimaa ina ishingge. ");
INSERT INTO ldb_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Abĩ akɔɔ asok adɛ̃ɛ̃ ifuw nggu abĩ akɔɔ, iyɛrhe iso idɛ̃ɛ̃ ifuw nggu iyɛrhe iyɔɔ. Ukoi uwuri itsu imerh ri inanga irhɛrhɛ. Nu upfunga uwuri izizusa ri inanga irhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kishoo akɛrɛ ha awu ititirhi uver imar. ");
INSERT INTO ldb_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","<<Mɔcɛ umbɔ aka idzowe umbi umbɔ adzaa umbi uver na afɛre umbi. Abĩã kishoo awuri ikpɛ̃ke umbi ri itsimum. ");
INSERT INTO ldb_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ri ivang hã anera arhɛrhɛ imangmangmbɔ iwuri iwe uku ughɛɛng, umbɔ awuri ighadak na akpɛ̃na adɔka. ");
INSERT INTO ldb_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Abika asɔm Arherhu-Num igbɛrangwĩ awuri idzeka na arhɛm anera arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ititoma iyiki ibewe iwuri itsu ibibema anera arhɛrhɛ iwe uku ughɛɛng. ");
INSERT INTO ldb_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bɔr uwuku ubima utsɛku imimasha awuri ikpoa ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Isarhe Iyiki Ize iyɛrɛ iyi Iyɛrhe, awuri idũwã ngge ru upfunga kishoo, ngge iwe ideka ra abĩã kishoo, mɔcɛ imimasha iba. ");
INSERT INTO ldb_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","<<Umbi aba anyãmbi ubin uku utãrhã uku udakuwe anang, ukpurukpi uner uwuku usɔm Arherhu-Num Udaniyɛrh aka arherhe, udɛ̃ɛ̃kpɔ ri Iya-Num, neke uner uwuku uvarhe ahwɛng. ");
INSERT INTO ldb_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Mɔcɛ abirabɛ aka awe ru Uyahudiya atĩ azĩ ri igũ. ");
INSERT INTO ldb_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Uwuruwi aka awu afafã ni itsi uvi niba acipuwanga inyãngu ubin uku uwe ri iya. ");
INSERT INTO ldb_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Uwuruwi aka awe ra arhum niba abvui abanga inyãngu untamanga. ");
INSERT INTO ldb_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Atorhmbi akatsɛrh abika awu ra ana nu abika akpɔm awɛkaci ri ivang hã! ");
INSERT INTO ldb_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Àka afɛn-Num utsur utser ha uwekpɔ ri ivang ighɛnga use unum ukpuku uwosha abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ubinkutsu, umbɔ awuri inyãmbɔ ayetnum akarhãrhã akirakɛ umbɔ aka anasi inyãmbɔ ake udzur ri imimunu upfunga uba utsĩ icɛrɛ. Asi íbvui anyãmbɔ akɔɔ aka anangke aki ha. ");
INSERT INTO ldb_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Agɛ umbɔ asi izharhukũmbɔ inum hã uku ugbim, unera asi íbɛka, bɔr ri itsi abirabɛ umbɔ aka asɛng umbɔ awuri izharhukũmbɔ inum hã. ");
INSERT INTO ldb_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","<<Ri ivang hã unera aba agɔra umbi agɛ, <Àka anyã, Ukiristo uwi!> use <Nggawɔ nggɔɔ!> niba awembi ri imangmang. ");
INSERT INTO ldb_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ubinkutsu akiristo igbɛrangwĩ nu abika asɔm Arherhu-Num igbɛrangwĩ awuri idzekambɔ, umbɔ awuri ikorhumbɔ atsar akagɔng nu abin idzeu arhɛm anera nu abirabɛ Unum aka asɛng, ngge iba idɛ̃ɛ̃ iwengge. ");
INSERT INTO ldb_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Àka anyã, umum iki idɛyiwamum umbi ngge idɔrhi iwe. ");
INSERT INTO ldb_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","<<Nggee unera aba agɔra umbi agɛ, <Unggawɔ ra arhum,> niba adzembi, use agɔr umbi agɛ, <Nggawi ru ubã,> niba awembi ri imangmang. ");
INSERT INTO ldb_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ubinkutsu, ibiba Ungwɛ̃-Ner iwuri iwe ru nyaki irhirhang iki irhange afã kishoo udiki igɔ̃kpee izĩ itsĩ udiku urhɛɛ. ");
INSERT INTO ldb_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Anangkɛ ukom uku uwe, anang hã amgbɛpɛ iki ikɔng. ");
INSERT INTO ldb_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","<<Kanying inum ayetnum hã aki imaa, << <ishaa unum iwuri iwu uzĩ, nu ufɛ̃ usi írhangmgbɔ, nu ídzɛr idzek afafã igba, nu umbɔ awuri izusa abin aka amor aka awu ra afã.> ");
INSERT INTO ldb_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","<<Mɔcɛ utsar ukpu Ungwɛ̃-Ner uku idzeka afafã, nu idũa ru upfunga kishoo awuri ididɔng. Umbɔ awuri inyãmbɔ Ungwɛ̃-Ner aka iba ra amɛɛ nggu ijee nu ikpikpoi akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nu unga awuri idene ípfu itsernga nggu atsom aki irhak ayisa, na awuri ikɔng abirabɛ umbɔ aka asɛng ra anggbokunga anaa, udiku igɔ̃kpee nu udiku urhɛɛ nu unɔr nu ufã, udzur ru ubandzin upfunga udiku ukpɛrɛ uzĩ udiku ukpɔrɔ. ");
INSERT INTO ldb_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","<<Àka amesu ubin ru ucucii uvorhvo, ivangyɛ aboka aka ipfum adzeka na aghwɛr ayerhe aka afa, umbi ahwɛng ugɛ idoi iki iyongge. ");
INSERT INTO ldb_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iwu rimi ikɛi, ivangyɛ umbi aka anyãmbi kishoo abin hã, umbi ahwɛng ugɛ ivanga iki iyongge, idɛ̃ɛ̃ ra angwĩã. ");
INSERT INTO ldb_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Umum indɛyiwa umbi idzidzɛrhe, udan ukpirɛ usi ítɔngkpɔ utsɛku ifɛrhɛ ha kishoo iki ikorhe. ");
INSERT INTO ldb_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Afã nggu abĩ awuri itɔngke, bɔr arherhamum asi ítɔngke. ");
INSERT INTO ldb_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","<<Unera asi ihwɛnga unum hã use ivang hã, ípfu itser-Num ra afã isi ihwɛngngge, Ungwɛ̃-Ner asi ihwɛnga, Utɛ ukpekũ unga ahwɛng. ");
INSERT INTO ldb_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ru nyaku inum Unuhu iki iwe, ngge iwuri iwe rimi ri ibiba Ungwɛ̃-Ner. ");
INSERT INTO ldb_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ri inumyɛ amɛ̃ isok upfung aka awe, anera agha na ahwa, apfuna na adzise ipfuna, utsɛku unumkpi Unuhu aka atsĩ ru ukhukhɔɔ amɛ̃. ");
INSERT INTO ldb_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Umbɔ asi ihwɛngmbɔ utsɛku amɛ̃ aka aba akarha umbɔ. Ngge iwuri iwe rimi hã ru unum ibiba Ungwɛ̃-Ner. ");
INSERT INTO ldb_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Inera ivaa iwe ru usi, awuri inyãnguwe unying na aneke unying. ");
INSERT INTO ldb_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akatsɛrh ivaa awuri idɛ̃ɛ̃ igɔ nu ukɔ igɔ urhɔnga, awuri inyãnguwe unying na aneke unying. ");
INSERT INTO ldb_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","<<Nggee, àka adɛ̃ɛ̃ adzɛu, umbi asi ihwɛngmbi awu unum ukusong Uteijee aka iba. ");
INSERT INTO ldb_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bɔr àka ahwɛng ugɛ uner iya aba ahwɛnga ivangyɛ uvɛu aka iba ru untsuuka, unga awuri isei uku urhi asi íneke umbɔ atsĩ ayarmbɔ iyanga. ");
INSERT INTO ldb_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nggee umbi igambi awu ufang umbi adzɛu, ubinkutsu, Ungwɛ̃-Ner awuri iba ri ivangyɛ umbi aka asi ikaimbi ifɛrhkɔ. ");
INSERT INTO ldb_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","<<Ungamɔ ucɛ, awu ugãrhã uwuku urhurhika nu uwu itsoi, uwuruwi uteiyanga aka atsu unga idzɛu agãrhã iyanga, unga adzise ubinghambɔ uku kpengkpeng ri ivangngge? ");
INSERT INTO ldb_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Anggɔm awe aki ugãrhã hã uteiyanga aka iba anyã unga adɛ̃ɛ̃ itsernga rimi hã. ");
INSERT INTO ldb_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Umum indɛyiwa umbi idzidzɛrhe, awuri itsuke ugãrhã hã arhise abinnga kishoo. ");
INSERT INTO ldb_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bɔr ugãrhã hã aba awu uku ubewe, unga awuri igɔr itsinga agɛ, <Uteiya asi íbanga ifetem.> ");
INSERT INTO ldb_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Mɔcɛ unga atirhi ikwɛr agãrhã abɔrɔ, unga agha na ahwa nggu abi afĩrhã. ");
INSERT INTO ldb_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Uteiya ugãrhã hã aba ru unumkpi unga aka asi itsara. Ri ivangyɛ unga aka asi ihwɛngnga. ");
INSERT INTO ldb_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Uteiya awuri ikwɛr unga iyiki ibewe na agbange unga nggu abi ukpukpeta, umɔ umbɔ aka iciu na atãi anyĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","<<Mɔcɛ Iyɛrhe afã iwuri iwe ru nyaka anakagbĩrhĩ usɔka aka anasi ihwɛngmbɔ ukutsak anyangu írhirhangmbɔ azĩ igbangu utsak uku ufa. ");
INSERT INTO ldb_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Atɔ̃ɔ̃ ru umbɔ awu agugge nu atɔ̃ɔ̃ awu abi itsoi. ");
INSERT INTO ldb_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Agugge ha anyangu írhirhangmbɔ bɔr asi inyangumbɔ atsei. ");
INSERT INTO ldb_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Abi itsoi ha igambɔ anyangu írhirhangmbɔ nggu atsei ra andzoma. ");
INSERT INTO ldb_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Utsak uku ufa ha asi ibanga ifitem, kishoo agbɛu na arhambɔ urhɔ. ");
INSERT INTO ldb_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","<<Ri ikɔtsuuka umbɔ agũ urhɛm ukerketakpɔ uku ugɔr ugɛ, <Utsak uku ufa ha uwi aka abanga! Àka aba agbanga unga!> ");
INSERT INTO ldb_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","<<Mɔcɛ anakagbĩrhĩ usɔka ha asok agbishi írhirhangmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Agugge ha agɔr abi itsoi ha agɛ, <Àka ama adzaa atseimbi ukunjiir, írhirhangmɛn iki iwuri irhim.> ");
INSERT INTO ldb_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","<<Abi itsoi ha agɛ, <Ĩ'ĩ, asi ímɛ̃ke umɛn nggu umbi. Ugba umbi azĩ ru abika agoyiwe atsei agoi akimbi.> ");
INSERT INTO ldb_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","<<Bɔr ivangyɛ umbɔ aka adzek azĩ igoi atsei ha, utsak uku ufa ha atsĩwãnga. Anakagbĩrhĩ aka agbisha abinmbɔ atsĩmbɔ irhowa nggu unga na afɔmukumbɔ angwĩ ubãã. ");
INSERT INTO ldb_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","<<Kata abɔrɔ adɔrha aba agɛ, <A uteiya! A uteiya! Uma utsuruwa angwĩ ubãã!> ");
INSERT INTO ldb_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","<<Bɔr unga agɛ, <Umum indɛyiwa umbi idzidzɛrhe, umum isi ihwɛng umbi.> ");
INSERT INTO ldb_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","<<Nggee, àka adɛ̃ɛ̃ adzɛu, umbi asi ihwɛngmbi unuma use ivanga. ");
INSERT INTO ldb_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","<<Ikɛi, Iyɛrha afã iwuri iwe ru nyaku unera aka izĩ uzãrhã, na ayisa agãrhãnga agashuwe umbɔ uhwɛk. ");
INSERT INTO ldb_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Utsa ha ahwɛnga ubinkpi agãrhãnga aki idɛ̃ɛ̃ akorhe, nggee unga adzowe unying ibɛi uazurhfa itɔ̃ɔ̃, uwu uvaa ikɛi ibɛi uazurhfa ivaa, uwu untaar ibɛi uazurhfa unying. Mɔcɛ unga azĩã uzɛ̃rhãnga. ");
INSERT INTO ldb_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Utsa ha aka ayɛi ibɛi uazurhfa itɔ̃ɔ̃ hã kanying kanying unga akũ azĩ agoyi igoi adzipa nggu uhwɛk ha, akpo ighigha ibɛi uazurhfa itɔ̃ɔ̃. ");
INSERT INTO ldb_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nggee ikɛi, uwu ibɛi uazurhfa ivaa ha, akpo ighigha ibɛi uazurhfa ivaa. ");
INSERT INTO ldb_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bɔr uwu ha aka ayɛi ibɛi uazurhfa unying hã azĩ asim abĩ awɔkuka uhwɛk uteiyanga. ");
INSERT INTO ldb_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","<<Ivanga iki iderngge, uteiya agãrhã hã aba ayisa agãrhãnga umbɔ avarhuwe ubinkpi umbɔ aka akorhe. ");
INSERT INTO ldb_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Uner uwuku uyɛi ibɛi uazurhfa itɔ̃ɔ̃ akũ ibɛi uazurhfa itɔ̃ɔ̃ aba agɛ, <A Uteiya, ungo udzaa umum ibɛi uazurhfa itɔ̃ɔ̃. Unyã, umum ikpo ighigha ibɛi uazurhfa itɔ̃ɔ̃ itoma.> ");
INSERT INTO ldb_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","<<Uteiyanga agɛ, <Ungo udɛ̃ɛ̃, ugãrhã uwuku uze uwu idzidzɛrhe! Ungo uweɔ ri idzidzɛrhe ru ubin uku uci. Umum indzaamum ijee iyiki ikpɔm abina arhɛrhɛ. Uba ugɔmanggɔm nggu uteiyango.> ");
INSERT INTO ldb_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","<<Uner uwuku uyɛi ibɛi uazurhfa ivaa ha ikɛi aba agɛ, <A Uteiya, Ungo udzaa umum ibɛi uazurhfa ivaa. Unyã nggayɛ umum ikpo ighigha ibɛi uazurhfa ivaa itoma.> ");
INSERT INTO ldb_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","<<Uteiyanga agɛ, <Ungo udɛ̃ɛ̃ ugãrhã uwuku uze uwu idzidzɛrhe! Ungo uweɔ ri idzidzɛrhe nggu ubin uku uci. Umum indzaamum ijee iyiki ikpɔm abina arhɛrhɛ. Uba ugɔmanggɔm nggu uteiyango!> ");
INSERT INTO ldb_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","<<Mɔcɛ uner uwuku uyɛi ibɛi uazurhfa unying hã aba agɛ, <A Uteiya, umum ihwɛng amɛnngo aghong ifɛrhɛ. Ungo udɛ̃ɛ̃ ugbugbɛrɔ ra anangkɛ ungo uku usi idosɔ. Ungo udɛ̃ɛ̃ urhɔ̃ĩngo ra anangkɛ ungo uku usi inãngo ikpũ. ");
INSERT INTO ldb_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nggee umum igũ iwei izĩ iwɔke ibɛi uazurhfango ra abĩ. Unyã ibɛi uazurhfango iyɛ.> ");
INSERT INTO ldb_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","<<Uteiyanga agɛ, <Ungo ugãrhũ uwuku ubewe, ughɛrha! Ungo uhwɛngo umum iki isaki ĩgbɛtũ ra anangkɛ umum iki isi idoimum ni irhɔ̃ĩmum ra anangkɛ umum iki isi inãmum ikpũ. ");
INSERT INTO ldb_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Azea mɔcɛ, ugɛ ungo uba utsuke uhwɛka ru ubanki. Ivangyɛ umum iki ibvui iba, umum itsũ ngge nggu ighigha! ");
INSERT INTO ldb_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","<< <Àka ayɛise ibɛi uazurhfa unying hã ru unga, aka atomuwe ru uwɔrɔ uwu ibɛi uazurhfa usɔka. ");
INSERT INTO ldb_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Uwuruwi aka awe ru ihwihwɛng awuri itomuwe unga akpo arhɛrhɛ. Uwuruwi aka ashia, awuri iyɛse ungwɛ̃rhĩ ihwihwɛng ha unga aka awerangge. ");
INSERT INTO ldb_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Na atare ugãrhã ibɛm hã ra awiya ru uzĩ uku ugburhuk. Umɔ umbɔ aki iciu akpe nggu itãi anyĩ.> ");
INSERT INTO ldb_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","<<Ivangyɛ Ungwɛ̃-Ner aka iba ri ikpikpoinga nggu ípfu itsernga kishoo, unga awuri isei nú anang isei iyɛrhe aki ikpikpoi. ");
INSERT INTO ldb_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Awuri ikɔng abi upfung ukpirɛ kishoo ra anangnga, unga awuri igasha umbɔ awuwembɔ ru nyaku uner ughãwã aka igashi ídɔi nggu íbũ. ");
INSERT INTO ldb_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Unga awuri itsu ídɔi ru ubok ugha na atsu íbũ ru ubok uferanga. ");
INSERT INTO ldb_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","<<Mɔcɛ Uyɛrhe awuri igɔr abika awe ru ubok ughanga agɛ, <Àka aba, umbi abi Utɛmum aka atsuka umbi idorh. Àka ayɛi ukamkpi Unum aka igbishuwa umbi udzur ri imimunu upfung. ");
INSERT INTO ldb_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Umum iki igũ imerh, umbi adzaa umum ubingha, umum iki igũ ugɔ̃ amɛ̃, umbi adzaa umum ubin umum ihwa, iwu utsen, umbi ayɛi umum ra ayambi. ");
INSERT INTO ldb_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Umum ishimum ra atorho, umbi adzaa umum atorho, aghonga umum, umbi anɛta umum, iwe ru ugborzĩ, umbi aba ayepa umum.> ");
INSERT INTO ldb_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","<<Mɔcɛ abika arhurhika awuri igɔr agɛ, <A Uteijee, ukang umɛn iki inyã ungo ugũ imerh ni ĩdzaa ungo ubingha, use ungo ugũ ugɔ̃ amɛ̃, umɛn ĩdzaa ungo ubin ungo uhwa? ");
INSERT INTO ldb_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ukang umɛn iki inyã ungo uku uwu utsen ni iyɛi ungo, use ungo ushiɔ ra atorho, umɛn indzaa ungo atorho? ");
INSERT INTO ldb_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ukang ungo uku ughong iyor use ungo uwe ru ugborzĩ umɛn izĩ iyepa ungo?> ");
INSERT INTO ldb_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","<<Mɔcɛ Uyɛrhe awuri igɔr umbɔ agɛ, <Umum indɛyiwa umbi idzidzɛrhe, ubɛn ubinkpi umbi aka akorhuwe unying ra angwɛ̃mɛn use anapumɛn abika asheru ugarh ru umbi, umbi akorhuwa umum.> ");
INSERT INTO ldb_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","<<Mɔcɛ unga awuri igɔr abɔrɔ ru ubok uferanga agɛ, <Àka asombi ru umum umbi abi ikponum. Àka azĩ atsĩ ru urha ukpu ugbagbaa umbɔ aka ataiwe Undenggũ nggu ípfu itsernga. ");
INSERT INTO ldb_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Umum iki igũ imerh, umbi asi idzaambi umum ubingha, umum iki igũ ugɔ̃ amɛ̃, umbi asi idzaambi umum ubin umum ihwa. ");
INSERT INTO ldb_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Iwu utsen, umbi asi iyɛi umum atsĩmbi ri iya, ishimum ra atorho umbi asi idzaambi atorho ru umum, aghonga umum, ikɛi umum iwe ru ugborzĩ, umbi asi iba ayepumbi umum.> ");
INSERT INTO ldb_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","<<Umbɔ ikɛi awuri igɔr agɛ, <A Uteijee, ukang umɛn iki inyã ungo ugũ imerh use ugɔ̃ amɛ̃ use ungo uwu utsen use ungo ushiɔ ra atorho use aghonga ungo use ungo uwe ru ugborzĩ, umɛn isi iyikamɛn ungo?> ");
INSERT INTO ldb_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","<<Unga awuri igɔr agɛ, <Umum indɛyiwa umbi idzidzɛrhe, ubɛn ubinkpi umbi aka asi ikorhukumbi unying ra abɛrɛ aka asheru ugarh, umbi asi ikorhuwambi umum nukpɔ.> ");
INSERT INTO ldb_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","<<Mɔcɛ umbɔ awuri ikpo ayetnum aki ugbagbaa, bɔr abika arhurhika awuri ikpo urhɛ uwu ugbagbaa.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ivangyɛ Uyesu aka amaa irherha abina akɛrɛ ha kishoo, unga agɔr angwɛ̃ imesanga agɛ, ");
INSERT INTO ldb_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","<<Umbi ahwɛngmbi, Irhowa Iyiki Igar Utɔng ibɔr inuma ivaa, umɔ awuri idzowe Ungwɛ̃-Ner umbɔ anyapuwe unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mɔcɛ ateiya abika adzowe idɛm-Num nu akakũ anera akɔng ri iya Ukugɔng Uwuku Udzowe Idɛm-Num, itsoka igburh Ukayafa. ");
INSERT INTO ldb_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Umbɔ avarhe idzur Uyesu ri iwɔk afɛre unga. ");
INSERT INTO ldb_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bɔr umbɔ agɛ, <<Asi íwea ri ivang irhowa, utsur anera asoyimbɔ amɛn.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ivangyɛ Uyesu aka awe ru Ubetani ri iya Usiman uwuruwi ingbimnga iki ikerhe, ");
INSERT INTO ldb_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","utsɛrh uwɔɔ aba ru Uyesu nggu undzoma utarh uku utɔk nggu atsei isung aki imang akarhãrhã. Unga awupuwe atsei ha ri itsinga ri ivangyɛ unga aka asei nu anang ubingha. ");
INSERT INTO ldb_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ivang angwɛ̃ imesanga aka anyã rimi, umbɔ agũ avɔm na arhusa adɔkambɔ agɛ, <<Akɛrɛ awu inyar! ");
INSERT INTO ldb_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Imɛ̃ɛ̃ngge umbɔ agoshe atsei isung hã ru uhwɛk urhɛrhɛ na adzowe atsũwã.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Uyesu agɔr umbɔ agɛ, <<Awu use utsu umbi ayɔm utsɛrh ha? Unga akorhuwa umum ubin uku uze. ");
INSERT INTO ldb_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Atsũwã awu nggu umbi ubɛn ivang, bɔr umum isi íwemum nggu umbi ubɛn ivang. ");
INSERT INTO ldb_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Atseikɛ unga awupuwa umum, unga agbishuwa iyormum umbɔ aka idzake. ");
INSERT INTO ldb_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Umum indɛyiwa umbi idzidzɛrhe, kishoo anangkɛ umbɔ aka idzowe Isarhe Iyiki Ize iyɛrɛ ru upfunga, umbɔ awuri isɔmmbɔ ubinkpi utsɛrh uwurɛ aka akorhe ri ayita unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mɔcɛ unying ru umbɔ usɔkdũmɛn hã itsoknga igburh Uyahuda Uiskariyoti, azĩ ra ateiya abika adzowe idɛm-Num, ");
INSERT INTO ldb_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","arhusa agɛ, <<Umbi awuri idzaa umum use umum ĩba ĩdzaamum unga ru umbi?>> Nggee umbɔ avarhuwe unga íshaa imang uazurhfa isɔka itaar. ");
INSERT INTO ldb_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Udzur ri ivang hã Uyahuda abee udĩkpi unga aka ighadak Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ru unum inggbaashia ukpu Irhowu Uborodi ukpuku Usheru Uguga, angwɛ̃ imesa aba ru Uyesu arhusa unga agɛ, <<Ra anang akasong ungo uku ubee umɛn igbishuwa ungo ugha Irhowa Iyiki Igar Utɔng?>> ");
INSERT INTO ldb_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Unga agɛ, <<Àka atsĩ ru utepa, àka azĩ ru utsa uwɔɔ, àka agɔr unga agɛ, <Umarhem agɛ, ivangmum iki iyongge. Umum igha Irhowa Iyiki Igar Utɔng ri iyango nggu angwɛ̃ imesamum.> >> ");
INSERT INTO ldb_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nggee angwɛ̃ imesanga akorhu ubinkpi Uyesu aka agɔr umbɔ na akorhuwe ubingha Irhowa Iyiki Igar Utɔng. ");
INSERT INTO ldb_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Urhɛɛ uku uwe, Uyesu asei igha ubingha nggu angwɛ̃ imesanga usɔkdũmɛn. ");
INSERT INTO ldb_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Asei ighigha ha nukpi, unga agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, unying ru umbi awuri ighaa adakmum.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Amɛnmbɔ aghong akarhãrhã na atirhi irhusa unga anyinganying agɛ, <<A Uteijee, awu umum?>> ");
INSERT INTO ldb_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Uyesu agɛ, <<Uwuruwi aka atsĩ ubok ri itɛ̃rhĩ nggu umum, unga awuri ighaa adakmum. ");
INSERT INTO ldb_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ungwɛ̃-Ner awuri ikpe ru nyaka umbɔ aka atsɛng ri itsinga. Bɔr atorh uner ha aka ighadak Ungwɛ̃-Ner! Ugba umbɔ asi imarmbɔ unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Mɔcɛ Uyahuda, uwuruwi aka igha adaknga agɛ, <<A umarhem, awu umum?>> Uyesu agɛ, <<Awu ungo urherhe.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Umbɔ ana asei ighigha ha, Uyesu anyangu uborodi, atar uwɛɛ na atsɔka ukpɔ. Adzowe angwɛ̃ imesanga agɛ, <<Àka ayɛi, atãi. Uwɛrɛ awu iyormum.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mɔcɛ unga anyangu ukpɛwa, atar uwɛɛ, na adzowe ru umbɔ, agɛ, <<Àka ahwa ru umgbɔ kishookambi. ");
INSERT INTO ldb_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Akɛrɛ awu adzirhmum aki ibibemuwe-Num, akirakɛ aka adzek awupa ra anera arhɛrhɛ, atsũwe arhimmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Umum indɛyiwa umbi, umum isi íbvui ihwamum amɛ̃ ikpũrhã inebi akɛrɛ utsɛku unumkpi umum iki ihwa aka afa nggu umbi ri Iyɛrhe Utɛmum.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Umbɔ aka amaa itsũwe ubom ru Unum, umbɔ adzek azĩmbɔ Igũ Acucii Uzaitun. ");
INSERT INTO ldb_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mɔcɛ Uyesu agɔr umbɔ agɛ, <<Ru untsuu akpirɛ umbi kishoo awuri itĩ ri itsi ubinkpi uku ikorhe nggu umum. Itsɛng Arherhu-Num igɔr igɛ, << <Umum iwuri ikwɛr uner ughãwãã, nu ukpui ídɔi ha iwuri isita.> ");
INSERT INTO ldb_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bɔr ivangyɛ umum iki isok ra akpe, umum inggbaashia izĩ Ugarhirhi ru umbi adɔrha atsĩ umɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ubitru agɛ, <<Kishoo aba atĩmbɔ ri itsi ubinkpi uku ikorhe nggu ungo, umum isi ítĩmum.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Uyesu agɔr unga agɛ, <<Umum indɛyiwa ungo idzidzɛrhe, ru untsuu akpirɛ, ungo uwuri itsɛyingo ihwɛng umum idiki itaar ri ikɔ idɔrhi igbɛr ukpee.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ubitru agɔr unga agɛ, <<Uko umbɔ awuri ifɛre umum nggu ungo, umum isi ítsɛyimum ihwɛng ungo.>> Rimi hã angwɛ̃ imesa abɔɔ kishoo aka arherhe. ");
INSERT INTO ldb_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mɔcɛ Uyesu nu angwɛ̃ imesanga azĩmbɔ anang akɔɔ umbɔ iki iyisa Ugetsemani. Unga agɔr umbɔ agɛ, <<Àka asei nggimi, umum izĩ ifɛn-Num nggɔɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Unga akũ nggu Ubitru nu angwɛ̃ Uzabadi avaa, unga atirhunga igũ idamɛn nu ighongamɛn. ");
INSERT INTO ldb_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Unga agɔr umbɔ agɛ, <<Igũ ighongyɛ iki iwe ra amɛnmum idɛ̃ɛ̃ ifɛrngge umum. Àka asei nggimi na adzɛu nggu umum.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Unga aka agɔpa azĩ ukunjiir unga agba akwɛr anaanga atsim nú abĩ afɛn-Num agɛ, <<A Utɛmum, ngge iba imɛ̃ngge, ungo unyanguwe ukpɛwa ayetnum akɛrɛ ru umum. Bɔr ukorhu ubinkpi ungo uku ubee, asi iwea ubinkpi umum iki ibee.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mɔcɛ unga abvui aba ra angwɛ̃ imesanga, akpo umbɔ aka arhambɔ urhɔ. Unga agɔr Ubitru agɛ, <<A Ubitru, umbi asi idɛ̃ɛ̃ adzɛumbi nggu umum ukara unying? ");
INSERT INTO ldb_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Àka adzɛu na afɛn-Num utsur umbi agbambi ru undeya. Idzidzɛrhe ipfu ibemungge, bɔr iyor isi ikerngge.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Unga abvui azĩã ifɛn-Num idevaa agɛ, <<A Utɛmum, uba ayetnum akɛrɛ asi ítɔngke utsɛku umum iki ihwa ake, umum ikorhumum ubinkpi ungo uku ubee.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Unga abvui aba akpo umbɔ ikɛi awe ru urhɔ, umbɔ asi idɛ̃ɛ̃ ayangumbɔ asumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nggee unga abɔre umbɔ na azĩã ifɛn-Num ide untaar, abvui arherhe ubinkpi unga aka arherhe ri inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Mɔcɛ unga abvui aba ra angwɛ̃ imesa ha agɔr umbɔ agɛ, <<Utsɛku icɛrɛ umbi ana awu ru urhɔ na adɛ̃ɛ̃ iwosha? Àka anyã, ivanga iki iyongge umbɔ aka idzowe Ungwɛ̃-Ner ru abok abi arhim. ");
INSERT INTO ldb_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Àka asisok umɛn izĩmɛn! Uwuku ugha adakmum uwi aka abanga!>> ");
INSERT INTO ldb_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Unga ana awu ra arherhe, Uyahuda, unying ru umbɔ usɔkdũmɛn hã, aba atsĩ. Unga aba nggu anera arhɛrhɛ aka akpɔm nggu akon aka ader nu ígbong. Ateiya abika adzowe idɛm-Num nu akakũ anera aka adene umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Umɔ uwuku ughadaknga hã aka asɔmuka umbɔ utsara agɛ, <<Uwuruwi umum iki ishor atamnga, awu uner ha nuwɔ umbi aka idzur.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Uyahuda aka aba, unga akpurha azĩ ru Uyesu agɛ, <<A umarhem, umum ighwe ungo!>> Na ashor atamnga. ");
INSERT INTO ldb_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Uyesu agɔr unga agɛ, <<A uwee, ukorhu ubinkpi uku ukũna ungo uba.>> Mɔcɛ anera aba, adzur Uyesu akpɔm unga. ");
INSERT INTO ldb_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Unying ra angwɛ̃ imesa Uyesu agbiir ikon iki idernga, agbɛr uto ugãrhũ Ukugɔng Uwuku Udzowe Idɛm-Num, azharhuwe. ");
INSERT INTO ldb_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Uyesu agɔr unga agɛ, <<Utsuke ikon iki iderngo ru udapa. Ubɛn uwuku ugbiir ikon iki ider, awu ikon iki ider ifɛr unga. ");
INSERT INTO ldb_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Umbi akaifɛrhkɔ ugɛ umum ishimum ri ijeea umum iki iyisu Utɛmum kanying unga adene ípfu itser-Num anakagɔnga? ");
INSERT INTO ldb_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bɔr itsɛng Arherhu-Num iki igɔr ugɛ awu ufang akɛrɛ ha akorhe, iwuri ikorhe igusengge ni itsuifɛr?>> ");
INSERT INTO ldb_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mɔcɛ Uyesu agɔr ikikɔng anera agɛ, <<Umum iwu uner uwuku uvui abin anera ri iker, umbi aka idzeka nggu akon aka ader nu ígbong adzur umum? Ubɛn unum umum isei ru ufɔm Iya-Num imesuwe imesa, umbi asi idzurmbi umum. ");
INSERT INTO ldb_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bɔr kishoo akɛrɛ akorhe ngge itsuifɛr abinkɛ aka atsɛng ra abvur abika asɔm Arherhu-Num.>> Mɔcɛ angwɛ̃ imesanga kishoo atĩ abɔrukumbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Abika adzur Uyesu akũna unga azĩ ru Ukayafa, Ukugɔng Uwuku Udzowe Idɛm-Num, anangkɛ abika amesuwe Ikpem nu akakũ anera aka akɔng. ");
INSERT INTO ldb_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bɔr Ubitru adɔsa unga ukuka, utsɛku umbɔ aka azĩ atsĩ ru ufɔm iya Ukugɔng Uwuku Udzowe Idɛm-Num. Unga atsĩ asei nggu abi idzɛu ha abee inyã imimasha ubinkpi umbɔ aka ikorhe. ");
INSERT INTO ldb_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ateiya abika adzowe idɛm-Num nu abi udzepurhe kishoo abee igbɛrangwĩyɛ umbɔ aka itsuke Uyesu na akpo udĩ ukpuku ufɛre unga. ");
INSERT INTO ldb_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Anera arhɛrhɛ aka adzeka, agbɛyangwĩ atsuke unga, bɔr umbɔ asi ikpombɔ udĩ ukpuku ufɛr unga. Ri imimaa, anera avaa adzeka, ");
INSERT INTO ldb_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","agɛ, <<Utsak uwurɛ agɔr agɛ, <Umum idɛ̃ɛ̃ ibupukũ Iya-Num, ni ibvui idzine ri inuma itaar.> >> ");
INSERT INTO ldb_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mɔcɛ, Ukugɔng Uwuku Udzowe Idɛm-Num asok agɔr Uyesu agɛ, <<Ungo usi ídzipungo arherhe? Awu use aner abɛrɛ aka arherha atsuka ungo?>> ");
INSERT INTO ldb_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bɔr Uyesu awu uku uvep. Ukugɔng Uwuku Udzowe Idɛm-Num agɔr unga agɛ, <<Umum itsu ungo nggu uyirh ri itsok Unum uwu urhɛ, usɔma umɛn, awu ungo uwu Ukiristo Ungwɛ̃ Unum?>> ");
INSERT INTO ldb_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Uyesu agɔr unga agɛ, <<Awu ungo urherhe. Bɔr umum isɔma umbi kishoo, utirhi ucɛrɛ umbi awuri inyãmbi Ungwɛ̃-Ner aka isei ru ubok ugha Nggaa Unum na awuri iba ra amɛɛ afafã.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Mɔcɛ Ukugɔng Uwuku Udzowe Idɛm-Num hã avapuwe atorhanga na agɛ, <<Unga aka arhenu Unum! Awu use umɛn iki ibee ikɛi? Àka anyã, icɛrɛ umbi aka agũmbi unga aka arhenu Unum. ");
INSERT INTO ldb_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Umbi anyã aguse?>> Umbɔ agɛ, <<Imɛ̃ngge umbɔ afɛre unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mɔcɛ umbɔ atang aci atsuyiwe ru asunga na akũ ikpoi akwɛr unga. Abɔɔ akwɛre unga inkpai, ");
INSERT INTO ldb_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na agɛ, <<A Ukiristo! Udɛyiwa umɛn, uwukusong akwɛr ungo ikpoi?>> ");
INSERT INTO ldb_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ri ivang hã Ubitru asei ru ufɔm iya ha, nu una igãrhã aba ru unga agɔr unga agɛ, <<Ungo uwu nggu Uyesu uner Ugarhirhi uwurɛ!>> ");
INSERT INTO ldb_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bɔr Ubitru atsɛyinga ra anangmbɔ kishoo agɛ, <<Umum isi ihwɛng ubinkpi ungo uku urherhe!>> ");
INSERT INTO ldb_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Mɔcɛ unga adzek azĩã ru angwĩ ufɔma, umɔ una uwɔɔ aka anyã unga, agɔr abika adɛ̃ɛ̃ umɔ agɛ, <<Utsak uwurɛ awu nggu Uyesu uner Unazarat!>> ");
INSERT INTO ldb_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ubitru atsɛyi ikɛi nggu uyirh agɛ, <<Umum isi ihwɛng utsa ha.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Adãrhã ukunjiir, abirabɛ aka adɛ̃ɛ̃ umɔ aba agɔr Ubitru agɛ, <<Idzidzɛrhe ungo uwu unying ru umbɔ, ikpũ arherhango ake akũ ungo adzeka.>> ");
INSERT INTO ldb_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Mɔcɛ unga ayirh agɛ, <<Ikponum ru umum, umum inba ihwɛng utsak uwurɛ!>> Kanying ikɔ igbɛrkpee. ");
INSERT INTO ldb_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mɔcɛ Ubitru aka ayita arherhe Uyesu aka arherhe nggu unga agɛ, <<Ungo uwuri itsɛyingo ihwɛng umum idikunga itaar, nu ikɔ idɔrhi igbɛrkpee.>> Ubitru adzek aciu akpe akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ri igɔ̃ ukpeeka, kishoo ateiya abika adzowe idɛm-Num nu akakũ anera akɛki itsũwã iyiki ifɛr Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Umbɔ abow unga, akũna unga azĩ adzowe unga ru Ubirhatu, ugomna. ");
INSERT INTO ldb_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ivangyɛ Uyahuda, uwuku ughadaknga, aka anyã umbɔ aka atsu Uyesu ufai akpe, unga agɔr ra amɛnnga agɛ, <<Uhwɛngrimi.>> Unga abvui aba ra ateiya abika adzowe idɛm-Num nu akakũ aner ha. Abvui adzowuka íshaa imang uazurhfa isɔka itaar ha. ");
INSERT INTO ldb_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Agɛ, <<Umum iwu ra arhim, ubinkutsu, umum iki ighadak adzirh uwuku usheru uvau.>> Bɔr umbɔ agɔr unga agɛ, <<Akɛrɛ awu use ru umɛn? Umei imesungo.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nggee Uyahuda atare uhwɛk uazurhfa ha ru Iya-Num na adzek azĩã. Mɔcɛ unga azĩ ayapuwe itsikamnga. ");
INSERT INTO ldb_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Bɔr ateiya abika adzowe idɛm-Num akarhu uhwɛka na agɛ, <<Ri ikpem isi imɛ̃ngge umbɔ atsuke uhwɛk ha ru uhwɛk Iya-Num, uwu ukpu adzirh.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nggee umbɔ akɛka na akũ uhwɛka agoi idɛɛ iyɔɔ, ayisi idɛɛ ha agɛ idɛɛ uner uwuku udzin anui. Anang akika adzake ikom atsen. ");
INSERT INTO ldb_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ngge itsu umbɔ ayisi idɛɛ ha ugɛ Idɛɛ Adzirh utsɛku irherɛ. ");
INSERT INTO ldb_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mɔcɛ ubinkpi uwuku usɔm Arherhu-Num Uirimiya aka arherhe utsu ufɛrkpɔ ugɛ, <<Umbɔ anyangu íshaa imang uazurhfa isɔka itaar, uhwɛk ha aner Uisrairha aka abema umbɔ afai ri itsinga nukpɔ, ");
INSERT INTO ldb_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","umbɔ akũ ngge agoi idɛɛ uner uwuku udzin anui ru nyaku Uteijee aka atsuka umum.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Uyesu adɛ̃ɛ̃ ra asu ugomna nukpi, ugomna arhusa unga agɛ, <<Ungo uwu uyɛrhe abi Uyahuda?>> Uyesu agɔr unga agɛ, <<Awu ungo urherhe.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bɔr ateiya abika adzowe idɛm-Num nu akakũ anera atsuke unga uvau, unga asi idzipunga urhɛm. ");
INSERT INTO ldb_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mɔcɛ Ubirhatu arhusa unga agɛ, <<Ungo usi igũo abin avaukɛ umbɔ aka atsuka ungo?>> ");
INSERT INTO ldb_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bɔr Uyesu asi idzipuka urhɛm ru arherhanga, utsɛku ugomna aka adzeidzeu akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Umɔ awu ugau ugomna ri Irhowa Iyiki Igar Utɔng, unga atsũwe uner uvau unying uwuruwi umbɔ aka asɛng. ");
INSERT INTO ldb_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ri ivang hã umbɔ awu ru ugbau unera, anera kishoo ahwɛngmbɔ unga, itsoka igburh Ubaraba ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nggee ivangyɛ anera aka akɔng, Ubirhatu arhusa umbɔ agɛ, <<Umbi abee umum itsũwã umbi ungamɔ, Ubaraba use Uyesu umbɔ iki iyisa Ukiristo?>> ");
INSERT INTO ldb_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Unga ahwɛnga awu unyɛ̃ɛ̃ utsu umbɔ adzowe Uyesu ru unga. ");
INSERT INTO ldb_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ubirhatu aka asei ra anang isei aka avarha arherhanga, utsɛ̃nga adene umbɔ adɛyiwe unga agɛ, <<Utsũ ubokngo ra arherhe utsak ha ashia ru uvau, ngge itsu umum igũ uver akarhãrhã irherɛ ru urhɔmum iki irhei ri itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bɔr ateiya abika adzowe idɛm-Num nu akakũ atsu anera agɔr agɛ atsũwe Ubaraba na afɛre Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ugomna iganga abvui arhusa umbɔ agɛ, <<Uwuku usong ru umbɔ ikivarhambɔ umbi aka abee umum itsũwã?>> Umbɔ agɛ, <<Ubaraba.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ubirhatu arhusa umbɔ agɛ, <<Umum ikorhi iguse nggu Uyesu umbɔ iki iyisa Ukiristo?>> Kishookambɔ agɛ, <<Unyapuwe unga!>> ");
INSERT INTO ldb_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ubirhatu arhusa umbɔ agɛ, <<Awu use utsu? Unga akorhu use iyiki ibewe?>> Bɔr anera abvui atsarhi irhakmbɔ agɛ, <<Unyapuwe unga!>> ");
INSERT INTO ldb_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ivangyɛ Ubirhatu aka anyã unga asi idɛ̃ɛ̃ akorhunga ubin, ikɛi anera agbisha abee isoyi amɛn, unga anyangu amɛ̃ asorh aboknga ra asu anera. Agɛ, <<Umum amɛ̃mum ashike ra adzirh utsak uwurɛ, akɛrɛ awu ra abokmbi!>> ");
INSERT INTO ldb_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Anera kishoo agɛ, <<Adzirhnga awe ru urhɔkmɛn nggu angwɛ̃mɛn!>> ");
INSERT INTO ldb_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mɔcɛ unga atsũwũka Ubaraba ru umbɔ. Unga atsu abi iwa akwɛre ugwɛɛ ru Uyesu, na adzowuka umbɔ anyapuwe unga. ");
INSERT INTO ldb_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mɔcɛ abi iwa ugomna akũ Uyesu azĩmbɔ ru udzepurhe ugomna, akɔng kishoo abi iwa adziira unga. ");
INSERT INTO ldb_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Atsimuwe atorhanga na atsĩme atorho aka abãrhã akagɔng. ");
INSERT INTO ldb_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Atsɛrhi ifur iyɛrhe iyi ídidɔk atsime ni itsinga. Atsu unga akpɔm igbong ru ubok ughanga na atangarhu ra anangnga. Ayɛɛia unga agɛ, <<Urhɛngo uder Uyɛrhe abi Uyahuda!>> ");
INSERT INTO ldb_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ashau aci atsuyiwe unga, ayɛi ugam akwɛr ni itsinga ikɛi. ");
INSERT INTO ldb_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Umbɔ aka ayɛɛi unga amaa, umbɔ atsimuwe atorho aka abãrhã hã na atsĩme atorhanga. Mɔcɛ umbɔ akũna unga azĩmbɔ inyapuwe unga. ");
INSERT INTO ldb_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Umbɔ aka adzek, umbɔ agbopu utsak Usayirin uwɔɔ, itsoka igburh Usiman. Umbɔ atsu unga atsã igãrhãmau ucucii ha. ");
INSERT INTO ldb_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Umbɔ azĩ atsĩ anangkɛ umbɔ aki iyisa Ugorhgota, agbena agburh <<Anang Apfupfu Aghow Itsi.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Umɔ umbɔ adzowe Uyesu amɛ̃ inebi uku ukpere ugɛ unga ahwa, bɔr unga aka abanga agũ, unga akpɛ̃ɛ̃ ihwihwaa. ");
INSERT INTO ldb_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ivangyɛ umbɔ aka anyapuwe unga, umbɔ atang isɛng agasha atorhanga. ");
INSERT INTO ldb_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mɔcɛ umbɔ asei umɔ adzɛu unga. ");
INSERT INTO ldb_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ra afafã igãrhãmau ucucii ha ukhapa ri itsinga, umbɔ atsɛng isarhe uvaunga agɛ, <<UWƐRƐ AWU UYESU, UYƐRHE ABI UYAHUDA.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Anyapuwe avɛu avaa nggu unga, unying ru ubok ughanga uwu uvaa ru ubok uferanga. ");
INSERT INTO ldb_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Anera aka atɔng, arhena unga azung atsimbɔ, ");
INSERT INTO ldb_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","agɛ, <<Ĩhĩĩ! Ungo iki isipuwe Iya-Num, nu udzine ike ikɛi ri inuma itaar, ucipuwa nu igãrhãmau ucuciia ha ufɔrh itsingo, ungo uba uwu Ungwɛ̃ Unum!>> ");
INSERT INTO ldb_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Rimi hã ikɛi ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem nu akakũ anera ayɛɛia unga. ");
INSERT INTO ldb_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Agɛ, <<Unga afɔrhe abɔɔ, bɔr asi idɛ̃ɛ̃ afɔrha itsinga! Unga aba awu Uyɛrhe Uisrairha, unga acipuwa icɛrɛ ru igãrhãmau ucucii ha, nu umɛn iwe ru imangmang ru unga. ");
INSERT INTO ldb_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Unga awe ru imangmang ru Unum. Uneke Unum afɔrhe unga icɛrɛ, unga aba abeenga. Unga agɛ, <Umum iwu Ungwɛ̃ Unum.> >> ");
INSERT INTO ldb_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Rimi hã avɛu ha umbɔ aka anyapuwe nggu unga arherhuwe unga arherhe aka atãrhã. ");
INSERT INTO ldb_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Utirhi ri idzingga atenuma, uzĩ utsirkpɔ abĩã kishoo utsɛku akara ataar aki urhɛɛ. ");
INSERT INTO ldb_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ru akara ataar ikɛi Uyesu atsarhi irhaknga ikerketangge agɛ, <<Erhoi, Erhoi, urhama sabaktani?>> agbena agburh, <<A Unummum, a Unummum, awu use utsu ungo uneka umum?>> ");
INSERT INTO ldb_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Abika adɛ̃ɛ̃ umɔ aka agũ rimi, umbɔ agɛ, <<Unga adɛ̃ɛ̃ iyisu uner uwuku usɔm Arherhu-Num Uirhiya.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kanying uwɔɔ atĩ azĩ anyangu usoso. Abii ra amɛ̃ inebi akika agbata, avaki igbong, adzowe Uyesu ugɛ unga ayam. ");
INSERT INTO ldb_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bɔr abɔɔ agɛ, <<Àka aneke unga, umɛn inyãni use Uirhiya awuri afɔrhuka unga.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mɔcɛ Uyesu aka abvui atsarhi irhaknga ikerketangge atsu ivum, na atsũwũka ipfunga. ");
INSERT INTO ldb_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ru ivang hã urhaburhe ukpu Iya-Num uvaar akpɛrha avaa udzur ri itsia uba utsĩ abĩã. Abĩ azusa, ífa iyata. ");
INSERT INTO ldb_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Adzak ayar atsuri, ayor asarkasar anera arhɛrhɛ abika akpe asok nggu urhɛ, ");
INSERT INTO ldb_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","umbɔ adzeka ra adzakmbɔ. Ivangyɛ Uyesu aka asok ra akpe, abika akpe ha atsĩmbɔ asarkasar uteu Urusharhima, anera arhɛrhɛ aka anyã umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ri ivang hã uteiya abi iwa Uroma nu abɔɔ abika adɛ̃ɛ̃ adzɛu Uyesu anyã izizusa abĩ nu ikɛi abinkɛ aka akorhe, umbɔ agũ iwei akarhãrhã, na agɛ, <<Idzidzɛrhe uwɛrɛ ha awu Ungwɛ̃ Unum!>> ");
INSERT INTO ldb_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Akatsɛrh arhɛrhɛ aka awe umɔ, adɛ̃ɛ̃ ukuka na azɛrhe ubinkpi uku ukorhe. Umbɔ adzeku Ugarhirhi adɔsu Uyesu akorhuwe unga ubinkpi unga aka abee. ");
INSERT INTO ldb_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ru umbɔ awu umbɔ Umaryamu Umagadarha, nu Umaryamu uyisa Uyaku nu Uyusuf, angwɛ̃ Uzabadi. ");
INSERT INTO ldb_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Urhɛɛ uku uyo, uner ubin uwɔɔ, utsa Uarimatiya aba umɔ, itsoknga igburh Uyusuf. Unga awu ungwɛ̃ imesu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Azĩ ru Ubirhatu, ashɔ̃rhã unga adzowe ukom Uyesu. Ubirhatu atsu umbɔ adzowe ukoma ru unga. ");
INSERT INTO ldb_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Uyusuf ashupu ukom hã, akũ atorho aka afa abɛrh, ");
INSERT INTO ldb_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","atsuke ukpɔ ru udzak uku ufa ukpurukpi unga aka atsɛ̃ ri ifɛn utarh. Unga agɔ̃rhũ nggaa utarh afɔme angwĩ udzaka na azĩã. ");
INSERT INTO ldb_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Umaryamu Umagadarha nu Umaryamu uwɔɔ asei akhapa umɔ ra angwĩ udzak ha. ");
INSERT INTO ldb_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ukpe unum uvaa, unum ukpuku ugbisha abin uku utɔng, ateiya abika adzowe idɛm-Num nu abi Ufarisi akɔng ra anang Ubirhatu, ");
INSERT INTO ldb_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","agɛ, <<A Uteiya! Umɛn iyitumɛn ubinkpi uner uwuku urhɛm aner ha aka arherhe, unga aka ana awe nggu urhɛ, unga agɛ, <Inuma itaar iba iwengge umum iwuri isokũ ra akpe.> ");
INSERT INTO ldb_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ngge itsu umbɔ adzɛu udzak ha utsɛku inuma itaar, utsur angwɛ̃ imesanga azĩ avɛu ukomnga na agɔr anera ugɛ unga aka asoka ra akpe. Irhirhɛm iyi imaataka iwuri ibewe inangngge iyi inggbaashia.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ubirhatu agɔr umbɔ agɛ, <<Àka akarha abi iwa azĩ adzɛu kishoo ri ikermbi.>> ");
INSERT INTO ldb_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nggee umbɔ azĩ avinu udzak ha, akwɛr utsar iyɛrhe nú utarh udzak ha, atsu abi iwa adzɛu anang hã. ");
INSERT INTO ldb_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Unum ukpuku Uwosha uku utɔng, ru unkpeka unum ukpu inggbaashia ru inuma utɔɔva, Umaryamu Umagadarha nu Umaryamu uwɔrɔ azĩmbɔ iyepu udzak ha. ");
INSERT INTO ldb_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Umɔ nggaa izizusa abĩ iki izusa, ipfu itser Uteijee idzeka afã, izĩngge ru udzak ha, igɔ̃rhuwe utarh ha umbɔ aka atsĩme udzak ha, isei nú ukpɔ. ");
INSERT INTO ldb_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Idzidzeka ngge irhang ru nyaki inai iki inyaka, atorha ake awu uku upɛ̃rhɛng ugɛɛ aghwitu urhurhu. ");
INSERT INTO ldb_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Abi idzɛu aka anyã ngge, iwei ifɛr umbɔ, azang ayormbɔ agbei ra abĩ ugɛɛ ikom. ");
INSERT INTO ldb_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Bɔr ipfu itser-Num hã igɔr akatsɛrh ha igɛ, <<Àka niba agũmbi iwei, umum ihwɛng umbi abee Uyesu uwuruwi umbɔ aka anyapuwe. ");
INSERT INTO ldb_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Unga ashia nggimi, unga aka asoka, ru nyaka unga aka arherhe. Àka aba anyã anangkɛ unga aka anu. ");
INSERT INTO ldb_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mɔcɛ àka azĩ ifetem azĩ asɔme angwɛ̃ imesanga ugɛ, <Unga aka asoka ra akpe, nggawɔ agbaashia azĩ Ugarhirhi ru umbi. Nggɔɔ ha umbi awuri inyãmbi unga.> Àka agũ, umum iki idɛyiwamum umbi.>> ");
INSERT INTO ldb_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Nggee akatsɛrh ha iki ifefetem asokmbɔ ru udzaka, agũ iwei nggu anggɔm, atĩ azĩ idɛyiwe angwɛ̃ imesanga. ");
INSERT INTO ldb_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kanying Uyesu agbopa umbɔ. Agɔr umbɔ agɛ. <<Ighwe umbi!>> Umbɔ agɔpa aba awuma adaknga, adzowe unga igɔng. ");
INSERT INTO ldb_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Mɔcɛ Uyesu agɔr umbɔ agɛ, <<Àka niba agũmbi iwei. Àka azĩ asɔme angwɛ̃mɛn umbɔ azĩ Ugarhirhi. Nggɔɔ ha umbɔ aka inyã umum.>> ");
INSERT INTO ldb_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Akatsɛrh ha awe ru uzɛ̃rhã, abɔɔ abi idzɛu udzak ha atsĩmbɔ utepa, asɔme ateiya abika adzowe idɛm-Num kishoo ubinkpi uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ivangyɛ ateiya abika adzowe idɛm-Num nu akakũ anera akɔng akɛki itsũwã, umbɔ adzowe abi iwa ha uhwɛk urhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Agɔr umbɔ agɛ, <<Àka agɔr agɛ, <Angwɛ̃ imesanga aba avɛu ukomnga ru untsuuka, ri ivangyɛ umbi aka awe ru urhɔ.> ");
INSERT INTO ldb_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Arherha akɛrɛ aba atsĩke ra ato ugomna, umɛn iwuri irherhumɛn arherhe nggu unga, umbi asi íhwambi uver.>> ");
INSERT INTO ldb_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Nggee abi iwa ha ayɛi uhwɛka na akorhe ru nyaka umbɔ aka agɔr umbɔ akorhe. Nu arherhe akɛrɛ atɛ̃rhã amaake abi Uyahuda aba atsĩ irherɛ. ");
INSERT INTO ldb_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Mɔcɛ angwɛ̃ imesa ha usɔka nu unying hã azĩmbɔ Ugarhirhi, azĩmbɔ ri igũ hã Uyesu aka agɔr umbɔ izĩ. ");
INSERT INTO ldb_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Umbɔ aka anyã unga, umbɔ adzowe unga igɔng, bɔr abɔɔ acucang. ");
INSERT INTO ldb_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mɔcɛ Uyesu aba ru umbɔ agɔr umbɔ agɛ, <<Aka adzaambɔ umum ijeea kishoo iyi afã nggu abĩ. ");
INSERT INTO ldb_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nggee àka azĩ akũ anera kishoo ru upfunga aba adɔsa umum. Àka asorhuwe umbɔ ubɔtisima ri itsok Utɛ nu iki Ungwɛ̃ nu iki Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Àka amesuwe umbɔ adɔsa kishoo abinkɛ umum iki itsuka umbi. Idzidzɛrhe umum iwe nggu umbi, utsɛku imimashu upfung.>>");
INSERT INTO ldb_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Itirhi Isarhe Iyiki Ize iyi Uyesu Ukiristo, Ungwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Umbɔ aka atsɛng ru ubvur uner uwuku usɔm Arherhu-Num Uishaya ri itsinga agɛ, <<Umum iwuri idene ungwɛ̃ itsermum agbaashia ru ungo. Unga awuri igbishuwa atsĩndĩngo. ");
INSERT INTO ldb_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Urhɛm uwɔɔ uyisa ra arhum ugɛ, <Agbishuwe utsĩndĩ Uteijee, aka agbisha avii atsĩndĩnga arhika.> >> ");
INSERT INTO ldb_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nggee Uyohana aba, asorhuwe ubɔtisima ra arhum na adzowe isarhe iyi idzidzipa iyiki itsũwe arhim. ");
INSERT INTO ldb_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Anera arhɛrhɛ abi abĩ Uyahudiya, nu aner Urusharhima adzek azĩ ru unga. Asɔm arhimmbɔ, unga asorhuwe umbɔ ubɔtisima ra Azɛ̃ Urdun. ");
INSERT INTO ldb_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Uyohana atsim atorho igwar urhakumi, abow ikpɔm ubvur nú upfurhsĩnga, ubinghanga uwu asusu nggu utoo arhum. ");
INSERT INTO ldb_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Isarhanga hã iyɛ ugɛ, <<Uwɔɔ ruwɔ aka iba ru undzingmum agɔnga umum, uwuruwi umum isi ídɛ̃ɛ̃ inggarhukũ arhi abadaknga. ");
INSERT INTO ldb_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Umum isorhuwa umbi ubɔtisima nggu amɛ̃, bɔr unga awuri ikũ Ipfu Isarsatangge asorhuwa.>> ");
INSERT INTO ldb_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ri ivang hã Uyesu adzeka ru Unazarat ra abĩ Ugarhirhi, Uyohana asorhuwe unga ubɔtisima ra Azɛ̃ Urdun. ");
INSERT INTO ldb_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Uyesu aka awuri idzeka ra amɛ̃, unga anyã afã aka ayanga, Ipfu Isarsatangge ru nyaku unurhɛu icipuwa nu unga. ");
INSERT INTO ldb_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Urhɛm udzeka afã ugɔr ugɛ, <<Ungo uwu Ungwɛ̃mum iki ĩbema. Nggu ungo umum igũibɛn akarhãrhã.>> ");
INSERT INTO ldb_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kanying Ipfu-Num ikũna unga idzek izĩngge ra arhum. ");
INSERT INTO ldb_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Unga awu umɔ utsɛku inuma isɔka inaa, Ushaitan aka adeya unga. Unga awu nggu íjuɛ arhum, bɔr ípfu itser-Num itɔ̃we unga itser. ");
INSERT INTO ldb_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Umbɔ aka agbange Uyohana ru ugborzĩ amaa, Uyesu azĩ atsĩã Ugarhirhi, anu idzowe Isarhe Iyiki Ize iyi Unum. ");
INSERT INTO ldb_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Agɛ, <<Ivanga iki ibangge! Nggayɛ Iyɛrhu Unum iki iyongge. Àka adzipa, na awe ru imangmang ri Isarhe Iyiki Ize!>> ");
INSERT INTO ldb_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Uyesu aka azɛ̃rhã atɔng ru ubang Ukau Ugarhirhi, unga anyã Usiman nu ungwɛ̃mbɔ Uandarawu anu itang igber ru ukau ha, umbɔ awu abika adɛm abɛrh. ");
INSERT INTO ldb_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Uyesu agɔr umbɔ agɛ, <<Àka aba adɔsa umum, umum itsu umbi awu abika adzui anera.>> ");
INSERT INTO ldb_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kanying umbɔ aneke itang igbermbɔ na adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Unga aka agɔpa azĩ ukunjiir, unga anyã Uyaku ungwɛ̃ Uzabadi nu ungwɛ̃mbɔ Uyohana ru ukhukhɔɔ, adɛ̃ɛ̃ igbishu igbermbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Asi idãrhũmbɔ unga ayisa umbɔ. Umbɔ aneke utɛmbɔ Uzabadi nggu abi itser imang ru ukhukhɔɔ ha na adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Uyesu nggu angwɛ̃ imesanga atsĩmbɔ Ukafanahum, unum ukpuku uwosha uku uwe, Uyesu atsĩ ru ubã ifɛn-Num atirhi imesuwe. ");
INSERT INTO ldb_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Anera adzeidzeu ri imesanga, ubinkutsu amesuwe umbɔ ru nyaku uner ijee. Asi iwea ru nyaku uwuku umesuwe Ikpem. ");
INSERT INTO ldb_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Umɔ hã uner uwɔɔ ru ubã ifɛn-Nummbɔ awuri ipfu iyiki ibewe itsu ivum igɛ, ");
INSERT INTO ldb_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","<<Iyee! Ungo ubee use nggu umɛn Uyesu uner Unazarat? Ungo uba itsĩme umɛn? Umum ihwɛng ungo uwu usarkasar uwu Unum!>> ");
INSERT INTO ldb_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Uyesu atsɛrhi ipfu iyiki ibewe ha agɛ, <<Unukutata! Upfudzeka ru utsak ha!>> ");
INSERT INTO ldb_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ipfu iyiki ibewe ha iyung utsak ha nggu uvɔm ni itsu ivum idzengge ru utsak ha. ");
INSERT INTO ldb_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Anera kishoo adzeidzeu na arhusa adɔka agɛ, <<Awu use nuwi ikɛi? Imesa iyiki ifa nu ijee! Atsu ípfu iyiki ibewe idɔsa arherhanga!>> ");
INSERT INTO ldb_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Kanying isarhanga itɛ̃rhã imaangge ananga ra abĩ Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Umbɔ aka adzeka ru ubã ifɛn-Num hã, umbɔ azĩ nggu Uyaku nu Uyohana atsĩmbɔ ri iyambɔ Ubitru nu Uandarawu. ");
INSERT INTO ldb_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Uya utsɛ̃ Ubitru iyora imani unga anu inũ, umbɔ asɔme unga kanying. ");
INSERT INTO ldb_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nggee unga azĩ adzur uboknga abera unga. Imani iyor ha ikerhungge, unga asok atɔ̃we umbɔ itser. ");
INSERT INTO ldb_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nu urhɛɛ ha, unuma uku utsĩ anera akũ arhɛrha abi írhãrhã aba ru Uyesu, nu abi ípfu iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Arhɛrha anera ru utepa akɔng nu angwĩ iyaa. ");
INSERT INTO ldb_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Uyesu akerhuwe abi ikpũ írhãrhã. Ikɛi atsusuwe ípfu iyiki ibewe ra anera arhɛrhɛ, asi ibeenga ípfu iyiki ibewe irherha arherhe ubinkutsu ngge ihwɛngngge unga. ");
INSERT INTO ldb_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ri igɔ̃kpeka, uzĩ na ubɔrkpɔ, Uyesu asok, aneke iya ha na azĩã ra anangkɛ anera aka ashimbɔ, umɔ unga aka afɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Usiman nu abirabɛ aka awu nggu unga azĩmbɔ ibea unga. ");
INSERT INTO ldb_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Umbɔ aka anyã unga, umbɔ agɛ, <<Kishoo adɛ̃ɛ̃ ibea ungo.>> ");
INSERT INTO ldb_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Uyesu agɔr umbɔ agɛ, <<Umɛn izĩmɛn iteuyɛ iki ikhapa nggimi, umum idzowe isarhe umɔ ikɛi. Ubin hã ru ukpɔ uku ukũ umum uba.>> ");
INSERT INTO ldb_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nggee unga azɛ̃rhã amaa Ugarhirhi adzowe isarhe ra abã ifɛn-Nummbɔ na atsusuwe ípfu iyiki ibewe ra anera. ");
INSERT INTO ldb_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uner ingbim uwɔɔ aba ru Uyesu, atararhu ashɔ̃rhã unga agɛ, <<Ungo uba ubeengo, ungo udɛ̃ɛ̃ ukerhuwango umum nu usara umum.>> ");
INSERT INTO ldb_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Umɔ Uyesu agũ atorh, aberu uboknga abangu utsa ha. Agɛ, <<Umum ĩbeemum, ukerhe!>> ");
INSERT INTO ldb_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kanying ingbimnga ikerhungge. ");
INSERT INTO ldb_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Uyesu asoyiwe unga na avange atonga akarhãrhã agɛ, ");
INSERT INTO ldb_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","<<Niba usɔmukɔ unera. Bɔr uzĩ, udɛyiwe itsingo ru uwuku udzowe idɛm-Num nu udzowe idɛm-Num iyi Umusa aka amesuwa umbi ri ikikerhe, ra anera ahwɛng ugɛ ungo uku ukerhungo.>> ");
INSERT INTO ldb_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Unga aka ikorhe rimi, utsak ha akpurha adzek adɛ̃ɛ̃ isisɔme anera, amaa ananga kishoo. Akɛrɛ ha atsu Uyesu asi idɛ̃ɛ̃ atsĩã uteu ukpɔɔ ri inyĩnyã anera, akpurha aseiyi ru awiya anangkɛ anera aka ashimbɔ umɔ. Rimi hã anera anang adzeyi ri inang aba ru unga. ");
INSERT INTO ldb_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Inuma ukunjiir iki itɔng, Uyesu abvui atsĩã Ukafanahum ikɛi, anera aka agũ ugɛ unga aka aba ri iya. ");
INSERT INTO ldb_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Anera arhɛrhɛ akɔng atɔke ubãã, atsu ananga asi ibɔrke ru angwĩ ubãã, Uyesu adzowe umbɔ isarhe. ");
INSERT INTO ldb_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Inera inaa iki itsã uner irhãrhĩ ishai iyor akũ aba. ");
INSERT INTO ldb_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Umbɔ aka asi ikpombɔ udĩ ukpuku utsutsĩ ru Uyesu, anera aka arhɛmbɔ, umbɔ afũ ati akang uvi iya ha ra anankɛ Uyesu aka adɛ̃ɛ̃, na acipuwe uner ishai iyor ha nu ufarnga aka anu. ");
INSERT INTO ldb_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Uyesu aka anyã imangmangmbɔ, unga agɔr uner ishai iyor ha agɛ, <<Ungwɛ̃mum, aka atsũwãmbɔ arhimngo.>> ");
INSERT INTO ldb_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Abika amesuwe Ikpem asei umɔ ra anang hã akaifɛrhkɔ ra amɛnmbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","<<Awu use utsu utsak uwurɛ arherhe rimi? Unga aka arhenu Unum! Ungamɔ awe ru ijee iyiki itsũwe arhim? Asi iwea Unum ikiyikanga?>> ");
INSERT INTO ldb_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kanying Uyesu ahwɛnga ubinkpi umbɔ aka akaifɛrhkɔ ra amɛnmbɔ, unga agɔr umbɔ agɛ, <<Awu use utsu umbi awe ru ikpũ ifɛrhkɔ ha? ");
INSERT INTO ldb_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Akasong aka ayoa, umbɔ aka idɛyiwe uner ishai iyor ha, <Aka atsũwãmbɔ arhimngo,> use igɔr ugɛ, <Usisok unyangu ufarngo uzɛ̃rhã?> ");
INSERT INTO ldb_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bɔr umum ibee umbi ahwɛng ugɛ Ungwɛ̃-Ner awea ri ijee iyiki itsũwe arhim ru upfung.>> Umɔ unga agɔr uner ishai iyor ha agɛ, ");
INSERT INTO ldb_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","<<Umum ĩgɔr ungo, usisok, unyangu ufarngo uzĩ ri iya.>> ");
INSERT INTO ldb_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Unga asok, anyangu ufarnga azɛ̃rhã adzeka ri inyĩnyã anera kishoo. Akɛrɛ ha atsu umbɔ adzeidzeu na akpoi Unum agɛ, <<Umɛn inasi inyãmɛn ifɛrhɛ rimi.>> ");
INSERT INTO ldb_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Uyesu abvui adzek azĩã ru ubang Ukau Ugarhirhi. Anera arhɛrhɛ aka azĩ akɔng adziira unga, unga amesuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Unga aka azɛ̃rhã atɔng, unga anyã Urhawi ungwɛ̃ Uharhfa aka asei ra anang akika ayɛi ikirbi abĩ. Uyesu agɔr unga agɛ, <<Udɔsa umum,>> unga asok adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Uyesu nu angwɛ̃ imesanga asei igha urhɛɛ ri iya Urhawi nggu abika ayɛi ikirbi abĩ nu abirabɛ aka anyanga umbɔ awu abi arhim arhɛrhɛ. Anera arhɛrhɛ aka adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ivangyɛ abika amesuwe Ikpem aka awu abi Ufarisi, aka anyã unga aka asei igha ubingha nggu abi arhim hã nu abika ayɛi ikirbi abĩ, umbɔ arhusa angwɛ̃ imesanga agɛ, <<Awu use utsu unga asei igha ubingha nggu abika ayɛi ikirbi abĩ nu abi arhim?>> ");
INSERT INTO ldb_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Uyesu aka agũ rimi, unga agɔr umbɔ agɛ, <<Abika aker asi ibeembɔ uner agɔu, abi irhãrhã ukpekũ abee uner agɔu. Umum isi ĩbamum iyisa abika arhurhika, bɔr umum ĩba iyisa abi arhim.>> ");
INSERT INTO ldb_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Angwɛ̃ imesu Uyohana Uner Ubɔtisima nu abi Ufarisi adɛ̃ɛ̃ ikpem ighabin. Anera abɔɔ aba arhusu Uyesu agɛ, <<Awu use utsu Angwɛ̃ imesu Uyohana nu abi Ufarisi akpemmbɔ ighabin, bɔr abingo asi ikpemmbɔ?>> ");
INSERT INTO ldb_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Uyesu agɔr umbɔ agɛ, <<Awu use utsu awɛrhu utsak uwuku ufa akpem ighabin unga aba ana awu nggu umbɔ? Asi íkpemmbɔ ri ivangyɛ unga aka awu nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ivanga niyɔ ibarɔ umbɔ awuri isoyiwe utsak uwuku ufa ha ru umbɔ, unum hã nukpɔ umbɔ aka ikpem ighabin. ");
INSERT INTO ldb_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","<<Unera asi íkũ utatorho uku ufa abipunga atorho aka agbe. Unga aba akorhunga, utatorho uwuku ufa ha uwuri ishĩrhã avaate atorho aka agbe ha, ivivaar ha iwuri inangge iyi inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ikɛi unera asi ítsuka amɛ̃ inebi aka afa ra ambãĩ aka agbe. Unga aba akorhunga rimi, amɛ̃ inebi aka afa ha awuri iyare ambãĩ aka agbe ha, ambãĩ ha nu amɛ̃ inebi ha awuri iwe ibɛm. Amɛ̃ inebi aka afa, awuri itsu ake ra ambãĩ aka afa.>> ");
INSERT INTO ldb_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ru unum ukpuku uwosha ukpɔɔ, Uyesu nu angwɛ̃ imesanga azɛ̃rhã atɔng ri icang arhkama. Angwɛ̃ imesanga aka azɛ̃rhã nggu unga, atirhi igbiu atsi arhkama. ");
INSERT INTO ldb_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Abi Ufarisi agɔr unga agɛ, <<Unyã, awu use utsu umbɔ azharhuwe Ikpem unum ukpuku uwosha?>> ");
INSERT INTO ldb_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Unga agɔr umbɔ agɛ, <<Umbi anasi ivarhumbi ubin Udauda aka akorhe ri ivangyɛ umbɔ aka agũ imerh nggu awɛrhu uzɛ̃rhãnga? ");
INSERT INTO ldb_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ri inum Uabiata aka awu Ukugɔng Uwuku Udzowe Idɛm-Num, Udauda atsĩ ri Iya-Num, atãiwe usarkasar uborodi, ikɛi na abɔr adzowe awɛrhu uzɛ̃rhãnga, ukpurukpi uku usi imɛ̃kpɔ unera atãinga ukpɔ, uner uwuku udzowe idɛm-Num ukpekũ awuri itãi.>> ");
INSERT INTO ldb_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mɔcɛ unga agɔr umbɔ agɛ, <<Angwɛ̃we unum ukpuku uwosha ra anera, asi ingwɛ̃mbɔ anera awembɔ abi unum ukpuku uwosha. ");
INSERT INTO ldb_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nggee Ungwɛ̃-Ner unga awu Uteijee uwu unum ukpuku uwosha.>> ");
INSERT INTO ldb_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ivang iyɔɔ unga aka atsĩ ru abã ifɛn-Num, uner uwɔɔ umɔ nggu uboknga ushushai. ");
INSERT INTO ldb_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Abɔɔ abee ubinkpi umbɔ aka ikũ akpo uvau ru Uyesu. Umbɔ atsu asumbɔ nu unga use unga awuri ikikerhuka utsak ha ru unum ukpuku uwosha. ");
INSERT INTO ldb_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Uyesu agɔr uner uwuku ushai ubok ha agɛ, <<Udzek udɛ̃ɛ̃ ra asumbɔ kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Uyesu arhusa umbɔ agɛ, <<Imɛ̃ɛ̃ umbɔ akorhu use ru unum ukpuku uwosha, akorhi iyiki ize use akorhi iyiki ibewe, afɔrhe urhɛ use afɛre umgbɔ?>> Bɔr umbɔ asei ukutata. ");
INSERT INTO ldb_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Unga arhi adziira umbɔ ra avɔm, amɛnnga adake ra amɛn aka akermbɔ, unga agɔr uner ushai ubok ha agɛ, <<Unamu ubokngo.>> Unga anamu uboknga udzek, Kanying ukpɔ ukerhukpɔ. ");
INSERT INTO ldb_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Mɔcɛ abi Ufarisi adzek akɛki itsũwã nggu aner Uhiridu, abee udĩ ukpuku ufɛr Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Uyesu adzek nggu angwɛ̃ imesanga azĩmbɔ ubang ukau, arhɛrha anera adzeku Ugarhirhi adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Umbɔ aka agũ abinkɛ unga aka akorhe kishoo, anera arhɛrhɛ aka adzeku Uyahudiya aba ru unga, nu Urusharhima, nu Uidumiya, nu abi ugar Azɛ̃ Urdun, nu aner Utaya nu Usidon. ");
INSERT INTO ldb_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Anera aka arhɛmbɔ, unga agɔr angwɛ̃ imesanga akpowe ukhukhɔɔ amɛ̃ uwuku uci adzowe unga, utsur anera afĩĩmbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Unga akerhuka anera arhɛrhɛ, nggee abi irhãrhã abee izĩ ra asu abanga unga. ");
INSERT INTO ldb_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ivangyɛ ípfu iyiki ibewe iki inyã unga, ngge igba nú abĩ ra anangnga ni itsui ivum igɛ, <<Ungo uwu Ungwɛ̃ Unum!>> ");
INSERT INTO ldb_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bɔr unga avange ngge niba idɛyikungge unera unerwi unga aka awe. ");
INSERT INTO ldb_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Uyesu afũã igũ na ayisa abirabɛ unga aka abee, umbɔ aba ru unga. ");
INSERT INTO ldb_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Unga asɛng usɔkdũmɛn umbɔ aka iwe abi itser Uyesu ugɛ umbɔ awe nggu unga, nú unga adene umbɔ adzek adzise isarhe. ");
INSERT INTO ldb_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Umbɔ awuri iyiyɛimbɔ ijee iyiki itsusuwe ípfu iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Umbɔ hã abɛ, usɔkdũmɛn hã unga aka asɛng, Usiman, uwu ha Uyesu aki iyisa Ubitru, ");
INSERT INTO ldb_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","nu Uyaku ungwɛ̃ Uzabadi nu ungwɛ̃mbɔ Uyohana, abirabɛ Uyesu iki iyisa ugɛ Ubuwarnaji, agbena agburh <<Angwɛ̃ Igbigbashu Inai,>> ");
INSERT INTO ldb_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","nu Uandarawu, nu Ufirhibu, nu Ubatorhomi, nu Umatiyu, nu Utoma, nu Uyaku ungwɛ̃ Uharhfa, nu Utaddiyu, nu Usiman uner Ukan'ana, ");
INSERT INTO ldb_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nu Uyahuda Uiskariyoti uwuku ugha adaknga. ");
INSERT INTO ldb_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mɔcɛ Uyesu abvui atsĩ ri iya. Anera abvui akɔng ikɛi, utsɛku unga nu angwɛ̃ imesanga asi idɛ̃ɛ̃ aghambɔ ubingha. ");
INSERT INTO ldb_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Abi iyambɔ aka agũ rimi, asok azĩmbɔ idzur unga. Anera anu igɔr agɛ, <<Unga aka azhɔmu ukpong!>> ");
INSERT INTO ldb_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Abika amesuwe Ikpem igambɔ adzeku Urusharhima aba agɔr agɛ, <<Awu Uba'arhzaburh uyɛrhe ípfu iyiki ibewe unga atsĩ ru unga! Akũ ijeenga ikɛi atsusuwe ipfu iyiki ibewe idzek.>> ");
INSERT INTO ldb_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nggee Uyesu ayisa umbɔ na arherhuwe umbɔ unyaka arherhe agɛ, <<Ushaitan awuri ikorha aguse na awayiwe Ushaitan? ");
INSERT INTO ldb_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Iyɛrhe iba igaungge itsingge, iyɛrha ha isi ídɛ̃ɛ̃ngge. ");
INSERT INTO ldb_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Iya iba igauke itsike, iya ha isi ídɛ̃ɛ̃ke. ");
INSERT INTO ldb_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Rimi Ushaitan aba ugapa itsinga, unga asi ídɛ̃ɛ̃nga, imimashanga iki ibangge. ");
INSERT INTO ldb_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Idzidzɛrhe, unera asi ídɛ̃ɛ̃ atsĩã ri iya uner uwuku uker akarhuka abinnga, awuri itirhi abow uner uwuku uker ha. Mɔcɛ unga awuri idɛ̃ɛ̃ avura abin iya ha. ");
INSERT INTO ldb_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Umum idɛyiwa umbi idzidzɛrhe, kishoo arhim nu irhenu Unum anera aki ikorhe, awuri itsitsũwũkumbɔ ake. ");
INSERT INTO ldb_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bɔr ubɛn uwuku urhenu Ipfu Isarsatangge asi ítsũwũkumbɔ unga, awu ra arhim aki ugbagbaa.>> ");
INSERT INTO ldb_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Unga arherhe rimi, ubinkutsu umbɔ aka agɔr agɛ, <<Unga awe ru ipfu iyiki ibewe.>> ");
INSERT INTO ldb_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mɔcɛ uya Uyesu nggu angwɛ̃mbɔ aba atsĩ. Adɛ̃ɛ̃ nú awiya, na adene uwɔɔ unga ayisuwe Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ikikɔnga isei adziira unga, umbɔ adɛyiwe unga agɛ, <<Uyango nu anapumbi abeea ungo ra awiya.>> ");
INSERT INTO ldb_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Unga arhusa umbɔ agɛ, <<Awu umbɔ ungamɔ awu uyamum nu angwɛ̃mɛn?>> ");
INSERT INTO ldb_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Unga arhi abirabɛ aka asei adziira unga na agɛ, <<uyamum uwi nggu angwɛ̃mɛn! ");
INSERT INTO ldb_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ubɛn unera aka ikorhu ubinkpi Unum aka abema, unga awu ungwɛ̃mɛn nu unapumɛn nu uyamum.>> ");
INSERT INTO ldb_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ikɛi Uyesu atirhi imesuwe nú ubang ukau. Ikikɔnga iki ikɔng idziir unga irhɛngge, unga asok atsĩ ukhukhɔɔ amɛ̃ asei ru ukau, ikikɔng anera idɛ̃ɛ̃ umɔ nú ubang ukau ha. ");
INSERT INTO ldb_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Unga akũ unyaka arherhe amesuwe umbɔ abina arhɛrhɛ, agɔr umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","<<Àka akpeto! Uner irham adzek azĩ idoi ikpũnga. ");
INSERT INTO ldb_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Unga aka adɛ̃ɛ̃ inna ikpũ hã, ikpũ iyɔɔ igba nú utsĩndĩ, anunu aba akpɔuke iyi ha. ");
INSERT INTO ldb_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Iyɔɔ igbei ru ukpɔrha, abĩ asi iweke akarhãrhã. Ngge imɛr kanying ubinkutsu, abĩ anang hã asi ighorke. ");
INSERT INTO ldb_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Unum uku urhang, imani ikoikungge ikpũ iyi ha, ubinkutsu ngge ishingge ra anũnang. ");
INSERT INTO ldb_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ikpũ iyɔɔ igba ri ididɔk, ididɔk iseng itong iyi ha, ngge isi ighwɛrngge ikpũrhã. ");
INSERT INTO ldb_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Iyɔɔ ikɛi igba ra abĩ aka aze. Imɛr idzeka, iseng ni ighwɛr ikpũrhã, iyɔɔ isɔka itaitaar, iyɔɔ isɔka utɔ̃tɔ̃ĩ, iyɔɔ ananaka.>> ");
INSERT INTO ldb_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mɔcɛ Uyesu agɛ, <<Ubɛn unera aka awu ra ato akika agũ, neke unga agũ.>> ");
INSERT INTO ldb_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ivangyɛ Uyesu aka asei ikiyikanga, angwɛ̃ imesanga usɔkdũmɛn nu abɔɔ aka adɔsa unga arhusa agben unyaka arherhe ha. ");
INSERT INTO ldb_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Unga adɛyiwe umbɔ agɛ, <<Aka adzaambɔ umbi ihwɛng iwiwɔk Iyɛrhe-Num. Bɔr abirabɛ aka awu ra awiya, abina kishoo awuri irherhuwe umbɔ ru unyaka arherhe. ");
INSERT INTO ldb_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ngge itsu, << <Umbɔ awuri irhirhimbɔ, bɔr asi ínyãmbɔ, awuri igũmbɔ ikɛi na asi íhwɛngmbɔ, utsur umbɔ adzipa na atsũwũkumbɔ arhimmbɔ!> >> ");
INSERT INTO ldb_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Unga agɔr umbɔ agɛ, <<Umbi asi ihwɛngmbi agben unyaka arherhe ha? Ude umbi awuri ikorhu uguse na ahwɛng agben unyaka arherhe akɔɔ? ");
INSERT INTO ldb_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Uner irham hã adoi Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Abɔɔ awu ru nyaki ikpũyɛ iki igba nú utsĩndĩ, anangkɛ umbɔ aka adoi arherha ha, kanying Ushaitan aba atsũwũka arherhe ha aka adoi ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Abirabɛ aka awu ru nyaki ikpũ iyiriyɛ umbɔ aka adoi nú abĩ ifa, agũ arherha ha, kanying umbɔ ayɛi ake nggu itɛnamɛn. ");
INSERT INTO ldb_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Bɔr umbɔ aka ashimbɔ ra anũnang, umbɔ adãrhĩ ivanga ukunjiir. Ivang ayetnum use uver iki iba ri itsi arherha ha, kanying umbɔ abvui azĩmbɔ ra andzing. ");
INSERT INTO ldb_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ikɛi abɔɔ, awu ru nyaki ikpũyɛ iki idoi ri ididɔk, agũ arherhe ha, ");
INSERT INTO ldb_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bɔr igũ ighong abin upfung, nu irhirhɛm ibee iwu ru ubin nu ikpona abina akɔɔ itsĩ ikɛnke arherha ha ighwighwɛr. ");
INSERT INTO ldb_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Abɔɔ, awu ru nyaki ikpũyɛ iki idoi na abĩ aka aze, agũ arherha ha, na ayɛi ake akũ atɔ̃ itser nggu ake, aghwɛr ikpũrhã iyɔɔ isɔka itaitaar, iyɔɔ isɔka utɔ̃tɔ̃ĩ, iyɔɔ ananaka.>> ");
INSERT INTO ldb_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Uyesu agɔr umbɔ agɛ, <<Umbi aka isaka agaar irhirhang awɔkmbi ru ikikĩĩ? Use atsuke ngge ra ada ukoma? Ishingge rimi, ugɛse umbi aka isaka aden ngge ru anang idɛ̃ɛ̃ke afafã? ");
INSERT INTO ldb_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Abinkɛ aka awu ri iwɔk, umbɔ awuri inyãmbɔ ake, abinkɛ aka awoyi ikɛi, awuri inyinyãmbɔ ake nu awiya. ");
INSERT INTO ldb_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ubɛn unerwi aka awu ra ato akika agũ, neke unga agũ.>> ");
INSERT INTO ldb_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Na agɔr umbɔ agɛ, <<Àka akpeto na agũ. Ugbiu ha ungo uku ukũ umei, awuri ikũ umgbɔ amei adzaa ungo, awuri itomuwambɔ ungo. ");
INSERT INTO ldb_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Uwuruwi aka awe ru ihwihwɛng awuri itomuwe unga akpo arhɛrhɛ. Uwuruwi aka ashia, awuri iyɛse ungwɛ̃rhĩ ihwihwɛng ha unga aka awerangge.>> ");
INSERT INTO ldb_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na agɔr agɛ, <<Iyɛrhe Unum iwuri iminɛ. Unera adoi ikpũ nu icangnga. ");
INSERT INTO ldb_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Utsuu nu atenum, unga arha na asok, utsɛki ikpũ hã iki imɛr iseng, uner ha asi ihwɛnga ubinkpi uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Abĩ nibikake atsu ikpũ imɛr, atirhi akũ agam adzeka, na akũ azang adzeka, nu azanga akũ ishaanga idzeka. ");
INSERT INTO ldb_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ivang ishaanga iki ikɔ̃, unga aka ikũ ikon agbɛr, ivang iyiki igbɛr iki iwe.>> ");
INSERT INTO ldb_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Uyesu ikɛi agɛ, <<Umum ikpangu Iyɛrhe Unum nggu use, umum ikũ unyaka arherhe akasong idɛyiwe ngge iki iwe? ");
INSERT INTO ldb_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Iwu ru nyaki ishaa ikpũ umastad, iyiriyɛ ngge iki iwe iyiki icia ri ikpũ abin iyiki idoi nu abĩ. ");
INSERT INTO ldb_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Umbɔ aka idoi ngge, ngge iki isaki iseng igɔngngge abinkɛ umbɔ aka adoi ra abĩ, nggu abokngge akagɔng anunu aka isaka acipuwa akang ashiake nu ake.>> ");
INSERT INTO ldb_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nggu urhɛrhɛ unyaka arherhe Uyesu aka akũ asɔme anera Arherhu-Num, ri ihwihwɛngmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Asi isɔmuka umbɔ ubin rimi ru umbɔ uku ushikpɔ ru unyaka arherhe. Bɔr ivangyɛ unga aka awu nggu angwɛ̃ imesanga ikiyikambɔ, unga aka isaka asɔmuka umbɔ agbena. ");
INSERT INTO ldb_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ru unum hã urhɛɛ uku uwe, unga agɔr angwɛ̃ imesanga agɛ, <<Umɛn inggar udiku ukpɔrɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Umbɔ abɔre ikikɔng anera, umbɔ ashupa unga nggu umbɔ, ru ukhukhɔɔ amɛ̃ unga aka asei ru umgbɔ. Akhukhɔɔ akɔɔ ikɛi awu umɔ. ");
INSERT INTO ldb_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nggaa ugba ukom ukerketakpɔ usoyi, amɛ̃ ukau ha ukwɛr ukhukhɔɔmbɔ, utsɛku umgbɔ ubɔr ukunjiir ri ididɛɛ ra amɛ̃. ");
INSERT INTO ldb_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Uyesu awu ru urhɔ ra akpok ukhukhɔɔ nu ubin ukpuku utsorhi itsi. Angwɛ̃ imesanga azita unga agɔr agɛ, <<A umarhem, ungo usi igũo ighong umɛn iki iwuri itsĩmɛn?>> ");
INSERT INTO ldb_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Unga asok, atsɛrhu ugba ukukom hã agɔr amɛ̃ ukau ukugɔng hã agɛ, <<Unukutata! Udɔɔr!>> Mɔcɛ ugbaa ukpekpɔ, ananga kishoo anukutata uku ughwɔɔw. ");
INSERT INTO ldb_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Unga agɔr angwɛ̃ imesanga agɛ, <<Awu use utsu umbi agũ iwei rimi? Umbi ana ashimbi ri imangmang?>> ");
INSERT INTO ldb_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Umbɔ agũ iwei akarhãrhã agɔr adɔkambɔ agɛ, <<Awu ungaa nuwi? Ugba ukom nu ubvun amɛ̃ agũna unga!>> ");
INSERT INTO ldb_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Umbɔ azĩ atsĩ ugar ukau abĩ Ugarasa. ");
INSERT INTO ldb_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ivang Uyesu aka adzeku ukhukhɔɔ, unga agbang nggu uner ipfu iyiki ibewe aka adzeka ra anang aka adzak aner. ");
INSERT INTO ldb_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Uner ha asei ra anang akika adzak aner, unera asi idɛ̃ɛ̃ abowpa unga uko nggu inyãwã. ");
INSERT INTO ldb_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Umbɔ aka isaka abow aboknga nu adaknga nggu inyãwã, bɔr unga aka isaka apupuwe ngge na abvũĩwe azɔu aki adaknga. Unera ashia ri iker iyiki ikpɔm unga. ");
INSERT INTO ldb_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nu utsuu na atenum unga aghɛta ra anang akika adzak aner nu ígũ anu itsuyi ívum na akũ atarh angwãi iyornga. ");
INSERT INTO ldb_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Unga aka anyã Uyesu ukukaa, unga atĩtser aba atararhu ra anangnga. ");
INSERT INTO ldb_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Atsarhi irhaknga atsu ívum agɛ, <<Awu use utoma ungo nggu umum, Uyesu, Ungwɛ̃ Unum uwuku Ugɔng? Uyirh itsok Unum ugɛ ungo usi ídzaango umum uver!>> ");
INSERT INTO ldb_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ubinkutsu Uyesu aka agɔra unga agɛ, <<Upfudzeka ru utsak uwurɛ, ungo ipfu iyiki ibewe!>> ");
INSERT INTO ldb_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Uyesu arhusa unga agɛ, <<Itsokngo igburh ungamɔ?>> Unga agɛ, <<Itsokmum igburh Ukpusha, ubinkutsu umɛn iwu irhɛɛmɛn.>> ");
INSERT INTO ldb_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Unga ashɔ̃rhũ Uyesu akarhãrhã utsur unga awayika umbɔ adzembɔ ra anang hã. ");
INSERT INTO ldb_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Arhede arhɛrhɛ aka adɛ̃ɛ̃ ughãwã akhapa ri igũa. ");
INSERT INTO ldb_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ípfu iyiki ibewe ha ishɔ̃rhũ Uyesu igɛ, <<Uma udena umɛn izĩ ru arhede akɔrɔ, itsĩ ra ake.>> ");
INSERT INTO ldb_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nggee unga abemuka ípfu iyiki ibewe ha idzek izĩngge ru ikpui arhede ha. Ikpui arhede ha itsĩngge anaka agɔnga avaa, ake asok atĩtser, ahwarha acipa atsĩke ru ukau atsĩmke ra amɛ̃. ");
INSERT INTO ldb_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abi idzɛu arhede ha atĩ azĩ asɔme uteumbɔ nu ukpuku ukhapa umɔ adzise isarhe, anera adzeyi aba inyã ubinkpi uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Umbɔ aka aba atsĩ ru Uyesu umbɔ anyã utsak ha ukpui ípfu iyiki ibewe ha iki iwe ru unga, asei umɔ atsim atorho ri iyornga amɛnnga awu uku urhirhiki, iwei ifɛr umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Abirabɛ aka anyã ifɛrha ha iki ikorhe adzowe isarhe abinkɛ aka akorhe nggu uner ukpui ípfu iyiki ibewe nu ikpui arhede ha. ");
INSERT INTO ldb_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mɔcɛ anera atirhi ishɔ̃rhũ Uyesu unga abɔre abĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Uyesu awuri itsĩ ru ukhukhɔɔ amɛ̃ nukpi, utsak ha ípfu iyiki ibewe ha iki idzeku unga ashɔ̃rhũ Uyesu ama aneke unga adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bɔr Uyesu asi inekuka unga. Agɔr unga agɛ, <<Uzĩ ri iya ra angwɛ̃mbi, usɔme umbɔ abin aka agɔngkɛ Uteijee aka akorhuwa ungo, nu atorhkɛ unga aka agũ ru ungo.>> ");
INSERT INTO ldb_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nggee utsak ha, azĩ atsĩrhã ri iteu usɔka umbɔ iki iyisa Udikaforhi adzise isarhe, abinkɛ Uyesu aka akorhuwe unga. Anera kishoo adzeidzeu. ");
INSERT INTO ldb_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ikɛi ivang Uyesu aka agar ugar ukpɔrɔ ru ukhukhɔɔ amɛ̃, anera arhɛrhɛ akɔng adziir unga nu ubang ukau ha. ");
INSERT INTO ldb_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mɔcɛ unying ra anggbaashi ubã ifɛn-Num itsoka igburh Uyayiru, aba umɔ. Unga aka anyã Uyesu, unga agba ra adaknga, ");
INSERT INTO ldb_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ashɔ̃rhã unga agɛ, <<Ungwɛ̃rhũ unapmum akpurha abɔr akpe. Umum ishɔ̃rhã ungo uba utsorhu ubokngo nu unga akerhe na abɛk.>> ");
INSERT INTO ldb_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nggee Uyesu azĩã nggu unga. Anera arhɛrhɛ aka afĩĩ adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Utsɛrh uwɔɔ umɔ aghong irhãrhã umɛ̃ɛ̃ imɛka usɔkdũmɛn. ");
INSERT INTO ldb_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Irhãrhãnga ighong unga akarhãrhã ri ivangyɛ abi agɔu arhɛrhɛ aka anɛta unga. Afɛre ubinkpi unga aka awerakpɔ kishoo, bɔr asi igũa ugarh, irhãrhã ikpurhi idɛ̃ɛ̃ ititoma. ");
INSERT INTO ldb_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ivangyɛ unga aka agũ isarhe Uyesu, unga adɔsa unga ra andzing ri ikikɔnga, aba abanga atorho Uyesu, ");
INSERT INTO ldb_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ubinkutsu unga akaifɛrhkɔ ra amɛnnga agɛ, <<Umum ĩba ĩbangumum atorhanga ukpekũ, umum iwuri ikerhumum.>> ");
INSERT INTO ldb_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kanying umɛ̃ɛ̃nga udɛ̃ɛ̃kpɔ, nu unga agũã ri iyornga aka akerhunga ru ayetnumnga. ");
INSERT INTO ldb_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Kanying Uyesu agũ ijee iki idze ru unga. Unga adzipa ri ikikɔnga arhusa agɛ, <<Ungamɔ abanga atorhamum?>> ");
INSERT INTO ldb_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Angwɛ̃ imesanga agɔr unga agɛ, <<Ungo unyã anera arhɛrhɛ afĩĩa ungo riminɛ ungo ugɔr ugɛ, <Ungaa abanga umum?> >> ");
INSERT INTO ldb_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Bɔr Uyesu arhi adziir abee inyã uwuku ukorhu ubin hã. ");
INSERT INTO ldb_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mɔcɛ utsɛrh ha, aka ahwɛng ubinkpi uku ukorhuwe unga, aba nggu iwei nu izang iyor, agba ra anangnga adɛyiwe unga kishoo idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Unga agɔr unga agɛ, <<A unapmum, imangmango ngge ikerhuwa ungo. Uzĩ uku utɔɔ, ayetnumngo aka amaake.>> ");
INSERT INTO ldb_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Uyesu ana awu ra arherhe nukpi, nu anera adzeki iya Uyayiru unggbaashi ubã ifɛn-Num hã, aba agɔr agɛ, <<Unapungo aka akpea. Awu use utsu ungo unu idzowe umarhem ayetnum?>> ");
INSERT INTO ldb_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bɔr Uyesu akwɛɛte arherhambɔ, agɔr unggbaashi ubã ifɛn-Num hã agɛ, <<Niba ugũa iwei, uwe ru imangmang ukpekũ.>> ");
INSERT INTO ldb_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Asi ineke unera azĩã nggu unga, akpurha akũ Ubitru, nu Uyaku, nu Uyohana ungwɛ̃mbɔ Uyaku. ");
INSERT INTO ldb_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ivang umbɔ aka azĩ atsĩ ri iya unggbaashi ubã ifɛn-Num hã, Uyesu anyã idzidzunambɔ, nu anera aka aciu akpe atsui ivum. ");
INSERT INTO ldb_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Unga atsĩ agɔr umbɔ agɛ, <<Awu use utsu umbi aciu akpe na atsui ívum rimi? Una hã anasi ikpea awu ru urhɔ!>> ");
INSERT INTO ldb_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bɔr umbɔ anyĩrhã unga. Nggee unga atsu umbɔ adzek ra awiya, unga akũ utesa nu uyisa una hã nu angwɛ̃ imesanga hã abika awu nggu unga, atsĩ ra anangkɛ una hã aka awe. ");
INSERT INTO ldb_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Adzur ubok una hã agɔr agɛ, <<Tarhita kumi!>> agbena agburh <<Unakuci, umum igɔr ungo, usisok!>> ");
INSERT INTO ldb_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kanying una hã asok azɛ̃rhã adziir. Imɛknga iwu usɔkdũmɛn. Akɛrɛ ha atsu umbɔ adzeidzeu akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Uyesu agbiite atombɔ akarhãrhã ugɛ umbɔ niba adɛyikumbɔ unera. Ikɛi unga agɔr umbɔ adzowe ubingha ru una hã. ");
INSERT INTO ldb_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Uyesu asoka umɔ abvui azĩã Unazarat utepunga, angwɛ̃ imesanga azĩ nggu unga. ");
INSERT INTO ldb_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Unum ukpuku uwosha uku uwe, unga atirha amesuwe ru ubã ifɛn-Num, anera arhɛrhɛ aka agũ unga, adzeidzeu na arhusa agɛ, <<Utsak uwurɛ akpo abin akɛrɛ ri inɛ̃ɛ̃? Adzowe unga itsoi iyɛrɛ ri inɛ̃ɛ̃ unga aka anu ikorha abin idzeu? ");
INSERT INTO ldb_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Uwɛrɛ ha asi iwea ukapinta ha, ungwɛ̃ Umaryamu, ungwɛ̃mbɔ Uyaku, nu Uyusuf, nu Uyahuda nu ikɛi Usiman? Asi iwea anapumbɔ abɛ nggu umɛn?>> Umbɔ akpɛ̃mbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Uyesu agɔr umbɔ agɛ, <<Uwuku usɔm Arherhu-Num aka isaka akpoa igɔng ru ubɛn ananga, akpurha asheru utepunga nu anernga nu abi iyanga.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Unga asi idɛ̃ɛ̃ akorhunga abin idzeu nggɔɔ ha, unga akpurha atsorhuwe abok nu abi irhãrhã ukunjiir akerhuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Unga adzeidzeu umbɔ aka ashimbɔ ri imangmang. Mɔcɛ Uyesu atsĩrhã adziir íteu iyiki ici umɔ hã amesuwe anera. ");
INSERT INTO ldb_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Unga ayisa angwɛ̃ imesanga usɔkdũmɛn hã azĩ ru unga, unga adene umbɔ ivaivaa na adzowe umbɔ ijee ri itsi ípfu iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Unga agɔr umbɔ agɛ, <<Niba anyangumbi ubin ru uzɛ̃rhã hã, umbi akpurha akpɔm igbong, niba akpɔmmbi ubingha, use ijara, use uhwɛk ri íbvuk atorhambi. ");
INSERT INTO ldb_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Àka atsu abadak bɔr niba akpɔmmbi atorho akɔɔ. ");
INSERT INTO ldb_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ubɛn iya umbi aka itsĩ, àka asei umɔ utsɛku unumkpi umbi aka isok ru uteu ha. ");
INSERT INTO ldb_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ubɛn anangkɛ umbɔ aka asi iyɛimbɔ umbi use aba asi ikpembɔ ato ru umbi, àka awashuwe uzurhu adakmbi ivangyɛ umbi aka isok, umgbɔ uwu ideka iyiki ibewe ra atsimbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Umbɔ adzek adzowe isarhe ugɛ anera adzipa. ");
INSERT INTO ldb_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Umbɔ atsusuwe ípfu iyiki ibewe írhɛirhɛ, na adzukuwe atsei ra abi írhãrhã arhɛrhɛ akerhuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Uyɛrhe Uhiridu aka agũ abin akɛrɛ kishoo, ubinkutsu umbɔ ahwɛng itsok Uyesu imaa ananga. Abɔɔ agɛ, <<Uyohana Uner Ubɔtisima unga asok ra akpe. Ngge itsu unga awe ru ijee iyiki ikorha abin idzeu ha.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Abɔɔ agɛ, <<Awu uner uwuku usɔm Arherhu-Num Uirhiya.>> Abɔɔ igambɔ agɛ, <<Awu uner uwuku usɔm Arherhu-Num uwɔɔ, uwu abi isha.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ivangyɛ Uhiridu aka agũ akɛrɛ, unga agɛ, <<Uyohana, unerwi umum iki izharhuwe itsinga, unga asoka akpe!>> ");
INSERT INTO ldb_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ubinkutsu Uhiridu nibikanga atsumbɔ adzur Uyohana, abow unga na atsuke ru ugborzĩ, ri itsi Uhirudiya. Utsɛrha ungwɛ̃mbɔ Ufirhibu unga aka apfuna. ");
INSERT INTO ldb_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Uyohana aka isaka arherhu Uhiridu agɛ, <<Asi izea ungo uku upfunu utsɛrha ungwɛ̃mbi.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nggee Uhirudiya agũ avɔm Uyohana na abee ifɛre unga. Bɔr Uhiridu asi ibemuka. ");
INSERT INTO ldb_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ubinkutsu Uhiridu agũ iwei Uyohana na agana unga, ahwɛnga Uyohana arhika na awu usarkasar uner. Ubɛn ivangyɛ Uhiridu aka igũ arherhu Uyohana, unga aka isaka adzununga, rimi hã unga anang agũibɛn ikpeto ru unga. ");
INSERT INTO ldb_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ri imimasha ivanga ibangge ru Uhirudiya. Ru unum imar Uhiridu ivangyɛ unga aka azek irhowa, ayisa ayɛrhe abĩnga kishoo nu akagɔng abi iwa, nu akakũ abi Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ivangyɛ unapa Uhirudiya aka atsĩ azer azer, ake atsĩ ra amɛn Uhiridu nu atsennga. Nggee uyɛrhe agɔr una hã agɛ, <<Urhusa umum ubinkpi ungo uku ubee, umum iwuri ĩdzaamum ungo.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Unga ayirh nggu uyirh abemuwe una hã agɛ, <<Ubɛn ubinkpi ungo uku urhusa umum iwuri ĩdzaamum ungo, utsɛku uteng iyɛrhamum.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Una hã adzek azĩ arhusu uyanga agɛ, <<Umum iwuri irhusu use?>> Uyanga agɔr unga agɛ, <<Itsi Uyohana Uner Ubɔtisima.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kanying una hã abvui atĩ azĩã ru uyɛrhe agɔr agɛ, <<Umum ibee icɛrɛ ungo udzaa itsi Uyohana Uner Ubɔtisima ri itɛ̃rhĩ.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Amɛn Uyɛrhe aghong akarhãrhã, bɔr uyirhnga aka ayirh ra asu atsennga, itsu unga asi idɛ̃ɛ̃ akɛna unga. ");
INSERT INTO ldb_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nggee kanying unga adene undɔsu uyɛrhe akũ itsi Uyohana akũ aba. Utsa ha azĩ azharhe itsi Uyohana ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Akũ itsi ha ri itɛ̃rhĩ akũ aba. Adzowe ru una hã, unga ayɛi adzowe ru uyanga. ");
INSERT INTO ldb_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Angwɛ̃ imesu Uyohana aka agũ isarhe ha, umbɔ aba ashupu ukom Uyohana adzake. ");
INSERT INTO ldb_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Uner itser Uyesu akɔng adziir Uyesu na adɛyiwe unga kishoo abinkɛ umbɔ aka akorhe na amesuwe. ");
INSERT INTO ldb_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mɔcɛ, anera arhɛrhɛ aka anu iba na adzek utsɛku umbɔ asi ikpombɔ ivang igha ubin, unga agɔr umbɔ agɛ, <<Àka aba nggu umum umɛn izĩ ra anangkɛ anera aka ashimbɔ umɔ, umɛn iwosha ukunjiir.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nggee umbɔ atsĩ ukhukhɔɔ amɛ̃ azĩmbɔ anangkɛ anera aka ashimbɔ umɔ. ");
INSERT INTO ldb_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bɔr umbɔ aka isoka anang hã, anera arhɛrhɛ aka anyã umbɔ ahwɛngmbɔ umbɔ. Atĩ ra adak adzeyi ri íteu kishoo, anggbaashia azĩ atsĩmbɔ ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Uyesu aka acipa ru ukhukhɔɔ anyã arhɛrha anera aka akɔng. Unga agũ atorh umbɔ, ubinkutsu umbɔ awu ru nyaki ídɔi iki ishingge ru uner idzɛu. Nggee unga atirha amesuwe umbɔ abina arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Unum uku uyo itsitsĩ, nggee angwɛ̃ imesanga aba agɔr unga agɛ, <<Anera ashimbɔ ra anang akɛrɛ, nggayɛ unum uku uwuri itsĩkpɔ. ");
INSERT INTO ldb_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Udene anera umbɔ atsĩ íteu nu ícang iyiki ikhapa nggimi agoi ubin umbɔ aka igha.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bɔr unga agɔr umbɔ agɛ, <<Umbi àka adzowe umbɔ ubin umbɔ agha.>> Umɔ umbɔ agɔr unga agɛ, <<Ugɛ umɛn izĩ igoi ubingha ukpu imang uner itser afɛ̃ɛ̃ utɔrɔk! Umɛn izĩ ifɛre imang iyɛrɛ ru ubingha ni idzowe umbɔ agha?>> ");
INSERT INTO ldb_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Unga agɔr umbɔ agɛ, <<Umbi awu ra aborodi asong nggu umbi? Àka azĩ arhi.>> Umbɔ aka azĩ arhi, umbɔ agɛ, <<Aborodi atɔ̃ɔ̃, nu abɛrh avaa.>> ");
INSERT INTO ldb_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Uyesu atsu umbɔ agɔr anera asei ukpukpusha nu ubĩĩ uku usum. ");
INSERT INTO ldb_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nggee umbɔ asei ukpukpusha abɔɔ ananaka abɔɔ isɔka itɔ̃itɔ̃ɔ̃. ");
INSERT INTO ldb_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Unga aka anyangu aborodi ha ikitɔ̃nake nu abɛrh ha ikivarhake, aberi itsinga arhi afã, atar uwɛɛ na atsɔku uborodi ha. Mɔcɛ unga adzise angwɛ̃ imesanga umbɔ akũ azĩ adene anera. Ikɛi unga agashuwe abɛrh ha ikivarhake ru umbɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kishoo agha, ashuurmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Angwɛ̃ imesa arhɔ̃yĩ awushu uborodi ha nu abɛrh ha atɔk azĩnga usɔkdũmɛn. ");
INSERT INTO ldb_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Irhɛ anera aka agha ubingha ha, akatsak awu anakagɔnga atɔ̃ɔ̃. ");
INSERT INTO ldb_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kanying Uyesu atsu angwɛ̃ imesanga atsĩ ru ukhukhɔɔ amɛ̃ agbaashia azĩ ugar Ubetsaida, na asoyiwe ikikɔnga. ");
INSERT INTO ldb_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Unga aka asoyiwe umbɔ amaa, unga afũã igũ azĩã ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Urhɛɛ uku uwe, ukhukhɔɔ amɛ̃ hã uwe ra ateu ukau, unga awu ikiyikanga nu abĩ. ");
INSERT INTO ldb_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Unga anyã angwɛ̃ imesanga atɛ̃wã ikpikpayi, ugba ukɛnkpɔ umbɔ izĩ ra asu. Utsar ukpu akara ataar aki utsuu unga azĩã ru umbɔ, azɛ̃rhã afafã nu amɛ̃ ukau ha. Unga abee ifara umbɔ atɔng, ");
INSERT INTO ldb_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","bɔr umbɔ aka anyã unga azɛ̃rhã afafã nu ukau amɛ̃ hã, umbɔ atsar ugɛ awu imãrhã. Umbɔ atsu ivum, ");
INSERT INTO ldb_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Umbɔ aka anyã unga, umbɔ agbipa kishookambɔ. Kanying unga arherhe arherhe nggu umbɔ agɛ, <<Àka aker amɛnmbi! Awu umum. Niba agũmbi iwei!>> ");
INSERT INTO ldb_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Unga atsĩã ru ukhukhɔɔ nggu umbɔ, mɔcɛ ugbaka ukpekpɔ. Umbɔ adzeidzeu akarhãrhã, ");
INSERT INTO ldb_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","umbɔ asi ihwɛngmbɔ agben aki ubingha ukpu inera anakagɔnga atɔ̃ɔ̃ hã, ubinkutsu, amɛnmbɔ asi iyɛike. ");
INSERT INTO ldb_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Umbɔ aka agar ukau ha, umbɔ acipa ra abĩ Ujanisarat, abope ukhukhɔɔ amɛ̃ hã nu angwĩ ukau ukugɔng hã. ");
INSERT INTO ldb_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ubɛn umbɔ aka adzek ru ukhukhɔɔ amɛ̃ hã, kanying anera ahwɛngmbɔ ugɛ awu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Umbɔ atĩna adzeyiwa ra abĩmbɔ kishoo akũna abi irhãrhã ra afarmbɔ akũ azĩ kishoo ra anangkɛ Uyesu aka awe. ");
INSERT INTO ldb_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kishoo anangkɛ unga aka izĩ, iteu iki igɔng, use iteu iki ici, umbɔ angwɛ̃we abi irhãrhã ra angwĩ anang izɛɛ. Na ashɔ̃rhã unga ru abi irhãrhã hã abangu utɛm ibang atorhanga. Kishoo abirabɛ aka akpo ibibanga akerhumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Abi Ufarisi nu abɔɔ abika amesuwe Ikpem aka adzeku Urusharhima aba akɔng adziir Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Na anyã angwɛ̃ imesanga agha ubingha nggu abok arhim, asi isorhmbɔ abokmbɔ aka awu agbeyambɔ. ");
INSERT INTO ldb_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Abi Ufarisi nggu abi Uyahuda kishoo aka isaka asorh abokmbɔ akata na adɔrha agha ubingha, ubinkutsu awu ugau agbeyi akakũmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ivangyɛ umbɔ aka idzeki izɛɛ abvui aba ri iya, asi íghambɔ ubin, umbɔ awuri igbaashia adɔsa agbeyambɔ asorh ayormbɔ kata. Na asorh akpɛwa nu ídzum amɛ̃ nu atɛ̃rhĩ nu andzoma nu atseu. ");
INSERT INTO ldb_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nggee abi Ufarisi nu abika amesuwe Ikpem arhusu Uyesu agɛ, <<Awu use utsu angwɛ̃ imesango asi idɔsumbɔ ugau akakũ na anu igha abin nggu abok arhim?>> ");
INSERT INTO ldb_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Uyesu agɔr umbɔ agɛ, <<Irhikungge Uishaya aka asɔm Arherhu-Num ra atsimbi abi ukpukpeta agɛ, << <Aner abɛrɛ adzaa umum igɔng ra angwĩ, bɔr amɛnmbɔ aderke nggu umum. ");
INSERT INTO ldb_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Umbɔ adzaa umum igɔng ibɛm, anu imesuwe ikpem anera ugɛɛ Unum adzowe umbɔ.> ");
INSERT INTO ldb_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","<<Umbi aka atarkumbi ikpem Unum, umbi adɔsa agau anera.>> ");
INSERT INTO ldb_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na agɔr umbɔ agɛ, <<Umbi aka akpombi anang umbi aka angwɛ̃we Ikpem Unum ngge itsú umbi idɔsa agaumbi! ");
INSERT INTO ldb_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Umusa agɔr agɛ, <Udzowe imor ru utɛngo nu uyango,> nu <Ikɛi, uwuruwi aka arhenu utɛnga use uyanga, awu ufang umbɔ afɛre unga.> ");
INSERT INTO ldb_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bɔr umbi aka isaka agɔr agɛ unera aba agɔr utɛnga use uyanga agɛ, <Ubin hã uwu izũwã iyi Unum.> ");
INSERT INTO ldb_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Rimi hã, umbi akɛnmbi unga ikorhu ubɛn ubin ayike utɛnga use uyanga. ");
INSERT INTO ldb_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Rimi hã umbi afɔ̃rhũwe Arherhu-Num na adɔsa agbeyi ha umbi aki imesuwe angwɛ̃mbi. Ikɛi umbi aki ikorhe abin arhɛrhɛ ru nyaka ha.>> ");
INSERT INTO ldb_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ikɛi Uyesu ayisu ikikɔng hã iba ru unga agɔr umbɔ agɛ, <<Ubɛn unera akpeto ru umum, aka ahwɛng akɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Asi iwea abin awiya aki itsĩ ru unera atsu unga asi isara, abinkɛ aka idzeyiwa ra amɛn unera atsu unga asi isara ra asu Unum.>> ");
INSERT INTO ldb_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Unga aka asok ri ikikɔng hã na atsĩã ri iya, angwɛ̃ imesanga arhusa unga agben unyaka arherhe ha. ");
INSERT INTO ldb_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Unga agɔr umbɔ agɛ, <<Umbi adzuna? Umbi asi ihwɛngmbi ugɛ abinkɛ aka adzeka awiya atsĩ ru unera asi ítsu unga asi isara ra asu Unum? ");
INSERT INTO ldb_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Abin hã asi itsĩke ra amɛnnga bɔr atsĩ ra anaanga, na adzek ri iyornga.>> Ra arherhe akɛrɛ Uyesu adɛyiwe ugɛ abingha kishoo awu asarsatake. ");
INSERT INTO ldb_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Agɛ, <<Ubinkpi iki idzeyiwa ra amɛn unera awu ukpɔ utsu unga asi isara ra asu Unum. ");
INSERT INTO ldb_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ubinkutsu iwu ru unɔrkang amɛn unera, ifɛrhkɔ iyiki ibewe iki idzeyiwa, arhim irha ukutsɛrh use ukutsak, nu ivɛu, nu ifɛr uner nu itoma-dak, ");
INSERT INTO ldb_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","nu ikpona, nu iyiki ibewe, nu irhirhɛm, nu anyɔna, nu unyɛ̃ɛ̃ nu idakuwe itsok, nu iberi itsi nu ibemitsi, nu ikɛi ishera amɛn. ");
INSERT INTO ldb_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kishoo abin aka abewe akɛrɛ adzeyiwa ra amɛn unera, ake atsu unera asi isara ra asu Unum.>> ");
INSERT INTO ldb_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Uyesu abɔruka anang hã na asok azĩã abĩ Utaya nu Usidon. Atsĩ ri iya ikɔɔ asi ibeenga unera ahwɛng, rimi hã unga afɔr iwiwoi adaka. ");
INSERT INTO ldb_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Idzidzɛrhe, kanying utsɛrh uwɔɔ, uwuruwi ungwɛ̃rhũ unapunga aka awe ru ipfu iyiki ibewe aka agũ isarhe ri itsinga, aba agba ra adaknga. ");
INSERT INTO ldb_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Awu utsɛrh abĩ Uherhini, amar unga udiku ugbɛr uwu Ufinikiya. Unga ashɔ̃rhũ Uyesu ama atsũwe ipfu iyiki ibewe ru unapunga. ");
INSERT INTO ldb_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Uyesu agɔr unga agɛ, <<Uneke awɛkaci agbaashia agha kishoo ubinkpi umbɔ aka abee, ubinkutsu isi irhikungge umbɔ anyangu ubingha awɛkaci atsuke íjui.>> ");
INSERT INTO ldb_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Bɔr utsɛrh ha agɛ, <<Ĩĩ, Uteijee, bɔr ru adak utebur íjui iki isaki ighangge awushu ubingha aka idze ra abok awɛkaci agbei.>> ");
INSERT INTO ldb_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Uyesu agɔr unga agɛ, <<Iwu idzidzɛrhe, uzĩ ri iya, ipfu iyiki ibewe iki idzengge ru unapungo.>> ");
INSERT INTO ldb_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Unga abvui azĩ ri iya anyã unapa anu nu ukoma, ipfu iyiki ibewe iki idzengge ru unga. ");
INSERT INTO ldb_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mɔcɛ Uyesu adzek udiku ugbɛr Utaya adɔsu udiku Usidon, azĩã Ukau Ugarhirhi nu utsĩndĩ uku uzĩ iteu usɔka umbɔ iki iyisa Udikaforhi. ");
INSERT INTO ldb_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nggɔɔ ha umbɔ aka akowe unga uner igbau uwuku ufɔr arherhe adaka, umbɔ ashɔ̃rhã unga atsorhu ubok nu uner ha. ");
INSERT INTO ldb_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nggee Uyesu adarhu uner igbau ha akũ azĩã, adzeka ri ikikɔng hã, atsu itoknga ra ato utsak ha. Unga atar aci akũ abanguwe arhɛm utsak ha. ");
INSERT INTO ldb_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na abere arhi afafã agbiir uwoi ughorghotakpɔ, agɔr unga agɛ, <<Iffata!>> Agbena agɛ, <<Uyanga!>> ");
INSERT INTO ldb_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kanying unga aka arherhe rimi, ato utsak ha ayanga, urhɛmnga ugarhe unga atirhunga arherhe azezee. ");
INSERT INTO ldb_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Uyesu atsu umbɔ niba adɛyikumbɔ unera. Bɔr ubɛn unga aka ikɛn umbɔ, umbɔ anang adɛ̃ɛ̃ isɔme anera. ");
INSERT INTO ldb_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Anera agũ na adzeidzeu kishoo agɛ, <<Heee! Akorhe ubɛn abina azezerake. Atsu ugbau agũã arherhe, uwuku ufɔr arherhe, arherhe azezee.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ri inum hã anera abɔɔ arhɛrhɛ akɔng. Umbɔ aka ashimbɔ ru ubinkpi umbɔ aka igha, Uyesu ayisa angwɛ̃ imesanga umbɔ azĩ ru unga na agɔr umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","<<Umum igũ atorh anera abɛrɛ. Unum untaar nukpi umbɔ awu nggu umum na ashimbɔ ru ubingha. ");
INSERT INTO ldb_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Umum ĩba isoyikũ umbɔ azĩ ri iya nggu imerh, umbɔ awuri igbambɔ nu utsĩndĩ, ubinkutsu abɔɔ adzeki inang iyiki ider.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Angwɛ̃ imesanga agɔr unga agɛ, <<Umɛn ínyã ubingha ri inɛɛ ukpu umɛ̃ɛ̃ ighigha anera abɛrɛ ra arhum akɛrɛ?>> ");
INSERT INTO ldb_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Uyesu arhusa umbɔ agɛ, <<Umbi awe ru ípo uborodi isong?>> Umbɔ agɛ, <<Utɔɔva.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Unga agɔr ikikɔng hã iseisa abĩ. Ivangyɛ unga aka anyangu aborodi ha utɔɔva, atar uwɛɛ ru Unum, na atsɔka ake agasha adzise angwɛ̃ imesa umbɔ adene ru anera, umbɔ akorhe rimi hã. ");
INSERT INTO ldb_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Umbɔ awembɔ ru angwɛ̃rhã abɛrh ukunjiir, unga atar uwɛɛ ra ake ikɛi, unga agɔr umbɔ agashuwe ikikɔnga. ");
INSERT INTO ldb_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Anera agha ashur, angwɛ̃ imesa arhɔ̃ĩ akika abubɔr ake atɔk azĩnga utɔɔva. ");
INSERT INTO ldb_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Irhɛ anera aka agha, atsĩmbɔ anaka agɔnga anaa. Mɔcɛ Uyesu asoyika anera umbɔ azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kanying unga atsĩ ukhukhɔɔ amɛ̃ nu angwɛ̃ imesanga, azĩã abĩ Udarhmanuta. ");
INSERT INTO ldb_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Abi Ufarisi abɔɔ aba atirhi uning nggu Uyesu. Avira unga, umbɔ abee unga akorhuwe abin idzeu ake awu utsar ugɛ unga adzeka afã. ");
INSERT INTO ldb_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Unga agbɛr usepa ughoghor na agɛ, <<Awu use utsu umbi aner undan ukpirɛ abee inyã atsar? Umum indɛyiwa umbi idzidzɛrhe, utsar ushikpɔ umbɔ aka idɛyiwe ukpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mɔcɛ unga abɔruka umbɔ, atsĩ ukhukhɔɔ amɛ̃, agar azĩã ugar ukpɔrɔ. ");
INSERT INTO ldb_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Angwɛ̃ imesu Uyesu ayirukumbɔ asi ikũmbɔ uborodi. Akpurha awe ru ipoa unying ukpekũ ru ukhukhɔɔ amɛ̃ hã. ");
INSERT INTO ldb_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Uyesu agbiite atombɔ agɛ, <<Àka akpɔm amɛnmbi nggu uga abi Ufarisi nu uwu Uhiridu.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Angwɛ̃ imesa ha atirhi irherhe nggu adɔka agɛ, <<Arherhe rimi ubinkutsu umɛn iki isi ikũmɛn uborodi.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Unga ahwɛng arherhakɛ umbɔ aka arherhe, unga arhusa umbɔ agɛ, <<Awu use utsu umbi anu igɔr ugɛ umbi ashimbi ru uborodi? Utsɛku icɛrɛ umbi asi inyã ahwɛngmbi? Amɛnmbi awe ru igbau? ");
INSERT INTO ldb_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Umbi awu ra asu na asi inyãmbi, na awembi ra ato na asi igũmbi? Umbi asi iyitumbi, ");
INSERT INTO ldb_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ivangyɛ umum iki igashuwe anera anaka agɔnga atɔ̃ɔ̃ nggu aborodi atɔ̃ɔ̃? Azĩnga asong umbi aka akarha akika abɔr?>> Umbɔ agɛ, <<Usɔkdũmɛn.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","<<Ivangyɛ umum iki itsɔku ipo aborodi utɔɔva ha, umum iki igashuwe anera anaka agɔnga anaa, azĩng akagɔng asong umbi aka akarha atɔk?>> Umbɔ agɔr unga agɛ, <<Utɔɔva.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Unga agɔr umbɔ agɛ, <<Utsɛku icɛrɛ umbi asi ihwɛngmbi?>> ");
INSERT INTO ldb_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Umbɔ aka aba Ubetsaida, abɔɔ akũ uner ibvuta ashɔ̃rhũ Uyesu abangu uner ibvuta ha. ");
INSERT INTO ldb_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Unga adzur ubok uner ibvuta ha akũna unga adzek azĩã undzing utepa. Ivangyɛ unga aka ashapa aci ra asu utsak ha na atsorhu ubok nu unga, Uyesu arhusa agɛ, <<Ungo udɛ̃ɛ̃ unyãɔ ubin ukpɔɔ?>> ");
INSERT INTO ldb_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Unga abera asunga na agɛ, <<Inyãmum anera, umbɔ awu ru nyaka acucii iki izɛ̃rhã.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Uyesu abvui abanga asu utsak ha. Mɔcɛ utsak ha ayangi ikpor asunga ugeii, asunga akerhuke, unga anyã abina uku ushashaki. ");
INSERT INTO ldb_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Uyesu adene unga azĩã ri iya, agɛ, <<Niba ubvui uzĩɔ udiku utepa.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Uyesu nggu angwɛ̃ imesanga azĩmbɔ, atsĩrhĩ iteu iki ici iyi Ukaisariya Ufirhibi. Nu utsĩndĩ unga arhusa angwɛ̃ imesanga agɛ, <<Anera anu igɔr agɛ umum iwu ungamɔ?>> ");
INSERT INTO ldb_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Umbɔ agɔr unga agɛ, <<Abɔɔ agɛ ungo uwu Uyohana Uner Ubɔtisima, abɔɔ agɛ, ungo uwu uner uwuku usɔm Arherhu-Num Uirhiya, abɔɔ agɛ ungo uwu unying ra abika asɔm Arherhu-Num.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Unga arhusa umbɔ agɛ, <<Bɔr umbi agɔr ugɛ umum iwu ungamɔ?>> Ubitru agɔr unga agɛ, <<Ungo uwu Ukiristo.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Uyesu agbiite atombɔ utsur umbɔ adɛyikumbɔ unera ubinkpi unga aka awe. ");
INSERT INTO ldb_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Unga atirha amesuwe umbɔ agɛ, <<Ungwɛ̃-Ner awuri ihwa uver ra abina arhɛrhɛ nu akakũ nu ateiya abika adzowe idɛm-Num, nu abika amesuwe Ikpem, awuri ikpɛ̃mbɔ unga. Awuri ifɛre unga, ru unum untaar unga awuri isoka nggu urhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Arherhe akɛrɛ ha ra awiya. Nggee Ubitru adarha unga azĩ ri ifɛna atirhi itsɛrha unga. ");
INSERT INTO ldb_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bɔr Uyesu adzipa arhi angwɛ̃ imesa ha, atsɛrhu Ubitru agɛ, <<Usɔkɔ ru umum Ushaitan! Ungo uwu utarh ukpuku ukwɛr itok ru umum, ifɛrhkɔngo iwe ru nyaki iyi anera, isi iwengge ru nyaki iyi Unum.>> ");
INSERT INTO ldb_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mɔcɛ unga ayisa anera nu angwɛ̃ imesanga aba ru unga, unga agɔr umbɔ agɛ, <<Unera aba abeenga idɔsa umum, awu ufang unga akpɛ̃ɛ̃ itsinga na ashipu igãrhãmau ucuciianga adɔsa umum. ");
INSERT INTO ldb_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ubɛn unerwi aka abee ifɔrh urhɛnga, umgbɔ uwuri igwir, bɔr uwuku ugwirhuwe urhɛnga ru ubokmum nu Isarhe Iyiki Ize afufɔrh umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Izea iwu use unera akpo abin upfung kishoo na asi ikpoa urhɛnga? ");
INSERT INTO ldb_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Use unera awuri ikũ use ukpɔ uwe ifare urhɛnga? ");
INSERT INTO ldb_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Unera aba agũã atsakmum nu arherhamum ru udan ukpuku ushe irhirhika ukpirɛ ukpu itoma-dak nu arhim, Ungwɛ̃-Ner awuri igigũa atsak uner ha ri ivangyɛ unga aka iba ri ikpikpoi Utɛnga nggu ípfu itser-Num isarsatangge.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Unga agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, abɔɔ rabɔ adɛ̃ɛ̃ nggimi awuri inyãmbɔ ijee Iyɛrhe afã kata na adɔrha akpe.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Inuma utɔ̃ĩ iki imaa Uyesu akũ Ubitru, nu Uyaku, nu Uyohana, afũ igũ iyiki ider ikiyikambɔ. Umɔ iyor Uyesu idzipa iwiwengge ra asumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Atorhanga ikɛi awu akaterha uku upɛ̃rhɛ̃ng uku unyar-nyar, anangke isisorh unera ru upfung ukpirɛ. ");
INSERT INTO ldb_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mɔcɛ abika asɔm Arherhu-Num Uirhiya nu Umusa akapɛng ra asumbɔ, adɛ̃ɛ̃ arherhe nggu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ubitru agɔr Uyesu agɛ, <<A umarhem, azea umɛn iki iwe ri nggimi, uneke umɛn itar atsurha ataar, unying uwu ungo, unying uwu Umusa, unying uwu Uirhiya.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Unga asi ihwɛngnga ubinkpi unga aka arherhe, ubinkutsu umbɔ agũ iwei akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mɔcɛ amɛɛ adzek aba atsire umbɔ, urhɛm udzek ra amɛɛ ha, ugɔr ugɛ, <<Uwɛrɛ awu Ungwɛ̃mum, uwu umum iki ibema. Àka akpe ato ru unga!>> ");
INSERT INTO ldb_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kanying, umbɔ aka arhi adzipa, asi inyãmbɔ unera akpurha anyã Uyesu ikiyikanga nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Umbɔ aka azɛ̃rhã acipuwa ru igũ hã, Uyesu agbiite atombɔ ugɛ niba adɛyikumbɔ unera ubinkpi umbɔ aka anyã utsɛku Ungwɛ̃-Ner aka isoka akpe. ");
INSERT INTO ldb_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ngge itsu umbɔ angwɛ̃ arherhe ha ra amɛnmbɔ, na arhusa adɔkambɔ agɛ, <<Awu use uwu agben isoka akpe?>> ");
INSERT INTO ldb_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Umbɔ arhusa unga agɛ, <<Awu use utsu abika amesuwe Ikpem anu igɔr ugɛ awu ufang uner uwuku usɔm Arherhu-Num Uirhiya agbaashia aba?>> ");
INSERT INTO ldb_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Uyesu agɔr umbɔ agɛ, <<Awu idzidzɛrhe Uirhiya agbaashia aba agbishi ifɛrhɛ kishoo. Awu use utsu itsɛng igɔr igɛ awu ufang Ungwɛ̃-Ner ahwa uver urhɛrhɛ umbɔ akpɛ̃mbɔ unga? ");
INSERT INTO ldb_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Bɔr umum indɛyiwa umbi Uirhiya aka abanga, anera akorhuwe unga ubinkpi umbɔ aka abee, ru nyaka ngge iki itsɛng ri itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Uyesu nggu angwɛ̃ imesanga hã ikitatambɔ abvui aba ra angwɛ̃ imesanga, umbɔ anyã nggaa ikikɔng iki idzipa umbɔ nu abika amesuwe Ikpem adɛ̃ɛ̃ uning nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kanying umbɔ aka anyã Uyesu, kishoo ikikɔng hã idzedzeu akarhãrhã, asok atĩtser azĩ aghwe unga. ");
INSERT INTO ldb_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Uyesu arhusa angwɛ̃ imesanga agɛ, <<Umbi adɛ̃ɛ̃ uning use nggu umbɔ?>> ");
INSERT INTO ldb_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Uner uwɔɔ ri ikikɔng hã adzipuwe agɛ, <<A umarhem, nggawi umum ikũwã ungo ungwɛ̃mum, uwuruwi aka awe ru ipfu iyiki ibewe iki ikɛnngge unga arherhe. ");
INSERT INTO ldb_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ivangyɛ ngge iki isok ru unga, iki isaki itare unga ra abĩ. Itsu unga adzeyi ufuu ra angwĩnga, anu ishang anyĩ, iyornga idɛ̃ɛ̃ ikerketangge. Umum ĩgɔr angwɛ̃ imesango ama atsũwe, bɔr umbɔ afɔr adambɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Uyesu agɔr umbɔ agɛ, <<Umbi abi udan ukpirɛ, abika asheri imangmang, abi amɛn aka abewe. Umum iki isei ĩdãrhũmum nggu umbi, ukang umbi aka awe ru imangmang ru umum? Utsɛku ukang umum iki ibima nggu ida imangmangmbi? Ukũ ungwɛ̃ hã uba nggɛɛ ru umum.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nggee umbɔ akũ unga aba. Ivangyɛ ipfu iyiki ibewe iki inyã Uyesu, kanying ngge ikwɛr ungwɛ̃ hã iyornga izang. Unga agba agɔ̃rhã, ufuu ikɛi udzeyi ra angwĩnga. ");
INSERT INTO ldb_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Uyesu arhusu utɛ ungwɛ̃ hã agɛ, <<Ukang ifɛrhɛ ha iki itirhi ru unga?>> Utɛ ungwɛ̃ hã agɛ, <<Itirhi unga ana awu uwɛkuci ukunjiir. ");
INSERT INTO ldb_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Iki isaki itare unga ru urha, nu amɛ̃, ibee ifɛre unga. Bɔr ungo uba udɛ̃ɛ̃ ukorhukɔ ubin, uma ugũ atorh umɛn uma uyika umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Uyesu agɔr unga agɛ, <<Awu use utsu ungo urhusa ugɛ umum ĩba idɛ̃ɛ̃ imɛ̃mum? Ubɛn ifɛrhɛ iwengge ru uwuruwi aka awe ru imangmang.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kanying utɛ ungwɛ̃ hã atsarhi irhaknga agɛ, <<Umum iwemum ri imangmang, uma uyika umum ingbiki iwerangge!>> ");
INSERT INTO ldb_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Uyesu aka anyã ikikɔng hã iki itĩ iba, unga atsɛrhi ipfu iyiki ibewe ha agɛ, <<Ungo ipfu iyiki ibewe iyiki itsu igbau ni ikɛn arherhe, umum itsu ungo upfudzek ru unga, niba ubvui utsĩɔ̃ ru unga ikɛi!>> ");
INSERT INTO ldb_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ipfu iyiki ibewe ha itsu ivum, izung ungwɛ̃ hã mɔcɛ ngge idzekngge. Ungwɛ̃ hã anu ru nyaku ukom, nggee irhɛ anera igɔr ugɛ, <<Aka akpea.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bɔr Uyesu adzur uboknga aberuwe unga nu adaknga, unga asok adɛ̃ɛ̃. ");
INSERT INTO ldb_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Uyesu aka atsĩ ri iya, angwɛ̃ imesanga arhusa unga ikiyikambɔ agɛ, <<Awu use utsu umɛn isi idɛ̃ɛ̃ itsũwũkumɛn ipfu iyiki ibewe ha?>> ");
INSERT INTO ldb_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Uyesu agɔr umbɔ agɛ, <<Ikpũ idzidzek iyɛrɛ iwuri iwe ri ifɛn-Num ukpekũ.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Umbɔ asokmbɔ ra anang hã, azɛ̃rhã atɔng ru Ugarhirhi. Uyesu asi ibeenga anera ahwɛng anangkɛ umbɔ aka awe, ");
INSERT INTO ldb_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ubinkutsu anu imesuwe angwɛ̃ imesanga. Agɔr umbɔ agɛ, <<Awuri ighambɔ adak Ungwɛ̃-Ner adzowe unga ra abok anera. Umbɔ awuri ifɛre unga, inuma itaar iki itɔng unga awuri isoka.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bɔr umbɔ asi ihwɛngmbɔ agben arherhanga, na agũ iwei irhusa unga. ");
INSERT INTO ldb_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ivangyɛ umbɔ aka azĩ atsĩ Ukafanahum, ivangyɛ unga aka awe ri iya, unga arhusa umbɔ agɛ, <<Umbi adɛ̃ɛ̃ uning use ru utsĩndĩ?>> ");
INSERT INTO ldb_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bɔr umbɔ anukutata, ubinkutsu nu utsĩndĩ umbɔ adɛ̃ɛ̃ uning ugɛ ungaa awu uwuku ugɔnga ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Uyesu asei, na ayisa umbɔ usɔkdũmɛn hã, agɔr umbɔ agɛ, <<Ubɛn unera aka abee iwu ukugɔngmbi, awu ufang unga awu uwuku ucia, ikɛi na awu ugãrhãmbi kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Unga ashupu ungwɛ̃rhũ uwɛkuci atsu unga adɛ̃ɛ̃ ra ateumbɔ. Unga ashupa unga awuma ra aboknga, agɔr umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","<<Uwuku uyɛi ungwɛ̃rhũ uwɛkuci ru nyaku uwɛrɛ ri itsokmum, ayɛi umum nukpɔ, uwuruwi aka ayɛi umum ayɛi uwuku udena umum ĩba.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Uyohana agɔr unga agɛ, <<A umarhem, umɛn inyã uner uwɔɔ anu itsusuwe ipfu iyiki ibewe ri itsokngo, umɛn ikɛnmɛn unga, ubinkutsu asi iwea nggu umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bɔr Uyesu agɔr unga agɛ, <<Àka niba akɛnmbi unga. Unera asi íkorhunga ubin idzeu ri itsokmum amaa na arherhunga iki ibewe ri itsimum. ");
INSERT INTO ldb_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ubɛn unerwi aka asi ikpɛ̃ɛ̃ umɛn awu uwu umɛn. ");
INSERT INTO ldb_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Umum indɛyiwa umbi idzidzɛrhe, kishoo uwuku udzaa umbi ukpɛwa amɛ̃ aka ahwa ri itsokmum ugɛ umbi awu abi Ukiristo, umum indɛyiwa umbi idzidzɛrhe awuri ikpoa ugbɛtanga. ");
INSERT INTO ldb_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","<<Ubɛn uwuruwi aka itsu unying ra awɛkaci abika awe ru imangmang ru umum agba ra arhim, ugba umbɔ abope ukɔ igɔ ru urhɔk uner ha na atsuke unga ru ukau ukugɔng. ");
INSERT INTO ldb_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ubokngo uba utsu ungo ugbaɔ ra arhim, uzharhuwe ukpɔ. Azea ungo utsĩ urhɛ uwu ugbagbaa nggu uboka unying nu ungo uku ineke abokngo ikivarhake atsĩ idzũ urhakpi uku usi írhimkpɔ. ");
INSERT INTO ldb_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Udakngo uba utsu ungo igba ra arhim, uzharhuwe ukpɔ. Azea ungo utsĩ urhɛ uwu ugbagbaa nggu igbeta nu ungo iki itsĩ idzũ urhakpi uku usi írhimkpɔ nggu adakngo avaa. ");
INSERT INTO ldb_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ishaa usungo iba itsu ungo ugba ra arhim, uhoote ukpɔ. Azea ungo utsĩ Iyɛrhe Unum nggu usua unying nu ungo uku itsĩ ri idzũ urha nggu asu avaa. ");
INSERT INTO ldb_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Umɔ, << <Adzudzimbɔ asi íkpeke, nu urha ikɛi usi írhimkpɔ.> ");
INSERT INTO ldb_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","<<Asare anera kishoo nggu urha ru nyaka umbɔ aka ikũ angwã asare idɛm. ");
INSERT INTO ldb_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","<<Angwã aze, bɔr ake aba ashike ri itonga angwã, ungo ukorhu uguse nu utsu ake atonga ikɛi? Àka awe ra angwã ra atsimbi, na asei uku ughwɔɔw nggu adɔka.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mɔcɛ Uyesu asoka ra anang hã na azĩã ugbɛr uwu Uyahudiya agar Azɛ̃ Urdun. Ikɛi anera arhɛrhɛ abvui akɔng ru unga, unga amesuwe umbɔ ru nyaka unga aka abayi. ");
INSERT INTO ldb_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Abi Ufarisi abɔɔ aba avira unga, arhusa agɛ, <<Ri Ikpem imɛ̃ngge unera agau nggu utsɛ̃nga?>> ");
INSERT INTO ldb_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Uyesu agɔr umbɔ agɛ, <<Umusa atsu umbi akorhu use?>> ");
INSERT INTO ldb_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Umbɔ agɛ, <<Umusa agɔr umɛn agɛ unera awuri idɛ̃ɛ̃ atsɛng ubvur igau itsɛrh awayika utsɛ̃nga.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Uyesu agɔr umbɔ agɛ, <<Itsã itsimbi itsu Umusa atsɛnga umbi akɛrɛ ha. ");
INSERT INTO ldb_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bɔr ri inggbaashia <Unum amuna umbɔ ukutsak nggu ukutsɛrh.> ");
INSERT INTO ldb_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","<Nggee, unera awuri ineke utɛnga nu uyanga, na anyapa nggu utsɛ̃nga. ");
INSERT INTO ldb_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Umbɔ ikivarhambɔ awuri iwu iyora unying.> Nggee umbɔ asi iwembɔ ivaa bɔr awu iyora unying. ");
INSERT INTO ldb_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nggee, ubinkpi Unum aka agbopa, unera niba agashuka.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ivangyɛ umbɔ aka awu ri iya, ikɛi, angwɛ̃ imesa arhusu Uyesu arherhe ha. ");
INSERT INTO ldb_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Unga agɔr umbɔ agɛ, <<Ubɛn uwuku ugau itsɛrh nggu utsɛ̃nga na apfunu utsɛrh uwukuse, unga awu ra arhim itoma-dak ru unga. ");
INSERT INTO ldb_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Iwe rimi hã ukutsɛrh aba agau itsɛrh nggu utsaka, na azĩ itsɛrh uner uwukuse, unga atoma-dak.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Anera aka akũ angwɛ̃rhã awɛkaci aba ru Uyesu abanga umbɔ, bɔr angwɛ̃ imesanga atsɛrha umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Uyesu aka anyã rimi, avɔm afɛr unga. Unga agɔr umbɔ agɛ, <<Àka aneke angwɛ̃rhã awɛkaci aba ru umum, niba akɛnmbi umbɔ, Iyɛrhe-Num iwu iyi ikpũmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Umum indɛyiwa umbi idzidzɛrhe, ubɛn unera aka asi iyɛisa Iyɛrhe-Num ru nyaku uwɛkuci, asi ídɛ̃ɛ̃ atsĩã ri ngge.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Mɔcɛ unga ashupa awɛkaci ha ra aboknga awuma na atsorhe abok nu atsimbɔ na atsuke umbɔ idorh. ");
INSERT INTO ldb_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Uyesu atirhi isisok ra anang hã nukpi, utsak uwɔɔ atĩ aba, atararhu ra anangnga, arhusa unga agɛ. <<A umarhem uwuku uze, umum ikorhu use ni ikpo urhɛ uwu ugbagbaa?>> ");
INSERT INTO ldb_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Uyesu agɔr unga agɛ, <<Awu use utsu ungo uyisa umum uwuku uze? Uwuku uze ashia, Unum ukpekũ awu uwuku uze. ");
INSERT INTO ldb_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ungo uhwɛngo íkpem iyɛrɛ, <Niba ufɛrɔ unera, niba utomungo-dak, niba uvɛpɔ ivɛu, niba ugbɛrɔ angwĩ utsukukɔ unera, niba ughaɔ urha, udzowe igɔng ru utɛngo nu uyango.>>> ");
INSERT INTO ldb_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Uwɛdzɛm hã agɔr unga agɛ, <<A umarhem, umum iki idɔsumum akɛrɛ ha kishoo rimɔ̃ɔ̃ utirhi ri iwɛ̃nci.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Uyesu arhi unga na abema unga, agɔr unga agɛ, <<Ungo usheru ubina unying ukpekũ. Uzĩ, ugoshe abinngo kishoo, udzowe uhwɛka ra atsũwã, ungo uwuri iweɔ ru ugbɛta urhɛrhɛ ra afã, mɔcɛ uba udɔsa umum.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Igũ rimi itsu ungwɛ̃dzɛm hã ashepa asunga, azĩ nggu ida amɛn, ubinkutsu unga awu uner ubin akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Uyesu arhi adziir angwɛ̃ imesanga, agɔr umbɔ agɛ, <<Aghong abika awu ru ubin aki ikpo itsĩ Iyɛrhe Unum!>> ");
INSERT INTO ldb_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Angwɛ̃ imesanga adzeidzeu ra arherha ha. Uyesu ikɛi agɔr umbɔ agɛ, <<Umbi awɛkaci, aghong akarhãrhã unera atsĩ ri Iyɛrhe Unum! ");
INSERT INTO ldb_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ighɔrhungge urhakumi utsĩ atɔng ra angwĩ inepurha, nu uner ubin aka itsĩ ri Iyɛrhe Unum.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Angwɛ̃ imesa ha adzeidzeu akarhãrhã arhusa adɔka agɛ, <<Ungamɔ awuri idɛ̃ɛ̃ akpo ififɔrh?>> ");
INSERT INTO ldb_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Uyesu arhi umbɔ na agɛ, <<Ra anera ngge isi ímɛ̃ngge, bɔr ru Unum imɛ̃ngge. Ubɛn ubina umɛ̃ɛ̃kpɔ ra anang Unum.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ubitru agɔr unga agɛ, <<Nggayɛ umɛn ineke abina kishoo ni adɔsa ungo!>> ");
INSERT INTO ldb_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Uyesu agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, unera ashia uwuruwi aka neke iyanga, use angwɛ̃mbɔ use anapumbɔ use uyanga use utɛnga use awɛkacinga use icang irhamnga ri itsimum nu Isarhe Iyiki Ize, ");
INSERT INTO ldb_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","na asi ikpoa iya, angwɛ̃mbɔ, anapumbɔ, uya, awɛkaci nu icang irham idikunga unaka ru udan ukpirɛ, unga ikpoa uver ikɛi, ru upfung ukpuku uba unga ikpoa urhɛ uwu ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bɔr anera arhɛrhɛ aka awu abi inggbaashi, awuri iwu ãmaata. Ãmaata ikɛi, awuri iwu anggbaashi.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Umbɔ awu ru utsĩndĩ uwuku afũrhã azĩ Urusharhima. Uyesu agbaashia nu udĩ hã. Angwɛ̃ imesa adzeidzeu, nu abika adɔsa unga agũ iwei. Ikɛi unga ayisa angwɛ̃ imesanga usɔkdũmɛn hã ri ibanga adɛyiwe umbɔ ubinkpi iki ikorhe nggu unga. ");
INSERT INTO ldb_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","<<Nggayɛ umɛn izĩ ufã Urusharhima. Umɔ awuri ighambɔ adak Ungwɛ̃-Ner adzowe unga ra abok ateiya abika adzowe idɛm-Num, na abika amesuwe Ikpem. Awuri itsu unga ufai akpe na adzowe unga ra atsen abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Umbɔ awuri iyɛia unga na ashau aci atsuke ra asunga, awuri ikwɛre unga ugwɛɛ na afɛre unga. Inuma itaar iki itɔng unga awuri isoka nggu urhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mɔcɛ angwɛ̃ Uzabadi, Uyaku nu Uyohana, aba ru unga. Agɔr unga agɛ, <<A umarhem, umɛn ibee ungo ukorhuwa ubɛn ubina umɛn iki ifɛna ungo.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Unga arhusa umbɔ agɛ, <<Umbi abee umum ikorhuwa umbi use?>> ");
INSERT INTO ldb_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Umbɔ agɛ, <<Umɛn ishɔ̃rhã ungo neke unying ru umɛn asei nú ubok ughango, uwu uvaa asei nú ubok uferango ri ikpikpoingo.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Bɔr Uyesu agɔr umbɔ agɛ, <<Umbi asi ihwɛngmbi ubinkpi umbi aka arhusa. Umbi awuri idɛ̃ɛ̃ ahwambi ru ukpɛwa uverkpi umum iki ihwa, use umbi awuri idɛ̃ɛ̃ akorhumbi ikpũ ubɔtisima uverkpi umbɔ aka ikorhuwa umum?>> ");
INSERT INTO ldb_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Umbɔ agɛ, <<Ĩĩ, umɛn idɛ̃ɛ̃ ikorhumɛn.>> Uyesu agɔr umbɔ agɛ, <<Ĩĩ, umbi awuri ihwambi ru ukpɛwa umum iki ihwa na awuri akorhumbi ubɔtisima hã umbɔ aka ikorhuwa umum, ");
INSERT INTO ldb_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","bɔr isei nu ubok ughamum use ubok uferamum asi iwea umum ĩbemuwa. Inang iyɛrɛ iwu iyi abirabɛ umbɔ aka asɛng agbishuwe rimɔ̃ɔ̃.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ivangyɛ angwɛ̃ imesa ha usɔka aka agũ rimi, umbɔ agũ avɔm nggu Uyaku nu Uyohana. ");
INSERT INTO ldb_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Uyesu ayisa umbɔ ananga unying agɔr umbɔ agɛ, <<Umbi ahwɛngmbi ugɛ abirabɛ umbɔ aka anyanga umbɔ awu ayɛrhe atsen abi Uyahuda, anu idɛyiwe anera iyɛrhe, anggbaashimbɔ ikɛi anu ikũ ijee adarh umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bɔr isi íwengge rimi ru umbi. Ubɛn uwuku ubee igɔng ru umbi awu ufang unga awu ugãrhãmbi. ");
INSERT INTO ldb_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ikɛi ubɛn unera aka abee iwu unggbaashi, awu ufang unga awuri iwu ugãrhã ra anera kishoo. ");
INSERT INTO ldb_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ungwɛ̃-Ner asi ibanga umbɔ atɔ̃we unga itser, bɔr unga awuri iwu ugãrhã, na adzowe urhɛnga afɔrh anera arhɛrhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Uyesu nu angwɛ̃ imesanga aka azĩ atsĩ Ujeriko. Umbɔ nu anera arhɛrhɛ, awuri idze utepa, uner itapa agburh Ubartimawu agbena agburh <<ungwɛ̃ Utimawu,>> asei nu ubang utsĩndĩã anu ifɛn. ");
INSERT INTO ldb_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ivangyɛ unga aka agũ ugɛ Uyesu uner Unazarat unga atɔng, unga atsarhi irhaknga ayisa agɛ, <<Uyesu Ungwɛ̃ Udauda ugũ atorh umum!>> ");
INSERT INTO ldb_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Anera abɔɔ arhɛrhɛ atsɛrha unga agɛ, <<Unu ukutata!>> Bɔr unga agbisha atsarhi irhaknga akarhãrhã ayisa agɛ, <<A Ungwɛ̃ Udauda, uma ugũ atorh umum!>> ");
INSERT INTO ldb_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Uyesu atsurha adɛ̃ɛ̃ na agɛ, <<Àka ayisuwa unga.>> Umbɔ ayisu uner itapa ha, agɔr unga agɛ, <<Ugɔm! Usisok, ayisa ungo.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Unga atare untamanga, na akatasok ater isha, azĩã ru Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Uyesu arhusa unga agɛ, <<Ungo ubee umum ikorhuwa ungo use?>> Uner itapa ha agɛ, <<A Uteiya, umum ibee inyã anang.>> ");
INSERT INTO ldb_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Uyesu agɔr unga agɛ, <<Uzĩɔ. Imangmangngo ngge ikerhuwa ungo.>> Kanying unga ayɛisa inyĩnyãnga na adɔsu Uyesu umbɔ uzĩmbɔ nu utsĩndĩ. ");
INSERT INTO ldb_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Umbɔ aka aba akhapa ru Urusharhima ru Ubetafaji ru Ubetani Igũ Acucii Uzaitun, Uyesu adene angwɛ̃ imesanga avaa. ");
INSERT INTO ldb_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Agɔr umbɔ agɛ, <<Àka azĩ ru ungwɛ̃rhũ uteu ukpɔɔ ra asumbi, ubɛn itsitsĩmbi, umbi awuri inyãmbi ungwɛ̃ uzhika umbɔ aka abow, unera aka anasi ifũã umgbɔ. Àka agarha umgbɔ akũ aba. ");
INSERT INTO ldb_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Unera aba arhusunga umbi agɛ, <Awu use umbi akorhe rimi?> Àka agɔr unga agɛ, <Uteijee unga abeea umgbɔ unga awuri ibvui adene umgbɔ uba kanying.> >> ");
INSERT INTO ldb_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Umbɔ azĩ anyã ungwɛ̃ uzhika uku udɛ̃ɛ̃ ru ubang utsĩndĩã, ubow ra angwĩ iya. Umbɔ atirhi igarha umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Abirabɛ aka adɛ̃ɛ̃ umɔ arhusa umbɔ agɛ, <<Awu use utsu umbi agarhu ungwɛ̃ uzhika ha?>> ");
INSERT INTO ldb_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Umbɔ adzipa arherhe ubinkpi Uyesu aka adɛyiwe umbɔ. Aner ha neke umbɔ akũ ungwɛ̃ uzhika ha azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ivangyɛ umbɔ aka akũ ungwɛ̃ uzhika ha aba ru Uyesu na abɛtuwe antamambɔ nu undzingmgbɔ, Uyesu afũ asei nu umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Anera arhɛrhɛ abɛtuwe antamambɔ nu utsĩndĩã, abɔɔ agbɛyi ayerhe ri icang abɛtuwe nu utsĩndĩã. ");
INSERT INTO ldb_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Abika awu ra asunga na abika aba ra andzingnga atsui ivum agɛ, <<Ikpikpoi iwe ru Unum! Idorh iwe nggu unga aka aba ri itsok Uteijee! ");
INSERT INTO ldb_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Idorh iwe ri ibiba iyɛrhe utɛmɛn Udauda! Ikpikpoi iwe afafã ra afã.>> ");
INSERT INTO ldb_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Uyesu aka atsĩ Urusharhima, azĩã ri Iya-Num atsĩ arhisa abina kishoo. Nggayɛ unum uku utsĩkpɔ, nggee unga abvui adzek azĩã Ubetani nggu angwɛ̃ imesanga usɔkdũmɛn. ");
INSERT INTO ldb_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ukpe unum uvaa umbɔ aka asoku Ubetani, imerh ifɛr Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Unga aka anyã ucucii uvorhvo ukukaa uku ukpusha ayerhe udɛ̃ɛ̃, unga azĩa ibee ikpũrhã ru umgbɔ. Ivangyɛ unga aka azĩ atsĩ ru umgbɔ, unga asi ikpoa ubin, ayerhe ukpekũ ake akpusha adɛ̃ɛ̃, ubinkutsu, asi iwea ivang ikpũrhũ uvorhvo. ");
INSERT INTO ldb_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Mɔcɛ unga agɔr uvorhvo ha agɛ, <<Unera niba abvui aghaa ikpũrhãngo ugbagbaa!>> Angwɛ̃ imesa igambɔ agũmbɔ ubinkpi unga aka arherhe. ");
INSERT INTO ldb_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Umbɔ aka atsĩ Urusharhima, Uyesu atsĩ ri Iya-Num atirha awayiwe abika agoi igoi nu abika agugoyiwe umɔ. Akwɛr atsime atebur abika afaruwe uhwɛk nu anang isei abika agoyiwe anurhɛu. ");
INSERT INTO ldb_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Akɛna anera ikũ ubin ukpuku ugoiwe atɔng ra angwĩ Iya-Num. ");
INSERT INTO ldb_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Unga amesuwe anera agɛ, <<Itsɛng Arherhu-Num isi igɔrngge ugɛ, << <Awuri iyisi iyamum iya ifɛn-Num ri idũa kishoo?> Nggayɛ umbi atsu ike iwu utai uwoyi avɛu.>> ");
INSERT INTO ldb_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem aka agũ arherhe akɛrɛ umbɔ abee utsĩndĩ uwuku ufɛre unga, na agũ iwei unga ubinkutsu anera kishoo adzeidzeu imesanga. ");
INSERT INTO ldb_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Urhɛɛ uku uwe, Uyesu nu angwɛ̃ imesanga adzembɔ ru uteu ha. ");
INSERT INTO ldb_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ru ukpeeka, umbɔ aka atɔng, umbɔ anyã ucucii uvorhvo ha uku ukoyi kishoo nggu anunanga. ");
INSERT INTO ldb_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ubitru ayita na agɔr Uyesu agɛ, <<A umarhem, urhi unyã! Ucucii uvorhvo ha ungo uku utsuke ikponum hã uku usherhumgbɔ!>> ");
INSERT INTO ldb_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Uyesu agɔr umbɔ agɛ, <<Àka awe ru imangmang ru Unum! ");
INSERT INTO ldb_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Umum indɛyiwa umbi idzidzɛrhe, unera aba agɔr igũ iyɛrɛ agɛ, <Utang itsingo ugba ru ukau ukugɔng,> unga aba asi icicanga ra amɛnnga nu ubinkpi unga aka arherhe, na awea ri imangmang awuri ikorhukumbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nggee umum idɛyiwa umbi, ubɛn ubinkpi umbi aka ifɛna ru ifɛn-Num, aka awe ru imangmang ugɛ umbi aka akpombi ukpɔ, ukpɔ iwuri iwu ukpumbi. ");
INSERT INTO ldb_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ikɛi ubɛn ivangyɛ umbi aka idɛ̃ɛ̃ na afɛn-Num, umbi aba awembi ra avɔm nggu unera, àka atsũwe uner ha, nu Utɛmbi uwu afã atsũwã umbi ra arhimmbi.>> ");
INSERT INTO ldb_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Umbɔ aka abvui atsĩ Urusharhima, Uyesu atsĩ azɛ̃rhã ri irhɛrh Iya-Num nukpi, umɔ ateiya abika adzowe idɛm-Num, nu abika amesuwe Ikpem nu anggbaashi anera aba ru unga. ");
INSERT INTO ldb_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Agɔr unga agɛ, <<Ungo ukũ ijee iyikisong unu ikorhe ifɛrhɛ iyɛrɛ ha? Ikɛi ungaa adzaa ungo ijee iyiki ikorhi ifɛrha ha?>> ");
INSERT INTO ldb_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Uyesu agɔr umbɔ agɛ, <<Umum irhusa umbi ubina unying. Àka adzipuwa umum, umum idɛyiwa umbi umum ikũ ijee ungaa ikũ ikorha abin hã. ");
INSERT INTO ldb_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ubɔtisima Uyohana udzeka afã use udzeka anera? Àka adɛyiwa umum!>> ");
INSERT INTO ldb_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Umbɔ akɛki itsũwã nggu adɔkambɔ, agɛ, <<Umɛn iba igɔr ugɛ, <Udzek ra afã,> unga awuri irhusa umɛn agɛ, <Awu use utsu umbi ashimbi ri imangmang ru unga?> ");
INSERT INTO ldb_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bɔr umɛn iba igɔr ugɛ, <Udzek ra anera,> umɛn igũ iwei anera abɛrɛ, ubinkutsu, umbɔ anyangu Uyohana awu uner uwuku usɔm Arherhu-Num.>> ");
INSERT INTO ldb_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nggee umbɔ agɔr Uyesu agɛ, <<Umɛn isi ihwɛngmɛn.>> Uyesu agɔr umbɔ agɛ, <<Umum igamum isi ídɛyiwamum umbi umum ikũ ijee iyikisong ikorha abin hã.>> ");
INSERT INTO ldb_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Uyesu arherhe unyaka arherhe adzise umbɔ, agɛ, <<Utsa uwɔɔ akau icang inebi, adzin ufɔm adzipuwe icang hã, asim ughwee ri ifa ukpuku upayi amɛ̃ ikpũrhũ inebi ha, ikɛi atar akang utsurha udedetamgbɔ uwu idzɛu. Mɔcɛ unga atsu abɔɔ abi irham imang ri icang hã, na azĩã abĩ akase. ");
INSERT INTO ldb_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ivang iyiki ikɔng inebi ha iki iwe, unga adene ugãrhãnga azĩ ra abi irham imang ri icang hã, ayɛise ikpũrhũ inebi ri icang hã. ");
INSERT INTO ldb_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bɔr abi irham imang hã adzur ugãrhã hã, akwɛr unga, na awayiwe unga nggu abok aka atãrhã. ");
INSERT INTO ldb_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mɔcɛ unga adene ugãrhũ uwɔɔ, umbɔ akwɛr uwu ha ni itsia, na ayɛia unga. ");
INSERT INTO ldb_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Unga anang adene uwɔɔ, uwu ha umbɔ afɛrkumbɔ unga. Unga adene abɔɔ arhɛrhɛ, abi irham imang hã akwɛr abɔɔ, na afɛre abɔɔ. ");
INSERT INTO ldb_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","<<Unga abɔra unera unying unga aka idene, ungwɛ̃nga aka abema. Unga adene unga uwu imaataka, na agɛ, <Awuri idzowukumbɔ igɔng ru ungwɛ̃mum.> ");
INSERT INTO ldb_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","<<Bɔr abi irham imang hã agɔr adɔkambɔ agɛ, <Uwuku ugha ukam icang hã nuwi. Àka aba umɛn ifɛre unga, nu icanga iwu iyimɛn.> ");
INSERT INTO ldb_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nggee umbɔ adzur unga afɛre unga, na atare ukoma ru undzing ufɔm icang hã.>> ");
INSERT INTO ldb_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Uyesu arhusa umbɔ agɛ, <<Uner icang hã awuri ikorha aguse? Awuri iba atsĩme abi irham imang hã na adzowe icang hã ra abɔɔ. ");
INSERT INTO ldb_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Umbi aka avarhumbi ri itsɛng Arherhu-Num akirakɛ aka agɔr ugɛ, << <Utarhkpi abi idzin aka akpɛ̃, ukpɔ uwu utarh ãgboki idzin. ");
INSERT INTO ldb_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Uteijee ha unga akorha akɛrɛ, awu ubin igbigba ra asumɛn.>>> ");
INSERT INTO ldb_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Mɔcɛ umbɔ abee udĩ ukpuku udzur unga, ubinkutsu umbɔ ahwɛngmbɔ ugɛ arherhe unyaka arherhe ha iwu ra atsimbɔ. Bɔr umbɔ agũ iwei anera, ngge itsu umbɔ neke unga na azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Akɛrɛ aka amaa umbɔ adene abi Ufarisi abɔɔ nu aner Uhiridu umbɔ azĩ adeyi Uyesu ri irhɛm arherhanga. ");
INSERT INTO ldb_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Umbɔ aba agɔr unga agɛ, <<A umarhem, umɛn ihwɛngmɛn ungo urhiku uner. Anera kishoo awu ubina unying ru ungo, ubinkutsu amɛ̃ngo ashike nggu iwiwe uner, bɔr ungo umesuwe utsĩndĩ Unum ri idzidzɛrhe. Ungo unyã imɛ̃ngge umɛn ifase ikirbi abĩ ru Ukaisar use isi imɛ̃ngge? ");
INSERT INTO ldb_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Umɛn ifai use umɛn neke ififai?>> Bɔr Uyesu ahwɛnga ukpukpetambɔ. Unga agɔr umbɔ agɛ, <<Awu use utsu umbi andeya umum? Àka akũwã ishaa imang hã umbɔ iki ikũ afai ikirbi abĩ ru umum inya.>> ");
INSERT INTO ldb_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Umbɔ aka akowe ishaa imang hã, unga arhusa umbɔ agɛ, <<Uzirhzĩ ukpirɛ nu itsok ikɛrɛ iwu iki ungamɔ?>> Umbɔ agɛ, <<Iki Ukaisar.>> ");
INSERT INTO ldb_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Uyesu agɔr umbɔ agɛ, <<Àka adzowe Ukaisar ubin ukpunga na adzowe Unum ubin ukpu Unum.>> Umbɔ adzeidzeu akarhãrhã ru unga. ");
INSERT INTO ldb_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Abi Usaduki abɔɔ, abika agɔr agɛ isok ra akpe ishingge, aba ru Uyesu nggu irhirhusa. ");
INSERT INTO ldb_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Agɔr unga agɛ, <<A umarhem, Umusa atsɛnga umɛn ugɛ unera aba akpea na abɔre utsɛ̃nga ashia ra awɛkaci, awu ufang ungwɛ̃mbɔ anyangu utsɛ̃rhãpfu ha amare awɛkaci ru ungwɛ̃mbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Abɔɔ rabɔ utɔɔva awu angwɛ̃ uyi akatsak. Uwu inggbaashia apfuna, na akpe ashia ru ungwɛ̃. ");
INSERT INTO ldb_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Uwu uvaa ikɛi apfunu utsɛ̃rhãpfu ha, iganga akpea, ashia ru ungwɛ̃. Uwu untaar rimi hã. ");
INSERT INTO ldb_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Rimi hã kishookambɔ utɔɔva ha, asi ibɔrukumbɔ ungwɛ̃. Ri imimasha utsɛ̃rhãpfu ha ikɛi akpea. ");
INSERT INTO ldb_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ri isok ra akpe awuri iwu utsɛrha ungamɔ ru umbɔ? Ubinkutsu kishookambɔ utɔɔva apfunumbɔ unga.>> ");
INSERT INTO ldb_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Uyesu agɔr umbɔ agɛ, <<Umbi asi igbambi irhak umbi aka asi ihwɛngmbi itsɛng Arherhu-Num use ijeenga? ");
INSERT INTO ldb_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ivangyɛ abika akpukpe aka isok, asi ípfunumbɔ use adzowukumbɔ ipfuna, umbɔ awuri iwe ru nyaki ípfu itser-Num ra afã. ");
INSERT INTO ldb_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ra arherhi isok ra akpe, umbi anasi ivarhumbi akɛrɛ ha ru ubvur Umusa, ri isarhe ufum uku ugar urha? Unum aka agɔr Umusa agɛ, <Umum iwu Unum uwu Uibrahim, nu uwu Uishaku, nu ikɛi uwu Uyakubu.> ");
INSERT INTO ldb_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Unga asi iwea Unum uwu abika akpe, bɔr unga awu uwu abi urhɛ. Umbi agba irhak iki ibewe!>> ");
INSERT INTO ldb_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Utsa uwɔɔ uwuku umesuwe Ikpem aba agũ umbɔ adɛ̃ɛ̃ uning nggu adɔka. Unga aka agũ ugɛ Uyesu adzowe umbɔ irhɛm iyiki ize, unga arhusa unga agɛ, <<Kishoo ikpem, iyikisong iwu iki igɔnga?>> ");
INSERT INTO ldb_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Uyesu agɔr unga agɛ, <<Iki igɔnga iwu nggɛɛ agɛ, <Àka agũ umum umbi abi Uisrairha, Uteijee Unummɛn, awu Uteijee unying. ");
INSERT INTO ldb_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ubemu Uteijee Unumngo nggu amɛnngo kishoo, nggu urhɛngo kishoo, nu ihwihwɛngngo kishoo, nu nggu ikerngo kishoo.> ");
INSERT INTO ldb_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iyi ivaa ha igɛ, <Ubemu undɔkango ru nyaka ungo uku ubemi itsingo.> Íkpem iyɔɔ isi inangngge iyɛrɛ ha.>> ");
INSERT INTO ldb_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Uwuku umesuwe ikpem ha agɔr Uyesu agɛ, <<Ungo urhika ra arherhango uku urherhe ugɛ Unum awu unying uwɔɔ ashia bɔr unga. ");
INSERT INTO ldb_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ubema unga nggu amɛnngo kishoo, nu ihwihwɛngngo kishoo nu ikerngo, nu ubemu udɔkango ru nyaki itsingo, ananga izũwã iyiki ikpikpĩĩ nu idɛm-Num.>> ");
INSERT INTO ldb_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Uyesu aka agũ unga arherha arherhe itsoi, unga agɔr unga agɛ, <<Ungo uku ukhapungo nggu Iyɛrhe Unum.>> Mɔcɛ unera asi irhusunga ubin ukpɔɔ. ");
INSERT INTO ldb_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Uyesu aka adɛ̃ɛ̃ amesuwe ru ufɔm Iya-Num unga arhusa agɛ, <<Awu use utsu abika amesuwe Ikpem anu igɔr agɛ Ukiristo awu ungwɛ̃ Udauda? ");
INSERT INTO ldb_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Udauda nibikanga, ri ijee Ipfu Isarsatangge unga agɔr agɛ, << <Uteijee agɔr Uteijeemum agɛ, usei ru ubok ughamum, <<Utsɛku umum iki itsu anggamtsakngo ru andaidakngo.>> > ");
INSERT INTO ldb_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Udauda nibikanga ayisu Ukiristo agɛ, <Uteijee.> Awuri ikorha aguse ru Uteijee awu ungwɛ̃ ru Udauda?>> Nggaa ikikɔng anera ikpeto ru unga nggu itɛnamɛn. ");
INSERT INTO ldb_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ri imesanga, Uyesu agɔr agɛ, <<Àka akpɔm amɛnmbi nggu abika amesuwe Ikpem, umbɔ abee itsĩm atorho akagɔng azɛ̃rhã, abee anera aghwe umbɔ ri inang izɛɛ, ");
INSERT INTO ldb_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ikɛi umbɔ abee anera adzise umbɔ anang isei aka aze ra abã ifɛn-Num, nu anang isei aka aze ra anang irhowa. ");
INSERT INTO ldb_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Umbɔ awu abika aghawe abin atsɛ̃rhãpfu na avur ayambɔ, na adarhi ider ifɛn-Num iyi igbana. Ikpũ umbɔ awuri itsu umbɔ ufai akarhãrhã.>> ");
INSERT INTO ldb_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Uyesu asei ri ifɛna ra anangkɛ umbɔ iki itsu izũwã ri Iya-Num, azɛrhe anera iki itsuyiwe uhwɛk ri ijara izũwã. Abɔɔ abi ubin arhɛrhɛ atsu uhwɛk urhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mɔcɛ utsũwũ utsɛ̃rhãpfu uwɔɔ, aba atsuke ungwɛ̃rhĩ íshaa imang ivaa iki isi iwengge ubin. ");
INSERT INTO ldb_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Uyesu ayisa angwɛ̃ imesanga aba ru unga, agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, ubinkpi utsũwã utsɛ̃rhãpfu uwurɛ aka atsu ri ijara izũwã hã, inangngge iyimbɔ aka adzowe kishoo. ");
INSERT INTO ldb_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kishoo adzowe ra arhɛrha abinmbɔ aka awe, bɔr unga ri itsũwãnga, unga adzowe kishoo ubinkpi unga aka awe ra ukpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Uyesu adzeka ri Iya-Num nukpi, unying ra angwɛ̃ imesanga agɔr unga agɛ, <<A umarhem, urhi unyã nggaa atarh akɛrɛ, nu ídzin iyɛrɛ!>> ");
INSERT INTO ldb_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Uyesu agɔr unga agɛ, <<Ungo unyãɔ nggaa ídzin iyɛrɛ? Awuri isipuwe ngge kishoo. Asi ínekukumbɔ utarh unying nu undɔkakpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Uyesu asei ni itsi Igũ Acucii Uzaitun iki idɛ̃ɛ̃ ra asu Iya-Num. Ubitru, Uyaku, Uyohana nu Uandarawu arhusa unga ri iwɔk agɛ, ");
INSERT INTO ldb_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","<<Usɔma umɛn, ifɛrha ha ikorhu ukang? Utsara uwu uguse umbɔ aka inyã ri ivangyɛ ngge iki itirhi ikorhe?>> ");
INSERT INTO ldb_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Uyesu agɔr umbɔ agɛ, <<Àka arhi anyã, utsur unera arhɛma umbi. ");
INSERT INTO ldb_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Anera arhɛrhɛ aka idzeka ri itsokmum, anu igɔr agɛ, <Umum iwu unga,> umbɔ awuri irhɛm anera arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ivangyɛ umbi aka igũ isarhe iwa nu ugbugbewangge, niba asoyimbi amɛnmbi. Awu ufang akɛrɛ ha akorhe, bɔr imimasha ina ishingge kata. ");
INSERT INTO ldb_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Abi abĩ akɔɔ asok adɛ̃ɛ̃ igamtsak nggu abi abĩ akɔɔ, iyɛrhe iso idɛ̃ɛ̃ igamtsak nggu iyɛrhe. Abĩ awuri izizusa ri inanga irhɛirhɛ, nu ikpo imerh iwuri itsĩwãngge. Awu ititirhi uver imar. ");
INSERT INTO ldb_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","<<Awu ufang umbi adzɛu. Awuri ikũna umbi azĩ ra abi ijee iyɛrhe na akwɛr umbi ra abã ifɛn-Num. Awuri ikũna umbi azĩ ra asu anggbaashi nu ayɛrhe ri itsimum, ubinkutsu umbi awuri iwu idekamum ra asumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Awu ufang umbɔ aka igbaashia adzowe Isarhe Iyiki Ize ri idũa kishoo kata, ri imimasha idɔrhi iba. ");
INSERT INTO ldb_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ubɛn ivangyɛ umbɔ aka idzur umbi akũ azĩ ra aya ayɛrhe, àka niba agũmbi ighong ru ubinkpi umbi aka irherhe. Àka arherhu ubɛn ubinkpi umbɔ aka idzaa umbi ri ivang hã, ubinkutsu, asi íwea umbi irherhe ri ivang hã, awu Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","<<Ungwɛ̃yi awuri idzowe ungwɛ̃mbɔ umbɔ afɛre, utei ikɛi awuri idzowe ungwɛ̃nga. Awɛkaci ikɛi awuri iwu ri igamtsak nggu ateimbɔ utsɛku umbɔ aka itsu umbɔ afɛre umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Anera kishoo awuri ikpɛ̃na umbi ri itsokmum. Bɔr uwuku ubima utsɛku imimasha awuri ikpoa ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","<<Ivangyɛ umbi aka inyã ubin ishĩ ukpuku ukũ itsitsĩme udɛ̃ɛ̃kpɔ ra anangkɛ aka asi imɛ̃ke, abika awu ru Uyahudiya atĩrhã azĩ ri ígũ, neke uner uwuku uvarhe ahwɛng. ");
INSERT INTO ldb_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Uwuruwi aka awe ri itsi uvi niba acipuwanga inyãngu ubin ri iya. ");
INSERT INTO ldb_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Uwuruwi aka awe ra arhum ikɛi niba abvui abanga inyãngu untamanga. ");
INSERT INTO ldb_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Atorhmbi akatsɛrh abika awu ra ana nu abika akpɔm awɛkaci ri ivang hã! ");
INSERT INTO ldb_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Àka afɛn-Num utsur ifɛrhɛ ha ikorhungge ri idoyi. ");
INSERT INTO ldb_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ri ivang hã awuri ihwambɔ ayetnum akarhãrhã akirakɛ aka anasi ikorhuke udzur ri ivangyɛ Unum aka amunu upfunga, utsɛku icɛrɛ. Asi íbvui akorhumbɔ ikpũ hã ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Uteijee aba asi ishɔyika inum hã, unera unying asi íbɛka. Bɔr ru ubok abirabɛ unga aka asɛng, unga ashɔyika inum hã. ");
INSERT INTO ldb_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ri ivang hã unera aba agɔra umbi agɛ, <Àka anyã, Ukiristo uwi!> use <Àka anyã, nggawɔ!> niba awembi ri imangmang ra ake. ");
INSERT INTO ldb_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ukiristo igbɛrangwĩ nu abika asɔm Arherhu-Num igbɛrangwĩ awuri idzidzeka, awuri idɛyiwe atsar nu abin idzeu akũ arhɛm anera nggu abirabɛ Unum aka asɛng, umbɔ aba adɛ̃ɛ̃ amɛ̃ɛ̃mbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nggee, àka arhi! Umum iki idɛyiwamum abina kishoo ake adɔrha aba. ");
INSERT INTO ldb_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","<<Bɔr ri ivang hã, ayetnum akika aba ha aka imaa, << <awuri itsu ishaa unum iwu uzĩ. Ufɛ̃ ikɛi usi írhangmgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ídzɛɛr idzeka afã igbei. Ikɛi awuri izizusa nggaa abinkɛ aka awu afafã ra afã.> ");
INSERT INTO ldb_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","<<Mɔcɛ Ungwɛ̃-Ner aka icipuwa ra amɛɛ nggu nggaa ijee nu imor. ");
INSERT INTO ldb_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mɔcɛ unga awuri idene ípfu itsernga nggu atsom aki irhak ayisa, na awuri ikɔng abirabɛ umbɔ aka asɛng ra anggbokunga anaa, udiku igɔ̃kpee nu udiku urhɛɛ nu unɔr nu ufã, udzur ru ubandzin upfunga udiku ukpɛrɛ uzĩ udiku ukpɔrɔ. ");
INSERT INTO ldb_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","<<Àka amesu ubin ukpɔɔ ru ucucii uvorhvo. Umbi aba anyã aboke apfum adzeka nggu ayerhe aka afa, umbi ihwɛng ugɛ isung amɛka iki iyongge. ");
INSERT INTO ldb_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Rimi hã ikɛi umbi aba anyãmbi ifɛrhɛ iyɛrɛ itirhungge, umbi ahwɛng ugɛ ivanga iki iyongge, iki ibangge ra angwĩã. ");
INSERT INTO ldb_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Umum indɛyiwa umbi idzidzɛrhe, udan ukpirɛ usi ítɔngkpɔ utsɛku ifɛrhɛ ha kishoo iki ikorhe. ");
INSERT INTO ldb_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Afã nggu abĩ awuri itɔngke, bɔr arherhamum asi ítɔngke. ");
INSERT INTO ldb_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","<<Unera asi ihwɛnga unum hã use ivang hã, ípfu itser-Num ra afã isi ihwɛngngge, Ungwɛ̃-Ner asi ihwɛnga, Utɛ ukpekũ unga ahwɛng. ");
INSERT INTO ldb_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Àka arhi, àka agbisha adzɛu, ubinkutsu umbi asi ihwɛngmbi ivanga ngge iki ikorhe. ");
INSERT INTO ldb_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Awuri iwe ru nyaku uner uzɛ̃rhã. Ivangyɛ unga aka isok, unga idzowe iya ra agãrhãnga, ubɛn unera awea ri itsernga aka itɔ̃. Mɔcɛ unga aka itsu uner idzɛu, unga agbisha adzɛu. ");
INSERT INTO ldb_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","<<Nggee àka adɛ̃ɛ̃ adzɛu, ubinkutsu umbi asi ihwɛngmbi ivangyɛ uner iya ha aka ibvui aba, use ru urhɛɛka, use ri ikɔtsuuka, use ri ivang ikɔ iki igbɛr ukpee, use ru unkpeeka. ");
INSERT INTO ldb_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Utsur unga aba umbi asi ihwɛngmbi, unga akpo umbi awu ru urhɔ. ");
INSERT INTO ldb_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ubinkpi umum iki idɛyiwa umbi, umum indɛyiwe ubɛn unera, aka agbisha asei adzɛu!>> ");
INSERT INTO ldb_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Abɔr inuma ivaa umbɔ azek Irhowa Iyiki Igar Utɔng nu iyi Uborodi Ukpuku Usheru Uguga, ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem abee utsĩndĩwi umbɔ aka idzur Uyesu ri iwɔk afɛre unga. ");
INSERT INTO ldb_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Umbɔ anu igɔr agɛ, <<Bɔr asi íwea ri ivang irhowa, utsur anera awuri isoyi amɛnmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Uyesu awe ru Ubetani ri iya utsa uwɔɔ umbɔ iki iyisa Usiman uner ingbim, awuri igha ubingha nukpi, utsɛrh uwɔɔ aba nggu ungwɛ̃rhũ udzoma utɔk nggu atsei isung aki imang akarhãrhã aki ikũ unardi ayang. Unga ayar udzoma hã atsuke atsei ha ri itsi Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Abɔɔ aka awe umɔ agũ avɔm agɔr adɔkambɔ agɛ, <<Awu use utsu umbɔ atare atsei isung ha ibɛm rimi? ");
INSERT INTO ldb_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Uda umbɔ agoshe atsei ha atsĩke imang itser unera iyi amɛka, umbɔ aka idzowe atsũwã.>> Umbɔ atsɛrhu utsɛrh ha ri ifuw. ");
INSERT INTO ldb_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bɔr Uyesu agɛ, <<Àka aneke unga. Awu use utsu umbi arherha unga? Awu ubin uku uze unga aka akorhuwa umum. ");
INSERT INTO ldb_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Atsũwã awu nggu umbi ubɛn unum, umbi adɛ̃ɛ̃ ayikukumbi umbɔ ri ivangyɛ umbi aka abee. Bɔr umum iwuri iwe nggu umbi ivanga ukunjiir. ");
INSERT INTO ldb_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Akorhu ubinkpi ikernga iki imɛ̃. Adzukuwa atsei agbishi iyormum iyiki idzidzake. ");
INSERT INTO ldb_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Umum indɛyiwa umbi idzidzɛrhe, kishoo anangkɛ umbɔ aka idzowe Isarhe Iyiki Ize iyɛrɛ ru upfunga, awuri isɔmmbɔ ubinkpi utsɛrh uwurɛ aka akorhe umbɔ ayita unga.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mɔcɛ Uyahuda Uiskariyoti, unying ra angwɛ̃ imesa usɔkdũmɛn hã, azĩ ru ateiya abika adzowe idɛm-Num nu unga agha-dak Uyesu na adzowe ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Umbɔ aka agũ rimi umbɔ agɔm anggɔm na abemuwe unga uhwɛk. Nggee Uyahuda abee utsĩndĩã unga aka idzowe unga ru ubok. ");
INSERT INTO ldb_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ru unum ukpu inggbaashia ukpu Irhowu Uborodi Ukpuku Usheru Uguga, unum ukpuku ungwãni ungwɛ̃ itsurhi iyi Irhowa Iyiki Igar Utɔng, angwɛ̃ imesu Uyesu arhusa unga agɛ, <<Ri inɛ̃ɛ̃ ungo uku ubee umɛn izĩ ĩgbishuwa ungo igha Irhowa Iyiki Igar Utɔng?>> ");
INSERT INTO ldb_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nggee unga adene angwɛ̃ imesanga avaa, agɔr umbɔ agɛ, <<Àka atsĩ ru utepa, nggɔɔ umbi awuri igbopumbi utsak uwɔɔ aka atsã idzuma amɛ̃. Àka adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Iya ikɛ unga aka itsĩ, àka agɔr uteiya ha agɛ, <Umarhem arhusa ugɛ ubã atsen ungwɛ̃kpɔ, umum iki igha Irhowa Iyiki Igar Utɔng nggu angwɛ̃ imesamum?> ");
INSERT INTO ldb_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Unga awuri idɛyiwanga nggaa ubã afã ukpɔɔ umbɔ aka atsu abin iya amaambɔ. Àka igbishuwa ubinghamɛn umɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Angwɛ̃ imesa ha aka asok atsĩmbɔ ru utepa, anyã abina awe ru nyaku Uyesu aka asɔme umbɔ. Nggee umbɔ agbishu ubingha Irhowa Iyiki Igar Utɔng. ");
INSERT INTO ldb_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Urhɛɛ uku uwe, Uyesu nggu angwɛ̃ imesanga usɔkdũmɛn hã aba ri iya ha. ");
INSERT INTO ldb_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Awuri igha ubingha nukpi, Uyesu agɔr agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, unying ru umbi aka agha nggu umum awuri ighadak umum.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Amɛnmbɔ atirhuke igũ ighong, anu igɔr unga anyinganying agɛ, <<Asi iwea umum, use awu umum?>> ");
INSERT INTO ldb_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Uyesu agɔr umbɔ agɛ, <<Unying ru umbi usɔkdũmɛn hã, uwuruwi aka agha ri itɛ̃rhĩ unying nggu umum. ");
INSERT INTO ldb_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ungwɛ̃-Ner awuri ikpe ru nyaka umbɔ aka atsɛng ri itsinga. Bɔr atorh uner ha aka ighadak Ungwɛ̃-Ner! Ugba umbɔ asi imarmbɔ unga.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Umbɔ aka adɛ̃ɛ̃ igha ubingha, Uyesu anyangu uborodi, atar uwɛɛ ru Unum, abvũ adzowe ra angwɛ̃ imesanga agɛ, <<Àka ayɛi uwɛrɛ atãi. Awu iyormum.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na anyangu ukpɛwa amɛ̃ inebi, atar uwɛɛ ru Unum na adzowe ru umbɔ, kishoo ahwa ru umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Uyesu agɔr umbɔ agɛ, <<Akɛrɛ awu adzirhmum aki ibibemuwe-Num nggu anernga, aka idze ru ubok anera arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Umum indɛyiwa umbi idzidzɛrhe, umum isi íbvui ihwamum amɛ̃ inebi akɛrɛ utsɛku unumkpi umum iki ihwa akika afa akɔɔ ri Iyɛrhe Unum.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Umbɔ aka amaa itsũwe ubom ru Unum, umbɔ adzek azĩmbɔ Igũ Acucii Uzaitun. ");
INSERT INTO ldb_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Uyesu agɔr angwɛ̃ imesanga agɛ, <<Kishookambi awuri itĩ na abɔra umum ikiyikami, ru nyaki itsɛng Arherhu-Num iki igɔr igɛ, << <Umum ikwɛr uner uwuku udzɛu idɔi, idɔsa ikɛi iwuri isitungge.> ");
INSERT INTO ldb_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bɔr ivangyɛ umum iki isok ra akpe, umum inggbaashia izĩ Ugarhirhi ru umbi adɔrha atsĩ umɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ubitru agɔr unga agɛ, <<Kishoo aba atĩna na abɔrambɔ ungo, umum isi ínekamum ungo.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Uyesu agɔr unga agɛ, <<Umum indɛyiwa ungo idzidzɛrhe, irherɛ, ru untsua ukpirɛ, ungo uwuri itsɛyingo ihwɛng umum idiki itaar ni ikɔ idɔrhi igbɛr ukpee idiki ivaa.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bɔr Ubitru abvui arherhe akarhãrhã agɛ, <<Umbɔ aba awuri ifɛre umum nggu ungo, umum isi ítsɛyimum ihwɛng ungo.>> Kishoo angwɛ̃ imesanga arherhe rimi hã. ");
INSERT INTO ldb_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Azĩmbɔ anangkɛ umbɔ iki iyisa Ugetsemani, Uyesu agɔr angwɛ̃ imesanga agɛ, <<Àka asei nggimi umum izĩ ifɛn-Num.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Unga akũ Ubitru, nggu Uyaku nu Uyohana. Awu umɔ nukpi unga atirhunga igũ ighong akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Unga agɔr umbɔ agɛ, <<Igũ ighongyɛ iki iwe ra amɛnmum idɛ̃ɛ̃ ifɛrngge umum. Àka asei nggimi na adzɛu.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Unga aka azĩ ra asu ukunjiir, na agba nu abĩ, afɛn-Num ugɛ ngge iba imɛ̃ngge, umbɔ anyanguwe ivang ayetnum akɛrɛ ru unga. ");
INSERT INTO ldb_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Unga agɛ, <<Abba, Utɛ, ubɛn ubina imɛ̃ngge ru ungo. Unyanguwa ukpɛwa ayetnum akɛrɛ ru umum. Bɔr asi iwea ubinkpi umum iki ibee, bɔr awu ubinkpi ungo uku ubee.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mɔcɛ unga abvui aba anyã angwɛ̃ imesa ha ikitatambɔ awu ru urhɔ. Unga agɔr Ubitru agɛ, <<Ungo uwu ru urhɔ? Ungo usi idɛ̃ɛ̃ idzɛupɔ ukara unying? ");
INSERT INTO ldb_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Àka adzɛu na afɛn-Num utsur umbi agbambi ru undeya. Idzidzɛrhe ipfu ibemungge bɔr iyor isi ikerngge.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Abvui azĩa ifɛn-Num, arherhe irhɛm iyi inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mɔcɛ unga abvui aba ikɛi, akpo umbɔ awu ru urhɔ asumbɔ awu nggu urhɔ akarhãrhã. Umbɔ ashimbɔ nu ubinkpi umbɔ aka isɔme unga. ");
INSERT INTO ldb_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ivangyɛ unga aka abvui aba ide untaar, unga agɔr umbɔ agɛ, <<Umbi ana awu ru urhɔ nu iwiwosha? Iki imɛ̃ mɔnɔ! Ivanga iki ibangge. Unyã, umbɔ aka agha-dak Ungwɛ̃-Ner na atsuke unga ra abok abi arhim. ");
INSERT INTO ldb_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Àka asisok umɛn izĩmɛn! Uwuku ugha adakmum uwi aka abanga!>> ");
INSERT INTO ldb_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Uyesu awu ra arherhe nukpi, umbɔ anyã Uyahuda, unying ra angwɛ̃ imesanga usɔkdũmɛn hã. Unga aba nggu anera arhɛrhɛ aka akpɔm igbong nu akon akika ader. Ateiya abika adzowe idɛm-Num, abika amesuwe Ikpem nu akakũmbɔ aka adene umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Uyahuda, uwuku ugha adak Uyesu, aka asɔmuka umbɔ agɛ, <<Uwuruwi umum iki ishor atamnga, awu unga nuwɔ. Aka adzur akũ azĩ. Aka angwɛ̃dzɛn na adzɛu unga.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Uyahuda aka aba, unga adarha azĩã ru Uyesu, agɔr unga agɛ, <<A umarhem!>> na ashor atamnga. ");
INSERT INTO ldb_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Anera adzur Uyesu akpɔm unga uku ungbongbong. ");
INSERT INTO ldb_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Bɔr unying ra awɛ imesu Uyesu uwuku ukhapa ru unga, awɔɔr ikon iki idernga, azharhuwe uto ugãrhũ Ukugɔng Uwuku Udzowe Idɛm-Num. ");
INSERT INTO ldb_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Uyesu agɔr umbɔ agɛ, <<Umbi adzeka nggu igbong nu akon aka ader adzur umum ugɛ umum iwu uvɛu? ");
INSERT INTO ldb_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ubɛn unuma umum iwu nggu umbi ri Iya-Num imesuwa umbi, umbi asi idzurmbi umum. Bɔr awu ufang itsɛng Arherhu-Num itsuifɛr.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mɔcɛ kishoo angwɛ̃ imesa ha atĩ abɔre unga. ");
INSERT INTO ldb_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Uwɛdzɛm nuwɔ, atamu untama ukpekũ na adɔsu Uyesu. Ri ivangyɛ umbɔ aka adzur unga, ");
INSERT INTO ldb_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","unga aneke untamanga ra abokmbɔ na atĩ igbĩrhĩ. ");
INSERT INTO ldb_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Akũ Uyesu azĩ ru Ukugɔng Uwuku Udzowe Idɛm-Num, nu ateiya abika adzowe idɛm-Num, nu ikɛi abika amesuwe Ikpem nu akakũ akɔng. ");
INSERT INTO ldb_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ubitru adɔsa unga, bɔr ukukaa-ukukaa. Atsĩ ru ufɔm iya Ukugɔng Uwuku Udzowe Idɛm-Num. Umɔ unga aka asei iwɛr urha nggu adogerhi ha. ");
INSERT INTO ldb_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ateiya abika adzowe idɛm-Num nu kishoo abi udzepurhe abee ubinkpi uku iwe ideka ri itsi Uyesu, umbɔ afɛre unga, bɔr umbɔ asi ikpombɔ. ");
INSERT INTO ldb_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Anera arhɛrhɛ aka adzowe ideka igbɛrangwĩ, bɔr angwĩmbɔ asi iweke unying. ");
INSERT INTO ldb_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mɔcɛ abɔɔ asok adɛ̃ɛ̃, adzowe ideka igbɛrangwĩ ru unga agɛ, ");
INSERT INTO ldb_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","<<Umɛn igũ unga agɔr agɛ, <Umum iwuri isipuwe Iya-Num ikɛrɛ anera aka adzin, ni idzin ikɔɔ ri inuma itaar, ikirikɛ iki isi iwengge idzin unera.> >> ");
INSERT INTO ldb_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kishoo rimi hã idekambɔ isi iwengge unying. ");
INSERT INTO ldb_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mɔcɛ Ukugɔng Uwuku Udzowe Idɛm-Num asok adɛ̃ɛ̃ ra ateumbɔ, arhusu Uyesu agɛ, <<Ungo usi ídzipungo arherhe? Awu use uwe ri idekayɛ umbɔ aka adzowe ri itsingo?>> ");
INSERT INTO ldb_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bɔr Uyesu anukutata asi idzipuka, Ukugɔng Uwuku Udzowe Idɛm-Num hã abvui arhusa unga agɛ, <<Awu ungo uwu Ukiristo Ungwɛ̃ Uwu Idorh?>> ");
INSERT INTO ldb_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Uyesu agɔr unga agɛ, <<Awu umum. Ikɛi umbi awuri inyãmbi Ungwɛ̃-Ner aka isei nu ubok ugha Uwu Ijee, ikɛi awuri iba nu amɛɛ afafã ra afã.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ukugɔng Uwuku Udzowe Idɛm-Num hã avapuwe atorhanga, na agɛ, <<Umɛn ibee ideka iyikisong ikɛi? ");
INSERT INTO ldb_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Umbi agũmbi unga aka arhenu Unum! Awu use uwu itsũwãmbi?>> Anera kishoo arherhe agɛ, <<Agbaa! Afɛre unga!>> ");
INSERT INTO ldb_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mɔcɛ abɔɔ atirha ashau aci atsuyiwe unga, abope asunga, ikɛi akwɛre unga ugwɛɛ, anu igɔr unga agɛ, <<Udɛyiwa umɛn, ungaa akwɛr ungo!>> Mɔcɛ adogerhi abi udzepurhe ha akũ unga azĩmbɔ na akwɛr unga. ");
INSERT INTO ldb_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ubitru iganga awu unɔr ufɔm iya ha, unaa uwɔɔ ra anang itser Ukugɔng Uwuku Udzowe Idɛm-Num aba. ");
INSERT INTO ldb_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Unga aka anyã Ubitru aka asei iwɛr urha, unga angwɛ̃dzɛn na arhi unga, na agɛ, <<Ungo uwu nggu Uyesu uner Unazarat ha!>> ");
INSERT INTO ldb_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bɔr Ubitru atsɛyinga agɛ, <<Umum isi ihwɛng ubinkpi ungo uku urherhe.>> Unga aka arherhe rimi amaa, unga asok atsĩ ru udzepurhe iya ha. Kanying ikɔ igbɛr ukpee. ");
INSERT INTO ldb_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Unna hã aka abvui anyã unga umɔ, unga adɛyiwe abirabɛ aka adɛ̃ɛ̃ umɔ agɛ, <<Uwɛrɛ awu nggu umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ikɛi Ubitru abvui atsɛyinga. Ivanga ukunjiir iki itɔng, abirabɛ aka adɛ̃ɛ̃ akhapa ru Ubitru agɔr unga agɛ, <<Asi iwea ubin itsɛyi, ungo uwu nggu umbɔ, ungo usi iwea uner Ugarhirhi?>> ");
INSERT INTO ldb_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Mɔcɛ Ubitru atirhunga ifuw atsukuka ikponum nu itsinga, ayirh uyirh ra asumbɔ agɛ, <<Umum isi ihwɛng utsakwi umbi aka anu irherhe ri itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kanying ikɔ ibvui igbɛr ukpee ide uvaa. Mɔcɛ Ubitru ayita arherhe Uyesu aka adɛyiwe unga agɛ, <<Ungo itsɛyingo ihwɛng umum idiki itaar ri ikɔ idɔrhi igbɛr ukpee idiki ivaa.>> Ngge unga atsĩã iciu akpe. ");
INSERT INTO ldb_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ri igɔ̃kpeeka ateiya abika adzowe idɛm-Num nu akakũ, nu abika amesuwe Ikpem, nu kishoo abi itser udzepurhe akɛki itsũwã. Umbɔ abow Uyesu akũna unga azĩmbɔ ra asu Ubirhatu. ");
INSERT INTO ldb_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ubirhatu arhusa unga agɛ, <<Awu ungo uwu uyɛrhe abi Uyahuda?>> Uyesu agɔr unga agɛ, <<Ungo uku urherhungo.>> ");
INSERT INTO ldb_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ateiya abika adzowe idɛm-Num hã, agbɛyi urherhe atsuke unga ra abina arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ngge ikɛi Ubirhatu arhusa unga agɛ, <<Unyã arhɛrha abinmbɔ aka agbɛyi atsuka ungo. Ungo usi ídzipungo arherhe?>> ");
INSERT INTO ldb_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Bɔr Uyesu asi idzipunga arherhe. Ubirhatu adzeidzeu. ");
INSERT INTO ldb_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Icɛ awu ugau ugomna aka isaka atsũwe unerwi umbɔ aka abow ru ugborzĩ, uwuruwi anera aki ibee ru unum Irhowa Iyiki Igar Utɔng. ");
INSERT INTO ldb_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Uwɔɔ ruwɔ itsoka igburh Ubaraba, uvau isoyamɛn nu ifɛr uner itsu umbɔ agbange unga ru ugborzĩ hã nggu abɔɔ. ");
INSERT INTO ldb_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ikikɔnga iba ifɛn Ubirhatu unga akorhuwe ubin unga aka abayi ikikorhe. ");
INSERT INTO ldb_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Unga agɔr umbɔ agɛ, <<Umbi abee umum itsũwã Uyɛrha abi Uyahuda ru umbi?>> ");
INSERT INTO ldb_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Unga ahwɛnga agɛ awu unyɛ̃ɛ̃ utsu ateiya abika adzowe idɛm-Num atsuke Uyesu ru uboknga. ");
INSERT INTO ldb_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bɔr ateiya abika adzowe idɛm-Num atsu anera agɔr agɛ aneke Uyesu ru ugborzĩ, na atsũwe Ubaraba ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ubirhatu arhusa umbɔ agɛ, <<Umum iwuri ikorhe uguse nggu uwuruwi umbi iki iyisa Uyɛrhe abi Uyahuda?>> ");
INSERT INTO ldb_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Umbɔ atsarhi irhakmbɔ agɛ, <<Anyapuwe unga!>> ");
INSERT INTO ldb_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ubirhatu arhusa umbɔ agɛ, <<Awu use utsu? Ashɔyi use arherhunga?>> Umbɔ agbisha atsarhi irhakmbɔ agɛ, <<Anyapuwe unga!>> ");
INSERT INTO ldb_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ubirhatu aka abee itsu umbɔ agɔm unga, atsũwũka Ubaraba. Unga aka atsu umbɔ akwɛre ugwɛɛ ru Uyesu amaa, unga adzowuka unga umbɔ anyapuwe. ");
INSERT INTO ldb_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Abi iwa akũ Uyesu azĩ ru udzepurhe ugomna, umbɔ iki iyisa agɛ, <<Upiretoriyum.>> Na akɔng kishoo ukpui abi iwa ha. ");
INSERT INTO ldb_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Atsime atorho aka abãrhã akagɔng aki iyɛrhe nú Uyesu, ikɛi akare ifur iyɛrhe iyi ídidɔk, atsime ni itsinga. ");
INSERT INTO ldb_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Umbɔ atirhi ighwe unga agɛ, <<Urhɛngo uder, Uyɛrha abi Uyahuda!>> ");
INSERT INTO ldb_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ikɛi anu ikũ igbong akwɛr unga ni itsia, atang aci atsuyiwe ru unga. Na atangarhu agɛ umbɔ anu idzowe unga igɔng. ");
INSERT INTO ldb_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Umbɔ aka ayɛɛia unga rimi amaa, umbɔ atsimuwe atorho aka abãrhã akagɔng hã, na atsime atorhanga. Mɔcɛ umbɔ akũna unga adzek azĩmbɔ inyinyapuwe. ");
INSERT INTO ldb_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Utsa uwɔɔ adzeku Usayirin, itsoknga igburh Usiman utɛmbɔ Uarhekzanda nu Urhufɔ, adzek ri ibang abĩ hã na atɔng ru uteu ha. Umbɔ atsu unga inggang unga atsã igãrhãmau ucucii Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Akũ Uyesu azĩ ra anangkɛ umbɔ iki iyisa Ugorhgota, agbena agburh, <<Anang Apfupfu Aghow Itsi.>> ");
INSERT INTO ldb_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mɔcɛ umbɔ adzowe unga amɛ̃ inebi aka asarhe nggu isung, bɔr unga akpɛ̃ɛ̃ ihwihwaa. ");
INSERT INTO ldb_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mɔcɛ umbɔ anyapuwe unga. Umbɔ agasha atorhanga ra adɔkambɔ, atang isɛng ra atsimbɔ anyã ubinkpi ubɛn unera aka ikpo. ");
INSERT INTO ldb_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Awu ra akara utɔɔrha aki ukpee umbɔ aka inyapuwe unga. ");
INSERT INTO ldb_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Umbɔ atsɛng isarhe iyiki irhena unga agɛ, <<UYƐRHA ABI UYAHUDA.>> ");
INSERT INTO ldb_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Anyapuwe avɛu avaa nggu unga, unying nu ubok ughanga, uwu uvaa ikɛi nu ubok uferanga. ");
INSERT INTO ldb_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Anera aka atɔng, arhena unga, azung atsimbɔ agɛ, <<Ĩhĩĩ! Ungo iki isipuwe Iya-Num, nu udzine ike ikɛi ri inuma itaar, ");
INSERT INTO ldb_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ucipuwa ru igãrhãmau ucuciia ha ufɔrh itsingo!>> ");
INSERT INTO ldb_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Rimi hã ikɛi ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem ani iyɛɛia unga ra adɔkambɔ agɛ, <<Afɔrhuka abɔɔ, bɔr asi idɛ̃ɛ̃ afɔrha itsinga! ");
INSERT INTO ldb_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Uneke Ukiristo uwurɛ, uyɛrhe abi Uisrairha, acipuwa icɛrɛ ru igãrhãmau ucuciia uwurɛ, ru umɛn inyã ni iwe ru imangmang!>> Avɛu ha umbɔ aka anyapuwe nggu unga arherhu nggaa urhena atsuke unga. ");
INSERT INTO ldb_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ri idzingga atenuma, uzĩ itsirkpɔ abĩã kishoo, utsɛku akara ataar aki urhɛɛ. ");
INSERT INTO ldb_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ra akara ataar, Uyesu atsarhi irhaknga ikerketangge agɛ, <<Erhoi, Erhoi, urhama sabaktani?>> Agbena agburh, <<A Unummum, a Unummum, awu use utsu ungo uneka umum?>> ");
INSERT INTO ldb_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Abika adɛ̃ɛ̃ ukhapa umɔ aka agũ rimi, umbɔ agɛ, <<Àka agũ, unga adɛ̃ɛ̃ iyisu uner uwuku usɔm Arherhu-Num Uirhiya.>> ");
INSERT INTO ldb_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Unying ru umbɔ atĩ, azĩ abii usoso ra amɛ̃ inebi akika agbata, avaki igbong, abera adzowe ru Uyesu ahwa. Unga agɛ, <<Àka adidɛ̃ɛ̃! Umɛn inyãni use Uirhiya awuri iba acipuka unga.>> ");
INSERT INTO ldb_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Uyesu atsarhi irhaknga ikerketangge, atsu ivum na akpea. ");
INSERT INTO ldb_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Urhaburhe ha ukpuku uwe ru Iya-Num uvaar agbɛra avaa udzur afafã uba utsĩ ra abĩ. ");
INSERT INTO ldb_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ivang unggbaashi abi iwa uwuku udɛ̃ɛ̃ ra asu Uyesu aka anyã ikpũ akpea, umɔ unga agɔr agɛ, <<Icicang ishingge, utsak uwurɛ awu Ungwɛ̃ Unum!>> ");
INSERT INTO ldb_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Akatsɛrh abɔɔ adɛ̃ɛ̃ ukukaa na azɛrhe. Ru umbɔ ha awu umbɔ Umaryamu Umagadarha, nu Umaryamu uyisa Uyaku ungwɛ̃mbɔ Uyesu uku ucia nu Uyusuf, nu Usarhomi. ");
INSERT INTO ldb_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Umbɔ atirhi idɔsa unga ru Ugarhirhi anu itɔ̃ itser iyike unga. Akatsɛrh abɔɔ ikɛi arhɛrhɛ abika aba nggu unga azĩ Urusharhima awu umɔ. ");
INSERT INTO ldb_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Urhɛɛ uku uwe, umbɔ adɛ̃ɛ̃mbɔ igbisha abin udãã awu unum ukpuku uwosha. ");
INSERT INTO ldb_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Utsa uwɔɔ agburh Uyusuf uner Uarimatiya, unga awu ra abi itser ru udzepurhe, awea ri itsu amɛn ibiba Iyɛrhe Unum. Aker amɛn azĩ ru Ubirhatu ashɔ̃rhã unga adzowe iyor Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ubirhatu adzeidzeu unga aka agũ ugɛ Uyesu aka akpea. Unga ayisu unggbaashi abi iwa ha arhusa use awu idzidzɛrhe Uyesu aka akpe. ");
INSERT INTO ldb_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Unga aka agũ ra angwĩ unggbaashi abi iwa ha, mɔcɛ unga adzowuka ukom iyora ru Uyusuf. ");
INSERT INTO ldb_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nggee Uyusuf azĩ agoi atorho, acipu iyor Uyesu, akũ atorha ha abow iyor ha, atsuke ngge ru udzakkpi umbɔ aka atsɛ̃ɛ̃ ru utarh. Unga agɔ̃rhũ utarh ukpɔɔ afɔme angwĩ udzak ha. ");
INSERT INTO ldb_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Umaryamu uwuku udzeku Umagadarha nu Umaryamu uyisa Uyusuf adɛ̃ɛ̃ azɛrhe anangkɛ umbɔ aka angwɛ̃we iyor Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Unum ukpuku Uwosha uku utɔng, Umaryamu Umagadarha nu Umaryamu uyisa Uyaku, nu ikɛi Usarhomi, agoi abin isung akirakɛ umbɔ aka izĩ adzukuwe ri iyor Uyesu. ");
INSERT INTO ldb_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ru unum ukpu inggbaashia ri inuma utɔɔva, ru ukpeeka ri ivangyɛ ishaa unum iki idzek, umbɔ atirhumbɔ izĩ ru udzaka. ");
INSERT INTO ldb_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Umbɔ aka awu ru utsĩndĩ, umbɔ agɔr adɔkambɔ agɛ, <<Ungamɔ awuri igɔ̃rhuwe utarha ra angwĩ udzaka?>> ");
INSERT INTO ldb_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bɔr umbɔ aka azĩ atsĩ umɔ, umbɔ abera asumbɔ anyã nggaa utarh ha uku ugɔ̃rhũkpɔ. ");
INSERT INTO ldb_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Umbɔ aka atsĩ ru udzaka, umbɔ anyã uwɛdzɛm aka atsim atorho aka aterha asei udiku ubok ugha, umbɔ agũ iwei. ");
INSERT INTO ldb_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ungwɛdzɛm hã agɔr umbɔ agɛ, <<Àka niba agũmbi iwei. Umbi abee Uyesu uner Unazarat uwuruwi umbɔ aka anyapuwe. Aka asoka! Ashia nggimi. Àka anyã anangkɛ umbɔ aka angwɛ̃we unga. ");
INSERT INTO ldb_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Àka azĩ adɛyiwe angwɛ̃ imesanga nu Ubitru, unga agbaashia azĩ Ugarhirhi ru umbi. Nggɔɔ ha umbi aka inyã unga, ru nyaka unga aka asɔma umbi.>> ");
INSERT INTO ldb_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Akatsɛrh ha atĩ adzek ru adzak ha, adzunumbɔ na azang ayormbɔ, asi irherhumbɔ arherhe nggu unera, ubinkutsu umbɔ agũ iwei. ");
INSERT INTO ldb_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ivangyɛ Uyesu aka asoka akpe ru unkpeka ru unum ukpu inggbaashia ri inuma utɔɔva, agbaashia adzeka ru Umaryamu Umagadarha, utsɛrh ha Uyesu aka atsũwe ípfu iyiki ibewe utɔɔva. ");
INSERT INTO ldb_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Unga azĩ asɔme abirabɛ aka awu nggu Uyesu, umbɔ agũ ighong na aciu akpe. ");
INSERT INTO ldb_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Umbɔ aka agũ ugɛ Uyesu aka asoka nggu urhɛ, ikɛi unga nibikanga anyã Uyesu, umbɔ asi ibemumbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Akɛrɛ aka amaa Uyesu adzipa adzeka ru nyaku uner uwɔɔ ra angwɛ̃ imesa abɔɔ avaa ri ivangyɛ umbɔ aka azɛ̃rhã adzek ru uteu ha adɔsu utsĩndĩã azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ikivarhambɔ abvui aba asɔme abimbɔ, bɔr utsɛku icɛrɛ umbɔ ashimbɔ ri imangmang ri isarhe ha. ");
INSERT INTO ldb_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ri imaatak Uyesu aka adzeka ru umbɔ usɔka nu unying hã ri ivangyɛ umbɔ aka asei igha ubingha. Unga atsɛrha umbɔ ri ida imangmangmbɔ, nu iker itsimbɔ, umbɔ aka asi ibemumbɔ arherhe abirabɛ aka agbaashia anyã unga ri isisoknga. ");
INSERT INTO ldb_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ikɛi unga agɔr umbɔ agɛ, <<Àka atsĩ ru upfunga kishoo adzowe Isarhe Iyiki Ize ra anera kishoo. ");
INSERT INTO ldb_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ubɛn unera aka awea ri imangmang, umbɔ asorhukumbɔ unga ubɔtisima, awuri ikpikpoa ififɔrh, bɔr ubɛn unera aka akpɛ̃ɛ̃ iwe ru imangmang awuri itsitsĩm. ");
INSERT INTO ldb_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Atsar akɛ aka idɔsa abika awuri imangmang, ri itsokmum, umbɔ awuri itsũwũkumbɔ ípfu iyiki ibewe, awuri irherhumbɔ idũ iyiki ifa. ");
INSERT INTO ldb_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Awuri inyãngumbɔ íbvui ra abokmbɔ, ikɛi umbɔ aba ahwambɔ umau, ake asi íkorhuke ubin ru umbɔ. Umbɔ aba atsorha abokmbɔ ra abi irhãrhã, umbɔ awuri ikerhumbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Uteijee Uyesu aka amaa irherhuwe umbɔ arherhe ha, ashupa unga akũ afũmbɔ ra afã, unga aseisa nu ubok ugha Unum. ");
INSERT INTO ldb_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mɔcɛ angwɛ̃ imesanga adzek adzise isarhe ubɛn ananga, Uteijee atɔ̃ itser nggu umbɔ, akorha abin idzeu atsu arherhambɔ awu idzidzɛrhe.");
INSERT INTO ldb_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Anera arhɛrhɛ aka atsu amɛnmbɔ atsɛng isarhe abinkɛ aka atsuafɛr ru umɛn. ");
INSERT INTO ldb_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Atsɛng abinkɛ umɛn iki igũ ra angwĩ abika anyã abin hã ra asumbɔ ri inggbaashia na awe agãrhã isarhe Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nggee, a uteiya Utiyofirhu, umum iki ingwɛ̃dzɛn ni irhisa abina kishoo aka atirhi ri inggbaashia, umum inyã azea ikɛi umum itsɛnga ungo agbɛgbɛra. ");
INSERT INTO ldb_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ngge itsú ungo uma uhwɛng idzidzɛrhe abinkɛ umbɔ aka amesuwa ungo. ");
INSERT INTO ldb_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ri ivang Uhiridu aka awu uyɛrhe Uyahudiya, uwuku udzowe idɛm-Num nuwɔ agburh Uzakariya, awe ru ukpui Uabija. Utsɛ̃nga Uarhisabatu ikɛi awu unang Uharuna. ");
INSERT INTO ldb_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Uzakariya nggu Uarhisabatu arhika ra asu Unum, adɔsi Ikpem Uteijee kishoo asi igbambɔ. ");
INSERT INTO ldb_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bɔr umbɔ ashimbɔ nu ungwɛ̃, ubinkutsu Uarhisabatu awu ukpirh, umbɔ ikivarhambɔ aka akɔ̃mbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ivanga niyɔ ukpui ukpumbɔ Uzakariya awe ri itser, nu Uzakariya atɔ̃ itser iyi uner uwuku udzowe idɛm-Num ra asu Unum. ");
INSERT INTO ldb_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ru nyaka umbɔ aki itang avii asɛng abika adzowe idɛm-Num, umbɔ asɛng Uzakariya azĩ akpĩĩ abin isung ri Iya Uteijee. ");
INSERT INTO ldb_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ivang iyiki ikpĩĩ abin isung hã iki iwe, anera abika adzowe igɔng ru Unum akɔng ru awiya anu ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mɔcɛ ipfu itser Uteijee ha akapɛɛng ra asunga, idɛ̃ɛ̃ udiku ubok ugha ubeu isung hã. ");
INSERT INTO ldb_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ivang Uzakariya aka anyã unga, unga agbipa, iwei ifɛr unga. ");
INSERT INTO ldb_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bɔr ipfu itser-Num hã igɔr unga igɛ, <<A Uzakariya, niba ugũo iwei, aka agũmbɔ ifɛn-Numngo. Utsɛ̃ngo Uarhisabatu awuri imara ungo uwɛkutsa, ungo utar itsoknga igburh Uyohana. ");
INSERT INTO ldb_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Unga awuri iwu ubin anggɔm nu itɛnamɛn ru ungo, imarnga iwuri itsu anera arhɛrhɛ agɔm anggɔm. ");
INSERT INTO ldb_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Unga awuri iwu uner ukugɔng ra asu Uteijee. Awu ufang unga asi íhwaa adɛ nu abin aka atsu afĩrhã, awuri itsuke unga Ipfu Isarsatangge ri imarnga. ");
INSERT INTO ldb_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Anera arhɛrhɛ ru Uisrairha unga awuri idzipa umbɔ azĩ ru Uteijee Unummbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Unga awuri inggbaashia azĩ ru Uteijee ha, ri ijee ipfu ru nyaki iyi Uirhiya, awuri itsu amɛn atei adzipa awe nggu angwɛ̃mbɔ na adzipa abi iker itsi umbɔ adɔsi itsoi abika arhurhika na atsu anera agbishi isiseimbɔ nggu Uteijee.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Uzakariya arhusu ipfu itser-Num hã agɛ, <<Umum ikorhu uguse ni ihwɛng rimi hã? Umumwi iki ikɔ̃mum, nu imɛk utsɛ̃mum iyɛ iki irhɛirhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ipfu itser-Num hã igɔr unga igɛ, <<Awu umum Ujibrairhu. Umum idɛ̃ɛ̃ ra asu Unum, awu unga adena umum ĩba irherha arherhe nggu ungo ni idɛyiwa ungo isarhe iyiki ize iyɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ungo ucɛrɛ, unu ukutata usi ídɛ̃ɛ̃ urherhungo arherhe utsɛku unumkpi akɛrɛ ha aka ikorhe, ubinkutsu ungo ushiɔ ru imangmang ru irhɛm arherhamum, arherha ha awuri iweke ri ivangyɛ ngge iki imɛ̃ ngge iwe.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ri ivang hã, anera aka adɛ̃ɛ̃ adzɛu Uzakariya adzeidzeu ri ididãrhãnga ri Iya-Num. ");
INSERT INTO ldb_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Unga aka adzeka, unga afɔr irherha arherhe adaka nggu umbɔ. Umbɔ adiki ihwihwɛng agɛ anyãã irhi ri Iya-Num, ubinkutsu unga akpurha akũ aboka akorhu utsara na afɔr irhirherhe adaka. ");
INSERT INTO ldb_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ivang itsernga iki imaa, unga abvui azĩã ri iya. ");
INSERT INTO ldb_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Inum hã iki imaa, utsɛ̃nga Uarhisabatu adzur anaa, afɛ̃ɛ̃ atɔ̃ɔ̃ asei ri iya, anera asi ihwɛngmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Uarhisabatu agɛ, <<Uteijee akorhuwa umum rimi. Ri inumyɛ unga aka amutuwa umum na atsũwã atsak ru umum ra asu anera!>> ");
INSERT INTO ldb_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Anaa Uarhisabatu awu ru ufɛ̃ uwu utɔ̃ĩ, Unum adene ipfu itser-Num Ujibrairhu izĩ uteu Unazarat ra abĩ Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Azĩ ru unakugbĩrhĩ anasi ihwɛngnga ukutsa aka awu ukarh unerwi aka agburh Uyusuf, unang Udauda. Itsok unakugbĩrhĩ hã igburh Umaryamu. ");
INSERT INTO ldb_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ipfu itser-Num hã izĩ igɔr unga igɛ, <<Umum ighwe ungo unamata ukugɔng, Uteijee awu nggu ungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Amɛn Umaryamu agũ ighong akarhãrhã ru urhɛm ighwe ha, na akaifɛrhkɔ ugɛ awu use ighwea iwe rimi. ");
INSERT INTO ldb_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Bɔr ipfu itser-Num hã igɔr unga igɛ, <<A Umaryamu, niba ugũa iwei. Unum unga amutuwa ungo. ");
INSERT INTO ldb_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ungo uwuri ikɔ̃ anaa umar ungwɛ̃, nu utar itsoknga igburh Uyesu. ");
INSERT INTO ldb_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Unga awuri iwu ukugɔng na awuri iyisa unga Ungwɛ̃ Nggaa Uwuku Ugɔng. Unum Uteijee awuri idzowuka unga anang isei iyɛrhe utɛnga Udauda, ");
INSERT INTO ldb_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","nu unga awuri iwu uyɛrhe iya Uyakubu ugbagbaa, iyɛrhanga isi ímaangge.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Umaryamu arhusu ipfu itser-Num hã agɛ, <<Ifɛrha ha ikorhi iguse ni iwe? Umum uwi inasi ihwɛng ukutsa.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ipfu itser-Num hã igɔr igɛ, <<Ipfu Isarsatangge iwuri icipuwa ru ungo, nu ijee iyi Nggaa Uwuku Ugɔng itsira uzirhzĩnga nu ungo. Ngge itsú usarkasar ungwɛ̃ hã ungo uku imar awuri iyisa unga Ungwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nggayɛ unapumbi Uarhisabatu awu ra anaa uwɛkutsa afɛ̃ɛ̃ utɔ̃ĩ nggu ikɔ̃nernga, umbɔ iki iyisa unga ukpirh. ");
INSERT INTO ldb_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ubin usi ínangkpɔ Unum.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Umaryamu agɛ, <<Umum iwu ugãrhũ Uteijee. Uneke ifɛrha ha iwe ru umum ru nyaka ungo uku ugɔr.>> Mɔcɛ ipfu itser-Num hã ibɔrukungge unga. ");
INSERT INTO ldb_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ivang hã Umaryamu asok iki ifefetem azĩã ri igũ abĩ Uyahudiya. ");
INSERT INTO ldb_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Unga atsĩ ri iya Uzakariya na aghwe Uarhisabatu. ");
INSERT INTO ldb_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Uarhisabatu aka agũ ighwe Umaryamu, irheng ungwɛ̃ iso iniir ra ananga. Uarhisabatu awu nggu Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Unga atsu ivum agɛ, <<Ungo uwe ru idorh ru akatsɛrh, nu idorh iwe nggu ungwɛ̃wi ungo iki imar! ");
INSERT INTO ldb_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Awu use utsu umum ikpo umata rimi, uyisa Uteijeemum asok aba ru umum? ");
INSERT INTO ldb_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ivangyɛ umum iki igũ irhak ighwengo ra atomum, irheng ungwɛ̃ ra anaamum iso idɛ̃ɛ̃ anggɔm. ");
INSERT INTO ldb_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Idorh iwe nggu unga, aka awe ru imangmang agɛ arherhu Uteijee aka arherhe nggu unga awuri itsuafɛrke.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Umaryamu agɛ, <<Ipfumum ikpoi Uteijee ha, ");
INSERT INTO ldb_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nu ipfumum igɔmanggɔm Unum aka awu uwuku ufɔrh umum, ");
INSERT INTO ldb_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","unga aka ayita umum utsũwũ ugãrhãnga! Utirhi icɛrɛ undana kishoo awuri iyisa umum uner idorh, ");
INSERT INTO ldb_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ubinkutsu Uner Igɔng hã aka akorhe abin akagɔng ru umum. Itsoknga isarsatake. ");
INSERT INTO ldb_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Atorhnga atɛ̃rhã ru undana kishoo, ra abika agũ iwei unga. ");
INSERT INTO ldb_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Unga aka akũ aboknga akorhi ifɛrhɛ iyiki igɔng. Unga aka asituwe abi aberi itsi ri ifɛrhkɔmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Unga aka acipuwe ayɛrhe ra anang iseimbɔ, na aberuwe abika arhɛrhi itsi afafã. ");
INSERT INTO ldb_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Unga aka atsu abi imerh ashuurmbɔ nggu abin aka aze, na adene abi ubin nggu abok akatãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Unga aka ayikuwe ugãrhãnga Uisrairha, na acorhuwe ");
INSERT INTO ldb_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Uibrahim nu anangnga ugbagbaa, ru nyaka unga aka arherhe nggu atokamɛn.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Umaryamu asei nggu Uarhisabatu ayoka afɛ̃ɛ̃ ataar na adɔrha abvui azĩ ri iya. ");
INSERT INTO ldb_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ivang Uarhisabatu aka imar, unga amar uwɛkutsa. ");
INSERT INTO ldb_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Andɔkanga nu abi iyambɔ agũ ugɛ Uteijee acorhuwe unga akarhãrhã, umbɔ agɔm anggɔm nggu unga. ");
INSERT INTO ldb_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ru unum ukpu utɔrɔk umbɔ aka aba isorhuwe ungwɛ̃ɛ̃, na abee itare itsok utɛnga ru unga ugɛ Uzakariya, ");
INSERT INTO ldb_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","bɔr uyisa agɛ, <<Ĩ'ĩ! Awuri iyisi itsoknga Uyohana.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Umbɔ agɔr unga agɛ, <<Umbi ashimbi nu unera ru ikarmbi aka awe ru itsok ikɛrɛ ha.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Mɔcɛ umbɔ akũ abok akorhu utsara nu utesa abee ihwɛng utesa awuri itar itsok ungwɛ̃ɛ̃ igburh ungaa. ");
INSERT INTO ldb_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Unga arhusa umbɔ adzowe ubin itsɛng, nu anera kishoo adzeidzeu unga aka atsɛng, <<Itsoka igburh Uyohana.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kanying angwĩnga ayanga urhɛmnga ugarhe nu unga atirhunga arherhe na akpoi Unum. ");
INSERT INTO ldb_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Iwei ifɛr umbɔ, ikɛi umbɔ atsĩmbɔ irherha arherhe ha amaa inanga kishoo ra abĩ ampfũwã Uyahudiya. ");
INSERT INTO ldb_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ubɛn unera aka igũ arherhe ha, unga akaifɛrhkɔ na arhusa agɛ, <<Ungwɛ̃wi awuri iwe agusenga?>> Ubinkutsu ubok Uteijee uwe nggu unga. ");
INSERT INTO ldb_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Utɛ ungwɛ̃ hã Uzakariya awu nggu Ipfu Isarsatangge na asɔm Arherhu-Num agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","<<Umɛn ikpoi Uteijee, Unum uwu Uisrairha! Ubinkutsu unga aka iba ibvure anernga. ");
INSERT INTO ldb_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Unga aka aberunga utsom ififɔrh ru umɛn ri iya ugãrhãnga Udauda, ");
INSERT INTO ldb_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ru nyaka unga aka arherhe ra angwĩ asarkasar abika asɔm Arherhu-Numnga ishaisha. ");
INSERT INTO ldb_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Afɔrh umɛn ru ubok anggamtsakmɛn, nu kishoo abika akpɛ̃na umɛn. ");
INSERT INTO ldb_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Adɛyiwe atorhnga ra atokamɛn na ayitu usarkasar ibibemuwenga. ");
INSERT INTO ldb_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Uyirhkpi unga aka ayirhe utɛmɛn Uibrahim, ");
INSERT INTO ldb_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","unga aka ifɔrh umɛn ru ubok anggamtsakmɛn, na atsu umɛn isi ígũmɛn iwei itɔ̃ itsernga, ");
INSERT INTO ldb_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ri isisar nu irhirhika ra asunga ri inummɛn kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","<<Ungo ungwɛ̃mum, awuri iyisa ungo uner uwuku usɔm Arherhu-Num uwu Nggaa Uwuku Ugɔng. Ubinkutsu ungo uwuri igbaashia uzĩ ugbishuwe utsĩndĩ Uteijee, unga adɔrha aba. ");
INSERT INTO ldb_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ungo uwuri idzowe anernga ihwihwɛng ififɔrh ri itsũwe arhimmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ubinkutsu atorh Unum aka adzaa umɛn, unga atsu irhirhang ishaa unum iwuri idzeka afã iba ru umɛn, ");
INSERT INTO ldb_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","izĩ irhange abika awe ru uzĩ nu abika awe ru uzirhzĩ akpe, na adarh umɛn izãrhã nu utsĩndĩ uwuku udɔɔr.>> ");
INSERT INTO ldb_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Uyohana aseng aba awu akerketawɔ ri ipfu, na aseisa arhum utsɛku unumkpi unga aka adzek ra asu abi Uisrairha. ");
INSERT INTO ldb_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ri inum hã Ukaisar Uaugustu atsu umbɔ avarhi irhɛ anera ra abĩ Uroma ru upfunga. ");
INSERT INTO ldb_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Uvarhe ukpu inggbaashia nukpɔ ri ivang Ukiriniyu aka awu ugomna ra abĩ Usuriya. ");
INSERT INTO ldb_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Anera kishoo asok azĩmbɔ iteumbɔ nu umbɔ atsɛng umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Nggee Uyusuf iganga adzeku uteu Unazarat ru Ugarhirhi azĩ Uyahudiya, azĩã Ubaitarhami uteu Udauda, ubinkutsu unga awu unang Udauda. ");
INSERT INTO ldb_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Unga azĩ umɔ umbɔ atsɛng unga nggu Umaryamu, ukarhnga aka awu ra anaa. ");
INSERT INTO ldb_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ivangyɛ umbɔ aka awu umɔ, ivang iyiki imar ungwɛ̃ iwengge. ");
INSERT INTO ldb_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Unga amar ukã ungwɛ̃nga, uwɛkutsa. Unga abɛrh unga ra atorho na angwɛ̃we unga ru ukhukhɔɔ, ubinkutsu umbɔ asi ikpombɔ ubã anang inũ. ");
INSERT INTO ldb_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ra abĩ hã abi idzɛu rabɔ ri idɛɛ iyɔɔ, anu idzɛu ídɔimbɔ ru untsuuka. ");
INSERT INTO ldb_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ipfu itser Uteijee akapɛɛng ru umbɔ, ikpikpoi Uteijee irhange umbɔ, iwei ifɛr umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bɔr ipfu itser-Num hã igɔr umbɔ igɛ, <<Niba agũmbi iwei. Umum ikũwã umbi isarhe iyiki izeyɛ iki ikowe anera kishoo anggɔm akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Irherɛ ru uteu Udauda aka amarambɔ uwuku ufɔrh umbi, unga awu Ukiristo Uteijee. ");
INSERT INTO ldb_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Utsar ukpirɛ, umbi awuri inyãmbi irheng ungwɛ̃ iki ibɛrh ra atorho na angwɛ̃we unga ru ukhukhɔɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kanying ikpui ípfu itser-Num irhɛirhɛ, ngge aka apɛng nggu ipfu itser-Num hã akpoi Unum na agɔr agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","<<Akpoi Unum afafã ra afã, nu ididɔɔr ru upfung iwe nggu abirabɛ Unum aka amutuwe umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ivang ikpui ípfu itser-Num hã iki ibɔre umbɔ ni ifũngge ra afã, abi idzɛu ha agɔr adɔkambɔ agɛ, <<Umɛn izĩmɛn Ubaitarhami izĩ inyãni ubinkpi uku ukorhe Uteijee aka adɛyiwa ukpɔ ru umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nggee umbɔ asok ififitem azĩmbɔ azĩ anyã Umaryamu nggu Uyusuf, nu irheng ungwɛ̃ iki inũ ru ukhukhɔɔ. ");
INSERT INTO ldb_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Umbɔ aka anyã unga, umbɔ asɔme anera ubinkpi umbɔ aka adɛyiwe umbɔ ri itsi ungwɛ̃ hã, ");
INSERT INTO ldb_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","nu kishoo abika agũ adzeidzeu ru ubinkpi abika idzɛu idɔi ha aka arherhe nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bɔr Umaryamu angwɛ̃ ifɛrha ha kishoo na akaifɛrhkɔ ake ra amɛnnga. ");
INSERT INTO ldb_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Abi idzɛu ha abvui azĩ na akpoi Unum ra abina kishoo umbɔ aka agũ na anyã, awu ru nyaka umbɔ aka adɛyiwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Unum ukpu utɔrɔk uku uba uwe, ivang umbɔ iki isorhuwe unga usorhe, umbɔ atar itsoka igburh Uyesu, itsok iki ipfu itser-Num hã iki irherhe umbɔ adɔrha akɔ̃ ananga. ");
INSERT INTO ldb_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ivang iyiki isorhuwe inyãwã iki iba itsuifɛr, ru nyaka ngge iki iwe ru Íkpem Umusa, Uyusuf nggu Umaryamu akũna unga azĩmbɔ Urusharhima umbɔ adzowe irheng ungwɛ̃ɛ̃ ru Uteijee, ");
INSERT INTO ldb_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ru nyaka umbɔ aka atsɛng ri Íkpem Uteijee ugɛ, <<Ubɛn ukã ungwɛ̃ uwuku utsa, awuri itsũ unga awu uwu Uteijee.>> ");
INSERT INTO ldb_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ikɛi na adzowe idɛm-Num, ru nyaka ngge iki iwe ri Íkpem Uteijee, <<Anurhɛu iya avaa, use angwɛ̃ anurhɛu avaa.>> ");
INSERT INTO ldb_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ri ivang hã unera nuwɔ ru Urusharhima itsoka igburh Usimiyon. Awu uner uwuku urhika, agũ iwei Unum na adzɛu abee inyã ififɔrh Uisrairha, awu nggu Ipfu Isarsatangge ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ipfu Isarsatangge iki isɔmukũngge unga igɛ, unga asi íkpea utsɛku unga aka inyã Ukiristo uwu Uteijee. ");
INSERT INTO ldb_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ipfu-Num ikũna unga izĩngge ru ufɔm Iya-Num. Ivang utesa nggu uyisa Uyesu aka akũna unga aba nu umbɔ akorhuwe ubinkpi agbeyambɔ aka agɔr ri Íkpem Umusa, ");
INSERT INTO ldb_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Usimiyon ayɛi unga ra aboka na akpoi Unum agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","<<A Uteijee uner ijee kishoo, ru nyaka ungo uku urherhe, uneke ugãrhãngo azĩ uku utɔɔ icɛ, ru nyaka ungo uku ubemuwe. ");
INSERT INTO ldb_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ubinkutsu asumum anyãke ififɔrhngo, ");
INSERT INTO ldb_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","iyiriyɛ ungo uku ugbisha ra asu anera kishoo, ");
INSERT INTO ldb_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","irhirhang irhang idɛyiwe atsen abi Uyahuda, nu ikpikpoi ra anerngo abi Uisrairha.>> ");
INSERT INTO ldb_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Uyisa nu utesa adzeidzeu ubinkpi Usimiyon aka arherhe ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Mɔcɛ Usimiyon atsuke idorh ru umbɔ na agɔr Umaryamu, uyisunga agɛ, <<Ungwɛ̃ uwurɛ, unga awuri ikũ igbigba nu isisok anera arhɛrhɛ ri Uisrairha, na awuri iwu utsar ukpuku ukpukpɛ̃. ");
INSERT INTO ldb_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ngge itsú ifɛrhkɔ amɛn anera arhɛrhɛ iwuri idzekangge ra awiya. Ikɛi ungo uwuri igũo ighong ru nyaki ikon iki itar ikpuingo.>> ");
INSERT INTO ldb_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Umɔ̃ ikɛi utsɛrh uwuku usɔm Arherhu-Num Uhanatu, unapa Ufanuyirha unang Uasher. Aka akɔ̃ɔ̃ akarhãrhã, apfuna asei nggu utsaka imɛka utɔɔva nu utsaka ashia. ");
INSERT INTO ldb_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mɔcɛ unga awu utsɛ̃rhãpfu ri imɛka isɔka utɔrɔk nu imɛka inaa. Unga asi isoka ri Iya-Num, nu utsuu na atenum akpurha adɛ̃ɛ̃ ikpem igha ubin na adzowe igɔng nu ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Asok abanga ru umbɔ ri ivang hã, unga atar uwɛɛ ru Unum, na arherha arherhe ri itsi ungwɛ̃ hã nggu kishoo abika adzɛu unum ukpuku ufɔrh Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Umbɔ aka amaa abina kishoo aki Íkpem Uteijee, umbɔ apfuri azĩmbɔ utepumbɔ Unazarat ru Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ungwɛ̃ɛ̃ aseng na aker, na awu nggu itsoi, nu imimutu Unum iwe nggu unga. ");
INSERT INTO ldb_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ubɛn amɛka utesa nggu uyisa aka isaka azĩ Irhowa Iyiki Igar Utɔng ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Unga aka awu imɛka usɔkdũmɛn umbɔ akũna unga azĩmbɔ irhowa ha ru nyaka agbeyambɔ. ");
INSERT INTO ldb_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Irhowa ha iki imaa, umbɔ apfuri azĩmbɔ usoi, ungwɛ̃ hã Uyesu adɛ̃ɛ̃ unga ra andzing ru Urusharhima, utesa nu uyisa amɔrmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Akaifɛrhkɔ agɛ awu nggu umbɔ, na azɛ̃rhã amaambɔ unuma unying. Na atirhi irhisa unga ra abimbɔ nu awɛrhambɔ. ");
INSERT INTO ldb_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Umbɔ aka asi inyãmbɔ unga, umbɔ abvui azĩmbɔ Urusharhima anumbɔ irhisa unga. ");
INSERT INTO ldb_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Amaambɔ inuma itaar na adɔrha anyã unga ru ufɔm Iya-Num, asei nggu abika amesuwe, anu igosha umbɔ na anu irhusa umbɔ arherhe. ");
INSERT INTO ldb_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ubɛn unera aka igũ unga akpurha adzeidzeu ri ihwihwɛngnga nu idzipa arherhanga. ");
INSERT INTO ldb_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ivang utesa nggu uyisa aka anyã unga, umbɔ agũ idzeu akarhãrhã. Uyisa agɔr unga agɛ, <<A ungwɛ̃mum, awu use utsu ungo ukorhuwa umɛn rimi? Unyã utɛngo nggu umum iki isham asumɛn ibeea ungo, ikɛi amɛnmɛn aghong akarhãrhã umɛn iki isi inyãmɛn ungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Unga arhusa umbɔ agɛ, <<Awu use utsu umbi abeea umum? Umbi asi ihwɛngmbi agɛ awu ufang umum iki iwe ri iya Utɛmum?>> ");
INSERT INTO ldb_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bɔr umbɔ asi ihwɛngmbɔ ubinkpi unga aka arherhe nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Mɔcɛ unga adɔsa umbɔ, umbɔ azĩmbɔ Unazarat na agũna umbɔ. Bɔr uyisunga angwɛ̃ arherha ha kishoo ra amɛnnga. ");
INSERT INTO ldb_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Uyesu aseng nggu itsoi, nu iker iyor, na akpo izama ra anang Unum nu anera. ");
INSERT INTO ldb_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ri imɛka iyi usɔka ni imɛka itɔ̃ɔ̃ iyi iyɛrhe Ukaisar Utibariya, Ubuntu Ubirhatu awu ugomna Uyahudiya. Uhiridu atɔ̃ itser iyɛrhe Ugarhirhi, ungwɛ̃mbɔ Ufirhibu unga agha iyɛrhe Uiturhiya nu Utarakunita, nu Urhisaniya atɔ̃ itser iyɛrhe Uabirhene. ");
INSERT INTO ldb_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ri ivang hã umbɔ Uhanana nggu Ukayafa aka awu Ukugɔng Uwuku Udzowe Idɛm-Num. Arherhu-Num aba ru Uyohana ungwɛ̃ Uzakariya ra arhum. ");
INSERT INTO ldb_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nggee Uyohana aba, asorhuwe ubɔtisima ru Azɛ̃ Urdun na adzowe isarhe iyi idzidzipa iyiki itsũwe arhim. ");
INSERT INTO ldb_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ru nyaka ngge iki itsɛng ru ubvur uner uwuku usɔm Arherhu-Num Uishaya igɛ, <<Urhɛm uner udũwã ra arhum ugɛ, <Àka agbisha anang Uteijee, àka agbisha atsĩndĩnga uku urhirhiki. ");
INSERT INTO ldb_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Awuri itsu abĩ atɔke ubɛn izɛ̃rhĩ, na asim ifũrhã ni igũ asituwe, awuri ivii atsĩndĩ akika anyɔsha awe uku urhirhiki. Na agbisha atsĩndĩ akika arhurhuta ake aghwɔrhe. ");
INSERT INTO ldb_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nu anera kishoo awuri inyãmbɔ ififɔrh Unum.> >> ");
INSERT INTO ldb_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Uyohana agɔr anera kishoo aka akɔng aba ru unga asorhuwe umbɔ ubɔtisima agɛ, <<Umbi angwɛ̃ ibvui! Ungaa adɛyiwa umbi itĩ avɔm Unum aka iba unuma? ");
INSERT INTO ldb_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Àka atɔ̃ itseryɛ iki idɛyiwe idzidzipambi. Àka aneke igɔr ra amɛnmbi agɛ, <Uibrahim unga awu utɛmɛn.> Ubinkutsu, umum idɛyiwa umbi Unum awea ri ijee unga aka itsu atarh akɛrɛ ake awe awɛkaci ru Uibrahim. ");
INSERT INTO ldb_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Icɛrɛ anggãi iki idɛ̃ɛ̃ngge ra anũnang acucii, ubɛn ucucii uku usi ighwɛr umgbɔ ikpũrhã iyiki ize umbɔ awuri igbɛr umgbɔ atsuku urha.>> ");
INSERT INTO ldb_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ikikɔnga kishoo irhusa unga igɛ, <<Ude umɛn ikorhi uguse?>> ");
INSERT INTO ldb_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Uyohana agɔr umbɔ agɛ, <<Unera aka awu ra atorho avaa, unga agaar unying adzowe undɔkanga aka ashia, nu uwuruwi aka awu ru ubingha, akorhe rimi hã.>> ");
INSERT INTO ldb_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Abika ayɛsu ikirbi abĩ, aba umbɔ isorhu ubɔtisima arhusa unga ikɛi agɛ, <<A uner imesa, umɛn igamɛn ikorhu ugusemɛn?>> ");
INSERT INTO ldb_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Unga agɔr umbɔ agɛ, <<Niba ayɛi agarmbi ubinkpi umbɔ aka atsuka umbi.>> ");
INSERT INTO ldb_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Umɔ abi iwa arhusa unga agɛ, <<Umɛn igamɛn ikorhu ugusemɛn?>> Unga agɔr umbɔ agɛ, <<Niba avurmbi uhwɛk, niba agbɛrangwĩ atsukukumbi anera, àka ashur nggu ugbɛtambi.>> ");
INSERT INTO ldb_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Anera aka afosi ibiba Ukiristo, arhusa adɔkambɔ agɛ, <<Awu Uyohana unga Ukiristo ha?>> ");
INSERT INTO ldb_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Uyohana agɔr umbɔ kishoo agɛ, <<Umum isorhuwa umbi ubɔtisima nggu amɛ̃, bɔr uwɔɔ ruwɔ abarɔ, awuri ijee ananga umum. Abadaknga umum isi ídɛ̃ɛ̃ inggarhukũ arhisa. Unga awuri isorhuwa umbi ubɔtisima nggu Ipfu Isarsatangge nu urha. ");
INSERT INTO ldb_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Utak ukpuku utsɛku itsemnga uwu ru uboknga. Awuri itsɛki ishaa itsemnga itɛtɛnangge azĩ atsuku ungbanga, na akpĩĩwe uhwenga ru urhakpi uku usi írhimkpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nu irhɛm iyɔɔ irhɛirhɛ Uyohana aka akũ adam anera na adzowe Isarhe Iyiki Ize ra anera. ");
INSERT INTO ldb_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Uyohana atsɛrhu uyɛrhe Uhiridu, ri itsi Uhirudiya utsɛrha ungwɛ̃mbɔ, nu kishoo amɛn akatãrhã akɔɔ Uhiridu aka akorhe. ");
INSERT INTO ldb_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Uhiridu ashɔi arherhe akɔɔ atoma ikɛi, agbange Uyohana Uner Ubɔtisima ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ivangyɛ anera kishoo aka asorhu ubɔtisima, Uyesu asorhunga iganga. Unga aka adɛ̃ɛ̃ ifɛn-Num, afã adiki iyanga, ");
INSERT INTO ldb_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ipfu Isarsatangge ru nyaku unurhɛu icipuwa ni itsinga, urhɛm udzeka afã ugɔr ugɛ, <<Ungo uwu Ungwɛ̃mum uwuruwi umum iki ibema. Nggu ungo umum igũibɛn.>> ");
INSERT INTO ldb_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ivangyɛ Uyesu aka ayoka imɛka isɔka itaar, unga aka atirhi itsernga. Anera akaifɛrhkɔ unga awu ungwɛ̃ Uyusuf ungwɛ̃ Uherhi, ");
INSERT INTO ldb_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Uherhi ungwɛ̃ Umatat, Umatat ungwɛ̃ Urhawi, Urhawi ungwɛ̃ Umarhki, Umarhki ungwɛ̃ Uyanna, Uyanna ungwɛ̃ Uyusuf, ");
INSERT INTO ldb_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Uyusuf ungwɛ̃ Umatatiya, Umatatiya ungwɛ̃ Uamos, Uamos ungwɛ̃ Unahum, Unahum ungwɛ̃ Uhasrhi, Uhasrhi ungwɛ̃ Unajaya, ");
INSERT INTO ldb_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Unajaya ungwɛ̃ Umaata, Umaata ungwɛ̃ Umatatiya, Umatatiya ungwɛ̃ Ushimeya, Ushimeya ungwɛ̃ Ujosek, Ujosek ungwɛ̃ Ujoda, ");
INSERT INTO ldb_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ujoda ungwɛ̃ Ujowanan, Ujowanan ungwɛ̃ Uresa, Uresa ungwɛ̃ Uzerubaberh, Uzerubaberh ungwɛ̃ Usheyarhtiyerh, Usheyarhtiyerh ungwɛ̃ Uniri, ");
INSERT INTO ldb_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Uniri ungwɛ̃ Umarhki, Umarhki ungwɛ̃ Uaddi, Uaddi ungwɛ̃ Ukosama, Ukosama ungwɛ̃ Uerhmadama, Uerhmadama ungwɛ̃ Uer, ");
INSERT INTO ldb_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Uer ungwɛ̃ Ujoshuwa, Ujoshuwa ungwɛ̃ Uerhiyeza, Uerhiyeza ungwɛ̃ Ujorima, Ujorima ungwɛ̃ Umatat, Umatat ungwɛ̃ Urhawi, ");
INSERT INTO ldb_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Urhawi ungwɛ̃ Usiman, Usiman ungwɛ̃ Uyahuda, Uyahuda ungwɛ̃ Uyusuf, Uyusuf ungwɛ̃ Uyonam, Uyonam ungwɛ̃ Uerhiyakim, ");
INSERT INTO ldb_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Uerhiyakim ungwɛ̃ Umerheya, Umerheya ungwɛ̃ Umena, Umena ungwɛ̃ Umattata, Umattata ungwɛ̃ Unatan, Unatan ungwɛ̃ Udauda, ");
INSERT INTO ldb_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Udauda ungwɛ̃ Ujesse, Ujesse ungwɛ̃ Uobida, Uobida ungwɛ̃ Ubo'aza, Ubo'aza ungwɛ̃ Usarhmon, Usarhmon ungwɛ̃ Unashon, ");
INSERT INTO ldb_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Unashon ungwɛ̃ Uamminadab, Uamminadab ungwɛ̃ Uaram, Uaram ungwɛ̃ Uhezuron, Uhezuron ungwɛ̃ Ufereza, Ufereza ungwɛ̃ Uyahuda, ");
INSERT INTO ldb_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Uyahuda ungwɛ̃ Uyakubu, Uyakubu ungwɛ̃ Uishaku, Uishaku ungwɛ̃ Uibrahim, Uibrahim ungwɛ̃ Utera, Utera ungwɛ̃ Unahor, ");
INSERT INTO ldb_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Unahor ungwɛ̃ Userug, Userug ungwɛ̃ Ureyu, Ureyu ungwɛ̃ Uferheg, Uferheg ungwɛ̃ Ueber, Ueber ungwɛ̃ Usherha, ");
INSERT INTO ldb_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Usherha ungwɛ̃ Ukenan, Ukenan ungwɛ̃ Uarfakshad, Uarfakshad ungwɛ̃ Ushem, Ushem ungwɛ̃ Unuhu, Unuhu ungwɛ̃ Urhamek, ");
INSERT INTO ldb_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Urhamek ungwɛ̃ Umetuserha, Umetuserha ungwɛ̃ Uenɔk, Uenɔk ungwɛ̃ Uyared, Uyared ungwɛ̃ Umaharharherh, Umaharharherh ungwɛ̃ Ukenan, ");
INSERT INTO ldb_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ukenan ungwɛ̃ Uenosh, Uenosh ungwɛ̃ Usɛt, Usɛt ungwɛ̃ Uadamu, Uadamu ungwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Uyesu awu nggu Ipfu-Num, adzeku Azɛ̃ Urdun, Ipfu ikũna unga izĩngge ra arhum. ");
INSERT INTO ldb_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Umɔ unga amaa inuma isɔka inaa Undenggũ adeya unga. Ri inum hã unga asi ighaa ubingha. Inum hã iki imaa, imerh ifɛr unga. ");
INSERT INTO ldb_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Undenggũ agɔr unga agɛ, <<Ungo uba uwu Ungwɛ̃ Unum, ugɔr utarh ukpirɛ ukpɔ uwu ubingha.>> ");
INSERT INTO ldb_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Uyesu agɔr unga agɛ, <<Itsɛng Arherhu-Num igɔr igɛ, <Asi iwea ubingha ukpekũ itsu unera abɛk.>>> ");
INSERT INTO ldb_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Undenggũ akũna unga afũã ra anang afafã na adɛyiwe unga kanying iyɛrhu upfung kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Mɔcɛ unga agɔr unga agɛ, <<Umum iwuri idzaamum ungo ijee ra abĩã kishoo ni idzaa ungo ikpikpoingge, ubinkutsu aka adzaa ru umum, nu umum idɛ̃ɛ̃ indzowukũ ubɛn unera umum iki ibee. ");
INSERT INTO ldb_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Nggee ungo uba udzaango umum igɔng, ukpɔ uwuri iwu ukpungo kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Uyesu agɛ, <<Itsɛng Arherhu-Num igɔrngge ugɛ, <Udzowe igɔng ru Uteijee Unumngo nu uwu ugãrhãnga ukpekũ.> >> ");
INSERT INTO ldb_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Undenggũ akũna unga azĩã Urusharhima, na atsu unga adɛ̃ɛ̃ ra afafã ni itsi uvi Iya-Num, na agɔr unga agɛ, <<Ungo uba uwu Ungwɛ̃ Unum, upur ucipa ru nggɛɛ, ");
INSERT INTO ldb_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ubinkutsu itsɛng igɔr igɛ, << <Unga awuri itsu ípfu itsernga ngge ingwɛ̃dzɛn ni ikaa ungo, ");
INSERT INTO ldb_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ngge iwuri ikpɔm ungo ra afafã ra abokngge, utsur ungo ukwɛrɔ undaidakngo nu utarh.> >> ");
INSERT INTO ldb_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Uyesu agɔr unga agɛ, <<Itsɛng Arherhu-Num igɔr ugɛ, <Ungo niba ivirungo Uteijee Unumngo.> >> ");
INSERT INTO ldb_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ivangyɛ Undenggũ aka amaa ideya unga kishoo, unga nekuka unga utsɛku ivang iyikise. ");
INSERT INTO ldb_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mɔcɛ Uyesu abvui azĩã abĩ Ugarhirhi ri ijee Ipfu-Num, isarhe ri itsinga itɛ̃rhã imaangge abĩã kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Unga amesuwe ra abã ifɛn-Nummbɔ, nu ubɛn unera akpoi unga. ");
INSERT INTO ldb_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Unga azĩã Unazarat, ra anangkɛ umbɔ aka akpɔm unga, ru unum ukpuku uwosha unga azĩ atsĩã ru ubã ifɛn-Num, ru nyaka unga aka abayi. Unga asok adɛ̃ɛ̃ abee ivarhu uvarhe. ");
INSERT INTO ldb_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Umbɔ adzowe ubvur uku ufeta uwu uner uwuku usɔm Arherhu-Num Uishaya, unga aka ayanga, unga akpo anangkɛ iki itsɛng igɛ, ");
INSERT INTO ldb_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","<<Ipfu Uteijee iwu nggu umum, ubinkutsu unga aka adzukuwa umum atsei akika adzowe Isarhe Iyiki Ize ra atsũwã. Unga aka adena umum idũwã itsũwe abirabɛ umbɔ aka abow ru ugborzĩ ni iyanguwe asu abi ibvuta ni ifɔne abika ahwa ayetnum. ");
INSERT INTO ldb_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Izĩ idũwã imɛk umatu Uteijee.>> ");
INSERT INTO ldb_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mɔcɛ unga afetu ubvura, adzowuka umgbɔ ru uner itsera ru ubã ifɛn-Num hã na aseisa. Asumbɔ kishoo ru ubã ifɛn-Num hã awing arhi unga. ");
INSERT INTO ldb_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nu unga atirhi agɔr umbɔ agɛ, <<Irherɛ Arherhu-Num akɛrɛ atsuafɛrke ri igigũmbi.>> ");
INSERT INTO ldb_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kishoo arherhe iki ize ri itsinga na adzeidzeu irhɛm iyiki ize iyiriyɛ iki idzeka ra angwĩnga. Umbɔ arhusa agɛ, <<Asi iwea ungwɛ̃ Uyusuf nuwi?>> ");
INSERT INTO ldb_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Uyesu agɔr umbɔ agɛ, <<Idzidzɛrhe umbi awuri idzaambi umum unyaka arherhe agɛ, <Unera agɔu ukerhuwe itsikamngo! Umbi ikɛi awuri igɔrmbi umum ugɛ, ukorhe nggimi ru utepungo ubinkpi umɛn iki igũ ugɛ ungo ukorhe ru Ukafanahum.> >> ");
INSERT INTO ldb_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","<<Umum indɛyiwa umbi idzidzɛrhe, uner uwuku usɔm Arherhu-Num asi isaka ikpoa imor ru utepunga. ");
INSERT INTO ldb_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Umum isɔma umbi idzidzɛrhe, atsɛ̃rhãpfu awu arhɛrhɛ ru Uisrairha ri ivang uner uwuku usɔm Arherhu-Num Uirhiya, inai iki isi idoingge imɛka itaar nu utenga rimɔ̃ɔ̃ imerh akarhãrhã imaangge abĩã. ");
INSERT INTO ldb_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Rimi hã asi idene Uirhiya azĩã ru unyinga umbɔ na adene unga azĩ ru utsɛ̃rhãpfu ru Uzarefat ra abĩ Usidon. ");
INSERT INTO ldb_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ikɛi ru Uisrairha abi ingbim awu arhɛrhɛ ri ivang uner uwuku usɔm Arherhu-Num Uerhisha, rimi hã unera asi ikerhunga, Una'aman ukpekũ, utsa Usuriya.>> ");
INSERT INTO ldb_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Anera kishoo ru abã ifɛn-Num hã, amɛnmbɔ asoke umbɔ aka agũ rimi. ");
INSERT INTO ldb_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Umbɔ asok agbĩrhã unga adzek ru utepa, na akũna unga azĩmbɔ ni ishi igũa, ra anangkɛ utepa uku uwe, abee iyira unga agɔ̃rhã. ");
INSERT INTO ldb_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bɔr unga azɛ̃rhã atɔng ra ateumbɔ azĩã udĩnga. ");
INSERT INTO ldb_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Mɔcɛ, unga azĩã Ukafanahum ru uteu ukpɔɔ ra abĩ Ugarhirhi, ru unum ukpuku uwosha amesuwe anera. ");
INSERT INTO ldb_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Umbɔ adzeidzeu nggu imesanga ubinkutsu isarhanga iwu nggu ijee. ");
INSERT INTO ldb_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ru abã ifɛn-Num hã uner uwɔɔ awe ru ipfu iyiki ibewe. Unga atsarhi irhaknga ikerketangge atsu ivum agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","<<Iyee! Ungo ubee use nggu umɛn Uyesu uner Unazarat? Ungo uba itsĩme umɛn? Umum ihwɛng ungo uwu usarkasar uwu Unum!>> ");
INSERT INTO ldb_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Uyesu atsɛrha ngge agɛ, <<Unukutata! Upfudzeka ru unga!>> Mɔcɛ ipfu iyiki ibewe ha ashupa unga atar ra ateumbɔ kishoo, ni inekungge unga, isi inayikungge unga. ");
INSERT INTO ldb_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Anera kishoo adzeidzeu na agɔr adɔkambɔ agɛ, <<Arherhakɛ awu ikpũ akasong? Nggu iker nu ijee unga atsu ípfu iyiki ibewe ngge ipfudzeka!>> ");
INSERT INTO ldb_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Isarhe ri itsinga itɛ̃rhã imaangge ikãwã anang hã. ");
INSERT INTO ldb_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Uyesu asoku ubã ifɛn-Num hã azĩã ri iya Usiman. Mɔcɛ uyisa utsɛrha Usiman iyora imani akarhãrhã, umbɔ arhusu Uyesu ama ayike unga. ");
INSERT INTO ldb_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nggee unga agbapfu akhapa ru unga na atsɛrhi imani anii iyor, ngge idzengge ru unga. Unga asok kanying azĩã agashuka umbɔ amɛ̃ aka ahwa. ");
INSERT INTO ldb_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ivang urhɛɛ uku uwe, anera akũ abi ikpũ irhãrhã aba ru Uyesu atsorha aboknga, anyinganying, akerhuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ikɛi ípfu iyiki ibewe ha adzeka ra anera arhɛrhɛ itsu ivum agɛ, <<Ungo uwu Ungwɛ̃ Unum!>> Bɔr unga atsɛrha ngge, unga asi ibeenga ineke ngge idzipa arherhe, ubinkutsu ngge ihwɛngngge unga aka awu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ukpe uku usar, Uyesu adzek azĩã anangkɛ aka awu uku utata. Anera anu ibeea unga, umbɔ aka anyã unga, umbɔ abee iden unga utsur unga nekuka umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bɔr unga agɛ, <<Awu ufang umum idzowe Isarhe Iyiki Ize iyi Iyɛrhe Unum ri iteu iyɔɔ ikɛi, ngge itsu umbɔ adena umum ĩba.>> ");
INSERT INTO ldb_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nu unga adɛ̃ɛ̃nga idzowe isarhe ra abã ifɛn-Num Uyahudiya. ");
INSERT INTO ldb_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Unuma nukpɔ Uyesu adɛ̃ɛ̃ ni ifɛn ukau Ujanisarat, anera arhɛrhɛ afĩĩ adzipa unga na akpeto ani igosha Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Unga anyã akhukhɔɔ avaa aka adɛ̃ɛ̃ ri ifɛn amɛ̃, abi udɛm aka aden, na adɛ̃ɛ̃ isorh igbermbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Unga atsĩ ru ukhukhɔɔ uwu Usiman, na ashɔ̃rhã unga agɔpa atsĩ ukunjiir ru ukau ha. Umɔ unga asei nu ukhukhɔɔ ha na amesuwe anera. ");
INSERT INTO ldb_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Unga aka amaa arherhe, unga agɔr Usiman, agɛ, <<Àka atsĩ ra anang aka aghora na atsu igbermbi adzui.>> ");
INSERT INTO ldb_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Usiman agɔr unga agɛ, <<A Uteiya, umɛn imaa utsuu itɛ̃wã, isi idzurmɛn ubin. Bɔr ri igigɔrngo, umum itsukũ igber ha.>> ");
INSERT INTO ldb_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Umbɔ aka atsu igber ha, umbɔ adzui abɛrh arhɛrhɛ ake atsu igbermbɔ itirhi ipupa. ");
INSERT INTO ldb_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Umbɔ akorhuwe utsara ra adɔkambɔ ru ukhukhɔɔmbɔ aba ayike umbɔ. Umbɔ aka aba atsu abɛrh ake atɔk akhukhɔɔmbɔ, akhukhɔɔ ha akpurha abee ididɛk. ");
INSERT INTO ldb_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Usiman Ubitru aka anyã rimi, unga agba ra atsurhuk Uyesu na agɛ, <<A Uteijee, ugɔpa ru umum, umum iwu uner arhim!>> ");
INSERT INTO ldb_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ubinkutsu unga nggu abirabɛ aka awu nggu unga kishoo adzeidzeu ra arhɛrha abɛrh ha umbɔ aka adzui. ");
INSERT INTO ldb_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Awu umbɔ Uyaku nggu Uyohana, angwɛ̃ Uzabadi, awɛrhi itser Usiman. Mɔcɛ Uyesu agɔr Usiman, agɛ, <<Niba ugũa iwei, utirhi icɛrɛ ungo uwuri idzui anera.>> ");
INSERT INTO ldb_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nggee umbɔ ayii akhukhɔɔmbɔ adzeka nu ubang ukau ha. Umbɔ aneke abinmbɔ kishoo na adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ivang hã niyɔ Uyesu awu ru uteu ukpɔɔ, uner uwɔɔ aba awuri irhãrhĩ ingbim. Unga aka anyã Uyesu, unga agba ra asunga na ashɔ̃rhã unga agɛ, <<A Uteijee, ungo uba ubemungo, ungo udɛ̃ɛ̃ ukerhuwango umum.>> ");
INSERT INTO ldb_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Uyesu aberu uboknga abangu uner irhãrhĩ ingbim hã, na agɛ, <<Umum ĩbeemum, ukerhe!>> Kanying ingbimnga ikerhungge. ");
INSERT INTO ldb_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Mɔcɛ Uyesu avange unga agɛ, <<Niba udɛyikɔ unera, bɔr uzĩ udɛyiwe itsingo ra abika adzowe idɛm-Num, nu udzowe idɛm-Num iyiki ikikerhe Umusa aka atsuka umbi, ngge iwu utsara ra anera ugɛ ungo uku ukerhungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bɔr rimi hã isarhanga itɛ̃rhã imaangge inanga, ngge itsú anera arhɛrhɛ aba igũ unga na akpo ikikerhe ri irhãrhãmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bɔr Uyesu aka isaka adzek ikiyikanga anu ifɛn-Num ra arhum. ");
INSERT INTO ldb_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Unuma nukpɔ Uyesu adɛ̃ɛ̃ imesuwe anera, abi Ufarisi nggu abika amesi Íkpem Umusa, adzek kishoo ri iteu iyiki ici iki iwe ru Ugarhirhi nu Uyahudiya nu Urusharhima, asei umɔ. Ijee iyi Uteijee iwu nggu unga iyiki ikerhuwe abi irhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mɔcɛ abɔɔ atsã uner irhãrhĩ ishai iyor nu ufar abee ikũna unga atsĩ ri iya azĩ angwɛ̃we unga ra asu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ivangyɛ umbɔ aka asi ikpombɔ anang aka atsĩã, ubinkutsu anera arhɛmbɔ, umbɔ afũ ni itsi uvi ati uvi ha na acipuwe unga nu ufarnga ra asu Uyesu ra ateu anera. ");
INSERT INTO ldb_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ivang Uyesu aka anyã imangmangmbɔ, unga agɛ, <<A uwee, aka atsũwãmbɔ arhimngo.>> ");
INSERT INTO ldb_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Abi Ufarisi na abika amesuwe Ikpem atirhi ikaifɛrhkɔ ra amɛnmbɔ agɛ, <<Awu ungaa nuwi arhenu Unum! Ungaa adɛ̃ɛ̃ atsũwe arhim uba asi iwea Unum ikiyikanga?>> ");
INSERT INTO ldb_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Uyesu aka ahwɛnga ifɛrhkɔmbɔ, unga arhusa umbɔ agɛ, <<Awu use utsu umbi anu ikaifɛrhkɔ rimi ra amɛnmbi? ");
INSERT INTO ldb_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Akasong asi ighongke irherhe, umum iki igɔr, <Àka atsũwãmbɔ arhimngo,> use igɔr igɛ, <Usiso uzɛ̃rhũ uzɛ̃rhã?> ");
INSERT INTO ldb_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bɔr ngge itsú umbi ahwɛng ugɛ Ungwɛ̃-Ner awea ri ijee iyiki itsũwe arhim ru upfung.>> Mɔcɛ unga agɔr uner ishai iyor ha agɛ, <<Umum igɔr ungo, usisok, ufetu ufarngo uzĩ ri iya!>> ");
INSERT INTO ldb_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kanying utsa ha abera asok ra asumbɔ, afetu ufarnga, akai izĩ ri iya na akpoi Unum. ");
INSERT INTO ldb_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ubɛn unera adzeidzeu na akpoi Unum. Umbɔ awe nggu iwei na agɛ, <<Umɛn inyãmɛn abin idzeu irherɛ!>> ");
INSERT INTO ldb_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Akɛrɛ ha aka amaa, Uyesu adzek anyã uner uwuku uyɛi ikirbi abĩ itsoka igburh Urhawi asei ra anang itsernga. Uyesu agɔr unga agɛ, <<Udɔsa umum!>> ");
INSERT INTO ldb_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Urhawi asok nekuka ubɛn ubin na adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mɔcɛ Urhawi azɛke Uyesu irhowa iyiki igɔng ri iyanga, arhɛrhɛ abika ayɛsu ikirbi abĩ nu abɔɔ atɔk agha nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bɔr abi Ufarisi nu abika amesuwe Ikpem Umusa aka awu ru ukpui agbeyambɔ akũ arherhe aba ra angwɛ̃ imesa Uyesu agɛ, <<Awu use utsu umbi agha na ahwa nggu abika ayɛsu ikirbi abĩ nu abi arhim?>> ");
INSERT INTO ldb_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Uyesu agɔr umbɔ agɛ, <<Asi iwea abika aker abee uner agɔu, bɔr abi irhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Umum isi ĩbamum iyisa abika arhurhika, bɔr umum ĩba iyisa abi arhim umbɔ adzipa ra arhimmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Umbɔ agɔr unga agɛ, <<Angwɛ̃ imesu Uyohana aka isaka akpemmbɔ igha ubin na afɛnmbɔ Unum, nu angwɛ̃ imesa abi Ufarisi, bɔr abingo agha na ahwa.>> ");
INSERT INTO ldb_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Uyesu agɔr umbɔ agɛ, <<Umbi adɛ̃ɛ̃ atsu awɛrhu uner utsɛrh uwuku ufa akpemmbɔ igha ubinghanga na awu nggu umbɔ? ");
INSERT INTO ldb_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ivanga niyɔ ibarɔ awuri inyangukumbɔ uner utsɛrh uwuku ufa ru umbɔ, ivang ha niyɔ umbɔ aka ikpem igha ubin.>> ");
INSERT INTO ldb_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ikɛi asɔme umbɔ unyaka arherhe agɛ, <<Unera asi ízharha atorho aka afa akũ abipunga nu atorho akagbe. Unga aba akorhunga rimi, unga adakuwe atorho aka afa ha, nu atorho aka afa ha asi íweke ru nyaku akika akagbe ha. ");
INSERT INTO ldb_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Asi ítsumbɔ amɛ̃ inebi aka afa ru ubãĩ uwuku ugbe. Ungo uba utsukɔ, ubãĩ uwuku ugbe ha ukpurhu uyar, amɛ̃ inebi ha akpurha adzɛ̃rhã ra abĩ, ubãĩ hã uwuri iwu ibɛm. ");
INSERT INTO ldb_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bɔr, awu ufang umbɔ atsu amɛ̃ inebi aka afa ra ambãĩ aka afa! ");
INSERT INTO ldb_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Unera asi íbemunga ihwa amɛ̃ inebi aka afa, unga aba aka ahwaa akagbe. Awuri igɔr agɛ, <Akagbe azeke aka afa.> >> ");
INSERT INTO ldb_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Unum ukpuku uwosha ukpɔɔ Uyesu azɛ̃rhã atɔng ri icang arhkama, angwɛ̃ imesanga agbiu azang arhkama adzuka ra abokmbɔ, na atãi ishaanga. ");
INSERT INTO ldb_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Abi Ufarisi abɔɔ arhusa agɛ, <<Awu use utsu umbi azharhuwe Ikpem unum ukpuku uwosha?>> ");
INSERT INTO ldb_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Uyesu agɔr umbɔ agɛ, <<Umbi anasi ivarhumbi ubin Udauda aka akorhe ri ivangyɛ unga aka agũ imerh nggu abi uzãrhãnga? ");
INSERT INTO ldb_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Unga atsĩ ru Utsurha-Num, azĩ anyangu ubingha umbɔ anɛmuwe ru Unum, adiki ighigha nggu abi uzɛ̃rhãnga. Ikpem iki igɔr igɛ abika adzowe idɛm-Num ukpekũ umbɔ igha ubingha ha.>> ");
INSERT INTO ldb_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Mɔcɛ Uyesu agɔr umbɔ agɛ, <<Ungwɛ̃-Ner unga awu Uteijee unum ukpuku uwosha.>> ");
INSERT INTO ldb_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ru unum ukpuku uwosha ukpɔɔ unga atsĩ ru abã ifɛn-Num amesuwe anera, uner uwɔɔ umɔ ubok ughanga ushushai. ");
INSERT INTO ldb_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Abi Ufarisi nu abika amesuwe Ikpem arhi ubin umbɔ aka ikũ atsu uvau ru Uyesu. Nggee umbɔ awing asumbɔ arhi unga use unga awuri ikerhuka ru unum ukpuku uwosha. ");
INSERT INTO ldb_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bɔr Uyesu ahwɛnga ifɛrhkɔmbɔ, umɔ unga agɔr uner uwuku ushai ubok ha agɛ, <<Usisok uba udidɛ̃ɛ̃ ra asumɛn kishoo.>> Utsa ha asok aba adɛ̃ɛ̃ umɔ. ");
INSERT INTO ldb_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Mɔcɛ Uyesu agɔr umbɔ agɛ, <<Umum irhusa umbi, Ikpem iwu use ru unum ukpuku uwosha? Akorhi iyiki ize use iyiki ibewe? Afɔrhe urhɛ use atsĩme umgbɔ?>> ");
INSERT INTO ldb_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Unga arhi adzipa umbɔ kishoo, na agɔr uner ushai ubok ha agɛ, <<Unɛmu ubokngo udzek!>> Unga ayɛrhu uboknga, ukpu udiki ikikerhe kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Akɛrɛ ha atsu umbɔ asoyi avɔm akarhãrhã na atirhi arherhe nggu adɔkambɔ ubin umbɔ aka ikorhuwe Uyesu. ");
INSERT INTO ldb_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Unum ukpɔɔ ri inum hã Uyesu azĩ afũã igũ azĩ ifɛn-Num, amaa utsuu unum hã kishoo anu ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ivangyɛ ukpe uku usar unga ayisa angwɛ̃ imesanga aba ru unga, umɔ unga atsũ usɔkdũmɛn, na ayisa umbɔ abi itsernga. ");
INSERT INTO ldb_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Usiman uwu ha unga aka atar unga agburh Ubitru, nu ungwɛ̃mbɔ Uandarawu, nu Uyaku, nu Uyohana, nu Ufirhibu, nu Ubatorhomi, ");
INSERT INTO ldb_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","nu Umatiyu, nu Utoma, nu Uyaku ungwɛ̃ Uharhfa, nu Usiman umbɔ iki iyisa Uzarhoti, ");
INSERT INTO ldb_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","nu Uyahuda ungwɛ̃ Uyaku, nu Uyahuda Uiskariyoti uwuku ugha adak. ");
INSERT INTO ldb_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Unga acipuwa nggu umbɔ azĩ adɛ̃ɛ̃mbɔ ri idɛɛ iyɔɔ. Arhɛrha angwɛ̃ imesanga akɔng umɔ, nu arhɛrha anera aka adzeka abĩ Uyahudiya nu Urusharhima, nu abɔɔ aka adzeku ubang azɛ̃ Utaya nu Usidon. ");
INSERT INTO ldb_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Umbɔ aka aba igosha unga, unga akerhuwe irhãrhãmbɔ. Abika agũ uver nggu ípfu iyiki ibewe ikɛi akerhumbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Anera kishoo akɔka abee ibanga unga, ubinkutsu unga akerhuwe umbɔ kishoo nggu nggaa ijeenga. ");
INSERT INTO ldb_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Unga arhi angwɛ̃ imesanga, na agɛ, <<Idorh iwu iyimbi aka awu atsũwã, ubinkutsu Iyɛrhe Unum iwu iyimbi. ");
INSERT INTO ldb_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Idorh iwu iyimbi abika agũ imerh icɛrɛ, umbi awuri ishuurmbi. Idorh iwu iyimbi abika adɔng icɛrɛ, umbi awuri inyĩrhũmbi unyĩrhã. ");
INSERT INTO ldb_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Idorh iwu iyimbi anera iki ikpɛ̃na umbi na awayiwe umbi na arhena umbi, na agũ ashĩ umbi ugɛɛ umbi awu abi amɛn aka abewe ni itsi umbi aka adɔsu Uyesu Ungwɛ̃-Ner. ");
INSERT INTO ldb_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","<<Àka agɔm ru unum hã na atengasha nggu anggɔm, ubinkutsu ugbɛtambi uwu ugɔgɔngakpɔ ra afã. Rimi hã ateimbɔ aka akorhuwe abika asɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","<<Bɔr atorhmbi abika awu ru ubin, umbi aka ayɛimbi ififitambi. ");
INSERT INTO ldb_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Atorhmbi abika awu ra ashur icɛrɛ, ubinkutsu umbi awuri igbambi imerh. Atorhmbi abika anyĩrhũ unyĩrhã icɛrɛ, ubinkutsu umbi awuri idɔngmbi na aciu. ");
INSERT INTO ldb_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Atorhmbi ivang anera kishoo iki irherhe iyiki ize ru atsimbi, ubinkutsu atokambɔ aka isaka akorhe rimi nggu abika asɔm Arherhu-Num igbɛrangwĩ. ");
INSERT INTO ldb_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","<<Bɔr umum idɛyiwa umbi abika agũna umum, àka abema anggamtsakmbi, àka akorhuwe iki ize ru abika akpɛ̃na umbi. ");
INSERT INTO ldb_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Àka atsuke idorh ra abika arhena umbi, àka afɛne-Num ra abika ayɔm umbi. ");
INSERT INTO ldb_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Unera aba akwɛra ungo nu utamngo, udzipuwe utam ukpu uvaa ikɛi. Unera aba avura atorhango akagɔng, niba ukɛnɔ unga atorha akɔɔ akaci. ");
INSERT INTO ldb_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Udzowe ubɛn unera aka afɛnu ubinngo, unera aba avura ubinngo, niba ubvui uyɛsɔ. ");
INSERT INTO ldb_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ukorhuwe anera ubinkpi ungo uku ubee umbɔ akorhuwa ungo. ");
INSERT INTO ldb_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","<<Umbi aba abema abika abema umbi ukpekũ, umbi awu ru use ugbɛtunga? Abi arhim aka isaka abema abika abema umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Umbi aba akorhi iyiki ize nggu abika akorhuwa umbi iyiki ize, umbi awu ru use ugbɛtunga? Uko abi arhim aka isaka akorhe rimi hã. ");
INSERT INTO ldb_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Umbi aba adzowe ikɔw ra abirabɛ umbi aka afosa ugɛ adɛ̃ɛ̃ afaimbɔ, ugbɛtɛ umbi uwu use? Abi arhim aka isaka adzowukumbɔ ikɔw ra abi arhim na ayɛi uku kpengkpeng. ");
INSERT INTO ldb_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bɔr àka abema anggamtsakmbi, àka akorhe iyiki ize ru umbɔ, àka adzowe umbɔ ikɔw niba arhimbi usu ififai. Mɔcɛ ugbɛtambi uwu ugɔgɔng, umbi awuri iwe angwɛ̃ Nggaa Uwuku Ugɔng, ubinkutsu unga aka amutuka abika akpɛ̃ itar uwɛɛ nu abi amɛn aka abewe. ");
INSERT INTO ldb_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Àka awu abika agũ atorh, ru nyaka Utɛmbi ra afã aka awu uwuku ugũ atorh. ");
INSERT INTO ldb_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","<<Niba atsumbi uvau ra anera, asi ítsukambɔ umbi uvau. Niba atsumbi ufai, asi ítsukambɔ umbi ufai. Àka atsũwe anera, awuri itsũwãmbɔ umbi. ");
INSERT INTO ldb_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Àka adzowe, awuri idzaambɔ umbi. Ugbiu utsutɔk, nu ujer, nu uzusa, nu utɔk, nu ubɔr ugba. Ugbiuwi umbi aka akũ amei, awuri ikũ ugbiu ha amei adzaa umbi.>> ");
INSERT INTO ldb_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Uyesu adɛyiwe umbɔ unyaka arherhe agɛ, <<Uner ibvuta adɛ̃ɛ̃ adarha uner ibvuta? Umbɔ ikivarhambɔ asi ígbambɔ ru ughwee? ");
INSERT INTO ldb_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ungwɛ̃ imesa asi inangnga uner uwuku umesuwe unga, bɔr ubɛn unera umbɔ aka amesuwe unga abina kishoo, awuri iwea ru nyaku uner uwuku umesuwe unga. ");
INSERT INTO ldb_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","<<Awu use utsu ungo urhi umbumbin ru usu undɔkango, nu usi inyãɔ̃ ungbũngkũ uku uwe ru usungo? ");
INSERT INTO ldb_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ungo ukorhu uguse nu ugɔr undɔkango ugɛ, <A ungwɛ̃mɛn, umum itsũwã umbumbinwi ru usungo,> ri ivangyɛ ungo uku usi idɛ̃ɛ̃ unyãɔ ungbũngkũ ru usu ukpungo? Ungo uner ukpukpeta, utirhu utsũwe ugbũkũ uwɔ ra asungo, nu urhi utai nu utsũwe umbumbin ru usu undɔkango. ");
INSERT INTO ldb_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","<<Ucucii uwuku uze usi íghwɛrmgbɔ ikpũrhã iyiki ibewe, nu ucucii uwuku ubewe usi íghwɛrmgbɔ ikpũrhã iyiki ize. ");
INSERT INTO ldb_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ahwɛng ubɛn ucucii ri ikpũrhãngge. Asi íkɔɔrmbɔ ikpũrhũ uvorhvo ru ididɔk, use ikpũrhĩ ihwerhe ru ididɔk. ");
INSERT INTO ldb_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Uner uwuku uze, aka isaka akũwã abin aka aze, akirakɛ aka awe ra amɛnnga. Uner uwuku ubewe, aka isaka akũwã abin aka abewe, akirakɛ aka awu ra amɛnnga. Nggee, abinkɛ aka atɔk ra amɛn unera, ake angwĩnga iki irherhe. ");
INSERT INTO ldb_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","<<Awu use utsu umbi ayisa umum, <A Uteijee, a Uteijee,> na asi ikorhumbi ubinkpi umum iki irherhe? ");
INSERT INTO ldb_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Umum iwuri idɛyiwamum umbi arherhe ri itsi uwuku uba ru umum na agũ irhɛm arherhamum na atɔ̃ itser nggu ake. ");
INSERT INTO ldb_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Unga awu ru nyaku uner idzin iya, unga asim abĩ aghoghotake, na atsu atarh idzin ni ifa. Ivangyɛ amɛ̃ aka adzek aba, ayiri ubandzina ukpɔ usi izusukpɔ, ubinkutsu ubandzin iya ha udɛ̃ɛ̃ ni ifa. ");
INSERT INTO ldb_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bɔr uwuku ugũ arherhamum na asi itɔ̃ itser nggu ake, awu ru nyaku uner idzin aka adzin iya nu uzuzeu. Amɛ̃ aka adzek aba ayiri iya ha ike igba, ni ida kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ivang Uyesu aka amaa arherhe kishoo ri igigũ anera, unga atsĩã Ukafanahum. ");
INSERT INTO ldb_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nggɔɔ ha ugãrhã unggba iwa abi iwa, uwuruwi uteiyanga aka abema akarhãrhã, aghonga unga akpurha abɔra akpe. ");
INSERT INTO ldb_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Unggba iwa abi iwa ha agũ isarhe Uyesu na adene akakũ abi Uyahuda azĩmbɔ ru unga, ashɔ̃rhũ Uyesu amaa aba akerhuwe ugãrhãnga. ");
INSERT INTO ldb_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ivangyɛ umbɔ aka aba ru Uyesu, umbɔ ashɔ̃rhã unga akarhãrhã agɛ, <<Imɛ̃ngge ungo ukerhuwe ugãrhã utsa ha, ");
INSERT INTO ldb_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ubinkutsu abema abĩmɛn. Unga adzin abã ifɛn-Nummɛn.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nggee Uyesu asok azĩã nggu umbɔ. Unga aka ayoki iya, uteiya abi iwa ha adene awɛrhanga umbɔ azĩ agɔr unga agɛ, <<A Uteijee, niba uhwaɔ uver, umum isi imɛ̃mum ungo iki iba ri iyamum. ");
INSERT INTO ldb_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ngge itsu umum inyã umum ibɔtũci umum iki inba ru ungo. Bɔr urherhu urhɛm, nu ugãrhãmum awuri ikerhunga. ");
INSERT INTO ldb_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Umum iwe ru ubok ijee, abi iwa abɔɔ awu ru ubokmum. Igɔr uwɛrɛ inggɛ, <Uzĩ,> unga azĩã, nu uwɔrɔ inggɛ, <Uba,> unga abanga. Umum iba igɔr ugãrhãmum inggɛ, <Ukorhe riminɛ,> unga akorhe.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Uyesu aka agũ rimi, unga adzeidzeu ru unga. Na adzipa udika anera aka adɔsa unga, na agɛ, <<Umum idɛyiwa umbi, umum ina isi ikpomum uner imangmang akarhãrhã ru Uisrairha rimi.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mɔcɛ, aner ha umbɔ aka adene umbɔ itser ha, abvui atsĩwã ri iya akpo ugãrhã ha aka akerhunga. ");
INSERT INTO ldb_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Asi idãrhũmbɔ, nu Uyesu azĩã uteu ukpɔɔ ugburh Unayin, angwɛ̃ imesanga nu anera arhɛrhɛ azĩmbɔ nggu unga. ");
INSERT INTO ldb_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Unga aka ayoka ra angwĩ uteu ha, anyã ukom umbɔ aka atsã, ukom hã uwu unanyĩ ungwɛ̃ utsɛrh uwɔɔ. Anera arhɛrhɛ adzeku utepa adɔsu utsɛ̃rhãpfu ha. ");
INSERT INTO ldb_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ivangyɛ Uteijee aka anyã utsɛrh ha, atorh afɛr unga. Unga agɔr unga agɛ, <<Niba uciupɔ akpe.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Unga agɔpa azĩ abangu ukom hã, abika atsã ukom hã adɛ̃ɛ̃ uku udzik. Unga agɛ, <<A ungwɛ̃dzɛm, umum ĩgɔr ungo ugɛ, usisok!>> ");
INSERT INTO ldb_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ukom hã uso asei isei nu utirha arherhe. Uyesu adzowuka unga ru uyisunga. ");
INSERT INTO ldb_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kishoo agũ iwei, na akpoi Unum agɛ, <<Uner uwuku usɔm Arherhu-Num ukugɔng aka abanga ru umɛn, Unum aba iyike anernga.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Isarhe iyɛrɛ ri itsi Uyesu itɛ̃rhã imaangge abĩ abi Uyahudiya nu ikãwãngge. ");
INSERT INTO ldb_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Angwɛ̃ imesu Uyohana adɛyiwe unga ifɛrhɛ ha kishoo. Uyohana ayisa angwɛ̃ imesanga avaa, ");
INSERT INTO ldb_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","adene umbɔ azĩ arhusu Uteijee, agɛ, <<Awu ungo uwu uwuku ububa ha, use umɛn ifosu uwukuse?>> ");
INSERT INTO ldb_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ivangyɛ aner ha aka azĩ atsĩ ru Uyesu, agɔr unga agɛ, <<Uyohana Uner Ubɔtisima unga adena umɛn ĩba irhusa ungo ĩgɛ, <Awu ungo uwu uwuku ububa ha, use umɛn ifosu uwukuse?> >> ");
INSERT INTO ldb_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ri ivang hã Uyesu akerhuwe arhɛrha anera abika awe ru uver ri irhãrhã, nu ípfu iyiki ibewe, na ayanguwe asu abi ibvuta arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nggee unga adzipa agɔr abika akũ itser ha aba agɛ, <<Àka abvui azĩ adɛyiwe Uyohana ubinkpi umbi aka anyã na agũ. Abi ibvuta anyãmbɔ, akatarhu azɛ̃rhũmbɔ uzɛ̃rhã, abi ingbim akerhumbɔ, abi igbau agũmbɔ, ikom isongge nggu urhɛ, adzowukumbɔ Isarhe Iyiki Ize ra atsũwã. ");
INSERT INTO ldb_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Unum awuri idzowuka idorh ru unerwi aka asi icicanga imangmangnga ri itsimum.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Angwɛ̃ itser Uyohana aka azĩmbɔ, Uyesu atirha arherhe nggu ikikɔnga ri itsi Uyohana agɛ, <<Umbi azĩ izɛrhu use ra arhum? Ubĩĩ uku uder ugba iki ifɛu? ");
INSERT INTO ldb_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ngge iba isi iwengge rimi, ude umbi azĩ izɛrhu use? Umbi azĩ izɛrhe unera aka atsim atorho imang? Ishingge rimi, abika igũibɛn na atsim atorho imang, aka isaka akpombɔ ra adzepurhe iyɛrhe ru utepa. ");
INSERT INTO ldb_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bɔr umbi adzek azĩ izɛrhu use? Uwuku usɔm Arherhu-Num? Ĩĩ, umum idɛyiwa umbi, ananga uwuku usɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Unga hã uwi umbɔ aka atsɛng ra Arherhu-Num ri itsinga agɛ, << <Umum iwuri idene ungwɛ̃ itsermum agbaashia ru ungo. Unga awuri igbishuwa atsĩndĩngo.> ");
INSERT INTO ldb_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Umum idɛyiwa umbi, abirabɛ akatsɛrh aka amar kishoo, unera asi igɔnga Uyohana. Rimi hã, uwuku ucia ri Iyɛrhe Unum agɔnga unga Uyohana.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Anera kishoo, nu abika ayɛsu ikirbi abĩ aka agũ irhɛm Uyesu, umbɔ abema ugɛ utsĩndĩ Unum uwu uku uzea, ubinkutsu Uyohana aka akorhuka umbɔ ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bɔr abi Ufarisi nu abika amesuwe Íkpem Umusa akpɛ̃mbɔ ubinkpi Unum aka abee ikorhuwe umbɔ, ubinkutsu Uyohana anasi ikorhuka umbɔ ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","<<Umum ikpangu aner udan ukpirɛ nggu use? Umbɔ awu ru nyaku use? ");
INSERT INTO ldb_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Awu ru nyaka awɛkaci aki iseyi ra anang izɛɛ na ayisa adɔkambɔ agɛ, << <Umɛn ibar aserhuwa umbi akpɛ̃mbi azera. Umɛn itsũ ubom akpe, umbi asi iciumbi akpe.> ");
INSERT INTO ldb_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Uyohana Uner Ubɔtisima aka aba, asi itãinga uborodi, asi ihwaa adɛ, umbi agɔra agɛ, <Awu ri ipfu iyiki ibewe.> ");
INSERT INTO ldb_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Nggayɛ Ungwɛ̃-Ner aka aba agha na ahwa, umbi agɛ, <Unyã uner uwuku ubvun igha abin nu ufĩrhã afĩrhã, uwɛrhɛ abika ayɛi ikirbi abĩ, na abi arhim.> ");
INSERT INTO ldb_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bɔr awu itser unera iwuri idɛyiwe ugɛ unga awea ri itsoi.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Utsa Ufarisi uwɔɔ ayisu Uyesu igha ubingha, Uyesu atsĩ ri iya utsa ha azĩ asei ra anang ubingha. ");
INSERT INTO ldb_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Utsɛrh uwɔɔ ru uteu ha awu ra arhim. Ivangyɛ unga aka agũ ugɛ Uyesu awe ri igha ubingha ri iya utsa Ufarisi ha, unga azĩ nggu udzoma atsei isung imang akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Unga adɛ̃ɛ̃ udiku undzingnga, udika adaknga, aciu awua anyĩ ra adaknga, na akũ igwar itsinga adzukuwe, na atar uwɛɛ, na atsuke atsei isung hã nu ake. ");
INSERT INTO ldb_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ivang utsa Ufarisi uwuku uyisa unga, aka anyã rimi, unga agɔr ra amɛnnga agɛ, <<Uda utsak uwurɛ awu uner uwuku usɔm Arherhu-Num, unga awuri ihwɛngnga ungamɔ ani ibasa abok ru unga, ikpũ utsɛrh ha aka awe, awu ra arhim.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Uyesu agɔr unga agɛ, <<A Usiman, umum iwu ru ubina ukpi umum iki idɛyiwa ungo.>> Unga agɛ, <<A umarhem, uma udɛyiwa.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Uyesu agɛ, <<Inera ivaa agha uvɛrh unera aka akɔwe umbɔ imang. Unying agha uvɛrh íshaa imang anaka atɔ̃ɔ̃, uwu uvaa agha uvɛrh íshaa imang isɔka itɔ̃ɔ̃. ");
INSERT INTO ldb_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ikivarhambɔ ashimbɔ ri imangyɛ umbɔ aka ifai unga. Unga anekuka umbɔ ikivarhambɔ. Uwukusong awuri ibema unga anang udɔka?>> ");
INSERT INTO ldb_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Usiman agɔr unga agɛ, <<Uwuruwi uvɛrh unga urhɛrhɛ umbɔ aka aneke unga awuri ibema anang.>> Uyesu agɛ, <<Ungo uzharhe mɔnɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Mɔcɛ unga adzipa arhi udiku utsɛrh ha na agɔr Usiman agɛ, <<Ungo unyã utsɛrh uwurɛ? Umum iki iba ri iyango, ungo usi idzaango amɛ̃ aka asorha adak, bɔr unga akũ anyĩnga awua ra adakmum na afire ake nggu igwar itsinga. ");
INSERT INTO ldb_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ungo usi idzaango umum imor nu itar uwɛɛ, bɔr utsɛrh uwurɛ udzur ri ivangyɛ umum iki itsĩwã ri iya ikɛrɛ unga anasi nekuka idzaa umum imor nu itang awɛɛ. ");
INSERT INTO ldb_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ungo usi itsukango atsei ni itsimum, bɔr unga atsukanga atsei isung ra adakmum. ");
INSERT INTO ldb_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nggee, umum idɛyiwa ungo, aka itsũwũkumbɔ arhɛrha arhimnga ha, ibibemanga iwu irhɛrhɛ. Bɔr uwuruwi umbɔ aka atsũwe arhim ukunjiir, abema ukunjiir.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Mɔcɛ, Uyesu agɔr utsɛrh ha agɛ, <<Aka atsũwũkumbɔ arhimngo.>> ");
INSERT INTO ldb_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Atsen abɔɔ atirhi igɔr adɔkambɔ agɛ, <<Awu ungamɔ nuwi, atsũwũka arhim?>> ");
INSERT INTO ldb_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Uyesu agɔr utsɛrh ha agɛ, <<Imangmangngo ngge ifɔrha ungo, uzĩ uku utɔɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Akɛrɛ ha aka amaa, Uyesu azɛ̃rhã amaa iteu iyiki igɔng nu iyiki ici, adũwã Isarhe Iyiki Ize iyi Iyɛrhe Unum. Abɔrɔ ha usɔkdũmɛn awu nggu unga, ");
INSERT INTO ldb_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","nu ikɛi akatsɛrh abɔɔ aka akerhe ri ípfu iyiki ibewe nu irhãrhĩ iyɔɔ. Umaryamu Umagadarha, uwu umbɔ aka atsũwe ípfu iyiki ibewe utɔɔva. ");
INSERT INTO ldb_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nggu Uyowana, utsɛrha Ukuza unggbaashi ufɔm iya Uhiridu, nu Usuzana, nu arhɛrha akatsɛrh abɔɔ akũ abina arhɛrhɛ ayike Uyesu nu angwɛ̃ imesanga. ");
INSERT INTO ldb_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Anera arhɛrhɛ adzeyi ri iteu aba akɔng ru Uyesu, unga arherhe unyaka arherhe agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","<<Uner ikpũ abin akũ ikpũnga azĩ ididoi. Unga aka annaa ikpũa ri icanga, ikpũ iyɔɔ igba ru utsĩndĩ, umbɔ azɛ̃rhã ajang adak, anunu aba akpɔuke iyi ha. ");
INSERT INTO ldb_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Iyɔɔ igba nu ifa, ngge iki imɛr, isi idãrhũngge ni ikoingge, ubinkutsu amɛ̃ ashike ra anang hã. ");
INSERT INTO ldb_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Iyɔɔ ikɛi igba ra aga ididɔk, ngge imɛr ni iseng, ididɔk ha itong ngge. ");
INSERT INTO ldb_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ikpũ iyɔɔ igba ra abĩ aka aze, imɛr iseng ighwɛr ikpũrhã inainaka inangngge ikpũ ha umbɔ aka adoi.>> Unga aka arherhe rimi, na atsarhi irhaknga agɛ, <<Uner ato akika agũ, unga agũ.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Angwɛ̃ imesanga arhusa unga agɛ awu use uwu agben unyaka arherhe ha. ");
INSERT INTO ldb_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Unga agɛ, <<Aka adɛyiwambɔ umbi abinkɛ aka awɔk aki Iyɛrhe Unum. Bɔr ra abɔɔ umum irherhe unyaka arherhe nggu umbɔ, << <nggee umbɔ awuri irhimbɔ na asi ínyãmbɔ. Awuri igũmbɔ na asi íhwɛngmbɔ agbena.> >> ");
INSERT INTO ldb_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","<<Agben unyaka arherhe ha akɛ, ikpũ hã iwu Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Iyɔrɔ iyiki igba nu utsĩndĩ iwu abirabɛ aka agũ, bɔr Undenggũ aba anyanga arherhe ha adzeke ra amɛnmbɔ, utsur umbɔ ayɛimbɔ idzidzɛrhe na akpombɔ ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Iyɔrɔ iyiki igba ni ifa, iwu abirabɛ aka ayɛi arherhe ha nggu anggɔm ri ivangyɛ umbɔ aka agũ, bɔr umbɔ ashimbɔ ra anũnang. Umbɔ akpurha ayɛi idzidzɛrhe ivanga ukunjiir, bɔr umbɔ aka avira umbɔ, umbɔ azĩmbɔ udĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ikpũ iyɔrɔ iyiki igba ru aga ididɔk, iwu abirabɛ aka agũ Arherhu-Num, bɔr igũ ighong iwu ru ubin, nu igũibɛn upfung itsu umbɔ asi isengmbɔ na aghwɛrmbɔ ikpũrhã. ");
INSERT INTO ldb_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Bɔr ikpũ iyɔrɔ ra abĩ aka aze, iwu abi amɛn aka aze, abika agũ Arherhu-Num na anyanga akpɔm ra amɛnmbɔ, umbɔ abima na aghwɛr ikpũrhã. ");
INSERT INTO ldb_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","<<Unera asi ítsuka irhirhang awɔkuka ru utsutseu, use atsukuka ra ada ukoma. Ĩ'ĩ, awuri idene irhirhang hã afafã nú anang idɛ̃ɛ̃ke ru abika atsutsĩwã anyã ananga arhang. ");
INSERT INTO ldb_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ubin usi íwɔkpɔ umbɔ aka asi ínyãmbɔ. Ikɛi ubin usi ítsirkpɔ umbɔ aka asi íhwɛngmbɔ ra awiya. ");
INSERT INTO ldb_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nggee àka ayepa anyã na angwɛ̃dzɛn ri igigũ. Uwuruwi aka awe ru ihwihwɛng awuri itomuwe unga akpo arhɛrhɛ. Uwuruwi aka ashia, awuri iyɛse ungwɛ̃rhĩ ihwihwɛng ha unga aka awerangge.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Uya Uyesu nu angwɛ̃mbɔ asok aba ru unga, bɔr umbɔ afɔr izĩ atsĩ ru unga adambɔ, ubinkutsu anera arhɛmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Uwɔɔ agɔr unga agɛ, <<Uyango uwɔɔ nu angwɛ̃mbi adɛ̃ɛ̃ ra awiya rɔ, abee inyã ungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bɔr unga agɔr umbɔ agɛ, <<Abika agũ Arherhu-Num na atɔ̃ itser nggu ake, umbɔ awu uyamum nu angwɛ̃mɛn.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Unum ukpɔɔ Uyesu agɔr angwɛ̃ imesanga agɛ, <<Umɛn igar ukau ha izĩ afɛn akɔrɔ.>> Umbɔ asok atsĩ ru ukhukhɔɔ amɛ̃ azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Umbɔ awu ru uzɛ̃rhã, unga arhaa urhɔ. Ufin inai nggu ugba uso ubvun nu ukau ha ukwɛr amɛ̃ utsuke ru ukhukhɔɔ amɛ̃mbɔ, uwuri itsĩme umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Angwɛ̃ imesa ha azĩ azita unga agɛ, <<A Uteiya, a Uteiya! Umɛn iki itsĩmmɛn!>> Unga azir asok atsɛrhu ugba nu ibvun amɛ̃ hã udɔɔr unu, ananga uku utɔɔ. ");
INSERT INTO ldb_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Unga arhusa angwɛ̃ imesanga agɛ, <<Imangmangmbi iwerɛngge?>> Nggu iwei umbɔ adzeidzeu, na arhusa adɔkambɔ agɛ, <<Awu ungamɔ nuwi ikɛi, atsɛrhu ugba nu amɛ̃, ake agũna unga?>> ");
INSERT INTO ldb_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Umbɔ atsĩ ukhukhɔɔ azĩ atsĩ abĩ Ugarasa, ake awu ugar ukau Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ivangyɛ Uyesu aka acipa nu ubang ukau ha, unga agbopa unerwi aka awe ru ipfu iyiki ibewe ru uteu ha. Aka adera utsa ha asi itsima atorho use aseisa ri iya, aseiyi ra adzak. ");
INSERT INTO ldb_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ivangyɛ unga aka anyã Uyesu, unga atsu ivum na agba ra adaknga na atsarhi irhaknga agɛ, <<Ungo ubee usengo nggu umum Uyesu, Ungwɛ̃ Unum Uwuku Ugɔng? Umum ishɔ̃rhã ungo niba udzaango umum uver!>> ");
INSERT INTO ldb_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Unga irherhe rimi ubinkutsu Uyesu aka agɔra ipfu iyiki ibewe ha ugɛ ngge idze ru utsa ha. Aka adera ngge iki isaki idzur unga, anera aka isaka abow adaknga nu aboknga nggu inyãwã na adzɛu unga, bɔr unga anang apupuwe, ipfu iyiki ibewa ha iki isaki ikũna unga izĩngge ra arhum. ");
INSERT INTO ldb_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Uyesu arhusa unga agɛ, <<Itsokngo igburh ungamɔ?>> Unga agɛ, <<Ukpusha,>> ubinkutsu ípfu iyiki ibewa ha iwu irhɛrhɛ iki itsĩ ru unga. ");
INSERT INTO ldb_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ngge ishɔ̃rhã unga, unga niba atsuka ngge izĩngge ru ughorkaghor angwĩ ra anangkɛ umbɔ iki igbang ípfu iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ikpui arhede niyɔ iwu ru ughãwã ra anang akɔɔ nu ubang igũ iki ikhapa nu ukau ukugɔng. Ípfu iyiki ibewa ha ishɔ̃rhũ Uyesu ama aneke ngge itsĩ ru ngge, unga nekuka. ");
INSERT INTO ldb_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ípfu iyiki ibewa ha iki idzeku utsa ha ngge itsĩngge ru ukpui arhede ha. Ukpui arhede ha iso itĩ icipungge ru ukau ukugɔng hã, íkpengge ra amɛ̃. ");
INSERT INTO ldb_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ivangyɛ abi idzɛu arhede ha aka anyã ubinkpi uku ukorhe, umbɔ asok atĩ azĩ adzowe isarhe ru utepa nu ikãwãngge. ");
INSERT INTO ldb_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Anera adzek aba inyã ifɛrhɛ ha. Umbɔ aka aba atsĩ nu Uyesu, umbɔ akpurha anyã utsa ha ípfu iyiki ibewa ha iki idzeku unga atsim atorho asei ra adak Uyesu nggu amɛnnga uku urhirhiki, iwei ifɛr umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Abirabɛ ifɛrha ha iki ikorhe ra asumbɔ, adɛyiwe anera ubinkpi uku utsu uner ípfu iyiki ibewe ha akerhe. ");
INSERT INTO ldb_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Iwei iki ifɛr anera kishoo ri ikãwã abĩ Ugarasa, umbɔ ashɔ̃rhũ Uyesu unga ama adzeka ra abĩmbɔ. Nggee unga asok atsĩ ukhukhɔɔ amɛ̃ azĩã. ");
INSERT INTO ldb_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Utsa ha ípfu iyiki ibewa ha iki idzeku unga ashɔ̃rhũ Uyesu agɛ unga adɔsa unga, bɔr Uyesu adene unga azĩã agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","<<Ubvui uzĩ ri iya nu udɛyiwe ubinkpi Unum aka akorhuwa ungo.>> Nggee utsa ha azĩã, na adɛyiwe utepa kishoo ubinkpi Uyesu aka akorhuwe unga. ");
INSERT INTO ldb_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ivangyɛ Uyesu aka abvui aba, anera arhɛrhɛ aba aghwe unga, ubinkutsu umbɔ kishoo asei idzɛu unga. ");
INSERT INTO ldb_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mɔcɛ utsa uwɔɔ agburh Uyayiru, unggbaashi abã ifɛn-Num, aba agba ra adak Uyesu, na ashɔ̃rhã unga ama azĩ ri iyanga, ");
INSERT INTO ldb_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ubinkutsu unanyĩ unapunga, imɛknga iki iyongge usɔkdũmɛn, aka abɔr ikpikpe. Uyesu awu ru utsĩndĩ anera arhɛrhɛ afĩĩ azɛ̃rhã nggu unga. ");
INSERT INTO ldb_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Utsɛrh uwɔɔ aka arhong adzirh imɛka usɔkdũmɛn awe umɔ, bɔr unera asi idɛ̃ɛ̃ akerhuka unga. ");
INSERT INTO ldb_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Unga aghɔ̃rhã aba udiku undzing Uyesu na abangu ifɛn atorhanga, kanying irhong adzirhnga ikerhungge. ");
INSERT INTO ldb_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Uyesu arhusa agɛ, <<Ungaa abanga umum?>> Umbɔ kishoo atsɛyimbɔ, Ubitru agɛ, <<A Uteiya, anera arhɛrhɛ aka akɔng afĩĩ azɛ̃rhã nggu ungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bɔr Uyesu agɔr agɛ, <<Unera abangunga umum. Umum ihwɛng ijee iki idzengge ru umum.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Mɔcɛ utsɛrh ha anyã unga asi idɛ̃ɛ̃ awɔka, unga adzek azang aba agba ra adak Uyesu. Ra asu anera kishoo, unga adɛyiwe umbɔ ubinkpi uku utsu unga abanga unga, nu ibibanga hã iki ikerhuwe unga kanying. ");
INSERT INTO ldb_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Mɔcɛ Uyesu agɔr unga agɛ, <<A unapmum, imangmango ngge ikerhuwe ungo, uzĩ uku utɔɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Uyesu ana awu ra arherhe nu uwɔɔ adzeki iya Uyayiru unggbaashi ubã ifɛn-Num hã aba adɛyiwe unga agɛ, <<Unapungo aka akpea. Niba udzowukɔ uver ikɛi ru uner imesa.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Bɔr Uyesu aka agũ rimi, unga agɔr Uyayiru agɛ, <<Niba ugũo iwei, uwe ri imangmang ukpekũ, unapungo awuri ikerhunga.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Unga aka atsĩ ri iya Uyayiru, unga asi ineke unera atsĩã nggu unga Ubitru nu Uyohana nu Uyaku nu utesa nu uyisa una hã ukpekũ. ");
INSERT INTO ldb_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Anera kishoo ra awiya iya adɛ̃ɛ̃ iciu akpe, na atsui ivum ni itsi una hã. Uyesu agɛ, <<Àka aneke iciu akpe. Una hã anasi ikpea, awu ru urhɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Umbɔ anyĩrhã unga, ahwɛngmbɔ unga aka akpea, ");
INSERT INTO ldb_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","bɔr unga adzur ubok una hã akpɔm, na agɛ, <<A unapmum, usisok!>> ");
INSERT INTO ldb_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ipfu una hã ibvui ibangge, kanying unga abera asok. Mɔcɛ Uyesu atsu umbɔ adzowe ubingha ru una hã. ");
INSERT INTO ldb_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Abika amar una hã adzeidzeu, bɔr unga akɛna umbɔ niba adɛyikumbɔ unera ifɛrha ha. ");
INSERT INTO ldb_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Uyesu aka ayisa angwɛ̃ imesanga usɔkdũmɛn ananga unying, unga adzowe umbɔ iker nu ijee iyiki itsũwe ípfu iyiki ibewe kishoo na akerhuwe irhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Adene umbɔ adzek adzowe isarhe Iyɛrhe Unum na akerhuwe abi irhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Unga agɔr umbɔ agɛ, <<Àka niba anyangumbi ubin nu uzɛ̃rhã hã, niba anyangumbi igbong, use ukpoka, use ubingha, use uhwɛk. Niba anyangumbi atorho avaa. ");
INSERT INTO ldb_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ubɛn iyaa umbi aka itsĩ, àka asei umɔ utsɛku umbi aka isoku uteu ha. ");
INSERT INTO ldb_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Anera aba asi iyɛimbɔ umbi, àka awashuwe uzurhu adakmbi ri ivangyɛ umbi aka idzek utepumbɔ. Umgbɔ uwu utsar ukpuku ubewe ru umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nggee umbɔ adzek azɛ̃rhã atsĩrhũmbɔ iteu, adzise Isarhe Iyiki Ize na akerhuwe anera ri inanga kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Uhiridu uyɛrhe aka agũ abin hã kishoo aka akorhe, unga adzununga, ubinkutsu abɔɔ agɛ awu Uyohana aka asoku udzak. ");
INSERT INTO ldb_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Abɔɔ agɛ uner uwuku usɔm Arherhu-Num Uirhiya unga adzeka, abɔɔ ikɛi agɛ awu uner uwuku usɔm Arherhu-Num uwu ishaisha unga asok nggu urhɛ. ");
INSERT INTO ldb_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Bɔr Uhiridu agɛ, <<Umum iki izharhukũ itsi Uyohana. Awu ungamɔ uwi ikɛi umum iki ini igosha ikpũ abin akɛrɛ?>> Na abee inyã unga. ");
INSERT INTO ldb_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ivangyɛ abi itser Uyesu aka abvui aba, umbɔ azĩ asɔme unga ubinkpi umbɔ aka akorhe. Mɔcɛ unga akũna umbɔ, umbɔ abvui adzek umbɔ ikiyikambɔ azĩmbɔ uteu ukpɔɔ ugburh Ubetsaida. ");
INSERT INTO ldb_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bɔr anera aka agũ unga awe ru nggɔɔ ha, umbɔ adɔsa unga. Unga ayɛi umbɔ na arherhe arherhe Iyɛrhe Unum nggu umbɔ, na akerhuwe abika abee ikikerhe. ");
INSERT INTO ldb_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Urhɛɛ uku uwe angwɛ̃ imesanga usɔkdũmɛn aba agɔr unga agɛ, <<Udɛyiwe anera umbɔ azĩmbɔ ru umbɔ atsĩ ri iteu nu icang azĩ abee ubingha nggu anang inũ, ubinkutsu nggimi awu arhum.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bɔr unga agɔr umbɔ agɛ, <<Àka adzowe umbɔ ubin umbɔ agha.>> Umbɔ agɛ, <<Umɛn ikpurhi iwu ru atsɔku uborodi atɔ̃ɔ̃ nu abɛrh avaa, ungo ubee umɛn izĩ igoi ubingha ukpurukpi uku umɛ̃ɛ̃ arhɛrha anera abɛrɛ kishoo?>> ");
INSERT INTO ldb_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Akatsa abirabɛ aka awu umɔ ayombɔ anaka agɔnga atɔ̃ɔ̃. Bɔr unga agɔr angwɛ̃ imesanga agɛ, <<Àka atsu umbɔ asei ukpu ukpusha, ubɛn ukpusha uyokpɔ isɔka itɔ̃ɔ̃.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Angwɛ̃ imesanga atsu anera kishoo asei ukpukpusha nú abĩ. ");
INSERT INTO ldb_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Uyesu ayɛi ímarhu uborodi atɔ̃ɔ̃ hã nu abɛrh avaa ha, unga aka abere arhi afã na atar uwɛɛ adzowe Unum na atsɔka ake. Mɔcɛ unga adzowe angwɛ̃ imesanga umbɔ agashuwe anera. ");
INSERT INTO ldb_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Umbɔ kishoo agha ashur na abɔre awushunga. Angwɛ̃ imesanga arhɔsa ake atɔk azĩnga usɔkdũmɛn. ");
INSERT INTO ldb_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Unum ukpɔɔ Uyesu ikiyikanga awu ri ifɛn-Num na angwɛ̃ imesanga awu nggu unga, unga arhusa umbɔ agɛ, <<Anera agɔr agɛ umum iwu ungamɔ?>> ");
INSERT INTO ldb_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Umbɔ agɔr unga agɛ, <<Abɔɔ agɛ ungo uwu Uyohana Uner Ubɔtisima, abɔɔ agɛ Uirhiya, na abɔɔ agɛ uner uwuku usɔm Arherhu-Num uwu ishaisha aka abvui aba nggu urhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Unga arhusa umbɔ agɛ, <<Bɔr umbi agɔr agɛ use? Umbi agɔr agɛ umum iwu ungamɔ?>> Ubitru adzipa agɛ, <<Ungo uwu Ukiristo uwu Unum.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Uyesu avange umbɔ utsur umbɔ adɛyikumbɔ unera arherhe akɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Unga agɛ, <<Awu ufang Ungwɛ̃-Ner aka ihwa ayetnum ra abina arhɛrhɛ ra akakũ, nu ateiya abika adzowe idɛm-Num, na abika amesuwe Ikpem, awuri ikpɛ̃mbɔ unga. Awu ufang umbɔ aka ifɛr unga, ru unum untaar unga awuri isok abɛka.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Mɔcɛ unga agɔr umbɔ kishoo agɛ, <<Ubɛn unera aba awuri idɔsunga umum, awu ufang unga ikpɛ̃ɛ̃ itsikamnga, na anyangu igãrhãmau ucuciianga ubɛn unum adɔsa umum. ");
INSERT INTO ldb_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nggee ubɛn unerwi aka abee ifɔrh urhɛnga, umgbɔ uwuri igwirmgbɔ. Bɔr uwuruwi urhɛnga uku ugwir ri itsimum, afufɔrh umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Izea iwu use, unera aba akpo abin upfung kishoo bɔr urhɛnga ugwirmgbɔ? ");
INSERT INTO ldb_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Unera aba agũã atsak umum nu arherhamum, Ungwɛ̃-Ner awuri igũa atsak uner ha ri ivangyɛ unga aka iba ri ikpikpoi Utɛnga, nu ikpikpoi asarkasar ípfu itser-Num. ");
INSERT INTO ldb_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Umum indɛyiwa umbi idzidzɛrhe, abɔɔ rabɔ adɛ̃ɛ̃ nggimi awuri inyãmbɔ Iyɛrhe afã kata na adɔrha akpe.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Inuma utɔrɔk iki iyok, Uyesu aka amaa arherhe akɛrɛ, unga akũ Ubitru nu Uyohana nu Uyaku nggu unga, umbɔ afũmbɔ igũ, azĩ ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Unga aka adɛ̃ɛ̃ ifɛn-Num, unyɛ̃ɛ̃nga udzipu uwuwemgbɔ, na atorhanga adiki iwu uku upɛ̃rhɛng ru nyaki inyĩnyaki inai. ");
INSERT INTO ldb_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Inera ivaa, Umusa nggu Uirhiya, ");
INSERT INTO ldb_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","aka apɛng na arhang ru nyaki ishaa unum adɛ̃ɛ̃ arherhe nggu Uyesu. Umbɔ arherhe arherhe ri itsi akpenga iki iba itsuifɛr ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ubitru nggu awɛrhu uzɛ̃rhãnga awe ru urhɔ. Umbɔ aka azir, umbɔ akpurha anyã irhirhang Uyesu nggu anera avaa aka adɛ̃ɛ̃ nggu unga. ");
INSERT INTO ldb_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ikivarhambɔ aka awuri abɔre Uyesu, Ubitru agɔr unga agɛ, <<A Uteiya, azea umɛn iki iwu nggimi! Uneke umɛn itar atsurha ataar, unying uwu ungo, unying uwu uwuku usɔm Arherhu-Num Umusa, unying uwu uwuku usɔm Arherhu-Num Uirhiya.>> Asi ihwɛngnga ubinkpi unga aka arherhe. ");
INSERT INTO ldb_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ana asi ibvura angwĩnga, akpurha anyã amɛɛ aka aba atsire umbɔ. Amɛɛ aka awu uzĩrhzĩ ru umbɔ, angwɛ̃ imesanga adiki igũ iwei. ");
INSERT INTO ldb_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Urhɛm udzeka ra amɛɛ ha ugɔr ugɛ, <<Uwɛrɛ awu Ungwɛ̃mum, uwuruwi umum iki itsũ. Àka akpeto ru unga!>> ");
INSERT INTO ldb_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Urhɛm hã uku udɔng, umbɔ akpurha anyã Uyesu ikiyikanga. Angwɛ̃ imesa ha akpɔm arherhe ha ra amɛnmbɔ, asi isɔmukumbɔ unera ri inum hã ubinkpi umbɔ aka anyã. ");
INSERT INTO ldb_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ukpe unum uvaa, umbɔ aka abvui ri igũ hã acipuwa, anera arhɛrhɛ aba akɔng ru unga. ");
INSERT INTO ldb_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Unera ri ikikɔnga atsarhi irhaknga agɛ, <<A umarhem! Umum ishɔ̃rhã ungo umaa uba uyike ungwɛ̃mum, umum iwu ra unga ikiyikanga! ");
INSERT INTO ldb_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ipfu iyiki ibewe iki isaki ifũ unga, itsu unga anu itsu ivum. Iki isaki igbipa unga itar, iyornga izang, ufuu udzeyi ra angwĩnga. Isi ínekungge unga utsɛku ngge iki inayiwe unga akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Umum iki ishɔ̃rhã angwɛ̃ imesango umbɔ ama atsũwe, bɔr umbɔ afɔr adambɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Mɔcɛ Uyesu agɛ, <<Umbi abi udan ukpirɛ, abika asheri imangmang, abi amɛn aka abewe. Umum iki isei ĩdãrhũmum nggu umbi, ukang umbi aka awe ru imangmang ru umum? Utsɛku ukang umum iki ibima nggu ida imangmangmbi? Ukũ ungwɛ̃ hã uba nggɛɛ ru umum.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ungwɛ̃ hã awu ru utsĩndĩ uwuku ububa, ipfu iyiki ibewe ha ishipa unga itar nu abĩ, iyornga itirhi izizang. Uyesu atsɛrhu ipfu iyiki ibewe ha, akerhuwe ungwɛ̃ hã, adzowuka unga ru utesa. ");
INSERT INTO ldb_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kishoo aka awu umɔ adzeidzeu igɔng Unum. Umbɔ kishoo ana awe ru idzeu ru kishoo ubinkpi Uyesu aka akorhe, unga agɔr angwɛ̃ imesanga agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","<<Àka akpeto ru ubinkpi umum iki idɛyiwa umbi! Awuri ighambɔ adak Ungwɛ̃-Ner adzowe unga ra abok anera.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bɔr umbɔ asi ihwɛngmbɔ ubinkpi unga aka arherhe. Awɔmbɔ ake ru umbɔ utsur umbɔ ahwɛngmbɔ. Umbɔ ikɛi agũ iwei irhusa unga arherhe ha. ");
INSERT INTO ldb_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Uning usomgbɔ ra angwɛ̃ imesanga agɛ uwukusong awu ukugɔnga ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Uyesu ahwɛnga ifɛrhkɔmbɔ, unga ashupu ungwɛ̃rhũ uwɛkuci, atsu unga adɛ̃ɛ̃ akhapa nggu unga. ");
INSERT INTO ldb_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Unga agɔr umbɔ agɛ, <<Ubɛn unerwi aka ayɛisa ungwɛ̃rhũ ungwɛ̃ uwurɛ ri itsokmum, unga ayɛi umum nukpɔ. Ikɛi ubɛn unerwi aka ayɛi umum unga ayɛi uwuku udena umum ĩba. Uwuruwi aka awu uwuku ucia ru umbi kishoo, unga awu ukugɔnga.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Uyohana agɛ, <<A Uteiya, umɛn inyã uwɔɔ asi iwea nggu umɛn na adɛ̃ɛ̃ itsusuwe ípfu iyiki ibewe ri itsokngo. Umɛn ibee ikɛn unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Uyesu agɛ, <<Niba akɛnmbi unga, ubɛn unerwi aka asi iwea unggamtsakmbi awu uwɛrhambi.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ivangyɛ umbɔ aka ishipu Uyesu azĩ ra afã iki iyo, unga atsu amɛnnga akarhãrhã abee izĩ Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Unga adene abi itser umbɔ agbaashia, umbɔ azĩmbɔ ungwɛ̃rhũ uteu ru Usamariya azĩã agbishuwe abina ru unga. ");
INSERT INTO ldb_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bɔr abi uteu ha akpɛ̃mbɔ iyɛi unga, ubinkutsu umbɔ ahwɛngmbɔ unga awuri itɔng azĩ Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Angwɛ̃ imesanga umbɔ Uyaku nggu Uyohana aka anyã rimi, umbɔ arhusa agɛ, <<A Uteijee, ungo ubeengo umɛn iyisu urha ra afã ukpɔ ucipuwa uba ukpĩĩwe umbɔ?>> ");
INSERT INTO ldb_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bɔr Uyesu adzipa, atsɛrha umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Umbɔ azĩmbɔ ungwɛ̃rhũ uteu ukpɔɔ. ");
INSERT INTO ldb_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Umbɔ aka awu ru utsĩndĩ, utsa uwɔɔ agɔr Uyesu agɛ, <<Umum idɔsumum ungo ubɛn anangkɛ ungo iki izĩ.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Uyesu adzipa agɔr unga agɛ, <<Íjui ngbako iyiki ici iwengge ri ingwĩngge, anunu ikɛi aweke ra ashiyake, bɔr Ungwɛ̃-Ner ashia ra anangkɛ unga aka itsu itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Agɔr uwɔɔ ikɛi agɛ, <<Udɔsa umum.>> Bɔr uner ha agɛ, <<A Uteijee, uneke umum izĩ indzake utɛmum kata.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Uyesu agɔr unga agɛ, <<Uneke abika akpe adzake abika akpembɔ. Bɔr ungo uzĩ udũwũ Iyɛrhe Unum.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Uner uwɔɔ ikɛi agɛ, <<A Uteijee, umum idɔsumum ungo, bɔr uneka umum izĩ ighwe unuma nggu abi iyamum kata.>> ");
INSERT INTO ldb_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Uyesu adzipa agɔr agɛ, <<Ubɛn unerwi aka atsai ikau irham na anu irhi undzingnga, asi imɛ̃ɛ̃ itɔ̃ itser ri Iyɛrhe Unum.>> ");
INSERT INTO ldb_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Akɛrɛ ha aka amaa, Uteijee asɛng inera isɔka utɔɔva nu avaa. Unga adene umbɔ ivaivaa umbɔ agbaashia azĩ ubɛn uteukpi nu inangyɛ unga aka izĩ. ");
INSERT INTO ldb_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Unga adɛyiwe umbɔ agɛ, <<Igbɛra abin iwe irhɛirhɛ, bɔr abi itsera awe ukunjiir. Àka ashɔ̃rhũ Uteijee uwu igbɛra abin, unga adene abi itser ri icang igbɛra abinnga. ");
INSERT INTO ldb_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Àka azĩ! Umum idena umbi ru nyaka angwɛ̃ idɔi ra ateu íjui ngbako. ");
INSERT INTO ldb_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Àka niba akpɔmmbi uhwɛk use ukpoka use abadak. Àka niba aghwembi unera ru utsĩndĩ. ");
INSERT INTO ldb_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","<<Ubɛn iyakɛ umbi aka itsĩ, àka atirha agɔr agɛ, <Ididɔɔr ri iya ikɛrɛ.> ");
INSERT INTO ldb_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Uner ididɔɔr aba awea ri iya ha, ididɔɔrambi iwuri iwe nggu unga. Unera aba ashia, ighwembi iyi ididɔɔr ibvui iba ru umbi. ");
INSERT INTO ldb_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Àka asei ri iya ha, àka agha na ahwa ubɛn ubinkpi umbɔ aka adzaa umbi, ubinkutsu, imɛ̃ngge umbɔ afai uner itser ugbɛtanga. Àka niba akpɔwumbi aya. ");
INSERT INTO ldb_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","<<Ubɛn uteukpi umbi aka atsĩ, umbɔ aba ayɛimbɔ umbi, àka agha ubɛn ubinghakpi umbɔ aka idzaa umbi. ");
INSERT INTO ldb_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Àka akerhuwe abi irhãrhã abirabɛ aka awu umɔ, àka adɛyiwe anera agɛ, <Iyɛrhe Unum iki iyongge nggu umbi.> ");
INSERT INTO ldb_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bɔr ubɛn uteukpi umbi aka itsĩ umbɔ aba akpɛ̃mbɔ iyɛi umbi, àka adɔsa atsĩndĩ uteu ha na agɔr agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","<Uzurhu uteumbi uku unyapa ra adakmɛn, umɛn iwashuwa umgbɔ ru umbi. Bɔr àka ahwɛng ugɛ Iyɛrhe Unum iki iyongge.> ");
INSERT INTO ldb_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Umum idɛyiwa umbi, ru unum ukpuku utsu uvau, Unum awuri igũ atorh Usɔdɔm ananga uteu ha. ");
INSERT INTO ldb_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","<<Atorhngo, Ukorazin! Atorhngo, Ubetsaida! Akorhuwa umbi abin idzeu arhɛrhɛ, umum iba ikorhumum ake ru Utaya nggu Usidon, umbɔ awuri idzipumbɔ iki ifitem, umbɔ awuri itsim ashaka atorho, na asei ra atɔɔ. ");
INSERT INTO ldb_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bɔr Unum awuri igũa atorh Utaya nu Usidon ru unum ukpuku uvarha arherhe anangnga umbi. ");
INSERT INTO ldb_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ungo igango, Ukafanahum, ungo ukaifɛrhkɔ ugɛ awuri ibera ungo afũ afã? Ĩ'ĩ, awuri ikũna ungo acipa ra anang isei abika akpukpe. ");
INSERT INTO ldb_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","<<Unga uwuku ikpeto ru umbi, akpeto ru umum. Uwuruwi aka akpɛ̃na umbi ikɛi akpɛ̃na umum. Bɔr uwuku ukpɛ̃ɛ̃ umum, akpɛ̃ uwuku udena umum ĩba.>> ");
INSERT INTO ldb_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Isɔka utɔɔva na avaa ha abvui aba nggu anggɔm na agɔr agɛ, <<A Uteijee, ípfu iyiki ibewe igũna umɛn ri itsokngo!>> ");
INSERT INTO ldb_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Uyesu adzipa agɔr umbɔ agɛ, <<Umum inyãmum Ushaitan aka agba iki ifitem ru nyaki inai iki inyaka. ");
INSERT INTO ldb_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Umum iki idzaamum umbi ijee umbi aka ijeku íbvui nu ínna, na atɔngmbi kishoo ijee Undenggũ, ubin isi ínayikpɔ umbi. ");
INSERT INTO ldb_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Niba agɔmmbi anggɔm ugɛ ípfu iyiki ibewe igũna umbi, bɔr àka awu ra anggɔm ugɛ aka atsɛngmbɔ atsokmbi ra afã.>> ");
INSERT INTO ldb_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ri ivang hã Uyesu awu ra anggɔm ri Ipfu Isarsatangge, agɔr agɛ, <<Umum ikpoi ungo Utɛ, Uteijee uwu afã nggu abĩ, ungo uku uwɔkɔ ifɛrhɛ iyɛrɛ ru abi itsoi nu abi idzursu, nu usɔme ake ra awɛkaci. Akɛrɛ ha awu ubinkpi ungo uku ugũibɛn ikorha ukpɔ. ");
INSERT INTO ldb_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","<<Abina kishoo Utɛmum aka adzaa umum. Unera asi ihwɛngnga amɛn ungwɛ̃ɛ̃, Utɛ ikiyikanga ahwɛng. Unera asi ihwɛngnga amɛn Utei, Ungwɛ̃ɛ̃ ukpekũ nu uwuruwi Ungwɛ̃ hã aka isɔme unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mɔcɛ unga adzipa udiku angwɛ̃ imesanga agɛ, <<Idorh iwu iyi asukɛ aka anyã ubinkpi umbi aka anyã! ");
INSERT INTO ldb_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Umum idɛyiwa umbi ugɛ abika asɔm Arherhu-Num nu ayɛrhe arhɛrhɛ aka abee inyã ubinkpi umbi aka anyã, na asi ikpombɔ inyĩnyã, abee igũ ubinkpi umbi aka agũ na asi igũmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Unuma nukpɔ utsa uwɔɔ uwuku uhwɛng Íkpem Umusa asok adɛ̃ɛ̃ na aviru Uyesu, arhusa unga agɛ, <<A umarhem, umum ikorhi iguse ni ikpo urhɛ uwu ugbagbaa?>> ");
INSERT INTO ldb_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Unga adzipa agɔr unga agɛ, <<Atsɛng agɔr agɛ usee ru ubvur Íkpem Umusa? Ungo uhwɛngo agbena?>> ");
INSERT INTO ldb_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Utsa ha adzipa agɔr agɛ, << <Ungo ibemu Uteijee Unumngo nggu amɛnngo kishoo, nu ipfungo kishoo, nu ikerngo kishoo, nu adzɛnngo kishoo.> Ikɛi, <Ungo ibemu udɔkango ru nyaki itsikamngo.> >> ");
INSERT INTO ldb_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Uyesu adzipa agɔr unga agɛ, <<Ungo urherhe mɔnɔ. Uzĩ ukorhe rimi nu ubɛk.>> ");
INSERT INTO ldb_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bɔr utsa ha anyã ugɛɛ unga ashia ru uvau. Nggee unga arhusu Uyesu agɛ, <<Awu ungamɔ awu undɔkamum?>> ");
INSERT INTO ldb_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Uyesu adzipa agɔr unga agɛ, <<Unera nuwɔ aka asoku Urusharhima acipa awuri izĩ Ujeriko. Unga agbopa avɛu. Umbɔ avur atorhanga, na akwɛr unga akarhãrhã, unga akpurha abɔr akpe. ");
INSERT INTO ldb_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Uner uwuku udzowe idɛm-Num nuwɔ azɛ̃rhã ru utsĩndĩ hã. Unga aka anyã utsa ha aka anu, unga ayapa nu ubang utsĩndĩã azĩã akinga. ");
INSERT INTO ldb_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nggee ikɛi, utsa uwɔɔ ru unang Urhawi, ivangyɛ unga aka aba atsĩ ra anang hã anyã unga aka anu, unga ikɛi ayapa ru ubang utsĩndĩã. ");
INSERT INTO ldb_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bɔr uner Usamariya azɛ̃rhã ru utsĩndĩ hã, aba atsĩ ra anang utsa ha aka anu. Unga aka anyã utsa ha, atorh afɛr unga. ");
INSERT INTO ldb_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Unga azĩ ru unga azĩ akũ atorhanga afire isɔɔ, na atsuke atsei nu amɛ̃ inebi ake awu agɔu ri isɔɔ ha na abope ngge. Ashupa unga atsuku uzhikanga, akũna unga akũ azĩã inɛta ri iya iki iwosha. ");
INSERT INTO ldb_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ukpe uku usar, unga anyangi íshaa imang ivaa adzowe ru uner iya ha, na agɛ, <Uma unɛtuwa utsak uwurɛ. Umum iba ibvui ĩbamum, umum iwuri ifasamum ubinkpi ungo uku ufɛr ri itsinga.> >> ");
INSERT INTO ldb_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Uyesu arhusa unga agɛ, <<Ikitatambɔ, uwukusong awu undɔku utsa ha aka agba ra abok avɛu ha?>> ");
INSERT INTO ldb_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Utsa uwuku uhwɛng Ikpem hã agɛ, <<Uwɔrɔ aka agũ atorh unga.>> Uyesu agɔr unga agɛ, <<Uzĩ ukorhe rimi hã.>> ");
INSERT INTO ldb_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Uyesu nggu angwɛ̃ imesanga awu ru uzɛ̃rhã nukpi, unga azĩ atsĩ ru ungwɛ̃rhũ uteu ukpɔɔ utsɛrh uwɔɔ umɔ agburh Umarta ayɛi unga ri iyanga. ");
INSERT INTO ldb_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Unga Umarta awea ru unapumbɔ itsoka igburh Umaryamu, unga asei akhapa nggu Uteijee anu igosha arherhanga. ");
INSERT INTO ldb_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bɔr Umarta itser ubingha inyangungge amɛnnga. Unga aba ru Uyesu na arhusa agɛ, <<A Uteijee, ungo usi igũo ighong unapumɛn aka aneka umum itɔ̃ itser ikiyikami? Udɛyiwe unga aba ayika umum.>> ");
INSERT INTO ldb_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bɔr Uteijee adzipa agɔr unga agɛ, <<A Umarta, a Umarta, amɛnngo aghong na adake ra abina arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bɔr ubina unying ukpekũ ungo uku ubee. Umaryamu aka atsũa ubin uku uzea, nu umbɔ asi íyesukumbɔ ukpɔ ru unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Unuma nukpɔ Uyesu adɛ̃ɛ̃ ifɛn-Num ra ananga akɔɔ. Unga aka amaa, unying ra angwɛ̃ imesanga agɔr unga agɛ, <<A Uteijee, umesuwa umɛn ifɛn-Num ru nyaka Uyohana aka amesuwe angwɛ̃ imesanga.>> ");
INSERT INTO ldb_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Uyesu agɔr umbɔ agɛ, <<Umbi aba awuri ifɛnmbi Unum, àka agɔr agɛ, << <A Utɛmɛn, atsam itsokngo isarsatake, Iyɛrhango iba. ");
INSERT INTO ldb_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Uma udzaa ubinghamɛn ukpu irherɛ. ");
INSERT INTO ldb_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Uma utsũwe arhimmɛn, ru nyaka umɛn iki isaki itsuwe abika ashɔng umɛn. Niba ukũna umɛn uzĩɔ ru undeya.> >> ");
INSERT INTO ldb_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mɔcɛ unga agɔr angwɛ̃ imesanga agɛ, <<Agɛ unera unying ru umbi awu ru uwɛrhɛ, unga asok azĩ ru unga ri ikɔtsuuka agɔr unga agɛ, <A uwee, uma ukɔpa imarhu uborodi itaar. ");
INSERT INTO ldb_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ubinkutsu uwɛrha umumwi adzeku uzɛ̃rhã aba acipa ri iyamum icɛrɛ. Umum ishimum ru ubin umum iki idzowe unga.> ");
INSERT INTO ldb_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","<<Mɔcɛ uwɛrhɛ ha awu ru ubã na agɔr agɛ, <Niba unyekungo umum arherhe! Umum iki ifɔmukumum ananga, umum nu awɛkacimum kishoo iki iwu ra anang inũ, isi ídɛ̃ɛ̃ iso idzaamum ubin.> ");
INSERT INTO ldb_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Umum idɛyiwa umbi, iwɛrhɛ iba isi itsu unga asok adzowuka ubin, awuri iso adzowuka ubinkpi unga aka abee, ubinkutsu uwɛrha ha asi inekuka ififɛna. ");
INSERT INTO ldb_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","<<Nggee umum idɛyiwa umbi, àka afɛna awuri idzaambɔ. Àka abee umbi awuri ikpombi. Àka akwɛr angwĩ ubã awuri itsi itsuruwambɔ umbi. ");
INSERT INTO ldb_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ubɛn unerwi aka afɛna awuri iyɛisa, unga uwuku ububee awuri ikpoa, nu unga uwuku ukwɛr angwĩ ubã awuri itsurukumbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","<<Utei uwukusong ru umbi, ungwɛ̃nga aba ifɛnu ubɛrh, unga adzowe ibvui? ");
INSERT INTO ldb_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Use ungwɛ̃nga afɛnu udzee, unga adzowe unga inna? ");
INSERT INTO ldb_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Uba umbi abi amɛn aka abewe, ahwɛngmbi idzowe abin aka aze ra angwɛ̃mbi, icicang ishingge, Utɛmbi ra afã awuri idzowuka Ipfu Isarsatangge ra abika afɛna.>> ");
INSERT INTO ldb_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Uyesu atsũwe ru utsa uwɔɔ ipfu iyiki ibewe iki itsu unera asi irherhunga arherhe. Ivangyɛ ipfu iyiki ibewe ha iki idzek, utsa ha arherha arherhe, anera arhɛrhɛ adzeidzeu. ");
INSERT INTO ldb_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bɔr anera abɔɔ agɛ, <<Uba'arhzaburh uyɛrhe ípfu iyiki ibewe unga adzowe ijee iyiki itsũwe ípfu iyiki ibewe ha.>> ");
INSERT INTO ldb_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Abɔɔ avira unga agɛ unga akorhu ubin idzeu ukpu uwu utsar unga aka adzeku Unum. ");
INSERT INTO ldb_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Uyesu ahwɛnga ifɛrhkɔmbɔ, unga agɔr umbɔ agɛ, <<Ubɛn iyɛrhe iki igau agbɛra avaa, iyɛrha ha iwuri isita, nu iya iki igau agbɛra avaa, iwuri ikpɛ̃ɛ̃ke adɔkake, ike iwuri igba ra abĩ. ");
INSERT INTO ldb_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Iyɛrhe Ushaitan iba igasha agbɛra avaa, iyɛrhanga iwuri idɛ̃ɛ̃ iguse? Ubinkutsu umum igɔr rimi, umbi agɔr agɛ umum ikũ ijee Uba'arhzaburh itsũwe ípfu iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Umum iba ikũ ijee Uba'arhzaburh itsũwe ípfu iyiki ibewe, abimbi akũ ijee iyikisong atsusuwe? Angwɛ̃ imesambi awuri itsuka umbi uvau ra arherhe akɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bɔr, umum ĩba itsũwe ípfu iyiki ibewe ru ubok Unum, Iyɛrhe Unum iki ibangge ru umbi. ");
INSERT INTO ldb_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","<<Ukerkaker uner aba agbisha abin iwa, adɛ̃ɛ̃ adzɛu iyanga, abin iyanga awuri iwu uku kpengkpeng. ");
INSERT INTO ldb_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bɔr ivangyɛ uwuruwi aka akera unga aba afũ unga nggu ifuw, awuri ikũ ikernga avur abin iwa ha utsa ha aka awe ru imangmang ra ake, na agashuwe abin iya ha. ");
INSERT INTO ldb_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","<<Uwuruwi aka asi iwea nggu umum, akpɛ̃ɛ̃ umum. Uwuruwi aka asi ikɔnga nggu umum, asusituwe. ");
INSERT INTO ldb_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","<<Ivangyɛ ipfu iyiki ibewe iba idzek ru unera, iki isaki iyarhe ri inang iyiki ikoi ibee ikpo iwiwosha ni isi ikpongge. Ngge igɔr igɛ, <Umum ibvui izĩ ri iyakɛ umum iki idzek.> ");
INSERT INTO ldb_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ngge ibvui iba itsĩ, ngge inyã umbɔ aka ayar na agbishumbɔ iya ha. ");
INSERT INTO ldb_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Mɔcɛ ngge ibvui izĩ ikarhe ípfu iyiki ibewe iyɔɔ utɔɔva iyiriyɛ iki ibewe inangge ngge, ngge kishoo iba isei umɔ. Isisei utsa ha iyi imaataka iwuri ibewe inangge iyi inggbaashia.>> ");
INSERT INTO ldb_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Uyesu aka arherhe rimi, utsɛrh uwɔɔ ri ikikɔnga atsarhi irhaknga agɛ, <<Idorh iwe nggu uyi uwuku umar ungo, na akpɔm ungo!>> ");
INSERT INTO ldb_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Uyesu agɛ, <<Ĩĩ, bɔr idorh iwu iyi abirabɛ aka agũ Arherhu-Num na adɔsa.>> ");
INSERT INTO ldb_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ikikɔnga iki itoma, Uyesu agɛ, <<Undan ukpuku ubewe nukpi. Abee utsar idzeu, bɔr asi ídzowukumbɔ umbɔ utsar ukuse, awuri idzowe utsar ukpu Uyunana ukpekũ. ");
INSERT INTO ldb_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ru nyaka Uyunana aka awu utsar ra aner Unineba, rimi hã Ungwɛ̃-Ner aka iwe ru undan ukpirɛ. ");
INSERT INTO ldb_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ru unum ukpuku uvarha arherhe, Usarauniya uwu unɔr awuri iso adɛ̃ɛ̃ nggu abi undan ukpirɛ na atsuke uvau ru umbɔ. Ubinkutsu unga adzeka anang akika ader aba igũ itsoi Usorhomon. Nggayɛ uwuruwi aka anangnga Usorhomon awu nggimi. ");
INSERT INTO ldb_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Aner Unineba awuri iso adɛ̃ɛ̃mbɔ ru unum ukpuku uvarha arherhe nggu udan ukpirɛ na awuri itsu uvau ru ukpɔ, ubinkutsu, umbɔ adzipumbɔ ri udũwã Uyunana. Icɛrɛ uwuku unang Uyunana uwi nggimi! ");
INSERT INTO ldb_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","<<Unera asi ítsuka irhirhang awɔkuka, use anyangi ikikĩĩ atsĩmka irhirhang hã. Ĩ'ĩ awuri idene ngge ra anang idɛ̃ɛ̃ke, ngge itsú anera itsĩwã na anyã irhirhang hã. ");
INSERT INTO ldb_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Asungo ake awu irhirhang iyorngo. Asungo aba akerke, iyorngo kishoo iwe ri irhirhang. Bɔr asungo aba asi ikerke, iyorngo kishoo ikɛi iwu uzĩ. ");
INSERT INTO ldb_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ungwɛ̃dzɛn utsur irhirhang hã ru ungo iwe uzĩ. ");
INSERT INTO ldb_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nggee iyorngo kishoo iba irhangngge, ugau ukpɔɔ ushikpɔ ru uzĩ, ngge irhange ananga kishoo, ru nyaku urha utɔngvi uku usaku urhang ru ungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ivang Uyesu aka arherhe amaa, uner Ufarisi uwɔɔ ayisa unga igha ubingha ri iyanga. Nggee unga azĩ asei ra anang ubingha. ");
INSERT INTO ldb_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bɔr utsa Ufarisi ha aka anyã ugɛ Uyesu asi inggbaashia asorha aboknga na atirhi igha ubingha, unga adzeidzeu. ");
INSERT INTO ldb_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Mɔcɛ Uteijee agɔr unga agɛ, <<Umbi abi Ufarisi aka isaka asorh andzing akpɛwa nu itɛ̃rhĩ, bɔr unɔrkang umbi uwu abi unyɛ̃ɛ̃ nggu iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Umbi aguge aner! Uwuku umuna awiya, ugɛse unga amunu unɔrkang hã ikɛi? ");
INSERT INTO ldb_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Bɔr àka adzowe ubinkpi uku uwe ru unɔrkang itɛ̃rhĩ hã ra atsũwã, na abina kishoo awu atɛtɛnake ru umbi. ");
INSERT INTO ldb_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","<<Atorhmbi abi Ufarisi, ubinkutsu umbi aka isaka adzowe Unum unying ra abina usɔka iyi ibɔ̃ɔ̃ iyi ayerhe na ayerhu udzau kishoo ikɛi. Bɔr umbi akpɛ̃mbi izharhe arherhe idzidzɛrhe nu ibemu Unum. Imɛ̃ɛ̃ngge umbi akorhe akɛrɛ ha, na aneke ikwɛɛte akɔɔ. ");
INSERT INTO ldb_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","<<Atorhmbi abi Ufarisi! Ubinkutsu umbi abema anang isei aki imor ra abã ifɛn-Num na aghwe umbi ri inang izɛɛ. ");
INSERT INTO ldb_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","<<Atorhmbi, ubinkutsu umbi awu ru nyaka adzakɛ umbɔ aka asi idzinmbɔ, akirakɛ anera iki izɛ̃rhã afafã ri ida ihwihwɛng.>> ");
INSERT INTO ldb_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Unying ra abika ahwɛng Íkpem Umusa agɔr unga agɛ, <<A umarhem, ungo uba ugɔr rimi ungo urhena umɛn nukpɔ!>> ");
INSERT INTO ldb_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Uyesu agɛ, <<Atorhmbi, umbi abika amesuwe Íkpem Umusa! Ubinkutsu umbi atsuke imor Ikpem ra anera umbɔ iki ikɔka atsã, bɔr umbi nibikambi asi ibangumbi abina nggu itokmbi unying, aka iyike umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","<<Atorhmbi, ubinkutsu umbi adzine adzak akika aze ra abika asɔm Arherhu-Num abirabɛ ateimbi aka afɛr. ");
INSERT INTO ldb_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Rimi hã umbi adekuwe ugɛ umbi abemumbi ubinkpi ateimbi aka akorhe. Umbɔ afɛr abika asɔm Arherhu-Num nu umbi adzin adzaka. ");
INSERT INTO ldb_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ri itsi akɛrɛ ha Unum ri itsoinga agɔr agɛ, <Umum iwuri idene umbɔ abika asɔm Arherhu-Num nu abi itsermum. Awuri ifɛre abɔɔ na adzowe abɔɔ uver.> ");
INSERT INTO ldb_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nggee undan ukpirɛ uwuri iyɛi ufai adzirh abika asɔm Arherhu-Num kishoo umbɔ aka afɛyi ishaisha udzur ri imimunu upfunga, ");
INSERT INTO ldb_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","utirhi ra adzirh Uhabirha uzĩɔ ra adzirh Uzakariya, uwuruwi umbɔ aka afɛr ra avarhu ubeu anang aka adzowe idɛm-Num ri Iya-Num. Ĩĩ, umum idɛyiwa umbi, udan ukpirɛ uwuri iyɛi ufai abin akɛrɛ kishoo! ");
INSERT INTO ldb_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","<<Atorhmbi abika amesuwe Íkpem Umusa, ubinkutsu umbi avur atsak umukurhi idzursu. Umbi nibikambi asi itsĩmbi, na asi ineke abika abee itsitsĩ atsĩmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ivangyɛ Uyesu aka aneke anang hã, abika amesuwe Ikpem na abi Ufarisi atirhumbɔ ikpɛ̃na unga akarhãrhã, atsĩmbɔ ibeea unga ifuw nggu irhusa arherhe ra abina arhɛrhɛ, ");
INSERT INTO ldb_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Adzɛu abee idzur unga ru ubinkpi unga aka irherhe. ");
INSERT INTO ldb_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ri ivangyɛ arhɛrha anera aka akɔng, afĩĩ ajang adɔka, Uyesu agbaashia arherhe arherhe nggu angwɛ̃ imesanga agɛ, <<Àka angwɛ̃dzɛn nggu uga abi Ufarisi, iki iwu ukpukpeta. ");
INSERT INTO ldb_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ubin usi ítsirkpɔ umbɔ aka asi ínyãmbɔ, use uwɔkpɔ umbɔ aka asi íhwɛngmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ubinkpi umbi aka arherhe ru uzĩ, awuri igũ ake ru unum ukpuku urhang, nu ubinkpi umbi aka awoyi na arherhe ru ubã, awuri idũwã ake nu atsi uvi aya. ");
INSERT INTO ldb_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","<<Umbi awɛrhamum, umum idɛyiwa umbi, niba agũmbi iwei abika afɛr iyor na asi ídɛ̃ɛ̃ akorhumbɔ ubin. ");
INSERT INTO ldb_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bɔr umum idɛyiwa uwuruwi umbi aka igũ iwei unga. Àka agũ iwei unga, uwuku ifɛr iyor, na awea ri ijee iyiki itsu ungo ri idzũũ urha. Ĩĩ, umum idɛyiwa umbi aka agũ iwei unga! ");
INSERT INTO ldb_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Umbɔ aki isaka agoshe anunu atɔ̃ɔ̃ ukobo avaa, bɔr Unum asi iyiruka unying ra ake. ");
INSERT INTO ldb_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Idzidzɛrhe, igwar itsimbi aka avarha ngge kishoo. Niba agũmbi iwei, umbi awu ru ugarh anangmbi anunu arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","<<Umum idɛyiwa umbi, ubɛn uwuku urherhe ra asu anera ugɛ unga awu uwu umum, Ungwɛ̃-Ner ikɛi awuri irherhunga ugɛ uner ha awu uwu unga ra asu ípfu itser-Num. ");
INSERT INTO ldb_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bɔr uwuruwi aka atsɛyinga ihwɛng umum ra asu anera, Ungwɛ̃-Ner ikɛi awuri itsɛyinga ihwɛng unga ra asu ípfu itser-Num. ");
INSERT INTO ldb_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Nu ubɛn uwuruwi aka arherhe irhɛm iyiki ibewe ri itsi Ungwɛ̃-Ner, awuri itsũwũkumbɔ unga, bɔr uwuruwi aka arhenu Ipfu Isarsatangge, asi ítsũwũkumbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","<<Umbɔ aba akũna umbi ri iker azĩmbɔ ra abã ifɛn-Num, nu ayɛrhe, nu abi ijee, niba agũmbi ighong ikaa atsimbi, use ubinkpi umbi aka irherhe. ");
INSERT INTO ldb_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ubinkutsu Ipfu Isarsatangge iwuri imesuwangge ubinkpi umbi aka irherhe ri ivang hã.>> ");
INSERT INTO ldb_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Uwɔɔ ri ikikɔnga agɔr Uyesu agɛ, <<A umarhem, ugɔr ungwɛ̃mɛn unga agashuwa ukammum, ra abinkɛ utɛmɛn aka akpe na abɔra umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Uyesu agɔr unga agɛ, <<A utsa uner, ungamɔ atsu umum iwu uwuku utsu uvau, use uwuku ugashuwa ukammbi?>> ");
INSERT INTO ldb_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mɔcɛ unga agɔr umbɔ agɛ, <<Àka arhi atai, àka adɛ̃ɛ̃ ukuka nggu kishoo ikpona abin upfung, ubinkutsu urhɛ unera usi íbɛkmgbɔ ra abin upfung.>> ");
INSERT INTO ldb_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Arherhuwe umbɔ unyaka arherhe agɛ, <<Uner uwɔɔ nuwɔ awu uner ubin, abinkɛ unga aka akau ri icangnga, awu azeze akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Unga akaifɛrhkɔ ra amɛnnga agɛ, <Umum ikorhi iguse? Ananga abɔrkeci umum iki itsu abin icangmum.> ");
INSERT INTO ldb_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","<<Mɔcɛ unga agɔr itsikamnga agɛ, <Ĩhĩĩ! Ubinkpi umum iki ikorhe ukpi. Umum ibibupuwe angbanmum akɛrɛ ni idzin akika agɔnga, ni itsuke abin icangmum kishoo nu abin akɔɔ umɔ. ");
INSERT INTO ldb_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Umum iwuri igɔr itsikammum ugɛ, <<Ungo uweɔ ra abin arhɛrhɛ akirakɛ ungo iki igha imɛka irhɛrhɛ. Uwosha, nu ugha nu uhwa nu ugũibɛnngo.>> > ");
INSERT INTO ldb_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","<<Bɔr Unum agɔr unga agɛ, <A ugugge! Ru untsuua ukpirɛ ungo iki ikpe. Umum inyãni ungaa awuri igha abin hã kishoo ungo uku ukɔngnge itsingo.> ");
INSERT INTO ldb_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","<<Ngge iwe rimi nggu kishoo uwuku ukɔngnge itsikamnga abin upfung, na ashia ru ubin ra asu Unum.>> ");
INSERT INTO ldb_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Mɔcɛ Uyesu agɔr angwɛ̃ imesanga agɛ, <<Nggee umum idɛyiwa umbi, niba agũmbi ighong nggu ibibɛkmbi, ubinkpi umbi aka igha, use ubinkpi umbi aka itsim ra ayormbi. ");
INSERT INTO ldb_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Urhɛ unangmgbɔ abingha, nu iyor ikɛi inangngge atorho. ");
INSERT INTO ldb_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Àka arhi anyã anunu, asi idoike, asi igbɛrke, ashike ra angban akika atsu ubin igha, bɔr kishoo rimi hã Unum adzowuka umbɔ ubingha. Umbi anangmbi anunu akarhãrhã! ");
INSERT INTO ldb_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ungamɔ ru umbi igũ ighongnga idɛ̃ɛ̃ itomungge ivanga unying ri inumyɛ unga aka ibɛk? ");
INSERT INTO ldb_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Umbi aba asi idɛ̃ɛ̃ akorhumbi ungwɛ̃rhũ ubin rimi, ude awu use utsu umbi anu igũ ighong ra abina akɔɔ? ");
INSERT INTO ldb_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","<<Àka arhi anyã ífur iki iseng. Isi ihwɛpungge itser, isi isɔrngge atorho. Bɔr umum isɔma umbi uyɛrhe Usorhomon ri igɔngnga kishoo anasi igbɛra idzam ru nyaku unying ru ngge. ");
INSERT INTO ldb_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Unum aba agbɛruka idzam ru ubĩĩ usi, uku uwe irherɛ, udã umbɔ akpĩĩwe ru urha, asi ígbɛranga umbi idzam ananga ukpɔ, umbi abi imangmang iyiki ici! ");
INSERT INTO ldb_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Àka neke ikaifɛrhkɔ ubinkpi umbi aka igha, use ubinkpi umbi aka ihwa, niba agũmbi ighong abin hã. ");
INSERT INTO ldb_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ubinkutsu, abi uzĩ ru upfung atĩna abee ikpũ abin akɛrɛ ha kishoo. Utɛmbi ahwɛnga umbi abeembi ake. ");
INSERT INTO ldb_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Bɔr àka abee Iyɛrhanga, nu abin akɛrɛ ha awuri idzaambɔ ake ikɛi. ");
INSERT INTO ldb_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","<<Ukpuimum uku uci, niba agũmbi iwei, ubinkutsu Utɛmbi aka abemunga idzaa Iyɛrha ha. ");
INSERT INTO ldb_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Àka agoshe abinmbi na adzowe uhwɛka ra atsũwã. Àka agbishu ijari imangyɛ iki isi ívarngge, na angwɛ̃ abinmbi ra afã, anangkɛ abin hã asi ímaake, anangkɛ uvɛu asi íkhapunga umɔ nu adzurh asi ítsĩ aghake ake. ");
INSERT INTO ldb_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ubinkutsu anangkɛ abinmbi aka awe, amɛnmbi ikɛi awe umɔ. ");
INSERT INTO ldb_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","<<Àka atsim abin itsermbi na akpɔm irhirhang igar, ");
INSERT INTO ldb_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ru nyaka anerabɛ aka asei adzɛu uteiyambɔ aka idzeki irhowu ipfuna aba. Unga aka iba akwɛr angwĩ ubã, kanying umbɔ atsuruwe angwĩ ubã ru unga. ");
INSERT INTO ldb_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Awu ubin anggɔm ra agãrhã hã uteiyambɔ aka iba akpombɔ asei uku urhi. Umum indɛyiwa umbi idzidzɛrhe, awuri itsim atorho igãrhã, na agɔr umbɔ ugɛ àka asei isei, na agha ubingha, awuri iso nibikanga agashuwe umbɔ ubingha. ");
INSERT INTO ldb_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Agãrhã hã awuri igũmbɔ ibɛn unga aka aba, ri ikɔtsuuka, use ri igɔ̃kpeka, unga akpombɔ asei ukurhi adzɛu. ");
INSERT INTO ldb_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Àka ahwɛng ugɛ uteiya aba ahwɛnga ivangyɛ uvɛu aka iba ru unga, unga asi íneke unga ayar iyanga atsĩã. ");
INSERT INTO ldb_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Umbi igambi awu ufang umbi adzɛu, ubinkutsu, Ungwɛ̃-Ner awuri iba ri ivangyɛ umbi aka asi ikaimbi ifɛrhkɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ubitru arhusa agɛ, <<A Uteijee, ungo urherhe unyaka arherhe ha ru umɛn, use ru ubɛn uner?>> ");
INSERT INTO ldb_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Uteijee agɔr unga agɛ, <<Ugãrhũ uwukusong arhika na awe ru itsoi? Awu unga hã, uteiyanga aka itsu unga irhi agãrhã iyanga, unga adzowe ubinghambɔ ri ivangngge? ");
INSERT INTO ldb_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Anggɔm awe aki ugãrhã hã uteiyanga aka iba anyã unga adɛ̃ɛ̃ itsernga rimi hã. ");
INSERT INTO ldb_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Umum indɛyiwa umbi idzidzɛrhe, awuri itsuke ugãrhã hã arhise abinnga kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bɔr agɛ ugãrhã hã agɔr ra amɛnnga agɛ, <Uteiyamum asi íbanga ifetem,> na atirhunga ikwɛr agãrhã abɔɔ, akatsɛrh nu akatsak, na atsĩã igha na ahwa, utsɛku unga aka afĩrhã. ");
INSERT INTO ldb_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Uteiya ugãrhã hã aba ru unumkpi unga aka asi ihwɛnga, ikɛi ri ivangyɛ unga aka asi ihwɛngnga. Uteiya awuri ikwɛr unga iki ibewe na atsuke unga nggu abi uzĩ. ");
INSERT INTO ldb_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","<<Ugãrhã uwuruwi aka ahwɛnga ubinkpi Uteiyanga aka abee unga akorhe, na asi ikorhunga, awuri ikwɛr unga ugwɛɛ akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bɔr uwuruwi aka asi ihwɛngnga ubinkpi Uteiyanga aka abee unga ikorhe, na akorhe ubinkpi uku umɛ̃ɛ̃kpɔ ugwɛɛ, awuri ikwɛr unga ukunjiir. Ubɛn uwuruwi umbɔ aka adzowe unga abina arhɛrhɛ, awuri ibee abin arhɛrhɛ ru unga. Uwuruwi ikɛi umbɔ aka aneke unga abin akagɔng arhɛrhɛ, awuri ibee abin akagɔng arhɛrhɛ ru unga. ");
INSERT INTO ldb_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","<<Umum iba itsu urha ru upfung, umum ibee urha ha utirhi ikpĩĩ icɛrɛ! ");
INSERT INTO ldb_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bɔr iwemum ru ubɔtisima umbɔ aka ikorhuwa umum, nu uver ru umum akarhãrhã utsɛku umbɔ aka ikorhuwa umgbɔ! ");
INSERT INTO ldb_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Umbi akaifɛrhkɔ ugɛ umum ikũ ididɔɔr inba ru upfung? Ĩ'ĩ, umum idɛyiwa umbi, umum ikũ igigau inba. ");
INSERT INTO ldb_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Udzur icɛrɛ, ri iyaa unying, inera itɔ̃ɔ̃ awuri igasha awu agbɛra ivaa, itaar angwĩmbɔ asi íweke unying nggu ivaa, ivaa ikɛi angwĩmbɔ asi íweke unying nggu itaar. ");
INSERT INTO ldb_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Awuri igigau, utei awuri ikpɛ̃ɛ̃ ungwɛ̃ɛ̃ nu ungwɛ̃ɛ̃ awuri ikpɛ̃ɛ̃ utɛnga. Uyi awuri ikpɛ̃ɛ̃ unapa, unapa awuri ikpɛ̃ɛ̃ uyisa. Ukoko awuri ikpɛ̃ɛ̃ utsɛnngwɛ̃nga, utsɛnngwɛ̃ awuri ikpɛ̃ɛ̃ ukokanga.>> ");
INSERT INTO ldb_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Unga agɔr ikikɔnga agɛ, <<Umbi aba anyã ufin inai udiku urhɛɛ, kanying umbi agɔr agɛ, <Inai iwuri idoingge,> ngge idoingge. ");
INSERT INTO ldb_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Umbi aba agũ ugba udze unɔr ufɛu, umbi agɛ, <Imani anii iwuri iwengge,> ngge iwengge. ");
INSERT INTO ldb_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Umbi abi ukpukpeta! Umbi adɛ̃ɛ̃ ahwɛngmbi idzipa abin abĩ nggu afã, bɔr ihwɛng atsar ivang iyɛrɛ umbi afɔr adambi. ");
INSERT INTO ldb_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","<<Awu use utsu umbi asi ivarhumbi ubin uku urhika nibikambi? ");
INSERT INTO ldb_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Umbi aba azɛ̃rhã azĩ ivarha arherhe ri iya uyɛrhe, umina asungo umbi avarha amaa nggu unga nu utsĩndĩ. Use unga ikũna ungo akũ azĩã ra abika atsu uvau. Uner uwuku utsu uvau ikɛi atsuke ungo ru ubok abow ikow. Abow ikow ikɛi atsuke ungo ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Umum idɛyiwa ungo, ungo usi ídzekɔ ra anang hã, utsɛku ungo iki ifai kishoo, ukobo usi íbɔrkpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Abɔɔ awu umɔ ri ivang hã, adɛyiwe Uyesu ubinkpi Ubirhatu aka atsu anernga afɛr aner Ugarhirhi atoma adzirh umbɔ ri ivangyɛ umbɔ aka adzowe idɛm-Num. ");
INSERT INTO ldb_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Uyesu agɔr umbɔ agɛ, <<Umbɔ aka afɛr abi Ugarhirhi ha rimi hã, umbi agɔr agɛ umbɔ awu ra arhim anangmbɔ anera kishoo ru Ugarhirhi? ");
INSERT INTO ldb_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ishingge rimi! Umum idɛyiwa umbi, umbi aba asi idzipumbi igambi, umbi kishoo awuri ikpe ru nyaka umbɔ ha. ");
INSERT INTO ldb_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Use anera usɔka nu utɔrɔk ha ubandzin uku ubupa ru Usirhuwam ufɛre umbɔ, umbi agɔr agɛ umbɔ awu ra arhim anangmbɔ anera kishoo ru Urusharhima? ");
INSERT INTO ldb_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ishingge rimi! Umum idɛyiwa umbi, umbi aba asi idzipumbi igambi, umbi awuri ikpe ru nyaka umbɔ ha.>> ");
INSERT INTO ldb_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mɔcɛ Uyesu arherhuwe umbɔ unyaka arherhe agɛ, <<Unera nuwɔ, awu ru ucucii uvorhvo ri icangnga. Unga asok azĩã ibee ikpũrhũ uvorhvo ha, bɔr unga asi ikpoa ikpũrhã unying. ");
INSERT INTO ldb_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Unga agɔr uwuku urhise icang hã agɛ, <Amɛɛ untaar rakɛ umum iki iba inu ibee ikpurhu ucucii uvorhvo uwurɛ, bɔr umum isi ikpomum ubin ru umgbɔ. Ugbɛre umgbɔ! Awu use umgbɔ uvina abĩã?> ");
INSERT INTO ldb_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","<<Bɔr uwuku urhise icang hã agɛ, <A uteiya, uneke umgbɔ, umum itsuke abĩ ru umgbɔ, ni itsuke abi ru umgbɔ ikɛi ra amɛka akɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Umgbɔ uba ughwɛrmgbɔ ikpũrhã ra akang, izea niyɔ! Umgbɔ uba usi ighwɛrmgbɔ, umbɔ agbɛre umgbɔ.> >> ");
INSERT INTO ldb_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ru unum ukpuku uwosha ukpɔɔ Uyesu adɛ̃ɛ̃ amesuwe ra abã ifɛn-Num, ");
INSERT INTO ldb_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","utsɛrh uwɔɔ awu umɔ ipfu iyiki ibewe iki itsuke unga irhãrhã ipfuruwe undzinga imɛka usɔka ni imɛka utɔrɔk, afɔr idɛ̃ɛ̃ ukudzik adaka. ");
INSERT INTO ldb_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ivangyɛ Uyesu aka anyã unga, unga ayisa unga aba ru unga na agɔr unga agɛ, <<A utsɛrh ha, aka ashɔɔtambɔ ungo ri irhãrhãngo.>> ");
INSERT INTO ldb_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Mɔcɛ unga aberu uboknga atsorhe nu utsɛrh ha, kanying utsɛrh ha abera adɛ̃ɛ̃ uku udzik, na akpoi Unum. ");
INSERT INTO ldb_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bɔr unggbaashi ubã ifɛn-Num hã agũ avɔm Uyesu aka akerhuwe ru unum ukpuku uwosha. Unga agɔr anera aka awu umɔ agɛ, <<Inuma iwu utɔ̃ĩ iyi itser, aka aba ri inum hã umbɔ akerhuwa umbi, asi iwea unum ukpuku uwosha.>> ");
INSERT INTO ldb_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Bɔr Uteijee agɔr unga agɛ, <<Umbi abi ukpukpeta! Ubɛn unera ru umbi aka asi isaka agarhunga inaknga use uzhikanga ru ugbor, akũ azĩa ihwa amɛ̃ ru unum ukpuku uwosha? ");
INSERT INTO ldb_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Utsɛrh uwurɛ awu unang Uibrahim, uwuruwi Ushaitan aka abow imɛka usɔka ni imɛka utɔrɔk riyɛ. Asi izea umbɔ agarhuwe unga ru unum ukpuku uwosha?>> ");
INSERT INTO ldb_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Unga aka arherhe rimi, kishoo anggamtsaknga agũ atsa. Bɔr anera agɔm anggɔm abin idzeukɛ unga iki ikorhe kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Uyesu arhusa agɛ, <<Iyɛrhe Unum iwu igusengge? Umum ikpanga ngge nggu use? ");
INSERT INTO ldb_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Iwe ru nyaki ishaa umastad, iyiriyɛ utsa uwɔɔ aka anyanga adoi ri icangnga, ngge iseng iba iwu ucucii, anunu akang ashiyake ra aboka.>> ");
INSERT INTO ldb_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ikɛi unga arhusa agɛ, <<Umum ikpangu Iyɛrhe Unum nggu use? ");
INSERT INTO ldb_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Iwe ru nyaku uga, ukutsɛrh aka anyanga akayi agbiu isɔka ivaa aki akɔ̃ abvurh, ake kishoo asok afui.>> ");
INSERT INTO ldb_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Mɔcɛ Uyesu aka adzur utsĩndĩ uwuku izĩ Urusharhima, unga atsĩrhũ iteu iyiki ici nu iyiki igɔng anu imesuwe anera. ");
INSERT INTO ldb_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Uwɔɔ arhusa unga agɛ, <<A Uteijee, inera iwu ukunjiir ukpekũ iki ikpo ififɔrh?>> Unga agɔr umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","<<Àka abima na atsĩ ra angwĩ ubã akika apare, ubinkutsu, anera arhɛrhɛ awuri ikãrhũmbɔ itsitsĩ bɔr asi ídɛ̃ɛ̃ atsĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Uteiya aba asok afɔma angwĩ iya, umbi adɛ̃ɛ̃ ra awiya na akwɛr angwĩ iya, na ashɔ̃rhã agɛ, <A uteiya, kabɔɔ umaa utsuruwa ananga ru umɛn!> <<Bɔr unga awuri igɔr agɛ, <Umum isi ihwɛng umbi use anangkɛ umbi aka adzek umɔ!> ");
INSERT INTO ldb_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","<<Mɔcɛ umbi awuri igɔr agɛ, <E! Umɛn iki igha ni ihwa nggu ungo, ikɛi ungo umesuwa umɛn ru atsĩndĩmɛn.> ");
INSERT INTO ldb_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","<<Bɔr unga awuri igɔr agɛ, <Umum isi ihwɛng umbi use anangkɛ umbi aka adzek umɔ! Àka asombi ru umum, abi itser iki ibewe!> ");
INSERT INTO ldb_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","<<Iciu akpe nu itãi anyĩ iwe umɔ, aka inyã Uibrahim, nu Uishaku, nu Uyakubu, nu kishoo abika asɔm Arherhu-Num ri Iyɛrhe Unum, bɔr umbi abɛ umbɔ awuri itare umbi. ");
INSERT INTO ldb_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Anera awuri idzeki igɔ̃kpee nu udiku urhɛɛ nu ufã nu unɔr, asei ri irhowu Iyɛrhe Unum. ");
INSERT INTO ldb_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Idzidzɛrhe, abɔɔ icɛrɛ aka awe amaataka awuri iwe anggbaashia, anggbaashia awuri iwe amaataka.>> ");
INSERT INTO ldb_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ri ivang hã abi Ufarisi aba ru Uyesu, agɔr unga agɛ, <<Usɔkɔ nggimi, uzĩɔ anang akase, ugomna Uhiridu abee ifɛre ungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Unga agɔr umbɔ agɛ, <<Àka azĩ adɛyiwe ijui ngbako iyiki ici ha ugɛ, <Irherɛ umum iwuri itsũwũkũ ípfu iyiki ibewe, ni iwuri ikerhukũ anera, ikɛi udã rimi hã, umum imaa itsermum ikpe. ");
INSERT INTO ldb_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ĩĩ awu ufang, umum iki izɛ̃rhũ uzɛ̃rhãmum irherɛ nggu udã, ni ikpe ikɛi. Idzidzɛrhe isi imɛ̃ngge uner uwuku usɔm Arherhu-Num akpe ra awiya Urusharhima!> ");
INSERT INTO ldb_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","<<Oka Urusharhima, Urusharhima! Ungo ufɛr abika asɔm Arherhu-Num nu utang atarh ra abirabɛ umbɔ aka adene umbɔ aba ru umbi. Idiki isong umum iki ibee ikɔng angwɛ̃mbi ananga unying, ru nyaki inũ iki isaki ikɔng angwɛ̃ngge ra afɛkngge, bɔr umbi akpɛ̃mbi! ");
INSERT INTO ldb_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nggayɛ awuri inekambɔ iyambi arhanga! Umum idɛyiwa umbi, umbi asi íbvui anyãmbi umum, utsɛku unumkpi umbi aka igɔr agɛ, <Idorh iwe nggu uwuruwi aka aba ri itsok Uteijee!> >> ");
INSERT INTO ldb_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Unum Ivangyɛ Uyesu aka atsĩ igha ubingha ri iya unggbaashi utsa Ufarisi uwɔɔ ru ukpuku uwosha ukpɔɔ, anera angwɛ̃dzɛn na atsu asumbɔ ru unga. ");
INSERT INTO ldb_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Uner irhãrhĩ iyiki iseng iyor awu umɔ ra asu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Uyesu arhusa abi Ufarisi ha nu abika amesuwe Íkpem Umusa agɛ, <<Ri Ikpem, imɛ̃ngge umbɔ akerhuwe unera ru unum ukpuku uwosha use isi imɛ̃ngge?>> ");
INSERT INTO ldb_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bɔr umbɔ anukutata. Nggee Uyesu akpɔm utsa ha na akerhuwe unga, na adene unga adzeka. ");
INSERT INTO ldb_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mɔcɛ unga arhusa umbɔ agɛ, <<Uba unera ru umbi awu ru ungwɛ̃ use inak igba ru uvãã amɛ̃ ru unum ukpuku uwosha, umbi asi ítsũwũkumbi kanying?>> ");
INSERT INTO ldb_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Umbɔ ashimbɔ ru urhɛmkpi umbɔ aka irherhe. ");
INSERT INTO ldb_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ivangyɛ unga aka anyã atsen aka atɛng anang isei aka azea asei, unga adɛyiwe umbɔ unyaka arherhe ugɛ, ");
INSERT INTO ldb_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","<<Unera aba ayisunga ungo irhowu ipfuna, niba useisɔ ra anang isei aka azea, use aghwimbɔ uwɔɔ aka ananga ungo. ");
INSERT INTO ldb_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ngge iba iwu rimi, uner irhowa ha aka ayisa umbi aba awuri igɔr ungo agɛ, <Ubɔre anang iseingo ru uner uwɔrɔ.> Ungo uso uzĩɔ̃ ra anang aka acia nggu atsa. ");
INSERT INTO ldb_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Bɔr umbɔ aba ayisumbɔ ungo irhowu ipfuna, usei ra anang aka acia, uneke uner irhowa ha aba nibikanga, ayisa ungo agɛ, <A uwɛrhɛ, uba usei nggɛɛ ra anang aka azea.> Mɔcɛ ungo uwuri iweɔ ri imor ra asu abi irhowa. ");
INSERT INTO ldb_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ubɛn unerwi aka aberi itsinga, awuri irhɛrhuwe ike, uwuruwi aka arhɛrhuwe itsinga, awuri iberuwe ike.>> ");
INSERT INTO ldb_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mɔcɛ Uyesu agɔr uner irhowa ha agɛ, <<Ungo uba uwuri iyisungo anera igha ubingha, use irhowa, niba uyisungo awɛrhango, nu angwɛ̃mbi, nu unangmbi nu abi ubinmbi. Ungo uba ukorhungo rimi, umbɔ aba ayisumbɔ ungo, umbɔ ifasambɔ ungo ubinkpi ungo uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Bɔr ungo uba uwuri ikorhungo irhowa, uyisa atsũwã nu akatarhu, nu abi ishai iyor, nu abi ibvuta, ");
INSERT INTO ldb_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ungo uwuri iweɔ ri idorh. Nu ngge iki iwe ugɛ umbɔ asi ídɛ̃ɛ̃ afaimbɔ, bɔr Unum awuri ifasa ungo ru unum ukpuku usok ra akpe uwu abika arhurhika.>> ");
INSERT INTO ldb_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ivangyɛ unying ru umbɔ abika asei igha ubingha aka agũ rimi, unga agɔr Uyesu agɛ, <<Idorh iwe nggu unerwi aka isei ighigha ri Iyɛrhe Unum.>> ");
INSERT INTO ldb_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Uyesu agɔr unga agɛ, <<Unera nuwɔ aka agbisha abin irhowa iyiki igɔngnga amaa, na aghwi abika azĩ irhowa arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ivangyɛ ivang irhowa ha iki iba imɛ̃, unga adene ugãrhãnga azĩ adɛyiwe abi ha unga aka aghwi agɛ, <Àka aba, umum iki inzɛkũ abina.> ");
INSERT INTO ldb_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","<<Bɔr umbɔ kishoo atsĩmbɔ isɔm abinkɛ aka ikɛn umbɔ izizĩ irhowa ha ru ughwisha. Uwu inggbaashia agɛ, <Umum igoi icang niyɔ, awu ufang umum izĩ inyã ngge. Kabɔɔ uma aneka umum izĩ.> ");
INSERT INTO ldb_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","<<Uwɔɔ agɛ, <Umum igoi inak iyiki ikau irham usɔka, umum ibee izĩ ivira ngge. Kabɔɔ uma aneka umum izĩ.> ");
INSERT INTO ldb_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","<<Ikɛi uwɔɔ agɛ, <Umum inii ipfunu utsɛrh uwuku ufa, isi ídɛ̃ɛ̃ ĩbamum.> ");
INSERT INTO ldb_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","<<Ugãrhã hã aba adɛyiwe uteiyanga akɛrɛ ha. Mɔcɛ amɛn uteiya iya ha adake, unga adɛyiwe ugãrhãnga hã agɛ, <Udze uzĩ ifetem, ra atsĩndĩ nu ikparavar utepa, ukarha atsũwã, nu akatarhu nu abi ibvuta, nu ashai iyor ukũba.> ");
INSERT INTO ldb_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","<<Ugãrhãnga agɛ, <A uteiya, ubinkpi ungo uku ubee iki izĩ ikorhumum, bɔr ananga ana abɔrke ri iya.> ");
INSERT INTO ldb_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","<<Mɔcɛ uteiya irhowa ha agɔr ugãrhãnga agɛ, <Ubvui udze utsĩrhã atsĩndĩ iteu nu arhum, utsu anera umbɔ aba atɔk iyamum. ");
INSERT INTO ldb_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Umum idɛyiwa umbi, uko unera unying ra abɔrɔ abi inggbaashi ha umbɔ aka aghwi asi íbangunga ubin irhowamum.> >> ");
INSERT INTO ldb_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Anera arhɛrhɛ aka azɛ̃rhã nggu Uyesu, unga adzipa agɔr umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","<<Ubɛn unerwi aka iba ru umum, na asi ikpɛ̃ɛ̃ utɛnga nu uyanga, utsɛ̃nga nu awɛkacinga, angwɛ̃mbɔ nu anapumbɔ, use urhɛnga, unga asi ídɛ̃ɛ̃ awea ungwɛ̃ imesamum. ");
INSERT INTO ldb_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ubɛn unerwi aka asi ishupu igãrhãmau ucuciia adɔsunga umum, asi ídɛ̃ɛ̃ awea ungwɛ̃ imesamum. ");
INSERT INTO ldb_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","<<Unera unying ru umbi aba abee idzin utsurha udedetamgbɔ, unga asi ígbaashia asei na avarhu ubinkpi unga aka ifɛr, na anyã use unga awea ru uhwɛk ukpurukpi unga aka imaa idzina? ");
INSERT INTO ldb_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ubinkutsu utsur unga atsu atarh idzina na afɔr imimaa adaka, ubɛn unera aka inyã, awuri inyĩrhã unga, ");
INSERT INTO ldb_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","agɛ, <Umbi anyã uner uwirɛ aka atirhi idzin, na afɔr imimaa adaka.> ");
INSERT INTO ldb_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","<<Use awu uyɛrhe uwukusong awuri izĩ iwa nggu uyɛrhu uwɔɔ, na asi isei avarhunga use anernga anaka agɔnga usɔka awuri idɛ̃ɛ̃ amɛ̃ɛ̃mbɔ nggu abɔrɔ aka awu anaka agɔnga isɔka ivaa? ");
INSERT INTO ldb_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Unga aba asi ídɛ̃ɛ̃ amɛ̃ɛ̃, unga adene itser umbɔ azĩ akpo uyɛrhe uwɔrɔ unga ana awu ukukaa, umbɔ ashɔ̃rhã abee ididɔɔr? ");
INSERT INTO ldb_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iwe rimi hã, ubɛn unera ru umbi aka asi idzowuka abinnga kishoo, uner ha asi ídɛ̃ɛ̃ awea ungwɛ̃ imesamum. ");
INSERT INTO ldb_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","<<Angwã aze, bɔr ake aba ashike ri itonga angwã, iwuri ikorhu uguse ni iwe angwã ikɛi? ");
INSERT INTO ldb_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ashike ri itser ri ikom icang, use ra atɔɔ irham. Umbɔ awuri itare ake. <<Uner ato akika agũ, unga agũ.>> ");
INSERT INTO ldb_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Abika ayɛsu ikirbi abĩ nu abirabɛ umbɔ aka anyanga umbɔ awu abi arhim arhɛrhɛ, aba akɔng adziir anu igosha unga, ");
INSERT INTO ldb_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","abi Ufarisi nu abika amesuwe Ikpem abvun agɛ, <<Utsak uwirɛ ayɛisa abi arhim na agha nggu umbɔ!>> ");
INSERT INTO ldb_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mɔcɛ Uyesu arherhuwe umbɔ unyaka arherhe agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","<<Unera unying ru umbi awe ru ídɔi unaka. Unying iba igwirngge, unga asi ínekuka ídɔi isɔka utɔɔrha nu utɔɔrha ri idɛɛ na azĩã ibee iyiki igwir ha utsɛku unga aka ikpo ngge? ");
INSERT INTO ldb_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Unga aba akpoa ngge, unga agɔm na atsã ngge ra acɛisa, ");
INSERT INTO ldb_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","unga aka izĩ ri iya. Unga ayisa awɛrhanga nu andɔkanga ananga unying na agɔr umbɔ agɛ, <Àka agɔm anggɔm nggu umum. Iki ikpomum idɔi uma hã iyiki igwir ha.> ");
INSERT INTO ldb_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Umum idɛyiwa umbi, iwuri iwe rimi hã, umbɔ aka igɔmanggɔm ra afã ri itsi uner arhim unying uwuku udzipa anangmbɔ abika arhika isɔka utɔɔrha ni inera utɔɔrha iki isi ibeengge idzidzipa. ");
INSERT INTO ldb_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","<<Use, utsɛrh uwukusong awe ru íshaa imang usɔka, ishaanga unying igwirngge, unga asi ígaar urhirhang, na ayar iya kishoo na angwɛ̃dzɛn abee utsɛku unga aka ikpo? ");
INSERT INTO ldb_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Unga aba akpoa, unga iyisa awɛrhanga nu undɔkanga na agɔr umbɔ agɛ, <Àka agɔm anggɔm nggu umum iki ikpomum ishaa uhwɛk ha iki igwir.> ");
INSERT INTO ldb_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Umum idɛyiwa umbi, iwuri iwe rimi hã, awu ubin anggɔm ra asu ípfu itser-Num ri itsi uner arhim unying uwuku udzipa.>> ");
INSERT INTO ldb_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Uyesu arherhe agɛ, <<Unera nuwɔ awu ra awɛkatsa avaa. ");
INSERT INTO ldb_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Uwuku ucia agɔr utɛnga agɛ, <A utɛ, ugashuwa ukammum.> Mɔcɛ utɛnga agashuka ukammbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","<<Akpurha amaa inuma ukunjiir, uwuku ucia akarha abinnga kishoo, azĩã abĩ akɔɔ nu udĩ ukpuku uder. Mɔcɛ, unga afɛruka abinnga ru ugba. ");
INSERT INTO ldb_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Unga aka amaawe abinnga kishoo, imerh iso imaangge abĩã, unga atsĩã iyaki imerh. ");
INSERT INTO ldb_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Unga asok azĩ awea ugãrhã utsa uwɔɔ ra abĩ hã, utsa ha atsuke unga azĩ idzɛu arhede ra agborke. ");
INSERT INTO ldb_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Unga abee igha ubingha arhede ha, unera asi idzowuka unga ubin. ");
INSERT INTO ldb_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","<<Ivangyɛ unga aka atsĩ ra amɛnnga, unga agɛ, <Agãrhã awu asong ri iya utɛmum, umbɔ iki igha ashur na abɔre? Nu umum iwuri ikpemum ri imerh. ");
INSERT INTO ldb_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Umum iso izĩ ru utɛmum igɔr unga igɛ, a utɛ, umum iki ikorhu ubin arhim ru Unum, ni ishɔiwamum ungo. ");
INSERT INTO ldb_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Umum isi ibvui imɛ̃mum umbɔ ayisa umum ungwɛ̃ngo. Unyanga umum ru nyaku ugãrhãngo.> ");
INSERT INTO ldb_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Mɔcɛ unga asok azĩã ru utɛnga. <<Bɔr unga ana adzeka ukuka nu utɛnga anyã unga, atorh afɛr unga, unga atĩ azĩã akarha unga awuma na ashor atamnga. ");
INSERT INTO ldb_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","<<Ungwɛ̃nga agɔr unga agɛ, <A utɛ, umum ikorhu ubin arhim ru Unum ni iki ishɔiwamum ungo. Umum isi imɛ̃mum umbɔ abvui ayisa umum ungwɛ̃ngo.> ");
INSERT INTO ldb_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","<<Bɔr utesa agɔr agãrhãnga agɛ, <Àka akũ atorho aka aze aba atsĩme unga ifetem. Àka atsuke imangto ri itoknga na abadak ra adaknga. ");
INSERT INTO ldb_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Àka atsĩ adzur ungwɛ̃ inak iyiki isenga, aba angwãna. Umɛn izɛk irhowa igɔmanggɔm. ");
INSERT INTO ldb_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ubinkutsu ungwɛ̃mum uwɛrɛ ha aka akpea na azir ikɛi, aka agwira bɔr icɛrɛ umɛn iki ikpomɛn.> Mɔcɛ umbɔ atsĩmbɔ irhowa. ");
INSERT INTO ldb_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","<<Umbɔ ana awe ru irhowa ha, ungwɛ̃nga uwuku ukũa awu ra arhum. Unga aka adzeka arhum aba ayo ri iya, unga agũ anggang nu azer atɔkuke iya. ");
INSERT INTO ldb_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nggee unga ayisu ugãrhã unying na arhusa unga agɛ, <Awu use uni izãrhã?> ");
INSERT INTO ldb_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Unga agɔr unga agɛ, <Ungwɛ̃mbi aka abanga, utɛngo atsu umbɔ angwã inak iyiki isenga, akorhi irhowa, unga aka aba atsĩ ukuker.> ");
INSERT INTO ldb_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","<<Ungwɛ̃mbɔ uwuku ukũa amɛnnga adake, unga akpɛ̃ɛ̃ itsĩ ri iya, nggee utɛnga adzek ashɔ̃rhã unga. ");
INSERT INTO ldb_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bɔr unga agɔr utɛnga agɛ, <Unyã! Imɛk iyɛrɛ kishoo umum ikapa ungo, inasi ikpɛ̃mum igũna ungo idiki unying. Rimi hã ungo unasi idzaango umum ibũ iyiki ici umum ikorhumum irhowa nggu awɛrhamum. ");
INSERT INTO ldb_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bɔr ungwɛ̃ngo uwuruwi aka azĩ afɛre abinngo nggu akatsɛrh aba ri iya, ungo ungwãnuwe ungwɛ̃ inak iyiki isenga ru unga!> ");
INSERT INTO ldb_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","<<Utɛnga agɛ, <Oka ungwɛ̃mum, ungo uwu nggu umum ubɛn ivang, ubɛn ubinmum, uwu ukpungo. ");
INSERT INTO ldb_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bɔr imɛ̃ngge umɛn ikorhi irhowa ni igɔmanggɔm, ubinkutsu ungwɛ̃mbi uwuruwi aka akpe, aka azira, uwuruwi aka agwir, umbɔ aka akpombɔ unga.> >> ");
INSERT INTO ldb_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Uyesu adɛyiwe angwɛ̃ imesanga agɛ, <<Unera nuwɔ awu uner ubin, umbɔ adɛyiwe unga agɛ, <Uner uwuku udzɛu itserngo anu ikorhe ataba nggu abinngo.> ");
INSERT INTO ldb_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nggee unga ayisu uner itsernga hã arhusa agɛ, <Umum ini igũshu use ri itsingo? Ukũ ubvur itserngo uba uvarhe umum inyãni kishoo, ubinkutsu ungo usi íweɔ uner itsermum.> ");
INSERT INTO ldb_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","<<Uner itser ataba ha akaifɛrhkɔ ra amɛnnga agɛ, <Umum ikorhi iguse icɛrɛ? Uteiyamum uwi awuri iwayiwe umum ri itser. Umum uwi ishimum ri iker iyiki ikau irham, ni iwu ra atsa akika afɛn ifɛn. ");
INSERT INTO ldb_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Umum ihwɛng ubinkpi umum iki ikorhe, umbɔ aba awayikumbɔ umum ri itser nggimi, anera awuri iyaimbɔ umum ra ayambɔ.> ");
INSERT INTO ldb_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","<<Nggee unga ayisa abika agha uvɛrh ru uteiyanga unying anying, unga arhusu inggbaashia agɛ, <Uteiyamum adɔsa ungo itikisong?> ");
INSERT INTO ldb_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","<<Unga agɔr unga agɛ, <Ídzum atsei anaka utɔrɔk.> <<Mɔcɛ uner itser ataba ha agɔr unga agɛ, <Unyangu ubvur uvɛrhngo ifitem, utsɛng anaka ana.> ");
INSERT INTO ldb_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","<<Mɔcɛ unga arhusu uwu uvaa ikɛi agɛ, <Adɔsa ungo itikisong?> <<Unga agɔr agɛ, <Ambãĩ itsem, unaka unying.> Unga adɛyiwe unga agɛ, <Unyangu ubvur uvɛrhngo, utsɛng isɔka utɔrɔk.> ");
INSERT INTO ldb_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","<<Uteiya ha akpoi uner itser uwuku uda irhirhika ha, ubinkutsu akorhi ifɛrhɛ ha nggu isarasu. Anera ru upfung ukpirɛ akorhi ifɛrhɛmbɔ nggu itsoi anangmbɔ abika adɔsu Unum. ");
INSERT INTO ldb_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Umum idɛyiwa umbi, àka akũ abin upfung akũ akpowe itsikammbi awɛrhɛ, abinmbi aba amaake, umbɔ ayɛi umbi ra aya aki ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","<<Uwuruwi aka awe ru imangmang nggu ubin uku uci, awuri iwea ri imangmang ru ubin ukpuku urhɛ. Uwuruwi aka ashia ri imangmang ru ubin ukpuku uci, asi íwea ri imangmang ru ubin ukpuku urhɛ. ");
INSERT INTO ldb_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nggee umbi aba ashimbi ri imangmang ra abin upfung ukpirɛ, ungaa idzaa umbi abin aki idzidzɛrhe? ");
INSERT INTO ldb_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Umbi aba isaka ashimbi ri imangmang ra abin anera, ungaa idzaa umbi abin aki ukammbi? ");
INSERT INTO ldb_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","<<Ugãrhã asi ídɛ̃ɛ̃ atɔ̃wũka itser ra ateiya avaa. Unga awuri ibema unying na akpɛ̃ɛ̃ uwɔrɔ, unga awuri idzowe itsinga ru unying na akpɛ̃ɛ̃ uwɔrɔ. Ungo usi ídɛ̃ɛ̃ udzowukɔ itsingo ru Unum nu uhwɛk.>> ");
INSERT INTO ldb_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Abi Ufarisi abika abemu uhwɛk, aka agũ akɛrɛ ha kishoo, umbɔ acatu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Unga agɔr umbɔ agɛ, <<Umbi azharhe arherhe aka aze ra asu anera, bɔr Unum ahwɛnga amɛnmbi. Ubin uku uze ra asu anera, uwu ubin ishĩ ra asu Unum. ");
INSERT INTO ldb_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","<<Imesi Íkpem Umusa nu abvur abika asɔm Arherhu-Num, umbɔ aka adũwã utsɛki ivang Uyohana. Udzur ri ivang hã, umbɔ aka anu idzowe Isarhe Iyiki Ize iyi Iyɛrhe Unum, nu ubɛn unera abee itsĩ ri ngge ri inggang. ");
INSERT INTO ldb_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Asi ighonga afã nggu abĩ aki imaa, bɔr ishia unying ri Íkpem Umusa isi ífɔ̃rhũngge. ");
INSERT INTO ldb_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","<<Ubɛn unera aka iwayiwe utsɛ̃nga na apfuna utsɛrh uwukuse, unga awu ra arhim itoma-dak, nu unera aka ipfunu utsɛrh uwuku uwuwayi, awu ra arhim itoma-dak. ");
INSERT INTO ldb_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","<<Uner ubin nuwɔ aka isaka atsim atorhi imang azezerake, unga awe ri igũibɛn ubɛn unuma. ");
INSERT INTO ldb_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ra angwĩ iyanga, utsũwã nuwɔ agburh Urhiazaru anu umɔ, awu nggu isɔɔ iki imaa iyornga. ");
INSERT INTO ldb_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Unga abee igha awushu ubingha aki igbei, ra adak utebur uner ubin hã. Ijui iki isaki iba irhɛn isɔɔnga hã. ");
INSERT INTO ldb_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","<<Ivanga iki imɛ̃ uner ifɛn hã akpea. Ípfu itser-Num ishupa unga ikũ izĩngge ri igbɔm Uibrahim. Ikɛi, uner ubin hã akpea, umbɔ adzake unga. ");
INSERT INTO ldb_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ra anang isei abika akpukpe, ra anangkɛ unga aka agũ uver, unga abera asunga anyã Uibrahim ukuka nu Urhiazaru ri igbɔmnga. ");
INSERT INTO ldb_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nggee unga ayisa unga agɛ, <A Utɛtɛ Uibrahim, umaa ugũ atorh umum nu udene Urhiazaru unga ashɔmu itoknga ra amɛ̃ na arhor adɔnga arhɛmmum, ubinkutsu umum iwe ru uver ri idzũũ urha ukpirɛ.> ");
INSERT INTO ldb_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","<<Bɔr Uibrahim agɔr unga agɛ, <A ungwɛ̃mum, uyita ri ivangyɛ ungo uku uwe ru urhɛ. Ungo uyɛisa abin aka aze nu Urhiazaru ayɛisa abin aka abewe, bɔr icɛrɛ umbɔ afituwe unga nggimi ungo uwe ru uver. ");
INSERT INTO ldb_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Asi iwea akɛrɛ ha ukpekũ, bɔr ra ateumɛn nggu umbi, aka atsu ughorkaghor umbumbang uteitasamgbɔ utsur anera asoki nggimi abambɔ ugarmbi, use unera adzek ugarmbi abanga ru umɛn.> ");
INSERT INTO ldb_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","<<Unga agɛ, <A utɛ, umum ishɔ̃rhã ungo, uma udene Urhiazaru unga azĩ ri iya utɛmum, ");
INSERT INTO ldb_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ubinkutsu umum iwe ra angwɛ̃mɛn atɔ̃ɔ̃. Umum ibee unga arherha umbɔ, utsur umbɔ abambɔ ra anang akɛrɛ ha aki uver ha.> ");
INSERT INTO ldb_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","<<Uibrahim agɛ, <Awembɔ ru Umusa nu abika asɔm Arherhu-Num, uneke umbɔ akpeto ra abi ha.> ");
INSERT INTO ldb_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","<<Unga agɛ, <A utɛ Uibrahim, ĩ'ĩ, unera aba adzek ra abika akpe azĩ ru umbɔ, umbɔ awuri idzipumbɔ.> ");
INSERT INTO ldb_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","<<Unga agɔr unga agɛ, <Umbɔ aba asi ikpembɔ ato ru Umusa nggu abika asɔm Arherhu-Num, umbɔ asi ígũmbɔ unerwi aka idzeka akpe.> >> ");
INSERT INTO ldb_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Uyesu agɔr angwɛ̃ imesanga agɛ, <<Ubinkpi uku itsu anera agba ra arhim, awu ufang ukpɔ uba, bɔr atorh uner ha aka itsu ukpɔ uba. ");
INSERT INTO ldb_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nu unerwi aka itsu unying ra awɛkaci abɛrɛ agba ra arhim, ugba umbɔ abope ukɔ igɔ ru urhɔknga na atare unga atsĩ ru ughorkaghor ukau ukugɔng. ");
INSERT INTO ldb_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nggee àka akpɔm atsimbi. <<Undɔkango aba agbaa ra arhim, utsɛrha unga. Unga aba nekuka, utsũwe unga. ");
INSERT INTO ldb_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Unga aba agbaa uvau ru ungo idikunga utɔɔva ru unuma unying, na aba idiku utɔɔva agɛ, <Iki inekukũ,> utsũwe unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Abi itser Uyesu agɔr agɛ, <<Uteijee, utomuwa imangmangmɛn.>> ");
INSERT INTO ldb_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Uteijee agɔr umbɔ agɛ, <<Umbi aba awembi ri imangmang ukunjiir ru nyaki ishaa umastad, umbi adɛ̃ɛ̃ agɔrmbi ucucii ipfum uwurɛ agɛ, <Ubvurhi nu udɔnna ru ukau,> umgbɔ uwuri igũmgbɔ umbi. ");
INSERT INTO ldb_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","<<Awu ungamɔ ru umbi aka iwe ru ugãrhã uwu irham use uwuku udzɛu ídɔinga, aka idzeku usi aba, unga agɔr unga agɛ, <Uba ifitem, uba usei nu ugha ubingha>? ");
INSERT INTO ldb_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Asi ígɔra rimi, bɔr unga awuri igɔr ugãrhãnga hã ugɛ, <Utɔng ukorhu ubingha ukũwã umum igha ni ihwa imaa, nu ungo udɔrhu ugha nu uhwa> ");
INSERT INTO ldb_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Awuri itara uwɛɛ ru ugãrhã hã aka adɔsa arherhanga? ");
INSERT INTO ldb_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nggee umbi awe rimi hã, umbi aba adɔsumbi abina kishoo umbɔ aka adɛyiwa umbi. Umbi awuri igɔr agɛ, <Umɛn isi iwemɛn ubin, umɛn iwu agãrhã. Umɛn ikpurhi itɔ̃ itseryɛ iki iwe iyimɛn.> >> ");
INSERT INTO ldb_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Icɛ Uyesu awu ru uzãrhã ukpuku uzĩ Urusharhima, unga azɛ̃rhã ra atsom Usamariya nggu Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Unga aka atsĩ ru ungwɛ̃rhũ uteu ukpɔɔ akatsak abi irhãrhĩ ingbim usɔka agbanga unga, adɛ̃ɛ̃ ukuka. ");
INSERT INTO ldb_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Umbɔ atsarhi irhakmbɔ agɛ, <<Uyesu, Uteiya, ugũ atorh umɛn!>> ");
INSERT INTO ldb_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ivangyɛ unga aka anyã umbɔ, unga agɛ, <<Àka azĩ ra abika adzowe idɛm-Num umbɔ anyã umbi.>> Umbɔ awu ru utsĩndĩ uwuku uzĩ, na akerhumbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Unying ru umbɔ aka anyã unga aka akerhunga, unga abvui aba atsu ivum akpoi Unum. ");
INSERT INTO ldb_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Unga aba agba ra adak Uyesu na atar uwɛɛ ru unga. Unga uwi awu uner Usamariya. ");
INSERT INTO ldb_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Uyesu arhusa agɛ, <<Asi iwea inera usɔka kishoo aka akerhe? Abɔrɔ utɔɔrha angwɛ̃mbɔ? ");
INSERT INTO ldb_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Awu use ukpɔ utsu akpurha awu utsen uwurɛ ikiyikanga unga abvui aba ikpoi Unum?>> ");
INSERT INTO ldb_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Mɔcɛ unga agɔr unga agɛ, <<Usisok uzĩɔ. Imangmangngo ngge ikerhuwe ungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Unuma nukpɔ abi Ufarisi arhusa unga agɛ Iyɛrhe Unum iwuri iba ukang? Uyesu agɔr umbɔ agɛ, <<Ibiba Iyɛrhe Unum isi íwengge ubinkpi umbi aka inyã ra asumbi, ");
INSERT INTO ldb_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Unera asi ígɔra agɛ, <Àka anyã nggayɛ,> use <Nggayɔ,> ubinkutsu Iyɛrhe Unum iwu nggu umbi.>> ");
INSERT INTO ldb_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Mɔcɛ unga agɔr angwɛ̃ imesanga agɛ, <<Ivanga niyɔ ibarɔ, umbi aka ibee inyã unuma unying ri inum Ungwɛ̃-Ner, bɔr umbi asi ínyãmbi. ");
INSERT INTO ldb_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Anera awuri igɔr umbi agɛ, <Àka anyã nggawi ri nggimi,> use <Nggawɔ ru nggɔɔ.> Niba azĩmbi, niba adɔsumbi umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ubinkutsu unum Ungwɛ̃-Ner uwuri iwe ru nyaki inai iki inyaka irhangnge afã, usok ru ubang upfunga nggɔɔ uzĩ ubang ukpɔrɔ. ");
INSERT INTO ldb_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bɔr awu ufang unga aka igbaashia ahwa uver abina arhɛrhɛ nu undan ukpirɛ ukpɛ̃kpɔ unga. ");
INSERT INTO ldb_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","<<Ru nyaka ngge iki iwe ri inum Unuhu, rimi hã ikɛi ngge iki iwe ri ivang Ungwɛ̃-Ner. ");
INSERT INTO ldb_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Anera agha na ahwa, apfuna na apfunuwe, utsɛku unumkpi Unuhu aka atsĩ ru nggaa ukhukhɔɔ amɛ̃, mɔcɛ amɛ̃ isopfung aba atsĩme umbɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","<<Iwe ru nyaka ha ri inum Urhutu, anera aka agha na ahwa, agoi na agoyiwe, akau irham na adzin idzin. ");
INSERT INTO ldb_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bɔr ru unum Urhutu aka adzeka ru Usɔdɔm, umbɔ atsuke urha nggu akãã urha adzeka afã aba atsĩme umbɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","<<Ĩĩ, iwuri iwe rimi hã ru unum Ungwɛ̃-Ner aka idzeka. ");
INSERT INTO ldb_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ru unum hã uwuruwi aka awu afafã ni itsi uvi iyanga na abinnga awu ra abĩ, unga niba acipuwanga inyanga ake. Rimi hã ikɛi, uwuku uwe ru usi, niba abvui abanga ri iya. ");
INSERT INTO ldb_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Àka ayitu utsɛrha Urhutu. ");
INSERT INTO ldb_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Kishoo abika abee ifɔrh urhɛmbɔ, umgbɔ uwuri igwirmgbɔ. Kishoo abika agwirhuwe urhɛmbɔ, afufɔrh umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Umum ididɛyiwa umbi, nu utsuu ukpu ha awuri inyãmbɔ inera ivaa nu ukoma unying. Awuri nyanguwe unying na abɔre unying. ");
INSERT INTO ldb_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akatsɛrh avaa aka idɛ̃ɛ̃ igɔɔ ananga unying. Awuri nyanguwe unying na abɔre unying.>> ");
INSERT INTO ldb_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Umbɔ arhusa unga agɛ, <<Awuri iwe rinɛɛ Uteijee?>> Unga agɔr umbɔ agɛ, <<Anangkɛ ukom uku uwe, anang hã amgbɛpɛ iki ikɔng.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mɔcɛ Uyesu adɛyiwe angwɛ̃ imesanga unyaka arherhe aki ifɛn-Num ubɛn ivang na aneke igũ azhe. ");
INSERT INTO ldb_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Unga agɛ, <<Utepa nukpɔ uner uwuku utsu uvau aka asi igũa iwei Unum, asi ihwɛngnga unera. ");
INSERT INTO ldb_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ru uteu ha utsɛ̃rhãpfu ruwɔ akɛyi ru utsa ha anu igɔr unga agɛ, <Umaa utsĩ ra ateu umum nggu abika akpɛ̃na umum.> ");
INSERT INTO ldb_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","<<Unga atirhi akpɛ̃ɛ̃, bɔr unga abvui agɔr ra amɛnnga agɛ, <Umum ihwɛng ugɛ umum isi igũmum iwei Unum, ni isi ihwɛng anera, ");
INSERT INTO ldb_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","bɔr utsɛ̃rhãpfu uwurɛ akɛna umum iwiwosha. Umum ima iyike unga, utsur ikikɛyanga izhengge umum.> >> ");
INSERT INTO ldb_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Uteijee agɛ, <<Àka agũ ubinkpi uner uwuku utsu uvau uwu amɛn aka atãrhã aka arherhe. ");
INSERT INTO ldb_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Unum asi íkorhuka anernga aka asɛng abinkɛ aka arhika, abirabɛ aki iciu ru utsuu na atenum ru unga? Unga awuri adɔ̃rhũnga ri iyike umbɔ? ");
INSERT INTO ldb_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Umum idɛyiwa umbi, awuri iyikuka umbɔ ifitem ikɛi ru ubinkpi umbɔ aka abee. Bɔr Ungwɛ̃-Ner aka iba, awuri ikpoa imangmang ru upfung?>> ");
INSERT INTO ldb_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ra abirabɛ aka adzowe imangmang ra atsimbɔ agɛ umbɔ arhika, na anu iyɛɛi abikase, Uyesu arherhe unyaka arherhe ugɛ, ");
INSERT INTO ldb_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","<<Inera ivaa atsĩ ifɛn-Num ru ufɔm Iya-Num, unying awu utsa Ufarisi, uwu uvaa awu uner uwuku uyɛi ikirbi abĩ. ");
INSERT INTO ldb_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Uner Ufarisi ha asok abera adɛ̃ɛ̃ afɛn-Num ri itsikamnga agɛ, <A Unum, umum itar uwɛɛ ĩdzaa ungo umum iki isi iwemum ru nyaka avɛu, abika ida irhirhika, abika atoma-dak, use uwuku uyɛi ikirbi abĩ uwurɛ. ");
INSERT INTO ldb_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Umum ikpem igha ubin idiki ivaa ri inuma utɔɔva, ni idzowe unying ra abina usɔka ra abinkɛ umum iki ikpo kishoo.> ");
INSERT INTO ldb_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","<<Bɔr uner uwuku uyɛi ikirbi abĩ hã adɛ̃ɛ̃ uku uka. Asi ibera asunga arhisa afã, bɔr abangu ikɔknga na agɛ, <A Unum, ugũ atorh umum uner arhim.> ");
INSERT INTO ldb_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","<<Umum idɛyiwa umbi, uner uwuku uyɛi ikirbi abĩ hã abvui azĩ ri iyanga, Unum anyanga unga awu uner uwuku urhika, bɔr asi inyangu utsa uwɔrɔ awea rimi. Ubɛn unerwi aka aberi itsinga, awuri irhɛrhuwe ike. Nu uwuruwi aka arhɛrhi itsinga, awuri ibiberuwe ike.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Anera ikɛi akũ angwɛ̃rhã awɛkaci aba ru Uyesu abanga umbɔ. Angwɛ̃ imesanga aka anyã rimi, umbɔ atsɛrha umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bɔr Uyesu ayisa awɛkaci ha azĩ ru unga, na agɛ, <<Àka aneke awɛkaci aba ru umum, Àka niba akɛnmbi umbɔ, Iyɛrhe Unum iwu iyi ikpũmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Umum indɛyiwa umbi idzidzɛrhe, ubɛn unerwi aka asi iyɛisa Iyɛrhe Unum ru nyaku uwɛkuci, asi ídɛ̃ɛ̃ atsĩã ri ngge.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Uyɛrhu Uyahuda uwɔɔ arhusa unga agɛ, <<A umarhem uwuku uze, umum ikorhe uguse ni ikpo urhɛ uwu ugbagbaa?>> ");
INSERT INTO ldb_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Uyesu agɔr unga agɛ, <<Awu use utsu ungo uyisa umum uwuku uze? Uwuku uze ashia, Unum ukpekũ awu uwuku uze. ");
INSERT INTO ldb_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ungo uhwɛngo íkpem iyɛrɛ, <Niba ufɛrɔ unera, niba utomungo-dak, niba uvɛpɔ ivɛu, niba ugbɛrɔ angwĩ utsukukɔ unera, udzowe igɔng ru utɛngo nu uyango.> >> ");
INSERT INTO ldb_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Uwɛdzɛm hã agɛ, <<A umarhem, umum iki idɔsumum akɛrɛ ha kishoo rimɔ̃ɔ̃, utirhi ri iwɛ̃nci.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Uyesu aka agũ rimi, unga agɔr unga agɛ, <<Ungo ubɔr ubina unying ukpekũ. Ugoshe abinngo kishoo, udzowe uhwɛka ra atsũwã, nu uba udɔsa umum. Mɔcɛ ungo uwuri iweɔ ru ugbɛta urhɛrhɛ ra afã.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Unga aka agũ rimi, amɛnnga aghong akarhãrhã, ubinkutsu unga awu uner ubin akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Uyesu arhi unga na agɔr agɛ, <<Aghong uner ubin aka itsĩ ri Iyɛrhe Unum. ");
INSERT INTO ldb_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Idzidzɛrhe, uwuri ighwɔrhungge Urhakumi utsĩ ra angwĩ inepurha nu uner ubin aka itsĩ ri Iyɛrhe Unum.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Abika agũ rimi, arhusa agɛ, <<Ungaa adɛ̃ɛ̃ akpo ififɔrh?>> ");
INSERT INTO ldb_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Uyesu agɛ, <<Ubin ukpuku unang anera, Unum ananga ukpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ubitru agɔr unga agɛ, <<Umɛn abɛ ineke abinmɛn kishoo ni idɔsa ungo!>> ");
INSERT INTO ldb_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Uyesu agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, unera asi íneke iya use utsɛrh, use angwɛ̃mbɔ, use ateinga, use awɛkaci ri itsi Iyɛrhe Unum, ");
INSERT INTO ldb_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","na asi ikpoa arhɛrhɛ ru udan ukpirɛ, ru unum upfung uku ufa uku iba ikɛi unga akpo urhɛ uwu ugbagbaa.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Uyesu akũna umbɔ usɔkdũmɛn azĩ ri ibanga, na adɛyiwe umbɔ agɛ, <<Umɛn izĩ ufã Urusharhima, nu kishoo abinkɛ abika asɔm Arherhu-Num aka atsɛng ri itsi Ungwɛ̃-Ner awuri itsuafɛrke. ");
INSERT INTO ldb_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Awuri idzowe unga ra abok atsen abi Uyahuda. Umbɔ awuri iyɛia unga, arhena unga, ashau aci atsuyiwe unga, awuri ikwɛr unga, na afɛre unga. ");
INSERT INTO ldb_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ru unum untaar unga awuri isoka ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bɔr angwɛ̃ imesanga asi igũ arherhanga ataimbɔ. Agbena awuwɔk ru umbɔ, nu umbɔ asi ihwɛngmbɔ ubinkpi unga aka arherhe. ");
INSERT INTO ldb_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Uyesu aka ayoku Ujeriko, uner ibvuta asei nu ubang utsĩndĩã anu ifɛn. ");
INSERT INTO ldb_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ivangyɛ unga aka agũ ititɔng anera arhɛrhɛ, unga arhusa agɛ awu use uni izãrhã? ");
INSERT INTO ldb_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Umbɔ adɛyiwe unga agɛ, <<Uyesu uner Unazarat unga atɔng.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Unga atsarhi irhaknga ayisa agɛ, <<Uyesu! Ungwɛ̃ Udauda! Ugũ atorh umum!>> ");
INSERT INTO ldb_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Abika azɛ̃rhã ra asu Uyesu atsɛrha unga agɛ unga unukutata, bɔr unga agbisha atsarhi irhaknga agɛ, <<A Ungwɛ̃ Udauda! Ugũ atorh umum.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Uyesu adɛ̃ɛ̃ na atsu umbɔ akũ uner ibvuta ha aba ru unga. Unga aka aba ukhapa, Uyesu arhusa unga agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","<<Ungo ubee umum ikorhuwa ungo use?>> Unga agɛ, <<A Uteijee, umum ibee ikpo inyã anang.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Uyesu agɔr unga agɛ, <<Uyɛi inyinyãngo. Imangmangngo ngge ikerhuwa ungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kanying asunga ayanguke, unga adɔsu Uyesu na akpoi Unum. Anera kishoo aka anyã rimi, umbɔ akpoi Unum ikɛi. ");
INSERT INTO ldb_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Uyesu aka atsĩ ru Ujeriko, na azɛ̃rhã atɔng. ");
INSERT INTO ldb_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Uner uwɔɔ umɔ itsoka igburh Uzakka, unga awu unggbaashi abika ayɛi ikirbi abĩ, na awu ru ubin akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Abee inyã ungamɔ awu Uyesu ha. Bɔr Uzakka akpinunga asi idɛ̃ɛ̃ anyãã Uyesu, anera arhɛmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nggee unga atĩ agbaashia azĩ afũ nggaa ucucii abee inyã unga, Uyesu ani itɔng udika ha. ");
INSERT INTO ldb_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Uyesu aka azĩ atsĩ ra anang ucucii ha, unga abera asunga afafã na agɔr unga agɛ, <<A Uzakka, ucipuwa ififitem, awu ufang umum iki icipa ri iyango irherɛ.>> ");
INSERT INTO ldb_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nggee iki ififitem unga ahwarha acipuwa aba agbanga unga nggu agɔm. ");
INSERT INTO ldb_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Anera kishoo aka anyã rimi, umbɔ atirhi ibvun arherhe agɛ, <<Unga azĩ iwu utsen uner arhim.>> ");
INSERT INTO ldb_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bɔr Uzakka asok adɛ̃ɛ̃ na agɔr Uteijee agɛ, <<A Uteijee, unyã! Icɛrɛ umum idzowe uteng abinkɛ umum iki iwu ra ake ra atsũwã, ni ifase idikunga inaa ra abirabɛ umum iki igha urhambɔ ri iyɛi ikirbi abĩ.>> ");
INSERT INTO ldb_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Uyesu agɔr unga agɛ, <<Ififɔrh iki itsĩngge ri iya ikɛrɛ irherɛ, ubinkutsu utsak uwurɛ iganga awu unang Uibrahim. ");
INSERT INTO ldb_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ungwɛ̃-Ner aba ibee abirabɛ aka agwir, na afɔrh umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Anera aka anu igosha akɛrɛ ha, unga atsĩã irherhe unyaka arherhe, ubinkutsu unga aka ayoka itsĩ Urusharhima, umbɔ akaifɛrhkɔ ugɛ use Uyesu awuri itsu Iyɛrhe Unum idzeka kanying ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Unga agɛ, <<Utsa uwɔɔ aka akpo imar iyiki ize asok azĩã itsim iyɛrhe ra abĩ akɔɔ, ra anang aka ader, na abvui aba ra abĩnga. ");
INSERT INTO ldb_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nggee unga ayisa agãrhãnga usɔka, agashuwe umbɔ imang uazurhfa unying anying, na agɔr umbɔ ikɛi agɛ, <Àka akũ imang hã adzipa utsɛku umum iki iba.> ");
INSERT INTO ldb_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","<<Bɔr abi utepunga akpɛ̃mbɔ unga, umbɔ adene itser umbɔ azĩ agɔr unga agɛ, <Umɛn isi ibemumɛn ungo uwu uyɛrhamɛn.> ");
INSERT INTO ldb_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","<<Umbɔ aka atsĩme iyɛrhanga, unga abvui aba ri iya. Unga atsu umbɔ ayisuwe agãrhãnga hã, unga aka adzowe imang hã. Abee inyã angwĩkɛ umbɔ aka akpo atoma ri idzidzipambɔ. ");
INSERT INTO ldb_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","<<Uwu inggbaashia aba adɛ̃ɛ̃ ra asunga na agɛ, <A uteiya, imang uazurhfango hã ikũwã umum uazurhfa usɔka.> ");
INSERT INTO ldb_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","<<Uteiyanga agɛ, <Ĩhĩĩ, ungo udɛ̃ɛ̃, ugãrhũ uwuku uze, ubinkutsu ungo uweɔ ri idzidzɛrhe ru ubin ukpuku uci, umum iwuri ĩdzaamum ijee itepa usɔka.> ");
INSERT INTO ldb_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","<<Uwu uvaa aba agɛ, <A uteiya imang uazurhfango hã ikũwã umum uazurhfa atɔ̃ɔ̃.> ");
INSERT INTO ldb_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","<<Uteiyanga agɔr unga agɛ, <Ĩhĩĩ, ungo udɛ̃ɛ̃, ugãrhũ uwuku uze, ubinkutsu ungo uweɔ ri idzidzɛrhe ru ubin ukpuku uci, umum iwuri ĩdzaamum ungo iyɛrhe itepa itɔ̃ɔ̃.> ");
INSERT INTO ldb_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","<<Mɔcɛ ugãrhũ uwɔɔ aba agɛ, <A uteiya, imang uazurhfango hã iyɛ, umum iwɔke ru utatorho. ");
INSERT INTO ldb_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Umum igũ iwei ungo, ungo ughong ikorhi ifɛrhɛ. Nu ubema abinkɛ ungo uku usi ingwɛ̃ɔ, nu ugbɛrɔ ubinkpi ungo uku usi idosɔ.> ");
INSERT INTO ldb_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","<<Unga agɔr unga agɛ, <Ungo ugãrhã uwuku utãrhã, umum ikũ arherhe angwĩngo itsu ungo uvau. Ungo uhwɛngngo umum ighong ikorhi ifɛrhɛ, ni ibee abinkɛ umum iki isi ingwɛ̃mum, ni ĩgbɛtũ abinkɛ umum iki isi idoimum? ");
INSERT INTO ldb_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Awu use utsu ungo isi itsukukɔ imangmum ru ubanki, umum iki iba icɛrɛ iyɛi ngge nggu angwĩngge?> ");
INSERT INTO ldb_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","<<Mɔcɛ unga agɔr abika adɛ̃ɛ̃ umɔ agɛ, <Àka ayɛise imang uazurhfamum unying hã ru unga, àka adzowe ru uwɔrɔ uwu uazurhfa usɔka.> ");
INSERT INTO ldb_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","<<Umbɔ agɔr unga agɛ, <A uteiya, awea ra uazurhfa usɔka.> ");
INSERT INTO ldb_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","<<Unga agɛ, <Umum idɛyiwa umbi, uwuruwi aka awe ru ihwihwɛng awuri itomuwe unga akpo arhɛrhɛ. Uwuruwi aka ashia, awuri iyɛse ungwɛ̃rhĩ ihwihwɛng ha unga aka awerangge. ");
INSERT INTO ldb_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Icɛrɛ, anggamtsakmum aka asi ibemumbɔ umum iki iwu uyɛrhambɔ, àka akũna umbɔ aba nggɛɛ na afɛre umbɔ ra asumum.> >> ");
INSERT INTO ldb_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Uyesu aka arherhe akɛrɛ amaa, unga agbaashia azĩã ufã Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Unga aka ayoka uteu iyiki ici iyi Ubetafaji nu Ubetani udiki igũ iyɔrɔ umbɔ iki iyisa agɛ Igũ Acucii Uzaitun, unga adene angwɛ̃ imesanga avaa agɔr umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","<<Àka atsĩ ru uteu ukpuku uci nggɔɔ ra asumbi, ubɛn itsitsĩmbi, umbi awuri inyãmbi ungwɛ̃ uzhika aka abow adɛ̃ɛ̃, uwuruwi unera anasi ifũã umgbɔ. Aka agarha umgbɔ akũ aba nggɛɛ. ");
INSERT INTO ldb_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Unera aba arhusunga umbi agɛ, <Awu use utsu umbi agarha umgbɔ?> Àka adɛyiwe unga ugɛ, <Awu Uteijee abeea umgbɔ.> >> ");
INSERT INTO ldb_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Abɔrɔ unga aka adene umbɔ agbaashia, azĩ anyã umgbɔ ru nyaka unga aka adɛyiwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Umbɔ aka adɛ̃ɛ̃ igarhu ungwɛ̃ uzhika ha, abi uzhika ha arhusa umbɔ agɛ, <<Awu use utsu umbi anu igarhu ungwɛ̃ uzhika ha?>> ");
INSERT INTO ldb_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Umbɔ agɛ, <<Uteijee unga abeea umgbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Umbɔ akũ umgbɔ aba ru Uyesu, abɛtuwe atorhambɔ nu undzingmgbɔ, Uyesu afũ asei nu umgbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Unga awu ru uzãrhã, anera abɛtuwe atorhambɔ nu utsĩndĩã. ");
INSERT INTO ldb_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ivangyɛ unga aka aba akhapa ri icipa ri Igũ Acucii Uzaitun, kishoo ikikɔng angwɛ̃ imesa atsĩmbɔ anggɔm, akpoi Unum nggu irhɛm ikerketangge ra abin idzeu kishoo umbɔ aka anyã. ");
INSERT INTO ldb_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Agɔr agɛ, <<Idorh iwe nggu uyɛrhe uwi aka aba ri itsok Uteijee! Ididɔɔr ra afã, nu ikpikpoi afafã!>> ");
INSERT INTO ldb_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Bɔr abi Ufarisi abɔɔ ri ikikɔnga agɔr Uyesu agɛ, <<A umarhem, utsɛrha angwɛ̃ imesango!>> ");
INSERT INTO ldb_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Unga agɔr umbɔ agɛ, <<Umum idɛyiwa umbi, abɛrɛ ha aba anukutata, atarh awuri idze aciuke.>> ");
INSERT INTO ldb_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Unga aka ayoka Urusharhima na anyã utepa, unga aciu akpe uteu ha. ");
INSERT INTO ldb_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Na agɛ, <<Uda umbi awuri ihwɛngmbi abinkɛ aki ikũwã ididɔɔr! Bɔr nggayɛ umbi asi idɛ̃ɛ̃ anyãmbi. ");
INSERT INTO ldb_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Inuma niyɔ ibarɔ anggamtsakmbi awuri idzin ufɔm adzipa umbi. Abi iwa awuri ikena umbi amaa inanga, na ayɔm umbi. ");
INSERT INTO ldb_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Awuri ikwɛr umbi atar nu abĩ, umbi nggu awɛkaci ra abangdzinmbi. Asi ínekukumbɔ utarh unying nu undɔkakpɔ, ubinkutsu umbi asi ihwɛngmbi ivang ibiba Unum ru umbi.>> ");
INSERT INTO ldb_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mɔcɛ unga atsĩ ru ufɔm Iya-Num, na awayiwe abika agoyiwe abin. ");
INSERT INTO ldb_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Agɔr umbɔ agɛ, <<Atsɛngmbɔ agɛ, <Iyamum iwu iya iki ifɛn-Num,> bɔr umbi atsu ike iwe anang awoi avɛu!>> ");
INSERT INTO ldb_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ubɛn unuma unga amesuwe ru ufɔm Iya-Num. Bɔr ateiya abika adzowe idɛm-Num, nu abika amesuwe Ikpem nu anggbaashi anera abee ifɛr unga. ");
INSERT INTO ldb_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Rimi hã asi ikpombɔ udĩkpi umbɔ aka ikorhe, ubinkutsu anera kishoo ayurhi ra arherhanga. ");
INSERT INTO ldb_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Unuma nukpɔ unga aka anu imesuwe anera ru ufɔm Iya-Num, unga aka adzowe Isarhe Iyiki Ize, ateiya abika adzowe idɛm-Num na abika amesuwe Ikpem Umusa nu akakũmbɔ, aba agɔr unga agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","<<Udɛyiwa umɛn ungo ukũ ijee iyikisong ukorhi ifɛrha iyɛrɛ ha? Ungamɔ adzaa ungo ijeea?>> ");
INSERT INTO ldb_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Unga agɔr umbɔ agɛ, <<Umum ibee irhusa umbi, àka adɛyiwa umum. ");
INSERT INTO ldb_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ubɔtisima Uyohana udzeka afã use udzeka anera?>> ");
INSERT INTO ldb_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Umbɔ akɛki itsũwã nggu adɔkambɔ, agɛ, <<Umɛn iba igɔr ugɛ, <Udzek ra afã,> unga awuri irhusa umɛn agɛ, <Awu use utsu umbi ashimbi ri imangmang ru unga?> ");
INSERT INTO ldb_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bɔr umɛn iba igɔr ugɛ, <Udzek ra anera,> umɛn igũ iwei anera abɛrɛ, ubinkutsu, umbɔ anyangu Uyohana awu uner uwuku usɔm Arherhu-Num.>> ");
INSERT INTO ldb_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nggee umbɔ agɔr unga agɛ, <<Umɛn isi ihwɛngmɛn anangkɛ umgbɔ uku udze.>> ");
INSERT INTO ldb_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Uyesu agɔr umbɔ agɛ, <<Umum igamum isi ídɛyiwamum umbi umum ikũ ijee iyikisong ikorha abin hã.>> ");
INSERT INTO ldb_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Uyesu arherhuwe anera unyaka arherhe ugɛ, <<Unera nuwɔ akau icang irham inebi, na adzowuka abi irham imang, na azĩã uteu ukpɔɔ azĩ adãrhũnga. ");
INSERT INTO ldb_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ivang inebi ha iki ibĩ, unga adene agãrhãnga ra abi irham imang hã agɛ, umbɔ adzowe ikpũrhã inebi ha ri icangnga, bɔr abi irham imang hã akwɛr ugãrhã hã na adene unga azĩã abok aka atãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Unga adene ugãrhũ uwu uvaa, uwu ha ikɛi umbɔ akwɛr na atsuyiwe unga atsa na awayiwe unga azĩã abok aka atãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Unga ana adene uwu untaar ikɛi, uwu ha umbɔ atsuyiwe unga isɔɔ na atare unga adzeka. ");
INSERT INTO ldb_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","<<Mɔcɛ uner icang hã agɛ, <Umum ikorhi iguse ucɛ? Umum iwuri idene ungwɛ̃mum uwuruwi umum iki ibema, use umbɔ awuri idzowukumbɔ imor unga.> ");
INSERT INTO ldb_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","<<Bɔr ivangyɛ abi irham imang hã aka anyã unga, umbɔ akɛki itsũwã nggu adɔkambɔ agɛ, <Uwɛrɛ unga awu uner ukam hã. Umɛn ifɛre unga nu ukam hã uwu ukpumɛn.> ");
INSERT INTO ldb_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nggee umbɔ atare unga ru undzing ufɔm icang hã, na afɛre unga. <<Ude icɛ, uner icang irham hã awuri ikorha aguse nggu umbɔ? ");
INSERT INTO ldb_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Unga awuri iba atsĩme abi irham imang hã, na adzowe icanga ru aner abɔɔ.>> Ivangyɛ anera aka agũ rimi, umbɔ agɛ, <<Akɛrɛ ama aneke iwe rimi!>> ");
INSERT INTO ldb_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Uyesu arhi umbɔ, na arhusa agɛ, <<Awu use uwu agben itsɛng Arherhu-Num iki igɔr ugɛ, << <Utarhkpi abi idzin aka akpɛ̃mbɔ, ukpu ha uwu utarh angboki idzina>? ");
INSERT INTO ldb_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ubɛn unerwi aka igba ni itsi utarh ha, akpurha ashaka. Nu uwuruwi utarh ha uku igba nú unga, ukpurhu ugɔke unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Abika amesuwe Ikpem Umusa nu ateiya abika adzowe idɛm-Num abee utsĩndĩwi umbɔ aka idzur unga kanying, umbɔ ahwɛngmbɔ ugɛ arherhe unyaka arherhe akɛrɛ ri itsimbɔ. Bɔr umbɔ anu igũ iwei anera. ");
INSERT INTO ldb_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Adene anera azĩ akhapa ru unga, na akpeta agɛ umbɔ arhika. Abee idzur Uyesu ri irhɛm arherhanga na atsuke unga ru ubok ijee ugomna. ");
INSERT INTO ldb_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Nggee aner ha umbɔ aka adene arhusa unga agɛ, <<A umarhem, umɛn ihwɛngmɛn arherhango nu imesango irhika, ungo ushiɔ ri itɛngasu, ikɛi ungo umesuwe anera idzidzɛrhe ru utsĩndĩ Unum uku urhirhiki. ");
INSERT INTO ldb_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Irhikungge umɛn ifai ikirbi abĩ ru Ukaisar use isi irhikungge?>> ");
INSERT INTO ldb_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bɔr unga anyã ikoiambɔ unga agɔr umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","<<Àka adɛyiwa ishaa imang hã. Awu uzirhzĩ ungaa, nu itsok ungamɔ iwu umɔ?>> ");
INSERT INTO ldb_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Umbɔ agɛ, <<Ukaisar.>> Unga agɔr umbɔ agɛ, <<Àka adzowe Ukaisar ubin ukpu Ukaisar, na adzowe Unum ubin ukpu Unum.>> ");
INSERT INTO ldb_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Umbɔ afɔr idzur unga adambɔ ra arherhakɛ unga aka arherhe ra asu anera. Adzeidzeu ri idzipa arherhanga na akpurha anukutata. ");
INSERT INTO ldb_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Icɛ abi Usaduki agɔr agɛ isok ra akpe ishingge. Abɔɔ aba ru Uyesu arhusa agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","<<A umarhem, Umusa atsɛnga umɛn agɛ, unera aba akpea na abɔruka utsɛ̃nga ashia ru ungwɛ̃, awu ufang ungwɛ̃mbɔ anyangu ukam utsɛrh ha na amare awɛkaci ru ungwɛ̃mbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Akatsak abɔɔ rabɔ utɔɔva anambɔ awu unying. Uwu inggbaashia apfunu utsɛrh, ashia ru ungwɛ̃ na akpea. ");
INSERT INTO ldb_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Uwu uvaa anyangu ukam utsɛrh ha na akpea rimi hã. ");
INSERT INTO ldb_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mɔcɛ uwu untaar apfuna unga. Ikɛi ru nyaka ha, uwu utɔɔva apfunu utsɛrh ha na akpe asi ibɔruka ungwɛ̃. ");
INSERT INTO ldb_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ri imimasha utsɛrh ha akpea. ");
INSERT INTO ldb_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ru unum isok ra akpe, awuri iwu utsɛ̃ ungaa ru umbɔ? Ubinkutsu umbɔ utɔɔva ha apfunumbɔ unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Uyesu agɔr umbɔ agɛ, <<Anera ru upfung ukpirɛ apfuna na apfunuwe, ");
INSERT INTO ldb_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","bɔr abirabɛ aka imɛ̃ɛ̃ isok ra akpe ikɛi, asei nggu upfung ukpɔrɔ uku iba asi ípfunumbɔ, asi ídzowukumbɔ ipfuna. ");
INSERT INTO ldb_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Umbɔ asi íbvui akpembɔ, umbɔ awu ru nyaka ípfu itser-Num. Awu angwɛ̃ Unum, umbɔ aka asok ra akpe. ");
INSERT INTO ldb_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ikɛi Umusa adɛyika ugɛ abika akpe awuri isokmbɔ. Ra arherhakɛ unga aka arherhe ru ufum uku ugar urha, unga aka ayisu Uteijee, Unum uwu Uibrahim, nu Unum uwu Uishaku, nu Unum uwu Uyakubu. ");
INSERT INTO ldb_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Unga asi iwea Unum uwu ikom, bɔr awu Unum uwu abi urhɛ, ru unga kishoo awu ru urhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Abɔɔ abika amesuwe Ikpem agɛ, <<A umarhem, ungo urherhe mɔnɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Mɔcɛ umbɔ ashimbɔ ri ikeramɛn iyiki irhusa unga arherhe akɔɔ. ");
INSERT INTO ldb_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Mɔcɛ Uyesu agɔr umbɔ agɛ, <<Awuri ikorha aguse na agɔr agɛ, Ukiristo awu ungwɛ̃ Udauda? ");
INSERT INTO ldb_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Udauda nibikanga agɔr ru Ubvur Ambom agɛ, << <Uteijee agɔr Uteijeemum agɛ, <<Usei ru ubok ughamum, ");
INSERT INTO ldb_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","utsɛku umum iki itsu anggamtsakngo ru andaidakngo.>> > ");
INSERT INTO ldb_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Udauda ayisa unga agɛ, <Uteijee>. Ude awuri ikorha aguse na awu ungwɛ̃nga?>> ");
INSERT INTO ldb_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ivang anera aka anu ikpeto, Uyesu agɔr angwɛ̃ imesanga agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","<<Àka angwɛ̃dzɛn nggu abika amesuwe Ikpem. Umbɔ abee itsim atorho akagɔng azɛ̃rhã, abee anera aghwe umbɔ ri inang izɛɛ, ikɛi umbɔ abee anera adzise umbɔ anang isei aka aze ra abã ifɛn-Num, nu anang isei aka aze ra anang irhowa. ");
INSERT INTO ldb_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Umbɔ awu abika aghawe abin atsɛ̃rhãpfu na avur ayambɔ, na adarhi ider ifɛn-Num iyi igbana. Ikpũ umbɔ awuri itsu umbɔ ufai akarhãrhã.>> ");
INSERT INTO ldb_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Uyesu aka abera arhi anyã, abi ubin aka atsuyi izũwãmbɔ ri ijara izũwã ru ufɔm Iya-Num. ");
INSERT INTO ldb_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Unga ikɛi anyã utsũwũ utsɛ̃rhãpfu iganga aka atsuke ungwɛ̃rhĩ íshaa imang ivaa umɔ. ");
INSERT INTO ldb_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Unga agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, utsũwũ utsɛ̃rhãpfu uwurɛ atsu ananga abɔɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Kishoo adzowe izũwãmbɔ ri iwu ru ubinmbɔ. Bɔr unga ri itsũwãnga, unga adzowe kishoo ubinkpi unga aka awu ra ukpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Angwɛ̃ imesanga abɔɔ anu irherhe arherhe ra abinkɛ umbɔ aka akũ agbishu Iya-Num, nggu atarh aka aze nu izũwãyɛ umbɔ aka adzise ru Unum, bɔr Uyesu agɛ, ");
INSERT INTO ldb_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","<<Aba awu abin hã umbi aka azɛrhe, ivanga niyɔ ibarɔ utarh unying umbɔ asi íneke ukpɔɔ utsorhukpɔ nu undɔkakpɔ, awuri isituwe ake kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Umbɔ arhusa unga agɛ, <<A umarhem, ifɛrhɛ ha iwu ukang? Utsar ukpukusong ikɛi umbɔ aka inyã ri ivangyɛ ngge iki iyok?>> ");
INSERT INTO ldb_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Unga agɛ, <<Àka angwɛ̃dzɛn utsur umbɔ arhɛmmbɔ umbi. Ubinkutsu anera arhɛrhɛ aka iba ri itsokmum, umbɔ awuri igɔr agɛ, <Umum iwu unga,> nu <Ivanga iki iyongge.> Niba adɔsumbi umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Umbi aba agũmbi isarhe iwa nu isoyi anang, niba agũmbi iwei. Awu ufang ifɛrhi iyɛrɛ ha igbaashia ikorhe, bɔr isok upfung isi íwengge kata.>> ");
INSERT INTO ldb_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Mɔcɛ unga agɔr umbɔ agɛ, <<Abĩ nggu abĩ akase awuri itang iwa nggu adɔkake. Iyɛrha abĩ nggu iyɛrha abĩ akase awuri itang iwa nggu adɔkake. ");
INSERT INTO ldb_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Umɔ awuri izusu upfunga akarhãrhã, ikɛi imerh nggu ikpo ri inanga irhɛirhɛ. Abin iwei ikɛi nu atsar agɔgɔngake aki idzeka afã. ");
INSERT INTO ldb_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","<<Bɔr umbɔ awuri idzaa umbi uver, na adzowe umbi ra anang aka avarha arherhe aki abi Uyahuda na atsuke umbi ra abã ifɛn-Num nu ra agborzĩ, na atsu arherhe ri itsimbi ikɛi ra ayɛrhe nu agomna, ubinkutsu umbi awu abimum kata. ");
INSERT INTO ldb_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Akɛrɛ ha awuri iwu atsĩndĩkɛ umbi aka idɛyiwe umbɔ isarhe ri itsimum. ");
INSERT INTO ldb_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bɔr àka atsu amɛnmbi, niba agũmbi ighong ubin umbi aka irherhe akaa atsimbi. ");
INSERT INTO ldb_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ubinkutsu umum iwuri idzaamum umbi irhɛm nu itsoi arherhe akirakɛ anggamtsakmbi asi íwembɔ ru uning na akpɛ̃mbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ateimbi, angwɛ̃mbi, abi ubãmbi, nu awɛrhambi awuri ighambɔ adakmbi. Awuri ifɛrukumbɔ abɔɔ ru umbi. ");
INSERT INTO ldb_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Anera kishoo awuri ikpɛ̃mbɔ umbi ri itsimum. ");
INSERT INTO ldb_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bɔr igwar itsimbi unying isi ígwirngge. ");
INSERT INTO ldb_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Awu ibibimambi iwuri ĩdzaa umbi urhɛ. ");
INSERT INTO ldb_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","<<Ivangyɛ umbi aba anyã abi iwa akan adziir Urusharhima, umbi ahwɛngmbi ugɛ itsitsimngge iki iyongge. ");
INSERT INTO ldb_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mɔcɛ abirabɛ aka awu ru Uyahudiya atĩ afũ ra akpowa. Abirabɛ aka awu ru utepa atĩ adzeka. Nu abika awu ra awiya niba atsĩmbɔ utepa. ");
INSERT INTO ldb_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ubinkutsu ivang iyiki itsu ufai riyɛ, iki itsuifɛr kishoo abinkɛ abika asɔm Arherhu-Num aka atsɛng. ");
INSERT INTO ldb_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Atorhmbi akatsɛrh abika awu ra ana nu abika akpɔm awɛkaci ri ivang hã! Uver akarhãrhã uwuri icipuwakpɔ nu abĩ, nu avɔm ikɛi iwuri igba ra anera. ");
INSERT INTO ldb_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Awuri ifɛre abɔɔ nggu akon aka ader, ikɛi awuri idzui abɔɔ akũ azĩ igãrhã ra abĩã kishoo. Atsen abi Uyahuda aba avur Urusharhima ukpɔ uwe ukpumbɔ utsɛki ivangmbɔ iki iba itsuifɛr. ");
INSERT INTO ldb_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","<<Awuri inyãmbɔ atsar ri ishaa unum, ufɛ̃ nu idzɛɛr. Nu abĩã ikɛi, anera kishoo amɛnmbɔ awuri ida, umbɔ awuri igũ ighong akarhãrhã, ru ubvun nu ighwighwii ukau ukugɔng. ");
INSERT INTO ldb_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Anera awuri igbiwa uvermbɔ uzĩkpɔ iwei ra abin hã aka ikorhe ru upfung, na awuri izusa abin akagɔng afafã. ");
INSERT INTO ldb_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ri ivang hã umbɔ aka inyã Ungwɛ̃-Ner iki iba ra amɛɛ nggu ijee ri ikpikpoi akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ifɛrhɛ iyɛrɛ iba itirhugge, àka agbisha adɛ̃ɛ̃ aker, ubinkutsu ivang ififɔrhmbi iki iyongge.>> ");
INSERT INTO ldb_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Uyesu arherhuwe umbɔ unyaka arherhe agɛ, <<Àka arhi ucucii uvorhvo nggu acucii akɔɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Umbi aba anyã umgbɔ utirhi izɛɛ ayerhe aka afa, umbi nibikambi ahwɛngmbi ugɛ ikpũrhũnga isi idãrhũngge ni iba. ");
INSERT INTO ldb_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Rimi hã ikɛi, umbi aba anyã ifɛrhɛ iyɛrɛ ikorhungge, umbi ahwɛng agɛ Iyɛrhe Unum iki iyongge. ");
INSERT INTO ldb_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","<<Umum indɛyiwa umbi idzidzɛrhe, udan ukpirɛ usi ítɔngkpɔ utsɛku ifɛrhɛ ha kishoo iki ikorhe. ");
INSERT INTO ldb_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Afã nggu abĩ awuri itɔngke, bɔr arherhamum asi ítɔngke. ");
INSERT INTO ldb_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","<<Àka angwɛ̃dzɛn, utsur amɛnmbi ayana atsĩke ri ihwihwa nu amɛn akatãrhã nu ifɛrhkɔ ibee abin upfung. Unum hã uba udzur umbi ru nyaku unggurhi. ");
INSERT INTO ldb_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ubinkutsu iwuri iba ra atsi anera kishoo abika awu ru upfung. ");
INSERT INTO ldb_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Aka adzɛu ubɛn unuma na afɛn-Num agɛ umbi ama akpo iker iyiki ishɔɔr ri kishoo abin hã aka ikorhe, umbi awuri idɛ̃ɛ̃mbi ra asu Ungwɛ̃-Ner.>> ");
INSERT INTO ldb_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ubɛn unuma Uyesu amesuwe ru ufɔm Iya-Num, nu untsuuka unga aka isaka adzeku utepa amaa utsuu ni igũyɛ umbɔ iki iyisa Igũ Acucii Uzaitun. ");
INSERT INTO ldb_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ubɛn igɔ̃kpeka anera kishoo aka isaka azĩ ru ufɔm Iya-Num agũsha arherhanga. ");
INSERT INTO ldb_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Irhowu Uborodi ukpuku Usheru Uga iki iyongge. Umbɔ aki iyisa Irhowa Iyiki Igar Utɔng. ");
INSERT INTO ldb_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem agũ iwei anera, nggee umbɔ abee udĩ ukpuku ufɛr Uyesu ri iwɔk. ");
INSERT INTO ldb_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mɔcɛ Ushaitan atsĩ ru Uyahuda, uwu umbɔ aki iyisa Uiskariyoti, unying ra angwɛ̃ imesanga ha usɔkdũmɛn. ");
INSERT INTO ldb_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Uyahuda azĩ ra ateiya abika adzowe idɛm-Num nu anggbaashi abika adzɛu ufɔm Iya-Num akɛka arherhe nggu umbɔ ubinkpi unga aka ikorhe na adzowe Uyesu ru ubokmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Umbɔ agɔm na abemi ifai unga uhwɛk. ");
INSERT INTO ldb_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Unga abemuwe na abee ugarha unga aka idzowe Uyesu ri ivangyɛ anera aka asi íhwɛngmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Unum Irhowa Uborodi ukpuku isheru uga uku uba uwe, unumkpi umbɔ aka ingwã ungwɛ̃ itsurhi iyi Irhowa Iyiki Igar Utɔng adzowe idɛm-Num. ");
INSERT INTO ldb_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Uyesu adene Ubitru nggu Uyohana agɛ, <<Àka azĩ akorhuwa ubingha Irhowa Iyiki Igar Utɔng umɛn iki igha.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Umbɔ arhusa unga agɛ, <<Ungo ubee umɛn ikorhe rinɛɛ?>> ");
INSERT INTO ldb_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Unga agɔr umbɔ agɛ, <<Umbi aba atsĩmbi ru utepa, umbi awuri igbopumbi unera aka atsã idzum amɛ̃. Àka adɔsa unga azĩ ri iyakɛ unga aka itsĩ, ");
INSERT INTO ldb_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","àka adɛyiwe uteiya iyaa ugɛ, <Umarhem agɔr agɛ, <<Ubãã ungwɛ̃kpɔ umum iki igha Irhowa Iyiki Igar Utɔng nggu angwɛ̃ imesamum?>> > ");
INSERT INTO ldb_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Unga awuri idɛyiwanga nggaa ubã ri ubã afã nggu abina ru unɔrkang. Umɔ umbi aka ikorhuwa abina kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Umbɔ azĩmbɔ azĩ anyã abina kishoo ru nyaka Uyesu aka adɛyiwe umbɔ. Nggee umbɔ akorhu ubingha Irhowa Iyiki Igar Utɔng. ");
INSERT INTO ldb_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ivanga iki iwe, Uyesu nggu abi itsernga asei ra anang ubingha. ");
INSERT INTO ldb_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Unga agɔr umbɔ agɛ, <<Umum iki ĩmɛni ikponi igha ubingha Irhowa Iyiki Igar Utɔng iyɛrɛ nggu umbi ni ĩdɔrhi ihwa ayetnum. ");
INSERT INTO ldb_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Umum idɛyiwa umbi, umum isi íbvui ighamum ngge utsɛku unumkpi ngge iki itsuifɛr ri Iyɛrhe Unum.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Unga anyangu ukpɛwa ha, atar uwɛɛ ru Unum na agɛ, <<Àka ayɛi agasha kishookambi. ");
INSERT INTO ldb_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Umum idɛyiwa umbi, umum isi íbvui ihwamum amɛ̃ inebi utsɛku Iyɛrhe Unum iki iba.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na anyangu uborodi, atar uwɛɛ na atsɔka ukpɔ adzowe umbɔ, na agɛ, <<Ukpɛrɛ awu iyormum umbɔ aka adzaa ru umbi. Àka akorhe rimi hã na ayita umum.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ru nyaka ha, umbɔ aka amaa igha ubingha, unga anyangu ukpɛwa agɛ, <<Ukpɛwa uwurɛ awu ibibemuwe-Num iyiki ifa iki itsuifɛr ra adzirhmum, aka idzek agba ru umbi. ");
INSERT INTO ldb_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bɔr aka anyã ubok unerwi aka igha adakmum usei igha ubingha nggu umum nu utebur. ");
INSERT INTO ldb_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ungwɛ̃-Ner awuri ikpe ru nyaku Unum aka abee, bɔr atorh uner ha aka agha adaknga.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Mɔcɛ angwɛ̃ imesa atirhi irhusa adɔkambɔ agɛ awu ungamɔ ru umbɔ awuri ikorhe akɛrɛ ha. ");
INSERT INTO ldb_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ikɛi uning usomgbɔ ru umbɔ agɛ awu ungamɔ awuri iwu uwuku ugɔngmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Uyesu agɔr umbɔ agɛ, <<Ayɛrhe atsen abi Uyahuda aka isaka adɛyiwe iyɛrhe ra anermbɔ. Anggbaashimbɔ ikɛi aka isaka ayisa atsimbɔ ugɛ umbɔ awu <abika ayike anermbɔ.> ");
INSERT INTO ldb_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bɔr umbi, ishingge rimi. Uwuku ugɔnga ru umbi unga awu uwɛkucia, uyɛrhe ikɛi awu ufang unga awe ugãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Awu ungamɔ awu uwuku ugɔnga, uwuku usei na agha use ugãrhã? Asi iwea uwuku usei na agha? Bɔr umum uwe ru umbi ru nyaku ugãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Awu umbi adɛ̃ɛ̃ nggu umum ri kishoo ivang iyiki ivarha arherhamum. ");
INSERT INTO ldb_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Umum itsima umbi iyɛrhe, ru nyaku Utɛmum aka atsima umum iyɛrhe. ");
INSERT INTO ldb_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ngge itsú umbi ama agha na ahwa nggu umum nú uteburmum, ri Iyɛrhamum, na asei ra anang isei Iyɛrhamum na avarhuwe arherhe anang usɔkdũmɛn aki Uisrairha. ");
INSERT INTO ldb_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","<<A Usiman, a Usiman, Ushaitan aka arhusa abee itsitsɛka umbi ru nyaka umbɔ iki itsɛki itsem. ");
INSERT INTO ldb_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bɔr umum iki ifɛn-Num ru ungo Usiman ugɛ, imangmango niba igbangge. Ri ivangyɛ ungo iki idzipa, ungo ufituwe angwɛ̃mbi.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bɔr unga agɔr agɛ, <<A Uteijee, umum iwuri izĩ ugborzĩ nggu ungo ni ikpe nggu ungo.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Uyesu agɔr unga agɛ, <<Umum idɛyiwa ungo Ubitru, ungo uwuri itsɛyingo ihwɛng umum idiki itaar irherɛ ni ikɔ idɔrhi igbɛr ukpee.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mɔcɛ Uyesu arhusa umbɔ agɛ, <<Ivangyɛ umum iki idena umbi adzek, umbi asi inyãngumbi imang, ukpoka, nu abadak, umbi asheru use?>> Umbɔ agɛ, <<Ubin shikpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Unga agɔr umbɔ agɛ, <<Bɔr icɛrɛ ungo uba uweɔ ru ukpoki imang, unyanga nu ibɛi ikɛi, ungo uba ushiɔ ri ikon ikider, ugoshe atorhango nu ugoi unying. ");
INSERT INTO ldb_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Itsɛng Arherhu-Num hã iki igɔr ugɛ, <Avarha unga ra abi uvau,> awu ufang ngge itsuifɛr ri itsimum. Ĩĩ, ubinkpi umbɔ aka atsɛng ri itsimum, awu ufang ngge itsuifɛr.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Angwɛ̃ imesanga agɛ, <<A Uteijee, unyã akon aka aderkɛ avaa.>> Unga agɔr umbɔ agɛ, <<Awu mɔnɔ.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Uyesu adzek azĩ afũã Igũ Acucii Uzaitun ru nyaka unga aka abayi, angwɛ̃ imesanga asok adɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Unga aka azĩ atsĩ ra anang hã, unga agɔr umbɔ agɛ, <<Àka afɛn-Num, utsur umbi agbambi ru undeya.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Unga abɔre umbɔ na agɔpa azĩa anang aka ader ru nyaki itang utarh. Unga atararhu na afɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Agɛ, <<A Utɛ, ungo uba ubeengo, ungo uma unyanguwa ayetnum akɛrɛ. Rimi hã, asi iwea ibibeea umum bɔr ibibeea ungo ikorhe.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nu ipfu itser-Num idzeka afã akapɛng ru unga ifituwe unga. ");
INSERT INTO ldb_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Awu ru uver akarhãrhã, na amina asunga na afɛn-Num. Izipunga idzek irhong nu abĩ ru nyaka adzirh. ");
INSERT INTO ldb_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Unga aka amaa ifɛn-Num na azĩ ra angwɛ̃ imesanga, unga akpo umbɔ awu ru urhɔ, azhe ida amɛn. ");
INSERT INTO ldb_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Unga arhusa umbɔ agɛ, <<Awu use utsu umbi arharhɔ? Àka asisok afɛn-Num utsur umbi agbambi ru undeya.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Anasi ibvura angwĩnga, ikikɔng anera iba, nu uner ha umbɔ iki iyisa Uyahuda, unying ru umbɔ usɔkdũmɛn hã, agbaashia ru umbɔ adɔsa. Unga aba awumu Uyesu na ashor atamnga. ");
INSERT INTO ldb_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bɔr Uyesu arhusa unga agɛ, <<A Uyahuda, ungo uwuri ighadak Ungwɛ̃-Ner nggu ishor atam?>> ");
INSERT INTO ldb_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ivangyɛ abika adɔsu Uyesu aka anyã ifɛrhɛ ha iki iwuri ikikorhe, umbɔ agɛ, <<A Uteijee, umɛn ikũ akon aka adermɛn ingbɛya umbɔ?>> ");
INSERT INTO ldb_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Unying ru umbɔ atsũ ikon iyiki idernga agbɛr ugãrhũ Ukugɔng Uwuku Udzowe Idɛm-Num, azharhuwe uto ubok ughanga. ");
INSERT INTO ldb_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bɔr Uyesu agɛ, <<Ĩ'ĩ àka aneke umbɔ rimi!>> Na abangu uto ugãrhã hã akerhuwe ukpɔ. ");
INSERT INTO ldb_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mɔcɛ Uyesu agɔr ateiya abika adzowe idɛm-Num, nu anggbaashi abika adzɛu Iya-Num, nu akakũ aka aba ru unga agɛ, <<Umbi adzeka nggu akon aka ader nu igbong ugɛɛ umbi aba idzur uvɛu? ");
INSERT INTO ldb_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ubɛn unuma umum iwu nggu umbi ru ufɔm Iya-Num, umbi asi iberu ubokmbi adzurmbi umum. Bɔr awu ivangmbi riyɛ ri iyɛrhe uzĩ.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Mɔcɛ umbɔ adzur unga, akũna unga azĩmbɔ ri iya Ukugɔng Uwuku Udzowe Idɛm-Num. Ubitru azɛ̃rhã uku ukaa adɔsa umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Bɔr umbɔ aka atai urha ra ateu ufɔm iya na akana asei umɔ, Ubitru asei nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Una igãrhã nuwɔ asei umɔ akhapa ru irhirhang urha, arhi Ubitru, na agɛ, <<Uner uwurɛ awu nggu unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bɔr unga atsɛyi agɛ, <<A una hã, umum isi ihwɛng unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ivanga ukunjiir iki itɔng, utsa uwɔɔ ikɛi anyã unga na agɛ, <<Ungo igango uwu nggu umbɔ.>> Ubitru agɛ, <<A utsak ha, umum isi iwumum nggu umbɔ!>> ");
INSERT INTO ldb_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ukara unying uba utɔng, utsa uwɔɔ ikɛi agɔr agɛ, <<Asi iwea ubin itsɛi, utsak uwurɛ awu nggu unga, ubinkutsu awu utsa Ugarhirhi.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ubitru agɛ, <<A utsa ha, umum isi ihwɛng ubinkpi ungo uku urherhe.>> Unga ana awu ra arherhe nu ikɔ igbɛrngge ukpee. ");
INSERT INTO ldb_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Uteijee adzipa arhi Ubitru. Mɔcɛ Ubitru ayitu urhɛm Uteijee aka arherhe nggu unga agɛ, <<Ungo uwuri itsɛyingo ihwɛng umum idiki itaar, ni ikɔ idɔrhi igbɛr ukpee irherɛ.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Unga asok adzek ra awiya na aciu na adɔng akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Abirabɛ aka akpɔm Uyesu ayɛia unga na akwɛr unga. ");
INSERT INTO ldb_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Akũ atorho abope asunga na arhusa unga agɛ, <<Usɔm Arherhu-Num! Ungamɔ akwɛr ungo?>> ");
INSERT INTO ldb_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Arherhi irhɛm iyiki itãrhã irhɛirhɛ arhena unga. ");
INSERT INTO ldb_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ukpee uku usar, ikikɔng akakũ abi Uyahuda, nu ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem akɔng nu umbɔ akũ Uyesu azĩ ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Umbɔ arhusa unga agɛ, <<Ungo uba uwu Ukiristo, usɔma umɛn.>> Uyesu adzipa agɔr agɛ, <<Umum iba isɔma umbi, umbi asi íwembi ri imangmang ru umum. ");
INSERT INTO ldb_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Umum ĩba irhusa umbi, umbi asi ídzipumbi urhɛm. ");
INSERT INTO ldb_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bɔr udzur icɛrɛ uzĩ, Ungwɛ̃-Ner awuri isei ru ubok ugha Unum uwu ukugɔng.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Umbɔ kishoo arhusa agɛ, <<Ungo uwu Ungwɛ̃ Unum?>> Unga adzipa agɔr agɛ, <<Awu umbi arherhe.>> ");
INSERT INTO ldb_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mɔcɛ umbɔ agɛ, <<Umɛn ibee ideka iyikisong ikɛi? Umɛn iki igũmɛn ra angwĩnga.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mɔcɛ umbɔ kishoo asok akũna unga azĩmbɔ ru Ubirhatu. ");
INSERT INTO ldb_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Atirhi irhena unga agɛ, <<Umɛn inyã utsak uwurɛ adɛ̃ɛ̃ idzunuwe abimɛn. Unga agɔr agɛ anera niba afaimbɔ ikirbi abĩ ru Ukaisar, anu igɔr agɛ, unga uwu Ukiristo, uyɛrhe.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nggee Ubirhatu arhusu Uyesu agɛ, <<Awu ungo uwu uyɛrha abi Uyahuda?>> Uyesu adzipa agɔr agɛ, <<Ĩĩ, iwu ru nyaka ha ungo uku urherhe.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Mɔcɛ Ubirhatu agɔr ateiya abika adzowe idɛm-Num nu arhɛrha anera kishoo agɛ, <<Umum isi ikpomum ubin uvau ru utsak uwurɛ.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Umbɔ ana angipa unga agɛ, <<Unga asoyiwe amɛn anera nggu imesanga ru Uyahudiya kishoo. Atirhi ru Ugarhirhi na aba atsĩã nggimi.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ubirhatu aka agũ rimi, unga arhusa agɛ use awu utsa Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Unga aka agũ agɛ Uyesu awu ri ijee iyɛrhe Uhiridu, unga adene umbɔ akũna unga azĩmbɔ ru Uhiridu, aka awu ru Urusharhima ri ivang hã. ");
INSERT INTO ldb_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Uhiridu aka anyã Uyesu, unga agɔm akarhãrhã, ubinkutsu aka adãrhũnga unga aka abee inyã unga. Unga aka agũã isarhanga, unga abee inyã abin idzeukɛ Uyesu aka ikorhe ra asunga. ");
INSERT INTO ldb_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Unga arhusa unga arherhe arhɛrhɛ, bɔr unga asi idzipunga urhɛm. ");
INSERT INTO ldb_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ateiya abika adzowe idɛm-Num nu abika amesuwe Ikpem adɛ̃ɛ̃ atsuyi arherhe uvau akeketake nu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Mɔcɛ Uhiridu nggu abi iwanga anyã Uyesu uku ukwɛɛr na ayɛia unga. Atsime unga atorho iyɛrhe, na adene umbɔ akũna unga azĩmbɔ nu Ubirhatu ikɛi. ");
INSERT INTO ldb_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ru unum hã umbɔ Uhiridu nggu Ubirhatu aka awu awɛrhɛ adɔka. Rimɔ̃ɔ̃ umbɔ awe ru igamtsak. ");
INSERT INTO ldb_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ubirhatu ayisa ateiya abika adzowe idɛm-Num, nu anggbaashi anera nu anera kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Agɔr umbɔ agɛ, <<Umbi akũ utsak uwurɛ aba agɛ unga anu idzunuwe anera. Umum irhusa unga ra asumbi isi ikpomum uvau ru unga ru arherhambi aka akũ aba ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Uhiridu ikɛi asi ikpoa uvau ru unga, unga abvui adene unga aba ru umɛn. Umbi anyãmbi, unga asi ikorhunga ubin ukpuku utsu ufai akpe. ");
INSERT INTO ldb_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nggee, umum ikwɛre unga ugwɛɛ ni itsũwe unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nggu urhɛma unying umbɔ atsu ivum, anu igɔr agɛ, <<Àka afɛre utsak uwurɛ, nu atsũwã umɛn Ubaraba.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ubinkpi uku utsu umbɔ atsuke Ubaraba ru ugborzĩ, unga atsu abika abee itsũwe iyɛrha abĩã afɛre anera. ");
INSERT INTO ldb_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ubirhatu abee itsũwe Uyesu, nggee unga ashɔ̃rhã umbɔ ikɛi. ");
INSERT INTO ldb_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bɔr umbɔ abvui atsu ivum agɛ, <<Anyapuwe unga! Anyapuwe unga!>> ");
INSERT INTO ldb_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Unga abvui arherhe ide untaar agɛ, <<Awu use utsu? Akorhu use iyiki ibewe? Umum isi inyãmum uvau akpe ru unga. Nggee umum iwuri ikwɛre unga ugwɛɛ ni itsũwe unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bɔr umbɔ atsarhi irhakmbɔ angipa abee umbɔ anyapuwe Uyesu nu igãrhãmau ucucii, ivummbɔ itsu ngge iwe rimi. ");
INSERT INTO ldb_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Nggee Ubirhatu atsukuka ufai akpe ru Uyesu ubinkpi umbɔ aka abee. ");
INSERT INTO ldb_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Unga atsũwũka uner ha umbɔ aka arhusa, na adzowe Uyesu umbɔ akorhu ubinkpi umbɔ aka abee. ");
INSERT INTO ldb_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Abi iwa aka akũ Uyesu adzek, umbɔ adzur Usiman utsa Usayirin aka adzeku usi atsĩwã ru utepa, umbɔ atsu unga atsã igãrhãmau ucucii ha adɔsu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Arhɛrha anera adɔsa unga, nu akatsɛrh abɔɔ atsorha abok nu atsimbɔ aciu akpenga. ");
INSERT INTO ldb_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bɔr Uyesu adzipa agɔr umbɔ agɛ, <<Umbi ana Urusharhima, àka aneke iciupa umum akpe. Àka aciu akpe atsimbi nggu awɛkacimbi. ");
INSERT INTO ldb_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ubinkutsu ivanga niyɔ ibarɔ umbɔ aka igɔr agɛ, <Idorh iwe nggu akatsɛrh abirabɛ aka awu akpirh, abirabɛ aka anasi imarmbɔ imar, nu abirabɛ umbɔ aka anasi iyammbɔ abɛ̃mbɔ!> ");
INSERT INTO ldb_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mɔcɛ << <umbɔ awuri igɔr ígũ agɛ, <<Àka agba nú umɛn!>> Ikɛi na agɔr ampfũwã akagɔng agɛ, <<Àka atsire umɛn!>> > ");
INSERT INTO ldb_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Anera aba akorhe rimi ri ivangyɛ ucucii ha aka ana awu uku usum, awuri ikorha aguse ri ivangyɛ ngge iki ikoyi?>> ");
INSERT INTO ldb_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Abɔɔ inera ivaa awu avɛu, akũ umbɔ azĩ ifɛre nggu unga. ");
INSERT INTO ldb_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Umbɔ aka azĩ atsĩ ra anang hã umbɔ iki iyisa agɛ, <<Upfupfu Itsia.>> Umɔ umbɔ aka anyapuwe unga nu igãrhãmau ucucii nggu avɛu ha, unying ru ubok ugha, unying ru ubok ufer. ");
INSERT INTO ldb_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Uyesu agɛ, <<A Utɛ, utsũwe umbɔ amɔrmbɔ ubinkpi umbɔ aka akorhe.>> Umbɔ agasha atorhanga nggu itang isɛng. ");
INSERT INTO ldb_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Anera adesa na azɛrhe, anggbaashi acata unga agɛ, <<Unga afɔrhuka abɔɔ, uneke unga afɔrhe itsinga unga aba awu Ukiristo, uwuruwi Unum aka asɛng!>> ");
INSERT INTO ldb_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abi iwa agɔpa afũ ayɛia unga ikɛi. Azĩ adzowe amɛ̃ inebi akika agbata. ");
INSERT INTO ldb_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Umbɔ agɛ, <<Ungo uba uwu uyɛrha abi Uyahuda, ufɔrh itsikamngo!>> ");
INSERT INTO ldb_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Afafã itsinga umbɔ atsɛng itsɛng agɛ, <<UWƐRƐ AWU UYƐRHA ABI UYAHUDA.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Unying ru umbɔ avɛu ha umbɔ aka anyapuwe arherhe arherhe aka atãrhã agɛ, <<Asi iwea ungo uwu Ukiristo? Ufɔrh itsingo nggu umɛn!>> ");
INSERT INTO ldb_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bɔr uvɛu uwu uvaa atsɛrha unga agɛ, <<Hɛ, ungo usi igũo iwei Unum, ufaingo uku uwu ubina unying nggu unga? ");
INSERT INTO ldb_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Umɛn ihwa uvermɛn mɔnɔ, umɛn ifai ubinkpi umɛn iki ikorhe. Bɔr utsak uwurɛ ashia ru uvau.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Mɔcɛ unga agɛ, <<Uyesu, uyita umum ri ivang Iyɛrhango.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Uyesu agɔr unga agɛ, <<Umum indɛyiwa ungo idzidzɛrhe, irherɛ ungo uwuri iwu nggu umum ra afã.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Awu idzingga atenuma, uzĩ udze utsire ananga kishoo utsɛku akara ataar aki urhɛɛ, ");
INSERT INTO ldb_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ishaa unum isi irhangngge. Nu urhaburhe ukpuku uwe ri Iya-Num uvaar agbɛra avaa. ");
INSERT INTO ldb_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Uyesu atsarhi irhaknga akarhãrhã ayisa agɛ, <<A Utɛ, umum itsuka ipfumum ru ubokngo.>> Unga aka arherhe rimi amaa, unga akpea. ");
INSERT INTO ldb_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Uteiya abi iwa ha aka anyã ifɛrhɛ ha iki ikorhe, unga akpoi Unum agɔr agɛ, <<Awu idzidzɛrhe utsak uwurɛ arhiku uner.>> ");
INSERT INTO ldb_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ri ivang hã umbɔ kishoo aka akɔng umɔ ra anang hã, anyãmbɔ ifɛrhɛ ha iki ikorhe, umbɔ akwɛr ikɔkmbɔ na azĩmbɔ akimbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Bɔr kishoo abika ahwɛng unga, utoma nggu akatsɛrh abirabɛ aka adɔsa unga adzeka abĩ Ugarhirhi, adɛ̃ɛ̃ ukuka, na azɛrhi ifɛrha ha. ");
INSERT INTO ldb_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Unera nuwɔ itsoknga igburh Uyusuf, unying ru umbɔ akakũ abi Uyahuda, bɔr awu ra amɛn na arhiku uner, ");
INSERT INTO ldb_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","unga asi ibemunga ubinkpi abimbɔ aki ikorhe. Unga adzeka abĩ Uyahuda, uteu Uarimatiya, na adzɛu Iyɛrhe Unum. ");
INSERT INTO ldb_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Unga asok azĩã ru Ubirhatu arhusa umbɔ adzowe ukom Uyesu. ");
INSERT INTO ldb_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mɔcɛ unga acipuwe ukom hã, na akũ atorho aka aze abɛrh ukpɔ, na atsuke ukpɔ ru udzak. Udzak ha uwe ru utai umbɔ aka asim ni ifa, ukpurukpi umbɔ aka anasi itsumbɔ unera umɔ. ");
INSERT INTO ldb_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Unum hã uwu unum igbisha abin, unum ukpuku uwosha uku uyokpɔ. ");
INSERT INTO ldb_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akatsɛrh ha aka adzeka abĩ Ugarhirhi adɔsu Uyesu, asok adɔsu Uyusuf azĩ anyã udzaka na anyã ininu ukom iyornga uku unu umɔ. ");
INSERT INTO ldb_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mɔcɛ umbɔ abvui azĩmbɔ ri iya azĩ agbisha atsei isung na atsei akika adzuka. Ru unum ukpuku uwoshambɔ, umbɔ awosha ri ikpem. ");
INSERT INTO ldb_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ru unum inggbaashia ri inuma utɔɔva, ri igɔ̃kpeka, akatsɛrh ha anyanga abinkɛ umbɔ aka agbisha azĩmbɔ ru udzaka. ");
INSERT INTO ldb_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Umbɔ akpo utarh ukpuku utsim ru udzaka uku ugɔ̃rhũkpɔ. ");
INSERT INTO ldb_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Bɔr umbɔ aka atsĩ, umbɔ asi inyãmbɔ ukom Uteijee Uyesu. ");
INSERT INTO ldb_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Umbɔ ana awe ri idzeu ifɛrhɛ ha, kanying inera ivaa idɛ̃ɛ̃ ikhapa ru umbɔ, itsim atorho aka aterha ake arhang ru nyaki ishaa unum. ");
INSERT INTO ldb_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Akatsɛrh ha agũ iwei na asũrhã atsimbɔ ra abĩ, aner ha agɔr umbɔ agɛ, <<Awu use utsu umbi abee uner urhɛ ra abika akpukpe? ");
INSERT INTO ldb_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Unga ashia nggimi, unga aka asoka! Aka ayitu ubinkpi unga aka adɛyiwa umbi, unga aka awu nggu umbi ru Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Agɛ awu ufang umbɔ aka idzowe Ungwɛ̃-Ner ra abi arhim, umbɔ anyapuwe unga nu igãrhãmau ucucii, ru unum untaar unga awuri isoka ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mɔcɛ umbɔ ayitu irhɛmnga. ");
INSERT INTO ldb_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ivangyɛ umbɔ aka apfuri ra anang udzaka abambɔ asɔme abɔrɔ udom hã (11), angwɛ̃ imesanga, nu irhɛ abɔɔ ifɛrha ha. ");
INSERT INTO ldb_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Awu umbɔ Umaryamu Umagadarha, nggu Uyowana, nu Umaryamu uyisa Uyaku, nu akatsɛrh abɔɔ aka awu nggu umbɔ, umbɔ asɔme abi itser Uyesu ifɛrha ha. ");
INSERT INTO ldb_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Bɔr umbɔ asi ibemumbɔ idzidzɛrhe akatsɛrh ha, ubinkutsu umbɔ anyanga arherhe ha awu isheri itsi. ");
INSERT INTO ldb_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bɔr Ubitru asok atĩ azĩã ru udzaka, agba apfu, na anyã atorho ukpekũ, na abvui azĩã adzeidzeu ifɛrha ha iki iwe. ");
INSERT INTO ldb_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ru unum hã ikɛi inera ivaa abika adɔsu Uyesu aka azɛ̃rhã awuri izĩ ungwɛ̃rhũ uteu ukpɔɔ ugburh Uimawu. Iderkpɔ iyongge akirhomita usɔka nu unying uzĩ Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Umbɔ anu irherhe nggu adɔka ru ubɛn ubinkpi uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Umbɔ aka adɛ̃ɛ̃ irherha arherhe ifɛrhɛ ha nggu adɔkambɔ, Uyesu nibikanga adzeka aba azɛ̃rhã nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bɔr Uyesu asi ibeenga umbɔ ahwɛng ugɛ awu unga. ");
INSERT INTO ldb_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Unga arhusa umbɔ agɛ, <<Umbi azɛ̃rhã na ani irherhu use ikivarhambi?>> Umbɔ atsurha adɛ̃ɛ̃, unyɛ̃ɛ̃mbɔ ughɔrhe. ");
INSERT INTO ldb_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unying itsoka igburh Ukirhiyoba, arhusa unga agɛ, <<Awu ungo ikiyikango uwu utsen ru Urusharhima ungo uku usi ihwɛngngo ifɛrha ha iki ikorhe umɔ inum iyɛrɛ?>> ");
INSERT INTO ldb_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Unga arhusa umbɔ agɛ, <<Ifɛrhu use?>> Umbɔ agɛ, <<Arherhu Uyesu uner Unazarat, uner uwuku usɔm Arherhu-Num, uner ijee ra arherhe nu ikikorhe ra asu Unum na anera kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ikɛi ateiya abika adzowe idɛm-Num nu anggbaashi abɔɔ aka adzowe unga ra abi ijee Uroma, umbɔ atsuke unga ufai akpe, na anyapuwe unga nu igãrhãmau ucucii. ");
INSERT INTO ldb_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Bɔr umɛn ifosa ugɛ unga awuri ifai Uisrairha. Utoma rimi, ifɛrha ha iki ikorhe kishoo unum untaar nukpi. ");
INSERT INTO ldb_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Utoma rimi, akatsɛrhmɛn abɔɔ adzaa umɛn idzeu. Umbɔ azĩmbɔ ru udzaka ri igɔ̃ ukpea ukpirɛ, ");
INSERT INTO ldb_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bɔr umbɔ asi ikpombɔ ukom iyornga. Umbɔ asok aba agɔr umɛn ugɛ umbɔ anyãmbɔ irhi, ípfu itser-Num igɔr umbɔ igɛ awu nggu urhɛ. ");
INSERT INTO ldb_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Mɔcɛ abimɛn abɔɔ asok azĩmbɔ ru udzaka azĩ anyã rimi hã ru nyaka akatsɛrh ha aka arherhe, bɔr umbɔ asi inyãmbɔ unga.>> ");
INSERT INTO ldb_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Unga agɔr umbɔ agɛ, <<Umbi adzunu use umbi rimi, amɛnmbi adɔ̃rhũ use rimi, ri iwe ru imangmang abinkɛ kishoo abika asɔm Arherhu-Num aka arherhe! ");
INSERT INTO ldb_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Asi iwea ufang Ukiristo aka ihwa ayetnum ri ifɛrha ha na atsĩ ri ikpikpoinga?>> ");
INSERT INTO ldb_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Na atirhi ru imesu Umusa nu iyi abika asɔm Arherhu-Num kishoo, asɔme umbɔ arherhe akirakɛ aka awe ri itsinga ri itsɛng Arherhu-Num kishoo. ");
INSERT INTO ldb_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Umbɔ aka ayoku ungwɛ̃rhũ uteu ha umbɔ aka izĩ, unga akorhe ugɛɛ unga awuri itɔng. ");
INSERT INTO ldb_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Umbɔ angipa unga agɔr agɛ, <<Usei nggu umɛn, unuma aka amaanga.>> Nggee unga azĩ asesa nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ivangyɛ unga aka asei igha ubingha nggu umbɔ, unga anyangu uborodi, atar uwɛɛ adzowe Unum, na atsɔka adzowe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mɔcɛ asumbɔ ayanga, umbɔ ahwɛng unga ikɛi, nu unga agwira ri inyĩnyãmbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Umbɔ arhusa adɔkambɔ agɛ, <<Anggɔm asi itsu amɛnmɛn ayiruke ri ivangyɛ unga aka arherhe arherhe nggu umɛn ru utsĩndĩ na amesuwa umɛn itsɛng Arherhu-Num?>> ");
INSERT INTO ldb_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kanying umbɔ asok azĩmbɔ Urusharhima, umbɔ azĩ akpo abɔrɔ udom hã (11) ananga unying na abirabɛ aka awu nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Anu igɔr agɛ, <<Awu idzidzɛrhe! Uteijee aka asoka, adzekanga ru Usiman!>> ");
INSERT INTO ldb_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mɔcɛ umbɔ ikivarhambɔ adzowe isarhe ubinkpi uku ukorhe ru utsĩndĩ, ru nyaka umbɔ aka ahwɛng Uyesu ri itsɔku uborodi. ");
INSERT INTO ldb_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ivangyɛ umbɔ aka adɛ̃ɛ̃ irherha arherhe ifɛrha ha, akpurha anyã Uyesu akapɛng adɛ̃ɛ̃ ra ateumbɔ, na agɔr umbɔ agɛ, <<Ididɔɔr iwe nggu umbi.>> ");
INSERT INTO ldb_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bɔr umbɔ agbipa iwei ifɛr umbɔ, umbɔ akaifɛrhkɔ agɛ umbɔ anyã imãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Unga agɔr umbɔ agɛ, <<Awu use utsu umbi agũ iwei, awu use umbi anu icang ikɛi ra amɛnmbi? ");
INSERT INTO ldb_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Àka arhi abokmum, nu adakmum. Awu umum nibikami! Àka abanga umum agũ. Imãrhã ishingge ri ijuɛ nggu apfupfu ru nyaka umbi aka agũ ru umum.>> ");
INSERT INTO ldb_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ivangyɛ unga aka arherhe rimi, unga adɛyiwe umbɔ aboknga nu adaknga. ");
INSERT INTO ldb_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Bɔr umbɔ ana acang ra amɛnmbɔ, ri itsi anggɔm nu idzeu akarhãrhã, unga arhusa umbɔ agɛ, <<Umbi awembi ru ubingha ri nggimi?>> ");
INSERT INTO ldb_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Umbɔ adzowe unga awushu ubɛrh uwuku uvum. ");
INSERT INTO ldb_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Unga ayɛi atãi ra asumbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Unga agɔr umbɔ agɛ, <<Arherhamum ha rakɛ, umum iki idɛyiwa umbi rimɔ̃ɔ̃ umum iki iwu nggu umbi. Ugɛ awu ufang abina kishoo aka itsuafɛr ri itsimum umbɔ aka atsɛng ri Íkpem Umusa, nu abvur abika asɔm Arherhu-Num, nu Ambom.>> ");
INSERT INTO ldb_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mɔcɛ unga ayanguwe amɛnmbɔ umbɔ ahwɛng itsɛng Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Unga agɔr umbɔ agɛ, <<Itsɛng hã iyɛ iki itsɛng igɛ awu ufang Ukiristo aka ihwa ayetnum na asoka ra akpe ru unum untaar. ");
INSERT INTO ldb_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ni igɛ idzidzipa nu itsũwe arhim awuri idzowe isarhangge ri itsoknga, ra abĩã kishoo, awuri itirhi ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Awu umbi awuri idekuwe anera ifɛrha iyɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Umum iwuri idenukũ ubinkpi Utɛmum aka abemuwa, bɔr aka adãrhã ru utepa utsɛku umbi aka iyɛi ijee iyiki idzeka afã.>> ");
INSERT INTO ldb_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ivangyɛ unga aka akũna umbɔ adzek azĩ akhapa ru Ubetani, unga abera aboka atsuke idorh ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Unga aka adɛ̃ɛ̃ itsuke umbɔ idorh, umɔ unga abɔruka umbɔ, ashupa unga afũmbɔ ra afã. ");
INSERT INTO ldb_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mɔcɛ umbɔ adzowe unga igɔng na apfuri azĩmbɔ Urusharhima nggu anggɔm akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ubɛn unuma ikɛi umbɔ akɔng ru ufɔm Iya-Num anu ikpoi Unum.");
INSERT INTO ldb_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ri inggbaashia Urhɛm uwekpɔ, Urhɛm hã uwu nggu Unum, urhɛm hã uwu Unum. ");
INSERT INTO ldb_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Unga awu nggu Unum ri inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Awu ru uboknga umbɔ aka amuna abina kishoo. Agɛ unga ashia, ubin usi ímunukpɔ ra abin hã umbɔ aka amuna. ");
INSERT INTO ldb_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ru unga urhɛ uwemgbɔ, urhɛ ha awu irhirhang ra anera kishoo. ");
INSERT INTO ldb_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Irhirhang hã irhang ru uzĩ, bɔr uzĩ hã usi ihwɛngkpɔ ngge. ");
INSERT INTO ldb_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Unera nuwɔ Unum aka adene unga aba. Itsoknga igburh Uyohana. ");
INSERT INTO ldb_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Unga aba awu ideka ri irhirhang hã, nggee ru uboknga anera kishoo ama awe ru imangmang. ");
INSERT INTO ldb_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Unga asi iwea irhirhang hã. Unga aba awu ideka irhirhang hã ukpekũ. ");
INSERT INTO ldb_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Uwu ha aka awe irhirhang iyi idzidzɛrhe aka abanga ru upfung. Unga aka idzowe irhirhang ru anera kishoo ru upfung. ");
INSERT INTO ldb_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Urhɛm hã uwe ru upfung. Upfunga umuna ru uboknga, bɔr upfung hã usi ihwɛngkpɔ unga. ");
INSERT INTO ldb_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Unga aba ru upfungkpi uku uwe ukpunga, bɔr anernga asi iyɛimbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Rimi hã kishoo abika ayɛi unga, nu abika adzowe imangmang ri itsoknga, unga adzowuka umbɔ ijee umbɔ awe angwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Awu Unum abema ngge iwe rimi ngge itsu umbɔ awu angwɛ̃nga, asi iwea imar iyi anera, use ikponi iyor, use isisɛng anera itsu umbɔ awu angwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Urhɛm hã uwu unera nu usei nggu umɛn. Umɛn inyãmɛn igɔngnga, igɔngyɛ iki iwu iyi unanyĩ Ungwɛ̃wi aka adzeku Utɛ. Awu nggu imimuta nu idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Uyohana adzowuka ideka ri itsinga. Atsarhi irhaknga agɛ, <<Uwɛrɛ awu unga hã umum iki irherha arherhe ri itsinga ri ivangyɛ umum iki ĩgɔr ugɛ, <Uwuruwi aka iba ru undzingmum ananga umum, ubinkutsu awea umbɔ adɔrha amar umum.> >> ");
INSERT INTO ldb_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Umɛn kishoo iyɛi idorh irhɛirhɛ iki idzeku imimutanga. ");
INSERT INTO ldb_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Adzaa Íkpem ru ubok Umusa, bɔr imimuta nu idzidzɛrhe idzeku ubok Uyesu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Unera anasi inyãã Unum, bɔr unanyi Ungwɛ̃nga adɛyiwa umɛn iwiwe Unum. Unanyi Ungwɛ̃ hã akhapa nggu Unum Utɛ, unga itsikamnga awu Unum. ");
INSERT INTO ldb_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ideka Uyohana iyɛ, ri ivangyɛ abi ijee Uyahuda ru Urusharhima adene abika adzowe idɛm-Num abɔɔ nu abi Urhawi ru Uyohana arhusa unga agɛ, <<Ungo uwu ungamɔ?>> ");
INSERT INTO ldb_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Uyohana adekuwe umbɔ ra awiya agɛ, <<Asi iwea umum iwu Ukiristo.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Umbɔ arhusa unga agɛ, <<Ungo uwu ungamɔ? Awu ungo uwu Uirhiya?>> Unga agɛ, <<Ĩ'ĩ.>> Umbɔ arhusa ikɛi agɛ, <<Awu ungo uwu uner uwuku usɔm Arherhu-Num hã Umusa aka arherhe ugɛ ibanga?>> Unga agɛ, <<Ĩ'ĩ.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Umbɔ agɔr unga agɛ, <<Ude ungo uwu ungamɔ? Udɛyiwa ubinkpi umɛn iki izĩ idɛyiwe abika adena umɛn. Ungo udɛyiwa umɛn use ri itsingo?>> ");
INSERT INTO ldb_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Uyohana akũ arherhe uner uwuku usɔm Arherhu-Num Uishaya agɔr umbɔ agɛ, <<Awu umum iwu urhɛmkpi uku idũwã ra arhum ugɛ, <Àka agbishu utsĩndĩ Uteijee uku urhirhiki.> >> ");
INSERT INTO ldb_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mɔcɛ abi Ufarisi ha umbɔ aka adene, ");
INSERT INTO ldb_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","arhusu Uyohana agɛ, <<Awu use utsu ungo usorhuwe ubɔtisima uba ungo usi iweɔ Ukiristo, ikɛi ungo usi iweɔ Uirhiya, ikɛi ungo usi iweɔ uwuku usɔm Arherhu-Num hã Umusa aka arherhe ugɛ ibanga?>> ");
INSERT INTO ldb_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Uyohana agɔr umbɔ agɛ, <<Umum isorhuwe ubɔtisima nggu amɛ̃, bɔr uwɔɔ ruwɔ ru umbi, uwuruwi umbi aka asi ihwɛngmbi unga. ");
INSERT INTO ldb_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Unga awuri iba ru undzingmum, uwuruwi umum isi ímɛ̃mum igarhuwe arhi abadaknga.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Kishoo akɛrɛ ha akorhe ru Ubetani, ugar Azɛ̃ Urdun, anangkɛ Uyohana aki isorhuwe ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ukpe uku usar, Uyohana anyã Uyesu aka azɛ̃rhã aba ra anangnga, Uyohana agɛ, <<Àka anyã, Ungwɛ̃ Itsurhi Unum uwuruwi aka itsũwe arhim upfunga! ");
INSERT INTO ldb_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uwɛrɛ awu unga hã nuwi umum iki ĩgɔr ĩgɛ, <Uwɔɔ ruwɔ aba ru undzingmum ananga umum, ubinkutsu, unga aka awea umbɔ adɔrha amar umum.> ");
INSERT INTO ldb_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Umum isi ihwɛng unga, bɔr umum iki isorhu ubɔtisima nggu amɛ̃ ngge ítsu abi Uisrairha ama ahwɛng unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mɔcɛ Uyohana adzowe ideka iyɛrɛ agɛ, <<Umum inyã Ipfu-Num iki icipuwa ru nyaku unurhɛu ra afã, iba isei nu unga. ");
INSERT INTO ldb_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Umum isi ihwɛng unga, bɔr Unum uwuku udena umum ĩba isorhu ubɔtisima nggu amɛ̃, unga agɔr umum agɛ, <Utsakwi ungo uku unyã Ipfu-Num icipuwa iseingge nu unga, awu unga hã nuwɔ aka isorhuwe ubɔtisima nggu Ipfu Isarsatangge.> ");
INSERT INTO ldb_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Umum inyãmum ngge iki iwe rimi hã ni iwemum ri ideka ugɛ unga awu Ungwɛ̃ Unum.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ukpe uku usar ikɛi Uyohana adɛ̃ɛ̃ nggu angwɛ̃ imesanga avaa. ");
INSERT INTO ldb_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Unga aka anyã Uyesu aka azɛ̃rhã atɔng, unga agɛ, <<Àka anyã, Ungwɛ̃ Itsurhi Unum!>> ");
INSERT INTO ldb_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Angwɛ̃ imesa ha ikivarhambɔ aka agũ arherhe Uyohana, umbɔ adɔsu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Uyesu aka adzipa arhi undzingnga, anyã umbɔ aka adɔsa unga, unga arhusa umbɔ agɛ, <<Umbi abee use?>> Umbɔ agɛ, <<Rabbi, ungo usei ri inɛɛ?>> Agben <<Rabbi>> agburh <<A umarhem.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Uyesu agɔr umbɔ agɛ, <<Àka aba, umbi awuri inyãmbi.>> Nggee angwɛ̃ imesa ha azĩ anyã anangkɛ unga aka asei. Umbɔ atsĩ umɔ ra akara annaa aki urhɛɛ na asei nggu unga unum hã. ");
INSERT INTO ldb_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Uandarawu, ungwɛ̃mbɔ Usiman Ubitru, awu umɔ ri iner ha ikivarhangge iki igũ arherhe Uyohana ri itsi Uyesu ni idɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Uandarawu atirha abee ungwɛ̃mbɔ Usiman, agɔr unga agɛ, <<Umɛn iki ikpomɛn Uarhmasihu,>> agbena agburh <<Ukiristo.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Unga akũ Usiman azĩã ru Uyesu. Uyesu arhi unga na agɛ, <<Ungo uwu Usiman ungwɛ̃ Uyohana. Awuri iyisa ungo Ukefa,>> agbena aka agburh <<Ubitru.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ukpe uku usar ikɛi Uyesu abee izĩ Ugarhirhi. Unga akpo Ufirhibu, agɔr unga agɛ, <<Udɔsa umum.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ufirhibu awu uner Ubetsaida, uteumbɔ Uandarawu nu Ubitru. ");
INSERT INTO ldb_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ufirhibu akpo Unataniyerh, agɔr unga agɛ, <<Umɛn iki ikpomɛn uner ha umbɔ aka atsɛng isarhanga ru ubvur Íkpem Umusa nu abvur abika asɔm Arherhu-Num. Unga awu Uyesu uner Unazarat, ungwɛ̃ Uyusuf.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Unataniyerh arhusa agɛ, <<Ubin uku uze udɛ̃ɛ̃ udzekpɔ ru Unazarat?>> Ufirhibu agɛ, <<Uba unyã.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Uyesu aka anyã Unataniyerh aka aba ru unga, unga agɔr agɛ, <<Àka anyã uner Uisrairha uwu idzidzɛrhe, uwuruwi aka asi igbɛrangwĩ.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Unataniyerh arhusu Uyesu agɛ, <<Ungo ukorhu uguse nu uhwɛng umum?>> Uyesu agɛ, <<Umum inyãmum ungo ru usĩrhũ ucucii uvorhvo, nu Ufirhibu adɔrha ayisa ungo.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Mɔcɛ Unataniyerh agɔr Uyesu agɛ, <<A umarhem, ungo uwu Ungwɛ̃ Unum. Ungo uwu Uyɛrhe Uisrairha.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Uyesu agɔr Unataniyerh agɛ, <<Ubinkutsu ungo uwe ri imangmang, umum iki idɛyiwa ungo ugɛ umum inyãmum ungo ru usĩrhũ ucucii uvorhvo? Ungo uwuri inyinyãɔ abinkɛ aka anangke rimi.>> ");
INSERT INTO ldb_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Unga atoma adɛyiwe unga agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, umbi awuri inyãmbi afã aka iyanga, ípfu itser-Num ikɛi ifũrhã ni icipa ni itsi Ungwɛ̃-Ner.>> ");
INSERT INTO ldb_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ru unum ukpu untaar umbɔ awe ru irhowa ipfuna ru Ukana ukpu Ugarhirhi. Uya Uyesu awe umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aghwi Uyesu nu angwɛ̃ imesanga ri ipfuna hã. ");
INSERT INTO ldb_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ivangyɛ amɛ̃ inebi aka amaa, uya Uyesu agɔr unga agɛ, <<Amɛ̃ inebi aka amaake.>> ");
INSERT INTO ldb_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Uyesu agɔr unga agɛ, <<A uya, awu ufang asi iwea ungo udɛyiwa umum ubin ukpuku ukukorhe. Ivangmum inasi ibangge.>> ");
INSERT INTO ldb_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Uyanga agɔr abika atɔ̃ itser ri irhowa ha agɛ, <<Àka akorhe kishoo ubinkpi unga aka agɔr umbi ikikorhe.>> ");
INSERT INTO ldb_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ídzor niyɔ utɔ̃ĩ iyiriyɛ umbɔ aka akũ atarh adzin aden ra anang hã. Ubɛn idzora ighangge idzum amɛ̃ itɔ̃ɔ̃ use utɔ̃ĩ. Abi Uyahuda aka isaka akũ amɛ̃ asorh ayormbɔ iyi agbeyambɔ. ");
INSERT INTO ldb_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Uyesu agɔr abika atɔ̃ itser ri irhowa ha agɛ, <<Àka atsu amɛ̃ atɔk ídzor iyɛrɛ.>> Nggee umbɔ atsu amɛ̃ atɔke ídzor ha uku urhɛrhɛki. ");
INSERT INTO ldb_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Mɔcɛ unga agɔr umbɔ agɛ, <<Icɛrɛ àka ashɔyi, adzowe unggbaashi abika atɔ̃ itser irhowa ha.>> Umbɔ ashɔyi adzowe. ");
INSERT INTO ldb_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Utei irhowa ha avupa agũ ake aka adzipa awu amɛ̃ inebi. Unga asi ihwɛngnga anangkɛ ake aka adzek, bɔr abika ashɔyi adzowe ahwɛngmbɔ. Mɔcɛ unga ayisu utsa ipfuna hã ri ibanga, ");
INSERT INTO ldb_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","agɔr unga agɛ, <<Ubɛn unera aka isaka agbaashia adzowe amɛ̃ inebi aka azea na adɔrha akũ akirakɛ aka asi ikpanga azeke. Bɔr ungo uwɔkɔ amɛ̃ inebi aka azea nu udɔrhu ukũ icɛrɛ uba!>> ");
INSERT INTO ldb_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Akɛrɛ ha ake awu ubin idzeu nu utsar ukpu inggbaashia ukpu Uyesu aka akorhe. Akorha ake ru Ukana ukpu Ugarhirhi. Akɛrɛ adɛyiwe igɔngnga nu angwɛ̃ imesanga atsu imangmangmbɔ ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Akɛrɛ aka amaa Uyesu asok acipa azĩ Ukafanahum, unga nu uyanga nu angwɛ̃mbɔ nu angwɛ̃ imesanga. Nggɔɔ ha umbɔ asei inuma ukunjiir. ");
INSERT INTO ldb_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ivang Irhowa Iyiki Igar Utɔng iyi abi Uyahuda iki iyo, Uyesu azĩ Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ru ufɔm Iya-Num, unga anyã anera adɛ̃ɛ̃ igoyiwe ínak nu ídɔi nu anurhɛu. Ikɛi unga anyãã abika afaruwe uhwɛk asei umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nggee Uyesu akũ arhi awɛyi asharhe, akũ awayiwe kishoo anera nu ídɔi nu ínak ru ufɔm Iya-Num hã. Ikɛi unga ayii atebur iyi abika afaruwe uhwɛk ha, asituwe íshaa uhwɛkmbɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Mɔcɛ Uyesu agɔr anera abika agoyiwe anurhɛu ha agɛ, <<Àka akũ akɛrɛ apfu adzek nggimi! Niba adzipu iya Utɛmum iweke anang izɛɛ!>> ");
INSERT INTO ldb_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Angwɛ̃ imesanga ayitu ubinkpi uku utsɛng ra Arherhu-Num ugɛ, <<Ibibemayɛ umum iki iwurangge ri iyango iwuri ikpĩa umum ru nyaku urha.>> ");
INSERT INTO ldb_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mɔcɛ anggbaashi abi Uyahuda arhusu Uyesu agɛ, <<Utsar idzeu ukusong ungo iki idɛyiwa umɛn ugɛ ungo uweɔ ri ijeeyɛ iki itsu ungo ukorha akɛrɛ ha?>> ");
INSERT INTO ldb_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Uyesu agɔr umbɔ agɛ, <<Àka abupuwe Iya-Num ikɛrɛ, umum iwuri iberukũ ake ikɛi ri inuma itaar.>> ");
INSERT INTO ldb_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Abi Uyahuda agɔr unga agɛ, <<Anyanga amɛka isɔka inaa ni ímɛka utɔ̃ĩ adzin Iya-Num ikɛrɛ nu ungo ugɔr ugɛ ungo idzine ake ri inuma itaar?>> ");
INSERT INTO ldb_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bɔr iya-Numkɛ unga aka arherhe awu iyornga. ");
INSERT INTO ldb_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Uyesu aka asoka akpe, angwɛ̃ imesanga ayita arherhe ha Uyesu aka arherhe. Mɔcɛ umbɔ awe ru imangmang ri itsɛng Arherhu-Num nu arherhe Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ivang Uyesu aka awe ru Urusharhima ri Irhowa Iyiki Igar Utɔng, anera arhɛrhɛ aka anyã atsar abin idzeukɛ unga aka akorhe, umbɔ adzowe imangmang ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bɔr Uyesu ashia ri imangmang ru umbɔ, ubinkutsu unga ahwɛnga amɛn anera kishoo. ");
INSERT INTO ldb_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Unga asi ibeenga unera adɛyiwe unga ubin ri itsi anera ubinkutsu unga ahwɛnga abinkɛ aka awe ra amɛn anera. ");
INSERT INTO ldb_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Unera nuwɔ itsoka igburh Unikodimu. Awu unggbaashi abi Uyahuda na awu utsa Ufarisi. ");
INSERT INTO ldb_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Unga aba ru Uyesu ru untsuuka, agɔr Uyesu agɛ, <<A umarhem, umɛn ihwɛngmɛn ungo uwu umarhemwi aka adzeku Unum, ubinkutsu unera asi ídɛ̃ɛ̃ akorhunga abin idzeu nu atsarkɛ ungo uku ikorhe, Unum aba asi iwea nggu unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Uyesu agɔr unga agɛ, <<Umum indɛyiwa ungo idzidzɛrhe, aba asi imarmbɔ unera ide ivaa, asi ídɛ̃ɛ̃ atsĩã ri Iyɛrhe Unum.>> ");
INSERT INTO ldb_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Unikodimu arhusa agɛ, <<Abvui amar unera aguse ri ikɔ̃ uner? Idzidzɛrhe asi íbvui atsĩã ra anaa uyanga umbɔ amar unga ide ivaa!>> ");
INSERT INTO ldb_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Uyesu agɔr unga agɛ, <<Umum indɛyiwa ungo idzidzɛrhe, umbɔ aba asi imarmbɔ unera ra amɛ̃ nu Ipfu-Num, asi ídɛ̃ɛ̃ atsĩã Iyɛrhe Unum. ");
INSERT INTO ldb_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ubinkpi unera aka amar uwu uner, bɔr ubinkpi Ipfu-Num iki imar uwu ipfu. ");
INSERT INTO ldb_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Niba ugũo idzeu umum iki igɔr ungo ugɛ, <Awu ufang umbɔ abvui amar umbi.> ");
INSERT INTO ldb_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ugba ufɛu ra anangkɛ ukpɔ uku ubee. Ungo ugũo ititɔngkpɔ, bɔr ungo usi ihwɛngo anangkɛ ukpɔ uku udzek, ikɛi ungo usi ihwɛngo anangkɛ ukpɔ uku izĩ. Iwu rimi nggu unerwi Ipfu-Num iki imar.>> ");
INSERT INTO ldb_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Unikodimu arhusu Uyesu agɛ, <<Akɛrɛ ha akorha aguse na awe?>> ");
INSERT INTO ldb_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Uyesu agɛ, <<Ungo uwu umarhem uwuku ugɔng ru Uisrairha, bɔr ungo usi ihwɛngo abina akɛrɛ? ");
INSERT INTO ldb_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Umum indɛyiwa ungo idzidzɛrhe, umɛn irherha abinkɛ umɛn iki ihwɛng, ikɛi umɛn ĩdzaa umbi ideka abinkɛ umɛn iki inyã, bɔr utsɛku icɛrɛ umbi akpɛ̃mbi iyɛi idekayɛ umɛn iki isɔma umbi. ");
INSERT INTO ldb_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Uba umum irherhuwa umbi arherhe ra abinkɛ aka uwe ru upfung nu umbi asi iwembi ri imangmang, ude umbi akorha aguse na awe ru imangmang umum ĩba isɔma umbi abinkɛ aka awe ra afã? ");
INSERT INTO ldb_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Unera anasi ifũã ra afã. Ungwɛ̃-Ner ukpekũ unga aka adzek umɔ acipuwa. ");
INSERT INTO ldb_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ru nyaku Umusa aka aberi ibvui nu ucici ra arhum, rimi hã ikɛi awu ufang umbɔ aberu Ungwɛ̃-Ner, ");
INSERT INTO ldb_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","agɛ uwuruwi aka awea ri imangmang ru unga ama akpo urhɛ uwu ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","<<Unum abemu upfunga akarhãrhã nggee unga adzowe unanyĩ Ungwɛ̃nga, agɛ ubɛn unera aka awea ri imangmang ru unga asi íkpea, bɔr unga awuri ikpo urhɛ uwu ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Unum asi idenuka Ungwɛ̃nga ru upfung agɛ unga atsu uvau ru upfung, bɔr agɛ upfung ukpo ififɔrh ru uboknga. ");
INSERT INTO ldb_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ubɛn uwuku uwe ru imangmang ru Ungwɛ̃ Unum, asi ítsumbɔ uvau ru unga, bɔr uwuruwi aka asi iwea ri imangmang ru unga, aka atsumbɔ uvau ru unga, ubinkutsu asi idzowuka imangmang ri itsok unanyĩ Ungwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nu izharha arherhenga iwe ri iminɛ. Irhirhang itsĩwã ru upfung, bɔr anera abemu uzĩ anangmbɔ irhirhang, ubinkutsu itsermbɔ iwu iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ubɛn uwuku utɔ̃itser iyiki ibewe akpɛ̃ irhirhang, asi íbanga ri irhirhang, utsur umbɔ anyãmbɔ itsernga. ");
INSERT INTO ldb_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bɔr uwuku utɔ̃itser idzidzɛrhe aka isaka aba ra anang aka arhurhang ngge itsú umbɔ anyã ra awiya agɛ abinkɛ unga aka adɛ̃ɛ̃ ikikorhe awu Unum ayike unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Akɛrɛ aka amaa, Uyesu nu angwɛ̃ imesanga adzek azĩmbɔ abĩ Uyahudiya, umɔ unga amaa inuma irhɛirhɛ nggu umbɔ, anu ikorhuwe ubɔtisima ra anera. ");
INSERT INTO ldb_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Uyohana ikɛi anu ikorhuwe ubɔtisima ru Uainon uku ukhapa nggu Usarhim, ubinkutsu amɛ̃ awu arhɛrhɛ umɔ. Anera ubɛn unum akɛyi ru unga umɔ azĩ isorhu ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Akɛrɛ ha akorhuke kata, umbɔ adɔrha agbange Uyohana ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Umɔ angwɛ̃ imesu Uyohana atsĩmbɔ uning nggu utsa Uyahuda uwɔɔ ra arherhi isorh iyor ru nyaka agbeyi abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Umbɔ azĩmbɔ ru Uyohana agɔr unga agɛ, <<A umarhem, utsa ha umbi aka awu nggu unga unum hã ru ugar ubang Azɛ̃ Urdun, uwu ha ungo uku udzowe ideka ri itsinga hã, unggawɔ nggɔɔ adɛ̃ɛ̃ isorhuwe ubɔtisima. Anera kishoo azĩ ru unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mɔcɛ Uyohana agɛ, <<Unera asi idɛ̃ɛ̃ ayɛisa ubin, Unum aba asi ídzowuka ukpɔ ra afã. ");
INSERT INTO ldb_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Umbi awu idekamum, umum ĩgɔr ugɛ, <Asi iwea umum iwu Ukiristo, bɔr adena umum inggbaashia ĩba.> ");
INSERT INTO ldb_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Utsak uwuku ufa unga apfunu utsɛrh uwuku ufa. Bɔr uwɛrhu utsak uwuku ufa uwuku uzĩ irhowa ipfuna hã aka isaka adzɛu igũ irhak utsak uwuku ufa, na aka isaka agɔm anggɔm ri ivangyɛ unga aka igũ irhak utsak uwuku ufa ha. Anggɔm hã awu akimum, atsuafɛr icɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Awu ufang unga awu ukugɔnga, bɔr awu ufang umum iwu uku ucia. ");
INSERT INTO ldb_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","<<Uwuruwi aka adzeka afã aba ananga anera kishoo. Uwuruwi aka adzeka abĩ awu uwu abĩ na arherhe ra abinkɛ aka awu ra abĩ. Uwuruwi aka adzeka afã aba ananga kishoo. ");
INSERT INTO ldb_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Unga arherhe ideka ubinkpi unga aka agũ na anyã, bɔr anera asi iyɛimbɔ idekanga. ");
INSERT INTO ldb_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ubɛn unera aka ubemu idekanga atsu utsar adɛyiwe ugɛ Unum arherhi idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Uwu ha Unum aka adene arherhe irhɛm Unum, ubinkutsu adzowe Ipfu iyiriyɛ iki isi ímaangge. ");
INSERT INTO ldb_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Utɛ abemu Ungwɛ̃ na atsuke abina kishoo ru uboknga. ");
INSERT INTO ldb_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ubɛn uwuku uwe ru imangmang ru Ungwɛ̃ awea ru urhɛ uwu ugbagbaa, bɔr ubɛn uwuku ukpɛ̃ɛ̃ Ungwɛ̃ asi ínyãã urhɛ, ubinkutsu avɔm Unum awu ni itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Abi Ufarisi aka agũ ugɛ Uyesu ani akposha angwɛ̃ imesa ananga Uyohana na ani akorhuwe umbɔ ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Bɔr asi iwea Uyesu aka isaka akorhuwe umbɔ ubɔtisima hã, awu angwɛ̃ imesanga aka isaka akorhuwe. ");
INSERT INTO ldb_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ivangyɛ Uteijee aka agũ akɛrɛ, unga asoka ru Uyahudiya na abvui azĩã Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Unga awuri itsĩ ru Usamariya atɔng. ");
INSERT INTO ldb_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nggee unga aba atsĩ ru uteu ukpɔɔ ru Usamariya umbɔ iki iyisa Usaikar, ukhapa ra abĩkɛ Uyakubu aka adzowe ungwɛ̃nga Uyusuf. ");
INSERT INTO ldb_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Uvãã amɛ̃ Uyakubu uwe ra anang hã. Azhe uzɛ̃rhã aka afɛr Uyesu, unga asei ra angwĩ uvãã amɛ̃ hã. Aka awu idzingga atenuma. ");
INSERT INTO ldb_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Utsɛrh Usamariya uwɔɔ aka aba ishɔyi amɛ̃, Uyesu agɔr unga agɛ, <<Ungo uma udzaango amɛ̃ umum ihwa?>> ");
INSERT INTO ldb_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Angwɛ̃ imesanga aka azĩmbɔ ru utepa igoi ubingha. ");
INSERT INTO ldb_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Utsɛrh Usamariya ha agɔr unga agɛ, <<Ungo uwu utsa Uyahuda. Umum iwu utsɛrh Usamariya. Awu use utsu ungo urhusa umum amɛ̃ aka ahwa?>> Unga arhusa akɛrɛ ubinkutsu abi Uyahuda aka asi isaka agbopumbɔ nggu abi Usamariya. ");
INSERT INTO ldb_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Uyesu agɔr unga agɛ, <<Uba ungo uhwɛngo izũwã Unum nu unerwi aka arhusa ungo amɛ̃ aka ahwa, ungo uwuri ifɛnungo unga, unga adzaa ungo amɛ̃ akika adzowe urhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Utsɛrh ha agɔr Uyesu agɛ, <<A uteiya, umum inyã ungo ushiɔ ru ubin ukpuku ushɔi nu uvãã amɛ̃ ukpi uwu ughorghotakpɔ. Ri inɛ̃ɛ̃ ungo iki ikpo amɛ̃ akika adzowe urhɛ ha? ");
INSERT INTO ldb_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Use ungo unango utɛmɛn Uyakubu, unga aka aneka uvãã amɛ̃ ru umɛn? Unga nibikanga ahwa amɛ̃ hã, ikɛi angwɛ̃nga, nu íjuɛnga aka ahwa umɔ.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Uyesu agɛ, <<Ubɛn uwuku uhwa amɛ̃ akɛrɛ awuri ibvui agũã ugɔ̃ amɛ̃ ikɛi. ");
INSERT INTO ldb_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Bɔr ubɛn uwuku uhwa amɛ̃mum iki ĩdzowe unga asi íbvui agũã ugɔ̃ amɛ̃ ugbagbaa. Amɛ̃ hã umum iki idzowe unga awuri iwu akwiu amɛ̃ ru umbɔ aka idzowe urhɛ uwu ugbagbaa.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Utsɛrh ha agɔr unga agɛ, <<A uteiya, udzaa umum amɛ̃ hã utsur umum ibvui ĩgũmum ugɔ̃ amɛ̃ ikɛi ni isi íbvui ikɛyiwamum ishɔng amɛ̃ nggimi.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Uyesu agɔr unga agɛ, <<Uzĩ uyisu utsakngo umbi aba nggimi.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Unga agɛ, <<Umum ishimum ru utsak.>> Uyesu agɔr unga agɛ, <<Ungo urherhi idzidzɛrhe ungo uku ugɔr ugɛ, ungo ushiɔ ru utsak. ");
INSERT INTO ldb_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ubinkutsu ungo uku uweɔ ra atsaka atɔ̃ɔ̃ nu unerwi umbi aka awu nggu unga icɛrɛ asi iwea utsakngo. Ungo urherhe ishaa idzidzɛrhe.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Utsɛrh ha agɛ, <<A uteiya, umum inyã ungo uwu uner uwuku usɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Atokamɛn adzowe Unum igɔng ri igũ iyɛrɛ, bɔr umbi abi Uyahuda agɛ Urusharhima ukpɔ umɛ̃ɛ̃ awu ufang anera adzowe igɔng ru Unum.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Uyesu agɔr unga agɛ, <<A utsɛrh ha, uwe ru imangmang ra abinkɛ umum iki irherhe. Ivanga niyɔ ibarɔ anera asi ídzowukumbɔ Utɛ igɔng ri igũ iyɛrɛ use ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Umbi abi Usamariya asi ihwɛngmbi ubinkpi umbi aka idzowe igɔng. Bɔr umɛn abi Uyahuda ihwɛngmɛn ubinkpi umɛn iki idzowe igɔng, ubinkutsu udĩ ififɔrh udzeka ra abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Bɔr ivanga niyɔ ibarɔ, iki ibangge, abika adzowe igɔng idzidzɛrhe aka idzowe Utɛ igɔng ri Ipfu nu idzidzɛrhe, ubinkutsu Utɛ abee ikpũ abi ha adzowe unga igɔng. ");
INSERT INTO ldb_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Unum awu ipfu, abika adzowe unga igɔng ikɛi awu ufang umbɔ adzowe igɔng ri Ipfu nu idzidzɛrhe.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Utsɛrh ha agɛ, <<Umum ihwɛng Uarhmasihu, awu unga umbɔ iki iyisa Ukiristo, nggawɔ abarɔ. Ivangyɛ unga aka iba, unga awuri idɛyiwanga umɛn abina kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mɔcɛ Uyesu adɛyiwe unga agɛ, <<Umum uner arherhakɛ nggu ungo, iwu unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ivang hã niyɔ angwɛ̃ imesanga abvui aba adzeidzeu umbɔ aka anyã unga adɛ̃ɛ̃ arherhe nggu ukutsɛrh. Bɔr unera asi igɔra agɛ, <<Ungo ubee use,>> use arhusa unga agɛ, <<Awu use utsu ungo urherha arherhe nggu unga?>> ");
INSERT INTO ldb_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Mɔcɛ utsɛrh ha abɔruka idzum amɛ̃nga umɔ na atsĩã ru utepa na agɔr anera agɛ, ");
INSERT INTO ldb_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","<<Àka aba anyã unerwi aka adɛyiwa umum kishoo abinkɛ umum iki ikorhe! Awu unga awu Ukiristo?>> ");
INSERT INTO ldb_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Umbɔ adzeku utepa aba ra anang Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Angwɛ̃ imesanga ashɔ̃rhã unga agɛ, <<A umarhem, uma ugha ubingha.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bɔr unga agɔr umbɔ agɛ, <<Umum iwemum ru ubinkpi umum iki igha umbi aka asi ihwɛngmbi ukpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mɔcɛ angwɛ̃ imesanga arhusa adɔka agɛ, <<Use unera akũ ubingha akowe unga?>> ");
INSERT INTO ldb_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Bɔr Uyesu agɔr umbɔ agɛ, <<Ubinghamum ukpi, umum ikorhu ubin amɛn uwuku udena umum ĩba, ikɛi imashuwe itseryɛ unga aka adzaa umum. ");
INSERT INTO ldb_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Uba umbi aka isaka agɔr agɛ, <Abɔr afɛ̃ɛ̃ anaa umbɔ atirhi igbɛr abin>? Bɔr umum idɛyiwa umbi, aka agbisha arhi icanga. Iki ikɔ̃ngge, ni iki iwengge iyiki igbigbɛr. ");
INSERT INTO ldb_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Uner uwuku ugbɛr abin hã aka ikpoa itosanga, ikɛi unga ani ikɔng anera aka akpo urhɛ uwu ugbagbaa, ngge itsú uner uwuku udoi nu uner uwuku ugbugbɛr agɔm anggɔm urhɔnga. ");
INSERT INTO ldb_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ake awu idzidzɛrhe, ake aka agɔr agɛ, <Uwɔɔ adoi, nu uwɔɔ agbɛr.> ");
INSERT INTO ldb_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Umum idena umbi igbɛr abinkɛ umbi aka asi itɔ̃mbi itser ake. Abɔɔ umbɔ atɛ̃wã itsera, umbi agbɛr ugarh ititɛ̃wãmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Abi Usamariya awu arhɛrhɛ ru uteu ha umbɔ aka awe ru imangmang ru Uyesu ri itsi ideka utsɛrh ha aka agɔr agɛ, <<Unga adɛyiwa umum kishoo abinkɛ umum iki ikorhe.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Abi Usamariya aka aba ru unga, umbɔ ashɔ̃rhã unga asei nggu umbɔ, unga asei inuma ivaa. ");
INSERT INTO ldb_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Arherhanga atsu anera arhɛrhɛ awe ru imangmang. ");
INSERT INTO ldb_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Umbɔ agɔr utsɛrh ha agɛ, <<Umɛn iwe ru imangmang ru Uyesu, ubinkutsu asi iwea ubinkpi ungo uku urherhe ukpekũ, bɔr icɛrɛ umɛn igũmɛn nibikamɛn ni ihwɛngmɛn ugɛ uwɛrɛ ha idzidzɛrhe unga awu Uwuku Ufɔrh upfunga.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Inuma ivaa ha iki imaa unga asok azĩã Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Uyesu nibikanga adekuka ugɛ uner uwuku usɔm Arherhu-Num aka isaka ashia ri imor ra abĩnga. ");
INSERT INTO ldb_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ivangyɛ unga aka itsĩ Ugarhirhi, abi Ugarhirhi ayɛi unga aboka avaa, ubinkutsu umbɔ ikɛi azĩmbɔ Irhowa Iyiki Igar Utɔng hã ru Urusharhima na anyãmbɔ kishoo abin Uyesu aka akorhe. ");
INSERT INTO ldb_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Mɔcɛ Uyesu abvui azĩã iyepu uteu Ukana ukpu Ugarhirhi, anangkɛ unga aka adzipa amɛ̃ ake awu amɛ̃ inebi. Utsa uner itser ijee nuwɔ uwuruwi ungwɛ̃nga aka aghonga unga ru Ukafanahum. ");
INSERT INTO ldb_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ivangyɛ utsa ha aka agũ ugɛ Uyesu aka adzeku Uyahudiya abvui abanga Ugarhirhi, unga azĩ ru unga ashɔ̃rhã unga ama aba akerhuwe ungwɛ̃nga, aka abɔr akpe. ");
INSERT INTO ldb_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Uyesu agɔr unga agɛ, <<Umbi aba asi inyãmbi atsar nu abin idzeu, umbi asi íwembi ri imangmang.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Uner itser ijee ha agɛ, <<A Uteiya, uba umɛn izĩmɛn utsur ungwɛ̃mum akpea.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Uyesu agɔr unga agɛ, <<Ungo udɛ̃ɛ̃ uzĩɔ. Ungwɛ̃ngo awuri ibɛka.>> Utsa ha awea ri imangmang nu ubin Uyesu aka arherhe nggu unga, umɔ unga azĩã. ");
INSERT INTO ldb_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ana awe ru utsĩndĩ ugãrhãnga agbanga unga, agɔr unga agɛ, <<Ungwɛ̃ngo abɛka.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Unga arhusa umbɔ ivangyɛ ungwɛ̃ hã aka atirhi igũ ugarha. Umbɔ agɔr unga agɛ, <<Imani iyor ha ineke unga arhɛkɛ ru ukara unying.>> ");
INSERT INTO ldb_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Utei ungwɛ̃ hã ayita, ivang hã niyɔ Uyesu agɔra unga agɛ, <<Ungwɛ̃ngo awuri ibɛka.>> Nggee unga nu aner iyanga kishoo awe ru imangmang. ");
INSERT INTO ldb_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Akɛrɛ awu ubin idzeu ukpu uvaa Uyesu aka akorhe unga aka adzeku Uyahudiya azĩ Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Akɛrɛ aka amaa, Uyesu azĩã irhowa abi Uyahuda ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ru Urusharhima ukau amɛ̃ nukpɔ umbɔ iki iyisa ri idũ abi Uyahuda agɛ Ubetasda. Ukpɔ ukhapa ru angwĩ ufɔm, anangkɛ ídɔi iki itsĩ. Aka akũ atarh atang nggaa atsurha atɔ̃ɔ̃ adzipu ukau ha. ");
INSERT INTO ldb_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Awu ra atsurha ha abi irhãrhã nu abi ibvuta, nu akatarhu nu abi ishayi iyor arhɛrhɛ aka isaka anu umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Uner uwɔɔ aka amaa imɛka isɔka itaar ni imɛka utɔrɔk asi idɛ̃ɛ̃ azɛ̃rhũnga. ");
INSERT INTO ldb_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Uyesu aka anyã ininunga, ikɛi ahwɛnga utsa ha aka adãrhũnga nggu irhãrhã hã, unga arhusu uner irhãrhã hã agɛ, <<Ungo ubeengo ikikerhe?>> ");
INSERT INTO ldb_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Uner irhãrhã hã agɛ, <<A uteiya, umum ishimum ru unera aka iyika umum itsĩ ru amɛ̃ ivangyɛ ake aka idzipa. Umum ĩba itita ibee itsitsĩwã, uwɔɔ agbaangashia ru umum.>> ");
INSERT INTO ldb_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Mɔcɛ Uyesu agɔr unga agɛ, <<Usisok, unyangu ufarngo, ukũ uzɛ̃rhã!>> ");
INSERT INTO ldb_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kanying, uner ha akerhunga. Anyangu ufarnga atirhunga uzɛ̃rhã. Akɛrɛ ha akorhe ru unum ukpuku uwosha. ");
INSERT INTO ldb_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nggee anggbaashi abi Uyahuda agɔr utsa ha aka akerhe agɛ, <<Awu unum ukpuku uwosha. Ikpem ikɛnngge ungo itsã ufar.>> ");
INSERT INTO ldb_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Bɔr utsa ha agɛ, <<Unerwi aka akerhuwa umum agɔr umum agɛ, <Unyangu ufarngo uso uzɛ̃rhã.> >> ");
INSERT INTO ldb_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nggee umbɔ arhusa unga agɛ, <<Awu ungamɔ uner ha aka agɔr ungo ugɛ unyanga umgbɔ uso uzɛ̃rhã?>> ");
INSERT INTO ldb_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Utsa ha aka akerhe asi ihwɛngnga awu ungamɔ akerhuwe unga, ubinkutsu Uyesu aka azɛ̃rhã atsĩã ra anera arhɛrhɛ umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ivanga ukunjiir iki itɔng Uyesu akpo unga ri Iya-Num na agɔr unga agɛ, <<Unyã ungo uku ukerhungo! Uneke arhim utsur ubin uku unangkpɔ akɛrɛ ha ukpokpɔ ungo.>> ");
INSERT INTO ldb_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Utsa ha azĩ adɛyiwe anggbaashi abi Uyahuda agɛ awu Uyesu unga akerhuwe unga. ");
INSERT INTO ldb_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ngge itsu anggbaashi abi Uyahuda adzowe uver ru Uyesu, ubinkutsu itser iyiki ikikerhe ha unga aki itɔ̃ ru unum ukpuku uwosha. ");
INSERT INTO ldb_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Uyesu agɔr umbɔ agɛ, <<Utɛmum anu itser utsɛku irherɛ, umum rimi hã ini ititɔ̃.>> ");
INSERT INTO ldb_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Arherha akɛrɛ atsu anggbaashi abi Uyahuda abee ifɛre Uyesu. Agɔr agɛ unga asi izharhuka ikpem unum ukpuku uwosha ukpekũ, bɔr unga agɔr agɛ Unum awu Utɛnga na anu inyãngu itsinga uku kpengkpeng nggu Unum. ");
INSERT INTO ldb_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Uyesu agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, Ungwɛ̃ asi íkorhunga ifɛrhɛ nibikanga, unga akpurha akorhu ubinkpi unga aka anyã Utɛnga aki ikorhe, ubinkutsu ubinkpi Utei iki ikorhe awu ukpɔ Ungwɛ̃ hã awuri ikorhe. ");
INSERT INTO ldb_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ubinkutsu Utɛ abemu Ungwɛ̃ na adɛyiwe unga kishoo abinkɛ unga aka isaka akorhe. Ĩĩ, umbɔ awuri idɛyiwe unga abinkɛ aka anangke akɛrɛ ha nu umbi awuri idzedzeu. ");
INSERT INTO ldb_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ru nyaku Utɛ iki isoyiwe abika akpukpe na adzowe umbɔ urhɛ, rimi Ungwɛ̃ hã awuri idzowe urhɛ ru kishoo abirabɛ unga aka abee idzidzowe. ");
INSERT INTO ldb_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Rimi hã, Utɛ asi ítsuka uvau ru unera, bɔr adzowe ijee itsu uvau ru Ungwɛ̃nga, ");
INSERT INTO ldb_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ngge itsú umbɔ kishoo adzowe igɔng ru Ungwɛ̃ ru nyaka umbɔ iki idzowe igɔng ru Utɛ. Uwuruwi aka asi idzowuka igɔng ru Ungwɛ̃, asi idzowuka igɔng ru Utɛ uwuku udene unga. ");
INSERT INTO ldb_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","<<Umum indɛyiwa umbi idzidzɛrhe, uwuku ugũ arherhamum na adzowuka imangmang ru uwuku udena umum ĩba, awea ru urhɛ uwu ugbagbaa na asi ítsumbɔ unga uvau. Unga aka agar akpe azĩã urhɛ. ");
INSERT INTO ldb_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Umum indɛyiwa umbi idzidzɛrhe, ivanga niyɔ ibarɔ ni iki ibangge abika akpe awuri igũmbɔ urhɛm Ungwɛ̃ Unum nu abika agũ hã awuri ibɛkmbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ru nyaku Utɛ aka awe ru urhɛ ri itsikamnga, rimi hã unga aka adzowe Ungwɛ̃nga ijee iyiki idzowe urhɛ. ");
INSERT INTO ldb_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Utɛ ikɛi adzowuka unga ijee iyiki ivarha arherhe, ubinkutsu unga awu Ungwɛ̃-Ner. ");
INSERT INTO ldb_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","<<Niba agũmbi idzeu akɛrɛ ha, ivanga niyɔ ibarɔ kishoo abika awe ra adzak awuri igũmbɔ urhɛmnga ");
INSERT INTO ldb_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na adzeka. Abika akorhe iyiki ize awuri isok ra akpe abɛk, bɔr abika akorhe iyiki ibewe awuri isok akpo uvau itsitsĩme. ");
INSERT INTO ldb_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Umum nibikami isi ídɛ̃ɛ̃ ikorhumum ubin. Umum itsu uvau ubinkpi umum iki igũ ukpekũ. Itsu uvaumum iwu iyiki irhika, ubinkutsu isi idɔsumum ubinkpi amɛnmum aki ibee bɔr aki uwuku udena umum. ");
INSERT INTO ldb_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","<<Umum ĩba idzowe ideka itsimum, idekamum isi iwengge idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bɔr uner uwɔ aba adzowe ideka ri itsimum, umum ihwɛng ideka ha ri itsimum iwe idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","<<Adzaanga umbi ideka idzidzɛrhe ri ivangyɛ umbi adene anera azĩ ru Uyohana. ");
INSERT INTO ldb_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Asi iwea ugɛ umum itsorhi itsimum ri ideku unera, bɔr umum irherhe rimi ngge ítsu umbi adɛ̃ɛ̃ akpo ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Uyohana awu ru nyaki irhirhang iki igar ni irhang, umbi atsũmbi igũibɛn irhirhangnga ri ivanga ukunjiir. ");
INSERT INTO ldb_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","<<Bɔr umum iwemum ri idekayɛ iki inangngge ideka Uyohana. Ubinkutsu itseryɛ Utɛmum aka adzaa umum imasha, iyiriyɛ umum iki inũ itɔ̃ icɛrɛ, ngge idekuwe ugɛ awu Utɛ unga adena umum. ");
INSERT INTO ldb_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Utɛ uwuku udena umum adzowuka ideka ri itsimum. Umbi anasi anyãmbi unga use agũmbi urhɛmnga ");
INSERT INTO ldb_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","nu arherhanga asi iseike ru umbi, ubinkutsu umbi asi iwembi ri imangmang ru uwu ha unga aka adene. ");
INSERT INTO ldb_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Umbi atsu amɛnmbi ivarhi itsɛng Arherhu-Num, ubinkutsu umbi akaifɛrhkɔ ugɛ umbi awuri ikpikpombi urhɛ uwu ugbagbaa ru ngge. Itsɛng Arherhu-Num hã ngge idzowe ideka ri itsimum. ");
INSERT INTO ldb_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Bɔr umbi akpɛ̃mbi iba ru umum aba akpo urhɛ. ");
INSERT INTO ldb_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","<<Umum isi iyɛimum ikpikpoi ra anera. ");
INSERT INTO ldb_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bɔr umum ihwɛng umbi. Umum ihwɛng ugɛ umbi asi ibemumbi Unum ra amɛnmbi. ");
INSERT INTO ldb_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Umum iba ri itsok Utɛmum, umbi asi iyɛimbi umum, bɔr uwɔɔ aba, aba ri itsok ukamnga, umbi awuri iyɛimbi unga. ");
INSERT INTO ldb_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Umbi awuri ikorha aguse na awe ru imangmang uba umbi ayɛi ukpoi ra adɔkambi, bɔr umbi asi ibeembi iyɛi ikpikpoi iki idzeku Unum unying ukpekũ? ");
INSERT INTO ldb_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","<<Bɔr aka niba akaimbi ifɛrhkɔ ugɛ umum iwuri ihwitumum umbi ru Utɛ. Uwuku uhwita umbi awu Umusa, uwuruwi umbi aka afosa. ");
INSERT INTO ldb_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Agɛ umbi awembi ri imangmang ru Umusa, umbi awuri iwembi ri imangmang ru umum, ubinkutsu unga atsɛng itsɛng ri itsimum. ");
INSERT INTO ldb_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bɔr umbi aba ashimbi ri imangmang ra abinkɛ Umusa aka atsɛng, umbi akorha aguse na awe ru imangmang ra abinkɛ umum iki irherhe?>> ");
INSERT INTO ldb_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Akɛrɛ aka amaa Uyesu agar Ukau ukpu Ugarhirhi, ukpɔ uku uwe ukau ukugɔng ukpu Utibariya. ");
INSERT INTO ldb_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Nggaa ikikɔng anera idɔsa unga, ubinkutsu umbɔ aka anyã atsar abin idzeukɛ unga aka akorhuwe abi irhãrhã. ");
INSERT INTO ldb_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Mɔcɛ Uyesu afũã ri ifɛn igũ aseisa umɔ nggu angwɛ̃ imesanga. ");
INSERT INTO ldb_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Irhowa Iyiki Igar Utɔng iyi abi Uyahuda iki iyongge. ");
INSERT INTO ldb_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ivangyɛ Uyesu aka abera asunga anyã anera arhɛrhɛ aka aba ru unga, unga agɔr Ufirhibu agɛ, <<Umɛn igoi uborodi ri inɛ̃ɛ̃ ukpɔ umɛ̃ɛ̃ aner abɛrɛ?>> ");
INSERT INTO ldb_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Unga arhusa rimi avira unga, ubinkutsu unga aka ahwɛnga ra amɛnnga ubinkpi unga aka ikorhe. ");
INSERT INTO ldb_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ufirhibu agɔr unga agɛ, <<Uborodi ukpu imang itser afɛ̃ɛ̃ utɔrɔk usi ímɛ̃kpɔ ubɛn unera akpo atsɔr idiki unying!>> ");
INSERT INTO ldb_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Uwɔɔ ra angwɛ̃ imesanga hã agburh Uandarawu, ungwɛ̃mbɔ Usiman Ubitru, arherhe agɛ, ");
INSERT INTO ldb_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","<<Ungwɛ̃ uwɔɔ uwi nggimi nggu ípo uborodi itɔ̃ɔ̃ nu abɛrh avaa. Bɔr iwuri imɛ̃ use nggu arhɛrha aner abɛrɛ?>> ");
INSERT INTO ldb_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Uyesu agɛ, <<Àka agɔr anera asei isei.>> Ra anang hã ubĩĩ uwu urhɛrhɛ umɔ, anera kishoo aseisa abĩ. Akatsak atsĩmbɔ anaka agɔnga atɔ̃ɔ̃. ");
INSERT INTO ldb_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mɔcɛ Uyesu anyangu ípo uborodi ha, unga aka atar uwɛɛ ru Unum, na agashuwe anera aka asei ubinkpi uku imɛ̃ ru umbɔ. Rimi hã unga aka akorhe nggu abɛrh ha. ");
INSERT INTO ldb_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ivang umbɔ aka atãi ashuur, unga agɔr angwɛ̃ imesanga agɛ, <<Àka arhɔsa awushunga aka abɔr utsur ubin ugbakpɔ abĩ.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ri ípo uborodi itɔ̃ɔ̃ hã, anera aka atãi na abɔre, angwɛ̃ imesanga arhɔsa awushu uborodi na atɔke azĩnga usɔka na avaa. ");
INSERT INTO ldb_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ivang anera aka anyã utsar ubin idzeu Uyesu aka akorhe, umbɔ agɛ, <<Idzidzɛrhe, unga awu uner uwuku usɔm Arherhu-Num hã Unum aka abemuwa umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Uyesu aka ahwɛnga agɛ anera abee atsime unga iyɛrhe ri inggang, unga abvui afũã ni igũa ikiyikanga. ");
INSERT INTO ldb_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Urhɛɛ uku uwe, angwɛ̃ imesanga acipa azĩmbɔ ru ukau ha, ");
INSERT INTO ldb_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","anangkɛ umbɔ aka atsĩ ukhukhɔɔ amɛ̃ na agar ukau ha azĩmbɔ Ukafanahum. Ri ivang hã ananga aka atirhi iwu uzĩ, nu Uyesu anasi ibanga ru umbɔ kata. ");
INSERT INTO ldb_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nggaa ugba ukerketakpɔ ubvun amɛ̃ ru ukau ha. ");
INSERT INTO ldb_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Umbɔ aka azĩmbɔ akirhomita atɔ̃ɔ̃ use utɔ̃ĩ, umbɔ anyã Uyesu azɛ̃rhã nú amɛ̃ aba ayoku ukhukhɔɔ ha. Iwei ifɛr umbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bɔr unga agɔr umbɔ agɛ, <<Awu umum. Niba agũmbi iwei.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mɔcɛ umbɔ ayɛi unga ru ukhukhɔɔ ha nggu anggɔm. Kanying ukhukhɔɔ ha utsĩ anangkɛ umbɔ aka izĩ. ");
INSERT INTO ldb_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ukpe unum uvaa abika asei ugar ukau ukugɔng hã ahwɛngmbɔ ugɛ awu ukhukhɔɔ unying uku uzĩ ugar ha. Ikɛi ahwɛngmbɔ ugɛ Uyesu ashia ru ukhukhɔɔ ha nggu angwɛ̃ imesanga. Awu angwɛ̃ imesa ha ukpekũ azĩ. ");
INSERT INTO ldb_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Bɔr akhukhɔɔ akɔɔ aka adzeku Utibariya adɛ̃ɛ̃ akhapa ra anang aner ha aka atãi uborodi ukpu Uteijee aka atar uwɛɛ. ");
INSERT INTO ldb_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ivang anera aka anyã agɛ Uyesu nu angwɛ̃ imesanga ashimbɔ ra anang hã, umbɔ atsĩ akhukhɔɔ amɛ̃ na azĩmbɔ Ukafanahum anu ibee Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ivangyɛ umbɔ aka anyã unga ugar ukau ha, umbɔ agɔr unga agɛ, <<A umarhem, ukang ungo uku uba nggimi?>> ");
INSERT INTO ldb_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Uyesu agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, ubinkutsu umbi abeea umum, asi iwea atsar abin idzeu umum iki ikorhe, bɔr awu uborodi ukpɔ umbi aka atãi ashur. ");
INSERT INTO ldb_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Niba atɔ̃mbi itser ri ibee abin igha akika adak, bɔr aka atɔ̃ itser abinghakɛ aka azĩ utsĩ urhɛ uwu ugbagbaa, akirakɛ Ungwɛ̃-Ner aka awuri idzaa umbi. Awu ru unga Unum Utɛ aka angwɛ̃ utsar ijeenga.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mɔcɛ umbɔ arhusa unga agɛ, <<Awu ufang umɛn ikorhu use itɔ̃ itser Unum aka abee?>> ");
INSERT INTO ldb_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Uyesu agɛ, <<Itser Unum aka abee nggayɛ, uwe ri imangmang ru uwuruwi unga aka adene.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nggee umbɔ arhusa unga agɛ, <<Ungo uwuri ikorhe utsar ubin idzeu ukusong umɛn iki inyã ni iwe ru imangmang ru ungo? Ungo uwuri ukorhu use? ");
INSERT INTO ldb_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Atoka-atokamɛn agha umanna ra arhum, ru nyaka umbɔ aka atsɛng ra Arherhu-Num agɛ, <Unga adzowe uborodi uku udzeka afã umbɔ atãi.> >> ");
INSERT INTO ldb_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Uyesu agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, asi iwea Umusa unga adzaa umbi uborodi ha ra afã, awu Utɛmum unga adzaa umbi uborodi ukpu idzidzɛrhe uku udzeka afã. ");
INSERT INTO ldb_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Uborodi Unum hã, uwu unga aka acipuwa ra afã na adzowe urhɛ ru upfung.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Umbɔ agɛ, <<A Uteiya, utirhi icɛrɛ udzisa umɛn uborodi ha ubɛn unuma!>> ");
INSERT INTO ldb_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Mɔcɛ Uyesu adɛyiwe umbɔ agɛ, <<Umum iwu uborodi ha ukpuku udzowe urhɛ. Uwuruwi aka aba ru umum asi ígũa imerh, nu uwuruwi aka awe ru imangmang ru umum asi ígũa ugɔ̃ ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bɔr ru nyaka umum iki idɛyiwa umbi, umbi aka anyãmbi umum nu utsɛku icɛrɛ umbi anasi iwembi ri imangmang. ");
INSERT INTO ldb_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kishoo uwuruwi Utɛ aka adzaa umum awuri iba ru umum, nu ubɛn uwuku uba ru umum ikɛi umum isi íwayikũ unga. ");
INSERT INTO ldb_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Umum ĩdzek ra afã isi ĩbamum ikorhu ubin amɛnmum iki ibee, bɔr ikorhu ubin uwuku udena umum. ");
INSERT INTO ldb_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Amɛn uwuku udena umum akɛ, agɛ, umum niba igwirhukũ unying ru kishoo abirabɛ unga aka adzaa umum, bɔr umum isoyiwe umbɔ ru unum ukpuku umasha. ");
INSERT INTO ldb_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ubin Utɛmum ukpi aka abee agɛ, kishoo uwuku urhi Ungwɛ̃ na awea ri imangmang ru unga awea ru urhɛ uwu ugbagbaa. Mɔcɛ umum iwuri isoyikũ unga ru unum ukpuku umasha.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Akɛrɛ ha atsu abi Uyahuda adɛ̃ɛ̃mbɔ ibvibvun ri itsi Uyesu ubinkutsu, unga aka agɔr agɛ, <<Umum iwu uborodi ukpuku udzeka afã ucipuwa.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Abi Uyahuda agɛ, <<Asi iwea Uyesu nuwi ungwɛ̃ Uyusuf, uwuruwi umɛn iki ihwɛng utɛnga nu uyanga? Ude awu use utsu icɛrɛ unga agɔr agɛ, <Umum idzeka afã icipuwa>?>> ");
INSERT INTO ldb_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Uyesu agɛ, <<Àka neke ibvibvun. ");
INSERT INTO ldb_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Unera asi ídɛ̃ɛ̃ abanga ru umum utsɛku Utɛ uwuku udena umum iki idarha unga ĩba, nu umum iwuri isoyikũ uner ha ru unum ukpuku umasha. ");
INSERT INTO ldb_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Atsɛng ra abvur abika asɔm Arherhu-Num agɛ, <Kishoo awu Unum unga imesuwe umbɔ.> Ubɛn unera uwuku ukpeto na amesa ru Utɛ awuri iba ru umum. ");
INSERT INTO ldb_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Unera anasi inyã Utɛ ha akpurha awu uwuku udzeku Unum. Unga ukpekũ unga aka anyã Utɛ ha. ");
INSERT INTO ldb_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Umum indɛyiwa umbi idzidzɛrhe, ubɛn unera aka awe ru imangmang awea ru urhɛ uwu ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Umum iwu uborodi ukpuku udzowe urhɛ. ");
INSERT INTO ldb_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Atoka-atokambi agha umanna ra arhum, bɔr rimi hã akpembɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bɔr aka anyã uborodi ha ukpi uku udzeka afã ucipuwa. Ubɛn unera aka itãi asi íkpea. ");
INSERT INTO ldb_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Umum iwu uborodi ukpu urhɛ uku udzeka afã ucipuwa. Ubɛn uwuku utãi uborodi ha awuri ibɛka ugbagbaa. Uborodi ha uwu ijuɛ iyormum, iyiriyɛ umum iki iwuri ĩdzowe ngge itsú upfunga uma ubɛk.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Mɔcɛ abi Uyahuda atsĩmbɔ uning akarhãrhã ru ubinkpi Uyesu aka arherhe na agɔr agɛ, <<Uner uwurɛ awuri ikorha aguse na adzaa ijuɛ iyornga umɛn itãi?>> ");
INSERT INTO ldb_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Uyesu agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, umbi aba asi itãimbi ijuɛ iyor Ungwɛ̃-Ner na ahwambi adzirhnga, urhɛ ushimgbɔ ru umbi. ");
INSERT INTO ldb_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ubɛn uwuku utãi ijuɛ iyormum na ahwa adzirhmum awea ru urhɛ uwu ugbagbaa. Umum ikɛi iwuri isoyikũ unga ru unum ukpuku umasha. ");
INSERT INTO ldb_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ijuɛ iyormum iwu uborodi ukpu idzidzɛrhe, nu adzirhmum ikɛi awu ubin uku uhwuhwa ukpu idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ubɛn uwuku utãi ijuɛ iyormum, na ahwa adzirhmum, abɛk ru umum, umum igamum ibɛk ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ru nyaku Utɛ uwu urhɛ aka adena umum, na awu ru unga umum iki ibɛk, rimi uwuku unyanga umum iwu ubinghanga, awuri ibɛka ru umum. ");
INSERT INTO ldb_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Umum iwu uborodi ha uku udzeka afã. Atoka-atokambi agha umanna nu umbɔ akpembɔ, bɔr unera aka atãi ru uborodi ukpirɛ awuri ibɛka ugbagbaa.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Uyesu arherha arherhe akɛrɛ kishoo ri ivangyɛ unga aka adɛ̃ɛ̃ imesuwe anera ru ubã ifɛn-Num ru Ukafanahum. ");
INSERT INTO ldb_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Igũ rimi hã, angwɛ̃ imesanga arhɛrhɛ agɛ, <<Imesa iyɛrɛ ighong. Ungaa adɛ̃ɛ̃ ayɛi ngge?>> ");
INSERT INTO ldb_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Uyesu aka ahwɛnga agɛ angwɛ̃ imesanga adɛ̃ɛ̃ ibvibvun ri imesa ha. Unga agɔr umbɔ agɛ, <<Imesa ha itsu amɛnmbi aghong? ");
INSERT INTO ldb_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ude, amɛnmbi awu aguse umbi aba anyã Ungwɛ̃-Ner afũ azĩã anangkɛ unga aka adzek? ");
INSERT INTO ldb_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ipfu-Num ngge idzowe urhɛ. Iyor ishingge ri ijee ubin. Irhɛmyɛ umum iki isɔma umbi idzeku Ipfu ha iyiki idzowe urhɛ. ");
INSERT INTO ldb_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bɔr abimbi abɔɔ ashimbɔ ri imangmang.>> Uyesu ahwɛnga utirhi ri inggbaashia abika asheri imangmang, nu uwuruwi aka igha-daknga. ");
INSERT INTO ldb_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Mɔcɛ unga agɛ, <<Ngge itsu unera asi ídɛ̃ɛ̃ imɛ̃ɛ̃ iba ru umum, Utɛ aba asi ibemuka unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Udzur ri ivang iyɛrɛ arhɛrhɛ angwɛ̃ imesanga aka adɔsa unga abvui anekukumbɔ idɔsa unga. ");
INSERT INTO ldb_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Uyesu arhusa angwɛ̃ imesanga usɔkdũmɛn hã agɛ, <<Umbi abee ibvui azĩ hã ikɛi?>> ");
INSERT INTO ldb_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Usiman Ubitru agɔr unga agɛ, <<A Uteijee, ru ungaa umɛn iki izĩ? Awu ungo uwe ri irhɛm urhɛ uwu ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Umɛn iwemɛn ri imangmang nu umɛn ihwɛngmɛn ugɛ ungo uwu Usarkasar uwu Unum.>> ");
INSERT INTO ldb_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Mɔcɛ Uyesu agɛ, <<Asi iwea umum isɛng umbi kishoo usɔkdũmɛn? Bɔr unying ru umbi awu undenggũ!>> ");
INSERT INTO ldb_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Arherhe akɛrɛ ru Uyahuda ungwɛ̃ Usiman Uiskariyoti, unying ru umbɔ usɔkdũmɛn hã, uwuruwi aka igha-daknga. ");
INSERT INTO ldb_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Akɛrɛ aka amaa, Uyesu azɛ̃rhã atsĩrhã amaa Ugarhirhi. Bɔr unga asi ibeenga itsĩ ru Uyahudiya, ubinkutsu anggbaashi abi Uyahuda abika awu nggɔɔ ha abee ifɛre unga. ");
INSERT INTO ldb_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ivangyɛ Irhowa Atsurha abi Uyahuda iki iyo, ");
INSERT INTO ldb_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","angwɛ̃mbɔ agɔr unga agɛ, <<Imɛ̃ngge ungo uzĩ Uyahudiya, ngge itsú angwɛ̃ imesango anyã abin idzeukɛ ungo iki ikorhe. ");
INSERT INTO ldb_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Uwuku ubee anera ahwɛng unga akarhãrhã asi íwɔka ubinkpi unga iki ikorhe. Ungo uku ukorha abina akɛrɛ, udɛyiwe itsingo ru upfunga uhwɛng.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Uko angwɛ̃mbɔ ashimbɔ ri imangmang ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nggee Uyesu agɔr umbɔ agɛ, <<Ivanga inasi iwengge ru umum kata, bɔr ru umbi ubɛn ivang iwengge. ");
INSERT INTO ldb_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Umbi, upfunga usi ídɛ̃ɛ̃ ukpɛ̃kpɔ umbi, bɔr ukpɛ̃kpɔ umum ubinkutsu umum idekuwe ugɛ abinkɛ ukpɔ iki ikorhe awu aka abewe. ");
INSERT INTO ldb_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Umbi aka azĩ irhowa ha. Umum isi ízĩmum irhowa ha, ubinkutsu ivangmum inasi ibangge kata.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Unga aka amaa irherha akɛrɛ ha, mɔcɛ unga aseisa ru Ugarhirhi. ");
INSERT INTO ldb_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Bɔr ivang angwɛ̃mbɔ aka azĩmbɔ irhowa ha, unga azĩã ikɛi. Unga asi izĩã ukupɛ̃ɛ̃ bɔr ri iwɔk. ");
INSERT INTO ldb_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Anggbaashi abi Uyahuda anu ibeea unga ra anang irhowa ha, arhusa agɛ, <<Uner ha awerɛ unga?>> ");
INSERT INTO ldb_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ikikɔnga aner ha ini ibvun urherhe nggu adɔka ri itsinga. Abɔɔ agɛ, <<Awu uner uwuku uze.>> Abɔɔ ikɛi agɛ, <<Ĩ'ĩ, anu irhɛm anera.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bɔr unera asi irherhunga arherhe Uyesu ukupɛ̃ɛ̃ ubinkutsu, anu igũ iwei anggbaashi abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ivangyɛ umbɔ aka agha uteng ivang irhowa ha, Uyesu atsĩ ri Iya-Num atirhunga imesuwe. ");
INSERT INTO ldb_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Anggbaashi abi Uyahuda adzeidzeu arhusa agɛ, <<Utsak uwurɛ akorha aguse na ahwɛng rimi? Nggawi anasi itsĩa imesa.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Uyesu agɛ, <<Imesamum isi iwengge iyimum. Idzeka ru Unum uwuku udena umum ĩba. ");
INSERT INTO ldb_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ubɛn unera aka asɛng ikorhu ubinkpi Unum aka abema, awuri ihwɛngnga use imesamum idzeku Unum, use iwu iyimum. ");
INSERT INTO ldb_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Uwuruwi aka anu imesuwe abin ukamnga, anu ibeewe itsinga ikpikpoi. Bɔr uwuku ubeewe ikpikpoi ru uwuku udene unga awu uner idzidzɛrhe. Ashia ri igbɛrangwĩ ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Asi iwea Umusa adzaa umbi Íkpem? Bɔr umbi asi ikpɔmmbi Íkpem hã. Awu use utsu umbi abee ifɛre umum?>> ");
INSERT INTO ldb_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Anera agɛ, <<Ungo uwe ru ipfu iyiki ibewe ri itsingo! Ungamɔ abee ifɛre ungo?>> ");
INSERT INTO ldb_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Uyesu agɔr umbɔ agɛ, <<Umum ikorhe ubin idzeu unying ukpekũ nu umbi kishoo adzeidzeu. ");
INSERT INTO ldb_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Umusa atsu umbi isorhu usorhe, ngge itsu umbi aka isaka asorhe awɛkacimbi usorhe ru unum ukpuku uwosha. Nu ngge iki iwe rimi, awu atoka-atokambi atirha akɛrɛ ha, asi iwea Umusa. ");
INSERT INTO ldb_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Umbi aba asorhukumbi awɛkaci ru unum ukpuku uwosha ri idɔsi Íkpem Umusa, awu use utsu umbi agũ avɔm nggu umum ri ikerhuwe undzumu unera ru unum ukpuku uwosha? ");
INSERT INTO ldb_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Àka niba azharhukumbi arherhe ra abinkɛ umbi iki inyã ra asu, bɔr àka azharha arherhunga uku urhirhiki.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Aner Urusharhima abɔɔ aka awe umɔ arhusa agɛ, <<Asi iwea utsa ha nuwi umbɔ aka abee ififɛr ha? ");
INSERT INTO ldb_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Unga uwi nggimi, adɛ̃ɛ̃ arherhe ukupɛ̃ɛ̃ bɔr umbɔ asi idzipumbɔ urhɛm nggu unga. Use abi ijee aka abemumbɔ agɛ awu unga awu Ukiristo? ");
INSERT INTO ldb_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bɔr umɛn ihwɛngmɛn anangkɛ utsak uwurɛ aka adzek. Ivang Ukiristo aka iwuri iba, unera asi íhwɛnga anangkɛ unga aka idzek.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Uyesu ana adɛ̃ɛ̃ imesuwe anera ru ufɔm Iya-Num hã, unga atsarhi irhaknga agɛ, <<Ĩĩ, umbi ahwɛngmbi umum na ahwɛngmbi anangkɛ umum iki idzek. Bɔr umum isi iwemum nggimi nibikami. Unga hã uwuku udena umum awu idzidzɛrhe bɔr umbi asi ihwɛngmbi unga. ");
INSERT INTO ldb_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Bɔr umum ihwɛng unga, ubinkutsu umum indzeku unga, ikɛi unga adena umum.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Mɔcɛ umbɔ abee idzur unga, bɔr unera asi ibangunga ubok ru unga, ubinkutsu ivangnga inasi ibangge. ");
INSERT INTO ldb_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bɔr anera arhɛrhɛ ri ikikɔnga awe ru imangmang ru unga na agɛ, <<Ivangyɛ Ukiristo aka iba, awuri ikorha atsar abin idzeu akɔɔ anangmbɔ aki uner uwɛrɛ ha?>> ");
INSERT INTO ldb_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Abi Ufarisi agũ anera anu ibvun arherha ha ri Iya-Num nggu adɔkambɔ ri itsinga. Mɔcɛ ateiya abika adzowe idɛm-Num nu abi Ufarisi adene abika adzɛu Iya-Num umbɔ adzure unga. ");
INSERT INTO ldb_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Uyesu agɛ, <<Ivangyɛ umum iki iwe nggu umbi ibɔr ukunjiir, mɔcɛ umum iwuri ibvui izĩ ru uwuruwi aka adena umum. ");
INSERT INTO ldb_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Umbi awuri ibeembi umum, bɔr umbi asi íkpombi umum. Anangkɛ umum iki iwe ikɛi umbi asi ídɛ̃ɛ̃ abambi.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Anggbaashi abi Uyahuda ha arherhe nggu adɔkambɔ agɛ, <<Utsak uwurɛ awuri izĩnɛnga umɛn iki isi ídɛ̃ɛ̃ ikpomɛn unga? Use unga awuri izĩ ra anangkɛ abimɛn aka asaka asei nggu abi Uherhini na amesuwe abi Uherhini hã? ");
INSERT INTO ldb_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Akaifɛrhkɔ use ra amɛnnga, ivangyɛ unga aka agɔr agɛ, <Umbi awuri ibeembi umum, bɔr umbi asi íkpombi umum,> na agɔr agɛ, <Anangkɛ umum iki iwe umbi asi ídɛ̃ɛ̃ abambi>?>> ");
INSERT INTO ldb_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ru unum ukpuku umashu irhowa ha uku uwe nggaa unum hã, Uyesu adɛ̃ɛ̃ na atsarhi irhaknga agɛ, <<Uba unera agũã ugɔ̃, unga aba ru umum aba ahwa. ");
INSERT INTO ldb_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ubɛn unera aka awea ri imangmang ru umum, ru nyaki itsɛng Arherhu-Num iki igɔr igɛ, <Azɛ̃ amɛ̃ akika adzowe urhɛ awuri idzɛ̃rhã adzek ra amɛnnga.> >> ");
INSERT INTO ldb_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Uyesu arherha akɛrɛ ri itsi Ipfu-Num, iyiriyɛ abika awe ru imangmang ru unga aka iwuri iyɛi. Ri ivang hã anasi idzowukumbɔ Ipfu-Num ha, ubinkutsu Uyesu ana ashia ri ikpikpoi kata. ");
INSERT INTO ldb_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ivangyɛ umbɔ aka agũ irhɛmnga, abɔɔ ra anera agɛ, <<Idzidzɛrhe uwɛrɛ ha awu uwuku usɔm Arherhu-Num hã Umusa aka arherhe ugɛ ibanga.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Abɔɔ agɛ, <<Unga awu Ukiristo.>> Bɔr abɔɔ arhusa agɛ, <<Akorha aguse ru Ukiristo adzeku Ugarhirhi? ");
INSERT INTO ldb_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Asi iwea itsɛng Arherhu-Num igɔr igɛ Ukiristo awuri idzeku unang Udauda, nu ru Ubaitarhami, uteukpi Udauda aka asei?>> ");
INSERT INTO ldb_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ngge igigau itsĩngge ra anera ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Abɔɔ abee idzur unga, bɔr unera asi ibangunga ubok ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Adogerhi Iya-Num aka abvui azĩ ra ateiya abika adzowe idɛm-Num nu abi Ufarisi arhusa umbɔ agɛ, <<Awu use utsu umbi asi ikũ unga abambi?>> ");
INSERT INTO ldb_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Adogerhi ha agɛ, <<Unera anasi irherhunga arherhe ru nyaku utsak uwurɛ.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Abi Ufarisi arhusa agɛ, <<Unga aka arhɛm nggu umbi ikɛi? ");
INSERT INTO ldb_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Use umbi anyãmbi unera ra anggbaashi abi Uyahuda use abi Ufarisi aka awe ru imangmang ru unga? ");
INSERT INTO ldb_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ĩ'ĩ! Ikikɔng iyɛrɛ ha iki isi ihwɛngngge ubin ri Íkpem Umusa, awu ikponum ru umbɔ!>> ");
INSERT INTO ldb_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Unikodimu, aka azĩã ru Uyesu, unga aka awu unying ra abi Ufarisi ha, arhusa umbɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","<<Ri Íkpem, umɛn idɛ̃ɛ̃ itsumɛn uvau ru utsa ha umɛn iki inasi igũmɛn ra angwĩnga ni ihwɛng ubinkpi unga aka anu ikorhe?>> ");
INSERT INTO ldb_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Umbɔ agɛ, <<Ungo uwu uner Ugarhirhi ikɛi? Uvarhe ungo unyãɔ ugɛ, uner uwuku usɔm Arherhu-Num ashia aka idzeku Ugarhirhi.>> ");
INSERT INTO ldb_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mɔcɛ ikikɔnga isitungge nu ubɛn unera azĩã ri iyanga. ");
INSERT INTO ldb_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Bɔr Uyesu azĩã ri Igũ Acucii Uzaitun. ");
INSERT INTO ldb_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ri igɔ̃kpeka ikɛi unga abvui atsĩã ru ufɔm Iya-Num. Kishoo anera aba akɔng adziira unga, nu unga asei na amesuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Abika amesuwe Ikpem nu abi Ufarisi akũ utsɛrh uwɔɔ umbɔ aka adzur unga ri itoma-dak. Atsu unga adɛ̃ɛ̃ ra asu ukpui ha. ");
INSERT INTO ldb_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Umbɔ agɔr Uyesu agɛ, <<A umarhem, utsɛrh uwurɛ adzur unga ri itoma-dak. ");
INSERT INTO ldb_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ri Íkpem Umusa atsu umɛn ikũ atarh itang ikpũ akatsɛrh abɛrɛ ha ifɛre. Bɔr ungo ugɔr uguse?>> ");
INSERT INTO ldb_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Arhusa akɛrɛ ani ideya unga, na akpo ubinkpi umbɔ aka itsu arherhanga. Bɔr Uyesu agbapfu na akũ itoknga atsɛng itsɛng nú abĩ. ");
INSERT INTO ldb_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ivangyɛ umbɔ aka ani irhusa unga, unga abera agɔr umbɔ agɛ, <<Unera aka ashia ra arhim ru umbi, unga atirha atang utarh ru utsɛrh ha.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ikɛi unga abvui agbapfu na atsɛng itsɛng nú abĩ. ");
INSERT INTO ldb_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Umbɔ aka agũ rimi, umbɔ atirha asoyimbɔ ra anang hã unying anying. Umbɔ atirhi ru uwuku ukũmbɔ utsɛku umbɔ aneke Uyesu iki iyikanga nggu utsɛrh ha. ");
INSERT INTO ldb_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Uyesu abera adɛ̃ɛ̃ na arhusa unga agɛ, <<A utsɛrh ha, umbɔ awerɛmbɔ? Unera asi itsuka ungo ufai?>> ");
INSERT INTO ldb_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Utsɛrh ha agɛ, <<A uteiya, unera ashia.>> Uyesu agɛ, <<Umum ikɛi isi ítsukamum ungo ufai. Uzĩɔ̃, bɔr niba ubvui utsĩɔ̃ ra arhim.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Uyesu abvui arherha arherhe nggu anera agɛ, <<Umum iwu irhirhang upfung. Umbi aba adɔsumbi umum, umbi asi izɛ̃rhũmbi ru uzĩ, bɔr umbi awuri ikpombi irhirhang urhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Abi Ufarisi agɔr unga agɛ, <<Ungo uni idzowe ideka itsingo, nggee idekango isi iwengge idzidzɛrhe.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Uyesu agɛ, <<Uko umum ĩba ĩdzowe itsimum ideka, idekamum iwu idzidzɛrhe, ubinkutsu umum ihwɛng anangkɛ umum iki ĩdzek, nu ikɛi anangkɛ umum iki izĩ. Bɔr umbi asi ihwɛngmbi anangkɛ umum iki ĩdzek, use anangkɛ umum iki izĩ. ");
INSERT INTO ldb_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Umbi atsu uvau ikpũ iyi anera. Umum isi itsukũ uvau ru unera. ");
INSERT INTO ldb_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Bɔr umum iba izharha arherhe, izharha arherhamum iwu idzidzɛrhe, ubinkutsu asi iwea umum ikiyikami izharha arherhunga, bɔr umum nu Utɛmum aka adena umum ikorhu urhɔnga. ");
INSERT INTO ldb_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ri Íkpemmbi umbɔ atsɛng agɛ ideka inera ivaa iwe idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Umum ĩdzowe ideka ri itsimum, nu Utɛ uwuku udena umum unga awu uner uwu uvaa.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Mɔcɛ umbɔ arhusa unga agɛ, <<Utɛngo hã awerɛ unga?>> Uyesu agɛ, <<Umbi asi ihwɛngmbi umum use Utɛmum. Umbi aba ahwɛngmbi umum, umbi awuri ihwɛngmbi Utɛmum ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Unga arherhe irhɛm iyɛrɛ ri ivangyɛ unga aka adɛ̃ɛ̃ imesa akhapa ra anangkɛ umbɔ aka angwɛ̃we uhwɛk izũwã ri Iya-Num. Bɔr unera asi idzura unga, ubinkutsu ivanga inasi iwengge kata. ");
INSERT INTO ldb_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ikɛi Uyesu abvui adɛyiwe anera agɛ, <<Umum iwuri izĩmum, nu umbi awuri ibeembi umum nu umbi awuri ikpe ra arhimmbi. Anangkɛ umum iki izĩ, umbi asi ídɛ̃ɛ̃ abambi.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Akɛrɛ ha atsu anggbaashi abi Uyahuda agɔr agɛ, <<Awuri ifɛre itsinga? Unga aka agɔr agɛ, <Anangkɛ umum iki izĩ, umbi asi ídɛ̃ɛ̃ abambi.> >> ");
INSERT INTO ldb_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Bɔr unga akpurha adɛ̃ɛ̃ igɔr agɛ, <<Umbi awu anɔnɔr, umum idzeka afafã. Umbi awu abi upfung ukpirɛ, bɔr umum isi iwemum uwu upfung ukpirɛ. ");
INSERT INTO ldb_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ngge itsu umum igɔr umbi ugɛ umbi awuri ikpe ra arhimmbi. Umbi awuri ikpe, umbi aba ashimbi ri imangmang ugɛ umum iwu unga hã umum iki ĩgɔr ĩgɛ umum iwe.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Umbɔ adzipa agɛ, <<Ungo uwu ungamɔ?>> Uyesu agɛ, <<Umum iwe ru nyaka umum iki indɛyiwa umbi ri inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Umum iwu ra abina arhɛrhɛ umum iki irherhe ra atsimbi ni itsu umbi uvau. Bɔr uwuku adena umum awu undzumu uner idzidzɛrhe. Umum indɛyiwe anera ru upfung ubinkpi umum iki ĩgũ ru unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Umbɔ asi ihwɛngmbɔ ugɛ unga anu irherha arherhe ri itsi Utɛnga ra afã. ");
INSERT INTO ldb_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nggee Uyesu agɛ, <<Ivangyɛ umbi aka iberu Ungwɛ̃-Ner, ivang hã niyɔ umbi aka ihwɛng ugɛ awu umum iwu unga hã. Umbi awuri ihwɛngmbi ugɛ umum isi ikorhumum ubin ri ijee itsimum, bɔr umum irherhu abinkɛ Utɛ aka amesuwa umum ukpekũ. ");
INSERT INTO ldb_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Uwuku udena umum awu nggu umum, unga asi ínekanga umum ikiyikami, ubinkutsu ubɛn unum umum ikorhu ubinkpi unga aka agũibɛn.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Mɔcɛ anera arhɛrhɛ aka agũ arherha akɛrɛ atsu imangmangmbɔ ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Uyesu agɔr abi Uyahuda ha aka awuri imangmang ru unga agɛ, <<Umbi aba akpɔmmbi imesamum, umbi awuri iwe angwɛ̃ imesamum abi idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mɔcɛ umbi awuri ihwɛngmbi idzidzɛrhe, idzidzɛrhe iwuri ifɔnangge umbi.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Umbɔ agɔr unga agɛ, <<Umɛn iwu anang Uibrahim, umɛn inasi iwemɛn agãrhũ unera. Awu use utsu ungo ugɔr ugɛ umɛn ikpomɛn ififɔnmɛn?>> ");
INSERT INTO ldb_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Uyesu agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, uwuku utɔ̃itser arhim awu ugãrhã arhim. ");
INSERT INTO ldb_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ugãrhã ashia ra anang ugbagbaa ri iya, bɔr ungwɛ̃ awea ra anang ri iya ha ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nggee Ungwɛ̃ aba adzaanga umbi ififɔn, umbi akpombi ififɔn idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Umum ihwɛng umbi awu anang Uibrahim. Bɔr umbi abee ifɛr umum, ubinkutsu umbi asi iyɛimbi irhɛmmum. ");
INSERT INTO ldb_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Umum isɔma umbi ubinkpi umum iki inyã ivangyɛ umum iki iwu nggu Utɛmum, bɔr umbi akorhu abinkɛ umbi aka agũ ru utɛmbi.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Umbɔ agɛ, <<Uibrahim unga awu utɛmɛn.>> Uyesu agɛ, <<Umbi aba awu angwɛ̃ Uibrahim, umbi awuri itɔ̃mbi itser Uibrahim aka atɔ̃. ");
INSERT INTO ldb_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Iwu uner uwuku urherhi idzidzɛrhe umum iki igũ ru Unum, bɔr umbi abee ifɛre umum. Uibrahim asi ikorhunga ikpũ amɛn akɛrɛ ha. ");
INSERT INTO ldb_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Umbi amesi itser utɛmbi aki itɔ̃.>> Abi Uyahuda atsɛyi agɛ, <<Umɛn isi iwemɛn angwɛ̃ ugba. Unum ikiyikanga awu Utɛmɛn.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Uyesu agɔr umbɔ agɛ, <<Uba Unum unga awu Utɛmbi, uda umbi aba abemumbi umum, umum idzeku Unum ĩba, icɛrɛ umum iwu nggimi. Umum isi ĩbamum nibikami, bɔr unga adena umum. ");
INSERT INTO ldb_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Awu use utsu umbi asi igũ ataimbi ubinkpi umum iki irherhe? Ubinkutsu umbi asi ibeembi ikpeto ra arherhamum. ");
INSERT INTO ldb_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Umbi awu abi utɛmbi, Undenggũ hã, nu umbi abee itɔ̃ itser ubin utɛmbi aka abee. Unga awu uner uwuku ufɛyi aner udzur ri inggbaashia, akpɛ̃ɛ̃ idzidzɛrhe, nu idzidzɛrhe ishingge ru unga. Ivangyɛ unga iki igbɛyi angwĩ, unga arherhe idũnga niyɔ, ubinkutsu unga awu uner igbɛrangwĩ nu utei igbɛrangwĩ. ");
INSERT INTO ldb_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Bɔr umbi ashimbi ri imangmang ru umum, ubinkutsu umum isɔm idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ungamɔ ru umbi awuri isɔma uvau arhim ru umum? Umum ĩba irherhe idzidzɛrhe, awu use utsu umbi ashimbi ri imangmang ru umum? ");
INSERT INTO ldb_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Uwuruwi aka awe uwu Unum, aka isaka agɔm ikpeto ri irhɛm Unum iki irherhe. Umbi asi igũmbi ngge, ubinkutsu umbi asi iwembi abi Unum.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Abi Uyahuda agɔr unga agɛ, <<Asi iwea idzidzɛrhe umɛn iki igɔr ugɛ ungo uwu uner Usamariya uwuku uwe ru ipfu iyiki ibewe?>> ");
INSERT INTO ldb_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Uyesu agɛ, <<Umum ishimum ri ipfu iyiki ibewe, umum idzowe igɔng ru Utɛmum bɔr umbi asi idzaambi umum igɔng. ");
INSERT INTO ldb_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Umum isi ĩbeemum ikpoi itsimum, bɔr uwɔɔ ruwɔ abeenga ngge ru umum, nu unga hã awu uner uwuku utsu uvau. ");
INSERT INTO ldb_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Umum indɛyiwa umbi idzidzɛrhe, unera aba adɔsunga irhɛmmum, unga asi ínyãã akpe.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Abi Uyahuda agɔr unga agɛ, <<Icɛrɛ umɛn iki ihwɛngmɛn ugɛ ungo uweɔ ri ipfu iyiki ibewe! Uibrahim akpea nu abika asɔm Arherhu-Num akpembɔ, bɔr ungo ugɔr ugɛ, <Unera aba adɔsunga irhɛmmum, unga asi ínyãã akpe.> ");
INSERT INTO ldb_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ungo unango utɛmɛn Uibrahim? Unga akpea. Rimi hã abika asɔm Arherhu-Num akpembɔ. Ungo ukaifɛrhkɔ ugɛ ungo uwu use?>> ");
INSERT INTO ldb_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Uyesu agɛ, <<Umum ĩba ikpoi itsimum, ukpoimum usi iwekpɔ ubin. Utɛmum umbi aka agɔr agɛ awu Unummbi, awu unga akpoi umum. ");
INSERT INTO ldb_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Umbi asi ihwɛngmbi unga, bɔr umum ihwɛng unga. Umum iba ĩgɔr igɛ umum isi ihwɛng unga, umum iwu uner igbɛrangwĩ ru nyaka umbi. Bɔr umum ihwɛng unga, ni idɔsi irhɛmnga. ");
INSERT INTO ldb_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Utɛmbi Uibrahim agɔm anggɔm akarhãrhã ri ivangyɛ unga aka akaifɛrhkɔ inyã ivangyɛ umum iki ĩba. Unga anyã ngge na agɔm anggɔm.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Abi Uyahuda agɔr unga agɛ, <<Ungo unasi itsĩɔ imɛka isɔka itɔ̃ɔ̃ kata, nu ugɔr ugɛ ungo unyãɔ Uibrahim?>> ");
INSERT INTO ldb_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Uyesu agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, umum iwemum umbɔ adɔrha amar Uibrahim.>> ");
INSERT INTO ldb_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nggee umbɔ arhɔ̃ĩ atarh abee itang unga, bɔr Uyesu awoi itsinga adzek abɔruka Iya-Num hã. ");
INSERT INTO ldb_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Uyesu azɛ̃rhã atɔng na anyã uner uwɔɔ umbɔ aka amar unga itapa. ");
INSERT INTO ldb_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Angwɛ̃ imesanga arhusa unga agɛ, <<A umarhem, awu arhim uner uwurɛ use ateinga atsu umbɔ amar unga itapa?>> ");
INSERT INTO ldb_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Uyesu agɛ, <<Asi iwea arhim uner uwurɛ use aki ateinga. Amar unga itapa nu umbɔ adɛyiwe itser Unum ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Awu ufang umɛn itɔ̃ itseryɛ unga aka adena umum ri ivanga nu unuma una arhang umɔ. Utsuu ukpɔ ubarɔ ivangyɛ anera asi ídɛ̃ɛ̃ atɔ̃mbɔ itser. ");
INSERT INTO ldb_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ivangyɛ umum iki iwu ru upfunga, umum iwu irhirhang upfunga.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Unga aka arherhe rimi, unga atar aci ra abĩ, akayi abĩ nggu aci ha, na akũ abĩ hã atsu ake ra asu uner itapa ha. ");
INSERT INTO ldb_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Agɔr uner itapa ha agɛ, <<Uzĩ ru ukau Usirhuwam nu usorh asungo umɔ.>> Agben <<Usirhuwam>> agburh <<Adene unga.>> Nggee uner itapa ha azĩ asorh asunga, na abvui aba anyãã. ");
INSERT INTO ldb_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Andɔkanga nu abirabɛ aki inyã unga afɛn ifɛn arhusa agɛ, <<Asi iwea uner uwɛrɛ anu isei na afɛn ifɛn iyɛrɛ?>> ");
INSERT INTO ldb_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Abɔɔ agɛ, <<Awu unga.>> Abɔɔ agɛ, <<Ĩ'ĩ, ayɛiyɛi ukpekũ.>> Bɔr uner itapa ha agɛ, <<Awu umum uner ha nuwi.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Umbɔ arhusa unga agɛ, <<Ungo ukorhu uguse na asungo ayanga?>> ");
INSERT INTO ldb_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Unga agɛ, <<Uner ha umbɔ iki iyisa Uyesu unga akũ aci akayi abĩ atsuka ra asumum, na agɔr umum agɛ, <Uzĩ usorh asungo ru ukau Usirhuwam.> Umum izĩ isorh, mɔcɛ umum ikpo inyã anang.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Umbɔ arhusa unga agɛ, <<Uner ha awerɛ unga?>> Unga agɛ, <<Umum isi ihwɛng.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Mɔcɛ umbɔ akũ uner itapa ha asunga aka ayanga azĩmbɔ ra abi Ufarisi. ");
INSERT INTO ldb_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Awu ru unum ukpuku uwosha abi Uyahuda, Uyesu aka akayi abĩ hã akerhuwe asu uner itapa ha. ");
INSERT INTO ldb_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nggee abi Ufarisi arhusa unga akorhu uguse na anyã anang. Uner itapa ha agɛ, <<Unga akayi abĩ atsuka ra asumum nu umum isorhe ake ni inyã ananga.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Abi Ufarisi abɔɔ agɛ, <<Uner ha asi idzeka ru Unum, ubinkutsu unga asi itsamma unum ukpuku uwosha.>> Bɔr abɔɔ arhusa agɛ, <<Uner arhim awuri ikorha aguse na akorha abin idzeu nu atsar rimi?>> Nggee umbɔ agashumbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mɔcɛ abi Ufarisi abvui arhusu utsa ha agɛ, <<Ungo ugɔr ugɛ use ri itsi utsa ha? Awu asungo unga aka ayanguwa.>> Uner itapa ha agɛ, <<Unga awu uner uwuku usɔm Arherhu-Num.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Anggbaashi abi Uyahuda utsɛku icɛrɛ umbɔ ashimbɔ ri imangmang agɛ amar utsa ha nggu itapa, bɔr icɛrɛ unga aka anyã ananga. Akɛrɛ ha atsu umbɔ ayisa abika amar utsa ha. ");
INSERT INTO ldb_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Umbɔ arhusa agɛ, <<Uwɛrɛ awu ungwɛ̃mbi? Umbi aka agɔr agɛ amar unga itapa? Akorha aguse na anyã anang icɛrɛ?>> ");
INSERT INTO ldb_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Abika amar uner itapa ha agɛ, <<Umɛn ihwɛngmɛn uwɛrɛ ha awu ungwɛ̃ imarmɛn, ikɛi umɛn imar unga adzeka nggu itapa. ");
INSERT INTO ldb_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bɔr umɛn isi ihwɛngmɛn ubinkpi uku utsu unga anyã ananga icɛrɛ. Umɛn isi ihwɛngmɛn uwuku uyanguwe asunga. Àka arhusa unga. Unga asi iwea uwɛkuci. Unga awuri irherhunga ra angwĩnga.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Abika amar unga arherhe rimi ubinkutsu umbɔ agũ iwei anggbaashi abi Uyahuda. Abi Uyahuda agɛ kishoo uwuku ugɔr agɛ Uyesu awu Ukiristo, umbɔ awuri iwiwayiwe uner ha adzek ru ubã ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ngge itsu abika amar unga agɔr agɛ, <<Unga asi iwea uwɛkuci, àka arhusa unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ide uvaa abi Ufarisi abvui ayisu uner itapa ha aka akerhe, agɔr unga agɛ, <<Udzowe Unum igɔng nu urherhi idzidzɛrhe. Umɛn ihwɛngmɛn uner uwuku ukerhuwa ungo awu uner arhim.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Unga agɛ, <<Unga aba awu uner arhim, umum isi ihwɛng. Ubina unying umum iki ihwɛng, umum iwu itapa, icɛrɛ umum inyãmum ananga.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Mɔcɛ umbɔ arhusa unga ikɛi agɛ, <<Unga akorhuwa ungo use? Akorhu uguse na ayanguwa asungo?>> ");
INSERT INTO ldb_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Unga agɛ, <<Umum iki isɔmamum umbi, umbi asi ikpembi ato. Awu use utsu umbi abvui abee igigũ ikɛi? Use umbi abee iwu angwɛ̃ imesanga igambi?>> ");
INSERT INTO ldb_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mɔcɛ umbɔ arhenu utsa ha agɛ, <<Awu ungo uwu ungwɛ̃ imesanga! Umɛn iwu awɛ imesu Umusa. ");
INSERT INTO ldb_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Umɛn ihwɛngmɛn Unum arherhunga arherhe nggu Umusa, bɔr utsak uwurɛ umɛn isi ihwɛngmɛn anangkɛ unga aka adzek.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Utsa ha agɛ, <<Akɛrɛ awu ubin idzeu! Umbi asi ihwɛngmbi anangkɛ unga aka adzek, bɔr ayanguwanga asumum! ");
INSERT INTO ldb_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Umɛn ihwɛngmɛn Unum aka isaka asi igũa abi arhim. Bɔr aka isaka agũa abi iwei unga na atɔ̃ itsernga. ");
INSERT INTO ldb_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Utirhi ri imimunu upfunga unera anasi igũa umbɔ ayangukumbɔ asu unerwi umbɔ aka amar unga nggu itapa. ");
INSERT INTO ldb_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Utsak uwurɛ aba asi idzeku Unum abanga, asi ídɛ̃ɛ̃ akorhunga ubin.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Akɛrɛ atsu umbɔ agɔr unga agɛ, <<Ungo umbɔ aka amar ra arhim, nu ungo ubee imesuwa umɛn?>> Umbɔ awayikumbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Uyesu agũ isarhunga ugɛ umbɔ aka awayikumbɔ utsa ha. Ivang Uyesu aka akpo utsa ha, unga arhusa unga agɛ, <<Ungo uweɔ ri imangmang ru Ungwɛ̃-Ner?>> ");
INSERT INTO ldb_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Uner itapa ha aka akerhe arhusa agɛ, <<A uteiya, awu ungamɔ? Udɛyiwa umum nu umum iwe ru imangmang ru unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Uyesu agɔr unga agɛ, <<Ungo unyãɔ unga icɛrɛ. Awu unga adɛ̃ɛ̃ arherhe nggu ungo.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Mɔcɛ utsa ha agɛ, <<A Uteijee, umum iwemum ri imangmang,>> na adzowe unga igɔng. ");
INSERT INTO ldb_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Uyesu agɛ, <<Umum itsĩwã itsu uvau ru upfung ukpirɛ, ngge itsú abi itapa anyã, abika anyunyã ikɛi awe abi itapa.>> ");
INSERT INTO ldb_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Abi Ufarisi ha abika akhapa ru unga aka agũ rimi, umbɔ agɔr unga agɛ, <<Umɛn iwu abi itapa igamɛn?>> ");
INSERT INTO ldb_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Uyesu agɛ, <<Umbi aba awu abi itapa, umbi asi iwembi ru uvau arhim, bɔr umbi agɔr agɛ umbi adɛ̃ɛ̃ anyãmbi, nggee arhimmbi awe umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","<<Umum indɛyiwa umbi idzidzɛrhe, unerwi aka asi itsĩa ra angwĩ ugbor idɔi, bɔr na afũ udika afɛn akase atsĩ, uner ha awu uvɛu nu uwuku uvui abin. ");
INSERT INTO ldb_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Unerwi aka atsĩ ra angwĩ ugbora unga awu uner ughãwã idɔi ha. ");
INSERT INTO ldb_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Uner uwuku udzɛu angwĩ ugbora aka isaka atsuruwe angwĩ ugbora ru unga. Ídɔi ha ikɛi iki isaki ikpeto ru urhɛmnga. Unga aka isaka ayisi ídɔinga nggu atsokngge akũ adzeka awiya. ");
INSERT INTO ldb_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ivangyɛ unga aka ikũ iyinga adzek, unga agbaashia nu ídɔinga idɔsa unga, ubinkutsu ngge ihwɛngngge urhɛmnga. ");
INSERT INTO ldb_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bɔr isi ídɔsungge utsen, ngge iwuri itĩ, ubinkutsu ngge imɔrngge urhɛm utsen.>> ");
INSERT INTO ldb_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Uyesu akũ nyaka arherhe akɛrɛ asɔme anera, bɔr umbɔ asi ihwɛngmbɔ ubin unga aka arherhuwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nggee Uyesu ikɛi agɔr umbɔ agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, awu umum iwu angwĩ ugbor ídɔi ha. ");
INSERT INTO ldb_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Kishoo abika agbaashia aba ru umum ĩdɔrhi ĩba awu avɛu nu abika avui abin, bɔr ídɔi ha isi idɔsungge umbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Awu umum iwu angwĩ ugbora. Ubɛn unera aka atsĩ ru ubokmum awuri ikpoa ififɔrh, awuri itsĩ na adzek akpo ubĩĩ uku uze. ");
INSERT INTO ldb_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Uvɛu aba ivivɛu na afɛre na adakuwe. Umum ĩba ru umbɔ akpo urhɛ, akpo umgbɔ uku kpengkpeng. ");
INSERT INTO ldb_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","<<Awu umum iwu uner idzɛu uwuku uze ha. Uner idzɛu uwuku uze ha adzowe urhɛnga ri ídɔinga. ");
INSERT INTO ldb_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Unerwi iki itɔ̃ itser imang asi iwea uner idzɛu, ídɔi ha ikɛi isi iwengge iyinga. Ivangyɛ unga aka inyã ijui ngbako iki itĩ iba, unga awuri ineke idɔi ha na atĩã. Ijui ngbako ha idzui ngge ni isituwe ngge. ");
INSERT INTO ldb_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Uner ha awuri itĩ, ubinkutsu unga atɔ̃ itser imang ukpekũ nu ubin usi íghongkpɔ amɛnnga ri idzɛu ídɔi ha. ");
INSERT INTO ldb_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","<<Awu umum iwu uner idzɛu uwuku uze. Umum ihwɛng ídɔimum nu ídɔimum ihwɛngngge umum. ");
INSERT INTO ldb_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Rimi hã Utɛmum ahwɛnga umum nu umum ihwɛng Utɛ, ni iwuri indzowukũ urhɛmum ri ídɔi ha. ");
INSERT INTO ldb_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Iwemum ri ídɔi iyɔɔ iki isi iwengge iyi ugbor idɔi ukpirɛ. Awu ufang umum ikũna ngge ĩba ikɛi. Ngge iwuri ikpengge ato ru urhɛmmum, ni ídɔi ha iwuri iwu ukpusha unying uner ughãwã unying. ");
INSERT INTO ldb_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Utɛ abema umum ubinkutsu umum iwuri ingwɛ̃we urhɛmum, ugɛ umum ibvui inyanga umgbɔ ikɛi. ");
INSERT INTO ldb_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Unera asi ívura urhɛmum, umum nibikami iwuri ingwɛ̃we umgbɔ. Iwemum ri ijee iyiki ingwɛ̃we umgbɔ nu ijee iyiki inyanga umgbɔ ikɛi. Awu Utɛmum atsu umum ikorhe akɛrɛ ha.>> ");
INSERT INTO ldb_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Irhɛm arherhe iyɛrɛ itsu abi Uyahuda agasha nggu adɔka ikɛi. ");
INSERT INTO ldb_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Anera arhɛrhɛ agɛ, <<Awea ri ipfu iyiki ibewe ngge itsu unga ukpong. Awu use utsu umbi akpeto ru unga?>> ");
INSERT INTO ldb_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bɔr abɔɔ agɛ, <<Ĩ'ĩ, arherhe akɛrɛ asi iweke aki uner uku uwe nggu ipfu iyiki ibewe. Ipfu iyiki ibewe idɛ̃ɛ̃ iyangungge asu uner itapa?>> ");
INSERT INTO ldb_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Awu ri ivang umbɔ aka adɛ̃ɛ̃ Irhowa iyiki Iyɛruwe Iya-Num ru Urusharhima, ");
INSERT INTO ldb_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Uyesu azɛ̃rhã ru angwĩ iya Usorhomon ri Iya-Num hã. ");
INSERT INTO ldb_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Abi Uyahuda akɔng adziir unga agɛ, <<Utsɛku ukang ungo uku ineka umɛn ri icicang? Ungo uba uwu Ukiristo, udɛyiwa umɛn ra awiya.>> ");
INSERT INTO ldb_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Uyesu agɛ, <<Umum iki idɛyiwamum umbi, umbi ashimbi ri imangmang. Abin idzeukɛ umum iki ikorhe ri itsok Utɛmum, ake adɛyiwe umum iwu ungamɔ. ");
INSERT INTO ldb_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bɔr umbi ashimbi ri imangmang, ubinkutsu umbi asi iwembi ídɔimum. ");
INSERT INTO ldb_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ídɔimum ikpeto ru urhɛmmum, umum ihwɛng ngge, ngge idɔsa umum. ");
INSERT INTO ldb_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Umum ĩdzowe ngge urhɛ uwu ugbagbaa, ngge isi íkpengge ugbagbaa, unera asi ívura ngge ru ubokmum. ");
INSERT INTO ldb_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Utɛmum uwuruwi aka adzaa ngge ru umum, unga ananga kishoo. Unera asi ídɛ̃ɛ̃ avura ngge ru ubok Utɛmum. ");
INSERT INTO ldb_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Umum nu Utɛ iwu unying.>> ");
INSERT INTO ldb_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Abi Uyahuda abvui arhɔ̃ĩ atarh abee itang unga. ");
INSERT INTO ldb_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Bɔr Uyesu agɔr umbɔ agɛ, <<Umum iki ikorhuwamum umbi abin idzeu arhɛrhɛ akika agɔng aka adzeku Utɛ. Akikasong awuri itsu umbi afɛre umum nggu atarh?>> ");
INSERT INTO ldb_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Abi Uyahuda agɔr unga agɛ, <<Asi iwea itser iyiki izengo itsu umɛn ibee itang atarh ru ungo, bɔr arherhe urhenango ru Unum, ubinkutsu ungo uwu unera nu unyangi itsingo uwu Unum.>> ");
INSERT INTO ldb_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Uyesu agɔr umbɔ agɛ, <<Asi itsɛngmbɔ ri Íkpemmbi ugɛ Unum agɔr agɛ, <Umum igɔr ugɛ umbi awu anum>? ");
INSERT INTO ldb_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Itsɛng Arherhu-Num iwu idzidzɛrhe. Uba unga ayisa abika adzowe Arherhu-Num agɛ <anum>, ");
INSERT INTO ldb_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","mɔcɛ umbi agɔr aguse ri itsi uwu ha Utɛ aka atsũ unga awu uwu unga na adene unga aba ru upfunga? Awu use utsu umbi agɔr ugɛ umum ini irhenu Unum ri ivangyɛ umum iki irherhe ugɛ, <Umum iwu Ungwɛ̃ Unum>? ");
INSERT INTO ldb_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Uba umum isi ikorhumum abinkɛ Utɛmum aki ikorhe, àka aneke iwe ru imangmang ru umum. ");
INSERT INTO ldb_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bɔr umum ĩba ikorha ake, umbi aba ashimbi ri imangmang ru umum, àka awe ru imangmang ra abin idzeu ha umum iki ikorhe, na ahwɛng agɛ Utɛ awea ru umum, nu umum iwemum ru Utɛ.>> ");
INSERT INTO ldb_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ikɛi umbɔ abee idzur unga, bɔr unga ashɔɔta ra abokmbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mɔcɛ Uyesu abvui agar Azɛ̃ Urdun azĩã anangkɛ Uyohana aka asorhuwe ubɔtisima isha na aseisa umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Umɔ anera arhɛrhɛ aka aba ru unga. Anera ani igɔr ugɛ, <<Uyohana anasi ikorhunga atsar abin idzeu, bɔr kishoo abinkɛ unga aka arherhe ri itsi utsak uwurɛ awu idzidzɛrhe.>> ");
INSERT INTO ldb_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ra anang hã anera arhɛrhɛ aka awe ru imangmang ru Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Unera nuwɔ itsoka igburh Urhiazaru aghonga unga. Awu ru uteu Ubetani, uku uwu uteumbɔ Umaryamu nu Umarta unapumbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Urhiazaru uwuku ughong hã awu ungwɛ̃mbɔ Umaryamu, uwuku udzukuwe atsei isung nú Uteijee, na akũ igwar itsinga afire adaknga. ");
INSERT INTO ldb_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nggee anaa uyi ha ikivarhambɔ adene itser ru Uyesu agɛ, <<A Uteijee, uwu ha ungo uku ubema aghonga unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ivang Uyesu aka agũ rimi unga agɔr agɛ, <<Irhãrhã hã isi ítsu unga akpea, bɔr iwuri ikũ ikpikpoi iba ru Unum nu Ungwɛ̃nga ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Uyesu abemu Umarta nu unapumbɔ nu Urhiazaru. ");
INSERT INTO ldb_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Bɔr ivangyɛ unga aka agũ ugɛ Urhiazaru aghonga unga, unga atoma aseisa inuma ivaa ru nggɔɔ ha. ");
INSERT INTO ldb_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Mɔcɛ unga agɔr angwɛ̃ imesanga agɛ, <<Umɛn ibvui izĩ Uyahudiya.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Angwɛ̃ imesanga hã agɛ, <<A umarhem, inum iyɛrɛ abi Uyahuda abee ifɛre ungo nggu atarh, nu ungo ubvui uzĩ nggɔɔ ha?>> ");
INSERT INTO ldb_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Uyesu agɛ, <<Asi iwea akara usɔkdũmɛn ru unuma unying ishaa unum iki irhang? Kishoo uwuku uzɛ̃rhã ra atenum asi íkwɛra itok, ubinkutsu, unga anyãã irhirhang upfung ukpirɛ. ");
INSERT INTO ldb_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bɔr uwuku uzɛ̃rhã ru utsuu awuri ikwɛra itok, ubinkutsu irhirhang ishingge ru unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ivangyɛ Uyesu aka arherha abina akɛrɛ amaa, unga atoma agɔr umbɔ agɛ, <<Uwɛrhamɛn Urhiazaru aka arharhɔ, bɔr umum izĩ izita unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Angwɛ̃ imesanga hã agɛ, <<A Uteijee, aba awu urhɔ, unga awuri ikerhunga.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ubin Uyesu aka arherhe agɛ Urhiazaru aka akpea, bɔr angwɛ̃ imesanga akaifɛrhkɔ agɛ unga arherha arherhe urhɔ uwuku uwosha. ");
INSERT INTO ldb_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nggee Uyesu adɛyiwe umbɔ ukupɛ̃ɛ̃ agɛ, <<Urhiazaru aka akpea. ");
INSERT INTO ldb_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Umum igɔm umum iki isi iwemum umɔ, ngge ima itsu umbi awe ru imangmang. Bɔr umɛn izĩmɛn ru unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mɔcɛ Utoma, uwuruwi umbɔ iki iyisa unga Akãrhghwɛ̃, agɔr abimbɔ angwɛ̃ imesa ha agɛ, <<Umɛn izĩmɛn ikɛi, nu umɛn ikpe nggu unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ivangyɛ Uyesu aka azĩ atsĩ, agũ ugɛ Urhiazaru aka akpea, umbɔ aka adzake unga, aka amaa inuma inaa ru udzak. ");
INSERT INTO ldb_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ubetani ukhapa nggu Urusharhima, asi itsĩa akirhomita ataar. ");
INSERT INTO ldb_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Abi Uyahuda arhɛrhɛ aba ighwe akpe Urhiazaru ru anapumbɔ na adɔnge amɛn Umarta nu Umaryamu. ");
INSERT INTO ldb_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ivangyɛ Umarta aka agũ ugɛ Uyesu uwɔ abarɔ, unga asok azĩ agbanga unga. Bɔr Umaryamu asei ri iya. ");
INSERT INTO ldb_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Umarta agɔr Uyesu agɛ, <<A Uteijee, agɛ ungo uwu nggimi ungwɛ̃mɛn asi íkpea. ");
INSERT INTO ldb_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bɔr uko icɛrɛ umum ihwɛng Unum awuri idzaanga kishoo ubinkpi ungo iki ishɔ̃rhã unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Uyesu agɔr unga agɛ, <<Ungwɛ̃mbi awuri isoka ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Umarta agɛ, <<Umum ihwɛng awuri ibɛka ikɛi ri isisok abika akpukpe ri imimashu upfung.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Uyesu agɔr unga agɛ, <<Awu umum iwu isisok abika akpukpe, ikɛi awu umum iwu urhɛ. Uwuruwi aka awea ri imangmang ru umum unga awuri ibɛka, uko unga aka akpea. ");
INSERT INTO ldb_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Uwuruwi aka abɛk na awea ri imangmang ru umum asi íkpea ugbagbaa. Ungo uweɔ ri imangmang akɛrɛ?>> ");
INSERT INTO ldb_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mɔcɛ Umarta agɛ, <<Ĩĩ, Uteijee, umum iwemum ri imangmang ugɛ awu ungo uwu Ukiristo ha, Ungwɛ̃ Unum uwuruwi umɛn iki ifosa ugɛ unga ibanga ru upfung.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ivangyɛ Umarta aka arherhe rimi, unga abvui azĩ ayisu unapumbɔ Umaryamu agɛ, <<Umarhem aka abanga na ayisa ungo.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ivangyɛ Umaryamu aka agũ rimi, unga asok ifefetem azĩã ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Uyesu anasi itsĩa ru utepa kata. Unga ana awu ra anangkɛ Umarta aka agbanga unga. ");
INSERT INTO ldb_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ivang abi Uyahuda abika asei ifaakpe ri iya Umaryamu aka anyã unga asok iki ifefetem adzek, umbɔ adɔsa unga akaifɛrhkɔ agɛ unga awuri izĩ ra anang udzaka na aciu akpe umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ivang Umaryamu aka azĩ atsĩ ra anangkɛ Uyesu aka awe, unga aka anyã unga, unga agba anu ra adak Uyesu na agɛ, <<A Uteijee, agɛ ungo uwu nggimi, ungwɛ̃mɛn asi íkpea.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ivang Uyesu aka anyã unga aciu akpe, nu abi Uyahuda ha aka aba nggu unga aciu akpe igambɔ, mɔcɛ amɛn Uyesu aghong akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Unga arhusa agɛ, <<Umbi adzake unga rinɛɛ?>> Umbɔ agɛ, <<A Uteijee, uba unyã.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Uyesu aciu akpe. ");
INSERT INTO ldb_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Mɔcɛ abi Uyahuda agɛ, <<Àka anyã ikpũ ibibemayɛ unga aka awerangge ru Urhiazaru!>> ");
INSERT INTO ldb_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Bɔr abɔɔ ru umbɔ agɛ, <<Unga ayanguwe asu uner itapa uwɔrɔ. Awu use utsu unga asi ikorhunga ubin ukpɔɔ iki ikɛn utsak uwurɛ ikpikpe?>> ");
INSERT INTO ldb_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Uyesu abvui agũ ighong ra amɛnnga akarhãrhã. Azĩã ru udzak ha. Udzak ha uwu utai. Akũ ubatu utarh afɔme angwĩ udzaka. ");
INSERT INTO ldb_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Uyesu agɛ, <<Àka aberuwe utarh ha.>> Bɔr Umarta, unapumbɔ uwuku akpukpe ha, agɔr Uyesu agɛ, <<A Uteijee, icɛrɛ aka awu anunukawɔ. Irherɛ unum unaa nukpi unga aka akpe.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Mɔcɛ Uyesu agɛ, <<Isi isɔmamum ungo ugɛ ungo uba uweɔ ri imangmang, ungo uwuri inyãɔ̃ igɔng Unum?>> ");
INSERT INTO ldb_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nggee umbɔ atsimuwe utarh ha. Uyesu abera asunga afafã na agɛ, <<A Utɛ, umum itar uwɛɛ ungo uku ugũo umum. ");
INSERT INTO ldb_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Umum ihwɛng ubɛn unum ungo ugũo umum, bɔr umum irherhe rimi ru anera abika adɛ̃ɛ̃ nggimi awe ru imangmang ugɛ awu ungo udena umum ĩba.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ivangyɛ unga aka arherhe rimi, Uyesu atsarhi irhaknga ikerketangge agɛ, <<A Urhiazaru, udzeka!>> ");
INSERT INTO ldb_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Uner uwuku ukpe ha adzeka, adaknga na aboknga abow nggu atatorho, asunga ikɛi abɛrh nggu atorho. Uyesu agɔr umbɔ agɛ, <<Àka agarhuwe unga azĩã.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nggee abi Uyahuda arhɛrhɛ aka aba ighwe akpe ru Umaryamu na anyã ubinkpi Uyesu aka akorhe, umbɔ awe ru imangmang ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bɔr abɔɔ azĩmbɔ ra abi Ufarisi, adɛyiwe umbɔ ubinkpi Uyesu aka akorhe. ");
INSERT INTO ldb_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mɔcɛ ateiya abika adzowe idɛm-Num nu abi Ufarisi akɔng anggbaashi abi Uyahuda. Arhusa adɔka agɛ, <<Umɛn ikorhu usemɛn? Utsak uwurɛ anu ikorha atsar abin idzeu arhɛrhɛ! ");
INSERT INTO ldb_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Umɛn ĩba ineke unga akorhunga abin hã, anera kishoo awuri iwe ru imangmang ru unga. Mɔcɛ abi Uroma awuri iba avurmbɔ abĩmɛn nu Iya-Nummɛn ikɛi!>> ");
INSERT INTO ldb_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Bɔr unying ru umbɔ agburh Ukayafa Ukugɔng Uwuku Udzowe Idɛm-Num ra amɛk aki ha, agɔr umbɔ agɛ, <<Umbi asi ihwɛngmbi ubin! ");
INSERT INTO ldb_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Umbi asi irhi ataimbi ugɛ ugba unera unying akpe ri itsi anera, nu abĩmɛn aki itsim.>> ");
INSERT INTO ldb_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Arherha ha Ukayafa aka arherhe asi iweke ifɛrhkɔ amɛnnga, bɔr unga aka awu Ukugɔng Uwuku Udzowe Idɛm-Num ra amɛk ha na asɔm Arherhu-Num ugɛ Uyesu awuri ikpe ri itsi aner abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Unga asi íkpea ra abi Uyahuda ukpekũ, bɔr unga awuri ikɔng aner Unum abirabɛ aka asita ru upfunga umbɔ awu unying. ");
INSERT INTO ldb_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nggee udzur ru unum hã anggbaashi abi Uyahuda avarhi ifɛr Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nggee Uyesu asi ibvui azɛ̃rhũnga ra abi Uyahuda ukupɛ̃ɛ̃, bɔr asoka ra anang hã, azĩã abĩkɛ aka akhapa ra arhum. Atsĩã uteu ukpɔɔ umbɔ iki iyisa Uifrayim na aseisa umɔ nggu angwɛ̃ imesanga. ");
INSERT INTO ldb_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Irhowa Iyiki Igar Utɔng iyi abi Uyahuda iki iyok. Anera arhɛrhɛ aka adzeki iteu iki ici azĩ Urusharhima, ugɛ umbɔ asare atsimbɔ ru irhowa ha idɔrhi iwe. ");
INSERT INTO ldb_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Atɛ̃wã abee Uyesu, adesa ra Iya-Num anu irhusa adɔka agɛ, <<Umbi akaifɛrhkɔ use? Awuri ibanga irhowa ha idĩã?>> ");
INSERT INTO ldb_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bɔr ateiya abika adzowe idɛm-Num nu abi Ufarisi aka adzowukumbɔ itser ugɛ kishoo uwuku uhwɛng anangkɛ Uyesu aka awe, unga aba asɔme umbɔ nu umbɔ azĩ adzur unga. ");
INSERT INTO ldb_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Irhowa Iyiki Igar Utɔng ibɔr inuma utɔ̃ĩ, Uyesu atsĩ Ubetani, anangkɛ unga aka azituwe Urhiazaru ra akpe. ");
INSERT INTO ldb_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Umɔ umbɔ aka akorhuwe Uyesu ubingha urhɛɛ. Awu Umarta unga agashu ubingha ha, Urhiazaru awu unying ra anera abika agha ubingha ha nggu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mɔcɛ Umaryamu anyangu ungwɛ̃rhũ undzoma atsei isung aki imang umbɔ aka akũ unardi agbisha na adzukuwe ra adak Uyesu. Mɔcɛ unga akũ igwar itsinga afire. Isung iyiki ize iyi atsei ha imaangge iya kishoo. ");
INSERT INTO ldb_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Bɔr Uyahuda Uiskariyoti, unying ra angwɛ̃ imesanga, uwuruwi aka igha-daknga, agɔr agɛ, ");
INSERT INTO ldb_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","<<Awu use utsu umbɔ asi igoshukumbɔ atsei isung hã akirakɛ imanga iki iwu iyi uner itser ra amɛka, na adzowukumbɔ imanga ra atsũwã?>> ");
INSERT INTO ldb_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ubinkutsu unga arherhe rimi, asi igũã ighong atsũwã, bɔr ubinkutsu unga awu uvɛu. Unga akpɔm ijari imangmbɔ, unga aka isaka ayikuka itsinga ri imang hã. ");
INSERT INTO ldb_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Uyesu agɛ, <<Àka aneke unga. Unga aden ake adzɛu unumkpi umbɔ aka idzake umum. ");
INSERT INTO ldb_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Atsũwã awu nggu umbi ubɛn unum, bɔr umbi asi íwembi nggu umum ubɛn unuma.>> ");
INSERT INTO ldb_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ri ivang hã ikikɔng abi Uyahuda irhɛirhɛ iki igũ ugɛ Uyesu awu umɔ, umbɔ aba. Asi ibambɔ inyã Uyesu ikiyikanga, bɔr abee inyã Urhiazaru uwu ha Uyesu aka azituwe unga ra akpe. ");
INSERT INTO ldb_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ateiya abika adzowe idɛm-Num avarhe ifɛre Urhiazaru ikɛi. ");
INSERT INTO ldb_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ubinkutsu awu arherhe Urhiazaru ake atsu abi Uyahuda arhɛrhɛ ani idzipa awe ru imangmang ru Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ukpe unum uvaa anera arhɛrhɛ aka aba Irhowa Iyiki Igar Utɔng agũ ugɛ Uyesu awu ru utsĩndĩ uwuku uba Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Umbɔ arhɔ̃ĩ angbɔk irhek, akũ azĩ agbopa unga, atsarhi irhakmbɔ agɛ, <<Ikpikpoi iwe ru Unum! Idorh Unum iwu nggu uwu ha aka aba ri itsok Uteijee, idorh Unum iwu nggu uyɛrhe Uisrairha!>> ");
INSERT INTO ldb_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Uyesu aka akpo ungwɛ̃ uzhika unga afũ asei nú umgbɔ, ru nyaki itsɛng Arherhu-Num igɔr ugɛ, ");
INSERT INTO ldb_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","<<Niba agũmbi iwei, umbi aner Urusharhima. Uyɛrhambi uwɔ aba nú undzing ungwɛ̃ uzhika!>> ");
INSERT INTO ldb_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ri inggbaashia angwɛ̃ imesanga asi ihwɛngmbɔ kishoo abin hã. Bɔr ivang Unum aka asoyiwe Uyesu ra akpe na akpoi unga, mɔcɛ umbɔ ayita ugɛ atsɛngmbɔ abin hã ri itsinga, nu abin hã akorhuke ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Anerabɛ aka awu nggu unga ri ivangyɛ unga aka ayisu Urhiazaru unga adzeka ru udzak na azituwe unga ra akpe, ani idekuwe anera ubinkpi Uyesu aka akorhe. ");
INSERT INTO ldb_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Anera arhɛrhɛ aka azĩ agbangu Uyesu ubinkutsu umbɔ agũ utsar ubin idzeu ha unga aka akorhe. ");
INSERT INTO ldb_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Nggee abi Ufarisi arherhe arherhe nggu adɔkambɔ agɛ, <<Àka anyã, umɛn isi ighamɛn inggbaashi. Nggayɛ kishoo upfunga adɔsa unga!>> ");
INSERT INTO ldb_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Icɛ abɔɔ rabɔ abi Uherhini aka aba idzowe igɔng ri irhowa. ");
INSERT INTO ldb_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Umbɔ aba ru Ufirhibu, uner Ubetsaida ru Ugarhirhi, arhusa unga agɛ, <<A Uteiya, umɛn ibee inyã Uyesu.>> ");
INSERT INTO ldb_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ufirhibu azĩ asɔmuka Uandarawu. Umbɔ ikivarhambɔ azĩ asɔmukumbɔ Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Uyesu agɔr umbɔ agɛ, <<Ivang iyiki ikpoi Ungwɛ̃-Ner iki iwengge. ");
INSERT INTO ldb_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Umum indɛyiwa umbi idzidzɛrhe, umbɔ aba asi inaambɔ ishaa itsem ra abĩ ngge ikpengge, ngge iwe ikiyikangge. Bɔr ngge iba ikpengge, ngge ighwɛr ishaanga irhɛirhɛ. ");
INSERT INTO ldb_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Uwuruwi aka abemu urhɛnga, umgbɔ uwuri igwirmgbɔ. Bɔr uwuruwi aka akpɛ̃ɛ̃ urhɛnga ru upfung ukpirɛ, awuri iwe ru urhɛ uwu ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ubɛn uwuku utɔ̃ itsermum, awu ufang unga adɔsa umum. Nu anangkɛ umum iki iwe, ugãrhãmum ikɛi awuri iwe umɔ. Utɛmum awuri itomuka imor ru uwu ha aka awu ugãrhãmum. ");
INSERT INTO ldb_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","<<Icɛrɛ umum ĩgũ ighong ra amɛnmum. Umum ĩgɔr ugɛ use? <A Utɛ, ufɔrh umum ri ivang iyɛrɛ>? Ĩ'ĩ, awu ubin ivang iyɛrɛ itsu umum ĩba. ");
INSERT INTO ldb_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","A Utɛ, ukũ ikpikpoi uba ri itsokngo!>> Mɔcɛ urhɛm udzeka afã ugɔr ugɛ, <<Umum iki ikpoishũ ike, ni ibvui ikpikpoimum ike ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Anera abika adɛ̃ɛ̃ umɔ aka agũ urhɛm hã, umbɔ agɛ inai irhare. Abɔɔ agɛ, <<Ipfu itser-Num ngge irherha arherhe nggu unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Uyesu agɛ, <<Urhɛm ukpirɛ uba ru umbi, usi ibakpɔ ru umum. ");
INSERT INTO ldb_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Icɛrɛ awu ivangyɛ umbɔ aka ivarha arherhe ru upfung ukpirɛ. Icɛrɛ umbɔ aka awuri iwayiwe uyɛrhe upfung ukpirɛ. ");
INSERT INTO ldb_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bɔr ivangyɛ umbɔ aka ibera umum ra abĩ, umum uwuri idarha anera kishoo umbɔ aba ru umum.>> ");
INSERT INTO ldb_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Unga arherhe akɛrɛ adɛyiwe ikpũ akpekɛ unga aka ikpe. ");
INSERT INTO ldb_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Anera agɔr agɛ, <<Íkpemmɛn idɛyiwa umɛn igɛ Ukiristo awuri ibɛk ugbagbaa. Mɔcɛ awu use utsu ungo ugɔr ugɛ awu ufang umbɔ aberuwe Ungwɛ̃-Ner? Ungamɔ awu Ungwɛ̃-Ner ha?>> ");
INSERT INTO ldb_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mɔcɛ Uyesu agɔr umbɔ agɛ, <<Irhirhang hã iwu nggu umbi ivanga ukunjiir. Àka azɛ̃rhã ri irhirhang hã, utsur uzĩ unangkpɔ umbi. Uner uzɛ̃rhã ru uzĩ amɔra anangkɛ unga aka izĩ. ");
INSERT INTO ldb_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ivang umbi aka ana awe nggu irhirhang hã àka awe ru imangmang ri ngge, ugɛ umbi ama awu angwɛ̃ irhirhang hã.>> Ivang Uyesu aka amaa arherhe, unga azĩ awoinga ri inyĩnyãmbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Uko arhɛrha atsar abin idzeu ha Uyesu aka akorhe ra asumbɔ, utsɛku icɛrɛ umbɔ ashimbɔ ri imangmang ru unga. ");
INSERT INTO ldb_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Akɛrɛ ha akorhe rimi ngge itsuifɛr ubinkpi uner uwuku usɔm Arherhu-Num Uishaya aka arherhe agɛ, <<A Uteijee, ungamɔ awe ru imangmang ri isarhamɛn? Ru ungamɔ ikɛi umbɔ aka adɛyiwe ijee Uteijee?>> ");
INSERT INTO ldb_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ngge itsu umbɔ asi idɛ̃ɛ̃ awembɔ ri imangmang, ru nyaku Uishaya aka arherhe ra anang akɔɔ agɛ, ");
INSERT INTO ldb_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","<<Unga aka atsu umbɔ itapa na abĩruwe amɛnmbɔ, ngge itsú umbɔ asi ínyãmbɔ nggu asumbɔ, na asi íhwɛngmbɔ ra amɛnmbɔ, na asi ídzipumbɔ ru umum ikerhuwe umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Uishaya arherhe rimi ubinkutsu unga anyã ikpikpoi Uyesu, na arherhunga arherhe ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Rimi hã anera arhɛrhɛ aka awe ru imangmang ru Uyesu, nu anggbaashimbɔ arhɛrhɛ aka awe ru imangmang ru unga. Bɔr umbɔ asi irherhumbɔ ukupɛ̃ɛ̃, umbɔ agũ iwei abi Ufarisi aka iwayiwe umbɔ ru ubã ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ubinkutsu umbɔ abema ikpikpoi iyi anera anangmbɔ ikpikpoi iyi Unum. ");
INSERT INTO ldb_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Mɔcɛ Uyesu atsarhi irhaknga agɛ, <<Ivang unera aka awe ru imangmang ru umum, asi iwea ri imangmang ru umum ukpekũ, bɔr nggu uwuku udena umum ĩba. ");
INSERT INTO ldb_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ivangyɛ unga aka irhi umum, awuri inyã uwu ha aka adena umum ĩba. ");
INSERT INTO ldb_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Umum ĩba ru nyaki irhirhang ru upfung, ngge itsú kishoo uwuku uwe ru imangmang ru umum asi íseisa ru uzĩ. ");
INSERT INTO ldb_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","<<Uwuku ugũ irhɛmmum bɔr asi idɔsunga, asi iwea umum iwuri itsuke unga uvau. Umum isi ĩbamum itsu uvau ru upfung, bɔr umum ĩba ififɔrh ukpɔ. ");
INSERT INTO ldb_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Uwuruwi aka akpɛ̃ɛ̃ umum na asi iyɛsa arherhamum awea ru uwuku utsu unga uvau. Arherha ha umum iki irherhe awuri itsuke unga uvau ru unum ukpuku umasha. ");
INSERT INTO ldb_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ubinkutsu, umum isi irherhumum ubinkpi umum iki ibee, bɔr Utɛ uwuku udena umum unga atsuka ubinkpi umum iki irherhe nu utsĩndĩwi umum iki irherhe. ");
INSERT INTO ldb_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Umum ihwɛng arherhanga awuri ikũ urhɛ uwu ugbagbaa aba. Nggee ubɛn ubinkpi umum iki irherhe, umum irherhe ubinkpi Utɛ aka adɛyiwa umum irherhe.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Irhowa Iyiki Igar Utɔng inasi iwengge. Uyesu aka ahwɛnga ugɛ ivanga iki iwengge unga aka ibɔre upfung ukpirɛ na abvui azĩ ru Utɛ. Unga aka abema anernga aka awe ru upfung, uko uzĩ utsĩ imimashu urhɛnga. ");
INSERT INTO ldb_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Uyesu nu angwɛ̃ imesanga aka asei igha urhɛɛ. Undenggũ aka atsukuka ra amɛn Uyahuda Uiskariyoti ungwɛ̃ Usiman unga agha-dak Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Uyesu ikɛi ahwɛnga ugɛ Utɛ atsuke abina kishoo ru uboknga. Ahwɛnga unga adzeku Unum aba, ikɛi unga abvui azĩ ru Unum. ");
INSERT INTO ldb_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ivang umbɔ aka asei igha ubingha, Uyesu asok atsimuwe atorhanga aki awiya na anyangu utawurh abow ru upfurhsĩnga. ");
INSERT INTO ldb_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Mɔcɛ unga atsu amɛ̃ ri itɛ̃rhãzɔu na atirhi isorh adak angwɛ̃ imesanga, na akũ utawurh ukpu upfurhsĩnga hã awɔnge. ");
INSERT INTO ldb_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Unga aba ru Ubitru, Ubitru agɔr agɛ, <<A Uteijee, awu ungo uwuri isorh adakmum?>> ");
INSERT INTO ldb_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Uyesu agɔr unga agɛ, <<Icɛrɛ ungo usi uhwɛngo ubinkpi umum iki ikorhe, bɔr ivanga ungo uwuri ihwɛngngo.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ubitru agɛ, <<Ĩ'ĩ! Ungo usi ísorhɔ adakmum.>> Uyesu agɛ, <<Umum ĩba isi isorhamum ungo, ungo ishiɔ ru ugau ru umum.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ubitru agɛ, <<A Uteijee, asi iwea adakmum ukpekũ ungo iki isorh, bɔr usorh nggu abokmum nu itsimum ikɛi!>> ");
INSERT INTO ldb_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Uyesu agɛ, <<Unerwi aka asorhi iyor, akpurha asorh adaknga ukpekũ, iyornga kishoo iki itɛngge. Umbi awu atɛtɛn, bɔr asi iwea umbi kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Uyesu ahwɛnga uwuku ughadaknga, ngge itsu unga agɔr agɛ, <<Asi iwea umbi kishoo awu atɛtɛn.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Unga aka asorh adakmbɔ amaa, unga atsim atorhanga, abvui azĩã ra anang iseinga. Unga arhusa umbɔ agɛ, <<Umbi ahwɛngmbi ubinkpi umum iki ikorhuwa umbi? ");
INSERT INTO ldb_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Umbi ayisa umum Umarhem nu Uteijee, iwe rimi, ubinkutsu umum iwe rimi hã. ");
INSERT INTO ldb_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Umum iwu Uteijee nu Umarhemmbi. Ngge iki iwe ugɛ umum isorha adakmbi, imɛ̃ngge umbi asorh adak adɔkambi. ");
INSERT INTO ldb_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Umum indɛyiwa umbi utsĩndĩã. Àka akorhuwe abɔɔ ubinkpi umum iki ikorhuwa umbi. ");
INSERT INTO ldb_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Umum indɛyiwa umbi idzidzɛrhe, ugãrhã asi inanga uteiyanga, uner itser ikɛi asi inanga uwuku udene unga. ");
INSERT INTO ldb_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Icɛrɛ iki iwe ugɛ umbi ahwɛngmbi abin akɛrɛ, Unum awuri itsukanga umbi idorh umbi aba akorhumbi ake. ");
INSERT INTO ldb_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","<<Isi irherhumum akɛrɛ ri itsimbi kishoo. Umum ihwɛng abirabɛ umum iki isɛng. Bɔr awu ufang ngge itsuifɛr ubinkpi uku utsɛng ra Arherhu-Num ugɛ, <Uwuku ugha ubinghamum asok awu unggamtsakmum.> ");
INSERT INTO ldb_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","<<Umum idɛyiwa umbi icɛrɛ ni ngge idɔrhi ikorhe, nggee ivangyɛ ngge iki ikorhe umbi awuri iwembi ri imangmang ugɛ umum iwu unga hã. ");
INSERT INTO ldb_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Umum indɛyiwa umbi idzidzɛrhe, uwuku uyɛi ubɛn uwuruwi umum iki idene, ayɛi umum, nu uwuku uyɛi umum, ayɛi uwuku udena umum ĩba.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ivang Uyesu aka arherha akɛrɛ amaa, unga agũ ighong akarhãrhã ra amɛnnga na adeka ra awiya agɛ, <<Umum indɛyiwa umbi idzidzɛrhe, unying ru umbi awuri ighaa adakmum.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Angwɛ̃ imesanga arhi adɔka. Asi ihwɛngmbɔ ungwɛ̃ imesa uwu ha Uyesu aka arherhe ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Unying ru umbɔ angwɛ̃ imesa ha, uwuruwi Uyesu aka abema, asei akhapa ru Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ubitru akũ uboknga agɔr Uyohana agɛ, <<Urhusa unga, uwukusong unga aka arherha arherha ha ri itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ungwɛ̃ imesa ha agɔpa azĩ ru Uyesu arhusa unga agɛ, <<Awu uwukusong Uteijee?>> ");
INSERT INTO ldb_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Uyesu agɛ, <<Uwuruwi umum iki itsɔɔr uborodi irhɔma ri itɛ̃rhãzɔu indzowe, awu unga nuwɔ.>> Mɔcɛ, unga aka arhɔmu uborodi adzowe ru Uyahuda ungwɛ̃ Usiman Uiskariyoti. ");
INSERT INTO ldb_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kanying Uyahuda aka ayɛi uborodi ha, Ushaitan atsĩ ru unga. Uyesu agɔr unga agɛ, <<Ubin hã ungo iki ikorhe, ukorhe ifetem.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bɔr umbɔ abika agha ubingha ha nggu unga asi ihwɛngmbɔ ubinkpi uku utsu Uyesu arherhe rimi hã. ");
INSERT INTO ldb_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ngge iki iwu ugɛ Uyahuda unga akpɔm ijari imangmbɔ, umɔ abɔɔ ra angwɛ̃ imesa ha akaifɛrhkɔ ugɛ Uyesu asɔme unga igoi ubin ukpɔɔ umbɔ aka abee ri irhowa ha, use unga azĩ adzowe atsũwã ubin ukpɔɔ. ");
INSERT INTO ldb_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Uyahuda ayɛi uborodi ha na adzeka. Utsuu ufin. ");
INSERT INTO ldb_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Uyahuda aka adzek, Uyesu agɛ, <<Icɛrɛ umbɔ aka ikpoi Ungwɛ̃-Ner na akpoi Unum ru uboknga. ");
INSERT INTO ldb_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Unum aba ayɛisa ikpikpoi ru uboknga, Unum awuri idzowuka Ungwɛ̃ɛ̃ ikpikpoi, nu unga awuri idzowuka unga ikpikpoi kanying. ");
INSERT INTO ldb_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","<<Umbi angwɛ̃mum abika acia, abɔr ivanga ukunjiir umum iki iwu nggu umbi. Umbi awuri ibeembi umum, bɔr ru nyaka umum iki idɛyiwe anggbaashi abi Uyahuda, rimi hã umum iki idɛyiwa umbi icɛrɛ inggɛ, <Anangkɛ umum iki iwuri izĩ, umbi asi ídɛ̃ɛ̃ abambi.> ");
INSERT INTO ldb_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","<<Awu ikpem iyiki ifa umum iki ĩdzaa umbi, àka abema adɔka. Ru nyaka umum iki ibema umbi, awu ufang umbi abema adɔka. ");
INSERT INTO ldb_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Rimi hã itsu ubɛn unera awuri ihwɛngnga ugɛ umbi awu angwɛ̃ imesamum, umbi aba abemumbi adɔka.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Usiman Ubitru arhusu Uyesu agɛ, <<A Uteijee, ungo izĩnɛ?>> Uyesu agɛ, <<Anangkɛ umum iki izĩ ungo usi ídɛ̃ɛ̃ udɔsungo umum icɛrɛ, bɔr unum ukpɔɔ ungo uwuri idɔsungo.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ubitru arhusa agɛ, <<A Uteijee, awu use utsu umum isi ídɛ̃ɛ̃ idɔsumum ungo icɛrɛ? Umum iwuri idzowukũ urhɛmum ri itsingo.>> ");
INSERT INTO ldb_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Mɔcɛ Uyesu agɛ, <<Ungo uwuri idzowukɔ urhɛngo ri itsimum? Umum indɛyiwa ungo idzidzɛrhe, ungo uwuri itsɛyingo ihwɛng umum idikunga itaar ni ikɔ idɔrhi igbɛr ukpee.>> ");
INSERT INTO ldb_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","<<Niba agũmbi ighong ra amɛnmbi. Àka awe ri imangmang ru Unum, ikɛi aka awe ri imangmang ru umum. ");
INSERT INTO ldb_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ri iya Utɛmum abã awu arhɛrhɛ, Umum iwuri izĩ nggɔɔ ha izĩ igbishuwa anang ru umbi. Iba isi iwengge rimi, umbi atsar ugɛ umum isi ídɛyiwamum umbi? ");
INSERT INTO ldb_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Umum ĩba izĩmum igbishuwa ananga ru umbi, umum ibvui iba ikũna umbi awe nggu umum, nu umbi asei ra anangkɛ umum iki iwe. ");
INSERT INTO ldb_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Anangkɛ umum iki izĩ umbi ahwɛngmbi utsĩndĩã.>> ");
INSERT INTO ldb_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Utoma agɔr Uyesu agɛ, <<A Uteijee, umɛn isi ihwɛngmɛn anangkɛ ungo iki izĩ. Umɛn ikorhu uguse ni ihwɛng utsĩndĩã?>> ");
INSERT INTO ldb_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Uyesu agɛ, <<Umum iwu utsĩndĩã, umum iwu idzidzɛrhe, ni iwu urhɛ. Unera asi ízĩã ru Utɛ, aba asi iwea ru ubokmum. ");
INSERT INTO ldb_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Umbi aba ahwɛngmbi umum, umbi awuri ihwɛngmbi Utɛmum. Utirhi icɛrɛ uzĩɔ̃ umbi aka ahwɛngmbi unga na anyãmbi unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ufirhibu agɛ, <<A Uteijee, uma udɛyiwa umɛn Utɛ ha. Aka amɛ̃mɔnɔ ru umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Uyesu agɛ, <<Aka adera umum iki iwu nggu umbi, bɔr utsɛku icɛrɛ ungo usi ihwɛngngo umum, Ufirhibu? Ubɛn uwuku unyã umum aka anyã Utɛ. Awu use utsu ungo ugɔr ugɛ, <Udɛyiwa umɛn Utɛ ha>? ");
INSERT INTO ldb_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ungo usi iweɔ ri imangmang ugɛ umum iwu ru Utɛ, Utɛ awu ru umum? Arherhakɛ umum iki irherhuwa umbi asi iweke akimum. Awu Utɛ aka awe ru umum unga atɔ̃ itsernga. ");
INSERT INTO ldb_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Àka awe ru imangmang ra arherhamum iki igɔr ugɛ umum iwe ru Utɛ, Utɛ ikɛi awe ru umum, use aka awe ru imangmang ra abin idzeukɛ umum iki ikorhe. ");
INSERT INTO ldb_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Umum indɛyiwa umbi idzidzɛrhe, ubɛn uwuku uwe ri imangmang ru umum awuri ikikorhunga abinkɛ umum iki ikorhe. Awuri ikorha akɔɔ anangke akɛrɛ ha, ubinkutsu umum iwuri izĩ ru Utɛ. ");
INSERT INTO ldb_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Nu ubin umbi aka ifɛna ri itsokmum, umum iwuri ikorhuwamum, ngge itsú Utɛ akpo ikpikpoi ru ubok Ungwɛ̃. ");
INSERT INTO ldb_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ubɛn ubina umbi aka ifɛna ri itsokmum, umum iwuri ikorhuwamum. ");
INSERT INTO ldb_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","<<Umbi aba abemumbi umum, umbi awuri ikorhumbi ubinkpi umum iki itsuka. ");
INSERT INTO ldb_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Umum iwuri irhusumum Utɛ, unga awuri idzaanga uwuku uyika umbi asei nggu umbi ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Unga awu Ipfu iyi idzidzɛrhe, uwuruwi upfunga uku usi ídɛ̃ɛ̃ uyɛikpɔ unga, ubinkutsu upfunga usi idɛ̃ɛ̃ unyãkpɔ unga use uhwɛng unga. Bɔr umbi ahwɛngmbi unga, unga asei nggu umbi, ikɛi awuri iseisa ru umbi. ");
INSERT INTO ldb_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Umum isi ínekamum umbi ru nyaka angwɛ̃rhãpfu. Umum iwuri iba ru umbi. ");
INSERT INTO ldb_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ivanga ukunjiir upfunga usi íbvui unyãkpɔ umum, bɔr umbi awuri inyãmbi umum. Ubinkutsu umum iwemum ru urhɛ, umbi ikɛi awuri ibibɛkmbi. ");
INSERT INTO ldb_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Awu ru unum hã umbi aka ihwɛng ugɛ umum iwe ru Utɛmum nu umbi awe ru umum nu umum iwe ru umbi. ");
INSERT INTO ldb_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ubɛn unera uwuku uhwɛng arherhamum iki itsu na adɔsunga ake, awu unga abema umum. Uwuruwi aka abema umum, Utɛmum awuri ibemunga uner ha, umum ikɛi iwuri ibemumum uner ha ni idɛyiwe itsimum ru unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Mɔcɛ Uyahuda, asi iwea Uyahuda Uiskariyoti, agɔr unga agɛ, <<A Uteijee, awu use utsu ungo iki idɛyiwa itsingo ru umɛn, bɔr ungo usi idɛyikɔ ru upfunga?>> ");
INSERT INTO ldb_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Uyesu agɛ, <<Ubɛn unera uwuku ubema umum awuri idɔsunga imesamum. Utɛmum awuri ibemunga uner ha, ikɛi umɛn iwuri inba iseimɛn nggu unga. ");
INSERT INTO ldb_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ubɛn unera aka asi ibemunga umum asi ídɔsunga arherhe imesamum. Irhɛmyɛ umbi aka agũ isi iwengge irhɛmmum, awu irhɛm Utɛ uwuku udena umum. ");
INSERT INTO ldb_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","<<Kishoo akɛrɛ umum isɔmamum umbi umum iki ina iwu nggu umbi. ");
INSERT INTO ldb_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bɔr uwuku uyika ha unga awuri imesuwa umbi abina kishoo na ayituwa umbi kishoo abinkɛ umum iki isɔma umbi. Unga awu Ipfu Isarsatangge, uwuruwi Utɛ aka idene ri itsokmum. ");
INSERT INTO ldb_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Umum ĩbɔra umbi nggu ididɔɔr, ididɔɔrmum iki ĩdzaa umbi. Isi iwengge ru nyaku upfung iki idzowe. Niba aneke amɛnmbi agũke ighong, ikɛi niba agũmbi iwei. ");
INSERT INTO ldb_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","<<Umbi agũmbi umum iki ĩgɔr ugɛ, <Umum izĩ ni ibvui ibamum ru umbi.> Umbi aba abemumbi umum, umbi awuri igɔmmbi anggɔm ugɛ umum iwuri izĩ ru Utɛ, Utɛ ha ananga umum. ");
INSERT INTO ldb_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Icɛrɛ umum iki isɔmamum umbi ru ngge idɔrhi iwe, nggee ivangyɛ ngge iki iwe, umbi awe ru imangmang. ");
INSERT INTO ldb_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Umum isi íbvui irherhuwamum arherhe arhɛrhɛ, ubinkutsu uyɛrhe upfung ukpirɛ uwɔ abarɔ. Unga ashia ri ijee ri itsimum. ");
INSERT INTO ldb_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Bɔr awu ufang upfunga uhwɛng ugɛ umum ibemumum Utɛ ha ni ikorhe uku kpengkpeng ubinkpi Utɛmum aka atsuka umum. <<Àka asok icɛrɛ umɛn ibɔre nggimi. ");
INSERT INTO ldb_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","<<Umum iwu udzum ucucii inebi uwu idzidzɛrhe, nu Utɛmum unga awu uner irhama. ");
INSERT INTO ldb_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Unga azharhuwe ubɛn uboka uku uwe ru umum uku usi ighwɛrkpɔ ikpũrhã, na agbishuwe ubɛn uboka ukpuku ughwɛr ikpũrhã, ru ukpɔ ughwɛr utoma. ");
INSERT INTO ldb_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Umbi aka awembi atɛtɛn ri itsi arherhamum iki isɔma umbi. ");
INSERT INTO ldb_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Àka asei ru umum, umum iwuri isei ru umbi. Ubok ucucii usi ídɛ̃ɛ̃ ughwɛrkpɔ ikpũrhã nibikakpɔ, awu ufang ukpɔ usei nggu udzuma. Rimi hã umbi asi ídɛ̃ɛ̃ aghwɛrmbi ikpũrhã umbi aba asi iseimbi ru umum. ");
INSERT INTO ldb_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","<<Umum iwu udzuma, umbi awu aboka. Unera aba aseisa ru umum nu umum ikɛi isei ru unga, unga awuri ighwɛr ikpũrhã irhɛirhɛ. Umum ĩba ishimum ru umbi, umbi asi ídɛ̃ɛ̃ akorhumbi ubin. ");
INSERT INTO ldb_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ubɛn unera aka asi iwea ru umum, awe ru nyaku ubokkpi umbɔ aka atare ukpɔ ukoyi. Anera aka isaka arheu ikpũ abok aki ha atsuku urha, akpĩĩwe. ");
INSERT INTO ldb_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Umbi aba asei ru umum arherhamum ikɛi aweke ru umbi, àka arhusa ubɛn ubinkpi umbi aka abee, awuri idzaambɔ umbi. ");
INSERT INTO ldb_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Umbi àka aghwɛr ikpũrhã irhɛirhɛ na adɛyiwe ugɛ umbi awu angwɛ̃ imesamum. Ngge ikũ nggaa ikpikpoi izĩ ru Utɛ. ");
INSERT INTO ldb_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","<<Ru nyaku Utɛ aka abema umum, rimi hã umum iki ibema umbi. Icɛrɛ àka asei ri ibibemamum. ");
INSERT INTO ldb_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Umbi aba adɔsumbi arherhamum iki itsu, umbi awuri iseimbi ri ibibemamum, ru nyaka umum iki ĩdɔsa arherhe Utɛmum aka atsu ni isei ri ibibemanga. ");
INSERT INTO ldb_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Umum ĩdɛyiwa umbi riminɛ ngge itsú anggɔmmum awe ru umbi nu anggɔmmbi atsu atɔk. ");
INSERT INTO ldb_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ikpemmum iyɛ, àka abema adɔka ru nyaka umum iki ĩbema umbi. ");
INSERT INTO ldb_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nggaa ibibema iyɔɔ isi inangngge iyɛrɛ, ugɛ unera adzowe urhɛnga ri itsi awɛrhanga. ");
INSERT INTO ldb_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Umbi awu awɛrhamum, umbi aba akorhumbi ubinkpi umum iki itsuka umbi. ");
INSERT INTO ldb_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Umum isi íbvui iyisumum umbi agãrhã, ubinkutsu ugãrhã asi ihwɛngnga ubinkpi uteiyanga aki ikorhe. Bɔr umum iyisa umbi awɛrhɛ, ubinkutsu iki isɔmamum umbi kishoo abinkɛ umum iki igũ ru Utɛmum. ");
INSERT INTO ldb_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Asi iwea umbi asɛng umum, bɔr umum isɛng umbi itsuka umbi azĩ aghwɛr ikpũrhã, ikpũrhãyɛ iki idãrhã. Mɔcɛ Utɛ awuri idzaanga kishoo abinkɛ umbi aka arhusa ri itsokmum. ");
INSERT INTO ldb_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ubinmum ukpi iki itsu, àka abema adɔka. ");
INSERT INTO ldb_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","<<Upfunga uba ukpɛ̃kpɔ umbi, àka ahwɛng ra amɛnmbi ugɛ ugbaashia ukpɛ̃ umum. ");
INSERT INTO ldb_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Umbi aba awu abi upfung, upfunga uba ubemukpɔ umbi ru nyaka abinga. Bɔr umbi asi iwembi abi upfung. Umum iki isɛng umbi idzek ru upfunga. Ngge itsu upfung ukpɛ̃kpɔ umbi. ");
INSERT INTO ldb_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Àka ayita ubinkpi umum iki idɛyiwa umbi ugɛ, <Ugãrhã asi inanga Uteiyanga.> Umbɔ aba adzaa umum uver, awuri idzaambɔ umbi uver ikɛi. Umbɔ aba adɔsumbɔ imesamum, umbɔ awuri idɔsumbɔ iyimbi. ");
INSERT INTO ldb_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Awuri ikorhuwambɔ umbi akɛrɛ ha, ri itsi umbi awu abimum nu umbɔ asi ihwɛngmbɔ uwuku udena umum ĩba. ");
INSERT INTO ldb_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Agɛ umum isi ĩba irherhumum arherhe nggu umbɔ, umbɔ awuri ishimbɔ ru uvau arhim. Bɔr icɛrɛ umbɔ ashimbɔ ru ubin ukpuku ukaa atsimbɔ ra arhimmbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Unerwi aka akpɛ̃ umum, akpɛ̃ Utɛmum. ");
INSERT INTO ldb_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Agɛ umum isi ikorhumum abina arhɛrhɛ ru umbɔ akirakɛ unera aka anasi ikorhunga, mɔcɛ umbɔ awuri ishimbɔ ru uvau arhim. Bɔr icɛrɛ umbɔ aka anyãmbɔ abin idzeu ha na akpɛ̃mbɔ umum nu Utɛmum. ");
INSERT INTO ldb_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Akɛrɛ akorhe ngge itsuifɛr ubinkpi umbɔ aka atsɛng ri Íkpemmbɔ agɛ, <Adzuma akpɛ̃mbɔ umum asi iwea ubin utsu.> ");
INSERT INTO ldb_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","<<Ivangyɛ Uwuku Uyuyika ha aka iba, uwuruwi umum iki idene unga adzeku Utɛ aba ru umbi, Ipfu iyi idzidzɛrhe iki idzeku Utɛ, unga awuri idzowe ideka ri itsimum. ");
INSERT INTO ldb_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Umbi awuri iwu idekamum, ubinkutsu umbi awu nggu umum udzur ri inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","<<Umum isɔma umbi kishoo akɛrɛ utsur umbi ayapumbi ri imangmangmbi. ");
INSERT INTO ldb_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Awuri iwayikumbɔ umbi ra abã ifɛn-Num. Idzidzɛrhe, ivanga niyɔ ibarɔ ubɛn uwuku ufɛre umbi awuri igɔr ugɛ unga itɔ̃ itser Unum. ");
INSERT INTO ldb_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Umbɔ awuri ikorhe rimi ubinkutsu umbɔ anasi ihwɛngmbɔ Utɛ use umum. ");
INSERT INTO ldb_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Umum isɔma umbi akɛrɛ, nggee ivang hã iba iwengge umbi ayita ugɛ umum iki isɔmamum umbi. Umum isi isɔmamum umbi abin akɛrɛ ri inggbaashia ubinkutsu, umum ina iwu nggu umbi. ");
INSERT INTO ldb_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","<<Icɛrɛ umum iwuri izĩ ru uwuku udena umum iba, bɔr umbi asi irhusumbi umum ugɛ, <Ungo uwuri izĩnɛ?> ");
INSERT INTO ldb_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Amɛnmbi aghong ra abin hã umum iki isɔma umbi. ");
INSERT INTO ldb_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bɔr umum indɛyiwa umbi idzidzɛrhe, awu azeze ru umbi umum ĩba izĩmum. Umum ĩba isi izĩmum, mɔcɛ Uwuku Uyuyika ha asi íbanga ru umbi. Bɔr umum ĩba izĩmum, umum iwuri idene unga aba ru umbi. ");
INSERT INTO ldb_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ivangyɛ unga aka iba, unga awuri idɛyiwe upfunga uvau arhim nu irhirhika nu ivarha arherhe. ");
INSERT INTO ldb_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Unga awuri idɛyiwe umbɔ ugɛ umbɔ awe ra arhim, ubinkutsu anera ashimbɔ ri imangmang ru umum. ");
INSERT INTO ldb_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Unga awuri idɛyiwe igbigbambɔ ri irhirhika, ubinkutsu umum iwuri izĩ ru Utɛ, umbi asi íbvui anyãmbi umum. ");
INSERT INTO ldb_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Unga awuri idɛyiwe umbɔ agɛ awuri izharha arherhambɔ, ubinkutsu uyɛrhe upfung ukpirɛ aka atsukukumbɔ unga uvau. ");
INSERT INTO ldb_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","<<Umum ibɔr abina arhɛrhɛ umum iki irherhuwa umbi, akirakɛ umbi asi ídɛ̃ɛ̃ anyangumbi ake icɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Bɔr ivangyɛ Ipfu iyi idzidzɛrhe ha iki iba, ngge iwuri idarh umbi ri idzidzɛrhe kishoo. Asi íwea arherhe itsikamnga unga aka irherhe, bɔr awuri isɔma ubinkpi unga aka agũ. Awuri isɔma umbi abinkɛ aka iwuri iba. ");
INSERT INTO ldb_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Awuri ikũ ikpikpoi aba ru umum, unga awuri inyãnga abinkɛ umum iki irherhe adɛyiwa umbi. ");
INSERT INTO ldb_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Kishoo abinkɛ Utɛ aka awe ra ake awu akimum. Ngge itsu umum igɔr ugɛ Ipfu-Num ha iwuri inyãnga abinkɛ umum iki irherhe adɛyiwa umbi. ");
INSERT INTO ldb_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","<<Ivanga ukunjiir umbi asi ínyãmbi umum, mɔcɛ ikɛi ivanga ukunjiir umbi awuri inyãmbi umum.>> ");
INSERT INTO ldb_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Angwɛ̃ imesanga abɔɔ agɔr adɔkambɔ agɛ, <<Agbena agburh use unga aka agɔr umɛn agɛ, <Ivanga ukunjiir umbi asi ínyãmbi umum, mɔcɛ ikɛi ivanga ukunjiir umbi awuri inyãmbi umum,> nu <Ubinkutsu umum iwuri izĩ ru Utɛ>?>> ");
INSERT INTO ldb_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Adɛ̃ɛ̃mbɔ irhusa agɛ, <<Agbena awu use unga aka agɔr agɛ, <Ivanga ukunjiir>? Umɛn isi ihwɛngmɛn agben ubinkpi unga aka arherhe.>> ");
INSERT INTO ldb_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Uyesu anyã umbɔ abee irhusa unga ra arherhe ha, nggee unga agɔr umbɔ agɛ, <<Umbi arhusa adɔka agben arherha ha umum iki igɔr ugɛ, <Ivanga ukunjiir umbi asi ínyãmbi umum, mɔcɛ ikɛi ivanga ukunjiir umbi awuri inyãmbi umum>? ");
INSERT INTO ldb_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Umum indɛyiwa umbi idzidzɛrhe, umbi awuri iciu akpe nggu ighongamɛn, bɔr upfunga uwuri igɔmanggɔm. Amɛnmbi awuri ida, bɔr ida amɛnmbi iwuri idzipa iwu anggɔm. ");
INSERT INTO ldb_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ivangyɛ ukutsɛrh aba ahwashi imar, unga aka isaka agũ ighong akarhãrhã, ubinkutsu ivang imarnga iki iwengge. Bɔr ivangyɛ unga aka imar irheng ungwɛ̃ amaa, unga aka isaka ayiruka ighighong hã, ubinkutsu unga awu ra anggɔm unga aka amar irheng ungwɛ̃ ru upfunga. ");
INSERT INTO ldb_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ngge iwu rimi hã ru umbi. Icɛrɛ umbi awuri igũ ighong, bɔr umum ibvui inyãmum umbi, mɔcɛ amɛnmbi aka igɔmanggɔm, unera asi ívura anggɔmmbi. ");
INSERT INTO ldb_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ru unum hã umbi asi írhusumbi umum ubin. Umum indɛyiwa umbi idzidzɛrhe, Utɛ awuri idzaanga kishoo ubinkpi umbi aka arhusa ri itsokmum. ");
INSERT INTO ldb_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Utsɛku icɛrɛ umbi anasi irhusumbi ubin ri itsokmum. Àka arhusa umbi awuri iyiyɛimbi, nu anggɔmmbi awuri itsu atɔke.>> ");
INSERT INTO ldb_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","<<Umum ikũ nyaka arherhe indɛyiwa umbi akɛrɛ ha. Bɔr ivanga niyɔ ibarɔ umum iki irherha arherhe nggu umbi ukupɛ̃ɛ̃ ri itsi Utɛ, umum isi iwuri íkũmum nyaka arherhe. ");
INSERT INTO ldb_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ru unum hã umbi awuri irhusa ri itsokmum. Umum isi igɔrmum ugɛ iwuri irhusuwamum Utɛ ru umbi. ");
INSERT INTO ldb_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Unga Utɛ nibikanga abemunga umbi, ubinkutsu umbi abemumbi umum, ikɛi umbi awembi ri imangmang ugɛ umum idzeku Unum. ");
INSERT INTO ldb_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Umum idzeku Utɛ iba itsĩ ru upfung, icɛrɛ umum iwuri ibɔre upfung ni ibvui izĩ ru Utɛ.>> ");
INSERT INTO ldb_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mɔcɛ angwɛ̃ imesu Uyesu agɛ, <<Ĩhĩĩ! Awu icɛrɛ ungo uku urherhuwa umɛn arherhe ukupɛ̃ɛ̃ asi iweke unyaka arherhe! ");
INSERT INTO ldb_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Icɛrɛ umɛn iki ihwɛngmɛn ugɛ ungo uhwɛngo abina kishoo. Ungo uhwɛngo ubɛn ubinkpi unera aka irhusa ungo. Akɛrɛ ha atsu umɛn iwe ru imangmang ugɛ ungo udzeku Unum.>> ");
INSERT INTO ldb_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Uyesu agɛ, <<Awu icɛrɛ umbi aka awe ri imangmang? ");
INSERT INTO ldb_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bɔr ivanga niyɔ ibarɔ, iki ibangge, ubɛn unera ru umbi awuri itĩ azĩ ri iyanga na aneka umum ikiyikamum. Bɔr rimi hã, umum isi iwemum ikiyikami, ubinkutsu Utɛ awu nggu umum. ");
INSERT INTO ldb_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","<<Umum isɔmamum umbi abin akɛrɛ, ngge itsú umbi ama akpo ididɔɔr. Ru upfung ukpirɛ umbi awuri igũ ighong. Bɔr àka aker amɛn! Umum iki inangmum upfunga.>> ");
INSERT INTO ldb_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Uyesu aka amaa irherhe abin akɛrɛ, unga abera asunga arhi afã na afɛn-Num agɛ, <<A Utɛ, ivanga iki iwengge. Ukpoi Ungwɛ̃ngo nggee Ungwɛ̃ngo ama akpoi ungo. ");
INSERT INTO ldb_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ubinkutsu ungo uku udzowukɔ Ungwɛ̃ngo ijee ri itsi anera kishoo, nggee unga ama adzowe urhɛ uwu ugbagbaa ru kishoo abirabɛ ungo uku udzowe unga. ");
INSERT INTO ldb_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Uwɛrɛ ha awu urhɛ uwu ugbagbaa, ugɛ umbɔ ama ahwɛng ungo, Unum unying ukpekũ, nu Uyesu Ukiristo, uwuruwi ungo uku udene. ");
INSERT INTO ldb_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Umum ikũwã ungo ukpoi ra abĩ ni imaawe itsera kishoo ungo uku udzaa umum itɔ̃. ");
INSERT INTO ldb_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Icɛrɛ ikɛi, a Utɛ, ukpoi umum ra asungo nggu ikpikpoi ha umum iki iwurangge nggu ungo, ru upfung udɔrhu umuna.>> ");
INSERT INTO ldb_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","<<Umum iki idɛyikũ ungo ra anerabɛ ungo uku udzaa umum ru upfung. Umbɔ awu abingo, ungo adzaa umbɔ ru umum, umbɔ ikɛi aka adɔsumbɔ arherhango. ");
INSERT INTO ldb_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Icɛrɛ umbɔ ahwɛngmbɔ kishoo abinkɛ ungo uku udzaa umum adzeku ungo, ");
INSERT INTO ldb_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ubinkutsu iki idzowukũ ru umbɔ arherhango uku udzaa umum. Umbɔ aka ayɛimbɔ ake na ahwɛngmbɔ ugɛ awu idzidzɛrhe umum idzeku ungo, na awembɔ ri imangmang ugɛ awu ungo udena umum. ");
INSERT INTO ldb_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Umum ifɛne-Num ru umbɔ. Umum isi inumum ifɛne-Num ru upfunga, bɔr umum ifɛne-Num ra abirabɛ ungo uku udzaa umum, ubinkutsu umbɔ awu abingo. ");
INSERT INTO ldb_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Kishoo abinmum awu akingo, nu kishoo abinngo awu akimum. Ikpikpoi iki ibangge ru umum ru ubokmbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Umum isi íbvui iseisũ ru upfunga, bɔr umbɔ ana awu ru upfunga kata. Umum ibvui iba ru ungo. Usarkasar Utɛ, ukũ ijee itsokngo ukake umbɔ, itsokyɛ ungo uku udzaa umum, ngge itsú umbɔ awu unying ru nyaka umɛn iki iwu unying. ");
INSERT INTO ldb_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ivangyɛ umum iki iwu nggu umbɔ, umum ikũ ijee itsokyɛ ungo uku udzaa umum ikake umbɔ. Uwɔɔ asi igwira, unying hã ukpekũ aka awu uwuku utsutsĩm, ngge itsuifɛr itsɛng Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","<<Icɛrɛ umum iwuri iba ru ungo, bɔr umum irherha abina akɛrɛ ru umum ina iwu ru upfung, ngge itsú umbɔ ama akpo undzumu anggɔmmum ra amɛnmbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Umum iki isɔmukũ arherhango ru umbɔ, upfunga ikɛi uku ukpɛ̃kpɔ umbɔ, ubinkutsu umbɔ asi iwembɔ abi upfung ru nyaka umum iki isi iwemum uwu upfung. ");
INSERT INTO ldb_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Isi irhusumum ungo unyanguwe umbɔ ru upfunga, bɔr ungo udzɛu umbɔ ru ubok Undenggũ. ");
INSERT INTO ldb_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Umbɔ asi iwembɔ abi upfung, ru nyaka umum iki isi iwemum uwu upfung. ");
INSERT INTO ldb_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Utsu umbɔ awu asarkasar ri idzidzɛrhe. Arherhango awu idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Umum idene umbɔ azĩ ru upfung, ru nyaka ungo uku udena umum ru upfunga. ");
INSERT INTO ldb_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Umum idzowe itsimum ri itsimbɔ, nggee umbɔ ama adzowe atsimbɔ ru ungo ru ubok idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","<<Ifɛn-Nummum isi iwengge ru umbɔ ikiyikambɔ. Bɔr a Utɛ, umum ifɛne-Num ra abirabɛ aka awuri iwe ri imangmang ru umum ru ubok arherhambɔ, ");
INSERT INTO ldb_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ugɛ umbɔ kishoo ama awu unying. Umbɔ ama awe ru umɛn, ru nyaka ungo uku uwe ru umum, nu umum iwe ru ungo, ngge itsú anera ru upfung awe ru imangmang ugɛ awu ungo udena umum ĩba. ");
INSERT INTO ldb_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Umum iki idzowukũ umbɔ ikpikpoiyɛ ungo uku udzaa umum, ru umbɔ awu unying ru nyaka umɛn iki iwu unying. ");
INSERT INTO ldb_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Umum isei ru umbɔ nu ungo ru umum. Umbɔ ama awu unying, ru upfunga uma uhwɛng ugɛ awu ungo udena umum ĩba, na ahwɛng ugɛ ungo ubemungo umbɔ ru nyaka ungo uku ubema umum. ");
INSERT INTO ldb_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","<<A Utɛ, anerabɛ ungo uku udzaa umum, umum ibee umbɔ asei nggu umum ra anangkɛ umum iki iwe, na anyã ikpikpoimum, iyiriyɛ ungo uku udzaa umum, ubinkutsu ungo uku ubemungo umum umbɔ adɔrha amunu upfunga. ");
INSERT INTO ldb_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","<<A Utɛ uwuku urhurhika, upfunga usi ihwɛngkpɔ ungo, bɔr umum ihwɛngmum ungo, anera ikɛi ahwɛngmbɔ ugɛ awu ungo udena umum iba. ");
INSERT INTO ldb_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Umum iki idɛyikũ ungo ru umbɔ. Ikɛi umum ina itsu umbɔ ahwɛng ungo ubɛn ivang, nggee ibibemango uku ukorhuwa umum ima isei ru umbɔ nu umum isei ru umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ivangyɛ unga aka amaa ifɛn-Num, Uyesu agar izɛ̃rhĩ Ukidron azĩã ugar ukpɔrɔ nggu angwɛ̃ imesanga. Ugar ha icang acucii uzaitun niyɔ, unga nu angwɛ̃ imesanga atsĩmbɔ ru ngge. ");
INSERT INTO ldb_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Uyahuda, ungwɛ̃ imesa uwuku ugha adak Uyesu, ahwɛnga anang hã, ubinkutsu Uyesu aka isaka agbowa umɔ nggu angwɛ̃ imesanga. ");
INSERT INTO ldb_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nggee Uyahuda akũ ukpui abi iwa nu adogerhi abɔɔ abi ateiya abika adzowe idɛm-Num, nu abi Ufarisi, azĩmbɔ ri icang acucii uzaitun hã. Umbɔ akpɔm nggu atseu irhirhang nú atɔngvi akagɔng nu abin iwa. ");
INSERT INTO ldb_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Uyesu aka ahwɛnga kishoo ubinkpi uku ikpo unga. Unga adzeka, aba agɔr umbɔ agɛ, <<Umbi abee ungamɔ?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Umbɔ agɛ, <<Uyesu uner Unazarat.>> Uyesu agɛ, <<Umum uwi.>> Uyahuda, uwuku ughadaknga, adɛ̃ɛ̃ umɔ nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Uyesu aka agɔr agɛ, <<Umum iwe uwu ha,>> umbɔ azĩmbɔ ra andzing na agba ra abĩ. ");
INSERT INTO ldb_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Uyesu abvui arhusa umbɔ agɛ, <<Umbi abee ungamɔ?>> Umbɔ agɛ, <<Uyesu uner Unazarat.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Uyesu agɛ, <<Umum iki idɛyiwamum umbi ugɛ umum iwu unga. Umbi aba ani ibeea umum, mɔcɛ àka neke anera abɛrɛ azĩmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Akɛrɛ akorhe nggee arherhakɛ Uyesu aka arherhe atsuafɛr. Unga aka agɔr agɛ, <<Ra aner ha ungo uku udzaa umum unera ru umbɔ asi igwira.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Usiman Ubitru awe ru ikon iki ider, awɔɔr ike agbɛr uto ubok ugha ugãrhũ Ukugɔng Uwuku Udzowe Idɛm-Num, azharhuwe. Itsok ugãrhã hã igburh Umarhcu. ");
INSERT INTO ldb_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Bɔr Uyesu agɔr Ubitru agɛ, <<Utsuke ikon iki iderngo ru udapa! Umum isi íhwamum ru ukpɛwawi Utɛ aka adzaa umum ihwa?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mɔcɛ ukpui abi iwa nu unggbaashimbɔ, nu adogerhi abi Uyahuda adzur Uyesu, abow unga. ");
INSERT INTO ldb_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ri inggbaashia umbɔ akũ unga azĩ ru Uhanana, unga aka awu umar Ukayafa. Ukayafa unga awu Ukugɔng Uwuku Udzowe Idɛm-Num ra amɛk ha. ");
INSERT INTO ldb_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ukayafa unga adzowe anggbaashi abi Uyahuda itsũwã ugɛ ugba unera unying akpe ri itsi anera arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Usiman Ubitru nggu uwɔɔ ra awɛ imesu Uyesu adɔsu Uyesu ra andzing. Ungwɛ̃ imesa ha, Ukugɔng Uwuku Udzowe Idɛm-Num ahwɛnga unga, nggee unga atsĩã ru ufɔm iya Ukugɔng Uwuku Udzowe Idɛm-Num nggu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bɔr Ubitru adɛ̃ɛ̃ ra angwĩã udika awiya. Ungwɛ̃ imesa ha, Ukugɔng Uwuku Udzowe Idɛm-Num hã aka ahwɛng adzek arherha arherhe nggu una uwuku udzɛu angwĩ ubã, na akũ Ubitru atsĩ. ");
INSERT INTO ldb_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Una uwuku udzɛu angwĩ ubã hã agɔr Ubitru agɛ, <<Ungo igango usi iweɔ unying ra angwɛ̃ imesanga?>> Ubitru agɛ, <<Ĩ'ĩ, umum ishimum.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Awu ri ivang ighɛnga ngge itsu agãrhã nu adogerhi atai urha, adɛ̃ɛ̃ iwɛr urha. Ubitru adɛ̃ɛ̃ iwɛr urha ha nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mɔcɛ Ukugɔng Uwuku Udzowe Idɛm-Num arhusu Uyesu ri itsi angwɛ̃ imesanga nu imesanga. ");
INSERT INTO ldb_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Uyesu agɔr unga agɛ, <<Umum irherha arherhe ukupɛ̃ɛ̃ ra asu upfunga. Ubɛn ivang umum imesuwe ra abã ifɛn-Num nu Iya-Num, anangkɛ abi Uyahuda iki ikɔng kishoo. Umum inasi irherhumum ubin ukpɔɔ ri iwɔk. ");
INSERT INTO ldb_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Awu use utsu ungo urhusa umum? Urhusa abika agosha arherhamum ubinkpi umum iki idɛyiwe umbɔ. Umbɔ ahwɛngmbɔ ubinkpi umum iki irherhe.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ivang Uyesu aka arherhe rimi, uwɔɔ ru umbɔ adogerhi ha aka adɛ̃ɛ̃ umɔ akwɛr unga na agɛ, <<Rimi ungo uku irherhe nggu Ukugɔng Uwuku Udzowe Idɛm-Num?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Uyesu agɛ, <<Umum iba igbigba umum iki irherhe rimi hã, udɛyiwa igbigbamum. Bɔr umum iba irherhe idzidzɛrhe, awu use utsu ungo ukwɛr umum?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mɔcɛ Uhanana atsu umbɔ akũ Uyesu azĩmbɔ ru Ukayafa, Ukugɔng Uwuku Udzowe Idɛm-Num. Unga ana awu ri ibibow. ");
INSERT INTO ldb_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ubitru ana adɛ̃ɛ̃ iwɛr urha ha, abɔɔ aka adɛ̃ɛ̃ umɔ arhusa unga agɛ, <<Ungo usi iweɔ unying ra angwɛ̃ imesanga hã?>> Ubitru atsɛyinga agɛ, <<Umum ishimum.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ugãrhũ uwɔɔ ra agãrhã Ukugɔng Uwuku Udzowe Idɛm-Num awu umɔ. Utsa ha awu unang uwuruwi Ubitru aka azharhuwe utoa, unga agɔr Ubitru agɛ, <<Asi iwea ungo umum iki inyã nggu unga ru icang acucii uzaitun?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ubitru abvui atsɛyi. Kanying ikɔ igbɛr ukpee. ");
INSERT INTO ldb_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mɔcɛ abi Uyahuda akũ Uyesu adzek ri iya Ukayafa azĩmbɔ udzepurhe ugomna Uroma. Aka awu ukpee. Abi Uyahuda akpɛ̃mbɔ itsĩ ru udzepurhea, agɛ utsur umbɔ asi isarmbɔ ra agbeyakɛ aka ikɛn umbɔ igha Irhowa Iyiki Igar Utɔng. ");
INSERT INTO ldb_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Nggee Ubirhatu adzek aba arhusa umbɔ agɛ, <<Arherhe akasong umbi aka atsu ri itsi utsak uwurɛ?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Umbɔ agɔr unga agɛ, <<Agɛ unga ashia ru uvau, umɛn isi íkũ unga ibamɛn ru ungo.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ubirhatu agɛ, <<Àka akũna unga azĩ atsuke unga uvau nibikambi ri Íkpemmbi.>> Anggbaashi abi Uyahuda asi ibeembɔ na agɛ, <<Bɔr isi irhikungge umɛn itsu ufai akpe ru ubɛn uner.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Akɛrɛ akorhe ngge itsuifɛr arherhe Uyesu aka arherhe aki ikpũ akpenga aka ikpe. ");
INSERT INTO ldb_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ubirhatu abvui atsĩã ru udzepurhe ha, unga ayisu Uyesu arhusa unga agɛ, <<Ungo uwu Uyɛrhe abi Uyahuda?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Uyesu agɛ, <<Akɛrɛ awu ungo urhusa use anera adɛyiwa ungo ri itsimum?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ubirhatu agɛ, <<Umum iwu uner abi Uyahuda? Awu abi abĩmbi nu ateiya abika adzowe idɛm-Num umbɔ atsuka ungo ru ubokmum. Ungo ukorhu use?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Uyesu agɛ, <<Iyɛrhamum isi iwengge iyi upfung ukpirɛ. Agɛ Iyɛrhamum iwu iyi upfung ukpirɛ, agãrhãmum awuri ikɛnmbɔ anggbaashi abi Uyahuda idzur umum. Bɔr Iyɛrhamum iwu iyi anang akase.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ubirhatu agɛ, <<Ungo uwu uyɛrhe nukpɔ!>> Uyesu agɛ, <<Ungo urherhe mɔnɔ ungo uku ugɔr ugɛ umum iwu uyɛrhe. Ngge itsu umbɔ amar umum, ikɛi ngge itsu umum itsĩwã ru upfung, indzowe ideka ri itsi idzidzɛrhe. Ubɛn uwuku uwe ri idzidzɛrhe awuri ikpea ato na adɔsunga urhɛmmum.>> ");
INSERT INTO ldb_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ubirhatu arhusa unga agɛ, <<Awu use uwu idzidzɛrhe?>> Ubirhatu aka arherha akɛrɛ amaa, unga abvui adzek agɔr abi Uyahuda agɛ, <<Umum isi ikpomum unga nggu uvau. ");
INSERT INTO ldb_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","<<Bɔr umbi awembi ru ugau, ri ivang Irhowa Iyiki Igar Utɔng umum iki isaki itsũwã umbi uner uvau unying ru ugborzĩ. Umbi abeembi umum itsũwã Uyɛrhe abi Uyahuda?>> ");
INSERT INTO ldb_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Umbɔ abvui atsui ivum agɛ, <<Ĩ'ĩ! Asi iwea uwɛrɛ ungo iki itsũwã, utsũwã Ubaraba!>> Ubaraba uner uwuku utsu anera asoyiwe amɛn abika akpɔm abĩã. ");
INSERT INTO ldb_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mɔcɛ Ubirhatu atsu umbɔ akwɛre ugwɛɛ ru Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abi iwa akũ ídidɔk akari ifur atsime ni itsi Uyesu. Umbɔ atsime unga atorho iyɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Aba ru unga, anu ikwɛr unga na agɛ, <<Urhɛngo uder, Uyɛrhe abi Uyahuda!>> Mɔcɛ umbɔ akwɛr unga nú unyɛ̃ɛ̃nga. ");
INSERT INTO ldb_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ubirhatu abvui adzek aba agɔr abi Uyahuda agɛ, <<Àka anyã, umum iwuri ikũna unga idzeka ru umbi ahwɛng umum isi ikpomum unga nggu uvau.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ivang Uyesu aka adzeka nggu ifur ididɔk ni itsinga na atsim atorho iyɛrhe, Ubirhatu agɔr umbɔ agɛ, <<Àka anyã utsa ha uwi.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ivang ateiya abika adzowe idɛm-Num nu adogerhi Iya-Num aka anyã Uyesu, umbɔ atsu ivum agɛ, <<Anyapuwe unga! Anyapuwe unga!>> Bɔr Ubirhatu agɛ, <<Àka azĩ anyapuwe unga nibikambi. Umum isi ikpomum unga nggu uvau.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Anggbaashi abi Uyahuda angipa agɛ, <<Umɛn iwemɛn ri ikpem, ikpem hã igɔr igɛ awu ufang unga akpe, ubinkutsu anyangi itsinga awu Ungwɛ̃ Unum.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ivang Ubirhatu aka agũ rimi, iwei itomi ifɛr unga. ");
INSERT INTO ldb_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Unga abvui atsĩã ru udzepurhe ha, arhusu Uyesu agɛ, <<Ungo udzekɛ?>> Bɔr Uyesu asi idzipunga urhɛm. ");
INSERT INTO ldb_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ubirhatu agɛ, <<Ungo ukpɛ̃ɔ irherha arherhe nggu umum? Ungo usi ihwɛngngo ugɛ umum iwemum ri ijee iyiki itsũwã ungo use umum inyapuwe ungo?>> ");
INSERT INTO ldb_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Uyesu agɛ, <<Ungo ushiɔ ri ijee ri itsimum, ngge iba isi idzengge ru Unum. Nggee unerwi aka atsuka umum ru ubokngo awe ra arhim ananga ungo.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Udzur na arherhe akɛrɛ, Ubirhatu abee itsũwe Uyesu, bɔr anggbaashi abi Uyahuda atsarhi irhakmbɔ atsu ivum agɛ, <<Ungo uba utsũwũkɔ unga, ungo usi iweɔ uwɛrhu Ukaisar. Ubɛn uwuku ugɔr ugɛ unga awu uyɛrhe, unga uwu unggamtsak Ukaisar.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ivang Ubirhatu aka agũ ubin umbɔ aka arherhe, unga akũ Uyesu adzeka na asei nú utarh ukpuku utsu uvau, ra anang hã umbɔ aki isaka ayisa agɛ, <<Ubeu Atarh>>. Ri idũ abi Uyahuda umbɔ iki iyisa Ugabbata. ");
INSERT INTO ldb_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aka awu atenum ru unum ukpuku ugbisha abin Irhowa Iyiki Igar Utɔng. Ubirhatu agɔr abi Uyahuda agɛ, <<Uyɛrhambi uwi!>> ");
INSERT INTO ldb_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bɔr abi Uyahuda atsui ivum agɛ, <<Akũna unga adzek! Akũna unga adzek! Anyapuwe unga!>> Ubirhatu arhusa umbɔ agɛ, <<Umbi abee umum inyapuwe uyɛrhambi?>> Ateiya abika adzowe idɛm-Num agɔr agɛ, <<Umɛn ishimɛn ru uyɛrhe uwɔɔ. Ukaisar ukpekũ awu uyɛrhamɛn.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Mɔcɛ Ubirhatu atsukuka unga ru ubok abi Uyahuda umbɔ anyapuwe unga. Nggee abi iwa akũ Uyesu azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Uyesu atsã igãrhãmau ucuciianga nibikanga adzek utepa akũ azĩ anang akɔɔ umbɔ iki iyisa agɛ, <<Anang Apfupfu Aghow Itsi.>> Ri idũ abi Uyahuda ayisa agɛ, <<Ugorhgota.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Umɔ umbɔ anyapuwe unga nggu inera ivaa, unying ru ubok ughanga, unying ikɛi ru ubok uferanga nu Uyesu ra ateumbɔ. ");
INSERT INTO ldb_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ubirhatu atsɛng isarhe, umbɔ anyapuwe nú igãrhãmau ucuciia ha. Unga atsɛng agɛ, <<UYESU UNER UNAZARAT, UYƐRHA ABI UYAHUDA.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Abi Uyahuda arhɛrhɛ aka avarhe isarhe ha, ubinkutsu anangkɛ umbɔ aka anyapuwe Uyesu akhapa ru utepa. Itsɛng hã umbɔ atsɛng ngge ri idũ abi Uyahuda nu iyi abi Uroma nu abi Uherhini. ");
INSERT INTO ldb_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ateiya abika adzowe idɛm-Num abi Uyahuda asi ibemumbɔ ubinkpi Ubirhatu aka atsɛng agɛ, <<Niba utsɛ̃ngo, <Uyɛrha abi Uyahuda,> bɔr utsɛng ugɛ utsak uwurɛ agɔr agɛ unga awu uyɛrha abi Uyahuda.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ubirhatu agɛ, <<Ubinkpi umum iki itsɛng, iki itsɛng ukpɔ nukpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Abi iwa aka anyapuwe Uyesu amaa, umbɔ unyangu atorhanga, agasha agapa anaa, ubɛn unera anyangu ugapa unying, na atorha aki unɔrkang abɔrke. Aki ha asi isɔrmbɔ bɔr anunu ake udzur afafã uba ra abĩã. ");
INSERT INTO ldb_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Umbɔ agɔr adɔka agɛ, <<Umɛn niba ivarkumɛn atorha akɛrɛ, bɔr umɛn itang isɛng ra ake ni inyãni uwuruwi aka igha.>> Akɛrɛ akorhe rimi ngge itsuifɛr ubinkpi uku utsɛng ra Arherhu-Num ugɛ, <<Agasha atorhamum ra adɔkambɔ, atorhamum ikɛi umbɔ atang isɛng ri itsike.>> Ubinkpi abi iwa aka akorhe nukpɔ. ");
INSERT INTO ldb_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Abirabɛ aka adɛ̃ɛ̃ akhapa ru igãrhãmau ucucii Uyesu awu umbɔ uyanga nggu unapumbɔ, nu Umaryamu utsɛrha Ukirhoba, nu Umaryamu Umagadarha. ");
INSERT INTO ldb_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Uyesu aka anyã uyanga nu ungwɛ̃ imesa ha unga aka abema adɛ̃ɛ̃ akhapa umɔ, unga agɔr uyanga agɛ, <<A uze utsɛrh ha, uwɛrɛ awu ungwɛ̃ngo!>> ");
INSERT INTO ldb_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mɔcɛ unga agɔr ungwɛ̃ imesa ha agɛ, <<Uwɛrɛ unga awu uyango.>> Udzur ri ivang hã, ungwɛ̃ imesa ha akũ uyisa Uyesu azĩã aseisa nggu unga ri iyanga. ");
INSERT INTO ldb_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Uyesu aka ahwɛnga agɛ abina kishoo aka amaake, nu ngge itsuifɛr ubinkpi uku utsɛng ra Arherhu-Num, unga agɛ, <<Ugɔ̃ amɛ̃ ufɛr umum.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Itseu niyɔ itɔk nggu amɛ̃ inebi akika agbata idɛ̃ɛ̃ umɔ. Umbɔ abii usoso ra ake, anyangu iyɛk iyiki ider avak usoso ha na abere akũ azĩ ra angwĩ Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ivang Uyesu aka ayɛi amɛ̃ inebi akika agbata amaa, unga agɛ, <<Iki imaangge!>> Mɔcɛ unga arhɛrhi itsinga atsũwũka ipfunga. ");
INSERT INTO ldb_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Mɔcɛ anggbaashi abi Uyahuda ashɔ̃rhũ Ubirhatu unga atsu umbɔ abvũĩwe adak abirabɛ umbɔ aka anyapuwe na acipuwe ayormbɔ ru igãrhãmau acuciia ha. Akorhe rimi ubinkutsu awu unum ukpuku ugbisha abin unum ukpuku uwosha, umbɔ asi ibeembɔ ayor anyapa ri igãrhãmau acucii ru unum ukpuku uwosha. ");
INSERT INTO ldb_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Abi iwa aba ru umbɔ ha umbɔ aka anyapuwe nggu Uyesu abvũĩwe adak uner uwu inggbaashia, na azĩ abvũĩwe adak uner uwu uvaa ha. ");
INSERT INTO ldb_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bɔr umbɔ aka aba ru Uyesu, umbɔ anyã unga aka akpea, nggee umbɔ asi ibvũĩkumbɔ adaknga. ");
INSERT INTO ldb_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bɔr unying ra abi iwa ha akũ asawa atar Uyesu ri igbɔmnga, kanying adzirh nu amɛ̃ adzek. ");
INSERT INTO ldb_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Uner uwuku unyã abin hã kishoo aka akorhe, unga adzowuka ideka. Idekayɛ unga aka arherhe iwu idzidzɛrhe. Unga nibikanga ahwɛnga ugɛ unga arherhe idzidzɛrhe. Unga arherha akɛrɛ nggee umbi ikɛi ama awe ru imangmang. ");
INSERT INTO ldb_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Akɛrɛ akorhe ru ubinkpi umbɔ aka atsɛng ra Arherhu-Num atsuafɛr agɛ, <<Upfupfunga unying umbɔ asi ibvũĩkumbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Itsɛng Arherhu-Num ikɛi igɔr igɛ, <<Awuri irhimbɔ uwuruwi umbɔ aka atar.>> ");
INSERT INTO ldb_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Akɛrɛ aka atɔng Uyusuf uner Uarimatiya, uwuruwi aka awu ungwɛ̃ imesu Uyesu, ashɔ̃rhũ Ubirhatu unga adzowe ijeea unga ashupu iyor Uyesu. Bɔr unga akorha akɛrɛ ri iwɔk ubinkutsu unga agũ iwei anggbaashi abi Uyahuda. Ubirhatu abemuka, nggee unga azĩ ashupu iyor Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Unikodimu, uner ha aka aba ru Uyesu ru untsuuka, azĩã nggu Uyusuf. Unga akpɔm nggu atsei umbɔ iki iyisa umur aka akayi nggu uarho ake aka awe akirhograma isɔka itaar. ");
INSERT INTO ldb_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Umbɔ ikivarhambɔ ashupu ukom iyor Uyesu, asakuwe abin isung hã ri iyornga na akũ atorho abɛrh ukpɔ. Akɛrɛ awu ugau idza uner abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ra anangkɛ umbɔ aka anyapuwe unga, icang irham niyɔ iwu umɔ. Ru icang hã utai uku ufa ru ukpɔ umbɔ aki ingwɛ̃we ukom umɔ. Anasi ingwɛ̃mbɔ ukom umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ngge iki iwu unum abi Uyahuda aki igbisha abin unum ukpuku uwosha nu utai ha ukhapa umɔ, umbɔ adzakukumbɔ iyor Uyesu umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ri igɔ̃kpeka ru unum ukpu inggbaashia ri inuma utɔɔva, ukpe una usi isarkpɔ, Umaryamu Umagadarha azĩã ru utai ha, anyã utarh ukpuku utsim ra angwĩ utai ha uku ugɔ̃rhũkpɔ. ");
INSERT INTO ldb_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nggee unga atĩ azĩã ru Ubitru nu ungwɛ̃ imesa uwuruwi Uyesu aka abema, agɔr umbɔ agɛ, <<Aka atsũwũkumbɔ Uteijee ru udzaka! Umɛn isi ihwɛngmɛn anangkɛ umbɔ aka angwɛ̃we unga!>> ");
INSERT INTO ldb_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nggee umbɔ Ubitru nu angwɛ̃ imesa ha adzek azĩmbɔ ru utai ha. ");
INSERT INTO ldb_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ikivarhambɔ atĩtser, bɔr ungwɛ̃ imesa uwɔrɔ afaru Ubitru atɔnga, agbaashia azĩ atsĩã ra anang utai ha. ");
INSERT INTO ldb_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Unga agbapfu arhi anyã atorho hã aka anu, bɔr unga asi itsĩa ru utai ha. ");
INSERT INTO ldb_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Mɔcɛ Ubitru aba ra andzingnga, atsĩã ru utai ha na anyã atorho ha aka anu umɔ. ");
INSERT INTO ldb_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ikɛi anyã atorhakɛ umbɔ aka abope ni itsi Uyesu. Aka afeta anu ra anang akɔɔ awuweke nggu anang atorha ha. ");
INSERT INTO ldb_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mɔcɛ ungwɛ̃ imesa uwɔɔ uwuku uggbaashia azĩ atsĩ ra anang utai ha, atsĩã ru utai ha. Ivangyɛ unga aka anyã, unga awe ru imangmang. ");
INSERT INTO ldb_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Bɔr ri ivang hã umbɔ anasi ihwɛngmbɔ itsɛng Arherhu-Num iki igɔr igɛ awu ufang Uyesu awuri isoka ra akpe. ");
INSERT INTO ldb_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mɔcɛ angwɛ̃ imesa ha abvui azĩmbɔ ra ayambɔ. ");
INSERT INTO ldb_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Bɔr Umaryamu adɛ̃ɛ̃ ra awiya utai ha na aciu akpe. Adɛ̃ɛ̃ iciu akpe ha nukpi, unga agbapfu na arhi ru utai ha. ");
INSERT INTO ldb_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Unga anyã ípfu itser-Num ivaa nggu atorho aka aterha asei ra anangkɛ ukom iyor Uyesu uku unu bɔr ushikpɔ umɔ. Ipfu itser-Num hã unying isei udiki itsia, iyi ivaa isei udika adaknga. ");
INSERT INTO ldb_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ípfu itser-Num hã irhusa unga igɛ, <<A utsɛrh ha, ungo uciu usengu?>> Unga agɛ, <<Aka ashipukumbɔ iyor Uteijeemum, umum isi ihwɛng anangkɛ umbɔ aka akũna unga azĩ.>> ");
INSERT INTO ldb_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Unga aka amaa irherha arherha ha, unga adzipa anyã Uyesu aka adɛ̃ɛ̃ umɔ bɔr unga asi ihwɛngnga ugɛ awu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Uyesu arhusa unga agɛ, <<A utsɛrh ha, ungo uciu usengo? Ungo uni ubee ungamɔ?>> Unga akaifɛrhkɔ agɛ use awu uner itser icang hã, nggee unga agɛ, <<A uteiya, aba awu ungo ushupa unga, ungo udɛyiwa anangkɛ ungo uku ungwɛ̃we unga nu umum izĩ ishupa unga.>> ");
INSERT INTO ldb_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Uyesu agɔr unga agɛ, <<Umaryamu!>> Unga adzipa azĩ udiku Uyesu agɔr unga agɛ, <<Urabboni!>> Ri idũ abi Uyahuda agbena agburh, <<A umarhem.>> ");
INSERT INTO ldb_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Uyesu agɛ, <<Niba ukpɔmɔ umum, ubinkutsu umum inasi izĩmum ru Utɛ kata. Bɔr uzĩ ra angwɛ̃mɛn ugɔr umbɔ ugɛ, <Umum ibvui izĩ ru Utɛmum nu Utɛmbi, izĩ ru Unummum nu Unummbi.> >> ");
INSERT INTO ldb_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Umaryamu Umagadarha azĩ nggu isarhe ha, agɔr angwɛ̃ imesa ha agɛ, <<Umum inyãmum Uteijee!>> Unga adɛyiwe umbɔ ubinkpi Uyesu aka adɛyiwe unga. ");
INSERT INTO ldb_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Urhɛɛ uku uwe ru unum ukpu inggbaashia ri inuma utɔɔva, angwɛ̃ imesa Uyesu akɔng ananga unying. Iwei anggbaashi abi Uyahuda itsu umbɔ agbange angwĩ ubã kishoo. Uyesu aba adɛ̃ɛ̃ ra ateumbɔ na agɔr umbɔ agɛ, <<Ididɔɔr ima iwe nggu umbi!>> ");
INSERT INTO ldb_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Unga aka arherhe rimi amaa, mɔcɛ unga adɛyiwe aboknga nu igbɔmnga. Angwɛ̃ imesa ha agɔm anggɔm umbɔ aka anyã Uteijee. ");
INSERT INTO ldb_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Uyesu abvui agɔr umbɔ agɛ, <<Ididɔɔr ima iwe nggu umbi! Ru nyaku Utɛ aka adena umum, rimi hã umum ini idena umbi.>> ");
INSERT INTO ldb_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Unga aka arherhe rimi amaa, mɔcɛ unga afɛte uwoianga ru umbɔ, agɔr umbɔ agɛ, <<Àka ayɛi Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ubɛn unera umbi aka atsũwe arhimnga, aka atsũwũkumbɔ ake nukpɔ. Ubɛn unera umbi aka asi itsũwũkumbi, asi itsũwũkumbɔ nukpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Utoma, uwuruwi umbɔ iki iyisa Akãrhghwɛ̃, unying ru umbɔ usɔkdũmɛn hã, ashia umɔ nggu umbɔ ri ivang hã Uyesu aka aba. ");
INSERT INTO ldb_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nggee angwɛ̃ imesa ha agɔr unga agɛ, <<Umɛn inyãmɛn Uteijee.>> Bɔr Utoma agɔr umbɔ agɛ, <<Umum iba isi inyãmum ughwee akusa ra aboknga, ni ishɔmu itokmum ru ughwee akusa ha, ikɛi ni ishɔmu ubokmum ru ughwee asawa ha ri igbɔmnga, umum isi íwemum ri imangmang.>> ");
INSERT INTO ldb_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Inuma utɔrɔk iki itɔng angwɛ̃ imesa ha akɔng ri iya ha, ikɛi Utoma awu nggu umbɔ. Angwĩ ubã agbang, bɔr Uyesu aba adɛ̃ɛ̃ ra ateumbɔ na agɛ, <<Ididɔɔr ima iwe nggu umbi!>> ");
INSERT INTO ldb_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mɔcɛ unga agɔr Utoma agɛ, <<Utsu itokngo ru ungɛɛ, unyã abokmum. Unamu ubokngo ushɔma ri igbɔmmum. Uneke icicang, bɔr uwe ru imangmang.>> ");
INSERT INTO ldb_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Utoma agɔr unga agɛ, <<A Uteijeemum nu Unummum!>> ");
INSERT INTO ldb_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Uyesu agɔr unga agɛ, <<Ungo unyã umum ngge itsu ungo uwe ru imangmang. Idorh iwe nggu abirabɛ aka asi inyãmbɔ umum bɔr ana awembɔ ri imangmang.>> ");
INSERT INTO ldb_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Uyesu akorhe atsar abin idzeu arhɛrhɛ ra asu angwɛ̃ imesanga, akirakɛ umbɔ aka asi itsɛngmbɔ ru ubvur uwurɛ. ");
INSERT INTO ldb_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bɔr atsɛng akɛrɛ ru umbi awe ru imangmang ugɛ Uyesu unga awu Ukiristo, Ungwɛ̃ Unum, mɔcɛ ru ubok imangmang ru unga, umbi ama akpo urhɛ ri itsoknga. ");
INSERT INTO ldb_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Akɛrɛ ha aka amaa, Uyesu abvui adzeka ra angwɛ̃ imesanga nú ubang ukau ukugɔng ukpu Utibariya. Riminɛ ngge iki ikorhe. ");
INSERT INTO ldb_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Usiman Ubitru nu Utoma, uwuruwi ha umbɔ iki iyisa Akãrhghwɛ̃, nu Unataniyerh aka adzeku Ukana ukpu Ugarhirhi, nu angwɛ̃ Uzabadi, nu ikɛi angwɛ̃ imesa abɔɔ avaa awu urhɔnga. ");
INSERT INTO ldb_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ubitru agɔr umbɔ agɛ, <<Umum iwuri idze izĩ udɛm.>> Angwɛ̃ imesa abika abɔr agɛ, <<Umɛn izĩmɛn nggu ungo.>> Nggee umbɔ adzek atsĩ ukhukhɔɔ amɛ̃ azĩmbɔ. Bɔr ru utsuu ukpu ha umbɔ asi idzurmbɔ ubin. ");
INSERT INTO ldb_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ivang ukpe uku usar, umbɔ akpurha anyã Uyesu aka adɛ̃ɛ̃ ri ifɛn ukau ukugɔng hã, bɔr angwɛ̃ imesa ha asi ihwɛngmbɔ ugɛ awu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Uyesu ayisa umbɔ agɛ, <<Umbi awɛrhamum, umbi awembi ra abɛrh?>> Umbɔ agɛ, <<Ĩ'ĩ.>> ");
INSERT INTO ldb_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Uyesu agɔr umbɔ agɛ, <<Àka atang igbermbi udiku ubok ugha ukhukhɔɔ amɛ̃ hã, umbi awuri ikpombi akɔɔ.>> Ivangyɛ umbɔ aka atang, umbɔ asi idɛ̃ɛ̃ adarhumbɔ igber ha ubinkutsu, arhɛrha abɛrha amor. ");
INSERT INTO ldb_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Mɔcɛ ungwɛ̃ imesa ha uwu Uyesu aka abema agɔr Ubitru agɛ, <<Awu Uteijee!>> Ivang Usiman Ubitru aka agũ agɛ awu Uteijee, unga anyangu untamanga uwuruwi unga aka atsimuwe, atama na ater isha atsĩã ra amɛ̃. ");
INSERT INTO ldb_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Angwɛ̃ imesa abika abɔr igambɔ azĩmbɔ ru ubang ukau ukugɔng ru ukhukhɔɔ ha, agbĩrhã nggu igber ha iki itɔk nggu abɛrh ha. Umbɔ asi idermbɔ nggu abĩ ubang ukau ha, awu ru nyaki ivarha adaka anaka ataar (300). ");
INSERT INTO ldb_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ivang umbɔ aka adzeka nú abĩã, umbɔ anyã akãã urha ra anang hã nu abɛrh nú ake, nu uborodi. ");
INSERT INTO ldb_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Uyesu agɔr umbɔ agɛ, <<Àka akũ abɛrh akɔɔ aba ra akirakɛ umbi aka adzui icicɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Usiman Ubitru afũ ukhukhɔɔ amɛ̃ hã agbiir igber ha akũ azĩ ri ifɛn ukau ha. Igber ha itɔk nggu nggaa abɛrh unaka ni isɔka itɔ̃ɔ̃ nu ataar (153). Bɔr kishoo nu irhɛ abɛrh ha riminɛ, igber ha isi ipupungge. ");
INSERT INTO ldb_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Uyesu agɔr umbɔ agɛ, <<Àka aba atsu ukpee.>> Ra angwɛ̃ imesa ha, unera asi iwea ri ikeramɛn iyiki irhusa unga ugɛ, <<Ungo uwu ungamɔ?>> Umbɔ ahwɛngmbɔ agɛ awu Uteijee. ");
INSERT INTO ldb_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Uyesu aba anyangu uborodi adzowe umbɔ, na akorhe rimi nggu abɛrh ha. ");
INSERT INTO ldb_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Uyesu aka asok ra akpe, ide untaar riyɛ unga aka adzeyiwa ra angwɛ̃ imesanga. ");
INSERT INTO ldb_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ivangyɛ umbɔ aka amaa itsukpee, Uyesu agɔr Usiman Ubitru agɛ, <<A Usiman ungwɛ̃ Uyohana, ungo ubema umum unango ibibemayɛ abɛrɛ aka abema umum?>> Ubitru agɛ, <<Ĩĩ, Uteijee, ungo uhwɛngo umum iki ibema ungo.>> Uyesu agɛ, <<Ufuka angwɛ̃ itsurhimum.>> ");
INSERT INTO ldb_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Uyesu abvui arhusa unga agɛ, <<A Usiman ungwɛ̃ Uyohana, idzidzɛrhe ungo ubemungo umum?>> Unga agɛ, <<Ĩĩ, Uteijee, ungo uhwɛngo ugɛ umum ĩbemum ungo.>> Uyesu agɛ, <<Urhisa ídɔimum.>> ");
INSERT INTO ldb_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Uyesu arhusa unga ide untaar agɛ, <<A Usiman ungwɛ̃ Uyohana, ungo ubemungo umum?>> Amɛn Ubitru aghong, Uyesu aka arhusa unga idikũnga itaar agɛ, <<Ungo ubemungo umum?>> Unga agɛ, <<A Uteijee, ungo uhwɛngo abina kishoo, ungo uhwɛngo ugɛ umum ĩbemum ungo.>> Uyesu agɛ, <<Ufukuwa ídɔimum. ");
INSERT INTO ldb_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Umum indɛyiwa ungo idzidzɛrhe, ivangyɛ ungo uku uwu uwɛdzɛm, ungo iki isaku utsim abinngo nibikango nu uzĩ anangkɛ ungo uku ubee. Bɔr ivangyɛ ungo uba ukɔ̃ɔ̃ ungo uwuri ibera abokngo nu uwɔɔ atsima ungo atorho na akũna ungo azĩ anangkɛ ungo uku usi ibeengo izizĩ.>> ");
INSERT INTO ldb_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Uyesu arherhe rimi unga adɛyiwe ikpũ akpe Ubitru aka awuri ikpe akpoi Unum. Mɔcɛ unga agɔr Ubitru agɛ, <<Udɔsa umum.>> ");
INSERT INTO ldb_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ubitru adzipa arhi undzing anyã ungwɛ̃ imesa ha, uwuruwi Uyesu aka abema aka adɔsa umbɔ. Uwɛrɛ ha unga awu ungwɛ̃ imesa ha uwuku ufata ri ikɔ Uyesu ri ivang iki igha Irhowa Iyiki Igar Utɔng na arhusu Uyesu agɛ, <<A Uteijee, awu ungamɔ awuri igha adakngo?>> ");
INSERT INTO ldb_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ivang Ubitru aka anyã unga, unga arhusu Uyesu agɛ, <<A Uteijee, utsak uwurɛ awu use ikorhe nggu unga?>> ");
INSERT INTO ldb_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Uyesu agɛ, <<Umum iba ibee unga abɛk utsɛku umum iki ibvui iba, awu use awe akingo? Awu ufang ungo udɔsa umum!>> ");
INSERT INTO ldb_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Akɛrɛ ha atsu arherhe ha atɛ̃rhã ra abika adɔsu Uyesu ugɛ ungwɛ̃ imesa ha asi íkpea. Bɔr Uyesu asi igɔra ugɛ asi íkpea, agɔr agɛ, <<Umum iba ibee unga abɛk utsɛku umum iki ibvui iba, awu use awe akingo?>> ");
INSERT INTO ldb_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Uwɛrɛ ha unga awu ungwɛ̃ imesa ha aka ani idzowe ideka ra abin akɛrɛ, ikɛi unga atsɛng ake. Umɛn ihwɛngmɛn idekanga iwu idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bɔr abin akɔɔ arhɛrhɛ Uyesu aka akorhe. Agɛ umbɔ atsɛngmbɔ ubɛn ubin, umum ikaifɛrhkɔ ugɛ upfunga kishoo usi íwekpɔ ru ubã ukpuku udɛ̃ɛ̃ unyanga abvurkɛ umbɔ aka itsɛng.");
INSERT INTO ldb_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","A uze Utiyofirhu, ru ubvurmum uwu inggbaashia, umum itsɛng abina kishoo akirakɛ Uyesu aka atirha akorhe na amesuwe ");
INSERT INTO ldb_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","utsɛku unumkpi umbɔ aka ashupa unga afũ azĩ ra afã. Ipfu Isarsatangge iki idarh unga amaa itsu itser ra abi itser Uyesu unga aka asɛng. ");
INSERT INTO ldb_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Unga aka ahwa ayetnum amaa, unga adɛyiwe itsinga ra abi itser Uyesu ha na akorhi ikpũ abinkɛ aka atsu umbɔ anyã unga awea ru urhɛ. Unga adzeyiwa ru umbɔ inuma isɔka inaa na arherhe arherhe Iyɛrhe Unum. ");
INSERT INTO ldb_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ivanga niyɔ unga aka asei ighigha nggu umbɔ, unga agɔr umbɔ agɛ, <<Àka niba adzembi ru Urusharhima, bɔr àka adzɛu izũwũ Utɛmum aka abemuwa, umum iki irherha ngge ri igigũmbi. ");
INSERT INTO ldb_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Uyohana asorhuwe anera ubɔtisima nggu amɛ̃, bɔr inuma ukunjiir iki iba, awuri isorhuwa umbi ubɔtisima nggu Ipfu Isarsatangge.>> ");
INSERT INTO ldb_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nggee umbɔ aka akɔng, umbɔ arhusa unga agɛ, <<A Uteijee, awu icɛrɛ ungo iki ibvui udzowe iyɛrhe Uisrairha?>> ");
INSERT INTO ldb_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Bɔr unga agɔr umbɔ agɛ, <<Asi iwea umbi awuri ihwɛng ivanga use inumyɛ Utɛ aka angwɛ̃ ri ijeenga. ");
INSERT INTO ldb_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Bɔr umbi awuri iyɛimbi ijee ri ivangyɛ Ipfu Isarsatangge iki icipuwa nu umbi, umbi awuri iwu idekamum ru Urusharhima, nu kishoo abĩ Uyahudiya nu aki Usamariya, uzĩ utsĩ ra abĩã kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Unga aka arherha akɛrɛ ha amaa, umbɔ ashupa unga ra asumbɔ afũ afafã, nu amɛɛ atsirke unga ri inyĩnyãmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Umbɔ aka atsu asumbɔ arhi izizĩnga ra afã, kanying inera ivaa itsim atorho akika aterha idɛ̃ɛ̃ ikhapa nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Iner ha igɔr umbɔ ugɛ, <<Umbi abi Ugarhirhi, awu use utsu umbi adɛ̃ɛ̃ nggimi anu irhi afã? Uyesu ha umbɔ aka ashupa ru umbi ha akũ azĩmbɔ ra afã, awuri ibvui abanga ru nyaka umbi aka anyã ififũnga ra afã.>> ");
INSERT INTO ldb_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mɔcɛ umbɔ abvui azĩ Urusharhima adzeku Igũ Acucii Uzaitun, iyiriyɛ iki ikhapa ru Urusharhima, iderngge iki iyongge ukirhomita unying. ");
INSERT INTO ldb_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Umbɔ aka azĩ atsĩ, umbɔ afũmbɔ ru ubã afã ra anangkɛ umbɔ aka asei. Awu umbɔ Ubitru, Uyohana, Uyaku nu Uandarawu, Ufirhibu nu Utoma, Ubatorhomi nu Umatiyu, Uyaku ungwɛ̃ Uharhfa nu Usiman Uzarhoti, nu Uyahuda ungwɛ̃ Uyaku. ");
INSERT INTO ldb_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Abɛrɛ ha kishoo aka isaka atsu atsimbɔ akɔng ri ifɛn-Num nggu amɛn unying, nggu akatsɛrh abɔɔ nu Umaryamu, uyisa Uyesu, nu angwɛ̃mbɔ Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Inum hã niyɔ Ubitru aka asok adɛ̃ɛ̃ ri ikikɔng abika adɔsa, iyiriyɛ iki iyongge inera unaka ni isɔka ivaa, na agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","<<Umbi angwɛ̃mɛn nu anapumɛn, awu ufang ngge iki itsuifɛr Arherhu-Num aki Ipfu Isarsatangge iki irherhe ishaisha ra angwĩ Udauda, ri itsi Uyahuda, unga aka agbaashia ra abika adzur Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Unga uwi awe ru umɛn, awea ri itser ri itser iyɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nggu itosayɛ unga aka akpo iyi amɛn aka abewe, Uyahuda akũ agoi idɛɛ, umɔ unga aka agba nggu itsia, iyora iyar iyanga, abina anaanga kishoo adzeka awiya. ");
INSERT INTO ldb_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kishoo anera ru Urusharhima agũmbɔ akɛrɛ ha, nggee umbɔ ayisi idɛɛ ha agɛ <<Uakarhdama,>> ri idũmbɔ agbena agburh <<Idɛɛ Adzirh.>> ");
INSERT INTO ldb_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Unga agɔr agɛ, <<Ubinkutsu atsɛngmbɔ ru Ubvur Ambom ugɛ, << <Uneke iyanga ima iwu arhang, utsur unera aseisa umɔ,> nu, << <Uneke itsernga ikɛi uner uwɔɔ ama anyangu ukam.> ");
INSERT INTO ldb_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Nggee awu ufang umɛn isɛng unera unying ra aner abɛrɛ aka awu nggu umɛn ri ivanga kishoo Uteijee Uyesu aka awu nggu umɛn, ");
INSERT INTO ldb_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","udzur ri ivangyɛ Uyohana aka asorhuwe unga ubɔtisima uba utsĩ ri ivangyɛ umbɔ aka ashupuwe unga ra ateumɛn. Awu ufang umɛn isɛng unera aka awe ru ideka isisoknga ra akpe nggu umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nggee umbɔ aden inera ivaa, Uyusuf umbɔ iki iyisa Ubarsabba, ikɛi umbɔ iki iyisa Ujustu, nu Umatiya. ");
INSERT INTO ldb_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mɔcɛ umbɔ afɛn-Num agɛ, <<A Uteijee, ungo uhwɛng amɛn anera kishoo. Ra abɛrɛ ikivarhambɔ, udɛyiwa uwuruwi ungo uku usɛng ");
INSERT INTO ldb_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","unga anyangi itser uner itser Uyesu, iyi Uyahuda aka aneke na azĩã anang hã aka awe akinga.>> ");
INSERT INTO ldb_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mɔcɛ umbɔ atang isɛng ru umbɔ. Umatiya unga agha, nggee umbɔ atoma unga nggu abi itser Uyesu, udom hã. ");
INSERT INTO ldb_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Unum irhowu Upentiko iki iwe, abika adɔsa kishoo akɔng ananga unying. ");
INSERT INTO ldb_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kanying umbɔ agũ irhak iki idzeka afã ru nyaku ugba ukom, udzeka afã uba utɔkpɔ iyakɛ umbɔ aka asei. ");
INSERT INTO ldb_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mɔcɛ umbɔ anyã ubina ru nyaki ikon urha, uku ugasha ucipuwa ra atsimbɔ unying anying. ");
INSERT INTO ldb_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nu kishoo awu nggu Ipfu Isarsatangge, atsĩmbɔ irherhe idũ abikase Ipfu-Num iki idzowe umbɔ ijeea. ");
INSERT INTO ldb_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ri ivang hã ru Urusharhima abi Uyahuda abi iwei Unum aka asei umɔ adzeka ru ubɛn abĩ upfung ukpirɛ. ");
INSERT INTO ldb_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Umbɔ aka agũ ubvun ugba ha, anera aka akɔng adzunumbɔ, ubinkutsu ubɛn unera agũ umbɔ arherhe idũnga. ");
INSERT INTO ldb_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Umbɔ adzeidzeu akarhãrhã, na arhusa agɛ, <<Kishoo abika arherha arherha ha, asi iwembɔ aner Ugarhirhi? ");
INSERT INTO ldb_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Awu use utsu ubɛn unera ru umɛn agũ umbɔ arherhe idũnga? ");
INSERT INTO ldb_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Umɛn abɛ iwu abi Upartiya, nu Umadiya nu Uerhama, nu aner abĩ Umesofotamiya, nu abi Uyahudiya nu abi Ukafadokiya, nu abi Upanta nu abi Uasiya, ");
INSERT INTO ldb_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","nu abi Ufirijiya nu abi Upamfirhiya, aka adzeka abĩ Umasar, nu ikɛi abɔɔ aka akhapa ru abĩ Urhibiya aka akhapa ru Usayirin. Umɛn abɔɔ idzeku Uroma, ");
INSERT INTO ldb_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ru umɛn hã, abɔɔ awu abi Uyahuda na abirabɛ aka adzipa adɔsa agbeyambɔ, ikɛi abɔɔ awu abi Ukarita nu abi Urharaba, kishoo iki igũ umbɔ anu irherhe abin idzeu Unum ri idũmɛn!>> ");
INSERT INTO ldb_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kishoo adzeidzeu na adzunumbɔ, agɔr adɔkambɔ agɛ, <<Agben akɛrɛ ha awu use?>> ");
INSERT INTO ldb_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Bɔr abɔɔ umɔ ayɛia umbɔ agɛ, <<Ahwa adɛ afĩrhã!>> ");
INSERT INTO ldb_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bɔr Ubitru abere nggu umbɔ udom hã, atsarhi irhaknga arherhe arherhe nggu anera agɛ, <<Umbi abimɛn abi Uyahudiya nu kishoo abi Urusharhima, umum idɛyiwa umbi arherhe akɛ, àka akpeto ru ubinkpi umum iki irherhe. ");
INSERT INTO ldb_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Anera abɛrɛ asi ifĩrhũmbɔ adɛ ru nyaka umbi aka akaifɛrhkɔ, nggayɛ awu akara utɔɔrha aki ukpee! ");
INSERT INTO ldb_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ĩ'ĩ, awu ubin hã nukpi uner uwuku usɔm Arherhu-Num Uyowɛrh aka arherhe agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","<< <Unum agɔr agɛ, ri inum iyiki imimasha, umum iwuri itsuke Ipfumum ra anera kishoo. Nu awɛkacimbi akatsɛrh na akatsak awuri isɔm Arherhu-Num, na awɛdzɛmmbi awuri inyãmbɔ irhi, nu akakũmbi ikɛi awuri irheyimbɔ urhɔ. ");
INSERT INTO ldb_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ra agãrhãmum akatsɛrh nu akatsak, umum iwuri itsuke Ipfumum ri inum hã, nu umbɔ ikɛi awuri isɔmmbɔ Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Umum iwuri idɛyiwe abin idzeu afafã ra afã, na atsar anɔnɔr nu abĩ, adzirh, nu urha, nu ikɛi azoo aka afĩrhã asok arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ishaa unum iwuri idzipa iwu uzĩ, ufɛ̃ ikɛi uwuri iwu uku uzhãĩ ru nyaka adzirh, kata ibiba nggaa ikpikpoi unum ukpu Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nu ubɛn unera aka afɛn Uteijee awuri ikpoa ififɔrh.> ");
INSERT INTO ldb_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","<<Umbi abimɛn abi Uisrairha, àka akpeto ra arherhe akɛrɛ, Uyesu aka awu uner Unazarat unerwi Unum aka asɛng unga akorha abin idzeu, nu abin igbigba na atsar, akirakɛ Unum aka akorhe ru umbi ri itsinga, ru nyaka umbi itsikammbi aka ahwɛng. ");
INSERT INTO ldb_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Utsak uwurɛ adzowe unga ru umbi ri ikikorhu Unum ikɛi ri itsernga nu ihwihwɛngnga, umbi akũ akusa akwɛr anyapuwe unga nu igãrhãmau ucucii, afɛre unga ra abok abi arhim. ");
INSERT INTO ldb_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Bɔr Unum asoyika unga na ashɔɔrka unga ru uver akpe, ubinkutsu akpe asi idɛ̃ɛ̃ akpɔmke unga. ");
INSERT INTO ldb_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Udauda arherhunga arherhe ri itsinga agɛ, << <Ubɛn ivang umum inyã Uteijee awu nggu umum. Ubinkutsu unga awe ru ubok ughamum, umum isi ízusumum. ");
INSERT INTO ldb_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nggee amɛnmum agɔm anggɔm, arhɛmmum agũibɛn akarhãrhã iyormum ikɛi iwuri iwosha ri ifosa, ");
INSERT INTO ldb_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ubinkutsu, ungo usi ínekango umum ru udzak, use ungo ineke Usarkasar Unerngo avɔ̃ɔ̃. ");
INSERT INTO ldb_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ungo uku utsu umum ihwɛng utsĩndĩ urhɛ, ungo uwuri itɔka umum nggu anggɔm ra anangngo.> ");
INSERT INTO ldb_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","<<Umbi abimɛn abi Uisrairha, umum iwemum ri ikeramɛn iki idɛyiwa umbi ugɛ utoka atokamɛn Udauda aka akpea nu umbɔ aka adzakukumbɔ unga, ikɛi udzaknga uwu nggu umɛn uba utsĩ irherɛ. ");
INSERT INTO ldb_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bɔr unga awu uner uwuku usɔm Arherhu-Num, na ahwɛnga Unum aka abemuka unga nggu uyirh agɛ, unga awuri itsu unangnga unying nu utarh isei iyɛrhanga. ");
INSERT INTO ldb_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Unga aka anyã, arherha arherhe isisok Ukiristo ra akpe, agɛ asi ínekukumbɔ iyornga ru udzak, iyornga ikɛi isi ívɔ̃ngge. ");
INSERT INTO ldb_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Unum aka asoyika Uyesu ha nggu urhɛ, nu umɛn kishoo iwu ideka umɔ ni idzidzɛrha ha. ");
INSERT INTO ldb_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Unum adzowe unga imor nu ubok ughanga, unga aka ayɛi ibibemuwe Ipfu Isarsatangge ru Utɛ, na awupuwa ubinkpi umbi aka anyã na agũ icɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Udauda asi ifũã ra afã, bɔr unga agɔr agɛ, << <Uteijee agɔr Uteijeemum agɛ, <<Usei nu ubok ughamum, ");
INSERT INTO ldb_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","utsɛku umum iki itsu anggamtsakngo awu ubin uku utsorhe andaidakngo.>> > ");
INSERT INTO ldb_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","<<Nggee, uneke aner Uisrairha ahwɛng ugɛ, Unum aka atsu Uyesu uwuruwi, umbi aka anyapuwe nu ucucii awu Uteijee na awu Ukiristo ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Anera aka agũ rimi, amɛnmbɔ agbɛra adzɛu, na agɔr Ubitru nu abi itser Uyesu abɔɔ, agɛ, <<Umbi angwɛ̃mɛn, umɛn ikorhi uguse?>> ");
INSERT INTO ldb_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ubitru agɔr umbɔ agɛ, <<Àka adzipa ra arhimmbi umbɔ asorhuwa umbi ubɔtisima ri itsok Uyesu Ukiristo ngge atsũwe arhimmbi. Ikɛi umbi awuri iyɛimbi izũwũ Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ubinkutsu ibibemuwe ha iwu iyimbi nu angwɛ̃mbi nu kishoo abi anang aka ader, umbɔ abirabɛ Uteijee Unummɛn aka awuri iyisa umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Nggu irhɛm iyɔɔ irhɛirhɛ unga aka adzowe itsũwã na afituwe umbɔ agɛ, <<Àka afɔrh atsimbi ru ubinkpi uku udzɛu abi amɛn akatãrhã aki udan ukpirɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Abika ayɛi isarhanga hã umbɔ akorhuwe umbɔ ubɔtisima, ru unum hã umbɔ ayombɔ inera anaka agɔnga ataar (3,000) atoma ri irhɛɛmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Umbɔ atsu atsimbɔ ri ikpeto ri imesa abi itser Uyesu, nu iwɛrhɛ abika adɔsa, nu itsɔku uborodi ri ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Unum akorha abin igbigba na abin idzeu arhɛrhɛ ru ubok abi itser Uyesu, nu ubɛn unera agũ idzeu. ");
INSERT INTO ldb_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Kishoo abika adɔsa awu unying, nu abinmbɔ kishoo awu aki adɔkambɔ. ");
INSERT INTO ldb_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Agoyiwe abin ukammbɔ, na agashuwe uhwɛka ra adɔkambɔ uku kpengkpeng ri itsũwãmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ubɛn unum umbɔ anu ikɔng ru ufɔm Iya-Num nggu amɛn unying. Agha ubingha ananga unying ra ayambɔ, agha na ahwa nggu anggɔm nu itɛnamɛn, ");
INSERT INTO ldb_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","akpoi Unum na awe ru izama ra anera kishoo. Ubɛn unuma Uteijee anu itomuwe umbɔ abika afɔrh. ");
INSERT INTO ldb_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Unuma nukpɔ Ubitru nu Uyohana azɛ̃rhã azĩ ri Iya-Num ri ivang ifɛn-Num ra akara ataar ra atenuma. ");
INSERT INTO ldb_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Icɛ unera nuwɔ amar unga akatarhu, ubɛn unuma umbɔ asaka ashupa unga azĩ adene ru angwĩ ufɔm Iya-Num umbɔ iki iyisa agɛ, <<Angwĩ Ufɔm Aka aze,>> nu unga afɛn uhwɛk ru abika azĩ ru ufɔm Iya-Num. ");
INSERT INTO ldb_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Unga aka anyã Ubitru nu Uyohana aka awuri itsitsĩ, unga afɛnu uhwɛk ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Umbɔ Ubitru nggu Uyohana aka atsu asumbɔ arhi unga, mɔcɛ Ubitru agɔr unga agɛ, <<Urhi umɛn!>> ");
INSERT INTO ldb_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nggee amɛn ukatarhu ha azĩke udikambɔ, akaifɛrhkɔ iyɛi ubin ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Bɔr Ubitru agɛ, <<Umum ishimum ru uhwɛk, bɔr ubinkpi umum iki iwurakpɔ ukpɔ umum iki ĩdzaa ungo. Ri itsok Uyesu Ukiristo uwu Unazarat usisok, uzɛ̃rhuzɛ̃rhã.>> ");
INSERT INTO ldb_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Akũ ubok akpɔm ubok ughanga abera unga, kanying adaknga ri ikpor adaknga awu akeketake. ");
INSERT INTO ldb_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Unga ater isha! Asok adɛ̃ɛ̃, na atirhi uzɛ̃rhã atsĩ ru ufɔm Iya-Num nggu umbɔ, azɛ̃rhã na atengasha na akpoi Unum ikɛi. ");
INSERT INTO ldb_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ivangyɛ kishoo anera aka anyã unga aka azɛ̃rhã na akpoi Unum, ");
INSERT INTO ldb_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","umbɔ ikɛi ahwɛngmbɔ ugɛ awu unga anu isei ru Angwĩ Ufɔm Iya-Num Aka Aze. Umbɔ adzeidzeu akarhãrhã nggu ubinkpi uku ikorhe nggu unga. ");
INSERT INTO ldb_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ukatarhu ha aka akpɔm abokmbɔ Ubitru nu Uyohana, mɔcɛ anera kishoo adzeidzeu na atĩ abambɔ ru umbɔ ru anangkɛ umbɔ iki iyisa agɛ angwĩ iya Usorhomon. ");
INSERT INTO ldb_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ubitru aka anyã rimi, unga agɔr umbɔ agɛ, <<Umbi aner Uisrairha, awu use utsu akɛrɛ atsu umbi adzeidzeu? Awu use utsu ikɛi umbi arhi umɛn ugɛɛ awu ijeemɛn use awu idɔsu Unummɛn itsu ukatarhu ha azɛ̃rhũ uzɛ̃rhã? ");
INSERT INTO ldb_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Unum uwu Uibrahim, Uishaku nu Uyakubu, Unum uwu atokamɛn, unga akpoi ugãrhãnga Uyesu, uwu ha umbi aka adzowe unga umbɔ afɛre, ikɛi umbi aka akpɛ̃mbi unga ra asu Ubirhatu, nggayɛ unga abee itsuwe unga. ");
INSERT INTO ldb_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Umbi akpɛ̃mbi Usarkasar ha Uner Uwuku Arhurhika, na afɛna umbɔ atsũwã umbi uner uwuku ufɛr aner. ");
INSERT INTO ldb_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Umbi afɛre uner uwuku udzowe urhɛ, bɔr Unum azituka unga ra akpe. Umɛn iwu ideka ra akɛrɛ ha. ");
INSERT INTO ldb_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Awu imangmang ru itsok Uyesu, ngge itsu utsak uwurɛ umbi aka ahwɛng na anyã awu akerketawɔ. Awu itsok Uyesu nu imangmangyɛ iki iba ru unga, ngge idzowe utsak uwurɛ ikikerhe, umbi kishoo aka anyãmbi. ");
INSERT INTO ldb_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","<<Umbi abimɛn, umum ihwɛng awu ida ihwihwɛng itsu umbi akorhe rimi, ru nyaka anggbaashimbi. ");
INSERT INTO ldb_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bɔr awu akɛrɛ ha Unum aka atsu ake atsuafɛr ra arherhakɛ unga aka arherhe ra angwĩ abika asɔm Arherhu-Num kishoo, agɛ Ukiristo awuri ihwa uver. ");
INSERT INTO ldb_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nggee àka adzipa ra arhimmbi, na adɔsu Unum, nggee itsú umbɔ asorhe arhimmbi, ");
INSERT INTO ldb_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","nu unga ama adene Ukiristo ha, uwuruwi unga aka asɛng unga awu uwu umbi, Uyesu ififɔrhmbi. ");
INSERT INTO ldb_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Awu ufang unga asei ra afã utsɛku ivangyɛ Unum aka ifaruwe abina kishoo, ru nyaka unga aka abemuwe ishaisha ra angwĩ asarkasar abika asɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ubinkutsu Umusa agɔr agɛ, <Uteijee Unummbi awuri iberuwanga umbi uner uwuku usɔm Arherhu-Num uwɔɔ ra abimbi, ru nyaka umum, awu ufang umbi aka igũ ubinkpi unga aka awuri idɛyiwa umbi kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ubɛn unerwi aka asi ikpea ato ru uner uwuku usɔm Arherhu-Num hã, awuri itsũwũkumbɔ unga ra anernga.> ");
INSERT INTO ldb_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","<<Idzidzɛrhe, kishoo abika asɔm Arherhu-Num, udzur ru Usamairha uba ra asu, kishoo arherhambɔ arherhe aki inum iyɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Umbi awu abika agha ukam abika asɔm Arherhu-Num, nu ukam ibibemuwe-Num ra atokambi. Unga aka agɔr Uibrahim agɛ, <Ru unangngo anera kishoo ru upfung awuri ikpo idorh.> ");
INSERT INTO ldb_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Unum aka aberuwe ugãrhãnga, unga agbaashia adene unga aba ru umbi, ru umbi akpo idorh ri idzipuwe ubɛn unera ru umbi ru utsĩndĩ uwuku ubewanga.>> ");
INSERT INTO ldb_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ivangyɛ umbɔ Ubitru nggu Uyohana aka adɛ̃ɛ̃ arherhe nggu anera, abika adzowe idɛm-Num nu anggbaashi abi idzɛu Iya-Num nu abi Usaduki aba ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Umbɔ agũ avɔm, ubinkutsu abi itser Uyesu anu imesuwe anera ugɛ ikom iwuri isongge nggu urhɛ ru nyaku Uyesu aka asok ra akpe. ");
INSERT INTO ldb_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Umbɔ adzur umbɔ Ubitru nu Uyohana agbange utsɛku ukpe unum uvaa, ubinkutsu urhɛɛ uku uwekpɔ. ");
INSERT INTO ldb_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Bɔr anera arhɛrhɛ abika agũ isarhe ha awe ru imangmang, nu irhɛɛ abika adɔsa iyongge anaka agɔnga atɔ̃ɔ̃. ");
INSERT INTO ldb_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Unum uvaa, ayɛrhe nu akakũ nu abika amesuwe ikpem umbɔ akɔng ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Uhanana Ukugɔng Uwuku Udzowe Idɛm-Num awu umɔ, nggu Ukayafa, nu Uyohana, nu Uarhekzanda, nu ikɛi kishoo abirabɛ aka awu ru ubã abika adzowe idɛm-Num. ");
INSERT INTO ldb_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Atsu umbɔ akũ Ubitru nu Uyohana aba adɛ̃ɛ̃ ra ateumbɔ, na atirhi irhusa umbɔ agɛ, <<Umbi akũ ijee iyikisong use itsok iyikisong akũ akorha akɛrɛ ha?>> ");
INSERT INTO ldb_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mɔcɛ Ubitru, awu nggu Ipfu Isarsatangge, unga agɔr umbɔ agɛ, <<Umbi ayɛrhe nu akakũ anera! ");
INSERT INTO ldb_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Umbi ayisa umɛn irherɛ, arhusa umɛn icicorhayɛ umbɔ aka akerhuwe ukatarhu uwurɛ, umbi abee ihwɛng ubinkpi uku ukerhuwe unga? ");
INSERT INTO ldb_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Umɛn ibee umbi nu abi Uisrairha kishoo ahwɛng ugɛ, awu ri itsok Uyesu Ukiristo uwu Unazarat, uwuruwi umbi aka afɛre unga ri inyapuwe unga nu igãrhãmau ucicii, uwuruwi Unum aka asoyiwe ra akpe, atsu utsak uwirɛ akerhe adɛ̃ɛ̃ akerketawɔ ra asumbi. ");
INSERT INTO ldb_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Uyesu ha unga awu << <Utarhkpi umbi abi idzin aka akpɛ̃, ukpɔ uwu utarh angboki idzin.> ");
INSERT INTO ldb_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Asi íkpombɔ ififɔrh ru uner uwɔɔ, asi idzowukumbɔ itsok ikɔɔ ru upfung umɛn iki ikpo ififɔrh ri ike.>> ");
INSERT INTO ldb_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ivangyɛ ateiya aka anyã ikeramɛn Ubitru nu Uyohana, umbɔ ahwɛngmbɔ ugɛ umbɔ asi itsĩmbɔ imesa, umbɔ adzeidzeu, na adiki ihwɛng agɛ umbɔ awu nggu Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Bɔr umbɔ aka anyã utsa uwuku ukerhe ha adɛ̃ɛ̃ nggu umbɔ, umbɔ asi ikpombɔ ubinkpi umbɔ aka irherhe. ");
INSERT INTO ldb_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nggee umbɔ atsu umbɔ adzembɔ ru udzepurhe ha, na akɛki itsũwã nggu adɔka. ");
INSERT INTO ldb_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Umbɔ arhusa agɛ, <<Umɛn ikorhi uguse nggu anera abɛrɛ? Ubinkutsu anera ru Urusharhima aka ahwɛngmbɔ ugɛ aka akorhumbɔ nggaa abin idzeu ru abok anera abɛrɛ, umɛn isi ídɛ̃ɛ̃ itsɛyimɛn. ");
INSERT INTO ldb_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bɔr utsur arherhe ha atsĩ amaake ra anera, umɛn igbiite atombɔ utsur umbɔ abvui arherhumbɔ arherhe nggu anera ri itsok ha.>> ");
INSERT INTO ldb_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mɔcɛ umbɔ ayisa abi itser Uyesu ha atsu umbɔ niba abvui arherhumbɔ arherhe, use imesa ri itsok Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Bɔr Ubitru nu Uyohana adzipa agɛ, <<Àka avarhe nibikambi irhikungge ra anang Unum umɛn ĩdɔsa arherhambi ni ineke ĩdɔsa Arherhu-Num? ");
INSERT INTO ldb_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ubinkutsu, umɛn isi ídɛ̃ɛ̃ inekukumɛn irherhe ubinkpi umɛn iki igũ ni inyã ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Umbɔ aka atoma aziya umbɔ, umbɔ atsũwe umbɔ azĩmbɔ. Asi ikpombɔ ubinkpi umbɔ aka ikorhe na adzowe umbɔ uver, ubinkutsu anera kishoo akpoi Unum ru ubinkpi uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Utsa ukatarhu uwuku ukpo idzeu ikikerhe ha, imɛknga iki inangngge isɔka inaa. ");
INSERT INTO ldb_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ivangyɛ umbɔ aka atsũwe umbɔ Ubitru nu Uyohana azĩmbɔ ra abimbɔ, umbɔ asɔme kishoo abinkɛ ateiya abika adzowe idɛm-Num nu akakũ aka adɛyiwe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ivangyɛ umbɔ aka agũ rimi, umbɔ atsarhi irhakmbɔ ri ifɛn-Num nggu amɛn unying agɛ, <<A Uteijee uner ijee kishoo, ungo umuna afã nggu abĩ nu akau akagɔng, nu abina kishoo aka awe ra ake. ");
INSERT INTO ldb_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Arherhango ri Ipfu Isarsatangge, ungo uku urherhe ra angwĩ ugãrhãngo, utokamɛn Udauda ugɛ, << <Awu use utsu abĩã kishoo agũ uvɔm nu anera akaifɛrhkɔ iyiki itãrhã? ");
INSERT INTO ldb_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ayɛrhe ru upfung agbopa atsimbɔ abee iwa, nu anggbaashi abĩã akɔng ananga unying awe ru igamtsa nggu Uteijee, nu ikɛi Ukiristonga.> ");
INSERT INTO ldb_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Awu idzidzɛrhe, uyɛrhe Uhiridu nu Ubuntu Ubirhatu agbopumbɔ itsi nggu atsen abi Uyahuda nu aner Uisrairha ru uteu ukpirɛ. Awembɔ ri ikpikpɛ̃ɛ̃ nggu ugãrhãngo Uyesu usarkasar, uwuruwi ungo uku usɛng unga awu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Umbɔ akorhe abinkɛ kishoo ijeengo nu ibibemango iki itsu ishaisha ugɛ ngge ikorhe. ");
INSERT INTO ldb_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","A Uteijee, ungo ugũo iziziyambɔ ra atsimɛn nu uma uyike agãrhãngo nggu ikeramɛn irherha arherhango. ");
INSERT INTO ldb_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Uberu ubokngo ukpuku ukerhe ikɛi ukorhu nggaa abin idzeu nu igbigba ri itsok ugãrhãngo Uyesu usarkasar.>> ");
INSERT INTO ldb_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Umbɔ aka afɛn-Num amaa, anangkɛ umbɔ aka akɔng adiki izizusa. Mɔcɛ atsuke umbɔ kishoo Ipfu Isarsatangge, umbɔ adɛ̃ɛ̃mbɔ irherha Arherhu-Num nggu ikeramɛn. ");
INSERT INTO ldb_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mɔcɛ kishoo abika adɔsa amɛnmbɔ awu unying. Ubɛn unera asi iwea ru ubin ukamnga, bɔr umbɔ agasha abinkɛ umbɔ aka awurake nggu adɔka. ");
INSERT INTO ldb_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nggu ijee nggaa abi itser Uyesu aka adɛ̃ɛ̃ arherhe isisok Uteijee Uyesu ra akpe, nu imimuta irhɛirhɛ iki iwu ru umbɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Unera asi ibee ubin adaka ru umbɔ. Ubinkutsu abi icang irham nu abi aya agoyiwe ake na akũ uhwɛka ");
INSERT INTO ldb_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aba adzowe ra abi itser Uyesu, umbɔ agashuwe anera ri itsũwãmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Rimi hã uner itsok Uyusuf aka akorhe awu unang Urhawi, adzeku Usayifuru, uwuruwi abi itser Uyesu iki iyisa unga Ubarnaba, agbena agburh <<Uner uwuku Ufituwe.>> ");
INSERT INTO ldb_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Unga aka agoshe icangnga iyɔɔ, unga akũ uhwɛka aba adzowe abi itser Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Unera nuwɔ itsoka igburh Uhananiya, nggu utsɛ̃nga Usafiratu, agoshe icang irhammbɔ iyɔɔ. ");
INSERT INTO ldb_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nggu ihwihwɛng utsɛ̃nga, unga atsũ uhwɛka angwɛ̃ ukpunga na akũ ukpuku ubɔr aba angwɛ̃we ra adak abi itser Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Mɔcɛ Ubitru agɛ, <<A Uhananiya, awu use utsu ungo uneke Ushaitan atsĩ ra amɛnngo? Ungo ugbɛrangwĩ utsuke Ipfu Isarsatangge, ungo ikɛi utsũɔ̃ ubin ukpɔɔ ru uhwɛk icanga? ");
INSERT INTO ldb_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Isi iwengge iyingo ungo udɔrhu ugoshe? Ungo uku ugoshe ikɛi, uhwɛka usi iwekpɔ ri ijeengo? Awu use utsu ungo ukaifɛrhkɔ iyiki ikorhu ubin hã? Ungo usi igbɛrangwĩ utsukukɔ unera, ungo ugbɛr utsuke Unum.>> ");
INSERT INTO ldb_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ivangyɛ Uhananiya aka agũ rimi, unga agba nu abĩ akpea. Nggaa iwei ifɛr anera kishoo aka agũ ubinkpi uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Mɔcɛ awɛdzɛm aba, akũ atorho abvur ukom iyornga, na akũna unga adzek adzake. ");
INSERT INTO ldb_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Aka ayoka akara ataar nu utsɛ̃nga atsĩwã, asi ihwɛngnga ubinkpi uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ubitru arhusa unga agɛ, <<Udɛyiwa umum, awu uhwɛk ha nukpi kishoo umbi aka agoshe icang hã?>> Unga agɛ, <<Ĩĩ, uhwɛk ngge niyɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ubitru agɔr unga agɛ, <<Awu use utsu umbi agbopa atsimbi na aviri Ipfu Uteijee? Unyã! Adak abika adzake utsakngo akɔ ra angwĩ ubã, umbɔ awuri itsã ungo adzek ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kanying unga agba nu adak Ubitru akpea. Mɔcɛ awɛdzɛm aka atsĩwã aba anyã unga aka akpea, umbɔ ashupa unga adzek azĩ adzak akhapuwe ru udzak utsaknga. ");
INSERT INTO ldb_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nggaa iwei akarhãrhã ifɛr kishoo abika adɔsa nu kishoo abika agũ ifɛrha ha. ");
INSERT INTO ldb_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Abi itser Uyesu akorhuwe abin idzeu nu abin igbigba ra anera arhɛrhɛ. Nu abi imangmang kishoo aki isaka akɔng ra Angwĩ Iya Usorhomon. ");
INSERT INTO ldb_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Bɔr uner uwɔɔ asi itsĩ atomunga ru umbɔ, kishoo rimi hã anera ana adzowe umbɔ imor. ");
INSERT INTO ldb_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Irhɛ akatsak nu akatsɛrh abika awe ru imangmang ru Uteijee ikpurhi idɛ̃ɛ̃ ititoma ri irhɛmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ubinkpi abi itser Uyesu aka akorhe utsu anera akũ abi irhãrhã adzeka ra atsĩndĩ, abɛta umbɔ nu atakarha nu afarmbɔ, ugɛ Ubitru aba atɔnga, usakanga uma utɔng nu abɔɔ. ");
INSERT INTO ldb_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Anera arhɛrhɛ aka adzeyi ri iteu iyiki ikhapa ru Urusharhima, akɔng akũ abi irhãrhã aba nu abirabɛ ípfu iyiki ibewe iki idzowe umbɔ uver, nu kishoo akerhumbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ukugɔng Uwuku Udzowe Idɛm-Num nu kishoo abirabɛ aka awu nggu unga, awu abi ukpui Usaduki, agũ unyɛ̃ɛ̃ abi itser Uyesu akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ngge itsu umbɔ asok adzur abi itser Uyesu atsuke umbɔ ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Bɔr ru untsuuka ipfu itser Uteijee itsuruwe angwĩ ubã ugborzĩ hã ikũna umbɔ idzekngge. Igɔr umbɔ igɛ, ");
INSERT INTO ldb_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","<<Àka azĩ adɛ̃ɛ̃ ru ufɔm Iya-Num na adɛyiwe anera undzuma arherhe akɛrɛ aki urhɛ uwuku ufa.>> ");
INSERT INTO ldb_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ukpekpeka, umbɔ atsĩ ru ufɔm Iya-Num, ru nyaka ngge iki idɛyiwe umbɔ, umbɔ atirhi imesuwe anera. Mɔcɛ Ukugɔng Uwuku Udzowe Idɛm-Num nu abirabɛ aka awu nggu unga aka aba atsĩ, umbɔ akɔng abi udzepurhe, aka awu akakũ Uisrairha kishoo, na adene itser ugɛ akũ abi itser Uyesu ha ru ugborzĩ hã aba. ");
INSERT INTO ldb_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Bɔr abi idzɛu Iya-Num azĩ atsĩ ru ugborzĩ hã, abeea umbɔ, umbɔ ashimbɔ umɔ, umbɔ azĩ asɔme umbɔ ");
INSERT INTO ldb_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","agɛ, <<Umɛn inyã ugborzĩ ugbang uku kpengkpeng, abi idzɛu ikɛi adɛ̃ɛ̃ adzɛu angwĩ ubã, bɔr umɛn iki itsuri, umɛn isi inyãmɛn unera ru ugborzĩ hã.>> ");
INSERT INTO ldb_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Anggbaashi abi idzɛu Iya-Num nu ateiya abika adzowe idɛm-Num aka agũ rimi, amɛnmbɔ aghong akarhãrhã, akaifɛrhkɔ ubinkpi uku ikorhe ri ifɛrhɛ iyɛrɛ ha. ");
INSERT INTO ldb_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mɔcɛ utsa uwɔɔ aba agɔr umbɔ agɛ, <<Àka anyã! Abi ha abɛ umbi aka atsuku ugborzĩ adɛ̃ɛ̃ ru ufɔm Iya-Num, anu imesuwe anera.>> ");
INSERT INTO ldb_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Mɔcɛ unggbaashi abi idzɛu Iya-Num nggu abi idzɛu ha azĩ akũ abi itser Uyesu aba, bɔr asi ikũmbɔ ri inggang. Anggbaashi ha anu igũ iwei anera utsur umbɔ atang umbɔ atarh. ");
INSERT INTO ldb_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Umbɔ aka akũ abi itser Uyesu aba, atsu umbɔ adɛ̃ɛ̃ ra asu abi itser udzepurhe, mɔcɛ Ukugɔng Uwuku Udzowe Idɛm-Num anu irhusa umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Agɛ, <<Umɛn ivangamɛn umbi akarhãrhã igɛ umbi niba abvui amesukumbi anera ri itsok ikɛrɛ ha. Bɔr nggayɛ umbi aka amaakumbi Urusharhima kishoo nggu imesambi ikɛi umbi abee itsuka umɛn uvau adzirh utsa ha!>> ");
INSERT INTO ldb_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bɔr Ubitru nu abi itser Uyesu abɔɔ agɛ, <<Awu ufang umɛn iki idɔsa arherhu Unum inangmɛn arherhe anera! ");
INSERT INTO ldb_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Unum uwu atokamɛn unga asoyiwe Uyesu ra akpe, uwuruwi umbi aka afɛre ri inyapuwe unga ni igãrhãmau ucucii. ");
INSERT INTO ldb_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Unum aka aberuwe unga, atsu unga asei ru ubok ughanga, awu unggbaashi na awu Uner Uwuku Ufɔrh ikɛi na atsuruwe Uisrairha utsĩndĩ idzidzipambɔ ikɛi akpo itsũwe arhim. ");
INSERT INTO ldb_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Umɛn iwu ideka ri ifɛrha iyɛrɛ ha, iwu rimi ikɛi Ipfu Isarsatangge, iyiriyɛ Unum aka adzowe abika adɔsa unga.>> ");
INSERT INTO ldb_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ivangyɛ umbɔ aka agũ rimi, umbɔ agũ avɔm akarhãrhã na abee ifɛre umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bɔr utsa Ufarisi uwɔɔ itsoka igburh Ugamarhiyerh, uwuku umesuwe Íkpem Umusa, uwuruwi anera kishoo aki asaka adzowe unga imor, asok adɛ̃ɛ̃ ru udzepurhea, atsu umbɔ akũ abi itser Uyesu adzeka awiya kata. ");
INSERT INTO ldb_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mɔcɛ unga agɔr abi udzepurhe ha agɛ, <<Umbi abimɛn Uisrairha àka angwɛ̃dzɛn na arhi anyã ubinkpi umbi aka abee ikorhuwe anera abɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ivanga niyɔ isha uner uwɔɔ aka adzeka, itsoka igburh Utuda, anyangi itsinga awu ubin ukpɔɔ. Anera ayombɔ anaka anaa aki idɔsa unga, bɔr afɛrkumbɔ unga, na asitukumbɔ abika adɔsa unga, ake awu imimashambɔ. ");
INSERT INTO ldb_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Akɛrɛ ha aka amaa ikɛi, uwɔɔ itsoka igburh Uyahuda utsa Ugarhirhi adzeka ri ivangyɛ umbɔ aka adɛ̃ɛ̃ ivarhe irhɛ anera atsu anera adɔsa unga umbɔ awe ru igamtsa nggu agomnati. Unga ikɛi afɛrkumbɔ unga, abika adɔsa unga kishoo asitumbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nggee, umum idzaa umbi itsũwã, àka adzembi ru utsĩndĩ anera abɛrɛ, àka neke umbɔ azĩmbɔ! Ubinkutsu ibibemambɔ use itsermbɔ iba iwu iyi anera, iwuri isitungge. ");
INSERT INTO ldb_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bɔr itsermbɔ ha iba idzeku Unum, umbi asi ídɛ̃ɛ̃ akɛnmbi umbɔ, utsur umbi awembi ri ifuw nggu Unum.>> Nggee umbɔ ayɛimbɔ itsũwã Ugamarhiyerh. ");
INSERT INTO ldb_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Umbɔ ayisa abi itser Uyesu ha, atsu umbɔ akwɛre umbɔ ugwɛɛ. Na avange atombɔ utsur umbɔ arherhumbɔ arherhe ri itsok Uyesu, na atsũwe umbɔ azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Abi itser Uyesu ha asok azĩmbɔ agɔm akarhãrhã agɛ Unum anyã umbɔ amɛ̃ɛ̃mbɔ ihwa uver nu atsa ri itsok Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ubɛn unuma, umbɔ asi inekukumbɔ imesuwe anera ri idzowe Isarhe Iyiki Ize ri Iya-Num nu aya ugɛ Uyesu unga awu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ri inum hã angwɛ̃ imesa anu ititoma arhɛrhɛ, umɔ abi Uyahuda abika agũ idũ abi Uherhini atsĩmbɔ ibvun arherhe ri itsi abi Uyahuda abika agũ idũ abi Ibrani ubinkutsu abika agau ubingha ubɛn unuma anu irhi atsɛ̃rhãpfu abi idũ Uherhini uku ungwaan. ");
INSERT INTO ldb_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nggee umbɔ usɔkdũmɛn hã ayisa anera kishoo angwɛ̃ imesa agɛ, <<Isi irhikungge umɛn ineke isarhe Arherhu-Num ni itsĩmɛn igashu ubingha. ");
INSERT INTO ldb_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Umbi angwɛ̃mɛn nu anapumɛn, àka asɛng inera utɔɔva ra abimbi abirabɛ umbɔ aka ahwɛng umbɔ awu nggu Ipfu-Num nu itsoi. Umɛn iki idzowe itser iyɛrɛ ru umbɔ, ");
INSERT INTO ldb_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","nu umɛn itsu amɛnmɛn ri ifɛn-Num ni imesuwe Arherhu-Num.>> ");
INSERT INTO ldb_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Abika adɔsa kishoo agũibɛn ubinkpi umbɔ aka arherhe. Mɔcɛ umbɔ asɛng Uistifanu, uwuruwi aka awe ru imangmang akarhãrhã na awu nggu Ipfu Isarsatangge, nu Ufirhibu nu Uburokora nu Unikano, nu Utimon, nu Ubarmina, nu Unikorha aka adzeku Uantakiya, adzipa atsĩ agbeyi abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Umbɔ akũ anera abɛrɛ aba aden ra asu abi itser Uyesu, umbɔ aka afɛn-Num na atsoyiwe umbɔ abok. ");
INSERT INTO ldb_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nggee Arherhu-Num atɛ̃rhã. Irhɛ angwɛ̃ imesa ru Urusharhima ikpurhi idɛ̃ɛ̃ itoma akarhãrhã, nu arhɛrhɛ abika adzowe idɛm-Num adɔsumbɔ imangmang hã. ");
INSERT INTO ldb_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Uistifanu, awu nggu imimuta nu ijee akarhãrhã, akorha abin akagɔng aki idzeu nu aki igbigba ra anera. ");
INSERT INTO ldb_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Bɔr abɔɔ abi ubã ifɛn-Num ukpɔɔ umbɔ iki iyisa agɛ Ubã Ifɛn-Num Abika Adzek Ukam, asoyimbɔ uning nggu Uistifanu. Abɛrɛ ha awu abi Uyahuda abika adzeku Usayirin nu Uarhekzandiriya, nu ikɛi abika adzeka abĩ Ukirhikiya, nu aki Uasiya. ");
INSERT INTO ldb_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Bɔr afɔr uning adambɔ nggu itsoi iyi Ipfu-Num iki idzowe unga arherhe. ");
INSERT INTO ldb_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Mɔcɛ umbɔ aghɔ̃rhã agɔr anera abɔɔ ri iwɔk umbɔ agɛ, <<Umɛn igũ Uistifanu anu irhenu Umusa na arhenu Unum ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nggee umbɔ asoyiwe amɛn anera nu akakũ nu abika amesuwe ikpem. Umbɔ asok adzur Uistifanu akũ azĩmbɔ ra asu abi udzepurhe. ");
INSERT INTO ldb_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Umbɔ akũ anera abi ideka igbɛrangwĩ aba, umbɔ agɔr agɛ, <<Utsak uwurɛ ubɛn unuma unga anu irherhi iyiki itãrhã ru usarkasar anang akɛrɛ nu Íkpem Umusa ikɛi. ");
INSERT INTO ldb_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Umɛn igũ unga agɔr agɛ Uyesu uner Unazarat ha awuri ibibupuwe anang akɛrɛ na afaruwe agbeyi Umusa aka abɔra umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Kishoo abika asei ru udzepurhe ha awing asumbɔ arhi Uistifanu, anyã asunga awu ru nyaka aki ipfu itser-Num. ");
INSERT INTO ldb_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mɔcɛ Ukugɔng Uwuku Udzowe Idɛm-Num arhusu Uistifanu agɛ, <<Arherha akɛrɛ ha awu idzidzɛrhe?>> ");
INSERT INTO ldb_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Uistifanu agɛ, <<Umbi angwɛ̃mɛn nu atesmɛn, àka akpeto ru umum! Unum uwuku ukpukpoi adzeka ru utokamɛn Uibrahim ri ivangyɛ unga aka awu ra abĩ Umesofotamiya, unga anasi iseisa ru Uharan. ");
INSERT INTO ldb_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Unum agɔr unga agɛ, <Uso ra abĩmbi, ubɔre abimbi, uzĩ abĩkɛ umum iki idɛyiwa ungo.> ");
INSERT INTO ldb_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","<<Nggee unga asoka abĩ abi Ukarhdi, azĩ aseisa ru Uharan. Utɛnga aka akpe amaa, Unum adene unga aba ra abĩkɛ umbi aka asei umɔ icɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Unum asi idzowuka Uibrahim ukam abĩ hã, uko ider udaka unying. Bɔr Unum abemuka unga agɛ unga awuri itsu abĩ hã awu akinga nggu unangnga iki idɔsu undzingnga, nggayɛ Uibrahim ana ashia ru ungwɛ̃ ri ivang hã. ");
INSERT INTO ldb_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Unum arherhe nggu unga agɛ, <Unangngo awuri iwemgbɔ atsen ra abĩ akase, abi abĩ hã awuri itsu umbɔ igãrhã, awuri idzowe umbɔ ayetnum imɛka inaka inaa. ");
INSERT INTO ldb_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Umum iwuri itsukukũ uver ra abĩ hã umbɔ aka iwu igãrhã. Akɛrɛ ha aka imaa ikɛi, unang Uibrahim awuri idze adzaa umum igɔng ra anang akɛrɛ.> ");
INSERT INTO ldb_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Unum adzowe Uibrahim ibibemuwe utsar ukpu usorhe. Uibrahim aka amar Uishaku, unga asorhuwe unga ru unum ukpu utɔrɔk. Uishaku unga amar Uyakubu, Uyakubu amar atokamɛn usɔkdũmɛn. ");
INSERT INTO ldb_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","<<Atokamɛn hã agũ unyɛ̃ɛ̃ ungwɛ̃mbɔ aka agburh Uyusuf, umbɔ agoshe unga azĩã igãrhã ru Umasar. Bɔr Unum awu nggu unga, ");
INSERT INTO ldb_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","atsũwũka unga ri inyãyernga kishoo. Unum ikɛi atsu Uyusuf awu uner itsoi awe ru izama ra asu Ufir'auna uyɛrhe Umasar, nggee unga atsu unga awu ugomna Umasar ru udzepurhenga kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","<<Mɔcɛ imerh itsĩngge abĩ Umasar kishoo nu Ukan'ana, itoma nggu ayetnum akarhãrhã, itsu atokamɛn ashimbɔ ru ubingha. ");
INSERT INTO ldb_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ivangyɛ Uyakubu aka agũ ugɛ ubingha uwekpɔ ru Umasar, unga adene atokamɛn azĩmbɔ Umasar uzɛ̃rhã ukpu inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ru uzɛ̃rhãmbɔ ukpu uvaa Uyusuf adɛyiwe itsikamnga ru angwɛ̃mbɔ, mɔcɛ Ufir'auna ikɛi ahwɛng abi iyambɔ Uyusuf. ");
INSERT INTO ldb_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Akɛrɛ aka amaa Uyusuf atsu umbɔ ayisuwe utɛnga Uyakubu asok aba ru unga, nu kishoo abi iyambɔ, awu isɔka utɔɔva na atɔ̃ɔ̃. ");
INSERT INTO ldb_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Mɔcɛ Uyakubu azĩã Umasar. Ru nggɔɔ ha unga nggu atokamɛn aka akpe, ");
INSERT INTO ldb_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","na akũ akom ayormbɔ azĩmbɔ Ushekem, adzake umbɔ ru udzak ukpu Uibrahim aka agoi nggu uhwɛk uazurhfa ru ubok awɛ Uhamor ru Ushekem. ");
INSERT INTO ldb_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","<<Bɔr ivangyɛ iki itsuifɛr iyi ibibemuwe-Num ru Uibrahim iki iyok, anermɛn atɛ̃rhã akarhãrhã ra abĩ Umasar. ");
INSERT INTO ldb_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mɔcɛ uyɛrhe uwɔɔ ru Umasar, uwuruwi aka asi ihwɛngnga Uyusuf agha iyɛrhe Umasar. ");
INSERT INTO ldb_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Unga agha urha unangmɛn na ayɔm atokamɛn na atsu umbɔ atãyĩwe irheng angwɛ̃mbɔ ngge ikpeyi. ");
INSERT INTO ldb_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","<<Ivang hã niyɔ umbɔ aka amar Umusa, unga awu uzeze ungwɛ̃. Anɛta unga afɛ̃ɛ̃ ataar ri iya utɛnga. ");
INSERT INTO ldb_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Umbɔ aka angwɛ̃we unga ra awiya, unapa Ufir'auna unga ashupa unga akpɔm ru nyaku ungwɛ̃nga. ");
INSERT INTO ldb_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Amesuwe Umusa ri kishoo itsoi abi Umasar na awe ru ijee ra arherhe nu ikikorhe. ");
INSERT INTO ldb_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","<<Ivangyɛ Umusa aka atsĩ imɛka isɔka inaa, unga avarhe na asok azĩã iyepa angwɛ̃mbɔ abi Uisrairha. ");
INSERT INTO ldb_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Unga aka anyã utsa Umasar aka adɛ̃ɛ̃ iyɔm ungwɛ̃mbɔ, unga azĩ ayɛsuwe ungwɛ̃mbɔ afɛruka utsa Umasar ha. ");
INSERT INTO ldb_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Umusa akaifɛrhkɔ agɛ abimbɔ awuri ihwɛngmbɔ ugɛ Unum awuri ikũ unga akũ afɔrh umbɔ, bɔr umbɔ asi ihwɛngmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Unum uvaa, Umusa aba anyã abi Uisrairha avaa aka adɛ̃ɛ̃ ifuw. Unga abee igbopa atsimbɔ akũwe umbɔ ididɔɔr, agɔr agɛ, <Umbi anerabɛ, umbi awu angwɛ̃yi. Awu use utsu umbi ayɔm adɔka?> ");
INSERT INTO ldb_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","<<Bɔr uwuku uyɔm undɔkanga hã ayiru Umusa adene ri ifɛna na agɛ, <Ungaa atsu ungo uwu uyɛrhamɛn, nu uwuku utsu uvau ru umɛn? ");
INSERT INTO ldb_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ungo ubee ifɛre umum ru nyaka ungo uku ufɛr utsa Umasar arhɛkɛ ha?> ");
INSERT INTO ldb_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ivangyɛ Umusa aka agũ rimi, unga atĩ azĩã Umidiyan, umɔ unga awea utsen ru nggɔɔ ha unga amar awɛkaci avaa akatsa. ");
INSERT INTO ldb_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","<<Imɛka isɔka inaa iki itɔng, ipfu itser-Num idzeka ra asu Umusa ra arhum ri ikon urha iki igar ru ufum uku ukhapa ri Igũ Usinai. ");
INSERT INTO ldb_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ivangyɛ Umusa aka anyã rimi, unga adzeidzeu umɔ. Unga aka agɔpa azĩ na agbisha arhi, unga agũ urhɛm Uteijee uku ugɔr ugɛ, ");
INSERT INTO ldb_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","<Awu umum Unum uwu atokango, Unum uwu Uibrahim, nu Uishaku nu Uyakubu.> Iyor Umusa izang unga afɔr irhi adaka. ");
INSERT INTO ldb_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","<<Mɔcɛ Uteijee agɔr unga agɛ, <Utsũwe abadakngo, anangkɛ ungo uku udɛ̃ɛ̃ umɔ awu asarkasar abĩ. ");
INSERT INTO ldb_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Idzidzɛrhe, umum inyãmum ayetnum anermum ru Umasar. Umum iki igũmum akpembɔ, umum icipuwa iba ishɔɔte umbɔ. Icɛrɛ uba umum idena ungo ubvui uzĩ Umasar.> ");
INSERT INTO ldb_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","<<Awu Umusa ha nuwi umbɔ aka akpɛ̃ na agɛ, <Ungaa atsuka ungo uwu uyɛrhamɛn nu uwu uwuku utsu uvau ru umɛn?> Unga hã Unum aka adene unga awu unggbaashi na awu uwuku ufɔrh, ru ubok ipfu itser-Num hã iki idzeka ru unga ru ufum hã. ");
INSERT INTO ldb_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Unga akũna umbɔ adzeku Umasar na akorha abin idzeu nu abin igbigba ru Umasar, ru Ukau uku Ubãrhã nu ikɛi ra arhum imɛka isɔka inaa. ");
INSERT INTO ldb_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","<<Umusa ha unga agɔr abi Uisrairha agɛ, <Unum awuri idzaanga umbi uner uwuku usɔm Arherhu-Num ra anermbi ru nyaka umum.> ");
INSERT INTO ldb_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Unga awu nggu ikikɔng atokamɛn abi Uisrairha ra arhum, nggu ipfu itser-Num hã iki irherha arherhe nggu unga ni Igũ Usinai, nu nggu atokamɛn, na ayɛi arherhe urhɛ aka adzeku Unum akũ akũwã umɛn. ");
INSERT INTO ldb_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","<<Bɔr atokamɛn akpɛ̃mbɔ idɔsa arherhanga hã. Akpɛ̃mbɔ unga, na agũ ikpona ibvui izĩ abĩ Umasar ra amɛnmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Agɔr Uharuna agɛ, <Ugbishuwa umɛn anum abirabɛ aka idarh umɛn. Umusa ha aka akũna umɛn adzeka ra abĩ Umasar, umɛn isi ihwɛngmɛn ubinkpi uku ukpo unga!> ");
INSERT INTO ldb_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ivang hã niyɔ umbɔ aka agbishu ugberhe usaku ungwɛ̃ inak. Adzowe idɛm ru umgbɔ anu izek irhowa agɔm anggɔm nu ubinkpi umbɔ aka akũ abokmbɔ agbisha. ");
INSERT INTO ldb_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bɔr Unum adzipu undzingnga nggu umbɔ. Na aneke umbɔ atsĩ idzowe igɔng ru ídzɛr afã ngge iwu anummbɔ. Akɛrɛ ha awu uku kpengkpeng nggu ubinkpi umbɔ aka atsɛng ru abvur abika asɔm Arherhu-Num agɛ, << <Umbi angwãmbi ijuɛ na adzaambi umum idɛm ri imɛka isɔka inaa ra arhum, umbi abi iya Uisrairha? ");
INSERT INTO ldb_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Umbi azɛ̃rhã nggu ishia Umorhek nu idzɛɛr ugberhe Urifan, agberhe aki ha umbi aka agbisha adzowe ake igɔng. Ngge iki iwu rimi, umum iwiwayiwe umbi ra abĩmbi,> ifaru Ubabirha itɔng. ");
INSERT INTO ldb_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","<<Atokamɛn awe ru utsurha uwuruwi uku utsu umbɔ ahwɛng ideka Unum ru umbɔ ra arhum. Awu umgbɔ, uwu utsurhawi Unum aka atsu Umusa agbisha, ikɛi umbɔ agbisha umgbɔ uku kpengkpeng ubinkpi Unum aka adɛyiwe Umusa. ");
INSERT INTO ldb_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Utsurha ha ruwɔ atokamɛn aka akũ umgbɔ aba ra abĩ akɛrɛ umbɔ aka ayɛi ri ivang Ujoshuwa, Unum aka awayiwe atsen ra asumbɔ. Umgbɔ uwu umɔ uba utsĩ ivang Udauda, ");
INSERT INTO ldb_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","unga aka awe ru imimuta Unum, na afɛna agɛ unga amaa adzine anang ru Unum uwu utokamɛn Uyakubu. ");
INSERT INTO ldb_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bɔr awu Usorhomon unga adzine iya ha. ");
INSERT INTO ldb_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","<<Rimi hã Nggaa Uwuku Ugɔng asi iseisa ri iyakɛ aki anera iki idzin. Ubin ukpu uner uwuku usɔm Arherhu-Num aka agɔr agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","<< <Afã awu anang isei iyɛrhamum, nu upfung uwu anangkɛ umum iki iden andaidakmum. Ikpũ iya iyikisong umbi aka idzina umum? Uteijee agɔr. Use anang akasong awu anang akika uwoshamum? ");
INSERT INTO ldb_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Asi iwea abokmum adzin abin akɛrɛ ha kishoo?> ");
INSERT INTO ldb_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","<<Umbi agbau abi igbĩrhĩ anera, nggu amɛn akika asheru usorhe nu ato! Umbi awe ru nyaka atokambi, ubɛn ivang umbi asi idɔsumbi Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ra abika asɔm Arherhu-Num, uwukusong atokambi asi idzowukumbɔ unga uver? Afɛrkumbɔ abirabɛ aka arherhe arherhe ri itsi uwuku ububa Uwuku Arhurhika ha. Nu umbi igambi aghambi adaknga, umbi afɛre unga. ");
INSERT INTO ldb_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Umbi ayɛimbi Íkpem iyiki itsu itser ru ubok ípfu itser-Num bɔr umbi asi idɔsumbi.>> ");
INSERT INTO ldb_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ivangyɛ umbɔ aka agũ rimi, amɛnmbɔ adak akarhãrhã, afar anyĩmbɔ agũ avɔm nggu unga. ");
INSERT INTO ldb_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Bɔr Uistifanu awu nggu Ipfu Isarsatangge, awing asunga arhi afã anyã ikpikpoi Unum, nu Uyesu aka adɛ̃ɛ̃ nu ubok ugha Unum. ");
INSERT INTO ldb_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Uistifanu agɛ, <<Àka anyã, umum inyã afã atsuri nu Ungwɛ̃-Ner adɛ̃ɛ̃ nu ubok ugha Unum.>> ");
INSERT INTO ldb_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Bɔr umbɔ akũ abok abvure atombɔ, atsarhi irhakmbɔ atsuyi ivum awirhi azĩ ru unga, ");
INSERT INTO ldb_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","akũna unga adzek azĩ undzing utepa, adɛ̃ɛ̃ atang unga atarh nu unga. Abika adzowe ideka igbɛrangwĩ hã angwɛ̃we atorhambɔ nggu uwɛdzɛm uwɔɔ agburh Ushawurhu. ");
INSERT INTO ldb_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Umbɔ aka adɛ̃ɛ̃ itang atarh nu unga, umɔ Uistifanu afɛn-Num agɛ, <<A Uteijee Uyesu, uyɛi ipfumum.>> ");
INSERT INTO ldb_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Mɔcɛ unga atararhu, na atsarhi irhaknga agɛ, <<A Uteijee niba ukpɔmmɔ arhim akɛrɛ nu atsimbɔ.>> Unga aka arherhe rimi amaa, na akpea. ");
INSERT INTO ldb_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ushawurhu awu umɔ abemuka ifɛr Uistifanu. Ru unum hã nggaa uver utsĩkpɔ ra abika adɔsa ru Urusharhima, asituwe umbɔ kishoo ra abĩ abi Uyahudiya nu aki Usamariya, akpurha abɔre abi itser Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mɔcɛ aner Unum adzake Uistifanu, aciu akpenga akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Bɔr Ushawurhu akpurha adɛ̃ɛ̃ idzowe uver ra abika adɔsa akarhãrhã. Atsĩrhã aya aya, adzui akatsak nu akatsɛrh atsuyiwe umbɔ ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Abɔrɔ ha umbɔ aka asituwe adzowe Isarhe Iyiki Ize ri inangyɛ umbɔ aka azĩ. ");
INSERT INTO ldb_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ufirhibu azĩã uteu Usamariya, adzowe isarhe Ukiristo umɔ. ");
INSERT INTO ldb_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Anera aka agũ, na anyã abin idzeukɛ unga aka akorhe umbɔ angwɛ̃ amɛnmbɔ ru ubinkpi unga iki irherhe. ");
INSERT INTO ldb_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ípfu iyiki ibewe itsuyi ivum ni idzeyingge ru ayor anera arhɛrhɛ, akerhuwe abi ishayi iyor na akatarhu arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Nggee umbɔ agɔm anggɔm akarhãrhã ru uteu ha. ");
INSERT INTO ldb_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Unera nuwɔ itsoka igburh Usiman anu itser igoka adzowe idzeu ra anera kishoo ru uteu Usamariya. Anu iberi itsinga agɛ unga awu nggaa uner. ");
INSERT INTO ldb_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nu anera kishoo, uwuku ugɔng nu uwuku uci, atsu amɛnmbɔ nu unga anu igɔr agɛ, <<Utsak uwurɛ awe ru ijee iyi Unum umbɔ iki iyisa nggaa Ijee.>> ");
INSERT INTO ldb_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Umbɔ adɔsa unga ubinkutsu aka adera unga aka anu ikorhuwe umbɔ abin idzeu nggu igbigba igokanga. ");
INSERT INTO ldb_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bɔr umbɔ aka awe ru imangmang ri Isarhe Iyiki Ize iyiriyɛ Ufirhibu aka arherhe iyi Iyɛrhe Unum nu iyi itsok Uyesu Ukiristo, asorhuwe umbɔ ubɔtisima, akatsak nu akatsɛrh. ");
INSERT INTO ldb_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Usiman nibikanga awea ri imangmang, umbɔ aka asorhuwe unga ubɔtisima ikɛi unga adɔsunga Ufirhibu ubɛn anang. Unga aka anyã Ufirhibu akorha atsar nu abin idzeu, unga adzeidzeu akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Abi itser Uyesu aka awe ru Urusharhima aka agũ abi Usamariya aka ayɛimbɔ Arherhu-Num, umbɔ adene umbɔ Ubitru nggu Uyohana azĩ ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Umbɔ aka azĩ atsĩ, umbɔ afɛne-Num ru umbɔ ama ayɛi Ipfu Isarsatangge, ");
INSERT INTO ldb_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ubinkutsu, Ipfu Isarsatangge ina isi icipuwangge nu unyinga umbɔ kata, akpurha akorhuwe umbɔ ubɔtisima ri itsok Uteijee Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Mɔcɛ Ubitru nu Uyohana atsorhuwe abok nu umbɔ, umbɔ ayɛi Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Usiman aka anyã ugɛ awu itsorha abok abi itser Uyesu iki isaki itsu ikpo Ipfu-Num, unga adzowe umbɔ uhwɛk. ");
INSERT INTO ldb_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Na agɛ, <<Udzaa umum ijee ha igamum, umum ĩba itsorhumum ubok nu ubɛn unera unga akpo Ipfu Isarsatangge.>> ");
INSERT INTO ldb_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ubitru agɔr unga agɛ, <<Uhwɛkngo nggu ungo aka atsim, ungo ukaifɛrhkɔ ugɛ ungo ukũ uhwɛk uyɛi izũwũ Unum! ");
INSERT INTO ldb_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ungo ushiɔ ru ugau ri itser iyɛrɛ, ubinkutsu, amɛnngo asi irhikuke ra asu Unum. ");
INSERT INTO ldb_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Udzipa ru iyiki ibewa iyɛrɛ nu ufɛn-Num ru Uteijee. Use unga awuri itsũwãnga ungo ri ikpũ ifɛrhkɔ iyɛrɛ ra amɛnngo. ");
INSERT INTO ldb_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ubinkutsu umum inyã amɛnngo awu nggu unyɛ̃ɛ̃ akarhãrhã aka abow ra arhim.>> ");
INSERT INTO ldb_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Mɔcɛ Usiman agɛ, <<Àka afɛnuwa umum Uteijee, utsur abin hã umbi aka arherhe akorhuke nggu umum.>> ");
INSERT INTO ldb_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ivangyɛ umbɔ Ubitru nggu Uyohana aka amaa idzowe isarhe Arherhu Uteijee, umbɔ abvui azĩmbɔ Urusharhima, adzowe Isarhe Iyiki Ize ri iteu Usamariya irhɛirhɛ. ");
INSERT INTO ldb_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Icɛ ipfu itser Uteijee igɔr Ufirhibu igɛ, <<Uso uzĩ unɔr utsĩndĩ arhum uwuku udzeku Urusharhima uzĩ Ugaza.>> ");
INSERT INTO ldb_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Nggee unga asok adzek azĩã, unga agbopu uner Uitiyofiya uwuruwi aka awu unggbaashi, abika angwɛ̃ kishoo abin Ukadi uyɛrhe Uitiyofiya, aka awu ukutsɛrh. Aka azĩ Urusharhima idzowe igɔng. ");
INSERT INTO ldb_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Unga awu ru utsĩndĩ uwuku uzĩ usoi, asei ru ikar inyãwãnga anu ivarhu ubvur uwuku usɔm Arherhu-Num Uishaya. ");
INSERT INTO ldb_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ipfu-Num igɔr Ufirhibu igɛ, <<Uzĩ ukhapa nu ikar inyãwã iyɔrɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ufirhibu atĩ azĩ nu ikar inyãwã hã agũ utsa ha adɛ̃ɛ̃ ivarhe ubvur uwuku usɔm Arherhu-Num Uishaya. Ufirhibu arhusa unga agɛ, <<Ungo ugũ utaingo ubinkpi ungo uku uvarhe?>> ");
INSERT INTO ldb_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Unga agɛ, <<Umum ikorhi iguse, unera aba asi igbisha adɛyiwanga umum?>> Na ayisu Ufirhibu afũ ikar inyãwã hã umbɔ asei. ");
INSERT INTO ldb_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Uner Uitiyofiya ha adɛ̃ɛ̃ ivarhe ubvur Arherhu-Num aka agɔr ugɛ, <<Adarh unga ru nyaki idɔi azĩmbɔ ingwĩngwã, ru nyaku ungwɛ̃ itsurhi iki unukutata ru ubok uwuku ukone igwar iyorngge, unga asi iyangunga angwĩnga. ");
INSERT INTO ldb_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Akwɛɛte unga na akɛnmbɔ unga idzidzɛrhanga. Ungaa idɛ̃ɛ̃ arherhe arherhe ri itsi unangnga? Ubinkutsu anyangu urhɛnga adzembɔ ru upfung.>> ");
INSERT INTO ldb_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Uner Uitiyofiya ha arhusu Ufirhibu, agɛ, <<Udɛyiwa umum, kabɔɔ, uner uwuku usɔm Arherhu-Num hã arherhe arherhe ha ri itsi ungaa, ri itsinga use ri itsi uner uwukuse?>> ");
INSERT INTO ldb_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mɔcɛ Ufirhibu atirhi nu ugbɛr itsɛng Arherhu-Num uwu ha adzowe unga Isarhe Iyiki Ize iyi Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Umbɔ awe ru uzɛ̃rhã nú utsĩndĩ hã, azĩ anyã amɛ̃, Uner Uitiyofiya ha agɛ, <<Unyã amɛ̃ akɛ! Awu use ikɛn umum isi ísorhmum ubɔtisima?>> ");
INSERT INTO ldb_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Unga atsu umbɔ ajimu ikar inyãwã hã ngge idɛ̃ɛ̃. Umbɔ Ufirhibu nggu utsa ha ikivarhambɔ acipa atsĩmbɔ ra amɛ̃. Mɔcɛ Ufirhibu asorhuwe ubɔtisima ru utsa ha. ");
INSERT INTO ldb_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ivangyɛ umbɔ aka adzeka ra amɛ̃, Ipfu Uteijee ishupungge Ufirhibu, Uner Uitiyofiya ha asi ibvui anyã unga ikɛi, bɔr azĩã uzɛ̃rhãnga na agɔm anggɔm. ");
INSERT INTO ldb_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ufirhibu, anyã itsinga, ru Uazotu. Umɔ unga atsĩrhã ri kishoo iteu, adzise Isarhe Iyiki Ize azĩ atsĩã Ukaisariya. ");
INSERT INTO ldb_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ri ivang hã Ushawurhu anu igha unggbaashi nggu iziya angwɛ̃ imesu Uteijee. Unga asok azĩã ru Ukugɔng Uwuku Udzowe Idɛm-Num, ");
INSERT INTO ldb_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ashɔ̃rhã unga amaa atsɛng abvur adzowe anggbaashi abã ifɛn-Num ru Udimashku, ubinkutsu unga aba azĩ akpoa abika adɔsu Utsĩndĩ Uteijee, akatsak use akatsɛrh, unga abow umbɔ akũ aba Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Unga aka azɛ̃rhã azĩ akhapa nggu Udimashku, kanying irhirhang idzeka afã irhang idzipa unga. ");
INSERT INTO ldb_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Unga agba anu nu abĩ na agũ urhɛm ukpɔɔ uku ugɔr unga ugɛ, <<A Ushawurhu, a Ushawurhu, awu use utsu ungo udzaa umum uver?>> ");
INSERT INTO ldb_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ushawurhu arhusa agɛ, <<Awu ungo ungaa Uteijee?>> Urhɛm hã ugɔr ugɛ, <<Awu umum Uyesu uwuruwi ungo uku udɛ̃ɛ̃ idzowe uver. ");
INSERT INTO ldb_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Icɛrɛ usisok utsĩ ru utepa, nggɔɔ ha umbɔ awuri idɛyiwambɔ ubinkpi awu ufang ungo iki ikorhe.>> ");
INSERT INTO ldb_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Abika azɛ̃rhã nggu Ushawurhu afɔr arherhe adambɔ, umbɔ agũmbɔ urhɛm hã na asi inyãmbɔ unera. ");
INSERT INTO ldb_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ushawurhu asoka abĩ na ayanga asunga bɔr asi idɛ̃ɛ̃ anyã ubin. Nggee umbɔ akpɔm aboknga adarh unga atsĩ ru Udimashku. ");
INSERT INTO ldb_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Unga amaa inuma itaar, asunga awu ibvuta, asi ighaa na asi ihwaa ubin ikɛi. ");
INSERT INTO ldb_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ungwɛ̃ imesa Uyesu nuwɔ ru Udimashku itsoka igburh Uhananiya. Uteijee ayisa unga ru irhi agɛ, <<A Uhananiya!>> Unga anyũwã agɛ, <<Umumwi, Uteijee.>> ");
INSERT INTO ldb_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Uteijee ha agɔr unga agɛ, <<Usisok utsĩ ri iya Uyahuda nu utsĩndĩ uwɔ umbɔ iki iyisa agɛ uku Urhirhiki urhusa ugɛ use uner Utarsu itsoka iki igburh Ushawurhu awu umɔ, unggawɔ adɛ̃ɛ̃ ifɛn-Num mɔnɔ. ");
INSERT INTO ldb_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ru irhi unga aka anyã unerwi aka agburh Uhananiya aka aba atsorhu ubok nu unga, unga abvui anyãã ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Uhananiya agɛ, <<A Uteijee, umum iki nggũshumum arherhe utsak uwirɛ ra anera arhɛrhɛ, nu amɛn aka abewe unga aki ikorhuwe abika adɔsa ungo akarhãrhã ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nggayɛ ikɛi ateiya abika adzowe idɛm-Num aka adzowukumbɔ unga ijee iyiki idzui kishoo abirabɛ aka afɛn ungo.>> ");
INSERT INTO ldb_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Bɔr Uteijee agɔr Uhananiya agɛ, <<Uzĩ! Awu utsa ha uwi umum iki isɛng unga aka itɔ̃ itser iyiki idzowe isarhe itsokmum ra atsen abi Uyahuda nu ayɛrhambɔ nu aner Uisrairha. ");
INSERT INTO ldb_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Umum iwuri idɛyikũ unga ikpũ ayetnumkɛ awu ufang unga aka ihwa ri itsokmum.>> ");
INSERT INTO ldb_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nggee Uhananiya asok azĩã azĩ atsĩ ri iya. Atsorha aboknga nu Ushawurhu, na agɛ, <<A ungwɛ̃mɛn Ushawurhu, Uteijee Uyesu uwuruwi aka adzeka ru ungo nu utsĩndĩ ibibango nggimi unga adena umum ĩba ru ungo ubvui unyã anang ikɛi nu uwe nggu Ipfu Isarsatangge.>> ");
INSERT INTO ldb_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kanying, abina ru nyaka afeka abɛrh ahwor ra asu Ushawurhu agba, mɔcɛ unga abvui anyã anang. Unga asok, umbɔ asorhuwe unga ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Unga aka agha ubingha amaa, unga akpo iker iyornga. Ushawurhu amaa inum iyɔɔ asei nggu angwɛ̃ imesa ru Udimashku. ");
INSERT INTO ldb_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kanying Ushawurhu atirhunga idzowe isarhe Uyesu ra abã ifɛn-Num abi Uyahuda agɛ Uyesu awu Ungwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kishoo abika agũ unga adzeidzeu na arhusa agɛ, <<Asi iwea unga afɛyiwe abika afɛn uner ha, Uyesu, ru Urusharhima? Unga asi ibanga idzui anera nggimi akũ azĩ ra ateiya abika adzowe idɛm-Num?>> ");
INSERT INTO ldb_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Bɔr isarhe Ushawurhu ikpurhi idɛ̃ɛ̃ ititoma ri iker nu ijee, itsu abi Uyahuda abika asei ru Udimashku adzeidzeu na adzuna, unga aka adɛyiwe idzidzɛrhe ugɛ Uyesu awu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Inuma irhɛirhɛ iki imaa, abi Uyahuda akɛki itsũwã iyiriyɛ umbɔ aka ifɛre Ushawurhu. ");
INSERT INTO ldb_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Bɔr Ushawurhu aka agũ ubinkpi umbɔ aka arherhe. Nu utsuu na atenum, atsu asumbɔ adzɛu ingwĩ utepa abee ifɛre unga. ");
INSERT INTO ldb_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Bɔr angwɛ̃ imesanga ashupa unga ru uzĩng ru untsuuka acipuwe unga ra angwĩ ubandzin ufɔm utepa. ");
INSERT INTO ldb_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ivangyɛ unga aka abvui aba atsĩ Urusharhima, unga abee igbopi itsi nggu awɛ imesu Uyesu, bɔr kishoo agũ iwei unga, umbɔ asi idzowukumbɔ imangmang ugɛ unga awu ungwɛ̃ imesa idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Bɔr Ubarnaba akũna unga akũ azĩã ra abi itser Uyesu. Adɛyiwe umbɔ Ushawurhu aka anyã Uteijee nu utsĩndĩ nu Arherhu Uteijee nggu Ushawurhu, nu Isarhe Iyiki Ize Ushawurhu adũwã ri itsok Uyesu ru Udimashku asi igũa iwei. ");
INSERT INTO ldb_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nggee Ushawurhu asei nggu umbɔ na azɛ̃rhã nggu umbɔ ru Urusharhima, adzowe isarhe ri itsok Uteijee asi igũa iwei. ");
INSERT INTO ldb_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ikɛi unga anu irherha arherhe na awe ru uning nggu abi Uyahuda abika agũ idũ abi Uherhini, bɔr umbɔ abee utsĩndĩ uwuku ufɛre unga. ");
INSERT INTO ldb_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Abika adɔsa aka ahwɛng rimi, umbɔ akũna unga azĩmbɔ Ukaisariya adene unga azĩã Utarsu. ");
INSERT INTO ldb_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Mɔcɛ abika adɔsa ru Uyahudiya, nu Ugarhirhi, nu Usamariya, akpombɔ ididɔɔr. Umbɔ akpo iker nu ififita akarhãrhã ri Ipfu Isarsatangge, atɛ̃rhã awu arhɛrhɛ nggu iwei Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ubitru aka azɛ̃rhã amaa abĩã kishoo, unga azĩã ra abika adɔsa ha ru Urhidda. ");
INSERT INTO ldb_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Umɔ unga aka agbopa nggu uner uwɔɔ agburh Uiniya, uwuruwi aka aghong irhãrhĩ iyiki ishayi iyor anu imɛka utɔrɔk. ");
INSERT INTO ldb_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ubitru agɔr unga agɛ, <<A Uiniya, Uyesu Ukiristo aka akerhuwanga ungo. Uso ufetu ufarngo.>> Kanying Uiniya asoka. ");
INSERT INTO ldb_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kishoo aner Urhidda nu abi abĩ Usharon anyã unga aka akerhunga, umbɔ adzipa awu abi Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ru Ujopa ungwɛ̃ imesu Uyesu nuwɔ, itsoka igburh Utabita, agbena agburh <<Udooka,>> uwuku udzowe itsinga ri itɔ̃ itser iyiki ize, na ayike atsũwã. ");
INSERT INTO ldb_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ri ivang hã unga aghong akpea, umbɔ aka asorhuwe iyornga na angwɛ̃we unga ru ubã afã. ");
INSERT INTO ldb_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Urhidda ukhapa nggu Ujopa angwɛ̃ imesa aka agũ agɛ Ubitru awe ru Urhidda, umbɔ adene inera ivaa izĩ ru unga ashɔ̃rhã unga agɛ, <<Kabɔɔ uba ru umɛn ifetem!>> ");
INSERT INTO ldb_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ubitru asok azĩã nggu umbɔ, unga aka azĩ atsĩ umbɔ akũna unga afũmbɔ ru ubã afã hã. Kishoo atsɛ̃rhãpfu adɛ̃ɛ̃ adziira unga, aciu akpe adɛyiwe atorho ha Udooka aka adzise umbɔ unga aka awu nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ubitru atsu umbɔ kishoo adzek ra awiya, unga atar arhuk na afɛn-Num. Adzipa udiku ukom utsɛrh ha, agɛ, <<A Utabita, usisok.>> Unga ayanga asunga, unga aka anyã Ubitru unga asok asei isei. ");
INSERT INTO ldb_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ubitru adzowe uboknga ayike unga asok adɛ̃ɛ̃ nu adaknga. Mɔcɛ unga ayisa abika adɔsa na atsɛ̃rhãpfu ha adzowuka Utabita ru umbɔ nggu urhɛ. ");
INSERT INTO ldb_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Isarhe iyɛrɛ itɛ̃rhã kishoo ru Ujopa, anera arhɛrhɛ aka adzowe imangmang ru Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ubitru asei inuma irhɛirhɛ ru Ujopa ri iya uwɔɔ uner itser abvur ijuɛ itsoka igburh Usiman. ");
INSERT INTO ldb_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Unera nuwɔ ru Ukaisariya itsoka igburh Ukonerhiyu, unga awu uteiya abi iwa ru ukpui Uitarhiya ra abi iwa Uroma. ");
INSERT INTO ldb_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Unga nu abi iyanga kishoo awu abika adzowe igɔng na agũ iwei Unum, atsu itsinga akarhãrhã ri idzowe izũwã irhɛirhɛ ra atsũwã, na afɛn-Num ubɛn ivang. ");
INSERT INTO ldb_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Unuma nukpɔ aka ayoka akara ataar ra atenuma, unga anyã ipfu itser-Num ru irhi, iki igɔr unga igɛ, <<A Ukonerhiyu!>> ");
INSERT INTO ldb_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Unga atsu asunga ri iwei na arhusa agɛ, <<A Uteijee, awu use?>> Ipfu itser-Num igɔr unga igɛ, <<Unum aka agũã ifɛn-Numngo nu iyiyikeyɛ ungo uku iyike atsũwã. Unga ayɛi ngge ru nyaku izũwã. ");
INSERT INTO ldb_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Udene anera icɛrɛ umbɔ azĩ Ujopa ayisuwa Usiman uwu ha umbɔ iki iyisa unga Ubitru. ");
INSERT INTO ldb_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Unggawɔ asei nggu Usiman uwuku utɔ̃itser abvur ijuɛ, uwuruwi iyanga iki iwe ru ubang ukau ukugɔng.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ivangyɛ ipfu itser-Num iyiki irherha arherhe nggu unga iki izĩngge, Ukonerhiyu ayisa agãrhãnga avaa, nu uner iwa uwuku udɔsu Unum ra abika atɔ̃ itsernga. ");
INSERT INTO ldb_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Unga aka amaa idɛyiwe umbɔ abina kishoo aka akorhe na adene umbɔ azĩmbɔ Ujopa. ");
INSERT INTO ldb_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ra atenuma unum uvaa agãrhũ Ukonerhiyu awe ru uzɛ̃rhã umbɔ aka ayo ru utepa, Ubitru afũ ni itsi uvi abee ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Imerh ifɛr unga, unga abee igha ubin, bɔr umbɔ aka adɛ̃ɛ̃ ikorhu ubingha, unga anyã irhi. ");
INSERT INTO ldb_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Unga anyã afã aka atsuri, unga anyã ubina ru nyaka atorho ukoma atɛtɛi uku ucipuwa nu abĩ nggu angbokake anaa aka ayurhi. ");
INSERT INTO ldb_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ru ake ubɛn ikpũ ijuɛ iyi adaka anaa iwu umɔ, nu iyiki ikaikai, íbvui nu ígwer nu anunu afafã. ");
INSERT INTO ldb_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Mɔcɛ unga agũ urhɛm uku ugɔr unga ugɛ, <<A Ubitru, uso, ungwãnu utãi.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bɔr Ubitru agɛ, <<ĩ'ĩ Uteijee! Umum inasi ighamum ubin arhim use ukpurukpi uku usi isarkpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Unga abvui agũ urhɛm hã idevaa, uku ugɔr ugɛ, <<Ubinkpi Unum aka asare ukpɔ, niba ugɔrɔ ukpɔ ugɛ usi isarkpɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ifɛrhɛ iyɛrɛ ha ikorhe idiki itaar, nu kanying umbɔ unyangu atorha ha afũmbɔ ra afã. ");
INSERT INTO ldb_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Amɛn Ubitru ana awe ri icang agben irhi ha umbɔ aka adɛyiwe unga, aner ha Ukonerhiyu aka adene arhusa na adɛ̃ɛ̃ ra angwĩ iya. ");
INSERT INTO ldb_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Umbɔ ayisa arhusa agɛ, <<Usiman uwuruwi umbɔ iki iyisa Ubitru asei umɔ?>> ");
INSERT INTO ldb_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ubitru ana awe ri ifɛrhkɔ irhi ha, Ipfu-Num igɔr unga igɛ, <<Usiman, inera itaar iyɛ idɛ̃ɛ̃ ibeea ungo. ");
INSERT INTO ldb_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Nggee uso ucipa uzĩ ru umbɔ. Niba ucango izĩ nggu umbɔ, ubinkutsu awu umum idene umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ubitru acipa azĩ ru aner ha, agɔr umbɔ agɛ, <<Awu umum umbi aka abee. Awu use utsu umbi aba?>> ");
INSERT INTO ldb_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Aner ha agɛ, <<Umɛn idzeku Ukonerhiyu uteiya abi iwa. Arhiku uner na agũ iwei Unum, awuri imor ra asu abi Uyahuda kishoo. Usarkasar ipfu itser-Num itsu unga adena itser ugɛ ungo uba ri iyanga, unga awuri igigũa ubinkpi ungo iki irherhe.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mɔcɛ Ubitru akũna umbɔ atsĩ, ayɛi umbɔ awu atsen ri iyanga. Unum untaar Ubitru azĩã nggu umbɔ, nu abika adɔsa abɔɔ aka adzeku Ujopa azĩ urhɔnga. ");
INSERT INTO ldb_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Unum unaa umbɔ atsĩmbɔ Ukaisariya. Ukonerhiyu aka afosi ibibambɔ ayisa abimbɔ kishoo nu awɛrhanga abi idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ubitru awuri itsĩ ri iya nukpi, Ukonerhiyu agbanga unga atararhu ra asunga, adzowe unga igɔng. ");
INSERT INTO ldb_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Bɔr Ubitru atsu unga asisok agɛ, <<Usisok! Umum iwu unera ukpekũ ru nyaka ungo.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ubitru aka adɛ̃ɛ̃ arherhe nggu unga, atsĩ akpo anera arhɛrhɛ aka akɔng. ");
INSERT INTO ldb_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Unga agɔr umbɔ agɛ, <<Umbi ahwɛngmbi ugɛ isi imɛ̃ngge uner Uyahudiya agbopi itsi use unga azĩ iyepa atsen abi Uyahuda. Bɔr Unum aka adɛyiwanga umum agɛ umum niba iyisumum unera igɛ asi isara, use asi itɛna. ");
INSERT INTO ldb_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nggee ivangyɛ umbɔ aka adene ugɛ umum ĩba, umum isi ikpɛ̃mum. Icɛrɛ umum ibee irhusa awu use utsu umbi ayisa umum.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ukonerhiyu agɛ, <<Inuma inaa iki itɔng ru nyaki ivang iyɛrɛ nu akara ataar aki urhɛɛ. Umum iwuri ifɛn-Num ri iyamum, kanying umum inyã unera aka adɛ̃ɛ̃ ra asumum atsim atorho aka aterha ake arhang. ");
INSERT INTO ldb_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Uner ha agɛ, <A Ukonerhiyu, Unum aka agũã ifɛn-Numngo na ayitunga ungo iki iyike atsũwã. ");
INSERT INTO ldb_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Udene itser ru Ujopa umbɔ ayisuwa Usiman, uwuruwi umbɔ iki iyisa Ubitru. Unga awu utsen ri iya Usiman, uwuku utɔ̃itser abvur ijuɛ uwuruwi iyanga iki iwe ru ubang ukau azɛ̃ akagɔng.> ");
INSERT INTO ldb_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ngge itsu kanying umum idene umbɔ ayisa ungo, aze ungo uku uba. Icɛrɛ Umɛn abɛ ikɔng kishoo ra asu Unum, umɛn iwuri ikpeto ru ubɛn ubinkpi Uteijee aka atsuka ungo udɛyiwa umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mɔcɛ Ubitru atirhi irherhuwe umbɔ arherhe agɛ, <<Idzidzɛrhe umum ihwɛng Unum asi itɛnga asu. ");
INSERT INTO ldb_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Bɔr ayɛi anera ra abĩã kishoo abika agũ iwei unga na akorhu ubinkpi uku urhika. ");
INSERT INTO ldb_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Umbi ahwɛngmbi itseryɛ Unum aka adene ra aner Uisrairha, agɛ Isarhe Iyiki Ize iyi ididɔɔr iba ru ubok Uyesu Ukiristo, unga aka awu Uteijee kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Umbi ahwɛngmbi ubinkpi uku ukorhe umaa abĩ Uyahudiya kishoo, utirhi ru Ugarhirhi ri ivangyɛ Uyohana aka idzowe isarhe iyi ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Umbi ahwɛngmbi ubinkpi uku ukorhe Unum aka adzukuwe atsei na atsuke Ipfu Isarsatangge nu ijee ru Uyesu uwu Unazarat, unga aka azɛ̃rhã akorhi iyiki ize akerhuwe kishoo abirabɛ aka awe ru ijee Undenggũ, ubinkutsu Unum awu nggu unga. ");
INSERT INTO ldb_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","<<Umɛn iwu ideka ru ubɛn ubinkpi unga aka akorhe ra abĩ abi Uyahuda, nu Urusharhima. Umbɔ afɛre unga ri inyinyapuwe unga ni igãrhãmau ucucii. ");
INSERT INTO ldb_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Bɔr Unum asoyika unga ra akpe ru unum ukpu untaar na atsu unga adzeka umbɔ anyã unga. ");
INSERT INTO ldb_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Asi iwea anera kishoo anyã unga, akpurha adzeka ra abirabɛ Unum aka asɛng umɛn iwu ideka, umɛn iki igha ni ihwa nggu unga aka asoka akpe. ");
INSERT INTO ldb_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Unga atsu umɛn idzowe isarhe ra anera ni idɛyiwe anera ugɛ, awu unga hã nuwi Unum aka asɛng unga awuri itsu uvau abi urhɛ na abika akpe. ");
INSERT INTO ldb_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Abika asɔm Arherhu-Num kishoo adzowukumbɔ ideka ri itsinga agɛ, ubɛn unera aka adzowuka imangmang ru unga awuri ikpoa itsũwe arhim ri itsoknga.>> ");
INSERT INTO ldb_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ubitru awu ra arherhe nukpi, Ipfu Isarsatangge icipuwangge nu abirabɛ aka anu igosha arherhanga kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Abi usorhe abi Uyahuda abika adɔsa, abirabɛ aka aba nggu Ubitru, adzeidzeu umbɔ aka anyã atsen abi Uyahuda ayɛimbɔ izũwã Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ubinkutsu umbɔ agũ umbɔ anu irherhi idũ iyikise na adzowe igɔng ru Unum. Mɔcɛ Ubitru agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","<<Unera awea unga aka ikɛn isorhuwe ubɔtisima nggu amɛ̃ ra anera abɛrɛ umbɔ aka ayɛi Ipfu Isarsatangge ru nyaka umɛn iki ikpo?>> ");
INSERT INTO ldb_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nggee unga atsu umbɔ asorhuwe umbɔ ubɔtisima ri itsok Uyesu Ukiristo. Mɔcɛ umbɔ ashɔ̃rhã unga ama asei nggu umbɔ inuma ukunjiir. ");
INSERT INTO ldb_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Abi itser Uyesu na abika adɔsa ra abĩ abi Uyahudiya kishoo agũ ugɛ atsen abi Uyahuda ikɛi ayɛimbɔ Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nggee Ubitru aka azĩ ufã Urusharhima, abi usorhe abi Uyahuda abi imangmang azɔka unga arherhe. ");
INSERT INTO ldb_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Na agɛ, <<Awu use utsu ungo uzĩ ru abika ashimbɔ ru usorhe ugha ubingha nggu umbɔ?>> ");
INSERT INTO ldb_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Mɔcɛ Ubitru atirha asɔme umbɔ uku kpengkpeng ubinkpi uku ukorhe. ");
INSERT INTO ldb_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Unga agɛ, <<Umum iwu ru uteu Ujopa idɛ̃ɛ̃ ifɛn-Num, ni inyã irhi. Umum inyã ubina uku ucipuwa ru nyaka atorho ukoma uwuku ugɔng aka adzeka afã nggu angbokake anaa ayurhi, aba ra anangkɛ umum iki iwe. ");
INSERT INTO ldb_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Umum iki ingbiki irhi umum inyã ijuɛ iyi adaka anaa nu ijuɛ arhum iyiki ibewe, nu iyiki ikaikai, nu anunu. ");
INSERT INTO ldb_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Mɔcɛ umum igũ urhɛm ukpɔɔ uku ugɔr umum ugɛ, <A Ubitru, usisok ungwãnu utãi.> ");
INSERT INTO ldb_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","<<Bɔr umum ĩgɔr ĩgɛ, <Ĩ'ĩ a Uteijee! Ubinkpi uku usi isarkpɔ use utɛnkpɔ unasi itsĩkpɔ ra angwĩmum.> ");
INSERT INTO ldb_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","<<Mɔcɛ urhɛm hã udzeka afã urherhe idevaa, ugɛ, <Ubinkpi Unum aka asare niba ugɔrɔ ugɛ usi isarkpɔ.> ");
INSERT INTO ldb_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Akɛrɛ ha akorhe idiki itaar, na ashupa abin hã afũmbɔ ra afã ikɛi. ");
INSERT INTO ldb_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","<<Ri ivang hã inera itaar umbɔ aka adene umbɔ adzeku Ukaisariya aba ru umum, adɛ̃ɛ̃ nu angwĩ iyakɛ umum iki iwe. ");
INSERT INTO ldb_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ipfu-Num igɔr umum igɛ umum ĩdɔsa umbɔ niba icicang umum izĩ nggu umbɔ. Angwɛ̃mɛn utɔ̃ĩ hã aka azĩ nggu umum, umɛn izĩ itsĩ ri iya utsak uwurɛ. ");
INSERT INTO ldb_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Unga adɛyiwa umɛn unga aka anyã ipfu itser-Num iki idɛ̃ɛ̃ ri iyanga, ni igɔr igɛ, <Udene umbɔ azĩ ayisuwa Usiman ru Ujopa uwuruwi umbɔ iki iyisa Ubitru. ");
INSERT INTO ldb_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Unga awuri iba asɔma ungo isarheyɛ ungo nu iyango kishoo aki ikpo ififɔrh.> ");
INSERT INTO ldb_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","<<Umum iki itirhi arherhe, Ipfu Isarsatangge icipuwa nu atsimbɔ ru nyaka ngge iki icipuwa nu atsimɛn ri inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mɔcɛ umum iyita Arherhu Uteijee aka agɔr agɛ, <Uyohana akorhu ubɔtisima nggu amɛ̃, bɔr awuri isorhuwa umbi ubɔtisima nggu Ipfu Isarsatangge.> ");
INSERT INTO ldb_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nggee Unum aba adzowe umbɔ izũwã uku kpengkpeng ubinkpi unga aka adzaa umɛn, iki iwe ru imangmang ru Uteijee Uyesu Ukiristo, umum igburh ungamɔ umum iki ikɛn Unum?>> ");
INSERT INTO ldb_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Umbɔ aka agũ rimi, umbɔ asi ikpombɔ ubinkpi umbɔ aka irherhe, umbɔ akpoi Unum agɛ, <<Ugũ uko atsen abi Uyahuda Unum akorhuka umbɔ utsĩndĩ idzidzipa nu ikpo urhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Uver uku utsu abika adɔsa asita ri ifɛre Uistifanu abɔɔ azĩ abĩ Ufinikiya, nu aki Usayifuru, nu uteu Uantakiya, adzowe isarhe Arherhu-Num ra abi Uyahuda ukpekũ. ");
INSERT INTO ldb_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Aner Usayifuru nu Usayirin abika adɔsa azĩ Uantakiya adɛyiwe abi Uherhini, ikɛi arherha ha, adzowe umbɔ Isarhe Iyiki Ize iyi Uteijee Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ubok Uteijee uwu nggu umbɔ, anera arhɛrhɛ ikɛi awe ru imangmang na adzipa awe abi Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Isarhe ubinkpi uku ikorhe ru Uantakiya izĩ itsĩngge ra ato abika adɔsa aka awe ru Urusharhima, umbɔ adene Ubarnaba azĩã ru Uantakiya. ");
INSERT INTO ldb_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Unga aka azĩ atsĩ anyã imimutayɛ Unum aka ikorhuwe umbɔ, unga agɔm anggɔm na adɛyiwe umbɔ kishoo adɛ̃ɛ̃ aker nggu amɛnmbɔ ru Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ubarnaba awu uner uwuku uze, awu nggu Ipfu Isarsatangge nu imangmang, nu anera arhɛrhɛ aka aba atoma awu abi Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mɔcɛ Ubarnaba azĩ ibee Ushawurhu ru Utarsu. ");
INSERT INTO ldb_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ivangyɛ unga aka anyã unga, unga akũna unga abanga Uantakiya. Amaa amɛka unying umbɔ Ubarnaba nggu Ushawurhu aki ikɔng nggu abika adɔsa amesuwe anera arhɛrhɛ. Awu ru Uantakiya umbɔ aka atirhi iyisa angwɛ̃ imesu Uyesu nggu itsok <<Abi Ukiristo.>> ");
INSERT INTO ldb_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ri ivang hã abika asɔm Arherhu-Num abɔɔ aka adzeku Urusharhima aba Uantakiya. ");
INSERT INTO ldb_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Unera unying ru umbɔ, itsoka igburh Uagabu. Asok abera adɛ̃ɛ̃ na arherha arherhe ru ubok ijee Ipfu-Num. Agɛ ikpũ imerh niyɔ igɔigɔng iwuri itɛ̃rhã ru upfunga kishoo. Ikpũ imerh ha itsuifɛr ri ivangyɛ Ukarhaudiyu aka awu uyɛrhe. ");
INSERT INTO ldb_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Angwɛ̃ imesa ha, akɛki itsũwã nggu adɔkambɔ agɛ, umbɔ akɔng abin adene ake azĩ ayike abika adɔsa ru Uyahudiya, ubɛn unera ri ikernga. ");
INSERT INTO ldb_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Umbɔ akorhe rimi hã, adene izũwãmbɔ izĩ ra akakũmbɔ ru ubokmbɔ Ubarnaba nu Ushawurhu. ");
INSERT INTO ldb_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ivang ha niyɔ Uyɛrhe Uhiridu aka adzui abika adɔsa abɔɔ, abee idzowe umbɔ uver. ");
INSERT INTO ldb_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Unga atsu umbɔ afɛre Uyaku ungwɛ̃mbɔ Uyohana nggu ikon iyiki ider. ");
INSERT INTO ldb_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Unga aka anyã agɛ abi Uyahuda agũibɛn ubinkpi unga aka akorhe, unga adzur Ubitru ikɛi. Akɛrɛ akorhe ri ivang Irhowa Uborodi ukpuku Usheru Uguga. ");
INSERT INTO ldb_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Umbɔ aka adzur unga amaa, unga atsuke unga ru ugborzĩ, nu ubok abi iwa usɔka nu utɔ̃ĩ umbɔ adzɛu unga inera inaa inaa. Uhiridu akaifɛrhkɔ ikũna unga azĩ ra asu anera umbɔ atsu uvaunga, Irhowa Iyiki Igar Utɔng ha iba imaangge. ");
INSERT INTO ldb_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Nggee Ubitru aka awe ru ugborzĩ, abika adɔsa atsu amɛnmbɔ ifɛne-Num ru unga. ");
INSERT INTO ldb_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ru untsua ha Uhiridu aka akaifɛrhkɔ agɛ ukpe uba usarkpɔ unga awuri ikũ Ubitru akũ aba avarhuwe arherhanga. Unga anu ra ateu abi iwa avaa, abope nggu inyãwã ivaa, nu abika adzɛu ugborzĩ, ikɛi abɔɔ adɛ̃ɛ̃ ra angwĩ ubã adzɛu. ");
INSERT INTO ldb_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kanying ipfu itser Uteijee akapɛng, irhirhang irhange ugbora. Ipfu itser-Num ikwɛr Ubitru ri igbɔmnga izita unga. Igɔr igɛ, <<Usisok, ifetem!>> Inyãwã hã igarhungge ra abok Ubitru. ");
INSERT INTO ldb_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mɔcɛ ipfu itser-Num igɔr unga igɛ, <<Utsim atorhango, nu utsu abadakngo.>> Ubitru akorhe rimi hã. Ipfu itser-Num igɔr unga igɛ, <<Utama atorhango udɔsa umum.>> ");
INSERT INTO ldb_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ubitru adɔsa unga adzek ru ugborzĩ, asi ihwɛngnga ugɛ ubinkpi ipfu itser-Num hã iki ini ikorhe uwu idzidzɛrhe, unga akaifɛrhkɔ ugɛ unga anyã irhi. ");
INSERT INTO ldb_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Umbɔ aka atɔng abi idzɛu abi inggbaashia nu abi uvaa aba ra angwĩ ufɔm utepa aka awu nggu angwĩ ubã azɔu. Angwĩ ubã atsuri nibikake, nu umbɔ adzek ra ake. Umbɔ aka azɛ̃rhã nú ider utsĩndĩã unying, kanying ipfu itser-Num hã igwirngge ri inyĩnyã Ubitru. ");
INSERT INTO ldb_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mɔcɛ Ubitru aka atsĩ ra amɛnnga, na agɛ, <<Icɛrɛ umum iki ihwɛng idzidzɛrhe ugɛ, Uteijee unga adene ipfu itsernga ngge ifɔrh umum ru ubok Uhiridu, ikɛi nu kishoo iyiki ibeweyɛ anggbaashi abi Uyahuda aka abee ikorhuwa umum.>> ");
INSERT INTO ldb_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ivangyɛ Ubitru aka ahwɛng akɛrɛ ha, unga azĩã ri iya Umaryamu uyisa Uyohana umbɔ iki iyisa Umarku, ra anangkɛ anera aka akɔng arhɛrhɛ anu ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ubitru aka akwɛr angwĩ ufɔm ha, una igãrhã agburh Uroda asok aba irhi awu ungaa nuwi. ");
INSERT INTO ldb_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Unga aka ahwɛng urhɛm Ubitru, anggɔm anyaike unga asi itsurunga ananga unga abvui atĩ atsĩ ri iya adɛyiwe umbɔ agɛ, <<Ubitru uwɔ adɛ̃ɛ̃ ra angwĩ udzepurhe rɔ!>> ");
INSERT INTO ldb_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Umbɔ agɔr unga agɛ, <<Ungo uku uzhɔma!>> Unga ana agɔr ugɛ awu Ubitru. Umbɔ agɛ, <<Awu ufang awu ipfu itsernga.>> ");
INSERT INTO ldb_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bɔr Ubitru akpurha adɛ̃ɛ̃ ikwɛr angwĩ iya, umbɔ aka atsuri angwĩ ubã hã na anyã unga, umbɔ adzeidzeu. ");
INSERT INTO ldb_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ubitru akorhuwe umbɔ utsara nggu uboknga umbɔ anu utata, na adɛyiwe umbɔ ikikorhe Uteijee aka akũna unga adzek ru ugborzĩ. Unga agɛ, <<Àka adɛyiwe Uyaku nu abika adɔsa abɔɔ abin hã.>> Unga agɔr rimi mɔcɛ unga adzek azĩã anang akɔɔ. ");
INSERT INTO ldb_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ru unkpeka, idzidzuna isi iwengge ukunjiir ra abi iwa ri ifɛrhɛ ha iki ikorhe nggu Ubitru. ");
INSERT INTO ldb_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Uhiridu aka abeea unga asi ikpoa, unga arhusa abi idzɛu ha ubinkpi uku ukorhe nggu Ubitru, na atsu umbɔ afɛre umbɔ. Mɔcɛ Uhiridu adzeka abĩ Uyahudiya azĩã Ukaisariya aseisa umɔ kata. ");
INSERT INTO ldb_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Uhiridu awe ri ifuw nggu aner Utaya nu abi Usidon, umbɔ asok aba akɔng ananga unying abee irherha arherhe nggu unga. Na akpo ibibema ru Ubirhatu, unggbaashi abi itser ri iya uyɛrhe, umbɔ azĩmbɔ ru uyɛrhe Uhiridu abee isei uku utɔɔ, ubinkutsu umbɔ atsu amɛnmbɔ nú abĩ iyɛrha ha na akpo ubingha. ");
INSERT INTO ldb_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Unumkpi umbɔ aka ungwɛ̃ Uhiridu atsim atorhi iyɛrhanga, asei nu utarh iyɛrhe arherhe arherhe nggu anera. ");
INSERT INTO ldb_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ikikɔnga iki igũ urhɛmnga, umbɔ atsarhi irhakmbɔ agɛ, <<Heee! Urhɛm unum nukpi usi iwekpɔ urhɛm unera.>> ");
INSERT INTO ldb_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kanying, ipfu itser Uteijee ikwɛr unga ubinkutsu unga asi idzowuka igɔng ru Unum, adzudzi agha unga, utsɛku unga aka akpe. ");
INSERT INTO ldb_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Bɔr Arherhu-Num akpurha adɛ̃ɛ̃ ititoma na atɛ̃rhã. ");
INSERT INTO ldb_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ivangyɛ umbɔ Ubarnaba nu Ushawurhu aka amaa itsermbɔ, umbɔ abvui aba ru Urusharhima, umbɔ akũ nggu Uyohana uwuruwi umbɔ iki iyisa Umarku. ");
INSERT INTO ldb_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ra abika adɔsa ru Uantakiya umɔ abika asɔm Arherhu-Num abɔɔ nu abika amesuwe awu umɔ, Ubarnaba nu Usimiyon uwuruwi umbɔ iki iyisa Uwuku Ufĩrhã, nu Urhushiyu aka adzeku Usayirin nu Umanayen uwuruwi aka awu uwɛrhɛ uyɛrhe Uhiridu udzur ri ingwɛ̃nci, nu ikɛi Ushawurhu. ");
INSERT INTO ldb_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Umbɔ aka anu idzowe igɔng Uteijee na akpem igha ubin, Ipfu Isarsatangge ha igɔr umbɔ igɛ, <<Àka asɛnga umum Ubarnaba, nu Ushawurhu, umbɔ awu abi itseryɛ umum iki iyisa umbɔ aka itɔ̃.>> ");
INSERT INTO ldb_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Umbɔ aka akpem igha ubin na afɛn-Num amaa, umbɔ atsorhuwe abok nu umbɔ na adene umbɔ azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ipfu Isarsatangge idene Uburhu nu Ubarnaba, umbɔ azĩmbɔ Usarhukiya, umɔ umbɔ atsĩ ukhukhɔɔ amɛ̃ azĩmbɔ Usayifuru. ");
INSERT INTO ldb_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ivangyɛ umbɔ aka azĩ atsĩ Usarhami, umbɔ adzowe isarhe Arherhu-Num ra abã ifɛn-Num aki abi Uyahuda. Uyohana, umbɔ iki iyisa Umarku, awu nggu umbɔ anu iyike umbɔ ri itser. ");
INSERT INTO ldb_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Umbɔ aka azɛ̃rhã amaa umpfũwã hã kishoo aba atsĩ Upafo, umɔ umbɔ aka agbopu utsa Uyahudiya uwɔɔ uner igoka uwuku usɔm Arherhu-Num igbɛrangwĩ itsoka igburh Ubar-Joshuwa, ");
INSERT INTO ldb_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","uwuruwi aka awu nggu ugomna Usarjiyu Uburhu, unga awu uner itsoi. Ugomna ayisu Ubarnaba nu Ushawurhu abee igũ Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Bɔr uner igoka ha Uarhima, itsoknga rikɔ ri idũ abi Uherhini, awe ri igamtsa nggu Ushawurhu nu Ubarnaba, abee ikɛn ugomna utsur unga adzowuka imangmang. ");
INSERT INTO ldb_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mɔcɛ Ushawurhu, uwu umbɔ iki iyisa Uburhu, awu nggu Ipfu Isarsatangge, atsu asunga arhi Uarhima, ");
INSERT INTO ldb_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","na agɛ, <<Ungo uwu ungwɛ̃ Undenggũ unggamtsak kishoo abin akika aze. Ungo uwu nggu ikpũ igbɛrangwĩ iyiki ibewe ukpekũ. Ungo udɛ̃ɛ̃ idzipu atsĩndĩ idzidzɛrhe uwu Uteijee umgbɔ uwu igbɛrangwĩ! ");
INSERT INTO ldb_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Icɛrɛ ubok Uteijee uwe ri igamtsa nggu ungo. Ungo uwuri iwu uner itapa, ungo usi ínyãɔ irhirhang ishaa unum ri ivanga.>> Kanying ibur nu uzĩ utsirkpɔ unga, unga anu ibibãrhã, abee uwuruwi aka ikpɔm ubok adarh unga. ");
INSERT INTO ldb_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ivangyɛ ugomna aka anyã abinkɛ aka akorhe, unga adzowuka imangmang, ubinkutsu unga adzeidzeu akarhãrhã ri imesa ri itsi Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Uburhu nu awɛrhu uzɛ̃rhãnga atsĩ ukhukhɔɔ amɛ̃ asoku Upafo azĩmbɔ Uperga ru abĩ Upamfirhiya, anangkɛ Uyohana Umarku aka abɔre umbɔ na abvui azĩã Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Asoku Uperga azĩmbɔ Uantakiya ru abĩ Upisidiya. Ru unum ukpuku uwoshambɔ atsĩ ru ubã ifɛn-Num asei. ");
INSERT INTO ldb_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Umbɔ aka amaa ivarhe ubvur Íkpem Umusa nu abvur abika asɔm Arherhu-Num, anggbaashi ubã ifɛn-Num hã adene itser ru umbɔ agɛ, <<Umbi angwɛ̃mɛn, umbi aba awembi ri irhɛm iyiki ififitayɛ umbi aka idzowe anera, umbi ama arherhe.>> ");
INSERT INTO ldb_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Uburhu aka abera adɛ̃ɛ̃, aberu uboknga na atirha arherhe agɛ, <<Umbi abimɛn abi Uisrairha, nu atsen abi Uyahuda nu abi iwei Unum, àka akpeto ru umum! ");
INSERT INTO ldb_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Unum uwu aner Uisrairha unga asɛng atokamɛn, aberuwe umbɔ ri ivangyɛ umbɔ aka awu ra abĩ Umasar, unga akũna umbɔ adzek umɔ nggu ijee iyiki igɔng. ");
INSERT INTO ldb_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Abima nggu umbɔ imɛka isɔka inaa ra arhum. ");
INSERT INTO ldb_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Unga aka amaa ivur abĩã utɔɔva ru Ukan'ana na adzowe ukam abĩmbɔ ra aner Uisrairha. ");
INSERT INTO ldb_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Akɛrɛ ha ayoke imɛka anaka anaa ni isɔka itɔ̃ɔ̃ (450). <<Akɛrɛ ha aka amaa, Unum aberuwe abɔɔ ru umbɔ awe abika atsu uvau utsɛku ivang uner uwuku usɔm Arherhu-Num Usamairha. ");
INSERT INTO ldb_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mɔcɛ aner Uisrairha abee umbɔ atsime umbɔ uyɛrhe, Unum atsũwe Ushawurhu ungwɛ̃ Ukish, uner unang Ubanjami, uwuruwi aka awu uyɛrhe imɛka isɔka inaa. ");
INSERT INTO ldb_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Umbɔ aka atsũwe Ushawurhu, Unum atsime Udauda awu uyɛrhambɔ. Arherhu-Num ri itsi Udauda agɔr agɛ, <Umum ikpo Udauda ungwɛ̃ Ujesse, awu uner ikɔkmum, unga awuri ikorha abina kishoo aki amɛnmum.> ");
INSERT INTO ldb_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","<<Awe ru unang utsak uwurɛ Unum aka akowe abi Uisrairha uwuku ufufɔrh, Uyesu, ru nyaka unga aka abemuwe. ");
INSERT INTO ldb_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ivangyɛ Uyesu aka aba Uyohana aka adzowuka abi Uisrairha kishoo isarhe idzidzipa nu isorhu ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ivangyɛ itser Uyohana iki iyo imimaa, unga agɛ, <Umbi akaifɛrhkɔ ugɛ umum iwu ungamɔ? Umum isi iwemum unga hã. Ĩ'ĩ. Bɔr uwɔɔ ruwɔ aka iba ru undzingmum, uwuruwi arhi abadaknga umum isi ímɛ̃mum igarhuwe ake.> ");
INSERT INTO ldb_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","<<Umbi abimɛn, anang Uibrahim, nu atsen abi Uyahuda nu abi iwei Unum ru umbi, awu ru umɛn umbɔ aka adene arherhe ififɔrh akɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Aner Urusharhima nu ayɛrhambɔ, umbɔ asi ihwɛngmbɔ ugɛ unga awu Uner Uwuku Ufɔrh ha. Umbɔ ikɛi asi ihwɛngmbɔ arherhe abika asɔm Arherhu-Num umbɔ iki ivarhe ubɛn unum ukpuku uwosha. Bɔr umbɔ atsu arherhe abika asɔm Arherhu-Num atsuafɛr, ri itsu uvau akpe ru Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Umbɔ aka asi ikpombɔ uvau uwuku ufɛr unga, rimi hã umbɔ ngipu Ubirhatu umbɔ afɛre unga. ");
INSERT INTO ldb_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ikikorhambɔ iki itsuifɛr kishoo ubinkpi umbɔ aka atsɛng ri itsinga, umbɔ acipuwe unga nu igãrhãmau ucucii, adzake unga ru ughwee utarh. ");
INSERT INTO ldb_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Bɔr Unum asoyika unga ra akpe ha. ");
INSERT INTO ldb_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Inuma irhɛirhɛ unga aka adzeyiwa ra abirabɛ aka adzeku Ugarhirhi adɔsa unga azĩ Urusharhima. Abirabɛ icɛrɛ umbɔ awu idekanga ra anera. ");
INSERT INTO ldb_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","<<Umɛn idɛyiwa umbi Isarhe Iyiki Ize. Ubinkpi Unum aka abemuwe atokamɛn, ");
INSERT INTO ldb_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","unga aka atsu ake atsuafɛr ru umɛn, angwɛ̃mbɔ, ri isoyiwe Uyesu ra akpe. Ru nyaka ngge iki itsɛng ru ubom ukpu uvaa ru Ubvur Abom igɛ, << <Ungo uwu ungwɛ̃mum, irherɛ umum iki iwu Utɛngo.> ");
INSERT INTO ldb_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Idzidzɛrhe Unum aka asoyiwe unga ra akpe ha utsur unga avɔ̃ɔ̃, arherhe ri írhɛm iyɛrɛ agɛ, << <Umum iwuri idzaamum umbi usarkasar ídorh iyi idzidzɛrhe umum iki ibemuwe Udauda.> ");
INSERT INTO ldb_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nggee unga agɔr ru ubom ukpɔɔ agɛ, << <Ungo usi íneke Usarkasarngo avɔ̃ɔ̃.> ");
INSERT INTO ldb_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","<<Udauda aka amaa itseryɛ Unum aka adzowe unga ri ivangnga. Mɔcɛ unga akpea, umbɔ adzake unga nggu atokanga, iyornga ivɔ̃ngge. ");
INSERT INTO ldb_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Bɔr uwuruwi Unum aka asoyiwe unga ra akpe asi ivɔ̃ɔ̃. ");
INSERT INTO ldb_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","<<Umbi abimɛn, àka akpeto! Umɛn iwu nggimi ni idũwũwa umbi ugɛ atsũwe arhimmbi iwu ru ubok Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ru uboknga kishoo uwuruwi aka awe ru imangmang, umbɔ aka atsũwũkumbɔ arhimnga, akirakɛ Íkpem Umusa iki isi idɛ̃ɛ̃ itsũwũkũngge. ");
INSERT INTO ldb_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Àka angwɛ̃dzɛn utsur abin hã abvur abika asɔm Arherhu-Num aka arherhe akorhuke ru umbi. Agɔr agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","<< <Àka anyã, umbi abika ayɛi itser Unum! Àka adzeidzeu na akpe, umum iwuri ikorhu ubin ukpɔɔ ri inummbi, ukpurukpi umbi asi ídzowukumbi imangmang, ru unerwi aka idɛyiwa umbi.> >> ");
INSERT INTO ldb_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Uburhu nu Ubarnaba aka azɛ̃rhã awuri idzidzek ru ubã ifɛn-Num hã, anera ashɔ̃rhã umbɔ ama aba arherhe arherhe ra abin hã ikɛi unum ukpuku uwosha iki iba. ");
INSERT INTO ldb_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ivangyɛ umbɔ aka asoyiwe anera, abi Uyahuda arhɛrhɛ nu atsen abi Uyahuda aka adzipa atsĩ agbeyi abi Uyahuda adɔsu Uburhu nu Ubarnaba, nu umbɔ ikivarhambɔ adzowe umbɔ itsũwã umbɔ adɛ̃ɛ̃ aker ri imimutu Unum. ");
INSERT INTO ldb_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Unum ukpuku uwosha ukpɔɔ uku ukɔru uba irhɛɛ anera ru utepa idzek ikɔng inũ igosha Arherhu Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ivangyɛ abi Uyahuda aka anyã ikikɔng anera irhɛirhɛ, umbɔ agũ unyɛ̃ɛ̃ akarhãrhã, umbɔ adzuse igbɛrangwĩ nu ubinkpi Uburhu aka arherhe umbɔ atsĩmbɔ irhena unga. ");
INSERT INTO ldb_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mɔcɛ Uburhu nu Ubarnaba asi igũmbɔ iwei, agɔr agɛ, <<Umbi abi Uyahuda imɛ̃ɛ̃ngge umɛn itirhi isarhe Arherhu-Num nggu umbi. Bɔr umbi aka akpɛ̃mbi na anyanga atsimbi asi imɛ̃mbi ikpo urhɛ uwu ugbagbaa, umɛn izĩ ra atsen abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ubinkutsu ubin hã nukpɔ Uteijee aka atsuka umɛn agɛ, << <Umum iki isɛng ungo uwu irhirhang ra atsen abi Uyahuda, ugɛ umbi awuri ikũ ififɔrh azĩ atsĩ ri imimashu upfung.>>> ");
INSERT INTO ldb_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ivangyɛ atsen abi Uyahuda aka agũ rimi, umbɔ agɔm anggɔm na akpoi Arherhu Uteijee, abirabɛ umbɔ aka asɛng umbɔ aka ikpo urhɛ uwu ugbagbaa adzowe imangmang. ");
INSERT INTO ldb_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Arherhu Uteijee atɛ̃rhã amaake abĩã kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Bɔr abi Uyahuda azɔka akatsɛrh abɔɔ abi iwei Unum abirabɛ umbɔ iki isaka adzowe umbɔ igɔng na abika agɔng abɔɔ ru utepa. Asoyikumbɔ uver ru umbɔ Uburhu nu Ubarnaba, awayiwe umbɔ ru abĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Nggee umbɔ awashuwe uzurhu adakmbɔ umgbɔ uwu utsar ikpikpɛ̃ɛ̃ ra atsi abi utepa, na azĩmbɔ Uikoniya. ");
INSERT INTO ldb_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nu angwɛ̃ imesa agɔm akarhãrhã, awu nggu Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ubina unying uku ukorhe ru Uikoniya. Uburhu nu Ubarnaba aka atsĩ ru ubã ifɛn-Num abi Uyahuda. Adzowe isarhe nggu ijee ru nggaa ikikɔng anera abi Uyahuda nu Atsen abi Uyahuda awe ru imangmang. ");
INSERT INTO ldb_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Bɔr abi Uyahuda abirabɛ aka akpɛ̃ iwe ru imangmang asoyiwe amɛn atsen abi Uyahuda adakuwe amɛnmbɔ nggu umbɔ Uburhu nu Ubarnaba. ");
INSERT INTO ldb_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Bɔr abi itser Uyesu asei adãrhã umɔ, adzowe isarhe ri ikeramɛn imimuta ru Uteijee. Nu unga abemunga isarhambɔ ri idzowe umbɔ ijee umbɔ akorha abin idzeu nu abin igbigba. ");
INSERT INTO ldb_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Abi uteu ha agau agbɛra avaa, abɔɔ adɔsu undzing abi Uyahuda, abɔɔ adɔsu undzing abi itser Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mɔcɛ atsen abi Uyahuda nu abi Uyahuda atoma nggu anggbaashimbɔ abee idzowe abi itser Uyesu uver na atange umbɔ atarh. ");
INSERT INTO ldb_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ivangyɛ abi itser Uyesu aka agũ rimi, umbɔ atĩ azĩmbɔ iteu Urhistira nu Udarbe ru Urhikoniya nu ikãwãngge. ");
INSERT INTO ldb_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Umɔ umbɔ adɛ̃ɛ̃mbɔ idzowe Isarhe Iyiki Ize. ");
INSERT INTO ldb_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ru Urhistira unera nuwɔ awu ukatarhu, amar unga ukatarhu anasi izɛ̃rhũnga uzɛ̃rhã. ");
INSERT INTO ldb_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Unga agũshu isarhe Uburhu. Uburhu atsu asu nu unga, anyã imangmangnga imɛ̃ngge umbɔ akerhuwe unga, ");
INSERT INTO ldb_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","na atsarhi irhaknga agɛ, <<Usisok udɛ̃ɛ̃ nu adakngo!>> Ukatarhu ha ater isha atirhunga uzɛ̃rhã. ");
INSERT INTO ldb_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ivangyɛ ikikɔnga iki inyã ubinkpi Uburhu aka akorhe, umbɔ atsarhi irhakmbɔ ivanga unying arherhe ri idũ Urhikoniya agɛ, <<Anum acipuwambɔ ru umɛn ru asaka anera!>> ");
INSERT INTO ldb_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Umbɔ atar itsok Ubarnaba agɛ Uzeyu, Uburhu umbɔ atare unga agburh Uherme, ubinkutsu unga awu uyɛrhe arherha ha. ");
INSERT INTO ldb_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Uwuku udzowe idɛm-Zeyu, uwuruwi ugbor ishiyanga uku uwu ra awiya ukhapa ru utepa, akũ ínak iyiki itsak nu ífur akũ aba ra angwĩ utepa ubinkutsu unga nu anera arhɛrhɛ abee idzowe idɛm ru abi itser Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Bɔr abi itser Uyesu Ubarnaba nu Uburhu aka agũ rimi, amɛnmbɔ aghong umbɔ avapuwe atorhambɔ na atĩ atsĩ ri ikikɔnga, atsarhi irhakmbɔ atsu ivum agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","<<Umbi anera, awu use utsu umbi akorhe rimi hã? Umɛn ikpurhi iwu anera, ru nyaka umbi. Umɛn ikũ Isarhe Iyiki Ize ikũwã umbi, idɛyiwa umbi idzidzipa ra abin aka atãrhã akɛrɛ na awe abi Unum uwu urhɛ, uwuruwi aka amuna afã nu abĩ, nu akau akagɔng, nu kishoo abinkɛ aka awe ra ake. ");
INSERT INTO ldb_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ivang iyi isha, unga aneke abĩã kishoo azɛ̃rhã ru udĩkpi umbɔ aka abee. ");
INSERT INTO ldb_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Bɔr unga asi inekuka idɛyiwe ugɛ unga awu umɔ ri ikorhe abin aka aze ra anera. Unga acorhuwa umɛn ri idzaa inai ra afã nu abingha, adzaa umbi ubingha umbi agha, na atsu umbi agɔm anggɔm ra amɛnmbi.>> ");
INSERT INTO ldb_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Uko nggu arherha akɛrɛ umbɔ agũ uver kata na akɛn anera abɛrɛ ikorhuwe umbɔ idɛm. ");
INSERT INTO ldb_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Mɔcɛ abi Uyahuda abɔɔ adzeku Uantakiya nu Uikoniya aba adzipa amɛn ikikɔnga. Umbɔ atang atarh nu Uburhu na adɔ̃rhã unga azĩmbɔ ru undzing utepa, akaifɛrhkɔ agɛ unga aka akpea. ");
INSERT INTO ldb_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Bɔr angwɛ̃ imesa aka akɔng akan adziira unga, unga asoka na azɛ̃rhã atsĩã ru utepa. Unum uvaa unga nu Ubarnaba azĩmbɔ Udarbe. ");
INSERT INTO ldb_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Umbɔ adzowe Isarhe Iyiki Ize ru utepa na akpo angwɛ̃ imesa arhɛrhɛ. Mɔcɛ umbɔ abvui azĩmbɔ Urhistira, nu Uikoniya nu Uantakiya aki Upisidiya, ");
INSERT INTO ldb_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","afituwe angwɛ̃ imesa ha umbɔ adɛ̃ɛ̃ aker ri imangmangmbɔ hã. Agɔr agɛ, <<Awu ufang umɛn iki ihwa uver urhɛrhɛ ni idɔrhi ikpo itsĩ Iyɛrhe Unum.>> ");
INSERT INTO ldb_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Uburhu nu Ubarnaba asɛnge umbɔ akakũ ukpui abika adɔsa, nggu ikpem igha ubin nu ifɛn-Num umbɔ aka ayɛruwe umbɔ ru Uteijee, uwuruwi umbɔ aka awe ri imangmang ru unga. ");
INSERT INTO ldb_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Amaa uzɛ̃rhã adɔsa udika abĩ Upisidiya, aba atsĩ abĩ Upamfirhiya, ");
INSERT INTO ldb_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","umbɔ aka adũwã Arherhu-Num ru Uperga, mɔcɛ umbɔ azĩmbɔ Uatarhiya. ");
INSERT INTO ldb_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Adzeku Uatarhiya atsĩ ukhukhɔɔ amɛ̃ abvui azĩmbɔ Uantakiya, anangkɛ umbɔ aka abee iwembɔ imimutu Unum ri itseryɛ umbɔ aka atɔ̃ amaa. ");
INSERT INTO ldb_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Umbɔ aka azĩ atsĩ Uantakiya, umbɔ akɔng abika adɔsa asɔme kishoo ubinkpi Unum aka akorhe ru ubokmbɔ nu amɛnkɛ umbɔ aka atsuruwe utsĩndĩ imangmang ra atsen abi Uyahuda igambɔ. ");
INSERT INTO ldb_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Umbɔ asei adermbɔ ru nggɔɔ ha nggu angwɛ̃ imesa. ");
INSERT INTO ldb_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Aner abɔɔ adzeku Uyahudiya aba ru Uantakiya anu imesuwe abika adɔsa agɛ, <<Umbɔ aba asi isorhuwambɔ umbi usorhe ru nyaki Íkpem Umusa iki iwe, umbi asi íkpombi ififɔrh.>> ");
INSERT INTO ldb_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Awu uning akarhãrhã umbɔ Uburhu nu Ubarnaba aka akorhe nggu aner ha ra arherhe akɛrɛ. Nggee umbɔ asɛng umbɔ Uburhu nu Ubarnaba nu abɔɔ umbɔ azĩ Urusharhima ra abi itser Uyesu nu akakũ abika adɔsa ri itsi arherhe ha. ");
INSERT INTO ldb_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Abika adɔsa ha azĩ adene umbɔ azĩmbɔ, na adɔsa udika abĩ Ufinikiya nu aki Usamariya, umbɔ asɔm arherhe atsen abi Uyahuda aka adzipa azĩ ru Unum. Arherha akɛrɛ atsu abika adɔsa kishoo agɔm anggɔm akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ivangyɛ umbɔ aka azĩ atsĩ Urusharhima, abika adɔsa nu abi itser Uyesu nu akakũ ayɛi umbɔ, Uburhu nu Ubarnaba asɔme umbɔ kishoo ubinkpi Unum aka akorhe ra abokmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Bɔr abika adɔsa abɔɔ abika awu ru ugbɛr uwu abi Ufarisi asok adɛ̃ɛ̃ na agɛ, <<Awu ufang abi imangmang ra atsen umbɔ asorhuwe umbɔ usorhe na adɔsi Íkpem Umusa.>> ");
INSERT INTO ldb_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Abi itser Uyesu na akakũ akɔng arherha arherhe ri itsi arherhe ha. ");
INSERT INTO ldb_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Umbɔ aka amaa uning akarhãrhã, mɔcɛ Ubitru asok adɛ̃ɛ̃ na agɔr umbɔ agɛ, <<Umbi angwɛ̃mɛn, umbi ahwɛngmbi rimɔ̃ɔ̃ Unum asɛng umum ru umbi agɛ atsen abi Uyahuda agũ Isarhe Iyiki Ize ru ubokmum na awe ru imangmang. ");
INSERT INTO ldb_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Unum aka ahwɛng amɛn anera, adeyiwa agɛ unga aka ayɛisa umbɔ ri idzowe umbɔ Ipfu Isarsatangge ru nyaka unga aka adzaa umɛn. ");
INSERT INTO ldb_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Unga asi iyotunga ugɛ umɛn iwiwemɛn nggu umbɔ unga asaruka amɛnmbɔ ri imangmangmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nggee, awu use utsu umbi anu iviru Unum ri itsorhuwe abin aka amor ru atsi angwɛ̃ imesa abɛrɛ umɛn nu atesmɛn iki isi idɛ̃ɛ̃ itsãmɛn? ");
INSERT INTO ldb_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ĩ'ĩ! Umɛn ihwɛng ugɛ awu imimuta Uteijee Uyesu ngge inu ifɔrha umɛn, ru nyaka ngge iki ifɔrhe umbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kishoo ikikɔng anera inũ ukutata na akpeto ru Ubarnaba nu Uburhu umbɔ aka asɔme umbɔ abin idzeu nu igbigbayɛ Unum aka akorhuwe atsen abi Uyahuda ru ubokmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ivangyɛ umbɔ aka amaa arherhe ha, Uyaku agɛ, <<Umbi angwɛ̃mɛn, aka akpeto ru umum. ");
INSERT INTO ldb_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Usiman asɔma umɛn ikikorhu Unum unga aka atirha asɛng abɔɔ ra atsen abi Uyahuda umbɔ awu abinga. ");
INSERT INTO ldb_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Akɛrɛ ha awu uku kpengkpeng nggu arherhe abika asɔm Arherhu-Num. Umbɔ aka atsɛng agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","<< <Akɛrɛ ha aka imaa umum ibvui ĩbamum iba idzin utsurha Udauda uku ugba. Umum ibvui iberukũ igbigbangge, umum ibvui itarukũ. ");
INSERT INTO ldb_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Nggee anera abika abɔr aka ibeea umum Uteijee, nu kishoo atsen abi Uyahuda umum iki isɛng umbɔ awu abimum.> Awu Uteijee uwuku ukorha abin hã arherhe arherhe akɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ahwɛngmbɔ akɛrɛ ha ishaisha. ");
INSERT INTO ldb_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","<<Nggee, aba awu inyĩnyãmum, isi imɛ̃ngge umɛn ipare atsen abi Uyahuda abika adzipa aba udiku Unum. ");
INSERT INTO ldb_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Bɔr umɛn itsɛnge umbɔ ubvur isɔme umbɔ niba aghambɔ ubinkpi umbɔ aka ayɛruwe ru ugberhe, use itoma-dak, nu atãi ijuɛyɛ umbɔ aka ashĩrhũwe urhɔka, use atãi adzirh. ");
INSERT INTO ldb_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ubinkutsu aka avarhukumbɔ Íkpem Umusa ru ubɛn utepa ishaisha, na avarhumbɔ ra abã ifɛn-Nummbɔ ubɛn unum ukpuku uwosha.>> ");
INSERT INTO ldb_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Mɔcɛ abi itser Uyesu nggu akakũ nu kishoo abika adɔsa, anyã azea umbɔ asɛng anera ra adɔkambɔ adene umbɔ azĩ Uantakiya nggu Uburhu nu Ubarnaba. Umbɔ asɛng Uyahuda uwu umbɔ iki iyisa Ubarsabba, nu Usirha, ikivarhambɔ aka awu anggbaashi ra abika adɔsa. ");
INSERT INTO ldb_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Nggu umbɔ adene ubvur uwurɛ uwu utsɛng ugɛ, Abi itser Uyesu nu akakũ abika adɔsa, angwɛ̃mbi, Uzĩ ra abika adɔsa atsen abi Uyahuda ru Uantakiya, ra abĩ Usuriya nu aki Ukirhikiya, Ighwe. ");
INSERT INTO ldb_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Umɛn igũ abɔɔ adzeku umɛn asoyiwa amɛnmbi nggu arherhambɔ, adzunuwa umbi nggu ubinkpi umbɔ iki irherhe, asi iwea umɛn idene umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nggee umɛn iki ibema ni inyã azea umɛn isɛng abɔɔ idene umbɔ aba ru umbi nggu awɛrhamɛn umbɔ Ubarnaba nggu Uburhu, ");
INSERT INTO ldb_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","abirabɛ aka adzowe urhɛmbɔ ri itsok Uteijeemɛn Uyesu Ukiristo ha. ");
INSERT INTO ldb_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nggee umɛn idene umbɔ Uyahuda nggu Usirha aba ru umbi asɔma umbi abin hã ra angwĩmbɔ umɛn iki itsɛng. ");
INSERT INTO ldb_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ipfu Isarsatangge nu umɛn inyã azea umɛn niba itsukamɛn umbi imoryɛ iki inangngge umbi, umɛn ikpurhi isɔma umbi abinkɛ aka awu ufang. ");
INSERT INTO ldb_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Umbi niba aghambi ubinkpi umbɔ aka ayɛruwe nu agberhe, use atãi ijuɛyɛ umbɔ aka ashĩrhũwe urhɔka, use itãi adzirh, use itoma-dak. Umbi aba atsammbi atsimbi ra abin akɛrɛ, umbi akorhe iyiki ize nukpɔ. Aka azĩ uku utɔɔ. ");
INSERT INTO ldb_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Umbɔ adene umbɔ itser ha abvui azĩmbɔ Uantakiya, anangkɛ umbɔ aka akɔng abika adɔsa adzowe umbɔ ubvur ha. ");
INSERT INTO ldb_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ivangyɛ anera aka avarhu ubvur ha, umbɔ agɔm anggɔm nggu itɛnamɛn nu arherhe ififitayɛ umbɔ aka avarhe. ");
INSERT INTO ldb_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Uyahuda nu Usirha, umbɔ awu abika asɔm Arherhu-Num, arherha arherhe ififita na afituwe abika adɔsa nggu irhɛm arherhe. ");
INSERT INTO ldb_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Umbɔ aka amaa ivang iyɔɔ umɔ, umbɔ adene abika adɔsa azĩ nggu igũibɛn iyi ididɔɔr ra abirabɛ aka adene umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Uburhu nu Ubarnaba asei adãrhũmbɔ ivang ru Uantakiya nu aner abɔɔ arhɛrhɛ aka amesuwe na adzowe isarhe Arherhu Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ivanga ukunjiir iki itɔng Uburhu agɔr Ubarnaba agɛ, <<Uba umɛn izĩmɛn ubɛn iteuyɛ umɛn iki idzowe isarhe Arherhu Uteijee izĩ iyepa angwɛ̃mɛn nu anapumɛn, ni inyãni ubinkpi umbɔ iki ikorhe.>> ");
INSERT INTO ldb_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ubarnaba abee ikũ nggu Uyohana, umbɔ iki iyisa Umarku, umbɔ azĩ urhɔnga. ");
INSERT INTO ldb_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Bɔr Uburhu asi ikaifɛrhkɔ ugɛ izengge umbɔ akũna unga, ubinkutsu, unga asi idɛ̃ɛ̃nga nggu umbɔ ri itser ru Upamfirhiya. ");
INSERT INTO ldb_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Uning igigau utsotsoramgbɔ, utsu umbɔ agaumbɔ. Ubarnaba akũ Umarku umbɔ atsĩ ukhukhɔɔ amɛ̃ azĩmbɔ Usayifuru. ");
INSERT INTO ldb_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Bɔr Uburhu asɛng Usirha umbɔ azĩmbɔ, abika adɔsa afɛne umbɔ Uteijee unga atsu imimutanga idzɛu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Unga adɔsa udika abĩ Usuriya nu aki Ukirhikiya, afita abika adɔsa. ");
INSERT INTO ldb_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Uburhu agbaashia aba Udarbe mɔcɛ na azĩ uteu Urhistira, anangkɛ ungwɛ̃ imesa uwɔɔ itsoka igburh Utimoti. Uyanga awu una Uyahudiya uwuku ududɔsa, bɔr utɛnga awu utsa Uherhini. ");
INSERT INTO ldb_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Abika adɔsa ru Urhistira nu Uikoniya arherhi iyiki ize ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Uburhu abee ikũ unga azĩ uzɛ̃rhã, nggee unga atsu umbɔ asorhuwe unga usorhe, ubinkutsu abi Uyahuda abi anang hã kishoo ahwɛngmbɔ utɛ Utimoti awu utsa Uherhini. ");
INSERT INTO ldb_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Umbɔ aka azɛ̃rhã atsĩrhĩ iteu, anu idɛyiwe anera abinkɛ abi itser Uyesu nu akakũ ru Urusharhima, adɛyiwe abika adɔsa, adɔsa ake. ");
INSERT INTO ldb_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ngge itsu abika adɔsa atoma awu akerketambɔ ri imangmang, nu irhɛmbɔ inũ ititoma ubɛn unuma. ");
INSERT INTO ldb_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Uburhu nu awɛrhu uzɛ̃rhãnga azĩ udika abĩ Ufirijiya na aki Ugarhatiya, ubinkutsu Ipfu Isarsatangge ikɛnngge umbɔ idzowe isarhe Uteijee ru abĩ Uasiya. ");
INSERT INTO ldb_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ivangyɛ umbɔ aka aba atsĩ nu atsom abĩ Umisiya, umbɔ abee izĩ abĩ Ubitiniya, bɔr Ipfu Uyesu ikɛnngge umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nggee umbɔ adɔsa udika abĩ Umisiya acipa azĩmbɔ uteu Utoruwa. ");
INSERT INTO ldb_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Nu untsuuka Uburhu anyã irhi uner abĩ Umakidoniya aka adɛ̃ɛ̃ na ashɔ̃rhã unga agɛ, <<Uma uba Umakidoniya uba uyika umɛn.>> ");
INSERT INTO ldb_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Uburhu aka anyã irhi ha, kanying umɛn ingbika abinmɛn izĩmɛn Umakidoniya, ubinkutsu umɛn inyã Unum unga ayisa umɛn idzowe Isarhe Iyiki Ize ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Umɛn isok ru ukhukhɔɔ amɛ̃ idzeku Utoruwa uku urhirhiki izĩmɛn Usamutarkiya. Unum uvaa umɛn itsĩmɛn Uniyaforhi. ");
INSERT INTO ldb_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Umɛn idze umɔ izĩmɛn uteu Ufirhipi, ukpuku uwe anang isei abi Uroma uteu ukugɔnga ra abĩ Umakidoniya. Umɛn imaa inuma umɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ru unum ukpuku uwosha umɛn idzeka angwĩ utepa izĩmɛn ru ubang azɛ̃, anangkɛ umɛn iki itsar ugɛ awu anang ifɛn-Num. Umɛn isei ni irherha arherhe ra akatsɛrh aka akɔng umɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Utsɛrh uwɔɔ ra abika akpeto itsoka igburh Urhidiya, unga awu una uteu Utiyatira anu igoyiwe atorho undzuna, uwuku udzowe igɔng ru Unum. Uteijee ayanguwe amɛnnga unga akpeto ru ubinkpi Uburhu aka arherhe. ");
INSERT INTO ldb_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ivangyɛ umbɔ aka asorhuwe unga ubɔtisima nggu aner iyanga, unga ayisa umɛn izĩ ri iyanga agɛ, <<Umbi aba abemumbi agɛ umum iwu uwuku uwe ru imangmang ru Uteijee, àka aba acipa ri iyamum.>> Unga aka agbiir amɛnmɛn umɛn ibemumɛn. ");
INSERT INTO ldb_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Unum ukpɔɔ umɛn izĩ ra anang ifɛn-Num ni igbopu una uwɔɔ awu ugãrhã awuri ipfu iyiki ibewe iyi irhi. Unga aka isaka akposhuwe uhwɛk ru ateiyanga akarhãrhã ri itser irhi ha. ");
INSERT INTO ldb_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Unga anu idɔsu Uburhu nu umɛn, atsu ivum, anu igɔr agɛ, <<Abɛrɛ awu agãrhũ Unum Uwuku Ugɔng anu idɛyiwa umbi utsĩndĩ uwuku ufɔrh.>> ");
INSERT INTO ldb_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Anu ikorhe rimi inuma irhɛirhɛ utsɛku Uburhu agũ avɔm, na adzipa agɔr ipfu iyiki ibewe ha agɛ, <<Umum itsu ungo ri itsok Uyesu Ukiristo upfudzeka ru unga!>> Kanying ipfu iyiki ibewe ha idzekngge ru unga. ");
INSERT INTO ldb_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ivangyɛ ateiya una hã aka anyã utsĩndĩ ikpo uhwɛkmbɔ uku uborhmgbɔ, mɔcɛ umbɔ adzur Uburhu nu Usirha agbĩrhã umbɔ azĩmbɔ ra anang izɛɛ ra asu abi ijee. ");
INSERT INTO ldb_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Umbɔ aka akũna umbɔ azĩ ra abika atsu uvau abi Uroma na agɛ, <<Aner abɛrɛ awu abi Uyahuda, adɛ̃ɛ̃ isoyiwe amɛn utepmɛn. ");
INSERT INTO ldb_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Anu imesuwa agbeyakɛ aka asi imɛ̃ke ri ikpemyɛ umɛn abi Uroma iki iyɛi use umɛn ĩdɔsa.>> ");
INSERT INTO ldb_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Anera akɔng nu atsimbɔ Uburhu nu Usirha, abika atsu uvau atsuke anera atsimuwe atorhambɔ na akwɛr umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Umbɔ aka akwɛr umbɔ akarhãrhã amaa, atsuke umbɔ ru ugborzĩ, atsu uner idzɛu angwɛ̃dzɛn na adzɛu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Unga aka ayɛi itsera, unga atsuke umbɔ ru unɔrkang ugbora, atsuke adakmbɔ ru ukhɔɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ayoka ikɔ untsuuka Uburhu nu Usirha afɛn-Num atsusa abom ikpoi Unum, abirabɛ umbɔ aka agbange ru ugborzĩ hã akpeto ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kanying nggaa izizusa abĩ itsu atarh idzin ugbor uzĩ hã azusa. Kanying kishoo angwĩ ubã ugbor uzĩ atsuri, kishoo inyãwã iyiriyɛ umbɔ aka abow abi ugbora igarhe. ");
INSERT INTO ldb_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Uner adzɛu ugborzĩ hã aka azir ru urhɔ anyã angwĩ ubã agbora adɛ̃ɛ̃ iyɛm, unga awɔɔr ikonnga abee ifɛre itsinga, ubinkutsu akaifɛrhkɔ agɛ abirabɛ umbɔ aka agbange ru ugborzĩ hã aka atĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bɔr Uburhu atsarhi irhaknga atsu ivum agɛ, <<Niba unayikɔ itsingo! Umɛn abɛ kishoo iwu umɔ!>> ");
INSERT INTO ldb_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Uner udzɛu ugborzĩ hã agɔr umbɔ akũ irhirhang aba, mɔcɛ unga asok adɛr atsĩ azang iwei ifɛr unga atararhu ra asu Uburhu nu Usirha. ");
INSERT INTO ldb_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Mɔcɛ unga akũna umbɔ adzeka ra awiya na arhusa agɛ, <<Umbi anggbaashi, umum ikorhu use aka awu ufang ni ikpo ififɔrh?>> ");
INSERT INTO ldb_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Umbɔ agɛ, <<Uwe ru imangmang ru Uteijee Uyesu, ungo uwuri ikpikpoɔ ififɔrh, ungo nu abi iyango.>> ");
INSERT INTO ldb_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mɔcɛ umbɔ arherhe Arherhe Uteijee asɔme unga nu abirabɛ aka awu ri iyanga kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ru untsuua ha ri ivang hã uner idzɛu ugbor ha aka akũna umbɔ azĩ asorhe isɔɔmbɔ. Kanying unga nu abi iyanga kishoo asorhuwe umbɔ ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Unga akũna umbɔ atsĩã ri iyanga akowe umbɔ ubingha. Unga nu abi iyanga kishoo agɔm anggɔm ubinkutsu umbɔ kishoo awembɔ ri imangmang ru Unum. ");
INSERT INTO ldb_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ukpe uku usar, abika atsu uvau adene ambow ikow agɛ, <<Atsũwe aner abɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Nggee uner idzɛu ugbor ha adɛyiwe Uburhu agɛ, <<Abika atsu uvau agɔr agɛ atsũwe umbi. Icɛrɛ aka adzek. Azĩ uku utɔɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Bɔr Uburhu agɔr uner idzɛu ugbor ha agɛ, <<Akwɛr umɛn ra asu anera na asi ivarhumbɔ arherhe, umɛn abɛ iwu aner Uroma, na atsuke umɛn ru ugborzĩ. Icɛrɛ umbɔ awuri itsũwe umɛn ri iwɔk? Ĩ'ĩ, rinɛɛ! Uneke umbɔ aba nibikambɔ aba atsũwe umɛn idzek.>> ");
INSERT INTO ldb_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ambow ikow ha azĩ asɔme abika atsu uvau arherha akɛrɛ ha. Abika atsu uvau aka agũ agɛ Uburhu nu Usirha awu aner Uroma, iwei ifɛr umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nggee umbɔ aba ashɔ̃rhã umbɔ Uburhu nu Usirha, atsũwe umbɔ, na adene umbɔ adzek ru ugborzĩ, na ashɔ̃rhã umbɔ ama adzek ru utepa. ");
INSERT INTO ldb_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ivangyɛ umbɔ Uburhu nu Usirha aka adzek ru ugborzĩ hã, umbɔ abvui azĩmbɔ ru iya Urhidiya, umɔ umbɔ aka akɔng nggu abika adɔsa na afituwe umbɔ. Mɔcɛ umbɔ abɔrukumbɔ utepa. ");
INSERT INTO ldb_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Uburhu nu Usirha aka azɛ̃rhã adɔsa udiku iteu Uamfiporhi nu Uafirhoniya, aba atsĩ uteu Utasarhonika, anangkɛ ubã ifɛn-Num abi Uyahuda uku uwe. ");
INSERT INTO ldb_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ru nyaku Uburhu aka abayi, atsĩ ru ubã ifɛn-Num hã, inum iyiki iwiwosha itaar umbɔ aka anu irhisi itsɛng Arherhu-Num nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Unga anu isɔme umbɔ na adɛyiwe umbɔ idzidzɛrhe agɛ awu ufang Ukiristo aka ihwa uver na asoku udzak. Uburhu agɔr umbɔ agɛ, <<Uyesu ha umum iki inu indɛyiwa umbi unga awu Ukiristo.>> ");
INSERT INTO ldb_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Abɔɔ abi Uyahuda abemumbɔ arherhe Uburhu nu Usirha, nu arhɛrhɛ abi Uherhini abika agũ iwei Unum nu akatsɛrh akagɔng atomi itsi nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Bɔr abi Uyahuda abikase agũ unyɛ̃ɛ̃, umbɔ akɔng awɛ ugbau ra atsĩndĩ, umbɔ aka akɔng kishoo ahwita abi utepa. Akũ avɔm atsĩ ri iya Ujason abee Uburhu nu Usirha abee ikũna umbɔ adzeka ra anera. ");
INSERT INTO ldb_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Bɔr umbɔ aka asi inyãmbɔ umbɔ, umbɔ adarhu Ujason nu abika adɔsa abɔɔ akũna umbɔ azĩmbɔ ra asu abi ijee utepa, atsuyi ivum agɛ, <<Aner abɛrɛ abika asoyi amɛn ubɛn ananga ru upfung nggabɛ aka abambɔ nggimi. ");
INSERT INTO ldb_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ujason ayɛi umbɔ akũ atsĩ ri iyanga. Kishoo akpɛ̃mbɔ idɔsi ikpem Ukaisar, anu igɔr agɛ uyɛrhe uwɔɔ, itsoknga igburh Uyesu.>> ");
INSERT INTO ldb_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Umbɔ aka agũ rimi, anera nu abi ijee utepa agũ avɔm akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Mɔcɛ umbɔ atsu Ujason na anera abɔɔ afai uhwɛk na aneke umbɔ azĩmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Utsuu uku ufin abika adɔsa adene Uburhu nu Usirha azĩmbɔ Ubiriya. Umbɔ aka azĩ atsĩ umɔ, umbɔ atsĩ ru ubã ifɛn-Num abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Abi Ubiriya awu ra amɛn akika agũ arherhe ha anangmbɔ abi Utasarhonika, ubinkutsu ayɛi arherhe ha aboka avaa avaa. Anu itsu asumbɔ ri itsɛng Arherhu-Num ubɛn unuma abee inyã ubinkpi Uburhu aka arherhe uwu idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Abi Uyahuda arhɛrhɛ awe ru imangmang, nu abi Uherhini, akatsɛrh abika agɔng nu ikɛi akatsak. ");
INSERT INTO ldb_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Bɔr abi Uyahuda ru Utasarhonika aka agũ agɛ Uburhu adɛ̃ɛ̃ idzowe isarhe Arherhu-Num ru Ubiriya, umbɔ asok azĩmbɔ umɔ ikɛi. Umbɔ aka azĩ atsĩ, ahwita anera asoyiwe amɛnmbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Kanying kanying abika adɔsa akũ Uburhu azĩ ru ubang ukau azɛ̃ akagɔng, bɔr Usirha nu Utimoti aseimbɔ ru Ubiriya. ");
INSERT INTO ldb_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Abirabɛ aka azĩ adene Uburhu akũna unga azĩ atsĩmbɔ Uatina. Abvui aba akũ nggu itser Uburhu aka adene umbɔ ugɛ Usirha nu Utimoti aba akpo unga iki ifefetem. ");
INSERT INTO ldb_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Uburhu aka adɛ̃ɛ̃ adzɛu umbɔ ru Uatina, amɛnnga aghong akarhãrhã unga aka anyã utepa nggu agberhe arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nggee unga aka isaka arherha arherhe ru ubã ifɛn-Num nggu abi Uyahuda nu abi Uherhini abɔɔ abika agũ iwei Unum, ikɛi ubɛn unuma unga iki irherha arherhe nggu abirabɛ unga iki ikpo ra anang izɛɛ. ");
INSERT INTO ldb_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Rimi hã ikɛi abi ifɛrhkɔ itsoi umbɔ iki iyisa Uabikuriya nu Usitokiya anu irherha arherhe nggu unga. Abɔɔ arhusa agɛ, <<Uwɛrɛ uner ugbugbewa uwurɛ abee igɔr agɛ use?>> Abɔɔ agɛ, <<Awu uner uwuku udzowe isarhe anum abɔɔ abĩ akase.>> Ubinkutsu umbɔ arherhe rimi Uburhu anu idzowe Isarhe Iyiki Ize iyi Uyesu, nu isok ra akpe. ");
INSERT INTO ldb_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Mɔcɛ umbɔ akũna unga azĩmbɔ udzepurhe anang ikikɔngyɛ umbɔ aki iyisa Igũ Uarasa agɔr unga agɛ, <<Uba udɛyiwa umɛn imesa iyiki ifa iyɛ ungo uku unu imesuwe. ");
INSERT INTO ldb_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ungo ukũ itsen arherhe ake atsĩ ra atomɛn, umɛn ibee ihwɛng agbena.>> ");
INSERT INTO ldb_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kishoo aner Uatina nu atsen abika asei umɔ, anyangi ivangmbɔ asi ikorhumbɔ ubin bɔr anu irherhe na agosha abin aka afa. ");
INSERT INTO ldb_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Uburhu asok adɛ̃ɛ̃ ra asu ikikɔnga, na agɛ, <<Umbi aner Uatina! Umum inyã umbi awu abika abema agbeyi akarhãrhã nu afɛna kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ubinkutsu ivangyɛ umum iki izɛ̃rhã imaa utepa umum inyãmum abinkɛ umbi iki idzowe igɔng nu ake, ikɛi umum inyãmum ubeu idɛm anummbi nggu itsɛng iki igɔr igɛ, <UZĨ RU UNUMWI UMBƆ AKA ASI IHWƐNGMBƆ.> Ubinkpi umbi aka asi ihwɛngmbi na adzowe igɔng ru ukpɔ, awu unga umum iki inu idɛyiwa umbi. ");
INSERT INTO ldb_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","<<Unumwi aka amunu upfung nu kishoo abinkɛ aka awu umɔ awu Uteijee afã nu abĩ na asi iseisa ra aya-Numkɛ anera iki idzin. ");
INSERT INTO ldb_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Unga asi ibeenga anera ayike unga, asi ibeenga ubin, ubinkutsu, awu unga adzowe anera kishoo urhɛ nu uwoyi nu abina kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Awu ru unera unying unga aka amunu idũa kishoo, agɛ umbɔ asei ra ananga kishoo ru upfung, unga angwɛ̃ ivangyɛ umbɔ aka isei atsĩ nu inangyɛ umbɔ aka isei. ");
INSERT INTO ldb_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Unum akorhe rimi ngge itsú anera ibeea unga, na awuri ima abãrhã azĩmbɔ ru unga, na awuri ikpombɔ unga. Idzidzɛrhe, asi idera nggu ubɛn unera ru umɛn. ");
INSERT INTO ldb_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","<Ubinkutsu, iwu ru unga umɛn iki iwe ru urhɛ, ni izɛ̃rhã, ni ibɛk.> Ru nyaka abika atsɛng ambommbi abɔɔ aki igɔr agɛ, <Umɛn iwu unangnga.> ");
INSERT INTO ldb_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","<<Ngge iki iwe ugɛ umɛn iwu unang Unum, asi imɛ̃ɛ̃ umɛn ikaifɛrhkɔ ugɛ Unum awu ru uzirhzĩ uzinarhi use uazurhfa use atarh, ubinkpi unera iki ikorhe ri itsoinga. ");
INSERT INTO ldb_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ri iyi isha Unum asi ibeenga idzowe anera uver ihwihwɛng iki ishingge ru umbɔ, bɔr icɛrɛ unga atsu anera kishoo ubɛn ananga umbɔ adzipa. ");
INSERT INTO ldb_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ubinkutsu unga aka angwɛ̃ɛ̃ unumkpi unga aka iba atsu uvau iyi idzidzɛrhe ru upfunga ru ubok uwɔɔ unga aka asɛng. Unga aka adɛyiwa arherhe ha iwuri iwe rimi ra anera kishoo ri isoyiwe uner ha ra akpe.>> ");
INSERT INTO ldb_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ivangyɛ umbɔ aka agũ arherhe isisok ra akpe, abɔɔ acata, bɔr abɔɔ agɛ, <<Umɛn ibee ibvui igũ ubinkpi ungo uku irherhe ra arherha akɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Awu umɔ Uburhu aka abɔre umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Bɔr abɔɔ ukunjiir agbopa nggu Uburhu awe abi imangmang. Ru umbɔ ha awu Udiyonisiyu, uner itser ru udzepurhe, nu utsɛrh uwɔɔ itsoka igburh Udamari, na abɔɔ nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Akɛrɛ ha aka amaa, Uburhu abɔruka Uatina na azĩã Ukorinti. ");
INSERT INTO ldb_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nggɔɔ ha unga aka agbopa nggu utsa Uyahuda uwɔɔ itsoka igburh Uakirha, unga awu uner abi abĩ Ufontu. Unga nu utsɛ̃nga Ubiriskirha anai idzeka abĩ Uitarhiya, ubinkutsu Ukarhaudiyu atsu abi Uyahuda kishoo adzembɔ ru Uroma. Uburhu azĩ inyã umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ubinkutsu itsermbɔ iwu unying iyiki isɔr utenti, mɔcɛ unga aseisa umbɔ atɔ̃ itser urhɔnga. ");
INSERT INTO ldb_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ubɛn unum ukpuku uwosha Uburhu atsĩã arherhe ru ubã ifɛn-Num abee igbiir amɛn abi Uyahuda na Atsen abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ivangyɛ umbɔ Usirha nu Utimoti aka adzeku Umakidoniya aba, Uburhu adzowe ivanga kishoo ri idzowe isarhe, adekuwe abi Uyahuda agɛ Uyesu unga awu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Bɔr abi Uyahuda aka asi ibemumbɔ na irhena unga, unga azusu uzurhu ra atorhanga agɔr umbɔ agɛ, <<Adzirhmbi awu ra atsimbi! Umum ishimum ru uvau. Icɛrɛ umum iwuri izĩ ra Atsen abi Uyahuda.>> ");
INSERT INTO ldb_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Mɔcɛ unga asok azĩã ri iya uwɔɔ itsoka igburh Utitiyu Ujustu, uwuku udzowe igɔng Unum. Iyanga iki ikhapa ru abã ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ukiribu, unggbaashi ubã ifɛn-Num, awea ri imangmang ru Uteijee, unga nggu aner iyanga kishoo. Abi Ukorinti abɔɔ arhɛrhɛ aka agũ unga awembɔ ri imangmang, umbɔ akorhuwe umbɔ ubɔtisima. ");
INSERT INTO ldb_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Untsuuka nukpɔ Uteijee arherhe arherhe nggu Uburhu ru irhi agɔr unga agɛ, <<Niba ugũo iwei, udzowe isarhe, niba unuɔ ukutatata. ");
INSERT INTO ldb_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ubinkutsu umum iwu nggu ungo, unera ashia aka itsu ubok akorhuwa ungo ifɛrhɛ, anermum awu arhɛrhɛ ru utepu ukpirɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nggee Uburhu asei umɔ amɛka nu utenga, amesuwe umbɔ Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ivangyɛ Ugarhiyo aka awu unggbaashi abĩ Uakaya, abi Uyahuda agbopa atsimbɔ igamtsa nggu Uburhu akũna unga azĩmbɔ ru udzepurhe uku uvarha arherhe. ");
INSERT INTO ldb_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Agɔr agɛ, <<Utsak uwurɛ atsu anera adzowe igɔng ru Unum ru utsĩndĩwi Íkpem iki ikɛnngge.>> ");
INSERT INTO ldb_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Uburhu aka abee irherha arherhe, Ugarhiyo agɔr abi Uyahuda agɛ, <<Uda unga akorhu ubin ukpɔɔ uku usi izekpɔ use ukpuku ubewe ri Íkpem, umum igũmum na umbi. ");
INSERT INTO ldb_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Bɔr ngge iki iwu uning ru irhɛm, atsutsok nu Íkpemmbi, umbi aka azĩ arherhe amaa nibikambi. Umum ishimum ra amɛn aka atsu uvau ri ikpũ abin akɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Mɔcɛ unga awayika umbɔ ru udzepurhe uku uvarha arherhanga. ");
INSERT INTO ldb_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Mɔcɛ umbɔ kishoo adzur Usostanu unggbaashi ubã ifɛn-Num, akwɛre unga ugwɛɛ ru udzepurhe uku uvarha arherhe. Bɔr Ugarhiyo asi irhisa. ");
INSERT INTO ldb_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Uburhu asei ru uteu Ukorinti inuma irhɛirhɛ. Na aneke abika adɔsa na atsĩ ukhukhɔɔ amɛ̃ azĩmbɔ abĩ Usuriya, umbɔ Ubiriskirha nu Uakirha azĩ urhɔnga nggu unga. Bɔr uyirhkpi unga aka ayirh utsu umbɔ akone itsinga ru uteu Ukankiriya unga adɔrha azĩ. ");
INSERT INTO ldb_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Umbɔ aka azĩ atsĩ ru Uafisa, umɔ Uburhu aka abɔre umbɔ Ubiriskirha nu Uakirha. Unga atsĩã ru ubã ifɛn-Num arherha arherhe nggu abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ivangyɛ umbɔ aka ashɔ̃rhã unga ama adãrhã nggu umbɔ, unga asi ibemunga. ");
INSERT INTO ldb_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Bɔr unga aka awuri ibɔre umbɔ, unga abemuwe agɛ, <<Umum ibvui inbamum ru umbi Unum aba abemunga.>> Mɔcɛ unga atsĩ ukhukhɔɔ amɛ̃ adzeka ru Uafisa. ");
INSERT INTO ldb_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Unga aka acipa ru uteu Ukaisariya, unga afũã ighwe abika adɔsa ru Urusharhima, mɔcɛ unga acipa azĩã uteu Uantakiya. ");
INSERT INTO ldb_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Unga aka adãrhã amaa ru Uantakiya, Uburhu asok atsĩrhã ra abĩ Ugarhatiya na abĩ Ufirijiya, adɔsu ititeu ayike angwɛ̃ imesa adɛ̃ɛ̃ aker. ");
INSERT INTO ldb_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ivang hã utsa abi Uyahuda uwɔɔ itsoka igburh Uaforho, aba ru Uafisa. Unga awu uner uteu Uarhekzandiriya ru Umasar. Unga ahwɛnga arherhe afina na ahwɛng itsɛng Arherhu-Num akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Aka amesukumbɔ unga ru utsĩndĩ Uteijee, unga aka isaka anyar asunga arherhe uku urhirhiki ri itsi Uyesu, bɔr unga akpurha ahwɛng ubɔtisima Uyohana. ");
INSERT INTO ldb_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Unga atirha adzowe isarhe nggu ikernga kishoo ru ubã ifɛn-Num. Umbɔ Ubiriskirha nu Uakirha aka agũ arherhanga, umbɔ akũna unga azĩmbɔ ri iyambɔ na atoma adɛyiwe unga utsĩndĩ Unum. ");
INSERT INTO ldb_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ivangyɛ Uaporho aka abee izĩ abĩ Uakaya, abika adɔsa afituwe unga na atsɛnge ubvur ra angwɛ̃ imesa ru Uakaya umbɔ ayɛi unga. Unga aka azĩ atsĩ umɔ unga amɛna ayike abirabɛ aka awe ru imangmang ru Unum ru ubok imimuta. ");
INSERT INTO ldb_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ubinkutsu unga ananga abi Uyahuda ra asu anera nggu ijee arherhe akarhãrhã, adɛyiwe umbɔ ri itsɛng Arherhu-Num agɛ Uyesu unga awu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ivangyɛ Uaforho aka awu ru Ukorinti, Uburhu azɛ̃rhã ru utsĩndĩ abĩã azĩ atsĩ Uafisa, umɔ unga akpo angwɛ̃ imesa abɔɔ. ");
INSERT INTO ldb_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Arhusa umbɔ agɛ, <<Umbi ayɛimbi Ipfu Isarsatangge ri ivangyɛ umbi aka awuri imangmang?>> Umbɔ agɔr unga agɛ, <<Ĩ'ĩ, umɛn isi igũmɛn ugɛ Ipfu Isarsatangge iwengge.>> ");
INSERT INTO ldb_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Nggee Uburhu arhusa agɛ, <<Asorhuwa umbi ikpũ ubɔtisima uwukusong rimi?>> Umbɔ agɛ, <<Ikpũ ubɔtisima Uyohana.>> ");
INSERT INTO ldb_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Uburhu agɛ, <<Ubɔtisima Uyohana uwe uwu idzidzipa. Unga adɛyiwe anera umbɔ awe ru imangmang ru uwuruwi aka iba ru undzingnga, awu unga hã awu Uyesu.>> ");
INSERT INTO ldb_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Umbɔ aka agũ rimi, umbɔ asorhuwe umbɔ ubɔtisima ri itsok Uteijee Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ivangyɛ Uburhu aka atsorhuwe umbɔ abok, Ipfu Isarsatangge icipuwangge nu umbɔ, umbɔ atsĩmbɔ irherha arherhe ri idũ iyikise na asɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Umbɔ kishoo ayombɔ inera usɔkdũmɛn. ");
INSERT INTO ldb_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Uburhu atsĩ ru ubã ifɛn-Num adzowe isarhe nggu ikeramɛn afɛ̃ɛ̃ ataar, anu arherhe na agbiir amɛnmbɔ aba ra arherhe Iyɛrhe Unum. ");
INSERT INTO ldb_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Bɔr abɔɔ abi itsi iki iker akpɛ̃mbɔ iwe ru imangmang, na arherhe iyiki ibewe ru Utsĩndĩ Uteijee ra asu anera. Nggee Uburhu abɔruka umbɔ, na akũ angwɛ̃ imesa azĩ amesuwe umbɔ ubɛn unuma ru ubã imesa Utiranu. ");
INSERT INTO ldb_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Akɛrɛ ha anu ikorhe rimi utsɛku imɛka ivaa, ngge itsu kishoo abi Uyahuda nu abi Uherhini abika asei ra abĩ Uasiya agũ Arherhu Uteijee. ");
INSERT INTO ldb_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Unum anu ikorha abin idzeu akɔɔ awuweke ru ubok Uburhu, ");
INSERT INTO ldb_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","utsɛku umbɔ aki ikũ ushanga atorho nu atorhi itser iyɛ iki ibanga unga akũ azĩ ru abi irhãrhã akerhe, nu ípfu iyiki ibewe ikɛi ibɔrukungge umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Abɔɔ abi Uyahuda abika azɛ̃rhã atsĩrhĩ iteu atsusuwe ípfu iyiki ibewe abee ikũ itsok Uteijee Uyesu akorhe rimi hã. Agɔr agɛ, <<Umum itsũ umbi ri itsok Uyesu, Uburhu aka adũwã, àka apfu adzek.>> ");
INSERT INTO ldb_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Angwɛ̃ Usikeba utɔɔva uner Uyahudiya ateiya abika adzowe idɛm-Num nuwɔ, anu ikorhe rimi hã. ");
INSERT INTO ldb_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Unuma nukpɔ ipfu iyiki ibewe igɔr umbɔ igɛ, <<Uyesu umum ihwɛng unga, umum ikɛi ihwɛng Uburhu, umbi awu umbɔ ungaa?>> ");
INSERT INTO ldb_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mɔcɛ uner ha aka awuri ipfu iyiki ibewe ha ater isha afũã nu umbɔ atɔnga ikermbɔ kishoo. Akwɛr umbɔ adzek igbĩrhĩ ri iya ha atĩ nggu isisɔɔ. ");
INSERT INTO ldb_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ivangyɛ kishoo abi Uyahuda nu abi Uherhini abika asei ru Uafisa aka agũ ubinkpi uku ukorhe, iwei ifɛr umbɔ kishoo, umbɔ adzowe igɔng ru itsok Uteijee Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Arhɛrhɛ abika awe ru imangmang aba akũ angwĩmbɔ asɔm itser iyiki ibeweyɛ umbɔ aka akorhe ru awiya. ");
INSERT INTO ldb_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Anera arhɛrhɛ abi igoka akarha abvurmbɔ akpĩĩwe ra asu anera kishoo. Uhwɛk abvur ha utsĩkpɔ íshaa imang uazurhfa anaka agɔnga isɔka itɔ̃ɔ̃ (50,000). ");
INSERT INTO ldb_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ru utsĩndĩ hã Arherhu Uteijee aka adzek atɛ̃rhã akarhãrhã nggu ijee. ");
INSERT INTO ldb_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Akɛrɛ ha aka akorhe kishoo amaa, Uburhu abee izĩ Urusharhima, awuri izɛ̃rhã atɔng udika abĩ Umakidoniya nu aki Uakaya. Agɛ, <<Umum iba izĩ itsĩ imaamum nggɔɔ ha, awu ufang umum izĩ iyepa Uroma ikɛi.>> ");
INSERT INTO ldb_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Unga adene abika ayike unga ikivarhambɔ, Utimoti nu Uarastu, azĩmbɔ Umakidoniya, unga iganga asei ivanga ukunjiir ra abĩ Uasiya. ");
INSERT INTO ldb_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ivang hã iki iyo ubvun uku ugɔng usomgbɔ ra abika adɔsu Utsĩndĩ hã. ");
INSERT INTO ldb_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Uner unai uwɔɔ itsoka igburh Udimitiriyu, uwuruwi aki ikũ uazurhfa anak azirhzĩ iya ugberhe Uartemi. Unga nu abi itsernga akposhu uhwɛk ri itsermbɔ ha akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Unga akɔng umbɔ, nu abika atɔ̃ ikpũ itser ha, na agɛ, <<Umbi anermɛn, àka ahwɛng ugɛ nggu itser iyɛrɛ umɛn iki ikpo abin. ");
INSERT INTO ldb_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Umbi anyãmbi na agũmbi asi iwea ri nggimi ru uteu Uafisa ukpekũ, abĩ Uasiya kishoo abɔr ukunjiir, Uburhu uwurɛ aka igbiite amɛnmbɔ na anu igɔr agɛ anum abɛ umbɔ iki ikũ abok agbisha asi iwembɔ anum. ");
INSERT INTO ldb_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Ighighong iwe asi íwea igba abĩ itsermɛn ukpekũ, bɔr iya-num nggaa Uartemi awuri itsu ike ishike ru ugarh, nu Uartemi nibikanga, umbɔ iki idzowe igɔng ra abĩ Uasiya nu upfunga kishoo, awuri ishia ri igɔng.>> ");
INSERT INTO ldb_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ivangyɛ umbɔ aka agũ rimi, avɔm afɛr umbɔ akarhãrhã, umbɔ atirhi itsarhi irhakmbɔ agɛ, <<Igɔng iwe nggu Uartemi aki Uafisa!>> ");
INSERT INTO ldb_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Kanying utepa kishoo udzunukpɔ. Agbĩrhũ Ugayu nu Uaristaku, aner Umakidoniya, abirabɛ aka awu awɛrhu uzɛ̃rhũ Uburhu. Anera kishoo atĩ azĩmbɔ ra anang ikikɔnga. ");
INSERT INTO ldb_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Uburhu abee itsĩ ra anang ikikɔnga, bɔr angwɛ̃ imesa akɛnmbɔ unga. ");
INSERT INTO ldb_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Anggbaashi abɔɔ ra abĩ Uasiya, abirabɛ aka awu awɛrhu Uburhu, adene itser ashɔ̃rhã unga agɛ unga niba atsĩã ra anang ikikɔnga. ");
INSERT INTO ldb_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Anera aka akɔng umɔ adzunumbɔ, abɔɔ asi ihwɛngmbɔ ubinkpi uku utsu umbɔ akɔng. Abɔɔ atsarhi irhakmbɔ arherhe arherhe, abɔɔ anu irherha akimbɔ awuweke. ");
INSERT INTO ldb_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Abi Uyahuda ayiru Uarhekzanda ra asu abɔɔ ri ikikɔnga unga atsu ivum abee unga arherha arherhe. Unga aberu uboknga umbɔ anukutata ru unga ikaa itsinga ra anera. ");
INSERT INTO ldb_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Bɔr umbɔ aka ahwɛng agɛ unga awu utsa Uyahuda, umbɔ atsarhi irhakmbɔ kishoo agɛ, <<Igɔng iwe nggu Uartemi ukpu Uafisa.>> Akorhe rimi ayombɔ akara avaa. ");
INSERT INTO ldb_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Bɔr uner itsɛng utepa atsu umbɔ anukutata, na agɛ, <<Umbi aner Uafisa, upfunga kishoo usi ihwɛngkpɔ ugɛ uteu Uafisa ukpuku udzɛu iya nggaa Uartemi, nu asarkasar utarh ha uku udzeka afã uba ugba? ");
INSERT INTO ldb_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Iki isi iwengge ubin itsɛyi nggu abin akɛrɛ, imɛ̃ngge umbi adɔɔr amɛnmbi niba azangmbi. ");
INSERT INTO ldb_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nggayɛ anerabɛ umbi aka akũ aba nggimi, asi ivɛumbɔ ivɛu ra aya-num, asi irhenumbɔ unummɛn Uartemi. ");
INSERT INTO ldb_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bɔr Udimitiriyu nu awɛrhi itsernga aba awembɔ ru ubin ukpuku ughong amɛnmbɔ nggu ubɛn unera, udzepurhe ukpuku uvarha arherhe ukpi utsurirɛ, ikɛi abika atsu uvau, adɛ̃ɛ̃ azĩ atsumbɔ arherhe ri itsimbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Aba awu ubin ukpɔɔ umbi aka abee, àka ahwɛng ugɛ awuri irherha ake ru udzepurhe ukpuku uvarha arherhe. ");
INSERT INTO ldb_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ngge iki iwe rimi, igbaigba iwe ru umɛn, ubinkutsu awuri itsumbɔ arherhamɛn ri isoyamɛn irherɛ, ni isi ídɛ̃ɛ̃ isɔmmɛn awu use utsu isoyamɛn hã. Ni isi ítsɛngamɛn awu use utsu isoyamɛn hã.>> ");
INSERT INTO ldb_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Unga aka arherhe rimi amaa, na asoyika ikikɔnga. ");
INSERT INTO ldb_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ivangyɛ isoya amɛn hã iki idɔɔr, Uburhu ayisa angwɛ̃ imesa ha, unga aka amaa ifituwe umbɔ, aghwe umbɔ unuma na azĩã abĩ Umakidoniya. ");
INSERT INTO ldb_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Unga aka azɛ̃rhã ri inang hã, arherhuwe irhɛm irhɛirhɛ iyiki ififita ra anera, na amasha atsĩã abĩ Uherha. ");
INSERT INTO ldb_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Umɔ unga asei afɛ̃ɛ̃ ataar, na abee itsĩ ukhukhɔɔ amɛ̃ azĩ abĩ Usuriya, na agũ ugɛ abi Uyahuda aka adzɛu abee ikorhe iyiki ibewe nggu unga ri ivang hã, nggee unga abvui adɔsu udiku Umakidoniya. ");
INSERT INTO ldb_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Abika azĩ nggu unga awu Usopata ungwɛ̃ Upuru aka adzeku Ubiriya, Uaristaku nu Usakundu aner Utasarhonika, nu Ugayu uner Udarbe, nu Utimoti ikɛi, nu Utikiku nu Uturofimu aner abĩ Uasiya. ");
INSERT INTO ldb_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Aner abɛrɛ agbaashia asok azĩmbɔ idzɛu umɛn ru Utoruwa. ");
INSERT INTO ldb_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Bɔr umɛn itsĩ ukhukhɔɔ amɛ̃ ru Ufirhipi umbɔ aka amaa Irhowa Uborodi Ukpuku Usheru Uguga, umɛn imaa inuma itɔ̃ɔ̃ ni ikpo umbɔ ru Utoruwa. Umɔ umɛn isei inuma utɔɔva. ");
INSERT INTO ldb_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ru unum inggbaashia ri inuma utɔɔva umɛn ikɔng itsɔku uborodi. Uburhu adzowe isarhe ru umbɔ, unga abee isisok ukpe unum uvaa, adɛ̃ɛ̃ adzowe isarhe utsɛku ikɔ untsuuka. ");
INSERT INTO ldb_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Atseu irhirhang awu arhɛrhɛ ru ubã afã hã umɛn iki ikɔng. ");
INSERT INTO ldb_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ungwɛ̃dzɛm uwɔɔ itsoknga igburh Uyutiku, asei nu angwĩ ugba, agbɛu urhɔ ri ivangyɛ Uburhu aka anu idzowe isarhe iyiki ider. Urhɔ uku unyangu Uyutiku, unga ashɔɔr ri iya afã ugbɛr uwu untaar aba agba umbɔ ashupa unga ukoma. ");
INSERT INTO ldb_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Uburhu acipuwa nu abĩ, aba agbapfu nu ungwɛ̃dzɛm hã na akarha unga awuma na agɛ, <<Niba agũmbi ighong. Awu nggu urhɛnga!>> ");
INSERT INTO ldb_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mɔcɛ unga abvui afũã ni iya afã. Unga atsɔku uborodi, atãi, na adɛ̃ɛ̃nga arherhe utsɛku ukpe uku usar, unga azĩã. ");
INSERT INTO ldb_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Umbɔ akũ ungwɛ̃dzɛm hã azĩmbɔ nggu urhɛnga, na akpo idɔngamɛn akarhãrhã. ");
INSERT INTO ldb_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Umɛn iso izĩmɛn ru ukhukhɔɔ amɛ̃, umɛn idzur udĩ izĩmɛn Uassu. Umɛn itsar ishupu Uburhu umɔ, ubinkutsu unga avarhe rimi ri inggbaashia, unga aka azɛ̃rhã na adak azĩ. ");
INSERT INTO ldb_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Unga aka akpo umɛn ru Uassu, umɛn ishupa unga izĩmɛn Umitirhen. ");
INSERT INTO ldb_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Unum uvaa umɛn izɛ̃rhã ru ukhukhɔɔ ĩba itɔng ifɛn Ukiyo. Unum untaar ikɛi umɛn igar izĩ Usamo, unum unaa umɛn itsĩ ru Umirhetu. ");
INSERT INTO ldb_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Uburhu asi ibeenga itsĩ ru Uafisa utsur ivanga imaangge ru Uasiya, azang abee itsĩ ru Urusharhima, ngge iba imɛ̃ngge, ru unum irhowu Upentiko. ");
INSERT INTO ldb_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Awu ru Umirhetu, Uburhu aka ayisa akakũ ri ikikɔng abika adɔsa ru Uafisa. ");
INSERT INTO ldb_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ivangyɛ umbɔ aka aba atsĩ, unga agɔr umbɔ agɛ, <<Umbi ahwɛngmbi ikpũ isiseimum ri ivanga kishoo umum iki iwu nggu umbi, udzur ru unumkpi umum iki itsĩ ra abĩ Uasiya. ");
INSERT INTO ldb_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Umum itɔ̃ itser Uteijee nggu ididɔɔr akarhãrhã nu anyĩ. Nu ngge iki iwe ugɛ abi Uyahuda atsu umum ayetnum nggu andeya. ");
INSERT INTO ldb_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Umbi ahwɛngmbi umum isi ibvurmum angwĩ ri ĩdzaa umbi kishoo isarhayɛ iki iyika umbi bɔr umum imesuwa umbi ra ayambi nu awiya ikɛi. ");
INSERT INTO ldb_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Umum isɛmmum abi Uyahuda nu atsen abi Uyahuda ugɛ awu ufang umbɔ adzipa aba ru Unum na atsu amɛnmbɔ ru Uteijeemɛn Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","<<Nu icɛrɛ, Ipfu-Numyɛ iki iyira umum iwuri izĩ Urusharhima, isi ihwɛng ubinkpi iki ikorhe nggu umum umɔ. ");
INSERT INTO ldb_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Umum ikpurhi ihwɛng ugɛ ubɛn uteu Ipfu Isarsatangge iki igbiitangge atomum ugɛ ugborzĩ nu uver ukpɔ udzɛu umum. ");
INSERT INTO ldb_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Bɔr umum isi inyã urhɛmum uwekpɔ ubin. Umum ikpurhi ibee imaa itseryɛ Uteijee Uyesu aka adzaa umum, idekuwe arherhe Isarhe Iyiki Ize iyi imimutu Unum. ");
INSERT INTO ldb_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","<<Icɛrɛ umum ihwɛng ubɛn unera ru umbi umum iki izɛ̃rhã idũwã isarhe Iyɛrhe Unum, asi ínyãã asumum ikɛi. ");
INSERT INTO ldb_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nggee, umum idɛyiwa umbi irherɛ ugɛ, umum ishimum ru uvau adzirh anera kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ubinkutsu, umum isi ibvurmum angwĩmum ri isɔma umbi kishoo abinkɛ Unum aka abee. ");
INSERT INTO ldb_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Àka adzɛu atsimbi nu kishoo ukpui abika adɔsa, Ipfu Isarsatangge iki itsũ umbi awu anggbaashimbɔ. Àka adzɛu abika adɔsu Unum, abirabɛ unga aka akũ adzirh Ungwɛ̃nga agoi. ");
INSERT INTO ldb_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Umum ihwɛngmum ĩba isokũ, íjui ngbako iwuri itsĩngge ru umbi isi ínekũngge ukpui idɔi ha. ");
INSERT INTO ldb_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Abɔɔ ru umbi asok adɛ̃ɛ̃ idzidzunuwe idzidzɛrhe ha abee igbiir amɛn angwɛ̃ imesa azĩ ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Nggee àka adɛ̃ɛ̃ adzɛu! Àka ayita ugɛ imɛka itaar nu utsuu na atenum umum isi ibvurmum angwĩmum ri isɛm umbi kishoo nggu anyĩ. ");
INSERT INTO ldb_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","<<Icɛrɛ umum iyɛruwe umbi ru Unum. Àka aneke urhɛm imimutanga ngge idɛ̃ɛ̃ idzin umbi ni idzaa umbi ukam ru abirabɛ aka awe asarkasar kishoo. ");
INSERT INTO ldb_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Umum inasi igũmum unyɛ̃ɛ̃ uhwɛk unera use atorhanga. ");
INSERT INTO ldb_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Umbi nibikambi ahwɛngmbi umum ikũ abokmum itɔ̃ itser ifai itsũwãmum nu iyi abirabɛ aka awu nggu umum. ");
INSERT INTO ldb_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ra abina kishoo umum iki ikorhe, umum idɛyiwa umbi ugɛ awu ufang umbi atɔ̃ ikpũ itser iyiki itso ha ayike abika asheri iker, na ayita Arherhu Uteijee Uyesu aka agɔr agɛ, <Idzidzowe iwe ru idorh inangngge iyiyɛi.> >> ");
INSERT INTO ldb_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ivangyɛ unga aka irherhe rimi, unga atararhu nggu umbɔ kishoo na afɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Umɔ umbɔ kishoo aciu akpe na awumu Uburhu na ashor unga. ");
INSERT INTO ldb_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ubinkpi uku utsu amɛnmbɔ aghong akarhãrhã, awu arherhakɛ unga aka arherhe ugɛ umbɔ asi íbvui anyãmbɔ asunga ikɛi. Mɔcɛ umbɔ azĩ adene unga nu ukhukhɔɔ amɛ̃. ");
INSERT INTO ldb_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ivangyɛ umɛn iki ibɔre umbɔ, itsĩ ukhukhɔɔ amɛ̃ izĩmɛn Ukosi. Unum uvaa umɛn izĩmɛn Urod, idzek umɔ izĩmɛn Upatara. ");
INSERT INTO ldb_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Umɛn iki ikpo ukhukhɔɔ amɛ̃ uwuku uzĩ abĩ Ufinikiya, umɛn itsĩ izĩmɛn. ");
INSERT INTO ldb_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Umɛn iki itirhi inyã Usayifuru, umɛn itɔng udiku unɔrmgbɔ, umɛn izĩmɛn Usuriya. Umɛn icipa ru Utaya, ubinkutsu ru ukhukhɔɔ amɛ̃ umɛn ucipuwe abinke. ");
INSERT INTO ldb_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Umɛn iki ikpo angwɛ̃ imesa umɔ, umɛn isei umɔ inuma utɔɔva. Mɔcɛ ru ubok Ipfu-Num umbɔ adɛyiwe Uburhu unga niba azĩã Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Bɔr ivang iyiki isisokmɛn iki iwe, umɛn iso idɛ̃ɛ̃mɛn uzɛ̃rhãmɛn. Angwɛ̃ imesa kishoo nu atsɛ̃mbɔ nu awɛkacimbɔ akũna umɛn azĩ adena nu undzing utepa. Mɔcɛ umɛn iki itar arhu nu ubang ukau ukugɔng ni ifɛn-Num. ");
INSERT INTO ldb_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Umɛn ighwe unuma ra adɔka imaa ni itsĩ ukhukhɔɔ amɛ̃, umbɔ abvui azĩmbɔ ra ayambɔ. ");
INSERT INTO ldb_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Umɛn itsĩmɛn uzɛ̃rhãmɛn idzeku Utaya, itsĩmɛn Utorhemayi, umɔ umɛn iki ighwe ighwe nggu angwɛ̃mɛn nu anapumɛn, umɛn imaa unuma unying nggu umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Unum uvaa umɛn isok izĩmɛn Ukaisariya. Umɛn itsĩ isei ri iya Ufirhibu uwuku udzowe Isarhe Iyiki Ize, unying ru umbɔ utɔɔva ha umbɔ aka asɛng umbɔ ayike abi itser ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Unga awu ra anakatsɛrh anaa aka anasi ipfunumbɔ awu abika asɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Umɛn iki imaa inum iyɔɔ umɔ, uwuku usɔm Arherhu-Num itsoka igburh Uagabu, adzeka abĩ Uyahudiya aba atsĩ. ");
INSERT INTO ldb_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Unga aka aba atsĩ, unga anyangu ikpɔm Uburhu, abow adaknga na aboknga na agɛ, <<Ubinkpi Ipfu Isarsatangge iki igɔr igɛ, <Riminɛ anggbaashi abi Uyahuda ru Urusharhima aka ibow uner ikpɔm iyɛrɛ, na atsuke unga ra abok Atsen abi Uyahuda.> >> ");
INSERT INTO ldb_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ivangyɛ umɛn iki igũ rimi, umɛn nu abi anang hã ishɔ̃rhũ Uburhu unga niba azĩã Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mɔcɛ Uburhu agɛ, <<Awu use utsu umbi aciu na adakuwe amɛnmum? Umum iki igbishi imaamum, ibibow ukpekũ isi iwengge ubin, bɔr afɛre umum ru Urusharhima ri itsok Uteijee Uyesu.>> ");
INSERT INTO ldb_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Umɛn iki isi idɛ̃ɛ̃ ikɛnmɛn unga, umɛn inumɛn ukutata, ni ĩgɔr igɛ, <<Uneke ibibemu Uteijee iwe.>> ");
INSERT INTO ldb_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Akɛrɛ ha aka amaa umɛn ingbika abinmɛn izĩmɛn Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Angwɛ̃ imesa abɔɔ adzeku Ukaisariya aba adena umɛn, akũna umɛn azĩmbɔ ru Umanason, uwuruwi umɛn iki icipa ri iyanga. Unga awu uner Usayifuru unying ra angwɛ̃ imesa abi inggbaashia. ");
INSERT INTO ldb_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ivangyɛ umɛn iki itsĩ Urusharhima, angwɛ̃mɛn nu anapumɛn ayɛi umɛn nggu ibibema. ");
INSERT INTO ldb_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Unum uvaa Uburhu nggu umɛn izĩmɛn inyã Uyaku, nu kishoo akakũ awu umɔ. ");
INSERT INTO ldb_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Uburhu aka aghwe umbɔ amaa, unga adɛyiwe umbɔ agbɛgbɛra agbɛra abinkɛ Unum aka akorhuwe Atsen abi Uyahuda ru ubok itseryɛ unga aka atɔ̃. ");
INSERT INTO ldb_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Umbɔ aka agũ rimi amaa, umbɔ akpoi Unum, na agɔr Uburhu agɛ, <<A ungwɛ̃mɛn, urhi unyã, irhɛ anaka agɔnga abi Uyahuda asong abika awe ru imangmang! Kishoo atsu amɛnmbɔ ri idɔsi Íkpem! ");
INSERT INTO ldb_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Aka asɔmukumbɔ arherhango, ugɛ ungo umesuwe kishoo abi Uyahuda abika asei ra atsen abi Uyahuda umbɔ aneke Íkpem Umusa, ungo ugɔr umbɔ ugɛ, umbɔ niba asorhukumbɔ usorhe ra awɛkacimbɔ, use adɔsa agbeyi abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Umɛn ikorhu ugusemɛn? Nggayɛ umbɔ awuri igũmbɔ agɛ ungo uku ubango. ");
INSERT INTO ldb_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Nggee ukorhu ubinkpi umɛn iki idɛyiwa ungo, inera niyɔ inaa iwu nggu umɛn aka ayirh uyirh. ");
INSERT INTO ldb_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Utsĩ ra anera abɛrɛ, uzĩ umbɔ asare umbi ivanga unying ru ungo ufai uhwɛkmbɔ, ngge itsú umbɔ akone atsimbɔ. Rimi hã itsu ubɛn unera awuri ihwɛngnga ugɛ kishoo abinkɛ umbɔ aka arherhe ri itsingo asi iweke idzidzɛrhe, bɔr awuri inyĩnyãmbɔ ungo uku udɔsi Íkpem. ");
INSERT INTO ldb_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Atsen abi Uyahuda abika awe ru imangmang, umɛn iki itsɛng abvur idɛyiwe umbɔ ugɛ umɛn ibee umbɔ niba aghambɔ ubinkpi umbɔ aka ayɛruwe ru agberhe, use adzirh, asi ítãimbɔ ijuɛyɛ umbɔ aka ashĩrhũ urhɔkngge, asi ítomumbɔ-dak.>> ");
INSERT INTO ldb_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Unum untaar Uburhu akũna anera abɛrɛ umbɔ asare unga nggu umbɔ. Mɔcɛ unga atsĩã ri Iya-Num, adɛyiwe abika adzowe idɛm-Num unumkpi uku utsufɛr isisarmbɔ. Ru unum hã ubɛn unera ru umbɔ aka idzowe izũwũ idɛm. ");
INSERT INTO ldb_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Inuma utɔɔva ha iki iyo imimaa, abi Uyahuda abɔɔ aka adzeka abĩ Uasiya anyã Uburhu ri Iya-Num. Umbɔ ahwita anera ri ikikɔnga kishoo umbɔ adzur unga. ");
INSERT INTO ldb_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Atsu ivum agɛ, <<Umbi aner Uisrairha, àka ayika umɛn! Uner ha nuwi aki azɛ̃rhã amesuwe anera kishoo awe ru igamtsa ra anermɛn nu Íkpemmɛn nu anang akɛrɛ. Asi iwea akɛrɛ ha ukpekũ, bɔr unga aka akũ Atsen abi Uyahuda abɔɔ atsĩwã ru ufɔm Iya-Num aba atsuke arhim ru usarkasar anang akɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Umbɔ agɛ iwe rimi umbɔ aka anyãmbɔ Uburhu nggu Uturofimu, uner Uafisa, ru utepa. Umbɔ akaifɛrhkɔ agɛ Uburhu unga akũna unga atsĩ ru ufɔm Iya-Num. ");
INSERT INTO ldb_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Uteu ha kishoo udzunukpɔ, anera asok atĩ aba akɔng. Azĩ adzur Uburhu, agbĩrhã unga adzek ru ufɔm Iya-Num, umbɔ afɔmukumbɔ angwĩ ufɔma kanying. ");
INSERT INTO ldb_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Abee ifɛre unga nukpi, mɔcɛ isarhe izĩ itsĩngge ru ukugɔng abi iwa Uroma igɛ Urusharhima kishoo uku udzunukpɔ. ");
INSERT INTO ldb_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kanying unga akarha abi iwa Uroma na ateiyambɔ, atĩ azĩmbɔ ri ikikɔnga. Ivangyɛ anera aka anyã ukugɔng nu abi iwanga, umbɔ anekukumbɔ ikwɛr Uburhu. ");
INSERT INTO ldb_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ukugɔng abi iwa ha aba adzur Uburhu atsu umbɔ abow unga nggu inyãwã ivaa. Mɔcɛ na arhusa agɛ, <<Unga awu ungamɔ, na akorhu use?>> ");
INSERT INTO ldb_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ikikɔnga itsuyi ivum igwarha arherhe, abɔɔ agɛ akɛrɛ abɔɔ agɛ akɔrɔ. Uteiya abi iwa ha aka asi idɛ̃ɛ̃ adzura usu arherhe ha igwarha arherhe irhɛngge, unga atsu umbɔ akũ Uburhu azĩmbɔ aya abi iwa. ");
INSERT INTO ldb_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ivangyɛ Uburhu aka aba atsĩ ru abeu angwĩ iyaa, abi iwa ashupa unga, umbɔ aka anyã anera abee ifɛre unga. ");
INSERT INTO ldb_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Ikikɔng anera iki idɔsa umbɔ inũ itsuyi ivum igɛ, <<Afɛre unga, afɛre unga!>> ");
INSERT INTO ldb_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Umbɔ aka akũ Uburhu ayo itsĩ ra aya abi iwa, unga ashɔ̃rhã ukugɔng abi iwa ha agɛ, <<Kabɔɔ ungo uma uneka umum irherha arherhe nggu ungo?>> Unga agɔr unga agɛ, <<Ungo uhwɛngo idũ abi Uherhini? ");
INSERT INTO ldb_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Asi iwea ungo uwu utsa Umasar ha isha uwuku ukũ isoyamɛn uba akũ anera anaka agɔng anaa abika afɛr aner ukũ azĩ ra arhum?>> ");
INSERT INTO ldb_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Uburhu agɔr unga agɛ, <<Umum iwu utsa Uyahudiya, idzeku Utarsu ra abĩ Ukirhikiya, umum iwu ungwɛ̃ undzumu uteu ukugɔng. Kabɔɔ uma uneka umum irherha arherhe nggu anera abɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Unga aka aneke unga arherhe, Uburhu adɛ̃ɛ̃ nu abeu ha aberu uboknga ra anera umbɔ anu ukutata. Umbɔ aka anu ukutata, unga arherhe arherhe nggu umbɔ ri idũ abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Uburhu agɛ, <<Umbi angwɛ̃mɛn nu atesmɛn, àka akpeto ru umum ikaa itsimum.>> ");
INSERT INTO ldb_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ivangyɛ umbɔ aka agũ unga arherhewe umbɔ ri idũ abi Uyahuda, umbɔ agbisha anu ukutata. Mɔcɛ Uburhu agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","<<Umum iwu utsa Uyahudiya. Amar umum ru Utarsu ra abĩ aki Ukirhikiya, bɔr akpɔm umum ru utepu ukpirɛ. Umum itsĩ imesa ru ubok Ugamarhiyerh. Amesuwa umum abina kishoo aki Íkpem atokamɛn. Umum iwemum ri itsu amɛn ri idɔsu Unum, ru nyaka umbi kishoo aki ikorhe irherɛ. ");
INSERT INTO ldb_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Idzowukũ uver ra abika adɔsu utsĩndĩ uwirɛ, ifɛyiwe umbɔ, idzui akatsak nu akatsɛrh itsuyikumum umbɔ ru ugborzĩ, ");
INSERT INTO ldb_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ru nyaku Ukugɔng Uwuku Udzowe Idɛm-Num nu ikikɔng akakũ abi Uyahuda kishoo aka iwu idekamum. Umum iyɛisũ abvur ru umbɔ iwuri ikũ izĩ ru abimbɔ ru Udimashku. Umum izĩ umɔ ibee idzui abirabɛ aka adɔsu utsĩndĩ uwurɛ ikũ iba Urusharhima, umbɔ adzowe umbɔ ayetnum. ");
INSERT INTO ldb_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","<<Umum iwu ru uzɛ̃rhã, iki iyokũ itsĩ Udimashku ra atenuma, kanying nggaa irhirhang ra afã irhang idzipa umum. ");
INSERT INTO ldb_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Umum ĩgba inũ nu abĩ ni igũ urhɛm uku ugɔr umum ugɛ, <A Ushawurhu! A Ushawurhu! Awu use utsu ungo udzaa umum uver?> ");
INSERT INTO ldb_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","<<Umum irhusa inggɛ, <Awu ungo ungamɔ Uteijee?> <<Mɔcɛ urhɛm hã ugɔr umum ugɛ, <Awu umum Uyesu uner Unazarat uwuruwi ungo uku unu idzowe uver.> ");
INSERT INTO ldb_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Abirabɛ aka awu nggu umum anyãmbɔ irhirhang hã, bɔr asi igũmbɔ urhɛm hã uku unu arherhe nggu umum. ");
INSERT INTO ldb_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","<<Nggee umum irhusa inggɛ, <A Uteijee, umum ikorhi uguse?> <<Mɔcɛ Uteijee agɔr umum agɛ, <Usisok, utsĩ ru Udimashku. Umɔ umbɔ aka idɛyiwa kishoo ubinkpi umum iki itsu ungo ikorhe.> ");
INSERT INTO ldb_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Iker irhirhang hã iki itsu umum itapa, abirabɛ aka awu nggu umum akpɔm abokmum adarh umum atsĩ Udimashku. ");
INSERT INTO ldb_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","<<Utsa uwɔɔ agburh Uhananiya aba inyã umum. Awu uner uwuku udzowe itsinga idɔsu Unum ri Íkpem Umusa, abi Uyahuda kishoo abika awu umɔ aka isaka adzowe unga igɔng. ");
INSERT INTO ldb_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Unga aba adɛ̃ɛ̃ akhapa ru umum agɔr umum agɛ, <A ungwɛ̃mɛn Ushawurhu, ukpo inyã anang!> Kanying asumum ayanga, umum idɛ̃ɛ̃ inyã unga. ");
INSERT INTO ldb_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","<<Mɔcɛ unga agɛ, <Unum uwu atokamɛn asɛng ungo, ungo uhwɛng amɛnnga, nu unyã Uner Uwuku Urhurhika ha nu ugũ urhɛm ra angwĩnga. ");
INSERT INTO ldb_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ubinkutsu ungo uwuri iwu idekanga ru ubɛn unera, ru ubinkpi ungo uku unyã nu ugũ. ");
INSERT INTO ldb_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Icɛrɛ ungo udzɛu use? Usisok, usorhu ubɔtisima, nu usorh arhimngo adzek ri ifɛn ri itsoknga.> ");
INSERT INTO ldb_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","<<Umum iki ibvui iba Urusharhima iwe ri ifɛn-Num ru ufɔm Iya-Num, umum inyã irhi ");
INSERT INTO ldb_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ni inyã Uteijee aka arherhe nggu umum agɛ, <Ifetem! Udzekɔ ru Urusharhima kanying, ubinkutsu, umbɔ asi íyɛimbɔ idekango ri itsimum.> ");
INSERT INTO ldb_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","<<Umum igɔr ugɛ, <A Uteijee, umbɔ nibikambɔ ahwɛngmbɔ umum iki itsĩrhã abã ifɛn-Num itsuke abika awe ru imangmang ru ungo, ru ugborzĩ na ikwɛre umbɔ ugwɛɛ. ");
INSERT INTO ldb_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nu ivang umbɔ aka ifɛr Uistifanu uwu idekango, umum nibikami idɛ̃ɛ̃ umɔ, umum iwu ru undzingmbɔ ru ubinkpi umbɔ aka akorhe, awu umum idzɛu atorho abika afɛr unga.> ");
INSERT INTO ldb_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","<<Mɔcɛ Uteijee agɔr umum agɛ, <Uso uzĩ, umum iwuri idena ungo uzĩ nggɔɔ ra anang akika ader ra atsen abi Uyahuda.> >> ");
INSERT INTO ldb_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ikikɔnga ikpeto ru Uburhu utsɛku unga aka arherhe akɛrɛ. Mɔcɛ umbɔ atsarhi irhakmbɔ atsui ívum agɛ, <<Afɛre ikpũ uner uwurɛ! Isi imɛ̃ngge unga abɛk!>> ");
INSERT INTO ldb_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Umbɔ aka atsuyi ívum atsimuwe antamambɔ atãyĩwe, asoyi uzurhu ru ugba. ");
INSERT INTO ldb_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ukugɔng abi iwa ha atsu umbɔ akũ Uburhu azĩmbɔ ru aya abi iwa. Atsu umbɔ akwɛre ugwɛɛ, abee unga asɔm ubinkpi uku utsu ikikɔnga itsuyiwe unga ivum rimi. ");
INSERT INTO ldb_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Umbɔ aka agbiir aboknga abow na abee ikwɛr unga, Uburhu agɔr uteiya abi iwa aka adɛ̃ɛ̃ akhapa umɔ agɛ, <<Imɛ̃ngge ungo ukwɛre ugwɛɛ ru uner Uroma umbɔ aka anasi itsu umbɔ uvau ru unga?>> ");
INSERT INTO ldb_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ivangyɛ uteiya abi iwa ha aka agũ rimi, unga azĩ ru ukugɔng hã azĩ agɔr unga agɛ, <<Ungo ubee ikorhu uguse? Utsak uwurɛ awu uner Uroma.>> ");
INSERT INTO ldb_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ukugɔng hã aba agɔr Uburhu agɛ, <<Usɔma umum idzidzɛrhe, ungo uwu uner Uroma?>> Uburhu agɔr agɛ, <<Ĩĩ.>> ");
INSERT INTO ldb_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mɔcɛ ukugɔng hã agɛ, <<Umum ikũ uhwɛk urhɛrhɛ ikpo iwe uner Uroma.>> Uburhu agɛ, <<Umum iwu undzumu ungwɛ̃ Uroma.>> ");
INSERT INTO ldb_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Abika abee irhusa unga urherhe abvui azĩmbɔ ra andzing kanying. Ukugɔng hã aka ahwɛng agɛ Uburhu awu uner Uroma, iwei ifɛr unga, nggayɛ unga aka abowpa unga. ");
INSERT INTO ldb_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Unum uvaa, ukugɔng hã abee ihwɛng ubinkpi Uburhu aka ikorhuwe abi Uyahuda umbɔ atsu arherhanga. Unga agarhuwe abok Uburhu na atsu ateiya abika adzowe idɛm-Num nu abi udzepurhe abi Uyahuda kishoo akɔng. Mɔcɛ unga akũ Uburhu aba adɛ̃ɛ̃ ra asumbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Uburhu arhi abi udzepurhe ha ra asumbɔ na agɛ, <<Umbi angwɛ̃mɛn, umum iki itɔ̃ itsermum ĩba itsĩ irherɛ ra amɛn aka aze kishoo ra asu Unum.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Akɛrɛ ha atsu Uhananiya Ukugɔng Uwuku Udzowe Idɛm-Num, atsu abika adɛ̃ɛ̃ ayo nggu Uburhu akwɛr unga nu angwĩnga. ");
INSERT INTO ldb_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Mɔcɛ Uburhu agɔr unga agɛ, <<Unum unga awuri ikwɛr ungo, uner ukpukpeta! Ungo usei nu utsu umum uvau ri idɔsi Íkpem Umusa, bɔr ungo nibikango uzharhukɔ Íkpema ungo uku utsu umbɔ akwɛr umum.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Abirabɛ aka adɛ̃ɛ̃ akhapa ru Uburhu agɔr unga agɛ, <<Ukugɔng Uwuku Udzowe Idɛm-Num ungo uku urhena?>> ");
INSERT INTO ldb_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Uburhu agɛ, <<Umbi angwɛ̃mɛn, umum isi ihwɛng unga aka awu Ukugɔng Uwuku Udzowe Idɛm-Num. Ubinkutsu itsɛng Arherhu-Num igɔrngge ugɛ, <Niba arhenumbɔ uyɛrhe.> >> ");
INSERT INTO ldb_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ivangyɛ Uburhu aka anyã ugɛ abɔɔ awu abi Usaduki, abɔɔ ikɛi awu abi Ufarisi, unga atsarhi irhaknga ru udzepurhe ha agɛ, <<Umbi angwɛ̃mɛn, umum iwu uner Ufarisi, ungwɛ̃ Ufarisi. Umum idɛ̃ɛ̃ umbɔ avarhuwa umum arherhe ri itsi umum iki ifosa ugɛ abika akpe awuri isok ra akpe.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ivangyɛ unga aka arherhe akɛrɛ ha, uning usomgbɔ ra abi Ufarisi nu abi Usaduki, ikikɔnga igashungge. ");
INSERT INTO ldb_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Abi Usaduki awembɔ ri imangmang ugɛ isok ra akpe ishingge, ípfu itser-Num ishingge use ípfu ishingge. Abi Ufarisi awembɔ ri imangmang ugɛ kishoo aweke. ");
INSERT INTO ldb_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Isoyamɛn igɔigɔng isongge. Abɔɔ abika amesuwe Ikpem ru ukpui ukpu Ufarisi asok adɛ̃ɛ̃ uning akarhãrhã agɛ, <<Umɛn isi ikpomɛn utsak uwurɛ nggu uvau. Ungaa ahwɛng, use awu ipfu use ipfu itser-Num irherha arherhe nggu unga?>> ");
INSERT INTO ldb_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Uning utsotsoramgbɔ uku usoyi, ukugɔng abi iwa ha agũ iwei ugɛ utsur umbɔ ashakukumbɔ Uburhu. Unga atsu abi iwa ha acipa avur Uburhu ri inggang akũ azĩmbɔ aya abi iwa. ");
INSERT INTO ldb_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Utsuu uku ufin, Uteijee adɛ̃ɛ̃ akhapa ru Uburhu, na agɛ, <<Uker amɛnngo! Ru nyaka ungo uku udzowe idekamum ru Urusharhima, nggee awu ufang ungo iki idekuwe umum ru Uroma.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ukpee unum uvaa, abi Uyahuda akɔng avarhe ifɛre Uburhu ayirh uyirh ugɛ umbɔ asi íghambɔ asi íhwambɔ ubin, utsɛku umbɔ aka ifɛr Uburhu. ");
INSERT INTO ldb_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Anang umbɔ isɔka inaa umbɔ aka avarhi ikorhe iyiki ibewe ha. ");
INSERT INTO ldb_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Umbɔ asok azĩmbɔ ru ateiya abika adzowe idɛm-Num nu akakũ anera, na agɛ, <<Umɛn iki iyirh nggaa uyirh, igɛ umɛn isi íghamɛn ubin utsɛku umɛn iki ifɛr Uburhu. ");
INSERT INTO ldb_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nggee, umbi nggu abi udzepurhe, àka adene itser umbɔ adɛyiwe ukugɔng abi iwa ha, umbɔ akũna unga akũwã ru umbi, àka akpeta ugɛ umbi abee ibvui arhusa arherhanga hã agũni ikɛi. Umɛn iki igbishi imaamɛn, umɛn iwuri ifɛre unga, unga adɔrha aba atsĩ.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Bɔr ungwɛ̃ unapumbɔ Uburhu aka adɛ̃ɛ̃ na agũ arherhe aka abewe ha, unga atsĩ ru aya abi iwa asɔmuka Uburhu. ");
INSERT INTO ldb_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Mɔcɛ Uburhu ayisu unying ra ateiya abi iwa Uroma agɛ, <<Ukũ ungwɛ̃dzɛm uwurɛ uzĩ ru uku ugɔngmbi, abee idɛyiwe unga ubin ukpɔɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Nggee uteiya abi iwa Uroma ha akũ ungwɛ̃dzɛm hã azĩã ru uku ugɔngmbɔ na agɛ, <<Uburhu uwɔrɔ ru ugborzĩ ukpɔrɔ, ayisa umum ugɛ, umum ikũ ungwɛ̃dzɛm uwurɛ iba ru ungo, ubinkutsu unga awuri isɔma ungo ubin ukpɔɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ukugɔng hã adzur ubok ungwɛ̃dzɛm hã, akũna unga azĩã ri ifɛna arhusa unga ikiyikanga agɛ, <<Ungo ubee isɔma umum use?>> ");
INSERT INTO ldb_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Unga agɛ, <<Abi Uyahuda abee igɔr ungo ukũ Uburhu uzĩ ru udzepurhe udã, akpeta ugɛ umbɔ abee igbisha arhusa arherhe Uburhu. ");
INSERT INTO ldb_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Bɔr niba ubemukɔ, ubinkutsu inera itɔngngge isɔka inaa iki iwoi adzɛu unga. Aka ayirhmbɔ ugɛ umbɔ asi íghambɔ ubin utsɛku umbɔ aka ifɛre unga. Icɛrɛ umbɔ adzɛu ibibemango ukpekũ.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Nggee ukugɔng hã adene ungwɛ̃dzɛm hã azĩã, na agbiite atonga agɛ, <<Niba udɛyikɔ unera ugɛ ungo uku usɔmango umum arherhe akɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Mɔcɛ unggbaashi ha ayisa ateiya abi iwa Uroma avaa agɔr umbɔ agɛ, <<Àka agbisha abinmbi, umum idena umbi azĩ Ukaisariya ra akara utɔɔrha aki utsuu irherɛ, nggu abi iwa inaka ivaa, nu abi iwa abɔɔ isɔka utɔɔva abika afũ inyãwã, nu abi iwa inaka ivaa abika atang iwa nggu asawa. ");
INSERT INTO ldb_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Àka akpowe ínyãwãyɛ Uburhu aka ifũ, umbi afɔrh unga akũ azĩ ru ugomna Uferhi.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Unggbaashi abi iwa ha atsɛng ubvur riminɛ agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Udzeku Ukarhaudiya Urhisiya, Uzĩ ru nggaa uner uwuku ugɔng ugomna Uferhi, Umum ighwe ungo. ");
INSERT INTO ldb_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","<<Uner uwurɛ abi Uyahuda adzur unga abee ifɛre unga, umum iso nggu abi iwamum umɛn ifɔrhe unga, ubinkutsu umum igũ unga awu utsa Uroma. ");
INSERT INTO ldb_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Umum iki ibee igũ uvauwi uku utsu umbɔ atsu arherhanga, nggee umum ikũna unga izĩ ru udzepurhembɔ. ");
INSERT INTO ldb_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Umum igũ umbɔ arhena unga ra arherhe íkpemmbɔ, bɔr umum isi ikpomum unga akorhunga ubinkpi uku utsu akpe use ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ivangyɛ umum iki ĩgũ iyiki ibeweyɛ umbɔ aka atsar ikorhe nggu utsa ha, kanying umum idene umbɔ akũ unga aba ru ungo. Ikɛi umum itsu abika atsu arherhe ri itsinga umbɔ aba asɔm ubinkpi umbɔ aka anyã unga akorhe ra asungo.>> ");
INSERT INTO ldb_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Nggee abi iwa, atɔ̃ itsermbɔ ru nyaka umbɔ aka atsuke, akũ Uburhu azĩmbɔ Uantifatiri nu untsuuka. ");
INSERT INTO ldb_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Unum uvaa abi iwa abika afũ inyãwã akũna unga azĩmbɔ ra asu, ra abɔɔ abvui azĩmbɔ ru aya abi iwambɔ. ");
INSERT INTO ldb_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Abi iwa abika afũ inyãwã aka azĩ atsĩ Ukaisariya, umbɔ adzowe ubvur ha ru ugomna, na atsuke Uburhu ru uboknga. ");
INSERT INTO ldb_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ugomna hã aka avarhu ubvur ha na arhusu Uburhu ugɛ unga adzek udika abĩ akasong. Unga aka agũ agɛ Uburhu adzeka abĩ Ukirhikiya, ");
INSERT INTO ldb_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","unga agɛ, <<Umum iwuri ĩgũmum arherhango, ri ivang abika atsu arherhe ri itsingo aka iba.>> Mɔcɛ unga atsu umbɔ adzɛu unga ru udzepurhe iyɛrhe Uhiridu aka adzin. ");
INSERT INTO ldb_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Inuma itɔ̃ɔ̃ iki imaa Ukugɔng Uwuku Udzowe Idɛm-Num Uhananiya azĩ Ukasariya nggu akakũ abɔɔ nu urhoya uwɔɔ itsoka igburh Utarturhu, atsu arherhe Uburhu ru ugomna. ");
INSERT INTO ldb_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ivang umbɔ aka ayisu Uburhu atsĩ, urhoya Utarturhu atsu arherhe Uburhu ra asu ugomna Uferhi agɛ, <<Awu itsoingo itsu umɛn igũibɛn ididɔɔr iyiki ider, ikɛi ihwihwɛng iyi unuma itsu igbigbisha iba ra abĩmɛn. ");
INSERT INTO ldb_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ra afɛna kishoo nu inanga, a uteiya Uferhi, umɛn itar uwɛɛ urhɛrhɛ ru ungo. ");
INSERT INTO ldb_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Bɔr umum isi ĩbeemum igha ivangngo, umum ishɔ̃rhã ungo uma udɔng amɛnngo ukpeto ru umɛn ukunjiir. ");
INSERT INTO ldb_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","<<Umɛn ikpo utsak uwurɛ awu uner uwuku utsuyi ifuw, anu ikũ isoyamɛn atsĩwã ra abi Uyahuda ru ubɛn ananga ru upfung. Unga awu unggbaashi agbeyi abi Unazarat. ");
INSERT INTO ldb_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","8","Abee itsu arhim ri Iya-Num, nggee umɛn idzur unga. Ungo uba urhusungo unga nibikango, ungo uwuri igũo idzidzɛrhe kishoo ubinkpi umɛn iki irherhe ri itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Abi Uyahuda awu ru undzing akɛrɛ ha, agɔr ugɛ ífɛrha ha iwu idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ivangyɛ ugomna aka adzowe unga ijee arherhe Uburhu agɛ, <<Umum ikaa itsimum nggu itɛnamɛn ubinkutsu umum ihwɛng ungo uku umaa imɛka irhɛirhɛ ungo uku uvarhuwe arherhe ra abĩ akɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ungo uba ugbishu urhisɔ, ungo ihwɛngngo ugɛ anasi itɔnga inuma usɔkdũmɛn umum iki izĩ ĩzdowe igɔng ri Iya-Num ru Urusharhima. ");
INSERT INTO ldb_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Abika atsu arherhamum asi ikpombɔ umum idɛ̃ɛ̃mum uning nggu unera ri Iya-Num, use isoyiwe amɛn anera ra abã ifɛn-Num, use ra anang akɔɔ ru utepa. ");
INSERT INTO ldb_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Asi ídɛ̃ɛ̃ adɛyiwambɔ ungo ubinkpi umbɔ aka akũ atsu arherhamum. ");
INSERT INTO ldb_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Bɔr umum isɔma ungo ra awiya, umum idzowe igɔng ru Unum uwu atokamɛn ru Utsĩndĩ hã, umbɔ aka ayisa ukpui uku ukpɛ̃. Bɔr umum iwemum ri imangmang ri kishoo abinkɛ aka awe ri Íkpem Umusa nu ru abvur abika asɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ififosamum ru Unum iwu unying nggu anera abɛrɛ, ugɛ abika arhurhika awuri isok ra akpe nu abika ada irhirhika. ");
INSERT INTO ldb_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ngge itsu ubɛn ivang umum inũ itsu amɛnmum uku ushashaki ra asu Unum nu unera. ");
INSERT INTO ldb_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","<<Imɛka irhɛrhɛ iki imaa, umum ibvui iba Urusharhima ikũ ízũwã abin ĩba indzowe anera ayike atsũwãmɛn, ni indzowe ídɛm-Num. ");
INSERT INTO ldb_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Umum iki imaamum isare itsikammum ivangyɛ abɛrɛ ha aka aba akpo umum ru ufɔm Iya-Num. Isi iwemum ri ikikɔng anera, isi isoyikũ amɛn anera. ");
INSERT INTO ldb_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Bɔr abi Uyahuda rabɔ adzeka abĩ Uasiya, awu umɔ, imɛ̃ngge umbɔ aba ra anangngo aba atsu arherhamum umbɔ aba awembɔ ra arherhe nggu umum. ");
INSERT INTO ldb_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Use ungo uneke anera abɛrɛ asɔm uvauwi umbɔ aka akpo ru umum ivangyɛ umum iki idɛ̃ɛ̃ ra asu abi udzepurhe. ");
INSERT INTO ldb_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Arherhambɔ awu unying ukpekũ umbɔ aka itsu umum uvau, umum iki itsarhi irhakmum ra asumbɔ ĩgɔr inggɛ, <Awu arherhe isisok ra akpe umbɔ aka avarha arherhamum ra asumbi irherɛ.> >> ");
INSERT INTO ldb_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Mɔcɛ Uferhi, uwuku uhwɛng Utsĩndĩ Uyesu akarhãrhã, agɔpuwe unuma agɔr umbɔ agɛ, <<Utsɛku unumkpi ukugɔng Urhisiya aka iba kata, umum idɔrhi izharhuwa arherhango.>> ");
INSERT INTO ldb_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Unga atsu uteiya abi iwa Uroma adzɛu Uburhu na aneke unga agayi iyornga na aneke awɛrhanga adzowe ubinkpi unga aka abee. ");
INSERT INTO ldb_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Inum iyɔɔ iki imaa Uferhi aba nggu utsɛ̃nga Udurusirha, una Uyahuda. Adene umbɔ akũ Uburhu aba, ru unga akpeto ra arherhe Uburhu aki imangmang ru Ukiristo Uyesu. ");
INSERT INTO ldb_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ivangyɛ Uburhu aka anu idɛyiwe irhirhika, nu ikpɔm amɛn, nu nggaa unum ukpuku uvarha arherhe uku iba, itsu iwei ifɛr Uferhi, unga agɔr Uburhu agɛ, <<Iki iwu mɔnɔ icɛrɛ! Ubvui uzĩɔ̃. Umum iba ikpomum ivanga, umum idene umbɔ ayisuwa ungo.>> ");
INSERT INTO ldb_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ri ivang hã unga atsu amɛnnga Uburhu awuri idzowe unga uhwɛk igha angwĩ, ngge itsu Uferhi ayisa unga ubɛn ivang asei irhɛrh nggu unga. ");
INSERT INTO ldb_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Imɛka ivaa iki imaa Ufokiyu Ufestu awea ugomna ru ugarh Uferhi. Uferhi abee itɛnamɛn ra abi Uyahuda, unga aneke Uburhu ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Inuma itaar iki imaa Ufestu aka atsĩ ra abĩ hã, asoku Ukaisariya azĩã Urusharhima, ");
INSERT INTO ldb_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","umɔ ateiya abika adzowe idɛm-Num nu anggbaashi abi Uyahuda atsu arherhe Uburhu ru unga. ");
INSERT INTO ldb_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Umbɔ ashɔ̃rhũ Ufestu unga ama atsu umbɔ akũ Uburhu abvui azĩ Urusharhima, ubinkutsu aka agbisha abee iwoi na afɛre unga ru utsĩndĩ. ");
INSERT INTO ldb_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Bɔr Ufestu agɔr umbɔ agɛ, <<Adzudzɛu Uburhu ru Ukaisariya, umum nibikami isi ídãrhũmum ni ibvui izĩ umɔ. ");
INSERT INTO ldb_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Utsak uwurɛ aba awea ru uvau, anggbaashimbi abɔɔ aba umɛn izĩmɛn urhɔnga, azĩ atsu arherhe ri itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Inuma isi inangngge utɔrɔk, use usɔka, unga aka amaa nggu umbɔ, unga abvui azĩã Ukaisariya. Ukpee unum uvaa unga asei nú udzepurhe uku uvarha arherhe, atsu umbɔ akũ Uburhu aba ra asunga. ");
INSERT INTO ldb_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ivang Uburhu aka adzeka, anggbaashi abi Uyahuda abika adzeku Urusharhima aba adɛ̃ɛ̃ adziira unga, atsuyi urherhe arhɛrhɛ uwuku utso ri itsinga, akirakɛ aka ashike ru idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mɔcɛ Uburhu akaa itsinga agɔr agɛ, <<Umum isi igbamum uvau ri Íkpem abi Uyahuda use ri Iya-Num use ru Ukaisar.>> ");
INSERT INTO ldb_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Bɔr Ufestu abee itɛnne amɛn abi Uyahuda, unga agɔr Uburhu agɛ, <<Ungo ubeengo izĩ Urusharhima umbɔ avarhuwa arherhango ra asumum ru nggɔɔ ha?>> ");
INSERT INTO ldb_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Uburhu agɛ, <<Umum iwu ra asu Ukaisar, ru udzepurhe uku uvarha arherhe, anangkɛ ngge iki imɛ̃ɛ̃ umbɔ avarhuwa umum arherhe. Umum isi ikorhumum iyiki ibewe ra abi Uyahuda, ungo nibikango uhwɛngo rimi hã. ");
INSERT INTO ldb_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Umum ĩba ikorhumum ubinkpi uku umɛ̃ɛ̃ akpe, umbɔ afɛre umum, umum isi ikpɛ̃mum akpe. Bɔr idzidzɛrhe iba ishingge ra arherhe ha abi Uyahuda aka atsu ru umum, unera asi ídɛ̃ɛ̃ adzowuka umum ru umbɔ. Umum ifɛna akũ arherhamum izĩ ru Ukaisar!>> ");
INSERT INTO ldb_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ufestu aka akɛki itsũwã nggu abi udzepurhenga, mɔcɛ unga agɛ, <<Ungo ugɔr ugɛ akũ arherhango azĩ ru Ukaisar. Ungo uwuri izĩ ru Ukaisar.>> ");
INSERT INTO ldb_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Inuma ukunjiir iki itɔng uyɛrhe Uagiripa nu Ubani abambɔ Ukaisariya, aba ighwe ugomna Ufestu. ");
INSERT INTO ldb_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Umbɔ amaa inuma irhɛirhɛ nggɔɔ ha, Ufestu arherhe arherhe Uburhu nggu uyɛrhe agɛ, <<Unera nuwɔ Uferhi aka aneka unga ru ugborzĩ. ");
INSERT INTO ldb_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ivangyɛ umum iki iwe ru Urusharhima, ateiya abika adzowe idɛm-Num nu anggbaashi abi Uyahuda atsu arherhe utsak uwurɛ, ashɔ̃rhã umum ima itsu ubinkpi uku iwu uvau akpe ru unga. ");
INSERT INTO ldb_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","<<Umum idɛyiwe umbɔ ugɛ umɛn abi Uroma iki isaki isi idzowukumɛn unera ra abika atsu arherhe ri itsinga, bɔr awuri idzowukumbɔ ivang unga akaa itsinga ra asumbɔ ra arherha ha. ");
INSERT INTO ldb_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ivangyɛ umbɔ aka aba nggimi nggu umum, umum isi idãrhũmum, unum uvaa umum isei nú utarh iyɛrhe ni itsu umbɔ akũ uner ha aba. ");
INSERT INTO ldb_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Abika atsu arherhe ha aka asok arherhe, umbɔ asi irherhumbɔ abin aka abewe akirakɛ umum iki ikau ra amɛnmum. ");
INSERT INTO ldb_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Bɔr umbɔ akpurha awu ru uning ra agbeyi ha umbɔ aka amesuwe, nu utsa uwɔɔ agburh Uyesu aka akpea, bɔr Uburhu agɔr agɛ awea ru urhɛ. ");
INSERT INTO ldb_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Umum iki isi ikpomum usu uku udɔsa arherhe ha, umum irhusa unga ugɛ use unga abemunga izĩ Urusharhima umbɔ avarhuwe arherhanga umɔ nggu abin akɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bɔr Uburhu aka abee uyɛrhe Ukaisar unga azharhuwe arherhanga, umum itsu umbɔ adzɛu unga utsɛku ivangyɛ umum iki idene unga azĩ ru Ukaisar.>> ");
INSERT INTO ldb_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Mɔcɛ uyɛrhe Uagiripa agɔr Ufestu agɛ, <<Umum ibee igũ ru utsa ha nibikami.>> Ufestu agɛ, <<Udã ungo uwuri igũo unga.>> ");
INSERT INTO ldb_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Unum untaar Uagiripa nu Ubani adzek ri ijee iyɛrhambɔ, aba nggu akagɔng abi iwa nu anggbaashi abi utepa atsĩwã udzepurhe iyɛrhe. Mɔcɛ Ufestu atsu umbɔ akũ Uburhu atsĩwã. ");
INSERT INTO ldb_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ufestu agɛ, <<A uyɛrhe Uagiripa, nu kishoo abirabɛ aka awu nggimi nggu umɛn, umbi anyã utsak uwurɛ! Abi Uyahuda kishoo aka atsu arherhe ri itsinga ru umum ru Urusharhima nu nggimi ru Ukaisariya, atsuyi ivum agɛ isi imɛ̃ngge umbɔ neke unga abɛk. ");
INSERT INTO ldb_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Bɔr umum inyã unga asi ikorhunga ubinkpi umbɔ aka ifɛre unga. Ubinkutsu unga nibikanga abee arherhanga azĩ ra asu uwuku ugɔng Ukaisar, umum idene unga azĩã Uroma. ");
INSERT INTO ldb_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bɔr umum ishimum ru undzumu ubinkpi umum iki itsɛnge uyɛrhe uwuku ugɔng ru Uroma ri itsinga. Ngge iki iwe rimi umum ikũ unga iba ru umbi kishoo, undzumunga ru ungo uyɛrhe Uagiripa, inggɛ umɛn ĩba irhi arherhe ha imaamɛn umum ima ikpo ubinkpi umum iki itsɛng. ");
INSERT INTO ldb_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ubinkutsu ri inyĩnyãmum, awu ijijam umbɔ adene uner ugborzĩ ru uwuku ugɔng Ukaisar na asi ikpombɔ undzumu arherhe ha umbɔ aka itsɛng.>> ");
INSERT INTO ldb_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Mɔcɛ Uagiripa agɔr Uburhu agɛ, <<Adzaambɔ ijeea ungo ukaa itsingo.>> Nggee Uburhu aberu uboknga, atirhi arherhe agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","<<A uyɛrhe Uagiripa, umum inyãmum iwu ra andzui iki iwe ugɛ awu ru ungo umum idɛ̃ɛ̃ ikaa itsimum irherɛ ru urherhe anggbaashi abi Uyahuda iki irherhe ri itsimum, ");
INSERT INTO ldb_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","undzumunga ugɛ ungo uhwɛngo ibibayi abi Uyahuda nu abinkɛ umbɔ iki iwe ru uning ra ake. Nggee, uma udɔɔr amɛnngo ukpeto ru umum. ");
INSERT INTO ldb_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","<<Abi Uyahuda kishoo ahwɛngmbɔ ikpũ isiseimum utirhi ri iwɛdzɛmmum, ra abĩmɛn nu ru Urusharhima uba utsĩ irherɛ. ");
INSERT INTO ldb_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Ahwɛngmbɔ umum utirhi ri iwɛdzɛm. Umbɔ aba abemumbɔ, adɛ̃ɛ̃ idzowukumbɔ ideka ri itsimum ugɛ umum iwu ru ukpui agbeyamɛn ukpuku uwu utsotsorakpɔ, umum iwu utsa Ufarisi. ");
INSERT INTO ldb_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ubinkutsu umbɔ avarhuwa umum arherhe irherɛ, awu ififosa ru ubinkpi Unum aka abemuwe atokamɛn. ");
INSERT INTO ldb_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Awu ibibemuwe ha riyɛ idũmɛn usɔkdũmɛn aka afosa abee inyã ngge itsuifɛr. Ngge itsu umbɔ aka amina asumbɔ adɔsu Unum ru utsuu ra atenum. A uyɛrhe, awu ififosa ha itsu anggbaashi abi Uyahuda agɔr agɛ umum iwu ru uvau. ");
INSERT INTO ldb_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Awu use utsu umbi ashimbi ri imangmang ugɛ Unum adɛ̃ɛ̃ asoyika abika akpe? ");
INSERT INTO ldb_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","<<Umum nibikami isha inyã ugɛɛ awu ufang umum ikorha abina arhɛrhɛ akika akpɛ̃ itsok Uyesu uner Unazarat. ");
INSERT INTO ldb_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ubinkpi umum iki ikorhe nukpɔ ru Urusharhima, umum iki ikpo ijee ra ateiya abika adzowe idɛm-Num iyiki igbange asarkasar anera arhɛrhɛ ru ugborzĩ. Ivangyɛ umbɔ aka itsu ufai akpe ru umbɔ, umum iwu ru undzing abika atsu ufai ha. ");
INSERT INTO ldb_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ivanga irhɛirhɛ umum iki ĩdɔsa abã ifɛn-Num kishoo idzise umbɔ uver, ni ibee itsu umbɔ arheni itsok Uyesu. Umum igũ avɔm nggu umbɔ akarhãrhã nggee umum ikɛn umbɔ ri iteu iyɔɔ iyi abĩ akase idzowe umbɔ uver. ");
INSERT INTO ldb_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","<<Ru uzɛ̃rhã ukpu ifɛrha ha umum iwuri izĩ Udimashku, ri ijee ateiya abika adzowe idɛm-Num. ");
INSERT INTO ldb_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Aka ayoka atenuma, a uyɛrhe, umum iwu ru utsĩndĩ ni inyã irhirhang iyɔɔ iki inangngge irhirhang ishaa unum irhang idzeka afã, iba idzipa umum nggu awɛrhu uzɛ̃rhãmum. ");
INSERT INTO ldb_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Umɛn kishookamɛn igba ra abĩ, nu umum igũ urhɛm ukpɔɔ ri idũ abi Uyahuda, uku ugɔr umum ugɛ, <A Ushawurhu, a Ushawurhu, awu use utsu ungo udzaa umum uver? Ungo ukpurhu unayiwe itsingo, ru nyaki inak iki igbopi itsingge nggu igbong uner ughãwã.> ");
INSERT INTO ldb_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","<<Mɔcɛ umum irhusa inggɛ, <Awu ungo ungaa Uteijee?> <<Uteijee agɔr umum agɛ, <Awu umum Uyesu uwu ungo uku udzowe uver. ");
INSERT INTO ldb_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Bɔr icɛrɛ usisok udidɛ̃ɛ̃ nu adakngo. Umum idzeka ru ungo ibee isɛng ungo uwu uner itsermum nu uwu ideka ubinkpi ungo uku unyã ru umum nu abinkɛ umum iki idɛyiwa ungo. ");
INSERT INTO ldb_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Umum iwuri ifɔrhamum ungo ra anerngo nu atsen abi Uyahuda umum iki idena ungo uzĩ ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ungo iyanguwe asumbɔ, umbɔ adzipa adzek ru uzĩ aba ri irhirhang, na adzeki ijee Ushaitan aba ru Unum, ngge itsú umbɔ ama akpo itsũwe arhim, na ama akpo anang nggu abirabɛ umbɔ aka asɛng umbɔ ru ubok imangmangmbɔ ru umum.> ");
INSERT INTO ldb_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","<<Nggee a uyɛrhe Uagiripa, umum isi ikpɛ̃mum idɔsa irhiyɛ iki idzeka afã iba ru umum. ");
INSERT INTO ldb_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Umum itirhi idzowe isarhe ra aner Udimashku imaa ni idzowe aner Urusharhima nu Uyahudiya kishoo, ikɛi ni indzowe isarhe ra atsen abi Uyahuda, inggɛ umbɔ adzipa aba ru Unum, akorha abinkɛ aka idɛyiwe idzidzipambɔ. ");
INSERT INTO ldb_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Ngge itsu abi Uyahuda adzur umum ru ufɔm Iya-Num abee ifɛre umum. ");
INSERT INTO ldb_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bɔr Unum unga ayika umum ĩba itsĩ irherɛ, ngge itsu umum iwu nggimi ni indzowe ideka ra akagɔng nu akaci. Isi irherhumum abin akase bɔr abin abika asɔm Arherhu-Num nu Umusa aka arherhe agɛ iwuri ikorhe rimi, ");
INSERT INTO ldb_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ugɛ awu ufang Ukiristo ahwa uver, na awu unggbaashi uwuku usok ra akpe, na adũwũ irhirhang ififɔrh ra anernga nu atsen abi Uyahuda.>> ");
INSERT INTO ldb_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Uburhu anu ikaa itsinga nukpi Ufestu abvutuwe arherhe Uburhu. Atsarhi irhaknga agɛ, <<A Uburhu, ungo uku uzhɔma! Idzursungo akarhãrhã iki idzipukungge itsingo.>> ");
INSERT INTO ldb_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bɔr Uburhu agɛ, <<A uteiya Ufestu, isi izhɔmum ukpong. Ubinkpi umum iki irherhe uwu idzidzɛrhe nu uwu ubin ukpuku uyɛi. ");
INSERT INTO ldb_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ungo uyɛrhe ungo uhwɛngo abina akɛrɛ, umum isi igũmum iwei irherha ake ru ungo. Umum ihwɛng ungo uku ugũo abin hã kishoo, ubinkutsu, asi ikorhumbɔ ake ri iwɔk. ");
INSERT INTO ldb_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","A uyɛrhe Uagiripa, ungo udzowukɔ imangmang abika asɔm Arherhu-Num? Umum ihwɛng ungo ubemungo.>> ");
INSERT INTO ldb_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Mɔcɛ Uagiripa agɔr Uburhu agɛ, <<Ungo utsar ugɛ ri ungwɛ̃rhĩ ivang iyɛrɛ ungo ubee itsu umum iwu uner Ukiristo?>> ");
INSERT INTO ldb_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Uburhu agɛ, <<Ivang iki ici use iyiki ider, umum ifɛn-Num asi íwea ungo ukpekũ, bɔr kishoo abika akpeto ru umum irherɛ, awe ru nyaka umum, bɔr niba awembɔ ri inyãwã iyɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Uyɛrhe nu ugomna nu Ubani na abirabɛ aka asei nggu umbɔ asisok. ");
INSERT INTO ldb_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Umbɔ aka adzek ru ubã ha, umbɔ anu arherhe nggu adɔka, umbɔ agɔr agɛ, <<Utsak uwurɛ asi ikorhunga ubinkpi uku umɛ̃ɛ̃ igbigbang ru ugborzĩ use akpe.>> ");
INSERT INTO ldb_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Uagiripa agɔr Ufestu agɛ, <<Utsak uwurɛ abee umbɔ akũ arherhanga azĩ ra asu Ukaisar, uda umbɔ atsũwũkumbɔ unga.>> ");
INSERT INTO ldb_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Ivanga iki iwe umɛn iki igar izĩ abĩ Uitarhiya, umbɔ atsuke Uburhu nu abi ugborzĩ abɔɔ ru ubok uteiya abi iwa Uroma uwɔɔ itsoka igburh Ujurhiyo, unying ru ukpui abi iwa Ukaisar. ");
INSERT INTO ldb_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Umɛn iki itsĩ ukhukhɔɔ amɛ̃ uku udzeku Uadiramitiyum, uku uwuri utsĩrhĩ ifɛn akau iteu iyɔɔ iyiki iwe ra abĩ Uasiya, umɛn itsĩ uzɛ̃rhã ru ukau azɛ̃ akagɔng. Uaristaku, utsa Utasarhonika ra abĩ Umakidoniya, awu nggu umɛn. ");
INSERT INTO ldb_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Unum uvaa umɛn itsĩmɛn Usidon. Ujurhiyo amutuwe Uburhu, aneke unga azĩ anyã awɛrhanga umbɔ adzowe ubinkpi unga aka abee. ");
INSERT INTO ldb_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Umɛn iki isok umɔ ru ukhukhɔɔ amɛ̃ hã itsĩmɛn azɛ̃ akagɔng, ugba ukɛnkpɔ umɛn uzɛ̃rhã. Nggee umɛn ikɔre udiku undzing Usayifuru ra anangkɛ ugba usi ikerkpɔ. ");
INSERT INTO ldb_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Umɛn iki igar ukau azɛ̃ akagɔng hã ukpuku ukhapa ra abĩ Ukirhikiya nu Upamfirhiya, umɛn icipa ru uteu Umira ra abĩ Urhikiya. ");
INSERT INTO ldb_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Umɔ uteiya abi iwa Uroma aka akpo ukhukhɔɔ uwɔɔ uku udzeku Uarhekzandiriya uwuri izĩ abĩ Uitarhiya, unga atsu umɛn ru uwu ha. ");
INSERT INTO ldb_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Umɛn uzɛ̃rhã uku utɔɔɔ imaa inuma irhɛirhɛ nggu uver, umɛn iki ikhapa ru uteu Ukinidu, ugba ukɛnkpɔ umɛn izĩ ra asu, umɛn ikɔre udiku ubang ukau Ukirit afɛn akirakɛ aka ashike ru ugba uku uker, aka akhapa ru Usarhmoni. ");
INSERT INTO ldb_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Umɛn igũ uver ni itɔng ubang ukau Ukirit izĩ itsĩ anang akɔɔ umbɔ iki iyisa Anang Akika Ufɔrh, aka akhapa ru uteu Urhasiya. ");
INSERT INTO ldb_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Uzɛ̃rhãmɛn ughawe ivanga irhɛirhɛ. Mɔcɛ igbigba iwe ru uzɛ̃rhã hã. Ubinkutsu unum ikpem igha ubin uku utɔngkpɔ. Nggee Uburhu adzowe umbɔ itsũwã agɛ, ");
INSERT INTO ldb_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","<<Umum inyã uzɛ̃rhã hã uwuri iwu igba abĩ ra asu, ukhukhɔɔmɛn nu abinmɛn nu urhɛmɛn uwuri igba abĩ.>> ");
INSERT INTO ldb_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Bɔr uteiya abi iwa asi ibemunga ubinkpi Uburhu aka arherhe, akpurha atsu amɛnnga ru uner ukhukhɔɔ nu uteiya ukhukhɔɔ ha. ");
INSERT INTO ldb_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ngge iki isi izengge umbɔ agha idoi ru anang hã, irhɛmbɔ ibemumbɔ izɛ̃rhã azĩ ra asu, afosi izĩ atsĩ Ufinikiya, ngge iba imɛ̃ngge umbɔ agha idoyi umɔ. Akɛrɛ awu anang idɛ̃ɛ̃ akɔɔ aki akhukhɔɔ ru Ukirit aka arhi udiku unɔr uwu urhɛɛ nu ufã uwu urhɛɛ. ");
INSERT INTO ldb_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Ivangyɛ ugba ukpuku udzek unɔr utirhi ifɛu uku utɔɔɔ, anera atsar agɛ ubinkpi umbɔ aka abee uku ukpokpɔ, nggee umbɔ agbiir uzɔu ukpuku ukpɔm ukhukhɔɔ ha adɔsu ifɛn ukau uku ukhapa ru Ukirit. ");
INSERT INTO ldb_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Isi idãrhũngge ugba ukpɔɔ ugɔgɔngakpɔ ukpurukpi umbɔ iki iyisa ugba ufã uwu igɔ̃kpee, uku udzeku umpfũwã abĩ hã. ");
INSERT INTO ldb_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ugba ha uku ukwɛr ukhukhɔɔ ha umgbɔ ufɔr irhi udiku ugba ha uda umgbɔ, umɛn idiki neke ugbaka uyii umɛn. ");
INSERT INTO ldb_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Umɛn iki idɔsu udiku umpfũwã uku uci umbɔ iki iyisa Ukauda, afɛnkɛ aka ashike ru ugba, umɛn igũ uver ni idɔrhi igbiir ukhukhɔɔ uwuku uci uwuku ukhapa ru ukhukhɔɔ ha. ");
INSERT INTO ldb_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Ivangyɛ anera aka agbiir ukhukhɔɔ ha atsĩ ru ukugɔnga, mɔcɛ umbɔ akũ arhi aboyi adzipa ukhukhɔɔ ukugɔng hã utsur umgbɔ uyarmgbɔ. Ikɛi umbɔ acipukumbɔ utatorho atorho ukhukhɔɔ ha na aneke ugba uyii ukhukhɔɔ ha. Umbɔ akorhe rimi ubinkutsu agũ iwei utsur umbɔ atsĩmbɔ uzuzeu Usiriti. ");
INSERT INTO ldb_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Unum uvaa ugba utsokpɔ akarhãrhã, utsu umbɔ atirhi akarh abinkɛ aka awe ru ukhukhɔɔ ha atsuyiwe ra amɛ̃. ");
INSERT INTO ldb_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ru unum untaar, umbɔ atãyĩwe abin akɔɔ ikɛi aki itser ukhukhɔɔ ha. ");
INSERT INTO ldb_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Umɛn iki imaa inuma isi inyãmɛn ishaa unum use ídzɛɛr, nggaa ugba ukpu ufin inai ukpurhu udɛ̃ɛ̃ ikwɛr umɛn, umɛn isi ifosumɛn ibibɛk. ");
INSERT INTO ldb_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Aka adera anera aka asi ighambɔ ubingha, Uburhu asok adɛ̃ɛ̃ ra ateumbɔ na agɛ, <<Umbi anera, uda umbi agũmbi arherhamum iki igɔr ugɛ niba asombi ru ubang umpfũwã abĩ Ukirit, uda umɛn isi itsĩmɛn igba abĩ nggu ididak iyɛrɛ. ");
INSERT INTO ldb_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Bɔr icɛrɛ umum idzaa umbi itsũwã àka awe ri ikeramɛn, unera asi íkpea ru umbi, bɔr ukhukhɔɔ ha uwuri iyar ukpekũ. ");
INSERT INTO ldb_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ubinkutsu utsuu ukpu arhɛkɛ ipfu itser iyiki idzeku Unum uwuruwi umum iki iwu uwu unga ni itɔ̃ itsernga, idɛ̃ɛ̃ akhapa ru umum, ");
INSERT INTO ldb_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","igɔr igɛ, <Niba ugũo iwei, Uburhu. Awu ufang ungo iki idɛ̃ɛ̃ ra asu Ukaisar umbɔ avarhuwa arherhango, nggayɛ Unum ri imimutanga aka afɔrhuka abirabɛ aka uzɛ̃rhã nggu ungo.> ");
INSERT INTO ldb_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Nggee àka awe ri ikeramɛn, ubinkutsu umum iwemum ri imangmang ru Unum abin hã umbɔ aka arherhuwa umum, iwuri iwe rimi hã. ");
INSERT INTO ldb_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Bɔr awu ufang ugba utare umɛn nu ubang umpfũwã abĩ akɔɔ.>> ");
INSERT INTO ldb_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ru utsuu ukpu usɔka na anaa, ugba ukpurhu adɛ̃ɛ̃ ikikɛn umɛn ru ukau akagɔng Umeditereniya, aka ayoka ikɔtsuuka abika akpai ukhukhɔɔ ha akaifɛrhkɔ agɛ umɛn iki ikhapumɛn abĩ. ");
INSERT INTO ldb_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Umbɔ amei ighor amɛ̃ anyã ake atsĩke adaka unaka nu isɔka ivaa. Umɛn iki igɔpa izĩ ukunjiir umbɔ amei ikɛi, akpo ighor amɛ̃ adaka isɔka utɔɔrha. ");
INSERT INTO ldb_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Agũ iwei utsur ukhukhɔɔ ha ugbopumgbɔ nggu atarh, umbɔ acipuwe azɔu akika amor anaa udiku undzing ukhukhɔɔ ha, utsur umgbɔ uzɛ̃rhumgbɔ uzɛ̃rhã iki ifefetem. Umbɔ atsĩmbɔ ifɛn-Num ukpee usar ifetem. ");
INSERT INTO ldb_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Abika akpai ukhukhɔɔ ha abee itĩ adzek ru ukhukhɔɔ ha. Nggee umbɔ acipuwe ukhukhɔɔ uwuku uci, akpeta agɛ umbɔ awuri icipuwe azɔu akika amor ra asu ukhukhɔɔ ukugɔng. ");
INSERT INTO ldb_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Mɔcɛ Uburhu agɔr uteiya abi iwa Uroma nu abi iwa ha agɛ, <<Anera abɛrɛ aba asi idɛ̃ɛ̃mbɔ ru ukhukhɔɔ ha, umbi asi íbɛkmbi.>> ");
INSERT INTO ldb_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Igũ rimi itsu abi iwa azharhuwe arhi ukhukhɔɔ uku uci ha, aneke umgbɔ uzĩmgbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ukpee uku uwuri isar Uburhu ashɔ̃rhã umbɔ kishoo ama agha ubingha, agɔr agɛ, <<Irherɛ awu unum ukpu usɔka nu anaa nukpi umbi aka asei ri iwei, asi ighambi ubin. ");
INSERT INTO ldb_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nggee umum ishɔ̃rhã umbi àka agha ubingha na abɛk. Igwar unermbi unying isi ígwirngge ri itsinga.>> ");
INSERT INTO ldb_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Unga aka arherhe rimi amaa, unga anyangu uborodi atar uwɛɛ ru Unum ra asumbɔ kishoo. Mɔcɛ unga azharhe atirha atãi. ");
INSERT INTO ldb_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Kishookambɔ akpo ikeramɛn na agha ubingha. ");
INSERT INTO ldb_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Umɛn kishoo ru ukhukhɔɔ ha iwu inera inaka ivaa ni isɔka utɔɔva nu utɔ̃ĩ (276). ");
INSERT INTO ldb_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Umbɔ aka agha ashur, umbɔ atsũwe imor ukhukhɔɔ ha atare ishaa abin ra amɛ̃. ");
INSERT INTO ldb_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Ivangyɛ ukpee uku usar abika akpai ukhukhɔɔ ha asi ihwɛngmbɔ abĩkɛ umbɔ aka awe, bɔr umbɔ anyã avarha akɔɔ aka awe ru uzuzeu, umbɔ abee ikũ ukhukhɔɔ ha azĩ afata umɔ. ");
INSERT INTO ldb_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Umbɔ atenge arhisa kishoo aki azɔu akika amor, abɔre ake ru ukau. Ri ivang hã umbɔ agarhuwe ubin ukpuku udzipu ukhukhɔɔ ha. Umɔ umbɔ aberuwe utatorho aka awe ra asu ukhukhɔɔ ha na akũ adzur ugba uku iyira umgbɔ ra asu na azĩmbɔ udika abĩ. ");
INSERT INTO ldb_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Bɔr ukhukhɔɔ ha ukwɛr uzuzeu utsĩ ra amɛ̃ ukãã ufɔr idzidzipa udamgbɔ, ukhukhɔɔ ha utirhi iyata udiku undzing itso amɛ̃ aka aker uke. ");
INSERT INTO ldb_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Abi iwa abee ifɛre abi ugborzĩ, utsur uwɔɔ ru umbɔ akwɛr izoyi adzek atĩã. ");
INSERT INTO ldb_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Bɔr uteiya abi iwa Uroma abee ifɔrhe Uburhu, akɛna umbɔ. Atsu umbɔ kishoo uwuruwi aka ahwɛnga ikwɛr izoyi unga ateer isha atsĩ ra amɛ̃ akwɛr izoyi agar nu abĩ. ");
INSERT INTO ldb_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Uteiya abi iwa ha atsu abika abubɔr afũ uakatako, abɔɔ afũ avɛtu ukhukhɔɔ ha. Rimi umbɔ kishoo aka afɔrh azĩ atsĩ nu abĩ. ");
INSERT INTO ldb_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Umɛn iki ifɔrh itsĩ ubang umpfũwã abĩ hã, umɛn irhusa igũ itsok anang hã igburh Umarhta. ");
INSERT INTO ldb_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Abi anang hã amatuwa umɛn akarhãrhã. Inai idoi, ananga aghɛnga, umbɔ ataiwa umɛn urha na ayɛi umɛn iwɛr urha. ");
INSERT INTO ldb_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Uburhu akarh itokũ atsuyi ru urha. Imanu urha itsu ighwɛr idze ikpɔɔr ni izũrhã nu uboknga. ");
INSERT INTO ldb_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Ivangyɛ abi umpfũwã hã aka anyã ngge iki izũrhã nu ubok Uburhu, umbɔ agɔr adɔkambɔ agɛ, <<Idzidzɛrhe utsak uwurɛ awu uner uwuku ufɛyi aner, àka anyã unga aka abɛk ru ukau ukpuku ugɔng, rimi hã kishoo iyiki ibewe ina idɔsa unga awuri ikpea.>> ");
INSERT INTO ldb_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Bɔr Uburhu azusu uboknga atsukuka ibvui ha ru urha, isi inayikungge unga. ");
INSERT INTO ldb_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Anera akau ra amɛnmbɔ agɛ anang hã awuri isengke use unga awuri igba ra abĩ akpe, bɔr umbɔ aka adãrhã asi inyã ifɛrhɛ ikorhungge nggu unga, umbɔ agɛ awu unum. ");
INSERT INTO ldb_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Ídɛɛ niyɔ ikhapa umɔ ra anang hã, iwu iyi Upubirhiyu, unga awu uyɛrhe umpfũwã hã. Unga ayɛi umɛn ri iyanga, na akorhuwa umɛn inna inuma itaar. ");
INSERT INTO ldb_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Utɛ Upubirhiyu aghonga unga, iyora imani anu nggu isurhã. Uburhu atsĩ ru unga afɛne-Num nu unga, atsorha abok nu unga na akerhuwe unga. ");
INSERT INTO ldb_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ivangyɛ ifɛrha ha iki ikorhe, kishoo abi irhãrhã aka abɔr ru umpfũwã abĩ hã aka aba, akerhumbɔ. ");
INSERT INTO ldb_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Umbɔ adzaa umɛn igɔng ra atsĩndĩã arhɛrhɛ. Umɛn iki iwuri isok ru ukhukhɔɔ amɛ̃ ukugɔng, umbɔ akɔng abinkɛ umɛn iki ibee adzaa umɛn. ");
INSERT INTO ldb_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Afɛ̃ɛ̃ ataar aka amaa umɛn isok ru ukhukhɔɔwi uku ugha idoyi ru umpfũwã abĩ hã, uwuku udzeku Uarhekzandiriya. Ra asu ukhukhɔɔ ha umbɔ aka atsɛ̃ uzirhzĩ akãrhghwɛ̃ anum. ");
INSERT INTO ldb_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Umɛn iki itsĩ uteu Usiraku umɛn imaa inuma itaar umɔ. ");
INSERT INTO ldb_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Umɔ umɛn isok izĩmɛn ru uteu Urigiyum. Umɛn imaa unuma unying, ukpee uku usar ugba ukpu unɔr uba, unum uvaa umɛn itsĩmɛn Uputiyorhi. ");
INSERT INTO ldb_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ru Uputiyorhi umɛn iki igbopa angwɛ̃mɛn nu anapumɛn umbɔ ashɔ̃rhã umɛn imaa inuma utɔɔva nggu umbɔ. Ri imimasha umɛn ĩba itsĩ Uroma. ");
INSERT INTO ldb_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Angwɛ̃mɛn nu anapumɛn ru Uroma aka agũ isarhamɛn, umbɔ adzek aba agbanga umɛn. Abɔɔ adzeki Izɛɛ Uaffiyu, abɔɔ adzeka anangkɛ umbɔ iki iyisa Aya Atsen Ataar. Uburhu aka anyãmbɔ unga atar uwɛɛ ru Unum, na awe ru ikeramɛn. ");
INSERT INTO ldb_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ivangyɛ umɛn iki itsĩ Uroma, umbɔ abemuwe Uburhu unga azĩ asei ikiyikanga nggu uner iwa abirabɛ aka adzɛu unga ri iyakɛ umbɔ aka afai uhwɛk. ");
INSERT INTO ldb_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Inuma itaar iki imaa, Uburhu ayisa anggbaashi abi Uyahuda umɔ. Umbɔ aka akɔng Uburhu agɔr umbɔ agɛ, <<Umbi angwɛ̃mɛn nu anapumɛn, umum ihwɛngmum isi igbamum uvau ra anermɛn use ra agbeyi atokamɛn, bɔr umbɔ adzur umum ru Urusharhima adzowe umum ra abok abi ijee Uroma. ");
INSERT INTO ldb_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Umbɔ aka arhisa umum abee itsũwe umum, ubinkutsu, asi ikpombɔ umum nggu uvau uwu ubinkpi umbɔ aka ifɛre umum. ");
INSERT INTO ldb_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Bɔr anggbaashi abi Uyahuda aka akpɛ̃mbɔ, ngge iwu ufang ru umum ikũ arherhunga umɛn izĩmɛn ra asu Ukaisar. Isi iwengge ugɛ umum itsu arherhe abimɛn. ");
INSERT INTO ldb_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Akɛrɛ ha atsu umum ibee inyã umbi ni ikɛki itsũwã nggu umbi. Ubinkutsu awu ubinkpi abi Uisrairha aka afosa itsu umbɔ abow umum nggu inyãwã iyɛrɛ.>> ");
INSERT INTO ldb_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Umbɔ agɔr unga agɛ, <<Umɛn isi ikpomɛn ubvur uku udzeku Uyahudiya uba ru umɛn ri itsingo, use ungwɛ̃mɛn use unapumɛn uwɔɔ aba nggimi nggu isarhe iyiki ibewe ri itsingo. ");
INSERT INTO ldb_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Bɔr umɛn ibee igũ ubinkpi ungo iki irherhe, ubinkutsu umɛn ihwɛng anera ri inanga kishoo arherhe iyiki ibewe ru ukpui ukpɛrɛ ha.>> ");
INSERT INTO ldb_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Nggee umbɔ atsũ unumkpi umbɔ aka igbopa nggu Uburhu. Unum hã uku uwe umbɔ awu arhɛrhɛ aka aba ra anangkɛ Uburhu aka asei. Udzur ru ukpeeka uba utsĩ urhɛɛ unga akpurha adɛ̃ɛ̃ idɛyiwe umbɔ arherhe ri itsi Iyɛrhe Unum abee itsu umbɔ ahwɛng Uyesu ru utsĩndĩ Íkpem Umusa na abvur abika asɔm Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Abɔɔ abemumbɔ ubin hã unga aka arherhe, bɔr abɔɔ ashimbɔ ri imangmang. ");
INSERT INTO ldb_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nggee umbɔ atsĩmbɔ uning nggu adɔkambɔ, na atirhi ibɔre anang hã, Uburhu aka amaa irherhuwe umbɔ arherhe agɛ, <<Ipfu Isarsatangge irherhe idzidzɛrhe ru atokamɛn ra angwĩ uner uwuku usɔm Arherhu-Num Uishaya igɛ, ");
INSERT INTO ldb_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","<< <Uzĩ ra anera abɛrɛ, ugɔr ugɛ, <<Umbi awuri igũmbi ubɛn unuma bɔr asi íhwɛngmbi, umbi awuri irhirhi umbi ubɛn unuma bɔr asi ínyãmbi.>> ");
INSERT INTO ldb_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ubinkutsu amɛn anera abɛrɛ awu akerketake, aka afɔmukumbɔ atombɔ, umbɔ aka abvurkumbɔ asumbɔ, utsur umbɔ anyãmbɔ nggu asumbɔ, utsur umbɔ agũmbɔ nggu atombɔ, na ahwɛngmbɔ nggu amɛnmbɔ, na idzipa aba ru umum ikerhukũ umbɔ.> ");
INSERT INTO ldb_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","<<Umum ibee umbi ahwɛng agɛ Unum aka adene isarhe ififɔrh iyɛrɛ ra atsen abi Uyahuda, nu umbɔ awuri ikpembɔ ato.>> ");
INSERT INTO ldb_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Imɛka ivaa Uburhu asei ri iyakɛ umbɔ aka afai uhwɛk, ayɛi kishoo abika aba ru unga. ");
INSERT INTO ldb_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Unga adzowe isarhe Iyɛrhe-Num, amesuwe abin aki Uteijee Uyesu Ukiristo asi igũa iwei, unera asi ikɛna unga.");
INSERT INTO ldb_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Idzeku umum Uburhu, uner itser Ukiristo Uyesu. Umbɔ aka ayisa umum iwe uner itser Uyesu, atsũ umum idũwũ Isarhe Iyiki Ize iyi Unum. ");
INSERT INTO ldb_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Isarhe Iyiki Ize iyi Unum aka abemuwe akũ abika asɔm Arherhu-Num ishaisha, ru nyaka umbɔ aka atsɛng ra asarkasar abvur Arherhu-Num, ");
INSERT INTO ldb_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ri itsi Ungwɛ̃nga ri iyornga awe unang Udauda. ");
INSERT INTO ldb_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Umbɔ abema agɛ unga awe Ungwɛ̃ Unum ri isisoknga ra akpe ri ijee Ipfu Isarsatangge. Unga awu Uyesu Ukiristo Uteijeemɛn. ");
INSERT INTO ldb_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Ru uboknga Unum aka adzaa umɛn imimuta na ayisa umɛn iwe abi itser Uyesu nggee umɛn iwuri iyisa kishoo atsen abi Uyahuda aba awe ru imangmang na adɔsa. Umɛn ikorhe akɛrɛ ha ri itsoknga. ");
INSERT INTO ldb_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Umbi ikɛi awu ra abirabɛ umbɔ aka ayisa ra atsen abi Uyahuda umbɔ awe abi Uyesu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Umum inu itsɛnge ru kishoo abika awe ru Uroma Unum aka abema ayisa umbi awe asasar. Imimuta nu ididɔɔr iki idzeku Unum Utɛmɛn nu Uteijee Uyesu Ukiristo iwe nggu umbi. ");
INSERT INTO ldb_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Umum inggbaashia, itar uwɛɛ ru Unummum ri itsok Uyesu Ukiristo ru umbi kishoo, ubinkutsu aka asɔmukumbɔ isarhe imangmangmbi ru upfunga kishoo. ");
INSERT INTO ldb_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Umum itɔ̃we Unum itser nggu amɛnmum kishoo ri idzowe Isarhe Iyiki Ize iyi Ungwɛ̃nga, Unum awu idekamum iki iyita umbi ");
INSERT INTO ldb_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ubɛn ivangyɛ umum iki ifɛn-Num. Umum ifɛna unga aba abemunga, unga ama utsuruwa utsĩndĩã ru umum ĩba ru umbi. ");
INSERT INTO ldb_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Umum ibee inyã umbi akarhãrhã ni ĩdzaa umbi izũwã iyɔɔ iyi Ipfu Isarsatangge iyiki itsu umbi aker. ");
INSERT INTO ldb_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Ugɛ iwuri itsu umum nu umbi ifituwe adɔka ri imangmangmɛn. ");
INSERT INTO ldb_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Umum isi ĩbeemum umbi awe ru ida ihwihwɛng umbi angwɛ̃mɛn nu anapumɛn, ugɛ umum ibee ĩba ru umbi idikunga irhɛirhɛ, bɔr umum isi ikpomum ivanga utsɛku icɛrɛ. Umum ibee ikpo igbɛr abin ru umbi, ru nyaka umum iki ikpo ra atsen abi Uyahuda abɔɔ. ");
INSERT INTO ldb_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Umum iwemum ru uvɛrh anera kishoo, abi Uyahuda nu atsen abi Uyahuda, abi isarasu nu agugge. ");
INSERT INTO ldb_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ngge itsu umum itsu amɛnmum idũwũ Isarhe Iyiki Ize ru umbi abirabɛ aka awe ru Uroma ikɛi. ");
INSERT INTO ldb_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Umum isi igũmum atsa idzowe Isarhe Iyiki Ize, ubinkutsu ngge iwu ijee Unum iyiriyɛ iki ikũ ififɔrh iyi abika awe ru imangmang, utirhi ra abi Uyahuda uzĩ utsĩ atsen abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Awu Isarhe Iyiki Ize ha idɛyiwa umɛn ugɛ Unum anyanga umɛn iwe abika arhika, irhirhikayɛ iki iwe ri imangmang iyi inggbaashia izĩ itsĩ imimasha, ru nyaki itsɛng Arherhu-Num iki igɔr ugɛ, <<Uwuku urhika awuri ibɛk ri imangmang.>> ");
INSERT INTO ldb_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Avɔm Unum adzeka ra afã aba nu atsi abirabɛ aka ashimbɔ ru Unum nu abika awe ri iyiki ibewe anera aki adɛmu idzidzɛrhe ri iyiki ibewambɔ. ");
INSERT INTO ldb_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Abinkɛ umbɔ aka adɛ̃ɛ̃ ahwɛng ri itsi Unum uwu ukupɛ̃ɛ̃ ra asumbɔ, ubinkutsu Unum aka ayanguka ake ra asumbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Udzur ri imimunu upfunga iwiweyɛ Unum aka awe umbɔ aka asi idɛ̃ɛ̃ inyãmbɔ, iyiriyɛ iki iwu ijeenga iyi ugbagbaa nu abinkɛ aka adɛyiwa ugɛ unga awu Unum, aka anyã ake ukupɛ̃ɛ̃. Anyã ake ra abinkɛ unga aka amuna, ngge itsú anera asi iwembɔ ru ubin ukpuku urherhe uku uka arhimmbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Ahwɛngmbɔ Unum, na asi ikpoimbɔ unga aka awe Unum, asi itarmbɔ uwɛɛ ru unga. Ifɛrhkɔmbɔ iwe ibɛm nu amɛnmbɔ awe uzĩ. ");
INSERT INTO ldb_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Umbɔ anu igɔr agɛ umbɔ asarasu, bɔr awu agugge ");
INSERT INTO ldb_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","na afaruwe ikpikpoi Unum adzowe ra agberhekɛ aka awe ru nyaka anera nu anunu nu íjuɛ nu abinkɛ aki ikaikai ra abĩ. ");
INSERT INTO ldb_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Nggee Unum aneke umbɔ, ngge itsú umbɔ akorhu abin arhim iyiki ibewe amɛnmbɔ iki ibee. Umbɔ akorhu abin atsa nggu adɔkambɔ. ");
INSERT INTO ldb_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Umbɔ adzipu idzidzɛrhe Unum ngge iwe igbɛrangwĩ, anu idzowe igɔng ra abinkɛ umbɔ aka amuna na akpɛ̃mbɔ uwuku umumuna uwu ikpikpoi ugbagbaa. Iwerimi. ");
INSERT INTO ldb_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Nggee Unum aneke umbɔ nggu ikpona iyiki ikũ atsa. Uko atsɛ̃mbɔ akpɛ̃mbɔ irha nggu atsakmbɔ bɔr arha nggu akatsɛrh. ");
INSERT INTO ldb_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Rimi hã akatsak akpɛ̃mbɔ irha akatsɛrh ngge iki iwe ubinkpi Unum aka amuna na awu ra anyɔna nggu adɔkambɔ akatsak. Akatsak nu akatsak aka isaka arha adɔkambɔ, na ayɛi avau itser iyiki ibewambɔ. ");
INSERT INTO ldb_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Umbɔ akpɛ̃mbɔ iwe nggu ihwihwɛng Unum, nggee Unum aneke umbɔ ri ifɛrhkɔ iyiki itãrhãmbɔ, ngge itsú umbɔ akorha abinkɛ aka asi imɛ̃ke umbɔ akorhe. ");
INSERT INTO ldb_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Umbɔ awe nggu ikpũ iyiki ibewe, nu ikpona nu amɛn aka abewe. Awu nggu unyɛ̃ɛ̃, nu ifɛr uner, nu ifuw, nu ikpikpɛ̃ɛ̃. ");
INSERT INTO ldb_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Umbɔ awe abika avɛrha anera, abika akpɛ̃ Unum, abi ugbau, abika aberi itsi, abika afĩrhã, abika angwɛ̃ amɛnmbɔ ri iki ibewe, asi itĩmbɔ atei, ");
INSERT INTO ldb_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","abika asheri itsoi, abika asheri imangmang, abika ashera amɛn, abika ashera atorh. ");
INSERT INTO ldb_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Umbɔ ahwɛngmbɔ Íkpem iyiki irhika iyi Unum iki igɔr igɛ abika akorha abina akɛrɛ imɛ̃ngge umbɔ akpe, umbɔ asi ikorhumbɔ akɛrɛ ha ukpekũ, bɔr umbɔ ikɛi abema abika akorha ake. ");
INSERT INTO ldb_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nggee ungo ushiɔ ru urhɛm, ungo uwuku utsu uvau ru uwɔɔ, ungo uba utsu uvau ru uwɔɔ, ungo utsu uvau ri itsingo. Ubinkutsu, ungo uner uwuku utsu uvau ha, ungo uni ukorhe ru nyaku uner uwuku uwe ru uvau. ");
INSERT INTO ldb_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Umɛn ihwɛngmɛn ugɛ itsu uvau iyi Unum ru abika akorhe rimi hã iwe idzidzɛrhe. ");
INSERT INTO ldb_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Nggee, ungo uner uwuku utsu uvau ra abɔɔ, nu uni ukorhe iki ibewe ugɛɛ umbɔ, ungo ukaifɛrhkɔ ugɛ ungo uwuri ishɔɔtɔ ri itsu uvau Unum? ");
INSERT INTO ldb_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Use ungo ukwɛɛte urhɛrhɛ innanga, nu inineke nu idɔngamɛn? Ungo usi ihwɛngo ugɛ inna Unum ikũna ungo izĩ idzidzipa? ");
INSERT INTO ldb_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Bɔr iker itsingo nu ida idzidzipa amɛnngo ngge itsu ungo unu ikɔng avɔm ri itsingo ru unum avɔm Unum, ri ivang iyiki itsu uvau iyiki irhika iyi Unum iki idzeka. ");
INSERT INTO ldb_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Unum awuri idzowe ubɛn unera ugbɛtɛ ubinkpi unga aka akorhe. ");
INSERT INTO ldb_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Abika atɔ̃ itser abima ri ikorhu ubin uku uze na abee ikpikpoi, imor nu urhɛ uwu ugbagbaa, Unum awuri idzowe umbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Bɔr abika abema atsimbɔ na akpɛ̃mbɔ idzidzɛrhe na adɔsu iyiki ibewe, awuri itsĩ ra avɔm Unum. ");
INSERT INTO ldb_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Uver nu ayetnum awuri iwe nggu ubɛn unera aka akorhe iki ibewe, agbaashia akorhuwe abi Uyahuda, mɔcɛ atsen abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Bɔr ikpikpoi, igɔng nu ididɔɔr iwuri iwe nggu uwuku ukorhi iyiki ize, igbaashia iwe nggu abi Uyahuda, mɔcɛ atsen abi Uyahuda. ");
INSERT INTO ldb_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Unum asi itɛnga asu. ");
INSERT INTO ldb_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Abirabɛ aka asi ihwɛngmbɔ Íkpem na agba ra arhim, arhimmbɔ awuri itsĩme umbɔ, bɔr abirabɛ aka ahwɛng Íkpem na agba ra arhim, Íkpem iwuri itsĩme umbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Ubinkutsu, asi iwea abika agũ Íkpem awu abika arhika ru Unum, bɔr Unum awuri inyanga abika adɔsi Íkpem awu abika arhika. ");
INSERT INTO ldb_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Rimi hã, atsen abi Uyahuda, abika asheri Íkpem, ivang iyɔɔ umbɔ akorhumbɔ abin akɔɔ aka awe ri Íkpem. Awembɔ ri Íkpem ra amɛnmbɔ, uko umbɔ aka ashimbɔ nu Íkpem. ");
INSERT INTO ldb_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Itsermbɔ itsu anera ahwɛng ugɛ abinkɛ Íkpem iki igɔr, atsɛngmbɔ ake ra amɛnmbɔ. Ifɛrhkɔ amɛnmbɔ ikɛi idɛyiwe ugɛ iwe idzidzɛrhe. Ngge iki iwe ugɛ ifɛrhkɔmbɔ isaki itsu uvau ru umbɔ, ivang iyɔɔ ngge ikaa umbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Akɛrɛ ha awuri iwe ru unumkpi Unum aka itsu uvau ri iwiwɔk amɛn anera ru ubok Uyesu Ukiristo, ru nyaka Isarhe Iyiki Izemum iki irherhe. ");
INSERT INTO ldb_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ungo uner uwuku uyisi itsingo uner Uyahuda. Ungo utsukɔ amɛnngo ri Íkpem nu ufĩrhã ri iwɛrhɛngo nggu Unum. ");
INSERT INTO ldb_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ungo umesungo Íkpem ha. Ungo uhwɛngo ubinkpi unga aka abee ungo ukorhe, nu ubemu ubin uku uze. ");
INSERT INTO ldb_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ungo akaifɛrhkɔ ugɛ ungo udarh abi ibvuta, irhirhang ra abi uzĩ. ");
INSERT INTO ldb_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Ungo ukaifɛrhkɔ ugɛ ungo uwu uner uwuku umesuwe agugge, uwuku umesuwe awɛkaci, ubinkutsu ungo ukaifɛrhkɔ ugɛ ri Íkpem ungo uku ukpo ihwihwɛng nu idzidzɛrhe kishoo. ");
INSERT INTO ldb_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Nggee, ungo, uner uwuku umesuwe anera, ungo usi imesukɔ itsingo? Ungo uner uwuku udũwã ugɛ niba avɛumbɔ ivɛu, ungo uvɛpɔ ivɛu? ");
INSERT INTO ldb_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ungo uner uwuku ugɔr ugɛ niba atomumbɔ-dak, ungo utomungo-dak? Ungo uner uwuku ugũ ishĩ ugberhe, ungo uvɛpɔ ivɛu ru abã agberhe? ");
INSERT INTO ldb_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ungo uwuku ufĩrhã nggu Íkpem, ungo usi idakukɔ itsok Unum ri izharhuwe Íkpemnga? ");
INSERT INTO ldb_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Itsɛng Arherhu-Num igɔr igɛ, <<Umbi atsu atsen abi Uyahuda arhenu Unum.>> ");
INSERT INTO ldb_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Usorhe uwekpɔ ru ugarh, ungo uba udɔsungo Íkpem, bɔr ungo uba uzharhukɔ Íkpem, ungo uwe ru nyaku uwuruwi aka ashia ru usorhe. ");
INSERT INTO ldb_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Nggee, abika asheru usorhe aba adɔsumbɔ abinkɛ Íkpem iki irherhe, asi ínyãnga umbɔ awembɔ ru nyaka abi usorhe? ");
INSERT INTO ldb_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Uwuruwi aka ashia ru usorhe nu iyornga na adɔsunga abinkɛ Íkpem iki irherhe, awuri itsuka uvau ru ungo uwuku uwe ru Íkpem nu usorhe, bɔr ungo uzharhukɔ Íkpem hã. ");
INSERT INTO ldb_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Unera asi iwea uner Uyahuda unga aba akpurha awu Uyahuda uwu iyor, usorhe usi iwekpɔ utsar ukpu iyor ukpekũ anera aka adɛ̃ɛ̃ anyã. ");
INSERT INTO ldb_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ĩ'ĩ, unera awu Uyahuda uwu idzidzɛrhe unga aba awea ra amɛnnga, usorhe ukpu idzidzɛrhe uwe ukpu amɛn, ukpurukpi Ipfu-Num iki isaki ikorhe, asi iwea Ikpem. Ikpũ uner uwɛrɛ awu Unum akpoi unga, asi iwea anera. ");
INSERT INTO ldb_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Abi Uyahuda anang atsen nggu use, nggu ugarh use nggu uwe ru usorhe? ");
INSERT INTO ldb_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ĩĩ, uwe urhɛrhɛ ru ubɛn udĩ! Ri inggbaashia, umbɔ adzowe abi Uyahuda Arherhu-Num. ");
INSERT INTO ldb_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Iwuri iwe iguse abɔɔ aba ashimbɔ ri imangmang? Isheri imangmangmbɔ iwuri itsũwũkũngge imangmang Unum? ");
INSERT INTO ldb_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ĩ'ĩ! Ishingge! Unum awe idzidzɛrhe, nu ngge iki iwu ugɛ anera kishoo awe abi igbɛrangwĩ. Itsɛng Arherhu-Num igɔr igɛ, <<Ngge itsu umbɔ adɛyiwe ugɛ ungo urhika ivangyɛ ungo iki irherha arherhe nu ugha inggbaashi ri ivangyɛ ungo uku itsu uvau.>> ");
INSERT INTO ldb_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Bɔr uba ida irhirhikamɛn ikũ irhirhika Unum idzeka ukupɛ̃ɛ̃, umɛn igɔr uguse? Umɛn igɔr ugɛ Unum asi irhikunga unga aka atsu avɔmnga ru umɛn? Aner abɔɔ arherhe ri iminɛ. ");
INSERT INTO ldb_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Ĩ'ĩ! Ishingge rimi! Iba iwe rimi, Unum awuri ikorha aguse na atsu uvau ru upfung? ");
INSERT INTO ldb_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Uwɔɔ awuri idɛ̃ɛ̃ arherhunga agɛ, <<Ida idzidzɛrhamum iba itsu idzidzɛrhe Unum idzekangge ri idzowe igɔng ru Unum, awu use utsu umbɔ atsu uvau ru umum ra arhimmum?>> ");
INSERT INTO ldb_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Awu ugɛ umbɔ anu irherhe agɛ, <<Iba iwe rimi, mɔcɛ umɛn idɛ̃ɛ̃ ĩgɔrmɛn ugɛ umɛn ikorha iyiki ibewe nu iyiki ize iba?>> Abɔɔ abika arherhi iyiki ibewe nu atsimɛn anu igɔr ugɛ umɛn irherhe aki ha! Awuri itsĩme umbɔ ri iwiwembɔ. ");
INSERT INTO ldb_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Umɛn irherhe iguse ra akɛrɛ? Umɛn abi Uyahuda inangmɛn abɔɔ? Ĩ'ĩ, Ishingge rimi! Umɛn iki itsu atsimɛn ugɛ abi Uyahuda nu atsen abi Uyahuda kishoo umɛn iwe ri ijee arhim. ");
INSERT INTO ldb_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ru nyaku itsɛng Arherhu-Num iki igɔr ugɛ, <<Uner uwuku urhurhika ashia, uko unying. ");
INSERT INTO ldb_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Uwuku uhwuhwɛng ashia, uwuku ubee Unum ashia ");
INSERT INTO ldb_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Kishoo aka adzipu undzingmbɔ ru Unum, kishoo aka awe ibɛm uwuku ikorhe iyiki ize ashia, uko unying.>> ");
INSERT INTO ldb_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","<<Ru nyaku inuk iki ibewe iki isaki idzeyiwa ra adzak aka adɛ̃ɛ̃ iyɛm, rimi hã irhɛm iyiki ibewe iki isaki idzeyiwa ra angwĩmbɔ. Arhɛmmbɔ atɔ̃ itser irhirhɛm.>> <<Irhɛm angwĩmbɔ iwu ungguma íghwɛr.>> ");
INSERT INTO ldb_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","<<Angwĩmbɔ atɔk nggu urhena uku ukperek.>> ");
INSERT INTO ldb_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","<<Adakmbɔ afɛ̃rhĩ itsu adzirh, ");
INSERT INTO ldb_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","igba abĩ nu ihwa uver iwu utsar atsĩndĩmbɔ, ");
INSERT INTO ldb_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ikɛi asi ihwɛngmbɔ atsĩndĩ ididɔɔr.>> ");
INSERT INTO ldb_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","<<Ashimbɔ ri iwei Unum ra asumbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Awu idzidzɛrhe umɛn ihwɛngmɛn ubinkpi Íkpem iki irherhe, irherhe nggu abirabɛ aka awe ru uzirhzĩ Íkpem, ngge itsú ubɛn angwĩ awe uku uveb, nu kishoo upfung aka agbambɔ ra asu Unum. ");
INSERT INTO ldb_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Nggee asi ínyangu unera awea uner uwuku urhika ru utsĩndĩ uwuku udɔsi Íkpem Umusa. Ubinkpi Íkpem Umusa iki ikorhe, idɛyiwe unera ihwɛng arhimnga. ");
INSERT INTO ldb_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Bɔr icɛrɛ Unum aka adɛyiwanga utsĩndĩwi uku itsu unga anyanga umɛn iwe uku urhirhiki. Asi iwea ri Íkpem Umusa. Íkpem Umusa nu abvur abika asɔm Arherhu-Num adzowuke ideka ri itsingge. ");
INSERT INTO ldb_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Irhirhika ha adzowe ngge ru ubok imangmang ru Uyesu Ukiristo ru kishoo abika awe ru imangmang. Asi iwiwembɔ, ");
INSERT INTO ldb_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","anera kishoo awe ra arhim, na afɔr itsitsĩ ru igɔng Unum adambɔ, ");
INSERT INTO ldb_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","bɔr unga anyanga umɛn iwe abika arhika ri izũwã imimutayɛ unga aka adzaa umɛn. Unga akorhe akɛrɛ ru ubok Ukiristo Uyesu ri ivangyɛ unga aka ashɔɔte umɛn. ");
INSERT INTO ldb_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Unum adzowe Uyesu unga awu idɛm-Num iyiki inyãnguwe ugbɛtɛ arhim. Ra adzirhnga umbɔ aka atsũwe arhim anera ri ivangyɛ umbɔ aka awe ru imangmang. Unum akorhe akɛrɛ adeyiwa ugɛ unga arhika, ubinkutsu unga aka asi itsuka uvau ra arhim anera aki isha. ");
INSERT INTO ldb_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Unga akorha ake adɛyiwe irhirhikanga ri ivang iyɛrɛ. Unga arhika, na anyanga kishoo abirabɛ aka awe ru imangmang ru Uyesu awu abika arhika. ");
INSERT INTO ldb_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Nggee unera adɛ̃ɛ̃ ifĩrhũnga? Ĩ'ĩ. Awu idɔsu Íkpem Umusa itsu umɛn irhika? Ĩ'ĩ, awu ru imangmang. ");
INSERT INTO ldb_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Umɛn igɔr ugɛ iwe ru ubok imangmang Unum aka anyanga anera awu abika arhika, asi iwea itser Íkpem Umusa. ");
INSERT INTO ldb_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Unum awu Unum uwu abi Uyahuda ukpekũ? Asi iwea uwu atsen abi Uyahuda ikɛi? Ĩĩ awea, ");
INSERT INTO ldb_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ngge iki iwe ugɛ Unum awu unying. Unga awuri inyanga abi usorhe awu abika arhika ru ubok imangmang, rimi hã abika asheru usorhe awu abika arhika ru ubok imangmang iyɛrɛ ha. ");
INSERT INTO ldb_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Umɛn iki itsũwũkumɛn Íkpem Umusa ri imangmang iyɛrɛ? Uko ukunjiir! Nu ngge iki iwe rimi, umɛn ikpɔm nggu Íkpem hã. ");
INSERT INTO ldb_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Umɛn irherhu uguse ri itsi Uibrahim, utoku atokamɛn ri iyor? Ihwihwɛngnga iwu use ra akɛrɛ ha? ");
INSERT INTO ldb_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Unum aba anyangu Uibrahim awu uner uwuku urhika ru ubok itseryɛ Uibrahim iki itɔ̃, unga awea ru ubinkpi unga aka ikũ afĩrhã nukpɔ, bɔr asi iwea ra asu Unum. ");
INSERT INTO ldb_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Itsɛng Arherhu-Num igɔr ugɛ use? <<Uibrahim awe ru imangmang ru Unum, ngge itsu umbɔ anyanga unga awu uner uwuku urhika.>> ");
INSERT INTO ldb_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Unera aba atɔ̃ itser, itosanga isi iwengge izũwã, bɔr iwu itosi itsernga. ");
INSERT INTO ldb_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Bɔr, unerwi aka asi itɔ̃ itser na akpurha atsu amɛnnga ru Unum uwuruwi iki inyanga abika abewe awe abika arhika, iwu imangmang uner ha iwuri itsu unga arhika ru Unum. ");
INSERT INTO ldb_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Udauda arherhe rimi ivangyɛ unga aka arherhe ugɛ unerwi Unum aka asi inyanga unga awea uner uwuku urhika ru ubok itseryɛ uner ha aka atɔ̃, idorh iwe nggu uner ha. Unga agɔr agɛ, ");
INSERT INTO ldb_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","<<Idorh iwu iyi abirabɛ umbɔ aka atsũwe avaumbɔ, abirabɛ umbɔ aka atsire arhimmbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Idorh iwe nggu uner ha Uteijee aka asi ivarhunga arhimnga.>> ");
INSERT INTO ldb_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Idorh iyɛrɛ iwe ra abi usorhe ukpekũ, use nggu abika asheru usorhe ikɛi? Umɛn iki irherhumɛn ugɛ imangmang Uibrahim itsu umbɔ anyanga unga awu uner uwuku urhika. ");
INSERT INTO ldb_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Iwe ra akasong umbɔ aka anyanga unga awu uner uwuku urhika? Awe ru unga aka asorhu usorhe amaa, use unga aka anasi isorhunga usorhe? Anasi isorhukumbɔ unga usorhe. ");
INSERT INTO ldb_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Bɔr unga ayɛi usorhe ru nyaku utsar. Ake adɛyiwe ugɛ Unum anyangu Uibrahim awu uner uwuku urhika ru ubok imangmang ri ivangyɛ unga aka anasi isorhunga usorhe. Nggee Uibrahim awu utɛ ru kishoo abika awe ru imangmang ru Unum, abirabɛ aka anasi isorhmbɔ usorhe, ngge itsú umbɔ anyanga umbɔ awu abika arhika. ");
INSERT INTO ldb_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Rimi hã ikɛi Uibrahim awu utei ra abi usorhe abirabɛ aka asi iwea usorhe ukpekũ umbɔ aka awe ru ukpɔ, bɔr adɔsumbɔ ikpũ imangmang iyi Uibrahim, unga awe ru imangmang hã na adɔrha asorhu usorhe. ");
INSERT INTO ldb_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Asi iwea ri Íkpem Uibrahim nu unangnga aka ayɛi ibibemuwe agɛ unga awuri igha ukam upfunga, bɔr awu ri irhirhika iyiki iba ru ubok imangmang. ");
INSERT INTO ldb_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Uba awu abika adɔsi Íkpem umbɔ awuri igha ukam, imangmang iwu ibɛm nu ibibemuwe ishingge ru ugarh, ");
INSERT INTO ldb_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ubinkutsu Íkpem Umusa ini ikũ itsu uvau iba. Nu anangkɛ íkpem iki ishingge, izharhuwe íkpem ishingge. ");
INSERT INTO ldb_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Nggee, ibibemuwe iba ru ubok imangmang. Ngge iwu ru ubok imimuta unang Uibrahim kishoo aka adɛ̃ɛ̃ awe ru ikeramɛn ugɛ umbɔ awuri iyɛimbɔ ngge. Asi iwea abirabɛ aka adɔsi Íkpem ukpekũ, bɔr nggu abirabɛ aka awe ru imangmang ru nyaku Uibrahim. Unga awu utɛmɛn kishoo. ");
INSERT INTO ldb_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ru nyaku itsɛng Arherhu-Num iki igɔr igɛ, <<Umum itsu ungo uwe utɛ abĩã arhɛrhɛ.>> Unga awu utɛmɛn ra asu Unum uwuruwi unga aka awe ru imangmang ru unga, Unumwi iki idzowe urhɛ ra abika akpukpe, na awe ru ijee iyisa abinkɛ aka ashike awe. ");
INSERT INTO ldb_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Nu ifosa iki ishingge, Uibrahim akpurha atsu amɛnnga awe ru imangmang. Ngge itsu unga iwe utɛ abĩã arhɛrhɛ ru nyaka umbɔ aka adɛyiwe unga agɛ, <<Unangngo uwuri iwe urhɛrhɛ.>> ");
INSERT INTO ldb_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Imɛk Uibrahim iwu unaka, iker iyornga iki imaangge ri ikɔ̃ner, nu ivang imar Usaratu iki itɔngngge ru unga, bɔr Uibrahim asi idɔ̃rhũnga ri imangmangnga. ");
INSERT INTO ldb_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Asi icanga ibibemuwe-Num na nekuka imangmangnga, bɔr atoma awe ru iker ri imangmangnga, anu ikpoi Unum. ");
INSERT INTO ldb_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Unga awe nggu undzumu ihwihwɛng ugɛ Unum awea ri ijee iyiki itsu ibibemuwenga iwe. ");
INSERT INTO ldb_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Ngge itsu umbɔ anyanga unga awu uner uwuku urhika. ");
INSERT INTO ldb_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Irhɛm hã umbɔ aka atsɛng ngge agɛ, <<Anyanga unga awu uner uwuku urhika,>> asi itsɛngmbɔ ngge ri itsinga ikiyikanga, ");
INSERT INTO ldb_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","bɔr ikɛi nggu umɛn. Awuri inyanga umɛn iwe abika arhika, abirabɛ aka awe ru imangmang ru uwuku usoyiwe Uyesu Uteijeemɛn ra akpe. ");
INSERT INTO ldb_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Awe arhimmɛn atsu umbɔ adzowe unga ra akpe, na asoyiwe unga nggu urhɛ, ru umɛn ikpo isheru uvau ra asu Unum. ");
INSERT INTO ldb_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Unum aka anyanga umɛn iwu abika arhika ru ubok imangmang. Nggee, umɛn iwemɛn ri ididɔɔr nggu Unum ru ubok Uteijeemɛn Uyesu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Unga atsu umɛn idɛ̃ɛ̃ itsĩ ri imimutanga, umɛn idɛ̃ɛ̃ nú ngge icɛrɛ. Umɛn igɔmagɔm ri itsi umɛn iki iwe ru ifosa ugɛ umɛn iwuri ikpomɛn igɔng iyi Unum. ");
INSERT INTO ldb_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Asi iwea rimi ukpekũ, bɔr umɛn iwemɛn ra anggɔm ra ayetnummɛn, ubinkutsu umɛn ihwɛngmɛn ugɛ ayetnum ikũwã umɛn ibibima, ");
INSERT INTO ldb_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ibibima ngge ikũwã umɛn amɛn aka aze, amɛn aka aze ake ikũwã umɛn ifosa. ");
INSERT INTO ldb_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Ifosa ha isi ítsu umɛn igũmɛn atsa, ubinkutsu Unum aka awupuwa ibibemanga ra amɛnmɛn ru ubok Ipfu Isarsatangge, unga aka adzaa umɛn. ");
INSERT INTO ldb_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Àka anyã, ri ivangyɛ umɛn iki ishimɛn ri iker, ivang hã niyɔ Ukiristo akpe ri itsi abika asheru Unum. ");
INSERT INTO ldb_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Aghong unera aka ikpe ri itsi uner uwuku urhika. Use uwɔɔ awuri ibemunga ikpe ri itsi uner amɛn aka aze. ");
INSERT INTO ldb_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Bɔr Unum adɛyiwa umɛn ibibemanga riminɛ, Ukiristo akpe ri itsimɛn ri ivangyɛ umɛn iki iwe abi arhim. ");
INSERT INTO ldb_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Unum anyanga umɛn iwu abika arhika ru ubok adzirh Uyesu. Icicang ishingge, umɛn iwuri ikpomɛn ififɔrh ra avɔm Unum ru uboknga! ");
INSERT INTO ldb_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Isha umɛn iwe anggamtsak Unum, bɔr unga aka agbishuwa iwɛrhɛmɛn nggu unga ru ubok akpe Ungwɛ̃nga. Icicang ishingge, unga aba amaa igbishuwa iwɛrhɛmɛn, umbɔ awuri ifɔrha umɛn ru ubok ibibɛk Ukiristo! ");
INSERT INTO ldb_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Inangngge rimi, bɔr umɛn ikɛi ifĩrhã Unum ru ubinkpi unga aka akorhe ru ubok Uteijeemɛn Uyesu Ukiristo, icɛrɛ unga aka atsu umɛn iwe awɛrhu Unum. ");
INSERT INTO ldb_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Arhim atsĩwã ru upfung ru ubok unera unying, arhim akũwã umɛn akpe. Rimi hã akpe aka akpo anera kishoo, ubinkutsu kishoo awu ra arhim. ");
INSERT INTO ldb_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Awu idzidzɛrhe, arhim aweke ru upfung nu umbɔ adɔrha adzowe Íkpem Umusa, bɔr asi ivarhumbɔ arhim, ubinkutsu íkpem ina ishingge. ");
INSERT INTO ldb_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Rimi hã akpe agha iyɛrhe anera udzur ri ivang Uadamu uba utsĩ ivang Umusa. Akpe agha atsi anera, uko abirabɛ aka asi izharhukumbɔ ikpem, ru nyaku Uadamu aka akorhe. Uadamu awu unyaka uwɔɔ aka iba nggu izũwũ Unum. ");
INSERT INTO ldb_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Bɔr izũwã hã Unum aka adzowe ru uwuku ububa ha isi iwengge ru nyaka arhim Uadamu. Awu idzidzɛrhe ugɛ arhim unera unying hã akowe akpe ra anera arhɛrhɛ. Bɔr imimutu Unum irhɛngge, ngge itsú izũwãyɛ unga aka akorhe ru unera unying hã Uyesu Ukiristo, ngge ikũwã nggaa igũibɛn ra anera arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Iwe rimi, izũwũ Unum iwiwengge nggu arhim unera unying hã. Awu ufaikpi uku udɔsu undzing unera unying hã uku uwu uvau akpe, bɔr izũwãyɛ Unum aka adzaa ngge ikũwã ufai uner uwuku usheru uvau unying ra asunga ra arhimmɛn arhɛrhɛ. ");
INSERT INTO ldb_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Uba awu arhim unera unying atsu akpe agha iyɛrhe anera arhɛrhɛ, nggaa imimutu Unum nu izũwã iyi irhirhikanga inangge, ubinkutsu kishoo uwuku uyɛi ngge awuri ibɛk ru ubok unera unying hã, Uyesu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ngge iki iwe rimi, ru nyaka arhim unera unying aka akowe ufai akpe ra anera kishoo, ngge rimi hã itser iyiki irhika unera unying iki ikowe isheru uvau nggu urhɛ ra anera kishoo. ");
INSERT INTO ldb_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Ida ididɔsa uwu unera unying itsu anera arhɛrhɛ awe abi arhim, rimi hã ididɔsa uwu unera unying ikɛi itsu anera arhɛrhɛ awe abika arhika. ");
INSERT INTO ldb_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Akũ Íkpem Umusa aba ngge itsú anera anyã arhimmbɔ. Bɔr arhim anera aba atomuke, imimutu Unum iki isaki itoma irhɛirhɛ, ");
INSERT INTO ldb_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ru nyaka arhim aka agha iyɛrhe ra anera kishoo na akũ umbɔ azĩ ra akpe, rimi hã ikɛi imimutu Unum iki igha iyɛrhe igangge ni itsu umɛn iwu abika arhika ru Unum, ni ikũwã umɛn urhɛ uwu ugbagbaa ru ubok Uyesu Ukiristo Uteijeemɛn. ");
INSERT INTO ldb_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Umɛn ĩgɔr ugɛ use? Umɛn ikorha arhim ru imimuta itoma? ");
INSERT INTO ldb_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ishingge! Ra arherha arhim, ngge iwe ugɛɛ umɛn iki ikpemɛn, awu use utsu umɛn ibɛk ra ake ikɛi? ");
INSERT INTO ldb_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Umbi asi ihwɛngmbi ugɛ umɛn ru ubok ubɔtisimamɛn umbɔ aka agbopa umɛn nggu Ukiristo Uyesu nu akpenga? ");
INSERT INTO ldb_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ru ubok ubɔtisimamɛn ngge iwe ugɛɛ umɛn iki ikpe, ikɛi ugɛɛ umbɔ aka adzake umɛn nggu Ukiristo. Umbɔ akorha akɛrɛ ha ngge itsú umɛn idɛ̃ɛ̃ iwe ru urhɛ uwuku ufa, ru nyaku Ukiristo aka asok ra akpe ru ubok igɔng Utɛ. ");
INSERT INTO ldb_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Uba umɛn ĩgbopa iwu unying nggu unga ra akpenga, umɛn iwuri iwu unying ru nyaka ha ikɛi ri isok ra akpe. ");
INSERT INTO ldb_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Umɛn ihwɛngmɛn ugɛ amɛnmɛn aka agbe aki arhim aka akpeke anyapuke nggu unga, ngge itsú umɛn ishimɛn ri igãrhã arhim. ");
INSERT INTO ldb_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ubinkutsu ubɛn unera aba akpea, unga aka ashɔɔta ru ubok arhim. ");
INSERT INTO ldb_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Umɛn ĩba iki ikpemɛn nggu Ukiristo, umɛn iwemɛn ri imangmang ugɛ umɛn iwuri ĩbɛkmɛn nggu unga. ");
INSERT INTO ldb_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Umɛn ihwɛngmɛn ugɛ aka asoyikumbɔ Ukiristo ra akpe, nggee unga asi íbvui akpea, akpe ashike ri ijee ri itsinga. ");
INSERT INTO ldb_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Akpe ha unga aka akpe, akpe ra arhim kishoo idiki unying, bɔr ibibɛkyɛ unga aka abɛk, abɛk ri ikpikpoi Unum. ");
INSERT INTO ldb_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Rimi hã, ra arherhe arhim, àka akaifɛrhkɔ ugɛɛ umbi aka akpembi, na akaifɛrhkɔ atsimbi ugɛ umbi awe ru urhɛ ru Unum ru ubok Ukiristo Uyesu. ");
INSERT INTO ldb_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Nggee niba aneke arhim aghake iyɛrhe atsimbi, utsur ake atsu umbi adɔsumbi ikponi iyiki ibewangge. ");
INSERT INTO ldb_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Niba akũ agau ayormbi akorhumbi itser iyi arhim. Bɔr àka adzowe atsimbi ru Unum, ru nyaka abika adzeka akpe azĩ urhɛ, na adzowe agau atsimbi ru unga ru nyaka abin itser irhirhika. ");
INSERT INTO ldb_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Arhim asi íbvui aweke ateiyambi, ubinkutsu umbi asi iwembi abi Íkpem Umusa, bɔr umbi awe abi imimuta. ");
INSERT INTO ldb_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Umɛn igɔr ugɛ use? Azea umɛn ikorha arhim ni igɛ Íkpem ishingge ri ijee ra atsimɛn awu imimuta? Ishingge! ");
INSERT INTO ldb_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Umbi asi ihwɛngmbi ugɛ umbi aba adzowe atsimbi adɔsu uwɔɔ umbi awe agãrhã uner ha? Umbi awu agãrhã ra arhim, ukpurukpi uku ikũna umbi uzĩ ra akpe, use umbi awu agãrhã ri ididɔsa, ukpurukpi uku ikũna umbi uzĩ ri irhirhika. ");
INSERT INTO ldb_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Bɔr itar uwɛɛ izĩ ru Unum! Umbi aka isaka awu agãrhã arhim, bɔr icɛrɛ amɛnmbi kishoo adɔsa ikpũ imesa ha umbɔ aka amesuwa umbi. ");
INSERT INTO ldb_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Aka ashɔɔtambɔ umbi ra arhim, umbi aka awu agãrhã irhirhika. ");
INSERT INTO ldb_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Umum irherhe akɛrɛ ru nyaka anera iki irherhe ubinkutsu awu ididɔ̃rhãmbi ri ihwihwɛng. Umbi aka abayimbi idzowe atsimbi ri itser igãrhã iyi ishĩ nu ikorhu iyiki ibewe, nggee icɛrɛ àka adzowe atsimbi ugɛɛ agãrhã ri itser iyiki irhika iyiki izĩ isisar. ");
INSERT INTO ldb_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ivangyɛ umbi aka awe agãrhã arhim, amɛnmbi ashike nggu itser iyiki irhirhika. ");
INSERT INTO ldb_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ugarh use umbi aka akpo ra abin hã, icɛrɛ àka awe abina atsa? Ugbɛtɛ abin hã iwu akpe! ");
INSERT INTO ldb_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Bɔr icɛrɛ umbɔ aka ashɔɔta umbi ra arhimmbi, umbi awu agãrhũ Unum, ugarhkpi umbi aka akpo ukũna umbi azĩ awe asasar, nu itosambi iwu iyi urhɛ uwu ugbagbaa. ");
INSERT INTO ldb_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Itosa arhim iwu akpe, bɔr izũwũ Unum iwu urhɛ uwu ugbagbaa ru ubok Ukiristo Uyesu Uteijeemɛn. ");
INSERT INTO ldb_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Umbi angwɛ̃mɛn nu anapumɛn umbi ahwɛngmbi íkpem. Umbi asi ahwɛngmbi ugɛ íkpem iwe ru ijee ru uner urhɛ ukpekũ? ");
INSERT INTO ldb_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ru nyaku utsɛrh uwuku upfuna, ikpem ibow unga nggu utsaknga aka awe ru urhɛ, bɔr utsaka aba akpea unga aka ashɔɔta ri ikpem ipfuna. ");
INSERT INTO ldb_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Nggee unga aba arhaa utsa uwɔɔ ri ivangyɛ utsaknga aka awe ru urhɛ, awuri iyisa unga uner uwuku utoma-dak. Bɔr utsaka aba akpea, unga aka ashɔɔta ri ikpem hã na asi itomunga-dak uko unga abvui apfunu utsak ukuse. ");
INSERT INTO ldb_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Nggee, umbi angwɛ̃mɛn nu anapumɛn, umbi aka akpembi ri Íkpem hã, ru ubok iyor Ukiristo, ngge itsú umbi awu abi uwɔɔ, unga uwu ha umbɔ aka asoyiwe unga ra akpe, ngge itsú umɛn ighwɛr ikpũrhã ri itɔ̃we Unum itser. ");
INSERT INTO ldb_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ri ivangyɛ amɛn aki arhim iki idarh umɛn, Íkpem itsu umɛn ikponi ikorha arhim. Ngge itsu umɛn ighwɛr ikpũrhã akpe. ");
INSERT INTO ldb_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Bɔr icɛrɛ, ru ubok akpe ru ubin hã uku ubow umɛn, umɛn iki ishɔɔrmɛn ri Íkpem ngge itsú umɛn itɔ̃ itser ru utsĩndĩ uwuku ufa ri Ipfu-Num, asi iwea utsĩndĩ uwu itsɛng ikpem iyiki igbe. ");
INSERT INTO ldb_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Umɛn ĩgɔr ugɛ use? Íkpem iwu arhim? Ĩ'ĩ, ishingge! Umum isi íhwɛng ubinkpi uku uwe arhim Íkpem iba ishingge. Íkpem iba isi igɔrngge ugɛ, <<Niba ugũo ikponu ubin unera,>> umum isi íhwɛng ubinkpi umbɔ aki iyisa ikpona. ");
INSERT INTO ldb_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Bɔr arhim, akpo ivang iyiki ikũwã umum ikpona ri Íkpem, ngge ighwɛr ikpũ ikpona irhɛirhɛ ru umum. Íkpem iba ishingge arhim awu ubin uku ukpe. ");
INSERT INTO ldb_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Ri inum iyɔrɔ isha umum ĩbɛk ri ida ihwɛng ikpem, bɔr Íkpem iki iba, arhim asok awe ru urhɛ nu umum ikpemum. ");
INSERT INTO ldb_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Íkpem iki ibee ikũwã umɛn urhɛ, ngge ikũwã akpe ru umɛn. ");
INSERT INTO ldb_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Arhim ikpo ivangngge ri Íkpem irhɛm umum, ngge itsu umum ra akpe ru ubok Íkpem. ");
INSERT INTO ldb_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Nggee Íkpem iwu isarsatangge, nu itsitsungge iwu isaisar, irhika ni ize. ");
INSERT INTO ldb_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Ubin uku uze ukpirɛ, ukpɔ ukũwã umum akpe? Isi iwengge rimi! Bɔr awu arhim ake akũ ubin uku uze ha akũwã umum akpe. Awu Íkpem itsu umbɔ ahwɛng ubinkpi arhim aka awe. Íkpem itsu arhim idzeka iwe iki ibewe. ");
INSERT INTO ldb_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Umɛn ihwɛngmɛn ugɛ Íkpem idzek ru Unum, bɔr umum ikpurhu iwu unergwar, agoshe umum iwu ugãrhã arhim. ");
INSERT INTO ldb_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Umum isi ihwɛng ubinkpi iki itsu umum ikorhe abinkɛ umum iki ikorhe. Ubinkutsu ubinkpi umum iki ibee ikikorhe, asi iwea ukpɔ umum iki ikorhe, bɔr ubinkpi umum iki ikpɛ̃, ukpɔ umum iki ikorhe. ");
INSERT INTO ldb_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Uba awu ubinkpi umum iki ikpɛ̃, ukpɔ umum iki ikorhe, umum ĩbemum ugɛ Íkpem ize. ");
INSERT INTO ldb_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Nu ngge iki iwe rimi, asi iwea umum ikorha ake, bɔr awu arhimkɛ aka awe ru umum. ");
INSERT INTO ldb_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Umum ihwɛng ugɛ ubin uku uze ushikpɔ ru umum, ru amɛn aki arhimmum. Ubinkutsu umum ibee ikorhu ubin uku uze, bɔr umum ifɔr ĩdakũ. ");
INSERT INTO ldb_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Umum isi ikorhumum abin aka azekɛ umum iki ibee ikorhe, bɔr iyiki ibewe ha umum iki isi ĩbeemum ikorhe, ngge umum iki idɛ̃ɛ̃ ikorhe. ");
INSERT INTO ldb_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Umum ĩba ikorhu ubinkpi umum iki isi ĩbeemum ikorhe, asi iwea umum ikorhu ubin hã, awu arhimkɛ hã aka awe ru umum akorhe. ");
INSERT INTO ldb_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Nggee, umum inya awu idzidzɛrhe ugɛ umum inba ibee ikorhu ubin uku uze, umum inya itsimum ini ikorhu iyiki ibewe. ");
INSERT INTO ldb_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ra amɛnmum, umum ĩbemumum Íkpem Unum, ");
INSERT INTO ldb_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","bɔr ra agau iyormum, umum inyã ijee iyɔɔ ini itɔ̃ itser ru umum, idɛ̃ɛ̃ iwa nggu amɛnmum ni itsu umum ru ugborzĩ ijee arhim hã iki isei ra agau iyormum. ");
INSERT INTO ldb_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ifakpemum iwu ubina atorh! Ungamɔ awuri ifɔrha umum ri iyor iyɛrɛ iyi akpe? ");
INSERT INTO ldb_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Umum itarwɛɛ ru Unum ru ubok Uyesu Ukiristo Uteijeemɛn! Nggee, umum nibikami ra amɛn aki arhimmum iwu ugãrhu Íkpem Unum, bɔr ri iyormum iwu ugãrhã ijee arhim. ");
INSERT INTO ldb_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nggee, icɛrɛ itsu uvau akpe ri itsi abika awu ru Ukiristo Uyesu ishingge. ");
INSERT INTO ldb_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Ubinkutsu, iwe ru ubok Ukiristo Uyesu ijee iyi Ipfu-Num iki idzaa umbi urhɛ ni itsũwã umbi ri ijee arhim nu akpe. ");
INSERT INTO ldb_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Íkpem hã isi idɛ̃ɛ̃ ifɔnangge umɛn, ubinkutsu umɛn isi idɛ̃ɛ̃ idɔsumɛn Íkpem nggu amɛn aki arhimmɛn aki arhim. Bɔr Unum akorha akɛrɛ ha ri idene unanyi Ungwɛ̃nga ru usaka uner arhim. Unum atsu unga awu idɛm ru arhim, na afɛre arhim nggu iyor Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ngge itsú itser irhirhika ri ikpem ikorhe itɔk ru umɛn, iki isi ibɛkmɛn iyi amɛn aki arhim bɔr iwe iyi Ipfu-Num. ");
INSERT INTO ldb_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Abika abɛk ra amɛn aki arhim aki isaka atsu amɛnmbɔ ra abin iyor aki ibee, bɔr abika abɛk ri Ipfu-Num atsu amɛnmbɔ ru ubinkpi Ipfu-Num iki ibee. ");
INSERT INTO ldb_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Amɛn uner arhim awu akpe, bɔr amɛnkɛ Ipfu-Num iki idarh awu urhɛ nu ididɔɔr. ");
INSERT INTO ldb_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Amɛn aki arhim awe igamtsak Unum. Asi idɔsuke Íkpem Unum, na asi ídɛ̃ɛ̃ akorhuke. ");
INSERT INTO ldb_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Abika abɛk ra amɛn aki arhim asi ídɛ̃ɛ̃ atsu Unum agũã ibɛn. ");
INSERT INTO ldb_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ipfu-Num iba iwengge ru umbi, asi iwea amɛn aki arhim idarh umbi bɔr awu Ipfu-Num. Ubɛn unera aka ashia ri Ipfu iyi Ukiristo, unga asi iwea uwu Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Bɔr Ukiristo aba awea ru umbi, ayormbi aka akpeke ru ubok arhim, rimi hã Ipfu-Num idzaa umbi urhɛ ubinkutsu unga anyanga umbi awu abika arhika. ");
INSERT INTO ldb_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ipfu-Num iyiriyɛ iki isoyiwe Uyesu ra akpe iba iseingge ra amɛnmbi, unga uwu ha aka asoyiwe Ukiristo ra akpe awuri idzaanga urhɛ ra ayormbi aka akpe ru ubok Ipfunga iki isei ru umbi. ");
INSERT INTO ldb_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Nggee, umbi angwɛ̃mɛn nu anapumɛn, umɛn iwemɛn ri itser, bɔr isi iwengge isisei iyi amɛn aki arhim. ");
INSERT INTO ldb_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Umbi aba abɛk ra amɛn aki arhim, umbi awuri ikpe, bɔr umbi aba abɛk ri Ipfu-Num na afɛrkumbi itser arhim iyor, umbi awuri ibɛkmbi. ");
INSERT INTO ldb_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Abirabɛ Ipfu-Num iki idarh umbɔ, awu angwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Umbi asi iyɛimbi Ipfu iyiki itsu umbi agãrhã igũ iwei ikɛi, bɔr umbi ayɛi Ipfu iyiki iwu angwɛ̃. Ru unga umɛn iki iyisu Unum ugɛ, <<Abba!>> Agbena agɛ, <<Utɛ!>> ");
INSERT INTO ldb_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ipfu-Num ha nibikangge nggu ipfumɛn ihwɛngngge ugɛ umɛn iwu angwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Umɛn ĩba iwu angwɛ̃, umɛn iwu abi ukam Unum ni iwu awɛrhu ukam nggu Ukiristo. Bɔr awu ufang umɛn ĩba ihwa uver nggu unga ni idɔrhi igasha ri ikpikpoinga. ");
INSERT INTO ldb_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Umum inyã ayetnummɛn icɛrɛ asi iweke ubin umbɔ aba akpanga ake nggu ikpikpoi iyinga aka idɛyiwa umɛn unuma. ");
INSERT INTO ldb_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Ímimuna kishoo ídzɛu ifosu angwɛ̃ Unum aka idzeka. ");
INSERT INTO ldb_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Atsu imimuna awe ibɛm, akɛrɛ asi iwea ibibema ímimuna hã, bɔr awu ubinkpi Unum aka abee ikorhe. Unga akorhe rimi ri ififosa ");
INSERT INTO ldb_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","agɛ imimuna nibikangge ikpo ishishɔɔr ri igãrhãyɛ ngge iki iwe ri ivivɔ̃ɔ̃ ni itsĩ ri ififɔn nu igɔng iyi angwɛ̃ Unum. ");
INSERT INTO ldb_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Umɛn ihwɛngmɛn ugɛ utsɛku irherɛ ímimuna kishoo idɛ̃ɛ̃ ihwihwasha ru nyaku ukutsɛrh uwuku ugũ ighong ri ivang imar. ");
INSERT INTO ldb_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Isi iwengge ímimuna ukpekũ ihwasha, bɔr umɛn abika akpo Ipfu-Num iyiriyɛ ngge iki iwe izũwũ Unum iyi inggbaashia. Umɛn idzɛu Unum adzipa umɛn iwe adzuma angwɛ̃nga na atsũwe ayormɛn. ");
INSERT INTO ldb_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ri ifosa iyɛrɛ umbɔ aka afɔrh umɛn. Bɔr ifosayɛ umbɔ aki inyã, isi iwengge ifosa. Ungaa afosa ru ubinkpi unga aka akpoa? ");
INSERT INTO ldb_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Bɔr umɛn ĩba ifosa ru ubin umɛn iki inasi ikpomɛn, umɛn iwuri ĩdzɛu nggu idɔngamɛn. ");
INSERT INTO ldb_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Rimi hã, Ipfu-Num iki isaki iba iyika umɛn ri ididɔ̃rhãmɛn. Umɛn isi ihwɛngmɛn ubinkpi umɛn iki ifɛn-Num nukpɔ, bɔr Ipfu-Num ini ifɛna Unum ru umɛn nggu ihwihwashayɛ irhɛm iki isi ídɛ̃ɛ̃ isɔmngge. ");
INSERT INTO ldb_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Nu unga uwuku urhi amɛnmɛn ahwɛnga amɛn Ipfu-Num ha, ubinkutsu Ipfu-Num ha ifɛn-Num ra abika adɔsa nu abinkɛ unga aka afɛna awu abinkɛ Unum aka abema. ");
INSERT INTO ldb_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Umɛn ihwɛngmɛn ugɛ ra abina kishoo Unum atɔ̃ itser ayike abika abema unga, abirabɛ umbɔ aka ayisa umbɔ akpo ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Abirabɛ Unum aka atsũ rimɔ̃ɔ̃ awu umbɔ ha unga aka avina umbɔ anyangu uzirhzĩ Ungwɛ̃nga, ngge itsú unga awu ukã ungwɛ̃ ra arhɛrha angwɛ̃ nu anai. ");
INSERT INTO ldb_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Abi ha unga aka atsũ, awu umbɔ unga aka ayisa. Abi ha unga aka ayisa, awu umbɔ unga anyanga umbɔ awu abika arhika. Abi ha unga aka anyanga awe abika arhika, unga adzowe umbɔ igɔnga. ");
INSERT INTO ldb_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Nggee umɛn ĩgɔr ugɛ use ra akɛrɛ ha? Unum aba awu nggu umɛn ungamɔ idɛ̃ɛ̃ igamtsa nggu umɛn? ");
INSERT INTO ldb_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Unga aka asi ikɛna Ungwɛ̃nga, bɔr adzowuka unga ru umɛn kishoo. Awu use ikɛn unga idzaa umɛn abina kishoo ikɛi izũwã? ");
INSERT INTO ldb_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ungamɔ awuri itsu arherhe abirabɛ Unum aka asɛng? Awu Unum awuri itsu isheru uvau ra asunga. ");
INSERT INTO ldb_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Awu ungamɔ awuri itsu uvau? Unera ashia. Ukiristo Uyesu, aka akpe, unga aka asok abɛk, awu ru ubok ugha Unum, ikɛi awu unga ani ifɛnuwa umɛn! ");
INSERT INTO ldb_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ungamɔ adɛ̃ɛ̃ agau umɛn nggu ibibema Ukiristo? Awu ayetnum, use itsũwã, use uver, use imerh, use igbĩrhĩ, use ubin uku utsu iwei, use akpe? ");
INSERT INTO ldb_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Itsɛng Arherhu-Num igɔr igɛ, <<Ru ungo umɛn inyã akpe ubɛn unum, anyanga umɛn ru nyaka ídɔi umbɔ aka ingwã.>> ");
INSERT INTO ldb_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ĩ'ĩ, ra abina akɛrɛ kishoo, umɛn itɔngmɛn ininang ru uboknga aka abema umɛn. ");
INSERT INTO ldb_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Ubinkutsu umum ihwɛng ugɛ uko akpe use urhɛ, use ípfu itser-Num use ípfu iyiki ibewe, use icɛrɛ, use unuma, use ikpũ ijee iyɔɔ, ");
INSERT INTO ldb_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","use ider use ighor, use ubin ukpɔɔ ra abinkɛ umbɔ aka amuna kishoo, asi ídɛ̃ɛ̃ agauke umɛn nggu ibibemu Unum aka akorhuwa umɛn ru ubok Ukiristo Uyesu Uteijeemɛn. ");
INSERT INTO ldb_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Umum irherhe idzidzɛrhe ru Ukiristo isi igbɛrmum angwĩ, amɛnmum adɛyiwake umum ru ubok Ipfu Isarsatangge. ");
INSERT INTO ldb_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Umum iwe ru nggaa idamɛn nu igũ ighong ra amɛnmum aka asi ímaake. ");
INSERT INTO ldb_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Ngge iba imɛ̃ɛ̃ngge, umum ibee umbɔ atsuka umum ikponum na agau umum nggu Ukiristo ri ifɔrh angwɛ̃mɛn, aner unangmum, ");
INSERT INTO ldb_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","aner Uisrairha. Unum asɛng umbɔ awe angwɛ̃nga. Unga adɛyiwe umbɔ igɔngnga na adzowe umbɔ ibibemuwenga. Umbɔ ayɛi Ikpem, umbɔ adzowe igɔng ri Iya-Num, nu ayɛi ibibemuwenga. ");
INSERT INTO ldb_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Uibrahim, Uishaku, nu Uyakubu awu atokambɔ ri iyor, Ukiristo iganga awu unang Uisrairha. Ukiristo awu Unum uwu abina kishoo, na awe ri idorh ugbagbaa! Iwerimi. ");
INSERT INTO ldb_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Isi iwengge ugɛ ibibemuwe-Num nggu anera iki igba, asi iwea anang Uisrairha kishoo awe aner Unum. ");
INSERT INTO ldb_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ikɛi asi iwea anang Uibrahim kishoo awe ungwɛ̃ Uibrahim. Unum agɔr Uibrahim agɛ, <<Awu ru Uishaku ukpekũ ungo iki ikpo unang hã umum iki inbemuwa.>> ");
INSERT INTO ldb_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Agben akɛrɛ agɛ asi iwea angwɛ̃ abirabɛ Uibrahim aka amar ri iyor awu angwɛ̃ Unum, awu angwɛ̃ ibibemuwe ukpekũ awe angwɛ̃ Uibrahim. ");
INSERT INTO ldb_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Ibibemuwe ha irherhe riminɛ, igɛ, <<Ri ivang iyɛrɛ ra amɛk aka aba, umum ibvui ĩbamum, Usaratu awuri imar ungwɛ̃.>> ");
INSERT INTO ldb_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Asi iwea ake ukpekũ, bɔr angwɛ̃ Urifkatu utesmbɔ awu unying, utɛmɛn Uishaku. ");
INSERT INTO ldb_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Unga anasi imara akãrhghwɛ̃ awɛkaci ha, use umbɔ atɔ̃mbɔ itser iyiki ize use iyiki ibewe, Unum adɛyiwe Urifkatu agɛ, <<Uwuku ukũa awuri itɔ̃we itser ru uwuku ucia.>> Akɛrɛ adɛyiwa ugɛ Unum ani isɛng abirabɛ unga aka abee, isi iwengge ru ubok itsermbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Ru nyaku itsɛng Arherhu-Num iki igɔr ugɛ, <<Umum ibemu Uyakubu, ni ikpɛ̃mum Isuwa.>> ");
INSERT INTO ldb_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Umɛn iwuri igɔr ugɛ use? Unum asi irhikunga nukpɔ? Ishingge! ");
INSERT INTO ldb_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Unga agɔr Umusa agɛ, <<Umum iwuri igũ atorh unerwi umum iki igũ atorh, ni icorhuwe uwuruwi umum iki icorhuwe.>> ");
INSERT INTO ldb_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Nggee, awu Unum unga ani igũ atorh, asi iwea itser unera use ititɛ̃wãnga. ");
INSERT INTO ldb_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Itsɛng Arherhu-Num igɔr Ufir'auna igɛ, <<Umum itsu ungo uwu uyɛrhe, ru umum ikũ ungo idɛyiwe ijeemum ni isɔme itsokmum ru upfunga kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Nggee, Unum awuri igũ atorh unerwi unga aka abee igũ atorh, ikɛi abvure amɛn uwuruwi unga aka ibvure. ");
INSERT INTO ldb_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Bɔr uwɔɔ ru umbi awuri igɔr umum agɛ, <<Awu use utsu Unum anyã avaumɛn? Ungaa adɛ̃ɛ̃ akpɛ̃ ubinkpi unga aka abee?>> ");
INSERT INTO ldb_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Bɔr ungo uwu ungamɔ, unera, ungo iki iwe ru uning nggu Unum? Ubinkpi umbɔ aka akũ abĩ adzin usi ídɛ̃ɛ̃ ugɔrkpɔ uwuku udzin ukpɔ ugɛ, <<Awu use utsu ungo udzin umum rimi?>> ");
INSERT INTO ldb_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Uner uwuku udzin anũi abĩ, asi iwea ri ijee iyiki ikũ abĩ hã akorhu ubinkpi unga aka abee? Unga awea ri ijee iyiki idzin anũi iyi itser ugarh use iyi itser iyiki isheru ugarh. ");
INSERT INTO ldb_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Rimi hã awu idzidzɛrhe Unum aka akorhe. Unga aka abee idɛyiwe avɔmnga, ikɛi adɛyiwe ijeenga. Bɔr unga adɔngamɛn nggu abirabɛ avɔmnga aka imɛ̃ igba ru umbɔ ni itsĩme umbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Unga akorha akɛrɛ ha ri idɛyiwe ikpikpoinga ra abirabɛ unga aka agũ atorh, abirabɛ unga aka asɛng ri idɛyiwe ikpikpoinga ishaisha. ");
INSERT INTO ldb_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Uko umɛn, unga aka ayisa, asi iwea ra abi Uyahuda ukpekũ bɔr nggu atsen abi Uyahuda ikɛi. ");
INSERT INTO ldb_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Ru nyaka unga aka arherhe ru ubvur Uhosiya agɛ, <<Umbɔ asi iwembɔ anermum, bɔr umum iwuri iyisa umbɔ anermum, ikɛi asi iwea uwu umum iki ibema, bɔr umum iyisa unga uwu umum iki ibema.>> ");
INSERT INTO ldb_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Na agɔr agɛ, <<Ngge iwuri ikorhungge uku kpengkpeng ra anangkɛ umbɔ aka agɔr umbɔ agɛ, <Umbi asi iwembi anermum,> awuri iyisa umbɔ <angwɛ̃ Unum uwu urhɛ.> >> ");
INSERT INTO ldb_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Uishaya adũwũ udũwã ri itsi abi Uisrairha agɛ, <<Uko irhɛ abi Uisrairha iwe ru nyaku uzuzeu azɛ̃ akagɔng, abika abɔr ukpekũ awuri ikpo ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Uteijee awuri itsu ufainga ru upfung iki ifefetem idiki unying.>> ");
INSERT INTO ldb_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ru nyaku Uishaya aka arherhe agɛ, <<Agɛ Uteijee uner ijee kishoo asi inekanga umɛn anang, umɛn iwuri iwe ru nyaka Usɔdɔm, umɛn iwuri iwe ru nyaku Ugomora.>> ");
INSERT INTO ldb_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ude umɛn igɔr ugɛ use? Ugɛ atsen abi Uyahuda aka asi ibeembɔ irhirhika, aka akpombɔ ngge, irhirhikayɛ iki iwe ri imangmang. ");
INSERT INTO ldb_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Abi Uisrairha aka atɛ̃wã abee Unum anyanga umbɔ awu abika arhika ri idɔsi Íkpem, bɔr asi ikpombɔ. ");
INSERT INTO ldb_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Awu use ikɛn? Ubinkutsu, umbɔ asi ibeembɔ ngge ri imangmang bɔr umbɔ abeea ngge ri itser. Umɔ umbɔ adana nu <<utarh ukpuku ukwɛr itok.>> ");
INSERT INTO ldb_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Ru nyaku itsɛng Arherhu-Num iki igɔr ugɛ, <<Unyã, umum iden utarh ru Usihiyona, ukpuku itsu anera adani itok nu ifa iyiki itsu anera agbeigba, bɔr ubɛn uwuruwi aka awe ru imangmang ru unga asi íhwaa atsak.>> ");
INSERT INTO ldb_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Umbi angwɛ̃mɛn nu anapumɛn, ubinkpi amɛnmum aka abee nu ifɛn-Nummum iwu ugɛ abi Uisrairha ama akpo ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Umum iwemum ri ideka ri itsimbɔ ugɛ adzowukumbɔ amɛnmbɔ ru Unum, bɔr idzowe amɛnmbɔ isi iwengge ri ihwihwɛng. ");
INSERT INTO ldb_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Umbɔ asi ihwɛngmbɔ irhirhikayɛ iki idzek ru Unum, nggee umbɔ abee itsu atsimbɔ awe abika arhika na asi ineke Unum atsu umbɔ awe abika arhika. ");
INSERT INTO ldb_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Ukiristo awe imimasha Íkpem ngge itsú ubɛn unerwi aka awe ri imangmang ama awe uwuku usheru uvau. ");
INSERT INTO ldb_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Umusa atsɛng riminɛ irhirhika iki ikpo ri idɔsi Íkpem, agɔr agɛ, <<Uner uwuku udɔsi ikpem iyɛrɛ awuri ibɛka.>> ");
INSERT INTO ldb_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Bɔr irhirhika iki iwe ri imangmang igɔr igɛ, <<Niba ugɔrɔ ra amɛnngo ugɛ, <Ungamɔ awuri ifũ ra afã akũ Ukiristo acipuwa?> ");
INSERT INTO ldb_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Use <Ungamɔ awuri itsĩ ra anang abika akpe asoyiwe Ukiristo ra akpe?> >> ");
INSERT INTO ldb_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Irhirhika ha igɔr igɛ, <<Urhɛm hã akhapa ru ungo, uwe ra angwĩngo nu ra amɛnngo.>> Ake awe, arherhe imangmang umɛn iki ĩdũwã ake. ");
INSERT INTO ldb_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Ungo uba urherhungo nggu angwĩngo ugɛ, <<Uyesu awu Uteijee,>> nu uweɔ ri imangmang ra amɛnngo ugɛ Unum asoyiwe unga ra akpe, ungo uwuri ikpoɔ ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Ubinkutsu idzowe imangmang nggu amɛnngo ngge itsú ungo ushiɔ ru uvau ra asu Unum, nu ukũ angwĩngo urherhe ngge itsú ungo ukpo ififɔrh. ");
INSERT INTO ldb_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Ru nyaki itsɛng Arherhu-Num iki igɔr igɛ, <<Ubɛn unera aka awe ru imangmang ru unga asi ígũa atsak.>> ");
INSERT INTO ldb_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ubinkutsu umɛn iwe ubina unying, uwɔɔ asi inanga uwɔɔ, abi Uyahuda nu atsen abi Uyahuda awu unying. Uteijee ha awe Uteijee anera kishoo na atsuke idorh ru kishoo uwuku ufɛna unga. ");
INSERT INTO ldb_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Itsɛng Arherhu-Num igɔr igɛ, <<Ubɛn unerwi aka ayisi itsok Uteijee awuri ikpoa ififɔrh.>> ");
INSERT INTO ldb_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Bɔr anera akorhu uguse na ayisu Unum umbɔ aba ashimbɔ ri imangmang ru unga? Awuri ikorha aguse na awe ru imangmang ru uwuruwi umbɔ aba anasi igũmbɔ isarhe ri itsinga? Awuri ikorha aguse na agũ, unera aba asi idzowuka umbɔ isarhe? ");
INSERT INTO ldb_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Awuri ikorha aguse na adzowe isarhe, umbɔ aba asi idenukumbɔ umbɔ? Ru nyaku itsɛng Arherhu-Num iki igɔr ugɛ, <<Adak abika akũ Isarhe Iyiki Ize awu azezerake!>> ");
INSERT INTO ldb_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Bɔr asi iwea kishoo abi Uisrairha aka ayɛi Isarhe Iyiki Ize ha. Ubinkutsu Uishaya arherhe agɛ, <<A Uteijee, ungamɔ awe ru imangmang ri isarhamɛn?>> ");
INSERT INTO ldb_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Nggee imangmang idzek ri igũ isarhe, igũ isarhe ri itsi Ukiristo. ");
INSERT INTO ldb_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Bɔr umum irhusa, abi Uisrairha anasi igũmbɔ? Aka agũmbɔ, itsɛng Arherhu-Num igɔr igɛ, <<Irhak arherhambɔ iki idɔsu abĩã kishoo, írhɛmmbɔ iki itsĩngge ru upfunga kishoo.>> ");
INSERT INTO ldb_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ikɛi umum ibvui irhusa, abi Uisrairha asi ihwɛngmbɔ? Ĩĩ, ahwɛngmbɔ, uko ri inggbaashia, Umusa agɔr agɛ, <<Umum iwuri itsu umbi agũ unyɛ̃ɛ̃ abirabɛ umbi aka asi inyanga umbɔ awembɔ ubin, umum iwuri itsu umbi agũ avɔm ru ubok abirabɛ aka ashimbɔ ri ihwihwɛngmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Nu Uishaya arherhe nggu ikeramɛn agɛ, <<Abirabɛ aka asi ibeembɔ umum, akpo umum, umum idzeka ra abirabɛ aka asi ibeembɔ umum.>> ");
INSERT INTO ldb_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Bɔr ri itsi abi Uisrairha, unga agɔr agɛ, <<Kishoo unuma umum ibera abokmum iyɛi anera abika asheri ididɔsa nu abika akpɛ̃ igigũ.>> ");
INSERT INTO ldb_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Nggee umum irhusa, Unum aka akpɛ̃ɛ̃ anernga? Ishingge! Umum iwe uner Uisrairha, umum idzeku unang Uibrahim ru unui Ubanjami. ");
INSERT INTO ldb_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Unum asi ikpɛ̃ɛ̃ abirabɛ unga aka asɛng ri inggbaashia. Umbi asi ihwɛngmbi ubinkpi itsɛng Arherhu-Num iki irherhe ri itsi Uirhiya? Unga aka akũ akpenga azĩ ru Unum ri itsi Uisrairha. Agɛ, ");
INSERT INTO ldb_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","<<A Uteijee, aka afɛrkumbɔ abika asɔm Arherhu-Numngo, na asipukumbɔ abeungo, awu umum ĩbɔr ikiyikami, ikɛi umbɔ abee ifɛre umum?>> ");
INSERT INTO ldb_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Unum adzipuwe unga aguse? Adzipa agɛ, <<Umum ibɔre anera anaka agɔnga utɔɔva aka anasi itar arhu na adzowukumbɔ igɔng ru unum uwu Uba'arh.>> ");
INSERT INTO ldb_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Nggee ikɛi, icɛrɛ, anerabɛ Unum aka asɛng ri imimutanga ana abɔrmbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Isisɛng hã iwe ri imimuta, asi iwea ri itseryɛ anera aka atɔ̃. Iba isi iwengge rimi, imimuta ha isi iwengge imimuta. ");
INSERT INTO ldb_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Awu use ucɛ? Abi Uisrairha afɔr ikpo ubin umbɔ aka abee adambɔ, bɔr abirabɛ Unum aka asɛng akpombɔ. Bɔr abika abɔr awu abi atsi aka aker. ");
INSERT INTO ldb_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Ru nyaku itsɛng Arherhu-Num iki igɔr ugɛ, <<Unum atsu umbɔ arharhɔ. Unga adzowe umbɔ asu aka asi ídɛ̃ɛ̃ anyãke nu ato aka asi ídɛ̃ɛ̃ agũke uba utsĩ irherɛ.>> ");
INSERT INTO ldb_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Nu Udauda agɔr agɛ, <<Uneke irhowambɔ iwu unggurhi ru umbɔ, ubinkpi uku itsu umbɔ agbaigba. Uneke umgbɔ utsu umbɔ ufai. ");
INSERT INTO ldb_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Uneke asumbɔ awu uzĩ utsur umbɔ adɛ̃ɛ̃ anyãmbɔ, andzingmbɔ apfuri ugbagbaa.>> ");
INSERT INTO ldb_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ikɛi umum irhusa, abi Uisrairha aka akwɛr itok agbaigba asi ísombɔ nukpɔ? Ishingge! Ubinkutsu igbigbambɔ ngge itsú ififɔrh iba ra atsen abi Uyahuda ngge itsú abi Uisrairha agũ unyɛ̃ɛ̃. ");
INSERT INTO ldb_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Uba uvaumbɔ ukowe upfunga iwe ru ubin, ikɛi uba igbigbambɔ ikowe iwe ru ubin ra atsen abi Uyahuda, iwe ru ubin hã iwe igusengge ri ivangyɛ abi Uisrairha arhɛrhɛ aka idzipa adɔsu Unum! ");
INSERT INTO ldb_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Umum ini irherhe nggu umbi atsen abi Uyahuda. Unum aka atsũ umum iwe uner itser Uyesu ra atsen abi Uyahuda, umum ifĩrhã ri itsermum, ");
INSERT INTO ldb_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ni ifosa ugɛ umum ima itsu anermum abi Uisrairha agũ unyɛ̃ɛ̃ ni ifɔrhe abɔɔ ru umbɔ. ");
INSERT INTO ldb_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Ikpikpɛ̃ɛ̃mbɔ iba idzowe ififɔrh ru upfung, iyiyɛimbɔ iwuri iwe iguse? Iwuri idzowe urhɛ ra abika akpukpe! ");
INSERT INTO ldb_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Uba uteng akɔ̃ uborodi umbɔ aka adzowe idɛm ru Unum awe asasar, akɔ̃ hã kishoo awe asasar nukpɔ. Ikɛi anunang ucucii aba uwe asasar, abok ucucii ha kishoo awe asasar nukpɔ. ");
INSERT INTO ldb_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Bɔr abok akɔɔ aki ucucii uzaitun ha aka abvũĩke, na anyanga ubok aki arhum agbopuwe. Umbi atsen abi Uyahuda, umbi awu ru nyaka abok ucucii arhum, umbɔ aka akũ agbopa nggu ucucii ha. Icɛrɛ umbi aka akpo igha atsei ra anũnang uzaitun ha. ");
INSERT INTO ldb_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Niba anyangu atsimbi anangmbi abok ucucii akɔɔ. Umbi aba akorhumbi, àka ayita ugɛ asi iwea umbi iyike anunang hã, bɔr awu anunang hã ayika umbi. ");
INSERT INTO ldb_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Bɔr umbi adɛ̃ɛ̃ agɔrmbi agɛ, <<Aboka abvũĩ umbɔ akpo utsĩndĩ uwuku ugbopa umum nggu ucucii.>> ");
INSERT INTO ldb_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Iwe idzidzɛrhe! Bɔr ida imangmang ngge itsu umbɔ abvũĩwe umbɔ ru ucucii, ungo igango awu imangmang ngge itsu ungo udɛ̃ɛ̃. Niba ufĩrhungo, ugũ iwei Unum. ");
INSERT INTO ldb_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Unum aba abvũĩka undzumu abok ucucii ha, unga adɛ̃ɛ̃ abvũĩka ungo igango uba unga abeenga. ");
INSERT INTO ldb_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Àka anyã atorh Unum, ikɛi anyã uvernga ra abika agbugba. Awu ru uver ra abika agbugba, bɔr agũã atorhngo, ungo uba uzɛ̃rhũngo ru atorhnga. Bɔr ungo uba ushiɔ, awuri izharha ungo atare. ");
INSERT INTO ldb_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Uba abi Uisrairha asi izɛ̃rhũmbɔ ri ida imangmang, awuri igbopukumbɔ umbɔ nggu ucucii ha, ubinkutsu Unum adɛ̃ɛ̃ adzipa umbɔ atsukuka. ");
INSERT INTO ldb_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Umbi atsen abi Uyahuda awe ru nyaka abok ucucii uzaitun aki arhum, umbɔ aka agbɛr agbopuwe ake itsɛrh nggu ucucii uzaitun akirakɛ umbɔ aka akau. Akɛrɛ aba awu idzidzɛrhe, asi íghonga ru Unum aka ibvui adzipa abok ucucii ha umbɔ aka agbɛr, agbopa nggu ucucii ha umbɔ aka agbɛr ake! ");
INSERT INTO ldb_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Umum isi ĩbeemum umbi asei ri ida ihwɛng abinkɛ umbɔ aka awɔk, umbi angwɛ̃mɛn nu anapumɛn, utsur umbi awembi abika abera atsi. Abi Uisrairha adɛ̃ɛ̃ iker itsi utsɛku Unum aka isɛng atsen abi Uyahuda awe ru imangmang ru unga. ");
INSERT INTO ldb_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Nggee kishoo abi Uisrairha awuri ikpombɔ ififɔrh, ru nyaki itsɛng Arherhu-Num iki igɔr ugɛ, <<Uwuku ufɔrh awuri idzeku Usihiyona, unga awuri itsũwe kishoo ikpɛ̃ idɔsu Unum ra amɛn Uyakubu. ");
INSERT INTO ldb_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Akɛrɛ ake awu ibibemuwemum ru umbɔ, ivangyɛ umum iki itsũwe arhimmbɔ.>> ");
INSERT INTO ldb_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Abi Uisrairha awu anggamtsak ru Isarhe Iyiki Ize, ru ugarha uwu ukpumbi, umbi atsen abi Uyahuda. Rimi hã umbɔ ana awu anernga aka abema ubinkutsu atsɛng atokambɔ. ");
INSERT INTO ldb_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Ubinkutsu, Unum asi íyesuka izũwãyɛ unga aka adzowe use atsɛyi abirabɛ unga aka atsũ. ");
INSERT INTO ldb_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Umbi aka asi iwembi abika adɔsu Unum, bɔr icɛrɛ umbi aka ayɛi icicorhe ri itsi ida ididɔsambɔ. ");
INSERT INTO ldb_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Rimi hã, umbɔ awe abika asheri ididɔsa ngge itsú umbɔ ayɛi icicorhe ubinkutsu Unum aka adzaanga umbi icicorhe. ");
INSERT INTO ldb_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Ida ididɔsa anera kishoo itsu Unum akorhuwe umbɔ ru nyaka abi ugbor uzĩ, ngge itsú unga ama acorhuwe umbɔ kishoo. ");
INSERT INTO ldb_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Ungaa adɛ̃ɛ̃ amei iwe ru ubin Unum nu itsoi nu ihwihwɛngnga? Ungaa adɛ̃ɛ̃ ahwɛng abinkɛ unga aka abee ikorhe use adɛ̃ɛ̃ adɛyiwe abinkɛ unga iki ikorhe? ");
INSERT INTO ldb_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","<<Ungamɔ ahwɛng ifɛrhkɔ Uteijee? Use adzowe unga itsũwã? ");
INSERT INTO ldb_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Ungamɔ aka adzowe ru Unum, ngge itsú Unum afase unga?>> ");
INSERT INTO ldb_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kishoo abin adzeku Uteijee. Abina kishoo amuna ru uboknga na 