﻿USE sofia;
DROP TABLE IF EXISTS sofia.lcp_vpl;
CREATE TABLE lcp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lcp_vpl WRITE;
INSERT INTO lcp_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","โฆะ ลั่ง เมือ โรง อื พะจาว ยุฮ ปลัฮเตะ ไม่ ปลัฮ มะลอง. ");
INSERT INTO lcp_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","เญือม เซ ปลัฮเตะ ดิ แปน โตว ฮุป ฮอย แตะ เฟือฮ. ม่าวง เยือ ลั่ง. รไม่ ลั่ง ไม่ รอาวม. ราว รอาวม โด่ะ เซ เฟียก ตัน ลั่ง. ลปุ พะจาว มอง ควป คุม ราว รอาวม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","พะจาว อัฮ เฮี, “เกือฮ ซเปีย ไก,” อัฮ เซ. ซเปีย เซ ไก เนอึม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","พะจาว เญือม ยุ อื ซเปีย เซ ไมจ ละ อื. พะจาว รกัฮ ซเปีย ฮา เฟียก อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ซเปีย เซ อัฮ เมือ ซเง่ะ ไม่ อื. เฟียก เซ อัฮ เมือ ก ซาวม ไม่ อื. เมือ กปู อื ไก. เมือ กซะ อื ไก. มัฮ ซเงะ ติ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ฟวยจ เซ พะจาว อัฮ เฮี, “เกือฮ รตา ไก ซน่ะ รอาวม ละ ซ เกือฮ อื รอาวม เซ รกัฮ ฮา ปุ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","เญือม เซ พะจาว ยุฮ เนอึม อื ตอก อัฮ แตะ เซ. รอาวม เซ รกัฮ เนอึม ฮา ปุ แตะ. รอาวม อาวต ราว เซ อาวต โน่ง. รอาวม อาวต ฆรึม เซ อาวต โน่ง โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","พะจาว อัฮ ปลัฮ มะลอง ไม่ รตา เซ. เมือ กปู อื ไก. เมือ กซะ อื ไก. มัฮ ซเงะ ลอา นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","พะจาว อัฮ แม เฮี, “เกือฮ รอาวม อาวต ฆรึม มะลอง รโจะ ติ โดฮ เดอึม ซ ไก เตะ ซออฮ นึง,” อัฮ เซ. ไก เนอึม ตอก อัฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","พะจาว อัฮ ปลัฮเตะ ไม่ เตะ ซออฮ เซ. รอาวม รโจะ เซ อัฮ ปลัฮ รอาวม ไม่ อื. พะจาว เญือม ยุ อื ไมจ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","เญือม เซ พะจาว อัฮ เฮี, “เกือฮ ปลัฮเตะ กวยฮ โอเอีฮ นึง โครยญ เจือ, ตอก โคะ เอาะ, เฮงาะ รโกะ, ไม่ พักเญือ เมาะ ป ไก เปลิ ไก โนง นึง ปลัฮเตะ เฮี เตือง โอยจ อื,” อัฮ เซ. ไก เนอึม ตอก อัฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ปลัฮเตะ กวยฮ เนอึม โอเอีฮ ตอก เซ นึง. พะจาว เญือม ยุ อื ไมจ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","เมือ กปู อื ไก. เมือ กซะ อื ไก. มัฮ ซเงะ ลอวย นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","พะจาว อัฮ แม เฮี, “เกือฮ ควน ซเปีย ยุฮ โอเอีฮ ไก นึง ปลัฮ มะลอง, ละ ซ รกัฮ แตะ เมือ ซเง่ะ อื ฮา เมือ ก ซาวม อื. เกือฮ แปน ควน ยุง ปุย เวลา, ซเงะ เคิ เนอึม นึง. ");
INSERT INTO lcp_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","เกือฮ แปน ป รัง นึง ปลัฮ มะลอง, ไม่ ซเปีย โรฮ อื ฮอยจ นึง ปลัฮเตะ,” อัฮ เซ. ไก เนอึม ตอก อัฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","พะจาว ยุฮ เนอึม ควน ซเปีย ระ ลอา โม่ว. ป ระ นึง อื เกือฮ อื ตัตเตียง เมือ ซเง่ะ อื. ป แตวะ นึง อื เกือฮ อื ตัตเตียง เมือ ก ซาวม อื. ยุฮ โรฮ ซโมยญ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","พะจาว เกือฮ อื อาวต นึง ปลัฮ มะลอง. เกือฮ อื ซอต ซเปีย ฮอยจ นึง ปลัฮเตะ. ");
INSERT INTO lcp_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","เกือฮ อื ตัตเตียง เมือ ซเง่ะ ไม่ เมือ ก ซาวม อื, ไม่ เกือฮ อื รกัฮ ก ซเปีย ฮา ก เฟียก อื. พะจาว เญือม ยุ อื ไมจ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","เมือ กปู อื ไก. เมือ กซะ อื ไก. มัฮ ซเงะ ปาวน นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","พะจาว อัฮ แม เฮี, “เกือฮ รอาวม ไก โกะโกลง นึง โฮวน, โครยญ เจือ. เกือฮ โรฮ ไซม โปว นึง กังฮาว ราว ปลัฮเตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","เญือม เซ พะจาว ยุฮ กะ ระ ไก นึง ปลัฮ รอาวม. ยุฮ โรฮ โกะโกลง โครยญ เจือ, เกือฮ อื อาวต โตะ รอาวม โฮวน, ตัม เจือ อื ไอฮ โครยญ เจือ. ยุฮ โรฮ ไซม โครยญ เจือ, ตอก เจือ แตะ ไอฮ โรฮ. พะจาว เญือม ยุ อื ไมจ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","พะจาว ปิฮ มุ่น ละ อื. อัฮ เฮี, “เกือฮ ติ เปอะ พรุฮ โฮวน ปอ นาวก อื ยุฮ ปลัฮ รอาวม. โม ไซม เกือฮ โรฮ พรุฮแพร เลี่ป ปลัฮเตะ โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","เมือ กปู อื ไก. เมือ กซะ อื ไก. มัฮ ซเงะ พอน นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","พะจาว อัฮ แม เฮี, “เกือฮ ปลัฮเตะ ไก โกะพริ โกะย่วง นึง, ไม่ ซัตซิง ป โฮว ลังเตะ ตัม เจือ อื ไอฮ โครยญ เจือ,” อัฮ เซ. ไก เนอึม ตอก อัฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","พะจาว ยุฮ เนอึม โอเอีฮ ตอก เซ โครยญ เจือ. เญือม ยุ อื ไมจ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","เญือม เซ พะจาว อัฮ เฮี, “ไมจ เอะ ยุฮ ปุย ตอก ฮุปฮอย เอะ ไอฮ. เกือฮ ตอก เอะ. เกือฮ ตัตเตียง กะ นึง ปลัฮ รอาวม. ตัตเตียง โรฮ อื ไม่ ไซม ไล่ ไม่ โกะพริ โกะย่วง เตือง โอเอีฮ ปลัฮเตะ เตือง โอยจ อื, ไม่ ซัตซิง ป โฮว ลังเตะ เตือง โอยจ อื โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","พะจาว ยุฮ เนอึม ปุย ตอก ฮุปฮอย โกะ แตะ ไอฮ. ยุฮ อื เตือง ปรเมะ ปรโปวน. ");
INSERT INTO lcp_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","พะจาว ปิฮ มุ่น ละ อื ตอก เฮี, “เกือฮ ติ เปอะ พรุฮแพร โฮวน ปอ นาวก เปอะ ยุฮ ปลัฮเตะ. เกือฮ ติ เปอะ ปุน กุม โอเอีฮ ปลัฮเตะ เตือง โอยจ อื. ไมจ เปอะ ตัตเตียง กะ นึง ปลัฮ รอาวม. ตัตเตียง โรฮ ไม่ ไซม ไล่ ไม่ โอเอีฮ ไฮญ ป โฮว นึง ปลัฮเตะ เตือง โอยจ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","เญือม เซ พะจาว อัฮ เฮี, “ง่อต แลน เมอะ. เฮงาะ รโกะ ไม่ พักเญือ ไม่ เปลิ โคะ เปลิ เอาะ, อาึ เอีจ เกือฮ แปน ป โซม ป ปอน ละ เปอะ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","ฮละ โคะ ฮละ เอาะ ไม่ ไรป เบระ โอเอีฮ, อาึ เอีจ เกือฮ โรฮ แปน ป โซม ละ โกะพริ โกะย่วง ไม่ ไซม ไล่ ไม่ ซัตซิง ป โฮว ลังเตะ โครยญ เจือ,” อัฮ เซ พะจาว. แปน เนอึม ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","พะจาว เญือม ยุ อื โอเอีฮ ป ยุฮ แตะ เซ โครยญ เจือ, ไมจ เนอึม ละ อื. เมือ กปู อื ไก. เมือ กซะ อื ไก. มัฮ ซเงะ แลฮ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ไลลวง กัน ยุฮ พะจาว ปลัฮเตะ ไม่ ปลัฮ มะลอง ไม่ โอเอีฮ อาวต นึง อื โครยญ เจือ เอีจ ฟวยจ เมาะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","เญือม เอีจ เติง ซเงะ อาแลฮ นึง อื พะจาว เอีจ ฟวยจ กัน ยุฮ อื. ลโล่ะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","พะจาว ปิฮ มุ่น ละ ซเงะ อาแลฮ เซ. เกือฮ อื แปน ซเงะ ซัมคัน, นึง มัฮ อื ซเงะ ลโล่ะ อื ฮา ยุฮ แตะ กัน เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","ไลลวง ปลัฮเตะ ไม่ ปลัฮ มะลอง เญือม ยุฮ พะจาว อื มัฮ ตอก เฮี. เญือม ยุฮ โรง พะจาว เยโฮวา ปลัฮเตะ ไม่ ปลัฮ มะลอง เงอ, ดิ ไก โตว โคะ เอาะ นึง ปลัฮเตะ เอ. ดิ ไก โตว ป กวยฮ นึง เฟือฮ. มัฮ ฆาื โอ พะจาว เยโฮวา ดิ เกือฮ พริ เฮละ ละ ปลัฮเตะ. ดิ ไก โตว ปุย ละ ซ มอก แตะ ม่า ยุฮ แตะ ชิจ เจอ. ");
INSERT INTO lcp_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","มัฮ รอาวม ปลาึฮ ป โอก เน่อึม ปลัฮเตะ เซ โน่ง ป ซเกาะ ยุฮ เตะ เอ. ");
INSERT INTO lcp_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","เญือม เซ พะจาว เยโฮวา โกว เตะ รกาื ละ ยุฮ แตะ ปุย นึง. ฟวยจ เซ ปลาึง รพาวม โกะ แตะ โตะ มาึฮ อื. ปุย เซ ไก เอิน จีวิต เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","พะจาว เยโฮวา ยุฮ อาึง รปึม ติ โดฮ นึง แควน เอเด่น. มัฮ ลวง ลั่ก โอก ซเงะ. เกือฮ ปุย ยุฮ แตะ เซ อาวต นึง รปึม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ฟวยจ เซ พะจาว เกือฮ โคะ กวยฮ นึง รปึม ยุฮ แตะ เซ. เมาะ ป ไมจ ละ ไง่ ปุย, ไม่ ป ลัง โซม ปุย เปลิ อื ยุฮ อื โครยญ เจือ. บั่กบ่วน รปึม เซ ไก โคะ จีวิต นึง, ไม่ โคะ เกือฮ ปุย ยุง ป มัฮ ป ปุก ไม่ ป พิต. ");
INSERT INTO lcp_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","แควน เอเด่น เซ ไก โกลง นึง ปัต ฮอยจ ละ รปึม เซ. เญือม เอีจ ปัต อื โปน รปึม เซ โกลง เซ รกัฮ แปน ปาวน เซน. ");
INSERT INTO lcp_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","ติ เซน อื มัฮ โกลง ปีโชน. มัฮ ป ปัต รวิต เมือง ฮาวิลา นา ก โฮวน แฮ ไคร นึง. ");
INSERT INTO lcp_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ไคร เมือง เซ มัฮ ไคร ตึก นึง ไมจ แตะ. นา เซ ไก โรฮ ปุยฮ โคะ ซออย ฮงาื นึง ไม่ แกว ไมจ ติ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","ติ เซน อื แม มัฮ โกลง กิโฮน. ปัต รวิต เมือง คุต. ");
INSERT INTO lcp_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","ติ เซน อื แม มัฮ โกลง ไทกริต. ปัต เฆียง เมือง อัตซีเรีย ลวง ลัก โอก ซเงะ นึง อื. ติ เซน อื แม มัฮ โกลง ยูฟะเรตี. แปน ปาวน เตือง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","พะจาว เยโฮวา เกือฮ ปุย ยุฮ แตะ เซ อาวต นึง รปึม เอเด่น เซ, เกือฮ อื แลน แก อื ไม่ รซอฮ อื นึง. ");
INSERT INTO lcp_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","พะจาว เยโฮวา ซตอก อาึง อื ตอก เฮี, “เปลิ โคะ ไฮญ โตะ รปึม เฮี โครยญ เจือ ปะ ลัง โซม เปอะ, เตอึม ป ฆวต โซม เปอะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ไก ติ โคะ โน่ง ป โอ เปอะ ไมจ โซม เปลิ อื เฟือฮ เอิน. มัฮ โคะ ป เกือฮ ปุย ยุง ป มัฮ ป ปุก ไม่ ป พิต เซ. ลู เปอะ โซม ซเงะ ออฮ ซ ยุม เปอะ ซเงะ เซ” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ฟวยจ เซ พะจาว เยโฮวา อัฮ เฮี “ไมจ โตว ปรเมะ เฮี อาวต โน่ง. อาึ ซ ยุฮ ปุ กู อื ป โปง โกะ อื เกือฮ แปน ป เรอึม อื” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","โกะพริ โกะย่วง ไม่ ไซม ไล่ ไม่ โอเอีฮ ป ไก จีวิต เตือง โอยจ อื พะจาว เอีจ เกือฮ อื เกิต เน่อึม นึง เตะ. เญือม เซ ตาว อื ละ ปรเมะ เซ. ง่อต แลน ตอก ซ ปุก ปรเมะ เซ มอยฮ อื. ปุก ปรเมะ เซ มอยฮ อื ตอก ออฮ เอีจ แปน มอยฮ อื ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ปรเมะ เซ ปุก เนอึม มอยฮ โกะพริ โกะย่วง ไม่ ไซม ไล่ เตือง โอยจ อื. ปรเมะ เซ ปังเมอ โอ ดิ ไก ปุ กู ป เรอึม อื ไม่ โปง อื โกะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","เญือม เซ พะจาว เยโฮวา เกือฮ ปรเมะ เซ ปู ไอจ. ลไล ไอจ อื เซ กอฮ ซอัง พราวก อื ติ. เกือฮ แม เนะ อื รติต ตอก ไพรม แตะ แม. ");
INSERT INTO lcp_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ซอัง พราวก กอฮ พะจาว ฮา ปรเมะ เซ ยุฮ อื แปน ปรโปวน. ตาว อื ละ ปรเมะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","เญือม เซ ปรเมะ เซ อัฮ เฮี, “ปุย เฮี มัฮ เนะซอัง โอก เน่อึม เนะซอัง อาึ. ปุย เฮี เอีจ เกือฮ พะจาว โอก ฮา ปรเมะ. ไมจ อัฮ ปรโปวน ไม่ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","มัฮ ฆาื เซ ป ไมจ ปรเมะ ละ มะเปือะ แตะ นึง ติต รพาวม อื นึง ปรโปวน เญือะ แตะ ฆาื อื. ปุย ลอา เซ เอีจ แปน เนะซอัง ติ. ");
INSERT INTO lcp_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","เญือม เซ ปรเมะ เซ ไม่ ปรโปวน เญือะ อื เซ อาวต ฆาวง ลั่ง, ยุง โตว โซะ กิจ. ");
INSERT INTO lcp_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","เมาะ ป ยุฮ พะจาว เยโฮวา มัฮ ซโอยญ ป เฮียง นึง อื ฮา โกะพริ ไฮญ เตือง โอยจ อื. ซโอยญ เซ อัฮ เฮี ละ ปรโปวน เซ, “พะจาว อัม คัต เนอึม โม เปะ โอ โซม เปลิ โคะ โตะ รปึม เฮี?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ปรโปวน เซ โลยฮ อื ละ ซโอยญ เซ, “เปลิ โคะ นึง รปึม เฮี โฮลฮ โซม โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","พะจาว ปังเมอ อัฮ อื ตอก เฮี, ‘โคะ อาวต บั่กบ่วน รปึม เฮี ติ โคะ โน่ง ป โอ เปอะ ไมจ โซม เปลิ อื. ปุ ลอก เฟือฮ เอิน, เดอึม เปอะ โอ ซ ยุม ฆาื’ ” อัฮ เซ เนิ. ");
INSERT INTO lcp_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ซโอยญ เซ โลยฮ อื ละ ปรโปวน เซ, “ยุม เนอึม เปอะ โตว ฆาื เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","พะจาว เอีจ มัฮ ยุง อื, โซม เปอะ เญือม ออฮ ซ ซเปีย ไง่ เปอะ ฆาื เญือม เซ, ซตอก เอิน เปอะ พะจาว. ซ ยุง โรฮ เปอะ ป ปุก ไม่ ป พิต ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","เญือม แลน ปรโปวน เปลิ โคะ เซ, ไมจ ละ ไง่ อื. ชอม ซ ญึม ละ อื. มัฮ โรฮ แกต อื ติ แตะ ซ โฮลฮ พันญา ไมจ แตะ เบือ อื, เปฮ โซม อื ฆาื อื. เปฮ โรฮ เกือฮ อื ละ ปรเมะ เญือะ แตะ ง่อน. ปรเมะ เญือะ อื เซ โซม โรฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","เญือม เซ ยุง เอิน คิง แตะ เตือง ลอา แตะ, ตอก ป ซเปีย พราวป ไง่ โฮ. ยุง มัฮ แตะ ปุย อาวต ฆาวง. ตุย ชิญ ฮละ เม ละ ซ เฟีย แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","ปู เซ เยอ ปุย ลอา เซ ฮมอง ลอยฮ โฮว พะจาว เยโฮวา นึง รปึม เซ. ปรเมะ เซ ไม่ ปรโปวน เญือะ อื ตอ เอิน เม่าะ ลลาึง โคะ เอาะ โตะ รปึม เซ. ฆวต เกือฮ ติ แตะ ไฆลป ฮา ไง่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","พะจาว เยโฮวา กอก ปรเมะ เซ, “ปะ อาวต เปอะ ก เมอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ปรเมะ เซ อัฮ เฮี, “อาึ ฮมอง ลอยฮ โฮว เปอะ นึง รปึม เซ. ฮลัต ฆาื, ตอ เม่าะ ฆาื อาวต ฆาวง แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","พะจาว อัฮ เฮี, “ปุย รโฮงะ ละ เปอะ มัฮ เปอะ ปุย อาวต ฆาวง เงอ? อัม มัฮ โซม เปอะ เปลิ โคะ คัต อาึ แตะ โอ โซม โฮ?” อัฮ เซ ละ อื พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ปรเมะ เซ โลยฮ อื, “ปรโปวน เกือฮ เปอะ อาวต ดิ ไม่ เยอะ เซ เกือฮ เปลิ โคะ เซ เนิ. อาึ โคะ โซม เนอึม ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","พะจาว อัฮ เฮี ละ ปรโปวน เซ, “ปะ ยุฮ โน่ง เปอะ โอเอีฮ ตอก เซ เมอ?” อัฮ เซ. ปรโปวน เซ อัฮ เฮี, “มัฮ ซโอยญ ป จุ อาึ โซม เมอ. อาึ โคะ โซม เนอึม ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","พะจาว อัฮ เฮี ละ ซโอยญ เซ, “ปะ ซ ลอก เปอะ ป โอยจ นึง โซะ แตะ ฮา โกะพริ โกะย่วง ไฮญ โครยญ เจือ นึง ยุฮ เปอะ ตอก เซ. ซ โฮลฮ เปอะ โฮว นึง เวียก แตะ ไม่ ซ โฮลฮ เปอะ โซม เตะ รกาื ฆาื อื ล่อยญ เจน เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","อาึ ซ เกือฮ ปะ ไม่ ปรโปวน เฮี เกละยุ ปุ แตะ, ฮอยจ ละ จัตเจือ เปอะ ไม่ จัตเจือ ปรโปวน เฮี เฆียง เฮี. จัตเจือ ปรโปวน เซ ซ บึน ไกญ ปะ ติ ปุย, เกือฮ บลวย. ปะ ซ ปวก โรฮ เปอะ ล่อยจ ปุย เซ ปอ โซะ อื โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","พะจาว อัฮ โรฮ เฮี ละ ปรโปวน เซ, “เญือม โรวก เปอะ กวน แตะ ปะ ซ เม่ะมั่ก เนอึม ละ เปอะ. เญือม เกิต กวน เปอะ อาึ ซ เกือฮ ปะ โซะ เนอึม ป อาวม. ปัง มัฮ ตอก เซ, ปะ ซ ไก ลั่ง รพาวม เปอะ นึง ปรเมะ เญือะ แตะ. ปรเมะ เญือะ เปอะ เซ ซ โฮลฮ ตัตเตียง ปะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","พะจาว อัฮ โรฮ เฮี ละ อาดั่ม, “ปลัฮเตะ เญือะ ซ ไมจ โตว ละ เปอะ ตอก ไพรม แตะ, มัฮ ฆาื ง่อต ปะ ป อัฮ ปรโปวน เญือะ แตะ, ไม่ โซม เปอะ เปลิ โคะ คัต อาึ แตะ โอ โซม เซ. ปะ ซ โฮลฮ เปอะ ยุฮ กัน โซะ ล่อยญ ฆอ แตะ, เดอึม เปอะ ซ โฮลฮ โซม เน่อึม นึง ปลัฮเตะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","ปะ ซ โฮลฮ เปอะ โซม ป ซมา แตะ นึง ปลัฮเตะ. ลลาึง ป ซมา เปอะ เซ ซ กวยฮ โคะ กัต นึง ละ เปอะ ง่อน, ไม่ ไรป กัต โฮวน เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","ปะ ซ โฮลฮ เปอะ โซม เบือ ยุฮ แตะ กัน ปอ แตก ลโอฮ โฆลฮ ลฮาึง แตะ, ฮอยจ ละ แปน แม เปอะ เตะ ตอก ไพรม แตะ, นึง ยุฮ อาึ เปอะ นึง เตะ. ปะ มัฮ เปอะ เตะ รกาื. ซ โฮลฮ แม เปอะ แปน เตะ รกาื ตอก ไพรม แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ปรเมะ เซ ปุก มอยฮ ปรโปวน เญือะ แตะ. อัฮ เอวา ละ อื, นึง มัฮ อื มะ ปุย เมือ โรง อื เตือง โอยจ อื เมาะ ป ซ เกิต นึง ปลัฮเตะ. ");
INSERT INTO lcp_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","เญือม เซ พะจาว เยโฮวา ยุฮ เครอึง เซอึก ละ อาดั่ม ไม่ ปรโปวน เญือะ อื นึงฮัก ซัตซิง, จาวป อื ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","เญือม เซ พะจาว อัฮ เฮี, “ง่อต แลน, ปเลี่ย เฮี ปุย เยอ เอีจ ตอก โรฮ เอะ นึง ยุง อื ป มัฮ ป ปุก ไม่ ป พิต. ปเลี่ย เฮี ดัฮ กอยฮ เตะ แตะ ละ เปฮ แตะ โซม เปลิ โคะ จีวิต เซ ตึน ซ ไอม ลอป ฆาื อื. ไมจ โตว เกือฮ ยุฮ อื ตอก เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","มัฮ ฆาื เซ ป โครฮ พะจาว อื โอก ฮา รปึม เอเด่น ฆาื อื ละ ซ เกือฮ อื มอก ม่า ยุฮ ชิจ นึง ปลัฮเตะ, นึง เอีจ มัฮ โรฮ โกะ อื เตะ เน่อึม เมือ โรง อื. ");
INSERT INTO lcp_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ฟวยจ โครฮ อื โอก เซ พะจาว เกือฮ โม เตปด่า ไก โพรยจ อาวต นึง รปึม เซ ลวง ลั่ก โอก ซเงะ นึง อื. เกือฮ โรฮ วิจ ไก รเออึป งอ นึง อาวต นา เซ. เกือฮ วิจ เซ แน ติ แตะ โครยญ ลวง ละ ซ เกือฮ อื ปุย โอ เกียฮ เลียก ละ โคะ จีวิต เซ. ");
INSERT INTO lcp_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","เญือม เอีจ โฮลฮ อาดั่ม ยุ ปุ แตะ ไม่ เอวา ปรโปวน เญือะ แตะ เซ, ปุย เญือะ อื เซ โรวก. ฟวยจ เซ เกิต คาอิน นึง. เอวา เซ อัฮ เฮี, “อาึ เอีจ โฮลฮ กวน รเมะ แตะ เบือ เรอึม พะจาว แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ฟวยจ เซ เกิต แม ปุ. มอยฮ อื มัฮ เฮเบ่น. เฮเบ่น เซ มัฮ ป เลียง แกะ. คาอิน เซ มัฮ ป ยุฮ รปึม. ");
INSERT INTO lcp_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ไก ติ ซเงะ คาอิน โรวก เปลิ โคะ เปลิ เอาะ ละ ซ ทไว แตะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","เฮเบ่น เซ โรวก โรฮ โม กวน แกะ เกิต โรง ยุฮ แตะ ง่อน. มอก อื. โตะ อื ไม่ ลออยฮ อื เซ ตอง ทไว อื ละ พะจาว. เฮเบ่น เซ ปุก รพาวม พะจาว. ป ทไว อื เซ ปุก โรฮ รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","คาอิน เซ ปุก โตว รพาวม พะจาว. ป ทไว อื เซ ปุ โรฮ ปุก อื. คาอิน รอก ลัมเลือ รพาวม. นา มึต นา มอง ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","พะจาว อัฮ เฮี ละ คาอิน, “เมอ รอก พาวม เปอะ นึง อื? มัฮ ฆาื เมอ ป นา มึต นา มอง เปอะ ฆาื อื? ");
INSERT INTO lcp_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ดัฮ ปะ ยุฮ ป ปุก โฮ, โม่ ซ ปุก โรฮ ละ อาึ อื? ดัฮ ปะ ยุฮ ป โอ ปุก, มั่ป เซ เอีจ อาวต นึง โตะ รเวือะ ละ ซ ดัม อื บุก ปะ ตอก ซัตซิง โฮ, นึง ฆวต เป อื ปะ. ไมจ เปอะ โตว เกือฮ ติ แตะ ไป นึง,” อัฮ เซ ละ อื พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","คาอิน อัฮ เฮี ละ เฮเบ่น ป มัฮ ปุ แตะ เซ, “โฮว, โฮว ดิ นึง รปึม และ,” อัฮ เซ. ฟวยจ เซ โฮว เนอึม. เญือม อาวต ดิ อื นึง รปึม เซ คาอิน โกฮ ยุฮ ยุม ไม่ ปุ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ฟวยจ เซ พะจาว อัฮ เฮี ละ คาอิน, “เฮเบ่น ป มัฮ ปุ เปอะ เซ อาวต ก เมอ?” อัฮ เซ. คาอิน โลยฮ อื, “ยุง โตว ก อาวต ปุ แตะ เซ. มัฮ โตว อาึ ป แลน แก เยอ. เกียฮ ไฮมญ โน่ง เปอะ อาึ นึง เมอ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","พะจาว อัฮ เฮี, “ปะ เกียฮ ยุฮ โน่ง เปอะ โอเอีฮ ตอก เซ เมอ? ฮนัม ปุ เปอะ ป ปัต ลังเตะ เซ ตอก เอิน ป รโอง ดวน อาึ โรก เวน ละ ปะ. ");
INSERT INTO lcp_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","ปะ ซ ลอก เปอะ ป ตึก นึง โซะ แตะ ฆาื อื. เฆิม เฮี ซ กี เตะ ไฮจ รอาวม ละ เปอะ, นึง เอีจ มัฮ เตะ เฮี ป ลอก ฮนัม ปุ เปอะ เซ ไม่ ฟอง โรฮ อื ปะ ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","เญือม ยุฮ เปอะ รปึม เญือะ ซ ลุก โตว ป ซมา ลโลวง เปอะ นึง ฆาื อื ตอก ไพรม แตะ. ปะ ซ โฮลฮ เปอะ โตว อาวต ไมจ ตอก ปุย. ซ โฮลฮ เปอะ ตอ ไป ตอ มา ลอป นึง ปลัฮเตะ เฮี ฆาื อื,” อัฮ เซ ละ อื พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","คาอิน อัฮ เฮี ละ พะจาว, “ตุต เกือฮ เปอะ อาึ ลอก เฮี เอีจ โฮฮ ฮา ปุน โอต เตอะ. ");
INSERT INTO lcp_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ปะ เอีจ โครฮ เปอะ อาึ โอก ฮา ปลัฮเตะ ไมจ. เอีจ เกือฮ เปอะ อาึ ซไง ฮา โกะ แตะ. อาึ ซ โฮลฮ โฮว ไป โฮว มา ลอต แปน ปุย โอ ไก เญือะ อาวต คราว โซม ฆาื อื. ปุย ดัฮ รโตฮ ยุ อาึ ตึน ซ ยุฮ ยุม ไม่ เยอะ,” อัฮ เซ คาอิน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","พะจาว อัฮ เฮี, “มัฮ โตว ตอก เซ. ดัฮ ไก ป ยุฮ ยุม ไม่ ปะ อา, ปุย เซ ซ ลอก ตุต ฆาื อื อาแลฮ เตะ เซ เอิน,” อัฮ เซ ละ คาอิน. เญือม เซ พะจาว ไม อาึง คาอิน ติ เจือ, นึง ซ แปน อื ควน เกือฮ ปุย ยุง โอ แตะ ไมจ ยุฮ ยุม ไม่ อื เญือม รโตฮ อื ยุ คาอิน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","คาอิน โอก ซไง ฮา ก อาวต พะจาว. อาวต นึง เมือง โนต, บลัฮ รปึม เอเด่น เซ ลวง ลั่ก โอก ซเงะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","คาอิน ไม่ ปรโปวน เญือะ อื โฮลฮ กวน รเมะ แตะ ติ. อัฮ เอโนก ละ อื. เญือม เกิต เอโนก เซ คาอิน ปุก เญือม ตัง อื ย่วง ติ. ลอต อัฮ ย่วง เอโนก ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","กังเคะ เอ เอโนก เซ ไก โรฮ กวน รเมะ, มอยฮ อื มัฮ อิรัต. อิรัต เซ มัฮ เปือะ เมฮุยาเอน. เมฮุยาเอน เซ มัฮ เปือะ เมทูชาเอน. เมทูชาเอน เซ มัฮ เปือะ ลาเมก. ");
INSERT INTO lcp_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ลาเมก เซ ไก ปรโปวน เญือะ ลอา ปุย. มอยฮ อื มัฮ อาด่า ไม่ ซินลา. ");
INSERT INTO lcp_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","กวน อาด่า เซ มัฮ ยาบั่น. โม ป อาวต นึง พากัง เมือ โรง อื ละ ซ เลียง แตะ ซัตซิง เอีจ มัฮ จัตเจือ ยาบั่น เซ. ");
INSERT INTO lcp_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ปุ ยาบั่น เซ มัฮ ยูบั่น. โม ป เกง นึง เตียต แตะ ซึง โฮวน ไซ ไม่ โม ป เกียฮ ปาึง เปี มัฮ จัตเจือ ยูบั่น เซ. ");
INSERT INTO lcp_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ซินลา ไก โรฮ กวน รเมะ ติ. มอยฮ อื มัฮ ทูบั่นคาอิน. ปุย เซ มัฮ จังเคือง เกียฮ แตม โอเอีฮ นึง ไร ซเงี ไม่ ไร เฮลีจ. รนัน ทูบั่นคาอิน เซ มัฮ นาอามา. ");
INSERT INTO lcp_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ลาเมก อัฮ เฮี ละ ปรโปวน เญือะ แตะ นึง รซอม แล่ แตะ, “อาด่า, ซินลา, ง่อต ที ลปุง อาึ เฮี. ไก ปรเมะ นุม ติ ปุย, เคียต ปุฮ อาึ. อาึ ปังเมอ โรก เอิน ละ อื ปอ ยุม อื. ");
INSERT INTO lcp_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ปุย ดัฮ ยุฮ ยุม ไม่ คาอิน โฮ, จัมเปน ลอก ตุต แตะ ฆาื อื อาแลฮ เตะ. ดัฮ มัฮ ตอก เซ, ปุย ยุฮ ยุม ไม่ อาึ อื ปังเมอ ซ ลอก เอิน ตุต แตะ ฆาื อื อาลแฆลฮ โรฮ อาแลฮ เตะ เอิน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","กังเคะ เอ, อาดั่ม ไม่ เอวา เซ ไก แม โรฮ กวน รเมะ อื. เญือม เซ เอวา อัฮ เฮี, “พะจาว เอีจ เกือฮ แม กวน รเมะ เนิ ตัง เฮเบ่น ป ยุฮ คาอิน ยุม ไม่ เซ,” อัฮ เซ. ปุก มอยฮ กวน แตะ เซ. อัฮ เซต ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","เซต เซ ไก โรฮ กวน รเมะ ติ. อัฮ เอโนต ละ อื. มัฮ เญือม เซ เญือม อัฮ โรง ปุย พะเยโฮวา เญือม ไววอน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ไลลวง เฮี มัฮ ไลลวง จัตเจือ อาดั่ม. เญือม ยุฮ พะจาว ปุย มัฮ ยุฮ อื ตอก ฮุป ฮอย โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ยุฮ อื เตือง ปรเมะ ปรโปวน. ซเงะ เซ พะจาว ปิฮ มุ่น ละ อื. อัฮ โรฮ ปุย ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","เญือม ไก อาญุ อาดั่ม 130 เนอึม เมอ ไก กวน รเมะ ติ. ตอก เอิน เปือะ แตะ ไอฮ. ปุก มอยฮ อื. อัฮ เซต ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","ฟวยจ เกิต เซต เซ อาดั่ม ไอม ลั่ง 800 เนอึม. โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","อาญุ อื ฮาวก 930 เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","เญือม ไก อาญุ เซต 105 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. มัฮ เอโนต. ");
INSERT INTO lcp_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ฟวยจ เกิต เอโนต เซ เซต ไอม ลั่ง 807 เนอึม. โฮลฮ โรฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","อาญุ อื ฮาวก 912 เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","เญือม ไก อาญุ เอโนต 90 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. มัฮ เคนัน. ");
INSERT INTO lcp_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ฟวยจ เกิต เคนัน เซ เอโนต ไอม ลั่ง 815 เนอึม. โฮลฮ โรฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","อาญุ อื ฮาวก 905 เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","เญือม ไก อาญุ เคนัน 70 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. มัฮ มาฮะลาเลน. ");
INSERT INTO lcp_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ฟวยจ เกิต มาฮะลาเลน เซ เคนัน ไอม ลั่ง 840 เนอึม. โฮลฮ โรฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","อาญุ อื ฮาวก 910 เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","เญือม ไก อาญุ มาฮะลาเลน 65 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. มัฮ ยาเรต. ");
INSERT INTO lcp_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ฟวยจ เกิต ยาเรต เซ มาฮะลาเลน ไอม ลั่ง 830 เนอึม. โฮลฮ โรฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","อาญุ อื ฮาวก 895 เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","เญือม ไก อาญุ ยาเรต 162 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. มัฮ เอโนก. ");
INSERT INTO lcp_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ฟวยจ เกิต เอโนก เซ ยาเรต ไอม ลั่ง 800 เนอึม. โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","อาญุ อื ฮาวก 962 เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","เญือม ไก อาญุ เอโนก 65 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. มัฮ เมทูเซลา. ");
INSERT INTO lcp_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ฟวยจ เกิต เมทูเซลา เซ เอโนก รโจะ ดิ เนอึม รพาวม แตะ ไม่ พะจาว. เอโนก เซ อาวต นัม พะจาว 300 เนอึม. โฮลฮ โรฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","อาญุ เอโนก เตือง โอยจ อื ไก 365 เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","เอโนก รโจะ เนอึม รพาวม แตะ ไม่ พะจาว ฮอยจ ละ ไฆร แตะ. ไก โตว ป ยุ นึง เอีจ ตุย พะจาว อื. ");
INSERT INTO lcp_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","เญือม ไก อาญุ เมทูเซลา 187 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. มัฮ ลาเมก. ");
INSERT INTO lcp_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ฟวยจ เกิต ลาเมก เซ เมทูเซลา ไอม ลั่ง 782 เนอึม. โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","อาญุ อื ฮาวก 969 เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","เญือม ไก อาญุ ลาเมก 182 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. ");
INSERT INTO lcp_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ปุก มอยฮ อื. อัฮ โนอา ละ อื. อัฮ เฮี, “เอะ โฮลฮ ยุฮ กัน โซะ กัน เชียน เคียง อัฮ พะจาว ป โซะ ละ ปลัฮเตะ เฮี. กวนดุ เฮี ปังเมอ ซ เกือฮ เอะ โฮลฮ รพาวม ไมจ มวน แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ฟวยจ เกิต โนอา เซ ลาเมก ไอม ลั่ง 595 เนอึม. โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","อาญุ ลาเมก ฮาวก 777 เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","เญือม ไก อาญุ โนอา 500 เนอึม เมอ ไก กวน ลอวย. มัฮ เชม ไม่ ฮาม ไม่ ยาเฟต. ");
INSERT INTO lcp_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","เญือม เอีจ พรุฮ ปุย นึง ปลัฮเตะ โฮวน เนอ, เอีจ โฮวน โรฮ ไม่ กวน รโปวน อื. ");
INSERT INTO lcp_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","เญือม เซ โม ป อัฮ ปุย มัฮ กวน รเมะ พะจาว แลน กวน รโปวน ปุย ปลัฮเตะ. ยุ ไมจ อื. เลือก ป ปุก รพาวม แตะ นึง อื. เกือฮ อื แปน ปุย เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","เญือม เซ พะจาว อัฮ เฮี, “อาึ ซ เกือฮ โตว ลปุ แตะ อาวต ลอป ไม่ ปุย ปลัฮเตะ นึง มัฮ อื เนะซอัง ทัมมด่า. เวลา ซ เกือฮ อาึ ละ อื ซ ไก ติ รอย ไม่ ง่า เนอึม โน่ง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","เญือม ไอฮ กวน พะจาว ปุ แตะ ไม่ กวน รโปวน ปุย ปลัฮเตะ เซ ไก กวน ไม่ ปุ แตะ. แปน ปุย ระ ปุย ฮลาวง ไม่ เกง แตะ ง่อน. แปน ปุย พรุ มอยฮ ปอยฮ โด่วง นึง ปลัฮเตะ เฮี เจน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","พะจาว ยุ ยุฮ ปุย กัน ฆอก กัน เบร โฮวน เจือ นึง ปลัฮเตะ เฮี. ยุ ป คิต ป ง่อต ปุย โตะ รพาวม แตะ. มัฮ ลอป ป ฆอก ละ อื โน่ง. ");
INSERT INTO lcp_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","เญือม เซ พะจาว ไกลฮ นึง ยุฮ แตะ ปุย ฆาื อื นึง ปลัฮเตะ. ไลจ รพาวม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","พะจาว อัฮ เฮี, “อาึ ซ ยุฮ ไลจ ไม่ ปุย ยุฮ แตะ เฮี, เตือง ปุย เตือง โกะพริ โกะย่วง, เตือง ไซม ไล่ ไม่ ซัตซิง โฮว ลังเตะ โครยญ เจือ. ซ เกือฮ ไฆร ฮา ปลัฮเตะ เตือง โอยจ อื นึง ไกลฮ แฮะ นึง ยุฮ แตะ โอเอีฮ โม เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","เจน เซ มัฮ โนอา โน่ง ป ปุก รพาวม พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","เฮี มัฮ ไลลวง โนอา. ลลาึง ปุย ติ เจน เซ มัฮ โนอา โน่ง ป มัฮ ปุย ซืไซ ละ พะจาว นึง อื. มัฮ ปุย ไมจ ไล โครยญ เจือ. รโจะ ลอป รพาวม แตะ ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","โนอา ไก กวน รเมะ ลอวย, มอยฮ อื มัฮ เชม ติ, ฮาม ติ, ยาเฟต ติ. ");
INSERT INTO lcp_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","เญือม เซ ปุย ปลัฮเตะ มัฮ ป รแอม ซเออึม ลโฮก โตะ รพาวม ละ ยุ พะจาว อื. ปลัฮเตะ นาวก นึง ป ฆอก ป เบร ป กอยจ ป ราวม โฮวน เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","พะจาว ชวน ปุย ปลัฮเตะ, มัฮ ป ฆอก ละ อื โครยญ เจือ. ปุย ปลัฮเตะ เอีจ พลวย ติ แตะ ละ ยุฮ แตะ ป โอ ปุก เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","พะจาว อัฮ เฮี ละ โนอา, “อาึ เอีจ โปวต รพาวม แตะ ละ ซ ยุฮ แตะ ไลจ ไม่ ปุย เตือง ปลัฮเตะ อาวต อื. มัฮ ฆาื เอีจ นาวก ปลัฮเตะ นึง ป ฆอก ป เบร ป กอยจ ป ราวม ป ซ ยุฮ อาึ ไลจ ไม่ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","มัฮ เซ ป ไมจ เปอะ ยุฮ โล่ง ระ ฆาื อื ละ เญือะ โกะ เปอะ ไอฮ, ยุฮ นึง โคะ ฆิ โกเฟอ. ยุฮ แปน คัก แปน คัก แตะ. ตา ยั่ง นึง เตือง ก พริ กไน อื. ");
INSERT INTO lcp_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ไมจ เปอะ ยุฮ ตอก เฮี, เกือฮ ลั่ง ลอวย รอย รเนฮ. เกือฮ เวือฮ รฮอน รเนฮ. เกือฮ ฮลาวง ง่วย รเนฮ. ");
INSERT INTO lcp_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ไมจ โรฮ เปอะ เกือฮ โบฮ โบ พรัง อื ติ รเนฮ ไคว อื. ยุฮ โรฮ ไม่ โตะ รเวือะ เฆียง อื ติ. โล่ง เซ เกือฮ ไก ลอวย คัก. ");
INSERT INTO lcp_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ไตม อาึง, อาึ ซ เกือฮ รอาวม เลอึป ปลัฮเตะ เตือง โอยจ อื, ละ ซ เกือฮ แตะ โอเอีฮ ป ไก รพาวม ติ ฆรึม มะลอง ไลจ. เมาะ ป ไก นึง ปลัฮเตะ ซ ยุม แกล. ");
INSERT INTO lcp_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","อาึ ซ เกือฮ ตอน ลปุง ซันญา แตะ ไม่ ปะ เฮี. ปะ ซ โฮลฮ เปอะ เลียก โตะ โล่ง เฮี, เตือง ปะ เตือง กวน เปอะ, เตือง ปุย เญือะ เปอะ เตือง โมวน เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ซัตซิง ไมจ โรฮ ปะ ซเพระ ติ เจือ ติ กู, เกือฮ โรฮ เลียก ไม่ เปอะ โตะ โล่ง เซ ละ ซ เกือฮ เปอะ ไอม ไม่ แตะ. ไอฮ ป ไฮมญ อื ติ ไม่ ปรโปวน อื ติ โครยญ เจือ อื. ");
INSERT INTO lcp_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ไซม ไล่ ไม่ โกะพริ โกะย่วง, ไม่ ซัตซิง ป โฮว ลังเตะ เตือง โอยจ อื, ซ ฮอยจ เคะ เปอะ ติ เจือ ติ กู ตัม เจือ แตะ ไอฮ โครยญ เจือ ละ ซ เกือฮ ปะ อื ไอม. ");
INSERT INTO lcp_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ไมจ โรฮ เปอะ ซาวป แฮรน ป โซม ละ โกะ แตะ ไม่ ละ ซัตซิง โม เซ โครยญ เจือ โรฮ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","โนอา ยุฮ เนอึม อื ตอก อัฮ พะจาว อื ละ แตะ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","เญือม เซ พะจาว อัฮ เฮี ละ โนอา, “ปะ ไมจ เปอะ โฮว เลียก อาวต นึง โตะ โล่ง ระ เซ เตือง เญือะ เปอะ โรฮ. ปุย ติ เจน เฮี อาึ เอีจ ยุ อุ, มัฮ ปะ โน่ง ป ซืไซ นึง อื ละ อาึ อื. ");
INSERT INTO lcp_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ไมจ เปอะ โรวก ซัตซิง ป ซง่ะ ไล อื โครยญ เจือ, ติ เจือ อาแลฮ กู เตือง ป ไฮมญ ปรโปวน อื. ซัตซิง โอ ซง่ะ ไล นึง อื ไมจ เปอะ โรวก ติ เจือ ติ กู, เตือง ป ไฮมญ ปรโปวน อื. ");
INSERT INTO lcp_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ไซม ไมจ โรฮ เปอะ โรวก ติ เจือ อาแลฮ กู, เตือง ป ไฮมญ ปรโปวน อื, ละ ซ โฮลฮ อื ซึป ลั่ง เจือ แตะ นึง ปลัฮเตะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ไก ลั่ง อาแลฮ ซเงะ กา ซ เกือฮ อาึ พริ เฮละ รปาวน ซเงะ รปาวน ซาวม เมอ. โอเอีฮ เมาะ ป ไก รพาวม ป เอีจ ยุฮ ฮุ เซ, อาึ ซ ยุฮ ไลจ ไม่ เกือฮ ไฆร ฮา ปลัฮเตะ เตือง โอยจ อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","โนอา ยุฮ เนอึม อื ตัม ป อัฮ พะจาว ละ แตะ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","เญือม เลอึป รอาวม ปลัฮเตะ เซ โนอา ไก อาญุ แลฮ รอย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","โนอา ไม่ ปุย เญือะ อื ไม่ กวน ไม่ โมวน อื เลียก ดิ โตะ โล่ง เซ, ละ ซ เกือฮ อื ติ แตะ โปน ฮา รอาวม ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ซัตซิง เมาะ ป ซง่ะ ไล ไม่ ป โอ อื ซง่ะ ไล ไม่ ไซม ไม่ ซัตซิง ป โฮว ลังเตะ เตือง โอยจ อื, ");
INSERT INTO lcp_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ฮอยจ เคะ โนอา แปน กู แปน กู แตะ เตือง ป ไฮมญ ปรโปวน อื. โนอา เลียก ไม่ อื โตะ โล่ง เซ ตอก เอีจ อัฮ พะจาว อาึง ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ฟวยจ เซ อาแลฮ ซเงะ รอาวม ระ ฮอยจ เนอึม นึง ปลัฮเตะ. ");
INSERT INTO lcp_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","เญือม ไก อาญุ โนอา แลฮ รอย เนอึม เมอ, ปุก ฮาวก เคิ ลอา กาว โรฮ อาแลฮ ซาวม, ซเงะ เซ รอาวม ระ ก โด่ะ อื เซ จาึฮ โอก เน่อึม ฆรึม เตะ. ระ ลัมเลือ เฮละ นึง ตอก ป โทก ป โซ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","เฮละ รปาวน ซเงะ รปาวน ซาวม เอิน. ");
INSERT INTO lcp_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","โนอา ไม่ ปุย เญือะ อื ไม่ กวน อื ป มัฮ เชม, ฮาม, ยาเฟต, ไม่ โมวน อื เตือง ลอวย อื, เลียก ดิ โตะ โล่ง เซ ซเงะ เซ เอิน. ");
INSERT INTO lcp_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","โกะพริ โกะย่วง ไม่ ซัตซิง ป โฮว ลังเตะ ไม่ ไซม ไล่ โครยญ เจือ เลียก โรฮ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","โอเอีฮ เมาะ ป ไก รพาวม โครยญ เจือ ฮอยจ เคะ โนอา. เลียก ไม่ อื โตะ โล่ง เซ แปน กู แปน กู แตะ, เตือง ป ไฮมญ ป ปรโปวน อื, ตอก เอีจ อัฮ พะจาว อาึง ละ อื. ฟวยจ เซ พะจาว ซอง รเวือะ โล่ง เซ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ไน รปาวน ซเงะ เซ รอาวม ฮาวก แนฮ ปุๆ ปอ เอิน ตอยฮ โล่ง เซ ฮอยจ ก ฮลาวง อื. ");
INSERT INTO lcp_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","รอาวม ระ แนฮ ลั่ง ปุๆ ปอ เลอึป อื ปลัฮเตะ. โล่ง เซ ตอยฮ แนฮ ราว รอาวม. ");
INSERT INTO lcp_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","รอาวม เซ ฮาวก ฮอยจ ละ เลอึป อื เปือง โม เปือง มอยจ ติ ฆรึม มะลอง เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ฮาวก เอิน ฮลาวง ฮา เปือง โม กาว โรฮ พอน รเนฮ. ");
INSERT INTO lcp_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","โม ไซม ไล่ ไม่ โกะพริ โกะย่วง ไม่ ซัตซิง ป โฮว ลังเตะ ไม่ ปุย เตือง โอยจ อื, ");
INSERT INTO lcp_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","เมาะ ป ไก รพาวม นึง ปลัฮเตะ ยุม เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","พะจาว ยุฮ เนอึม ไลจ ไม่ โอเอีฮ ป ไก นึง ปลัฮเตะ, เตือง ปุย เตือง โกะพริ โกะย่วง ไม่ ไซม ไล่ เตือง โอยจ อื. มัฮ โนอา ไม่ โม ป อาวต ไม่ อื โตะ โล่ง เซ โน่ง ป ไอม ลั่ง เงอ. ");
INSERT INTO lcp_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ไก ติ รอย ไม่ รฮอน ซเงะ เลอึป รอาวม ปลัฮเตะ เอ. ");
INSERT INTO lcp_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","พะจาว โตก ละ โนอา ไม่ โกะพริ โกะย่วง อาวต ไม่ อื โตะ โล่ง เซ. เญือม เซ พะจาว เกือฮ กาื บาึง ราว ปลัฮเตะ ละ ซ เกือฮ อื รอาวม เซ เน่ฮ. ");
INSERT INTO lcp_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","รอาวม ฆรึม เตะ เญือะ จาึฮ โตว โอก. พริ ปุ โรฮ เญือะ เฮละ นึง เอีจ เกือฮ พะจาว อื โอง. ");
INSERT INTO lcp_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","รอาวม เลอึป ปลัฮเตะ เซ เน่ฮ ปุ ปุ. เญือม เอีจ โปน อื ฮา ติ รอย ไม่ รฮอน ซเงะ เซ เอีจ เน่ฮ รอาวม เมอ. ");
INSERT INTO lcp_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","โล่ง เซ คัง นึง บลาวง อะรารัต. เญือม คัง อื เซ ปุก ฮาวก เคิ อาแลฮ เซ กาว โรฮ อาแลฮ ซาวม. ");
INSERT INTO lcp_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","รอาวม เซ เน่ฮ แนฮ ปุๆ ฮอยจ ละ เคิ กาว. เญือม เอีจ ฮาวก เคิ กาว ติ ซาวม เมอ, เปือง โม เอีจ ปลาึฮ ปอ ชวน ปุย อื. ");
INSERT INTO lcp_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ฟวยจ เซ รปาวน ซเงะ แม โนอา โปฮ รเวือะ นาตัง โล่ง ยุฮ แตะ เซ, พลวย รงั่ก ติ ตัว. ");
INSERT INTO lcp_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","รงั่ก เซ โปว ไป โปว มา ฮอยจ ละ ไฮจ รอาวม นึง ปลัฮเตะ. ");
INSERT INTO lcp_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","เญือม เซ พลวย โรฮ รโกะเกอื ติ นึง ฆวต ยุง แตะ เมาะ ไฮจ รอาวม ฮา ปลัฮเตะ. ");
INSERT INTO lcp_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","รโกะเกอื เซ แมๆ ละ โล่ง เซ นึง โอ อื ยุ ก ซ จัป แตะ, นึง เลอึป ลั่ง รอาวม ปลัฮเตะ ละ อื เตือง โอยจ อื. โนอา ซนาว เตะ แตะ เดือะ เชือน อื เกือฮ เลียก แม โตะ โล่ง ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","มอง แม อื อาแลฮ ซเงะ. พลวย แม รโกะเกอื เซ ติ โฮน. ");
INSERT INTO lcp_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","เญือม เอีจ ฮลอง บู เยอ, รโกะเกอื เซ ปวก โรวก ฮละ กาวก ไอม นึง รฆุฮ แตะ. เอีญ แม ไม่ อื. เญือม เซ โนอา ยุง เอิน เอีจ ไฮจ รอาวม ฮา ปลัฮเตะ. ");
INSERT INTO lcp_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","โนอา มอง แม อื อาแลฮ ซเงะ. ฟวยจ เซ พลวย แม รโกะเกอื เซ ติ โฮน แม. รโกะเกอื เซ ลอต โอ เญือะ เอีญ. ");
INSERT INTO lcp_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","เญือม ไก อาญุ โนอา แลฮ รอย ไปล ติ เนอึม, ปุก ฮาวก เคิ ติ เซ ติ ซาวม, เอีจ ไฮจ รอาวม นึง ปลัฮเตะ เอ. โนอา ตอฮ พรัง โล่ง ยุฮ แตะ ละ ซ แก แตะ ปลัฮเตะ. เญือม แก อื ชวน เอีจ ซออฮ ปลัฮเตะ. ");
INSERT INTO lcp_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","เญือม เอีจ ฮาวก เคิ ลอา ง่า โรฮ อาแลฮ ซาวม เมอ, เอีจ ซออฮ เตือง โอยจ อื ปลัฮเตะ เอ. ");
INSERT INTO lcp_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","เญือม เซ พะจาว อัฮ เฮี ละ โนอา, ");
INSERT INTO lcp_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ปะ ไม่ ปุย เญือะ เปอะ ไม่ กวน ไม่ โมวน เปอะ, ไมจ เปอะ โอก ฮา โล่ง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","โอเอีฮ เมาะ ป ไก รพาวม ป อาวต ไม่ เปอะ เซ เตือง ไซม ไล่ ไม่ โกะพริ โกะย่วง ไม่ ซัตซิง ป โฮว ลังเตะ โครยญ เจือ เกือฮ โรฮ โอก ไม่ เปอะ ละ ซ พรุฮแพร อื นึง ปลัฮเตะ เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","โนอา โอก เนอึม ไม่ ปุย เญือะ แตะ ไม่ กวน ไม่ โมวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","โม โกะพริ โกะย่วง ไม่ ไซม ไล่ โอเอีฮ เซ โอก ตื ฮา โล่ง เซ, อาวต ตัม เจือ แตะ ไอฮ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","เญือม เซ โนอา รชุก ซโมะ ละ ซ ยุฮ แตะ คัน ไว แตะ พะจาว นึง. ตุย ซัตซิง ไม่ ไซม ป ซง่ะ ไล อื ละ มอก แตะ ตอง ทไว ละ พะจาว นึง คัน เซ ง่อน. ");
INSERT INTO lcp_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","เญือม อาวม พะจาว ซออย ฮงาื อื อัฮ เฮี โตะ รพาวม แตะ, “อาึ เญือะ ซ ยุฮ โตว ไลจ ไม่ ปลัฮเตะ เฮี, ปัง คิต ลอป ปุย ป ฆอก โตะ รพาวม แตะ เน่อึม เญือม มัฮ ลั่ง แตะ กวนดุ, อาึ เญือะ ซ ยุฮ โตว ไลจ ไม่ โอเอีฮ ป ไก จีวิต นึง ปลัฮเตะ ฆาื อื ตอก ยุฮ แตะ โฮน เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","ติ เจน ไก ลั่ง ปลัฮเตะ เฮี, แจง ซ ไก เญือม โม่ ไม่ เญือม มัก, เญือม โฆยญ ไม่ เญือม ฮรวน, เญือม แลง ไม่ เญือม เฮละ, ไก ซเง่ะ ไม่ รซาวม นึง อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","พะจาว ปิฮ มุ่น ละ โนอา ไม่ กวน อื. อัฮ เฮี ละ อื, “เกือฮ ติ เปอะ พรุฮแพร ปอ นาวก เปอะ ยุฮ ปลัฮเตะ. ");
INSERT INTO lcp_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","อาึ ซ เกือฮ โกะพริ โกะย่วง ไม่ ไซม ไล่ ไม่ ซัตซิง ป โฮว ลังเตะ ไม่ กะ เตือง โอยจ อื ฮลัต นึง โม เปะ. ซ เกือฮ โม เปะ โฮลฮ ตัตเตียง. ");
INSERT INTO lcp_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","โตะ โอเอีฮ ป ไก จีวิต นึง ปลัฮเตะ ซ แปน ป โซม ป ปอน ละ เปอะ เตือง โอยจ อื. อาึ เกือฮ ละ โม เปะ โครยญ เจือ ตอก เอีจ เกือฮ โรฮ แตะ เฮงาะ รโกะ ไม่ พักเญือ ละ เปอะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“โตะ โอเอีฮ ป ไก ลั่ง ไม่ ฮนัม อื ปังเมอ โอ เปอะ ไมจ ปอน, นึง มัฮ ฮนัม อื เซ จีวิต อื. ");
INSERT INTO lcp_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","ดัฮ ไก ป ยุฮ ยุม ไม่ ปุย, อาึ ซ เกือฮ ลอก ตุต แตะ ฮอยจ ละ ยุม อื. ปัง มัฮ ซัตซิง ดัฮ ยุฮ ยุม ไม่ ปุย ซ เกือฮ โรฮ ยุม ฆาื อื ตอก เซ โรฮ. ซ เกือฮ ปุย ลอก ตุต ตัม กัน ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","ป ยุฮ ยุม ไม่ ปุย ไมจ โรฮ ปุย ยุฮ ยุม ไม่ โกะ อื โรฮ. มัฮ ฆาื ยุฮ พะจาว ปุย ตัม ฮุปฮอย โกะ แตะ ไอฮ ป ไมจ อื ยุฮ ตอก เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","“โม เปะ ไมจ เปอะ เกือฮ ติ แตะ พรุฮแพร. เกือฮ โม เปะ ไก กวน รเมะ โฮวน, กวน รโปวน บื, ปอ นาวก อื ยุฮ ปลัฮเตะ เฮี,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ฟวยจ เซ พะจาว อัฮ อื ละ โนอา ไม่ กวน อื ป อาวต ไม่ อื เซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ง่อต แลน, อาึ ซ เกือฮ ตอน ลปุง ซันญา แตะ ไม่ โม เปะ ฮอยจ ละ โม จัตเจือ เปอะ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ฮอยจ โรฮ ละ ซัตซิง เมาะ ป โอก ไม่ เปอะ ฮา โล่ง เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ลปุง ซันญา เกือฮ อาึ ละ เปอะ มัฮ ตอก เฮี, เฆิม เฮี อาึ เญือะ ซ เกือฮ โตว โอเอีฮ เตือง โอยจ อื ยุม แม ฆาื เลอึป รอาวม แตะ. เญือะ ซ ไก โตว รอาวม ป ซ ไลจ ยุฮ ปลัฮเตะ เอ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","พะจาว อัฮ แม เฮี, “เอีจ มัฮ เฮี ป มัฮ ควน เกือฮ ปุย ไตม ลปุง ซันญา อาึ อาึง ไม่ โม เปะ เอ, ฮอยจ ละ ซัตซิง โอเอีฮ ไม่ จัตเจือ เปอะ เฆียง เฮี เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","อาึ ซ เกือฮ รยุง โกฮ ละ เปอะ นึง ชุต รวู. ซ แปน ควน โตก อาึ ละ ลปุง ซันญา แตะ ไม่ ปุย ปลัฮเตะ. ");
INSERT INTO lcp_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","เญือม เกือฮ อาึ ชุต รวู ฮอยจ ราว ปลัฮเตะ ดัฮ ยุ โกฮ รยุง นึง อื, อาึ ซ ไตม ลปุง ซันญา แตะ ไม่ โม เปะ ไม่ ซัตซิง โอเอีฮ โครยญ เจือ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","เญือะ ซ ไก โตว รอาวม ฮาวก ยุฮ ไลจ ไม่ โอเอีฮ ป ไก รพาวม เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ดัฮ รยุง เอีจ โกฮ นึง ชุต รวู อาึ ซ แก เยอะ ไม่ ซ ไตม เมอะ ลปุง ซันญา โอ เญาะ ไก ลอยจ แตะ ไม่ โม เปะ. มัฮ ลปุง ซันญา อาึ ไม่ โอเอีฮ เมาะ ป ไก จีวิต นึง ปลัฮเตะ เฮี เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","เอีจ มัฮ รยุง เซ ควน ไตม อาึ ลปุง ซันญา แตะ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","กวน โนอา ป โอก ดิ ไม่ อื ฮา โล่ง เซ มัฮ เชม, ไม่ ฮาม, ไม่ ยาเฟต. ฮาม เซ มัฮ เปือะ คะนาอัน. ");
INSERT INTO lcp_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ปุย ติ ปลัฮเตะ ป โฮว อาวต โครยญ โดฮ เซ, มัฮ ตื จัตเจือ กวน โนอา เตือง ลอวย อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","โนอา มัฮ ป ซมา ลโลวง โอเอีฮ โฮวน เจือ. ลอง แลน ยุฮ รปึม อะงุน ติ โดฮ. ");
INSERT INTO lcp_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","เญือม ญุ อื รอาวม อะงุน เซ ญุ่ยจ ฆาื อื. ปอยจ เครอึง แตะ. ไอจ ฆาวง โตะ พากัง อาวต แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ฮาม ป มัฮ เปือะ คะนาอัน เซ เลียก แก อื. โฮว อู อื ละ เอียกระ เอียกตุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","เญือม เซ เชม ไม่ ยาเฟต ตุย เฟีย ติ ปลัฮ, ไปญ ดิ เฟีย เซ, ติ ปุย ติ ก บลัฮ, ไปญ อื บริญ ไม่ ซอังปา แตะ, ราึต ปุ เลียก ลั่กเคะ แตะ ฮอยจ เคะ เปือะ แตะ, เลอึป อื นึง เฟีย เซ. นา โตว ลั่ก เปือะ แตะ ละ ซ เกือฮ อื ติ แตะ โอ ยุ อาวต ฆาวง เปือะ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","เญือม เอีจ ซวง แม โนอา เยอ, ฮมอง ป ยุฮ กวน รเคะ แตะ เซ ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","อัฮ เฮี ฆาื อื, “เกือฮ เญือะ คะนาอัน ลอก ป โอยจ นึง โซะ แตะ. เกือฮ โฮลฮ แปน ครา เซีญ เอียกปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","ปัว พะจาว ทื อาึ ปิฮ มุ่น ละ เชม. เญือะ คะนาอัน ซ โฮลฮ แปน ครา เซีญ เญือะ เชม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ปัว พะจาว เกือฮ เญือะ ยาเฟต พรุฮแพร. เกือฮ จัตเจือ อื โฮลฮ อาวต ดิ ไม่ จัตเจือ เชม. เกือฮ โม คะนาอัน แปน ครา เซีญ อื,” อัฮ เซ โนอา เยอ. ");
INSERT INTO lcp_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ฟวยจ เลอึป รอาวม ปลัฮเตะ โนอา ไอม ลั่ง 350 เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","อาญุ โนอา เตือง โอยจ อื ฮาวก 950 เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ไลลวง เฮี มัฮ ไลลวง จัตเจือ ป เกิต เน่อึม นึง กวน โนอา ป มัฮ เชม, ฮาม, ไม่ ยาเฟต. เอีจ มัฮ ป เกิต ละ อื ฟวยจ เลอึป รอาวม ปลัฮเตะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","กวน ยาเฟต มอยฮ อื มัฮ ตอก เฮี. โกเมอ, มาโกก, มาได่, ยาวัน, ทูบั่น, เมเชก, ไม่ ทิรัต. ");
INSERT INTO lcp_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","กวน โกเมอ เซ มัฮ อัตเคนัต, ริฟัต, ไม่ โทกามา. ");
INSERT INTO lcp_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","กวน ยาวัน เซ มัฮ เอลีชา, ทาระชิต, คิตทิม, ไม่ โด่ด่านิม. ");
INSERT INTO lcp_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ปุย อาวต เฆียง รอง ปลัฮ รอาวม ไม่ เกาะ โฮวน โดฮ เซ มัฮ ป ซึป เจือ แตะ เน่อึม นึง ปุย โม เซ. ตัง โคน ตัง อาวต เมือง โกะ แตะ ตัม ลปุง โกะ แตะ ไอฮ เตือง ไพ เตือง มัน. อาวต ตัม จัตเจือ แตะ ไอฮ โครยญ เมือง โครยญ ปะเทต. ปุย โม เซ มัฮ ตื จัตเจือ ยาเฟต. ");
INSERT INTO lcp_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","กวน ฮาม มอยฮ อื มัฮ ตอก เฮี. คุต, อียิป, พุต, ไม่ คะนาอัน. ");
INSERT INTO lcp_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","กวน คุต เซ มัฮ เซบ่า, ฮาวิลา, ซัปทา, ราอามา, ไม่ ซัปเทคา. กวน ราอามา เซ มัฮ เชบ่า ไม่ เด่ดั่น. ");
INSERT INTO lcp_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","นิมโรต มัฮ โรฮ จัตเจือ คุต เซ. นิมโรต เซ มัฮ ปุย เกง นึง กัน ตัตเตียง แตะ ปุย นึง อัมนัต แตะ กา ปุย ไฮญ. ");
INSERT INTO lcp_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","นิมโรต มัฮ โรฮ ป เกือฮ ติ แตะ เกง ซองนา พะจาว นึง กัน ริ แตะ ซัตซิง. ปุย ไพรม อัฮ เฮี ฆาื อื, “เอีจ เกือฮ ติ แตะ เกง ซองนา พะจาว ตอก นิมโรต ป กอ ปุน ซัตซิง โฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","เมือง ปุน เตียง นิมโรต เซ เมือ โรง อื มัฮ เมือง บ่าบี่โลน ไม่ เมือง เอเรก ไม่ เมือง อักคัต. เมือง เตือง ลอวย อื เซ ไก นึง แควน เมือง ชินา. ");
INSERT INTO lcp_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","นิมโรต โอก เน่อึม นา เซ โฮว แม ฮอยจ เมือง อัตซีเรีย. ยุฮ เวียง นีนะเว ไม่ เวียง เรโฮโบ่ตอิน ไม่ เวียง คาลา ไม่ เวียง เรเซน. ");
INSERT INTO lcp_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","เวียง เรเซน เซ มัฮ เวียง ระ ซน่ะ เวียง นีนะเว ไม่ เวียง คาลา. ");
INSERT INTO lcp_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","อียิป เซ ไก จัตเจือ โฮวน. มัฮ โม ลูดิ่ม, โม อานามิม, โม เลฮะบิ่ม, โม นัปทูฮิม, ");
INSERT INTO lcp_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","โม ปัตรุซิม, โม คัตลูฮิม, ไม่ โม คัปโทริม. โม ฟีลิซเตีย ซึป เจือ แตะ เน่อึม นึง โม คัปโทริม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","กวน โรง คะนาอัน เซ มัฮ ไซด่อน. ฟวยจ เซ ปุ ทัต อื มัฮ เฮต, ");
INSERT INTO lcp_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","โม เยบุ่ต, โม อาโมไร, โม เกอกาชี, ");
INSERT INTO lcp_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","โม ฮีไว, โม อารคา, โม ซินี, ");
INSERT INTO lcp_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","โม อารวัต, โม เซเมอ, ไม่ โม ฮามัต. ปุย โม เซ มัฮ ตื จัตเจือ คะนาอัน เซ. กังเคะ เอ โม คะนาอัน เซ โฮว อาวต โน่งๆ ฮา ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ม่าื เตะ อาวต อื เซ ไก เน่อึม นึง เมือง ไซด่อน, โพต เมือง เกรา ฮอยจ ละ เมือง กาซา, ลอต ฮอยจ ละ เมือง โซโด่ม ไม่ โกโมรา ไม่ เมือง อัตมา ไม่ เมือง เซโบ่ยิม ฮอยจ ละ เมือง ลาชา. ");
INSERT INTO lcp_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","จัตเจือ ปุย โม เซ มัฮ ตื ป ซึป เจือ แตะ เน่อึม นึง ฮาม. ตัง โคน ตัง อาวต เมือง โกะ แตะ ตัม ลปุง โกะ แตะ ไอฮ ตัม จัตเจือ แตะ โครยญ เมือง โครยญ ปะเทต. ");
INSERT INTO lcp_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","เชม ป มัฮ เอียกระ ยาเฟต เซ ไก โรฮ กวน โฮวน โรฮ. โม เอเบ่อ เตือง โอยจ อื ซึป เจือ แตะ เน่อึม นึง เชม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","กวน เชม เซ มอยฮ อื มัฮ เอลัม, อัตชู, อาปักชัต, ลุต, ไม่ อารัม. ");
INSERT INTO lcp_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","กวน อารัม เซ มอยฮ อื มัฮ อุต, ฮูน, เกเทอ, ไม่ มัต. ");
INSERT INTO lcp_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","อาปักชัต เซ มัฮ เปือะ เชลา. เชลา เซ มัฮ เปือะ เอเบ่อ. ");
INSERT INTO lcp_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","เอเบ่อ เซ ไก กวน ลอา. ติ ปุย อื มอยฮ อื มัฮ เพเลก, นึง มัฮ เวลา เซ เวลา รกัฮ ปุย ฮา ปุ แตะ อาวต โน่งๆ นึง ปลัฮเตะ. ปุ เพเลก เซ มัฮ โยกทัน. ");
INSERT INTO lcp_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","โยกทัน เซ มัฮ เปือะ อันโมดั่ต, เชเลป, ฮาซามาเวต, เยรา, ");
INSERT INTO lcp_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ฮาโด่รัม, อุซัน, ดิ่กลา, ");
INSERT INTO lcp_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","โอบั่น, อาบี่มาเอน, เชบ่า, ");
INSERT INTO lcp_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","โอฟี, ฮาวิลา, ไม่ โยบั่ป. ปุย โม เซ มัฮ ตื กวน โยกทัน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","นาตี อาวต อื ไก เน่อึม นึง เมือง เมชา ลอต ฮอยจ นึง คระ เมือง เซฟา ฮอยจ ละ บลาวง ลวง โอก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","จัตเจือ โม เซ มัฮ ตื ป ซึป เจือ แตะ เน่อึม นึง เชม. ตัง โคน ตัง อาวต เมือง โกะ แตะ ตัม ลปุง โกะ แตะ ตัม จัตเจือ แตะ ไอฮ โครยญ เมือง โครยญ ปะเทต. ");
INSERT INTO lcp_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ปุย โม เซ เตือง โอยจ อื มัฮ ตื ป ซึป เจือ แตะ เน่อึม นึง กวน โนอา. ปุย ติ ปลัฮเตะ มัฮ พรุฮแพร อื ยุฮ แตะ เน่อึม นึง ปุย โม เซ. ฟวยจ เลอึป รอาวม ปลัฮเตะ เอ, ปุย โม เซ อาวต โน่งๆ เลี่ป เตะ ตัม จัตเจือ แตะ ไอฮ โครยญ เมือง โครยญ ปะเทต เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","โฆะ ลั่ง ปุย ติ ปลัฮเตะ ลปุง ติ เจือ โน่ง. อัฮ ลปุง ตอก ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","เญือม ตอ ไป ตอ มา ปุย นึง ลวง ลั่ก โอก ซเงะ เอ ยุ นา ก ลโลวง เตะ แควน เมือง ชินา ติ โดฮ, โฮว อาวต นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","เญือม เซ ปุย ตัง โคน ตัง อัฮ อื ละ ปุ แตะ ตอก เฮี, “ไมจ เอะ ยุฮ เตะ ตอง เกือฮ ไมจ โฮ,” อัฮ เซ ละ ปุ แตะ. โม เซ โกว ดิ่นจี ตัง ซโมะ, โกว โรฮ ยั่ง ตัง ซไต. ");
INSERT INTO lcp_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","เญือม เซ ปุย อัฮ เฮี ละ ปุ แตะ, “ไมจ เอะ ยุฮ เวียง ละ โม โกะ แตะ, ยุฮ ไม่ เจดี่ ฮลาวง ติ. เกือฮ เปือง อื ฮอยจ มะลอง. ไมจ เกือฮ ติ แตะ พรุ มอยฮ ปอยฮ โด่วง, เดอึม โอ ซ โฮลฮ อาวต เฮีย อาวต ไฮ เลี่ป เตะ,” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ฟวยจ เซ พะจาว เลีฮ ละ ซ แลน แตะ เวียง เซ ไม่ เจดี่ ป ยุฮ ปุย ปลัฮเตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","พะจาว อัฮ เฮี, “ง่อต แลน, ปุย โม เฮี มัฮ ปุย ติ มู. ลปุง ติ เจือ โน่ง. ปเลี่ย เฮี มัฮ เญือม ยุฮ โรง อื โอเอีฮ. เฆียง เฮี โฮว ละ ซ ระ แตะ ปุ ปุ กัน ซ ยุฮ อื. ไก โตว ป โอ อื ซ เกียฮ ยุฮ ฮู. ");
INSERT INTO lcp_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ไมจ เอะ เลีฮ ละ. ไมจ เกือฮ ลปุง อื ซุกซัก ตัง โน่ง ฮา ปุ แตะ. เกือฮ โอ เญือะ ยุง ป อัฮ ปุ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","พะจาว ยุฮ เนอึม อื ตอก เซ นึง ซ เกือฮ อื อาวต เฮีย อาวต ไฮ เลี่ป เตะ. ฟวยจ เซ ปุย เลิก เอิน ยุฮ แตะ เวียง เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","เคียง เซ เยอ ปุย อัฮ บ่าบี่โลน ไม่ เวียง เซ, นึง มัฮ อื นา ก เกือฮ พะจาว ลปุง ปุย ติ ปลัฮเตะ ซุกซัก ตัง โน่ง ฮา ปุ แตะ. มัฮ เน่อึม นา เซ นา ก เกือฮ โรง พะจาว อื อาวต เฮีย อาวต ไฮ ฮา ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","คัก เฮี มัฮ จัตเจือ เชม นึง อื. ฟวยจ เลอึป รอาวม ปลัฮเตะ ลอา เนอึม เมอ, เชม ไก อาญุ 100 เนอึม. โฮลฮ กวน รเมะ แตะ. มอยฮ อื มัฮ อาปักชัต. ");
INSERT INTO lcp_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ฟวยจ เกิต ปุย เซ เชม ไอม ลั่ง 500 เนอึม, โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","อาปักชัต เญือม ไก อาญุ อื 35 เนอึม โฮลฮ กวน รเมะ แตะ. มอยฮ อื มัฮ เชลา. ");
INSERT INTO lcp_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ฟวยจ เกิต เชลา เซ อาปักชัต ไอม ลั่ง 403 เนอึม, โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","เญือม ไก อาญุ เชลา 30 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. มัฮ เอเบ่อ. ");
INSERT INTO lcp_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ฟวยจ เกิต เอเบ่อ เซ เชลา ไอม ลั่ง 403 เนอึม. โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","เญือม ไก อาญุ เอเบ่อ 34 เนอึม เมอ ไก โรฮ กวน รเมะ ติ. มัฮ เปเลก. ");
INSERT INTO lcp_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ฟวยจ เกิต เปเลก เซ เอเบ่อ ไอม ลั่ง 430 เนอึม. โฮลฮ โรฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","เญือม ไก อาญุ อื 30 เนอึม เมอ เปเลก ไก โรฮ กวน รเมะ ติ. มัฮ เรอู. ");
INSERT INTO lcp_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ฟวยจ เกิต เรอู เซ เปเลก ไอม ลั่ง 209 เนอึม. โฮลฮ โรฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","เญือม ไก อาญุ อื 32 เนอึม เมอ เรอู ไก โรฮ กวน รเมะ ติ. มัฮ เซรุก. ");
INSERT INTO lcp_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ฟวยจ เกิต เซรุก เซ เรอู ไอม ลั่ง 207 เนอึม. โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","เญือม ไก อาญุ อื 30 เนอึม เมอ เซรุก ไก โรฮ กวน รเมะ ติ. มัฮ นาโฮ. ");
INSERT INTO lcp_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ฟวยจ เกิต นาโฮ เซ เซรุก ไอม ลั่ง 200 เนอึม. โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","เญือม ไก อาญุ อื 29 เนอึม เมอ นาโฮ ไก โรฮ กวน รเมะ ติ. มัฮ เทรา. ");
INSERT INTO lcp_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ฟวยจ เกิต เทรา เซ นาโฮ ไอม ลั่ง 119 เนอึม. โฮลฮ กวน รเมะ กวน รโปวน แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","เญือม ไก อาญุ อื 70 เนอึม เมอ เทรา ไก โรฮ กวน รเมะ ลอวย. มัฮ อัปรัม ไม่ นาโฮ ไม่ ฮารัน. ");
INSERT INTO lcp_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","คัก เฮี มัฮ จัตเจือ เทรา ป มัฮ เปือะ อัปรัม ไม่ นาโฮ ไม่ ฮารัน. ฮารัน เซ มัฮ เปือะ โลต. ");
INSERT INTO lcp_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ฮารัน เซ ยุม นึง เวียง เออ ป มัฮ เมือง เกิต แตะ เซ, มัฮ ป อาวต นึง เมือง เคนเดี่ย. เญือม ยุม อื เซ เปือะ อื ไอม ลั่ง. ");
INSERT INTO lcp_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","อัปรัม ไอฮ ซาไร แปน ปุย เญือะ แตะ. นาโฮ ไอฮ มิละคา. มิละคา ไม่ อิซคา เซ มัฮ กวน ฮารัน. ");
INSERT INTO lcp_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ซาไร เซ ไก โตว กวน นึง มัฮ อื ปุย ซแกต. ");
INSERT INTO lcp_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","เทรา โรวก อัปรัม กวน แตะ เซ ไม่ โลต กวนโซะ แตะ, ป มัฮ กวน ฮารัน เซ, ไม่ ซาไร ป มัฮ ปุย เญือะ อัปรัม เซ โฮว ไม่ แตะ. โอก ฮา เวียง เออ เมือง เคนเดี่ย, ตะ โฮว ฮอยจ เมือง คะนาอัน, ปังเมอ ฮอยจ เคียง เมือง ฮารัน โน่ง. ลอต อาวต นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","เทรา ยุม นา เซ. อาญุ อื ไก 205 เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","เญือม เซ พะจาว อัฮ เฮี ละ อัปรัม, “ไมจ เปอะ โอก โฮว ฮา เญือะ ย่วง บั่นเมือง อาวต เปอะ เฮี, ฮา เอียกปุ ตุเจอ เปอะ, ฮา เญือะ ยุฮ เปือะ เปอะ เฮี. โฮว ฮอยจ เมือง โคระ ป ซ เปลีฮ อาึ ละ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","อาึ ซ เกือฮ จัตเจือ เปอะ โฮวน ปอ แปน อื ติ เมือง ระ. อาึ ซ ปิฮ มุ่น ละ เปอะ. ซ เกือฮ มอยฮ ปะ แปน มอยฮ ระ ไล ละ ปุย. โฮวน ป ซ โฮลฮ รัป ป ไมจ เบือ มอยฮ ปะ อา. ");
INSERT INTO lcp_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","โม ป ปิฮ มุ่น ละ ปะ อาึ ซ ปิฮ โรฮ มุ่น ยุฮ แตะ ละ. ป โปง ป โซะ ละ ปะ อา, อาึ ซ เกือฮ โรฮ ลอก ป โซะ โรฮ. อาึ ซ เกือฮ ปุย ปลัฮเตะ โฮลฮ รัป ป ไมจ เบือ ปะ โครยญ เมือง ปุย,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","เญือม เซ อัปรัม โกฮ โฮว เนอึม ตัม ดวน พะจาว แตะ เซ. โลต โฮว โรฮ ไม่ อื. เญือม โอก อัปรัม ฮา เมือง ฮารัน เซ, อาญุ อื ไก อาลแฆลฮ โรฮ พอน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","อัปรัม โฮว ไม่ ปุย เญือะ แตะ ไม่ กวน ปุ เลีฮ แตะ ป มัฮ โลต เซ. โรวก โรฮ คาวคอง แตะ ไม่ กวนไจ แตะ ป โฮลฮ แตะ เญือม อาวต อื นึง เมือง ฮารัน เซ. โอก โฮว ละ ซ ฮอยจ แตะ นึง เมือง คะนาอัน. ");
INSERT INTO lcp_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","เญือม เอีจ ฮอยจ อื นา เซ อัปรัม ลอต ฮอยจ นึง นาตี ติ โดฮ ก อัฮ ปุย เชเคม ไม่. นา เซ ไก โคะ ไฆรจ ซัมคัน ป ทื ปุย นึง. ปุย อัฮ โมเร ไม่ นาตี เซ. ");
INSERT INTO lcp_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","เญือม เซ มัฮ โม คะนาอัน ป อาวต นึง เมือง เซ. พะจาว เปลีฮ ติ แตะ ละ อัปรัม. อัฮ เฮี ละ อื, “มัฮ เมือง เฮี ป ซ เกือฮ อาึ ละ จัตเจือ เปอะ,” อัฮ เซ ละ อื. เญือม เซ อัปรัม รชุก ซโมะ ยุฮ คัน ละ ซ ทไว แตะ โอเอีฮ ละ พะเยโฮวา ป เปลีฮ ติ แตะ ละ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","ฟวยจ เซ โฮว แม ฮา นา เซ ฮอยจ ก เซฮ นา ก โฮวน บลาวง ลวง ลั่ก โอก ซเงะ นึง ย่วง เบ่ตเอน. กัง พากัง ยุฮ แตะ ซน่ะ ย่วง เบ่ตเอน ไม่ ย่วง ไอ. ย่วง เบ่ตเอน เซ อาวต ลวง เลียก ซเงะ นึง อื. ย่วง ไอ เซ อาวต ลวง โอก ซเงะ นึง อื. อัปรัม ยุฮ โรฮ คัน นา เซ ละ ซ ทไว แตะ โอเอีฮ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ฟวยจ เซ เฌาะ ไป เฌาะ มา ก อาวต แตะ นึง เมือง คะนาอัน ฮอยจ ซดิ ไม่ ลาึน เนเกป ปุ ปุ. ");
INSERT INTO lcp_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ติ โฮน อื เมือง คะนาอัน เกิต ไปลญ เออึป ปุย นึง. โซะ เนอึม ไปลญ ปุย เญือม เซ. อัปรัม เลีฮ อาวต ฆาื อื นึง เมือง อียิป ติ วัง. ");
INSERT INTO lcp_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","เญือม เอีจ ซ เลียก อื เมือง อียิป เปอ, อัฮ เฮี ละ ซาไร ป มัฮ ปุย เญือะ แตะ, “โม เปะ มัฮ เปอะ ปุย ไมจ ละ แลน ปุย เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","เญือม ยุ โม อียิป ไมจ โม เปะ ตอก เซ, ตึน ซ ยุฮ ยุม ไม่ อาึ ฆาื อื นึง มัฮ อาึ ปรเมะ เญือะ เปอะ. ซ เกือฮ โม เปะ ไอม โน่ง. ");
INSERT INTO lcp_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","ไมจ เปอะ อัฮ ติ แตะ มัฮ รนัน อาึ ละ. ดัฮ เปอะ อัฮ ตอก เซ โฮ, ตึน ซ เกือฮ อาึ ไอม เบือ เปอะ. ซ ยุฮ ป ไมจ ละ อาึ ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","เญือม เอีจ เลียก อื นึง เมือง อียิป เปอ โม อียิป ยุ เนอึม ไมจ ปรโปวน เญือะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","โม จาวไน เมือง เซ ยุ โรฮ อื. โฮว รโฮงะ เมาะ ไมจ อื ละ กซัต. เญือม เซ กซัต เกือฮ ปุย โรวก อื ฮอยจ เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","กซัต เซ เกือฮ ป ไมจ ละ อัปรัม ฆาื อื. เกือฮ แกะ ไม่ ปิ ไม่ โมวก ไม่ บรัง ละ อื ไม่ กวนไจ อื ไม่ อุต โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","เญือม เซ พะจาว ปังเมอ เกือฮ เอิน พาญัต โซะ เนอึม เกิต ละ กซัต เซ ไม่ โม กวนไจ ยุฮ อื, ฆาื ริ อื ไอฮ ซาไร ป มัฮ ปรโปวน เญือะ อัปรัม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","กซัต เซ กอก อัปรัม ฮอยจ เคะ แตะ ฆาื อื. อัฮ เฮี ละ อื, “ปะ เมอยุ ยุฮ เปอะ โอเอีฮ เฮี ละ อาึ อื? ตอก เมอ โอ เปอะ รโฮงะ มัฮ อื ปรโปวน เญือะ แตะ เนิ อี? ");
INSERT INTO lcp_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","เกียฮ อัฮ โน่ง เปอะ มัฮ รนัน แตะ เมอ? เกือฮ โน่ง เปอะ อาึ ไอฮ แปน ปรโปวน เญือะ แตะ เมอ? เฮิ ปุย เญือะ เปอะ. โรวก แปฮ. ปุ เญือะ อาวต ไม่ นา เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","เญือม เซ กซัต เซ ดวน กวนไจ ยุฮ แตะ ตาว แปฮ อัปรัม เกือฮ โอก ฮา เมือง แตะ, เตือง ปรโปวน เญือะ อื ไม่ คาวคอง อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","อัปรัม ไม่ ป รโปวน เญือะ อื โอก ฮา เมือง อียิป, ฮาวก ฮอยจ นึง เมือง คะนาอัน นึง ลาึน เนเกป. ฮาวก ไม่ คาวคอง แตะ. โลต โฮว โรฮ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","อัปรัม มัฮ ปุย กอย. ไก แกะ ปิ ไม่ โมวก ยุฮ โฮวน. ไคร มาื ยุฮ อื โฮวน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","ฮาวก เน่อึม นึง ลาึน เนเกป เซ ฮอยจ ก ล่าวง ปุ ปุ. ฮอยจ แม นา ก กัง แตะ พากัง ยุฮ แตะ ซน่ะ ย่วง เบ่ตเอน ไม่ ย่วง ไอ ไพรม อื โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","ทไว โอเอีฮ ไม่ กอก แตะ รโฮงะ มอยฮ พะจาว นึง คัน ยุฮ ไพรม แตะ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","โลต ป โฮว ดิ ไม่ อัปรัม เซ ไก โรฮ แกะ ปิ ยุฮ ไม่ โมวก โฮวน. กวน เฌือต อื ไม่ กวนไจ อื ไก โรฮ โฮวน ปอ ไก พากัง ยุฮ อื โฮวน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","นา ก อาวต อื เซ เญือะ ปอ โตว ไรป ละ เปือม คอง เลียง อื ละ ซ อาวต ดิ อื, นึง เอีจ โฮวน ลอน อื. ");
INSERT INTO lcp_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","โม ป เลียง ซัตซิง ยุฮ อัปรัม ไม่ โม ป เลียง ซัตซิง ยุฮ โลต เซ รเจ ฆาื อื ไม่ ปุ แตะ. (เจน เซ เยอ มัฮ เญือม อาวต ลั่ง โม คะนาอัน ไม่ โม เปริซี นึง เมือง เซ.) ");
INSERT INTO lcp_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","อัปรัม อัฮ เฮี ละ โลต ฆาื อื, “เอะ มัฮ คระ เฌือต ปุ แตะ. ไมจ โตว เกือฮ ติ แตะ แพก ปุ แตะ. โม ป เลียง ซัตซิง ยุฮ ปะ ไม่ โม ป เลียง ซัตซิง ยุฮ อาึ ไมจ โตว เญือะ เกือฮ รเจ รไซญ ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","จัมเปน เอะ รกัฮ ฮา ปุ แตะ. ไมจ เปอะ เลือก นาตี ป ปุก รพาวม เปอะ. ดัฮ ปะ อาวต ลวง วิ อาึ ซ อาวต ลวง ดอม. ดัฮ ปะ อาวต ลวง ดอม อาึ ซ อาวต ลวง วิ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","เญือม เซ โลต แก ปลัฮเตะ รวิต แตะ. ชวน เตะ ลโลวง ฮอง โกลง จอแด่น เน่อึม ก ล่าวง อื ฮอยจ ละ ย่วง โซอัน. ไมจ ละ อื นึง โฮวน รอาวม นึง อื ตอก เอิน รปึม ยุฮ พะจาว โฆะ. ไมจ โรฮ ตอก เมือง อียิป โฮ. (เจน เซ มัฮ กา ยุฮ พะจาว ไลจ ไม่ เวียง โซโด่ม ไม่ เวียง โกโมรา). ");
INSERT INTO lcp_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","โลต เลือก เตะ ลโลวง จอแด่น ฆาื อื ละ ซ อาวต โกะ แตะ นึง. โฮว ฮา อัปรัม อาวต ลวง ลั่ก โอก ซเงะ. แปน เนอึม รกัฮ ฮา ปุ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","อัปรัม อาวต ลั่ง เมือง คะนาอัน. โลต โฮว อาวต เตะ ลโลวง โบ เวียง ระ นึง อื. กัง พากัง ยุฮ แตะ โบ เวียง โซโด่ม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ปุย เวียง โซโด่ม เซ มัฮ ปุย ฆอก ปุย เบร. ยุฮ แนฮ กัน พิต ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ฟวยจ โฮว โลต เซ พะจาว อัฮ เฮี ละ อัปรัม, “ชุง ก อาวต เปอะ เซ, ลอง แลน แก ก ซไง อื โครยญ ลวง รวิต เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","ปลัฮเตะ ชวน เปอะ เซ เตือง โอยจ อื อาึ ซ เกือฮ ละ ปะ ไม่ โม จัตเจือ เปอะ. ซ เกือฮ แปน คอง อื โอ เญาะ ไก ลอยจ. ");
INSERT INTO lcp_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","อาึ ซ เกือฮ จัตเจือ เปอะ โฮวน ตอก ไฮมจ ไก นึง เกาะ โฮ. โอ ปุย เญาะ ปุน เมีญ เมาะ ไก โนง ไฮมจ นึง ปลัฮเตะ เฮี ตอก ออฮ, ปุย ปุ โรฮ ซ ปุน เมีญ เมาะ ไก จัตเจือ ปะ ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","โฮว ซาวป แลน เลียป ปลัฮเตะ เซ เตือง โอยจ อื. อาึ ซ เกือฮ ละ ปะ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","เญือม เซ อัปรัม เฌาะ แม ก อาวต แตะ. กัง พากัง ยุฮ แตะ นา ก ไก โคะ ไฆรจ ยุฮ มัมเร นึง แควน เฮปโรน เซ. อัปรัม ยุฮ คัน นา เซ ทไว โอเอีฮ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","ไก กซัต ปาวน ปุย. มัฮ อัมราเฟน กซัต เมือง ชินา ติ, ไม่ อารีโอก กซัต เมือง เอลาซัน ติ, ไม่ เคโด่ลาโอเมอ กซัต เมือง เอลัม ติ, ไม่ ทิดั่น กซัต เมือง โกยิม ติ. ");
INSERT INTO lcp_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","กซัต โม เซ โฮว ดิ ละ ซ ตอซู แตะ ปุ แตะ ไม่ กซัต พอน ปุย. มัฮ เบ่รา กซัต เมือง โซโด่ม, ไม่ บิ่ระซา กซัต เมือง โกโมรา, ไม่ ชีนัป กซัต เมือง อัตมา, ไม่ เซมเอเบ่อ กซัต เมือง เซโบ่ยิม, ไม่ กซัต เมือง เบ่ลา ติ (มัฮ โรฮ เมือง โซอัน.) ");
INSERT INTO lcp_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","กซัต พอน ปุย เซ เอีจ โปวต รพาวม แตะ เรอึม ปุ แตะ. รโจะ ดิ นึง เตะ ลโลวง ซิตดิ่ม โบ ปลัฮ รอาวม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","เอีจ ไก กาว โรฮ ลอา เนอึม โฮลฮ เคโด่ลาโอเมอ เตียง กซัต เตือง พอน ปุย อื เซ. เญือม เอีจ มัฮ อื เนอึม กาว ลอวย นึง อื กซัต พอน ปุย เซ ริ เลฮ เตียง กซัต เคโด่ลาโอเมอ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","เนอึม กาว โรฮ ปาวน นึง อื แม เคโด่ลาโอเมอ ไม่ โม ป มัฮ ไม่ อื ฮอยจ รุป ไม่ โม เรฟาอิม ป อาวต เมือง อัตทาโรต คาระนาอิม ไม่ โม ซูซิม ป อาวต เมือง ฮาม ไม่ โม เอมิม ป อาวต นึง ชาเว คีริยาทาอิม. เป โม เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","กซัต เซ เป โรฮ โม โฮรี ป อาวต นึง บลาวง เมือง เอโด่ม. โครฮ อื ฮอยจ ย่วง เอนพารัน โบ ลาึน เวือฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ฟวยจ เซ กซัต โม เซ แม แม ฮอยจ ละ ย่วง คาเด่ต. (ป อัฮ ปุย เอนมิซพัต ไม่ ไพรม อื.) เป โอยจ เมือง อาวต โม อามาเลก ไม่ โม อาโมไร ป อาวต เมือง ฮาซาโซน ทามัน. ");
INSERT INTO lcp_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ฟวยจ เซ กซัต เมือง โซโด่ม, กซัต เมือง โกโมรา, กซัต เมือง อัตมา, กซัต เมือง เซโบ่ยิม, ไม่ กซัต เมือง เบ่ลา รโจะ ตฮัน ยุฮ แตะ ละ ซ ตอซู อื ปุ แตะ ไม่ กซัต ปาวน ปุย เซ. รโจะ ดิ นึง เตะ ลโลวง ซิตดิ่ม. ");
INSERT INTO lcp_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","กซัต ปาวน ปุย เซ มัฮ กซัต เมือง ชินา ไม่ กซัต เมือง เอลัม ไม่ กซัต เมือง โกยิม ไม่ กซัต เมือง เอลาซัน. มัฮ กซัต พอน ปุย ตอซู ไม่ กซัต ปาวน ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ลโลวง เซ โฮวน โตะ ป ไก ลออยฮ เตะ นึง. กซัต เวียง โซโด่ม ไม่ กซัต เวียง โกโมรา ริ ตอ. ดุฮ โตะ ไก ลออยฮ เตะ เซ. กซัต ไฮญ ลอวย ปุย นึง อื เซ เตือน ตอ ฮอยจ นึง บลาวง. ");
INSERT INTO lcp_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","เญือม เซ กซัต ปาวน เซ ตุย โรวก โอเอีฮ ยุฮ ปุย เวียง โซโด่ม ไม่ เวียง โกโมรา เซ เตือง เฮงาะ รโกะ เตือง คอง เลียง ปุย โฮว ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","โฮมวต โรฮ โรวก โลต ป มัฮ กวน ปุ เลีฮ อัปรัม ป อาวต เวียง โซโด่ม เซ, ไม่ คาวคอง ยุฮ อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","เญือม เซ ไก ปุย ติ ป เตือน ตอ เอีญ รโฮงะ ไลลวง อื ละ อัปรัม ป มัฮ โม ฮีบรู เซ, ปุก เญือม อาวต อื แควน โคะ ไฆรจ ยุฮ มัมเร ป มัฮ ปุย อาโมไร เซ. มัมเร ไม่ เอซโคน ไม่ อาเนอ ป มัฮ ปุ มัมเร เซ พาวม ดิ โรฮ ไม่ อัปรัม. ");
INSERT INTO lcp_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","เญือม ฮมอง อัปรัม ไลลวง โรวก ปุย โลต ป มัฮ กวน ปุ เลีฮ แตะ เซ, กอก โม กวนไจ ป เกียฮ แปน ตฮัน อาวต ไม่ แตะ เซ. ไก ลอวย รอย ไปล กาว ซเตะ ปุย เตือง โอยจ อื. โฮว อาื กซัต ปาวน เซ ฮอยจ เมือง ด่าน. ");
INSERT INTO lcp_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","รฆุ ตฮัน ยุฮ แตะ แปน มู แปน มู อื. ตอซู รซาวม โม กซัต เซ. เป อื. โครฮ อื ฮอยจ เมือง โฮบ่า ราว เวียง ด่ามาซกัต. ");
INSERT INTO lcp_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","โฮลฮ แม โรฮ โรวก โลต ป มัฮ กวน ปุ เลีฮ แตะ เซ ไม่ คาวคอง อื. โรวก โรฮ อื เตือง ปุย ไฮญ โฮมวต อื เซ เตือง ปรเมะ ปรโปวน, ไม่ คาวคอง ยุฮ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","เญือม เอีญ อัปรัม เน่อึม ตอซู แตะ ไม่ เคโด่ลาโอเมอ ไม่ กซัต ไฮญ เซ, กซัต เมือง โซโด่ม โอก รโตฮ ยุ อื นึง เตะ ลโลวง ชาเว นา ก อัฮ ปุย เตะ ลโลวง ยุฮ กซัต ไม่. ");
INSERT INTO lcp_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","เญือม เซ เมละคีซเด่ก ป มัฮ กซัต เมือง ซาเลม ไม่ มัฮ โรฮ อื ซตุ ยุฮ พะจาว ตึก นึง ฮลาวง แตะ โอก โรฮ เคะ อื. โรวก คโนมปัง ไม่ รอาวม อะงุน เกือฮ อื ละ อัปรัม. ");
INSERT INTO lcp_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ปิฮ มุ่น ละ อื. อัฮ เฮี, “ปัว พะจาว ป ตึก นึง ฮลาวง แตะ ป ยุฮ ปลัฮเตะ ไม่ ปลัฮ มะลอง ปิฮ มุ่น ละ อัปรัม. ");
INSERT INTO lcp_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","เกือฮ ปุย ลืลาว พะจาว ป ตึก นึง ฮลาวง แตะ. มัฮ พะจาว เซ ป เกือฮ ปะ ปุน เป ป ตอซู ไม่ เปอะ เซ,” อัฮ เซ. เญือม เซ อัปรัม ทไว คาวคอง โรวก แตะ เซ ละ เมละคีซเด่ก. กาว ปุน ทไว อื ละ อื ติ ปุน. ");
INSERT INTO lcp_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","กซัต เมือง โซโด่ม อัฮ เฮี, “คาวคอง ปุน เปอะ เซ ไอฮ ไอฮ เมิฮ. เกือฮ อาึ โฮลฮ โรวก ปุย ยุฮ แตะ นึง อื โน่ง,” อัฮ เซ ละ อัปรัม. ");
INSERT INTO lcp_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","อัปรัม โลยฮ อื ตอก เฮี, “อาึ เอีจ ยวก เตะ แตะ ละ ซ ซันญา ซโตฮ แตะ ซองนา พะเยโฮวา พะจาว ป ตึก นึง ฮลาวง แตะ ป ยุฮ ปลัฮเตะ ไม่ ปลัฮ มะลอง. ");
INSERT INTO lcp_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","อาึ ญอม โตว ไอฮ คาวคอง ยุฮ ปะ ติ เจือ เนอึม. ปัง มัฮ กอย ติ เญียง ไม่ โม่ะเกิป ติ เตียง ปุ ซ ไอฮ เฟือฮ เอิน. อาึ ฆวต เกือฮ โตว ปะ อัฮ ติ แตะ มัฮ ป เกือฮ อัปรัม โฮลฮ แปน ปุย กอย. ");
INSERT INTO lcp_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","อาึ ซ ไอฮ โตว โอเอีฮ ละ โกะ แตะ, โนก ฮา ป เอีจ ฟวยจ โซม โม ป โฮว ไม่ เยอะ เฮี. รโตง มัมเร ไม่ อาเนอ ไม่ เอซโคน ป มัฮ ปุโฮมว เยอะ เฮี, ดัฮ ฆวต ไอฮ อื โฮ, เกือฮ ละ อื เมิฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ฟวยจ เซ อัปรัม ยุ บลอง พะจาว. ฮมอง อัฮ อื เฮี ละ แตะ, “อัปรัม, ปุ ฮลัต นึง โอเอีฮ ฮี. อาึ ซ เฆีญ ปะ เกือฮ โปน ฮา โอเอีฮ ป ซ ยุฮ ป โซะ ละ เปอะ. ซ เกือฮ โรฮ ลังวัน ระ เนอึม ละ เปอะ ไม่ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","อัปรัม อัฮ เฮี, “โอ พะจาว เยโฮวา, ลังวัน เกือฮ เปอะ เนิ ซ ไมจ ละ อาึ ตอก เมอ? อาึ ไก โตว กวน ติ เนอึม. ป ซ โฮลฮ รัป คาวคอง เงอะ เฮี มัฮ เอลีเยเซอ ปุย เมือง ด่ามาซกัต เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","ปะ เกือฮ เปอะ โตว อาึ โฮลฮ กวน แตะ. มัฮ กวนไจ ยุฮ ฮุ ติ ปุย เฮี โน่ง ป ซ โฮลฮ คาวคอง เงอะ ฆาื อื,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","เญือม เซ อัปรัม ฮมอง แม เซียง พะจาว อัฮ เฮี, “มัฮ โตว ตอก เซ. เอลีเยเซอ กวนไจ ยุฮ เปอะ เซ ซ โฮลฮ โตว คาวคอง เปอะ. มัฮ กวน โกะ เปอะ ไอฮ ป ซ โฮลฮ โฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","พะจาว ตาว อัปรัม โอก ก พริ. อัฮ เฮี ละ อื, “แก แลน มะลอง เงอ, เมีญ แลน เมาะ ไก ซโมยญ นึง อื ตัม โครยญ เปอะ ยุฮ. โม จัตเจือ เปอะ ซ โฮวน โรฮ ตอก ซโมยญ เซ โรฮ,” อัฮ เซ ละ อื พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","อัปรัม เจือ ป อัฮ พะจาว ละ แตะ. พะจาว เมีญ อื มัฮ ปุย ซืไซ ละ แตะ เบือ รพาวม เจือ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","พะจาว อัฮ เฮี ละ อื, “อาึ มัฮ เยโฮวา ป เกือฮ ปะ โอก ฮา เวียง เออ เมือง เคนเดี่ย นึง ซ เกือฮ เมือง เฮี แปน คอง เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","อัปรัม อัฮ เฮี, “โอ พะจาว เยโฮวา, อาึ ซ ยุง ตอก เมอ ซ มัฮ เนอึม อื คอง อาึ อื?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","พะจาว อัฮ เฮี, “ไมจ เอะ ซันญา อาึง โอเอีฮ ไม่ ปุ แตะ. ตาว โมวก รโปวน เนิ ติ ไม่ ปิ รโปวน ติ ไม่ แกะ ไฮมญ ติ. ไอฮ ป ไก อาญุ อื ลอวย เนอึม เตือง ลอวย อื. โรวก ไม่ รโกะเกอื ติ ไม่ โนกพิลัป ติ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","อัปรัม โรวก เนอึม โอเอีฮ โม เซ ละ พะจาว. มอก อื. ซเดือฮ อื เลีฮ ลอา. เดี่จ โน่ง โน่ง อื แปน ทอย แตะ. ไซม ปังเมอ โอ มอก ซเดือฮ อื เลีฮ ลอา. ");
INSERT INTO lcp_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","เญือม เลีฮ รงั่ก ไม่ เรียง ละ โตะ มอก อื เซ อัปรัม โครฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","เญือม เอีจ ซ เลียก ซเงะ เอ อัปรัม ลอต ปุน ไอจ นา เซ. เญือม เซ เกิต พราวป เฟียก ตัง เจือ ละ. ฮลัต เตีจ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","เญือม เซ พะจาว อัฮ เฮี ละ อัปรัม, “จัตเจือ เปอะ ซ โฮลฮ อาวต เมือง ปุย ก ซไง อื ติ เมือง. ซ โฮลฮ แปน ครา เซีญ ปุย เมือง เซ. ซ โคมเฮง คาเคียน ปุย ตา ปาวน รอย เนอึม เอิน. ");
INSERT INTO lcp_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","ฟวยจ เซ อาึ ซ เกือฮ ปุย เมือง ป โฮลฮ อื แปน ครา นึง เซ ลอก ตุต แตะ. เญือม โอก โม จัตเจือ เปอะ ฮา เมือง เซ ซ โฮลฮ โรฮ โรวก คาวคอง ไมจ ไม่ แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","ปะ ซ ไอม เปอะ ฮอยจ ละ กวต แตะ. เญือม ยุม เปอะ ซ ญึม ยุม เปอะ. ปุย ซ รมอยจ ปะ ไมจๆ. ");
INSERT INTO lcp_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ซ ไก ลั่ง ปาวน เจน ปุย กา ซ โฮลฮ จัตเจือ เปอะ แม อาวต แม นา เฮี. ปเลี่ย เฮี กัน ฆอก กัน เบร ยุฮ โม อาโมไร เอีจ โฮวน, ปังเมอ โอ โรฮ ดิ โฮฮ ดิ เกิน. ดัฮ เอีจ โฮฮ เอีจ เกิน โฮ, อาึ ซ เกือฮ จัตเจือ เปอะ โฮลฮ แม อาวต นึง เมือง เฮี,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","เญือม เอีจ เลียก ซเงะ เฟียก พริ อี, ฮอยจ ง่อม โดง งอ ป โอก ม่าึต นึง. ฮอยจ ไม่ รเออึป ฆิ. โฮว ซน่ะ ซัตซิง มอก อื อาึง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","เอีจ มัฮ ซาวม เซ เญือม ซันญา พะจาว อาึง โอเอีฮ ไม่ อัปรัม เมอ. อัฮ เฮี ละ อื, “อาึ ซ เกือฮ ปลัฮเตะ เฮี ละ จัตเจือ เปอะ เน่อึม นึง โกลง อียิป ฮอยจ ละ โกลง ยูฟะเรตี. ");
INSERT INTO lcp_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ซ เกือฮ ละ เปอะ เตือง นาตี อาวต โม เคไน, โม เคนัต, โม คัตโมไน, ");
INSERT INTO lcp_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","โม ฮิตไท, โม เปริซี, โม เรฟาอิม, ");
INSERT INTO lcp_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","โม อาโมไร, โม คะนาอัน, โม เกอกาชี, ไม่ โม เยบุ่ต เตือง โอยจ อื,” อัฮ เซ ละ อื พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ซาไร ป มัฮ ปรโปวน เญือะ อัปรัม ดิ โฮลฮ โตว กวน แตะ ติ ปุย เนอึม. ซาไร เซ ไก กวนไจ รโปวน ติ ปุย. มอยฮ อื มัฮ ฮากา, มัฮ ปุย เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ซาไร เซ อัฮ เฮี ละ อัปรัม, “พะจาว เกือฮ โตว อาึ โฮลฮ กวน แตะ ติ ชวง. ไอฮ เอิน กวนไจ เยอะ เซ. เมอ เตือง อื โฮลฮ ไอฮ กวน แตะ เบือ อื ยุ่ง. ฟวยจ เซ ซ เมีญ มัฮ กวน อาึ,” อัฮ เซ. อัปรัม ปุก รพาวม อื ป อัฮ ซาไร เซ. ");
INSERT INTO lcp_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ซาไร เกือฮ เนอึม กวนไจ แตะ เซ ละ อัปรัม ละ ซ แปน อื ปรโปวน เญือะ อื. ไล เฮี มัฮ ป เกิต เญือม เอีจ อาวต อัปรัม นึง เมือง คะนาอัน เซ กาว เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","อัปรัม ไอฮ เนอึม ฮากา เซ ฆาื อื. เญือม เอีจ เติง เวลา อื ฮากา เซ โรวก เนอึม. เญือม เอีจ ยุง อื ติ แตะ เกียฮ ฮุน. พลิฮ แมเลียง แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","เญือม เซ ซาไร อัฮ เฮี ละ อัปรัม, “มัฮ ฆาื โม เปะ ป พลิฮ ฮากา อาึ ฆาื อื. อาึ เอีจ เกือฮ ละ โม เปะ. เคียง เอีจ ยุง อื ติ แตะ พลิฮ ลัมเลือ อาึ ฆาื อื. เกือฮ พะจาว รเตีฮ ป พิต ป ปุก นึง อื. อัม มัฮ โม เปะ ป พิต เตอ? อัม มัฮ อาึ ป พิต เตอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","อัปรัม อัฮ เฮี ละ ซาไร, “เอีจ มัฮ กวนไจ เปอะ. เอีจ อาวต โรฮ ฆรึม อัมนัต เปอะ. เตอึม ป ยุฮ เปอะ ละ อื,” อัฮ เซ. เคียง เซ ซาไร โคม ลัมเลือ กวนไจ แตะ เซ. กวนไจ อื เซ ตอ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ฮากา โฮว คระ ลาึน เวือฮ. มัฮ คระ โฮว ปุย นึง เมือง ชูระ. ฮอยจ ละ รอาวม ปลาึฮ ติ โดฮ. เตปด่า ยุฮ พะจาว รโตฮ ยุ ฮากา นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","เตปด่า เซ อัฮ เฮี ละ อื, “ฮากา, กวนไจ ยุฮ ซาไร, โอก เปอะ เน่อึม ก เมอ? ซ โฮว เปอะ ก เมอ?” อัฮ เซ ละ อื. ฮากา โลยฮ อื, “ตอ เยอะ ฮา แมเลียง แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","เตปด่า เซ อัฮ แม เฮี ละ อื, “เอีญ เมิฮ. เกือฮ ติ เปอะ เนอึง ป อัฮ แมเลียง เปอะ โครยญ เจือ.” ");
INSERT INTO lcp_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","อัฮ โรฮ เฮี ละ อื, “อาึ ซ เกือฮ ปะ โฮลฮ จัตเจือ แตะ โฮวน ปอ โอ ปุย เญือะ โอยจ เมีญ. ");
INSERT INTO lcp_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ปะ ซ โฮลฮ เปอะ กวน รเมะ แตะ. ไมจ เปอะ อัฮ อิชมาเอน ละ, นึง เอีจ ฮมอง พะจาว ไลลวง ยุฮ ปุย ป โซะ ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","กวน ปะ ซ แปน ตอก บรัง พริ. ปุย ซ ตอซู โกะ อื. โกะ อื ซ ตอซู โรฮ ปุย. ซ อาวต ไม่ โอ แตะ ปุก ปุ แตะ ไม่ คระ เฌือต แตะ,” อัฮ เซ ละ อื เตปด่า ยุฮ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ฮากา ง่อต อื โตะ รพาวม แตะ ตอก เฮี, “อาึ เอีจ โฮลฮ เนอึม ยุ พะจาว นา เฮี, เกียฮ ไอม บุย ลั่ง เงอะ เมอ?” อัฮ เซ. เญือม เซ ลอต กอก รโฮงะ มอยฮ พะจาว นา เซ. อัฮ “พะจาว ป เกียฮ ยุ โอเอีฮ” ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","มัฮ เซ ป ลอต ปุย อัฮ “นัมโม่ ยุฮ พะจาว ไอม ลอป ป เกียฮ ยุ อาึ” ไม่ นัมโม่ เซ ฆาื อื. นัมโม่ เซ ไก ซน่ะ ย่วง คาเด่ต ไม่ ย่วง เบ่เรต. ");
INSERT INTO lcp_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","ฮากา ไก เนอึม กวน ไม่ อัปรัม. อัปรัม อัฮ อิชมาเอน ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","เญือม เซ อาญุ อัปรัม ไก รเตะ โรฮ แลฮ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","เญือม ไก อาญุ อัปรัม รไตม โรฮ ซไตม เนอึม เมอ, พะจาว เปลีฮ ติ แตะ ละ อื. อัฮ เฮี, “อาึ มัฮ พะจาว อาวต ไม่ อัมนัต ตึก นึง ระ แตะ. ปะ ไมจ เปอะ รโจะ ลอป รพาวม แตะ ไม่ อาึ, ไม่ เนอึง เปอะ ป อัฮ ฮะ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","อาึ ซ ซันญา ดิ อาึง โอเอีฮ ไม่ เปอะ. ซ เกือฮ โรฮ จัตเจือ เปอะ พรุฮแพร โฮวน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","เญือม เซ อัปรัม นุ่ม ปอ จิ ไกญ แตะ เตะ. ");
INSERT INTO lcp_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","พะจาว อัฮ แม เฮี ละ อื, “ไลลวง ป ซันญา อาึ ไม่ เปอะ มัฮ เฮี. ปะ ซ แปน เปอะ เปือะ ปุย โฮวน เมือง. ");
INSERT INTO lcp_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","มอยฮ ปะ เญือะ ซ มัฮ โตว อัปรัม. ปะ ซ โฮลฮ เปอะ มอยฮ โคระ แตะ. มอยฮ โคระ เปอะ เซ ซ มัฮ อัปราฮัม นึง เกือฮ อาึ เปอะ แปน เปือะ ปุย โฮวน เมือง. ");
INSERT INTO lcp_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","อาึ ซ เกือฮ ปะ พรุฮแพร. จัตเจือ เปอะ ซ แปน ปุย โฮวน เมือง. ซ แปน โรฮ กซัต ง่อน จัตเจือ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","ลปุง ซันญา อาึ ไม่ ปะ เฮี ซ เกือฮ ตอน ละ เปอะ ฮอยจ ละ จัตเจือ เปอะ เฆียง เฮี โครยญ เจน ปุย. แปน ลปุง ซันญา โอ เญือะ เกียฮ ลอยจ. อาึ ซ แปน พะจาว ยุฮ เปอะ ไม่ ซ แปน พะจาว ยุฮ จัตเจือ เปอะ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ป มัฮ เมือง คะนาอัน ป อาวต เปอะ นึง ตอก อาวต ปุย ตังเมือง นา ก โฮว ไป โฮว มา เปอะ นึง เฮี, อาึ ซ เกือฮ ละ ปะ เตือง โอยจ อื ฮอยจ ละ จัตเจือ เปอะ เฆียง เฮี โรฮ. ซ เกือฮ เมือง คะนาอัน แปน คอง เปอะ ฮอยจ ละ เฆียง เฮี โอ เญาะ ไก ลอยจ. อาึ ซ แปน พะจาว ยุฮ โม จัตเจือ เปอะ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","พะจาว อัฮ โรฮ เฮี, “ปะ ไมจ เปอะ ยุฮ ตัม ลปุง ซันญา อาึ อาึง ละ เปอะ เฮี, เตือง ปะ เตือง จัตเจือ เปอะ โครยญ เจน ปุย ฮอยจ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ไมจ เปอะ ยุฮ ริตกิต ละ ปรเมะ ไน โม เปะ โครยญ โฆะ เปอะ เตือง ปะ เตือง จัตเจือ เปอะ เฆียง เฮี. เอีจ มัฮ ตอก เซ ตอก เปลีฮ เปอะ ยุฮ แตะ ตัม ลปุง ซันญา อาึ ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","เน่อึม ปเลี่ย ฮอยจ เฆียง เฮี ดัฮ ไก กวนดุ รเมะ เกิต นึง เญือะ เปอะ, ดัฮ เอีจ ฟวยจ เกิต ซเตะ ซเงะ โฮ, ไมจ เปอะ ยุฮ ริตกิต เซ ละ โครยญ โฆะ อื, เตือง กวนไจ เกิต นึง เญือะ เปอะ ไม่ กวนไจ รวี เปอะ นึง ปุย ตังเมือง โรฮ. มัฮ ตอก เซ ตอก ซ เปลีฮ ที เปอะ นัปทื แตะ ลปุง ซันญา อาึ อาึง ไม่ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","ปุย ไมจ อื ไอฮ ริตกิต โครยญ โฆะ แตะ ละ ซ ไม อื อาึง เนะซอัง แตะ ติ เจือ. มัฮ ตอก เซ ตอก ซ ที มัฮ เนอึม ลปุง ซันญา อาึ ไม่ โม เปะ เซ ลปุง ซันญา โอ เญาะ ไก ลอยจ เจอ. ");
INSERT INTO lcp_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ดัฮ ไก ปรเมะ ป โอ อื ไอฮ ริตกิต เซ อาึ ซ เมีญ โตว มัฮ ปุย ไน แตะ, นึง โอ อื ยุฮ ตัม ลปุง ซันญา อาึ อาึง ไม่ แตะ,” อัฮ เซ ละ อัปราฮัม พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","พะจาว อัฮ โรฮ เฮี, “ปุ เญือะ อัฮ ซาไร ละ ปรโปวน เญือะ เปอะ. เฆิม เฮี มอยฮ อื ซ มัฮ ซารา. ");
INSERT INTO lcp_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","อาึ ซ ปิฮ มุ่น ละ. อาึ ซ เกือฮ กวน รเมะ เปอะ เกิต เน่อึม นึง อื ติ ปุย. อาึ ซ ปิฮ มุ่น ละ ซารา เซ, ซ เกือฮ แปน มะ ปุย โฮวน เมือง. ซ แปน โรฮ กซัต ง่อน จัตเจือ อื เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","อัปราฮัม นุ่ม ปอ จิ ไกญ แตะ เตะ. เญือม เซ ง่อต อื โตะ รพาวม แตะ ตอก เฮี, “ปรเมะ เอีจ ไก อาญุ ติ รอย เนอึม เมอ อัม ซ เกียฮ ไก ลั่ง กวน? ซารา ไก อาญุ รไตม เนอึม, อัม ซ เกียฮ ไก ลั่ง กวน?” ง่อต อื ตอก เซ. เญือม เซ ญวยฮ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","อัฮ อื ละ พะจาว ตอก เฮี, “เกือฮ อิชมาเอน อาวต ลอป นึง ลวัง บั่งคัป เปอะ. เอีจ เคราะ โรฮ อื เมาะ เซ,” อัฮ เซ อัปราฮัม. ");
INSERT INTO lcp_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","พะจาว อัฮ เฮี, “มัฮ โตว ตอก เซ. ซารา ปรโปวน เญือะ เปอะ เซ ซ ไก ลั่ง กวน ละ เปอะ. ปะ ไมจ เปอะ อัฮ ยิซฮัก ละ. อาึ ซ เกือฮ ลปุง ซันญา แตะ ตอน ไม่ ปุย เซ ฮอยจ ละ จัตเจือ อื เฆียง เฮี โอ เญาะ ไก ลอยจ. ");
INSERT INTO lcp_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ไลลวง อิชมาเอน เนอ อาึ เอีจ ฮมอง เงอะ รซอม ปัว เปอะ รโตง อื. อาึ ซ ปิฮ มุ่น ละ. ซ เกือฮ กวน อื โฮวน. ซ เกือฮ จัตเจือ อื พรุฮแพร. ซ แปน จาวไน กาว โรฮ ลอา ปุย. จัตเจือ อื ซ แปน ติ เมือง ระ. ");
INSERT INTO lcp_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ลปุง ซันญา อาึ ปังเมอ ซ ตอน ไม่ ยิซฮัก ป ซ เกิต เน่อึม นึง ซารา เซ ซัมติ เวลา เมือ ปเลี่ย เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","เญือม เอีจ ฟวยจ ลปุง อื ไม่ อัปราฮัม เมอ, พะจาว โอก โฮว ฮา อื. ");
INSERT INTO lcp_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","ซเงะ เซ อัปราฮัม เนอึง ป อัฮ พะจาว ละ แตะ. ยุฮ ริตกิต ละ อิชมาเอน กวน แตะ เซ. ยุฮ โรฮ อื ละ ปรเมะ ไฮญ ป อาวต ไม่ แตะ เตือง กวนไจ เกิต เญือะ แตะ ไม่ กวนไจ รวี แตะ นึง ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","เญือม ไอฮ อัปราฮัม ริตกิต เซ อาญุ อื ไก รไตม โรฮ ซไตม เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","กวน อื ป มัฮ อิชมาเอน เซ เอีจ ไก อาญุ กาว โรฮ ลอวย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","ไอฮ ริตกิต ซเงะ ติ เซ เตือง เปือะ เตือง กวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","โม กวนไจ ยุฮ อื เตือง โอยจ อื ไอฮ ตื ริตกิต ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","เญือม อาวต อัปราฮัม โบ โคะ ไฆรจ ยุฮ มัมเร เยอ, พะจาว ฮอยจ เปลีฮ ติ แตะ ละ อื. อัปราฮัม งาวม ลโล่ะ โตะ รเวือะ พากัง ยุฮ แตะ. ปุก เญือม เรียง โซะ กอยจ. ");
INSERT INTO lcp_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","เญือม เซ เยอ ชวน ชุง ปุย รเตือป แตะ ลอวย ปุย. ตอ เอิน โอก โฮว รโนฮ รชึง อื. นุ่ม ปอ จิ ไกญ แตะ เตะ. ");
INSERT INTO lcp_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","อัฮ เฮี ละ อื, “จาวไน, ดัฮ ปุก รพาวม เปอะ โฮ, ปัว โม เปะ โอ ลอต ฮา แตะ. ปัว เปอะ วิฮ เคะ อาึ ป มัฮ กวนไจ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","อาึ ซ เกือฮ ปุย ตุย โรวก รอาวม ละ ซ รไซจ เปอะ ชวง แตะ นึง. งาวม ลโล่ะ ฆรึม โคะ เฮี ลไล อื. ");
INSERT INTO lcp_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","อาึ ซ ตุย ป โซม ป ปอน ละ เปอะ เญี่ยะ. ซ ปุน เปอะ เรียง แตะ นึง กา ซ โฮว แม เปอะ นึง คระ. เอีจ แปน เนอึม นา ตา เนิ ฮอยจ เปอะ เคะ อาึ อื. ฆวต รัปคัม โม เปะ เญี่ยะ,” อัฮ เซ ละ อื. โม เซ โลยฮ อื ตอก เฮี, “แปน โรฮ ตอก เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","อัปราฮัม ซไจ เลียก โตะ พากัง ยุฮ แตะ. อัฮ เฮี ละ ซารา, “ซไจ ตุย ญอต แปง ยุฮ เปอะ ลอวย รปัก, ยุฮ คโนมปัง นึง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","โกะ อื ตอ โฮว ฮอยจ ลั่ก ก อาวต โมวก ยุฮ แตะ. โฮมวต โรวก กวน โมวก ซไพร โกลยญ ยุฮ แตะ ติ. เกือฮ กวนไจ แตะ มอก โกยฮ โตะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ฟวยจ เซ ตุย เนย ไม่ นัมโนม ไม่ โตะ มอก แตะ เซ. ปอก โซม ตุม ไอฮ ละ ปุย ฮอยจ เซ. อัปราฮัม มอง ไอฮ ไจไซ ป โซม ป ปอน ละ อื. เกือฮ อื โซม ฆรึม โคะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","โม เซ ไฮมญ อัปราฮัม ตอก เฮี, “ซารา ป มัฮ ปรโปวน เญือะ เปอะ อาวต ก เมอ?” อัฮ เซ. “อาวต โตะ พากัง เซ,” อัฮ เซ ละ อื อัปราฮัม. ");
INSERT INTO lcp_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","ปุย โม เซ ติ ปุย อื อัฮ เฮี, “ซัมติ เมือ ปเลี่ย เฮี, อาึ ซ ฮอยจ แม เคะ เปอะ. ปรโปวน เญือะ เปอะ เซ ซ ไก กวน รเมะ,” อัฮ เซ. ซารา อาวต กไน พากัง เซ ซดิ ไม่ ก อาวต ปุย เซ. ฮมอง โรฮ ป อัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","อัปราฮัม ไม่ ซารา เอีจ กวต. ซารา เญือะ ไก โตว ปะจัม เดื่อน อื. ");
INSERT INTO lcp_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","เญือม ฮมอง อื ป อัฮ ปุย เซ ญวยฮ ฆาื อื. อัฮ เฮี โตะ รพาวม แตะ, “อาึ เอีจ กวต เอีจ ซอง ตอก เฮี. อัม ซ เกียฮ ไก ลั่ง กวน เนอะ ละ ซ โฮลฮ รพาวม ไมจ มวน แตะ เบือ อื? ปุย เญือะ อาึ เอีจ กวต โรฮ ไม่ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","เญือม เซ พะจาว ไฮมญ อัปราฮัม ตอก เฮี, “เมอยุ ญวยฮ ซารา เซ? เมอยุ ซองไซ อื นึง โอ แตะ เญือะ ซ ไก กวน นึง เอีจ กวต แตะ? ");
INSERT INTO lcp_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","อัม ไก ป ญัก ลอน ละ พะจาว? ซัมติ เมือ ปเลี่ย เฮี อาึ ซ ฮอยจ เนอึม เคะ เปอะ. ซารา ซ โฮลฮ เนอึม อื กวน แตะ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","เญือม เซ ซารา ฮลัต. ริ เม่าะ ไล แตะ. “อาึ ญวยฮ โตว เมอ,” อัฮ เซ. “ปะ ญวยฮ เปอะ,” อัฮ เซ ละ อื พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ฟวยจ เซ ปุย ลอวย เซ โกฮ โฮว ละ ซ ฮาวก แก แตะ เมือง โซโด่ม. อัปราฮัม ตาว อื นึง คระ. ");
INSERT INTO lcp_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","พะจาว อัฮ เฮี โตะ รพาวม แตะ, “อาึ อัม ซ คาว ละ เม่าะ ไลลวง ตะ แตะ ยุฮ ฮา อัปราฮัม เซ? ");
INSERT INTO lcp_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","เมือต แลน จัตเจือ อื ซ พรุฮ แปน เมือง ระ. อาึ ซ โฮลฮ เกือฮ เมือง ปุย ติ ปลัฮเตะ โฮลฮ ป ไมจ เบือ อัปราฮัม เซ โครยญ เมือง. ");
INSERT INTO lcp_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","อาึ เอีจ เลือก อาึง นึง ซ เกือฮ ฮะ เพอึก ตอม กวน เฌือต แตะ เนอึง ป อัฮ อาึ, ไม่ เพอึก ตอม อื ยุฮ กัน ปุก กัน ลอก กัน ซื กัน ไซ. มัฮ ตอก เซ ตอก ซ โฮลฮ อาึ ยุฮ โอเอีฮ ละ อื ตัม ซันญา แตะ อาึง โครยญ เจือ,” อัฮ เซ โตะ รพาวม แตะ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","เญือม เซ พะจาว อัฮ เฮี ละ อัปราฮัม, “โฮวน เนอึม ป ฟอง ปุย เมือง โซโด่ม ไม่ เมือง โกโมรา ละ อาึ อื. ระ เนอึม มั่ป ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","จัมเปน อาึ เลีฮ แลน ไลลวง อื ตัม เมาะ เนอึม, เมาะ โอ อื เนอึม, ตอก ฟอง ปุย อื เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ปุย ลอา นึง อื เซ ลอต โฮว นึง คระ เมือง โซโด่ม. พะจาว ปังเมอ อาวต ลั่ง ไม่ อัปราฮัม. ");
INSERT INTO lcp_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","อัปราฮัม เลียก ซดิ โบ พะจาว, อัฮ เฮี ละ อื, “อัม ซ เกือฮ เปอะ ปุย ซื ยุม ดิ ไม่ ปุย บ่วก? ");
INSERT INTO lcp_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ดัฮ ไก ลั่ง รฮอน ปุย, ปุย ซืไซ ละ ปะ นึง เมือง เซ อัม ซ ยุฮ ลั่ง เปอะ ไลจ ไม่ ฆาื อื? โม่ เปอะ ซ ฮลักกอ ปุย รฮอน เซ? ");
INSERT INTO lcp_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","แจง โอ เปอะ ซ ยุฮ ยุม ไม่ ปุย ซื นึง อาวต อื ไม่ ปุย บ่วก เกอ. โปง โตว ปะ. ปะ กอ ยุฮ เปอะ โตว ตอก เซ. มัฮ ยุฮ เปอะ ตอก เซ ปุย ซืไซ ซ ลอก ดิ ตุต ไม่ ปุย พิต ฆาื อื. โปง โตว ปะ. ป รเตีฮ รตุม ปุย ติ ปลัฮเตะ ไมจ อื รเตีฮ ตัม ซื อื, โม่ มัฮ อื?” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","พะจาว อัฮ เฮี, “ดัฮ อาึ ยุ ปุย ซืไซ อาวต นึง เวียง โซโด่ม เซ รฮอน ปุย อาึ ซ ฮลักกอ ปุย นึง เวียง เซ เตือง โอยจ อื เบือ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","อัปราฮัม อัฮ แม เฮี, “โอ พะจาว, ปัว เปอะ โอ ทื อาึ นึง โรวต ลั่ง แตะ อัฮ โอเอีฮ ละ เปอะ. อาึ มัฮ ปุย ทัมมด่า, มัฮ เยือ เตะ รกาื. ");
INSERT INTO lcp_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","เมอ เตือง อื ไก โตว รฮอน ปุย ยุ่ง. วิต พอน ปุย ยุ่ง. ดัฮ ไก รปาวน โรฮ พอน โน่ง อัม ซ ยุฮ ลั่ง เปอะ ไลจ ไม่ เมือง เซ นึง วิต ลั่ง อื พอน ปุย?” อัฮ เซ. พะจาว อัฮ เฮี, “ดัฮ ไก ลั่ง รปาวน โรฮ พอน ปุย อาึ ซ ยุฮ โตว ไลจ ไม่,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","อัปราฮัม อัฮ แม เฮี, “เมอ เตือง อื ไก ลั่ง รปาวน โน่ง ยุ่ง, ปุย ซืไซ ละ ปะ นึง อื,” อัฮ เซ. พะจาว อัฮ เฮี, “ดัฮ ไก ลั่ง รปาวน ปุย อาึ ซ ยุฮ โตว ไลจ ไม่,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","อัปราฮัม อัฮ แม เฮี, “โอ พะโองจาว, ปัว เปอะ โอ รอก พาวม นึง แตะ. อาึ จัมเปน ลั่ง ปัว นึง เปอะ. เมอ เตือง อื ไก ลั่ง ง่วย โน่ง ยุ่ง,” อัฮ เซ. “ดัฮ ไก ลั่ง ง่วย อาึ ซ ยุฮ โตว ไลจ ไม่,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","อัปราฮัม อัฮ เฮี, “โอ พะโองจาว, ปัว เปอะ โอ ทื อาึ นึง โรวต แตะ ปัว โอเอีฮ นึง เปอะ. เมอ เตือง อื ไก ง่า ปุย โน่ง ยุ่ง,” อัฮ เซ. พะจาว อัฮ เฮี, “ดัฮ ไก ง่า ปุย ปุ ลั่ง ซ ยุฮ ไลจ ไม่,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","อัปราฮัม อัฮ เฮี, “โอ พะโองจาว, ปัว เปอะ โอ รอก พาวม นึง แตะ. อาึ ซ อัฮ แม ละ เปอะ ติ โฮน เฮี โน่ง. ดัฮ ไก ลั่ง กาว ปุย, ปุย ซืไซ นึง อื ซ อัฮ เปอะ ตอก เมอ?” อัฮ เซ. พะจาว อัฮ เฮี, “ดัฮ ไก กาว ปุย อาึ ซ ยุฮ โตว ไลจ ไม่,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","เญือม เอีจ ฟวยจ ลปุง อื ไม่ อัปราฮัม พะจาว ลอต โฮว คระ โฮว แตะ. อัปราฮัม เอีญ เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ซเงะ เซ เมือ กปู อื เตปด่า ลอา เซ ฮอยจ เมือง โซโด่ม. โลต งาวม โบ โตะ รเวือะ เวียง เซ. เญือม ชวน อื ปุย ลอา เซ โกฮ โฮว รชึง อื. นุ่ม ปอ จิ ไกญ แตะ เตะ. ");
INSERT INTO lcp_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","อัฮ เฮี ละ อื, “จาวไน, อาึ ปัว โม เปะ วิฮ เญือะ เญะ. เอีจ ไก ก ไอจ ก โซม เปอะ. ซ โฮลฮ เปอะ รไซจ เตะ ชวง แตะ. ไอจ ติ ซาวม เมอ. ซง่าวป เกียฮ งาวป โกฮ เปอะ ลอต เปอะ โฮว คระ ฆวต โฮว แตะ นึง,” อัฮ เซ ละ อื. เตปด่า ลอา เซ โลยฮ อื ตอก เฮี, “มัฮ อื ญุ่ก, เอะ ซ ไอจ นึง ตะ โบรก เวียง เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","โลต อัฮ เลาะ อัฮ ลาึน อื ละ อื. แปน เนอึม ฮาวก เญือะ โลต ฆาื อื. โลต ดวน กวนไจ ยุฮ แตะ ยุฮ คโนมปัง ละ อื. เกือฮ อื พรี โซม ตุม ไอฮ ละ อื. เญือม เอีจ ฟวยจ พรี อื เซ เกือฮ อื โซม. ");
INSERT INTO lcp_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ซาวม เซ กา ไอจ อื ปรเมะ เมือง โซโด่ม เซ ฮอยจ รวิต เญือะ เซ. โม ปรเมะ เวียง เซ เตือง ป กวต ป บุฮ ฮอยจ โอยจ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","รโอง อัฮ เฮี ละ โลต, “ตัว ปรเมะ ฮอยจ ไอจ เญือะ เปะ เอ? ตาว เกือฮ โอก เคะ เอะ,” อัฮ เซ. ปรเมะ เมือง โซโด่ม เซ ฆวต ไอฮ ปุ แตะ ไม่ ปรเมะ ฮอยจ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","โลต โอก ก พริ. รบิต รเวือะ ลั่กเคะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","อัฮ เฮี ละ ปุย โฮวน เซ, “ซไฮ, อาึ ปัว โม เปะ โอ ยุฮ ป พังไฮะ ลอน ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ง่อต แลน, อาึ ไก ลอา ปุย กวน เครีฮ ฮี. มัฮ ลั่ง ปเครีฮ ม่อง ลั่ง. อาึ ซ ตาว เกือฮ โอก ละ โม เปะ. ยุฮ ละ อื ตัม ป ฆวต ยุฮ เปอะ เมิฮ. ปรเมะ ฮอยจ เฮี ปังเมอ โอ เปอะ ไมจ ยุฮ กัน ไอฮ พาวม แตะ ไม่. มัฮ แคก เลือ ฮอยจ เปิง เญือะ เญะ. ไมจ อาึ โซะโกะ ฮรักซา นึง,” อัฮ เซ ละ ปุย โฮวน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","ปุย โฮวน เซ อัฮ เฮี, “ปะ ปุย ตังเมือง เงอ, ตอ แปฮ. ฮอยจ เปิง เปอะ เมือง เอะ. ปเลี่ย เฮี ฆวต เตียง แม เปอะ เอะ. ตอ แปฮ. ดัฮ เปอะ โอ ตอ ซ ยุฮ ป พังไฮะ ละ ปะ โฮฮ ฮา ตะ แตะ ยุฮ ละ โม เซ แม,” อัฮ เซ. ฟวยจ เซ ญุยฮ โลต. ริ ตัม รเวือะ เญือะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","เญือม เซ ปุย ลอา ป อาวต โตะ เญือะ อื เซ ซนาว เตะ แตะ เมือะ พราวป โลต เลียก โตะ เญือะ. ซอง รเวือะ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","เกือฮ ปุย โฮวน เซ จัก เตือง มู แตะ. โม เซ เญือะ เกียฮ ยุ โตว โตะ รเวือะ ฆาื อื. บู่เบื่อ ปุ โฮว โอเอีฮ. ");
INSERT INTO lcp_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ปุย ลอา เซ อัฮ เฮี ละ โลต, “อัม ไก ลั่ง กวน เฌือต เปอะ นึง เวียง เฮี? ดัฮ ไก ลั่ง โฮ, กวน รเมะ กวน รโปวน เปอะ ไม่ กวนพา เปอะ ญุ่ก, คระ เฌือต ไฮญ เปอะ ญุ่ก, ไมจ เปอะ ตาว เกือฮ โอก แปฮ ฮา เมือง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","เอะ ซ ยุฮ ไลจ ไม่ เมือง เฮี. พะจาว เอีจ ฮมอง ตอก ฟอง ปุย ปุย เมือง เฮี นึง ฆอก กัน ยุฮ อื. เอีจ เกือฮ เอะ โฮว ยุฮ ไลจ ไม่ เมือง เฮี ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","เญือม เซ โลต โอก ลปุง ไม่ ป ลัง มัฮ กวนพา แตะ ป ซ ไอฮ กวน รโปวน แตะ เซ. อัฮ เฮี ละ อื, “ซไจ แปฮ โอก ฮา เมือง เฮี. พะจาว ซ ยุฮ ไลจ ไม่ เมือง เฮี แกล,” อัฮ เซ ละ อื. กวนพา อื เซ โคะ อื มัฮ อัฮ อื ป เลน ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","เญือม เอีจ ซ ปวยฮ พริ อี เตปด่า โม เซ ดวน โลต ซไจ โอก. “ซไจ, ตาว ปรโปวน เญือะ เปอะ ไม่ กวน เครีฮ ลอา เปอะ เซ. โอก แปฮ เดอึม เปอะ โอ ซ ยุม ไม่ ปุย เญือม ไลจ เมือง เฮี,” อัฮ เซ ละ อื เตปด่า เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","โลต ฆวต ลบลี แนฮ ลั่ง ซ โอก แตะ. พะจาว ปังเมอ เลียก พาวม นึง อื. ปุย ลอา เซ โตวก โรวก เตะ อื ไม่ เตะ ปรโปวน เญือะ อื ไม่ กวน ลอา อื เซ ตาว อื โอก ฮา เวียง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","เญือม เซ ปุย ติ อื เซ อัฮ เฮี, “ไมจ เปอะ ตอ ยุม ตอ ไอม. ปุ แมฆี ลั่กเคะ เปอะ เฟือฮ. ปุ อาวต ก ลโลวง อื. ตอ ฮอยจ นึง บลาวง เงอ เดอึม เปอะ โอ ซ ยุม,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","โลต อัฮ เฮี, “จาวไน, ปุ อัฮ ตอก เซ. อาึ ปัว เนอึม นึง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","เอีจ กุน เนอึม เนิ ป ยุฮ เปอะ ละ อาึ อื นึง เกือฮ เปอะ อาึ ไอม. อาึ ปังเมอ ฮลัต ติ แตะ โอ เตือน ฮอยจ นึง บลาวง เซ. ซไง ลอน เนิ. ฮลัต ติ แตะ ยุม นึง คระ. ");
INSERT INTO lcp_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ตึต แตะ, ย่วง แตวะ เซิต เตอ ซดิ เญี่ยะ. ซ เตือน ฮอยจ นึง. เกือฮ อาึ ตอ อาวต นึง นา เซ. ซ ไอม เมอะ เบือ อื ย่วง แตวะ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","เตปด่า เซ อัฮ เฮี, “เออ แปน, อาึ ญอม เกือฮ เปอะ อาวต นึง. ซ ยุฮ โตว ไลจ ไม่ ย่วง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ซไจ. ตอ โฮว เมิฮ. อาึ ดิ เกียฮ ยุฮ โตว โอเอีฮ กา เฆียง ฮอยจ เปอะ นา เซ,” อัฮ เซ ละ อื. มอยฮ ย่วง เซ ปุย ลอต อัฮ โซอัน ละ อื นึง อัฮ โลต “แตวะ” ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","เญือม เอีจ ฮอยจ โลต นึง ย่วง โซอัน เอีจ โอก ซเงะ เอ. ");
INSERT INTO lcp_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","เญือม เซ พะจาว เกือฮ งอ รเออึป ไม่ มัต ราื นึง เมือง โซโด่ม ไม่ เมือง โกโมรา. ราื ตอก เฮละ ตอก แพร โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","เมือง ลอา เซ ไม่ เตะ ลโลวง นา เซ เตือง ปุย นึง อื ไม่ โอเอีฮ ป ไอม นึง นา เซ ฮะ ไลจ โอยจ แกล. ");
INSERT INTO lcp_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ปรโปวน เญือะ โลต ปังเมอ แมฆี แลน ลั่กเคะ แตะ. เมือต แมฆี ลั่กเคะ แตะ โกะ อื ลอต เอิน แปน ด่อง กิฮ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","เมือ กซะ อื เซ อัปราฮัม งาวป โฮว ฮอยจ นา ก โฮลฮ แตะ ลปุง ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","แก เมือง โซโด่ม ไม่ เมือง โกโมรา เน่อึม นึง ไกญ บลาวง เซ. ชวน เตะ ลโลวง เน่อึม นา เซ. ชวน มัฮ โอยจ อื ม่าึต งอ ตอก ม่าึต งอ เญือม โตก ปุย ม่า โฮ. ระ เนอึม ระ แนม งอ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","เญือม ยุฮ พะจาว ไลจ ไม่ เมือง เตะ ลโลวง ก อาวต โลต เซ พะจาว ไตม อัปราฮัม. เกือฮ โลต โอก เบือ อื. เกือฮ โตว อื ยุม ไม่ ปุย ไฮญ. ");
INSERT INTO lcp_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","เญือม เซ โลต ฮลัต นึง ซ อาวต แตะ นึง ย่วง โซอัน เซ. ตอ ฆาื อื ไม่ กวน เครีฮ ลอา แตะ เซ. ฮาวก อาวต นึง บลาวง ติ โดฮ, เลียก อาวต โตะ ทัม. ลอต อาวต ไม่ กวน แตะ โตะ ทัม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ติ ซเงะ อื ป มัฮ กวน โรง อื อัฮ อื ละ ปุ แตะ ตอก เฮี, “เปือะ เกอะ เอีจ กวต. แควน เฮี ไก โตว ปรเมะ นึง เฟือฮ ป ซ เญือะ ไม่ เอะ ตอก กอ ยุฮ ปุย อื โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ไมจ เอะ จุ เปือะ เกอะ เกือฮ ญุ ไปล เดอึม ซ ญอม ไอจ ไม่ เอะ ละ ซ โฮลฮ กวน แตะ นึง, เดอึม เอะ โอ ซ ดุต เจือ นึง ปลัฮเตะ เฮี,” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ซาวม เซ เกือฮ เนอึม เปือะ แตะ ญุ ไปล ปอ ญุ่ยจ อื เอิน. กวน โรง อื เซ เลียก ไอจ ไม่ เปือะ แตะ. เปือะ อื เซ ยุง โตว เญือม เลียก ไอจ อื ไม่ เญือม โกฮ อื เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ปวยฮ พริ เซ ออระ อื เซ อัฮ อื ละ ปุ แตะ ตอก เฮี, “รเอฮ ซาวม อาึ ไอจ ไม่ เปือะ เกอะ. เนฮ ก ซาวม เฮี ไมจ เอะ เกือฮ แม เปือะ เกอะ ญุ ไปล ติ โฮน แม. ไมจ แม ปะ เลียก ไอจ ไม่ ละ ซ โฮลฮ เปอะ กวน แตะ นึง, เดอึม เอะ โอ ซ ดุต เจือ นึง ปลัฮเตะ เฮี,” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","ซาวม เซ ปุย ลอา เซ เกือฮ แม เปือะ แตะ ญุ ไปล ติ โฮน แม. ป มัฮ กวน รเคะ อื เซ เลียก ไอจ โรฮ ไม่ เปือะ แตะ. เปือะ อื เซ ยุง โตว เญือม เลียก ไอจ อื ไม่ เญือม โกฮ อื เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","มัฮ ตอก เซ ตอก โฮลฮ กวน รโปวน โลต เซ โรวก กวน แตะ ไม่ เปือะ แตะ เตือง ลอา อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","กวน โรง อื เซ เกิต กวน รเมะ ติ. อัฮ โมอัป ละ อื. ปุย เซ ลอต แปน จัตเจือ ไพรม ปุย โมอัป ฮอยจ ปเลี่ย. ");
INSERT INTO lcp_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","กวน รเคะ อื เซ เกิต โรฮ กวน รเมะ ติ. อัฮ เบ่นอัมมี ละ อื. ปุย เซ ลอต โรฮ แปน จัตเจือ ไพรม โม อัมโมน ฮอยจ ปเลี่ย. ");
INSERT INTO lcp_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","อัปราฮัม โฮว ฮา ก อาวต มัมเร เซ เลีฮ ก เซฮ ปุ ปุ, ฮอยจ นึง ลาึน เนเกป, อาวต ซน่ะ ย่วง คาเด่ต ไม่ ย่วง ชู. กัง เคะ เอ ลอต อาวต เมือง เก-รา. ");
INSERT INTO lcp_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","เญือม อาวต อื นา เซ อัฮ ซารา ป มัฮ ปรโปวน เญือะ แตะ มัฮ รนัน แตะ. เญือม เซ อาบี่เมเลก ป มัฮ กซัต เมือง เก-รา เซ เกือฮ ปุย ตาว ซารา ฮอยจ เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","เญือม เอีจ เติง เมือ ก ซาวม อื กซัต เซ รโมะ ยุ ฮอยจ พะจาว เคะ แตะ. อัฮ เฮี ละ อื, “ปะ ซ ยุม เปอะ ฆาื ไอฮ แตะ ปรโปวน เซ นึง เอีจ ไก ปุย เญือะ อื,” อัฮ เซ ละ อื พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","กซัต อาบี่เมเลก เซ ดิ เตือน โตว ไอจ ดิ ไม่ อื. อัฮ เฮี ละ พะจาว, “โอ พะจาว. อัม ซ ยุฮ เปอะ ยุม ไม่ ปุย โอ ไก พิต เตือง อาึ เตือง ปุย เมือง เงอะ เฮี? ");
INSERT INTO lcp_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","มัฮ อัปราฮัม ไอฮ ป อัฮ มัฮ รนัน แตะ. โกะ อื อัฮ โรฮ อื ตอก เซ. อาึ ยุง โตว มัฮ อื ป พิต. เซ ป โคะ ยุฮ ตอก เซ ฆาื อื. รพาวม อาึ ซง่ะ ซงอม นึง ไลลวง เฮี,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","รโมะ แม ยุ อัฮ พะจาว เฮี ละ แตะ, “เนอึม, อาึ ยุง เงอะ ซง่ะ ซงอม รพาวม ปะ นึง ไลลวง เฮี. มัฮ เซ ป คัต อาึ เปอะ ฆาื อื นึง ริ เปอะ ยุฮ ป พิต. เอีจ มัฮ ฆาื เซ ป โอ อาึ เกือฮ เปอะ ลอก ปรโปวน เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ปเลี่ย เฮี ไมจ เปอะ เกือฮ เอีญ เคะ ปรเมะ เญือะ แตะ. ปุย เซ มัฮ ป ซึป ลปุง อาึ ละ ปุย. ซ ไววอน เพือ เปอะ เดอึม เปอะ โอ ซ ยุม. ดัฮ เปอะ โอ เกือฮ เอีญ อาึ ซ อัฮ ป เนอึม ละ เปอะ. ซ ยุม เนอึม เปอะ, เตือง ปะ เตือง โม ลุกเมือง เปอะ โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","ปวยฮ พริ เซ เมือ กซะ งาวป อื อาบี่เมเลก กอก โม กวนไจ ยุฮ แตะ. รโฮงะ ไลลวง เซ ละ อื เตือง โอยจ อื. โม เซ ฮลัต เนอึม ฮลัต แนม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","เญือม เซ อาบี่เมเลก กอก เอิน อัปราฮัม ฮอยจ เคะ แตะ. อัฮ เฮี ละ อื, “เมอยุ ยุฮ เปอะ โอเอีฮ เฮี ละ เอะ เอ? อาึ อัม ไก เญือม ยุฮ ป พิต ละ ปะ อา? เกียฮ ยุฮ โน่ง เปอะ โอเอีฮ ป ซ แปน ป ฆอก ลัมเลือ ละ อาึ ไม่ เมือง อาวต เตอะ ตอก เฮี เมอ? ปะ ยุฮ เปอะ ป โอ แตะ ลัมเปิง ยุฮ เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","มัฮ เมอ ป ง่อต เปอะ? เกียฮ อัฮ โน่ง เปอะ ป โอ เนอึม ละ อาึ ตอก เซ เมอ?” อัฮ เซ กซัต เซ. ");
INSERT INTO lcp_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","อัปราฮัม อัฮ เฮี, “อาึ แกต เตอะ ปุย นา เฮี โอ ฮลัต นึง พะจาว ติ เนอึม. แกต ปุย ซ ยุฮ ยุม ไม่ แตะ ละ ซ โฮลฮ อื ไอฮ ปุย เญือะ อะ. ");
INSERT INTO lcp_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ป เนอึม นึง อื ปุย เฮี มัฮ เนอึม รนัน เนอะ. เอะ มัฮ กวน ติ เปือะ ปังเมอ มัฮ มะ โน่งๆ แตะ. อาึ เอีจ ไอฮ เนอึม แปน ปุย เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","พะจาว เอีจ เกือฮ อาึ โอก ฮา ย่วง เปือะ เกอะ ฮอยจ อาวต ไม่ ปุย ตัง เมือง. อาึ เอีจ อัฮ เนอึม ละ ซารา ตอก เฮี ฆาื อื, เญือม โฮว เยอะ ฮอยจ เมือง ออฮ เมือง เอีฮ ญุ่ก, ปะ ไมจ เปอะ อัฮ ติ แตะ มัฮ รนัน อาึ ละ ซ นัปทื แตะ อาึ. อาึ เอีจ เกือฮ เนอึม อัฮ อื ตอก เซ โครยญ เมือง ฮอยจ แตะ,” อัฮ เซ อัปราฮัม. ");
INSERT INTO lcp_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","เญือม เซ อาบี่เมเลก เกือฮ ซารา เอีญ แม เคะ อัปราฮัม ตอก ไพรม แตะ. เกือฮ โรฮ แกะ ละ อัปราฮัม ไม่ โมวก ไม่ กวนไจ อื ง่อน. ");
INSERT INTO lcp_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","อัฮ เฮี ละ อัปราฮัม, “แก แลน เมือง ยุฮ อาึ เฮี. เตอึม ก ฆวต อาวต เปอะ นึง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","อัฮ แม เฮี ละ ซารา, “อาึ เอีจ เกือฮ มาื ละ เพร เปอะ ติ เปือน เชเคน ละ ซ เปลีฮ ที ละ ปุย โอ อาึ ดิ ยุฮ ป พิต ละ ปะ. ปุย เตือง โอยจ อื ซ ยุง ซง่ะ ซงอม ลั่ง ปะ นึง ไลลวง เฮี ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","เญือม ริ อาบี่เมเลก ไอฮ ซารา ปรโปวน เญือะ อัปราฮัม เซ, พะจาว เอีจ เกือฮ ปรโปวน ป อาวต ไม่ อาบี่เมเลก แปน ตอก ปุย ซแกต, เกียฮ ไก โตว กวน ติ ปุย เนอึม. เญือม ไววอน อัปราฮัม เพือ อาบี่เมเลก เซ, พะจาว เกือฮ อื โปน ฮา ป ตะ แตะ ยุฮ ละ อื เซ. เกือฮ โรฮ ปรโปวน เญือะ อาบี่เมเลก ไม่ โม กวนไจ รโปวน อื เกียฮ ไก แม กวน ฆาื อื ตอก ไพรม แตะ โครยญ โฆะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","พะจาว เกือฮ เนอึม ซารา โรวก ตัม รซอม ซันญา แตะ อาึง ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","เญือม เอีจ เติง เวลา อื, เกิต เนอึม กวน รเมะ ละ อัปราฮัม เตือง เอีจ กวต แตะ. กวนดุ เซ เกิต เนอึม ตัม เวลา อัฮ พะจาว อาึง ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","อัปราฮัม อัฮ ยิซฮัก ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","เญือม เอีจ ฟวยจ เกิต อื ซเตะ ซเงะ เอ, อัปราฮัม เกือฮ อื ไอฮ ริตกิต ตัม ป ดวน พะจาว แตะ ยุฮ. ");
INSERT INTO lcp_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","เญือม เกิต ยิซฮัก เซ อัปราฮัม ไก ติ รอย เนอึม อาญุ อื. ");
INSERT INTO lcp_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ซารา อัฮ เฮี, “พะจาว เอีจ เกือฮ อาึ โฮลฮ ญวยฮ ไม่ ไมจ มวน รพาวม แตะ. เมาะ ป ฮมอง ไลลวง เฮี ซ ญวยฮ โรฮ ไม่ เยอะ. ");
INSERT INTO lcp_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","มัฮ ปุย ป โรวต รโฮงะ ละ อัปราฮัม ซ โฮลฮ ลั่ง อาึ เกือฮ กวน แตะ ปุ อู? แจง โอ อื ไก. อาึ ปังเมอ โฮลฮ ลั่ง กวน แตะ ละ เญือม เอีจ กวต อื,” อัฮ เซ ซารา. ");
INSERT INTO lcp_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","กวนดุ เซ ระ ฮอน ปุ ปุ. ซเงะ ละ อื ตาึฮ ฮื, อัปราฮัม กอก ปุย ฮอยจ เคะ แตะ โฮวน. เลียง ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ติ ซเงะ อื แม อิชมาเอน กวน ฮากา ป โฮลฮ อื ละ อัปราฮัม เซ รง่ะ ดิ ไม่ ยิซฮัก กวน ซารา เซ. อิชมาเอน ยุฮ ป วัว รพาวม ยิซฮัก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","ปุก ยุ ซารา อื. อัฮ เฮี ฆาื อื ละ อัปราฮัม, “ไมจ เปอะ โครฮ ปรโปวน ป มัฮ ครา เซ ไม่ กวน อื โรฮ เกือฮ โอก แปฮ ฮา เอะ. อาึ ญอม โตว เกือฮ กวน ปรโปวน ป มัฮ ครา เฮี รฆุ ดิ คาวคอง ยุฮ เปอะ ไม่ ยิซฮัก กวน อาึ เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","อัปราฮัม ตุก เนอึม รพาวม ฆาื ป ฮมอง แตะ เซ นึง มัฮ โรฮ อิชมาเอน เซ กวน อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","พะจาว ปังเมอ อัฮ เฮี ละ อัปราฮัม, “ปุ ตุก รพาวม นึง ไลลวง กวนดุ เซ ไม่ กวนไจ เปอะ เซ. ยุฮ ตัม ป อัฮ ซารา เซ. อาึ ซ เกือฮ จัตเจือ เปอะ พรุฮแพร เน่อึม นึง ยิซฮัก เฮี ตัม ลปุง ซันญา แตะ อาึง. ");
INSERT INTO lcp_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","กวน เปอะ ป เกิต เน่อึม นึง กวนไจ เปอะ เซ อาึ ซ เกือฮ โรฮ พรุฮแพร ปอ แปน อื ปุย ติ ปะเทต นึง เอีจ มัฮ โรฮ อื กวน เปอะ โรฮ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","ปวยฮ พริ เซ อัปราฮัม งาวป โกฮ. ตุย ป โซม ป ปอน ไม่ ปัง ฮัก นาวก นึง รอาวม เกือฮ อื ละ ฮากา, เกือฮ อื ปุยฮ โรวก อื. มอป กวน แตะ ละ อื เกือฮ อื โฮว. ปรโปวน เซ โอก โฮว เนอึม. เญือม เอีจ ฮอยจ อื นึง ลาึน เวือฮ เบ่เออเชบ่า เซ โฮว ไป โฮว มา ฆาื โอ อื ยุง คระ ซ โฮว แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","เญือม เอีจ โอยจ รอาวม โรวก อื เซ เกือฮ กวน แตะ เซ อาวต ฆรึม โคะ แตวะ ติ. ");
INSERT INTO lcp_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","โกะ อื โฮว อาวต ฮา อื ซไง บุย โรฮ เมาะ ติ เจน โฮว โนง กังกอน. อัฮ เฮี, “ปุ เกือฮ อาึ โฮลฮ ยุ ยุม กวน แตะ เฮี,” อัฮ เซ โตะ รพาวม แตะ. โฮว งาวม รเตือป อื, เยือม เรียง. กวน อื เซ เยือม โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","พะจาว ฮมอง เยือม กวนดุ เซ. เญือม เซ เตปด่า พะจาว อัฮ เฮี ละ ฮากา เน่อึม นึง มะลอง, “ฮากา, เมอ ตุก รพาวม เปอะ นึง อื? ปุ ฮลัต นึง โอเอีฮ ฮี. พะจาว เอีจ ฮมอง อื เยือม กวนดุ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","โกฮ, โฮว เคะ อื, ลบุ่ฮ. เกาะ โลม รพาวม อื. อาึ ซ เกือฮ จัตเจือ อื แปน ปะเทต ระ ติ,” อัฮ เซ ละ ฮากา. ");
INSERT INTO lcp_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","เญือม เซ พะจาว เกือฮ ไง่ ฮากา ซเปีย. ชวน นัมโม่ ติ โดฮ. โฮว เชียต รอาวม ปอ นาวก อื ยุฮ ปัง ฮัก ยุฮ แตะ, เอีญ เกือฮ กวน แตะ ญุ อื. ");
INSERT INTO lcp_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","พะจาว อาวต ไม่ กวนดุ เซ. เญือม เอีจ ระ อื อาวต นึง ลาึน เวือฮ เมือง พารัน. แปน ปุย แมน นึง กอ ปุน แตะ ซัตซิง. ");
INSERT INTO lcp_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","มะ อื โฮว ซาวป ปรโปวน เญือะ อื ละ อื นึง เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ฟวยจ เซ อาบี่เมเลก ไม่ ฟีโคน ฮัวนา ตฮัน ยุฮ อื โฮว ดิ เคะ อัปราฮัม. อัฮ เฮี ละ อื, “ยุฮ เปอะ กัน ออฮ กัน เอีฮ ญุ่ก เอีจ ที อาวต พะจาว ไม่ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","อาึ ฆวต เกือฮ เปอะ ซันญา อาึง ซองนา พะจาว นา เฮี นึง โอ เปอะ ซ บ่วก ละ อาึ, เตือง กวน เนอะ เตือง จัตเจือ เยอะ เฆียง เฮี. บุน เอีจ ฟวยจ อื อาึ เอีจ เนอึม รพาวม เมอะ ละ ปะ อา. ฆวต เกือฮ โรฮ เปอะ ซันญา อาึง ละ ซ เนอึม โรฮ รพาวม เปอะ ละ อาึ, ไม่ ซ เนอึม รพาวม เปอะ ละ เมือง ฮอยจ อาวต เปอะ นึง เฮี โรฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","อัปราฮัม อัฮ เฮี, “เออะ, อาึ ซ ซันญา อาึง ซโตฮ ละ เปอะ ตอก เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ฟวยจ เซ อัปราฮัม รโฮงะ ไลลวง นัมโม่ ติ โดฮ ป เอีจ ลู โม กวนไจ ยุฮ อาบี่เมเลก เซ ฮา แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","อาบี่เมเลก อัฮ เฮี, “อาึ ยุง โตว ป ลู นัมโม่ เซ. ปะ รโฮงะ เปอะ โตว เนิ ไพรม อื. เดอึม ปเลี่ย เฮี ฮมอง เงอ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","เญือม เซ อัปราฮัม เกือฮ แกะ ยุฮ แตะ ละ อาบี่เมเลก ไม่ โมวก ง่อน. ปุย ลอา เซ ซันญา อาึง โอเอีฮ ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","อัปราฮัม รกัฮ กวน แกะ ชัง เกือฮ อาวต โน่ง ฮา โฮมว แตะ อาแลฮ ตัว. ");
INSERT INTO lcp_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","อาบี่เมเลก ไฮมญ อัปราฮัม เซ ฆาื อื ตอก เฮี, “รกัฮ เปอะ ละ เมอ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","อัปราฮัม โลยฮ อื ตอก เฮี, “เฮี มัฮ ป ซ เกือฮ ละ ปะ. ดัฮ เปอะ ไอฮ กวน แกะ ชัง อาแลฮ เฮี, เอีจ มัฮ โรฮ แจง เปอะ นึง มัฮ อาึ ป กาวง นัมโม่ เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","มัฮ เซ ป ลอต ปุย อัฮ เบ่เออเชบ่า ไม่ นัมโม่ เซ ฆาื อื, นึง มัฮ อื ก ซันญา ปุย ลอา เซ อาึง โอเอีฮ ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ฟวยจ ซันญา อื อาึง โอเอีฮ ไม่ ปุ แตะ นึง เบ่เออเชบ่า เซ, อาบี่เมเลก ไม่ ฟีโคน เอีญ แม นาตี อาวต โม ฟีลิซเตีย, ป มัฮ เมือง แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","เญือม เซ อัปราฮัม ซมา โคะ แทมริก นึง เบ่เออเชบ่า เซ, ไววอน กอก รโฮงะ มอยฮ พะจาว ป ไอม ลอป นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ฟวยจ เซ อัปราฮัม อาวต เมือง ฟีลิซเตีย เลี่ญ. ");
INSERT INTO lcp_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","กัง เคะ เอ พะจาว ลอง รพาวม อัปราฮัม ติ เจือ. กอก อื, “อัปราฮัม,” อัฮ เซ ละ อื. อัปราฮัม โลยฮ อื, “โอ พะจาว, อาึ อาวต นา เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","พะจาว อัฮ เฮี ละ อื, “ตาว กวน เปอะ ป มัฮ กวน ติ เปอะ เซ. อาึ มัฮ อัฮ ฮะ ไม่ ยิซฮัก ป ฮรัก เปอะ เซ. โฮว ตาว ฮอยจ นึง นาตี โมริยา. เญือม เอีจ ฮอยจ เปอะ นา เซ ไมจ เปอะ มอก ตอง ทไว ละ อาึ นึง บลาวง ติ โดฮ ก ซ รโฮงะ อาึ ละ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ปวยฮ พริ เซ อัปราฮัม เซฮ อาึง เคิ ละ ซ โรวก แตะ ตาึง, อาึง อื นึง รตัง บรัง ยุฮ แตะ. เกือฮ ยิซฮัก ไม่ โม กวนไจ ยุฮ แตะ ลอา ปุย โฮว ไม่ แตะ. โอก โฮว ละ ซ ฮอยจ แตะ นา ก รโฮงะ พะจาว ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ซเงะ ลอวย นึง อื อัปราฮัม ชวน บลาวง เซ ก ซไง อื. ");
INSERT INTO lcp_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","เญือม เซ อัฮ เฮี ละ กวนไจ แตะ, “โม เปะ อาวต นา เฮี เยอ ไม่ บรัง. อาึ ไม่ กวน เนอะ ซ โฮว ไว พะจาว ลั่กเติต. ดัฮ เอีจ ฟวยจ ไว โฮ, เอะ ซ แม แม เคะ เปอะ ฮอยจ นา เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","อัปราฮัม เกือฮ ยิซฮัก ปุยฮ โรวก เคิ ละ ซ ตาึง แตะ. โกะ อื โรวก มิต ไม่ รฆุ งอ ละ ซ จอป แตะ งอ นึง. โฮว ดิ ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ยิซฮัก ไฮมญ อื, “เปือะ,” อัฮ เซ. “เมอ อัฮ เปอะ กวน?” อัฮ เซ. ยิซฮัก อัฮ เฮี, “รฆุ งอ ไม่ เคิ อี เอีจ โรวก ตื เปอะ. กวน แกะ ละ ซ ตอง เปอะ ทไว เซ อาวต ก เมอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","อัปราฮัม โลยฮ อื ตอก เฮี, “พะจาว ซ โพต ไอฮ แกะ เนิ ละ ซ ตอง เงอะ ทไว,” อัฮ เซ ละ อื. เญือม เซ โฮว ดิ แนฮ ลั่กกา แตะ ปุ ปุ. ");
INSERT INTO lcp_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","เญือม เอีจ ฮอยจ อัปราฮัม นา ก รโฮงะ พะจาว ละ แตะ เซ, อัปราฮัม รชุก ซโมะ ยุฮ คัน นึง อื. รแทม เคิ นึง อื. ฟวยจ เซ รเบี่ยก กวน แตะ อาึง อื นึง คัน ราว เคิ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ตุย มิต ละ ซ ยุฮ แตะ ยุม ไม่ กวน แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","เญือม เซ เตปด่า ยุฮ พะจาว กอก อัฮ เฮี ละ อื เน่อึม นึง มะลอง, “อัปราฮัม, อัปราฮัม,” อัฮ เซ ละ อื. “โอ พะจาว, อาึ อาวต นา เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","เตปด่า เซ อัฮ เฮี, “ปุ ยุฮ ป โซะ ละ กวน เปอะ. ปุ ลอก เฟือฮ เอิน. ปเลี่ย เฮี อาึ เอีจ ยุง เงอะ นัปทื เนอึม เปอะ พะจาว นึง โอ เปอะ ฮลักกอ กวน ติ แตะ เซ ฮา อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","อัปราฮัม แก โอเอีฮ. ชวน แกะ ไฮมญ ติ ตัว คอม โด่วง นึง โตะ รัป, โฮว โฮมวต อื. มอก ตอง ทไว แกะ เซ ตัง กวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","อัปราฮัม ปุก มอยฮ นา เซ, อัฮ “เยโฮวายีเร” ละ อื, มัฮ อัฮ อื พะจาว โพต โอเอีฮ ไม่. ปุย อัฮ ลั่ง อื ตอก เฮี ฮอยจ ปเลี่ย เฮี, “พะจาว ซ โพต โอเอีฮ นึง บลาวง ยุฮ แตะ,” อัฮ ลั่ง อื ตอก เซ ลั่ง. ");
INSERT INTO lcp_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","เญือม เซ เตปด่า ยุฮ พะจาว เซ กอก แม อัปราฮัม เน่อึม นึง มะลอง ติ โฮน แม. อัฮ เฮี ละ อื, “เฮี มัฮ เนอึม ลปุง พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","อาึ มัฮ ซันญา อาึง ไลลวง เฮี ละ เปอะ ซโตฮ เบือ มอยฮ โกะ แตะ. มัฮ ฆาื โอ เปอะ ฮลักกอ กวน ติ แตะ ฮา อาึ นึง เนอึง เปอะ ป อัฮ อาึ. ");
INSERT INTO lcp_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","อาึ ซ ปิฮ เนอึม มุ่น ละ เปอะ. อาึ ซ เกือฮ จัตเจือ เปอะ พรุฮแพร โฮวน ตอก ซโมยญ นึง มะลอง โฮ. ซ โฮวน โรฮ ตอก ไฮมจ นึง เกาะ. จัตเจือ เปอะ เซ ซ เป โม ป ตอซู ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ปุย โครยญ เจือ ปุย ซ โฮลฮ รัป ป ไมจ เบือ จัตเจือ ปะ. โอเอีฮ เซ มัฮ โฮลฮ เปอะ เบือ เนอึง เปอะ ป อัฮ อาึ ละ แตะ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","อัปราฮัม เอีญ แม เคะ กวนไจ แตะ. ลอต เอีญ ดิ ไม่ อื ฮอยจ นึง เบ่เออเชบ่า ป มัฮ ย่วง อาวต แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","กังเคะ เอ ไก ติ ปุย ป ฮอยจ เคะ อัปราฮัม. อัฮ เฮี ละ อื, “มิละคา ปรโปวน เญือะ นาโฮ ป มัฮ ปุ เปอะ เซ เอีจ ไก กวน โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","กวน โรง อื มัฮ อุต. ปุ อุต เซ มัฮ บุ่ต. ฟวยจ เซ มัฮ เคมูเอน (ป มัฮ เปือะ อารัม.) ");
INSERT INTO lcp_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ไม่ เคเซต ไม่ ฮาโซ ไม่ ปินดั่ต ไม่ ยิตลัป ไม่ เบ่ทูเอน,” อัฮ เซ ละ อื. (เบ่ทูเอน เซ เอีจ มัฮ เปือะ เรเบ่คา.) ");
INSERT INTO lcp_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ปุย ซเตะ ปุย เซ มัฮ กวน รเมะ นาโฮ ไม่ มิละคา เซ. นาโฮ เซ มัฮ ปุ เลีฮ อัปราฮัม. ");
INSERT INTO lcp_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ปรโปวน แตวะ เญือะ นาโฮ เซ, มอยฮ อื มัฮ เรอูมา. ไก โรฮ กวน ปาวน ปุย. มัฮ เทบ่า, กาฮัม, ทาฮัต, ไม่ มาอาคา. ");
INSERT INTO lcp_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ซารา ไอม ฮอยจ ละ ไก อาญุ แตะ ติ รอย ไม่ ง่า โรฮ อาแลฮ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ฟวยจ เซ ยุม นึง ย่วง เฮปโรน เมือง คะนาอัน. อัปราฮัม เยือม อื นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","เญือม เซ อัปราฮัม โกฮ โฮว ฮา ป ยุม เซ, โฮว เคะ โม ฮิตไท. ");
INSERT INTO lcp_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","อัฮ เฮี ละ อื, “อาึ มัฮ ปุย ตังเมือง อาวต ลลาึง โม เปะ นา เฮี. ปัว เปอะ โชะ เตะ ละ อาึ ติ โดฮ ละ ซ รมอยจ เจอะ ปรโปวน เญือะ แตะ นึง,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","โม ฮิตไท อัฮ เฮี ละ อัปราฮัม, ");
INSERT INTO lcp_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“จาวไน, ง่อต ป อัฮ เอะ เอ. เอะ นัปทื ปะ. เมีญ โรฮ ปะ แปน ป ระ ลลาึง แตะ. เลือก เมิฮ โตะ ทัม ยุฮ เอะ เฮี. ไอฮ ป ปุก รพาวม เปอะ นึง. เอะ เฆรอึม ตื รพาวม นึง ซ เกือฮ แตะ โตะ รมอยจ ยุฮ แตะ ละ เปอะ ละ ซ รมอยจ เปอะ ปุย เญือะ แตะ นึง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","เญือม เซ อัปราฮัม นุ่ม ไว โม ฮิตไท เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","อัฮ เฮี, “ดัฮ ปุก รพาวม โม เปะ ละ ซ เกือฮ เปอะ อาึ รมอยจ ปุย เญือะ แตะ นา เฮี, ปัว เปอะ ไฮมญ เนิ นึง เอฟโรน กวน โซฮา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ปัว เปอะ เกือฮ โชะ โตะ ทัม ยุฮ แตะ เซ เนิ ป อัฮ ปุย มักเปลา ไม่ เซ. มัฮ ป อาวต เฆียง รปึม ยุฮ อื. เกือฮ โชะ อื เนิ ตัม โซมกวน อื ซองนา โม เปะ เฮี, ละ ซ แปน อื เบือง รมอยจ ละ โม เญือะ เญะ,” อัฮ เซ ละ โม เซ อัปราฮัม เมอ. ");
INSERT INTO lcp_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","โม ฮิตไท เซ งาวม ดิ นา ก โพรม แตะ นึง โบ โตะ รเวือะ เวียง เซ. เอฟโรน เซ งาวม โรฮ นา เซ. อัฮ เฮี ซองนา ปุย โฮวน เซ, ");
INSERT INTO lcp_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“จาวไน, ง่อต ป อัฮ อาึ อื, อาึ เกือฮ เยือ ละ เปอะ รปึม เซ, เตือง โตะ ทัม นึง อื. อาึ เกือฮ ละ เปอะ ซองนา โม คระ เฌือต แตะ เตือง โอยจ อื เฮี. ไอฮ เมิฮ. รมอยจ ปุย เญือะ เปอะ นึง,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","เญือม เซ อัปราฮัม นุ่ม ไว โม ฮิตไท เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","อัฮ เฮี ละ เอฟโรน เรียง ปอ ฮมอง ปุย เตือง โอยจ อื, “ปัว เปอะ ง่อต ป อัฮ อาึ เฮี, อาึ ซ รวี รปึม เซ นึง เปอะ. ไมจ เปอะ ไอฮ งวยฮ อื ตัม เมาะ โซมกวน อื. อาึ ซ รมอยจ ปุย เญือะ แตะ นึง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","เอฟโรน อัฮ เฮี ละ อัปราฮัม, ");
INSERT INTO lcp_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“จาวไน, รปึม เฮี งวยฮ ปาวน รอย เชเคน โน่ง, อัม มัฮ ป ที ญอย ปุย นึง ละ ปุ แตะ? ไอฮ เมิฮ. รมอยจ ปุย เญือะ เปอะ นึง,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","อัปราฮัม ญอม ไอฮ อื เมาะ เซ. ตุย ญอย ละ อื. แฆ มาื ละ อื ปาวน รอย เชเคน ตอก อัฮ อื ซองนา ปุย โฮวน เซ. โกว นัม นัก มาื ตัม ป โกว โม ปอกา เจน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","อัปราฮัม รวี เนอึม รปึม มักเปลา ป ไก ลวง ลั่ก โอก ซเงะ เญือะ มัมเร เซ ป มัฮ คอง เอฟโรน ไพรม อื. โฮลฮ อื เตือง รปึม เตือง โตะ ทัม เตือง โคะ ป ไก นึง อื เลี่ป รปึม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","แปน ป แจง แน นึง ปุน แปน โม ฮิตไท พีญัน อื เตือง โอยจ แตะ เญือม โพรม ดิ อื โบ โตะ รเวือะ เวียง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","เญือม เซ อัปราฮัม รมอยจ ซารา ปุย เญือะ แตะ โตะ ทัม อาวต นึง เมือง คะนาอัน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","มัฮ ตอก เซ ตอก โฮลฮ อัปราฮัม กุม รปึม ป มัฮ คอง โม ฮิตไท ไพรม อื เซ, เตือง โตะ ทัม นึง อื ละ ซ แปน อื รมอยจ ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","เญือม เซ อัปราฮัม เอีจ กวต เนอึม. พะจาว เอีจ โพต ป ไมจ ละ อื โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","อัปราฮัม กอก กวนไจ แตะ ป กวต อื ฮา ปุย เอีญ เคะ แตะ. ปุย เซ มัฮ ป กุม คาวคอง ยุฮ อัปราฮัม โครยญ เจือ. อัฮ เฮี ละ อื, “อาึง เตะ เปอะ ฆรึม รเวือง อาึ ละ ซ ซันญา เปอะ อาึง ซโตฮ ไม่ อาึ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ฆวต เกือฮ เปอะ ซันญา อาึง เบือ มอยฮ เยโฮวา พะจาว กุม ปลัฮเตะ ปลัฮ มะลอง นึง โอ เปอะ ซ ซาวป ปรโปวน เญือะ กวน อาึ ละ อื ลลาึง ปุย เมือง คะนาอัน เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ไมจ เปอะ เอีญ ฮอยจ เมือง ไพรม อาึ ไม่ ตุย เปอะ โรวก ปรโปวน เน่อึม นึง คระ เฌือต อาึ ละ ซ แปน อื ปรโปวน เญือะ ยิซฮัก ป มัฮ กวน อาึ เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","กวนไจ อื เซ ไฮมญ อื ตอก เฮี, “เมอ เตือง อื ปรโปวน นา เซ ซ ญอม โตว ละ เญือะ ม่า แตะ ละ ซ เอีญ อื ไม่ อาึ นา เฮี ยุ่ง. ดัฮ โอ ญอม ฮอยจ โฮ, อาึ อัม ซ ไมจ เกือฮ กวน เปอะ เอีญ ฮอยจ ย่วง ไพรม เปอะ ฆาื อื?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","อัปราฮัม อัฮ เฮี, “ตอก ออฮ ตอก เอีฮ ญุ่ก, ปุ เกือฮ กวน อาึ แม แม นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","เยโฮวา ป มัฮ พะจาว กุม มะลอง เอีจ ตาว อาึ โอก ฮา เญือะ มะเปือะ เกอะ, โอก ฮา เมือง เกิต เตอะ. เอีจ ซันญา อาึง อื ละ อาึ ซโตฮ นึง ซ เกือฮ อื เมือง อาวต เตอะ นา เฮี ละ จัตเจือ อาึ. พะจาว ซ เกือฮ เตปด่า ยุฮ แตะ โฮว ลั่กกา เปอะ นึง ซ โฮลฮ เปอะ ปรโปวน เญือะ อื ละ กวน อาึ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ดัฮ ปรโปวน นา เซ โอ ญอม เอีญ ไม่ เปอะ เญือะ พิต เปอะ โตว นึง รซอม ซันญา เปอะ เฮี. ตอก ออฮ ญุ่ก ตอก เอีฮ ญุ่ก, ปุ ตาว กวน อาึ อื โฮว ไม่ เปอะ นา เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","เญือม เซ กวนไจ อื เซ อาึง เนอึม เตะ แตะ ฆรึม รเวือง อัปราฮัม ป มัฮ ปอเลียง แตะ เซ. ซันญา อาึง อื ละ ซ ยุฮ แตะ ตัม ป อัฮ อัปราฮัม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","กวนไจ ป กุม คาวคอง ยุฮ อัปราฮัม เซ โรวก อุต ยุฮ ปอเลียง แตะ กาว ตัว, โรวก โรฮ โอเอีฮ ป ไมจ ป ญุ่ก, ป ระ งวยฮ ระ ตุง โฮวน เจือ, โฮว ไม่ อื ฮอยจ ย่วง อาวต นาโฮ นึง เมือง เมโซโปเตเมีย. ");
INSERT INTO lcp_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","เกือฮ อุต ยุฮ แตะ ลโล่ะ โบ นัมโม่ ป อาวต ก พริ ย่วง เซ. ปุก เมือ กปู อื เวลา กอ โฮว เชียต โม ปรโปวน รอาวม. ");
INSERT INTO lcp_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ไววอน ตอก เฮี, “โอ เยโฮวา, พะจาว ทื อัปราฮัม ปอเลียง อาึ, ปัว เปอะ เรอึม อาึ เกือฮ กัน ยุฮ ฮุ ฟวยจ. ปัว เปอะ ยุฮ ตัม ลปุง ซันญา เปอะ อาึง ละ ปอเลียง อาึ. ");
INSERT INTO lcp_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","อาึ เอีจ ฮอยจ โบ นัมโม่ เฮี. โม ปเครีฮ ย่วง เฮี กัมลัง โอก โฮว เชียต รอาวม นึง นัมโม่ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","อาึ ซ ปัว ปุย เชียต รอาวม ละ ซ เกือฮ อื อาึ ญุ. ดัฮ ไก ป อัฮ เนิ ตอก เฮี, ‘ญุ เมิฮ. อาึ ซ เชียต โรฮ รอาวม ละ อุต ยุฮ เปอะ โรฮ,’ ดัฮ อัฮ เซ เนิ, เกือฮ มัฮ ปุย เซ ป เลือก เปอะ อาึง ละ ซ แปน อื ปรโปวน เญือะ ยิซฮัก ป มัฮ กวนไจ เปอะ. ดัฮ แปน เนอึม ตอก อัฮ ฮะ เฮี อาึ ซ ยุง เนอึม ยุฮ ปะ อื ตัม ลปุง ซันญา เปอะ อาึง ละ ปอเลียง อาึ ฆาื อื,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ดิ เตือน โตว ลอยจ ไววอน อื เซ, เรเบ่คา ฮอยจ เอิน, กลอม โรวก อุง รอาวม. ปรโปวน เซ มัฮ กวน เบ่ทูเอน. เบ่ทูเอน เซ มัฮ กวน นาโฮ ไม่ มิละคา ปรโปวน เญือะ อื. นาโฮ เซ เอีจ มัฮ ปุ เลีฮ อัปราฮัม. ");
INSERT INTO lcp_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","เรเบ่คา เซ มัฮ ปเครีฮ ไมจ ลัมเลือ เนอึม. มัฮ โรฮ ปเครีฮ ม่อง ลั่ง. ฮอยจ นึง นัมโม่ เซ เลีฮ เชียต รอาวม ปอ นาวก อุง ยุฮ แตะ เซ, ฟวยจ เซ ฮาวก แม ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","กวนไจ ฮอยจ เซ ตอ เอีญ เคะ อื. อัฮ เฮี ละ อื, “ปัว ญุ รอาวม โตะ อุง ยุฮ เปอะ เญี่ยะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","ปรโปวน เซ อัฮ เฮี, “โปะ, ญุ เมิฮ,” อัฮ เซ. ซไจ บลาึฮ อุง รอาวม ยุฮ แตะ, ไปญ อื ละ อื เกือฮ อื ญุ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","เญือม เอีจ ฟวยจ ญุ อื, ปรโปวน เซ อัฮ เฮี, “อาึ ซ เชียต โรฮ รอาวม ละ อุต ยุฮ เปอะ โรฮ เกือฮ ญุ อื ซัก,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ซไจ โทก รอาวม ยุฮ แตะ โตะ กัวะ ญุ ซัตซิง รอาวม. ตอ แม เลีฮ เชียต รอาวม โตะ นัมโม่ เซ ฮอยจ ละ ฟวยจ ญุ โม อุต ยุฮ อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ปรเมะ เซ อาวต โฆย ละ ซ แลน ที แตะ กัน ยุฮ อื. มอง แลน ตอก เกือฮ พะจาว กัน ยุฮ แตะ ฟวยจ ไม่ โอ อื ฟวยจ. ");
INSERT INTO lcp_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","เญือม เอีจ ฟวยจ ญุ อุต โม เซ รอาวม เมอ, ปรเมะ เซ ฮอย ไคร รวอง โรวก แตะ เซ, ดุฮ อื นึง มาึฮ อื. นัมนัก ไคร เซ ไก บลัฮ เชเคน. เกือฮ แม เบล ไคร ระ ละ อื ติ กู, จาวป อื ละ อื นึง เตะ อื, นัมนัก กาว เชเคน. ");
INSERT INTO lcp_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","อัฮ เฮี ละ อื, “ปัว เปอะ รโฮงะ มอยฮ เปือะ เปอะ ละ แตะ. อัม ไก ก ไอจ นึง เญือะ เปือะ เปอะ ปอ ไอจ เอะ นึง อื?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","เรเบ่คา อัฮ เฮี, “เปือะ เกอะ มัฮ เบ่ทูเอน กวน นาโฮ ไม่ มิละคา. ");
INSERT INTO lcp_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","นึง เญือะ เญะ เอีจ โฮวน เบระ โฮวน ไรป ละ อุต ยุฮ เปอะ. ก ไอจ เปอะ ไก โรฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","เญือม เซ ปรเมะ เซ นุ่ม เอิน ติ แตะ ไววอน ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","อัฮ เฮี, “อาึ ลืลาว เยโฮวา พะจาว ทื อัปราฮัม. ปะ ละ โปวฮ เปอะ โตว รพาวม ฮรัก ตอน ฮมัน ไม่ รพาวม เนอึม ยุฮ เปอะ ละ ปอเลียง อาึ. ปะ เอีจ นัม เอิน เปอะ อาึ ฮอยจ เคะ คระ เฌือต ปอเลียง เงอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","ปรโปวน เซ ตอ เอีญ เคะ มะ แตะ ฮอยจ นึง เญือะ. รโฮงะ ไลลวง ป ยุ ป ฮมอง แตะ ละ ปุย โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","เอียกระ เรเบ่คา เซ มัฮ ลาบั่น, ตอ โอก ก พริ ย่วง ฮอยจ นึง นัมโม่ เซ. กวนไจ อัปราฮัม อาวต ลั่ง นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","เญือม เอีจ ยุ ลาบั่น ไคร รวอง โตะ มาึฮ รนัน แตะ ไม่ เบล ป ไก นึง เตะ อื, ไม่ เอีจ ฮมอง โรฮ อื ป อัฮ ป อู ปรเมะ เซ ละ รนัน แตะ เซ, โฮว ฆาื อื เคะ กวนไจ อัปราฮัม ป ชุง ลั่ง ไม่ อุต ยุฮ แตะ โบ นัมโม่ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","อัฮ เฮี ละ อื, “เอีญ ไม่ อาึ อื. ปะ มัฮ เปอะ ปุย โฮลฮ ยุ กุนมุ่น ยุฮ พะจาว. เมอยุ ชุง เปอะ นา เฮี? อาึ เอีจ เพรียง ฮอง ไอจ เปอะ โตะ เญือะ. ก อาวต อุต ยุฮ เปอะ ไก โรฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ปุย เซ ฮาวก เนอึม เญือะ เซ ฆาื อื. ลาบั่น โปต รตัง อุต ยุฮ อื เซ. เกือฮ เบระ เกือฮ ไรป ละ อื. ตุย โรวก รอาวม ละ กวนไจ ยุฮ อัปราฮัม ไม่ โม ป โฮว ไม่ อื เซ, เกือฮ อื รไซจ เตะ ชวง แตะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","เญือม เอีจ ทอย ปุย ป โซม ป ปอน ละ อื, ปุย เซ ปังเมอ อัฮ เฮี, “อาึ ญอม โตว โซม กา เฆียง โฮลฮ แตะ อัฮ ป ฆวต อัฮ แตะ,” อัฮ เซ. “อัฮ เมิฮ,” อัฮ เซ ลาบั่น. ");
INSERT INTO lcp_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ปุย เซ อัฮ เฮี, “อาึ มัฮ กวนไจ ยุฮ อัปราฮัม. ");
INSERT INTO lcp_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","พะจาว เอีจ เกือฮ ปอเลียง อาึ โฮลฮ รัป ป ไมจ โครยญ เจือ. เกือฮ อื กอย เตอึม เนอึม รโอฮ. เกือฮ แกะ ปิ, โมวก บรัง, ไม่ อุต ไม่ ไคร มาื ละ อื โฮวน. เกือฮ โรฮ กวนไจ รเมะ กวนไจ รโปวน ละ อื โฮวน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ซารา ป มัฮ ปรโปวน เญือะ ปอเลียง อาึ เซ โฮลฮ โรฮ กวน แตะ เญือม เอีจ กวต อื. ปอเลียง อาึ เอีจ เกือฮ โอเอีฮ ยุฮ แตะ ละ กวน เซ แตะ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ปอเลียง อาึ เอีจ เกือฮ อาึ ซันญา ซโตฮ อาึง อื ละ แตะ นึง โอ อื ซ เกือฮ อาึ ซาวป ปรโปวน เญือะ อื ละ กวน อื นึง เมือง คะนาอัน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","มัฮ เกือฮ อื อาึ โฮว ซาวป เลือก ลลาึง คระ เฌือต เญือะ เปือะ โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“อาึ อัฮ ละ ปอเลียง แตะ ตอก เฮี, ‘เมอ เตือง อื ปรโปวน นา เซ ซ ญอม โตว โฮว ไม่ อาึ ยุ่ง,’ อัฮ เซ ละ. ");
INSERT INTO lcp_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","ปอเลียง อาึ อัฮ เฮี เนิ, ‘พะเยโฮวา ป อาวต ลอป ไม่ อาึ ซ เกือฮ เตปด่า ยุฮ แตะ โฮว ไม่ เปอะ. ซ เกือฮ กัน ยุฮ เปอะ ฟวยจ. ซ โฮลฮ เปอะ ปรโปวน เญือะ กวน อาึ เนิ เน่อึม นึง คระ เฌือต อาึ ไอฮ. ซ มัฮ ปุย ไน จัตเจือ เปือะ เกอะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","ดัฮ เปอะ โฮว เนอึม เคะ เอียกปุ อาึ, ดัฮ โอ ญอม เอีญ ไม่ เปอะ โฮ, เญือะ พิต เปอะ โตว นึง รซอม ซันญา เปอะ อาึง เฮี,’ อัฮ เซ เนิ ปอ เลียง เงอ.” ");
INSERT INTO lcp_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“เนาะ เฮี เอะ ฮอยจ นึง นัมโม่ เซ, อาึ ไววอน ตอก เฮี, ‘โอ เยโฮวา, พะจาว ทื อัปราฮัม ปอเลียง อาึ, ปัว เปอะ เรอึม อาึ เกือฮ กัน ยุฮ ฮุ ฟวยจ. ");
INSERT INTO lcp_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","อาึ เอีจ ฮอยจ โบ นัมโม่. ตัม ฮอยจ ปเครีฮ เชียต รอาวม, อาึ ซ ปัว ญุ รอาวม นึง อุง ยุฮ อื เญี่ยะ. ");
INSERT INTO lcp_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","ดัฮ เกือฮ อาึ ญุ อื ไม่ เชียต โรฮ อื ละ อุต ยุฮ ฮุ เกือฮ มัฮ ปุย เซ ป เลือก ปะ แปน ปรโปวน เญือะ กวน ปอเลียง อาึ อื,’ อาึ ไววอน ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“ลไล ไววอน ลั่ง อาึ เซ ฮอยจ เอิน เรเบ่คา ไม่ กลอม แตะ โรวก อุง รอาวม ยุฮ แตะ. เลีฮ โตะ นัมโม่ เชียต รอาวม. อาึ ปัว ญุ รอาวม นึง. ");
INSERT INTO lcp_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","เรเบ่คา ซไจ บลาึฮ รอาวม ยุฮ แตะ, ‘ญุ เมิฮ, อาึ ซ เชียต โรฮ โฮะ ละ อุต ยุฮ เปอะ โรฮ,’ อัฮ เซ เนิ. อาึ ญุ เนอึม เมอะ. เชียต เนอึม โรฮ อื ละ อุต เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","อาึ ไฮมญ มอยฮ เปือะ อื. อัฮ ติ แตะ มัฮ กวน เบ่ทูเอน ป มัฮ กวน นาโฮ ไม่ มิละคา. เญือม เซ อาึ ดุฮ ไคร รวอง นึง มาึฮ อื. จาวป โรฮ เบล นึง เตะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ฟวยจ เซ อาึ นุ่ม ติ แตะ ไววอน ละ พะจาว. อาึ ลืลาว เยโฮวา พะจาว ทื อัปราฮัม ป ตาว อาึ ฮอยจ เอิน เคะ เญือะ เอียกปุ ปอเลียง เงอะ เฮี, ละ ซ โฮลฮ โฮะ ปรโปวน เญือะ อื ละ กวน ปอเลียง เงอะ. ");
INSERT INTO lcp_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ปเลี่ย เฮี ดัฮ โม เปะ ซ เนอึม รพาวม ละ ปอเลียง อาึ ปัว เปอะ รโฮงะ ละ แตะ. ดัฮ โอ แปน ปัว โรฮ เปอะ รโฮงะ ละ แตะ โรฮ เดอึม อาึ ซ ยุง ตอก ซ ไมจ แตะ ยุฮ,” อัฮ เซ กวนไจ ยุฮ อัปราฮัม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","เญือม เซ ลาบั่น ไม่ เบ่ทูเอน โลยฮ อื ตอก เฮี, “ไลลวง เฮี เกิต เบือ พะจาว. เอะ เกียฮ อัฮ โตว โอเอีฮ ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","เรเบ่คา เอีจ อาวต นา เฮี. โรวก ไม่ เปอะ เมิฮ. เกือฮ แปน ปรโปวน เญือะ กวน ปอเลียง เปอะ เซ ตอก เอีจ รโฮงะ พะจาว อื ละ เปอะ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","เญือม ฮมอง อื โอเอีฮ ตอก เซ กวนไจ อัปราฮัม เซ นุ่ม เอิน ปอ จิ ไกญ แตะ เตะ ไววอน ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ฟวยจ เซ ฮอย ป โรวก แตะ ละ อื. เกือฮ เครอึง เซอึก ไมจ ละ เรเบ่คา ไม่ ฮนัง เบล ไคร มาื ละ อื โฮวน. เกือฮ โรฮ คาวคอง ไมจ ละ มะ อื ไม่ เอียกระ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ฟวยจ เซ โซม ดิ ไม่ โม ป ฮอยจ ไม่ แตะ เซ. ไอจ เญือะ เซ ติ ซาวม. ปวยฮ พริ เซ โกฮ อัฮ เฮี, “เกือฮ อาึ เอีญ เคะ ปอเลียง แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","เอียกระ อื ไม่ มะ อื อัฮ เฮี, “ฆวต ปัว ลั่ง เกือฮ เรเบ่คา อาวต ไม่ เอะ ติ วัง ฮัม. ลวง รมัฮ อื เมาะ กาว ซาวม โฮ. ฟวยจ เซ ซ เกือฮ โฮว ไม่ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","ปุย เซ อัฮ เฮี, “ปัว เปอะ โอ คัต เอะ. พะจาว เอีจ เกือฮ กัน ยุฮ ฮุ ฟวยจ. ปัว เปอะ เกือฮ อาึ เอีญ เคะ ปอเลียง แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","โม เซ อัฮ เฮี, “กอก เรเบ่คา เซ ไฮมญ แลน โกะ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","กอก เนอึม อื ไฮมญ อื, “อัม ฆวต โฮว เปอะ ไม่ ปุย เฮี?” อัฮ เซ ละ อื. “ฆวต โฮว เยอะ,” อัฮ เซ เรเบ่คา. ");
INSERT INTO lcp_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","เญือม เซ เกือฮ เนอึม เรเบ่คา โฮว. เกือฮ กวนไจ รโปวน แตะ ป แลน เรเบ่คา เซ เน่อึม เญือม แตวะ อื โฮว ไม่ อื. เกือฮ อื โฮว ไม่ กวนไจ อัปราฮัม ไม่ โม ป ฮอยจ ไม่ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","โม เพร อื ปิฮ มุ่น ละ เรเบ่คา ตอก เฮี, “รนัน, เกือฮ จัตเจือ เปอะ พรุฮแพร แปน ฮมาึน แปน แซน อื. เกือฮ จัตเจือ เปอะ เป เมือง ป ตอซู ไม่ แตะ โครยญ เมือง,” อัฮ เซ ละ อื นึง รซอม ปิฮ แตะ มุ่น เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","เญือม เซ เรเบ่คา ไม่ โม กวนไจ รโปวน ยุฮ อื, ฮาวก บุก อุต เซ. โฮว ดิ ไม่ อื. กวนไจ อัปราฮัม เซ โฮลฮ เนอึม โรวก เรเบ่คา เอีญ ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","กา เซ ยิซฮัก เอีจ โอก ฮา “นัมโม่ ยุฮ พะจาว ป ไอม ลอป ป เกียฮ ยุ อาึ” เซ, โฮว ฮอยจ นึง ลาึน เนเกป ติ โดฮ. ลอต อาวต นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","เมือ กปู อื ยิซฮัก โอก โฮว เลีม โตะ รปึม, ง่อต โอเอีฮ โตะ รพาวม แตะ. ชวน ฮอยจ อุต โม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","เรเบ่คา เญือม ชวน อื ยิซฮัก เกอ, เลีฮ เอิน ฮา อุต บุก แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ไฮมญ กวนไจ อัปราฮัม เซ ตอก เฮี, “มัฮ ปุย ป โฮว โตะ รปึม เซิต เตอ? ตอก ป ซ โฮว รชึง เอะ โฮ,” อัฮ เซ. “มัฮ ปอเลียง อาึ,” อัฮ เซ ละ อื. เญือม เซ เรเบ่คา ตุย พา ยุฮ แตะ เลอึป นา แตะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","กวนไจ เซ รโฮงะ โอเอีฮ ป ยุฮ ป อัฮ แตะ ละ ยิซฮัก โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ฟวยจ เซ ยิซฮัก ตาว เรเบ่คา เลียก อาวต โตะ พากัง กอ อาวต มะ แตะ ไพรม อื. ยิซฮัก ฮรัก เนอึม เรเบ่คา. เรเบ่คา เซ แปน เนอึม ปรโปวน เญือะ อื, แปน โรฮ ป เกาะ โลม รพาวม อื ฟวยจ ยุม มะ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","โนก ฮา ซารา เยอ อัปราฮัม ไอฮ โรฮ ปรโปวน แตวะ เญือะ แตะ ติ แม. มอยฮ อื มัฮ เคทูรา. ");
INSERT INTO lcp_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","กวน อัปราฮัม ไม่ เคทูรา เซ มัฮ ซิมรัน, โยกชัน, เมดั่น, มีเดี่ยน, อิชบั่ก, ไม่ ชูอา. ");
INSERT INTO lcp_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","โยกชัน เซ มัฮ เปือะ เซบ่า ไม่ เด่ดั่น. โม อัตชู ไม่ โม เลทู ไม่ โม เลอุม มัฮ โรฮ จัตเจือ เด่ดั่น เซ. ");
INSERT INTO lcp_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","กวน มีเดี่ยน เซ มัฮ เอฟา, เอเฟอ, ฮาโนก, อาบิ่ด่า, ไม่ เอนด่าอา. ปุย โม เซ เตือง โอยจ อื มัฮ ตื จัตเจือ เคทูรา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","เมาะ ไก คาวคอง ยุฮ แตะ เตือง โอยจ อื อัปราฮัม เอีจ มอป อื ละ ยิซฮัก. ");
INSERT INTO lcp_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ละ กวน ไฮญ แตะ ป เกิต เน่อึม นึง ปรโปวน แตวะ เญือะ อื เซ อัปราฮัม เกือฮ โอเอีฮ ละ อื เญือม ไอม ลั่ง แตะ. เกือฮ โรฮ อื โอก โฮว ฮา ยิซฮัก, โฮว อาวต เมือง ลั่ก โอก ซเงะ ก ซไง อื. ");
INSERT INTO lcp_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","อัปราฮัม ไอม ฮอยจ ละ ไก อาญุ แตะ ติ รอย ไม่ อาลแฆลฮ โรฮ พอน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","มัฮ เนอึม ปุย ลั่ง ไอม. ยุม เญือม เอีจ กวต เนอึม แตะ. โฮลฮ เนอึม โฮว รโจะ ไม่ จัตเจือ ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","ยิซฮัก ไม่ อิชมาเอน ป มัฮ กวน อื เซ โฮว รมอยจ อื โตะ ทัม มักเปลา ป ไก นึง โตะ รปึม ซดิ ไม่ ย่วง มัมเร. ไพรม อื รปึม เซ มัฮ รปึม ยุฮ เอฟโรน กวน โซอัน. ");
INSERT INTO lcp_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","เอีจ มัฮ รปึม รวี อัปราฮัม เน่อึม นึง โม ฮิตไท. อัปราฮัม ไม่ ซารา ป มัฮ ปรโปวน เญือะ อื รมอยจ ดิ ปุย โบ ปุ แตะ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ฟวยจ ยุม อัปราฮัม เมอ พะจาว ปิฮ มุ่น ละ ยิซฮัก. เญือม เซ ยิซฮัก อาวต โบ นัมโม่ อัฮ ปุย “นัมโม่ ยุฮ พะจาว ป ไอม ลอป ป เกียฮ ยุ อาึ” ไม่ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","เคียง เฮี อื มัฮ มอยฮ จัตเจือ อิชมาเอน, ป มัฮ กวน อัปราฮัม ไม่ ฮากา. ฮากา เซ มัฮ กวนไจ ซารา. มัฮ ปุย อียิป. ");
INSERT INTO lcp_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","มอยฮ กวน อิชมาเอน เน่อึม นึง กวน โรง อื ฮอยจ ละ กวน รเคะ อื มัฮ ตอก เฮี, ป มัฮ เอียกระ ปุย นึง อื มัฮ เนบ่าโยต. ฟวยจ เซ มัฮ แม เคด่า, อัตบิ่เอน, มิปซัม, ");
INSERT INTO lcp_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","มิชมา, ดู่มา, มัตซา, ");
INSERT INTO lcp_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ฮาดั่ต, เทมา, เยทู, นาพิต, ไม่ เคเด่มา. ");
INSERT INTO lcp_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ปุย กาว ลอา เฮี มัฮ กวน อิชมาเอน. กังเคะ เอ โฮลฮ แปน ฮัวนา เจอ อาวต แตะ เตือง ไพ เตือง มัน. มอยฮ อื ลอต เอิน แปน มอยฮ ย่วง อาวต อื. ");
INSERT INTO lcp_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","อิชมาเอน ไอม ฮอยจ ละ ไก อาญุ แตะ 137 เนอึม. เญือม เซ ยุม. โฮลฮ เนอึม โฮว รโจะ ไม่ โม จัตเจือ ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","โม กวน เฌือต อื ลอต อาวต ซน่ะ เมือง ฮาวิลา ไม่ เมือง ชู. ปุก คระ โฮว ปุย เน่อึม นึง เมือง อัตซีเรีย เซ ฮอยจ เมือง อียิป. โม เซ อาวต โบ เคต อียิป นึง อื. ไก แนฮ รพาวม เกละยุ โม เอียกปุ แตะ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","เคียง เฮี อื มัฮ ไลลวง ยิซฮัก ป มัฮ กวน อัปราฮัม. ");
INSERT INTO lcp_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","เญือม ไก อาญุ ยิซฮัก รปาวน เนอึม เมอ, ไอฮ เรเบ่คา กวน เบ่ทูเอน แปน ปุย เญือะ แตะ. เรเบ่คา เซ มัฮ รนัน ลาบั่น. มัฮ ปุย เมือง ปัตดั่น อารัม นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ยิซฮัก ไววอน เพือ ปรโปวน เญือะ แตะ นึง มัฮ อื ปุย ซแกต. พะจาว เกือฮ อื ตัม ป ปัว ยิซฮัก เซ. เรเบ่คา โรวก เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","กวน อาวต โตะ เวียก อื เซ ซแน่ต ปุ แตะ. มะ อื อาวม อื. อัฮ เฮี ฆาื อื, “มัฮ โอเอีฮ ตอก เมอ ป เกิต กไน อาึ เฮี?” อัฮ เซ. โฮว ไฮมญ พะจาว ฆาื อื นึง รซอม ไววอน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","พะจาว โลยฮ อื ละ อื, “ปุย ลอา เมือง อาวต โตะ เวียก ปะ. ปุย ลอา ปะเทต ซ โอก เน่อึม นึง ปะ. ซ โฮว โน่งๆ ฮา ปุ แตะ. ซ ปูไป อัมนัต ฮา ปุ แตะ. ป มัฮ เอียกระ อื ซ โฮลฮ แปน กวนไจ ปุ แตะ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","เญือม เอีจ เติง เคิ รอาวม อื กวน อื เซ พรอม. รเมะ เตือง ลอา แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ป เกิต รกา นึง อื เซ ซครัก เนือะนัง. ฮาึก ไม่ อื เตือง โกะ เตือง ตัว แตะ ตอก เอิน ลปิ ฮาึก โฮ. ปุย อัฮ เอซาว ละ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ป เกิต รเคะ นึง อื เซ, เตะ อื โฮมวต ปุ โอก ล่อยจ เอซาว เซ นึง อื. ปุย อัฮ ยาโคป ละ อื ฆาื อื. เญือม เกิต กวน ลอา อื เซ ยิซฮัก ไก อาญุ ลแฆลฮ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","กวนดุ ลอา เซ ระ ฮอน ปุ ปุ. เอซาว มัฮ ปุย กอ โฮว เอีย โตะ เพระด่าวก. มัฮ ปุย กอ ปุน โกะพริ. ยาโคป มัฮ ปุย โบลวน. กอ อาวต ไม่ กัน นึง เญือะ นึง ม่า แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ยิซฮัก ฮรัก เอซาว นึง กอ โฮลฮ แตะ ปอน โตะ ปุน อื, เรเบ่คา ปังเมอ ฮรัก ยาโคป. ");
INSERT INTO lcp_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ติ ซเงะ อื เอซาว เอีญ เน่อึม โฮว เอีย แตะ โตะ เพระด่าวก. ฆวต โซม ลัมเลือ. ปุก เญือม โกยฮ ยาโคป โตะฮงา. ");
INSERT INTO lcp_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","เอซาว อัฮ เฮี ละ ยาโคป, “ซไจ เกือฮ ละ อาึ โตะฮงา ซครัก เซ. เอีจ ซ ยุม เนอึม นึง ฆวต โซม แตะ,” อัฮ เซ. (มัฮ ฆาื เซ ป ลอต ปุย อัฮ เอโด่ม ละ อื ฆาื อื.) ");
INSERT INTO lcp_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ยาโคป อัฮ เฮี ละ อื, “ดัฮ เปอะ เกือฮ ไล แปน แตะ เอียกระ เซ ละ อาึ โฮ, อาึ ซ เกือฮ โรฮ โตะฮงา เฮี ละ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","เอซาว อัฮ เฮี, “อาึ ซ ยุม ลอป เนอึม นึง ฆวต โซม แตะ. ไลลวง เมีญ ปุย อาึ มัฮ เอียกระ เซ เมอ ซ แปน อื เนิ อี? ไอฮ เมิฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ยาโคป อัฮ แม เฮี, “ซม่อต อาึง ติ เปอะ นึง ซ เกือฮ เนอึม เปอะ อาึ โฮลฮ แปน เอียกระ เซ,” อัฮ เซ. เญือม เซ เอซาว ซม่อต เนอึม ติ แตะ. โปง อื ละ ยาโคป โครยญ เจือ ป ลัง โฮลฮ โกะ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ยาโคป เกือฮ เนอึม โตะฮงา ทัวแด่ง เซ ละ อื ไม่ คโนมปัง. เญือม เอีจ ฟวยจ โซม อื เอซาว ลอต โกฮ เอีญ. มัฮ ตอก เซ ตอก พามัต เอซาว ไลลวง แปน แตะ เอียกระ ปุย ไม่ ป ลัง โฮลฮ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ฟวยจ เซ เกิต ไปลญ อาวป เออึป กิฮ นึง ติ โฮน แม, ตอก เกิต อื โฮน รกา เญือม ไอม ลั่ง อัปราฮัม โฮ. ยิซฮัก โฮว ฆาื อื ฮอยจ เคะ อาบี่เมเลก ป มัฮ กซัต ยุฮ โม ฟีลิซเตีย ป อาวต ย่วง เก-รา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","เญือม เซ พะจาว เปลีฮ ติ แตะ ละ ยิซฮัก, อัฮ เฮี ละ อื, “ปุ โฮว ฮอยจ เมือง อียิป เปอ. อาวต เมือง เฮี ตอก ดวน อาึ เปอะ อาวต. ");
INSERT INTO lcp_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","อาวต แนฮ นา เฮี. อาึ ซ อาวต ไม่ เปอะ. ซ ปิฮ มุ่น ละ เปอะ. เมือง โม เฮี เตือง โอยจ อื อาึ ซ เกือฮ ละ ปะ ไม่ จัตเจือ เปอะ เฆียง เฮี ตอก เอีจ ซันญา แตะ อาึง ละ อัปราฮัม เปือะ เปอะ โฆะ. ");
INSERT INTO lcp_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","อาึ ซ เกือฮ จัตเจือ เปอะ โฮวน ตอก ซโมยญ นึง มะลอง. ซ เกือฮ โฮลฮ กุม ปลัฮเตะ นา เฮี เตือง โอยจ อื. อาึ ซ เกือฮ ปุย ปลัฮเตะ โฮลฮ รัป ป ไมจ เบือ จัตเจือ ปะ โครยญ เมือง ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","อัปราฮัม เอีจ เนอึง ป อัฮ อาึ. ยุฮ เนอึม อื ตัม ลปุง ซตอก อาึ แตะ ยุฮ ไม่ โกตไม ยุฮ ฮุ โครยญ เจือ. มัฮ เซ ป ซ ปิฮ อาึ มุ่น ละ ปะ ฆาื อื,” อัฮ เซ ละ ยิซฮัก พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ฟวยจ เซ ยิซฮัก อาวต ลั่ง นึง ย่วง เก-รา. ");
INSERT INTO lcp_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","เญือม ไฮมญ โม ปรเมะ ย่วง เซ ไลลวง ปรโปวน เญือะ อื เคียต อัฮ อื มัฮ รนัน แตะ. โรวต โตว อัฮ อื มัฮ ปรโปวน เญือะ แตะ นึง ฮลัต แตะ นึง ปรเมะ โม เซ. ฮลัต โม เซ ซ ยุฮ ยุม ไม่ โกะ แตะ ฆาื ฆวต ไอฮ อื ปรโปวน เญือะ อื เซ, นึง มัฮ เรเบ่คา เซ ปุย ไมจ เนอึม ฮุนฮัง. ");
INSERT INTO lcp_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","เญือม เอีจ เลี่ญ อาวต ยิซฮัก ย่วง เซ, ไก ติ ซเงะ เญือม แก กซัต อาบี่เมเลก โอเอีฮ เน่อึม นึง โตะ นาตัง เญือะ แตะ คัก ฮลาวง อื. ซวน รง่ะ ดิ ยิซฮัก เซ ไม่ ปุย เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","กซัต เซ กอก ยิซฮัก ฮอยจ เคะ แตะ. บวยจ ละ อื ตอก เฮี. “ปะ เมอยุ จุ เปอะ เอะ เอ? แจง มัฮ อื ปุย เญือะ เปอะ. เกียฮ อัฮ โน่ง เปอะ มัฮ รนัน แตะ เมอ?” อัฮ เซ ละ อื. ยิซฮัก โลยฮ อื ละ อื, “อาึ เตอ ฮลัต ปุย ยุฮ ยุม ไม่ โกะ แตะ ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","อาบี่เมเลก อัฮ เฮี ละ อื, “เกียฮ ยุฮ โน่ง เปอะ ป ตัง เจือ ตอก เซ ละ เอะ เมอ? มัฮ ไก ปุย ไน โม เอะ ติ ปุย ป โคะ ไอฮ ปุ แตะ ไม่ อื ซ แปน เคาะ นัม ละ เอะ ฆาื อื. ซเปี เนอึม ลอก เอะ ป โอ ไมจ ฆาื ปะ เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","เญือม เซ อาบี่เมเลก ซตอก อาึง ปุย ไน แตะ ตอก เฮี, “ดัฮ ไก ป ลอก ป คุย ปุย เฮี ไม่ ปุย เญือะ อื ซ เกือฮ ไก ตุต ฮอยจ ละ ยุม แตะ,” อัฮ เซ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","เนอึม เซ ยิซฮัก ซมา เฮงาะ ไม่ ปุย ย่วง เซ. เฮงาะ โฮลฮ อื ไก ติ รอย เตะ ซมา อื. มัฮ เบือ ปิฮ พะจาว มุ่น ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ฟวยจ เซ ยิซฮัก กอย แนฮ ปุ ปุ. คาวคอง อื โฮวน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","เญือม เอีจ โฮวน คอง เลียง คอง ดู่ อื, ไม่ โฮวน โรฮ กวนไจ อื, แปน ป วัว ละ โม ฟีลิซเตีย ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","เญือม เซ โม ฟีลิซเตีย ซาวป เทอึม นัมโม่ กาวง โม กวนไจ ยุฮ อัปราฮัม ไพรม อื โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","อาบี่เมเลก อัฮ เฮี ละ ยิซฮัก, “ไมจ เปอะ โฮว แปฮ ฮา เอะ. ปะ เอีจ ระ ลอน เปอะ ยุฮ แตะ ฮา เอะ. เอะ ไป ลอน นึง เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ยิซฮัก เฌาะ เนอึม ติ แตะ ฆาื อื, โฮว อาวต นึง เตะ ลโลวง ฆรึม ย่วง เก-รา. ");
INSERT INTO lcp_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","เฌาะ กาวง โคระ แม นัมโม่ ป กาวง อัปราฮัม ไพรม อื, นึง เอีจ เทอึม โม ฟีลิซเตีย อื ฟวยจ ยุม อัปราฮัม เซ. ปุก มอยฮ นัมโม่ โม เซ ตัม ป อัฮ เปือะ แตะ ไพรม อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","กวนไจ ยุฮ ยิซฮัก กาวง แม นัมโม่ นึง เตะ ลโลวง เซ. โฮลฮ รอาวม ไมจ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","โม ป เลียง แกะ ป อาวต ย่วง เก-รา เซ รเจ ไม่ โม ป เลียง แกะ ยุฮ ยิซฮัก. อัฮ อื มัฮ รอาวม ยุฮ โกะ แตะ ไอฮ. ยิซฮัก ปุก มอยฮ นัมโม่ เซ. อัฮ “นัมโม่ รเจ” ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ฟวยจ เซ กวนไจ ยุฮ ยิซฮัก กาวง แม อื ติ โดฮ. โม ฟีลิซเตีย รเจ แม ไม่ อื. ยิซฮัก อัฮ “นัมโม่ ป ตอซู ปุ แตะ” ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ฟวยจ เซ เฌาะ แม ติ แตะ. กาวง แม อื ติ โดฮ. โฮน เซ เญือะ ไก โตว ป รเจ ไม่ อื. ปุก โรฮ มอยฮ นัมโม่ เซ, อัฮ “นาตี เวือฮ” ไม่ อื. “ปเลี่ย เฮี พะจาว เอีจ เกือฮ นาตี เวือฮ ละ เอะ. เอะ ซ อาวต ซนุก ซุกบั่น นา เฮี,” อัฮ เซ ยิซฮัก เกอ. ");
INSERT INTO lcp_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","กัง เคะ เอ โอก แม ฮา นา เซ, ฮาวก อาวต ย่วง เบ่เออเชบ่า. ");
INSERT INTO lcp_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ซาวม เซ พะจาว เปลีฮ ติ แตะ ละ อื. อัฮ เฮี ละ อื, “อาึ มัฮ พะจาว ทื อัปราฮัม ป มัฮ เปือะ เปอะ. ปุ ฮลัต นึง โอเอีฮ ฮี. อาึ ซ อาวต ไม่ เปอะ. ซ ปิฮ มุ่น ละ เปอะ. ซ เกือฮ จัตเจือ เปอะ พรุฮแพร โฮวน เบือ อัปราฮัม กวนไจ ยุฮ ฮุ เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ยิซฮัก ยุฮ คัน ทไว นา เซ. ไววอน ละ พะจาว. กัง พากัง ยุฮ แตะ นา เซ. กวนไจ อื กาวง โรฮ นัมโม่ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","กัง เคะ เอ อาบี่เมเลก ฮอยจ เคะ ยิซฮัก. โอก ดิ ฮา ย่วง เก-รา ไม่ อาฮุซัต ปุ โฮมว แตะ ไม่ ฟีโค ฮัวนา ตฮัน ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ยิซฮัก ไฮมญ อื ตอก เฮี, “เมอยุ ฮอยจ เปอะ เคะ อาึ อื? เมือต แลน เกละ เปอะ ยุ อาึ. เอีจ โครฮ เปอะ อาึ โอก ฮา แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","โม เซ โลยฮ อื, “เอีจ ที เนิ อาวต พะจาว ไม่ เปอะ. มัฮ เซ ป ฆวต ซันญา อาึง โอเอีฮ ไม่ ปุ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ไมจ เอะ ซันญา ซโตฮ อาึง ไม่ ปุ แตะ นึง โอ โม เปะ ซ ยุฮ ป โซะ ละ เอะ ตอก โรฮ โอ เอะ ยุฮ ป โซะ ละ โม เปะ ไพรม อื. เอะ เอีจ เกือฮ โม เปะ โอก ฮา แตะ ไม่ เฮน ฮลอง รพาวม เปอะ. ปเลี่ย เฮี เอะ ยุ ที เยอะ ปิฮ พะจาว มุ่น ละ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","เญือม เซ ยิซฮัก จัต กัน กิน เลียง ละ โม ป ฮอยจ เคะ แตะ เซ. โม เซ โซม เนอึม ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ปวยฮ พริ เซ เมือ กซะ งาวป อื โม เซ ซันญา ซโตฮ อาึง โอเอีฮ ไม่ ปุ แตะ. ฟวยจ เซ ยิซฮัก ตาว อื เอีญ ไมจ เอีญ มวน. ลอต โรฮ ปุก ปุ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ซเงะ เซ กวนไจ ยุฮ ยิซฮัก เอีญ อู ไลลวง นัมโม่ กาวง แตะ ละ ปอเลียง แตะ. อัฮ ติ แตะ ยุ รอาวม ไมจ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","ยิซฮัก ลอต อัฮ นัมโม่ เชบ่า ไม่ อื. เคียง เซ ฮอยจ ปเลี่ย ย่วง เซ อัฮ ปุย เบ่เออเชบ่า ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","เญือม เอีจ ไก อาญุ อื รปาวน เนอึม เมอ เอซาว ไอฮ ปรโปวน เญือะ แตะ. มัฮ ยูดิ่ต กวน เบ่เออรี ป มัฮ โม ฮิตไท. ไอฮ โรฮ ปรโปวน แตวะ เญือะ แตะ ติ. มัฮ บ่าเซมัต กวน เอโลน. มัฮ โรฮ โม ฮิตไท. ");
INSERT INTO lcp_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ยิซฮัก ไม่ เรเบ่คา อาวต ลอป ไม่ รพาวม ตุก แตะ ฆาื ปุย ลอา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ยิซฮัก เญือม เอีจ กวต อื จัก ไง่. ติ ซเงะ อื กอก เอซาว ป มัฮ กวน โรง แตะ เซ เอีญ เคะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","เญือม เอีจ ฮอยจ เอซาว เคะ อื, ยิซฮัก อัฮ เฮี ละ อื, “กวน, อาึ เอีจ กวต เตอะ. ยุง โตว ซเงะ ซ ยุม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ตุย โรวก อัก ยุฮ เปอะ. โฮว ซาวป จัก ปอยฮ แฮ ละ อาึ นึง เพระด่าวก. ");
INSERT INTO lcp_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","โกยฮ โตะฮงา ญึม นึง เนิ ตอก ปุก อื รพาวม เมอะ. ตาว เนิ เกือฮ อาึ โซม เดอึม อาึ ซ โฮลฮ ปิฮ มุ่น ละ เปอะ กา ซ ยุม แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ลไล อู อื เซ เรเบ่คา บระ ง่อต ป อัฮ อื ละ กวน โรง แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","เญือม เอีจ โฮว เอซาว เซ อัฮ เฮี ละ ยาโคป, “อาึ เอีจ ฮมอง ซตอก เปือะ เปอะ เอียกระ เปอะ เนาะ ออ. ");
INSERT INTO lcp_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","ฮมอง ดวน อื โฮว ซาวป จัก ปอยฮ ละ แตะ. ฮมอง โรฮ ดวน อื พรี โตะฮงา ญึม ละ แตะ ละ ซ โฮลฮ อื โซม ไม่ ซ ปิฮ อื มุ่น ละ เอียกระ เปอะ เบือ มอยฮ พะจาว เญือม ไอม ลั่ง แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","มะ อื อัฮ แม เฮี ละ กวน แตะ, “กวน, ไมจ เปอะ ง่อต ป อัฮ อาึ ละ เปอะ. ยุฮ ตัม ดวน อาึ เปอะ ยุฮ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","โฮว มอก กวน ปิ โกลยญ เนิ ลอา ตัว เดอึม อาึ ซ เกียฮ พรี โตะฮงา ญึม ละ เปือะ เปอะ. ซ พรี ละ อื ตอก ปุก อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","ฟวยจ เซ ไมจ ปะ โฮว ตาว ละ อื, ซ ปิฮ มุ่น ละ เปอะ ฆาื อื กา ยุม แตะ,” อัฮ เซ ละ อื เรเบ่คา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ยาโคป โลยฮ อื ละ มะ แตะ ตอก เฮี, “แปน โตว ยุ่ง. เอียกระ เกอะ มัฮ ปุย ฮาึก เตือง โม่ว แตะ. อาึ ปังเมอ มัฮ ปุย รมัฮ ฮาึก. ");
INSERT INTO lcp_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","เมอ เตือง อื เปือะ เกอะ ซ เบื่อ แลน อาึ ยุ่ง. ซ ที ละ อื ฆาื อื. เญือม เซ ซ โปง มั่ป ละ อาึ ฮา ซ ปิฮ อื มุ่น เนิ ยุ่ง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","มะ อื อัฮ เฮี, “กวน, ยุฮ ตัม ป ดวน อาึ เปอะ เซ เมิฮ. ดัฮ เปือะ เปอะ โปง มั่ป ละ เปอะ โฮ, เกือฮ มั่ป เซ ฮอยจ ละ อาึ เฮี. โฮว มอก เนิ เมิฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","เญือม เซ ยาโคป โฮว มอก เนอึม อื. มะ อื พรี เนอึม โตะฮงา ละ เปือะ อื เซ ตอก ปุก อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ฟวยจ เซ ตุย เครอึง เซอึก เอซาว ป มัฮ กวน โรง แตะ เซ ป ตึก อื นึง ไมจ แตะ เกือฮ ยาโคป จาวป อื. ");
INSERT INTO lcp_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","เกือฮ โรฮ อื จาวป ฮัก ปิ นึง เตะ แตะ ไม่ นึง เน่อึม โงก แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","เกือฮ โตะฮงา เซ ละ ยาโคป ไม่ คโนมปัง ยุฮ โคระ แตะ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","ยาโคป เลียก ไม่ อื ฮอยจ เคะ เปือะ แตะ. อัฮ เฮี ละ อื, “เปือะ,” อัฮ เซ. เปือะ อื โลยฮ อื, “เอิฮ, กวน, ปะ มัฮ เปอะ ปุย นึง อื?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ยาโคป โลยฮ อื ละ อื, “อาึ มัฮ เอซาว กวน โรง เปอะ. อาึ เอีจ ยุฮ ฮุ ตัม ดวน เปอะ อาึ ยุฮ. โกฮ งาวม โซม ไม่ โตะฮงา โรวก อาึ ละ เปอะ เฮี เมอะ, เดอึม เปอะ ซ เกียฮ ปิฮ มุ่น ละ อาึ,” อัฮ เซ ละ เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ยิซฮัก เซ อัฮ แม เฮี, “กวน, เกียฮ ไกลจ ลัมเลือ โน่ง ปุน เปอะ จัก เมอ?” อัฮ เซ. ยาโคป โลยฮ อื, “มัฮ พะเยโฮวา ป มัฮ พะจาว ทื เปือะ เกอะ ป เกือฮ เนิ อี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","เญือม เซ ยิซฮัก อัฮ เฮี ละ ยาโคป, “เลียก ซดิ ไม่ อาึ เฮี เมอะ, เดอึม อาึ ซ เกียฮ เบื่อ แลน เปอะ, เดอึม ซ เกียฮ แจง นึง มัฮ เปอะ เอซาว กวน โรง เงอะ ไม่ โอ เปอะ มัฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ยาโคป เลียก เนอึม ฆาื อื ซดิ. ยิซฮัก เบื่อ เนอึม แลน อื. อัฮ เฮี ฆาื อื, “เซียง อื ตอก เซียง ยาโคป, เตะ อื ปังเมอ มัฮ เนอึม เตะ เอซาว,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ยุง โตว มัฮ อื ยาโคป นึง ฮาึก เตะ อื ตอก เตะ เอซาว เซ. มัฮ เซ ป ปิฮ อื มุ่น ละ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ไฮมญ แม อื ติ โฮน, “อัม มัฮ เนอึม เปอะ เอซาว กวน เนอะ?” อัฮ เซ ละ อื. “มัฮ ฮะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","“ตาว เนิ เมอะ โตะฮงา โรวก เปอะ เซ. อาึ ซ โซม ไม่. ฟวยจ เซ ซ ปิฮ มุ่น ละ เปอะ,” อัฮ เซ ยิซฮัก เกอ. ยาโคป เกือฮ เนอึม อื ละ อื. โซม ปอน เนอึม อื. เกือฮ โรฮ รอาวม อะงุน ละ อื ไม่ อื ง่อน. ญุ โรฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","เญือม เซ ยิซฮัก กอก กวน แตะ, “กวน, เอีญ นา เฮี, ฮงาึต เปือะ เปอะ เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","เญือม เซ ยาโคป เลียก ฮงาึต เนอึม อื. ยิซฮัก เญือม อาวม อื ซออย ฮงาื เครอึง เซอึก อื ปิฮ เนอึม มุ่น ละ อื. อัฮ เฮี, “กวน, ซออย ฮงาื เปอะ ตอก ซออย ฮงาื รปึม ซแก ป โฮลฮ พะจาว ปิฮ มุ่น ละ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ปัว พะจาว เกือฮ ปะ โฮลฮ รอาวม รน่ะ เน่อึม นึง มะลอง, ไม่ เกือฮ เปอะ โฮลฮ ป ไมจ ป ญุ่ก เน่อึม นึง ปลัฮเตะ. ปัว พะจาว เกือฮ เฮงาะ รโกะ ละ เปอะ โฮวน, ไม่ เกือฮ อื รอาวม อะงุน ละ เปอะ กุมปอ. ");
INSERT INTO lcp_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","เกือฮ ปุย ตังเมือง รซอฮ ละ เปอะ, เกือฮ ปุย ตัง ปะเทต นุ่ม ไว เปอะ. ปัว พะจาว เกือฮ ปะ โฮลฮ แปน จาว แปน ไน ระ ฮา กวน เปือะ เปอะ, ไม่ เกือฮ กวน มะ เปอะ นุ่ม ไว เปอะ. เมาะ ป ฆวต เกือฮ ปะ โฮลฮ ป โซะ เกือฮ ปุย เซ ลอก ป โอยจ นึง โซะ แตะ. เมาะ ป ปิฮ มุ่น ละ ปะ เกือฮ โฮลฮ มุ่น เตือง โอยจ อื,” อัฮ เซ ยิซฮัก เกอ. ");
INSERT INTO lcp_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","ฟวยจ ปิฮ เปือะ อื มุ่น ละ อื ยาโคป โอก ฮา นา เซ. เมาะ ฟวยจ โอก อื เซ, เอซาว เซ เอีญ เอิน โรฮ เน่อึม โฮว ซาวป แตะ โกะ พริ. ");
INSERT INTO lcp_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","พรี โรฮ โตะฮงา ญึม, ตาว โรฮ อื ละ เปือะ แตะ. อัฮ เฮี, “เปือะ, โกฮ งาวม โซม ไม่ โตะ โรวก อาึ ละ เปอะ เฮี, เดอึม เปอะ ซ เกียฮ ปิฮ มุ่น ละ อาึ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","ยิซฮัก ป มัฮ เปือะ อื เซ ไฮมญ อื ตอก เฮี, “ปะ มัฮ เปอะ ปุย?” อัฮ เซ. “อาึ มัฮ เอซาว กวน โรง เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","เญือม เซ ยิซฮัก รกุฮ เอิน เตือง โม่ว แตะ. อัฮ เฮี, “ดัฮ มัฮ ตอก เซ มัฮ ปุย ป ปุน โกะพริ ป โกยฮ ตาว อื ละ อาึ เนาะ ออ? อาึ เอีจ ฟวยจ โซม ปอน เนอะ กา ฮอยจ ปะ. เอีจ ฟวยจ โรฮ ปิฮ มุ่น ละ ปุย เซ. มุ่น ปิฮ อาึ เซ เญือะ เกียฮ เปียน โตว. ซ ฮอยจ เนอึม ละ อื ตอก เซ,” อัฮ เซ ยิซฮัก เกอ. ");
INSERT INTO lcp_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","เญือม ฮมอง เอซาว ป อัฮ เปือะ แตะ ตอก เซ, ครวก เอิน เรียง นึง โซะ ลอน รพาวม แตะ. อัฮ เฮี ละ เปือะ แตะ, “เปือะ อาึ, ปิฮ โรฮ มุ่น ละ อาึ โรฮ โอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ยิซฮัก อัฮ เฮี ละ อื, “แปน โตว ตอก เซ. ปุ ปะ เซ เอีจ ฮอยจ จุ อาึ. ลู ตุย มุ่น ป ลัง ฮอยจ ละ ปะ เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","เอซาว อัฮ แม เฮี, “เอีจ มัฮ ลอา โฮน เตือง เฮี บ่วก อื ละ อาึ อื. ลู ไล แปน กวน โรง ปุย ฮา เยอะ ติ เจือ. โฮน เฮี ลู แม มุ่น ยุฮ ฮุ ฮา เยอะ. โปง ลัมเลือ มอยฮ แตะ ยาโคป เซ. อัม มัฮ โอ อื เญือะ ไก เฟือฮ มุ่น ซ ปิฮ เปอะ ละ อาึ อื?” อัฮ เซ ละ เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ยิซฮัก โลยฮ อื, “อาึ เอีจ ปัว พะจาว เกือฮ แปน จาวไน ระ ฮา ปะ. เอีจ ปัว โรฮ เกือฮ คระ เฌือต อื แปน กวนไจ อื เตือง โอยจ อื. อาึ เอีจ ปัว เฮงาะ รโกะ ละ, ไม่ รอาวม อะงุน โคระ. มัฮ เมอ ป ไก ลั่ง ละ ซ โฮลฮ โฮะ เกือฮ ละ ปะ อา?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","เอซาว ไฮมญ อื, “เปือะ, อัม มัฮ ไก อื ติ เจือ โน่ง มุ่น เกียฮ ปิฮ เปอะ? เปือะ, ปัว เนอึม ปะ ปิฮ โรฮ มุ่น ละ อาึ ติ โรฮ,” อัฮ อื ตอก เซ ไม่ เยือม เรียง แตะ เอซาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","เญือม เซ ยิซฮัก อัฮ เฮี, “เญือะ อาวต คราว โซม เปอะ ซ ซไง ฮา รอาวม รน่ะ เน่อึม มะลอง. ซ โฮลฮ เปอะ โตว ป ไมจ ป ญุ่ก เน่อึม นึง ปลัฮเตะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","ปะ ปังเมอ ซ ไอม เปอะ เบือ วิจ เบือ เพลียฮ. ซ โฮลฮ เปอะ แปน กวนไจ ปุ แตะ. กังเคะ เอ ซ ไก ติ ซเงะ เญือม เลฮ เปอะ เตียง อื. เญือม เซ ปะ ซ ปุน เกือฮ เปอะ ติ แตะ โปน ฮา อัมนัต ยุฮ อื เซ,” อัฮ เซ ยิซฮัก เกอ. ");
INSERT INTO lcp_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","เคียง เซ เยอ เอซาว เกละยุ ยาโคป ฆาื ปิฮ เปือะ แตะ มุ่น ละ ยาโคป ตอก เซ. อัฮ เฮี โตะ รพาวม แตะ, “ปเลี่ย เฮี เอีจ ซดิ ซ ยุม เปือะ เกอะ ไม่ ซ เยือม ปุย ยุม อื เซ. มัฮ เญือม เซ ซ เคริ อื ละ ยุฮ อาึ ยุม ไม่ ยาโคป ป มัฮ ปุ อุ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ฟวยจ เซ ไก ป อู ไลลวง ป คิต ป ง่อต เอซาว เซ ละ มะ อื. เรเบ่คา เซ กอก ยาโคป ป มัฮ กวน รเคะ แตะ เซ เอีญ เคะ แตะ ฆาื อื. อัฮ เฮี ละ อื, “เอียกระ เปอะ เอีจ เพรียง ติ แตะ ละ ซ โรก แตะ เวน ละ ปะ. ตะ ยุฮ ยุม ไม่ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ไมจ เปอะ เนอึง ป อัฮ อาึ ละ เปอะ ฆาื อื. ไมจ เปอะ ซไจ โฮว ฮอยจ เคะ เนอึม ระ ลาบั่น เปอะ นึง ย่วง เอะ ย่วง ฮารัน. ");
INSERT INTO lcp_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ไมจ เปอะ อาวต ไม่ เนอึม ระ เปอะ เซ ติ เจน กา เฆียง ไฆร รพาวม ฮาวก ยุฮ เอียกระ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ดัฮ เอีจ เบีย ป ยุฮ ปะ ละ แตะ อาึ ซ ตอม มวยญ แตะ ละ เปอะ เกือฮ เปอะ เอีญ. ดัฮ ปะ ไม่ เอียกระ เปอะ ยุม ติ ซเงะ โน่ง โม่ ซ โซะ ลอน ละ อาึ?” อัฮ เซ เรเบ่คา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","เญือม เซ เรเบ่คา อัฮ อื ละ ยิซฮัก ตอก เฮี, “อาึ เอีจ เตือ เอีจ ออป นึง ปรโปวน เญือะ เอซาว เฮี. โม เฮี เตอ มัฮ ปุย ตัง เมือง. ดัฮ ยาโคป ซ โคะ ไอฮ โรฮ โม ฮิตไท ตอก เซ โฮ อาึ แกต โกะ ลั่ก ยุม แตะ ฮา,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ยิซฮัก กอก ยาโคป เอีญ เคะ แตะ ฆาื อื. ปิฮ มุ่น ละ อื. ซตอก อื ตอก เฮี, “ปุ ไอฮ ปรโปวน เมือง คะนาอัน เฮี แปน ปุย เญือะ เปอะ เฟือฮ เอิน. ");
INSERT INTO lcp_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ไมจ เปอะ โกฮ โฮว ฮอยจ นึง เมือง ปัตดั่น อารัม ปเลี่ย เฮี เอิน. โฮว ฮาวก เญือะ ตะ เนอึม เบ่ทูเอน เปอะ เซ. ไมจ เปอะ ไอฮ ปรโปวน เญือะ เปอะ นา เซ. ไอฮ เอิน กวน เนอึม ระ เปอะ เซ ติ ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ปัว พะจาว ป อาวต ไม่ อัมนัต ตึก นึง ระ แตะ ปิฮ มุ่น ละ เปอะ, ละ ซ เกือฮ อื ปะ โฮลฮ กวน รเมะ โฮวน กวน รโปวน บื แตะ, ไม่ เกือฮ อื ปะ พรุฮแพร ฮอยจ ละ แปน เปอะ ปุย โฮวน เมือง. ");
INSERT INTO lcp_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","ปัว เกือฮ กุนมุ่น ป เกือฮ พะจาว ละ อัปราฮัม เซ อาวต ไม่ ปะ ฮอยจ ละ จัตเจือ เปอะ, เดอึม เปอะ ซ โฮลฮ กุม ปลัฮเตะ อาวต เปอะ เฮี, นึง มัฮ อื เมือง ป ซันญา พะจาว อาึง ละ อัปราฮัม,” อัฮ เซ ละ ยาโคป. ");
INSERT INTO lcp_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","เญือม เซ ยิซฮัก โปง ยาโคป โฮว คระ โฮว แตะ ละ ซ ฮอยจ อื นึง เมือง ปัตดั่น อารัม ละ ซ ฮอยจ อื เคะ ลาบั่น กวน เบ่ทูเอน. ลาบั่น เซ มัฮ เอียกระ เรเบ่คา ป มัฮ มะ เอซาว ไม่ ยาโคป เซ. ");
INSERT INTO lcp_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","เอซาว ฮมอง ปิฮ เปือะ แตะ มุ่น ละ ยาโคป ไม่ ดวน อื โฮว ซาวป ปุย เญือะ แตะ นึง เมือง ปัตดั่น อารัม. ฮมอง โรฮ ซตอก อื โอ ไอฮ ปุย เญือะ แตะ ไน โม คะนาอัน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","เอซาว ฮมอง โรฮ ไลลวง เนอึง ยาโคป ป อัฮ เปือะ แตะ ไม่ โฮว เนอึม อื เมือง ปัตดั่น อารัม. ");
INSERT INTO lcp_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","เญือม เซ เอซาว ยุง อื โอ ปรโปวน เมือง คะนาอัน ปุก รพาวม เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","โฮว ฆาื อื เคะ อิชมาเอน กวน อัปราฮัม. ไอฮ มาฮะลัต กวน อิชมาเอน เซ แปน ปรโปวน โคระ เญือะ แตะ. ไอฮ ดิ อื ไม่ ปรโปวน ไพรม เญือะ แตะ เตือง ลอา อื. มาฮะลัต เซ มัฮ รนัน เนบ่าโยต. ");
INSERT INTO lcp_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ยาโคป โอก โฮว ฮา ย่วง เบ่เออเชบ่า ละ ซ โฮว แตะ ฮอยจ เมือง ฮารัน. ");
INSERT INTO lcp_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","เญือม เอีจ ซ เลียก ซเงะ เอ ฮอยจ นึง เพระด่าวก ติ โดฮ. ลโล่ะ นา เซ, ตุย ซโมะ ติ. รฆวง อื. ลอต ปุน ไอจ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","เคะ ไอจ อื เซ รโมะ ยุ โบง ติ. ชวง โบง เซ อาวต ลังเตะ. ไกญ อื ฮอยจ นึง มะลอง. โม เตปด่า พะจาว ฮาวกๆ เลีฮๆ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ยุ โรฮ อาวต พะจาว โบ แตะ. ฮมอง อัฮ อื เฮี ละ แตะ, “อาึ มัฮ เยโฮวา พะจาว ทื อัปราฮัม ไม่ ยิซฮัก. อาึ ซ เกือฮ ปลัฮเตะ นา ก ไอจ เปอะ นึง เฮี ละ เปอะ ฮอยจ ละ จัตเจือ เปอะ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","จัตเจือ เปอะ ซ ตอก เอิน เตะ รกาื ป โอ ปุย ปุน เมีญ เมาะ โฮวน อื โฮ. ซ พรุฮแพร ฮอยจ ลั่กล่าวง ไม่ ลั่กเซฮ, ฮอยจ ลั่ก โอก ซเงะ ไม่ ลั่ก เลียก ซเงะ. ปุย โครยญ เจือ ปุย ซ โฮลฮ รัป ป ไมจ เบือ ปะ ไม่ เบือ จัตเจือ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","อาึ ซ อาวต ดิ ไม่ เปอะ. ซ แลน แก ปะ โครยญ คระ โฮว โครง เอีญ เปอะ. ซ นัม ปะ ฮอยจ ละ ซ เอีญ อาวต แม เปอะ นึง เมือง อาวต เปอะ เฮี. อาึ ซ อาวต ลอป ไม่ เปอะ ฮอยจ ละ ฟวยจ ป ซันญา อาึ อาึง ละ เปอะ เฮี โครยญ เจือ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","เญือม เอีจ โปวะ อื เน่อึม ไอจ แตะ ยาโคป ง่อต อื โตะ รพาวม แตะ ตอก เฮี, “อาึ แจง นึง อาวต พะจาว นา เฮี เตือง โอ อาึ ยุง เฟือฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","ยาโคป เซ ฮลัต ฆาื อื. อัฮ เฮี, “ซัมคัน เนอึม นา ก อาวต เตอะ เฮี. มัฮ โตว ตอก ไฮญ. มัฮ เนอึม เญือะ ยุฮ พะจาว. มัฮ โตะ รเวือะ เมือง มะลอง,” อัฮ เซ ยาโคป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ปวยฮ พริ เซ เญือม งาวป ลั่ง อื ยาโคป ลบุ่ฮ ซโมะ รฆวง แตะ เซ เกือฮ ชุง. เรฮ ลออยฮ นึง เปือง อื. เกือฮ อื แปน นา ก ซัมคัน อื. ");
INSERT INTO lcp_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","อัฮ เบ่ตเอน ไม่ นา เซ. ไพรม อื ปุย ปังเมอ อัฮ ลุต ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","เญือม เซ ยาโคป ซันญา อาึง โอเอีฮ ไม่ พะจาว ตอก เฮี, “ดัฮ พะจาว อาวต ดิ ไม่ อาึ, แลน แก เนอึม อาึ คระ โฮว เยอะ โฮ, ไม่ เกือฮ เนอึม อื ป โซม ป ปอน เนิ ไม่ เครอึง จาวป เครอึง ฟุต เตอะ โฮ, ");
INSERT INTO lcp_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ดัฮ นัม อาึ ฮอยจ ละ เอีญ แม เยอะ ฮอยจ เญือะ เปือะ เกอะ ไม่ กอ บาึง แตะ โฮ, พะเยโฮวา ซ แปน พะจาว ทื อาึ. ");
INSERT INTO lcp_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ซโมะ ซัมคัน ป ลบุ่ฮ อาึ เกือฮ ชุง นา เฮี ซ แปน นา ก อาวต พะจาว. เมาะ ป เกือฮ เปอะ เนิ กาว ปุน อาึ ซ ทไว ละ ปะ ติ ปุน,” อัฮ เซ ละ พะจาว นึง รซอม ซันญา แตะ, ยาโคป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ยาโคป โฮว แนฮ นึง คระ โฮว แตะ ฮอยจ ละ ก อาวต ปุย ลั่ก โอก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","ยุ นัมโม่ นา เซ ติ, มัฮ นา ก ลโลวง อื ติ โดฮ. ไก แกะ นึง ลอวย มู ไอจ ซดิ โบ อื. มอง ญุ รอาวม เน่อึม นึง นัมโม่ เซ. ซโมะ เตือป นัมโม่ เซ ระ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","เญือม เอีจ รโจะ โม แกะ เตือง โอยจ อื นา เซ, โม ป เลียง แกะ กอ วิต ซโมะ เซ โอก ฮา มวยญ นัมโม่ เซ, เดอึม ซ เกียฮ เชียต รอาวม ละ แกะ. ฟวยจ เซ ซ เตือป แม นัมโม่ นึง ซโมะ ระ เซ ตอก ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ยาโคป ไฮมญ โม ป เลียง แกะ เซ ตอก เฮี, “เอียกปุ, โม เปะ อาวต ก เมอ ย่วง เปอะ?” อัฮ เซ. โม เซ โลยฮ อื, “เอะ อาวต ย่วง ฮารัน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","“อัม ยุง เปอะ ลาบั่น กวนโซะ ตะ นาโฮ เยอ?” อัฮ เซ ละ อื. “ยุง เงอะ แอฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","“ลาบั่น เซ อัม กอ?” อัฮ เซ ละ อื. “กอ. ตึต แตะ, ราเชน ป มัฮ กวน เครีฮ อื ฮอยจ ไม่ แกะ ยุฮ แตะ ปเลี่ย,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","ยาโคป อัฮ เฮี, “แลน เมิฮ. ซเงะ ฮลาวง ลั่ง. ดิ เติง โตว เวลา เกือฮ ปุย แกะ อาวต โตะ คอก เกอ. เมอยุ โอ เปอะ เชียต แปฮ รอาวม ละ อื ละ ซ เกือฮ แม เปอะ โฮว ซาวป เปือม ไรป เปอ?” อัฮ เซ ยาโคป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","“เอะ ปุน ยุฮ โตว กา เฆียง ฮอยจ โอยจ แกะ ยุฮ ปุย. เญือม เซ ซ วิต ปุย ซโมะ ระ เซ ละ เอะ. ซ โฮลฮ เชียต รอาวม ละ แกะ เญือม เซ,” อัฮ เซ โม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ลไล อู อื ไม่ ปุ แตะ เซ, ราเชน ฮอยจ โรฮ นา เซ ไม่ แกะ เลียง แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","เญือม ยุ ยาโคป ราเชน เซ ไม่ แกะ ยุฮ เนอึม ระ แตะ เซ, เลียก เอิน ละ นัมโม่ เซ วิต โน่ง ซโมะ เซ โอก. เชียต รอาวม ละ แกะ ยุฮ เนอึม ระ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","เญือม เซ ยาโคป ฮงาึต ราเชน. เยือม เรียง นึง ไมจ รพาวม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","รโฮงะ อื ละ ราเชน มัฮ แตะ กวน เฌือต เปือะ อื, ไม่ มัฮ แตะ กวน เรเบ่คา เญือะ อื. ราเชน เซ ตอ เอิน เอีญ รโฮงะ อื ละ เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","เญือม ฮมอง ลาบั่น ไลลวง กวน เฌือต แตะ เซ ซไจ เอิน โฮว เคะ อื. โอม อื. ฮงาึต อื. ตาว อื เอีญ เญือะ แตะ. ยาโคป รโฮงะ ไลลวง แตะ ละ อื โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ลาบั่น อัฮ เฮี, “ปะ มัฮ เนอึม เปอะ โกะ เนะ อาึ,” อัฮ เซ ละ อื. ยาโคป อาวต ไม่ อื นา เซ ติ เคิ. ");
INSERT INTO lcp_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ฟวยจ เซ ลาบั่น อัฮ เฮี ละ ยาโคป, “เคียง มัฮ เปอะ โกะ เนะ อาึ ตอก เซ คาว โตว ละ ยุฮ เยือ เปอะ กัน ละ อาึ เตือง โอ เปอะ ไก จังลา. ปะ ซ ไอฮ เปอะ เมาะ เมอ จัง แตะ? รโฮงะ เนิ เมิฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ลาบั่น ไก กวน เครีฮ ลอา. ป มัฮ ออ อื มัฮ เลอา. ปุ เลอา เซ มัฮ ราเชน. ");
INSERT INTO lcp_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","เลอา เซ มัฮ ปุย ยอย ไง่. ราเชน เซ มัฮ ปุย ไมจ ฮุนฮัง ไม่ ไมจ นาตา อื. ");
INSERT INTO lcp_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ยาโคป ฮรัก ราเชน. ฆวต ไอฮ อื. อัฮ เฮี ฆาื อื, “เนอึม ระ, ดัฮ เปอะ เกือฮ ราเชน เนิ โฮ, อาึ ซ ยุฮ กัน ละ เปอะ อาแลฮ เนอึม,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ลาบั่น โลยฮ อื, “แปน. ฮา ซ เกือฮ ละ ปุย ไฮญ เญอ เอีจ ปุก โรฮ เนิ เกือฮ ฮะ ละ ปะ อา. อาวต ไม่ อาึ เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ยาโคป อาวต เนอึม ไม่ อื, ยุฮ เนอึม กัน ละ อื อาแลฮ เนอึม ละ ซ โฮลฮ แตะ ราเชน. ตอก ป มัฮ ติ เตะ โน่ง ละ อื นึง ฮรัก เนอึม แตะ ราเชน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ฟวยจ เซ ยาโคป อัฮ เฮี ละ ลาบั่น, “เอีจ เติง เวลา ตะ เปอะ เกือฮ กวน เครีฮ แตะ เนิ อี. ปัว เปอะ เกือฮ แปฮ เนิ, เดอึม อาึ ซ โฮลฮ แปน ปุย เญือะ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","เญือม เซ ลาบั่น กอก ปุย เตือง โอยจ อื. โซม ญุ เนอึม ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","เญือม เอีจ ฟวยจ โซม อื ลาบั่น บระ ตาว เลอา ละ ยาโคป. ซาวม เซ ยาโคป ยุ เนอึม ปุ แตะ ไม่ เลอา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","(ลาบั่น เกือฮ โรฮ กวนไจ แตะ ละ เลอา เซ ติ ปุย ละ ซ โฮลฮ อื รซอฮ ละ อื. มอยฮ อื มัฮ ซีละปา.) มัฮ ตอก เซ ตอก โฮลฮ ยาโคป เลอา เซ แปน ปุย เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","เญือม เอีจ ปวยฮ พริ อี, ยาโคป เดอึม ยุง มัฮ อื เลอา ป ไอจ แตะ ไม่ เซ. โฮว ฆาื อื เคะ ลาบั่น. อัฮ เฮี ละ อื, “เกียฮ ยุฮ โน่ง เปอะ ป ตัง เจือ ตอก เฮี ละ อาึ เมอ? อาึ มัฮ ยุฮ กัน ละ ซ โฮลฮ แตะ ราเชน, โม่ มัฮ อื? เกียฮ จุ โน่ง เปอะ อาึ ตอก เฮี เมอ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ลาบั่น โลยฮ อื ละ อื, “มัฮ โตว ปซี ปซา ยุฮ ปุย นา เฮี ละ ซ เกือฮ อื ป มัฮ ปุ ปุย เอีญ กา ออ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","อาวต ไม่ ตอก เซ ฮอยจ ละ ลอยจ อาแลฮ ซเงะ เลียง ปุย ปุ แตะ เซ ฮัม. ฟวยจ เซ อาึ ซ เกือฮ ปะ โฮลฮ แม ปุ อื, ปังเมอ ซ โฮลฮ แม เปอะ ยุฮ กัน รโตง อื อาแลฮ เนอึม แม,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ยาโคป ยุฮ เนอึม อื ตอก เซ. อาวต ไม่ เลอา อาแลฮ ซเงะ. ฟวยจ เซ ลาบั่น เกือฮ โรฮ ราเชน ละ อื ละ ซ แปน อื ปุย เญือะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","(ลาบั่น เกือฮ โรฮ บิ่นฮา กวนไจ ยุฮ แตะ ละ ราเชน ละ ซ แปน อื ป รซอฮ ละ อื.) ");
INSERT INTO lcp_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ยาโคป ลอต โรฮ ไอฮ ราเชน แปน ปุย เญือะ แตะ. ฮรัก อื ระ ฮา เลอา. ยุฮ แม กัน ละ ลาบั่น เซ ฆาื อื อาแลฮ เนอึม แม. ");
INSERT INTO lcp_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","เญือม ยุ พะจาว โอ ยาโคป ฮรัก เลอา เซ, พะจาว เกือฮ เลอา เซ เกียฮ ไก กวน. ราเชน เซ ปังเมอ เกือฮ อื ซแกต. ");
INSERT INTO lcp_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","เลอา โรวก. ไก กวน รเมะ ติ. อัฮ อื ตอก เฮี, “พะจาว เอีจ ยุ อื เม่ะมั่ก อาึ อื. ปเลี่ย ปรเมะ เญือะ อา ตึน ซ ฮรัก อาึ,” อัฮ เซ. อัฮ รูเบ่น ละ กวน แตะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","กังเคะ เอ โรวก แม ติ โฮน. ไก แม กวน รเมะ ติ แม. อัฮ อื ตอก เฮี, “พะจาว เอีจ เกือฮ แม กวน รเมะ เฮี เยอะ เนิ นึง ฮมอง อื โอ ปุย ฮรัก อาึ,” อัฮ เซ. อัฮ ซิเมโอน ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","ฟวยจ เซ โรวก แม ติ โฮน. ไก แม ติ กวน รเมะ อื. อัฮ เฮี, “ปเลี่ย เฮี ปรเมะ เญือะ อา ตึน ซ รโจะ ดิ รพาวม แตะ ไม่ อาึ นึง โฮลฮ อาึ กวน รเมะ อื ละ อื ลอวย,” อัฮ เซ. เลอา อัฮ เลวี ละ กวน เซ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","ฟวยจ เซ โรวก แม ติ โฮน แม. เกิต แม ติ กวน รเมะ อื. อัฮ อื ตอก เฮี, “โฮน เฮี อาึ ซ ลืลาว พะจาว,” อัฮ เซ. อัฮ ยูด่า ละ อื ฆาื อื. ลโล่ะ เมาะ เซ กวน เลอา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ราเชน โฮลฮ โตว กวน แตะ ติ ชวง. เญือม ยุ อื โฮลฮ ออระ แตะ กวน แตะ ตอก เซ, วัว ละ อื ฆาื อื. อัฮ เฮี ละ ยาโคป, “เกือฮ โรฮ อาึ ไก กวน โรฮ. ดัฮ เปอะ โอ เกือฮ โฮ, อาึ ซ ยุม เมอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ยาโคป รอก พาวม ฆาื อื นึง ราเชน เซ. “อาึ อัม เกียฮ ยุฮ โอเอีฮ ตอก ยุฮ พะจาว อื? มัฮ พะจาว ป คัต ปะ เกือฮ โอ เกียฮ ไก กวน เนอ, มัฮ โตว อาึ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","ราเชน อัฮ อื ตอก เฮี, “บิ่นฮา กวนไจ อาึ อาวต โรฮ นา เฮี. ไอฮ เมิฮ เดอึม ซ ไก กวน รโตง อาึ. อาึ ซ โฮลฮ กวน เฌือต แตะ เบือ อื. ซ เมีญ มัฮ กวน อาึ,” อัฮ เซ ละ ยาโคป. ");
INSERT INTO lcp_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","เญือม เซ ราเชน เกือฮ เนอึม บิ่นฮา เซ ละ ยาโคป. ยาโคป ไอฮ เนอึม อื แปน ปุย เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ฟวยจ เซ บิ่นฮา เซ โรวก เนอึม ฆาื อื. เกิต กวน รเมะ ติ. ");
INSERT INTO lcp_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","เญือม เซ ราเชน อัฮ เฮี, “พะจาว เอีจ ตัตซิน โอเอีฮ ละ ซ เรอึม แตะ อาึ. เอีจ ฮมอง รซอม ไววอน ยุฮ อาึ. เกือฮ กวน รเมะ เอะ เนิ ติ,” อัฮ เซ. อัฮ ด่าน ละ กวนงัก เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","กังเคะ เอ บิ่นฮา โรวก แม ติ โฮน. เกิต แม กวน รเมะ ละ ยาโคป ติ แม. ");
INSERT INTO lcp_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ราเชน อัฮ เฮี, “อาึ เอีจ ตอก ป เดือ รแม่น ไม่ ออระ เกอะ. เอีจ เป เนอึม เมอะ,” อัฮ เซ. ปุก มอยฮ กวนงัก เซ. อัฮ นัปทาลี ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","เลอา เมือต ยุ โอ โกะ แตะ เญือะ ไก กวน, ตาว โรฮ ซีละปา กวนไจ แตะ ละ ยาโคป ฆาื อื. เกือฮ โรฮ อื แปน ปรโปวน เญือะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ซีละปา กวนไจ เลอา เซ เกิต โรฮ กวน รเมะ ละ ยาโคป โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","เลอา อัฮ เฮี, “ไมจ เนอึม มุ่น เนอะ,” อัฮ เซ. อัฮ กาต ละ กวนงัก เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ฟวยจ เซ ยาโคป ไก แม กวน รเมะ ไม่ ซีละปา เซ ติ แม. ");
INSERT INTO lcp_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","เลอา อัฮ เฮี, “มวน เนอึม รพาวม เมอะ, ปเลี่ย เฮี โม ปรโปวน ซ อัฮ ตื อาึ มวน รพาวม,” อัฮ เซ. อัฮ อาเชอ ละ กวนงัก เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ติ โฮน อื ปุก เมือ มัก ปุย เฮงาะ ซาลี. รูเบ่น โอก โฮว นึง รปึม ไม่ ปุย. ยุ ซปุย ดู่ด่าอิม. เปฮ เอีญ ตาว อื ละ มะ แตะ ป มัฮ เลอา เซ. ราเชน ปัว อื นึง เลอา เซ, “เกือฮ ซปุย โรวก กวน เปอะ เซ เนิ ง่อน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","เลอา โลยฮ อื, “เอีจ ลู เปอะ ตุย ปรเมะ เญือะ อะ ฮา เยอะ. ดิ ปอ โตว ลั่ง ละ เปอะ? ฆวต ลู แม เปอะ ตุย ซปุย ยุฮ กวน เนอะ เซ ฮา เยอะ แม,” อัฮ เซ ละ อื. ราเชน อัฮ เฮี, “ดัฮ เปอะ เกือฮ ซปุย เซ เนิ โฮ, เนฮ ก ซาวม อาึ ซ เกือฮ ยาโคป ไอจ ไม่ ปะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","เญือม เอีจ เอีญ ยาโคป เมือ กปู อื, เลอา โอก รโนฮ รชึง อื. “เปือะ รูเบ่น, เนาะ ก ซาวม เฮี ซ โฮลฮ เปอะ ไอจ ไม่ อาึ นึง เอีจ กัฮ อาึ จัง เปอะ นึง ซปุย ยุฮ กวน เนอะ,” อัฮ เซ เลอา เซ. ซาวม เซ ยาโคป ไอจ เนอึม ฆาื อื ไม่ เลอา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","พะจาว ฮมอง รซอม ไววอน ยุฮ เลอา. โรวก แม ติ โฮน. เกิต แม กวน รเมะ ติ. แปน พอน เตือง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","เลอา อัฮ เฮี, “พะจาว เกือฮ จัง เงอะ เนิ นึง เกือฮ อาึ กวนไจ ยุฮ แตะ ละ ปรเมะ เญือะ แตะ,” อัฮ เซ. ปุก มอยฮ กวนงัก เซ. อัฮ อิตซคา ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","กังเคะ เอ เลอา ไก แม กวน รเมะ ติ. กวน ยาโคป ป เกิต เน่อึม นึง เลอา เซ แปน แลฮ เตือง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","เลอา อัฮ เฮี, “พะจาว เอีจ ปละ ซาึต ป ไมจ เนิ. เฆิม เฮี ปรเมะ เญือะ อา ซ นัปทื อาึ นึง โฮลฮ อาึ กวน รเมะ อื ละ อื แลฮ ปุย เอิน,” อัฮ เซ. อัฮ เซบู่ลุน ละ กวน เซ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ฟวยจ เซ ไก โรฮ กวน รโปวน ติ. อัฮ ดี่นา ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","กังเคะ เอ พะจาว โตก โรฮ ละ ราเชน. ง่อต รซอม ไววอน อื. เกือฮ โรฮ อื เกียฮ ไก กวน. ");
INSERT INTO lcp_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","ราเชน เซ โรวก โรฮ. เกิต โรฮ กวน รเมะ. อัฮ เฮี, “พะจาว เอีจ เกือฮ กวน รเมะ เอะ เนิ. ไลลวง โซะกิจ ปิญไง่ อาึ นึง โอ แตะ ไก กวน เซ, เอีจ ตุย เนอึม อื ฮา เยอะ เตือง โอยจ อื.” ");
INSERT INTO lcp_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","ราเชน ปุก มอยฮ กวน แตะ เซ, อัฮ โยเซป ละ อื. มัฮ อัฮ อื เฮี, “ปัว แม พะจาว เกือฮ กวน รเมะ เอะ เนิ ติ,” มัฮ อัฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","เญือม เอีจ ฟวยจ เกิต โยเซป เปอ, ยาโคป ปัว เอีญ ฮา ลาบั่น ป มัฮ เนอึม ระ แตะ เซ. “อาึ เอีจ ยุฮ กัน ละ เปอะ รโตง ปรโปวน เญือะ แตะ ไม่ กวน แตะ. ตึน ซ ยุง เปอะ ไอฮ เมาะ ไมจ กัน ยุฮ ฮุ ละ เปอะ. ปเลี่ย เฮี อาึ ฆวต ปัว เอีญ นึง ย่วง เกิต เมือง ไก แตะ,” อัฮ เซ ละ เนอึม ระ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ลาบั่น อัฮ เฮี ละ อื, “ดัฮ มัฮ ป ปุก รพาวม ปะ โฮ ฆวต เกือฮ ลั่ง ปะ อาวต ไม่ แตะ. อาึ เอีจ ยุง นึง ซโปก แตะ ปิฮ พะจาว มุ่น ละ อาึ เบือ ปะ อา. ");
INSERT INTO lcp_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","เมอ ซ ไอฮ เปอะ นึง จัง แตะ? เตอึม ป ฆวต ไอฮ เปอะ นึง, อาึ ซ เกือฮ ละ เปอะ,” อัฮ เซ ลาบั่น เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ยาโคป โลยฮ อื, “เอีจ ยุง เปอะ เมาะ ยุฮ อาึ กัน ละ เปอะ. เอีจ ที ละ เปอะ, เคียง แลน แก อาึ คอง เลียง เปอะ เอีจ พรุฮ เนอึม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ไพรม อื คอง เลียง เปอะ เซ รมัฮ. ปเลี่ย เฮี เอีจ โฮวน นึง เกือฮ พะจาว อื โฮวน เบือ อาวต อาึ ไม่ เปอะ. ปเลี่ย เฮี เอีจ ไมจ โรฮ อาึ ซาวป โอเอีฮ ละ เญือะ โกะ แตะ ไอฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","ลาบั่น ไฮมญ อื, “ซ ไอฮ เปอะ เมาะ เมอ จัง แตะ?” อัฮ เซ. ยาโคป โลยฮ อื, “ไอฮ โตว เมาะ ออฮ เมาะ เอีฮ. ดัฮ เปอะ ฆวต เกือฮ อาึ แลน ลั่ง แกะ ปิ ยุฮ เปอะ ยุฮ แลน ตอก เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","เกือฮ อาึ ซาวป กวน แกะ ลอง ลลาึง แกะ ยุฮ เปอะ โครยญ ตัว อื ไม่ กวน ปิ พรุยฮ นึง อื ไม่ โม ป โกง อื โครยญ ตัว อื. อาึ ซ ไอฮ เมาะ เซ โน่ง. ");
INSERT INTO lcp_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","เฆียง เฮี เยอ ซ ยุง เปอะ เมาะ ซื อาึ ละ เปอะ ฆาื อื. ดัฮ ไก แกะ โอ ลอง ไม่ ปิ โอ โกง โอ พรุยฮ ลลาึง คอง เลียง อาึ โฮ, ซ ยุง เปอะ นึง เซ มัฮ อื ป บระ อาึ ฮา เปอะ,” อัฮ เซ ยาโคป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ลาบั่น โลยฮ อื, “ปุก ตอก เซ. เกือฮ แปน ตอก อัฮ เปอะ เซ เมิฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ซเงะ เซ ลาบั่น ซไจ รกัฮ โม ปิ โกง ปิ พรุยฮ เตือง ป ไฮมญ ปรโปวน อื. เกือฮ อื อาวต โน่ง. รกัฮ โรฮ โม กวน แกะ ลอง ไม่ อื เกือฮ โม กวน แตะ แลน อื. ");
INSERT INTO lcp_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","เกือฮ อื อาวต ซไง ฮา ยาโคป ลอวย ซเงะ คระ. เกือฮ ยาโคป แลน แก แกะ ไม่ ปิ ป โฮฮ ลั่ง อื ฮา เซ. ริ บ่วก ละ ยาโคป ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ยาโคป ตุย กัก โคะ ไอม. มัฮ โคะ ลอวย เจือ ป ไก เมือง เซ. ปอฮ เฮลาะ อื แปน ตอน แปน ตอน แตะ. เกือฮ อื พรุยฮ ลอง บลัฮ ปิญ บลัฮ. ");
INSERT INTO lcp_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","อาึง กัก โคะ เซ ซองนา ปิ ไม่ แกะ นา ก ฮอยจ ญุ อื รอาวม. มัฮ ยุฮ อื ตอก เซ นึง กอ ฮึน อื ปุ แตะ โบ รอาวม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ปิ ป ติต ปุ แตะ ตอก เซ ไก กวน พรุยฮ ง่อน โกง ง่อน. ");
INSERT INTO lcp_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ยาโคป รกัฮ กวน แกะ กวน ปิ ป พรุยฮ ป โกง อื เซ เกือฮ อาวต โน่ง. ฟวยจ เซ เกือฮ แกะ ปิ ป กัมลัง ติต ปุ แตะ นา ลั่ก กวน แกะ กวน ปิ พรุยฮ ป เกิต เน่อึม แกะ ปิ ยุฮ ลาบั่น เซ. แกะ ปิ ยุฮ โกะ แตะ เซ เกือฮ อื อาวต โน่ง โนก แกะ ปิ ยุฮ ลาบั่น เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","เญือม ยุ อื แกะ ระ เรียง ฆวต ติต แกะ ไฮมญ ยาโคป อาึง กัก โคะ ละ อื โบ รอาวม ญุ อื. เกือฮ อื ติต ปุ แตะ โบ โคะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ดัฮ มัฮ แกะ ชุมเรียง โฮ อาึง โตว อื ละ อื. แปน ฮอยจ แกะ ชุมเรียง ฆาื อื ละ ลาบั่น โฮวน. แกะ ระ เรียง นึง อื ฮอยจ ละ ยาโคป. ");
INSERT INTO lcp_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","เคียง เซ ยาโคป โฮลฮ คาวคอง แตะ โฮวน. แปน เนอึม ปุย ไก คอง เลียง คอง ดู่ โฮวน. กวนไจ รเมะ กวนไจ รโปวน ไม่ อุต ไม่ บรัง ยุฮ อื โฮวน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ฟวยจ เซ ยาโคป ฮมอง ป อัฮ กวน รเมะ ลาบั่น ตอก เฮี, “ยาโคป เอีจ ลู ตุย โรวก คาวคอง เปือะ เกอะ เตือง โอยจ อื. โอเอีฮ เมาะ ป โฮลฮ ป ปุน อื เอีจ มัฮ คอง เปือะ เกอะ เตือง โอยจ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ยาโคป ยุ โรฮ โอ ลาบั่น เญือะ เปลีฮ นา ไมจ แตะ ละ แตะ ตอก ไพรม อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","เญือม เซ พะจาว อัฮ เฮี ละ อื, “เอีญ เมิฮ. เอีญ อาวต นึง เมือง อาวต มะเปือะ ตะเยือะ โกะ เปอะ. อาึ ซ อาวต ไม่ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ยาโคป กอก ราเชน ไม่ เลอา เกือฮ อื เอีญ ฮา ลโลวง นา ก ซาวป แกะ ยุฮ อื เปือม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","อัฮ เฮี, “อาึ ยุ ที โอ เปือะ เปอะ เญือะ แลน ไมจ แลน มวน อาึ ตอก ไพรม อื. ญันได่ เอีจ มัฮ พะจาว ทื เปือะ เกอะ ป อาวต ไม่ อาึ อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","โม เปะ เอีจ ยุง เปอะ รซอฮ อาึ ละ เปือะ เปอะ เมาะ ไก เรียง แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","เปือะ เปอะ บ่วก ละ อาึ นึง เปียน อื ตอก จัง แตะ อาึ แปน กาว โฮน อื เอิน. พะจาว ปังเมอ โอ เกือฮ อื ปุน ยุฮ ไลจ ไม่ อาึ. ");
INSERT INTO lcp_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ดัฮ เปือะ เปอะ อัฮ ติ แตะ ซ เกือฮ ป โกง อื ละ อาึ แปน จัง เงอะ โฮ, โม แกะ ไม่ ปิ ป เกิต เซ โฮวน ลั่ก โกง แตะ ฆาื อื. ดัฮ อัฮ ติ แตะ ซ เกือฮ ป พรุยฮ อื เนิ, โม แกะ ปิ เซ เกิต แนฮ โรฮ ป พรุยฮ นึง ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","มัฮ ตอก เซ ตอก เกือฮ พะจาว แกะ ปิ ยุฮ เปือะ เปอะ เซ ฮอยจ ละ อาึ อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“ติ โฮน อื เญือม เติง เคิ ติต ปิ ปุ แตะ, อาึ รโมะ ยุ ปิ ไฮมญ ฮึน ปิ รโปวน. โม ปิ ไฮมญ เซ มัฮ ปิ พรุยฮ ไม่ ปิ โกง เตือง มู แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","เญือม เซ อาึ รโมะ ฮมอง กอก เตปด่า พะจาว มอยฮ แตะ. อาึ โลยฮ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","เตปด่า เซ ดวน อาึ แลน ปิ ไฮมญ โม เซ. เกือฮ อาึ ยุ ที ตอก พรุยฮ อื ไม่ โกง อื เตือง โอยจ อื. เญือม เซ อาึ ฮมอง อัฮ พะจาว อื ละ แตะ ตอก เฮี, ‘อาึ เอีจ ยุ ป ยุฮ ลาบั่น ละ เปอะ โครยญ เจือ. เซ ป เกิต โอเอีฮ ตอก เฮี ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","อาึ มัฮ พะจาว ป เปลีฮ ติ แตะ ละ เปอะ นึง เบ่ตเอน นา ก เรฮ ปะ ลออยฮ นึง ซโมะ ละ ซ เกือฮ เปอะ ซัมคัน ละ อาึ, ไม่ นา ก ซันญา เปอะ โอเอีฮ ละ อาึ. ปเลี่ย เฮี ไมจ เปอะ โกฮ เอีญ ฮอยจ นึง ย่วง เกิต เมือง ไก แตะ เซ,’ อัฮ เซ เนิ พะจาว.” ");
INSERT INTO lcp_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ฟวยจ อัฮ ยาโคป โอเอีฮ เซ, ราเชน ไม่ เลอา โลยฮ อื, “ปเลี่ย เฮี เอีจ แจง โอ อื เญือะ ไก คาวคอง ยุฮ เปือะ เกอะ ป ซ ฮอยจ ละ เอะ เอ. ");
INSERT INTO lcp_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","เปือะ เกอะ เอีจ เมีญ เอิน เอะ ตอก ปุย ตังเมือง โฮ. เอีจ โชะ เอะ. เมาะ ป โฮลฮ แตะ เบือ เอะ เซ เอีจ โกว ไอฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","คาวคอง ป ตุย พะจาว ฮา เปือะ เกอะ เซ เอีจ มัฮ ป ลัง ฮอยจ ละ เอะ ไม่ โม กวน เนอะ. ไมจ เปอะ ยุฮ ตัม ดวน พะจาว เปอะ เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","เญือม เซ ยาโคป เกือฮ ปรโปวน เญือะ แตะ ไม่ กวน แตะ บุก ปุ โฮว อุต. ");
INSERT INTO lcp_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","โครฮ ปุ โฮว คอง เลียง แตะ ลั่กกา แตะ. โรวก คาวคอง โฮลฮ แตะ นึง เมือง ปัตดั่น อารัม เซ, ตะ เอีญ ไม่ อื ฮอยจ เคะ ยิซฮัก ป มัฮ เปือะ แตะ นึง เมือง คะนาอัน. ");
INSERT INTO lcp_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ลไล โฮว ลาบั่น ละ ซ ญัป แตะ ฮาึก แกะ ยุฮ แตะ เซ, ราเชน เลียก บระ ฮุป ไว เปือะ แตะ ง่อน. ยาโคป ปังเมอ โอ ยุง อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ยาโคป บระ โรฮ รพาวม ลาบั่น เซ นึง โอ อื อู ไลลวง ซ เอีญ แตะ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ตุย โรวก โอเอีฮ ยุฮ แตะ เตือง โอยจ อื เอีญ พราวป ไม่ อื. เตือง โกลง ยูฟะเรตี ละ ซ ฮาวก แตะ เมือง กิเลอัต นา ก โฮวน บลาวง นึง. ");
INSERT INTO lcp_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","ฟวยจ เซ แม ลอวย ซเงะ เอ ลาบั่น ฮมอง ตอ ยาโคป ฮา แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","โกฮ โฮว ดิ ฆาื อื ไม่ กวน เฌือต แตะ, อาื ยาโคป เซ อาแลฮ ซเงะ คระ เดอึม เครอึป อื นึง บลาวง เมือง กิเลอัต. ");
INSERT INTO lcp_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ซาวม กา เครอึป อื เซ, ลาบั่น รโมะ ยุ ฮอยจ พะจาว เคะ แตะ, ไม่ อัฮ อื เฮี ละ อื, “ไมจ เปอะ แฮน ตอก ซ อัฮ เปอะ โอเอีฮ ละ ยาโคป นึง ป ไมจ ญุ่ก, นึง ป ฆอก ญุ่ก,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","เญือม ฮอยจ ลาบั่น เคะ อื เซ, ยาโคป เอีจ กัง พากัง ยุฮ แตะ นึง บลาวง เมือง กิเลอัต. โม คระ เฌือต ลาบั่น กัง โรฮ พากัง ยุฮ แตะ นา เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ลาบั่น อัฮ เฮี ละ ยาโคป, “เมอยุ บ่วก เปอะ ละ อาึ อื? เอีจ โรวก เปอะ กวน อาึ ตอก ปุย ปุน เปอะ นึง รุป แตะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","เกียฮ จุ โน่ง เปอะ อาึ นึง บระ เปอะ ตอ ตอก เซ เมอ? ตอก เมอ โอ เปอะ อู เนิ อี, เดอึม อาึ ซ เกียฮ กอก ปุย ฮอยจ เชีย ดิ ไม่ เตียต พิน ดิฮ รัมมะนา ไม่ อื, ละ ซ โฮลฮ โซม มวน ไม่ ปุ แตะ กา โฮว เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","เกือฮ เปอะ โตว อาึ โฮลฮ ฮงาึต กวน แตะ ไม่ กวนโซะ โอะ กา ซ โฮว เปอะ. ยุฮ เปอะ โอเอีฮ ตอก ป ยุฮ ป งาว โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","อาึ เอีจ ไก อัมนัต ปอ เกียฮ ยุฮ แตะ ป โซะ ละ เปอะ. รเอฮ ซาวม พะจาว ยุฮ เปือะ เปอะ ปังเมอ ดวน อาึ แฮน โอ แตะ อัฮ โอเอีฮ ละ เปอะ ป ไมจ ญุ่ก, ป ฆอก ญุ่ก. ");
INSERT INTO lcp_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","เอีจ เอีญ เปอะ นึง ซฆลอย แตะ เญือะ เปือะ แตะ. เอีจ ไมจ โรฮ ตอก เซ. ป โอ ไมจ นึง อื มัฮ บระ เปอะ โรวก ฮุป ไว อาึ. เมอยุ ยุฮ เปอะ โอเอีฮ ตอก เซ เยอ?” อัฮ เซ ละ อื ลาบั่น เซ. ");
INSERT INTO lcp_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ยาโคป อัฮ เฮี, “อาึ ฮลัต เตอะ นึง แกต แตะ ปะ ซ ลู ตุย กวน เปอะ ฮา เยอะ. เซ ป ตอ เยอะ ตอก เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ดัฮ ไก ไน โม เอะ เฮี ป บระ เนอึม โรวก ฮุป ไว เปอะ เซ, เอะ ซ เกือฮ ปุย เซ ยุม. เกือฮ โม คระ เฌือต เปอะ เฮี แปน พีญัน อื. ซาวป แลน ตัม ไก เนอึม โอเอีฮ ป มัฮ คอง เปอะ นึง อื, ตุย เมิฮ ดัฮ ไก โฮ,” อัฮ เซ ละ อื ยาโคป เปอ. เตอ โอ ยุง บระ ราเชน ฮุป ไว เปือะ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ลาบั่น เลียก ซาวป อื โตะ พากัง ยุฮ ยาโคป รกา. ซาวป แม อื นึง พากัง ยุฮ เลอา. ซาวป โรฮ อื นึง พากัง ยุฮ โม กวนไจ อื เตือง ลอา อื. ยุ โตว อื. เลียก แม นึง พากัง ยุฮ ราเชน. ");
INSERT INTO lcp_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ราเชน เม่าะ อาึง ฮุป เซ ฆรึม รตัง อุต. งาวม ราว อื. ลาบั่น ซาวป เนอึม ซาวป แนม อื นึง พากัง เซ. ยุ โตว อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ราเชน อัฮ เฮี, “ปุ รอก พาวม ฆาื นึง อาึ โอะ เปือะ. อาึ เกียฮ โกฮ ชุง โตว ซองนา เปอะ เนาะ ออ, นึง ฮอยจ ปุโฮมว เยอะ,” อัฮ เซ. เญือม ซาวป ลาบั่น ฮุป ไว แตะ ตอก เซ ยุ โตว อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ยาโคป รอก พาวม. บวยจ ละ ลาบั่น ตอก เฮี, “มัฮ พิต ตอก เมอ ป ยุฮ อาึ ละ เปอะ? อาึ คัม มั่ป นึง เปอะ ตอก เมอ? เกียฮ อาื โน่ง เปอะ อาึ ตอก อาื ปุย คะมุย โฮ เมอ? ");
INSERT INTO lcp_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","ปะ เอีจ ซาวป เปอะ เต เครอึง อาึ เตือง โอยจ อื. เมอ ป ยุ เปอะ ป มัฮ คอง โกะ เปอะ นึง อื? อาึง นา เฮี ซองนา คระ เฌือต เอะ เฮี. เกือฮ โม เฮี ตัตซิน ไอฮ ป ปุก ป พิต นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","อาึ เอีจ อาวต ไม่ ปะ ง่า เนอึม. แกะ ไม่ ปิ ยุฮ เปอะ เอีจ ไก กวน ตัม เวลา อื โครยญ โฮน อื. อาึ มอก โตว ปอน แกะ ไฮมญ ยุฮ เปอะ ติ ชวง. ");
INSERT INTO lcp_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","เญือม เกียต โกะพริ แกะ ปิ ยุฮ เปอะ, มัฮ อาึ ป โรก ละ เปอะ. ดัฮ ไก ง่อน ป บระ ปุย อื, ปะ ดวน เปอะ อาึ โรก แตน ละ เปอะ โครยญ ตัว อื, ปัง บระ ซเง่ะ ปัง บระ รซาวม อื ญุ่ก. ");
INSERT INTO lcp_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","อาึ โฮลฮ โอต ตอง กอยจ แตะ เมือ ซเง่ะ อื. โฮลฮ โอต โฆยญ บริ ละ แตะ เมือ ก ซาวม อื. โฮลฮ โตว โซม ญึม ไอจ ไมจ ตอก ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","อาึ โอต โอเอีฮ ตอก เซ ติ เจน ง่า เนอึม อาวต แตะ ไม่ ปะ. ยุฮ กัน ละ ปะ กาว โรฮ ปาวน เนอึม รโตง กวน ปะ ลอา เซ. ยุฮ กัน รโตง แกะ ปิ เซ แลฮ เนอึม. ปะ เปียน เปอะ ไล จัง แตะ อาึ กาว โฮน. ");
INSERT INTO lcp_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","มัฮ โอ พะจาว ยุฮ ตะเยือะ เกอะ ป ทื อัปราฮัม ไม่ ยิซฮัก เซ อาวต ไม่ เยอะ, ปะ ตึน ซ เอีจ ฟวยจ เกือฮ เปอะ อาึ เอีญ ปลาว เยือ ฮา แตะ. พะจาว เซ ปังเมอ เอีจ ยุ อื เม่ะมั่ก อาวม อาึ เซ. รเอฮ ซาวม เมอ พะจาว เอีจ ซตอก โรฮ ปะ ฆาื อื,” อัฮ เซ ละ เนอึม ระ แตะ เซ ยาโคป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ลาบั่น อัฮ เฮี, “ปรโปวน เฮี มัฮ กวน อาึ. กวน อื มัฮ กวนโซะ อาึ. แกะ ปิ เฮี มัฮ คอง เลียง เงอะ. มัฮ ป อัฮ เนอึม ปุย ติ, เมาะ ป ยุ ปุย เฮี มัฮ คอง อาึ เตือง โอยจ อื. ปัง มัฮ ตอก เซ ญุ่ก, อาึ เญือะ ไก โตว ป อัฮ นึง ละ ปะ. กวน เนอะ ไม่ กวนโซะ โอะ เฮี อาึ มอป ละ ปะ. ");
INSERT INTO lcp_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ไมจ เอะ ซันญา อาึง โอเอีฮ ไม่ ปุ แตะ ซโตฮ. ไมจ เอะ รชุก ซโมะ ติ กอง เกือฮ แปน ซกิ พีญัน ซน่ะ อาึ ไม่ ปะ,” อัฮ เซ ลาบั่น เซ. ");
INSERT INTO lcp_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ยาโคป ซาวป เนอึม ซโมะ ระ ลั่ง ฆาื อื ติ. โบลวง อื เกือฮ ชุง แปน ซโมะ ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","ดวน โรฮ กวน แตะ ไม่ กวนไจ แตะ ซาวป โรฮ ซโมะ. รชุก อื นา เซ ติ กอง. ฟวยจ เซ โซม ดิ โบ ซโมะ รชุก แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ลาบั่น อัฮ เยกา ซฮาดู่ทา ไม่ กอง ซโมะ เซ. ยาโคป ปังเมอ อัฮ กาเลเอต ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ลาบั่น อัฮ เฮี, “กอง ซโมะ เฮี มัฮ ซกิ พีญัน ซน่ะ อาึ ไม่ ปะ.” เซ ป อัฮ อื กาเลเอต ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","ลาบั่น อัฮ โรฮ มิซปา ไม่ อื, นึง อัฮ อื, “เกือฮ พะจาว แปน ป มอง ญัม ซน่ะ อาึ ไม่ ปะ เญือม อาวต เอะ ซไง ฮา ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ดัฮ ปะ คัม ตุง กวน อาึ โฮ, ดัฮ ปะ ไอฮ แม ปุย โคระ เญือะ แตะ, ไมจ เปอะ ไตม ตอก เฮี. ปัง โอ อาึ มอง แลน ปะ พะจาว มอง แลน เปอะ. มอง โรฮ แลน อาึ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","ลาบั่น อัฮ แม เฮี ละ ยาโคป, “ซโมะ โม เฮี ป รชุก เอะ นา เฮี ไม่ ซโมะ ติ โม่ว ป โบลวง นา เฮี ซ แปน ควน ไตม เอะ ลปุง ซันญา แตะ เซ ฆาื อื. อาึ ซ พา โตว ซโมะ โม เฮี ละ ซ ยุฮ แตะ ป โซะ ละ ปะ. ปะ ปุ โรฮ เญือะ พา ซโมะ โม เฮี ละ ซ ยุฮ เปอะ ป โซะ ละ อาึ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","พะจาว ยุฮ อัปราฮัม ไม่ นาโฮ มัฮ โรฮ พะจาว ป ทื เปือะ อื โรฮ ซ รเตีฮ โอเอีฮ ซน่ะ อาึ ไม่ ปะ,” อัฮ เซ ลาบั่น เนอ. เญือม เซ ยาโคป โกว มอยฮ พะจาว ทื ยิซฮัก เปือะ แตะ นึง รซอม ซันญา แตะ ซโตฮ. ");
INSERT INTO lcp_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","มอก ตอง ทไว ซัตซิง ละ พะจาว. กอก คระ เฌือต แตะ โซม ดิ ไม่ แตะ นึง บลาวง เซ. ฟวยจ โซม อื ไอจ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ปวยฮ พริ เซ ลาบั่น งาวป โกฮ. ฮงาึต กวน แตะ ไม่ กวนโซะ แตะ. ปิฮ มุ่น ละ อื. ฟวยจ เซ เอีญ ฮา อื ฮอยจ นึง ย่วง แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","เญือม โฮว แม ยาโคป นึง คระ อา รโตฮ ยุ เตปด่า พะจาว ง่อน. ");
INSERT INTO lcp_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","เญือม ยุ อื อัฮ เฮี, “เฮี มัฮ โม ตฮัน ยุฮ พะจาว,” อัฮ เซ. มัฮ เซ ป อัฮ อื มาฮะนาอิม ไม่ นา เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ยาโคป เกือฮ ปุย โฮว กา แตะ ง่อน, ละ ซ เกือฮ อื โฮว เคะ เอซาว ป มัฮ เอียกระ แตะ ป อาวต นึง เมือง เอโด่ม เซ. ตอม มวยญ แตะ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","เกือฮ อื อัฮ เฮี, “อาึ มัฮ ยาโคป, ตอม มวยญ แตะ ละ เอียกระ เกอะ ป มัฮ จาวไน ยุฮ แตะ. อาึ มัฮ กวนไจ ยุฮ เปอะ. อาึ เอีจ โฮลฮ อาวต ไม่ เนอึม ระ เกอะ ฮอยจ ปเลี่ย. ");
INSERT INTO lcp_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","อาึ เอีจ โฮลฮ โมวก ไม่ บรัง ไม่ แกะ ปิ โฮวน. กวนไจ เยอะ ไก โรฮ เตือง ปรเมะ ปรโปวน อื. อาึ ฆวต ตอม มวยญ แตะ ละ จาวไน ยุฮ แตะ, ละ ซ ปัว เปอะ เลียก พาวม นึง อาึ,” อัฮ เซ รซอม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","เญือม เอีจ เอีญ โม ป โฮว ตาว มวยญ ตอม อื เซ ฮอยจ เคะ ยาโคป เปอ, อัฮ เฮี ละ อื, “เอะ เอีจ ยุ อุ เอียกระ เปอะ เซ. ซ ฮอยจ โรฮ เคะ ปะ. ซ ฮอยจ ดิ ไม่ ปรเมะ 400 ปุย เอิน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ยาโคป ตุก รพาวม ฆาื อื. ฮลัต เตีจ. รฆุ ปุย อาวต ไม่ แตะ แปน ลอา มู, เตือง แกะ ปิ, ไม่ โมวก ไม่ อุต ยุฮ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","ง่อต อื โตะ รพาวม แตะ ตอก เฮี, “ดัฮ เอซาว ฮอยจ ละ ซ ยุฮ แตะ ไลจ ไม่ ติ มู โฮ, ติ มู อื ซ เตือน โรฮ ตอ โปน อื ยุ่ง,” อัฮ เซ โตะ รพาวม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ยาโคป ไววอน ฆาื อื. อัฮ เฮี, “โอ พะจาว ปะ มัฮ เปอะ พะจาว ทื อัปราฮัม ป มัฮ ตะ เกอะ ไม่ ยิซฮัก ป มัฮ เปือะ เกอะ. ปะ ดวน เปอะ อาึ เอีญ ฮอยจ เมือง ไพรม เมอะ ฮอยจ เคะ คระ เฌือต แตะ. ปะ อัฮ เปอะ ติ แตะ ซ เกือฮ อาึ ไมจ ป ยุ เคราะ ป ฮมอง. ");
INSERT INTO lcp_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","อาึ โซมกวน โตว ไม่ โฮลฮ แตะ ยุ ป ไมจ ป ญุ่ก ป โพต เปอะ เนิ นึง รพาวม ฮรัก เปอะ, ไม่ กุนมุ่น ยุฮ เปอะ เซ. อาึ ป มัฮ กวนไจ ยุฮ เปอะ เฮี, เญือม เตือง เงอะ โกลง จอแด่น เฮี ไพรม อื อาึ โฮว ไม่ โคะ ฆิ ปลาว แตะ. ปเลี่ย เฮี อาึ เอีจ ไก เอิน ปุย ยุฮ ฮุ ลอา มู เอิน. ");
INSERT INTO lcp_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","ปัว ปะ เรอึม อาึ เกือฮ โปน ฮา ป ซ ยุฮ เอียกระ เกอะ เนิ เซ. อาึ ฮลัต เตอะ ซ ฮอยจ ยุฮ ยุม ไม่ แตะ. ฮลัต โรฮ ซ ยุฮ ไม่ โม กวนดุ ไม่ มะ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","อาึ ปัว ปะ ไตม รซอม ซันญา เปอะ อาึง ละ อาึ, ตอก เอีจ อัฮ เปอะ ติ แตะ ซ เกือฮ อาึ โฮลฮ ยุ ป ไมจ ฮอยจ ละ ซ โฮลฮ โฮะ กวน เฌือต แตะ โฮวน ตอก ไฮมจ ไก นึง เกาะ, ปอ โอ ปุย เญือะ โอยจ เมีญ โฮ,” อัฮ เซ ละ พะจาว ยาโคป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","ยาโคป ตะ ไอจ นา เซ. กา ไอจ อื เลือก ซัตซิง ง่อน ละ ซ แปน อื ป เกือฮ แตะ ละ เอซาว ป มัฮ เอียกระ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","มัฮ ปิ รโปวน ลอา รอย ไม่ ปิ ไฮมญ ง่า, แกะ รโปวน ลอา รอย ไม่ แกะ ไฮมญ ง่า. ");
INSERT INTO lcp_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","โนก ฮา เซ มัฮ อุต โกวน ง่วย ไม่ กวน อื ไม่ โมวก รโปวน รปาวน, ไม่ โมวก โปก กาว, ไม่ บรัง รโปวน ง่า, ไม่ บรัง โปก กาว ป ตะ อื เกือฮ ละ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","ยาโคป เกือฮ อื โฮว แปน มู แปน มู แตะ. เกือฮ กวนไจ ยุฮ แตะ อาวต ไม่ อื โครยญ มู. อัฮ เฮี ละ อื, “โฮว กา อาึ อื. เกือฮ ติ เปอะ รโปยฮ ฮา ปุ แตะ ซไง บุย โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","เญือม ยุ เปอะ เอียกระ เกอะ ตึน ซ ไฮมญ โม เปะ ตอก เฮี, ‘มัฮ ปุย ปอเลียง เปอะ? โฮว เปอะ ก เมอ? ซัตซิง โฮว กา เปอะ เฮี, มัฮ ปุย กุม อื?’ ตึน ซ อัฮ เซ ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","19","เญือม เซ ไมจ เปอะ อัฮ ละ อื ตอก เฮี, ‘มัฮ คอง ยาโคป กวนไจ เปอะ. มัฮ ป รโปะ อื ละ ปะ ป มัฮ จาวไน ยุฮ แตะ. ยาโคป เซ เอีจ อาวต ลั่กเคะ เอะ.’ ” เกือฮ กวนไจ ยุฮ แตะ อัฮ อื ตอก เซ โครยญ โฆะ แตะ เน่อึม นึง มู ป โฮว รกา ฮอยจ ละ มู ป โฮว รเคะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ยาโคป อัฮ โรฮ เฮี, “ไมจ เนอึม เปอะ อัฮ ละ อื ตอก เฮี, ‘ยาโคป ป มัฮ กวนไจ เปอะ ซ ฮอยจ ลั่กเคะ เอะ,’ ไมจ เปอะ อัฮ เซ ละ,” อัฮ เซ. ยาโคป เอีจ มัฮ แกต อื ติ แตะ ซ ปุน เกือฮ เอซาว ไก รพาวม นึง แตะ เบือ โอเอีฮ ป รโปะ แตะ ละ อื ลั่กกา แตะ ตอก เซ. แกต เอซาว ซ รัปคัม แตะ ฆาื อื เญือม ยุ อื ปุ แตะ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","มัฮ เซ ป รโปะ อื คอง เลียง แตะ ละ เอซาว ลั่กกา แตะ ตอก เซ ฆาื อื. ซาวม เซ โกะ อื อาวต ลั่ง ไม่ พากัง ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ซาวม เซ ยาโคป โกฮ โรวก ปรโปวน เญือะ แตะ เตือง ลอา อื ไม่ กวนไจ รโปวน ยุฮ แตะ เตือง ลอา อื ไม่ กวน รเมะ แตะ เตือง กาว โรฮ ติ อื เซ, เกือฮ อื เตือง โกลง ยะบ่อก. ");
INSERT INTO lcp_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","ฟวยจ เซ เกือฮ โรฮ คอง เลียง แตะ เตือง โรฮ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","โกะ อื อาวต โน่ง ลั่ง นา เซ. ไก ปรเมะ ติ, ฮอยจ เดือ รแม่น ไม่ อื ฮอยจ ละ ปวยฮ พริ. ");
INSERT INTO lcp_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","เญือม ยุ ปรเมะ เซ โอ แตะ ซ เป ยาโคป เซ, เดือะ เจีจ เน่อึม รเวือง อื. ลฆลอยจ เน่อึม รเวือง อื ลอต เอิน เฌาะ ตอก อาวต แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ปรเมะ เซ อัฮ เฮี, “พลวย อาึ เกือฮ เอีญ. เอีจ ซ ปวยฮ พริ อี,” อัฮ เซ ละ อื. ยาโคป โลยฮ อื ตอก เฮี, “ตัม โอ เปอะ ดิ ปิฮ มุ่น เนิ, ดิ ญอม โตว พลวย เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ปรเมะ เซ ไฮมญ ยาโคป ตอก เฮี, “ปะ มัฮ ปุย มอยฮ เปอะ?” ยาโคป โลยฮ อื, “อาึ มัฮ ยาโคป,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ปรเมะ เซ อัฮ แม เฮี, “ปะ เญือะ ซ มัฮ โตว ยาโคป มอยฮ เปอะ. ซ มอยฮ เปอะ อิซราเอน นึง เอีจ โฮลฮ เปอะ ตอซู ไม่ พะจาว ไม่ ปุย ปลัฮเตะ. เอีจ เป เนอึม เปอะ,” อัฮ เซ ละ อื ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ยาโคป อัฮ เฮี ละ ปุย เซ, “ปัว ปะ รโฮงะ มอยฮ เปอะ เนิ,” อัฮ เซ. ปุย เซ โลยฮ อื, “เมอยุ ไฮมญ เปอะ มอยฮ อาึ อื?” อัฮ เซ ละ อื. เญือม เซ ปุย เซ ปิฮ มุ่น ละ ยาโคป. ");
INSERT INTO lcp_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ฟวยจ เซ ยาโคป อัฮ เฮี โตะ รพาวม แตะ, “อาึ เอีจ โฮลฮ ยุ นา พะจาว, ไอม โรฮ ลั่ง เงอะ เยือก เมอ,” อัฮ เซ. อัฮ เปนีเอน ไม่ นาตี อาวต อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","เญือม โกฮ โฮว ยาโคป ฮา เปนีเอน เซ ซเงะ เอีจ โอก. ยาโคป เฌะ ปุ โฮว นึง โฌวะ ลฆลอยจ เน่อึม รเวือง แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","มัฮ เซ ป โอ โม จัตเจือ อิซราเอน ปอน ซนัก ลฆลอยจ เน่อึม รเวือง โอเอีฮ ฆาื อื ฮอยจ ละ ซเงะ เนาะ เฮี, นึง ลอก ยาโคป เจีจ พะจาว แตะ, ปุก ซนัก ลฆลอยจ เน่อึม รเวือง อื. ");
INSERT INTO lcp_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ฟวยจ เซ ยาโคป ชวน ซ ฮอยจ เอซาว เคะ แตะ ไม่ ปรเมะ ปาวน รอย ปุย. รฆุ กวน แตะ ฆาื อื เกือฮ อาวต ไม่ เลอา ไม่ ราเชน ไม่ กวนไจ รโปวน แตะ ลอา. ");
INSERT INTO lcp_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","เกือฮ กวนไจ แตะ ไม่ กวน อื โฮว รกา. เกือฮ เลอา ไม่ กวน อื โฮว ซน่ะ. เกือฮ ราเชน ไม่ โยเซป โฮว รเคะ. ");
INSERT INTO lcp_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","โกะ อื โอก โฮว กา โม เซ. เญือม ซ ฮอยจ อื โบ เอียกระ แตะ เซ, นุ่ม ติ แตะ ฮอยจ ลังเตะ อาแลฮ โฮน. ");
INSERT INTO lcp_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","เอซาว ตอ ฮอยจ เคะ อื. โอม เอิน อื. ฮงาึต อื. เยือม ดิ เตือง ลอา แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","เอซาว แก โม ปรโปวน เซ ไม่ กวน อื เตือง โอยจ อื. “โม ป ฮอยจ ไม่ เปอะ เฮี มัฮ ปุย?” อัฮ เซ. ยาโคป อัฮ เฮี, “โม เฮี มัฮ กวน เนอะ ป โพต พะจาว ละ กวนไจ ยุฮ เปอะ เบือ กุนมุ่น ยุฮ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","เญือม เซ กวนไจ รโปวน ยุฮ ยาโคป ฮอยจ ไม่ กวน แตะ นุ่ม ไว เอซาว. ");
INSERT INTO lcp_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","ฟวยจ เซ เลอา ฮอยจ โรฮ ไม่ กวน แตะ นุ่ม โรฮ ไว อื. ป ฮอยจ รเคะ นึง อื มัฮ ราเชน ไม่ โยเซป เญือะ อื, นุ่ม โรฮ ไว อื. ");
INSERT INTO lcp_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","เอซาว อัฮ เฮี, “คอง เลียง เปอะ โฮวน มู ป ยุ อาึ เนาะ ออ มัฮ ตอก เมอ?” อัฮ เซ. ยาโคป โลยฮ อื ตอก เฮี, “มัฮ เกือฮ ละ ปะ นึง มัฮ เปอะ จาวไน ยุฮ อาึ ละ ซ ปัว ปะ เลียก พาวม นึง แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","เอซาว อัฮ แม เฮี, “อาึ เอีจ กุม เอีจ ปอ โรฮ คาวคอง ยุฮ ฮุ, ไอฮ ปะ ไอฮ เมิฮ,” อัฮ เซ ละ ปุ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ยาโคป โลยฮ แม อื ตอก เฮี, “แปน โตว ตอก เซ. ดัฮ เปอะ เลียก พาวม นึง อาึ โฮ, ปัว เปอะ ไอฮ ป เกือฮ อาึ ละ เปอะ เฮี. เญือม ยุ อาึ นา ปะ ป มัฮ เอียกระ เกอะ, ไม่ ยุ อุ เปลีฮ เปอะ กุนมุ่น ยุฮ เปอะ เนิ อี, เมาะ เอิน โฮลฮ โฮะ ยุ นา พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ปัว เปอะ ไอฮ ป เกือฮ อาึ ละ เปอะ เฮี. พะจาว เอีจ เลียก พาวม เนอึม นึง อาึ. อาึ เอีจ กุมปอ โอเอีฮ ยุฮ ฮุ,” อัฮ เซ ยาโคป เปอ. เญือม เซ เอซาว ไอฮ เนอึม อื นึง ฆวต เกือฮ เนอึม ยาโคป อื ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","เอซาว อัฮ เฮี, “ซ ไมจ เอะ โฮว ยุ่ง. อาึ ซ โฮว ดิ ไม่ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ยาโคป อัฮ แม เฮี, “ปะ ป มัฮ จาวไน ยุฮ ฮุ ตึน ซ ยุง เปอะ ไอฮ แตวะ ลั่ง กวนดุ โม เฮี. คอง เลียง เงอะ เฮี โฮวน โรฮ ไม่ จัว ลั่ง กวน อื. ดัฮ โครฮ เกือฮ โฮว ไกลจ โฮ, ปัง มัฮ ติ ซเงะ โน่ง ตึน ซ ยุม เอิน ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ปัว ปะ ป มัฮ จาวไน ยุฮ แตะ โฮว รกา. อาึ ป มัฮ กวนไจ ยุฮ เปอะ ซ กวย โฮว รเคะ เปอะ. ซ โฮว ไน่ ไม่ ซัตซิง โม เฮี เมาะ ปุน อื. ซ ซไบ่ โรฮ ละ กวนดุ โม เฮี ฆาื อื. ซ ยุ แม ปุ แตะ นึง เมือง เซอี ย่วง อาวต เปอะ เซ,” อัฮ เซ ยาโคป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","“ดัฮ ตอก เซ อาึ ซ เกือฮ ลุกจัง แตะ โฮว ไม่ เปอะ ง่อน,” อัฮ เซ เอซาว. ยาโคป อัฮ เฮี, “จัมเปน เปอะ โตว เกือฮ โฮว ไม่ เยอะ. ดัฮ เปอะ เอีจ เลียก พาวม นึง เงอะ เอีจ ปอ เนิ เมาะ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ซเงะ เซ เอซาว เอีญ ฮอยจ นึง เมือง แตะ เมือง เซอี. ");
INSERT INTO lcp_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ยาโคป ฮอยจ นาตี ย่วง ซุกโคต. ยุฮ เญือะ แตะ นา เซ. ยุฮ โรฮ คอก ละ คอง เลียง แตะ. มัฮ เซ ป อัฮ ปุย ย่วง ซุกโคต ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ฟวยจ เอีญ อื ฮา เมือง ปัตดั่น อารัม, ยาโคป ฮอยจ ไมจ ฮอยจ มวน โบ ย่วง เชเคม เมือง คะนาอัน. กัง พากัง ยุฮ แตะ โบ ย่วง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","รวี เตะ ติ เบือง นึง กวน เฌือต ฮาโม ป มัฮ เปือะ เชเคม. รวี อื นึง มาื นัมนัก เมาะ ติ รอย แทป. มัฮ นา เซ นา ก กัง อื พากัง ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ยุฮ คัน ทไว นา เซ. อัฮ “คัน พะจาว ป มัฮ พะจาว ทื อิซราเอน” ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ดี่นา ป มัฮ กวน เครีฮ ยาโคป ไม่ เลอา เซ โฮว เลีม เคะ โม ปรโปวน ย่วง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","เชเคม กวน ฮาโม ป มัฮ โม ฮีไว มัฮ โรฮ จาวไน ตัตเตียง เมือง เซ. เญือม ยุ อื ดี่นา เซ โฮมวต อื ไอฮ พาวม ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","เชเคม เซ ปุก ดี่นา รพาวม อื. ฮรัก อื. อัฮ ป ไมจ ป มวน ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","เชเคม เซ อัฮ เฮี ละ ฮาโม ป มัฮ เปือะ แตะ เซ, “เปือะ, โฮว ปัว ปรโปวน เซ ละ อาึ. ฆวต ไอฮ แฮะ แปน ปุย เญือะ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","เญือม ฮมอง ยาโคป ไลลวง ยุฮ ปุย โอเอีฮ ไอฮ พาวม แตะ ละ กวน แตะ ตอก เซ, ปุก เญือม อาวต กวน รเมะ อื เพระด่าวก ไม่ คอง เลียง แตะ. ดิ อัฮ โตว โอเอีฮ ฆาื อื กา เฆียง เอีญ กวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","เญือม เซ ฮาโม ป มัฮ เปือะ เชเคม โฮว อู ไม่ ยาโคป. ");
INSERT INTO lcp_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","กวน ยาโคป เญือม ฮมอง อื ไลลวง ป เกิต เซ, เอีญ ฆาื อื เน่อึม เพระด่าวก. ฮาวก รพาวม เนอึม ฮาวก รพาวม แนม ฆาื อื. พิต ลัมเลือ ละ อื ป ยุฮ เชเคม เซ. เมีญ อื มัฮ กัน ดู่ ทุก ดู่แควน อื โม อิซราเอน นึง ยุฮ อื กัน ไอฮ พาวม แตะ ไม่ ดี่นา ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ฮาโม อัฮ เฮี ละ เญือะ ยาโคป เซ, “เชเคม กวน อาึ อัฮ ติ แตะ ฮรัก กวน รโปวน เปอะ. ปัว เปอะ เกือฮ เอีญ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ไมจ เอะ โตกโลง ไม่ ปุ แตะ ละ ซ โฮลฮ โม กวนดุ เฮี เญือะ เอีญ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","เญือม เซ โม เปะ ซ โฮลฮ เปอะ อาวต เมือง เอะ เฮี, เตอึม ลั่ก ฆวต อาวต เปอะ นึง. ซ โฮลฮ เปอะ กาไค นึง. ซาวป รวี พริ เตะ เบระ เบรอึม เปอะ นึง,” อัฮ เซ ฮาโม. ");
INSERT INTO lcp_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","12","เชเคม อัฮ เฮี ละ เปือะ ดี่นา ไม่ โม เพร อื, “ปัว เปอะ เกือฮ กวน รนัน เปอะ เซ เนิ. ซ อัฮ เปอะ เนิ เมาะ เมอ งวยฮ อื, เตอึม เมาะ อัฮ เปอะ เนิ, ซ ปุน เกือฮ ละ เปอะ. เมือน เตอ โฮลฮ แนฮ ปเครีฮ เซ แปน ปุย เญือะ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","กวน ยาโคป เปอ จุ ฮาโม ไม่ เชเคม, นึง ยุฮ อื ป พังไฮะ ละ ดี่นา รนัน แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","อัฮ เฮี ละ อื, “เอะ เกียฮ ยุฮ โตว ตอก เซ. แปน โตว เกือฮ รนัน แตะ เอีญ ละ ปรเมะ โอ ดิ เลียก นึง ริตกิต เตอ. ซ แปน ป ตวยฮ ละ เอะ. ");
INSERT INTO lcp_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ไก ติ เจือ ป ฆวต เกือฮ โม เปะ ยุฮ ฮู. ดัฮ โม เปะ ซ ญอม เลียก นึง ริตกิต ตอก เลียก โม เอะ โฮ, เอะ ซ ญอม ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","เญือม เซ เอะ ซ ปุน เกือฮ กวน รโปวน แตะ เอีญ ละ โม เปะ. เอะ ซ ไอฮ โรฮ กวน รโปวน โม เปะ เซ แปน ปุย เญือะ แตะ. เอะ ซ อาวต ดิ ไม่ โม เปะ. ซ แปน เมือง ติ ไม่ เปอะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ดัฮ เปอะ โอ ญอม เลียก นึง ริตกิต โฮ, เอะ ซ ตุย โรวก รนัน แตะ เฮี ฮา เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ป อัฮ ป มวยญ โม เซ ปุก รพาวม ฮาโม ไม่ เชเคม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","เชเคม เซ มัฮ ป ระ มอยฮ ฮา ปุย ไฮญ นึง ย่วง เซ. มอง โตว อื เฟือฮ, นึง ปุก ลัมเลือ กวน รโปวน ยาโคป เซ รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","โฮว ดิ ไม่ เปือะ แตะ ฮอยจ นึง โตะ รเวือะ ย่วง, ละ ซ อู แตะ ไม่ ปุ ย่วง แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","อัฮ เฮี, “โม เฮี ฆวต แปน ปุโฮมว เอะ. ไมจ เอะ เกือฮ อาวต เมือง แตะ. เกือฮ กาไค นึง อื. เมือง เอะ เฮี เอีจ เวือฮ โรฮ ปอ เกียฮ อาวต อื. เอะ ซ โฮลฮ ไอฮ กวน รโปวน โม เซ. โม เซ ซ โฮลฮ โรฮ ไอฮ กวน รโปวน โม เอะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ดัฮ เอะ ญอม ยุฮ ตัม ป ฆวต เกือฮ อื เอะ ยุฮ ติ เจือ เฮี โน่ง, โม เซ ซ ญอม อาวต ไม่ เอะ. ซ แปน เมือง ติ ไม่ เยอะ. ป ฆวต เกือฮ อื เอะ ยุฮ เซ มัฮ เกือฮ อื เอะ เลียก นึง ริต ตอก โม โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ดัฮ เอะ ญอม ยุฮ ตัม ป อัฮ อื เซ, คาวคอง ยุฮ อื เตือง ซัตซิง เลียง อื เซ, เอะ โม่ ซ โฮลฮ โอยจ? ไมจ เอะ ญอม ละ เดอึม ซ ญอม อาวต ไม่ เอะ,” อัฮ เซ ละ ปุ ย่วง แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ปรเมะ เตือง โอยจ อื ป โพรม ดิ นึง โตะ รเวือะ ย่วง เซ ปุก ตื รพาวม อื. ฆวต ยุฮ อื ตัม ป อัฮ เชเคม ไม่ ฮาโม ป มัฮ เปือะ อื เซ. ปรเมะ ย่วง เซ แปน เนอึม เลียก นึง ริตกิต เตือง โอยจ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ฟวยจ เซ ลอวย ซเงะ เอ เญือม อาวต ลั่ง ปุย โม เซ ไม่ โซะ แตะ, กวน ยาโคป ลอา ปุย ป มัฮ เพร ดี่นา เซ ตุย วิจ ยุฮ แตะ. บระ เลียก มอก ปรเมะ ย่วง เซ โครยญ โฆะ อื. มอยฮ ปุย ลอา เซ มัฮ ซิเมโอน ไม่ เลวี. ");
INSERT INTO lcp_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","ยุฮ ยุม ไม่ ฮาโม ไม่ เชเคม. ตุย โรวก ดี่นา โอก ฮา เญือะ อื โฮว ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","กวน ยาโคป เลียก เญือะ ป ยุม เซ, ตุย โอยจ คาวคอง อื ฆาื ยุฮ ปุย ย่วง เซ ป พังไฮะ ละ รนัน อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","ลู ตุย คอง เลียง ย่วง เซ ไม่ อื แกล, เตือง แกะ ปิ ไม่ บรัง โอเอีฮ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","โรวก คาวคอง ย่วง เซ ไม่ โม ปรโปวน ย่วง อื ไม่ กวน อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","เญือม เซ ยาโคป อัฮ เฮี ละ ซิเมโอน ไม่ เลวี, “โม เปะ ซ เกือฮ เนอึม เปอะ อาึ ลอก ป ญัก ลัมเลือ เอิน. โม คะนาอัน ไม่ โม เปริซี เฮี ซ ลอต เกละยุ อาึ ฆาื ป ยุฮ โม เปะ เฮี. เอะ มัฮ ปุย รมัฮ. ดัฮ โม เซ พาวม ดิ ละ ซ ตอซู แตะ ไม่ เอะ, เอะ ตึน ซ ยุม โอยจ เตือง เญือะ เตือง ม่า แตะ ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","ปุย ลอา เซ อัฮ เฮี, “โม เซ เอีจ ยุฮ อื ละ รนัน เอะ ตอก ยุฮ ปุย อื ละ มอจังคึต โฮ. เอะ อัม ซ เกียฮ เกือฮ ลั่ง ติ แตะ ญอม ละ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ฟวยจ เซ พะจาว อัฮ เฮี ละ ยาโคป, “เอีญ อาวต นึง ย่วง เบ่ตเอน เนอ, อาึ มัฮ พะจาว ป เปลีฮ ติ แตะ ละ เปอะ นา เซ เญือม ตอ เปอะ ฮา เอียกระ แตะ ไพรม อื โฮ. ไมจ เปอะ ยุฮ คัน ละ อาึ นา เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ยาโคป อัฮ เฮี ฆาื อื ละ เญือะ โกะ แตะ ไม่ โม ป โฮว ไม่ แตะ เซ, “โปวฮ แปฮ ฮุป พะจาว ตังเมือง ป ไก ไม่ เปอะ เซ. เกือฮ ติ เปอะ ซง่ะ ซงอม. จาวป เครอึง ซง่ะ อา. ");
INSERT INTO lcp_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","เอะ ซ โอก ฮา นา เฮี เอีญ ฮอยจ นึง ย่วง เบ่ตเอน. ซ ยุฮ คัน ละ พะจาว นา เซ, นึง เอีจ เรอึม อื อาึ เญือม อาวต อาึ ไม่ เม่ะมั่ก แตะ. เอีจ อาวต โรฮ ไม่ อาึ โครยญ คระ โฮว โครง เอีญ เญอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","โม เซ เกือฮ ฮุป พะจาว ยุฮ ปุย ตังเมือง ป ไก ไม่ แตะ ละ ยาโคป ฆาื อื. เกือฮ โรฮ อื ไม่ ตอฮู บาื แตะ เตือง โอยจ อื. ยาโคป รปาึง อื ฆรึม โคะ ไฆรจ ป ไก ซดิ ไม่ ย่วง เชเคม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","เญือม ซ โอก ยาโคป ไม่ กวน อื ฮา นา เซ, ปุย ย่วง ซดิ ไม่ อื เซ ฮลัต เนอึม ฮลัต แนม นึง เกือฮ พะจาว อื ฮลัต. ไก โตว ป โรวต อาื ยาโคป ติ ปุย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","เญือะ ยาโคป ฮอยจ นึง ย่วง ลุต ป อัฮ ปุย ย่วง เบ่ตเอน ไม่ เซ, ย่วง เซ ไก นึง เมือง คะนาอัน. ");
INSERT INTO lcp_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","ยุฮ เนอึม คัน นา เซ. อัฮ เอน เบ่ตเอน ไม่ นา เซ. มัฮ อัฮ อื เซ นึง มัฮ อื นา ก เปลีฮ พะจาว ติ แตะ ละ อื เญือม ตอ อื ฮา เอียกระ แตะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","เด่โบ่รา ป มัฮ กวนไจ เรเบ่คา ยุม นา เซ. รปาึง ปุย ฆรึม โคะ ไฆรจ ลั่กเซฮ เบ่ตเอน เซ. โคะ เซ ลอต ปุย อัฮ โคะ ไฆรจ เยือม ไม่ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ฟวยจ เอีญ ยาโคป ฮา เมือง ปัตดั่น อารัม เซ, พะจาว เปลีฮ แม ติ แตะ ละ อื. ปิฮ มุ่น ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","พะจาว อัฮ เฮี, “ปะ มัฮ ยาโคป มอยฮ เปอะ. เฆิม เฮี โฮว ไป นา เยอ, ปุย เญือะ ซ อัฮ โตว ยาโคป ละ เปอะ. ซ อัฮ อิซราเอน ละ เปอะ,” อัฮ เซ ละ อื. มัฮ พะจาว ป เกือฮ มอยฮ อิซราเอน ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","พะจาว อัฮ แม เฮี ละ อื, “อาึ มัฮ พะจาว ป ตึก นึง ระ อัมนัต แตะ. อาึ ซ เกือฮ จัตเจือ เปอะ พรุฮแพร โฮวน. ซ ไก โฮวน เมือง ป เกิต เน่อึม นึง เปอะ. โม กซัต ซ เกิต โรฮ นึง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","เมือง เกือฮ อาึ ละ อัปราฮัม ไม่ ยิซฮัก, อาึ ซ เกือฮ โรฮ ละ ปะ ฮอยจ ละ จัตเจือ เปอะ เฆียง เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ฟวยจ เซ พะจาว โฮว ฮา อื. ");
INSERT INTO lcp_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ยาโคป ลบุ่ฮ ซโมะ นา เซ นึง ฮมอง อื ลปุง พะจาว ไม่ แตะ. เรฮ รอาวม อะงุน นึง อื ไม่ ลออยฮ. เกือฮ อื แปน ป ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","อัฮ เบ่ตเอน ไม่ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","เญือะ ยาโคป โอก โฮว ฮา เบ่ตเอน. ลไล โฮว อื นึง คระ กา ฮอยจ อื ย่วง เอฟราทา เซ, ราเชน โซะ เติง เคิ รอาวม. โซะ เนอึม ป อาวม นึง นอ กวน อื. ");
INSERT INTO lcp_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","เญือม ตึก อื นึง โซะ ป อาวม แตะ เซ, มะ ป โกวน ป โซวต กวนงัก เซ อัฮ เฮี ละ อื, “ตุย รพาวม เรียง เปอะ. ซ โฮลฮ แม เปอะ กวน รเมะ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","เญือม เอีจ ซ โอยจ รพาวม อื ราเชน ปุก มอยฮ กวน แตะ. อัฮ เบ่นโอนี ละ กวน แตะ เซ. ฟวยจ เซ ลอต ยุม. ยาโคป ปังเมอ อัฮ เบ่นยามิน ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ฟวยจ ยุม อื ปุย รมอยจ อื เฆียง คระ โฮว ปุย นึง ย่วง เอฟราทา. ปเลี่ย ปุย อัฮ เบ่ตเลเฮม ไม่ ย่วง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ยาโคป ลบุ่ฮ ซโมะ ติ, โบลวง อื นึง เบือง รมอยจ ราเชน เซ. ซโมะ เซ อาวต นา เซ ฮอยจ ปเลี่ย. ");
INSERT INTO lcp_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","ฟวยจ เซ อิซราเอน โฮว แม ฮอยจ โปน เญือะ มอง ญัม ป อัฮ ปุย เอเด่อ ไม่. กัง พากัง ยุฮ แตะ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","เญือม อาวต อิซราเอน นา เซ, รูเบ่น ไอฮ พาวม ไม่ ปรโปวน แตวะ เญือะ เปือะ แตะ ป มัฮ บิ่นฮา เซ. อิซราเอน ฮมอง โรฮ คราว อื. ");
INSERT INTO lcp_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","ยาโคป ไก กวน รเมะ กาว ลอา. กวน อื ไม่ เลอา นึง อื มัฮ รูเบ่น มัฮ กวน โรง อื. ฟวยจ เซ มัฮ ซิเมโอน, เลวี, ยูด่า, อิตซคา, ไม่ เซบู่ลุน. ");
INSERT INTO lcp_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","กวน อื ไม่ ราเชน มัฮ โยเซป ไม่ เบ่นยามิน. ");
INSERT INTO lcp_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","กวน อื ไม่ กวนไจ ราเชน ป มัฮ บิ่นฮา เซ มัฮ ด่าน ไม่ นัปทาลี. ");
INSERT INTO lcp_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","กวน อื ไม่ กวนไจ เลอา ป มัฮ ซีละปา เซ มัฮ กาต ไม่ อาเชอ. โม เซ มัฮ กวน ยาโคป ป เกิต นึง เมือง ปัตดั่น อารัม. ");
INSERT INTO lcp_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ยาโคป เอีญ ฮอยจ เคะ ยิซฮัก เปือะ แตะ นึง ย่วง มัมเร ซดิ ไม่ เมือง เฮปโรน. มัฮ นา ก อาวต อัปราฮัม ไพรม อื. ยิซฮัก อาวต โรฮ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ยิซฮัก ไอม ฮอยจ ละ ไก อาญุ แตะ ติ รอย ไปล รเตะ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","มัฮ เนอึม ปุย ลั่ง ไอม. ยุม เญือม เอีจ กวต เนอึม แตะ. โฮลฮ โฮว รโจะ ไม่ จัตเจือ ไพรม แตะ. เอซาว ไม่ ยาโคป ป มัฮ กวน อื รมอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ไลลวง เฮี มัฮ ไลลวง จัตเจือ เอซาว. (เอซาว ไม่ เอโด่ม เอีจ มัฮ ติ.) ");
INSERT INTO lcp_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","เอซาว ไอฮ โม ปรโปวน เมือง คะนาอัน แปน ปุย เญือะ แตะ. ติ ปุย อื มัฮ อาด่า. มัฮ กวน เอโลน ป มัฮ โม ฮิตไท. ติ ปุย อื มัฮ โอโฮลีบ่ามา. มัฮ กวน อานา. อานา เซ มัฮ กวน ซิเบ่โอน ป มัฮ โม ฮีไว. ");
INSERT INTO lcp_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ไอฮ โรฮ บ่าเซมัต ป มัฮ กวน อิชมาเอน. ปรโปวน เซ มัฮ รนัน เนบ่าโยต. ");
INSERT INTO lcp_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","อาด่า เซ ไก กวน รเมะ ไม่ เอซาว ติ. มอยฮ อื มัฮ เอลีฟัต. บ่าเซมัต เซ ไก โรฮ กวน. มอยฮ อื มัฮ เรอูเอน. ");
INSERT INTO lcp_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","กวน โอโฮลีบ่ามา เซ มัฮ เยอุต, ยาลัม, ไม่ โครา. โม กวน รเมะ เอซาว เซ มัฮ ตื ป เกิต นึง เมือง คะนาอัน เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ฟวยจ เซ เอซาว โรวก ปรโปวน เญือะ แตะ ไม่ กวน รเมะ กวน รโปวน แตะ, ไม่ กวนไจ แตะ, ไม่ คอง เลียง แตะ, ไม่ คาวคอง ไฮญ ยุฮ แตะ ป โฮลฮ แตะ นึง เมือง คะนาอัน เซ, รกัฮ ติ แตะ ฮา ยาโคป. โฮว อาวต เมือง ซไง ฮา ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","มัฮ ยุฮ อื ตอก เซ นึง โฮวน คอง เลียง คอง ดู่ อื เตือง ลอา แตะ. เมือง ไพรม อาวต อื เซ ปอ โตว ไรป ละ ซ เปือม คอง เลียง อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","เอซาว โฮว อาวต ฆาื อื เมือง เซอี นา ก โฮวน บลาวง โฮวน ฌื. (เอซาว ไม่ เอโด่ม เอีจ มัฮ ติ.) ");
INSERT INTO lcp_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ไลลวง เฮี มัฮ ไลลวง จัตเจือ เอซาว ป มัฮ จัตเจือ ไพรม โม เอโด่ม ป อาวต นึง บลาวง เมือง เซอี โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","มอยฮ กวน รเมะ เอซาว มัฮ ตอก เฮี. มัฮ เอลีฟัต กวน อาด่า ป มัฮ ปรโปวน เญือะ เอซาว เซ. ฟวยจ เซ มัฮ เรอูเอน ป มัฮ กวน บ่าเซมัต ป มัฮ ปรโปวน แตวะ เญือะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","กวน รเมะ เอลีฟัต เซ มัฮ เทมัน, โอมา, เซโฟ, กาทัม, ไม่ เคนัต. ");
INSERT INTO lcp_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ปรโปวน แตวะ เญือะ เอลีฟัต เซ ติ ปุย อื มอยฮ ทิมนา. ไก โรฮ กวน รเมะ ติ, มอยฮ อามาเลก. โม เซ มัฮ กวนโซะ อาด่า ป มัฮ ปรโปวน ระ เญือะ เอซาว เซ. ");
INSERT INTO lcp_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","กวน รเมะ เรอูเอน เซ มัฮ นาฮัต, เซรา, ชัมมา, ไม่ มิตซา. โม เซ มัฮ กวนโซะ บ่าเซมัต ป มัฮ ปรโปวน แตวะ เญือะ เอซาว เซ. ");
INSERT INTO lcp_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ปุย โม เฮี มัฮ กวน รเมะ โอโฮลีบ่ามา ป มัฮ ปรโปวน แตวะ เญือะ เอซาว. มัฮ เยอุต, ยาลัม, ไม่ โครา. โอโฮลีบ่ามา เซ มัฮ กวน อานา. อานา เซ มัฮ กวน ซิเบ่โอน. ");
INSERT INTO lcp_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ปุย โม เฮี มัฮ โม จาวไน ลลาึง จัตเจือ เอซาว. ป มัฮ กวน รเมะ เอลีฟัต กวน โรง เอซาว เซ มัฮ จาวไน เทมัน, โอมา, เซโฟ, เคนัต, ");
INSERT INTO lcp_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","โครา, กาทัม, ไม่ อามาเลก. ปุย โม เซ โฮลฮ ตื แปน จาวไน ไน จัตเจือ เอลีฟัต นึง เมือง เอโด่ม. มัฮ กวนโซะ อาด่า นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","เรอูเอน ป มัฮ กวน เอซาว เซ ไก โรฮ กวน รเมะ, มัฮ จาวไน นาฮัต, เซรา, ชัมมา, ไม่ มิตซา. ปุย โม เซ โฮลฮ ตื แปน จาวไน ไน จัตเจือ เรอูเอน นึง เมือง เอโด่ม. มัฮ กวนโซะ บ่าเซมัต นึง อื. บ่าเซมัต เซ มัฮ ปรโปวน แตวะ เญือะ เอซาว. ");
INSERT INTO lcp_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","ป มัฮ กวน โอโฮลีบ่ามา เซ มัฮ จาวไน เยอุต, ยาลัม, ไม่ โครา. จาวไน โม เซ มัฮ จัตเจือ โอโฮลีบ่ามา ป มัฮ กวน อานา. โอโฮลีบ่ามา เซ มัฮ โรฮ ปรโปวน แตวะ เญือะ เอซาว. ");
INSERT INTO lcp_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ปุย โม เซ มัฮ จัตเจือ เอซาว (เอซาว ไม่ เอโด่ม เอีจ มัฮ ติ.) โฮลฮ ตื แปน จาวไน. ");
INSERT INTO lcp_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ไลลวง เฮี มัฮ มอยฮ ปรเมะ ป มัฮ จัตเจือ เซอี ป มัฮ โม โฮรี. มัฮ ป ตึน อาวต ไพรม นึง เมือง เซ. มัฮ โลทัน, โชบั่น, ซิเบ่โอน, อานา, ");
INSERT INTO lcp_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ดี่โชน, เอเซอ, ไม่ ดี่ชัน. โม เซ มัฮ ตื จาวไน นึง เมือง เอโด่ม. มัฮ จัตเจือ เซอี ป มัฮ โม โฮรี. ");
INSERT INTO lcp_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","กวน รเมะ โลทัน เซ มัฮ โฮรี ไม่ เฮมัน. รนัน โลทัน เซ มัฮ ทิมนา. ");
INSERT INTO lcp_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","กวน รเมะ โชบั่น เซ มัฮ อันวัน, มานาฮัต, เอบั่น, เชโฟ, ไม่ โอนัม. ");
INSERT INTO lcp_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","กวน รเมะ ซิเบ่โอน เซ มัฮ ไอยา ไม่ อานา. เอีจ มัฮ อานา เซ ป รโตฮ ยุ รอาวม โปวง ลลอก นึง ลาึน ติ โดฮ เญือม เลียง อื บรัง ยุฮ เปือะ แตะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","กวน รเมะ อานา เซ มัฮ ดี่โชน. โอโฮลีบ่ามา มัฮ กวน รโปวน อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","กวน ดี่โชน เซ มัฮ เฮมดั่น, เอชบั่น, อิตรัน, ไม่ เครัน. ");
INSERT INTO lcp_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","กวน รเมะ เอเซอ เซ มัฮ บิ่นฮัน, ซาวัน, ไม่ อาคัน. ");
INSERT INTO lcp_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","กวน รเมะ ดี่ชัน เซ มัฮ อุต ไม่ อารัน. ");
INSERT INTO lcp_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","ปุย โม เฮี มัฮ โม จาวไน ลลาึง โม โฮรี ป อาวต เมือง เซอี. อาวต ตัม เจือ แตะ ไอฮ. มัฮ จาวไน โลทัน, โชบั่น, ซิเบ่โอน, อานา, ดี่โชน, เอเซอ, ไม่ ดี่ชัน. โฮลฮ แปน จาวไน เตือง โอยจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","เฮี มัฮ มอยฮ โม กซัต ป ตัตเตียง เมือง เอโด่ม กา ไก กซัต ตัตเตียง เมือง อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","เบ่ลา ป มัฮ กวน เบ่โอ โฮลฮ แปน กซัต ตัตเตียง เมือง เอโด่ม กา ปุย. ย่วง อาวต อื มัฮ ย่วง ดิ่นฮาบ่า. ");
INSERT INTO lcp_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ฟวยจ ยุม เบ่ลา เซ มัฮ โยบั่ป ป มัฮ กวน เซรา ป อาวต ย่วง โบ่ซรา ป แปน กซัต ฆรอ อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ฟวยจ ยุม โยบั่ป เซ มัฮ ฮุชัม ป ฮอยจ เน่อึม นึง เมือง เทมัน ป แปน กซัต ฆรอ อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ฟวยจ ยุม ฮุชัม เซ มัฮ ฮาดั่ต ป มัฮ กวน เบ่ดั่ต ป แปน กซัต ฆรอ อื. ฮาดั่ต เซ มัฮ ป เอีจ เป โม มีเดี่ยน นึง เมือง โมอัป ไพรม อื. ย่วง อาวต อื มัฮ ย่วง อาวิต. ");
INSERT INTO lcp_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ฟวยจ ยุม ฮาดั่ต เซ มัฮ ซัมลา ป อาวต เมือง มัตชาเรคา ป แปน กซัต ฆรอ อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ฟวยจ ยุม ซัมลา เซ, มัฮ ชาอุน ป ฮอยจ เน่อึม นึง ย่วง เรโฮโบ่ต โบ โกลง ยูฟะเรตี ป แปน กซัต ฆรอ อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ฟวยจ ยุม ชาอุน เซ มัฮ บ่าอันฮานัน ป มัฮ กวน อักโบ่ ป แปน กซัต ฆรอ อื. ");
INSERT INTO lcp_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","ฟวยจ ยุม บ่าอันฮานัน เซ มัฮ ฮาด่า ป แปน กซัต ฆรอ อื. ย่วง ฮาด่า เซ มัฮ ย่วง ปาอู. ปรโปวน เญือะ อื มัฮ เมเฮทาเบ่น ป มัฮ กวน มัตเรต. มัตเรต เซ มัฮ กวน รโปวน เมซาฮัป. ");
INSERT INTO lcp_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ปุย โม เฮี มัฮ โม จาวไน ป ซึป เจือ แตะ เน่อึม นึง เอซาว, ตัม นาตี อาวต อื ตัม จัตเจือ แตะ ไอฮ. มัฮ จาวไน ทิมนา, อันวา, เยเทต, ");
INSERT INTO lcp_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","โอโฮลีบ่ามา, เอลา, ปีโนน, ");
INSERT INTO lcp_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","เคนัต, เทมัน, มิปซา, ");
INSERT INTO lcp_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","มักดี่เอน, ไม่ อิรัม. ปุย โม เซ โฮลฮ ตื แปน จาวไน เมือง เอโด่ม. อาวต ตัม นาตี ก อาวต แตะ เตือง ไพ เตือง มัน. (เอซาว มัฮ จัตเจือ ไพรม โม เอโด่ม.) ");
INSERT INTO lcp_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ยาโคป อาวต แนฮ นึง เมือง คะนาอัน, ป มัฮ เมือง อาวต เปือะ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ไลลวง เญือะ ยาโคป มัฮ ตอก เฮี. โยเซป เญือม ไก อาญุ อื กาว โรฮ อาแลฮ เนอึม เมอ, เลียง ดิ แกะ ไม่ โม เอียกปุ แตะ ป มัฮ กวน บิ่นฮา ไม่ ซีละปา, ปรโปวน แตวะ เญือะ เปือะ แตะ เซ. กอ เอีญ อู ไลลวง กัน ฆอก ป ยุฮ โม เอียกปุ แตะ เซ ละ เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","ป มัฮ ยาโคป ฮรัก โยเซป ฮา กวน ไฮญ แตะ นึง เกิต อื เญือม เอีจ กวต แตะ. ยุฮ ลปิ ลั่ง เตะ ดา ละ โยเซป. ");
INSERT INTO lcp_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","โม เอียกปุ อื เญือม ยุ อื ฮรัก เปือะ แตะ โยเซป ตอก เซ, เกละยุ โยเซป ฆาื อื. เญือะ ญอม โตว ลปุง ไมจ ไม่ อื เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","ติ ซาวม อื โยเซป รโมะ. ฟวยจ เซ รไปฮ รโมะ แตะ เซ ละ โม เอียกปุ แตะ ตอก เฮี, “ง่อต แลน ป รโมะ อาึ ยุ เฮี เมอะ. อาึ รโมะ ยุ มัก แตะ เฮงาะ ไม่ โม เปะ. โรม แปน โรม แปน โรม แตะ. เฮงาะ โรม อาึ นึง อื, รโมะ ยุ ชุง พราวป อื. เฮงาะ โรม โม เปะ เอ ฮอยจ รโจะ ไอฮ ติ แตะ นา เซ, นุ่ม ไว เฮงาะ โรม อาึ ติ โรม เซ เตือง โอยจ อื,” อัฮ เซ ละ อื. เญือม รไปฮ โยเซป รโมะ แตะ ละ อื ตอก เซ, โม เอียกปุ อื โฮว ละ เกละ แตะ ยุ โยเซป ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","โม เอียกปุ อื เซ อัฮ เฮี, “ปะ อัม มัฮ อัฮ เปอะ ติ แตะ ซ โฮลฮ ตัตเตียง เอะ ตอก กซัต โฮ?” อัฮ เซ ละ อื. เญือม อู โยเซป ไลลวง รโมะ แตะ เซ, โม เอียกปุ อื เซ โฮว ละ เกละ แตะ ยุ โยเซป ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ฟวยจ เซ โยเซป รโมะ แม ติ โฮน. อู แม โรฮ อื ละ โม เอียกระ เอียกตุ แตะ. อัฮ เฮี ละ อื, “ง่อต เมอะ, อาึ เอีจ รโมะ แม ติ โฮน. อาึ รโมะ ยุ ซเงะ ไม่ เคิ ไม่ ซโมยญ กาว โรฮ ติ โนง, ฮอยจ นุ่ม ไว อาึ เตือง โอยจ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","เญือม รไปฮ อื ละ เปือะ แตะ, เปือะ อื ริ คัต อื. “มัฮ ตอก เมอ ตอก โอวน รโมะ เปอะ เซ? อาึ ไม่ มะ เปอะ ไม่ เอียกระ เอียกตุ เปอะ อัม มัฮ ซ โฮลฮ นุ่ม ไว ปะ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","โม เอียกปุ อื เซ วัว ป อัฮ โยเซป เซ รพาวม อื. เปือะ อื ปังเมอ ไตม อาึง ไล เซ โตะ รพาวม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ติ โฮน อื โม เอียกระ เอียกตุ โยเซป เซ โฮว เลียง แกะ ยุฮ เปือะ แตะ โบ ย่วง เชเคม. ");
INSERT INTO lcp_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","อิซราเอน อัฮ เฮี ละ โยเซป, “โม เอียกระ เอียกตุ เปอะ โฮว เลียง แกะ นึง นาตี ย่วง เชเคม. อาึ ฆวต เกือฮ ปะ โฮว เคะ อื นา เซ โอะ,” อัฮ เซ. “เออะ,” อัฮ เซ ละ อื โยเซป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","เปือะ อื อัฮ แม เฮี ละ อื, “โฮว โพก แลน โม เอียกระ เอียกตุ เปอะ. อัม อาวต ตื ไม่ กอ บาึง แตะ เตือง แกะ แลน อื เซ? ฟวยจ เซ เอีญ อู ละ อาึ,” อัฮ เซ ละ อื. เญือม ดวน อื โยเซป โฮว ตอก เซ, ปุก เญือม อาวต อื นึง ลโลวง เฮปโรน. โยเซป โฮว เนอึม ฆาื อื ฮอยจ ย่วง เชเคม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ไก ปรเมะ ติ, รโตฮ ยุ โฮว ไป โฮว มา โยเซป โตะ ลโลวง เซ. ปรเมะ เซ ไฮมญ อื, “เมอ ซาวป เปอะ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","โยเซป โลยฮ อื ตอก เฮี, “โฮว ซาวป โม เอียกปุ แตะ. โม เปะ อัม ยุ เปอะ นา ก เลียง อื แกะ ยุฮ แตะ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ปุย เซ อัฮ เฮี, “เอีจ โฮว ฮา นา เฮี. อาึ ฮมอง อู อื ลอก ซ โฮว แตะ ย่วง โด่ทัน,” อัฮ เซ ละ อื. โยเซป โฮว ซาวป เนอึม โม เอียกปุ แตะ ลั่ก ย่วง โด่ทัน. ยุ เนอึม อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","โม เซ ชวน โยเซป เญือม อาวต ลั่ง อื ก ซไง อื. ง่อต ดิ ตอก ซ ยุฮ แตะ ยุม ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","อัฮ เฮี ละ ปุ แตะ, “ตึต แตะ. ปุย กอ รโมะ ลัมเลือ โฮ เอีจ ฮอยจ. ");
INSERT INTO lcp_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ไมจ เอะ เรอึม ปุ แตะ. ยุฮ แปฮ ยุม ไม่. น่าึก โปวฮ โตะ นัมโม่ ซออฮ ติ โดฮ. ฟวยจ เซ ซ อัฮ มัฮ ยุม อื นึง เกียต โกะพริ แตะ. มอง แลน ป ซ เกิต นึง รโมะ รมาว อื เซ,” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","เญือม ฮมอง รูเบ่น ป อัฮ อื เซ, ง่อต ตอก ซ เกือฮ แตะ โยเซป โปน ฮา กัน ฆอก ตะ ปุย ยุฮ ละ อื เซ. อัฮ เฮี ฆาื อื, “ไมจ โตว เอะ ยุฮ ยุม ไม่. ");
INSERT INTO lcp_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","โฮมวต คัง ฮา อื โตะ นัมโม่ ซออฮ เฮี, ปังเมอ โอ เยอะ ไมจ ยุฮ ป โซะ ละ เนะซอัง อื,” อัฮ เซ. ป อัฮ อื ตอก เซ ฆาื อื มัฮ ตะ อื เรอึม เกือฮ โอก. ตะ ตาว แม อื ละ เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","เญือม ฮอยจ โยเซป นา ก อาวต โม เอียกปุ แตะ เซ, โม เซ โฮมวต ปอยจ ลปิ ดา ไมจ อื เซ, บั่ว โรวก โกะ อื ดุฮ อื โตะ นัมโม่ ซออฮ. ");
INSERT INTO lcp_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ฟวยจ เซ โม เซ งาวม โซม. ลไล โซม อื เซ ชวน ฮอยจ โม อิชมาเอน ติ มู ฮอยจ ไม่ อุต ยุฮ แตะ. ตัง โรวก ป ซออย ฮงาื ไม่ เยื่อ ปุยฮ โคะ ไม่ เฮลาะ โคะ ชะโมต ละ ซ โฮว โชะ แตะ. โอก โฮว เน่อึม นึง เมือง กิเลอัต ละ ซ โฮว แตะ ฮอยจ เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ยูด่า อัฮ เฮี ละ เอียกปุ แตะ, “ดัฮ ยุฮ ยุม ไม่ ปุ แตะ เฮี ไม่ เม่าะ แตะ, เมอ ป ซ โฮลฮ เอะ นึง อื? ");
INSERT INTO lcp_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ฮา ซ ยุฮ แตะ ป โซะ ละ อื โชะ ฮา อื ละ โม อิชมาเอน เฮี และ. ดัฮ ง่อต ที โฮ มัฮ โรฮ ปุ อุ. มัฮ กวน ติ เปือะ ไม่,” อัฮ เซ. โม เซ ปุก ตื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","เญือม พา โม ปอกา มีเดี่ยน เซ คระ เซ, โม เอียกปุ อื เซ ยวก โยเซป โอก ฮา นัมโม่ เซ. โชะ อื ละ โม อิชมาเอน ลั่ก มาื ง่า เชเคน. โม เซ โรวก อื ฮอยจ เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ฟวยจ เซ เญือม เอีญ แลน รูเบ่น นัมโม่ เซ ไม่ ยุ อื โอ โยเซป เญือะ อาวต นึง โตะ อื, แจฮ ไอฮ ลปิ แตะ นึง ตุก รพาวม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","เอีญ อู อื ละ ปุ แตะ ตอก เฮี, “กวนดุ เซ เญือะ อาวต โตว นา เฮี. อาึ ซ ยุฮ ตอก เมอ แล?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","โม เซ ตุย ลปิ โยเซป. ตุย มอก ปิ ติ. ชึต ลปิ เซ นึง ฮนัม อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ฟวยจ เซ โรวก ลปิ ดา ไมจ เซ เปลีฮ อื ละ เปือะ แตะ. อัฮ เฮี ละ อื, “เอะ ยุ ลปิ เฮี. แลน ที เมอะ, อัม มัฮ ลปิ กวน เปอะ, อัม โอ มัฮ อื?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","เปือะ อื ยุง เอิน อื มัฮ อื. อัฮ เฮี, “มัฮ เนอึม ลปิ โยเซป เฮี เยอ. มัฮ เกียต โกะพริ อื. ตึน ซ แฌฮ บลวย ตื กวน อาึ เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ยาโคป แจฮ ไอฮ ลปิ โกะ แตะ ฆาื ตุก รพาวม แตะ. จาวป เครอึง ฮาื ฆัน. เยือม กวน แตะ เซ แปน วัง อื. ");
INSERT INTO lcp_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","โม กวน รเมะ กวน รโปวน อื ฮอยจ ดุป ไง่ ไป พาวม อื เตือง โอยจ แตะ. ยาโคป ปังเมอ โอ ญอม เกือฮ ปุย เกาะ โลม แตะ. อัฮ เฮี, “ปุ คัต อาึ อื. อาึ ซ เยือม กวน รเมะ เฮี แตะ ฮอยจ ละ ซเงะ ยุม โกะ แตะ,” อัฮ เซ. เยือม แนฮ เยือม แนฮ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","โม มีเดี่ยน เซ โรวก โยเซป ฮอยจ เมือง อียิป, โชะ อื ละ โปติฟา ป มัฮ จาวไน อาวต ไม่ กซัต ฟาโร ติ ปุย. มัฮ ฮัวนา ตฮัน มอง กซัต. ");
INSERT INTO lcp_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","2","เญือม เซ ยูด่า รกัฮ ติ แตะ ฮา โม เอียกปุ แตะ, โฮว อาวต ไม่ ปรเมะ ติ ปุย, มอยฮ ปุย เซ มัฮ ฮีรา. ฮีรา เซ มัฮ ปุย ย่วง อะดุ่นลัม. เญือม อาวต อื นา เซ ยูด่า รโตฮ ยุ ปเครีฮ ติ ปุย. มัฮ กวน ชูวา, มัฮ โม คะนาอัน. ปุก ปุย เซ รพาวม อื. ลอต เญือะ ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ฟวยจ เซ ปรโปวน เซ โรวก. เกิต กวน รเมะ ติ. ยูด่า ปุก มอยฮ อื. อัฮ เอ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","ปรโปวน เซ โรวก แม. ไก แม กวน รเมะ ติ. มอยฮ ปุย เซ มัฮ โอนัน. ");
INSERT INTO lcp_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","กังเคะ เอ โรวก แม ติ โฮน. เกิต แม กวน รเมะ. มอยฮ ปุย เซ มัฮ เชลา. เญือม เกิต เชลา เซ ปุก เญือม อาวต อื นึง ย่วง เคซิป. ");
INSERT INTO lcp_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","เญือม เอีจ เติง เวลา อื, ยูด่า ซาวป ปรโปวน ละ ซ เกือฮ แตะ เญือะ ไม่ เอ ป มัฮ กวน โรง แตะ เซ. มอยฮ ปรโปวน เซ มัฮ ทามัน. ");
INSERT INTO lcp_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","เอ เซ ยุฮ ป ฆอก ป เบร. กัน ยุฮ อื เซ ปุก โตว รพาวม พะจาว. พะจาว ยุฮ ยุม ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ฟวยจ เซ ยูด่า อัฮ เฮี ละ โอนัน, “ไมจ เปอะ ไอฮ ปรโปวน เญือะ เอียกระ เปอะ เซ. ยุฮ ป ลัง ยุฮ เปอะ ละ นึง มัฮ เปอะ ปุ เลีฮ อื, เดอึม เอียกระ เปอะ ซ ไก จัตเจือ ละ ซ ซึป อื มอยฮ แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","โอนัน เซ ยุง โอ ปุย ซ เมีญ จัตเจือ ป ซ เกิต นึง แตะ เซ มัฮ กวน โกะ แตะ. เญือม ไอจ อื ไม่ ปรโปวน เซ เกือฮ รอาวม เจือะ แตะ ดุฮ ลังเตะ ฆาื อื โครยญ โฮน อื, นึง โอ อื ฆวต เกือฮ เอียกระ แตะ เซ โฮลฮ กวน แตะ ละ ซ ซึป อื จัตเจือ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ป ยุฮ โอนัน เซ มัฮ ป ฆอก ป เบร ละ พะจาว. พะจาว ยุฮ โรฮ ยุม ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","เญือม เซ ยูด่า อัฮ เฮี ละ ทามัน ป มัฮ โมวน แตะ เซ, “เอีญ อาวต เญือะ เปือะ เปอะ ฮอยจ ละ ระ เชลา เญะ เฮี,” อัฮ เซ ละ อื. ดัฮ ซ เกือฮ เชลา เซ ไอฮ อื เตอ ฮลัต โรฮ อื ซ ยุม ตอก เซ โรฮ. เซ ป อัฮ อื ตอก เซ ฆาื อื. ทามัน เซ แม อาวต เนอึม ฆาื อื นึง เญือะ เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","เญือม เอีจ เลี่ญ อื ปรโปวน เญือะ ยูด่า เซ ยุม. เญือม เอีจ ไฮ โซะ รพาวม อื, ยูด่า เซ ฮาวก ดิ ไม่ ฮีรา ป มัฮ ปุโฮมว แตะ เซ ฮอยจ เคะ โม ป กัมลัง ญัป ฮาึก แกะ ยุฮ โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ไก ป รโฮงะ ละ ทามัน ตอก เฮี, “โปะ เปอะ ซ ฮาวก ย่วง ทิมนา ละ ซ ญัป อื ฮาึก แกะ ยุฮ แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ทามัน เปียน เครอึง แมฮัง แตะ ฆาื อื. เลอึป นา แตะ นึง พา ไมจๆ. โฮว งาวม ฆาื อื โบ โตะ รเวือะ ย่วง เอนาอิม. ปุก คระ โฮว ปุย นึง ย่วง ทิมนา เซ. ป ยุฮ อื ฆาื อื ตอก เซ, มัฮ ฆาื ยุ อื เอีจ ระ เชลา เซ, ยูด่า ปังเมอ โอ เกือฮ เชลา เซ แปน ปรเมะ เญือะ อื ติ ชวง. ");
INSERT INTO lcp_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ยูด่า เซ เญือม ยุ อื ปรโปวน เซ โคะ อื มัฮ มอจังคึต ติ ปุย, นึง เอีจ เลอึป อื นา แตะ ตัม ปซี ปซา ปรโปวน ฆอก ไล ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","เลียก เคะ อื ฆาื อื นึง อาวต อื เฆียง คระ เซ. บะ อื โฮว ดิ ไม่ แตะ. “โฮว ไอจ ดิ ไม่ อาึ และ,” อัฮ เซ ละ อื. เตอ โอ ยุง มัฮ อื โมวน แตะ. ทามัน เซ ไฮมญ อื ตอก เฮี, “ดัฮ โฮว ดิ ไม่ เปอะ เมอ ซ เกือฮ เปอะ เนิ อี?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","ยูด่า โลยฮ อื, “ดัฮ เอีจ โฮว ฮอยจ ก อาวต แกะ ยุฮ แตะ อาึ ซ เกือฮ ปุย ตาว กวน ปิ ละ เปอะ ติ ตัว,” อัฮ เซ. ปรโปวน เซ ไฮมญ แม อื, “เมอ ซ เกือฮ เปอะ แปน แมจัม อื กา เฆียง โฮลฮ โฮะ ปิ เซ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","ยูด่า อัฮ เฮี, “เมอ ฆวต ไอฮ เปอะ แปน แมจัม อื เซ?” อัฮ เซ ละ อื. ปุย เซ โลยฮ อื, “เกือฮ ไฌม ป ไก ทา ยุฮ เปอะ ไม่ โม่ะ ชวยฮ อื ไม่ โคะ ฆิ ยุฮ เปอะ เนิ,” อัฮ เซ ละ อื. ยูด่า เกือฮ เนอึม อื ละ อื. แปน ยุ เนอึม ปุ แตะ ฆาื อื. ทามัน โรวก เนอึม กวน แตะ เบือ ยุ แตะ ปุ แตะ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ฟวยจ โฮว ยูด่า ฮา อื เซ ทามัน ปอยจ พา ไมจๆ เลอึป นา แตะ เซ. ไอฮ แม เครอึง แมฮัง ตอก ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ฟวยจ เซ ยูด่า เกือฮ ปุโฮมว แตะ ป มัฮ ปุย ย่วง อะดุ่นลัม เซ ตาว กวน ปิ ละ ปรโปวน เซ ละ ซ โฮลฮ แม อื แมจัม เอีจ ดุฮ แตะ อาึง เซ. ปุย เซ ปังเมอ โอ ยุ ปรโปวน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ไฮมญ ปรเมะ ป อาวต ตอง เซ ฆาื อื, “มอจังคึต ป อาวต เฆียง คระ ย่วง เอนาอิม โฮ อาวต ก เมอ?” อัฮ เซ ละ อื. โม เซ โลยฮ อื, “นา เฮี ไก โตว มอจังคึต นึง เมอ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","ปุโฮมว อื เซ เอีญ แม เคะ ยูด่า. อัฮ เฮี, “อาึ ยุ โตว ปรโปวน อัฮ เปอะ เซ เฟือฮ. โม ป อาวต นา เซ อัฮ อื โอ ไก มอจังคึต นึง นา เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ยูด่า อัฮ เฮี, “ไอฮ อื ญุ่ก โอเอีฮ ป เกือฮ อาึ ละ อื เซ. ดัฮ เปอะ โฮว ไฮมญ ลอป โฮ, ปุย ซ โล่ ญวยฮ เอะ ฆาื อื. เอีจ ฟวยจ รโปะ กวน ปิ ละ อื. ปะ ปังเมอ โอ เปอะ ยุ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ฟวยจ เซ เมาะ ลอวย เคิ ไก ป ฮอยจ อู ละ ยูด่า ตอก เฮี, “ทามัน โมวน เปอะ เซ เอีจ เลน จุ. เอีจ โรวก ไม่ อื,” อัฮ เซ ละ อื. ยูด่า อัฮ เฮี, “โฮมวต โรวก นา เฮี. ไมจ ตอง แปฮ นึง งอ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","ลไล โฮมวต ปุย โรวก อื, ทามัน เซ รโปะ มวยญ แตะ ละ โปะ แตะ ตอก เฮี, “อาึ เอีจ โรวก ไม่ ปรเมะ ป มัฮ กุม โอเอีฮ โม เฮี. ไฌม ป ไก ทา เฮี ไม่ โม่ะ ชวยฮ อื ไม่ โคะ ฆิ เฮี มัฮ ป ยุฮ ปุย? แลน ทีๆ เมิฮ,” อัฮ เซ มวยญ ตอม อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ยูด่า เมือต แลน อื, ไตม มัฮ อื คอง โกะ แตะ. อัฮ เฮี ฆาื อื, “ปรโปวน เฮี เอีจ ปุก เดียก ฮา อาึ กัน ยุฮ อื. มัฮ ฆาื โอ อาึ ญอม เกือฮ ไอฮ เชลา ป มัฮ กวน เนอะ เซ,” อัฮ เซ. ฟวยจ เซ ยูด่า เญือะ ไอจ โตว ฆาื อื ไม่ ทามัน เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","เญือม เอีจ เติง เคิ รอาวม อื มัฮ กวน พรอม ป อาวต โตะ เวียก อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","เญือม ซ เกิต เนอึม อื, ติ ปุย อื ซนาว เตะ แตะ โอก รกา. มะปโกวน ป โซวต กวนงัก เซ ปุก เตะ อื นึง กอย ซครัก. อัฮ เฮี, “มัฮ ปุย เฮี ป เกิต รกา เยอ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","กวนงัก เซ ปังเมอ ราึต แม เตะ แตะ. กวนงัก ติ ปุย อื แม เกิต กา อื. มะปโกวน ป โซวต กวนงัก เซ อัฮ เฮี, “มัฮ ตอก เมอ เซ, เกียฮ ทอต โน่ง เปอะ ติ แตะ ตอก เฮี เมอ,” อัฮ เซ ละ กวนงัก เซ. ปุก มอยฮ อื. อัฮ เปเรต ละ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ฟวยจ เซ เกิต แม ปุ ป ไก กอย ซครัก นึง เตะ อื เซ. ปุก โรฮ มอยฮ กวนงัก เซ. อัฮ เซรา ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","เญือม โรวก โม อิชมาเอน โยเซป ฮอยจ เมือง อียิป เปอ, ไก จาวไน อาวต ไม่ กซัต ฟาโร ติ ปุย. มัฮ โปติฟา, มัฮ ฮัวนา ตฮัน มอง กซัต. รวี โยเซป นึง โม อิชมาเอน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","เญือม อาวต โยเซป เญือะ ปอเลียง แตะ นึง เมือง อียิป เซ, พะจาว อาวต ไม่ อื. เกือฮ กัน ยุฮ อื จเลิน โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ปอเลียง อื เซ ยุ อาวต พะจาว ไม่ โยเซป. กัน ยุฮ อื ไก ป มัฮ เบือ อื โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ปอเลียง อื ปุก กัน ยุฮ โยเซป เซ รพาวม อื. เกือฮ เอิน โยเซป เซ แลน แก คาวคอง เญือะ แตะ ฆาื อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","เคียง เซ พะจาว ปิฮ มุ่น ละ เญือะ โปติฟา ป มัฮ ปุย อียิป เซ เบือ โยเซป. โอเอีฮ นึง เญือะ นึง ย่วง, นึง ชิจ นึง ม่า ไมจ โอยจ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","โปติฟา มอป โอเอีฮ ยุฮ แตะ ละ โยเซป เตือง โอยจ อื เกือฮ อื กุม อื. เญือะ ตุก พาวม โตว นึง โอเอีฮ ติ เจือ เนอึม, โนก ฮา ป ซ โซม ซ ปอน โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","โยเซป มัฮ ปุย ไมจ นาตา ไม่ ชอม ฮุนฮัง แตะ. เญือม เอีจ เลี่ญ อาวต อื เญือะ เซ, ปรโปวน เญือะ ปอเลียง อื เซ ยุ ไมจ โยเซป. อัฮ เฮี ละ อื, “เลียก ไอจ ดิ โตะ ฮอง และ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","โยเซป ปังเมอ โอ ญอม เลียก ไอจ ไม่ อื. อัฮ เฮี, “ปอเลียง อาึ เญาะ ไฌม โตว โอเอีฮ นึง เญือะ แตะ นึง กุม อาึ อื ละ อื โครยญ เจือ. มอป โอเอีฮ ยุฮ แตะ ละ อาึ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","ไก โตว ป ระ นึง เญือะ เฮี ฮา อาึ อื. ปอเลียง เงอะ ฮลัก โตว กอ โอเอีฮ ฮา อาึ ติ เจือ เนอึม โนก ฮา ตัว ปะ เซ, นึง มัฮ เปอะ ปุย เญือะ อื. อาึ อัม ซ เกียฮ ยุฮ ป ฆอก ลัมเลือ ตอก เซ? มัฮ ป พิต เนอึม ละ พะจาว,” อัฮ เซ โยเซป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ปัง บะ ลอป โยเซป ตอก เซ โครยญ ซเง่ะ โยเซป ญอม โตว เนอึง ป อัฮ อื. อาวต ซดิ ไม่ อื ปุ ญอม อาวต. ");
INSERT INTO lcp_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ไก ติ ซเงะ เญือม เลียก โยเซป โตะ เญือะ ละ ซ ยุฮ แตะ กัน. ปุก เญือม โอ กวนไจ ไฮญ อื อาวต ติ ตื. ");
INSERT INTO lcp_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","ปรโปวน เซ โฮมวต ลปิ อื. อัฮ เฮี, “เลียก ไอจ ดิ โตะ ฮอง และ,” อัฮ เซ. โยเซป ตอ โอก ก พริ. ละ อาึง ลปิ แตะ นึง เตะ ปรโปวน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","14","ปรโปวน เซ เญือม ยุ อื ตอ โยเซป ตอก เซ ไม่ ละ อื อาึง ลปิ แตะ นึง เตะ แตะ ตอก เซ, รโอง กอก กวนไจ ยุฮ แตะ ฆาื อื. อัฮ เฮี, “แลน เมิฮ, ปรเมะ เญือะ อาึ เกือฮ ปุย ฮีบรู ฆอก ไล เฮี อาวต นึง เญือะ ละ ซ พามัต ดู่แควน แตะ เอะ. เลียก โตะ ฮอง ไอจ อาึ, ริ ไอฮ พาวม ไม่ เยอะ. อาึ รโอง เอิน ฆาื ปอ โอยจ เซียง แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","เญือม ฮมอง อื รโอง อาึ ตอก เซ ตอ โอก ก พริ, ละ อาึง ลปิ แตะ ไม่ อาึ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","ปรโปวน เซ แฮรน ลปิ อื เซ ฮอยจ ละ เอีญ ปรเมะ เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","เญือม เซ รโฮงะ ไลลวง อื ละ อื ตอก เฮี, “ครา ฮีบรู โอ ลุก ป โรวก โม เปะ เซ พามัต ลัมเลือ อาึ, เลียก โตะ ฮอง อาึ, ริ ไอฮ พาวม ไม่ เยอะ. ");
INSERT INTO lcp_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","เญือม รโอง อาึ ละ อื, ตอ เอิน โอก ก พริ, ละ อาึง ลปิ แตะ ไม่ เยอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","เญือม เอีจ ฮมอง ปอเลียง โยเซป ไลลวง ป อัฮ ปรโปวน เญือะ แตะ เซ, ฮาวก รพาวม เนอึม ฮาวก รพาวม แนม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","เกือฮ ปุย โฮมวต โยเซป, ตาว อาึง อื โตะ คอก. มัฮ คอก คัง ปุย ป ตุต ป รซอฮ ละ กซัต. โยเซป โฮลฮ โรฮ อาวต นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","พะจาว ปังเมอ อาวต ไม่ โยเซป. เปลีฮ กุนมุ่น ยุฮ แตะ ละ อื. เกือฮ ไนกุม คอก เลียก พาวม นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ไนกุม คอก เซ ลอต เกือฮ โยเซป แลน แก ป ตุต ไฮญ เตือง โอยจ อื. เกือฮ กัน โอเอีฮ โตะ คอก เซ อาวต ไน ลวัง บั่งคัป โยเซป โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ไนกุม คอก เซ เญือะ โฮลฮ โตว เครอึง นึง กัน โอเอีฮ ป มอป แตะ ละ อื, นึง อาวต พะจาว ไม่ โยเซป, ไม่ เกือฮ อื กัน ยุฮ อื เซ จเลิน โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ฟวยจ เซ ฮัวนา กวนไจ กซัต ป จิม รอาวม อะงุน ยุฮ อื ไม่ ฮัวนา ป ยุฮ คโนมปัง ละ อื ยุฮ ป พิต ละ กซัต. ");
INSERT INTO lcp_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","กซัต รอก พาวม นึง ปุย ลอา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","คัง อื โตะ คอก นึง เญือะ ฮัวนา ตฮัน ป มอง กซัต เซ. มัฮ ติ โดฮ ไม่ นา ก คัง ปุย โยเซป เซ. ");
INSERT INTO lcp_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ฮัวนา ตฮัน เซ เกือฮ โยเซป แลน แก อื นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","เญือม เอีจ เลี่ญ อาวต อื โตะ คอก เซ ป มัฮ ป จิม รอาวม อะงุน ไม่ ป ยุฮ คโนมปัง เซ ตัง โคน ตัง รโมะ ยุ โอเอีฮ. มัฮ ซาวม ติ. ป รโมะ อื ยุ เซ ตัง โน่ง ควัมไม ฮา ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ปวยฮ พริ เซ เญือม ฮอยจ โยเซป เคะ อื, ยุ นา มึต นา มอง ปุย ลอา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","ไฮมญ อื, “เมอ ตุก รพาวม เปอะ นึง อื เนาะ เฮี?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","ปุย ลอา เซ โลยฮ อื, “เอะ ลอา ตัง โคน ตัง รโมะ ยุ โอเอีฮ. ไก โตว ป เกียฮ รนึก เนิ,” อัฮ เซ. โยเซป อัฮ เฮี, “กัน รนึก รโมะ ปุย โม่ มัฮ พะจาว ป เกียฮ รนึก เกอ? รโฮงะ แลน ละ อาึ เมอะ รโมะ เปอะ เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","ป จิม รอาวม อะงุน เซ อัฮ เฮี, “อาึ รโมะ ยุ โคะ อะงุน ซองนา แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ไก กัก ลอวย. เมาะ ซ ชุก ฮละ อื โคะ อะงุน เซ เตีย. เปลิ. ตึม เอิน เปลิ อื. ");
INSERT INTO lcp_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","อาึ รโมะ ยุ ไปญ แตะ จอก ยุฮ กซัต. อาึ เปฮ เปลิ อะงุน เซ แม่ต เตอะ. เกือฮ รอาวม อื เลียก โตะ จอก ยุฮ อื เซ. ฟวยจ เซ กอยฮ แฮะ ละ กซัต,” อัฮ เซ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","โยเซป อัฮ เฮี, “รโมะ ปะ เซ มัฮ ตอก เฮี, กัก ลอวย เซ มัฮ ลอวย ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ไก ลั่ง ลอวย ซเงะ. กซัต ซ พลวย ปะ โอก. ซ เกือฮ ปะ โปน ตุต ยุฮ เปอะ. ซ เกือฮ แม ปะ โฮลฮ อาวต นึง ตัมแนง อาวต ไพรม เปอะ. ซ โฮลฮ เปอะ กอยฮ จอก รอาวม อะงุน ละ กซัต ตอก ยุฮ ไพรม เปอะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","เญือม ไมจ แม ป ยุ เคราะ แม ป ฮมอง เปอะ ปัว เปอะ โอ เบีย อาึ. ปัว เปอะ เลียก พาวม นึง เงอะ. อู ไลลวง อาึ ละ กซัต เกือฮ เรอึม อาึ เกือฮ โปน ฮา คอก เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","ไพรม อื อาึ มัฮ โฮมวต ปุย โรวก เกอะ เน่อึม นึง เมือง ฮีบรู. อาวต แม นึง เมือง เฮี, ปุ โรฮ ยุฮ ป พิต ติ เจือ เนอึม ป โปง ไม่ อาวต แตะ โตะ คอก เฮี ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","เญือม ฮมอง ป ยุฮ คโนมปัง เซ ไลลวง ไมจ ป ซ โฮลฮ ป จิม รอาวม อะงุน เซ นึง ไมจ รโมะ อื, อัฮ โรฮ เฮี ละ โยเซป, “อาึ รโมะ โรฮ โฮะ. รโมะ ยุ เน่ะ แตะ ปุ โฮว คโนมปัง ลอวย ทัต. ");
INSERT INTO lcp_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ทัต อาวต ราว เซ ไก คโนม ญึม ละ ฟาโร นึง โฮวน เจือ. เญือม เซ ฮอยจ ปวก ไซม โซม ป อาวต นึง ทัต ราว ไกญ เญอะ เซ,” อัฮ เซ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","โยเซป อัฮ เฮี, “รโมะ ปะ เซ มัฮ ตอก เฮี, ทัต ลอวย เซ มัฮ ลอวย ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ไน ลอวย ซเงะ ฟาโร ซ เกือฮ ปะ โอก ฮา คอก. ซ เกือฮ ปุย กิต ไกญ เปอะ. โกะ เปอะ ซ เคิง อื นึง โคะ. ไซม ซ ฮอยจ ปวก กุก เนะ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ฟวยจ เซ ลอวย ซเงะ, กซัต เลียง โม จาวไน นึง บั่นเมือง แตะ นึง มัฮ อื ซเงะ เกิต แตะ. เกือฮ ป จิม รอาวม อะงุน ยุฮ แตะ ไม่ ป ยุฮ คโนมปัง ยุฮ แตะ เซ โอก ฮา คอก. เกือฮ อื ชุง ลั่กกา โม จาวไน เซ. ");
INSERT INTO lcp_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","เกือฮ เนอึม ป จิม รอาวม อะงุน ยุฮ แตะ เซ อาวต แม นึง ตัมแนง อาวต ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","เกือฮ เนอึม ปุย ยุฮ ยุม ไม่ ป ยุฮ คโนมปัง เซ ไม่ เคิง อื นึง โคะ. เอีจ ตอก เนอึม อัฮ โยเซป อื โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ป จิม รอาวม อะงุน เซ ปังเมอ โอ เญือะ โตก ละ โยเซป เฟือฮ. เบีย ซไบ่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ฟวยจ เซ แม ลอา เนอึม, กซัต เมือง อียิป รโมะ ยุ ชุง แตะ โบ โกลง ไน. ");
INSERT INTO lcp_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","รโมะ ยุ โมวก โกลยญ ไมจ อาแลฮ ตัว, โอก ฮา โกลง, เปือม ไรป เฆียง โกลง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","ฟวยจ เซ ไก แม โมวก รเกือะ ลัมลอน นึง อาแลฮ ตัว, โอก ชุง โรฮ ไม่ อื เฆียง โกลง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","โมวก รเกือะ เซ เกียต กุก โมวก โกลยญ เซ. โอยจ เอิน ยุฮ อื. ฟวยจ เซ กซัต เซ โปวะ. ");
INSERT INTO lcp_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","เญือม ปุน แม อื ไอจ รโมะ แม ติ โฮน. รโมะ ยุ เฮงาะ ติ เน่อึม ไก อาแลฮ ซเนียง. มัฮ เฮงาะ ซโตฮ ตึก นึง ไมจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ฟวยจ เซ ไก แม เฮงาะ แลป นึง อาแลฮ ซเนียง, ตอก เฮงาะ ไลจ นึง ปุฮ กาื เน่อึม ลั่ก ลาึน ซออฮ แตะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","เฮงาะ แลป เซ โซม เฮงาะ ไมจ เซ, โอยจ เอิน ยุฮ อื. เญือม โปวะ อื กซัต เซ ยุง มัฮ อื รโมะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ปวยฮ พริ เซ ตุก รพาวม ฆาื อื. กอก โม ป เกียฮ ซโปก ซักซี ไม่ โม ป ฮลาวง ป ยุง เมือง อียิป เตือง โอยจ อื. รไปฮ รโมะ แตะ เซ ละ อื แปน ไล แตะ, ปังเมอ โอ ไก ป เกียฮ รนึก ละ อื ติ ปุย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","เญือม เซ ป จิม รอาวม อะงุน เซ อัฮ เฮี ละ กซัต, “เนาะ เฮี อาึ โตก ละ พิต แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ไพรม อื กซัต รอก พาวม นึง ป ยุฮ คโนมปัง ละ แตะ ไม่ อาึ โรฮ. ปะ คัง เปอะ เอะ ลอา โตะ คอก นึง เญือะ ฮัวนา ตฮัน ป มอง กซัต. ");
INSERT INTO lcp_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ไก ติ ซาวม. เอะ ลอา ตัง โคน ตัง รโมะ โอะ. รโมะ เอะ เซ ปังเมอ ตัง ควัมไม ฮา ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","ไก ปรเมะ นุม เมือง ฮีบรู ติ ปุย, มัฮ ป อาวต ดิ ไม่ เอะ โตะ คอก. มัฮ กวนไจ ฮัวนา ตฮัน มอง กซัต. เอะ รไปฮ รโมะ แตะ ละ ปุย เซ. ปุย เซ เกียฮ รนึก อื เนิ. ");
INSERT INTO lcp_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","เกิต เนอึม ตอก อัฮ อื ซ เกิต เซ โครยญ เจือ. ปะ เกือฮ เนอึม เปอะ อาึ โฮลฮ ยุฮ แม กัน ตอก ไพรม แตะ. ปะ ยุฮ เนอึม เปอะ ยุม ไม่ ป ยุฮ คโนมปัง ละ แตะ เซ,” อัฮ เซ ละ กซัต. ");
INSERT INTO lcp_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","เญือม เซ กซัต ดวน ปุย โฮว กอก โยเซป ฮอยจ เคะ แตะ ฆาื อื. โยเซป โอก เอิน ฮา คอก เซ. ฟวยจ เซ คุต ฮาึก กัป ฮาึก รบุม แตะ. ลโปลฮ เครอึง แตะ, ลอต ฮอยจ เคะ กซัต. ");
INSERT INTO lcp_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ฟาโร อัฮ เฮี ละ โยเซป, “อาึ รโมะ ยุ โอเอีฮ. ไก โตว ป เกียฮ รนึก รโมะ โอะ เนิ ติ ปุย เนอึม. อาึ เอีจ ฮมอง อัฮ ปุย ปะ เกียฮ รนึก รโมะ ปุย,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","โยเซป โลยฮ อื, “มัฮ โตว อาึ ป เกียฮ ฮา. มัฮ พะจาว โน่ง ป ซ เกียฮ เกือฮ ปะ ยุง โอเอีฮ ตัม โซมกวน อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","กซัต อัฮ เฮี, “อาึ รโมะ ยุ ชุง แตะ เฆียง โกลง ไน. ");
INSERT INTO lcp_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ไก โมวก โกลยญ ไมจ โอก ฮา โกลง เซ อาแลฮ ตัว. ซาวป เปือม ไรป เฆียง โกลง. ");
INSERT INTO lcp_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","ฟวยจ เซ ไก แม โมวก อาแลฮ ตัว. ฆอก, ไม่ รเกือะ ลัมเลือ เอิน อื. อาึ ยุ โตว ติ ชวง โมวก ฆอก ตอก เซ ไน ติ เมือง อียิป เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","โมวก รเกือะ เซ เกียต กุก โมวก โกลยญ ป ฮอยจ รกา แตะ เซ. โอยจ เอิน ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ฟวยจ กุก อื ปังเมอ รเกือะ ลั่ง ตอก ไพรม แตะ. ฆอก ลั่ง ตอก ไพรม แตะ. เญือม เซ อาึ โปวะ อุ. ");
INSERT INTO lcp_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“ฟวยจ เซ รโมะ แม ยุ เฮงาะ ติ เน่อึม ไก อาแลฮ ซเนียง, มัฮ เฮงาะ ซโตฮ ตึก นึง ไมจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","เญือม เซ ยุ แม โอก เฮงาะ อาแลฮ ซเนียง แม. แลป ฆอก ตอก เฮงาะ ปุฮ กาื เน่อึม ลั่ก ลาึน ซออฮ แตะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","เฮงาะ แลป เซ โซม เฮงาะ ไมจ เซ. โอยจ เอิน ยุฮ อื. อาึ เอีจ อู ไล เฮี ละ โม ป เกียฮ ซโปก ซักซี. ไก โตว ป เกียฮ รนึก เนิ ติ ปุย เนอึม,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","เญือม เซ โยเซป อัฮ เฮี ละ ฟาโร, “โอเอีฮ ป รโมะ ปะ ยุ เซ มัฮ ไล ติ. เอีจ มัฮ รโฮงะ พะจาว อาึง ป ซ ยุฮ แตะ ละ เปอะ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","โมวก ไมจ อาแลฮ ตัว เซ มัฮ อาแลฮ เนอึม. เฮงาะ ไมจ อาแลฮ ซเนียง เซ มัฮ โรฮ อาแลฮ เนอึม. มัฮ รโมะ ติ ไล โน่ง. ");
INSERT INTO lcp_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","โมวก ฆอก รเกือะ ป โอก รเคะ นึง อื เซ มัฮ โรฮ อาแลฮ เนอึม. เฮงาะ แลป อาแลฮ ซเนียง ป ไลจ นึง ปุฮ กาื แตะ เซ มัฮ โรฮ อื. เอีจ มัฮ ซ เกิต ไปลญ เออึป ปุย นึง อาแลฮ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“เอีจ มัฮ ตอก อัฮ ละ เปอะ เนาะ โฮ. เอีจ มัฮ รโฮงะ พะจาว อาึง ป ซ ยุฮ แตะ ละ เปอะ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ซ ไก อาแลฮ เนอึม เญือม ซ ไมจ เฮงาะ ไมจ รโกะ ติ เมือง อียิป เปอ. ไน อาแลฮ เนอึม เซ, ซ ไมจ เนอึม โอเอีฮ นึง. ");
INSERT INTO lcp_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","ฟวยจ เซ ซ เกิต แม ไปลญ เออึป ปุย นึง อาแลฮ เนอึม. ปุย ซ เบีย โอยจ ป ไมจ โฮลฮ แตะ, นึง ยุ แตะ ไลจ บั่นเมือง ฆาื ไปลญ เออึป ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ปุย เญือะ ซ เกียฮ โตก โตว ละ โอเอีฮ ไมจ ป ยุ แตะ กา เซ, นึง โซะ ลัมเลือ ไปลญ อาวป เออึป กิฮ ป ซ เกิต ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","พะจาว เอีจ โปวต รพาวม แตะ ละ ซ ยุฮ เนอึม แตะ ตอก เซ. เญือะ เลี่ญ โตว ซ เกิต อื. มัฮ เซ ป เปลีฮ พะจาว โอเอีฮ ตอก เซ ละ เปอะ ฆาื อื นึง รโมะ เปอะ เซ ลอา โฮน เอิน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","โยเซป อัฮ แม เฮี ละ ฟาโร, “ปเลี่ย เฮี คาว ละ ซาวป เปอะ ปุย ไมจ พันญา ป เกียฮ คิต เกียฮ ง่อต โอเอีฮ. เกือฮ ปุย เซ ไปญ กัน นึง เมือง อียิป เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ไมจ โรฮ เปอะ เลือก ปุย ง่อน. เกือฮ ซาวป ซเพระ เฮงาะ เลี่ป เมือง อียิป เฮี. เฮงาะ พอน ปุน เกือฮ แฮรน อาึง อื ติ ปุน, ไน ติ เจน ไมจ โอเอีฮ อาแลฮ เนอึม เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","ไมจ เปอะ เกือฮ อัมนัต ละ ปุย โม เซ, ละ ซ แฮรน อื อาึง ป โซม ป ปอน โครยญ เจือ ไน ติ เจน ไมจ โอเอีฮ เฮี. เกือฮ แฮรน อาึง อื กไน เวียง ละ ซ แปน อื ป โซม ปุย เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ป โซม ป ปอน เซ ไมจ อื แฮรน อาึง ละ ปุย เมือง เฮี, ละ ซ เกือฮ อื ปุย ไก ป โซม ไน ติ เจน อาแลฮ เนอึม เญือม ซ ไปลญ ปุย เซ, เดอึม ปุย เมือง อียิป เฮี โอ ซ ยุม นึง ไปลญ แตะ,” อัฮ เซ โยเซป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ฟาโร ไม่ โม กวนไจ ยุฮ อื, ปุก ป อัฮ โยเซป เซ รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ฟาโร ไฮมญ โม เซ ตอก เฮี, “ไน โม เอะ เฮี อัม ไก ปุย ตอก ปุย เฮี นึง อื? แจง โอ อื ไก. ปุย เฮี มัฮ เนอึม ปุย อาวต ลปุ พะจาว นึง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ฟาโร อัฮ แม เฮี ละ โยเซป, “เอีจ ที เนิ อาวต ปะ ไม่ ไมจ พันญา แตะ ไม่ เกียฮ คิต เกียฮ ง่อต เปอะ โอเอีฮ ฮา ปุย ไฮญ, นึง เปลีฮ พะจาว โอเอีฮ ไล เฮี ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","อาึ ซ เกือฮ ปะ ไปญ กัน นึง เมือง เอะ เฮี เตือง โอยจ อื. ซ เกือฮ โรฮ ลุกเมือง แตะ เนอึง ป อัฮ ปะ โครยญ โฆะ ปุย. ไก โตว ติ ปุย เนอึม ป ซ ระ อัมนัต ฮา ปะ โนก ฮา อาึ อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ปเลี่ย เฮี อาึ ดุฮ ปะ แปน ป แลน แก เมือง อียิป เตือง เมือง อื,” อัฮ เซ ละ อื ฟาโร เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ฟาโร ปอยจ ไฌม ซัมคัน ยุฮ แตะ จาวป อื นึง ด่อยฮ โยเซป. เกือฮ ลปิ ซัมคัน ละ อื เกือฮ อื จาวป อื, ดุฮ โรฮ ฮนัง ไคร นึง โงก อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","เกือฮ โลต บรอง นาโยก ละ อื เกือฮ อื บุก อื, เกือฮ โม ตฮัน โฮว รกา อื ไม่ ครอฮ อื ละ ปุย เกือฮ ปุย นุ่ม ไว อื. มัฮ ตอก เซ ตอก โฮลฮ โยเซป แปน ป ตัตเตียง เมือง อียิป เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ฟาโร อัฮ เฮี, “อาึ มัฮ ฟาโร. อาึ ซ เกือฮ โตว ปุย เมือง อียิป ยุฮ ป ติ ป เตอื โนก ฮา โปง ปะ อื ยุฮ ฮู,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","เกือฮ มอยฮ อียิป ละ โยเซป ติ. อัฮ ซาเฟนัต ปาเนอา ละ อื. เกือฮ โรฮ ปรโปวน เญือะ อื ละ อื. มัฮ อาเซนัต กวน โปทีเฟรา ป มัฮ ซตุ เมือง โอน. อาญุ โยเซป ไก ง่วย เนอึม เญือม ยุฮ โรง อื กัน ละ กซัต เมือง อียิป เซ. โอก โฮว ฮา เญือะ กซัต โฮว ไป โฮว มา เลี่ป เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ติ เจน อาแลฮ เนอึม เซ โฮวน ลัมเลือ เอิน ป โซม ป ปอน นึง เมือง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ไน ติ เจน อาแลฮ เนอึม เซ โยเซป ซาวป แฮรน อื กไน เวียง โฮวน โดฮ. เฮงาะ รโกะ ป ซาวป อื ซเพระ เน่อึม นึง แควน เวียง ออฮ, แฮรน อาึง อื โตะ เวียง เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","โยเซป เปอ รโจะ อาึง เฮงาะ โฮวน ลัมเลือ เอิน, ตอก เอิน ไฮมจ นึง เกาะ โฮ, ปอ เอิน โอ อื เญือะ เกียฮ โจต นึง บั่นชี, นึง โฮวน ลอน อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","กา ฮอยจ เนอึม ไปลญ ปุย เซ, โยเซป ไม่ อาเซนัต ไก กวน รเมะ ลอา ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","โยเซป อัฮ เฮี, “พะจาว เอีจ เกือฮ อาึ เบีย เม่ะมั่ก อาวม แตะ. เบีย โรฮ เญือะ เปือะ เกอะ ไม่ อื,” อัฮ เซ. มัฮ เซ ป อัฮ อื มะนาเซ ละ กวน โรง แตะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","อัฮ โรฮ เฮี, “พะจาว เอีจ เกือฮ อาึ โฮลฮ กวน แตะ นึง เมือง เม่ะมั่ก เกอะ เฮี,” อัฮ เซ. มัฮ เซ ป อัฮ อื เอฟราอิม ละ กวน รเคะ แตะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","กัง เคะ เอ เญือม เอีจ โปน อื อาแลฮ เนอึม เญือม โฮวน โอเอีฮ เซ, ");
INSERT INTO lcp_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","เอีจ ฮอยจ ละ อาแลฮ เนอึม ซ ไปลญ ปุย ตอก อัฮ โยเซป อาึง โฮ. เมือง ปุย ไฮญ ไปลญ เนอึม ปุย นึง. เมือง อียิป ปังเมอ โฮลฮ ลั่ง โซม ปุย นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ปุย เมือง อียิป เญือม โอยจ ป โซม ป ไอฮ โกะ อื, ปัว ป โซม ป ไอฮ แตะ นึง ฟาโร. ฟาโร เซ อัฮ เฮี ละ อื, “โฮว เคะ โยเซป เปอ. ยุฮ ตัม ดวน อื โม เปะ ยุฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","เญือม เอีจ ฮอยจ ไปลญ เออึป ละ ปุย ติ เมือง อียิป เปอ โยเซป โปฮ เกอึม ลวง, โชะ เฮงาะ ละ โม อียิป เซ. ");
INSERT INTO lcp_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ปุย ติ ปลัฮเตะ เอ ฮอยจ ตื เคะ โยเซป, รวี เฮงาะ นึง อื, นึง โซะ เนอึม ไปลญ เออึป ปุย โครยญ โดฮ. ");
INSERT INTO lcp_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","เญือม ฮมอง ยาโคป ไลลวง ไก ลั่ง เฮงาะ นึง เมือง อียิป เปอ, อัฮ เฮี ละ กวน แตะ, “เมอยุ อาวต โฆย แนฮ เปอะ ตอก เซ? ");
INSERT INTO lcp_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","อาึ เอีจ ฮมอง เงอะ ไก เฮงาะ นึง เมือง อียิป เปอ. ไมจ เปอะ โฮว ซาวป รวี ละ เอะ ง่อน, เดอึม โอ ซ ยุม นึง ไปลญ แตะ เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","เญือม เซ โม เอียกระ เอียกตุ โยเซป โฮว เนอึม กาว ปุย ละ ซ รวี แตะ เฮงาะ เมือง อียิป เซ. ");
INSERT INTO lcp_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ยาโคป เกือฮ โตว เบ่นยามิน ปุ เลีฮ โยเซป โฮว ไม่ อื, นึง ฮลัต แตะ ป โซะ ซ เกิต ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","มัฮ ตอก เซ ตอก โฮลฮ โม กวน อิซราเอน ฮอยจ รวี ดิ เฮงาะ ไม่ ปุย ไฮญ, นึง อาวต โรฮ ปุย เมือง คะนาอัน ไม่ ไปลญ เออึป แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","โยเซป ป มัฮ ป ตัตเตียง เมือง อียิป เซ โชะ เฮงาะ ละ ปุย ติ เมือง เซ. โม เอียกปุ โยเซป เซ ฮอยจ เคะ อื ฆาื อื. นุ่ม ไว อื ปอ จิ ไกญ แตะ เตะ. ");
INSERT INTO lcp_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","เญือม ยุ โยเซป โม เอียกปุ แตะ เซ, ยุง เอิน อื ป มัฮ อื, ปังเมอ เคียต เกือฮ ติ แตะ ตอก ป โอ ยุง อื. ลปุง ซวก ไม่ อื. “โม เปะ ฮอยจ เปอะ เน่อึม ก เมอ?” เคียต อัฮ เซ ละ อื. โม เซ โลยฮ อื, “ฮอยจ เน่อึม นึง เมือง คะนาอัน ละ ซ รวี แตะ ป โซม แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","โยเซป ยุง ลั่ง โม เอียกปุ แตะ เซ. โม เซ ปังเมอ โอ เญาะ ยุง โกะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","โยเซป โตก ละ รโมะ ไพรม แตะ ฆาื อื นึง ไลลวง โม เอียกปุ แตะ. อัฮ เฮี ละ อื, “โม เปะ มัฮ เปอะ ป ซาวป เลียป เมือง เอะ. ฆวต ซาวป เปอะ เลียป แลน นา ก โอ เมือง เงอะ ตอน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","โม เซ โลยฮ อื, “จาวไน, มัฮ โตว ตอก เซ. เอะ ป มัฮ กวนไจ ปุย โจฮ ยุฮ เปอะ เฮี, มัฮ ฮอยจ ซาวป รวี ป โซม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","เอะ มัฮ ตื กวน ติ เปือะ. เอะ มัฮ ปุย เนอึม รพาวม. มัฮ โตว ป ซาวป เลียป โอเอีฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","โยเซป อัฮ แม เฮี, “อาึ เจือ โตว เปอะ. โม เปะ มัฮ เนอึม เปอะ ป ซาวป เลียป แลน นา ก โอ เมือง เอะ ตอน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","โม เซ โลยฮ อื, “เอะ ป มัฮ กวนไจ ปุย โจฮ ยุฮ เปอะ ไก ไม่ ปุ แตะ กาว ลอา รเมะ, มัฮ กวน ติ เปือะ. เปือะ เกอะ อาวต เมือง คะนาอัน. ป มัฮ ปุ รเคะ เอะ อาวต ลั่ง ไม่ เปือะ เกอะ. ปุ อุ ติ ปุย อื เญือะ ไก โตว,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","โยเซป อัฮ เฮี, “เอีจ ปุก ป อัฮ ฮะ เซ. โม เปะ มัฮ เนอึม เปอะ ป เลียป แลน โอเอีฮ. ");
INSERT INTO lcp_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","อาึ ซ ลอง รพาวม โม เปะ ตอก เฮี. แจง ไอม ฟาโร ตอก ออฮ, อาึ แจง โรฮ โอ ซ เกือฮ โม เปะ เอีญ กา เฆียง ฮอยจ ปุ รเคะ เปอะ เซ นา เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","เกือฮ โม เปะ เอีญ ติ ปุย โน่ง ละ ซ เอีญ ตุย เปอะ ปุ แตะ เซ. ปุย ไฮญ ซ คัง เงอะ โตะ คอก, ละ ซ ลอง แตะ แลน เมาะ เนอึม ป อัฮ โม เปะ ไม่ โอ อื เนอึม. ดัฮ มัฮ ป โอ เนอึม โฮ, แจง ไอม ฟาโร ตอก ออฮ, อาึ แจง โรฮ นึง มัฮ โม เปะ ป เลียป เมือง ตอก เซ โรฮ,” อัฮ เซ ละ อื. เกือฮ โรฮ ติ แตะ แจง แน เบือ มอยฮ ฟาโร. ");
INSERT INTO lcp_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","คัง เนอึม อื โตะ คอก ลอวย ซเงะ เตือง มู อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ฟวยจ เซ ลอวย ซเงะ โยเซป อัฮ เฮี ละ อื, “อาึ มัฮ ปุย นัปทื เนอึม พะจาว. ดัฮ เปอะ ยุฮ ตอก เฮี ติ เจือ ซ เกือฮ โม เปะ ไอม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","ซ เกือฮ โม เปะ อาวต โตะ คอก นา เฮี ติ ปุย โน่ง นึง ซ เปลีฮ เปอะ มัฮ แตะ ปุย เนอึม รพาวม. ปุย ไฮญ ซ เกือฮ เอีญ ตาว เฮงาะ รวี เปอะ ละ โม กวน เฌือต ป อัฮ เปอะ อาวต ไม่ ไปลญ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","โม เปะ ปังเมอ ไมจ เปอะ ตาว ปุ รเคะ เปอะ เซ ฮอยจ เคะ อาึ เดอึม ซ แจง เนิ เนอึม ป อัฮ โม เปะ เอ ไม่ โอ เปอะ ซ ยุม,” อัฮ เซ ละ อื. โม เซ ญอม ละ อื ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","โม เซ บระ อัฮ อื ละ ปุ แตะ ตอก เฮี, “เอีจ แจง นึง กัน ลอก เอะ ตุต ตอก เฮี มัฮ ฆาื ป ยุฮ ฮุ ละ ปุ เลีฮ แตะ โฮ. เอะ ยุ อุ รพาวม ตุก อื เญือม ปัว อื เอะ เลียก พาวม นึง แตะ ละ ซ ไอม แตะ. เอะ ปังเมอ โอ เลียก พาวม นึง. เซ ป เกิต ป ญัก ละ เอะ ตอก เฮี ฆาื อื,” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","รูเบ่น อัฮ เฮี, “อาึ เอีจ ตึน อัฮ ละ โม เปะ โอ ไมจ ยุฮ ป โซะ ละ กวนดุ เซ, โม่ อัฮ? โม เปะ ปังเมอ โอ เปอะ เนอึง ป อัฮ ฮะ. ปเลี่ย เฮี มั่ป นึง ยุฮ แตะ ยุม ไม่ อื เอีจ ไคว ละ เอะ,” อัฮ เซ ละ โม ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","โม เซ ยุง โตว อื เกียฮ คาวไจ โยเซป ป อัฮ แตะ เซ นึง โกว อื ป ซึป ลปุง แตะ เญือม ลปุง อื ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","โยเซป โอก ฮา โม เซ, เยือม ฆาื อื. ฟวยจ เซ เลียก ลปุง แม ไม่ อื. รกัฮ ซิเมโอน โอก ฮา โม เซ. เกือฮ ปุย โจก อาึง อื ซองนา โม เอียกปุ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","โยเซป เกือฮ ปุย ดุฮ เฮงาะ โตะ ฮาื อื นาวก. ดวน โรฮ อื บระ รแม่ มาื งวยฮ เฮงาะ ยุฮ อื เซ โตะ ฮาื เฮงาะ เซ โครยญ โฆะ อื. เกือฮ โรฮ ป โซม ป ปอน ละ อื ละ โซม อื นึง คระ. ");
INSERT INTO lcp_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ฟวยจ เซ โม เอียกปุ อื เซ อาึง เฮงาะ รวี แตะ นึง รตัง บรัง ยุฮ แตะ, ลอต เอีญ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","เญือม ฮอยจ อื นา ก ซ ไอจ แตะ, ติ ปุย อื โปฮ ฮาื ยุฮ แตะ ละ ซ เกือฮ อื บรัง ยุฮ แตะ โซม. ยุ แม มาื ยุฮ แตะ นึง มวยญ ฮาื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","อัฮ เฮี, “เกียฮ แม อาวต แม โน่ง โตะ มวยญ ฮาื ยุฮ ฮุ เมอ, มาื ยุฮ ฮุ เฮี?” กอก รโฮงะ อื ละ เอียกปุ แตะ ตอก เซ. โม เซ ฮลัต เตีจ ฆาื อื. อู ไม่ ปุ แตะ ไม่ รกุฮ รเตียง แตะ, “ป เกือฮ พะจาว เกิต ละ เอะ เฮี ซ แปน ตอก เมอ แล?” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","เญือม เอีจ ฮอยจ อื เคะ เปือะ แตะ นึง เมือง คะนาอัน เนอ, รโฮงะ อื ละ อื โครยญ เจือ โอเอีฮ ป เกิต ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","อัฮ เฮี, “ปรเมะ ป ตัตเตียง เมือง เซ อัฮ ลปุง ซวก ละ เอะ. โคะ เอะ มัฮ ป ซ ซาวป เลียป โอเอีฮ เมือง แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","เอะ โลยฮ ละ อื ตอก เฮี, ‘เอะ มัฮ โตว โม ป โฮว เลียป เมือง. เอะ มัฮ ปุย เนอึม รพาวม. ");
INSERT INTO lcp_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","เอะ เตือง มู เยอะ มัฮ กวน ติ เปือะ, ไก ไม่ ปุ แตะ กาว ลอา รเมะ. ป มัฮ ปุ รเคะ เอะ อาวต ไม่ เปือะ เกอะ นึง เมือง คะนาอัน. ปุ อุ ติ ปุย อื ปังเมอ เอีจ ยุม,’ เอะ อัฮ เซ ละ. ");
INSERT INTO lcp_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“ปรเมะ ป ตัตเตียง เมือง เซ อัฮ แม เฮี เนิ, ‘อาึ ซ ยุฮ ตอก เฮี ละ ซ ลอง แตะ แลน เมาะ เนอึม รพาวม โม เปะ ไม่ โอ อื เนอึม. เอะ ซ ละ อาึง ปุย ไน โม เปะ เฮี อาวต ไม่ เอะ ติ ปุย. โนก ฮา เซ เอีญ ตาว เฮงาะ เซ ละ กวน เฌือต เปอะ เมิฮ. ");
INSERT INTO lcp_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ดัฮ เปอะ เอีจ โฮว แม โฮ, โรวก ปุ รเคะ เปอะ เซ ไม่ เปอะ, เดอึม อาึ ซ ยุง มัฮ เนอึม เปอะ ปุย เนอึม รพาวม, ไม่ โอ เปอะ มัฮ ป โฮว เลียป เมือง. ดัฮ เปอะ ยุฮ ตอก เซ อาึ ซ พลวย ปุย คัง แตะ อาึง เฮี เกือฮ เอีญ ไม่ เปอะ. ฟวยจ เซ โม เปะ ซ โฮลฮ ลั่ง เปอะ กาไค นึง เมือง เอะ เฮี ลั่ง,’ อัฮ เซ เนิ ปุย เซ.” ");
INSERT INTO lcp_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","เญือม เอีจ โทก โม เซ เฮงาะ ยุฮ แตะ เซ, ยุ เอิน รเพาะ มาื ยุฮ โกะ แตะ นึง อื โครยญ โฆะ แตะ. เญือม ยุ อื มาื ตอก เซ ฮลัต เนอึม ฆาื อื เตือง เปือะ เตือง กวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","เปือะ อื อัฮ เฮี, “โม เปะ เอีจ รกัฮ เปอะ กวน เนอะ ฮา เยอะ. โยเซป เอีจ ยุม ฮา เยอะ. ซิเมโอน ปุ โรฮ เญือะ ไก. ปเลี่ย ฆวต ตุย แม เปอะ เบ่นยามิน ฮา เยอะ ติ แม. อาึ ตุก เนอึม รพาวม เมอะ ฆาื โม เปะ เฮี,” อัฮ เซ ยาโคป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","รูเบ่น อัฮ เฮี, “ตัม โอ อาึ เญือะ เอีญ ตาว แม เบ่นยามิน ละ เปอะ ซ เกือฮ ปะ แง่ โงก กวน อาึ รโตง อื ลอา ปุย. เบ่นยามิน เฮี ซ ลัปลอง อาึ ละ เปอะ. ซ ตาว เนอึม เมอะ,” อัฮ เซ ละ เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ยาโคป อัฮ เฮี, “อาึ ญอม โตว เกือฮ กวน เฮี แตะ โฮว ไม่ เปอะ. เอียก อื เอีจ ยุม. มัฮ ปุย เฮี โน่ง ป ไก ลั่ง. อาึ ฮลัต ซ เกิต ป โอ ไมจ ละ นึง คระ. อาึ เอีจ กวต เอีจ ครา เยอะ. ตัม เกิต แม ป โอ ไมจ ละ กวน เฮี เยอะ, อาึ แจง ซ ยุม นึง ไลจ ลอน รพาวม แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","ฟวยจ เซ ปุย เมือง คะนาอัน ไปลญ แนฮ ลั่ง. ");
INSERT INTO lcp_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","เญือะ ยาโคป เอีจ โซม โอยจ อื เฮงาะ รโกะ โรวก แตะ เน่อึม นึง เมือง อียิป เปอ. ยาโคป อัฮ อื ละ กวน แตะ ตอก เฮี, “ไมจ แม เปอะ โฮว ซาวป รวี เฮงาะ เญี่ยะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ยูด่า อัฮ เฮี ละ อื, “ปรเมะ เซ เอีจ ซตอก ซโตฮ เอะ. อัฮ ติ แตะ โอ เญือะ ซ แลน นา เอะ ดัฮ เอะ โอ ฮอยจ ไม่ ปุ รเคะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ดัฮ เปอะ เกือฮ ปุ อุ เฮี โฮว ไม่ เยอะ เอะ ซ โฮว รวี ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ดัฮ เปอะ โอ เกือฮ โฮว, เอะ ปุ โรฮ ซ โฮว, นึง อัฮ ปรเมะ เซ ติ แตะ โอ เญือะ ซ แลน นา เอะ, ดัฮ โอ โฮว ไม่ ปุ รเคะ แตะ เฮี,” อัฮ เซ ละ เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","อิซราเอน ไฮมญ อื, “เมอยุ รโฮงะ เปอะ ไก ลั่ง ปุ แตะ ละ ปุย เซ, โอ มัฮ ฆวต ยุฮ เปอะ เม่ะมั่ก ละ อาึ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","โม เซ โลยฮ อื, “ปุย เซ เตอ ไฮมญ ที เอะ ฮอยจ ละ ไลลวง เญือะ ม่า ไม่ เอียกปุ อุ. ไฮมญ ไอม ลั่ง ปะ, ไฮมญ โรฮ ไก ลั่ง ปุ อุ. เอะ จัมเปน โลยฮ ละ อื ตัม ซื อื. เญือม อู เยอะ ละ อื เอะ แกต โตว โรฮ ซ ดวน เอะ โรวก ปุ รเคะ แตะ ละ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ยูด่า อัฮ เฮี ละ เปือะ แตะ, “เกือฮ กวน เปอะ เซ โฮว ไม่ อาึ. เอะ ซ โฮว ปเลี่ย เดอึม เอะ โอ ซ ยุม นึง ไปลญ แตะ เตือง เอะ เตือง กวน เนอะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","อาึ ซ ลัปลอง ละ เปอะ. ดัฮ พิต โฮ ไก ไน อาึ. ตัม โอ อาึ ตาว แม ละ เปอะ ไม่ กอ บาึง อื เกือฮ อาึ ลอก ลอป ตุต นึง. ");
INSERT INTO lcp_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","เอะ มัฮ โอ มอง เลี่ญ ตอก เฮี, เอีจ แม แม ติ ลอา โฮน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","เญือม เซ เปือะ อื อัฮ เฮี, “ดัฮ จัมเปน ตอก เซ โฮ, ไมจ เปอะ ยุฮ ตอก เฮี. ไมจ เปอะ ตัง โรวก ป ไมจ เมือง เฮี ง่อน เกือฮ แปน ป เกือฮ เปอะ ละ ปุย เซ. โรวก เยื่อ ปุยฮ โคะ โอ ง่อน, ไม่ รอาวม โกะ แฮ ไม่ ป ซออย ฮงาื, ไม่ เฮลาะ โคะ ชะโมต ง่อน. โรวก โรฮ ไม่ โนง มะมวง ซีโฮ ไม่ โนง อาละมัน เกือฮ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ไมจ โรฮ เปอะ โรวก มาื ลอา เตะ ไพรม อื, ละ ซ รแม่ เปอะ ป อาวต โตะ ฮาื เฮงาะ ยุฮ เปอะ ละ ปุย เซ. ตึน ซ มัฮ โคะ ดุฮ ปุย อื ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","โรวก ปุ รเคะ เปอะ เซ โฮว ไม่ เปอะ ฮอยจ เคะ ปุย เซ เมิฮ. ");
INSERT INTO lcp_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","ปัว พะจาว ป ตึก นึง ระ อัมนัต แตะ เกือฮ ปุย เซ เลียก พาวม นึง โม เปะ, ละ ซ เกือฮ อื เอียกตุ เปอะ ไม่ เบ่นยามิน เอีญ ดิ ไม่ เปอะ. ดัฮ มัฮ ซ จัมเปน แม กวน อาึ ไฆร ง่อน โฮ, เตอึม ตอก มัฮ อื ฮื,” อัฮ เซ ละ กวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","เญือม เซ โม เซ ตุย โรวก ป เกือฮ ป กอยฮ แตะ เซ ไม่ มาื ลอา เตะ ไพรม อื, โฮว ดิ เนอึม ไม่ เบ่นยามิน เญือะ แตะ. โฮว ฮอยจ เมือง อียิป, ลอต เลียก เคะ โยเซป. ");
INSERT INTO lcp_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","โยเซป เซ เญือม ยุ อื ฮอยจ เบ่นยามิน ไม่ โม เอียกระ เอียกตุ แตะ เซ, อัฮ เฮี ละ กวนไจ อาวต เญือะ แตะ, “ตาว โม เฮี เอีญ นึง เญือะ เญะ. มอก ซัตซิง ละ, พรี โซม ตุม ไอฮ ละ. เนฮ ซเง่ะ เอ ซ โซม ดิ ไม่ โม เฮี ติ รโซม,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ปุย เซ ยุฮ เนอึม อื ตัม ดวน โยเซป แตะ. ตาว เนอึม อื ฮอยจ เญือะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","เญือม ตาว อื ฮาวก เญือะ โยเซป เซ โม เซ ฮลัต เตีจ ฆาื อื. ง่อต อื ตอก เฮี, “ปุย เซ ตึน ซ มัฮ ตาว อื เอะ นา เฮี ฆาื มาื ป ดุฮ ปุย โตะ ฮาื เฮงาะ ยุฮ ฮุ โฮน รกา โฮ. โม เฮี ตึน ซ ปุฮ พราวป เอะ. ซ โฮมวต โรวก เอะ แปน ครา แตะ ยุ่ง. ฟวยจ เซ ซ โฮมวต โรวก บรัง ยุฮ ฮุ ไม่ อื,” อัฮ เซ โตะ รพาวม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","เญือม ฮอยจ อื โตะ รเวือะ เญือะ เซ, โม เซ รโซะ ติ แตะ ละ กวนไจ ป อาวต เญือะ โยเซป เซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“จาวไน, ปัว เปอะ ง่อต ป อัฮ เอะ. เญือม ฮอยจ เอะ โฮน รกา ละ ซ รวี แตะ เฮงาะ รโกะ โฮ, ");
INSERT INTO lcp_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","เญือม เอีจ ฮอยจ ก ไอจ แตะ, เอะ ยุ อาวต ลั่ง มาื นึง มวยญ ฮาื ยุฮ แตะ โครยญ โฆะ ปุย. ไก ลั่ง เมาะ ไพรม แตะ. ปเลี่ย เฮี มาื เซ เอะ เอีจ โรวก แม ละ ซ รแม่ แตะ ละ โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","โนก ฮา เซ เอีจ โรวก เกอะ มาื โคระ ละ ซ รวี แตะ เฮงาะ โคระ นึง. เอะ ยุง โตว ป ดุฮ มาื ไพรม เซ โตะ ฮาื เฮงาะ ยุฮ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","ปุย เซ อัฮ เฮี ละ อื, “ปุ ตุก รพาวม ฆาื. ปุ ฮลัต นึง. ตึน ซ มัฮ พะจาว ทื โม เปะ ไม่ พะจาว ป ทื เปือะ เปอะ ป ดุฮ มาื ละ เปอะ โตะ ฮาื เปอะ. อาึ เอีจ โฮลฮ โฮะ มาื ยุฮ เปอะ,” อัฮ เซ. เญือม เซ ตาว ซิเมโอน โอก เคะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","กวนไจ ป อาวต เญือะ โยเซป เซ ตาว ปุย โม เซ เลียก โตะ เญือะ. เกือฮ รอาวม รไซจ เตะ ชวง อื ละ อื. ซาวป เกือฮ ไรป เบระ ละ บรัง ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","โม เซ ฮมอง ตะ โยเซป เอีญ ละ ซ โซม ดิ อื ไม่ แตะ เมาะ ง่อน ซเงะ. เพรียง อาึง ป ซ เกือฮ แตะ เซ ละ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","เญือม เอีจ เอีญ โยเซป เปอ, โม เซ นุ่ม ไว อื ปอ จิ ไกญ แตะ เตะ. เกือฮ โอเอีฮ ป โรวก แตะ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","โยเซป ไฮมญ กอ บาึง อื. อัฮ โรฮ เฮี, “เปือะ เปอะ ป อัฮ โม เปะ เอีจ กวต โฮ, อัม ไอม ลั่ง? อัม กอ ปเลี่ย เฮี?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","โม เซ โลยฮ อื, “เปือะ เกอะ ป มัฮ กวนไจ ยุฮ เปอะ เซ ไอม ลั่ง. กอ โรฮ,” อัฮ เซ. นุ่ม แม ติ แตะ ซองนา โยเซป. ");
INSERT INTO lcp_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","เญือม ยุ โยเซป เบ่นยามิน ปุ เลีฮ แตะ ติ เวียก เซ ไฮมญ โม เซ, “อัม มัฮ ปุย เฮี ปุ รเคะ เปอะ ป รโฮงะ โม เปะ ไลลวง อื ละ อาึ โฮ?” อัฮ เซ. อัฮ โรฮ เฮี ละ เบ่นยามิน, “กวน เฌือต, ปัว พะจาว ปิฮ มุ่น ละ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","โยเซป ไก รพาวม ฆวต เยือม นึง ฮงา ลอน แตะ นึง ยุ แตะ ปุ เลีฮ แตะ เซ. โอก เยือม ฆาื อื ก ไฆลป อื นึง โตะ ฮอง โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ฟวยจ เซ คอยจ นา แตะ. ตุย รพาวม เรียง แตะ โอต โอ แตะ เยือม. โอก ดวน ปุย ปอก โม เซ โซม. ");
INSERT INTO lcp_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","โม กวนไจ อื เซ ปอก โน่ง อื ละ โยเซป ติ โดฮ. ปอก โน่ง อื ละ โม อียิป ติ โดฮ. ปอก อื ละ โม เอียกปุ อื ติ โดฮ, นึง โอ โม อียิป ลัง โซม ดิ ไม่ โม ฮีบรู. ");
INSERT INTO lcp_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ปุย ดวน โม เอียกปุ อื เซ งาวม แปน ไล แตะ ซองนา โยเซป เน่อึม นึง เอียกระ ปุย ฮอยจ ละ ปุ รเคะ ปุย ตัม อาญุ อื. เญือม ยุ อื ตอก เกือฮ ปุย แตะ งาวม ตอก เซ, แลน ปุ แตะ ฆาื อื ไม่ เงอึต แตะ นึง. ");
INSERT INTO lcp_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ปุย ตาว อาวป โตะ ฮงา ละ อื เน่อึม นึง โตะ โซม โยเซป เซ. ป ฮอยจ ละ เบ่นยามิน โฮวน ฮา ปุย ไฮญ พอน เตะ. โม เซ โซม ญุ ไม่ ปุ แตะ ฮอยจ ละ โฮลฮ อื รพาวม มวน แตะ เตือง มู แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","โยเซป บระ ซตอก กวนไจ แตะ ตอก เฮี, “ดุฮ เฮงาะ โตะ ฮาื ยุฮ โม เซ ปอ นาวก อื, เตอึม เมาะ เกียฮ โรวก อื. ฟวยจ เซ ดุฮ แม มาื งวยฮ เฮงาะ เซ โตะ มวยญ ฮาื ยุฮ อื โครยญ โฆะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ฟวยจ เซ อาึง จอก มาื ยุฮ อาึ อื นึง โตะ ฮาื เฮงาะ ยุฮ ปุ รเคะ ปุย เซ. อาึง ดิ ไม่ มาื งวยฮ เฮงาะ ยุฮ อื เซ,” อัฮ เซ ละ อื. ปุย เซ ยุฮ เนอึม อื ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","เมือ กซะ งาวป อื ปุย พลวย โม เซ เอีญ ไม่ บรัง ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","เญือม เอีจ เอีญ อื โปน เวียง เซ เญี่ยะ อา, โยเซป ดวน กวนไจ อาวต เญือะ แตะ เซ ซไจ โฮว อาื โม เซ. ดัฮ เอีจ เครอึป อื ดวน อื อัฮ เฮี ละ อื, “โม เปะ เกียฮ ยุฮ โน่ง เปอะ ป ฆอก ละ เอะ เตือง ยุฮ เอะ ป ไมจ ละ เปอะ เมอ? ");
INSERT INTO lcp_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","เมอยุ บระ เปอะ จอก มาื ยุฮ ปอเลียง อาึ อื? มัฮ จอก ญุ อื รอาวม. มัฮ โรฮ จอก โกว อื ละ ซโปก แตะ. เอีจ ระ เนอึม พิต ป ยุฮ โม เปะ เอ,” ดวน อื อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","เญือม เอีจ เครอึป อื โม เซ, กวนไจ เซ อัฮ เนอึม อื ละ อื ตัม รซอม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","โม เซ โลยฮ อื, “จาวไน, เมอยุ อัฮ เปอะ โอเอีฮ ตอก เซ ละ เอะ เอ? เอะ ป มัฮ กวนไจ ปุย โจฮ เปอะ แจง แน แมน กุน นึง โอ แตะ ยุฮ โอเอีฮ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","เอีจ ยุ เปอะ ไอฮ โรวก เอะ รแม่ มาื ยุ แตะ นึง มวยญ ฮาื ยุฮ ฮุ เซ ละ เปอะ เน่อึม นึง เมือง คะนาอัน เนอ. อัม เง่าะ เซ ซ บระ ลั่ง เอะ ไคร มาื อาวต เญือะ ปอเลียง เปอะ? ");
INSERT INTO lcp_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ดัฮ เปอะ ยุ ไก อื ไม่ เอะ ติ ปุย ไก นึง ป ออฮ ป เอีฮ ญุ่ก, เกือฮ ปุย เซ ลอก ตุต ฮอยจ ละ ยุม แตะ. เอะ เตือง โอยจ เจอ ซ ญอม โรฮ แปน ครา เปอะ ไม่ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","ปุย เซ โลยฮ อื, “ปุก โรฮ ป อัฮ เปอะ เซ. เกือฮ แปน ตอก อัฮ เปอะ เซ เมิฮ. ไก จอก เซ ไม่ ป ออฮ ปุย เซ ซ แปน ครา อาึ. ปุย ไฮญ นึง อื ซ ลอก โตว ตุต แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","โม เซ ซไจ โปต รตัง บรัง ยุฮ แตะ ฆาื อื ลังเตะ. กัฮ โม่ะ ปุก ฮาื ยุฮ แตะ โครยญ โฆะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","กวนไจ อาวต เญือะ โยเซป เซ ซาวป แลน ที อื นึง ฮาื ยุฮ โม เซ, เน่อึม นึง เอียกระ ปุย ฮอยจ ละ ปุ รเคะ ปุย นึง อื. ยุ จอก เซ นึง ฮาื ยุฮ เบ่นยามิน. ");
INSERT INTO lcp_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","โม เอียกปุ อื เซ แจฮ ไอฮ เครอึง แตะ นึง ตุก รพาวม แตะ. ตัง แม เฮงาะ นึง รตัง บรัง เซ. แม แม ไม่ อื ฮอยจ โตะ เวียง. ");
INSERT INTO lcp_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","เญือม ฮอยจ ยูด่า ไม่ โม เอียกปุ แตะ นึง เญือะ อื เซ, โยเซป อาวต ลั่ง นึง เญือะ แตะ. โม เซ นุ่ม ติ แตะ ปอ จิ ไกญ แตะ เตะ ซองนา อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","โยเซป ไฮมญ อื, “เมอ ป ริ โม เปะ ยุฮ ฮู? อัม มัฮ โอ เปอะ ยุง มัฮ อาึ ปุย เกียฮ ยุง โอเอีฮ เบือ ซโปก แตะ?” เคียต อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ยูด่า โลยฮ อื, “จาวไน, เอะ ซ เกียฮ กัฮ ลั่ง ติ แตะ ตอก เมอ? เญือะ เกียฮ อัฮ โตว ติ แตะ โอ พิต. เญือะ เกียฮ เก โตว เปอะ. พะจาว เอีจ เกือฮ อื โอก มั่ป ยุฮ ฮุ. ปเลี่ย เอะ ญอม แปน ครา เปอะ เตือง โอยจ แตะ เตือง ป ยุ เปอะ ไก จอก นึง รบุยฮ อื ไม่ โม เอะ เตือง โอยจ เจอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","โยเซป อัฮ เฮี, “แปน โตว ตอก เซ. อาึ เกียฮ ยุฮ โตว ป โอ ซื ตอก เซ. ป ซ โฮลฮ แปน ครา อาึ อื มัฮ ป ยุ ปุย ไก จอก เซ นึง โตะ ฮาื อื ติ ปุย โน่ง. ปุย ไฮญ ซ เกือฮ เอีญ ไมจ เอีญ มวน เคะ เปือะ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","เญือม เซ ยูด่า เลียก ซดิ ไม่ อื. อัฮ เฮี, “จาวไน, อาึ ป มัฮ กวนไจ ปุย โจฮ ยุฮ เปอะ ปัว ลปุง ไม่ เปอะ ติ มวยญ. ปัว เปอะ โอ รอก พาวม นึง อาึ. ปะ เอีจ เมาะ โรฮ เปอะ ฟาโร เนิ. ");
INSERT INTO lcp_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","จาวไน, ปะ เอีจ ไฮมญ เปอะ เอะ ตอก เฮี, ‘เปือะ เปอะ ไม่ ปุ เปอะ อัม ไก ลั่ง?’ อัฮ เปอะ เซ เนิ. ");
INSERT INTO lcp_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","เอะ เอีจ รโฮงะ ละ เปอะ เอีจ กวต เปือะ เกอะ. อัฮ ติ แตะ ไก ปุ ละ เปอะ ติ, ป เกิต ละ เปือะ เกอะ เญือม เอีจ กวต อื. เอียก ทัต ปุย เซ เอีจ ยุม. มัฮ ลั่ง ปุ เฮี เยอะ โน่ง ป ไอม นึง อื กวน ติ มะ เซ. เปือะ เกอะ ฮรัก เนอึม อื, เอะ เอีจ อัฮ เซ ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“จาวไน, ปะ ดวน เปอะ เอะ โรวก ปุ รเคะ แตะ เซ ฮอยจ เคะ เปอะ นา เฮี ละ ซ โฮลฮ เปอะ ยุ. ");
INSERT INTO lcp_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","เอะ เอีจ รโฮงะ ละ เปอะ โอ ปุย เซ เกียฮ โอก ฮา เปือะ เกอะ, นึง ฮอ แตะ นึง ซ ยุม เปือะ เกอะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","เญือม เซ ปะ อัฮ เปอะ เฮี เนิ, ‘ซ โฮลฮ เปอะ โตว ยุ นา อาึ แม ดัฮ ปุ รเคะ เปอะ โอ ฮอยจ ไม่ เปอะ,’ อัฮ เปอะ เซ เนิ. ");
INSERT INTO lcp_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","เญือม เอีจ ฮอยจ เคะ เปือะ เกอะ เอะ อู ละ อื ป อัฮ เปอะ เนิ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“กังเคะ เอ เปือะ เกอะ ดวน เอะ โฮว รวี แม เฮงาะ รโกะ เญี่ยะ. ");
INSERT INTO lcp_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","เอะ อัฮ ติ แตะ โอ เกียฮ โฮว ละ ดัฮ ปุ รเคะ เอะ โอ ฮอยจ ไม่ เยอะ. ดัฮ โอ ฮอยจ ไม่ เอะ โฮ, เอะ อัฮ ติ แตะ โอ เญาะ ซ โฮลฮ ยุ นา ปะ ละ เปือะ เกอะ. ");
INSERT INTO lcp_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“เปือะ เกอะ อัฮ เฮี เนิ, ‘โม เปะ เอีจ ยุง เปอะ, ราเชน ปรโปวน เญือะ อาึ ไก กวน ลอา โน่ง. ");
INSERT INTO lcp_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","เอีจ ไฆร ติ. ตึน ซ มัฮ เกียต กุก โกะพริ อื. อาึ ลอต โอ เญือะ โฮลฮ ยุ. ");
INSERT INTO lcp_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ดัฮ เปอะ ตุย แม ปุย เฮี ฮา เยอะ ดัฮ เกิต แม ป โอ ไมจ ละ โฮ, อาึ เตอ มัฮ ตะ กวต, ตึน ซ ยุม เนอึม นึง ตุก รพาวม แตะ,’ อัฮ เซ เนิ เปือะ เกอะ. ");
INSERT INTO lcp_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“จาวไน, ปเลี่ย เฮี ดัฮ อาึ เอีญ เคะ เปือะ เกอะ เตือง โอ แตะ โฮลฮ โรวก กวน อื เซ ละ อื โฮ, เญือม ยุ อื โอ ปุย เซ เอีญ ไม่ เยอะ แจง ซ ยุม เอิน อื. จีวิต เปือะ เกอะ เอีจ รโจะ ดิ ไม่ จีวิต กวน แตวะ อื เซ. เอะ ป มัฮ กวนไจ ยุฮ เปอะ ซ แปน ป ยุฮ ยุม ไม่ เปือะ เกอะ เซ ฆาื ตุก รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","โนก ฮา เซ อาึ เอีจ ลัปลอง เงอะ ละ เปือะ เกอะ นึง ซ ตาว แม แตะ ปุ แตะ เฮี ละ อื. อาึ เอีจ อัฮ ติ แตะ ซ ญอม ลอก ตุต นึง ติ เจน ไอม แตะ ดัฮ อาึ โอ เอีญ ตาว แม ละ เปือะ เกอะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“จาวไน, ปัว เปอะ เกือฮ อาึ อาวต ไม่ เปอะ. อาึ ซ ญอม แปน ครา เปอะ ตัง กวนดุ เซ. ปัว จาวไน เกือฮ อื เอีญ ไม่ โม เอียกปุ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","อาึ อัม เกียฮ เอีญ เคะ เปือะ เกอะ ดัฮ กวนดุ เซ โอ เอีญ ไม่ เยอะ โฮ? อาึ ซ ปุน ยุ โตว อาวต เปือะ เกอะ ไม่ รพาวม ตุก ลัมเลือ แตะ ตอก เซ แม,” อัฮ เซ ละ โยเซป ยูด่า เยอ. ");
INSERT INTO lcp_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","เญือม เซ โยเซป เญือะ ปุน คัม โตว รพาวม แตะ. ฮลัต ติ แตะ โคะ เยือม ซองนา โม กวนไจ แตะ. ดวน โม เซ โอก ฮา แตะ แกล. มัฮ เซ ป โอ อื ไก ปุย ไฮญ โตะ เญือะ เซ ฆาื อื เญือม รโฮงะ โยเซป ติ แตะ ละ โม เอียกปุ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","โยเซป เยือม เรียง ปอ เอิน ฮมอง โม อียิป ป อาวต ก พริ อื, ฮอยจ โรฮ ละ ฮมอง เญือะ กซัต ไลลวง อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","โยเซป อัฮ เฮี, “อาึ มัฮ โยเซป. อัม ไอม เนอึม ลั่ง เปือะ เกอะ?” อัฮ เซ. โม เอียกปุ อื เญือม ฮมอง อื ตอก เซ ฮลัต เตีจ ปอ โอ แตะ เญาะ เกียฮ โลยฮ. ");
INSERT INTO lcp_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","โยเซป ดวน อื เลียก ซดิ. เญือม เอีจ เลียก อื อัฮ เฮี ละ อื, “อาึ มัฮ โยเซป ปุ โม เปะ โฮ. เอีจ มัฮ อาึ เฮี ป โชะ โม เปะ ฮอยจ เมือง อียิป โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ปุ ตุก รพาวม ฆาื. ปุ เติ โกะ เปอะ ฆาื, นึง โชะ เปอะ อาึ ฮอยจ นา เฮี. เอีจ มัฮ พะจาว ป เกือฮ อาึ ฮอยจ รกา โม เปะ เอ, นึง ซ เรอึม อื ปุย เกือฮ ไอม. ");
INSERT INTO lcp_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","เอีจ ไก ลอา เนอึม ไปลญ เออึป ปุย เตือง ปลัฮเตะ อื. ซ ไก ลั่ง พอน เนอึม โอ ปุย ซ เกียฮ ไท ชิจ มัก เฮงาะ ออ. ");
INSERT INTO lcp_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","พะจาว เอีจ เกือฮ อาึ โฮว รกา โม เปะ ละ ซ เกือฮ อื โม เปะ ไอม, ไม่ ซ เกือฮ อื โม เปะ ไก ลั่ง จัตเจือ นึง ปลัฮเตะ เฮี. กัน เฮี มัฮ กัน ระ ไล ปอ เงอึต ปุย นึง. ");
INSERT INTO lcp_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“เคียง มัฮ อื ตอก เซ มัฮ โตว โม เปะ ป เกือฮ อาึ ฮอยจ นา เฮี. มัฮ พะจาว. พะจาว เอีจ เกือฮ อาึ โฮลฮ แปน จาวไน ระ ฮา ปุย ละ ฟาโร. เอีจ เกือฮ อาึ โฮลฮ กุม ลุกจุ ไพเมือง แตะ เตือง โอยจ อื. อาึ โฮลฮ ตัตเตียง เมือง อียิป เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","ไมจ โม เปะ ซไจ เอีญ. อัฮ ละ เปือะ เกอะ, ‘โยเซป ป มัฮ กวน เปอะ ดวน ปะ ฮอยจ เคะ แตะ. ปุ มอง เลี่ญ. พะจาว เอีจ เกือฮ อื แปน ป กุม โอเอีฮ เลี่ป เมือง อียิป,’ ไมจ เปอะ อัฮ เซ ละ. ");
INSERT INTO lcp_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","อาึ ซ เกือฮ เปือะ เกอะ อาวต นาตี เมือง โกเชน ละ ซ โฮลฮ อื อาวต ซดิ ไม่ อาึ, เตือง โกะ อื ไม่ กวน อื ไม่ กวนโซะ อื, เตือง คอง เลียง คอง ดู่ อื ไม่ โอเอีฮ ยุฮ อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","อาึ ซ แลน แก เปือะ เกอะ นา เซ นึง ซ ไก ลั่ง อื พอน เนอึม ซ ไปลญ ปุย เยอ. อาึ ฆวต เกือฮ โตว เญือะ เปือะ เกอะ ไม่ คอง เลียง คอง ดู่ อื อาวต ไม่ โซะ ไซญ ไปลญ เออึป แตะ, ไมจ เปอะ อัฮ ละ เปือะ เกอะ ตอก เซ.” ");
INSERT INTO lcp_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","โยเซป อัฮ แม เฮี, “โม เปะ เตือง โอยจ เปอะ ไม่ เบ่นยามิน เญือะ อะ เฮี เอีจ ยุ ตื เปอะ นึง ไง่ แตะ มัฮ อาึ โยเซป ป อู ไม่ เปอะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ไมจ เปอะ อู ละ เปือะ เกอะ ตอก โฮลฮ อาึ โญตซัก แตะ นึง เมือง อียิป เฮี, ไม่ โอเอีฮ ไฮญ ป ยุ เปอะ เฮี. เกือฮ ติ เปอะ ไกลจ ฮอยจ ไม่ เปือะ เกอะ นา เฮี โอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","โยเซป ไม่ เบ่นยามิน โอม ปุ แตะ. เยือม ไม่ อื เตือง ลอา แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","โยเซป โอม โรฮ โม เอียกปุ ไฮญ แตะ เตือง โอยจ อื. ฮงาึต อื. เยือม ไม่ อื. เญือม เซ โม เอียกปุ อื ลอต อู ดิ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ฟาโร ไม่ โม กวนไจ ยุฮ อื เญือม ฮมอง อื คราว เอีจ ฮอยจ เอียกปุ โยเซป เคะ อื ตอก เซ, มวน โรฮ รพาวม ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ฟาโร อัฮ เฮี ละ โยเซป, “เกือฮ โม เอียกปุ เปอะ เซ ตัง ปุ เอีญ เฮงาะ รโกะ ฮอยจ เมือง คะนาอัน. ");
INSERT INTO lcp_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","ฟวยจ เซ เกือฮ โรวก เปือะ แตะ ไม่ กวน เฌือต แตะ แม ฮอยจ นา เฮี. ชิจ โดว ตึก นึง ไมจ แตะ ไน เมือง อียิป เฮี อาึ ซ เกือฮ ละ อื. ซ เกือฮ โฮลฮ โซม ญึม ไอจ ไมจ. ");
INSERT INTO lcp_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“ไมจ เปอะ เกือฮ โรวก เลาะ เน่อึม นึง เมือง อียิป ละ ซ เกือฮ โม ปรโปวน ไม่ โม กวนดุ โฮลฮ บุก. เกือฮ โรฮ โรวก เปือะ เปอะ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ปุ เญือะ เกือฮ ตุก รพาวม นึง คอง ญอย ญัม ลั่กเคะ แตะ. โอเอีฮ ตึก นึง ไมจ แตะ เมือง อียิป เฮี ซ เกือฮ ละ อื,” อัฮ เซ ละ โยเซป ฟาโร เซ. ");
INSERT INTO lcp_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","เญือม เซ กวน อิซราเอน ยุฮ เนอึม อื ตอก เซ. โยเซป เกือฮ เนอึม เลาะ ละ อื ตัม ป อัฮ ฟาโร อาึง. เกือฮ โรฮ ป โซม ป ปอน ละ อื ละ ซ โซม อื นึง คระ. ");
INSERT INTO lcp_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","เกือฮ เครอึง เซอึก ละ อื ติ ปุย ติ จุม. ละ เบ่นยามิน ปังเมอ เกือฮ อื ละ อื พอน จุม ไม่ มาื ลอวย รอย เชเคน. ");
INSERT INTO lcp_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","โยเซป รโปะ โอเอีฮ ป ตึก นึง ไมจ แตะ นึง เมือง อียิป ละ เปือะ แตะ กาว รตัง บรัง. รโปะ โรฮ รโกะ ไม่ คโนมปัง ไม่ ป โซม ไฮญ ละ ซ โซม อื นึง คระ. มัฮ โรฮ กาว รตัง บรัง โกวน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","เญือม เซ เกือฮ เอียกปุ แตะ เอีญ. อัฮ เฮี ละ อื, “เอีญ เมิฮ. ปุ รเจ ไม่ ปุ เปอะ นึง คระ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","โม เอียกปุ อื เซ เอีญ เนอึม ฮา เมือง อียิป ฮอยจ เคะ เปือะ แตะ เมือง คะนาอัน. ");
INSERT INTO lcp_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","เญือม เอีจ ฮอยจ อื เคะ เปือะ แตะ อัฮ เฮี ละ อื, “เปือะ, โยเซป ไอม ลั่ง. โฮลฮ แปน ป ตัตเตียง เมือง อียิป เตือง เมือง อื,” อัฮ เซ ละ อื. ยาโคป เงอึต ฆาื ป ฮมอง แตะ เซ. เจือ โตว ป อัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","เญือม เซ โม เซ อู อื ละ อื แปน ไล อื ตัม ป อัฮ โยเซป ละ แตะ. เญือม ยุ ยาโคป เลาะ ป รโปะ โยเซป ละ แตะ เซ ลอต เอิน โฮลฮ รพาวม เรียง แตะ เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","ยาโคป อัฮ เฮี ฆาื อื, “เอีจ ปอ นึง พาวม เมอะ. โยเซป ไอม เนอึม ลั่ง เนิ เยือก. อาึ ซ โฮลฮ เนอึม โฮว ยุ นา อื กา ยุม แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","ยาโคป แฮรป เนอึม เครอึง แตะ โฮว เตือง เญือะ เตือง ม่า แตะ. เญือม ฮอยจ อื นึง ย่วง เบ่เออเชบ่า ไววอน, ทไว โอเอีฮ ละ พะจาว ทื ยิซฮัก ป มัฮ เปือะ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","เมือ ก ซาวม อื ยาโคป ยุ บลอง พะจาว. ฮมอง กอก อื มอยฮ แตะ ตอก เฮี, “ยาโคป, ยาโคป,” ฮมอง อัฮ อื เซ ละ แตะ. “โอ พะจาว, อาึ อาวต นา เฮี,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","พะจาว อัฮ เฮี ละ อื, “อาึ มัฮ พะจาว. มัฮ พะจาว ทื เปือะ เปอะ. ปุ ฮลัต นึง ซ เลีฮ เปอะ เมือง อียิป เปอ. อาึ ซ เกือฮ โม เปะ พรุฮแพร นา เซ แปน ปุย ติ เมือง ระ. ");
INSERT INTO lcp_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","อาึ ซ เลีฮ ไม่ เปอะ นึง เมือง อียิป. อาึ แจง ซ โรวก โม จัตเจือ เปอะ แม แม ฮอยจ นา เฮี. เญือม ยุม เปอะ โยเซป ซ มอง แลน รพาวม เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ฟวยจ เซ ยาโคป โอก ฮา ย่วง เบ่เออเชบ่า. โม กวน อื เกือฮ ยาโคป ไม่ กวน แตะ ไม่ ปุย เญือะ แตะ บุก ปุ โฮว เลาะ เกือฮ ฟาโร ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","โรวก คอง เลียง คอง ดู่ แตะ ไม่ คาวคอง โฮลฮ แตะ นึง เมือง คะนาอัน เซ. โฮว ไม่ อื ฮอยจ เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ยาโคป โฮว เนอึม ไม่ กวน เฌือต แตะ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","มอยฮ กวน เฌือต อิซราเอน ป เลียก เมือง อียิป เซ มัฮ ตอก เฮี. มัฮ รูเบ่น ป มัฮ กวน โรง อื. ");
INSERT INTO lcp_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","กวน รูเบ่น เซ มัฮ ฮาโนก, ปันลู, เฮซโรน, ไม่ คารมี. ");
INSERT INTO lcp_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","กวน ซิเมโอน มัฮ เยมูเอน, ยามิน, โอฮัต, ยาคิน, ไม่ โซฮา. มัฮ โรฮ ชาอุน ติ. มะ ชาอุน เซ มัฮ ปรโปวน เมือง คะนาอัน. ");
INSERT INTO lcp_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","กวน เลวี มัฮ เกอโชน, โคฮัต, ไม่ เมรารี. ");
INSERT INTO lcp_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","กวน ยูด่า มัฮ เอ, โอนัน, เชลา, เปเรต, ไม่ เซรา. ป มัฮ เอ ไม่ โอนัน เซ เอีจ ยุม เญือม อาวต ลั่ง แตะ เมือง คะนาอัน. กวน เปเรต มัฮ เฮซโรน ไม่ ฮามุน. ");
INSERT INTO lcp_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","กวน อิตซคา มัฮ โทลา, ปูวา, โยป, ไม่ ชิมโรน. ");
INSERT INTO lcp_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","กวน เซบู่ลุน มัฮ เซเรต, เอโลน, ไม่ ยาเลเอน. ");
INSERT INTO lcp_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","ปุย โม เซ มัฮ ตื กวน เฌือต ยาโคป ไม่ เลอา ป เกิต นึง เมือง ปัตดั่น อารัม. กวน รโปวน อื มัฮ ดี่นา. กวน เฌือต เกิต นึง อื ไก 33 ปุย เตือง ปรเมะ ปรโปวน. ");
INSERT INTO lcp_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","กวน กาต มัฮ ซิฟีโยน, ฮักกี, ชูนี, เอซโบ่น, เอรี, อาโรดี่, ไม่ อาเรลี. ");
INSERT INTO lcp_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","กวน อาเชอ มัฮ อิมนา, อิชวา, อิชวี, เบ่รียา, ไม่ เซรา ป มัฮ รนัน อื. กวน เบ่รียา มัฮ เฮเบ่อ ไม่ มันคีเอน. ");
INSERT INTO lcp_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","ปุย โม เซ มัฮ กวน เฌือต ยาโคป ไม่ ซีละปา ป เกือฮ ลาบั่น ละ เลอา ป มัฮ กวน แตะ เซ. ไก 16 ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","กวน ราเชน ปรโปวน เญือะ ยาโคป มัฮ โยเซป ไม่ เบ่นยามิน. ");
INSERT INTO lcp_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","โยเซป ไก กวน ลอา, มัฮ มะนาเซ ไม่ เอฟราอิม. มัฮ ป เกิต นึง เมือง อียิป เซ. มะ อื มัฮ อาเซนัต กวน โปทีเฟรา ป มัฮ ซตุ เมือง โอน. ");
INSERT INTO lcp_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","กวน เบ่นยามิน มัฮ เบ่ลา, เบ่เคอ, อัตชเบ่น, เกรา, นาอามัน, เอไฮ, โรต, มัปปิม, ฮุปปิม, ไม่ อัต. ");
INSERT INTO lcp_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","ปุย โม เซ มัฮ กวน เฌือต ยาโคป ไม่ ราเชน. ไก 14 ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","กวน ด่าน มัฮ ฮุชิม. ");
INSERT INTO lcp_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","กวน นัปทาลี มัฮ ยาเซเอน, กูนี, เยเซอ, ไม่ ชินเลม. ");
INSERT INTO lcp_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","ปุย โม เซ มัฮ กวน เฌือต ยาโคป ไม่ บิ่นฮา ป เกือฮ ลาบั่น ละ ราเชน ป มัฮ กวน แตะ. ไก 7 ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","กวน เฌือต ยาโคป ป โฮว ดิ ไม่ อื ฮอยจ เมือง อียิป เซ ไก 66 ปุย. เมีญ โตว โมวน แตะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","กวน โยเซป ป เกิต นึง เมือง อียิป ไก ลอา. เญือะ ยาโคป ป เลีฮ อาวต นึง เมือง อียิป เซ เตือง โอยจ อื แปน ไก อาลแฆลฮ ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ยาโคป ดวน ยูด่า โฮว กา แตะ ละ ซ เกือฮ อื ฮอยจ เคะ โยเซป. เกือฮ โยเซป ฮอยจ เคะ แตะ นึง เมือง โกเชน. ");
INSERT INTO lcp_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","เญือม ฮอยจ ปุย โฮวน เซ นึง เมือง โกเชน เนอ, โยเซป บุก ปุ โฮว เลาะ รุป เซิก ยุฮ แตะ, โฮว ฮอยจ เมือง โกเชน เซ ละ ซ โฮลฮ อื ยุ เปือะ แตะ. เญือม เอีจ ยุ อื เปือะ แตะ เซ โยเซป โอม เอิน อื. เยือม ไม่ อื เลี่ญ. ");
INSERT INTO lcp_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","ยาโคป อัฮ เฮี, “ปเลี่ย เฮี อาึ เอีจ ญึม ยุม เมอะ นึง เอีจ โฮลฮ แตะ ยุ นึง ไง่ โกะ แตะ ไอม ลั่ง ปะ อา,” อัฮ เซ ละ โยเซป. ");
INSERT INTO lcp_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","โยเซป อัฮ เฮี ละ โม เอียกปุ คระ เฌือต แตะ เตือง โอยจ อื, “ไมจ อาึ โฮว รโฮงะ ไลลวง โม เปะ ละ ฟาโร ตอก เฮี, ‘โม เอียกปุ อู ไม่ เญือะ เปือะ เกอะ ป อาวต นึง เมือง คะนาอัน ไพรม อื เซ, ปเลี่ย เฮี เอีจ ฮอยจ เคะ อาึ,’ ไมจ อาึ อัฮ เซ ละ. ");
INSERT INTO lcp_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ซ ไมจ รโฮงะ ละ อื มัฮ โม เปะ ป เลียง แกะ เลียง ปิ อี. เอีจ ฮอยจ เปอะ ไม่ แกะ ไม่ ปิ ไม่ โมวก โอเอีฮ ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ดัฮ ฟาโร ไฮมญ โม เปะ นึง ไลลวง กัน ริ เปอะ โซม โฮ, ");
INSERT INTO lcp_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","โม เปะ ไมจ เปอะ โลยฮ ละ อื ตอก เฮี, ‘เอะ ป มัฮ กวนไจ เปอะ มัฮ ป เลียง แกะ เน่อึม เญือม กวนดุ แตะ ตอก ยุฮ มะเปือะ ตะเยือะ แตะ โรฮ,’ ไมจ เปอะ อัฮ เซ ละ. เญือม เซ ซ เกือฮ โม เปะ โฮลฮ อาวต นึง นาตี โกเชน ฆาื อื.” ป อัฮ โยเซป เซ ฆาื อื มัฮ ฆาื รแอม โม อียิป เซ นึง โม ป เลียง แกะ เลียง ปิ. ");
INSERT INTO lcp_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","โยเซป โฮว รโฮงะ อื ละ ฟาโร ตอก เฮี, “เปือะ เกอะ ไม่ โม เอียกปุ อุ เตือง คอง เลียง คอง ดู่ อื ไม่ คาวคอง อื เตือง โอยจ อื เอีจ โอก ฮา เมือง คะนาอัน, เอีจ ฮอยจ นึง เมือง โกเชน ปเลี่ย เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","เญือม เซ โยเซป เลือก เอียกปุ แตะ พอน ปุย ตาว โรฮ อื ฮอยจ เคะ ฟาโร. ");
INSERT INTO lcp_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ฟาโร ไฮมญ โม เซ, “โม เปะ มัฮ กัน ตอก เมอ กัน ริ เปอะ โซม เมอ?” อัฮ เซ ละ อื. โม เซ โลยฮ อื, “เอะ ป มัฮ กวนไจ ยุฮ เปอะ มัฮ โม ป เลียง แกะ เลียง ปิ ตอก โรฮ มะเปือะ ตะเยือะ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","เอะ ปัว ฮอยจ อาวต นา เฮี ติ วัง นึง ไปลญ เนอึม เมือง คะนาอัน ปอ เอิน โอ คอง เลียง เงอะ เญือะ ไก ป โซม. ปัว เปอะ เกือฮ เอะ อาวต นึง เมือง โกเชน ดัฮ แปน โฮ,” อัฮ โรฮ เซ ละ ฟาโร. ");
INSERT INTO lcp_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ฟาโร อัฮ เฮี ละ โยเซป, “เปือะ เปอะ ไม่ เอียกปุ เปอะ เอีจ ฮอยจ เคะ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ติ เมือง อียิป เฮี อาึ คัต โตว ฮา อื ติ โดฮ เนอึม. เกือฮ อาวต นึง เมือง โกเชน เซ. เกือฮ โรฮ ไอฮ นาตี ก ตึก นึง ไมจ แตะ นึง อื. ดัฮ ไก โม ป ไมจ พันญา ฮา ปุย ไฮญ นึง อื, เกือฮ โรฮ โม เซ แลน แก คอง เลียง ยุฮ อาึ ไม่ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ฟวยจ เซ โยเซป ตาว ยาโคป ป มัฮ เปือะ แตะ เซ ฮอยจ โรฮ เคะ ฟาโร. ยาโคป ปิฮ มุ่น ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ฟาโร ไฮมญ อื, “ไก ซดุ เนอึม อาญุ เปอะ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ยาโคป โลยฮ อื, “เอีจ ไก ติ รอย ไปล ง่วย เนอึม อาึ มัฮ ปุย โอ ไก เญือะ อาวต คราว โซม นึง ปลัฮเตะ เฮี, ไม่ โฮว ไป โฮว มา ลอป แตะ. อาญุ อาึ เงี่ยง นึง อาวต ลอป ไม่ เม่ะมั่ก แตะ. ลั่ง เลี่ญ โตว อาวต ตอก จัตเจือ ไพรม เมอะ ป โฮว ไป โฮว มา นึง ปลัฮเตะ โฆะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","เญือม เซ ยาโคป ปิฮ แม มุ่น ละ ฟาโร. ฟวยจ เซ เอีญ ฮา อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","โยเซป ซาวป ก อาวต เปือะ แตะ ไม่ โม เอียกปุ แตะ, เกือฮ อื แปน คอง อื ละ ซ โฮลฮ อื อาวต ลอป นึง. มัฮ เตะ ตึก นึง ไมจ แตะ นึง นาตี ย่วง ราเมเซต นา ก โฮลฮ อื อาวต ตัม รซอม ดวน ฟาโร แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","โยเซป เกือฮ ป โซม ป ปอน ละ เญือะ เปือะ แตะ ไม่ โม เอียกปุ แตะ ตัม เมาะ โฮวน เมาะ รมัฮ กวน อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","เญือม เซ ปุย โครยญ โดฮ อาวต ตื ไม่ ไปลญ เออึป แควะ คัต แตะ. ปุย เมือง อียิป ไม่ เมือง คะนาอัน รเกือะ ชุมเรียง ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","เญือม ฮอยจ รวี ปุย เฮงาะ รโกะ นึง อื, โยเซป ตาว มาื ฮอยจ ละ เญือะ กซัต เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","เญือม เอีจ โอยจ มาื เมือง อียิป ไม่ เมือง คะนาอัน เนอ, โม อียิป ฮอยจ เคะ โยเซป. ปัว นึง อื ตอก เฮี, “ปัว ไอม ไม่ เปอะ. ปัว เปอะ เกือฮ ป โซม ป ปอน เนิ. เอะ เอีจ โอยจ ซง่ะ มาื ยุฮ ฮุ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","โยเซป โลยฮ อื, “ดัฮ เปอะ โอ เญือะ ไก มาื ยุฮ โฮ, โรวก คอง เลียง คอง ดู่ เปอะ ละ อาึ. อาึ ซ เกือฮ โรฮ ป โซม ป ปอน นึง ละ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","โม เซ โรวก เนอึม อื ละ อื. โยเซป เกือฮ เนอึม ป โซม ป ปอน ละ อื. รตู อื ละ อื ไม่ บรอง บรัง ครัก โมวก ปิ แกะ โอเอีฮ ยุฮ อื. ไน ติ เนอึม เซ โยเซป เกือฮ อื โซม เบือ คอง เลียง คอง ดู่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","เนอึม ติ อื แม, ปุย ฮอยจ แม เคะ อื. อัฮ เฮี ละ อื, “เอะ เกียฮ เม่าะ โตว โซะไซญ แตะ ฮา เปอะ. มาื ยุฮ ฮุ เอีจ โอยจ. คอง เลียง คอง ดู่ เยอะ เอีจ แปน โอยจ คอง ปะ. เอะ เญือะ ไก โตว ป ติ ป เตอื ยุฮ ละ ซ เกือฮ แตะ ละ เปอะ, โนก ฮา ตัว โกะ โอะ ไม่ เบือง เญือะ เบือง ม่า ยุฮ ฮุ. ");
INSERT INTO lcp_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ปัว เปอะ โอ เกือฮ เอะ ยุม นึง ไปลญ แตะ, ไม่ โอ เปอะ เกือฮ รปึม ยุฮ ฮุ ฮัง เยือ. รวี เอะ เฮี ไม่ เญือะ ม่า ยุฮ ฮุ นึง ป โซม ป ปอน เนอะ. เอะ ซ ญอม แปน กวนไจ ฟาโร. ซ เกือฮ ฟาโร กุม ชิจ กุม ม่า ยุฮ แตะ. ปัว เปอะ เกือฮ เฮงาะ รโกะ เนิ เดอึม ซ เกียฮ ไอม. เกือฮ โรฮ เฮงาะ ซมา เนิ เดอึม ซ เกียฮ ซมา,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","โยเซป รวี เนอึม เบือง ชิจ เบือง ม่า ติ เมือง อียิป เซ ละ ฟาโร เตือง โอยจ อื. โม อียิป โครยญ โฆะ ปุย จัมเปน โชะ เตะ ยุฮ แตะ นึง โซะ ไซญ ไปลญ เออึป แตะ. ลอต แปน เตะ ยุฮ ฟาโร เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ปุย ติ เมือง อียิป เซ โยเซป เกือฮ อื แปน กวนไจ ฟาโร เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","มัฮ เตะ ยุฮ โม ซตุ โน่ง ป โอ อื รวี, นึง โฮลฮ โม ซตุ เซ ป โซม ป ปอน แตะ เน่อึม นึง ฟาโร. จัมเปน โตว โชะ เตะ ยุฮ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","โยเซป อัฮ เฮี ละ โม ลัปซด่อน, “ง่อต แลน. ปเลี่ย เฮี อาึ เอีจ รวี โม เปะ ไม่ เตะ ยุฮ เปอะ ละ ฟาโร. เฮิ เฮงาะ ซมา เยอ. เกือฮ ละ เปอะ ละ ซ ซมา เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","เญือม เอีจ เฟือฮ เบระ ยุฮ เปอะ เฮงาะ โฮลฮ เปอะ พอน ปุน, ไมจ เปอะ เกือฮ ละ ฟาโร ติ ปุน. ปาวน ปุน อื เซ ไอฮ ไอฮ ละ โซม โกะ เปอะ ไม่ กวน เฌือต เปอะ เมิฮ, ละ โรฮ ละ ซมา เปอะ ง่อน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","โม ลัปซด่อน อัฮ เฮี, “จาวไน, เอีจ โพต เปอะ เอะ เกือฮ ไอม. เอีจ ระ เนอึม กุนมุ่น ยุฮ เปอะ ละ เอะ เอ. เอะ ญอม แปน กวนไจ ยุฮ ฟาโร,” อัฮ เซ ละ โยเซป. ");
INSERT INTO lcp_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","โยเซป ลอต เกือฮ อื แปน โกตไม เมือง อียิป ตอก เซ. โอเอีฮ พอน ปุน ลัง ฮอยจ ละ ฟาโร ติ ปุน. โกตไม เซ โกว ลั่ง อื ฮอยจ ปเลี่ย. มัฮ เตะ ยุฮ โม ซตุ โน่ง ป โอ โฮลฮ แปน คอง ฟาโร. ");
INSERT INTO lcp_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","โม อิซราเอน อาวต เมือง อียิป นึง นาตี โกเชน นึง อื. กอย ปุ ปุ. พรุฮแพร นา เซ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ยาโคป อาวต เมือง อียิป กาว โรฮ อาแลฮ เนอึม, อาญุ ยาโคป เตือง โอยจ อื ฮาวก ติ รอย ไปล รปาวน โรฮ อาแลฮ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","เญือม เอีจ ซดิ ซ ยุม อื, อิซราเอน กอก โยเซป เอีญ เคะ แตะ. อัฮ เฮี ละ อื, “อาึ ฆวต ปัว โอเอีฮ นึง เปอะ ติ เจือ. อาึง เตะ เปอะ ฆรึม รเวือง อาึ เฮี, ละ ซ ซันญา เปอะ อาึง ซโตฮ นึง โอ เปอะ ซ รมอยจ อาึ นึง เมือง อียิป เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","อาึ ฆวต เกือฮ ปุย กลอม โรวก แตะ โอก ฮา เมือง อียิป เฮี, ละ ซ รมอยจ อื อาึ นา ก รมอยจ ปุย จัตเจือ ไพรม เมอะ,” อัฮ เซ ละ อื. โยเซป โลยฮ อื, “เออะ, ซ ยุฮ ละ เปอะ ตัม ป อัฮ เปอะ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","เปือะ อื อัฮ แม เฮี ละ อื, “ซันญา อาึง ไม่ เยอะ ซโตฮ โฮ,” อัฮ เซ. โยเซป ซันญา เนอึม อาึง อื ละ อื. เญือม เซ อิซราเอน นุ่ม นึง ก ไกญ เตียง ไอจ แตะ เซ, ไววอน ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ฟวยจ เซ แม เญี่ยะ, ไก ป อู ละ โยเซป, “เปือะ เปอะ โซะ,” อัฮ เซ ละ อื. โยเซป โฮว เคะ อื ฆาื อื ไม่ กวน แตะ ป มัฮ มะนาเซ ไม่ เอฟราอิม เซ. ");
INSERT INTO lcp_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","เญือม ฮมอง ยาโคป ฮอยจ โยเซป เคะ แตะ ปุน เอิน เรียง แตะ เญี่ยะ ปอ ปุน โกฮ งาวม แตะ นึง เตียง ไอจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ยาโคป อัฮ เฮี, “พะจาว ป ตึก นึง ระ อัมนัต แตะ, เอีจ เปลีฮ ติ แตะ ละ อาึ นึง นาตี ลุต เมือง คะนาอัน. ปิฮ มุ่น ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","อัฮ ติ แตะ ซ เกือฮ อาึ พรุฮแพร, ไม่ เกือฮ อื จัตเจือ เยอะ แปน ปุย โฮวน เมือง. อัฮ โรฮ ติ แตะ ซ เกือฮ เมือง อาวต เตอะ เซ แปน ลอป เมือง ยุฮ จัตเจือ อาึ,” อัฮ เซ ละ โยเซป. ");
INSERT INTO lcp_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","อัฮ แม เฮี, “กวน ปะ ลอา เฮี, ป เกิต นึง เมือง อียิป กา ฮอยจ อาึ นา เฮี ซ เมีญ โรฮ มัฮ กวน อาึ. เอฟราอิม ไม่ มะนาเซ ซ มัฮ กวน อาึ ตอก มัฮ รูเบ่น ไม่ ซิเมโอน กวน อาึ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","ดัฮ ไก ลั่ง กวน ไฮญ เปอะ เมีญ มัฮ กวน โกะ เปอะ ไอฮ. นาตี อาวต อื ปังเมอ ซ โฮลฮ อื นึง นาตี เอฟราอิม ไม่ มะนาเซ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","อาึ โตก ละ ราเชน ป มัฮ มะ เปอะ. อาึ ไลจ เนอึม รพาวม เมอะ เญือม ยุม อื. ปุก เญือม เอีญ เญอะ เน่อึม นึง เมือง ปัตดั่น. เญือม เอีจ ฮอยจ เจอะ นาตี เมือง คะนาอัน เซ, เญือะ ซไง โตว ฮา ย่วง เอฟราทา, มะ เปอะ ยุม นา เซ. อาึ รมอยจ เจอะ โบ คระ นา เซ,” อัฮ เซ. (ปเลี่ย ปุย อัฮ เบ่ตเลเฮม ไม่ ย่วง เซ.) ");
INSERT INTO lcp_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","อิซราเอน เญือม ยุ อื กวน โยเซป เซ ไฮมญ อื, “กวนดุ เฮี มัฮ ปุย?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","โยเซป โลยฮ อื ตอก เฮี, “เฮี มัฮ กวน อาึ ป เกือฮ พะจาว เนิ นึง เมือง เฮี,” อัฮ เซ ละ อื. อิซราเอน ปัว อื ตาว อื ละ แตะ ละ ซ ปิฮ อื มุ่น ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","อิซราเอน เซ เอีจ กวต เอิน ปอ เปือ ไง่ แตะ. เญือะ ยุ ที โตว โอเอีฮ. โยเซป ตาว เนอึม กวนดุ เซ ละ อื. ตะ อื เซ โอม อื. ฮงาึต อื. ");
INSERT INTO lcp_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","อิซราเอน อัฮ เฮี ละ โยเซป, “อาึ แกต ติ แตะ โอ เญือะ โฮลฮ ยุ ปะ. ปเลี่ย เฮี พะจาว เอีจ เกือฮ อาึ โฮลฮ ยุ ปะ เตือง กวน เปอะ เยือก,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","เญือม เซ โยเซป เกือฮ กวน แตะ โอก ฮา เญือะ ดึม เปือะ แตะ. นุ่ม ไว เปือะ แตะ ปอ จิ ไกญ แตะ เตะ. ");
INSERT INTO lcp_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","เญือม เซ โยเซป โตวก เตะ กวน แตะ. โตวก เอฟราอิม นึง เตะ ดอม แตะ เกือฮ อื อาวต ลวง วิ เปือะ แตะ. โตวก มะนาเซ นึง เตะ วิ แตะ เกือฮ อื อาวต ลวง ดอม เปือะ แตะ. ตาว อื ฮอยจ เคะ อื. ");
INSERT INTO lcp_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","อิซราเอน ซนาว เตะ ดอม แตะ ย่อง อื นึง ไกญ เอฟราอิม เตือง มัฮ อื ปุ. ซนาว แม เตะ วิ แตะ ย่อง อื นึง ไกญ มะนาเซ ป มัฮ เอียกระ อื. มัฮ โฆง อื รแกน เตะ แตะ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","เญือม เซ ปิฮ มุ่น ละ เญือะ โยเซป. อัฮ เฮี, “ปัว พะจาว ป ทื อัปราฮัม ไม่ ยิซฮัก จัตเจือ ไพรม เมอะ ปิฮ มุ่น ละ กวนดุ ลอา เฮี. ปัว พะจาว ยุฮ อาึ ป เลียง ป แลน อาึ ตอก ป เลียง แกะ เซ เกือฮ กุน เกือฮ มุ่น ยุฮ แตะ ละ. ");
INSERT INTO lcp_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","เกือฮ โรฮ เตปด่า ยุฮ เปอะ ป เฆีญ อาึ ฮา ป โอ ไมจ โครยญ เจือ เซ แลน แก อื. เกือฮ มอยฮ อาึ ไม่ มอยฮ อัปราฮัม ไม่ ยิซฮัก อาวต ลอป ไม่ โม เฮี, เกือฮ พรุฮ ตอก กวน แฮ, แด ตอก กวน โอง, เกือฮ ไก กวน รเมะ โฮวน กวน รโปวน บื, กวน รโปวน นาวก เตะ, กวน รเมะ นาวก ย่วง,” อัฮ เซ อิซราเอน เนอ. ");
INSERT INTO lcp_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","เญือม ยุ โยเซป ย่อง เปือะ แตะ เตะ ดอม แตะ นึง ไกญ เอฟราอิม ตอก เซ, มวน โตว รพาวม ฆาื อื. ริ ยวก เตะ ดอม อื เซ โอก ฮา ไกญ เอฟราอิม เฌาะ อื ฮอยจ ละ ไกญ มะนาเซ. ");
INSERT INTO lcp_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","อัฮ เฮี, “เปือะ, ปุก โตว ตอก เซ. มัฮ ปุย เฮี กวน โรง เงอะ. ย่อง เตะ ดอม เปอะ ราว ไกญ ปุย เฮี นึง อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","เปือะ อื ญอม โตว ละ อื. “กวน, อาึ ยุง เงอะ. ยุง โรฮ โฮะ. จัตเจือ ปุย เฮี ซ แปน โรฮ ปุย โฮวน. ซ ระ โรฮ. ปัง มัฮ ตอก เซ ปุ อื เฮี ซ ระ แม ฮา เอียกระ แตะ. จัตเจือ ปุ อื ซ แปน ปุย โฮวน เมือง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","ซเงะ เซ อิซราเอน ปิฮ มุ่น ละ อื เตือง ลอา อื ตอก เฮี, “เฆียง เฮี โม อิซราเอน ซ โกว มอยฮ โม เปะ เญือม ปิฮ อื มุ่น ละ ปุ แตะ. ซ อัฮ เฮี, ‘ปัว พะจาว เกือฮ โม เปะ ระ ตอก เอฟราอิม ไม่ มะนาเซ,’ ซ อัฮ เซ ปุย.” มัฮ ตอก เซ ตอก เกือฮ อื เอฟราอิม ระ ฮา มะนาเซ. ");
INSERT INTO lcp_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","อิซราเอน อัฮ เฮี ละ โยเซป, “อาึ เอีจ ซ ยุม เมอะ. พะจาว ปังเมอ ซ อาวต ไม่ โม เปะ. ซ ตาว โม เปะ เอีญ แม ฮอยจ นึง เมือง อาวต จัตเจือ ไพรม เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","ปะ ซ ไมจ ป โฮลฮ เปอะ ฮา โม เอียกปุ แตะ. โนก ฮา เซ อาึ ซ เกือฮ ปะ โฮลฮ กุม ตู เตียม ติ โดฮ. ตู เซ มัฮ ป ปุน อาึ เบือ วิจ ไม่ ทนู ยุฮ แตะ เน่อึม นึง โม อาโมไร,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ยาโคป ดวน ปุย กอก โม กวน เฌือต แตะ เอีญ เคะ แตะ. เญือม เอีจ รเจอึม อื อัฮ เฮี ละ อื, “เอีญ ง่อต ป อัฮ อาึ นา เฮี. ซ รโฮงะ ละ เปอะ ป ซ เกิต ละ โม เปะ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","โม เปะ ป มัฮ กวน ยาโคป เปอ, เอีญ รโจะ นา เฮี. ง่อต ป อัฮ อิซราเอน เปือะ เปอะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“รูเบ่น, ปะ มัฮ เปอะ กวน โรง เงอะ, เกิต เปอะ เญือม บุฮ อาึ ไม่ ระ ลั่ง เรียง เงอะ ตอก เปลิ โคะ โรง โฮ. ปะ ระ เรียง เปอะ ฮา ปุ ปุย แตะ. ระ โรฮ เกียฮ ฮุน เปอะ ฮา ปุย โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","ปะ ตอก เปอะ รอาวม ดังดอ โฮ. ซ โฮลฮ เปอะ โตว แปน ไกญ ปุย, นึง ไอฮ พาวม เปอะ ไม่ ปรโปวน เญือะ เปือะ แตะ. มัฮ ป พังไฮะ ลอน ละ เญือะ เญะ. ");
INSERT INTO lcp_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“ซิเมโอน ไม่ เลวี มัฮ เอียกปุ. มัฮ ป ยุฮ กัน ไฮะฮอน นึง วิจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","อาึ ซ ญอม โตว เลียก ซิงซา ดิ โอเอีฮ ไม่ นึง กัน ตะ อื ยุฮ. โม เซ ยุฮ ยุม ไม่ ปุย นึง ซวก ลอน แตะ. เกือฮ ติ แตะ มวน รพาวม นึง ตอยฮ แตะ ซนัก โจว โมวก. ");
INSERT INTO lcp_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ซ ลอก ป โอยจ นึง โซะ แตะ ฆาื อื, นึง มัฮ อื ป กอ ฮาวก รพาวม ลัมเลือ เอิน ไม่ ซวก ลอน แตะ. ไก โตว รพาวม เลียก พาวม นึง โอเอีฮ ติ เจือ เนอึม. อาึ ซ เกือฮ รกัฮ ฮา ปุ แตะ ฆาื อื นึง เมือง อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“ยูด่า, โม เอียกปุ เปอะ ซ ลืลาว ปะ. ปะ ซ ปุน โฮมวต เปอะ โงก โม ป เกละยุ แตะ. เอียกปุ เปอะ ซ นุ่ม ไว ปะ. ");
INSERT INTO lcp_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ยูด่า มัฮ ตอก อื กวน รเวีย ซิงโต โฮ. เอีจ ปุน เกียต กุก เปอะ โอเอีฮ. เอีญ เปอะ ละ ทัม อาวต แตะ. เญือม ไอจ เปอะ ตอก ซิงโต โฮ ไก โตว ป โรวต ซอ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","มัฮ ยูด่า ป ซ ไปญ ลอป โคะ ฆิ ยุฮ กซัต เตอ. กวน เฌือต อื ซ โฮลฮ ลอป ตัตเตียง ปุย ฮอยจ ละ ซ ฮอยจ ป ลัง ตัตเตียง เนอึม ปุย เซ. เมือง ปุย ไฮญ ซ เนอึง ป อัฮ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","ยูด่า ซ ปุก กวน บรัง ยุฮ แตะ ไม่ โคะ อะงุน. มัฮ อะงุน ตึก นึง ญึม แตะ. ซ ซัก เครอึง เซอึก แตะ นึง รอาวม อะงุน. ");
INSERT INTO lcp_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ไง่ อื ซครัก เอิน นึง รอาวม อะงุน. เบียง อื ปิญ เอิน นึง รอาวม ตาึฮ. ");
INSERT INTO lcp_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“เซบู่ลุน ซ อาวต โบ ปลัฮ รอาวม. นา ก อาวต อื ซ โฮลฮ โล่ง ระ จวต นึง. ม่าื เตะ อาวต อื เซ ซ ติต ไม่ เคต เมือง ไซด่อน. ");
INSERT INTO lcp_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“อิตซคา มัฮ ตอก บรัง เรียง. ไอจ ซน่ะ รตัง แตะ เตือง ลอา ก บลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","ดัฮ ยุ มวน ก ลโล่ะ แตะ, ดัฮ อาวม มวน ปลัฮเตะ อาวต แตะ, ซ ญอม นุ่ม ติ แตะ โรวก รตัง แตะ ฆาื อื. ซ ญอม เกือฮ ปุย คนัป แตะ ยุฮ กัน. ");
INSERT INTO lcp_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ด่าน ซ ตัตซิน โอเอีฮ ละ ปุย ยุฮ แตะ ตัม ซื อื. ซ มัฮ เจอ ไน โม อิซราเอน ตา ติ เจอ. ");
INSERT INTO lcp_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ด่าน ซ ตอก ซโอยญ ปิต อาวต เฆียง คระ โฮ. ซ มอง ปวก ล่อยจ บรอง โฮว พา แตะ ละ ซ เกือฮ อื ป บุก บรอง เซ งัต ลั่กเคะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“โอ พะจาว, อาึ รกวน เวลา ซ เกือฮ เปอะ เอะ โปน ฮา ป โอ ไมจ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“ซ ไก คะมุย ติ มู, ซ ฮอยจ ซะ เต โม กาต เซ. โม กาต เซ ปังเมอ ซ โครฮ โม เซ. ซ อาื อื ฮอยจ ละ เครอึป แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“อาเชอ ซ โฮลฮ อาวต นึง ปลัฮเตะ ไมจ ป โซม ป ปอน นึง. ป โซม อื เซ มัฮ ป โปง ไม่ โซม กซัต แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“นัปทาลี มัฮ ตอก จัก โกวน ป เบลือฮ โฮ. กวน แตวะ อื เซ มัฮ ป ไมจ. ");
INSERT INTO lcp_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“โยเซป มัฮ ตอก โคะ อะงุน เกลอึม เปลิ ป อาวต โบ รอาวม ปลาึฮ โฮ. กัก อื รวุก เอิน ฆรุง ฮลาวง. ");
INSERT INTO lcp_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ตฮัน ไปญ ทนู ฮอยจ ตอซู ปุ แตะ ไม่ อื ไม่ รพาวม ซวก แตะ. โปยญ แนฮ อื นึง เกละ แตะ ยุ อื. ");
INSERT INTO lcp_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ทนู ไปญ โกะ อื ปังเมอ ตอน แนฮ ลั่ง. เตะ ดอม เตะ วิ อื เรียง แนฮ นึง เรอึม พะจาว อื. เอีจ มัฮ พะจาว ป ทื ยาโคป ป ตึก นึง เรียง แตะ ป อาวต ไม่ อื. มัฮ ซโมะ เปิง รอัง เดีย อื, มัฮ ป เลียง แกะ ยุฮ อิซราเอน ป เฆีญ อื ฮา ป โอ ไมจ เจอ. ");
INSERT INTO lcp_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","โยเซป, มัฮ พะจาว ยุฮ เปือะ เปอะ ป เรอึมชวย ตูเตอึม เปอะ. มัฮ พะจาว ตึก นึง ระ อัมนัต แตะ ป ปิฮ มุ่น ละ เปอะ. มัฮ มุ่น ดุฮ เน่อึม มะลอง ตอก รอาวม เฮละ โฮ. มัฮ มุ่น โอก เน่อึม ฆรึม เตะ ตอก รอาวม ปลาึฮ โฮ. ปัว พะจาว เกือฮ เปอะ ไก กวน รเมะ โฮวน, กวน รโปวน บื, ไม่ โฮวน โรฮ คอง เลียง คอง ดู่ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","มุ่น ปิฮ เปือะ เปอะ ละ เปอะ เฮี มัฮ ป ไมจ ฮา โอเอีฮ ไก นึง บลาวง, ฮลาวง โรฮ ฮา โอเอีฮ ไมจ ไก นึง โม, เกือฮ มุ่น ปิฮ อาึ เซ ฮอยจ ละ โยเซป, นึง มัฮ อื ปุย พิเซต ฮา เอียกปุ ไฮญ แตะ,” อัฮ เซ ละ โยเซป. ");
INSERT INTO lcp_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","อัฮ แม อื ตอก เฮี, “เบ่นยามิน มัฮ ตอก บราวก ซาวป โซม โฮ. เมือ กซะ อื โซม ซัก กุก เตือ. เมือ กปู อื โอยจ โตว โซม อื ป โฮลฮ ป ปุน แตะ,” อัฮ เซ ยาโคป เปอ. ");
INSERT INTO lcp_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ปุย โม เซ มัฮ ไกญ เจอ โม อิซราเอน เตือง กาว ลอา เจอ อื. เปือะ อื ปิฮ มุ่น ละ อื ตัม ป โปง ไม่ โกะ อื ไอฮ ตอก เซ โครยญ โฆะ ปุย. ");
INSERT INTO lcp_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ยาโคป ซตอก อาึง กวน แตะ ตอก เฮี, “อาึ เอีจ ซ โฮลฮ โฮว รโจะ ไม่ จัตเจือ ไพรม แตะ. ไมจ เปอะ รมอยจ อาึ ไม่ มะเปือะ ตะเยือะ เกอะ โตะ ทัม ป ไก นึง รปึม ยุฮ เอฟโรน ป มัฮ โม ฮิตไท เซ. ");
INSERT INTO lcp_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ทัม เซ ไก นึง รปึม มักเปลา ย่วง มัมเร นึง เมือง คะนาอัน นา ก รวี อัปราฮัม นึง เอฟโรน โฮ. ");
INSERT INTO lcp_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","มัฮ นา เซ ก รมอยจ ปุย อัปราฮัม ไม่ ซารา. รมอยจ โรฮ ยิซฮัก ไม่ เรเบ่คา นึง อื. อาึ รมอยจ โรฮ เลอา นา เซ. ");
INSERT INTO lcp_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","รปึม เซ ไม่ ทัม นึง อื เอีจ มัฮ ป รวี ตะ เกอะ นึง โม ฮิตไท ไพรม อื. ไมจ โรฮ เปอะ รมอยจ อาึ นา เซ โอะ,” อัฮ เซ ละ กวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","เญือม เอีจ ฟวยจ ซตอก อื กวน แตะ ตอก เซ ยาโคป ไอจ ไมจ, ลอต โอยจ รพาวม. โฮลฮ โฮว รโจะ ไม่ จัตเจือ ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","เญือม เซ โยเซป ฆลาื ไอจ ราว เปือะ แตะ. เยือม ไม่ อื. ฮงาึต เปือะ แตะ เซ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","โยเซป ดวน มอ ป รซอฮ ละ แตะ เซ ฮาวม เปือะ แตะ เซ นึง เยื่อ โอ เกือฮ ป ยุม เซ เกียฮ ซเออึม. ");
INSERT INTO lcp_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","มอ โม เซ ฮาวม อื รปาวน ซเงะ ตัม ป กอ ยุฮ แตะ ละ ป ยุม. โม อียิป เยือม ป ยุม เซ อาลแฆลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","เญือม เอีจ ฟวยจ เวลา เยือม อื เซ, โยเซป ปัว โม จาวไน โฮว ลปุง ไม่ ฟาโร รโตง แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","เกือฮ อื อัฮ เฮี, “เญือม ซ ยุม เปือะ เกอะ เอีจ เกือฮ อาึ ซันญา อื ละ แตะ ซโตฮ นึง ซ เกือฮ อื อาึ รมอยจ แตะ โตะ ทัม ติ โดฮ ป เพรียง แตะ อาึง นึง เมือง คะนาอัน. ปัว เปอะ เกือฮ อาึ โฮว รมอยจ เปือะ เกอะ ฆาื อื นา เซ. ฟวยจ เซ ซ ฮอยจ แม นา เฮี,” เกือฮ โม จาวไน ซึป ลปุง แตะ ละ ฟาโร ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ฟาโร อัฮ เฮี, “โฮว เมิฮ. โฮว รมอยจ เปือะ เปอะ ตัม ป ซันญา เปอะ อาึง ละ อื เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","เญือม เซ โยเซป โฮว เนอึม ละ ซ รมอยจ แตะ เปือะ แตะ. โม จาวไน เมือง อียิป โฮว โรฮ ไม่ อื, เตือง โม ป อาวต เญือะ กซัต ไม่ โม ป ระ ป คาว เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","เญือะ โยเซป โฮว เอิน เตือง โอยจ แตะ. โม เอียกปุ อื ไม่ โม ป อาวต เญือะ เปือะ อื โฮว ตื โรฮ. มัฮ โม กวนดุ โน่ง ไม่ แกะ ปิ โมวก โอเอีฮ ป อาวต ลั่ง นึง นาตี โกเชน เนอ. ");
INSERT INTO lcp_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","โนก ฮา เซ โม ตฮัน บุก เลาะ รุป เซิก ไม่ โม ตฮัน บุก บรอง โฮว โรฮ. โฮวน ลัมเลือ ไม่ ปุ แตะ ปุย ติ มู เซ. ");
INSERT INTO lcp_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","เญือม เอีจ ฮอยจ อื นึง เบือง ปุฮ ปุย เฮงาะ นึง ย่วง อัตทัต ป อาวต บลัฮ โกลง จอแด่น ลวง ลั่ง โอก ซเงะ เอ, เยือม เนอึม เยือม แนม นา เซ แปน ไล แตะ อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","โม คะนาอัน ป อาวต นา เซ เญือม ยุ อื เยือม ปุย นึง ย่วง อัตทัต ตอก เซ อัฮ เฮี, “คึนัก เนอึม ตอก เยือม โม อียิป ป ยุม เฮี,” อัฮ เซ. มัฮ เซ ป อัฮ ปุย อาเบ่น มิซราอิม ไม่ ย่วง เซ ฆาื อื ฮอยจ ปเลี่ย. ");
INSERT INTO lcp_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","กวน ยาโคป ยุฮ เนอึม อื ละ เปือะ แตะ ตัม ป อัฮ อื อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","โรวก เนอึม รมอยจ อื โตะ ทัม ป ไก นึง รปึม มักเปลา นา ก รวี อัปราฮัม นึง เอฟโรน ป มัฮ โม ฮิตไท ละ ซ แปน อื รมอยจ ยุฮ อื. ทัม เซ ไก ลั่ก โอก ซเงะ ย่วง มัมเร. ");
INSERT INTO lcp_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","เญือม เอีจ ฟวยจ รมอยจ อื เปือะ แตะ, โยเซป เอีญ ดิ ไม่ โม เอียกปุ แตะ ไม่ โม ป โฮว ไม่ แตะ ฮอยจ แม นึง เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ฟวยจ ยุม เปือะ อื โม เอียกปุ โยเซป อัฮ เฮี ละ ปุ แตะ, “เมอ เตือง อื โยเซป ทื ลั่ง โซะ โระ ลั่ง โกลยจ เอะ นึง ยุฮ ฮุ ป โซะ ละ อื ไพรม อื ยุ่ง. ซ ซาวป โรก เวน ฆาื อื ละ เอะ ยุ่ง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","รโปะ มวยญ แตะ ละ โยเซป ฆาื อื ตอก เฮี, “กา ยุม เปือะ เกอะ เอีจ ดวน เอะ ซึป ลปุง แตะ ละ ปะ, ปัว ปะ โอ เญือะ ทื โซะ โระ โกลยจ เอะ นึง ยุฮ เอะ ป พิต ละ เปอะ ไพรม อื โฮ, เปือะ เกอะ ฆวต อัฮ อื ละ เปอะ ตอก เซ. ปเลี่ย เฮี เอะ ฆวต ปัว โรฮ ปะ โอ ทื เอะ นึง ยุฮ เอะ ป พิต ละ เปอะ. เอะ เตอ มัฮ โรฮ กวนไจ พะจาว ทื เปือะ เปอะ,” อัฮ เซ ละ อื. เญือม ฮมอง อื ป อัฮ อื เซ โยเซป เยือม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","โม เอียกปุ อื ฮอยจ นุ่ม ติ แตะ ซองนา อื ไว อื. “เอะ มัฮ กวนไจ ปุย โจฮ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","โยเซป อัฮ เฮี ละ อื, “ปุ ฮลัต ฆาื. อาึ อัม เกียฮ ยุฮ โอเอีฮ ตัง พะจาว? ");
INSERT INTO lcp_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","โฆะ โอ โม เปะ ง่อต เนอึม เปอะ ตอก ซ ยุฮ แตะ ป ฆอก ละ อาึ, พะจาว ปังเมอ ง่อต ลั่ง ตอก ซ เกือฮ แตะ แปน ป ไมจ. มัฮ ซ เกือฮ อื ปุย โฮลฮ ไอม โฮวน ปุย ตอก ยุ เปอะ ซเงะ เนาะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ปุ เกือฮ ติ เปอะ ฮลัต นึง โอเอีฮ ติ เจือ เนอึม. อาึ ซ แลน แก โม เปะ ไม่ กวน เปอะ เตือง โอยจ อื,” อัฮ เซ ละ อื. เกาะ โลม รพาวม อื เกือฮ อื โฮลฮ รพาวม ไมจ มวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","โยเซป อาวต ลั่ง เมือง อียิป ไม่ เอียกปุ แตะ. ไอม ฮอยจ ละ ไก อาญุ แตะ ติ รอย ไม่ กาว เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ไอม ฮอยจ ละ ยุ แตะ กวนโซะ กวน แซะ เอฟราอิม. ยุ โรฮ กวน มาคี ป มัฮ กวน มะนาเซ ไม่ โฮลฮ อื โอม ละ ซ เมีญ อื มัฮ ปุย ไน จัตเจือ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","โยเซป อัฮ เฮี ละ เอียกปุ แตะ, “อาึ เอีจ ซดิ ซ ยุม เมอะ. พะจาว แจง ซ แลน แก โม เปะ. ซ นัม โม เปะ โอก ฮา เมือง เฮี ฮอยจ ละ เมือง ป เอีจ ซันญา ซโตฮ แตะ อาึง ละ อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป โฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","เญือม เซ โยเซป เกือฮ โม จัตเจือ อิซราเอน เซ ซันญา อาึง โอเอีฮ ไม่ แตะ ซโตฮ ตอก เฮี, “เญือม เอีจ ยุ เปอะ นัม เนอึม พะจาว แตะ โฮว ฮอยจ นึง เมือง เซ เยอ, ไมจ เปอะ กลอม โรวก โกะ ยุม อาึ โฮว ไม่ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ฟวยจ เซ โยเซป ยุม. อาญุ อื ไก ติ รอย ไม่ กาว เนอึม. โม เซ ฮาวม อื นึง เยื่อ โอ เกือฮ ป ยุม เซ เกียฮ ซเออึม. อาึง อื โตะ โคะ โลง นึง เมือง อียิป.");
INSERT INTO lcp_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","มอยฮ กวน ยาโคป ป โฮว อาวต เมือง อียิป ไม่ เปือะ แตะ ไม่ กวน เฌือต แตะ มัฮ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","มัฮ รูเบ่น, ซิเมโอน, เลวี, ยูด่า, ");
INSERT INTO lcp_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","อิตซาคา, เซบู่ลุน, เบ่นยามิน ");
INSERT INTO lcp_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ด่าน, นัปทาลี, กาต, ไม่ อาเชอ. ");
INSERT INTO lcp_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","เญือม เซ จัตเจือ ยาโคป เซ เตือง โอยจ อื ไก อาลแฆลฮ ปุย. ป มัฮ โยเซป เอีจ อาวต กา อื นึง เมือง อียิป เซ. ");
INSERT INTO lcp_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","เญือม เอีจ เลี่ญ อื โยเซป ไม่ โม เอียกปุ อื ไม่ ปุย เจน เซ ยุม เตือง โอยจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","โม จัตเจือ อิซราเอน ปังเมอ เอีจ โฮวน กวน เฌือต อื. พรุฮ เนอึม พรุฮ แนม ปอ นาวก อื ยุฮ เมือง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ฟวยจ เซ ไก แม กซัต โคระ นึง ติ ปุย ป เตียง เมือง อียิป เซ. กซัต เซ ยุง โตว ไลลวง โยเซป เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","กซัต เซ อัฮ เฮี ละ โม ลัปซด่อน ยุฮ แตะ, “โม อิซราเอน เฮี เอีจ พรุฮ โฮวน ฮา เอะ. เกง โรฮ ฮา เอะ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ดัฮ เกิต กัน ชุ เมือง นึง โฮ, โม เฮี ตึน ซ พาวม ดิ ไม่ โม ป ฮอยจ ตอซู ไม่ เอะ ยุ่ง. ดัฮ ตอซู ไม่ เอะ โฮ, อาึ ฮอ นึง ซ ไป โม เอะ นึง, ไม่ ลอต เอิน อื โอก ฮา เมือง เอะ ฆาื อื. ไมจ เอะ ง่อต อาึง เฮียง แตะ ละ โอ แตะ ซ เกือฮ พรุฮ,” อัฮ เซ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","เญือม เซ โม อียิป เกือฮ โม ป มัฮ ไนกุม โคมเฮง อื, คนัป อื ยุฮ กัน โซะ. โม อิซราเอน โฮลฮ ยุฮ เวียง ปิโทม ไม่ เวียง ราอัมเซต ละ กซัต. มัฮ นา ก แฮรน ฟาโร คาวคอง ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","โม อิซราเอน โฮว ปุย ละ โคมเฮง แตะ, ปังเมอ โฮว ละ พรุฮ แตะ ไม่ เวือฮ โรฮ ก อาวต อื ปุๆ. โม อียิป ฮลัต นึง อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","14","คนัป อื ยุฮ กัน โก ตึก นึง เตะ ตอง ไม่ ปุน, ไม่ ยุฮ กัน นึง ชิจ นึง รปึม. โซะ เนอึม ป อาวม โม อิซราเอน เซ นึง คนัป ลอน โม อียิป อื. เลียก พาวม โตว นึง อื เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ไก มะปโกวน ป โซวต กวนงัก ไน โม อิซราเอน ลอา ปุย. มอยฮ อื มัฮ ชิฟรา ไม่ ปูอา. กซัต เมือง อียิป กอก ปุย ลอา เซ เอีญ เคะ แตะ, อัฮ เฮี ละ อื, ");
INSERT INTO lcp_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“เญือม มอง เปอะ โซวต กวน โม ปรโปวน ฮีบรู เญือม ซ เกิต กวน อื เซ, ดัฮ กวน อื มัฮ ปรเมะ โฮ เกือฮ ยุม. ดัฮ มัฮ ปรโปวน เกือฮ ไอม,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","มะปโกวน ลอา ปุย เซ ปังเมอ ไก รพาวม ฮลัต นึง พะจาว. เนอึง โตว ป อัฮ กซัต เซ ฆาื อื. เกือฮ ลั่ง กวนดุ รเมะ เกิต เซ ไอม. ");
INSERT INTO lcp_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","เญือม เซ กซัต เซ กอก แม มะปโกวน ลอา เซ เอีญ เคะ แตะ ฆาื อื. ไฮมญ อื, “เมอยุ ยุฮ เปอะ ตอก เซ? เกียฮ เกือฮ โน่ง เปอะ กวนงัก รเมะ เซ ไอม ลั่ง เมอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","โม เซ โลยฮ อื, “ปรโปวน ฮีบรู ตอก โตว ปรโปวน อียิป. ไกลจ ลัมเลือ ไก กวน. กวน อื เซ เอีจ เกิต เอิน กา เฆียง ฮอยจ เอะ เคะ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","พะจาว เลียก พาวม นึง มะปโกวน ลอา เซ ฆาื อื. เกือฮ อื โฮลฮ กวน เฌือต แตะ โฮวน, นึง มัฮ อื ปุย นัปทื เนอึม พะจาว ไม่ ฮลัต แตะ นึง. โม อิซราเอน เซ พรุฮ แนฮ ปุ ปุ. เกง โรฮ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ฟวยจ เซ ฟาโร ดวน แม ปุย ไน แตะ ตอก เฮี, “เมาะ ป มัฮ กวนงัก รเมะ ไน โม ฮีบรู เซ, ไมจ เปอะ โปวฮ โตะ โกลงไน โครยญ โฆะ อื. กวนงัก รโปวน นึง อื ละ เกือฮ ไอม,” อัฮ เซ ละ โม ลัปซด่อน ยุฮ แตะ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ไก ปรเมะ เจอ เลวี ติ ปุย. ปรโปวน เญือะ อื มัฮ โรฮ เจอ เลวี. ");
INSERT INTO lcp_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","เญือม เซ ไก แม กวน ไม่ ปุ แตะ ติ, รเมะ. มะ อื เญือม ยุ อื กวน แตะ เซ เลียก พาวม นึง อื. ฮรัก อื. เม่าะ อื ลอวย เคิ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","เญือม โอ อื เญือะ ปุน เม่าะ ออ, ตุย อู ไตญ ปุย นึง ฮละ โด่ะ กอ. ตา ยั่ง ลอง นึง อื. อาึง กวน แตะ เซ นึง อื. ฟวยจ เซ โฮว ตาว อื นึง โกลง, เกือฮ อื ตอยฮ ราว รอาวม เฆียง โกลง เซ. อาวต ลลาึง ไรป ลโล. ");
INSERT INTO lcp_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ป มัฮ ออระ อื ชุง แก อื เน่อึม ก ซไง อื. มอง แก ป ซ เกิต ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","เญือม เซ กวน รโปวน ฟาโร เลีฮ ฮอยจ นึง โกลง เซ ละ ซ ฮาวม แตะ. กวนไจ อื โฮว ไร เฆียง โกลง เซ. เญือม ยุ กวน ฟาโร อาวต อู ลลาึง ไรป เซ, ดวน กวนไจ ยุฮ แตะ โฮว ตุย อื ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","กวนไจ อื เซ โฮว ตุย เนอึม อื. เญือม เอีจ โปฮ กวน กซัต อู เซ เยอ ยุ กวนงัก เซ, ปุก เยือม อื. เลียก พาวม นึง อื ฆาื อื. “เฮี ตึน ซ มัฮ กวนงัก ยุฮ โม ฮีบรู,” อัฮ เซ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","เญือม เซ ออระ กวนงัก เซ ฮอยจ ไฮมญ กวน ฟาโร ตอก เฮี, “อัม ฆวต เกือฮ เปอะ อาึ โฮว ซาวป โม ฮีบรู ละ เปอะ ติ ปุย, ละ ซ เกือฮ กวนงัก เฮี โฮลฮ ปุ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“โฮว เมิฮ,” อัฮ เซ ละ อื. ออระ กวนงัก เซ โฮว เนอึม. กอก เอิน มะ กวนงัก เซ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","เญือม เอีจ ฮอยจ อื กวน ฟาโร อัฮ เฮี ละ อื, “โรวก กวนงัก เฮี เอีญ ไม่ เปอะ. เกือฮ ปุ. เลียง เนิ. อาึ ซ เกือฮ จัง เปอะ ละ เปอะ,” อัฮ เซ ละ อื. มะ อื เซ โรวก เนอึม เลียง กวนงัก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","เญือม เอีจ ระ บุย โรฮ อื ตาว อื ละ กวน ฟาโร. กวน ฟาโร เซ เมีญ อื แปน กวน รเมะ แตะ. ปุก มอยฮ อื, อัฮ ไอ โมเซ ละ อื. “อาึ มัฮ ยวก เกอะ โอก ฮา รอาวม,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","กังเคะ เอ เญือม เอีจ ระ อื, ไอ โมเซ เซ โฮว เลีม นา ก อาวต โม ฮีบรู ป มัฮ จัตเจือ โกะ แตะ เซ. มอง แก อื ลไล ยุฮ อื กัน โซะ เซ. เญือม เซ ชวน โม อียิป ติ ปุย, ปุฮ เนอึม ปุฮ แนม โม ฮีบรู ป มัฮ จัตเจือ โกะ อื เซ ติ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ซาวป แก รวิต รเวียง แตะ เมือต โอ ยุ ปุย ไฮญ, ดัม เอิน ยุฮ ยุม ไม่ ปุย อียิป เซ ฆาื อื. ฟวยจ เซ รปาึง อื นึง ไฮมจ. ");
INSERT INTO lcp_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ปวยฮ พริ เซ โฮว เลีม แม ติ โฮน. ยุ โม ฮีบรู ลอา ปุย, รเจ ปุฮ ปุ แตะ. ไอ โมเซ อัฮ เฮี ละ ป ระ พิต นึง อื, “ปะ เมอยุ ปุฮ เปอะ ปุ แตะ ไม่ เอียกปุ ฮีบรู เปอะ เซ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ปุย เซ โลยฮ อื ละ อื, “มัฮ ปุย ป เกือฮ ปะ แปน ป ตัตเตียง รเตีฮ รตุม เอะ เอ? อัม มัฮ แกต เปอะ ติ แตะ ซ ปุน ยุฮ ยุม ไม่ อาึ ตอก ยุฮ เปอะ ไม่ ปุย อียิป เซ โรฮ?” อัฮ เซ ละ อื. เญือม เซ ไอ โมเซ ฮลัต ฆาื อื. อัฮ เฮี โตะ รพาวม แตะ, “ปุย ตึน ซ เอีจ ฮมอง ตื อื ป ยุฮ อาึ เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","เญือม ฮมอง ฟาโร ไลลวง อื เซ, ริ ยุฮ ยุม ไม่ ไอ โมเซ ฆาื อื. ไอ โมเซ ตอ ฆาื อื ฮา ฟาโร. โฮว อาวต นึง เมือง มีเดี่ยน. เญือม ฮอยจ อื นา เซ งาวม โบ นัมโม่ ติ โดฮ. ");
INSERT INTO lcp_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","เญือม เซ ไก ซตุ เมือง มีเดี่ยน ติ. ไก กวน เครีฮ อาแลฮ. ปุย อาแลฮ เซ ตาว แกะ ยุฮ เปือะ แตะ ฮอยจ นึง นัมโม่ เซ, เชียต รอาวม ละ แกะ เซ, โทก อื ละ อื โตะ กัวะ. ");
INSERT INTO lcp_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","เญือม เซ ฮอยจ แม โม ปรเมะ เลียง แกะ นึง ติ มู, ริ โครฮ โม ปรโปวน เซ โอก ฮา นัมโม่ เซ. ไอ โมเซ โกฮ เรอึม ปรโปวน โม เซ เกือฮ โตว โม ปรเมะ เซ ปัก อื. เชียต โรฮ รอาวม ละ อื เกือฮ แกะ ยุฮ อื ญุ อื. ");
INSERT INTO lcp_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","โม ปเครีฮ เซ เอีญ ฮอยจ เคะ เรอูเอน ป มัฮ เปือะ แตะ. เปือะ อื ไฮมญ อื, “โม เปะ เฌือน เอีญ บุย เปอะ เมอ เนาะ เฮี?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","กวน อื เซ โลยฮ อื ตอก เฮี, “ไก ปรเมะ โม อียิป ติ ปุย เรอึม เอะ, เกือฮ โตว ปุย ปัก เอะ. เชียต โรฮ รอาวม ละ แกะ ยุฮ ฮุ ไม่ อื,” อัฮ เซ ละ เปือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","เปือะ อื อัฮ เฮี, “ปุย เซ อาวต ก เมอ? ละ โน่ง เปอะ ก พริ ย่วง ตอก เซ เมอ? โฮว กอก เกือฮ เอีญ โซม ไม่ เอะ,” อัฮ เซ ละ กวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","กวน อื เซ โฮว กอก เนอึม อื. ไอ โมเซ เอีญ เนอึม ฮอยจ เญือะ เซ. ลอต อาวต ไม่ อื. ฟวยจ เซ เรอูเอน เซ เกือฮ ซิปโปรา ป มัฮ กวน แตะ ละ ไอ โมเซ แปน ปุย เญือะ อื. ");
INSERT INTO lcp_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","กัง เคะ เอ ซิปโปรา เซ ไก กวน รเมะ ติ, ไอ โมเซ อัฮ เกอโชม ละ อื. “อาึ มัฮ ปุย ตังด่าว อาวต ตังเมือง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","เญือม เอีจ เลี่ญ อื กซัต เมือง อียิป เซ ยุม. เญือม เซ โม อิซราเอน แงงัฮ นึง โซะ ป อาวม แตะ นึง แปน อื ครา ปุย, กอก ปัว พะจาว เรอึม แตะ ฆาื อื. รซอม ปัว อื เซ ฮอยจ เนอึม ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","เญือม แงงัฮ อื ฆาื โซะ ป อาวม แตะ เซ พะจาว ฮมอง อื. โตก โรฮ ละ ลปุง ซันญา แตะ อาึง ไม่ อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป. ");
INSERT INTO lcp_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","พะจาว ยุ ป เกิต ป ไก ละ โม อิซราเอน เซ โครยญ เจือ. ไฌม เนอึม ไฌม แนม อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ติ โฮน อื ไอ โมเซ โฮว เลียง แกะ ยุฮ โปะ แตะ. โปะ อื เซ มอยฮ เยโทร. มัฮ ซตุ เมือง มีเดี่ยน. ไอ โมเซ ตาว แกะ แลน แตะ เซ นึง ลาึน เวือฮ ลวง ลั่ก เลียก ซเงะ. เญือม เซ ฮอยจ ละ บลาวง ซัมคัน ยุฮ พะจาว. มอยฮ บลาวง เซ มัฮ ซีไน. ");
INSERT INTO lcp_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","เญือม เซ เตปด่า ยุฮ พะจาว เปลีฮ ติ แตะ ละ ไอ โมเซ ลลาึง รเออึป งอ ไก นึง โคะ แตวะ ติ. ไอ โมเซ เมือต แลน อื ยุ รเออึป งอ นึง โคะ เซ. โคะ เซ ปังเมอ โอ ฮะ เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ไอ โมเซ อัฮ เฮี โตะ รพาวม แตะ, “อาึ ซ เลียก แลน เนอะ ป ตังเจือ เฮี นึง โอ โคะ เฮี เกียฮ ฮะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","เญือม ยุ พะจาว ซ เลียก อื ซดิ ละ ซ แลน แตะ งอ เซ, อัฮ เฮี ละ อื เน่อึม นึง โคะ เซ, “ไอ โมเซ, ไอ โมเซ,” อัฮ เซ ละ อื. ไอ โมเซ โลยฮ อื, “มัฮ เมอ, อาึ อาวต นา เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","พะจาว อัฮ เฮี ละ อื, “ปุ เลียก ซดิ อี. ไมจ เปอะ ปอยจ เกิป แตะ. เตะ นา ก ชุง เปอะ เซ ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","อาึ มัฮ พะจาว ทื เปือะ เปอะ. มัฮ โรฮ พะจาว ทื อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป,” อัฮ เซ ละ อื. ไอ โมเซ ดุป นา แตะ. ฮลัต. โรวต โตว แลน พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","เญือม เซ พะจาว อัฮ เฮี ละ อื, “อาึ เอีจ ยุ อุ เม่ะมั่ก อาวม ปุย ไน อาึ ป อาวต นึง เมือง อียิป เปอ. อาึ เอีจ ฮมอง เงอะ แงงัฮ อื ฆาื คนัป โม ไนกุม อื ยุฮ กัน. อาึ ยุง เงอะ เมาะ โซะ ป อาวม อื. ");
INSERT INTO lcp_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","อาึ มัฮ เลีฮ ฮิ ละ ซ เรอึม แตะ เกือฮ โปน ฮา อัมนัต โม อียิป. ซ เกือฮ โปน ฮา เมือง เซ, เกือฮ ฮอยจ นึง เมือง ไมจ เมือง เวือฮ, มัฮ เมือง ตึม โครยญ โคะ โกะ โครยญ โกลง, โอเอีฮ ป ไก นึง อื พอม โครยญ เจือ. มัฮ ก อาวต โม คะนาอัน, โม ฮิตไท, โม อาโมไร, โม เปริซี, โม ฮีไว, ไม่ โม เยบุ่ต. ");
INSERT INTO lcp_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","อาึ เอีจ ฮมอง เงอะ แงงัฮ โม อิซราเอน. เอีจ ยุ โรฮ โฮะ เมาะ โคมเฮง โม อียิป อื. ");
INSERT INTO lcp_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","เอีญ เมิฮ. อาึ ซ เกือฮ ปะ เอีญ เคะ ฟาโร ละ ซ เกือฮ แตะ ปะ ตาว โม อิซราเอน ป มัฮ ปุย ไน อาึ เซ โอก ฮา เมือง อียิป,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ไอ โมเซ โลยฮ อื ละ พะจาว ตอก เฮี, “อาึ โรวต โตว โฮว เคะ ฟาโร เซ. โปง โตว อาึ. อาึ อัม ซ เกียฮ ตาว โม อิซราเอน โอก ฮา เมือง อียิป?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","พะจาว อัฮ แม เฮี ละ อื, “อาึ ซ โฮว แนฮ ไม่ เปอะ. เอีจ แจง ละ เปอะ นึง เฮี ดวน อาึ ปะ โฮว เยอ. เญือม เอีจ ตาว เปอะ ปุย โอก ฮา เมือง อียิป เปอ, โม เปะ ซ โฮลฮ เปอะ นุ่ม ไว อาึ นึง บลาวง เฮี,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","เญือม เซ ไอ โมเซ โลยฮ อื ละ พะจาว ตอก เฮี, “ดัฮ อาึ เอีจ ฮอยจ เคะ โม อิซราเอน, ดัฮ อาึ อัฮ มัฮ ดวน พะจาว ทื จัตเจือ ไพรม อื ฮอยจ เคะ อื, โม เซ ตึน ซ ไฮมญ แม อื ตอก เฮี, ‘พะจาว ป ดวน ปะ เซ มัฮ เมอ มอยฮ อื?’ ตึน ซ อัฮ เซ เนิ. อาึ ซ โลยฮ ละ อื ตอก เมอ?” อัฮ เซ ละ พะจาว ไอ โมเซ เยอ. ");
INSERT INTO lcp_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","พะจาว อัฮ เฮี ละ อื, “อาึ มัฮ เยโฮวา ป ตึน ไก ลอป. ไมจ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี, มัฮ เยโฮวา ป ตึน ไก ลอป เซ ป ดวน อาึ โฮว เคะ เปอะ. ไมจ เปอะ อัฮ เซ ละ.” ");
INSERT INTO lcp_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, “ปะ ไมจ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี, ‘มัฮ เยโฮวา ป มัฮ พะจาว ทื จัตเจือ ไพรม เปอะ. มัฮ โรฮ พะจาว ทื อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป ป ดวน อาึ ฮอยจ เคะ เปอะ,’ ไมจ เปอะ อัฮ ละ อื ตอก เซ. เซ ป มัฮ ลอป มอยฮ อาึ อื. มัฮ มอยฮ เซ ป เกือฮ ปุย ไตม อาึ นึง อื ฮอยจ เจน โคระ โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“โฮว กอก โม ป กวต ป เฮียง ยุฮ โม อิซราเอน เนอ, เกือฮ รโจะ ดิ เตือง โอยจ อื. ไมจ เปอะ รโฮงะ ละ อื เอีจ ฮอยจ เปลีฮ เยโฮวา ติ แตะ ละ เปอะ, มัฮ พะจาว ทื จัตเจือ ไพรม อื, มัฮ โรฮ พะจาว ทื อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป. รโฮงะ ละ อื ตอก ยุ ตอก ฮมอง อาึ ป ยุฮ ปุย ละ อื นึง เมือง อียิป เซ. ");
INSERT INTO lcp_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","รโฮงะ โรฮ ละ อื ตอก เอีจ ซันญา อาึ ซ ตาว แตะ เกือฮ โอก ฮา กัน โซะ อาวม อื นึง เมือง อียิป เซ. ซ โรวก เกอะ ฮอยจ เมือง อาวต โม คะนาอัน, โม ฮิตไท, โม อาโมไร, โม เปริซี, โม ฮีไว ไม่ โม เยบุ่ต. เมือง เซ มัฮ เมือง ตึม โครยญ โคะ โกะ โครยญ โกลง. ");
INSERT INTO lcp_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“โม ป กวต ป เฮียง ยุฮ โม อิซราเอน เซ ซ ง่อต ป อัฮ ปะ. ปะ ไม่ โม เซ ซ ไมจ เปอะ โฮว เคะ กซัต เมือง อียิป. ไมจ เปอะ อัฮ ละ อื ตอก เฮี, ‘เยโฮวา พะจาว ทื โม ฮีบรู เอีจ ฮอยจ เคะ เอะ. ปัว เปอะ เกือฮ เอะ โฮว นึง ลาึน เวือฮ เมาะ ลอวย ซเงะ คระ, ละ ซ ไว แตะ เยโฮวา พะจาว ทื แตะ, ไม่ ทไว แตะ โอเอีฮ ละ,’ ไมจ เปอะ อัฮ เซ ละ. ");
INSERT INTO lcp_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","อาึ ยุง เงอะ โอ กซัต เมือง อียิป เซ ซ เกือฮ โม เปะ โฮว เยอ, โนก ฮา ซ คนัป อาึ อื เกือฮ พลวย โม เปะ โฮว. ");
INSERT INTO lcp_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","อาึ ซ ยุฮ ป โซะ ละ เมือง อียิป โฮวน เจือ เบือ อัมนัต ระ แตะ. ฟวยจ เซ กซัต เซ ซ พลวย โม เปะ โฮว. ");
INSERT INTO lcp_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","โนก ฮา เซ อาึ ซ เกือฮ โม อียิป ซเปือฮ รพาวม ละ โม เปะ. ซ เกือฮ โตว โม เปะ โฮลฮ โฮว ปลาว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ไมจ เปอะ เกือฮ โม ปรโปวน ปัว โรวก ฮนัง เบล ไคร มาื, ไม่ เครอึง เซอึก แง่ฮ ฆัว เปอะ กวน รเมะ กวน รโปวน แตะ นึง. ตอก เซ ตอก ซ โฮลฮ เยือ เปอะ เครอึง ไมจ ยุฮ โม อียิป เปอ,” อัฮ เซ ละ อื พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ไอ โมเซ โลยฮ อื ละ พะจาว ตอก เฮี, “ปุย โม เซ ตึน โอ ซ ง่อต ลปุง อาึ. ตึน โอ ซ เจือ ป อัฮ อาึ เฮี, แกต อื โอ มัฮ เนอึม พะจาว ป เปลีฮ ติ แตะ ละ อาึ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","พะจาว อัฮ เฮี, “มัฮ เมอ ป ไปญ เปอะ นึง เตะ แตะ เซ?” อัฮ เซ ละ อื. “มัฮ โคะ ฆิ อิ,” อัฮ เซ ละ อื ไอ โมเซ เยอ. ");
INSERT INTO lcp_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","พะจาว อัฮ เฮี, “น่าึก แลน ลังเตะ เมอะ,” อัฮ เซ ละ อื. ไอ โมเซ น่าึก เนอึม อื. โคะ ฆิ อื เซ แปน เอิน ซโอยญ. ไอ โมเซ ตอ ฮา อื. ");
INSERT INTO lcp_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","พะจาว อัฮ เฮี, “ซนาว เตะ เปอะ โฮมวต ซตะ อื,” อัฮ เซ ละ อื. ไอ โมเซ โฮมวต เนอึม อื. แปน แม โคะ ฆิ ตอก ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","พะจาว อัฮ แม เฮี, “กัน ตอก เฮี มัฮ ซ เกือฮ โม อิซราเอน ยุง แจง แน มัฮ เนอึม เยโฮวา ป เปลีฮ ติ แตะ ละ เปอะ. มัฮ พะจาว ทื จัตเจือ ไพรม เปอะ, มัฮ โรฮ พะจาว ทื อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","เญือม เซ พะจาว ดวน อื ปอก โตะ ลปิ แตะ. ไอ โมเซ ปอก เนอึม อื, เญือม เอีจ กอฮ อื เตะ แตะ, เตะ อื เซ ลาวต เอิน ปอ ปิญ อื ตอก เตีย เปลาะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","เญือม เซ พะจาว ดวน แม อื ปอก โตะ ลปิ แตะ ติ โฮน แม. ปอก เนอึม อื. เญือม เอีจ กอฮ แม อื ไฮ ไมจ แม, ตอก แม ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","พะจาว อัฮ แม เฮี, “ดัฮ ปุย โอ เจือ เปอะ เญือม ยุ อื ป ซัมคัน โฮน รกา เซ, ตึน ซ เจือ อื เฆียง เอีจ ยุ อื ป ซัมคัน โฮน รเคะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ตัม โอ ลั่ง ดิ เจือ เปอะ เบือ ป ซัมคัน ลอา เจือ เซ, ดัฮ โอ ลั่ง ฆวต เนอึง ป อัฮ เปอะ, ไมจ เปอะ โฮว เชียต รอาวม เน่อึม นึง โกลงไน, ฟวยจ เซ โซ นึง เตะ ซออฮ. รอาวม เซ ซ เปียน เอิน ติ แตะ แปน ฮนัม ละ เปอะ,” อัฮ เซ ละ อื พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","เญือม เซ ไอ โมเซ อัฮ เฮี ละ พะจาว, “โอ พะจาว, บุน เอีจ ฟวยจ อื อาึ ตึน มัฮ ปุย โอ เกียฮ อัฮ เกียฮ อู. ปัง มัฮ ปเลี่ย เฮี เคียง ลปุง ปะ ไม่ เยอะ ปุ ลั่ง ดิ เกียฮ อัฮ เกียฮ อู ลั่ง. อาึ มัฮ ปุย ปักอะ ซะซิ ไม่ โอ แตะ ฮอยจ ยุฮ ลปุง โทง ยุฮ รโฮงะ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","พะจาว อัฮ เฮี, “มัฮ ปุย ป เกือฮ ปุย เกียฮ ลปุง เงอ? มัฮ ปุย ป เกือฮ อื ฮลาึต เกือฮ อื งาว? มัฮ ปุย ป เกียฮ เกือฮ ปุย ที ไง่ ไม่ เกียฮ เกือฮ อื จัก เกอ? โม่ มัฮ อาึ เฮี, อาึ มัฮ เยโฮวา. ");
INSERT INTO lcp_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","ปเลี่ย เฮี ไมจ เปอะ โฮว. อาึ ซ เรอึม ปะ เกือฮ เกียฮ อัฮ เกียฮ อู. ซ รโฮงะ ละ เปอะ ป ไมจ เปอะ อัฮ ฮา,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ไอ โมเซ อัฮ แม เฮี, “โอ พะจาว, ปัว ปะ เกือฮ ปุย ไฮญ โฮว เมิฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","เญือม เซ พะจาว ฆวต รอก พาวม ฆาื ป อัฮ ไอ โมเซ เซ. อัฮ เฮี ละ อื ฆาื อื, “อาโรน ป มัฮ เจอ เลวี เซ โม่ มัฮ เอียกระ เปอะ? อาึ ยุง เงอะ มัฮ อาโรน ปุย เกียฮ อัฮ เกียฮ มวยญ เญอ. ปเลี่ย เฮี เอีจ โฮว นึง คระ. เอีจ ซ ฮอยจ เคะ เปอะ. ดัฮ ยุ ปะ โฮ ตึน ซ มวน รพาวม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","ปะ ไมจ เปอะ อัฮ ละ อื เกือฮ ซึป ลปุง เปอะ. อาึ ซ อาวต นึง มวยญ เปอะ ไม่ ซ อาวต โรฮ นึง มวยญ อาโรน. ซ เพอึก ละ เปอะ ตอก ซ ไมจ เปอะ ยุฮ อัฮ ฮา. ");
INSERT INTO lcp_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","อาโรน เซ ซ อัฮ อื ละ ปุย ตัง ปะ, ซ แปน ดัก ดอย ปะ. ปะ ซ แปน เปอะ ตอก พะจาว ละ นึง ซึป เปอะ ลปุง อาึ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","ไมจ เปอะ ไปญ โรวก โคะ ฆิ เฮี ละ ซ ยุฮ เปอะ ป ซัมคัน นึง,” อัฮ เซ ละ อื พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ฟวยจ เซ ไอ โมเซ เอีญ ฮอยจ เคะ โปะ แตะ ป มอยฮ เยโทร เซ. อัฮ เฮี ละ อื, “ปัว เปอะ เกือฮ อาึ เอีญ ฮอยจ เมือง อียิป. ฆวต เอีญ เคะ จัตเจือ โกะ แตะ, ละ ซ ยุง แตะ โซะ กอ ไอม ยุม อื,” อัฮ เซ. เยโทร เซ พลวย อื เอีญ ไมจ เอีญ มวน. ");
INSERT INTO lcp_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","กา เซ เญือม อาวต ลั่ง อื เมือง มีเดี่ยน โฮ, พะจาว เอีจ ดวน อื เอีญ เมือง อียิป. “เอีจ ยุม โอยจ โม ป ฆวต ยุฮ ยุม ไม่ ปะ อา,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ไอ โมเซ โรวก ปรโปวน เญือะ แตะ ไม่ กวน แตะ. เกือฮ อื บุก ปุ โฮว บรัง. โอก เอีญ ไม่ อื นึง เมือง อียิป. โรวก โคะ ฆิ ดวน พะจาว แตะ โรวก เซ ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","พะจาว อัฮ เฮี ละ อื, “ดัฮ เปอะ เอีจ ฮอยจ เมือง อียิป โฮ, ไมจ เปอะ เปลีฮ ป ซัมคัน ป เกือฮ อาึ เปอะ ยุฮ ไม่ อัมนัต แตะ ละ ฟาโร โครยญ เจือ. อาึ ปังเมอ ซ เกือฮ รพาวม อื ลึง, ซ ญอม โตว พลวย เอิน ปุย โฮว. ");
INSERT INTO lcp_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","ไมจ เปอะ อัฮ ละ อื ตอก เฮี, พะจาว อัฮ โม อิซราเอน มัฮ กวน รเมะ โรง แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","ไมจ เปอะ พลวย กวน เนอะ เกือฮ โฮว ไว อาึ. ดัฮ เปอะ โอ พลวย โฮ อาึ ซ ยุฮ ยุม ไม่ กวน รเมะ โรง ปะ,” พะจาว ดวน ไอ โมเซ อัฮ อื ละ ฟาโร ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","เญือม เอีจ ฮอยจ อื ติ โดฮ ละ ซ ไอจ แตะ พะจาว ฮอยจ รโตฮ ยุ ไอ โมเซ. ริ ยุฮ ยุม ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","เญือม เซ ซิปโปรา ป มัฮ ปรโปวน เญือะ ไอ โมเซ เซ ซาวป ซโมะ ลอม ติ. กิต เปือง ฮัก นา ก ปุก ตะลมัง กวน รเมะ แตะ. จิ ชวง ไอ โมเซ นึง อื. มัฮ ฆาื ไลลวง ริตกิต เซ ป อัฮ อื เฮี ละ ไอ โมเซ ฆาื อื, “ปะ มัฮ เปอะ ปรเมะ เญือะ อะ, เอีจ ลอก เปอะ ฮนัม,” อัฮ เซ ละ อื. พะจาว ยุฮ เนอึม โตว ยุม ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","พะจาว อัฮ เฮี ละ อาโรน, “โฮว ซาวป ยุ ไอ โมเซ นึง ลาึน เวือฮ,” อัฮ เซ ละ อื. อาโรน โฮว ซาวป เนอึม อื. เญือม เอีจ ยุ อื ไอ โมเซ นึง บลาวง ซัมคัน ยุฮ พะจาว เซ ฮงาึต อื. ");
INSERT INTO lcp_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","เญือม เซ ไอ โมเซ รโฮงะ ไลลวง ตอก ดวน พะจาว แตะ อัฮ ละ ปุย โครยญ เจือ, ไม่ ไลลวง ป ซัมคัน ป ดวน พะจาว แตะ ยุฮ เซ ละ อาโรน. ");
INSERT INTO lcp_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ฟวยจ เซ ไอ โมเซ ไม่ อาโรน โฮว เคะ โม ป กวต ป เฮียง ยุฮ โม อิซราเอน, เกือฮ อื โพรม ดิ. ");
INSERT INTO lcp_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","อาโรน รโฮงะ ลปุง พะจาว ป ซึป ไอ โมเซ เซ ละ แตะ โครยญ มวยญ. ไอ โมเซ ยุฮ โรฮ ป ซัมคัน ซองนา ปุย โฮวน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","ปุย โฮวน เซ เจือ ลปุง อื ฆาื อื. เญือม ฮมอง อื ฮอยจ พะจาว เคะ โม อิซราเอน ไม่ ฮมอง โรฮ อื ยุ พะจาว เม่ะมั่ก อาวม แตะ เซ, ปุย โฮวน เซ นุ่ม เอิน ไว พะจาว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ฟวยจ เซ ไอ โมเซ ไม่ อาโรน เลียก เคะ ฟาโร. อัฮ เฮี ละ อื, “พะเยโฮวา ป มัฮ พะจาว ทื โม อิซราเอน อัฮ เฮี ละ เปอะ, ไมจ เปอะ พลวย ปุย ไน อาึ เกือฮ โฮว. เกือฮ โอก โฮว นึง ลาึน เวือฮ ละ ซ เลียง อื ปุ แตะ นึง กัน ไว แตะ อาึ, อัฮ อื ละ เปอะ ตอก เซ พะจาว เยอ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ฟาโร อัฮ เฮี, “พะจาว เซ มัฮ ปุย ตอก เมอ ตอก โอวน, เคียต โน่ง ดวน อาึ พลวย โม อิซราเอน โฮว ตอก เซ เมอ? อาึ ยุง โตว พะจาว เซ เฟือฮ. อาึ ซ ญอม โตว พลวย โม อิซราเอน เซ โฮว เฟือฮ เอิน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","ไอ โมเซ ไม่ อาโรน โลยฮ อื ตอก เฮี, “พะจาว ทื โม ฮีบรู เอีจ ฮอยจ เปลีฮ ติ แตะ ละ เอะ. ปัว เปอะ เกือฮ เอะ โฮว นึง ลาึน เวือฮ เมาะ ลอวย ซเงะ คระ ฆาื อื. เอะ ซ มอก ตอง ทไว โอเอีฮ ละ พะจาว ทื แตะ. ดัฮ โอ ยุฮ ตอก เซ, เอะ ฮอ นึง ซ เกือฮ อื เอะ ยุม นึง พาญัต ฆอก, ฮอ โรฮ นึง ซ เกือฮ อื เอะ ยุม นึง วิจ โรฮ,” อัฮ เซ ละ กซัต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","5","กซัต เซ อัฮ เฮี ละ ไอ โมเซ ไม่ อาโรน, “เกียฮ เกือฮ โน่ง เปอะ ปุย โม เซ ซุกซัก รพาวม ไม่ เกือฮ เปอะ ซลัฮ นึง กัน ยุฮ แตะ เมอ? โม เปะ เอีจ พรุฮแพร เปอะ โฮวน ฮา เอะ. ปเลี่ย เฮี เปะ ลอา ฆวต เซอึฮ ซุย แม เปอะ ปุย โอ เญือะ ยุฮ กัน. เอีญ แปฮ, ยุฮ แปฮ กัน เปอะ,” อัฮ เซ ละ อื เรียง. ");
INSERT INTO lcp_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ซเงะ เซ ฟาโร กอก โม ไนกุม ป แลน แก โม กวนไจ ยุฮ แตะ เกือฮ ฮอยจ. ");
INSERT INTO lcp_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","อัฮ เฮี ละ อื, “ปุ เญือะ ซาวป เบระ ละ โม ป ยุฮ เตะ ตอง เซ ตอก ไพรม อื. เกือฮ ซาวป ไอฮ อื นึง โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ไมจ เปอะ คนัป เกือฮ ยุฮ ลั่ง เตะ ตอง เมาะ ไพรม แตะ. ปุ ญอม เกือฮ รมัฮ เซน ฮา ไพรม แตะ เฟือฮ. โม เซ มัฮ เกละ อื. มัฮ เซ ป ปัว อื โอก โฮว ทไว โอเอีฮ ละ พะจาว ทื แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","ไมจ เปอะ เกือฮ กัน ยุฮ อื โฮวน ฮา ไพรม แตะ. ปุ เกือฮ ไก เญือม ลโล่ะ เฟือฮ เอิน, เดอึม โอ ซ อาวต ปลาว งาวม เรี ไม่ ง่อต แตะ ลปุง ไอฮ พาวม แตะ ตอก เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","เญือม เซ โม ไนกุม โอก รโฮงะ รซอม ฟาโร เซ ละ ปุย. รโฮงะ ไลลวง โอ ฟาโร ซ เกือฮ เบระ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","เกือฮ อื โฮว ซาวป ไอฮ อื นึง โกะ แตะ, เตอึม นา ก เกียฮ ซาวป อื. เตะ ตอง ยุฮ อื เซ ปังเมอ โอ เกือฮ อื รมัฮ ฮา ไพรม แตะ เญี่ยะ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ปุย โม เซ จัมเปน อื โฮว ไร ฆาื เลี่ป เมือง อียิป, ซาวป โงว เฮงาะ ละ ซ โกว แตะ ตัง เบระ. ");
INSERT INTO lcp_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","โม ไนกุม คนัป แนฮ อื, ดวน อื ยุฮ แนฮ อื เมาะ ยุฮ ไพรม แตะ ตัม เซน ลัง ยุฮ แตะ ไน ติ ติ ซเงะ ตอก เญือม เกือฮ ปุย เบระ ละ อื โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","ไนกุม ระ ป มัฮ โม อียิป เซ, เฟียต ไนกุม ป มัฮ โม อิซราเอน นึง อื เซ. บวยจ ละ อื ตอก เฮี, “ตอก เมอ โอ โม เปะ เญือะ ยุฮ เตะ ตอง โฮวน เมาะ ไพรม แตะ? เกียฮ รมัฮ โน่ง เซน ฮา ไพรม แตะ เมอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","โม อิซราเอน ป มัฮ ไนกุม เซ โฮว เคะ ฟาโร ฆาื อื. อัฮ เฮี ละ อื, “ตอก เมอ ป ยุฮ เปอะ ละ เอะ ป มัฮ กวนไจ ยุฮ เปอะ เฮี? ");
INSERT INTO lcp_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","เอะ เญือะ โฮลฮ โตว เบระ ตอก ไพรม แตะ. เมือต แลน ปุย ดวน ลั่ง เอะ ยุฮ เตะ ตอง เมาะ ไพรม แตะ. ปุย เฟียต ปุฮ เอะ, ญันได่ มัฮ ปุย ไน โม เปะ ไอฮ ป พิต เตอ, มัฮ โตว เอะ ป มัฮ กวนไจ ยุฮ เปอะ เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ฟาโร โลยฮ อื, “โม เปะ มัฮ เกละ เปอะ. มัฮ เซ ป ปัว เปอะ อาึ พลวย เปอะ โฮว ทไว โอเอีฮ ละ พะจาว ฆาื อื. เกละ ลอน เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","อาึ ญอม โตว เกือฮ ปุย เกือฮ เบระ ละ เปอะ. เตะ ตอง ลัง ยุฮ เปอะ ปุ ซ เกือฮ รมัฮ เซน ฮา ไพรม แตะ. ยุฮ เตม ตัม ดวน ปุย เปอะ ยุฮ. เอีญ ยุฮ แปฮ กัน ยุฮ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","โม อิซราเอน ป มัฮ ไนกุม เซ อาวม ซ ญัก เนอึม อื ละ แตะ ฆาื อื นึง ฮมอง แตะ โอ ปุย ซ เกือฮ เซน เตะ ตอง ลัง ยุฮ แตะ เซ รมัฮ ฮา ไพรม แตะ เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","เญือม โอก อื ฮา ฟาโร เซ ยุ มอง ไอ โมเซ ไม่ อาโรน แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","อัฮ เฮี ละ ปุย ลอา เซ, “ปัว พะจาว รเตีฮ เปะ ลอา เกือฮ ลอก ตุต แตะ นึง เกือฮ เปอะ กซัต ไม่ โม จาวไน ป ยุฮ กัน ละ อื เซ เกละยุ เอะ, เมาะ เอิน บุน เกือฮ เปอะ วิจ ละ ปุย โม เซ ละ ซ มอก อื เอะ นึง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ไอ โมเซ เลียก แม เคะ พะจาว ติ โฮน, อัฮ เฮี, “โอ พะจาว, มัฮ ตอก เมอ เกือฮ เปอะ เม่ะมั่ก ซักคระ เกิต ละ ปุย โม เฮี? เมอยุ ดวน เปอะ อาึ ฮอยจ เคะ ปุย โม เฮี? ");
INSERT INTO lcp_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","เคียง ฮอยจ ซึป อาึ ลปุง ปะ ละ อื, ฟาโร เอีจ ยุฮ ป โซะ ป ไซญ ละ ปุย ฆาื อื โน่ง. ปะ ยุฮ เปอะ โตว โอเอีฮ ละ ซ เกือฮ เปอะ ปุย ไน แตะ โปน เม่ะมั่ก แตะ เฟือฮ,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ปเลี่ย เฮี ซ ยุ เปอะ ป ซ ยุฮ อาึ ละ ฟาโร. อาึ ซ คนัป เยอะ เกือฮ พลวย ปุย ไน อาึ เฮี โอก ฮา เมือง อื. ซ คนัป นึง อัมนัต ระ ยุฮ แตะ เกือฮ โครฮ อื โอก เอิน,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","พะจาว ลปุง แม ไม่ ไอ โมเซ. อัฮ เฮี, “อาึ มัฮ เยโฮวา. ");
INSERT INTO lcp_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","อาึ เอีจ เปลีฮ ติ แตะ ละ อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป. เอีจ รโฮงะ ละ อื มัฮ แตะ พะจาว อาวต ไม่ อัมนัต ตึก นึง ระ แตะ. อาึ ปังเมอ โอ รโฮงะ ติ แตะ ละ ตัม มอยฮ แตะ เยโฮวา. ");
INSERT INTO lcp_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","โนก ฮา เซ อาึ เอีจ เกือฮ ลปุง ซันญา ยุฮ แตะ ละ. อาึ เอีจ ซันญา อาึง ซ เกือฮ แตะ เมือง คะนาอัน ละ อื แปน คอง อื. ญันได่ เญือม อาวต ลั่ง อื เมือง เซ โฆะ โอ มัฮ ตอก อื ปุย โอ ไก เญือะ อาวต คราว โซม โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ปเลี่ย เฮี อาึ เอีจ ฮมอง เงอะ แงงัฮ โม อิซราเอน นึง เกือฮ โม อียิป อื แปน ครา เซีญ แตะ. อาึ ไตม เมอะ ลปุง ซันญา แตะ อาึง ไม่ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, อาึ มัฮ เยโฮวา. อาึ ซ เกือฮ โม เปะ โปน ฮา แปน เปอะ ครา เซีญ โม อียิป. อาึ ซ เปลีฮ อัมนัต ระ ยุฮ แตะ, ละ ซ เกือฮ แตะ โม เปะ โปน ฮา อื. อาึ ซ รเตีฮ โม อียิป เซ เกือฮ ลอก ตุต แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","อาึ ซ ตาว โม เปะ โอก นึง มัฮ เปอะ ปุย ไน อาึ. อาึ ซ แปน ลอป พะจาว ยุฮ เปอะ. เญือม เกือฮ อาึ โม เปะ โปน ฮา แปน เปอะ ครา เซีญ โม อียิป เปอ, เญือม เซ โม เปะ ซ ยุง เปอะ มัฮ อาึ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","อาึ ซ ตาว โม เปะ ฮอยจ นึง เมือง ป เอีจ ซันญา ซโตฮ แตะ อาึง ละ อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป, ละ ซ เกือฮ ฮะ แปน คอง โม เปะ. อาึ มัฮ พะจาว,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","รซอม เซ ไอ โมเซ ซึป อื ละ โม อิซราเอน. โม เซ ปังเมอ โอ ง่อต ป อัฮ อื, นึง ไลจ ลอน รพาวม อื ฆาื โซะ ป อาวม แตะ นึง แปน อื ครา เซีญ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","เญือม เซ พะจาว อัฮ อื ละ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ไมจ เปอะ โฮว ซตอก ฟาโร กซัต เมือง อียิป, เกือฮ พลวย โม อิซราเอน ละ ซ โฮลฮ อื โอก ฮา บั่นเมือง ยุฮ อื เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ไอ โมเซ โลยฮ อื, “ปัง มัฮ โม อิซราเอน ง่อต โตว ลั่ง ป อัฮ ฮะ. ฟาโร ซ ญอม ง่อต ป อัฮ อาึ ตอก เมอ? อาึ มัฮ โตว ปุย เกียฮ อัฮ เกียฮ มวยญ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","พะจาว ดวน ไอ โมเซ ไม่ อาโรน โฮว รโฮงะ อื ละ โม อิซราเอน ไม่ ละ ฟาโร, ละ ซ เกือฮ อื ยุง ซ เกือฮ พะจาว แตะ ตาว ปุย โฮวน เซ โอก ฮา เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ไลลวง เฮี มัฮ ไลลวง จัตเจือ ไพรม ไอ โมเซ ไม่ อาโรน. มอยฮ กวน รเมะ รูเบ่น (ป มัฮ กวน โรง อิซราเอน) มัฮ ฮาโนก, ปันลู, เฮซโรน, ไม่ คารมี. โม เซ มัฮ ไกญ เจอ รูเบ่น. ");
INSERT INTO lcp_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","มอยฮ กวน รเมะ ซิเมโอน มัฮ เยมูเอน, ยามิน, โอฮาต, ยาคิน, โซฮา ไม่ ชาอุน. ชาอุน เซ มัฮ กวน ปรโปวน ปุย เมือง คะนาอัน. โม เซ มัฮ ไกญ เจอ ซิเมโอน. ");
INSERT INTO lcp_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","มอยฮ กวน รเมะ เลวี มัฮ เกอโชน, โคฮัต, ไม่ เมรารี. เลวี ไก อาญุ ติ รอย ไม่ ง่วย อาแลฮ เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","มอยฮ กวน เกอโชน เซ มัฮ ลิปนี ไม่ ชิเมอี. มัฮ ไกญ ซฆลาวม โม เลวี เตือง ลอา แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","มอยฮ กวน โคฮัต เซ มัฮ อัมรัม, อิซฮา, เฮปโรน, ไม่ อุตซีเอน. โคฮัต เซ ไก อาญุ ติ รอย ไม่ ง่วย ลอวย เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","มอยฮ กวน เมรารี เซ มัฮ มาลี ไม่ มูชี. ไก เมาะ เซ ป มัฮ เจอ เลวี ไม่ ป มัฮ ไกญ ซฆลาวม ปุย นึง อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","อัมรัม เซ ไอฮ โยเคเบ่ต ป มัฮ รนัน เปือะ แตะ แปน ปุย เญือะ แตะ, ไก กวน ไม่ ปุ แตะ. มอยฮ กวน รเมะ อื มัฮ อาโรน ไม่ ไอ โมเซ. อัมรัม เซ ไก อาญุ ติ รอย ไม่ ง่วย อาแลฮ เนอึม เดอึม ยุม. ");
INSERT INTO lcp_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","มอยฮ กวน อิซฮา เซ มัฮ โครา, เนเฟก, ไม่ ซิกรี. ");
INSERT INTO lcp_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","มอยฮ กวน อุตซีเอน เซ มัฮ มิชาเอน, เอนซาฟัน ไม่ ซิตรี. ");
INSERT INTO lcp_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","อาโรน เซ ไอฮ เอลีเชบ่า แปน ปุย เญือะ แตะ. ปรโปวน เซ มัฮ กวน อัมมีนาดั่ป, มัฮ รนัน นาโชน. เอลีเชบ่า เซ ไก กวน รเมะ ปาวน. มอยฮ อื มัฮ นาดั่ป, อาบี่ฮู, เอเลอาซา, ไม่ อิทามา. ");
INSERT INTO lcp_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","มอยฮ กวน โครา เซ มัฮ อัตซี, เอนคานา ไม่ อาบี่ยาซัป. โม เซ มัฮ ไกญ เจอ โม โครา นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","เอเลอาซา ป มัฮ กวน อาโรน เซ ไอฮ กวน รโปวน ปูทิเอน ติ ปุย แปน ปุย เญือะ แตะ. ปรโปวน เซ ไก กวน รเมะ ติ, มอยฮ อื มัฮ ฟีเนฮัต. ปุย โม เซ เตือง โอยจ อื มัฮ ตื ป มัฮ ไกญ ปุย นึง เจอ เลวี เซ. ");
INSERT INTO lcp_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","เอีจ มัฮ อาโรน เซ ไม่ ไอ โมเซ เซ ป ฮมอง เซียง พะจาว เญือม อัฮ อื เฮี ละ อื โฮ, “ไมจ เปอะ นัม โม อิซราเอน เกือฮ โอก ฮา เมือง อียิป เกือฮ โอก โฮว แปน มู แปน มู แตะ,” ฮมอง อัฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","เอีจ มัฮ ปุย ลอา เซ ป ปัว กซัต เมือง อียิป พลวย โม อิซราเอน โอก โฮว ฮา ก อาวต แตะ. เอีจ มัฮ ไอ โมเซ เซ ไม่ อาโรน เซ ป ยุฮ เนอึม โอเอีฮ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","เญือม ลปุง พะจาว ไม่ ไอ โมเซ นึง เมือง อียิป เปอ มัฮ อัฮ อื ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“อาึ มัฮ พะจาว. ไมจ เปอะ ซึป ลปุง อาึ ละ ฟาโร ป มัฮ กซัต เมือง อียิป เซ โครยญ มวยญ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ไอ โมเซ อัฮ เฮี ละ พะจาว, “อาึ มัฮ ปุย โอ เกียฮ อัฮ เกียฮ มวยญ, ฟาโร แจง โอ อื ซ ง่อต ป อัฮ อาึ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","พะจาว อัฮ เฮี, “อาึ ซ เกือฮ ปะ โฮว ฆรอ ลปุง ตัง แตะ ละ ฟาโร. ซ เกือฮ อาโรน แปน ป ซึป ป อัฮ ป มวยญ เปอะ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","เมาะ ป อัฮ อาึ ละ เปอะ โครยญ เจือ ไมจ เปอะ อัฮ ละ อาโรน. อาโรน เซ ซ ซึป แม อื ละ กซัต นึง ซ เกือฮ อื พลวย โม อิซราเอน โอก ฮา เมือง แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","อาึ ซ เปลีฮ ป ซัมคัน ละ โม อียิป โฮวน เจือ ปอ ฮลัต ปุย นึง. อาึ ปังเมอ ซ เกือฮ รพาวม ฟาโร เซ ลึง. ");
INSERT INTO lcp_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","ซ ง่อต โตว ป อัฮ ปะ. เญือม เซ อาึ ซ ยุฮ ป โซะ ละ เมือง อียิป เบือ อัมนัต ระ ยุฮ แตะ, ซ เกือฮ ลอก ตุต แตะ. ซ ตาว ปุย ไน แตะ โอก โครยญ เจอ อื. ");
INSERT INTO lcp_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","เญือม เซ โม อียิป ซ ยุง อื ฆาื อื มัฮ อาึ พะจาว. ซ ยุง อื เญือม เปลีฮ อาึ อัมนัต ระ แตะ ละ อื นึง ซ เกือฮ แตะ โม อิซราเอน โอก ฮา เมือง อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ไอ โมเซ ไม่ อาโรน ยุฮ เนอึม อื ตัม ป อัฮ พะจาว ละ แตะ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","เญือม เลียก ลปุง อื ไม่ ฟาโร เซ, ไอ โมเซ เอีจ ไก อาญุ รเตะ เนอึม. อาญุ อาโรน เอีจ ไก รเตะ โรฮ ลอวย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","พะจาว อัฮ อื ละ ไอ โมเซ ไม่ อาโรน ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ดัฮ กซัต ดวน โม เปะ ยุฮ ป ซัมคัน โฮ, เกือฮ อาโรน ไปญ โคะ ฆิ ยุฮ แตะ. เกือฮ น่าึก อื ซองนา ฟาโร. โคะ ฆิ เซ ซ เปียน เอิน ติ แตะ แปน ซโอยญ ละ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","เญือม เซ ไอ โมเซ ไม่ อาโรน เลียก ลปุง เนอึม ไม่ ฟาโร ตัม ดวน พะจาว แตะ. อาโรน น่าึก เนอึม โคะ ฆิ แตะ ซองนา ฟาโร ไม่ โม ลุกนอง อื. แปน เนอึม ซโอยญ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ฟาโร กอก โม ป ไก คู ไก บ่า ไม่ ป เกียฮ โกว อัมนัต พี. โม เซ เกียฮ ยุฮ โรฮ อื ตอก เซ เบือ กทา กทอง แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","เญือม น่าึก อื โคะ ฆิ แตะ แปน โรฮ ซโอยญ ละ อื โครยญ โฆะ อื. โคะ ฆิ ยุฮ อาโรน ปังเมอ บลวน เอิน โคะ ฆิ ยุฮ โม เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ปัง ยุ โอเอีฮ ตอก เซ ฟาโร อาวต ลั่ง ไม่ รพาวม ลึง แตะ. ง่อต โตว ลั่ง ป อัฮ ป มวยญ ไอ โมเซ ไม่ อาโรน เซ. ตอก เนอึม ป เอีจ อัฮ พะจาว อาึง ละ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","พะจาว อัฮ อื ละ ไอ โมเซ ตอก เฮี, “ฟาโร ลึง ลั่ง รพาวม, ญอม โตว เกือฮ ปุย โอก โฮว. ");
INSERT INTO lcp_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ซง่าวป ก ซะ ไมจ เปอะ โฮว ซาวป ยุ ลไล โฮว เลีม อื โบ โกลงไน ป มัฮ โกลง ระ เมือง อียิป เซ. โรวก โคะ ฆิ ป เอีจ แปน ซโอยญ ติ โฮน เซ ไม่ เปอะ. มอง เฆียง โกลง. ");
INSERT INTO lcp_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","ไมจ เปอะ อัฮ เฮี ละ, ‘เยโฮวา พะจาว ทื โม ฮีบรู เอีจ เกือฮ อาึ ฮอยจ เคะ เปอะ. ดวน ปะ พลวย ปุย ไน แตะ เกือฮ โฮว ทไว โอเอีฮ ละ แตะ นึง ลาึน เวือฮ. บุน เอีจ ฟวยจ อื ปะ ดิ ง่อต เปอะ โตว เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ปเลี่ย เฮี พะจาว อัฮ ติ แตะ ซ เกือฮ ปะ ยุง ป มัฮ แตะ เบือ กัน ซ ยุฮ แตะ. อาึ ซ ปุฮ รอาวม นึง โคะ ฆิ เฮี. รอาวม ซ เปียน เอิน ติ แตะ แปน ฮนัม. ");
INSERT INTO lcp_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","กะ นึง โกลง เฮี ซ ยุม. โกลง เฮี ซ เรียง ซออย ปอ โอ โม อียิป ซ เกียฮ ญุ ฆาื อื’ ” อัฮ เซ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","เญือม เซ พะจาว เกือฮ ไอ โมเซ ดวน อาโรน ตอก เฮี, “ยวก โคะ ฆิ เปอะ ราว รอาวม เมือง อียิป เตือง โอยจ อื, เตือง โกลง เตือง นัมเมือง เตือง นอง ไม่ ทัมโลป โอเอีฮ. รอาวม ซ เปียน ติ แตะ แปน ฮนัม ฆาื อื, ฮอยจ ละ รอาวม โตะ โดง ไม่ โตะ ฮมวน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ไอ โมเซ ไม่ อาโรน ยุฮ เนอึม อื ตัม ดวน พะจาว แตะ. อาโรน ยวก เนอึม โคะ ฆิ แตะ ซองนา ฟาโร ไม่ โม จาวไน ป ยุฮ กัน ละ อื เซ, ปุฮ โกลง ระ นึง อื. รอาวม เปียน เนอึม ติ แตะ แปน ฮนัม. ");
INSERT INTO lcp_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","โกะโกลง นึง อื ยุม โอยจ. รอาวม เซ ซออย ปอ โอ ปุย เญาะ เกียฮ ญุ. ฮนัม เซ ไก เอิน เลี่ป เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","โม ป ไก คู ไก บ่า เมือง อียิป เซ ปังเมอ เกียฮ ยุฮ โรฮ อื ตอก เซ เบือ กทา กทอง แตะ. ฟาโร ลึง แนฮ ลั่ง รพาวม ตอก ไพรม แตะ. ง่อต โตว ลั่ง ป อัฮ ไอ โมเซ ไม่ อาโรน, ตอก เนอึม ป เอีจ อัฮ พะจาว อาึง. ");
INSERT INTO lcp_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ฮา ซ ง่อต อื, พัต ติ แตะ ฮา อื ลอต เลียก โตะ เญือะ แตะ. ญอม โตว ง่อต อื เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","โม อียิป จัมเปน กาวง นัมโม่ ฆาื อื เฆียง โกลง เซ นึง โอ แตะ เญาะ เกียฮ ญุ รอาวม โตะ โกลง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","เญือม เอีจ ไก อื อาแลฮ ซเงะ ฟวยจ เกือฮ พะจาว โกลง ระ เซ แปน ฮนัม เมอ. ");
INSERT INTO lcp_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","เญือม เซ พะจาว ดวน แม ไอ โมเซ โฮว เคะ ฟาโร. เกือฮ อื อัฮ เฮี ละ อื, “พะจาว ซตอก ปะ เกือฮ พลวย ปุย ไน แตะ โอก โฮว ละ ซ ทไว อื โอเอีฮ ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ดัฮ เปอะ โอ เกือฮ โฮว โฮ, อาึ ซ เกือฮ เม่ะมั่ก เกิต ละ เปอะ. ซ เกือฮ บั่ก ฮอยจ คัม เปอะ เลี่ป บั่นเมือง ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","โกลงไน เซ ซ นาวก นึง บั่ก, บั่ก เซ ซ โอก ฮา โกลง เซ, ซ ฮาวก ฮอยจ นึง เญือะ เปอะ, ฮอยจ ละ ฮอง ไอจ เปอะ, ไม่ เตียง ไอจ เปอะ. ซ เลียก โรฮ เญือะ จาวไน ไม่ เญือะ ลัปซด่อน ยุฮ เปอะ. ซ นาวก ฮอยจ นึง นา ก พรี ปุย โซม ไม่ โตะ โดง โตะ เดือง นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ซ เตน ฮาวก นึง โกะ เปอะ ไม่ โม จาวไน ไม่ โม ลัปซด่อน ยุฮ เปอะ, อัฮ เซ ละ เปอะ พะจาว.” ");
INSERT INTO lcp_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","เญือม เซ พะจาว ดวน ไอ โมเซ อัฮ อื ละ อาโรน ตอก เฮี, “ยวก โคะ ฆิ ไปญ เปอะ เซ. ซนาว ราว รอาวม เมือง อียิป เตือง โกลง ไม่ นัมเมือง ไม่ นอง โอเอีฮ, เดอึม บั่ก ซ โอก ฆาื เลี่ป เมือง อียิป เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","อาโรน ยุฮ เนอึม อื ตอก เซ. โอก เนอึม บั่ก ละ โฮวน, ปอ นาวก อื ยุฮ ปลัฮเตะ เมือง อียิป เซ. ");
INSERT INTO lcp_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","โม ป ไก คู ไก บ่า เยอ, ยุฮ โรฮ อื ตอก เซ เบือ กทา กทอง แตะ. เกือฮ โรฮ บั่ก โอก โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","เญือม เซ ฟาโร กอก ไอ โมเซ ไม่ อาโรน เอีญ เคะ แตะ. อัฮ เฮี ละ อื, “ไมจ เปอะ ไววอน ละ พะจาว, เกือฮ ตุย แปฮ บั่ก เฮี เกือฮ โปน ฮา เอะ. อาึ ซ เกือฮ ปุย ไน โม เปะ โฮว, เดอึม เปอะ ซ เกียฮ ทไว โอเอีฮ ละ พะจาว ยุฮ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ไอ โมเซ อัฮ เฮี, “อาึ เตม รพาวม ละ ซ ไววอน แตะ เพือ เปอะ. ไมจ ปะ พัต ซเงะ จี ซาวม ละ ซ เกือฮ เปอะ อาึ ไววอน เพือ แตะ เตือง โม จาวไน ไม่ โม ลัปซด่อน ยุฮ เปอะ. ฟวยจ เซ เญือะ ซ ไก โตว เฟือฮ บั่ก นึง เญือะ นึง ย่วง, ซ ไก นึง โกลง โน่ง. ซ เกือฮ เปอะ อาึ ไววอน เญือม เมอ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","“ไววอน ซง่าวป เปอ,” อัฮ เซ ฟาโร. ไอ โมเซ อัฮ เฮี, “อาึ ซ ยุฮ ตัม ป อัฮ เปอะ เซ เดอึม เปอะ ซ ยุง โอ พะจาว ไฮญ ไก ป ตอก เยโฮวา พะจาว ทื เอะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","โม เปะ เตือง โม จาวไน ไม่ โม ลัปซด่อน ยุฮ เปอะ ซ โปน เปอะ ฮา คัม บั่ก แตะ เซ. เญือะ ซ ไก โตว ละ เปอะ โนก ฮา นึง โกลงไน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ไอ โมเซ ไม่ อาโรน โอก ฮา ฟาโร เซ. ไอ โมเซ ไววอน เนอึม ปัว พะจาว ตุย บั่ก ป คัม ฟาโร เซ โอก ฮา อื. ");
INSERT INTO lcp_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","พะจาว ง่อต ป อัฮ อื, บั่ก เซ ยุม นึง ย่วง นึง เญือะ นึง ม่า โครยญ โดฮ. ");
INSERT INTO lcp_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","โม อียิป รโจะ อื แปน กอง แปน กอง แตะ. เมือง เซ ซออย ลัมเลือ เอิน. ");
INSERT INTO lcp_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ฟาโร เซ เญือม ยุ อื ยุม บั่ก เซ เกือฮ แม รพาวม แตะ ลึง. ง่อต โตว อื ลั่ง ป อัฮ ไอ โมเซ ไม่ อาโรน ละ แตะ เซ. ตอก เนอึม ป เอีจ อัฮ พะจาว อาึง. ");
INSERT INTO lcp_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","พะจาว อัฮ แม อื ละ ไอ โมเซ ตอก เฮี, “เกือฮ อาโรน ปุฮ เตะ รกาื นึง โคะ ฆิ แตะ. ฟวยจ เซ รกาื เลี่ป เมือง อียิป เซ ซ แปน ลลอง ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","อาโรน ปุฮ เนอึม เตะ รกาื นึง โคะ ฆิ แตะ. รกาื ติ เมือง อียิป เซ แปน เนอึม ลลอง ราวม ปุย ไม่ ซัตซิง เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ลลอง เซ เลี่ป ยุฮ เมือง. โม ป ไก คู ไก บ่า เยอ ริ โกว กทา กทอง แตะ ละ ซ เกือฮ แตะ ลลอง โอก ปังเมอ โอ เญือะ เกียฮ ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","โม เซ อัฮ เฮี ละ กซัต ฟาโร, “โอเอีฮ ตอก เฮี ตึน ซ มัฮ เนอึม อัมนัต ระ ยุฮ พะจาว,” อัฮ เซ. รพาวม ฟาโร ปังเมอ ลึง แนฮ ลั่ง. ง่อต โตว ลั่ง ป อัฮ ไอ โมเซ ไม่ อาโรน. ตอก เนอึม เอีจ อัฮ พะจาว อื อาึง. ");
INSERT INTO lcp_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ฟวยจ เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ซง่าวป ก ซะ อา โฮว ซาวป ยุ ฟาโร ลไล โฮว เลีม อื โบ โกลง. อัฮ ละ อื ตอก เฮี, พะจาว อัฮ เฮี, ไมจ เปอะ เกือฮ ปุย ไน อาึ โฮว ไว อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ตัม โอ เปอะ เกือฮ ปุย ไน อาึ โฮว, อาึ ซ เกือฮ โรป ฮอยจ ราวม โม เปะ เตือง จาวไน เตือง โม ลัปซด่อน ยุฮ เปอะ เตือง โอยจ อื. โตะ เญือะ เปอะ ซ เลียก โอยจ นึง อื. ปลัฮเตะ อาวต โม เปะ ซ นาวก โอยจ นึง โรป เซ. ");
INSERT INTO lcp_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ซเงะ เซ อาึ ซ เกือฮ เมือง โกเชน ตัง ฮา ก ไฮญ, นึง อาวต ปุย ไน อาึ นึง อื. ซ เกือฮ โตว โรป เลียก นา เซ. โม เปะ ซ ยุง เปอะ มัฮ อาึ พะจาว ป เปลีฮ อัมนัต แตะ นึง เมือง เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","อาึ ซ รกัฮ ปุย ไน แตะ ฮา ปุย ไน โม เปะ เกือฮ ตัง ฮา ปุ แตะ. กัน ซัมคัน เฮี ซ เกิต ละ เปอะ ซง่าวป เอิน,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ฟวยจ เซ พะจาว ยุฮ เนอึม อื ตอก เซ. เกือฮ เนอึม โรป เซ ฮอยจ โฮวน, ราวม เญือะ ฟาโร ไม่ เญือะ โม จาวไน. โรป โฮวน เซ คัม เมือง อียิป เลี่ป อื. ไลจ เนอึม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","เญือม เซ ฟาโร กอก ไอ โมเซ ไม่ อาโรน ฮอยจ เคะ แตะ. อัฮ เฮี ละ อื, “โฮว เมิฮ. โฮว ทไว โอเอีฮ ละ พะจาว ยุฮ เปอะ, ปังเมอ ไมจ เปอะ ทไว ละ อื นึง เมือง อาวต เปอะ เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ไอ โมเซ โลยฮ อื, “แปน โตว ตอก เซ. โม อียิป ทื ซัตซิง ป ซ ไมจ เอะ ทไว ละ พะจาว ยุฮ ฮุ. ซ แปน ป พิต ละ อื มอก เอะ โอเอีฮ ตอก เซ. ดัฮ ยุ มอก เอะ ซัตซิง ตอก เซ โม่ ซ แล่น เอะ นึง ซโมะ ฆาื อื? ");
INSERT INTO lcp_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","เอะ จัมเปน โฮว ลอวย ซเงะ คระ ฮอยจ นึง ลาึน เวือฮ เดอึม ซ เกียฮ ทไว โอเอีฮ ละ เยโฮวา พะจาว ยุฮ แตะ, ตอก เอีจ ซตอก อื อาึง ละ เอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ฟาโร อัฮ เฮี, “อาึ ซ เกือฮ โม เปะ โฮว นึง ลาึน เซ ละ ซ ทไว เปอะ โอเอีฮ ละ พะจาว ยุฮ เปอะ, ปังเมอ โอ เปอะ ไมจ โฮว ซไง. ปัว เปอะ ไววอน เพือ อาึ ไม่ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ไอ โมเซ อัฮ เฮี, “ดัฮ อาึ เอีจ โอก ฮา นา เฮี อาึ ซ ไววอน เอิน เพือ เปอะ. ซง่าวป โรป โม เฮี ซ ไฆร ฮา เปอะ, ไม่ ฮา โม ลัปซด่อน ไม่ โม จาวไน. ตอก ออฮ ตอก เอีฮ ญุ่ก ปังเมอ โอ เปอะ ไมจ จุ เอะ นึง โอ เปอะ ซ พลวย เนอึม ปุย โฮว ทไว โอเอีฮ ละ พะจาว,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","เญือม เซ ไอ โมเซ โอก ฮา ฟาโร, ไววอน ปัว อื นึง พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","พะจาว เกือฮ อื ละ อื ตัม ป ปัว อื เซ. โรป เซ ไฆร เนอึม ฮา ฟาโร ไม่ โม จาวไน ไม่ โม ลัปซด่อน. เญาะ โฮฮ โตว ติ ตัว เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ฟาโร เซ ปังเมอ เกือฮ แม รพาวม แตะ ลึง ติ โฮน แม. พลวย โตว ลั่ง ปุย โอก โฮว. ");
INSERT INTO lcp_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","พะจาว อัฮ อื ละ ไอ โมเซ ตอก เฮี, “ไมจ เปอะ โฮว เคะ ฟาโร, อัฮ ละ อื ตอก เฮี, อาึ มัฮ พะจาว ทื โม ฮีบรู, ไมจ เปอะ เกือฮ ปุย ไน อาึ โอก โฮว ละ ซ ทไว อื โอเอีฮ ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ดัฮ เปอะ คนัป แนฮ อาวต, โอ แนฮ ญอม เกือฮ โฮว โฮ, ");
INSERT INTO lcp_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","อาึ ซ เกือฮ พาญัต ฆอก ฮอยจ ละ ซัตซิง เลียง เปอะ เตือง บรอง ไม่ บรัง, อุต, โมวก, แกะ, ปิ, เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","อาึ ซ เกือฮ คอง เลียง โม อิซราเอน ตัง ฮา คอง เลียง โม อียิป. ซัตซิง เลียง โม อิซราเอน ซ ยุม โตว ติ ตัว เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","โอเอีฮ ตอก เซ ซ เกิต ละ เปอะ ซง่าวป เอิน,” อัฮ เซ ละ อื. พะจาว เอีจ รโฮงะ อาึง อื ละ อื ตอก เซ เญือม ซ เกิต โอเอีฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ปวยฮ พริ เซ พะจาว ยุฮ เนอึม อื ตัม ป อัฮ แตะ อาึง. คอง เลียง โม อียิป ยุม เนอึม แกล. คอง เลียง โม อิซราเอน ปังเมอ โอ ยุม ติ ตัว เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","เญือม ดวน ฟาโร ปุย โอก โฮว ไฮมญ ฮมอง ป เกิต ละ ซัตซิง ยุฮ โม อิซราเอน เนอ, ฮมอง โอ อื ยุม ติ ตัว เนอึม. เญือม เอีจ ฮมอง อื ปังเมอ ลึง ลั่ง รพาวม อื. เกือฮ โตว ลั่ง ปุย โอก โฮว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ฟวยจ เซ พะจาว อัฮ อื ละ ไอ โมเซ ไม่ อาโรน ตอก เฮี, “ไมจ เปอะ กาวป จะ โตะ อังโล ติ ลอา ซบราวก เปอะ. เกือฮ ไอ โมเซ เลียก เจาะ จะ เซ ซองนา ฟาโร. ");
INSERT INTO lcp_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","จะ เซ ซ แปน ตอก รกาื จัว ปอย เลี่ป เมือง อียิป. ซ เกือฮ เอิน ปุย ไม่ ซัตซิง ติ เมือง อียิป เซ เกิต ปาวม ละ, เกือฮ อื อาวม ป โซะ เตือง โอยจ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ปุย ลอา เซ ตุย เนอึม จะ โตะ อังโล. เลียก ชุง ไม่ อื ซองนา ฟาโร เซ. ไอ โมเซ เจาะ จะ เซ. โม อียิป ไม่ คอง เลียง อื เซ เกิต เนอึม ปาวม ละ. ปาวม เซ มา เลี่ป โกะ เลี่ป ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","โม ป ไก คู ไก บ่า เยอ เญือะ เกียฮ ฮอยจ โตว เคะ ไอ โมเซ นึง ปาวม โรฮ อื เลี่ป โกะ เลี่ป ตัว แตะ ตอก โรฮ โม อียิป เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ปัง มัฮ ตอก เซ พะจาว เกือฮ ลั่ง รพาวม ฟาโร ลึง, ญอม โตว ลั่ง ง่อต ลปุง ไอ โมเซ ไม่ อาโรน เฟือฮ. ตอก เนอึม ป เอีจ อัฮ พะจาว อาึง ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","พะจาว ดวน แม ไอ โมเซ งาวป โกฮ โฮว เคะ ฟาโร. เกือฮ อื อัฮ เฮี ละ อื, “พะจาว ยุฮ โม ฮีบรู อัฮ เฮี, ไมจ เปอะ เกือฮ ปุย ไน อาึ โฮว, ละ ซ ไว อื อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ดัฮ เปอะ โอ พลวย โฮ, อาึ ซ เกือฮ ป โซะ เกิต ละ เปอะ โฮวน เจือ. ซ เกิต โรฮ ละ โม จาวไน ไม่ โม ลัปซด่อน ยุฮ เปอะ, เดอึม โม เปะ ซ ยุง โอ ปุย ไฮญ ติ ปลัฮเตะ เฮี ไก ป ตอก อาึ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","มัฮ ฆวต ยุฮ ฮุ, อาึ เอีจ เลี่ญ ปุน เกือฮ ป โซะ ฮอยจ ละ ปะ ไม่ โม ลัปซด่อน ยุฮ เปอะ ปอ ไฆร เปอะ ฮา ปลัฮเตะ เฮี เตือง โอยจ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","ญันได่ เอีจ มัฮ อาึ ป เกือฮ ปะ ไอม ลั่ง ฮอยจ เมาะ เฮี, นึง ซ เปลีฮ อัมนัต ยุฮ แตะ ละ เปอะ, ไม่ ซ เกือฮ มอยฮ แตะ พรุ เฮือ ละ ปุย เลี่ป เตะ ฆาื ป เกิต ละ ปะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","ปะ เกือฮ แนฮ เปอะ ติ แตะ ลึง รพาวม นึง เกละ เปอะ ยุ ปุย ไน อาึ. ญอม เปอะ โตว เกือฮ โฮว ติ ชวง. ");
INSERT INTO lcp_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","เคียง มัฮ อื ตอก เซ ซง่าวป เมือ ปเลี่ย เฮี อาึ ซ เกือฮ แพร ราื นึง เมือง อียิป เฮี. เน่อึม เญือม เกิต โรง เมือง อียิป ฮอยจ ปเลี่ย, ดิ ไก โตว ติ โฮน เนอึม โซะ ราื แพร เมาะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ปเลี่ย เฮี ไมจ เปอะ ดวน ปุย ซาวป โครฮ คอง เลียง คอง ดู่ แตะ ป อาวต เพระด่าวก, เกือฮ เลียก อาวต ฆรึม พรัง. ดัฮ เปอะ โอ ยุฮ ตอก เซ โฮ, โอเอีฮ เมาะ ป อาวต ลั่ง อื ก พริ เซ ซ ยุม ตื, เตือง ปุย เตือง ซัตซิง เตือง โอยจ อื, อัฮ เซ ละ เปอะ พะจาว ป ทื โม ฮีบรู เยอ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","เญือม เซ โม จาวไน ป ฮลัต นึง ลปุง พะจาว ซไจ เกือฮ ปุย ซาวป ซเพระ กวนไจ ยุฮ แตะ ไม่ ซัตซิง ยุฮ แตะ เกือฮ อื เลียก อาวต ฆรึม พรัง. ");
INSERT INTO lcp_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","โม ป โอ เครอึง นึง อื ละ อื ก พริ. ");
INSERT INTO lcp_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ซนาว เตะ เปอะ ลั่ก มะลอง เดอึม แพร ซ ราื นึง เมือง อียิป. ซ เกือฮ ลอก ปุย ไม่ ซัตซิง ไม่ โอเอีฮ ซมา ปุย นึง ชิจ นึง ม่า เตือง โอยจ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","เญือม ยวก ไอ โมเซ โคะ ฆิ ยุฮ แตะ ลั่ก มะลอง, พะจาว เกือฮ เนอึม แพร ราื ไม่ เนอึม บริ เลีฮ ตะ ฮอยจ ลังเตะ. ");
INSERT INTO lcp_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ติ เมือง อียิป เซ ราื แพร ระ แพร โฮวน นึง ไม่ ปลุกปลัก เนอึม บริ กาื ระ กาื กอ. เน่อึม เญือม ไก โรง เมือง อียิป ฮอยจ ปเลี่ย ดิ ไก โตว ติ โฮน เนอึม โซะ ราื แพร ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","แพร เซ ราื เลี่ป เมือง อียิป, ลอก โอเอีฮ ป อาวต เพระด่าวก เตือง ปุย เตือง ซัตซิง. โอเอีฮ ป ซมา ปุย นึง ชิจ นึง ม่า ไลจ โอยจ. โคะ เอาะ ไลจ ตื โรฮ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","มัฮ นาตี โกเชน นา ก อาวต โม อิซราเอน โน่ง นา ก โอ แพร เซ ราื นึง เงอ. ");
INSERT INTO lcp_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","เญือม เซ ฟาโร ดวน ปุย โฮว กอก ไอ โมเซ ไม่ อาโรน ฮอยจ เคะ แตะ. อัฮ เฮี ละ อื, “อาึ เอีจ พิต เนอึม เมอะ โฮน เฮี, พิต เตือง อาึ เตือง ปุย ไน เยอะ โรฮ. มัฮ พะจาว ป ปุก เกอ. ");
INSERT INTO lcp_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ไมจ เปอะ ปัว นึง พะจาว. เอีจ เคราะ อื เมาะ เซ แพร ระ แพร โฮวน ไม่ เนอึม บริ เซ. เญือะ เกือฮ โตว เปอะ อาวต. ซ เกือฮ เนอึม เปอะ โฮว,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ไอ โมเซ โลยฮ อื, “เญือม โอก เกอะ ฮา เวียง เฮี อาึ ซ ยวก เตะ แตะ ไววอน ปัว นึง พะจาว. เญือม เซ เญือะ ซ ฮมอง เปอะ โตว เนอึม บริ. แพร ปุ โรฮ เญือะ ซ ราื เดอึม โม เปะ ซ ยุง มัฮ ปลัฮเตะ เฮี คอง พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","อาึ ปังเมอ ยุง เงอะ โอ ปะ ไม่ โม จาวไน ป รซอฮ ละ เปอะ เซ ดิ ฮลัต เนอึม นึง พะจาว,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","โคะ ฆัน ซมา ปุย ไม่ เฮงาะ บ่าเล เอีจ ไลจ โอยจ นึง เอีจ ซฆรัฮ เฮงาะ เซ. โคะ ฆัน เอีจ เตีย โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ป มัฮ เฮงาะ ซาลี ไม่ เฮงาะ รเซฮ ปังเมอ โอ ทัน ไลจ นึง แตวะ ลั่ง อื. ");
INSERT INTO lcp_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ไอ โมเซ โอก ฮา ฟาโร ลอต โอก ก พริ เวียง. ยวก เตะ แตะ ไววอน ปัว อื นึง พะจาว. เญือม เซ ลโล่ะ เอิน เฮละ ระ กาื กอ ไม่ แพร ไม่ เนอึม บริ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ฟาโร เญือม ยุ อื เอีจ โอง อื ไม่ โอ แพร เญือะ ราื ไม่ โอ บริ เญือะ เนอึม เมอ, ยุฮ แม ป พิต ตอก ไพรม แตะ. โกะ อื ไม่ จาวไน ป รซอฮ ละ อื อาวต แม ไม่ รพาวม ลึง แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","รพาวม ฟาโร เซ ลึง ลอน. ญอม โตว ลั่ง พลวย โม อิซราเอน โฮว. ตอก เนอึม เอีจ อัฮ พะจาว อาึง ละ ไอ โมเซ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ฟวยจ เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ โฮว แม เคะ ฟาโร. อาึ เอีจ เกือฮ รพาวม อื ลึง ฮอยจ ละ รพาวม โม จาวไน ป รซอฮ ละ อื เซ, นึง ซ โฮลฮ อาึ ยุฮ ป ซัมคัน ลลาึง อื ปอ เงอึต ปุย นึง. ");
INSERT INTO lcp_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","โม เปะ ซ โฮลฮ เปอะ อู ละ กวน แตะ ไม่ กวนโซะ กวนแซะ เปอะ เฆียง เฮี ฆาื อื, ตอก ยุฮ อาึ ป โซะ ละ โม อียิป ไม่ ป ซัมคัน โฮวน เจือ. โม เปะ ซ ยุง โรฮ เปอะ มัฮ อาึ พะจาว ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ไอ โมเซ ไม่ อาโรน โฮว เนอึม เคะ ฟาโร. อัฮ เฮี ละ อื, “เยโฮวา พะจาว ทื โม ฮีบรู อัฮ เฮี ละ เปอะ, ซ เลี่ญ ลั่ง เมาะ เมอ แล ลึง รพาวม เปอ, โอ เปอะ ญิงญอม ละ อาึ อื? ไมจ เปอะ พลวย ปุย ไน อาึ เกือฮ โฮว ละ ซ ไว อื อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ดัฮ เปอะ โอ แนฮ ญอม เกือฮ โฮว โฮ, ซง่าวป อาึ ซ เกือฮ ซดู ฮอยจ นึง เมือง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ซ เกือฮ ฮอยจ โฮวน ปอ โอ ปุย เญือะ เกียฮ ยุ ปลัฮเตะ เอิน. ซ โซม โอเอีฮ ป ไอม ลั่ง ฟวยจ ราื แพร เซ เตือง ฮละ โคะ โอเอีฮ นึง ชิจ นึง ม่า โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","ซดู เซ ซ นาวก ฮอยจ นึง เญือะ เปอะ ไม่ นึง เญือะ โม จาวไน ไม่ โม ลัปซด่อน ยุฮ เปอะ. ซ โฮฮ ฮา ยุ ฮา ฮมอง ปุย อื, เน่อึม นึง เจน จัตเจือ ไพรม เปอะ เคียง อาวต โรง อื เมือง เฮี ฮอยจ ปเลี่ย, อัฮ เซ ละ เปอะ พะจาว,” อัฮ เซ. เญือม เซ ไอ โมเซ พัต ติ แตะ โอก ฮา เญือะ ฟาโร. ");
INSERT INTO lcp_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","เญือม เซ โม จาวไน ปัว อื นึง ฟาโร ตอก เฮี, “ปัว เปอะ เกือฮ โม ปรเมะ ไน โม เซ โฮว แปฮ. เกือฮ โฮว ไว พะจาว ทื แตะ เซ เมิฮ. อัม มัฮ โอ เปอะ ยุ ไลจ โลม เมือง อียิป เตือง ปะเทต อื? ซ เลี่ญ แม เมาะ เมอ เม่ะมั่ก เอะ ฆาื ปุย โม เซ เยอ? เกือฮ แปฮ โฮว เมิฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","เญือม เซ ปุย โฮว กอก ไอ โมเซ ไม่ อาโรน ฮอยจ แม เคะ กซัต เซ ฆาื อื. กซัต เซ อัฮ เฮี ละ อื, “โฮว ไว เยโฮวา พะจาว ทื เปอะ เซ เมิฮ. มัฮ ปุย ติ ติ ป ซ ไมจ อื โฮว เยอ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ไอ โมเซ โลยฮ อื ตอก เฮี, “ไมจ เอะ โฮว เตือง โอยจ แตะ เตือง ป กวต กวนดุ กวน รเมะ กวน รโปวน เนอะ ไม่ ครัก โมวก แกะ ปิ โอเอีฮ ยุฮ ฮุ, นึง ซ ไมจ เลียง ปุ แตะ ไม่ ทไว แตะ โอเอีฮ ละ พะจาว,” อัฮ เซ ละ อื ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ฟาโร โลยฮ แม อื, “อาึ ซันญา อาึง เบือ มอยฮ พะจาว โอ แตะ ซ เกือฮ โม เปะ โฮว เตือง โม ปรโปวน ไม่ โม กวนดุ เฟือฮ เอิน. อาึ เอีจ ที เนิ โอ โม เปะ เนอึม รพาวม ละ เอะ เอ. ");
INSERT INTO lcp_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","อาึ เกือฮ โตว โม ปรโปวน ไม่ กวนดุ โฮว. เกือฮ โม ปรเมะ โฮว โน่ง ละ ซ ไว เปอะ พะจาว ยุฮ แตะ เซ. เอีจ มัฮ เซ ป ปัว เปอะ เน่อึม เมือ โรง อื,” อัฮ เซ ละ อื. เญือม เซ ฟาโร เกือฮ ปุย โครฮ ปุย ลอา เซ โอก ฮา ก อาวต แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ฟวยจ เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ ยวก เตะ แตะ ราว เมือง อียิป เกือฮ ซดู ฮอยจ ราวม เมือง อียิป เฮี ละ ซ เกือฮ อื โซม โอเอีฮ ป ไอม ลั่ง นึง ชิจ นึง ม่า นึง รปึม ยุฮ อื เตือง โอยจ อื, เมาะ ป ไก ลั่ง อื เคียง ฟวยจ ราื แพร ระ เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ไอ โมเซ ยวก เนอึม โคะ ฆิ ยุฮ แตะ. พะจาว เกือฮ กาื ลวง ลั่ก โอก ซเงะ ฮอยจ ฆาื อื ติ ซเงะ ไปล ติ ซาวม. ปวยฮ พริ เซ ฮอยจ เนอึม ซดู เซ. ");
INSERT INTO lcp_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ราวม เนอึม เมือง อียิป โครยญ โดฮ. ไพรม อื ไก โตว ซดู ฮอยจ โฮวน เมาะ เซ. เฆียง เฮี ปุ เญือะ ซ ไก โฮวน เมาะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ซดู เซ นาวก เอิน ยุฮ ปลัฮเตะ ปอ เฟียก เอิน อื. โซม เนอึม โอเอีฮ ป ไอม ลั่ง นึง ชิจ นึง ม่า ป โฮฮ ฮา ไลจ แตะ นึง แพร เซ. โอยจ แกล ฮอยจ เปลิ โคะ เปลิ เอาะ. เญือะ ไก โตว ฮละ โคะ ซงา นึง ติ เจือ เนอึม, ปัง มัฮ โคะ เอาะ ญุ่ก, ปัง มัฮ พักเญือ ญุ่ก, เญาะ ไก โตว ติ ตื เนอึม ไน ติ เมือง อียิป เซ. ");
INSERT INTO lcp_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","เญือม เซ ฟาโร ซไจ เอิน กอก ไอ โมเซ ไม่ อาโรน เอีญ เคะ แตะ ฆาื อื. อัฮ เฮี ละ อื, “อาึ เอีจ พิต เนอึม ละ พะจาว ยุฮ เปอะ. พิต โรฮ ละ โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ปัว แม เปอะ ยวก พิต โฌวะ ยุฮ อาึ เฮี เนิ ติ โฮน แม โน่ง. ปัว เปอะ ไววอน ละ พะจาว ยุฮ เปอะ เกือฮ เม่ะมั่ก ปอ ยุม เฮี โปน อาึ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ไอ โมเซ โอก ฮา ฟาโร ไววอน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","พะจาว เปียน กาื เกือฮ อื แปน กาื กอ ลวง เลียก ซเงะ. กาื เซ โรวก ซดู โม เซ เกือฮ อื ดุฮ โตะ ปลัฮ รอาวม ซครัก. เญือม เซ นึง เมือง อียิป เซ เญือะ ไก โตว ซดู นึง ฆาื อื ติ ตัว เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","พะจาว ปังเมอ เกือฮ แนฮ ลั่ง รพาวม ฟาโร เซ ลึง. ฟาโร ดิ ญอม โตว ลั่ง พลวย โม อิซราเอน เกือฮ โฮว. ");
INSERT INTO lcp_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","เญือม เซ พะจาว ดวน ไอ โมเซ ตอก เฮี, “ยวก เตะ เปอะ โร มะลอง นึง, เดอึม ซ เฟียก ติ เมือง อียิป เฮี. มัฮ เฟียก ตัน ปอ เกียฮ อาวม ปุย อื เอิน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ไอ โมเซ ยวก เนอึม เตะ แตะ โร มะลอง นึง อื. เมือง อียิป เฟียก ตัน เนอึม ฆาื อื ลอวย ซเงะ ลอวย ซาวม เอิน. ");
INSERT INTO lcp_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ไน ติ เจน ลอวย ซเงะ เซ ไก โตว ป เกียฮ ยุ โอเอีฮ นึง ติ เจือ เนอึม. ปุย โฮลฮ โตว โอก ฮา ก อาวต แตะ ฆาื อื. ก อาวต โม อิซราเอน ปังเมอ ซเปีย แนฮ ละ อื ตอก ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","เญือม เซ ฟาโร กอก ไอ โมเซ เอีญ เคะ แตะ. อัฮ เฮี ละ อื, “โฮว เมิฮ. โฮว ไว พะจาว ยุฮ เปอะ. ซ เกือฮ โม ปรโปวน ไน เปอะ โฮว ไม่ เปอะ ไม่ โม กวนดุ โรฮ. คอง เลียง คอง ดู่ เปอะ ปังเมอ โอ เปอะ ไมจ โรวก,” อัฮ เซ ฟาโร เซ. ");
INSERT INTO lcp_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ไอ โมเซ โลยฮ อื, “ปะ ไมจ เปอะ เกือฮ เอะ โฮลฮ โรวก ซัตซิง ละ ซ มอก เกอะ ตอง ทไว ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","คอง เลียง เงอะ ไมจ อื โฮว ไม่ เอะ โครยญ ตัว. เอะ เกียฮ ละ โตว อาึง ติ ตัว เนอึม. เอะ ซ จัมเปน เลือก ง่อน ละ ซ ทไว เยอะ ละ พะจาว ยุฮ ฮุ. กา เฆียง ฮอยจ เจอะ นา ก ทไว แตะ เซ เอะ ดิ ยุง โตว ตัว มัฮ ตัว มอยฮ อื. พะจาว ดิ รโฮงะ โตว อื ละ เอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","พะจาว เกือฮ ลั่ง รพาวม ฟาโร เซ ลึง. ฟาโร ญอม โตว ลั่ง พลวย โม เซ เกือฮ โฮว. เญือม เซ ฟาโร ฮาวก รพาวม. ");
INSERT INTO lcp_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","อัฮ เฮี, “เอีญ แปฮ. อาึ เอีจ เตือ เอีจ ออป เนอึม นึง เปอะ. เฆิม เฮี โฮว ไป นา เยอ ปุ เญือะ เกือฮ อาึ ยุ นา เปอะ เฟือฮ เอิน. ยุ อาึ นา เปอะ ซเงะ ออฮ ซ ยุม เปอะ ซเงะ เซ,” อัฮ เซ ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ไอ โมเซ โลยฮ อื, “เตอึม รพาวม เปอะ. เฆิม เฮี ปะ เญือะ ซ โฮลฮ เปอะ โตว เนอึม ยุ นา อาึ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","กา เซ พะจาว เอีจ อัฮ อื ละ ไอ โมเซ ตอก เฮี, “ซ ไก ลั่ง ติ เจือ โน่ง เม่ะมั่ก ซ เกือฮ อาึ ฮอยจ ละ ฟาโร ไม่ เมือง อียิป เฮี. ฟวยจ เซ ฟาโร ซ พลวย โม เปะ โฮว. โฮฮ ฮา พลวย อื ซ โครฮ เอิน โม เปะ โอก ริป เอิน. ");
INSERT INTO lcp_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ไมจ เปอะ ซตอก โม อิซราเอน เตือง ปรเมะ ปรโปวน, เกือฮ โฮว ปัว เครอึง มาื เครอึง ไคร นึง ปุ ย่วง แตะ ป มัฮ โม อียิป เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","พะจาว เกือฮ โม อียิป เซ ไก รพาวม ฆวต เรอึม โม อิซราเอน. โม อียิป เซ นัปทื เนอึม โรฮ ไอ โมเซ เซ, เตือง โม จาวไน ไม่ โม ลัปซด่อน นึง อื, เมีญ ตื ไอ โมเซ มัฮ ปุย ระ เนอึม ไล ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","เญือม เซ ไอ โมเซ อัฮ อื ตอก เฮี, “เฮี มัฮ เนอึม ลปุง พะจาว, ซาวม เนาะ เฮี เมาะ ง่อน ซาวม เมอ อาึ ซ โฌ นึง เมือง อียิป เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","เมาะ ป มัฮ กวน รเมะ โรง โม อียิป ซ ยุม เตือง โอยจ อื, เน่อึม นึง กวน กซัต ป ลัง อาวต เบือง เปือะ แตะ, ฮอยจ ละ กวน ครา เซีญ ปุย ป โม แปง นึง อื. กวน คอง เลียง ปุย ป กิฮ โรง นึง อื ซ ยุม โรฮ โครยญ ตัว. ");
INSERT INTO lcp_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ปุย ติ เมือง อียิป ซ เยือม เนอึม เยือม แนม ฆาื อื. เน่อึม ไพรม อื ฮอยจ ปเลี่ย ดิ ไก โตว ติ ชวง โซะ เยือม ปุย ตอก โฮน เฮี. เฆียง เฮี ปุ เญือะ ซ โซะ เมาะ เฮี ติ โฮน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ลลาึง โม อิซราเอน เนอ ซ ไก โตว เซียง โรฮ เซาะ นึง อื, ละ ปุย ญุ่ก, ละ ซัตซิง ญุ่ก. โม เปะ ซ ยุง เปอะ ฆาื อื ตอก เกือฮ อาึ โม อิซราเอน ไม่ โม อียิป ตัง ฮา ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","โม จาวไน ป รซอฮ ละ เปอะ เซ ซ เลียก เคะ อาึ. ซ นุ่ม ไว อาึ ปอ จิ ไกญ แตะ เตะ ละ ซ ปัว อื อาึ ไม่ โม ป มัฮ ปุย บลัฮ ลั่ก อาึ โอก โฮว ฮา แตะ. เญือม เซ อาึ ซ โอก โฮว เนอึม เมอะ,” อัฮ เซ. เญือม เซ ไอ โมเซ โอก ฮา ฟาโร ไม่ ฮาวก รพาวม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","กา เซ พะจาว เอีจ อัฮ อาึง อื ละ ไอ โมเซ ตอก เฮี, “ฟาโร ตึน โอ ซ ง่อต ป อัฮ ปะ ละ แตะ. เอีจ มัฮ เกือฮ แปน ตอก เซ นึง ซ โฮลฮ อาึ เปลีฮ ป ซัมคัน ยุฮ แตะ โฮวน เจือ นึง เมือง อียิป เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ไอ โมเซ ไม่ อาโรน เอีจ ยุฮ ป ซัมคัน โฮวน เจือ ซองนา ฟาโร ตอก เซ, พะจาว เกือฮ ลั่ง รพาวม ฟาโร ลึง. พลวย โตว โม อิซราเอน โอก โฮว ฮา เมือง แตะ ฆาื อื ติ ชวง. ");
INSERT INTO lcp_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","เญือม อาวต ลั่ง ไอ โมเซ ไม่ อาโรน นึง เมือง อียิป เปอ, พะจาว อัฮ เฮี ละ อื, ");
INSERT INTO lcp_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“เฆิม เฮี โฮว ไป นา เคิ เฮี ซ โฮลฮ เปอะ เมีญ มัฮ เคิ ติ ละ เปอะ โครยญ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ไมจ เปอะ ดวน โม อิซราเอน เตือง มู อื ตอก เฮี. เญือม เอีจ ฮาวก เคิ เฮี กาว ซาวม เมอ, เกือฮ ปรเมะ ป มัฮ ไกญ เญือะ เลือก กวน แกะ, ติ เญือะ ติ ตัว โครยญ โฆะ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ดัฮ ไก เญือะ ป รมัฮ ปอ โอ แตะ ซ โอยจ ปอน กวน แกะ เซ, เกือฮ เลียก ดิ ไม่ ปุ ซดิ เญือะ แตะ ตัม รมัฮ ตัม โฮวน ปุย ป ซ ปอน อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ไมจ เปอะ เลือก ป โปก อื ป ไก อาญุ อื ติ เนอึม. กวน แกะ กวน ปิ แปน ตื, ปังเมอ ไมจ อื โอ ไก ตอก โละพริ เญี่ยะ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","โซะโกะ ฮรักซา อาึง นึง ฮอยจ ละ ฮาวก เคิ เซ กาว โรฮ ปาวน ซาวม. ปู พริ เซ ปุย ติ เมือง อิซราเอน ไมจ อื มอก โครยญ เญือะ, ติ เญือะ ติ ตัว. ");
INSERT INTO lcp_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","เญือม เซ ไมจ ปุย ตุย ฮนัม อื, เกือฮ ตา อื นึง มะ รเวือะ เญือะ แตะ, เตือง ลวง ราว อื ไม่ ลวง เฆียง อื เตือง ลอา ก บลัฮ อื, โครยญ เญือะ นา ก ซ ปอน ปุย โตะ มอก แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","ซาวม เซ ไมจ ปุย ปอน โตะ กา โครยญ โฆะ ปุย. ไมจ โซม คโนมปัง โอ ไก เจือ. ไมจ ปอน โตะ โกละ ซอง ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","ปุ ปอน โตะ ไม่ม เมอ. ปุ โกยฮ ไม่ รอาวม. ไมจ เปอะ กา นึง งอ เตือง ไกญ เตือง เกลีป เตือง รเวือง เตือง เครอึง กไน อื. ");
INSERT INTO lcp_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ปุ ละ อาึง ฮอยจ ละ ปวยฮ พริ. ดัฮ ไก ป โอ โอยจ ปอน ไมจ อื ตอง นึง งอ. ");
INSERT INTO lcp_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","เญือม โซม เปอะ ไมจ เปอะ ไอฮ เครอึง โฮว คระ แตะ, ไม่ เพรียง เปอะ ติ แตะ ละ ซ โฮว แตะ. จาวป อาึง เกิป เปอะ ไม่. ไปญ โรฮ โคะ ฆิ เปอะ. ซไจ โซม ไม่. ไล โซม เปอะ เฮี ซ อัฮ ปุย โซม เลียง ฌาว ไม่ อื. กัน เลียง เฮี มัฮ กัน เลียง ยุฮ พะจาว,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","พะจาว อัฮ โรฮ เฮี, “ซาวม เซ อาึ ซ โฌ เลี่ป เมือง อียิป. ซ ยุฮ ยุม ไม่ กวน รเมะ โรง ปุย ไม่ กวน โรง ซัตซิง ยุฮ อื, โครยญ เญือะ โครยญ ม่า. อาึ ซ ตัตซิน โม พะ โม จาว ป ทื โม อียิป เกือฮ ลอก ตุต เตือง โอยจ อื. อาึ มัฮ เยโฮวา. ");
INSERT INTO lcp_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ฮนัม เซ ซ แปน ป ซัมคัน ละ โม เปะ โครยญ เญือะ อาวต เปอะ. เญือม ยุ อาึ ฮนัม นึง มะ รเวือะ เญือะ เปอะ อาึ ซ เวีย โม เปะ. เญือม ยุฮ อาึ ยุม ไม่ ปุย เมือง อียิป เปอ, เม่ะมั่ก เซ ซ ลอก โตว โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ซเงะ เนาะ เฮี มัฮ ซเงะ ไมจ โม เปะ โตก ลอป ละ โครยญ เนอึม. ไมจ เปอะ ชลอง ซเงะ เฮี ละ ซ ไตม เปอะ อาึ นึง, ฮอยจ ละ เฆียง เฮี โครยญ เจน ปุย โอ เญาะ ไก ลอยจ. ");
INSERT INTO lcp_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ไน ติ เจน อาแลฮ ซเงะ เซ ไมจ เปอะ โซม คโนมปัง โอ ไก เจือ. ไมจ เปอะ ซาวป ตุย เจือ คโนมปัง เกือฮ โอก ฮา เญือะ เปอะ เน่อึม ซเงะ โรง อื. ดัฮ ไก ป โซม คโนมปัง ไก เจือ นึง ไน ติ เจน อาแลฮ ซเงะ เซ, ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ, ปุ เญือะ เมีญ มัฮ ปุย ไน โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ซเงะ โรง อื ไม่ ซเงะ ลั่ก ลอยจ อื ซ มัฮ ซเงะ โพรม เปอะ ไม่ ปุ แตะ. ปุ ยุฮ กัน นึง ติ เจือ เนอึม โนก ฮา ปอก เปอะ โซม ตุม เปอะ ไอฮ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“ไมจ เปอะ โซม คโนมปัง โอ ไก เจือ โครยญ เนอึม ละ ซ ไตม เปอะ อาึ นึง. เอีจ มัฮ ซเงะ เซ เกือฮ อาึ โม เปะ โปน ฮา เมือง อียิป เปอ. เซ ป ไมจ เปอะ โซม ลอป ฆาื อื โครยญ เนอึม ฮอยจ ละ เฆียง เฮี โครยญ เจน ปุย โอ เญาะ ไก ลอยจ. ");
INSERT INTO lcp_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","เญือม ฮาวก เคิ ติ ยุฮ เปอะ กาว โรฮ ปาวน ซาวม เมือ กปู อื, ฮอยจ ละ แฮม เคิ เซ แลฮ ซาวม เมือ กปู อื, ไมจ เปอะ โซม คโนมปัง โอ ไก เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ไน อาแลฮ ซเงะ เซ ปุ เกือฮ เจือ คโนมปัง ไก นึง เญือะ เปอะ เฟือฮ เอิน. ดัฮ ไก ป โซม โอเอีฮ ป รไม่ ไม่ เจือ คโนมปัง, ปุย เซ จัมเปน เปอะ เมีญ โอ เญือะ มัฮ ปุย ไน เมือง อิซราเอน, ปัง มัฮ ป เกิต ไน โม อิซราเอน ญุ่ก, ปัง มัฮ ปุย ตังเมือง ญุ่ก, ไมจ เปอะ เมีญ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","อาวต เปอะ นา ออฮ นา เอีฮ ญุ่ก, เมาะ ป รไม่ ปุย ไม่ เจือ คโนมปัง ปุ โซม เฟือฮ เอิน,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","เญือม เซ ไอ โมเซ กอก โม ป กวต ป เฮียง ไน โม อิซราเอน เกือฮ เอีญ เคะ แตะ. ซตอก อื ตอก เฮี, “ไมจ โม เปะ โฮว เลือก กวน แกะ กวน ปิ ละ เญือะ โกะ เปอะ ไอฮ. ฟวยจ เซ มอก, โกว ละ โซม เลียง ฌาว เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ฮนัม อื ไมจ เปอะ ละ อาึง โตะ เชือม ติ. ไอฮ ฮลาึง ลเวือง ละ ติ ซอป. ชึต นึง ฮนัม เซ. ตา นึง มะ รเวือะ เญือะ เปอะ เตือง ลวง ราว อื ไม่ ลวง เฆียง อื เตือง ลอา ก บลัฮ อื. ปุ เกือฮ ปุย ไน เญือะ เปอะ โอก ก พริ เญือะ แตะ ติ ปุย เนอึม ฮอยจ ละ ปวยฮ พริ. ");
INSERT INTO lcp_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","พะจาว ซ โฮว เลี่ป เมือง อียิป ละ ซ ยุฮ แตะ ยุม ไม่ โม อียิป. เญือม ยุ อื ฮนัม นึง มะ รเวือะ เญือะ ป ออฮ ซ เวีย เญือะ เซ. ซ ไก เตปด่า ติ ซ ฮอยจ ยุฮ ยุม ไม่ ปุย. พะจาว ซ เกือฮ โตว เตปด่า เซ เลียก เญือะ โม เปะ ละ ซ ยุฮ อื ยุม ไม่ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“ไตม อาึง. โม เปะ ไมจ เปอะ ยุฮ ตัม ไล เฮี ฮอยจ เฆียง เฮี โอ เญาะ ไก ลอยจ, เตือง กวน เปอะ ไม่ กวนโซะ กวน แซะ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","เญือม เอีจ โฮลฮ เปอะ เลียก นึง เมือง ป ซันญา พะจาว อาึง ละ เปอะ เซ, ไมจ เปอะ โซม ไม่ ปุ แตะ ตัม ไล เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","27","เญือม เซ ดัฮ กวน เปอะ ไฮมญ ตอก มัฮ ตอก มอยฮ ไล โซม เปอะ ไม่ ปุ แตะ เซ, โม เปะ ซ โฮลฮ เปอะ อัฮ ละ อื ตอก เฮี, ป โซม เอะ ตอก เซ ฆาื อื มัฮ ฆาื ฌาว พะจาว เญือะ เญะ โฆะ เญือม อาวต เตอะ นึง เมือง อียิป โฮ. มัฮ เวีย อื เอะ เญือม ยุฮ อื ยุม ไม่ โม อียิป โฮ. เซ ป โซม ฆาื อื ตัม ไล อื ละ ซ ทไว แตะ ละ พะจาว, ซ โฮลฮ เปอะ อัฮ เซ ละ,” อัฮ เซ ไอ โมเซ. ฟวยจ ซตอก ไอ โมเซ ปุย เมือง แตะ ตอก เซ, โม อิซราเอน นุ่ม ติ แตะ ละ ซ ไว แตะ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","โม อิซราเอน เนอึง ป อัฮ พะจาว ละ แตะ โครยญ เจือ ตัม ป ซตอก ไอ โมเซ ไม่ อาโรน แตะ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","เมาะ ง่อน ซาวม เซ พะจาว ยุฮ เนอึม ยุม ไม่ กวน รเมะ โรง ปุย ติ เมือง อียิป, เน่อึม นึง กวน ฟาโร ป ลัง แปน กซัต ฆรอ เปือะ แตะ, ฮอยจ ละ กวน โรง ป ตุต ป อาวต โตะ คอก โครยญ โฆะ ปุย โครยญ เญือะ โครยญ ม่า. กวน คอง เลียง คอง ดู่ ปุย ป กิฮ โรง อื ยุม โรฮ โครยญ ตัว. ");
INSERT INTO lcp_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ซาวม เซ ฟาโร ไม่ โม จาวไน ไม่ โม อียิป เตือง โอยจ อื โกฮ. ฮมอง เยือม เรียง ปุย โฮวน นึง โอ อื ไก ติ เนอึม เญือะ ป โอ ยุม ปุย นึง ติ เมือง อียิป เซ. ");
INSERT INTO lcp_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ซาวม เซ ฟาโร กอก ไอ โมเซ ไม่ อาโรน เอีญ เคะ แตะ, อัฮ เฮี ละ อื, “โฮว เมิฮ, เปะ ลอา ไม่ โม อิซราเอน เตือง โอยจ อื. โฮว แปฮ ฮา เอะ เอ. โฮว ไว พะจาว, โฮว ทไว โอเอีฮ ละ ตอก เอีจ ปัว เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","โรวก เมิฮ ครัก โมวก แกะ ปิ ยุฮ เปอะ เซ. ปัว เปอะ ปิฮ ปุ โฮว มุ่น ละ อาึ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","โม อียิป ดวน ปุย ซไจ โอก โฮว นึง ฮลัต ลอน แตะ. “ดัฮ เปอะ โอ โฮว เอะ ตึน ซ ยุม โอยจ เจอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","เญือม เซ โม อิซราเอน ดุฮ คโนมปัง ไม่ม ยุฮ แตะ โตะ เชือม โบลง เตือง โอ อื ดิ ไก เจือ, เพาะ อื นึง บ่วตชุ, ย่อง อื นึง ซอังปา แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","กา เซ โม อิซราเอน เอีจ ฟวยจ ปัว อื เครอึง เซอึก ไม่ มาื ไม่ ไคร นึง โม อียิป ตัม รซอม ดวน ไอ โมเซ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","พะจาว เกือฮ เอิน โม อียิป เซ อาื รพาวม โม อิซราเอน. โม อิซราเอน โฮลฮ เนอึม โอเอีฮ ป ปัว แตะ ฆาื อื โครยญ เจือ. โฮลฮ โรวก เยือ ป ไมจ เน่อึม นึง โม อียิป ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","โม อิซราเอน โฮว นึง ชวง แตะ เน่อึม นึง เมือง ราเมเซต โฮว คระ ย่วง ซุกโคต. โม ปรเมะ นึง อื โน่ง ไก ไม่ ปุ แตะ แลฮ แซน ปุย. โม ปรโปวน ไม่ โม กวนดุ นึง อื เมีญ โตว อื. ");
INSERT INTO lcp_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ปุย ไฮญ โฮว โรฮ ไม่ อื โฮวน. โรวก โรฮ ครัก โมวก แกะ ปิ ไม่ แตะ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","โม ป โฮว เซ โฮลฮ โอป คโนมปัง ไม่ม โรวก แตะ โอก ฮา เมือง อียิป เซ เตือง โอ อื ไก เจือ. เตือน โตว เพรียง ป โซม ป ปอน ยุฮ แตะ เกือฮ ไซญ ปุ โอก นึง พราวป ลอน โฮว แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","โม อิซราเอน แปน อาวต นึง เมือง อียิป เตือง โอยจ อื ปาวน รอย ไม่ ง่วย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ซเงะ โอก อื เซ จัป ปาวน รอย ไม่ ง่วย เนอึม วิต โตว ติ ซเงะ เนอึม. เญือม เซ ปุย ไน พะจาว โครยญ เจอ อื โฮลฮ เนอึม โอก ฮา เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ซาวม เซ พะจาว โซะโกะ ฮรักซา นึง โม อิซราเอน ตาว อื โอก ฮา เมือง อียิป เซ. เคียง เซ เยอ โม อิซราเอน โครยญ เจน ปุย, เมีญ ซาวม เซ มัฮ ซาวม ซัมคัน ยุฮ พะจาว, ไตม อาึง ซเงะ เซ ละ ซ นัปทื แตะ พะจาว นึง. ");
INSERT INTO lcp_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","พะจาว อัฮ อื ละ ไอ โมเซ ไม่ อาโรน ตอก เฮี, “ไล โซม เลียง ฌาว ปุย มัฮ ตอก เฮี, ปุย ตังเมือง ไมจ โตว อื โซม. ");
INSERT INTO lcp_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ป มัฮ ครา รวี เปอะ เซ ดัฮ เอีจ ฟวยจ เลียก นึง ริตกิต โฮ โซม อื แปน. ");
INSERT INTO lcp_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ป ฮอยจ อาวต จุบั่น ไม่ ป โซม จัง เญือะ เปอะ ปุ เกือฮ โซม อื. ");
INSERT INTO lcp_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","ไมจ เปอะ โซม กไน เญือะ นา ก พรี ปุย อื. ปุ โรวก โซม ก ไฮญ. ซอัง แกะ มอก เปอะ เซ ไมจ เปอะ โตว เกือฮ โบวก ติ ซี เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","โม อิซราเอน ไมจ อื ยุฮ ตัม ไล เซ เตือง โอยจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ปุย ตังเมือง ป อาวต ดิ ไม่ เปอะ ดัฮ ฆวต โซม เลียง ฌาว โฮ, ไมจ เปอะ เกือฮ ปรเมะ นึง เญือะ อื เลียก นึง ริตกิต เตือง โอยจ อื ฮัม, เดอึม ซ โฮลฮ โซม อื ตอก ป เอีจ เกิต ไน โม อิซราเอน โฮ. ปรเมะ ป โอ เลียก นึง ริตกิต ไมจ เปอะ โตว เกือฮ โซม อื เฟือฮ เอิน. ");
INSERT INTO lcp_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ป เกิต ไน โม อิซราเอน ไม่ ปุย ตังเมือง อาวต ลลาึง เปอะ ไมจ อื ไอฮ ปซี ปซา ติ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","โม อิซราเอน ยุฮ เนอึม อื ตัม ป อัฮ พะจาว ตอก เอีจ ซตอก ไอ โมเซ ไม่ อาโรน ปุย ยุฮ. ");
INSERT INTO lcp_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ซเงะ เซ พะจาว เกือฮ เนอึม โม อิซราเอน โครยญ เจอ อื โอก ฮา เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“เมาะ ป มัฮ กวน รเมะ โรง ปุย ไมจ เปอะ ทไว ละ อาึ โครยญ โฆะ อื. กวน รเมะ โรง ปุย ไม่ กวน โรง ซัตซิง ป โปก ป ไฮมญ อื มัฮ ป ยุฮ อาึ เตือง โอยจ อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ไอ โมเซ อัฮ เฮี ละ โม ลัปซด่อน, “ไมจ เปอะ ไตม อาึง ซเงะ เนาะ เฮี, นึง มัฮ อื ซเงะ โอก เปอะ ฮา เมือง อียิป นา ก แปน เปอะ ครา เซีญ ปุย โฮ. พะจาว เกือฮ โม เปะ โอก เบือ อัมนัต ระ แตะ. ไน ซเงะ เนาะ เฮี ปุ โซม คโนมปัง ไก เจือ เฟือฮ เอิน. ");
INSERT INTO lcp_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","เคิ เฮี มัฮ เคิ ติ ละ เปอะ. ซ อัฮ เปอะ เคิ อาบิ่ป ไม่ อื. มัฮ เคิ โอก เปอะ ฮา เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","พะจาว เอีจ ซันญา อาึง อื ละ จัตเจือ ไพรม เปอะ ละ ซ เกือฮ แตะ เมือง คะนาอัน ละ โม เปะ. มัฮ ก อาวต โม ฮิตไท, โม อาโมไร, โม ฮีไว, ไม่ โม เยบุ่ต ปเลี่ย. เญือม เอีจ ตาว พะจาว โม เปะ ฮอยจ นึง เมือง ตึม โครยญ โคะ โกะ โครยญ โกลง เซ, ไมจ เปอะ โซม เลียง ฌาว ไม่ ปุ แตะ นึง เคิ เฮี โครยญ เนอึม, ละ ซ แปน ควน ไตม เปอะ ป เกิต ละ แตะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ไน ติ เจน อาแลฮ ซเงะ ไมจ เปอะ โซม คโนมปัง โอ ไก เจือ. ซเงะ อาแลฮ นึง อื ไมจ เปอะ ชลอง ไม่ ปุ แตะ ตัม ไล อื ละ ซ ไตม แตะ พะจาว นึง. ");
INSERT INTO lcp_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ไน อาแลฮ ซเงะ เซ ไมจ เปอะ โตว โซม คโนมปัง ไก เจือ นึง. ปุย ติ เมือง อาวต เปอะ เฮี ปุ เกือฮ ไก ติ เญือะ เนอึม ป แฮรน อาึง เจือ คโนมปัง ไน โตะ เญือะ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ซเงะ โซม โรง เปอะ ไมจ เปอะ รโฮงะ ละ กวน แตะ เกือฮ ยุง ควัมไม ป ยุฮ เปอะ เซ, นึง เอีจ เกือฮ พะจาว เปอะ โอก ฮา เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","กัน โซม เปอะ ตอก เซ ซ แปน ตอก โอเอีฮ ปุก เปอะ นึง เตะ แตะ, ตอก โรฮ โอเอีฮ ตาึก เปอะ นึง แด่ แตะ โฮ. ซ แปน ควน เกือฮ พะทัม โกตไม ยุฮ พะจาว อาวต ลอป นึง ดัก นึง ดอย เปอะ ฆาื อื, ไม่ ซ แปน อื ควน ไตม เปอะ ตอก นัม พะจาว โม เปะ โอก ฮา เมือง อียิป เบือ อัมนัต ระ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","ดัฮ เอีจ เติง เวลา เซ โครยญ เนอึม ไมจ เปอะ โซม ตอก เซ ตัม ไล อื. ");
INSERT INTO lcp_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“พะจาว เอีจ ซันญา อาึง อื ละ โม เปะ ไม่ โม จัตเจือ ไพรม เปอะ ละ ซ เกือฮ อื เมือง คะนาอัน ละ เปอะ. ซ ตาว เนอึม โม เปะ ฮอยจ นา เซ. ซ เกือฮ เนอึม อื ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","เญือม เอีจ ฮอยจ เปอะ นา เซ, โอเอีฮ เมาะ ป เกิต โรง ยุฮ เปอะ ไมจ เปอะ เมีญ มัฮ คอง พะจาว. กวน โรง ซัตซิง ยุฮ เปอะ ป โปก อื ไมจ เปอะ ทไว ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ดัฮ มัฮ กวน บรัง โฮ, ไมจ เปอะ โตฮ นึง กวน แกะ ติ. ดัฮ เปอะ โอ โตฮ จัมเปน เปอะ โปวก โงก อื. กวน รเมะ โรง เปอะ ไมจ โรฮ เปอะ โตฮ โครยญ โฆะ อื. ");
INSERT INTO lcp_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“เฆียง เฮี เญือม ไฮมญ กวน เปอะ ตอก ยุฮ เปอะ นึง ไล เฮี, ไมจ เปอะ โลยฮ ละ อื ตอก เฮี, ‘โฆะ เญือม มัฮ ลั่ง เอะ ครา เซีญ ปุย โฮ, พะจาว นัม เอะ โอก ฮา เมือง อียิป เบือ อัมนัต ระ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","เญือม เกือฮ ฟาโร ติ แตะ ลึง รพาวม นึง โอ อื ญอม เกือฮ เอะ โอก เกอ, พะจาว ยุฮ ยุม ไม่ กวน รเมะ โรง ปุย ติ เมือง อียิป ฆาื อื. กวน โรง ซัตซิง ยุม โรฮ ตอก เซ โรฮ. มัฮ เซ ป มอก เอะ ตอง ทไว กวน โรง ซัตซิง ละ พะจาว ฆาื อื โครยญ ตัว เยอ. กวน รเมะ โรง เงอะ โฮลฮ โรฮ โตฮ ฆาื อื ตอก เซ โรฮ,’ ไมจ เปอะ อัฮ เซ ละ. ");
INSERT INTO lcp_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ไลลวง ยุฮ เอะ ตอก เซ ซ แปน ตอก โอเอีฮ ป ปุก เกอะ นึง เตะ แตะ ตาึก เกอะ นึง แด่ แตะ. ซ แปน ควน ไตม เมอะ ตอก นัม พะจาว เอะ โอก ฮา เมือง อียิป เบือ อัมนัต ระ แตะ,” อัฮ เซ ละ ปุย โฮวน เซ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ฟวยจ เกือฮ ฟาโร ปุย โอก โฮว เยอ, พะจาว เกือฮ โตว อื โฮว คระ พา เมือง ฟีลิซเตีย ป มัฮ คระ ซื นึง อื. พะจาว ง่อต อื ตอก เฮี โตะ รพาวม แตะ, “ปุย โม เฮี ดัฮ ยุ ซ จัมเปน แตะ รุป ปุ แตะ ไม่ ปุย ซ แม ฆาื อื ลั่กเคะ แตะ เมือง อียิป ยุ่ง.” ");
INSERT INTO lcp_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","พะจาว นัม ปุย โฮว ฆาื อื คระ บ่วก ป มัฮ คระ พา ลาึน เวือฮ ฮอยจ ละ ปลัฮ รอาวม ซครัก เซ. โม อิซราเอน โรวก เครอึง ตฮัน ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ไอ โมเซ โรวก ปุ โฮว ซอัง โยเซป ไม่ แตะ. ไพรม อื โยเซป เซ เอีจ เกือฮ โม อิซราเอน ซันญา อาึง อื ละ แตะ ซโตฮ ละ ซ ยุฮ อื ตอก เซ. เอีจ อัฮ อาึง อื ตอก เฮี, “เญือม เรอึม พะจาว โม เปะ เกือฮ เปอะ โปน เม่ะมั่ก แตะ ไมจ เนอึม เปอะ กลอม โรวก โกะ ยุม อาึ ไม่ เปอะ เกือฮ โอก ฮา นา เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ปุย โฮวน เซ โอก ฮา เมือง ซุกโคต ฮอยจ ย่วง เอทัม เฆียง ลาึน เวือฮ. ");
INSERT INTO lcp_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","เมือ ซเง่ะ อื พะจาว นัม คระ ละ อื นึง ชุต รวู ฮลาวง ตอก ด่อง โฮ, เมือ ก ซาวม อื แปน ตอก ด่อง งอ, รัง ซเปีย ละ อื. เกียฮ โฮว ฆาื อื เตือง ซเง่ะ รซาวม. ");
INSERT INTO lcp_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ชุต รวู เซ ไก ลอป ซองนา ปุย เมือ ซเง่ะ อื. ด่อง งอ เซ ไก ลอป โรฮ ละ อื เมือ ก ซาวม อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","เญือม เซ พะจาว อัฮ อื ละ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ไมจ เปอะ ดวน โม อิซราเอน ลเตือฮ ติ แตะ แม กัง พากัง ยุฮ แตะ โบ นาตี ปีฮะฮิโรต ป อาวต ซน่ะ มิกโด่น ไม่ ปลัฮ รอาวม เซ. ปุก รเตือป ย่วง บ่าอันเซโฟน. ");
INSERT INTO lcp_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ฟาโร ซ แกต โม อิซราเอน ไปๆ มาๆ นึง โอ อื ไก คระ โอก, แกต อื นัน นึง ลาึน เวือฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","อาึ ซ เกือฮ แม ฟาโร เซ ลึง รพาวม. ซ อาื โม เปะ ฆาื อื. อาึ ซ โฮลฮ โญตซัก แตะ เบือ เป แตะ ฟาโร ไม่ โม ตฮัน ยุฮ อื. เญือม เซ โม อียิป ซ ยุง มัฮ อาึ พะจาว เบือ อื,” อัฮ เซ ละ อื. โม อิซราเอน ยุฮ เนอึม อื ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","เญือม เอีจ ฮมอง ฟาโร ตอ โอยจ โม อิซราเอน ฮา เมือง อียิป เปอ, ฟาโร ไม่ โม จาวไน เมือง อียิป เซ ไกลฮ นึง โคะ พลวย แตะ โม อิซราเอน โฮว. อัฮ เฮี ฆาื อื ละ ปุ แตะ, “มัฮ ตอก เมอ ป ยุฮ เอะ เฮี? เอะ ตอ โคะ พลวย โน่ง โม อิซราเอน โอก ฮา แปน อื ครา เอะ เมอ?” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","กซัต เซ เกือฮ ปุย เพรียง เลาะ รุป เซิก ยุฮ แตะ ละ ซ โฮว รุป แตะ. โรวก โม ตฮัน ยุฮ แตะ โฮว ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ไก เลาะ รุป เซิก ตึก นึง ไมจ แตะ แลฮ รอย กัน. โนก ฮา เซ ไก แม ไม่ เลาะ รุป เซิก ไฮญ โฮวน. เลาะ โม เซ ไก ตื ฮัวนา ตฮัน นึง โครยญ กัน อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","พะจาว เกือฮ เนอึม รพาวม ฟาโร ลึง. เกือฮ อื ฆวต อาื โม อิซราเอน. โม อิซราเอน เซ โฮว ไม่ เฆีญ อัมนัต พะจาว แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ตฮัน ยุฮ โม อียิป เตือง บรอง เตือง เลาะ เตือง ป บุก เลาะ เซ โครยญ โฆะ อื อาื เนอึม โม อิซราเอน. เครอึป อื นา ก กัง อื พากัง ยุฮ แตะ เฆียง ปลัฮ รอาวม โบ นาตี ปีฮะฮิโรต, ปุก รเตือป ย่วง บ่าอันเซโฟน. ");
INSERT INTO lcp_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","เญือม เอีจ ฮอยจ ฟาโร ซดิ บุย โรฮ ไม่ อื, โม อิซราเอน ชวน ซ ฮอยจ รุป โม อียิป เซ ไม่ แตะ, ฮลัต เตีจ ฆาื อื. รโอง กอก ปัว พะจาว เรอึม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","เติ ไอ โมเซ ฆาื อื ตอก เฮี, “อัม มัฮ โอ อื ไก รมอยจ นึง เมือง อียิป เปอ? อัม ทา โรวก เอะ ฮอยจ ยุม เฮีย ยุม ไฮ นึง ลาึน เวือฮ เฮี? แลน เมิฮ ป เกิต ละ เอะ เฮี, มัฮ ฆาื นัม เปอะ เอะ โอก ฮา เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","เอะ เอีจ ตึน อัฮ ละ เปอะ กา เฆียง โอก เกอะ, โม่ อัฮ? ตึน อัฮ ละ เปอะ โอ ไมจ ยุฮ ป ซุกซัก ละ เอะ นึง ญอม ลั่ง แตะ ยุฮ กัน ละ โม อียิป. มัฮ แปน ลั่ง เงอะ ครา นา เซ ฌักแฟน เดียก ฮา ซ ยุม เฮีย ยุม ไฮ เยอะ นึง ลาึน เวือฮ เฮี, โม่ ฌักแฟน?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ไอ โมเซ โลยฮ อื ตอก เฮี, “ปุ ฮลัต. ไมจ เปอะ เกือฮ ติ แตะ อาวต ตอน อาวต ฮมัน, เดอึม เปอะ ซ ยุ ตอก เรอึม พะจาว แตะ, นึง ซ เกือฮ อื โม เปะ โปน ฮา โม เซ ไน ซเงะ เนาะ เฮี. โม อียิป ป ชวน เปอะ เนาะ เฮี เฆิม เฮี โฮว ไป นา เญือะ ซ โฮลฮ เปอะ โตว ยุ เฟือฮ เอิน. ");
INSERT INTO lcp_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","พะจาว ซ รุป รโตง โม เปะ. เญือะ โฮลฮ เปอะ โตว ยุฮ ป ติ ป เตอื ติ. อาวต โฆย แนฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","พะจาว อัฮ เฮี ละ ไอ โมเซ, “เมอยุ รโอง เปอะ ปัว โอเอีฮ นึง อาึ อื โม เปะ เอ? เกือฮ โม อิซราเอน โฮว ลั่กกา แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ยวก โคะ ฆิ เปอะ. ซนาว ราว ปลัฮ รอาวม ละ ซ เกือฮ รอาวม เซ รกัฮ ฮา ปุ แตะ, เดอึม โม อิซราเอน ซ โฮลฮ โฮว นึง ชวง แตะ นึง เตะ ซออฮ ซน่ะ ปลัฮ รอาวม เซ. ");
INSERT INTO lcp_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","อาึ ซ เกือฮ โม อียิป ลึง รพาวม. ซ เกือฮ เยอะ โฆง อาื โม เปะ. อาึ ซ โฮลฮ โญตซัก แตะ นึง ป เกิต ละ ฟาโร ไม่ ตฮัน ยุฮ อื ไม่ เลาะ ไม่ ตฮัน บุก บรอง ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","เญือม เป อาึ อื ตอก เซ, โม อียิป ซ ยุง เนอึม มัฮ อาึ พะจาว ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","เญือม เซ เตปด่า ยุฮ พะจาว ป โฮว ลั่กกา โม อิซราเอน ละ ซ นัม อื คระ ละ อื เซ, เปียน ลั่ก อาวต แตะ. แม อาวต ลั่กเคะ อื. ชุต รวู ป ตอก ด่อง เซ เปียน โรฮ ลั่ก อาวต แตะ โรฮ. อาวต โรฮ ลั่กเคะ อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","แปน อาวต ซน่ะ โม อียิป ไม่ โม อิซราเอน. ชุต รวู เซ เกือฮ อื เฟียก ละ โม อียิป, ปังเมอ เกือฮ อื ซเปีย ละ โม อิซราเอน. ซาวม เซ ปุย ลอา มู เซ โฮลฮ โตว เลียก ซดิ โบ ปุ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","เญือม เซ ไอ โมเซ ซนาว เนอึม เตะ แตะ ราว ปลัฮ รอาวม. พะจาว เกือฮ กาื ระ ฮอยจ เน่อึม ลั่ก โอก ซเงะ. กาื เซ บาึง ติ ซาวม บวยฮ, แทต รอาวม เซ เกือฮ รกัฮ ฮา ปุ แตะ, เกือฮ เตะ ซน่ะ รอาวม เซ แปน เตะ ซออฮ. ");
INSERT INTO lcp_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","โม อิซราเอน โฮลฮ เตือง ซไบ่ ซน่ะ รอาวม เซ นึง เตะ ซออฮ. รอาวม อาวต เอิน ตอก เดีญ โฮ เตือง ลอา ก บลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","โม อียิป อาื โรฮ อื. เลียก โรฮ ซน่ะ รอาวม เซ เตือง บรอง เตือง เลาะ เตือง ป บุก เลาะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","เญือม ซ ปวยฮ โรง พริ อี พะจาว แก อื เน่อึม นึง ชุต รวู ป ตอก ด่อง งอ เซ. เกือฮ อื ซุกซัก ลุงลัง เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","เกือฮ ชวง เลาะ ยุฮ อื เซ คอม นึง บิญ. ญัก โฮว ละ ฆาื อื. เญือม เซ โม อียิป อัฮ เฮี, “พะจาว ฮอยจ ตอซู ปุ แตะ ไม่ เอะ รโตง โม อิซราเอน. ไมจ เอะ ตอ แปฮ เกือฮ ติ แตะ โปน,” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ซนาว แม เตะ เปอะ ราว ปลัฮ รอาวม. รอาวม ซ แม เลอึป โม อียิป เตือง โกะ อื เตือง เลาะ เตือง ป บุก บรอง เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ไอ โมเซ ซนาว เนอึม เตะ แตะ ราว ปลัฮ รอาวม. เญือม โอก โรง ซเงะ เอ รอาวม แม แม เบือง ไพรม แตะ. โม อียิป ริ ตอ ฮา อื. พะจาว ปังเมอ เกือฮ เอิน รอาวม ระ เซ เลอึป อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","เญือม แม แม รอาวม เซ เบือง แตะ เลอึป เนอึม เลาะ เซ ไม่ โม ป บุก อื ไม่ โม ตฮัน เมือง อียิป ป อาื โม อิซราเอน ซน่ะ รอาวม เซ เตือง โอยจ อื. ปุย โม เซ ยุม โอยจ เอิน, เญือะ ไอม โตว ติ ปุย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","ป มัฮ โม อิซราเอน ปังเมอ เอีจ โฮลฮ โฮว ซน่ะ รอาวม เซ นึง เตะ ซออฮ. รอาวม เซ อาวต ละ อื ตอก เดีญ โฮ เตือง ลอา ก บลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ซเงะ เซ พะจาว เกือฮ เนอึม โม อิซราเอน โปน ฮา โม อียิป. โม อิซราเอน ยุ ป ยุม อาวต เฮีย เฆียง รอง ปลัฮ รอาวม. ");
INSERT INTO lcp_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","เญือม ยุ โม อิซราเอน อัมนัต ระ ยุฮ พะจาว นึง เป อื โม อียิป เซ, ฮลัต โรฮ ฆาื อื นึง พะจาว. อาึง รพาวม แตะ นึง พะจาว ฆาื อื. อาึง โรฮ รพาวม แตะ นึง ไอ โมเซ ป มัฮ กวนไจ ยุฮ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","เญือม เซ ไอ โมเซ ไม่ โม อิซราเอน เชีย ดิ ละ พะจาว นึง รซอม เชีย แตะ ตอก เฮี, อาึ ซ เชีย ลืลาว พะจาว นึง เอีจ เป เนอึม เป แนม อื ป รุป ไม่ แตะ. เอีจ น่าึก โปวฮ บรอง ไม่ โม ป บุก อื เซ ฮอยจ โตะ ปลัฮ รอาวม. ");
INSERT INTO lcp_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","พะจาว มัฮ ป เฆีญ อาึ ฮา ป โอ ไมจ. มัฮ ป เกือฮ อาึ โปน ฮา ป โตะ ป ตอง. มัฮ พะจาว ยุฮ ฮุ. อาึ ซ ลืลาว เยอะ. มัฮ พะจาว ทื จัตเจือ ไพรม เมอะ. อาึ วุฮ ฮุ ระ จอง เงอะ ฮลาวง. ");
INSERT INTO lcp_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","พะจาว มัฮ ตอก ตฮัน เกง. มอยฮ อื มัฮ เยโฮวา. ");
INSERT INTO lcp_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","เอีจ โปวฮ โม ตฮัน เมือง อียิป โตะ ปลัฮ รอาวม เตือง โอยจ อื, เตือง เลาะ เตือง ฮัวนา ตฮัน ระ มอยฮ นึง อื. เกือฮ อื รมั่ม โอยจ โตะ ปลัฮ รอาวม ซครัก. ");
INSERT INTO lcp_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","รอาวม โด่ะ เซ เลอึป ปุย โม เซ. โจม ฮอยจ ก โด่ะ อื ตอก ซโมะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","โอ พะจาว, เตะ ดอม เปอะ มัฮ ป ตึก นึง ระ อัมนัต แตะ. เอีจ เกือฮ เปอะ ป รุป ปุ แตะ ไม่ เปอะ ไลจ โลม โอยจ เอิน. ");
INSERT INTO lcp_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","ปะ เป เปอะ โม ป ตอซู ไม่ แตะ นึง มัฮ เปอะ กซัต ตึก นึง ระ อัมนัต แตะ. เญือม ฮาวก รพาวม เปอะ ละ อื, โม เซ ฮะ ล่อยญ เอิน ตอก เบระ ตอก ไรป โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","เญือม ปลาึง เปอะ รพาวม แตะ ละ อื, รอาวม เซ ฮาวก ปุ ปุ. อาวต ซื เอิน ตอก เดีญ โฮ. รอาวม โด่ะ เซ กอ เอิน ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","โม ป ตอซู ปุ แตะ ไม่ ปะ เอีจ อัฮ เฮี, “อาึ ซ อาื โม เซ ฮอยจ ละ เครอึป แตะ. อาึ ซ รฆุ คาวคอง อื. ซ ฟวยจ รพาวม นึง โฮลฮ แตะ โอเอีฮ ยุฮ อื. อาึ ซ ลวต วิจ แตะ. ซ เกือฮ ชิป เกือฮ ไฆร โอยจ เอิน,” เคียต อัฮ อื ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","โอ พะจาว, เมาะ ปลาึง ปะ รพาวม แตะ ละ อื, โม อียิป เซ รมั่ม โอยจ เอิน ฆาื อื. โจม ลอป เอิน โตะ รอาวม ระ เซ ตอก บรัก โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","โอ พะจาว, เมาะ ป อัฮ ปุย มัฮ พะจาว อัม ไก ป ตอก ปะ นึง อื? แจง โอ อื ไก. อัม ไก ป ซง่ะ ซงอม ไม่ คึ ไม่ นัก แตะ ตอก ปะ อา? อัม ไก ป อาวต ไม่ รัง ซเปีย ปอ ฮลัต ปุย นึง? อัม ไก ป เกียฮ ยุฮ ป ซัมคัน ตอก ปะ อา? แจง โอ อื ไก. ");
INSERT INTO lcp_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","เญือม ซนาว เปอะ เตะ ดอม แตะ เซ ปลัฮเตะ บลวน เอิน ปุย โม เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","โม ป เอีจ โตฮ เปอะ เซ, ปะ เอีจ นัม เปอะ เกือฮ โอก เบือ รพาวม ฮรัก ยุฮ แตะ. ซ นัม เปอะ เบือ อัมนัต ระ ยุฮ แตะ ละ ซ เกือฮ เปอะ ฮอยจ นึง เมือง ซง่ะ ซงอม ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ปุย ตังเมือง ซ ฮมอง ไลลวง ยุฮ เปอะ. ซ ฮลัต เตีจ รกุฮ รเตียง ฆาื อื. โม ฟีลิซเตีย ซ ฮลัต ปอ ซ เบฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","จาวไน เมือง เอโด่ม ซ ฮลัต เตีจ. ป ระ เรียง เมือง โมอัป ซ รกุฮ รเตียง. ปุย เมือง คะนาอัน ซ โอยจ รพาวม ฆาื ฮลัต ลอน แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ซ รไจจ ไม่ โตวฮ ฆราึง แตะ. โอ พะจาว, อัมนัต เปอะ ซ เกือฮ โม เซ อาวต โฆย ตอก ซโมะ โฮ นึง ฮลัต ลอน แตะ, ฮอยจ ละ โฮว พา ซไบ่ ปุย ไน เปอะ เมือง อาวต อื. ปุย ไน เปอะ เซ เอีจ มัฮ โม ป รวี เปอะ ละ โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ปะ ซ นัม เปอะ ฮอยจ นึง บลาวง เลือก เปอะ อาึง ละ ซ แปน อื นาตี อาวต เปอะ. มัฮ นาตี ซง่ะ ซงอม ยุฮ เปอะ. ซ เกือฮ เปอะ อาวต ตอน อาวต ฮมัน นา เซ ตอก ซมา ปุย โคะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","โอ พะจาว, ปะ ซ ตัตเตียง ลอป เปอะ ปุย โอ เญาะ ไก ลอยจ, อัฮ เซ นึง รซอม เชีย แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","เญือม เลียก บรอง ยุฮ ฟาโร ไม่ เลาะ ไม่ โม ป บุก อื เซ โตะ ปลัฮ รอาวม เมอ, พะจาว เกือฮ รอาวม เซ แม เลอึป อื. โม อิซราเอน นึง อื ปังเมอ เกือฮ อื โฮว ซไบ่ ซน่ะ รอาวม นึง เตะ ซออฮ. ");
INSERT INTO lcp_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","มิเรียม มัฮ ป ซึป ลปุง พะจาว, มัฮ โรฮ ออระ อาโรน. เญือม เซ ตุย โรวก รัมมะนา ยุฮ แตะ, โฮว ไม่ อื. โม ปรโปวน เตือง โอยจ อื ตุย โรฮ รัมมะนา ยุฮ แตะ, โฮว ฟวต มิเรียม เซ. ฟอน ลัม ปุ โฮว ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","มิเรียม เชีย ไม่ อื ตอก เฮี, “ไมจ เปอะ เชีย ลืลาว พะจาว นึง เป เนอึม เป แนม อื ป รุป ไม่ แตะ. เอีจ น่าึก โปวฮ บรอง ไม่ โม ป บุก อื เซ ฮอยจ นึง ปลัฮ รอาวม,” อัฮ เซ นึง รซอม เชีย แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ฟวยจ เซ ไอ โมเซ นัม โม อิซราเอน โฮว เน่อึม นึง ปลัฮ รอาวม ซครัก เซ ฮอยจ นึง ลาึน เวือฮ ป อัฮ ปุย ลาึน ชู ไม่. โฮว คระ ลาึน เซ ลอวย ซเงะ คระ, ยุ โตว รอาวม ติ โดฮ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","เญือม ฮอยจ อื ติ โดฮ ก อัฮ ปุย มารา ไม่, นา เซ ไก รอาวม ซอง นึง. ปุย เกียฮ ญุ โตว อื นึง ซอง ลอน อื. เซ ป อัฮ ปุย มารา ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ปุย โฮวน เซ เติ ไอ โมเซ ฆาื อื ตอก เฮี, “เมอ ซ โฮลฮ เอะ ญุ อู?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","เญือม เซ ไอ โมเซ ปัว เนอึม ปัว แนม นึง พะจาว. พะจาว เปลีฮ โคะ ละ อื ติ ตอน. เญือม น่าึก อื โคะ เซ โตะ รอาวม เซ, รอาวม เซ เปียน เอิน ติ แตะ แปน รอาวม งา. ปุย โฮลฮ เอิน ญุ อื. เญือม อาวต โม อิซราเอน นา เซ พะจาว เกือฮ ลปุง ซตอก แตะ ละ อื, ละ ซ เกือฮ อื ยุฮ อื ตัม เซ. มัฮ โรฮ ลอง อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","อัฮ เฮี ละ อื, “ดัฮ โม เปะ ง่อต เนอึม ลปุง เยโฮวา พะจาว ยุฮ เปอะ, ดัฮ เปอะ ยุฮ ป ปุก รพาวม อาึ ไม่ เนอึง เปอะ ลปุง ซตอก อาึ เปอะ โครยญ เจือ, อาึ ซ เกือฮ โม เปะ ตัง ฮา โม อียิป. อาึ เกือฮ โม เซ ลอก ป โซะ โฮวน เจือ. อาึ ซ เกือฮ โตว โม เปะ ลอก ป โซะ ตอก เซ ติ เจือ เนอึม. อาึ มัฮ พะจาว ป เกือฮ ป โซะ ป คระ ลอก เปอะ ไฮ โครยญ เจือ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","ฟวยจ เซ ปุย โฮวน เซ ฮอยจ นึง นาตี เอลิม. นา เซ ไก รอาวม ปลาึฮ นึง กาว ลอา โดฮ. ไก โรฮ โคะ อินทะพาลัม นึง อาลแฆลฮ โคะ. โม อิซราเอน กัง พากัง ยุฮ แตะ โบ รอาวม ปลาึฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","กังเคะ เอ โม อิซราเอน เตือง มู อื โอก โฮว ฮา ย่วง เอลิม เซ. ฟวยจ โอก อื ฮา เมือง อียิป ติ เคิ ไม่ กาว โรฮ พอน ซเงะ เอ, ฮอยจ นึง ลาึน เวือฮ ติ โดฮ ป อัฮ ปุย ลาึน เซอิน ไม่. นา เซ อาวต ซน่ะ ย่วง เอลิม ไม่ บลาวง ซีไน. ");
INSERT INTO lcp_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","เญือม ฮอยจ อื นึง ลาึน นา เซ ปุย โฮวน เซ เติ ไอ โมเซ ไม่ อาโรน. ");
INSERT INTO lcp_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","อัฮ เฮี ละ อื, “มัฮ ยุฮ พะจาว ยุม ไม่ เอะ นึง เมือง อียิป ไมจ เดียก เนิ. เญือม อาวต ลั่ง เงอะ นา เซ เอะ โฮลฮ งาวม โซม ซัก กุก เตือ, โฮวน โตะ โฮวน กะ นึง. ปะ เคียต เปอะ ตาว เอะ ฮอยจ นึง ลาึน เฮี ละ ซ เกือฮ เปอะ เอะ ยุม นึง ไปลญ แตะ เตือง มู เยอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “อาึ ซ เกือฮ ป โซม ราื ละ ปุย เน่อึม มะลอง ตอก เฮละ โฮ. ไมจ ปุย โอก ไรฮ โครยญ ซเง่ะ. เกือฮ ไรฮ อื ปอ โซม แตะ ไน ติ ติ ซเงะ โน่ง. ตอก เซ ตอก ซ ลอง อาึ แลน รพาวม อื, อัม ซ เนอึง อื ลปุง ซตอก อาึ แตะ เซ? อัม โอ ซ เนอึง อื? ");
INSERT INTO lcp_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ซเงะ แลฮ นึง อื ไมจ อื ไรฮ ลอา เตะ ซเงะ ไฮญ, เกือฮ เพรียง อาึง อื ละ ซ โซม แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","เญือม เซ ไอ โมเซ ไม่ อาโรน อัฮ เฮี ละ โม อิซราเอน, “เมือ ก ปู อื, โม เปะ ซ ยุง แจง แน เปอะ มัฮ เนอึม อื พะจาว ป นัม โม เปะ โอก ฮา เมือง อียิป เปอ. ");
INSERT INTO lcp_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","เมือ กซะ อื ซ ยุ เปอะ รัง ซเปีย ยุฮ พะจาว. พะจาว เอีจ ฮมอง อื ตอก เติ โม เปะ แตะ. เอะ ลอา มัฮ โตว ป เกียฮ อัฮ โอเอีฮ นึง โกะ แตะ. มัฮ อัฮ ฮะ ตัง พะจาว. โม เปะ มัฮ โตว เติ เปอะ เอะ, เอีจ มัฮ เอิน เติ เปอะ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","เมือ กปู อื พะจาว ซ เกือฮ โม เปะ โฮลฮ ปอน โตะ. เมือ กซะ อื ซ เกือฮ ป โซม ละ เปอะ ปอ ซัก เปอะ. ซ ยุง เปอะ เญือม เซ. เญือม เติ เปอะ เอะ เอีจ มัฮ เนอึม เติ เปอะ พะจาว,” อัฮ เซ ละ อื ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ไอ โมเซ เกือฮ อาโรน กอก โม ลัปซด่อน เกือฮ ฮอยจ ชุง ซองนา พะจาว นึง เอีจ ฮมอง พะจาว ตอก ปุปิ ปุย ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ลไล ลปุง อาโรน ไม่ ปุย โฮวน เซ, โม อิซราเอน แก ลั่ก ลาึน เวือฮ เซ. ชวน รัง ซเปีย ยุฮ พะจาว นึง ชุต รวู. ");
INSERT INTO lcp_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","พะจาว ลปุง ไม่ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“อาึ เอีจ ฮมอง ตอก ปุปิ โม อิซราเอน ละ แตะ. ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, เนฮ ก ปู ซ โฮลฮ เปอะ ปอน โตะ. ซง่าวป ก ซะ ซ โฮลฮ เปอะ โซม ซัก. เญือม ยุ เปอะ โอเอีฮ ตอก เซ ซ ยุง เปอะ มัฮ อาึ เยโฮวา พะจาว ยุฮ เปอะ ฆาื อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ปู พริ เซ ฮอยจ เนอึม กึต ละ โฮวน ปอ เอิน เลอึป อื ไคะ ยุฮ ปุย โม เซ. เญือม เอีจ ปวยฮ พริ อี ราื แม รอาวม รน่ะ นึง รวิต รเวียง ก อาวต อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","เญือม เอีจ ฮัต แม รน่ะ เซ ปุย ยุ โอเอีฮ ป ปิญ เฮรีๆ รเซฮ ตอก รปอฮ กะ โฮ, เลี่ป ลังเตะ นึง ลาึน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","โม อิซราเอน เญือม ยุ อื อัฮ เฮี ละ ปุ แตะ, “มัฮ เมอ เฮี?” อัฮ เซ นึง โอ อื ยุง ป มัฮ อื. ไอ โมเซ โลยฮ อื ละ อื, “เอีจ มัฮ เฮี ป โซม เกือฮ พะจาว ละ โม เปะ เอ. ");
INSERT INTO lcp_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","พะจาว เอีจ ดวน โม เปะ โฮว ซาวป ไรฮ อื ปอ โซม เปอะ เตือง ไพ เตือง มัน. ไอฮ ติ ปุย ลอา ลิต โครยญ โฆะ ปุย ตัม โฮวน ตัม รมัฮ เปอะ โครยญ เญือะ,” อัฮ เซ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","โม อิซราเอน ยุฮ เนอึม อื ตัม ดวน พะจาว แตะ. ง่อน อื ไรฮ อื โฮวน. ง่อน อื ไรฮ อื รมัฮ. ");
INSERT INTO lcp_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","เญือม ซมอย อื ไม่ ปุ แตะ โม ป โฮวน ป ไรฮ เซ โฮฮ โตว ละ อื. ป รมัฮ ป ไรฮ ปุ โรฮ วิต ละ อื. ไก จัป ปอ โซม อื โครยญ โฆะ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ไอ โมเซ อัฮ เฮี ละ อื, “ปุ แฮรน อาึง ป โฮฮ อื ฮอยจ ละ ซง่าวป ติ ตื เนอึม,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ปุย ง่อน อื ปังเมอ โอ ง่อต ป อัฮ อื. ฮลักกอ อื. แฮรน อาึง อื ฮอยจ ละ ปวยฮ พริ. ป แฮรน อื อาึง เซ นาวก นึง เฆรียก. ซออย ซเออึม. ไอ โมเซ รอก พาวม นึง อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ปุย โอก ซาวป ไรฮ อื โครยญ ซะ ปอ โซม แตะ ซเงะ ได่ ซเงะ นัน. เญือม เอีจ ฮลาวง ซเงะ เอ ป โซม เซ ฮัต เยือ ตอก รน่ะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","เญือม เติง ซเงะ แลฮ นึง อื ปุย โอก ไรฮ อื ลอา เตะ ซเงะ ไฮญ, ติ ปุย เมาะ ปาวน ลิต โครยญ โฆะ แตะ. โม ป มัฮ ฮัวนา นึง อื ฮอยจ รโฮงะ อื ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","ไอ โมเซ โลยฮ อื, “พะจาว เอีจ ซตอก เอะ เกือฮ ทื ซเงะ ซง่าวป แปน ซเงะ ซัมคัน ละ ซ ลโล่ะ แตะ, มัฮ ซเงะ ทไว ปุย ละ พะจาว. ไน ซเงะ เนาะ เฮี กา ป ฆวต กา เปอะ, โกยฮ ป ฆวต โกยฮ เปอะ. ป โฮฮ อื ฮา โซม เปอะ แฮรน อาึง ฮอยจ ละ ซง่าวป,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ปุย ยุฮ เนอึม อื ตัม ป ซตอก ไอ โมเซ แตะ. แฮรน เนอึม อื. ซออย โตว ฆาื อื. เฆรียก ปุ โรฮ เฆรียก. ");
INSERT INTO lcp_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ไอ โมเซ อัฮ เฮี, “ซเงะ เนาะ เฮี ไมจ เปอะ โซม ป โฮฮ โฆะเนิ่ เซ, นึง มัฮ อื ซเงะ ลโล่ะ ซัมคัน ละ พะจาว. เนาะ เฮี ซ ยุ เปอะ โตว ป โซม เฮี นึง ลาึน เวือฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","โม เปะ ไมจ เปอะ ซาวป ไรฮ ไน แลฮ ซเงะ. ซเงะ อาแลฮ นึง อื มัฮ ซเงะ ลโล่ะ เปอะ, ป โซม เซ ซ ไก โตว ละ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ซเงะ อาแลฮ เซ ไก ง่อน ป ริ โฮว ซาวป เปอ ปังเมอ โอ ยุ อื. ");
INSERT INTO lcp_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “โม เปะ ซ เลี่ญ เมาะ เมอ โอ เปอะ ซ เนอึง ลปุง ซตอก อาึ แตะ? ");
INSERT INTO lcp_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ไมจ เปอะ ไตม เกือฮ อาึ ซเงะ ลโล่ะ ละ เปอะ. มัฮ เซ ป เกือฮ ป โซม ละ เปอะ ไน ซเงะ แลฮ ฆาื อื ปอ โซม เปอะ ลอา ซเงะ เอ. ซเงะ อาแลฮ นึง อื ไมจ ปุย อาวต ก อาวต แตะ. ปุ โอก โฮว ก ไฮญ เญอ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","เคียง เซ ปุย อาวต เนอึม ลโล่ะ นึง ซเงะ อาแลฮ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","โม อิซราเอน อัฮ มานา ไม่ ป โซม แตะ เซ. มัฮ ตอก โนง โอเอีฮ ป ปิญ โฮ. เญือม โซม อื มัฮ โรฮ ป เด ตอก คโนมปัง ยุฮ ปุย ไม่ รอาวม โกะ แฮ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ไอ โมเซ อัฮ เฮี, “พะจาว เอีจ ซตอก เอะ เกือฮ แฮรน อาึง มานา ติ โดง ละ จัตเจือ เอะ เฆียง เฮี, เดอึม ซ โฮลฮ ยุ ป โซม ป ไอฮ เกือฮ พะจาว ละ เอะ. มัฮ ป เกือฮ อื เอะ โซม เญือม อาวต เตอะ นึง ลาึน เวือฮ ฟวยจ นัม อื เอะ โอก ฮา เมือง อียิป โฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ไอ โมเซ ดวน อาโรน ตุย โดง ติ. เกือฮ อื ละ อาึง มานา นึง อื ติ โอเมอ. เกือฮ อื อาึง อื ซองนา พะจาว ละ ซ แฮรน อื อาึง ฮอยจ ละ จัตเจือ ปุย เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","อาโรน อาึง เนอึม โดง อาวต มานา เซ ลั่กกา ฮิต ลปุง ซันญา ยุฮ พะจาว, ละ ซ แฮรน อื อาึง ตัม ป เอีจ ซตอก พะจาว อาึง ละ ไอ โมเซ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ไน ติ เจน รปาวน เนอึม เมอ, โม อิซราเอน โฮลฮ โซม มานา เซ ฮอยจ ละ ฮอยจ แตะ เมือง คะนาอัน, ป มัฮ เมือง ก ซ อาวต แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(เจน เซ ควน ซมอย โม อิซราเอน โอเอีฮ, ปุย อัฮ เอฟา ไม่ อื. ติ เอฟา มัฮ กาว โอเมอ.) ");
INSERT INTO lcp_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","โม อิซราเอน เตือง มู อื โอก ฮา ลาึน เซอิน. โฮว แนฮ ลั่กกา แตะ ตัม ดวน พะจาว แตะ. ฮอยจ ติ โดฮ นา ก อัฮ ปุย เรฟีดิ่ม ไม่. นา เซ ไก โตว รอาวม ละ ญุ ปุย นึง เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ปุย ฮอยจ เติ ไอ โมเซ ฆาื อื. อัฮ เฮี, “เกือฮ แปฮ รอาวม ละ เอะ เดอึม ซ โฮลฮ ญุ,” อัฮ เซ ละ อื. ไอ โมเซ โลยฮ อื, “เมอยุ เติ เปอะ อาึ นึง อื? เกียฮ โรวต โน่ง เปอะ ลอง รพาวม พะจาว ตอก เซ เมอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ปุย โม เซ ฆวต ญุ เนอึม รอาวม. เติ แนฮ ไอ โมเซ ไม่ ฮาวก รพาวม แตะ. อัฮ เฮี, “เมอยุ นัม เปอะ เอะ โอก ฮา เมือง อียิป เปอ? อัม มัฮ ซ เกือฮ เปอะ เอะ ยุม นึง ไปลญ แตะ รอาวม เตือง กวน เนอะ ไม่ คอง เลียง คอง ดู่ เยอะ เฮี?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ไอ โมเซ ไววอน เนอึม ไววอน แนม ละ พะจาว, อัฮ อื ตอก เฮี, “อาึ ซ ยุฮ ตอก เมอ ละ ปุย โม เฮี เยอ? เอีจ ซเปี แล่น อาึ นึง ซโมะ ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","พะจาว อัฮ เฮี ละ อื, “ไมจ เปอะ บะ โรวก โม ป กวต ป เฮียง ยุฮ อื ไม่ เปอะ ง่อน. โฮว ไม่ ลั่กกา โม ลัปซด่อน. ตุย โรวก โคะ ฆิ เปอะ ป ปุฮ เปอะ โกลง ไน นึง โฮ ไม่ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","อาึ ซ ชุง ลั่กกา เปอะ ราว ซโมะ ระ นึง บลาวง ซีไน. ปุฮ ซโมะ เซ นึง โคะ ฆิ เปอะ. ซ ปัต รอาวม โอก นึง ละ ปุย ละ ซ โฮลฮ อื ญุ,” อัฮ เซ ละ อื. ไอ โมเซ ยุฮ เนอึม อื ตอก เซ ซองนา โม ป กวต ป เฮียง ยุฮ โม อิซราเอน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","เคียง เซ ปุย อัฮ มัตซา ไม่ เมรีบ่า ไม่ นา เซ, นึง เติ โม อิซราเอน ป โพต พะจาว ละ แตะ ไม่ ลอง อื รพาวม อื. เอีจ อัฮ เฮี, “พะจาว อัม อาวต เนอึม ไม่ เอะ แล, อัม โอ อาวต แล?” เอีจ อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","เญือม อาวต โม อิซราเอน นึง เรฟีดิ่ม เซ โม ตฮัน เมือง อามาเลก ฮอยจ ตอซู ปุ แตะ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ไอ โมเซ อัฮ เฮี ละ โยชูวา, “ไมจ เปอะ เลือก อาึง ปุย ละ ซ โฮว ตอซู อื ปุ แตะ ไม่ โม อามาเลก. ซง่าวป อาึ ซ ชุง นึง ไกญ บลาวง. ซ ไปญ โคะ ฆิ ดวน พะจาว อาึ โรวก ไม่ แตะ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ปวยฮ พริ เซ โยชูวา ยุฮ เนอึม อื ตอก ดวน ไอ โมเซ แตะ. โอก ตอซู ปุ แตะ ไม่ โม อามาเลก. ไอ โมเซ ไม่ อาโรน ไม่ เฮอ ฮาวก นึง ไกญ บลาวง. ");
INSERT INTO lcp_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ติ เจน ยวก ไอ โมเซ เตะ แตะ เซ, โม อิซราเอน เป โม อามาเลก เบือ อื. เญือม บลาึฮ อื เตะ แตะ เลีฮ มัฮ โม อามาเลก ป เป เยอ. ");
INSERT INTO lcp_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","เญือม เอีจ โซะไมญ อื ไอ โมเซ เญือะ ปุน ยวก โตว เตะ แตะ. อาโรน ไม่ เฮอ เซ ตุย ซโมะ ติ เกือฮ อื งาวม นึง อื. ปุย ลอา เซ ชุง โบ อื ติ ปุย ติ ก บลัฮ, ยวก เตะ อื ฮลาวง เกือฮ ตอน ฮอยจ ละ เลียก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","มัฮ ตอก เซ ตอก เป โยชูวา โม อามาเลก เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ ไซฮ อาึง ไลลวง เฮี ละ ซ เกือฮ ปุย ไตม. ไมจ เปอะ รโฮงะ ซโตฮ ละ โยชูวา, เกือฮ ยุง ซ ยุฮ อาึ ไลจ โลม ไม่ โม อามาเลก ปอ โอ ปุย เญือะ ซ ไตม อื เฟือฮ เอิน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ไอ โมเซ ยุฮ คัน ติ. ปุก มอยฮ คัน เซ. อัฮ “พะเยโฮวา มัฮ โทงไช ยุฮ อาึ,” อัฮ เซ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","อัฮ แม เฮี, “ไมจ เปอะ ยวก โทง ยุฮ พะจาว, นึง มัฮ พะจาว ป ซ ตอซู ลอป ปุ แตะ ไม่ โม อามาเลก โครยญ เจน ปุย โอ เญาะ ไก ลอยจ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","เยโทร ป มัฮ โปะ ไอ โมเซ เซ มัฮ โรฮ ซตุ เมือง มีเดี่ยน. เอีจ ฮมอง โรฮ ไลลวง โอเอีฮ ป ยุฮ พะจาว ละ ไอ โมเซ ไม่ โม อิซราเอน เญือม เกือฮ อื โอก ฮา เมือง อียิป โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ฮอยจ ฆาื อื เคะ ไอ โมเซ. โรวก ซิปโปรา ป มัฮ ปรโปวน เญือะ ไอ โมเซ ไม่ กวน อื เตือง ลอา อื โฮว ไม่ แตะ. กา เซ ไอ โมเซ เอีจ ละ อาึง อื ไม่ โปะ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ไลลวง กวน แตะ เซ ไอ โมเซ เอีจ อัฮ อาึง อื ตอก เฮี, “อาึ เอีจ โฮลฮ แปน ปุย ตัง ด่าว อาวต ตัง เมือง,” อัฮ เซ. เซ ป อัฮ อื เกอโชม ละ กวน โรง แตะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ฟวยจ เซ เญือม เอีจ ไก แม กวน อื ติ อื อัฮ เฮี, “พะจาว ทื เปือะ เกอะ เรอึม อาึ, เกือฮ อาึ โปน ฮา ยุม แตะ นึง วิจ ยุฮ ฟาโร,” อัฮ เซ. เซ ป อัฮ อื เอลีเยเซอ ละ กวน รเคะ แตะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","เยโทร ฮอยจ ดิ ไม่ ปรโปวน เญือะ ไอ โมเซ ไม่ กวน อื เตือง ลอา อื. ฮอยจ นึง ไคะ ก อาวต ปุย นึง ลาึน เวือฮ โบ บลาวง ซัมคัน ยุฮ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","เยโทร ดวน ปุย โฮว รโฮงะ อื ละ ไอ โมเซ ตอก เฮี, “เยโทร ป มัฮ โปะ เปอะ เซ โรวก ปรโปวน เญือะ ปะ ไม่ กวน เปอะ ฮอยจ เคะ เปอะ,” ดวน อื อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ไอ โมเซ โอก โฮว รชึง โปะ แตะ เซ. นุ่ม ไว อื, ฮงาึต อื ไม่ อื. ไฮมญ กอ บาึง ปุ แตะ. ฟวยจ เซ เลียก โตะ พากัง ยุฮ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ไอ โมเซ รโฮงะ ไลลวง ป ยุฮ พะจาว ละ ฟาโร ไม่ โม อียิป นึง กัน เรอึม อื โม อิซราเอน. รโฮงะ โรฮ ไลลวง เม่ะมั่ก อาวม ปุย ตัม คระ โฮว แตะ ไม่ ตอก เรอึม พะจาว แตะ ละ โปะ แตะ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","เยโทร เญือม ฮมอง อื โอเอีฮ ตอก เซ มวน รพาวม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","อัฮ เฮี, “ญันดี่ ไม่ พะจาว ป เกือฮ ปะ โปน ฮา แปน แตะ ครา ฟาโร ไม่ โม อียิป เซ. ญันดี่ โรฮ ไม่ พะจาว ป เกือฮ ปุย โปน ฮา อัมนัต โม อียิป เซ เตือง โอยจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","พะจาว มัฮ ยุฮ อื ตอก เซ นึง ยุฮ โม อียิป ป โซะ ลอน ละ โม อิซราเอน. ปเลี่ย เฮี อาึ ยุง เนอึม เมอะ มัฮ เยโฮวา พะจาว ป ระ เนอึม ฮา พะจาว ไฮญ เตือง โอยจ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","เญือม เซ เยโทร โรวก ซัตซิง, มอก ตอง ทไว อื ละ พะจาว. ทไว โรฮ โอเอีฮ ไฮญ ละ อื. อาโรน ไม่ โม ป กวต ป เฮียง ยุฮ โม อิซราเอน ฮอยจ โซม ดิ ไม่ โปะ ไอ โมเซ เซ ซองนา พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ปวยฮ พริ เซ ไอ โมเซ งาวม รเตีฮ โอเอีฮ ซน่ะ โม อิซราเอน ป ฮอยจ ฟู มวยญ เดือ โครวน ไม่ ปุ แตะ. รเตีฮ อื ละ อื เน่อึม เมือ กซะ อื ฮอยจ เมือ กปู อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","เญือม ยุ โปะ อื ป ยุฮ อื เซ, อัฮ เฮี ละ อื ฆาื อื, “มัฮ ตอก เมอ ป ยุฮ เปอะ ละ ปุย โม เฮี? ปุย ชุง โบ เปอะ เน่อึม เมือ กซะ อื ฮอยจ เมือ กปู อื, เกือฮ ปะ รเตีฮ โอเอีฮ ละ แตะ. เมอยุ ยุฮ โน่ง เปอะ กัน เฮี เยอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ไอ โมเซ โลยฮ อื, “ปุย โม เฮี เตอ ฮอยจ แนฮ เคะ อาึ นึง ฆวต ยุง แตะ ป ปุก รพาวม พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","เญือม ไก ป โอ อื ปุก ปุ แตะ ฮอยจ โรฮ เคะ อาึ. อาึ รเตีฮ ซน่ะ ปุย ละ อื. รโฮงะ ลปุง ซตอก พะจาว อาึง ละ ปุย ไม่ โกตไม ยุฮ อื ละ อื. มัฮ เซ ป ยุฮ ฮุ ตอก เฮี ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","โปะ ไอ โมเซ อัฮ เฮี, “ปุก โตว ตอก ยุฮ เปอะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","ดัฮ เปอะ ยุฮ แนฮ ตอก เฮี, ปะ ซ โซะ ไมญ ลอน เปอะ. ปุย โม เฮี ซ เตือ ลอน โรฮ นึง มอง แตะ ปะ. กัน เมาะ เฮี เชียน ลอน ละ ปะ โน่ง. ");
INSERT INTO lcp_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","ง่อต ป อัฮ อาึ เฮี เญี่ยะ. ซ รโฮงะ ละ เปอะ ตอก ซ ชาวง อื ละ เปอะ. พะจาว ซ อาวต โรฮ ไม่ เปอะ. ปะ ไมจ เปอะ แปน ป โฮว ฆรอ ลปุง ตัง ปุย ละ พะจาว. ไมจ เปอะ ซึป ไลลวง ปุย ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ไมจ โรฮ เปอะ เพอึก ตอม ปุย ตัม ลปุง ซตอก พะจาว ไม่ โกตไม ยุฮ อื, ละ ซ เกือฮ เปอะ ปุย ยุง ตอก ไมจ อื ยุฮ ตอก ซ ปุก อื รพาวม พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","โนก ฮา ปะ อา ปังเมอ ไมจ แม เปอะ เลือก ปุย ไฮญ ป เกียฮ ยุฮ กัน เฮี ไม่ เปอะ. ไมจ เปอะ ดุฮ แปน ป กวต ป เฮียง, เกือฮ รเตีฮ รตุม โอเอีฮ ละ ปุย. ไมจ เปอะ เลือก ปุย ป ทื เนอึม พะจาว, ป เนอึม รพาวม ไม่ ซื แตะ, ป โอ ญอม เกือฮ ปุย นุน แตะ. ดุฮ เกือฮ แปน ป ตัตเตียง ปุย ติ เปือน ง่อน, ติ รอย ง่อน, รฮอน ง่อน, กาว ง่อน. ");
INSERT INTO lcp_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","เกือฮ แปน ลอป ป รเตีฮ รตุม โอเอีฮ ละ ปุย. ดัฮ ไก ไลลวง ป ญัก ลอน ละ อื เกือฮ ตาว อื ฮอยจ ละ ปะ. ดัฮ มัฮ ป โอ ทัน ญัก โฮ เกือฮ โม เซ รเตีฮ ไอฮ. ซ ฌักแฟน บุย ละ ปะ ฆาื อื. ปุย ไฮญ ซ โฮลฮ โรฮ เรอึม กลอม ป เชียน ไม่ เปอะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ดัฮ มัฮ ป ปุก รพาวม พะจาว โฮ, ดัฮ เปอะ ยุฮ ตอก อัฮ อาึ อื เซ, ปะ ตึน โอ เปอะ ซ โซะ ไมญ ลอน ฆาื. ปุย โฮวน เฮี ซ โฮลฮ เอีญ อาวต ไมจ อาวต มวน ฆาื อื ไม่ ปุ แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ไอ โมเซ ง่อต ป อัฮ โปะ แตะ เซ ละ แตะ. ยุฮ เนอึม อื ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","เลือก เนอึม ปุย ป ปุน ยุฮ กัน ตอก เซ. เลือก อื เน่อึม นึง โม อิซราเอน เตือง โอยจ อื. เกือฮ เนอึม อื แปน ป กวต ป เฮียง ป รเตีฮ โอเอีฮ ละ ปุย. เกือฮ อื แปน ป ตัตเตียง ปุย ติ เปือน ง่อน, ติ รอย ง่อน, รฮอน ง่อน, กาว ง่อน. ");
INSERT INTO lcp_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","เกือฮ เนอึม อื รเตีฮ รตุม ลอป โอเอีฮ ละ ปุย. ไลลวง ป ญัก ลอน นึง อื เกือฮ อื ตาว อื ละ โกะ แตะ. ป โอ ทัน ญัก นึง อื เกือฮ อื รเตีฮ ไอฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ฟวยจ เซ ไอ โมเซ ตาว โปะ แตะ เซ เอีญ. โปะ อื เซ เอีญ เนอึม ฮอยจ เมือง โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","เญือม เอีจ ฟวยจ โอก โม อิซราเอน ฮา เมือง อียิป เตม ลอวย เคิ อี, ฮอยจ นึง ลาึน ซีไน. ");
INSERT INTO lcp_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","กา เซ เอีจ โอก ฮา นาตี เรฟีดิ่ม เดอึม ฮอยจ นึง ลาึน ซีไน เซ. ยุฮ ไคะ อาวต แตะ นึง ชวง บลาวง ซีไน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ไอ โมเซ ฮาวก เคะ พะจาว. เญือม เซ พะจาว อู ไม่ อื นึง ไกญ บลาวง เซ. ดวน อื อัฮ อื ละ จัตเจือ ยาโคป ป มัฮ โม อิซราเอน เซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“โม เปะ เอีจ ยุ เปอะ ป ยุฮ อาึ ละ โม อียิป เปอ. อาึ เอีจ ยวก โรวก โม เปะ ตอก ยวก กลัง ลอง โรวก กวน แตะ ราว โพรยจ แตะ โฮ. มัฮ เกือฮ โม เปะ เอีญ เคะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","ดัฮ โม เปะ ซ เนอึง ป อัฮ อาึ, ไม่ ยุฮ เปอะ ตัม ลปุง ซันญา เอะ ไม่ ปุ แตะ เซ, อาึ ซ เกือฮ โม เปะ แปน ปุย ไน แตะ ป พิเซต ฮา ปุย เมือง ไฮญ. ปลัฮเตะ เฮี, ไม่ โอเอีฮ ป ไก นึง อื เตือง โอยจ อื เอีจ มัฮ คอง อาึ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","โม เปะ ซ แปน เปอะ ซตุ รซอฮ ละ อาึ เตือง บั่น เตือง เมือง เปอะ. ซ แปน เปอะ ปุย ซง่ะ ซงอม ยุฮ อาึ เตือง เมือง เปอะ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ฟวยจ เซ ไอ โมเซ เลีฮ กอก โม ป กวต ป เฮียง ยุฮ โม อิซราเอน ฮอยจ เคะ แตะ. รโฮงะ ลปุง พะจาว ละ อื โครยญ เจือ ตอก ดวน พะจาว แตะ อัฮ. ");
INSERT INTO lcp_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","โม อิซราเอน เตือง โอยจ อื บรุก อัฮ อื ไม่ ปุ แตะ ตอก เฮี, “เมาะ ป อัฮ พะจาว เซ เอะ ซ ยุฮ ฮุ เตือง โอยจ อื,” อัฮ เซ. ไอ โมเซ รโฮงะ แม ป อัฮ ปุย โฮวน เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","พะจาว อัฮ เฮี ละ ไอ โมเซ, “อาึ ซ ฮอยจ เคะ ปะ ไม่ ชุต รวู กุ. ซ อาวต กไน ชุต รวู เซ ละ ซ เกือฮ แตะ ปุย ฮมอง เญือม ลปุง แตะ ไม่ เปอะ, เดอึม ปุย โม เซ ซ เจือ ลอป ลปุง ปะ ฆาื อื,” อัฮ เซ ละ อื. เมาะ ป อัฮ ปุย โฮวน เซ ไอ โมเซ รโฮงะ อื ละ พะจาว โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ เอีญ เคะ ปุย โฮวน เซ. ไน ลอา ซเงะ เฮี ไมจ เปอะ ดวน ปุย เกือฮ เพรียง ติ แตะ เกือฮ ซง่ะ ไล ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ไมจ อื ซัก เครอึง แตะ ไม่ เพรียง อื อาึง ติ แตะ ละ ซะติ เซ. ซเงะ เซ อาึ ซ เลีฮ นึง ไกญ บลาวง ซีไน ซองนา ปุย โฮวน เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ไมจ เปอะ ยุฮ เคต ยุฮ โวง อื ละ ปุย รวิต รเวียง บลาวง เฮี. ไมจ เปอะ ซตอก ปุย โอ ฮาวก นึง บลาวง เฮี, ไม่ โอ อื เลียก กไน เคต กไน โวง เซ, ไม่ โอ อื ซ ลอก เคต เซ เฟือฮ เอิน. ดัฮ ไก ป ลอก กไน เคต เซ จัมเปน อื ลอก ตุต แตะ ฮอยจ ละ ยุม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","ไมจ เปอะ โตว โกว เตะ แตะ ละ ซ ยุฮ แตะ ยุม ไม่ ปุย ตอก เซ. ไมจ เปอะ แล่น นึง ซโมะ. โต เซ ไมจ เปอะ โปยญ นึง อัก. ปัง มัฮ ซัตซิง ญุ่ก, ปัง มัฮ ปุย ญุ่ก, ปุ เกือฮ ไอม. เญือม เอีจ ฮมอง เปอะ เซียง โตวต บั่ว เซียง แตะ ลั่ง เงอ, ไมจ เปอะ เกือฮ ปุย โม เซ ฮอยจ นึง ชวง บลาวง เฮี,” อัฮ เซ ละ ไอ โมเซ พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ไอ โมเซ เลีฮ เคะ ปุย. เกือฮ อื เพรียง ติ แตะ ละ ซ แปน อื ปุย ซง่ะ ไล. ปุย ซัก เนอึม เครอึง แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","อัฮ เฮี ละ อื, “ไมจ เปอะ เพรียง อาึง ติ แตะ ละ ซเงะ ซะติ เซ. ปุ เกือฮ ติ เปอะ ยุ ปุ แตะ ไม่ ปรโปวน เฟือฮ เอิน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","เญือม เอีจ ฮอยจ อื ซเงะ ลอวย นึง อื เมือ กซะ อื เนอึม บริ นึง. ปลุกปลัก. นึง ไกญ บลาวง เซ เลีฮ ชุต รวู กุ นึง. ลอยฮ เซียง โตวต นึง เนอึม ไอฮ พาวม แตะ. เมาะ ป อาวต โตะ พากัง โครยญ โดฮ โฮ ฮลัต เตีจ, รกุฮ รเตียง ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","เญือม เซ ไอ โมเซ เกือฮ ปุย โอก ฮา พากัง ยุฮ แตะ ละ ซ โฮลฮ อื ยุ พะจาว. ปุย โฮวน เซ โฮว ชุง นึง ชวง บลาวง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","พะจาว เลีฮ ไม่ งอ อาวต นึง บลาวง ซีไน. บลาวง เซ ม่าึต งอ นึง เลี่ป อื เอิน. ม่าึต อื เซ ฮาวก ตอก ม่าึต งอ เญือม โตก ปุย โฮ. บลาวง เซ ดุงเดียง เลี่ป อื เอิน. ");
INSERT INTO lcp_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","เซียง โตวต เซ ลอยฮ ซนัน เรียง ปุ ปุ. เญือม เซ ไอ โมเซ ลปุง ไม่ พะจาว. พะจาว โลยฮ อื ละ อื. เซียง พะจาว ตอก เอิน เนอึม บริ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","พะจาว เลีฮ ฮอยจ นึง ไกญ บลาวง ซีไน. กอก ไอ โมเซ ฮาวก เคะ แตะ นึง ไกญ บลาวง เซ. ไอ โมเซ ฮาวก เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","เญือม เซ พะจาว อัฮ เฮี ละ อื, “ไมจ เปอะ เลีฮ แม เคะ ปุย โฮวน เซ. ไมจ เปอะ ซตอก เกือฮ โอ ลู เลียก ละ ซ แก แตะ พะจาว. ดัฮ ลู เลียก โฮ โฮวน ป ซ ยุม ฆาื. ");
INSERT INTO lcp_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","ไมจ โรฮ เปอะ ดวน โม ซตุ ป รซอฮ ละ อาึ เซ เกือฮ เพรียง ติ แตะ เกือฮ ซง่ะ ไล ละ อาึ, เดอึม อาึ โอ ซ เกือฮ ลอก ตุต แตะ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ไอ โมเซ โลยฮ อื ละ พะจาว ตอก เฮี, “ปะ เอีจ ดวน เปอะ เอะ ยุฮ เคต โวง ละ ปุย รวิต รเวียง บลาวง เฮี, ละ ซ เกือฮ แปน นาตี ซัมคัน. ปุย โฮวน เซ เญือะ โรวต โตว ฮาวก นึง บลาวง ซีไน ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","พะจาว อัฮ เฮี ฆาื อื ละ ไอ โมเซ, “เลีฮ เมิฮ, ฟวยจ เซ ดัฮ เปอะ เอีจ ฮาวก แม โฮ บะ โรวก อาโรน เนอ ฮาวก ดิ ไม่ เปอะ. โม ซตุ ไม่ ปุย โฮวน เซ ปุ เกือฮ ลู เลียก เคะ อาึ, เดอึม อาึ โอ ซ ฮาวก รพาวม พราวป ละ ฆาื อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ไอ โมเซ เลีฮ เนอึม เคะ ปุย โฮวน เซ. รโฮงะ เนอึม อื ละ ปุย โครยญ เจือ ตัม ป อัฮ พะจาว ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","เญือม เซ พะจาว ลปุง ไม่ ปุย. อัฮ อื ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ ป ตาว โม เปะ โอก ฮา เมือง อียิป นา ก แปน เปอะ ครา ปุย โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“ปุ เกือฮ พะจาว ไฮญ ไก ละ เปอะ โนก ฮา อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“ปุ ยุฮ ฮุป ละ ซ ไว เปอะ. ฮุป โอเอีฮ ป ไก นึง มะลอง ญุ่ก, ป ไก นึง ปลัฮเตะ ญุ่ก, ป ไก โตะ รอาวม ญุ่ก. ");
INSERT INTO lcp_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ปุ นุ่ม ไว ฮุป ตอก เซ. ปุ โรฮ นัปทื. อาึ ป มัฮ เยโฮวา เอีจ มัฮ พะจาว ยุฮ เปอะ. อาึ ญอม โตว เกือฮ พะจาว ไฮญ ไก ลลาึง เปอะ. โม ป ยุฮ ป พิต ละ อาึ อื, อาึ ซ เกือฮ ลอก ตุต แตะ ฮอยจ ละ จัตเจือ อื ลอวย ปาวน เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ละ โม ป ฮรัก อาึ ไม่ ยุฮ อื ตัม ดวน อาึ แตะ, อาึ ซ เปลีฮ ลอป รพาวม ฮรัก ตอน ฮมัน ยุฮ แตะ ละ ฮอยจ ละ จัตเจือ อื แปน เปือน เจน แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“มอยฮ เยโฮวา ป มัฮ พะจาว ยุฮ เปอะ เซ ปุ โกว ไอฮ พาวม เปอะ, ป โกว มอยฮ พะจาว ไอฮ พาวม แตะ, พะจาว ซ เกือฮ อื ลอก ตุต ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“ไมจ เปอะ เกือฮ ติ แตะ ไตม ซเงะ ลโล่ะ แตะ. ไมจ เปอะ ทื แปน ซเงะ ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ไน แลฮ ซเงะ เอ โม เปะ ไมจ เปอะ ยุฮ กัน แตะ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ซเงะ อาแลฮ นึง อื มัฮ ซเงะ ลโล่ะ เปอะ ละ ซ นัปทื เปอะ พะจาว ยุฮ แตะ. ไน ซเงะ เซ ปุ ยุฮ กัน ติ เจือ เนอึม. ปะ ญุ่ก, กวน เปอะ ญุ่ก, กวนไจ เปอะ ญุ่ก, คอง เลียง เปอะ ญุ่ก, ปุย ตังเมือง ป อาวต ไม่ เปอะ ญุ่ก, ไมจ โตว อื ยุฮ กัน ติ ตื เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ไน แลฮ ซเงะ เอ พะจาว ยุฮ ปลัฮเตะ ไม่ ปลัฮ มะลอง, ไม่ ปลัฮ รอาวม เตือง โอเอีฮ ป ไก นึง อื เตือง โอยจ อื. ซเงะ อาแลฮ เซ พะจาว ลโล่ะ นึง อื. มัฮ เซ ป ปิฮ พะจาว มุ่น ละ ซเงะ อาแลฮ เซ ฆาื อื. มัฮ เกือฮ อื ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“ไมจ เปอะ นัปทื มะเปือะ แตะ. ดัฮ เปอะ ยุฮ ตอก เซ ซ โฮลฮ เปอะ จีวิต ลั่ง เลี่ญ แตะ นึง เมือง เกือฮ เยโฮวา พะจาว ยุฮ เปอะ ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“ปุ ยุฮ ยุม ไม่ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“ปุ เลน จุ ซู เมีย ปุย เยอ. ");
INSERT INTO lcp_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“ปุ บระ โอเอีฮ ฮี. ");
INSERT INTO lcp_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“ปุ แปน ซกิ พีญัน ป โอ เนอึม ละ ปุ ย่วง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ปุ เกือฮ ติ เปอะ ฆวต ไอฮ เญือะ ม่า ยุฮ ปุ ย่วง เปอะ. ปุ โรฮ ฆวต ไอฮ ปุย เญือะ อื. กวนไจ รเมะ รโปวน ยุฮ อื ญุ่ก, คอง เลียง อื ญุ่ก, โอเอีฮ ไฮญ ยุฮ อื ญุ่ก, ปุ ฆวต ไอฮ ฮา อื ติ เจือ เนอึม,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","เญือม ฮมอง ปุย โฮวน เซ เนอึม บริ ไม่ เซียง โตวต เซ, ไม่ ยุ อื ปลุกปลัก ไม่ ม่าึต งอ นึง บลาวง เซ, ฮลัต เตีจ ฆาื อื ปอ รกุฮ รเตียง แตะ. ราึต ลั่กเคะ แตะ ชุง ฮา อื ซไง ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ปุย โฮวน เซ อัฮ เฮี ละ ไอ โมเซ, “ปุ เกือฮ พะจาว ลปุง ไม่ เอะ. ฮอ นึง ซ ยุม แตะ ฆาื. ลปุง ไอฮ ปะ ไม่ เยอะ. เอะ ซ ง่อต ป อัฮ ปะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ไอ โมเซ อัฮ เฮี ละ ปุย โฮวน เซ, “ปุ ฮลัต ฆาื. พะจาว เอีจ มัฮ ฮอยจ อื นึง ฆวต ลอง แตะ แลน รพาวม โม เปะ. มัฮ โรฮ ซ เกือฮ อื โม เปะ ไก รพาวม ฮลัต นึง แตะ ละ ซ เกือฮ อื โม เปะ โอ โรวต ยุฮ ป พิต,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","เญือม เซ ไอ โมเซ เลียก เคะ พะจาว โตะ ชุต รวู กุ ก อาวต พะจาว เซ. ปุย โฮวน เซ ชุง ฮา อื ซไง. ");
INSERT INTO lcp_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","พะจาว ดวน ไอ โมเซ รโฮงะ อื ละ โม อิซราเอน ตอก เฮี, “โม เปะ เอีจ ยุ เอีจ ฮมอง เปอะ ไอฮ ลปุง อาึ ไม่ โม เปะ เน่อึม นึง มะลอง. ");
INSERT INTO lcp_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ปุ ยุฮ ฮุป โอเอีฮ นึง มาื นึง ไคร ละ ซ ไว เปอะ, ไมจ เปอะ ไว อาึ โน่ง. ");
INSERT INTO lcp_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ไมจ เปอะ ยุฮ คัน ทไว นึง เตะ. ไมจ เปอะ มอก ตอง ทไว โมวก ไม่ ปิ ไม่ แกะ ยุฮ เปอะ นึง คัน เซ. ไมจ โรฮ เปอะ ทไว โอเอีฮ ไฮญ นึง อื, ละ ซ เปลีฮ เปอะ รโจะ ดิ เปอะ รพาวม แตะ ไม่ อาึ. โครยญ โดฮ นา ก เกือฮ อาึ เปอะ ยุฮ คัน ละ ซ ทไว เปอะ โอเอีฮ ละ อาึ นึง เซ, อาึ ซ ฮอยจ เคะ เปอะ นา เซ. ซ ปิฮ มุ่น ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ดัฮ เปอะ ยุฮ คัน นึง ซโมะ ละ ซ ทไว เปอะ โอเอีฮ ละ อาึ โฮ, ปุ โกว ซโมะ ป เอีจ ปอยจ เอีจ เพรียง ปุย ละ. ดัฮ เปอะ เกือฮ ซโมะ เซ ไก ฮรอย มีต ฮรอย รปอยจ นึง โฮ, เอีจ มัฮ เกือฮ เปอะ ซโมะ เซ แปน ป โอ ซง่ะ ไล ละ อาึ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","ปุ ยุฮ โบง ละ ซ ฮาวก เปอะ นึง คัน เซ, เดอึม เปอะ โอ ซ เปลีฮ เนะซอัง แตะ, แปน ป โยะโพก พังไฮะ ละ คัน เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","พะจาว อัฮ เฮี, คัก เฮี อื มัฮ โกตไม ป ไมจ เปอะ รโฮงะ ละ โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","ดัฮ เปอะ รวี โม ฮีบรู ละ ซ ยุฮ เปอะ ครา แตะ นึง โฮ, ปุย เซ ซ โฮลฮ ยุฮ กัน ละ เปอะ แลฮ เนอึม. เญือม เอีจ ฮอยจ อื เนอึม อาแลฮ นึง อื, ไมจ เปอะ พลวย เกือฮ เอีญ เตือง โอ อื เญาะ ทา โอยจ มาื ละ โตฮ อื ติ แตะ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ดัฮ ฮอยจ ไม่ โอ แตะ ไก ปุย เญือะ โฮ, เญือม เอีญ อื ปุ โรฮ เกือฮ เอีญ ดิ ไม่ ปุย เญือะ แตะ. ดัฮ ฮอยจ ไม่ ปุย เญือะ แตะ โฮ, เกือฮ โรฮ เอีญ ดิ ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ดัฮ ปอเลียง อื เกือฮ ปรโปวน เญือะ อื ละ อื, ปัง ไก กวน รเมะ กวน รโปวน ไม่ ปุ แตะ, ปรโปวน เญือะ อื เซ ไม่ กวน อื เซ มัฮ ลั่ง กวนไจ ปอเลียง แตะ. เกือฮ ปรเมะ เซ เอีญ โน่ง ฮา ปอเลียง แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","ดัฮ ป มัฮ ครา เซ อัฮ ติ แตะ ฮรัก ปอเลียง แตะ, ไม่ ฮรัก โรฮ อื ปรโปวน เญือะ แตะ ไม่ กวน แตะ, ดัฮ โอ ฆวต เอีญ ฮา ปอเลียง แตะ โฮ, นึง ญอม อื แปน ลอป ครา อื, ");
INSERT INTO lcp_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ดัฮ มัฮ ตอก เซ ปอเลียง อื เซ ไมจ อื ตาว ปุย เซ ฮอยจ ซองนา พะจาว. เกือฮ ปอเลียง อื เซ ตาว ฮอยจ ละ รเวือะ เญือะ. เกือฮ อาึง ฮยวก แตะ นึง รเวือะ ญุ่ก, นึง มะรเวือะ ญุ่ก. เกือฮ ปอเลียง อื เซ ตอฮ ฮละ ฮยวก อื นึง ไร ลอม. ฟวยจ เซ ปุย เซ ซ แปน ลอป เอิน กวนไจ ปอเลียง แตะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","ดัฮ ไก ปรเมะ ป โชะ กวน รโปวน แตะ เกือฮ แปน ครา ปุย, ปรโปวน เซ ซ โฮลฮ โตว เอีญ ฟวยจ แลฮ เนอึม ตอก ครา รเมะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ดัฮ ปรโปวน เซ โอ เญาะ ปุก รพาวม ปอเลียง แตะ ป ตะ อื เกือฮ แปน ปรโปวน แตวะ เญือะ แตะ เซ, จัมเปน โชะ แม อื ละ เปือะ โกะ อื. ซ โฮลฮ โตว โชะ อื ละ ปุย ตังเมือง นึง โอ อื เญาะ เนอึม รพาวม ละ ปรโปวน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ดัฮ ปุย รวี ครา รโปวน ละ ซ เกือฮ อื แปน ปรโปวน เญือะ กวน รเมะ แตะ ไมจ อื เมีญ ตอก กวน โมวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ปรเมะ ดัฮ ไอฮ ปรโปวน แตวะ เญือะ แตะ โนก ฮา กวนไจ เอีจ ไอฮ ไพรม แตะ โฮ, ไมจ อื เกือฮ ลั่ง ปรโปวน ไพรม เซ โฮลฮ ป ลัง โฮลฮ แตะ. ป โซม ป ปอน ไม่ เครอึง เซอึก ไม่ ไลลวง ตอก อาวต รเมะ รโปวน ไม่ ปุ แตะ ไมจ โตว อื เกือฮ วิต ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ดัฮ โอ เญือะ ญอม เกือฮ โอเอีฮ เซ ละ อื ตอก ไพรม แตะ, จัมเปน อื ไมจ เกือฮ ปรโปวน เซ เอีญ เยือ ฮอยจ เญือะ โกะ แตะ. เญือะ ทา โตว อื โอยจ มาื ละ โตฮ อื ติ แตะ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","ดัฮ ไก ป ปุฮ ปุย ปอ ยุม อื, ไมจ โรฮ ปุย ไฮญ ยุฮ ยุม ไม่ ปุย เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","ตอก ออฮ ตอก เอีฮ ญุ่ก ดัฮ มัฮ โคะ ยุฮ อื เตือง โอ แตะ ไก รพาวม ฆวต ยุฮ โฮ, ปุย เซ ซ โฮลฮ ตอ ฮอยจ นึง นาตี ก เลือก อาึ อาึง ละ ปุย ตอก เซ. ดัฮ อาวต นา เซ โฮ, เญาะ ไก โตว ป ซ ยุฮ ป โซะ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ดัฮ ไก ป โฆง ยุฮ ยุม ไม่ ปุย ไม่ รพาวม ฮาวก แตะ, ปัง ฮอยจ เปิง คัน ยุฮ อาึ นึง ฆวต เกือฮ อื ติ แตะ โปน โฮ, ไมจ เปอะ โฮมวต โรวก ฮา นา เซ. ไมจ เปอะ ยุฮ ยุม ไม่. ");
INSERT INTO lcp_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","ดัฮ ไก ป มอก ป ปุฮ มะเปือะ แตะ, ไมจ เปอะ เกือฮ ปุย เซ ลอก ตุต ฮอยจ ละ ยุม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","ดัฮ ไก ป บระ โฮมวต ปุย ละ ซ โชะ แตะ ญุ่ก, ละ ซ โกว อื แปน ครา แปน เซีญ แตะ ญุ่ก, ปุย ตอก เซ ไมจ โรฮ เปอะ เกือฮ ลอก ตุต ฮอยจ ละ ยุม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","ดัฮ ไก ป อัฮ ลปุง ฆอก ละ มะเปือะ แตะ, ซ ไก โรฮ ตุต ฮอยจ ละ ยุม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","ดัฮ ไก ปุย รเจ ไม่ ปุ แตะ, ดัฮ ติ ปุย อื ปุฮ ปุ รเจ แตะ เซ นึง ซโมะ ญุ่ก, นึง ลกุย แตะ ญุ่ก, ดัฮ โอ ปอ ยุม อื โฮ, ปุย เซ ไก โตว ตุต ฆาื อื. ดัฮ ป โซะ เซ จัมเปน ไอจ ฆาื โซะ แตะ, ดัฮ เอีจ เกียฮ โฮว แม ไม่ โคะ ฆิ แตะ โฮ, ป ยุฮ ป โซะ ละ ปุย เซ ปังเมอ ไมจ อื เกือฮ งวยฮ ซเงะ ละ ป โซะ เซ, ไม่ ไมจ อื เรอึม เยื่อ ป โซะ เซ ฮอยจ ละ ไฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","ดัฮ ไก ป ปุฮ ครา แตะ, ครา รเมะ อื ญุ่ก, ครา รโปวน อื ญุ่ก, ดัฮ ครา อื เซ ยุม เอิน ฆาื อื, ปอเลียง อื เซ ซ ลอก ตุต ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ดัฮ ไอม ลั่ง ติ ลอา ซเงะ โฮ, ฟวยจ เซ ปัง ยุม, ปอเลียง อื ลอก โตว ตุต ฆาื อื. เตอ เอีจ มัฮ คอง อื. ");
INSERT INTO lcp_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","ดัฮ ปรเมะ โต ปรเมะ ปุฮ ปุ แตะ, ดัฮ โคะ ลอก ปรโปวน ป โรวก กวน แตะ ปอ ไลจ เวียก อื โฮ, ดัฮ ปรโปวน เซ โอ โซะ กังเคะ โฮ, ป โคะ ลอก อื เซ จัมเปน อื โละ ละ ปรเมะ เญือะ อื ตัม ป ฆวต ไอฮ อื ไม่ เมาะ ตัตซิน โม ป รเตีฮ รตุม อื ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ดัฮ ปรโปวน เซ ไลจ เนะซอัง ฆาื ตอก ออฮ ตอก เอีฮ ญุ่ก, ป โคะ ลอก อื เซ ไมจ อื ไก ตุต ตัม เฮี, จีวิต ฆรอ จีวิต, ");
INSERT INTO lcp_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ไง่ ฆรอ ไง่, เบียง ฆรอ เบียง, เตะ ฆรอ เตะ, ชวง ฆรอ ชวง. ");
INSERT INTO lcp_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","เบราะ ฮะ ฆรอ เบราะ ฮะ, เบราะ บั่ต ฆรอ เบราะ บั่ต, เบราะ เอีญ ฮนัม ฆรอ เบราะ เอีญ ฮนัม. ");
INSERT INTO lcp_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","ดัฮ ไก ป ปุฮ ครา แตะ, ครา รเมะ อื ญุ่ก, ครา รโปวน อื ญุ่ก, ดัฮ ลอก ไง่ อื ปอ จัก อื โฮ, ไมจ อื พลวย ครา เซ แตะ เกือฮ เอีญ รโตง ไลจ ไง่ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ดัฮ ปุฮ อื ปอ โบวก เบียง อื โฮ, ไมจ โรฮ อื พลวย เกือฮ เอีญ รโตง ไลจ เบียง อื เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","ดัฮ ไก โมวก โปก ป ลอ ป ชาวก ปุย ปอ ยุม อื โฮ, ไมจ ปุย แล่น โมวก เซ นึง ซโมะ ปอ ยุม อื. โตะ อื ปุ เกือฮ ปุย ปอน. กุม โมวก เซ ไก โตว ตุต นึง ยุม ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","โมวก เซ ดัฮ เอีจ โกย ลอ แตะ ปุย, กุม อื ดัฮ เอีจ ฮมอง อื ไม่ โอ ลั่ง แตะ คัง อาึง โมวก เซ โฮ, ดัฮ โมวก เซ ยุฮ ยุม ไม่ ปุย จัมเปน เปอะ แล่น โมวก เซ นึง ซโมะ โรฮ. กุม อื เซ ไมจ โรฮ เกือฮ ลอก ตุต ฮอยจ ละ ยุม แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ตอก ออฮ ตอก เอีฮ ญุ่ก, ดัฮ ปุย โตกโลง เกือฮ ปุย เซ โละ ละ ซ โตฮ อื ติ แตะ ฮา กัน ยุม แตะ เซ, กุม โมวก เซ ไมจ อื โละ มาื ละ เญือะ ป ยุม เซ ตัม เมาะ ปัว เญือะ เซ อื. ");
INSERT INTO lcp_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ดัฮ โมวก เซ ลอ กวนดุ รเมะ ญุ่ก, กวนดุ รโปวน ญุ่ก, ดัฮ ยุม ฆาื อื โฮ, ไมจ โรฮ เปอะ ยุฮ ละ อื ตัม โกต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ดัฮ โมวก เซ ลอ ครา รเมะ ครา รโปวน ยุฮ ปุย ปอ ยุม อื โฮ, กุม โมวก เซ ไมจ อื โละ ละ ปอเลียง อื เซ ง่วย เชเคน. ฟวยจ เซ ไมจ โรฮ ปุย แล่น โมวก เซ นึง ซโมะ ปอ ยุม อื. ");
INSERT INTO lcp_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","ดัฮ ไก ป โปฮ อาึง รเดือป นัมโม่ ญุ่ก, ป กาวง โตะ เตะ ไม่ โอ อื เตือป ญุ่ก, ดัฮ ซัตซิง ตอก โมวก ไม่ บรัง ดุฮ โตะ อื, ");
INSERT INTO lcp_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ป มัฮ กุม นัมโม่ เซ ไมจ อื โละ มาื ละ กุม ซัตซิง เซ ตัม คโนวน อื. ซัตซิง ยุม เซ ปังเมอ ซ แปน คอง กุม นัมโม่ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","ดัฮ โมวก โปก ชาวก โมวก ยุฮ ปุย ไฮญ ปอ ยุม อื, ไมจ กุม โมวก เตือง ลอา อื เซ โชะ แปฮ โมวก เซ, งวยฮ อื เซ ไมจ อื รฆุ บริญ ไม่ ปุ แตะ. โตะ โมวก ยุม เซ ไมจ โรฮ อื รฆุ บริญ ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ดัฮ โมวก เซ กอ ยุฮ ป โซะ ละ โมวก ไฮญ กา เซ โฮ, ไม่ โอ กุม อื คัง อาึง, กุม อื เซ ไมจ อื โรก โมวก ยุม เซ นึง โมวก ไอม. โมวก ยุม เซ ซ แปน คอง โกะ อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ดัฮ ไก ป บระ โมวก บระ แกะ ยุฮ ปุย เยอ, ปัง มอก ปอน อื ญุ่ก, ปัง โชะ อื ญุ่ก, เญือม ปุน ปุย อื จัมเปน อื โรก พอน ตัว รโตง โมวก บระ แตะ ติ ตัว เซ. ดัฮ มัฮ แกะ ป บระ อื ไมจ อื โรก ปาวน ตัว รโตง แกะ ติ ตัว. ");
INSERT INTO lcp_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","ดัฮ ปุย ปุน ป บระ เซ ลไล เลียก อื เมือ ก ซาวม อื, ปัง ปุฮ ป บระ เซ ปอ ยุม อื, กุม โอเอีฮ เซ ไก โตว ตุต ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ดัฮ มัฮ เมือ ซเง่ะ อื ดัฮ ยุฮ ยุม ไม่ อื ซ ไก ตุต ฆาื อื. ป บระ เซ จัมเปน อื ไมจ โรก โอเอีฮ รโตง ป บระ แตะ เซ. ดัฮ โอ ไก โอเอีฮ ยุฮ ไมจ ปุย โชะ โกะ อื ละ ปุย เกือฮ แปน ครา ปุย เดอึม ซ เกียฮ โรก ป ลัง โรก แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ดัฮ ปุย ปุน ป บระ เญือม อาวต ลั่ง อื ไม่ ซัตซิง บระ แตะ เซ, โมวก ญุ่ก, บรัง ญุ่ก, แกะ ญุ่ก, เกือฮ โรก อื ติ แปน ลอา. ");
INSERT INTO lcp_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ดัฮ ปุย พลวย คอง เลียง แตะ เกือฮ เลียก โซม เฮงาะ ไม่ ป โซม ไฮญ นึง ชิจ นึง ม่า ยุฮ ปุย ไฮญ โฮ, ไมจ อื โรก ละ กุม อื. เกือฮ โรก อื นึง ป ตึก นึง ไมจ แตะ เน่อึม นึง ป ซมา โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“ดัฮ งอ โตก ปุย ตอ มา เลียก โตะ รัป ปอ ฮอยจ อื นึง เฮงาะ ยุฮ ปุย, ปัง มัฮ เฮงาะ ชุง, ปัง มัฮ เฮงาะ ฟาว ญุ่ก, ป โตก เซ ไมจ อื โรก ละ กุม อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ดัฮ ไก ป รโปะ อาึง มาื ไม่ เครอึง ไมจ ยุฮ แตะ ไม่ ปุย่วง แตะ, ดัฮ คะมุย บระ ฮา ปุย เซ โฮ, ไมจ ปุย ซาวป ตัว ป บระ เซ. ดัฮ ปุย ปุน ป บระ เซ ไมจ อื โรก ติ แปน ลอา. ");
INSERT INTO lcp_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ดัฮ โอ ปุน อื โฮ, ป ไปญ เครอึง เซ ไมจ อื ฮอยจ ซองนา พะจาว นา ก ทไว ปุย โอเอีฮ ละ อื. เกือฮ พะจาว ตัตซิน ไลลวง ตุย ปุย เซ เครอึง ปุ ย่วง แตะ ไม่ โอ อื ตุย.” ");
INSERT INTO lcp_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","เญือม ฟอง ปุย ปุ แตะ, ปัง มัฮ นึง ไลลวง ไฆร ครัก โมวก ไม่ บรัง บรอง ไม่ แกะ ปิ ไม่ เครอึง เซอึก ไม่ โอเอีฮ ไฮญ, เกือฮ ปุย ลอา เซ ฮอยจ ซองนา พะจาว นา ก ทไว ปุย โอเอีฮ ละ อื. เกือฮ พะจาว ตัตซิน ป ปุก ป พิต นึง อื. ตัว ป พิต นึง อื เซ ไมจ อื โรก ละ ปุโฮมว แตะ เซ ลอา เตะ งวยฮ โอเอีฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","ดัฮ ไก ป รโปะ คอง เลียง แตะ นึง ปุย่วง แตะ, ละ ซ เกือฮ อื โซะโกะ ฮรักซา นึง อื ละ แตะ, ดัฮ คอง เลียง อื เซ ยุม ญุ่ก, ดัฮ ลอก เบราะ ญุ่ก, ดัฮ ไก ป ฮอยจ บระ โรวก เตือง โอ อื ไก ป ยุ ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","เกือฮ ปุย เซ โฮว นา ก ทไว ปุย โอเอีฮ ละ พะจาว. เกือฮ ซันญา อาึง อื ซองนา พะจาว นึง โอ อื บระ คอง เลียง ปุย่วง แตะ เซ. กุม คอง เลียง เซ ไมจ อื โฆย ไม่ เมาะ เซ. ป มอง โอเอีฮ เซ โฮลฮ โตว โรก อื ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ดัฮ มัฮ บระ ปุย อื ฆาื ซลัฮ ป มอง อื เซ, ไมจ อื โรก ละ กุม อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ดัฮ มัฮ เกียต โกะพริ อื โฮ, เกือฮ ป มอง ซัตซิง เซ ตาว เปลีฮ ป โฮฮ อื ละ กุม อื. ซ โฮลฮ โตว โรก รโตง ป เกียต โกะพริ อื เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ดัฮ ไก ป โกว ครัก โมวก ยุฮ ปุย่วง แตะ ดัฮ โซะ ดัฮ ยุม ลไล โอ กุม อื ยุ โฮ, ไมจ ป โกว เซ โรก ละ กุม อื ตัม คโนวน อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ดัฮ กุม อื อาวต ไม่ คอง เลียง แตะ เซ โฮ, ป จัง เซ โฮลฮ โตว โรก งวยฮ อื ละ อื. ดัฮ มัฮ ซัตซิง จัง อื โฮ, ไมจ อื กัฮ งวยฮ จัง แตะ เซ. ป มัฮ กุม อื เซ ไมจ อื เกือฮ ปอ ละ แตะ เมาะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“ดัฮ ไก ปรเมะ ป จุ ปรโปวน โอ ดิ ไก ปุ รง่ะ อา, ดัฮ โฮลฮ ไอจ ไม่ อื โฮ, ไมจ ปรเมะ เซ เกือฮ งวยฮ ปรโปวน เซ ละ เปือะ อื เตม. ไมจ อื ไอฮ ปรโปวน เซ แปน ปุย เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ดัฮ เปือะ ปรโปวน เซ โอ ญอม เกือฮ กวน เครีฮ แตะ เซ ละ โฮ, ปรเมะ เซ จัมเปน ลั่ง อื เกือฮ งวยฮ ปเครีฮ ม่อง เซ ละ เปือะ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“โม ปรโปวน เกียฮ ตู เกียฮ ลอง ไมจ เปอะ โตว เกือฮ ไอม ติ ปุย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“ไมจ เปอะ ยุฮ ยุม ไม่ ปรเมะ ป ไอฮ ซัตซิง ตัง ปุย เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“ดัฮ ไก ป เกือฮ โอเอีฮ ละ พะจาว ไฮญ โนก ฮา อาึ ป มัฮ เยโฮวา เยอ, ไมจ เปอะ ยุฮ ยุม ไม่ ปุย ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“ปุ คัม ปุ คุย ปุย ตังเมือง ลลาึง เปอะ. ไมจ เปอะ ไตม เญือม มัฮ โกะ เปอะ ปุย ตังเมือง นึง เมือง อียิป โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","ปุ โคมเฮง โม แมฮัง แมไม ไม่ โม กวนดอย ลลาึง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ดัฮ เปอะ โคมเฮง โฮ, เญือม ปัว อื อาึ เรอึม แตะ ไม่ รพาวม ตุก แตะ, อาึ แจง ซ ฮมอง รซอม ปัว อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","อาึ ซ ฮาวก รพาวม ฆาื ละ โม เปะ. อาึ ซ เกือฮ ปุย ฮอยจ รุป ไม่ เปอะ, ซ เกือฮ ปุย ยุฮ ยุม ไม่ โม เปะ. ปรโปวน เญือะ โกะ เปอะ ซ แปน แมฮัง, กวน โกะ เปอะ ซ แปน โรฮ กวนดอย ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“ดัฮ เปอะ เกือฮ ปุย ตุก ปุย ญัก ป มัฮ ปุย ไน อาึ รมะ รโตว นึง แตะ, ปุ ยุฮ ตอก ปุย ไฮญ ป เกือฮ มาื ยุฮ แตะ ละ ปุย. ปุ คนัป โรก อื ละ เปอะ ไม่ ด่อก อื. ");
INSERT INTO lcp_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","ดัฮ ปุย กัม ลปิ ซโอว แตะ ไม่ เปอะ, ไมจ เปอะ รแม่ ละ อื กา เลียก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","เมอ เตือง อื ปุย เซ ไก โตว เครอึง ไฮญ ละ ซ ไอจ อื ไม่ ยุ่ง. มัฮ เซ โน่ง ยุ่ง ควน ซโอว อื. ปุย เซ เญือม ปัว อื อาึ เรอึม แตะ อาึ แจง ซ ฮมอง เงอะ. อาึ ซ ยุฮ ละ อื ตัม ป ปัว อื, นึง มัฮ อาึ ป เลียก พาวม นึง ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ปุ อัฮ ลปุง พามัต ดู่แควน พะจาว เยอ. ปุ ซะ ซม่อต โม ป ตัตเตียง ปุย เยอ. ");
INSERT INTO lcp_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“ปุ ฮลักกอ ป ลัง ทไว เปอะ, เฮงาะ ยุฮ เปอะ ญุ่ก, รอาวม อะงุน ญุ่ก, ลออยฮ กาวก ญุ่ก. กวน รเมะ เกิต โรง เปอะ ไมจ เปอะ ทไว ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","กวน โมวก กวน แกะ กวน ปิ เกิต โรง ยุฮ เปอะ ไมจ โรฮ เปอะ ทไว. เกือฮ อาวต ไม่ มะ อื อาแลฮ ซเงะ. ซเงะ ซเตะ นึง อื โรวก ทไว ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“โม เปะ มัฮ เปอะ ปุย เอีจ เลือก อาึ อาึง ละ โกะ แตะ ไอฮ. มัฮ เซ ป โอ เปอะ ไมจ ปอน ซัตซิง ป ยุม นึง เกียต โกะพริ แตะ ฆาื อื, วัต แปฮ ละ เซาะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ปุ ซาวป อู ปุย นึง ไลลวง ป โอ เนอึม. ปุ เรอึม ปุย พิต เตอ นึง แปน เปอะ ซกิ พีญัน ป โอ เนอึม ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","ปัง ไก ปุย โฮวน ป โฮว ซาวป ยุฮ ป พิต เตอ, ปุ พาวม ดิ ไม่. ปัง โฮวน ป อัฮ ป โอ เนอึม นึง แปน อื พีญัน ละ ปุย, ปุ อัฮ ดิ ป โอ เนอึม ไม่. ");
INSERT INTO lcp_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ดัฮ ไก ปุย ตุก ปุย ญัก ป ลอก กัน ฟู มวยญ เดือ โครวน, ปุ ฮรัก ป ฮรัก จัง ป จัง เปอะ นึง อื ละ ซ พาวม ดิ เปอะ ไม่ ป ตุก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“ดัฮ เปอะ ยุ โมวก บรัง ไฆร ยุฮ โม ป ฆวต รุป ไม่ เปอะ ไมจ เปอะ ตาว แม ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ดัฮ เปอะ ยุ ฆลาื บรัง ยุฮ โม ป เกละยุ เปอะ นึง เชียน ลอน ป ตัง อื, ไมจ เปอะ เรอึม ปุย เซ. ปุ โฮว พา เยือ เตือง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“เญือม ลอก ปุย ตุก ปุย ญัก กัน ฟู มวยญ เดือ โครวน, ปุ รัม รเตีฮ ละ อื ตัม ซื อื นึง ตุก อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ตัม ไก ป ฟอง ปุย นึง ป โอ เนอึม ปุ ง่อต เฟือฮ. ปุ ยุฮ ยุม ไม่ ปุย ดัฮ โอ ไก เนอึม พิต โฮ. โม ป ยุฮ กัน ฆอก ตอก เซ อาึ ซ เกือฮ โตว โปน ตุต แตะ เฟือฮ เอิน,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“เญือม รเตีฮ เปอะ โอเอีฮ ละ ปุย ปุ ไอฮ มาื นุน ปุย เปอะ. มาื นุน ปุย ตอก เซ มัฮ ป เกือฮ ปุย ตอก ป จัก ไง่ โฮ. โบว โรฮ ลปุง ป ซื ป ไซ เกือฮ แปน ป โอ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“ปุ คัม ตุง ปุย ตังเมือง ป อาวต ลลาึง เปอะ. โม เปะ เอีจ ยุง เปอะ ไอฮ ตอก อาวม ปุย ตังเมือง อื, นึง เอีจ โฮลฮ โรฮ โกะ เปอะ แปน ปุย ตังเมือง ตัง ด่าว เญือม อาวต เปอะ นึง เมือง อียิป โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ไน แลฮ เนอึม เมอ ไมจ เปอะ ซมา เฮงาะ, ยุฮ รปึม, ไม่ ซาวป เปอะ แฮรน เปลิ ป ซมา เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","เนอึม อาแลฮ นึง อื ไมจ เปอะ เกือฮ ปลัฮเตะ นา ก ริ เปอะ โซม เซ ลโล่ะ. ปุ ซมา. ปุ เปฮ โอเอีฮ ป กวยฮ นึง อื. เกือฮ ปุย ตุก ปุย ญัก ลลาึง เปอะ โฮลฮ โซม โอเอีฮ ป กวยฮ ไอฮ นึง ชิจ ยุฮ เปอะ. ป โฮฮ โซม อื เซ ซ แปน โรฮ ป โซม ละ โกะพริ ไม่ ไซม ไล่ โอเอีฮ. นึง รปึม อะงุน ไม่ รปึม โคะ กาวก ยุฮ เปอะ ไมจ โรฮ เปอะ ยุฮ ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ไน แลฮ ซเงะ เอ ไมจ เปอะ ยุฮ กัน แตะ นึง. ซเงะ อาแลฮ นึง อื ปุ ยุฮ กัน เฟือฮ เอิน เดอึม โมวก บรัง ยุฮ เปอะ ซ โฮลฮ ลโล่ะ. กวนไจ เกิต เญือะ เปอะ ไม่ ปุย ตังเมือง อาวต ไม่ เปอะ ซ โฮลฮ รพาวม บาึง แตะ ฆาื โฮลฮ แตะ ลโล่ะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ไมจ เปอะ เครอึง นึง โอเอีฮ ป อัฮ อาึ อาึง ละ เปอะ เซ โครยญ เจือ. ปุ โกว มอยฮ พะจาว ไฮญ โนก ฮา อาึ, ปุ เกือฮ ปุย ฮมอง อู เปอะ ลอก อื เฟือฮ เอิน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ไมจ เปอะ รโจะ โพรม ไม่ ปุ แตะ ละ ซ ไตม เปอะ อาึ นึง ติ เนอึม ลอวย โฮน. ");
INSERT INTO lcp_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","เคิ อาบิ่ป ป มัฮ เคิ โอก เปอะ ฮา เมือง อียิป เซ ไมจ เปอะ รโจะ โพรม ไม่ ปุ แตะ นึง ติ โฮน. มัฮ กัน เลียง โซม เปอะ คโนมปัง โอ ไก เจือ. ไมจ เปอะ โซม ตัม ไล ดวน อาึ เปอะ โซม โฮ. ไน อาแลฮ ซเงะ เซ ปุ โซม คโนมปัง ไก เจือ นึง เฟือฮ เอิน. ปุ ฮอยจ เคะ อาึ นา ก ทไว ปุย โอเอีฮ เตือง โอ เปอะ ไก ป ทไว. ");
INSERT INTO lcp_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“เญือม เอีจ ฮอยจ เฮงาะ โคระ ยุฮ เปอะ ไมจ แม เปอะ รโจะ โพรม ไม่ ปุ แตะ ติ โฮน แม, ไม่ ทไว โรฮ เปอะ เปลิ ป ซมา ลโลวง ป เคราะ โรง ยุฮ เปอะ เซ ละ อาึ. “เญือม เฟือฮ เบระ รัง แก ไมจ แม เปอะ รโจะ โพรม ไม่ ปุ แตะ ติ โฮน แม, ละ ซ โตก เปอะ ละ อาึ นึง เอีจ ฟวยจ ตาว เปอะ ป โซม ป ไอฮ ฮอยจ นึง เญือะ แตะ. มัฮ เซ ป ไมจ เปอะ รโจะ โพรม ไม่ ปุ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","แปน ลอวย โฮน เตือง เซ ป ไมจ โม ปรเมะ ฮอยจ เคะ พะจาว นึง เญือะ ยุฮ อื ไน ติ เนอึม เมอ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“เญือม โรวก เปอะ ซัตซิง ละ ซ มอก เปอะ ทไว ละ อาึ อื, ปุ ทไว ดิ ไม่ คโนมปัง ป ดุฮ ปุย เจือ คโนมปัง เซ นึง. ลออยฮ ซัตซิง โกว เปอะ นึง กัน เลียง ยุฮ อาึ เซ, ปุ ละ อาึง ฮอยจ ละ ปวยฮ พริ. ");
INSERT INTO lcp_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","เปลิ โรง ป โฮลฮ เปอะ นึง โอเอีฮ ซมา ลโลวง เปอะ เซ, ป ตึก นึง ไมจ แตะ นึง อื, ไมจ เปอะ ทไว ละ พะจาว, ตาว ฮอยจ ละ เญือะ ยุฮ พะจาว ยุฮ เปอะ. “ไมจ เปอะ โตว โกยฮ ดิ โตะ กวน ปิ ไม่ รอาวม ตาึฮ มะ โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“ง่อต แลน, อาึ ซ เกือฮ เตปด่า โฮว รกา เปอะ ติ ละ ซ เฆีญ อื โม เปะ นึง คระ ซ โฮว เปอะ, ไม่ ซ นัม อื โม เปะ ฮอยจ นึง นาตี ก เพรียง อาึ อาึง ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ไมจ เปอะ ง่อต ที ไม่ เนอึง เปอะ ป อัฮ อื ละ เปอะ. ปุ เลฮ เตียง อื. เอีจ มัฮ ป ยุฮ ป อัฮ โอเอีฮ เบือ อัมนัต อาึ. ดัฮ โม เปะ กอ เลฮ โฮ, ซ ยวก โตว พิต ยุฮ โม เปะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","“ดัฮ โม เปะ เนอึง ป อัฮ เตปด่า เซ ไม่ ยุฮ โรฮ เปอะ ตัม ป อัฮ อาึ ละ แตะ โครยญ เจือ, อาึ ซ ตอซู ไม่ โม ป ฆวต ตอซู ไม่ โม เปะ. อาึ ซ คัต ซ เวียน โม ป ฆวต คัต เวียน โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","เตปด่า ยุฮ ฮุ เซ โฮว ลั่กกา เปอะ, ไม่ ซ นัม อื โม เปะ ฮอยจ ละ เมือง อาวต โม อาโมไร, โม ฮิตไท, โม เปริซี, โม คะนาอัน, โม ฮีไว, ไม่ โม เยบุ่ต. อาึ ซ ยุฮ ไลจ ไม่ โม เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ดัฮ เปอะ เอีจ ฮอยจ นึง เมือง เซ ปุ นุ่ม ไว พะ ทื โม เซ. ปุ นัปทื เฟือฮ เอิน. ปุ เฮียน ปซี ปซา ยุฮ อื. ไมจ เปอะ ยุฮ ไลจ ไม่ ฮุป ไว อื. ไมจ เปอะ ตุฮ ซกัง ซโมะ ทื อื เกือฮ บลวย. ");
INSERT INTO lcp_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ไมจ เปอะ นัปทื เยโฮวา พะจาว ยุฮ เปอะ เดอึม อาึ ซ ปิฮ มุ่น ละ ป โซม ป ปอน เปอะ ไม่ รอาวม ญุ เปอะ. อาึ ซ เกือฮ พาญัต พาญัม โฮว ซไง ฮา เปอะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","เญือะ ซ ไก โตว ป ไลจ เวียก ไม่ ป ซแกต นึง เมือง อาวต เปอะ. อาึ ซ เกือฮ โม เปะ ลั่ง ไอม ไพรม กอย ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“อาึ ซ เกือฮ โม ป ตอซู ไม่ เปอะ ฮลัต เตีจ นึง เปอะ. ปุย โครยญ เมือง เมาะ ป ริ คัต เวียน เปอะ อาึ ซ เกือฮ ซุกซัก รพาวม. อาึ ซ เกือฮ ลเตือฮ ติ แตะ ฮา เปอะ ไม่ ซ ตอ เง่าะ ตอ วู อื ฮา เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","อาึ ซ เกือฮ โกวน โอง โกวน ไอญ โฮวน โฮว กา เปอะ ละ ซ โครฮ อื โม ฮีไว ไม่ โม คะนาอัน ไม่ โม ฮิตไท ตอ โอก ลั่กกา เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","มัฮ โตว ซ เกือฮ โอก เอิน ไน ติ เนอึม โน่ง, เดอึม ปลัฮเตะ โอ ซ ฮัง ปอ เกียฮ พรุฮ ลอน ซัตซิง เพระด่าวก นึง ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","อาึ ซ กวย เกือฮ โอก ปุ ปุ, ฮอยจ ละ ซ พรุฮ โม เปะ ปอ ปุน ควป คุม เปอะ เมือง เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","อาึ ซ เกือฮ ม่าื เตะ อาวต เปอะ เซ ไก เน่อึม นึง ปลัฮ รอาวม ซครัก ฮอยจ ละ ปลัฮ รอาวม อาวต โม ฟีลิซเตีย. เน่อึม นึง ลาึน เวือฮ ก เซฮ ฮอยจ ละ โกลง ยูฟะเรตี ก ล่าวง. อาึ ซ มอป ปุย เมือง เซ เกือฮ อาวต ฆรึม อัมนัต เปอะ. ซ โฮลฮ เปอะ โครฮ โอก เกือฮ โปน ฮา แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","ปุ ซันญา อาึง โอเอีฮ ไม่ โม เซ. ปุ โรฮ ซันญา โอเอีฮ ไม่ พะ ทื อื เฟือฮ เอิน. ");
INSERT INTO lcp_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","ปุ เกือฮ ปุย โม เซ อาวต ไม่ เปอะ นึง เมือง ยุฮ เปอะ เซ, เดอึม โอ ซ ไก ตอก เกียฮ นัม โม เปะ ยุฮ ป พิต ละ อาึ. ดัฮ โม เปะ นัปทื พะ ทื โม เซ โฮ, ซ แปน ตอก แฮวะ ละ โกะ เปอะ ไอฮ, โม เปะ ซ ไลจ โลม เปอะ ฆาื เตือง มู เปอะ,” อัฮ เซ ละ อื พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ปะ ไม่ อาโรน ไม่ นาดั่ป ไม่ อาบี่ฮู ไม่ โม ป รเตีฮ รตุม โอเอีฮ ละ โม อิซราเอน อาลแฆลฮ ปุย เซ ฮาวก เคะ อาึ อื นึง บลาวง เฮี. นุ่ม ไว อาึ เน่อึม ก ซไง อื. ");
INSERT INTO lcp_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ฟวยจ เซ มัฮ ไอ โมเซ โน่ง ป โฮลฮ เลียก ซดิ ไม่ อาึ อื. ปุย ไฮญ ปุ เลียก ซดิ อี. โม ลัปซด่อน ปุ เกือฮ ฮาวก นึง บลาวง ไม่ เปอะ เฟือฮ เอิน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ไอ โมเซ โฮว รโฮงะ อื ละ ปุย โฮวน เซ โครยญ เจือ เมาะ ป อัฮ พะจาว อาึง ไม่ โกตไม ยุฮ อื. ปุย โฮวน เซ อัฮ ดิ อื ไม่ ปุ แตะ ตอก เฮี, “โอเอีฮ ป อัฮ พะจาว อาึง เซ เอะ ซ ยุฮ ฮุ โครยญ เจือ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","เญือม เซ ไอ โมเซ ไซฮ อาึง ป อัฮ พะจาว ละ แตะ เซ โครยญ เจือ. ปวยฮ พริ เซ ไอ โมเซ ยุฮ คัน ทไว นึง ชวง บลาวง เซ ติ. ลบุ่ฮ ด่อง ซโมะ กาว ลอา โฆง รโตง โม อิซราเอน เตือง กาว ลอา เจอ อื. ");
INSERT INTO lcp_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","ฟวยจ เซ ดวน โม ปรเมะ นุม โฮว มอก ตอง ทไว ซัตซิง ละ พะจาว ง่อน. เกือฮ แม โรฮ อื ทไว โมวก ละ แปน อื ควน รโจะ ปุย รพาวม แตะ ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ไอ โมเซ ตุย ฮนัม โมวก เซ บลัฮ, อาึง อื โตะ เชือม โบลง. บลัฮ อื ซพรอต อื นึง คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","เญือม เซ ไอ โมเซ ไปญ นังซื ป มัฮ ลปุง ซันญา ยุฮ พะจาว ไม่ ปุย เซ. ลาว อื ละ ปุย เกือฮ ปุย ฮมอง อื. ปุย โฮวน เซ อัฮ อื ตอก เฮี, “เอะ ซ ยุฮ ตัม ป อัฮ พะจาว อาึง เซ โครยญ เจือ. เอะ ซ เนอึง เงอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","เญือม เซ ไอ โมเซ ตุย ฮนัม โตะ เชือม โบลง เซ. ซพรอต อื นึง ปุย โฮวน เซ, อัฮ เฮี ไม่ อื, “เฮี มัฮ ฮนัม ป ตอน ยุฮ ลปุง ซันญา พะจาว ไม่ โม เปะ. มัฮ เกือฮ อื ละ เปอะ ไม่ ลปุง ซตอก แตะ อาึง,” อัฮ เซ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","เญือม เซ ไอ โมเซ, อาโรน, นาดั่ป, อาบี่ฮู ไม่ โม ป รเตีฮ รตุม โอเอีฮ อาลแฆลฮ ปุย เซ ฮาวก เนอึม บลาวง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","โฮลฮ เนอึม ยุ พะจาว ยุฮ โม อิซราเอน. ฆรึม ชวง อื เซ ไก ป ตุม โอเอีฮ นึง แปน ปลัฮ อื ตอก แกว มฮานิน, ตอก โรฮ มะลอง เญือม บวยฮ อื โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ปัง ยุ พะจาว ตอก เซ พะจาว ยุฮ โตว ยุม ไม่ โม ป กวต ยุฮ โม อิซราเอน เซ ฆาื อื. ฟวยจ ยุ อื พะจาว เซ เกียฮ โซม เกียฮ ญุ ลั่ง ตอก ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","พะจาว อัฮ แม อื ละ ไอ โมเซ ตอก เฮี, “ฮาวก เคะ อาึ อื นึง บลาวง เฮี. อาวต ไม่ อาึ อื. อาึ ซ เกือฮ แพน ซโมะ ละ เปอะ ลอา แพน. ซ ไก โกตไม ยุฮ อาึ นึง ไม่ ลปุง ซตอก อาึ อาึง ละ ปุย. อาึ มัฮ ไซฮ อาึง ละ ซ เกือฮ เปอะ เพอึก ปุย นึง,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ไอ โมเซ ไม่ ป เรอึม อื ติ ปุย เซ โอก โฮว. ป เรอึม อื เซ มัฮ โยชูวา. ซ ฮาวก นึง บลาวง ยุฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","ไอ โมเซ รโฮงะ อื ละ โม ป กวต ตอก เฮี, “โม เปะ มอง เอะ นา เฮี ฮอยจ ละ เอีญ แม เอะ เคะ เปอะ. อาโรน ไม่ เฮอ อาวต ไม่ เปอะ. ดัฮ ปันฮา เกิต ลไล โฮว เอะ โฮ รโฮงะ ละ ปุย ลอา เซ,” อัฮ เซ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ไอ โมเซ ฮาวก เนอึม นึง บลาวง ซีไน เซ. ชุต รวู ครุป เอิน บลาวง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","รัง ซเปีย ยุฮ พะจาว เลีฮ อาวต ไกญ บลาวง เซ. ละ แลน โม อิซราเอน อื ซเปีย เซ ตอก รเออึป งอ ละ อื, รัง เนอึม รัง แนม. ชุต รวู เซ ครุป ไกญ บลาวง เซ แลฮ ซเงะ. ซเงะ อาแลฮ นึง อื พะจาว กอก ไอ โมเซ ฮาวก เคะ แตะ เน่อึม นึง โตะ ชุต รวู เซ. ");
INSERT INTO lcp_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ไอ โมเซ ลอต ฮาวก ฮอยจ ไกญ บลาวง เซ, เลียก เนอึม โตะ ชุต รวู เซ. อาวต นึง ไกญ บลาวง เซ รปาวน ซเงะ รปาวน ซาวม. ");
INSERT INTO lcp_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“ไมจ เปอะ ดวน โม อิซราเอน ตาว โอเอีฮ ป ทไว แตะ ละ อาึ. เมาะ ป ไก รพาวม ฆวต ทไว ไม่ เตม รพาวม อื นึง, ไมจ เปอะ รัป ป ทไว อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","มัฮ โอเอีฮ โม เฮี ป ไมจ เปอะ ไอฮ เน่อึม นึง ปุย โฮวน เซ, มัฮ ไคร, มาื, ไร ซเงี, ");
INSERT INTO lcp_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","พา ปิญ รฮอยจ, กอย ซี นัมเงิน, กอย ซี ซูวัน, กอย ซครัก ไม่ ฮาึก ปิ. ");
INSERT INTO lcp_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ไอฮ โรฮ ไม่ ฮัก แกะ ญอม ปุย นึง ซี ซครัก, ฮัก กะ โลมา, ไม่ โคะ กทิน. ");
INSERT INTO lcp_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ไอฮ โรฮ ไม่ ลออยฮ ทไว ปุย ละ ออม, ไม่ ลออยฮ ซออย ฮงาื โกว ปุย ละ เรฮ แตะ นึง ปุย. ไอฮ โรฮ ไม่ ป ซออย ฮงาื โกว เปอะ ละ ทไว เปอะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ไอฮ ไม่ แกว พรุยฮ ไม่ แกว ไฮญ ละ ซ แง่ฮ ฆัว เปอะ ลปิ เอโฟต นึง, ไม่ ควน เลอึป รน่าวก ซตุ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“ฟวยจ เซ ไมจ เปอะ เกือฮ ปุย ยุฮ พากัง ซง่ะ ซงอม ละ อาึ, เดอึม อาึ ซ อาวต ซน่ะ ลลาึง ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ไมจ เปอะ ยุฮ พากัง เฮี ไม่ โอเอีฮ ป ลัง อาวต กไน อื ตัม ปิม ป ซ เปลีฮ อาึ ละ เปอะ. ปุ เกือฮ แพก ติ เจือ เนอึม,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","ไมจ เปอะ เกือฮ ปุย ยุฮ ฮิต ติ. ยุฮ นึง โคะ กทิน. ลวง ลั่ง อื เกือฮ ลั่ง ลอา รเนฮ ไปล ติ เดือะ. ลวง เวือฮ อื ติ รเนฮ ไปล ติ เดือะ, ลวง ฮลาวง อื ติ รเนฮ ไปล ติ เดือะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ฮิต เซ ไมจ เปอะ อัป นึง ไคร ซโน เตือง กไน ก พริ อื. ยุฮ โรฮ ไม่ คอป ไคร ป ไก ลวตไล นึง รวิต ฮิต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ไมจ โรฮ เปอะ โล ไคร เกือฮ แปน โวง แตะ ปาวน โวง, ละ ซ ยุฮ เปอะ ฮยวก ฮิต เซ นึง. ฟวยจ เซ ดุฮ นึง โจง ฮิต เซ ซื นา ชวง อื เตือง ปาวน โจง อื. ดุฮ นึง อื เตือง ลอา ก บลัฮ อื, ติ ก บลัฮ ลอา โวง. ");
INSERT INTO lcp_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ยุฮ โรฮ โคะ ลกลอม อื นึง โคะ กทิน, อัป โรฮ นึง ไคร. ");
INSERT INTO lcp_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ฟวยจ เซ ซลอ โคะ ลกลอม เซ โตะ ฮยวก ฮิต เซ ละ ซ กลอม ปุย อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","โคะ ลกลอม เซ ไมจ เปอะ โตว กอฮ ฮา ฮยวก ฮิต เซ เฟือฮ เอิน, ละ แนฮ นึง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","ลปุง ซตอก ป ซ เกือฮ อาึ ละ เปอะ นึง แพน ซโมะ เซ ไมจ เปอะ อาึง โตะ ฮิต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ไมจ โรฮ เปอะ ยุฮ รเดือป ฮิต เซ นึง ไคร ซโน, เกือฮ ลั่ง ลอา รเนฮ ไปล ติ เดือะ, เวือฮ ติ รเนฮ ไปล ติ เดือะ. ");
INSERT INTO lcp_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","แตม แม ฮุป เตปด่า ไก โพรยจ เจอ ลอา, แตม นึง ไคร, อาึง นึง ราว รเดือป ฮิต ซัมคัน เซ เตือง ลอา ลวง อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","เกือฮ รติต เอิน ปุ แตะ ไม่ ลวง ดวยฮ รเดือป ฮิต ซัมคัน เซ เตือง ลอา ลวง อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ฮุป เตปด่า เซ เกือฮ นา ลั่ก ปุ แตะ, ไม่ เกือฮ ดี โพรยจ แตะ เอีญ ลั่ก ปุ แตะ, ละ ซ เลอึป อื รเดือป ฮิต เซ นึง. ไง่ อื เกือฮ แลน ราว รเดือป ฮิต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ฟวยจ เซ ไมจ เปอะ อาึง รเดือป ฮิต เซ ราว ฮิต ซัมคัน เซ. ลปุง ซตอก ป ซ เกือฮ อาึ ละ เปอะ นึง แพน ซโมะ เซ ไมจ โรฮ เปอะ อาึง โตะ ฮิต เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","อาึ ซ เกือฮ ปะ ฮอยจ เคะ แตะ นา เซ. ซ อู ไม่ เปอะ เน่อึม นึง ราว รเดือป ฮิต ป ไก ลปุง ซตอก อาึ นึง ละ เปอะ เซ. เมาะ ป ซ เกือฮ แตะ ปะ รโฮงะ ละ โม อิซราเอน เนอ, อาึ ซ อู ละ เปอะ โครยญ เจือ เน่อึม นึง ซน่ะ เตปด่า ลอา, ป อาวต ราว ฮิต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ฟวยจ เซ ไมจ โรฮ เปอะ ยุฮ โตะ ติ ตัว. ยุฮ นึง โคะ กทิน, เกือฮ ลั่ง ลอา รเนฮ, เวือฮ ติ รเนฮ, ลวง ฮลาวง อื ติ รเนฮ ไปล ติ เดือะ. ");
INSERT INTO lcp_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","โตะ เซ ไมจ เปอะ อัป นึง ไคร ซโน, ยุฮ คอป ป ไก ลวตไล อื นึง ไคร รวิต อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","คอป โตะ เซ ยุฮ เกือฮ เวือฮ ติ ลเตือก เตะ รวิต อื. คอป ไคร ป ไก ลวตไล อื เซ ติต แม เกือฮ บุก คอป โตะ เซ รวิต อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ไมจ โรฮ เปอะ ยุฮ ฮยวก อื นึง ไคร, เกือฮ แปน โวง แตะ ปาวน โวง, ติต ไม่ ชวง โตะ เซ เตือง ปาวน โจง อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ดุฮ เกือฮ ติต ปุ แตะ ไม่ คอป ป ไก ลวตไล อื เซ. ฮยวก อื เซ มัฮ ละ ซลอ ปุย โคะ ลกลอม นึง. ");
INSERT INTO lcp_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ยุฮ แม โคะ ลกลอม อื ละ ซ กลอม ปุย โตะ เซ นึง, ยุฮ นึง โคะ กทิน, ฟวยจ เซ อัป แม นึง ไคร. ");
INSERT INTO lcp_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ไมจ เปอะ ยุฮ เชือม ดี, จอก, รตุง ไม่ เชือม โบลง, ละ ซ โกว ปุย ละ ทไว แตะ รอาวม อะงุน นึง ละ พะจาว. โอเอีฮ โม เซ ไมจ เปอะ ยุฮ นึง ไคร เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ไมจ เปอะ ทไว ลอป คโนมปัง ซัมคัน, ไม่ อาึง เปอะ ซองนา อาึ ราว โตะ เซ ฮอยจ เฆียง เฮี โอ เญาะ ไก ลอยจ. ");
INSERT INTO lcp_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“ไมจ เปอะ ยุฮ ชวง ออม ฮลาวง ติ. ยุฮ นึง ไคร ซโน. ไมจ เปอะ แตม ชวง อื ไม่ โฆง อื. นึง โฆง อื เซ เกือฮ ไก เตีย โพรยฮ, เตีย ปอป ไม่ โปลก เตีย อื, เกือฮ รติต ดิ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ยุฮ เกือฮ ไก กัก แลฮ. กัก อื เซ เกือฮ ซนาว ติ แตะ โอก เน่อึม โฆง อื เซ เตือง ลอา ก บลัฮ อื, ติ ก บลัฮ ลอวย กัก. ");
INSERT INTO lcp_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","กัก อื ติๆ เซ ยุฮ เตีย ตอก เตีย อาละมัน นึง ลอวย โพรยฮ. เตีย เซ โครยญ โพรยฮ อื ยุฮ เกือฮ ไก เน่อึม ไม่ ไก โปลก แตะ. กัก ไฮญ อื ยุฮ โรฮ เกือฮ ตอก ปุ แตะ เตือง แลฮ กัก อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ป มัฮ โฆง ออม เซ, ยุฮ เตีย ตอก เตีย อาละมัน นึง ปาวน โพรยฮ. ยุฮ โรฮ เน่อึม อื ไม่ โปลก อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","36","ฆรึม เน่อึม กัก อื เตือง ลอวย กู อื เซ, ไมจ เปอะ ยุฮ เตีย ปอป นึง. กัก อื เซ เกือฮ ย่อง ติ แตะ ราว เตีย ปอป เซ. โอเอีฮ โม เซ ไมจ เปอะ ยุฮ นึง ไคร ซโน, ยุฮ เกือฮ รติต ปุ แตะ ไม่ โฆง อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","นึง เปือง กัก เตือง อาแลฮ อื เซ, ไมจ โรฮ เปอะ ยุฮ ออม นึง. ไมจ เปอะ เตี ออม เซ เกือฮ ซอต ซเปีย ลวง ลั่กกา แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","มีต ญัป ละ ญัป ปุย กอย นึง ออม เซ, ไม่ ทัต อาึง ปุย มีต ญัป เซ, ไมจ เปอะ ยุฮ นึง ไคร ซโน. ");
INSERT INTO lcp_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ไมจ เปอะ โกว ไคร ละ ติ ตะลัน, ละ ซ ยุฮ เปอะ ออม เซ นึง, ไม่ เครอึง ป โกว ปุย ละ ออม เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ไมจ เปอะ แฮน เนอึม ตอก ยุฮ แตะ โอเอีฮ โม เซ. ไมจ เปอะ ยุฮ ตัม แบ่ป ป เอีจ รโฮงะ อาึ ละ เปอะ นึง บลาวง เซ.” ");
INSERT INTO lcp_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“โนก ฮา เซ ไมจ แม โรฮ เปอะ ยุฮ พากัง ระ นา ก ฮอยจ ปุย เคะ พะจาว, ยุฮ นึง พา กาว ปลัฮ ป ไตญ ปุย นึง กอย ปิญ ไมจ ไม่ กอย ฮาึก แกะ ญอม ปุย นึง ซี ฟะ, ซี ซูวัน ไม่ ซี ซครัก. เกือฮ โม ป เกง ละ ไตญ ชิญ แตะ ยุฮ ฮุป เตปด่า ไก โพรยจ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","พา ติๆ ปลัฮ เซ เกือฮ ลั่ง ง่า โรฮ ซเตะ รเนฮ, เกือฮ เวือฮ ปาวน รเนฮ, เกือฮ เมาะ ปุ แตะ โครยญ ปลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","พา เซ ไมจ เปอะ ชิญ เกือฮ รติต ไม่ ปุ แตะ พอนๆ ปลัฮ. เกือฮ แปน ลอา ชุต. ");
INSERT INTO lcp_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ฟวยจ เซ ยุฮ แม ฮยวก อื นึง พา ซี ฟะ เตือง ลอา ชุต อื เซ, นึง เฆียง อื ตัม ลวง ลั่ง อื ตา ติ ลวง. ");
INSERT INTO lcp_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","พา ติ ชุต อื เซ ยุฮ ฮยวก อื รฮอน, ติ ชุต อื แม ยุฮ โรฮ รฮอน ตอก ปุ แตะ. ฮยวก พา เตือง ลอา ชุต อื เซ เกือฮ อาวต ซื นา ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ยุฮ โรฮ โคะ รมั่ก อื นึง ไคร, ยุฮ รฮอน ตัว ละ ซ มั่ก เปอะ พา ลอา ชุต เซ นึง, เกือฮ รโจะ แปน พากัง ติ ปลัฮ. ");
INSERT INTO lcp_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“ไมจ เปอะ ไตญ พา นึง ฮาึก ปิ ละ ซ เลอึป ปุย ลวง ก พริ พากัง ระ เซ นึง, ไอฮ กาว โรฮ ติ ปลัฮ. ");
INSERT INTO lcp_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","พา ติ ติ ปลัฮ เซ เกือฮ ลั่ง ง่วย รเนฮ, เกือฮ เวือฮ ปาวน รเนฮ. เกือฮ บริญ เมาะ ปุ แตะ เตือง กาว โรฮ ติ ปลัฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","พอน ปลัฮ อื เซ ไมจ เปอะ ชิญ เกือฮ ติต ปุ แตะ แปน ติ ปลัฮ. แลฮ ปลัฮ อื เซ ไมจ โรฮ เปอะ ชิญ เกือฮ ติต ปุ แตะ ตอก เซ โรฮ. ป ไก อื แลฮ ปลัฮ เซ, ตา ติ ปลัฮ อื ไมจ เปอะ เกือฮ ทักโทง ลวง ลั่กกา พากัง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","พา เซ ไมจ โรฮ เปอะ ยุฮ ฮยวก อื ลวง เฆียง อื ติ ปลัฮ รฮอน, ติ ปลัฮ รฮอน เตือง ลอา ปลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ยุฮ โรฮ โคะ รมั่ก อื นึง ไร ซเงี, ยุฮ รฮอน ตัว ละ ซ มั่ก เปอะ พา เซ เกือฮ ติต ปุ แตะ แปน พาเตน ติ ปลัฮ. ");
INSERT INTO lcp_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","พา ป โฮฮ ตา บลัฮ ปลัฮ เซ พลวย เกือฮ ทักโทง ลวง ลั่กเคะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","พาเตน ป โฮฮ ติ ก บลัฮ ติ รเนฮ ตัม ลวง ลั่ง อื เซ, พลวย เกือฮ ทักโทง ละ ซ แปน อื ควน เดีย เฆียง พากัง ระ เซ เตือง ลอา ก บลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ราว พาเตน เซ ไมจ แม เปอะ เลอึป นึง ฮัก แกะ โปก ป ญอม ปุย นึง ซี ซครัก. ฟวยจ เซ เลอึป แม นึง ฮัก กะ โลมา ติ คัก แม. ");
INSERT INTO lcp_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“โคะ ละ ยุฮ เปอะ เดีญ อื เซ ไมจ เปอะ ไอฮ โคะ กทิน ละ. ไมจ เปอะ เดีญ ตุง ฌุง. ");
INSERT INTO lcp_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ไมะ แปน ละ ยุฮ เปอะ เดีญ ติ ติ แพน เซ เกือฮ ลั่ง กาว รเนฮ, เกือฮ เวือฮ ติ รเนฮ ไปล ติ เดือะ. ");
INSERT INTO lcp_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","เกือฮ ไก ซลวยญ นึง ชวง อื ติ แพน ลอา, ติ แพน ลอา เตือง โอยจ อื ละ ซ เกือฮ อื ชุง ซื. ");
INSERT INTO lcp_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","เดีญ ลวง ก เซฮ อื ยุฮ นึง ไมะ แปน ง่า แพน. ");
INSERT INTO lcp_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ยุฮ ไม่ ควน โบลวง อื รปาวน, ยุฮ นึง มาื. ไมะ แปน ติ ติ แพน เซ เกือฮ ไก ควน โบลวง ลอา ลอา ละ ซ โบลวง เปอะ ซลวยญ เซ นึง เตือง ลอา อื. ");
INSERT INTO lcp_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","เดีญ ลวง ก ล่าวง อื ไอฮ โรฮ ไมะ แปน ละ ง่า แพน. ");
INSERT INTO lcp_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ยุฮ โรฮ ควน โบลวง อื รปาวน ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","เดีญ ลวง ลั่กเคะ อื ลวง ลั่ก เลียก ซเงะ ไอฮ ไมะ แปน ละ แลฮ แพน. ");
INSERT INTO lcp_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ไมจ โรฮ เปอะ ยุฮ ไมะ แปน ละ โบลวง เปอะ นึง โจง เดีญ ลวง ลั่กเคะ อื เซ ติ โจง ลอา แพน. ");
INSERT INTO lcp_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ไมะ แปน ลอา แพน เซ เกือฮ ติต ปุ แตะ เน่อึม นึง ชวง อื ฮอยจ นึง ไกญ อื. นึง ไกญ อื เซ ไมจ เปอะ ดุฮ ไร โวง นึง ละ ซ โฮมวต อื ปุ แตะ. ไมจ เปอะ ยุฮ ตอก เซ เตือง ลอา โจง อื. ");
INSERT INTO lcp_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","เตือง โอยจ อื โกว ไมะ แปน ซเตะ แพน, ไม่ ควน โบลวง อื กาว โรฮ แลฮ, ไมะ แปน ติ ติ แพน เซ, ไอฮ ควน โบลวง อื ลอา. ");
INSERT INTO lcp_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","“เดีญ ตัม ลวง ลั่ง อื ติ ติ ก บลัฮ ฮา, ไมจ เปอะ ยุฮ โคะ ซแก อื พอนๆ เตือง ลอา ก บลัฮ อื, ยุฮ นึง โคะ กทิน. เดีญ ลั่กเคะ อื ลวง ลั่ก เลียก ซเงะ นึง อื ไมจ โรฮ เปอะ ยุฮ โคะ ซแก อื พอน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","โคะ ซแก ป อาวต ซน่ะ นึง อื เซ, เกือฮ อาวต ปุก บั่กบ่วน เดีญ เซ. เกือฮ ลั่ง ติ เจน เดีญ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ไมจ เปอะ อัป ไมะ แปน เซ นึง ไคร. ไมจ โรฮ เปอะ ยุฮ ไคร เกือฮ แปน โวง อื. ฟวยจ เซ ติต อาึง นึง ไมะ แปน เซ ละ ซ ซลอ เปอะ โคะ ซแก เดีญ เซ นึง. โคะ ซแก อื เซ อัป โรฮ นึง ไคร. ");
INSERT INTO lcp_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","ไมจ เปอะ ยุฮ พากัง ระ เซ ตัม แบ่ป ป เอีจ รโฮงะ อาึ ละ เปอะ นึง บลาวง โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“ไมจ เปอะ ไตญ พากัง ติ ปลัฮ. ไตญ นึง กอย บิญ ฮาึก แกะ ซี ฟะ, ซี ซูวัน, ไม่ ซี ซครัก. ฟวยจ เซ เกือฮ โม ป ไมจ ฟีมื ไตญ ฮุป เตปด่า ไก โพรยจ นึง พา เซ. ");
INSERT INTO lcp_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ฟวยจ เซ ไมจ เปอะ เคิง พากัง เซ นึง ด่อง โคะ กทิน ปาวน โฆง ป อัป นึง ไคร. ด่อง เซ โบลวง นึง ควน โบลง อื ป มัฮ มาื เซ ติ โฆง ติ. ");
INSERT INTO lcp_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","พากัง เซ ไมจ เปอะ ฟุก นึง โคะ รมั่ก ไคร ป ติต ปุย นึง ด่อง เซ. ฟวยจ เซ ไมจ เปอะ อาึง ฮิต ซัมคัน ยุฮ พะจาว เซ ลวง กไน พากัง เซ. พากัง เซ ซ แปน ป รฆุน ฮอง ซัมคัน ไม่ ฮอง ตึก นึง ซัมคัน แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","รเดือป ฮิต ซัมคัน เซ ไมจ โรฮ เปอะ อาึง ราว ฮิต เซ กไน ฮอง ตึก นึง ซัมคัน แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ป มัฮ โตะ อาึง ปุย คโนมปัง ไม่ ออม ไคร เซ, โบลวง อาึง นึง ก พริ พากัง เซ. ไมจ เปอะ เกือฮ ออม เซ อาวต ลวง ลั่กเซฮ. โตะ อาึง คโนมปัง เซ เกือฮ อาวต ลวง ลั่กล่าวง. ");
INSERT INTO lcp_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","ไมจ เปอะ เกือฮ โม ป ไมจ ฟีมื ไตญ พา ละ เฆีญ โตะ รเวือะ เลียก ปุย กไน พากัง ระ เซ. ไตญ นึง กอย บิญ ฮาึก แกะ ซี ฟะ, ไม่ ซี ซูวัน, ไม่ ซี ซครัก, ไม่ ปัก อื ลวตไล นึง. ");
INSERT INTO lcp_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ยุฮ แม ด่อง อื พอน โฆง นึง โคะ กทิน. ฟวยจ เซ อัป นึง ไคร. ด่อง พอน โฆง เซ มัฮ ละ ซ เคิง เปอะ พา เฆีญ โตะ รเวือะ เซ นึง. โคะ รมั่ก ละ ซ ฟุก เปอะ พากัง เซ นึง, ไมจ เปอะ ยุฮ นึง ไคร. ควน โบลวง ด่อง เซ ไมจ โรฮ เปอะ ยุฮ พอน, ยุฮ นึง ไร ซเงี. ");
INSERT INTO lcp_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“ไมจ เปอะ ยุฮ คัน ทไว นึง โคะ กทิน เกือฮ เวือฮ พอน รเนฮ พัตโมน. ลวง ฮลาวง อื ไอฮ ลอวย รเนฮ. ");
INSERT INTO lcp_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","นึง โจง เตือง ปาวน โจง อื เซ, ไมจ เปอะ ยุฮ โคะ ป ตอก โด่วง โอเอีฮ นึง, เกือฮ ติต ไมจ ปุ แตะ ไม่ คัน ทไว เซ. ไมจ เปอะ อัป คัน เซ นึง ไร ซเงี เลี่ป อื. ");
INSERT INTO lcp_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ไมจ โรฮ เปอะ ยุฮ โดง ละ อาึง เปอะ จะ นึง, ยุฮ โรฮ ไม่ ควน ชาวก จะ, เชือม โบลง, ไร มั่ก โตะ, ไม่ ทัต ละ รฆึม ปุย งอ นึง. โอเอีฮ โม เซ มัฮ ป โกว ปุย ละ รซอฮ แตะ นึง คัน ทไว เซ. ไมจ เปอะ ยุฮ นึง ไร ซเงี เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ไมจ เปอะ ยุฮ ตาแซง นึง ไร ซเงี. ยุฮ โรฮ ไร ซเงี รวอง เงอ ปาวน โวง, ติต อาึง นึง โจง คัน เซ เตือง ปาวน โจง อื. ");
INSERT INTO lcp_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ตา แซง เซ ไมจ เปอะ ดุฮ นึง กไน คัน เซ เน่อึม ฆรึม คอป คัน เกือฮ อาวต โด่ะ ฮอยจ เคียง บั่กบ่วน คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","โคะ ลกลอม อื ยุฮ โรฮ นึง โคะ กทิน, ฟวยจ เซ อัป แม นึง ไร ซเงี. ");
INSERT INTO lcp_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ไมจ เปอะ ซลอ โคะ ลกลอม เซ โตะ ฮยวก คัน ทไว. เญือม กลอม ปุย คัน ทไว เซ, โคะ ลกลอม เซ ซ อาวต ลวง เฆียง คัน เซ ติ ก บลัฮ ติ. ");
INSERT INTO lcp_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","คัน เซ ไมจ เปอะ ยุฮ นึง โคะ เตีป ระ แพน, กไน อื ปังเมอ ไมจ เปอะ เกือฮ ลอาวง. ยุฮ ตัม ปิม ป เอีจ รโฮงะ อาึ ละ เปอะ นึง บลาวง โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“ควง พากัง ระ ลวง ก เซฮ อื ไมจ เปอะ ยุฮ ฆรุง อื เกือฮ ลั่ง ติ รอย รเนฮ, เฆีญ นึง พา แนน ไมจ. ");
INSERT INTO lcp_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","เกือฮ ไก ลัก ง่า โฆง. ยุฮ โรฮ ไม่ ควน โบลวง เปอะ ลัก เซ ง่า โรฮ. ยุฮ นึง ไร ซเงี. ลัก เซ ไมจ เปอะ ยุฮ ควน โฮมวต อื ปุ แตะ, ไม่ ควน ฟุก เปอะ พา เซ นึง. โอเอีฮ เซ ยุฮ นึง มาื. ");
INSERT INTO lcp_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ฆรุง ลวง ลั่กล่าวง อื ไมจ โรฮ เปอะ ยุฮ ตอก ลวง ลั่กเซฮ อื เซ โรฮ. เกือฮ ลั่ง ติ รอย รเนฮ, เฆีญ นึง พา แนน ไมจ. เกือฮ โรฮ ไก ลัก ง่า โฆง ไม่ ควน โบลวง ลัก อื ป มัฮ ไร ซเงี เซ ง่า โรฮ. ควน ฟุก พา ไม่ ควน โฮมวต ลัก เซ ไม่ ปุ แตะ ยุฮ โรฮ นึง มาื. ");
INSERT INTO lcp_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","ตัม ลวง เวือฮ ควง เซ, ลวง ลั่ก เลียก ซเงะ นึง อื, ไมจ โรฮ เปอะ เฆีญ นึง พา แนน ไมจ โรฮ. เกือฮ ลั่ง รฮอน รเนฮ, เกือฮ ไก ลัก กาว โฆง, ไม่ ควน โบลวง อื กาว โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ลวง ลั่ก โอก ซเงะ นึง อื เกือฮ โรฮ ลั่ง รฮอน รเนฮ. ");
INSERT INTO lcp_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","พา ละ เฆีญ ปุย เฆียง โตะ รเวือะ นึง ติ ติ ก บลัฮ ฮา, เกือฮ ลั่ง กาว โรฮ พอน รเนฮ. ไอฮ ลัก อื ลอวย โฆง, ไม่ ควน โบลวง อื ลอวย โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ติ ก บลัฮ อื แม เฆีญ โรฮ นึง พา เกือฮ ลั่ง กาว โรฮ พอน รเนฮ, ไม่ ลัก อื ลอวย โฆง, ไม่ ควน โบลวง ลัก เซ ลอวย โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","นึง โตะ รเวือะ เลียก ปุย เซ ไมจ โรฮ เปอะ ดุฮ พา นึง ละ ซ แปน อื ควน เฆีญ โตะ รเวือะ เซ. เกือฮ ลั่ง ง่า รเนฮ. ไอฮ พา แนน ไมจ ป ไตญ ปุย นึง กอย ซี ฟะ, ซี ซูวัน, ไม่ ซี ซครัก ละ. เกือฮ โรฮ โม ชัง ป เกง ละ ยุฮ แตะ ลวตไล โอเอีฮ ดุฮ ลวตไล นึง พา เซ. เกือฮ ไก ลัก ปาวน ไม่ ควน โบลวง อื ปาวน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ควน โฮมวต ลัก เกือฮ รติต รเนือง ไม่ ปุ แตะ รวิต ฆรุง เซ, ไม่ ควน มั่ก ปุย พา เฆีญ อื เซ ไมจ เปอะ ยุฮ นึง มาื. ควน โบลวง ลัก เซ ยุฮ นึง ไร ซเงี. ");
INSERT INTO lcp_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ลวง ลั่ง ควง เซ มัฮ ติ รอย รเนฮ, เวือฮ รฮอน รเนฮ, ฮลาวง พอน รเนฮ. เฆีญ นึง พา แนน ไมจ. ควน โบลวง ลัก อื มัฮ ไร ซเงี. ");
INSERT INTO lcp_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","เครอึง ป ไจ ปุย ละ พากัง ระ เซ เตือง โอยจ อื, ฮอยจ ละ ลัก ป เกอึม ปุย ละ เคิง แตะ พากัง ระ, ไม่ ละ เคิง แตะ ฆรุง นึง รวิต อื เซ, ไมจ เปอะ ยุฮ นึง ไร ซเงี เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“ไมจ เปอะ ดวน โม อิซราเอน เกือฮ ตาว ลออยฮ กาวก ป ตึก นึง ไมจ แตะ ละ ซ บุ ปุย ลออยฮ โตะ ออม เซ นึง, เดอึม ออม เซ ซ ซเปีย ลอป ฆาื. ");
INSERT INTO lcp_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","ไมจ เปอะ เกือฮ อาโรน ไม่ กวน เฌือต อื โบลวง ออม เซ กไน ฮอง ซัมคัน ป อาวต ลั่กกา ฮอง ตึก นึง ซัมคัน แตะ นา ก ไก ฮิต ยุฮ พะจาว เซ, เกือฮ แลน แก ออม เซ ละ ซ เกือฮ อื รัง ลอป ซองนา พะจาว เน่อึม เมือ กปู ฮอยจ ละ เมือ กซะ อื. ไมจ เปอะ เกือฮ โม อิซราเอน ยุฮ ลอป ตอก เซ ฮอยจ ละ เฆียง เฮี โอ เญาะ ไก ลอยจ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ เกือฮ อาโรน ป มัฮ เอียกระ เปอะ เซ ไม่ กวน อื, ป มัฮ นาดั่ป, อาบี่ฮู, เอเลอาซา ไม่ อิทามา เซ, เกือฮ รกัฮ ฮา โม อิซราเอน ละ ซ แปน อื ซตุ รซอฮ ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","ฟวยจ เซ ไมจ เปอะ เกือฮ โม ชัง ยุฮ เครอึง โญต ซัมคัน ละ อาโรน ป มัฮ เอียกระ เปอะ เซ เกือฮ คึ ไม่ ไมจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ไมจ เปอะ อัฮ ละ โม ชัง ป เอีจ เกือฮ อาึ วิซา พันญา ไมจ ละ เซ, เกือฮ ยุฮ เครอึง ซัมคัน ละ ซ จาวป อาโรน อื เญือม ทไว อื ติ แตะ ละ อาึ นึง กัน แปน อื ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","เครอึง ซัมคัน ป ไมจ เปอะ เกือฮ ปุย ยุฮ เซ มัฮ โอเอีฮ โม เฮี. มัฮ ควน เลอึป รน่าวก, ลปิ เอโฟต, ลปิ ดา, ลปิ กไน ป ดุฮ ปุย ลวตไล อื, โคะ ไฆญ, ไม่ พา ปุก ญวย. โอเอีฮ โม เซ มัฮ เครอึง ซัมคัน ป ไมจ เปอะ ยุฮ ละ อาโรน ป มัฮ เอียกระ เปอะ ไม่ กวน อื, ละ ซ จาวป อื เญือม รซอฮ แตะ ละ อาึ นึง กัน แปน อื ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ไมจ เปอะ เกือฮ โม ชัง เซ โกว ไคร, กอย ซี ฟะ, ซี ซูวัน, ซี ซครัก, ไม่ พา แนน ไมจ ละ ยุฮ แตะ โอเอีฮ โม เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“เกือฮ โม ชัง เซ ไตญ ลปิ เอโฟต นึง ไคร, ไม่ กอย ซี ฟะ, ซี ซูวัน, ซี ซครัก, ไม่ พา แนน ไมจ ป ไตญ ปุย นึง กอย บิญ, เกือฮ ยุฮ ลวตไล อื ไมจๆ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","แคป นึง ซอังปา ลปิ เอโฟต เซ, ไมจ เปอะ เกือฮ ติต นึง เฆียง ลวง ก ล่าวง อื เตือง ลอา ปลัฮ อื เดอึม พา ลอา ปลัฮ เซ ซ เกียฮ รติต แปน ติ. ");
INSERT INTO lcp_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ไมจ เปอะ เกือฮ ชัง ไมจ ฟีมื ไตญ พา ปุก ญวย ติ, ละ ซ ปุก อื ราว ลปิ เอโฟต เซ เกือฮ แปน เครอึง ติ จุม. เกือฮ ยุฮ อื ไมจ ตอก ยุฮ แตะ ลปิ เอโฟต เซ. เกือฮ โรฮ ยุฮ อื นึง ไคร, ไม่ กอย ซี ฟะ, ซี ซูวัน, ซี ซครัก, ไม่ พา ไตญ ปุย นึง กอย บิญ. ");
INSERT INTO lcp_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","โกว โรฮ แกว พรุยฮ ละ ลอา แพน ละ ซ ไซฮ เปอะ อาึง มอยฮ กวน รเมะ อิซราเอน นึง เตือง กาว ลอา อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","แกว ติๆ แพน เซ ดุฮ มอยฮ อื นึง แลฮๆ ปุย, ดุฮ ตัม ไล อื ตัม ป เกิต รกา รเคะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","เกือฮ โม ชัง แกะ ซลัก ดุฮ มอยฮ โม กวน อิซราเอน นึง แกว ลอา แพน เซ. ฟวยจ เซ เกือฮ แม ยุฮ คอป อื นึง ไคร ป แตม ปุย ลวตไล โอเอีฮ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","แกว ลอา แพน เซ ไมจ เปอะ ติต อาึง นึง แคป ลปิ เอโฟต เซ ติ ก บลัฮ ติ แพน. แกว เซ ซ แปน ควน โตก พะจาว ละ โม อิซราเอน เตือง กาว ลอา เจอ อื. อาโรน ซ โรวก มอยฮ กวน อิซราเอน เซ ฮอยจ ซองนา พะจาว ละ ซ เกือฮ อื แปน ควน โตก พะจาว ละ. ");
INSERT INTO lcp_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","ไมจ เปอะ ยุฮ ควน มั่ก โม่ะ ไคร. ยุฮ โรฮ ไม่ โม่ะ ไคร ซโน ลอา เซน เกือฮ ตอก โม่ะ บวน โฮ. ฟวยจ เซ มั่ก อาึง นึง ควน มั่ก อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“ไมจ เปอะ ยุฮ ควน เลอึป รน่าวก ละ ซ แปน อื ควน ยุง เปอะ ป ปุก รพาวม พะจาว นึง. เกือฮ โม ชัง ป ไมจ ฟีมื ยุฮ ตอก ยุฮ แตะ เอโฟต โรฮ. เกือฮ ยุฮ อื นึง ไคร ไม่ กอย ซี ฟะ, ซี ซูวัน, ซี ซครัก ไม่ พา แนน ไมจ ป ไตญ ปุย นึง กอย บิญ. ");
INSERT INTO lcp_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ควน เลอึป รน่าวก เซ เกือฮ ยุฮ อื แปน ปาวน เลียม พัตโมน เกือฮ ฮนุป แฮนป ติ แตะ ลอา จัน. ลวง ลั่ง ลวง เงี่ยง อื มัฮ ติ เดือะ ตอก ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ไมจ เปอะ รปาึง แกว นึง ควน เลอึป รน่าวก เซ ปาวน เดี่จ. เดี่จ รกา อื มัฮ แกว ซครัก ไม่ แกว ซเงี ไม่ แกว ซงา. ");
INSERT INTO lcp_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","เดี่จ ลอา อื มัฮ แกว รัง ไม่ แกว มฮานิน ไม่ แกว ปิญ. ");
INSERT INTO lcp_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","เดี่จ ลอวย อื มัฮ แกว ซี โชมพู ไม่ แกว ตองเนะ ไม่ แกว ซี ซูวัน. ");
INSERT INTO lcp_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","เดี่จ ปาวน อื มัฮ แกว ซงา จัว ไม่ แกว พรุยฮ ไม่ แกว ซลอง ไง่ แมว. แกว เตือง โอยจ อื เซ ไมจ เปอะ รปาึง นึง ไคร ป แตม ปุย ลวตไล โอเอีฮ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","แกว กาว ลอา โนง เซ มัฮ รโตง กวน อิซราเอน เตือง กาว ลอา ปุย อื. แกว โครยญ โนง อื ไก มอยฮ เจอ โม อิซราเอน นึง ติ โนง ติ เจอ, เตือง กาว ลอา เจอ อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ไมจ แม เปอะ ยุฮ โม่ะ บวน นึง ไคร ซโน, ยุฮ ลอา เซน, ละ ซ ตาึก เปอะ ควน เลอึป รน่าวก เซ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ไมจ เปอะ ยุฮ ไคร แปน โวง อื ลอา โวง. ติต อาึง นึง โจง ลวง ก ล่าวง ควน เลอึป รน่าวก เซ เตือง ลอา โจง อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","โม่ะ ไคร เซ เกือฮ มั่ก ปุ แตะ ไม่ โวง ไคร ป อาวต นึง โจง ควน เลอึป รน่าวก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","เปือง โม่ะ ไคร ติ ก บลัฮ อื แม เกือฮ มั่ก ปุ แตะ ไม่ ควน มั่ก ป ติต นึง แคป ซอังปา ลปิ เอโฟต ลวง ลั่กกา อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ไมจ แม เปอะ ยุฮ ไคร แปน โวง อื ลอา โวง. ติต อาึง นึง โจง ลวง ก เซฮ ควน เลอึป รน่าวก เซ, เกือฮ อาวต ลวง กไน อื ก ติต อื ไม่ ลปิ เอโฟต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ยุฮ แม ไคร ลอา โวง. ติต อาึง นึง ฆรึม แคป ลปิ เอโฟต ลวง ลั่กกา อื. เกือฮ อาวต นึง โบ โฆลว ลปิ เอโฟต ลวง ราว พา ปุก ญวย ป ไตญ ปุย เกือฮ ไมจ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","ไมจ เปอะ แกน กอย ซี ฟะ เกือฮ แปน โม่ะ ละ ซ โจก เปอะ ควน เลอึป รน่าวก เซ เกือฮ ติต ไม่ ลปิ เอโฟต เซ, เดอึม ควน เลอึป รน่าวก เซ โอ ซ รกัฮ ฮา ลปิ เอโฟต เซ. เกือฮ ควน เลอึป รน่าวก เซ อาวต ราว พา ปุก ญวย เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“เญือม เลียก อาโรน นึง ฮอง ซัมคัน เซ โครยญ โฮน, อาโรน ซ จาวป ควน เลอึป รน่าวก ป มัฮ ควน ยุง อื ป ปุก รพาวม พะจาว. เญือม เซ มอยฮ กวน อิซราเอน ซ อาวต นึง รน่าวก อาโรน ซองนา พะจาว แปน ควน โตก พะจาว ละ โม อิซราเอน ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","ไมจ เปอะ ดุฮ อูริม ไม่ ทูมิม นึง กไน ควน เลอึป รน่าวก เซ. ป ลอา เจือ เซ ซ อาวต นึง จักพาวม อาโรน เญือม เลียก อื เคะ พะจาว. ควน ยุง อาโรน ป ปุก รพาวม พะจาว ละ โม อิซราเอน เซ, ซ อาวต นึง จักพาวม อาโรน ซองนา พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ไมจ แม เปอะ เกือฮ ปุย ไตญ ลปิ ดา นึง กอย ซี ฟะ เตือง บลัฮ อื ละ ซ จาวป อื ก พริ ลปิ เอโฟต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ไมจ เปอะ แปฮ โตะ โงก อื เกือฮ ปุก บั่กบ่วน ลปิ เซ. ฟวยจ เซ ยุฮ แม แคป โงก อื นึง พา ไตญ ปุย, เดอึม โอ ซ แฌฮ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","นึง ชวง ลปิ ดา เซ ไมจ เปอะ เกือฮ ปุย ตาึก ฮุป เปลิ ทัปทิม นึง. ไอฮ กอย ซี ฟะ ละ ไม่ กอย ซี ซูวัน ไม่ กอย ซี ซครัก, ดุฮ รวิต ชวง ลปิ เซ. ดุฮ แม โพรยญ ไคร นึง รตา ซน่ะ เปลิ ทัปทิม เซ โครยญ รตา อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ฮุป เปลิ ทัปทิม เซ, ไม่ โพรยญ ไคร เซ, ดุฮ รซอ นึง ชวง ลปิ ดา จาวป อาโรน เซ ปอ ไคว อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","อาโรน ซ จาวป ลปิ เซ เญือม รซอฮ แตะ ละ พะจาว. เญือม เลียก อื เคะ พะจาว กไน ฮอง ซัมคัน เซ ญุ่ก, เญือม โอก อื ญุ่ก, ปุย ซ ฮมอง ลอยฮ โพรยญ เซ. ดัฮ โอ ยุฮ อื ตอก เซ ซ ยุม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“ไมจ เปอะ แตม ไคร ซโน แปน แพน แตะ ติ แพน. ฟวยจ เซ ดุฮ รซอม เฮี นึง, ‘ป ซง่ะ ซงอม ละ พะจาว,’ อัฮ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ไมจ เปอะ แกน กอย ซี ฟะ เกือฮ แปน โม่ะ ละ ซ ปุก เปอะ แพน ไคร เซ นึง เกือฮ อาวต ราว โคะ ไฆญ เซ โตก ลวง ลั่กกา อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","แพน ไคร เซ ซ อาวต นึง แด่ อาโรน, นึง มัฮ อาโรน เซ ป จัมเปน รัป พิต ยุฮ ปุย เญือม พิต ตอก ทไว อื โอเอีฮ ละ พะจาว. อาโรน ซ ตาึก ลอป แพน ไคร เซ นึง แด่ แตะ, เดอึม พะจาว ซ ญอม รัป ป ทไว โม อิซราเอน เซ ฆาื. ");
INSERT INTO lcp_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“ไมจ เปอะ เกือฮ ปุย ไตญ ลปิ กไน นึง กอย ลินิน ไมจ ติ ปลัฮ, เกือฮ ดุฮ ลวตไล อื. ป มัฮ โคะ ไฆญ เซ ไอฮ โรฮ พา แนน ไมจ ป ไตญ ปุย นึง กอย ลินิน ละ. ป มัฮ พา ปุก ญวย นึง อื เซ ไมจ โรฮ เปอะ เกือฮ ปุย ไตญ ดุฮ ลวตไล นึง อื เกือฮ ไมจ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“ไมจ แม เปอะ เกือฮ ปุย ไตญ ลปิ, ไม่ พา ปุก ญวย, ไม่ วอม ละ ซ จาวป กวน อาโรน อื, เกือฮ ไมจ, โปง ไม่ โญตซัก อื. ");
INSERT INTO lcp_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ไมจ เปอะ เกือฮ อาโรน ป มัฮ เอียกระ เปอะ เซ ไม่ กวน อื จาวป เครอึง โญต ซัมคัน เซ. ฟวยจ เซ ไมจ เปอะ เรฮ ลออยฮ ซัมคัน นึง ไกญ อื, ไม่ ทไว เปอะ เกือฮ แปน ซตุ รซอฮ ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“ไมจ เปอะ ไตญ แว กไน ละ อาโรน ไม่ กวน อื นึง พา แนน ไมจ. แว เซ เกือฮ ดวต เน่อึม นึง ญวย อื ฮอยจ ละ เน่อึม รเวือง อื, เดอึม เนะซอัง อื โอ ซ โอก แปน ป พังไฮะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","เกือฮ อาโรน ไม่ กวน อื จาวป เญือม เลียก อื กไน พากัง ระ, ไม่ เญือม เลียก อื ซดิ ไม่ คัน ทไว ละ ซ รซอฮ แตะ นึง นาตี ซัมคัน เซ, เดอึม โอ ซ พังไฮะ ไม่ โอ อื ซ ยุม ฆาื. “ไมจ เปอะ เกือฮ อาโรน ไม่ จัตเจือ อื ยุฮ ลอป ตัม ไล เซ ฮอยจ ละ เฆียง เฮี โอ เญาะ ไก ลอยจ.” ");
INSERT INTO lcp_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“เฮี มัฮ ป ไมจ เปอะ ยุฮ ละ เญือะ อาโรน เซ, เกว ไม่ กัน ไมจ เปอะ ทไว เกือฮ เญือะ เซ ซง่ะ ไล ละ ซ แปน อื ซตุ รซอฮ ละ อาึ. ไมจ เปอะ ยุฮ ตอก เฮี, ไมจ เปอะ ไอฮ โมวก โปก นุม ติ ตัว ไม่ แกะ โปก ลอา ตัว ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ไอฮ โรฮ คโนมปัง ป โอ ไก เจือ, ป ซเบื่อก ปุย ไม่ ลออยฮ, ไม่ คโนมปัง แพน โอ ไก เจือ ป ตา ปุย ลออยฮ นึง. คโนม โม เซ ไมจ เปอะ ยุฮ นึง ญอต แปง ซาลี. ");
INSERT INTO lcp_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","คโนมปัง เซ อาึง รโจะ เอิน โตะ ควน อาึง ปุย อื, โรวก ทไว ดิ เญือม ทไว เปอะ โมวก โปก ไม่ แกะ โปก ลอา ตัว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ไมจ เปอะ เกือฮ อาโรน ไม่ กวน อื ฮอยจ นึง โตะ รเวือะ พากัง นา ก ฮอยจ ปุย เคะ พะจาว เซ. ฟวยจ เซ ไมจ เปอะ รไซจ เญือะ เซ นึง รอาวม เกือฮ ซง่ะ. ");
INSERT INTO lcp_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ฟวยจ เซ ไมจ เปอะ เกือฮ อาโรน จาวป เครอึง โญต ซัมคัน เซ, เกือฮ จาวป ลปิ กไน รกา, ฟวยจ เซ เกือฮ แม จาวป ลปิ ดา, ไม่ ลปิ เอโฟต ไม่ ควน เลอึป รน่าวก. เกือฮ แม ปุก ญวย แตะ นึง พา ปุก ญวย ป ไตญ โม ป ไมจ ฟีมื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","ไมจ เปอะ คัต โคะ ไฆญ นึง ไกญ อื ไม่ ปุก แม เปอะ แพน ไคร ซัมคัน เซ นึง โคะ ไฆญ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ไมจ เปอะ เรฮ ลออยฮ ซัมคัน เซ นึง ไกญ อื ละ ซ ดุฮ เปอะ เกือฮ แปน ซตุ. ");
INSERT INTO lcp_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","ไมจ โรฮ เปอะ เกือฮ โม กวน อาโรน เซ ฮอยจ เคะ เปอะ, เกือฮ จาวป ลปิ ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ฟวยจ เซ ไมจ เปอะ เกือฮ ปุก ญวย แตะ นึง พา ปุก ญวย เซ, เตือง อาโรน เตือง โม กวน อื เซ โรฮ, ไม่ จาวป เปอะ วอม ละ, เดอึม ซ เกียฮ แปน ซตุ รซอฮ ละ อาึ ฆาื อื. มัฮ ตอก เซ ตอก ดุฮ ปุย อาโรน ไม่ กวน อื เกือฮ แปน ซตุ อู. ");
INSERT INTO lcp_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ไมจ เปอะ โรวก โมวก โปก เซ ฮอยจ ลั่กกา พากัง นา ก ฮอยจ ปุย เคะ พะจาว เซ, เกือฮ อาโรน ไม่ กวน อื ย่อง เตะ แตะ ราว ไกญ โมวก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","ฟวยจ เซ มอก โมวก เซ ซองนา พะจาว นึง โตะ รเวือะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ไมจ เปอะ ชึต ด่อยฮ แตะ นึง ฮนัม โมวก เซ. ตา นึง โคะ ป ตอก โด่วง นึง โจง คัน ทไว เซ ง่อน. ฮนัม ป โฮฮ ลั่ง อื เซ โทก นึง ชวง คัน เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","เบือ ลออยฮ ป ติต นึง เครอึง กไน อื, ตอก เบือ ป ติต นึง โตม ไม่ เปละ เตือง ลอา อื ไม่ ลออยฮ ป ติต เปละ อื เซ, ไมจ เปอะ ตอง ทไว ราว คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","โตะ อื ไม่ ฮัก อื ไม่ เวียกตู อื ไมจ เปอะ ตอง ก พริ ไคะ, นึง มัฮ อื คอง ทไว ควน โตฮ ปุย ติ แตะ ฮา มั่ป. ");
INSERT INTO lcp_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ไมจ แม เปอะ โรวก แกะ โปก ติ ตัว, เกือฮ อาโรน ไม่ กวน อื ย่อง เตะ แตะ ราว ไกญ แกะ โปก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ฟวยจ เซ มอก แกะ เซ. ฮนัม อื ซพรอต รวิต คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ไมจ เปอะ ลัฮ แกะ เซ แปน ตอน แปน ตอน อื. เครอึง กไน ไม่ รเวือง อื ไมจ เปอะ รไซจ. ฟวยจ เซ ละ อาึง ราว โตะ อื ไม่ ไกญ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ฟวยจ เซ ไมจ เปอะ ตอง ทไว แกะ เซ เตือง ตัว อื ราว คัน ทไว เซ. เกือฮ แปน ป ตอง เปอะ ทไว ละ พะจาว เตือง ตัว อื, นึง มัฮ อื ป ซออย ฮงาื ละ พะจาว ไม่ ปุก เนอึม อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ไมจ แม เปอะ โรวก แกะ โปก ติ ตัว อื เซ, เกือฮ แม อาโรน ไม่ กวน อื ย่อง เตะ แตะ ราว ไกญ อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ฟวยจ เซ มอก แกะ เซ. ฮนัม แกะ เซ ไมจ เปอะ ตา นึง ฮละ ฮยวก ลวง ดอม อาโรน, ไม่ ฮละ ฮยวก ลวง ดอม กวน อื โครยญ โฆะ อื. ตา โรฮ นึง โฆวน เตะ โฆวน ชวง ลวง ดอม อื ง่อน. ฮนัม ป โฮฮ ลั่ง อื เซ ไมจ เปอะ ซพรอต รวิต คัน ทไว. ");
INSERT INTO lcp_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ฮนัม ป อาวต ราว คัน ทไว เซ ไม่ ลออยฮ ซัมคัน เซ, ไมจ เปอะ ซพรอต นึง อาโรน ไม่ นึง เครอึง ซัมคัน ป จาวป อื เซ. ไมจ โรฮ เปอะ ซพรอต นึง กวน อาโรน ไม่ เครอึง ซัมคัน จาวป อื เซ โรฮ. มัฮ ตอก เซ ตอก โฮลฮ อาโรน ไม่ โม กวน อื เซ แปน ปุย ซง่ะ ไล ละ พะจาว ฮอยจ ละ เครอึง จาวป อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“ไมจ เปอะ ตุย ลออยฮ แกะ โปก เซ, ตอก ลออยฮ นึง ซตะ อื, ลออยฮ ป ติต นึง เครอึง กไน อื, ลออยฮ ป ติต นึง โตม อื, เปละ อื เตือง ลอา อื ไม่ ลออยฮ ป ติต นึง อื เซ, ไม่ เนะ รเวือง ลวง ดอม อื นึง มัฮ อื แกะ โกว ปุย ละ ดุฮ แตะ ปุย เกือฮ แปน ซตุ. ");
INSERT INTO lcp_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ตุย โรฮ ไม่ คโนมปัง โม่ว ติ โม่ว, ไม่ คโนมปัง ป ซเบื่อก ปุย ไม่ ลออยฮ, ไม่ คโนมปัง แพน เฮรี ติ แพน, ป อาวต โตะ ควน อาึง ปุย คโนมปัง โอ ไก เจือ ป อาวต ซองนา พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","อาึง โอเอีฮ โม เซ นึง เตะ อาโรน, ไม่ นึง เตะ กวน อื. เกือฮ ซนาว อื ซองนา พะจาว. แปน ป กอยฮ อื ทไว ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ฟวยจ เซ ตุย แม โอเอีฮ โม เซ เน่อึม นึง เตะ อื เซ ตอง ดิ นึง คัน ทไว ไม่ โอเอีฮ ป ตอง ปุย ทไว เตือง ตัว อื เซ. เกือฮ แปน ป ตอง เปอะ ทไว ละ พะจาว. มัฮ ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก เนอึม รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“แกะ โปก ป โกว เปอะ ละ ดุฮ แตะ อาโรน แปน ซตุ เซ, ไมจ เปอะ ตุย เนะ รน่าวก อื. ฟวยจ เซ กอยฮ ทไว ละ พะจาว. เอีจ มัฮ เซ ป ลัง ละ ปะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","28","“เฆิม เฮี โฮว ไป นา เยอ เญือม ดุฮ ปุย ปุย เกือฮ แปน ซตุ อู, เนะ รน่าวก ไม่ เนะ รเวือง แกะ โปก ป โกว ปุย ละ ดุฮ อื ปุย เกือฮ แปน ซตุ เซ มัฮ ป ทไว ปุย ละ อาึ. เอีจ มัฮ ป ลอา เจือ เซ ป มัฮ รโตง อาโรน ไม่ โม กวน อื. มัฮ ป ลัง โฮลฮ ลอป อื เน่อึม นึง โม อิซราเอน โอ เญาะ ไก ลอยจ. มัฮ ป ทอเนาะ ปุย อาึง ละ โม ซตุ เน่อึม นึง ป ทไว อื ละ รโจะ แตะ รพาวม แตะ ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","เครอึง ซัมคัน จาวป อาโรน เซ ซ แปน โรฮ คอง กวน รเมะ อื ซึป ตอ ปุ แตะ ฮอยจ ละ จัตเจือ อื. เกือฮ จาวป อื เญือม เอีจ ดุฮ ปุย อื แปน ซตุ. ");
INSERT INTO lcp_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","เญือม แปน โรฮ กวน อาโรน ฮัวนา ซตุ รโตง เปือะ แตะ เซ ไม่ ฮอยจ อื นึง พากัง ระ ละ ซ รซอฮ อื ละ อาึ นึง นาตี ซัมคัน เซ, ไมจ เปอะ เกือฮ จาวป เครอึง ซัมคัน เซ อาแลฮ ซเงะ เตม. ");
INSERT INTO lcp_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“โตะ แกะ โปก ป โกว เปอะ ละ ดุฮ อื ปุย แปน ซตุ เซ, ไมจ เปอะ โตวง นึง นาตี ก ซง่ะ ไล อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","ฟวยจ เซ ไมจ เปอะ เกือฮ อาโรน ไม่ กวน อื เซ กุก โตะ เซ, เกือฮ โรฮ โซม อื ไม่ คโนมปัง ป อาวต โตะ ควน อาึง ปุย อื นึง โตะ รเวือะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","โตะ แกะ ไม่ คโนมปัง ป ทไว ซตุ ละ รไซจ อื พิต โฌวะ ยุฮ แตะ ละ ซ เกือฮ อื ติ แตะ ซง่ะ ซงอม ละ พะจาว เญือม ดุฮ ปุย อื แปน ซตุ เซ, โม ซตุ ลัง ปอน อื. ปุย ทัมมด่า ปังเมอ โอ อื ไมจ ปอน, นึง มัฮ อื ป โซม ป ปอน ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ดัฮ โตะ ไม่ คโนมปัง ป โกว ปุย เญือม ดุฮ แตะ ซตุ เซ โฮฮ ลั่ง ฮอยจ เมือ กซะ อื โฮ, ไมจ เปอะ ตอง โตะ งอ. ปุ เกือฮ ปุย โซม ปอน นึง มัฮ อื ป ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ป มัฮ อาโรน ไม่ กวน อื เซ ไมจ เปอะ ยุฮ ละ อื ตอก เอีจ อัฮ อาึ อื ละ เปอะ เซ. กัน ดุฮ เปอะ ปุย เกือฮ แปน ซตุ เซ ไมจ เปอะ โกว เวลา ละ อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","ไน อาแลฮ ซเงะ เซ ไมจ เปอะ ทไว โมวก โปก ติ ซเงะ ติ ตัว โครยญ ซเง่ะ, ละ ซ แปน อื ควน โตฮ อาึ ปุย ฮา มั่ป ยุฮ อื, ไม่ รไซจ เจอะ พิต โฌวะ ยุฮ อื. เญือม ยุฮ เปอะ ตอก เซ ซ แปน โรฮ ป ซง่ะ ไล ฆาื อื. ฟวยจ เซ ไมจ เปอะ เรฮ ลออยฮ กาวก นึง คัน ทไว ละ ซ เกือฮ อื แปน ป ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ไมจ เปอะ ยุฮ ตอก เซ เตือง อาแลฮ ซเงะ อื เซ, ละ ซ เกือฮ คัน ทไว เซ แปน ป ซัมคัน ไม่ แปน อื ป ซง่ะ ซงอม เนอึม ละ พะจาว. ฟวยจ เซ ดัฮ ไก โอเอีฮ ป ลอก คัน เซ เยอ, โอเอีฮ เซ ซ แปน โรฮ ป ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“คัก เฮี อื มัฮ ป ไมจ เปอะ ทไว นึง คัน เซ โครยญ ซเง่ะ. ป ไมจ เปอะ ทไว เซ มัฮ กวน แกะ ลอา ตัว ป ไก อาญุ อื ติ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ไมจ เปอะ ทไว เมือ กซะ อื ติ ตัว, เมือ กปู อื ติ ตัว. ");
INSERT INTO lcp_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","แกะ ป ทไว เปอะ เมือ กซะ อื เซ, ไมจ เปอะ บรุก ทไว ไม่ ญอต แปง ปาวน ลิต, ซเบื่อก ไม่ ลออยฮ กาวก ติ ลิต ไม่ บลัฮ. ทไว โรฮ ไม่ รอาวม อะงุน เมาะ ติ ลิต ไม่ บลัฮ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","แกะ ป ทไว เปอะ เมือ กปู อื เซ ไมจ เปอะ บรุก ทไว ดิ ไม่ ญอต แปง ซเบื่อก ไม่ ลออยฮ, ไม่ รอาวม อะงุน, ตอก ยุฮ เปอะ เมือ กซะ อื เซ โรฮ. ไมจ เปอะ ตอง ทไว ละ ซ แปน อื ป ซออย ฮงาื ละ พะจาว ไม่ ปุก เนอึม อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","กัน ทไว ตอก เซ มัฮ ป ไมจ โม อิซราเอน โครยญ เจน อื ทไว ละ อาึ ฮอยจ ละ เฆียง เฮี โอ เญาะ ไก ลอยจ. ไมจ อื โรวก ทไว นึง คัน ป อาวต โบ โตะ รเวือะ พากัง ระ เซ. พากัง ระ เซ มัฮ นา ก ฮอยจ อาึ เคะ โม เปะ ละ ซ อู แตะ ไม่ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","อาึ ซ ฮอยจ เคะ โม อิซราเอน นา เซ. นา เซ ซ แปน นาตี ซัมคัน ไม่ ซง่ะ ซงอม แตะ เบือ โญตซัก ไม่ รัง ซเปีย ยุฮ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","อาึ ซ เกือฮ พากัง ระ ไม่ คัน ทไว เซ แปน ป ซง่ะ ซงอม. ซ เกือฮ โรฮ อาโรน ไม่ กวน อื แปน ปุย ซง่ะ ไล ละ ซ แปน อื ซตุ รซอฮ ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","อาึ ซ อาวต ซน่ะ ลลาึง โม อิซราเอน. อาึ ซ แปน พะจาว ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","โม เซ ซ ยุง มัฮ อาึ พะจาว ยุฮ แตะ, ป นัม อื โอก ฮา เมือง อียิป โฮ. อาึ อาวต ซน่ะ ลลาึง อื, อาึ มัฮ เยโฮวา พะจาว ยุฮ อื.” ");
INSERT INTO lcp_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“ไมจ เปอะ ยุฮ คัน ตอง ปุย ทไว ป ซออย ฮงาื นึง ติ, ยุฮ นึง โคะ กทิน. ");
INSERT INTO lcp_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","ยุฮ เกือฮ ลั่ง ติ รเนฮ, เวือฮ ติ รเนฮ. เกือฮ เมาะ ปุ แตะ เตือง ปาวน ลวง อื. ลวง ฮลาวง อื ไอฮ ลอา รเนฮ. ป ตอก โด่วง นึง โจง คัน เซ ยุฮ นึง โคะ ติ โฆง ไม่ ป ยุฮ เปอะ คัน เซ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ไมจ เปอะ อัป คัน เซ นึง ไคร ซโน, เตือง ลวง ราว อื, ไม่ ลวง เฆียง อื โครยญ ลวง. อัป โรฮ ไม่ ป ตอก โด่วง นึง โจง คัน เซ. ยุฮ โรฮ คอป อื นึง ไคร ป ไก ลวตไล นึง รวิต อื. ");
INSERT INTO lcp_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","ไมจ เปอะ โล ไคร เกือฮ แปน โวง แตะ ลอา โวง, ติต อาึง นึง ฆรึม คอป อื เซ ติ ก บลัฮ ติ โวง ซื นา ปุ แตะ. มัฮ ละ ซ ซลอ ปุย โคะ ลกลอม ละ ซ กลอม แตะ คัน เซ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","โคะ ลกลอม อื เซ ยุฮ นึง โคะ กทิน, อัป โรฮ นึง ไคร. ");
INSERT INTO lcp_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","คัน เซ ไมจ เปอะ โบลวง อาึง ก พริ พากัง รฆุน ฮอง นา ก อาวต ฮิต ลปุง ซันญา ยุฮ ฮุ เซ, ไม่ รเดือป ฮิต ซัมคัน นึง อื. เอีจ มัฮ นา เซ นา ก ซ เปลีฮ อาึ ติ แตะ ละ ปะ อา. ");
INSERT INTO lcp_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“เญือม เลียก อาโรน ละ ซ เพรียง แตะ ออม เซ โครยญ ซะ อา, เกือฮ โรฮ ตอง ทไว ป ซออย ฮงาื ไม่ อื ราว คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","เญือม เลียก เตี อาโรน ออม เซ เมือ กปู อื, ไมจ โรฮ อื ตอง ป ซออย ฮงาื ไม่ ราว คัน เซ ซองนา พะจาว. ไมจ เปอะ ยุฮ ลอป ตอก เซ โครยญ เจน เปอะ ฮอยจ เฆียง เฮี โอ เญาะ ไก ลอยจ. ");
INSERT INTO lcp_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","นึง คัน เซ ปุ ทไว โอเอีฮ ไฮญ นึง เฟือฮ เอิน. ปัง มัฮ ป ซออย ฮงาื ไฮญ ป โอ อาึ ดวน เปอะ โรวก ญุ่ก, ปัง มัฮ ซัตซิง ตอง เปอะ ญุ่ก, แปง ตอง เปอะ ญุ่ก, รอาวม อะงุน โทก เปอะ นึง ญุ่ก, ปุ ทไว นึง อื ติ ตื เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","อาโรน ไมจ อื โรวก ฮนัม ซัตซิง ป โกว อื ละ รไซจ พิต โฌวะ ยุฮ ปุย เซ, ไม่ ตา อื นึง โด่วง คัน เซ ติ เนอึม ติ โฮน, ละ ซ เกือฮ อื คัน เซ แปน ป ซง่ะ ไล. โม อิซราเอน โครยญ เจน ปุย ไมจ อื ยุฮ ลอป ตอก เซ. คัน เซ ซ แปน ลอป ป ซง่ะ ซงอม ละ พะจาว ฆาื อื.” ");
INSERT INTO lcp_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","พะจาว อัฮ อื ละ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“เญือม โจต เปอะ เซน โม อิซราเอน เนอ, ไมจ เปอะ เกือฮ โม อิซราเอน ทไว มาื ละ พะจาว ละ ซ โตฮ อื จีวิต แตะ นึง, เดอึม กัน ไลจ กัน โลม โอ ซ เกิต ละ โม เซ เญือม เมีญ เปอะ เมาะ ไก เซน อื. ");
INSERT INTO lcp_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ปุย เมาะ ป เอีจ โจต เซน แตะ ไมจ อื ทไว มาื ละ อาึ ตัม เฮี. มัฮ มาื บลัฮ เชเคน ตัม เชเคน ป โกว ปุย นึง พากัง ระ เซ. (ติ เชเคน เซ ปุก ง่า เกรา.) ");
INSERT INTO lcp_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","เมาะ ป เอีจ โจต เซน แตะ มัฮ ป เอีจ ไก อาญุ ง่า เนอึม ฮาวก ก ล่าวง, ไมจ อื โรวก ทไว มาื ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","เญือม โรวก เปอะ มาื ละ ซ ทไว แตะ เกือฮ แปน ควน โตฮ เปอะ จีวิต แตะ นึง เซ, โม ป กอย ไมจ โตว อื ทไว โฮฮ ฮา บลัฮ เชเคน เซ, โม ป ตุก ไมจ โตว อื ทไว เญี่ยะ ฮา บลัฮ เชเคน เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ไมจ เปอะ เกป มาื เซ เน่อึม นึง โม อิซราเอน, เกือฮ แปน มาื ไจ เปอะ นึง พากัง ระ เซ. ซ แปน โรฮ ควน โตก พะจาว ละ โม อิซราเอน, ไม่ แปน โรฮ อื ควน โตฮ จีวิต โม เปะ โรฮ.” ");
INSERT INTO lcp_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","พะจาว อัฮ อื ละ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ไมจ เปอะ ยุฮ อาง ระ ไม่ ชวง อื, ยุฮ นึง ไร ซเงี. อาง เซ มัฮ ละ ซ อาึง ปุย รอาวม นึง ละ รไซจ โม ซตุ ติ แตะ นึง. โบลวง อาึง ซน่ะ พากัง ระ ไม่ คัน ทไว เซ. ฟวยจ เซ เชียต ดุฮ รอาวม นึง. ");
INSERT INTO lcp_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ไมจ เปอะ เกือฮ อาโรน ไม่ กวน อื โกว รอาวม เซ ละ รไซจ อื เตะ ชวง แตะ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","เญือม ซ เลียก อื ซดิ ไม่ คัน ทไว ละ ตอง แตะ ทไว โอเอีฮ ละ พะจาว, ไม่ เญือม เลียก ยุฮ อื กัน ละ พะจาว นึง กไน พากัง ระ เซ, ไมจ อื รไซจ ติ แตะ นึง รอาวม เซ ฮัม, เดอึม โอ ซ ยุม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","ไมจ เปอะ เกือฮ อาโรน ยุฮ ตัม ไล เซ, เตือง โกะ อื เตือง กวน อื, ฮอยจ ละ จัตเจือ อื โครยญ เจน อื, เดอึม โอ ซ ยุม ฆาื อื.” ");
INSERT INTO lcp_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","โนก ฮา เซ พะจาว อัฮ แม อื ละ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ไมจ เปอะ โรวก ป ซออย ฮงาื ป ตึก นึง ไมจ แตะ ตัม เฮี, มัฮ โมตญอป แลฮ กิโล, รไปฮ โฮวง ลอวย กิโล ไม่ บลัฮ, จักไค ซออย ฮงาื ลอวย กิโล. ");
INSERT INTO lcp_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","โนก ฮา เซ มัฮ แม การะบุ่น แลฮ กิโล, ตัม กิโล ป โกว ปุย นึง พากัง ระ. มัฮ แม ลออยฮ กาวก ปาวน ลิต. ");
INSERT INTO lcp_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","โอเอีฮ โม เซ เตือง โอยจ อื ไมจ เปอะ เกือฮ ปุย ยุฮ ลออยฮ ซัมคัน นึง ตัม ไล กอ ยุฮ โม ป ยุฮ ลออยฮ ซออย ฮงาื อื โฮ. ลออยฮ เซ ซ แปน ลออยฮ ซัมคัน ป โกว ปุย นึง กัน พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ฟวยจ เซ ไมจ เปอะ เรฮ ลออยฮ ซัมคัน เซ นึง พากัง ระ, ไม่ นึง ฮิต ลปุง ซันญา ยุฮ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","เรฮ โรฮ นึง โตะ อาึง ปุย คโนมปัง, ไม่ เครอึง ไฮญ ป โกว ปุย ละ กัน เซ. เรฮ โรฮ นึง ออม ฮลาวง เซ ไม่ เครอึง โกว ปุย ละ ออม เซ, ไม่ นึง คัน ทไว ปุย ป ซออย ฮงาื. ");
INSERT INTO lcp_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ไมจ โรฮ เปอะ เรฮ นึง คัน ทไว ไม่ เครอึง ป โกว ปุย ละ รซอฮ แตะ นึง คัน เซ. เรฮ โรฮ นึง อาง ระ เซ ไม่ ชวง อื. ");
INSERT INTO lcp_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","โอเอีฮ โม เซ ไมจ เปอะ ยุฮ เกือฮ แปน ป ซง่ะ ตัม ไล อื โครยญ เจือ, เดอึม ซ แปน ป ซัมคัน เนอึม ฆาื อื. ออฮ เอีฮ ญุ่ก, ป ลอก ป ไปญ โอเอีฮ โม เซ, โอเอีฮ เซ ซ แปน โรฮ ป ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“ไมจ เปอะ เรฮ ลออยฮ ซัมคัน เซ นึง อาโรน ไม่ กวน อื, ละ ซ ทไว เปอะ แปน ซตุ รซอฮ ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, ‘ลออยฮ เฮี มัฮ ลออยฮ ซัมคัน ยุฮ พะจาว. โม เปะ ไมจ เปอะ เกือฮ แปน ป ซัมคัน ละ แตะ โครยญ เจน เปอะ ฮอยจ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ไมจ เปอะ โตว โกว ลออยฮ เซ ละ เรฮ แตะ นึง ปุย ทัมมด่า. ไมจ เปอะ โตว โรฮ ยุฮ ลออยฮ ละ ซ โกว โกะ เปอะ ตัม ไล ยุฮ ปุย ลออยฮ ซัมคัน เฮี, นึง มัฮ ลออยฮ เฮี ลออยฮ ซัมคัน ยุฮ พะจาว. ไมจ เนอึม เปอะ เมีญ มัฮ ป ซัมคัน ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ดัฮ ไก ป ยุฮ ลออยฮ ละ โกว โกะ แตะ ตัม ไล ยุฮ ปุย ลออยฮ ซัมคัน เฮี, ไม่ ป โกว ลออยฮ ซัมคัน เซ ละ เรฮ แตะ นึง ปุย ทัมมด่า เยอ, ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ, ปุ เญือะ เมีญ มัฮ ปุย ไน โม อิซราเอน’ ” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, “ไมจ เปอะ เกือฮ ปุย ยุฮ ป ซออย ฮงาื ละ ซ ตอง เปอะ ทไว ละ อาึ. เกือฮ ยุฮ อื นึง โอเอีฮ โม เฮี. มัฮ โมตญอป, ชะโมต, ไม่ มฮาฮิง. เกือฮ รไม่ อื ไม่ กัมยัน ซโน ป โอ ดิ รไม่ ไม่ โอเอีฮ ไฮญ เฟือฮ เอิน. โอเอีฮ โม เซ ไอฮ ละ อื บริญ เมาะ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","ไมจ เปอะ ยุฮ ป ซออย ฮงาื นึง ตัม ไล กอ ยุฮ ปุย อื. ดุฮ แม กิฮ นึง เดอึม ซ แปน ป ซง่ะ ไล ไม่ แปน อื ป ซัมคัน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ไมจ เปอะ รยิฮ ไม่ โตฮ เปอะ เกือฮ โพง ง่อน. ฟวยจ เซ ละ อาึง ลั่กกา ฮิต ลปุง พะจาว ป อาวต กไน พากัง ระ นา ก เปลีฮ อาึ ติ แตะ ละ ปะ เซ. ป ซออย ฮงาื เซ ไมจ เปอะ เมีญ มัฮ ป ซัมคัน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ปุ เกือฮ ปุย ยุฮ ป ซออย ฮงาื ละ โกว โกะ แตะ ตัม ไล ยุฮ ปุย อื ละ อาึ เฮี. ไมจ เปอะ เมีญ เกือฮ แปน ป ซัมคัน ละ แตะ, นึง มัฮ อื ป ยุฮ ปุย ทไว ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ดัฮ ไก ป ยุฮ ป ซออย ฮงาื ละ โกว โกะ แตะ ตัม ไล เซ, ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ. ปุ เญือะ เมีญ มัฮ ปุย ไน โม อิซราเอน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ฟวยจ เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“อาึ เอีจ เลือก เบ่ซาเลน ป มัฮ เจอ ยูด่า เซ ละ ซ ยุฮ อื กัน ละ แตะ. เบ่ซาเลน เซ มัฮ กวน อุรี. ตะ อื มัฮ เฮอ. ");
INSERT INTO lcp_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","อาึ เอีจ เกือฮ ลปุ พะจาว นัม รพาวม อื เดอึม ซ เกียฮ ยุฮ เครอึง โอเอีฮ ละ อาึ. ซ ไก พันญา พันญวง, ซ เกง นึง เกียฮ แตม แตะ โอเอีฮ. ");
INSERT INTO lcp_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ซ เกียฮ แง่ฮ ฆัว เครอึง แตม แตะ นึง ไคร นึง มาื ไม่ ไร ซเงี. ");
INSERT INTO lcp_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","ซ เกียฮ เกลียง แกว ไมจ ไม่ แตม อื ก อาวต อื. ซ เกียฮ เพรียง โคะ ไม่ แปน อื จังเคือง นึง โอเอีฮ ไฮญ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","“โนก ฮา ปุย เซ อาึ เอีจ เลือก โรฮ โอโฮลีอัป กวน อาฮิซะมัก ป มัฮ เจอ ด่าน เซ ละ ซ แปน อื ป เรอึม อื. อาึ เอีจ เกือฮ โม จังเคือง ไก ตอก เกียฮ กัน ตอก เฮี โครยญ โฆะ ปุย. เกือฮ เยอะ เกียฮ ยุฮ โอเอีฮ ตัม ป ดวน อาึ เปอะ ยุฮ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","ซ เกียฮ ยุฮ พากัง ระ นา ก โฮลฮ ปุย ฮอยจ เคะ อาึ, ซ เกียฮ ยุฮ ฮิต ลปุง ซันญา ป ไก รเดือป ซัมคัน นึง. ซ เกียฮ ยุฮ โอเอีฮ ป ลัง อาวต กไน พากัง ระ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ป มัฮ โตะ อาวต คโนมปัง ไม่ กลอง เชือม อาวต นึง อื, ไม่ ออม ไคร ไม่ ควน เพรียง ปุย ออม เซ, ไม่ คัน ทไว ปุย ป ซออย ฮงาื ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","มัฮ โรฮ คัน ระ นา ก ตอง ปุย ทไว ซัตซิง, ไม่ เครอึง โกว ปุย นึง คัน เซ ไม่ อาง ระ เตือง ชวง อื. ");
INSERT INTO lcp_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ซ เกียฮ เพรียง โรฮ เครอึง เซอึก ไตญ ปุย ละ ซตุ เตือง เครอึง อาโรน ไม่ เครอึง ไอฮ กวน อาโรน เญือม ยุฮ อื กัน ซตุ. ");
INSERT INTO lcp_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ซ เพรียง โรฮ ลออยฮ ซัมคัน, ไม่ ป ซออย ฮงาื ละ ตอง ปุย อื นึง พากัง ซง่ะ ซงอม ยุฮ พะจาว. ไมจ อื ยุฮ ตัม ปิม เปลีฮ อาึ ละ เปอะ โครยญ เจือ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","เญือม เซ พะจาว ลปุง แม ไม่ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","เกือฮ อื ซตอก โม อิซราเอน ตอก เฮี, “ไมจ เปอะ ทื ซเงะ ลโล่ะ ยุฮ อาึ โครยญ ซเงะ ลโล่ะ. ซเงะ ลโล่ะ เซ ซ มัฮ ป ซัมคัน ซน่ะ อาึ ไม่ โม เปะ ฮอยจ ละ เจน โคระ โอ เญาะ ไก ลอยจ. โม เปะ ซ ยุง เปอะ มัฮ อาึ พะจาว ฆาื อื. มัฮ ป เกือฮ โม เปะ ตัง โน่ง ฮา ปุย ไฮญ. ");
INSERT INTO lcp_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ไมจ เปอะ ทื ซเงะ ลโล่ะ โม เซ นึง มัฮ อื ซเงะ ซัมคัน ละ โม เปะ. ดัฮ ไก ป ยุฮ กัน ไน ซเงะ ลโล่ะ เซ ไมจ ปุย ยุฮ ยุม ไม่ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ไมจ เปอะ ยุฮ กัน แตะ ไน แลฮ ซเงะ. ซเงะ อาแลฮ นึง อื มัฮ ซเงะ ลโล่ะ. มัฮ ซเงะ ซัมคัน ละ อาึ. ป ยุฮ กัน ไน ซเงะ เซ ไมจ ปุย ยุฮ ยุม ไม่. ");
INSERT INTO lcp_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","17","โม อิซราเอน ไมจ อื ทื ซเงะ ลโล่ะ เซ แปน ควน ไตม อื ลปุง ซันญา อาึ ไม่ แตะ. ไมจ อื ทื ฮอยจ ละ เจน โคระ เฆียง เฮี โอ เญาะ ไก ลอยจ. อาึ ป มัฮ เยโฮวา เอีจ ยุฮ ปลัฮเตะ ไม่ ปลัฮ มะลอง ไน แลฮ ซเงะ. ซเงะ อาแลฮ นึง อื อาึ ลโล่ะ โอะ, เญือะ ยุฮ โตว กัน นึง. เซ ป ไมจ โม เปะ ทื ซเงะ เซ ฆาื อื แปน ป ซัมคัน ซน่ะ อาึ ไม่ โม เปะ ป มัฮ อิซราเอน เนอ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","พะจาว เญือม เอีจ ฟวยจ ลปุง อื ไม่ ไอ โมเซ นึง บลาวง ซีไน เซ, เกือฮ แพน ซโมะ ละ อื ลอา แพน. แพน ซโมะ เซ ไก ลปุง ซตอก พะจาว อาึง นึง ละ ปุย. มัฮ ป ไซฮ พะจาว อาึง นึง ด่อยฮ โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ปุย โฮวน เซ เญือม ยุ อื เลี่ญ ซ เอีญ ไอ โมเซ เน่อึม นึง ไกญ บลาวง เซ โฮว เคะ อาโรน ฆาื อื. อัฮ เฮี, “ไมจ ปะ ยุฮ แปฮ ฮุป พะจาว ละ เอะ ติ ลอา ละ ซ เกียฮ นัม อื คระ โครง ละ เอะ. ป มัฮ ไอ โมเซ ป นัม เอะ โอก ฮา เมือง อียิป เซ เอีจ ไฆร. ตึน ซ มัฮ ไก ตอก มัฮ อื ติ เจือ. ปเลี่ย เฮี เอะ ยุง โตว ก อาวต อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","อาโรน อัฮ เฮี, “เอีญ ปอยจ ตอฮู ไคร ยุฮ ปรโปวน เญือะ เปอะ เตือง ไพ เตือง มัน, เตือง ตอฮู ยุฮ กวน เครีฮ กวน เบลีย เปอะ ตาว ฮอยจ ละ อาึ เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","โม เซ ปอยจ เนอึม อื ตาว อื ละ อาโรน. ");
INSERT INTO lcp_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","อาโรน โล ไคร เซ นึง ปิม, ยุฮ ฮุป กวน โมวก นึง อื. เญือม เซ ปุย โฮวน เซ อัฮ เฮี, “เออ โม อิซราเอน, เฮี ป มัฮ พะจาว ป ตาว โม เปะ โอก ฮา เมือง อียิป เปอ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","เญือม ยุ อาโรน รพาวม ปุย โฮวน เซ ยุฮ คัน ลั่กกา ฮุป เซ ฆาื อื. ครอฮ อื ละ ปุย ตอก เฮี, “ซง่าวป ซ ไก กัน ชลอง ระ นึง ละ พะจาว. ไมจ เอะ เลียง ปุ แตะ นึง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","ปุย โฮวน เซ งาวป โกฮ ฆาื อื. มอก ตอง ทไว โอเอีฮ ละ ฮุป เซ. ทไว โรฮ โอเอีฮ ละ เปลีฮ แตะ รโจะ ดิ แตะ รพาวม แตะ ไม่ อื. เญื่อฮ งาวม ละ ซ กุก แตะ โตะ ญุ แตะ ไปล ไม่ ปุ แตะ. ฟวยจ เซ โกฮ ละ ซ รง่ะ แตะ ไม่ ปุ แตะ นึง ไลลวง โอ ไมจ. ");
INSERT INTO lcp_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ซไจ เลีฮ ละ. โม อิซราเอน ป ตาว ปะ โอก ฮา เมือง อียิป เซ เอีจ ยุฮ ป ฆอก ป เบร. ");
INSERT INTO lcp_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","เกียฮ ไกลจ ลัมเลือ โน่ง ลเตือฮ ติ แตะ ฮา คระ โครง ดวน อาึ อื โฮว เมอ? เอีจ ยุฮ ฮุป กวน โมวก นึง ไคร. ไว อื ไม่ ทไว อื โอเอีฮ ละ อื. อัฮ เฮี ไม่ อื, ‘เออ โม อิซราเอน, เฮี ป มัฮ พะจาว ป ตาว โม เปะ โอก ฮา เมือง อียิป เปอ,’ อัฮ อื ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“อาึ เอีจ ยุ อุ เมาะ ลึง ลัมเลือ รพาวม โม เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ปุ เญือะ คัต อาึ อื. อาึ ซ ฮาวก รพาวม เนอึม ฮาวก รพาวม แนม ฆาื ละ โม เฮี. ซ ยุฮ ยุม ไม่ แกล เอิน. อาึ ปังเมอ ซ เกือฮ ปะ ไม่ จัตเจือ เปอะ แปน เมือง ระ เมือง คาว ตัง โม เฮี,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","เญือม เซ ไอ โมเซ ปัว อื นึง เยโฮวา ป มัฮ พะจาว ยุฮ แตะ ตอก เฮี, “โอ พะจาว, เมอยุ เกือฮ เปอะ ติ แตะ ฮาวก รพาวม เนอึม ฮาวก รพาวม แนม ละ ปุย ไน เปอะ เฮี? ปะ เอีจ ตาว เปอะ โม เฮี โอก ฮา เมือง อียิป เบือ อัมนัต ระ รที เรียง ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ดัฮ เปอะ ยุฮ ตอก เซ โม อียิป ตึน ซ เพียก แฮม ปะ ฆาื อื. ตึน ซ อัฮ ปะ รชุยจ โม เฮี ไลจ. ซ อัฮ ปะ เคียต ตาว ปุย โม เฮี โอก ละ ซ ยุฮ เปอะ ยุม ไม่ อื นึง บลาวง, นึง ซ เกือฮ เปอะ ชิป ฮา ปลัฮเตะ เตือง โอยจ อื. แจง ซ เพียก แฮม ปะ ฆาื อื ตอก เซ. โอ พะจาว, ปัว ปะ โอ เญือะ ฮาวก รพาวม ละ. ปัว เปอะ เปียน รพาวม แตะ โอ เญือะ ยุฮ ป โซะ ละ ปุย โม เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ปัว เปอะ โตก ละ อัปราฮัม ไม่ ยิซฮัก ไม่ อิซราเอน ป มัฮ กวนไจ ยุฮ เปอะ. ปะ เอีจ ซันญา เปอะ อาึง ละ อื ไม่ ลัปลอง เปอะ นึง มอยฮ โกะ เปอะ, เอีจ อัฮ เปอะ ติ แตะ ซ เกือฮ จัตเจือ อื โฮวน ตอก ซโมยญ นึง มะลอง. เอีจ อัฮ เปอะ ติ แตะ ซ เกือฮ เมือง เซ เตือง โอยจ อื ละ จัตเจือ อื. เอีจ ซันญา เปอะ ซ เกือฮ แตะ แปน คอง จัตเจือ อื เซ ฮอยจ เฆียง เฮี โอ เญือะ ไก ลอยจ. ปัว เปอะ โตก ละ ลปุง ซันญา เปอะ เซ,” อัฮ เซ ละ อื ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","เญือม เซ พะจาว เปียน รพาวม แตะ. ยุฮ เนอึม โตว ยุม ไม่ ปุย โม เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ไอ โมเซ เลีฮ เน่อึม นึง บลาวง เซ. ไปญ ปุ เลีฮ ซโมะ ลอา แพน ป ไซฮ พะจาว ลปุง ซตอก ยุฮ แตะ นึง เตือง ลอา ก บลัฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ซโมะ เซ มัฮ ป ยุฮ พะจาว. ตัว นังซื นึง อื มัฮ ป ไซฮ พะจาว นึง ด่อยฮ แตะ, ตอก เอิน ป ปอยจ ปุย นึง รปอยจ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","เญือม ฮมอง โยชูวา เดื่อต ปุย โฮวน เนอึม ไอฮ พาวม แตะ, อัฮ เฮี ฆาื อื ละ ไอ โมเซ, “ง่อต เมิฮ. มัฮ เซียง รุป ปุย ปุ แตะ นึง ไคะ เซ ยุ่ง,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ไอ โมเซ โลยฮ อื, “มัฮ โตว รโอง ปุย นึง เป แตะ. มัฮ โตว โรฮ ครวก อื นึง ไป แตะ. มัฮ เซียง เชีย ปุย ป ฮมอง อาึ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","เญือม เอีจ ฮอยจ อื ซดิ อี ไอ โมเซ ชวน ฮุป โมวก เซ ไม่ ยุ อื ฟอน เจิง ปุย. ฮาวก รพาวม เนอึม ฮาวก รพาวม แนม ฆาื อื ปอ เอิน โคะ เตือน อื ซโมะ ลอา แพน ป ไปญ แตะ เซ. ม่ะ บลวย โอยจ เอิน, อาวต เฮีย นึง ชวง บลาวง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","เญือม เซ ไอ โมเซ โรวก ตอง ฮุป โมวก เซ นึง งอ. ฟวยจ เซ ตุฮ อื เกือฮ บลวย ตอก รกาื โฮ ครวย อื โตะ รอาวม. คนัป โม อิซราเอน เซ ญุ อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ไอ โมเซ ไฮมญ อื นึง อาโรน ตอก เฮี, “มัฮ เมอ ป ยุฮ ปุย โฮวน เฮี ละ เปอะ? เกียฮ เกือฮ โน่ง เปอะ ปุย ยุฮ มั่ป ฆอก ลัมเลือ ตอก เฮี เมอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","อาโรน โลยฮ อื ตอก เฮี, “ปุ รอก พาวม ฆาื นึง อาึ โอะ. ปะ เอีจ ยุง เปอะ ไอฮ ตอก มัฮ ปุย โม เฮี. ตึน มัฮ ปุย ฆวต ยุฮ แนฮ ป โอ ปุก. ");
INSERT INTO lcp_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","เอีจ อัฮ อื ละ อาึ ตอก เฮี, ยุฮ แปฮ ฮุป พะจาว ละ เอะ ติ ลอา ละ ซ เกือฮ แปน ป นัม คระ นัม โครง ละ เอะ. ป มัฮ ไอ โมเซ ป นัม เอะ โอก ฮา เมือง อียิป เซ เอีจ ไฆร. เอะ ยุง โตว ก อาวต อื, อัฮ เซ เนิ. ");
INSERT INTO lcp_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","อาึ ดวน เนอะ ปอยจ เครอึง ไคร ยุฮ แตะ ฆาื อื เกือฮ โรวก อื ละ แตะ. โรวก เนอึม อื. อาึ น่าึก เกอะ โตะ งอ. ฮุป กวน โมวก เฮี โอก เอิน ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","กา เซ ปุย โฮวน เซ เอีจ พลวย ติ แตะ ยุฮ กัน ไอฮ พาวม แตะ เบือ รซอม อาโรน. กัน เซ มัฮ โรฮ ป ฟวยจ พาวม โม ป เกละยุ โม อิซราเอน นึง, นึง ซ โฮลฮ แตะ เพียก แฮม อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","เญือม ยุง ไอ โมเซ ไล เซ เยอ, ชุง ฆาื อื โบ คระ เลียก ปุย นึง ไคะ เซ. อัฮ อื ละ ปุย ตอก เฮี, “มัฮ ปุย ป มัฮ บลัฮ ลั่ก พะจาว? เอีญ รโจะ นา เฮี,” อัฮ อื ตอก เซ เรียง. โม ป มัฮ เจอ เลวี เยอ เอีญ รโจะ ไม่ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ไอ โมเซ อัฮ เฮี ละ อื, “เยโฮวา พะจาว ทื โม อิซราเอน อัฮ เฮี ละ เปอะ, ตุย โรวก วิจ ยุฮ เปอะ โครยญ โฆะ เปอะ. โฮว ซาวป ยุฮ ยุม ไม่ โม เอียกปุ เปอะ ไม่ ปุโฮมว เปอะ ไม่ ปุ ซดิ เญือะ เปอะ, เน่อึม คระ เลียก ปุย นึง ไคะ ลั่กเอีฮ ฮอยจ ละ คระ โอก ปุย ลั่กเติต,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","โม ป มัฮ เจอ เลวี เซ ยุฮ เนอึม อื ตัม ดวน ไอ โมเซ แตะ ยุฮ เซ. ซเงะ เซ โม เซ ยุม ด่าว ลอวย เปือน ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ไอ โมเซ อัฮ เฮี, “ซเงะ เนาะ เฮี โม เปะ เอีจ เกือฮ เปอะ ติ แตะ แปน ปุย ตัง โน่ง ละ ซ โฮลฮ แตะ รซอฮ ละ พะจาว, นึง โอ เปอะ ฮลักกอ กวน เปอะ ไม่ เอียกปุ เปอะ. มัฮ เซ ป ซ โฮลฮ พะจาว ปิฮ มุ่น ละ เปอะ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ปวยฮ พริ เซ ไอ โมเซ อัฮ เฮี ละ ปุย โฮวน เซ, “โม เปะ เอีจ มัฮ ยุฮ เปอะ มั่ป ฆอก ลัมเลือ เอิน. ปเลี่ย เฮี อาึ ซ ฮาวก แม เคะ พะจาว นึง บลาวง. เมอ เตือง อื พะจาว ซ ยวก ลั่ง มั่ป กัฮ ลั่ง ตุต ยุฮ เปอะ ยุ่ง,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","เญือม เซ ไอ โมเซ ฮาวก แม เคะ พะจาว. อัฮ อื ตอก เฮี, “โอ พะจาว, ปุย โม เฮี เอีจ ยุฮ มั่ป ฆอก ลัมเลือ, เอีจ ยุฮ ฮุป พะจาว ละ โกะ แตะ นึง ไคร. ");
INSERT INTO lcp_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ปะ ปังเมอ เกียฮ ยวก ลั่ง เปอะ มั่ป กัฮ ลั่ง เปอะ ตุต ยุฮ อื. ดัฮ เปอะ โอ ซ ยวก ละ อื โฮ, อาึ ปัว เปอะ ตุเตือะ ลูลา มอยฮ อาึ โอก ฮา นังซื ไซฮ เปอะ อาึง มอยฮ ปุย นึง,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","พะจาว อัฮ เฮี ละ ไอ โมเซ, “มัฮ โม ป ยุฮ ป พิต ละ อาึ เซ, ป ซ ตุเตือะ ลูลา อาึ มอยฮ อื โอก ฮา นังซื ยุฮ ฮุ. ");
INSERT INTO lcp_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","ปเลี่ย เฮี ปะ ไมจ เปอะ โฮว นัม ปุย โม เฮี ฮอยจ ละ เมือง ป เอีจ รโฮงะ อาึ ละ เปอะ เซ. อาึ ซ เกือฮ เตปด่า ยุฮ แตะ นัม คระ ละ เปอะ ลั่กกา เปอะ. ตอก ออฮ ตอก เอีฮ ญุ่ก, ซ ไก ติ ซเงะ เญือม ซ ลอก ปุย ตุต แตะ ฆาื มั่ป ยุฮ อื เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ฟวยจ เซ พะจาว เกือฮ พาญัต ฆอก เกิต ลลาึง ปุย โฮวน เซ ฆาื ไว อื ฮุป โมวก ยุฮ อาโรน ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ฟวยจ เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ โอก โฮว ฮา นา เฮี, เตือง ปะ เตือง โม ป นัม เปอะ โอก ฮา เมือง อียิป เซ. โฮว ฮอยจ นึง เมือง ป ซันญา อาึ อาึง ละ อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป. อาึ เอีจ อัฮ เนอึม ติ แตะ ซ เกือฮ ละ โม จัตเจือ อื. ");
INSERT INTO lcp_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","อาึ ซ เกือฮ เตปด่า โฮว รกา เปอะ ติ, ละ ซ โครฮ อื โม คะนาอัน, โม อาโมไร, โม ฮิตไท, โม เปริซี, โม ฮีไว ไม่ โม เยบุ่ต โอก ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","โฮว เมิฮ. เลียก อาวต นึง เมือง ตึม โครยญ โคะ โกะ โครยญ โกลง เซ. อาึ ปังเมอ โอ ซ โฮว ไม่ เปอะ. ดัฮ โฮว ไม่ เปอะ แกต ติ แตะ ซ โคะ ยุฮ ไลจ ไม่ โม เปะ ตัม คระ โฮว เปอะ, นึง ลึง ลอน รพาวม โม เปะ เฮี,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ปุย โฮวน เซ เญือม ฮมอง อื ลปุง เซ, ตุก รพาวม ปอ เยือม แตะ ฆาื อื. ไก โตว ป แง่ฮ ฆัว ติ แตะ นึง เครอึง ไมจ ติ ตื เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","กา เซ พะจาว เอีจ ดวน ไอ โมเซ ซตอก ปุย ตอก เฮี, “โม เปะ มัฮ เปอะ ปุย ลึง ลอน รพาวม. อาึ มัฮ ซ โฮว ไม่ โม เปะ เมาะ ติ เตะ โน่ง, ตึน ซ โคะ ยุฮ ไลจ ไม่ เปอะ. ปอยจ แปฮ เครอึง ไมจ แง่ฮ เปอะ ติ แตะ นึง เซ, เดอึม อาึ ซ เกียฮ ตัตซิน รพาวม แตะ นึง ป ซ ยุฮ แตะ ละ โม เปะ,” เอีจ อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","เคียง โอก โฮว อื ฮา บลาวง ซีไน เซ โม อิซราเอน เญือะ แง่ฮ ฆัว โตว ติ แตะ นึง ฮนัง เบล, ไม่ ไฌม โอเอีฮ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ปุย โฮวน เซ เญือม ฮอยจ อื นา ออฮ นา เอีฮ ญุ่ก ละ ซ ยุฮ อื ไคะ อาวต แตะ, ไอ โมเซ โกย กัง แตะ พากัง แตวะ ติ ลัง, เกือฮ อื รโปยฮ ซไง ฮา ไคะ อาวต ปุย. อัฮ พากัง ก ฮอยจ ปุย เคะ พะจาว ไม่ อื. ป ออฮ ป เอีฮ ญุ่ก ป ฆวต ยุง ป ปุก รพาวม พะจาว เยอ ซ โฮว ฮอยจ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","เญือม ซ โฮว ไอ โมเซ ฮอยจ นึง พากัง แตวะ เซ, ปุย โฮวน โกย ชุง แตะ โตะ รเวือะ พากัง ยุฮ โกะ แตะ เตือง ไพ เตือง มัน, แก ไอ โมเซ ฮอยจ ละ เลียก อื. ");
INSERT INTO lcp_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","เญือม เอีจ เลียก ไอ โมเซ โตะ พากัง เซ, ด่อง ชุต รวู เซ ซ เลีฮ อาวต โตะ รเวือะ พากัง แตวะ เซ. พะจาว ลปุง ไม่ ไอ โมเซ เน่อึม นึง โตะ ชุต รวู เซ. ");
INSERT INTO lcp_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ปุย โฮวน เซ เญือม ชวน อื เลีฮ ชุต รวู ฮอยจ โตะ รเวือะ พากัง แตวะ เซ, โกฮ ชุง นุ่ม ไกญ แตะ ละ ซ นัปทื แตะ พะจาว เน่อึม ก อาวต โกะ แตะ เตือง ไพ เตือง มัน. ");
INSERT INTO lcp_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","พะจาว ลปุง ไม่ ไอ โมเซ ซอง โต ซอง ตอก ลปุง ปุย ไม่ ปุโฮมว แตะ โฮ. ฟวยจ เซ ไอ โมเซ ซ เอีญ แม ฮอยจ นึง ไคะ. โยชูวา ปุย นุม อาญุ ป มัฮ ป เรอึม ไอ โมเซ เซ ปังเมอ โอ โอก ฮา พากัง แตวะ เซ. อาวต แนฮ ลั่ง โตะ เซ. โยชูวา เซ มัฮ กวน นูน. ");
INSERT INTO lcp_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ไอ โมเซ ปัว นึง พะจาว ตอก เฮี, “อาึ ไก ป ฆวต ปัว นึง เปอะ ติ เจือ. เอีจ เกือฮ เปอะ อาึ นัม ปุย โม เฮี โฮว ฮอยจ เมือง โคระ. อัฮ เปอะ ติ แตะ เมีญ อาึ มัฮ ปุโฮมว แตะ. อัฮ เปอะ อาึ ปุก รพาวม แตะ. ปังเมอ โอ เปอะ รโฮงะ เนิ ตัว ป ซ เกือฮ เปอะ โฮว ไม่ เอะ ละ ซ นัม อื เอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","ดัฮ อาึ ปุก เนอึม รพาวม เปอะ โฮ, ปัว เปอะ รโฮงะ ที ป คิต ป ง่อต เปอะ เนิ เกือฮ อาึ ยุง, เดอึม อาึ ซ เกียฮ ยุฮ ลอป ตอก ปุก อื รพาวม เปอะ, ไม่ เกียฮ ยุง เนอึม เมอะ ตอก มัฮ ตอก มอยฮ เปอะ. ปัว เปอะ ไตม อาึง ตอก เลือก เปอะ ปุย โฮวน เฮี แปน คอง โกะ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","พะจาว โลยฮ อื ละ อื ตอก เฮี, “อาึ ซ โฮว ไอฮ ไม่ เปอะ. ซ เกือฮ โม เปะ โฮลฮ อาวต ไมจ อาวต มวน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","16","ไอ โมเซ อัฮ เฮี, “ดัฮ เปอะ โฮว เนอึม ไม่ เอะ โฮ, ซ ที ละ ปุย ฆาื อื มัฮ เอะ ปุย ตัง โน่ง ฮา ปุย ไฮญ โครยญ เจือ ปุย. ดัฮ เปอะ โอ โฮว ไม่ เอะ โฮ, ปุย ซ ยุง อื ตอก เมอ ปุก อาึ ไม่ ปุก ปุย โฮวน เฮี รพาวม เปอะ ฆาื อื? ดัฮ เปอะ โอ โฮว เนอึม ไม่ เอะ, ปุ เกือฮ เอะ โฮว ฮา นา เฮี เฟือฮ เอิน,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","พะจาว โลยฮ อื ตอก เฮี, “อาึ ซ ยุฮ เนอึม ตัม ป ปัว เปอะ, นึง ปุก ปะ รพาวม เมอะ. อาึ เมีญ เนอึม ปะ มัฮ ปุโฮมว แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ไอ โมเซ อัฮ เฮี, “ปัว ปะ เปลีฮ รัง ซเปีย ยุฮ เปอะ เนิ เกือฮ อาึ ยุ,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","พะจาว โลยฮ อื, “อาึ ซ เกือฮ รัง ซเปีย ไมจ ญุ่ก ยุฮ แตะ โฮว ลั่กกา เปอะ. อาึ ซ รโฮงะ มอยฮ ซง่ะ ซงอม ยุฮ แตะ ละ เปอะ. อาึ มัฮ เยโฮวา. อาึ เลียก พาวม นึง โม ป เลือก แตะ ตัม รพาวม โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ปะ ปังเมอ โอ เปอะ ซ โฮลฮ ยุ นา อาึ. ปุย ปลัฮเตะ เฮี ดัฮ ยุ นา อาึ โฮ เญือะ เกียฮ ไอม โตว ติ ปุย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","โฮว ชุง ราว ซโมะ ป อาวต โบ อาึ เฮี. ");
INSERT INTO lcp_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","อาึ ซ เกือฮ ปะ อาวต เฆียป ซโมะ. ซ เดีย ปะ นึง เตะ แตะ ลไล โฮว พา อาึ ซโมะ เซ ไม่ รัง ซเปีย คึนัก ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ฟวยจ เซ อาึ ซ เฌาะ เตะ แตะ ฮา ซโมะ เซ เกือฮ ปะ ยุ ลวง ลั่กเคะ แตะ. นา เยอะ ปังเมอ โอ เปอะ ซ โฮลฮ ยุ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","พะจาว อัฮ แม อื ละ ไอ โมเซ ตอก เฮี, “ไมจ เปอะ พัฮ แม แพน ซโมะ โคระ ลอา แพน ตอก แพน ไพรม อื โฮ. อาึ ซ ไซฮ ลปุง แตะ นึง แพน ซโมะ เซ ตอก ลปุง อาวต นึง แพน ไพรม อื ป เตือน ปะ เกือฮ ม่ะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","ไมจ เปอะ เพรียง อาึง ติ แตะ, ซง่าวป ก ซะ อา งาวป ฮาวก เคะ อาึ อื นึง ไกญ บลาวง ซีไน. ");
INSERT INTO lcp_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ปุย ไฮญ ปุ เกือฮ โฮว ไม่ เปอะ. ไมจ เปอะ โตว เกือฮ ปุย อาวต นึง บลาวง เซ เฟือฮ เอิน, ปัง มัฮ นา ออฮ นา เอีฮ อื ญุ่ก. ปุ เกือฮ อาึ ยุ ติ ปุย เนอึม. แกะ ไม่ ปิ ไม่ โมวก ปุ โรฮ เกือฮ เปือม ไรป นึง ชวง บลาวง เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ไอ โมเซ พัฮ เนอึม แม แพน ซโมะ โคระ ฆาื อื ลอา แพน. ปวยฮ พริ เซ เญือม งาวป ลั่ง อื โรวก อื, ฮาวก ไม่ อื นึง บลาวง ซีไน เซ ตัม ป อัฮ พะจาว อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","เญือม เซ พะจาว เลีฮ นึง ชุต รวู. อาวต ดิ ไม่ ไอ โมเซ นา เซ. พะจาว รโฮงะ มอยฮ โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","พะจาว โฮว พา ลั่กกา ไอ โมเซ ไม่ อัฮ อื เฮี, “อาึ มัฮ เยโฮวา, มัฮ พะจาว ป นาวก นึง กุนมุ่น ไม่ รพาวม เลียก พาวม โซะ ไงะ แตะ นึง ปุย. มัฮ ป ไน่ ซ ฮาวก รพาวม. รพาวม ฮรัก เกอะ ตอน ฮมัน, ไก โตว ลอยจ นึง. อาึ มัฮ โรฮ ป เนอึม รพาวม. ");
INSERT INTO lcp_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","อาึ มัฮ ป เปลีฮ รพาวม ฮรัก ตอน ฮมัน ยุฮ แตะ ละ ปุย แปน เปือน เจน อื, ไม่ ยวก เกอะ มั่ป กัฮ ฮะ ตุต ละ ปุย, ไม่ โอ เยอะ ทื โซะ โระ โกลยจ ปุย. ปัง มัฮ ตอก เซ, ละ โม ป ยุฮ กัน พิต เตอ, อาึ ปังเมอ โอ ปุน อาวต โฆย ไม่. อาึ ซ เกือฮ ลอก ตุต แตะ เน่อึม เจน โกะ อื เซ, ฮอยจ ละ เจน กวนโซะ กวน แซะ อื ลอวย ปาวน เจน ปุย,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","เญือม เซ เยอ ไอ โมเซ นุ่ม ไว พะจาว ปอ จิ ไกญ แตะ เตะ, ไววอน. ");
INSERT INTO lcp_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","อัฮ เฮี ละ พะจาว, “โอ พะจาว, ดัฮ อาึ มัฮ เนอึม ปุย ปุก รพาวม เปอะ โฮ, ปัง มัฮ โม อิซราเอน เฮี ปุย ลึง ไม่ กอ บุ่ง รพาวม แตะ ญุ่ก, อาึ ปัว ลั่ง ปะ โฮว ดิ ไม่ เอะ ไม่ อาวต ลั่ง เปอะ ซน่ะ ลลาึง โม เอะ. ปัว เปอะ ยวก มั่ป กัฮ ตุต ละ โม เอะ. ปัว ปะ รัป ลั่ง เอะ แปน ปุย ไน เปอะ,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","พะจาว อัฮ เฮี, “ปเลี่ย เฮี อาึ ซ ซันญา ดิ อาึง โอเอีฮ ไม่ โม เปะ. อาึ ซ ยุฮ กัน ซัมคัน ซองนา โม เปะ ป โอ ปุย เมือง ไฮญ ติ ปลัฮเตะ เฮี ดิ ยุ ดิ ฮมอง ติ เมือง เนอึม. เมือง ปุย ป อาวต รวิต รเวียง เปอะ เซ ซ ยุ กัน ระ ไล ยุฮ อาึ ละ ซ เรอึม แตะ โม เปะ เซ, นึง มัฮ อื กัน ระ ไล ปอ ฮลัต ปุย นึง. ");
INSERT INTO lcp_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ป อัฮ อาึ ละ เปอะ ซเงะ เนาะ เฮี ไมจ เนอึม เปอะ ยุฮ ตัม เซ. ดัฮ เปอะ ยุฮ ตัม เซ อาึ ซ โครฮ โม อาโมไร, โม คะนาอัน, โม ฮิตไท, โม เปริซี, โม ฮีไว, ไม่ โม เยบุ่ต โอก ฮา เปอะ ลั่กกา เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","ไมจ เปอะ แฮน เนอึม ติ แตะ. ปุ ซันญา โอเอีฮ ไม่ ปุย เมือง ป ซ โฮว อาวต เปอะ นึง เซ, เดอึม โอ ซ แปน ตอก แฮวะ ละ เปอะ ละ ซ เกือฮ อื โม เปะ ไลจ โลม. ");
INSERT INTO lcp_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","ไมจ เปอะ เญื่อฮ คัน ไว อื พะ ยุฮ แตะ เซ. ไมจ เปอะ ตุฮ ซกัง ซโมะ ยุฮ อื เกือฮ บลวย. ไมจ เปอะ ฆู โปวฮ ซกัง โคะ ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","โม เปะ ไมจ เปอะ โตว นัปทื พะจาว ไฮญ ติ เจือ เนอึม. อาึ ป มัฮ เยโฮวา มัฮ พะจาว ป เครือง ลอป โม เปะ ตอก เครือง ปุย ปุ รง่ะ แตะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","ปุ โตกโลง ตอก ซ ปุก เปอะ ปุ แตะ ไม่ ปุย เมือง เซ. ปุย โม เซ เญือม ตัน อื ละ พะ ทื แตะ เซ ไม่ เลียง อื ปุ แตะ, ตึน ซ บะ โม เปะ ลวม ไม่ แตะ. ฟวยจ เซ โม เปะ ซ โคะ โซม เปอะ โอเอีฮ ตัน อื ละ ฮุป ทื อื เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","เญือม เซ ตึน ซ โคะ เลือก เปอะ กวน รโปวน อื แปน ปุย เญือะ กวน รเมะ เปอะ ง่อน. ปรโปวน โม เซ ตึน ซ นัปทื ลั่ง พะ โอ เนอึม โฮวน เจือ ยุฮ แตะ เซ, ตอก เอิน ไล ยุฮ ปุย ป โอ เนอึม รพาวม ละ ปรเมะ เญือะ แตะ โฮ. ซ ลอต นัม กวน รเมะ เปอะ แปน ปุย โอ เนอึม รพาวม ละ พะจาว ตอก เซ โรฮ. มัฮ เซ ป ไมจ เปอะ แฮน ติ แตะ ฆาื อื.” ");
INSERT INTO lcp_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“ปุ โกว ไคร มาื ไม่ ไร โอเอีฮ ละ ซ โล เปอะ ฮุป นึง ละ ซ ไว เปอะ เฟือฮ เอิน.” ");
INSERT INTO lcp_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“ไล รโจะ เปอะ โซม คโนมปัง โอ ไก เจือ ไน เคิ อาบิ่ป เซ ไมจ เปอะ ยุฮ โครยญ เนอึม. ไน ติ เจน อาแลฮ ซเงะ เซ ไมจ เปอะ โซม คโนมปัง โอ ไก เจือ ตัม ป ดวน อาึ เปอะ เซ, นึง มัฮ เคิ อาบิ่ป เซ เคิ เกือฮ พะจาว โม เปะ โอก ฮา เมือง อียิป.” ");
INSERT INTO lcp_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“กวน รเมะ เกิต โรง เปอะ โครยญ โฆะ อื, ไม่ ซัตซิง กิฮ โรง ป มัฮ ตัว ไฮมญ อื โครยญ ตัว อื ลัง มัฮ คอง อาึ. ");
INSERT INTO lcp_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","กวน บรัง ป กิฮ โรง ยุฮ เปอะ คาว ละ โตฮ เปอะ นึง กวน แกะ ติ ตัว. ดัฮ เปอะ โอ โตฮ โฮ, ไมจ เปอะ โปวก โงก อื เกือฮ ยุม. กวน รเมะ เกิต โรง เปอะ ไมจ โรฮ เปอะ โตฮ ตอก เซ โครยญ โฆะ อื.” “ปุ เกือฮ ปุย ฮอยจ เคะ อาึ นา ก ทไว ปุย โอเอีฮ เตือง โอ อื ไก ป ทไว.” ");
INSERT INTO lcp_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ไน แลฮ ซเงะ เอ โม เปะ ไมจ เปอะ ยุฮ กัน แตะ เตือง โอยจ อื. ซเงะ อาแลฮ นึง อื ไมจ เปอะ ลโล่ะ นึง. ปัง มัฮ เญือม ไท เปอะ ชิจ ญุ่ก, ปัง มัฮ เมือ ปุน เฮงาะ ญุ่ก, ไมจ โรฮ เปอะ ลโล่ะ นึง.” ");
INSERT INTO lcp_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","ไมจ เปอะ ชลอง ซเงะ รฮอน เญือม ฮอยจ โรง เฮงาะ ซาลี ยุฮ เปอะ โครยญ เนอึม. ไมจ โรฮ เปอะ ชลอง กัน อาวต นึง เตอึป เญือม เอีจ ฟวยจ แฮรน เปอะ ป ไล ป เพลือะ เญือม เอีจ ล่อยญ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ไมจ โม ปรเมะ ป มัฮ ปุย ไน เปอะ ฮอยจ เคะ เยโฮวา ป มัฮ พะจาว ทื เปอะ เซ นึง พากัง ยุฮ อื ติ เนอึม ลอวย โฮน. ");
INSERT INTO lcp_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","เญือม เอีจ ฟวยจ โครฮ อาึ ปุย โฮวน เมือง เซ โอก ละ เปอะ ลั่กกา โม เปะ ไม่ เวือ เยอะ นาตี อาวต เปอะ เซ เกือฮ เวือฮ ฮา, ลไล ฮาวก โม ปรเมะ ละ ซ ฮอยจ แตะ เคะ พะจาว ยุฮ เปอะ ติ เนอึม ลอวย โฮน ตอก เซ, ซ ไก โตว ปุย เมือง ไฮญ ป ซ โรวต เลียก ซะ เต เมือง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“เญือม โรวก เปอะ ซัตซิง ละ ซ มอก เปอะ ทไว ละ อาึ อื, ปุ ทไว ดิ ไม่ คโนมปัง ป ดุฮ ปุย เจือ คโนมปัง เซ นึง. โตะ ซัตซิง มอก เปอะ ละ โซม เลียง ฌาว เปอะ ไม่ ปุ แตะ เซ, ปุ ละ อาึง ฮอยจ ละ ปวยฮ พริ. ");
INSERT INTO lcp_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“เปลิ โรง ป โฮลฮ เปอะ นึง โอเอีฮ ซมา ลโลวง เปอะ เซ, ป ตึก นึง ไมจ แตะ นึง อื, ไมจ เปอะ ตาว ฮอยจ ละ เญือะ ยุฮ พะจาว ยุฮ เปอะ.” “ไมจ เปอะ โตว โกยฮ ดิ โตะ กวน ปิ ไม่ รอาวม ตาึฮ มะ โกะ อื ไอฮ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ ไซฮ อาึง ลปุง ไล เซ, นึง มัฮ อื ลปุง ซันญา อาึ อาึง ละ ปะ ไม่ โม อิซราเอน เตือง โอยจ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","เญือม เซ ไอ โมเซ อาวต นา เซ ไม่ พะจาว รปาวน ซเงะ รปาวน ซาวม เตือง โอ แตะ โซม โอเอีฮ ไม่ โอ แตะ ญุ รอาวม เฟือฮ เอิน. ไอ โมเซ ไซฮ อาึง ลปุง ซันญา ยุฮ พะจาว ละ ปุย นึง แพน ซโมะ ลอา เซ. เอีจ มัฮ โกตไม กาว เจือ ยุฮ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ไอ โมเซ เญือม เอีจ เลีฮ อื ฮา บลาวง ซีไน เซ โรวก ปุ เลีฮ ลปุง พะจาว ป ไก นึง แพน ซโมะ ลอา เซ. นา อื รฌิญ เอิน ซเปีย นึง, นึง เอีจ โฮลฮ อื ลปุง ดิ ไม่ พะจาว. โกะ อื ปังเมอ โอ ยุง อื. ");
INSERT INTO lcp_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","เญือม เซ อาโรน ไม่ โม อิซราเอน ชวน ไอ โมเซ. ยุ รฌิญ ซเปีย เน่อึม นึง นา อื. ฮลัต ฆาื อื. โรวต โตว เลียก ซดิ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ไอ โมเซ กอก อื เอีญ เคะ แตะ. อาโรน เอีญ เนอึม เคะ อื ไม่ โม ป กวต ยุฮ โม อิซราเอน. ไอ โมเซ ลปุง ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ฟวยจ เซ โม ลัปซด่อน ฮอยจ โรฮ ซดิ โบ อื. ไอ โมเซ รโฮงะ ลปุง ซตอก พะจาว อาึง ละ ปุย โครยญ เจือ ตัม ป เกือฮ พะจาว ละ แตะ นึง บลาวง ซีไน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","เญือม เอีจ ฟวยจ ลปุง อื ไม่ ปุย เยอ ไอ โมเซ เลอึป นา แตะ นึง พา. ");
INSERT INTO lcp_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","เญือม ซ เลียก อื โตะ พากัง แตวะ ละ ซ ลปุง แตะ ไม่ พะจาว ปอยจ พา เซ. เญือม ซ โอก อื เลอึป แม อื. เญือม เอีจ โอก อื รโฮงะ อื ละ โม อิซราเอน โครยญ เจือ โอเอีฮ ป ดวน พะจาว แตะ อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","โม อิซราเอน ยุ รฌิญ ซเปีย นา อื. ไอ โมเซ ไอฮ แม พา เลอึป นา แตะ ฆาื อื ฮอยจ ละ เลียก ลปุง แม แตะ ไม่ พะจาว ติ โฮน แม. ");
INSERT INTO lcp_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ไอ โมเซ กอก โม อิซราเอน เตือง มู อื เกือฮ อื โพรม ดิ ไม่ ปุ แตะ. อัฮ เฮี ละ อื, “ไลลวง เฮี มัฮ ป ซตอก พะจาว โม เปะ ยุฮ. ");
INSERT INTO lcp_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ไมจ เปอะ ยุฮ กัน ยุฮ แตะ ไน แลฮ ซเงะ. ซเงะ อาแลฮ นึง อื มัฮ ซเงะ ซัมคัน. ไมจ เปอะ ลโล่ะ กัน ยุฮ แตะ ละ ซ เปลีฮ เปอะ นัปทื แตะ พะจาว นึง. ดัฮ ไก ป ยุฮ กัน นึง ซเงะ เซ ไมจ ปุย ไฮญ ยุฮ ยุม ไม่ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ไน ซเงะ ลโล่ะ เปอะ เซ ปุ จอป งอ นึง เญือะ เปอะ ติ ปุย เนอึม,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ไอ โมเซ อัฮ อื ละ โม อิซราเอน ตอก เฮี, “ไลลวง เฮี มัฮ ป ซตอก พะจาว โม เปะ ยุฮ. ");
INSERT INTO lcp_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ไมจ เปอะ โรวก ทไว คาวคอง ยุฮ เปอะ ละ พะจาว ง่อน. เมาะ ป เตม รพาวม นึง ซ ทไว แตะ, ไมจ อื โรวก ทไว โอเอีฮ ตอก เฮี ละ พะจาว. ไคร ญุ่ก, มาื ญุ่ก, ไร ซเงี ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","กอย ซี ฟะ ไม่ ซี ซูวัน ไม่ ซี ซครัก ญุ่ก, พา ปิญ รฮอยจ ญุ่ก, พา ไตญ นึง ฮาึก ปิ ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ฮัก แกะ ไฮมญ ญอม ซครัก ญุ่ก, ฮัก กะ โลมา ญุ่ก, โคะ กทิน ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ไม่ ลออยฮ กาวก โกว ละ ดุฮ นึง ออม, ไม่ ป ซออย ฮงาื ละ ซ รไม่ ปุย อื ไม่ ลออยฮ ซัมคัน, ไม่ ป ซออย ฮงาื ตอง ปุย ทไว ละ พะจาว ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","แกว พรุยฮ ไม่ แกว ไฮญ ละ ซ โกว ปุย อื ละ ดุฮ แตะ นึง ลปิ เอโฟต ไม่ นึง พา เลอึป รน่าวก ซตุ ญุ่ก, เตอึม ป ฆวต ทไว เปอะ นึง อื,” อัฮ เซ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","ฟวยจ เซ อัฮ แม อื ตอก เฮี, “ปุย ไน โม เปะ เมาะ ป ไก วิซา พันญา ไมจ นึง อื, เกือฮ ฮอยจ ละ ซ ยุฮ แตะ กัน ตัม ป ดวน พะจาว เอะ ยุฮ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","เกือฮ ยุฮ พากัง ระ เตือง พรัง อื ไม่ ฮัก ราว อื. ยุฮ ไม่ ควน มั่ก อื ปุ แตะ ไม่ โคะ ซแก อื ไม่ ด่อง ไม่ โน่วก อื ไม่ ควน โบลวง ปุย ด่อง อื. ");
INSERT INTO lcp_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ยุฮ โรฮ ไม่ ฮิต ลปุง ซันญา ไม่ รเดือป ซัมคัน อื ไม่ โคะ ลกลอม อื, ไม่ พา เลอึป ปุย อื. ");
INSERT INTO lcp_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ยุฮ โรฮ ไม่ โตะ อาวต คโนมปัง ไม่ โคะ ลกลอม อื, ไม่ กลอง เชือม ลัง อาวต นึง อื ไม่ คโนมปัง ทไว ปุย นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ยุฮ โรฮ ไม่ ชวง ออม กัก อาแลฮ ละ ซ เกือฮ แปน ควน ซเปีย เซ, ไม่ เครอึง ลัง อาวต ไม่ อื เตือง ออม เตือง ลออยฮ โกว ปุย ละ ดุฮ อื นึง ออม เซ. ");
INSERT INTO lcp_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ยุฮ โรฮ ไม่ คัน ตอง ปุย ป ซออย ฮงาื เตือง โคะ ลกลอม อื, ไม่ ป ซออย ฮงาื ตอง ปุย ไม่ ลออยฮ ซัมคัน ละ ซ เรฮ นึง ปุย โรฮ. เกือฮ โรฮ ยุฮ พากัง ละ เฆีญ ปุย โตะ รเวือะ พากัง ระ เซ นึง, ");
INSERT INTO lcp_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ไม่ คัน ตอง ปุย ทไว ซัตซิง ละ พะจาว เตือง ตาแซง ไร ซเงี นึง อื ไม่ โคะ ลกลอม อื ไม่ เครอึง โกว ปุย นึง คัน เซ, ไม่ อาง ระ ไม่ ชวง อื. ");
INSERT INTO lcp_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ยุฮ โรฮ ไม่ พา ละ ฆรุง อื, เตือง ลัก อื ไม่ ควน โบลวง ลัก อื เซ ไม่ พากัง เฆีญ โตะ รเวือะ ฆรุง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ยุฮ โรฮ ลัก เกอึม ปุย ละ เคิง แตะ พากัง ระ, ไม่ โม่ะ เคิง อื, ไม่ ลัก ละ เคิง แตะ ฆรุง รวิต ควง อื, เตือง โม่ะ เคิง อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ไมจ โรฮ เปอะ ไตญ เครอึง ซัมคัน ละ จาวป โม ซตุ อื เญือม เลียก ยุฮ อื กัน กไน พากัง ยุฮ พะจาว เซ เตือง เครอึง อาโรน ไม่ เครอึง กวน อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","เญือม เซ โม อิซราเอน เอีญ ฮอยจ ก อาวต แตะ เตือง ไพ เตือง มัน. ");
INSERT INTO lcp_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","โม ป เตม รพาวม นึง ฆวต ทไว แตะ โอเอีฮ เซ, ตุย โรวก ป ฆวต ทไว แตะ ละ พะจาว ละ ซ ยุฮ ปุย พากัง นา ก ฮอยจ ปุย เคะ พะจาว นึง. ทไว โรฮ โอเอีฮ ละ ซ โกว ซตุ อื เญือม รซอฮ แตะ นึง อื, เตือง เครอึง ซัมคัน จาวป อื. ");
INSERT INTO lcp_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","เมาะ ป เตม รพาวม นึง ฆวต ทไว แตะ โอเอีฮ เซ, ฮอยจ ไม่ ฮนัง ไม่ เบล ไม่ ตอฮู ไม่ เครอึง ไคร ไฮญ โฮวน เจือ. ทไว เครอึง ไคร เซ ละ พะจาว เตือง ปรเมะ ปรโปวน. ");
INSERT INTO lcp_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","เมาะ ป ไก กอย ซี ฟะ, ซี ซูวัน, ซี ซครัก ยุฮ, ไม่ ป ไก พา ปิญ รฮอยจ ไม่ ฮาึก ปิ ไม่ ฮัก แกะ ไฮมญ ญอม ซครัก ไม่ ฮัก กะ โลมา ยุฮ ฮู, โรวก โรฮ ทไว อื ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","โม ป ไก รพาวม ฆวต ทไว มาื ไม่ ไร ซเงี, โรวก โรฮ ทไว อื ละ พะจาว โรฮ. ป ไก โคะ กทิน ยุฮ ละ ซ เกียฮ โกว อื นึง กัน เซ โรวก โรฮ อื โครยญ โฆะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","โม ปรโปวน ป เกียฮ เกลีญ กอย โรวก โรฮ กอย เกลีญ แตะ เซ, เตือง กอย ซี ฟะ, ซี ซูวัน, ซี ซครัก ไม่ กอย บิญ ยุฮ แตะ ทไว โรฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","โม ปรโปวน ป ไก รพาวม ฆวต ทไว ไม่ ป เกียฮ เกลีญ เญอ เกลีญ โรฮ ฮาึก ปิ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","โม ป มัฮ ฮัวนา ปุย นึง อื โรวก โรฮ แกว พรุยฮ ไม่ แกว ไมจ ไฮญ ละ ซ อาึง ปุย อื นึง ลปิ เอโฟต ไม่ นึง พา เลอึป รน่าวก ซตุ. ");
INSERT INTO lcp_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","โรวก โรฮ ป ซออย ฮงาื ไม่ ลออยฮ กาวก ละ ดุฮ ปุย นึง ออม เซ, ไม่ ลออยฮ ซัมคัน ละ เรฮ นึง ปุย ไม่ ป ซออย ฮงาื ละ ซ ตอง ปุย ทไว ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","โม อิซราเอน เตือง ปรเมะ ปรโปวน, เมาะ ป เตม รพาวม นึง ฆวต ทไว แตะ โอเอีฮ เซ, โรวก เนอึม ทไว อื ละ พะจาว ละ ยุฮ ปุย กัน เซ นึง เตือง โอยจ อื, ตัม ดวน พะจาว ไอ โมเซ ยุฮ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ไอ โมเซ อัฮ เฮี ละ โม อิซราเอน, “พะจาว เอีจ เลือก เบ่ซาเลน ป มัฮ กวน อุรี. (มัฮ กวนโซะ เฮอ, มัฮ ปุย เจอ ยูด่า.) ");
INSERT INTO lcp_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","พะจาว เอีจ เกือฮ ลปุ แตะ นัม รพาวม อื. เอีจ เกือฮ อื เกียฮ เตะ เกียฮ แนต ไม่ เกือฮ วิซา พันญา ละ อื นึง กัน ยุฮ อื โฮวน เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","เอีจ เกือฮ อื เกียฮ แตม ลวตไล โอเอีฮ โฮวน เจือ นึง ไคร ไม่ มาื ไม่ ไร ซเงี. ");
INSERT INTO lcp_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","เกือฮ โรฮ อื เกียฮ เกลียง แกว ไมจ ละ ซ โกว ปุย อื, ไม่ เกียฮ ยุฮ อื โอเอีฮ นึง โคะ ไม่ ปดั่ป ปด่า โอเอีฮ เกือฮ ไมจ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","พะจาว เอีจ เกือฮ เบ่ซาเลน ไม่ โอโฮลีอัป เซ ไก รพาวม ฆวต เพอึก โรฮ ปุย ไฮญ นึง กัน ตอก เซ โรฮ ไม่ อื. (โอโฮลีอัป เซ มัฮ กวน อะฮิซะมัก, มัฮ ปุย เจอ ด่าน.) ");
INSERT INTO lcp_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","พะจาว เอีจ เกือฮ ปุย ลอา เซ ไก วิซา พันญา ไมจ, แปน จัง เคือง เกียฮ แตม ลวตไล นึง ไคร นึง มาื, ไม่ ไตญ อื โอเอีฮ นึง กอย ซี ฟะ ซี ซูวัน ไม่ ซี ซครัก, ไม่ กอย บิญ. ปุย ลอา เฮี มัฮ ชัง ไมจ ไลมื นึง โอเอีฮ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“เบ่ซาเลน ไม่ โอโฮลีอัป ไม่ ปุย ไฮญ เซ ไมจ อื ยุฮ โอเอีฮ ตัม ไล แตะ ตอก เอีจ ดวน พะจาว เอะ ยุฮ โครยญ เจือ. เอีจ มัฮ พะจาว ป เกือฮ อื ไก วิซา พันญา ไมจ นึง กัน ตอก เซ ละ ซ ยุฮ อื พากัง ระ เซ,” อัฮ เซ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","เญือม เซ ไอ โมเซ กอก เบ่ซาเลน ไม่ โอโฮลีอัป เซ ฮอยจ เคะ แตะ, กอก โรฮ อื ไม่ ปุย ไฮญ ป เอีจ เกือฮ พะจาว วิซา พันญา ไมจ ละ, ละ ซ เกียฮ ยุฮ อื โอเอีฮ เซ. เมาะ ป เตม รพาวม นึง ฆวต ยุฮ แตะ กัน เซ, เกือฮ เนอึม อื ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ไอ โมเซ มอป เนอึม โอเอีฮ ป ทไว โม อิซราเอน เซ ละ โม ป ซ ยุฮ พากัง ระ เซ. โม ป เตม รพาวม นึง ฆวต ทไว แตะ โอเอีฮ เซ ตาว แนฮ ลั่ง ป ทไว แตะ เซ โครยญ ซะ. ");
INSERT INTO lcp_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","เญือม เซ โม ป เกียฮ กัน โครยญ เจือ เซ ฮอยจ เคะ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","อัฮ เฮี ละ อื, “โอเอีฮ ป ตาว โม ลัปซด่อน ละ ซ ยุฮ เอะ กัน ดวน พะจาว แตะ ยุฮ โครยญ เจือ เซ เอีจ โฮฮ ฮา จัมเปน อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","เญือม เซ ไอ โมเซ ซตอก ปุย เกือฮ ปุย โฮว ครอฮ อื เลี่ป ไคะ อาวต โม อิซราเอน เซ, นึง โอ อื เญือะ ซ เกือฮ ปุย โรวก ทไว โอเอีฮ ละ ซ ยุฮ พากัง ระ เซ นึง. ฟวยจ เซ ปุย เญือะ ตาว โตว อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ป เอีจ ฟวยจ ทไว ปุย ละ ซ ยุฮ ปุย กัน เซ นึง เอีจ โฮฮ ฮา จัมเปน อื. ");
INSERT INTO lcp_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","เญือม เซ โม ชัง ป ไก วิซา พันญา เซ ยุฮ เนอึม พากัง ระ เซ. ยุฮ อื นึง พา กาว ปลัฮ, มัฮ พา แนน ไมจ, ป ไตญ ปุย นึง กอย บิญ ไม่ กอย ซี ฟะ, กอย ซี ซูวัน, ไม่ กอย ซครัก. เกือฮ โรฮ โม ป เกง นึง ไตญ ชิญ แตะ เซ ยุฮ ฮุป เตปด่า ไก โพรยจ นึง อื, ยุฮ อื ไมจ. ");
INSERT INTO lcp_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","พา โกว อื ติ ติ ปลัฮ ฮา, ลั่ง ง่า โรฮ ซเตะ รเนฮ, เวือฮ ปาวน รเนฮ. พา เซ บริญ เมาะ ปุ แตะ โครยญ ปลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","พา ตา พอน ปลัฮ อื เซ, ชิญ อื เกือฮ รติต ดิ แปน ติ ชุต. พา ตา พอน ปลัฮ อื เซ แม ชิญ โรฮ อื เกือฮ รติต ดิ แปน ติ ชุต โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","ยุฮ โรฮ ฮยวก อื นึง กอย ซี ฟะ, ดุฮ ฮยวก อื เซ นึง โฆลว พา เซ ลวง ก พริ อื เตือง ลอา ชุต อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ดุฮ ฮยวก พา เซ นึง เฆียง พา ชุต ติ นึง อื เซ รฮอน โวง, ดุฮ แม อื นึง เฆียง พา ชุต ลอา นึง อื รฮอน โวง โรฮ. เกือฮ อื อาวต ซื นา ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","ฟวยจ เซ ยุฮ ควน มั่ก พา เซ นึง ไคร รฮอน ตัว ละ ซ มั่ก อื พา เซ นึง เกือฮ รติต ดิ, เดอึม ซ เกียฮ แปน พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","โม เซ ไตญ โรฮ พา นึง กอย ฮาึก ปิ กาว โรฮ ติ ปลัฮ ละ ซ แปน อื ควน พรัง ปุย พากัง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","พา ไตญ อื เซ ติ ติ ปลัฮ ฮา ลั่ง ง่วย รเนฮ, เวือฮ ปาวน รเนฮ, บริญ ไม่ ปุ แตะ เตือง กาว โรฮ ติ ปลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","พา ตา พอน ปลัฮ อื เซ, ชิญ อื เกือฮ รติต ดิ แปน ติ ชุต. พา ตา แลฮ ปลัฮ อื เซ แม, ชิญ โรฮ อื เกือฮ รติต ดิ แปน ติ ชุต โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ยุฮ โรฮ ฮยวก อื รฮอน โวง, ดุฮ อื นึง เฆียง พา ลอา ชุต เซ, ติ ชุต รฮอน โวง ตอก ปุ แตะ. เกือฮ อื อาวต ซื นา ปุ แตะ แปน ไล อื. ");
INSERT INTO lcp_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ฟวยจ เซ ยุฮ โรฮ ควน มั่ก อื นึง ไร ซเงี รฮอน ตัว ละ ซ มั่ก อื โตะ ฮยวก พา เซ นึง, เกือฮ อื รติต แปน ติ ปลัฮ ระ. ");
INSERT INTO lcp_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ยุฮ ควน เลอึป พากัง เซ นึง ฮัก แกะ โปก, ญอม อื นึง ซี ซครัก, ไม่ ยุฮ โรฮ ควน เลอึป อื นึง ฮัก กะ โลมา ติ คัก แม. ");
INSERT INTO lcp_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ฟวยจ เซ ยุฮ เดีญ พากัง เซ นึง โคะ กทิน. เดีญ ตุง ฌุง อื เกือฮ ฮาวก ซื. ");
INSERT INTO lcp_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ไมะ แปน ละ ยุฮ อื เดีญ เซ ติ ติ แพน เนอ ลั่ง กาว รเนฮ, เวือฮ ติ รเนฮ ไปล ติ เดือะ. ");
INSERT INTO lcp_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","เกือฮ อื ไก ซลวยญ นึง ชวง อื ติ แพน ลอา, ติ แพน ลอา เตือง โอยจ อื, ละ ซ เกือฮ อื เกียฮ ชุง ซื. ");
INSERT INTO lcp_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","เดีญ ลวง ก เซฮ อื ยุฮ อื นึง ไมะ แปน ง่า แพน. ");
INSERT INTO lcp_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ยุฮ โรฮ ควน โบลวง เดีญ อื เซ รปาวน, ยุฮ อื นึง มาื. ไมะ แปน ติ ติ แพน เซ เกือฮ อื ไก ควน โบลวง ลอา, ลอา, ละ ซ โบลวง อื ซลวยญ อื นึง เตือง ลอา อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","เดีญ ลวง ก ล่าวง อื ยุฮ โรฮ อื นึง ไมะ แปน ง่า แพน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ยุฮ โรฮ ควน โบลวง อื รปาวน ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","เดีญ ลวง ลั่กเคะ อื ลวง ลั่ก เลียก ซเงะ เอ, ไอฮ ไมะ แปน ละ อื แลฮ แพน. ");
INSERT INTO lcp_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","โบลวง ไมะ แปน นึง โจง ลวง ลั่กเคะ อื ติ โจง ลอา แพน. ");
INSERT INTO lcp_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ไมะ แปน ลอา แพน เซ เกือฮ อื ติต ปุ แตะ เน่อึม นึง ชวง อื ฮอยจ นึง ไกญ อื. นึง ไกญ อื เซ ดุฮ ไร ซเงี โวง นึง อื, ละ เกือฮ อื โฮมวต ปุ แตะ, ยุฮ อื ตอก เซ เตือง ลอา โจง อื. ");
INSERT INTO lcp_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ไมะ แปน โกว อื ละ เดีญ ลวง ลั่กเคะ อื เซ เตือง โอยจ อื ไก ซเตะ แพน, ไก ไม่ ควน โบลวง อื กาว โรฮ แลฮ, ยุฮ อื นึง มาื. ไมะ แปน ติ ติ แพน เซ ไอฮ ควน โบลวง อื ลอาๆ. ");
INSERT INTO lcp_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","เดีญ ลวง ลั่ง อื ติ ติ ก บลัฮ ฮา, ยุฮ โคะ ซแก อื พอน, เตือง ลอา ก บลัฮ อื, ยุฮ อื นึง โคะ กทิน. เดีญ ลวง ลั่กเคะ อื ลวง ลั่ก เลียก ซเงะ เอ, ยุฮ โรฮ โคะ ซแก อื พอน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","โคะ ซแก ป อาวต ซน่ะ นึง อื เซ, เกือฮ อื อาวต บั่กบ่วน เดีญ เซ, เกือฮ อื ลั่ง ติ เจน เดีญ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ไมะ แปน เซ อัป อื นึง ไคร, ยุฮ โรฮ โวง ไคร เซ ติต อาึง อื นึง ไมะ แปน เซ, ละ เกือฮ อื แปน ควน ซลอ ปุย โคะ ซแก เดีญ เซ นึง. โคะ ซแก อื เซ อัป โรฮ อื นึง ไคร. ");
INSERT INTO lcp_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","โม เซ ไตญ พา ติ ปลัฮ, ไตญ อื นึง กอย ซี ฟะ, ซี ซูวัน, ซี ซครัก, ไม่ นึง กอย บิญ. ฟวยจ เซ เกือฮ โม ป ไมจ ฟีมื ไตญ ฮุป เตปด่า ไก โพรยจ นึง พา เซ. ");
INSERT INTO lcp_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ยุฮ โรฮ ด่อง อื ปาวน โฆง นึง โคะ กทิน. ด่อง เซ อัป อื นึง ไคร เตือง ปาวน โฆง อื. ควน มั่ก ป ติต ไม่ ด่อง เซ มัฮ โรฮ ไคร. ยุฮ โรฮ ควน โบลวง ด่อง เซ นึง มาื, ละ ซ โบลวง อื ด่อง เซ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","โตะ รเวือะ พากัง เซ ไตญ พา แนน ไมจ ละ อื นึง กอย บิญ, ไม่ กอย ซี ฟะ, ซี ซูวัน, ไม่ ซี ซครัก. พา เซ มัฮ ป ไตญ โม ป ไมจ ฟีมื เกือฮ อื แนน, ไม่ ปัก ลวต ไล อื เกือฮ ไมจ. ");
INSERT INTO lcp_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","ฟวยจ เซ ยุฮ แม ด่อง อื พอน โฆง, ยุฮ อื ไม่ โคะ รมั่ก อื ละ ซ มั่ก อื พา เซ นึง. ควน โฮมวต ด่อง ไม่ เปือง ด่อง เซ อัป อื นึง ไคร. ป มัฮ ควน โบลวง ด่อง เซ ยุฮ อื นึง ไร ซเงี เตือง พอน อื. ");
INSERT INTO lcp_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","เบ่ซาเลน ยุฮ ฮิต นึง โคะ กทิน, ลั่ง ลอา รเนฮ ไปล ติ เดือะ, เวือฮ ติ รเนฮ ไปล ติ เดือะ, ฮลาวง โรฮ ติ รเนฮ ไปล ติ เดือะ. ");
INSERT INTO lcp_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","ฮิต เซ อัป อื นึง ไคร ซโน, เตือง ก พริ กไน อื. ยุฮ โรฮ คอป ป ไก ลวตไล อื, ยุฮ อื นึง ไคร, เกือฮ คอป อื เซ ไก รวิต ฮิต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","โล โวง ไคร ปาวน โวง ติต อาึง อื โจง ฮิต เซ นึง ชวง อื เตือง ปาวน โจง อื. อาึง อื นึง อื ติ ก บลัฮ ลอา โวง, ละ ซ แปน อื ควน ซลอ ปุย โคะ ลกลอม อื. ");
INSERT INTO lcp_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ยุฮ โรฮ โคะ ลกลอม อื. ยุฮ อื นึง โคะ กทิน, อัป อื นึง ไคร. ");
INSERT INTO lcp_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","ซลอ อาึง โคะ ลกลอม อื เซ เกือฮ เลียก โตะ โวง ป ดุฮ อื ลวง เฆียง ฮิต เซ, ละ ซ แปน อื ควน ยวก ปุย ฮิต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","ฟวยจ เซ ยุฮ รเดือป ฮิต ซัมคัน เซ. ยุฮ อื นึง ไคร ซโน, ลั่ง ลอา รเนฮ ไปล ติ เดือะ, เวือฮ ติ รเนฮ ไปล ติ เดือะ. ");
INSERT INTO lcp_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","แตม แม ฮุป เตปด่า ไก โพรยจ ลอา, แตม อื นึง ไคร, อาึง อื นึง ราว รเดือป ฮิต ซัมคัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","เกือฮ อื อาวต นึง ดวยฮ รเดือป ฮิต เซ เตือง ลอา ก บลัฮ อื, ติ ก บลัฮ ติ, เกือฮ เอิน อื รติต ดิ ไม่ รเดือป ฮิต ซัมคัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","เกือฮ ฮุป เตปด่า ไก โพรยจ เซ ดี โพรยจ แตะ ราว รเดือป ฮิต ซัมคัน เซ, เกือฮ อื นา ลั่ก ปุ แตะ, ไม่ เกือฮ อื แลน รเดือป ฮิต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","ฟวยจ เซ ยุฮ แม โตะ ติ ตัว. ยุฮ อื นึง โคะ กทิน, ลั่ง ลอา รเนฮ, เวือฮ ติ รเนฮ, ฮลาวง ติ รเนฮ ไปล ติ เดือะ. ");
INSERT INTO lcp_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","โตะ เซ อัป อื นึง ไคร ซโน, ยุฮ โรฮ คอป โตะ ป ไก ลวตไล นึง ไคร รวิต อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ยุฮ โรฮ คอป โตะ เซ เกือฮ เวือฮ ติ ลเตือก เตะ รวิต อื. คอป ไคร ป ไก ลวตไล อื เซ ติต แม อื เกือฮ บุก คอป โตะ เซ รวิต อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","ฟวยจ เซ โล ไคร แปน โวงๆ แตะ ปาวน โวง ยุฮ ฮยวก โตะ เซ นึง อื. ติต อาึง อื นึง ชวง โตะ เซ เตือง ปาวน อื. ");
INSERT INTO lcp_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ฮยวก โตะ เซ ดุฮ อื เกือฮ ติต ปุ แตะ ไม่ คอป โตะ ป ไก ลวตไล อื เซ, ละ ซ เกือฮ อื แปน ควน ซลอ ปุย โคะ ลกลอม อื นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ยุฮ แม โคะ ลกลอม อื นึง โคะ กทิน, อัป อื นึง ไคร, ละ ซ กลอม ปุย โตะ เซ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ยุฮ โรฮ เชือม ดี, จอก, ซนวน, รตุง, ไม่ เชือม โบลง. เชือม โบลง นึง อื เซ มัฮ ละ ซ โกว ปุย อื ละ ทไว แตะ รอาวม อะงุน นึง ละ พะจาว. โอเอีฮ โม เซ ยุฮ อื นึง ไคร ซโน เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ฟวยจ เซ ยุฮ แม ชวง ออม ติ. ยุฮ อื นึง ไคร ซโน. นึง เน่อึม ชวง อื ไม่ โฆง อื แตม ฮุป เตีย โพรยฮ นึง อื, ไม่ เตีย ปอป ไม่ โปลก เตีย อื. เกือฮ อื รติต ดิ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ชวง ออม เซ ไก กัก แลฮ กัก, โอก เน่อึม นึง โฆง อื เซ ติ ก บลัฮ ลอวย กัก. ");
INSERT INTO lcp_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","กัก อื เซ ติ ติ อี ยุฮ ฮุป เตีย ตอก เตีย อาละมัน นึง อื ลอวย โพรยฮ. เตีย เซ โครยญ โพรยฮ อื, ยุฮ อื เกือฮ ไก เน่อึม ไม่ ไก โปลก อื, ยุฮ อื เกือฮ ตอก ปุ แตะ เตือง แลฮ กัก อื. ");
INSERT INTO lcp_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ป มัฮ โฆง ออม เซ ยุฮ โรฮ ฮุป เตีย ตอก เตีย อาละมัน นึง อื ปาวน โพรยฮ. ยุฮ โรฮ เน่อึม อื ไม่ โปลก อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","22","นึง ฆรึม กัก อื เซ เตือง ลอวย กู อื, แตม โรฮ ฮุป เตีย ปอป นึง อื เตือง แลฮ กัก อื, เกือฮ กัก อื เซ ย่อง ติ แตะ ราว ฮุป เตีย ปอป เซ. โอเอีฮ โม เซ ยุฮ อื นึง ไคร ซโน. ยุฮ อื เกือฮ รติต ปุ แตะ ไม่ โฆง อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ยุฮ โรฮ ออม นึง เปือง กัก อื เซ เตือง อาแลฮ กัก อื, ยุฮ โรฮ มิตญัป ละ ญัป ปุย กอย นึง ออม เซ, ไม่ ทัต ละ อาึง ปุย มิตญัป เซ, ยุฮ อื นึง ไคร ซโน. ");
INSERT INTO lcp_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ออม เซ ไม่ เครอึง โกว อื ละ เพรียง แตะ ออม เซ, ยุฮ อื นึง ไคร ซโน นัมนัก ติ ตะลัน. ");
INSERT INTO lcp_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ฟวยจ เซ ยุฮ คัน ละ ซ ทไว ปุย ป ซออย ฮงาื นึง ละ พะจาว. ยุฮ อื นึง โคะ กทิน, ลั่ง ติ รเนฮ, เวือฮ ติ รเนฮ. ยุฮ อื เกือฮ ซี เลียม, เกือฮ อื ฮลาวง ลอา รเนฮ. โด่วง ป ไก นึง โจง คัน เซ มัฮ เอิน โคะ ติ ตอน ไม่ คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","คัน เซ อัป อื นึง ไคร ซโน, เตือง ลวง ราว, ลวง เฆียง อื เตือง ปาวน ลวง อื เซ, ไม่ นึง โด่วง อื เซ โรฮ, ยุฮ โรฮ คอป ไคร ป ไก ลวตไล นึง อื รวิต คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","โล แม ไคร แปน โวงๆ แตะ ลอา โวง, ดุฮ อื นึง ฆรึม คอป ป ไก ลวตไล เซ เตือง ลอา ก บลัฮ อื. เกือฮ อื อาวต ซื นา ปุ แตะ, ละ ซ เกือฮ อื แปน ควน ซลอ ปุย โคะ ลกลอม อื เซ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","ยุฮ แม โคะ ลกลอม อื นึง โคะ กทิน, อัป อื นึง ไคร. ");
INSERT INTO lcp_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","ฟวยจ เซ เพรียง ลออยฮ ซัมคัน ละ ซ โกว แตะ ละ เรฮ แตะ นึง ปุย ไม่ นึง โอเอีฮ ซัมคัน. เพรียง โรฮ ป ซออย ฮงาื ละ ซ โกว ปุย ตัม ป เอีจ กอ ยุฮ โม ป เกง นึง เพรียง แตะ ป ซออย ฮงาื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","เญือม เซ ยุฮ แม คัน ทไว ละ ซ แปน อื ควน ตอง ปุย ทไว โอเอีฮ นึง, ยุฮ อื นึง โคะ กทิน, เกือฮ อื ลั่ง พอน รเนฮ, เวือฮ พอน รเนฮ, ฮลาวง ลอวย รเนฮ, ซี เลียม ไมจ เอิน คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ยุฮ โรฮ โด่วง อื นึง โจง อื เตือง ปาวน โจง อื, โด่วง อื เซ มัฮ เอิน โคะ ติ ตอน ไม่ โคะ ยุฮ อื คัน ทไว เซ. ฟวยจ เซ อัป คัน เซ นึง ไร ซเงี. ");
INSERT INTO lcp_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","ฟวยจ เซ ยุฮ แม โดง, ควน ชาวก จะ, เชือม โบลง, ไร ควน มั่ก โตะ, ไม่ ทัต ควน รฮา ปุย งอ, ละ ซ โกว ปุย อื นึง คัน ทไว เซ. โอเอีฮ โม เซ เตือง โอยจ อื ยุฮ อื นึง ไร ซเงี. ");
INSERT INTO lcp_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","ยุฮ โรฮ ตาแซง นึง ไร ซเงี, ฟวยจ เซ ดุฮ อื กไน คัน เซ. เกือฮ อื อาวต ฆรึม คอป ป ไก ลวตไล เซ, ไม่ เกือฮ อื อาวต กไน คัน เซ โด่ะ ฮอยจ เคียง บั่กบ่วน คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","โล ไร ซเงี แปน โวงๆ แตะ ปาวน โวง, ดุฮ อื นึง โจง คัน เซ เตือง ปาวน โจง อื ละ ซ แปน อื ควน ซลอ ปุย โคะ ลกลอม นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ยุฮ โรฮ โคะ ลกลอม อื, ยุฮ อื นึง โคะ กทิน, อัป อื นึง ไร ซเงี. ");
INSERT INTO lcp_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ฟวยจ เซ ซลอ อาึง โคะ ลกลอม อื เซ นึง โตะ ฮยวก ป ไก ลวง เฆียง คัน เซ ละ ซ กลอม ปุย อื. ยุฮ คัน เซ นึง โคะ เตีป ระ แพน, กไน อื ปังเมอ เกือฮ อื ลอาวง. ");
INSERT INTO lcp_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","ฟวยจ เซ ยุฮ อาง อาวต รอาวม ติ โม่ว, ยุฮ อื ไม่ ควน โบลวง อื, ยุฮ อื นึง ไร ซเงี. ไร ซเงี เซ มัฮ ป ทไว โม ปรโปวน ป รซอฮ ละ พะจาว โบ โตะ รเวือะ พากัง. เอีจ มัฮ ไร ซเงี เซ ป โกว ปุย ไพรม ตัง ซแฆล ตอฮ ฮอ. ");
INSERT INTO lcp_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","เญือม เซ ปุย ยุฮ โรฮ ควง พากัง ระ เซ โรฮ, ฆรุง ลวง ลั่กเซฮ อื เกือฮ อื ไก พา เฆีญ, ไตญ พา แนน ไมจ ละ อื เกือฮ อื ลั่ง ติ รอย รเนฮ. ");
INSERT INTO lcp_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","เกือฮ อื ไก ลัก ง่า โฆง, ยุฮ โรฮ อื ไม่ ควน โบลวง ลัก เซ ง่า โรฮ, ยุฮ อื นึง ไร ซเงี. โคะ รมั่ก อื ไม่ ควน โฮมวต ลัก อื เซ ยุฮ อื นึง มาื. ");
INSERT INTO lcp_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ลวง ลั่กล่าวง อื ลั่ง โรฮ ติ รอย รเนฮ. ไก โรฮ ลัก ง่า โฆง, ไม่ ควน โบลวง ลัก อื ป มัฮ ไร ซเงี เซ ง่า โรฮ, โคะ รมั่ก ติต ลัก เซ ไม่ ควน โฮมวต ลัก เซ, ยุฮ โรฮ อื นึง มาื. ");
INSERT INTO lcp_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ป มัฮ ลวง ลั่ก เลียก ซเงะ นึง อื, ยุฮ พา เฆีญ อื เกือฮ อื ลั่ง รฮอน รเนฮ. ยุฮ ลัก อื กาว โฆง, ไม่ ควน โบลวง ลัก อื เซ กาว โรฮ, โคะ รมั่ก อื ไม่ ควน โฮมวต ลัก อื เซ ยุฮ โรฮ อื นึง มาื. ");
INSERT INTO lcp_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ลวง ลั่ก โอก ซเงะ ป มัฮ ควง ลั่กกา อื เวือฮ รฮอน รเนฮ. ");
INSERT INTO lcp_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","พา ละ เฆีญ ปุย เฆียง โตะ รเวือะ อื ติ ติ ก บลัฮ ฮา, เกือฮ อื ลั่ง กาว โรฮ พอน รเนฮ. ยุฮ ลัก อื ลอวย โฆง, ไม่ ควน โบลวง ลัก อื ลอวย โรฮ. ยุฮ อื ตอก เซ เตือง ลอา ก บลัฮ รเวือะ เลียก ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","พา เฆีญ ควง อื รวิต อื เซ, ยุฮ อื นึง พา แนน ไมจ. ");
INSERT INTO lcp_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ควน โบลวง ลัก อื เซ ยุฮ อื นึง ไร ซเงี, โคะ รมั่ก อื ไม่ ควน โฮมวต ลัก อื เซ ยุฮ อื นึง มาื. ป มัฮ ควน ครุป เปือง ลัก เซ อัป โรฮ อื นึง มาื. ลัก ควง อื เซ โครยญ โฆง อื, ไก ตื ควน โฮมวต, ยุฮ อื นึง มาื. ");
INSERT INTO lcp_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","นึง โตะ รเวือะ เลียก ปุย นึง เซ, ดุฮ โรฮ พา เฆีญ อื. ไอฮ พา แนน ไมจ ละ อื, ป ไตญ ปุย นึง กอย ซี ฟะ, ซี ซูวัน, ไม่ ซี ซครัก. เกือฮ โรฮ โม ชัง ป เกง ละ ยุฮ แตะ ลวตไล โอเอีฮ ดุฮ ลวตไล นึง อื. พา เซ ลั่ง ง่า รเนฮ, ฮลาวง พอน รเนฮ เบรียง ไม่ พา เฆีญ ควง อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ไก ลัก ปาวน โฆง ไม่ ควน โบลวง ลัก เซ ปาวน โรฮ ยุฮ อื นึง ไร ซเงี. โคะ รมั่ก ควน มัก พา ไม่ ควน โฮมวต ลัก เซ ยุฮ อื นึง มาื. ป มัฮ เปือง ลัก เซ อัป โรฮ อื นึง มาื. ");
INSERT INTO lcp_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ลัก ป เกอึม ปุย ละ เคิง แตะ พากัง เซ, ไม่ ลัก โบลวง ปุย รวิต ควง พากัง ระ เซ, ยุฮ อื นึง ไร ซเงี เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","เฮี มัฮ บั่นชี ไลลวง ตอก ยุฮ ปุย พากัง ระ, ป มัฮ นา ก อาวต ฮิต ลปุง ซันญา ยุฮ พะจาว เซ. มัฮ ป ไซฮ โม เลวี ตัม ป ดวน ไอ โมเซ อื ไซฮ. ป มอง ควป คุม กัน ยุฮ อื เซ, มัฮ อิทามา กวน รเมะ ซตุ อาโรน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","เบ่ซาเลน เอีจ ยุฮ อื ตัม ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ โครยญ เจือ. เบ่ซาเลน เซ มัฮ กวน อุรี, อุรี เซ มัฮ กวน เฮอ, ป มัฮ เจอ ยูด่า. ");
INSERT INTO lcp_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ป ยุฮ ดิ กัน ไม่ เบ่ซาเลน เซ มัฮ โอโฮลีอัป, กวน อาฮิซะมัก ป มัฮ เจอ ด่าน. ปุย เซ มัฮ ชัง ป เกง ละ ยุฮ แตะ ลวตไล โอเอีฮ, ไม่ เกง อื ละ ไตญ แตะ พา แนน ไมจ นึง กอย ซี ฟะ, ซี ซูวัน ไม่ ซี ซครัก. ");
INSERT INTO lcp_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ไคร ป โกว ปุย ละ ยุฮ แตะ พากัง ระ เซ, มัฮ ไคร ป โรวก ปุย ทไว ละ พะจาว. นัมนัก ไคร เซ เตือง โอยจ อื ไก 29 ตะลัน, ไปล 730 เชเคน, ตัม เชเคน โกว ปุย นึง ฮอง ซัมคัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","มาื ป โรวก ปุย ทไว เซ เตือง โอยจ อื ไก นัมนัก 100 ตะลัน, ไปล 1,775 เชเคน, ตัม เชเคน โกว ปุย นึง ฮอง ซัมคัน เซ. ");
INSERT INTO lcp_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","มาื โรวก ปุย ทไว เซ มัฮ ติ ปุย ติ เบ่คา. (ติ เบ่คา เซ มัฮ บลัฮ เชเคน ตัม เชเคน โกว ปุย นึง ฮอง ซัมคัน เซ.) มาื เซ มัฮ ป เกป อื นึง โม ปรเมะ ป ฮอยจ โจต เซน แตะ เซ โครยญ โฆะ ปุย, เมาะ ป เอีจ ไก อาญุ อื เคียง ง่า เนอึม ฮาวก ก ล่าวง. ปรเมะ โม เซ เตือง โอยจ อื ไก 603,550 ปุย. ");
INSERT INTO lcp_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","มาื ตา 100 ตะลัน เซ, โล ปุย ละ ควน โบลวง ด่อง ฮอง ซัมคัน เซ ไม่ ละ ควน โบลวง ด่อง พา รฆุน ฮอง ซัมคัน เซ. ควน โบลวง ด่อง เซ ไก ติ รอย. ปุย โกว มาื ละ อื 100 ตะลัน, ปุก ติ โฆง ติ ตะลัน. ");
INSERT INTO lcp_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","ป มัฮ มาื 1,775 เชเคน เซ, ยุฮ ควน มั่ก ป ติต ไม่ ด่อง เซ นึง อื ไม่ อัป อื เปือง ลัก นึง, ไม่ ควน โฮมวต ด่อง เซ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ไร ซเงี ป โรวก ปุย ทไว เซ เตือง โอยจ อื ไก นัมนัก 70 ตะลัน ไปล 2,400 เชเคน. ");
INSERT INTO lcp_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ไร ซเงี นึง อื เซ โกว อื ละ ยุฮ แตะ ควน โบลวง รเวือะ คระ เลียก ปุย โตะ ฮอง ซัมคัน เซ, ยุฮ โรฮ คัน ไร ซเงี นึง อื ไม่ ยุฮ อื ตาแซง ละ ดุฮ อื กไน คัน ตอง ปุย ทไว โอเอีฮ เซ, ไม่ เครอึง โกว ปุย ละ คัน เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ยุฮ โรฮ ควน โบลวง ลัก นึง อื รวิต พากัง ระ เซ, ไม่ ยุฮ อื ควน โบลวง ปุย รเวือะ คระ เลียก ปุย นึง อื ไม่ ลัก เกอึม ปุย ละ เคิง แตะ พากัง เซ นึง เตือง โอยจ อื, ไม่ ลัก เกอึม ปุย รวิต ควง อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","เญือม เซ ปุย ไตญ เครอึง ละ โม ซตุ, ไตญ อื นึง กอย ซี ฟะ, ซี ซูวัน, ไม่ ซี ซครัก, ละ ซ เกือฮ อื จาวป อื เญือม รซอฮ อื ละ พะจาว นึง ฮอง ซัมคัน เซ. ยุฮ โรฮ เครอึง ซัมคัน ละ อาโรน ตัม ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","ยุฮ ลปิ เอโฟต ละ อื นึง ไคร, ไม่ นึง กอย บิญ ไม่ กอย ซี ฟะ, ซี ซูวัน ไม่ ซี ซครัก. ");
INSERT INTO lcp_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","เกือฮ โม ชัง ป เกง ละ ยุฮ แตะ ลวตไล โอเอีฮ ยุฮ อื, เกือฮ อื แตม ไคร เกือฮ เฮรีๆ เกือฮ อื ไก แปน แพนๆ แตะ. ฟวยจ เซ ญัป แม อื เกือฮ ไก แปน เซนๆ แตะ ละ ซ ไตญ อื เกือฮ เลียก ดิ ไม่ กอย บิญ เซ ไม่ กอย ซี ฟะ ซี ซูวัน, ไม่ ซี ซครัก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ยุฮ โรฮ แคป นึง ซอังปา ลปิ เอโฟต เซ, เกือฮ อื ติต นึง เฆียง ลวง ก ล่าวง อื เตือง ลอา ก บลัฮ อื, ละ ซ เกือฮ อื พา ลอา ปลัฮ เซ รติต แปน ติ. ");
INSERT INTO lcp_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","เกือฮ โรฮ โม ชัง ป ไมจ ฟีมื ไตญ พา ปุก ญวย อื ละ ซ ปุก อื ราว ลปิ เอโฟต เซ, เดอึม ลปิ เอโฟต เซ ซ เกียฮ รติต ไม่ ปุ แตะ. ยุฮ โรฮ อื เกือฮ ไมจ ตอก ยุฮ แตะ ลปิ เอโฟต เซ โรฮ, ยุฮ โรฮ อื นึง ไคร, ไม่ กอย ซี ฟะ ซี ซูวัน ซี ซครัก ไม่ พา ไตญ ปุย นึง กอย บิญ, ตัม ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","โกว โรฮ แกว พรุยฮ ละ ซ รปาึง แตะ นึง ไคร ป ไก ลวตไล เซ, เกือฮ โรฮ โม ชัง แกะ ซลัก, ดุฮ มอยฮ โม กวน รเมะ อิซราเอน นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ฟวยจ เซ ติต อื ไม่ แคป ลปิ เอโฟต เซ ละ ซ เกือฮ อื แปน ควน ไตม ปุย โม กวน อิซราเอน เซ, ตัม ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","ฟวยจ เซ ยุฮ แม ควน เลอึป รน่าวก, เกือฮ โรฮ โม ชัง ป ไมจ ฟีมื ยุฮ อื ละ แตะ ตอก ยุฮ อื ลปิ เอโฟต เซ โรฮ. ยุฮ อื นึง ไคร, ไม่ กอย ซี ฟะ, ซี ซูวัน, ซี ซครัก, ไม่ พา แนน ไมจ, ป ไตญ ปุย นึง กอย บิญ. ");
INSERT INTO lcp_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ควน เลอึป รน่าวก เซ ฮนุป แฮนป อื เกือฮ โฆป ติ แตะ ลอา จัน. เญือม เอีจ ฟวยจ ฮนุป แฮนป อื, ลวง ลั่ง ลวง เงี่ยง อื ไก ติ เดือะ เมาะ ปุ แตะ, แปน ปาวน เลียม พัต โมน. ");
INSERT INTO lcp_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ควน เลอึป รน่าวก เซ รปาึง แกว นึง อื ปาวน เดี่จ. เดี่จ รกา อื มัฮ แกว ซครัก, ไม่ แกว ซเงี, ไม่ แกว ซงา. ");
INSERT INTO lcp_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","เดี่จ ลอา อื มัฮ แกว รัง ไม่ แกว มฮานิน, ไม่ แกว ปิญ. ");
INSERT INTO lcp_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","เดี่จ ลอวย อื มัฮ แกว ซี โชมพู, ไม่ แกว ตอง เนะ ไม่ แกว ซี ซูวัน. ");
INSERT INTO lcp_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","เดี่จ ปาวน อื มัฮ แกว ซงา จัว, ไม่ แกว พรุยฮ ไม่ แกว ซลอง ไง่ แมว. แกว โม เซ เตือง โอยจ อื, รปาึง อื นึง ไคร ป แตม ปุย ลวตไล โอเอีฮ นึง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","แกว กาว ลอา โนง เซ มัฮ รโตง กวน อิซราเอน เตือง กาว ลอา ปุย อื. แกว เซ โครยญ โนง อื ไก มอยฮ เจอ โม อิซราเอน นึง, ติ โนง ติ เจอ เตือง กาว ลอา เจอ อื. ");
INSERT INTO lcp_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ฟวยจ เซ ยุฮ แม โม่ะ บวน นึง ไคร ซโน, ยุฮ อื ลอา เซน, ละ ซ ตาึก อื ควน เลอึป รน่าวก เซ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","ยุฮ แม ไคร เกือฮ อื ไก ลวตไล, ยุฮ อื ไม่ ไคร แปน โวง อื ลอา โวง. ติต อาึง อื นึง โจง ควน เลอึป รน่าวก เซ เตือง ลอา โจง อื. ");
INSERT INTO lcp_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","เกือฮ โม่ะ ไคร เซ มั่ก ปุ แตะ ไม่ โวง ไคร ป อาวต นึง โจง ควน เลอึป รน่าวก เซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","เปือง โม่ะ ไคร เซ ติ ก บลัฮ อื แม, เกือฮ อื มั่ก ปุ แตะ ไม่ ควน มั่ก ป ติต นึง แคป ซอังปา ลปิ เอโฟต ลวง ลั่กกา อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ฟวยจ เซ ยุฮ แม ไคร แปน โวง อื ลอา โวง, ติต อาึง อื นึง โจง ลวง ฆรึม ควน เลอึป รน่าวก เซ, เกือฮ อื อาวต ลวง กไน อื, ก ติต อื ไม่ ลปิ เอโฟต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ยุฮ แม ไคร ลอา โวง. ติต อาึง อื นึง เฆียง ลปิ เอโฟต เซ ลวง ลั่กกา อื เกือฮ อื อาวต นึง โบ โฆลว ลปิ เอโฟต เซ, ลวง ราว พา ปุก ญวย ป ไตญ ปุย เกือฮ ไมจ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","ฟวยจ เซ แกน กอย ซี ฟะ เกือฮ แปน โม่ะ ละ โจก อื ควน เลอึป รน่าวก เซ เกือฮ ติต ไม่ ลปิ เอโฟต เซ, เดอึม ควน เลอึป รน่าวก เซ โอ ซ รกัฮ ฮา ลปิ เอโฟต เซ ฆาื อื. เกือฮ ควน เลอึป รน่าวก เซ อาวต ราว พา ปุก ญวย เซ, ตัม ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","โม เซ เกือฮ ป ไมจ ฟีมื ไตญ ลปิ ดา ละ ซ จาวป อื กไน ลปิ เอโฟต เซ, ไตญ อื นึง กอย ซี ฟะ เตือง ปลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","แปฮ โตะ โงก อื เกือฮ ปุก บั่กบ่วน ลปิ เซ. ฟวยจ เซ ยุฮ แม แคป โงก อื นึง พา ไตญ ปุย, เดอึม โอ ซ แฌฮ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","นึง โฆลว ชวง ลปิ เซ ตาึก ฮุป เปลิ ทัปทิม ป ยุฮ ปุย นึง กอย ซี ฟะ, ซี ซูวัน, ซี ซครัก, ไม่ พา แนน ไมจ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ฟวยจ เซ ยุฮ แม โพรยญ ละ อื นึง ไคร ซโน. ดุฮ รซอ โพรยญ เซ ไม่ ฮุป เปลิ ทัปทิม เซ นึง โฆลว ชวง ลปิ ดา เซ รวิต อื. ");
INSERT INTO lcp_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ดุฮ โพรยญ นึง อื ติ โนง. ดุฮ แม ฮุป เปลิ ทัปทิม นึง อื ติ โนง, รซอ อื ตอก เซ. ลปิ เซ มัฮ ละ จาวป อื เญือม รซอฮ อื ละ พะจาว, ตัม ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","ปุย โม เซ ยุฮ ลปิ ละ อาโรน ไม่ โม กวน รเมะ อื, เกือฮ โม ชัง ป ไมจ ฟีมื ยุฮ อื นึง พา แนน ไมจ. ");
INSERT INTO lcp_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ยุฮ โรฮ วอม ละ อื, ไม่ โคะ ไฆญ ไมจ, ไม่ แว, ยุฮ ตื อื นึง พา แนน ไมจ. ");
INSERT INTO lcp_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ยุฮ พา ปุก ญวย ละ อื นึง พา แนน ไมจ, ไม่ กอย ซี ฟะ, ซี ซูวัน ไม่ ซี ซครัก, ตัม ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","ปุย โม เซ ยุฮ แพน ซัมคัน ละ อื นึง ไคร ซโน, แปน ควน ไม ซตุ แปน ป ซัมคัน นึง โคะ ไฆญ อื. ดุฮ รซอม นึง อื ตอก เฮี, “ป ซง่ะ ซงอม ละ พะจาว,” อัฮ เซ รซอม เซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ฟวยจ เซ แกน กอย ซี ฟะ ละ อื, ปุก แพน ไคร ซัมคัน เซ นึง อื, เกือฮ อื รติต ไม่ โคะ ไฆญ ไมจ เซ ตัม ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","กัน ยุฮ ปุย พากัง ระ ก ฮอยจ ปุย เคะ พะจาว เซ เอีจ ฟวยจ เตือง โอยจ อื. พะจาว ซตอก อาึง อื ละ ไอ โมเซ ตอก ออฮ, โม อิซราเอน เอีจ ยุฮ เนอึม อื เกือฮ ฟวยจ ตอก เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","เญือม เซ ปุย มอป พากัง ระ เซ ละ ไอ โมเซ, เตือง พา เลอึป อื ไม่ เครอึง โกว ปุย ละ พากัง เซ, ป มัฮ โคะ รมั่ก อื, ไมะ แปน ละ เดีญ อื, โคะ ซแก ซปา เดีญ อื, ลัก เดีญ อื, ควน โบลวง ลัก อื, ");
INSERT INTO lcp_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","เครอึง โกว ปุย ละ พรัง อื, ป มัฮ ฮัก แกะ ญอม ปุย นึง ซี ซครัก, ฮัก กะ โลมา, ไม่ พา เฆีญ โตะ รเวือะ, ");
INSERT INTO lcp_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","มัฮ แม ฮิต ลปุง ซันญา ยุฮ พะจาว, ไม่ โคะ ลกลอม ฮิต เซ, ไม่ รเดือป ฮิต ซัมคัน เซ, ");
INSERT INTO lcp_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","โตะ อาวต คโนมปัง ไม่ เครอึง โกว ปุย นึง อื, ไม่ คโนมปัง ป อาึง ปุย ซองนา พะจาว นึง ราว โตะ เซ, ");
INSERT INTO lcp_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","มัฮ แม ชวง ออม ไคร ซโน ป ไก กัก อาแลฮ, ไม่ ออม อาวต นึง เปือง กัก อื เซ, ไม่ ลออยฮ ละ ดุฮ ปุย นึง ออม เซ, ");
INSERT INTO lcp_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","มัฮ แม คัน ไคร, ไม่ ลออยฮ ซัมคัน ละ เรฮ อื นึง ปุย. ไม่ ป ซออย ฮงาื ละ ตอง ปุย ทไว, ไม่ พา ละ เฆีญ ปุย โตะ รเวือะ พากัง เซ. ");
INSERT INTO lcp_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","มัฮ แม คัน ยุฮ ปุย นึง ไร ซเงี, ไม่ ตาแซง ป ยุฮ ปุย นึง ไร ซเงี ละ ดุฮ ปุย อื นึง คัน เซ โรฮ, มัฮ แม โคะ ลกลอม ปุย อื, ไม่ เครอึง โกว ปุย นึง คัน เซ เตือง โอยจ อื, ไม่ อาง รอาวม, ไม่ ควน โบลวง ปุย อาง เซ, ");
INSERT INTO lcp_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","มัฮ แม พา ละ เฆีญ ปุย ควง พากัง, ไม่ ลัก อื ไม่ ควน โบลวง ลัก อื, ไม่ พา ละ เฆีญ โตะ รเวือะ ควง อื, ไม่ โม่ะ ปุก ปุย พากัง เซ, มัฮ แม ลัก เกอึม ปุย ลวง เฆียง อื รวิต อื ไม่ เครอึง โกว ปุย ละ พากัง เซ เตือง โอยจ อื, ");
INSERT INTO lcp_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","มัฮ แม เครอึง แนน ไมจ, ละ จาวป โม ซตุ อื เญือม เลียก รซอฮ อื ละ พะจาว นึง ฮอง ซัมคัน เซ, มัฮ โรฮ เครอึง ซัมคัน คึนัก ละ จาวป อาโรน อื ไม่ เครอึง ละ จาวป โม กวน อาโรน อื เญือม เอีจ โฮลฮ อื แปน ซตุ. ");
INSERT INTO lcp_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","โอเอีฮ เมาะ ป เอีจ ซตอก พะจาว อาึง ละ ไอ โมเซ เซ, โม อิซราเอน เอีจ ยุฮ เนอึม อื เกือฮ ฟวยจ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ไอ โมเซ ซาวป กวต แลน กัน ยุฮ ปุย โม เซ. เญือม ยุ อื เอีจ ปุน ยุฮ ปุย อื ตัม ป ซตอก พะจาว อาึง ละ แตะ เกือฮ ฟวยจ โครยญ เจือ ตอก เซ เยอ, ไอ โมเซ ปิฮ มุ่น ละ โม ป ยุฮ กัน เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“เญือม เอีจ ฮาวก เคิ ติ ซเงะ ติ นึง อื, ไมจ เปอะ โบลวง พากัง ระ ป มัฮ นา ก โฮลฮ ปุย ฮอยจ เคะ อาึ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ไมจ เปอะ อาึง ฮิต อาวต ลปุง พะจาว โตะ พากัง เซ. รฆุน กไน อื นึง พากัง ติ. ");
INSERT INTO lcp_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ไมจ เปอะ โรวก โตะ คโนมปัง ไม่ เครอึง ลัง อาวต ราว อื เกือฮ อาวต โตะ พากัง เซ. โรวก โรฮ ชวง ออม เซ เกือฮ ออม นึง อื อาวต เบือง ก ลัง อาวต แตะ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ป มัฮ คัน ไคร นา ก ตอง ปุย ป ซออย ฮงาื เซ เกือฮ อาวต ลั่กกา ฮิต อาวต ลปุง พะจาว. กัง แม พา เฆีญ โตะ รเวือะ พากัง ระ เซ.” ");
INSERT INTO lcp_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“คัน ตอง ปุย ซัตซิง นึง เซ, โบลวง อาึง ลั่กกา โตะ รเวือะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","โบลวง โรฮ อาง ระ เซ เกือฮ อาวต ซน่ะ พากัง ไม่ คัน เซ. เชียต ดุฮ รอาวม นึง เกือฮ นาวก. ");
INSERT INTO lcp_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","โบลวง แม ฆรุง พา รวิต ควง พากัง ระ เซ. กัง พา เฆีญ โตะ รเวือะ เลียก ปุย นึง ควง เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ฟวยจ เซ ไมจ แม เปอะ ตุย ลออยฮ ซัมคัน เซ, เรฮ นึง พากัง ไม่ โอเอีฮ นึง อื โครยญ เจือ. เกือฮ แปน โอเอีฮ ซัมคัน ทไว ปุย ละ อาึ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","เรฮ ลออยฮ เซ นึง คัน ตอง ปุย ซัตซิง นึง ไม่ เครอึง โกว ปุย นึง อื เกือฮ แปน ป ตึก นึง ซัมคัน แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","เรฮ โรฮ ลออยฮ เซ นึง อาง ระ เซ ไม่ ชวง อื เกือฮ โรฮ แปน ป ซัมคัน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“ไมจ เปอะ เกือฮ อาโรน ไม่ กวน รเมะ อื ฮอยจ นึง โตะ รเวือะ พากัง ระ เซ. ฟวยจ เซ ไมจ เปอะ รไซจ นึง รอาวม เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ฟวยจ รไซจ เปอะ ไมจ เปอะ จาวป เครอึง ซัมคัน เซ ละ อาโรน. ฟวยจ เซ เรฮ ลออยฮ เซ นึง, เกือฮ แปน ปุย ซัมคัน ละ พะจาว เดอึม ซ เกียฮ แปน ซตุ. ");
INSERT INTO lcp_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","เกือฮ โรฮ กวน อื ฮอยจ. ฟวยจ เซ จาวป ลปิ ซตุ ละ. ");
INSERT INTO lcp_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","เรฮ โรฮ ลออยฮ นึง ตอก เปือะ อื เซ โรฮ เดอึม ซ เกียฮ รซอฮ ละ อาึ นึง กัน แปน อื ซตุ เซ. มัฮ ไล ตอก เซ ป ไมจ เปอะ ยุฮ ละ ซ เกือฮ เปอะ กวน อื ไม่ กวนโซะ กวน แซะ อื แปน ซตุ ละ อาึ ฮอยจ เฆียง เฮี โครยญ เจน ปุย,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ไอ โมเซ ยุฮ เนอึม โอเอีฮ ตัม ป เอีจ ซตอก พะจาว อาึง ละ แตะ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","เญือม เอีจ ไคว อื ติ เนอึม ฟวยจ โอก อื ฮา เมือง อียิป เซ, ปุก เคิ ติ ซเงะ ติ นึง อื, ไอ โมเซ เกือฮ เนอึม ปุย โบลวง พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","เญือม โบลวง อื ดุฮ ควน โบลวง เดีญ อื รกา. ฟวยจ เซ โบลวง เดีญ อื, ดุฮ แม โคะ ซแก เดีญ อื. ฟวยจ เซ โบลวง ด่อง อื. ");
INSERT INTO lcp_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","กัง พา เลอึป อื. เลอึป แม ก พริ อื นึง ฮัก โอเอีฮ, ตัม ป เอีจ ซตอก พะจาว อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ไอ โมเซ โรวก เนอึม แพน ซโมะ ป ไก ลปุง พะจาว นึง เซ อาึง อื โตะ ฮิต. เกือฮ โคะ ลกลอม อื ติต ไม่ ฮิต เซ. รเดือป ฮิต ป มัฮ นา ก โฮลฮ พะจาว ยวก มั่ป ละ ปุย เซ อาึง อื ราว ฮิต เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","เญือม เซ เกือฮ ฮิต เซ อาวต กไน พากัง. กัง พา ลั่กกา ฮิต เซ ละ ซ เฆีญ อื ฮิต เซ ฮา ปุย, ตัม ป เอีจ ซตอก พะจาว อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","อาึง โรฮ โตะ อาวต คโนมปัง กไน พากัง ระ เซ ลวง ลั่กล่าวง อื ก พริ พากัง รฆุน อื เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","อาึง โรฮ คโนมปัง นึง อื ตัม ไล แตะ ซองนา พะจาว, ตัม ป เอีจ ซตอก พะจาว อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","อาึง โรฮ ชวง ออม รเตือป โตะ เซ กไน พากัง ระ ลวง ลั่กเซฮ อื. ");
INSERT INTO lcp_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","อาึง ออม อาแลฮ เซ นึง เปือง กัก อื ซองนา พะจาว ตัม ป เอีจ ซตอก พะจาว อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","อาึง โรฮ คัน ไคร ลั่กกา พากัง รฆุน อื เซ กไน พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","ตอง เนอึม ป ซออย ฮงาื นึง อื ตัม ป เอีจ ซตอก พะจาว อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","กัง โรฮ พา นึง โตะ รเวือะ เลียก ปุย นึง พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ก พริ พากัง ระ ก ซดิ โบ โตะ รเวือะ เซ, ไอ โมเซ อาึง คัน ระ นา ก ตอง ปุย ซัตซิง ละ พะจาว นึง อื. มอก ตอง ทไว ซัตซิง นึง อื ไม่ เฮงาะ รโกะ ตัม ป เอีจ ซตอก พะจาว อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","อาึง โรฮ อาง ระ ซน่ะ คัน ไม่ พากัง ระ เซ. เชียต ดุฮ รอาวม นึง อื ละ ซ รไซจ โม ซตุ ติ แตะ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ไอ โมเซ ไม่ อาโรน ไม่ กวน อาโรน เนอ โกว รอาวม เซ ละ รไซจ อื เตะ ชวง แตะ นึง. ");
INSERT INTO lcp_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","เญือม ซ เลียก โม ซตุ นึง พากัง ระ ก ฮอยจ ปุย เคะ พะจาว เซ, ไม่ เญือม ซ เลียก อื ละ คัน ระ เซ, ซ โกว รอาวม เซ ละ รไซจ อื เตะ ชวง แตะ รกา. มัฮ ยุฮ อื ตัม ป เอีจ ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ฟวยจ เซ ไอ โมเซ โบลวง ฆรุง พา รวิต พากัง ระ เซ ไม่ คัน เซ. กัง โรฮ พา นึง โตะ รเวือะ ฆรุง เซ โรฮ. ไอ โมเซ ยุฮ เนอึม กัน เซ เกือฮ ฟวยจ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","เญือม เซ ฮอยจ เอิน ชุต รวู นึง, เลอึป พากัง ระ เซ. รัง ซเปีย ยุฮ พะจาว เลียก อาวต กไน พากัง เซ, รัง เนอึม รัง แนม. ");
INSERT INTO lcp_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","เญือม เซ ไอ โมเซ เกียฮ เลียก โตว กไน พากัง ระ เซ นึง เลีฮ อาวต ชุต รวู นึง อื. รัง ซเปีย ยุฮ พะจาว อาวต กไน พากัง เซ เลี่ป อื. รัง เนอึม รัง แนม. ");
INSERT INTO lcp_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","เคียง เซ เยอ โม อิซราเอน เญือม ชวน อื ฮาวก ชุต รวู ฮา พากัง ระ เซ เญือม ออฮ ซ โอก โฮว นึง คระ เญือม เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ดัฮ ชุต รวู เซ โอ ฮาวก โฮลฮ โตว โฮว ฆาื อื. อาวต แนฮ ฮอยจ ละ ฮาวก ชุต รวู เซ. ");
INSERT INTO lcp_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ชุต รวู ยุฮ พะจาว อาวต ราว พากัง เซ เมือ ซเง่ะ อื. เมือ ก ซาวม อื ชุต รวู เซ แปน งอ ละ อื. ติ เจน โฮว อื นึง คระ เซ โม อิซราเอน โฮลฮ ลอป ชวน อื ตอก เซ.");
INSERT INTO lcp_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ติ โฮน อื พะจาว กอก ลปุง ไม่ ไอ โมเซ เน่อึม นึง โตะ พากัง ก ฮอยจ ปุย เคะ พะจาว เซ, อัฮ เฮี ละ อื, ");
INSERT INTO lcp_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, ‘เญือม โรวก เปอะ ทไว ซัตซิง ละ พะจาว เยอ, โรวก เปอะ โมวก แปน, โรวก เปอะ แกะ ปิ แปน.’ ");
INSERT INTO lcp_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ดัฮ มัฮ โมวก ป โรวก ปุย ตอง ทไว ละ พะจาว เยอ, ไมจ อื เลือก โรวก ทไว ป โปก อื, ไม่ โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม. เกือฮ เมือะ โรวก อื ฮอยจ นึง โตะ รเวือะ พากัง ระ เซ, เดอึม ปุย เซ ซ แปน ปุย ปุก รพาวม พะจาว ฆาื. ");
INSERT INTO lcp_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","เกือฮ โรฮ ปุย เซ ย่อง เตะ แตะ ราว ไกญ ซัตซิง ทไว แตะ เซ, เดอึม ป ทไว อื เซ ซ ปุก รพาวม พะจาว ไม่ ซ แปน เนอึม อื ควน รไซจ พิต โฌวะ ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","เกือฮ โรฮ ปุย เซ ยุฮ ยุม ไม่ โมวก เซ ซองนา พะจาว. ป มัฮ ซตุ กวน อาโรน เซ ซ โรวก ทไว ฮนัม อื ละ พะจาว, ไม่ ซ ซพรอต อื ฮนัม เซ นึง คัน ทไว ป อาวต ซื นา รเวือะ พากัง เซ ปอ ไคว อื ยุฮ คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","เกือฮ โรฮ ปุย เซ ปอฮ ฮัก ซัตซิง ทไว แตะ เซ เกือฮ โอก โอยจ. ป มัฮ เนะ อื เซ, เกือฮ มอก อื แปน ตอน แปน ตอน อื. ");
INSERT INTO lcp_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","ซตุ ป มัฮ กวน อาโรน เซ ซ แพรฮ งอ นึง คัน เซ, ซ ดุฮ โรฮ เคิ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ฟวยจ เซ ซ อาึง เนะ ซัตซิง มอก ปุย เซ เตือง ไกญ อื ไม่ ลออยฮ อื โตะ งอ นึง คัน ทไว เซ แปน ไล แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","เกือฮ ป ฮอยจ ทไว โอเอีฮ เซ รไซจ เวียกตู โตม โฮมะ อื ไม่ ชวง อื เกือฮ ซง่ะ. ฟวยจ เซ โม ซตุ เซ ซ อาึง โรฮ อื โตะ งอ นึง คัน เซ เตือง โอยจ อื, เกือฮ ฮะ ล่อยญ. ป ตอง อื ทไว เซ แปน ป ซออย ฮงาื ละ พะจาว ไม่ ปุก เนอึม อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ดัฮ ปุย โรวก ตอง ทไว แกะ ปิ ละ พะจาว โฮ, ไมจ โรฮ อื เลือก โรวก ป โปก อื ไม่ โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","เกือฮ ปุย เซ มอก ป โรวก แตะ ทไว เซ ซองนา พะจาว เฆียง คัน ทไว เซ ลวง ก ล่าวง อื. ฟวยจ เซ โม ซตุ ป มัฮ กวน อาโรน เซ, ซ ตุย ฮนัม ป มอก ปุย ทไว เซ, ซพรอต อื นึง คัน ทไว เซ ปอ ไคว อื ยุฮ คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","เกือฮ แม ปุย เซ มอก โตะ อื เซ แปน ตอนๆ แตะ. โม ป มัฮ ซตุ เซ, ซ อาึง ป ทไว อื เซ โตะ งอ นึง คัน เซ แปน ไล แตะ, เตือง ไกญ อื ไม่ ลออยฮ อื. ");
INSERT INTO lcp_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","ป มัฮ เครอึง กไน อื ไม่ ชวง อื เซ, เกือฮ โรฮ ปุย เซ รไซจ อื เกือฮ ซง่ะ. ฟวยจ รไซจ อื ซตุ เซ ไมจ อื โรวก ตอง ทไว นึง คัน ทไว เซ เตือง โอยจ อื. ป ตอง อื ทไว เซ แปน ป ซออย ฮงาื ละ พะจาว, ไม่ ปุก เนอึม อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ดัฮ ไก ป โรวก ไซม ละ ซ ตอง แตะ ทไว ละ พะจาว เยอ, ไมจ โรฮ อื โรวก ป มัฮ รโกะเกอื. ดัฮ โอ มัฮ รโกะเกอื โฮ, มัฮ โนก พิลัป ป นุมๆ ลั่ง อื. ");
INSERT INTO lcp_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","เกือฮ โรฮ ซตุ เซ โรวก ไซม เซ ฮอยจ นึง คัน ทไว เซ. เกือฮ โรฮ ซเวียต โงก ไซม เซ ปอ ดุต ไกญ อื ไม่ ตอง อื ไกญ ไซม เซ นึง คัน. เกือฮ โรฮ ฮนัม อื ปัต เฆียง คัน ทไว เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","เกือฮ เปฮ ลาื อื ไม่ ตอยจ อื ฮาืก อื, ไม่ โปวฮ อื ก โปวฮ ปุย จะ เฆียง คัน ทไว เซ ลวง ลั่ก โอก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ฟวยจ เซ ไมจ อื แจฮ ป มัฮ โกะ ไซม เซ, ปังเมอ โอ ไมจ เกือฮ ป มัฮ โพรยจ อื เซ ดุต ฮา โกะ โม่ว อื. ฟวยจ เซ ซตุ เซ ซ ตอง ไซม เซ โตะ งอ ราว คัน ทไว เซ. ป ตอง อื ทไว เซ แปน ป ซออย ฮงาื ละ พะจาว ไม่ ปุก เนอึม อื รพาวม อื โรฮ.” ");
INSERT INTO lcp_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ดัฮ ไก ป โรวก ทไว เฮงาะ รโกะ ละ พะจาว เยอ, เกือฮ ปุย เซ คริต เฮงาะ รโกะ ยุฮ แตะ ละ อื ฮัม ปอ แปน อื แปง. ฟวยจ เซ เกือฮ ดุฮ ลออยฮ กาวก นึง อื ไม่ กัมยัน. ");
INSERT INTO lcp_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ฟวยจ เซ เกือฮ โฮว ตาว อื ละ โม ซตุ ป มัฮ กวน อาโรน. ซตุ เซ ซ ตุย แปง ป เอีจ ดุฮ ปุย ลออยฮ นึง เซ ติ ซบราวก เตะ แตะ, ดุฮ แม กัมยัน เซ นึง อื เตือง โอยจ อื, ซ ตอง อื โตะ งอ นึง คัน เซ ละ ซ เกือฮ อื แปน ควน กอก แตะ รโฮงะ ป ทไว ปุย เซ ละ พะจาว. ป ทไว อื เซ แปน เนอึม ป ซออย ฮงาื ละ พะจาว ไม่ ปุก เนอึม อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","เมาะ ป ไก ลั่ง อื เซ เกือฮ โรฮ อื แปน คอง อาโรน ไม่ กวน อื, นึง มัฮ อื เฮงาะ รโกะ ทไว ปุย ป ซง่ะ ซงอม เนอึม ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ดัฮ ไก ป โรวก ทไว คโนมปัง โอป ปุย นึง ตาว โอป เปอ, ไมจ อื มัฮ คโนม ป โอ ปุย ดุฮ เจือ อื. ปัง มัฮ คโนมปัง ยุฮ ปุย นึง แปง ซเบื่อก ไม่ ลออยฮ กาวก ญุ่ก, ปัง มัฮ คโนมปัง เฮรี ป ตา ปุย ลออยฮ นึง ญุ่ก, ไมจ โตว ดุฮ เจือ อื ติ ตื เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ดัฮ ไก ป โรวก ทไว คโนมปัง ป เอีจ เดือก ปุย ราว ไร เดีป เปอ, ไมจ อื ยุฮ นึง แปง ซเบื่อก ปุย ไม่ ลออยฮ กาวก ป โอ ปุย ดุฮ เจือ คโนมปัง นึง โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","เกือฮ โรฮ เรียก คโนมปัง เซ แปน ไซจ แปน ไซจ แตะ, เกือฮ โรฮ เรฮ ลออยฮ นึง อื. ฟวยจ เซ เดอึม เกียฮ แปน คอง ทไว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ดัฮ ปุย โรวก คโนมปัง ป เอีจ เดือก แตะ นึง มอคัง ละ ซ ทไว แตะ ละ พะจาว โฮ, ไมจ อื ยุฮ นึง แปง ไม่ ซเบื่อก โรฮ อื ไม่ ลออยฮ. ");
INSERT INTO lcp_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","เมาะ คโนมปัง โรวก ปุย ทไว ละ พะจาว เซ, ไมจ อื โรวก ฮอยจ ละ ซตุ. ฟวยจ เซ ซตุ ซ ตาว อื ฮอยจ โบ คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ซตุ เซ ซ รยิฮ ป โรวก อื เซ เญี่ยะ ไม่ ตอง อื นึง งอ ละ เกือฮ อื แปน ควน กอก แตะ รโฮงะ ป ทไว อื เซ ละ พะจาว. ป ทไว อื เซ แปน เนอึม ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก เนอึม รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","เมาะ ป ไก ลั่ง อื เซ เกือฮ โรฮ แปน คอง อาโรน ไม่ กวน อื, นึง มัฮ อื ป ทไว ปุย ละ พะจาว, มัฮ ป โซม ป ปอน ทไว ปุย ไม่ มัฮ อื ป ซง่ะ ซงอม เนอึม ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“เมาะ ป โซม ป ยุฮ ปุย นึง เฮงาะ รโกะ ป โรวก เปอะ ทไว ละ พะจาว เซ, ไมจ โตว ดุฮ เจือ นึง อื, นึง โอ เปอะ ลัง ตอง ทไว ป ไก เจือ นึง อื เซ. รอาวม โกะ แฮ ปุ โรฮ ไมจ ตอง โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","เญือม ทไว เปอะ โอเอีฮ ป โฮลฮ โรง เปอะ เกป นึง ป ซมา เปอะ, ดัฮ เปอะ ทไว คโนม ไก เจือ เซ นึง ไม่ รอาวม โกะ แฮ เซ ละ พะจาว แปน โรฮ, ปังเมอ โอ เปอะ ไมจ ตอง นึง คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","โอเอีฮ เมาะ ป ยุฮ ปุย นึง เฮงาะ รโกะ ละ ซ ทไว เปอะ เซ, ไมจ เปอะ ดุฮ กิฮ นึง, นึง มัฮ กิฮ เซ ควน โตก เปอะ ละ ลปุง ซันญา ซน่ะ พะจาว ไม่ โม อิซราเอน. เมาะ ป ทไว เปอะ โครยญ เจือ เยอ, ไมจ โรฮ เปอะ ดุฮ กิฮ นึง ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“โม เปะ ดัฮ เปอะ โรวก ทไว เฮงาะ รโกะ ฮอยจ โรง ยุฮ เปอะ ละ พะจาว โฮ, ไมจ เปอะ เดือก ป ซ ทไว แตะ เซ ละ ฮัม, โต เซ ไมจ เปอะ คริต เกือฮ บลวย. ");
INSERT INTO lcp_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ดุฮ แม ลออยฮ กาวก นึง ไม่ กัมยัน เซ ง่อน, เดอึม ซ เกียฮ แปน คอง ทไว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ฟวยจ เซ ป มัฮ ซตุ รซอฮ ละ พะจาว เซ ซ รยิฮ โรวก เฮงาะ รโกะ ทไว เปอะ เซ ไม่ ลออยฮ กาวก ง่อน, ไม่ กัมยัน เตือง โอยจ อื. โรวก ตอง อื นึง คัน ทไว เซ เกือฮ ฮะ ล่อยญ, นึง ซ แปน อื ควน กอก แตะ รโฮงะ ป ทไว เปอะ เซ ละ พะจาว.” ");
INSERT INTO lcp_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ดัฮ ไก ป โรวก ทไว โอเอีฮ ละ พะจาว นึง ฆวต รโจะ อื รพาวม แตะ ไม่ พะจาว เยอ, ดัฮ โรวก ทไว โมวก โฮ, โมวก โปก ญุ่ก, โมวก ชัง ญุ่ก, แปน ตื ดัฮ โอ ไก ตอก โละพริ โฮ. ");
INSERT INTO lcp_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ไมจ โรฮ ปุย เซ ย่อง เตะ แตะ ราว ไกญ โมวก ซ ทไว แตะ เซ, เกือฮ โรฮ มอก โมวก เซ นึง โตะ รเวือะ พากัง ก ฮอยจ ปุย เคะ พะจาว เซ. ฟวยจ เซ ป มัฮ จัตเจือ อาโรน ป แปน ซตุ เซ, ซ โรวก ฮนัม โมวก เซ ซพรอต อื นึง คัน ทไว เซ ปอ ไคว อื. ");
INSERT INTO lcp_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ฟวยจ เซ ป ทไว โมวก เซ ไมจ อื ฮอย โอเอีฮ โม เฮี ละ ซ แปน อื ป โซม ป ปอน ทไว แตะ ละ พะจาว. มัฮ ลออยฮ ป ติต ไม่ เครอึง กไน อื เซ เตือง โอยจ อื, ");
INSERT INTO lcp_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ไม่ เปละ อื เตือง ลอา ก บลัฮ อื, ไม่ เบือ ลออยฮ ป ติต นึง โตม อื, ไมจ อื ฮอย โอก เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","เญือม เซ กวน อาโรน ซ โรวก ตอง ทไว โอเอีฮ โม เซ ราว โอเอีฮ ไฮญ ป เอีจ ตอง ปุย ทไว นึง คัน เซ, เดอึม ซ แปน คอง ทไว ป ซออย ฮงาื ละ พะจาว ไม่ ปุก เนอึม อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ดัฮ ไก ป โรวก ทไว แกะ ปิ นึง ฆวต รโจะ อื รพาวม แตะ ไม่ พะจาว เยอ, ทไว ป โปก อื ญุ่ก, ป ชัง อื ญุ่ก, ไมจ อื เลือก โรวก ทไว ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","ดัฮ มัฮ กวน แกะ โฮ, เกือฮ โรวก ทไว อื ซองนา พะจาว เมิฮ. ");
INSERT INTO lcp_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ไมจ ปุย เซ ย่อง เตะ แตะ ราว ไกญ อื ไม่ มอก อื นึง ลั่กกา พากัง ยุฮ พะจาว เซ. ฟวยจ เซ กวน อาโรน ซ โรวก ฮนัม กวน แกะ เซ, ซพรอต อื นึง คัน ทไว เซ ปอ ไคว อื. ");
INSERT INTO lcp_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","ฟวยจ เซ ซ ลัฮ โรฮ แกะ เซ, ฮอย โอเอีฮ โม เฮี นึง อื ละ ซ แปน อื ป โซม ป ปอน ทไว แตะ ละ พะจาว. ป มัฮ เบือ ลออยฮ ป ติต ไม่ เครอึง กไน อื เซ, ฮอยจ ละ ลออยฮ ป อาวต นึง ซตะ อื ไม่ เบือ ลออยฮ ป ติต ไม่ ซอัง ซกู อื. ");
INSERT INTO lcp_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ฮอย เปละ อื เตือง ลอา ก บลัฮ อื, ไม่ ลออยฮ ป ติต ไม่ อื, เตือง เบือ ลออยฮ ป ติต นึง โตม อื เกือฮ โอก เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ป มัฮ ซตุ เซ ซ ตอง โรฮ โอเอีฮ โม เซ นึง คัน ทไว เซ ละ ซ เกือฮ แตะ แปน ป โซม ป ปอน ตอง ปุย ทไว ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ดัฮ ป ทไว อื เซ มัฮ ปิ โฮ, เกือฮ โรวก ทไว อื ฮอยจ ซองนา พะจาว เมิฮ. ");
INSERT INTO lcp_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ไมจ ปุย เซ ย่อง เตะ แตะ ราว ไกญ อื ไม่ มอก อื นึง ลั่กกา พากัง ยุฮ พะจาว เซ. ฟวยจ เซ กวน อาโรน ซ โรวก ฮนัม ปิ เซ, ซพรอต อื นึง คัน ทไว เซ ปอ ไคว อื. ");
INSERT INTO lcp_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","ฟวยจ เซ ซ ลัฮ ปิ เซ, ฮอย โอเอีฮ โม เฮี นึง อื ละ ซ แปน อื ป โซม ป ปอน ทไว แตะ ละ พะจาว. มัฮ เบือ ลออยฮ ป ติต ปุ แตะ ไม่ เครอึง อาวต กไน อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","เปละ อื เตือง ลอา ก บลัฮ อื ฮอยจ ละ ลออยฮ ป ติต ไม่ อื, เตือง เบือ ลออยฮ ป ติต นึง โตม อื ฮอย อื เกือฮ โอก เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ป มัฮ ซตุ เซ ซ ตอง โรฮ โอเอีฮ โม เซ นึง คัน ทไว เซ ละ ซ เกือฮ อื แปน ป โซม ป ปอน ป ซออย ฮงาื ทไว ละ พะจาว, ไม่ ปุก เนอึม อื รพาวม อื. เมาะ ป มัฮ ลออยฮ อื เตือง โอยจ อื ลัง มัฮ ป ยุฮ พะจาว ตื. ");
INSERT INTO lcp_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“เฮี มัฮ โกตไม ยุฮ อาึ ป เกือฮ โม เปะ โตก ละ, ฮอยจ ละ กวน เฌือต เปอะ โครยญ เจน ปุย. อาวต เปอะ ก ออฮ ก เอีฮ ญุ่ก, ไมจ เปอะ แฮน เวีย ปอน แตะ ลออยฮ ซัตซิง ไม่ ฮนัม อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ไมจ เปอะ รโฮงะ ไลลวง เฮี ละ โม อิซราเอน. ดัฮ ไก ป โคะ ยุฮ ป พิต ไม่ โอ โกะ อื ยุง มัฮ อื ป พิต โกตไม ยุฮ พะจาว โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","ดัฮ มัฮ ฮัวนา ซตุ โฮ ป โคะ ยุฮ ป พิต เซ, กัน พิต ยุฮ อื เซ แปน มั่ป ติต โรฮ ฮอยจ ละ ปุย ไฮญ ฆาื อื. ไมจ โรฮ ซตุ เซ ไอฮ โมวก โปก นุม ติ ตัว ไม่ โอ อื ไก ตอก โละพริ, ละ ซ ทไว แตะ ละ พะจาว เกือฮ แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","ไมจ อื ตาว โมวก เซ ฮอยจ นึง โตะ รเวือะ พากัง ระ เซ ซองนา พะจาว. เกือฮ ย่อง เตะ แตะ ราว ไกญ โมวก เซ, เกือฮ โรฮ ยุฮ ยุม ไม่ อื ซองนา พะจาว โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ฟวยจ เซ ซตุ เซ ซ โรวก ฮนัม โมวก เซ เลียก ไม่ อื โตะ กไน พากัง เซ, ");
INSERT INTO lcp_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ซ ชึต โรฮ ด่อยฮ แตะ นึง ฮนัม เซ ไม่ ซพรอต อื นึง ลั่กกา พากัง รตา ฮอง เซ อาแลฮ เตะ ซองนา พะจาว โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ซ ตา แม โรฮ ฮนัม เซ นึง โด่วง อาวต โจง คัน ทไว ปุย ป ซออย ฮงาื โตะ กไน พากัง ระ เซ. ฮนัม เมาะ ป โฮฮ ลั่ง อื เซ ซ โทก อื นึง ชวง คัน ตอง ปุย ทไว โอเอีฮ ป อาวต ลั่กกา พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","ฟวยจ เซ ซ ฮอย โรฮ ป มัฮ ลออยฮ ป ติต ไม่ เครอึง กไน โมวก เซ, ");
INSERT INTO lcp_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ฮอยจ ละ เปละ อื เตือง ลอา ก บลัฮ อื, ไม่ เบือ ลออยฮ ป ติต นึง โตม อื, เกือฮ อื โอก เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ไมจ โรฮ ยุฮ ตอก เญือม ยุฮ ปุย อื ละ โมวก ป ทไว ปุย ละ ซ รโจะ ดิ รพาวม แตะ ไม่ พะจาว เญือม ไฮญ โรฮ. ฟวยจ เซ ซตุ เซ ซ ตอง โรฮ โอเอีฮ โม เซ นึง คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ป มัฮ ฮัก โมวก เซ ไม่ เนะ ไม่ ไกญ อื ฮอยจ ละ ชวง อื ไม่ เครอึง กไน เตือง เวียกตู อื, ");
INSERT INTO lcp_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ซ ยวก ตาว อื โอก ก พริ ไคะ นา ก ซง่ะ ไล อื. ฟวยจ เซ ซ ตอง อื นา ก โทก ปุย โปวฮ จะ เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ดัฮ โม อิซราเอน เตือง โอยจ อื โคะ ยุฮ ป พิต, ไม่ โอ โม โกะ อื ยุง มัฮ อื ป พิต โกตไม ยุฮ พะจาว โฮ, เอีจ แปน โรฮ มั่ป ละ อื. ");
INSERT INTO lcp_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ดัฮ กัน พิต ยุฮ โม เซ เอีจ เปลีฮ ติ แตะ โอก โฮ, ไมจ โม เซ ทไว โมวก โปก นุม ลั่ง ติ ตัว ละ ซ แปน อื ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ. เกือฮ ตาว โมวก เซ ฮอยจ ลั่กกา พากัง ก ฮอยจ ปุย เคะ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","เกือฮ โรฮ โม ป กวต ป เฮียง ลลาึง โม อิซราเอน เซ ย่อง เตะ แตะ ราว ไกญ โมวก เซ ซองนา พะจาว, ไม่ มอก โรฮ อื โมวก เซ เกือฮ ยุม. ");
INSERT INTO lcp_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ฟวยจ เซ ฮัวนา ซตุ เซ ซ ตุย โรวก ฮนัม โมวก เซ ง่อน, เลียก ไม่ อื โตะ กไน พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ซตุ เซ ซ ชึต โรฮ ด่อยฮ แตะ นึง ฮนัม เซ. ซพรอต อื นึง ลั่กกา พากัง รตา ฮอง เซ ซองนา พะจาว อาแลฮ เตะ. ");
INSERT INTO lcp_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ซ ตา แม โรฮ ฮนัม เซ นึง โด่วง ป อาวต โจง คัน ทไว ปุย ป ซออย ฮงาื โตะ กไน พากัง ระ เซ. ฮนัม เมาะ ป โฮฮ ลั่ง อื ซ โทก อื นึง ชวง คัน ตอง ปุย ทไว โอเอีฮ ป อาวต ลั่กกา พากัง เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","ฟวยจ เซ ซ ตุย โรฮ ลออยฮ โมวก เซ เตือง โอยจ อื เซ, โรวก ตอง อื ราว คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ยุฮ ปุย ละ โมวก เกือฮ แตะ แปน ควน โตฮ มั่ป ยุฮ ปุย ตอก ออฮ, ซ ยุฮ โรฮ อื ละ โมวก เซ ตอก เซ โรฮ, มัฮ ยุฮ อื ตอก เซ ละ ซ เกือฮ อื แปน ควน รไซจ พิต โฌวะ ยุฮ ปุย, เดอึม พะจาว ซ ยวก มั่ป ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","ฟวยจ เซ ซตุ เซ ซ ตาว โมวก เซ โอก ฮอยจ ก พริ ไคะ. ซ ตอง โรฮ อื ตอก ตอง แตะ โมวก ทไว แตะ ละ มั่ป ยุฮ โกะ แตะ เซ. มัฮ ยุฮ อื ตอก เซ ละ ซ เกือฮ แตะ โม อิซราเอน เตือง โอยจ อื โปน ฮา มั่ป ยุฮ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ดัฮ โม ป ตัตเตียง เญือะ ย่วง บั่นเมือง โคะ ยุฮ ป พิต ไม่ โอ โกะ อื ยุง มัฮ อื ป พิต โกตไม ยุฮ พะจาว โฮ, โอเอีฮ ตอก เซ เอีจ แปน โรฮ มั่ป ละ อื. ");
INSERT INTO lcp_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ดัฮ ปุย เซ เอีจ ยุง ยุฮ แตะ ป พิต โฮ, ไมจ ปุย เซ โรวก ปิ โปก ติ ตัว ป โอ อื ไก ตอก โละพริ, ละ ซ เกือฮ อื แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","เกือฮ โรฮ ปุย เซ ย่อง เตะ แตะ ราว ไกญ ปิ เซ, ไม่ มอก อื ปิ เซ นา ก มอก ปุย ซัตซิง ละ ซ ตอง แตะ ทไว เซ, นึง มัฮ อื ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ฟวยจ เซ ซตุ เซ ซ ชึต ด่อยฮ แตะ นึง ฮนัม ปิ เซ. ตา อื นึง โด่วง ป อาวต โจง คัน เซ. ฮนัม ป ไก ลั่ง อื เซ ซ โทก อื นึง ชวง คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ฟวยจ เซ ซ ตุย โรฮ ตอง ลออยฮ ปิ เซ นึง คัน เซ เตือง โอยจ อื, ตอก เญือม ทไว ปุย โอเอีฮ ละ ซ รโจะ อื รพาวม แตะ ไม่ พะจาว โฮ. ซตุ เซ มัฮ ยุฮ อื ตอก เซ ละ เกือฮ แตะ แปน ควน รไซจ พิต โฌวะ ยุฮ ปุย เซ. พะจาว ซ ยวก เนอึม พิต โฌวะ ยุฮ อื เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ดัฮ โม ลัปซด่อน โคะ ยุฮ ป พิต ติ ปุย ไม่ โอ โกะ อื ยุง มัฮ อื ป พิต โกตไม ยุฮ พะจาว โฮ, โอเอีฮ ตอก เซ เอีจ แปน โรฮ มั่ป ละ อื. ");
INSERT INTO lcp_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","ดัฮ ปุย เซ เอีจ ยุง ยุฮ แตะ ป พิต, ไมจ ปุย เซ โรวก ปิ รโปวน ติ ตัว ป โอ อื ไก ตอก โละพริ, ละ ซ เกือฮ อื แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","เกือฮ โรฮ ปุย เซ ย่อง เตะ แตะ ราว ไกญ ปิ เซ, ไม่ มอก อื ปิ เซ นา ก มอก ปุย ซัตซิง ละ ซ ตอง แตะ ทไว เซ, นึง มัฮ อื ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ฟวยจ เซ ซตุ ซ ชึต ด่อยฮ แตะ นึง ฮนัม ปิ เซ. ตา อื นึง โด่วง อาวต โจง คัน เซ. ฮนัม ป ไก ลั่ง อื เซ ซ โทก อื นึง ชวง คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","ซ ตุย แม โรฮ ป มัฮ ลออยฮ อื เตือง โอยจ อื ตอก เญือม ทไว ปุย โอเอีฮ ละ ซ รโจะ อื รพาวม แตะ ไม่ พะจาว โฮ. ฟวยจ เซ ซตุ เซ ซ ตอง ลออยฮ เซ โตะ งอ นึง คัน เซ. ป ทไว อื เซ แปน เนอึม ป ซออย ฮงาื ละ พะจาว ไม่ ปุก เนอึม อื รพาวม อื. ซตุ เซ มัฮ ยุฮ อื ตอก เซ ละ ซ เกือฮ แตะ แปน ควน รไซจ พิต โฌวะ ยุฮ ปุย เซ. พะจาว ซ ยวก เนอึม พิต โฌวะ ยุฮ อื เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ดัฮ มัฮ แกะ โฮ ป โรวก ปุย ทไว ละ ซ เกือฮ อื แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ เซ, ไมจ อื โรวก ป มัฮ กวน แกะ รโปวน ติ ตัว ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","เกือฮ ปุย เซ ย่อง เตะ แตะ ราว ไกญ กวน แกะ เซ ไม่ มอก โรฮ อื นา ก มอก ปุย โอเอีฮ ไฮญ ป ตอง แตะ ทไว เซ. มัฮ เกือฮ อื แกะ เซ แปน ควน โตฮ อื ติ แตะ ฮา มั่ป. ");
INSERT INTO lcp_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ฟวยจ เซ ซตุ เซ ซ ชึต ด่อยฮ แตะ นึง ฮนัม กวน แกะ เซ. ตา อื นึง โด่วง อาวต โจง คัน ตอง ปุย ทไว โอเอีฮ เซ. ฮนัม โฮฮ เซ โทก แม อื นึง ชวง คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","ตุย แม โรฮ ป มัฮ ลออยฮ อื เตือง โอยจ อื ตอก ยุฮ แตะ ละ คอง ทไว ปุย ละ ซ รโจะ อื รพาวม แตะ ไม่ พะจาว โรฮ. ฟวยจ เซ ซ ตอง ลออยฮ เซ นึง คัน เซ, ราว โอเอีฮ ไฮญ ป ตอง ปุย ทไว ละ พะจาว. ซตุ เซ มัฮ ยุฮ อื ตอก เซ ละ ซ เกือฮ แตะ แปน ควน รไซจ พิต โฌวะ ยุฮ ปุย เซ. พะจาว ซ ยวก เนอึม พิต โฌวะ ยุฮ อื เซ ฆาื อื.” ");
INSERT INTO lcp_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","กัน ยุฮ ปุย ป เมีญ ปุย แปน มั่ป ละ อื มัฮ ตอก เฮี, ดัฮ ไก ป โฮลฮ ปุย กอก ฮอยจ แปน พีญัน นึง โอเอีฮ ป เอีจ ยุ เอีจ ฮมอง แตะ, ดัฮ โอ รโฮงะ อื ตัม ซื อื ตัม ป ยุ ป ฮมอง แตะ เซ โฮ, ปุย เซ ซ ไก ตุต ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","ดัฮ ไก ป โคะ ลอก ป โอ ซง่ะ ไล เตือง โอ โกะ แตะ ยุง, โกะพริ ยุม ญุ่ก, โกะย่วง ยุม ญุ่ก, ไม่ ซัตซิง ไฮญ ป เมีญ พะจาว มัฮ ป รแอม ละ แตะ ญุ่ก, ปุย เซ เอีจ แปน ปุย โอ ซง่ะ ไล ไม่ ไก ตุต แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ดัฮ ไก ป โคะ ลอก โอเอีฮ ป รแอม ป โอก เน่อึม นึง ปุย เยอ, ดัฮ เอีจ ยุง ลอก แตะ โอเอีฮ ตอก เซ โฮ, ปุย เซ เอีจ แปน ปุย โอ ซง่ะ ไล ไม่ ไก ตุต แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ดัฮ ไก ป โคะ ซม่อต ซบั่น ติ แตะ นึง ป ซ ยุฮ ซ อัฮ แตะ, ปัง มัฮ นึง ไลลวง ออฮ ไลลวง เอีฮ ญุ่ก, ดัฮ เอีจ โตก ละ ป โคะ อัฮ แตะ เซ โฮ, ปุย เซ เอีจ ไก ตุต ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","ดัฮ ไก ป อาวม ไก พิต ไก โฌวะ ยุฮ แตะ ตอก เอีจ อัฮ เยอะ เซ, เกือฮ ปุย เซ รโซะ พิต โฌวะ ยุฮ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","เกือฮ โรฮ โรวก ซัตซิง ละ ซ ทไว แตะ, เกือฮ แปน ควน ยวก มั่ป กัฮ ตุต ยุฮ อื เซ. ป โรวก อื เซ มัฮ แกะ ชัง ญุ่ก, ปิ ชัง ญุ่ก, แปน ตื. ไมจ เกือฮ ซตุ ทไว ซัตซิง เซ รโตง อื ละ ซ แปน อื ควน รไซจ มั่ป ยุฮ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ดัฮ ปุย เซ โอ ปุน โรวก ทไว แกะ โฮ, เกือฮ โรวก ทไว รโกะเกอื ลอา ตัว, โต เซ มัฮ โนก พิลัป ลอา ตัว. เกือฮ ทไว อื ละ พะจาว แปน ควน ยวก มั่ป กัฮ ตุต ยุฮ อื เซ. ติ ตัว อื แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ อื, ติ ตัว อื แม แปน โรฮ ป ตอง อื ทไว ละ พะจาว เตือง ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","9","เกือฮ โรฮ ปุย เซ โรวก ป ทไว แตะ เซ ฮอยจ ละ ซตุ. ฟวยจ เซ ซตุ เซ ซ ตุย โรฮ ไซม เซ ติ ตัว ไม่ ซเวียต อื โงก อื เกือฮ โอก ฮนัม, ปังเมอ โอ เกือฮ ไกญ อื รกัฮ ฮา โงก อื. เกือฮ โรฮ ตุย ฮนัม เซ ไม่ ซพรอต อื เฆียง คัน ทไว เซ ง่อน. เมาะ ป โฮฮ อื เซ เกือฮ โทก อื นึง ชวง คัน ทไว เซ. มัฮ ตอก เซ ตอก ยุฮ ปุย ละ ซ เกือฮ แตะ แปน ควน โตฮ อื ฮา มั่ป ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ฟวยจ เซ ตัว ป ไก ลั่ง อื เซ ซ ตุย โรฮ ตอง ทไว อื ละ พะจาว ตัม โกตไม. ซตุ เซ มัฮ ยุฮ อื ตอก เซ ละ ซ เกือฮ แตะ แปน ควน รไซจ พิต โฌวะ ยุฮ ปุย เซ. พะจาว ซ ยวก พิต โฌวะ ยุฮ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ดัฮ ปุย เซ โอ ลั่ง ปุน โรวก ไซม ละ ซ ทไว แตะ ละ พะจาว ตอก เซ โฮ, เกือฮ ปุย เซ โรวก ญอต แปง ยุฮ แตะ เซ ลอา ลิต, ละ ซ ทไว อื เกือฮ แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ อื เซ. ทัน โตว ดุฮ ลออยฮ นึง ไม่ กัมยัน เฟือฮ, นึง มัฮ อื ควน โตฮ ปุย ติ แตะ ฮา มั่ป ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","เกือฮ โรฮ ตาว ญอต แปง โรวก แตะ ทไว เซ ฮอยจ ละ ซตุ. เญือม เซ ซตุ เซ ซ โรวก ญอต แปง เซ ติ ซบราวก เตะ แตะ ไม่ ตอง อื นึง คัน ทไว เซ, ละ ซ เกือฮ อื แปน ควน กอก แตะ รโฮงะ ป ทไว ปุย เซ ละ พะจาว, ละ ซ แปน อื ป โซม ป ปอน ทไว แตะ. เอีจ มัฮ ตอก เซ ตอก ยุฮ ปุย ละ ซ เกือฮ อื แปน ควน โตฮ ติ แตะ ฮา มั่ป ยุฮ แตะ เซ.” ");
INSERT INTO lcp_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ซตุ เซ มัฮ ยุฮ อื ตอก เซ ละ ซ เกือฮ อื แปน ควน รไซจ พิต โฌวะ ยุฮ ปุย เซ เตือง โอยจ อื. พะจาว ซ ยวก อื ละ อื ฆาื อื. ญอต แปง เมาะ ป ไก ลั่ง อื เซ แปน โรฮ คอง ซตุ เซ, ตอก เญือม ทไว ปุย เฮงาะ รโกะ ละ พะจาว โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ดัฮ ไก ป โคะ ยุฮ ป พิต นึง โอ แตะ เกือฮ เนอึม ป ลัง ทไว แตะ ละ พะจาว เยอ, ไมจ ปุย เซ โรวก แกะ ไฮมญ ติ ตัว ละ ซ ทไว แตะ ละ พะจาว, ละ ซ เกือฮ อื แปน ควน ยวก มั่ป กัฮ ตุต ยุฮ อื. แกะ เซ ไมจ อื มัฮ แกะ ไมจ ไม่ โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม. ไมจ โรฮ ปุย ตี งวยฮ แกะ เซ ตัม งวยฮ มาื เชเคน ตี ปุย นึง พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","โนก ฮา เซ ปุย พิต เซ ไมจ อื โรก ป ลัง เกือฮ แตะ เซ ละ พะจาว. ไมจ แม อื บุ โฮฮ ฮา งวยฮ อื เซ ง่า เปอเซน. ไมจ อื เกือฮ ละ ซตุ. ซตุ เซ ซ มอก ทไว แกะ เซ ละ ซ แปน อื ควน รไซจ พิต โฌวะ ยุฮ ปุย เซ. พะจาว ซ ยวก มั่ป พิต ยุฮ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ดัฮ ไก ป ยุฮ ป พิต นึง ยุฮ แตะ โอเอีฮ ป คัต พะจาว แตะ โอ ยุฮ, ปัง โอ ยุง มัฮ อื ป พิต ญุ่ก, เอีจ แปน มั่ป ละ ปุย เซ. ซ ลอก โรฮ ตุต แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ไมจ ปุย เซ ตาว แกะ โปก ติ ตัว ละ ซตุ ละ ซ แปน อื ควน ยวก มั่ป กัฮ ตุต ยุฮ ปุย เซ. แกะ เซ ไมจ อื มัฮ แกะ ไมจ ไม่ โอ อื ไก ตอก โละพริ. ไมจ โรฮ อื ตี งวยฮ แกะ เซ ตัม คโนวน ป กอ ทไว ปุย โฮ. ซตุ เซ ซ มอก ทไว อื รโตง ปุย เซ ละ ซ แปน อื ควน รไซจ พิต โฌวะ ยุฮ อื. พะจาว ซ ยวก เนอึม อื ละ อื. ");
INSERT INTO lcp_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ปุย เซ เอีจ พิต ละ พะจาว. ป โรวก อื ทไว เซ มัฮ ควน ยวก มั่ป กัฮ ตุต ยุฮ อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","พะจาว อัฮ แม อื ละ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ดัฮ ไก ป ยุฮ ป พิต ละ พะจาว นึง บ่วก อื ละ ปุย่วง แตะ นึง ป รโปะ ปุย ไม่ แตะ ญุ่ก, นึง บระ ปอก แตะ ญุ่ก, นึง จุ แตะ ปุย ไลจ ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","นึง เม่าะ ลไลม แตะ โอเอีฮ ป ไฆร ฮา ปุย ญุ่ก, นึง ซม่อต อื ติ แตะ นึง ป โอ เนอึม ญุ่ก, นึง กัน พิต ตอก ไฮญ ญุ่ก. ");
INSERT INTO lcp_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","5","ปุย ดัฮ พิต นึง โอเอีฮ โม เซ ติ เจือ โฮ, เอีจ มัฮ โรฮ มั่ป ละ อื. ปุย เซ ไมจ อื โรก โอเอีฮ ละ ป บ่วก แตะ ละ เซ เกือฮ กุม. โนก ฮา เซ ไมจ แม อื บุ โฮฮ ฮา ลัง เกือฮ แตะ ง่า เปอเซน. ซเงะ ตาว อื ควน ยวก มั่ป กัฮ ตุต ยุฮ แตะ ละ พะจาว เซ ไมจ โรฮ อื เกือฮ โอเอีฮ เซ ละ ป บ่วก แตะ ละ เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","เญือม เซ ไมจ ปุย เซ ตาว แกะ โปก ติ ตัว ป โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม ละ ทไว อื ละ พะจาว เกือฮ แปน ควน ยวก มั่ป กัฮ ตุต ยุฮ แตะ เซ. ไมจ อื เกือฮ ละ ซตุ เซ. ไมจ โรฮ ปุย ตี งวยฮ อื ตัม คโนวน กอ เกือฮ ปุย อื โฮ. ");
INSERT INTO lcp_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ซตุ เซ ซ ทไว อื ละ พะจาว แปน ควน รไซจ พิต โฌวะ ยุฮ อื. พะจาว ซ ยวก อื ละ อื เบือ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","พะจาว อัฮ อื ละ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“ไมจ เปอะ ดวน อาโรน ไม่ โม กวน อื เซ เกือฮ ยุฮ อื ตอก เฮี. ซัตซิง ตอง เปอะ ทไว เซ ไมจ อื อาวต โตะ งอ นึง คัน เซ แปน ซาวม บวยฮ อื. งอ นึง คัน เซ ไมจ อื ตอก เลิง. ");
INSERT INTO lcp_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","เญือม เซ ซตุ ไมจ อื ไอฮ แว ลปิ พา แนน ไมจ เตือง ก พริ กไน อื. ไมจ อื กาวป จะ ก ตอง ปุย ซัตซิง เซ เกือฮ โอก อาึง อื เฆียง คัน ทไว เซ ติ ลวง. ");
INSERT INTO lcp_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ฟวยจ เซ ไมจ อื ปอยจ เครอึง ซัมคัน จาวป แตะ เซ. ไมจ อื ไอฮ เครอึง ไฮญ เดอึม ไมจ อื ตุย โรวก จะ เซ โอก ฮา ไคะ อาวต ปุย เซ, ไม่ ตาว อื ฮอยจ นา ก ซง่ะ ไล อื ติ โดฮ. ไมจ อื โปวฮ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","งอ นึง คัน เซ ไมจ อื ตอก เลิง. ปุ เกือฮ ญึ่ต เฟือฮ เอิน. ซตุ เซ ไมจ อื บุ เคิ นึง คัน เซ โครยญ ซะ. ไมจ โรฮ อื อาึง ซัตซิง ตอง แตะ นึง คัน เซ ตัม ไล อื. ไมจ อื ตอง ลออยฮ ซัตซิง นึง ละ ซ เกือฮ อื ปุย โฮลฮ รโจะ ดิ รพาวม แตะ ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","งอ นึง คัน เซ ไมจ อื ตอก เลิง. ปุ เกือฮ ญึ่ต เฟือฮ เอิน,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“เฮี มัฮ โกตไม เกว ไม่ ไลลวง ตอก ทไว ปุย เฮงาะ รโกะ ละ พะจาว. ดัฮ มัฮ แปง ป ทไว อื เซ, เกือฮ กวน อาโรน โรวก ทไว แปง เซ ซองนา พะจาว ลั่กกา คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ไมจ อื ตุย แปง เซ ติ ซบราวก ป เอีจ ซเบื่อก ปุย ไม่ ลออยฮ ไม่ กัมยัน เตือง โอยจ อื. เกือฮ ตอง อื โตะ งอ ละ ซ เกือฮ อื แปน ควน กอก แตะ รโฮงะ ละ พะจาว. ป ทไว อื เซ แปน เนอึม ป ซออย ฮงาื ละ พะจาว, ไม่ ป ปุก เนอึม รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","แปง เมาะ ป โฮฮ ลั่ง อื เซ เกือฮ แปน ป โซม อาโรน ไม่ กวน อื. เกือฮ ยุฮ คโนม โอ ไก เจือ นึง อื ละ ซ แปน อื ป โซม อื กไน ควง พากัง ระ ป มัฮ นาตี ซง่ะ ซงอม ยุฮ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","คโนมปัง ยุฮ อื นึง แปง เซ ปุ ดุฮ เจือ คโนม นึง เฟือฮ เอิน. พะจาว มัฮ เกือฮ อื ป โซม ป ปอน เฮี แปน รโตง โม ซตุ นึง อื, ไม่ เมีญ อื มัฮ คอง ทไว ซง่ะ ซงอม, ตอก โรฮ คอง ทไว ปุย ละ โตฮ อื ติ แตะ ไม่ คอง ทไว ปุย ละ แปน อื ควน ยวก มั่ป ยุฮ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ป ลัง โซม คโนม ยุฮ พะจาว เซ เอีจ มัฮ จัตเจือ อาโรน ป มัฮ ปรเมะ นึง อื โน่ง. ปุย ไฮญ ป โอ มัฮ ซตุ เซ ดัฮ ลอก ดัฮ ไปญ คโนมปัง ซัมคัน เซ ซ ไก ตุต ฆาื อื นึง มัฮ อื คอง พะจาว. โกตไม เฮี ไมจ เกือฮ แปน โกต โอ เญือะ ไก ลอยจ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“เฮี มัฮ แม ไลลวง ป ไมจ อาโรน ไม่ กวน เฌือต อื ทไว ละ พะจาว ซเงะ เญือม เรฮ ปุย ลออยฮ นึง ไกญ อื ละ ดุฮ อื เกือฮ แปน ซตุ. ป ไมจ อื ทไว เซ มัฮ ญอต แปง ลอา ลิต, ตอก โรฮ ป ลัง ทไว ปุย โครยญ ซเงะ โฮ. ญอต แปง เซ รฆุ อื เลีฮ ลอา ละ ซ ทไว อื เมือ กซะ อื บลัฮ, เมือ กปู อื บลัฮ. ");
INSERT INTO lcp_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","เกือฮ ซเบื่อก อื ไม่ ลออยฮ ปอ ตัว อื. ฟวยจ เซ ไมจ อื เดือก ราว ไร เดีป เกือฮ โรฮ บิฮ อื แปน ไซจ แปน ไซจ แตะ ตอก ป ทไว ปุย เญือม ไฮญ. ป ทไว อื เซ แปน เนอึม ป ซออย ฮงาื ละ พะจาว, ไม่ ป ปุก เนอึม รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","โม ซตุ ป มัฮ จัตเจือ อาโรน ป ดุฮ ปุย เกือฮ แปน ซตุ เซ โครยญ โฆะ อื, ไมจ เนอึม อื ตอง ทไว โอเอีฮ ตอก เซ โครยญ เจือ ละ พะจาว, เกือฮ แปน โกต โอ เญาะ ไก ลอยจ. ");
INSERT INTO lcp_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","เมาะ ป มัฮ เฮงาะ รโกะ ป ลัง ทไว โม ซตุ เซ โครยญ เจือ เยอ, ไมจ ตอง นึง งอ เตือง โอยจ อื. ไมจ โตว เกือฮ ปุย โซม,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“ไมจ เปอะ รโฮงะ ละ อาโรน ไม่ กวน อื ตอก เฮี, เฮี มัฮ โกตไม เกว ไม่ ตอก โตฮ ปุย ติ แตะ ฮา มั่ป. ไมจ เปอะ มอก ซัตซิง เฆียง คัน, นึง เบือง ก มอก ปุย ซัตซิง ตอง แตะ ทไว ซองนา พะจาว โฮ. คอง ทไว ปุย เซ เอีจ มัฮ ควน โตฮ อื ติ แตะ นึง, ไม่ แปน อื ป ซัมคัน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ป มัฮ ซตุ ทไว โอเอีฮ เซ, ไมจ อื ปอน โตะ ป ทไว ปุย เซ กไน ควง พากัง ระ ป มัฮ นาตี ซง่ะ ซงอม เซ. ");
INSERT INTO lcp_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ดัฮ ไก ป ลอก โตะ ซัตซิง เซ, ซ ลอต แปน ป ไก ตุต ฆาื อื นึง มัฮ อื คอง พะจาว. ดัฮ ฮนัม อื ลอก เครอึง เซอึก อื โฮ, ไมจ อื ซัก เกือฮ บัฮ โอยจ นึง นาตี ซัมคัน ยุฮ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ป มัฮ โดง เตะ ควน โกยฮ เปอะ โตะ เซ ไมจ เปอะ ยุฮ ไลจ ไม่. ดัฮ เปอะ โกยฮ นึง โดง ไร ไมจ เปอะ พัก ญื นึง รอาวม เกือฮ ซง่ะ. ");
INSERT INTO lcp_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","โตะ ซัมคัน เซ, เมาะ ป มัฮ ปรเมะ นึง จัตเจือ ซตุ เซ ลัง ปอน ตื อื. ");
INSERT INTO lcp_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ดัฮ มัฮ ซัตซิง ป โรวก ปุย ฮนัม อื ฮอยจ กไน พากัง ยุฮ พะจาว ละ ซ รไซจ อื พิต โฌวะ ยุฮ ปุย โฮ, ปังเมอ โอ ไมจ ปอน โตะ อื เฟือฮ เอิน. โตะ เซ ไมจ ตอง นึง งอ.” ");
INSERT INTO lcp_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“เฮี มัฮ โกตไม เกว ไม่ ไลลวง ป ทไว ปุย เกือฮ แปน ควน ยวก มั่ป กัฮ ตุต ยุฮ แตะ. มัฮ โรฮ ป ซัมคัน เนอึม ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ซัตซิง ทไว อื เซ ไมจ อื มอก นา ก มอก ปุย ซัตซิง ละ ซ ตอง แตะ ทไว โรฮ. ป มัฮ ฮนัม อื เซ ไมจ อื ซพรอต นึง คัน ทไว เซ ปอ ไคว อื. ");
INSERT INTO lcp_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","เมาะ ป มัฮ ลออยฮ อื เตือง โอยจ อื ไมจ เปอะ ทไว ละ พะจาว, ตอก ลออยฮ ป ติต ไม่ เครอึง กไน อื, ฮอยจ ละ ลออยฮ ติต ไม่ ซตะ อื, ");
INSERT INTO lcp_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ฮอยจ ละ เปละ อื เตือง ลอา ก บลัฮ อื ไม่ เบือ ลออยฮ ติต ไม่ โตม อื. ไมจ โรฮ ฮอย เกือฮ โอก เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ฟวยจ เซ เกือฮ ซตุ ตอง ลออยฮ เอีจ ฮอย แตะ เซ เตือง โอยจ อื นึง คัน ทไว เซ ละ ซ เกือฮ อื แปน ป โซม ป ปอน ป ทไว ปุย ละ พะจาว. เอีจ มัฮ ควน ยวก มั่ป กัฮ ตุต ยุฮ ปุย. ");
INSERT INTO lcp_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","เมาะ ป มัฮ ปรเมะ นึง จัตเจือ ซตุ เซ ลัง ปอน ตื อื โตะ เซ, ปังเมอ ไมจ อื ปอน นึง นาตี ซัมคัน ยุฮ พะจาว, นึง มัฮ อื โตะ ซัมคัน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“โกตไม เกว ไม่ กัน ทไว ปุย โอเอีฮ ละ ซ ยวก มั่ป กัฮ ตุต เซ, ตอก โรฮ ปุ แตะ ไม่ โกตไม ควน โตฮ ปุย ติ แตะ ฮา มั่ป โรฮ. โตะ มอก ปุย ตอง ทไว เซ ลัง ละ โม ซตุ ป ไจไซ ละ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ฮัก ซัตซิง ป ทไว ปุย เซ ลัง โรฮ ละ ซตุ ป ไจไซ ทไว ละ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","เมาะ ป มัฮ คโนมปัง ฮอยจ ทไว ปุย เซ, ป โอป ปุย โตะ ตาว โอป ญุ่ก, ป เดือก ปุย นึง มอคัง ญุ่ก, ป เดือก ปุย ราว ไร เดีป ญุ่ก, มัฮ โรฮ ป ลัง ละ ซตุ ป ไจไซ ละ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ป มัฮ เฮงาะ รโกะ เซ, ปัง รไม่ ไม่ ลออยฮ ญุ่ก, ปัง โอ ดิ รไม่ ญุ่ก, ลัง ละ จัตเจือ อาโรน โครยญ โฆะ อื. ไมจ อื รฆุ ดิ ไม่ ปุ แตะ บริญๆ. ");
INSERT INTO lcp_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“เฮี มัฮ โกตไม เกว ไม่ ไลลวง ป ทไว ปุย ละ ซ รโจะ อื รพาวม แตะ ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ดัฮ ไก ป ฆวต ทไว โอเอีฮ นึง ฆวต เปลีฮ อื รพาวม ญันดี่ แตะ ละ พะจาว เยอ, เกือฮ โรวก ซัตซิง ไม่ คโนมปัง โอ ไก เจือ. ปัง มัฮ คโนมปัง โม่ว ป ยุฮ ปุย นึง แปง ซเบื่อก ไม่ ลออยฮ ญุ่ก, คโนม แปน แพน ป ตา ปุย ลออยฮ นึง ญุ่ก, คโนม ญอต แปง ป ซเบื่อก ปุย ไม่ ลออยฮ ญุ่ก. ");
INSERT INTO lcp_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","โนก ฮา เซ ไมจ โรฮ อื โรวก คโนมปัง ไก เจือ ละ ซ ทไว แตะ ละ ซ รโจะ อื รพาวม แตะ ไม่ พะจาว นึง รพาวม ญันดี่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ไมจ ซตุ ตุย คโนม เซ ติ เจือ ติ โม่ว, เกือฮ แปน ป ทไว พิเซต อื ละ พะจาว. คโนม เซ มัฮ ป ลัง ละ ซตุ ป ซพรอต ฮนัม นึง คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","โตะ ซัตซิง ป ทไว อื เซ เกือฮ เอิน ปอน อื ไน ซเงะ เซ. ไมจ โตว เกือฮ โฮฮ ฮอยจ ละ ปวยฮ พริ. ");
INSERT INTO lcp_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ดัฮ ไก ป ฮอยจ ทไว โอเอีฮ ละ ซ รโจะ อื รพาวม แตะ ไม่ พะจาว เยอ, ทไว อื ตัม ป ซันญา แตะ ญุ่ก, นึง รพาวม ฆวต ทไว โกะ แตะ ไอฮ ญุ่ก, ป ทไว อื เซ เกียฮ โซม ปอน อื เน่อึม ซเงะ เซ, ฮอยจ ละ ซเงะ ติ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ดัฮ โตะ เซ โฮฮ ลั่ง ฮอยจ ซเงะ ลอวย โฮ, เญาะ ไมจ โตว ปอน. ไมจ ตอง โตะ งอ. ");
INSERT INTO lcp_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ดัฮ ไก ป ปอน ลั่ง โตะ เซ เยอ, พะจาว เกียฮ รัป โตว ป ทไว ปุย เซ นึง มัฮ อื ป รแอม ไล ละ อื. เมีญ โตว ป ทไว ปุย เซ แปน กุน ละ ปุย เซ. ป ปอน โตะ เซ ซ ลอก โรฮ ตุต ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“โตะ ทไว ปุย เซ, ดัฮ ลอก โอเอีฮ ป เมีญ พะจาว มัฮ ป รแอม ไล โฮ, เญาะ ไมจ โตว ปุย ปอน ฆาื อื. ไมจ เอิน ตอง โตะ งอ. ดัฮ มัฮ โตะ ซง่ะ ไล โฮ, เมาะ ป มัฮ ปุย ซง่ะ ไล ลัง ปอน อื. ");
INSERT INTO lcp_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ดัฮ ปุย ปอน เตือง โอ แตะ ซง่ะ ไล โฮ, ปุย เซ เญือะ เกียฮ เมีญ โตว มัฮ ปุย ไน โม อิซราเอน ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ดัฮ ไก ป ปอน โตะ ทไว ปุย ละ รโจะ อื รพาวม แตะ ไม่ พะจาว เตือง เอีจ ลอก แตะ ป โอ ซง่ะ ไล เยอ, เน่อึม นึง ปุย ญุ่ก, เน่อึม นึง ซัตซิง ญุ่ก, ปุ โรฮ เญือะ ไมจ เมีญ มัฮ ปุย ไน โม อิซราเอน โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, ป มัฮ ลออยฮ โมวก ญุ่ก, ลออยฮ แกะ ปิ ญุ่ก, ไมจ เปอะ โตว ปอน. ");
INSERT INTO lcp_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ดัฮ ไก ซัตซิง ยุม ไอฮ ญุ่ก, ยุม นึง เกียต กุก ซัตซิง ไฮญ อื ญุ่ก, ดัฮ เปอะ โกว ลออยฮ อื ตอก ไฮญ แปน, ปังเมอ โอ เปอะ ไมจ ปอน เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ดัฮ ไก ป ปอน ลออยฮ ซัตซิง เจือ ป โกว ปุย ละ ป โซม ป ปอน ทไว ปุย ละ พะจาว เยอ, เญือะ เกียฮ เมีญ โตว มัฮ ปุย ไน โม อิซราเอน ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","โนก ฮา เซ ปัง อาวต เปอะ นา ออฮ นา เอีฮ ญุ่ก, ไมจ เปอะ โตว ปอน ฮนัม ซัตซิง เฟือฮ เอิน. ฮนัม ไซม ญุ่ก, ฮนัม ซัตซิง ไฮญ ญุ่ก. ");
INSERT INTO lcp_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ดัฮ ไก ป ปอน ฮนัม เซ เญือะ เกียฮ เมีญ โตว โรฮ มัฮ ปุย ไน โม อิซราเอน ฆาื อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี. ดัฮ ไก ป โรวก ซัตซิง ละ ซ ทไว แตะ เกือฮ แปน ควน รโจะ เปอะ รพาวม แตะ ไม่ พะจาว โฮ, โอเอีฮ ป ลัง ทไว เปอะ ละ พะจาว นึง อื เซ ไมจ เนอึม เปอะ ทไว. ");
INSERT INTO lcp_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","เกือฮ ปุย เซ โรวก ไอฮ ป ลัง แปน ป โซม ป ปอน ทไว แตะ ละ พะจาว. เกือฮ โอก ลออยฮ อื ไม่ เนะ รน่าวก อื. เนะ รน่าวก อื เซ แปน ป กอยฮ อื ทไว. ");
INSERT INTO lcp_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ลออยฮ อื เซ เกือฮ โรฮ ซตุ ตอง ทไว ละ อื นึง คัน เซ. ป มัฮ เนะ รน่าวก อื เซ ปังเมอ มัฮ ป ลัง ละ อาโรน ไม่ จัตเจือ อื. ");
INSERT INTO lcp_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","33","ป มัฮ รเวือง ลวง ดอม ซัตซิง ทไว เปอะ ละ ซ รโจะ เปอะ รพาวม แตะ ไม่ พะจาว เซ, ไมจ เปอะ เกือฮ ละ ซตุ ป ไจไซ ทไว ฮนัม ไม่ ลออยฮ เซ รโตง เปอะ, นึง มัฮ อื ป ลัง โฮลฮ อื. ");
INSERT INTO lcp_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","ป มัฮ เนะ รน่าวก ป ทไว ปุย นึง ฆวต รโจะ อื รพาวม แตะ ไม่ พะจาว, ไม่ รเวือง ลวง ดอม อื เซ, อาึ เอีจ ไอฮ เน่อึม นึง โม อิซราเอน ละ ซ เกือฮ แตะ ละ อาโรน ไม่ จัตเจือ อื. เกือฮ แปน ป โฮลฮ ลอป อื ตอก เซ โอ เญาะ ไก ลอยจ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","มัฮ โอเอีฮ ตอก เซ ป ลัง โฮลฮ อาโรน ไม่ กวน อื เน่อึม นึง ป โซม ป ปอน ป ทไว ปุย ละ พะจาว เซ, เน่อึม ซเงะ แปน โรง อื ซตุ ละ ซ รซอฮ แตะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","โอเอีฮ ป ซตอก พะจาว ละ โม อิซราเอน ไน ซเงะ ดุฮ ปุย จัตเจือ อาโรน แปน ซตุ เซ, เกือฮ อื แปน ลอป โกตไม ละ อื ตอก เซ โอ เญาะ ไก ลอยจ. ");
INSERT INTO lcp_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","เมาะ โอเอีฮ โม เซ มัฮ ป เกว ไม่ โกตไม นึง ไลลวง ตอก ตอง ปุย ทไว โอเอีฮ ละ พะจาว เตือง ตัว อื, ไม่ ตอก ทไว ปุย เฮงาะ รโกะ, ป ทไว ปุย ละ โตฮ อื ติ แตะ ฮา มั่ป, ป ทไว ปุย เกือฮ แปน ควน ยวก มั่ป กัฮ ตุต, ป ทไว ละ ดุฮ ปุย เกือฮ แปน ซตุ, ไม่ ป ทไว ปุย นึง ฆวต รโจะ อื รพาวม แตะ ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","โอเอีฮ เซ มัฮ โรฮ ป อัฮ พะจาว ละ ไอ โมเซ นึง บลาวง ซีไน เญือม อาวต ลั่ง อื นึง ลาึน เวือฮ ละ ซ เกือฮ อื โม อิซราเอน ยุง ตอก ไมจ แตะ ทไว โอเอีฮ ละ พะจาว โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“กอก อาโรน ไม่ กวน รเมะ อื เกือฮ ฮอยจ นึง โตะ รเวือะ พากัง ระ ก ฮอยจ ปุย เคะ อาึ. เกือฮ โรวก เครอึง ซัมคัน ซตุ แตะ ไม่ ลออยฮ ซัมคัน เซ. เกือฮ โรฮ โรวก โมวก โปก ติ ตัว ละ แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ ไม่ แกะ โปก ลอา ตัว ไม่ คโนมปัง โอ ไก เจือ ติ เปียต. ");
INSERT INTO lcp_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","เกือฮ โม ลัปซด่อน รโจะ นา เซ เตือง โอยจ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ไอ โมเซ ยุฮ เนอึม อื ตัม ป อัฮ พะจาว ละ แตะ. โม ลัปซด่อน รโจะ เนอึม ลั่กกา รเวือะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ไอ โมเซ อัฮ เฮี, “ป ซ ยุฮ ฮุ ปเลี่ย เฮี มัฮ ป ซตอก พะจาว เอะ ยุฮ,” อัฮ เซ ละ ปุย โฮวน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ไอ โมเซ เกือฮ อาโรน ไม่ โม กวน รเมะ อื เซ ฮาวม ละ เกือฮ อื ติ แตะ ซง่ะ ตัม ไล อื. ");
INSERT INTO lcp_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","ฟวยจ ฮาวม อื ไอ โมเซ จาวป ลปิ ซตุ ละ อาโรน เตือง กไน ก พริ อื. ปุก แม พา นึง ญวย อื. จาวป โรฮ เอโฟต ละ อื. ปุก แม โม่ะฮุต ซัมคัน ไตญ ปุย ละ อื เซ นึง ญวย อื ราว เอโฟต เซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","เกือฮ โรฮ อื ไอฮ อื ไม่ ควน เลอึป รน่าวก ติ ปลัฮ เซ. ดุฮ อูริม ไม่ ทูมิม นึง อื. ");
INSERT INTO lcp_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ไอ โมเซ คัต แม โคะ ไฆญ ซัมคัน ละ อื. ปุก แม แพน ไคร ป มัฮ เคือง ไม ซัมคัน เซ นึง โคะ ไฆญ เซ ลั่กกา อื. ยุฮ เนอึม อื ตัม ป ซตอก พะจาว แตะ ยุฮ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","เญือม เซ ไอ โมเซ ตุย ลออยฮ ซัมคัน เซ ตา อื นึง พากัง ระ ไม่ เครอึง อาวต กไน อื โครยญ เจือ, ละ ซ เกือฮ อื แปน ป ซัมคัน ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ซพรอต โรฮ ลออยฮ เซ นึง คัน ระ เซ อาแลฮ เตะ เตือง เครอึง โกว ปุย นึง อื เตือง อาง ระ ฮอยจ ละ ชวง อื ละ ซ เกือฮ ตื อื แปน คอง ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ไอ โมเซ เรฮ ลออยฮ เซ นึง ไกญ อาโรน ง่อน ละ เกือฮ อื แปน ปุย ซัมคัน ยุฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ฟวยจ เซ โรวก โรฮ โม กวน อาโรน เกือฮ ฮอยจ นา เซ. จาวป โรฮ ลปิ ซตุ ละ อื. ปุก แม พา นึง ญวย อื. จาวป แม วอม พา ซัมคัน ละ อื ตัม ป ซตอก พะจาว แตะ ยุฮ. ");
INSERT INTO lcp_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ฟวยจ เซ ไอ โมเซ เมือะ โรวก โมวก โปก ติ ตัว ละ ซ เกือฮ อื แปน ควน โตฮ อื ปุย ฮา มั่ป ยุฮ อื. อาโรน ไม่ โม กวน อื ย่อง เตะ แตะ ราว ไกญ โมวก เซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ฟวยจ เซ ไอ โมเซ มอก โมวก เซ. ตุย ฮนัม อื. ชึต ด่อยฮ แตะ นึง ฮนัม เซ. ตา อื นึง โด่วง อาวต โจง คัน เซ เตือง ปาวน อื, ละ ซ เกือฮ อื คัน เซ แปน ป ซัมคัน ละ พะจาว. ฮนัม โฮฮ เซ โทก แม อื นึง ชวง คัน เซ. มัฮ ตอก เซ ตอก ทไว อื คัน เซ แปน ป ซง่ะ ซงอม ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ฮอย โรฮ ป มัฮ ลออยฮ โมวก เซ ป ติต ไม่ เครอึง กไน อื, ไม่ เบือ ลออยฮ ติต ไม่ โตม อื, ฮอยจ ละ เปละ อื เตือง ลอา ก บลัฮ อื, ไม่ ลออยฮ ติต ไม่ อื เตือง โอยจ อื. ฟวยจ เซ ตอง อื ราว คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ป มัฮ โกะ โมวก เซ เยอ เตือง ฮัก ไม่ เนะ อื ฮอยจ ละ เวียกตู อื, ไอ โมเซ โอก โฮว ตอง อื ก พริ ไคะ อาวต ปุย เซ ตัม ป ดวน พะจาว แตะ ยุฮ. ");
INSERT INTO lcp_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ฟวยจ เซ ไอ โมเซ ตุย แม แกะ โปก ติ ตัว ละ ซ ตอง แตะ ทไว เตือง ตัว อื. เกือฮ โรฮ อาโรน ไม่ โม กวน อื ย่อง เตะ แตะ ราว ไกญ แกะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ไอ โมเซ มอก แม แกะ เซ. ป มัฮ ฮนัม อื เซ ซพรอต โรฮ อื นึง คัน ทไว เซ ปอ ไคว อื. ");
INSERT INTO lcp_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ฟวยจ เซ มอก แกะ เซ เลีฮ แปน ตอนๆ แตะ. ไกญ อื ไม่ ลออยฮ อื ตอง อื นึง งอ. ");
INSERT INTO lcp_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","ป มัฮ เครอึง กไน อื ไม่ ชวง อื เซ, รไซจ อื เกือฮ ซง่ะ. ฟวยจ เซ ตอง โรฮ ทไว อื เตือง โอยจ อื ตัม ป เอีจ ดวน พะจาว แตะ ยุฮ, ละ ซ เกือฮ อื แปน คอง ทไว นึง งอ, ป ซออย ฮงาื ละ พะจาว, ไม่ ปุก เนอึม อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","ฟวยจ เซ ไอ โมเซ ตุย แม แกะ โปก ติ ตัว ละ ซ ทไว แตะ ละ พะจาว, ละ ซ โกว แตะ นึง กัน ดุฮ แตะ เญือะ อาโรน แปน ซตุ. เกือฮ โรฮ อาโรน เซ ไม่ โม กวน อื ย่อง เตะ แตะ ราว ไกญ แกะ โปก เซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ไอ โมเซ มอก แม แกะ เซ, ตา โรฮ ฮนัม อื เซ นึง ฮละ ฮยวก ลวง ดอม อาโรน. ตา โรฮ อื ฮอยจ นึง โฆวน เตะ ไม่ โฆวน ชวง ลวง ดอม อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","ฟวยจ เซ เกือฮ โรฮ ป มัฮ โม กวน อาโรน เซ เลียก เคะ แตะ. ตา โรฮ ฮนัม เซ นึง ฮละ ฮยวก ลวง ดอม อื, ไม่ โฆวน เตะ โฆวน ชวง ลวง ดอม อื ตอก เซ โรฮ. ฟวยจ เซ ฮนัม เซ โทก โรฮ อื นึง คัน ทไว เซ ปอ ไคว อื. ");
INSERT INTO lcp_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","ไอ โมเซ ตุย โรฮ ลออยฮ แกะ เซ ป ติต ไม่ เครอึง กไน อื ไม่ ลออยฮ อาวต นึง ซตะ อื, ฮอยจ ละ เบือ ลออยฮ ป ติต ไม่ โตม อื. ตุย โรฮ ป มัฮ เปละ อื เตือง ลอา ก บลัฮ อื ไม่ ลออยฮ ป ติต ไม่ อื, ไม่ รเวือง ลวง ดอม อื. ");
INSERT INTO lcp_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ฟวยจ เซ ตุย แม คโนมปัง โอ ไก เจือ เน่อึม นึง โตะ เปียต ป อาึง ปุย ซองนา พะจาว เซ. มัฮ คโนมปัง โม่ว ติ โม่ว, มัฮ แม คโนมปัง ป เอีจ ซเบื่อก ปุย ไม่ ลออยฮ ติ กอน. มัฮ แม คโนม ยุฮ ปุย แปน แพน แตะ ติ แพน. อาึง อื ราว ลออยฮ ไม่ รเวือง ลวง ดอม แกะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","โอเอีฮ โม เซ เตือง โอยจ อื ยวก อาึง อื ราว เตะ อาโรน, ไม่ ราว เตะ โม กวน อื เซ, ละ ซ เกือฮ แตะ โอเอีฮ โม เซ แปน ป กอยฮ อื ทไว ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ฟวยจ เซ ไอ โมเซ ตุย แม โอเอีฮ โม เซ เน่อึม นึง เตะ เญือะ อาโรน เซ. ตอง ทไว ดิ อื ไม่ แกะ เอีจ ตอง แตะ ทไว เตือง ตัว อื เซ. เกือฮ แปน ป ทไว ปุย เญือม ดุฮ แตะ ปุย เกือฮ แปน ซตุ. ป ทไว อื นึง งอ เซ แปน เนอึม ป ซออย ฮงาื ละ พะจาว, ไม่ ปุก เนอึม รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ฟวยจ เซ ไอ โมเซ ตุย โรฮ เนะ รน่าวก แกะ เซ กอยฮ ทไว อื ละ พะจาว, นึง มัฮ อื ป ลัง โฮลฮ โกะ อื นึง แกะ เซ. ไอ โมเซ ยุฮ เนอึม อื ตัม รซอม ดวน พะจาว แตะ ยุฮ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","เญือม เซ ไอ โมเซ ตุย ลออยฮ ซัมคัน เซ ง่อน ไม่ ฮนัม อาวต นึง คัน เซ ง่อน. ซพรอต อื นึง อาโรน. ซพรอต โรฮ อื นึง เครอึง ซตุ จาวป อื เซ. ละ โม กวน อื ยุฮ โรฮ อื ตอก เซ. มัฮ ตอก เซ ตอก เกือฮ อื อาโรน ไม่ กวน อื แปน ปุย ซัมคัน ยุฮ พะจาว ฆาื อื เตือง เครอึง ซตุ จาวป อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ไอ โมเซ ดวน แม เญือะ อาโรน ตอก เฮี, “ไมจ เปอะ โตวง โตะ เซ นึง คระ เลียก ปุย โตะ พากัง เซ. ฟวยจ เซ ปอน นา เซ, โซม ไม่ คโนมปัง ป อาวต นึง เปียต อาึง ปุย อื เญือม ดุฮ แตะ ซตุ, ตัม ป เอีจ ซตอก พะจาว อาึง. ");
INSERT INTO lcp_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","โตะ ไม่ คโนมปัง เมาะ ป โฮฮ ลั่ง อื, ไมจ เปอะ ตอง โตะ งอ. ");
INSERT INTO lcp_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ฟวยจ เซ ไน อาแลฮ ซเงะ เอ เญือะ เปะ ไมจ เปอะ โตว โอก ฮา รเวือะ พากัง ระ เซ เฟือฮ เอิน, ฮอยจ ละ ฟวยจ ไลลวง ตอก ดุฮ พะจาว เญือะ เปะ แปน ซตุ รซอฮ ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","เมาะ ป โฮลฮ เอะ ยุฮ ซเงะ เนาะ เฮี, พะจาว มัฮ เกือฮ อื เอะ ยุฮ ละ รไซจ อื พิต โฌวะ ยุฮ โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ไมจ เปอะ อาวต กไน โตะ รเวือะ พากัง เฮี ฆาื อื อาแลฮ ซเงะ อาแลฮ ซาวม, ไม่ ยุฮ เปอะ ตัม ป ดวน พะจาว แตะ ยุฮ เดอึม เปอะ โอ ซ ยุม ฆาื. เฮี มัฮ ลปุง ซตอก พะจาว ละ เปอะ,” อัฮ เซ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","อาโรน ไม่ กวน อื ยุฮ เนอึม อื ตัม รซอม ดวน พะจาว ป ซึป ไอ โมเซ ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ไล ดุฮ ปุย เญือะ อาโรน แปน ซตุ เซ โกว เวลา อาแลฮ ซเงะ. ซเงะ ซเตะ นึง อื ไอ โมเซ กอก อาโรน ไม่ กวน อื. กอก โรฮ อื ไม่ โม ป กวต ป เฮียง ลลาึง โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","อัฮ เฮี ละ อาโรน, “ไมจ เปอะ โรวก ทไว กวน โมวก โปก ติ ตัว ละ ซ โตฮ เปอะ ติ แตะ ฮา มั่ป ยุฮ แตะ. โรวก โรฮ ไม่ แกะ โปก ติ ตัว ละ ซ ตอง เปอะ ทไว เตือง โม่ว อื. ลอา เจือ เซ ไมจ โตว อื ไก ตอก โละพริ เญี่ยะ เนอึม นึง มัฮ อื ป ซ ทไว เปอะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ไมจ โรฮ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี, ‘ไมจ เปอะ โรวก ทไว ปิ โปก ติ ตัว ละ ซ โตฮ เปอะ ติ แตะ ฮา มั่ป ยุฮ แตะ. โรวก แม กวน โมวก ติ ตัว ไม่ กวน แกะ ติ ตัว ป ไก อาญุ อื ติ ติ เนอึม, ไม่ โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม ละ ซ ตอง เปอะ ทไว เตือง โม่ว อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","โรวก แม โมวก โปก ติ ตัว ไม่ แกะ โปก ติ ตัว ละ ทไว เปอะ เกือฮ แปน ควน รโจะ เปอะ รพาวม แตะ ไม่ พะจาว. โรวก โรฮ แปง เงอ ซเบื่อก ไม่ ลออยฮ ละ โรวก เปอะ ทไว โรฮ. พะจาว ซ เลีฮ เปลีฮ ติ แตะ ละ เปอะ ซเงะ เนาะ เฮี’ ” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","โม เซ เตือง โอยจ อื โรวก เนอึม ป ดวน ไอ โมเซ แตะ โรวก ทไว ละ พะจาว เซ, ฮอยจ นึง พากัง ก ฮอยจ ปุย เคะ พะจาว เซ. โม ลัปซด่อน เตือง โอยจ อื เลียก ชุง ซดิ ซองนา พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ไอ โมเซ อัฮ เฮี ละ โม เซ, “โม เปะ เอีจ ยุฮ เนอึม เปอะ ตัม ป ซตอก พะจาว อาึง ละ แตะ. เคียง ยุฮ เปอะ ตอก เซ พะจาว ซ เปลีฮ รัง ซเปีย ยุฮ แตะ ละ เปอะ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ฟวยจ เซ อัฮ แม เฮี ละ อาโรน, “ไมจ เปอะ เลียก ทไว ควน โตฮ เปอะ ติ แตะ ฮา มั่ป ยุฮ โกะ เปอะ ไม่ ซัตซิง ตอง เปอะ ทไว เตือง ตัว อื. ทไว โรฮ รโตง โม ลัปซด่อน โรฮ. ซ แปน ควน รไซจ เปอะ พิต โฌวะ ยุฮ โกะ แตะ เตือง พิต โฌวะ ยุฮ โม ลัปซด่อน โรฮ, ตัม ลปุง ซตอก พะจาว อาึง,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","อาโรน เลียก เนอึม ละ คัน ยุฮ พะจาว เซ. มอก กวน โมวก ติ ตัว เซ ละ โตฮ อื ติ แตะ ฮา มั่ป ยุฮ โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","กวน อาโรน โรวก ฮนัม อื ละ อื. อาโรน ชึต ด่อยฮ แตะ นึง อื, ตา อื นึง โด่วง อาวต โจง คัน เซ เตือง ปาวน อื. ฮนัม โฮฮ เซ โทก อื นึง ชวง คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","ฟวยจ เซ ตอง ทไว ลออยฮ โมวก เซ นึง คัน. ตอง โรฮ เปละ อื ไม่ เบือ ลออยฮ ป ติต ไม่ โตม อื ตัม ป อัฮ พะจาว อาึง ละ ไอ โมเซ โฮ. ");
INSERT INTO lcp_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","โตะ โมวก เซ ไม่ ฮัก อื โรวก ตอง อื ก พริ ไคะ. ");
INSERT INTO lcp_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","ฟวยจ เซ อาโรน มอก แม ซัตซิง ติ ละ ซ ตอง อื ทไว เตือง ตัว อื รโตง โกะ แตะ ไอฮ. โม กวน อื โรวก ฮนัม เซ ละ อื. อาโรน เซ โทก อื นึง ชวง คัน เตือง ปาวน ลวง อื. ");
INSERT INTO lcp_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","ฟวยจ เซ โม กวน อื กอยฮ ไกญ อื ละ อื ไม่ โตะ อื แปน ตอน แปน ตอน แตะ. อาโรน ตอง ทไว อื นึง คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ฟวยจ เซ รไซจ เวียก อื ไม่ เครอึง ไฮญ อื ไม่ ชวง อื. อาึง โรฮ อื ราว โตะ โอเอีฮ ป ไก นึง คัน เซ. ตอง อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","ฟวยจ เซ อาโรน ทไว โรฮ ป โรวก โม ลัปซด่อน ทไว ละ พะจาว. ป โรวก อื เซ มัฮ ปิ ติ ตัว, ละ ซ เกือฮ อื แปน ควน โตฮ โม เซ ติ แตะ ฮา มั่ป. อาโรน เซ มอก ทไว อื ตอก ยุฮ แตะ ละ โมวก ทไว แตะ รโตง มั่ป ยุฮ โกะ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","ตุย โรฮ โรวก ซัตซิง ละ ซ ตอง แตะ ทไว เตือง ตัว อื รโตง โม ลัปซด่อน. มอก โรฮ ทไว อื ตัม ไล อัฮ พะจาว อาึง โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ตุย โรฮ เฮงาะ รโกะ ทไว โม ลัปซด่อน ติ ซบราวก เตะ แตะ. ตอง อื นึง คัน เซ. กัน ทไว ตอก เซ ตัง โน่ง ฮา ป กอ ทไว อื โครยญ ซเง่ะ. ");
INSERT INTO lcp_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","อาโรน เซ มอก โรฮ โมวก โปก เซ ไม่ แกะ โปก เซ ละ ซ ทไว อื เกือฮ แปน ควน รโจะ ดิ ปุย รพาวม แตะ ไม่ พะจาว. โม กวน อื โรวก ฮนัม อื ละ อื. อาโรน โทก ฮนัม เซ นึง ชวง คัน เตือง ปาวน ลวง อื. ");
INSERT INTO lcp_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","20","ฟวยจ เซ อาโรน ตุย รน่าวก แกะ ไม่ โมวก เซ อาึง อื ราว คัน. ตุย แม โรฮ ลออยฮ ไม่ เบือ ลออยฮ ป ติต ไม่ เครอึง กไน อื ไม่ ลออยฮ ป ติต ไม่ ซตะ อื อาึง อื ราว รน่าวก โมวก ไม่ แกะ เซ. ลออยฮ นึง อื ตอง ทไว อื นึง คัน. ");
INSERT INTO lcp_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","รน่าวก อื ไม่ รเวือง ลวง ดอม อื ปังเมอ แปน ป กอยฮ อื ทไว ละ พะจาว, (แปน โรฮ ป โซม ป ปอน ละ โม ซตุ.) ตัม ป อัฮ ไอ โมเซ อาึง. ");
INSERT INTO lcp_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","เญือม เอีจ ฟวยจ ทไว อาโรน โอเอีฮ ตอก เซ, ยวก เตะ แตะ เตือง ลอา ก บลัฮ อื ราว โม ลัปซด่อน. ปิฮ มุ่น ละ อื. ฟวยจ เซ เลีฮ เน่อึม ทไว แตะ โอเอีฮ นึง คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","เญือม เซ ไอ โมเซ ไม่ อาโรน เลียก โตะ พากัง นา ก ฮอยจ ปุย เคะ พะจาว. เญือม โอก แม อื ปิฮ มุ่น ละ โม ลัปซด่อน. เญือม เซ รัง ซเปีย คึนัก ยุฮ พะจาว เปลีฮ ติ แตะ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","เญือม เซ งอ ยุฮ พะจาว โอก พราวป เอิน, ฮะ ยุฮ โตะ โอเอีฮ ไม่ ลออยฮ โอเอีฮ ป อาวต นึง คัน เซ. โม ลัปซด่อน เญือม ยุ อื โอเอีฮ ตอก เซ รโอง เรียง. นุ่ม ติ แตะ ปอ จิ ไกญ แตะ เตะ. ");
INSERT INTO lcp_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","กวน อาโรน ป มัฮ นาดั่ป ไม่ อาบี่ฮู ตุย โรวก โดง งอ ยุฮ แตะ ติ ปุย ติ. ดุฮ รฆุ งอ ยุฮ โกะ แตะ นึง อื. ดุฮ โรฮ ป ซออย ฮงาื นึง อื โรฮ. ทไว อื ละ พะจาว ตัม รพาวม โกะ แตะ. งอ เซ มัฮ โตว ป ลัง โกว ปุย ละ พะจาว นึง โอ พะจาว ดวน อื ยุฮ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","เญือม เซ งอ ยุฮ พะจาว โอก พราวป เอิน, ฮะ ยุฮ ปุย ลอา เซ. ยุม เอิน ซองนา พะจาว นึง พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","เญือม เซ ไอ โมเซ อัฮ เฮี ละ อาโรน. “เอีจ มัฮ เฮี ป อัฮ พะจาว ละ เปอะ, ‘เมาะ ป รซอฮ ละ อาึ เตือง โอยจ อื ไมจ อื เมีญ อาึ มัฮ ป ซัมคัน เนอึม. อาึ ซ เปลีฮ อัมนัต โญตซัก แตะ ละ ปุย เตือง โอยจ อื,’ อัฮ เซ ละ เปอะ พะจาว,” อัฮ เซ. อาโรน เกียฮ โลยฮ โตว อื ติ มวยญ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ไอ โมเซ กอก มิชาเอน ไม่ เอละซาฟัน ป มัฮ กวน อุซีเอน, ติญ อาโรน เซ, เอีญ เคะ แตะ. อัฮ เฮี ละ อื, “กลอม โรวก เอียกปุ เปอะ เฮี เกือฮ โอก ฮา พากัง ยุฮ พะจาว, ตาว เกือฮ โอก ก พริ ไคะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","โม เซ เลียก กลอม เนอึม โรวก ปุย ลอา เซ เตือง เครอึง เซอึก ซัมคัน ยุฮ อื, ตาว อื ก พริ ไคะ ตัม ดวน ไอ โมเซ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ไอ โมเซ อัฮ อื ละ อาโรน ไม่ กวน รเมะ ป ไอม ลั่ง อื ป มัฮ เอเลอาซา ไม่ อิทามา เซ ตอก เฮี, “ปุ เกือฮ ฮาึก เปอะ ซรุย. ปุ แจฮ เครอึง เซอึก เปอะ ตอก ยุฮ ปุย ละ ซ เปลีฮ อื รพาวม ตุก แตะ. ดัฮ เปอะ ยุฮ ตอก เซ ซ ยุม เปอะ. พะจาว ซ ฮาวก รพาวม ละ ปุย เตือง โอยจ อื ฆาื อื. มัฮ โม ลัปซด่อน ป ซ โฮลฮ เยือม โม ป ลอก งอ ยุฮ พะจาว เฮี. มัฮ โม เอียกปุ อิซราเอน เปอะ เตือง โต อื. โม เปะ ปุ เยือม. ");
INSERT INTO lcp_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ปุ โอก ฮา รเวือะ พากัง เฮี เฟือฮ เอิน เดอึม เปอะ โอ ซ ยุม ฆาื, นึง เอีจ เลือก พะจาว โม เปะ เกือฮ ตัง โน่ง ฮา ปุย ไฮญ. เอีจ ไก ลออยฮ ซัมคัน ยุฮ พะจาว นึง เปอะ,” อัฮ เซ ละ อื. เญือะ อาโรน เซ ยุฮ เนอึม อื ตัม ป อัฮ ไอ โมเซ ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","พะจาว อัฮ เฮี ละ อาโรน, ");
INSERT INTO lcp_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“ปะ ไม่ กวน เปอะ เญือม ซ เลียก เปอะ นึง พากัง ก ฮอยจ ปุย เคะ อาึ, ปุ ญุ ไปล เฟือฮ เอิน, ไปล อะงุน ญุ่ก, ไปล ตอก ไฮญ ญุ่ก, เดอึม เปอะ โอ ซ ยุม. ไล เฮี เยอ ไมจ เปอะ เกือฮ แปน โกตไม ตอน ฮมัน ละ แตะ ละ ซ ยุฮ ลอป เปอะ โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","โม เปะ ไมจ เปอะ เกือฮ โอเอีฮ ซัมคัน ยุฮ พะจาว ตัง ฮา โอเอีฮ ทัมมด่า. โอเอีฮ ป เอีจ ซง่ะ ไล ละ พะจาว ไมจ อื ตัง ฮา โอเอีฮ ป โอ ซง่ะ ไล. ");
INSERT INTO lcp_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","โม เปะ ไมจ เปอะ เพอึก โม อิซราเอน เกือฮ ยุฮ อื ตัม โกตไม ยุฮ พะจาว โครยญ เจือ ตัม ป อัฮ ไอ โมเซ อาึง ละ อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ไอ โมเซ อัฮ อื ละ อาโรน ไม่ เอเลอาซา ไม่ อิทามา ป มัฮ กวน อาโรน ป ไก ลั่ง ลอา ปุย เซ ตอก เฮี, “ตุย แปง ทไว ปุย ป โฮฮ ลั่ง อื ฮา ป ตอง ปุย ทไว ละ พะจาว เซ. ยุฮ คโนม โอ ไก เจือ นึง. ฟวยจ เซ โซม โบ คัน ทไว เซ, นึง มัฮ คอง ทไว เซ ป ซัมคัน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ไมจ โรฮ เปอะ โซม นึง นาตี ซัมคัน อื ฆาื อื, นึง เอีจ มัฮ โรฮ อื ป ลัง โฮลฮ ปะ ไม่ กวน รเมะ เปอะ เน่อึม นึง โอเอีฮ ป ฮอยจ ทไว ปุย ละ พะจาว, ตัม ป อัฮ พะจาว อาึง. ");
INSERT INTO lcp_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ป มัฮ เนะ รน่าวก ซัตซิง กอยฮ ปุย ทไว เซ, ไม่ รเวือง เกือฮ ปุย ละ เปอะ เซ, โซม ปอน ดิ เปอะ ไม่ กวน รเมะ กวน รโปวน เปอะ แปน, ดัฮ มัฮ นา ก ซง่ะ ไล อื. โอเอีฮ เซ เอีจ มัฮ โรฮ ป ลัง โฮลฮ เญือะ เปะ ฮอยจ ละ กวน เฌือต เปอะ เตือง โอยจ อื, เน่อึม นึง ป ทไว โม อิซราเอน ละ ซ รโจะ ดิ อื รพาวม แตะ ไม่ พะจาว โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","เญือม ฮอยจ ปุย ละ ซ กอยฮ แตะ ทไว ซัตซิง ละ พะจาว ไม่ ตอง แตะ ทไว ลออยฮ อื นึง งอ ละ พะจาว, รเวือง อื ไม่ เนะ รน่าวก อื มัฮ ป ลัง ละ โม เปะ ไม่ กวน เปอะ นึง มัฮ อื ป กอยฮ ปุย ทไว ละ พะจาว. โอเอีฮ เซ ซ มัฮ ลอป รโตง เปอะ ตัม ป อัฮ พะจาว อาึง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ไอ โมเซ ไฮมญ ฮมอง ไลลวง ปิ ทไว ปุย ละ โตฮ อื ติ แตะ ฮา มั่ป. ปิ ตัว เซ ปังเมอ เอีจ ตอง ปุย เตือง โอยจ อื. ไอ โมเซ รอก พาวม ฆาื อื นึง เอเลอาซา ไม่ อิทามา ป มัฮ กวน อาโรน ป ไก ลั่ง อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","อัฮ เฮี ละ อื, “โม เปะ เมอยุ โอ เปอะ โซม ปอน ป ทไว ปุย ละ โตฮ อื ติ แตะ เซ? โตะ ทไว อื เซ มัฮ ป ซง่ะ ซงอม. เมอยุ โอ เปอะ ปอน นึง นาตี ซัมคัน ยุฮ พะจาว เซ? พะจาว มัฮ เกือฮ อื คอง ทไว เซ ละ โม เปะ ละ ซ ตุย เปอะ โปวฮ มั่ป ยุฮ ปุย, ไม่ แปน อื ควน รไซจ พิต โฌวะ ยุฮ ปุย เตือง โอยจ อื ซองนา พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","แลน เมิฮ. เคียง เมอ โอ อื มัฮ ซัตซิง โฮลฮ ปุย เลียก ตาว ฮนัม อื ฮอยจ กไน ฮอง ซัมคัน เซ, โม เปะ ลัง โซม ปอน เปอะ โตะ ปิ เซ นึง นาตี ซัมคัน เซ ตัม ป เอีจ อัฮ อาึ อาึง ละ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","เญือม ฮมอง อาโรน ป อัฮ ไอ โมเซ เซ, โลยฮ อื ละ อื ตอก เฮี, “ซเงะ เนาะ เฮี โม ลัปซด่อน ฮอยจ ทไว โอเอีฮ ละ ซ โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ ไม่ ตอง อื ทไว ซัตซิง ละ พะจาว เตือง ตัว อื. เนาะ เฮี อาึ ปังเมอ มัฮ ซเงะ เกิต ไลจ โละ โซะ ยุม เนิ. ดัฮ อาึ โซม ปอน โฮ อัม มัฮ อื ป ปุก รพาวม พะจาว เยอ?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","เญือม ฮมอง ไอ โมเซ ตอก โลยฮ อาโรน อื ละ แตะ เซ, ปุก โรฮ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ ไม่ อาโรน. ");
INSERT INTO lcp_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน เกือฮ ยุง ป มัฮ ซัตซิง อาวต นึง โบ่ก ป ลัง ปอน แตะ โตะ อื ไม่ ป โอ อื ลัง ปอน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ป มัฮ ซัตซิง รกัฮ กลอฮ ไม่ ไก แกลฮ อื, ไม่ มัม อื เวียกซอง แตะ ลัง ปอน เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","ปัง มัฮ ตอก เซ ไก ง่อน ซัตซิง ป มัม เวียกซอง แตะ ปังเมอ โอ รกัฮ กลอฮ, ตอก อุต โฮ. ซัตซิง ตอก เซ แปน ซัตซิง โอ ซง่ะ ไล ฆาื อื ละ โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ครอย เยอ มัฮ โรฮ ตอก เซ. มัม โรฮ เวียกซอง แตะ ปังเมอ โอ รกัฮ กลอฮ. แปน โรฮ ซัตซิง โอ ซง่ะ ไล ฆาื อื ละ โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","กไต ตอก โรฮ เซ. มัม โรฮ เวียกซอง แตะ ปังเมอ โอ รกัฮ กลอฮ. แปน โรฮ ซัตซิง โอ ซง่ะ ไล ฆาื อื ละ โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","เลีจ มัฮ โรฮ ป รกัฮ กลอฮ ปังเมอ โอ มัม เวียกซอง แตะ. แปน โรฮ ซัตซิง โอ ซง่ะ ไล ละ โม เปะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","เมาะ ซัตซิง โม เซ ปุ ปอน เฟือฮ เอิน. ดัฮ เอีจ ยุม โฮ ปุ โรฮ ลอก เฟือฮ เอิน, นึง มัฮ อื ซัตซิง โอ ซง่ะ ไล ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“เมาะ ป มัฮ ซัตซิง อาวต โตะ รอาวม เมอ, อาวต โตะ โกลง ญุ่ก, อาวต โตะ ปลัฮ รอาวม ญุ่ก, ดัฮ มัฮ ป ไก โพรยจ อื ไม่ ไก รปอฮ อื โฮ, ลัง ปอน เปอะ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ดัฮ โอ ไก โพรยจ โอ ไก รปอฮ โฮ, ไมจ เปอะ โตว ปอน เฟือฮ. ไมจ เปอะ เมีญ มัฮ ป รแอม ไล ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","ปัง มัฮ เมาะ ลอก เปอะ ป เอีจ ยุม อื ญุ่ก, ไมจ เปอะ โตว ลอก. ");
INSERT INTO lcp_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","เมาะ ป มัฮ ซัตซิง อาวต โตะ รอาวม ดัฮ มัฮ ป โอ อื ไก โพรยจ ไม่ โอ อื ไก รปอฮ โฮ, มัฮ โอยจ ป โอ ซง่ะ ไล ละ เปอะ. ไมจ เปอะ โตว ปอน เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“เฮี มัฮ แม ไลลวง ไซม ป ไมจ เปอะ เมีญ มัฮ ป รแอม ไล ละ แตะ ไม่ โอ เปอะ ไมจ ปอน. มัฮ กลัง ลอง, เรียง ลอง, เรียง ปิญ, ");
INSERT INTO lcp_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","กลัง อัฮ ไม่ กลัง เจือ ไฮญ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","16","รงั่ก, ปลักโปลฮ, โนก กะจอกเทต, โนก นังนวน, เฆลียง, ");
INSERT INTO lcp_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","จักซจาว, ตวต, ปลักโปลฮ ระ, ");
INSERT INTO lcp_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ปลักโปลฮ ปิญ, โนก อีโกง, กลัง กะ, ");
INSERT INTO lcp_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","โนก กตา ลอง ไม่ โนก กตา ปิญ, ไซม เลเล ไม่ บลัก. ");
INSERT INTO lcp_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ซัตซิง แตวะๆ ป ไก โพรยจ ละ โปว แตะ ไม่ เกียฮ โฮว อื ลังเตะ, ไมจ เปอะ เมีญ มัฮ ป รแอม ไล ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ปังเมอ ไก โรฮ ง่อน ป ไก โพรยจ อื ไม่ ไก โรฮ ชวง อื ไม่ เกียฮ แฮนป อื ชวง แตะ เซ ละ ซ เตน แตะ. โอเอีฮ โม เซ ลัง ปอน โรฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ตอก โรฮ ดักดวน ไม่ จักจัน, ซดู ไม่ ซฆลา โครยญ เจือ อื ลัง ปอน เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","โอเอีฮ ไฮญ ป ไก โพรยจ ไม่ ไก ชวง ตอก เซ ไมจ เปอะ เมีญ มัฮ ป รแอม ไล ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“เมาะ โอเอีฮ โม เฮี เตือง โอยจ อื มัฮ ตื ป เกือฮ โม เปะ โอ ซง่ะ ไล ฆาื อื. ดัฮ ไก ป โคะ ลอก ป เอีจ ยุม อื, ซ รแอม ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ดัฮ ไก ป โรวก ซัตซิง ตอก เซ ป เอีจ ยุม อื, ไมจ อื ซัก เครอึง เซอึก แตะ ฆาื อื เกือฮ ซง่ะ. โกะ อื แปน โรฮ ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ซัตซิง ป เอีจ ยุม ป ไก กลอฮ ไม่ โอ กลอฮ อื เซ รกัฮ, ไม่ โอ โรฮ อื มัม เวียกซอง แตะ โฮ, เอีจ มัฮ โรฮ ซัตซิง โอ ซง่ะ ไล ละ โม เปะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","เมาะ ป มัฮ ซัตซิง ไก ชวง ปาวน ป ไก ไฮมม มัฮ โอยจ โรฮ ซัตซิง โอ ซง่ะ ละ โม เปะ. ซัตซิง ลอา เจือ เซ ดัฮ ไก ป ลอก ป ไปญ ป เอีจ ยุม อื, ปุย เซ แปน ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ดัฮ ไก ป โรวก ซัตซิง ตอก เซ ป เอีจ ยุม อื, ไมจ ปุย เซ ซัก เครอึง เซอึก แตะ ฆาื อื เกือฮ ซง่ะ, นึง มัฮ ซัตซิง โรวก อื เซ ป โอ ซง่ะ ไล, ไม่ แปน โรฮ อื ควน เกือฮ ปุย โอ ซง่ะ ไล ฆาื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","30","“เมาะ ป มัฮ ซัตซิง เจือ แตวะ ป ไร ลังเตะ เอ, ป โอ อื ซง่ะ ไล ละ เปอะ, มัฮ โอเอีฮ โม เฮี. มัฮ ซอ, เกือง, จวยฮ, ตอกแก, ฆอย, นะโนว, ซเคราะ ไม่ แงะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","เมาะ ป มัฮ ซัตซิง เจือ แตวะๆ ป ไร ลังเตะ เซ มัฮ ตื ป โอ ซง่ะ ไล ละ เปอะ. ดัฮ ไก ป ลอก ป ไปญ ป เอีจ ยุม อื, ปุย เซ แปน ปุย โอ ซง่ะ ไล ฆาื อื ไน ซเงะ เซ ฮอยจ ละ เลียก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ดัฮ โกะ ยุม โอเอีฮ โอ ซง่ะ ไล เซ ดุฮ ราว เครอึง ป โกว เปอะ นึง เญือะ นึง ม่า, ตอก ป ยุฮ ปุย นึง โคะ นึง ฮัก ญุ่ก, ตอก ฮาื ไม่ โอเอีฮ ยุฮ ปุย นึง บ่วตชุ ญุ่ก, ลอต แปน ป รแอม ไล ฆาื อื. ไมจ เปอะ เดอึม โตะ รอาวม. เญือม เอีจ เลียก ซเงะ เอ เดอึม ซ เกียฮ แปน แม ป ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","ดัฮ โอเอีฮ ยุม เซ ดุฮ โตะ โดง เตะ โฮ, ป อาวต โตะ โดง เตะ เซ เญือะ ซง่ะ โตว โรฮ ไล ฆาื อื. ไมจ โรฮ เปอะ ยุฮ ไลจ ไม่ โดง เตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ดัฮ เปอะ โกว ลั่ง โดง เซ ละ อาึง แตะ ป โซม ป ปอน ไม่ รอาวม นึง, โอเอีฮ เมาะ ป อาวต โตะ โดง เซ ซ แปน โอยจ ป รแอม ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ซัตซิง โอ ซง่ะ ไล ดัฮ ยุม ไม่ ดุฮ อื ราว โอเอีฮ, ราว ตาว งอ ญุ่ก, ราว ตาว โอป ญุ่ก, ไมจ ตื ยุฮ ไลจ ไม่ นึง โอ อื เญือะ ซง่ะ ไล ละ โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ปัง มัฮ ตอก เซ, ดัฮ มัฮ ดุฮ อื โตะ นัมโม่ ญุ่ก, ทัง เกป ปุย รอาวม ญุ่ก, นัมโม่ ไม่ ทัง เซ ซง่ะ ลั่ง. มัฮ รอาวม ลอก ป ยุม นึง อื เซ โน่ง ป แปน ป รแอม ไล เยอ. ");
INSERT INTO lcp_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ดัฮ ดุฮ ราว โนง ป ซมา ปุย โฮ, โนง ป ซมา เซ ดิ รแอม โตว โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ดัฮ โนง ป ซมา เซ เดอึม เอิน ติ แตะ นึง โตะ รอาวม อาวต ซัตซิง ยุม เซ โฮ, ปังเมอ แปน โนง ป ซมา โอ เญือะ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ซัตซิง ป ลัง ปอน ปุย โตะ อื, ดัฮ ยุม ไอฮ โฮ, ป ลอก ป ไปญ ซัตซิง เซ แปน ปุย โอ เญือะ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ดัฮ ไก ป ลอก ป ไปญ ไม่ โรวก แตะ ญุ่ก, ป โซม ปอน โตะ เซ ญุ่ก, ไมจ อื ซัก เครอึง เซอึก แตะ ซง่ะ ฆาื อื, ไม่ แปน ลั่ง อื ปุย โอ ซง่ะ ไล ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","42","“เมาะ ซัตซิง แตวะๆ ป ไร ลังเตะ เอ, ป โฮว นึง ชวง ปาวน แตะ ญุ่ก, ป โฮว นึง ชวง โฮวน แตะ ญุ่ก, ป ไร นึง เวียก แตะ ญุ่ก, ไมจ เปอะ เมีญ มัฮ ป รแอม ไล ละ แตะ. ปุ ปอน เฟือฮ เอิน. ");
INSERT INTO lcp_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ปุ เกือฮ ติ เปอะ รแอม ไล ฆาื ซัตซิง โม เซ ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ไมจ เปอะ เกือฮ ติ แตะ ซง่ะ ซงอม, นึง มัฮ อาึ ป ซง่ะ ซงอม. ปุ เกือฮ ติ เปอะ รแอม ไล ฆาื ซัตซิง ป ไร นึง เตะ นึง รกาื เซ ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","เอีจ มัฮ อาึ พะจาว ป นัม โม เปะ โอก ฮา เมือง อียิป เปอ, ละ ซ แปน เนอะ พะจาว ยุฮ เปอะ. เคียง มัฮ อื ตอก เซ, ไมจ เปอะ เกือฮ ติ แตะ ซง่ะ ซงอม นึง มัฮ อาึ ป ซง่ะ ซงอม. ");
INSERT INTO lcp_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“เมาะ โอเอีฮ โม เซ มัฮ โกตไม เกว ไม่ ไลลวง ซัตซิง เตือง ไซม ไม่ ซัตซิง ป อาวต โตะ รอาวม, ฮอยจ ละ ซัตซิง ป ไร นึง เตะ รกาื โครยญ เจือ, ");
INSERT INTO lcp_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","ละ ซ เกือฮ โม เปะ เกียฮ ยุง ที ไม่ ยุง แตะ ป มัฮ ซัตซิง ซง่ะ ไล ไม่ ป โอ อื ซง่ะ ไล โรฮ, ฮอยจ ละ ซัตซิง ลัง ปอน เปอะ ไม่ ป โอ เปอะ ลัง ปอน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, ดัฮ ไก ปรโปวน เกิต กวน ไม่ รเมะ กวน อื เซ, ปุย เซ แปน โรฮ ปุย โอ ซง่ะ ไล เน่อึม เญือม เกิต โรง กวน อื เซ ฮอยจ ซเงะ อาแลฮ, ตอก โรฮ โอ อื ซง่ะ ไล เญือม ไก ปะจัม เดื่อน แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","เญือม เอีจ มัฮ อื ซเงะ ซเตะ นึง อื, ไมจ อื เกือฮ กวน รเมะ แตะ เซ เลียก นึง ริตกิต. ");
INSERT INTO lcp_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ฟวยจ เซ ไน ติ เจน ง่วย โรฮ ลอวย ซเงะ เอ, ปรโปวน เซ แปน ลั่ง ป โอ ซง่ะ ไล ฆาื โอก ฮนัม แตะ เซ. ไมจ โตว อื โฮว ฮอยจ นึง พากัง ระ เซ, ไม่ โอ โรฮ อื ไมจ ลอก โอเอีฮ ป ซัมคัน ติ เจือ เนอึม, ฮอยจ ละ เติง ซเงะ โฮลฮ อื แปน ปุย ซง่ะ ไล. ");
INSERT INTO lcp_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","ดัฮ กวน เกิต อื เซ มัฮ ปรโปวน โฮ, มะ อื เซ ซ แปน โรฮ ปุย โอ ซง่ะ ไล ฆาื อื ลอา ควป ซเงะ, ตอก โรฮ โอ อื ซง่ะ เญือม ไก ปะจัม เดื่อน แตะ โฮ. ฟวยจ เซ ไมจ แม อื มอง ฮอยจ ละ กุม อื ลแฆลฮ โรฮ แลฮ ซเงะ แม ฮอยจ ละ เติง เวลา โฮลฮ อื แปน ปุย ซง่ะ ไล โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“เญือม เอีจ โปน เวลา ลัง มอง อื เซ, ปรเมะ กวน ญุ่ก, ปรโปวน กวน ญุ่ก, ไมจ อื โฮว เคะ ซตุ ฮอยจ นึง โตะ รเวือะ พากัง ระ เซ ไม่ โรวก อื กวน แกะ ป ไก อาญุ อื ติ เนอึม ละ ซ ตอง แตะ ทไว เตือง ตัว อื. ไมจ โรฮ อื โรวก ไม่ โนกพิลัป ติ ตัว, โต เซ อื รโกะเกอื ติ ตัว, ละ ซ ทไว อื แปน ควน โตฮ ติ แตะ ฮา มั่ป. ");
INSERT INTO lcp_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","ซตุ เซ ซ ทไว อื ละ พะจาว รโตง อื. มัฮ ตอก เซ ตอก รไซจ อื พิต โฌวะ ยุฮ แตะ เกือฮ ซง่ะ อา. ฟวยจ เซ ปรโปวน เซ ซ แปน ปุย ซง่ะ ไล ฆาื อื นึง ไลลวง ฮนัม แตะ เซ. มัฮ ตอก เซ โกตไม ไก ละ โม ปรโปวน นึง ไลลวง เกิต กวน รเมะ กวน รโปวน อื. ");
INSERT INTO lcp_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","ดัฮ ปรโปวน เซ โอ ไก ตอก โฮลฮ โรวก กวน แกะ เซ โฮ, เกือฮ โรวก รโกะเกอื ลอา ตัว, โต เซ อื โนกพิลัป ลอา ตัว. ติ ตัว อื แปน ควน ตอง อื ทไว เตือง ตัว อื. ติ ตัว อื เซ แปน โรฮ ป ทไว อื ละ โตฮ อื ติ แตะ ฮา มั่ป. เกือฮ โรฮ ซตุ เซ ทไว ละ พะจาว รโตง อื, ละ ซ รไซจ อื พิต โฌาะ ยุฮ แตะ เซ เกือฮ ซง่ะ, เดอึม ซ แปน ปุย ซง่ะ ไล ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","พะจาว อัฮ แม เฮี ละ ไอ โมเซ ไม่ อาโรน. ");
INSERT INTO lcp_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ดัฮ ไก ป ไก เบิ ไก กลัง นึง เนะ นึง ฮัก อื, ไม่ ยุ เปอะ ไก รปอฮ ไม่ เฆรีญ ฮัก อื เซ, ดัฮ เปอะ ซองไซ นึง มัฮ อื ลาวต โฮ, ไมจ เปอะ ตาว ปุย เซ เกือฮ ฮอยจ เคะ ซตุ ป มัฮ จัตเจือ อาโรน เซ, ");
INSERT INTO lcp_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","เกือฮ ซตุ เซ แลน ละ อื. ดัฮ ฮาึก นึง ก เบิ ก กลัง อื เซ ปิญ ไม่ เลียก โด่ะ โรฮ เฆรีญ อื เซ ฮา ปิม ฮัก ไจ อื, มัฮ มัฮ อื ลาวต. ดัฮ ซตุ เซ ยุ มัฮ อื ลาวต โฮ, เกือฮ รโฮงะ อื ละ ปุย มัฮ อื ปุย รแอม ไล เยอ. ");
INSERT INTO lcp_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ดัฮ ฮัก นา ก กลัง อื เซ ปิญ, ไม่ ยุ แตะ โอ กลัง อื เซ โด่ะ ฮา ฮัก อื, ไม่ โอ โรฮ ฮาึก อื เซ ปิญ โฮ, ไมจ ซตุ เซ ทอเนาะ โน่ง ปุย เซ อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","เญือม เอีจ ฮอยจ อื ซเงะ อาแลฮ เซ เกือฮ แม ซตุ เซ กวต แลน ติ โฮน แม. ดัฮ ยุ โอ เฆรีญ อื เซ ราวก ฮา ไพรม แตะ โฮ, เกือฮ แม ซตุ เซ ทอเนาะ โน่ง ปุย เซ อาแลฮ ซเงะ แม. ");
INSERT INTO lcp_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","เญือม เอีจ ฮอยจ อื ซเงะ อาแลฮ เซ เกือฮ แม แลน อื ติ โฮน. ดัฮ ยุ ไฆร เฆรีญ อื เซ ฮา ไพรม แตะ ไม่ โอ อื เวือ ติ แตะ ฮา ไพรม แตะ, มัฮ มัฮ อื เฆรีญ ทัมมด่า. ไมจ โรฮ ซตุ เซ รโฮงะ ละ ปุย มัฮ ปุย เซ ปุย ซง่ะ ไล เยอ. เกือฮ โรฮ ปุย เซ ซัก เครอึง เซอึก แตะ เกือฮ ซง่ะ. ปุย เซ ซ ซง่ะ เนอึม ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ดัฮ ปุย เซ ราวก แม เบราะ กัง เคะ เญือม เอีจ ฟวยจ แลน ซตุ แตะ, ไม่ เอีจ ฟวยจ เมีญ อื แปน ปุย ซง่ะ โฮ, ดัฮ เฆรีญ อื เซ เวือ แม ติ แตะ ฮา ไพรม แตะ, ไมจ แม อื ฮอยจ เปลีฮ ติ แตะ ละ ซตุ แม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ดัฮ ซตุ เซ ยุ เนอึม ราวก เฆรีญ ปุย เซ ฮา ไพรม แตะ, เกือฮ ซตุ เซ รโฮงะ ละ ปุย มัฮ ปุย เซ ปุย โอ ซง่ะ ไล ไม่ ลอก แตะ ลาวต. ");
INSERT INTO lcp_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ดัฮ ไก ป เบราะ แปน ลาวต เตอ, ไมจ ปุย ตาว ปุย เซ ฮอยจ เคะ ซตุ. ");
INSERT INTO lcp_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","เกือฮ ซตุ เซ กวต แลน ปุย เซ. ดัฮ ฮัก อื เซ ออยฮ ไม่ โอก ซี ปิญ นึง ฮัก อื เซ, ไม่ ปิญ โรฮ ฮาึก นึง อื เซ, ไม่ ราวก เนะ นา ก ปาวม อื เซ โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ปุย เซ มัฮ ลอก อื ลาวต. เกือฮ โรฮ ซตุ เซ รโฮงะ ละ ปุย มัฮ ปุย เซ ปุย รแอม ไล เยอ. เญือะ จัมเปน โตว มอง แลน ละ อื ฮัม นึง เอีจ แจง มัฮ อื ปุย เอีจ รแอม เนอึม ไล. ");
INSERT INTO lcp_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“ดัฮ ป ปิญ นึง ฮัก อื เซ เวือ ติ แตะ, เวือฮ ปุ ปุ ปอ เลี่ป เอิน อื โกะ อื เน่อึม นึง ไกญ อื ฮอยจ ละ ชวง อื โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","เกือฮ ซตุ เซ กวต แลน แม ติ โฮน. ดัฮ ยุ เลี่ป เนอึม อื โกะ อื ตอก เซ โฮ, เกือฮ โรฮ ซตุ เซ รโฮงะ เอีจ ซง่ะ ไล อื ละ ปุย, นึง เอีจ ปิญ ฮัก อื เซ เตือง ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","ดัฮ ปุย เซ ตอ ราวก แม เนะ เญือม ออฮ เญือม เอีฮ ญุ่ก, ปุย เซ เอีจ แปน แม ปุย โอ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ไมจ เกือฮ ซตุ กวต แลน เบราะ อื เซ, ไม่ รโฮงะ โรฮ อื ละ ปุย มัฮ ปุย เซ ปุย รแอม ไล เยอ. เอีจ ที นึง ราวก เบราะ อื เซ มัฮ อื ปุย ลาวต เตอ, แปน ปุย โอ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","กัง เคะ เอ ดัฮ เบราะ อื เซ ไฮ ไม่ เปียน แม อื ติ แตะ แปน ซี ปิญ โฮ, เกือฮ ปุย เซ ฮอยจ เปลีฮ แม ติ แตะ ละ ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","เกือฮ โรฮ ซตุ เซ กวต แลน ปุย เซ. ดัฮ เบราะ อื เซ แปน เอิน ฮัก ปิญ โฮ, ไมจ แม ซตุ เซ รโฮงะ ละ ปุย มัฮ ปุย เซ ปุย ซง่ะ ไล เยอ. ");
INSERT INTO lcp_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ดัฮ ไก ปุย เกิต ปาวม นึง, ไม่ เอีจ ไฮ อื ติ โฮน เนอ, ");
INSERT INTO lcp_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ดัฮ เบือง ปาวม อื เซ ออยฮ แม, เกิต ซี ปิญ นึง ญุ่ก, ซี ซครัก ญุ่ก, ไมจ ปุย เซ โฮว เปลีฮ ติ แตะ ละ ซตุ. ");
INSERT INTO lcp_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","เกือฮ ซตุ เซ กวต แลน. ดัฮ ยุ ราวก เนอึม เบราะ อื เซ ไม่ โด่ะ อื ฮา ปิม ฮัก ไจ อื, ไม่ โอก โรฮ ฮาึก ปิญ นึง เบราะ อื เซ, เกือฮ โรฮ ซตุ เซ รโฮงะ ละ ปุย, มัฮ ปุย เซ ปุย โอ ซง่ะ ไล เยอ, ไม่ มัฮ เบราะ อื เซ ลาวต ป เกิต นึง เบือง ปาวม อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ดัฮ ซตุ เซ ยุ โอ อื ไก ฮาึก ปิญ นึง, ไม่ โอ เบราะ อื เซ โด่ะ ฮา ฮัก อื โฮ, เกือฮ ซตุ เซ ทอเนาะ โน่ง ปุย เซ ละ ซ แลน แตะ เบราะ อื เซ อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ดัฮ เบราะ อื เซ เวือ ติ แตะ เวือฮ ปุ ปุ, เกือฮ โรฮ ซตุ เซ รโฮงะ ละ ปุย มัฮ ปุย เซ ปุย โอ ซง่ะ ไล เยอ. ปุย เซ มัฮ ลอก อื ลาวต. ");
INSERT INTO lcp_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ดัฮ เบราะ อื โอ เวือ ติ แตะ ฮา ไพรม แตะ มัฮ มัฮ อื ฮรอย เบราะ ไพรม. เกือฮ โรฮ ซตุ เซ รโฮงะ ละ ปุย, มัฮ ปุย เซ ปุย เอีจ ซง่ะ ไล เยอ. ");
INSERT INTO lcp_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ดัฮ ไก ป ฮะ นึง งอ เยอ, ดัฮ เบราะ ก ฮะ อื เซ โระ ติ แตะ แปน ลาวม, ดัฮ โอก ซครัก ญุ่ก, โอก ปิญ ญุ่ก, เกือฮ โรฮ ซตุ เซ กวต แลน. ");
INSERT INTO lcp_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ดัฮ ฮาึก ปิญ โอก นึง เบราะ อื เซ, ไม่ ยุ แตะ โด่ะ เบราะ เซ ฮา ฮัก ไจ อื, มัฮ มัฮ อื ลาวต. มัฮ โอก อื ลลาึง เบราะ ฮะ เซ. ไมจ โรฮ ซตุ เซ รโฮงะ ละ ปุย มัฮ อื ปุย โอ ซง่ะ ไล เยอ, ไม่ มัฮ อื ลาวต. ");
INSERT INTO lcp_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ดัฮ ซตุ เซ เอีจ กวต แลน, ดัฮ ยุ โอ ฮาึก นึง อื ปิญ, ไม่ โอ โรฮ อื โด่ะ ฮา ฮัก ไจ อื โฮ, เกือฮ ทอเนาะ โน่ง ปุย เซ อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ดัฮ เอีจ ฮอยจ ซเงะ อาแลฮ เซ, ซตุ เซ ซ แลน แม อื. ดัฮ เบราะ อื เซ เวือ ติ แตะ ฮา ไพรม แตะ โฮ, ไมจ ซตุ เซ รโฮงะ ละ ปุย มัฮ ปุย เซ ปุย โอ ซง่ะ ไล, ไม่ มัฮ อื ลาวต. ");
INSERT INTO lcp_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ดัฮ เบราะ อื เซ อาวต เมาะ ไพรม แตะ ไม่ โอ อื เวือ ติ แตะ นึง ฮัก อื, มัฮ ออยฮ อื ฆาื ฮะ งอ แตะ. เกือฮ โรฮ ซตุ เซ รโฮงะ ละ ปุย มัฮ ปุย เซ ปุย ซง่ะ ไล เยอ. มัฮ มัฮ อื ฮรอย เบราะ ฆาื ฮะ แตะ นึง งอ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ดัฮ ไก ป ไก เบราะ นึง ไกญ นึง กัป เปอ, ปรเมะ ญุ่ก, ปรโปวน ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ไมจ ซตุ กวต แลน เบราะ อื เซ. ดัฮ ยุ โด่ะ เบราะ อื เซ ฮา ฮัก ไจ อื ไม่ ยุ โรฮ แตะ ซเงี ฮาึก อื ไม่ รมัฮ อื, เกือฮ โรฮ ซตุ เซ รโฮงะ ละ ปุย. ปุย เซ เอีจ แปน โรฮ ปุย โอ ซง่ะ ไล โรฮ. มัฮ ลอก อื โซะง่ะ. มัฮ ปุย ลาวต ไกญ ลาวต กัป. ");
INSERT INTO lcp_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ดัฮ ซตุ เซ ยุ โอ อื โด่ะ ฮา ฮัก ไจ อื, ไม่ โอ แตะ ดิ ยุ ฮาึก ไมจ นึง อื โฮ, เกือฮ ทอเนาะ โน่ง ปุย เซ อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ดัฮ เอีจ ไคว ซเงะ อาแลฮ เซ ซตุ เซ ซ แลน แม อื ติ โฮน. ดัฮ ยุ โอ เบราะ อื เซ เวือ ติ แตะ ฮา ไพรม แตะ ไม่ โอ โรฮ อื ยุ ฮาึก ซเงี นึง อื, ไม่ โอ เบราะ เซ โด่ะ ฮา ฮัก ไจ อื, ");
INSERT INTO lcp_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ไมจ เกือฮ ปุย เซ คุต ฮาึก แตะ เซ. ปังเมอ โอ อื ไมจ คุต ซื นา เบราะ อื เซ. ไมจ ซตุ เกือฮ ปุย เซ อาวต โน่ง แม อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ดัฮ เอีจ ไคว ซเงะ อาแลฮ เซ โฮ, ไมจ แม ซตุ เซ กวต แม แลน ก เฆรีญ อื เซ. ดัฮ เฆรีญ อื เซ โอ เวือ ติ แตะ ฮา ไพรม แตะ, ไม่ โอ โรฮ เบราะ อื เซ โด่ะ ฮา ฮัก ไจ อื, เกือฮ โรฮ ซตุ เซ รโฮงะ ละ ปุย, มัฮ ปุย เซ ปุย ซง่ะ ไล เยอ. ไมจ โรฮ ปุย เซ ซัก เครอึง เซอึก แตะ ซง่ะ เดอึม ซ แปน ปุย ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ดัฮ ปุย เซ เอีจ ฟวยจ รไซจ ติ แตะ เกือฮ ซง่ะ โฮ, ดัฮ ตอ ราวก แม เฆรีญ เซ ฮา ไพรม แตะ, ");
INSERT INTO lcp_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ไมจ แม ซตุ เซ กวต แลน. ดัฮ เฆรีญ อื เซ เวือ ติ แตะ ฮา ไพรม แตะ โฮว นึง ฮัก ไจ อื โฮ, เญือะ จัมเปน โตว มอง แลน ซเงี ฮาึก อื. เอีจ แจง มัฮ อื ปุย รแอม ไล เยอ. ");
INSERT INTO lcp_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ดัฮ ซตุ เซ ยุ ฌักแฟน อื ฮา ไพรม แตะ โฮ, ไม่ กวยฮ โรฮ ลั่ง ฮาึก ไมจ นึง นา เซ, เกือฮ โรฮ ซตุ รโฮงะ ละ ปุย, เอีจ แปน ปุย เซ ปุย ซง่ะ ไล เยอ. ");
INSERT INTO lcp_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ปรเมะ ญุ่ก, ปรโปวน ญุ่ก, ดัฮ ไก ฮรอย เคียน ปิญ นึง ฮัก อื โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ไมจ โรฮ ซตุ กวต แลน. ดัฮ เคียน นึง ฮัก อื เซ ปิญ แกม ปาื โฮ, มัฮ มัฮ อื เคียน ทัมมด่า. ปุย เซ ซง่ะ โรฮ ลั่ง ไล อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ดัฮ ไก ปรเมะ ฆรอยจ ฮาึก ไกญ ปอ ฮัวลัน เอิน อื, ปุย เซ ซง่ะ โรฮ ไล อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ดัฮ ไก ปรเมะ ฮัวลัน แด่ ญุ่ก, ป ฆรอยจ ฮาึก โซม เซาะ ญุ่ก, มัฮ โตว โรฮ ป เกือฮ ปุย เซ โอ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ดัฮ ไก ป เกิต เบราะ ซี ซเงี แกม ซครัก นึง ก ฮัวลัน อื เซ, เอีจ มัฮ โรฮ ลาวต อื ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ไมจ โรฮ เกือฮ ซตุ เซ กวต แลน. ดัฮ เบราะ ไกญ อื เซ ออยฮ, ไม่ แกม ซครัก แตะ นึง ไกญ อื ญุ่ก, นึง แด่ อื เซ ญุ่ก, ไม่ ตอก แตะ ลาวต โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ปุย เซ เอีจ มัฮ ลาวต อื. ไมจ โรฮ ซตุ รโฮงะ ละ ปุย มัฮ อื ปุย โอ เญือะ ซง่ะ ไล เยอ ฆาื ลาวต ไกญ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“โม ป ลอก ลาวต เซ, ไมจ อื จาวป ปุ โฮว เครอึง ชุ เครอึง แฌฮ, ไม่ พลวย โรฮ อื ฮาึก แตะ เกือฮ ลั่ง. เกือฮ โรฮ เพาะ มวยญ แตะ ไม่ อัฮ อื ปุ โฮว เฮี, ‘รแอม, รแอม’ ไมจ อื อัฮ ลอป เซ. ");
INSERT INTO lcp_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ไน ติ เจน ไก เบราะ อื เซ, ปุย เซ แปน เนอึม ปุย รแอม ไล ฆาื อื. ไมจ อื อาวต โน่ง ก พริ ไคะ. ");
INSERT INTO lcp_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ดัฮ เครอึง เซอึก โกว ปุย โอก ลไตฮ ฆอก นึง โฮ, เครอึง ยุฮ ปุย นึง ฮาึก ซัตซิง ญุ่ก, เครอึง ป ไตญ ปุย นึง กอย ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","เครอึง กอย รเซฮ กอย รติญ ญุ่ก, เครอึง ยุฮ ปุย นึง ฮัก ซัตซิง ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ดัฮ ลไตฮ เซ ติต เอิน กอย นึง เครอึง เซอึก เซ โฮ, ไม่ เกิต เอิน ซี ซครัก ซี ซงา นึง, เอีจ มัฮ มัฮ อื ลไตฮ ฆอก. ไมจ ปุย เซ โฮว เปลีฮ ละ ซตุ. ");
INSERT INTO lcp_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","เกือฮ โรฮ ซตุ กวต แลน, ไม่ ละ โรฮ อื แลน เครอึง เซ อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ดัฮ เอีจ ไคว ซเงะ อาแลฮ เซ โฮ, ซตุ เซ ซ แลน แม เครอึง เซ. ดัฮ ยุ เวือ ลไตฮ นึง เครอึง เซ ติ แตะ ฮา ไพรม แตะ, เครอึง ยุฮ ปุย นึง กอย ญุ่ก, ป ยุฮ ปุย นึง ฮัก ซัตซิง ไม่ ฮาึก อื ญุ่ก, ลไตฮ เซ มัฮ มัฮ อื ลไตฮ ฆอก. เครอึง เซ แปน ป โอ เญือะ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ไมจ ซตุ เซ ตอง เครอึง เซอึก เซ เกือฮ ฮะ ฆาื อื, ปัง มัฮ เครอึง ตอก ออฮ ตอก เอีฮ ญุ่ก, ไมจ ตอง เกือฮ ฮะ โอยจ นึง มัฮ อื ลไตฮ ฆอก. เซ ป ไมจ ตอง ฆาื อื นึง งอ เยอ. ");
INSERT INTO lcp_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ดัฮ ซตุ เซ โอ ยุ เวือ ลไตฮ เซ ติ แตะ นึง เครอึง เซ ฮา ไพรม แตะ โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ไมจ ซตุ ซตอก ปุย เซ เกือฮ ซัก เครอึง เซ เกือฮ ซง่ะ. ฟวยจ เซ เกือฮ แม ละ อาึง อื อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ดัฮ ลไตฮ อาวต นึง เครอึง เซ โอ บัฮ โฮ, ปัง โอ เวือ ติ แตะ ฮา ไพรม แตะ, เอีจ แปน เครอึง เซอึก โอ ซง่ะ ไล โรฮ. ไมจ เปอะ ตอง เครอึง เซ นึง งอ เกือฮ ฮะ, ปัง ลอก ลไตฮ เซ ก พริ อื ญุ่ก, กไน อื ญุ่ก, ไมจ ตอง โอยจ. ");
INSERT INTO lcp_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","เญือม เอีจ ฟวยจ กวต ซตุ เครอึง เอีจ ซัก ปุย เซ, ดัฮ ยุ บัฮ อื ฮา ไพรม แตะ ไมจ ลั่ง ซตุ เซ แจฮ โปวฮ เบือง ก ลไตฮ อื เซ โอก ฮา เครอึง เซ. ");
INSERT INTO lcp_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ดัฮ ลไตฮ เซ เกิต แม นึง เครอึง เซ แม, ไมจ เปอะ ตอง เอิน เครอึง เซ ฆาื อื นึง งอ. ");
INSERT INTO lcp_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","เครอึง ลไตฮ เอีจ ฟวยจ ซัก ติ โฮน ตอก เซ, ไม่ เอีจ บัฮ โรฮ ลไตฮ นึง อื, ไมจ แม เปอะ เฌาะ ซัก แม ติ โฮน เดอึม ซ แปน เนอึม ป ซง่ะ ไล ละ เปอะ ฆาื อื.” ");
INSERT INTO lcp_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","เซ มัฮ โกตไม เกว ไม่ เครอึง เซอึก ป ลอก ลไตฮ ฆอก, เตือง เครอึง ยุฮ ปุย นึง กอย รเซฮ กอย รติญ, เครอึง ไตญ เครอึง แกน ญุ่ก, ไม่ เครอึง ยุฮ ปุย นึง ฮัก, ละ ซ เกือฮ แตะ โม เปะ เกียฮ ซังเกต เครอึง ซง่ะ ไล ไม่ เครอึง โอ ซง่ะ ไล นึง อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“เฮี มัฮ โกตไม เกว ไม่ ตอก ซ เกียฮ เกือฮ โม ป ลาวต ติ แตะ ซง่ะ ไล. เญือม ซ เกือฮ อื ติ แตะ ซง่ะ ไล เซ, ไมจ เปอะ เกือฮ ปุย ตาว ปุย เซ ฮอยจ เคะ ซตุ. ");
INSERT INTO lcp_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ซตุ เซ ไมจ อื โอก เคะ ปุย เซ ก พริ ไคะ ละ ซ กวต แตะ แลน เอีจ ไฮ เบราะ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ดัฮ เอีจ ยุ ไฮ ลาวต ปุย เซ โฮ, ไมจ ซตุ เซ ดวน ปุย ไฮญ เกือฮ โรวก โอเอีฮ ป ไมจ แตะ โกว เญือม ซ เกือฮ อื ปุย เซ ซง่ะ ไล เซ. ป ไมจ อื โรวก เซ มัฮ ไซม ไอม ลั่ง ไม่ ซง่ะ ไล แตะ ลอา ตัว, ไม่ ฆิ โคะ โซน ซีด่า, กอย ซครัก ไม่ โคะ ฮลาึง ลเวือง ติ เจือ เญี่ยะๆ. ");
INSERT INTO lcp_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ไมจ แม ซตุ เซ เกือฮ ปุย มอก ไซม เซ ติ ตัว, นึง ราว โดง เตะ ป ไก รอาวม ซงอม ป เชียต ปุย เน่อึม นึง โกลง เซ นึง. ");
INSERT INTO lcp_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","เกือฮ แม ซตุ ตุย แม ไซม ป ไอม ลั่ง เซ, เกือฮ ชึต ดิ อื ไม่ ฆิ เซ ไม่ กอย ซครัก ไม่ โคะ ฮลาึง ลเวือง เซ นึง ฮนัม ไซม มอก ปุย ราว รอาวม เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","เกือฮ แม ซตุ ซพรอต ฮนัม เซ นึง ปุย เซ อาแลฮ โฮน, ไม่ อัฮ อื ละ อื ตอก เฮี, ‘เอีจ ซง่ะ ไล อื,’ อัฮ เซ. ฟวยจ เซ พลวย แม ไซม ป ไอม ลั่ง อื เซ เกือฮ โปว นึง กังเด่น. ");
INSERT INTO lcp_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","เกือฮ โรฮ ป ฮอยจ เกือฮ ติ แตะ ซง่ะ ไล เซ ซัก เครอึง เซอึก แตะ, เกือฮ โรฮ กู ไกญ แตะ ไม่ คุต อื ฮาึก แตะ เตือง โอยจ อื. เกือฮ โรฮ ฮาวม. ปุย เซ ซ ซง่ะ เนอึม ไล ฆาื อื. ฟวยจ เซ เกือฮ โรฮ เลียก ฮอยจ กไน ไคะ, ปังเมอ ไมจ ลั่ง อื ไอจ ก พริ พากัง เญือะ โกะ แตะ เซ อาแลฮ ซเงะ แม. ");
INSERT INTO lcp_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","เญือม เอีจ ไคว อื ซเงะ อาแลฮ เซ, เกือฮ แม ปุย เซ คุต ฮาึก ไกญ แตะ ติ โฮน แม. เกือฮ โรฮ คุต อื ไม่ ฮาึก กัป ฮาึก รวุย ไง่ แตะ เกือฮ โอยจ. เกือฮ แม ซัก เครอึง เซอึก แตะ, ไม่ ฮาวม แตะ. ฟวยจ เซ เดอึม ซ แปน เนอึม ปุย ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“ซเงะ ซเตะ นึง อื, ไมจ แม ปุย เซ โรวก กวน แกะ โปก ลอา ตัว ป โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม. ไมจ แม อื โรวก ไม่ กวน แกะ รโปวน ป ไก อาญุ อื ติ เนอึม ป โอ โรฮ อื โละพริ. ไมจ โรฮ อื โรวก ไม่ ญอต แปง ป เอีจ ซเบื่อก ไม่ ลออยฮ แลฮ ลิต, ไม่ ลออยฮ เมาะ บลัฮ ลิต ละ ซ ทไว แตะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","เกือฮ ซตุ เซ ตุย โรวก ปุย เซ ไม่ โรวก อื ป ทไว อื เซ ฮอยจ ซองนา พะจาว นึง โตะ รเวือะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“เกือฮ โรฮ ตุย โรวก กวน แกะ โปก เซ ติ ตัว, ละ ซ ทไว อื เกือฮ แปน ควน ยวก มั่ป กัฮ ตุต. ไมจ แม โรฮ อื ตุย ไม่ ลออยฮ บลัฮ ลิต เซ, กอยฮ โรฮ ทไว อื ละ พะจาว โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","เกือฮ โรฮ ซตุ เซ มอก แม กวน แกะ เซ นา ก ซัมคัน อื. เบือง ก มอก ปุย ซัตซิง ละ ตอง อื ทไว ละ โตฮ ปุย ติ แตะ ฮา มั่ป. โอเอีฮ ทไว ปุย ป แปน ควน ยวก มั่ป กัฮ ตุต ยุฮ แตะ เซ มัฮ โรฮ ป ลัง ละ ซตุ, ตอก โรฮ ป ทไว ปุย เกือฮ แปน ควน โตฮ อื ติ แตะ นึง โฮ. โอเอีฮ โม เซ เยอ มัฮ ป ซง่ะ ซงอม เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ฟวยจ เซ ซตุ เซ ซ โกว โรฮ ฮนัม ซัตซิง ทไว ปุย เกือฮ แปน ควน ยวก มั่ป เซ ง่อน. ตา อื นึง ดอ ฮยวก ลวง ดอม ปุย เซ. ตา โรฮ อื นึง โฆวน เตะ โฆวน ชวง ลวง ดอม อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ซตุ เซ ซ ตุย แม ลออยฮ บลัฮ ลิต เซ, เรฮ โรฮ อื นึง ลเตือก เตะ ลวง วิ โกะ แตะ เซ ง่อน. ");
INSERT INTO lcp_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ฟวยจ เซ ซ ชึต ด่อยฮ ลวง ดอม แตะ นึง อื, ซพรอต โรฮ อื นึง ซองนา พะจาว อาแลฮ โฮน. ");
INSERT INTO lcp_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ลออยฮ ป ไก ลั่ง นึง ลเตือก เตะ อื เซ ซ ตา แม อื นึง ดอ ฮยวก ลวง ดอม ปุย เซ ง่อน, นึง ราว ฮนัม แกะ เอีจ ตา แตะ เซ ฮอยจ นึง โฆวน เตะ โฆวน ชวง อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","เมาะ ลออยฮ ป โฮฮ ลั่ง อื เซ, ซ ตา แม โรฮ อื นึง ไกญ ปุย เซ. มัฮ ตอก เซ ตอก ซ เกียฮ แปน ปุย เซ ปุย ซง่ะ ไล เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“ฟวยจ เซ ซตุ เซ ซ ทไว แม คอง ทไว ควน โตฮ ปุย เซ ติ แตะ ฮา มั่ป ละ ซ เกือฮ แตะ ปุย เซ แปน ปุย ซง่ะ ไล ฆาื อื. ฟวยจ เซ ซ มอก แม ซัตซิง ละ ซ ตอง แตะ ทไว เตือง ตัว อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","เญือม เอีจ ฟวยจ มอก อื ซ ลอต โฮว ตอง ทไว อื ไม่ แปง ทไว ปุย เซ. มัฮ ยุฮ อื ตอก เซ ละ ซ เกือฮ แตะ ปุย เซ แปน ปุย ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“ดัฮ ปุย ลาวต เซ มัฮ ปุย ตุก ไม่ โอ แตะ ปุน ทไว ตอก เซ โฮ, เกือฮ ปุย เซ โรวก กวน แกะ โปก ติ ตัว ละ ซ ทไว อื เกือฮ แปน ควน ยวก มั่ป กัฮ ตุต ยุฮ อื, ไม่ แปน อื ป กอยฮ อื ทไว ละ พะจาว ละ ซ แปน อื ควน รไซจ พิต โฌวะ ยุฮ อื. เกือฮ แม โรฮ โรวก อื ไม่ ญอต แปง ป เอีจ ซเบื่อก ไม่ ลออยฮ ลอา ลิต, ไม่ ลออยฮ กาวก บลัฮ ลิต, ละ ซ แปน อื ป ทไว อื ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","เกือฮ แม โรวก อื ไม่ รโกะเกอื ลอา ตัว, โต เซ โนก พิลัป ญุ่ก, เตอึม ป โฮลฮ อื โรวก. ไซม ติ ตัว อื เซ แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ. ติ ตัว อื แปน ป ตอง อื ทไว เตือง ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“ซเงะ ซเตะ นึง อื เซ, ไมจ อื โรวก ป ทไว แตะ เซ ละ ซตุ ฮอยจ นึง โตะ รเวือะ พากัง ระ เซ ซองนา พะจาว, ละ ซ แปน อื ปุย ซง่ะ ไล. ");
INSERT INTO lcp_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ป มัฮ ซตุ เซ ซ ตุย กวน แกะ โรวก ปุย เซ ทไว ละ ซ แปน อื ควน ยวก มั่ป กัฮ ตุต ยุฮ อื เซ, ไม่ ลออยฮ บลัฮ ลิต เซ. ซตุ เซ ซ เกือฮ โรฮ อื แปน ป กอยฮ อื ทไว ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ฟวยจ เซ ซตุ เซ ซ มอก แกะ เกือฮ แตะ แปน ควน ยวก มั่ป กัฮ ตุต ยุฮ ปุย เซ. ฟวยจ เซ ซ ตุย โรฮ ฮนัม แกะ เซ ง่อน, ไม่ ตา อื ฮนัม เซ นึง ดอ ฮยวก ลวง ดอม ปุย เซ. ตา โรฮ อื นึง โฆวน เตะ โฆวน ชวง ลวง ดอม อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ฟวยจ เซ ซตุ เซ ซ เรฮ แม ลออยฮ นึง ลเตือก เตะ ลวง วิ แตะ ง่อน. ");
INSERT INTO lcp_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ชึต ด่อยฮ ลวง ดอม แตะ นึง อื, ซพรอต โรฮ เตะ แตะ เซ ซองนา พะจาว อาแลฮ เตะ. ");
INSERT INTO lcp_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ฟวยจ เซ ลออยฮ ป ไก ลั่ง นึง ลเตือก เตะ อื เซ ซ ตา แม โรฮ อื นึง ดอ ฮยวก ลวง ดอม ปุย เซ โรฮ. ตา แม อื ฮอยจ ละ โฆวน เตะ โฆวน ชวง ลวง ดอม อื นึง เบือง ฮนัม แกะ เอีจ ตา แตะ นึง ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","เมาะ ลออยฮ ป โฮฮ ลั่ง นึง ลเตือก เตะ ซตุ เซ ซ ตา แม อื นึง ไกญ ปุย เซ. มัฮ ตอก เซ ตอก ซ เกียฮ ซง่ะ ไล ปุย เซ ซองนา พะจาว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ฟวยจ เซ ซตุ เซ ซ ทไว แม ไซม ยุฮ ปุย เซ ละ อื ตัม ป โฮลฮ ปุย เซ โรวก. ");
INSERT INTO lcp_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ไซม ติ ตัว อื แปน ควน โตฮ อื ติ แตะ ฮา มั่ป. ติ ตัว อื เซ แม แปน ป ตอง อื ทไว ละ พะจาว เตือง ตัว อื. ทไว โรฮ อื ไม่ แปง ตัม ป ลัง ไมจ แตะ ทไว. มัฮ ตอก เซ ตอก ซ ยุฮ ซตุ อื ละ อื, ละ ซ เกือฮ แตะ ปุย ซง่ะ ไล ซองนา พะจาว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","เซ มัฮ โกตไม ละ ป ลอก ลาวต, ป โอ ปุน ยุฮ ตัม ริต ระ นึง อื, ละ ซ เกือฮ อื ติ แตะ แปน ปุย ซง่ะ ไล.” ");
INSERT INTO lcp_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","พะจาว อัฮ แม เฮี ละ ไอ โมเซ ไม่ อาโรน, ");
INSERT INTO lcp_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“เญือม โฮลฮ โม เปะ เลียก อาวต นึง เมือง คะนาอัน ไม่ ซ เกือฮ โรฮ อาึ เมือง เซ แปน คอง เปอะ เซ, ดัฮ อาึ เกือฮ ลไตฮ ฆอก เกิต นึง เญือะ อาวต ปุย ติ ปุย โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","กุม เญือะ เซ ไมจ อื โฮว รโฮงะ ละ ซตุ ตอก เฮี, ‘อาึ ยุ เกิต โอเอีฮ ตอก ลไตฮ นึง เญือะ แตะ,’ ไมจ อื อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ฟวยจ เซ ซตุ เซ ซ ดวน ปุย เซ เกือฮ เราะ เครอึง เญือะ แตะ เซ โอก ฮอยจ ก พริ, กา ฮอยจ กวต แตะ เญือะ เซ, นึง ฮอ แตะ นึง ซ โฮลฮ แตะ รโฮงะ มัฮ เครอึง เญือะ เซ ป เอีจ รแอม ไล, ฟวยจ เซ ซตุ เซ ซ โฮว กวต เนอึม แลน อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","เญือม เอีจ ฮอยจ อื นึง เญือะ เซ, ดัฮ ยุ อาวต ลไตฮ เซ นึง เดีญ, ไม่ โอก โรฮ ซี ซครัก ซี ซงา นึง อื, ไม่ ยุ โรฮ อื เลียก อื โด่ะ ปุๆ โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ซตุ เซ ซ โอก ฮา เญือะ เซ คระ โตะ รเวือะ เซ, ซอง อาึง รเวือะ เญือะ เซ อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","เญือม เอีจ ฮอยจ อื ซเงะ อาแลฮ เซ, ซตุ เซ ซ ฮอยจ แลน แม อื ติ โฮน. ดัฮ ยุ เวือ ลไตฮ เซ ติ แตะ ฮา ไพรม อื โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ซตุ เซ ซ ดวน ปุย กอฮ ซโมะ อาวต นึง เดีญ ป ลอก ลไตฮ เซ, ไม่ โฮว น่าึก อื โปวฮ นา ก โอ ซง่ะ ไล ติ โดฮ ก พริ ย่วง. ");
INSERT INTO lcp_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","เกือฮ โรฮ ปุย คุต ปุน ตา ปุย กไน เญือะ เซ เลี่ป อื. ฟวยจ เซ ครัม ปุน ตา ปุย เซ เกือฮ โรฮ อื โรวก โฮว โปวฮ อื นา ก โอ ซง่ะ ไล ติ โดฮ ก พริ ย่วง โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","ฟวยจ เซ ไมจ ปุย ซาวป แม ซโมะ ไฮญ ละ ซ ดุฮ อื เบือง ซโมะ เอีจ กอฮ แตะ เกือฮ โอก เซ, ไม่ ไอฮ แม โรฮ อื ปุน โคระ ละ ซ ตา อื นึง เดีญ เญือะ เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“เญือม เอีจ ฟวยจ โอก อื ซโมะ ไก ลไตฮ นึง เซ, ไม่ เอีจ ตา แม โรฮ อื ปุน โคระ นึง อื, ดัฮ โอก แม ลไตฮ นึง ติ โฮน โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ไมจ แม ซตุ เซ โฮว กวต แลน ติ โฮน แม. ดัฮ ลไตฮ เซ เวือ ติ แตะ ฮา ไพรม แตะ เอีจ มัฮ มัฮ อื ลไตฮ ฆอก ลอน. เญือะ เซ เอีจ แปน เญือะ โอ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ไมจ เกือฮ ปุย เญื่อฮ เญือะ เซ. โคะ, ซโมะ, ปุน ป ยุฮ ปุย เญือะ เซ นึง เงอ, ไมจ ปุย โฮว โปวฮ นา ก โอ ซง่ะ ไล ติ โดฮ ก พริ ย่วง เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“ดัฮ ไก ป เลียก โตะ เญือะ เซ ไน ติ เจน ซอง ปุย รเวือะ เญือะ เซ, ปุย เซ แปน ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ดัฮ ไก ป โฮว ไอจ โฮว โซม นึง เญือะ เซ โฮ, ไมจ โรฮ อื ซัก เครอึง เซอึก แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“เญือม เอีจ ฟวยจ เฌาะ ตา ปุย ปุน โคระ นึง เญือะ เซ, ดัฮ ซตุ โฮว แลน ไม่ โอ อื เญือะ ยุ โอก ลไตฮ นึง อื, ไมจ โรฮ ซตุ เซ รโฮงะ ละ ปุย โอ เญือะ เซ รแอม ไล นึง โอ ลไตฮ เซ เญือะ เกิต นึง. ");
INSERT INTO lcp_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","ตอก ซ เกือฮ อื เญือะ เซ เกียฮ แปน ป ซง่ะ ไล เยอ, ไมจ อื โกว ไซม ละ ลอา ตัว. โกว โรฮ ไม่ ฆิ โคะ โซน ซีด่า, กอย ซครัก, ไม่ ฮลาึง ลเวือง. ");
INSERT INTO lcp_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","ไมจ ซตุ มอก ไซม เซ ติ ตัว ราว โดง เตะ ก อาึง ปุย รอาวม ซงอม ป เชียต ปุย เน่อึม นึง โกลง เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","เกือฮ โรฮ ตุย ฆิ เซ ไม่ ฮลาึง ลเวือง ไม่ กอย ซครัก ไม่ ไซม ป ไอม ลั่ง เซ. เกือฮ โรฮ ชึต อื นึง ฮนัม ไซม เอีจ มอก แตะ เซ ไม่ รอาวม เซ. ฟวยจ เซ เกือฮ ซพรอต อื นึง เญือะ เซ อาแลฮ เตะ. ");
INSERT INTO lcp_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","มัฮ ตอก เซ ตอก ซ แปน เญือะ เซ เญือะ ซง่ะ เนอึม ไล ฆาื อื เบือ ฮนัม ไซม ไม่ รอาวม ซงอม ไม่ ไซม ป ไอม ลั่ง เซ, ไม่ เบือ ฆิ โคะ โซน ซีด่า, ฮลาึง ลเวือง ไม่ เบือ กอย ซครัก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ฟวยจ เซ ซตุ เซ ซ พลวย ไซม ป ไอม ลั่ง เซ เกือฮ โปว นึง กังเด่น ก พริ ย่วง. มัฮ ตอก เซ ตอก ไมจ อื ยุฮ ละ เญือะ เซ ละ ซ เกือฮ แตะ เญือะ เซ ซง่ะ ไล ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ไล เซ มัฮ โกตไม เกว ไม่ ป ลอก ลาวต ไม่ ป โซะง่ะ, ");
INSERT INTO lcp_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","56","ไม่ โม ป ออยฮ, ป รปอฮ, ไม่ ป กลัง ฮัก, ไม่ ไลลวง ลไตฮ ป ไก นึง เครอึง เซอึก ญุ่ก, นึง เญือะ ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","ละ ซ เกือฮ ปุย ยุง ป ซง่ะ ไล ไม่ ป โอ ซง่ะ ไล นึง อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","พะจาว อัฮ แม เฮี ละ ไอ โมเซ ไม่ อาโรน, ");
INSERT INTO lcp_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, ปรเมะ ดัฮ ไก ป ปัต ลาวม โอก เน่อึม นึง ก ปุก ตะ ลมัง อื โฮ, โอเอีฮ ป ปัต ลาวม โอก เซ มัฮ โรฮ ป รแอม ไล โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","เฮี มัฮ โกตไม เกว ไม่ ไลลวง ป ปัต โอก เน่อึม นึง ปรเมะ เซ. ป เอีจ ปัต โอก ฮา เนะซอัง อื ญุ่ก, ป อาวต ลั่ง นึง เนะซอัง อื ญุ่ก, โอเอีฮ ตอก เฮี มัฮ ตื ป โอ ซง่ะ ไล. ");
INSERT INTO lcp_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","ปัง มัฮ เตียง ไอจ ปรเมะ เซ ไม่ ตังอี งาวม อื, แปน ตื โรฮ ป โอ เญือะ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","6","ป ลอก ป ไปญ เตียง ไอจ ปุย เซ ญุ่ก, ป โคะ งาวม นึง เบือง ก งาวม อื ญุ่ก, ไมจ โรฮ อื ฮาวม ไม่ ซัก อื เครอึง เซอึก แตะ เกือฮ ซง่ะ ฆาื อื. ปุย เซ แปน ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ดัฮ ไก ป โคะ ลอก โคะ ไปญ ปุย เซ โฮ, ไมจ อื ฮาวม ไม่ ซัก อื เครอึง เซอึก แตะ เกือฮ ซง่ะ. ปุย เซ แปน โรฮ ปุย โอ ซง่ะ ไล ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","ดัฮ ปรเมะ ป ไก ป ปัต โอก นึง เซ โดยจ แม่ แตะ ไม่ ลอก อื ปุย ซง่ะ ไล โฮ, ปุย ลอก โดยจ อื เซ ไมจ เอิน อื ฮาวม ไม่ ซัก อื เครอึง เซอึก แตะ เกือฮ ซง่ะ. ปุย เซ แปน โรฮ ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","ปรเมะ ป ไก ป ปัต โอก เน่อึม นึง โกะ อื เซ, ดัฮ บุก ซัตซิง โฮ, โอเอีฮ ป งาวม อื นึง เซ แปน ป โอ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ดัฮ ไก ป ลอก ป ไปญ ควน งาวม ปุย เซ นึง ญุ่ก, ดัฮ เฌาะ ควน งาวม อื เซ ญุ่ก, ป ลอก เซ ไมจ อื ฮาวม ไม่ ซัก อื เครอึง เซอึก แตะ เกือฮ ซง่ะ. ปุย เซ แปน ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ปรเมะ ไก ป ปัต โอก เน่อึม นึง เซ, ดัฮ ลอก ดัฮ ไปญ ปุย เตือง โอ อื รไซจ เตะ แตะ โฮ, ปุย โฮลฮ ปุย ลอก เซ ไมจ อื ฮาวม ไม่ ซัก อื เครอึง เซอึก แตะ เกือฮ ซง่ะ. ปุย เซ แปน ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","ดัฮ ปุย เซ ลอก โดง เดือง ป ยุฮ ปุย นึง เตะ โฮ, ไมจ โรฮ ยุฮ ไลจ ไม่ โอเอีฮ เซ ฆาื อื. ดัฮ มัฮ กลอง เชือม ป ยุฮ ปุย นึง โคะ โฮ, ไมจ รไซจ นึง รอาวม เกือฮ ซง่ะ. ");
INSERT INTO lcp_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“เญือม เอีจ ไฮ ปุย ไก ป ปัต โอเอีฮ เน่อึม นึง อื เซ, ไมจ แม อื มอง อาแลฮ ซเงะ. ฟวยจ เซ ไมจ อื ซัก เครอึง เซอึก แตะ ซง่ะ. ไมจ แม อื ฮาวม นึง รอาวม ปัต นึง โกลง แม. ฟวยจ เซ เดอึม ซ เกียฮ แปน ปุย ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ซเงะ ซเตะ นึง อื ไมจ ปุย เซ โรวก รโกะเกอื ลอา ตัว, โต เซ อื มัฮ โนก พิลัป นุม ลอา ตัว, ฮอยจ โตะ รเวือะ พากัง ระ เซ ซองนา พะจาว. เกือฮ โรฮ ไซม โรวก แตะ ทไว เซ ละ ซตุ. ");
INSERT INTO lcp_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ซตุ เซ ไมจ อื ตุย ไซม เซ ติ ตัว ทไว อื ละ ซ เกือฮ อื แปน ควน โตฮ ปุย เซ ติ แตะ ฮา มั่ป. ไมจ แม อื ตุย ตัว ติ อื เซ ไม่ ตอง โรฮ อื ทไว เตือง ตัว อื. มัฮ ยุฮ อื ตอก เซ ละ ซ เกือฮ แตะ ปุย เซ แปน ปุย ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ดัฮ ไก ปรเมะ ป โอก รอาวม โกะ โอ, ไมจ ปุย เซ โฮว ฮาวม. ปุย เซ ซ แปน โรฮ ปุย โอ ซง่ะ ไล โรฮ ฮอยจ ละ เลียก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","เครอึง บ่วตชุ ญุ่ก, เครอึง ฮัก ญุ่ก, ดัฮ รอาวม โกะ อื เซ ลอก โฮ, ไมจ อื รไซจ นึง รอาวม. เครอึง เซ ซ แปน โรฮ ป โอ ซง่ะ ไล ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ปรเมะ ดัฮ ไอฮ ปุ แตะ ไม่ ปรโปวน โฮ, ไมจ อื ฮาวม ฆาื อื เตือง ลอา แตะ. ซ แปน โรฮ ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“เญือม เลีฮ ปะจัม เดื่อน ปรโปวน เนอ, ปุย เซ ซ แปน ปุย โอ ซง่ะ ไล ฆาื อื อาแลฮ ซเงะ. ดัฮ ไก ป ลอก ป ไปญ ปรโปวน เซ, ปุย เซ ซ รแอม โรฮ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","เญือม โอ ปรโปวน เซ ซง่ะ ไล, ก ไอจ ก งาวม อื เซ เอีจ แปน โรฮ ก โอ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","23","ป ออฮ ป เอีฮ ป ลอก ป ไปญ เบือง ก ไอจ ก งาวม ปรโปวน โอ ซง่ะ ไล เซ, ไมจ ปุย เซ ฮาวม ไม่ ซัก อื เครอึง เซอึก แตะ เกือฮ ซง่ะ. ปุย เซ ซ แปน โรฮ ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","ดัฮ ไก ปรเมะ ป ไอฮ ปุ แตะ ไม่ ปรโปวน เซ เญือม โอ อื ซง่ะ ไล เยอ, ปรเมะ เซ ซ แปน โรฮ ป รแอม ไล ฆาื อื อาแลฮ ซเงะ เอิน. นา ก ไอจ อื เซ แปน โรฮ ก โอ ซง่ะ ไล ฆาื อื ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ดัฮ ไก ปรโปวน บราึง ฮนัม เมอ, ดัฮ ฮนัม อื เซ โอก เลี่ญ ฮา เวลา เญือม ลัง โอก ปะจัม เดื่อน แตะ โฮ, ไน ติ เจน เลีฮ ฮนัม อื เซ ปุย เซ ซ แปน โรฮ ปุย โอ ซง่ะ ไล ฆาื อื, ตอก โรฮ เญือม โอก ปะจัม เดื่อน อื เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ก ไอจ ก งาวม ปรโปวน เซ ไน ติ เจน เลีฮ ฮนัม อื เซ แปน โอยจ นา ก โอ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ดัฮ ไก ป ลอก ป ไปญ นา ก ไอจ ก งาวม ปรโปวน เซ, ไมจ อื ฮาวม ไม่ ซัก อื เครอึง เซอึก แตะ ฆาื อื. ปุย เซ ซ แปน โรฮ ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ดัฮ ปรโปวน เซ เอีจ ไฮ บราึง ฮนัม โฮ, ไมจ แม อื เมีญ เน่อึม เญือม เซ ฮอยจ ละ อาแลฮ ซเงะ. ดัฮ เอีจ ฟวยจ เซ โฮ เดอึม ซ เกียฮ แปน ปุย ซง่ะ ไล. ");
INSERT INTO lcp_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","ซเงะ ซเตะ นึง อื ไมจ ปรโปวน เซ โรวก รโกะเกอื ลอา ตัว, โต เซ อื โนก พิลัป ลอา ตัว, ฮอยจ เคะ ซตุ นึง โตะ รเวือะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ซตุ เซ ซ ทไว ไซม โรวก อื เซ ติ ตัว ละ ซ เกือฮ อื แปน ควน โตฮ ปุย เซ ติ แตะ ฮา มั่ป. ไซม ป ไก ลั่ง ติ ตัว อื เซ, เกือฮ โรฮ อื แปน ป ตอง อื ทไว ละ พะจาว เตือง ตัว อื โรฮ. มัฮ ยุฮ อื ตอก เซ ละ ซ แปน ปุย เซ ปุย ซง่ะ ไล ละ พะจาว นึง มัฮ อื ปุย บราึง ฮนัม เซ. ");
INSERT INTO lcp_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“มัฮ ตอก เซ ตอก ซ เกือฮ เปอะ โม อิซราเอน โปน ฮา ไล รแอม แตะ เซ. ดัฮ ไก ป ฮอยจ นึง พากัง ยุฮ อาึ ป อาวต บั่กบ่วน ก อาวต โม โกะ อื เซ ไม่ รแอม ไล แตะ, ปุย เซ ซ ยุม ฆาื อื, นึง เกือฮ อื พากัง ยุฮ อาึ แปน ป รแอม ไล,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ไล เซ มัฮ โกตไม เกว ไม่ ไลลวง ลาวม ป ปัต โอก เน่อึม นึง ก ปุก ตะ ลมัง ปรเมะ ไม่ ไลลวง โอก รอาวม โกะ ปรเมะ, ");
INSERT INTO lcp_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ฮอยจ โรฮ ละ ปะจัม เดื่อน ปรโปวน. เกว โรฮ ไม่ ไลลวง ไอฮ ปรเมะ ปรโปวน ปุ แตะ ลไล โอ ปรโปวน เซ ซง่ะ ไล. เมาะ โอเอีฮ ป ปัต โอก ตอก เซ มัฮ ตื ป เกือฮ ปุย โอ ซง่ะ ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ฟวยจ ยุม กวน อาโรน เตือง ลอา อื ฆาื เลียก ทไว อื งอ โอ ซง่ะ ไล ละ พะจาว เซ, ");
INSERT INTO lcp_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, “ไมจ เปอะ ซตอก อาโรน ป มัฮ เอียกระ เปอะ เซ โอ เกือฮ เลียก โตะ ฮอง ตึก นึง ซัมคัน แตะ กไน พากัง เซ ตัม พาวม โกะ แตะ ไอฮ, เดอึม โอ ซ ยุม ฆาื อื. นา เซ มัฮ นา ก เปลีฮ อาึ ติ แตะ นึง ชุต รวู ป อาวต ราว รเดือป ฮิต ลปุง ซันญา ยุฮ ฮุ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“อาโรน เญือม ซ เลียก อื โตะ กไน ฮอง ตึก นึง ซัมคัน แตะ เซ ไมจ อื ยุฮ ตอก เฮี. ไมจ อื โรวก โมวก โปก นุม ติ ตัว ละ ซ เกือฮ อื แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ, ไม่ แกะ โปก ติ ตัว ละ ซ ตอง อื ทไว เตือง ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","ไมจ อื ฮาวม ละ ฮัม, ฟวยจ เซ ไมจ อื จาวป เครอึง ซัมคัน ป มัฮ แว ลปิ พา แนน ไมจ. เกือฮ โรฮ ปุก พา นึง ญวย แตะ ไม่ คัต อื โคะ ไฆญ ไมจ นึง ไกญ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","โม ลัปซด่อน ไน โม อิซราเอน ไมจ อื เกือฮ ปิ โปก ลอา ตัว ละ ซ แปน อื ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ, ไม่ แกะ โปก ติ ตัว ละ ซ ตอง อื ทไว ละ พะจาว เตือง ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“อาโรน ไมจ อื มอก ทไว โมวก เซ ละ ซ โตฮ อื ติ แตะ ฮา มั่ป ยุฮ โกะ แตะ ไม่ มั่ป ยุฮ ปุย ไฮญ เญือะ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ฟวยจ เซ ไมจ อื ตาว ปิ ลอา เซ ละ พะจาว ฮอยจ นึง โตะ รเวือะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ไมจ อื โจก เบ่อ นึง ปิ ลอา ตัว เซ. ติ ตัว อื ลัง ทไว อื ละ พะจาว. ติ ตัว อื เซ ลัง พลวย อื แปน ปิ โรวก มั่ป ยุฮ ปุย. ");
INSERT INTO lcp_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","อาโรน ไมจ อื โรวก ปิ ป ลัง ทไว ปุย ละ พะจาว เซ. ไมจ อื มอก ละ แปน อื ควน โตฮ ปุย ติ แตะ ฮา มั่ป ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ปิ ป ลัง แปน ปิ โรวก มั่ป เซ ซ แปน ป ทไว ไอม ปุย ละ พะจาว. ซ เกือฮ มั่ป ยุฮ ปุย ติต ปิ เซ เกือฮ อื แปน ปิ โรวก มั่ป ฮา ปุย. ฟวยจ เซ ซ พลวย อื นึง ลาึน เวือฮ ละ ซ แปน อื ควน รไซจ พะจาว มั่ป ยุฮ ปุย เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“อาโรน ไมจ อื ตาว โมวก รโตง มั่ป ยุฮ โกะ แตะ ไอฮ ไม่ ปุย ไน เญือะ แตะ เซ. ไมจ อื มอก โมวก เซ รกา. ");
INSERT INTO lcp_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","เญือม เซ ไมจ อื ตุย โดง งอ ป ติต เน่อึม นึง คัน ซองนา พะจาว ไม่ ป ซออย ฮงาื คริต ปุย เกือฮ โพง ลอา ซบราวก. ไมจ อื เลียก ไม่ โตะ ฮอง ตึก นึง ซัมคัน แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","ไมจ อื ดุฮ ป ซออย ฮงาื เซ โตะ งอ ซองนา พะจาว นา เซ. ม่าึต งอ เซ ซ เลอึป รเดือป ฮิต ลปุง ซันญา เซ. เกือฮ โตว อื เกียฮ ยุ อื เดอึม โอ ซ ยุม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ไมจ อื ซพรอต ฮนัม โมวก เซ นึง รเดือป ฮิต เซ ลวง ลั่กกา อื นึง ด่อยฮ แตะ ง่อน. ไมจ แม อื ซพรอต ลั่กกา ฮิต เซ อาแลฮ เตะ. ");
INSERT INTO lcp_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ฟวยจ เซ ไมจ อื มอก ปิ ป มัฮ ควน โตฮ โม ลัปซด่อน ติ แตะ ฮา มั่ป ยุฮ แตะ เซ. ไมจ อื โรวก ฮนัม อื เลียก ไม่ อื โตะ ฮอง ตึก นึง ซัมคัน แตะ เซ. ไมจ อื ซพรอต ฮนัม อื ลั่กกา รเดือป ฮิต ซัมคัน เซ ไม่ ลั่กกา ฮิต เซ ตอก ยุฮ อื ไม่ ฮนัม โมวก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","เญือม ยุฮ อื ตอก เซ เอีจ มัฮ พัก อื ฮอง ตึก นึง ซัมคัน แตะ เซ เกือฮ ซง่ะ ฮา ป ฆอก ป เบร ไม่ มั่ป ตุต ยุฮ โม อิซราเอน เตือง โอยจ อื. ฟวยจ เซ ไมจ โรฮ อาโรน ยุฮ ตอก เซ ละ พากัง ระ เซ นึง อาวต อื ซน่ะ ลลาึง ปุย ป กอ ยุฮ กัน ฆอก กัน เบร. ");
INSERT INTO lcp_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ติ เจน เลียก อาโรน กไน ฮอง ตึก นึง ซัมคัน แตะ เซ ฮอยจ ละ โอก แม อื, ไมจ โตว ปุย ไฮญ อาวต นึง พากัง ระ เซ ติ ปุย เนอึม. เอีจ มัฮ รไซจ อื มั่ป ยุฮ โกะ แตะ ไม่ มั่ป ยุฮ ปุย ไฮญ เญือะ แตะ ไม่ มั่ป ยุฮ โม อิซราเอน เตือง โต อื. ");
INSERT INTO lcp_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“ฟวยจ เซ อาโรน ไมจ อื โอก ฮอยจ ละ คัน ตอง ปุย ทไว ซัตซิง ละ ซ พัก อื เกือฮ ซง่ะ. ไมจ อื ไอฮ ฮนัม โมวก เซ ง่อน ไม่ ฮนัม ปิ เซ ง่อน ละ ซ ตา อื นึง โด่วง ป อาวต นึง โจง คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","ไมจ อื ซพรอต ฮนัม นึง คัน เซ นึง ด่อยฮ แตะ อาแลฮ เตะ, ละ ซ พัก อื เกือฮ ซง่ะ ฮา ป ฆอก ป เบร ยุฮ โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“อาโรน เญือม เอีจ ฟวยจ รไซจ อื มั่ป ฮา ฮอง ตึก นึง ซัมคัน แตะ ไม่ พากัง ระ เซ ไม่ คัน นึง อื เซ, ไมจ แม อื ตุย ปิ ไอม เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","ไมจ อื ย่อง เตะ แตะ เตือง ลอา ก บลัฮ อื ราว ไกญ ปิ ไอม เซ. ไมจ อื รโฮงะ พิต โฌวะ ยุฮ โม อิซราเอน ไม่ ป ฆอก ป เบร ไม่ กัน เลฮ อื เตียง โครยญ เจือ. เกือฮ อื รโจะ นึง ไกญ ปิ เซ เตือง โอยจ อื. เญือม เซ ไมจ อื เกือฮ ปรเมะ ติ ป เอีจ ดุฮ ปุย แปน ป ยุฮ กัน เซ เกือฮ ตาว ปิ เซ โอก โฮว ฮอยจ นึง ลาึน เวือฮ. ");
INSERT INTO lcp_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ปิ เซ ซ โรวก ปุ โฮว มั่ป ยุฮ ปุย โครยญ เจือ ฮอยจ นึง นา ก ลงอต อื ติ โดฮ. ปรเมะ เซ ซ พลวย ปิ เซ เกือฮ โฮว นึง ลาึน เวือฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“ฟวยจ เซ อาโรน ซ ไมจ อื เลียก กไน พากัง ระ เซ. ไมจ อื ปอยจ เครอึง ซัมคัน ป ไอฮ แตะ เญือม เลียก แตะ โตะ ฮอง ตึก นึง ซัมคัน แตะ เซ. ไมจ อื ละ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ไมจ อื ฮาวม นึง นา ก ซง่ะ ไล อื ติ โดฮ เดอึม ไมจ อื ไอฮ เครอึง ซตุ ทัมมด่า ยุฮ แตะ. เญือม เซ ไมจ อื โอก ตอง ซัตซิง ละ ซ แปน อื ควน รไซจ มั่ป ยุฮ โกะ แตะ ไม่ มั่ป ยุฮ โม ลัปซด่อน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ไมจ โรฮ อื ตอง ลออยฮ ซัตซิง ป มัฮ ควน โตฮ ปุย ติ แตะ ฮา มั่ป นึง คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“ปรเมะ ป โฮว พลวย ปิ ป โรวก มั่ป ยุฮ ปุย เซ, ไมจ อื ซัก เครอึง เซอึก แตะ ไม่ ฮาวม แตะ ซง่ะ เดอึม ซ โฮลฮ เลียก แม นึง ไคะ. ");
INSERT INTO lcp_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","โมวก โปก ไม่ ปิ ป มอก ปุย ไม่ โรวก แตะ ฮนัม อื ฮอยจ นึง ฮอง ตึก นึง ซัมคัน แตะ เซ, นึง มัฮ อื ควน โตฮ ปุย ติ แตะ ฮา มั่ป เซ, ไมจ ปุย โรวก ตอง ก พริ ไคะ. โตะ อื ไม่ ฮัก อื ไม่ เวียกตู อื ไมจ ตอง เกือฮ ฮะ ล่อยญ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ปรเมะ ป โฮว ตอง อื เซ ไมจ อื ซัก เครอึง เซอึก แตะ ไม่ ฮาวม แตะ ซง่ะ เดอึม ซ โฮลฮ แม เลียก นึง ไคะ. ");
INSERT INTO lcp_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ไลลวง เฮี มัฮ โกตไม โฮลฮ เปอะ โกว ลอป. เญือม เอีจ ฮาวก เคิ อาแลฮ กาว ซาวม เมอ, ไมจ เปอะ เออึป ป โซม แตะ. ไมจ เปอะ โตว ยุฮ กัน นึง ติ เจือ เนอึม, เตือง โม จัตเจือ อิซราเอน ฮอยจ ละ ปุย ตังเมือง ป อาวต ลลาึง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ไน ซเงะ เซ พะจาว ซ รไซจ มั่ป ยุฮ เปอะ ละ ซ เกือฮ อื โม เปะ ซง่ะ ฮา มั่ป เซ. โม เปะ ซ ซง่ะ เนอึม เปอะ ฮา มั่ป ยุฮ แตะ เซ เตือง โอยจ อื ซองนา พะจาว. มัฮ เซ ป ไมจ โม เปะ ทื ซเงะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ซเงะ เซ ซ แปน ซเงะ ลโล่ะ ซัมคัน ละ เปอะ. ไมจ เปอะ เออึป ป โซม แตะ. เฮี มัฮ โกตไม โฮลฮ เปอะ โกว ลอป. ");
INSERT INTO lcp_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ซตุ ป เรฮ ปุย ลออยฮ นึง ละ ดุฮ อื แปน ฮัวนา ซตุ ฆรอ เปือะ แตะ เซ, ซ โฮลฮ แปน ป ยุฮ กัน เซ ละ ซ เกือฮ อื พะจาว รไซจ พิต โฌวะ ยุฮ ปุย, ไมจ โรฮ อื ไอฮ เครอึง ซตุ ซัมคัน ติ จุม เซ. ");
INSERT INTO lcp_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","ไมจ อื พัก ฮอง ตึก นึง ซัมคัน แตะ ไม่ พากัง ระ ไม่ คัน นึง อื. ไมจ โรฮ อื แปน ป รไซจ พิต โฌวะ ยุฮ โม ซตุ ไม่ โม ลัปซด่อน เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","เฮี มัฮ โกตไม โฮลฮ เปอะ โกว ลอป. ซตุ เซ ไมจ อื รไซจ มั่ป ยุฮ โม อิซราเอน เตือง โอยจ อื ติ เนอึม ติ โฮน โครยญ เนอึม,” อัฮ เซ พะจาว. ไอ โมเซ ยุฮ เนอึม อื ตัม ป อัฮ พะจาว ละ แตะ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“ไมจ เปอะ รโฮงะ ไลลวง เฮี ละ อาโรน ไม่ กวน เฌือต อื เตือง โม อิซราเอน เตือง โอยจ อื, นึง มัฮ อื ลปุง ซตอก พะจาว อาึง. ");
INSERT INTO lcp_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ดัฮ ไก โม อิซราเอน ป มอก ซัตซิง ละ ซ ทไว อื ละ พะจาว เยอ, มอก อื กไน ไคะ อาวต แตะ ญุ่ก, มอก อื ก พริ ไคะ ญุ่ก, ซัตซิง มอก อื เซ ปัง มัฮ โมวก, ปัง มัฮ กวน แกะ ปิ ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ดัฮ โอ โรวก มอก อื นึง โตะ รเวือะ พากัง ก ฮอยจ ปุย เคะ พะจาว ละ ซ เกือฮ อื แปน ป ทไว แตะ นา เซ โฮ, ปุย เซ เอีจ พิต ไม่ ลอก อื ตุต นึง มอก อื โอเอีฮ ไม่ เกือฮ อื ฮนัม ปัต ตอก โอ อื ปุก ไล ยุฮ พะจาว. ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ. ปุ เญือะ เมีญ มัฮ ปุย ไน โม อิซราเอน เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ป อัฮ ฮะ เซ มัฮ โอ เญือะ เกือฮ โม อิซราเอน มอก ทไว ซัตซิง ก ไฮญ. มัฮ ฆวต เกือฮ โรวก ซัตซิง เซ ฮอยจ ละ ซตุ อาวต นึง โตะ รเวือะ พากัง ระ เซ ละ ซ ทไว อื ละ พะจาว. มัฮ เกือฮ ป ทไว อื เซ แปน ควน รโจะ อื รพาวม แตะ ไม่ พะจาว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ซตุ เซ ซ ตุย ฮนัม ซัตซิง เซ. ซ ซพรอต อื นึง คัน ทไว อาวต โบ โตะ รเวือะ พากัง เซ. ซ ตอง โรฮ ป มัฮ ลออยฮ อื ละ ซ เกือฮ อื แปน ป ซออย ฮงาื ละ พะจาว ไม่ ปุก เนอึม อื รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","โม อิซราเอน เนอ, เญือะ ไมจ โตว อื มอก ซัตซิง ละ ซ เลียง แตะ พี ป เปลีฮ ติ แตะ ตอก ปิ อาวต นึง ลาึน เซ นึง, นึง มัฮ อื กัน โอ เนอึม รพาวม ละ พะจาว. เซ มัฮ โกตไม ตอน ฮมัน ละ เปอะ. ไมจ เปอะ ยุฮ ลอป ตัม เซ โอ เญาะ ไก ลอยจ. ");
INSERT INTO lcp_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","ไมจ เนอึม เปอะ รโฮงะ ไลลวง เฮี ละ โม อิซราเอน เตือง โต อื, ฮอยจ โรฮ ละ ปุย ตังเมือง ป อาวต ซน่ะ ลลาึง โม อิซราเอน โรฮ. เมาะ ป ทไว ซัตซิง ละ พะจาว เยอ, ป ตอง ทไว เตือง ตัว อื ญุ่ก, ป ทไว โอเอีฮ ไฮญ ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ดัฮ โอ โรวก ทไว ซัตซิง เซ ละ พะจาว ฮอยจ โบ โตะ รเวือะ พากัง ระ โฮ, ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ. ปุ เญือะ เมีญ มัฮ ปุย ไน โม อิซราเอน เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ดัฮ ไก โม อิซราเอน ป ปอน ฮนัม เมอ, ปัง มัฮ ปุย ตังเมือง อาวต ซน่ะ ลลาึง โม อิซราเอน ญุ่ก, อาึ ซ รเตีฮ ปุย ปอน ฮนัม เซ. ซ ทอเนาะ โน่ง ปุย เซ. เญือะ เมีญ โตว มัฮ ปุย ไน โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","มัฮ ฆาื มัฮ ฮนัม เซ จีวิต ละ โอเอีฮ. อาึ เอีจ เกือฮ โรฮ ฮนัม เซ แปน ควน รไซจ พิต โฌวะ ยุฮ เปอะ. ฮนัม ป มัฮ จีวิต ละ โอเอีฮ เซ เกียฮ รไซจ มั่ป ยุฮ ปุย. ");
INSERT INTO lcp_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","มัฮ เซ ป อัฮ อาึ อื ละ โม อิซราเอน ฆาื อื ตอก เฮี, ปุย ไน โม เปะ เตือง โอยจ เปอะ ไมจ เปอะ โตว ปอน ฮนัม. ปัง มัฮ ปุย ตังเมือง อาวต ซนะ ลลาึง เปอะ ญุ่ก, ไมจ โตว อื โรฮ ปอน ฮนัม. ");
INSERT INTO lcp_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","ดัฮ ไก โม อิซราเอน ญุ่ก, ปุย ตังเมือง อาวต ซน่ะ ลลาึง อื ญุ่ก, ดัฮ โฮว ซาวป โปยญ ซัตซิง ป ซง่ะ ไล อื ละ ซ ปอน แตะ โฮ, ไมจ อื เกือฮ ฮนัม อื ปัต โอก ลังเตะ. ฟวยจ เซ ไมจ แม อื เลอึป ฮนัม เซ นึง เตะ รกาื. ");
INSERT INTO lcp_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","เอีจ มัฮ ฮนัม ป แปน จีวิต ละ เนะซอัง ซัตซิง เซ, มัฮ เซ ป ซตอก อาึ โม อิซราเอน ฆาื อื ตอก เฮี, โม เปะ เอ ไมจ เปอะ โตว ปอน ฮนัม ซัตซิง ติ เจือ เนอึม, นึง มัฮ ฮนัม ป แปน จีวิต ละ โกะ เนอึม ซัตซิง เซ โครยญ ตัว อื. ดัฮ ไก ป ปอน เนอ ไมจ ทอเนาะ โน่ง ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","ปุย โครยญ โฆะ อื, ปัง มัฮ โม อิซราเอน, ปัง มัฮ ปุย ตัง เมือง, ดัฮ ไก ป โคะ ปอน โตะ ซัตซิง ยุม ไอฮ ญุ่ก, ยุม นึง เกียต กุก โกะพริ อื ญุ่ก, ไมจ ปุย เซ ฮาวม ไม่ ซัก อื เครอึง เซอึก แตะ เกือฮ ซง่ะ. ปุย เซ แปน ปุย โอ ซง่ะ ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ฟวยจ เซ เดอึม แปน ปุย ซง่ะ ไล. ");
INSERT INTO lcp_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ดัฮ โอ ซัก เครอึง เซอึก แตะ ไม่ โอ แตะ ฮาวม โฮ, ปุย เซ ไก ตุต ฆาื อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน, มัฮ อาึ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","โม เปะ ปุ ยุฮ ป ฆอก ป เบร ตอก ยุฮ โม อียิป อื, ป มัฮ เมือง เอีจ โฮลฮ เปอะ โฮว อาวต นึง ติ โฮน โฮ. ปุ โรฮ ยุฮ ตอก ยุฮ ปุย เมือง คะนาอัน อื, ป มัฮ เมือง ซ ตาว อาึ โม เปะ โฮว อาวต นึง เซ. ปุ โรฮ ยุฮ ตัม ปซี ปซา ยุฮ อื เฟือฮ เอิน. ");
INSERT INTO lcp_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","ไมจ เปอะ ยุฮ ตัม โกตไม ยุฮ อาึ ไม่ โซะโกะ ฮรักซา เปอะ นึง ลปุง ซตอก อาึ อาึง โครยญ โฆะ เปอะ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","ไมจ เนอึม เปอะ โซะโกะ ฮรักซา นึง โกตไม ยุฮ อาึ ไม่ ยุฮ เปอะ ตัม โกตไม เซ โครยญ เจือ. เมาะ ป ปุน ยุฮ ตอก เซ เยอ, ซ โฮลฮ เนอึม จีวิต แตะ เบือ อื. อาึ มัฮ พะจาว.” ");
INSERT INTO lcp_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“โม เปะ ปุ ไอฮ พาวม ไม่ คระ เฌือต ซดิ เปอะ นึง มัฮ อื ป พังไฮะ ลอน. ปุ ไอฮ คระ เฌือต เปอะ เซ แปน ปุย เญือะ เปอะ. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","ปุ ไอฮ พาวม ไม่ มะ โกะ เปอะ นึง มัฮ อื ป พังไฮะ ละ เปือะ เปอะ. เอีจ มัฮ มะ โกะ เปอะ ไอฮ. ปุ ยุฮ ป คึต ป ตวยฮ ละ มะ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","ปุ ไอฮ พาวม ไม่ มะ ตุ เปอะ. ปุ โรฮ ไอฮ แปน ปุย เญือะ เปอะ นึง มัฮ โรฮ อื ปุย เญือะ เปือะ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","ปุ ไอฮ พาวม ไม่ ป ลัง มัฮ รนัน เปอะ. ปุ โรฮ ไอฮ แปน ปุย เญือะ เปอะ, รนัน เลีฮ เปอะ ญุ่ก, รนัน ซวุง เปอะ ญุ่ก, รนัน อาวต ไม่ เปอะ ติ เญือะ ญุ่ก, รนัน อาวต ตัง เญือะ เปอะ ญุ่ก, ปุ ไอฮ พาวม ไม่ ติ ตื เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","ปุ ไอฮ พาวม ไม่ ป ลัง มัฮ กวนโซะ ลุกลัน เปอะ, ปุ โรฮ ไอฮ แปน ปุย เญือะ เปอะ, นึง มัฮ อื ป ไลจ ยุฮ มอยฮ โกะ เปอะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","ปุ ไอฮ พาวม ไม่ กวน รโปวน มะตุ เปอะ นึง มัฮ อื กวน เปือะ เปอะ ไม่ มัฮ โรฮ อื รนัน เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","ปุ โรฮ ไอฮ พาวม ไม่ รนัน เปือะ เปอะ. ปุ โรฮ ไอฮ แปน ปุย เญือะ เปอะ, นึง มัฮ อื กอระ กอตุ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","ปุ โรฮ ไอฮ พาวม ไม่ ออปุ มะ เปอะ. ปุ โรฮ ไอฮ แปน ปุย เญือะ เปอะ, นึง มัฮ อื ปุเลีฮ มะ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","ปุ โรฮ ยุฮ ป พังไฮะ ละ แอนระ แอนตุ เปอะ นึง ไอฮ พาวม เปอะ ไม่ ปรโปวน เญือะ อื, นึง ลัง มัฮ อื มะระ มะตุ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","ปุ โรฮ ไอฮ พาวม ไม่ ป ลัง มัฮ เครียก เปอะ. ปุ โรฮ ไอฮ แปน ปุย เญือะ เปอะ, นึง มัฮ อื ปรโปวน เญือะ กวน โกะ เปอะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","ปุ โรฮ ไอฮ พาวม ไม่ ปรโปวน เญือะ เอียก เญือะ ปุ เปอะ, นึง มัฮ อื ป พังไฮะ ละ อื.” ");
INSERT INTO lcp_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ปุ โรฮ ไอฮ พาวม ไม่ กวน รโปวน ปุย เญือะ เปอะ, ปัง มัฮ กวนโซะ อื ญุ่ก, ปุ โรฮ ไอฮ แปน ปุย เญือะ เปอะ นึง มัฮ อื โกะ เนะ โกะ เปอะ ไอฮ ไม่ มัฮ อื ป พังไฮะ ลอน. ");
INSERT INTO lcp_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ติ เจน ไอม ลั่ง ปุย เญือะ เปอะ ปุ ไอฮ ออปุ ปรโปวน เญือะ เปอะ เซ แปน ปุย เญือะ เปอะ เดอึม โอ ซ ลลั่ฮ ดิ. ");
INSERT INTO lcp_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“เญือม ไก ปะจัม เดื่อน ปรโปวน เนอ ปุ ซาวป ยุ ปุ เปอะ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","ปุ ไอฮ พาวม ไม่ ปรโปวน เญือะ ปุย่วง เปอะ, นึง มัฮ อื ควน เกือฮ โกะ เปอะ แปน ปุย รแอม ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ปุ เกือฮ กวน เปอะ เลียก โตะ งอ ละ ซ แปน อื ควน ทไว เปอะ ละ พะโมเลก เซ, นึง ซ แปน อื ควน ไลจ ยุฮ มอยฮ พะจาว. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","ปุ โรฮ ไอฮ พาวม ไม่ ปรเมะ เอ ตัง ปรโปวน, นึง มัฮ อื ป พังไฮะ ลอน. ");
INSERT INTO lcp_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","ปุ เกือฮ ปรเมะ ปรโปวน ไอฮ พาวม ไม่ ซัตซิง นึง มัฮ อื กัน คึต กัน ตวยฮ, ไม่ แปน เปอะ ปุย ฆอก ปุย เบร ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“โม เปะ ไมจ เปอะ โตว เกือฮ ติ แตะ แปน ปุย รแอม ไล นึง ยุฮ แตะ กัน คึต กัน ตวยฮ ตอก เซ. เอีจ มัฮ ฆาื กัน ฆอก ตอก เซ ป ซ โครฮ อาึ ปุย โฮวน เจือ เซ โอก ฮา เมือง อาวต อื ลั่กกา โม เปะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ปลัฮเตะ ก อาวต โม เซ แปน โรฮ ปลัฮเตะ ฆอก เบร ฆาื อื. มัฮ เซ ป เกือฮ อาึ ปลัฮเตะ เซ ลอก ตุต แตะ ฆาื อื. ปลัฮเตะ ซ ฮาว โรฮ ปุย อาวต นึง แตะ เซ ตอก ฮาว ปุย ป โซม แตะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","โม เปะ ปังเมอ ไมจ เนอึม เปอะ โซะโกะ ฮรักซา นึง ลปุง ซตอก อาึ ไม่ โกตไม ยุฮ ฮุ. ปัง มัฮ โม เปะ ญุ่ก, ปุย ตังเมือง อาวต ซน่ะ ลลาึง เปอะ ญุ่ก, ไมจ เปอะ โตว ยุฮ ป คึต ป ตวยฮ ตอก เซ ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","โม ป อาวต กา โม เปะ นึง เมือง เฮี เยอ, เอีจ ยุฮ ป คึต ป ตวยฮ ตอก เซ. มัฮ เซ ป รแอม ปลัฮเตะ เฮี ละ อาึ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","ดัฮ โม เปะ เกือฮ ปลัฮเตะ เฮี แปน ปลัฮเตะ รแอม โฮ, อาึ ซ เกือฮ ปลัฮเตะ เฮี ฮาว โม เปะ ตอก เอีจ ฮาว อื โม ป เอีจ อาวต นึง แตะ กา โม เปะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ดัฮ ไก ป ยุฮ ป คึต ป ตวยฮ ตอก เซ เยอ, ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ. เญือะ ไมจ โตว เมีญ มัฮ ปุย ไน โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","“เคียง มัฮ อื ตอก เซ เยอ, ไมจ เปอะ ยุฮ ตัม ลปุง ซตอก อาึ อาึง เตือง โอยจ เปอะ. ปุ เกือฮ ติ เปอะ แปน ปุย รแอม ละ อาึ นึง ยุฮ เปอะ กัน ฆอก กัน เบร ตอก เอีจ ยุฮ ปุย โม เซ อื. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","2","พะจาว เกือฮ ไอ โมเซ ซึป ลปุง แตะ ละ โม อิซราเอน เตือง มู อื ตอก เฮี, “อาึ ป มัฮ เยโฮวา พะจาว ยุฮ เปอะ มัฮ ป ซง่ะ ซงอม. โม เปะ ไมจ โรฮ เปอะ แปน ปุย ซง่ะ ซงอม ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ไมจ เปอะ นัปทื มะเปือะ แตะ โครยญ โฆะ เปอะ. ไมจ เปอะ ทื ซเงะ ลโล่ะ ยุฮ อาึ โครยญ ซเงะ ลโล่ะ นึง อื. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ปุ ลเตือฮ ติ เปอะ ฮา อาึ ละ ซ ไว เปอะ ฮุป. ปุ โล โอเอีฮ ละ แปน อื ฮุป ละ ซ ไว เปอะ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“เญือม ซ ทไว เปอะ ซัตซิง ละ อาึ นึง ซ เปลีฮ เปอะ รโจะ ดิ เปอะ รพาวม แตะ ไม่ อาึ อื, ไมจ เปอะ ยุฮ ตัม ป ซตอก อาึ เปอะ ยุฮ. อาึ ซ รัป ป ทไว เปอะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","โตะ โอเอีฮ ทไว เปอะ เซ ไมจ ปุย ปอน ไน ซเงะ เซ ไม่ ซเงะ ปวยฮ พริ เซ โน่ง. ป โฮฮ ลั่ง ฮอยจ ละ ซเงะ ลอวย ไมจ ปุย ตอง แปฮ เกือฮ ฮะ ล่อยญ. ");
INSERT INTO lcp_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ดัฮ ไก ป ปอน โตะ เซ ฮอยจ ซเงะ ลอวย นึง อื, อาึ ซ รัป โตว ป ทไว ปุย เซ, นึง มัฮ อื ป รแอม ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ป ปอน โอเอีฮ ตอก เซ ซ ไก ตุต ฆาื อื นึง เกือฮ อื โอเอีฮ ทไว ปุย ละ พะจาว แปน ป ทัมมด่า. เญือะ ไมจ โตว ปุย เมีญ ปุย เซ มัฮ ปุย ไน โม อิซราเอน ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“เญือม มัก เปอะ เฮงาะ ปุ มัก เกือฮ ฮอยจ ละ เฆียง ชิจ ยุฮ เปอะ. ปุ โรฮ โซวต ป ดุฮ อื ฮา เตะ เปอะ ลไล มัก เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","เปลิ อะงุน ยุฮ เปอะ ปุ โรฮ เปฮ ปอ โอยจ แกล อื. ป ดุฮ อื ลังเตะ ปุ โรฮ ซาวป ซเคระ. ไมจ เปอะ ละ อาึง ละ ป ตุก ป ญัก ไม่ ปุย ตังเมือง ลลาึง เปอะ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ปุ บระ โอเอีฮ ฮี. ปุ อัฮ ป โอ เนอึม ละ ปุย. ปุ บ่วก ละ ปุย เยอ. ");
INSERT INTO lcp_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ปุ ซันญา โอเอีฮ ละ ปุย เบือ มอยฮ อาึ ดัฮ เปอะ โอ ซ ยุฮ เนอึม ตัม ลปุง ซันญา เปอะ เซ. ป ยุฮ ตอก เซ แปน เพียก แฮม อื มอยฮ พะจาว. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ปุ ริ ปุย นึง กัน โอ ซื โอ ไซ. ปุ บระ ปอก โอเอีฮ ยุฮ ปุ ย่วง เปอะ. ปุ ฮลักกอ งวยฮ ซเงะ ลัง เกือฮ เปอะ ละ ลุกจัง เปอะ. ปัง มัฮ ติ ซาวม ปุ ละ อาึง ฮา อื. ");
INSERT INTO lcp_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ปุ ซะ ซม่อต ปุย ฮลาึต เตอ. ปุ อาึง โอเอีฮ นึง คระ โฮว ปุย จัก ละ ซ เกือฮ เปอะ โคะ ซดุฮ. ไมจ เปอะ นัปทื เนอึม อาึ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ปุ ตัตซิน โอเอีฮ ไม่ รพาวม บ่วก เปอะ. ปุ ฮรัก ป ฮรัก จัง ป จัง เปอะ. ปัง มัฮ ปุย ตุก ปุ พาวม ไม่. ปัง มัฮ ปุย กอย ปุ ฮลัต นึง. ไมจ เปอะ ตัตซิน โอเอีฮ ละ ปุ ย่วง เปอะ ตัม ซื อื. ");
INSERT INTO lcp_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ปุ ซาวป โฮว บรุ เพือ ปุย เยอ. ดัฮ ปุย ฟึนฟอง ปุ แตะ นึง ป โอ เนอึม ละ ซ เกือฮ อื ลอก ตุต ฮอยจ ละ ยุม แตะ, ไมจ เปอะ โตว ฮลัต นึง ซ อัฮ เปอะ ป เนอึม ละ ซ เรอึม เปอะ ปุย. อาึ มัฮ เยโฮวา. ");
INSERT INTO lcp_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ปุ เกละยุ ปุย เยอ. ดัฮ ปุย ยุฮ ป พิต ละ เปอะ ไมจ เปอะ ซตอก รเง่อึม ไม่ รพาวม เนอึม แตะ เดอึม โรฮ โกะ เปอะ โอ ซ พิต ฆาื. ");
INSERT INTO lcp_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ปุ ซาวป โรก เวน ละ ปุย. ปุ ทื โซะ โระ โกลยจ ปุ เปอะ. ไมจ เปอะ ฮรัก ปุ ย่วง แตะ ตอก ฮรัก เปอะ โกะ แตะ ไอฮ. อาึ มัฮ เยโฮวา. ");
INSERT INTO lcp_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ไมจ เปอะ ยุฮ ตัม โกตไม ยุฮ อาึ. ปุ เกือฮ คอง เลียง เปอะ ติต ปุ แตะ ไม่ ซัตซิง โอ มัฮ เจือ ติ. ปุ โรฮ วัน รไม่ เฮงาะ ซมา นึง ชิจ ยุฮ เปอะ. ปุ โรฮ จาวป เครอึง เซอึก ไตญ ปุย นึง กอย ลอา เจือ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ดัฮ ไก ป ไอฮ พาวม ไม่ ปรโปวน ป แปน ครา ปุย เยอ, เตือง เอีจ ไก รซอม อื ไม่ ปรเมะ ไฮญ ไม่ โอ โรฮ อื ดิ โตฮ เกือฮ โปน ฮา แปน แตะ ครา เซ, ไมจ ไฮมญ ฮมอง ละ อื รกา เดอึม ไมจ อื เกือฮ ลอก ตุต เตือง ลอา แตะ ตัม โซมกวน อื. ดิ ไมจ เปอะ โตว ยุฮ ยุม ไม่ นึง โอ โรฮ ปรโปวน เซ ดิ โปน ฮา แปน แตะ ครา โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ไมจ ปรเมะ เซ โรวก ทไว แกะ โปก ละ พะจาว ติ ตัว ฮอยจ นึง โตะ รเวือะ พากัง เซ ละ ซ แปน อื ควน ยวก มั่ป กัฮ ตุต รโตง โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ป มัฮ ซตุ เซ ซ มอก อื ละ อื ละ ซ เกือฮ อื แกะ เซ แปน ควน รไซจ พิต โฌวะ ยุฮ อื. เมาะ มั่ป พิต ยุฮ ปุย เซ ซ ยวก เนอึม พะจาว ละ อื ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“เญือม เอีจ โฮลฮ โม เปะ เลียก นึง เมือง คะนาอัน เนอ, ไม่ โฮลฮ โรฮ เปอะ ซมา โคะ ป โซม ป ปอน นึง, เปลิ โคะ ซมา เปอะ เซ ไมจ เปอะ เมีญ มัฮ ป รแอม ไล ละ เปอะ ไน ติ เจน ลอวย เนอึม. ปุ โซม ปอน เฟือฮ เอิน. ");
INSERT INTO lcp_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","เนอึม ปาวน นึง อื เปลิ ป ซมา เปอะ เซ ไมจ เปอะ ทไว ละ พะจาว นึง มัฮ อื ควน ลืลาว เปอะ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","เญือม เอีจ มัฮ อื เนอึม พอน นึง อื, โม เปะ ลัง โซม เปอะ เปลิ โคะ เซ. ดัฮ เปอะ ยุฮ ตอก เซ, อาึ ซ เกือฮ โคะ ซมา เปอะ เซ ระ เน่อึม เกลอึม เปลิ ละ เปอะ ฆาื อื, อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ.” ");
INSERT INTO lcp_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“โม เปะ เอ ไมจ เปอะ โตว ปอน โตะ ป ไก ฮนัม นึง. ปุ โกว กัน ซโปก ซักซี เยอ, ไม่ คทา กทอง, ไม่ ตู ไม่ ลอง. ");
INSERT INTO lcp_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","ปุ คุต ฮาึก นึง โซม เซาะ เปอะ. ปุ โรฮ ญัป ฮาึก กัป เปอะ เกือฮ เญี่ยง โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","ปุ โรฮ ซาวป เฮีจ เนะซอัง เปอะ ละ ซ เปลีฮ เปอะ รพาวม ตุก แตะ ฆาื ยุม ปุย. ปุ โรฮ ซาวป บวก มึก นึง โกะ เนอึม เปอะ. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ปุ เกือฮ กวน เครีฮ เปอะ แปน มอจังคึต, นึง มัฮ อื ป ซ แปน ควน โซะกิจ ปิญไง่ ละ กวน เปอะ เซ, เดอึม เมือง อาวต เปอะ เซ โอ ซ แปน เมือง คึต เมือง ตวยฮ ไม่ นาวก อื นึง ป ฆอก ป เบร ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ไมจ เปอะ โซะโกะ ฮรักซา นึง ซเงะ ลโล่ะ ยุฮ อาึ โครยญ ซเงะ ลโล่ะ. ไมจ โรฮ เปอะ นัปทื พากัง ระ ยุฮ อาึ โรฮ. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ปุ โรฮ ซาวป ยุ โม ป เกียฮ ปัต เกียฮ ซโปก เกอ, ไม่ ป อัฮ ปุย มัฮ ตีนัง. ปุ เกือฮ ติ เปอะ แปน ปุย รแอม ไล ฆาื ปุย โม เซ เฟือฮ เอิน. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ไมจ เปอะ นัปทื เนอึม โม ป เอีจ กวต เอีจ ครา ลลาึง เปอะ. พะจาว ยุฮ เปอะ เซ ไมจ โรฮ เปอะ ฮลัต นึง ไม่ นัปทื เนอึม เปอะ. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“เญือม ฮอยจ อาวต ปุย ตังเมือง ไม่ เปอะ ปุ โคมเฮง ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","ไมจ โรฮ เปอะ เมีญ ปุย ตังเมือง ฮอยจ อาวต ไม่ เปอะ เซ มัฮ โรฮ ปุย ตอก โม โกะ เปอะ โรฮ. ไมจ โรฮ เปอะ ฮรัก ตอก ฮรัก เปอะ โกะ แตะ ไอฮ. ไพรม อื โม เปะ เอีจ มัฮ โรฮ เปอะ ปุย ตังเมือง เญือม อาวต แตะ เมือง อียิป ตอก เซ โรฮ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“เญือม เตะ เญือม แนต เปอะ โอเอีฮ ญุ่ก, เญือม แฆ เปอะ ป ชาวง ป เชียน ญุ่ก, เญือม ซมอย เปอะ โอเอีฮ ญุ่ก, ปุ บ่วก ปุ โจวง นึง ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","โอเอีฮ โกว เปอะ โครยญ เจือ เยอ, ลุ่น ญุ่ก, ลุก ตุม ญุ่ก, ทัง ญุ่ก, ลิต ญุ่ก, ไมจ อื ซเมอ โครยญ เจือ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. เอีจ มัฮ อาึ ป นัม โม เปะ โอก ฮา เมือง อียิป เปอ. ");
INSERT INTO lcp_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","โม เปะ ไมจ เนอึม เปอะ โซะโกะ ฮรักซา นึง ลปุง ซตอก อาึ อาึง, ไม่ ยุฮ เปอะ ตัม โกตไม ยุฮ ฮุ โครยญ เจือ. อาึ มัฮ พะจาว,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, ดัฮ ไก ป เกือฮ กวน แตะ เลียก โตะ งอ ละ ซ ทไว อื ละ พะโมเลก เกอ, โม อิซราเอน ญุ่ก, ปุย ตังเมือง ป อาวต ซน่ะ ลลาึง อื ญุ่ก, ปุย เซ ซ ลอก ตุต แตะ ฮอยจ ละ ยุม แตะ. เกือฮ โม ลัปซด่อน แล่น นึง ซโมะ ปอ ยุม อื. ");
INSERT INTO lcp_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","อาึ ซ รเตีฮ โรฮ ปุย เซ. ซ ทอเนาะ โน่ง เงอะ. เญือะ เมีญ โตว มัฮ ปุย ไน อาึ ฆาื ทไว อื กวน แตะ ละ พะโมเลก เซ. โอเอีฮ ตอก เซ มัฮ โรฮ ป เกือฮ พากัง ซัมคัน ยุฮ อาึ แปน ป รแอม ไม่ แปน โรฮ อื ป พลิฮ บึน มอยฮ ซง่ะ ซงอม ยุฮ อาึ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ดัฮ โม ลัปซด่อน เคียต เกือฮ ติ แตะ โอ ยุ โอ ฮมอง ป ยุฮ ปุย เซ โฮ, ไม่ โอ อื แล่น นึง ซโมะ เกือฮ ยุม, ");
INSERT INTO lcp_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","อาึ ซ รเตีฮ ปุย เซ ไม่ กวน เฌือต อื. ซ ทอเนาะ โน่ง เงอะ. เญือะ เมีญ โตว มัฮ ปุย ไน อาึ, ฮอยจ ละ โม ป ฟวต ปุย เซ นึง ไว แตะ พะโมเลก เซ, นึง โอ อื เนอึม รพาวม ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ดัฮ ไก ป โฮว ซาวป ยุ ตีนัง ไม่ ซาวป อื ยุ ป เกียฮ ปัต เกียฮ ซโปก เกอ, เอีจ มัฮ โรฮ โอ อื เนอึม รพาวม ละ อาึ. อาึ ซ รเตีฮ ปุย เซ, เญือะ เมีญ โตว มัฮ ปุย ไน แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","โม เปะ ไมจ เปอะ เกือฮ ติ แตะ แปน ปุย ซง่ะ ซงอม ฆาื อื. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ไมจ เปอะ โซะโกะ ฮรักซา นึง โกตไม ยุฮ อาึ, ไม่ ยุฮ เปอะ ตัม เซ. อาึ มัฮ พะจาว ป เลือก โม เปะ แปน ปุย ซง่ะ ซงอม ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ดัฮ ไก ป อัฮ ลปุง ฆอก ละ มะเปือะ แตะ, ปุย เซ ซ ลอก ตุต แตะ ฮอยจ ละ ยุม แตะ. ไลลวง ยุม อื เซ มัฮ ฆาื โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ไน โม อิซราเอน ดัฮ ไก ป ไอฮ พาวม ไม่ ปรโปวน เญือะ ปุย เยอ, ไมจ ปุย แล่น ปุย ลอา เซ นึง ซโมะ ปอ ยุม อื. ");
INSERT INTO lcp_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ดัฮ ไก ป ไอฮ พาวม ไม่ ปรโปวน เญือะ เปือะ แตะ เอีจ มัฮ ยุฮ อื ป พังไฮะ ละ เปือะ แตะ เซ, ไม่ มัฮ อื กัน คึต กัน ตวยฮ. ไมจ เอิน ปุย แล่น ปุย ลอา เซ ปอ ยุม อื. ไลลวง ยุม อื เซ มัฮ ฆาื โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ดัฮ ไก ป ไอฮ พาวม ไม่ ป ลัง มัฮ เครียก แตะ, ไมจ ปุย แล่น ปุย ลอา เซ นึง ซโมะ ปอ ยุม อื, นึง ยุฮ อื กัน คึต กัน ตวยฮ. ไลลวง ยุม อื เซ มัฮ ฆาื โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ดัฮ ไก ปรเมะ โต ปรเมะ ไอฮ พาวม ดิ ไม่ ปุ แตะ ตอก ยุฮ ปุย ละ ปรโปวน โฮ, ปุย ลอา เซ เอีจ มัฮ ยุฮ อื ป คึต ป ตวยฮ. ไมจ ปุย แล่น ปุย ลอา เซ นึง ซโมะ ปอ ยุม อื. ไลลวง ยุม อื เซ มัฮ ฆาื โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ดัฮ ไก ปรเมะ ไอฮ ปรโปวน เญือะ แตะ ไม่ ไอฮ โรฮ อื มะ ปรโปวน เญือะ แตะ เซ แปน ปุย เญือะ แตะ โรฮ, ปุย เซ เอีจ มัฮ ยุฮ อื กัน ฆอก ไล. ไมจ ปุย โตก ปุย โม เซ นึง งอ เกือฮ ยุม เตือง ลอวย อื เซ, เดอึม ป ฆอก ป เบร เซ โอ เญือะ ซ เกิต ลลาึง เปอะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ดัฮ ไก ปรเมะ ไอฮ พาวม ไม่ ซัตซิง เงอ, ไมจ ปุย ยุฮ ยุม ไม่, เตือง ปุย เตือง ซัตซิง เซ. ");
INSERT INTO lcp_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ดัฮ ไก ปรโปวน ไอจ ไม่ ซัตซิง ละ ไอฮ พาวม อื ไม่ โฮ, ไมจ ปุย ยุฮ ยุม ไม่ ปรโปวน เซ เตือง ซัตซิง เซ โรฮ. ไลลวง ยุม อื เซ มัฮ ฆาื โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ดัฮ ไก ป มัฮ เพร ป ไอฮ พาวม ดิ ไม่ ป มัฮ รนัน แตะ, กวน รโปวน มะ อื ญุ่ก, กวน รโปวน เปือะ อื ญุ่ก, เอีจ มัฮ ยุฮ อื ป คึต ป ตวยฮ. ป ยุฮ ป พังไฮะ ละ รนัน แตะ เซ, เญือะ ไมจ โตว เมีญ มัฮ ปุย ไน โม อิซราเอน ฆาื อื. ตุต ลอก อื เซ มัฮ ฆาื โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ดัฮ ไก ปรเมะ ยุ ปุ แตะ ไม่ ปรโปวน เญือม ไก ปะจัม เดื่อน อื, ไมจ โรฮ ทอเนาะ ปุย ลอา เซ, เญือะ ไมจ โตว เมีญ มัฮ ปุย ไน โม อิซราเอน, นึง ยุฮ อื ป พิต โกตไม เกว ไม่ ไลลวง ป ซง่ะ ไล เซ. ");
INSERT INTO lcp_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ดัฮ ไก ป ไอฮ พาวม ไม่ ป ลัง มัฮ ออปุ มะ แตะ, ป ลัง มัฮ รนัน เปือะ อื ญุ่ก, ซ ลอก ตุต แตะ ฆาื อื, นึง มัฮ อื ป พังไฮะ ลอน. ");
INSERT INTO lcp_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ดัฮ ไก ปรเมะ ป ไอฮ พาวม ไม่ ปรโปวน เญือะ แอน ระ แอนตุ แตะ, ปุย ลอา เซ ซ ลอก ตุต แตะ ฆาื อื, นึง เอีจ มัฮ อื ป พังไฮะ ละ แอน ระ แอนตุ อื เซ. ซ ยุม ฆาื อื เตือง โอ แตะ ไก กวน เตือง ลอา แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","ดัฮ ไก ปรเมะ ป ไอฮ ปุย เญือะ เอียกปุ แตะ แปน ปรโปวน เญือะ แตะ, ปุย เซ รแอม ไล ฆาื อื. มัฮ โรฮ ป พังไฮะ ละ เอียกปุ อื โรฮ. ซ ยุม โรฮ ฆาื อื เตือง ลอา แตะ เตือง โอ แตะ ไก กวน. ");
INSERT INTO lcp_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ดัฮ มัฮ ตอก เซ, ไมจ เนอึม เปอะ โซะโกะ ฮรักซา นึง ลปุง ซตอก อาึ อาึง, ไม่ ยุฮ เปอะ ตัม โกตไม ยุฮ ฮุ โครยญ เจือ, เดอึม ปลัฮเตะ อาวต เปอะ เซ โอ ซ ฮาว โม เปะ เกือฮ โอก ฮา แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ไมจ เปอะ โตว เฮียน ไม่ ยุฮ แตะ ตัม ปซี ปซา ยุฮ ปุย โฮวน เมือง นา เซ. มัฮ เซ ป ซ โครฮ อาึ โม เซ เกือฮ โอก ลั่กกา โม เปะ ฆาื อื. โม เซ มัฮ ยุฮ อื ป ฆอก ป เบร โฮวน เจือ, มัฮ เซ ป เกละ อาึ ยุ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","อาึ เอีจ ซันญา อาึง ซ เกือฮ แตะ ปลัฮเตะ ตึม โครยญ โคะ โกะ โครยญ โกลง เซ ละ เปอะ เกือฮ แปน คอง เปอะ, ไม่ ซ เกือฮ เนอึม แปน ลอป คอง เปอะ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ, ป เอีจ เกือฮ โม เปะ อาวต ตัง โน่ง ฮา ปุย ไฮญ. ");
INSERT INTO lcp_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","มัฮ เซ ป ไมจ เปอะ ซังเกต ตอก ตัง ไล ซัตซิง, ไซม ไล่, ป ซง่ะ ไล นึง อื ไม่ ป โอ อื ซง่ะ ไล ฆาื อื. ปุ เกือฮ ติ เปอะ แปน ปุย รแอม ฆาื ซัตซิง ไซม ไล่ โอ ซง่ะ ไล เซ, ตอก ป เอีจ รโฮงะ อาึ ละ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ไมจ เปอะ เกือฮ ติ แตะ แปน ปุย ซง่ะ ซงอม ละ อาึ, นึง มัฮ อาึ พะจาว ซง่ะ ซงอม, ไม่ เอีจ เกือฮ ฮะ โม เปะ แปน ปุย ตัง โน่ง ฮา ปุย ปลัฮเตะ เฮี ละ ซ แปน เปอะ ปุย ไน อาึ. ");
INSERT INTO lcp_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ปรเมะ ปรโปวน ป เกียฮ ปัต เกียฮ ซโปก ญุ่ก, ป อัฮ ปุย มัฮ ตีนัง ญุ่ก, ไมจ เปอะ ยุฮ ยุม ไม่. ไมจ เปอะ แล่น นึง ซโมะ. ไลลวง ยุม อื เซ เกว ไม่ โกะ อื ไอฮ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ อัฮ ละ โม ป มัฮ ซตุ ป มัฮ กวน อาโรน ตอก เฮี, ป มัฮ ซตุ อู, ไมจ โตว อื เกือฮ ติ แตะ แปน ป รแอม ไล นึง ไปญ แตะ ปุย เอีจ ยุม, ");
INSERT INTO lcp_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","โนก ฮา มัฮ ป ยุม เซ โกะ เนะ คระ เฌือต ซดิ อื, ตอก มะ ตอก เปือะ อื, กวน รเมะ กวน รโปวน อื ฮอยจ ละ ปุ เลีฮ อื, ");
INSERT INTO lcp_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ฮอยจ โรฮ ละ รนัน อื ป เครีฮ ลั่ง อื, ป อาวต ลั่ง ไม่ อื ติ เญือะ. ");
INSERT INTO lcp_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","โนก ฮา เซ, ปัง มัฮ เฌือต ลวง ปรโปวน เญือะ อื, ไมจ โตว อื ไปญ นึง โอ อื ไมจ เกือฮ ติ แตะ รแอม ไล ฆาื ป ยุม เซ. ");
INSERT INTO lcp_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“โม ซตุ เซ ไมจ โตว อื คุต ฮาึก ไกญ แตะ ไม่ โอ โรฮ อื ไมจ ญัป ฮาึก กัป แตะ ละ ซ เปลีฮ อื รพาวม ตุก แตะ ฆาื ป ยุม เซ. ปุ โรฮ ไมจ อื ซาวป เฮีจ ติ แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","โม ซตุ เซ ไมจ อื แปน ปุย ซง่ะ ซงอม ละ พะจาว ยุฮ แตะ. ไมจ โตว อื ยุฮ ตอก ซ เพียก แฮม ปุย มอยฮ พะจาว นึง มัฮ อื ป แปน ป ตอง ทไว ซัตซิง ไม่ ป โซม ป ปอน ละ พะจาว. มัฮ เซ ป ไมจ อื แปน ปุย ซง่ะ ซงอม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","โม ซตุ เซ ไมจ อื ไอฮ ป เครีฮ ม่อง ลั่ง แปน ปุย เญือะ แตะ. ไมจ โตว อื ไอฮ มอจังคึต. ปรโปวน เอีจ เญือะ ติ โฮน, ดัฮ ละ ปรเมะ เญือะ แตะ โฮ, ปุ โรฮ ลัง ไอฮ อื นึง ไมจ ซตุ เซ แปน ปุย ซง่ะ ซงอม ละ พะจาว ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","ปุย ไมจ อื เมีญ ซตุ เซ แปน ปุย ซง่ะ ซงอม, นึง มัฮ อื ป ทไว ป โซม ป ปอน ละ พะจาว ยุฮ เปอะ. ไมจ เนอึม เปอะ เมีญ มัฮ ปุย ซง่ะ ซงอม นึง มัฮ อาึ พะจาว ป ซง่ะ ซงอม, ไม่ เกือฮ โรฮ โฮะ โม เปะ แปน ปุย ซง่ะ ซงอม โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","ดัฮ ไก กวน รโปวน ซตุ ป เกือฮ ติ แตะ แปน มอจังคึต เตอ, มัฮ โรฮ โชะ อื นา เปือะ แตะ ฆาื อื. ไมจ เปอะ โตก เอิน นึง งอ เกือฮ ยุม. ");
INSERT INTO lcp_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ป ดุฮ ปุย แปน ฮัวนา ซตุ เบือ เรฮ ปุย ลออยฮ ซัมคัน นึง ไกญ อื ละ ซ โฮลฮ อื ไอฮ เครอึง ซัมคัน ซตุ เซ, ไมจ โตว อื พลวย ฮาึก แตะ ไม่ แจฮ อื เครอึง เซอึก แตะ เญือม ยุม ปุย โฮ. ");
INSERT INTO lcp_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","12","ไมจ โตว อื โอก ฮา ควง ซัมคัน ยุฮ พะจาว ละ ซ ลอก อื ตัว ป ยุม, เดอึม โอ ซ แปน ปุย รแอม ไล ฆาื อื, ไม่ โอ โรฮ พากัง ยุฮ พะจาว ซ แปน ป รแอม ไล. ปัง มัฮ ป ยุม เซ มะเปือะ โกะ อื ญุ่ก, ไมจ โตว อื ลอก นึง เอีจ อาวต ลออยฮ ซัมคัน ยุฮ พะจาว เซ นึง ไกญ อื. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ป มัฮ ปรโปวน เญือะ ฮัวนา ซตุ เซ ไมจ อื มัฮ ปเครีฮ ม่อง ลั่ง. ");
INSERT INTO lcp_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ไมจ โตว อื เญือะ ไม่ แมฮัง แมไม, ไม่ ปรโปวน ป แปน มอจังคึต. ไมจ อื ซาวป ป มัฮ ปรโปวน ไน โม โกะ แตะ ไม่ มัฮ อื ปเครีฮ ม่อง ลั่ง แปน ปุย เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ดัฮ โอ แฮน ติ แตะ ตอก เซ ซ แปน ควน เกือฮ อื กวน เฌือต โกะ อื เซ แปน ปุย รแอม ไล ฆาื อื. อาึ มัฮ พะจาว ป เกือฮ อื แปน ปุย ซง่ะ ซงอม,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“ไมจ เปอะ อัฮ ละ อาโรน ตอก เฮี, เมาะ ป มัฮ จัตเจือ เปอะ โครยญ เจน ปุย เยอ, ดัฮ ไก ปุย โอ ตอก ปุย เกิต ซน่ะ ลลาึง เปอะ โฮ, ไมจ เปอะ โตว เกือฮ ปุย เซ เลียก ทไว ป โซม ป ปอน ละ พะจาว ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ปุย ตอก เซ ไมจ โตว อื เลียก เคะ พะจาว. ปุย จัก ไง่ ญุ่ก, ปุย คาโด่ ญุ่ก, ป ไก เบราะ เบิ ญุ่ก, ปุย วิต เตะ วิต ชวง ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ป โละพริ เตะ ชวง ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ปุย รโกม ญุ่ก, ปุย แตวะ, ปุย ไลจ ไง่, ปุย ลอก ฮิต ติต คีคัก, ปุย เซฮ ปุย ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ดัฮ ไก ป มัฮ จัตเจือ อาโรน ปุย โละพริ อี, ปุ เกือฮ ปุย เซ เลียก ทไว ป โซม ป ปอน ละ พะจาว ยุฮ แตะ ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ปุย ตอก เซ เยอ, ลัง โซม อื ป โซม ป ปอน ป ทไว ปุย ละ พะจาว เยอ, เตือง โอเอีฮ ป ซง่ะ ซงอม ไม่ ป ตึก นึง ซง่ะ ซงอม แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","โกะ อื เซ ปังเมอ โอ อื ไมจ เลียก โบ พากัง รฆุน ฮอง ซัมคัน เซ, ไม่ โบ คัน ทไว เซ, นึง มัฮ อื ปุย โละพริ. ไมจ โตว อื เกือฮ พากัง เซ แปน ป รแอม ไล ฆาื อื, นึง มัฮ อาึ พะจาว ป เกือฮ โอเอีฮ เซ แปน ป ซัมคัน ละ แตะ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ไอ โมเซ รโฮงะ เนอึม ไลลวง เซ ละ อาโรน ไม่ กวน เฌือต อื, ฮอยจ โรฮ ละ โม อิซราเอน เตือง โอยจ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“ไมจ เปอะ อัฮ ละ อาโรน ไม่ กวน เฌือต อื เกือฮ เมีญ โอเอีฮ ป ฮอยจ ทไว โม อิซราเอน ละ อาึ เซ แปน ป ซัมคัน, นึง มัฮ อื ป ซง่ะ ซงอม, ละ โอ เปอะ ซ เกือฮ ปุย เพียก แฮม มอยฮ ซัมคัน อาึ เซ. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","ไมจ เปอะ อัฮ ละ อื ตอก เฮี, ‘ดัฮ ไก ป มัฮ กวน เฌือต เปอะ, ดัฮ เลียก เคะ อาึ ละ ซ ทไว แตะ โอเอีฮ ซง่ะ ซงอม ป ทไว โม อิซราเอน เซ, เตือง มัฮ โกะ แตะ ปุย รแอม ไล เยอ, ไมจ เปอะ ทอเนาะ ปุย เซ เกือฮ โอก ฮา อาึ. ปุ เญือะ เกือฮ ทไว โอเอีฮ ละ อาึ เฟือฮ. เฮี มัฮ โกต ป ไมจ เปอะ โกว ลอป โครยญ เจน ปุย. อาึ มัฮ พะจาว.’ ");
INSERT INTO lcp_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ดัฮ ไก จัตเจือ อาโรน เนอ ป ลอก อื ลาวต ญุ่ก, ป ไก ป ปัต โอก เน่อึม นึง อื ญุ่ก, ไมจ โตว อื ปอน ป ซง่ะ ไล ทไว ปุย ติ เจือ เนอึม. ไมจ อื มอง ฮอยจ ละ ซง่ะ ไล โกะ แตะ ละ ฮัม, ฟวยจ เซ เดอึม ไมจ อื ปอน. ดัฮ ไก ปุย ไปญ ป ยุม ญุ่ก, ป โอก รอาวม โกะ อื ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ป ไปญ ซัตซิง ไร ลังเตะ ญุ่ก, ปัง โคะ ลอก ปุย ไฮญ ป รแอม ไล ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ซตุ ป ลอก ป ไปญ โอเอีฮ ตอก เซ เอีจ แปน ปุย รแอม ไล ฆาื อื ฮอยจ ละ เลียก ซเงะ เซ. ป รแอม ไล เซ กา เฆียง ฮาวม อื, ดิ เกียฮ โซม ปอน โตว โอเอีฮ ป ซง่ะ ไล เซ. ");
INSERT INTO lcp_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","ดัฮ ซเงะ เอีจ เลียก โฮ, โฮลฮ แม โรฮ แปน ปุย ซง่ะ ไล แม. ฟวยจ เซ โฮลฮ โซม ปอน อื ป ทไว ปุย เซ, นึง มัฮ อื ป ลัง โฮลฮ อื. ");
INSERT INTO lcp_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","เมาะ ป มัฮ ซัตซิง ยุม ไอฮ ญุ่ก, ยุม นึง เกียต กุก โกะพริ ไฮญ อื ญุ่ก, ไมจ โตว อื โซม ปอน, เดอึม โอ ซ แปน ปุย รแอม ไล ฆาื อื. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“โม ซตุ เซ ไมจ เนอึม อื โซะโกะ ฮรักซา นึง ลปุง ซตอก อาึ แตะ เดอึม โอ ซ ลอก ตุต แตะ, ไม่ ยุม แตะ ฆาื อื นึง เกือฮ อื ติ แตะ รแอม ไล ตอก เซ. เอีจ มัฮ อาึ พะจาว ป เกือฮ อื แปน ปุย ซง่ะ ซงอม เมอ. ");
INSERT INTO lcp_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“โอเอีฮ ป ซัมคัน ป ทไว ปุย เซ, ปุ เกือฮ ปุย ไฮญ โซม ปอน เฟือฮ. ปุย ฮอยจ อาวต ไม่ ซตุ เซ ญุ่ก, ลุกจัง อื ญุ่ก, ปุ เกือฮ โซม ปอน อื ติ ตื เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ดัฮ ไก โม ซตุ รวี ปุย ไฮญ เกือฮ แปน ครา แตะ นึง มาื ยุฮ โกะ แตะ ไอฮ, ป มัฮ ครา อื เซ ปังเมอ ลัง โซม ปอน โรฮ อื. โม ครา เมาะ ป เกิต อื นึง เญือะ ซตุ เซ ลัง โซม ปอน โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","ดัฮ ไก กวน เครีฮ ซตุ ป เอีญ ละ ปุย ป โอ มัฮ โม ซตุ อู, ปุย เซ เญือะ ลัง โซม ปอน โตว อื ป โซม ป ปอน ซัมคัน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ดัฮ กวน รโปวน ซตุ เซ มัฮ แมฮัง แมไม, ไม่ โอ แตะ ไก กวน โฮ, ไม่ เอีญ อาวต แม อื ไม่ เปือะ แตะ, ปุย เซ ลัง โซม ลัง ปอน โรฮ อื โอเอีฮ ป ลัง โซม ลัง ปอน เปือะ แตะ เซ. ปุย ไฮญ เญอ ปังเมอ โอ ลัง โซม ลัง ปอน อื เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ดัฮ ไก ป โคะ โซม ปอน โอเอีฮ ซัมคัน ทไว ปุย เซ, ไมจ อื โรก ละ ซตุ. โฮฮ ฮา โรก อื เซ ไมจ แม อื บุ งวยฮ อื ฆาื อื ง่า เปอเซน แม. ");
INSERT INTO lcp_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","16","โม ซตุ เซ ไมจ โตว อื เกือฮ ป โซม ป ปอน ซัมคัน ทไว โม อิซราเอน ละ พะจาว เซ แปน ป โอ ซัมคัน นึง เกือฮ อื โม ลัปซด่อน โซม ปอน. ดัฮ ยุฮ อื ตอก เซ โม ลัปซด่อน เซ ซ ลอก ตุต แตะ ฆาื โซม ปอน แตะ โอเอีฮ ซัมคัน เซ. เอีจ มัฮ อาึ พะจาว ป เกือฮ โอเอีฮ เซ แปน ป ซัมคัน เนอ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","19","“ไมจ เปอะ รโฮงะ ละ อาโรน ไม่ กวน เฌือต อื ฮอยจ โรฮ ละ โม อิซราเอน เตือง โอยจ อื ตอก เฮี, ดัฮ ไก ป ฮอยจ ตอง ทไว ซัตซิง เตือง ตัว อื ตอก ปุก อื รพาวม พะจาว เยอ, ปัง มัฮ โมวก แกะ ปิ ญุ่ก, ไมจ อื ทไว ตัว ป โปก อื ไม่ โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม. โม อิซราเอน ญุ่ก, ปุย ตังเมือง ญุ่ก, ปัง มัฮ ป ซันญา อื อาึง นึง ป ซ ทไว แตะ ญุ่ก, ปัง มัฮ ป ทไว อื ตัม รพาวม ฆวต ทไว แตะ ญุ่ก, ไมจ ตื ยุฮ ตัม ไล เซ. ");
INSERT INTO lcp_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","เญือม ทไว เปอะ ซัตซิง เงอ, เกียฮ ทไว เปอะ โตว ป ไก ตอก โละพริ อื, นึง โอ พะจาว เกียฮ รัป ป ทไว เปอะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ป ทไว ซัตซิง นึง ฆวต รโจะ อื รพาวม แตะ ไม่ พะจาว เยอ, ป ทไว ตัม ป เอีจ ซันญา แตะ อาึง ญุ่ก, ป ทไว ตัม รพาวม ฆวต ทไว แตะ ญุ่ก, ป ทไว อื เซ ไมจ อื ทไว ตัว ป โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม, เดอึม พะจาว ซ รัป ป ทไว อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ซัตซิง ป จัก ไง่ โบวก เตะ, ป ไก เบราะ ไก เบิ, ป ไก คีคัก คีกอ นึง, ปุ โรวก ทไว ละ พะจาว เฟือฮ. ปุ โรฮ เกือฮ แปน ป โซม ป ปอน ทไว เปอะ ละ พะจาว นึง คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ซัตซิง ทไว เปอะ ละ พะจาว เซ, ปัง มัฮ โมวก ญุ่ก, กวน แกะ ญุ่ก, ดัฮ เนะซอัง อื ไก ตอก วิต ตอก โฮฮ โฮ, ดัฮ เปอะ ทไว นึง รพาวม ฆวต ทไว เปอะ โฮ แปน โรฮ. ดัฮ เปอะ ทไว นึง เอีจ มัฮ อื ป ลัง ทไว เปอะ นึง รซอม ซันญา เปอะ โฮ, ปังเมอ โอ แปน. ");
INSERT INTO lcp_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ซัตซิง ป ฮอยจ ทไว ปุย ละ พะจาว เยอ, ปุ เกือฮ มัฮ ป ไก ฮรอย ปุฮ, ฮรอย บวก, ฮรอย เฮีจ, ฮรอย แปฮ นึง กลา อื เฟือฮ เอิน. พะจาว ญอม โตว เกือฮ ปุย ทไว โอเอีฮ ตอก เซ นึง อื เฟือฮ ไน ติ ปลัฮเตะ อาวต เปอะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ซัตซิง โอ เญือะ ไมจ ตอก เซ ป โฮลฮ เปอะ เน่อึม เมือง ปุย ไฮญ เญอ, ไมจ เปอะ โตว โรวก ทไว ละ เกือฮ เปอะ แปน ป โซม ป ปอน ทไว ปุย ละ พะจาว เฟือฮ, นึง โอ พะจาว ซ รัป, ฆาื เมีญ อื มัฮ ซัตซิง โละพริ ละ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“เญือม เกิต กวน โมวก กวน แกะ กวน ปิ ยุฮ เปอะ, ไมจ เปอะ ละ เกือฮ อาวต ไม่ มะ อื อาแลฮ ซเงะ. เคียง ซเงะ ซเตะ นึง อื โฮว ลั่กกา แตะ เอีจ เกียฮ โกว เปอะ ละ ป โซม ป ปอน ทไว เปอะ ละ พะจาว เยอ. พะจาว ซ รัป โรฮ ป ทไว เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","มะ โมวก ยุฮ เปอะ เซ, มะ แกะ, มะ ปิ ยุฮ เปอะ ญุ่ก, ปุ บรุก ยุฮ ยุม ไม่ ไน ซเงะ ติ เตือง มะ เตือง กวน อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","โม เปะ เญือม ทไว เปอะ ซัตซิง ละ ซ ญันดี่ แตะ นึง พะจาว เยอ, ไมจ เนอึม เปอะ ยุฮ ตัม ปุก อื ไล แตะ, เดอึม ซ ปุก รพาวม พะจาว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","โอเอีฮ ทไว เปอะ เซ ไมจ เปอะ โซม ปอน ไน ซเงะ เซ เกือฮ โอยจ. ปุ เกือฮ โฮฮ ฮอยจ ละ ซเงะ ติ อื แม. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“ไมจ เปอะ โซะโกะ ฮรักซา นึง ลปุง ซตอก อาึ เปอะ ยุฮ ไม่ ยุฮ เปอะ ตัม เซ โครยญ เจือ. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","ปุ เกือฮ ปุย โฮลฮ เพียก แฮม มอยฮ อาึ. ไมจ เปอะ เกือฮ มอยฮ อาึ แปน ป ซัมคัน ละ ปุย ลลาึง โม อิซราเอน. อาึ มัฮ พะจาว ป เกือฮ โม เปะ แปน ปุย ซง่ะ ซงอม. ");
INSERT INTO lcp_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","มัฮ โรฮ อาึ พะจาว ป นัม โม เปะ โอก ฮา เมือง อียิป เปอ ละ ซ แปน เนอะ พะจาว ยุฮ เปอะ. อาึ มัฮ เยโฮวา,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ไลลวง ซเงะ ชลอง ปุย ตัม เวลา ลัง ไก อื ละ ซ เกือฮ ปุย โตก ละ พะจาว. ไมจ ปุย ครอฮ ละ ปุ แตะ เกือฮ แปน ซเงะ ซัมคัน เลียง ปุย ปุ แตะ นึง. เอีจ มัฮ โม เฮี. ");
INSERT INTO lcp_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","ไน แลฮ ซเงะ นึง อื ไมจ เปอะ ยุฮ กัน. ซเงะ อาแลฮ นึง อื มัฮ ซเงะ ลโล่ะ เปอะ ละ ซ โพรม เปอะ ละ ง่อต แตะ พะจาว ไม่ ปุ แตะ. ไมจ เปอะ โตว ยุฮ กัน นึง เฟือฮ เอิน. ปัง อาวต เปอะ นา ออฮ นา เอีฮ ญุ่ก, ไมจ เปอะ ทื ซเงะ เซ แปน ซเงะ ซัมคัน ละ พะจาว.” ");
INSERT INTO lcp_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","เฮี มัฮ ไลลวง ซเงะ เญือม ไก กัน โพรม ชลอง เปอะ ตัม ป อัฮ พะจาว อาึง โครยญ เนอึม ตัม เวลา ลัง ไก อื. เญือม เอีจ เติง เวลา อื เซ, ไมจ เปอะ ครอฮ เกือฮ ปุย ฮมอง. ");
INSERT INTO lcp_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","เญือม เอีจ ฮาวก เคิ ติ กาว โรฮ ปาวน ซาวม เมอ, ปู เซ นึง อื มัฮ โรฮ ซเงะ โซม เลียง ฌาว ยุฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ปวยฮ พริ เซ แม, ปุก โรฮ ฮาวก เคิ เซ กาว โรฮ พอน ซาวม, มัฮ แม เวลา โซม ปุย คโนมปัง โอ ไก เจือ ละ ซ นัปทื แตะ พะจาว. โม เปะ ไมจ เปอะ โซม คโนมปัง โอ ไก เจือ เซ อาแลฮ ซเงะ เตม. ");
INSERT INTO lcp_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ซเงะ เมือ โรง นึง อื ไมจ เปอะ โพรม ดิ ละ ซ นัปทื แตะ พะจาว นึง. ไมจ เปอะ โตว ยุฮ กัน โกะ แตะ นึง เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ไน อาแลฮ ซเงะ เซ ไมจ เปอะ ทไว ป โซม ป ปอน เปอะ ละ พะจาว โครยญ ซเง่ะ. ซเงะ อาแลฮ นึง อื เซ ไมจ แม เปอะ โพรม ดิ ละ ซ นัปทื แตะ พะจาว ไม่ ปุ แตะ. ไมจ เปอะ โตว ยุฮ กัน โกะ แตะ นึง เญี่ยะ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","เญือม เอีจ ฮอยจ โม เปะ นึง ปลัฮเตะ เกือฮ พะจาว ละ เปอะ, ไม่ โฮลฮ โรฮ เปอะ เกป ป ซมา ลโลวง แตะ, เฮงาะ ฟาว มัก เปอะ รกา นึง อื ไมจ เปอะ เอีญ ตาว ฮอยจ ละ ซตุ. ");
INSERT INTO lcp_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ปวยฮ พริ ฟวยจ ซเงะ ลโล่ะ เซ, ซตุ เซ ซ ตุย เฮงาะ ฟาว เซ กอยฮ ทไว อื ละ พะจาว เดอึม ป ทไว ปุย ซ แปน ป ปุก รพาวม พะจาว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ซเงะ กอยฮ เปอะ ทไว เฮงาะ เซ ไมจ แม เปอะ ตุย กวน แกะ โปก ป ไก อาญุ อื ติ เนอึม, ไม่ โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม, ละ ซ ตอง เปอะ ทไว ละ พะจาว เตือง ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ป โซม ป ปอน ไมจ เปอะ ทไว เซ มัฮ ญอต แปง ปาวน ลิต ซเบื่อก ไม่ ลออยฮ ละ ซ ทไว เปอะ ละ พะจาว, มัฮ ป ซออย ฮงาื ละ อื ไม่ ป ปุก รพาวม อื. ไมจ แม เปอะ ทไว ไม่ รอาวม อะงุน ติ ลิต. ");
INSERT INTO lcp_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","เฮงาะ รโกะ โคระ ยุฮ เปอะ, ปัง ไซป เปอะ โซม ญุ่ก, ปัง ยุฮ เปอะ คโนมปัง นึง ญุ่ก, ปัง เดือก เปอะ ญุ่ก, ไมจ เปอะ โตว โซม กา เฆียง โฮลฮ เปอะ โรวก ป ไมจ แตะ ทไว ละ พะจาว เซ รกา. เซ มัฮ โกตไม ตอน ฮมัน เกือฮ อาึ ละ เปอะ ไม่ กวน เฌือต เปอะ ฮอยจ ละ ล่อยญ ฆอ กุม เจน เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ฟวยจ ซเงะ ลโล่ะ เกือฮ เปอะ ซตุ กอยฮ ทไว เฮงาะ ฟาว ยุฮ แตะ เซ, ไมจ แม เปอะ เมีญ อาแลฮ ควป ซเงะ เตม. ");
INSERT INTO lcp_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ฟวยจ เซ เมีญ แม ติ ซเงะ แม, แปน ซเงะ รฮอน นึง อื. เอีจ มัฮ ซเงะ ฟวยจ ซเงะ ลโล่ะ อาแลฮ โฮน เซ. ซเงะ เซ ไมจ แม เปอะ โรวก ทไว รโกะ โคระ ละ พะจาว แม. ");
INSERT INTO lcp_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ไมจ โรฮ เปอะ โรวก คโนมปัง ลอา กอน ระ ละ ซ เกือฮ เปอะ แปน ป กอยฮ แตะ ทไว ละ พะจาว เน่อึม นึง เญือะ แตะ เตือง ไพ เตือง มัน. คโนม เซ ยุฮ นึง ญอต แปง ป มัฮ เฮงาะ รโกะ ป โฮลฮ เปอะ เกป เมือ โรง อื เมาะ ปาวน ลิต. ดุฮ เจือ คโนมปัง นึง ละ ซ ทไว เปอะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","โนก ฮา คโนมปัง เซ ป ไมจ เปอะ ทไว รโตง โม ลัปซด่อน เซ มัฮ กวน แกะ โปก อาแลฮ ตัว ป ไก อาญุ อื เมาะ ติ เนอึม, ป โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม. ทไว แม ไม่ โมวก โปก นุม ติ ตัว ไม่ แกะ โปก แม ลอา ตัว. เกือฮ แปน ป ตอง เปอะ ทไว ละ พะจาว เตือง ตัว อื. ตอง ดิ เปอะ ไม่ เฮงาะ รโกะ ไม่ รอาวม อะงุน เซ, ละ ซ เกือฮ แปน คอง ทไว ป ซออย ฮงาื ละ พะจาว, ไม่ ป ปุก รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ไมจ แม เปอะ ทไว ปิ โปก ติ ตัว ละ เกือฮ แปน ควน โตฮ ปุย ติ แตะ ฮา มั่ป. ทไว ไม่ กวน แกะ โปก ลอา ตัว ป ไก อาญุ อื ติ เนอึม, ละ ซ เกือฮ แปน ควน รโจะ ปุย รพาวม แตะ ไม่ พะจาว ไม่ ป ปุก รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","เกือฮ ซตุ เซ กอยฮ ทไว คโนมปัง ป ยุฮ เปอะ นึง เฮงาะ รโกะ โฮลฮ โรง เปอะ เซ ไม่ กวน แกะ เซ ลอา ตัว ป ทไว เปอะ เซ. ซ แปน เนอึม ป ซง่ะ ซงอม เนอึม ละ พะจาว. เอีจ มัฮ ป ลัง ละ โม ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","ไน ซเงะ ติ เซ ไมจ เปอะ โพรม ไม่ ปุ แตะ เกือฮ มัฮ ซเงะ ซัมคัน ละ ซ นัปทื เปอะ พะจาว นึง. ไมจ เปอะ โตว ยุฮ กัน นึง เฟือฮ. ไล เฮี เยอ ไมจ เปอะ เกือฮ แปน โกตไม ตอน ฮมัน ละ เปอะ เตือง โม กวน เฌือต เปอะ โครยญ โดฮ นา ก อาวต เปอะ, ฮอยจ ละ ล่อยญ ฆอ กุม เจน เปอะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“เญือม เอีจ โฮลฮ เปอะ มัก เฮงาะ ยุฮ แตะ ไมจ เปอะ โตว มัก เอิน เกือฮ โอยจ เฮงาะ อาวต เฆียง ชิจ เฆียง ม่า ยุฮ เปอะ เซ. ป ดุฮ อื ฮา เตะ เปอะ ลไล มัก เปอะ เซ ปุ โรฮ เญือะ แม โซวต. ไมจ โรฮ เปอะ ละ ละ โม ป ตุก ป ญัก ไม่ ปุย ตังเมือง โรฮ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, เญือม เอีจ ฮาวก เคิ อาแลฮ ติ ซาวม เมอ, ไมจ เปอะ ลโล่ะ นึง เตือง โอยจ เปอะ. เญือม เอีจ ฮมอง เปอะ เซียง โตวต ยุฮ พะจาว เซ ไมจ เปอะ โพรม ดิ ละ ซ นัปทื แตะ พะจาว ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ปุ ยุฮ กัน เปอะ นึง ซเงะ เซ. ไมจ เปอะ โรวก ป โซม ป ปอน ป ไมจ แตะ ทไว ละ พะจาว โครยญ โฆะ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","เญือม เอีจ ฮาวก เคิ อาแลฮ เซ กาว ซาวม เมอ, มัฮ โรฮ ซเงะ รไซจ พะจาว พิต โฌวะ ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","ไมจ เปอะ โพรม ดิ ละ ซ นัปทื แตะ พะจาว นึง. ซเงะ เซ ไมจ เปอะ เออึป ป โซม แตะ. ไมจ โรฮ เปอะ โรวก ป โซม ป ปอน ป ไมจ แตะ ทไว ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ไน ซเงะ เซ เยอ ไมจ เปอะ โตว ยุฮ กัน นึง เฟือฮ, นึง มัฮ อื ซเงะ รไซจ พะจาว มั่ป ยุฮ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ดัฮ ไก ป โอ เออึป ป โซม แตะ ไน ซเงะ เซ เยอ, ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ ฮา โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ดัฮ ไก ป ยุฮ กัน ไน ซเงะ เซ, อาึ ซ ยุฮ โรฮ ไลจ ไม่ ปุย เซ เกือฮ โรฮ ยุม ฮา เอียกปุ ตุ เจอ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","โม เปะ ปุ ยุฮ กัน นึง ไน ซเงะ เซ ติ เจือ เนอึม. ไลลวง เฮี มัฮ โกตไม ตอน ฮมัน ละ เปอะ โครยญ โดฮ นา ก อาวต เปอะ เตือง กวน เฌือต เปอะ, ฮอยจ ละ ล่อยญ ฆอ กุม เจน เปอะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","เน่อึม เมือ กปู ซเงะ ซไตม นึง อื ฮอยจ ละ เมือ กปู ซเงะ กาว นึง อื, มัฮ ซเงะ โฮลฮ เปอะ ลโล่ะ กัน เกียง แตะ นึง โครยญ เจือ. ไมจ โรฮ เปอะ เออึป ป โซม แตะ นึง, ไม่ เมีญ เปอะ มัฮ ซเงะ ซัมคัน ละ แตะ, อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, เญือม เอีจ ฮาวก เคิ อาแลฮ กาว โรฮ พอน ซาวม เมอ, มัฮ แม ซเงะ ชลอง ยุฮ เปอะ ติ แม. ไมจ เปอะ อาวต นึง เตอึป ตา อาแลฮ ซเงะ แม ละ เกือฮ เปอะ แปน ควน นัปทื แตะ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ซเงะ เมือ โรง อื มัฮ ซเงะ โพรม เปอะ ไม่ ปุ แตะ. ไมจ เปอะ โตว ยุฮ กัน โกะ แตะ นึง. ");
INSERT INTO lcp_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ไน อาแลฮ ซเงะ เซ ไมจ เปอะ โรวก ป โซม ป ปอน ป ทไว แตะ ละ พะจาว โครยญ ซเง่ะ. ซเงะ ซเตะ นึง อื มัฮ แม ซเงะ โพรม ดิ เปอะ ละ ซ ทื แตะ พะจาว. ไมจ แม เปอะ โรวก ป โซม ป ปอน ป ไมจ แตะ ทไว ละ พะจาว. ไมจ เปอะ โตว ยุฮ กัน โกะ แตะ นึง ไน ซเงะ เซ, นึง มัฮ อื ซเงะ ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","ซเงะ ชลอง โม เซ เตือง โอยจ อื มัฮ ซเงะ เมก ไม พะจาว อาึง ละ เปอะ, ละ ซ โพรม ดิ เปอะ ละ ง่อต แตะ พะจาว, ไม่ เมีญ เปอะ มัฮ ซเงะ ซัมคัน ละ แตะ โครยญ โฆะ แตะ. มัฮ โรฮ ซเงะ ทไว เปอะ ป โซม ป ปอน, ซเงะ ตอง เปอะ ทไว ซัตซิง, ไม่ ทไว โรฮ เปอะ เฮงาะ รโกะ ไม่ รอาวม อะงุน ละ พะจาว ตัม ป ลัง ยุฮ แตะ โครยญ ซเง่ะ ตัม ปุก อื ไล แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ซเงะ ชลอง โม เซ เยอ, ตัง โน่ง ฮา ซเงะ ลโล่ะ ทัมมด่า. ป ทไว ปุย นึง อื ตัง โน่ง โรฮ ฮา ป ลัง ทไว ปุย เญือม ไฮญ. ตัง โรฮ ฮา ป เอีจ ซันญา ปุย อาึง ละ ซ ทไว แตะ, ไม่ ป ทไว ปุย ตัม รพาวม ฆวต ทไว แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","เญือม เอีจ ฮาวก เคิ อาแลฮ เซ กาว โรฮ พอน ซาวม เมอ, เญือม เอีจ โฮลฮ โรฮ เปอะ เกป เปลิ ป ซมา ลโลวง แตะ นึง ปลัฮเตะ อาวต เปอะ เฮี, ไมจ เปอะ ชลอง ฆาื อื อาแลฮ ซเงะ. ซเงะ เมือ โรง นึง อื มัฮ ซเงะ โฮลฮ เปอะ ลโล่ะ อาวต ไมจ มวน นึง. เญือม เอีจ ฮอยจ อื ซเงะ ซเตะ นึง อื มัฮ แม โรฮ ซเงะ โฮลฮ เปอะ อาวต ลโล่ะ นึง ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ซเงะ เมือ โรง อื เซ ไมจ เปอะ รอยฮ โรวก เปลิ ไมจๆ ป ซมา เปอะ เซ. โรวก ไม่ กัก โคะ เกลอึม ฮละ โฮวน เจือ ละ ซ เลียง เปอะ ปุ แตะ ละ ซ เปลีฮ เปอะ รพาวม ญันดี่ แตะ นึง พะจาว ยุฮ เปอะ ไน อาแลฮ ซเงะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ซเงะ เตือง อาแลฮ อื เซ ไมจ เปอะ เลียง ปุ แตะ นึง, ไม่ เมีญ เปอะ มัฮ ทไว แตะ ละ พะจาว โครยญ เนอึม. เฮี มัฮ โรฮ โกตไม ตอน ฮมัน ละ เปอะ ป ไมจ เปอะ ทื นึง เคิ อาแลฮ เซ โครยญ เนอึม ฮอยจ ละ จัตเจือ เปอะ โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ไน ซเงะ อาแลฮ เซ ป มัฮ โม อิซราเอน เตือง โอยจ อื ไมจ อื อาวต นึง เตอึป, ");
INSERT INTO lcp_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ละ ซ เกือฮ จัตเจือ เปอะ ยุง มัฮ อาึ ป เกือฮ โม อิซราเอน อาวต นึง เตอึป เญือม นัม เมอะ โอก ฮา เมือง อียิป โฮ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ, อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ไอ โมเซ รโฮงะ เนอึม ไลลวง เซ ละ โม อิซราเอน ละ ซ เกือฮ แตะ โม อิซราเอน ยุง ซเงะ ไมจ แตะ ชลอง ไม่ เลียง อื ปุ แตะ ตัม ป เมก ไม พะจาว อาึง โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“ไมจ เปอะ ดวน โม อิซราเอน เกือฮ โรวก ลออยฮ กาวก ซโน ละ ซ บุ ลออยฮ นึง ออม ป อาวต นึง พากัง ระ เซ ละ ซ เกือฮ ออม เซ ตอก ลอป. ");
INSERT INTO lcp_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","เกือฮ โรฮ อาโรน อาึง ออม เซ นึง ก ลัง อาวต อื, ไม่ เตี อื เน่อึม เมือ กปู ฮอยจ ละ เมือ กซะ อื, นึง ลั่กกา พากัง รฆุน ฮอง นา ก ไก ฮิต ลปุง ซันญา เซ. ไมจ อื ยุฮ ลอป ตอก เซ ซองนา พะจาว. ไล เซ มัฮ โรฮ โกตไม ตอน ฮมัน ละ เปอะ เตือง โม กวน เฌือต เปอะ โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","เกือฮ อาโรน เพรียง ลอป ออม เซ ไม่ อาึง อื ซองนา พะจาว นึง ชวง ออม ป ยุฮ ปุย นึง ไคร ซโน เซ. ");
INSERT INTO lcp_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“ไมจ เปอะ ตุย ญอต แปง ละ ซ โอป แตะ เกือฮ แปน คโนม กาว โรฮ ลอา กอน. คโนมปัง ติ ติ กอน เซ โกว ญอต แปง ละ ปาวน ลิต. ");
INSERT INTO lcp_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ไมจ โรฮ เปอะ อาึง คโนมปัง เซ ซองนา พะจาว นึง ราว โตะ ยุฮ ปุย นึง ไคร ซโน เซ แปน แทว แตะ. เกือฮ ไก ลอา แทว, ติ แทว แลฮ กอน. ");
INSERT INTO lcp_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ฟวยจ เซ อาึง แม กัมยัน ซโน นึง โครยญ แทว อื, เกือฮ แปน ป กู ไม่ คโนมปัง เซ ละ ซ แปน อื ควน ตอง อื ทไว ละ พะจาว ฆรอ คโนมปัง เซ. ");
INSERT INTO lcp_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","อาโรน ไมจ อื อาึง คโนมปัง เซ แปน ไล แตะ ไม่ ทไว อื ละ พะจาว รโตง โม อิซราเอน โครยญ ซเงะ ลโล่ะ, ละ ซ แปน อื ควน โตก ปุย ละ ลปุง ซันญา โอ เญาะ ไก ลอยจ ซน่ะ พะจาว ไม่ ปุย. ");
INSERT INTO lcp_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","คโนมปัง ทไว ปุย เซ แปน โรฮ ป ลัง ละ อาโรน ไม่ กวน เฌือต อื. โฮลฮ โรฮ โซม อื นึง นาตี ซง่ะ ไล ติ โดฮ, นึง มัฮ อื ป เกว ไม่ ป โซม ป ปอน ป ทไว ปุย ละ พะจาว, ไม่ ซง่ะ ซงอม เนอึม แตะ. แปน โรฮ ป ลัง โฮลฮ ลอป จัตเจือ อาโรน ตอก เซ โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","ฟวยจ เซ ไก ปรเมะ ติ ปุย. มะ อื มัฮ โม อิซราเอน, เปือะ อื มัฮ โม อียิป. มอยฮ มะ อื เซ มัฮ เชโลมิต, มัฮ กวน ดิ่บรี. มัฮ ปุย เจอ ด่าน. ปุย เซ โอก โฮว ซน่ะ ลลาึง โม อิซราเอน. โฮว รเจ ไม่ ปรเมะ ไน โม อิซราเอน เซ ติ ปุย นึง ไคะ อาวต อื เซ. ปรเมะ เซ เพียก แฮม มอยฮ พะจาว ไม่ ซะ ซม่อต แตะ พะจาว. ตาว ปุย ฮอยจ เคะ ไอ โมเซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ไอ โมเซ เกือฮ ปุย คัง อาึง ปุย เซ ฆาื อื ฮอยจ ละ ฮมอง ซโตฮ แตะ ป อัฮ พะจาว ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ไมจ เปอะ ตาว ปุย ซะ ซม่อต อาึ เซ, ฮอยจ ก พริ ไคะ. เมาะ โม ป ฮมอง ป อัฮ อื เญือม ซะ ซม่อต อื อาึ เซ, เกือฮ โรฮ ย่อง เตะ แตะ ราว ไกญ ปุย เซ โรฮ. ฟวยจ เซ เกือฮ โม อิซราเอน เตือง โอยจ อื แล่น ปุย เซ นึง ซโมะ ปอ ยุม อื. ");
INSERT INTO lcp_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ฟวยจ เซ ไมจ เปอะ อัฮ ละ ปุย เตือง โอยจ อื เซ ตอก เฮี, ‘ดัฮ ไก ป ซะ ซม่อต พะจาว ยุฮ แตะ, ปุย เซ ซ ลอก ตุต แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ดัฮ ไก ป เพียก แฮม มอยฮ พะจาว เยอ, ปุย เซ ซ ลอก ตุต แตะ ฮอยจ ละ ยุม แตะ. เกือฮ ปุย เตือง โอยจ อื แล่น นึง ซโมะ ปอ ยุม อื, ปัง มัฮ ปุย ตังเมือง ญุ่ก, ปุย ไน โม อิซราเอน ญุ่ก, ดัฮ พลิฮ บึน มอยฮ อาึ โฮ, ซ ลอก ตุต ฮอยจ ละ ยุม แตะ ฆาื อื,’ ไมจ เปอะ อัฮ เซ ละ. ");
INSERT INTO lcp_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ป ยุฮ ยุม ไม่ ปุย ซ ลอก โรฮ ตุต แตะ ฮอยจ ละ ยุม โกะ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ป ยุฮ ยุม ไม่ ซัตซิง ยุฮ ปุย, ไมจ อื โรก นึง ซัตซิง ยุฮ โกะ แตะ โรฮ. ตอก ปุก อื ไล แตะ จีวิต ไมจ โรก นึง จีวิต. ");
INSERT INTO lcp_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ป ยุฮ ไลจ โลม ละ ปุ เญือะ ปุ ย่วง แตะ, ตอก ออฮ ตอก เอีฮ ญุ่ก, ซ ไก โรฮ ป ยุฮ ไลจ โลม ละ โกะ อื ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ซอัง โบวก ฆรอ ซอัง โบวก, ไง่ ฆรอ ไง่, เบียง ฆรอ เบียง. ป ยุฮ ไลจโลม ละ ปุย ตอก ออฮ ไมจ โรฮ ปุย ยุฮ ละ โกะ อื ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ป ยุฮ ไลจ ไม่ ซัตซิง ยุฮ ปุย เยอ, ไมจ อื โรก ตัวแตน อื ละ อื. ป ยุฮ ยุม ไม่ ปุย, เกือฮ โรฮ ปุย ยุฮ ยุม ไม่ โกะ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","ปุย ตังเมือง ไม่ ปุย ไน โม โกะ เปอะ, ไมจ เปอะ โกว โกตไม ตอก ปุ แตะ ละ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","เญือม เซ ไอ โมเซ รโฮงะ เนอึม อื ละ โม อิซราเอน ตอก เซ. โม ปุย โฮวน เซ ตาว ปุย ซะ ซม่อต พะจาว เซ โอก ฮอยจ ก พริ ไคะ ฆาื อื. แล่น อื นึง ซโมะ ปอ ยุม อื. โม อิซราเอน เนอ ยุฮ เนอึม อื ตัม ป รโฮงะ พะจาว ละ ไอ โมเซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ นึง บลาวง ซีไน, ");
INSERT INTO lcp_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, เญือม เอีจ โฮลฮ โม เปะ เลียก อาวต นึง เมือง เกือฮ อาึ ละ เปอะ เซ, เญือม เอีจ ไคว รบี่ เนอึม อาแลฮ ละ เปอะ โครยญ โฮน เนอ, ไมจ เปอะ เกือฮ เตะ ยุฮ แตะ ลโล่ะ ไน เนอึม เซ. ปุ เญาะ ซมา โอเอีฮ นึง เฟือฮ เอิน, ละ ซ แปน อื ควน นัปทื เปอะ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","นึง ชิจ นึง รปึม ยุฮ เปอะ โม เปะ ซ โฮลฮ เปอะ ซมา โอเอีฮ นึง ไม่ รซัฮ เปอะ โคะ อะงุน ยุฮ แตะ ละ เกือฮ เปอะ ติ แตะ โฮลฮ เกป เปลิ อื ตา แลฮ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","เนอึม อาแลฮ นึง อื ปังเมอ มัฮ เนอึม ลโล่ะ. ไมจ เปอะ เกือฮ ปลัฮเตะ อาวต เปอะ เซ ลโล่ะ. เกือฮ แปน เนอึม ลโล่ะ เปอะ ละ พะจาว. ปุ เญือะ ซมา โอเอีฮ นึง ชิจ ยุฮ เปอะ เซ. รปึม อะงุน ยุฮ เปอะ ปุ โรฮ เญือะ รซัฮ. ");
INSERT INTO lcp_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ป กวยฮ อื ไอฮ ปุ ซาวป มัก. กัก อะงุน ยุฮ เปอะ ป ฆอย อื ไอฮ เตือง โอ เปอะ รซัฮ ปุ โรฮ เกป เปลิ อื. เกือฮ แปน เนอึม ลโล่ะ ปลัฮเตะ อาวต เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ปัง มัฮ ตอก เซ, โม เปะ ซ โฮลฮ ลั่ง เปอะ โซม ปอน โอเอีฮ ป ไก นึง ปลัฮเตะ ยุฮ เปอะ เซ เตือง โอ เปอะ ยุฮ กัน นึง, เตือง โกะ เปอะ, ฮอยจ ละ ลุกจัง เปอะ, ครา เซีญ เปอะ ญุ่ก, ปุย ตังเมือง อาวต ไม่ เปอะ ญุ่ก. ");
INSERT INTO lcp_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","เมาะ ป เกิต ไอฮ นึง ปลัฮเตะ เฮี เตือง โอยจ อื ซ เกียฮ แปน ป โซม ละ ปุย โม เซ, ไม่ ละ โกะพริ โกะย่วง เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ไมจ เปอะ เมีญ เนอึม ลโล่ะ เปอะ ป มัฮ เนอึม อาแลฮ เซ ฮอยจ ละ ไคว อื อาแลฮ โฮน. เนอึม ลโล่ะ โฮน อาแลฮ อื เซ แปน เนอึม รปาวน โรฮ ซไตม ฆาื อื ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","เญือม เอีจ ฮาวก เคิ อาแลฮ เซ กาว ซาวม เมอ, ปุก โรฮ ซเงะ รไซจ พะจาว พิต โฌาะ ยุฮ เปอะ. ซเงะ เซ ไมจ เปอะ ปาึง โตวต เกือฮ ลอยฮ เลี่ป เมือง อาวต เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ไมจ เปอะ เมีญ เนอึม รฮอน นึง อื เซ แปน เนอึม ซัมคัน ละ เปอะ ไม่ ครอฮ โรฮ เปอะ ละ ปุย เลี่ป เมือง เกือฮ ฮมอง ตื อื. เกือฮ โรฮ เนอึม เซ แปน เนอึม ลอยฮ เซียง โตวต ละ อื. ไมจ เปอะ เกือฮ ปุย รแม่ พริ เตะ เบระ เบรอึม ละ กุม ไพรม อื. โม ป มัฮ ครา ปุย เยอ, ไมจ โรฮ เปอะ พลวย เกือฮ เอีญ เคะ โกะ เนะ คระ เฌือต แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","เนอึม รฮอน เซ มัฮ เนอึม ลอยฮ เซียง โตวต ละ เปอะ. ไน ติ เนอึม เซ ปุ ซมา โอเอีฮ นึง. เฮงาะ ป กวยฮ อื ไอฮ ปุ โรฮ ซาวป เกป. เปลิ อะงุน ยุฮ เปอะ ป โอก นึง โคะ อะงุน โอ เปอะ รซัฮ เซ, ปุ โรฮ ซาวป เปฮ. ");
INSERT INTO lcp_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","เนอึม ลอยฮ เซียง โตวต เซ มัฮ เนอึม ซัมคัน เนอึม ละ เปอะ. ป ลัง โซม ปอน เปอะ ไน เนอึม เซ, มัฮ ป กวยฮ ไอฮ ละ เปอะ นึง ปลัฮเตะ โน่ง. ");
INSERT INTO lcp_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“เนอึม ลอยฮ เซียง โตวต เซ, ไมจ เปอะ เกือฮ ปุย รแม่ พริ เตะ เบระ เบรอึม ละ กุม ไพรม อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","ดัฮ เปอะ โชะ รวี รปึม ซแก ชิจ โดว เน่อึม นึง ปุ เญือะ ปุ ย่วง แตะ ไมจ เปอะ โตว บ่วก โจวง นึง ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","เญือม รวี ปุย ชิจ โดว เน่อึม นึง ปุ แตะ เกือฮ โชะ อื ตัม เมาะ เลี่ญ เมาะ กลอยฮ เมาะ ซ ฮอยจ แม เนอึม ลอยฮ เซียง โตวต เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ดัฮ เปอะ ซ เตือน ซมา โอเอีฮ นึง เลี่ญ โฮ, งวยฮ อื ตึน ซ เปียง. ดัฮ เปอะ โอ โฮลฮ ซมา โอเอีฮ นึง โฮวน เนอึม โฮ, งวยฮ อื ตึน ซ โทวก ละ เปอะ. ป โชะ เซ ซ โชะ อื ละ เปอะ ตัม เมาะ เลี่ญ เมาะ กลอยฮ ซ โฮลฮ เปอะ ซมา โอเอีฮ นึง. ");
INSERT INTO lcp_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ปุ บ่วก ละ ปุ เปอะ. ไมจ เปอะ ฮลัต นึง พะจาว ยุฮ แตะ นึง มัฮ อาึ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ไมจ เปอะ ยุฮ ตัม ลปุง ซตอก อาึ เปอะ, ไม่ โซะโกะ ฮรักซา เปอะ นึง โกตไม ยุฮ ฮุ โครยญ เจือ. ดัฮ เปอะ ยุฮ ตอก เซ โฮ, ซ โฮลฮ เปอะ อาวต เฮน อาวต ฮลอง ฆาื นึง ปลัฮเตะ ซ อาวต เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ปลัฮเตะ ซ โฮว อาวต เปอะ นึง เซ ซ ลุก ป ซมา ลโลวง นึง ละ เปอะ. ซ โฮลฮ เปอะ อาวต ไม่ ซัก เวียก โกวง โกะ แตะ ไม่ ซ โฮลฮ เปอะ อาวต เฮน อาวต ฮลอง เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","ตึน ซ ไก ง่อน ป อัฮ ตอก เฮี, ‘ดัฮ เอะ โอ โฮลฮ ซมา พักเญือ เฮงาะ รโกะ นึง เนอึม อาแลฮ เซ เฟือฮ โฮ, มัฮ เมอ ป ซ โฮลฮ เอะ โซม ปอน เนอ?’ ตึน ซ อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","อาึ ปังเมอ ซ ปิฮ กุนมุ่น ยุฮ แตะ ละ ป ซมา ลโลวง เปอะ นึง ปลัฮเตะ เฮี ไน เนอึม แลฮ นึง อื เซ, ละ ซ ปอ เอิน อื โซม เปอะ ตา ลอวย เนอึม เอิน. ");
INSERT INTO lcp_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","เญือม เอีจ โฮลฮ โม เปะ ซมา แม เฮงาะ รโกะ ไม่ พักเญือ นึง เนอึม ซเตะ นึง อื เซ, ซ โฮลฮ ลั่ง เปอะ โซม ปอน ป ริ ไพรม แตะ เซ ฮอยจ ละ เฟือฮ เบระ เนอึม ซเตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“โม เปะ เญือม โชะ เปอะ เตะ ยุฮ แตะ ละ ปุ แตะ เกียฮ โชะ ลุต เปอะ โตว, นึง มัฮ อาึ ป มัฮ กุม เตะ เซ. โม เปะ มัฮ โรฮ เปอะ ป ตอก ปุย ตังเมือง ตัง ด่าว, ไม่ ปัว โรฮ เปอะ อาวต ไม่ อาึ. เคียง มัฮ อื ตอก เซ โม เปะ เกียฮ โชะ ลุต เปอะ โตว ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","เญือม โชะ เปอะ เตะ ลโลวง ยุฮ แตะ ละ ปุ แตะ ไน ติ เมือง อาวต เปอะ เซ, ไมจ โรฮ เปอะ เกือฮ ป โชะ เซ เกียฮ โตฮ ลั่ง เตะ เซ เน่อึม นึง ป รวี เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ดัฮ ไก โม เอียกปุ โม อิซราเอน ป โฮลฮ โชะ เตะ ลโลวง ยุฮ แตะ นึง ตุก นึง ญัก แตะ โฮ, ไมจ โรฮ ป มัฮ คระ เฌือต ซดิ ปุย เซ แปน ป โตฮ รโตง อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ดัฮ ปุย เซ โอ ไก คระ เฌือต ละ ซ โตฮ แตะ ละ อื โฮ, กังเคะ เอ ดัฮ ปุย เซ ไก โรฮ โอเอีฮ ยุฮ ปอ ปุน โตฮ แตะ ไอฮ, ");
INSERT INTO lcp_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","เกือฮ โรฮ ปุย เซ เมีญ เมาะ ไก เนอึม อื เน่อึม เญือม โชะ โรง แตะ เตะ เซ, ไม่ กัฮ โรฮ อื งวยฮ อื ละ อื ตัม ลัง กัฮ แตะ ละ ป รวี นึง แตะ เซ, เดอึม เตะ เซ ซ เกียฮ แปน แม คอง อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ดัฮ กุม เตะ เซ โอ ไก โอเอีฮ ยุฮ ละ ซ โตฮ อื เตะ ยุฮ แตะ โฮ, เตะ เอีจ โชะ อื เซ แปน ลั่ง ป ยุฮ ป รวี เซ ฆาื อื ฮอยจ ละ ไคว เนอึม ลอยฮ เซียง โตวต เซ. ดัฮ เอีจ มัฮ เนอึม เซ โฮ, ป รวี เซ ไมจ อื รแม่ เตะ เซ ละ กุม ไพรม อื. เญือม เซ กุม ไพรม อื เซ ซ โฮลฮ แม กุม เตะ ยุฮ แตะ เซ เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ดัฮ ไก ป โชะ เญือะ แตะ, ไม่ อาวต เญือะ อื เซ กไน เวียง เอีจ ไก ฆรุง เงอ, ปุย เซ ลัง โฮลฮ ลั่ง โตฮ อื ไพ ไน เวลา ติ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ดัฮ กุม เญือะ เซ โอ โตฮ เญือะ ยุฮ แตะ เซ ไน ติ เจน เวลา ลัง โตฮ แตะ โฮ, ป รวี เญือะ อาวต กไน เวียง เซ เยอ, ซ ลอต เอิน โฮลฮ เญือะ เซ แปน ลอป คอง แตะ ฆาื อื, ฮอยจ ละ เจน กวนโซะ ลุกลัน อื. เญือะ จัมเปน โตว เกือฮ แม เญือะ เซ ละ กุม ไพรม อื เญือม เอีจ ไคว แม เนอึม ลอยฮ เซียง โตวต เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ดัฮ มัฮ เญือะ นึง ย่วง โอ ไก ฆรุง โฮ, ไมจ อื เมีญ ละ ปุ แตะ ตอก เมีญ แตะ ไลลวง โชะ รวี แตะ เตะ รปึม ซแก โฮ. ลัง โตฮ อื ฮา ปุ แตะ ไม่ ลัง รแม่ โรฮ อื ละ กุม ไพรม อื เญือม เอีจ ไคว เนอึม ลอยฮ เซียง โตวต เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","ปัง มัฮ ตอก เซ, ดัฮ มัฮ เญือะ ย่วง ก อาวต โม เลวี โฮ, โม เลวี เซ ลัง โตฮ คาวคอง เญือะ ม่า แตะ โครยญ เวลา. ");
INSERT INTO lcp_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ดัฮ โม เลวี โชะ เญือะ โชะ ม่า แตะ, ไม่ โอ อื โฮลฮ โตฮ เญือะ ม่า โชะ แตะ เซ, ดัฮ เอีจ ไคว เนอึม ลอยฮ เซียง โตวต เซ, โม ป รวี นึง อื เซ ไมจ อื รแม่ แม ละ โม เลวี เซ, นึง เอีจ มัฮ อื ป โฮลฮ โม เลวี เซ เน่อึม นึง โม อิซราเอน ละ แปน อื คอง อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ดัฮ มัฮ เตะ นา ก เลียง โม เลวี เซ ซัตซิง ยุฮ แตะ นึง โฮ, เกียฮ โชะ เกียฮ รวี โตว อื ละ ปุ แตะ, นึง มัฮ ลอป อื คาวคอง กังมู. ");
INSERT INTO lcp_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ดัฮ เอียกปุ โม อิซราเอน เปอะ อาวต ไม่ ตุก ไม่ ญัก แตะ ปอ โอ อื ปุน เลียง ไอฮ โกะ แตะ โฮ, ไมจ เปอะ เรอึมชวย ตูเตอึม ปุย เซ. เกือฮ อาวต ไมจ อาวต มวน ไม่ เปอะ ตอก อาวต ปุย ตังเมือง ไม่ เปอะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","ปุ คิต ด่อก ไป โอเอีฮ ยุฮ เปอะ ละ ปุย เซ. ไมจ เปอะ ฮลัต นึง พะจาว ยุฮ แตะ, เดอึม เอียกปุ เปอะ เซ ซ เกียฮ อาวต ไม่ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","เญือม รมะ อื มาื ยุฮ เปอะ ปุ คิต ด่อก อื ละ อื. ดัฮ รโตว ป โซม ป ปอน นึง เปอะ ปุ โรฮ คิต ด่อก อื นึง อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ. มัฮ โรฮ ป นัม โม เปะ โอก ฮา เมือง อียิป, ละ ซ เกือฮ แตะ เมือง คะนาอัน ละ เปอะ ไม่ ซ แปน โรฮ พะจาว ยุฮ เปอะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ดัฮ เอียกปุ โม อิซราเอน เปอะ อาวต ไม่ ตุก ไม่ ญัก แตะ ปอ ปัว อื โชะ ติ แตะ ละ เปอะ ละ ซ ยุฮ อื กัน ละ เปอะ, ปุ เกือฮ แปน ครา เปอะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","เกือฮ อาวต ไม่ เปอะ ตอก อาวต ลุกจัง ปุย โฮ. เกือฮ ยุฮ กัน ละ เปอะ ฮอยจ ละ ฮอยจ เนอึม ลอยฮ เซียง โตวต เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","เญือม เอีจ ฮอยจ อื เนอึม เซ เยอ, เกือฮ ปุย เซ ไม่ กวน เฌือต อื โอก เอีญ ฮา เปอะ ฮอยจ เญือะ โกะ แตะ, ฮอยจ เคะ เอียกปุ ตุเจอ แตะ, ไม่ พริ เตะ เบระ เบรอึม ยุฮ จัตเจือ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","โม อิซราเอน เตือง โอยจ อื เอีจ มัฮ กวนไจ ยุฮ พะจาว, ไม่ เอีจ นัม พะจาว อื เกือฮ โอก ฮา เมือง อียิป. เญือะ ลัง มัฮ โตว ครา เซีญ ปุย ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ปุ คนัป กัปกา. ไมจ เปอะ ฮลัต นึง พะจาว ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ดัฮ เปอะ ฆวต ไอฮ ปุย เกือฮ แปน ครา แตะ โฮ, ไมจ เปอะ รวี นึง ปุย ตังเมือง ป อาวต รวิต รเวียง เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","ปัง มัฮ ปุย ตังเมือง ป เอีจ อาวต นึง เมือง เปอะ เซ ญุ่ก, กวน เฌือต อื ญุ่ก แปน โรฮ, นึง เอีจ มัฮ โรฮ อื ปุย เกิต นึง เมือง อาวต เปอะ. โม เซ ซ เกีอฮ แปน คอง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ดัฮ เปอะ ดุฮ เอิน นึง นังซื พิไนกัม ละ กวน เฌือต แตะ, ดัฮ เปอะ มอป ละ กวน แตะ เญือม เอีจ ซ ยุม แตะ ละ เกือฮ เปอะ แปน ลอป คอง อื, ละ ซ เกือฮ เปอะ ยุฮ กัน ละ แตะ, เกียฮ ยุฮ โรฮ เปอะ. ละ โม ป มัฮ เอียกปุ โม โกะ เปอะ ไน โม อิซราเอน เนอ, ปังเมอ โอ ไมจ คนัป กัปกา ไม่ ยุฮ เปอะ ครา แตะ นึง ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ดัฮ ปุย ตังเมือง ฮอยจ อาวต ไม่ เปอะ เซ กอย ยุฮ แตะ, ไม่ ตุก โรฮ ป มัฮ เอียกปุ โม อิซราเอน เปอะ ป อาวต ไม่ โกะ เปอะ เซ ฮา ไพรม แตะ, ปอ โชะ อื ติ แตะ ละ ซ ญอม อื แปน ครา ปุย ตังเมือง เซ ญุ่ก, แปน ครา คระ เฌือต อื ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ไมจ โรฮ อื ไก ซิต ละ ซ เกียฮ โตฮ แม อื ติ แตะ. ไมจ เอียกปุ ซดิ อื โตฮ. ");
INSERT INTO lcp_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ป โตฮ เซ ปัง มัฮ เอียกปุ ออฮ เอีฮ อื ญุ่ก, ปัง มัฮ ยะ ตุ ติญ อื, กวน รนัน อื ญุ่ก แปน ตื. ดัฮ โกะ อื ไก โอเอีฮ ยุฮ ปอ ปุน โตฮ อื ติ แตะ โฮ, ปัง โตฮ ไอฮ ติ แตะ แปน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","เกือฮ ปุย โชะ ติ แตะ เซ คิต ไอฮ ไม่ ป รวี แตะ เซ เมาะ เอีจ เลี่ญ โชะ อื ติ แตะ ไม่ เมาะ เอีจ ซ ฮอยจ เนอึม ลอยฮ เซียง โตวต เซ. งวยฮ โตฮ อื ติ แตะ เซ ไมจ อื คิต ตัม เมาะ ไก เนอึม เอีจ อาวต แตะ ไม่ ป รวี แตะ เซ. ไมจ อื คิต งวยฮ อื ตัม ป คิต ปุย ละ ลุกจัง ไฮญ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ดัฮ เวลา ลัง อาวต อื เซ เลี่ญ ลั่ง เนอึม โฮ, ไมจ อื คิต ตัม เมาะ เลี่ญ ลั่ง เนอึม ลัง โฮลฮ แตะ อาวต เซ. มัฮ เมาะ เซ เมาะ ไมจ อื โตฮ ติ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ดัฮ โอ เญือะ เลี่ญ โฮ ซ ฮอยจ อื ละ เนอึม ลอยฮ เซียง โตวต เซ, ปุย เซ ซ คิต เมาะ เลี่ญ เมาะ กลอยฮ ลั่ง อื ไม่ โตฮ อื ติ แตะ ตัม เซ. ");
INSERT INTO lcp_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","เญือม เอีจ ซ โอก อื เกือฮ ปุย คิต งวยฮ อื ตอก ลุกจัง ป อาวต แปน เนอึม อื โฮ. ปุ เกือฮ ป มัฮ ปอเลียง อื เซ โคมเฮง ไม่ คาเคียน แตะ ปุย เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ดัฮ โอ ไก ป โตฮ ไม่ โอ อื ปุน โตฮ ไอฮ ติ แตะ โฮ, ไมจ เญือะ ป รวี เซ พลวย เญือม เอีจ ฮอยจ อื ละ เนอึม ลอยฮ เซียง โตวต เซ. ไมจ โรฮ อื พลวย ไม่ กวน อื. ");
INSERT INTO lcp_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","โม อิซราเอน เนอ เกียฮ แปน ลอป โตว ครา ปุย, นึง เอีจ มัฮ อื กวนไจ ยุฮ อาึ ไม่ เอีจ นัม โรฮ โฮะ เกือฮ โอก ฮา เมือง อียิป. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","พะจาว อัฮ เฮี, “ปุ ยุฮ ฮุป ละ ซ ไว เปอะ นึง ปลัฮเตะ อาวต เปอะ เซ. ฮุป ลวน ปุย ญุ่ก, ฮุป ปอยจ ปุย นึง ซโมะ ญุ่ก. ปุ โรฮ โบลวง ซกัง เงอ ไม่ โอเอีฮ ตอก เซ ละ ซ ทื เปอะ นึง มัฮ อาึ เยโฮวา พะจาว ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ไมจ เปอะ โซะโกะ ฮรักซา นึง ซเงะ ลโล่ะ ยุฮ ฮุ โครยญ ซเงะ ลโล่ะ. ไมจ โรฮ เปอะ นัปทื พากัง ซัมคัน ยุฮ ฮุ. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ดัฮ โม เปะ ยุฮ ตัม ลปุง ซตอก อาึ แตะ, ไม่ โซะโกะ ฮรักซา เปอะ นึง โกตไม ยุฮ ฮุ, ไม่ ยุฮ โรฮ เปอะ ตัม เซ, ");
INSERT INTO lcp_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","อาึ ซ ตาว รอาวม เฮละ ละ เปอะ ตัม เวลา ลัง เฮละ อื, ซ เกือฮ โรฮ ป ซมา ลโลวง เปอะ กวยฮ นึง ปลัฮเตะ อาวต เปอะ, ไม่ ซ เกือฮ โรฮ โฮะ โคะ นึง รปึม ซแก ยุฮ เปอะ ไก เปลิ ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","เญือม เอีจ เติง เวลา ยุฮ เฮงาะ, ซ โฮลฮ เปอะ ยุฮ เฮงาะ ยุฮ แตะ เลี่ญ ฮอยจ ละ ไมจ แม เปอะ เปฮ เปลิ อะงุน. เญือม เอีจ เปฮ แม เปอะ เปลิ อะงุน เนอ, ซ โฮลฮ แม โรฮ เปอะ เปฮ เลี่ญ ฮอยจ ละ เมือ วัน ปุย เฮงาะ แม. ซ โฮลฮ เปอะ อาวต ไม่ ซัก เวียก โกวง โกะ แตะ, ไม่ ซ โฮลฮ เปอะ อาวต เฮน ฮลอง นึง ปลัฮเตะ เซ เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“อาึ ซ เกือฮ ปลัฮเตะ อาวต เปอะ เฮน ฮลอง. ซ โฮลฮ เปอะ โซม ญึม ไอจ ไมจ. ไก โตว ป ซ เกือฮ เปอะ ฮลัต เตีจ ติ เจือ เนอึม. อาึ ซ ยุฮ โรฮ ไลจ ไม่ ป กุก ป เกียต นึง ปลัฮเตะ อาวต เปอะ. ป ซ ฮอยจ ตอซู ไม่ เปอะ ปุ โรฮ ซ ไก. ");
INSERT INTO lcp_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","โม เปะ ซ ปุน เป ซไบ่ เนอึม เปอะ โม ป ฮอยจ ตอซู ไม่ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","ปุย ไน โม เปะ พอน ปุย เยอ ซ ปุน ตอซู ป ฮอยจ รุป ไม่ แตะ แปน รอย อื. ปุย ไน เปอะ ติ รอย ปุย เยอ, ซ ปุน เลียก โครฮ เปอะ ปุย แปน ฮมาึน อื. ");
INSERT INTO lcp_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“อาึ ซ โตก ลอป ละ โม เปะ, ซ เบีย โตว ป ซันญา แตะ ละ เปอะ. ซ เกือฮ โรฮ จัตเจือ เปอะ พรุฮแพร. ");
INSERT INTO lcp_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ป ริ ป ฮา เปอะ ซ โฮฮ ฮา โซม ฮา ปอน เปอะ. เญือม เอีจ โฮลฮ เปอะ เกป ป ซมา โคระ เปอะ เซ, ซ โฮลฮ เอิน เปอะ ฮอย ป ไพรม อื เซ ละ ซ ดุฮ เปอะ ป โฮลฮ โคระ เปอะ เซ นึง. ");
INSERT INTO lcp_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","อาึ ซ อาวต ซน่ะ ลลาึง เปอะ นึง พากัง ซัมคัน ยุฮ แตะ. ซ เกือฮ โตว ติ แตะ เตือ นึง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","อาึ ซ อาวต ลอป ไม่ เปอะ ไม่ ซ แปน พะจาว ยุฮ เปอะ. โม เปะ ซ แปน โรฮ เปอะ ปุย ยุฮ อาึ. ");
INSERT INTO lcp_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ, ป นัม โม เปะ โอก ฮา เมือง อียิป ละ ซ โอ เปอะ เญือะ โฮลฮ แปน ครา ปุย. อาึ เอีจ เฟือก โรฮ แอก ยุฮ เปอะ ละ ซ เกือฮ โรฮ โม เปะ โฮว ซไบ่ นึง. ");
INSERT INTO lcp_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“โม เปะ ดัฮ เปอะ โอ เนอึง ป อัฮ อาึ, ไม่ โอ เปอะ ยุฮ ตัม โกตไม ยุฮ ฮุ เฮี, ปังเมอ ซ ลอก เปอะ ตุต แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","โม เปะ ดัฮ เปอะ เตือ นึง ลปุง ซตอก อาึ แตะ, ไม่ โอ แตะ ยุฮ ตัม โกตไม ยุฮ อาึ เตือง โอยจ อื โฮ, เอีจ มัฮ โรฮ ยุฮ เปอะ ไลจ ไม่ ลปุง ซันญา ยุฮ อาึ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","อาึ ซ เกือฮ โม เปะ ลอก ตุต แตะ. ซ พลวย โรฮ ป โตะ ป ตอง ฮอยจ ละ เปอะ, ไม่ ป โซะ ป คระ โฮวน เจือ, ซ เกือฮ โม เปะ จัก ไง่ ไพ เตะ ไม่ ตุก เญือะ รเกือะ โกะ เปอะ. ปัง ซมา เปอะ เฮงาะ, ซ ฮอยจ ตุย โม ป เกละยุ เปอะ เซ โซม ฮา เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","อาึ ซ วุต ติ แตะ ฮา เปอะ. ซ เกือฮ เปอะ ไป นึง โม ป ฮอยจ ตอซู ไม่ แตะ. ซ โฮลฮ เปอะ อาวต ฆรึม อัมนัต โม ป เกละยุ แตะ เซ. โม เซ ซ โฮลฮ ตัตเตียง โม เปะ. โม เปะ ซ ฮลัต เตีจ เปอะ, ซ ตอ เปอะ เตือง โอ แตะ ไก ป อาื. ");
INSERT INTO lcp_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ดัฮ โม เปะ โอ ลั่ง ดิ เนอึง ป อัฮ อาึ เตือง เอีจ เกิต โอเอีฮ ตอก เซ ละ แตะ โฮ, อาึ ซ เกือฮ เปอะ ลอก ตุต โฮวน ฮา ไพรม แตะ แปน อาแลฮ เตะ เอิน. ");
INSERT INTO lcp_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","อาึ ซ ยุฮ ไลจ ไม่ อัมนัต อานา โม เปะ ฆาื รพาวม ลึง เปอะ เซ. เญือะ ซ เฮละ โตว พริ ละ เปอะ. ปลัฮเตะ ไม่ มะลอง ซ กอ ละ เปอะ ตอก กอ ไร โฮ. ");
INSERT INTO lcp_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","โม เปะ ซ โปวฮ เยือ เปอะ เรียง แด่น แตะ นึง ยุฮ แตะ กัน, นึง โอ ปลัฮเตะ เฮี เญือะ กวยฮ โอเอีฮ นึง. โคะ ป เอีจ กวยฮ นึง อื ปุ เญือะ ซ ไก เปลิ ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“โม เปะ ดัฮ เปอะ เลฮ ลั่ง เตียง อาึ ไม่ โอ เปอะ ง่อต ป อัฮ อาึ ละ แตะ โฮ, อาึ ซ เกือฮ แม ป โตะ ป ตอง เกิต ละ เปอะ โฮวน ฮา ไพรม แตะ อาแลฮ เตะ, ฆาื มั่ป พิต เอีจ ยุฮ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","อาึ ซ พลวย โรฮ โกะพริ ซวก เกือฮ ฮอยจ อาวต ซน่ะ ลลาึง เปอะ. ซ เกือฮ โรฮ เกียต กุก กวน เฌือต เปอะ, ไม่ ซ ยุฮ อื ไลจ ไม่ คอง เลียง เปอะ. โม เปะ ซ แปน เปอะ ปุย รมัฮ ปุๆ คระ โฮว โครง เอีญ เปอะ ซ รงัม รมอง. ");
INSERT INTO lcp_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“โม เปะ ดัฮ ลั่ง เปอะ โอ ดิ เอีญ แม เคะ อาึ เตือง เอีจ เพอึก เอีจ เฟียต อาึ แตะ เมาะ เซ โฮ, ไม่ เลฮ ลั่ง เปอะ เตียง ป อัฮ ฮะ, ");
INSERT INTO lcp_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","อาึ ซ ตอซู ไม่ โม เปะ, ไม่ ซ เฟียต แตะ โม เปะ เกือฮ โซะ ฮา ไพรม แตะ ฆาื มั่ป พิต ยุฮ เปอะ เซ อาแลฮ เตะ แม. ");
INSERT INTO lcp_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","อาึ ซ ตาว โรฮ กัน รุป เซิก ฮอยจ ละ เปอะ ฆาื ไลจ เปอะ ยุฮ ลปุง ซันญา แตะ ไม่ อาึ. โม เปะ ปัง เคียต เปอะ ตอ โฮว เปิง ดิ เมือง ระ ยุฮ เปอะ ละ ซ เกือฮ เปอะ ติ แตะ โปน ฮา กัน รุป เซ, อาึ ปังเมอ ซ เกือฮ ลั่ง พาญัต ฆอก เกิต ลลาึง เปอะ นา เซ. ซ จัมเปน เปอะ ญอม ไป นึง โม ป ฮอยจ รุป ไม่ เปอะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","เญือม ยุฮ อาึ ไลจ ไม่ เฮงาะ รโกะ ยุฮ เปอะ เซ, ปรโปวน กาว ปุย เยอ, ซ โอป คโนมปัง ยุฮ แตะ นึง ตาว โอป ติ โน่ง นึง รมัฮ ลอน คโนมปัง ยุฮ อื. ซ จัมเปน เปอะ แฆ รฆุ โซม คโนมปัง เซ ไม่ ปุ แตะ ติ ปุย เญี่ยะๆ, ปังเมอ โอ ซ ปอ ซัก เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“เญือม เอีจ ยุ เปอะ ฮอยจ ป ญัก ละ แตะ ตอก เซ เยอ, โม เปะ ดัฮ ลั่ง เปอะ โอ เนอึง ป อัฮ อาึ, ไม่ ยุฮ เปอะ ป โอ ปุก รพาวม เมอะ โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","อาึ ซ ยุฮ โรฮ ป โอ ปุก รพาวม โม เปะ โรฮ, ไม่ ซ เปลีฮ แตะ รพาวม ฮาวก แตะ ละ เปอะ. ซ เกือฮ โรฮ โม เปะ ลอก ตุต แตะ ฆาื มั่ป พิต ยุฮ เปอะ อาแลฮ เตะ แม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","โม เปะ ซ ไปลญ เออึป เนอึม เปอะ ฮอยจ ละ โฮลฮ เปอะ กุก เนะ กวน รเมะ กวน รโปวน โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","อาึ ซ ยุฮ ไลจ ไม่ คัน อาวต นึง นาตี ฮลาวง ยุฮ เปอะ เซ. ซ เญื่อฮ โรฮ คัน ทไว เปอะ ป ซออย ฮงาื โรฮ. เญือม เอีจ ยุม เปอะ ซ เกือฮ เนะซอัง เปอะ อาวต เฮีย อาวต ไฮ ลลาึง ฮุป เอีจ ไลจ เอีจ เญื่อฮ ยุฮ เปอะ เซ. อาึ ซ รแอม ลัมเลือ นึง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","อาึ ซ เกือฮ โรฮ เมือง อาวต เปอะ เซ ฮัง เยือ, ไม่ ซ เกือฮ โรฮ ก ฮาวก ไว เปอะ พะจาว ทื แตะ เซ ม่าวง. ป ทไว เปอะ ละ อาึ เซ, อาึ ปุ โรฮ เญือะ ซ รัป โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","อาึ ซ เกือฮ โรฮ ปลัฮเตะ อาวต เปอะ เซ ฮัง ไม่ ซ เกือฮ โรฮ แพะ แลง โรฮ. ซ เกือฮ โรฮ โม ป รุป ไม่ เปอะ ป ลอต อาวต นึง เมือง เปอะ เซ เงอึต ฆาื. ");
INSERT INTO lcp_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","อาึ ซ เกือฮ โรฮ กัน รุป เซิก ฮอยจ ละ เปอะ ไม่ โครฮ อื โม เปะ โฮว อาวต เฮีย ไฮ ติ แตะ นึง เมือง ปุย ไฮญ. ปลัฮเตะ อาวต เปอะ เซ ซ ม่าวง. ย่วง อาวต เปอะ ซ ฮัง เยือ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","เญือม โฮลฮ โม เปะ ตอ โฮว อาวต นึง เมือง ป ฮอยจ รุป ไม่ เปอะ เซ, ปลัฮเตะ อาวต โม โกะ เปอะ ซ อาวต เยือ นึง เซ. ซ แปน เนอึม ลโล่ะ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ไน ติ เจน โฮลฮ เปอะ โฮว ฮา เซ ปลัฮเตะ เซ ซ โฮลฮ ลโล่ะ. มัฮ ฆาื โอ อื โฮลฮ ลโล่ะ เญือม อาวต โม เปะ นึง โฮ. ");
INSERT INTO lcp_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“เญือม เซ โม เปะ ป ไอม ลั่ง เงอ ป ซ อาวต นึง เมือง ปุย โม เซ, ซ อาวต เนอึม เปอะ ไม่ ฮลัต เตีจ แตะ. ปัง มัฮ เมาะ ฮมอง เปอะ ลอยฮ ฮละ โคะ ปอย กาื, โม เปะ ซ ตอ เปอะ ฆาื. ซ ตอ เปอะ ตอก ตอ ปุย ฮา วิจ ฮา เพลียฮ โฮ. ซ ตอ เปอะ ปอ ฆลาื แตะ เตือง โอ แตะ ไก ป อาื. ");
INSERT INTO lcp_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","โม เปะ ซ โคะ ซด่อยฮ เอิน เปอะ ปุ แตะ ไอฮ, ตอก ตอ ปุย ฮา วิจ นึง อาื ปุย มอก แตะ โฮ, เตือง โอ แตะ ไก ป อาื มอก เฟือฮ. ซ ไก เปอะ โตว เรียง แด่น ละ ซ ปุน ตอซู แตะ ไม่ ป ฮอยจ รุป ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","โม เปะ ซ ยุม เปอะ ซน่ะ ลลาึง ปุย เมือง ไฮญ ป เกละยุ เปอะ เซ. ปลัฮเตะ โฮลฮ เปอะ โฮว อาวต นึง เซ ซ แปน ป ไลจ ยุฮ โม เปะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","โม เปะ เมาะ โฮฮ ลั่ง เปอะ เซ, ซ อาวต เปอะ ไม่ ตุก เญือะ รเกือะ โกะ แตะ ฆาื มั่ป พิต ยุฮ แตะ เซ. มัฮ โรฮ ฆาื มั่ป พิต ยุฮ จัตเจือ ไพรม เปอะ เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","“ป โอ อาึ เญือะ โซะโกะ ฮรักซา นึง อื, ไม่ เกือฮ โรฮ โฮะ โฮลฮ โฮว อาวต นึง เมือง ป ฮอยจ รุป ไม่ อื เซ, มัฮ ฆาื โอ อื เนอึม รพาวม ละ อาึ ไม่ เลฮ อื เตียง ป อัฮ ฮะ. ปัง มัฮ ตอก เซ, เฆียง เฮี ดัฮ จัตเจือ เปอะ ญอม รโซะ มั่ป พิต ยุฮ โกะ แตะ, ไม่ ญอม โรฮ อื รโซะ มั่ป พิต ยุฮ จัตเจือ ไพรม แตะ โฮ, อาึ ซ ไตม ลั่ง ลปุง ซันญา ไพรม ยุฮ แตะ. เญือม เซ ดัฮ ญอม เนอึม เกือฮ รพาวม รโม่ยฮ แตะ ตุเตียม ไม่ ญอม อื รัป มั่ป พิต ยุฮ แตะ เซ โฮ, ");
INSERT INTO lcp_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","อาึ ซ เกือฮ ติ แตะ โตก ละ ลปุง เอีจ ซันญา แตะ ไม่ ยาโคป ไม่ ยิซฮัก ไม่ อัปราฮัม โรฮ. อาึ ซ โตก โรฮ ละ ปลัฮเตะ อาวต ไพรม อื เซ. ");
INSERT INTO lcp_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","อาึ ปังเมอ ซ ละ ลั่ง ปลัฮเตะ เซ ละ ซ เกือฮ ปลัฮเตะ เซ ไก ลั่ง เนอึม ลโล่ะ นึง ตัม ลัง ไมจ อื ลโล่ะ. ซ เกือฮ ม่าวง เยือ เตือง โอ อื ไก ป อาวต นึง. ไมจ โม เซ ลอก ตุต แตะ ฆาื พิต โฌวะ ยุฮ อื เซ, ฆาื เตือ ออป อื นึง โกตไม ยุฮ อาึ, ไม่ เกือฮ อื รพาวม รโม่ยฮ แตะ เกละยุ ลปุง ซตอก อาึ แตะ. ");
INSERT INTO lcp_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ปัง มัฮ ตอก เซ อาึ เตือ โตว นึง โม โกะ อื. เญือม อาวต อื นึง เมือง ป ฮอยจ รุป ไม่ แตะ เซ, อาึ ซ เกละ โตว ยุ ปอ ยุฮ แตะ ยุม ไม่ เตือง โอยจ อื. อาึ ซ ยุฮ โตว โรฮ ไลจ ไม่ ลปุง เอีจ ซันญา แตะ ไม่ อื, นึง มัฮ อาึ เยโฮวา พะจาว ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","มัฮ ฆาื ฮรัก เกอะ โม เซ. มัฮ เซ ป ซ โตก อาึ ละ ลปุง เอีจ ซันญา แตะ อาึง ละ จัตเจือ ไพรม อื ป เอีจ นัม เมอะ เกือฮ โอก ฮา เมือง อียิป ซองนา ปุย เมือง ไฮญ โฮ, ละ ซ แปน อาึ พะจาว ยุฮ อื. อาึ มัฮ เยโฮวา,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","เมาะ โอเอีฮ โม เซ เตือง โอยจ อื มัฮ ลปุง ซตอก พะจาว อาึง ไม่ โกตไม ยุฮ อื. เอีจ มัฮ ป เกือฮ พะจาว ละ ไอ โมเซ นึง บลาวง ซีไน โฮ. มัฮ เกือฮ อื ซึป ไลลวง เซ ละ โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ไมจ เปอะ รโฮงะ ละ โม อิซราเอน ตอก เฮี, ‘ดัฮ ไก ปุย ซันญา ซ ทไว พิเซต ปุย ละ พะจาว เยอ, ไมจ ปุย ตี งวยฮ อื เดอึม ซ เกียฮ โตฮ ปุย ทไว แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ไล โตฮ อื เซ มัฮ ตอก เฮี. ปรเมะ อาญุ เน่อึม นึง ง่า เนอึม ฮอยจ ละ ลแฆลฮ เนอึม เมอ, ไมจ เปอะ ตี งวยฮ อื รฮอน เชเคน ตัม มาื เชเคน เมีญ ปุย นึง พากัง ระ. ");
INSERT INTO lcp_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ดัฮ มัฮ ปรโปวน โฮ, ไมจ เปอะ ตี งวยฮ อื ง่วย เชเคน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ดัฮ มัฮ ปุย ไก อาญุ พอน เนอึม ฮอยจ ละ อาญุ ง่า เนอึม โฮ, ปรเมะ เอ ตี งวยฮ อื ง่า เชเคน. ดัฮ มัฮ ปรโปวน โฮ ตี งวยฮ อื กาว เชเคน. ");
INSERT INTO lcp_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ปุย ไก อาญุ ติ เคิ ฮอยจ ละ อาญุ พอน เนอึม เมอ, ปรเมะ นึง อื ตี งวยฮ อื พอน เชเคน. ดัฮ มัฮ ปรโปวน โฮ, ตี งวยฮ อื ลอวย เชเคน. ");
INSERT INTO lcp_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ดัฮ มัฮ ปุย เอีจ ไก อาญุ ลแฆลฮ เนอึม ฮาวก โฮ, ปรเมะ นึง อื ตี งวยฮ อื กาว โรฮ พอน เชเคน. ดัฮ มัฮ ปรโปวน โฮ, ตี งวยฮ อื กาว เชเคน. ");
INSERT INTO lcp_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ดัฮ ไก ปรเมะ ป อาวต ไม่ ตุก ไม่ ญัก แตะ, ไม่ มัฮ อื ปุย เอีจ ซันญา ปุย ซ ทไว แตะ ละ พะจาว, ดัฮ ปุย เซ โอ โฮลฮ กัฮ งวยฮ แตะ ตัม ลัง เกือฮ แตะ เซ, ไมจ ปุย โฮว ตาว ปุย เซ ฮอยจ เคะ ซตุ. เกือฮ ซตุ เซ ตี งวยฮ ปุย เซ ตัม เมาะ โซมกวน อื ไม่ เมาะ ซ ปุน เกือฮ เนอึม ปุย เซ อื.’ ” ");
INSERT INTO lcp_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ดัฮ มัฮ ซัตซิง ป ซันญา ปุย ละ ซ ทไว แตะ ละ พะจาว เซ, โอเอีฮ เมาะ ป ฮอยจ ทไว ปุย ละ พะจาว เตือง โอยจ อื เอีจ แปน ตื คอง พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ปุ เกือฮ ปุย เปียน ป ตะ แตะ ทไว เซ ไม่ โรวก อื โอเอีฮ ไฮญ รโตง อื. โอเอีฮ ไมจ เจอ, ปุ เปียน แปน ป โอ ไมจ. ป โอ ไมจ เจอ, ปุ โรฮ เปียน แปน ป ไมจ โรฮ. ดัฮ ไก ป เปียน ป ทไว แตะ เซ, ซ แปน เอิน คอง พะจาว ฆาื อื เตือง ลอา อื. ");
INSERT INTO lcp_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ดัฮ ไก ป โรวก ทไว ซัตซิง โอ ซง่ะ ไล เตือง โอ แตะ ลัง โรวก ทไว ละ พะจาว โฮ, เกือฮ โรฮ ปุย เซ โรวก ซัตซิง เซ ฮอยจ ละ ซตุ. ");
INSERT INTO lcp_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ซตุ เซ ซ ตี โรฮ งวยฮ อื ตัม เมาะ ไมจ เมาะ ฆอก อื โรฮ. ตี ซตุ เซ งวยฮ อื เมาะ ออฮ งวยฮ อื มัฮ เนอึม เมาะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ดัฮ ไก ป ฮอยจ โตฮ ซัตซิง โอ ซง่ะ ไล ป ฮอยจ ทไว แตะ ละ พะจาว เยอ, ไมจ แม อื บุ งวยฮ ป ทไว แตะ เซ ง่า เปอเซน แม. ");
INSERT INTO lcp_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ดัฮ ไก ป ทไว เญือะ แตะ ละ ซ เกือฮ อื แปน เญือะ ยุฮ พะจาว โฮ, ไมจ โรฮ ซตุ ตี งวยฮ เญือะ เซ ตัม เมาะ ไมจ เมาะ ฆอก อื. ตี ซตุ เซ งวยฮ อื เมาะ ออฮ, งวยฮ อื มัฮ เนอึม เมาะ เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ดัฮ แม ปุย เซ ฆวต โตฮ เญือะ แตะ เซ โฮ, เกือฮ แม บุ งวยฮ เญือะ แตะ เซ ง่า เปอเซน โรฮ. ฟวยจ เซ เญือะ เซ ซ แปน แม คอง โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ดัฮ ปุย ทไว เตะ ลโลวง ยุฮ แตะ ละ พะจาว โฮ, ไมจ เปอะ ตี งวยฮ อื ตัม เมาะ โอยจ เฮงาะ ซมา นึง เตะ ยุฮ แตะ เซ. ดัฮ มัฮ เตะ โอยจ เฮงาะ บ่าเล ติ โฮเมอ เญือม ซมา ปุย อื เซ, ไมจ เปอะ ตี งวยฮ อื รฮอน เชเคน. ");
INSERT INTO lcp_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ดัฮ ปุก เนอึม ลอยฮ เซียง โตวต โฮ เญือม ทไว อื เซ, ไมจ เปอะ ตี งวยฮ อื ละ อื เตม, ตัม คาโนวน ตี ปุย อื. ");
INSERT INTO lcp_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ดัฮ ทไว เตะ ยุฮ แตะ ฟวยจ เนอึม ลอยฮ เซียง โตวต เซ โฮ, ไมจ ซตุ ง่อต เมาะ เลี่ญ เมาะ กลอยฮ ซ ไคว แม เนอึม เซ แม ติ โฮน. คิต แม โรฮ งวยฮ อื ละ อื ตัม เมาะ เลี่ญ เมาะ กลอยฮ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ป เอีจ ทไว เตะ ลโลวง ยุฮ แตะ ละ พะจาว เยอ, ดัฮ ฆวต โตฮ แม เตะ เอีจ ทไว แตะ เซ โฮ, ไมจ โรฮ เปอะ เกือฮ บุ แม งวยฮ เตะ เซ ง่า เปอเซน โรฮ. ฟวยจ เซ เตะ เซ ซ แปน แม คอง ปุย เซ ตอก ไพรม อื. ");
INSERT INTO lcp_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ดัฮ ปุย เซ โอ แปน โตฮ, ไม่ โชะ แม อื เกือฮ ปุย ไฮญ ริ โซม นึง ญุ่ก, เญือะ เกียฮ โตฮ โตว อื เฟือฮ. ");
INSERT INTO lcp_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","เญือม เอีจ ฮอยจ อื ละ เนอึม ลอยฮ เซียง โตวต เซ, เตะ เซ ซ แปน ลอป คอง พะจาว ฆาื อื, นึง มัฮ อื คอง ทไว ปุย ละ อื. เตะ เซ เอีจ แปน โรฮ คาวคอง ยุฮ โม ซตุ เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ดัฮ ไก ป รวี เตะ ลโลวง เตือง โอ อื มัฮ คาวคอง ไพรม ยุฮ อื, ไม่ ทไว อื ละ พะจาว, ");
INSERT INTO lcp_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ไมจ ซตุ เซ ตี โรฮ งวยฮ อื ตัม เมาะ เลี่ญ ซ ฮอยจ อื ละ เนอึม ลอยฮ เซียง โตวต เซ. เญือม เอีจ ไคว อื ฮอยจ ละ เนอึม เซ, ซเงะ โรง นึง อื, ป มัฮ กุม เตะ เซ ไมจ อื ทไว มาื งวยฮ เตะ ยุฮ แตะ เซ ละ พะจาว ตัม เมาะ ปุก เมาะ ลอก อื ตอก อัฮ ซตุ อื ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","เญือม เอีจ ไคว อื ฮอยจ ละ เนอึม ลอยฮ เซียง โตวต เซ, เตะ เซ แม แปน แม คอง กุม ไพรม อื เซ ตอก ไพรม อื. ");
INSERT INTO lcp_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","เมาะ โอเอีฮ ตี ปุย งวยฮ อื, ไมจ อื ตี ตัม งวยฮ มาื เชเคน ป อาึง ปุย นึง พากัง ระ เซ. ง่า เกรา เซ มัฮ ติ เชเคน. ");
INSERT INTO lcp_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“กวน โรง ซัตซิง ยุฮ ปุย โครยญ ตัว อื เญือะ ไมจ โตว ปุย ซันญา อาึง ละ ซ ทไว แตะ ละ พะจาว, นึง เอีจ ตึน มัฮ อื คอง พะจาว. โมวก, แกะ, ปิ ญุ่ก, เอีจ มัฮ ตื คอง พะจาว ตื. ");
INSERT INTO lcp_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ดัฮ มัฮ ซัตซิง โอ ซง่ะ ไล โฮ, ดัฮ กุม อื ฆวต โตฮ แม โฮ, ไมจ อื โตฮ ตัม เมาะ งวยฮ ตี โม ซตุ อื ละ อื, ไม่ บุ โรฮ อื งวยฮ อื ง่า เปอเซน. ดัฮ ปุย เซ โอ เญือะ โตฮ, ไมจ โม ซตุ โชะ ตัม เมาะ โซมกวน อื ไม่ งวยฮ อื. ");
INSERT INTO lcp_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“โอเอีฮ ป ทไว ลุต ปุย ละ พะจาว เยอ, เญือะ เกียฮ โตฮ โตว ปุย. ปัง มัฮ ปุย, ปัง มัฮ ซัตซิง, ฮอยจ ละ พริ เตะ เบระ เบรอึม, โอเอีฮ โม เซ เอีจ มัฮ ลอป คอง พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ดัฮ ไก ปุย ป เอีจ มอป ปุย ละ พะจาว ละ ซ ยุฮ ปุย ไลจ ไม่ โฮ, เญือะ ไก โตว ป เกียฮ โตฮ ปุย เซ เยอ. ไมจ ปุย ยุฮ ยุม ไม่ ติ เจือ โน่ง. ");
INSERT INTO lcp_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“โอเอีฮ กาว ปุน ทไว ติ ปุน เซ, เปลิ โคะ เปลิ เอาะ ญุ่ก, ป ซมา ลโลวง ปุย ญุ่ก, เอีจ แปน โอยจ คอง พะจาว, ไม่ มัฮ โรฮ อื ป ซง่ะ ซงอม ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ดัฮ ไก ป ฆวต โตฮ โอเอีฮ กาว ปุน ทไว ติ ปุน เซ, ไมจ แม อื บุ งวยฮ ป ทไว แตะ เซ ง่า เปอเซน. ");
INSERT INTO lcp_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ซัตเลียง เปอะ โครยญ กาว ตัว อื, ลัง มัฮ คอง พะจาว ติ ตัว. ลไล เมีญ เปอะ ซัตซิง ยุฮ แตะ โครยญ กาว ตัว อื, ตัว กาว นึง อื เซ ลัง มัฮ คอง พะจาว. ");
INSERT INTO lcp_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","ปุ เกือฮ กุม อื เปียน ตัว ป ไมจ อื นึง ฮลัก แตะ กอ ฮา พะจาว. ดัฮ เปียน อื โฮ, ซ แปน เอิน คอง พะจาว ฆาื อื เตือง ลอา ตัว อื เซ, ไม่ โอ โรฮ อื เญือะ เกียฮ โตฮ แม,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","เมาะ โอเอีฮ โม เซ เตือง โอยจ อื มัฮ ตื ลปุง ซตอก พะจาว อาึง, ป เกือฮ พะจาว ละ ไอ โมเซ นึง บลาวง ซีไน โฮ, มัฮ เกือฮ อื ซึป อื ละ โม อิซราเอน.");
INSERT INTO lcp_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","เญือม เอีจ ฟวยจ โฮลฮ โม อิซราเอน โอก ฮา เมือง อียิป ลอา เนอึม เมอ, ปุก เญือม ฮาวก เคิ ลอา เซ ติ ซาวม. เญือม เซ พะจาว ฮอยจ อู ไม่ ไอ โมเซ นึง พากัง ก ฮอยจ ปุย เคะ พะจาว นึง ลาึน ซีไน. พะจาว อัฮ เฮี ละ อื, ");
INSERT INTO lcp_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","ปะ ไม่ อาโรน ไมจ เปอะ เมีญ เมาะ ไก เซน โม อิซราเอน เซ เตือง โอยจ อื, ละ ซ โจต เปอะ เมาะ ไก เซน โม ปรเมะ นึง อื เซ โครยญ โฆะ ปุย, ตัม ซฆลาวม ตัม ครอปครัว อื โครยญ โฆะ อื. ");
INSERT INTO lcp_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ไมจ เปอะ เมีญ โม ปรเมะ ป เอีจ ไก อาญุ อื เคียง ง่า เนอึม ฮาวก ก ล่าวง, เมาะ โม ป เกียฮ โฮว รุป เซิก นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ไมจ โรฮ เปอะ เกือฮ โม ปรเมะ เรอึม เปอะ. ไอฮ โม ฮัวนา เจอ นึง อื ติ เจอ ติ ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","ป มัฮ ปรเมะ ป ซ เรอึม เปอะ เซ ตัม เจอ อื เซ มอยฮ อื มัฮ ตอก เฮี. เจอ รูเบ่น เนอ มัฮ เอลีซู กวน เชเด่เออ. ");
INSERT INTO lcp_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","เจอ ซิเมโอน เนอ มัฮ เชลูมิเอน กวน ซูรีชัตได่. ");
INSERT INTO lcp_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","เจอ ยูด่า เยอ มัฮ นาโชน กวน อัมมีนาดั่ป. ");
INSERT INTO lcp_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","เจอ อิตซคา เยอ มัฮ เนทันเอน กวน ซูอา. ");
INSERT INTO lcp_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","เจอ เซบู่ลุน เนอ มัฮ เอลีอัป กวน เฮโลน. ");
INSERT INTO lcp_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ป มัฮ จัตเจือ โยเซป นึง อื, ไก ลอา เจอ. เจอ เอฟราอิม เมอ มัฮ เอลีชามา กวน อัมมีฮุต. เจอ มะนาเซ เยอ มัฮ กามาลิเอน กวน เปด่าซู. ");
INSERT INTO lcp_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","เจอ เบ่นยามิน เนอ มัฮ อาบี่ดั่น กวน กิเด่โอนี. ");
INSERT INTO lcp_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","เจอ ด่าน เนอ มัฮ อาฮิเยเซอ กวน อัมมีชัตได่. ");
INSERT INTO lcp_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","เจอ อาเชอ เยอ มัฮ ปากีเอน กวน โอครัน. ");
INSERT INTO lcp_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","เจอ กาต เตอ มัฮ เอลียาซัป กวน เด่อูเอน. ");
INSERT INTO lcp_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","เจอ นัปทาลี เยอ มัฮ อาฮิรา กวน เอนัน. อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ปุย โม เซ มัฮ โม ฮัวนา ลลาึง โม อิซราเอน เตือง โอยจ อื, นึง มัฮ อื ป เอีจ เลือก โม เซ ละ ซ เกือฮ อื แปน ตัว แทน เจอ ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ไอ โมเซ ไม่ อาโรน เกือฮ โม ป เอีจ โจต แตะ อาึง มอยฮ อื เซ เรอึม แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","เญือม เอีจ ฮาวก เคิ ลอา เซ ติ ซาวม เมอ, โม เซ กอก โม ลัปซด่อน ฮอยจ โพรม เนอึม เตือง โอยจ แตะ, เมาะ ป เอีจ ไก อาญุ อื เคียง ง่า เนอึม ฮาวก ก ล่าวง ฮอยจ โจต เนอึม เซน แตะ โครยญ โฆะ แตะ ตัม จัตเจือ แตะ, ตัม ครอปครัว แตะ, ตัม เมาะ ไก เซน แตะ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ไอ โมเซ เมีญ เนอึม ปุย นึง ลาึน ซีไน เซ ตัม ป เอีจ อัฮ พะจาว อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","46","โม ป เมีญ อื เซ มัฮ โม ปรเมะ ป ไก อาญุ อื เคียง ง่า เนอึม ฮาวก ก ล่าวง, เมาะ ป เกียฮ โฮว รุป เซิก นึง อื ตัม เจอ อื โครยญ เจอ, มัฮ ตอก เฮี. รูเบ่น มัฮ กวน โรง อิซราเอน. เจอ รูเบ่น ไก 46,500 ปุย. เจอ ซิเมโอน ไก 59,300 ปุย. เจอ กาต ไก 45,650 ปุย. เจอ ยูด่า ไก 74,600 ปุย. เจอ อิตซคา ไก 54,400 ปุย. เจอ เซบู่ลุน ไก 57,400 ปุย. เจอ เอฟราอิม ไก 40,500 ปุย. เจอ มะนาเซ ไก 32,200 ปุย. เจอ เบ่นยามิน ไก 35,400 ปุย. เจอ ด่าน ไก 62,700 ปุย. เจอ อาเชอ ไก 41,500 ปุย. เจอ นัปทาลี ไก 53,400 ปุย. รโจะ เตือง โอยจ อื แปน 603,550 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","เญือม เซ ปุย ปังเมอ โอ เมีญ โม เลวี เลียก รโจะ ไม่ โม เจอ ไฮญ นึง อื, ");
INSERT INTO lcp_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","นึง อัฮ พะจาว อื ละ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“ป มัฮ เจอ เลวี นึง อื ปะ ทัน โตว เมีญ, ไม่ โอ เปอะ ไมจ โจต เซน อื เกือฮ เลียก อาวต ไม่ โม อิซราเอน ไฮญ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ปะ ปังเมอ ไมจ เปอะ ดุฮ อาึง โม เลวี ละ ซ ยุฮ อื กัน ป เกว ไม่ พากัง ระ นา ก อาวต อาึ เซ. เกือฮ แปน ป แลน แก โอเอีฮ เมาะ ป โกว ปุย นึง พากัง ระ เซ ไม่ เฌาะ อื พากัง ระ เซ เตือง โอเอีฮ ป โกว ปุย นึง อื ฮอยจ ก ไฮญ, ไม่ ยุฮ อื กัน เกว ไม่ พากัง ระ เซ. มัฮ โรฮ ป ลัง โบลวง พากัง อาวต โม โกะ แตะ เกือฮ อาวต รวิต พากัง ระ เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","เญือม ซ เติง เวลา เฌาะ ปุย พากัง ระ เซ มัฮ โม เลวี เซ โน่ง ป ลัง เญื่อฮ ฮา. เญือม ซ โบลวง โคระ แม อื มัฮ โรฮ โม เลวี เซ โน่ง ป ลัง โบลวง เงอ. ดัฮ ไก ปุย ไฮญ ป เลียก ซดิ ไม่ พากัง ระ เซ ไมจ ปุย เกือฮ ลอก ตุต แตะ ฆาื อื ฮอยจ ละ ยุม อื. ");
INSERT INTO lcp_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ป มัฮ เจอ ไฮญ ไน โม อิซราเอน เซ, ไมจ อื โบลวง พากัง ยุฮ โกะ แตะ ไอฮ แปน มูๆ แตะ ตัม ก ลัง อาวต โม โกะ แตะ ไอฮ, นา ก ไก โทง ซุม เจอ ยุฮ อื เตือง ไพ เตือง มัน. ");
INSERT INTO lcp_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","โม เลวี ปังเมอ ไมจ เปอะ เกือฮ โบลวง พากัง ยุฮ โกะ แตะ เกือฮ อาวต รวิต พากัง ระ นา ก อาวต อาึ เซ, เดอึม อาึ โอ ซ โฮลฮ ฮาวก รพาวม ละ โม อิซราเอน เตือง โอยจ อื ฆาื เลียก ปุย ซดิ ไม่ นา เซ. ไมจ เปอะ เกือฮ โม เลวี เซ โซะโกะ ฮรักซา นึง พากัง ระ เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","โม อิซราเอน ยุฮ เนอึม อื ตัม ป อัฮ พะจาว อาึง ละ ไอ โมเซ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","พะจาว อัฮ อื ละ ไอ โมเซ ไม่ อาโรน ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","ไมจ เปอะ เกือฮ โม อิซราเอน ยุฮ ไคะ อาวต แตะ นึง ก ไก โทง ซุม เจอ ยุฮ โม โกะ แตะ. โทง เซ ไก เคืองไม เจอ ยุฮ โม โกะ นึง อื ไอฮ โครยญ เจอ อื. ไคะ ยุฮ อื เซ, เกือฮ ลั่กกา ลั่ก พากัง ระ ก ฮอยจ ปุย เคะ พะจาว โครยญ ลวง อื. ");
INSERT INTO lcp_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","โม ป ยุฮ ไคะ นึง ลวง ลั่ก โอก ซเงะ นึง อื ไมจ เปอะ เกือฮ อาวต ฆรึม โทง ไคะ ยุฮ โม ยูด่า. ป มัฮ ฮัวนา ยุฮ เจอ ยูด่า เซ มัฮ นาโชน กวน อัมมีนาดั่ป. ");
INSERT INTO lcp_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","โม ตฮัน ยุฮ อื เซ ไก 74,600 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ไมจ เปอะ เกือฮ เจอ อิตซาคา ยุฮ ไคะ อาวต แตะ โปน เซ เญี่ยะ. ป มัฮ ฮัวนา เจอ ยุฮ อื เซ มัฮ เนทันเอน กวน ซูอา. ");
INSERT INTO lcp_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","โม ตฮัน ยุฮ อื เซ ไก 54,400 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ไมจ เปอะ เกือฮ เจอ โม เซบู่ลุน ยุฮ ไคะ โปน ก อาวต โม อิตซาคา เซ. ป มัฮ ฮัวนา เจอ ยุฮ อื เซ มัฮ เอลีอัป กวน เฮโลน. ");
INSERT INTO lcp_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","โม ตฮัน ยุฮ อื เซ ไก 57,400 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","เซน ปุย ป เมีญ อื เลียก ไน ไคะ ยุฮ โม ยูด่า เซ เตือง โอยจ อื ไก 186,400 ปุย. เญือม ซ โอก โฮว อื, ปุย โม เซ ซ แปน ป โฮว รกา. ");
INSERT INTO lcp_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ไมจ เปอะ เกือฮ โม ป ลัง อาวต ฆรึม โทง ซุม เจอ ยุฮ โม รูเบ่น เซ ยุฮ ไคะ อาวต แตะ ลวง ลั่กเซฮ. ป มัฮ ฮัวนา เจอ รูเบ่น เซ มัฮ เอลีซู กวน เชเด่เออ. ");
INSERT INTO lcp_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","โม ตฮัน ยุฮ อื เซ ไก 46,500 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ไมจ เปอะ เกือฮ ปุย เจอ ซิเมโอน ยุฮ ไคะ ยุฮ แตะ เกือฮ อาวต โปน โม เซ แม เญี่ยะ. ป มัฮ ฮัวนา เจอ ยุฮ ซิเมโอน เซ มัฮ เชลูมิเอน กวน ซูรีชัตได่. ");
INSERT INTO lcp_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","โม ตฮัน ยุฮ อื เซ ไก 59,300 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ไมจ เปอะ เกือฮ ปุย เจอ กาต อาวต โปน ก อาวต โม เซ เญี่ยะ. ป มัฮ ฮัวนา ยุฮ โม เจอ กาต เซ มัฮ เอลียาซัป กวน เรอูเอน. ");
INSERT INTO lcp_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","โม ตฮัน ยุฮ อื เซ ไก 45,650 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","เซน ปุย ป เมีญ อื เลียก อาวต ไน ไคะ ยุฮ โม รูเบ่น เซ เตือง โอยจ อื ไก 151,450 ปุย. เญือม โอก โฮว อื, ปุย โม เซ ซ มัฮ มู ลอา นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ฟวยจ เซ ไมจ เปอะ เกือฮ โม เลวี ยวก พากัง ระ เซ, เกือฮ โกฮ โฮว ไม่ อื, ไมจ เปอะ เกือฮ โม เลวี โฮว ซน่ะ มู ไฮญ นึง อื. โม ป ยุฮ ไคะ ยุฮ แตะ รกา ไมจ อื โอก โฮว รกา. โม ป ยุฮ รเคะ ไมจ อื โฮว ตัม คัก ไล ตอก เญือม ยุฮ อื ไคะ ยุฮ แตะ เซ. อาวต ตื ไม่ โทง ยุฮ มู แตะ ไอฮ โครยญ มู อื. ");
INSERT INTO lcp_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ไมจ เปอะ เกือฮ โทง ไคะ ยุฮ โม เอฟราอิม อาวต ลวง ลั่ก เลียก ซเงะ ตัม ตอก อาวต มู โม โกะ อื เซ. ป มัฮ ฮัวนา ยุฮ โม เจอ เอฟราอิม เซ มัฮ เอลีชามา กวน อัมมีฮุต. ");
INSERT INTO lcp_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","โม ตฮัน ยุฮ อื เซ ไก 40,500 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ไมจ เปอะ เกือฮ ปุย เจอ มะนาเซ อาวต โปน เซ เญี่ยะ. ป มัฮ ฮัวนา ยุฮ โม เจอ มะนาเซ เซ มัฮ กามาลิเอน กวน เปด่าซู. ");
INSERT INTO lcp_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","โม ตฮัน ยุฮ อื เซ ไก 32,200 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ไมจ เปอะ เกือฮ ปุย เจอ เบ่นยามิน อาวต โปน ก อาวต โม มะนาเซ เซ เญี่ยะ. ป มัฮ ฮัวนา ยุฮ ปุย เจอ เบ่นยามิน เซ มัฮ อาบี่ดั่น กวน กิเด่โอนี. ");
INSERT INTO lcp_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","โม ตฮัน ยุฮ อื เซ ไก 35,400 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","เซน ปุย ป เมีญ อื เลียก อาวต ไน ไคะ ยุฮ โม เอฟราอิม เซ เตือง โอยจ อื ไก 108,100 ปุย. เญือม โอก โฮว อื, ปุย โม เซ ซ มัฮ มู ลอวย นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ไมจ เปอะ เกือฮ โทง ไคะ ยุฮ โม ด่าน อาวต ลวง ลั่กล่าวง ตัม ก อาวต มู โม โกะ อื ไอฮ. ป มัฮ ฮัวนา เจอ ยุฮ โม ด่าน เซ มัฮ อาฮิเยเซอ กวน อัมมีชัตได่. ");
INSERT INTO lcp_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","โม ตฮัน ยุฮ อื เซ ไก 62,700 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ไมจ เปอะ เกือฮ ปุย เจอ อาเชอ ยุฮ ไคะ ยุฮ แตะ โปน เซ แม เญี่ยะ. ป มัฮ ฮัวนา เจอ ยุฮ อื เซ มัฮ ปากีเอน กวน โอครัน. ");
INSERT INTO lcp_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","โม ตฮัน ยุฮ อื เซ ไก 41,500 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ไมจ เปอะ เกือฮ ปุย เจอ นัปทาลี อาวต โปน ก อาวต โม เซ แม เญี่ยะ. ป มัฮ ฮัวนา เจอ ยุฮ อื เซ มัฮ อาฮิรา กวน เอนัน. ");
INSERT INTO lcp_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","โม ตฮัน ยุฮ อื เซ ไก 53,400 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","เซน ปุย ป เมีญ อื เลียก อาวต ไน ไคะ ยุฮ โม ด่าน เซ เตือง โอยจ อื ไก 157,600 ปุย. เญือม โอก โฮว อื ปุย โม เซ ซ มัฮ มู รเคะ ฮา มู ไฮญ นึง อื. โฮว ตัม โทง ซุม เจอ ยุฮ โม โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","“ปุย โม เซ มัฮ โม ปรเมะ ไน จัตเจือ โม อิซราเอน ป เอีจ เกียฮ แปน ตฮัน นึง อื, มัฮ ป เอีจ เมีญ ปุย ตัม เจอ อื, ปุย โม เซ เตือง โอยจ อื ไก 603,550 ปุย.” ");
INSERT INTO lcp_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ปุย ปังเมอ โอ เมีญ โม เลวี เลียก รโจะ ไม่ โม อิซราเอน ไฮญ นึง อื, นึง มัฮ อื ป เอีจ ซตอก พะจาว อาึง ละ ไอ โมเซ ตอก เซ. ");
INSERT INTO lcp_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","เญือม เซ โม อิซราเอน ยุฮ เนอึม ไคะ ตอก เซ, ตัม ก อาวต โทง ยุฮ แตะ ไม่ โอก โฮว อื โครยญ โฆะ แตะ ตัม ครอปครัว แตะ, ตัม จัตเจือ แตะ ไอฮ, ตัม ป เอีจ ซตอก พะจาว อาึง ละ ไอ โมเซ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","เคียง เฮี โฮว มัฮ ไลลวง จัตเจือ อาโรน ไม่ ไอ โมเซ. มัฮ ป ไซฮ ปุย เญือม ลปุง พะจาว ไม่ ไอ โมเซ นึง บลาวง ซีไน โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","มอยฮ กวน รเมะ อาโรน เซ มัฮ ตอก เฮี, ป มัฮ กวน โรง อื มัฮ นาดั่ป. ฟวยจ เซ มัฮ แม อาบี่ฮู ไม่ เอเลอาซา ไม่ อิทามา. ");
INSERT INTO lcp_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","เอีจ มัฮ ปุย โม เซ ป เอีจ เรฮ อื ลออยฮ ซัมคัน นึง ไกญ อื ไม่ ดุฮ อื เกือฮ แปน ซตุ ยุฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ป มัฮ นาดั่ป ไม่ อาบี่ฮู เซ ปังเมอ ยุม ซองนา พะจาว ฆาื โกว อื งอ ป โอ ปุย ลัง โกว เญือม ทไว อื โอเอีฮ ละ พะจาว นึง ลาึน ซีไน เซ. ปุย ลอา เซ ไก โตว กวน ติ ตื. เคียง ยุม ปุย ลอา เซ มัฮ เอเลอาซา ไม่ อิทามา เซ โน่ง ป โฮลฮ ยุฮ กัน ลัง ยุฮ โม ซตุ เซ ไน ติ เจน ไอม อาโรน ป มัฮ เปือะ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ไมจ เปอะ เกือฮ โม เลวี เซ เลียก ซดิ, ไม่ ดุฮ โรฮ เปอะ อาึง ละ ซ แปน อื ป เรอึม อาโรน ป มัฮ ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","โม เซ ซ ยุฮ กัน เซ รโตง อาโรน, ไม่ รโตง ปุย เตือง โอยจ อื เมาะ ป เกว ไม่ กัน นึง พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","ซ แปน ป แลน แก โอเอีฮ ป โกว ปุย นึง พากัง ระ ก ฮอยจ ปุย เคะ พะจาว, ไม่ ซ ยุฮ อื กัน ป เกว ไม่ พากัง ระ เซ รโตง โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ไมจ เปอะ มอป อาึง โม เลวี เซ ละ อาโรน ไม่ โม ป มัฮ กวน อาโรน เซ. โม เซ เอีจ มัฮ ป เลือก พะจาว อาึง เน่อึม นึง โม อิซราเอน ละ ซ โฮลฮ อาโรน โกว. ");
INSERT INTO lcp_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","ปะ ไมจ เปอะ ดุฮ อาโรน ไม่ โม กวน อาโรน เซ ละ ซ เกือฮ เปอะ แปน ซตุ. ดัฮ ไก ปุย ไฮญ ป ฆวต เฆรือง แปน ซตุ ไม่ อื เซ, ปังเมอ จัมเปน ปุย ยุฮ ยุม ไม่ ฆาื อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ฟวยจ เซ พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“อาึ เอีจ เลือก โม เลวี โอก เน่อึม นึง โม อิซราเอน. มัฮ เลือก ฆรอ กวน รเมะ โรง โม อิซราเอน โครยญ โฆะ อื. เคียง เซ โม เลวี เอีจ มัฮ คอง อาึ. ");
INSERT INTO lcp_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","มัฮ ฆาื มัฮ กวน โรง โม อิซราเอน เซ คอง อาึ. เญือม โฮลฮ อาึ ยุฮ ยุม ไม่ กวน โรง ปุย นึง เมือง อียิป โฮ, อาึ เอีจ เลือก ป มัฮ กวน โรง โม อิซราเอน เซ, เตือง กวน โรง ปุย ไม่ กวน โรง ซัตซิง ละ ซ แปน อื คอง อาึ, อาึ มัฮ พะจาว,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","พะจาว อัฮ แม อื ละ ไอ โมเซ นึง บลาวง ซีไน เซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ไมจ เปอะ เมีญ โม เลวี เซ ตัม จัตเจือ อื, ตัม ครอปครัว อื. ไมจ เปอะ เมีญ โม ปรเมะ นึง อื โครยญ โฆะ ปุย, เมาะ ป เอีจ ไก อาญุ อื เคียง ติ เคิ ฮาวก ก ล่าวง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","เญือม เซ ไอ โมเซ เมีญ เนอึม โม เลวี เซ เตือง โอยจ อื ตัม ป เอีจ ซตอก พะจาว อาึง ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","มอยฮ กวน รเมะ เลวี เซ เตือง โอยจ อื มัฮ ตอก เฮี, มัฮ เกอโชน ไม่ โคฮัต ไม่ เมรารี. ");
INSERT INTO lcp_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ป มัฮ ซฆลาวม เกอโชน เซ มัฮ โม ลิปนี ไม่ โม ชิเมอี. ");
INSERT INTO lcp_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","ซฆลาวม โคฮัต เซ มัฮ โม อัมรัม, โม อิตฮา, โม เฮปโรน, ไม่ โม อุตซีเอน. ");
INSERT INTO lcp_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","ป มัฮ ซฆลาวม เมรารี เซ มัฮ โม มาลี, ไม่ โม มูชี. โม เซ เยอ, มัฮ ป ซึป เน่อึม จัตเจือ โม เลวี, ตัม จัตเจือ โม โกะ อื ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","จัตเจือ เกอโชน เซ มัฮ ซฆลาวม ลิปนี ไม่ ชิเมอี. ");
INSERT INTO lcp_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","เซน โม ปรเมะ นึง อื, เมาะ ป เอีจ ไก อาญุ อื เคียง ติ เคิ ฮาวก ก ล่าวง, ไก อาแลฮ เปือน ไปล พอน รอย ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","โม ป มัฮ จัตเจือ เกอโชน เซ ไมจ อื ยุฮ ไคะ ยุฮ แตะ นึง ลวง ลั่กเคะ พากัง ระ, ปุก ลวง ลั่ก เลียก ซเงะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ป มัฮ ฮัวนา ยุฮ โม จัตเจือ เกอโชน เซ มัฮ เอลียาซัป กวน ลาเอน. ");
INSERT INTO lcp_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","กัน ยุฮ โม จัตเจือ เกอโชน เซ มัฮ กัน เพรียง ฮอง ซัมคัน ไม่ พา ควน เลอึป ปุย อื, ไม่ พา ควน เฆีญ ปุย โตะ รเวือะ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","โนก ฮา เซ มัฮ แม กัน เพรียง พา ควน เฆีญ ปุย ควง พากัง ระ เซ นา ก อาวต คัน ทไว เซ ไคว อื, ไม่ พา ควน เฆีญ ปุย โตะ รเวือะ ก พริ อื เซ, ไม่ โม่ะ ควน โจก ปุย อื, ไม่ กัน ไฮญ นึง อื เมาะ ป เกว ไม่ พากัง ระ เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","จัตเจือ โคฮัต เซ มัฮ ซฆลาวม โม อัมรัม, อิตฮา, เฮปโรน, ไม่ อุตซีเอน. ");
INSERT INTO lcp_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","เซน โม ปรเมะ นึง อื เตือง โอยจ อื, เมาะ ป เอีจ ไก อาญุ อื เคียง ติ เคิ ฮาวก ก ล่าวง, ไก ซเตะ เปือน ไปล แลฮ รอย ปุย. ปุย โม เซ มัฮ ป ลัง แลน แก โอเอีฮ นึง ฮอง ซัมคัน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","โม ป มัฮ จัตเจือ โคฮัต เซ ไมจ อื ยุฮ ไคะ อาวต แตะ นึง ลวง ลั่กเซฮ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ป มัฮ ฮัวนา ยุฮ อื มัฮ เอลีซาฟัน กวน รเมะ อุตซีเอน. ");
INSERT INTO lcp_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","กัน ลัง ยุฮ ปุย โม เซ มัฮ กัน แลน แก ฮิต ซัมคัน ยุฮ พะจาว, ไม่ โตะ อาวต คโนมปัง, ไม่ ชวง ออม ไม่ คัน ทไว เตือง ลอา อื, ไม่ เครอึง โกว โม ซตุ เซ เญือม รซอฮ อื ละ พะจาว กไน พากัง ระ เซ โครยญ เจือ, เตือง พากัง ซน่ะ ฮอง ซัมคัน เซ, ไม่ กัน โครยญ เจือ ป เกว ไม่ โอเอีฮ โม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ป มัฮ ฮัวนา ระ ยุฮ โม เลวี เซ มัฮ เอเลอาซา กวน อาโรน ป มัฮ ซตุ เซ. เอเลอาซา เซ มัฮ ป ควป คุม แลน แก โม ป ไปญ กัน นึง ฮอง ซัมคัน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","จัตเจือ เมรารี เซ มัฮ ซฆลาวม มาลี ไม่ มูชี. ");
INSERT INTO lcp_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","เซน โม ปรเมะ นึง อื เตือง โอยจ อื, เมาะ ป เอีจ ไก อาญุ อื เคียง ติ เคิ ฮาวก กล่าวง, ไก แลฮ เปือน ไปล ลอา รอย ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ป มัฮ ฮัวนา ยุฮ โม จัตเจือ เมรารี เซ มัฮ ซุรีเอน, กวน อาบี่ฮาอิน, ปุย โม เซ ซ ยุฮ ไคะ ยุฮ แตะ นึง ลวง ลั่กล่าวง พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","กัน ลัง ยุฮ โม เซ มัฮ กัน โซะโกะ นึง ไมะ แปน เดีญ พากัง ระ เซ, ไม่ โคะ ซแก อื, ไม่ ด่อง, ไม่ ควน โบลวง ด่อง, ไม่ กัน ไฮญ ป เกว ไม่ โอเอีฮ โม เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","โนก ฮา เซ มัฮ แม ลัก ฆรุง อื ไคว อื ไม่ ควน โบลวง ลัก เซ, ไม่ โม่ะ อื เตือง ลัก ป เกอึม ปุย ละ ปุก โม่ะ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","โม ป ยุฮ ไคะ นึง ลั่กกา พากัง ระ ลวง ลั่ก โอก ซเงะ เซ, มัฮ ไอ โมเซ ไม่ อาโรน ไม่ กวน เฌือต อื. กัน ลัง ยุฮ ปุย โม เซ มัฮ แลน แก โซะโกะ ฮรักซา นึง ไลลวง พากัง ระ เซ รโตง โม อิซราเอน เตือง โอยจ อื. ปุย ไฮญ ดัฮ ลู เลียก ซดิ ไม่ พากัง ระ เซ จัมเปน ปุย ยุฮ ยุม ไม่ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","เซน โม ปรเมะ เลวี เตือง โอยจ อื โครยญ ซฆลาวม อื ป โฮลฮ ไอ โมเซ ไม่ อาโรน เมีญ ตัม ป อัฮ พะจาว ละ แตะ เซ, เมาะ ป เอีจ ไก อาญุ อื เคียง ติ เคิ ฮาวก ก ล่าวง เงอ, ไก ลอา ฮมาึน ไปล ลอา เปือน ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","พะจาว อัฮ แม อื ละ ไอ โมเซ ตอก เฮี, “ปะ ไมจ เปอะ เมีญ โม ป มัฮ กวน รเมะ โรง โม อิซราเอน เมาะ ป ไก อาญุ อื เคียง ติ เคิ ฮาวก ก ล่าวง. ไมจ เปอะ โจต อาึง เมาะ ไก เซน มอยฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","อาึ มัฮ พะจาว, โม เลวี เอีจ มัฮ คอง อาึ. มัฮ รโตง กวน โรง โม อิซราเอน เจอ ไฮญ นึง อื เซ. ไมจ โรฮ เปอะ ทไว ซัตซิง ยุฮ โม เลวี เซ ละ อาึ, รโตง ซัตซิง เกิต โรง ยุฮ โม อิซราเอน เจอ ไฮญ เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","เญือม เซ ไอ โมเซ เมีญ เนอึม โม ป มัฮ กวน โรง โม อิซราเอน เซ, ตัม ป เอีจ อัฮ พะจาว อาึง ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","กวน รเมะ โรง โม อิซราเอน ป เมีญ อื เซ, เมาะ ป เอีจ ไก อาญุ อื เคียง ติ เคิ ฮาวก ก ล่าวง เงอ, ไก 22,273 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ฟวยจ เซ พะจาว อัฮ แม อื ละ ไอ โมเซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ไมจ เปอะ ทไว โม เลวี เซ ละ อาึ รโตง กวน โรง โม อิซราเอน ไฮญ นึง อื เซ, ไม่ ซัตซิง ยุฮ โม เลวี เซ รโตง ซัตซิง ยุฮ โม อิซราเอน ไฮญ เซ. เญือม เซ โม เลวี เซ ซ มัฮ คอง อาึ. อาึ มัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","เซน โม กวน โรง โม อิซราเอน ไฮญ นึง อื เซ ปุก โฮฮ ฮา เซน โม เลวี ลอา รอย ไม่ อาลแฆลฮ โรฮ ลอวย ปุย. เซน ปุย เมาะ เซ ไมจ เปอะ โตฮ นึง มาื. ");
INSERT INTO lcp_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ปะ ไมจ เปอะ เกป เน่อึม นึง ปุย โม เซ ติ ปุย พอน เชเคน, ตัม นัม นัก โกว ปุย นึง พากัง ระ. (ติ เชเคน เซ ไก ง่า เกรา.) ");
INSERT INTO lcp_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","มาื เมาะ ป โฮลฮ ปุย นึง กัน โตฮ ปุย กวน โรง แตะ นึง อื เซ, ไมจ แม เปอะ มอป ละ อาโรน ไม่ โม ป มัฮ กวน เฌือต อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ไอ โมเซ เกป เนอึม มาื งวยฮ โตฮ ปุย กวน โรง แตะ นึง อื เซ, ");
INSERT INTO lcp_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","มาื เกป อื เซ ไก 1,365 เชเคน. ");
INSERT INTO lcp_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ฟวยจ เซ ไอ โมเซ เกือฮ เนอึม มาื เซ ละ อาโรน ไม่ โม กวน เฌือต อื ตัม ป อัฮ พะจาว ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","พะจาว อัฮ อื ละ ไอ โมเซ ไม่ อาโรน ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ไมจ เปอะ โจต เมาะ ไก เซน โม โคฮัต ป มัฮ เจอ เลวี เซ, ตัม เจอ ตัม ซฆลาวม อื, ");
INSERT INTO lcp_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","มัฮ โม ปรเมะ ป เอีจ ไก อาญุ อื เคียง ง่วย เนอึม ฮอยจ ละ รฮอน เนอึม โครยญ โฆะ ปุย, เมาะ ป เอีจ ลัง ยุฮ อื กัน ป เกว ไม่ พากัง ระ ก ฮอยจ ปุย เคะ พะจาว.” ");
INSERT INTO lcp_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“กัน ยุฮ โม โคฮัต เซ มัฮ กัน เกว ไม่ โอเอีฮ ป ตึก นึง ซัมคัน แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","เญือม ซ เฌาะ ปุย ไคะ ยุฮ แตะ, ไมจ อาโรน ไม่ โม กวน อื เลียก กไน พากัง ระ เซ, ละ ซ บลาึฮ อื พา ควน เฆีญ ปุย ฮิต ลปุง ซันญา เซ, ไม่ เลอึป อื ฮิต เซ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ไมจ แม อื เลอึป ฮิต เซ นึง ฮัก กะโลมา, ไม่ เลอึป อื นึง พา ซี ฟะ, ลอต เอิน ซลอ โคะ ควน กลอม ปุย อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","ฟวยจ เซ ไมจ แม อื ตุม พา ซี ฟะ นึง ราว โตะ อาวต คโนมปัง เซ ติ ปลัฮ, ไม่ อาึง อื กลอง เชือม นึง, ไม่ เชือม โบลง อาวต ป ซออย ฮงาื นึง เซ, เยือก รอาวม อะงุน, ไม่ คโนมปัง ป ลัง อาวต ลอป นึง อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ฟวยจ เซ ไมจ แม อื เลอึป นึง พา ซครัก, ไม่ ฮัก กะโลมา, ลอต เอิน ซลอ ควน กลอม ปุย อื.” ");
INSERT INTO lcp_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“ฟวยจ เซ ป มัฮ ชวง ออม ไม่ ออม นึง อื, ไม่ มิต ญัป, ไม่ ทัต ควน อาวต อื, ไม่ ปัง อาวต ลออยฮ ละ บุ ปุย ลออยฮ นึง ออม เซ, ไมจ โรฮ อื เลอึป นึง พา ซี ฟะ. ");
INSERT INTO lcp_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ไมจ เปอะ เกือฮ เพาะ ออม เซ ไม่ เครอึง โกว ปุย ละ ออม เซ เตือง โอยจ อื นึง ฮัก กะโลมา, ไม่ ลอต อื อาึง นึง ควน กลอม ปุย อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","เกือฮ แม เลอึป คัน ไคร ควน ทไว ปุย ป ซออย ฮงาื เซ นึง พา ซี ฟะ ไม่ ฮัก กะโลมา, ไม่ ลอต โรฮ อื ซลอ ควน กลอม ปุย อื.” ");
INSERT INTO lcp_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“ไมจ โรฮ อื เพาะ เครอึง โกว ปุย นึง ฮอง ซัมคัน เซ เตือง โอยจ อื นึง พา ซี ฟะ ไม่ เลอึป อื นึง ฮัก กะโลมา ไม่ ลอต โรฮ อื อาึง นึง ควน กลอม ปุย อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“ไมจ แม อื โทก จะ อาวต โตะ คัน ทไว ระ เซ, ไม่ เลอึป อื คัน เซ นึง พา ซี ซูวัน. ");
INSERT INTO lcp_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","โอเอีฮ เมาะ ป มัฮ เคืองมื โกว ปุย ละ คัน ทไว เซ, ตอก โดง อาวต งอ, ไร ควน มั่ก โตะ, ลัว ควน ชาวก จะ, ไม่ เชือม โบลง, เกือฮ ละ อาึง อื ลวง ราว คัน เซ. ฟวยจ เซ ไมจ อื เลอึป นึง ฮัก กะโลมา ไม่ ลอต อื ซลอ ควน กลอม ปุย อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","เญือม เอีจ ฟวยจ เลอึป อาโรน ไม่ โม กวน อื โอเอีฮ โกว ปุย นึง ฮอง ซัมคัน เซ, ดัฮ เอีจ เติง เวลา เฌาะ ปุย ไคะ ยุฮ แตะ, ไมจ เปอะ เกือฮ จัตเจือ โคฮัต เซ ฮอยจ กลอม ปุ โฮว เครอึง เซ, ปังเมอ โอ อื ไมจ ลอก โอเอีฮ ซัมคัน ยุฮ พะจาว เซ เฟือฮ เอิน, เดอึม โอ ซ ยุม ฆาื อื. เอีจ มัฮ โอเอีฮ ป โกว ปุย นึง พากัง ยุฮ พะจาว เซ ป โฮลฮ โม จัตเจือ โคฮัต เซ กลอม เมอ. ");
INSERT INTO lcp_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“เอเลอาซา กวน อาโรน ป มัฮ ซตุ เซ, ไมจ อื แปน ป มอง แลน ลออยฮ นึง ออม ไม่ ป ซออย ฮงาื, ไม่ เฮงาะ รโกะ ทไว ปุย, ไม่ ลออยฮ ซัมคัน ป โกว ปุย ละ เรฮ แตะ นึง ปุย. ไมจ อื แปน ป แลน แก พากัง เซ เตือง ลัง อื, ไม่ โอเอีฮ นึง อื โครยญ เจือ, เตือง โอเอีฮ ป ทไว ปุย ละ พะจาว นึง อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","พะจาว อัฮ แม อื ละ ไอ โมเซ ไม่ อาโรน ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","19","“ปุ เกือฮ โม จัตเจือ โคฮัต ลอก โอเอีฮ ซัมคัน ยุฮ พะจาว เซ เฟือฮ เอิน เดอึม โอ ซ ยุม ฆาื อื. ฮา เซ ไมจ เปอะ เกือฮ อาโรน ไม่ โม กวน อื เซ เลียก เมก ไม กัน ลัง ยุฮ โม เซ ละ อื โครยญ โฆะ อื นึง โอเอีฮ ป ลัง กลอม อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","โม โคฮัต เซ ปังเมอ โอ เปอะ ไมจ เกือฮ เลียก แก โอเอีฮ ซัมคัน ยุฮ พะจาว เซ ติ ไง่ เนอึม, เดอึม โอ ซ ยุม ฆาื อื,” อัฮ เซ พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","พะจาว อัฮ แม เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“ไมจ เปอะ โจต เซน มอยฮ โม จัตเจือ เกอโชน ป มัฮ เจอ เลวี เซ ตัม เจอ ตัม ซฆลาวม อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ป ไมจ เปอะ โจต มอยฮ อื เซ มัฮ โม ปรเมะ ป เอีจ ไก อาญุ อื เคียง ง่วย เนอึม ฮอยจ ละ รฮอน เนอึม, เมาะ ป เอีจ ลัง ยุฮ กัน ละ ซ เพรียง แตะ พากัง ระ ก ฮอยจ ปุย เคะ พะจาว เซ โครยญ โฆะ อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","กัน ลัง ยุฮ โม เซ มัฮ กัน ปุยฮ กลอม เครอึง พากัง ระ เซ. เครอึง โม เซ มัฮ ตอก เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","มัฮ พา ควน เลอึป ปุย อื เตือง ก พริ กไน อื, ไม่ ฮัก กะโลมา ควน เลอึป ปุย ลวง ราว อื, ไม่ พา ควน เฆีญ โตะ รเวือะ อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","มัฮ แม พา ควน เฆีญ ปุย ควง อื รวิต อื, ไม่ คัน ทไว นึง อื, ไม่ พา ควน เฆีญ โตะ รเวือะ ควง อื เซ, ไม่ โม่ะ ควน โจก ปุย อื, ไม่ โอเอีฮ ป เกว ไม่ อื. มัฮ โอเอีฮ โม เซ ป ลัง โฮลฮ โม เกอโชน ลัปพิตชอป เปอ. ");
INSERT INTO lcp_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ไมจ อาโรน ไม่ โม กวน อาโรน เซ แปน ป ควป คุม แลน แก โม จัตเจือ เกอโชน เซ. กัน ไมจ อื ยุฮ ไม่ โอเอีฮ ไมจ อื ปุยฮ กลอม โครยญ เจือ เซ, ไมจ อื เมก ไม อาึง ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","มัฮ โอเอีฮ โม เซ ป มัฮ กัน ลัง ยุฮ โม จัตเจือ เกอโชน ป เกว ไม่ พากัง ระ เซ. ป มอง ควป คุม แลน แก กัน ยุฮ ปุย โม เซ เยอ, มัฮ อิทามา กวน อาโรน ป มัฮ ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“ไมจ โรฮ เปอะ โจต เซน มอยฮ โม จัตเจือ เมรารี เซ ป มัฮ เจอ เลวี เซ ตัม เจอ ตัม ซฆลาวม อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ป ไมจ เปอะ โจต มอยฮ อื มัฮ โม ปรเมะ ป เอีจ ไก อาญุ อื เคียง ง่วย เนอึม ฮอยจ ละ รฮอน เนอึม, มัฮ โม ป เอีจ ลัง ยุฮ กัน ละ ซ เพรียง แตะ พากัง ระ ก ฮอยจ ปุย เคะ พะจาว เซ โครยญ โฆะ อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","กัน ลัง ยุฮ โม เซ มัฮ กัน ปุยฮ กลอม เครอึง พากัง ระ เซ, มัฮ กลอม โรวก ไมะ แปน เดีญ อื, ไม่ โคะ ซแก อื, ไม่ ด่อง อื ไม่ ควน โบลวง ด่อง อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","มัฮ แม ลัก ฆรุง อื ป ไก รวิต ควง อื เซ, ไม่ ควน โบลวง ลัก อื เซ, ไม่ ลัก ป เกอึม ปุย ละ ปุก โม่ะ อื, ไม่ โม่ะ ปุก ปุย อื, ไม่ เครอึง ไฮญ อื เมาะ ป โกว ปุย ละ พากัง เซ เตือง โอยจ อื. โอเอีฮ โม เซ โครยญ เจือ ปะ ไมจ เปอะ เมก ไม ละ อื ละ ซ เกือฮ เปอะ โรวก อื. ");
INSERT INTO lcp_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","มัฮ โอเอีฮ โม เซ ป มัฮ กัน ลัง ยุฮ โม จัตเจือ เมรารี ป เกว ไม่ พากัง ระ เซ. ป มอง ควป คุม แลน แก กัน ยุฮ ปุย โม เซ มัฮ อิทามา กวน อาโรน ป มัฮ ซตุ เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","48","ไอ โมเซ ไม่ อาโรน ไม่ โม ป มัฮ ฮัวนา ปุย นึง อื เซ, เมีญ เนอึม เซน โม โคฮัต ไม่ เซน โม เกอโชน ไม่ เซน โม เมรารี เซ ตัม จัตเจือ อื ตัม ครอปครัว อื โครยญ โฆะ อื. มัฮ ยุฮ อื ตัม ป ซตอก พะจาว อาึง ละ แตะ. ป เมีญ อื เซ มัฮ โม ปรเมะ ป เอีจ ไก อาญุ อื เคียง ง่วย เนอึม ฮอยจ ละ รฮอน เนอึม นึง อื ป เอีจ ลัง ยุฮ อื กัน ป เกว ไม่ พากัง ก ฮอยจ ปุย เคะ พะจาว เซ. ปุย โม เซ เยอ ไก เซน ตอก เฮี, จัตเจือ โคฮัต เตอ ไก 2,750 ปุย. จัตเจือ เกอโชน ไก 2,630 ปุย. จัตเจือ เมรารี แม ไก 3,200 ปุย. เซน ปุย โม เซ เตือง โอยจ อื รโจะ แปน 8,580 ปุย. เซน ปุย โม เซ เตือง โอยจ อื รโจะ แปน 8,580 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ปุย โม เซ เอีจ ไก ตื กัน ลัง ยุฮ ไม่ ป ลัง ปุยฮ ลัง กลอม อื โครยญ โฆะ แตะ เตือง ไพ เตือง มัน ตัม ป ซตอก พะจาว อาึง ละ ไอ โมเซ เซ. ไอ โมเซ เอีจ เมีญ เนอึม อาึง ปุย โครยญ โฆะ อื ตัม ป ซตอก พะจาว อาึง ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ปะ ไมจ เปอะ ซตอก โม อิซราเอน, เกือฮ อัฮ อื ละ โม ป ลอก ลาวต, ไม่ โม ป ไก ป รแอม ปัต โอก เน่อึม นึง โกะ อื เซ, ไม่ โม ป แปน ปุย รแอม ไล นึง โคะ ลอก แตะ ป ยุม, เกือฮ โอก อาวต ก พริ ไคะ โครยญ โฆะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ไมจ โรฮ เปอะ อัฮ ละ อื เตือง โม ปรเมะ ไม่ ปรโปวน, เกือฮ โอก อาวต ตื ก พริ ไคะ เซ, ละ โอ ไคะ อาวต อื เซ ซ แปน ป รแอม ไล ฆาื อื, นึง มัฮ ไคะ เซ นา ก ฮอยจ อาวต อาึ นึง ไม่ ปุย,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","เญือม เซ โม อิซราเอน ยุฮ เนอึม อื ตอก เซ. เกือฮ เนอึม ปุย โม เซ โอก อาวต ก พริ ไคะ ตัม ป ซตอก พะจาว อาึง ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ปะ ไมจ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี, ดัฮ ไก ป บ่วก ละ ปุย, ปัง มัฮ ปรเมะ ญุ่ก, ปัง มัฮ ปรโปวน ญุ่ก, ปุย เซ เอีจ มัฮ โรฮ ยุฮ อื ป พิต ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ไมจ ปุย เซ รโซะ พิต ยุฮ แตะ เซ, ไม่ รแม่ อื โอเอีฮ ป บ่วก แตะ นึง เซ ละ กุม อื เกือฮ ปุก ตัม คาโนวน งวยฮ อื, โฮฮ ฮา เซ ไมจ ลั่ง อื บุ ละ อื ง่า เปอเซน. ");
INSERT INTO lcp_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ดัฮ ปุย เซ เอีจ ยุม โฮ ไม่ โอ อื ไก เอียกปุ ละ ซ รัป แตะ โอเอีฮ ป รแม่ ปุย ละ แตะ เซ, ไมจ อื ตาว ป รแม่ แตะ เซ ละ พะจาว ละ ซ โฮลฮ ซตุ โกว. เกือฮ โรวก อื ไม่ แกะ โปก ละ ซ ทไว อื แปน ควน รไซจ พิต โฌวะ ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","โอเอีฮ เมาะ ป ทไว พิเซต โม อิซราเอน ละ พะจาว โครยญ เจือ มัฮ ป ลัง ละ ซตุ ป ไจไซ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","โอเอีฮ ทไว ปุย ละ พะจาว โครยญ เจือ, เอีจ มัฮ ป ลัง ละ โม ซตุ, เอีจ แปน โรฮ คอง โม ซตุ เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","14","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ปะ ไมจ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี. ‘ดัฮ ไก มะ ป โกวน ป เลนจุ ไม่ ปรเมะ ไฮญ เญอ, ปรเมะ เญือะ อื เซ ซองไซ นึง อื ปังเมอ โอ ปุน เตะ ปุน ชวง อื, นึง เม่าะ ปรโปวน เซ ไล แตะ ฮา อื, ปัง มัฮ ปุย ไฮญ ปุ โรฮ โรวต แปน พีญัน ละ อื, โต เซ อื แพป นึง อื, ดัฮ ตอ ไก ปุย ซองไซ รพาวม นึง แกต แตะ ปรโปวน เญือะ แตะ เลนจุ, เตือง โอ ปรโปวน เญือะ อื ยุฮ เนอึม ตอก เซ, ");
INSERT INTO lcp_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","เคียง มัฮ อื ตอก เซ ไมจ เปอะ เกือฮ ปุย เซ บะ โรวก ปรโปวน เญือะ แตะ, เกือฮ โฮว เคะ ซตุ, ไม่ โรวก อื ป ทไว แตะ รโตง ปรโปวน เญือะ แตะ เซ, ป มัฮ แปง บ่าเล ลอา ลิต. ปุ เกือฮ เรฮ ลออยฮ นึง อื ไม่ โอ อื ไมจ ดุฮ ป ซออย ฮงาื นึง แปง เซ, นึง มัฮ อื ป ทไว ปุย รโตง รพาวม ซองไซ ปุย นึง ปุ แตะ, ไม่ มัฮ อื ป เกือฮ ปุย โตก ละ พิต ยุฮ แตะ, ไม่ ซ เกือฮ อื ปุย ยุ ที พิต ยุฮ อื เซ, ดัฮ ไก เนอึม โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ฟวยจ เซ โม ซตุ เซ ซ เกือฮ ปรโปวน เซ เลียก ซดิ ละ ซ เกือฮ อื ชุง ซองนา พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","เญือม เซ ซตุ เซ ซ ดุฮ รอาวม ซัมคัน โตะ โดง เตะ. ฟวยจ เซ ซ ตุย รกาื ลังเตะ กไน พากัง ระ เซ ดุฮ อื โตะ รอาวม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ลไล อาวต อื ซองนา พะจาว เซ ซตุ เซ ซ เกือฮ อื กัฮ ฮาึก กลาวม แตะ. เกือฮ โรฮ อื ไปญ โอเอีฮ ทไว แตะ เซ ไม่ อื, ป มัฮ โอเอีฮ ทไว อื รโตง รพาวม ซองไซ ปุย นึง ปุ แตะ เซ. ซตุ เซ ซ ไปญ โรฮ รอาวม ซอง, ป ไก รซอม ซะ ซม่อต นึง. ");
INSERT INTO lcp_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ฟวยจ เซ ซตุ ซ เกือฮ ปรโปวน เซ ซม่อต ติ แตะ. ซตุ เซ ซ อัฮ อื ละ ปรโปวน เซ ตอก เฮี, ‘ดัฮ ปะ โอ ยุฮ เนอึม กัน ฆอก นึง ไอจ แตะ ไม่ ปรเมะ ไฮญ, ปัง ญุ เปอะ รอาวม ซม่อต เซ ซ แปน โตว ป ติ ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ดัฮ เปอะ ยุฮ เนอึม กัน ฆอก เซ โฮ นึง เลน เปอะ จุ ไม่ ปรเมะ ไฮญ, ");
INSERT INTO lcp_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","รซอม ซะ ซม่อต เซ พะจาว ซ เกือฮ เนอึม อื ฮอยจ ละ ปะ ฆาื อื ซองนา ปุย เตือง โอยจ อื. พะจาว ซ เกือฮ เญือะ กวน เปอะ แลป, ไม่ ซ เกือฮ อื เวียก เปอะ ปลอยฮ. ");
INSERT INTO lcp_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ปัว เกือฮ เนอึม รอาวม ซม่อต เซ เลียก นึง โกะ เปอะ ละ ซ เกือฮ เนอึม อื เวียก เปอะ ปลอยฮ ไม่ เกือฮ เนอึม อื เญือะ กวน เปอะ เซ แลป,’ อัฮ เซ. เญือม เซ ปรโปวน เซ ไมจ อื อัฮ ตอก เฮี, ‘อาเมน, เกือฮ แปน ตอก อัฮ เปอะ เซ เมิฮ,’ อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“เญือม เซ ซตุ เซ ซ ไซฮ ลปุง ซม่อต ซบั่น เซ นึง แพน ฮัก. ฟวยจ ไซฮ อื รไซจ แม รซอม เซ เกือฮ บัฮ โตะ รอาวม ซัมคัน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","กา ซ เกือฮ อื ปรโปวน เซ ญุ รอาวม ป เกียฮ เกือฮ ปรโปวน เซ โซะ เนอึม โซะ แนม ป อาวม เซ, ");
INSERT INTO lcp_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ซตุ เซ ซ ตุย ป ทไว ปรโปวน เซ ฮา เตะ อื, ซ กอยฮ ทไว อื ละ พะจาว. ฟวยจ เซ ตาว อื นึง คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ฟวยจ เซ ซตุ เซ ซ ตุย แม แปง ทไว อื เซ ติ ซบราวก เตะ แตะ, ลอต ตอง อื โตะ งอ นึง คัน ทไว เซ. เญือม เซ ซ เกือฮ ปรโปวน เซ ญุ รอาวม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","เญือม เอีจ ฟวยจ เกือฮ อื ปรโปวน เซ ญุ รอาวม เซ, ดัฮ ปรโปวน เซ โอ เนอึม รพาวม ละ ปรเมะ เญือะ แตะ โฮ, รอาวม ซม่อต เซ ซ เกือฮ อื โซะ เนอึม โซะ แนม ป อาวม ฆาื อื. ซ เกือฮ เวียก อื เซ ปลอยฮ ไม่ ซ เกือฮ โรฮ เญือะ กวน อื แลป. ปรโปวน เซ ซ ลอต แปน ปุย ไลจ มอยฮ ฆาื อื ซองนา ปุย เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ดัฮ ปรโปวน เซ ซง่ะ ซงอม เนอึม โฮ, ซ แปน โตว ป ติ ละ อื, ซ เกียฮ ไก แม โรฮ ลั่ง กวน อื. ");
INSERT INTO lcp_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","เซ มัฮ โกตไม โกว ปุย เญือม ไก รพาวม ซองไซ ปุย นึง ปรโปวน เญือะ แตะ นึง แกต อื มัฮ ป เลน จุ. ");
INSERT INTO lcp_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","เญือม เซ ไมจ อื เกือฮ ปรโปวน เซ ชุง ซองนา พะจาว, ฟวยจ เซ ซตุ เซ ซ ยุฮ อื ละ ปรโปวน เซ ตัม โกตไม เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","เญือม เซ ปรเมะ เซ ซ โปน กัน พิต ยุฮ แตะ. ปรโปวน เญือะ อื ดัฮ ไก เนอึม พิต โฮ ปังเมอ ซ จัมเปน ลอก ตุต แตะ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ไมจ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี, ดัฮ ไก ปรเมะ ญุ่ก, ปรโปวน ญุ่ก, ป ซันญา พิเซต โอเอีฮ ไม่ พะจาว นึง ซ แปน อื โม นาซีไรต ละ ซ ทไว อื ติ แตะ ละ พะจาว เยอ, ");
INSERT INTO lcp_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ไมจ เปอะ เกือฮ ปุย เซ ทอเนาะ ติ แตะ ฮา ไปล อะงุน ไม่ ไปล โอเอีฮ ไฮญ. ไมจ โตว อื ญุ ไปล อะงุน นะ, ไมจ โตว อื โรฮ ญุ รอาวม อะงุน, ปัง มัฮ เปลิ อะงุน ไอม, ปัง มัฮ เปลิ ซออฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","ไน ติ เจน แปน อื โม นาซีไรต เซ ไมจ โตว อื โซม โอเอีฮ เมาะ ป โอก เน่อึม นึง โคะ อะงุน, ปัง มัฮ โนง อื ญุ่ก, ปัง มัฮ เฮลาะ อื ญุ่ก, ไมจ โตว อื โซม ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ไน ติ เจน ซันญา อื ไลลวง ซ ทไว อื ติ แตะ ละ พะจาว เซ, ไมจ โตว อื ญัป ฮาึก แตะ ไม่ โอ อื ไมจ คุต ฮาึก รบุม แตะ. ไมจ อื ลเวือง ฮาึก ไกญ ฮาึก กัป แตะ. ไมจ อื แปน ปุย ซง่ะ ไล ฮอยจ ละ โอยจ กัมโนต ซันญา ทไว อื ติ แตะ ละ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","7","ไน ติ เจน ทไว อื ติ แตะ ละ พะจาว เซ, ไมจ โตว อื เกือฮ ติ แตะ ซดิ ไม่ ป ยุม, นึง ซ แปน อื ปุย รแอม ไล ฆาื อื, ปัง มัฮ ป ยุม เซ มะเปือะ อื, ปัง มัฮ เอียกปุ ออปุ อื ญุ่ก, ไมจ โตว อื เลียก ซดิ ไม่ ติ ตื, นึง เอีจ ยุ ที ปุย นึง ฮาึก ไกญ อื เซ มัฮ อื ปุย ทไว ติ แตะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","“ไน ติ เจน ทไว อื ติ แตะ เซ, ไมจ เนอึม อื แปน ปุย ซง่ะ ไล ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","ดัฮ ไก ปุย ฮอยจ ยุม โบ นาซีไรต เซ จุบั่น ตัน ด่วน เนอ, ฮาึก ไกญ ป ทไว อื เซ เอีจ แปน แม ป รแอม ไล ฆาื อื. ซเงะ อาแลฮ นึง อื, ไมจ อื ญัป ฮาึก แตะ ไม่ คุต อื ฮาึก รบุม แตะ, เดอึม ซ เกียฮ แปน แม ปุย ซง่ะ ไล ตอก ไพรม แตะ เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ซเงะ ซเตะ นึง อื เซ, ไมจ อื โรวก รโกะ เกอื ลอา ตัว. โต เซ มัฮ โนก พิลัป นุม ลั่ง ลอา ตัว ละ โม ซตุ ฮอยจ นึง โบ โตะ รเวือะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","เญือม เซ ซตุ เซ ซ ทไว อื ติ ตัว ละ ซ แปน ควน โตฮ ปุย เซ ติ แตะ ฮา มั่ป ยุฮ แตะ. ติ ตัว อื เซ ซ ตอง แม ทไว อื เตือง ตัว อื. มัฮ ตอก เซ ตอก ซ รไซจ อื พิต โฌวะ ยุฮ ปุย เซ นึง อื. มัฮ ฆาื เอีจ ไก พิต ยุฮ อื นึง ไลลวง ป ยุม เซ. ไน ซเงะ เซ ไมจ แม อื เฌาะ ลเวือง โคระ ฮาึก แตะ ละ ทไว อื ติ แตะ แม. ");
INSERT INTO lcp_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","ฟวยจ เซ ไมจ แม อื เฌาะ ตัง โคระ เวลา ซ ทไว อื ติ แตะ ละ พะจาว เซ. ไมจ อื โรวก แกะ โปก ป ไก อาญุ ติ เนอึม ละ ซ ทไว อื แปน ควน ยวก มั่ป กัฮ ตุต ยุฮ แตะ, มัฮ ฆาื เอีจ ลอก อื ป รแอม ไล. กัน ซันญา ไพรม อื เซ เอีจ ไลจ. เวลา ซันญา อื เซ เญือะ แปน โตว โรฮ ป โกว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“เญือม เอีจ ลอยจ เวลา ซันญา อื ซ แปน แตะ นาซีไรต เซ, โกต ยุฮ อื มัฮ ตอก เฮี. ไมจ อื โฮว ฮอยจ โบ โตะ รเวือะ พากัง ระ เซ, ");
INSERT INTO lcp_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","ไม่ ไมจ อื โรวก ทไว โอเอีฮ ละ พะจาว ตอก เฮี. มัฮ กวน แกะ โปก อาญุ ติ เนอึม ป โอ อื ไก ตอก โละพริ ละ ซ ตอง อื ทไว เตือง ตัว อื, ไม่ กวน แกะ รโปวน อาญุ ติ เนอึม ป โอ อื ไก ตอก โละพริ ละ ซ แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ, ไม่ แกะ โปก ติ ตัว ป โอ อื ไก ตอก โละพริ ละ ซ ทไว อื แปน ควน รโจะ ดิ อื รพาวม แตะ ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ไมจ โรฮ อื โรวก ทไว คโนมปัง โอ ไก เจือ ติ กซาว, ไม่ คโนมปัง ยุฮ ปุย นึง ญอต แปง ซเบื่อก ไม่ ลออยฮ, ไม่ คโนมปัง แปน แฮลป อื ป โอ ไก เจือ ป ตา ปุย ลออยฮ นึง, ไม่ เฮงาะ รโกะ ไม่ รอาวม อะงุน ละ ซ ทไว แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“เญือม เซ ซตุ เซ ซ ทไว อื ละ พะจาว แปน ควน โตฮ มั่ป ยุฮ ปุย เซ, ไม่ แปน อื ป ตอง อื ทไว เตือง ตัว อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","ซตุ เซ ซ ทไว แกะ โปก ติ ตัว เซ, ไม่ คโนมปัง โอ ไก เจือ ติ กซาว, ไม่ เฮงาะ รโกะ ไม่ รอาวม อะงุน ละ ซ แปน ควน รโจะ ดิ ปุย เซ รพาวม แตะ ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","ฟวยจ เซ ป มัฮ นาซีไรต เซ ซ คุต ฮาึก แตะ ตัม ป เอีจ ซันญา แตะ อาึง เซ, นึง โบ โตะ รเวือะ พากัง ระ เซ, ไม่ ซ ตอง อื ฮาึก ญัป แตะ เซ โตะ งอ นึง คัน ก เอีจ ตอง แตะ โอเอีฮ ทไว แตะ ละ รโจะ ดิ อื รพาวม แตะ ไม่ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","เญือม เอีจ ฟวยจ คุต ป มัฮ นาซีไรต ฮาึก แตะ เซ, ซตุ ซ ตุย เกลีป แกะ ป เอีจ โตวง แตะ อาึง เซ, ไม่ คโนมปัง โอ ไก เจือ เน่อึม โตะ กซาว เซ ลอา แฮลป. มัฮ ป ปู อื ติ แฮลป, มัฮ ป เฮรี อื ติ แฮลป, อาึง อื นึง เตะ ป มัฮ นาซีไรต เซ เตือง ลอา ก บลัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ฟวยจ เซ ซตุ เซ ซ โรวก โอเอีฮ โม เซ กอยฮ ทไว อื ละ พะจาว, แปน ป ทไว พิเซต อื ละ พะจาว. เนะ รน่าวก แกะ ไม่ รเวือง แกะ ป เอีจ กอยฮ อื ทไว เซ มัฮ ป ลัง ละ ซตุ เซ. เคียง เซ โฮว ไป นา เยอ, ป มัฮ นาซีไรต เซ ดัฮ ฆวต ญุ รอาวม อะงุน โฮ, ญุ อื แปน. ");
INSERT INTO lcp_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“โอเอีฮ โม เซ มัฮ โกตไม ยุฮ ป มัฮ นาซีไรต เซ, ตัม ป เอีจ ซันญา อื ไม่ พะจาว เญือม ทไว อื ติ แตะ เซ. โนก ฮา เซ ดัฮ ไก ลั่ง ป เอีจ ซันญา อื อาึง ละ พะจาว, ไมจ อื ยุฮ ตัม ป เอีจ ซันญา แตะ เซ โครยญ เจือ.” ");
INSERT INTO lcp_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“ไมจ เปอะ อัฮ ละ อาโรน ไม่ โม กวน อื เซ, เกือฮ ปิฮ มุ่น ละ โม อิซราเอน เซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘ปัว พะจาว ปิฮ กุนมุ่น ละ โม เปะ ไม่ แลน แก โซะโกะ ฮรักซา ลอป อื นึง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ปัว พะจาว ซอต รังซเปีย ยุฮ แตะ ละ เปอะ, ไม่ เลียก พาวม อื นึง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ปัว เกือฮ อัมนัต พะจาว อาวต ลอป ไม่ โม เปะ ไม่ เกือฮ อื รพาวม เฮน ฮลอง ละ เปอะ,’ เกือฮ อื อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","ดัฮ ยุฮ อื ตอก เซ นึง กอก แตะ รโฮงะ มอยฮ อาึ ละ โม อิซราเอน เซ, อาึ ซ ปิฮ เนอึม มุ่น ละ โม เซ เบือ อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ซเงะ โบลวง ไอ โมเซ พากัง ระ ก ฮอยจ ปุย เคะ พะจาว เซ ไอ โมเซ เรฮ ลออยฮ ซัมคัน นึง พากัง ระ เซ, ไม่ เครอึง ป โกว ปุย นึง อื เตือง คัน ทไว ไม่ โอเอีฮ เมาะ ป โกว ปุย นึง อื เซ โครยญ เจือ, ละ ซ ทไว อื ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","เญือม เซ ป มัฮ ฮัวนา เจอ ยุฮ โม อิซราเอน เซ เตือง โอยจ อื, มัฮ โม ป เอีจ เลือก ปุย แปน ฮัวนา เญือม โจต ปุย เซน แตะ โฮ, ");
INSERT INTO lcp_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","โรวก ทไว โอเอีฮ ละ พะจาว. ป ทไว อื เซ มัฮ เลาะ แลฮ กัน, ไม่ โมวก แลฮ กู. ปุย ลอา ปุย โรวก เลาะ ติ กัน ไม่ โมวก ติ ปุย ติ ตัว ทไว อื ลั่กกา พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ฟวยจ เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“ไมจ เปอะ รัป อาึง โอเอีฮ โม เซ, ละ ซ โกว ปุย อื นึง กัน ป เกว ไม่ พากัง ระ เซ. ไมจ เปอะ มอป ละ โม เลวี เซ, ตัม กัน ลัง ยุฮ อื โครยญ โฆะ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ไอ โมเซ โรวก เนอึม เลาะ ไม่ โมวก เซ, โฮว มอป อื ละ โม เลวี. ");
INSERT INTO lcp_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","เกือฮ เลาะ ลอา กัน ไม่ โมวก ลอา กู ละ โม เกอโชน ตัม กัน ลัง ยุฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","เกือฮ เลาะ ปาวน กัน ไม่ โมวก ปาวน กู ละ โม เมรารี, ตัม กัน ลัง ยุฮ อื โรฮ. ปุย โม เซ มัฮ ป ยุฮ กัน ตัม ป ควป คุม แลน แก อิทามา กวน อาโรน ป มัฮ ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","โม จัตเจือ โคฮัต นึง อื ปังเมอ โอ มอป โอเอีฮ โม เซ ละ อื, นึง มัฮ อื ป ลัง ปุยฮ กลอม โอเอีฮ ป ตึก นึง ซัมคัน ยุฮ พะจาว เซ นึง โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ไน ซเงะ ชลอง ปุย คัน ทไว เซ โม ฮัวนา เจอ ยุฮ โม อิซราเอน เซ โรวก โรฮ ทไว โอเอีฮ ยุฮ แตะ ลั่กกา คัน ทไว เซ. ");
INSERT INTO lcp_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","พะจาว เอีจ อัฮ อาึง อื ละ ไอ โมเซ ตอก เฮี, “ไมจ เปอะ เกือฮ โม ฮัวนา เจอ เซ โรวก ทไว โอเอีฮ ยุฮ แตะ ไน กัน ชลอง ปุย คัน ทไว เซ, โครยญ ซเง่ะ ติ ซเงะ ติ ปุย,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","ปุย โม เซ โรวก เนอึม ทไว โอเอีฮ ติ ซเงะ ติ ปุย ตัม ไล อื ตอก เฮี. ซเงะ ติ มัฮ นาโชน กวน อัมมีนาดั่ป ป มัฮ เจอ ยูด่า. ซเงะ ลอา มัฮ เนทันเอน กวน ซูอา ป มัฮ เจอ อิตซาคา. ซเงะ ลอวย มัฮ เอลีอัป กวน เฮโลน ป มัฮ เจอ เซบู่ลุน. ซเงะ ปาวน มัฮ เอลีซู กวน เชเด่เออ ป มัฮ เจอ รูเบ่น. ซเงะ พอน มัฮ เชลูมิเอน กวน ซุรีชัตได่ ป มัฮ เจอ ซิเมโอน. ซเงะ แลฮ มัฮ เอลียาซัป กวน เด่อูเอน ป มัฮ เจอ กาต. ซเงะ อาแลฮ มัฮ เอลีชามา กวน อัมมีฮุต ป มัฮ เจอ เอฟราอิม. ซเงะ ซเตะ มัฮ กามาลิเอน กวน เปด่าซู ป มัฮ เจอ มะนาเซ. ซเงะ ซไตม มัฮ อาบี่ดั่น กวน กิเด่โอนี ป มัฮ เจอ เบ่นยามิน. ซเงะ กาว มัฮ อาฮิเยเซอ กวน อัมมีชัตได่ ป มัฮ เจอ ด่าน. ซเงะ กาว โรฮ ติ มัฮ ปากีเอน กวน โอครัน ป มัฮ เจอ อาเชอ. ซเงะ กาว ลอา มัฮ อาฮิรา กวน เอนัน ป มัฮ เจอ นัปทาลี. โอเอีฮ ป โรวก ปุย โม เซ ละ ซ ทไว แตะ ป ตอก อื ปุ แตะ นึง อื มัฮ โอเอีฮ โม เฮี. มัฮ เชือม มาื ติ, นัมนัก ติ รอย ไม่ ง่วย เชเคน, ไม่ กลอง มาื ติ, นัมนัก อาลแฆลฮ เชเคน, ตัม เชเคน โกว ปุย นึง ฮอง ซัมคัน เซ. โอเอีฮ ลอา เจือ เซ นาวก นึง ญอต แปง ซเบื่อก ไม่ ลออยฮ, ตอก ไล กอ ทไว ปุย เฮงาะ รโกะ ละ พะจาว โฮ. มัฮ แม เชือม ไคร ติ, นัมนัก กาว เชเคน, นาวก นึง กัมยัน ละ ซ ตอง อื ทไว ละ พะจาว. มัฮ แม กวน โมวก โปก ติ ตัว, แกะ โปก ติ ตัว, กวน แกะ โปก อาญุ ติ เนอึม ติ ตัว, ละ ซ ตอง อื ทไว เตือง ตัว อื. มัฮ แม ปิ โปก ติ ตัว, ละ ซ ทไว อื แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ แตะ. มัฮ แม โมวก โปก ลอา ตัว, แกะ โปก พอน, ปิ โปก พอน, ไม่ กวน แกะ โปก ป ไก อาญุ อื ติ เนอึม พอน ตัว, ละ ซ ทไว อื แปน ควน รโจะ ดิ อื รพาวม แตะ ไม่ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ป มัฮ ฮัวนา เจอ ยุฮ โม อิซราเอน เซ, เอีจ โรวก เนอึม ทไว โอเอีฮ โม เซ เตือง โอยจ อื, ไน กัน ชลอง ปุย คัน ทไว เซ, เตือง กาว โรฮ ลอา ปุย อื เซ. ป ทไว อื เซ รโจะ แปน เมาะ เฮี เตือง โอยจ อื. มัฮ เชือม มาื กาว โรฮ ลอา, กลอง มาื กาว โรฮ ลอา, เชือม ไคร กาว ลอา. ");
INSERT INTO lcp_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","เชือม มาื เซ ติ ติ, นัมนัก ติ รอย ไม่ ง่วย เชเคน, กลอง มาื เซ ติ ติ นัมนัก อาลแฆลฮ เชเคน. มาื ป ยุฮ ปุย กลอง เชือม เซ นึง อื เตือง โอยจ อื นัมนัก ลอา เปือน ไปล ปาวน รอย เชเคน, ตัม เชเคน โกว ปุย นึง ฮอง ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","มัฮ แม เชือม ไคร กาว ลอา, นาวก นึง กัมยัน. เชือม ไคร เซ ติ ติ อี นัมนัก กาว เชเคน, ตัม เชเคน โกว ปุย นึง ฮอง ซัมคัน เซ. ไคร ป ยุฮ ปุย เชือม นึง เซ เตือง โอยจ อื นัมนัก ติ รอย ไม่ ง่า เชเคน. ");
INSERT INTO lcp_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ซัตซิง ละ ซ ตอง อื ทไว เซ, มัฮ โมวก โปก กาว ลอา ตัว, แกะ โปก กาว โรฮ ลอา ตัว, กวน แกะ โปก ป ไก อาญุ อื ติ เนอึม กาว ลอา ตัว, ไม่ เฮงาะ รโกะ ทไว ปุย, ไม่ ปิ โปก กาว โรฮ ลอา ตัว, ละ ซ ทไว อื แปน ควน โตฮ ปุย ติ แตะ ฮา มั่ป ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ซัตซิง เตือง โอยจ อื, เมาะ ป มอก ปุย ทไว ละ ซ รโจะ ดิ อื รพาวม แตะ ไม่ พะจาว เซ, มัฮ โมวก โปก ง่า โรฮ ปาวน ตัว, แกะ โปก ลแฆลฮ ตัว, ปิ โปก ลแฆลฮ ตัว, ไม่ กวน แกะ โปก ป ไก อาญุ อื ติ เนอึม ลแฆลฮ ตัว. โอเอีฮ โม เซ เตือง โอยจ อื, มัฮ ป ทไว ปุย ไน กัน ชลอง อื คัน ทไว เซ, ไม่ กัน เรฮ อื ลออยฮ ซัมคัน นึง อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","เญือม เลียก ไอ โมเซ นึง โตะ พากัง ระ ละ ซ ลปุง แตะ ไม่ พะจาว, เญือม ออฮ เญือม เอีฮ ญุ่ก, ไอ โมเซ โฮลฮ ฮมอง เซียง อัฮ พะจาว โอเอีฮ ละ แตะ เน่อึม นึง รเดือป ฮิต ซัมคัน ซน่ะ ฮุป เตปด่า ไก โพรยจ ลอา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“ปะ ไมจ เปอะ อัฮ ละ อาโรน ตอก เฮี, เญือม ซ อาึง เปอะ ออม ไคร อาแลฮ ราว ชวง อื เซ, ไมจ เปอะ เกือฮ ซเปีย ออม เซ ซอต โฮว ลั่กกา ชวง อื เซ,” ");
INSERT INTO lcp_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","อาโรน ยุฮ เนอึม อื ตอก เซ. อาึง ออม เซ ราว ชวง อาวต อื, เกือฮ ซเปีย ออม เซ ซอต โฮว ลั่กกา ควน อาวต อื เซ, ตัม ป ซตอก พะจาว ละ ไอ โมเซ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","ไลลวง ตอก ยุฮ ปุย ชวง ออม เซ มัฮ ตอก เฮี, ชวง ออม เซ มัฮ ป แตม ปุย นึง ไคร ซโน. เน่อึม นึง เน่อึม อื ฮอยจ นึง ฮุป เตีย ป อาวต เปือง กัก อื เซ มัฮ ป แตม ปุย เกือฮ ไมจ ตอก โฮ. มัฮ ยุฮ อื ตัม แบ่ป ป เปลีฮ พะจาว ละ ไอ โมเซ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","พะจาว อัฮ แม เฮี ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ปะ ไมจ เปอะ รกัฮ โม เลวี เกือฮ ตัง โน่ง ฮา โม อิซราเอน ไฮญ นึง อื, ไม่ เกือฮ เปอะ แปน ป ซง่ะ ไล ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","กัน เกือฮ เปอะ แปน ป ซง่ะ เซ มัฮ ตอก เฮี, ไมจ เปอะ โกว รอาวม ซัมคัน ป เกือฮ ปุย ซง่ะ ไล ละ. ไมจ เปอะ ซพรอต รอาวม เซ นึง โม เซ. ฟวยจ เซ ไมจ เปอะ เกือฮ คุต ฮาึก แตะ เตือง โม่ว แตะ. ไมจ โรฮ เปอะ เกือฮ ซัก เครอึง แตะ, ละ ซ เกือฮ อื ติ แตะ ซง่ะ ไล ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","ไมจ เปอะ เกือฮ โม เซ โรวก กวน โมวก โปก ไม่ โอเอีฮ ทไว อื, ป มัฮ ญอต แปง ซเบื่อก ไม่ ลออยฮ เซ. ปะ ไมจ โรฮ เปอะ โรวก กวน โมวก โปก ติ ตัว แม, ละ ซ ทไว เปอะ แปน ควน โตฮ ปุย ติ แตะ ฮา มั่ป. ");
INSERT INTO lcp_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ฟวยจ เซ ไมจ โรฮ เปอะ เกือฮ โม อิซราเอน ฮอยจ โพรม โครยญ โฆะ แตะ. ไมจ แม เปอะ เกือฮ โม เลวี โฮว ฮอยจ ลั่กกา พากัง ระ ก ฮอยจ ปุย เคะ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","เญือม เซ ไมจ เปอะ เกือฮ โม อิซราเอน ย่อง เตะ แตะ ราว โม เลวี เซ. ");
INSERT INTO lcp_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ฟวยจ เซ ไมจ เปอะ เกือฮ อาโรน ทไว โม เลวี เซ ละ พะจาว, เกือฮ แปน ป ทไว พิเซต โม อิซราเอน เซ ละ ซ รซอฮ อื ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","เญือม เซ โม เลวี ซ ย่อง เตะ แตะ ราว ไกญ โมวก เตือง ลอา ตัว อื เซ, ติ ตัว อื ปะ ไมจ เปอะ ทไว ละ แปน อื ควน โตฮ ปุย ติ แตะ ฮา มั่ป. ติ ตัว อื เซ แม ไมจ เปอะ ตอง ทไว เตือง ตัว อื แปน ควน รไซจ พิต โฌวะ ยุฮ โม เลวี. ");
INSERT INTO lcp_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","“ไมจ เปอะ เกือฮ โม เลวี เซ แปน ป ทไว พิเซต ปุย ละ พะจาว, เกือฮ อาโรน ไม่ กวน อื เซ ควป แลน กัน ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","มัฮ เซ ป ไมจ เปอะ รกัฮ โม เลวี เซ เกือฮ ตัง โน่ง ฮา โม อิซราเอน ไฮญ นึง อื ฆาื อื, ละ ซ แปน โม เลวี เซ คอง อาึ. ");
INSERT INTO lcp_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","เคียง เอีจ ฟวยจ ทไว เปอะ โม เลวี ตอก เซ ไม่ เอีจ เกือฮ เปอะ แปน ปุย ซง่ะ ไล เยอ, โม เลวี เซ ซ โฮลฮ เนอึม ยุฮ กัน ป เกว ไม่ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","อาึ เอีจ รัป โม เลวี เซ แปน คอง โกะ แตะ ไอฮ รโตง กวน รเมะ โรง โม อิซราเอน เซ เตือง โอยจ อื. โม เลวี เซ เอีจ มัฮ เนอึม คอง อาึ. ");
INSERT INTO lcp_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","เญือม ยุฮ อาึ ยุม ไม่ กวน โรง ปุย นึง เมือง อียิป โฮ, อาึ เอีจ รัป กวน รเมะ โรง โม อิซราเอน เซ โครยญ ครอปครัว อื, เกือฮ แปน คอง แตะ เตือง กวน โรง ซัตซิง ยุฮ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","อาึ เอีจ รัป โรฮ โม เลวี เซ รโตง กวน โรง โม อิซราเอน เซ, ละ ซ แปน อื คอง อาึ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","อาึ เอีจ มอป โรฮ โม เลวี เซ ละ อาโรน ไม่ โม กวน อื เซ, แปน คองควน เกือฮ โม อิซราเอน ละ อื. โม เลวี เซ ซ โฮลฮ ยุฮ กัน นึง พากัง ระ เซ ไม่ ซ โฮลฮ อื แปน ควน เฆีญ โม อิซราเอน, เดอึม โม อิซราเอน เซ โอ ซ เลียก ซดิ ไม่ ฮอง ซัมคัน เซ, ไม่ โอ อื ซ เกิต ป โตะ ป ตอง ละ ฆาื อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ไอ โมเซ ไม่ อาโรน ไม่ โม อิซราเอน เตือง โอยจ อื ทไว เนอึม โม เลวี เซ ละ พะจาว, ตัม ป ซตอก พะจาว อาึง ละ ไอ โมเซ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","เญือม เซ โม เลวี เกือฮ เนอึม ติ แตะ ซง่ะ ไล ละ พะจาว. ซัก เครอึง เซอึก แตะ. ฟวยจ เซ อาโรน ทไว เนอึม อื เกือฮ แปน คอง ทไว พิเซต ปุย ละ พะจาว, ไม่ ไจไซ อื ทไว ซัตซิง รโตง อื ละ ซ รไซจ อื เกือฮ ซง่ะ ฮา มั่ป ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","โม ลัปซด่อน เตือง โอยจ อื ยุฮ เนอึม อื ตัม ป ซตอก พะจาว อาึง ละ ไอ โมเซ, เมาะ ป เกว ไม่ ไลลวง โม เลวี เซ. เคียง เซ โม เลวี โฮลฮ เนอึม ยุฮ กัน ป เกว ไม่ พากัง ระ เซ, ตัม ป เมก ไม อาโรน ไม่ โม กวน อาโรน เซ ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ไลลวง เฮี มัฮ ป เกว ไม่ โม เลวี. ไมจ เปอะ เกือฮ โม เลวี ป ไก อาญุ อื เคียง 25 เนอึม ฮาวก ก ล่าวง แปน ป ยุฮ กัน ป เกว ไม่ พากัง ระ เซ โครยญ โฆะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ดัฮ เอีจ ไก อาญุ รฮอน เนอึม โฮ, ไมจ เปอะ เกือฮ ลโล่ะ ยุฮ แตะ กัน. ");
INSERT INTO lcp_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","เคียง เซ โฮว ไป นา, เกียฮ เรอึม ลั่ง อื โม เอียกปุ แตะ นึง กัน ยุฮ อื, ปังเมอ โอ อื เญือะ ไมจ ยุฮ ไอฮ นึง เตะ โกะ แตะ. ปะ ไมจ เปอะ มอป อาึง กัน ละ โม เลวี เซ, ตัม ไล เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ไน เคิ เมือ โรง นึง อื, เญือม เอีจ ไคว อื ติ เนอึม ฟวยจ โอก โม อิซราเอน ฮา เมือง อียิป เปอ, พะจาว อัฮ อื ละ ไอ โมเซ นึง ลาึน ซีไน เซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“ไมจ เปอะ เกือฮ โม อิซราเอน ชลอง กัน เลียง ฌาว, ตัม เวลา เอีจ กัมโนต อาึ อาึง ละ เปอะ ตอก เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","เญือม ฮาวก เคิ ติ เฮี กาว โรฮ ปาวน ซาวม เมอ, เมาะ เอีจ เลียก ซเงะ เอ, ไมจ เปอะ ชลอง กัน เลียง ฌาว เซ, ไม่ ยุฮ เปอะ ตัม โกตไม ไม่ โกต ลเบี่ยป ป เกว ไม่ ไลลวง เซ เตือง โอยจ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ไอ โมเซ ลอต เอิน รโฮงะ อื ละ โม อิซราเอน, เกือฮ อื ชลอง กัน เลียง ฌาว เซ. ");
INSERT INTO lcp_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","เญือม เอีจ ฮาวก เคิ ติ เซ กาว โรฮ ปาวน ซาวม เมอ, เญือม เอีจ เลียก ซเงะ เอ, โม อิซราเอน ชลอง เนอึม กัน เลียง ฌาว นึง ลาึน ซีไน เซ. เอีจ มัฮ ยุฮ อื ตัม ป อัฮ พะจาว ละ ไอ โมเซ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","เญือม เซ ปังเมอ ไก ปรเมะ นึง ง่อน ป เอีจ แปน ปุย รแอม ไล นึง โคะ ลอก แตะ ป ยุม, เกียฮ ชลอง โตว กัน เลียง ฌาว เซ ฆาื อื. ซเงะ เซ ปุย โม เซ โฮว ฆาื อื เคะ ไอ โมเซ ไม่ อาโรน. ");
INSERT INTO lcp_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","อัฮ เฮี ละ อื, “เอะ เอีจ แปน เนอึม ปุย รแอม ไล ฆาื โคะ ลอก แตะ ป ยุม. เมอยุ โอ เอะ โฮลฮ เลียก รโจะ นึง กัน ทไว ปุย โอเอีฮ ละ พะจาว เญือม ทไว โม อิซราเอน ไฮญ อื?” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ไอ โมเซ โลยฮ อื ละ อื, “ไมจ เปอะ มอง ฮอยจ ละ ยุง เปอะ ตอก รโฮงะ พะจาว อื ละ อาึ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ไมจ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี, ดัฮ ไก ปุย ไน โม เปะ ไม่ โม กวน เฌือต เปอะ, ป เอีจ แปน ปุย รแอม ไล นึง โคะ ลอก แตะ ป ยุม ญุ่ก, ไม่ ป โฮว คระ ซไง ญุ่ก, ไมจ ลั่ง อื ชลอง กัน เลียง ฌาว เซ ละ พะจาว, ");
INSERT INTO lcp_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ไมจ เปอะ เกือฮ ชลอง กัน เลียง ฌาว เซ ไน เคิ ลอา นึง อื. เญือม เอีจ ฮาวก เคิ ลอา เซ กาว โรฮ ปาวน ซาวม เมือ กปู อื, ไมจ โรฮ เปอะ เกือฮ โซม คโนมปัง โอ ไก เจือ, ไม่ ปอน อื โตะ แกะ เซ, ไม่ โตะ โกละ ซอง. ");
INSERT INTO lcp_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ไมจ โตว อื เกือฮ ป โซม ป ปอน เซ โฮฮ ฮอยจ ละ เมือ กซะ อื, ไม่ โอ อื ไมจ เกือฮ ซอัง แกะ เซ โบวก ติ ซี เนอึม. ไมจ โรฮ เปอะ เกือฮ ยุฮ อื ตัม โกตไม ป เกว ไม่ ไลลวง กัน เลียง ฌาว เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“ดัฮ ไก ป โฆง โอ ชลอง กัน เลียง ฌาว เซ, เตือง มัฮ แตะ ปุย โอ รแอม ไล, ไม่ โอ อื มัฮ ป โฮว คระ ซไง เยอ, ปุย เซ เญือะ ไมจ เปอะ โตว เมีญ มัฮ ปุย ไน โม อิซราเอน ฆาื อื, นึง โอ อื ทไว ป ลัง ทไว แตะ ตัม เวลา ลัง ยุฮ อื. ปุย เซ ซ จัมเปน ลอก ตุต ฆาื พิต ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","ดัฮ ปุย ตังเมือง ฮอยจ อาวต ลลาึง เปอะ, ไม่ ฆวต ชลอง โรฮ อื กัน เลียง ฌาว เซ ละ พะจาว, ไมจ อื ยุฮ ตัม โกตไม ไม่ โกต ลเบี่ยป ป เกว ไม่ ไลลวง กัน เลียง ฌาว เซ โครยญ เจือ. ไมจ เปอะ เกือฮ ยุฮ อื ตัม โกตไม ติ เจือ เซ โครยญ โฆะ ปุย, เตือง โม อิซราเอน ไม่ ปุย ตัง เมือง,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ไน ซเงะ โบลวง ปุย พากัง ก อาวต พะจาว เซ, ไก ชุต รวู ซัมคัน นึง, เลอึป เอิน พากัง ระ เซ. เมือ ก ซาวม อื ซครัก ตอก รเออึป งอ โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","เมือ ซเง่ะ อื มัฮ ชุต รวู, เมือ ก ซาวม อื มัฮ ตอก งอ. มัฮ แนฮ ตอก เซ โครยญ ซะ โครยญ บู. ");
INSERT INTO lcp_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","เญือม เอีจ เฌาะ ชุต รวู เซ ติ แตะ ฮา พากัง ระ เซ, โม อิซราเอน เซ เฌาะ โรฮ ก อาวต แตะ. เญือม เอีจ ลโล่ะ ชุต รวู เซ ซื นา ออฮ, โม อิซราเอน ซ ยุฮ โรฮ ไคะ อาวต แตะ ซื นา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","เญือม โอก โฮว โม อิซราเอน เซ, มัฮ โอก โฮว อื ตัม ป อัฮ พะจาว ละ แตะ. เญือม ยุฮ อื ไคะ อาวต แตะ มัฮ โรฮ ยุฮ อื ตัม ป อัฮ พะจาว ละ แตะ โรฮ. ติ เจน อาวต ชุต รวู ราว พากัง ระ เซ ปุย อาวต โรฮ ฆาื อื นึง ไคะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ดัฮ ชุต รวู อาวต ราว พากัง ระ เซ อาวต เลี่ญ โฮ, โม อิซราเอน ดิ โอก โฮว โตว โรฮ ฆาื อื, นึง ยุฮ อื ตัม ป อัฮ พะจาว ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ติ ติ เลีฮ อื ชุต รวู เซ อาวต โตว ราว พากัง ระ เซ โฮวน ซเงะ. โม เซ ซ ยุฮ ไคะ อาวต แตะ ไม่ เฌาะ อื ไคะ ยุฮ แตะ ตัม เซ นึง เนอึง อื ป อัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ติ ติ เลีฮ อื ชุต รวู เซ อาวต เน่อึม เมือ กปู อื ฮอยจ เมือ กซะ อื โน่ง. เมือ กซะ อื เซ โม เซ ซ เฌาะ ติ แตะ ตัม ตอก โฮว ชุต รวู เซ. ปัง อาวต แม ติ ซเงะ ไปล ติ ซาวม ญุ่ก, ดัฮ ชุต รวู เซ เฌาะ ติ แตะ, โม เซ ซ เฌาะ โรฮ ก อาวต แตะ ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ปัง อาวต ชุต รวู เซ ราว พากัง ระ เซ ลอา ซเงะ ญุ่ก, ปัง อาวต ติ เคิ ญุ่ก, ปัง มัฮ ติ เนอึม ญุ่ก, โม อิซราเอน ซ อาวต โรฮ นึง ไคะ ยุฮ แตะ ตัม เซ โรฮ. โอก โฮว ชุต รวู เซ เญือม ออฮ, ซ โอก โฮว เญือม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","เญือม ยุฮ โม เซ ไคะ ไม่ เญือม เฌาะ อื ไคะ ยุฮ แตะ เอีจ มัฮ ยุฮ อื ตัม ป อัฮ พะจาว อาึง ละ ไอ โมเซ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“ไมจ เปอะ แตม โตวต มาื ลอา, ละ ซ ปาึง ปุย อื เญือม กอก เปอะ ปุย โพรม, ไม่ เญือม ซ เกือฮ เปอะ ปุย เฌาะ ไคะ ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","เญือม ปาึง ปุย โตวต เซ เตือง ลอา อื เกือฮ บัว เซียง แตะ ลั่ง เงอ, เอีจ มัฮ กอก เปอะ ปุย เตือง โอยจ อื เกือฮ ฮอยจ โพรม ไม่ เปอะ นึง คระ เลียก ปุย โตะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","เญือม ปาึง ปุย โตวต เซ ติ โน่ง, เอีจ มัฮ กอก เปอะ โม ฮัวนา เจอ ยุฮ โม อิซราเอน เกือฮ ฮอยจ โพรม ไม่ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","เญือม ปาึง ปุย โตวต เกือฮ ดวต เซียง, เอีจ มัฮ เกือฮ เปอะ โม เจอ ป อาวต ลวง ลั่ก โอก ซเงะ เซ โอก โฮว. ");
INSERT INTO lcp_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","เญือม ปาึง ปุย โตวต เกือฮ ดวต เซียง โฮน ลอา นึง อื, เอีจ มัฮ เกือฮ เปอะ โม เจอ ป อาวต ลวง ลั่กเซฮ เซ โอก โฮว. เซียง โตวต ปาึง ปุย เกือฮ ดวต เซียง เซ, มัฮ เกือฮ อื ปุย ยุง เฌาะ ไคะ ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","เซียง โตวต ปาึง ปุย เกือฮ บัว เซียง แตะ เซ, ปังเมอ มัฮ ป เกือฮ ปุย ยุง ฮอยจ โพรม ดิ ไม่ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“ไมจ เปอะ เกือฮ กวน อาโรน ป มัฮ ซตุ เซ แปน ป ปาึง โตวต เซ. ไลลวง โตวต เซ เอีจ มัฮ โกตไม ตอน ฮมัน ละ เปอะ, ฮอยจ ละ จัตเจือ เปอะ เฆียง เฮี โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","เญือม ไก ป ฮอยจ รุป ไม่ เปอะ ฮอยจ นึง ปลัฮเตะ อาวต เปอะ เฮี, ลไล ตอซู เปอะ ปุ แตะ ไม่ โม เซ เยอ, ไมจ เปอะ ปาึง แนฮ โตวต เซ เตือง ลอา อื. อาึ มัฮ พะจาว ยุฮ เปอะ. ซ โตก ละ โม เปะ ฆาื อื, ซ เรอึม โม เปะ เกือฮ โปน ฮา โม ป เกละยุ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","เญือม อาวต เปอะ ไม่ รพาวม ไมจ มวน เฮน ฮลอง แตะ, ไม่ เญือม ไก กัน ชลอง เปอะ ฮาวก เคิ โคระ, ไม่ เญือม ชลอง เปอะ ซเงะ ซัมคัน ยุฮ แตะ, เญือม ตอง เปอะ ทไว ซัตซิง ละ อาึ ไม่ ทไว เปอะ โอเอีฮ ละ ซ รโจะ ดิ เปอะ รพาวม แตะ ไม่ อาึ, ไมจ เปอะ ปาึง โตวต ยุฮ เปอะ เญือม เซ. เญือม เซ อาึ ซ โตก ละ เปอะ ฆาื อื. ซ เรอึม โม เปะ, นึง มัฮ อาึ เยโฮวา พะจาว ยุฮ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","เญือม เอีจ ไก อื ติ เนอึม ไปล ลอา เคิ ฟวยจ โอก โม อิซราเอน ฮา เมือง อียิป เปอ, ปุก ฮาวก เคิ ลอา เซ ง่า ซาวม, ชุต รวู อาวต ราว พากัง นา ก อาวต พะจาว เซ เฌาะ ติ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","เญือม เซ โม อิซราเอน โอก โฮว เน่อึม นึง ลาึน ซีไน. ชุต รวู ซัมคัน เซ โฮว ลโล่ะ นึง ลาึน ปารัน. ");
INSERT INTO lcp_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","มัฮ เญือม เซ เญือม โอก โฮว โรง โม อิซราเอน ตัม ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ เยอ. ");
INSERT INTO lcp_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","เญือม โอก โฮว อื โครยญ โฮน, มัฮ โม ยูด่า นึง อื ป โอก โฮว ไม่ โทง ยุฮ แตะ รกา ปุย. ซ โอก โฮว แปน มูๆ แตะ. ป ควป คุม โม เซ มัฮ นาโชน กวน อัมมีนาดั่ป. ");
INSERT INTO lcp_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ป ควป คุม เจอ อิตซาคา นึง อื มัฮ เนทันเอน กวน ซุอา. ");
INSERT INTO lcp_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ป ควป คุม เจอ เซบู่ลุน นึง อื มัฮ เอลีอัป กวน เฮโลน. ");
INSERT INTO lcp_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","เญือม เอีจ ฟวยจ เต ปุย พากัง ระ เซ, โม เกอโชน ไม่ โม เมรารี ป กลอม โรวก เครอึง พากัง ระ เซ โอก โฮว โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ฟวยจ เซ โม รูเบ่น โอก โฮว โรฮ ไม่ โทง ยุฮ แตะ แปน มูๆ แตะ. ป ควป คุม เจอ รูเบ่น เซ มัฮ เอลีซู กวน เชเด่เออ. ");
INSERT INTO lcp_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ป ควป คุม เจอ ซิเมโอน มัฮ เชลูมิเอน, กวน ซุรีชัตได่. ");
INSERT INTO lcp_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ป ควป คุม เจอ กาต นึง อื มัฮ เอลียาซัป กวน เด่อูเอน. ");
INSERT INTO lcp_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ฟวยจ เซ โม โคฮัต ป กลอม โรวก โอเอีฮ ซัมคัน ยุฮ พะจาว เซ โอก โฮว โรฮ. ไน ติ เจน ซ ฮอยจ โม เซ, ปุย ไฮญ เอีจ ฟวยจ โบลวง อื พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ฟวยจ เซ โม เอฟราอิม โอก โฮว โรฮ ไม่ โทง ยุฮ แตะ, แปน มูๆ แตะ. ป ควป คุม เจอ เอฟราอิม เซ มัฮ เอลีชามา กวน อัมมีฮุต. ");
INSERT INTO lcp_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ป ควป คุม เจอ มะนาเซ นึง อื, มัฮ กามาลิเอน กวน เปด่าซู. ");
INSERT INTO lcp_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ป ควป คุม เจอ เบ่นยามิน นึง อื, มัฮ อาบี่ดั่น กวน กิเด่โอนี. ");
INSERT INTO lcp_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ฟวยจ เซ โม ด่าน ป มัฮ มู รเคะ นึง อื เซ โอก โฮว โรฮ ไม่ โทง ยุฮ แตะ แปน มูๆ แตะ. ป ควป คุม เจอ ด่าน เซ มัฮ อาฮิเยเซอ กวน อัมมีชัตได่. ");
INSERT INTO lcp_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ป ควป คุม เจอ อาเชอ นึง อื มัฮ ปากีเอน กวน โอครัน. ");
INSERT INTO lcp_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ป ควป คุม เจอ นัปทาลี นึง อื มัฮ อาฮิรา กวน เอนัน. ");
INSERT INTO lcp_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","เญือม เฌาะ โม อิซราเอน ไคะ อาวต แตะ, ซ โอก โฮว แปน มูๆ แตะ ตัม ไล อื ตอก เซ โครยญ โฮน. ");
INSERT INTO lcp_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","โฮบั่ป กวน เรอูเอน ป มัฮ โม มีเดี่ยน เซ, มัฮ เชือก ไอ โมเซ. เญือม เซ ไอ โมเซ อัฮ อื ละ เชือก แตะ เซ ตอก เฮี, “เชือก, โม เอะ กัมลัง ซ โฮว ฮอยจ นึง ปลัฮเตะ ป อัฮ พะจาว ติ แตะ ซ เกือฮ ละ เอะ เซ. พะจาว เอีจ ซันญา ซ เกือฮ แตะ โม อิซราเอน จเลิน ปุๆ. โฮว, โฮว ดิ ไม่ เอะ และ, เอะ ซ รฆุ โรฮ โอเอีฮ ป ไมจ ยุฮ แตะ ละ เมะ ง่อน โรฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","โฮบั่ป เซ ปังเมอ โลยฮ อื ตอก เฮี, “อาึ เกียฮ โฮว โตว ยุ่ง. อาึ ซ เอีญ ฮอยจ นึง เมือง โกะ แตะ. ซ เอีญ อาวต ไม่ คระ เฌือต โกะ แตะ ไอฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ไอ โมเซ อัฮ แม เฮี ละ อื, “ปัว เมะ โอ ละ โปวฮ เอะ. เอีจ ยุง เมะ ตอก มัฮ นาตี ลาึน ซออฮ เฮี, ไม่ ยุง เมะ นา ก ปุก อื ละ ยุฮ เอะ ไคะ อาวต แตะ. ซ เกียฮ แปน โรฮ เมะ ป นัม คระ ละ เอะ. ");
INSERT INTO lcp_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ดัฮ เมะ โฮว ไม่ เยอะ โฮ, เอะ ซ รฆุ เนอึม ป ไมจ โฮลฮ แตะ เน่อึม นึง พะจาว ละ เมะ,” อัฮ เซ ละ อื. (เญือม เซ แปน เนอึม โฮว ไม่ อื ฆาื อื.) ");
INSERT INTO lcp_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","โม ปุย โฮวน เซ โอก โฮว เนอึม ฮา บลาวง ซีไน เซ ลอวย ซเงะ คระ. โม ป กลอม โรวก ฮิต ลปุง ซันญา เซ โฮว รกา, ละ ซ ซาวป อื นา ก ยุฮ อื ไคะ อาวต แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","เญือม ซ เฌาะ โม เซ ไคะ อาวต แตะ เญือม ออฮ เญือม เอีฮ ญุ่ก, ป มัฮ ชุต รวู ซัมคัน เซ ซ อาวต ราว อื เมือ ซเง่ะ อื โครยญ โฮน. ");
INSERT INTO lcp_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","เญือม ซ โอก โฮว โม ป กลอม ฮิต ลปุง ซันญา เซ, เญือม ออฮ เญือม เอีฮ ญุ่ก, ไอ โมเซ ซ ปัว อื นึง พะจาว ตอก เฮี, “โอ พะจาว, ปัว เปอะ โกฮ โฮว ยุฮ ไลจ ไม่ โม ป เกละยุ เปอะ เซ. เกือฮ แตก เฮีย เตือง โอยจ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","เญือม เอีจ ลโล่ะ อื, ซ ปัว แม อื นึง พะจาว ตอก เฮี, “โอ พะจาว, ปัว เปอะ เอีญ เคะ โม อิซราเอน, ป ไก แปน ฮมาึน แปน แซน แตะ เซ เมิฮ,” อัฮ โรฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","กังเคะ เอ ปุย โฮวน เซ รักเริ เติ พะจาว นึง ญัก โอเอีฮ ละ แตะ. พะจาว ฮมอง ป อัฮ อื เซ. ฮาวก รพาวม ฆาื อื, เกือฮ งอ ฮอยจ ละ อื ฆาื อื. งอ เซ ฮะ ยุฮ พากัง อาวต ปุย ลวง เฆียง ไคะ ง่อน. ");
INSERT INTO lcp_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ปุย เตือง โอยจ อื รโอง ปัว ไอ โมเซ เรอึม แตะ ฆาื อื. เญือม ไววอน ไอ โมเซ ปัว นึง พะจาว เยอ, งอ เซ ญึ่ต เอิน. ");
INSERT INTO lcp_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","เคียง เซ นาตี เซ ปุย อัฮ ทาเบ่รา ไม่ อื, นึง ฮอยจ งอ เน่อึม นึง พะจาว ไม่ ฮะ อื ยุฮ โอเอีฮ นา เซ ลลาึง ปุย โฮวน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ปุย ตังเมือง ป โฮว ดิ ไม่ โม อิซราเอน เซ ไก รพาวม ฆวต ปอน ลัมเลือ โตะ. ปัง มัฮ โม อิซราเอน ปุปิ โรฮ ไม่ เยือม แตะ, อัฮ อื ตอก เฮี, “มัฮ ปุย ป ซ เกือฮ โตะ ละ เอะ เอ? ");
INSERT INTO lcp_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","เอะ ไตม เมอะ เญือม อาวต ลั่ง เงอะ เมือง อียิป โฮ, มวน เนอึม เนิ. โฮลฮ ปอน ลอป โตะ กะ ไม่ โอเอีฮ ญึม. โฮลฮ โซม ซัก กุก เตือ, โฮลฮ โซม แก โซม มตาว, โฮม ระ โฮม บิญ โฮม ซครัก ไม่ โอเอีฮ ไฮญ โฮวน เจือ เตือง โอ แตะ โฮลฮ รวี. ");
INSERT INTO lcp_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","ปเลี่ย เฮี ชุมเรียง เงอะ. ไก โตว ป โซม ป ปอน ติ เจือ เนอึม. มัฮ ลอป เอิน มานา งา เฮี ติ เจือ โน่ง ป โฮลฮ โฮะ โซม เมอ,” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","มานา อัฮ อื เซ มัฮ ตอก โนง โซง โฮ, ซี อื ปิญ แกม ซเงี. ");
INSERT INTO lcp_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","ราื ก อาวต ปุย เมือ ก ซาวม อื, บรุก ราื ไม่ รอาวม รน่ะ. ปวยฮ พริ ปุย กอ โฮว ซาวป ไรฮ อื. โตฮ อื เกือฮ แปน แปง. โกยฮ อื ง่อน. แมน อื แปน แฮลป แปน แฮลป แตะ, กา อื ง่อน. ญึม งา อื ตอก คโนมปัง ยุฮ ปุย ไม่ ลออยฮ กาวก โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ปุย ชุง โบ โตะ รเวือะ พากัง ยุฮ แตะ เตือง ไพ เตือง มัน, รักเริ เติ ป โซม แตะ ตอก เซ. เญือม เซ พะจาว รอก เนอึม พาวม นึง ปุย โฮวน เซ. ไอ โมเซ เญือม ฮมอง อื โอเอีฮ ตอก เซ, ตุก โรฮ รพาวม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","อัฮ เฮี ละ พะจาว, “เมอยุ เกือฮ เปอะ อาึ ลอก ป ญัก ลัมเลือ ตอก เฮี? มัฮ กัน เมอ ป ยุฮ อาึ ป โอ อื ปุก พาวม เปอะ นึง อื? เมอยุ เกือฮ เปอะ อาึ โฮลฮ ระ รบุยฮ เชียน ลกลอม นึง ปุย โฮวน เฮี? ");
INSERT INTO lcp_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","อัม มัฮ อาึ ป มัฮ เปือะ ปุย โม เฮี? อัม เกิต เน่อึม นึง อาึ? เมอยุ เกือฮ เปอะ อาึ โงก โรวก ปุย โฮวน เฮี ตอก แลน ปุย กวนงัก โฮ? อัม มัฮ ซ เกือฮ เปอะ อาึ โอม โรวก นึง เตะ แตะ ฮอยจ นึง เมือง ซันญา เปอะ อาึง ละ จัตเจือ ไพรม อื เซ? ");
INSERT INTO lcp_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ปุย โม เฮี เยือม แนฮ ละ อาึ นึง ฆวต ปอน แตะ โตะ. อาึ ซ โฮลฮ ละ อื ก เมอ ก โอวน โตะ ปอ ปอน ปุย โฮวน ตอก เฮี? ");
INSERT INTO lcp_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","อาึ ปุน โอม โน่ง โตว โรวก ปุย โม เฮี, เชียน ลอน เนิ. ");
INSERT INTO lcp_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","ดัฮ เปอะ ซ ยุฮ แนฮ ละ อาึ ตอก เฮี, ปัว เปอะ เลียก พาวม นึง เงอะ. ยุฮ แปฮ ยุม ไม่ อาึ เฮี เดอึม อาึ โอ เญือะ ซ โฮลฮ ยุ เม่ะมั่ก แตะ,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ ซาวป ปุย ลลาึง โม อิซราเอน เฮี อาลแฆลฮ ปุย ป มัฮ ป กวต ป เฮียง, ป ยุง ปะ มัฮ อื ป เกียฮ แนะนัม ปุย ไม่ เกียฮ รเตีฮ รตุม อื โอเอีฮ ละ ปุย. เกือฮ ฮอยจ นึง พากัง ระ ก ฮอยจ ปุย เคะ อาึ. เกือฮ ชุง ดิ ไม่ ปะ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","อาึ ซ เลีฮ ลปุง ไม่ เปอะ นา เซ. อาึ ซ ตุย ลปุ แตะ ป อาวต นึง ปะ ฮา เปอะ ง่อน, ซ เกือฮ ละ โม เซ. ฟวยจ เซ โม เซ ซ เกียฮ เรอึม ปะ กลอม ดิ ป เชียน นึง ปุย โฮวน เฮี เดอึม ปะ โอ เญือะ ซ โฮลฮ กลอม โน่ง,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","พะจาว ดวน ไอ โมเซ อัฮ อื ละ ปุย โฮวน เซ ตอก เฮี, “ไมจ เปอะ เพรียง ติ แตะ ละ ซง่าวป เกือฮ ติ เปอะ แปน ปุย ซง่ะ ไล. ซ โฮลฮ เปอะ ปอน โตะ โอ. พะจาว เอีจ ฮมอง อัฮ เปอะ ติ แตะ ฆวต ปอน ลัมเลือ โตะ, ปอ เอิน อัฮ เปอะ ตอก เฮี ไม่ เยือม แตะ. ‘มัฮ ปุย ป ซ เกือฮ โตะ ละ เอะ เอ? เญือม อาวต เตอะ เมือง อียิป โฮ, เอีจ มวน ลัมเลือ เนิ,’ อัฮ เปอะ เซ. พะจาว ซ เกือฮ เนอึม โม เปะ โฮลฮ ปอน อื ปอ ซัก ปอ เตือ เปอะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","มัฮ โตว ซ โฮลฮ เปอะ ปอน ติ ลอา ซเงะ, พอน แลฮ ซเงะ, กาว ง่า ซเงะ โน่ง. ");
INSERT INTO lcp_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ซ โฮลฮ เอิน เปอะ ปอน แปน เคิ อื. ซ เตือ ซ ออป เอิน เปอะ นึง, ปอ ฆวต ฮาว แตะ. ซ เกละ เอิน เปอะ ยุ. มัฮ ฆาื โอ เปอะ ฆวต เกือฮ เนอึม พะจาว อาวต ลลาึง เปอะ. เติ ลอป เปอะ พะจาว. อัฮ แนฮ เปอะ มัฮ ป โซะ ละ แตะ โฮลฮ แตะ โอก ฮา เมือง อียิป เซ,” อัฮ เซ ละ อื พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ไอ โมเซ อัฮ เฮี ละ พะจาว, “อาึ อาวต ดิ นา เฮี ไม่ ปรเมะ ป แปน ตฮัน แลฮ แซน ปุย. ปะ เกียฮ อัฮ โน่ง เปอะ ติ แตะ ซ เกือฮ โตะ ละ อื ปอ ปอน อื แปน เคิ อื เมอ? ");
INSERT INTO lcp_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ปัง มอก เกอะ โมวก ไม่ ปิ ไม่ แกะ ป โฮว ไม่ เอะ เฮี เตือง โอยจ อื แจง โอ อื ปอ ปอน อื. ปัง ปุน แม กะ ติ ปลัฮ รอาวม ปุ โรฮ ซ ปอ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","พะจาว โลยฮ อื ละ ไอ โมเซ ตอก เฮี, “อัม มัฮ แกต เปอะ อัมนัต พะจาว โอ ปอ? ป อัฮ อาึ ซ เกิต เซ ปเลี่ย เฮี ซ ยุ เปอะ ตอก เกิต เนอึม อื ไม่ โอ อื เกิต เตอ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ไอ โมเซ โอก ก พริ. รโฮงะ อื ละ ปุย ป อัฮ พะจาว ละ แตะ เซ. กอก เนอึม โม ป กวต ป เฮียง อาลแฆลฮ ปุย เซ. เกือฮ อื ชุง รวิต รเวียง พากัง ระ. ");
INSERT INTO lcp_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","เญือม เซ พะจาว เลีฮ ละ อื นึง ชุต รวู ลปุง ไม่ อื. ตุย เนอึม ลปุ แตะ ป อาวต นึง ไอ โมเซ เซ ง่อน, เกือฮ อื อาวต นึง โม ป กวต อาลแฆลฮ ปุย เซ. เญือม เอีจ อาวต ลปุ พะจาว นึง อื, โม ป กวต เซ เกียฮ ซึป โรฮ ลปุง พะจาว ละ ปุย ปังเมอ เกียฮ ซึป อื ติ โฮน เซ โน่ง. ");
INSERT INTO lcp_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ไน โม ป กวต ป เฮียง อาลแฆลฮ ปุย เซ ไก ลอา ปุย ป อาวต ลั่ง นึง ไคะ เยอ, มอยฮ อื มัฮ เอนดั่ต ไม่ เมดั่ต. ปุย ลอา เซ โอก รโจะ ดิ โตว ไม่ ปุย ไฮญ ป รโจะ ดิ โบ พากัง ระ เซ. ลปุ พะจาว เลีฮ อาวต โรฮ นึง ปุย ลอา เซ, เกือฮ โรฮ อื เกียฮ ซึป ลปุง พะจาว โรฮ, ซึป เอิน ลปุง พะจาว นึง ไคะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","เญือม เซ ไก ปรเมะ นุม ติ ปุย, ตอ โฮว รโฮงะ อื ละ ไอ โมเซ ตอก เฮี, “เอนดั่ต ไม่ เมดั่ต กัมลัง ซึป ลปุง พะจาว นึง ไคะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","เญือม เซ โยชูวา กวน นูน, ป โกย แปน แตะ ป เรอึม ไอ โมเซ เน่อึม เญือม นุม ลั่ง แตะ อัฮ เฮี ละ ไอ โมเซ, “จาวไน, ไมจ เปอะ คัต โอ เญือะ ยุฮ เญือะ อัฮ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ไอ โมเซ อัฮ เฮี, “อัม มัฮ ฮอ ลอน เปอะ นึง ฮลัต แตะ ปุย โอ เญือะ ซ นัปทื อาึ ฆาื อื? อาึ ฆวต เกือฮ พะจาว เกือฮ ลปุ แตะ อาวต นึง ปุย ไน แตะ โครยญ โฆะ ปุย, ละ ซ เกือฮ อื เกียฮ ซึป ลปุง พะจาว เตือง โอยจ แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ฟวยจ เซ ไอ โมเซ ไม่ โม ป กวต ป เฮียง เซ เอีญ นึง ไคะ เตือง โอยจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","เญือม เซ พะจาว เกือฮ กาื ระ ฮอยจ. กาื เซ โรวก กึต เน่อึม นึง ปลัฮ รอาวม โฮวน. กึต เซ โปว ฮลาวง ฮา เตะ เมาะ ลอา รเนฮ โน่ง, เลีฮ อาวต นึง ไคะ อาวต ปุย ไม่ อาวต รวิต รเวียง อื โครยญ ลวง เมาะ ติ ซเงะ คระ โฮว ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","โม อิซราเอน โอก โฮว โฮมวต กึต เซ ลอา ซเงะ ไม่ ติ ซาวม บวยฮ. โฮลฮ เนอึม กึต เซ โฮวน. รมัฮ โตว ฮา ติ รอย ทัง ตอ ติ ปุย. ฮอก อื นึง กอยจ รวิต ก อาวต แตะ โครยญ ลวง. ");
INSERT INTO lcp_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ลไล กุก ลั่ง ปุย โตะ เซ พะจาว ฮาวก รพาวม ละ ปุย. เกือฮ ป โซะ ตอก ฮา เกิต ละ ปุย ปอ ยุม ปุย ฆาื อื โฮวน ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","นาตี เซ ลอต ปุย อัฮ “คิปโรต ฮัตทาวา” ไม่ อื, นึง โฮลฮ ปุย รมอยจ โม ป ฆวต ปอน ลอน โตะ นา เซ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ฟวยจ เซ ปุย โอก โฮว ฮา คิปโรต ฮัตทาวา ฮอยจ นึง นาตี ฮาเซโรต. ยุฮ แม ไคะ อาวต แตะ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ปรโปวน เญือะ ไอ โมเซ มัฮ ปุย เมือง คุต. ติ ซเงะ อื มิเรียม ไม่ อาโรน เติ ไอ โมเซ ฆาื ไอฮ อื ปุย เมือง คุต เซ. ");
INSERT INTO lcp_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","อัฮ โรฮ เฮี ไม่ อื, “อัม มัฮ ไอ โมเซ โน่ง ป เอีจ โฮลฮ พะจาว โกว ละ ซึป อื ลปุง แตะ? โม่ โรฮ เอีจ โกว เอะ โรฮ?” อัฮ เซ. พะจาว ฮมอง ป อัฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ไอ โมเซ มัฮ ปุย ปึกๆ ออนๆ ฮา ปุย ไฮญ ติ ปลัฮเตะ เอิน. ");
INSERT INTO lcp_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","เญือม เซ พะจาว อัฮ เอิน อื ละ ไอ โมเซ ไม่ อาโรน ไม่ มิเรียม เซ ตอก เฮี, “เกือฮ ติ เปอะ ฮอยจ นึง พากัง ก ฮอยจ ปุย เคะ อาึ เตือง ลอวย เปอะ,” อัฮ เซ ละ อื. ปุย ลอวย เซ ฮอยจ เนอึม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","พะจาว เลีฮ นึง ด่อง ชุต รวู เซ. ชุง โตะ รเวือะ พากัง ระ เซ. กอก อาโรน ไม่ มิเรียม ฮอยจ เคะ แตะ. ปุย ลอา เซ เลียก เอิน ซดิ. ");
INSERT INTO lcp_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","พะจาว อัฮ เฮี ละ อื, “ปเลี่ย เฮี ไมจ เปอะ ง่อต ป อัฮ อาึ. เญือม ซ ไก ป ซึป ลปุง อาึ ลลาึง โม เปะ เอ อาึ ซ เปลีฮ ติ แตะ ละ ปุย เซ ติ เจือ. ซ เกือฮ เกียฮ ยุ บลอง โอเอีฮ ง่อน. ซ รโฮงะ โอเอีฮ ละ นึง รโมะ อื ง่อน เดอึม ซ เกียฮ ฮมอง ลปุง อาึ. ");
INSERT INTO lcp_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ไอ โมเซ กวนไจ ยุฮ อาึ ปังเมอ ตัง ฮา เซ. อาึ เอีจ มอป กัน ละ เกือฮ แตะ แปน ป แลน แก ปุย ไน อาึ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","เญือม ลปุง อาึ ไม่ อื อาึ ลปุง ไม่ ซอง โต ซอง. อัฮ ลปุง ซโตฮ ละ. มัฮ โตว ลปุง ปันฮา. ไอ โมเซ ยุ เอิน อาึ นึง ไง่ แตะ. ตอก โตว ปุย ไฮญ. โม เปะ โรวต โน่ง เปอะ เติ ไอ โมเซ กวนไจ ยุฮ อาึ เซ เมอ?” อัฮ เซ ละ อื พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","พะจาว ฮาวก รพาวม ละ ปุย ลอา เซ, ลอต โฮว ฮา อื. ");
INSERT INTO lcp_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ลไล ฮาวก ชุต รวู เซ ฮา พากัง ระ เซ ปุย ยุ ลอก มิเรียม ลาวต. ฮัก อื ปิญ เอิน ตอก เตีย เปลาะ โฮ. เญือม ยุ อาโรน ลอก มิเรียม ลาวต ตอก เซ, ");
INSERT INTO lcp_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","อัฮ เฮี ฆาื อื ละ ไอ โมเซ, “จาวไน, ปัว เปอะ โอ เกือฮ เอะ ลอก ตุต ฆาื มั่ป พิต ยุฮ ฮุ เฮี. เอะ เอีจ พิต เนอึม เมอะ นึง งาวไงญ ลอน แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","ปุ เกือฮ มิเรียม แปน ตอก กวนงัก เกิต ไม่ ยุม แตะ ไม่ เอีจ ซเออึม เนะ แตะ บลัฮ ตอก เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","เญือม เซ ไอ โมเซ อัฮ เฮี เรียง, “โอ พะจาว, ปัว เปอะ เกือฮ มิเรียม ไฮ,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","พะจาว โลยฮ อื, “ปุย เยอ, เมาะ โดยจ เปือะ อื นา อื บ่ได่ะ, โม่ ซ อาวต ไม่ โซะกิจ ปิญไง่ แตะ ฆาื อื อาแลฮ ซเงะ เอิน? ไมจ เปอะ ทอเนาะ เกือฮ อาวต ก พริ ไคะ อาแลฮ ซเงะ. ฟวยจ เซ แปน เลียก อาวต แม อื ไม่ ปุย,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ปุย ทอเนาะ เนอึม มิเรียม อาวต ก พริ ไคะ ฆาื อื อาแลฮ ซเงะ. โม อิซราเอน ดิ โอก โฮว โตว ฮา นา เซ กา เฆียง เลียก อาวต ดิ แม มิเรียม เซ ไม่ ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ฟวยจ เซ ปุย โอก ฮา แควน ฮาเซโรต โฮว ยุฮ แม ไคะ อาวต แตะ นึง ลาึน ปารัน. ");
INSERT INTO lcp_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“ไมจ เปอะ เลือก โม ฮัวนา เมือง อิซราเอน เตือง กาว ลอา เจอ อื, ติ เจอ ติ ปุย. เกือฮ ปุย โม เซ โฮว เลียป โอเอีฮ นึง เมือง คะนาอัน, ป มัฮ เมือง เกือฮ อาึ ละ โม อิซราเอน,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ไอ โมเซ ยุฮ เนอึม อื ตัม ดวน พะจาว แตะ. เกือฮ อื โอก ฮา ลาึน ปารัน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","โม ฮัวนา เมือง อิซราเอน เซ มัฮ ตอก เฮี มอยฮ อื. เจอ รูเบ่น มัฮ ชัมมุวา กวน ซักเกอ. ");
INSERT INTO lcp_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","เจอ ซิเมโอน มัฮ ชาฟัต กวน โฮรี. ");
INSERT INTO lcp_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","เจอ ยูด่า มัฮ คาเลป กวน เยฟูเน. ");
INSERT INTO lcp_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","เจอ อิตซคา มัฮ อิกกัน กวน โยเซป. ");
INSERT INTO lcp_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","เจอ เอฟราอิม มัฮ โฮเชยา กวน นูน. ");
INSERT INTO lcp_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","เจอ เบ่นยามิน มัฮ ปันที กวน ราฟู. ");
INSERT INTO lcp_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","เจอ เซบู่ลุน มัฮ กัตเดี่ยน กวน โซดี่. ");
INSERT INTO lcp_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","เจอ มะนาเซ มัฮ กัตดี่ กวน ซุซี (มัฮ จัตเจือ โยเซป.) ");
INSERT INTO lcp_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","เจอ ด่าน มัฮ อัมมีเอน กวน เกมาลี. ");
INSERT INTO lcp_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","เจอ อาเชอ มัฮ เซทู กวน มีคาเอน. ");
INSERT INTO lcp_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","เจอ นัปทาลี มัฮ นาบี่ กวน โวซี. ");
INSERT INTO lcp_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","เจอ กาต มัฮ เกอูเอน กวน มาคี. ");
INSERT INTO lcp_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","มัฮ โม เซ ป เกือฮ ไอ โมเซ อื โฮว เลียป โอเอีฮ เมือง เซ. ไอ โมเซ เปียน มอยฮ โฮเชยา ป มัฮ กวน นูน เซ, อัฮ โยชูวา ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","เญือม ซ เกือฮ ไอ โมเซ ปุย โม เซ โฮว เยอ, อัฮ อาึง เฮี ละ อื, “ไมจ เปอะ ฮาวก ก ล่าวง. ซ ฮอยจ เปอะ นึง ลาึน เนเกป นึง เมือง คะนาอัน เซ รกา. เญือม เอีจ ลอต เปอะ ฮา นา เซ ซ ฮอยจ แม เปอะ นึง นาตี โฮวน บลาวง โฮวน ฌื นึง. ");
INSERT INTO lcp_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ซาวป แลน ตอก มัฮ ตอก มอยฮ เมือง เซ เยอ. ปุย นึง อื อัม โฮวน, อัม รมัฮ? อัม ฮัง ซ ชุมเรียง, อัม ฮัง ซ ระ เรียง? ");
INSERT INTO lcp_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ซาวป แลน นาตี อาวต อื. อัม ไมจ, อัม ฆอก? ย่วง อาวต อื, อัม ไก ฆรุง, อัม อาวต เตือง เซ? ");
INSERT INTO lcp_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","เตะ ซมา ปุย โอเอีฮ นึง อื, อัม ไมจ อัม ฆอก? อัม โฮวน โคะ ป โซม ปุย นึง อื? ไมจ เปอะ ตุย รพาวม กา แตะ, ไมจ เปอะ เปฮ โรวก เปลิ โคะ นึง อื ง่อน เกือฮ เอะ ยุ,” อัฮ เซ ละ อื. (เญือม เซ ปุก เญือม ตึม โรง เปลิ อะงุน.) ");
INSERT INTO lcp_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","ปุย โม เซ โฮว เนอึม ฆาื อื. ฮาวก ลั่กล่าวง ปุ ปุ. เลียป แลน เมือง เน่อึม นึง ลาึน ซิน ฮอยจ ละ ย่วง เรโฮป ป ซดิ ไม่ เงียก ฮามัต. ");
INSERT INTO lcp_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","เลียก แลน ลั่กเซฮ รกา. ฮอยจ เวียง เฮปโรน. เฮปโรน เซ มัฮ ก อาวต โม อานัก. เญือม เซ ไก ลอวย ปุย ป ระ มอยฮ ลลาึง โม เซ. มัฮ อาฮิมัน ไม่ เชไช ไม่ ทันไม. (เวียง เฮปโรน เซ มัฮ เวียง ไพรม. โก ปุย กา เวียง โซอัน เมือง อียิป อาแลฮ เนอึม.) ");
INSERT INTO lcp_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","โม ป เลียป โอเอีฮ เซ ฮอยจ โตะ โลก เอตชโคน. ตอยฮ เปลิ อะงุน นา เซ ติ ซฆลาวม. เปลิ อะงุน ติ ซฆลาวม เซ ระ ปอ จัมเปน อื ไอฮ ปุย ละ ลอา, ละ ซ กลอม อื นึง โคะ ลกลอม. เปฮ โรฮ โรวก เปลิ ทัปทิม ไม่ เปลิ เม เมือง เซ ง่อน. ");
INSERT INTO lcp_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","โตะ โลก เซ ลอต ปุย อัฮ โตะ โลก เอตชโคน ไม่ อื นึง เปฮ ปุย เปลิ อะงุน นา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","26","เญือม เอีจ ไก อื รปาวน ซเงะ โฮว โม ป โฮว เลียป เมือง เซ, โม เซ โกฮ เอีญ ฮอยจ เคะ ไอ โมเซ ไม่ อาโรน ไม่ โม อิซราเอน เตือง มู แตะ. ปุก เญือม อาวต โม ลัปซด่อน ย่วง คาเด่ต นึง ลาึน ปารัน. โม ป โฮว เซ รโฮงะ ป ยุ ป ฮมอง แตะ เซ ละ ปุย. เปลีฮ โรฮ เปลิ โคะ โรวก แตะ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","อัฮ เฮี ละ ไอ โมเซ, “เอะ โฮว แลน เนอึม เมอะ เมือง ดวน ปะ แตะ แลน เซ, มัฮ เนอึม เมือง ตึม โครยญ โคะ โกะ โครยญ โกลง ตอก อัฮ เปอะ. แลน เมิฮ เปลิ โคะ นึง อื เฮี. ไมจ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ปุย นึง อื ปังเมอ ระ ลัมเลือ เรียง. เวียง นึง อื ระ, ไม่ ตอน โฮฮ ฆรุง อื. โนก ฮา เซ เอะ ยุ จัตเจือ อานัก นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","โม อามาเลก อาวต นึง ลาึน เนเกป นึง อื. โม ฮิตไท ไม่ โม เยบุ่ต ไม่ โม อาโมไร อาวต นึง บลาวง นึง อื. โม คะนาอัน อาวต โบ ปลัฮ รอาวม ง่อน. อาวต โรฮ นึง โตะ โลก จอแด่น ง่อน,” อัฮ เซ โม ป เลียป เมือง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","เญือม เซ คาเลป ดวน ปุย โฮวน เซ อาวต โฆย. อัฮ เฮี ละ อื, “ไมจ เอะ ฮาวก เกือฮ ติ แตะ ปุน เป เมือง เซ. แจง ซ เป เยอ,” อัฮ เซ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ปุย ไฮญ ป โฮว ไม่ อื ปังเมอ อัฮ เฮี, “เอะ แจง โอ ปุน ตอซู ไม่ ปุย โม เซ. ระ ลัมเลือ เรียง ฮา เอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","ซาวป เพียก แฮม เมือง เลียป แตะ เซ. เกือฮ ปุย แกต อื มัฮ ป โอ ไมจ. อัฮ เฮี, “เมือง โฮว แลน เอะ เซ มัฮ เมือง กอยจ เมือง ราวม. เยือ โซะ ยุม ปุย นึง. ปุย อาวต นึง อื ระ ฮลาวง ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","เอะ ยุ โรฮ โม เนฟิน นา เซ. เญือม แพป ติ แตะ ไม่ โม เซ เอะ อาวม เอิน แตวะ แตะ ตอก จักจัน โฮ. โม เซ เญือม ยุ อื เอะ ตอก โรฮ ยุ อื จักจัน โรฮ,” อัฮ เซ. โม เนฟิน อัฮ อื เซ มัฮ จัตเจือ อานัก. ");
INSERT INTO lcp_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ซาวม เซ ปุย โม เซ เยือม เรียง ติ ซาวม บวยฮ เตือง มู แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","โม อิซราเอน เตือง โอยจ อื เติ เนอึม เติ แนม ไอ โมเซ ไม่ อาโรน. อัฮ เฮี ละ อื, “มัฮ ยุม นึง เมือง อียิป ญุ่ก นึง ลาึน เวือฮ ญุ่ก ไมจ เดียก เนิ. ");
INSERT INTO lcp_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","พะจาว เมอยุ ซ ตาว อื เอะ ฮอยจ เมือง เซ? เอะ ซ ยุม เยือ นึง รุป แตะ. ปรโปวน เญือะ อะ ไม่ กวน เนอะ ซ โฮลฮ แปน ครา ปุย. มัฮ แม เยอะ ลั่กเคะ แตะ ฮอยจ นึง เมือง อียิป โม่ ซ ฌักแฟน ฮา เฮี?” อัฮ เซ เตือง มู แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","บะ ปุ แตะ แม ฆาื อื. อัฮ เฮี, “ไมจ เอะ เลือก แม ฮัวนา โคระ ยุฮ แตะ ละ ซ นัม อื เอะ เกือฮ แม ฮอยจ เมือง อียิป,” อัฮ เซ ละ ปุ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","เญือม เซ ไอ โมเซ ไม่ อาโรน ตุก ลัมเลือ รพาวม ฆาื อื. ไอจ รเคอึป ลังเตะ ซองนา โม อิซราเอน ป รโจะ รเจอึม นา เซ เตือง มู อื. ");
INSERT INTO lcp_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","โยชูวา กวน นูน ไม่ คาเลป กวน เยฟูเน มัฮ โรฮ ไน โม ป โฮว ซาวป เลียป เมือง เซ, แจฮ ไอฮ เครอึง แตะ นึง ตุก รพาวม แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","อัฮ อื ละ ปุย เตือง โอยจ อื เซ ตอก เฮี, “เมือง โฮว ซาวป เอะ เลียป แลน เซ มัฮ เมือง ตึก นึง ไมจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","พะจาว ดัฮ เอะ ปุก รพาวม อื โฮ ตึน ซ นัม เอะ เลียก อาวต นึง เมือง เซ ไม่ ซ เกือฮ อื แปน คอง เอะ. มัฮ เนอึม เมือง ตึม โครยญ โคะ โกะ โครยญ โกลง เอิน. ");
INSERT INTO lcp_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","ปุ เกือฮ ติ เปอะ ฆวต เลฮ เตียง ป อัฮ พะจาว. ปุ ฮลัต นึง ปุย เมือง เซ, เอะ แจง ซ เป เยอ. ปุย โม เซ เญือะ ไก โตว ตัว เปิง. พะจาว เอีจ อาวต ไม่ เอะ. ปุ เญือะ ฮลัต นึง,” อัฮ เซ โยชูวา ไม่ คาเลป เซ. ");
INSERT INTO lcp_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","โม ลัปซด่อน เตือง โอยจ อื เญือม ฮมอง อื ป อัฮ ปุย ลอา เซ บะ เอิน ปุ แตะ แล่น อื นึง ซโมะ. เญือม เซ รัง ซเปีย ยุฮ พะจาว ปลาึฮ พราวป นึง พากัง ก ฮอยจ ปุย เคะ พะจาว. โม อิซราเอน โฮลฮ ยุ อื เตือง โอยจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ปุย โฮวน เฮี ซ เลี่ญ แม เมาะ เมอ แล ซ เพียก แฮม อื อาึ อื? ซ เลี่ญ เมาะ เมอ แล ลึง รพาวม อื โอ แนฮ อื ญอม เจือ อาึ อื? เอีจ โฮวน ลัมเลือ กัน ซัมคัน ยุฮ อาึ ลลาึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","อาึ ซ เกือฮ ยุม โอยจ นึง พาญัต ฆอก ปอ ดุต ปอ ลอยจ เอิน จัตเจือ อื. ฟวยจ เซ ซ เกือฮ จัตเจือ ปะ แปน เมือง ระ ฮา ปุย โม เฮี. ซ เกือฮ เยอะ ระ เรียง ระ แด่น ฮา อื ไม่ อื,” อัฮ เซ ละ ไอ โมเซ พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ไอ โมเซ โลยฮ อื ละ พะจาว ฆาื อื ตอก เฮี, “โอ พะจาว, ปะ เอีจ นัม เปอะ ปุย โม เฮี โอก ฮา เมือง อียิป เบือ อัมนัต ระ แตะ. ดัฮ เปอะ ยุฮ เนอึม ตอก อัฮ เปอะ เซ โม อียิป ตึน ซ ฮมอง อื. ");
INSERT INTO lcp_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ซ รโฮงะ อื ละ ปุย อาวต เมือง เฮี เกือฮ ยุง ไลลวง อื. ปุย อาวต นา เฮี เอีจ ฮมอง ตื อื ตอก อาวต ปะ ไม่ เอะ เอ. เอีจ ฮมอง โรฮ อื ตอก เปลีฮ เปอะ ติ แตะ ละ เอะ นึง ชุต รวู ไม่ ตอก โฮว เปอะ กา เอะ นึง ด่อง ชุต รวู เมือ ซเง่ะ อื ไม่ ด่อง งอ เมือ ก ซาวม อื. ");
INSERT INTO lcp_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","16","ปเลี่ย เฮี ดัฮ เปอะ ยุฮ เนอึม ยุม ไม่ ปุย ไน แตะ ตอก เซ โฮ, เมือง ปุย ไฮญ ป เอีจ ฮมอง ไลลวง ยุฮ เปอะ ตึน ซ อัฮ ปะ ยุฮ ยุม ไม่ ปุย ไน แตะ นึง ลาึน เวือฮ เซ, นึง โอ เปอะ ปุน นัม เกือฮ ฮอยจ เนอึม เมือง ซันญา เปอะ อาึง ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“โอ พะจาว, ปัว เปอะ เปลีฮ อัมนัต ระ แตะ ไม่ ยุฮ เนอึม เปอะ ตัม ป ซันญา แตะ อาึง. ");
INSERT INTO lcp_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","เอีจ อัฮ เปอะ ติ แตะ มัฮ พะจาว อาวต ไม่ ลั่ง รพาวม แตะ. อาวต ลอป เปอะ ไม่ รพาวม ฮรัก ตอน ฮมัน แตะ. ละ ป ยุฮ ป พิต ไม่ เลฮ อื เตียง ป อัฮ เปอะ, ปะ อัฮ ลั่ง เปอะ ติ แตะ ซ ยวก มั่ป กัฮ ตุต ละ อื. ปัง มัฮ ตอก เซ ปะ ปังเมอ อัฮ โรฮ เปอะ ติ แตะ ซ เกือฮ ปุย พิต ลอก ตุต แตะ ฮอยจ ละ กวน อื ไม่ กวนโซะ อื ฮอยจ ลอวย ปาวน เจน ปุย, ");
INSERT INTO lcp_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","เคียง มัฮ อื ตอก เซ อาึ ฆวต ปัว นึง เปอะ ติ เจือ. เอีจ อาวต เปอะ ไม่ รพาวม ฮรัก ตอน ฮมัน แตะ. ปัว เปอะ ยวก มั่ป กัฮ ตุต ยุฮ ปุย โฮวน เฮี เบือ อื, ตอก เอีจ กอ ยวก ไพรม เปอะ ละ อื เน่อึม เญือม โอก โรง อื ฮา เมือง อียิป ฮอยจ ปเลี่ย,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","พะจาว โลยฮ อื, “อาึ ซ ยวก ละ อื ตัม ป ปัว เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ตอก ออฮ ตอก เอีฮ ญุ่ก แจง ไอม อาึ ตอก ออฮ, ไม่ แจง ซ นาวก ปลัฮเตะ นึง รังซเปีย คึนัก ยุฮ ฮุ ตอก ออฮ, ");
INSERT INTO lcp_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","โม ป เอีจ ยุ รังซเปีย ยุฮ ฮุ เฮี แจง โรฮ โอ อื ซ ไก ติ ปุย เนอึม ป ซ โฮลฮ เลียก ยุ เมือง โคระ เซ. เอีจ มัฮ เมือง ซันญา อาึ อาึง ละ จัตเจือ ไพรม อื. โม เฮี ปัง ยุ อื กัน ซัมคัน ยุฮ อาึ นึง เมือง อียิป เปอ, ฮอยจ ละ กัน ซัมคัน นึง ลาึน เวือฮ เซ, เลฮ ลั่ง เตียง ป อัฮ อาึ. เอีจ ลอง รพาวม อาึ กาว โฮน เอิน, โม ป เพียก แฮม อาึ ตอก เซ ซ โฮลฮ โตว ยุ เมือง โคระ เซ ติ ปุย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","คาเลป ป มัฮ กวนไจ อาึ เซ ปังเมอ ไก รพาวม ตัง โน่ง ฮา ปุย โม เซ. มัฮ ปุย ฆวต เนอึง ป อัฮ อาึ. คาเลป เซ อาึ ซ นัม เกือฮ ฮอยจ นึง เมือง โฮลฮ อื โฮว เลียป แลน เซ. ซ โฮลฮ เนอึม อื แปน คอง แตะ เตือง จัตเจือ อื ฮอยจ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ปเลี่ย เฮี โม อามาเลก ไม่ โม คะนาอัน เอีจ อาวต นึง ลโลวง ก เซฮ เฮี. ซง่าวป โม เปะ ไมจ เปอะ แม ลั่กเคะ แตะ ฆาื อื ฮอยจ นึง ลาึน เวือฮ, ตัม คระ โฮว ปุย ฮอยจ นึง ปลัฮ รอาวม ซครัก โฮ,” อัฮ เซ ละ ปุย โฮวน เซ พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","พะจาว อัฮ เฮี ละ ไอ โมเซ ไม่ อาโรน, ");
INSERT INTO lcp_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ปุย ฆอก ปุย เบร เฮี ซ รักเริ เติ อาึ เลี่ญ แม เมาะ เมอ แล? อาึ เอีจ ซัก เอีจ เตือ นึง ฮมอง แตะ เติ ลอป โม เฮี แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","ไมจ เปอะ ซึป ลปุง อาึ ละ อื ตอก เฮี, ‘แจง ไอม อาึ ตอก ออฮ, อาึ ซ เกือฮ เนอึม เกิต ละ เปอะ ตอก เซ. อาึ ซ ยุฮ ละ เปอะ ตัม รซอม โกะ เปอะ ไอฮ นึง เอีจ ฮมอง เงอะ ป อัฮ โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","โม เปะ ซ ยุม เฮีย ยุม ไฮ เนอึม เปอะ นึง ลาึน เวือฮ เฮี. เมาะ ป ไก อาญุ เคียง ง่า เนอึม ฮาวก ก ล่าวง, เอีจ มัฮ โม ป เมีญ ปุย เญือม โจต ปุย เซน ปุย โฮ, โม เปะ ป เติ อาึ อื ซ โฮลฮ เปอะ โตว เลียก นึง ปลัฮเตะ โคระ เซ ติ ปุย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","เมือง ป ซันญา อาึ อาึง ละ ซ เกือฮ แตะ โม เปะ อาวต นึง เซ, ไก โตว ติ ปุย เนอึม ป ซ โฮลฮ อาวต นึง อื โนก ฮา คาเลป ไม่ โยชูวา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","ไลลวง กวน เปอะ ป อัฮ โม เปะ ซ โฮลฮ แปน ครา ปุย โฮ, โม กวน เปอะ เซ อาึ ซ เกือฮ อาวต ซไบ่ นึง เมือง โอ โม เปะ ฆวต ไอฮ เซ. ซ โฮลฮ เนอึม กุม อื แปน เมือง แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","ไลลวง โม เปะ นึง อื ซ ยุม เฮีย เยือ เปอะ นึง ลาึน เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","โม กวน เปอะ ซ โฮลฮ อาวต ไม่ เม่ะมั่ก แตะ ฆาื โอ โม เปะ เนอึม รพาวม. ซ โฮลฮ โฮว ไป โฮว มา นึง ลาึน เฮี รปาวน เนอึม ฮอยจ ละ โอ โม เปะ เญือะ ไอม ติ โกะ ปุย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","เญือม โฮว เลียป เปอะ เมือง เซ โฮว เปอะ รปาวน ซเงะ โน่ง. โม เปะ ปังเมอ ซ อาวม เปอะ เม่ะมั่ก แตะ ฆาื อื รปาวน เนอึม เอิน. ติ เนอึม มัฮ รโตง ติ ซเงะ เซ. มัฮ ฆาื มั่ป ยุฮ เปอะ. ซ ยุง เปอะ ตอก มัฮ ตอก มอยฮ กัน ตอซู ปุย ปุ แตะ ไม่ อาึ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","อาึ มัฮ พะจาว. อาึ แจง ซ ยุฮ ตอก อัฮ แตะ ละ ปุย ฆอก ปุย เบร ติ มู เฮี นึง บะ อื ปุ แตะ ตอซู ไม่ อาึ. ซ ยุม เนอึม นึง ลาึน เวือฮ เฮี โครยญ โฆะ แตะ.’ ” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","โม ป โฮลฮ ไอ โมเซ ดวน โฮว ซาวป เลียป แลน เมือง โคระ เซ, เอีจ ฟวยจ เพียก แฮม เนอึม เมือง เซ, เกือฮ ปุย แกต อื มัฮ ป โอ ไมจ. มัฮ ฆาื โม เซ ป รักเริ เติ ปุย พะจาว ฆาื อื. พะจาว เกือฮ อื ลอก ป โซะ นึง เนะซอัง แตะ. ยุม เอิน ฆาื อื ซองนา พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ปุย กาว ลอา ป โฮว เลียป แลน เมือง เซ มัฮ โยชูวา กวน นูน ไม่ คาเลป กวน เยฟูเน โน่ง ป ไอม ลั่ง นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","เญือม เอีจ ฮมอง โม อิซราเอน ลปุง พะจาว ป ซึป ไอ โมเซ ละ แตะ ตอก เซ เยอ, เยือม เนอึม เยือม แนม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","ปวยฮ พริ เซ งาวป โกฮ. เพรียง ติ แตะ โฮว ฮอยจ นึง บลาวง. ตะ ลู เลียก เตือง เซ. อัฮ เฮี ละ ปุ แตะ, “เอะ เอีจ พิต เตอะ. เอะ ซ โฮว เลียก เนอึม เมือง ป ซันญา พะจาว อาึง ละ แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ไอ โมเซ คัต อื, “เมอยุ โอ เปอะ ง่อต ป อัฮ พะจาว ละ แตะ? แจง โอ เปอะ ซ เป เยอ. ");
INSERT INTO lcp_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","ปุ ฮาวก เฟือฮ เอิน. พะจาว อาวต โตว ไม่ เปอะ. ซ ไป เปอะ นึง โม ป ตอซู ไม่ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","เญือม ตอซู เปอะ ปุ แตะ ไม่ โม อามาเลก ไม่ โม คะนาอัน เซ, โม เปะ แจง ซ ยุม เปอะ. พะจาว ซ ญอม โตว โฮว ไม่ เปอะ นึง โอ โม เปะ เนอึม รพาวม ละ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","ปุย โม เซ ปังเมอ ริ ลั่ง ฮาวก นึง บลาวง ตัม รพาวม โกะ แตะ ไอฮ. ไอ โมเซ ญอม โตว โฮว ไม่ อื. ฮิต ลปุง ซันญา ยุฮ พะจาว ปุ โรฮ เกือฮ อื โรวก อื. อาวต ลั่ง ก อาวต ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","เญือม เซ โม อามาเลก ไม่ โม คะนาอัน ป อาวต นึง บลาวง เซ เลีฮ ตอซู ปุ แตะ ไม่ อื. เป เนอึม อื. อาื อื. โม อิซราเอน โฮลฮ ตอ ฮอยจ ย่วง โฮรมา ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ไมจ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี, เญือม ซ เลียก โม เปะ นึง ปลัฮเตะ ป ซันญา อาึ ซ เกือฮ ละ เปอะ เซ, ");
INSERT INTO lcp_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ดัฮ ไก ป โรวก โมวก ญุ่ก, แกะ ปิ ญุ่ก ละ ซ ตอง แตะ ทไว ละ พะจาว, ปัง มัฮ ป ตอง อื ทไว เตือง ตัว อื ญุ่ก, ปัง มัฮ ป ทไว อื ตัม ป ซันญา แตะ อาึง ญุ่ก, ปัง มัฮ ป ทไว อื ตัม รพาวม ฆวต ทไว แตะ ญุ่ก, ปัง มัฮ ป ทไว อื นึง กัน ชลอง อื ซเงะ ซัมคัน ยุฮ แตะ ญุ่ก, โอเอีฮ เมาะ ป ทไว อื เซ แปน ป ซออย ฮงาื ละ พะจาว ป ปุก เนอึม รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ไมจ เปอะ เกือฮ ปุย เซ โรวก กวน แกะ กวน ปิ ทไว แตะ เซ ละ พะจาว, เกือฮ โรวก อื ไม่ ญอต แปง ลอา ลิต, ซเบื่อก ไม่ ลออยฮ กาวก ติ ลิต. ");
INSERT INTO lcp_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","กวน แกะ ทไว อื เซ ไมจ อื ไก ไม่ รอาวม อะงุน ติ ตัว ติ ลิต โครยญ ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“เญือม ทไว อื แกะ โปก ระ ติ ตัว ไมจ อื โรวก ไม่ ญอต แปง ปาวน ลิต, ซเบื่อก ไม่ ลออยฮ กาวก ติ ลิต ไม่ บลัฮ. ");
INSERT INTO lcp_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ไมจ โรฮ อื โรวก รอาวม อะงุน ติ ลิต ไม่ บลัฮ, ละ ซ ทไว อื เกือฮ แปน ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“เญือม โรวก อื โมวก โปก ละ ซ ตอง อื ทไว ละ พะจาว เตือง ตัว อื ญุ่ก, ละ ซ ทไว อื เกือฮ แปน ควน รโจะ ดิ อื รพาวม แตะ ไม่ พะจาว ญุ่ก, ปัง มัฮ ป ทไว อื ตัม ป ซันญา แตะ อาึง ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ไมจ อื โรวก ไม่ ญอต แปง แลฮ ลิต, ซเบื่อก ไม่ ลออยฮ กาวก ลอา ลิต. ");
INSERT INTO lcp_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","ไมจ โรฮ อื โรวก ไม่ รอาวม อะงุน ลอา ลิต. ป ตอง อื ทไว เซ แปน ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก เนอึม รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ปัง มัฮ โมวก โปก ญุ่ก, แกะ โปก ญุ่ก, กวน แกะ กวน ปิ ญุ่ก, ไมจ ปุย ทไว ไม่ โอเอีฮ โม เซ โครยญ โฮน อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","เมาะ ไก เซน ซัตซิง ทไว ปุย, ไมจ อื ไก ไม่ โอเอีฮ โม เซ โครยญ ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“โม ป มัฮ จัตเจือ อิซราเอน เตือง โอยจ อื, ไมจ อื ยุฮ ตอก เซ โครยญ โฆะ แตะ เญือม ซ ตอง อื ทไว โอเอีฮ ละ พะจาว เซ, เดอึม ซ แปน ป ซออย ฮงาื ละ อื ไม่ ป ปุก รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","เญือม ไก แคก เลือ ฮอยจ เคะ เปอะ ไม่ ปุย ตังเมือง ป อาวต ลลาึง เปอะ ป ฆวต ตอง ทไว โอเอีฮ ละ พะจาว ละ ซ แปน อื ป ซออย ฮงาื ละ อื ไม่ ป ปุก รพาวม อื, ไมจ โรฮ เปอะ เกือฮ ยุฮ อื ตอก ยุฮ โม เปะ อื โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ปัง มัฮ ปุย ตังเมือง, ปัง มัฮ โม เปะ ป มัฮ จัตเจือ โม อิซราเอน, ไมจ ปุย ยุฮ ตัม โกตไม ติ เจือ เซ เตือง โอยจ แตะ, นึง มัฮ อื โกตไม ตอน ฮมัน โกว ลอป ปุย โครยญ เจน ปุย. โม เปะ ไม่ ปุย ตังเมือง มัฮ เปอะ ป ตอก ปุ แตะ ละ ยุ พะจาว อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","มัฮ เซ ป ไมจ เปอะ โกว โกตไม ป ตอก ปุ แตะ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ไมจ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี, เญือม เอีจ ฮอยจ เปอะ นึง เมือง ป ตาว อาึ เปอะ นึง เซ, ");
INSERT INTO lcp_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","เญือม เอีจ โฮลฮ เปอะ โซม ปอน โอเอีฮ นึง เมือง เซ เยอ, ไมจ เปอะ ละ อาึง ง่อน, ละ ซ ทไว เปอะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","เญือม เอีจ ฟวยจ เกป เปอะ เปลิ เฮงาะ รโกะ ยุฮ แตะ โครยญ เนอึม, เญือม ยุฮ เปอะ คโนมปัง นึง อื, ป มัฮ แฮลป เมือ โรง อื เซ, ไมจ เปอะ ทไว ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ไมจ เปอะ ทไว เฮงาะ รโกะ โฮลฮ โรง เปอะ เซ ละ พะจาว ตอก เซ, ฮอยจ ละ เฆียง เฮี โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ไลลวง โกตไม เกือฮ พะจาว ละ ไอ โมเซ โครยญ เจือ เซ, ดัฮ โม เปะ ซลัฮ นึง ไม่ เบีย ยุฮ เปอะ ง่อน โฮ, ซ ไมจ เปอะ ยุฮ ตอก เมอ? ");
INSERT INTO lcp_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ป มัฮ ลปุง ซตอก พะจาว อาึง ละ ไอ โมเซ, ตึน มัฮ ป ลัง ยุฮ ปุย เน่อึม ซเงะ อัฮ โรง พะจาว อื ละ ไอ โมเซ ฮอยจ ละ เฆียง เฮี โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ดัฮ โม เปะ เตือง มู เปอะ โคะ ยุฮ ป พิต เตือง โอ แตะ ยุง ติ ตื เนอึม, กัง เคะ เอ ดัฮ เปอะ เอีจ ยุง มัฮ อื ป พิต โฮ, ไมจ เปอะ โรวก กวน โมวก โปก ละ ซ ตอง เปอะ ทไว เตือง ตัว อื, เกือฮ แปน ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก รพาวม อื. ไมจ โรฮ เปอะ ทไว ไม่ เฮงาะ รโกะ ไม่ รอาวม อะงุน. โนก ฮา เซ ไมจ แม เปอะ ทไว ไม่ ปิ โปก ติ ตัว ละ ซ แปน ควน โตฮ ปุย ติ แตะ ฮา มั่ป ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ไมจ เปอะ เกือฮ ซตุ ทไว โอเอีฮ เซ แปน ควน เกือฮ อื พะจาว รไซจ พิต โฌวะ ยุฮ ปุย โฮวน เซ. พะจาว ซ ยวก เนอึม มั่ป พิต ยุฮ โม เซ เบือ อื, นึง มัฮ อื ป พิต ยุฮ ปุย เตือง โอ แตะ ยุง, ไม่ เอีจ ญอม อื ตอง ทไว โอเอีฮ ละ พะจาว ไม่ ทไว อื ควน โตฮ อื ติ แตะ นึง. ");
INSERT INTO lcp_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ปัง เอีจ มัฮ ปุย โคะ ยุฮ ป พิต ตอก เซ โครยญ โฆะ แตะ, เตือง โม อิซราเอน ไม่ ปุย ตังเมือง ป อาวต ลลาึง อื เซ, พะจาว ซ ปุน ยวก ลั่ง อื ละ อื เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ดัฮ ไก ติ ปุย โน่ง ป โคะ ยุฮ ป พิต เตือง โอ แตะ ยุง, ไมจ เกือฮ ปุย เซ โรวก กวน ปิ รโปวน ติ ตัว ป ไก อาญุ อื ติ เนอึม, ละ ซ ทไว อื เกือฮ แปน ควน โตฮ อื ติ แตะ ฮา มั่ป ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ไมจ เปอะ เกือฮ ซตุ ทไว โอเอีฮ ละ พะจาว ละ ซ แปน อื ควน รไซจ พิต โฌวะ ยุฮ อื. เญือม เซ พะจาว ซ ยวก มั่ป ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ดัฮ ไก ป โคะ ยุฮ ป พิต เซ ไมจ เปอะ ยุฮ ตัม โกตไม ติ เจือ เซ ตอก ปุ แตะ, เตือง จัตเจือ โม อิซราเอน ไม่ ปุย ตังเมือง ป อาวต ลลาึง อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ดัฮ ตอ ไก ป โฆง ยุฮ ป พิต เตอ, ปัง มัฮ โม อิซราเอน ญุ่ก, ปัง มัฮ ปุย ตังเมือง ญุ่ก, ปุย เซ เอีจ มัฮ พามัต อื พะจาว. ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ, เญือะ ไมจ เปอะ โตว เมีญ มัฮ ปุย ไน โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","มัฮ ฆาื โอ อื ญอม ง่อต ป อัฮ พะจาว, ไม่ โอ อื ญอม ยุฮ ตัม ลปุง ซตอก อื อาึง, ปุย เซ ซ จัมเปน เปอะ ทอเนาะ โน่ง ฆาื อื. กัน ลอก อื ตุต เซ เกว ไม่ โกะ อื ไอฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","เญือม อาวต ลั่ง โม อิซราเอน นึง ลาึน เวือฮ เซ, ไก ปรเมะ ติ. ยุ ปุย โฮว อื เคิ ไน ซเงะ ลโล่ะ. ");
INSERT INTO lcp_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","โม ป ยุ อื เซ โรวก ปุย เซ ฮอยจ เคะ ไอ โมเซ ไม่ อาโรน ไม่ ปุย เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ปุย โม เซ คัง อาึง ปุย เซ ฆาื อื, นึง โอ อื ดิ ยุง ตอก ซ ยุฮ แตะ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ ปุย ยุฮ ยุม ไม่ ปุย เซ. ไมจ เปอะ เกือฮ ปุย เตือง โอยจ อื โฮว แล่น ปุย เซ นึง ซโมะ ก พริ ไคะ เซ ปอ ยุม อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ปุย เตือง โอยจ อื โรวก เนอึม ปุย เซ ฮอยจ ก พริ ไคะ, แล่น อื นึง ซโมะ ปอ ยุม อื, ตัม ป ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ปะ ไมจ เปอะ อัฮ ละ โม อิซราเอน เซ ตอก เฮี, โม เปะ ไมจ เปอะ ยุฮ ดาึง ลปิ ฮอป แตะ โครยญ โจง อื. นึง ดาึง ลปิ เปอะ เซ ไมจ เปอะ ดุฮ กอย ซี ฟะ นึง ติ บวน. ไมจ เปอะ ยุฮ ตอก เซ ฮอยจ ละ เฆียง เฮี โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","กัง เคะ เอ ดัฮ เปอะ เอีจ ยุ ดาึง ลปิ เซ, แปน ควน โตก เปอะ ละ ลปุง ซตอก พะจาว แตะ, ไม่ ซ ยุฮ เปอะ ตัม ลปุง เซ เบือ อื, เดอึม เปอะ โอ ซ ยุฮ ตัม รพาวม โกะ แตะ ไม่ ป ปุก ละ ไง่ โกะ แตะ ไอฮ, ไม่ โอ เปอะ ซ ลอต แปน ปุย โอ เนอึม รพาวม ละ พะจาว ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ดาึง ลปิ เซ ซ แปน ควน ไตม เปอะ ลปุง ซตอก อาึ อาึง ละ เปอะ, ละ ซ ยุฮ เนอึม เปอะ ไม่ ซ แปน เปอะ ปุย ซง่ะ ซงอม ยุฮ อาึ เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ, ป นัม โม เปะ เกือฮ โอก ฮา เมือง อียิป โฮ, ละ ซ แปน อาึ พะจาว ยุฮ เปอะ. อาึ มัฮ เยโฮวา พะจาว ยุฮ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","2","ฟวยจ เซ ไก ปุย ติ. มัฮ โครา ป มัฮ กวน อิตซฮา มัฮ ปุย เจอ เลวี, มัฮ ซฆลาวม โม โคฮัต นึง อื. โครา เซ ซาวป ตอก ซ ตอซู แตะ ไม่ ไอ โมเซ. ป พาวม ดิ ไม่ อื มัฮ โม เจอ รูเบ่น ลอวย ปุย. มัฮ ด่าทัน ไม่ อาบี่รัม กวน เอลีอัป ไม่ โอน กวน เปเลต. โนก ฮา เซ ไก ลั่ง ลอา รอย ไม่ รฮอน ปุย ป พาวม ไม่ อื, มัฮ ตื โม อิซราเอน ป ไก มอยฮ นึง เลือก ปุย อื แปน ฮัวนา ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","โม เซ รโจะ รเจอึม ซองนา ไอ โมเซ ไม่ อาโรน. อัฮ เฮี ละ อื, “โม เปะ ลอา เอีจ เกิน ลอน ป ยุฮ เปอะ. โม เอะ เตือง โต เยอะ มัฮ ตื ปุย ไน พะจาว. พะจาว อาวต ดิ ไม่ เอะ เตือง มู เยอะ. โม เปะ ลอา เมอยุ อวต เปอะ ติ แตะ ระ ฮา ปุย ไน พะจาว เตือง โอยจ อื ไม่ เกือฮ เปอะ ติ แตะ ระ ตวก ซวก ซฮาว ตอก เฮี?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ไอ โมเซ, เญือม ฮมอง อื โอเอีฮ เซ ไอจ รเคอึป ฆาื อื ลังเตะ, ไววอน. ");
INSERT INTO lcp_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ฟวยจ เซ อัฮ เฮี ละ โครา ไม่ โม ปุ โฮมว อื เซ, “ซง่าวป ก ซะ พะจาว ซ เปลีฮ ที ป มัฮ ปุย ไน แตะ. พะจาว ซ เปลีฮ โม ป มัฮ ป เลือก แตะ ไม่ ป ลัง เลียก ละ คัน ยุฮ แตะ ละ ซ ทไว อื โอเอีฮ ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","7","ซง่าวป ก ซะ ปะ ไม่ ปุ โฮมว เปอะ เซ ตุย โรวก โดง งอ ยุฮ เปอะ. อาึง รฆุ งอ นึง ไม่ ป ซออย ฮงาื, โรวก ฮอยจ ละ คัน ยุฮ พะจาว. เญือม เซ เอะ ซ ยุ อุ ป มัฮ เนอึม ปุย เลือก พะจาว นึง อื. มัฮ โม เปะ ป มัฮ เจอ เลวี ป เกิน ลอน ป ยุฮ ฮู,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ไอ โมเซ อัฮ แม เฮี ละ โครา, “โม เปะ ป มัฮ เจอ เลวี, ง่อต เมอะ. ");
INSERT INTO lcp_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","อัม มัฮ แกต เปอะ มัฮ ป แตวะ ลอน ไล เกือฮ พะจาว โม เปะ ตัง โน่ง ฮา ปุย ไฮญ? โม เปะ เอีจ โฮลฮ เปอะ เลียก ซดิ ไม่ พะจาว ยุฮ อิซราเอน นึง ยุฮ เปอะ กัน เกว ไม่ พากัง ระ ยุฮ พะจาว ละ ซ ยุฮ เปอะ กัน ฆรอ โม ลัปซด่อน นึง กัน รซอฮ เปอะ ละ โม อิซราเอน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","พะจาว เอีจ เกือฮ โม เปะ ไม่ โม เจอ เลวี ไฮญ เตือง โอยจ อื โฮลฮ อาวต ซดิ ไม่ แตะ ตอก เซ, โม เปะ ปังเมอ โอ ลั่ง ปอ นึง รพาวม เปอะ เมาะ เซ. ฆวต โฮลฮ ลั่ง เปอะ แปน ซตุ ไม่ ติ. ");
INSERT INTO lcp_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","เญือม เติ เปอะ อาโรน ตอก เซ เอีจ มัฮ เมาะ เติ เปอะ พะจาว, โม่ เปอะ ยุง?” อัฮ เซ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","เญือม เซ ไอ โมเซ เกือฮ ปุย กอก ด่าทัน ไม่ อาบี่รัม ฮอยจ เคะ แตะ. ปุย ลอา เซ ปังเมอ โอ ฮอยจ. อัฮ เฮี, “โฮว โตว. ");
INSERT INTO lcp_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","อัม มัฮ โอ อื ดิ ปอ ละ เปอะ เอีจ เกือฮ เปอะ เอะ โอก ฮา เมือง โฮวน ป โซม บื ป ปอน ละ ซ เกือฮ เปอะ เอะ ยุม เยือ นึง ลาึน เวือฮ เฮี? อัม ทา ลั่ง เกือฮ ติ เปอะ ระ ตวก ซวก ซฮาว คนัป กัป กา เปอะ เอะ ไม่ ตอก เซ? ");
INSERT INTO lcp_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ปะ ตาว เนอึม เปอะ โตว เอะ ฮอยจ นึง เมือง โฮวน ป โซม บื ป ปอน ป เอีจ อัฮ เปอะ เนิ เซ. เกือฮ เปอะ โตว เอะ โฮลฮ ชิจ ไม่ รปึม ก อาวต แตะ เฟือฮ. ปเลี่ย ฆวต จุ แม เปอะ เอะ ฮอยจ เคะ แตะ. โฮว โตว เฟือฮ เอิน เอะ เอ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","เญือม เซ ไอ โมเซ รอก ลัมเลือ พาวม ฆาื อื. อัฮ เฮี ละ พะจาว, “ปุ รัป ป ทไว อื ละ เปอะ. อาึ ยุฮ โตว ป พิต ละ โม เซ. บรัง ติ ตัว บ่ได่ะ, อาึ ปุ ตุย ฮา อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","17","ไอ โมเซ อัฮ เฮี ละ โครา, “ซง่าวป ปะ ไม่ โม ปุ โฮมว เปอะ ลอา รอย ไม่ รฮอน ปุย เซ ไมจ เปอะ ฮอยจ นึง พากัง นา ก ฮอยจ ปุย เคะ พะจาว เซ. อาโรน ซ ฮอยจ โรฮ นา เซ. ไมจ เปอะ เกือฮ ปุย โรวก โดง งอ ยุฮ แตะ โครยญ โฆะ แตะ. เกือฮ โรฮ ดุฮ ป ซออย ฮงาื นึง อื ไม่ โรวก อื ฮอยจ ซองนา พะจาว,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ปุย ตัง โคน ตัง โรวก เนอึม โดง งอ ยุฮ แตะ ฆาื อื. ดุฮ รฆุ งอ นึง อื ไม่ ป ซออย ฮงาื. ชุง โบ โตะ รเวือะ พากัง เซ ไม่ ไอ โมเซ ไม่ อาโรน. ");
INSERT INTO lcp_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","เญือม เซ โครา เกือฮ โม ปุ โฮมว แตะ รโจะ โบ แตะ ชุง รเตือป ไอ โมเซ ไม่ อาโรน นา เซ. เญือม เซ รัง ซเปีย ยุฮ พะจาว ปลาึฮ เอิน ละ ปุย, รัง เนอึม รัง แนม. ");
INSERT INTO lcp_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","พะจาว อัฮ เฮี ละ ไอ โมเซ ไม่ อาโรน. ");
INSERT INTO lcp_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“รกัฮ ติ เปอะ ฮา โม ลัปซด่อน เซ. อาึ ซ ยุฮ ยุม ไม่ อื จุบั่น ตันด่วน เอิน,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","เญือม เซ ไอ โมเซ ไม่ อาโรน นุ่ม ติ แตะ ปอ จิ ไกญ แตะ เตะ ปัว อื นึง พะจาว, “โอ พะจาว, ปะ มัฮ เปอะ กาวะ งาว ฮัก งุน จีวิต ปุย เตือง โอยจ อื. ดัฮ มัฮ พิต ปุย ติ ปุย โน่ง อัม ซ ฮาวก รพาวม เปอะ ละ ปุย เตือง โอยจ อื ฆาื อื?” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ไมจ เปอะ ซตอก โม ลัปซด่อน เกือฮ โอก ซไง ฮา พากัง ยุฮ โครา ไม่ ด่าทัน ไม่ อาบี่รัม เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","เญือม เซ ไอ โมเซ ไม่ โม ป กวต ไน โม อิซราเอน โกฮ โฮว ดิ เคะ เญือะ ด่าทัน ไม่ อาบี่รัม. ");
INSERT INTO lcp_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","อัฮ อื ละ โม ลัปซด่อน ตอก เฮี, “เกือฮ ติ เปอะ ซไง ฮา พากัง ยุฮ ปุย ฆอก ปุย เบร โม เฮี. ปุ ลอก โอเอีฮ ยุฮ อื ติ เจือ เนอึม เดอึม เปอะ โอ ซ ยุม ดิ ไม่ โม เฮี ฆาื มั่ป ยุฮ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","โม ลัปซด่อน เฌาะ ติ แตะ อาวต ซไง ฆาื อื ฮา พากัง ยุฮ โครา ไม่ ด่าทัน ไม่ อาบี่รัม เซ. ด่าทัน ไม่ อาบี่รัม เซ ชุง โบ โตะ รเวือะ พากัง อาวต แตะ ไม่ ปุย เญือะ แตะ ไม่ กวน แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ไอ โมเซ อัฮ เฮี, “มัฮ ตอก เฮี ตอก ซ ยุง เปอะ มัฮ เนอึม พะจาว ป ดวน อาึ ฮอยจ ยุฮ โอเอีฮ เฮี โครยญ เจือ ฆาื อื. มัฮ โตว โอเอีฮ ป เบิ่ก ไอฮ นึง โกะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ดัฮ ปุย โม เฮี ยุม ทัมมด่า ไม่ โอ อื ลอก ป ตัง โน่ง เน่อึม นึง พะจาว โฮ, ซ ยุง ที เปอะ นึง เซ โอ อื มัฮ พะจาว ป ดวน อาึ อื. ");
INSERT INTO lcp_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ดัฮ พะจาว ยุฮ เนอึม ป ซัมคัน นึง เกือฮ แตะ ปลัฮเตะ ม่ะ ปอ บลวน แตะ ปุย โม เซ เตือง โอเอีฮ ยุฮ อื, ไม่ เกือฮ อื เลีฮ พราวป เอิน เตือง ไอม แตะ ฮอยจ เมือง ป ยุม, โม เปะ ซ ยุง เปอะ มัฮ ปุย โม เซ ป พามัต พะจาว ฆาื อื,” อัฮ เซ ละ โม ลัปซด่อน. ");
INSERT INTO lcp_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","เญือม เอีจ ฟวยจ อัฮ ไอ โมเซ โอเอีฮ ไล เซ เยอ, ปลัฮเตะ ฆรึม ปุย โม เซ ดุงเดียง ม่ะ เอิน. ");
INSERT INTO lcp_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ปลัฮเตะ ม่ะ ปอ บลวน แตะ โม เซ เตือง กวน เตือง เฌือต อื. เมาะ ป พาวม ดิ ไม่ โครา เซ เตือง คาวคอง อื ดุฮ ตื นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","โม เซ ดุฮ พราวป เนอึม เตือง ไอม แตะ ฮอยจ เมือง ป ยุม ไม่ คาวคอง อื เตือง โอยจ อื. เญือม เซ ปลัฮเตะ รบิต แม ราว อื. โม เซ ลอต เอิน ไฆร ลอป. ");
INSERT INTO lcp_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","โม อิซราเอน ป อาวต นา เซ เญือม ฮมอง อื ครวก โม เซ เยอ ตอ ฆาื อื. อัฮ อื ตอก เฮี เรียง “ตอ เออ. ปลัฮเตะ ซ บลวน โรฮ เอะ ตอก เซ ยุ่ง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","เญือม เซ พะจาว เกือฮ งอ ซัมคัน ยุฮ แตะ โอก ฮะ ยุฮ ปุย ลอา รอย ไม่ รฮอน เซ ลไล ทไว อื ป ซออย ฮงาื. ");
INSERT INTO lcp_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ฟวยจ เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“ไมจ เปอะ เกือฮ เอเลอาซา กวน อาโรน ป มัฮ ซตุ เซ โฮว ตุย โดง งอ ไร ซเงี โอก ฮา โม ป ฮะ เซ. เกือฮ โปวฮ รฆุ งอ นึง อื ก ซไง อื. โดง เซ มัฮ ป ซัมคัน. ");
INSERT INTO lcp_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","เญือม ทไว ปุย อื ละ อาึ นึง คัน ระ เซ ลอต แปน ป ซัมคัน. โดง งอ ยุฮ โม ป ยุม นึง มั่ป ยุฮ แตะ เซ, ไมจ เปอะ ตุย แตม เกือฮ แปน ปลัฮ แปน ปลัฮ แตะ. เลอึป คัน เซ นึง. ซ แปน ควน เกือฮ โม อิซราเอน ยุง คิง แตะ ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","40","เอเลอาซา ตุย เนอึม โดง งอ เซ. เกือฮ เนอึม ปุย แตม อื แปน ปลัฮ อื ตอก เซ. เลอึป คัน เซ นึง อื ตัม ป ดวน พะจาว ไอ โมเซ อัฮ ละ อื เซ. แปน เนอึม ควน เกือฮ โม อิซราเอน ยุง โอ ปุย ไฮญ ไมจ เลียก ละ คัน เซ ละ ซ ทไว แตะ ป ซออย ฮงาื นึง ละ พะจาว. มัฮ โม จัตเจือ อาโรน โน่ง ป ลัง ยุฮ กัน เซ. ปุย ไฮญ ดัฮ ยุฮ อื ตอก เซ ซ ยุม โรฮ ฆาื อื ตอก โครา ไม่ โม ป พาวม ดิ ไม่ อื เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","เญือม เอีจ ปวยฮ พริ อี, โม อิซราเอน เตือง โอยจ อื รโจะ ละ ซ เติ แตะ ไอ โมเซ ไม่ อาโรน ตอก เฮี, “มัฮ ฆาื เปะ ลอา เฮี ป ยุม ปุย ไน พะจาว เซ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ลไล รโจะ ปุย โฮวน ละ ซ เติ แตะ ไอ โมเซ ไม่ อาโรน เซ, ปุย โฮวน เซ นา ลวง ลั่ก พากัง ระ เซ. เญือม เซ ชวน เอิน เลีฮ เลอึป ชุต รวู ซัมคัน เซ พากัง ระ, ฮอยจ ไม่ รัง ซเปีย คึนัก ยุฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ไอ โมเซ ไม่ อาโรน โฮว ชุง ลั่กกา พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ไมจ เปอะ โอก ฮา ปุย โฮวน เซ. อาึ ซ ยุฮ ไลจ ไม่ ปุย โม เซ ไน เวลา ปเลี่ย เฮี เอิน,” อัฮ เซ. ปุย ลอา เซ นุ่ม เอิน ปอ จิ ไกญ แตะ เตะ. ");
INSERT INTO lcp_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ไอ โมเซ อัฮ เฮี ละ อาโรน, “ไมจ เปอะ ตุย โรวก โดง งอ ยุฮ เปอะ. โฮว ดุฮ งอ อาวต นึง คัน ทไว เซ โตะ อื, ไม่ ดุฮ เปอะ ป ซออย ฮงาื นึง. ฟวยจ เซ ซไจ โฮว ไม่ ฮอยจ เคะ ปุย โฮวน เซ ละ ซ ทไว เปอะ เกือฮ แปน ควน รไซจ พิต โฌวะ ยุฮ อื เซ, นึง เอีจ ฮอยจ พราวป รพาวม ฮาวก ยุฮ พะจาว ละ อื. เอีจ เกิต เอิน พาญัต ฆอก ลอน ละ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","อาโรน โฮว เนอึม ไม่ โดง งอ ยุฮ แตะ ตัม ป อัฮ ไอ โมเซ ละ แตะ. ตอ เลียก ลลาึง ปุย โฮวน เซ. เญือม เอีจ ยุ อื เกิต พาญัต ฆอก ลอน ละ ปุย โม เซ เยอ, อาึง ป ซออย ฮงาื โตะ โดง งอ ยุฮ แตะ เซ. ลอต ทไว อื เกือฮ แปน ควน รไซจ พิต โฌวะ ยุฮ ปุย โฮวน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","เญือม เซ พาญัต ฆอก ลอน ป ฮอยจ ละ ปุย เซ ไฆร เอิน. อาโรน เซ ชุง ลั่ง ซน่ะ ป ยุม ไม่ ป ไอม. ");
INSERT INTO lcp_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","เซน ปุย ป ยุม ฆาื พาญัต ฆอก เซ ไก เอิน 14,700 ปุย, เมีญ โตว ป ยุม ไม่ โม โครา นึง อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","เญือม เอีจ ไฆร พาญัต ฆอก เซ, อาโรน เอีญ ฮอยจ เคะ ไอ โมเซ นึง โบ โตะ รเวือะ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ไมจ เปอะ ดวน โม อิซราเอน เกือฮ โรวก โคะ ฆิ ยุฮ ฮัวนา เจอ เตือง กาว ลอา เจอ อื เซ ติ เจอ ติ โฆง. เกือฮ ไซฮ มอยฮ กุม อื นึง อื โครยญ โฆง อื. ");
INSERT INTO lcp_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","โคะ ฆิ รโตง เจอ เลวี นึง อื ไมจ เปอะ ไซฮ มอยฮ อาโรน นึง. เกือฮ ฮัวนา เจอ โครยญ เจอ โรวก โคะ ฆิ แตะ ติ ปุย ติ โฆง. ");
INSERT INTO lcp_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ไมจ เปอะ อาึง ลั่กกา ฮิต ลปุง ซันญา ป อาวต กไน พากัง ระ, นา ก กอ ฮอยจ อาึ เคะ ปะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","โคะ ฆิ ปุย เลือก อาึ นึง อื อาึ ซ เกือฮ โอก ฆอย. มัฮ ตอก เซ ตอก ซ เกือฮ โม อิซราเอน โอ เญือะ เติ ลอป ปะ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ไอ โมเซ อัฮ เนอึม อื ละ โม อิซราเอน ตอก เซ. โม ฮัวนา อื โรวก เนอึม โคะ ฆิ ยุฮ แตะ เตือง กาว ลอา แตะ ติ ปุย ติ โฆง โครยญ เจอ โม อิซราเอน. โคะ ฆิ ยุฮ อาโรน อาวต ดิ โรฮ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ไอ โมเซ อาึง อื โตะ พากัง เซ ลั่กกา ฮิต ลปุง ซันญา ยุฮ พะจาว เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ปวยฮ พริ เซ ไอ โมเซ เลียก กไน พากัง ระ เซ, ยุ โอก ฆอย โคะ ฆิ ยุฮ อาโรน, ป มัฮ ตัว แทน เจอ เลวี เซ. ฆอย อื เซ โอก เตีย ปอป ง่อน. โพรยฮ ง่อน. โอก เปลิ, ไก เปลิ อาลามัน ตึม นึง ง่อน. ");
INSERT INTO lcp_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ไอ โมเซ ตุย โรวก โคะ ฆิ เซ เตือง โอยจ อื, เปลีฮ อื ละ โม อิซราเอน. เญือม เอีจ ฟวยจ แลน อื, โม เซ ตุย โรวก โคะ ฆิ ยุฮ โกะ แตะ เตือง ไพ เตือง มัน. ");
INSERT INTO lcp_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","พะจาว อัฮ เฮี ละ ไอ โมเซ, “อาึง โคะ ฆิ ยุฮ อาโรน ลั่กกา ฮิต ลปุง ซันญา, ละ ซ แปน อื ควน เกือฮ โม ป เลฮ เตียง ยุง คิง แตะ. ซ เกือฮ อื ยุง โอ แตะ ไมจ เติ ลอป ปุย เดอึม โอ ซ ยุม ฆาื อื,” อัฮ เซ ละ ไอ โมเซ พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ไอ โมเซ ยุฮ เนอึม อื ตัม ป อัฮ พะจาว ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","โม อิซราเอน อัฮ เฮี ละ ไอ โมเซ, “เอะ เอีจ ไลจ โลม เนอึม เมอะ, เอีจ ซ ชิป โอยจ เจอะ. ");
INSERT INTO lcp_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","เมาะ ป ฮอยจ โบ พากัง ระ เซ ตึน ซ ยุม โอยจ, เอะ มัฮ ซ ยุม โอยจ โรฮ โฮะ ตอก เซ ยุ่ง.” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","พะจาว อัฮ อาึง อื ละ อาโรน ตอก เฮี, “ดัฮ ไก ป ยุฮ ป พิต นึง กัน รซอฮ ปุย นึง พากัง นา ก ฮอยจ ปุย เคะ พะจาว, ไม่ นึง กัน แปน เปอะ ซตุ เซ, ปะ ไม่ โม กวน เฌือต เปอะ ไม่ โม จัตเจือ เปอะ, ซ จัมเปน เปอะ ลอก ตุต ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","เญือม ยุฮ ปะ ไม่ โม กวน เปอะ กัน นึง พากัง นา ก อาวต อาึ เซ, ไมจ เปอะ เกือฮ โม คระ เฌือต เปอะ ป มัฮ โม เลวี เซ เรอึม เปอะ นึง กัน ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","โม เซ ซ แปน กวนไจ ปุย โจฮ เปอะ, ไม่ ซ ยุฮ อื กัน ป เกว ไม่ พากัง ระ เซ, ปังเมอ โอ เปอะ ไมจ เกือฮ เลียก ซดิ ไม่ ฮอง ซัมคัน เซ, ไม่ ก อาวต คัน ทไว เซ, เดอึม ปุย โอ ซ ยุม ฆาื อื, เตือง โม เซ เตือง ปะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","โม เซ ไมจ อื รซอฮ ดิ ไม่ ปะ นึง กัน ลัง ยุฮ แตะ ป เกว ไม่ พากัง ระ เซ. ปุย ไฮญ โนก ฮา โม เลวี เซ, ปังเมอ โอ เปอะ ไมจ เกือฮ ยุฮ กัน ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“มัฮ ปะ ไม่ โม กวน เปอะ โน่ง ป ลัง ยุฮ กัน นึง ฮอง ซัมคัน ไม่ นึง คัน ทไว เซ, เดอึม อาึ โอ ซ โฮลฮ ฮาวก รพาวม แม ละ โม อิซราเอน เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","อาึ เอีจ เลือก โม เลวี, ป มัฮ เอียกปุ คระ เฌือต เปอะ, โอก เน่อึม นึง โม อิซราเอน ไฮญ เซ ละ ซ แปน อื คอง ควัน เกือฮ อาึ ละ ปะ. โม เซ เอีจ มัฮ ป รกัฮ โน่ง อาึ ละ โกะ แตะ, ละ ซ โฮลฮ อื ยุฮ กัน ป เกว ไม่ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ปะ ไม่ โม กวน เปอะ ปังเมอ ไมจ เปอะ ยุฮ กัน ลัง ยุฮ โม ซตุ เซ โครยญ เจือ, เมาะ ป เกว ไม่ คัน ทไว ไม่ โอเอีฮ ป อาวต กไน พากัง ซัมคัน เซ. โอเอีฮ โม เซ มัฮ ป ลัง ฟวยจ นึง ปะ, นึง เอีจ เกือฮ พิเซต อาึ กัน แปน ซตุ เซ ละ เปอะ. ดัฮ ไก ปุย ไฮญ ป โอ มัฮ จัตเจือ ปะ นึง อื ป เลียก ซดิ ไม่ โอเอีฮ ซัมคัน เซ, ซ โฮลฮ ปุย ยุฮ ยุม ไม่ ฆาื อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","พะจาว อัฮ เฮี ละ อาโรน, “ไมจ เปอะ ไตม ตอก เฮี, โอเอีฮ ป ทไว ปุย ละ อาึ เตือง โอยจ อื, เมาะ ป โอ ปุย ตอง, อาึ เอีจ เกือฮ ละ ปะ. เอีจ เมีญ มัฮ รโตง ปะ ไม่ โม กวน เฌือต เปอะ ฮอยจ ละ เฆียง เฮี โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","โอเอีฮ ซัมคัน ทไว ปุย เซ ป โอ ปุย ตอง นึง คัน ทไว ป ซ เมีญ มัฮ รโตง ปะ นึง อื เซ มัฮ ตอก เฮี. มัฮ เฮงาะ รโกะ ทไว ปุย, ไม่ ป ทไว ปุย ละ ซ แปน ควน โตฮ มั่ป ยุฮ ปุย, ไม่ ป ทไว อื ละ แปน ควน ยวก มั่ป กัฮ ตุต ละ ปุย. โอเอีฮ ซัมคัน ทไว ปุย โครยญ เจือ เซ, เอีจ มัฮ ป ลัง ละ ปะ ไม่ โม กวน เฌือต เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","ปะ ไมจ เปอะ โซม ปอน โอเอีฮ โม เซ นึง นาตี ก ซง่ะ ไล อื นึง มัฮ อื ป ซัมคัน. มัฮ โม ปรเมะ โน่ง ป ลัง โซม ปอน โอเอีฮ โม เซ เยอ. ไมจ เปอะ ทื มัฮ ป ซัมคัน ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“โนก ฮา เซ มัฮ แม ป ทไว ไฮญ ปุย, ป กอยฮ โม อิซราเอน ทไว พิเซต ละ พะจาว เตือง โอยจ อื. อาึ เอีจ เกือฮ โรฮ แปน คอง ปะ ไม่ โม กวน รเมะ กวน รโปวน เปอะ ฮอยจ ละ เฆียง เฮี โครยญ เจน ปุย, เมาะ ป มัฮ ปุย ไน จัตเจือ เปอะ โครยญ โฆะ อื ป โอ อื มัฮ ปุย รแอม ไล ลัง โซม ปอน ตื อื. ");
INSERT INTO lcp_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“โอเอีฮ เมาะ ป ทไว โรง ปุย ป ตึก นึง ไมจ แตะ, ป มัฮ ลออยฮ กาวก, รอาวม อะงุน, ไม่ เฮงาะ รโกะ, อาึ เอีจ เกือฮ แปน คอง เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","เมาะ ป มัฮ ปุย ไน จัตเจือ เปอะ ป ซง่ะ ไล อื ลัง โซม ปอน ตื อื. ");
INSERT INTO lcp_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“โอเอีฮ ทไว ลุต ปุย ติ เมือง อิซราเอน โครยญ เจือ, อาึ เอีจ เกือฮ ละ โม เปะ. ");
INSERT INTO lcp_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","กวน โรง ปุย โครยญ โฆะ อื ไม่ กวน โรง ซัตซิง ป ลัง โรวก โม อิซราเอน ทไว ละ อาึ, อาึ เอีจ เกือฮ โรฮ ละ โม เปะ. ป มัฮ กวน โรง ปุย โครยญ โฆะ อื, ปะ ปังเมอ ไมจ เปอะ เกือฮ ปุย โตฮ ตัม ไล อื. กวน โรง ซัตซิง ป โอ ซง่ะ ไล นึง อื, ไมจ โรฮ เปอะ เกือฮ ปุย โตฮ ตอก เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","กวน รเมะ ปุย ดัฮ เอีจ ไก อาญุ ติ เคิ โฮ, ไมจ เปอะ เกือฮ ปุย โตฮ ตัม คาโนวน อื. ปุก พอน เชเคน ตัม เชเคน โกว ปุย นึง ฮอง ซัมคัน เซ. ติ เชเคน เซ ปุก ง่า เกรา. ");
INSERT INTO lcp_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“ป มัฮ กวน โรง โมวก, กวน โรง แกะ, ไม่ กวน โรง ปิ, ปังเมอ โอ เปอะ ไมจ โตฮ, นึง เอีจ มัฮ อื คอง อาึ. ไมจ เปอะ มอก ทไว ไม่ ซพรอต เปอะ ฮนัม อื นึง คัน ทไว, ไม่ ตอง เปอะ ทไว ลออยฮ อื. โอเอีฮ เซ ซ แปน ป ซออย ฮงาื ป ปุก เนอึม รพาวม อาึ. ");
INSERT INTO lcp_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","โตะ ซัตซิง โม เซ เตือง โอยจ อื เอีจ มัฮ ป ลัง ละ โม เปะ, ตอก เนะ รน่าวก ไม่ รเวือง ลวง ดอม ป กอยฮ ปุย ทไว ละ อาึ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","เมาะ ป ทไว พิเซต โม อิซราเอน ละ อาึ โครยญ เจือ, อาึ เอีจ เกือฮ โรฮ ละ ปะ, ไม่ โม กวน รเมะ กวน รโปวน เปอะ ฮอยจ ละ เฆียง เฮี โครยญ เจน ปุย. เฮี มัฮ ลปุง ซันญา ตอน ฮมัน ยุฮ อาึ ละ ปะ ไม่ โม จัตเจือ เปอะ โครยญ โฆะ อื. ");
INSERT INTO lcp_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","“โม เปะ ซ โฮลฮ เปอะ โตว พริ เตะ เบระ เบรอึม นึง ปลัฮเตะ เซ. ซ โฮลฮ เปอะ โตว รโตง แตะ ไม่ ปุย โม เซ. เอีจ มัฮ อาึ ป มัฮ รโตง เปอะ. เอีจ มัฮ อาึ ป มัฮ ป ลัง โฮลฮ เปอะ เซ,” อัฮ เซ ละ อาโรน พะจาว เยอ. ");
INSERT INTO lcp_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","พะจาว อัฮ แม เฮี, “เญือม ทไว โม อิซราเอน โอเอีฮ ยุฮ แตะ ละ อาึ กาว ปุน ติ ปุน เซ, อาึ เอีจ เกือฮ ละ โม เลวี แปน ป ลัง โฮลฮ อื, นึง มัฮ อื ป ยุฮ กัน ป เกว ไม่ พากัง ระ ก ฮอยจ ปุย เคะ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","เญือะ ไมจ โตว เกือฮ โม อิซราเอน ไฮญ เลียก ซดิ ไม่ พากัง ระ เซ, เดอึม โอ ซ ลอก ตุต ฮอยจ ละ ยุม แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","เน่อึม ปเลี่ย โฮว ไป นา, โม เลวี ซ แปน ป ลัปพิตชอป พากัง ระ เซ ไม่ กัน ป เกว ไม่ อื โครยญ เจือ. เอีจ มัฮ เซ ป มัฮ โกตไม ป ไมจ ปุย ยุฮ ลอป ฮอยจ ละ โม จัตเจือ เปอะ เฆียง เฮี. โม เลวี ซ ไก โตว พริ เตะ เบระ เบรอึม ยุฮ นึง เมือง อิซราเอน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ป ทไว โม อิซราเอน กาว ปุน ติ ปุน เซ อาึ เอีจ เกือฮ เนอึม ละ โม เลวี แปน รโตง อื. เอีจ มัฮ ป ลัง โฮลฮ อื. มัฮ เซ ป อัฮ อาึ ละ โม เลวี เซ ตอก เฮี ฆาื อื, โม เปะ ไก โตว พริ เตะ เบระ เบรอึม ยุฮ เปอะ นึง เมือง อิซราเอน เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","พะจาว ดวน ไอ โมเซ อัฮ อื ละ โม เลวี ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“เญือม เอีจ โฮลฮ เปอะ รัป โอเอีฮ มอป พะจาว ละ เปอะ เซ, ป มัฮ โอเอีฮ ทไว โม อิซราเอน กาว ปุน ติ ปุน ยุฮ อื เซ, โม เปะ ไมจ โรฮ เปอะ โรวก ทไว ป โฮลฮ แตะ เซ ละ พะจาว, ไน กาว ปุน เซ ตา ติ ปุน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","โอเอีฮ ทไว เปอะ เซ, ซ เมีญ โรฮ ตอก ทไว ปุย ป โฮลฮ ป ปุน แตะ รกา เน่อึม นึง ม่า นึง ชิจ ยุฮ แตะ โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","มัฮ ตอก เซ ตอก ไมจ เปอะ ทไว โอเอีฮ ป โฮลฮ แตะ เน่อึม นึง โอเอีฮ ทไว ปะจัม โม อิซราเอน เซ, นึง มัฮ อื ป ลัง เกือฮ เปอะ ละ พะจาว. โอเอีฮ โม เซ ไมจ เปอะ มอป ละ อาโรน ป มัฮ ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","“โอเอีฮ ป โฮลฮ เปอะ เซ, ไมจ เปอะ เลือก ป ตึก นึง ไมจ แตะ นึง อื ละ ซ ทไว เปอะ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","เญือม เอีจ ฟวยจ ทไว เปอะ ป ตึก นึง ไมจ แตะ ตอก เซ, ป โฮฮ ฮา ทไว เปอะ เซ ไมจ เปอะ เมีญ มัฮ ตอก เฮงาะ โฮลฮ ปุย เน่อึม นึง รบุฮ ยุฮ แตะ โฮ, ไม่ ตอก เปลิ โคะ ป โฮลฮ ปุย เน่อึม นึง โตะ รปึม ยุฮ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","เญือม เซ โม เปะ ไม่ ปุย ไน เญือะ เปอะ, ปัง โฮว โซม โฮว ปอน เปอะ นา ออฮ นา เอีฮ แปน ตื, นึง มัฮ อื โอเอีฮ ป ลัง โฮลฮ เปอะ นึง ยุฮ เปอะ กัน ป เกว ไม่ พากัง ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","เญือม เอีจ ฟวยจ ทไว เปอะ ป ตึก นึง ไมจ แตะ ละ พะจาว ตอก เซ, ปัง โซม ปอน เปอะ โอเอีฮ โม เซ, พะจาว เญือะ เมีญ โตว อื แปน ป พิต ละ เปอะ. ปุ เกือฮ โอเอีฮ ซัมคัน ทไว โม อิซราเอน เซ แปน ป รแอม ละ พะจาว, นึง โซม ปอน เปอะ โอเอีฮ กา เฆียง ทไว เปอะ ป ตึก นึง ไมจ แตะ เซ, เดอึม เปอะ โอ ซ ยุม ฆาื,” อัฮ เซ ละ โม เลวี เซ. ");
INSERT INTO lcp_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ ไม่ อาโรน, ");
INSERT INTO lcp_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ไมจ เปอะ เกือฮ โม อิซราเอน ยุฮ ตัม โกตไม ป ซตอก อาึ เฮี, เกือฮ โรวก โมวก ชัง ซครัก ป โอ อื ไก ตอก โละพริ ไม่ ป โอ ปุย ดิ โกว ละ กัน ติ ชวง. ");
INSERT INTO lcp_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","เกือฮ ตาว โมวก เซ ละ เอเลอาซา ป มัฮ ซตุ เซ. ฟวยจ เซ ไมจ เปอะ เกือฮ ปุย โฮว มอก โมวก เซ นึง ก พริ ไคะ ซองนา ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","เญือม เซ เอเลอาซา เซ ซ ชึต ด่อยฮ แตะ นึง ฮนัม โมวก เซ. ฟวยจ เซ ซ ซพรอต อื ลวง ลั่ก อาวต พากัง ระ เซ อาแลฮ โฮน. ");
INSERT INTO lcp_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ฟวยจ เซ ไมจ เปอะ เกือฮ ปุย ตอง โมวก เซ ซองนา ซตุ เซ เตือง โม่ว อื, เตือง ฮัก อื, เนะ อื, ฮนัม อื, ไม่ เวียกตู อื. ");
INSERT INTO lcp_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","เญือม เซ ซตุ เซ ซ ตุย โคะ โซน ซีด่า ไม่ กัก ฮลาึง ลเวือง ไม่ กอย ซครัก, น่าึก อื โตะ งอ ก ตอง ปุย โมวก เซ. ");
INSERT INTO lcp_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ฟวยจ เซ ซตุ เซ ไมจ อื ซัก เครอึง เซอึก แตะ ไม่ ไมจ อื ฮาวม เดอึม ซ เกียฮ เลียก อาวต แม นึง ไคะ. ซตุ เซ ปังเมอ แปน ลั่ง ปุย รแอม ไล ฮอยจ ละ เมือ กปู อื. ");
INSERT INTO lcp_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ป มัฮ ปุย ตอง โมวก เซ ไมจ โรฮ อื ซัก เครอึง เซอึก แตะ, ไม่ ไมจ โรฮ อื ฮาวม. ปุย เซ ซ แปน โรฮ ปุย รแอม ไล ฮอยจ ละ เมือ กปู อื. ");
INSERT INTO lcp_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ฟวยจ เซ ไมจ เปอะ เกือฮ ปุย ซง่ะ ไล ติ ปุย กาวป จะ ก ตอง ปุย โมวก เซ. เกือฮ โฮว ตาว อาึง อื ก พริ ไคะ นา ก ซง่ะ ไล อื. จะ เซ มัฮ ป โกว ปุย ละ ซ ยุฮ อื รอาวม ซัมคัน เกือฮ ปุย แปน ปุย ซง่ะ ไล, ไม่ แปน อื ควน รไซจ พิต โฌวะ ยุฮ ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ปุย กาวป จะ เซ ไมจ โรฮ อื ซัก เครอึง เซอึก แตะ. ปุย เซ ปังเมอ ซ แปน ลั่ง ปุย รแอม ไล ฮอยจ ละ เมือ กปู อื. โกตไม เซ มัฮ ป ตอน ป ฮมัน ป โกว ลอป โม อิซราเอน ไม่ ปุย ตังเมือง ป อาวต ลลาึง อื เซ โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ดัฮ ไก ป โคะ ไปญ ป ยุม เมอ, ปุย เซ ซ แปน ปุย รแอม ไล ฆาื อื อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ปุย เซ ไมจ อื โกว รอาวม ซัมคัน เซ ละ ซ เกือฮ อื ติ แตะ ซง่ะ ไล. ไมจ อื โกว ไน ซเงะ ลอวย ไม่ ซเงะ อาแลฮ เซ, เดอึม ซ แปน เนอึม ปุย ซง่ะ ไล. ดัฮ โอ ยุฮ อื ตอก เซ ไน ซเงะ ลอวย ไม่ ซเงะ อาแลฮ เซ, ซ แปน แนฮ ลั่ง ปุย รแอม ไล ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ป เอีจ โคะ ไปญ ป ยุม ตอก เซ ไม่ โอ อื โกว รอาวม ซัมคัน เซ, เอีจ แปน ปุย รแอม ไล. ปุย เซ เอีจ มัฮ เกือฮ อื พากัง ระ ยุฮ พะจาว เซ แปน ป รแอม, ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ ฮา โม อิซราเอน ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“เญือม ไก ป ยุม นึง โตะ พากัง ยุฮ แตะ, เมาะ ป อาวต ไม่ อื ไม่ โม ป เลียก เคะ ป ยุม เซ, ซ แปน ปุย รแอม ไล ฆาื อื อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","โอเอีฮ เมาะ ป โอ ไก รเดือป ป โกว ปุย นึง อื, ปัง มัฮ ฮมวน ญุ่ก, โดง ญุ่ก, เอีจ แปน ตื โรฮ ป รแอม ไล. ");
INSERT INTO lcp_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“ดัฮ ไก ป โคะ ไปญ ป ยุม นึง มอก ปุย แตะ, ปัง มัฮ ป ยุม ทัมมด่า นึง ก พริ พากัง ยุฮ แตะ ญุ่ก, ไม่ ป โคะ ลอก ซอัง ป ยุม, ไม่ โม ป ลอก รมอยจ ปุย ญุ่ก, ซ แปน ปุย รแอม ไล ฆาื อื อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ละ โม ป เอีจ แปน ปุย รแอม ไล ตอก เซ เยอ, ไมจ ปุย ตุย จะ ป เอีจ ฟวยจ ตอง ปุย โมวก เซ นึง, ไม่ อาึง อื โตะ โดง เญี่ยะ, เกือฮ โรฮ ดุฮ รอาวม ป เชียต ปุย เน่อึม นึง โกลง นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ฟวยจ เซ ไมจ เปอะ เกือฮ ปุย ซง่ะ ไล ติ ปุย ตุย กัก ฮลาึง ลเวือง เกือฮ ชึต อื โตะ รอาวม เซ. เกือฮ ซพรอต รอาวม เซ นึง พากัง เซ, ไม่ โอเอีฮ โกว ปุย นึง อื, ไม่ ปุย อาวต นึง อื. ไมจ โรฮ อื ซพรอต นึง ปุย โคะ ไปญ ป ยุม เซ, ป โคะ ลอก ซอัง ป ยุม ญุ่ก, ไม่ ป โคะ ลอก รมอยจ ปุย ญุ่ก. ");
INSERT INTO lcp_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ไมจ เปอะ เกือฮ ปุย ซง่ะ ไล เซ ซพรอต รอาวม นึง ปุย รแอม ไล เซ, ไน ซเงะ ลอวย ไม่ ซเงะ อาแลฮ เซ. ไน ซเงะ อาแลฮ นึง อื เซ, ปุย รแอม ไล เซ ซ ลอต โรฮ ซง่ะ เบือ อื. ไมจ อื ซัก เครอึง เซอึก แตะ ไม่ ไมจ อื ฮาวม. ดัฮ เอีจ มัฮ เมือ กปู อื ลอต เอิน แปน ปุย ซง่ะ ไล เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","โม ป เอีจ แปน ปุย รแอม ไล ตอก เซ, ดัฮ โอ เกือฮ ติ แตะ ซง่ะ ตัม ไล เซ, แปน แนฮ ลั่ง ปุย รแอม ฆาื อื. มัฮ ฆาื โอ อื ดิ เกือฮ ปุย ซพรอต รอาวม ซัมคัน เซ นึง แตะ. ปุย เซ เอีจ มัฮ เกือฮ อื พากัง ระ ยุฮ พะจาว เซ แปน ป รแอม. ไมจ เปอะ ทอเนาะ โน่ง ปุย เซ ฮา โม อิซราเอน ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ปะ ไมจ เปอะ โกว โกตไม เซ ละ ปุย ฮอยจ ละ เฆียง เฮี โครยญ เจน ปุย. ป มัฮ ปุย ซพรอต รอาวม นึง ปุย เซ, ไมจ โรฮ อื ซัก เครอึง เซอึก แตะ. ดัฮ ไก ปุย โคะ ไปญ รอาวม เซ, ซ แปน ปุย รแอม ไล ฆาื อื ฮอยจ เมือ กปู อื. ");
INSERT INTO lcp_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","โอเอีฮ เมาะ ป โคะ ไปญ ปุย รแอม ไล อื เซ, โอเอีฮ เซ ซ ลอต แปน ป รแอม ไล ฆาื อื. ดัฮ ไก ปุย โคะ ไปญ โอเอีฮ เซ, ปุย เซ ซ แปน โรฮ ปุย รแอม ไล ฆาื อื ฮอยจ ละ เมือ กปู อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","เญือม เอีจ ฮอยจ โม อิซราเอน นึง ลาึน เวือฮ ติ โดฮ ก อัฮ ปุย ลาึน ซิน ไม่ อื เซ, ยุฮ ไคะ อาวต แตะ นึง ย่วง คาเด่ต. ปุก เคิ ติ นึง อื. มิเรียม ยุม นา เซ. ปุย รมอยจ อื นา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","นา ก อาวต อื เซ ไก โตว รอาวม นึง. ปุย รโจะ รเจอึม ฆาื อื ซองนา ไอ โมเซ ไม่ อาโรน. ปุปิ ละ ปุย ลอา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","เติ ไอ โมเซ ไม่ อื. อัฮ เฮี, “มัฮ ยุม เมอะ ซองนา พากัง ยุฮ พะจาว ตอก โม เอียกปุ อุ ไมจ เดียก เนิ. ");
INSERT INTO lcp_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","เมอยุ ตาว เปอะ เอะ ฮอยจ นึง ลาึน เวือฮ เฮี? อัม มัฮ ซ เกือฮ เปอะ เอะ ยุม เยือ นา เฮี เตือง เอะ เตือง คอง เลียง เงอะ? ");
INSERT INTO lcp_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","เมอยุ ตาว เปอะ เอะ โอก ฮา เมือง อียิป ฮอยจ นึง นาตี โซะ ไซญ ลัมลอน เฮี? ไก โตว ป เกียฮ ไอม นึง เฟือฮ. ปัง มัฮ เฮงาะ รโกะ, เปลิ เม เปลิ อะงุน, เปลิ ทัปทิม ไม่ โอเอีฮ ไฮญ ญุ่ก, ไก โตว ติ ตื. รอาวม ญุ อุ ปได่ะ ปุ ไก,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ไอ โมเซ ไม่ อาโรน ราึต ฮา ปุย โฮวน เซ ชุง โตะ รเวือะ พากัง ก ฮอยจ ปุย เคะ พะจาว เซ. ไอจ รเคอึป ลังเตะ. รัง ซเปีย ยุฮ พะจาว เปลีฮ ติ แตะ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ตุย โรวก โคะ ฆิ ยุฮ เปอะ เซ. ฟวยจ เซ ปะ ไม่ อาโรน ไมจ เปอะ เกือฮ ปุย โฮวน เซ รโจะ รเจอึม. ไมจ เปอะ ลปุง ไม่ ซโมะ ระ ป อาวต นา เซ ซองนา ปุย เตือง โอยจ อื. รอาวม ซ จาึฮ เอิน โอก เน่อึม นึง ซโมะ เซ. มัฮ ตอก เซ ตอก ซ เกือฮ เปอะ รอาวม โอก เน่อึม นึง ซโมะ เซ ละ ญุ ปุย อื เตือง โกะ อื เตือง คอง เลียง อื โรฮ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ไอ โมเซ ตุย เนอึม โคะ ฆิ ป อาวต ซองนา พะจาว เซ ตัม ดวน พะจาว แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","โฮว ดิ ไม่ อาโรน กอก ปุย รโจะ ดิ โบ ซโมะ เซ. ไอ โมเซ อัฮ เฮี, “โม เปะ ป กอ เลฮ เตียง เงอ, เอะ อัม มัฮ ซ จัมเปน เนอะ เกือฮ รอาวม โอก ละ เปอะ เน่อึม นึง ซโมะ เฮี แล?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","เญือม เซ ไอ โมเซ ยวก โคะ ฆิ แตะ เซ, ปุฮ ซโมะ เซ นึง อื ลอา เตะ. รอาวม จาึฮ โปยญ เอิน โอก ฮา ซโมะ เซ. ปุย โฮลฮ ญุ อื เตือง คอง เลียง อื เตือง โอยจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ ไม่ อาโรน, “โม เปะ เจือ เปอะ โตว ป อัฮ อาึ ละ แตะ. เกือฮ เปอะ โตว อาึ โฮลฮ โญตซัก แตะ ซองนา โม อิซราเอน. เคียง มัฮ อื ตอก เซ โม เปะ ซ โฮลฮ เปอะ โตว โรฮ นัม ปุย โฮวน เฮี ฮอยจ ละ เลียก อื เมือง เกือฮ อาึ ละ อื ฆาื อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","โอเอีฮ ตอก เซ เกิต ละ ปุย นึง นาตี เมรีบ่า. มัฮ นา ก รักเริ ปุย ไม่ เติ อื พะจาว. เอีจ มัฮ นา เซ ก เปลีฮ พะจาว ติ แตะ ละ ปุย เกือฮ อื ยุง มัฮ แตะ ป ซง่ะ ซงอม ไม่ มัฮ อื ป ซัมคัน เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","เญือม อาวต อื นึง ย่วง คาเด่ต เซ ไอ โมเซ ดวน โม ป โฮว ฆรอ แตะ ง่อน, เกือฮ อื โฮว ฮอยจ เคะ กซัต นึง เมือง เอโด่ม. เกือฮ อื อัฮ เฮี ละ อื, “เฮี มัฮ รซอม โม อิซราเอน ป มัฮ เอียกปุ เปอะ เซ. ปะ ตึน เอีจ ยุง เปอะ ไอฮ ไลลวง เม่ะมั่ก รพาวม ตุก ป เกิต ละ เอะ เอ, ");
INSERT INTO lcp_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ตอก เญือม โฮว อาวต โม จัตเจือ ไพรม เอะ นึง เมือง อียิป เลี่ญ โฮ, ไม่ ตอก โคมเฮง ปุย เมือง อียิป อื, ฮอยจ โรฮ ละ โคมเฮง อื เอะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","เญือม เซ เอะ กอก ปัว พะจาว เรอึม แตะ. พะจาว ง่อต เนอึม อื เนิ, เกือฮ เอิน เตปด่า ยุฮ แตะ ฮอยจ นัม เอะ เกือฮ โอก ฮา เมือง อียิป เซ. ปเลี่ย เฮี เอะ อาวต นึง ย่วง คาเด่ต, ป มัฮ ย่วง อาวต ซดิ ไม่ เคต ก อาวต ปะ เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ปัว ปะ เกือฮ โม เอะ โฮว คระ พา เมือง อาวต เปอะ เซ. โม เอะ ไม่ ซัตซิง ยุฮ ฮุ ซ โอก โตว โนก คระ ติญ. ซ เลียก โตว โรฮ โตะ ชิจ โตะ ม่า ไม่ โตะ รปึม ยุฮ เปอะ เฟือฮ เอิน. รอาวม นึง นัมโม่ ยุฮ เปอะ ปุ โรฮ ซ ญุ. เอะ ซ โฮว ตัม คระ ติญ เซ ฮอยจ ละ โปน แตะ เคต อาวต เปอะ เซ,” อัฮ เซ รซอม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ปุย นึง เมือง เอโด่ม เซ ปังเมอ โลยฮ อื ตอก เฮี, “เอะ ญอม โตว เกือฮ โม เปะ โฮว คระ พา เมือง อาวต แตะ เฮี. ตัม ลู เปอะ โฮว พา, เอะ ซ โฮว รุป ปุ แตะ ไม่ โม เปะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","โม อิซราเอน ปัว แม อื นึง กซัต เซ ตอก เฮี, “เอะ ซ โฮว ตัม คระ ติญ เซ โน่ง. ปัง มัฮ เอะ, ปัง มัฮ ซัตซิง ยุฮ ฮุ, ดัฮ โคะ ญุ รอาวม ยุฮ เปอะ, เอะ ซ กัฮ งวยฮ อื ละ เปอะ นึง มาื. เอะ มัฮ โตว ฆวต ไอฮ ป ไฮญ. มัฮ จัมเปน โฮว คระ พา เมือง อาวต เปอะ เซ ติ เจือ โน่ง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","โม เอโด่ม โลยฮ แม อื ตอก เฮี, “เอะ ญอม โตว เกือฮ โม เปะ โฮว พา,” อัฮ เซ. เญือม เซ โม เอโด่ม โกฮ โฮว ฆาื อื ไม่ โม ตฮัน ยุฮ แตะ, ริ รุป ปุ แตะ ไม่ โม อิซราเอน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","เญือม โอ โม เอโด่ม เซ ญอม เกือฮ โฮว คระ พา เมือง อาวต แตะ ตอก เซ, โม อิซราเอน ลอต โฮว ฆาื อื คระ ไฮญ. ");
INSERT INTO lcp_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","โม อิซราเอน เตือง โอยจ อื โอก โฮว ฮา ย่วง คาเด่ต ฮอยจ นึง บลาวง โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","พะจาว อัฮ อื ละ ไอ โมเซ ไม่ อาโรน นึง บลาวง โฮ ป มัฮ เฆียง เคต เอโด่ม เซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“อาโรน ซ โฮลฮ โตว เลียก นึง เมือง ป ซันญา อาึ ซ เกือฮ แตะ ละ โม อิซราเอน เซ. ซ ยุม ฆาื โอ เปะ ลอา เนอึง ป อัฮ อาึ นึง นาตี เมรีบ่า โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","ไมจ เปอะ เกือฮ อาโรน ไม่ กวน อื ป มัฮ เอเลอาซา เซ ฮาวก ดิ ไม่ เปอะ ฮอยจ นึง บลาวง โฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","ฟวยจ เซ ไมจ เปอะ ปอยจ ลปิ อาโรน ป มัฮ ลปิ ซตุ อื เซ, จาวป ละ เอเลอาซา เซ. อาโรน ซ ยุม นา เซ นึง ซ รโจะ อาึ อื ไม่ โม จัตเจือ ไพรม อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ไอ โมเซ ยุฮ เนอึม อื ตัม ป อัฮ พะจาว ละ แตะ เซ. โฮว ฮาวก เนอึม ไม่ อาโรน ไม่ เอเลอาซา ฮอยจ นึง ไกญ บลาวง โฮ เซ ซองนา ปุย เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","เญือม เซ ปอยจ เนอึม ลปิ ซตุ อาโรน เซ, จาวป อื ละ เอเลอาซา เซ. อาโรน ยุม เนอึม นึง ไกญ บลาวง เซ. ฟวยจ เซ ไอ โมเซ ไม่ เอเลอาซา เลีฮ เน่อึม นึง บลาวง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","เญือม เอีจ ยุ ฮมอง ปุย เตือง โอยจ อื ยุม อาโรน เซ, โม อิซราเอน เยือม ยุม อื เซ ง่วย ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ป มัฮ กซัต เมือง อารัต มัฮ โม คะนาอัน ป อาวต นึง เนเกป เซ, ฮมอง ฮอยจ โม อิซราเอน เน่อึม คระ อาทาริม เซ. โกฮ โฮว เอิน ฆาื อื ไม่ ตฮัน ยุฮ แตะ ละ ซ รุป อื ปุ แตะ ไม่ โม อิซราเอน. โฮมวต คัง อาึง โม อิซราเอน เซ ง่อน. ");
INSERT INTO lcp_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","เญือม เซ โม อิซราเอน ซันญา อื ละ พะจาว ตอก เฮี, “ดัฮ เปอะ เกือฮ เอะ เป ปุย โม เฮี โฮ, เอะ ซ ยุฮ ไลจ ไม่ เญือะ บ่วง บั่นเมือง ยุฮ อื เกือฮ โอยจ แกล เอิน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","พะจาว ง่อต เนอึม ป อัฮ โม อิซราเอน เซ, เรอึม อื เกือฮ อื เป โม คะนาอัน ป อาวต นา เซ. โม อิซราเอน ยุฮ เนอึม ไลจ ไม่ บั่นเมือง ยุฮ อื ไม่ ปุย นึง อื. ฟวยจ เซ ลอต ปุก มอยฮ นา เซ, อัฮ โฮรมา ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","โม อิซราเอน โอก โฮว ฮา บลาวง โฮ เซ, โฮว คระ ปลัฮ รอาวม ซครัก ละ ซ เวีย แตะ เมือง เอโด่ม. เญือม โฮว อื คระ เซ เงี่ยง รพาวม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","เติ พะจาว ไม่ เติ อื ไอ โมเซ ตอก เฮี, “เมอยุ ตาว เปอะ เอะ โอก ฮา เมือง อียิป ละ ซ เกือฮ เปอะ เอะ ยุม ปลาว นึง ลาึน เวือฮ เฮี? ไก โตว ป โซม ป ปอน นึง. รอาวม ญุ อุ ปุ ไก. เอีจ เตือ เอีจ ออป เนอึม นึง โซม แตะ โอเอีฮ ไอฮ พาวม แตะ ตอก เฮี. เญาะ เลียก โตว ยุฮ เฟือฮ เอิน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","เญือม เซ พะจาว เกือฮ ซโอยญ ปิต โฮวน เลียก ลลาึง ปุย. ปวก โม อิซราเอน โฮวน ปุย. โฮวน ป ยุม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","เญือม เซ ปุย โฮวน เซ ฮอยจ เคะ ไอ โมเซ ฆาื อื. อัฮ เฮี ละ อื, “เอะ เอีจ พิต เนอึม เมอะ นึง เติ แตะ พะจาว ไม่ เติ แตะ ปะ. ไมจ เปอะ ไววอน ปัว พะจาว ตุย ซโอยญ โม เฮี ฮา เอะ,” อัฮ เซ ละ อื. ไอ โมเซ ไววอน เนอึม เพือ อื. ");
INSERT INTO lcp_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","เญือม เซ พะจาว ดวน ไอ โมเซ ยุฮ ฮุป ซโอยญ นึง ไร ซเงี. เกือฮ อื อาึง อื นึง เปือง โคะ ติ โฆง. ป ออฮ ป เอีฮ ญุ่ก, เมาะ ป ปวก ซโอยญ อื เซ เญือม โฮลฮ อื แก ฮุป ซโอยญ เซ ซ ไฮ เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ไอ โมเซ ยุฮ เนอึม ฮุป ซโอยญ นึง ไร ซเงี. อาึง เนอึม อื นึง เปือง โคะ โบลวง แตะ ติ โฆง. ป ออฮ ป เอีฮ ญุ่ก, ป โฮลฮ ซโอยญ ปวก เซ, ดัฮ โฮว แลน ฮุป ซโอยญ ไร ซเงี เซ ซ ไอม เนอึม เบือ อื. ");
INSERT INTO lcp_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","โม อิซราเอน โฮว ยุฮ แม ไคะ อาวต แตะ นึง ย่วง โอโบ่ต. ");
INSERT INTO lcp_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ฟวยจ โอก อื ฮา ย่วง โอโบ่ต เซ โฮว ยุฮ แม ไคะ นึง เบือง ย่วง อาบ่าริม, นึง ลาึน เวือฮ. ปุก ลวง ลั่ก โอก ซเงะ ละ เมือง โมอัป เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","ฟวยจ เซ โฮว ยุฮ แม ไคะ อาวต แตะ นึง ลโลวง เซเรต. ");
INSERT INTO lcp_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","ฟวยจ โอก อื เน่อึม นา เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง เฆียง โกลง อาโนน, ลวง ลั่กล่าวง อื. ปุก นึง ลาึน ป รติต ไม่ นาตี อาวต โม อาโมไร. (โกลง อาโนน เซ แปน เอิน ม่าื เตะ ละ ปุย โมอัป ไม่ ปุย อาโมไร.) ");
INSERT INTO lcp_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","มัฮ ฆาื เซ ป ไก อื นึง นังซื ป อู ไลลวง กัน รุป เซิก ยุฮ พะจาว เซ ฆาื ตอก เฮี, “ย่วง วาเฮป นาตี ซุฟา ไม่ ฮอง โกลง อาโนน, ");
INSERT INTO lcp_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ไม่ เตะ ลโลวง นา โม เซ, ฮอยจ ละ เมือง อา, รติต ฮอยจ ละ นาตี เมือง โมอัป เซ,” อัฮ เซ รซอม นังซื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","โม อิซราเอน โอก เน่อึม นา เซ โฮว แม ฮอยจ ละ นา ก อัฮ ปุย เบ่เออ ไม่, (มัฮ อัฮ อื นัมโม่ ไม่.) เญือม เซ พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ เกือฮ ปุย เตือง โอยจ อื ฮอยจ รโจะ นา เฮี, อาึ ซ เกือฮ รอาวม ละ ซ ญุ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","เญือม เซ โม อิซราเอน เชีย นึง รซอม เชีย แตะ ตอก เฮี. เออ, นัมโม่ โด่ะ, โตะ ลาึน เวือฮ. เกือฮ รอาวม ฮาวก, ปอ นาวก เตม. เอะ เชีย เนอึม ไม่ ไก พาวม มวน. เชีย ลเบี่ย ปาึง, บาึง รพาวม. ");
INSERT INTO lcp_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","มัฮ นัมโม่ ไพรม, ไตม ป กาวง. กาวง โม ฮัวนา, กา เจน เอะ. กาวง นึง โคะ ฆิ, ริ รอาวม. พาวม เนอึม ติ โดฮ, โฮลฮ นัมโม่. โคะ ฆิ กซัต, ปัต รอาวม. อัฮ เซ. ฟวยจ เซ โม อิซราเอน โอก โฮว เน่อึม ลาึน เวือฮ เซ, ฮอยจ นึง นาตี มัตทานา. ");
INSERT INTO lcp_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","โอก โฮว แม เน่อึม นา เซ ฮอยจ นึง นาตี นาฮะลีเอน. โอก เน่อึม นาตี นาฮะลีเอน เซ ฮอยจ นึง นาตี บ่าโมต. ");
INSERT INTO lcp_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","โอก เน่อึม บ่าโมต ฮอยจ นึง ลโลวง ป มัฮ นาตี อาวต ปุย โมอัป ชวง บลาวง ปิซกา. เน่อึม นึง ไกญ บลาวง ปิซกา เซ ปุย ฮอยจ ชวน ลาึน เวือฮ. ");
INSERT INTO lcp_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","โม อิซราเอน ดวน ปุย เกือฮ อื โฮว ฮอยจ เคะ กซัต ซีโฮน ป มัฮ กซัต ยุฮ ปุย อาโมไร เซ. เกือฮ อื อัฮ เฮี ละ อื, ");
INSERT INTO lcp_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“ปัว เปอะ เกือฮ เอะ โฮว คระ พา เมือง อาวต เปอะ เซ. โม เอะ ไม่ ซัตซิง ยุฮ ฮุ ซ โอก โตว โนก คระ ติญ, ไม่ โอ เยอะ ซ เลียก โตะ ชิจ, โตะ ม่า, ไม่ โตะ รปึม ยุฮ เปอะ เฟือฮ เอิน. รอาวม โตะ นัมโม่ ยุฮ เปอะ ปุ โรฮ ซ เชียต ญุ โรฮ. โม เอะ ซ โฮว ตัม คระ ติญ เซ ฮอยจ ละ โปน แตะ เมือง อาวต เปอะ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","กซัต ซีโฮน เซ ปังเมอ โอ ญอม เกือฮ โม อิซราเอน โฮว คระ พา เมือง อาวต แตะ เซ. กซัต เซ เกือฮ โม ตฮัน ยุฮ แตะ รโจะ, โอก โฮว ไม่ อื ฮอยจ นึง นาตี ยาฮัต นึง ลาึน เซ. เญือม เซ เลียก รุป ปุ แตะ ไม่ โม อิซราเอน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","เญือม รุป อื ปุ แตะ ตอก เซ โม อิซราเอน ปังเมอ โฮลฮ ยุฮ ยุม ไม่ โม เซ โฮวน. โฮลฮ เลียก กุม ปลัฮเตะ ยุฮ อื, เน่อึม นึง ฮอง โกลง อาโนน ลวง ลั่กเซฮ ฮอยจ ละ โกลง ยัปบ่อก ลวง ลั่กล่าวง. ฮอยจ โรฮ นึง ยาเซอ ป มัฮ ม่าื เตะ โม อัมโมน. ");
INSERT INTO lcp_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","โม อิซราเอน โฮลฮ โรฮ กุม บั่นเมือง ยุฮ โม อาโมไร โฮวน โดฮ, ฮอยจ ละ เวียง เฮตโบ่น ไม่ ย่วง ป อาวต รวิต รเวียง อื เซ. ลอต เอิน อาวต นึง อื, เกือฮ อื แปน บั่นเมือง ยุฮ โม โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","เวียง เฮตโบ่น เซ มัฮ เมือง ลวง ยุฮ กซัต ซีโฮน, ป มัฮ กซัต ยุฮ ปุย อาโมไร เซ. ไพรม อื กซัต ซีโฮน เซ เอีจ รุป ปุ แตะ ไม่ กซัต เมือง โมอัป เซ ไม่ ลู อื บั่นเมือง ยุฮ อื ฮา อื ฮอยจ นึง โบ โกลง อาโนน. ");
INSERT INTO lcp_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","มัฮ เซ ป อัฮ โม อาโมไร อื นึง รซอม เชีย แตะ ฆาื อื ตอก เฮี, “ไมจ เอะ โฮว ฮอยจ นึง เมือง เฮตโบ่น, ป มัฮ เมือง ยุฮ กซัต ซีโฮน เซ ละ ซ โก โคระ โอะ เมือง เซ เกือฮ ตอน ฮมัน. ");
INSERT INTO lcp_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","ไก ม่าึต งอ โอก เน่อึม นึง เมือง เฮตโบ่น เซ. ไก โรฮ รเออึป งอ โอก เน่อึม นึง เมือง อาวต ซีโฮน เซ. เมือง อา ยุฮ โมอัป ป ไก นึง ตู ฮลาวง เดือะ โกลง อาโนน เซ, เอีจ ไลจ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","เออ, โม เปะ ป อาวต นึง เมือง โมอัป ซ เม่ะมั่ก เนอึม เปอะ. เออ, โม เปะ ป ไว พะเคโมต เตอ, เอีจ ไลจ โลม เนอึม เปอะ. โม ปรเมะ ไน พะเคโมต เซ เอีจ โฮลฮ เนอึม ตอ เม่าะ, โม ปรโปวน นึง อื เอีจ โฮลฮ แปน ครา ซีโฮน กซัต อาโมไร เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","เอะ เตือง มู เยอะ เอีจ ตอซู เนอึม เมอะ, เอะ เป เนอึม ปุย โม เซ เบือ อื. เมือง เฮตโบ่น เอีจ ไลจ เนอึม ฮอยจ นึง เมือง ดี่โบ่น. เอะ โฮลฮ ยุฮ ไลจ ไม่ ฮอยจ นึง เมือง โนฟา, ป ไก โบ เมือง เมเด่บ่า เซ,” อัฮ เซ นึง รซอม เชีย แตะ โม เซ เยอ. ");
INSERT INTO lcp_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","เคียง เซ โม อิซราเอน โฮลฮ เนอึม อาวต นึง เมือง อาโมไร เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ฟวยจ เซ ไอ โมเซ ดวน ปุย โฮว เลียป เมือง ยาเซอ. ปุย โม เซ โฮว เนอึม, ตอซู ปุ แตะ ไม่ ปุย เมือง เซ, โฮลฮ เนอึม เมือง ยาเซอ เซ ไม่ ย่วง อาวต รวิต รเวียง อื แปน คอง แตะ, ไม่ โครฮ อื ปุย อาโมไร เซ เกือฮ ตอ ฮา นา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","ฟวยจ เซ โม อิซราเอน โอก โฮว แม คระ เมือง บ่าชัน. เญือม เซ กซัต โอก ป มัฮ กซัต เมือง บ่าชัน เซ โกฮ โฮว ไม่ โม ตฮัน ยุฮ แตะ, ละ ซ รุป อื ปุ แตะ ไม่ โม อิซราเอน นึง ย่วง เอตเรอี. ");
INSERT INTO lcp_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","พะจาว อัฮ เฮี ฆาื อื ละ ไอ โมเซ. “ปุ ฮลัต นึง ปุย โม เซ เยอ. อาึ ซ เกือฮ ปะ โฮลฮ เป กซัต เซ, ไม่ ปุย ไน ปะเทต ยุฮ อื เตือง โอยจ อื. ไมจ เปอะ ยุฮ ละ กซัต โอก เซ ตอก ยุฮ เปอะ ละ ซีโฮน, ป มัฮ กซัต ยุฮ ปุย อาโมไร ป ตัตเตียง เมือง เฮตโบ่น โฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","เญือม เซ โม อิซราเอน ยุฮ เนอึม ยุม ไม่ กซัต โอก, ไม่ โม กวน เฌือต อื ไม่ ปุย ไน บั่นเมือง ยุฮ อื เตือง โอยจ อื. เกือฮ โตว อื ไก ป โปน ฮา ยุม แตะ ติ ปุย เนอึม. ฟวยจ เซ ลอต เอิน เลียก อาวต นึง บั่นเมือง ยุฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","โม อิซราเอน โฮว ลั่กกา แตะ ปุ ปุ. ยุฮ ไคะ อาวต แตะ นึง ลโลวง เมือง โมอัป บลัฮ โกลง จอแด่น ลั่ก โอก ซเงะ รเตือป เมือง เยรีโค. ");
INSERT INTO lcp_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","กซัต บ่าลัก ป มัฮ กวน ซีโพ ฮมอง ป ยุฮ โม อิซราเอน ละ โม อาโมไร. ");
INSERT INTO lcp_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","โม โมอัป ฮลัต เนอึม ฮลัต แนม นึง โม อิซราเอน ฆาื อื นึง โฮวน ลัมเลือ อื ละ แตะ. โม โมอัป ฮลัต เตีจ ลัมเลือ เอิน ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","โม ลัปซด่อน นึง เมือง โมอัป ฮอยจ ซิงซา ดิ อื ไม่ โม ป กวต เมือง มีเดี่ยน ฆาื อื. อัฮ เฮี, “ปุย โฮวน โม เฮี ตึน ซ โอยจ ยุฮ เมือง เอะ ตอก เปือม โมวก ไรป จัว ฮอยจ ละ โอยจ อื โฮ,” อัฮ เซ ละ ปุ แตะ. เญือม เซ บ่าลัก กวน ซีโพ ป มัฮ กซัต ยุฮ โม โมอัป เซ ");
INSERT INTO lcp_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ดวน กวนไจ ยุฮ แตะ โฮว กอก บ่าลาอัม กวน เบ่โอ ฮอยจ เรอึม แตะ. บ่าลาอัม เซ อาวต นึง เมือง เปโท โบ โกลง ยูฟะเรตี. มัฮ เมือง โกะ อื ไอฮ. โม กวนไจ กซัต เซ ฮอยจ อัฮ เฮี ละ อื, “ง่อต แลน, ไก ปุย ติ เมือง เดอึม ฮอยจ เน่อึม นึง เมือง อียิป. เลี่ป เอิน ปลัฮเตะ แควน เอะ เฮี. ปเลี่ย เฮี กัมลัง อาวต นึง รเตือป เวียง อาวต เตอะ. ");
INSERT INTO lcp_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ปัว ปะ ฮอยจ ซะ ซม่อต ปุย โม เซ ละ แตะ ปเลี่ย เฮี เอิน. เอะ แจง โอ ซ เป ไอฮ นึง โกะ แตะ นึง โฮวน ลอน อื. ดัฮ ปะ ซะ ซม่อต โฮ, เอะ ตึน ซ เกียฮ เป ฆาื อื. ตึน ซ เกียฮ โครฮ โฮะ โอก ฮา เมือง แตะ. อาึ ยุง เงอะ ป ปิฮ ปะ มุ่น ละ ซ โฮลฮ เนอึม มุ่น. ป ซะ ซม่อต เปอะ ซ ลอก เนอึม ป โซะ,” ดวน อื อัฮ เซ ละ บ่าลาอัม. ");
INSERT INTO lcp_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","โม ป กวต ป เฮียง เมือง โมอัป ไม่ เมือง มีเดี่ยน เนอ, โรวก โรฮ เครอึง ไม่ มาื ละ ซ จัง แตะ บ่าลาอัม นึง อื, ละ ซ เกือฮ อื ซะ ซม่อต ปุย. อัฮ เนอึม อื ละ อื ตอก ดวน กซัต แตะ อัฮ. ");
INSERT INTO lcp_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","บ่าลาอัม โลยฮ อื ละ อื ตอก เฮี, “ไอจ นา เฮี ติ ซาวม. อาึ ซ รโฮงะ ละ เปอะ ป ซ ยุฮ แตะ ตัม ดวน พะจาว แตะ อัฮ,” อัฮ เซ ละ อื. โม ป กวต เมือง โมอัป เซ ไอจ เนอึม เญือะ บ่าลาอัม ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ซาวม เซ พะจาว ฮอยจ เคะ บ่าลาอัม. ไฮมญ อื ตอก เฮี, “โม ป ไอจ นา เฮี มัฮ ปุย ตอก เมอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","บ่าลาอัม อัฮ เฮี, “บ่าลัก กวน ซีโพ ป มัฮ กซัต เมือง โมอัป เอีจ ตอม มวยญ แตะ ละ อาึ ตอก เฮี, ไก ปุย ติ เมือง เดอึม ฮอยจ เน่อึม นึง เมือง อียิป. ");
INSERT INTO lcp_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","เลี่ป เอิน ปลัฮเตะ แควน ก อาวต อื. ปัว อาึ ฮอยจ ซะ ซม่อต อื ละ แตะ เดอึม ซ เกียฮ เป อื. เญือม เซ ซ โฮลฮ โครฮ อื โอก ฮา เมือง แตะ ฆาื อื,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","พะจาว อัฮ เฮี ละ บ่าลาอัม, “ปุ โฮว ไม่ เฟือฮ เอิน. ปุ ซะ ซม่อต ละ อื. ปุย โม เซ มัฮ ป ปิฮ อาึ มุ่น ละ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","เมือ กซะ อื บ่าลาอัม โกฮ อู ไม่ โม ป กวต เมือง โมอัป เซ. อัฮ เฮี ละ อื, “เอีญ เมือง เปอะ เมิฮ. พะจาว คัต อาึ รัม โฮว ไม่ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","โม ป กวต เมือง โมอัป เซ โกฮ เอีญ เนอึม ฆาื อื. “บ่าลาอัม ญอม โตว โฮว ไม่ เอะ,” อัฮ เซ ละ กซัต บ่าลัก. ");
INSERT INTO lcp_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","เญือม เซ กซัต บ่าลัก ดวน แม ปุย โฮว เคะ บ่าลาอัม ติ โฮน แม. โม ป โฮว โฮน เฮี มัฮ ป ระ ไล ฮา โม ป โฮว โฮน รกา เซ. โฮวน ฮา ไพรม แตะ ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","โม เซ ฮอยจ โรฮ เคะ บ่าลาอัม. อัฮ เฮี ละ อื, “เฮี มัฮ รซอม กซัต บ่าลัก กวน ซีโพ. ‘ปุ เกือฮ โอเอีฮ คัต เปอะ รัม ฮอยจ เคะ อาึ. ");
INSERT INTO lcp_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","อาึ ซ เกือฮ ปะ แปน ป ระ ป คาว ลลาึง ปุย. ปัว ปะ ออฮ นึง เงอะ ซ เกือฮ เซ ละ เปอะ. ไมจ เปอะ ฮอยจ ซะ ซม่อต ปุย โม เฮี ละ อาึ,’ อัฮ เซ ละ เปอะ กซัต บ่าลัก เกอ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","บ่าลาอัม โลยฮ อื ละ กวนไจ บ่าลัก เซ ตอก เฮี, “ปัง เกือฮ กซัต บ่าลัก เซ ไคร มาื เนิ ปอ นาวก เญือะ ยุฮ อื เอิน, อาึ ปุน ยุฮ โตว ป โฮฮ ฮา ป อัฮ เยโฮวา พะจาว ทื แตะ ละ แตะ. ไลลวง ป ระ ไล ญุ่ก, ไลลวง ป แตวะ ไล ญุ่ก, ปุน ยุฮ โตว. ");
INSERT INTO lcp_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","ตอก ออฮ ตอก เอีฮ ญุ่ก, ไมจ เปอะ ไอจ นา เฮี ติ ซาวม ตอก ไอจ โม เซ โรฮ, เดอึม อาึ ซ ฮมอง ป ซ อัฮ โคระ แม พะจาว ละ แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ซาวม เซ พะจาว ฮอยจ แม เคะ บ่าลาอัม. อัฮ เฮี ละ อื, “ดัฮ ปุย โม เซ เอีจ ฮอยจ กอก เปอะ โฮ, โกฮ โฮว ไม่ เมิฮ, ปังเมอ โอ เปอะ ไมจ ยุฮ โฮฮ ฮา อัฮ อาึ อื ละ เปอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","ปวยฮ พริ เซ บ่าลาอัม โกฮ ฮัง บรัง ยุฮ แตะ, โฮว ไม่ โม ป กวต เมือง โมอัป เซ. ");
INSERT INTO lcp_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","เญือม เซ พะจาว รอก พาวม ฆาื โฮว บ่าลาอัม ไม่ โม เซ. เตปด่า ยุฮ พะจาว ฮอยจ อาวต ฆาื อื นึง คระ ละ ซ ตอซู อื ปุ แตะ ไม่ อื. บ่าลาอัม บุก ปุ โฮว บรัง. โฮว ไม่ กวนไจ ยุฮ แตะ ลอา ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","เญือม เซ บรัง เซ ยุ ฮอยจ เตปด่า ยุฮ พะจาว เซ อาวต เฆียง คระ ไม่ ไปญ แตะ วิจ. บรัง เซ วิฮ ฮา คระ ฆาื อื นึง เวีย แตะ เตปด่า เซ, เลียก โตะ ชิจ. บ่าลาอัม ปุฮ อื นึง โคะ ฆาื อื เกือฮ อื แม นึง คระ. ");
INSERT INTO lcp_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ฟวยจ เซ เตปด่า ยุฮ พะจาว เซ ฮอยจ ชุง ซน่ะ รปึม อะงุน ลอา นา ก ไก ฆรุง ซโมะ เตือง ลอา ก บลัฮ คระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","เญือม ยุ บรัง เซ เตปด่า เซ, ไบรจ เอิน ติต ฆรุง เอิน, นิ่ป เอิน ชวง บ่าลาอัม ฆาื อื ไม่ ฆรุง เซ. บ่าลาอัม เซ ปุฮ แม บรัง ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ฟวยจ เซ เตปด่า ยุฮ พะจาว เซ โฮว แม ลั่กกา แตะ ฮอยจ นา ก ซไกป คระ นา ก โอ อื เญาะ ไก ตอก ซ เกียฮ ไบรจ เตือง ลั่ก วิ ลั่ก ดอม อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","เญือม ยุ บรัง เตปด่า เซ โมป เอิน ฆาื อื. เญือะ ญอม โตว โฮว. บ่าลาอัม ฮาวก รพาวม ซาวม ไง่ ฆาื อื. ปุฮ เนอึม ปุฮ แนม บรัง ยุฮ แตะ นึง โคะ ฆิ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","เญือม เซ พะจาว โปฮ มวยญ บรัง เซ เกือฮ อื เกียฮ ลปุง. อัฮ เฮี, “เมอ ป ยุฮ อาึ ละ เปอะ? เกียฮ ปุฮ โน่ง เปอะ อาึ ลอวย โฮน เอิน เมอ?” อัฮ เซ ละ อื บรัง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","บ่าลาอัม เซ โลยฮ อื, “ปะ เตอ พลิฮ ลอน เปอะ อาึ. มัฮ ไก วิจ เจอะ เอีจ ฟวยจ มอก ปะ ปอ ยุม เปอะ เอิน,” อัฮ เซ ละ บรัง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","บรัง เซ โลยฮ แม อื ละ บ่าลาอัม ตอก เฮี, “อาึ โม่ มัฮ บรัง บุก ลอป ปะ โครยญ ซเง่ะ ฮอยจ ปเลี่ย? ไพรม อื อาึ อัม ไก เญือม ยุฮ ละ ปะ ตอก ยุฮ แตะ เนาะ เฮี?” อัฮ เซ ละ อื. “ไก โตว,” อัฮ เซ บ่าลาอัม. ");
INSERT INTO lcp_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ฟวยจ เซ พะจาว โปฮ ไง่ บ่าลาอัม เกือฮ อื เกียฮ ยุ เตปด่า ยุฮ พะจาว ป ชุง นา เซ ไม่ ไปญ แตะ วิจ เซ. บ่าลาอัม นุ่ม เอิน ปอ จิ ไกญ แตะ เตะ. ");
INSERT INTO lcp_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","เตปด่า เซ อัฮ เฮี, “เมอยุ ปุฮ เปอะ บรัง ยุฮ แตะ ลอวย โฮน เอิน เนอ? ง่อต แลน. อาึ มัฮ ฮอยจ คัต เวียน ปะ นึง โอ คระ โฮว เปอะ ปุก ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","บรัง เซ ยุ อาึ. เอีจ เวีย อาึ ลอวย โฮน. มัฮ โอ อื ยุฮ ตอก เซ อาึ แจง เอีจ ยุฮ ยุม ไม่ ปะ เตือง เกือฮ แตะ บรัง เซ ไอม,” อัฮ เซ เตปด่า เซ. ");
INSERT INTO lcp_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","บ่าลาอัม อัฮ เฮี ละ เตปด่า เซ, “อาึ เอีจ พิต เตอะ. อาึ ยุง โตว ชุง ปะ นึง คระ ละ ซ คัต เวียน เปอะ อาึ. ปเลี่ย เฮี ดัฮ โอ ปุก ละ ปะ โฮ, อาึ เญือะ ซ โฮว โตว. ซ เอีญ เญอะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","เตปด่า เซ ดวน แม อื ตอก เฮี, “โฮว ไม่ โม เซ เมิฮ. ปังเมอ โอ เปอะ ไมจ อัฮ โอเอีฮ โนก ฮา ไลลวง ป เกือฮ อาึ เปอะ อัฮ ละ อื,” อัฮ เซ ละ อื. บ่าลาอัม โฮว ลั่ง ฆาื อื ไม่ โม ป กวต เมือง โมอัป เซ. ");
INSERT INTO lcp_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","กซัต บ่าลัก เญือม ฮมอง อื ซ ฮอยจ บ่าลาอัม เคะ แตะ, โอก รโนฮ รชึง อื นึง ย่วง อา โบ โกลง อาโนน ป มัฮ ม่าื เตะ เมือง โมอัป เซ. ");
INSERT INTO lcp_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","อัฮ อื ละ บ่าลาอัม ตอก เฮี, “เมอยุ โอ เปอะ ฮอยจ เคะ อาึ เน่อึม เมือ โรง อื? อัม มัฮ แกต เปอะ อาึ โอ ตอม เนอึม แตะ? อัม มัฮ แกต เปอะ อาึ โอ ปุน เกือฮ จังลา แตะ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","บ่าลาอัม อัฮ เฮี, “อาึ เอีจ ฮอยจ เคะ เปอะ. ปัง ฮอยจ เจอะ, อาึ อัม ซ ไก อัมนัต ละ ซ เกียฮ อัฮ โอเอีฮ นึง โกะ แตะ ไอฮ? เกือฮ พะจาว อาึ อัฮ รซอม ตอก ออฮ ซ อัฮ ตอก เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","บ่าลาอัม โฮว ดิ ไม่ กซัต บ่าลัก ฮอยจ นึง ย่วง ฮุโซต. ");
INSERT INTO lcp_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","กซัต บ่าลัก โนก โมวก โนก แกะ ละ ป ทื แตะ นา เซ โฮวน. เกือฮ โตะ ละ บ่าลาอัม ไม่ โม จาวไน โฮว ไม่ อื เซ ง่อน. ");
INSERT INTO lcp_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ปวยฮ พริ ติ แม บ่าลัก ตาว บ่าลาอัม ฮอยจ นึง นาตี ก อัฮ ปุย บลาวง ยุฮ บ่าอัน ไม่. บ่าลาอัม เกียฮ ชวน โม อิซราเอน เน่อึม นา เซ ง่อน โม ป อาวต อื ก ซดิ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","บ่าลาอัม อัฮ เฮี ละ บ่าลัก, “ปัว เปอะ เกือฮ ปุย ยุฮ คัน ซโมะ นา เฮี อาแลฮ, ไม่ เกือฮ เปอะ ซาวป โมวก โปก อาแลฮ ตัว ไม่ แกะ โปก อาแลฮ ตัว โรฮ” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","บ่าลัก ยุฮ เนอึม อื ตอก เซ. ฟวยจ เซ บ่าลัก ไม่ บ่าลาอัม มอก ตอง โมวก ไม่ แกะ นึง คัน เซ. คัน ติ ติ เซ ตอง โมวก นึง อื ติ, แกะ นึง อื ติ โครยญ คัน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","บ่าลาอัม อัฮ เฮี ละ บ่าลัก, “ปะ ไมจ เปอะ ชุง โบ โอเอีฮ ตอง เปอะ ทไว เฮี. อาึ ซ โฮว แลนๆ, เมอ เตือง อื พะจาว ซ ฮอยจ เคะ อาึ ยุ่ง, อัฮ พะจาว ละ อาึ ตอก ออฮ อาึ ซ แม รโฮงะ โรฮ ละ ปะ ตอก เซ,” อัฮ เซ ละ อื. ฟวยจ เซ โกะ อื ฮาวก ฮอยจ เปือง โม ฮลาวง ติ โดฮ. ");
INSERT INTO lcp_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","พะจาว ฮอยจ เคะ อื นา เซ. บ่าลาอัม อัฮ เฮี, “อาึ เอีจ ยุฮ คัน อาแลฮ. เอีจ ทไว โมวก นึง ติ, แกะ นึง ติ, โครยญ คัน เซ,” อัฮ เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","เญือม เซ พะจาว เกือฮ บ่าลาอัม ยุง ป ไมจ แตะ อัฮ ละ บ่าลัก เซ, ดวน อื เอีญ ซึป ลปุง แตะ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","เญือม เอีจ เอีญ บ่าลาอัม เคะ บ่าลัก เซ, ยุ ชุง บ่าลัก โบ เครอึง โนก แตะ เซ. โม จาวไน เมือง โมอัป อาวต โรฮ นา เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","บ่าลาอัม ซึป ลปุง อัฮ พะจาว ละ แตะ ตอก เฮี, “บ่าลัก กซัต เมือง โมอัป กอก อาึ ก ซไง อื, กอก อาึ ฮอยจ เน่อึม นึง เมือง ซีเรีย นึง บลาวง ลั่ก โอก ซเงะ. อัฮ เฮี เนิ, ‘โฮว ซะ ซม่อต เมือง ยาโคป ละ อาึ. โฮว อัฮ ลปุง ตึก นึง โซะ แตะ ละ เมือง อิซราเอน,’ อัฮ เซ เนิ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","อาึ อัม เกียฮ ซะ ปุย โอ พะจาว ซะ? อาึ อัม เกียฮ อัฮ ป โซะ ละ ป โอ พะจาว อัฮ ป โซะ ละ? แจง โอ เกียฮ ฮา. ");
INSERT INTO lcp_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","อาึ เอีจ ชวน โม เซ เน่อึม นึง ไกญ รอัง ก ฮลาวง อื. อาึ แก เยอะ โม เซ เน่อึม นึง ไกญ บลาวง. อาึ ยุ ปุย ติ เมือง ป อาวต โน่ง ฮา ปุย ไฮญ. มัฮ เมือง ป ยุง โฮลฮ แตะ กุนมุ่น โฮวน ฮา เมือง ปุย ไฮญ. ");
INSERT INTO lcp_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","จัตเจือ โม อิซราเอน เอีจ โฮวน ตอก โนง เตะ รกาื เอิน. โฮวน เอิน ปอ โอ ปุย เญาะ โอยจ ยุฮ เมีญ แตะ. อาึ ดัฮ ยุม เกือฮ อาึ ยุม ตอก ปุย ซืไซ ละ พะจาว เซ. ลั่ก ก ลอยจ จีวิต อาึ อื, ปัว เกือฮ ไมจ ตอก ปุย โม เซ โรฮ,” อัฮ เซ บ่าลาอัม. ");
INSERT INTO lcp_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","เญือม เซ บ่าลัก อัฮ เฮี ละ บ่าลาอัม, “มัฮ ตอก เมอ ป ยุฮ เปอะ ละ อาึ เฮี? อาึ เอีจ กอก ปะ เกือฮ เปอะ ซะ ซม่อต ป ซ ตอซู ไม่ เอะ เฮี. ปะ ปังเมอ ลเตือฮ เยือ เปอะ ปิฮ มุ่น ละ ฮา อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","บ่าลาอัม อัฮ เฮี, “อาึ จัมเปน แฮน โอ แตะ อัฮ โอเอีฮ โนก ฮา ลปุง เกือฮ พะจาว อาึ อัฮ. อาึ เกียฮ อัฮ โตว ตอก ไฮญ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ฟวยจ เซ บ่าลัก อัฮ แม เฮี ละ อื, “เอีญ ไม่ อาึ ลั่กเติต ติ โดฮ. ปะ ซ ฮอยจ เปอะ ชวน เน่อึม นา เซ, ซ ชวน เปอะ โม ป อาวต ก ซดิ อื, ชวน เปอะ โตว เตือง โอยจ อื. ตึน ซ เกียฮ แปน ซะ ซม่อต เปอะ เน่อึม นา เซ เยอ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","เญือม เซ ตาว อื ฮอยจ นึง ลโลวง เปือง ตู นึง ไกญ บลาวง ปิซกา นา ก อัฮ ปุย โซฟิม ไม่. ยุฮ แม คัน นา เซ อาแลฮ. โนก โมวก โปก, แกะ โปก นึง อื ติ ติ, โครยญ คัน อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","เญือม เซ บ่าลาอัม อัฮ เฮี ละ บ่าลัก, “ปะ ไมจ เปอะ ชุง โบ เครอึง โนก ยุฮ เปอะ เซ. อาึ ซ โฮว เคะ พะจาว นา เซิต,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","พะจาว ฮอยจ เคะ อื. รโฮงะ ป ซ ไมจ อื อัฮ ละ อื. อัฮ เฮี ละ อื, “เอีญ เคะ บ่าลัก เกอ. อัฮ ละ อื ตอก อัฮ อาึ อื ละ เปอะ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","บ่าลาอัม เอีญ เนอึม. ยุ อาวต ลั่ง บ่าลัก โบ ซัตซิง โนก แตะ เซ. อาวต ไม่ โม จาวไน เมือง โมอัป. บ่าลัก ไฮมญ อื ตอก เฮี, “พะจาว อัฮ อื ละ เปอะ ตอก เมอ?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","บ่าลาอัม ซึป ลปุง อัฮ พะจาว ละ แตะ ตอก เฮี, “เออ บ่าลัก กวน ซีโพ, ง่อต เมอะ, ไมจ เปอะ ง่อต ป อัฮ อาึ เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","พะจาว มัฮ โตว ปุย ป เกียฮ อัฮ ป โอ เนอึม. พะจาว มัฮ โตว ปุย ปลัฮเตะ ป เปียน ไป มา รพาวม แตะ. ดัฮ พะจาว อัฮ โอเอีฮ โฮ, โม่ ซ ยุฮ เนอึม อื ตัม ป อัฮ แตะ? โอเอีฮ รโฮงะ อื อาึง เงอ แจง ซ ยุฮ อื ตัม เซ, โม่ ซ ยุฮ อื? ");
INSERT INTO lcp_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","อาึ เอีจ ฮมอง ดวน พะจาว แตะ ปิฮ มุ่น ละ ปุย. พะจาว เอีจ ปิฮ เนอึม มุ่น. อาึ เกียฮ เปียน โตว ป เอีจ อัฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“พะจาว ยุ โตว กัน ตุกญัก โซะไซญ นึง เมือง ยาโคป. ชวน โตว เม่ะมั่ก ซักคระ นึง โม อิซราเอน เฟือฮ. เยโฮวา พะจาว ทื อื อาวต ดิ ลอป ไม่ อื. มัฮ พะจาว เซ ป มัฮ กซัต ยุฮ อื ป โฮลฮ อื ลื. ");
INSERT INTO lcp_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","อาวต มวย ไม่ ระ เรียง แตะ ตอก ออฮ, โม อิซราเอน อาวต ไม่ อัมนัต พะจาว ตอก เซ โรฮ. มัฮ พะจาว ป ตาว อื โอก ฮา เมือง อียิป เปอ. ");
INSERT INTO lcp_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","แจง โอ อื ไก ป ปุน ตู ปุน ลอง ปุย เมือง ยาโคป เปอ. ปัง โกว กทา กทอง ละ อื, ปุ โรฮ ซ ปุน ยุฮ ป โซะ ละ โม อิซราเอน. ปเลี่ย เฮี ปุย ซ อัฮ ไลลวง ยาโคป ไม่ อิซราเอน ตอก เฮี, ‘แลน เมิฮ, กัน ยุฮ พะจาว ระ เนอึม ไล,’ ซ อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ง่อต แลน, ปุย โม เฮี มัฮ ตอก อื รเวีย ซิงโต โกฮ ชุง ละ ซ โอก อื เรียง แตะ โฮ. ซ ไอจ โตว กา เฆียง โฮลฮ อื กุก โตะ ป ปุน แตะ. ซ อาวต โฆย โตว กา เฆียง โฮลฮ อื ญุ ฮนัม ป ยุม เบือ แตะ เซ,” อัฮ เซ บ่าลาอัม. ");
INSERT INTO lcp_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","เญือม เซ บ่าลัก อัฮ เฮี ละ บ่าลาอัม, “ดัฮ มัฮ ตอก เซ ปุ ซะ ซม่อต. ปุ โรฮ ปิฮ มุ่น ละ. โฆย ไม่ เตือง เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","บ่าลาอัม โลยฮ อื, “อาึ โม่ เอีจ อัฮ ละ เปอะ ไมจ แตะ อัฮ ตัม เกือฮ พะจาว แตะ อัฮ ฮา?” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","เญือม เซ บ่าลัก อัฮ เฮี, “เอีญ ไม่ อาึ อื, ซ ตาว แม ปะ โฮว ติ โดฮ. ดัฮ เอีจ ฮอยจ นา เซ, เมอ เตือง อื พะจาว ซ ญอม เกือฮ ปะ ซะ ซม่อต อื เน่อึม นา เซ ยุ่ง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ตาว เนอึม บ่าลาอัม ฮอยจ นึง ไกญ บลาวง เปโอ. โฮลฮ แก ลาึน เวือฮ เน่อึม นา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","บ่าลาอัม อัฮ เฮี, “เกือฮ ปุย ยุฮ คัน ซโมะ นา เฮี อาแลฮ. ซาวป โมวก โปก อาแลฮ ไม่ แกะ โปก อาแลฮ,” อัฮ เซ ละ บ่าลัก. ");
INSERT INTO lcp_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","บ่าลัก ยุฮ เนอึม อื ตอก เซ. มอก ตอง โมวก นึง อื ติ, แกะ นึง อื ติ โครยญ คัน อื. ");
INSERT INTO lcp_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","โฮน เฮี บ่าลาอัม ยุง อื ปุก อื รพาวม พะจาว ละ ซ ปิฮ แตะ มุ่น ละ โม อิซราเอน. เญือะ ซาวป โตว ซโปก ซักซี ตอก ไพรม แตะ. พัต ติ แตะ นา ลั่ก ลาึน เวือฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","เญือม แก อื โม อิซราเอน ชวน อาวต อื แปน เจอ แปน เจอ แตะ. ลปุ พะจาว โบว รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ซึป ลปุง พะจาว ฆาื อื ตอก เฮี. “บ่าลาอัม กวน เบ่โอ, มัฮ ปุย อัฮ โอเอีฮ ไม่ ที ไง่ รฮอง ฮยวก แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","มัฮ ปุย ฮมอง เซียง พะจาว. ปุน รโฮงะ ป ซ เกิต ลั่กกา ปุย เบือ อื. มัฮ โรฮ ป ยุ บลอง โอเอีฮ เบือ พะจาว ป ตึก นึง ระ อัมนัต แตะ. ปัง เอีจ ฆลาื โกะ, ไง่ อื เกียฮ ยุ ที ลั่ง โอเอีฮ. ");
INSERT INTO lcp_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","โอ เมือง ยาโคป, พากัง ยุฮ เปอะ ไมจ ลัมเลือ. โอ เมือง อิซราเอน, ก อาวต เปอะ ชอม เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","ตอก เอิน โคะ อินทะพะลัม ป ซมา ปุย แปน เดี่จ อื โฮ. ตอก รปึม ไมจ อาวต ฮอง โกลง. ตอก โคะ การะบุ่น ป ซมา พะจาว อาึง โฮ. ตอก โรฮ โคะ โซน ซีด่า ป อาวต โบ รอาวม โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ซ โฮลฮ รอาวม เฮละ ปอ ซัก แตะ. ซ ซมา โอเอีฮ นา ก ชุม เตะ โฮวน รอาวม.กซัต ยุฮ อื ซ ระ ฮา กซัต อากัก. ซ ตัตเตียง เมือง ปุย ก ซไง อื. ");
INSERT INTO lcp_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“พะจาว เอีจ นัม โม เฮี โอก ฮา เมือง อียิป. ซ ระ เรียง ตอก มวย ซครัก. ซ โฮลฮ เป เมือง ปุย รุป ไม่ แตะ. ซ โปวก ซอัง อื. ซ โปยญ อื นึง ตี ทนู โฮวน. ");
INSERT INTO lcp_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","เมือง เฮี มัฮ ตอก รเวีย ซิงโต ตึก นึง ระ เรียง แตะ. เญือม ปุน อื ไอจ เจอ มัฮ ปุย ป ซ โรวต ซอ เกือฮ โกฮ โฮ? ป ปิฮ มุ่น ละ อิซราเอน ซ โฮลฮ เนอึม มุ่น. ป ซะ ซม่อต อื ซ ลอก ป โอยจ นึง โซะ แตะ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","เญือม เซ บ่าลัก รอก พาวม. ซอป ลกุย แตะ ฆาื อื ละ บ่าลาอัม. อัฮ เฮี “อาึ เอีจ กอก ปะ ละ ซ เกือฮ เปอะ ฮอยจ ซะ ซม่อต ปุย โม เฮี. ปะ ปังเมอ ลเตือฮ แม เปอะ ปิฮ มุ่น ละ โม เซ โทน ลอวย โฮน เอิน. ");
INSERT INTO lcp_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","อาึ เอีจ ซันญา อาึง ซ เกือฮ แตะ ลังวัน ละ เปอะ. ปเลี่ย เฮี พะจาว ปังเมอ โอ เกือฮ ปะ โฮลฮ รัป ลังวัน แตะ เซ. เอีญ แปฮ ย่วง เปอะ เมิฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","บ่าลาอัม โลยฮ อื, “อาึ โม่ เอีจ อัฮ ละ โม ป ดวน เปอะ โฮว เคะ อาึ เซ ตอก เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ปัง เกือฮ เปอะ ไคร มาื เนิ ปอ นาวก อื ยุฮ เญือะ เปอะ, อาึ เกียฮ ยุฮ โตว โอเอีฮ โนก ฮา ป อัฮ พะจาว ละ แตะ,’ โม่ เอีจ อัฮ เซ ละ? ป ไมจ ญุ่ก, ป ฆอก ญุ่ก, อาึ เกียฮ ยุฮ โตว ไอฮ นึง โกะ แตะ ติ เจือ เนอึม. อาึ จัมเปน อัฮ ตัม ป ดวน พะจาว แตะ อัฮ โน่ง,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","บ่าลาอัม อัฮ แม อื ละ บ่าลัก ตอก เฮี, “ปเลี่ย เฮี อาึ ซ เอีญ ฮอยจ นึง ย่วง อาวต โกะ แตะ ไอฮ. กา ซ เอีญ เญอะ อาึ ฆวต ปัว อัฮ โอเอีฮ ป ซ ยุฮ โม อิซราเอน ละ โม จัตเจือ เปอะ เฆียง เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","ฟวยจ เซ บ่าลาอัม ลอต ซึป ลปุง อัฮ พะจาว ละ แตะ ตอก เฮี. “เฮี มัฮ ลปุง ซัมคัน ป อัฮ บ่าลาอัม กวน เบ่โอ, มัฮ ลปุง ซัมคัน ยุฮ ปุย ที ไง่ รฮอง ฮยวก. ");
INSERT INTO lcp_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","มัฮ ปุย ฮมอง เซียง พะจาว, ปุน รโฮงะ ป ซ เกิต ลั่กกา ปุย เบือ อื, ไม่ โฮลฮ อื พันญา ไมจ เน่อึม พะจาว ป ตึก นึง ฮลาวง แตะ. มัฮ โรฮ ป โฮลฮ ยุ บลอง โอเอีฮ เบือ พะจาว ป ตึก นึง ระ อัมนัต แตะ. ปัง เอีจ ฆลาื โกะ, ไง่ อื เกียฮ ยุ ที ลั่ง โอเอีฮ. ");
INSERT INTO lcp_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","อาึ โฮลฮ ยุ ปุย เซ, ปังเมอ โอ ดิ มัฮ ตอก เวลา ปเลี่ย เฮี. อาึ แก เยอะ ปุย เซ, ปังเมอ มัฮ ลั่ง แก เน่อึม ก ซไง อื. อาึ โฮลฮ ยุ กซัต ติ, โอก เน่อึม จัตเจือ ยาโคป. มัฮ โรฮ ตอก ซโมยญ ซัมคัน ป โอก เน่อึม นึง เมือง อิซราเอน เซ. ซ เฟียต ปุฮ โม ฮัวนา ยุฮ ปุย เมือง โมอัป, ซ ยุฮ ไลจ ไม่ โม จัตเจือ เชต. ");
INSERT INTO lcp_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ปุย เซ ซ เป โม เอโด่ม ป มัฮ ป เกละยุ แตะ เซ. ซ เกือฮ โรฮ เมือง อาวต อื แปน คอง แตะ. โม อิซราเอน ซ โฮลฮ ลอป เป ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ป โอก เน่อึม ยาโคป ติ ปุย เซ ซ โฮลฮ ตัตเตียง ปุย. ซ ยุฮ ไลจ ไม่ ปุย ป ไก ลั่ง นึง เมือง โม เซ เกือฮ โอยจ แกล เอิน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ฟวยจ เซ บ่าลาอัม โฮลฮ แม ยุ บลอง โม อามาเลก. อัฮ โอเอีฮ ป ซ เกิต ลั่กกา ปุย ฆาื อื ตอก เฮี. “โม อามาเลก มัฮ ป ระ อัมนัต ฮา ปุย เมือง ไฮญ, ลั่ก ก ลอยจ อื ปังเมอ ซ โฮลฮ โรฮ ปุย ยุฮ ไลจ ไม่ แกล เอิน,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","บ่าลาอัม โฮลฮ โรฮ ยุ บลอง โม เคไน. อัฮ โอเอีฮ ป ซ เกิต ลั่กกา ปุย ฆาื อื ตอก เฮี. “นา ก อาวต โม เปะ โม เคไน เซ ตอน ฮมัน เนอึม, ตอก ไซม ป ยุฮ รฮมาวม แตะ ราว ซโมะ รอัง โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ปัง มัฮ ตอก เซ โม เปะ ซ โฮลฮ ปุย ยุฮ ไลจ ไม่ เปอะ เญือม ซ โฮลฮ โม อัตซีเรีย โรวก เปอะ เกือฮ แปน ครา แตะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","บ่าลาอัม อัฮ แม โอเอีฮ ซ เกิต ลั่กกา ปุย ตอก เฮี. “เฮฮ เฮฮ, โซะ ไซญ เนอึม. เญือม ยุฮ พะจาว อื ตอก เซ เยอ มัฮ ปุย ป ซ เกียฮ ไอม ลั่ง เงอ? ");
INSERT INTO lcp_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ซ ไก โล่ง ป ฮอยจ เน่อึม นึง เมือง ไซปรัต, ซ ยุฮ ไลจ ไม่ เมือง อัตซีเรีย, ยุฮ โรฮ ไลจ ไม่ เมือง เอเบ่อ. ฟวยจ เซ โม กุม โล่ง เซ ซ ไลจ โลม โรฮ ตอก เซ โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ฟวยจ เซ บ่าลาอัม โกฮ เอีญ ฮอยจ นึง ย่วง แตะ. กซัต บ่าลัก โกฮ โฮว โรฮ คระ โฮว โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","เญือม ยุฮ โม อิซราเอน ไคะ ยุฮ แตะ นึง นาตี ชิตทิม, เญือม เซ โม ปรเมะ อิซราเอน เลน จุ ไม่ โม ปรโปวน โมอัป. ");
INSERT INTO lcp_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ปรโปวน โมอัป เซ บะ โม ปรเมะ อิซราเอน โฮว ลวม นึง กัน เลียง กัน ปอย พะ ยุฮ แตะ. โม อิซราเอน ไว เนอึม อื ไม่ โซม อื โอเอีฮ ตัน ปุย ละ ฮุป ยุฮ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","โม อิซราเอน แปน เนอึม นัปทื พะ ยุฮ ปุย โมอัป ป มัฮ พะบ่าอัน นึง ย่วง เปโอ เซ. พะจาว ฮาวก รพาวม ละ โม อิซราเอน เซ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ เกือฮ ปุย ยุฮ ยุม ไม่ โม ฮัวนา ยุฮ โม อิซราเอน เซ. ฟวยจ เซ เกือฮ เคิง อื นา ก เปง อื ซองนา อาึ, เดอึม อาึ โอ ซ โฮลฮ ฮาวก รพาวม ละ โม อิซราเอน เตือง โอยจ อื เซ ฆาื อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ไอ โมเซ อัฮ อื ละ โม ป รเตีฮ รตุม ยุฮ โม อิซราเอน เซ ตอก เฮี, “ไมจ เปอะ ยุฮ ยุม ไม่ โม ป ไว พะบ่าอัน นึง ย่วง เปโอ เซ ป มัฮ ปุย ไน เจอ ยุฮ เปอะ เตือง ไพ เตือง มัน โครยญ โฆะ อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","เญือม เซ ไก ปรเมะ อิซราเอน ติ ปุย, โฆง โรวก ปรโปวน มีเดี่ยน ติ ปุย, โรวก อื ฮอยจ นึง พากัง อาวต แตะ ซองนา ไอ โมเซ ไม่ ซองนา ปุย เตือง โอยจ อื. ปุก ลไล เยือม ปุย นึง โบ โตะ รเวือะ พากัง ก ฮอยจ ปุย เคะ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ฟีเนฮัต กวน เอเลอาซา, ป มัฮ กวนโซะ อาโรน ป มัฮ ซตุ เซ, เญือม ยุ อื โอเอีฮ ตอก เซ, โอก เอิน ฮา ปุย โฮวน เซ ฆาื อื, ตุย โรวก เพลียฮ ไม่ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","โฮว อาื ปุย ลอา เซ ฮอยจ นึง โตะ กไน พากัง อาวต อื เซ, บวก อื นึง เพลียฮ ลล่อน เอิน เตือง ลอา อื เซ. เคียง เซ ป มัฮ พาญัต ฆอก ลอน ป ฮอยจ ละ โม อิซราเอน เซ ไฆร เอิน. ");
INSERT INTO lcp_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ปัง มัฮ ตอก เซ โม ป เอีจ ยุม ฆาื พาญัต ฆอก ลอน เญือม เซ ไก เอิน 24,000 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ฟีเนฮัต เอีจ เกือฮ กัน รอก พาวม อาึ นึง โม อิซราเอน เซ ไฆร, นึง มัฮ อื ปุย เรียง รพาวม นึง โอ แตะ ฆวต เกือฮ ปุย ยุฮ ป พิต ตอก เรียง รพาวม อาึ โฮ. มัฮ เซ ป โอ อาึ ยุฮ ไลจ ไม่ ปุย เตือง โอยจ อื นึง รพาวม ฮาวก แตะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ไมจ เปอะ รโฮงะ ละ อื ตอก เฮี, อาึ ซ เกือฮ ลปุง ซันญา แตะ ละ. ลปุง ซันญา อาึ ละ อื เซ มัฮ ป ตอน ป ฮมัน. ");
INSERT INTO lcp_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","กัน แปน อื ซตุ เซ มัฮ ป ซ ไก ลอป ฮอยจ ละ โม จัตเจือ อื เฆียง เฮี, มัฮ เบือ โอ อื ปุน ยุ ปุน ฮมอง โม ป พลิฮ บึน มอยฮ อาึ. เอีจ มัฮ โรฮ เกือฮ อื อาึ โฮลฮ รไซจ พิต โฌวะ ยุฮ ปุย ไน อิซราเอน เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","ปรเมะ ยุฮ ปุย ยุม ไม่ บรุก ไม่ ปรโปวน มีเดี่ยน เซ, มอยฮ อื มัฮ ซิมรี กวน ซาลู. ซาลู เซ มัฮ ฮัวนา ปุย ติ มู ไน เจอ ซิเมโอน. ");
INSERT INTO lcp_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","ปรโปวน ยุฮ ปุย ยุม ไม่ เซ มอยฮ อื มัฮ โคตบี่ กวน ซู. ซู เซ มัฮ ฮัวนา ปุย ติ มู ไน โม มีเดี่ยน. ");
INSERT INTO lcp_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ไมจ เปอะ รุป ปุ แตะ ไม่ โม มีเดี่ยน เซ, ฮอยจ ละ ยุม โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","มัฮ ฆาื เอีจ ยุฮ อื ป ฆอก ป เบร ละ เปอะ, เญือม รชุยจ อื โม เปะ ไลจ นึง เกือฮ อื โม เปะ ไว ฮุป นึง ย่วง เปโอ, ไม่ ไลลวง ปรโปวน ป มัฮ โคตบี่ เซ ป โฮลฮ ปุย ยุฮ ยุม ไม่ เญือม เกิต พาญัต ฆอก ลอน ละ ปุย ฆาื กัน พิต ยุฮ อื เซ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","เญือม เอีจ ฟวยจ เกิต พาญัต ฆอก เซ, พะจาว อัฮ อื ละ ไอ โมเซ ไม่ เอเลอาซา กวน อาโรน ป มัฮ ซตุ เซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ไมจ เปอะ โจต เมาะ ไก เซน โม อิซราเอน เตือง โอยจ อื, ตัม เจอ ตัม ซฆลาวม อื, เมาะ ป เอีจ เกียฮ โฮว รุป เซิก นึง อื. มัฮ โม ปรเมะ ป เอีจ ไก อาญุ อื เคียง ง่า เนอึม ฮาวก ก ล่าวง,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","ไอ โมเซ ไม่ เอเลอาซา ป มัฮ ซตุ เซ ยุฮ เนอึม อื ตัม ป อัฮ พะจาว ละ ไอ โมเซ. กอก โม ปรเมะ ป ไก อาญุ เคียง ง่า เนอึม เซ ฮอยจ โพรม ไม่ แตะ นึง ลโลวง โมอัป โบ โกลง จอแด่น รเตือป เมือง เยรีโค. โม อิซราเอน ป โอก ฮา เมือง อียิป เซ มัฮ ตอก เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","ปุย เจอ รูเบ่น มัฮ ตอก เฮี. (รูเบ่น เซ มัฮ กวน โรง ยาโคป) จัตเจือ รูเบ่น เซ มัฮ โม ฮะโนก, ไม่ โม ปันลู, ");
INSERT INTO lcp_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","โม เฮตโรน, ไม่ โม คาระมี. ");
INSERT INTO lcp_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","โม เซ มัฮ ปรเมะ ไน เจอ รูเบ่น. เซน ปุย นึง อื ไก 43,730 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","จัตเจือ ปันลู เซ มัฮ เอลีอัป. ");
INSERT INTO lcp_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","กวน เอลีอัป เซ มัฮ เนมูเอน ไม่ ด่าทัน ไม่ อาบี่รัม. ด่าทัน ไม่ อาบี่รัม เซ มัฮ โม พูนัม ป โอ ญอม อาวต ฆรึม ตัตเตียง ไอ โมเซ ไม่ อาโรน, ไม่ พาวม ดิ อื ไม่ โม โครา นึง เลฮ อื เตียง ป อัฮ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","เญือม เซ ปลัฮเตะ นา ก อาวต อื เซ ม่ะ เอิน ปอ บลวน แตะ โม เซ ไม่ โครา. ยุม โอยจ เอิน. โนก ฮา เซ ยุม แม นึง ฮะ งอ แตะ ลอา รอย ไม่ รฮอน ปุย. โอเอีฮ ตอก เซ มัฮ โรฮ ป เกิต ละ ซ แปน อื ป เพอึก ปุย เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","ป มัฮ จัตเจือ โครา เซ ปังเมอ โอ โรฮ ยุม เตือง โอยจ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","ปุย เจอ ซิเมโอน มัฮ โม เนมูเอน, โม ยามิน, โม ยาคิม, ");
INSERT INTO lcp_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","โม เซรา, ไม่ โม ชาอุน. ");
INSERT INTO lcp_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ปุย โม เซ มัฮ ตื ปุย ไน เจอ ซิเมโอน เซ. เซน ปุย นึง อื ไก 22,200 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","18","ปุย เจอ กาต มัฮ โม เซโฟน, โม ฮักกี, โม ชูนี, โม โอซนี, โม เอรี, โม เอโรต, ไม่ โม อาเรลี. เซน ปุย ไน เจอ กาต เซ ไก 40,500 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","22","ปุย เจอ ยูด่า มัฮ โม เชลา, โม เพเรต, ไม่ โม เซรา. ป มัฮ จัตเจือ เพเรต มัฮ โม เฮตโรน, ไม่ โม ฮามุน. กวน ยูด่า ป ยุม นึง เมือง คะนาอัน เตือง โอ อื ไก กวน เนอ, มอยฮ อื มัฮ เอ ไม่ โอนัน. เซน ปุย ไน เจอ ยูด่า เซ ไก 76,500 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","25","ปุย ไน เจอ อิตซาคา มัฮ โม โทลา, โม ปูวา, โม ยาชุป, ไม่ โม ซิมโรน. เซน ปุย ไน เจอ อิตซาคา เซ ไก 64,300 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","27","ปุย เจอ เซบู่ลุน มัฮ โม เซเรต, โม เอโลน, ไม่ โม ยาเลเอน. เซน ปุย ไน เจอ เซบู่ลุน เซ ไก 60,500 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","ปุย ไน จัตเจือ โยเซป มัฮ เจอ มะนาเซ ไม่ เจอ เอฟราอิม. ");
INSERT INTO lcp_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","ปุย เจอ มะนาเซ มัฮ มาคี ติ. มาคี เซ ไก โรฮ กวน, มัฮ กิเลอัต. โม กิเลอัต เตอ ซึป เจือ แตะ เน่อึม นึง กิเลอัต เซ. ");
INSERT INTO lcp_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","32","จัตเจือ กิเลอัต เซ มัฮ โม เยเซอ, โม เฮเลก, โม อัตรีเอน, โม เชเคม, โม เชมิด่า, ไม่ โม เฮเฟอ. ");
INSERT INTO lcp_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ป มัฮ เซโลเฟฮัต กวน เฮเฟอ เซ ไก โตว กวน รเมะ. ไก กวน รโปวน โน่ง. มัฮ มาลา, โนอา, โฮก-ลา, มินคา, ไม่ ทีระซา. ");
INSERT INTO lcp_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","เซน ปุย เจอ มะนาเซ เซ ไก 52,700 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ปุย เจอ เอฟราอิม, จัตเจือ อื มัฮ โม ชูเทลา, โม เบ่เคอ, ไม่ โม ทาฮัน. ");
INSERT INTO lcp_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","โม เอรัน มัฮ ป ซึป จัตเจือ แตะ เน่อึม ชูเทลา. ");
INSERT INTO lcp_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","เซน ปุย ไน เจอ เอฟราอิม เซ ไก 32,500 ปุย. ปุย โม เซ มัฮ จัตเจือ โยเซป นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","40","ปุย เจอ เบ่นยามิน, จัตเจือ อื มัฮ โม เบ่ลา, โม อัตซเบ่น, โม อาฮิรัม, โม เชฟูฟัม, ไม่ โม ฮุฟัม. โม อาต ไม่ โม นาอามัน มัฮ ป ซึป จัตเจือ แตะ เน่อึม นึง เบ่ลา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ปุย ไน เจอ เบ่นยามิน เซ ไก 45,600 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","43","ปุย เจอ ด่าน, จัตเจือ อื มัฮ โม ชูฮัม. เซน ปุย ไน เจอ ด่าน เซ ไก 64,400 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ปุย เจอ อาเชอ มัฮ โม อิมนา, โม อิชวี, ไม่ โม เบ่ริยา. ");
INSERT INTO lcp_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","โม เฮเบ่อ ไม่ โม มันคีเอน มัฮ ป ซึป จัตเจือ แตะ เน่อึม เบ่ริยา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","กวน รโปวน อาเชอ เซ มัฮ เซรา. ");
INSERT INTO lcp_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ปุย ไน เจอ อาเชอ เซ ไก 53,400 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","ปุย ไน เจอ นัปทาลี มัฮ โม ยาเซเอน, โม กูนี, ");
INSERT INTO lcp_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","โม เยเซอ, ไม่ โม ชินเลม. ");
INSERT INTO lcp_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","เซน ปุย ไน เจอ นัปทาลี เซ ไก 45,400 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","เซน โม ปรเมะ โม อิซราเอน เตือง โอยจ อื ไก 601,730 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ไมจ เปอะ รฆุ ปลัฮเตะ ละ โม อิซราเอน เซ ตัม เมาะ ไก เซน ปุย ไน เจอ ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","ป มัฮ เจอ ป โฮวน เซน ปุย นึง อื เกือฮ ละ อื เวือฮ ตัม เซ. ดัฮ มัฮ เจอ รมัฮ เซน ปุย นึง อื โฮ, เกือฮ โรฮ ละ อื ซไกป ตัม เซ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","กัน รฆุ เปอะ ปลัฮเตะ เซ, ปังเมอ ไมจ เปอะ เกือฮ ปุย โจก เบ่อ นึง อื, ตัม มอยฮ เจอ อาวต แตะ ไอฮ เตือง ไพ เตือง มัน. ");
INSERT INTO lcp_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","กัน เกือฮ เปอะ ปุย โจก เบ่อ เซ, ไมจ เปอะ เกือฮ โจก อื ตัม ระ ตัม แตวะ เจอ ยุฮ อื เซ โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","เจอ เลวี ไก ไม่ ปุ แตะ ลอวย ซฆลาวม. มัฮ ซฆลาวม เกอโชน, โคฮัต, ไม่ เมรารี. ");
INSERT INTO lcp_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ไน ซฆลาวม ลอวย เซ ไก โม ลิปนี นึง ไม่ โม เฮปโรน, โม มาลี, โม มูชี, ไม่ โม โครา. โคฮัต มัฮ จัตเจือ อัมรัม. ");
INSERT INTO lcp_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","ปรโปวน เญือะ อัมรัม เซ มัฮ โยเคเบ่ต, มัฮ จัตเจือ เลวี ป เกิต นึง เมือง อียิป โฮ. อัมรัม ไม่ โยเคเบ่ต เซ ไก กวน รเมะ ลอา ปุย, มัฮ อาโรน ไม่ ไอ โมเซ. ไก กวน รโปวน ติ ปุย, มัฮ มิเรียม ป มัฮ ออระ ไอ โมเซ ไม่ อาโรน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","อาโรน เซ ไก โรฮ กวน รเมะ ปาวน, มัฮ นาดั่ป ไม่ อาบี่ฮู ไม่ เอเลอาซา ไม่ อิทามา. ");
INSERT INTO lcp_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ป มัฮ นาดั่ป ไม่ อาบี่ฮู เซ ปังเมอ ยุม ฆาื โกว แตะ งอ โอ ปุย ลัง โกว เญือม ตอง อื ทไว โอเอีฮ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","เซน โม เลวี เซ เตือง โอยจ อื ไก 23,000 ปุย. มัฮ โม ปรเมะ ป ไก อาญุ อื เคียง ติ เคิ ฮาวก ก ล่าวง. โม เลวี เซ เมีญ รโจะ โตว อื ไม่ โม อิซราเอน ไฮญ, นึง โอ อื ไก รโตง นึง ปลัฮเตะ รฆุ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","ไอ โมเซ ไม่ เอเลอาซา ป มัฮ ซตุ มัฮ ป โจต เซน ปุย โม เซ เญือม เมีญ อื เมาะ ไก เซน โม อิซราเอน, นึง ลโลวง โมอัป โบ โกลง จอแด่น รเตือป เมือง เยรีโค. ");
INSERT INTO lcp_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","เมาะ ป โจต ไอ โมเซ ไม่ อาโรน อาึง เซน อื นึง ลาึน ซีไน โฮ, ไก โตว ติ ปุย เนอึม ป ไอม ลั่ง อื. ");
INSERT INTO lcp_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","พะจาว เอีจ อัฮ อาึง อื ตอก เฮี, “ปุย โม เซ ซ ยุม โอยจ นึง ลาึน เวือฮ,” อัฮ เซ. เอีจ เกิต เนอึม ตอก อัฮ พะจาว อื เซ. มัฮ คาเลป กวน เยฟูเน ไม่ โยชูวา กวน นูน โน่ง ป ไอม ลั่ง เงอ. ");
INSERT INTO lcp_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","กวน รโปวน เซโลเฟฮัต เซ มัฮ มาลา, โนอา, โฮก-ลา, มินคา, ไม่ ทีระซา. (เซโลเฟฮัต เซ มัฮ กวน รเมะ เฮเฟอ, เฮเฟอ เซ มัฮ กวน กิเลอัต. กิเลอัต เซ มัฮ กวน มาคี, มาคี เซ มัฮ กวน มะนาเซ. มะนาเซ เซ มัฮ กวน โยเซป.) ");
INSERT INTO lcp_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","ปรโปวน พอน ปุย เซ ฮอยจ ชุง ลั่กกา ไอ โมเซ, ไม่ ลั่กกา เอเลอาซา ป มัฮ ซตุ เซ, ไม่ ลั่กกา โม ฮัวนา ไม่ ลั่กกา ปุย เตือง โอยจ อื, นึง โบ โตะ รเวือะ พากัง ระ ก ฮอยจ ปุย เคะ พะจาว. อัฮ เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“เปือะ ก เญะ เอีจ ยุม นึง ลาึน เวือฮ เซ, เตือง โอ แตะ ไก กวน รเมะ ติ ปุย เนอึม. มัฮ โตว เลียก ดิ อื ไม่ โม โครา ป เลฮ เตียง พะจาว เซ, มัฮ ยุม อื ฆาื พิต มั่ป ยุฮ โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","เคียง มัฮ อื ตอก เซ อัม ปุก ละ เกือฮ เปอะ มอยฮ เปือะ เกอะ ไฆร ฮา จัตเจือ อื ฆาื โอ อื ไก กวน รเมะ เซ? ปัว เปอะ เกือฮ เอะ โฮลฮ รัป ป มัฮ เตะ ลัง โฮลฮ อื เซ, ตอก โฮลฮ โม เอียกปุ คระ เฌือต เปือะ เกอะ เซ รัป โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ไอ โมเซ รโฮงะ ไลลวง เซ ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","พะจาว อัฮ อื ละ ไอ โมเซ ตอก เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ป อัฮ กวน รโปวน เซโลเฟฮัต เซ มัฮ เนอึม ป ปุก. ไมจ เปอะ เกือฮ โฮลฮ รัป รโตง แตะ ตอก รัป โม เอียกปุ คระ เฌือต เปือะ อื เซ โรฮ. คาวคอง เปือะ อื เซ เมาะ ไก อื มัฮ โรฮ ป ลัง ละ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","ไมจ เปอะ รโฮงะ ละ โม อิซราเอน เตือง โอยจ อื, ดัฮ ไก ป ยุม เตือง โอ แตะ ไก กวน รเมะ เอ, คาวคอง อื เมาะ ไก อื มัฮ ป ลัง ละ กวน รโปวน อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ดัฮ ปุย เซ โอ โรฮ ไก กวน รโปวน โฮ, คาวคอง อื เซ มัฮ ป ลัง ละ ปุ เลีฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ดัฮ มัฮ ปุย โอ ไก ปุ เลีฮ โฮ, คาวคอง อื เซ มัฮ ป ลัง ละ เอียกปุ เปือะ อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ดัฮ มัฮ ปุย โอ ไก เอียกปุ เปือะ โฮ, มัฮ ป ลัง ละ เอียกปุ ซวุง ป ซดิ ไม่ อื ฮา ปุย ไฮญ. ไมจ ปุย เซ กุม เตะ ยุฮ อื เซ. ไมจ เปอะ เกือฮ โม อิซราเอน ยุฮ ตอก เซ เกือฮ แปน โกตไม ยุฮ อื, ตัม ป ซตอก อาึ ป มัฮ พะจาว ละ เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ ฮาวก ฮอยจ นึง ไกญ บลาวง อาบ่าริม เซ, ละ ซ แก เปอะ แลน ปลัฮเตะ เกือฮ อาึ ละ โม อิซราเอน เซ. ");
INSERT INTO lcp_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","เญือม เอีจ โฮลฮ เปอะ ยุ ตอก เซ, ปะ ซ ลอยจ จีวิต เปอะ นึง ปลัฮเตะ เฮี. อาึ ซ รโจะ โรฮ ปะ ไม่ โม จัตเจือ ไพรม เปอะ ตอก อาโรน ป มัฮ เอียกระ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","มัฮ ฆาื โอ เปะ ลอา เนอึง ป อัฮ อาึ นึง ลาึน ซิน เซ เญือม เติ ปุย โฮวน เซ อาึ นึง เมริบ่า โฮ. เปะ ลอา ญอม เปอะ โตว เกือฮ อาึ โฮลฮ โญตซัก แตะ.” (เมริบ่า เซ มัฮ ก ไก รอาวม ปลาึฮ นึง, ปุก แควน คาเด่ต ป มัฮ นึง ลาึน ซิน เซ.) ");
INSERT INTO lcp_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ไอ โมเซ ปัว อื นึง พะจาว ตอก เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“โอ พะจาว, ป มัฮ กุม จีวิต ปุย โครยญ โฆะ ปุย, ปัว ปะ ดุฮ ปรเมะ ติ ปุย ละ ซ เกือฮ แปน ป นัม โม ปุย โฮวน เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ละ ซ แปน อื ป โฮว รกา เอีญ รเคะ ละ ปุย, เดอึม ปุย ไน เปอะ โอ ซ แปน ตอก แกะ โอ ไก ป เลียง โฮ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","พะจาว อัฮ เฮี ละ ไอ โมเซ, “ไมจ เปอะ กอก โยชูวา กวน นูน เซ เอีญ เคะ แตะ. ปุย เซ มัฮ ป อาวต ลปุ พะจาว กไน อื. ไมจ เปอะ ย่อง เตะ แตะ ราว ไกญ อื. ");
INSERT INTO lcp_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","ไมจ เปอะ เกือฮ ชุง ลั่กกา เอเลอาซา ป มัฮ ซตุ เซ, ไม่ ลั่กกา ปุย เตือง โอยจ อื. เญือม เซ ไมจ เปอะ รโฮงะ ละ ปุย มัฮ อื ดุฮ เปอะ เกือฮ แปน ป ยุฮ กัน ฆรอ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","อัมนัต เกือฮ อาึ ละ เปอะ เซ ไมจ โรฮ เปอะ มอป ละ อื ง่อน, เดอึม โม อิซราเอน เตือง โอยจ อื ซ ง่อต ป อัฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ไมจ อื ฮอยจ เคะ เอเลอาซา ป มัฮ ซตุ เซ, เกือฮ เอเลอาซา เซ ไฮมญ โอเอีฮ ละ อื. เกือฮ โกว อูริม ไม่ ทูมิม ละ ซ เกือฮ อื ติ แตะ ยุง ป ปุก รพาวม อาึ. ปุย เตือง โอยจ อื ซ โฮว ซ เอีญ ตัม ป อัฮ เอเลอาซา ป มัฮ ซตุ เซ, เตือง โยชูวา ไม่ ปุย ไน โม อิซราเอน เตือง โอยจ อื,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ไอ โมเซ ยุฮ เนอึม อื ตัม ป ซตอก พะจาว ละ แตะ, เกือฮ โยชูวา เซ ชุง ลั่กกา เอเลอาซา ป มัฮ ซตุ เซ, ไม่ ลั่กกา ปุย เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","เญือม เซ ย่อง เตะ แตะ ราว โยชูวา เซ. ฟวยจ เซ รโฮงะ อื ละ ปุย ไลลวง เอีจ ดุฮ แตะ เกือฮ แปน ป ยุฮ กัน ฆรอ แตะ เซ, ตัม ป เอีจ อัฮ พะจาว อาึง ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ไมจ เปอะ ซตอก ละ โม อิซราเอน ตอก เฮี, ‘โอเอีฮ ป ลัง ตอง เปอะ ทไว ละ อาึ ละ ซ แปน อื ป ซออย ฮงาื ป ปุก รพาวม เมอะ, ไมจ เปอะ ทไว ลอป ตัม เวลา กัมโนต อื.’ ");
INSERT INTO lcp_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","ไมจ โรฮ เปอะ อัฮ ละ อื ตอก เฮี, ‘โอเอีฮ โม เฮี มัฮ ป ลัง ตอง เปอะ ทไว โครยญ ซเง่ะ. มัฮ แกะ โปก ลอา ตัว ป ไก อาญุ อื ติ เนอึม ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ไมจ เปอะ ทไว เมือ กซะ อื ติ ตัว, เมือ กปู อื ติ ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","เญือม ทไว เปอะ กวน แกะ เซ ไมจ โรฮ เปอะ ทไว ไม่ ญอต แปง ลอา ลิต ซเบื่อก ไม่ ลออยฮ กาวก ตึก นึง ไมจ แตะ ติ ลิต.’ ");
INSERT INTO lcp_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","เซ มัฮ ป ไมจ ปุย ตอง ทไว ลอป ละ พะจาว โครยญ ซเง่ะ ละ ซ เกือฮ อื แปน ป ซออย ฮงาื ละ อื, ป ปุก รพาวม อื. เอีจ มัฮ ตอก ป ดวน อาึ เปอะ ยุฮ เน่อึม เญือม อาวต เปอะ นึง บลาวง ซีไน โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","เญือม ทไว เปอะ กวน แกะ นึง คัน เซ โครยญ โฮน เนอ, ไมจ โรฮ เปอะ โทก รอาวม อะงุน นึง เมาะ ติ ลิต โครยญ ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","เมือ กปู อื, เกือฮ ตอง ทไว แกะ ตัว ลอา นึง อื เซ ไม่ ญอต แปง ไม่ รอาวม อะงุน, ตอก ป ทไว เปอะ เมือ กซะ อื เซ โรฮ, ละ ซ เกือฮ แปน ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก รพาวม อื.” ");
INSERT INTO lcp_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ไน ซเงะ ลโล่ะ เซ ไมจ เปอะ ทไว กวน แกะ โปก ลอา ตัว ป ไก อาญุ อื ติ เนอึม ป โอ อื ไก ตอก โละพริ, ไม่ ญอต แปง ปาวน ลิต ซเบื่อก ไม่ ลออยฮ กาวก ละ แปน อื เฮงาะ รโกะ ทไว เปอะ, ไม่ รอาวม อะงุน. ");
INSERT INTO lcp_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","โอเอีฮ โม เซ มัฮ ป ไมจ เปอะ ตอง ทไว โครยญ ซเงะ ลโล่ะ, มัฮ โนก ฮา โอเอีฮ ป ตอง ลอป เปอะ ทไว โครยญ ซเง่ะ, ไม่ รอาวม อะงุน ทไว เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ไมจ เปอะ ตอง ทไว โอเอีฮ ละ พะจาว โครยญ ฮาวก เคิ ติ ซาวม. ป ไมจ เปอะ ทไว เซ มัฮ โมวก โปก นุม ลั่ง ลอา ตัว ไม่ แกะ โปก ระ ติ ตัว, ไม่ กวน แกะ โปก อาญุ ติ เนอึม อาแลฮ ตัว. โอเอีฮ โม เซ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ นึง. ");
INSERT INTO lcp_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","เฮงาะ รโกะ ทไว เปอะ เซ ไมจ เปอะ ทไว ไม่ ซัตซิง ตอก เฮี. โมวก ติ ตัว เซ ตอง ทไว ไม่ ญอต แปง แลฮ ลิต ซเบื่อก ไม่ ลออยฮ. แกะ โปก ระ ติ ตัว เซ ทไว ไม่ ญอต แปง ปาวน ลิต ซเบื่อก โรฮ ไม่ ลออยฮ. ");
INSERT INTO lcp_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ป มัฮ กวน แกะ ติ ติ ตัว ทไว ไม่ ญอต แปง ลอา ลิต, ซเบื่อก โรฮ ไม่ ลออยฮ โครยญ ตัว อื, ละ ซ แปน ป โซม ป ปอน ทไว เปอะ ละ พะจาว, แปน ป ซออย ฮงาื ละ พะจาว ป ปุก รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ป มัฮ โมวก ทไว เปอะ ติ ตัว เซ, ไมจ เปอะ ทไว ไม่ รอาวม อะงุน ลอา ลิต, แกะ โปก ระ ติ ตัว ไม่ รอาวม อะงุน ติ ลิต ไม่ บลัฮ, กวน แกะ ติ ตัว ไม่ รอาวม อะงุน ติ ลิต. โอเอีฮ โม เซ มัฮ ป ไมจ เปอะ ทไว โครยญ ฮาวก เคิ ติ ซาวม. ");
INSERT INTO lcp_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","โนก ฮา ป ตอง เปอะ ทไว โครยญ ฮาวก เคิ เซ, ไม่ รอาวม อะงุน ทไว เปอะ เซ, ไมจ โรฮ เปอะ ทไว ปิ โปก ติ ตัว, ละ ซ แปน ควน โตฮ เปอะ ติ แตะ ฮา มั่ป ยุฮ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ซเงะ ชลอง ปุย กัน เลียง ฌาว ละ ซ นัปทื แตะ พะจาว เซ, ปุก ฮาวก เคิ ติ กาว โรฮ ปาวน ซาวม. ");
INSERT INTO lcp_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","เญือม ฮาวก เคิ ติ เซ กาว โรฮ พอน ซาวม เมอ, มัฮ ซเงะ เมือ โรง นึง กัน เลียง ฌาว เซ, ไมจ เปอะ โซม คโนมปัง โอ ไก เจือ อาแลฮ ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ไน ซเงะ เมือ โรง นึง กัน เลียง ฌาว เซ, ไมจ เปอะ โพรม ดิ ละ ซ นัปทื เปอะ พะจาว. ไน ซเงะ เซ ไมจ โตว ปุย ยุฮ กัน เญี่ยะ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ไมจ เปอะ ทไว ป โซม ป ปอน ละ พะจาว. ป ไมจ เปอะ ตอง ทไว นึง อื เซ มัฮ โมวก โปก นุม ลอา ตัว, แกะ โปก ระ ติ ตัว, ไม่ กวน แกะ โปก อาญุ ติ เนอึม อาแลฮ ตัว. โอเอีฮ โม เซ โครยญ เจือ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","เญือม เซ ไมจ เปอะ ทไว เฮงาะ รโกะ ป มัฮ ญอต แปง ซเบื่อก ไม่ ลออยฮ กาวก ตอก เฮี, โมวก ติ ตัว ไม่ แปง แลฮ ลิต, แกะ โปก ระ ติ ตัว ไม่ แปง ปาวน ลิต, ");
INSERT INTO lcp_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","กวน แกะ ติ ตัว ไม่ แปง ลอา ลิต โครยญ ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","เกือฮ โรฮ ทไว ปิ โปก ติ ตัว แปน ควน โตฮ เปอะ ติ แตะ ฮา มั่ป ละ ซ รไซจ อื พิต โฌวะ ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ไมจ เปอะ ทไว โอเอีฮ โม เซ, โนก ฮา ป ตอง เปอะ ทไว โครยญ ซเง่ะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ไน อาแลฮ ซเงะ เซ ไมจ เปอะ ทไว ป โซม ป ปอน ตอก เซ โครยญ ซเง่ะ. โอเอีฮ โม เซ มัฮ ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก รพาวม อื. ไมจ เปอะ ทไว โอเอีฮ เซ, โนก ฮา ป ทไว ปะจัม เปอะ โครยญ ซเง่ะ เซ, ไม่ รอาวม อะงุน ทไว เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ซเงะ อาแลฮ นึง อื เซ, ไมจ เปอะ ฮอยจ โพรม ดิ ไม่ ปุ แตะ ละ ซ นัปทื เปอะ พะจาว. ไน ซเงะ เซ ไมจ โตว ปุย ยุฮ กัน เญี่ยะ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ไน ซเงะ เมือ โรง นึง กัน ทไว ปุย เปลิ โรง โอเอีฮ ยุฮ แตะ, เญือม ทไว เปอะ เฮงาะ โคระ ยุฮ แตะ ละ พะจาว, ไมจ เปอะ รโจะ โพรม ดิ ไม่ ปุ แตะ, ละ ซ นัปทื เปอะ พะจาว. ไน ซเงะ เซ ปุ ยุฮ กัน ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ไมจ เปอะ ตอง ทไว โอเอีฮ ละ พะจาว ละ ซ เกือฮ เปอะ แปน ซออย ฮงาื ละ อื, ไม่ ป ปุก รพาวม อื. ป ไมจ เปอะ ทไว เซ มัฮ โมวก โปก นุม ลอา ตัว, แกะ โปก ระ ติ ตัว, กวน แกะ โปก อาญุ ติ เนอึม อาแลฮ ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ไมจ เปอะ ทไว เฮงาะ รโกะ ละ พะจาว ป มัฮ ญอต แปง ซเบื่อก ไม่ ลออยฮ. โมวก ติ ตัว ทไว ไม่ แปง แลฮ ลิต, แกะ โปก ระ ติ ตัว ทไว โรฮ ไม่ แปง ปาวน ลิต, ");
INSERT INTO lcp_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","กวน แกะ ติ ตัว ไม่ แปง ลอา ลิต โครยญ ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","เกือฮ ทไว ปิ โปก ติ ตัว ละ ซ แปน อื ควน รไซจ พิต โฌวะ ยุฮ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ป ทไว เปอะ นึง กัน ชลอง เซ ไมจ อื ไก ตื ไม่ รอาวม อะงุน โรฮ. โอเอีฮ เซ มัฮ โรฮ โนก ฮา ป กอ ตอง เปอะ ทไว ไม่ เฮงาะ รโกะ ทไว เปอะ โครยญ ซเง่ะ. ซัตซิง โม เซ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ เญี่ยะ เนอึม.” ");
INSERT INTO lcp_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","เญือม ฮาวก เคิ อาแลฮ เซ ติ ซาวม, โม เปะ ไมจ เปอะ โพรม ดิ ไม่ ปุ แตะ ละ ซ นัปทื เปอะ พะจาว. ปุ ยุฮ กัน ติ เจือ เนอึม. ซเงะ เซ มัฮ ซเงะ ปาึง เปอะ โตวต. ");
INSERT INTO lcp_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ไมจ เปอะ ตอง ทไว โอเอีฮ ละ พะจาว ละ ซ แปน ป ซออย ฮงาื ละ อื ไม่ ป ปุก เนอึม รพาวม อื. ป ไมจ เปอะ ทไว เซ มัฮ โมวก โปก นุม ติ ตัว, แกะ โปก ระ ติ ตัว, ไม่ กวน แกะ โปก อาญุ ติ เนอึม อาแลฮ ตัว. โอเอีฮ โม เซ ไมจ โตว อื ไก ตอก โละพริ เญี่ยะ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ซัตซิง โม เซ ไมจ เปอะ ทไว ไม่ ญอต แปง ซเบื่อก ไม่ ลออยฮ. โมวก เซ ทไว ไม่ ญอต แปง แลฮ ลิต. แกะ โปก ระ เซ ทไว ไม่ อื ปาวน ลิต. ");
INSERT INTO lcp_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","กวน แกะ อาแลฮ ตัว เซ ทไว ไม่ แปง ติ ตัว ลอา ลิต โครยญ ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","ไมจ โรฮ เปอะ ทไว ไม่ ปิ โปก ติ ตัว แปน ควน โตฮ ปุย ติ แตะ ฮา มั่ป ละ ซ รไซจ อื พิต โฌวะ ยุฮ ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ไมจ เปอะ ทไว โอเอีฮ โม เซ โนก ฮา โอเอีฮ ตอง เปอะ ทไว โครยญ ฮาวก เคิ เซ, ไม่ โอเอีฮ ตอง เปอะ ทไว ปะจัม โครยญ ซเง่ะ, ไม่ ญอต แปง ทไว เปอะ ไม่ รอาวม อะงุน เซ โรฮ. ป โซม ป ปอน ทไว เปอะ เซ, มัฮ ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก เนอึม รพาวม อื. ");
INSERT INTO lcp_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","เญือม เอีจ ฮาวก เคิ อาแลฮ เซ กาว ซาวม, ไมจ เปอะ โพรม ดิ ไม่ ปุ แตะ ละ ซ นัปทื เปอะ พะจาว นึง. ไน ซเงะ เซ ไมจ เปอะ เออึป ป โซม แตะ ไม่ โอ เปอะ ไมจ ยุฮ กัน ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ไมจ เปอะ ตอง ทไว โอเอีฮ ละ พะจาว, ป มัฮ ป ซออย ฮงาื ละ อื ไม่ ป ปุก รพาวม อื. ป ไมจ เปอะ ทไว เซ มัฮ โมวก โปก นุม ติ ตัว, แกะ โปก ระ ติ ตัว, ไม่ กวน แกะ โปก อาญุ ติ เนอึม อาแลฮ ตัว. โอเอีฮ โม เซ ไมจ โตว อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","เฮงาะ รโกะ ป ไมจ เปอะ ทไว ดิ ไม่ อื เซ มัฮ ตอก เฮี, มัฮ ญอต แปง ซเบื่อก ไม่ ลออยฮ กาวก. โมวก ติ ตัว เซ ทไว ไม่ ญอต แปง เซ แลฮ ลิต, แกะ โปก ติ ตัว ไม่ แปง ปาวน ลิต, ");
INSERT INTO lcp_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","กวน แกะ ติ ตัว ไม่ แปง ลอา ลิต โครยญ ตัว อื. ");
INSERT INTO lcp_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ไมจ เปอะ ทไว ปิ โปก ติ ตัว ละ ซ แปน ควน โตฮ เปอะ ติ แตะ ฮา มั่ป. มัฮ โนก ฮา ปิ ทไว เปอะ ละ แปน อื ควน รไซจ พิต โฌวะ ยุฮ ปุย, ไม่ โอเอีฮ ตอง ปุย ทไว โครยญ ซเง่ะ, ไม่ รอาวม อะงุน ไม่ เฮงาะ รโกะ ป ทไว ปะจัม เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“เญือม ฮาวก เคิ อาแลฮ เซ กาว โรฮ พอน ซาวม, ไมจ เปอะ โพรม ดิ ไม่ ปุ แตะ. ไมจ เปอะ ชลอง กัน เลียง เซ อาแลฮ ซเงะ ละ ซ นัปทื เปอะ พะจาว, ไม่ โอ เปอะ ไมจ ยุฮ กัน ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ไน ซเงะ เมือ โรง นึง อื ไมจ เปอะ ตอง ทไว ป โซม ป ปอน ละ พะจาว. โอเอีฮ ทไว เปอะ เซ ซ แปน ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก อื รพาวม อื. ป ไมจ เปอะ ทไว เซ มัฮ โมวก โปก นุม กาว โรฮ ลอวย ตัว, แกะ โปก ระ ลอา ตัว, ไม่ กวน แกะ โปก อาญุ ติ เนอึม กาว โรฮ ปาวน ตัว. ซัตซิง โม เซ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ไมจ เปอะ ทไว ไม่ ญอต แปง ซเบื่อก ไม่ ลออยฮ กาวก, โมวก ติ ตัว ไม่ แปง แลฮ ลิต, แกะ โปก ระ ติ ตัว ไม่ แปง ปาวน ลิต, ");
INSERT INTO lcp_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","กวน แกะ ติ ตัว ไม่ แปง ลอา ลิต. โครยญ ตัว อื, ไมจ โรฮ เปอะ ทไว ไม่ รอาวม อะงุน. ");
INSERT INTO lcp_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ไมจ โรฮ เปอะ ทไว ไม่ ปิ โปก ระ ติ ตัว ละ ซ แปน อื ควน โตฮ เปอะ ติ แตะ ฮา มั่ป ยุฮ แตะ. ไมจ เปอะ ทไว โอเอีฮ โม เซ โนก ฮา โอเอีฮ ตอง ปะจัม เปอะ ทไว โครยญ ซเง่ะ ไม่ ญอต แปง ไม่ รอาวม อะงุน ทไว เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ไน ซเงะ ลอา นึง อื, ไมจ เปอะ ทไว โมวก โปก นุม กาว โรฮ ลอา ตัว, แกะ โปก ระ ลอา ตัว, ไม่ กวน แกะ โปก อาญุ ติ เนอึม กาว โรฮ ปาวน ตัว. โอเอีฮ โม เซ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","19","โนก ฮา เซ ไมจ โรฮ เปอะ ทไว ไม่ โอเอีฮ ไฮญ ตอก โอเอีฮ ทไว เปอะ ไน ซเงะ เมือ โรง อื เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ไน ซเงะ ลอวย นึง อื, ไมจ เปอะ ทไว โมวก โปก นุม กาว โรฮ ติ ตัว, แกะ โปก ระ ลอา ตัว, ไม่ กวน แกะ โปก อาญุ ติ เนอึม กาว โรฮ ปาวน ตัว. โอเอีฮ โม เซ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","22","โนก ฮา เซ ไมจ โรฮ เปอะ ทไว ไม่ โอเอีฮ ไฮญ ตอก โอเอีฮ ทไว เปอะ ไน ซเงะ เมือ โรง อื เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ซเงะ ปาวน นึง อื, ไมจ เปอะ ทไว โมวก โปก นุม กาว ตัว, แกะ โปก ระ ลอา ตัว, ไม่ กวน แกะ โปก อาญุ ติ เนอึม กาว โรฮ ปาวน ตัว. โอเอีฮ โม เซ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","25","โนก ฮา เซ ไมจ โรฮ เปอะ ทไว ไม่ โอเอีฮ ไฮญ ตอก โอเอีฮ ทไว เปอะ ไน ซเงะ เมือ โรง อื เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ซเงะ พอน นึง อื ไมจ เปอะ ทไว โมวก โปก นุม ซไตม ตัว, แกะ โปก ระ ลอา ตัว, กวน แกะ โปก อาญุ ติ เนอึม กาว โรฮ ปาวน ตัว. โอเอีฮ โม เซ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","28","โนก ฮา เซ ไมจ โรฮ เปอะ ทไว ไม่ โอเอีฮ ไฮญ ตอก โอเอีฮ ทไว เปอะ ไน ซเงะ เมือ โรง อื เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ซเงะ แลฮ นึง อื, ไมจ เปอะ ทไว โมวก โปก นุม ซเตะ ตัว, แกะ โปก ระ ลอา ตัว, กวน แกะ โปก อาญุ ติ เนอึม กาว โรฮ ปาวน ตัว. โอเอีฮ โม เซ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","31","โนก ฮา เซ ไมจ โรฮ เปอะ ทไว ไม่ โอเอีฮ ไฮญ ตอก โอเอีฮ ทไว เปอะ ไน ซเงะ เมือ โรง อื เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ซเงะ อาแลฮ นึง อื, ไมจ เปอะ ทไว โมวก โปก นุม อาแลฮ ตัว, แกะ โปก ระ ลอา ตัว, กวน แกะ โปก อาญุ ติ เนอึม กาว โรฮ ปาวน ตัว. โอเอีฮ โม เซ ไมจ อื มัฮ ป โอ อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","34","โนก ฮา เซ ไมจ โรฮ เปอะ ทไว ไม่ โอเอีฮ ไฮญ ตอก โอเอีฮ ทไว เปอะ ไน ซเงะ เมือ โรง อื เซ โครยญ เจือ.” ");
INSERT INTO lcp_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","ซเงะ ซเตะ นึง อื, ไมจ เปอะ โพรม ดิ ไม่ ปุ แตะ. ปุ ยุฮ กัน ติ เจือ เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ไมจ เปอะ ตอง ทไว ป โซม ป ปอน ละ พะจาว ละ ซ เกือฮ เปอะ แปน ป ซออย ฮงาื ละ พะจาว ไม่ ป ปุก รพาวม อื. ไมจ เปอะ ทไว โมวก โปก นุม ติ ตัว, แกะ โปก ระ ติ ตัว, ไม่ กวน แกะ โปก อาญุ ติ เนอึม อาแลฮ ตัว. โอเอีฮ โม เซ เตือง โอยจ อื ไมจ โตว อื ไก ตอก โละพริ. ");
INSERT INTO lcp_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","38","โนก ฮา เซ ไมจ โรฮ เปอะ ทไว ไม่ โอเอีฮ ไฮญ ตอก โอเอีฮ ทไว เปอะ ไน ซเงะ เมือ โรง อื เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","เญือม ไก กัน เลียง ปะจัม ยุฮ เปอะ ไมจ เปอะ ทไว โอเอีฮ โม เฮี ละ พะจาว. ซัตซิง ตอง เปอะ ทไว, เฮงาะ รโกะ ทไว เปอะ, รอาวม อะงุน ไม่ โอเอีฮ ทไว เปอะ ละ ซ รโจะ ดิ เปอะ รพาวม แตะ ไม่ พะจาว. โนก ฮา เซ มัฮ แม ป ทไว เปอะ ตัม รพาวม ฆวต ทไว แตะ, ไม่ ป ทไว เปอะ ตัม ป ซันญา เปอะ อาึง. อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ไอ โมเซ เอีจ รโฮงะ เนอึม อื ละ โม อิซราเอน โครยญ เจือ ตัม ป อัฮ พะจาว ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ไอ โมเซ รโฮงะ อื ละ โม ฮัวนา เจอ ยุฮ โม อิซราเอน ตอก เฮี, “มัฮ เฮี ป อัฮ พะจาว อาึง ละ เปอะ, ");
INSERT INTO lcp_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ดัฮ ไก ปรเมะ ป เอีจ ซันญา อาึง โอเอีฮ ซองนา พะจาว นึง ซ ทไว แตะ โอเอีฮ ละ พะจาว ญุ่ก, นึง ซ ยุฮ อื โอเอีฮ พิเซต ติ เจือ ญุ่ก, ปุย เซ ไมจ โตว อื เกือฮ ติ แตะ แพก ป ซันญา แตะ เซ, ไมจ อื ยุฮ ตัม ป เอีจ ซันญา แตะ เซ โครยญ เจือ. ");
INSERT INTO lcp_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“ดัฮ มัฮ ปเครีฮ ป อาวต ลั่ง นึง เญือะ ยุฮ เปือะ แตะ ป ซันญา อาึง ละ ซ ทไว แตะ โอเอีฮ ละ พะจาว ญุ่ก, ละ ซ ยุฮ อื โอเอีฮ พิเซต ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ดัฮ เปือะ อื ฮมอง ป ซันญา อื เซ, ไม่ โอ อื คัต รัม ยุฮ อื, ปุย เซ ไมจ อื ยุฮ ตัม ป เอีจ ซันญา แตะ อาึง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ดัฮ เปือะ อื ฮมอง ลปุง ซันญา อื เซ ไม่ คัต อื รัม ยุฮ อื ตัม ป ซันญา แตะ, ปัง โอ ยุฮ อื ตัม ป ซันญา แตะ เซ แปน. พะจาว ทื โตว พิต ยุฮ อื นึง โอ เปือะ อื เซ เกือฮ ยุฮ อื ตัม ป ซันญา อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ดัฮ ไก ปรโปวน โอ ดิ เญือะ อา, ดัฮ ซันญา อาึง โอเอีฮ ซองนา พะจาว, ปัง มัฮ โฆง อื อัฮ, ปัง มัฮ โคะ อัฮ อื ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ฟวยจ เซ ปุย เซ ดัฮ เอีจ เญือะ เอีญ โฮ, ไมจ อื ยุฮ ตัม ป เอีจ ซันญา แตะ เซ, โนก ฮา คัต ปรเมะ เญือะ อื รัม ยุฮ อื เญือม ฮมอง อื ไลลวง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ดัฮ ปรเมะ เญือะ อื เอีจ ยุง ไลลวง อื ไม่ คัต อื โอ ยุฮ อื ตัม ป ซันญา อื เซ, ปัง โอ ยุฮ อื ตัม ป ซันญา แตะ เซ แปน. พะจาว ทื โตว พิต ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“ป มัฮ แมฮัง แมไม, ไมจ อื ยุฮ ตัม ป เอีจ ซันญา แตะ อาึง เซ โครยญ เจือ, เตือง กัน ทไว แตะ, เตือง กัน พิเซต ตะ แตะ ยุฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ดัฮ ไก ปรโปวน เอีจ เญือะ อา ไม่ ซันญา อื ซ ทไว แตะ โอเอีฮ ซองนา พะจาว ญุ่ก, ซันญา นึง กัน พิเซต ตะ แตะ ยุฮ ญุ่ก, ปุย เซ ไมจ อื ยุฮ ตัม ป ซันญา แตะ เซ โครยญ เจือ, ");
INSERT INTO lcp_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","โนก ฮา ซ ฮมอง ปรเมะ เญือะ อื ไม่ คัต อื รัม ยุฮ อื ตัม ซันญา อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ดัฮ ปรเมะ เญือะ อื เอีจ ฮมอง ไลลวง อื ไม่ คัต อื รัม ยุฮ อื ตัม ป ซันญา อื เซ, ปัง โอ ยุฮ อื ตัม ป ซันญา แตะ เซ แปน. พะจาว ซ ทื โตว พิต ยุฮ อื. ");
INSERT INTO lcp_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ปรเมะ เญือะ อื ไก อัมนัต ละ ซ เกือฮ แตะ ป ซันญา อื เซ ตอน ฮมัน ไม่ ปุน เกือฮ อื โอ แปน ป โกว. ");
INSERT INTO lcp_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ดัฮ ปรเมะ เญือะ อื เอีจ ฮมอง ไลลวง ป ซันญา อื เน่อึม กา เซ เมาะ ลอา ลอวย ซเงะ, ไม่ โอ อื คัต รัม ยุฮ อื ตัม ป ซันญา อื เซ, ปุย เซ ไมจ อื ยุฮ ตัม ป ซันญา แตะ เซ โครยญ เจือ. เญือม โอ อื คัต รัม ยุฮ ตัม ป ซันญา อื เซ เอีจ บริญ ไม่ อัฮ อื ปุก ละ โกะ แตะ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","กัง เคะ เอ ดัฮ คัต แม อื รัม ยุฮ อื ตัม ป เอีจ ซันญา แตะ เซ, มัฮ ปรเมะ เญือะ อื เซ ป ซ พิต นึง อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","ลปุง ไล เซ มัฮ โกตไม เกือฮ พะจาว ละ ไอ โมเซ. มัฮ ไลลวง ลปุง ซันญา ปรโปวน โอ ดิ เญือะ ป อาวต ลั่ง นึง เญือะ เปือะ แตะ, ไม่ ไลลวง ลปุง ซันญา ปรโปวน เอีจ เญือะ, ป เอีจ อาวต ไม่ ปรเมะ เญือะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ไมจ เปอะ เกือฮ โม อิซราเอน โรก เวน ละ โม มีเดี่ยน. ฟวยจ เซ อาึ ซ รโจะ ปะ ไม่ โม จัตเจือ ไพรม เปอะ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","เญือม เซ ไอ โมเซ รโฮงะ อื ละ ปุย เตือง โอยจ อื ตอก เฮี, “ไมจ เปอะ เกือฮ ปุย เพรียง ติ แตะ ละ ซ โฮว รุป เปอะ ปุ แตะ ไม่ โม มีเดี่ยน เซ ง่อน, ไม่ เกือฮ เปอะ โรก เวน ละ อื ตัม ป พิต ยุฮ อื ละ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ไมจ เปอะ เลือก ปุย ไน เจอ ยุฮ แตะ เตือง ไพ เตือง มัน, ละ ซ เกือฮ เปอะ โฮว รุป เซิก, ติ เจอ ติ เปือน ปุย,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","เญือม เซ โม อิซราเอน เลือก เนอึม โม ปรเมะ ไน เจอ ยุฮ แตะ, ติ เจอ ติ เปือน ปุย. โม ป เลือก อื เซ เตือง โอยจ อื ไก ติ ฮมาึน ไม่ ลอา เปือน ปุย. ปุย โม เซ ไปญ เครอึง รุป ยุฮ แตะ โครยญ โฆะ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ฟวยจ เซ ไอ โมเซ เกือฮ ปุย โม เซ โฮว รุป เซิก. เกือฮ ฟีเนฮัต กวน เอเลอาซา ป มัฮ ซตุ เซ แปน ป โฮว ละ ซ มอง แตะ ควป คุม เครอึง ซัมคัน ป โรวก อื ไม่ แตะ เซ ไม่ โม ป ปาึง โตวต ซัมคัน ยุฮ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","ปุย โม เซ ตอซู เนอึม ปุ แตะ ไม่ โม มีเดี่ยน ตัม ป ซตอก พะจาว อาึง ละ ไอ โมเซ. โฮลฮ ยุฮ ยุม ไม่ โม ปรเมะ นึง อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","โม เซ โฮลฮ โรฮ ยุฮ ยุม ไม่ โม กซัต ยุฮ โม มีเดี่ยน เซ พอน ปุย เอิน, ป มัฮ กซัต เอวี, กซัต เรเคม, กซัต ซู, กซัต เฮอ, ไม่ กซัต เรบ่า. ยุฮ โรฮ ยุม ไม่ บ่าลาอัม กวน เบ่โอ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","โม อิซราเอน โฮมวต โม ปรโปวน โม มีเดี่ยน ไม่ โม กวนดุ นึง อื, ไม่ ตุย อื โรวก ซัตซิง ยุฮ อื ป มัฮ โมวก, แกะ ปิ, ฮอยจ ละ คาวคอง ไฮญ ยุฮ อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","โตก โรฮ ย่วง อาวต อื ไม่ ไคะ ยุฮ อื เกือฮ ฮะ แกล เอิน. ");
INSERT INTO lcp_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","ฟวยจ เซ ซาวป ตุย โรวก โอเอีฮ โฮลฮ แตะ เซ เตือง โอยจ อื, เตือง ซัตซิง, เตือง ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","โรวก โอเอีฮ โม เซ ฮอยจ ละ ไอ โมเซ ไม่ เอเลอาซา ไม่ ละ โม อิซราเอน เตือง โอยจ อื, โรวก อื ละ อื ฮอยจ นึง นา ก ตัง อื ไคะ ยุฮ แตะ นึง ลโลวง โมอัป เฆียง โกลง จอแด่น รเตือป เมือง เยรีโค เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ไอ โมเซ ไม่ เอเลอาซา ไม่ โม ฮัวนา ยุฮ ปุย อิซราเอน เซ, โอก ฮา ไคะ ยุฮ แตะ ละ ซ โฮว รัป แตะ โม ป เอีญ เน่อึม โฮว รุป แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ไอ โมเซ รอก พาวม นึง โม ฮัวนา ตฮัน เซ เตือง โม ไนพัน ไนลอยะ นึง อื, เมาะ ป เอีญ เน่อึม โฮว รุป แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","ไอ โมเซ ไฮมญ ปุย โม เซ ตอก เฮี, “โม เปะ เมอยุ โอ เปอะ ยุฮ ยุม ไม่ ปรโปวน โม เฮี เยอ? ");
INSERT INTO lcp_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","อัม มัฮ โอ เปอะ ไตม มัฮ ปรโปวน โม เฮี ป ยุฮ ตัม ลปุง เพอึก ตอม บ่าลาอัม โฮ? มัฮ ป เกือฮ ปุย ยุฮ ป พิต ละ พะจาว นึง ย่วง เปโอ ไม่ เกือฮ อื ปุย ไน พะจาว ยุม นึง ลอก แตะ พาญัต ฆอก ลอน โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","ไมจ เปอะ ยุฮ แปฮ ยุม ไม่ กวนดุ รเมะ เซ โครยญ โฆะ อื. ไมจ โรฮ เปอะ ยุฮ ยุม ไม่ โม ปรโปวน ป เอีจ ยุ ปุ แตะ ไม่ ปรเมะ เซ โครยญ โฆะ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","โม กวนดุ รโปวน ป โอ อื ดิ ยุ ปุ แตะ ไม่ ปรเมะ นึง อื เซ, ดัฮ เปอะ ฆวต ละ ละ โม โกะ เปอะ ไอฮ แปน โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“เมาะ ป ยุฮ ยุม ไม่ ปุย โครยญ โฆะ อื ไม่ โม ป ลอก ป ยุม เซ, ไมจ อื อาวต ก พริ ไคะ อาแลฮ ซเงะ. ไน ซเงะ ลอวย ไม่ ซเงะ อาแลฮ นึง อื, ไมจ อื เกือฮ ติ แตะ ซง่ะ ไล ตัม ไล กอ ยุฮ ไพรม เปอะ. โม ปรโปวน ป โฮมวต เปอะ เซ ไมจ โรฮ เปอะ เกือฮ แปน ป ซง่ะ ไล โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ป มัฮ เครอึง เซอึก ไม่ โอเอีฮ ไฮญ ป โกว ปุย โครยญ เจือ, เมาะ ป ยุฮ ปุย นึง ฮัก ไม่ ฮาึก ปิ ไม่ นึง โคะ, ไมจ โรฮ เปอะ เกือฮ แปน ป ซง่ะ ตัม ไล อื โครยญ เจือ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","เอเลอาซา ป มัฮ ซตุ เซ อัฮ อื ละ โม ตฮัน ป เอีญ เน่อึม โฮว รุป แตะ เซ ตอก เฮี, “เฮี มัฮ โกตไม ป ซตอก พะจาว อาึง ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","23","โอเอีฮ เมาะ ป ตอง ปุย นึง งอ ป โอ อื ฮะ, ป มัฮ ไคร มาื, ไร ซเงี, ไร เฮลีจ, แฮ ดีบุ่ก ไม่ บรัก, ไมจ โรฮ เปอะ ตอง นึง งอ ละ ซ เกือฮ แปน ป ซง่ะ ไล. โนก ฮา เซ ไมจ แม เปอะ โกว รอาวม ซัมคัน ละ, ละ ซ เกือฮ เปอะ แปน ป ซง่ะ ไล โรฮ. โอเอีฮ โอ คัม งอ นึง อื เซ, ไมจ โรฮ เปอะ โกว รอาวม เซ ละ โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ไน ซเงะ อาแลฮ เซ ไมจ เปอะ ซัก เครอึง แตะ. ฟวยจ เซ ซ แปน เปอะ ปุย ซง่ะ ไล, ไม่ ซ โฮลฮ เปอะ เลียก อาวต แม นึง ไคะ เบือ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","พะจาว อัฮ เฮี ละ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“ปะ ไม่ เอเลอาซา ไม่ โม ฮัวนา ยุฮ ปุย โฮวน เซ, ไมจ เปอะ เมีญ เมาะ ไก โอเอีฮ โฮลฮ เปอะ เซ, เตือง ปุย เตือง ซัตซิง นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ไมจ เปอะ รฆุ เลีฮ ลอา เกือฮ บริญ โฮ. ไมจ เปอะ เกือฮ ละ ป โฮว รุป เซ บลัฮ. บลัฮ อื เซ ไมจ เปอะ เกือฮ ละ โม ป โอ โฮลฮ โฮว รุป เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ป มัฮ รโตง โม ตฮัน นึง อื เซ, ไน พอน รอย ปุน ไมจ เปอะ ละ อาึง ติ ปุน ละ ซ ทไว เปอะ ละ พะจาว เตือง ปุย เตือง โมวก, เตือง บรัง เตือง แกะ เตือง ปิ. ");
INSERT INTO lcp_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","โอเอีฮ ทไว เปอะ ละ พะจาว เซ ไมจ เปอะ ตาว ละ เอเลอาซา ป มัฮ ซตุ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ป มัฮ รโตง ปุย โฮวน นึง อื เซ, โอเอีฮ ไน รฮอน ปุน ไมจ เปอะ ละ อาึง ติ ปุน, ละ ซ ทไว เปอะ ละ พะจาว, ปัง มัฮ ปุย, ปัง มัฮ โมวก, บรัง, แกะ, ปิ. โอเอีฮ โม เซ ไมจ เปอะ เกือฮ ละ โม เลวี นึง มัฮ อื ป แลน แก พากัง ระ ยุฮ พะจาว เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ไอ โมเซ ไม่ เอเลอาซา ป มัฮ ซตุ เซ ยุฮ เนอึม อื ตัม ลปุง ซตอก พะจาว ละ แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","โอเอีฮ ป โฮลฮ โม ตฮัน โรวก เญือม เซ, โนก ฮา ป ปอน อื นึง คระ เอีญ แตะ, มัฮ ตอก เฮี. มัฮ แกะ ปิ 675,000 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","มัฮ โมวก 72,000 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","บรัง 61,000 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","มัฮ กวนดุ รโปวน ป โอ ดิ ยุ ปุ แตะ ไม่ ปรเมะ 32,000 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ป มัฮ รโตง ป โฮลฮ โม ตฮัน นึง อื เซ มัฮ แกะ ปิ 337,500 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ป มัฮ แกะ ปิ รโตง พะจาว นึง อื ไก 675 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","มัฮ โรฮ โมวก 36,000 ตัว. มัฮ โมวก รโตง พะจาว นึง อื 72 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","มัฮ โรฮ บรัง 30,500 ตัว, มัฮ รโตง พะจาว นึง อื 61 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ป มัฮ ปุย นึง อื ป มัฮ รโตง โม ตฮัน เซ ไก 16,000 ปุย. มัฮ ปุย รโตง พะจาว นึง อื ง่วย โรฮ ลอา ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ไอ โมเซ มอป โอเอีฮ ป เอีจ ละ แตะ อาึง ละ ซ ทไว อื ละ พะจาว เซ ละ เอเลอาซา ป มัฮ ซตุ เซ, ตัม ดวน พะจาว แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ป มัฮ รโตง ปุย โฮวน นึง อื เซ มัฮ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","มัฮ แกะ ปิ 337,500 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","มัฮ โรฮ โมวก 36,000 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","มัฮ บรัง 30,500 ตัว. ");
INSERT INTO lcp_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","มัฮ ปุย 16,000 ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","เน่อึม นึง โอเอีฮ โม เซ เตือง โอยจ อื ป มัฮ รโตง ปุย โฮวน เซ, ไอ โมเซ เอีจ มอป ป มัฮ รโตง พะจาว นึง อื ละ โม เลวี ตัม ป ซตอก พะจาว อาึง ละ แตะ. ไน รฮอน ปุน, ตุย อื ตา ติ ปุน, เตือง ปุย เตือง ซัตซิง นึง อื, นึง มัฮ โม เลวี เซ ป แลน แก พากัง ระ ยุฮ พะจาว เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ฟวยจ เซ ป มัฮ โม ฮัวนา ตฮัน เตือง โอยจ อื, เตือง ไน พัน ไม่ ไน ลอยะ นึง อื, โฮว เคะ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","อัฮ เฮี ละ อื, “เอะ ป มัฮ กวนไจ เปอะ เอีจ ฟวยจ เมีญ เญอะ โม ตฮัน ป อาวต ฆรึม บั่งคัป โม เอะ เซ. ไก โตว ติ ปุย เนอึม ป ไฆร อื. ");
INSERT INTO lcp_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","เอะ โรวก โรฮ โอเอีฮ ป โฮลฮ แตะ ละ ซ ทไว แตะ ละ พะจาว รโตง โอ โม โกะ แตะ ยุม นึง กัน รุป แตะ เซ. ป ทไว เยอะ เซ มัฮ ป ยุฮ ปุย นึง ไคร, ป มัฮ ซเลียง ไม่ เบล ไม่ ไฌม ไม่ ตอฮู ไม่ ฮนัง ไคร เตือง โอยจ อื,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ไอ โมเซ ไม่ เอเลอาซา ป มัฮ ซตุ เซ รัป เนอึม โอเอีฮ ป ยุฮ ปุย นึง ไคร เซ. ");
INSERT INTO lcp_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","เครอึง ไคร ทไว โม ฮัวนา ตฮัน ป มัฮ ไน พัน ไม่ ไน ลอยะ เซ, นัมนัก อื ไก 16,750 เชเคน. ");
INSERT INTO lcp_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","(โม ตฮัน เตือง โอยจ อื เตอ เอีจ โฮลฮ ตุย โอเอีฮ ละ โกะ แตะ ไอฮ เตือง ไพ เตือง มัน.) ");
INSERT INTO lcp_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ไอ โมเซ ไม่ เอเลอาซา ป มัฮ ซตุ เซ ตาว ไคร ทไว โม ไน พัน ไน ลอยะ เซ ฮอยจ นึง พากัง ระ ยุฮ พะจาว ละ ซ เกือฮ อื โม อิซราเอน เซ โตก ละ ตอก เอีจ เรอึม พะจาว แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","ปุย เจอ รูเบ่น ไม่ เจอ กาต ไก โมวก ยุฮ โฮวน. เญือม ยุ อื นาตี เมือง ยาเซอ ไม่ เมือง กิเลอัต เซ, ยุ เกียฮ จัป อื ละ เลียง ปุย ซัตซิง นึง. ");
INSERT INTO lcp_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","โม เซ โฮว ฆาื อื เคะ ไอ โมเซ ไม่ เอเลอาซา ป มัฮ ซตุ เซ ไม่ โม ฮัวนา ไฮญ นึง อื. อัฮ เฮี ละ อื, ");
INSERT INTO lcp_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“นาตี ย่วง อาทาโรต, ย่วง ดี่โบ่น, ย่วง ยาเซอ, ย่วง นิมรา, ย่วง เฮตโบ่น, ย่วง เอเลอาเล, ย่วง เซบั่น, ย่วง เนโบ่, ไม่ ย่วง เบ่โอน, ");
INSERT INTO lcp_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","มัฮ ตื นาตี ย่วง เกือฮ พะจาว ไป นึง โม อิซราเอน. มัฮ นา ก จัป อื ละ เลียง ปุย ซัตซิง นึง, เอะ ป มัฮ กวนไจ เปอะ ไก โมวก ยุฮ ฮุ โฮวน. ");
INSERT INTO lcp_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ดัฮ ปุก รพาวม เปอะ, ปัว เปอะ เกือฮ ปลัฮเตะ นา เซ ละ เอะ. ปัว เปอะ โอ เกือฮ เอะ โฮว อาวต นึง บลัฮ โกลง จอแด่น ลวง ลั่กเติต,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ไอ โมเซ โลยฮ อื ละ อื, “โม เปะ อัม มัฮ ซ อาวต ซไบ่ เปอะ นา เฮี, ลไล โฮว รุป โม เอียกปุ เปอะ ป มัฮ โม อิซราเอน ไฮญ เซ? ");
INSERT INTO lcp_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","เมอยุ ซ เกือฮ เปอะ โม อิซราเอน ไฮญ เซ ไก รพาวม ฆวต ราึต ลั่กเคะ แตะ, ฮา ซ เตือง อื โกลง จอแด่น ฮอยจ นึง ปลัฮเตะ ซันญา พะจาว อาึง ละ แตะ เซ? ");
INSERT INTO lcp_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","เญือม ดวน อาึ ปุย โฮว เน่อึม เมือง คาเด่ต บ่าเนีย ละ ซ โฮว เลียป อื บั่นเมือง โฮ, โม จัตเจือ ไพรม เปอะ เอีจ ยุฮ โรฮ อื ตอก ยุฮ โม เปะ อื ปเลี่ย เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","เญือม ฮาวก โม ป เลียป เมือง เซ ฮอยจ นึง ลโลวง เอชโค เซ, ไม่ ยุ อื บั่นเมือง เซ, เมือต เอีจ เอีญ ปุย โม เซ ปังเมอ ลเตือฮ เอิน อัฮ ควน ซ ราึต ปุย ไฮญ ลั่กเคะ แตะ นึง โอ อื ญอม เลียก นึง บั่นเมือง ป ซันญา พะจาว อาึง ละ แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ซเงะ เซ พะจาว ฮาวก รพาวม ละ อื ฆาื อื. ลอต ซันญา ซโตฮ อาึง อื ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘ปุย เมาะ ป เอีจ ไก อาญุ อื เคียง ง่า เนอึม ฮาวก ก ล่าวง ป โอก เน่อึม เมือง อียิป เซ, ซ โฮลฮ โตว เลียก นึง บั่นเมือง ซันญา อาึ ละ อัปราฮัม ไม่ ยิซฮัก ไม่ ยาโคป, มัฮ ฆาื โอ อื เนอึม รพาวม ละ อาึ. ");
INSERT INTO lcp_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","มัฮ คาเลป กวน เยฟูเน ป มัฮ โม เคนัต ไม่ โยชูวา กวน นูน โน่ง ป ซ โฮลฮ เลียก เกอ. ปุย ลอา เซ มัฮ ป ฟวต อาึ ไม่ รพาวม เนอึม แตะ,’ อัฮ เซ ละ เอะ. ");
INSERT INTO lcp_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","“ฟวยจ เซ พะจาว ฮาวก รพาวม ละ ปุย โฮวน เซ, เกือฮ อื โฮว ไป โฮว มา ฆาื อื นึง ลาึน เวือฮ เซ รปาวน เนอึม, ฮอยจ ละ ยุม โอยจ ปุย จุป เซ, นึง มัฮ อื ป ยุฮ ป พิต ละ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","ปเลี่ย เฮี โม เปะ ยุฮ ลั่ง เปอะ ตอก ยุฮ โม มะเปือะ แตะ เซ, นึง มัฮ เปอะ จัตเจือ ปุย มั่ป ไม่ มัฮ เปอะ ป ซ เกือฮ รพาวม ฮาวก ยุฮ พะจาว ฮอยจ ละ โม อิซราเอน เซ โฮว ละ เรียง แตะ ฮา ไพรม แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ดัฮ โม เปะ ป มัฮ โม รูเบ่น ไม่ โม กาต โอ ยุฮ ตัม ปุก อื รพาวม พะจาว เน่อึม ปเลี่ย เฮี, พะจาว ซ ละ โปวฮ โม อิซราเอน ฆาื อื เตือง โอยจ อื นึง ลาึน เวือฮ. กัน ยุฮ พะจาว ไลจ ไม่ ปุย ตอก เซ ซ มัฮ ฆาื โม เปะ,” อัฮ เซ ไอ โมเซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","ปุย โม เซ เลียก เคะ ไอ โมเซ. อัฮ เฮี ละ อื, “ปัว เปอะ เกือฮ เอะ ยุฮ ฆรุง ละ ซ เกือฮ คอง เลียง แตะ อาวต กไน อื, ไม่ ยุฮ เญือะ ย่วง ละ ซ เกือฮ โม กวนดุ ไม่ โม ปรโปวน อาวต นึง อื ละ ฮัม. ");
INSERT INTO lcp_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ฟวยจ เซ เอะ ซ เพรียง โรฮ ติ แตะ ละ ซ โฮว ดิ ไม่ โม เอียกปุ แตะ ละ ซ โฮว เรอึม รุป ดิ ไม่ อื, เอะ ซ แปน ป โฮว รกา ละ ซ โฮลฮ ปลัฮเตะ เซ แปน คอง อื. ลไล โฮว เอะ เซ โม กวน เฌือต เตอะ เซ ซ โฮลฮ อาวต นึง ย่วง ป ไก ฆรุง ตอน เบือ อื, ละ ซ แปน ควน เฆีญ อื ติ แตะ ฮา โม ป อาวต ลั่ง นึง เมือง เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","เอะ ซ ญอม โตว เอีญ กา เฆียง โฮลฮ โม อิซราเอน ไฮญ ปลัฮเตะ นา เซ แปน คอง แตะ โครยญ โฆะ ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","เอะ ซ ไอฮ โตว ปลัฮเตะ ป ไก นึง บลัฮ โกลง จอแด่น เซ เฟือฮ เอิน, นึง เอีจ โฮลฮ เอะ ปลัฮเตะ ป ไก บลัฮ โกลง จอแด่น ลวง ลั่ก โอก ซเงะ นึง อื เฮี แปน คอง แตะ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ไอ โมเซ โลยฮ อื ละ อื, “ดัฮ โม เปะ ซ ยุฮ เนอึม ตัม ป อัฮ แตะ เซ, ไมจ เปอะ เพรียง เครอึง รุป แตะ ซองนา พะจาว ละ ซ โฮว รุป เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ไมจ เปอะ เกือฮ โม ตฮัน ยุฮ แตะ โฮว เตือง โกลง จอแด่น, ตัม ป ดวน พะจาว แตะ โครยญ โฆะ ปุย, ฮอยจ ละ ซ เกือฮ พะจาว เปอะ เป โม ป รุป ไม่ เปอะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ฟวยจ เกือฮ พะจาว ปลัฮเตะ เซ แปน คอง เอะ เซ, โม เปะ ซ โฮลฮ เปอะ เอีญ ย่วง แตะ, นึง เอีจ กุมปอ กัน ลัง ยุฮ เปอะ ละ พะจาว, ไม่ กัน ลัง ยุฮ เปอะ ละ โม อิซราเอน. ซ ที นึง เซ ซองนา พะจาว มัฮ ปลัฮเตะ บลัฮ โกลง ลั่กเอีฮ เฮี คอง โม เปะ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","ดัฮ เปอะ โอ ยุฮ ตัม ป เอีจ อัฮ แตะ อาึง เซ, โม เปะ ปังเมอ เอีจ มัฮ ยุฮ เปอะ มั่ป พิต ละ พะจาว, ไมจ เปอะ เกือฮ ติ แตะ ยุง แจง แน, มั่ป ยุฮ เปอะ เซ มัฮ ป ซ เกือฮ โม เปะ ลอก ตุต แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ดัฮ เปอะ ฆวต ยุฮ เญือะ ย่วง ละ อาวต กวน เฌือต แตะ ไม่ ยุฮ เปอะ ฆรุง ละ อาวต คอง เลียง เปอะ ยุฮ เมิฮ, ปังเมอ ไมจ เปอะ ยุฮ ตัม ป เอีจ ซันญา แตะ อาึง เซ,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","โม กาต ไม่ โม รูเบ่น เซ อัฮ อื ตอก เฮี, “เอะ ป มัฮ กวนไจ ยุฮ เปอะ ซ ยุฮ ตัม ป ซตอก เปอะ ละ แตะ เซ, ");
INSERT INTO lcp_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","โม ปรโปวน เญือะ เอะ เฮี ไม่ โม กวน เนอะ ไม่ โมวก ไม่ แกะ ยุฮ ฮุ ซ อาวต นึง โม ย่วง ป ไก นึง กิเลอัต เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","เอะ ป มัฮ กวนไจ ยุฮ เปอะ โครยญ โฆะ โอะ ซ เพรียง ติ แตะ ละ ซ โฮว รุป แตะ ซองนา พะจาว. เอะ ซ เตือง โกลง จอแด่น เซ ละ ซ โฮว รุป แตะ ตัม ป ซตอก เปอะ เซ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ไอ โมเซ อัฮ อื ละ เอเลอาซา ป มัฮ ซตุ เซ ไม่ โยชูวา กวน นูน ไม่ โม ฮัวนา ยุฮ โม อิซราเอน เซ ตอก เฮี, ");
INSERT INTO lcp_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“ดัฮ โม ปรเมะ ไน โม กาต ไม่ โม รูเบ่น เซ เตือง โอยจ อื เตือง โกลง จอแด่น ละ ซ โฮว รุป แตะ ตัม ป ซตอก พะจาว อาึง, ดัฮ เรอึม เนอึม รุป ไม่ เปอะ ฮอยจ ละ เป เปอะ, ไม่ โฮลฮ เปอะ ปลัฮเตะ เซ แปน คอง แตะ, ไมจ เปอะ มอป เมือง กิเลอัต เซ ละ โม เซ เกือฮ แปน คอง อื. ");
INSERT INTO lcp_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ดัฮ โม เซ โอ เตือง เนอึม โกลง เซ ไม่ โอ อื เรอึม รุป ไม่ เปอะ โฮ, โม เซ ปังเมอ ซ โฮลฮ รโตง แตะ นึง เมือง คะนาอัน เซ โน่ง ตอก โม เปะ โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","โม กาต ไม่ โม รูเบ่น เซ โลยฮ อื, “เอะ ป มัฮ กวนไจ ยุฮ เปอะ ซ ยุฮ เนอึม ตัม ลปุง ซตอก พะจาว อาึง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","เอะ ซ เตือง ซองนา พะจาว ฮอยจ นึง เมือง คะนาอัน ละ ซ เรอึม แตะ รุป ดิ ไม่ ปุย ตอก เซ, ปลัฮเตะ ป ซ ไอฮ เอะ แปน คอง แตะ, ปังเมอ มัฮ บลัฮ โกลง จอแด่น ลวง ลั่กเอีฮ เฮี,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ไอ โมเซ เกือฮ เนอึม ปลัฮเตะ นา เซ ละ เจอ กาต ไม่ เจอ รูเบ่น, เกือฮ โรฮ อื ละ เจอ มะนาเซ ป มัฮ กวน โยเซป ตา บลัฮ เจอ. ปลัฮเตะ เกือฮ อื ละ อื เซ มัฮ นาตี ยุฮ กซัต ซีโฮน ป มัฮ โม อาโมไร, ไม่ นาตี ยุฮ กซัต โอก ป อาวต นึง บ่าชัน เตือง ย่วง ระ ย่วง แตวะ ป อาวต นึง เมือง เซ เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","ฟวยจ เซ โม จัตเจือ กาต เฌาะ เพรียง เมือง ดี่โบ่น, ไม่ เมือง อาทาโรต, เมือง อาโรเออ, ");
INSERT INTO lcp_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","เมือง อัตโรต โชฟัน, เมือง ยาเซอ, เมือง โยกเบ่ฮา, ");
INSERT INTO lcp_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","เมือง เบ่ตนิมรา, ไม่ เมือง เบ่ตฮารัน เกือฮ อื แปน บั่นเมือง ยุฮ แตะ. เมือง โม เซ ไก ตื ฆรุง ไคว อื ไม่ ไก คอก ละ ซ อาวต แกะ นึง. ");
INSERT INTO lcp_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","ป มัฮ เจอ รูเบ่น เซ, เฌาะ เพรียง เมือง เฮตโบ่น, เมือง เอเลอาเล, เมือง คีริยาทาอิม, ");
INSERT INTO lcp_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","เมือง ซิปมา, ไม่ ย่วง ป อัฮ ไพรม ปุย ย่วง เนโบ่, ไม่ ย่วง บ่าอันเมโอน ไม่. ปุย โม เซ เอีจ เฌาะ ตัง โคระ มอยฮ เมือง ป เอีจ เพรียง แตะ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","โม จัตเจือ มาคี ป มัฮ กวน มะนาเซ ปุน เมือง กิเลอัต. โครฮ โม อาโมไร ป อาวต นึง เมือง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ไอ โมเซ เกือฮ ปลัฮเตะ กิเลอัต ละ จัตเจือ มาคี ละ ซ เกือฮ อื อาวต นา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ยาอี ป มัฮ จัตเจือ มะนาเซ เลียก ตอซู ไม่ ย่วง โฮวน โดฮ. โฮลฮ อื แปน คอง แตะ. ลอต ตัง มอยฮ อื, อัฮ ย่วง ยาอี ไม่ ย่วง โม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ป มัฮ โนบ่า เลียก ตอซู เมือง เคนัต ไม่ ย่วง อาวต รวิต รเวียง อื, โฮลฮ อื แปน คอง แตะ. ลอต โรฮ ปุก มอยฮ เมือง เซ, อัฮ เมือง โนบ่า ไม่ อื ตัม มอยฮ โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","2","เคียง เฮี โฮว มัฮ ไลลวง คระ โฮว โม อิซราเอน, เน่อึม เญือม โอก โฮว อื ฮา เมือง อียิป, แปน มู แปน มู แปน รตัฮ รตัฮ แตะ โฮ, ตัม กัน นัม ไอ โมเซ อื ไม่ อาโรน. พะจาว ดวน ไอ โมเซ โจต อาึง เมาะ ไก รตัฮ คระ โฮว แตะ โครยญ รตัฮ. ");
INSERT INTO lcp_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","เญือม โอก โรง โม อิซราเอน ฮา เมือง อียิป, ปุก ฮาวก เคิ ติ กาว โรฮ พอน ซาวม. ปวยฮ พริ ฟวยจ ซเงะ โซม เลียง ฌาว เซ, โม เซ โอก ฮา เมือง ราเมเซต ไม่ กาึฮ นา ซดู ตา แตะ ซองนา ปันตา โม อียิป เซ. ");
INSERT INTO lcp_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","เญือม เซ ปุก ลไล รมอยจ โม อียิป กวน รเมะ โรง แตะ. มัฮ ป ยุฮ พะจาว ยุม ไม่ ละ ซ เกือฮ อื ปุย ยุง ที มัฮ พะจาว ป ระ อัมนัต ฮา พะ โฮวน ทื โม อียิป เซ. ");
INSERT INTO lcp_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","โม อิซราเอน โอก ฮา เมือง ราเมเซต, โฮว ยุฮ ไคะ อาวต แตะ นึง นาตี ซุกโคต. ");
INSERT INTO lcp_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","เญือม เอีจ โอก อื ฮา ซุกโคต เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง นาตี เอทัม ป ไก ลวง เฆียง ลาึน ซออฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","โอก เน่อึม นา เซ. โวก แม เอีญ ฮอยจ นึง ปีฮะฮิโรต, ป ไก ลวง ลั่ก โอก ซเงะ ละ เมือง บ่าอันเซโฟน, ลอต โฮว ยุฮ ไคะ อาวต แตะ ซดิ ไม่ เมือง มิกโด่น. ");
INSERT INTO lcp_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","เญือม โอก อื ฮา เมือง ปีฮะฮิโรต เซ, เตือง เอิน ปลัฮ รอาวม ซครัก เซ, ลอต โฮว คระ ลาึน เวือฮ เอทัม เซ ลอวย ซเงะ คระ. ฟวยจ เซ ลอต ยุฮ ไคะ อาวต แตะ นึง ย่วง มารา. ");
INSERT INTO lcp_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ฟวยจ โอก อื เน่อึม ย่วง มารา เซ, ฮอยจ แม นึง นาตี เอลิม. นึง เอลิม เซ ไก รอาวม ปลาึฮ นึง กาว โรฮ ลอา โดฮ, ไก โรฮ โคะ อินทะพลัม นึง อาลแฆลฮ โคะ. เญือม เซ ลอต ยุฮ ไคะ อาวต แตะ นา เซ. ");
INSERT INTO lcp_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","โอก เน่อึม นาตี เอลิม เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง เฆียง ปลัฮ รอาวม ซครัก. ");
INSERT INTO lcp_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","โอก เน่อึม เฆียง ปลัฮ รอาวม ซครัก เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง ลาึน เซอิน. ");
INSERT INTO lcp_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","โอก เน่อึม ลาึน เซอิน เซ โฮว ยุฮ แม ไคะ อาวต แตะ นึง โด่ฟะคา. ");
INSERT INTO lcp_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","โอก เน่อึม นึง โด่ฟะคา เซ, ยุฮ แม ไคะ อาวต แตะ นึง อาลุต. ");
INSERT INTO lcp_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","โอก เน่อึม อาลุต เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง นาตี เรฟีดิ่ม. นา เซ ไก โตว รอาวม นึง ละ ซ โฮลฮ ปุย ญุ. ");
INSERT INTO lcp_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ฟวยจ โอก อื ฮา เรฟีดิ่ม เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง ลาึน ซีไน. ");
INSERT INTO lcp_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ฟวยจ โอก อื ฮา ลาึน ซีไน เซ, โฮว ยุฮ แม ไคะ ยุฮ แตะ นึง คิปโรต ฮัตทาอาวา. ");
INSERT INTO lcp_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ฟวยจ โอก อื ฮา คิปโรต ฮัตทาอาวา เซ, โฮว ยุฮ แม ไคะ ยุฮ แตะ นึง ฮาเซโรต. ");
INSERT INTO lcp_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ฟวยจ โอก อื ฮา ฮาเซโรต เซ, โฮว ยุฮ แม ไคะ ยุฮ แตะ นึง ริตทมา. ");
INSERT INTO lcp_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ฟวยจ โอก อื ฮา ริตทมา เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง ริมโมนเปเรต. ");
INSERT INTO lcp_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ฟวยจ โอก อื ฮา ริมโมนเปเรต เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง ลิปนา. ");
INSERT INTO lcp_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ฟวยจ โอก อื ฮา ลิปนา เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง ริตซา. ");
INSERT INTO lcp_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ฟวยจ โอก อื ฮา ริตซา เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง เคเฮลาทา. ");
INSERT INTO lcp_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","โอก เน่อึม เคเฮลาทา เซ, โฮว ยุฮ แม ไคะ อาวต แตะ นึง บลาวง เชเฟอ. ");
INSERT INTO lcp_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","โอก เน่อึม เชเฟอ เซ, โฮว ยุฮ แม ไคะ นึง ฮาราด่า. ");
INSERT INTO lcp_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","โอก เน่อึม ฮาราด่า เซ, โฮว ยุฮ แม ไคะ นึง มักเฮโลต. ");
INSERT INTO lcp_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","โอก เน่อึม มักเฮโลต เซ, โฮว ยุฮ แม ไคะ นึง ทาฮัต. ");
INSERT INTO lcp_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","โอก เน่อึม ทาฮัต เซ, โฮว ยุฮ แม ไคะ นึง เทรา. ");
INSERT INTO lcp_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","โอก เน่อึม เทรา เซ, โฮว ยุฮ แม ไคะ นึง มิทะคา. ");
INSERT INTO lcp_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","โอก เน่อึม มิทะคา เซ, โฮว ยุฮ แม ไคะ นึง ฮัตชะโมนา. ");
INSERT INTO lcp_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","โอก เน่อึม ฮัตชะโมนา เซ, โฮว ยุฮ แม ไคะ นึง โมเซโรต. ");
INSERT INTO lcp_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","โอก เน่อึม โมเซโรต เซ, โฮว ยุฮ แม ไคะ นึง เบ่เนยาอะคัน. ");
INSERT INTO lcp_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","โอก เน่อึม เบ่เนยาอะคัน เซ, โฮว ยุฮ แม ไคะ นึง โฮฮักกิตกัต. ");
INSERT INTO lcp_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","โอก เน่อึม โฮฮักกิตกัต เซ, โฮว ยุฮ แม ไคะ นึง โยตบ่าทา. ");
INSERT INTO lcp_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","โอก เน่อึม โยตบ่าทา เซ, โฮว ยุฮ แม ไคะ นึง อัปโรนา. ");
INSERT INTO lcp_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","โอก เน่อึม อัปโรนา เซ, โฮว ยุฮ แม ไคะ นึง เอซิโอน เกเบ่อ. ");
INSERT INTO lcp_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","โอก เน่อึม เอซิโอน เกเบ่อ เซ, โฮว ยุฮ แม ไคะ นึง ลาึน ซิน (มัฮ นึง ย่วง คาเด่ต.) ");
INSERT INTO lcp_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","โอก เน่อึม นึง ย่วง คาเด่ต เซ, โฮว ยุฮ แม ไคะ นึง บลาวง โฮ, เฆียง เมือง เอโด่ม. ");
INSERT INTO lcp_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","อาโรน ป มัฮ ซตุ เซ โฮว ฮาวก บลาวง โฮ ตัม ลปุง ซตอก พะจาว อาึง ละ แตะ. เญือม เซ อาโรน ลอต ยุม นึง บลาวง เซ. เญือม เซ เอีจ ไก รปาวน เนอึม ฟวยจ โอก โม อิซราเอน ฮา เมือง อียิป เซ. ปุก ฮาวก เคิ พอน ติ ซาวม. ");
INSERT INTO lcp_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","เญือม ยุม อาโรน นึง บลาวง โฮ เซ, อาญุ อื ไก ติ รอย ไม่ ง่า โรฮ ลอวย เนอึม. ");
INSERT INTO lcp_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","เญือม เซ กซัต เมือง อารัต ป อาวต นึง ลาึน เนเกป นึง เมือง คะนาอัน เซ ฮมอง อัฮ ปุย โม อิซราเอน เอีจ ฮอยจ ซดิ โบ นา ก อาวต แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","โม อิซราเอน โอก แม เน่อึม นึง บลาวง โฮ เซ, โฮว ยุฮ แม ไคะ นึง ซันโมนา. ");
INSERT INTO lcp_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","โอก เน่อึม นึง ซันโมนา เซ. โฮว ยุฮ แม ไคะ นึง ปูโนน. ");
INSERT INTO lcp_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","โอก เน่อึม นึง ปูโนน เซ, โฮว ยุฮ แม ไคะ นึง โอโบ่ต. ");
INSERT INTO lcp_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","โอก เน่อึม นึง โอโบ่ต เซ, โฮว ยุฮ แม ไคะ นึง เบือง ย่วง อาบ่าริม ป อาวต ไน เคต เมือง โมอัป. ");
INSERT INTO lcp_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","โอก เน่อึม นึง อาบ่าริม เซ, โฮว ยุฮ แม ไคะ นึง ดี่โบ่น กาต. ");
INSERT INTO lcp_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","โอก เน่อึม นึง ดี่โบ่น กาต เซ, โฮว ยุฮ แม ไคะ นึง อันโมน ดิ่ปลาทาอิม. ");
INSERT INTO lcp_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","โอก เน่อึม อันโมน ดิ่ปลาทาอิม เซ, โฮว ยุฮ แม ไคะ นึง บลาวง อาบ่าริม ซดิ ไม่ บลาวง เนโบ่. ");
INSERT INTO lcp_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","โอก เน่อึม นึง บลาวง อาบ่าริม เซ, โฮว ยุฮ แม ไคะ นึง ลโลวง โมอัป เฆียง โกลง จอแด่น รเตือป เมือง เยรีโค. ");
INSERT INTO lcp_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","โม เซ ยุฮ ไคะ อาวต แตะ นึง โบ โกลง จอแด่น เซ, เน่อึม นึง ย่วง เบ่ตเยชิโมต ฮอยจ ละ ย่วง เอเบ่น ชิตทิม นึง ลโลวง เวือฮ เมือง โมอัป เซ. ");
INSERT INTO lcp_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","เญือม อาวต ลั่ง ไอ โมเซ นึง ลโลวง โมอัป เฆียง โกลง จอแด่น นึง รเตือป เมือง เยรีโค เซ, พะจาว ดวน อื อัฮ เฮี ละ โม อิซราเอน, ");
INSERT INTO lcp_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“เญือม ซ เตือง เปอะ โกลง จอแด่น ฮอยจ ละ เมือง คะนาอัน เซ, ");
INSERT INTO lcp_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ไมจ เปอะ โครฮ ปุย โตะ เมือง เซ เกือฮ โอก เตือง โอยจ อื. ไมจ โรฮ เปอะ ยุฮ ไลจ ไม่ ฮุป แกะ ซลัก ปุย ไม่ ฮุน แตม ปุย เตือง โอยจ อื, เตือง คัน ทไว ป ไก นึง นาตี ฮลาวง ยุฮ อื เตือง โอยจ อื. ");
INSERT INTO lcp_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ไมจ เปอะ เลียก อาวต นึง ปลัฮเตะ นา เซ ละ ซ ยุฮ เปอะ เญือะ ย่วง บั่นเมือง ยุฮ เปอะ นึง, ไม่ แปน อื ปลัฮเตะ ยุฮ เปอะ, นึง มัฮ อื ปลัฮเตะ ป เกือฮ อาึ ละ เปอะ. ");
INSERT INTO lcp_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ไมจ เปอะ รฆุ ปลัฮเตะ ละ ปุย ตัม เจอ อื โครยญ เจอ อื, ฟวยจ เซ เกือฮ โจก เบ่อ นึง อื. ลัง นา ออฮ อื ละ ปุย ออฮ, ปุย เซ ซ โฮลฮ ไอฮ นา เซ. ป มัฮ เจอ โฮวน ปุย นึง อื ไมจ อื โฮลฮ ปลัฮเตะ เวือฮ, โม เจอ ป รมัฮ ปุย นึง อื ไมจ อื โฮลฮ ปลัฮเตะ ซไกป ตัม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ดัฮ โมเปะ โอ โครฮ ปุย เมือง เซ เกือฮ โอก เตือง โอยจ อื, เมาะ ป โฮฮ ลั่ง อื เซ ซ ยุฮ ป กอยจ ป ราวม ละ โม เปะ. ซ แปน เอิน ตอก ครัม โฆยฮ ไง่ เปอะ ไม่ กัต ป บวก พราวก เปอะ ไม่ ซ ตอซู อื ไม่ เปอะ ฆาื อื. ");
INSERT INTO lcp_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","ดัฮ เปอะ โอ โครฮ เกือฮ โอก โฮ, อาึ ซ ยุฮ ไลจ ไม่ โม เปะ ตอก ตะ แตะ ยุฮ ไลจ ไม่ ปุย โม เซ โรฮ,” อัฮ เซ พะจาว. ");
INSERT INTO lcp_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“ไมจ เปอะ อัฮ ละ โม อิซราเอน ตอก เฮี, เญือม เอีจ เลียก เปอะ นึง เมือง คะนาอัน เซ, ป มัฮ เคต ปลัฮเตะ ป อาวต รวิต เปอะ ซ มัฮ ตอก เฮี. ");
INSERT INTO lcp_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","ลวง ลั่กเซฮ อื มัฮ เน่อึม ลาึน ซิน โฮว ตัม เฆียง ปะเทต เอโด่ม, เน่อึม นึง ลอยจ ปลัฮ รอาวม ยุม ลวง ลั่ก โอก ซเงะ. ");
INSERT INTO lcp_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ฟวยจ เซ โฮว รวอง แม ลวง ลั่กเซฮ ตัม คระ เงียก อาครัปบิ่ม เซ. โฮว เตือง นึง ลาึน ซิน เซ, โฮว ลอยจ นึง ลวง ฆรึม ย่วง คาเด่ต บ่าเนีย, โฮว แม ฮอยจ นึง ฮาซารัตด่า, โฮว แม ฮอยจ นึง อัตโมน. ");
INSERT INTO lcp_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ฟวยจ เซ โฮว รวอง แม เน่อึม อัตโมน เซ ฮอยจ นึง โกลง เมือง อียิป, โฮว ลอยจ นึง ทะเล ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","“ม่าื เตะ ลวง ลั่ก เลียก ซเงะ นึง อื มัฮ เอิน ทะเล ระ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","“ม่าื เตะ ลวง ลั่กล่าวง, มัฮ โรฮ โฮว เน่อึม นึง ทะเล ระ เซ, โฮว ซื ฮอยจ นึง บลาวง โฮ. ");
INSERT INTO lcp_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","เน่อึม นึง บลาวง โฮ เซ, โฮว ฮอยจ นึง เงียก ฮามัต, โฮว แม ฮอยจ นึง ย่วง เซดั่ต, ");
INSERT INTO lcp_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","โฮว แม ฮอยจ นึง นาตี ซิโฟรน. โฮว ลอยจ นึง ย่วง ฮาซาเรนัน, เซ มัฮ ม่าื เตะ ลวง ก ล่าวง นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","“ม่าื เตะ ลวง ลั่ก โอก ซเงะ นึง อื, มัฮ โฮว เน่อึม ย่วง ฮาซาเรนัน เซ ฮอยจ นึง ย่วง เชฟัม. ");
INSERT INTO lcp_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ฟวยจ เซ โฮว แม ลวง ลั่กเซฮ ฮอยจ นึง ย่วง ริปลา ปุก ลวง ลั่ก โอก ซเงะ ละ เมือง อายิน, โฮว แม ฮอยจ นึง บลาวง ลั่ก โอก ซเงะ ละ ปลัฮ รอาวม กาลิลี, ");
INSERT INTO lcp_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","โฮว แม ลวง ลั่กเซฮ โฮว ตัม โกลง จอแด่น โฮว ลอยจ นึง ปลัฮ รอาวม ยุม, มัฮ ตอก เซ ม่าื เตะ ยุฮ เปอะ เตือง ปาวน ลวง อื,” อัฮ เซ ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ไอ โมเซ รโฮงะ อื ละ โม อิซราเอน ตอก เฮี, “มัฮ เมาะ เซ ปลัฮเตะ ป ซันญา พะจาว ซ เกือฮ แตะ แปน คอง โม เปะ เซ, ละ ซ โฮลฮ เปอะ โจก เบ่อ อื ตา ซไตม เจอ ไม่ บลัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ป มัฮ เจอ รูเบ่น ไม่ เจอ กาต ไม่ เจอ มะนาเซ ตา บลัฮ เจอ, ป อาวต ลวง ลั่ก โอก ซเงะ เซ, เอีจ โฮลฮ รัป ปลัฮเตะ รโตง แตะ ตัม เจอ ตัม ซฆลาวม แตะ โครยญ โฆะ อื. ");
INSERT INTO lcp_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ปุย ตา ลอา เจอ ไม่ บลัฮ เซ, มัฮ ป อาวต บลัฮ โกลง จอแด่น ลวง ลั่ก โอก ซเงะ ปุก รเตือป เมือง เยรีโค,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","เอเลอาซา ป มัฮ ซตุ เซ, ไม่ โยชูวา กวน นูน เซ, ซ แปน ป เรอึม รฆุ ปลัฮเตะ ละ ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","ไมจ โรฮ เปอะ เกือฮ โม ฮัวนา เจอ เซ ติ เจอ ติ ปุย เรอึม รฆุ ไม่ อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","มอยฮ โม ฮัวนา เจอ ป ซ เรอึม เซ มัฮ ตอก เฮี. คาเลป กวน เยฟูเน มัฮ ฮัวนา เจอ ยูด่า. ");
INSERT INTO lcp_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","เชมูเอน กวน อัมมีฮุต มัฮ ฮัวนา เจอ ซิเมโอน. ");
INSERT INTO lcp_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","เอลีดั่ต กวน คิตโลน มัฮ ฮัวนา เจอ เบ่นยามิน. ");
INSERT INTO lcp_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","บุ่กคี กวน โยกลี มัฮ ฮัวนา เจอ ด่าน. ");
INSERT INTO lcp_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ฮันนิเอน กวน เอโฟต มัฮ ฮัวนา เจอ มะนาเซ. ");
INSERT INTO lcp_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","เคมูเอน กวน ชิปทัน มัฮ ฮัวนา เจอ เอฟราอิม. ");
INSERT INTO lcp_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","เอลีซาฟัน กวน ปันนัก มัฮ ฮัวนา เจอ เซบู่ลุน. ");
INSERT INTO lcp_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ปันทีเอน กวน อัตซัน มัฮ ฮัวนา เจอ อิตซาคา. ");
INSERT INTO lcp_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","อาฮิฮุต กวน เชโลมี มัฮ ฮัวนา เจอ อาเชอ. ");
INSERT INTO lcp_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ไม่ เปด่าเฮน กวน อัมมีฮุต มัฮ ฮัวนา เจอ นัปทาลี. อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ปุย โม เซ มัฮ ป เลือก พะจาว ละ ซ เกือฮ อื แปน ป เรอึม รฆุ ปลัฮเตะ คะนาอัน เซ ละ โม อิซราเอน. ");
INSERT INTO lcp_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","เญือม อาวต ไอ โมเซ นึง ลโลวง โมอัป เฆียง โกลง จอแด่น รเตือป เมือง เยรีโค เซ, พะจาว อัฮ เฮี ละ อื, ");
INSERT INTO lcp_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“ไมจ เปอะ อัฮ ละ โม อิซราเอน เซ, เกือฮ โรฮ เมก ย่วง ละ โม เลวี เซ ง่อน, ละ ซ แปน อื ย่วง อาวต อื, ไม่ เกือฮ โรฮ อื ลโลวง ไก ไรป ละ อื ละ ซ เลียง อื ซัตซิง ยุฮ แตะ นึง. ย่วง โม เซ ซ ไมจ อื เกือฮ โอก เน่อึม นึง นาตี ป โฮลฮ เจอ ไฮญ นึง อื. ");
INSERT INTO lcp_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","ย่วง โม เซ ซ แปน ย่วง อาวต โม เลวี เซ, ละ ซ ไก เญือะ อาวต อื นึง, ไม่ ซ โฮลฮ อื เลียง โมวก ไม่ ซัตซิง ไฮญ ยุฮ แตะ นึง เตือง โอยจ อื, นึง ลโลวง แควน ย่วง อาวต อื เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","ป มัฮ ลโลวง ไก ไรป เซ, มัฮ เมีญ เน่อึม เคียง ก พริ ฆรุง ย่วง เซ โฮว เมาะ พอน รอย เมต รวิต อื. ");
INSERT INTO lcp_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","เญือม เอีจ แนต อื ตอก เซ นาตี ย่วง เซ ซ ไก ฆาื อื ติ เปือน เมต รวิต อื เตือง ปาวน ลวง อื. ซ แปน โรฮ ก เลียง อื ซัตซิง ยุฮ แตะ นึง. เญือม เซ ย่วง เซ ซ แปน ป อาวต บั่กบ่วน อื. ");
INSERT INTO lcp_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","ไมจ เปอะ เกือฮ ย่วง ละ โม เลวี เซ แลฮ ย่วง, ละ ซ แปน อื ก ฮอยจ เปิง โม ป โคะ ยุฮ ยุม ไม่ ปุย. โนก ฮา เซ ไมจ แม เปอะ เมก ย่วง ละ โม เลวี รปาวน โรฮ ลอา ย่วง. ");
INSERT INTO lcp_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ย่วง เกือฮ เปอะ ละ อื เซ รโจะ แปน รปาวน โรฮ ซเตะ ย่วง ไม่ ลโลวง ไก ไรป นึง อื โรฮ. ");
INSERT INTO lcp_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","ย่วง รฆุ เปอะ ละ โม เลวี เซ, ไมจ เปอะ รฆุ ละ อื ตัม เมาะ เวือฮ เมาะ ซไกป นาตี โฮลฮ โม อิซราเอน เซ. เจอ ป โฮลฮ นาตี เวือฮ ไมจ เปอะ เกือฮ เจอ เซ รฆุ ละ อื โฮวน ย่วง. เจอ ป ซไกป นาตี โฮลฮ ไมจ โรฮ เปอะ เกือฮ เจอ เซ รฆุ ละ อื ตัม เมาะ ซไกป อื เซ โรฮ,” อัฮ เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","พะจาว อัฮ เฮี ละ ไอ โมเซ, ");
INSERT INTO lcp_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“ไมจ เปอะ อัฮ ละ โม อิซราเอน เซ ตอก เฮี, เญือม เตือง โม เปะ โกลง จอแด่น ฮอยจ ละ เมือง คะนาอัน เซ, ");
INSERT INTO lcp_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","ไมจ เปอะ เลือก เมือง ละ ซ เกือฮ เปอะ แปน เมือง ตอ ปุย เปิง. เญือม เซ ดัฮ ไก ป โคะ ยุฮ ยุม ไม่ ปุย เตือง โอ อื โฆง ยุฮ ฮู, ซ โฮลฮ ฮอยจ เปิง เมือง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","เกือฮ โรฮ เมือง เซ แปน ก อาวต โม ป โคะ ยุฮ ยุม ไม่ ปุย เซ นึง, ละ โอ ซ เกือฮ โม คระ เฌือต ป ยุม เซ ยุฮ โรฮ ยุม ไม่ โกะ อื กา เฆียง โฮลฮ ปุย รเตีฮ ซองนา โม ลัปซด่อน. ");
INSERT INTO lcp_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","ไมจ เปอะ เลือก เมือง แลฮ เมือง. ");
INSERT INTO lcp_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","นึง บลัฮ โกลง จอแด่น ลวง ลั่ก โอก ซเงะ เซ ลอวย เมือง, นึง ปลัฮเตะ คะนาอัน เซ ลอวย เมือง. ");
INSERT INTO lcp_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","เมือง โม เซ ซ แปน เมือง โฮว เปิง โม อิซราเอน, ไม่ ปุย ตังเมือง ป อาวต ลลาึง อื เซ. โม ป ยุฮ ยุม ไม่ ปุย เตือง โอ อื มัฮ โฆง อื ยุฮ เซ, ปัง มัฮ ปุย ออฮ ปุย เอีฮ ญุ่ก ซ โฮลฮ โฮว เปิง เมือง โม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","18","“ปัง มัฮ ตอก ออฮ ตอก เอีฮ ญุ่ก, เมาะ ป โกว ไร, ป โกว ซโมะ, ป โกว โคะ ละ ยุฮ แตะ ยุม ไม่ ปุย, เอีจ มัฮ ป โฆง ยุฮ ยุม ไม่ ปุย. ปุย เซ ไมจ อื ลอก ตุต ฮอยจ ละ ยุม แตะ. ");
INSERT INTO lcp_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ป มัฮ เอียกปุ คระ เฌือต ป ยุม เซ, ไมจ อื ซาวป ยุฮ ยุม ไม่ ป ยุฮ ยุม ไม่ อื เซ. ยุ อื เญือม ออฮ เญือม เอีฮ ญุ่ก, ไมจ อื ยุฮ ยุม ไม่ เญือม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","21","ดัฮ ไก ป บวก ปุย ปอ ยุม อื ญุ่ก, ป แล่น ปุย นึง โอเอีฮ ปอ ยุม อื ญุ่ก, ป จุต ปุย ปอ ยุม อื ฆาื เกละ อื ยุ ญุ่ก, ปุย ตอก เซ เอีจ มัฮ ป โฆง ยุฮ ยุม ไม่ ปุย. ปุย เซ ซ ไมจ โรฮ ปุย ยุฮ ยุม ไม่ โกะ อื โรฮ. ป มัฮ เอียกปุ คระ เฌือต ป ยุม เซ ไมจ อื ซาวป ยุฮ ยุม ไม่ ป ยุฮ ยุม ไม่ อื เซ. ยุ อื เญือม ออฮ ไมจ อื ยุฮ ยุม ไม่ เญือม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ดัฮ ไก ป โคะ บวก โคะ วัต ปุ แตะ ปอ ยุม อื เตือง โอ อื ไก กัม เวน ไม่ ปุ แตะ, ");
INSERT INTO lcp_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ปัง มัฮ ดุฮ อื ยุฮ ซโมะ ราว ปุย โคะ ลอก อื ปุย ปอ ยุม เอิน อื นึง โอ แตะ ยุ โอ แตะ ฮมอง, เตือง โอ อื ตะ ยุฮ ตอก เซ นึง โอ อื มัฮ ป เกละยุ ปุ แตะ ไม่ ปุย เซ ญุ่ก, ");
INSERT INTO lcp_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ละ โม ป ยุฮ ตอก เซ นึง อื, เญือม ตัตซิน โม ลัปซด่อน อื เซ, ปุย ปังเมอ ไมจ อื เกือฮ ป โคะ ยุฮ ยุม ไม่ ปุย เซ โปน ฮา ตุต แตะ, ไมจ โตว อื พาวม ไม่ คระ เฌือต ป ยุม เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ปุย โฮวน เซ ไมจ อื เรอึม ปุย โคะ ยุฮ ยุม ไม่ ปุย เซ, เกือฮ โปน ฮา กัน โรก คระ เฌือต ป ยุม เซ เวน ละ อื. ซ ตาว ปุย เซ แม อาวต นึง เมือง ก เปิง อื เญือม ตอ โรง อื เซ. ปุย เซ ไมจ อื อาวต นา เซ ฮอยจ ละ ยุม ป มัฮ ฮัวนา ซตุ ป ไก ลออยฮ ซัมคัน ยุฮ พะจาว นึง เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","ป ยุฮ ยุม ไม่ ปุย เซ, ดัฮ ตอ ฮา เมือง โฮว เปิง แตะ เซ โฮ, ");
INSERT INTO lcp_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ดัฮ คระ เฌือต ป ยุม เซ รโตฮ ยุ ปุย เซ, ไม่ ยุฮ อื ยุม ไม่ อื นึง โรก แตะ เวน ละ อื, ป มัฮ คระ เฌือต ป ยุม เซ ซ ไก โตว โรฮ พิต นึง โรก แตะ เวน ละ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ป โคะ ยุฮ ยุม ไม่ ปุย เซ ไมจ อื อาวต นึง เมือง ตอ แตะ เปิง เซ, ฮอยจ ละ ยุม ป มัฮ ฮัวนา ซตุ เซ. เญือม เอีจ ฟวยจ ยุม ฮัวนา ซตุ เซ ซ โฮลฮ โรฮ เอีญ นึง เมือง อาวต โกะ แตะ ไอฮ. ");
INSERT INTO lcp_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“โอเอีฮ ตอก เฮี มัฮ โกตไม ไมจ เปอะ ยุฮ ลอป ฮอยจ เฆียง เฮี โครยญ เจน ปุย. ");
INSERT INTO lcp_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","ดัฮ ไก ป ฟอง ปุย นึง อัฮ อื ปุย เซ เอีจ ยุฮ ยุม ไม่ ปุย ไฮญ เญอ, ไมจ อื ไก พีญัน ลอา ลอวย ปุย เดอึม ลักทัน อื เซ ซ ปอ ยุฮ ปุย ยุม ไม่ ปุย เซ. ดัฮ ไก พีญัน ติ โน่ง ปังเมอ โอ ปอ เกียฮ ยุฮ ปุย ยุม ไม่ อื. ");
INSERT INTO lcp_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","ดัฮ ป ยุฮ ยุม ไม่ ปุย เซ ปัว โตฮ ติ แตะ นึง มาื, ไมจ โตว ปุย รัป งวยฮ โตฮ อื ติ แตะ เซ, นึง เอีจ มัฮ ปุย เซ ป ไก ตุต ยุฮ ฮอยจ ละ ยุม แตะ. ปุย ตอก เซ เอีจ ไมจ เนอึม ปุย ยุฮ แปฮ ยุม ไม่. ");
INSERT INTO lcp_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","ปัง มัฮ งวยฮ โตฮ โม ป ฮอยจ เปิง เมือง ปุย เซ ติ แตะ นึง, ฆาื ฆวต เอีญ อื นึง เมือง โกะ แตะ กา เฆียง ยุม ฮัวนา ซตุ เซ ญุ่ก, ไมจ โตว โรฮ รัป ละ อื. ");
INSERT INTO lcp_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","มัฮ ตอก เซ ตอก โอ โม เปะ ซ เกือฮ ปลัฮเตะ อาวต เปอะ แปน ป รแอม ไล เยอ, มัฮ ฆาื ยุฮ ปุย ยุม ไม่ ปุ แตะ ป แปน ปลัฮเตะ เซ ป รแอม ฆาื อื. ไก โตว คระ ไฮญ ละ ซ เกือฮ แตะ ปลัฮเตะ ป เอีจ ยุฮ ปุย ยุม ไม่ ปุ แตะ นึง เซ แม แปน แม ปลัฮเตะ ซง่ะ ไล, โนก ฮา ซ ยุฮ โรฮ ปุย ยุม ไม่ ป ยุฮ ยุม ไม่ ปุย เซ. ");
INSERT INTO lcp_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ปุ ยุฮ โอเอีฮ ตอก ซ เกือฮ เปอะ ปลัฮเต