﻿USE sofia;
DROP TABLE IF EXISTS sofia.lcm_vpl;
CREATE TABLE lcm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES lcm_vpl WRITE;
INSERT INTO lcm_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Aino luai God kata asinong na mete kuku na kuli rina. ");
INSERT INTO lcm_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Katapo kovek luai ta bil e kuli rina. Keve bil aongos kitapo kovek i pukun. Vong lava katapo pakut a keve bil aongos. Malanganto i God katapo ngoi angpok palau e kuli laman. ");
INSERT INTO lcm_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Au na God kala antok, “Malangas, ku tu aserei.” Na kala malangas. ");
INSERT INTO lcm_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Na God kala arai ta malangas vola roron na kala posong angtaliungai ani malangas pelek a vong. ");
INSERT INTO lcm_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Na God kala atuk a malangas ang ta tenei ias, na kala atuk a vong ang ta tenei vong. Au, vong kala serei le na kala tenei vauk pok. Asukang na ainoai i taun kala pasal suai. ");
INSERT INTO lcm_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Au na God kala antok, “Laman, ku tapagal ane si pongua na palpal. Mang palpal ane pangkul na mang palpal ane kevkev. Nei liuan i ngono palpal ke, ka atogon ta pangau si pagal ani ngono laman ke.” Au na kala asukang. ");
INSERT INTO lcm_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Na God kala atuk a pangau ang ta kuku. Au, vong kala serei le na kala tenei vauk pok. Asukang na vapongua i taun kala pasal suai. ");
INSERT INTO lcm_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Au, na God kala antok, “Laman ang e kevkev i mete kuku, ku ago kuvul si sikei a oring na numai kuli roe, ku tu aserei.” Na kala asukang. ");
INSERT INTO lcm_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Na God kala atuk a laman po ago kuvul ang ta nei laman, na kala atuk a ring kolo ang ta kuli roe. God kala arai ania ta vola roron. ");
INSERT INTO lcm_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Na God kala antok, “Kuli roe, ku apolokai ani mamain ta sukal atogon katui na mamain ta ei atogon uai na katui neiria ani mi uai asereai ani manik imi akorong ta matan uai.” Na kala asukang. ");
INSERT INTO lcm_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ri sukal angpetpetekai na ri ei angpetpetekai kila polok kuli vunep. Kita uai asereai akorong ani kari keve mamain ta uai. Keve katui iria kita apolokai akorong pok ani keve tukulai iria. Na God kala arai ania ta vola roron. ");
INSERT INTO lcm_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Au, vong kala serei le na kala tenei vauk pok. Asukang na vapotol i taun kala pasal suai. ");
INSERT INTO lcm_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Na God kala antok, “Keve malangas, mi tu aserei e mete kuku ani mi akalit ta angpetpetekai i tenei ias ve tenei vong. Keve malangas ke kapa ki akanangai ani angpetpetekai i keve taun na keve ulen na keve matas. ");
INSERT INTO lcm_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ani keve malangas ke e metekuku ki mang amalangasai ani kuli rina aongos.” Na kala asukang. ");
INSERT INTO lcm_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God kata asinong a pongua na malangas lava. Ri makarap ve ulen. Makarap vo tavirimok ang, ani nia ka saupai ani tenei ias, na ulen ani ka saupai ani tenei vong. Kata asinong kapa ri kalto. ");
INSERT INTO lcm_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God kata asinong a keve malangas ang asi mang ani kuli rina. ");
INSERT INTO lcm_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ani ki saupai ani tenei ias na tenei vong, na ki pagal akipai ani malangas na vong. Na God kala arai ania ta vola roron. ");
INSERT INTO lcm_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Au, vong kala serei le na kala tenei vauk pok. Asukang na vapuat i taun kala pasal suai. ");
INSERT INTO lcm_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Na God kala antok, “Nei laman, mi duk ta mamain ta manmanik to. Na ri mani, mi ngoi angpok neite kuku e pangkul i kuli roe. ");
INSERT INTO lcm_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Asukang na God kala asinong ri ie lava kuvul ve mamain ta manmanik aongos kipo to na kipo duk na kipo sang angpok nei laman val si kari keve laulauan angpetpetekai. Na ani ri mani vap po ngoi korong ang, asukang palau val kari keve laulauan angpetpetekai. Na God kala arai ania ta vola roron. ");
INSERT INTO lcm_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God kala poso atauia iria ta mengen asukang ke, “Mi apitus na mi serei aduk si kami tataot ani nei laman ka duk tatami. Ri mani, mi kun apolokai pok animi ani mi duk si kuli rina ke.” ");
INSERT INTO lcm_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Au, vong kala serei le na kala tenei vauk pok. Asukang na vapalpalima i taun kala pasal suai. ");
INSERT INTO lcm_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Na God kala antok, “Ri manmanik anglok i kuli roe, mi serei aduk e kuli rina, na mi apitus asereai pok animi si kami keve kuvkuvulan angpetpetekai. Ri vongo asi aiveven, ri manmanik palis e kuli roe na ri kei i nei uten, mi apitus angkokoai singimi pok. Na kala asukang. ");
INSERT INTO lcm_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God kata asinong a ri kei, ri vongo asi aiveven e rina na ri manmanik po palis e kuli roe. Kata asereai aniria ani ki apolokai pok aniria akorong. Na God kala arai ta vola roron. ");
INSERT INTO lcm_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Na God kala antok, “Tara asinong a ri vap si lilinau na kankanuai ira. Tara alis iria ta kitmat si saupai aongos ani mamain ta ien i nei laman na mamain ta mani i nei pangau ke. Ki saupai kapa ani mamain ta vongo ipo aiveven na ani kuli rina aongos ke na ki saupai kapa ani mamain ta manmanik ipo palis na pasal anglok kuli rina. ");
INSERT INTO lcm_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Asukang vanang na God kata asinong ri vap si kankanuai ina akorong pok. Io, si kankanuai ina pok God kata asinong ri vap. Kata asinong ri vap ani ki tauan na aina. ");
INSERT INTO lcm_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Na God kala poso atauia iria ta mengen asukang ke, “Mi apolokai pok animi. Kami inatus ki aduk na kuli rina ke na ki saupai ania. Mi saupai aongos ani ri ien nei laman na ri mani nei pangau na ani ri manmanik aongos kipo ago kuli roe. ");
INSERT INTO lcm_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Na God kala antok, “Nalapo alis vang imi ta ri sukal aongos i kuli rina vopo atogon katui kuvul ve ri ei aongos vopo uai ang. Kilapo kakami ani mi angan singiria. ");
INSERT INTO lcm_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Na ani ri mani i nei pangau na ri manmanik aongos po to kuli vunep, riria kapa ki angan pan na uai i mamain ta ei na uriuri aongos.” Na kala asukang. ");
INSERT INTO lcm_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God kala arai ani keve bil aongos i kana la asinong ang, na vola roron luai. Au, vong kala serei le na kala tenei vauk pok. Asukang na valimalesikei i taun kala pasal suai. ");
INSERT INTO lcm_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Au na God kala akamusai ani asisinong e metekuku na kuli rina tavirimok asip ke. ");
INSERT INTO lcm_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kata akamusai aongos ani kana keve avibisan i asisinong si valimalesikei i taun. Au na si valimalengua i taun kala ausai pelek kana abis. ");
INSERT INTO lcm_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kata poso atauia na taun ang na kala vil agogoai ania. Kata abis ia asukang using si taun ang akorong kata ausai pelek kana avibisan aongos i asisinong. ");
INSERT INTO lcm_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kana na akuskus i sa kata serei si taun ang na God kata asinong na mete kuku na kuli rina. Si taun ang a God, nang nia na IAVE, kata asinong a kuli rina na mete kuku, ");
INSERT INTO lcm_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","katapo kovek i mangsikei a bil i suk polok le kuli vunep, using IAVE parik katapa alis langit lak kuli rina na katapo kovek lak i igenen si itoitonai ani nei roe. ");
INSERT INTO lcm_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Sikei laman katapo uli uv alak le nei roe na kapo vil a vuluk a roe aongos ang pulakai. ");
INSERT INTO lcm_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Na IAVE kala kap roe le kuli vunep na kala pitopito na igenen tatana. Le na kala kui alak kana malu i to ane si isuna i igenen ang na kala serei a igenen atogon to. ");
INSERT INTO lcm_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Aino le, IAVE katala sukal a mangsikei a matang e Eden, si palpal ang a makarap kapo sanglak singina. Na eiang vanang kala asinong a igenen i kana la pitopito ang. ");
INSERT INTO lcm_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","E nei matang ang IAVE kala asereai ani mamain ta ei anglok pulakai aongos. Na kipo keve ei talupus roron luai angkokoai si angan. E nei liuan ina i nei matang ang kala asereai ani pongua na ei. Ei i to, na ei i malangas ani rikek na roron. ");
INSERT INTO lcm_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Katapo atogon a mangsikei a sung katapo saling le Eden na katapo alis laman ani matang ang. Si mang palpal i Eden, sung ang kanlapo tapagal ane si puat a ngakan i laman. ");
INSERT INTO lcm_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Ainoai i sung, kana asan ta Pison. Laman ke kapo saling pulakai nei palpal Avila aongos. Na palpal rina ang kapo duk ta gol roron luai. Eiang kapa kapo atogon rul sain ro na iat roron lik ke onikis. ");
INSERT INTO lcm_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Vapongua i sung, kana asan ta Gion, na kapo saling pulakai nei palpal Kus aongos. ");
INSERT INTO lcm_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Na vapotol i sung kana asan ta Tigiris na kapo saling e ngising i palpal Asur, si palpal ipo sanglak ta makarap. Au na vapuat i sung kana asan ta Euperetes. ");
INSERT INTO lcm_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Au, IAVE kanla asinong a igenen ang e nei matang e Eden ani kan itoitonai ania na ka aiveven ia. ");
INSERT INTO lcm_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Na kala pini ia asukang ke, “Kupo kalakala luai si angan si uai i keve ei aongos i nei matang ke, ");
INSERT INTO lcm_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","sikei napo tubat ua ta ku ago ta angan si ei i malangas ani roron na rikek suke. Napo tubat luai anim, using man ku angan singina, matmat ka kinkos ua.” ");
INSERT INTO lcm_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Na God IAVE kala antok ta, “Pua, parik kapa ro ani tauan ke ka ago papalik. Kapo ro ani naka asinong ta mang anu val nia ani ka papakangai ania. ");
INSERT INTO lcm_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Aino le, IAVE kata pitopito na mamain ta manmanik na ri mani ta roe. Na kala luk iria ane si igenen ang ani kame poso asan aniria. IAVE katapo ago na kapo longong ta saka asan an tauan ke katapo atuk a siksikei i keve manmanik na mani ang tataria, nang nia katalapo kari asan luai. ");
INSERT INTO lcm_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Asukang vanang a tauan ke kata atuk a ri manmanik aongos ipo aiveven na i nei uten na ri mani aongos i nei pangau na kuli roe ta kari keve asan. Sikei katapo kovek i sikei ka ago kuvul ve nia asukang val ta kana papakangai. ");
INSERT INTO lcm_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Asukang na IAVE kala arodot ia ani ka rot mat. Taun kalapo rot, IAVE kala luk suai ani sikei a vuk tuan i vagvag ina na kala pakut pok a makas ang ta sin. ");
INSERT INTO lcm_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Au na ka luk a tuan ang na kala pitopito asereai ani aina tatana. Kala songo le na aina ang na kanla atatung ia si kana tauan. ");
INSERT INTO lcm_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Si vuk taun ang kala arai ani kana aina na kala antok ta, “Pua, kana vang a mangsikei ig akorong! Tuan ina, le si tuan ig. Sin i pukunina, le si sin i pukunig. Io, naka atuk vang kana asan ta aina, using kata serei le si tauan.” ");
INSERT INTO lcm_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Au si oring ke vanang, tauan ka papalek a tamana ve rinana na kan ago kuvul ve kana aina na kilong sikei palau. ");
INSERT INTO lcm_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Si taun ang a ngono angkisnganan ke kilongtapo pukun varas aongos na parik katapa atogon bil si vil amamaila anirilong. ");
INSERT INTO lcm_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nei liuan i keve manmanik aongos i nei uten ang IAVE katala asinong iria, kene katapo nas alava luai aniria. Mangsikei a taun, kene kata tapasuk na kamela antok a aina ang asukang ke, “Ai, iuang! Au si kapo tutuman nang ta God kata tubat akorong imilong asi ago ta angan si mamain ta ei aongos nei matang ke?” ");
INSERT INTO lcm_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Aina ang kala antok ta, “Ai, parik nang. Namemlongpo kalakala si angan si ri ei aongos i nei matang ke. Sikei si ei ang e nei liuan i nei matang ke akorong, God vanang kata tubat imemlong asi ago ta angan an singina. Kata atatai imemlong ta man namemlong angan vo sigil si ei ang, nganlak namemlong mamat.” ");
INSERT INTO lcm_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Na kene kala antok ta, “A pua! Kovek luai. Parik nang milongpa angkoai si mat. ");
INSERT INTO lcm_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kupo nas, God kata mengen asukang nang using kapo malangas ta man milongla angan si ei ang, milongla atogon a nas lava. Milong la serei asukang palau val nia, God akorong. Milongla nas vang a ro na rikek.” ");
INSERT INTO lcm_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Au, aina ke kala longong na kala arai ta Uai ina i ei ke kapo ararai aro na kapo roron asi angan, na man nganing kala angan singina, kala atogon a malangas roron luai. Asukang na kanla ngumut a mang matan uai ina na kala angan iria. Kisngana kapa katapo tung eiang. Au na aina ang kala alis ia na kala kun angan kapa. ");
INSERT INTO lcm_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Na kilongla lomlomon tapalas na kilongla arai kinle ta kilong tapo varas. Asukang na kilong la kikit pan i ei na kilongla susukai ania asi karilong pakut anirilong. ");
INSERT INTO lcm_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Au kalapo livus aliu tenei ngelik na kilongla longong a God IAVE sipo pasal pulakai e nei matang ang. Na kilongla sip sian mumun ania nei liuan i ri ei i nei matang ang. ");
INSERT INTO lcm_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Sikei IAVE kala songo na tauan ang ta, “Au, nei numai kana evoi?” ");
INSERT INTO lcm_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Na tauan ang kala antok, “Nata longong ua sipo pasal pulakai na nala mumun anim. Natapo leng nang using nalapo varas.” ");
INSERT INTO lcm_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","“Iau? Au si kata antok ua ta kupo pukun varas? Sa nang, kutala angan si ei ang nata tubat imilong singina ingko?” ");
INSERT INTO lcm_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Na tauan ang kala antok ta, “Nang a aina ke kuta atatung ia singig, ninia vanang kata luk le na mang matan uai si ei ang na kanla alis iau, na nala kun angan.” ");
INSERT INTO lcm_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Au na God IAVE kala antok a aina ang ta, “Ku antok tapai anig. Sa akorong kupo abis ia asukang ke?” Na aina kala polpol ta, “Nang a kene ang, kata kun kapau anig na nala angan.” ");
INSERT INTO lcm_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Asukang na God IAVE kala antok a kene ang ta, “Le si sa kutala abis ia, kam vilvil akui ka asukang ke: numai papalik, ri vap ki alele na ki mirik anim, nei liuan i mamain ta manmanik. Tutapongai le kana ku palis ta vingam na ku kon mutep i kuli roe ani keve taun aongos tung si ku mat. ");
INSERT INTO lcm_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Na amatung a neikien nei liuan imilong ve aina suke na milong uli angmamaralai angpokpokai animilong. Keve matan tivum ki angmamaralai ve keve matan tivuna i aina suke. Taun kapo tulbonai anim ka komeng a patum, na numai ku kalat a pung i kakina.” ");
INSERT INTO lcm_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Au IAVE kala mengen a aina asukang ke, “Kam vilvil akui ka sang asukang ke. Taun kupo sungsungukan na kalapo sinong kam taun asi ingus, ku nasai ani kui lava. Na ku atogon a vubuk ani kam tauan, na ninia ka uli sausaupai anim.” ");
INSERT INTO lcm_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Na kala tutalang a tauan na kala posong ta, “Numai vanang, kutala longolongai ani kalingana i kam aina, na kula kun angan si ei i kag tubat ang anim, na kuta longogel iau. Asukang vanang na kuli roe ke kala rikek tukulai ina singim. Na ka uli asukang tung si ku mat. Ka meng ua na kui i abis si keve taun asi kam sabonai ani pok singina. ");
INSERT INTO lcm_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Ka duk ta uriuri na ei ve angus rodotan, na ku sili pulakai nei uten lava si gule ta kam pok asi angan. ");
INSERT INTO lcm_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ku kun gese alava vang taun a nei roe asi apolokai ta kam pok akorong. Ku abis alava tung si kuan mat na ku papok ane nei roe. Lomon akit ia ta kuta serei nang le si roe, na numai nang kupo roe. Au na using kapo asukang, taun ku mat kuan papok ane si ring ang kuta serei le singina.” ");
INSERT INTO lcm_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Na tauan ang kala atuk a kisngana ta Eva. Using ninia vanang nganlak ka rinaria i ri vap aongos. ");
INSERT INTO lcm_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Na God IAVE kala luk a kulit i manmanik na kala kavat na ri Adam ve Eva tatana. ");
INSERT INTO lcm_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Na kala antok ta, “Igenen ke kalapo serei val tara. Kalapo nas vang a roron ve rikek. Asukang na ka ago ta angan an si ei i to ang vei nganing kala to asikei luai.” ");
INSERT INTO lcm_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Asukang na God IAVE kala asok suai ania le nei matang ang ani kan abis matang akorong ania si roe ang nang kata serei singina. ");
INSERT INTO lcm_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Au kala kirikai suai ani igenen ang na kala atung a Kerubim e mete takaman i Matang i Eden si palpal ipo sanglak ta makarap. Na kala atung kapa na mangsikei a samele lava ipo visvis. Samele ang katapo ripag na kapo timis angtaliungai val ureurek i kut na kapo tavulit angpok asi tubat ani selen alak ane si ei i to. ");
INSERT INTO lcm_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Au, Adam kala ago ve kisngana na kala sungsungukan. Kala ingus a sikei a nat na kala lomlomonai ta, “Si papakangai si IAVE natala asereai ani nat.” Si oring ang vanang na kala atuk a nat ang ta Kain. ");
INSERT INTO lcm_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Au, emung kala anguan vinga pok an na kala ingus kana vapongua i nat na kala atuk ia ta Abel. Abel kala serei a igenen katakai i aiveven vongo na Kain kata serei a igenen katakai i suksukal. ");
INSERT INTO lcm_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Au si mangsikei a taun Kain kamela serei ta mang keve uai i matang na kamela sula serei si IAVE tatana. ");
INSERT INTO lcm_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Au, Abel kamela kun serei ve kana keve vuk sin vulvuluk i kana keve ainoai i natnat i sipsip, na kala sula serei si IAVE tatana. IAVE kala arai velai maramarak ani alilis ang si Abel sikei kala arai misagai ani anu ang si Kain. ");
INSERT INTO lcm_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Asukang na Kain kala vinga manas luai na nona kala songag ta marala. ");
INSERT INTO lcm_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Taun a IAVE kan arai ania sipo marala asukang ke le na kala sui ia ta, “Au si kupo marala asukang nang marai sa? Marai sa luai na nom kapo asukang? ");
INSERT INTO lcm_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Sa, parik kupa nas ta man ku abis aro nala maramarak anim? Ku aiveven, using man ku abis a sa parik kapa roron, rikek nganlak kame sinong teremai anim e mete kam takaman asi kana kong akit anim. Ku atokngai alava asi kam dual suai ani kitmat ina i rikek ke. ");
INSERT INTO lcm_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Au, mangsikei a taun Kain kala antok a tasina asukang ke, “Me na tarung an ulit tapai nei uten.” Taun kilong anlapo ago nei uten Kain ka tutalang palau na tasina na kala vis punuk ia. ");
INSERT INTO lcm_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Na emung ina IAVE kala sui a Kain ta, “Au Kain, nei a tasim ta Abel evoi?” Na kala antok ta, “Parik napa nas nang. Au si, natame nat nang asi me uli aiveven tasig?” ");
INSERT INTO lcm_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Na IAVE kala antok ta, “Marai sa kuta abis a lau rikek ke? Ku longong! Rangai i tasim kana kapo tang taun iau le kuli roe. ");
INSERT INTO lcm_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Asukang vang na kana naka poso arikek ua na nala kirikai suai anim pelek a roe ke kana kata apanga na nguruna si inum ani rangai ina i tasim, nang kata puka si kungam. Kula siang nei mamaiten asukang ke: ");
INSERT INTO lcm_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Taun ang ku abis a nei roe, ka kovek luai ta bil ka polok. Kula igenen asi pasal angpok palau ani kuli rina ke na ku kovek ta ring akorong si ago atuk.” ");
INSERT INTO lcm_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Au, Kain kala antok a IAVE ta, “Loi, vilvil akui ang nang kupo alis iau tatana kapo tavirimok luai anig si paus. ");
INSERT INTO lcm_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Pua napo mamakus using kana kulapo lu suai anig le si oring ke, na nala tav ago vang e ngerem. Io, kapo rikek luai using nala uli pa angpok pulakai na nala kovek ta ring asi kag ago atuk. Nala asukang luai vang ta igenen ago angvolai kovek i ring akorong si ago. Pua na man nganing a sikei kala tul bonai anig kala raung korong luai anig.” ");
INSERT INTO lcm_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Na IAVE kala antok ia, “Parik. Parik kapa angkoai si ka asukang. Man ta sikei kala raung korong a Kain, nganlak a vilvil akui ang ninia ka paus ia ka amatan limalengua asoliu ani kakam ta vilvil akui.” Au na IAVE kala amatung a mangsikei a akanangai si Kain ani man a sikei kala angruduai pulakai ve nia ki tav angkoai si raung korong ania. ");
INSERT INTO lcm_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Asukang vanang na Kain kala papelek suai ani matana i God na kanla ago e palpal Nod si mang pulis i Eden si ring ipo sanglak ta makarap. ");
INSERT INTO lcm_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Au Kain kala ago ve kana aina na kala atogon sungsungukan na kala ingus a sikei a nat. Na Kain kala atuk ia ta Enok. Si taun ang Kain katapo abis a mangsikei a rina na kala kun atuk ania using kana nat ta Enok. ");
INSERT INTO lcm_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enok kata asereai ani Irad. Na Irad kata asereai ani Meuiael. Na Meuiael kata asereai ani Metusael na Metusael kata asereai ani Lamek. ");
INSERT INTO lcm_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Au Lamek kala osongon kana pongua na aina. Kana ainoai i aina kana asan ta Ada, na vapongua kana asan ta Sila. ");
INSERT INTO lcm_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Na Ada kala ingus a Iabel. Au Iabel vanang kapo tamaria i mamain ta vap ipo pasal angpok si keve rina pulakai sipo aiveven vongo. ");
INSERT INTO lcm_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Na tasina i Iabel ta Iubal. Au Iubal vanang kapo tamaria i mamain ta vap ipo tiring na kuikui. ");
INSERT INTO lcm_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Na kana nat a Sila ta Tubal-Kain. Ninia na katakai i abis ta keve aen anglok. Kata abis asereai ani mamain ta bil ipo tangai. Na tauna i Tubal-Kain ta Nama. ");
INSERT INTO lcm_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Na Lamek kala antok a ngono kisngana ta, “Kag ngono aina, ri Ada ve Sila, milong longong aro kag mengen. Natala raung a mang igenen tanginang using katala vil akui iau. ");
INSERT INTO lcm_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Man ta sikei kala raung korong a Kain io, limalengua na igenen nganlak ki kun mat. Sikei man ta mang anu kala vil akui iau, 77 na igenen ki kun mat using iau.” ");
INSERT INTO lcm_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Na Adam kala anguan ago an ve kana aina na kala ingus kana mang nat na kala lomlomonai ta, “Nat ke kapo sasakolai i Abel voiang a Kain kata raung ia.” Si vuk oring ang vanang na kala atuk a nat ang ta Set. ");
INSERT INTO lcm_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Na Set kata atogon nat kapa na kala atuk ia ta Enos. Si vuk pangau ke vang ri vap kila tutapong nanauai ani asan IAVE e ring malangas. ");
INSERT INTO lcm_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Kana na akuskus kita kalang ia i kana matan inatus na Adam. Si taun ang na God kata asinong na ri vap, kata pitopito iria usiusing kakana ta kankanuai akorong pok. ");
INSERT INTO lcm_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kata pitopito iria ani ki tauan na ki aina. Na nia si taun ang akorong kala poso atautauia iria na kala posong iria ta ri vap. ");
INSERT INTO lcm_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Na Adam kala 130 na matas na kala asereai ani mang sikei a nat kana asan ta Set. Nat ke katapo asukang luai val tamana. ");
INSERT INTO lcm_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Emung ina Adam kala to pok le na mang 800 na matas. Nei liuan i pangau ang kata atogon kapa na mang matan inatus nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Aongos Adam kata to na 930 na matas le na kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Na Set kala 105 na matas na kala atogon kakana ta kun nat kana asan ta Enos. ");
INSERT INTO lcm_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Au le na kala to na mang 807 na matas. Nei liuan i pangau ang kata atogon kapa na mang matan inatus nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Aongos Set kata to na 912 na matas le na kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Na Enos kala 90 na matas na kala atogon kakana ta kun nat, Kenan. ");
INSERT INTO lcm_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Emung ina Enos kala to pok le na mang 815 na matas. Nei liuan i pangau ang kata atogon kapa na mang matan inatus nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Aongos Enos kata to na 905 na matas le na kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Na Kenan kala 70 na matas na kala atogon kana kun nat, Malalel. ");
INSERT INTO lcm_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Emung ina kala to pok le na mang 840 na matas. Nei liuan i pangau ang kata atogon kapa na mang matan inatus nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Aongos Kenan kata to na 910 na matas le na kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Na Malalel kala 65 na matas na kala asereai ani kakana ta kun nat Iared. ");
INSERT INTO lcm_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Emung ina kala to pok le na mang 830 na matas. Nei liuan i pangau ang kata atogon kapa na mang matan inatus nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Aongos Malalel kata to na 895 na matas le na kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Na Iared kala 162 na matas na kala asereai ani Enok. ");
INSERT INTO lcm_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Emung ina Iared kala to pok le na mang 800 na matas. Nei liuan i pangau ang kata atogon kapa na mang matan inatus nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Aongos Iared kata to na 962 na matas le na kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Na Enok kala 65 na matas na kala kun atogon kakana ta kun nat, Metusela. ");
INSERT INTO lcm_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Na emung ina Enok kala to i pasal ve God ani mang 300 na matas pok le. Nei liuan i pangau ang kata atogon kapa na mang matan inatus nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Aongos Enok kata to na 365 na matas. ");
INSERT INTO lcm_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Au, na using Enok kata to aro i usiusing ani God, God kata songo suai ania na kala kovek palau. ");
INSERT INTO lcm_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Na Metusela kala 187 na matas na kala asereai ani kakana ta kun nat, Lamek. ");
INSERT INTO lcm_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Emung ina kala to pok le na mang 782 na matas. Nei liuan i pangau ang kata atogon kapa na mang matan inatus nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Aongos Metusela kata to na 969 na matas le na kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Au na Lamek kala 187 na matas na kala asereai ani kakana ta kun nat. ");
INSERT INTO lcm_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Na kala atuk ia ta Noa kuli mengen ke kata posong ia singina ta, “Nat ke ka kopo aus ira pelek a kui lava ke tarapo duai ia si kara keve avibisan e kuli rina ke, nang a God kata poso arikek ia.” ");
INSERT INTO lcm_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Emung i Noa, Lamek kala to pok le na mang 595 na matas. Nei liuan i pangau ang kata atogon kapa na mang matan inatus nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Aongos Lamek kata to na 777 na matas le na kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Au na Noa kala 500 na matas na kala asereai ani potol a nat ke, Sem, Am na Iapet. ");
INSERT INTO lcm_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Si pangau ke tataot na polpolokan i ri vap kalapo laba e kuli rina, na kilapo apitus asereai ani ri kavulik miang. ");
INSERT INTO lcm_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Na kana inatus nat a God kila arai ta ri kavulik i ri vap kipo ararai miminaungan na kila osongon iria angkokoai si kakaria ta keve pipilak akorong. ");
INSERT INTO lcm_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Na IAVE kala arai ani bil ke na kala mengen asukang ke, “Pato ig ka ago ta sinong asikei an si ri vap using kipo pukun palau na kipo angkoai si mat. Kari matas si to ka tung palau si 120 na matas. ");
INSERT INTO lcm_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Matan vap ke ri Nepilim kitapo ago e kuli rina si taun ang na ane mung lik kapa ina. Kita polok serei si taun ang kana inatus nat a God kita ago kuvul ve ri kavulik i asereai ta ri vap i kuli rina na kila atogon inatus singiria. Matan inatus ke kita polok alak na kila atogon asan na akus lava si taun ang. Kitapo vap madot luai. ");
INSERT INTO lcm_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","IAVE kala arai ta ri vap si taun ke kita lapo dual luai ta using ani lau rikek. Lomlomonai iria kata lapo lomon papalik akorong na keve laulauan rikek ani keve taun aongos. ");
INSERT INTO lcm_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Na IAVE kala mamakus luai ta katala asinong ri vap e kuli rina. Na kui kala rongos a pakangat ina. ");
INSERT INTO lcm_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Asukang vang na kala antok ta, “Naka mus suai luai ani vap ke natala asinong iria pelek na kuli rina ke. Na saka keve manmanik an, na riria kapa kipo palis ta vingaria kuli vunep, aongos si raung suai. Ri mani i nei pangau kapa asi daung. Napo mamakus ta natala asinong na keve bil ke e kuli rina.” ");
INSERT INTO lcm_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Sikei Noa papalik katapo auruk na IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Kana na akuskus i kana matan vap na Noa. Noa katapo mang sikei a igenen roron luai na katapo uli atutuman nei liuan i vap ang katapo ago ve ria si taun ang. Katapo uli auai ve God. ");
INSERT INTO lcm_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa katapo atogon kana potol a nat tauan. Karitol volo asan ta ri Sem, Am na Iapet. ");
INSERT INTO lcm_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Kuli rina aongos katapo duk ta lau rikek na katapo visuk luai e matana i God. ");
INSERT INTO lcm_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God kala arai ani kuli rina na kala arai ta kapo visuk na vap ina kapa, kari to kata lapo asukang. ");
INSERT INTO lcm_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Au na kala antok a Noa ta, “Nalapo lomlomonai kana ta na akamusai ani ri vap using kuli rina ke kalapo duk ta lau visuk le singiria. ");
INSERT INTO lcm_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ku tapasuk na ku abis a mangsikei a perengan anim. Abis ia ta ei ke, Saipres. Ku abis ta keve rum e neina na ku vulit ia ta kolta e neina na komo kapa. ");
INSERT INTO lcm_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kana vang na selen ku using ia si abis ani perengan ang. Vungavunga ina ka 150 na nganga, manamanang ina ka 25 na nganga na lakat ina ka 15 na nganga alak. ");
INSERT INTO lcm_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","E kuluna i lu ang ku abis ta vuk matakoto lik na ka inongos i sikei a nganga alak le si kuluna i lu ang. E ngising i perengan ang ku abis kapa ta mang matakoto. Nia si perengan ang ku abis ta keve ring asi pasal. Ta anu e pangkul luai, mang anu e liuan na mang anu e kevkev. ");
INSERT INTO lcm_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Naka alis a mangsikei a nole lava nang e kuli rina ke na ka bungum aongos na ri mamain ta bil atogon to e neite kuku. Saka keve bil an kipo atogon na malu i to singiria, riria aongos asi bungum. Keve bil aongos e kuli rina ke ki mamat. ");
INSERT INTO lcm_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Sikei nau nala abis na mang ainainakai ve numai. Numai na kisngam na kam volo nat na volo kisngaritol aongos asi palak nei perengan ke. ");
INSERT INTO lcm_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ane nei perengan ang kapa ku luk alak ta tataot pongua i keve manmanik aongos. Aina na tauan iria. Riria vanang ku aiveven ato iria ve numai. ");
INSERT INTO lcm_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ka atogon pongua i ri mamain ta mani, manmanik na riria kipo palis kuli roe. Ku ato aongos vanang iria. ");
INSERT INTO lcm_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Na ku luk aiton kapa na ri mamain ta pok anim na ani keve manmanik ang. Asinong aro na pok ang asi aiveven.” ");
INSERT INTO lcm_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Keve atatai aongos suke si God, Noa kata longong ia na ka using ia. ");
INSERT INTO lcm_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Au na IAVE kala antok a Noa asukang ke, “Nei liuan i vap ke kupo ago ve ria si taun ke, numai kupo korong luai. Asukang na numai ve kam inatus aongos mi palak e nei perengan ke. ");
INSERT INTO lcm_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ku songo ve numai na limalengua na angkisnganan i keve siksikei a manmanik daus aongos. Na i keve manmanik ipo tav angan ku songo palau a sikei a angkisnganan. ");
INSERT INTO lcm_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Songo na limalengua na angkisnganan i keve mani aongos i nei pangau, aina na tauan iria. Si oring ke nganlak kila apitus atanginang pok na kuli rina ke e mung i nole lava ke. ");
INSERT INTO lcm_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Emung i limalengua na taun, nala alis langit ani kuli rina ke. Na ka usen a 40 na mangias na 40 na tenei vong aongos. Keve bil aongos i kag la asinong ang e kuli rina nala vil punuk aongos iria.” ");
INSERT INTO lcm_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Na Noa kala abis aongos na keve bil ang IAVE kata atatai ia tatana. ");
INSERT INTO lcm_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa kata lapo 600 na matas aongos si taun ang na nole lava ang kata serei singina. ");
INSERT INTO lcm_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ninia ve kisngana na karilong volo nat na volo kisngaritol kapa kila palak aongos e nei perengan ang asi sip ani nole ang. ");
INSERT INTO lcm_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Keve angkisnganan i keve manmanik aongos ang, ri mani na ri manmanik palis e kuli vunep ");
INSERT INTO lcm_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","aongos kita serei si Noa. Au na kila kun palak alak e nei perengan ang si kuvkuvulan pongua i aina na tauan iria aongos. Kata asukang palau val atatai si God ani Noa. ");
INSERT INTO lcm_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Na limalengua na taun palau emung, nole ang kala serei. ");
INSERT INTO lcm_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa, kana vang kata lapo 600 na matas aongos. Na nole ang kata serei si va 17 i taun i va pongua i ulen i matas ang. Taun ang akorong keve laman i nei roe kita tavas na mete kuku ka vekai ani langit. ");
INSERT INTO lcm_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Na kala usen na 40 na tenei ias na tenei vong aonogs. ");
INSERT INTO lcm_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Nia si taun ang akorong Noa ve kisngana na karilong volo nat ri Sem, Am na Iapet, kuvul ve volo kisngaritol kita riuk lak aongos nei perengan ang. ");
INSERT INTO lcm_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ri mamain ta manmanik, loi na tav loi kapa kita kun kokos ve ria. Mamain ta manmanik anglok ipo palis kuli vunep na ri mamain ta mani aongos kapa kita kun kokos. ");
INSERT INTO lcm_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Saka keve manmanik an atogon to, kita serei si Noa si kuvkuvulan pongua na kianpo palak e nei perengan ang. ");
INSERT INTO lcm_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Sikei a aina na sikei a tauan i keve manmanik to aongos kita serei asukang palau val atatai si God ani Noa. Emung palau i kitala papalak aongos IAVE akorong kala akang bat a takaman. ");
INSERT INTO lcm_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Si vuk pangau i 40 na mangias ang kuli rina katala voko aongos. Taun ang na laman ang kapo ruduk alak kala sung alakat a perengan ang le kuli roe. ");
INSERT INTO lcm_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Laman ang kata ruduk alak tung kanla sung suai luai ani perengan ang na kala voko nia si laman i pangkul i kuli vunep ang. ");
INSERT INTO lcm_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Saka keve mulang lava an i kuli rina katala mun aongos si taun ang na laman ke kata ruduk na kala pakut aongos iria. ");
INSERT INTO lcm_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Le si lakat i keve mulang lava laman ang kata anguan palak ani limalengua na nganga soliu na kuluria. ");
INSERT INTO lcm_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Saka keve bil atogon to si taun ang kita mamat aongos. Ri mani, ri manmanik loi na ipo aiveven na ri manmanik aongos ipo uraura ani kuli rina kita mat. Na ri vap tutuman aongos kita kun mamat kapa. ");
INSERT INTO lcm_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Si selen ke vanang keve bil aongos i kuli rina kita mamat suai. Saka keve bil an kita atogon a to na kipo aus ta isuria kita mamat suai aongos. ");
INSERT INTO lcm_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","IAVE kata vil suai aongos ani mamain ta bil atogon to nang katapo aduk na kuli rina. Noa papalik na vap po ago ang ve nia nei perengan ang kitapo to. ");
INSERT INTO lcm_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Emung i keve bil ke, laman ang kata pakut lak na kuli rina ani mang 150 na mangias aongos. ");
INSERT INTO lcm_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Sikei God kala lomon pok na Noa ve keve manmanik kei na manmanik ipo aiveven e nei perengan ang na kala alis a mangsikei a vuk malu asi malu ani kuli rina na laman ang kalapo uak asiang. ");
INSERT INTO lcm_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Si vuk pangau ke lenginang na keve mata i nei laman miting kila akang bat ta uv alak na langit tavirimok ang kala kun aulei ta usen. ");
INSERT INTO lcm_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Laman ang kuli rina kalapo uak ananap asiang ani 150 na taun tung kanla pasiang luai. ");
INSERT INTO lcm_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Asukang na si va sangauli na limalengua i taun i va limalengua i ulen perengan ang vanang kamela soisinong kuli keve mulang i Ararat. ");
INSERT INTO lcm_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Laman katapo kisiang lak tung si ainoai i taun i vasangauli i ulen na kuluria i ri mulang kalapo serei aongos. ");
INSERT INTO lcm_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Au, emung i 40 a taun Noa kala tavas na matakoto i kana abis kuli perengan ang ");
INSERT INTO lcm_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","na kala angoi a kol ani kan ararai. Sikei a kol ang kanlapo ngoi angpok palau tung a kuli rina kala kolo aongos. ");
INSERT INTO lcm_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Asukang na kala angoi a uk asi kana an kun ararai ta man a laman e kuli rina kala uak asiang. ");
INSERT INTO lcm_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Taun kanlapo ngoi pulakai parik kata arai korong ta oring asi kana gon ausai, using laman katapo duk aongos lak e kuli rina. Asukang na kamela papok na Noa kala sulai ani kungana na kala songo aro alak pok ia nei perengan ang. ");
INSERT INTO lcm_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Au, kala kokoai ani limlengua na taun kan liu na kala anguan asok ani uk ang. ");
INSERT INTO lcm_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Si tenei ngelik i taun ang pok kala serei ve pan tanginang luai i oliv e nguruna na Noa kala nas ta laman ang e kuli rina katalapo uak asiang. ");
INSERT INTO lcm_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Au, kala kokoai pok ani mang limalengua na taun na kala anguan asok ani uk ang. Sikei si taun ke parik kata mela papok. ");
INSERT INTO lcm_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Si ainoai i taun i ainoai i ulen i matas ang na Noa kata lapo 601 na matas singina, kuli rina kala kolo aongos. Na si taun ang Noa kala vil suai ani akang bat i perengan ang na kala arai ta kuluna i kuli roe kala kolo aongos. ");
INSERT INTO lcm_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Io na si va 27 i taun i va pongua i ulen akorong kuli rina aongos ke katala kolo aongos luai. ");
INSERT INTO lcm_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Na God kala antok a Noa, ");
INSERT INTO lcm_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Mi soung pelek a perengan ang. Numai ve kisngam na kam volo nat na volo kisngaritol. ");
INSERT INTO lcm_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mamain ta manmanik to aongos ang ve numai, ku songo suai aongos kapa aniria. Ri mani, ri mamain ta vongo anglok, na riria kipo palis kuli roe, ki soung aongos ani kime apitus ani kuli rina ke na ka duk luai tataria.” ");
INSERT INTO lcm_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Asukang na Noa kamela soung pelek na perengan ang ve kisngana na kana volo nat na volo kisngaritol. ");
INSERT INTO lcm_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mamain ta vongo aongos na riria aongos kipo palis e kuli roe na ri mani aongos kila kun soung. Ri bil aongos ipo rol ani kuli rina ke kita soung asiang nei kari keve kuvkuvulan akorong. ");
INSERT INTO lcm_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Na Noa kala ngoto atung na mangsikei a pata ipo sula e mete IAVE. Kala luk ta mang rukun i mamain ta vongo ve mani daus aongos ipo angan na kala sula iria asukang ta kana alilis ane si IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","IAVE kala sain na sain lulupusan ang na kala antok pok ia ta, “Tutapongai kana na iles lak nala aulei luai ta anguan vil arikek an ani kuli rina si kari lau rikek ri vap. Kantanem ki uli bil arikek lak using kapo ago si rangai iria, sikei nau nala aulei luai ta anguan bil asukang ke an. Nala aulei kapa ta anguan vil punuk suai an ani ri manmanik aongos kuli rina. ");
INSERT INTO lcm_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tung si akamusai i taun i kuli rina ke, ka uli atogon ani keve taun angpetpetekai ke: keve taun i suksukal ve keve taun i kopkopos, keve taun livus ve keve taun manas, keve taun mangias ve keve tenei vong, keve taun angpetpetekai nei liuan i matas. Io, ki ago luai ta anguan taputuk an.” ");
INSERT INTO lcm_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Na God kala poso atautauia na Noa ve kana volo nat velai ani mengen asukang ke, “Mi apitus na mi serei aduk luai asi kami rol ani kuli rina ke. ");
INSERT INTO lcm_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mamain ta vongo i kuli rina ke na mamain ta mani aongos i nei pangau na ri manmanik kipo palis e kuli roe na ri ien aongos i nei laman kilapo ago si kungami asi kami saupai. Nganlak ki leng na ki sip animi. ");
INSERT INTO lcm_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Saka bil an kapo atogon a to singina na kapo palis vo ngoi angpok, kalapo kami pok asi angan. Natala alis imi ta mamain ta suksukalan na asukang palau kapa nala alis imi kana ta keve bil aongos ke. ");
INSERT INTO lcm_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Sikei mi ago luai ta angan an ta sikei a vuk avus kapo atogon rangai lak singina. ");
INSERT INTO lcm_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Na nganlak lak man nami ri vap mi angdaung, mila mengen amalangas e matag ta kakami ta kun to akorong. Ka asukang si mamain ta vongo aongos na ka asukang kapa singimi ri vap ta siksikei a igenen man ka vil punuk a tungana e ke e vunep, kala mengen amalangas ta kana to. ");
INSERT INTO lcm_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Si ka asasaling na rangai si igenen, igenen akorong pok kala asasaling na rangai ina i iuang. Using a God kata pitopito na igenen si kakana ta kankanuai akorong pok. ");
INSERT INTO lcm_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Au animi akorong ri vap, mi apitus na mi serei aduk luai na mi aruduk a kuli rina ke tatami pok.” ");
INSERT INTO lcm_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Na God kala anguan antok an ani Noa na kana volo nat asukang ke, ");
INSERT INTO lcm_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kana vang nala amatung kag palpalatung ve nami na matan inatus ang kapa ki serei lak emung imi. ");
INSERT INTO lcm_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Kuvul ve mamain ta bil atogon to kitapo ago aongos ve nami e nei perengan ang. Ri mani, ri mamain ta vongo anglok, na ri kei aongos, nang riria aongos kitala soung ve nami, mamain ta bil aongos atogon to e kuli rina. ");
INSERT INTO lcm_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Kag palpalatung kapo asukang ke: Tutapongai kana na iles lak nala aulei luai ta anguan vil putuk ani kami to ta alis nole ane kuli rina. Io, ka ago luai ta atogon ta mang nole lava asukang ke asi anguan vilvil punuk suai an e kuli rina ke.” ");
INSERT INTO lcm_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Na God kala antok kapa asukang ke, “Kana vang na akanangai i palapalatung ke napo amatung ia nei liuan ira, na keve mamain ta vongo aongos ang na kami keve patvap si serei lak emung imi. ");
INSERT INTO lcm_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Mi arai ta natala amatung na mang sikei a kumrangai e nei liuan i keve kuku suke. Ninia vanang kalapo akanangai i palpalatung ke nalapo abis ia ve kuli rina ke. ");
INSERT INTO lcm_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Si keve taun, man a nei pangau ka duk ta kuku na kumrangai kala tutu serei io, ");
INSERT INTO lcm_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","naka lomlomonai pok ani kag palpalatung ve nami aongos na mamain ta bil anglok aongos atogon to singiria. Parik luai kapa angkoai ta laman ka anguan bungum na vil punuk suai an ani mamain ta bil e kuli rina. ");
INSERT INTO lcm_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Io, taun na arai ani kumrangai ang, ka alomon pok iau ta kag palpalatung kapo tung atokos ve mamain ta bil anglok aongos atogon to singiria. ");
INSERT INTO lcm_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Sukana vang Noa, arai ta kumrangai vanang kapo akanangai i kag palpalatung ve kuli rina aongos ke.” ");
INSERT INTO lcm_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Kana volo nat a Noa voiang kita soung ve nia pelek a nei perengan ang, karitol volo asan ta ri Sem, Am na Iapet. Na Am ninia katapo tamana i Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Le si volo nat ke vanang kuli rina ke kata serei aduk luai. Na inatus iria kila angpotok ta kuli rina ke. ");
INSERT INTO lcm_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa katapo mangsikei a igenen katakai i sukal. Asukang na kata sukal kana matang vaen. ");
INSERT INTO lcm_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Mangsikei a taun kata inum si uai i nei kana matang na kala nio, na kanla matung ta varas e nei kana lu. ");
INSERT INTO lcm_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Au na Am, nat voike kata asereai ani Kanan, kala arai ania sipo matung ang na kanla antok a ngono tasina e komo. ");
INSERT INTO lcm_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sikei ngono angtasimal ke kilongla luk le na mang vakup na kilongla amatung ia e kalakalarilong na kilong anla palak alak ta mung irilong na kilongla pakut a tamarilong tatana. No irilong kapo tun apetekai vei kilong arai ani tamarilong sipo varas ang. ");
INSERT INTO lcm_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Taun ang a Noa kala vangang tapalas na kala nas a sa na kana kiu kata abis ia singina, kala tapasuk ");
INSERT INTO lcm_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","na kala posong asukang ke: ‘Mamaiten kitmat ka kos lak e kuluna i Kanan. Ka serei a asosokai e kevkev luai si ngono tasina.” ");
INSERT INTO lcm_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Na kala posong kapa na vuk mengen asukang ke: “Alatun ane si IAVE, voiang a Sem kapo atogon ia val kana God. Kanan ka asosokai si Sem. ");
INSERT INTO lcm_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","God ka apolokai apapanai ani palpal roe si Iapet, na ri Iapet ve Sem kilong sikei palau si karilong keve togtogon, na Kanan ka asosokai singirilong.” ");
INSERT INTO lcm_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Emung i nole lava ang, Noa kata to pok na mang 350 na matas. ");
INSERT INTO lcm_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Na aongos Noa kata to na 950 na matas, le na kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Kana na akuskus usiusingai i kana volo nat a Noa, ri Sem, Am na Iapet voiang kitol tala kun atogon nat pok emung i nole lava ang. ");
INSERT INTO lcm_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iapet kata apolokai ani keve nat ke: Gomer, Magog, Madai, Iavan, Tubal, Mesek na Tiras. ");
INSERT INTO lcm_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Na Gomer kata apolokai ani Askenas, Ripat na Togarma. ");
INSERT INTO lcm_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Na Iavan kata apolokai ani Elisa, Tarsis, na ri Kitim ve ri Rodaim. ");
INSERT INTO lcm_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Keve palpal vap vo ago aliu ang si keve palpal e ngere lo kita seserei le si keve vap suke. Kita tapagal pulakai na ki polok ane si keve patmani angpetpetekai na kila ago akorong si kari keve palpal. Na ninia si kari keve palpal kita atogon kari keve mengen i rina akorong. ");
INSERT INTO lcm_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Am kata apolokai ani keve nat ke: Kus, Misraim, Put na Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Na Kus kata apolokai ani Seba, Avila, Sabta, Rama na Sabteka. Na Rama kata apolokai ani Seba na Dedan. ");
INSERT INTO lcm_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus kata asereai ani Nimrod na Nimrod kata serei a igenen visvis madot luai e kuli rina aongos. ");
INSERT INTO lcm_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","E matana i IAVE kata serei a igenen katak aro luai ta akalat. Eiang vanang na ri vap kipo nas ani posong ani vuk mengen ke: ‘Asukang val Nimrod, igenen dual alava ke mete IAVE ta akalat.’ ");
INSERT INTO lcm_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Keve ainoai i rina lava i kana atung na ka vosap aniria kipo Babilon, Erek, Akad na Kalne e palpal Sinar. ");
INSERT INTO lcm_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Le ke vanang kata pasal taun a Asiria na kanla atung a Nineve, Reobot, Ir, Kala ");
INSERT INTO lcm_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","nas Resen. Resen nang kapo ago nei liuan i Nineve na rina tavirimok ang ta Kala. ");
INSERT INTO lcm_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim kata asereai ani ri Lud, ri Anam, ri Leav, ri Naptu, ");
INSERT INTO lcm_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ri Patrus, ri Kaslu - vap ke ri Pilistin kita polok singiria - na ri Kaptor kapal;. ");
INSERT INTO lcm_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanan kata asereai ani Sidon, kana nat kiu. Au na ri It, ");
INSERT INTO lcm_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ri Iebus, ri Amor, ri Girgas, ");
INSERT INTO lcm_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ri Iv, ri Arak, ri Sin, ");
INSERT INTO lcm_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ri Arvad, ri Semar, na ri Amat kapa. Keve patmani i Kanan kila pasal apapanai pulakai ");
INSERT INTO lcm_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","tung si puli i Kanan kanla kinkos a Sidon taun a Gerar na alak luai ane Gasa. Na le iang pulis ang kala pasal taun a Sodom, Gomora, Adma na Seboim tung e Lasa. ");
INSERT INTO lcm_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Riria vang sukana na matan inatus si Am. Si kari keve patmani akorong, na kari keve mengen i rina. Si kari keve palpal roe na kari keve palpal vap. ");
INSERT INTO lcm_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Au na Sem kapa, voiang kapo tasina lik i Iapet, kata kun atogon kana inatus. Sem katapo tivuria i matan inatus aongos si Eber. ");
INSERT INTO lcm_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem kata apolokai ani keve nat ke: Elam, Asur, Arpakad, Lud na Aram. ");
INSERT INTO lcm_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Na Aram kata apolokai ani Us, Ul, Geter na Mesek. ");
INSERT INTO lcm_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arkapad kata asereai ani Sela na Sela kata asereai ani Eber. ");
INSERT INTO lcm_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Na Eber kata atogon kana pongua na nat. Mang anu kita atuk ia ta Peleg, using si taun ang a kui rina katapo tatapagal. Na tasina i Peleg kana asan ta Ioktan. ");
INSERT INTO lcm_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ioktan kata asereai ani keve nat ke: Almodad, Selep, Asarmavet, Iera, ");
INSERT INTO lcm_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Usal, Dikla, ");
INSERT INTO lcm_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO lcm_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Opir, Avila na Iobab. Sukana na keve nat ang si Ioktan. ");
INSERT INTO lcm_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Palpal ang kitapo ago singina kata oros apapanai le Mesa ane Separ, si palpal rina mulangan ang ane si ring ipo sanglak ta makarap. ");
INSERT INTO lcm_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Riria vang kana na matan inatus si Sem. Si kari keve patmani akorong, na kari keve mengen i rina. Si kari keve palpal roe na kari keve palpal vap. ");
INSERT INTO lcm_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","riria aongos vanang na keve patmani i kana volo nat a Noa. Kipo matung amalangas luai si ausingai i kari keve polpolokan nei liuan i kari keve palpal vap akorong. Le singiria vanang a keve palpal vap ke kita apolokai ani kuli rina aongos ke emung i nole lava vo serei ang. ");
INSERT INTO lcm_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Au, kuli rina aongos ke kata atogon kana sikei palau a saling i mengen i rina. ");
INSERT INTO lcm_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Na taun ri vap kilapo pasal avunga ane si ring ipo sanglak ang ta makarap, kianla sabonai ani mangsikei a oring marul e Sinar na kila soi sinong singina. ");
INSERT INTO lcm_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Na kila angtokai angpokpokai aniria asukang ke, “A, tara me pulpul na roe ke na tara ngangan amadot iria” Kitapo uli abis lu ta roe, parik ta iat. ");
INSERT INTO lcm_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Na kila antok, “A, tara abis anira ta mangsikei a rina lava ve mangsikei a lu lakat luai e nei liuan ina voiang ka palak alak luai ane metekuku ani kara asan ka lava. Vei tarala uli angpotok pulakai ta kuli rina ke.” ");
INSERT INTO lcm_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Sikei IAVE kamela pasiang asi me ararai ani rina lava ang nang a lu lava ang kilapo abis ia ");
INSERT INTO lcm_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","na kala antok, “Au, man kana using a vap ke kipo sikei palau ve kari sikei a mengen i rina na kilapo tutapongai kana asukang ke, pua! Nganlak nganing ka kovek i bil ka tubat iria man kila atogon a mang sa keve lomlomonai ang emung. ");
INSERT INTO lcm_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","A, tara kun pasiang na tara an atapagal kari mengen i rina ani ki angilung pok nei liuan iria.” ");
INSERT INTO lcm_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Asukang na si selen ke vanang IAVE kata ailung na ka pagal na ri vap angpotok ta kuli rina ke. Io na eke avibisan i rina lava ang kata kamus palau. ");
INSERT INTO lcm_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ninia vanang a tukulai ina na kita atuk a rina ang ta Babel, using eiang vanang IAVE kata ailung na sikei a mengen i kuli rina aongos ke. Tapagal i matan vap ang vanang aulit i kuli rina ke kata tutapongai le iang. ");
INSERT INTO lcm_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Kana na akuskus i Sem. Pongua na matas emung i nole lava ang, Sem kalapo 100 na matas le na kala asereai ani Arpakad. ");
INSERT INTO lcm_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Emung ina kala to pok le na mang 500 na matas na kala atogon nei pangau ang kana mang rukun nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Au, Arpakad kalapo 35 na matas le na kala asereai ani Sela. ");
INSERT INTO lcm_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Emung ina kala to pok le na mang 403 na matas na kala atogon nei pangau ang kana mang rukun nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Au, Sela kalapo 30 na matas le na kala asereai ani Eber. ");
INSERT INTO lcm_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Emung ina kala to pok le na mang 403 na matas na kala atogon nei pangau ang kana mang rukun nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Au, Eber kalapo 34 na matas le na kala asereai ani Peleg. ");
INSERT INTO lcm_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Emung ina kala to pok le na mang 430 na matas na kala atogon nei pangau ang kana mang rukun nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Au, Peleg kalapo 30 na matas le na kala asereai ani Reu. ");
INSERT INTO lcm_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Emung ina kala to pok le na mang 209 na matas na kala atogon nei pangau ang kana mang rukun nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Au, Reu kalapo 32 na matas le na kala asereai ani Serug. ");
INSERT INTO lcm_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Emung ina kala to pok le na mang 207 na matas na kala atogon nei pangau ang kana mang rukun nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Au, Serug kalapo 30 na matas le na kala asereai ani Naor. ");
INSERT INTO lcm_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Emung ina kala to pok le na mang 200 na matas na kala atogon nei pangau ang kana mang rukun nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Au, Naor kalapo 29 na matas le na kala asereai ani Tera. ");
INSERT INTO lcm_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Emung ina kala to pok le na mang 119 na matas na kala atogon nei pangau ang kana mang rukun nat kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Au, Tera kalapo 70 na matas le na kala asereai ani ri Abaram, Naor na Aran. ");
INSERT INTO lcm_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Kana na akuskus i Tera. Tera kata asereai ani ri Abaram, Naor na Aran. Au, Aran kala kun asereai ani Lot. ");
INSERT INTO lcm_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Le na kan mat e Ur, rina ke si ri Kalde, si ring i ingus ania. Kata mat si taun a tamana katapo to lak. ");
INSERT INTO lcm_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Au, ri Abaram ve Naor kilong talapo osongon na kisngana i Abaram, kana asan ta Sarai, na kisngana i Naor, kana asan ta Milka, tamarilong ve Iska ta Aran. ");
INSERT INTO lcm_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sarai katapo ngolo, kovek i nat. ");
INSERT INTO lcm_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Au, Tera kala songo kana nat ta Abaram na tivuna ta Lot, nat ang si Aran, na omona ta Sarai na kila tapasuk pelek a Ur si ri Kalde asi kari pasal ane Kanan. Sikei, taun ang kimela serei e Aran akorong, kila soi sinong eiang. ");
INSERT INTO lcm_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera kalapo 205 na matas aongos le na kala mat eiang e Aran. ");
INSERT INTO lcm_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Au, mangsikei a taun IAVE kata serei si Abaram na kala antok ia, “Ku tapasuk suai ani kam ring ipo ago na kam matan vap na lu ang si tamam na ku pasal taun a vuk roe ke naka akalit lak ua tatana. ");
INSERT INTO lcm_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Naka asereai anim ani ku serei a matan vap lava luai. Na naka atautauia ua. Naka asereai ani kam asan asi kana tavirimok na ku serei a oring asi kag atautauia ani mang matan vap. ");
INSERT INTO lcm_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ri si kipo poso atautauia ua, naka kun poso atautauia aniria kapa. Na riria kipo poso arikek ua, naka kun poso arikek aniria kapa. Le singim naka atautauia aongos na mamain ta palpal vap i kuli rina ke.” ");
INSERT INTO lcm_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Au, asukang na Abaram kala tapasuk suai val IAVE katala antok ia. Na Lot kata pasal ve nia. Taun ke na Abaram kata papelek na Aran, kana matas i to katalapo 75 aongos. ");
INSERT INTO lcm_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Kata songo na kisngana ta Sarai na kana nat ta Lot. Na kala luk kana togtogon aongos na kana keve asosokai i kana samui e Aran na kila pasal na kianla serei e Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Taun kianla serei e Kanan, Abaram kanlapo pasal nei liuan i ring ang tung e Sekem, si ring ang a ei gogoai ang i More kapo tung singina. Si taun ang ri Kanan kitapo ago si roe ang, ");
INSERT INTO lcm_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","sikei IAVE kala serei si Abaram na kala antok ia, “Naka alis a vuk roe ke ane si kam nat.” Asukang na Abaram kala solo atung na mangsikei a pata ipo sula ane si IAVE, iuang kata serei singina. ");
INSERT INTO lcm_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Au le iang kala pasal alak taun a palpal mulangan i Betel na kanla atung kana lu eiang. Tere le iang Betel katapo matung si palpal ipo siang ta makarap, na Ai si palpal ipo sanglak ta makarap. Au na kala solo atung kapa na mang pata ipo sula ane si IAVE na kala songo na asan ina i IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Emung ina kala tapasuk pok na kala pasal taun na palpal Negev. ");
INSERT INTO lcm_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Si pangau i taun ke kata lapo atogon a mol lava si palpal ang. Asukang na Abaram kala pasiang ane Aigipto asi an ago tapai eiang, using a mol ke katapo rikek luai. ");
INSERT INTO lcm_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Le ani kianla serei e Aigipto, Abaram kala antok na kisngana Sarai asukang ke, “Napo nas ta kupo aina ararai aminaungan. ");
INSERT INTO lcm_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Na nganlak man a ri vap i Aigipto ki arai anim kila posong ta, ‘Aina suke nang kapo kisngana.’ Au na kila angkoai si raung anig sikei kila teng ato ua. ");
INSERT INTO lcm_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Asukang vanang na kapo ro ani ku antok iria ta kupo taug ani ki teng ato iau na kag to ka kalakala asi kag la aiveven aro anim emung.” ");
INSERT INTO lcm_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Io na taun a Abaram kanla serei e Aigipto, vap i ring ang kila arai kinle ta Sarai katapo ararai miminaungan luai. ");
INSERT INTO lcm_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Na kana keve ainoinoai a Parao kila arai ania na kianla posong i mangal ania si Parao. Asukang na kila songo alak ia ane nei kana lu. ");
INSERT INTO lcm_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Au, na Parao kala aiveven aro na Abaram using a Sarai. Kata alis ia ta kana keve sipsip, na meme, na bulumakau, na dongki, na kamel na kana keve asosokai aina na tauan kapa. ");
INSERT INTO lcm_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Au, IAVE kala arai ta Parao katala songo kana aina na Abaram, kala alis a mamain ta malepen lava singina na si vap aongos ang i nei kana lu. ");
INSERT INTO lcm_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Au, na Parao kala lis mengen asi kana arai ani Abaram na kamela antok ia asukang ke, “Au si Abaram, marai sa kana kupo vil iau asukang ke? Ani sa akorong parik kutapa buk antok amalangas anig ta aina ke kapo kisngam? ");
INSERT INTO lcm_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Marai sa kuta antok ta kapo taum, kana? Kutala vil iau na natala osongon ia lenginang. Au kanat, kana na kam aina, songo le ia na mi pasal suai ani ring ke!” ");
INSERT INTO lcm_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Na Parao kala alis a saupai ani Abaram si kana keve asosokai na kila asok suai ania kuvul ve kisngana na kana keve togtogon aongos. ");
INSERT INTO lcm_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Asukang na Abaram kala papelek a Aigipto taun a palpal Negev kuvul ve kisngana na kana keve togtogon aongos. Abaram si taun ke katala serei a igenen tauia luai, duk i vongo na kapkap miminaungan. Na Lot kata auai ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kalapo pasal angpok rina le palpal Negev tung si kanla serei e Betel. Io, si vuk oring ang akorong e liuan i Betel na Ai, voiang kata atu lu aino singina, ");
INSERT INTO lcm_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","na ka abis kapa na pata ipo sula ang. Eiang Abaram kala anguan songo an ani asan ina i IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Au, Lot kapa katapo atogon kakana ta kun keve sipsip na bulumakai na kana keve vakup ipo atu lu, na kana kun keve asosokai. ");
INSERT INTO lcm_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Kilong tapo auai atogon ani keve bil miang ke asukang na vuk roe ang kilong tapo ago ia kata lapo liklik anirilong kuvul. ");
INSERT INTO lcm_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Au na using kapo liklik a vuk roe ang, karilong keve katakai i aiveven vongo kitapo uli angmamaralai. Si vuk pangau ke ri Kanan na ri Peris kapa kitapo ago na roe ang. ");
INSERT INTO lcm_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Asukang vanang na Abaram kala antok a Lot asukang ke, “A, parik nang kapa ro ani ka atogon angmamaralai e nei liuan irung na nei liuan i karung keve asosokai. Tarungpo angtogon nang. ");
INSERT INTO lcm_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kalapo roron vang kana ani tarung angtaliungai. Roe lava nang kapo oros palau e matarung. Pilak ta kam ta palpal roe kupo buk ia, na man kula luk a saka palpal an, nau nala kun luk ani mang palpal. Kapo ro ta tarung angtaliungai e ke.” ");
INSERT INTO lcm_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","11","Au na Lot kan arai ani mas ro i polpolokan i nei lulung ang e Ioridan na kala pilak ia ania. Vuk roe ke katapo roron luai val matang ang si IAVE, na asukang val roe ang e Aigipto taun a Soar. Si taun ke IAVE parik lak katapa vil punuk suai ani ri vap i Sodom na Gomora. Au, Lot kala tapasuk na kala pasal taun a vuk roe ang ane si ring ipo sanglak ta makarap. Eiang vanang, ngono igenen ke kilongla angtaliungai. ");
INSERT INTO lcm_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abaram kala ago si roe ang e Kanan na Lot kala pataun na keve rina i nei palpal ang na kanla atu lu ngere Sodom. ");
INSERT INTO lcm_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ri vap i Sodom kitapo to arikek luai na kitapo uli abis ani keve lau rikek miang e mete IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Au, emung palau i karilong angtaliungai, IAVE kala antok na Abaram asukang ke, “Le si vuk oring ang kupo tung singina, ku tere aongos aulitai anim si keve palpal malu. ");
INSERT INTO lcm_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Roe aongos ang nang kupo arai ania, naka alis ua na matmatan inatus emung im tatana ani kala kakami asikei. ");
INSERT INTO lcm_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Naka asereai aniria ani ki duk luai na parik kipa angkoai si taot korong aniria. Man ta sikei ka angkoai si tataot korong ani mutep i kuli vunep ke io, kala angkoai vanang si tataot korong ani matmatan inatus emung im. ");
INSERT INTO lcm_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Pasal na ku ararai ani vungavunga na manamanang i vuk roe ang. Kalapo kakam nang. Nala alis ua tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Asukang vanang na Abaram kala aingik kana keve lu taun a Eberon na kanlapo atu lu eiang ngere keve ei gogoai ang si Mamre. Eiang kala solo atung kana pata ipo sula taun a IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","3","Si vuk pangau i taun ke katapo atogon a visvis e nei palpal Lulung i Sidim, kipo kin ia ta Laman Makasim. Puat a vosap kita pasal asi an visvis ve mang palpalima na vosap. Amrapel i Sinar, Ariok i Elasar, Kedorlaomer i Elam na Tidal i Goim kita visvis ve mang palpalima na vosap ke: Bera i Sodom, Bersa i Gomora, Sinab i Adma, Semeber i Seboim na vosap i Bela, nang a palpal ang kipo kin kapa ia ta Soar. Palpalima na vosap ke kita angsongo na kila tung kuvul e palpal lulung ke e Sidim. ");
INSERT INTO lcm_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ani 12 na matas aongos kita ago neite saupai si Kedorloamer na si va 13 i matas vanang kila tutaliung ia. ");
INSERT INTO lcm_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Au na si va 14 i matas Kedorlaomer na keve vosap ang kita ago ve nia kita pasal na kianla vis suai ani ri Repa e Asterot-Karnaim, ri Sus e Am, na ri Em e Save-Kiriataim, ");
INSERT INTO lcm_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","na ri Or e palpal mulangan i Seir na avunga lik ane El Paran ngere ring varasai palau ang. ");
INSERT INTO lcm_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Le iang kila aliuliu pok na kila pasal ane En-Mispat, kipo kin ia ta Kades si taun ke, na kianla luk aongos a roe ang si ri Amelek na si ri Amor kapa po ago ang e Aseson-Tamar. ");
INSERT INTO lcm_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Au, asukang vanang na palpalima na vosap ang le Sodom, Gomora, Adma, Seboim na Bela (nang Soar) kila auai kuvul na kianla itoitonai ani kari keve tungtungan i visvis e nei palpal lulung ang e Sidim. ");
INSERT INTO lcm_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Na kila angvisvis ve palpalima na vosap ang, Kedorlaomer i Elam, Tidal i Goim, Amrapel i Sinar na Ariok i Elasar. Visvis ke katapo asukang ke: puat a vosap kitapo petau na palpalima na vosap. ");
INSERT INTO lcm_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Au, palpal lulung ang e Sidim katapo duk i ri lulung lik pulakai voiang kapo atogon kolta neiria. Na vuk taun ang na ngono vosap ke i Sodom na Gomora kilongta sip, mang matan i karilong keve vap kila puka nei keve lulung ang, na mang matan iria kila sip alak taun a ring mulangan. ");
INSERT INTO lcm_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Asukang na puat a vosap ang kita aunga aongos na togtogon na matan pok i Sodom na Gomora na kila pasal suai tatana. ");
INSERT INTO lcm_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Kita tak kapa na Lot, nat ang si Abaram, kuvul ve kana togtogon aongos. Io, katapo asukang ke using katapo ago e iang e Sodom. ");
INSERT INTO lcm_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Au, mangsikei i kana keve asosokai a Lot kala sip na kamela antok a Abaram, igenen i Ebraio voike katapo ago ngere keve ei gogoai ang si Mamre, igenen ke i patvap Amor. Mamre katapo tasirilong i ri Eskol ve Aner na kitapo tung kuvul aongos ve Abaram. ");
INSERT INTO lcm_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Io, taun ang na Abaram kata longong ta kitala teng akit kana nat, kala songo akuvul kana petau i visvis. Tataot iria 318 aongos. Petau ke kitapo kakana akorong ta vap ipo aiveven na itoitonai ani matan taun asukang ke. Kata songo le vanang iria na kila pasal using na vap ang tung e Dan akorong. ");
INSERT INTO lcm_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Au eiang si tenei vong ang kala pagpagal iria si keve kuvkuvulan lik asi an via ani vap ang. Au, kila vis iria na kila lu iria tung e Oba, liu a Damaskus. ");
INSERT INTO lcm_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Na Abaram kala songo pok kana nat ta Lot ve kana togtogon aongos kuvul ve kari keve aina na vap kapa. ");
INSERT INTO lcm_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abaram katala vis suai aongos ani ri Kedorlaomer ve keve vosap ipo tung ang ve nia, na vosap i Sodom kamela paruduai ia e nei Lulung i Save. (Kipo posong kapa ia ta Lulung si ri Vosap.) ");
INSERT INTO lcm_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Au eiang, Melkisedek, vosap i Salem, kala sasagi aniria ta saui na vaen. Igenen ke katapo piris si God e Palkul Luai. ");
INSERT INTO lcm_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Au, kala sasagi le na kala poso atautauia na Abaram asukang ke, “Atautauia ane singim Abaram, le si God i Palkul Luai, ninia na vo tauk i kuli rina na metekuku. ");
INSERT INTO lcm_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Io, na posong ro ane si God i Palkul Luai, voiang kata atiti dong ua ta vap ipo marala ang anim.” Au na Abaram kala pagal suai ania ta keve vo asangauli i keve bil ang. ");
INSERT INTO lcm_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Na vosap i Sodom kala antok na Abaram ta, “Iuang, ku alis iau nang ta vap ang, na togtogon aongos ang ku teng akit ia anim.” ");
INSERT INTO lcm_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Sikei Abaram kala antok ia ta, “Parik. Natala atung a kungag nang i atu vala e matana i IAVE, God i Palkul Luai ang, na tukulai i metekuku na kuli rina ke ta ");
INSERT INTO lcm_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","na ago luai ta naung an ta mangsikei i kam keve togtogon aongos. Io, ka ago luai ta vuk vakup lik luai vo vuk kulit lik i pauk i kak name teng ia. Napo lolokovo vei nganing kula antok nganlak lak ta numai kutala vil atauia iau. ");
INSERT INTO lcm_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Na ago luai ta luk an ta sikei a bil le singim sikei sa palau kag petau kitala angan ia na palpal i togtogon palau nang ke petau vap ke kitala auai ve nau, ri Aner, Eskol na Mamre io, ritol kitol luk kakaritol ta pagpagal i togtogon ang.” ");
INSERT INTO lcm_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Emung ina palau, kalingana i IAVE kamela serei si Abaram nei ararai veai ani mengen ke, “Ku ago ta leng an Abaram. Nau kana kam lilit kitmat. Io, nau naka seupok alava luai anim. ");
INSERT INTO lcm_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Sikei Abaram kala antok ta, “Pua, kag igenen madot luai ta IAVE, ka saka roron an vanang kam atautauia anig sipo kovek i nat akorong ke tatag. Igenen asi la atogon ani tauia ang emung ig, kana na Elieser i Damaskus. ");
INSERT INTO lcm_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Parik kuta lapa alis nat anig. Asukang nganing na asosokai ke i nei kag lu kavla tauk nganlak i tauia aongos ang. ");
INSERT INTO lcm_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Au na kalingana i IAVE kala serei singina ta, “Parik. Igenen ang nang parik kamepa atogon a tauia ang. Naka alis ua nang ta kakam ta ring nat akorong, ani ninia ka tauk i kam tauia emung im.” ");
INSERT INTO lcm_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Le na kala asoung na Abaram ane komo na kala antok ia, “Au kanat, ku tarak alak ane metekuku na ku tataot kotok na mamain ta kalto aongos suke - io, man kupo angkoai si tataot aniria. Longong, kam matan inatus vanang emung im ki serei asukang ta keve kalto suke.” ");
INSERT INTO lcm_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Na Abaram kala lomlomon ta mengen ang si IAVE. Asukang na IAVE kala taot ia ta kapo igenen korong e matana. ");
INSERT INTO lcm_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Na kala antok ia, “Nau a IAVE nata asoung ua pelek a Ur nei liuan i ri Kasdim, asi kag alis anim ta palpal roe ke ani ku tauk ina.” ");
INSERT INTO lcm_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Sikei kala antok, “Kag volava ta IAVE, na saka malangas an vang ta nalapo tauk ina?” ");
INSERT INTO lcm_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Na kala antok ia, “Ku an luk le anig ta sikei a bulumakau aina tanginang na sikei a meme na sikei a sipsip tauan, siksikei ka atogon kana potol a matas ila to, na kapa ta sikei a uk na sikei a maniangui tanginang.” ");
INSERT INTO lcm_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Na kanla luk aongos iria na kamela lamdek angpal iria na kala amatung angpalpalai ani ngono palpal iria, sikei si ngono mani ang parik kapa lamdek angpal irilong. ");
INSERT INTO lcm_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Na ri mani lava kime lapo karau na keve bil i lamut ang, na Abaram kalapo lulu suai aniria. ");
INSERT INTO lcm_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Au, kalapo sin ariri na makarap na buk rot lava kala lukluk na Abaram na kala rot punuk. Na mangsikei a vuk vong taremaras kala pakut aongos ia. ");
INSERT INTO lcm_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Na IAVE kala antok ia, “Kana vang ku nas aro ta keve matan inatus emung im kian ago i sokoung si mangsikei a rina parik ta kakaria akorong. Na ani 400 na matas aongos ki akeke tataria na ki ago si vilvil akui. ");
INSERT INTO lcm_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Sikei naka amiming lak na palpal vap ang kianla ago aisog neite kui singina, na taun ki soung pelek na ring ang ki soung veai ani tauia tavirimok. ");
INSERT INTO lcm_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Sikei numai kuan sinong lavan aro luai le na kian amunai anim vang ve keve tivum. ");
INSERT INTO lcm_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Au, puat a polpolokan ki kun mamat suai tapai na keve matan tivum kila papok ane ke. Ka asukang ke using a keve lau rikek ang si ri Amor ka serei arikek aliu lak le na kila soung suai.” ");
INSERT INTO lcm_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Au, makarap kala siang luai na kalapo vong aongos, na mangsikei a avubus kala serei na bung kapo soung le neina na mangsikei a sulu kapo ureurek alava. Bil ke kanla pasal aliu nei liuan i keve vuk angpalpalai i keve manmanik i putuk ang. ");
INSERT INTO lcm_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Si taun ang akorong vanang IAVE kala atung kana palpalatung ve Abaram. Kata mengen asukang ke, “Naka alis kam matmatan inatus ta vuk roe aongos ke le si sung ang i Aigipto tung si sung lava ang i Euparates - ");
INSERT INTO lcm_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","roe ke, kana na keve palpal vap ke kipo ago singina: ri Ken, ri Kenis, ri Kadmon, ");
INSERT INTO lcm_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ri It, ri Peris, ri Repa, ");
INSERT INTO lcm_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ri Amor, ri Kanan, ri Girgas na ri Iebus kapa.” ");
INSERT INTO lcm_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Au, Abaram katapo kovek i nat using a kisngana ta Sarai parik katapa ingus korong ta kana nat. Sikei Sarai katapo atogon a mangsikei a ainan asosokai le Aigipto kana asan ta Agar. ");
INSERT INTO lcm_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Asukang na kanla serei si Abaram na kala antok ia asukang ke, “IAVE nang kapo tav ainak anig si atogon nat. Asukang na napo buk ua ani kuan rot ve kag asosokai. Le si nat ang nala kun angkoai asi asereai ani mangsikei a patvap.” Au, Abaram kala auai ve lomlomonai ang si Sarai. ");
INSERT INTO lcm_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Si taun ke kalapo sangauli na matas kana ago e Kanan na Abaram. Au na Sarai kala songo le kana ainan asosokai na kanla atatung ia si Abaram ani ka ago ve nia asukang ta kana aina. ");
INSERT INTO lcm_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Io, na kala rot korong ve nia na kala atogon kana sungsungukan. Au, taun ang kala nas ta kalapo atogon kana sungsungukan ta Abaram, kalapo uli kiming na kurek ani Sarai, aina po tauk ang una. ");
INSERT INTO lcm_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Au na Sarai kala antok a Abaram ta, “Numai kana kupo tukulai i mese ke nalapo paus ia. Nata alis ua ta kag asosokai ani kuan ago ve nia. Au na kana using kalapo nas ta kalapo atogon sungsungukan le singim, kalapo kiming iau. Pua, kapo ro ani IAVE ka arai nei liuan irung ta si kapo korong.” ");
INSERT INTO lcm_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Na Abaram kala antok ta, “Apua, aina ang apok kapo kakam ta asosokai na kapo matung e kungam ta ku abis a sa kupo lomon ia ta kapo roron singina.” Asukang na Sarai vanang kala bil arikek si Agar tung si kala sip ania. ");
INSERT INTO lcm_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Au, Agar kanla sip ane nei ring varasai palau na eiang angelo si IAVE kamela serei singina ngere mang vuk laman lik ipo uv alak le nei roe. Laman ang kapo matung atava na selen ang ane Sur. ");
INSERT INTO lcm_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Au, angelo ang kala antok ta, “Agar, asosokai ke si Sarai, kuta pasal le voi kana? Na nei a ring ang kupo pasal taun ia?” Na kala antok ta, “A, nang napo sip nang ani tauk ug ta Sarai.” ");
INSERT INTO lcm_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Au na angelo ang si IAVE kala antok ia asukang ke, “Papok akorong ane si taukum na ku lis aongos ua neite kana sausaupai. ");
INSERT INTO lcm_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Naka asereai aduk lak ani keve matan inatus emung im ani ki kun duk luai tav angkoai si taot.” ");
INSERT INTO lcm_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Au na angelo ang si IAVE kala mengen kapa ia ta vuk mengen ke, “Kana kulapo ago veai ani sungsungukan na nganlak kula ingus kam nat. IAVE katala longong kam mamakus, na asukang vang ku atuk a nat ang ta Ismael. ");
INSERT INTO lcm_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Nat ang ka asukang val dongki loi. Dual i kungana nganlak ka angsualai ve vap miang, asukang palau val dual i kungaria i ri vap ka kun angsualai kapa ve nia. Kana to ka to i anggegelai ve keve tasina akorong pok.” ");
INSERT INTO lcm_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Na Agar kala antok ta, “Kana vang natala arai akorong ani Voiang kapo arai anig.” Le si vuk mengen ang vanang na kala atuk a IAVE vopo mengen ang singina ta, “Numai a God ang kupo arai anig.” ");
INSERT INTO lcm_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Asukang vanang na vuk laman ang kita atuk ia ta Ber Lai Roi. Laman ang si taun ke kapo matung lak nei liuan i Kades na Bered. ");
INSERT INTO lcm_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Io, na si selen ke vanang a Agar kata ingus nat ani Abaram. Na Abaram kala atuk a nat ang ta Ismael. ");
INSERT INTO lcm_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abaram kata lapo 86 na matas na Agar kala ingus a Ismael. ");
INSERT INTO lcm_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Au, Abaram kalapo 99 na matas na IAVE kala anguan tutu aserei an singina na kala antok ia ta, “Nau kana na God Kitmat Luai. Ku pasal ta pasal kapo korong e matag na ka ago ta visuk ka lak ua. ");
INSERT INTO lcm_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Naka vil akit kag palpalatung nei liuan irung na nala asereai alava luai ani kam keve apolokai.” ");
INSERT INTO lcm_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abaram kata longong a bil ke na kala soturungai ane kevkev luai. Na God kala antok ia ta, ");
INSERT INTO lcm_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Kakag vang kana ta palpalatung ve numai. Numai ku serei a tamaria i keve palpal vap miang luai. ");
INSERT INTO lcm_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ki aulei ta songo anim ta Abaram. Kana nala atuk ua ta kam asan tanginang ta Abaraam, using natala asereai anim a tamaria i mamain ta palpal vap. ");
INSERT INTO lcm_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Naka alis ua ta matan vap lava luai, na le singiria ri vosap ki tapasuk atung. Ku atogon ta matan tivum lava luai na nganlak kila asereai ani ri palpal vap miang e kuli rina ke. ");
INSERT INTO lcm_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Nala amatung a palpalatung ke ve numai ani ka tung atokos luai nei liuan irung na keve matan tivum ki serei emung im, na ani polpolokan tanginang lak ang kapa. Io, ka asukang ke ta ku uli atogon anig val kam God na asukang kapa si keve matan tivum e mung im lak. ");
INSERT INTO lcm_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Roe ke e Kanan kupo ago asukang ta sokoung singina, nala alis anim ve keve matan tivum emung im ani kala kakami asikei. Na riria kapa, ki atogon iau val kari God.” ");
INSERT INTO lcm_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Na God kala rodo kana mengen taun a Abaraam asukang ke, “Na anim vang akorong, ku tung akit si palpalatung ke napo amatung ia ve numai na keve matan tivum emung im, si mamain ta polpolokan aliu. ");
INSERT INTO lcm_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Kana vang na palpalatung ke ve numai na keve matan tivum emung im. Palpalatung voike mi teng akit luai singina. Asukang ke vang: Keve nat tauan aongos kipo serei nei liuan imi, mi lampulit iria. ");
INSERT INTO lcm_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","12","Le si taun ke mi uli lampulit ani ri nat tauan aongos, si va limaletul i taun emung i ingus aniria. Lampulit ke ka asukang val akanangai i kag palpalatung ve numai na ka pakut aongos na ri si kipo ago neite kam aiveven asukang ta ri asosokai na matan asosokai ang mita samui iria le si mang matan vap petekai - io matan vap ang nang parik nami akorong mitapa asereai aniria. ");
INSERT INTO lcm_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Teng akit a mengen ke. Kantanem kita serei eiang si kam patvap akorong vo kuta samui iria ta kam kapkap, riria aongos lak asi lampulit. Akanangai ke ka serei si pukunimi asukang ta tokos luai i palpalatung. ");
INSERT INTO lcm_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Io, na saka nat tauan an e nei liuan imi parik kapa siang si bil ke, asi kirikai suai ania pelek kana vap. Using nang kalapo vil putuk na kag palpalatung.” ");
INSERT INTO lcm_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God kata mengen kapa na Abaraam ta mang vuk mengen asukang ke, “Ani kisngam ta Sarai, kula aulei kana ta songo ania ta Sarai. Kana nala atuk ia ta asan tanginang ke, Sara. ");
INSERT INTO lcm_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Naka atautauia lak ia na ka kun ingus akorong ani kamilong nat. Na eiang kam aina ka kun serei a tivuria i keve palpal vap miang na ri vosap kapa ki kun tapasuk le si keve matan tivuna emung ina.” ");
INSERT INTO lcm_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Au, Abaraam kala soturungai na kala los. Na kalapo antok musik singina pok ta, “Iau? Kapo koi lak nang ta igenen lapan val nau, 100 na matas i to, ka atogon nat lak? Pua, kapo angkoai lak nang ta Sara ka ingus si lapo 90 na matas ke?” ");
INSERT INTO lcm_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Le na kala antok a God ta, “Au si sa, kapo ro nang ta Ismael ka luk kam atautauia.” ");
INSERT INTO lcm_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Au na God kala antok ia, “Kapo ro nang, sikei kisngam ta Sara ka ingus lak ta kam nat na ku atuk ia ta Isak. Na le singina nala teng akit kag palpalatung tung si keve matan tivuna kapa emung ina. Io, kapo palpalatung asi tung atokos luai. ");
INSERT INTO lcm_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Au na ani Ismael, kapo ro natala longong ua. Na kun atautauia ania. Ninia ka kun serei aduk luai si kana keve apolokai na ki polok alava si kari tataot. Ka serei a tamaria i 12 na tu ainoinoai na naka kun asereai ani keve matan tivuna emung ina ani ki serei a palpal vap lava luai. ");
INSERT INTO lcm_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Sikei, si palpalatung ke singig, na asereai ania si Isak, nat ang na Sara ka ingus ia anim si vuk taun asukang ke si matas ang eno.” ");
INSERT INTO lcm_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Au, God kala kamus ta angmemengenai ve Abaraam na kala palak alak pelek ia. ");
INSERT INTO lcm_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Na si taun ang akorong pok Abaraam kata songo kana nat Ismael na keve nat i serei ang si petau i kana po aiveven ang na vap i kana samui ang ta kana kapkap akorong na kala lampulit aongos iria val God katala pinipini tapai ania. ");
INSERT INTO lcm_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ninia akorong na Abaraam kata lapo 90 na matas aongos taun kita lamut ia. ");
INSERT INTO lcm_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Na kana nat ta Ismael katapo 13 na matas. ");
INSERT INTO lcm_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ngono angtama aongos kilongta auauai lampulit si sikei palau a taun. ");
INSERT INTO lcm_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Io, asukang vanang na keve nat tauan aongos neite aiveven ang si Abaraam, vap i nei lu na vap i kana samui ang, kita auauai lampulit ve nia Abaraam. ");
INSERT INTO lcm_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Si mangsikei a tenei ias lava Abaraam katapo sinong e mete takaman i kana lu ngere keve ei gogoai ang si Mamre, na IAVE kala serei singina. ");
INSERT INTO lcm_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abaraam katan tarak alak na kala arai ani potol a igenen kitolpo tung e ring vunga lik. Vuk taun ang kala arai aniritol, kala tapasuk sumasuma palau pelek a mete kana lu na kala sang asian ruduai aniritol. Kanla soturungai ane vunep ");
INSERT INTO lcm_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","na kala antok, “Kala ro luai, kag igenen tauia! Napo sokotuk imitol ani mitol ago ta pasal liu luai an palau asukang ke. Napo ago kana si pakangai animitol. ");
INSERT INTO lcm_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tol kokoai na nan luk laman le asi me galui ani kakimitol, le na mitol sinong ausai tapai neite ei ke. ");
INSERT INTO lcm_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Io, ta kamitol men pok lik kapa asi akikit animitol si paspasal ang. Tol sinong aro, naka pakangai nang animitol.” Na kitola antok ta, “Kapo ro. Ku abis ia val kutala posong ia.” ");
INSERT INTO lcm_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Asukang na Abaraam kala sumasuma alak pok ane nei lu na kanla atai a Sara ta, “Au iuang, ku sumasuma palau ta potol a pakut i palaua roron luai na ku itoiton ta rukun saui.” ");
INSERT INTO lcm_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Le na Abaraam kala sang sumasuma ane nei liuan i kana takaman vongo na kanla pilak a mangsikei a natnat ngoknok tanginang ro lik i vulumakau. Kala alis ia si mangsikei a asosokai eiang asi kana an itoiton na vil amoso ania. ");
INSERT INTO lcm_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Au na kanla luk na mang keve bil asi amomoi saui na keve susu. Kamela luk tul na avus ila itoiton amoso ang na kala sasagi ani volo tanganu ang. Taun kitol lapo angan, nia na Abaraam kanlapo tung neite mang iei eiang. ");
INSERT INTO lcm_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Na kitola sui ia, “Au na nei a ri kisngam evoi ta ri Sara?” “Nang riria e nei lu.” ");
INSERT INTO lcm_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Au, kala antok ta, “Si vuk taun asukang ke akorong si matas ang eno, namela serei pok singim, na ri kisngam ki atogon kari nat.” Si vuk taun ke akorong Sara katapo tung e mung ina i kokolongong e mete takaman i lu. ");
INSERT INTO lcm_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Sikei rilong aongos ve Abaraam kilong talapo lavan luai na Sara akorong katala polo soliu kana taun i atogon nat. ");
INSERT INTO lcm_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Asukang vanang na taun kata longong a mengen ke kata los musik lik na kalapo lomlomonai ta, “Pua, nalapo piluk luai na kag tauan kalapo kun lavan akorong vang. Kala saka angkoai an anig si atogon ani bil miminaungan ke?” ");
INSERT INTO lcm_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Sikei IAVE kala sui a Abaraam ta, “Au, marai sa vanang na Sara kapo los na kapo antok ta parik kapa koi ia kana si atogon nat si lapo lavan? ");
INSERT INTO lcm_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Au nei? Nau kana na IAVE. Sa vanang kapo kitmat anig si abis ania? Name serei lak singim si taun i kag la atutung si matas ang eno na Sara vang ka atogon ta kana nat.” ");
INSERT INTO lcm_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sikei Sara kalapo leng lik pulakai na kala kapau ta, “A, parik nang natapa los.” Sikei IAVE kala polpol ia ta, “Io, kapo tutuman luai ta kuta los.” ");
INSERT INTO lcm_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Au, volo igenen ke kitol lapo tapasuk asi pasal na kitola tung si tere asiang tapai ane Sodom. Abaraam katapo auai asi an atatung aniritol. ");
INSERT INTO lcm_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Na IAVE kalapo lomlomonai ta, “Au sa, naka amunai ani Abaraam kana ta sa napo buk asereai ania? ");
INSERT INTO lcm_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abaraam lak nang ka serei a tamaria i palpal vap madot na tavirimok luai. Na eiang a mamain ta palpal vap aongos e kuli rina ki luk kari roron le singina. ");
INSERT INTO lcm_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Using nau natala pilak ia ani ka tu ainoai ani kana inatus na keve matan tivuna e mung ina ani ki teng akit si kag keve laulauan si selen ke ta ki asereai ani aisoisogan kapo marip na kapo korong. Na eiang nau a IAVE nala asereai atutuman ani kag palpalatung ve Abaraam.” ");
INSERT INTO lcm_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Au na IAVE kala antok ta, “Keve atatai ke natala longong ia i Sodom na Gomora kapo tavirimok luai. Rikek ang kipo siang neina kapo mitmitikan luai. ");
INSERT INTO lcm_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Asukang na nan pasiang tapai ane iang na nan kun arai akorong ta matag ta sa natala longong ia nia kapo tutuman val atatai anig. Man parik kapa tutuman, naka luk na nas ang eiang kapa.” ");
INSERT INTO lcm_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Au, mang ngono palua rilong kilongla kik putuk sian pasiang ane Sodom, sikei Abaraam kala sikei a tung an eiang e matana i IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Na kan pataun ia na kala sui, “Au si ku gal suai kapa nang ani mang matan vap korong kuvul ve keve vap rikek aongos suke? ");
INSERT INTO lcm_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kapo sa singim ta man ka atogon ta 50 na igenen korong e nei rina ang? Sa, ku gal suai lak ani rina ang? Sa, parik ta anangnangai ania using a 50 na igenen korong ang kipo ago singina? ");
INSERT INTO lcm_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Kapo tav angtunganan luai anim si abis ani bil asukang ta kula raung kuvul na ri vap korong ve ri vap rikek asukang pala val kipo rikek aongos. Pua, parik kapa angkoai nang! Sa, parik ta Katakai i Saupai i kuli rina ke ka abis a lau kapo angkokoai? ");
INSERT INTO lcm_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Na IAVE kala antok ta, “Man nala sabonai ta 50 na igenen korong e Sodom, nala anangnangai ani rina aongos ang using palau iria. ");
INSERT INTO lcm_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Na Abaraam kala anguan luklukai an ta, “Pua, using ko nalapo kavakavalak ua si mengen korong ve numai, IAVE, igenen palau i mutep na vuta ke tatag, kapo koi si na sui ta ");
INSERT INTO lcm_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","man a tatot ang kala uak ta palpalima sa, ku vis punuk suai lak ani nei rina ang?” Na IAVE kala antok ta, “Parik, man na sabonai kapa ta 45 na igenen korong eiang, nala tav vil arikek ania.” ");
INSERT INTO lcm_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Le na Abaraam kan luklukai pok ta, “Au na man a 40 palau kipo ago eiang, sa singiria?” Na kala antok ta, “Ani 40 na igenen ang kapa, na ago ta vil arikek ani nei rina ang.” ");
INSERT INTO lcm_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Na Abaraam kala antok, “Au, kanat. Kapo ro ani IAVE ku ago ta songag an anig, sikei napo atogon lak a mang susui ta man kala 30 na igenen palau ki ago eiang, kapo sa singim? Na kala antok ta, “Na tav bil arikek lak kapa man ta 30 na igenen korong na sabonai aniria eiang.” ");
INSERT INTO lcm_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Na Abaraam kala antok ta, “Pua, using ko nalapo kavakavalak ua si mengen korong ve numai, IAVE, sa si man a 20 na igenen palau kula sabonai aniria eiang?” Na IAVE kan polpol ia kapa ta, “Ani 20 ang kapa na tav vil arikek ani nei rina ang.” ");
INSERT INTO lcm_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Na Abaraam kala antok ta, “Au, kanat. Kapo ro ani IAVE ku ago ta songag an anig, sikei napo atogon lak kag akamusai luai i susui. Ka sa akorong man kula sabonai ani sangauli palau eiang?” Na kala polpol ta, “Ani sangauli palau ang kapa, na ago ta vil arikek an ani nei rina ang.” ");
INSERT INTO lcm_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Au, kan kamus na angmemengenai ke si IAVE ve Abaraam na kala papelek ia. Na Abaraam kala kun papok ane si kana vainagoan. ");
INSERT INTO lcm_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Si vuk pangau ke, ngono angelo ang kilong anla serei e Sodom si kalapo sagup a makarap. Na Lot, nia katapo sinong mete takaman alak ane nei rina ang. Taun kata arai anirilong kala tapasuk atung na kanla tu ruduai irilong. Kala soturungai ane vunep na kala antok, ");
INSERT INTO lcm_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","“Au, ngono igenen tauia, milong pasal asukang ke ane si kag lu. Napo ago kana si pakangai animilong. Long palak na milong galui a keve kakimilong. Io, kapo ro ani milong ago tapai ani vong ke singig na tenei vauk lak milong tapasuk using kamilong paspasal.” Na kilongla antok ia ta, “Parik, atalipai animemlong na namemlong an matung ausai e nei ring kalakala suke i nei rina ke.” ");
INSERT INTO lcm_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Sikei Lot kalapo sunggil luai anirilong na kilongla longong ia. Asukang na kanla itoitonai ani rukun saui anirilong, na kilongla angan. ");
INSERT INTO lcm_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Au, kitola buk an matung ausai na ri vap tauan aongos i keve vuk palpal lik i nei rina ang i Sodom kimela tung aulit na lu ang, vap tanginang na lapan iria aongos. ");
INSERT INTO lcm_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Na kila songo alak ane si Lot ta, “Au iuang, nei a ngono vopo serei vong ke singim anginang? Ku songo asoung irilong ani namem me rot tapai ve rilong.” ");
INSERT INTO lcm_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Au, Lot kala soung ane singiria, na kala akang akit pok a takaman emung ina ");
INSERT INTO lcm_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","na kala antok ta, “Keve tungag, ka ago luai. Mi ago ta abis an ani lau visuk ang. ");
INSERT INTO lcm_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Arai, kag ngono kavulik kilongpo tav nas lak ani ri tauan. Nan songo le irilong ani mi akeke tatarilong val kam vubuk, sikei si ngono igenen ang, mi ago luai ta abis an ta mangsikei a bil singirilong. Kilongpo ngono sokoung nang na napo aiveven irilong e nei kag lu.” ");
INSERT INTO lcm_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Sikei kila vas ia ta, “Ai, ku pasal suai ani mete takaman ang!” Na kila angmemengenai pok singiria asukang ke, “Igenen ke kata kun serei sokoung eke singira na kana kalapo buk ani ka vil saupai anira.” Na kila taong ia ta, “Man parik nganing kupa alis tatarilong, namem bil arikek luai singim soliu na sa namem abis ia si ngono iuang.” Na kilapo porot alava luai ani Lot na kila aingik asung sian nui galang ani takaman. ");
INSERT INTO lcm_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Sikei, ngono igenen e nei lu ang kilongla sulai asoung ani kungarilong na kilongla tak alak pok a Lot ane nei lu, na kilongla akang bat a takaman. ");
INSERT INTO lcm_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Na kitmat irilong kala vil aba na vap aongos ang e komo, tanginang na lapan iria. Na parik kilapa angkoai si sabonai korong ani mete takaman i lu ang. ");
INSERT INTO lcm_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Au, ngono igenen ang kilongla sui a Lot ta, “Au, kupo atogon kam mang keve angtogon eke? Matan inatus im, vo keve almum, vo si eke pulakai kapo angasungai im? Man ka atogon, songo suai aongos aniria ");
INSERT INTO lcm_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","using namemlong lapo usausa nang si vis punuk suai ani rina ke. IAVE katala longong na keve mengen i atatai ania na kala asok imemlong si me vis punuk suai ania.” ");
INSERT INTO lcm_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Au, Lot kanla soung ane komo na kanla mengen amalangas na ngono almuna ila pala si osongon ani kana ngono kavulik ta, “A, ngono iuang. Long sumasuma palau na milong pasal suai using IAVE nang kalapo usausa si vis punuk suai ani rina ke!” Sikei ngono almuna kilongpo lomon ia ta kapo kapau. ");
INSERT INTO lcm_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Au, kalapo malas alak a tangat na ngono angelo ang kilongla asum a Lot ta, “Ku sumasuma nang! Ku songo na kisngam na kam ngono kavulik suai ani ring ke sumasuma palau. Mi abis vei mila kun puka arikek man namemlongla amiming a rina ke.” ");
INSERT INTO lcm_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot kalapo tung i susugul lik, sikei ngono igenen ang kilongla tak le na kungana i Lot na kana volo angnanan na kila pasal suai tataria pelek na nei rina ang ani kian kalakala, using a IAVE kata ngorem na angtama ke. ");
INSERT INTO lcm_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Na taun ang kime lapo ago e komo i rina ang mangsikei irilong kala antok iria ta, “Au, mi sip suai ta kami keve to! Ka ago luai ta sikei ka tere pok ane mung vo ka tung ausai pulakai eiang nei ring marul ang! Mi sip alak sumasuma ane kuli mulang vei mamaiten ke kala kun luk animi.” ");
INSERT INTO lcm_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Sikei Lot kala antok irilong asukang ke, “Ai, parik kag ngono igenen tauia. ");
INSERT INTO lcm_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nau kana kamilong asosokai. Na milong tala lomon alava luai anig lenginang na milong tala akalit amalangas ta kamilong ngorem taun anig si sa kana milong tala abis ia singig. Sikei parik nang napa angkoai si sip taun ani keve mulang suke. Mamaiten ke nganing kala kinkos iau na nala mat. ");
INSERT INTO lcm_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Milong arai, kapo atogon sukana na mang vuk rina angasungai angkoai si nala sang taun ia. Kapo vuk rina roron lik nang, ingko? Io, asukang vanang parik nalapa angkoai si na mat.” ");
INSERT INTO lcm_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Na angelo ang kala antok ia, “Au kalaro, nala ainak ani kam sokotuk ke kapa. Vuk rina lik ang kupo mengen tatana nala kun ago ta vil arikek an kapa ania. ");
INSERT INTO lcm_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Sikei kana ku sang sumasuma tapai ane iang. Using parik napa angkoai si bil ta sa lak tung kuanla serei aro e suke. Au, eiang vanang na kita atuk a vuk rina ang ta Soar. ");
INSERT INTO lcm_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Au, Lot kanla kinkos na nei rina e Soar na lenginang a makarap kalapo sinlak. ");
INSERT INTO lcm_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Le vanang, IAVE akorong e metekuku kala vekai asiang ani iat nini val langit e kuli Sodom na Gomora. ");
INSERT INTO lcm_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Sukana vang IAVE kata vil galang luai ani ngono rina ang kuvul ve palpal aulitai ina aongos. Ri vap aongos na keve suksukalan aongos kapa kala kamus aongos. ");
INSERT INTO lcm_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Sikei, kisngana i Lot kata tere pok ane mung na pukun ina kala iat. ");
INSERT INTO lcm_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Si tenei vauk lik using ina palau, Abaraam kata tapasuk na kala pasal taun na ring ang kilong tapo angtung anongo ve IAVE singina. ");
INSERT INTO lcm_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Kanla tun asiang ane Sodom na Gomora na palpal lava aongos ang. Na kala arai palau ani bung miting lava sipo sang lak le si vuk vunep ang. Bung ang katapo asukang val bung i nei ring ipo ani aen. ");
INSERT INTO lcm_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Io, taun ang na God kata ani na ngono rina lava ke, katala lomon pok na Abaraam asukang na kata asoung na Lot pelek a mamaiten i ngono rina ke katapo ago singina. ");
INSERT INTO lcm_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot kalapo leng ani ago e Soar, asukang na kala tapasuk ve kana ngono kavulik taun na kuli keve mulang ang eiang na kanla soi sinong si mangsikei a vakil. ");
INSERT INTO lcm_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Au, tulava i ngono angtasimal ke kala antok a tasina lik ta, “Tamarung kana kalapo lapan paspasal na kapo kovek i tauan asungai eke si la ago kuvul ve tarung, val kapo laulauan i kuli rina ke. ");
INSERT INTO lcm_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kume na tarung an ainum na tamarung ta vaen. Man kala nio, tarung rot ve nia ani patmani ke ka uli ago akit le si tamarung.” ");
INSERT INTO lcm_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Au, si tenei vong ang kilongla ainum a tamarilong ta vaen na kavulik aino ang kala rot ve nia. Taun katan matung le na ka tapasuk pok, Lot parik katapa nasai ani sa. ");
INSERT INTO lcm_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Au, si taun using ina na kavulik ang kala antok a tasina lik ta, “Anginang vong natanla rot le ve tamarung. Nganlak vong tarung anguan ainum an ania, na kuan palak na ku rot tapai ve nia. Si selen ke kara patmani ka uli ago akit le si tamarung.” ");
INSERT INTO lcm_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Asukang na si tenei vong ang kapa kilongla ainum a tamarilong, le na kavulik emung kala kun palak sian rot ve nia. Na taun katan matung le na ka tapasuk pok, tamana parik katapa nasai ani sa. ");
INSERT INTO lcm_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Asukang na si selen ke kana ngono kavulik na Lot kilongtala sungsungukan le si tamarilong akorong pok. ");
INSERT INTO lcm_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kavulik aino ang kata ingus kana nat na kala atuk ia ta Moab. Na Moab vanang kapo tamaria i ri Moab i taun ke. ");
INSERT INTO lcm_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Au, anu emung kala kun ingus kapa ani kakana ta kun nat na kala atuk ia ta Ben Ami. Na Ben Ami vanang kapo tamaria i ri Amon i taun ke. ");
INSERT INTO lcm_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Au, Abaraam kala pasal taun a palpal Negev na kanla ago tapai e Gerar, nei liuan i Kades na Sur. ");
INSERT INTO lcm_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Na eiang kan posong ta Sara kapo tauna. Au na Abimelek, vosap i Gerar, kala asok tapai ani Sara na kala osongon ia. ");
INSERT INTO lcm_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Na God kala serei vong si Abimelek nei orodung na kala antok ia asukang ke, “Numai vanang asi mat using kutala songo na aina vopo osongon ke.” ");
INSERT INTO lcm_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimelek lak parik katapa pasal asungai ani aina ke. Asukang na kala sui ta, “Au Volava. Sa? Ku vis punuk suai animem na matan vap korong ke? ");
INSERT INTO lcm_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Sa? Parik ta Abaraam akorong kata posong ta kapo tauna? Parik ta nia na aina ang akorong kata kun posong ta kapo tauna i Abaraam? Abis ang nata abis ia, kata tapasuk le si lomlomonai daus. Kungag kapo daus luai si maiten ke.” ");
INSERT INTO lcm_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Na God kala antok ta, “Io, napo malangas ta kuta abis a lau ke le si lomlomonai daus. Asukang na parik natapa atalipai anim si kam la bil arikek ane singig. Katapo tukulai ina vanang parik natapa atalipai anim si sigil ania. ");
INSERT INTO lcm_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kana vang ku asok pok a aina ang taun kana tauan akorong, using tauan ang nang kapo katakai i kusatung, na nganlak kala sokotuk anim na kula to. Sikei man parik kulapa lis pok ia, ku nas atutuman ta numai na kam patvap asi mamat aongos.” ");
INSERT INTO lcm_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Si tenei vauk lik palau i taun using ina Abimelek kala songo akuvul kana keve ainoinoai na kala atatai iria ta sa kata serei singina na riria aongos kila anglengai alava luai. ");
INSERT INTO lcm_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Na Abimelek kala songo alak tapai ani Abaraam na kala antok, “Au sa kana kuta abis ia singimem? Nata abis a saka rikek akorong an na kume songo mamaiten na mese taun imem ve matan vap ke kipo ago neite kag saupai? Kutala abis a lau ang singig voiang parik kapa angkoai luai si abis ania. ");
INSERT INTO lcm_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nei akorong a tukulai i kam abis ani lau ke?” ");
INSERT INTO lcm_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Na Abaraam kala antok ta, “Parik. Natapo lomlomonai musik lik nang ta kapo ararai asukang ke ta ri vap i ring ke parik kipa mamaila ani God na kapo angkoai luai ta ki raung iau using ani kag aina. ");
INSERT INTO lcm_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Au na ngerena kapo taug tutuman kapa using kapo mang kavulik ke mamai sikei rinana kipo petekai. Asukang na nala osongon ia. ");
INSERT INTO lcm_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Na taun ang na God kata songo suai anig pelek na vainagoan si mamai, nala antok ia asukang ke, ‘Si keve ring tarung pasal ia, ku antok ri vap ta nau napo taum. Si selen ke ku akalit ta kam vubuk anig.’” ");
INSERT INTO lcm_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Au, Abimelek kala songo aiton na mang keve sipsip na mang keve vulumakau na mang keve tauan na ainan asosokai ani ke Abaraam iria. Au na kala asok aliu pok na Sara ane si Abaraam akorong pok. ");
INSERT INTO lcm_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Na kala antok ia ta, “Kag roe aongos kana kapo oros e malangas i matam. Pilak ta kam ring na ku ago singina. ");
INSERT INTO lcm_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Na kala antok a Sara asukang ke, “Kana napo alis a taum ta kapkap lava luai ke asi pakut bat ani lau rikek ang natala abis ia ane singim. Na ani vap ang ve numai ki nas ta kupo kalakala luai si lau rikek.” ");
INSERT INTO lcm_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Na Abaraam kala sokotuk a God ani ka atautauia pok na Abimelek ve kana aina na kana keve ainan asosokai ani ki atogon nat pok ");
INSERT INTO lcm_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","using God katala vil bat aongos a keve lu i nat si keve aina aongos nei kana vainagoan a Abimelek le si Sara, kisngana i Abaraam. ");
INSERT INTO lcm_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Au si vuk pangau ang, IAVE kala arai ani Sara na kala atautauia ia val kata palatung. ");
INSERT INTO lcm_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Na Sara kala sungsungukan na kala ingus a mangsikei a nat ani Abaraam. Abaraam si taun ke kata lapo lavan singina, au na nat ke kita ingus ia si taun ang akorong a God kata atatai a Abaraam tatana. ");
INSERT INTO lcm_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Na Abaraam kala atuk a nat ang ta Isak, nat ang a Sara kata ingus ania tatana. ");
INSERT INTO lcm_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Na Isak kalapo limaletul kana taun i to. Au, Abaraam kala lampulit ia val atatai ang si God. ");
INSERT INTO lcm_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abaraam kata lapo 100 na matas aongos si taun ke kita ingus kana nat singina. ");
INSERT INTO lcm_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Na Sara kala antok ta, “Pua, God katala lis iau ta bil asi kag los maramarak singina, na man a ri si ki longong kana ta sa kalapo serei singig, ki kun los kuvul ve nau.” ");
INSERT INTO lcm_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Na kala rodo na mengen ang, “Si pat kana ka angkoai si antok ani Abaraam ta Sara kapo koi si atutus nat lak? Sikei kana, si lapo lavan luai ke tatana, natala ingus korong a nat ke ania.” ");
INSERT INTO lcm_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Au, nat ang kala polok alak tung si kalapo angan korong na Abaraam kala teng a matan angan lava i posong ro singina. ");
INSERT INTO lcm_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sikei, Sara kala arai ta nat ang ainan Aigipto ke kata ingus ia ani Abaraam kapo kuskurek, ");
INSERT INTO lcm_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","na kala antok a Abaraam ta, “Ku kirikai suai ani ainan asosokai suke ve kana nat using parik luai ta nat vo serei si asosokai ang kame angpagal ta togtogon ke ve kag nat.” ");
INSERT INTO lcm_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Na Abaraam kalapo mamakus alava si lomlomonai ke using nat ang kapo kana nat kapa. ");
INSERT INTO lcm_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Sikei, God kala antok ia asukang ke, “Ku ago ta mamakus luai an ani kam nat na ainan asosokai ang. Longong palau ta sa nang a Sara kapo mengen ua tatana, using le si Isak akorong vanang, au matan tivum emung im ki atogon asan. ");
INSERT INTO lcm_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Au na ani nat ang si ainan asosokai ang, using kapo kam nat kapa, nala kun apolokai ani kakana ta matan vap akorong.” ");
INSERT INTO lcm_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Au na si tenei vauk using ina Abaraam kala asisiang men pok na kala luk a sikei a ese laman na kala agon ia e kalakalana i Agar kuvul ve nat ang na kala asok suai ania. Na kanlapo su pulakai si ring varasai ang e Berseba. ");
INSERT INTO lcm_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Au na taun a laman i nei ese ang kala mat luai, kala amatung kana nat neite mang ei eiang, ");
INSERT INTO lcm_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","na kala pasal akipai ane ring vunga lik na kanlapo sinong, using kapo lomlomonai ta, “Pua, parik napa angkoai si tere palau asukang ke ta kag nat si mat.” Na taun kapo sinong lomlomonai eiang kala tangis alava. ");
INSERT INTO lcm_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Na God kala longong a nat lik ang sipo tangis na kana angelo kala songosongo le metekuku taun a Agar asukang ke, “Agar, kupo sa? Ku ago ta leng an, using a God katala longong lenginang kana tangis a kam nat si ring ang kapo matung singina. ");
INSERT INTO lcm_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Longong. Ku tak atadut kam nat na ku teng akit ia e kungana. Using le singina naka asereai lak ani matan vap lava.” ");
INSERT INTO lcm_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Na God kala palas a matana na kala arai ani mangsikei a laman kapo uv le nei roe, na kanla lolong kana ese na kanla ainum kana nat. ");
INSERT INTO lcm_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Nat ke kata polok alak na God kata ago kuvul ve nia. Kana ring i ago nei ring varasai, na katapo katakai i so ta vatilau. ");
INSERT INTO lcm_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Au na taun ang katapo ago eiang nei ring varasai ang e Paran, rinana kila aosongon ia ta mangsikei a aina i Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Si taun ang ri Abimelek ve Pikol kilongmela serei si Abaraam. Pikol kapo ainoinoai i kana petau i visvis a Abimelek. Au, kilong mela serei na Abimelek kala mengen asukang ke, “Si kam keve avibisan aongos kupo abis ia, God kapo ago ve numai. ");
INSERT INTO lcm_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Asukang na napo buk ani ku atuvala e matag na e matana i God ta ku tav abis luai ta ring kapau taun imem ve kag inatus na keve matan tivug kapa. Napo buk ani ku akalit amalangas ane singig na ane si palpal vap ke kulapo ago sokoung nei liuan iria ta sikei palau a roron ang natala kun akalit anim tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Na Abaraam kala antok ta, “Io, nala atuvala tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Au, Abaraam kalapo tatapokai ani Abimelek si laman ang kana keve asosokai a Abimelek kita luk pakang ia tatana. ");
INSERT INTO lcm_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Na Abimelek kala antok ta, “Parik napa nas ta si kata abis a bil ang. Parik kapa, kutapa antok aino iau tatana. Kana palau nalapo kun longong ania.” ");
INSERT INTO lcm_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Asukang na Abaraam kala alis a Abimelek ta mang rukun sipsip na mang rukun bulumakau na kilongla abis karilong angainainakai. ");
INSERT INTO lcm_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Na Abaraam kala pagal suai ani limalengua na sipsip aina tanginang. ");
INSERT INTO lcm_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Na Abimelek kala sui ia ta, “Au, nei akorong a supsupai i limalengua na sipsip aina ke kulapo pagal suai aniria?” ");
INSERT INTO lcm_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Na Abaraam kala antok ia asukang ke, “Naung ani limalengua na sipsip ke le si kungag akorong. Ninia vang kana kapo akanangai ta nau akorong nata tep a laman ke.” ");
INSERT INTO lcm_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Le iang vanang na kila atuk a rina ang ta Berseba, using a ngono igenen ke kilongta abis karilong palapalatung i angainainakai eiang. ");
INSERT INTO lcm_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Au, emung i angainainakai ang ri Abimelek ve Pikol, ainoinoai ang ani kana petau i visvis, kilongla papok ane si palpal ang si ri Pilistia. ");
INSERT INTO lcm_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Na Abaraam kala sukal a mangsikei a ei eiang e Berseba, na ngere ei ang kala songo ane si IAVE, God To Asikei. ");
INSERT INTO lcm_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abaraam kata ago na taun vunga si palpal ang si ri Pilistia. ");
INSERT INTO lcm_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Au, si mang taun emung i keve bil ang, God kala atokngai ani Abaraam. Na kala songo ta, “Abaraam!” Na Abaraam kala ngenget ta, “Io, nau kana.” ");
INSERT INTO lcm_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Na God kala atatai ia, “Ku songo le kam ring sikei palau a nat ta Isak, voiang kupo buk alava luai ania na milong pasal ane si palpal Moria. Na si mangsikei a vuk mulang eiang nala atai amalangas ua nganlak tatana, kula sula kam nat asukang ta kam alilis ane singig.” ");
INSERT INTO lcm_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Au na Abaraam kala tapasuk tenei vabaukan lik na kala usausa dong kana dongki na kala songo na pongua i kana keve asosokai na kana nat ta Isak. Au na kala usausa kut angkoai asi an sula ani alilis ang, le na kila tapasuk taun a ring ang God katala atatai ia tatana. ");
INSERT INTO lcm_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Si vapotol i taun i kari paspasal Abaraam katan tun avunga lik na kala arai ani oring i atatai ang ania. ");
INSERT INTO lcm_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Na kala antok kana ngono asosokai asukang ke, “Au kanat, milongla aiveven kokoai vang eke ani dongki ke, na namemlong ve nat ke namemlongla pasal alak tapai ane si vuk oring suke. Namemlong an soturungai tapai, le na namemlong me papok ane singimilong.” ");
INSERT INTO lcm_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Au, Abaraam kala luk a volo kut ang na kala agon ia si kalakalana i kana nat Isak, na ninia akorong kala teng karilong vuk kut ni na karilong samele na kilong lapo auai aliu. ");
INSERT INTO lcm_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Na Isak kala antok ta, “Au, mamai!” “Au sa kag nat?” Na kala sui ia, “Vuk kut ni nang, na keve kut mat kana. Au na nei vanang akorong a sipsip tanginang asi an sula serei si God?” ");
INSERT INTO lcm_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Na Abaraam kala antok ta, “Kag nat, God akorong nia ka asereai ta ring sipsip ani alilis ke.” Le na kilongla auai kuvul alak. ");
INSERT INTO lcm_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Au na kilong anla serei si oring ang a God katala atatai tatana, na Abaraam kala solo atung a pata ipo sula serei si IAVE. Au na kala kirkirimai ani keve kut mat kuluna i pata ang. Na kala got akit kana nat ta Isak na kala amatung ia kuli keve kut ang lakat kuli pata ang. ");
INSERT INTO lcm_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Au, kala sulai ani kungana ani ka luk kana samele si lam rongok ani kana nat, ");
INSERT INTO lcm_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","na angelo si IAVE kala songosongo le metekuku, “Abaraam, Abaraam!” Na kala ngenget ta, “Io, nau kana.” ");
INSERT INTO lcm_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Na angelo ang kala antok ta, “Luk suai ani kungam si nat ang. Ku ago luai ta bil an ta mangsikei a bil singina. Kana vang nala nas luai ta kupo mamaila ani God, using parik luai kuta lapa gel iau na kula teng apok kam nat, nang kam ring sikei palau a nat.” ");
INSERT INTO lcm_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Au na Abaraam ka tun aliu na kala arai ani mangsikei a sipsip tauan kapo tuang ta kana ngono kom si mang vuk keke. Na kanla ulak a sipsip ang na kala runguk ia na kala sula ia asukang ta kana alilis serei si IAVE. Na kana nat kala kalakala. ");
INSERT INTO lcm_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Na Abaraam kala atuk a oring ang ta IAVE-ka-asereai. Tung si taun ke anginang kipo uli posong ta, “E kuli mulang si IAVE, nia ka asereai.” ");
INSERT INTO lcm_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Au na angelo ke si IAVE kala vapongua i songosongo le metekuku taun a Abaraam, ");
INSERT INTO lcm_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“IAVE kapo antok asukang ke, ‘Napo atuvala pok si asan ig. Using kutala vil korong a bil ke, na parik kutalapa teng apok kam ring sikei a nat, ");
INSERT INTO lcm_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","io, nala atautauia alava lak ua. Nala asereai ani kam patvap na ki duk luai val ri kalto i metekuku na ki miang asukang val ri kone e ngerelo, na ki vis suai aniria kipo petau iria na ki tauk nganlak i kari keve rina. ");
INSERT INTO lcm_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Au na using kutala longong aro iau, keve palpal vap aongos i kuli rina ki luk a atautauia le si kam apolokai.” ");
INSERT INTO lcm_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Le iang Abaraam kala papok taun kana ngono asosokai na kila pasal aongos pok ane Berseba na Abaraam kanla soisinong eiang. ");
INSERT INTO lcm_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Au, emung i keve bil ke kila antok a Abaraam ta, “Tasim nang ta Naor ve ri kisngana, ri Milka, kilong lapo kun atogon nat kapa. ");
INSERT INTO lcm_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Nat tuan iria kana asan ta Us. Vapongua kana asan ta Bus, le na Kemuel nang kapo tamana i Aram. ");
INSERT INTO lcm_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Au na emung i keve nat ke, Kesed, Aso, Pildas, Irilap, na kiu iria ta Betuel.” ");
INSERT INTO lcm_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel vanang, nia katapo tamana i Rebeka. Io, sukana na limaletul a nat ta ri Milka, na tamaria ta Naor, voiang kapo tasina i Abaraam. ");
INSERT INTO lcm_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kapa, Naor kata atogon a mang puat a nat le si kana ainan asosokai Reuma. Kari keve asan ta ri Teba, Gam, Tas na Maka. ");
INSERT INTO lcm_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara katala to na 127 na matas aongos ");
INSERT INTO lcm_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","le na kala mat. Kata mat e palpal Kanan si vuk rina ang Kiriat Araba, kipo kin ia ta Eberon. Au na Abaraam kamela radaupa si Sara. ");
INSERT INTO lcm_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Na kanla radaupa eiang ngere kisngana silapo matung mat ang, le na kala tapasuk na kanla mengen ri It ta mengen asukang ke, ");
INSERT INTO lcm_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Napo igenen sokoung palau kana nei liuan imi. Parik napa angtogon ve nami. Mi atos ta ring vuk roe singig asi kag la amunai korong ani matmat i kag aina.” ");
INSERT INTO lcm_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Au na ri It kila polpol ia ta, ");
INSERT INTO lcm_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Arai, kupo igenen lava luai nang na kupo asasanan e nei liuan imem. Pilak palau nei liuan i kamem keve vakil ta anu ang kupo buk ia na ku amunai ani matmat i kisngam. Ka kovek ta sikei imem ka atakun ua si saka vakil an kula pilak ia.” ");
INSERT INTO lcm_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Au, Abaraam ka tapasuk na kala soturungai taun na ri It, nang riria vap po tauk i palpal roe ang, ");
INSERT INTO lcm_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","na kala antok iria, “Au kanat, using milapo naung anig asi amunai ani matmat ke, mi longong pok tapai. Mianla mengen anig ve Eperon, nat ang si Soar, ");
INSERT INTO lcm_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","na nia ka atos singig ta vakil ang e Makpela voiang kapo tauk ina, nang a vakil vopo tung ang e ngising luai i kana vuk roe. Naka samui ia ta kapkap tapunuk aongos ina i ring ang. Ka atos tatana e malangas i matami, na kala kakag asi amunai ani matmat ke.” ");
INSERT INTO lcm_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eperon, kapo igenen i It, katapo sinong eiang nei liuan i kana vap. Au na si kari kokolongong aongos e mete takaman alak ane si kana rina, Eperon kala antok a Abaraam ta, ");
INSERT INTO lcm_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Kag igenen lava, parik. Arai, nala alis palau ua ta vuk roe ang kuvul ve vakil ang nang kapo ago singina. Kana e mataria i kag vap nalapo alis ua tatana. Pasal na kuanla amunai ani matmat i kisngam.” ");
INSERT INTO lcm_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Sikei Abaraam kala anguan soturungai an taun a vap i rina ang ");
INSERT INTO lcm_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","na kala luklukai ane si Eperon ta, “Ku kun longong tapai anig, man kupo ro? Napo buk samui nang ani vuk roe ang si kana atutung akorong. Kapo ro ani ku naung ani samui ke le asi kag la amunai ani matmat i kisngag eiang.” Ri It aongos eiang kilapo kolongong. ");
INSERT INTO lcm_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Au, Eperon kala polpol a Abaraam asukang ke, ");
INSERT INTO lcm_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Iau tungag! Arai, vuk roe ang kapo angkokoai si 400 na vuk kapkap. Sikei nia kapo bil lik palau nang singirung. Au kanat, kuan amunai ani matmat i kisngam.” ");
INSERT INTO lcm_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Asukang vang na Abaraam kala auai ve lomlomonai ang si Eperon na kala pagal suai akorong ani mamaiten i kapkap angkokoai si poisan katala posong ia. Ri It kipo tung i longong na Abaraam kalapo taot suai ani kapkap punuk. 400 na vuk kapkap angkokoai si kari tataot ri katakai i atos. ");
INSERT INTO lcm_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Io, sukana vang kitala vil akorong a vuk roe ang si Eperon e Makpela e ngere Mamre. Abaraam kalapo serei a tamana tanginang i vuk roe ang, kuvul ve vakil ina na keve ei aongos neina i palpal roe ang. Samui roe ke kita teng ia e mete takaman alak ane nei rina ang, e malangas i mataria i ri It aongos. ");
INSERT INTO lcm_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Emung i keve itoitonai ke Abaraam vang kala amunai ani kisngana ta Sara e nei vakil ang e palpal Kanan. Vakil ang katapo tung si vuk roe ke Makpela e ngere Mamre, nang kipo posong ia ta Eberon. ");
INSERT INTO lcm_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Io, sukana na akuskus i vilvil akorong ani roe na vakil. Abaraam kana kalapo tauk ina le si ri It. Na kata lapo kakana nang ta gom. ");
INSERT INTO lcm_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abaram kata lapo lapan paspasal na IAVE kata vil atauia ia si keve selen aongos. ");
INSERT INTO lcm_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Mang sikei a taun kata songo kana ainoai i asosokai. Asosokai ang kapo tu-ainoai ani kana keve asosokai na kana keve togtogon aongos. Au, kala songo ia na kala antok ia ta, “Ku amatung a kungam neite savag ");
INSERT INTO lcm_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","asi kam vil akit ani palpalatung mete IAVE, God i mete kuku na kuli rina, ta ku ago luai ta songo aina an ani kag nat si ri aina i Kanan, rina ke napo ago singina. ");
INSERT INTO lcm_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Sikei ku pasal ane si kag rina na eiang ku songo ta kana aina na Isak, si kag pat vap akorong.” ");
INSERT INTO lcm_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Asosokai ang kala tapasuk na kala sui ta, “Au, na man a aina ang kala tangag ani pasal ve nau ane ke, sa, name songo pok le kam nat ane si rina ang kutala papelek ia?” ");
INSERT INTO lcm_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Sikei Abaram kala polpol ia ta, “Ku aiveven akit luai ta ku ago ta songo an ani kag nat ane suke pok. ");
INSERT INTO lcm_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","IAVE kata songo suai anig le si kag rina na le si kag pat vap akorong, na ka palpalatung ve nau ta roe ke ka alis kag inatus na matan tivug tatana. Le si oring ke, napo nas ta nia ka asok kana angelo aino anim ani ku vil korong a abis ke. ");
INSERT INTO lcm_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Man a aina ang kala tangag ani papok ve numai, kam palpalatung si bil ke kala takunis. Sikei, ring oring lablabat palau anim ta ku ago ta songo an ani Isak ane suke.” ");
INSERT INTO lcm_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Au, na asosokai ang kala amatung a kungana neite savana i Abaram ta ka abis ia asukang palau val kana palpalatung. ");
INSERT INTO lcm_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Au, asosokai ang kala luk le ta mang keve bil roron miang le si togtogon si Abaram, ka akos ia kuli kana sangauli na kamel na kala tapasuk asi kana pasal ane Aram Nakaraim. Kala pasal pasal na kala serei si mimierokot ang Naor katapo ago singina. ");
INSERT INTO lcm_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Au, kala serei si dim ang e ngising i mimierokot na kamela ausai e iang. Kana keve kamel kipo matung kokoai asi kari inum. Katalapo pasal ani ka marmarip tenei ngelik na ri kavulik i mimierokot ang kime kakap. ");
INSERT INTO lcm_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Na asosokai ang kala sokotuk ane si IAVE asukang ke, “IAVE, numai kupo God si kag ainoinoai ta Abaram. Napo buk ani ku akalit amalangas ta kam ngorem roron ane singina, si oring ke ta ku vil iau ani na sakam korong a telan ke katala alis iau tatana. ");
INSERT INTO lcm_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Pakangai anig sipo tung ngere dim ke, using ri kavulik i ring ke kana kimelapo soung sime kakap. ");
INSERT INTO lcm_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Napo buk ani ka asukang ke ta, taun na sokotuk asi kag inum ane si mang sikei a kavulik iria, na man a kavulik ang kala sulai ani kungana ta ka alis laman anig, na man kapa ka mengen asukang ke ta ka alis laman kapa ani keve kamel ke, naka atogon a malangas ke ta ninia palau vanang a aina ang, kutala pilak ia ani kam asosokai ta Isak. Man kala asukang palau val natala kin ia, nala nas ta kam ngorem ane si kag ainoinoai kapo tutuman.” ");
INSERT INTO lcm_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Au, asosokai ang, parik kapa aulei lak ta sokotuk na Rebeka kala soung le nei mimierokot ang ta kana laka e kalakalana asi me kakap. Kavulik ke, tamana ta Betuel, nat si ri Milka ve Naor. Naor kapo tasina i Abaram. ");
INSERT INTO lcm_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Katapo kavulik talupus luai na parik lak katapa nas ri tauan. Au, kala pasiang taun a dim ang, kan kap le na kamela palak pok. ");
INSERT INTO lcm_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Au, asosokai ang kala pataun ia na kala antok ta, “Kapo angkoai ani na inum tapai si kam laka?” ");
INSERT INTO lcm_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","19","Rebeka kala longong na kala ngorem ia. Asukang na kala luk asiang a laka ang le kalakalana na kala ali laman ania. Au, asosokai ang kala inum na Rebeka kala antok ia ta “Naka kakap laman kapa ani kam keve kamel na ki kun inum asip le.” ");
INSERT INTO lcm_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Sumasuma palau kala bekai asip ani kana laka nei vulvul na kala sang asiang pok si an selai laman tung a keve kamel ang kila aulei ta inum aongos. ");
INSERT INTO lcm_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Taun a Rebeka kapo kakap, asosokai ang kapo tung musik ipo teremai ania asi kana nas ta kavpo tutuman nganing ta IAVE katala auai ve nia asi kana sakam ani paspasal ang. ");
INSERT INTO lcm_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Taun a keve kamel ang kita kamus ta inum, kala luk a mang keve alilis samui lava na kala alis a Rebeka tatana. Sikei a muraling asi atung e isuna na pongua na amaung e kungana. ");
INSERT INTO lcm_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","25","Au le, kala tapasuk na kala sui ia ta, “Ku antok iau, numai a kavulik si si akorong?” Na kala polpol ta, “Kupo nas a Betuel, nat ke si ri Milka ve Naor? Nau vang kana, kana kavulik.” Na kala sui ta, “Au, na kapo atogon pangau animem nei lu ang si tamam asi kamem matung ausai ani tenei vong ke?” Kala antok ta, “E, kapo togon angkoai pangau animi asi rot. Ani kam keve kamel kapa, ring asi rot na uriuri kapo kun punuk aroron.” ");
INSERT INTO lcm_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Taun a asosokai ang kata longong a mengen ang si Rebeka, kata soturungai na kala nanauai ani IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Kata mengen asukang ke, “Alatun ane si IAVE, God si kag ainoinoai ta Abaram. Napo man ua si kam roron na kam aiveven kitmat ane si kag ainoinoai si oring ke ta kuta ausingai anig asi kag pataun akorong ani pat vap ke akorong singina.” ");
INSERT INTO lcm_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Emung palau ina Rebeka kala sang ane nei lu na kanla antok a rinana kuvul ve kari matan vap. ");
INSERT INTO lcm_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Au, tauna i Rebeka, kana asan ta Laban katapo kun tung kapa eiang. Kata arai ani maus ang e isuna i Rebeka na e ngono kungana. Na taun kata longong a akuskus i sa na asosokai ang katala posong ia, kata sang asiang na kanla arai ania sipo tung ve kana keve kamel ngere dim ang. ");
INSERT INTO lcm_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Na kala antok ia, “Au, kana igenen roron a IAVE i la alomonaus, kupo tung sa eiang? Me ane ke na tarung palak ane nei lu. Natala itoitonai lenginang a ring asi kami ausai na ring kapa ani keve kamel ang asi kari kun ago.” ");
INSERT INTO lcm_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Au, kila pasal kuvul ane nei mimierokot na asosokai ang kala palak ane nei lu ve kana petau. Laban kala asok asi lukluk suai ani keve usausan kuli keve kamel ang na ki alis bil aniria si matung na uriuri asi kari angan. Le na kala asok asi alis laman ani vap ososongan ang asi kari galui kak. ");
INSERT INTO lcm_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Na emung kila sasagi aniria. Sikei asosokai ang kala tapasuk na kala antok ta, “Naka sonkos emung i nala antok amalangas tapai animi ta tukulai i kag pasal ane ke.” Na Laban kala antok ta, “Au, kapo ro, ku mengen tapai.” ");
INSERT INTO lcm_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Au le, kala luklukai ta, “Nau kana na asosokai si Abaram. ");
INSERT INTO lcm_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","IAVE katala vil atauia luai ania na ka alis ia ta amiang i ri bulumakau na sipsip. Kata atauia ia kapa ta kapkap duk, ri asosokai duk i ri tauan kuvul ve ri aina na ri kamel na dongki miang kapa. ");
INSERT INTO lcm_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Na kisngana ta ri Sara kita ingus karilong nat tauan, si taun kilong talapo lapan paspasal. Na kala atogtogon a nat ang ta kana tauia aongos. ");
INSERT INTO lcm_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Io na kata vil a mang palpalatung ve nau. Ka antok iau ta, ‘Ku ago luai ta songo aina an ani kag nat si ri aina i Kanan, ring ke kana napo ago singina, ");
INSERT INTO lcm_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","sikei ku arai ania ta ku pasal taun akorong a pat vap ang si mamai napo angtogon ve ria na ku songo ta kana aina na kag nat eiang.’ ");
INSERT INTO lcm_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Na nala sui ia ta, ‘Au, na man a kavulik ang kala misag ani papok ve nau ane ke?’ ");
INSERT INTO lcm_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Na kala polpol iau asukang ke, ‘IAVE, God ke napo longong singina, ka asok kana angelo ve numai ani ku vil korong a paspasal ke, na ku sakam a telan ke ta ku luk aina korong ani kag nat, si kag pat vap. Si vap ang si mamai akorong. ");
INSERT INTO lcm_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Man kula serei si kag pat vap akorong na kila misag anim kula takunis io, kula takunis si palpalatung ke.’ ");
INSERT INTO lcm_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Au na taun nata serei ngere dim ke anginang, nala sokotuk a IAVE ta, ‘God si kag ainoinoai ta Abaram, ku pakangai anig ani naka sakam korong a telan ke. ");
INSERT INTO lcm_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ku pakangai anig sipo tung ngere dim ke si oring ke ta man na sokotuk ane si mang sikei a kavulik i ring ke, man ka pasiang si me kakap, na man nala sokotuk ia asi kag inum, ");
INSERT INTO lcm_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","na kala antok ta, “Ku inum aino, le na naka kakap kapa ani kam keve kamel” io, naka nas si akanangai ke ta ninia palau vanang a aina ang numai IAVE kutala pilak ia ani kana nat kag ainoinoai.’ ");
INSERT INTO lcm_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Au, parik napa aulei lak ta sokotuk nei lomlomonig na taum ta Rebeka kala soung ve kana laka e kalakalana. Kala pasiang na kanla kap le, na nala sokotuk ia asi kag inum. ");
INSERT INTO lcm_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Au, akorong palau na kala luk asiang kana laka le kalakalana na kala antok ta, ‘Ku inum, na naka kakap kapa ani kam keve kamel.’ Asukang na nala inum na kala alis laman ani kag keve kamel. ");
INSERT INTO lcm_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Le na nala sui ia ta, ‘Au si, numai kana na kavulik si si akorong?’ Na kala ngenget iau ta, ‘Nau a kavulik si Betuel, nat ke si ri Naor ve Milka.’ “Au na nala luk a muraling ang na nala atung ia e isuna, na nala alakai kapa ani ngono amaung ang e ngono kungana. ");
INSERT INTO lcm_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Na nala soturungai na nala nanauai ani IAVE. Nata alatun a IAVE, God ang si kag ainoinoai ta Abaram, using kata ainoai anig si selen korong ane si tivuna i kag ainoinoai ani kan osongon kana nat. ");
INSERT INTO lcm_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Au, using kalapo asukang ke napo buk ani mi abis a lau roron si selen i atutuman ane si kag ainoinoai. Man parik kapa angkoai, mi antok amalangas iau na na lomlomonai selen asi kag using.” ");
INSERT INTO lcm_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Na ri Laban ve tamana kilong la antok ta, “Bil ke kapo serei le si IAVE, na parik kapa koi ta namem mengen ta sa lakat kuluna. ");
INSERT INTO lcm_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka kana kapo ago, ku songo ia na mi pasal na kan osongon ta kana nat kam ainoinoai val kana vubuk a IAVE.” ");
INSERT INTO lcm_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Taun a asosokai ang kata longong a mengen ke si Laban, kata soturungai na kala nanauai ani IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Emung ina kala luk na mamain ta alilis roron val mang keve bil asi maus na vakup samui lava na kala alis a Rebeka. Kata alis kapa na tauna na rinana ta mang matan bil miminaungan. ");
INSERT INTO lcm_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Au, na kila matan angan le na kila rot a tenei vong ang. Taun kita tapangun tenei vauk asosokai ang kala antok ta, “Au kanat, mi akala iau vang na na pasal ane si kag ainoinoai.” ");
INSERT INTO lcm_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Sikei tauna na rinana i Rebeka kila antok ta, “Kapo roron ani ka ago lik pok tapai ani sangauli vo alak na taun le na mi pasal.” ");
INSERT INTO lcm_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Sikei kala antok ta, “Mi ago ta atakun an anig. Man a IAVE katala pakangai anig asi kag sakam korong ani paspasal ke, mi atalipai anig na na pasal pok ane si kag ainoinoai.” ");
INSERT INTO lcm_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Na kila antok ta “Au kanat, tara susuiai tapai kotok ani kana lomlomonai a Rebeka. ");
INSERT INTO lcm_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Na kila songo ia na kila sui ia, “Sa, kulapo buk pasal ve igenen ke kana palau vo parik?” Na Rebeka kala antok ta, “Kapo ro, naka pasal kana ve nia.” ");
INSERT INTO lcm_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Asukang na kila atatung a tauria kuvul ve aina po aiveven ang ania, asi kana pasal ve asosokai ang si Abaram na kana petau. ");
INSERT INTO lcm_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Si kana tapasuk kita poso-atauia ia asukang ke, “Taumem, numai ku tivuria i pat vap lava luai. Keve tivum e mung im ki sakam na ki ngi suai ani mamain ta rina kipo petau aniria.” ");
INSERT INTO lcm_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Au, kila kokos ve kana keve ainan asoksokai kuli kamel na kila pasal ve asosokai ang. ");
INSERT INTO lcm_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Nei pangau i keve taun ang, Isak kata pasal le Ber Lakai Roi e Negev na kamela po ago e Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Si tenei ngelik marmarip i mang taun kata pasal avunga lik akipai ani nei rina, asi kana an sokotuk na lomlomonai. Na taun ang kata tun alak na kala tere avunga lik, kala arai ani keve kamel si la vulis serei. ");
INSERT INTO lcm_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Si taun ang kapa, Rebeka kata kun tere aliu na kala arai ania. Kata kisiang le kuli kana kamel ");
INSERT INTO lcm_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","na kala sui a asosokai ang ta, “Au si, saka igenen sukana kapo pasal taun ira?” Na asosokai ang kala polpol ta, “A, nang kag ainoinoai nang.” Taun kata longong a polpol ke kata luk kana vuk vakup na kala pakut a nona. ");
INSERT INTO lcm_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Taun kianla angruduai, asosokai ang kala antok amalangas a Isak ta kana paspasal aongos. ");
INSERT INTO lcm_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Au, Isak kala tak le na Rebeka ane si lu si rinana ta Sara na kala osongon ia. Si karilong osongon kata buk alava luai ania, na kana mamakus si matmat ang si rinana katalapo pongo suai paspasal. ");
INSERT INTO lcm_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Emung ina Abaraam kala osongon pok a mang aina kana asan ta Ketura. ");
INSERT INTO lcm_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura kata ingus ania ta ri Simran, Ioksan, Medan, Midian, Isbak na Sua. ");
INSERT INTO lcm_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ioksan nang katapo tamarilong i ri Siba na Didan. Na Didan katapo tivuria i ri Asurim, na ri Letusim na ri Leumim. ");
INSERT INTO lcm_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Au na Midian katapo tivuria i ri Epa, Eper, Anok, Abida na Elda. Io, keve vap aongos suke, kipo matan tivuna i Ketura. ");
INSERT INTO lcm_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Emung i kana matmat a Abaraam, kana togtogon aongos, Isak kata luk ia. ");
INSERT INTO lcm_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Sikei, aino si taun katapo to lak, kata alilis kapa ani kana mang keve nat ang le si keve kisngana ka, na kala asok suai ani keve nat ang ane si ring ipo sanglak ta makarap, ani ki an ago akipai i Isak. ");
INSERT INTO lcm_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Io, Abaraam kata to na 175 matas aongos le na kala pasal suai asi kana an ausai ve riria kitala mat aino ia. Katalapo lapan luai na kana matmat katapo mangsikei a matmat ro luai. ");
INSERT INTO lcm_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Kana ngono nat aino, ri Isak ve Ismael, kilongta tepai ania nei vakil ang e Makpela, angasungai i rina ang Mamre si vuk roe ang si Epron tamana ta Soar. Abaraam kata samui aino ia si patvap ke, ri Et. Io, si vuk roe ang vanang kita tepai ani Abaraam ngere kisngana ta Sara. ");
INSERT INTO lcm_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Emung i kana matmat, God kata atautauia kana nat ta Isak. Isak si vuk taun ke katalapo ago e Ber Lakai Roi. ");
INSERT INTO lcm_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Kana vang na akuskus i kana mang nat a Abaraam, Ismael, voi ke na ri Agar kita ingus asereiai ania. Aina ke le Aigipto katapo asosokai ke ri Sara. ");
INSERT INTO lcm_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Na kana vang na keve asan i kana keve nat nia na Ismael, le si tuan tung si kiu iria. Kana ainoai i nat ta Nebaiot, le na Kedar, Adbel, Mibsam, ");
INSERT INTO lcm_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa ");
INSERT INTO lcm_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adad, Tema, Ietur, Napis, na Kedema. ");
INSERT INTO lcm_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Kana vang na keve asan i kana keve nat na Ismael. Kapo keve asan kapa i 12 na tu lava i keve patvap, na kari keve rina na ring ipo ago tul, voi ang kita sunguk na keve asan ke. ");
INSERT INTO lcm_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael kata to aongos na 137 na matas, le na kala mat taun kana vap. ");
INSERT INTO lcm_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Keve tivuna kita ago aliu si palpal ang le Avila ane Sur. Sur kapo ago nei liuan i pangau pelek a Aigipto alak ane Asuria. Na kitapo ago i angkiki na angvis ve matan polpolokan ang si keve tasina i Ismael. ");
INSERT INTO lcm_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Kana na akuskus i Isak, kana mang nat a Abaraam. ");
INSERT INTO lcm_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak katala puat a sangauli na matas aongos taun kata osongon a ri Rebeka, kavulik ang si Betuel. Betuel, igenen i patvap Aram, le Padan Aram. Na tauria i ri Rebeka ta Laban. ");
INSERT INTO lcm_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Using ri Rebeka kitapo ngolo, Isak kata sokotuk ane si IAVE asi kari ingus korong. Na IAVE kata longong kana sokotuk na ri kisngana kila sungsungukan. ");
INSERT INTO lcm_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ngono lua ang nei vingaria, kilongtapo uli anggegelai angpokpokai anirilong. Asukang na ri Rebeka kila antok ta, “Au si maraisa kana na bil ke kapo serei singig?” Na kianla nanas si IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Au, IAVE kala antok iria asukang ke, “Pongua na palpal nang kipo ago e nei vingami. Na pongua na matan vap ke, ki ago angtaliungai. Mang palpal vap ki dual ani mang anu ang. Vopo aino ang ka abis ani vo aimung irilong.” ");
INSERT INTO lcm_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Io, kalapo liliuan aliu, na taun kalapo sinong ani ki ingus. Na kila ingus kari ngono lua tauan. ");
INSERT INTO lcm_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Vopo soung aino ang katapo pukun melek na katapo pukun ungan val sualakai mosong, asukang na kila atuk ia ta Esau, supsupai ina ta pukun ungan. ");
INSERT INTO lcm_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Emung ina tasina kala kun soung na katapo teng akit si pung i kakina i Esau, asukang na kila atuk ia ta Iakov, supsupai ina ta igenen apupu. Si taun ke Isak katalapo 60 na matas aongos na ri Rebeka kila ingus na ngono nat ke. ");
INSERT INTO lcm_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Au, kilongla polok alak na ngono nat ke, na Esau katapo igenen katak aro luai ta akalat. Katapo uli buk sili nei uten. Sikei tasina ta Iakov katapo igenen nok, asukang na katapo uli ago e rina. ");
INSERT INTO lcm_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak, using katapo uli buk angan ani ri pok i nei uten, katapo buk alava luai ani Esau, sikei ri Rebeka kitapo buk a Iakov. ");
INSERT INTO lcm_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Na mangsikei a taun Iakov katapo ago e rina i po vil amoso sup, na Esau kala serei le nei uten ta buk angan lava. ");
INSERT INTO lcm_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Na kala antok a Iakov ta, “A! Napo buk angan arikek luai. Lis iau ta men sup melek ang!” Le si oring suke, kana mang asan ta Edom, supsupai ina ta melek. ");
INSERT INTO lcm_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Sikei Iakov kala polpol ta, “Aino ani na lis pok anim, ku alis aino iau ta kam sinsinong i nat tuan, na keve roron ina.” ");
INSERT INTO lcm_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Au, na Esau kala antok ia ta, “Nalapo buk mat nang ta mol ke. Kapo saka roron an anig na sinsinong ang, man napo asukang ke?” ");
INSERT INTO lcm_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Na Iakov kala antok ta, “Au, kanat. Ku palpalatung tapai singig tatana.” Asukang na Esau kala palpalatung ve Iakov ta kana sinsinong i nat tuan. ");
INSERT INTO lcm_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Emung ina Iakov kala alis ia ta rukun vuk saui na men sup ang. Kata angan le ia na kala tapasuk na kala pasal. Asukang vanang na si selen ke Esau kata akalit amalangas ta kana ararai alik ani kana sinsonong i nat tuan. ");
INSERT INTO lcm_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Nei liuan i taun ang kata atogon a mang sikei a mol lava kata serei nei palpal aongos ang. Katapo emung i mang mol lava vo serei aino ang si taun na Abaraam katapo to singina. Asukang na Isak kala pasal ane Gerar, rina ang a Abimelek katapo tauk ina. Na katapo vosap i matan vap i Pilistin eiang. ");
INSERT INTO lcm_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Au, Iakov kala serei eiang e Gerar na IAVE kala serei singina na kala antok ia asukang ke, “Ku ago ta pasiang an ane Aigipto, sikei ku ago eke si rina ke napo antok ua asi kam ago singina. ");
INSERT INTO lcm_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Io, man ku ago nei rina ke, na auai ve numai na na vil atauia ua ta nala alis imi ve keve matan tivum ta roe aongos ke. Nala asereai atutuman vang ani palpalatung ang nata abis ia ve tamam ta Abaraam. ");
INSERT INTO lcm_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Na apolokai ani matan tivum na ki serei aduk luai val ri kalto i mete kuku, na na alis iria ta keve roe aongos ke. Le si ngiria vanang naka asereai ta sikei voiang na mamain ta matan vap aongos i kuli rina ke ki luk kari alomonaus le singina. ");
INSERT INTO lcm_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Naka vil ia asukang using Abaraam kata longong iau. Kata abis aro kag keve vubuk, na kag keve sausaupai, na kag keve asok.” ");
INSERT INTO lcm_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Io, asukang na Isak kala ago eiang e Gerar. ");
INSERT INTO lcm_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Taun ri vap i nei rina ang kila sui ia ta ri kisngana na kala antok iria ta, “A, nang a ri taug nang.” Katapo leng vei ki raung suai ania marai ri kisngana using kitapo ararai miminaungan. ");
INSERT INTO lcm_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isak katalapo ago na vuk taun eiang, na vosap Abimelek, mangsikei a taun kala tun asiang le nei matakoto i kana lu na kala taping si arai ani Isak sipo malus ani ri Rebeka. ");
INSERT INTO lcm_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kala songo na Isak na kamela sui ia, “Au, aina ang nang kapo kisngam, ingko? Marai sa vanang kuta kapau iau ta kapo taum?” Na Isak kala antok ta, “Using apok natapo lomon ia ta mila raung korong iau, man nata antok imi ta kapo kisngag.” ");
INSERT INTO lcm_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Au, Abimelek kala antok ta, “Au, marai sa kuta abis a lau rikek asukang? Man a mang sikei i kag vap katala rot korong ve kam aina, pua, nganlak kula apaus imem ta mese lava.” ");
INSERT INTO lcm_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Asukang na Abimelek kala alis a saupai ke ane si ri vap aongos ta, “Man a sikei ka akeke ta igenen ke vo ri kisngana kapa, ka ago asi mat.” ");
INSERT INTO lcm_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Taun ang na Isak kapo ago, kala sukal alava nei roe ang na nia si matas ang palau kata kopos kana suksukalan lava. Kana sukal kata uai alak ane si sikei a lelen sangauli aongos na kopkopos soliu na sa kata sukal aino ia. Io, IAVE katapo atautauia alava luai ania ");
INSERT INTO lcm_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","na kata serei atauia. Kana keve togtogon kata polok aduk tung kala serei a igenen tauia luai. ");
INSERT INTO lcm_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Kata atogon kana keve manmanik miang na keve asosokai miang kapa, asukang na ri vap i Pilistin kilapo man ia na kila vinga rikek ania. ");
INSERT INTO lcm_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kila tapasuk na kila tapus na mamain ta dim i tep ang ta kana keve asosokai a tamana, si taun katapo to lak. ");
INSERT INTO lcm_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Le na Abimelek kala antok a Isak ta, “Ku pasal suai animem, using kulapo soliu animem si kam atogtogon na na kam kitmat kalapo lava.” ");
INSERT INTO lcm_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Asukang na Isak kala pasal suai ani palpal ang na kanla ago e nei palpal lulungai ina i Gerar. ");
INSERT INTO lcm_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Kala tapasuk na kala tep asereiai pok ani mamain ta dim i tep ang ta tamana na kala atuk pok iria ta keve asan ang tamana kata atuk iria tatana. Keve dim ke, ri vap i Pilistin kita tapus iria emung i Abaraam kata mat. ");
INSERT INTO lcm_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Kana keve asosokai na Isak kila tep pulakai nei lulung ang tung si kila sabonai ani mang sikei a laman kapo uv alak. ");
INSERT INTO lcm_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Sikei keve katakai i aiveven vongo le Gerar akorong kila angkiki ve petau ang si Isak asukang ke ta, “A, laman ang nang kapo kakamem ta laman!” Le si oring suke vanang na Isak kala atuk a laman ang ta Esek, supsupai ina ta ‘angkiki’ using kita angkiki ve nia singina. ");
INSERT INTO lcm_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Au, kila pasal na kianla tep na mang dim sikei kila anggegelai kapa singina. Le si oring suke vanang na kala atuk a dim ang ta Sitna, supsupai ina ta ‘anggegelai’. ");
INSERT INTO lcm_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Au, kila papelek a ring ang na kianla tep kapa na mang dim, sikei taun ke parik vang kitalapa angmamaralai maraina. Na Isak kala antok ta, “Pua, kana vang IAVE kala alis pangau anira. Tara serei aduk vanang si rina ke.” Le si vuk mengen suke na kala atuk a dim ang ta Reobot, supsupai ina ta ‘pangau roron’. ");
INSERT INTO lcm_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Le iang kala palak alak ane Berseba ");
INSERT INTO lcm_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","na si tenei vong ang IAVE kala serei singina na kala antok ia ta, “Nau kana na God ke si tamam ta Abaraam. Ku ago ta leng an using napo auai ve numai. Na atauia lak ua na ku polok alava luai ve keve matan tivum. Bil ke na abis ia si nanauai ani kag asosokai ta Abaraam.” ");
INSERT INTO lcm_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Asukang na Isak kala atung na mang sikei a iat eiang asi kana nanauai ani IAVE. Kala atung kana lu eiang na kana keve asosokai kila tep na mang dim aniria kapa eiang. ");
INSERT INTO lcm_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Taun kata lapo ago liliuan lik, Abimelek kala serei singina i kana pasal le Gerar. Kata serei ve Ausat, kana igenen ipo pini ania, na Pikol, ainoinoai i kana keve katakai i visvis. ");
INSERT INTO lcm_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Au, kitol la serei na Isak kala sui iritol, “Au, marai sa kana mitolpo serei singig, taun mita tav aiveven aro anig na mila kirikai suai anig pelek kami rina?” ");
INSERT INTO lcm_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Na kitol la polpol ia ta, “Namemtol tala arai amalangas vang ta IAVE katapo uli auai ve numai, asukang na namemtol la lomlomonai ta kapo ro ani ka atogon na ainainakai roron nei liuan ira. Asukang na namemtolpo buk palpalatung ve numai ");
INSERT INTO lcm_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ta tara ago ta angridikekai angpokpokai anira. Parik namemta akeke tatam na namem aiveven aro ua na namemta asok suai anim ta luai na marip. Asukang palau ku ago kapa ta vil arikek an ane singimem. Using kana vang, kala po malangas ta IAVE kapo atauia alava luai anim.” ");
INSERT INTO lcm_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Au, na Isak kala itoitonai ani mang sikei a matan angan aniritol na kitol la angan. ");
INSERT INTO lcm_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Si tenei vauk lik kitol la palpalatung kuvul angpokpokai aniritol. Le na Isak kala atatung iritol na kila angtaliungai ta marip. ");
INSERT INTO lcm_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Singina si taun ang palau, kana keve asosokai kimela serei singina na kila antok ia ta dim tanginang i kari tep ang. ");
INSERT INTO lcm_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kala atuk ia ta Siba, supsupai ina ta palpalatung. Na asukang, tung si taun ke kipo posong lak a rina ang ta Ber Seba. ");
INSERT INTO lcm_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau, si taun kata lapo puat a sangauli na matas aongos, kala osongon a kavulik ang si Beri, i pat vap ang ri It, kana asan ta Iudit. Na kala osongon kapa na Basemat, kavulik ang si Elon i pat vap ang i Itit kapa. ");
INSERT INTO lcm_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Sikei ngono aina ang kilongta po uli vil amamakus ani ri Isak ve Rebeka. ");
INSERT INTO lcm_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Au, Isak kata lapo lapan paspasal na kalapo mataba. Mang sikei a taun kala songo kana nat tuan ta Esau ta “Kag nat.” Na Esau kala antok ta, “Io, nau kana.” ");
INSERT INTO lcm_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Na Isak kala mengen ia asukang ke, “Nalapo lapan kana na parik napa malangas a taun ang naka mat singina. ");
INSERT INTO lcm_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Asukang na ku luk kam usausan ipo akalat, kam vatilau, na kam keve vut na ku pasal ane nei uten na ku an akalat ta ring avus anig. ");
INSERT INTO lcm_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Taun ku papok ku me itoitonai amoso ania asukang palau val matan pok ang nau napo uli buk angan ania na ku luk ia ane singig, ani taun nala angan sip le ia nala posong atautauia ua aino le ani na mat.” ");
INSERT INTO lcm_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Sikei nia si taun ang akorong ri Rebeka kitapo kokolongong tainau na Isak sipo angmemengenai ve kana nat ta Esau. Asukang na taun a Esau kala ultaliung ane nei uten asian akalat ani tamana, ");
INSERT INTO lcm_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","kila pasal na kianla mengen ve kari mang nat ta Iakov. Kila antok ia asukang ke ta, “A ku longong tapai! Nata longo-tainau nang a tamam sipo mengen ani tasim ta, ");
INSERT INTO lcm_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Ku pasal na kuanla so le ta kag ring avus, na kume itoitonai amoso ania val matan pok ang napo uli buk angan ania, ani taun nala angan le ia, nala posong atautauia ua e matana i IAVE aino le ani na mat’. ");
INSERT INTO lcm_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Au, kag nat, ku longong aroron luai na ku abis a sa kana na atatai ua tatana. ");
INSERT INTO lcm_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ku pasal ane nei liuan i kara keve vongo na kuan daung le ta pongua na natnat vubukan ro i me, na name itoitonai ani matan pok ang a tamam kapo uli buk ania. ");
INSERT INTO lcm_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Le na ku luk le ia na kuan alis a tamam asi kana angan, na ka posong atautauia ua aino le ani ka mat.” ");
INSERT INTO lcm_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Na Iakov kala antok ta, “Iau? Esau nang kapo pukun ungan na nau napo pukun ratal palau. ");
INSERT INTO lcm_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Man a mamai kala sigil a pukun ig, nala sa? Kala nas akorong ta napo kapau ia. Varas nganlak kala uak kulug na parik ta posong atautauia.” ");
INSERT INTO lcm_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Sikei kila antok ta, “Kag nat, ku ago ta leng an. Ago na varas ang ka lak iau. Ku abis palau a sa kana napo antok ua tatana. La luk le na ngono vongo lik suke.” ");
INSERT INTO lcm_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Au, Iakov kala pasal na kanla luk le na ngono vongo lik ang na kame la alis rinana na kila itoitonai ani matan pok ang ani tamana. ");
INSERT INTO lcm_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kila luk a keve sualakai roron luai si Esau voiang katapo sinong nei lu na kala amaus a Iakov tatana. ");
INSERT INTO lcm_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Kila luk kulit i me na kila pakut a ngono kungana na palpal iruna voiang katapo ratal. ");
INSERT INTO lcm_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Le na kila alis ia ta keve pok ang na keve saui i kari la itoiton ang. ");
INSERT INTO lcm_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Au, Iakov kanla serei si tamana na kala songo, “Mamai!” Na tamana kala polpol, “Io kag nat. Numai nang a si?” ");
INSERT INTO lcm_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Au, kala antok ta, “Nau nang kam ainoai i nat ta Esau. Natala vil apunuk kam atatai anig. Ku sinong atung nang na ku angan tapai si pok ke, le na ku posong atautauia iau.” ");
INSERT INTO lcm_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Sikei Isak kala sui ia ta, “Au, kag nat, kuta sa sabonai sumasuma nang ani bil ang?” Na kala antok ta, “IAVE kam God kata pakangai anig.” ");
INSERT INTO lcm_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Asukang na Isak kala antok ta, “Au, kanat kag nat, me asung ani na sigil korong ua. Na nanas ta numai akorong nang kag nat ta Esau vo parik.” ");
INSERT INTO lcm_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Au, Iakov kala pasal asung na tamana kala sigil ia na kala antok ta, “Kalingam kapo tangis val kalingana i Iakov sikei ngono kungam kapo asukang val ngono kungana i Esau.” ");
INSERT INTO lcm_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Si taun ke Isak parik katapa arai kinle ania, using ngono kungana katapo ungan val ke Esau. Ninia vanang a tukulai ina kata posong atautauia ia. ");
INSERT INTO lcm_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Au, Isak kala sigil ia na kala sui, “Si? Numai akorong kana kag nat ta Esau?” Na kala antok ta, “Io, nau palau.” ");
INSERT INTO lcm_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Au kala antok ta, “Kag nat, luk a pok ang na name angan, le na na posong atautauia ua.” Na Iakov kala luk dong ia ta pok ang ve kana men wine kapa na kala sonkos. ");
INSERT INTO lcm_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Emung ina Isak kala antok ia, “Me asung iau, kag nat, na kume lulus iau.” ");
INSERT INTO lcm_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Na Iakov kala pasal asung a tamana na kala lulus ia. Au, vuk taun ang kapo lulus ia, Isak kala sain korong a sain i kana keve sualakai na Esau na kala tapasuk na kala posong atautauia na Iakov. Kana posong atautauia asukang ke, “Io, sain i kag nat kapo asukang ta sain i nei matang, voiang a IAVE katala atauia ia. ");
INSERT INTO lcm_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","God ka alis ua ta langit i mete kuku na tauia i kuli roe. Ku duk luai ta uai i ei na wine tanginang. ");
INSERT INTO lcm_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Mang keve pat vap ki abis anim na ki soturungai taun ua. Keve tasim ki abis anim, na ki soturungai taun ua. Riria kipo varas ua ki kun duk ta rikek. Na riria kipo posong atautauia ua ki kun tauia kapa.” ");
INSERT INTO lcm_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Au, Isak kala aulei ta mengen na Iakov kala pataliung a tamana. Na akorong palau tasina ta Esau kamela serei i akalat. ");
INSERT INTO lcm_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Kala itoitonai aroron ani kana matan pok asi an sasagi dong ani tamana tatana. Au, kala palak na kala antok a tamana ta, “Au, mamai, ku sinong atung na ku angan le si sasagian ke, ani ku posong atautauia iau.” ");
INSERT INTO lcm_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Na tamana kala sui ia, “Au, numai nang a si?” Na kala antok ta, “Nau apok na Esau, kam ainoai i nat.” ");
INSERT INTO lcm_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Au, vuk taun ang kapo mengen asukang suke, Isak kala tetek alava luai na kala sui, “Au, na mang si nang katanla akalat le na kana palau katamela lis pok le anig? Natala angan asip le ia kana aino ani kupo tavas alak, na natala posong atautauia ia kapa. Io, kalapo kakana ta posong atautauia ang. Parik kapa angkoai ani na luk pok ia.” ");
INSERT INTO lcm_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau kata longong a keve mengen ke si tamana na kala kup alava ta tangis na kala antok ia ta, “Ku posong atautauia iau kapa. Io nau, nau kapa mamai dangis!” ");
INSERT INTO lcm_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Sikei tamana kala antok ia, “Tasim kata serei singig ta kapau na kamela luk a posong atautauia ang pat anim.” ");
INSERT INTO lcm_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Na Esau kala antok ta, “Kita atuk aro luai nang ania ta Iakov, using katala kapau a matan pongua iau lenginang. Katala luk suai ani kag sinsinong i nat tuan, na kana kala luk kag posong atautauia!” Na kala sui a tamana ta, “Sa mamai, parik kutapa lomon akipai ta ring posong atautauia anig?” ");
INSERT INTO lcm_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Na Isak kala polpol asukang ke, “Parik nang. Tasim vanang kana kalapo tu-ainoai anim, na keve tasina natala posong iria ta ki ago neite kana sausaupai. Natala posong atautauia ia ta uai i ei na vaen tanginang. Kalapo asukang vanang. Nau parik napa angkoai si posong ta mang sa anim nang ka pok petekai. Kalapo kovek nang, kag nat!” ");
INSERT INTO lcm_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Na Esau kala sui ta, “Mamai, kupo atogon ta sikei palau a posong atautauia? Mamai, napo sokotuk ua ta ku posong atautauia iau kapa.” Na Esau kala tangis alava. ");
INSERT INTO lcm_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Au, Isak kala posong dong ia ta vuk mengen asukang ke, “Longong! Kam ring asi ago ka ago akipai ani roron na tauia i nei roe, na ka ago akipai ani keve langit i mete kuku. ");
INSERT INTO lcm_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ku igenen visvis ta samele na ku abis ani tasim. Sikei, ka serei lak a taun ku mamal ani ago neite kana sausaupai na kula sip pelek ia.” ");
INSERT INTO lcm_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Io, le si taun ang Esau kalapo uli atogon marala lava ani Iakov le si posong atautauia ang tamana kata posong dong ia tatana. Asukang na kalapo lomlomonai ta, “Uring lik a mamai nang ka mat. Man kala mat, io nala raung suai ani tasig ta Iakov.” ");
INSERT INTO lcm_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Au, taun ri Rebeka kila longong a mengen ang si Esau, kila songo na Iakov na kila antok ia ta, “Tasim nang ta Esau kapo alos pulakai ta kana lomlomonai asi raung anim. ");
INSERT INTO lcm_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ku longong aro iau, kag nat. Ku sip sumasuma palau ane si lavam ta Laban e Aran. ");
INSERT INTO lcm_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Na ku ago e iang ve nia ani mang rukun taun tung kana marala anim a tasim ka livus. ");
INSERT INTO lcm_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Man kala livus kana marala na kala lomon taun a sa kuta abis ia ane singina, naka alis mengen anim asi kam papok. Kapo rikek ani milong aongos milong mat pelek iau si sikei palau a vuk taun.” ");
INSERT INTO lcm_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Na Rebeka kala antok a Isak asukang ke, “Napo kirik luai nang ani ago kuvul ve ngono omog ke i ri It. Man a Iakov kala kun osongon korong kapa singiria, loi, kag to parik luai kapa angkoai si ka roron.” ");
INSERT INTO lcm_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","3","Asukang na Isak kala songo na Iakov na kala pinipini ia ta mengen asukang ke, “Ku ago luai ta osongon an ta sikei i keve aina ke i Kanan. Ku tapasuk na ku pasal ane Padan Aram ane si tivum ta Betuel, tamaria i rinam. Ku luk ta mangsikei i kana keve kavulik a Laban ani kam aina. Laban nang kapo tauria i rinam.” Isak kata posong dong kapa ia ta poso-atauia ke, “God Tavirimok Luai ka vil atauia ua. Ka apolokai ani kam polpolokan ki serei a matan vap lava luai. ");
INSERT INTO lcm_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ka alomonaus imi ve keve matan tivum na ka alis imi ta roe ang, kana kupo ago ia val sokoung. Roe ang nang God katala atogon a Abaram tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Au, Isak kala mengen asip na kala asok na Iakov asi kana pasal ane si Laban e Padan Aram. Tamana i Laban ta Betuel le Aram. Na ri Laban kilongpo angtaumal ve ri Rebeka. Na ri Rebeka vanang kipo rinarilong i ri Iakov ve Esau. ");
INSERT INTO lcm_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Si pangau i taun ang Esau kala longong ta Isak katala poso-atauia na Iakov na kala asok suai ania ane Padan Aram asian luk ta kana aina le iang. Na taun kata poso-atauia ia kata pinipini ia ta ka ago luai ta osongon an ta sikei i keve aina ke i Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Na Esau kala kun longong ta Iakov katala longong a tamana na rinana na kala pasal ane Padan Aram. ");
INSERT INTO lcm_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Le iang Esau kala kinle ta tamana kapo kirik ani ri aina i Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Asukang na kala pasal ane si matan vap ang si Ismael, mang nat ang si Abaram, na kanla osongon kana mang kavulik kana asan ta Ma-alat. Tauna i Ma-alat ta Nebaiot. Osongon ke kata vil a tataot lava na mang keve aina ang katala osongon lenginang iria. ");
INSERT INTO lcm_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Io, Iakov kala papelek a Berseba asi kana pasal ane Aran. ");
INSERT INTO lcm_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Au, nei liuan i kana paspasal kanla serei si mang vuk ring na kala vong ania. Na kala lomlomonai ani ka matung ausai ani tenei vong ang e iang. Kala luk a mang sikei a vuk iat asi kana kirang vangang na kala pok suai asi kana rot. ");
INSERT INTO lcm_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Taun kalapo rot kala arai ani mang sikei a kikiklakan kapo tung asiang le mete kuku ane kuli vunep. Kana keve angelo a God kitapo pasal angpok kuluna. ");
INSERT INTO lcm_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Na IAVE kapo tung e pangkul. Kala mengen asukang ke, “Nau kana na IAVE, nia palau a God, nang a tivum ta Abaram na tamam ta Isak kilongpo lomlomon singina. Naka alis imi ve keve matan tivum ta roe ke kana kupo matung singina. ");
INSERT INTO lcm_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Matan tivum ki duk pitpitliu luai. Ki polok apapanai alava luai ane si keve matana i malu aongos i kuli rina. Naka asereai ta sikei le nei liuan imi voiang na mamain ta matan vap aongos i kuli rina ke ki luk kari alomonaus le singina. ");
INSERT INTO lcm_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Teng akit a mengen ke. Nau kana ve numai. Naka aiveven ua si kam keve paspasal aongos. Na emung nala songo pok ua ane si roe ke, using parik luai napa angkokoai si papelek anim tung si nala vil korong a palpalatung ang natala palpalatung ia ve numai.” ");
INSERT INTO lcm_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Au, na Iakov kala tapangun na kala lomlomonai ta, “Pua, kapo tutuman luai, IAVE kana kapo ago si vuk vunep ke, na parik natapa malangas tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Vuk leng lava kalapo serei singina na kala antok ta, “Vuk vunep ke kana kalapo vil a leng iau. Kapo tutuman luai, oring ke kana kapo lu si God, na kana na takaman i mete kuku.” ");
INSERT INTO lcm_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Si tenei vauk lik Iakov kala tapasuk na kala luk a iat ang kata kirang vangang tatana na kala atung atung ia na kala vekai rul i oliv kuluna. ");
INSERT INTO lcm_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Na kala atuk a ring ang ta Betel, supsupai ina ta lu si God. Aino kitapo uli posong ania ta Lus. ");
INSERT INTO lcm_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Eiang Iakov kala vil a mang palpalatung ve God asukang ke, “Man ku auai ve nau, na man ku ararai bat anig si paspasal ke napo pasal ia, na man kapa ku alis pok na ku amaus iau, ");
INSERT INTO lcm_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","na man nala vil korong ia ta nanla serei pok si kana lu na mamai, io, man ku pakangai anig asukang suke, nala luk vang ua val kag God, IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Akanangai ke kana natala atung atung ia kalapo kam lu. Le si keve tauia ang ku alis iau tatana, nala alis pok ua ta tataot-sangauli iria aongos.” ");
INSERT INTO lcm_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Au Iakov kala pasal na kanla serei si palpal roe ang si matan vap ang si ring ipo sanglak ta makarap. ");
INSERT INTO lcm_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Eiang kala arai ani potol a kuvkuvulan i sipsip na kipo matung ngere mang sikei a dim. Kitapo ainuinum ri sipsip si dim ang. Vuk iat i nguruna i dim ang katapo vuk iat lava, ");
INSERT INTO lcm_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","na si taun na ri sipsip kianpo ago kuvul eiang, vap ipo aiveven ang aniria kipo uli ul suai ani iat ang le na ki ainum iria. Emung ina kipo uli ul pok ani iat ang bat a nguruna i dim ang. ");
INSERT INTO lcm_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Au, Iakov kala serei eiang na kala sui na vap ang ta, “Au si, keve tungag, nami akorong kana le voi?” Na kila antok ta, “Namem nang le Aran.” ");
INSERT INTO lcm_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Au, na kala sui iria ta, “A, mipo nas kana na Laban, nang a tivuna ta Naor?” Na kila antok ta, “E, namempo nas ia.” ");
INSERT INTO lcm_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Na Iakov kala sui ta, “Au sa, kapo to aro palau?” Na kila antok ta, “E, kapo to aro. A! Ta kana kavulik kana ia ta Rakel kapo pakasang ve kari keve sipsip.” ");
INSERT INTO lcm_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Na kala antok ta, “Apua, makarap kana kapo ago e pangkul lak. Parik lak kapa taun si songo aiton ani ri sipsip asi kari rot. Mi ainum iria, le na mi songo iria asi kari an angan. ");
INSERT INTO lcm_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Sikei kila antok ta, “Parik kapa angkoai tung a keve sipsip aongos kila seserei, io kila ul suai vanang ani iat ke na namem la ainum vang a ri sipsip aongos.” ");
INSERT INTO lcm_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Au, taun ang kapo angmemengenai lak ve ria, Rakel kamela serei ve keve sipsip ang si tamana. Katapo kun katakai i aiveven sipsip kapa. ");
INSERT INTO lcm_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tamana i kavulik ke kapo tauna i rinana i Iakov. Au, kamela serei ve keve sipsip ang si tamana na Iakov kala arai ania na kala paliu na kala ul suai ani iat ang na kala ainum a keve sipsip ang si lavana. ");
INSERT INTO lcm_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Si vuk taun ang Iakov kalapo maramarak arikek luai. Ka lulus ia, ka tangis alava luai ta uruk. ");
INSERT INTO lcm_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Na kala antok ia ta kapo angtogon ve tamana na ninia kapo nat si ri Rebeka. Au, Rakel kala sang pok na kanla antok a tamana. ");
INSERT INTO lcm_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Taun a Laban kata longong a akuskus i tipasina ta Iakov, kala pasal sumasuma asian ruduai ania. Kala vongok ia na kala lulus ia, le na kala songo alak ia ane nei lu. Eiang Iakov kanla atatai ia ta keve bil aongos ang kata serei singina. ");
INSERT INTO lcm_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Asukang na Laban kala antok ia ta, “Numai kupo palpal ig atutuman luai.” Au, Iakov katala ago na sikei a ulen ve nia, ");
INSERT INTO lcm_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","na Laban kala antok ia asukang ke, “Kupo tipasig, sikei napo misag ani ku abis palau anig. Ku posong amalangas a samui ang kupo buk ia.” ");
INSERT INTO lcm_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Au, Laban katapo atogon kana pongua na kavulik, anu aino ang kana asan ta Lea, na vopo using ania nang Rakel palau. ");
INSERT INTO lcm_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea katapo ararai ro, sikei Rakel katapo ararai talupus luai si pukun ina aongos. ");
INSERT INTO lcm_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Iakov katapo buk a Rakel, asukang na kala antok a Laban ta, “Naka abis anim ani limalengua na matas aongos, na emung ku lis iau ta kam kavulik tanginang ta Rakel ani na osongon ia.” ");
INSERT INTO lcm_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Na Laban kala antok ta, “Pua, kapo roron luai ta na alis ia ane singim na parik ta ane si mang igenen petekai. Ku ago eke ve nau.” ");
INSERT INTO lcm_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Au, le iang Iakov kala abis ani limalengua na matas aongos asi luk ani Rakel. Na limalengua na matas ang kata asukang ta rukun taun lik palau using kana vubuk ani kavulik ke katapo tavirimok. ");
INSERT INTO lcm_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Emung ina Iakov kala antok a Laban ta, “Au, ku lis iau vang ta kag aina. Kag taun i abis ania kala kamus na kana nalapo buk ago ve nia.” ");
INSERT INTO lcm_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Asukang na Laban kala songo akuvul aongos na vap i ring ang na kala teng a mang sikei a matan angan. ");
INSERT INTO lcm_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Sikei si tenei ngelik sagup, kala songo le na Lea na kanla alis a Iakov tatana. Na Iakov kala rot ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban kata alis kapa kana ainan asosokai ta Silpa ani kan asosokai si Lea. ");
INSERT INTO lcm_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Au, si tenei vauk Iakov kala tapangun na kala taping ta Lea eiang. Na kala antok a Laban ta, “Au, marai sa kana kupo vil iau asukang ke? Nata abis anim asi kag osongon ani Rakel. Na marai sa kana kutala kapau iau?” ");
INSERT INTO lcm_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Na Laban kala atatai ia asukang ke, “Kamem laulauan eke parik kapa ainak ani kavulik emung kan osongon aino ani kavulik aino ang. ");
INSERT INTO lcm_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Parik. Sikei kapo ro. Ku akamusai tapai ani limalengua na taun i matan angan i osongon ke ve Lea, na emung ina namemla alis ua kapa ta Rakel. Sikei, kula abis pok le vanang na mang limalengua na matas.” ");
INSERT INTO lcm_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Au, kila akamusai tapai ani matan angan i osongon ani Lea na emung Laban kala alis ia ta Rakel ani ka osongon ia kapa. ");
INSERT INTO lcm_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Kata alis kapa ta kana ainan asosokai ta Bila ani ka asosokai si Rakel. ");
INSERT INTO lcm_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Au, na Iakov kala kun ago ve Rakel, na kata buk alava luai ania sikei Lea parik. Na Iakov kata abis ani Laban ani mang limalengua na matas aongos pok an. ");
INSERT INTO lcm_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Au, IAVE kata arai ta Iakov parik katapa buk a Lea, na kala asereiai ania ta Lea ka atogon nat, sikei Rakel ka ngolo. ");
INSERT INTO lcm_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Asukang na Lea kala atogon kana sungsungukan na kala ingus kana nat tauan. Na kala lomlomonai asukang ke, “IAVE katala arai korong ani kag mamakus. Kala koi vang kana ta kag tauan kala kun buk anig.” Le si mengen suke vanang na kala atuk a nat ang ta Ruben. ");
INSERT INTO lcm_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Au, kala anguan vinga an na kala ingus kana mang nat. Na kala lomlomonai ta, “IAVE katala nas ta kag tauan parik lak kapa buk iau, na kala alis iau kapa ta mang nat ke.” Le si mengen suke vanang na kala atuk a nat ang ta Simeon. ");
INSERT INTO lcm_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Au, na kala anguan vinga an na kala ingus kana mang nat. Na kala lomlomonai ta, “Au, kana vang nganing kisngag kala pataun iau, using natala ingus kana potol a nat.” Le si mengen suke vanang na kala atuk a nat ang ta Levi. ");
INSERT INTO lcm_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Au, na kala anguan vinga an na kala ingus a mang nat na kala lomlomonai ta, “Si nat ke, naka alatun a IAVE.” Le si mengen suke vanang na kala atuk a nat ang ta Iuda. Au, emung i nat ke, parik kata lapa anguan ingus an ani rukun taun lik. ");
INSERT INTO lcm_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Au, Rakel kala arai ta parik kapa angkoai si ingus korong ta ring nat anirilong ve Iakov na kala atogon vinga maiten ani tasina. Na kala antok a Iakov ta, “Ku alis ta kag ring nat vei nganing naka mat ta mese!” ");
INSERT INTO lcm_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Iakov kala marala na kala antok ia, “Au sa? Nau nang naka luk a pangau ang si God, voiang ninia kapo teng akit ua si atogon nat?” ");
INSERT INTO lcm_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Au, na Rakel kala antok ia ta, “Kapo ro, sikei kana kag ainan asosokai kana ta Bila. Ku ago tapai ve nia na ka ingus tapai ta kag ring nat, na le si nat ang, na kun tutapong apolokai ta kakag ta kun matan vap.” ");
INSERT INTO lcm_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Asukang na kala alis a Iakov ta kana ainan asosokai ta Bila ani kan rot ve nia asukang ta kana aina. Io, na Iakov kala rot ve nia ");
INSERT INTO lcm_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","na kala atogon kana sungsungukan na kala ingus a sikei a nat. ");
INSERT INTO lcm_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Au, na Rakel kala antok ta, “God kana vang katala asapang iau. Katala longong iau, na kala alis nat anig.” Le si mengen suke vanang na kala atuk a nat ang ta Dan. ");
INSERT INTO lcm_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Au, Bila kala anguan vinga pok an na kala ingus kana vapongua i nat. ");
INSERT INTO lcm_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Na Rakel kala antok ta, “Nata atogon angkasai lava ve tasig na kana nala dual.” Le si mengen suke vanang na kala atuk a nat ang ta Naptali. ");
INSERT INTO lcm_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Au, Lea kala arai ta parik kapa anguan ingus an na kala kun songo ani kana ta kun ainan asosokai ta Silpa na kala kun alis ania ane si Iakov ani kan kun ago ve nia asukang val kana aina. ");
INSERT INTO lcm_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Eiang Silpa kala kun ingus ta mang sikei a nat ani Iakov. ");
INSERT INTO lcm_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Na Lea kala antok ta, “Pua, kag bil roron luai!” Le si mengen suke vanang na kala atuk a nat ang ta Gad. ");
INSERT INTO lcm_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ago lik na Silpa kala anguan ingus pok an ani kana vapongua i nat ani Iakov. ");
INSERT INTO lcm_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Na Lea kala antok ta, “Pua, napo maramarak luai! Ri aina aongos kana ki posong iau ta nau a aina maramarak.” Le si mengen suke vanang na kala atuk a nat ang ta Aser. ");
INSERT INTO lcm_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Kalapo vuk taun vunga lik na taun i kopkopos kon kala serei. Mang taun Ruben kala pasal ane matang na kanla sabonai ani mang keve uriuri roron. Kala luk le ia na kamela alis a rinana ta Lea tatana. Au, Rakel kala arai ania na kala antok a Lea ta, “Pua tasig, ku alis kapa ta kag ta kun keve uriuri ani taun na inum ia nala kun atogon vinga.” ");
INSERT INTO lcm_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Sikei kala antok ia asukang ke, “Sa, parik kupa angkoai lak? Kutala luk pakang iau ta kag tauan, na kana kulapo anguan buk luk pakang anig ta keve uriuri ke.” Na Rakel kala antok asukang ke, “Kala ro luai, nganlak tenei vong ke Iakov kame rot ve numai, ngenget ani keve uriuri ke.” ");
INSERT INTO lcm_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Asukang vanang na taun a Iakov kata papok le matang tenei ngelik ang, Lea kata pasal na kanla ruduai ia na ka antok ia ta, “Natala seupok nang ua ta mang keve uriuri i la alis ta kag nat, ani ku ago vong nganlak ve nau.” Asukang na si tenei vong ang kala rot kuvul ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Na God katala longong korong a Lea na asukang kala anguan vinga pok an na kala ingus ta kana vapalpalima i nat ani Iakov. ");
INSERT INTO lcm_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Na kala antok ta, “God kana kapo seupok iau using natala alis kag ainan asosokai ane si kag tauan.” Le si mengen suke vanang na kala atuk a nat ang ta Isakar. ");
INSERT INTO lcm_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Na kala anguan vinga pok an na kala ingus kana valimalesikei i nat ani Iakov. ");
INSERT INTO lcm_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Na kala antok ta, “Kana God kapo alis iau ta alilis talupus luai. Kana vang kisngag ka aminaung singig using natala ingus ania ta limalesikei a nat aongos.” Le si mengen suke vanang na kala atuk a nat ang ta Sebulun. ");
INSERT INTO lcm_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Si mang vuk pangau pok emung ina kala ingus kana kavulik na kala atuk ia ta Dina. ");
INSERT INTO lcm_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Au, emung ina God kala lomlomonai pok ani Rakel. Kata longong kana tangis na kala itoiton pok a laka ipo matung nei vinga ta ri popo lik. ");
INSERT INTO lcm_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Au, na kala vinga na kala ingus a sikei a nat. Na kala antok ta, “Si taun ke God katala luk suai ani kag mese. ");
INSERT INTO lcm_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kapo roron ta IAVE ka alis anig ta kag mang sikei pok a nat.” Le si mengen suke vanang na kala atuk a nat ang ta Iosep. ");
INSERT INTO lcm_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Emung i Rakel i la ingus tapai ani Iosep, Iakov kala antok a Laban asukang ke, “Almug, kalapo taun ani ku atalipai anig na naka papok ane si kag rina akorong pok. ");
INSERT INTO lcm_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ku alis iau ta kag ngono aina na kag inatus kana nata mela abis amarai aniria singim, na naka pasal. Numai akorong kupo malangas aro luai ani abis lava ang natala teng anim tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Sikei Laban kala antok ta, “Man kupo ainak, napo sokotuk ani ku ago. Natala arai si kag keve tangatangai ta IAVE kapo vil atauia iau using numai palau. ");
INSERT INTO lcm_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kapo ro, posong kam samui na naka seupok ua.” ");
INSERT INTO lcm_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Na Iakov kala antok ta, “Numai kupo malangas aro ta natalapo abis alava luai anim, na kupo malangas aro ta kam keve vongo kita polok aro si kag aiveven. ");
INSERT INTO lcm_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Menlik ang kutapo atogon ia aino ani kag serei eke, kana katala polok alava luai. Si saka oring an natapo ago singina IAVE katapo vil atauia ua. Sikei nei akorong vang kakag ta kun taun si abis akorong anig na kag inatus?” ");
INSERT INTO lcm_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Au, Laban kala sui ia ta, “Naka alis vang kana ua ta sa?” Na Iakov kala polpol ta, “Ago ta alis an anig ta mang sikei a bil. Sikei man ku abis a ring sikei a bil palau anig, naka aiveven aliu lak tapai ani kam keve vongo. ");
INSERT INTO lcm_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Napo buk ani tarung ainainakai asukang ke: Atalipai anig na nakan pasal nei liuan kam keve meme na kam keve sipsip, na nakan irang suai nei liuan iria, riria kipo atogon salik na riria kapa kipo ituitumai na kipo pukun miting. Riria vanang, kilapo kag samui. ");
INSERT INTO lcm_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Kag atutuman si bil ke ka serei amalangas singim iles lak, man kupo buk ararai pok ani samui ke ku seupok iau tatana. Saka meme vo sipsip an parik kapa atogon salsalikai kime serei lak nei liuan i kakag ta keve vongo, ka malangas singirung aongos ta nata tainau iria.” ");
INSERT INTO lcm_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Au, Laban kala antok ta, “Io, napo ainak luai. Kapo ro ani ka asukang palau val kutala posong atangis ia.” ");
INSERT INTO lcm_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Na nia si taun ang akorong Laban kala pasal na kanla irang suai ani keve meme tauan vap po ituitumai na salik ang, na asukang kapa si keve meme aina aongos ang. Keve sipsip kitapo atogon ituitumai posok singiria na keve sipsip miting aongos kata irang suai kapa aniria. Riria aongos vang kana kata alis kana keve nat ani ki an aiveven iria. ");
INSERT INTO lcm_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Kila pasal ane ring vunga akipai ani Iakov. Pangau ang nei liuan irilong ve Iakov, kipo angkoai si pasal ania ani potol a taun aongos. Au, na Iakov si taun ke katapo aiveven lak kana mang keve vongo na Laban. ");
INSERT INTO lcm_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Au, Iakov kanla tangai le ta mang keve ngakan lik i mang keve ei posok. Kala dek suai ani palpal i kulit iria ani ki atogon salsalikai. ");
INSERT INTO lcm_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Le na kamela asiang iria nei keve vulvul ipo inum ang ta ri vongo, ani taun ki serei sime inum, bil ang kapo matung amalangas luai e noria. Taun ri vongo aina kila pukun manas ta buk tauan, na ki pasal sime inum, kimela ago kuvul ve keve vongo tauan e mete keve ngakan ang. Na si selen ke nganlak kila ingus na keve natnat tanginang atogon salik na pukun ituitumai kapa. ");
INSERT INTO lcm_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Na Iakov kala irang suai ani keve natnat tanginang lik ang apetekai, na mang matan ang kala atung iria ani ki tu talang a keve vongo salik na pukun miting ang si Laban. ");
INSERT INTO lcm_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Na taun a keve vongo aina vap po dual ang kila pukun manas, Iakov kala amatung a keve ngakan ang e noria ani ki ago kuvul mete nem ang. ");
INSERT INTO lcm_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Si keve vongo vo ngau ang parik katapa abis iria asukang ke. Asukang na si selen ke, vap po pukun ngau ang kita pasal ane si Laban, na keve anu dual kita pasal ane singina. ");
INSERT INTO lcm_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Au, si selen ke Iakov kata serei atauia alava luai na kala kun atogon ani kakana ta kun tangan vongo lava luai akorong. Kata atogon kapa kana keve asosokai i ri aina na ri tauan, na kana keve kamel na keve dongki kapa. ");
INSERT INTO lcm_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Na Iakov kala longong kana keve nat a Laban kipo angtokai ta, “Iakov nang katala luk aongos a sa na tamara katapo atogon ia na kala tauia le si kana keve bil a tamara.” ");
INSERT INTO lcm_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Na kala arai ta karilong angtunganan ve Laban parik katalapo anguan roron an val aino. ");
INSERT INTO lcm_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Asukang na IAVE kala antok ia asukang ke, “Ku papok ane si roe ang si keve tamam na kam pat vap akorong. Naka auai ve numai.” ");
INSERT INTO lcm_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Au, Iakov kala alis mengen ani Rakel ve Lea asi karitol me angruduai si ring ang kana keve vongo kitapo ago singina. ");
INSERT INTO lcm_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Na kala antok irilong asukang ke, “Napo arai ani tamamilong na nalapo arai ta kana laulauan ane singig kalapo petekai ani aino. Sikei God ang si mamai kapo uli auai lak ve nau. ");
INSERT INTO lcm_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Milongpo nas ta nata abis ani tamamilong ta kag dual aongos, ");
INSERT INTO lcm_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","sikei lak katapo kapau alava iau na ka sasakol kag keve seuseupok amatan sangauli aongos a taun. Sikei God parik katapa atalipai ania ani ka vil arikek iau. ");
INSERT INTO lcm_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Si man katapo antok ta keve vongo ituitumai ang kapo kag samui, nganlak a keve vongo ang ki ingus asereai ani ri anu ituitumai papalik. Na si man ka antok ta keve anu salik ang ki kag samui, nganlak ki ingus asereai ani ri anu salik papalik. ");
INSERT INTO lcm_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Asukang vanang na God katala luk suai ani kana keve vongo a tamamilong na katala alis iau tataria. ");
INSERT INTO lcm_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Si taun ipo apitus, nata atogon a mang sikei a orodung. Nata tun alak na nala arai ta keve me tauan aongos ang kitapo ago kuvul ve keve me aina, kipo atogon salik na pukun ituitumai. ");
INSERT INTO lcm_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Au, asosokai si God kala songo iau ta, ‘Iakov!’ Na nala polpol ta, ‘Io, nau kana.’ ");
INSERT INTO lcm_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Na kala antok iau asukang ke, ‘Tun alak na ku arai ta keve me tauan suke kipo ago kuvul ve keve me aina, riria aongos kipo atogon salik na pukun ituitumai. Napo pakangai anim asukang ke using napo nas aro a keve lau ang a Laban kata abis ia singim. ");
INSERT INTO lcm_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nau kana na God voiang kutala palpalatung ve nau e Betel. Na kutala akanangai ani kam palpalatung si vuk iat ang. Kana, ku tapasuk suai ani ring ke na ku papok ane si rina ang kita asereai anim singina.’” ");
INSERT INTO lcm_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Au, ri Rakel ve Lea kilong tala longong a akuskus ang si Iakov na kilongla mengen ia asukang ke, “Parik namemlong pa anguan atogon an ani kamemlong palpal i togtogon ang si tamamemlong. ");
INSERT INTO lcm_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Lenginang namemlong lapo bil val sokoung e matana. Katala atos tatamemlong na kala angan aongos na samui imemlong. ");
INSERT INTO lcm_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kalapo tutuman luai asukang ke ta kana keve tauia voiang God kata luk suai ania, kalapo kakamemlong ve kamemlong inatus.” ");
INSERT INTO lcm_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Au, Iakov kala tapasuk asi kana pasal pok ane si roe ang si tamana ta Aisak e Kanan. Kala agon kana ngono aina ve inatus kuli kamel na kila pasal. Kana keve vongo aongos na kana keve togtogon aongos i kana asereai ang e Padan Aram, kata apasal iria eno. ");
INSERT INTO lcm_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Aino, si pangau ang a Iakov katanpo tok sipsip singina, Rakel kata luk musik a keve tangatangai ang i neina i lu si tamana, na Iakov parik kapa nas. ");
INSERT INTO lcm_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Na mang anu, Iakov kata kapau na Laban le Aram ta tav mengen amalangas ania ta kalapo usausa asi sip pelek ania. ");
INSERT INTO lcm_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Au, Iakov kala tapasuk na kala sip veai ani kana togtogon aongos. Kanla ngum putuk a Iuperetes na kanla palak taun a palpal kuli putput ang e Gilear. ");
INSERT INTO lcm_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Si vapotol i taun Laban kala longong ta Iakov katala sip. ");
INSERT INTO lcm_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Asukang na kala songo aiton a keve tungana na kila lu using na Iakov. Si va limalengua i taun kanla sabonai ania si palpal kuli putput ang e Gilear. ");
INSERT INTO lcm_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Si tenei vong i taun ang, God katala mengen a Laban nei orodung asukang ke, “Ku aiveven ta ku ago ta asuai an ta vuk mengen rikek vo mengen roron ane si Iakov.” ");
INSERT INTO lcm_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Io, ninia si taun ang, Iakov katapo atu lu eiang e palpal kuli putput, na Laban kanla sabonai ania eiang. Asukang na ri Laban ve keve tungana kila kun atu lu eiang. ");
INSERT INTO lcm_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Au, Laban kala ki na Iakov asukang ke, “Marai sa kuta abis a lau rikek ke? Kuta kapau iau si sa? Marai sa kuta akos suai ani kag ngono kavulik val vap amiming si taun i visvis? ");
INSERT INTO lcm_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Marai sa kuta sip musik asukang? Marai sa parik kutapa mengen amalangas aro? Man kuta mengen amalangas aro, nala vil matan angan asi kara angatatungai ta uruk na mikamika na tangam. ");
INSERT INTO lcm_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Marai sa parik kutapa atalipai anig ani na lulus atatung a keve vuvui ke na ngono rinaria? Sikei kutala vil a lau nio asukang ke! ");
INSERT INTO lcm_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Napo atogon kana na kitmat si vil arikek anim, sikei God ang si tamam kata antok vong iau asi kag ago ta asuai an ta vuk mengen roron vo mengen rikek dong anim. ");
INSERT INTO lcm_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Napo malangas ta kutala tapasuk suai using kam vubuk lava luai ani ku papok ane si tamam. Sikei marai sa kuta tainau na keve tangatangai i neina i kag lu?” ");
INSERT INTO lcm_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Na Iakov kala antok a Laban asukang ke, “Natapo leng ta ku teng apok kam ngono kavulik. ");
INSERT INTO lcm_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Sikei kapo ro, man ku sabonai ta sikei imem kapo teng kam keve tangatangai, igenen ang ka mat. E mataria i keve tungara ke, numai akorong ku ararai ta man kapo atogon ta bil kapo kakam na kapo ago eke singig, ku luk ia.” Iakov parik katapa malangas ta Rakel nang kata tainau na keve nem ang. ");
INSERT INTO lcm_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Au na Laban kala palak nei lu si Iakov, na nei lu si Lea, na si ngono ainan asosokai ang, sikei parik katapa sabonai ta bil. Kala soung le nei lu si Lea na kamela palak akorong nei lu si Rakel. ");
INSERT INTO lcm_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Io, na Rakel katala amunai ani keve tangatangai ang e neina i kana sinsinong i kuli kamel na kala gon lakat kuli sinsinong ang. Au, Laban kamela gule pulakai e nei kana lu, sikei parik kapa sabonai ta bil. ");
INSERT INTO lcm_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Na Rakel kala antok a tamana ta, Mamai, ku ago ta atu marala an anig si kag tav tadut e matam, sikei napo ulen nang.” Asukang na kata gulegule tav sabonai ani keve tangatangai ang. ");
INSERT INTO lcm_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Au, na Iakov kala tapasuk na kala sui marmaralan a Laban asukang ke, “A, nei kag rikek evoi? Saka lau rikek an nata abis ia ane singim na kumepo lu using iau asukang ke? ");
INSERT INTO lcm_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kutala gulegule alava si kag keve togtogon. Au, kutala sabonai akorong ani sa nang kapo kakam i nei kam lu akorong? Asinong ia eke e ring malangas, e mataria i kam keve angtogon na kakag kapa. Au na ki antok vanang ta ke si ta bil akorong. Sikei, ku arai, kapo kovek luai nang! ");
INSERT INTO lcm_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nata ago ve numai na pongua na sangauli na matas amot sipo aiveven ani kam keve sipsip na kam keve me, na parik kitapa akau a mat lik tapai. Na parik kapa natapa angan lik ta sikei a sipsip tauan i kam keve vongo. ");
INSERT INTO lcm_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Man ri kauvek loi kitame rangas ta mang vongo, parik natapa akalit ua tatana, using nau akorong natapo uli seupok musik ania. Au, na man kita tainau tenei vong vo tenei ias, kutapo uli sungil anig asi seupok ania. ");
INSERT INTO lcm_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kag ago katapo asukang ke: Ngan i sinang katapo ngan iau tenei ias na mulak lava katapo meng iau tenei vong, na parik natapa rot aroron. ");
INSERT INTO lcm_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Katapo asukang ke ani pongua na sangauli na matas aongos ang natapo ago ve numai. Nata abis a sangauli na puat a matas ani kam ngono kavulik na limalesikei a matas ani kam keve vongo. Ani kag seuseupok, kuta sasakol ia a matan sangauli aongos na taun. ");
INSERT INTO lcm_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Sikei napo nas ta God kata pakangai anig. Ninia palau na God ang mamai ta Aisak kapo mamaila ania, na vuivui ta Abaram kata using ia, man ninia parik katapa pakangai anig, kula asok suai anig kovek luai i bil. Sikei katala arai ani kag kui na kag abis lava na asukang kala ki bat ua tenei vong.” ");
INSERT INTO lcm_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Au na Laban kala polpol a Iakov asukang ke, “Ngono aina ang, kag ngono kavulik. Na karilong inatus, kakag ta inatus, na keve vongo aongos ang, kakag kapa. Keve bil aongos eke kapo kakag. Sikei nala abis sa akorong vang kana ani kag ngono kavulik na karilong matan inatus? ");
INSERT INTO lcm_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Me na tarung palpalatung kuvul, na karung palpalatung ka tung akit val karung akanangai.” ");
INSERT INTO lcm_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Au, asukang na Iakov kala luk a mangsikei a iat na kala atung atung ia. ");
INSERT INTO lcm_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Na kala asok kana vap ta “Mi lukluk iat ane ke.” Na kimela asinong kuvul na keve vuk iat ang si sikei a kirim, le na kila matan angan eiang ngere kirim ang. ");
INSERT INTO lcm_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","48","Au, Laban kala antok ta, “Kirim iat ke kapo tung akanangai ani karung palpalatung si taun ke anginang.” Le si mengen ke vanang na kana asan a ring ang ta Galer, supsupai ina ta kirim i akanangai. Laban kata posong ia si kana mengen ta Iegar Sa-aduta, na Iakov kata posong ia si kana mengen ta Galer. ");
INSERT INTO lcm_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","50","Na Laban kala mengen kapa ta, “IAVE ka ararai anirung si taun tarung po ago angpetpetekai anirung pok. Man kula tav aiveven aro ani kag ngono kavulik, vo man kula osongon ta mang keve aina atava irilong, kupo malangas ta God kapo arai anirilong si karung angmemengenai kana, kantanem tarung papalik tarungpo ago si vuk taun ke.” Le si vuk mengen suke na kana mang asan a ring ang ta Mispa. ");
INSERT INTO lcm_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Au Laban kala mengen kapa na Iakov asukang ke, “Kana vang kana na kirim iat ke na kana vang kana na iat ke natala atung ia nei liuan irung, ");
INSERT INTO lcm_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","kilongpo akanangai ani nau na ago ta pasal liu irilong ane si kam palpal roe, na numai kapa ku kun ago ta pasal liu an ane si kakag ta palpal asi vil arikek pok anirung. ");
INSERT INTO lcm_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","God ang si ri Abaram ve Naor na tamarilong, ninia kapo arai anirung na ninia vanang ka saupai anirung ta mengen ke kana kapo tutuman vo kapo tav tutuman.” Asukang na Iakov kala palpalatung mete Igenen Mamaila ke IAVE, voiang a tamana ta Aisak kapo mamaila ania, ");
INSERT INTO lcm_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","na kala sulsuluk kana alilis ane singina eiang e palpal putput na kala songo kana petau asi me matan angan. Emung i kari matan angan kila rodot aongos e iang. ");
INSERT INTO lcm_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Si tenei vauk lik Laban kala tapasuk na kala lulus atatung a keve tivuna na kana ngono kavulik na kala ponsong atautauia iria aongos. Au le na kala papelek iria na kala papok ane si kana rina. ");
INSERT INTO lcm_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Na taun ang Iakov kalapo kun akikik kak using ani kana paspasalan, na keve angelo si God kimela angruduai ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Taun kala arai aniria na kala posong ta, “Pua, nala arai ani kana kuvkuvulan a God!” Le si oring ang vanang na kala atuk a ring ang ta Manaim. ");
INSERT INTO lcm_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Taun ang tasina i Iakov ta Esau katapo ago e Seir si palpal Edom. Na Iakov kala asok igenen aino ane singina ");
INSERT INTO lcm_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","velai ani pinipini ke, “Mianla mengen kag tulava ta Esau asukang ke, ‘Kam asosokai ta Iakov kapo mengen ta, “Natanla ago aongos a taun ke si Laban tung kana. ");
INSERT INTO lcm_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Napo atogon bulumakau, dongki, sipsip, me, na keve tauan na ri ainan asosokai miang. Na kana napo alis a mengen amalangas ke ane singim, kag tulava, ta man kapo koi ua na man kupo roron na tarung an angruduai.” ’” ");
INSERT INTO lcm_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Au na taun a keve vap i asok ang kimela serei pok si Iakov, kimela antok ia ta, “Namemtala pasal na namem anla serei si tasim ta Esau. Au na kame lapo pasal nang si me angruduai ve numai. Na 400 na igenen kipo auai ve nia.” ");
INSERT INTO lcm_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Na Iakov kala longong a bil ke na leng ve makus lava kala sip ia. Asukang na kala pagpagal na vap po auai ang ve nia ane si pongua na kuvkuvulan. Na keve sipsip, keve me na keve bulumakau na keve kamel aongos ang kapa. ");
INSERT INTO lcm_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kapo lomlomonai ta man a Esau kala serei korong na kamela visvis a mangsikei i ngono kuvkuvulan ke, anu vopo kalakala ang kila angkoai si sip. ");
INSERT INTO lcm_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Au, Iakov kala pagal iria le na kala sokotuk asukang ke, “God, kupo God si vuvui ta Abaram, na kupo God si mamai ta Isak. Io, numai IAVE, kutala antok iau ta man nala papok ane si kag rina na kag vap akorong pok, kula atautauia iau. ");
INSERT INTO lcm_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Parik napa koi a keve roron ve keve lau tutuman ke kutala asereai ania singig, kam asosokai. Taun nata paputuk a sung ke e Ioridan, natapo teng palau kag vuk kipa. Sikei kana, kag togtogon kala serei si pongua na kuvkuvulan. ");
INSERT INTO lcm_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Napo sokotuk ua kana ta ku akala iau pelek a tasig. Napo leng luai ta nganlak ka serei na ka raung aongos imem kuvul ve keve aina natan ke na kari inatus. ");
INSERT INTO lcm_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Kag sokotuk using kuta antok iau ta ku atautauia iau na ku apolokai ani kag pat vap ani ki duk val kone i ngerelo, na ki tav taot korong aniria.” ");
INSERT INTO lcm_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Kala kamus kana sokotuk na Iakov kala rot a vong ang eiang. Au na kala pilak le nei liuan kana togtogon using kala lomlomonai ani mangsikei a alilis ani tasina ta Esau. ");
INSERT INTO lcm_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Kana vang a keve alilis. 200 na me aina na 20 na anu tauan. 200 na sipsip aina na 20 na anu tauan. ");
INSERT INTO lcm_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 na kamel aina ve kari keve natnat. 40 na bulumakau aina na 10 na anu tauan. 20 na dongki aina kapa na 10 na anu tauan. ");
INSERT INTO lcm_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Au, kala pagal angpotok taun kana keve asosokai ta siksikei a kuvkuvulan i keve manmanik aongos ang na kala antok iria, “Mi pasal aino iau, na ka uli atogon ta pangau e nei liuan i keve siksikei a kuvkuvulan i manmanik ang.” ");
INSERT INTO lcm_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Eiang kala pinipini na asosokai vo tung aino ang asukang ke, “Man a tasig ta Esau kala duai ua na kala sui ua ta, ‘Taukai im ta si? Ku ane voi? Na si kapo tauk i keve manmanik ke kipo pasal aino ua?’ ");
INSERT INTO lcm_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Na ku polpol ia ta, ‘Kag igenen lava, kam asosokai ta Iakov kapo tauk iria. Na kipo kakam nang ta alilis. Na ninia nang a Iakov kapo aimung imem.’” ");
INSERT INTO lcm_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Kala pini kapa na vapongua na vapotol i asosokai, na riria aongos kipo auai emung i keve kuvkuvulan manmanik ang ta man a Esau kala duai iria ki polpol ta sikei palau a vuk posong ang, ");
INSERT INTO lcm_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","na ki antok ia ta, “Arai, kam asosokai nang ta Iakov kapo aimung imem.’” Iakov katapo lomlomonai asukang ke ta, “Man kana naka asok aino na keve alilis ke, kala vinga marip anig nganing. Au na emung man kala arai korong anig kala angkoai si ruduai anig val napo tasina.” ");
INSERT INTO lcm_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Asukang vang a keve alilis ang kita pasal aino ani Iakov, na ninia kala rot pok le na vong ang si kari vuk oring. ");
INSERT INTO lcm_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Au, nei liuan i tenei vong ang Iakov kala songo kana engo na kana ngono ainan asosokai na kana 11 a nat na kala asok aino iria na kianla ngusputuk si papaputukan i sung ang e Iabok. Le na kana keve togtogon aongos kila kun aimung aniria. ");
INSERT INTO lcm_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Sikei ninia kala ago papalik pok emung. Na mangsikei a igenen kamela angpuagai ve nia. Kilongta angpuagai tung si tangat. ");
INSERT INTO lcm_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Na igenen ang kalapo nas ta parik kapa angkoai si ka dual, asukang na kala sigil a ngusngus ina i Iakov, akorong si ring ipo angrodoai ta ngono tuan ang na kala takavis. ");
INSERT INTO lcm_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Na igenen ang kala antok a Iakov ta, “Ai, ku atolongon iau lak. Makarap kana kalapo buk sanglak.” Sikei Iakov kala antok ta, “Parik. Parik napa atolongon ua tung si kula poso atautauia tapai anig.” ");
INSERT INTO lcm_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Na igenen ang kala sui ia ta, “Kam asan ta si?” Na kala antok ta, “Iakov.” ");
INSERT INTO lcm_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Au, igenen ang kala antok ia ta, “Kam asan parik kalapa anguan Iakov an. Kam asan tanginang vang kana ta Israel, using kutala angpuagai ve God na kapa ve ri vap na kuta lapo uli dual.” ");
INSERT INTO lcm_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Eiang Iakov kala sokotuk ia ta, “Au, kapo angkoai si ku kin tapai ani kam asan?” Sikei nia kala antok ta, “Marai sa kupo kun buk nas ani kag asan?” Le na kala poso atautauia na Iakov eiang. ");
INSERT INTO lcm_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Le iang vanang na Iakov kala luklukai ani vuk mengen ke ta, “Using natala tu angtalang ve God ta matag akorong na parik nata lapa mat, io, nala atuk vang kana na ring ke ta Peniel.” ");
INSERT INTO lcm_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Au na makarap kalapo sanglak na Iakov kala ultaliung a Peniel na kalapo pakipa ta ngusngus ina ");
INSERT INTO lcm_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","using a igenen ang katala sigil ia si kana angrodoai i tuan. Io na le si oring suke vanang ri Israel tung si taun ke parik kipa angkoai si angan ani sin ang kapo angrodokotai si tuan i ngusngus iria i ri manmanik. ");
INSERT INTO lcm_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Au, Iakov kala tun avunga na kala arai ta Esau kame lapo pakasang. Kana 400 na igenen kitapo auai ve nia. Asukang na Iakov kala pagal angpotok kana inatus ane si keve rinaria akorong, Lea, Rakel na ngono ainan asosokai ang. ");
INSERT INTO lcm_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Kala atung eno na ngono ainan asosokai ve karilong ta inatus, na using irilong, Lea ve kakana ta kun inatus, au na emung luai, Rakel ve Iosep. ");
INSERT INTO lcm_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Au, na ninia akorong a Iakov kata tung ainoai aniria. Na kala pasal asian angruduai ve Esau na kapo soturungai aliu amatan limalengua ane nei roe. ");
INSERT INTO lcm_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Sikei Esau kala sang taun ia na kamela vongok ia, ka lulus ia, na kilongla angtangisai aongos. ");
INSERT INTO lcm_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Au, Esau kala takngo na kala arai ani keve aina ang ve kari keve nat na kala sui ta, “Au na ri si kana ve numai?” Na Iakov kala antok ta, “Riria palau a inatus ang voiang a God, si kana roron na kala lis kam asosokai tataria.” ");
INSERT INTO lcm_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Na ngono ainan asosokai ang ve karilong inatus kilong pakasang na kimela kun soturungai. ");
INSERT INTO lcm_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Au na Lea kapa ve kana inatus na ngono akamusai i angnanan kapa, ri Iosep ve Rakel. Aongos kimela soturungai. ");
INSERT INTO lcm_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Na Esau kala luklukai ta, “Nata duai nang a keve kuvkuvulan i manmanik. Nei vanang? Kupo saka lomlomonai an?” Na Iakov kala antok ta, “Kag alilis anim, man kupo roron, kag tulava.” ");
INSERT INTO lcm_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Sikei Esau kala antok ia ta, “Apua tasig! Nalapo kun duk akorong nang. Kapo ro ani kakam a keve tangan ang.” ");
INSERT INTO lcm_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Na Iakov kala antok ta, “Iau? Parik! Man kana kulapo roron anig, ku naung ani alilis ke napo alis ua tatana. Taun ke kana napo arai anim, kapo asukang ta napo arai ani nona i God, using kume lapo sesel aro pok iau. ");
INSERT INTO lcm_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Napo sokotuk ua ta ku naung ani sa kana napo alis ua tatana using a God katala kun atautauia alava anig, na napo duk luai.” Emung, Esau kala naung ani alilis ang using Iakov kata lapo gel adual ia. ");
INSERT INTO lcm_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Au na Esau kala antok ta, “Kanat. Tara pasal kuvul. Nau naka ausingai anira.” ");
INSERT INTO lcm_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Sikei Iakov kala antok ia ta, “Kag tulava, kupo nas nang ta inatus ke kilapo ngau. Au na napo buk pasal ananap kapa si aiveven ani keve sipsip na bulumakau ke ve kari keve natnat. Using man nganing tarala aisul alava iria si sikei palau a taun ke, nganlak a keve manmanik aongos ke ki mamat. ");
INSERT INTO lcm_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Asukang kag tulava, napo kam asosokai na kapo ro ani ku pasal aino anig. Na nau nala pasal ananap lik emung im, angkokoai si paspasal ve keve manmanik na inatus ke kapa. Nanla serei lak singim, kag tulava, eiang e Seir.” ");
INSERT INTO lcm_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Au na Esau kala antok ta, “Kapo ro palau, sikei napo buk alis anim ta kag mang rukun igenen asi auai ve numai.” Sikei Iakov kala antok ta, “Kag tulava, parik. Napo ro palau nang. Napo sokotuk ua ta ku naung anig.” ");
INSERT INTO lcm_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Asukang na si taun ang pok, Esau kala papok ane Seir. ");
INSERT INTO lcm_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Sikei Iakov kala pasal ane Sukot na kanla atung kana lu eiang. Au na kala atutu lu kapa ani kana keve manmanik asi kari marmarip. Le si oring suke vanang na kila posong a ring ang ta Sukot. ");
INSERT INTO lcm_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Io, sukana na akuskus i kana papelek ani Padan Aram a Iakov na kamela serei e ke e palpal Kanan si rina ang si Sekem na kamela ago eiang ngere rina ang. Kata kovek ta bil kata vil arikek ia, si kana paspasal. ");
INSERT INTO lcm_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Au na kala samui a vuk roe ang kata lapo atu lu singina si keve nat ang si Amor. Amor katapo tamana i Sekem. Kata samui ia ta 100 na vuk kapkap. ");
INSERT INTO lcm_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Au, na kala solo atung a mangsikei a pata ipo sula eiang. Na kala atuk a pata ang ta El Eloe Israel. ");
INSERT INTO lcm_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Si taun ke Iakov kata lapo atogon kana kavulik kana asan ta Dina, rinana ta Lea. Au, mangsikei a taun Dina kata pasal si an vokvokol ani mang keve aina i ring ang. ");
INSERT INTO lcm_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Na Sekem kala arai ania na kanla tak ia na kala rot ve nia. Tamana i Sekem ta Amor. Amor kapo igenen i Iv na kapo tulava kapa i ring ang. ");
INSERT INTO lcm_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekem kata lapo buk alava luai ani Dina na kalapo mengen aro lik i vubui ania. ");
INSERT INTO lcm_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Asukang na kanla pataun a tamana ta Amor na kanla antok ia ta, “Ku samui a kavulik ke anig na naka osongon ia.” ");
INSERT INTO lcm_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Au, Iakov kala longong ta Sekem katala vil arikek kana kavulik. Na using kana keve nat kitapo aiveven sipsip aongos lak e ring vunga, parik kata lapa angkoai si atatai aniria, tung akorong si kimela serei pok e rina. ");
INSERT INTO lcm_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Au na Amor, nang a tamana i Sekem, kala tapasuk na kame lapo angmemengenai ve Iakov. ");
INSERT INTO lcm_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Na si vuk pangau ke akorong keve nat ang si Iakov kila longong sigil ta sa katala serei, kimela papok ane rina. Kitala mamakus luai na kipo marala alava kapa using Sekem katala abis a lau rikek taun a Israel, ta katala rot ve kana kavulik a Iakov. Matan lau asukang ke parik luai kitapa ainak ania. ");
INSERT INTO lcm_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Sikei Amor kala mengen iria asukang ke, “Kana lomlomonai kag nat ta Sekem kalapo kitmat taun a kavulik ke. Kapo ro ani mi naung ani ka osongon ia. ");
INSERT INTO lcm_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Tara angososongon nei liuan ira. Namem samui aina singimi na nami kapa, mi samui aina singimem. ");
INSERT INTO lcm_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Tara ago kuvul nei palpal ke. Roe ke kapo tavas animi. Mi kalakala luai si ago si roe ke, na mi abis kami keve abis na mi tauk i keve vuk roe kapa.” ");
INSERT INTO lcm_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Au na Sekem kala kun mengen taun ani tamana i Dina ve keve tauna, “Man kana mipo roron anig, napo usausa luai si alis animi nganlak ta sa mi sokotuk iau tatana. ");
INSERT INTO lcm_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mi posong palau a samui na saka alilis lava an mipo buk ia, na nau nala samui using palau kami vubuk. Napo buk palau ta mi naung anig ta kavulik ke, na nala osongon ia.” ");
INSERT INTO lcm_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sikei keve nat ang si Iakov kilapo tere ta lau rikek ang katala abis ia si Dina. Asukang na kila kapau a ngono angtama ang, Sekem ve Amor asukang ke, ");
INSERT INTO lcm_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Parik namempa angkoai luai si alis ani taumem ane si igenen po tav lampulit ang. Kupo songo mamaila nang animem. ");
INSERT INTO lcm_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Sikei namemla naung anim si osongon ania si oring ke ta mi lampulit aongos ri vap tauan na mila asukang val namem. ");
INSERT INTO lcm_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Le vanang na mi osongon singimem na namemla kun osongon singimi. Na namemla ago ve nami na tarala serei a sikei a matan vap. ");
INSERT INTO lcm_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Sikei man mipo misag ani lampulit animi, namemanla songo suai le ani taumem na namemla pasal.” ");
INSERT INTO lcm_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Au, ri Amor ve Sekem kilongla arai ania ta sokotuk ke kapo roron palau. ");
INSERT INTO lcm_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sekem katapo posongan nei liuan i matan vap ang si tamana. Na parik katapa buk amomole si amalangasai ani sokotuk ang using katapo vubuk alava na kavulik ke si Iakov. ");
INSERT INTO lcm_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Asukang na ngono angtama ang kilong anla tung e mete takaman alak ane nei kari rina na kilongla mengen dong a ri tauan aongos asukang ke, ");
INSERT INTO lcm_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Keve vap ke kipo buk angtunganan ve tara. Asukang na tara atalipai aniria na ki ago na ki abis kari keve avibisan si kara palpal. Arai, kapo angkoai pangau nang anira aongos si ago kuvul. Ani tara angkoai si osongon singiria na riria ki osongon singira. ");
INSERT INTO lcm_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Sikei, ring bil ta tara ri tauan, tara ainak tapai ani sikei a bil ke. Tara lamlampulit ira aongos val ria, le vang na kila ainak ani ago ve tara asukang ta sikei palau a matan vap. ");
INSERT INTO lcm_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Arai, man tara abis a bil ke, nganlak kari keve vongo, kari togtogon na kari mang keve manmanik aongos kala kakara kapa. Asukang a tara longong palau a sa kipo lomlomonai ania na ki ago ve tara.” ");
INSERT INTO lcm_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Na ri vap aongos eiang mete takaman i rina ang kila longong aongos a sa ri Amor ve kana nat ta Sekem kilongta posong ia, na kila ainak aro aongos, na ri tauan aongos kila lampulit iria. ");
INSERT INTO lcm_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Au, emung i potol a taun kala liu na petau ang lak kipo ago i kui, kana mang ngono nat a Iakov, ri Simeon ve Levi, kilongla luk le karilong keve samele i visvis na kilong anla serei ataping nei rina ang na kilongla vis punuk aongos a ri tauan. Ngono nat ke kilongpo ngono tauna akorong i Dina. ");
INSERT INTO lcm_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Na kilongla raung a Amor ve kana nat ta Sekem na kilongla songo suai ani Dina nei lu ang si Sekem na kilongla pasal. ");
INSERT INTO lcm_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Au, keve nat ang si Iakov kimela serei na kila pasal nei liuan i keve matmat ke na ki aunga aongos a togtogon i nei rina ang marai kita akeke na taurilong. ");
INSERT INTO lcm_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Kita luk aongos ri sipsip ve ri me, ri bulumakau, ri dongki na mang keve bil aongos i nei rina ang na i nei matang kapa. ");
INSERT INTO lcm_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Kari saka keve tauia an kapa, kita luk aongos iria. Na kari togtogon i nei lu kapa, kita vil arikek luai ania na ki kong ato aongos kari keve aina na inatus. ");
INSERT INTO lcm_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Na Iakov kala tutalang ri Simeon ve Levi na kala antok irilong ta, “Pua, kana vang milong tala songo mamaiten ani pukun ig. Kana ri Kanan ve ri Peres, vap tauk i roe ke, ki mirik luai anig. Tataot ira kana kapo menlik palau. Au na man kila tung kuvul na kila vis iau, pua nganlak ki dunguk aongos iau ve kag vap.” ");
INSERT INTO lcm_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Sikei kilongla polpol ia ta, “Au kapo saka ro na lau asukang ke ta igenen ang kame lapo gulang a taumemlong val kapo katakai i luk tauan pulakai?” ");
INSERT INTO lcm_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Na God kala antok a Iakov ta “Ku tadut na ku palak pok ane Betel na kuan ago eiang. Kuan solo atung ta mangsikei a pata ipo sula serei singig using si taun ang kutapo sip ani tasim Esau, nau nata serei singim.” ");
INSERT INTO lcm_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Asukang na Iakov kala antok kana patvap ve ria vap po auai kuvul ang ve nia ta, “Mi atolongon suai ani kami keve tangatangai na mi vil adaus imi, na mi alak kami keve maus tanginang. ");
INSERT INTO lcm_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Au na taran palak alak ane Betel. Eiang nakan solo atung ta mangsikei a pata ipo sula serei si God using ninia kata pakangai anig si kag keve taun mamaiten na katapo uli auai ve nau si keve rina aongos natapo pasal ia.” ");
INSERT INTO lcm_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Asukang na kila alis a Iakov ta kari keve tangatangai na keve muraling i talingaria na Iakov kala amunai aniria neite ei lava vo tung ang e ngere rina ang e Sekem. ");
INSERT INTO lcm_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Au kila tapasuk aongos na kila pasal. Na God kala vil aleng aongos a vap i nei keve rina aulitai ang aniria na parik kilapa lu using korong iria. ");
INSERT INTO lcm_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Au, asukang na Iakov kamela serei e Lus ve vap aongos po auai ang ve nia. Lus kapo ago nei palpal Kanan na kana mang asan ta Betel. ");
INSERT INTO lcm_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Au, kala serei na kala solo atung a pata ipo sula na kala atuk a ring ang ta El Betel. Using eiang vanang God kata tutu aserei singina i kana po sip ang ani tasina. ");
INSERT INTO lcm_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Eiang kapa, Debora kala mat, aina vopo aiveven ang ani Rebeka. Na kila amunai ani matmat ina neite ei lava ang e Betel. Na kila kin a ei ang ta Alon Bakut. ");
INSERT INTO lcm_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Io, emung i kana papok le Padan Aram a Iakov, God kala anguan serei an singina na kala atautauia ia ");
INSERT INTO lcm_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ta mengen asukang ke, “Kam asan ta Iakov. Sikei kana parik kulapa anguan Iakov an, naka atuk ua ta Israel.” Sukana vang kala poso akit ia ta Israel. ");
INSERT INTO lcm_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Na God kala antok ia kapa ta, “Nau kana na God kitmat luai. Ku apitus adual na ku polok asukang ta sikei a matan vap. Nganlak a mang keve matan vap miang ki polok serei le singim kuvul ve ri tulava iria kapa. ");
INSERT INTO lcm_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Roe ang natala alis a ri Abaraam ve Isak tatana, kana nalapo kun alis anim tatana. Na matan tivum kapa emung im, nia na sikei a roe ang palau nala alis iria kapa tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Na God kala palak pelek ia si ring i karilong po angmemengenai ang. ");
INSERT INTO lcm_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Au na Iakov kala solo atung a mang vuk iat asi akanangai ani oring i mengen ang ania ta God na kala lingai vaen asukang ta kana alilis kuluna na ka lingai rul i oliv kapa kuluna. ");
INSERT INTO lcm_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Io, sukana na vuk oring ang a God kata mengen ve Iakov singina, tukulai ina na kala atuk ia ta Betel. ");
INSERT INTO lcm_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Au, kila papelek a Betel na kilapo pasal alak ane Eparat, sikei eno ani kimela serei Rakel kalapo buk ingus na kala kui alava. ");
INSERT INTO lcm_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Taun ang kapo kui lak singina, kana aina ipo luk nat ang kala antok ia, “Rakel, ku ago ta leng an, using kam mang nat tauan kana kulapo ingus ia.” ");
INSERT INTO lcm_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Na Rakel kala ingus korong a nat ang, sikei ninia akorong kala mat. Vuk taun katapo matung lak, kata atuk a nat ang ta Benoni. Sikei tamana kala atuk ia ta Beniamin. ");
INSERT INTO lcm_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Asukang vanang na e nei selen ang ane Betelem, using kana mang asan a Eparat ta Betelem, Rakel kata mat na kila amunai ani matmat ina eiang. ");
INSERT INTO lcm_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Na si mopong ina Iakov kala atung a mang vuk iat si akanangai ania. Iat ang kana kapo tung lak si taun ke si akanangai ani mopong ina i Rakel. ");
INSERT INTO lcm_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Au na Israel kala tapasuk pok na kanla atu lu e ngere Migdal Eder. ");
INSERT INTO lcm_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Na taun ang kapo ago si vuk roe ang, Ruben kata palak taun a Bila, kana ainan asosokai a tamana, na kanla rot ve nia. Na Israel katala longong na kala nas a bil ke. Iakov kata atogon kana 12 na nat aongos. ");
INSERT INTO lcm_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Le si Lea kari keve asan ta Ruben, Simeon, Levi, Iuda, Isakar, na Sebulon. ");
INSERT INTO lcm_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Le si Rakel karilong ngono asan ta Iosep na Beniamin. ");
INSERT INTO lcm_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Le si Bila, ainan asosokai ang si Rakel, karilong ngono asan ta Dan a Napitali. ");
INSERT INTO lcm_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Na le si Silipa, ainan asosokai ang si Lea, karilong ngono asan ta Gad na Aser. Riria aongos vanang a matan inatus nat si Iakov. Kita ingus aongos iria e Padan Aram. ");
INSERT INTO lcm_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Au, Iakov kala pasal na kamela serei e rina si tamana ta Isak e Mamre e ngere Kiriat Arba. Kipo kin kapa na ring ang ta Eberon. Rina ke vang kana, ri Abaraam ve Isak kilong tapo ago singina. ");
INSERT INTO lcm_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak kata to na 180 na matas aongos. ");
INSERT INTO lcm_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Katan lavan aro luai na kala pasal suai asi kana an ausai ve riria kitala mat aino ia. Na kana ngono nat ri Esau ve Iakov kilongla amunai ani matmat ina. ");
INSERT INTO lcm_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Kana na akuskus i kana matan vap a Esau, nang kana mang asan ta Edom. ");
INSERT INTO lcm_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Esau kata osongon e Kanan. Kana volo aina ta Ada, Olibama na Basemat. Tamana i Ada ta Elon nia le si ri It. Tamana i Olibama ta Ana na tamana i Ana ta Sibeon si ri Iv. Au na tamana i Basemat ta Ismael na tauna ta Nabaiot. ");
INSERT INTO lcm_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Kana sikei a nat a Esau si Ada ta Elipas. Na si Basemat kana nat ta Reuel ");
INSERT INTO lcm_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","na si Olibama kana volo nat ta Ieus, Ialam, na Kora. Ke Esau vang kana ta keve nat i serei e Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Na Esau kala songo le kana engo, kana inatus nat na kana keve kavulik, na vap po ago aongos ang kuvul ve nia. Kata songo kapa kana keve manmanik aongos. Sa keve togtogon an kapa kata kamkam ia e Kanan kata luk aongos le iria kapa, na kala pasal taun a mang vuk roe akipai ani Iakov. ");
INSERT INTO lcm_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ngono angtasimal ke, karilong togtogon kata lapo laba luai, na kapo tav koi anirilong asi ago kuvul. Vuk roe ang kitapo ago singina kata lapo liklik luai ani karilong keve manmanik. ");
INSERT INTO lcm_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Asukang vang na Esau, kana mang asan ta Edom, kanla soisinong si palpal mulangan ang e Seir. ");
INSERT INTO lcm_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Kana na akuskus i kana matan vap a Esau, tamaria i ri Edom, voiang kipo ago si palpal mulangan ang e Seir. ");
INSERT INTO lcm_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Na kari asan kana polokan a Esau asukang ke. Elipas, nat ang le si kana aina ta Ada, na Reuel le si mang aina ang, Basemat. ");
INSERT INTO lcm_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Au na inatus nat si Elipas kana riria: Teman, Omar, Sepo, Gatam na Kenas. ");
INSERT INTO lcm_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elipas kapa kata atogon kana ainan asosokai, Timna, na karilong nat ta Amelek. Riria vang sukana na matan tivuna i Ada, aina ang si Esau. ");
INSERT INTO lcm_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Au, Reuel kata atogon kana puat a nat: Naat, Sera, Sama na Misa. Riria vang sukana na matan tivuna i Basemat, kana mang aina na Esau. ");
INSERT INTO lcm_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Kana mang aina na Esau ta Olibama. Na tamana i Olibama ta Ana. Na tamana i Ana ta Sibeon. Olibama kata ingus a volo nat ke: Ieus, Ialam na Kora. ");
INSERT INTO lcm_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Au na kana na keve tulava i kana polokan a Esau. Kana ainoai i nat ta Elipas. Elipas kata apolokai ani keve tulava ke: Teman, Omar, Sepo, Kenas, ");
INSERT INTO lcm_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam na Amelek. Riria vanang kita serei si Elipas na kipo ago si roe ang e Edom. Riria na matan tivuna i Ada. ");
INSERT INTO lcm_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Au na kana mang nat a Esau ta Reuel, kata apolokai ani keve tulava ke: Naat, Sera, Sama na Misa. Riria vanang kita polok si Reuel na kipo ago si roe ang e Edom. Riria na matan tivuna i Basemat. ");
INSERT INTO lcm_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Au, kana mang aina na Esau ta Olibama kata asereai ani volo tulava ke: Ieus, Ialam na Kora. Ritol vanang kitolta serei le si kana mang aina na Esau ta ri Olibama. Na tamana i Olibama ta Ana. ");
INSERT INTO lcm_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Io, sukana vang a polokan si Esau, nang kana mang asan ta Edom. Na riria aongos kipo keve tulava. ");
INSERT INTO lcm_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Kana na asan i matan inatus nat ang si Seir, igenen ang si ri Or, vap lapo ago si palpal roe ang. Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO lcm_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Eser na Disan. Riria vanang a keve nat ang si Seir. Kitapo ago eiang e Edom, kari keve tulava ri Or. ");
INSERT INTO lcm_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Na kana ngono nat a Lotan ta Ori na Omam. Na tauna i Lotan ta Timna. ");
INSERT INTO lcm_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Kana keve nat a Sobal ta Alvan, Manaat, Ebal, Sepo na Onam. ");
INSERT INTO lcm_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Kana ngono nat a Sibeon ta Aia na Ana. Ana ke vo sabonai ani keve laman manas po uv alak ang le nei roe e nei ring varasai palau si taun ang katapo aiveven a keve dongki ang si tamana ta Sibeon. ");
INSERT INTO lcm_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Kana nat a Ana lava ta Dison na kana kavulik ta Oolibama. ");
INSERT INTO lcm_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Kana keve nat a Dison ta Emdan, Esban, Itiran na Keran. ");
INSERT INTO lcm_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Kana inatus nat a Eser ta Bilan, Savan na Akan. ");
INSERT INTO lcm_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Na Disan, kana ngono nat ta Us na Aran. ");
INSERT INTO lcm_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Riria vang sukana na keve tulava si ri Or. Io, kari keve asan ta Lotan, Sobal, Sibeon, Ana, ");
INSERT INTO lcm_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Eser na Disan. Kitapo ainoinoai ani ri Or si kari keve kuvkuvulan angpetpetekai si palpal roe ang e Seir. ");
INSERT INTO lcm_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Aino le ani ri tulava si ri Israel ki teng saupai katapo atogon a keve tulava kitapo saupai ani Edom. ");
INSERT INTO lcm_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Kana vang ria. Ainoai iria ta Bela, nat ang si Beor na kana rina asan ina ta Dinaba. ");
INSERT INTO lcm_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Au, taun ang a Bela kala mat, Iabov, nat ang si Sera le Bosra kala luk kana pangau. ");
INSERT INTO lcm_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Iabov kala kun mat na Usam le si palpal roe ang si ri Teman kala luk kana pangau. ");
INSERT INTO lcm_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Na Usam kala kun mat na Adar, nat ang si Bedar kala luk kana pangau. Igenen vo anla ngaungom tapai ang ani ri Midian si palpal roe ang e Moab. Kana rina asan ina ta Avit. ");
INSERT INTO lcm_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Na Adar kala kun mat na Samla le Masreka kala luk kana pangau. ");
INSERT INTO lcm_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Na Samla kala kun mat na Saul le Reobot si sung ang e Iuperetes kala luk kana pangau. ");
INSERT INTO lcm_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul kala kun mat na Bal Anan, nat ang si Akbor kala luk kana pangau. ");
INSERT INTO lcm_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Au na taun ang a Bat Anan kanla kun mat Adar kala luk kana pangau. Kana rina e Pau, na kisngana kana asan ta Metebal. Rinana i Metebal ta Matarer na rinana i Matarer ta Me Sav. ");
INSERT INTO lcm_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Keve tulava i polok ang si Esau. Kita arai ani angusing iria si kari keve asan, kari keve patvap na kari keve palpal. Keve asan iria vang kana. Timna, Alva, Ietet, ");
INSERT INTO lcm_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oolibama, Ela, Pinon, ");
INSERT INTO lcm_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenas, Teman, Mivsar, ");
INSERT INTO lcm_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel na Iram. Riria vanang a keve tulava ke kita polok si Edom, nia palau nang kana na Esau tamaria i ri Edom. Sa keve vuk roe an siksikei i keve patvap ke kita soisinong singina, riria kari keve tulava kita saupai aniria. ");
INSERT INTO lcm_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Na Iakov kalapo ago akit nei rina e Kanan, ring ang tamana katapo ago aino singina. ");
INSERT INTO lcm_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Kana na akuskus i Iakov. Iosep katapo igenen tanginang palau lak. Katapo 17 palau kana matas i to na kitapo aiveven ri sipsip ve keve tasina, inatus ang si ri Bila ve Silpa, ngono ainan asosokai ang si tamaria. Na Iosep katanla atatai a tamaria Iakov ta keve akuskus rikek i sa na keve tasina kita abis ia. ");
INSERT INTO lcm_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Iakov akorong katapo mangal alava na Iosep nei liuan i kana mang keve nat, using kita ingus dong ia tatana si taun ang kata lapo lapan singina. Na kata itoiton ania ta kana maus miminaungan. ");
INSERT INTO lcm_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Taun ang keve tasina kila arai ta tamaria kapo mangal alava na Iosep na riria parik, kilapo mirik alava ania na parik kilapa anguan buk asi kari amengen ania val lau i angtunganan. ");
INSERT INTO lcm_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Mang sikei a tenei vong Iosep kata orodung na si taun ang kanla akus iria tatana, kila mirik alava luai ania. ");
INSERT INTO lcm_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Eiang kala antok iria asukang ke, “Mi longong tapai ani kag orodung. ");
INSERT INTO lcm_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Tara aongos taratapo volovolo ri kon e matang na akorong palau volo ang singig kala tung na kakami kimela tung aulitai na kila soturungai singina.” ");
INSERT INTO lcm_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Na keve tasina kila sui ia ta, “Au, kupo lomon ia nang ta ku serei a tulava na ku saupai aongos animem?” Asukang na kari mirik kala anguan palak alava an using le si kana keve orodung na using kapa si sa katala mengen tatana aniria. ");
INSERT INTO lcm_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Au, emung kala anguan orodung an na kala antok a keve tasina ta, “Arai, nalapo atogon a mang orodung. Nata arai ani makarap, ulen, na sangauli na sikei a kalto na kita soturungai singig.” ");
INSERT INTO lcm_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Na kala akuskus kapa na tamana ta kana orodung, na tamana kala tatapokai ania ta, “Au, saka orodung an kapo asukang? Sa nang, kupo lomon ia ta nau, rinam na keve tasim namem me soturungai singim?” ");
INSERT INTO lcm_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Na keve tasina akorong kilapo vinga neikien ania, sikei tamana kapo lomlomonai akit lak ani keve nem ang. ");
INSERT INTO lcm_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Mang sikei a taun keve tasina i Iosep kita pasal ane Sekem asi kari an aiveven ani kana keve sipsip a tamaria. ");
INSERT INTO lcm_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Na Israel kala antok a Iosep ta, “Arai, keve tasim kipo aiveven sipsip e Sekem. Napo buk ua ani kuan serei singiria.” Na Iosep kala antok ta, “Io, nalapo usausa.” ");
INSERT INTO lcm_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Au, tamana kala antok ia ta, “Pasal na kunla arai ta man a keve tasim kipo sapang na man kapa ri manmanik kipo kun ro asukang. Emung ku papok na ku me atai iau.” Asukang na tamana kanla atatung ia e iang e Eberon na kala palak. Au, kanla serei e Sekem ");
INSERT INTO lcm_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","na kanlapo gule pulakai e iang nei nangkomo, na mang igenen kala arai ania na kala sui ia ta, “Au, kupo gulegule na sa?” ");
INSERT INTO lcm_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Na kala antok ia ta, “Napo gule nang a keve tasig. Au sa kupo angkoai si atai amalangas anig ta kian lapo angangan kana kari keve sipsip evoi?” ");
INSERT INTO lcm_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Au na igenen ang kala ngenget ia asukang ke, “Ai, natapo longong iria kitapo angmemengenai ta, ‘Kapo ro lak tara pasal ane Dotan.’ Asukang vang a kitala aingingik suai ani oring ke.” Na Iosep kala akikik kak using aliu a keve tasina, na kanla kinkos iria e Dotan. ");
INSERT INTO lcm_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Sikei taun kila arai ta kapo pasal lak e ring vunga na si vuk pangau ang nang kalapo lau angasungai iria kita lapo angmemengenai lenginang ta ki raung ia. ");
INSERT INTO lcm_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Na kipo mengen angpokpokai singiria ta, “Io, nang a katakai i orodung kapo pasal akasang! ");
INSERT INTO lcm_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tara an ngarunguk ia na tara asuai nia ane nei sikei i keve mata suke na man a tamara kan sui tatana, tara an antok ia ta kei marala rikek katala rangas ia lenginang. Asi kara arai ta saka nem an ka serei lak emung si kana keve orodung.” ");
INSERT INTO lcm_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Si taun a Ruben kala nas kari lomlomonai asukang, ninia akorong kala atokngai ta ka vil ato na Iosep, na kala antok iria ta, “Pua, kapo ro lak ani tara ago ta gulang an ta kana to. ");
INSERT INTO lcm_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tara ago ta raung an ania. Asuai palau ania ane nei mang mata kana nei ring varasai palau ke. Sikei ago luai ta asuai kunga an singina.” Ruben nang katapo mengen asukang using katapo buk vil ato ani tasiria pelek kari marala, na ani kame songo pok le ia taun a tamaria. ");
INSERT INTO lcm_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Au na Iosep kanla serei si keve tasina na eiang kianla teng akit ia na ki ngaikiang kana maus vopo samui lava ang. ");
INSERT INTO lcm_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Au na ki tak le ia, kianla asuai ania nei mata. Sikei mata ang katapo kovek i laman neina, katapo mat. ");
INSERT INTO lcm_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Na inatus ang kilapo sinong e iang i po sonkos, na kila takngo na kila arai ani petau lava kipo kokos kuli kari keve kamel. Ri vap i Ismael nang, na kita pasal le Gilear na kipo pasiang ane Aigipto si an atos ta kari keve bil sain roron ve marasin. ");
INSERT INTO lcm_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Na Iuda kala antok a keve tasina ta, “Saka nem ro an kana tarapo angkoai si luk ania, man tarala raung a tasira, na rangai ina tara kepai amunai ania nei roe? ");
INSERT INTO lcm_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tara me atos tatana si keve Ismael ke, na tara ago ta vis an ania, using kapo tasira tutukai luai, na tarapo sikei palau a pukun.” Au na kila ainak ani lomlomonai ang. ");
INSERT INTO lcm_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Au taun ang a keve katakai i asesel ang le Midian kimela pasal angasungai iria, kianla tak alak a tasiria ta Iosep pelek a mata ang na kila atos tatana. Kita sel ta tasiria si ri Ismael ta 20 na vuk i kapkap. Au, asukang na kila songo le na Iosep ane Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Taun a Ruben kala papok ane si mata ang, kanla gule ta Iosep kalapo kovek neina. Na kala taktakding kana keve vakup ipo alak. ");
INSERT INTO lcm_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kala papok taun a keve tasina na kanla antok iria ta, “Nat ang kalapo kovek e suke! Au nau vang kana naka ane voi?” ");
INSERT INTO lcm_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Na kila luk kana vakup a Iosep na kila bungum ia si rangai i mangsikei a me kita lamrongok ia. ");
INSERT INTO lcm_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Au na kila luk le na vakup ang taun a tamaria na kila antok ia, “Ku arai, namemtala sabonai ani bil ke. Arai kotok ania, ani tara kinle ta kapo ke kam nat ta vakup vo parik nganing.” ");
INSERT INTO lcm_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Na Iakov kala arai kinle korong ani vakup ang na kala antok, “Pua, ke kag nat akorong kana ta vakup! Mang matan kei rikek i nei uten kitala angan ia. Loi ta Iosep! Lenginang kitala rangas amitmitlikai ani pukun ina.” ");
INSERT INTO lcm_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Na Iakov kala takding kana vakup ipo alak na kala maus ta maus i mamakus na kala ago i makus using ani kana nat si mang keve taun miang. ");
INSERT INTO lcm_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kana inatus aongos kimela mengen i anatok ania, sikei katapo misag ani longong aniria. Na eiang kala antok ta, “Parik, naka tangis aongos tung si naka pasiang taun a rina i mat.” Na kapo tav aus ani tangis. ");
INSERT INTO lcm_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Si pangau ang ri vap i Midian kianla atos ta Iosep e Aigipto si Potipar. Kapo mangsikei i kana keve tulava na Parao, na kapo tu ainoinoai ani kuvkuvulan ipo aiveven. ");
INSERT INTO lcm_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Na si taun ang Iuda kata pasal pelek a keve tasina asi kana an ago kuvul ve mang igenen kana asan ta Ira le Adulam. ");
INSERT INTO lcm_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Au na e iang Iuda kanla arai ani mang aina i Kanan tamana ta Sua, na kala osongon le ia na kanla ago ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Na aina ang kala sungsungukan na kala ingus a nat tauan na kila atuk ia ta Er. ");
INSERT INTO lcm_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Na kala anguan sungsunguk an na kala ingus a mang nat tauan kapa na kala atuk ia ta Onan. ");
INSERT INTO lcm_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Na kala anguan ingus pok an ani kana mang nat tauan na kala atuk ia ta Sela. Nat ke kita ingus ia e Kesiv. ");
INSERT INTO lcm_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Au na Iuda kala samui aina ani kana posong sang Er. Kana asan a aina ang ta Tamar. ");
INSERT INTO lcm_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kana keve lau a Er katapo rikek luai e matana i IAVE asukang a kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","E mung ina Iuda kala atai a Onan tasina i Er asukang ke, “Pasal na kuanla rot kuvul ve mainang i tasim. Apunuk kam abis korong singina val nia kapo kisngana i tasim, asukang vang ani tasim ka atogon mang keve tusakolai ina.” ");
INSERT INTO lcm_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Sikei Onan kapo malangas ta inatus ang parik kilapa kakana asukang na taun kapo ago kuvul ve mainang i tasina kapo vekai suai palau ani laman ina nei vunep ani ka ago ta atogon nat an ani tasina. ");
INSERT INTO lcm_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Lau ke na Onan katapo vil ia kata vil amarala na IAVE, asukang na kala kun mat. ");
INSERT INTO lcm_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Au na Iuda kala antok a omona ta Tamar, “Pasal pok ane si kana lu na tamam na kuanla ago mainang akorong tung si kag nat Sela ka tavirimok.” Iuda katapo leng vei la kun raung nganing ani Sela val ngono tasina. Asukang vang a Tamar kala papok ane nei lu si tamana. ");
INSERT INTO lcm_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Au, kata lapo vuk pangau vungavunga na kisngana i Iuda kala mat, kavulik ke si Sua. Au na kala kamus kana taun a Iuda ipo mamakus, na ninia ve tungana ta Ira le Adulam kilongla pasal ane Timna, ring ang kipo tok kana keve sipsip singina. ");
INSERT INTO lcm_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Mangsikei katanla mengen a Tamar ta omona nang ka pasal ane Timna asi an tok ani kana keve sipsip. ");
INSERT INTO lcm_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Au na kala sakol suai ani kana keve maus i mainang ang na kala pakut le na nona ta kana vakup na kan lapo sinong mete takaman alak ane Enaim kapo rina lik ngere selen ang taun a Timna. Using kata lapo malangas aro ta Sela, nat tanginang ke si Iuda, kala polok alava lenginang na parik lak kipa samui ania tatana ani ka osongon ia. ");
INSERT INTO lcm_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Au, si kana paspasal a Iuda, kanla arai ania na kalapo setpat ta aina vopo luk tauan pulakai ang nang using kata pakut a nona. ");
INSERT INTO lcm_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Na kala pasal aliu using ia ngere selen na kanla antok ia ta, “Me, nakan rot ve numai.” Using katapo tav kinle aro ta omona nang. Na aina ang kala antok ia ta, “Au na ku samui iau ta sa man ku rot ve nau?” ");
INSERT INTO lcm_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Na Iuda kala antok ia ta, “Naka samui ua ta sikei a me tanginang le si kag keve me.” Na aina ang kala antok ta, “Ku alis iau ta mang bil asi kag asinong asukang val akanangai tung si kula alis lak a me ang.” ");
INSERT INTO lcm_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Na Iuda kala sui ia ta, “Saka nem an naka alis ua tatana val akanangai?” Aina ang kala ngenget ia ta, “Lis iau ta kankanuai i kam asan vo takuk ang e ngom, na vuk kipa ang nang kupo teng ia.” Na kala alis ia. Na emung i karilongla ago kuvul le, na aina ang kala sungsungukan. ");
INSERT INTO lcm_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Au, aina ang kala pasal pok ane rina, na kanla luang suai ani vakup ang na kala alak pok kana maus i mainang. ");
INSERT INTO lcm_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Mang matan taun e mung, Iuda kala asok a tungana ta Ira le Adulam asi kana sunguk le ani me ang na ka pasal taun pok a aina ang katala akanangai ania ta keve nem ang, sikei parik katalapa sabonai ania. ");
INSERT INTO lcm_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Na e iang kanla sui a mang matan vap i rina ang ta, “Nei kana na aina po buk tauan pulakai ke na katapo sinong ngere selen e Enaim?” Na kila antok ta, “Eke kapo kovek i aina asukang.” ");
INSERT INTO lcm_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Na Ira kala papok taun a Iuda na kanla antok ia ta, “Parik nata lapa sabonai korong ani aina ang. Na vap i rina ang kita antok ta kapo kovek i aina buk tauan pulakai asukang e iang.” ");
INSERT INTO lcm_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Na Iuda kala antok asukang ke, “Atolongon ia. Kakana na keve nem ang, vei ri vap kila los ira. Kapo ro palau using natala atokngai asi kag samui ania ta me ke, sikei parik kuta lapa sabonai ania.” ");
INSERT INTO lcm_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Si kalapo vapotol i ulen kimela antok a Iuda asukang ke, “Omom nang ta Tamar kata lapo luk tauan pulakai e selen. Arai, kana kalapo sungsungukan.” Na Iuda kala antok, “Mi songo suai ania na kian suluk punuk ia.” ");
INSERT INTO lcm_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Vuk taun ang kilapo songo suai ania, kala alis a mengen taun a omona asukang ke, “Nalapo sungsungukan ta igenen vo po taukai i keve nem ke. Arai aniria na kinle ta ke si nang kana ta kankanuai ve angus ina, na kipa ke kapa.” ");
INSERT INTO lcm_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Iuda kala arai kinle aniria na kala antok, “Aina ke kapo ago nei ring korong na nau natala ngau. Pat konang nala samui ia ani ka osongon ta Sela kag nat.” Na Iuda parik kalapa anguan rot kuvul an ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Au, kalapo sinong a taun asi kana ingus na kila taping ta kala ingus kana lua. ");
INSERT INTO lcm_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Si taun ang kipo abis singina sikei irilong kala sulai ani kungana, na mang aina lava kala sel ia na kala rikut a vuk angus melek singina na kala antok ta, “Ige lik ki ingus aino ia.” ");
INSERT INTO lcm_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Sikei kala tak alak pok a kungana na kila taping ta tasina kala serei aino. Na aina lava ang kala antok ta, “Au, asukang vang a kupo vil amalangas kamilong selen asiang.” Asukang a kila atuk ia ta Peres. ");
INSERT INTO lcm_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Le na kila kun ingus ani tasina velai ani vuk angus melek e kungana, na kila atuk ia ta Sera. ");
INSERT INTO lcm_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Si taun ang ri vap i Ismael kita tak a Iosep ane Aigipto na kita anla atos tatana si Potipar. Potipar katapo igenen i Aigipto na katapo mangsikei i kana keve tulava na Parao na kapo tu ainoinoai ani kuvkuvulan ipo aiveven. ");
INSERT INTO lcm_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Na IAVE katala auai ve Iosep na kata pakangai ania asi kana dual aro. Na katapo ago nei lu si vo taukai ina, igenen ang i Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Na igenen ang kapo kinle ta IAVE katala vil adual aro na Iosep si keve bil aongos kata abis ia. ");
INSERT INTO lcm_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Na e iang Potipar kala uruk ania na kala atung ia ani kakana akorong ta asosokai asukang a kala atung ia asi kana saupai ani kana lu na kana togtogon aongos. ");
INSERT INTO lcm_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Au, le si taun ang na aliu na using kapa na Iosep eiang, IAVE kala atautauia na tamana i lu ang kuvul ve keve bil aongos kapo atogon ia nei lu na ane nei kana keve matang. ");
INSERT INTO lcm_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Asukang na Potipar kala alis suai aongos ani keve bil kapo atogon ia ani ki ago si aiveven si Iosep na parik kalapa anguan mamaiten an singina, sikei palau si pok i po angan. Iosep vola igenen pukunan aro na kapo tauan nau roron. ");
INSERT INTO lcm_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Au na e mung lik palau kisngana i Potipar kalapo mangal a Iosep, na kala antok ia ta, “Kume rot ve nau.” ");
INSERT INTO lcm_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Sikei Iosep katapo misag na kala antok a aina ang ta, “Ka ago. Arai, taukai ig parik kapa anguan mamaiten an ta mang ring bil i nei lu using nau eke. Katala atung iau ani naka saupai ani keve bil aongos kapo atogon iria. ");
INSERT INTO lcm_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Napo atogon ro asi saupai ani lu ke val nia, na parik kata lapa teng akit ta mang ring bil pelek iau, sikei palau numai, using kupo kisngana. Au na naka saka bil an asi kag vil ani lau rikek asukang e matana i God?” ");
INSERT INTO lcm_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kantanem a aina ke katala aikut ia si keve taun sikei Iosep parik kapa buk ainak ani kan rot ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Au, mang taun Iosep kala palak nei lu asi kana an abis. Na si pangau ang katapo kovek luai ta sikei i kana keve vap ipo asosokai e iang. ");
INSERT INTO lcm_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Aina ang kala teng akit ia si kana vakup na kala antok ta, “Rot ve nau.” Sikei Iosep kala galsai ania na kala sang pelek kana vakup e kungana i aina ang ane komo. ");
INSERT INTO lcm_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Na taun ang kala arai ta Iosep katala sip taliung kana vakup ane komo, ");
INSERT INTO lcm_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kala songosongo taun kana mang matan vap ipo asosokai nei kana lu na kala antok iria, “Mi arai kana ia! Kana na igenen Eberaio ke kata me asosokai nei lu na kana kame lapo gulang tatara. Kata riuk lak nei lu na kame lapo buk rot ve nau, sikei nala kail alava luai. ");
INSERT INTO lcm_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Na kala longong iau sipo kail asi me pakang tatag na kala sip taliung kana vakup ngereg ane komo.” ");
INSERT INTO lcm_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Na aina ke kala teng akit kana vakup a Iosep tung si vo taukai ina kamela serei nei lu. ");
INSERT INTO lcm_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Na kisngana kamela akus ia asukang ke, “Eberaio i kongato ang kuta songo ia ane ke kata palak taun iau na kame lapo buk gulang tatag. ");
INSERT INTO lcm_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Sikei taun ang nala kail na kala sip asiang taliung kana vakup ngereg.” ");
INSERT INTO lcm_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Vuk taun ang a aina ke kame lapo atatai suak a kisngana na kala pat luai ania na marala ");
INSERT INTO lcm_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","na kala asok ani ki teng akit a Iosep na ki alakai ania nei lu i akangbat si ring ang kana petau a Tulava kipo kun ago si vilvil akui singina na kanla ago e iang. ");
INSERT INTO lcm_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Sikei IAVE kata auai ve Iosep na kala pakangai ania. Asukang na vo tu ainoai ang ani ri ararai bat kata lapo uruk ania. ");
INSERT INTO lcm_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Na kala atung a Iosep ani ka aiveven a petau aongos ang kipo ago si amiming na ka arai kapa ani keve bil aongos eiang. ");
INSERT INTO lcm_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ainoinoai ang parik kapa anguan telan ta aiveven an ta mang ring bil using Iosep kala luk aongos a abis ang. Io, using IAVE kata auai ve Iosep na kapo pakangai ania asi kana dual si kana keve abis i po teng. ");
INSERT INTO lcm_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","3","Si mang rukun taun emung mang ngono asosokai si Parao, Tulava i Aigipto, kilongtapo ago na kilongla bil arikek e matana na kalapo marala luai anirilong na kala alakai anirilong nei lu i akangbat. Ngono asosokai ke, mangsikei katapo ainoinoai ani ri asosokai vap po ali vaen na mang anu katapo ainoinoai ani ri asosokai vap po ngau saui ang. Au, kala alakai anirilong si vopo ainoinoai ang ani ri ararai bat, akorong palau si ring ang kita alakai ani Iosep singina. ");
INSERT INTO lcm_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Na ainoinoai ang kala asok a Iosep ani ka ararai anirilong. Na Iosep kala aiveven aro irilong. Na kilongla ago nei akangbat si mang rukun taun. ");
INSERT INTO lcm_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Mangsikei a tenei vong kilongta orodung, siksikei irilong katapo atogon kana orodung. Na ngono orodung ang kapa katapo angpetpetekai a supsupai ina. ");
INSERT INTO lcm_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","7","Au, Iosep kamela serei vauk si ngono asosokai ang eiang nei lu i akangbat si taukai ina na kala arai ta kilongpo mamakus. Na kala sui irilong ta, “Au, sa tukulai ina na milongpo ararai mamakus si taun ke?” ");
INSERT INTO lcm_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Na kilongla ngenget ia asukang ke, “Namemlong aongos, siksikei, kapo atogon kana orodung, na eke kapo kovek ta sikei kapo angkoai asi palas ani kamemlong ngono orodung.” Na Iosep kala antok, “Au si God parik kapa angkoai asi palas ani ri orodung? Kapo ro milong akus iau.” ");
INSERT INTO lcm_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Asukang a vopo ali vaen ang kala antok ia, “Si kag orodung nata arai ani ungaungan vaen akorong e nog ");
INSERT INTO lcm_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","kuvul ve potol a ngakan ina. Na akorong palau kala tis, uai kala laba na kala motem. ");
INSERT INTO lcm_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Nau natapo teng kana kavi ipo inum a Parao. Asukang a nala luk a uai i ungan i vaen ang na nala pirongos dong a kavi ang tatana na nala alis ia e kungana i Parao.” ");
INSERT INTO lcm_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Na Iosep kala antok ia, “Kana vang a supsupai ina i kam orodung. Si potol a ungaungan ang nang, kapo asukang ta potol a taun. ");
INSERT INTO lcm_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Man a potol a taun ka liu, Parao ka asoung ua na ka atung pok ua si kam kirim na ku an ali vaen ia val kutapo abis aino ia. ");
INSERT INTO lcm_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Sikei napo akurkurai anim ani ku lomlomonai akit anig man a keve nem ke kila serei aro anim, na ku posong iau si matana i Parao asi pakangai anig pelek ani lu i akangbat ke. ");
INSERT INTO lcm_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Using kita got iau pelek a rina si ri Eberaio na katapo kovek i tukulai ina. Na e ke kapa, e Aigipto, parik luai natapa bil arikek ta ring sa ani name ago nei akangbat asukang ke.” ");
INSERT INTO lcm_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Au na vopo ngau saui ang kala arai ta Iosep katala alomon aus na igenen ang na kala kun antok ania, “Nau kapa natapo kun atogon ani kag orodung na kapo asukang ke. Natapo sunguk a potol a tepe i saui e patug. ");
INSERT INTO lcm_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","E lakat neina i tepe ang katapo atogon a keve saui angpetpetekai pulakai ani Parao na ri mani kimepo angan ia.” ");
INSERT INTO lcm_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Na Iosep kala polpol ia asukang ke, “Kana vang a supsupai ina i kam orodung. Potol a tepe ang nang kapo potol a taun. ");
INSERT INTO lcm_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Man a potol a taun ka liu, Parao ka asoung ua na ki atakuk lakat a pukun im kuli kitip na ri mani kime angan a sin im.” ");
INSERT INTO lcm_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Au, si vapotol i taun, Parao kala vil a matan angan lava i akanangai ani taun i ingus ania na kala songo kana keve asosokai aongos si me angan. Na kala asoung a vopo ali vaen ang na vopo ngau saui ang, na ki tak irilong ane mataria i keve vap ang. ");
INSERT INTO lcm_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Na kala atung pok a vopo ali vaen ang taun kana kirim ipo ali vaen ang val aino. ");
INSERT INTO lcm_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Sikei, vopo ngau saui ang, kila vil punuk ia. Keve bil ang kita serei palau val Iosep kata atai tatana. ");
INSERT INTO lcm_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Sikei vopo ali vaen ke parik kalapa anguan lomlomonai ani Iosep. Katala lomon taun luai ania. ");
INSERT INTO lcm_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Emung i pongua na matas kala liu, Parao kala kun orodung asukang ke. Katapo tung e ngere Sung ");
INSERT INTO lcm_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","na kala arai ani limalengua na bulumakau pukunan na kipo tanginang kipo palak le nei laman na kime lapo tutapongai angan uriuri ngere sung. ");
INSERT INTO lcm_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Na mang limalengua na bulumakau kila kun palak, kitapo makuk na tuanan palau. Kita serei na kime lapo kun tung asung i mang keve bulumakau ang ngere sung. ");
INSERT INTO lcm_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Na keve bulumakau makuk ang kila konem aongos a vap po pukunan ang. Na Parao kala tapangun. ");
INSERT INTO lcm_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Au, kala anguan rot pok an na kala arai ani mang orodung. Limalengua na kon batip aro na matukal kitapo tung lakat kuli sikei a iei i kon. ");
INSERT INTO lcm_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Na mang limalengua na kon kila kun kov serei alak, kipo makuk na magang ta malu manas i nei ring varasai palau. ");
INSERT INTO lcm_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Na keve kon makuk lik ang kila konem aongos a keve kon batip aro ang. Na Parao kala tapangun na kalapo nas ta katapo orodung nang. ");
INSERT INTO lcm_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Na si tenei vauk kalapo sugul velai ani lomlomonai alava. Na kala asok taun a vap po teng mai korong na vap nas i Aigipto. Na kala akus iria ta kana keve orodung, sikei parik kapa angkoai ta mang sikei ka palas dong ia tataria. ");
INSERT INTO lcm_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Au, igenen vopo ali vaen ke kala antok a Parao ta, “Kana palau nala lomlomonai pok ani kag la bil arikek ang. ");
INSERT INTO lcm_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Kuta marala na kam ngono asosokai na ku alakai animemlong ve vopo ngau saui ang nei lu i akangbat si vopo tu ainoinoai ang ani ri ararai bat. ");
INSERT INTO lcm_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Si mang sikei a tenei vong namelong siksikei namemlongta orodung, na kamemlong rukun orodung kilongpo supsupai angpetpetekai. ");
INSERT INTO lcm_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","E suke mangsikei a nat tanginang i Eberaio katapo ago ve namemlong, nia kapo mang asosokai ke ainoinoai ang. Namemlongla akus ia ta kamemlong keve orodung na kala palas dong imemlong siksikei tataria. ");
INSERT INTO lcm_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Na keve bil ang kata kin iria kila saul akorong palau val kana mengen. Nau vang kana, kutala atung pok iau si kag kirim na iuang kutala asok si vil punuk ania.” ");
INSERT INTO lcm_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Na Parao kala asok tapai ani Iosep na sumasuma palau kianla songo le ia nei lu i akangbat. Emung i kana la ridik na kala sakol kana vakup na kamela serei e matana i Parao. ");
INSERT INTO lcm_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Na Parao kala antok ia, “Natala orodung, sikei kapo kovek ta igenen kapo angkoai asi palas ania. Au na natala longong lik tatam. Man ki akus ua ta orodung, kupo angkoai si palas ani supsupai ina, ingko?” ");
INSERT INTO lcm_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Na Iosep kala ngenget ia, “Nau parik napa angkoai. God, nia ka alis a palpalas roron.” ");
INSERT INTO lcm_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Na Parao kala akus dong a Iosep ta kana orodung asukang ke. “Natapo tung ngere Sung ");
INSERT INTO lcm_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","na si vuk taun ang limalengua na bulumakau pukunan na kipo tanginang kipo palak le nei sung na kime lapo tutapong angan uriuri ngere sung. ");
INSERT INTO lcm_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Na mang limalengua na bulumakau kila kun palak na kitapo makuk na kipo tuanan palau. Keve bulumakau ke kipo makuk rikek na le kabang parik natapa arai ani bulumakau asukang e Aigipto aongos. ");
INSERT INTO lcm_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Na keve bulumakau makuk ang kila konem aongos a vap po pukunan ang. ");
INSERT INTO lcm_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Sikei parik kapa angkoai si malangas ania using kipo ararai arikek asukang palau val aino. Aimung na nala tapangun. ");
INSERT INTO lcm_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Na nata orodung kapa na limalengua na kon batip aro na matukal, na kitapo tung lakat kuli sikei a iei i kon ");
INSERT INTO lcm_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Au, mang limalengua na kon kila kun kov serei alak, kipo makuk na kipo magang ta malu manas i ring varasai palau. ");
INSERT INTO lcm_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Na keve kon makuk lik ang kila konem aongos a keve anu po pukunan ang. Natala mengen a vap po teng mai ang sikei kapo kovek ta sikei iria katala palas dong iau tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Na Iosep kala antok a Parao ta, “Kam pongua na orodung, supsupai irilong kapo sikei palau. God katala amalangasai anim ta saka nem an ka vil lak ia. ");
INSERT INTO lcm_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nang a limalengua na bulumakau pukunan ang kapo limalengua na matas, na limalengua na kon batip ang kapo limalengua kapa na matas. Kipo atogon sikei palau a supsupai iria. ");
INSERT INTO lcm_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Au na limalengua na bulumakau makuk ang kita serei e mung na limalengua na kon makuk ang na magang ipo ngan ta malu manas i nei ring varasai palau, kipo limalengua na matas i mol. ");
INSERT INTO lcm_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Kapo asukang palau val natala mengen ua. God katala akalit ua ta sa ka vil lak ia. ");
INSERT INTO lcm_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Longong aro. Ka atogon lak a limalengua na matas i masung duk ta pok aulit aongos eke e Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Na emung ina ka atogon a mang limalengua na matas i mol. Nei liuan i mol ang ri vap parik kilapa anguan lomlomonai an ta kata atogon a taun i masung using a mol ang ka vil arikek a rina. ");
INSERT INTO lcm_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Na taun i masung ang parik kilapa anguan lomlomonai an ania using a mol using ina ka rikek luai. ");
INSERT INTO lcm_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Si kam ararai amatan pongua ani kam orodung kapo supsupai ina ta God katala vil akorong lenginang a bil ke, na ka asereai sumasuma palau ania. ");
INSERT INTO lcm_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Kana kapo ro ta ku vil a saupai asukang ke. Ku atung ta mang igenen malangas ani ka aiveven a rina Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ku atung ta mang matan vap na ki luk a va palpalima i keve uai i sukal nei liuan i limalengua na matas i masung ang. ");
INSERT INTO lcm_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ki luk akuvul a pok aongos nei liuan i keve matas roron ang na ki agongon akuvul a kon si keve rina lava na ki aiveven akit aroron ia. ");
INSERT INTO lcm_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Na pok ang ka sinong ani nei rina si liuan i limalengua na matas i mol ang, nang kapo pasal asi kana me serei eke e Aigipto. Man asukang ri vap parik kipa puka si buk angan.” ");
INSERT INTO lcm_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Na Parao kala arai ani lomlomonai ang ta kapo lomlomonai ro na kana keve asosokai kapa. ");
INSERT INTO lcm_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Na kala sui iria ta, “Tarapo gule lak a mang si, using ninia vang kana na igenen roron ke tarapo buk ia. Using ri god kipo ago ve nia.” ");
INSERT INTO lcm_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Au na Parao kala antok a Iosep ta, “Ri god kita akalit ua ta keve nem ke, asukang a numai kupo atogon malangas ro luai ve masam ani vap aongos eke aliu. ");
INSERT INTO lcm_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Naka atung ua ani ku saupai ani kag vainagoan na kag vap aongos ki mamaila anim na ki uli longong ani kam keve asok. Numai, si kam mamaiten asi saupai, ku vapongua palau ig. ");
INSERT INTO lcm_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Kana vang nalapo akanangai anim asi kam aiveven aongos ani Aigipto.” ");
INSERT INTO lcm_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Na kala kiang kana muraling akanangai i kana tungtungan i tulava le piupiu i kungana na kala alis a Iosep tatana. Na kala alak ia ta kana maus miminaungan roron na kala angongo ia ta ngongo miminaungan kapa. ");
INSERT INTO lcm_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Au na kala alis ia ta kana vapongua i tagtagai asi kana sang kuluna velai ani vap po pasal aino ania ta mengen ke, “Mi soturungai!” Asukang a Iosep kala serei ainoinoai aulit aongos ani Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Na Parao kala antok kapa na Iosep ta, “Nau napo Parao lak, sikei numai, si kam tungtungan, ka kovek luai ta sikei aulitai aongos i Aigipto ka vil a sa ta kungana vo kakina man parik kupa ainak ania.” ");
INSERT INTO lcm_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Na kala posong a Iosep ta kana asan tanginang ta Sapenat-Panea, na kala aosongon ia ta mang kavulik si Potipera, vopo piris ang e On, kana asan ta Asenat. Au, kana vang Iosep kalapo saupai ani Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Si taun i kana tung mete Parao, Iosep kata lapo 30 na matas aongos. Na taun kata soung pelek a vainagoan si Parao kalapo pasal asi kana saupai aulitai aongos ani rina Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Nei liuan i limalengua na matas i masung nei roe aongos kata asereai ani pok duk. ");
INSERT INTO lcm_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Na nia aongos a pok ang Iosep kata luk akuvul iria na ka asinong aiveven ia nei lu i keve rina lava. Si siksikei a rina kata luk akuvul a pok aongos i nei keve matang aulitai ina, na ka agongon ia. ");
INSERT INTO lcm_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Aongos eiang kata lapo aunai i duk luai a kon na Iosep parik kalapa angkoai asi kana taot korong ania, kata lapo duk luai val kone i ngerelo. ");
INSERT INTO lcm_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Eno i keve matas i buk angan kila serei, Iosep katala atogon kana pongua na nat si Asenat. ");
INSERT INTO lcm_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Na kala atuk a anu tuan ta Manase, le si oring ke ta, “God kata mela vil iau asi kag lomon taun ani kag keve kui na kana matan vap a mamai.” ");
INSERT INTO lcm_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Au na vapongua i nat kala atuk ia ta Eparaim le si oring ke ta, “God kata mela asereai ani inuai singig si rina i kag kui ke.” ");
INSERT INTO lcm_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Au, limalengua na matas i masung ang e Aigipto kala kamus ");
INSERT INTO lcm_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","au na limalengua na matas i buk angan kalapo serei asukang palau val kana mengen a Iosep. Eiang buk angan ke kata lapo kun ago si mang keve rina, sikei nei rina aulitai aongos i Aigipto katapo atogon pok. ");
INSERT INTO lcm_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Si taun ri Aigipto akorong kilapo buk angan arikek, kianla tang taun a Parao ta kari ring pok. Asukang na kala antok iria ta, “Mi pasal taun a Iosep na mian vil a saka nem an ka atai imi tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Na buk angan ke kala polok alava luai na kala pakut aongos a kuli rina na e Aigipto akorong katapo kun kitmat luai kapa. Asukang a Iosep kala tavas a keve lu i pok na kalapo asesel pok singiria ta kon. ");
INSERT INTO lcm_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Using a buk angan ke kata lapo rikek luai na ri vap i kuli rina aongos kita lapo pasal ane Aigipto asi kari mepo samui kon si Iosep. ");
INSERT INTO lcm_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Si taun ang Iakov kalapo nas ta kapo atogon kon e Aigipto, na kala antok kana keve nat, “Au sa parik mipa buk bil ta ring sa? ");
INSERT INTO lcm_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Arai, natala longong ta kapo atogon kon e Aigipto. Mi pasal ane iang na mianla samsamui le ani ka pakangai anira pelek a matmat.” ");
INSERT INTO lcm_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Au, asukang na sangauli i keve tasina i Iosep kila pasal ane Aigipto si an samui kon. ");
INSERT INTO lcm_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Sikei Iakov parik katapa asok a tasina tutukai i Iosep ta Beniamin ve ria using katapo leng vei nganing kala atogon ta bil ka serei ania. ");
INSERT INTO lcm_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kana keve nat a Iakov kitapo auai ve mang matan vap kapa using a buk angan ang katala luk a palpal Kanan aongos kapa. ");
INSERT INTO lcm_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Au, Iosep, using kapo ainoinoai i Aigipto, nia katapo asesel ta kon si ri vap aongos i rina ang. Asukang a keve tasina kimela soturungai singina, vangang iria ane nei roe. ");
INSERT INTO lcm_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Vuk taun ang Iosep kala arai ani keve tasina na kala kinle korong iria, sikei kapo bil apetekai pulakai vei kila kinle ia. Na kala sui vabasalai iria ta, “Au na mipo pasal le voi kana?” Na kila antok ta, “Namemta pasal le Kanan si me samui pok.” ");
INSERT INTO lcm_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iosep katala kinle na keve tasina, sikei ria parik kitapa kinle ia. ");
INSERT INTO lcm_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Na Iosep kala lomlomonai ani kana keve orodung aniria na kala antok iria, “Nami mipo keve vap ararai musiklik mimepo serei asi kami me ararai ta nei kamem rina kapo ngau evoi.” ");
INSERT INTO lcm_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Na kila antok ia ta, “Kamem igenen lava, parik. Namempo serei val kam keve asosokai asi kamem me samui pok. ");
INSERT INTO lcm_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Namempo keve angtasimal palau, na namempo atogon a sikei a tamamem. Na parik namempa vap ararai musiklik. Namempo vap atutuman.” ");
INSERT INTO lcm_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Sikei Iosep kala antok iria ta, “Parik! Mimepo serei nang asi kami me ararai ta nei kamem rina kapo ngau evoi.” ");
INSERT INTO lcm_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Na kila antok ia ta, “Namem aongos namempo sangauli na pongua. Namempo keve angtasimal palau akorong na namempo inatus i sikei palau a igenen i rina ang e Kanan. Sikei a tasimem katala mat na kiulik imem sukana kapo ago ve tamemem.” ");
INSERT INTO lcm_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Na Iosep kala antok iria ta, “Kapau. Kapo asukang palau val natala mengen. Nami mipo keve vap po ararai musik. ");
INSERT INTO lcm_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Naka atokngai animi vang kana. Napo atutuman mete Parao ta parik luai mipa angkoai si pasal pelek ani ring ke man parik mipa songo na tasimi lik ane ke. ");
INSERT INTO lcm_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ta sikei imi kan songo le ia na nami aongos mi ago si aiveven kitmat tung si tutuman i kami mengen kala serei e ring malangas. Man parik kapa serei a tasimi lik, napo anguan posong akit mete Parao ta nami mipo vap katakai i ararai musik. ");
INSERT INTO lcm_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","E mung na kala alakai aniria aongos kuvul nei akangbat si potol a taun. ");
INSERT INTO lcm_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Na si vapotol i taun kala atatai iria asukang ke ta, “Man mi using kag mengen, mila to, using nau napo igenen mamaila ani God.” ");
INSERT INTO lcm_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Io, asi arai ta mipo atutuman, sikei imi ka ago eke nei lu i akangbat na petau aongos mi papok velai ni pok i kami me samui taun a matan vap lapo buk angan suke. ");
INSERT INTO lcm_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Au, na mi songo na tasimi lik ane ke taun iau. Nia vanang kamela amalangas ta mitapo mengen atutuman, na parik nalapa asok asi raung amat animi.” Na kila ainak aongos ani kana mengen ang. ");
INSERT INTO lcm_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Na kilapo mengen angpokpokai singiria asukang ke, “Io, kana vang tara me kui using aliu a keve lau ang tarata abis ia si tasira. Taratala arai korong ani kana mamaiten lava na katapo aikut asi kara pakangai ania, sikei parik taratapa longong ia. Kana vang a tukulai ina na kana tarame lapo ago nei pisu ke.” ");
INSERT INTO lcm_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Au na Ruben kala kun mengen singiria ta, “Natala antok imi ani mi ago ta bil arikek an si nat ang, na parik mitapa buk longong. Au na kana taralapo luk kara samui i kara raung ang ania.” ");
INSERT INTO lcm_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Parik kipa nas ta Iosep kapo longong korong kari mengen using kita lapo mengen ve nia si katakai i pokai ni mengen. ");
INSERT INTO lcm_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Na Iosep kala pasal pelek iria na kanlapo tangis. Na taun ang kalapo angkoai si mengen pok kamela papok taun iria na kala songo na Simeon nei liuan iria na kala got akit ia e mataria aongos. ");
INSERT INTO lcm_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Au na kala asok kana keve asosokai ta, Mianla asiang aduk kari keve asisiang ta kon na mi asiang pok kapa kari keve kapkap nei kari keve asisiang siksikei na mi ali pok kapa aniria asi kari angan e selen aliu pok.” Bil ke kitala vil akorong ia asukang palau. ");
INSERT INTO lcm_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Na keve angtasimal ang kila akos kari keve dongki na kila pasal. ");
INSERT INTO lcm_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Na si ring ang katanla vong aniria singina mangsikei iria kala tavas kana asisiang asi kana apus ani kana dongki na kala taping si arai ani kana kapkap e pangkul i kana asisiang. ");
INSERT INTO lcm_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Na kala antok a keve tasina, “Arai, kag kapkap pok kana. Kana nei kag asisiang!” Ria aongos kala uak a lomlomon iria na kipo leng alava luai. Kipo sui angpokpokai aniria siksikei ta, “Au, God kata lapo vil sa kana anira?” ");
INSERT INTO lcm_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Au, kila pasal na kianla serei pok si tamaria ta Iakov e Kanan na kila akus ia ta keve nem aongos ang katanla serei singiria, ");
INSERT INTO lcm_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ainoinoai i Aigipto kata vabasalai animem na ka tupang alava imem ani namempo pasal asi kamem an ararai musiklik ani kana rina. ");
INSERT INTO lcm_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Na namemla antok ia ta, ‘Parik namempa ararai musiklik. Namempo vap atutuman. ");
INSERT INTO lcm_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Namem aongos namempo sangauli na pongua na angtasimal palau. Namempo atogon a sikei palau a tamamem. Sikei a tasimem katala mat na sikei a nat lik imem sukana kapo ago e Kanan ve tamamem.’ ");
INSERT INTO lcm_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Na igenen ang kala antok imem ta, ‘Kana vang asi kag sabonai aro ta mipo vap atutuman, ta sikei imi ka ago ve nau na nami aongos mi asalak kon ani kami matan vap lapo buk angan suke, na mila pasal. ");
INSERT INTO lcm_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Mi an songo le na nat tanginang lik imi ane singig, na nala nas aro ta parik mipa vap ararai musiklik, sikei mipo vap atutuman. Naka akala pok a tasimi taun imi na ka ro palau animi si ago eke na mi abis kami keve avibisan nei rina ke.’” ");
INSERT INTO lcm_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Au, si vuk taun ang kila atatai aongos tapai ani tamaria, na kila lingai ani kari keve asisiang na ria aongos siksikei kila arai ani kari keve asisiang i kapkap. Taun ang kilapo arai ani kapkap ang, ria aongos ve tamaria kilapo leng. ");
INSERT INTO lcm_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Na tamaria kala mengen iria asukang ke, “Sa, mipo buk iau asi kag vil amun ani kag inatus aongos? Iosep katala mun, Simeon kala kun mun na kana mipo buk songo akipai kapa ani Beniamin. Nau a ring igenen ke naka makus alava.” ");
INSERT INTO lcm_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Na Ruben kala antok a tamaria asukang ke, “Alis ia taun kag aiveven na naka pasal ve nia. Man parik nalapa songo pok ia taun ua, kupo angkoai palau si ngapunuk ani kag ngono nat.” ");
INSERT INTO lcm_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Na Iakov kala antok ta, “Ka ago! Kag nat parik luai kapa pasal ve numai. Tasina katala mat na nia kana kapo ring sikei palau kapo ago. Ta nem eiang kan serei singina e selen. Nau kana nalapo lapan na mamakus lava nganlak mi vil ia anig ka raung amat iau.” ");
INSERT INTO lcm_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Buk angan ang kalapo serei arikek luai e Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Na si pangau ang kitala angan asip a kon i kari an samui ang. Au na Iakov kala antok a keve nat ang ta, “Mi pasal pok na mianla samui le ta kara mang men pok lik.” ");
INSERT INTO lcm_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Sikei Iuda kala antok ia ta, “Igenen ang kata mengen akorong luai animem na ka anonok imem ta parik namempa angkoai si me serei e matana man parik namempa songo le na tasimem. ");
INSERT INTO lcm_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Man ku ainak ani tasimem ka auai ve namem, namemla pasal ta an samui pok anim. ");
INSERT INTO lcm_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Man parik kupa ainak, namempo tav angkoai si pasal using a igenen ang kata antok imem ta, ‘Parik mipa angkoai si me serei e matag man parik mipa songo le na tasimi.’” ");
INSERT INTO lcm_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Na Israel kala sui ta, “Sa tukulai ina na mipo vil apisu alava iau ta atai ani igenen ang ta mipo atogon a mang tasimi?” ");
INSERT INTO lcm_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Na kila antok ia ta, “Igenen ang katapo uli sui agilgilai animem ta kamem vap, ‘Au, na tamami kapo to lak? Au, na mipo atogon lak a mang tasimi?’ Namemta polpol akorong palau kana keve susui. Pat namem saka nas an ta ka asok lak imem ta songo ani tasimem asi pasal kuvul ve namem?” ");
INSERT INTO lcm_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Na Iuda kala antok a tamana ta Israel asukang ke, “Asok a nat ang ve nau, na namem pasal kana palau, ani ka ago ta sikei ira ka mat ta buk angan. ");
INSERT INTO lcm_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nau akorong naka alis kag to, na mamaiten ina ka gon kulug akorong. Man parik napa serei pok ve nia ta to e matam, naka uli sunguk ani mamaiten ina. ");
INSERT INTO lcm_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Man parik namemtapa amomole asukang ke, oro namemla ane suke lenginang na ane ke pok.” ");
INSERT INTO lcm_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Na tamaria ta Israel kala mengen iria asukang ke, “Au, man kala po ararai asukang a lomlomonai ang, mi luk ta uai roron luai i keve sukalan na ta ta men murungan na ta mang keve nem sainro dong kami keve asisiang val kapo alilis serei si ainoinoai ang. ");
INSERT INTO lcm_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mi luk kapkap angkoai kuvul ve ngaupap kapa, using mian alis pok a kapkap ang nang mita mela serei pok ve nia e nei kami keve asisiang. Vei kavtapo atogon lomon taun nganing. ");
INSERT INTO lcm_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Na mi songo na tasimi na mi pasal sumasuma palau taun a igenen ang. ");
INSERT INTO lcm_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kapo ro ani God vo kitmat ang ka pokai ani igenen ang asi kana atogon ngorem animi, na ka alis pok imi ta Beniamin na mang tasimi ang pok. Eloi ta man kilapo mun kag inatus!” ");
INSERT INTO lcm_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Au, angtasimal ang kila luk a alilis ang na kari kapkap kuvul ve ngaupap na kila pasal sumasuma ane Aigipto kuvul ve Beniamin. Na kian la tung aserei akorong si Iosep. ");
INSERT INTO lcm_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Taun ang a Iosep kala arai ani Beniamin ve ria, na kala asok kana asosokai i nei lu ta, “Sangauli na keve tauan suke kime ane nei kag lu. Kime angan kuvul ve nau nganlak si sintung, asukang a kuanla runguk a sikei a sipsip na ku itoiton amoso ia.” ");
INSERT INTO lcm_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Na asosokai ke kala songo iria ane nei lu si Iosep na kanla abis aongos a poisan a nem Iosep katala mengen ia tatana. ");
INSERT INTO lcm_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Si taun ang katala songo iria ane nei lu, kilapo leng na kila mengen angpokpokai nei liuan iria ta, “Songo ke anira ane ke vei kavpo tukulai ina nganing si kapkap ang tarata papok ve nia e nei kara keve asisiang si ainoai i taun ang. Nganlak kime vis ataping palau ira, ki luk pakang ira ta kara keve dongki na ki kong ato ira val kana keve asosokai.” ");
INSERT INTO lcm_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Asukang na kila pataun a asosokai ang e mete takaman i lu ang, na kila antok ia ta, ");
INSERT INTO lcm_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Kamem igenen lava, namemta me serei si mang sikei a taun e ke si me samui pok. ");
INSERT INTO lcm_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Na taun nameman lapo ausai tul le ane rina, namem la tavas kamem keve asisiang na siksikei imem kala arai ani kana kapkap nei kana asisiang, keve vuk inoinongos lik aongos ina. Nia kana namem tala luk pok le ia taun imi. ");
INSERT INTO lcm_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Namempo atogon mang matan kapkap duk kapa kana asi kamem me anguan samui pok aduk an. Parik namempa nas ta si kata asiang pok kamem keve kapkap nei kamem keve asisiang.” ");
INSERT INTO lcm_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Na asosokai ang kala antok iria, “Mi ago aro. Mi ago ta leng an. Kami God, kana God a tamami, nia palau nang katala asiang dong pok imi ta kami keve kapkap nei kami keve asisiang. Natala sel lenginang kami seupok.” Na emung kanla songo le na Simeon taun iria. ");
INSERT INTO lcm_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Na kala songo alak iria ane nei lu si Iosep, na ka ali laman aniria asi kari galui ani kakiria, na ninia kanla apus kari keve dongki. ");
INSERT INTO lcm_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Na keve angtasimal ang kilapo itoiton kari keve bil asi me alis ani Iosep man ka serei si sintung, using kitala antok amalangas iria ta kame son kos ve ria. ");
INSERT INTO lcm_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Au na Iosep kamela serei nei lu na kila luk kari keve alilis taun ia na kianla soturungai ane nei vunep e nona. ");
INSERT INTO lcm_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kala susuai aniria ta kari to, au le na kala sui iria ta, “Tamami mita antok iau tatana, kapo sa? Kapo to lak na kapo ro kapa?” ");
INSERT INTO lcm_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Na kila antok ia ta, “Kam asosokai tamamem kapo to lak na kapo ago aro.” Na kila soturungai ane vunep e matana kapa. ");
INSERT INTO lcm_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Taun ang a Iosep kala arai ani Beniamin, tasina na sikei palau a rinarilong na kala antok ta, “Tasimi lik ke vang kana mita antok iau tatana, ingko? Pua, kag nat, kana roron a God ka ago singim.” ");
INSERT INTO lcm_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Na Iosep kala tadut sumasuma pelek suai aniria, using nei vingana aongos katala tameng velai ngorem ani tasina, na kalapo gule ring asi kana tangis musik papa. Na kanla riuk lak nei kana oring i po rot na kanla tangis. ");
INSERT INTO lcm_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Na emung i kana la raus le ani nona, na kala soung. Kata aiveven aro ia, na kala asok, “Sasagi!” ");
INSERT INTO lcm_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kita sasagi ani Iosep dong a pata apetekai, na ani keve tasina si mang anu petekai. Na vap i Aigipto ria kitapo angan e iang ve ria kita kun sasagi apetekai aniria, using ri Aigipto kipo misag luai ani angan kuvul ve ri Eberaio. ");
INSERT INTO lcm_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Na keve angtasimal ang, kita asinong iria angtalangai ve Iosep si angusing i kari keve matas i po ingus aniria tutapongai le si anu tuan tung si anu kiu iria. Pangau ang kila arai ani kari lau i sinong, kipo gelep angpok pokai aniria velai taping ania. ");
INSERT INTO lcm_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Na ri asosokai kila sasagi dong iria ta pok ang le kuli pata si Iosep. Sikei, ani Beniamin kita lis amatan palpalima ania. Asukang na kilapo matan angan aro ve Iosep velai ani kalakala. ");
INSERT INTO lcm_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Na Iosep kala asok a asosokai i nei lu ang ta, “Ku asiang aduk a kari keve asisiang a vap ke na ka duk aroron luai, na ku asinong a kapkap si siksikei a igenen iria e kuluna i kana asisiang. ");
INSERT INTO lcm_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Na ku asiang kag kavi ripag e kuluna i kana asisiang a nat tanginang iria, kuvul ve kana kapkap i kana kon.” Na asosokai ang kala vil apunuk a keve atatai ke si Iosep. ");
INSERT INTO lcm_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Si tenei vauk lik kila atatung iria asi kari pasal kuli kari keve dongki. ");
INSERT INTO lcm_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Taun kianla pasal avungalik pelek a rina, Iosep kala asok a asosokai ang ta, “Sumasuma luai taun a keve tauan suke. Man kuanla kinkos iria, sui iria asukang ke, ‘Sa tukulai ina na mitala ngenget a lau ro ta lau rikek? ");
INSERT INTO lcm_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Kavi ripag ke, ke kag tulava nang. Kapo kana kavi ipo inum, na kapo kingai kapa singina. Mitala bil arikek.’” ");
INSERT INTO lcm_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Au, kala sang na kanla sakam korong iria na kanla posong na keve mengen i atatai ang ania. ");
INSERT INTO lcm_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Na kila ngenget ia, “Kamem igenen lava. Kupo saka mengen an kana? Parik luai namemtapa bil ta lau asukang. ");
INSERT INTO lcm_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kupo malangas ta keve kapkap ang nang namemtanla sabonai ania nei kamem keve asisiang, lenginang namemtala luk pok ia le Kanan. Namempo anguan buk ainau kapkap si kana lu kam tulava ani sa? ");
INSERT INTO lcm_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kamem igenen lava, man ta si imem kila sabonai ania ta kapo atogon ia ka mat, na animem aongos namem serei val kana keve kong ato kamem tulava.” ");
INSERT INTO lcm_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Na kala antok iria ta, “Kapo ro. Iuang vo luk ani kavi ang nia kag kongato. Sikei nami aongos mipo ro si kalakala.” ");
INSERT INTO lcm_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Sumasuma asukang palau na siksikei iria kala kopos asiang kana asasalakan ane vunep na kala eres ia. ");
INSERT INTO lcm_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Na kana asosokai a Iosep kala ararai aro luai aongos singiria tutapongai le si anu tuan na asiang luai. Na kala sabonai ani kavi ang nei asisiang ang si Beniamin akorong. ");
INSERT INTO lcm_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Na keve angtasimal ang kila taktakding kari keve vakup ipo alak ta mamakus, ki akos pok le kari keve dongki na kila papok ane nei rina. ");
INSERT INTO lcm_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Si taun ang a Iuda ve keve tasina kimela serei, Iosep kapo ago lak nei kana lu. Na kila soturungai ane vunep e matana. ");
INSERT INTO lcm_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Na Iosep kala sui iria ta, “Marai sa na mitala abis a lau rikek ke? Parik mipa malangas ta igenen si kag sinsinongan kapo kingai korong?” ");
INSERT INTO lcm_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Na Iuda kala antok ta, “Kamem tulava roron, namempo kovek luai i mengen asi mengen anim tatana. Namem saka gel an? Namemtala bil arikek e matam. God katala arai ani kamem rikek. Namem aongos vang kana kam keve kong ato, kuvul ve nat ke nang a kavi ang kita luk ia nei kana asisiang.” ");
INSERT INTO lcm_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Na Iosep kala antok, “Parik luai napa angkoai si bil asukang! Ninia akorong papalik a vopo atogon ani kavi ang ka kongato singig. Nami aongos mila papok taun a tamami velai ani marip.” ");
INSERT INTO lcm_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Sikei Iuda kala pasal asung taun a Iosep na kala sokotuk ia ta, “Kag igenen lava, ku ainak anig asi kag kalakala ani mengen ve numai. Ku ago ta marala an anig using kupo angkokoai val Parao. ");
INSERT INTO lcm_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Kuta sui imem asukang ke, ‘Mipo atogon tamami vo ta mang tasimi?’ ");
INSERT INTO lcm_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Na namemtala polpol ta namempo atogon a tamamem nia kana kala po lapan na tasimem lik, kita ingus ia si matas i lapo lapan ke tatana. Na tasina i nat ang katala mat, na nia nang kapo ring sikei palau a nat kapo to le si sikei a rinarilong. Na tamana kapo buk alava luai ania. ");
INSERT INTO lcm_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kuta asok imem ta songo le ania ane ke asi kam me arai ania, ");
INSERT INTO lcm_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","na namemla antok ta nat ang parik kapa angkoai si pasal pelek ani tamana. Man ka pasal suai, tamana nganing kala mat. ");
INSERT INTO lcm_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Na kula antok imem ta namempo tav angkoai si me anguan palak an e matam man parik nempa songo le na tasimem lik ve namem. ");
INSERT INTO lcm_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Na taun namem papok ane si kam asosokai tamamem, namem anla mengen ia ta sa kuta antok tatana. ");
INSERT INTO lcm_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Na tamamem kala asok imem ta, ‘Mi papok na mian samui men pok lik anira.’ ");
INSERT INTO lcm_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Sikei namemla antok ia ta, ‘Parik namempa angkoai si pasal. E suke parik kipa naung animem asi an tung aserei e matana i igenen ang man a tasimem lik kapo tav auai ve namem. Namempo angkoai palau si pasal man a kiu lik imem ka pasal.’ ");
INSERT INTO lcm_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Na kam asosokai tamamem kala mengen imem asukang ke, ‘Mipo nas ta ri kisngag kita ingus anig ta pongua palau a nat. ");
INSERT INTO lcm_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Mangsikei irilong lenginang katala pasal pelek iau na natala antok ta lenginang ri kei i nei uten kitala rangas arikek pulakai ania, using parik nata lapa anguan arai tapai an ania le si taun ang. ");
INSERT INTO lcm_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Man mila songo pelek iau ta sikei ke kana, na man ta bil kan serei singina, mamakus ang mi vil ia anig ka raung iau, using nalapo lapan.’ ");
INSERT INTO lcm_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Asukang na man naka papok taun a mamai, na nat ke kapo kovek, taun ang man ka arai ta nat ke kapo tav auai ve nau, ka mat palau. Kana to nang kapo pakutan ta to si kiu ke. ");
INSERT INTO lcm_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Sukana na mamakus namem vil ia ani lapan suke na ka vil amat ia. ");
INSERT INTO lcm_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nau akorong kam asosokai, natala ainak ta kag to ani nat ke, using nata antok a mamai asukang ke ta, ‘Man parik nalapa serei pok taun ua ve nat ke, nau akorong naka sunguk a mamaiten ina asikei.’ ");
INSERT INTO lcm_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Asukang vang kana, kag igenen lava, naka ago eke si kana pangau a nat ke val kam kongato. Ku atolongon ia na ka pasal pok ve keve tasina. ");
INSERT INTO lcm_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Using parik napa angkoai si papok palau ane si mamai man a nat ke kapo tav auai ve nau, vei nanla arai ani mamai si puka.” ");
INSERT INTO lcm_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Na kala pat luai ani Iosep na parik kalapa anguan angkoai an si aiveven aro ani kana nanasai e mataria i kana keve asosokai na kala vas iria ta, “Mi pasal suai aongos!” Asukang na katalapo kovek ta mangsikei ka ago ve nia si pangau ang kala atai amalangas a keve tasina ta nia nang kapo si. ");
INSERT INTO lcm_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Na kala kup alava luai ta tangis, na ri vap i Aigipto kila longong ia na nei rina si Parao kila kun longong kapa. ");
INSERT INTO lcm_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Na Iosep kala antok a keve tasina ta, “Nau nang a Iosep. Au na mamai kapo to lak?” Sikei keve tasina parik kilapa angkoai si ngenget using kilapo leng alava luai e matana. ");
INSERT INTO lcm_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Emung a Iosep kala antok iria ta, “Kapo ro mi sinong asung ane ke.” Au, kila aingingik na kala atatai iria. “Nau a tasimi Iosep nang mita atos tatag ane Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Au, kana mi ago ta makus an vo angtupang an ta kami atos ang tatag ane ke. God katala asok aino iau ani nau name vil ato lak imi. ");
INSERT INTO lcm_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Kana kapo vapongua i matas i buk angan ta nei rina aongos, na eno lak kapo atogon a mang palpalima na matas asi tav anguan dek roe an na tav rok kon. ");
INSERT INTO lcm_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Io, God kata asok aino iau animi asi kag teng ato animi si selen roron asukang ke ani nami ve matan tus using imi mi duk e kuli rina. ");
INSERT INTO lcm_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Io, asukang vang a parik ta nami mitapa asok iau ane ke, sikei God papa, nia kata asereai anig asi kag me asukang val napo tamana i Parao. Nalapo aiveven aongos kana vainagoan na Aigipto aongos kapa. ");
INSERT INTO lcm_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Kana mi pasal sumasuma taun pok a mamai na mian antok ia ta kana nat ta Iosep kata asok si antok ania asukang ke, ‘God katala asereai anig ani nau a tulava i Aigipto aongos. Ku pakasang ane ke. Ago ta amomole an. ");
INSERT INTO lcm_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kume ago si palpal Gosen, ring ke kapo angasungai anig. Numai ve kam inatus a keve tivum. Kam keve sipsip, keve bulumakau na kam togtogon aongos ka ane ke. ");
INSERT INTO lcm_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Name aiveven ua eke e Gosen using ane no kapo pasal lak a palpalima na matas i buk angan. Kume ve kam matan vap na kam togtogon vei mila mat ta buk angan.’ ");
INSERT INTO lcm_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Kana, nami aongos, na numai kapa Beniamin, mi arai ta nau atutuman a Iosep napo alis a mengen ke. ");
INSERT INTO lcm_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Mianla akus a mamai ta nau napo saka igenen lava an eke e Aigipto na mi mengen ia kapa ta keve nem aongos mitala arai ania. Mi sumasuma na mianla songo le ia ane ke.” ");
INSERT INTO lcm_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Na Iosep kala vongok a tasina ta Beniamin na kala tangis, na Beniamin kapa kalapo kun tangis si kapo lot ia. ");
INSERT INTO lcm_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Na kanpo vongok a mang keve tasina siksikei na kianpo angtangisai kuvul. Emung ina keve tasina kila tutapongai angmemengenai ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Na akus kanla serei nei kana vainagoan a Parao ta keve tasina i Iosep kita mela serei. Na Parao ve kana keve asosokai kilapo uruk. ");
INSERT INTO lcm_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Au na kala atatai a Iosep asukang ke, “Ku antok a keve tasim ta ki akos aro kari keve dongki na ki pasal pok ane rina e Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Kian songo le na tamaria ve kari inatus na ki papok ane ke. Naka lis roe roron luai lak aniria e ke e Aigipto, na ki ago aro na ki masung. ");
INSERT INTO lcm_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Antok iria kapa asi kari dal le ta keve sinsinongan i paspasal le ke e Aigipto ani kari keve aina na kari inatus lik. Ki pasal na kian songo na tamaria. ");
INSERT INTO lcm_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ki ago ta lomlomonai makus an ta kilapo sip taliung kari togtogon e suke, using a keve nem roron luai aongos i rina ke Aigipto ki atogon ia lak.” ");
INSERT INTO lcm_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Au na kana inatus a Israel kila ainak ani mengen ang. Na Iosep kala dal sinsinongan i paspasal dong iria val kana atatai a Parao. Ka lis pok angkoai kapa aniria si kari paspasal. ");
INSERT INTO lcm_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ria aongos siksikei kata lis iria ta kari keve sikei a sakol vakup ipo alak, sikei Beniamin, kata alis ia ta 300 na vuk kapkap na palpalima na sakol vakup ipo alak. ");
INSERT INTO lcm_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Na ka asok si akos aduk ani sangauli na dongki ta mamain ta bil roron luai i Aigipto, na mang sangauli na dongki aina ki akos iria ta kon, saui na mang matan pok ani tamana ani ka angkoai si kana paspasal. ");
INSERT INTO lcm_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Na kala atatung a keve tasina asi kari pasal. Na taun ang kilapo pataliung ia kala antok iria ta, “Mi ago ta angkiki e selen.” ");
INSERT INTO lcm_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Au na kila pasal pelek a Aigipto na kila papok ane si tamaria Iakov e Kanan. ");
INSERT INTO lcm_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Na kianla antok ia ta, “Iosep sukana kapo to lak! Nia kana kalapo tulava i Aigipto aongos!” Na Iakov kala tun apuak iria using kapo tav lomlomon tataria. ");
INSERT INTO lcm_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Sikei, kila mengen aro aongos ia ta saka keve mengen an a Iosep kata mengen iria tatana. Na taun ang kala arai ani keve sinsinongan i paspasal ang a Iosep kata lis ia asi me akos ang ania, kala uruk pok a nei vingana. ");
INSERT INTO lcm_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Na Israel kala mengen asukang ke, “Kala aulei. Kag nat Iosep kana kapo to lak! Kapo ro luai asi kag an arai ania aino le ani naka mat.” ");
INSERT INTO lcm_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Na Iakov kala usausa aongos kana keve togtogon na kala pasal ane Berseba, na eiang kanla sula alilis serei si God voiang a tamana ta Isak kata atogon ia. ");
INSERT INTO lcm_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Na tenei vong God kala songo na Israel nei ararai asukang ke, “Iakov, Iakov!” Na kala polpol ta, “Io, nau kana.” ");
INSERT INTO lcm_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Na kala antok ia ta, “Nau a God, nau kana God a tamam. Ku ago ta leng an ani pasal ane Aigipto. Naka asereai lak ani matan vap tavirimok lava le singim eiang. ");
INSERT INTO lcm_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Naka auai ve numai ane Aigipto na naka songo pok lak kam matan vap. Na Iosep akorong ka auai ve numai si kam taun i tapikon.” ");
INSERT INTO lcm_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Au, Iakov kala tapasuk pelek a Berseba. Kana keve nat kila akos ia kuvul ve kari ta kun keve inatus lik na kari keve aina kuli keve sinsinongan i paspasal ang nang a Parao kata lis tapai aniria. ");
INSERT INTO lcm_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Na kila songo kari mamain ta manmanik ipo apus na kari togtogon aongos i asereai e Kanan na kila pasal ane Aigipto. Io, asukang vanang a Iakov kanla serei e Aigipto, nia kuvul ve kana matan vap aongos. ");
INSERT INTO lcm_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Kana inatus tauan aina na keve tivuna tauan aina aongos. ");
INSERT INTO lcm_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Kari keve asan a matan vap ang si Israel kita auai ane Aigipto asukang ke. Kana posong sang ta Ruben. ");
INSERT INTO lcm_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Na keve nat si Ruben ta Anok, Pulu, Esron na Karmi. ");
INSERT INTO lcm_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Na keve nat si Simeon ta Iemuel, Iamin, Oad, Iakin, Soar na Siaul ke mang aina i Kanan ta nat. ");
INSERT INTO lcm_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Na keve nat si Levi ta Gerson, Koat na Merari. ");
INSERT INTO lcm_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Na keve nat si Iuda ta Er, Onan, Sela, Peres na Sera. Ri Er ve Onan kilong tala mat e Kanan. Kana ngono nat a Peres ta Esron na Amul. ");
INSERT INTO lcm_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Na keve nat si Isakar ta Tola, Puva, Iasuv na Simron. ");
INSERT INTO lcm_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Na keve nat si Sebulon ta Serer, Elon na Ialel. ");
INSERT INTO lcm_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Sukana vang a inatus si Iakov kita asereai aniria si Lea e Padan Aram, na e ngerena kapa kana kavulik ta Dina. Tataot i petau suke katapo 33 aongos. ");
INSERT INTO lcm_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Au, na keve nat si Gad ta Sepon, Agi, Suni, Esbon, Eri, Arori na Areli. ");
INSERT INTO lcm_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Na keve nat si Aser ta Imna, Isva, Isvi, Beria na tauria Sera. Na ngono nat si Beria ta Eber na Malkiel. ");
INSERT INTO lcm_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Sukana vang na inatus si Iakov kata asereai aniria si Silpa, ainan asosokai ang Laban kata alis kana kavulik Lea tatana. Na tataot i petau suke katapo 16 aongos. ");
INSERT INTO lcm_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Au na kana ngono nat a Iakov si Rakel ta Iosep na Beniamin. ");
INSERT INTO lcm_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Na Iosep e Aigipto kata anla aumata na pongua na nat tauan, Manase na Eparaim si Asenat, kavulik ang si Potipera vopo piris ang e On. ");
INSERT INTO lcm_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Na keve nat si Beniamin ta Bela, Beker, Asbel, Gera, Naman, Ei, Ros, Mupim, Upim na Ar. ");
INSERT INTO lcm_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Sukana na inatus si Iakov kata asereai aniria si Rakel. Tataot iria katapo 14 aongos. ");
INSERT INTO lcm_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Au na kana nat a Dan ta Usim. ");
INSERT INTO lcm_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Au na keve nat si Napitali ta Iasiel, Guni, Ieser na Silem. ");
INSERT INTO lcm_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Sukana na inatus suke si Iakov kata asereai aniria si Bila, ainan asosokai ang Laban kata alis kana kavulik Rakel tatana. Tataot iria kapo limalengua aongos. ");
INSERT INTO lcm_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Na tataot kuvul akorong i matan vap ang si Iakov nang kita pasal ane Aigipto kapo 66 aongos. Na keve omona i Iakov kipo tav taot aniria eke. ");
INSERT INTO lcm_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Na ngono nat inla ingus ang ani Iosep e Aigipto kala vil alakat a tataot iria tung si 70 aongos si kana matan vap a Iakov nang kita palak ane Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Au kana, Iakov katala asok aino na Iuda asi kana an nanas selen ane Gosen. Asukang na kimela serei e palpal Gosen. ");
INSERT INTO lcm_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Na Iosep kala dal kana tagtagai na kala pasal ane Gosen asi kana an ruduai ani tamana ta Israel. Taun ang kilongta angduai, Iosep kala vongok a tamana na kala tangis avungavunga luai. ");
INSERT INTO lcm_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Na Israel kala antok a Iosep ta, “Nalapo usausa asi kag mat vang kana using natala arai anim na napo arai ta kupo to lak.” ");
INSERT INTO lcm_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Na Iosep kala mengen amalangas a keve tasina ve ria aongos kana matan vap a tamana asukang ke, “Naka pasal kana na nakan antok a Parao ta, ‘Keve tasig na kana matan vap aongos a mamai nang kitapo ago e Kanan, kana kila serei. ");
INSERT INTO lcm_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Sikei, kipo vap katakai i aiveven sipsip na mang matan manmanik na kita songo le kapa kari keve sipsip na bulumakau na kari togtogon aongos.’ ");
INSERT INTO lcm_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Au, man a Parao kala asok tapai animi, na ka susui imi ta mipo saka abis an akorong kana, ");
INSERT INTO lcm_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","mi antok ia asukang ke, ‘Namem, kam keve asosokai, namemtapo katakai i aiveven sipsip le kabang le si kamem to aongos asukang palau val keve tivumem kitapo abis ia.’ Na si oring ke kala lomon suai animi asi kami ago e palpal Gosen using ri Aigipto kipo misag luai ani ri katakai i aiveven sipsip.” ");
INSERT INTO lcm_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Au na Iosep kala pasal na kanla antok a Parao ta, “Mamai kana ve keve tasig kila serei taun iau le Kanan. Kipo atogon kari mamain ta sipsip na bulumakau na kari togtogon aongos. Na riria kana kilapo ago e Gosen.” ");
INSERT INTO lcm_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Na kanla songo le na palpalima i keve tasina na kamela atung amalangas iria e matana i Parao. ");
INSERT INTO lcm_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Au, Parao kala sui iria ta, “Mipo saka abis an akorong kana?” Na kila antok ia ta, “Namem nang kam keve asosokai namempo katakai i aiveven sipsip. Namempo asukang palau val keve matan tivumem aino.” ");
INSERT INTO lcm_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Na kila antok ia kapa ta, “Kamem pasal nang ane ke asi me ago tapai using a buk angan lava ke kalapo kun meng animem e Kanan na kamem keve manmanik kilapo kovek i uriuri asi angan. Asukang vanang na namempo sokotuk ua ta ku naung animem na namem me soisinong si palpal roe ke e Gosen.” ");
INSERT INTO lcm_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Na Parao kala antok a Iosep ta, “Tamam na keve tasim kita me serei singim ");
INSERT INTO lcm_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","na roe lava ang i Aigipto kapo oros e matam. Alis iria ta palpal tauia i roe ang na ku asoisinong iria e Gosen. Na man ri si nei liuan iria kipo katak ta aiveven manmanik, ku asok iria na kime aiveven kakag akorong ta kun keve manmanik.” ");
INSERT INTO lcm_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Au le na Iosep kala kun songo alak ani tamana ane mete Parao. Na Iakov kala poso atautauia na Parao. ");
INSERT INTO lcm_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Na Parao kala sui a Iakov ta, “Kam poisan kana na matas i la to?” ");
INSERT INTO lcm_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Na Iakov kala antok ia ta, “Kag matas i to parik kapa asukang val keve vuvui kitala to ia. Nata duai ri mamaiten lava nei kag to na kalapo liklik palau na napo 130 na matas palau.” ");
INSERT INTO lcm_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Le na kan poso atautauia pok tapai ani Parao na kamela soung pelek ia. ");
INSERT INTO lcm_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Asukang vang na Iosep katala asoisinong na tamana ve keve tasina e Aigipto. Kata alis iria ta palpal roe tauia luai e Rameses, asukang palau val atatai ang si Parao. ");
INSERT INTO lcm_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Kata alis kapa na tamana na keve tasina na matan vap aongos ang ta pok angkokoai si tataot i inatus iria. ");
INSERT INTO lcm_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Buk angan ang kala serei alava luai na kala kovek i pok si palpal aongos ang. Na ngono rina ke Aigipto na Kanan kilong tala logo luai kovek i pok. ");
INSERT INTO lcm_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Na Iosep kala luk aongos le na keve kapkap ipo samui pok ang ta ri Aigipto na ri Kanan taun a lu si Parao. ");
INSERT INTO lcm_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Taun ang a kapkap si ri Aigipto na ri Kanan katala kamus aongos, ri Aigipto aongos kimela serei si Iosep na kila antok ia ta, “Ku alis pok animem. Marai sa namem me mat palau e matam? Kamem kapkap kana kala kovek aongos.” ");
INSERT INTO lcm_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Na Iosep kala antok iria asukang ke, “Au, kanat. Using milapo kovek i kapkap, mi luk dong iau ta kami keve manmanik, na nala alis pok imi sakolai aniria.” ");
INSERT INTO lcm_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Au na kianla luk aongos le kari keve manmanik ane si Iosep na kala alis iria ta pok sasakolai ani kari keve os na sipsip na me na bulumakau na dongki. Na nei liuan i matas aongos ang kata alis pok palau aniria sasakolai ani kari keve manmanik aongos. ");
INSERT INTO lcm_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Na si matas using ina kimela serei pok si Iosep na kila antok ia, “Kamem tulava, kupo malangas lenginang ta namempo kovek i kapkap na keve manmanik numai kulapo tauk ina aongos. Asukang na sa kana namem lapo atogon ia si taun ke kapo pukun imem palau na kamem roe. ");
INSERT INTO lcm_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Marai sa vanang na namem me mamat e matam kuvul ve kamem roe? Ku samui imem ve kamem roe ta pok asi kamem angan. Io, kamem roe, Parao ka tauk ina na namem an asosokai palau asikei si Parao. Lis imem ta katui i kon ani namem ago ta mat an na roe ke ka ago ta varasai palau an.” ");
INSERT INTO lcm_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Asukang vang a Iosep kala samui aongos a roe ang e Aigipto ani Parao. Siksikei iria i ri Aigipto kata atos ta kana vuk roe, using a mol ang kata lapo laba luai aniria. Roe aongos ang, Parao kata lapo tauk ina. ");
INSERT INTO lcm_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Na ri vap aongos le si mang ngising i Aigipto ane si mang ngising ina, Iosep kata vil iria ani ki asosokai si Parao. ");
INSERT INTO lcm_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Sikei, roe ang si ri piris, parik kata lapa samui ia using Parao katapo uli ali pok aniria, asukang na kipo atogon pok si angan na parik katapa inongos taun ta ki atos ta kari roe. ");
INSERT INTO lcm_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Au na Iosep kala antok a ri vap ta, “Arai, kana using natala samui aongos imi ve kami roe ani Parao, kana nala alis katui animi si sukal si roe ang. ");
INSERT INTO lcm_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Sikei si taun i kaming ania mi alis a Parao ta sikei a palpal i uai na mang puat a palpal ang kapo kakami asi angan na asi suksukal atanginang kapa animi, kami inatus na riria mipo aiveven iria.” ");
INSERT INTO lcm_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Na ri vap kila antok ta, “Pua, kamem tulava, kulapo teng ato imem kana. Man kapo roron palau singim, namem serei a keve asosokai palau asikei si Parao.” ");
INSERT INTO lcm_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Asukang vang a Iosep kala asereai ani mang sausaupai e Aigipto ta va palpalima i keve uai i sukal, ke Parao ia. Na saupai ang kapo tung akit lak si taun ke kana. Sikei palau a roe ang si ri piris Parao parik katapa tauk ina. ");
INSERT INTO lcm_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Io, ri Israel si taun ke kita lapo soisinong e Aigipto si palpal Gosen. Kita lapo tauk i mang keve roe eiang na kari polokan kala serei alava luai si tataot iria. ");
INSERT INTO lcm_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Iakov kata ago eiang e Aigipto si 17 na matas, na tataot aongos i kana matas i to kata lapo 147 na matas. ");
INSERT INTO lcm_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Au na kalapo angasungai aliu ani Israel ka mat na kala songo kana nat ta Iosep na kala antok ia, “Man napo ro e matam, kapo ro ku amatung a kungam neite savag ta ku pakangai anig na ku abis a lau tutuman anig. Ku ago luai ta amunai ani matmat ig eke e Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Si taun ang nala mat, ku sunguk suai ani matmat ig pelek a Aigipto na kuan amunai ania nei gom ang kag matan vap kipo matung singina.” Na Iosep kala antok ia ta, “Io, naka abis ia asukang palau val kupo atatai iau tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Na Iakov kala antok ia, “Ku atuvala ane singig.” Na Iosep kala abis ia asukang. Na Israel kapo teng akit si kana kipa na kala tuturung e matana i IAVE. ");
INSERT INTO lcm_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","E mung i mang rukun taun na kimela antok a Iosep ta, “Tamam nang kapo malepen.” Asukang a kala songo le kana ngono nat, ri Manase ve Eparaim ani kilong auai ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Na mangsikei eiang kala antok a Iakov ta, “Arai, kam nat ta Iosep kana kame arai anim.” Na Israel kala arudualan pok ia na kala sinong atung kuli pata. ");
INSERT INTO lcm_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Na kala mengen a Iosep ta mengen asukang ke, “God vo kitmat luai ang kata serei singig e Lus si palpal Kanan na kata poso atautauia iau eiang ");
INSERT INTO lcm_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ta mengen asukang ke, ‘Arai, naka atautauia ua na mi serei a vap miang. Mi serei lak asukang ta kuvkuvulan tavirimok. Na palpal roe ke nala alis ia si keve matan tus using im ani ki tauk ina asikei.’ ");
INSERT INTO lcm_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Na kam ngono nat i ingus ke e Aigipto aino ani name serei eke, nala posong irilong ta kakag ta ngono nat. Io, ri Eparaim ve Manase kilongpo kag ngono nat asukang palau val ri Ruben ve Simeon. ");
INSERT INTO lcm_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kam mang keve nat emung irilong, riria vanang kila kakam akorong ta keve nat. Sikei, saka palpal roe an nganlak ki pagal dong iria tatana, ki taot iria si asan i ngono tasiria ke. ");
INSERT INTO lcm_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nau natala mamakus luai marai kag papok ang le Padan na Rakel kamela mat e selen si palpal Kanan avunga lik i Eparat, asukang vang a natala amunai ania e ngere selen ane Eparat.” Eparat kipo posong kapa ia ta Betelem. ");
INSERT INTO lcm_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Au, taun ang a Israel kala arai ani ngono nat ang si Iosep kala sui, “Au na ri si kana?” ");
INSERT INTO lcm_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Na Iosep kala antok a tamana ta, “Kag ngono nat nang voiang a God katala kun alis anig tatarilong eke.” Au, Israel kala antok ta, “Songo alak tapai anirilong ane singig na name poso atautauia irilong.” ");
INSERT INTO lcm_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Matana i Israel kata lapo ngau na parik kata lapa anguan arai aro an, using kata lapo lavan luai. Au, Iosep kala songo asung irilong na tivurilong kala vongok na ka lulus irilong. ");
INSERT INTO lcm_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Au na Israel kala antok a Iosep ta, “Parik natapa lomon ia ta naka anguan arai korong pok an anim, sikei God katala vil korong ia ta nala arai ani kam inatus.” ");
INSERT INTO lcm_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Na Iosep kala songo suai anirilong pelek a savana i tivurilong na kala soturungai ane vunep. ");
INSERT INTO lcm_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Le na kala aingingik atava na ngono nat ang taun a Israel. Eparaim ka tung e palkais ina na Manase e palso ina. ");
INSERT INTO lcm_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Sikei Israel kala sulai ani kana palso taun a patuna i Eparaim vopo nat emung ang na kala sulai aputuk ani kana palkais taun a patuna i Manase, vo posong sang ang. ");
INSERT INTO lcm_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","16","Au na kala poso atautauia na Iosep ta mengen asukang ke, “God ka atautauia na ngono nat ke. Kana na God ke voiang a vuvui ta Abaraam na mamai ta Isak kilongtapo angtogon ve nia, na katala aiveven kag to aongos tung kana, na kana angelo kata asapang iau si keve mamaiten aongos. Io, nia ka atautauia irilong na ki poso atat lak irilong using a asan ig, na asan i vuvui ta Abaraam na mamai ta Isak. Na kari polokan ki serei aduk luai e kuli rina ke.” ");
INSERT INTO lcm_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Taun ang a Iosep kala arai ta tamana kalapo amatung kana palso si patuna i Eparaim, parik kalapa ainak ania, na kala teng akit kana palso na tamana asi kana luk suai ania pelek a patuna i Eparaim ani kan amatung ia e patuna i Manase. ");
INSERT INTO lcm_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Na kala antok ia ta, “Mamai, parik ta asukang. Kana na ike kana kapo posong sang. Kam palso vanang ka matung e patuna.” ");
INSERT INTO lcm_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Sikei tamana kala misag na kala antok ia, “Napo nas nang, kag nat. Napo malangas. Ninia nang kapa ka kun serei a matan vap, na ki kun serei alava. Sikei tasina lik lak ka tavirimok ania, na keve matan tus using ina ki serei asukang ta mamain ta matan vap duk luai.” ");
INSERT INTO lcm_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Na kala poso atautauia irilong si taun ang velai ani mengen ke, “Si asan imilong vanang, ri Israel emung aliu lak ki uli poso atautauia ani mang matan asukang ke, ‘God ka asereai animi val ri Eparaim na ri Manase.’” Io, sukana vang kala atung a Eparaim ani ka aino ani Manase. ");
INSERT INTO lcm_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Au le na Israel kala antok a Iosep, “Arai, nalapo angasungai kana asi kag mat, sikei God ka auai ve numai, na ka ausingai pok anim ane si roe ang si keve tivum. ");
INSERT INTO lcm_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nami angtasimal, nala alis imi siksikei ta roe ang eiang. Au na anim, kula atogon kam ngaupap si vuk roe i kag la luk suke si ri Amor ta dual i kag samele ipo visvis na kag vatilau. ");
INSERT INTO lcm_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Na Iakov kala asok tapai ani kana keve nat ta, “Mime serei akuvul na naka atai imi ta keve bil lak eno imi. ");
INSERT INTO lcm_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Inatus nat si Iakov, mime serei akuvul na mi longong. Mi longong a tamami ta Israel ");
INSERT INTO lcm_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, numai kupo posong sang. Numai a madot ig using kam serei kata akanangai ani naka serei a igenen madot. Asanim kapo laba luai na dual im kapa. ");
INSERT INTO lcm_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Vingam kapo asukang val kel lava na parik kutapa sausaupai aro anim na parik kulapa anguan laba an kana using kutala abis a lau visuk kuli pata si tamam. ");
INSERT INTO lcm_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Ri Simeon ve Levi kilongpo ngono angtasimal. Karilong keve samele kipo bil asi galagalang. ");
INSERT INTO lcm_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Naka ago ta sinong an si karilong keve aititikai. Naka ago ta sinong kuvul an ve rilong si karilong keve lomlomonai. Using si karilong marala kilongtala raung a vap miang, na kilongta tangai asoles palau ri bulumakau using karilong vubuk. ");
INSERT INTO lcm_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nala poso arikek karilong marala using kapo soliu luai. Na karilong vinga manas using kapo rikek luai. Naka angtaliungai ani karilong patvap nei liuan i patvap si Iakov, na ki ago angtaliungai pulakai nei liuan i ri Israel. ");
INSERT INTO lcm_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Numai Iuda, keve tasim ki poso aro ua. Ri si kipo petau ua ku teng lak a ngoria, na keve tasim ki soturungai singim. ");
INSERT INTO lcm_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Numai Iuda kupo natnat i laion, kutanla kon puka le na kume lapo matung musik na ka ago luai ta sikei ka gulang pangun ua. ");
INSERT INTO lcm_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Sinsinong i sausaupai parik kapa angkoai si papelek ani Iuda, tung si vopo tauk i kirim ang kame serei. Mamain ta patvap aongos ki longong singina. ");
INSERT INTO lcm_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ka pala kana natnat i dongki si mangsikei a vaen si ngakan roron luai ina. Ka galui kana vakup ipo alak ta rul melek i vaen. ");
INSERT INTO lcm_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Matana ka melek luai val rul i vaen na ngisana ka posok luai val mang i rul i tus, using kipo tauia tatana si kana rina. ");
INSERT INTO lcm_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulon ka ago e ngere makasim na kana vuk laman ka ring kalakala ani ri perengan simepo tung ausai. Kana palpal roe ka polok tung e Sidon akorong. ");
INSERT INTO lcm_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isakar kapo dongki dual luai, kapo matung ausai ve kana sungsungukan e tongina. ");
INSERT INTO lcm_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Au na taun kapo arai ta kana ring ipo ausai kapo marip, na roe ang kapo talupus, nganlak ka ainak palau ani ki apaus ia ta mamaiten lava na ka serei a asosokai. ");
INSERT INTO lcm_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan ka saupai aro ani kana vap, asukang ta mangsikei i keve patvap i Israel. ");
INSERT INTO lcm_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ka bil val kene kapo matung ngere selen ipo pasal ta ri os. Na taun ang ka kalat a kakiria, vap po kokos ang kuluria, ki uak arikek ane mung. ");
INSERT INTO lcm_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Numai IAVE, napo atu mata taun kam vilvil ato. ");
INSERT INTO lcm_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad, ri vap tainau ki visvis ia, sikei ka dual aniria na ka lu suai aniria. ");
INSERT INTO lcm_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser, kana keve uai i matang ka aunai ro luai. Na matan pok naminan ang ka angkoai ta ri Tulava ki angan singina. ");
INSERT INTO lcm_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Napitali kapo sang pulakai val me kei lik kita akala ia, na kala akau a keve natnat talupus ro luai. ");
INSERT INTO lcm_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Iosep kapo mangsikei a vaen kapo uai adual luai e ngere laman voiang a keve ngakan ina kipo polok karaunai ani vabat. ");
INSERT INTO lcm_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ri vap so ta vatilau kita marala ia na ki so ia. Kita vis ia velai ani neikien lava. ");
INSERT INTO lcm_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Sikei kata tivo korong luai ta kana vatilau na kungana ka tung madot asukang. Dual i kungana le si God kitmat luai ang si Iakov. Le si katakai i aiveven sipsip ang, nang nia na iat i Israel. ");
INSERT INTO lcm_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Le si kana pakangai a God ang si tamana. Le si kana poso atauia na vo kitmat luai ang. Tauia i mete kuku e pangkul, tauia i kevkev luai i nei roe, tauia i duk ta inatus. ");
INSERT INTO lcm_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Atautauia ang ke tamana kapo soliu ani roron ang le si keve mulang vo to avunga suke. Io, keve atautauia ke, Iosep ka tauia tatana, keve tasina ki arai ania na ki mamaila alava ania. ");
INSERT INTO lcm_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Beniamin kapo mangsikei a kei lava kapo mol arikek. Tenei vauk ka angan a sa katala kong akit ia, na tenei ngelik ka pagal a sa katala luk ia.” ");
INSERT INTO lcm_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Aongos vang sukana na 12 na matan vap suke i Israel. Na sukana na keve mengen tamaria katala posong dong iria si kana poso atautauia aniria. Si atautauia ang kata alis siksikei iria tatana, katapo angkokoai luai akorong singiria. ");
INSERT INTO lcm_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Au na kala pinipini iria asukang ke, “Nalapo usausa kana asi mat using ani kag vap kitala aino iau. Mian amunai anig ngere kag keve vap e nei vakil si roe ang ta Eperon, igenen ang si ri It, ");
INSERT INTO lcm_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","nang a vakil kuvul ve vuk roe ang si Makpela, ngere Mamre, e Kanan, voiang a Abaraam kata samui ia si Eperon ani kakana ta gom. ");
INSERT INTO lcm_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Kita amunai ani ri Abaraam ve kisngana ta Sara, ri Isak ve kisngana ta Rebeka na nau kapa nata kun amunai ani Lea eiang. ");
INSERT INTO lcm_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Vuk roe ang nang ve vakil ang singina i la samui si ri It.” ");
INSERT INTO lcm_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Taun kata kamus ta pinipini ani kana keve nat, kala luk alak a kakina ane kuli pata na kala akamusai ani luk malu alak na kala pasal suai ani kan ago ve kana vap. ");
INSERT INTO lcm_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Na Iosep kala suai ania e kuluna i tamana ta Israel velai ani tangis lava na kala lulus ia. ");
INSERT INTO lcm_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Le na kala asok kana keve katakai ipo itoitonai ani matmat asi itoiton aro ani pukun ina. Na kila abis ia asukang. ");
INSERT INTO lcm_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kata luk aongos a 40 na mangias si itoitonai ani pukun ina val kari laulauan. Na ri Aigipto kita ago i mamakus na tangis ani 70 na mangias aongos. ");
INSERT INTO lcm_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Au, kala kamus a taun i mamakus ania na Iosep kala antok kana matan vap a Parao ta, “Man napo roron e matami, mianla mengen anig si Parao asukang ke, ");
INSERT INTO lcm_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Mamai katapo usausa si mat, na nata atuvala ta nakan amunai ania si vakil i kana la itoiton ang e Kanan. Asukang na napo sokotuk a kalakala ke asi an amunai ani mamai le na name papok.’” ");
INSERT INTO lcm_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Au na Parao kala polpol ta, “Ku pasal na ku an amunai ani tamam val kutala atuvala tatana.” ");
INSERT INTO lcm_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Asukang vang a Iosep kala pasal asi an amunai ani tamana. Keve asosokai aongos si Parao kita auai ve nia kuvul ve keve vap lava i kana vainagoan na ri vap lava aongos i Aigipto. ");
INSERT INTO lcm_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Nei vainagoan aongos si Iosep na keve tasina kapa kita kun auai. Na asukang kapa nei vainagoan ang si tamana. Inatus lik papalik, ri sipsip, na ri bulumakau kita ago pok e Gosen. ");
INSERT INTO lcm_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Vap kapa ipo sang kuli tagtagai na ri os kita auai ve nia. Katapo kuvkuvulan laba luai kita auai ve Iosep. ");
INSERT INTO lcm_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Taun kianla serei e Goren Atar, ngere Ioridan, kila tutapong kup ta tangis using a mamakus lava kalapo meng iria. Na Iosep kala anguan atung an ani mang limalengua na taun i mamakus. ");
INSERT INTO lcm_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ri vap i Kanan kila arai ani radaupa lava ang e Atar na kila antok ta, “Pua, vap suke le Aigipto kipo teng a mangsikei a radaupa lava luai.” Asukang vang na kila atuk a ring ang ngere Ioridan ta Abel Misraim. ");
INSERT INTO lcm_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Kana keve nat a Iakov kitala abis apunuk a pinipini ang a tamaria katala pini iria tatana. ");
INSERT INTO lcm_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Kita sunguk ia ane Kanan, na kianla amunai ania e nei vakil ang si vuk roe ang si Makpela, ngere Mamre, si vuk roe ang a Abaraam kata samui ia si Eperon. ");
INSERT INTO lcm_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Au na emung i amunai tapai ani tamana, Iosep kala papok ane Aigipto ve keve tasina na vap auai aongos ang ve nia. ");
INSERT INTO lcm_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Keve tasina i Iosep kila arai ta tamaria katala mat na kilapo mengen angpokpokai nei liuan iria ta, “Au si man kana na Iosep kapo teng akit lak a rikek ang taratala abis ia taun ia, sa kala ngenget ira singina?” ");
INSERT INTO lcm_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Asukang a kila lis mengen ane si Iosep ta, “Aino le ani tamam ka mat kata pinipini imem asukang ke, ");
INSERT INTO lcm_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Mi antok a Iosep ta napo sokotuk aro ia ani ka lomon suai ani keve visuk na lau rikek ang a keve tasina kitala vil arikek ia tatana.’” Asukang vang kana na namempo sokotuk ua ta ku lomon suai adaus ani kamem rikek, namem na keve asosokai ke si kana God a tamam.” Taun ang a Iosep kata longong a mengen ang kala tangis. ");
INSERT INTO lcm_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Na keve tasina kimela tutalang ia na ki suai aniria e vunep na kila antok ia, “Namem kana na kam keve asosokai aongos.” ");
INSERT INTO lcm_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Sikei Iosep kala antok iria ta, “Mi ago ta leng an. Sa nang? Nau kana name luk kana pangau a God? ");
INSERT INTO lcm_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Io, kami lomlomonai lava ta mi vil arikek iau, sikei God katala asaul pokai ania ani kame serei asukang ke vang, ani to si vap miang ka kalakala. ");
INSERT INTO lcm_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Asukang na mi ago ta leng an. Naka aiveven aro lak imi na kami inatus.” Eiang kala mengen i alomon ro aniria. ");
INSERT INTO lcm_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Iosep kata ago e Aigipto ve patvap aongos ang si tamana. Kata to na 110 na matas aongos. ");
INSERT INTO lcm_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Katapo to lak na inatus si Eparaim kila kun atogon nat akorong. Na inatus ang si Makir, kana nat a Manase, Iosep kata kun posong aniria ta kakana akorong. ");
INSERT INTO lcm_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Na Iosep kala antok a keve tasina ta, “Nalapo angasungai kana asi kag mat. Sikei God lak ka pakangai animi na kame songo suai animi pelek a ring ke, taun a rina ang katala palpalatung ve Abaraam, Isak na Iakov tatana. ");
INSERT INTO lcm_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Na Iosep kala antok kana keve nat a Israel asukang ke, “God ka songo suai animi lak. Au mi atuvala singig ta emung mi sunguk a tuan i pukunig pelek a rina ke.” ");
INSERT INTO lcm_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Au na Iosep kala mat. Iosep kata mat si kata lapo 110 na matas aongos. Emung ila itoitonai le ani pukun ina, kila asiang ia nei asisiang i ri vap po mat eiang e Aigipto. ");
INSERT INTO lcm_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","1","Si taun ang a ri vosap kitapo saupai, katapo atogon a mol nei rina, na mangsikei a igenen i Betlekem si palpal Iuda kata tapasuk asi kana an ago tapai e palpal Moab, ninia ve kisngana na kana ngono nat. ");
INSERT INTO lcm_vpl VALUES ("RT1_2","009_1_2","RUT","1","2","2","Kana asan na igenen ke ta Elimelek na asan i kisngana ta Naomi, na karilong ngono nat ta ri Malon ve Kilion. Riria i patvap si Eparata na kari rina e Betlekem si palpal Iuda. Kita pasal ane si palpal Moab na kianla ago e iang. ");
INSERT INTO lcm_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Taun ang kitan lapo ago e Moab, Elimelek kala mat na Naomi papalik ve kana ngono nat kitol lapo ago. ");
INSERT INTO lcm_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Na ngono nat ang kilongla osongon ta mang pongua na aina le iang, karilong ngono asan ta ri Oripa ve Rut. Kita ago asukang ta sangauli na matas, ");
INSERT INTO lcm_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","na ri Malon ve Kilion kilongla kun mat na Naomi kala ago papalik, kovek i tauan na nat kapa. ");
INSERT INTO lcm_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Na kala tapasuk kuvul ve ngono omona asi kana pasal pelek ani Moab, using e Moab katala longong e ta Volava katala atauia pok kana vap pok. ");
INSERT INTO lcm_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Na kala tapasuk pelek a rina ang katapo ago singina, kuvul ve ngono omona, na kitol lapo pasal aliu asi karitol papok ane palpal Iuda. ");
INSERT INTO lcm_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Sikei Naomi kala antok a ngono omorilong ta, Milong papok, siksikei imilong ane si lu si rinana. Kana papakangai a Volava ka ago singimilong, asukang val milongtala papakangai ani volo angtama la mat ang, na anig. ");
INSERT INTO lcm_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Volava ka alis imilong ta rina ro asi ago, siksikei imilong nei lu si kisngana. Le na kala lulus irilong, na kitol la angtangisai alava. ");
INSERT INTO lcm_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Na kilongla antok ia ta, Parik. Namemlong auai ve numai ane si kam patvap. ");
INSERT INTO lcm_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Sikei Naomi kala antok ta, Ngono omog, milong papok. Marai sa na milongpo buk auai ve nau? Sa, napo sungsungukan kana ta mang ngono nat ani milong osongon irilong lak e mung? ");
INSERT INTO lcm_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Ngono omog, milong papok. Milong pasal, using nalapo lapan tav angkokoai si anguan osongon an. Sa, man kana na antok ta naka anguan osongon an, o man nganlak vong nala atogon tauan asi kag ingus lak, ");
INSERT INTO lcm_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","sa, kapo koi imilong si kokoai le asi kari taviri? Sa, kapo koi imilong si tav osongon tung si taun ang? Ka ago, ngono omog, using kana nala rikek aongos taun napo arai animilong, using a Volava katala tu taliung iau. ");
INSERT INTO lcm_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Na kila anguan tangis alava an, le na Oripa kala lulus a omorilong, sikei Rut kapo bongok akit lak singina. ");
INSERT INTO lcm_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Na kala antok ta, Arai, tungam sukana kalapo pasal pok ane si kana matan vap na kana keve god. Ku papok ve tungam. ");
INSERT INTO lcm_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Sikei Rut kala antok ta, Ago ta sokotuk an anig si papelek anim vo si kag papok. Using saka ring an ku pasal taun ia, tarung kuvul. Saka rina an ku an ago singina, tarung kuvul. Karung sikei palau a matan vap, karung sikei palau a God. ");
INSERT INTO lcm_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Si rina ang ku an mat singina nau kapa nakan mat singina, na e iang ki kepai anig. Volava ka abis asukang singig na alakat kuluna kapa man parik ta mat papalik asi angtaliung anirung. ");
INSERT INTO lcm_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Na kala arai ta kapo atogon vubuk lava asi using ania, asukang a kala kamus ta mengen. ");
INSERT INTO lcm_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Na kilongla pasal aliu tung e Betlekem na taun kilonganla serei e Betlekem, ri vap i nei rina aongos kila taping si arai anirilong, na ri aina kila sui ta, Naomi kana? ");
INSERT INTO lcm_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Na kala antok iria ta, Mi ago ta songo an anig ta Naomi. Mi songo iau ta Mail, using a Vo Kitmat Luai katala aunai vil amail anig. ");
INSERT INTO lcm_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Nata tapasuk le ke velai ani duk ta bil ro, na kana Volava kamela atatung pok iau e ke ta kunga varavarasan. Ago ta songo an anig ta Naomi, using a Volava katala mengen arikek anig na Vo Kitmat Luai katala goeng iau. ");
INSERT INTO lcm_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Sukana na serei pok si Naomi, na omona ta Rut, ainan Moab ang ve nia, nang nia katame serei le palpal Moab. Na karilong serei e Betlekem si taun i tutapongai ta rok kon. ");
INSERT INTO lcm_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Na Naomi katapo atogon a mangsikei a igenen kapo angtogon ve kisngana, kapo igenen tauia na kapo igenen si palpal vap ang si Elimelek, kana asan ta Boas. ");
INSERT INTO lcm_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Na Rut, aina ang le Moab, kala antok a Naomi, Ku ainak anig ani naka pasal ane si non matang suke asi kag an lukluk aiton kon si mang vap man ki ainak anig si an lukluk e mung iria. Na kala antok ia ta, Ku pasal omog. ");
INSERT INTO lcm_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Na kala pasal na kanlapo lukluk aiton emung i vap po abis ang. Na parik kapa nas ta vuk matang ang nang ke Boas akorong, tauan ang i palpal vap ang si Elimelek. ");
INSERT INTO lcm_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Na e iang Boas kala serei le Betlekem, na kala mengen a vap po abis ang ta, VOLAVA ve nami. Na kila ngenget ia ta, VOLAVA ka atautauia ua. ");
INSERT INTO lcm_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Le na Boas kala sui na vopo tu ainoai ani vap po abis ang ta, Ke si ta kavulik ke? ");
INSERT INTO lcm_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Na vopo tu ainoai ang ani vap po abis ang kala ngenget ta, Kavulik ang i palpal Moab, voiang kilongta mela papok ve Naomi le Moab. ");
INSERT INTO lcm_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Kata antok ta, Napo sokotuk ua ani na lukluk aiton e mung i vap po abis ke. Asukang na kamela abis, le tenei vauk lik le tung kana, kovek i ring ausai lik kapa. ");
INSERT INTO lcm_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Na Boas kala antok a Rut, Ku longong, kag kavulik, ku ago ta pasal an ane si mang matang si lukluk aiton. Ku ago ta pasal pelek an ani matang ke kana, sikei ku ago asung i keve kavulik ke singig. ");
INSERT INTO lcm_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ku ararai ani ring ang kipo dok singina na ku pasal e mung iria. Arai, natala mengen akit ri nat ta ki ago ta vil arikek an anim. Na man kula buk inum, ku pasal taun a keve ese suke ri nat kitala lolong iria. ");
INSERT INTO lcm_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Au, kala soturungai ane vunep na kala antok ia, Marai sa na kupo ararai anig ta napo ro, na kupo taot alava iau, nau a aina sokoung palau ke? ");
INSERT INTO lcm_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Au na Boas kala ngenget ia ta mengen asukang ke, Keve lau roron ang kutala abis ia taun a ri omom le si taun ang a kisngam kata mat singina, kita akuskus aongos iau tatana, ta kuta pasal pelek a tamam ve rinam na rina ang kita ingus ua singina, na kumela ago si mang patvap parik kutapa nas aino iria. ");
INSERT INTO lcm_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","VOLAVA ka seu ua si sa kuta abis ia, na ka lis ua ta seupok kirol, nia na VOLAVA, God ke si Israel, nang kume lapo mun neite vangana asi kam sapang. ");
INSERT INTO lcm_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Na kala antok, Kupo roron luai anig, kag igenen lava, using kutala alomonaus iau na kupo mengen ananap aro iau kam asosokai, kantanem parik napa mangsikei i kam keve kavulik. ");
INSERT INTO lcm_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Na si taun i matan angan Boas kala mengen ia ta, Ku me na ku angan, na ku abui kam vuk saui nei uain ke. Asukang na kamela sinong ngere vap po abis ang, na kala alis kon ngungut ania, na kala angan aro tung si kala masung, na kana inongos kalapo sinong. ");
INSERT INTO lcm_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Na kala tapasuk asi kana an lukluk aiton, na Boas kala atatai kana keve asosokai asukang ke, Mi ararai ta ka lukluk kapa nei liuan i keve volo kon na mi ago ta vil amamaila an ania. ");
INSERT INTO lcm_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Na mang anu, mi ulak suai ta mang keve kon asi kana me lukluk nganlak, na mi ago ta atakun an ania. ");
INSERT INTO lcm_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Na kanla lukluk aiton aliu nei matang ang tung tenei ngelik, le na kala mulmul a keve kon i kana lukluk, na mamaiten i kon ang kapo asukang ta sikei a epa. ");
INSERT INTO lcm_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Na kala sunguk ia na kanla pasal ane nei rina, na kanla akalit a omona ta sa katala lukluk aiton ia, na kala kun luk ani inongos i pok i kana angan tapong ang na kala alis ia tatana. ");
INSERT INTO lcm_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Na omona kala antok ia ta, Kuta lukluk aiton anginang e voi? Kuta abis e voi? Atautauia ane si igenen ang kata lomlomonai anim. Na kala amalangasai ani omona ta asan i igenen ang kata abis singina, Asan i igenen ang nata abis singina ta Boas. ");
INSERT INTO lcm_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Na Naomi kala antok a omona ta, Kana atautauia na VOLAVA ka ago si igenen ang, using si kana lau roron parik kapa lomon taun a ri vap to ve ri vap mat kapa. Na Naomi kala mengen kapa ia ta, Tauan ang kapo angtogon ve tara. Kapo mangsikei iria kipo atogon kirim asi aiveven anira. ");
INSERT INTO lcm_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Na Rut, aina ke le Moab, kala mengen ta, Mang anu kapa, kata antok iau asukang ke, Ku ago akit ve kag keve asosokai tung si kila akamusai ani kag keve matang kon aongos. ");
INSERT INTO lcm_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Na Naomi kala antok a omona ta Rut, Kapo ro, kag kavulik, ta ku auai ve kana keve kavulik, vei si mang matang petekai nganing ki vil arikek ua. ");
INSERT INTO lcm_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Asukang na kala auai ve keve kavulik ang si Boas asi kana an lukluk aiton kon tung si taun i kopkopos kala kamus. Na kapo ago nei lu si omona. ");
INSERT INTO lcm_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Na omona ta Naomi kala antok ia ta, Arai omog, naka gulegule ta kam ring asi ago, ani ku ago aro. ");
INSERT INTO lcm_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Na asukang, Boas kana kapo angtogon ve tarung, nang kutapo auai kuvul ve kana keve kavulik. Arai, nganlak vong kana taun asi abis nei ring ipo irang kon ang. ");
INSERT INTO lcm_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ku asising ua na ku amoi ua ta bil sain ro na ku alak kam keve maus roron, le na ku pasal ane si ring ipo irang kon ang. Sikei ka ago ta nas an ta numai e iang tung si kala matan angan aro le. ");
INSERT INTO lcm_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Au, taun kanlapo matung, ku lomon akit a ring ang kapo matung singina, na ku an sanga alak kana apupung e ngono kakina na ku matung Na ninia ka antok ua ta sa si kam abis ania. ");
INSERT INTO lcm_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Na kala antok ta, Sa mipo atatai iau tatana, nala abis aongos ia. ");
INSERT INTO lcm_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Au kala pasiang ane si ring ipo irang kon ang na kanla abis using a atatai ang si omona. ");
INSERT INTO lcm_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Na Boas kala angan na kala inum na kala masung aro, le na kanla matung e mung i kirkirimai i keve kon ang. Au Rut kala pan alak musik lik na kanla sanga alak kana apupung e ngono kakina na kala kun matung. ");
INSERT INTO lcm_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Nei liuan vong a tauan ang kala taping na kala pokpok na kala arai ani aina kapo matung ngere kakina. ");
INSERT INTO lcm_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Na kala sui ta, Numai a si? Na nia kala antok ta, Nau a Rut, kam asosokai. Ku apung kam asosokai ta palpal i kam apupung, using numai a igenen vopo atogon kirim ang asi aiveven. ");
INSERT INTO lcm_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Na kala antok ta, Volava ka alomon aus ua, kag kavulik. Kam lau vo la roron na kapo liu na sa kutala abis ia lenginang, using parik kutapa pasal taun a keve tauan tanginang, logo vo tauia. ");
INSERT INTO lcm_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Na asukang kag kavulik, ku ago ta leng an. Sa kana kutala aikut ia, naka abis aroron ia anim, using a keve tungag aongos si kag rina kipo malangas ta numai a aina roron. ");
INSERT INTO lcm_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Io, kapo korong ta nau a mang igenen asi aiveven anim, sikei kapo atogon a mang sikei kapa kapo atogon a kirim ke na kapo angasungai luai anim. ");
INSERT INTO lcm_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ku ago e ke na vong ke, au na nganlak tenei vauk, man ka naung ani ka aiveven ua, kapo ro palau, ka abis ia. Sikei man parik kapa naung si aiveven anim, nau nala luk a kirim ang, napo mengen ua e matana i Volava. Ku matung e ke tung tenei vauk. ");
INSERT INTO lcm_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Asukang a kala matung e ngere ngono kakina tung tenei vauk, sikei kata tapasuk aino ani kala angkoai si kinle ani mang anu, na nia kala antok ta, Ka ago ta malangas an ta aina ang kata mela ago si ring ipo irang kon ang. ");
INSERT INTO lcm_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Na kala antok ta, Me ta vakup ang e patum na ku eres ia. Na kala eres ia na nia kala bekai dong ia ta limalesikei a kinkintong i kon, na kala asunguk ia tatana, le na kala pasal ane nei rina. ");
INSERT INTO lcm_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Na kanla serei na omona kala sui ia ta, Omog, kalapo sa? Na kala akuskus ia ta sa na tauan ang katala abis ia ania, ");
INSERT INTO lcm_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Kana na limalesikei a mamaiten i kon kata alis iau tatana, using kata antok ta, Ku ago ta papok an ane si ri omom ta kunga palau. ");
INSERT INTO lcm_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Au nia kala antok ta, Ku kokoai, omog, na ku tere ta bil ke ka saka serei an, using a tauan ang parik kapa angkoai si ausai tung si kila vilvil akorong a mengen ke nganlak. ");
INSERT INTO lcm_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Na Boas kala pasal na kan lapo sinong e mete takaman i rina. Na akorong palau, vopo togon kirim ang si aiveven ani Rut, nang a Boas katapo mengen tatana, kamela pakasang. Na kala songo ia, Tungag, mela sinong e ke. Na kamela sinong. ");
INSERT INTO lcm_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Na kala sokotuk a saungauli i keve igenen lava i rina na kala antok, Mi me sinong e ke. Na kimela sinong. ");
INSERT INTO lcm_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Le na kala antok a tungana vopo togon ani kirim ang, Ri Naomi kita mela serei pok kana le Moab. Kilapo buk atos ta vuk roe nang a tungarung ta Elimelek katapo tauk ina. ");
INSERT INTO lcm_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Io, natapo lomlomonai ani naka amalangasai anim tatana, ku samui ia e mataria i vap ke kipo sinong na keve vap lava i kag patvap. Man kupo buk samui ania, ku samui ia. Na man parik, ku antok iau asi kag malangas, using numai palau kupo igenen asi samui ania, na e mung im, nau. Na kala antok ta, Naka samui ia. ");
INSERT INTO lcm_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Na Boas kala antok ta, Taun kupo samui a vuk roe ang si ri Naomi, kalapo asukang ta kupo kun samui ani Rut, aina Moab ke, mainang i Malon, ani asan i vo mat ang ka uli ago si vuk roe ke. ");
INSERT INTO lcm_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Na tungana kala antok ta, Napo tav angkoai si samui ania anig vei nala vil arikek kag inatus e mung. Numai ku luk kag roron asi samui, nau parik napa angkoai si samui ania. ");
INSERT INTO lcm_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Si taun aino si ri Israel kari laulauan i samui na atos katapo asukang ke, asi vil akit ani angainakai, igenen kala luk suai ani pauk i kakina na kala alis ia si mang anu. Sukana na lau i vilvil akorong si ri Israel. ");
INSERT INTO lcm_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Na vopo atogon ani kirim ang kala antok a Boas ta, Ku samui ia anim, na kala luk suai ani pauk i kakina. ");
INSERT INTO lcm_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Na Boas kala antok a keve vap lava na vap aongos ang ta, Kana vang e matami si taun ke anginang nala samui a togtogon aongos ang a Elimelek katapo tauk ina ve kana ngono nat ta ri Kilion ve Malon le si kungaria i ri Naomi. ");
INSERT INTO lcm_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Na kapa, Rut, aina Moab ke, kisngana i Malon, nala samui ia anig, asukang ta kag aina, ani asan i vo mat ang ka uli ago si kana vuk roe, na asan i vo mat ang ka ago ta mus suai an si kana patvap vo e mete takaman i kana rina. Napo mengen e matami kana anginang. ");
INSERT INTO lcm_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Na vap aongos ang kitapo ago mete takaman kuvul ve ri vap lava i rina kila posong asukang ke, Namempo ainak. Volava ka asereiai ani kam aina, nang kalapo ago si kam aiveven, ani ka asukang val ri Rakel ve Lea, voiang kilongta apitus na matan vap si Israel. Ku tauia e Eparata, na ku asasanan e Betilem, ");
INSERT INTO lcm_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","na kam matan vap ki asukang val matan vap ang si Peres nat ang a Tamar kata ingus ia ani Iuda, io, le si inatus ang na Volava ka alis ua tataria si aina tanginang ke. ");
INSERT INTO lcm_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Le na Boas kala songo na Rut asukang val kisngana. Na kala ago kuvul ve nia na Volava kala pakangai ania ani ka sungsungukan, na kala ingus kana nat tauan. ");
INSERT INTO lcm_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Na ri aina kila antok a Naomi ta, Posong ro ane si Volava, using parik katapa atolongon palau ua si taun ke kovek i igenen asi aiveven anim. Ka asasanan si ri Israel. ");
INSERT INTO lcm_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ka vil ato pok ua na ka aiveven aro ua si kam matas i lapan, using a ri omom vo ngorem ang anim, kana kila ingus ia anim. Pua, kari papakangai anim kapo liu na papakangai si man kuta atogon kam limalengua na nat. ");
INSERT INTO lcm_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Na Naomi kala amatung a nat ang e savana na kala aiveven ia. ");
INSERT INTO lcm_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Na keve aina angasungai e iang kila atuk ia ta kana asan using kila arai ta Naomi kalapo atogon nat. Kila atuk ia ta Obed, voiang kapo tamana i Iese, na nia kapo tamana i David. ");
INSERT INTO lcm_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Na kana vang na angusing i matan angtama le si Peres: Peres kata asereiai ani Esron, ");
INSERT INTO lcm_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","na Esron kata asereiai ani Ram, na Ram kata asereiai ani Aminadav, ");
INSERT INTO lcm_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","na Aminadav kata asereiai ani Nason, na Nason kata asereiai ani Salmon, ");
INSERT INTO lcm_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","na Salmon kata asereiai ani Boas, na Boas kata asereiai ani Obed, ");
INSERT INTO lcm_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","na Obed kata asereiai ani Iese, na Iese kata asereiai ani David. ");
INSERT INTO lcm_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Kana na kalingana i Iave taun a Iona, tamana ta Amitai: God kata asok a Iona asukang ke, ");
INSERT INTO lcm_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Ku pasal taun a rina lava suke Nineve, na kuanla ngavaka iria si kari keve lau rikek, using kalapo rikek luai e matag.” ");
INSERT INTO lcm_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Sikei Iona kala tadut asi sip ani asok ang si Iave. Na kala pasiang ane Iopa na kanla serei arokonai ani mang perengan si lapo usausa ane Tarsis. Au kala samui kana selen na kala kokos ani ka an ago akipai ani Iave. ");
INSERT INTO lcm_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Nei liuan i kari paspasal Iave kala alis a mang malu kitmat na nei laman kalapo toan alava luai na kalapo ararai ta to ka tavadek korong a perengan ang. ");
INSERT INTO lcm_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Vap aongos kuli perengan ang kilapo leng, na siksikei aliu iria kalapo sokotuk serei si kana tangatangai ani ka pakangai aniria. Asi kari akala ani perengan ang kila asuai ani usausan nei laman. Sikei Iona katala pasiang ane neina i perengan ang na kanlapo rodot musik lik. ");
INSERT INTO lcm_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Na tulava i kuli perengan ang kanla sabonai ania na kala sui ia, “Au, kupo rot sa? Ku tapasuk na ku songo serei si kam tangatangai. Vei ninia nganing ka vinga marip anira, na ka asapang kara to.” ");
INSERT INTO lcm_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Na vap akorong i kuli perengan ang kila angmememengenai angpokpokai aniria asukang ke, “Au, tara vil a mangsikei a abis i gusgus asi kara sabonai akorong ani igenen ke kapo buk vil apuka aira.” Na kila sabonai ani kana asan a Iona. ");
INSERT INTO lcm_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Asukang na kila mengen ia, “Kana ku antok imem! Si kana kapo vila puka ira ta nem ke? Numai akorong, Kupo saka igenen an? Kuta pasal le si saka rina an? Nei kam rina, na nei kam patvap?” ");
INSERT INTO lcm_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Au, kala polpol ta, “Nau a igenen i Eberaio, napo lomlomon ta Iave, nia kapo God i metekuku na kata piruma na kuli vunep na nei laman”. ");
INSERT INTO lcm_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Na kala akus iria ta kapo sip ani Iave. Taun kila longong a mengen ke si Iona, kila leng alava, na kila antok ia, “Kupo bil arikek luai iuang!” ");
INSERT INTO lcm_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Au, rai ang kapo anguan tadut akit an. Asukang na kila sui ia ta, “Au, namem saka bil an kana anim si kana kamus na rai lava ke?” ");
INSERT INTO lcm_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Na kala antok ta, “Mi asuai anig nei laman asi kana pongo na rai ke. Napo malangas ta kakag ta rikek na kana mimelapo puka.” ");
INSERT INTO lcm_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Eiang kipo kalip amadot asi kari me ngangat ngerelo. Sikei rai ang kapo anguan serei amadot an kovek ta mang saka ring an asi pasal. ");
INSERT INTO lcm_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Asukang na kila sokotuk a Iave ta, “Namempo sokotuk ani ku ago ta vil punuk an animem marai la gulang ta kana to na igenen ke! Namem raung ia kana, sikei numai Iave, ku ago ta marala an using kutala asereai ani keve nem aongos ke.” ");
INSERT INTO lcm_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Au na ki asalak a Iona na ki asuai ania nei laman. Na rai lava ang kala kamus na luai kala matung. ");
INSERT INTO lcm_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Taun kila arai ani luai ke, kila aunai i leng ani Iave singina, na kila vil a mang alilis serei singina na ki atutu vala asi kari angtogon ve nia. ");
INSERT INTO lcm_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Sikei Iona parik kata lapa mat nei laman, using Iave kata asok a mangsikei a ien lava na kamela konem ia. Na kanla ago na potol a mangias na potol a vong e vingana i ien lava ang. ");
INSERT INTO lcm_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","E nei vingana i ien ang Iona kala mengen taun a IAVE kana God, ");
INSERT INTO lcm_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","“Iave, si kag puka nata songo ua na kula polpol iau. Io, e nei laman miting, si rina i mat, natapo songo papakangai na kula longong iau. ");
INSERT INTO lcm_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Kuta asuai anig nei laman miting ane kevkev luai i laman, na aulitai aongos kel kata sang tatag. Kam keve to lava nei laman kitapo saul lakat kulug. ");
INSERT INTO lcm_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Natapo lomon ia ta kutala kirikai luai anig pelek a matam, sikei napo atu mata ta naka arai pok lak ani kam lu i atailai. ");
INSERT INTO lcm_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Laman kamela karaunai anig. Laman kala pakut asip aongos iau. Ri aigamang kimela pis aulitai ani patug. ");
INSERT INTO lcm_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Natala pasiang luai ane si tukul dup i keve mulang, taun a rina i mat na roe kalapo teng akitmat luai anig eke. Sikei numai IAVE kag God, kutala songo pelek a lulung i mat tatag asi kag to. ");
INSERT INTO lcm_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Taun kag to kalapo ngau, sikei napo lomlomon tatam, IAVE, na kag sokotuk kalapo palak taun ua si kam lu i atailai. ");
INSERT INTO lcm_vpl VALUES ("JH2_8","033_2_8","JON","2","8","9","Numai IAVE, kupo buk vil ato ani ri vap, sikei man kipo uli longong si kari keve tangatangai palau, parik kupa anguan ngorem an aniria. Kupo buk vil ato ani ri vap, sikei man kipo uli longong si kari keve tangatangai palau. Sikei nau naka tangam i alatun ane singim. Naka vil kag alilis serei singim. Naka abis a bil ang nata atu vala asi kag abis ania. Kalaro luai using a vilvilato kapo serei le singim, Iave.” ");
INSERT INTO lcm_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Au, na Iave kala asok a ien ang asi kanan mutakai ani Iona e ngerelo, na ien ang kala vil ia asukang. ");
INSERT INTO lcm_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Na IAVE kala anguan asok an ani Iona ta, ");
INSERT INTO lcm_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Ku pasal taun a rina lava suke e Nineve na kuanla ngavaka iria ta mengen ang natala alis ua tatana”. ");
INSERT INTO lcm_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Au, na asukang Iona kala longong a Iave na kala pasal ane Nineve. Nineve kapo rina tavirimok lava. Kapo luk a potol a taun si arai ani keve bil aongos nei rina. ");
INSERT INTO lcm_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Au, Iona kala serei palak(pok?) si ainoiai i taun na ka pasal a nei rina. Ka amalangasai ani ri vap asukang ke ta, “Mang puat a sangauli na taun lak na emung ina ka tagoeng suai aongos a nei rina ke”. ");
INSERT INTO lcm_vpl VALUES ("JH3_5","033_3_5","JON","3","5","6","Na vap aongos i Nineve kila lomlomon ta kana mengen a God. Na kari vosap kapa, taun kata longong a mengen si God, kala tadut pelek kana sinsinongan lakat, ka luang suai ani kana maus i vosap, na ka alak a maus tading na ka sinong mete vuta. Na ka saupai ta kana vap aongos ki alal ani pok, na ani ri vap asasanan tung si vap po ago e kevkev luai ang, ria aongos ki alak a maus tading. ");
INSERT INTO lcm_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Kalingana i vosap taun a vap aongos i Nineve kata serei asukang ke, “Nau a vosap i rina ke na volo posongan, namemtol po asok asukang ke: Ka ago ta sikei ka angan ta ring men inongos lik, ri vap aongos, ri bulumakau, na ri sipsip. Ri pok, ve laman kilong ago luai. ");
INSERT INTO lcm_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Nami aongos mi alak kami keve maus tading, na ri manmanik kapa, mi apung iria ta vakup tading. Tara aongos, tara sokotuk amadot a God. Tara atolongon kara keve lau rikek na lau i angdaung. ");
INSERT INTO lcm_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Vei God nganing ka sakol kana lomlomonai, na ka ngorem ira. Iau, vei kana marala ka kamus nganing na parik taralapa mat.” ");
INSERT INTO lcm_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Au, God kala arai ta kila atolongon kari keve lau rikek. Asukang na kala ngorem iria na kala sakol kana lomlomonai na parik kalapa vis punuk iria val kana ainoai i lomlomonai. ");
INSERT INTO lcm_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Sikei Iona kalapo misag alava i kana lapo nas ani lau i ming ang, na kalapo songag ani IAVE. ");
INSERT INTO lcm_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Kala antok a IAVE asukang ke, “E no le i kag me pasal suai ani rina, nata nas ta nganlak ku bil asukang palau. Nambang a tukulai ina na nata sip sumasuma ane Tarsis. Natala malangas ta kupo God roron i ngorem, uli kokoai ananap, uli ngorem, uli usausa asi sakol ani lomlomonai i vis punuk. ");
INSERT INTO lcm_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Kana vang IAVE, ku atolongon iau na naka mat. Napo ro luai asi mat na to ka ago!” ");
INSERT INTO lcm_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Sikei God kala sui ia ta, “Kapo saka roron an anim si songag?” ");
INSERT INTO lcm_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Au, Iona kala papelek a rina ang taun a ring ipo sanglak ta makarap, na kanla abis kana marmarip na kala sinong neina kokoai asi kana arai ta saka nam an ka serei e Nineve. ");
INSERT INTO lcm_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Na God IAVE kala apolokai ani mang iei asi kana polok alava taunai ani Iona asi kana amarmarip aro luai ania. Tauan ke vola uruk alava luai marai togon ani marmarip ke. ");
INSERT INTO lcm_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Sikei eno i sanglak ta makarap si taun using ina, God kala lis a mang sikei a kanipa na kanipa ke kala angan a iei ang na kala magang. ");
INSERT INTO lcm_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Na emung, makarap kala sanglak na God kala lis a malu manas. Iona kala talus a pukun ina ta ngan i sinang kitmat arikek ang. Asukang na kalapo buk asi kana mat na kala antok ta, “Napo ro luai asi mat, na to ka ago!” ");
INSERT INTO lcm_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Sikei God kala sui ia ta, “Kapo saka roron an anim si songag marai i ei palau ke?” Na kala antok ta, “Napo angkoai ro asi songag na kag songag kapo angkoai ani naka mat!” ");
INSERT INTO lcm_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Na IAVE kala antok ia ta, “Numai kana, ku longong! Ei ke kana kata polok alava alak si sikei a vong palau na ka kovek pok si taun using ina. Numai parik kutapa bil ta sa singina na parik kutapa apolokai ania, sikei lak kupo lomlomonai ngorem ania! ");
INSERT INTO lcm_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Au, sa? Kupo songag anig si la ngorem ani vap duk suke? Kapo rina tavirimok lava luai. Tataot i vap kapo liu a 120,000. Na kipo tauia ta mamain ta vongo kapa. Na vap ang, kipo asukang val inatus lik, kipo tav malangas! Au, na numai kupo ngorem a iei palau ke si sa?” ");
INSERT INTO lcm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Kana na akus i mamain ta polpolokan le si Abaram tung si David tung si Iesu Karisto. ");
INSERT INTO lcm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abaram kata apolokai ani Isak, na Isak kata apolokai ani Iakov, na Iakov kata apolokai ani ri Iudas ve keve tasina. ");
INSERT INTO lcm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Au na Iudas kata apolokai ani ri Pares ve Sara, rinarilong ta Tamar. Au na Pares kata apolokai ani Esron, na Esron kata apolokai ani Aram, ");
INSERT INTO lcm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","na Aram kata apolokai ani Aminadav, na Aminadav kata apolokai ani Nason, na Nason kata apolokai ani Salmon, ");
INSERT INTO lcm_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","na Salmon kata apolokai ani Boes, rinana ta Rakav. Na Boes kata apolokai ani Iobet rinana ta Rut. Au na Iobet kata apolokai ani Iesai, ");
INSERT INTO lcm_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","na Iesai kata apolokai ani David nia na tulava. Au na David kata apolokai ani Solomon, rinana ta ri kisngana i Urias. ");
INSERT INTO lcm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Au na Solomon kata apolokai ani Roboam, na Roboam kata apolokai ani Abia, na Abia kata apolokai ani Asap, ");
INSERT INTO lcm_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","na Asap kata apolokai ani Iosapat, na Iosapat kata apolokai ani Ioram, na Ioram kata apolokai ani Osias, ");
INSERT INTO lcm_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","na Osias kata apolokai ani Ioatam, na Ioatam kata apolokai ani Akas, na Akas kata apolokai ani Esekias, ");
INSERT INTO lcm_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","na Esekias kata apolokai ani Manases, na Manases kata apolokai ani Amon, na Amon kata apolokai ani Iosias, ");
INSERT INTO lcm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","na Iosias kata apolokai ani ri Iekonias ve keve tasina si taun i kong ato aniria ane Babulon. ");
INSERT INTO lcm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Au, e mung i kong ato aniria ane Babulon, Iekonias kata apolokai ani Salatiel, na Salatiel kata apolokai ani Sorobabel, ");
INSERT INTO lcm_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","na Sorobabel kata apolokai ani Abiut, na Abiut kata apolokai ani Eliakim, na Eliakim kata apolokai ani Asor, ");
INSERT INTO lcm_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","na Asor kata apolokai ani Sadok, na Sadok kata apolokai ani Akim, na Akim kata apolokai ani Eliut, ");
INSERT INTO lcm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","na Eliut kata apolokai ani Eleasar, na Eleasar kata apolokai ani Matan, na Matan kata apolokai ani Iakov, ");
INSERT INTO lcm_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","na Iakov kata apolokai ani Iosep, na Iosep kata osongon a Maria, nang kata ingus a Iesu, voiang kipo posong ia ta igenen i akanangai. ");
INSERT INTO lcm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Au, asukang na tataot i keve polpolokan le si Abaram tung si David kapo sangauli na puat aongos. Na asukang kapa le si David tung si taun i kong ato aniria ane Babulon kapo sangauli na puat aongos. Na asukang kapa le si taun i kong ato aniria ane Babulon tung si igenen i akanangai kala serei, kapo sangauli na puat aongos. ");
INSERT INTO lcm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ingus ani Iesu Karisto kata asukang ke. Rinana ta Maria, na si taun ang kita pala ia ani Iosep na parik lak kilong tapa ago kuvul, kila arai ta kalapo sungsungukan le si kitmat i Malanganto Gogoai. ");
INSERT INTO lcm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Au na Iosep, kana tauan, katapo igenen korong na katapo misag ani ka mamaila na kapo buk ta ka atolongon suai musik lik ania. ");
INSERT INTO lcm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Taun ang a lomlomonai ang katapo ago lak, angelo si Volava kala serei singina nei orodung, na kala antok ia, “Iosep, nat i David, ku ago ta leng an ani osongon ta Maria using kana sungsungukan le si kitmat i Malanganto Gogoai. ");
INSERT INTO lcm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Na ka ingus lak a nat tauan, na ku atuk ia ta Iesu using ninia vanang ka vil ato kana vap pelek kari lau rikek.” ");
INSERT INTO lcm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Io, keve bil ke kata serei si apunuk ani kana mengen a Volava e nguruna i katakai i kus amalangas asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Arai, aina tanginang ang ka sungsungukan lak na ka ingus a nat tauan na ki atuk ia ta Emanuel, supsupai ina ta God ve tara. ");
INSERT INTO lcm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Na Iosep kala tapangun na kala vil ia asukang val angelo si Volava kata antok ia na kala osongon kana aina ");
INSERT INTO lcm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","na parik katapa rot kuvul ve nia tung si kala ingus a nat tauan na kala atuk ia ta Iesu. ");
INSERT INTO lcm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iesu kita ingus ia e Betilem e palpal Iudaia si taun ang a Erodes katapo tulava singina, na mang keve katakai i malangas le si ring ipo sanglak ta makarap kimela serei e Ierusalem na kila sui, ");
INSERT INTO lcm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Nei vanang a nat ang kita ingus ia ani ka tulava ani ri Iudaia? Namemtala arai ani kalto i akanangai ania e palpal ipo sanglak ta makarap, na kana namem lapo serei sime soturungai singina.” ");
INSERT INTO lcm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na tulava ta Erodes kala longong a mengen asukang na kalapo pisu, na ri vap aongos i Ierusalem kapa. ");
INSERT INTO lcm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Kala songo akuvul na keve ainoinoai si ri katakai i sula ve keve vap malangas ani saupai na kala sui iria ta nei a rina ang ki ingus a Karisto singina. ");
INSERT INTO lcm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na kila antok ia, “E Betilem, e Iudaia, asukang val katakai i kus amalangas kata salik ia, ");
INSERT INTO lcm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Numai, Betilem e palpal roe si Iudas, parik luai kupa liklik ani mamain ta ainoinoai i ri Iudas. Using le singim mangsikei a ainoinoai ka serei, voiang ka aiveven kag mamain ta sipsip, ri Israel.” ");
INSERT INTO lcm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Au, Erodes kala songo musik lik na keve igenen malangas ang na kala sui iria ani ka nanas aro ta saka taun an a kalto ang kata serei singina. ");
INSERT INTO lcm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Na kala asok iria ane Betilem ta mengen asukang ke, “Mi pasal na mianla susuiai aroron lik pulakai ta nat ang, na man mila sabonai ania mi antok amalangas pok iau, ani nau kapa nakan kun soturungai singina.” ");
INSERT INTO lcm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Na kila longong kana mengen a tulava na kila pasal. Vuk taun ang kipo pasal, kalto ang, nia palau na kalto ang kita arai ania si ring ipo sanglak ta makarap, kala ainoai aniria ane si ring a popo ang kapo matung singina na kanla sinong akit. ");
INSERT INTO lcm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Taun kipo arai ani kalto ang kitapo uruk alava luai. ");
INSERT INTO lcm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Na kila riuk lak ane nei lu na kianla arai ani popo kuvul ve rinana ta Maria. Na kila soturungai ane vunep i alatun ania. Na kila eres kari keve asisiang na kila alis ia ta kana keve alilis miminaungan, gol na libanos ve simurna. ");
INSERT INTO lcm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","God kata atakun iria nei orodung ta ki ago tan serei pok an si Erodes. Asukang na kila using a mang selen petekai ane rina. ");
INSERT INTO lcm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Au, e mung i kari la pasal tapai, angelo si Volava kala serei si Iosep nei orodung na kala antok ia, “Tadut. Songo na nat ke ve rinana na mitol sip ane Aigipto, na mitol an ago e iang tung si na mengen amalangas pok ua, using a Erodes ka gulegule na nat ke ani ka raung ia.” ");
INSERT INTO lcm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Si tenei vong ang Iosep kala tadut na kala songo na nat ang ve rinana na kitol la tapasuk asi karitol pasal ane Aigipto. ");
INSERT INTO lcm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Na kitol la ago e iang tung si Erodes kala mat. Io, keve bil ke kata serei si apunuk ani kana mengen a Volava e nguruna i katakai i kus amalangas asukang ke, Natala songo suai ani kag nat pelek a Aigipto. ");
INSERT INTO lcm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na Erodes kalapo marala alava using kapo kinle ta keve igenen malangas kitala kapau ia. Na kala asok asi raung suai ani ri nat lik aongos e Betilem na aulitai ania, ria kipo pongua na matas na asiang, using katala nas a taun le si kana nanas ani keve igenen malangas ang. ");
INSERT INTO lcm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","E iang a mengen ang si katakai i kus amalangas ta Ieremias kala serei atutuman, ");
INSERT INTO lcm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Kalinga e Rama kapo tangis, mangsikei kapo raupa. Rakel kapo tangis alava luai using kana inatus. Kapo pat aongos ia na mamakus using kana inatus kitala mat. ");
INSERT INTO lcm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Au, Erodes kala mat tapai na angelo si Volava kala serei si Iosep nei orodung e Aigipto na kala antok ia, ");
INSERT INTO lcm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Tadut. Songo na nat ke ve rinana na mitol pasal pok ane Israel. Using vap po buk raung ang ani nat ke kitala mat.” ");
INSERT INTO lcm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Na kala tadut na kala songo na nat ang ve rinana na kitol la pasal pok ane Israel. ");
INSERT INTO lcm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Sikei kanla longong ta Arkelaus kalapo sakol a tamana ta Erodes asukang ta tulava i Iudaia, na kalapo leng ani ago e iang. Na God kala mengen amalangas luai ania nei orodung, asukang na kala pasal luai ane palpal Galilaia. ");
INSERT INTO lcm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na kitol anla serei na kitol anla ago si mang sikei a rina, kana asan ta Nasaret, si vil apunuk ani mengen ang si ri katakai i kus amalangas asukang ke, “Ki posong ia ta igenen i Nasaret.” ");
INSERT INTO lcm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Si pangau i taun ang, Ioanes katakai i asing tauia kata serei nei ring varasai palau e Iudaia na kame lapo akuskus asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mi lomon pokai using a vainagoan i metekuku kalapo angasungai.” ");
INSERT INTO lcm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kana na igenen ke, Esias kata mengen aino tatana asukang ke, Kalingana i mang igenen kapo songosongo e nei ring varasai palau asukang ke. Mi usausa na selen ani Volava, mi itoiton ta selen korong ania. ");
INSERT INTO lcm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ioanes katapo alak vakup i ung i kamel, na katapo ngenge ta pauk i vongo, na katapo angan bivo ve murungan i nei uten. ");
INSERT INTO lcm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Na vap i Ierusalem na aulitai aongos i Iudaia na i ngere sung ang e Iordanes ");
INSERT INTO lcm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","kimela mengen amalangas ta kari keve lau rikek, na kala asing tauia iria si sung ang e Iordanes. ");
INSERT INTO lcm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Si taun ang kala arai ani ri Parisaio ve ri Sadukaio sipo pasal taun ania si kana me asing tauia aniria, na kala antok iria ta, “Nami na mamain ta natnat i kene. Si nang kata antok imi si kami sip pelek ani marala vo serei ang? ");
INSERT INTO lcm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sikei mi uai asereiai tapai ani lau bil voiang ka atai amalangas ta mitala lomon pokai. ");
INSERT INTO lcm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Na mi ago ta angmemengenai musik an ta mipo angtivu aro ve Abaram. Using napo antok imi ta God kapo angkoai si luk ani keve iat ke na ka asereiai ani keve tivuna i Abaram tatana! ");
INSERT INTO lcm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kaput nang kalapo tung usausa si tukul i ei. Keve ei ang vanang parik kipa uai ta uai roron, asi tanga suai dong ani kut. ");
INSERT INTO lcm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nau napo asing tauia imi ta laman asi akanangai ta mitala ming, sikei nia vopo aimung ig, kapo tavirimok anig, napo tav ro angkoai luai ve asosokai palau vopo sunguk ani pauk i kakina. Nia vanang kame asing tauia imi ta Malanganto Gogoai ve kut ni. ");
INSERT INTO lcm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Kalapo tung usausa asi kana irang suai ani keve katui i kon na kan sinong kuvul nei lu. Sikei ka suluk suai ani mung nei kut vo tav angkoai si mat ang.” ");
INSERT INTO lcm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Au le na Iesu kala serei le Galilaia sime asing tauia ania ta Ioanes e Iordanes. ");
INSERT INTO lcm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sikei Ioanes kapo atokngai si kana atakun ania na kala antok, “Nau vanang, napo ro ani numai asi kam asing tauia anig, au na kana kume lapo serei singig?” ");
INSERT INTO lcm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Na Iesu kala polpol ia, “Lomon suai ania na ka asukang. Kapo ro anirung si abis ania asukang ke si vil apunuk ani mamain ta bil korong aongos.” Au na kala ainak. ");
INSERT INTO lcm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Na e mung i asiang tauia, na Iesu kala kiklak le nei sung na akorong palau metekuku kala tavas na kala arai ani Malanganto i God kapo pasiang asukang val uk na kame lapo gon singina. ");
INSERT INTO lcm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Na kalinga le metekuku kala antok, “Kana kag nat ro, napo buk alava ia. Napo uruk luai ania.” ");
INSERT INTO lcm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Au Iesu, Malanganto kala ainoai ania ane nei ring varasai palau ani vo petau ang ania kan atokngai ania. ");
INSERT INTO lcm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na katapo alal si pangau i 40 na mang ias ve tenei vong, na e mung kalapo buk angan. ");
INSERT INTO lcm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na katakai i atoktokngai kala serei singina na kala antok ia, “Man numai a nat i God, ku asok a keve at ke si kari sakol ane si pok.” ");
INSERT INTO lcm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Na kala polpol ia ta, “Kita salik ia ta, Parik kapa angkoai si ri vap ki to ta pok papa, sikei si keve mengen aongos kapo soung le si nguruna i God.” ");
INSERT INTO lcm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Au le na vo petau ang kala songo ia ane nei rina gogoai na kanla atung ia si ring lakat luai kuli rina i atailai, ");
INSERT INTO lcm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na kala antok ia, “Man numai a nat i God, ku akik asiang using kita salik ia ta, Ka asok kana keve angelo taun ua, na ki teng alakat ua ta kungaria vei kakim ka tukai si at.” ");
INSERT INTO lcm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Na Iesu kala antok ia ta, “Kitala kun salik kapa ta, Ku ago ta atoktokngai ani Volava kam God.” ");
INSERT INTO lcm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Au, vo petau ang ania kala songo alak ia kuli mulang lakat luai na kanla akalit ia ta mamain ta vainagoan aongos i kuli rina na miminaungan ina, ");
INSERT INTO lcm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","na kala antok ia, “Keve bil aongos ke naka alis ua tatana si man ku soturungai singig.” ");
INSERT INTO lcm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Na Iesu kala antok ia, “Pasal suai anig, Satan! Using kitala salik ia ta, Ku soturungai si Volava kam God, na nia papalik ku abis ania.” ");
INSERT INTO lcm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Na Ingua kala pasal pelek ia na ri angelo kimela pakangai ania. ");
INSERT INTO lcm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Taun kala longong ta kitala alakai ani Ioanes nei lu i akangbat na kala papok ane Galilaia. ");
INSERT INTO lcm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na kala aingingik pelek a Nasara asi kana me ago e Kaparnaum, nang kapo ago ngere laman tatapulitai si ngono palpal ke Sabulon ve Neptalim ");
INSERT INTO lcm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","si vil apunuk ani mengen ang si Esias katakai i kus amalangas asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Palpal Sabulon na palpal Napitali, e ngere laman, si mang palpal i Iordanes, Galilaia si ri vap i ngising. ");
INSERT INTO lcm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ri vap ago nei vong kitala arai ani malangas laba. Malangas kalapo tapading si vap ang kipo ago si palpal i mat. ");
INSERT INTO lcm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Le si taun ang Iesu kalapo akuskus asukang ke, “Mi lomon pokai, using a vainagoan i metekuku kalapo angasungai.” ");
INSERT INTO lcm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Taun katapo pasal aliu e ngere laman tatapulitai ang e Galilaia, na kala arai ani mang ngono angtasimal, ri Simon, kipo kin ia ta Petero, ve tasina ta Andereas. Kilongtapo so ta uvene nei laman, using kilongtapo katakai i maiak. ");
INSERT INTO lcm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na kala antok irilong, “Milong me auai ve nau. Nakan iton imilong asi kamilong sog ani ri vap.” ");
INSERT INTO lcm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nang palau kilongla papelek karilong keve uvene na kilongla using ia. ");
INSERT INTO lcm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Au, kala paliu aliu le iang na kala arai ani mang ngono angtasimal, ri Iakovo ve tasina ta Ioanes, tamarilong ta Sebedaio. Kitol tapo itoiton karitol uvene ve tamarilong kuli vul. Au, kala arai anirilong na kala songo irilong. ");
INSERT INTO lcm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nang palau kilongla papelek na tamarilong kuli vul na kilongla using ia. ");
INSERT INTO lcm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Au, kala pasal aongos a Galilaia na kapo akuskus nei kari keve lu i kivung. Katapo akus ta akus ro i vainagoan. Na kapo vilvil ato na mamain ta malepen anglok si ri vap. ");
INSERT INTO lcm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Na akus ina kala sang aongos a Suria na ri vap kipo serei singina ta kari mamain ta malepen, riria kipo maiten si ri kui lava, na riria kipo sangan ta ingua, na ri go, na ri soles kapa, na kapo vil ato aongos iria. ");
INSERT INTO lcm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Na vap duk luai le Galilaia, na Dekapolis, na Ierusalem, na Iudaia na mang palpal kapa i Iordanes, riria aongos kilapo using ia. ");
INSERT INTO lcm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Si taun kala arai ani petau lava ang, kala kiklak ane kuli put na kalapo sinong. Na kana keve nat i akalit kimela serei singina ");
INSERT INTO lcm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","na kalapo tutapong vil akalit singiria asukang ke. ");
INSERT INTO lcm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Uruk kakaria kipo makus e malanganto iria, using kakaria na vainagoan i metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Uruk kakaria kipo tangis, using ki anatok lak iria. ");
INSERT INTO lcm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Uruk kakaria kipo mailik, using ki tauk lak i kuli rina. ");
INSERT INTO lcm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Uruk kakaria kipo tauke using na lau korong, using kian masung. ");
INSERT INTO lcm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Uruk kakaria kipo atogon a lau i ngorem tangis, using kian ngorem asukang iria. ");
INSERT INTO lcm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Uruk kakaria kipo vinga daus, using kian arai ani God. ");
INSERT INTO lcm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Uruk kakaria kipo asereiai ani marip, using ki kin iria ta inatus si God. ");
INSERT INTO lcm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Uruk kakaria kitala vilvil akui iria marai kari lau korong, using kakaria na vainagoan i metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Uruk kakami si man ri vap ki mengen arikek animi, na ki vil akui imi na ki kapau ta poisan a sa rikek animi marai ig. ");
INSERT INTO lcm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mi uruk na mi uruk alava, using kami seupok laba kapo ago e metekuku. Using ninia palau kana si selen ke kita kun vil akui ani keve katakai i kus amalangas aino animi. ");
INSERT INTO lcm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nami na makasim i kuli rina. Sikei si man a makasim kala kovek na namin ina, ki saka vil anaminan an pok ania? Kalapo kovek i mang roron ina, si asuai palau ania ane komo na ri vap kian saksak meng ia. ");
INSERT INTO lcm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nami na alimang i kuli rina. A rina lava kuli put parik kapa angkoai si mumun. ");
INSERT INTO lcm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Parik tarapa asusuk a lam asi amunai ania nei avubus, parik. Tarapo atung ia si kana ring akorong, ani ka mang aongos ri vap nei lu. ");
INSERT INTO lcm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Asukang palau nami, mi kun mang amalangas e mataria i ri vap ani ki arai ani kami keve abis ro na ki alatun a tamami e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mi ago ta lomon an ania ta natame serei asi kag me akamusai suai ani keve mengen i nei saupai na ri katakai i kus amalangas, parik. Parik nata mepa serei asi akamusai aniria parik. Sikei asi kag me vil apunuk aniria. ");
INSERT INTO lcm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Io, napo antok atutuman imi. Tung si metekuku ve kuli rina kilong pasal suai, ka kovek ta mang sikei a vuk salsalik lik ka tamus le si keve saupai, tung si kian vil korong aongos a sa kipo mengen tatana. ");
INSERT INTO lcm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Asukang na si man a si ka putuk a mangsikei a saupai lik luai na ka akalit a mang matan si kari using ania, ki kin ia ta anu lik luai nei vainagoan i metekuku. Sikei man a si kapo abis using iria na kapo akalit tataria, ki kin ia ta anu tavirimok nei vainagoan i metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Io, napo antok imi ta si man kami keve lau korong parik kapa roron ani keve lau ang si ri Parisaio ve ri vap malangas ani saupai voiang kipo sekpat ta kipo lau roron, parik mipa angkoai asi palak nei vainagoan i metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mipo malangas ta kitala antok ri vap aino ta, Ku ago ta daung an, na si kapo daung kan tung si saupai. ");
INSERT INTO lcm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Sikei nau napo antok imi ta si kapo marala na tungana kan kun tung mete saupai. Na si kapo kin a tungana ta vangang gulgul, kan kun tung mete saupai kitmat luai. Na si kapo kin ta, ‘Numai a tanio,’ kapo togon rikek angkoai sian siang nei kut lava i saupai. ");
INSERT INTO lcm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Asukang na si man kupo serei velai ani alilis si pata ipo sula, na kula lomlomonai ani kana rikek a tungam ve numai, ");
INSERT INTO lcm_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ku lomon suai ani alilis ang e mete pata na kuan vilvil akorong tapai ve tungam le na kume alilis ta kam alilis. ");
INSERT INTO lcm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Vilvil akorong sumasuma na rikek ve kam igenen vopo atung anim si saupai. Vilvil akorong ia si taun ang milongpo paliu lak nei selen vei kanla agon ua e kungana i vo saupai na nia kanla agon ua e kungana i vo aiveven vilvil akui na kanla alakai anim nei lu i akangbat. ");
INSERT INTO lcm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Napa antok atutuman ua ta parik luai kupa angkoai si soung le iang, tung si kula samui suai luai ani akamusai luai i vuk kope lik. ");
INSERT INTO lcm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mipo malangas ta kitala antok ta, Ago ta putuk osongon an. ");
INSERT INTO lcm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sikei nau napo antok imi ta si kapo lomlomonai musik ani mangsikei a aina, lenginang kalapo putuk osongon e nei pakangat ina. ");
INSERT INTO lcm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Au na man a palso i matam katala vil ua si uak si lau rikek, ku ruvel suai ania na ku asuai akipai ania, using kapo ro ani palpal im ka puka ani pukun im aongos ki asuai ania nei kut lava i saupai. ");
INSERT INTO lcm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na si man a palso i kungam kala vil ua si uak si lau rikek, ku lamputuk ia na ku asuai akipai ania, using kapo ro ani palpal im ka puka ani pukun im aongos ki asuai ania nei kut lava i saupai. ");
INSERT INTO lcm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Kitala antok kapa ta, Si kapo buk kamus si kana aina ka alis ia ta panbuk i mengen amalangas ta karilong kamus. ");
INSERT INTO lcm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sikei nau napo antok imi ta man a si katala kamus si kana aina, parik napa mengen kana ta man kata panik aino, e iang kapo vil kana aina ta kanla abis a lau rikek. Na man a si katala osongon ta aina ila asuai ta kana tauan, sukana kapo vil a lau rikek. ");
INSERT INTO lcm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Au kapa, mipo malangas ta kitala antok ri vap aino ta, Ku ago ta kapau an si atu vala, ku abis atutuman ia mete Volava. ");
INSERT INTO lcm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sikei nau napo antok imi ta mi ago luai ta atu vala an serei si mang bil, serei si metekuku ka ago using kapo kana sinsinong a God. ");
INSERT INTO lcm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na si kuli vunep ka ago using kapo oring ipo agon ani kakina. Na si Ierusalem ka ago using kapo kana rina na tulava tavirimok. ");
INSERT INTO lcm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na mi ago ta atu vala an serei si vangang imi using parik mipa angkoai si vil aposok vo vil amiting ani mangsikei a ung i patumi. ");
INSERT INTO lcm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mi antok palau ta io si man kapo io, na parik si man kapo parik. Man mi mengen ta saka vuk mengen an asi vil amaiten ani ngenget ang, sukana kapo serei le si vo rikek ang. ");
INSERT INTO lcm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mipo malangas ta kitala antok ta, Luvek a matana man kata luvek a matam, na mul a ngisana man kata mul a ngisam. ");
INSERT INTO lcm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sikei nau napo antok imi ta mi ago ta vil bat an ani igenen vopo abis lau rikek singim. Si man ka tava ua si palso i asam, ku alis ia ta mang asam na ka tava ia. ");
INSERT INTO lcm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Na si man a mangsikei kapo buk vil akorong ani kam rikek singina ta kam mang siot, ku alis ia ta kam vakup kapa. ");
INSERT INTO lcm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Si man a mangsikei ka sulai anim si pasal ani vuk oring, ku pasal ve nia na vuk uring kapo vunga amatan pongua i kana vubuk. ");
INSERT INTO lcm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Alis a si kapo aikut ua, na ku ago ta ultaliung an si man kipo buk luk tapai singim. ");
INSERT INTO lcm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Mipo malangas ta kitala antok ta, Ku vinga ro taun a tungam na ku mirik ani igenen ipo marala anim. ");
INSERT INTO lcm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sikei nau napo antok imi ta mi vinga ro taun a keve vap ipo marala animi na mi sokotuk aniria kipo vil akui imi, ");
INSERT INTO lcm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ani mi serei a inatus si tamami e metekuku. Mi arai ania. Ninia kapo vil kana makarap na kapo sinang singiria kipo rikek na riria kipo ro. Na kapa, kapo asok na langit ane kuluria kipo korong na riria kipo tav korong. ");
INSERT INTO lcm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Arai, man mipo vinga ro papalik taun a vap ang kipo vinga ro taun imi, mi saka luk an ani seupok? Au sa, keve vap luk takis ke parik kipa vil korong ia? ");
INSERT INTO lcm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Au na man mipo ruduai papalik na tasimi akorong papalik, sa mipo abis ia kapo roron ani mang vap ang? Au sa, ri vap i ngising parik kipa vil korong ia? ");
INSERT INTO lcm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Asukang na mi lau korong asukang val tamami e metekuku kapo uli korong. ");
INSERT INTO lcm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mi aiveven aro ani mi ago ta abis ani kami laulauan korong e mataria i ri vap asi kari arai animi. Si man asukang, mipo kovek i seupok si tamami e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Asukang na man ku alilis ane si ri vap logo, ku ago ta kup an tatana val ri katakai i kapau kipo abis ia nei lu i kivung na nei selen ani ri vap si kari alatun aniria. Napo antok atutuman imi, kitala luk aongos lenginang kari seupok. ");
INSERT INTO lcm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sikei, si man ku alilis ane si ri vap logo, kam palkais ka ago ta nas ani sa na kam palso kapo abis ia, ");
INSERT INTO lcm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ani kam alilis si kana mumun. Na tamam, nia vo arai ani bil mumun, ka seu ua. ");
INSERT INTO lcm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Na man mi sokotuk, mi ago ta bil an val ri katakai i kapau. Arai, taun kipo sokotuk kipo tung nei lu i kivung vo nei selen ani ri vap si kari arai aniria. Napo antok atutuman imi. Kitala luk aongos lenginang kari seupok. ");
INSERT INTO lcm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sikei numai man ku buk sokotuk, ku palak ane nei lu na ku akang a takaman, le na ku sokotuk a tamam voiang parik kupa arai ania. Au na tamam vanang, nia vo arai ang ani keve bil mumun, ka seu ua. ");
INSERT INTO lcm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Man mi sokotuk, mi ago ta uli kin an ani sikei a vuk mengen amatan duk luai miang val ri vap i ngising, using kipo sekpat ani man ki uli posong ania, nginlak ki longong iria. ");
INSERT INTO lcm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Asukang na mi ago ta bil an val ria, using a tamami kapo nas a sa mipo inongos taun ia aino ani mi aikut ia. ");
INSERT INTO lcm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Asukang na mi sokotuk asukang ke. Tamamem e metekuku, namem uli mamaila ani asan im. ");
INSERT INTO lcm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kam vainagoan kame, na kume abis kam vubuk e ke kuli rina, asukang val kupo abis ia e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ku alis imem ta kamem pok ani taun ke. ");
INSERT INTO lcm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ku lomon suai ani kamem keve lau rikek, asukang val namem-tala kun lomon suai ani kari keve lau rikek. ");
INSERT INTO lcm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na ku ago ta ausingai animem taun a atoktokngai. Ku asa-pang imem pelek a igenen rikek. ");
INSERT INTO lcm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Using man mi lomon suai ani kari rikek io, tamami kapa e metekuku ka kun lomon suai ani kami lau rikek. ");
INSERT INTO lcm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sikei man parik mipa lomon suai ani kari rikek, tamami kapa parik kapa kun lomon suai ani kami rikek. ");
INSERT INTO lcm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Man mi alal, mi ago ta nau mamakus an val ri katakai i kapau. Riria kipo vil arikek a noria ani ri vap si kari nas ta kipo alal. Napo antok atutuman imi, kitala luk aongos lenginang kari seupok. ");
INSERT INTO lcm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sikei numai man ku buk alal, ku amoi a nom ta rul i elaio na ku raus a matam ");
INSERT INTO lcm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ani ri vap ki ago ta nas an ta kupo alal, sikei tamam papalik voiang parik kupa arai ania, nia ka nas. Au na tamam vanang, nia vo arai ani keve bil mumun, ka seu ua. ");
INSERT INTO lcm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mi ago ta asinong an ani kami tauia e ke kuli rina, vei nganing a ros na manmanik kala vil arikek ia. Na vap tainau ki galang alak na kian tainau ia. ");
INSERT INTO lcm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sikei mi asinong kami tauia e metekuku si rina ang ros na manmanik parik kapa angkoai si vil arikek ania na ri vap tainau parik kipa galang alak na kin tainau ia. ");
INSERT INTO lcm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Arai, man kam atogtogon kapo ago si saka ring an, pakangat im kapa ka kun ago singina. ");
INSERT INTO lcm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mata ninia na lam ani pukun. Asukang na man a matam ka ro, pukun im aongos ka malangas. ");
INSERT INTO lcm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sikei man a matam parik kapa ro, pukun im aongos ka vong. Au e iang vanang ku arai ta man a malangas ang singim kapo vong, vola vong luai akorong! ");
INSERT INTO lcm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Parik kapa angkoai luai ani igenen ka abis ani pongua na volava. Man rilong angtaunai, ka mirik ani sikei na ka buk a mang anu, vo ka buk alava luai ani mang anu na ka misag luai ani mang anu. Parik mipa angkoai si abis ani God ve kapkap kapa.” ");
INSERT INTO lcm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Na kala antok kana keve nat i akalit, “Asukang a napo antok imi ta mi ago ta urui an ani kami to, ta mi angan a sa, na mi inum a sa, na ani pukun imi ta mi kavat ta sa. Sa, kami to parik kapa laba ani pok? Na pukun imi parik kapa laba ani vakup? ");
INSERT INTO lcm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mi arai ani mamain ta mani nei pangau. Parik kipa sukal na parik kipa kopkopos na parik kipa asinong pok nei lu. Sikei tamami e metekuku kapo li pok iria. Sa, nami parik mipa roron aniria? ");
INSERT INTO lcm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Si imi kapo angkoai si to avunga lik si uli urui? ");
INSERT INTO lcm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Au, using a sa mipo urui using a vakup ani pukun? Mi arai ani mamain ta purpur nei matang si kari polok. Parik kipa abis. Parik kipa suisui vakup. ");
INSERT INTO lcm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sikei napo antok imi ta Solomon si kana amaumausan asip parik katapa miminaungan asukang val mang sikei iria. ");
INSERT INTO lcm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","God kana kapo amaus a mamain ta uriuri ani ki mang miminaungan ani sikei a taun kudik palau, na ilesvauk ki suluk suai aniria. Au nei vanang? God parik kapa angkoai si kavat animi? Pua, kami lomlomon kapo kudik luai! ");
INSERT INTO lcm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Asukang a mi ago ta urui an na mi sui ta, tara angan a sa, vo tara inum a sa, vo tara kavat ta sa. ");
INSERT INTO lcm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Using a ri vap i ngising kipo gule na keve nem ke. Na tamami e metekuku kapo nas ta mipo inongos taun iria. ");
INSERT INTO lcm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sikei, ainoai ina mi lomlomon maiten using kana vainagoan na kana lau korong, na keve nem ke takami iria kapa. ");
INSERT INTO lcm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Asukang na mi ago ta urui an ani ilesvauk, using a ilesvauk ka kun urui pok ania. Siksikei a taun kapo kun atogon mamaiten ania akorong. ");
INSERT INTO lcm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mi ago ta kiming an ani tungami, vei nganing kila kun kiming animi. ");
INSERT INTO lcm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Using si saka selen an mita kiming a tungami, ki kun vil ania kapa singimi, na ki abis singimi angkokoai palau val lau ang mita abis ia. ");
INSERT INTO lcm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Marai sa kupo tun a tep lik ang e matana i tungam, na numai akorong kupo tav nasai ani vukei lava ang e matam? ");
INSERT INTO lcm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kapo saka ro an man ku antok a tasim ta, ‘Me, name luk suai tapai ani tep ang e matam’ man a vukei lava ang kapo ago e matam? ");
INSERT INTO lcm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Numai a katakai i kapau. Aino ina, ku luk suai ani vukei lava ang e matam akorong, le na kula angkokoai asi arai atapalas si luk suai ani tep ang e matana i tungam. ");
INSERT INTO lcm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mi ago ta alis ani ri kauvek ve ri vongo ta bil ang kapo daus vo kapo samui lava, vei nganing ki saksak meng ia vo ki tu talang imi na ki tang arikek luai animi. ");
INSERT INTO lcm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Mi aikut na mi atogon, mi gule na mi sabonai, mi pirpirikai na takaman ka tavas animi. ");
INSERT INTO lcm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Io, ninia kapo aikut, ka luk. Na ninia kapo gule, ka sabonai. Na ninia kapo pirpirikai, takaman ka tavas ania. ");
INSERT INTO lcm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Numai igenen, man kam nat ka aikut ua ta pok, sa nang, kula alis ia ta iat? ");
INSERT INTO lcm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Vo man ka aikut ua ta ien, sa nang, kula alis ia ta kene? ");
INSERT INTO lcm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nami na mamain ta katakai i bil arikek, sikei mipo uskorong a lau i alilis ta mamain ta alilis roron si kami inatus. Au sa nang si tamami e metekuku? Ninia parik kapa nas a lau i alilis ani bil roron singiria kipo sokotuk ia? ");
INSERT INTO lcm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Asukang a ninia palau a lau ang mipo buk ani ri vap ki abis ia singimi, mi kun abis ania singiria. E iang milapo abis aro na saupai ve keve mengen ang si ri katakai i kus amalangas. ");
INSERT INTO lcm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Mi palak si takaman ngingimai using a takaman ane si puka kapo laba na selen ang kapo papanai na vap miang kipo palak neina. ");
INSERT INTO lcm_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Io, takaman ane si to kapo liklik na selen ang kapo ngingimai. Na rukun lik palau kipo sabonai ania. ");
INSERT INTO lcm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mi aiveven aro vei ri katakai i kus amalangas kapau. Kipo serei singimi ta ararai i sipsip, sikei nei vingaria kipo asukang ta kauvek kalat. ");
INSERT INTO lcm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mi kinle korong iria si uai iria. Sa, tarapo kopos vaen si ei rodotan? Tarapo kopos suke si ei kakaulan? Parik. ");
INSERT INTO lcm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Using ri ei roron kipo uli asereiai ani uai roron. Na ri ei rikek kipo uli asereiai ani uai rikek. ");
INSERT INTO lcm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ei roron parik kapa angkoai si asereiai ani uai rikek. Na ei rikek parik kapa angkoai si asereiai ani uai roron. ");
INSERT INTO lcm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ri ei aongos voiang parik kipa uai ani uai roron, ki tanga suai aniria na ki asuai aniria nei kut. ");
INSERT INTO lcm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Asukang vang, mi kinle iria si uai iria. ");
INSERT INTO lcm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Parik ta ri vap aongos voiang kipo songo iau ta ‘Volava, Volava,’ kian palak nei vainagoan e metekuku. Sikei riria papalik kipo usiusing kana vubuk a mamai e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Si taun ang, vap miang ki antok iau, ‘Volava, Volava, namemta kus amalangas si asan im na namemta lu suai ani ri ingua si asan im, na namemta abis a keve bil i vilvil ataping miang si asan im.’ ");
INSERT INTO lcm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Sikei, na antok iria, ‘Parik natapa nas imi, mi pasal suai anig, nami na mamain ta katakai i putuk saupai.’ ");
INSERT INTO lcm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Riria kipo longong kag keve mengen kana na kipo abis using ia, kipo asukang val mangsikei a igenen nas kata abis kana lu kuli at. ");
INSERT INTO lcm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Langit kata usen, na molong ka but asiang, na malu kala malu arikek a lu ke, sikei parik katapa tabut using kata akevkevai kuli at. ");
INSERT INTO lcm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Au na riria kipo longong kag keve mengen kana na kipo tav using ia, kipo bil val mangsikei a igenen nio kata abis kana lu kuli kone palau. ");
INSERT INTO lcm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Langit kata usen, na molong ka but asiang, na malu kala malu arikek a lu ang na kala tabut aongos luai.” ");
INSERT INTO lcm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Si taun ang a Iesu kala akamusai ani keve mengen ang, petau lava ang kilapo taping ani kana akalkalit, ");
INSERT INTO lcm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","using kapo mengen iria val igenen atogon kitmat na parik val kari keve vap malangas ani saupai. ");
INSERT INTO lcm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Au na si taun kala kiksiang le kuli mulang, petau lava kila using ia. ");
INSERT INTO lcm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na mang igenen tapak kamela sovusulai singina na kala antok, “Volava, man kupo naung, kupo angkoai si vil adaus anig.” ");
INSERT INTO lcm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Na kala sulai ani kungana na kala teng e pukun ina na kala antok ta, “Io, napo naung. Pukun im kala serei daus vang!” Na akorong palau na pukun tapak ang kala daus. ");
INSERT INTO lcm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Na Iesu kala antok ia ta, “Ku ago ta mengen amalangas an ani mangsikei ta bil ke, sikei kuan akalit ta pukun im si katakai i sula ani ka suluk a alilis val kana sausaupai a Moses, ani ri vap asi kari nas ta kulapo daus.” ");
INSERT INTO lcm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Au na kanla palak nei rina e Kaparnaum, na mangsikei a ainoinoai i petau ipo visvis kamela serei singina na kamela sokotuk ia ");
INSERT INTO lcm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","asukang ke, “Volava, kag asosokai kalapo matung mat nei lu ta kui tavirimok.” ");
INSERT INTO lcm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Na kala antok ia ta, “Naka pasal na nakan vil ato ia.” ");
INSERT INTO lcm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Na ainoinoai ang kala antok, “Volava, napo tav ro angkoai asi songo alak anim ane nei kag lu, sikei ku posong palau na kag asosokai ka to. ");
INSERT INTO lcm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Using nau kana napo igenen ipo ago neite saupai, na kag petau i visvis kipo kun ago neite kag saupai. Asukang ta man naka asok a mang anu ta ka pasal, na kala pasal. Na man naka asok a mang anu ta ka me, na kamela pakasang. Na man naka asok kag mang asosokai ta ka abis a mang nem, na kala abis ia.” ");
INSERT INTO lcm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Si vuk taun ang a Iesu kala longong kana mengen, kala taping na kala antok a petau vo using ang ania ta, “Napo antok atutuman imi ta parik lak napa arai ani lomlomon kit asukang ke nei liuan i ri Israel. ");
INSERT INTO lcm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Napo antok imi ta vap miang ki serei le si keve palpal miang i kuli rina na kime sinong si matan angan ve Abaram, Isak na Iakov si vainagoan e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sikei riria akorong i vainagoan ang ki asuai aniria ane komo ane nei vong miting luai na kian tangis velai ngut ngisa.” ");
INSERT INTO lcm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Au na kala antok na vo ainoinoai ang ta, “Ku pasal na ka asukang palau anim val kutala lomlomon.” Na si vuk taun ang palau kana asosokai kala to. ");
INSERT INTO lcm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Na Iesu kanla palak nei lu si Petero na kanla arai ani omona i Petero sipo matung malepen ta mulak. ");
INSERT INTO lcm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Na kala sigil a kungana na malepen ang kala pasal suai ania. Na kala tadut na kalapo sasagi ania. ");
INSERT INTO lcm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ngelik i taun ang, kime lapo serei singina ta vap miang ingua katapo aol iria. Na kame lapo kirikai suai ani keve ingua ang ta vuk mengen lik palau. Na kapo vil ato aongos iria kitapo malepen. ");
INSERT INTO lcm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nang asi vil apunuk ani mengen ang si Esias katakai i kus amalangas ta, Ninia akorong kata sunguk kara keve ngau na kata asalak kara keve malepen. ");
INSERT INTO lcm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesu kala arai ani petau lava aulitai ina na kala asok asi kokos aputuk ane mang palpal. ");
INSERT INTO lcm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Au na mangsikei a igenen malangas ani saupai kamela antok ta, “Katakai i akalit, nau naka auai ve numai si saka oring an ku pasal ia.” ");
INSERT INTO lcm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Na Iesu kala antok ia, “Ri kauvek kei kipo atogon kari mata na ri mani i nei pangau kipo atogon ting, sikei igenen i pukun kapo kovek ta ring asi aoros ani patuna.” ");
INSERT INTO lcm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Na kana mang nat i akalit kala antok ia, “Volava, ku naol suai tapai anig na nakan mo tapai ani mamai.” ");
INSERT INTO lcm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Na Iesu kala antok ia ta, “Ku using iau. Atalipai ani ri vap mat na ki mo kari keve matmat.” ");
INSERT INTO lcm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Au na kala kokos kuli vul na kana keve nat i akalit kila kun auai ve nia. ");
INSERT INTO lcm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","E nei laman rai lava kala serei, na to kalapo lak nei kari vul, sikei nia katapo rot. ");
INSERT INTO lcm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na kianla pangun ia, “Volava, ku asapang ira. Tara puka kana!” ");
INSERT INTO lcm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Na kala sui iria ta, “Marai sa na mipo leng? Nami na vap lomlomon kudik.” Na kala tadut na kala atakun a malu ve to asi karilong kamus, na luai lava kala pitik. ");
INSERT INTO lcm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Na keve nat ang kilapo sugul luai, na kilapo sui ta, “Au si saka igenen an kana na malu ve to kipo kun longong korong ania?” ");
INSERT INTO lcm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na kanla serei e mang palpal, si palpal ang si ri Gadareno. Na pongua na igenen sangan ta ingua kilongmela duai ia le nei gom. Kilongtapo aunai i kei alava. Asukang na katapo kovek ta igenen katapo pasal korong a ring ang. ");
INSERT INTO lcm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Au, kilong mela songosongo ta, “Nat i God, kupo serei asi kam me ve vil sa animem! Sa, kula serei aino ani taun i atung asi me vil akui animem?” ");
INSERT INTO lcm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Mang takaman vongo katapo susuang e ring vunga lik, ");
INSERT INTO lcm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","au na keve ingua ang kila sokotuk ia ta, “Man ku asok suai animem, ku asok imem na namem palak si takaman vongo suke.” ");
INSERT INTO lcm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Na kala antok iria ta, “Pasal!” Au kila soung na kianla aol a keve vongo ang. Au na takaman vongo aongos ang kila doso asiang taun a ring karkadapan na kianla lus mat nei laman. ");
INSERT INTO lcm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Na vap po aiveven vongo ang kila sip, na kianla serei e nei rina na kila atatai ta keve bil aongos ke, na sa kata serei si ngono vo sangan ta ingua ang. ");
INSERT INTO lcm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Au na nei rina aongos ang kimela soung si me arai ani Iesu. Taun kila arai ania kimela sokotuk ia asi kana pasal pelek suai ani kari palpal. ");
INSERT INTO lcm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Na Iesu kala kokos kuli vul ane si mang palpal na kanla serei si kana rina. ");
INSERT INTO lcm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na mang vap kimela serei singina ta mang igenen soles na kapo oros kuli kana pata. Si taun a Iesu kala arai kinle ani kari lomlomon kala antok a igenen soles ang ta, “Ku maramarak, kag nat, kam keve lau rikek, nala lomon suai ania.” ");
INSERT INTO lcm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Au na ri vap malangas ani saupai kila mengen musik ta, “Igenen ke kalapo mengen i nau varas.” ");
INSERT INTO lcm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Na Iesu kala nas kari lomlomonai na kala antok, “Marai sa mipo atogon a lomlomonai rikek nei vingami? ");
INSERT INTO lcm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Si i ngono bil ke kapo remrem si antok ania? Nala lomon suai ani kam lau rikek, vo si antok ta ku tapasuk na ku pasal? ");
INSERT INTO lcm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Sikei, asi kami nas vang ta igenen i pukun kapo atogon kitmat kuli rina si kana lomon suai ani rikek.” Le na kala antok na igenen soles ang ta, “Tadut na ku sunguk le kam pata na ku pasal ane rina.” ");
INSERT INTO lcm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Na kala tadut na kala pasal ane rina. ");
INSERT INTO lcm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na petau lava aongos e iang kila arai ani bil ke, na kilapo leng na kilapo alatun a God using kapo ali kitmat asukang ke ane si igenen ke. ");
INSERT INTO lcm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Au, taun a Iesu kala pasal pelek a ring ang kala arai ani mang igenen kana asan ta Mataio kapo sinong nei lu ipo luk takis. Na kala antok ia, “Me, using iau.” Na kala tadut na kala using ia. ");
INSERT INTO lcm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na kanlapo angan nei lu, na petau duk, vap po luk takis na mamain ta katakai i bil arikek kimela sinong kuvul ve Iesu na kana keve nat i akalit. ");
INSERT INTO lcm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Na ri Parisaio kila arai ani oring ang na kila sui kana keve nat i akalit ta, “Marai sa na kami katakai i akalit kapo angan kuvul ve ri vap luk takis na ri vap bil arikek?” ");
INSERT INTO lcm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sikei kala longong iria na kala antok, “Vap po to aro parik kipa inongos taun a katakai i vilvil ato, sikei ri malepen vang kipo inongos taun ia. ");
INSERT INTO lcm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mi pasal na mian nas le na supsupai i vuk mengen ke, Napo buk arai ani ngorem, parik ta alilis. Using parik natapa serei asi me songo ani vap korong, sikei ri katakai i bil arikek.” ");
INSERT INTO lcm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Keve nat i akalit si Ioanes kimela serei singina na kila sui ia ta, “Marai sa na namem ve ri Parisaio namempo alal, na kam keve nat i akalit parik?” ");
INSERT INTO lcm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Na Iesu kala antok iria, “Sa nang? Mipo buk atakun ani keve tungana i votauk i pagamau ani ki ago ta urukan mamakus si taun kipo ago kuvul ve nia? Ka atogon a taun iles lak na kila luk suai ani vo tauk i pagamau pelek a keve tungana. Taun ang vanang ki mal lak. ");
INSERT INTO lcm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kapo tav angkoai si tara suisui alak ani vuk vakup tanginang si maus kavang. Man asukang, vuk vakup tanginang ang ka ding pok a maus ang na ka vil alava pok na tading ang. ");
INSERT INTO lcm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na kapo tav angkoai kapa si tara lingai ani vaen tanginang si pauk kavang, vei pauk ang ka tading. Sukana na vaen kala vekai asip na pauk ang kapa kala rikek. Sikei, vaen tanginang vanang kapo ro si pauk tanginang, ani rilong aongos kilong uli ro.” ");
INSERT INTO lcm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Si taun ang kapo mengen lak iria, mangsikei a ainoinoai kamela palak na kala sovusulai e matana na kala antok, “Kag kavulik katala tapikon. Sikei kume na kuan amatung a kungam singina asi kana to pok.” ");
INSERT INTO lcm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Au Iesu kala tapasuk na kala pasal ve nia kuvul ve kana keve nat i akalit. ");
INSERT INTO lcm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na mangsikei a aina katapo uli kui ta tongmasik asukang ta 12 na matas aongos, na kala gingging kolotai alak ania na kanla sigil a su i kana vakup. ");
INSERT INTO lcm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Using kapo lomlomonai musik ta, “Man naka sigil lik palau kana vakup nala roron pok.” ");
INSERT INTO lcm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sikei Iesu kala ulpokai na kala arai ania na kala antok, “Ku uruk, kag kavulik. Kam lomlomon kala vil ato pok ua.” Nang palau na aina ang kala to pok. ");
INSERT INTO lcm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Au, Iesu kala palak nei lu si ainoinoai ang na kala arai ani ri katakai i kuikui na loek lava, ");
INSERT INTO lcm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","na kala antok ta, “Mi pasal suai, using a kavulik ke parik kapa mat, kapo rot palau.” Na kila los ia. ");
INSERT INTO lcm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na petau ang kila soung ane komo, na kala palak na kanla teng a kungana. Na kavulik ang kala tadut. ");
INSERT INTO lcm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Na akus ke kala papanai nei palpal aongos ang. ");
INSERT INTO lcm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Au, Iesu kala pasal aliu le iang na mang ngono igenen mata ba kilongla tadut using ia, na kilongpo songosongo alava, “Nat i David, ku ngorem imemlong.” ");
INSERT INTO lcm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Na kanla riuk lak mete lu na ngono ba ke kilongla pataun ia. Na Iesu kala sui irilong ta, “Milongpo lomlomon ta napo angkoai si vil korong ani nem ke?” Na kilongla antok ia ta, “Io, Volava.” ");
INSERT INTO lcm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Na kala sigil a matarilong na kala antok, “Io, ka asukang palau val kamilong lomlomon.” ");
INSERT INTO lcm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Na kilongla mata arai aro pok. Na Iesu kala sokotakun akit irilong ta, “Mi aiveven akit ta ka ago ta mangsikei ka nas a nem ke!” ");
INSERT INTO lcm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sikei kilongla pasal na kilong anla akuskus pulakai tatana nei palpal aongos ang. ");
INSERT INTO lcm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Au, kila pasal suai na mang vap kimela serei singina ta mang igenen sangan ta ingua na parik kapa angkoai si mengen. ");
INSERT INTO lcm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Na Iesu kala kirikai suai ani ingua ang na igenen ang kalapo mengen korong. Na petau ang kilapo taping na kila antok, “Kapo kovek lak i bil asukang ke namemta arai ania nei liuan i ri Israel.” ");
INSERT INTO lcm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Na ri Parisaio kilapo antok ta, “Kapo luk kitmat le si ainoinoai i ri ingua si kana lu suai aniria.” ");
INSERT INTO lcm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Na Iesu kala pasal aongos nei liuan i keve rina lava na keve rina lik, na kapo akalkalit nei kari keve lu i kivung na kapo akus ta akus ro i vainagoan na kapo vil ato na ri vap pelek kari keve maiten na malepen anglok aongos. ");
INSERT INTO lcm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Taun kalapo arai ani petau lava, kalapo ngorem iria using kitapo makatis na kipo kovek i papakangai, asukang ta ri sipsip kovek i vo aiveven aniria. ");
INSERT INTO lcm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Au na kala antok kana keve nat i akalit ta, “Uai i nei matang kalapo duk, sikei kipo men lik palau a vap si kopos ania. ");
INSERT INTO lcm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Asukang na mi sokotuk a Volava i nei matang si kana asok ta vap sian kopos nei kana matang.” ");
INSERT INTO lcm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Na kala songo asung kana 12 na nat i akalit na kala alis iria ta kitmat asi kirikai ani ri malanganto rikek, na si vilvil ato ani ri vap pelek a mamain ta mamaiten na malepen anglok aongos. ");
INSERT INTO lcm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kana na keve asan i 12 na aposel ang. Ainoai ina, Simon, nang kana mang asan ta Petero, na tasina ta Andereas, ri Iakovo ve Ioanes, ngono nat ke si Sebedaio, ");
INSERT INTO lcm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ri Pilipo ve Bartolomaio, ri Tomas ve Mataio vopo luk takis ang, na Iakovo si Alpaio, na Tadaio, ");
INSERT INTO lcm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","na Simon, mangsikei i ri Kananaio, na Iudas Iskariot vopo alis suai ania asi kana mat. ");
INSERT INTO lcm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Io, 12 nat ke, Iesu kata asok iria kuvul velai ani atatai ke, “Mi an ago ta pasal an ane nei liuan i ri vap i ngising na mi ago ta an palak an nei keve rina si ri Samareia. ");
INSERT INTO lcm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sikei, mi pasal taun a keve sipsip mun i ri Israel. ");
INSERT INTO lcm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na taun mi pasal, mi akuskus asukang ke, ‘Vainagoan i metekuku kalapo angasungai.’ ");
INSERT INTO lcm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mi vil ato ri malepen, mi tak atadut ri mat, mi vil adaus ri tapak, mi kirikai ani ri ingua. Parik mitapa samui, asukang na mi kun alis palau tav luk samui. ");
INSERT INTO lcm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ago ta luk le an ta saka ring kapkap an nei kami keve asisiang. ");
INSERT INTO lcm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tepe ani pasal ke ka ago, pongua na siot ka ago, pauk i kak ka ago, kipa ka ago, using a igenen abis, kapo ro ka luk kana seupok i abis. ");
INSERT INTO lcm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Saka rina lava an vo rina lik mipo serei singina, mi gule ta igenen kapo ro na mian ago tung si taun ang mi papelek pok a rina ang singina. ");
INSERT INTO lcm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Si taun mipo palak si kana lu, mi poso aro ia. ");
INSERT INTO lcm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Si man kipo ro angkoai si luk ani kami poso amarip, kapo ro ki luk ia. Sikei si man a nei lu ang parik kitapa ro animi, mi luk pok kami poso amarip. ");
INSERT INTO lcm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Man a ri si ki tav ainak animi, na kipo misag ani longong ani kami mengen, mi tipngai suai ani kaponpon e kakimi si taun mila pasal suai ani lu ang vo rina ang. ");
INSERT INTO lcm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Napo antok atutuman imi ta si taun e mung ka pen roron lik ani ri Sodoma ve Gomora, sikei ri vap i rina ang ki sikei a rikek luai an. ");
INSERT INTO lcm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Arai, napo asok imi asukang ta keve sipsip nei liuan i ri kauvek kalat. Asukang na mi uli alpok aro luai na mi uli daus luai. ");
INSERT INTO lcm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mi aiveven si ri vap, using ki teng akit imi lak taun a saupai, na ki sasaup imi nei kari keve lu i kivung. ");
INSERT INTO lcm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ki tak imi taun a keve ainoinoai na keve tulava marai ig, asi kami akuskus amalangas e mataria na e mataria i ri vap i ngising. ");
INSERT INTO lcm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Man kila alis suai animi e kungaria, mi ago ta urui an ta mian saka mengen vo ngenget an, using a mengen asi kami mengen, mi luk ia si vuk taun ang. ");
INSERT INTO lcm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Using parik ta nami mianpa mengen, Malanganto i tamami ka mengen singimi. ");
INSERT INTO lcm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Igenen ka alis suai ani tasina asi an raung ania. Inatus kapa ki puka si tamaria si lau ke, na ri tamaria ve rinaria kapa, ki kun mat si kari inatus. ");
INSERT INTO lcm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na ri vap aongos ki mirik animi marai asan ig. Sikei man a si ka tung akit tung si akamusai ina, ka sapang. ");
INSERT INTO lcm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Si man ki vil akui imi si mang rina, mi sip ane si mang rina. Napo antok atutuman imi ta parik mipa akamusai ani keve rina aongos i Israel aino ani igenen i pukun ka serei pok. ");
INSERT INTO lcm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ri nat i akalit parik kipa tavirimok ani kari katakai i akalit. Na asosokai kapa parik kapa tavirimok ani kana ainoinoai. ");
INSERT INTO lcm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nat i akalit ka kuvul palau ve kana katakai i akalit na asosokai ve kana ainoinoai. Au man kitala kin na ainoinoai i lu ta Belsebul, marai sa na kime kun angarimai animi? ");
INSERT INTO lcm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","E iang mi ago ta leng an aniria, using kapo kovek i bil katapo ago nei apupung, ki tav tavas ania. Vo bil katapo mumun, ka tav serei e ring malangas. ");
INSERT INTO lcm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sa napo antok imi e ring vong, mi mengen amalangas tatana e mete malangas. Saka mengen an kitapo angtutulibotai tatana, mi songosongo tatana e ring malangas nei rina. ");
INSERT INTO lcm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mi ago ta leng an aniria kipo raung a pukun palau na parik kipa raung korong na malanganto. Sikei mi leng vang ani vo raung ang ani pukun ve malanganto aongos nei kut lava i saupai. ");
INSERT INTO lcm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Arai ani ri tuv. Kipo samui iria ta kapkap lik luai palau. Na parik ta mangsikei iria kapo angkoai si uak ane vunep si man a tamami parik kapa ainak. ");
INSERT INTO lcm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Io, God katala taot pasuk a keve ung i patumi. ");
INSERT INTO lcm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Asukang na mi ago ta leng an. Nami mipo marmarai lava luai ani mamain ta tuv duk. ");
INSERT INTO lcm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Riria kipo atitipas tatag e mataria i ri vap, asukang nau kapa naka kun atitipas tataria e matana i mamai e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sikei, ninia kapo agel suai anig e mataria i ri vap, nau kapa na kun agel suai ania e matana i mamai e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ago ta lomon an ania ta natame serei asi me asinong ani luai kuli rina, parik. Nata serei ani nala alis samele. ");
INSERT INTO lcm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Kag serei ka vil a ri angtama ta ki tapagal angtaliungai, ri angnanan, na ri angomonan kapa. Mang anu ka marala na mang anu. ");
INSERT INTO lcm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Na keve vap ipo marala ani igenen, ki serei le nei kana lu akorong. ");
INSERT INTO lcm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Si kapo lomon alava na tamana ve rinana anig, parik kapa roron angkoai anig. Na si kapo lomon alava kana nat vo kavulik, parik kapa roron angkoai anig. ");
INSERT INTO lcm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Na man a si parik kapa sunguk kana ngakputuk na ka using iau, parik kapa roron angkoai anig. ");
INSERT INTO lcm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Si kapo teng akit si kana to, ka amun ia. Na si kapo amun kana to anig, ka sabonai ania. ");
INSERT INTO lcm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Si kapo ainak animi kapo ainak anig. Na si kapo ainak anig, kapo ainak ani vo asok ang anig. ");
INSERT INTO lcm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Si kapo songo alak na katakai i kus amalangas taun ia, using kapo katakai i kus amalangas, ka luk a seupok i kus amalangas, nang palau. Na si kapo songo alak na igenen korong taun ia using kapo igenen korong, ka luk a seupok i igenen korong, nang palau. ");
INSERT INTO lcm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Au sikei, si kapo alis ta men laman livus si mangsikei i vap mailik vopo using ke anig, napo antok atutuman imi ta parik kapa angkoai si ngaudap ani kana seupok.” ");
INSERT INTO lcm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","E mung i Iesu kala kamus ta atatai ani kana 12 na nat i akalit, kala pasal le iang ane nei kari keve rina asi kanan vil akalit na kan akuskus. ");
INSERT INTO lcm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Au na Ioanes kala longong le nei lu i akangbat na keve avibisan si igenen i akanangai ke, na kala asok kana keve nat i akalit ");
INSERT INTO lcm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","si an sui ania asukang ke, “Numai tutuman vang kana na igenen vo me serei ke, vo nganing namemla atu lomlomon ta mangsikei petekai?” ");
INSERT INTO lcm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Na Iesu kala antok iria ta, “Mi papok na mianla mengen amalangas a Ioanes ta sa mitala arai ania na mitala longong ia. ");
INSERT INTO lcm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ri mata ba, kilapo ararai pok. Ri soles, kilapo pasal korong. Ri tapak, kilapo rangrangis aongos, na ri talinga bot, kilapo longong korong. Riria kitala mat, kilapo tapasuk pok. Ri vap mailik, kilapo longong a akus ro. ");
INSERT INTO lcm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kapo tauia na igenen ang nang parik kapa savang marai ig.” ");
INSERT INTO lcm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Au, kila pasal suai na Iesu kalapo atatai a petau lava ang ta Ioanes. “Mita pasal ane ring varasai palau si kami an arai ani sa? Ani tavuang kapo lulu angpok si malu? ");
INSERT INTO lcm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Au, man parik, na marai sa mita pasal? Asi kami arai ani igenen maus ta maus ro luai? Parik. Vap ang kipo maus ta maus roron luai kipo ago nei keve lu lava si ri tulava. ");
INSERT INTO lcm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Au, man parik, na marai sa mita pasal? Asi kami an arai ani katakai i akus? Io, ninia vanang! Na kapo lakat ani katakai i kus amalangas. ");
INSERT INTO lcm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kana vang na igenen ke kita salik tatana asukang ke, Arai, naka asok kag asosokai aino anim. Ninia kan itoiton aino kam selen. ");
INSERT INTO lcm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Napo antok atutuman imi ta nei liuan i ri vap aongos i kuli rina kapo kovek ta mang anu katala tung alakat i Ioanes, katakai i asing tauia. Sikei lak, si kapo liklik luai nei vainagoan i metekuku, kapo lakat ania. ");
INSERT INTO lcm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Na le si taun i Ioanes katakai i asing tauia tung kana, vainagoan i metekuku kalapo bil asi angrudualai marai ina, na ri vap marala kipo buk ani ki visvis asi kari luk palau ania. ");
INSERT INTO lcm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Io, keve katakai i kus amalangas tung si Ioanes na keve mengen ang nei buk i saupai kitala mengen i kus amalangas. ");
INSERT INTO lcm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Na si man mipo usausa si ainak ania io, ninia kana vang na Elias, nia sime serei ang. ");
INSERT INTO lcm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Si kapo togon talinga, kapo ro ani ka longong. ");
INSERT INTO lcm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Naka altongai ani matan polpolokan i taun ke ta sa? Io, kipo asukang ta inatus lik nei ring ipo asesel na kipo sinong i songosongo ane si keve tungaria ta, ");
INSERT INTO lcm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Namemtala kuikui animi na parik milapa mika. Namemtala tangam akurkurai animi na parik milapa radaupa.’ ");
INSERT INTO lcm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Arai, Ioanes kata serei na parik kapa angan na inum, na kila antok ta kapo sangan ta ingua. ");
INSERT INTO lcm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Au na kana na igenen i pukun kamela serei na kalapo angan na inum, na kila antok, ‘Arai ta igenen ramit suke. Arai ta igenen buk inum alava suke. Arai ta igenen suke kapo angtunganan ve ri katakai i luk takis na ri katakai i bil arikek!’ Nang a laulauan kapo akalit ta masam kapo tutuman.” ");
INSERT INTO lcm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Au le na kalapo mengen amaiten ani keve rina ang kata abis a keve vilvil ataping miang singiria using parik kitapa lomon pokai. ");
INSERT INTO lcm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ka rikek animi, ri Korasin! Ka rikek animi, ri Betsaida! Using man nganing ri Turo ve ri Sidon kita arai ani keve abis i vilvil ataping ang mitala arai ania, kila lomon pokai lenginang na ki alakai ani maus i mamakus na ki mo nei vuta. ");
INSERT INTO lcm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sikei napo antok imi ta si taun i sausaupai ka pen roron lik ani ri Turo ve ri Sidon, sikei nami mi sikei a rikek luai an. ");
INSERT INTO lcm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Au na nami ri Kaparnaum, mipo buk vil alakat luai animi, ingko? Parik vang! Ki so asiang luai tatami ane si rina i mat. Man nganing a ri Sodoma kita arai ani keve abis i vilvil ataping ang mitala arai ania, oro kana kipo ago lak si taun ke. ");
INSERT INTO lcm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Arai, si taun i sausaupai ka pen roron lik ani ri Sodoma, sikei nami mi sikei a rikek luai an.” ");
INSERT INTO lcm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na si vuk taun ang Iesu kala antok, “Mamai numai a Volava i metekuku na kuli rina. Napo alatun ua using kutala amunai ani keve nem ke pelek ri katakai i masam na ri vap malangas, na kula amalangasai ania si mamain ta nat lik. ");
INSERT INTO lcm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tutuman mamai, using numai akorong kupo buk ia ani ka asukang. ");
INSERT INTO lcm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Mamai katala alis a keve bil aongos singig. Na kapo kovek ta sikei kapo uskorong kana nat, sikei tamana papalik. Na kapo kovek ta sikei kapo uskorong a tamana, sikei kana nat papalik kuvul ve ria kana nat kapo buk asi kana amalangasai aniria tatana. ");
INSERT INTO lcm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mi me ane singig, nami mipo mamal na mipo asalak alava. Mime, na mime luk a aus singig. ");
INSERT INTO lcm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mi sunguk kag kamung na mi luk akalit singig, using nau napo igenen ananap na parik napa vil alava iau. Mi sunguk ia na malanganto imi ka sabonai ani ausai. ");
INSERT INTO lcm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Using kag kamung kapo kalakala, na kag asasalakan parik kapa maiten.” ");
INSERT INTO lcm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Si taun ang Iesu katapo pasal aliu nei matang kon si taun i atailai. Na kana keve nat i akalit kila buk angan na kilapo rok a mang matan kon na kilapo angan ia. ");
INSERT INTO lcm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Na ri Parisaio kila arai ani oring ke na kila antok ia, “Arai ta kam keve nat i akalit sukana kilapo abis a lau kapo tav angkoai si abis ania si taun i atailai.” ");
INSERT INTO lcm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Na kala atai iria, “Au si parik lak kana mitapa tataot a akuskus i David na sa kata abis ia si taun katapo buk angan, ninia ve keve tungana? ");
INSERT INTO lcm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kata palak nei lu si God na kala angan a pok i asinong akipai ang voiang kapo tav angkoai ania si angan singina, na ani keve tungana kapa parik, sikei ri katakai i sula papalik. ");
INSERT INTO lcm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pua, parik mitapa tataot nei buk i saupai ta ri katakai i sula i nei rina i atailai? Using kipo uli putuk ani sausaupai i taun i atailai sikei lak parik kipa rikek singina. ");
INSERT INTO lcm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Napo antok imi ta kapo atogon a mangsikei kana kapo tavirimok ani rina i atailai. ");
INSERT INTO lcm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Si man mitala nas aro na supsupai i mengen ke, Napo buk a ngorem, parik ta alilis, parik nganing milapa angkoai si poso arikek ani vap po ro ke. ");
INSERT INTO lcm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Using a igenen i pukun kapo Volava i taun i atailai.” ");
INSERT INTO lcm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Au, kala papelek a ring ang na kanla palak nei kari lu i kivung, ");
INSERT INTO lcm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","na mangsikei a igenen kunga mat kapo ago. Na kilapo sui ia, “Au si kapo angkoai si vilvil ato si taun i atailai?” Using kitapo buk aoles ania. ");
INSERT INTO lcm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Na kala antok iria, “Si man a mang sikei imi kapo atogon kana sipsip na sipsip ke kala uak nei mata si taun i atailai sa, kula arai palau ania? Parik kunlapa tak alak suai ania? ");
INSERT INTO lcm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Sa kapo laba si to si igenen na si sipsip? Sukana kapo malangas ta kapo angkoai aro si pakangai si taun i atailai.” ");
INSERT INTO lcm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Le na kala antok a igenen ang ta, “Ku koros a kungam.” Na igenen ang kala koros ia na kala pukunan aro pok val kana mang palpal kunga. ");
INSERT INTO lcm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Sikei ri Parisaio kila soung na kian lapo gulegule selen ta ki saka raung an ania. ");
INSERT INTO lcm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Au, Iesu kapo malangas kari lomlomonai na kala papelek a rina ang. Na vap miang kipo using ia na kapo vil ato kari keve malepen aongos. ");
INSERT INTO lcm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Na kapo atakun iria si ago ta mengen amalangas an tatana, ");
INSERT INTO lcm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","asi vil apunuk ani sa na katakai i kus amalangas Esias katala posong ia, ");
INSERT INTO lcm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Arai, kana na kag asosokai natala songo ia. Napo buk ia na napo uruk ania. Naka alis ia ta Malanganto ig na ka mengen ta sausaupai korong si mamain ta palpal vap i ngising. ");
INSERT INTO lcm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Parik kapa anggegelai vo songosongo. Parik kipa angkoai si longong ani kalingana nei keve selen i rina. ");
INSERT INTO lcm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Parik kapa angkoai si ka putuk a bil kapo pepe. Na parik kapa angkoai si ka vil amat a kalupa vo buk mat. Tung si kana sausaupai korong na ka aging suai ani mamain ta kitmat. ");
INSERT INTO lcm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mamain ta palpal vap i ngising ki atung kari lomlomon si asan ina. ");
INSERT INTO lcm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Au, kimela serei singina ta mang igenen ingua katapo aol ia na kapo mataba na kapo tapo. Na kala vil ato na igenen ke asi kana arai na ka mengen korong. ");
INSERT INTO lcm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na ri vap aongos kilapo taping na kila antok, “Au, si kana? Nia na nat i David ingko?” ");
INSERT INTO lcm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Sikei ri Parisaio kila longong na kila antok ta, “Igenen ke kapo abis ta kitmat le si Belsebul nang a tulava si ri ingua asi lu suai ani ri ingua.” ");
INSERT INTO lcm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Na kala nas kari lomlomonai na kala antok iria, “Man a vap i nei vainagoan ki angvis pok, kanla tagoeng a matan vap ang. Vo man a saka rina an vo saka angtama an kila angvis pok, nginlak parik kipa angkoai si tung akit. ");
INSERT INTO lcm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Man a Satan kapo uli lu suai pok ani Satan, nang kapo vil atagalang pok ia. Au na kana vainagoan ka saka tung akit an? ");
INSERT INTO lcm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Man napo kirikai suai ani ri ingua ta kitmat i Belsebul, nei vanang? Kami keve nat kipo kun kirikai suai aniria ta kitmat i si? Arai, kami keve nat ki akalit pok imi ta kami kapau. ");
INSERT INTO lcm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sikei, using kana napo kirikai suai ani ri ingua ta kitmat i Malanganto i God, nang ninia vanang kapo akalit amalangas ta kana vainagoan a God kalapo serei singimi. ");
INSERT INTO lcm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kapo saka angkoai an si mangsikei ka palak nei lu si igenen dual na kan ainau kana keve bil, man parik kapa got tapai ani igenen dual ang? Le lak na kapo angkoai si ainau ani keve bil i nei kana lu. ");
INSERT INTO lcm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ninia parik kapa tung ve nau, nang palau kapo tu talang iau. Na ninia parik kapa sosongo aiton ve nau, nang palau kapo musa suai. ");
INSERT INTO lcm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Au, e iang vanang napo antok imi ta keve rikek na keve mengen i nau varas si ri vap, kapo angkoai si lomon suai ania. Sikei si nau varas ani Malanganto, parik luai kapa angkoai si lomon suai ania. ");
INSERT INTO lcm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Si kapo mengen arikek ani igenen i pukun kapo angkoai si lomon suai ani kana rikek, sikei nia kapo mengen arikek ani Malanganto Gogoai, parik luai kapa atogon lomon suai ani kana rikek. Kana na iles si taun ang e mung. ");
INSERT INTO lcm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ku sukal a ei roron na ka uaiai ani uai roron, vo ku sukal a ei rikek na ka uaiai ani uai rikek. Using a ei kipo kinle ia si uai ina. ");
INSERT INTO lcm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nami na keve natnat i kene. Mi saka mengen aro an man kami lau kapo rikek? Using a ngurumi kapo asoung asereiai ani bil ang na vingami kapo duk tatana. ");
INSERT INTO lcm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Igenen ro ka asoung asereiai ani roron le si tauia i kana keve roron, na igenen rikek ka asoung asereiai ani rikek le si tauia i kana keve bil rikek. ");
INSERT INTO lcm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Napo antok imi ta si taun i sausaupai siksikei a igenen kan mengen amalangas aongos ta kana keve mengen rikek i la mengen. ");
INSERT INTO lcm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Using si kam keve mengen nia vanang kan akala ua, vo kan sausaupai anim.” ");
INSERT INTO lcm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Au, na mang keve Parisaio ve ri vap malangas ani saupai kila antok ia, “Katakai i akalit, namempo buk arai anim si vil ani mang akanangai i vilvil ataping.” ");
INSERT INTO lcm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Na kala antok iria, “Vap rikek i taun ke, ki uli putuk ani kari angosongon ve God. Kana kipo buk arai ani akanangai, sikei napo tav ainak si alis ta mangsikei. Akanangai palau i Ionas, katakai i kus amalangas, kapo ro ki arai ania. ");
INSERT INTO lcm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Using Ionas kata ago nei vingana i ielava ani potol a mangias na potol a vong. Au na igenen i pukun kapa ka kun ago ani potol a mangias na potol a vong e nei vunep. ");
INSERT INTO lcm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ri vap i Nineve ki tapasuk ve matan polpolokan ke si taun i sausaupai iles, na kari lomon pokai si kana apasa na Ionas ka akalit amalangas pok na matan polpolokan i taun ke ta kari vinga kit. Sikei mi arai, igenen ke kana e matami kapo lavlabat ani Ionas. ");
INSERT INTO lcm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na ainan tulava i ring vunga ang ka kun tapasuk ve matan polpolokan i taun ke si taun i sausaupai iles. Na lau roron ang kata abis ia si taun i Solomon, ka akalit iria ta kari lau rikek. Using ninia kata pasal le ring vunga luai asi kana me kolongong ani masam si Solomon. Sikei mi arai, igenen ke kana e matami kapo lavlabat ani Solomon. ");
INSERT INTO lcm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Taun a ingua ka soung pelek a igenen, ka paliu si keve ring kapo kovek i laman na kanpo gule ring asi kanan ausai. Na man parik kapa sabonai korong ");
INSERT INTO lcm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kala antok, ‘Kapo ro naka papok ane si kag lu nata pasal pelek ia.’ Si vuk taun ang kamela serei, kala sabonai ta kapo vauvau na kitala gala ia na keve bil kipo sinong aro. ");
INSERT INTO lcm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Au, kala pasal na kanla songo le na mang limalengua na ingua voiang kipo rikek alava luai ania, na kimela riuklak na kila ago e iang. Na akamusai i tungtungan si igenen ke kala rikek luai ani aino. Ka asukang palau kapa si polpolokan rikek i taun ke.” ");
INSERT INTO lcm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Si taun ang katapo mengen lak a petau ang, rinana na keve tasina kime lapo tung e komo na kipo buk mengen ania. ");
INSERT INTO lcm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Na mangsikei kala antok ia, “Arai ta rinam ve keve tasim kipo angtung e komo na kipo buk mengen anim.” ");
INSERT INTO lcm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Na kala ngenget a vo mengen amalangas ang ta, “Si akorong kapo rina, na ri si akorong kipo keve tasig?” ");
INSERT INTO lcm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na kala so akalitai ane si kana keve nat i akalit na kala antok, “Kana vang a rina na keve tasig. ");
INSERT INTO lcm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Using man a si kapo usiusing kana vubuk a mamai e metekuku, nia vanang kapo tasig, kapo taug na kapo rina.” ");
INSERT INTO lcm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Si taun ang palau Iesu kala soung le nei lu na kan lapo sinong ngere lo. ");
INSERT INTO lcm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Na petau tavirimok kimela kirkirimai aulitai ania, asukang na kala kokos kuli vul na kan lapo sinong. Ri vap aongos kipo angtung lava e ngerelo. ");
INSERT INTO lcm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na kalapo mengen iria ta keve bil miang si kankanuai i mengen asukang ke, “Mangsikei a katakai i sukal kata sapungai ani kana keve katui i pok e matan. ");
INSERT INTO lcm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Na mang matan katui kanpo uak e selen na ri mani kimela angan ia. ");
INSERT INTO lcm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Na mang matan katui kianlapo uak si ring iatan, kapo tav angkoai roe, na using parik kapa atogon roe lava kala polok sumasuma, ");
INSERT INTO lcm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","na sinang kala ngan amak ia using kapo kovek i mis. ");
INSERT INTO lcm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Na mang matan katui kipo uak nei ring kakaulan na kanla polok alak ve nia na kala palun runguk ia. ");
INSERT INTO lcm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Na mang matan katui kipo uak nei roe roron, na kipo polok alak na kipo uai, mang matan kipo uai ta 30, na mang matan ta 60, na mang matan ta 100 alak ani keve katui i sukal ang. ");
INSERT INTO lcm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Man a si kapo atogon talinga, kapo ro ka longong!” ");
INSERT INTO lcm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Au, kana keve nat i akalit kimela serei singina na kila sui ia ta, “Marai sa na kupo mengen iria si kankanuai i mengen?” ");
INSERT INTO lcm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Na kala polpol iria asukang ke, “Malangas i keve bil mumun i vainagoan i metekuku, kakami asi atogon. Sikei riria, parik. ");
INSERT INTO lcm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Using man a si kapo atogon, ki ngaupap ia, na man a si kapo atogon men lik, io, men lik ang kapo atogon ia, ki luk suai vang ania. ");
INSERT INTO lcm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nang tukulai ina napo mengen iria si kankanuai i mengen. Using kantanem kipo gulegule, sikei ki tav sabonai, na ki kokolongong sikei ki tav nas na parik kipa malangas. ");
INSERT INTO lcm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Singiria kalapo punuk na mengen i kus amalangas ang ta Esias, Mi uli longong sikei lak mi tav malangas. Mi uli arai sikei lak mi tav tun kinle. ");
INSERT INTO lcm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Io, pakangat i vap ke kalapo tabat. Parik kilapa angkoai si longong ta talingaria. Kilapo apilum akit na mataria vei nganing kila arai korong na ki longong ta talingaria na ki malangas ta pakangat iria na kila sasakol na naka vil ato iria. ");
INSERT INTO lcm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Sikei, roron si matami using kapo arai korong na talingami using kapo longong. ");
INSERT INTO lcm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Napo antok atutuman imi vang kana ta mamain ta katakai i kus amalangas ve keve vap korong kitapo buk alava asi kari arai ani keve bil ke kana milapo arai ania na parik kita lapa arai ania. Na kitapo buk alava asi kari longong ani keve mengen ke kana milapo longong ia, na parik kita lapa longong ia. ");
INSERT INTO lcm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Au mi longong vang na supsupai i kankanuai i mengen ang. ");
INSERT INTO lcm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Man a mangsikei kapo longong a akus i vainagoan na parik kapa malangas ia, igenen rikek kapo serei na kapo ngai suai ani nem i sukal ang e vingana. Ninia vanang na katui i sukal ang nei selen. ");
INSERT INTO lcm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Au na katui i la uak si ring iatan, nang ninia kata luk a mengen na sumasuma kala uruk singina. ");
INSERT INTO lcm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sikei using kapo kovek i mis, kana to i lomlomon kapo kudik palau. Si man a maiten vo vilvil akui kala serei singina marai mengen ro ang, kala uak sumasuma palau. ");
INSERT INTO lcm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Na katui i la uak si ring kakaulan, nang ninia katala longong a mengen, sikei keve mamaiten i kuli rina ke na lomlomonai using ani tauia kala vil bat na mengen ro ang na kalapo kovek i uai. ");
INSERT INTO lcm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Au na katui i la uak nei roe roron ang, nang ninia kapo longong a mengen na kalapo malangas ia. Na kalapo aunai uai alaba asukang ta 100 na 60 na 30 alakat ani sa i sukal ang.” ");
INSERT INTO lcm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Au na kala mengen iria ta mang kankanuai i mengen. “Vainagoan i metekuku kapo asukang val igenen kata sukal kana keve katui roron nei kana matang. ");
INSERT INTO lcm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sikei, si taun ri vap aongos kilapo rodot, kana igenen ipo marala ania kala serei na kamela sukal le na keve uriuri rikek nei liuan i kana keve kon na kala pasal. ");
INSERT INTO lcm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Taun a keve kon ang kila kovkov na kila bokol alak, keve uriuri ang kila kun bokol. ");
INSERT INTO lcm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Au, keve asosokai si vo tauk i matang ang kimela serei na kila sui ia, ‘Volava, parik kutapa sukal katui ro papa nei matang suke? Marai sa na kalapo atogon uriuri nei matang ang?’ ");
INSERT INTO lcm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Na kala antok iria ta, ‘Mangsikei a igenen atogon marala singig kata abis na abis ang!’ Au na kila sui ia ta, ‘Au sa kupo buk ani namem an auk iria?’ ");
INSERT INTO lcm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Na kala antok ta, ‘Parik, ka ago tapai. Vei nganing si man mianla auk iria, mianla purut kuvul nganing iria ve keve kon ang. ");
INSERT INTO lcm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Lomon suai aniria kuvul ve keve kon ang na ki polok alak kuvul tung si taun sian dok. Na si taun ang naka antok a vap sian dok ang ta, mi auk suai aino tapai ani uriuri ang na mi pis kuvul iria asian ani. Au le vang na mi rok aiton na keve kon ang ane nei kag lu ipo asinong pok.’” ");
INSERT INTO lcm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Au, kala mengen iria ta mang kankanuai i mengen. “Vainagoan i metekuku kapo asukang ta katui i sinapeo mangsikei a igenen katan sukal ia. ");
INSERT INTO lcm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kantanem kapo katui lik luai i keve katui aongos, sikei man kala polok kala serei alava ani keve suksukalan aongos i nei matang na kala bil val ei akorong. Na ri mani i nei pangau kimela serei na kime lapo ting kuli keve ngakan ina.” ");
INSERT INTO lcm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Au, kala mengen iria ta mang kankanuai i mengen. “Vainagoan i metekuku kapo asukang ta yeast nang a aina kata luk ia na kala angvilai ania ve potol a pakut lava i palaua, na kala bakang tung si palaua aongos ang kala yeast an.” ");
INSERT INTO lcm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iesu kata mengen dong a petau lava aongos ang si kankanuai i mengen. Parik katapa mengen iria si mang selen. ");
INSERT INTO lcm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Asi vil apunuk ani mengen ang si katakai i kus amalangas ta, Naka mengen si kankanuai i mengen na nakan atangis a keve bil katapo mumun le si taun i asisinong. ");
INSERT INTO lcm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Au, kala papelek a petau ang na kanla palak nei lu. Na kana keve nat i akalit kimela serei singina na kila antok ia ta, “Ku mengen amalangas imem ta supsupai i mengen i uriuri nei matang.” ");
INSERT INTO lcm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Au, kala polpol iria asukang ke, “Vo sukal ang ani katui roron ang, nia na igenen i pukun. ");
INSERT INTO lcm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Matang ang, nia na kuli rina ke. Na keve katui roron ang, riria na vap i nei vainagoan. Na keve uriuri ang, riria na vap ang si igenen rikek. ");
INSERT INTO lcm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Au na igenen marala ang, voiang kata sukal iria, ninia na vo petau. Taun i dok, nia na akamusai i taun. Na keve vap sian dok, riria na mamain ta angelo. ");
INSERT INTO lcm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Na keve uriuri ang kian auk iria na kian ni, io ka asukang palau si akamusai i taun. ");
INSERT INTO lcm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Igenen i pukun ka asok kana keve angelo nei liuan i kana matan vap si kana vainagoan na kian auk suai aongos ani saka bil an kapo asereiai ani lau rikek na aniria kipo putuk saupai. ");
INSERT INTO lcm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kian asuai aniria nei kut karkarian luai na e iang kian aloi alaba velai ani ngut ngisa. ");
INSERT INTO lcm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Si taun ang a vap korong kian mang val makarap nei vainagoan ang si tamaria. Si kapo atogon talinga kapo ro ani ka longong. ");
INSERT INTO lcm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Vainagoan i metekuku kapo asukang val igenen kata sabonai ani bil atogon samui lava nei mangsikei a matang na kala amunai aro pok ania. Le na using kapo uruk alaba luai kanla atos suai ta kana togtogon aongos na kamela samui na matang ang. ");
INSERT INTO lcm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Vainagoan i metekuku kapo asukang kapa val mang igenen atos kata pasal si an gule iat samui lava. ");
INSERT INTO lcm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Taun kanla sabonai ani mang vuk iat kapo samui laba luai na kapo aunai roron, kala pasal pok na kanla atos suai ta kana togtogon aongos le na kanla samui na iat ang. ");
INSERT INTO lcm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Vainagoan i metekuku kapo asukang kapa val mang vap kita asiangai ani uvene laba ane nei laman na ri ien anglok kianla tuang singina. ");
INSERT INTO lcm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Taun kala duk kila tak alak ia ane ngerelo. Au kianla sinong i lukluk dong ani tepe ta ri ien ro na kipo asuai akipai ani ri ien rikek. ");
INSERT INTO lcm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ka asukang palau si akamusai i taun. Ri angelo ki serei na kime pagal na vap rikek le nei liuan i vap korong. ");
INSERT INTO lcm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Na ki asuai aniria ane nei kut karkarian lava na e iang kian aloi alaba velai ni ngut ngisa. ");
INSERT INTO lcm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Au, milapo malangas aongos na keve bil ke?” Na kila antok ia ta, “Io.” ");
INSERT INTO lcm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Na kala antok iria, “Asukang na keve vap malangas ani saupai man kilapo palak nei kuvkuvulan i vainagoan i metekuku, kipo asukang ta votauk i lu kapo akalit amalangas ta mamain ta togtogon miminaungan tanginang na kavang i nei kana ring ipo asinong.” ");
INSERT INTO lcm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Au, Iesu kala kamus si keve kankanuai i mengen suke na kala pasal aliu le iang. ");
INSERT INTO lcm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Na kamela serei si kana rina akorong na kalapo tutapong vil akalkalit nei kari lu i kivung. Na kilapo aunai taping na kila sui, “Au, ike lik kana kata luk na masam ve kitmat i vilvil ataping ke le voi akorong? ");
INSERT INTO lcm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Parik kana na nat ke si katakai i abis lu ke? Parik kana ta rinana ta ri Maria? Na keve tasina ta ri Iakovo, Iosep, Simon na Iudas? ");
INSERT INTO lcm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na parik ta keve tauna kana kipo ago ve tara? Nei vanang? Ike lik kata luk na keve bil ke le voi?” ");
INSERT INTO lcm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Na kilapo savang singina. Sikei kala antok iria ta, “Katakai i kus amalangas, vei kavpo atogon asan si mang keve rina, sikei si kana rina akorong, na mete kana lu, parik.” ");
INSERT INTO lcm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na parik katapa abis vilvil ataping duk e iang using kitapo tav lomlomon. ");
INSERT INTO lcm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Si taun ang a tulava Erodes kala longong ta Iesu kalapo atogon asan lava. ");
INSERT INTO lcm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na kala antok kana keve asosokai ta, “Ninia palau nang a Ioanes katakai i asing tauia ke nang katala to pok. Tukulai ina na kapo atogon a kitmat asukang asi vil ani keve nem ke.” ");
INSERT INTO lcm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Using Erodes katala asok asi teng akit ani Ioanes na ki got ia na kianla alakai ania nei lu i akangbat. Tukulai ina si Erodias, kisngana i tasina Pilipo. ");
INSERT INTO lcm_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Using Ioanes katapo uli mengen ania ta, “Parik kapa korong ta ku osongon ia.” ");
INSERT INTO lcm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Asukang na katapo uli buk raung suai ania, sikei parik katapa vil korong ia using katapo leng ani ri vap, using kitapo mengen ta kapo mangsikei a katakai i kus amalangas. ");
INSERT INTO lcm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Au, mangsikei a taun Erodes kala vil matan angan asi nanauai ani taun i kari ingus ania. Na si taun i matan angan ang kana kavulik a Erodias kalapo mikamika. Na Erodes kalapo mangal alava luai ani kavulik ke sipo mikamika ang ");
INSERT INTO lcm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","na kala antok ia ta ka alis ia ta saka nem an kapo buk ia. Na kapo aunai atuvala ta kapo tutuman kana mengen. ");
INSERT INTO lcm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Au, rinana kala antok sumasuma ia, na kamela kin ta, “Ku alis iau kana ta vangang ina i Ioanes, katakai i asing tauia nei gapai.” ");
INSERT INTO lcm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Na tulava kala mamakus. Sikei using katala atuvala tatana, na keve vap lava kipo sinong, asukang na kala ali mengen ani ki abis ia. ");
INSERT INTO lcm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Au kianla lam rongok a ngona i Ioanes nei lu i akangbat. ");
INSERT INTO lcm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na kila asiang a vangang ina nei gapai na kimela alis a kavulik ang tatana na kanla alis ia si rinana. ");
INSERT INTO lcm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Na e mung kana keve nat i akalit kimela sunguk suai ani pukun ina na kianla kepai ania, le na kianla mengen amalangas a Iesu. ");
INSERT INTO lcm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Taun a Iesu kala longong na sa katala serei, kala kokos papalik kuli vul ane si mang vuk rina vauvau. Na ri vap kila longong asukang ke na kila using ia e selen palau, le nei keve rina. ");
INSERT INTO lcm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Na kanlapo ung sabonai ani vap duk, na kalapo ngorem iria, na kala vil ato kari keve vap malepen. ");
INSERT INTO lcm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na kalapo ngelik na keve nat i akalit kimela serei singina na kila antok ia ta, “Ring ke kapo vauvau na kalapo vong. Ku asok suai ani petau ke ane nei keve rina na kian samui pok aniria.” ");
INSERT INTO lcm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Na Iesu kala antok iria, “Parik kapa maiten ani ki pasal suai. Nami akorong mi li pok iria.” ");
INSERT INTO lcm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na kila antok ia ta, “Namempo atogon palau kana na palpalima na saui na pongua na ien.” ");
INSERT INTO lcm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Na kala antok ta, “Luk iria ane ke ane singig.” ");
INSERT INTO lcm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na kala luk a palpalima na saui ang na pongua na ien na kala tarak ane metekuku, na kala posong aro ia, le na kala tevetevek a saui ang dong a keve nat ang, na keve nat ang kila lilis aliu ani petau ang tatana. ");
INSERT INTO lcm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na riria aongos kila angan na kila masung aro. Na kila lukluk akuvul a keve inongos i pok na kila asiang aduk a 12 na tepe lava tatana. ");
INSERT INTO lcm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Na vap tauan ang kita angan, tataot iria katapo 5,000 aongos, sikei parik kapa taot na ri aina ve ri nat lik. ");
INSERT INTO lcm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Au na kala asok kana keve nat i akalit ta ki kokos aputuk aino, na nia asi kana asok suai tapai ani petau ang. ");
INSERT INTO lcm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","E mung palau i kana la asok suai ani petau ang kala palak papalik ane si mang mulang si kanan sokotuk. Kalapo tenei vong na ninia papalik kalapo ago. ");
INSERT INTO lcm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Sikei a vul ang lenginang kata lapo voko avunga ni ring kolo na kapo suang to using a vuk malu kapo tu talang ia. ");
INSERT INTO lcm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Si tapading i tangat i tenei vong ang kala pataun iria na kapo pasal aliu kuli laman. ");
INSERT INTO lcm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Si taun kila arai ania sipo pasal kuli laman na kila antok ta, “Ingua kana!” Na kilapo kup velai ni leng. ");
INSERT INTO lcm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sikei akorong palau Iesu kala antok iria, “Akos. Nau palau kana. Mi ago ta leng an.” Au, Petero kala antok ia, ");
INSERT INTO lcm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","“Si man numai palau a Volava, asok iau ani naka pasal taun ua kuli laman.” ");
INSERT INTO lcm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Na kala antok ia, “Me ane ke.” Na Petero kala siang suai le kuli vul na kalapo pasal aliu kuli laman taun a Iesu. ");
INSERT INTO lcm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sikei taun kalapo arai ani vuk malu kalapo leng na kalapo tutapongai lum asiang. Na kalapo songosongo, “Volava, teng ato iau!” ");
INSERT INTO lcm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nang palau Iesu kala sulai ani kungana taun ia na kanla sel ia na kala antok ia, “Numai kupo atogon a lomlomon kudik. Marai sa kupo ilung?” ");
INSERT INTO lcm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Au, kilongla kos lak kuli vul na malu ang kala kamus. ");
INSERT INTO lcm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Na vap vopo gon kuli vul ang kilapo soturungai singina na kipo mengen ta, “Tutuman luai, numai a nat i God.” ");
INSERT INTO lcm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Au, kila paputuk luai ane mang palpal na kianla ung alak e Genesaret. ");
INSERT INTO lcm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Au na ri vap i ring ang kila kinle ia na kila alis mengen pulakai ane si keve vuk oring e komo i rina ang. Na ri vap kime lapo serei ta kari keve mamain ta malepen aongos. ");
INSERT INTO lcm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Na kila sokotuk ia asi kana ainak ani ki sigil na ngising palau i kana maus. Au na taun ang kian lapo sigil ia, ria aongos kilapo to. ");
INSERT INTO lcm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Na mang keve Parisaio ve vap malangas ani saupai kimela serei si Iesu le Ierusalem na kimela sui ia ta, ");
INSERT INTO lcm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Marai sa na kam keve nat i akalit kipo putuk a sausaupai si ri vap lava? Parik kipa galui aro le na kungaria le ani ki angan.” ");
INSERT INTO lcm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Na Iesu kala antok iria ta, “Na marai sa mipo putuk kana asok tapai a God using mipo buk usiusing aro ani kami keve sausaupai? ");
INSERT INTO lcm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Arai, God kata antok ta, Ku mamaila ani tamam ve rinam na si kapo mengen arikek ani tamana ve rinana, nia asi mat. ");
INSERT INTO lcm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sikei nami mipo antok ta man a si kapo antok a tamana ve rinana ta kana keve bil asi pakangai aniria katala alis ia ane si God, ");
INSERT INTO lcm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","parik kapa anguan mamaiten ania asi kana mamaila ani tamana ve rinana. Sukana, asi kami teng akit si kami keve sausaupai, milapo lomon apalau na mengen si God. ");
INSERT INTO lcm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nami na vap kapau. Esias kata atutuman tatami si taun ang kata mengen ta, ");
INSERT INTO lcm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Vap ke kipo mamaila anig ta ngururia palau, sikei nei pakangat iria kipo ago avunga luai anig. ");
INSERT INTO lcm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kipo soturungai kapau palau singig. Na kipo mengen alava ta kari keve lomlomonai palau asukang val kapo akalkalit tutuman.” ");
INSERT INTO lcm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Na Iesu kala songo na petau ang na kala antok iria ta, “Mi longong na mi longong kinle na supsupai i mengen ke. ");
INSERT INTO lcm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sa kapo palak si nguruna i igenen parik kapa vil avisuk ia. Sikei a sa kapo soung e nguruna, nambang kapo akalit ta kana visuk.” ");
INSERT INTO lcm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Au na kana keve nat kimela serei singina na kila sui ia ta, “Au si kutapo malangas kana na ri Parisaio sipo vinga rikek si taun ang kitapo longong na mengen ke?” ");
INSERT INTO lcm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Na kala polpol iria asukang ke, “Keve ei ang voiang a mamai e metekuku parik katapa sukal iria, ka auk suai aniria kuvul ve mis iria. ");
INSERT INTO lcm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ago aniria. Kipo mata ba na kipo tu ainoai ani mang vap. Man a igenen mata ba kapo ainoai ani mang ba, rilong aongos kilong anla siang nei lulung.” ");
INSERT INTO lcm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Na Petero kala antok, “Ku palas na kankanuai i mengen ke singimem.” ");
INSERT INTO lcm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Na kala sui iria, “Au si parik lak kana mipa nas? ");
INSERT INTO lcm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Parik mipa arai ta sa kapo palak e ngur, ka ane nei vinga le na kanlapo soung suai pok? ");
INSERT INTO lcm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sikei keve bil kipo soung le nei ngur kipo pasal le nei vinga nambang kipo akalit amalangas ta igenen kapo visuk. ");
INSERT INTO lcm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Using le nei vinga, keve lomlomonai rikek ki serei. Daung, putuk osongon, panik, tainau, mengen kapau mete saupai, mengen arikek ani mang anu. ");
INSERT INTO lcm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kana vang a keve bil ke kipo vil avisuk a igenen. Sikei si angan ta kunga i tav galui aro aino, parik kapa vil avisuk a igenen.” ");
INSERT INTO lcm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Na Iesu kala papelek suai ani rina ang na kala pasal ane palpal i Turo na Sidon. ");
INSERT INTO lcm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na mangsikei a aina le iang, katapo aina i Kanan, kamela serei singina na kame lapo tangis ia, “Ku ngorem iau Volava, numai a nat i David. Kag kavulik kapo sangan ta ingua na kapo meng alava luai ania.” ");
INSERT INTO lcm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sikei Iesu parik kapa ngenget ia ta mang sikei a vuk mengen. Asukang na kana keve nat i akalit kimela serei singina na kila antok ia ta, “Ku asok suai ania using kapo uli buk tang using lak anira.” ");
INSERT INTO lcm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Na kala polpol asukang ke, “Kita asok iau taun a keve sipsip lapo mun ang i Israel papalik.” ");
INSERT INTO lcm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Na aina ke kamela serei na kamela soturungai e matana i Iesu na kala antok, “Volava, ku pakangai anig!” ");
INSERT INTO lcm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Na Iesu kala antok ia, “Parik kapa ro asi luk ani pok si ri nat lik na apus ani kauvek tatana.” ");
INSERT INTO lcm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na kala antok, “Kapo ro volava, sikei apok ri kauvek kipo nas ani angan ani nunulik i pok nang kapo uak le si pata i po angan si vo taukuna.” ");
INSERT INTO lcm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Na Iesu kala antok ia, “Iuang, kupo atogon a lomlomon tavirimok luai. Kam vubuk lenginang kala punuk.” Na si vuk taun ang palau kana kavulik kala ro pok. ");
INSERT INTO lcm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Au, Iesu kala papelek na rina ang na kanlapo pasal aliu ngerelo i laman tatapulitai ang e Galilaia. Na kala palak taun a mang mulang na kanlapo sinong. ");
INSERT INTO lcm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Au na petau tavirimok kimela serei singina ta kari keve malepen, ri soles, na ri vap pukun dokot, ri mata ba, na ri tapo na mang matan malepen miang kapa. Kimela serei aongos tataria singina na kamela vil ato iria. ");
INSERT INTO lcm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Na ri vap kilapo taping ani ri tapo kilapo mengen na ri vap po pukun dokot ang kilapo ro pok na ri soles kilapo pasal korong na ri mata ba kilapo kun arai korong. Au na kilapo alatun a God si ri Israel. ");
INSERT INTO lcm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Na Iesu kala songo kana keve nat i akalit ane singina na kala antok iria, “Napo ngorem a petau ke, using lenginang kitala ago na potol a taun ve nau na kalapo kovek i pok. Napo misag ani asok suai aniria si taun kipo buk angan vei nganing kianla ngau alava e selen.” ");
INSERT INTO lcm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na kana keve nat kila antok ta, “Tara saka gule pok angkoai an asi kara alis ani petau lava asukang ke? Using a ring ke kapo ago avunga i mangsikei a rina.” ");
INSERT INTO lcm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Na Iesu kala sui iria, “Poisan a saui nang mipo atogon ia?” Na kila antok ta, “Limalengua na saui na rukun ien lik.” ");
INSERT INTO lcm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Au na kala asok a petau ang asi kari sinong aongos e vunep. ");
INSERT INTO lcm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na kala luk a limalengua na saui kuvul ve rukun ien ang na kala posong ro, na kala tevek ia na kalapo alis ia si kana keve nat i akalit na kipo lis ia si ri vap. ");
INSERT INTO lcm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Riria aongos kita angan na kila masung. Au na kila lukluk akuvul na keve inongos i pok ang na kala serei asukang ta limalengua na tepe duk. ");
INSERT INTO lcm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tataot i ri tauan papalik kita angan kata serei asukang ta 4,000 aongos. Sikei parik kapa taot na ri aina ve ri natlik. ");
INSERT INTO lcm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Au e mung i kana la asok tapai ani petau ang kala kokos kuli vul na kala pasal ane palpal Magadan. ");
INSERT INTO lcm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Na ri Parisaio ve ri Sadukaio kimela serei si Iesu asi kari atokngai ania na kila antok ia asi kana akalit aniria ta mangsikei a akanangai le metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Na kala polpol iria ta, “Si man na nei pangau kapo melek tenei ngelik milapo antok ta ka taun ro. ");
INSERT INTO lcm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Na si man kapo melek tenei vauk na kapo duk i kuku milapo antok ta taun ke ka taun daian. Mipo nas aro na keve angpetpetekai i ararai i nei pangau, sikei parik mipa angkoai si tun kinle ani keve akanangai i taun ke. ");
INSERT INTO lcm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Matan vap rikek uli putuk ani kari angosongon ve God kipo uli gule using ani akanangai, sikei parik luai napa ainak si alis ta sikei. Akanangai palau i Ionas, kapo ro ki arai ania.” Au le na Iesu kala pasal suai aniria. ");
INSERT INTO lcm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na ri nat i akalit kimela kun serei e mang palpal, sikei kitala lomon taun ani luk saui le. ");
INSERT INTO lcm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na Iesu kala antok iria, “Mi arai aro, na mi aiveven imi pelek a yeast si ri Parisaio ve ri Sadukaio.” ");
INSERT INTO lcm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Na kilapo angmemengenai musik ta, “Parik tarata lapa luk saui le.” ");
INSERT INTO lcm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iesu kalapo nas ia na kala antok, “Keve vap atogon lomlomon kudik, marai sa mipo angmemengenai musik ta kovek i saui? ");
INSERT INTO lcm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Parik lak mipa malangas? Parik mipa lomlomonai ani palpalima na saui ang ani 5,000 vap aongos ang na poisan na tepe duk i inongos ina mita luk akuvul ia, ingko? ");
INSERT INTO lcm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Vo limalengua na saui ani 4,000 vap aongos ang na poisan na tepe duk i inongos ina? ");
INSERT INTO lcm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kapo saka bil an na mipo tav malangas ta parik natapa mengen imi ta saui? Sikei mi aiveven imi pelek a yeast si ri Parisaio ve ri Sadukaio.” ");
INSERT INTO lcm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Au na kila malangas ta parik katapa mengen ta yeast i nei saui, sikei katapo mengen si aiveven akit si kari keve akalkalit. ");
INSERT INTO lcm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Au na Iesu kanla serei si palpal Kaisareia Pilipi na kala sui kana keve nat ta, “Ri vap kipo kin a igenen i pukun ta nia na si?” ");
INSERT INTO lcm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Na kila antok, “Mang matan kipo kin ta Ioanes katakai i asing tauia. Na mang matan ta Elias, na mang matan ta Ieremias vo mangsikei iria mamain ta katakai i kus amalangas.” ");
INSERT INTO lcm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Na kala sui iria, “Au na nami, mipo kin iau ta nau a si?” ");
INSERT INTO lcm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Na Simon Petero kala ngenget ta, “Numai a igenen i akanangai. Numai a nat i God vopo to ang.” ");
INSERT INTO lcm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Na Iesu kala antok ta, “Uruk kakam, Simon Bariona, using parik ta ri vap kita mengen amalangas ua tatana, sikei mamai e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Na napo antok kapa ua Petero ta numai a at. Na lakat kuli at ke naka atung kag matan vap. Na kitmat i mat, kapo kovek i dual angkoai si ruduai aniria. ");
INSERT INTO lcm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Naka alis ua ta keve ki i keve takaman i nei vainagoan i metekuku. Sa ku pis akit ia e ke e vunep, ki kun pis akit ania e metekuku. Na sa ku luang ia e ke e vunep, ki kun luang ania e metekuku.” ");
INSERT INTO lcm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Na kala atakun akit a keve nat ang asi kari ago ta mengen an ani mangsikei ta nia na igenen i akanangai. ");
INSERT INTO lcm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na le si taun ang, Iesu kalapo uli atai amalangas ani kana keve nat i akalit ta kapo mamaiten ani ka pasal ane Ierusalem na kan sunguk a keve vilvil akui miang e kungaria i ri vap lava, na keve ainoinoai si ri katakai i sula ve ri vap malangas ani saupai, na ki raung ia na si vapotol i taun ka tadut pok. ");
INSERT INTO lcm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Na Petero kala songo ia ane ngising na kanlapo tatapokai ania ta, “Parik luai, Volava! Parik kapa angkoai luai ta bil ke ka serei singim.” ");
INSERT INTO lcm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Na kala taval na kala antok a Petero ta, “Pasal e mung ig, Satan! Numai a at asi asavang anig, using parik kupa auai ve lomlomonai si God, sikei kupo auai ve lomlomonai si ri vap.” ");
INSERT INTO lcm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Au le na Iesu kala antok kana keve nat ta, “Man a mangsikei kapo buk usiusing anig, ka uli auak suai ani lomlomonai ania pok, na ka asalak kana ngakputuk na ka usiusing iau. ");
INSERT INTO lcm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Using nia kapo buk aiveven aroron ani kana to, ka amun ia. Sikei nia kapo amun kana to anig ka teng ia. ");
INSERT INTO lcm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Using man a igenen ka atogon a keve bil aongos kuli rina na ka mat, keve bil ang ki saka pakangai ania? Tara samui pok kara to ta sa? ");
INSERT INTO lcm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Using a igenen i pukun ka serei pok kuvul ve kana keve angelo ta miminaungan i tamana, na kame ali seupok ani siksikei a igenen angkokoai si sa katala abis ia.” ");
INSERT INTO lcm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na kala antok iria, “Napo mengen atutuman luai animi ta mang matan kana kipo tung e ke, parik kipa mat tung si ki arai ani igenen i pukun kame serei val tulava i kana vainagoan.” ");
INSERT INTO lcm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na kala liu tapai a limalesikei a taun na Iesu kala songo le na ri Petero ve ngono angtasimal ke ri Iakovo ve Ioanes, ritol papalik, na kala ainoai alak aniritol ane si mangsikei a put lakat. ");
INSERT INTO lcm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Na kanla sakol e mataritol. Nona kala mang val makarap na kana maus kala posok aongos. ");
INSERT INTO lcm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na akorong palau ri Moses ve Elias kilongla tu aserei e mataritol na kilongan lapo angmemengenai ve nia. ");
INSERT INTO lcm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Na Petero kala antok a Iesu ta, “Volava, kapo ro anira sime ago e ke. Si man kupo buk, naka atung ta potol a ralai, ta sikei anim, na mangsikei ani Moses na ta mang anu ani Elias.” ");
INSERT INTO lcm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Si taun ang kapo mengen lak, mangsikei a kuku malangas kamela apung aongos iria na kalinga kala mengen nei kuku, “Kana kag nat ro, napo buk alava ia, na napo uruk alava ania. Mi longong ia.” ");
INSERT INTO lcm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Taun a volo nat ke kitol la longong na kalinga ke, kitol la soturungai ane vunep velai ani leng lava. ");
INSERT INTO lcm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sikei Iesu kala pataun iritol na kanla sigil iritol na kala antok, “Mitol tadut na mitol ago ta leng an.” ");
INSERT INTO lcm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Taun kitol la ararai, kitol la tav arai ani mang si, Iesu papalik. ");
INSERT INTO lcm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Au na taun kitolapo kik siang pok le kuli put ang, Iesu kala atakun iritol ta, “Mitol ago ta antok an ani mangsikei ta sa mitol tala arai ania, tung si igenen i pukun kala tadut pelek a mat.” ");
INSERT INTO lcm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Na volo nat i akalit kito la sui ia ta, “Au man asukang, marai sa na ri vap malangas ani saupai kipo antok ta Elias ka serei aino tapai?” ");
INSERT INTO lcm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Na kala antok ta, “E, Elias ka serei lak na ka vil aro pok na keve bil aongos. ");
INSERT INTO lcm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Sikei napo antok imitol ta lenginang a Elias katala serei na parik kitapa kinle ia na kila vil na keve bil aongos singina using kari vubuk, na asukang kapa na igenen i pukun ka kui e kungaria.” ");
INSERT INTO lcm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Au na volo nat ang kitol la malangas ta katapo mengen iria ta Ioanes katakai i asing tauia. ");
INSERT INTO lcm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Si taun ang kimela serei si petau ang, mang igenen kamela serei singina na kala so vusulai e matana na kala antok ta, ");
INSERT INTO lcm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Volava, ku ngorem kag nat, using kapo go na kapo vis alava luai ania. Kapo uli uak nei kut ni vo nei laman. ");
INSERT INTO lcm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Natala serei tatana si kam keve nat i akalit, sikei parik kita lapa angkoai si vil ato ania.” ");
INSERT INTO lcm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Au, Iesu kala antok ta, “Nami na matan polpolokan tav lomlomon na milapo pataliung na selen korong. Poisan lak a taun si kag ago ve nami? Poisan lak a taun si kag telan tatami? Sunguk ia ane singig!” ");
INSERT INTO lcm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na Iesu kala kirikai ani ingua ang na kala soung suai. Si vuk taun ang palau na nat ang kala teng a to. ");
INSERT INTO lcm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Au, e mung keve nat i akalit kimela serei papalik si Iesu na kimela sui ia, “Sa tukulai ina na parik namemtapa angkoai si lu suai ania?” ");
INSERT INTO lcm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Na kala antok iria ta, “Using mipo atogon a lomlomon kudik luai. Arai, napo antok atutuman imi ta man kami lomlomon kapo liklik palau val katui i sinapeo, mila angkoai si mengen taun ani put ke ta ‘Ku tapasuk le ke ane suke’ na ka tapasuk. Ka kovek i bil ka kitmat animi.” ");
INSERT INTO lcm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Si taun ang kime lapo ago kuvul e Galilaia, Iesu kala antok iria, “Igenen i pukun ki alis lak ia e kungaria i ri vap. ");
INSERT INTO lcm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kian raung ia na si vapotol i taun ka tadut pok.” Na kilapo mamakus alava luai. ");
INSERT INTO lcm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Au, kila pasal na kianla serei e Kaparnaum na ri vap po luk takis i nei rina i atailai kimela serei si Petero na kila sui ia, “Au si kami katakai i akalit kapo kun samui ani takis ang kapa?” ");
INSERT INTO lcm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Na kala antok ta, “E.” Au, kanla palak ane nei lu na Iesu kala ainoai i igenen asi mengen na kala sui ia, “Simon, kupo atogon a saka nanasai an? Ri tulava i kuli rina kipo nas ani luk ani kari takis le si si, le si kari keve nat akorong, vo le si mang matan petekai?” ");
INSERT INTO lcm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Na Petero kala ngenget ta, “Le si mang matan petekai.” Au na Iesu kala antok ia, “Asukang na inatus kipo kalakala si maiten ke. ");
INSERT INTO lcm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sikei, vei tara tav mamaila aro aniria, ku pasiang ane ngerelo na kuanla ngaungaul. Na si ainoai i ien man kutala tak, ku pagang a nguruna na ku sabonai ani sikei a vuk kapkap. Ku luk le ia na kuan alis iria anirung aongos.” ");
INSERT INTO lcm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Si taun ang kana keve nat i akalit kimela serei singina na kimela sui ia, “Si nang kapo atogon asan nei vainagoan i metekuku?” ");
INSERT INTO lcm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Au, kala songo na mang nat lik na kala atung ia nei liuan iria ");
INSERT INTO lcm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","na kala antok, “Napo antok atutuman imi. Si man parik mipa sasakol na mi bil val ri nat lik, parik mipa angkoai si palak nei vainagoan i metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Asukang na si kapo vil alik ia val nat lik ke, nia vanang kapo atogon asan nei vainagoan i metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Na si kapo uruk suak ani sikei a nat lik asukang ke si asan ig, e iang kapo uruk suak anig. ");
INSERT INTO lcm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Sikei man a si ka asavang a sikei i keve nat lik ke voiang kapo lomlomon tatag, kapo ro ki pala a iat maiten e ngona na kian alum asiang ia ane kevkev luai i laman. ");
INSERT INTO lcm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Pua ta kuli rina ke using a keve iat asi asavang kak! Using a keve bil asi tukai parik kapa angkoai ta ki tav serei. Ki serei, sikei ani iuang kapo asinong ia, ka rikek luai ania. ");
INSERT INTO lcm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Si man a kungam vo kakim kata vil ua asi kam savang, lamut suai ania na ku asuai akipai ania. Kapo ro anim si palak taun ani to ta kovek i kunga vo ta kovek i kak vei atogon ani pongua na kunga na kak na kianla asuai anim nei kut ipo ni asikei ang. ");
INSERT INTO lcm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Na si man a matam kata vil ua asi kam savang, ruvel suai ania na ku asuai akipai ania. Kapo ro anim si palak taun ani to ta mata sikopal vei atogon ani pongua na mata na kianla asuai anim nei kut lava i saupai. ");
INSERT INTO lcm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Arai aro ta mi ago ta tun alik ani mangsikei i keve vap lik ke. Using napo antok imi ta kari keve angelo e metekuku kipo uli arai ani nona i mamai e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Mipo lomon ia ta sa? Si man a igenen kapo atogon kana 100 na sipsip na mangsikei iria kala mun e iang pulakai, kupo lomon ia ta parik kapa pataliung na 99 ang e kuli put asi an gule ani sikei vo lapo mun ang? ");
INSERT INTO lcm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na si man kan sabonai ania, napo antok atutuman imi ta kapo aunai maramarak ani sikei palau vo lapo mun ang ani mang matan vap po tav mun ang. ");
INSERT INTO lcm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Asukang palau, tamami e metekuku parik kapa ainak ta mangsikei i keve vap lik ke ka puka. ");
INSERT INTO lcm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Si man a tungam katala vil arikek ua, pasal na kuan akalit ia ta kana rikek, sikei ku vil ia singimilong papalik. Si man kala longong ua kutala luk korong pok na tungam. ");
INSERT INTO lcm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sikei si man parik kapa longong ua, luk pok le ta sikei vo ta pongua na igenen ani keve mengen aongos ka pasal si mengen korong si pongua vo potol a igenen. ");
INSERT INTO lcm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Si man parik kapa buk longong anirilong, antok a petau aongos. Si man parik kapa buk longong kapa aniria, au kula taot ia asukang ta kapo bil val igenen i ngising vo katakai i luk takis. ");
INSERT INTO lcm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Napo antok atutuman imi ta sa mipo pis ia e ke e vunep, ki kun pis ania e metekuku. Na sa mipo luang ia e ke e vunep, ki kun luang ania e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Napo anguan antok an animi ta si man a pongua imi kilongpo ainak ani sa e ke e vunep kilongpo sokotuk ia, mamai e metekuku ka vil akorong ia anirilong. ");
INSERT INTO lcm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Using si man a pongua vo potol kitolpo sinong kuvul si asan ig, nau kapa e nei liuan iritol.” ");
INSERT INTO lcm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Au na Petero kamela serei singina na kala sui ia, “Volava, naka amatan poisan a lomon suai ani keve rikek ang si tungag singig? Amatan limalengua?” ");
INSERT INTO lcm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Na Iesu kala antok ia ta, “Napo antok ua, parik ta limalengua na taun. Sikei limalengua na sangauli na limalengua na taun aongos. ");
INSERT INTO lcm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Asukang na vainagoan i metekuku kapo asukang ta tulava katapo buk vil akorong ani keve kope ve kana keve asosokai. ");
INSERT INTO lcm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Si taun ang kapo vilvil akorong kila songo na mang asosokai katapo atogon kana kope tavirimok luai na kame lapo tung e nona. ");
INSERT INTO lcm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Sikei, using parik katapa angkoai si samui sip ania, kana tulava kala asok ta ninia ve kana aina na karilong inatus na karilong togtogon ki atos aongos tataria asi samui suai ani kana kope. ");
INSERT INTO lcm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Au, asosokai ang kala uak na kala matung turung e ngono kakina na kala sokotuk, ‘Ku kokoai aro tapai anig na naka samui suai aongos ani kag kope.’ ");
INSERT INTO lcm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Na pakangat ina i tulava ang kala tameng taun ia na kala lomon suai ani kana kope na kala atolongon ia. ");
INSERT INTO lcm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Sikei, asosokai ke kala soung na kanla sabonai ani mangsikei pok a asosokai val nia, voiang katapo atogon kope singina asukang ta rukun kapkap lik palau. Ka serei na kala tak ia e ngona na kalapo buk ngau punuk ania na kalapo antok ia ta, ‘Ku samui sumasuma luai ani kam kope.’ ");
INSERT INTO lcm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Na tungana kala uak e matana na kala sokotuk, ‘Ku kokoai aro tapai anig na naka samui kag kope.’ ");
INSERT INTO lcm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sikei kala bot na kanla alakai ania e nei lu i akangbat tung si ka samui kana kope. ");
INSERT INTO lcm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Au, mang keve asosokai kila arai ani lau suke na kilapo vinga maiten na kila pasal na kianla antok na tulava ta sa katala serei. ");
INSERT INTO lcm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Au, tulava kala songo na asosokai ang na kanla antok ia, ‘Numai a asosokai visuk. Nata lomon suai aongos ani kam kope using kuta sokotuk iau. ");
INSERT INTO lcm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Au na parik kutapa buk ngorem ani tungam vo kun asosokai suke, val nata kun ngorem anim?’ ");
INSERT INTO lcm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Na kala marala alava na kala asok a vap po vil amiming ang ta ki amiming ia tung si kala samui aongos kana kope. ");
INSERT INTO lcm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Mamai e metekuku ka kun vil ania asukang si siksikei imi man parik kapa lomon suai aro luai ani rikek si tungana.” ");
INSERT INTO lcm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Taun a Iesu kala kamus ta mengen ta keve bil ke kala papelek a Galilaia na kala pasal ane si palpal Iudaia si mang palpal i Iordanes. ");
INSERT INTO lcm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Na petau lava kipo using ia na kan lapo vil ato iria e iang. ");
INSERT INTO lcm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Na mang keve Parisaio kimela serei singina si kari me atoktokngai ania. Na kila sui ia ta, “Au si kara saupai kana kapo ainak ani tauan si kamus si kana aina si saka keve tukulai an?” ");
INSERT INTO lcm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Na kala ngenget iria asukang ke, “Sa, parik mitapa tataot ta vo asisinong ang kata asinong iria tauan na aina?” ");
INSERT INTO lcm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Na kala antok ta, “Nang tukulai ina na tauan ka papelek a tamana ve rinana na kame ago kuvul ve kana aina, na kilongla sikei palau a pukun. ");
INSERT INTO lcm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Sukana vang, parik kilonglapa anguan pongua an, kilong lapo sikei. Asukang na sa na God katala pala kuvul ia, ka ago ta mangsikei ka luang ia.” ");
INSERT INTO lcm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Na kila sui ia ta, “Au man asukang, marai sa na Moses kata saupai ta igenen ka salik kana mengen i misag, le na kala asok suai ania?” ");
INSERT INTO lcm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Na kala antok iria ta, “Using a vingami kapo kitmat, na Moses kata ainak animi si kirikai suai ani kami keve aina. Sikei parik katapa asukang ke le si taun i asisinong. ");
INSERT INTO lcm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Napo antok imi ta man a si katala kamus si kana aina, man parik katapa atogon panik, na kala osongon a mang anu, sukana kapo abis a lau rikek.” ");
INSERT INTO lcm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Na kana keve nat kila antok ta, “Au si man nia vanang kapo selen ani tauan na aina, kapo ro nganing asi ago ta osongon an.” ");
INSERT INTO lcm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Na Iesu kala antok ta, “Io, mengen ang, parik ta ri vap aongos ki ainak ania, sikei riria voiang kipo angkokoai. ");
INSERT INTO lcm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Napo mengen asukang ke ta mang matan tauan parik kipa osongon using kita akau asereiai aniria asukang, na mang matan using ri vap kita kavak iria, na mang matan marai vainagoan i metekuku. Nia kapo angkoai si luk ani mengen ke, ka luk ia.” ");
INSERT INTO lcm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Na kimela serei singina ta ri natlik ani ka amatung kunga singiria na ka sokotuk singiria. Na keve nat i akalit kilapo ki iria. ");
INSERT INTO lcm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Sikei Iesu kala antok, “Mi lomon suai ani ri nat lik ane singig. Ago ta atakun an aniria, using a matan vap val ria, kakaria vang na sinsinongan si vainagoan ang e metekuku.” ");
INSERT INTO lcm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na kala amatung kunga singiria, na kala pasal. ");
INSERT INTO lcm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Na mangsikei a igenen kamela serei singina na kala sui ia, “Katakai i akalit, na abis a saka lau roron an asi atogon ani to asikei?” ");
INSERT INTO lcm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Na kala antok ia ta, “Marai sa na kupo sui iau ta sa kapo roron? Kapo togon palau a sikei a igenen kapo roron. Man kupo buk palak nei sinsinongan i to asikei, ku uli longong ani keve asok tapai.” ");
INSERT INTO lcm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Na kala sui ia, “Saka keve asok tapai an?” Na Iesu kala antok ta, “Ku ago ta daung an, ku ago ta putuk osongon an, ku ago ta tainau an, ku ago ta posposo akapau an mete saupai. ");
INSERT INTO lcm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ku mamaila aro ani tamam ve rinam na ku vinga ro taun a tungam val kupo vinga ro taun pok ua.” ");
INSERT INTO lcm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Na igenen tanginang ang kala antok ia ta, “Riria aongos nata using arukup iria. Mang sa lak napo kudik ina?” ");
INSERT INTO lcm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Na Iesu kala antok ia ta, “Si man kupo buk ani ku talupus aro, ku pasal na kuan atos ta kam keve togtogon na ku alis ani ri vap logo ani kakam a togtogon roron e metekuku. Na kume using iau.” ");
INSERT INTO lcm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Taun a igenen tanginang ke kala longong asukang ke, kala pasal mamakus aliu, using katapo atogon kana togtogon lava. ");
INSERT INTO lcm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Na Iesu kala antok kana keve nat i akalit, “Napo antok atutuman imi ta vola kitmat luai ani igenen tauia si palak nei vainagoan i metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Naka anguan mengen an animi, palak ang si igenen tauia ane nei vainagoan ang si God, ka kitmat luai ani papalakan si kamel nei malang i sangum.” ");
INSERT INTO lcm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Taun a keve nat i akalit kila longong asukang ke, kilapo aunai taping na kila sui, “Au man asukang na si kala sapang?” ");
INSERT INTO lcm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Na Iesu kala tun iria na kala antok ta, “Ani ri vap kapo kitmat, sikei ani God, keve bil aongos kapo angkoai.” ");
INSERT INTO lcm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Na Petero kala antok ta, “Arai, namem tala papelek a keve bil aongos asi kamem using anim. Asukang na ka atogon a sa animem?” ");
INSERT INTO lcm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Na Iesu kala antok iria, “Napo antok atutuman imi ta si kuli rina tanginang, si taun ang man a igenen i pukun kala sinong si kana miminaungan i sinsinongan, io nami mita usiusing iau, mi an sinong lak si 12 na sinsinongan asi kami saupai ani 12 na patvap i Israel. ");
INSERT INTO lcm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Na man a si kata papelek kana lu, keve tasina, keve tauna, tamana vo rinana, kana inatus, kana keve matang, using a asan ig, kan atogon a tauia tavirimok luai ani sa kata papelek ia, na ka luk kana sinsinongan i to asikei. ");
INSERT INTO lcm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Sikei, vap miang kitapo aino, kime aimung. Na riria kitapo aimung kian aino. ");
INSERT INTO lcm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Io, vainagoan i metekuku kapo asukang ta votauk i vuk roe nang kata pasal tenei vauk lik si kana songo vap sime abis si kana matang vaen. ");
INSERT INTO lcm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kala ainak si samui aniria ta samui i sikei a taun na kala asok iria ane nei kana matang vaen. ");
INSERT INTO lcm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Au, e mung lik si limaleat a vuk taun kala pasal na kanla sabonai ani mang matan sipo angtung palau nei ring ipo asesel. ");
INSERT INTO lcm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na kala antok iria, ‘Nami kapa, mi kun pasal na mian kun abis nei kag matang na na kun samui animi si saka seupok an kapo angkokoai.’ Asukang na kila pasal. ");
INSERT INTO lcm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na si 12 kala anguan asok an ani mang matan sian abis. Na e mung i potol kapa. ");
INSERT INTO lcm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Au, e mung i palpalima na vuk taun tenei ngelik, kanla anguan sabonai ani mang keve anu sipo angtung palau. Na kala sui iria, ‘Au marai sa na mipo angtung palau na mangias aongos ke tav abis ta mangsikei a abis?’ ");
INSERT INTO lcm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na kila antok ia ta, ‘Using katapo kovek i igenen si songo animem sian abis ania.’ Na kala antok iria ta, ‘Nami kapa, mi kun pasal na mian kun abis nei kag matang vaen.’ ");
INSERT INTO lcm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Au, kala ngelik luai na votauk i matang vaen ang kala antok na kana igenen vo ainoinoai ani abis ang ta, ‘Songo na vap vo abis ang na kume samui iria tutapongai si vap abis amukmuk ke tung si vap vo luk abis ang tenei vauk.’ ");
INSERT INTO lcm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Vap po abis ang si palpalima na vuk taun tenei ngelik, kita luk siksikei na kari samui i sikei a taun kirol. ");
INSERT INTO lcm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Asukang na vap vopo abis le tenei vauk ang kitapo sekpat ani ki luk alava lik. Sikei siksikei iria kapa kala kun luk ani samui i sikei a taun palau. ");
INSERT INTO lcm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Taun kila luk ia kilapo kitukituk ani votauk i roe ang ta, ");
INSERT INTO lcm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Vap ke voike kuta songo iria si me abis aimung ke kita abis palau na vuk pangau kudik luai, sikei kupo vil iria angkoai palau val namem, vap po sunguk ani maiten i abis ke nei liuan i manas i sinang ke.’ ");
INSERT INTO lcm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Sikei kala polpol na mangsikei iria ta, ‘Tungag, parik napa aninio ua. Au sa parik kutapa ainak si abis ani seu i sikei a taun? ");
INSERT INTO lcm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Luk kam samui na ku pasal. Napo buk alis ani iuang vo luk abis aimung ang asukang palau val nata alis ua. ");
INSERT INTO lcm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Sa, parik napa atogon roron si asuai ani kag kapkap si kag kun vubuk? Vei kuvpo pisu nganing anig using napo igenen alis?’ ");
INSERT INTO lcm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sukana vang a vo aimung ka aino na vo aino ka aimung.” ");
INSERT INTO lcm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kana si taun ke na Iesu kalapo palak ane Ierusalem. Kala songo na 12 na nat ane ngising na kala antok papalik iria e selen asukang ke ta, ");
INSERT INTO lcm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Arai, taralapo palak vang ane Ierusalem na igenen i pukun kian sung lis ia e kungaria i keve ainoinoai si ri katakai i sula na keve vap malangas ani saupai, na kian alis saupai ani kan mat. ");
INSERT INTO lcm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na ki alis ia e kungaria i ri vap i ngising ani ki kurek ia na ki sasaup ia na kian atakuk ia kuli ngakputuk, na si vapotol i taun ka tapasuk pok.” ");
INSERT INTO lcm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Au, rinarilong i ngono nat si Sebedaio kamela serei singina ta kana ngono nat, na kala soturungai si aikut ani mangsikei a vubuk singina. ");
INSERT INTO lcm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Na kala sui iria ta, “Au mipo buk a sa?” Na kila antok ia ta, “Napo buk ani ku asok ta mangsikei i kag ngono nat ani kan sinong si kam palso na mang anu si kam palkais nei kam vainagoan.” ");
INSERT INTO lcm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Na Iesu kala antok ta, “Parik milongpa nas a sa milongpo aikut ia. Sa, milongpo angkoai si inum si kavi ke napo usausa asi kag inum singina?” Na kilongla antok ia ta, “Namemlongpo angkoai.” ");
INSERT INTO lcm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na Iesu kala antok irilong ta, “Tutuman, milong inum singina, sikei si sinong si kag palso vo palkais, parik vang kapa kakag si kag posong singina. Ngono palpal ang kapo kakaria, riria na mamai katala itoiton ia aniria.” ");
INSERT INTO lcm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Au, mang sangauli na nat ang kila longong a bil ke, na kilapo songag ani ngono angtasimal ke. ");
INSERT INTO lcm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Sikei Iesu kala songo akuvul iria na kala antok, “Mipo nas a ri vap i ngising, kari keve vap vo sausaupai kipo aunai lakat aniria. Na kari keve vap asanan kipo aunai sausaupai aniria. ");
INSERT INTO lcm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Parik kapa ro ta ka asukang singimi. Sikei si man a si kapo buk ani ka laba singimi, kapo ro ani ka serei a asosokai singimi aongos. ");
INSERT INTO lcm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Na si kapo buk tu ainoinoai animi ka auak ia ani ka asosokai e kevkev luai singimi. ");
INSERT INTO lcm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Asukang val igenen i pukun kata serei parik asi kari me asosokai singina, sikei asi kana me asosokai singiria na asi kana me mat bat ani vap miang na asukang ka samui apok iria.” ");
INSERT INTO lcm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Au, kilapo pataliung a Ieriko na petau lava kilapo kun using aniria. ");
INSERT INTO lcm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Na pongua na igenen mata ba kilong tapo sinong ngere selen. Na kilongla longong ta Iesu nang kapo pakasang na kilonglapo songosongo ta, “Volava, nat i David, ku ngorem imemlong!” ");
INSERT INTO lcm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Na petau ang kilapo atakun irilong ani kilong ago ta mengen an, sikei kilongla songosongo alava luai ta, “Volava, nat i David, ku ngorem imemlong!” ");
INSERT INTO lcm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Na Iesu kamela tung na kala songo irilong na kala sui ta, “Milongpo buk ani naka vil sa animilong?” ");
INSERT INTO lcm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Na kilongla ngenget ia ta, “Volava, namemlongpo buk ani namemlong mata arai.” ");
INSERT INTO lcm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Na pakangat ina i Iesu kala tameng taun irilong na kala sigil a matarilong. Na akorong palau matarilong kala arai, na kilongla using ia. ");
INSERT INTO lcm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na kian lapo pasal angasungai i Ierusalem, asi an serei e Betpage si mulang ang Elaio, na Iesu kala asok a pongua na nat i akalit ");
INSERT INTO lcm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","velai ani mengen anirilong ta, “Milong pasal taun a rina suke e no, na milonganla sabonai ani mang sikei a dongki kita pala ia kuvul ve kana natnat. Milong kunis irilong na milong tak irilong ane singig. ");
INSERT INTO lcm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Man a sikei ka sui imilong, milong antok ta, ‘Volava kapo inongos taun irilong,’ na ka ainak sumasuma palau si tak anirilong.” ");
INSERT INTO lcm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Bil ke kata serei asi vil apunuk ani mengen ang a katakai i kus amalangas kata posong ia aino asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Antok a rina ang e Sion ta, arai, kami tulava sukana kapo serei taun imi. Kapo igenen marip na kapo gon kuli dongki, io kuli natnat ina i dongki vopo asalak ang. ");
INSERT INTO lcm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Na ngono nat ang kilongla pasal na kilong anla vil ia asukang palau val Iesu katala atatai irilong, ");
INSERT INTO lcm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","na kilongmela serei pok ta dongki ang ve kana natnat na kilongla veleveles karilong keve vakup ipo apupung kuluna na kala kokos kuluna. ");
INSERT INTO lcm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Amiang i petau ang kila veleveles kari keve vakup ipo apupung aliu e selen na mang matan kipo tangai ngakan i ei na kipo veleveles ia nei selen. ");
INSERT INTO lcm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Na petau vo aino ang ve riria e mung kapa kipo songosongo ta, “Alatun ane si nat i David. Atautauia ane singina, voiang kapo serei si asan i Volava. Alatun ane pangkul luai.” ");
INSERT INTO lcm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Na taun kanla palak nei rina ang e Ierusalem, nei rina lava aongos ang kilapo angnanasai na kilapo sui ta, “Au, si kana?” ");
INSERT INTO lcm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Na petau ang kila antok ta, “Kana na Iesu, ninia na katakai i kus amalangas ang le Nasaret le palpal Galilaia.” ");
INSERT INTO lcm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Au, Iesu kanla palak nei rina i atailai na kanlapo lu asoung aongos a vap po samui na asesel ang nei rina i atailai. Na ka ul aturung a keve pata singiria kipo sakol kapkap, na keve sinsinong singiria kipo atos ta ri uk. ");
INSERT INTO lcm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na kala antok iria, “Kitala salik ia ta, Kag lu kapo lu si sokotuk, sikei milapo pokai ania asi kana bil val vakil si ri vap tainau.” ");
INSERT INTO lcm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Na ri mataba ve ri soles kimela serei singina e iang nei rina i atailai na kalapo vil ato iria. ");
INSERT INTO lcm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sikei, keve tulava i ri katakai i sula ve keve vap malangas ani saupai kila arai ani keve abis roron ke na kipo longong a inatus lik sipo songosongo nei rina i atailai ta, “Alatun ane si nat i David,” na kilapo vinga marala, ");
INSERT INTO lcm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","na kila sui ia ta, “Au, kupo longong a sa kipo posong ia?” Na Iesu kala antok iria ta, “E, napo longong iria. Sa, parik kana mitapa tataot a mengen ke? Le si kalingaria i inatus lik ve ri popo lik luai kutala iton iria asi kari alatun anim.” ");
INSERT INTO lcm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Na kala papelek iria ane komo i rina lava ane Betania na kanla ago na vong ang e iang. ");
INSERT INTO lcm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Au, tenei vauk, taun kalapo papok ane nei rina lava ang, buk angan kala lukluk ia. ");
INSERT INTO lcm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kala arai ani mangsikei a suke kapo tung papalik ngere selen. Na kala pataun ia sikei kanla sabonai ta kapo papanan palau. Au na kala mengen taun ia, “Ku ago ta anguan uai an.” Akorong palau na ei ang kala mak aongos. ");
INSERT INTO lcm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na kana keve nat i akalit kila arai ania na kilapo taping na kila sui, “Au, kata saka bil an a suke ke na kalapo mat sumasuma palau?” ");
INSERT INTO lcm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Na Iesu kala antok, “Napo antok atutuman imi ta si man mipo atogon palau a sikei a lomlomon na parik mipa ilung, parik kapa angkoai si vil amat papalik ani suke ke, sikei kapo angkoai kapa si mi asok ani mulang ke ta, ‘Ku tapasuk na kuan asuai anim nei laman!’ na ka serei asukang. ");
INSERT INTO lcm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Si man mipo lomlomon ta sa mipo kin ia si kami sokotuk, mi sel korong ia.” ");
INSERT INTO lcm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na kanlapo pasal nei rina i atailai na ri ainoinoai si ri katakai i sula, kuvul ve ri vap lava kimela serei singina si kapo vil akalit, na kila sui ta, “Si saka ro an kana kupo abis a keve abis ke? Si kata alis ua ta ro?” ");
INSERT INTO lcm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Na Iesu kala polpol iria ta, “Naka sui imi ta mang susui, na man mila polpol aro ia, nau naka antok imi ta kag saka ro an asi abis ani keve abis ke. ");
INSERT INTO lcm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ioanes si kana asing tauia, kata luk a ro ang le voi? Le metekuku vo le si ri vap?” Na kilapo anggegelai ta, “Man tara antok ta le metekuku, kala sui ira ta sa tukulai ina parik taratapa lomlomon tatana. ");
INSERT INTO lcm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sikei, man tara antok ta le si ri vap, tarala leng ani ri vap duk, using ri vap aongos kipo lomon ia ta Ioanes katapo katakai i kus amalangas.” ");
INSERT INTO lcm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Asukang na kila polpol a Iesu ta, “Parik namempa nas.” Na kala atai iria ta, “Nau kapa, parik napa kun antok animi ta saka ro an kana napo abis a keve abis ke tatana. ");
INSERT INTO lcm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mipo saka lomlomonai an? Mangsikei a igenen katapo atogon kana pongua na nat. Na kamela antok kana ainoai i nat ta, ‘Kag nat, ku pasal kana na kuan abis nei matang.’ ");
INSERT INTO lcm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Na kala antok ta, ‘Ka ago. Parik napa buk.’ Sikei e mung kala sakol kana lomlomonai na kala pasal. ");
INSERT INTO lcm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Au na tamana kala pasal taun kana mang nat na kanla antok ia ta sikei palau a mengen ang. Na kala polpol ia ta, ‘E, kanat, kapo ro mamai.’ Sikei parik kalapa pasal. ");
INSERT INTO lcm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Au, si i ngono nat ke katala abis using a vubuk ang si tamarilong?” Na kila antok ia ta, “Anu aino ang.” Na kala antok iria ta, “Napo mengen atutuman imi ta ri vap luk takis ve ri aina panik kipo palak ane nei vainagoan ang si God aino imi. ");
INSERT INTO lcm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Using Ioanes kata serei sime akalit animi ta selen korong, na parik mita lapa lomlomon tatana. Sikei ri vap luk takis ve ri aina panik kitala lomlomon tatana. Na nami, mitala arai ani kari lomlomon, parik mita lapa ming na mila lomlomon tatana. ");
INSERT INTO lcm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Au mi longong a mang kankanuai i mengen. Mangsikei a igenen kata sukal kana matang vaen, na kala omo aulitai ania na kala atu ring asi kokomeng ani uai, na kala abis a lu lakat ipo ararai bat, na kala alis tapai ani matang ke si mang keve vap aiveven matang na kala pasal akipai ane si mang rina. ");
INSERT INTO lcm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na si taun i kopkopos kala asok kana keve asosokai taun a keve vap aiveven matang ang si kari an luk ani kana keve uai. ");
INSERT INTO lcm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Au na keve vap po aiveven matang ke kila teng akit iria na kianla vis a mangsikei, ki raung a mang anu, na ki so na mang anu ta at. ");
INSERT INTO lcm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Au na kala asok kana mang matan asosokai kipo aunai duk ani vap aino ang ane singiria. Na kianla anguan vil asukang an kapa aniria. ");
INSERT INTO lcm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Na akamusai ina kala asok akorong kana nat using kapo lomon ia ta vei ki mamaila nganing ani kana nat. ");
INSERT INTO lcm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sikei taun a keve vap po aiveven matang ke kila arai ani kana nat na kila antokai, ‘Arai ta votauk i togtogon iles. Akos, tara me vil punuk ia ani kakara na togtogon ang.’ ");
INSERT INTO lcm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Au kila teng akit ia na kila asuai akipai ania pelek a matang ang, na kianla raung ia. ");
INSERT INTO lcm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Au na si man a votauk i matang ke kala serei pok, ka vil sa ani keve vap po aiveven matang ke?” ");
INSERT INTO lcm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Na kila ngenget ia ta, “Ka asok a vap rikek luai ke ane si vilvil akui lava, na ka alis tapai ani matang ang si mang keve vap using ki alis pok ia ta polpol i matang ang si taun i kopkopos.” ");
INSERT INTO lcm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Na Iesu kala antok iria, “Sa, parik kana mitapa tataot a vuk mengen ke nei salsalik? Iat ke ri katakai i abis lu kita kilis ia, kana kala serei a iat talupus luai. Bil ke, Volava kata asereiai ania, na vola miminaungan luai e matara! ");
INSERT INTO lcm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Man a ri si ki uak kuli iat ang ki tagalang amitmitngai lik, sikei man a iat ang ka uak taunai ani si, ka tatameng aongos luai. ");
INSERT INTO lcm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ninia kapo uak kuli at ke ka tatadek alik, sikei nia kana na at ke ka uak kuluna ka vil atameng luai ania.” ");
INSERT INTO lcm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Taun a keve ainoinoai si ri katakai i sula ve ri Parisaio kipo longong kana keve kankanuai i mengen, kilapo malangas ta kapo mengen tataria. ");
INSERT INTO lcm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Na kilapo gule selen asi kari teng akit ania, sikei kipo leng ani petau ang using kipo lomlomon ta kapo katakai i kus amalangas. ");
INSERT INTO lcm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Na Iesu kala anguan mengen an aniria si kankanuai i mengen asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Vainagoan i metekuku kapo asukang val mangsikei a tulava kata vil a matan angan ani kana nat si kana osongon. ");
INSERT INTO lcm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na kala asok kana keve asosokai asi kari an songo ani vap ang katala songo iria ane si matan angan ang, na kipo misag ani me serei. ");
INSERT INTO lcm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Au, kala asok kana keve asosokai ta, ‘Mi pasal na mian antok na vap ila mengen amalangas ang ta, “Natala itoitonai lenginang ani kag matan angan. Keve bulumakau ve mang keve vongo ngokngok ro natala taun aniria. Keve bil aongos kalapo usausa. Mi me ane si matan angan ke.” ’ ");
INSERT INTO lcm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Sikei kila misag na kila pasal using kari keve lomlomonai akorong, mang anu kata pasal ane matang na mang anu ane si kana ring ipo atos. ");
INSERT INTO lcm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Na mang matan kila teng akit kana keve asosokai na kila nau varas iria na kila raung iria. ");
INSERT INTO lcm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Au na tulava kala marala na kala asok kana keve katakai i visvis asi kari an raung suai luai ani vap po daung ang na ki an ani kari rina. ");
INSERT INTO lcm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Au na kala antok kana keve asosokai, ‘Matan angan i osongon ke kalapo usausa, sikei vap ang natapo buk iria parik kita lapa ro angkoai asi kari me angan. ");
INSERT INTO lcm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mi pasal taun a keve angmamarakai i selen na mian songo vap ane si matan angan ke. Mi songo na ri si mipo arai aniria.’ ");
INSERT INTO lcm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Asukang a keve asosokai ke kila pasal taun a keve selen i nei rina na kianla songo akuvul aongos na ri vap kipo sabonai aniria, vap roron ve ri vap po rikek ang. Na nei lu sian pagamau kamela sogong atung ta kana vap. ");
INSERT INTO lcm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Sikei taun a tulava ang kamela palak sime arai ani vap ke, kanla arai ani mangsikei e iang parik katapa alak a maus ipo alak si taun i pagamau na kala antok ia, ");
INSERT INTO lcm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Au tungag, kuta saka palak an? Using parik kupa alak kam maus.’ Na igenen ang kala tu bot. ");
INSERT INTO lcm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Na tulava ke kala antok kana keve asosokai, ‘Mi got a ngono kungana ve ngono kakina na mi asuai ania ane komo ane si ring vong itum, voiang kapo atogon tangis na ngut ngisa.’ ");
INSERT INTO lcm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Io, vap miang kipo songo iria, sikei rukun lik palau kipo pilak iria.” ");
INSERT INTO lcm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na ri Parisaio kianla vil lomlomonai si kari teng akit ania si kana mengen. ");
INSERT INTO lcm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na kila asok kari keve nat i akalit ane singina kuvul ve mang keve vap si Erodes. Na kianla antok ia ta, “Katakai i akalit, namempo malangas ta kupo igenen atutuman na kupo akalkalit ta kana laulauan a God si selen tutuman. Na parik kupa tarakai ani mangsikei using ri vap kipo angkokoai palau e matam. ");
INSERT INTO lcm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ku mengen imem. Nei kam lomlomonai? Kapo korong ani tara samui takis ane si Kaisar vo parik?” ");
INSERT INTO lcm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sikei, Iesu kala nas kari lomlomonai visuk na kala antok, “Nami na vap kapau, marai sa na mipo buk atoktokngai anig? ");
INSERT INTO lcm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mi akalit iau ta kapkap ipo samui takis ang.” Na kila alis ia. ");
INSERT INTO lcm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Na Iesu kala sui iria, “Au, nona i si kana? Na asan i si kana?” ");
INSERT INTO lcm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Na kila antok ia, “Ke Kaisar.” Na kala antok iria, “Mi alis a Kaisar ta sa ke Kaisar, na mi alis a God ta sa ke God.” ");
INSERT INTO lcm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Taun kila longong asukang ke kilapo taping, na kila atolongon ia na kila pasal. ");
INSERT INTO lcm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Si taun ang palau mang matan Sadukaio, vap ang kipo agel suai ani tadut pok, kimela serei singina, na kila sui ia ta, ");
INSERT INTO lcm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Katakai i akalit, Moses kata antok ta si man a igenen katala mat na kapo kovek i inatus, tasina ka osongon a mainang ang asi kana aumata nat ani tasina. ");
INSERT INTO lcm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kana nei liuan imem katapo atogon a limalengua na angtasimal. Anu tuan kata osongon na kala mat. Na using kapo kovek i inatus, tasina kala osongon kana aina. ");
INSERT INTO lcm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na asukang kapa si anu tasina na vapotol na kala pasal luai tung si valimalengua. ");
INSERT INTO lcm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Au, e mung iria aongos, aina ke kala kun mat kapa. ");
INSERT INTO lcm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Si taun i tadut pok, si akorong i limalengua na tauan ke ka tauk i aina ke? Using ria aongos kita osongon tatana?” ");
INSERT INTO lcm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Na Iesu kala antok iria, “Mipo lok singina using parik mipa nas a mengen ang nei salsalik, na parik kapa mipa malangas kana kitmat a God. ");
INSERT INTO lcm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Si taun i tadut pok ri vap parik kipa angosongon, parik. Ki bil val ri angelo i metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Au na ani vap la mat ang, vei parik lak nganing mipa taot kana mengen a God taun imi? ");
INSERT INTO lcm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Nau a God si Abaram, God si Isak, na God si Iakov. Parik ta God si ri vap mat, sikei kakaria kipo to.” ");
INSERT INTO lcm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Taun a petau lava ang e iang kipo longong ia kilapo taping ani kana akalkalit. ");
INSERT INTO lcm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Si taun ri Parisaio kila longong ta Iesu katala vil amamaila na ri Sadukaio, kimela serei kuvul. ");
INSERT INTO lcm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Na mangsikei iria, voiang katapo igenen malangas ani saupai, kala atoktokngai ania ta susui ke, ");
INSERT INTO lcm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Katakai i akalit, saka asok tapai an kapo laba luai nei liuan i keve saupai?” ");
INSERT INTO lcm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Na kala antok ia, “Ku vinga ro taun a Volava kam God ta pakangat im aongos, na malanganto im aongos, na lomlomon im aongos. ");
INSERT INTO lcm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kana kapo ainoai na kapo lavlabat luai i asok tapai. ");
INSERT INTO lcm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Na vapongua kapo kuvul palau, Ku atogon a tungam val kupo vinga ro taun pok ua. ");
INSERT INTO lcm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pongua na asok tapai ke, keve mengen i nei saupai na si ri katakai i kus amalangas kipo gon kuluna.” ");
INSERT INTO lcm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Si taun a ri Parisaio kianlapo ago kuvul Iesu kala sui iria, ");
INSERT INTO lcm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Mipo saka lomlomonai an ani igenen i akanangai? Kapo nat i si?” Na kila antok ta, “Nat i David.” ");
INSERT INTO lcm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Na kala antok ta, “Kapo saka bil an na David, si malanganto, kata songo ia ta Volava, asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Volava kata antok kag Volava ta ku sinong e palso ig tung si naka vil a vap po petau ang anim asi kari ago neite ngono kakim. ");
INSERT INTO lcm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Man a David sukana kapo songo ia ta Volava, kapo saka angkoai an si kin ania ta kapo nat ina?” ");
INSERT INTO lcm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na kapo kovek i mangsikei kapo angkoai si polpol ania. Na le si taun ang kilapo lolokovo luai ani sui ania ta mangsikei a susui. ");
INSERT INTO lcm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Au, Iesu kala mengen na petau ang ve kana keve nat i akalit ");
INSERT INTO lcm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","asukang ke, “Ri vap malangas ani saupai ve ri Parisaio kilapo tung kuli sinsinong ang si Moses. ");
INSERT INTO lcm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Asukang na mi longong na mi abis aongos na sa kipo antok imi tatana. Sikei mi ago ta using an ani sa kipo abis ia using parik kipa vil korong a sa kipo mengen tatana. ");
INSERT INTO lcm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kipo got na keve sungsungukan maiten luai na kipo asunguk na ri vap tatana, sikei riria akorong parik kipa sigil ta sikei a piupiu i kungaria. ");
INSERT INTO lcm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Keve bil aongos kipo abis ia ani ri vap si kari arai aniria. Kipo uli buk atere ani ri vap ta kari keve laka lik ipo asiang ani mengen si God. Na kari keve vuk akanangai e ngising i vakup, kipo buk ani ki laba. ");
INSERT INTO lcm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Kipo buk a keve oring mamaila si keve matan angan, na kipo pigpig ta keve sinsinong lava nei lu i kivung, ");
INSERT INTO lcm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","na asi posong aro singiria nei ring i atos, na kipo buk ani ri vap ki kin iria ta rabi. ");
INSERT INTO lcm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Sikei nami, ki ago ta kin an animi ta katakai i akalit using mipo atogon palau kami sikei a katakai i akalit na nami aongos mipo angtasimal. ");
INSERT INTO lcm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na mi ago ta kin an ani mangsikei e kuli rina ta tamami using mipo atogon palau a sikei a tamami, nang a vo ago ang e metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ki ago ta kin animi ta ainoinoai using mipo atogon kami sikei palau a ainoinoai, nia na Karisto. ");
INSERT INTO lcm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ninia kapo buk asi kana laba nei liuan imi, ka serei a asosokai singimi. ");
INSERT INTO lcm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Io, ninia kapo vil alava pok ia, ki vil alik ia. Na ninia kapo vil alik pok ia, ki sunguk alakat ia. ");
INSERT INTO lcm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Ka rikek animi, ri vap malangas ani saupai ve ri Parisaio. Mipo vap kapau. Mipo akang na vainagoan i metekuku e mataria i ri vap. Using nami akorong parik mipa palak na parik mipa atalipai aniria kipo atokngai si palak asi kari palak. ");
INSERT INTO lcm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ka rikek animi ri vap malangas ani saupai ve ri Parisaio. Mipo vap kapau. Mipo paputuk laman na keve ring vunga asi an sasakol ani to si sikei a igenen ani ka using imi. Na si taun kala sasakol mila vil ia asi kana la soliu luai animi si kana bil val nat i nei kut lava i saupai. ");
INSERT INTO lcm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ka rikek animi keve mata ba vopo ausingai ang ani ri vap. Mipo antok ta si man a sikei kapo atutuman serei si rina i atailai, kapo palau. Sikei si man kapo atutuman serei si at riparipag i rina i atailai, io kana palapalatung kapo maiten. ");
INSERT INTO lcm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Keve mata ba velai tanio, sa kapo laba? At ang vo rina i atailai vopo vil agogoai ani at ang? ");
INSERT INTO lcm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mipo antok kapa ta si man a sikei kapo atutuman serei si pata ipo sula ang kapo palau. Sikei si man ka atutuman serei si saka alilis an kapo gon kuluna, io ninia vanang kapo atogon maiten. ");
INSERT INTO lcm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Keve vap mata ba, sa kapo laba? Alilis ang vo pata vo vil agogoai ang ani alilis? ");
INSERT INTO lcm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Asukang na si kapo atutuman serei si pata ipo sula, kalapo atutuman serei si keve bil aongos kapo gon kuluna. ");
INSERT INTO lcm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Na si kapo atutuman serei si rina i atailai kalapo atutuman serei si vo ago ang neina. ");
INSERT INTO lcm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Na si kapo atutuman serei si metekuku, kalapo atutuman serei si sinsinongan si God na vopo sinong ang singina. ");
INSERT INTO lcm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ka rikek animi ri vap malangas ani saupai ve ri Parisaio. Mipo vap kapau, using mipo alis aro kami sikei a vasangauli i panga sain ve lambo mai na anian, sikei mipo ataole na keve bil mamaiten i saupai, nang a lau korong, ngorem na atutuman. Kapo ro mi abis na keve bil ke kuvul ve keve bil ang mitapo abis ia. ");
INSERT INTO lcm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nami na keve vap mata ba na mipo ausingai ani ri vap. Mipo telan alava ta keve nem lik luai, sikei mipo ba ani keve nem maiten. ");
INSERT INTO lcm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ka rikek animi vap malangas ani saupai ve ri Parisaio. Mipo vap kapau. Mipo vil adaus na pere i ese ve avubus sikei neina kapo duk ta tainau ve neikitung. ");
INSERT INTO lcm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Numai a Parisaio mata ba, ku vil adaus aino na neina i ese ve avubus, au le lak na perena ka kun daus. ");
INSERT INTO lcm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ka rikek animi ri vap malangas ani saupai ve ri Parisaio. Mipo vap kapau. Mipo asukang val keve mopong kavang kapo ararai aroron luai e komo sikei neina kapo duk ta tuan i vap mat na ri bil visuk miang. ");
INSERT INTO lcm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Asukang palau nami mipo ararai val vap korong e mataria i ri vap, sikei nei vingami kapo duk ta kapau ve lau i putuk saupai. ");
INSERT INTO lcm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ka rikek animi ri vap malangas ani saupai ve ri Parisaio. Mipo vap kapau, using mipo atung akanangai si keve mopong si ri katakai i kus amalangas na mipo amaus na mopong i ri vap korong. ");
INSERT INTO lcm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na mipo antok ta, ‘Si man tarata ago si taun si keve tivura parik tarapa angkoai si tung le ve ria si raung ani keve katakai i kus amalangas.’ ");
INSERT INTO lcm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Sukana mipo mengen amalangas pok tatami ta nami na keve tivuria palau i vap raung ang ani keve katakai i kus amalangas. ");
INSERT INTO lcm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kapo ro, mi akamusai aro tapai ani keve lau rikek ang si keve tivumi. ");
INSERT INTO lcm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nami na ri kene na keve natnat i kene, mi saka sip an man ki asok imi ane si kut lava i saupai? ");
INSERT INTO lcm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Au mi arai. Naka alis imi ta keve katakai i kus amalangas na keve vap nas na keve vap malangas ani saupai. Mang matan iria mi an vil punuk iria na mi atakuk iria, na mang matan mian sasaup iria nei kami keve lu i kivung na mi lu pulakai aniria le si mang rina ane si mang rina. ");
INSERT INTO lcm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na e iang, rangai aongos i keve vap korong katala saling kuli rina kan gon kulumi, tutapong le si rangai i igenen korong ang Abel tung si rangai i Sakarias nat si Barakias, mita raung ia nei liuan i lu i atailai na pata ipo sula ang. ");
INSERT INTO lcm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Napo antok imi ta keve bil aongos ke ka gon si polpolokan i taun ke. ");
INSERT INTO lcm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Numai vang a Ierusalem, kuta raung ri katakai i kus amalangas, na kuta li punuk iria, vap ang a God kata asok iria taun ua. Taun miang nata lapo buk songo akuvul ani kam inatus asukang ta pura aina kapo apung kana keve natnat neite ngono vangana. Sikei mitapo uli misag! ");
INSERT INTO lcm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mi arai! Sukana kami lu kalapo tung vauvau. ");
INSERT INTO lcm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Using kana napo antok imi ta parik mipa anguan arai an anig tung si taun mila songosongo asukang ke, ‘Atautauia singina, nang kalapo serei si asan i Volava!’ ");
INSERT INTO lcm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Na Iesu kala soung pelek na rina i atailai na taun kalapo pasal aliu, kana keve nat i akalit kimela antok ia si kana arai ani rina i atailai. ");
INSERT INTO lcm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Na kala antok iria, “Mipo arai kana ani keve nem ke, ingko? Napo mengen atutuman imi ta ka kovek luai i ngoto roron. Kime galang aongos ia.” ");
INSERT INTO lcm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na si taun kanlapo sinong si mulang ang Elaio kana keve nat i akalit kimela serei papalik singina na kila sui ia ta, “Ku atai imem. Angisan a keve bil ke ki serei? Na saka akanangai an i taun i kam serei pok na akamusai i kuli rina ke?” ");
INSERT INTO lcm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Na Iesu kala polpol iria, “Mi aiveven vei mangsikei nganing ka kapau imi. ");
INSERT INTO lcm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Using vap miang ki serei na ki posong pok iria ta asan ig na ki antok ta, ‘Nau kana na igenen i akanangai.’ Na ki kapau a vap miang. ");
INSERT INTO lcm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mi longong lak ta kalapo togon visvis vo kalapo angasungai a visvis. Mi ago ta leng an using a keve bil ke ki serei, sikei akamusai ina lak, parik. ");
INSERT INTO lcm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Using mang palpal vap ka tapasuk na ka angvis ve mang palpal vap, na mang vainagoan ka angvis ve mang vainagoan. Na keve buk angan lava na keve mimo ki serei si mang keve rina. ");
INSERT INTO lcm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Keve bil ke kapo asukang ta tutapongai palau i kui. ");
INSERT INTO lcm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ki alis imi ane si vilvil akui na kian raung imi, na mamain ta matan vap ki mirik animi marai asan ig. ");
INSERT INTO lcm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Na si taun ang vap miang ki savang na ki alis angpokpokai aniria si saupai kitmat na ki mirik angpokpokai aniria. ");
INSERT INTO lcm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Na aduk i ri kus amalangas kapau ki tapasuk na ki kapau a vap miang. ");
INSERT INTO lcm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Na using a lau rikek kalapo polok alava, vap miang ki auak kari lau i ngorem. ");
INSERT INTO lcm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sikei man a si ka tung akit tung si akamusai ina, ka sapang. ");
INSERT INTO lcm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Na akus ro i vainagoan ke ki akuskus tatana e kuli rina aongos ani mamain ta matan vap si kari longong ania le lak na kuli rina ke ka kamus. ");
INSERT INTO lcm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Taun mi arai ani bil vopo nau varas ani God na kapo goeng rina, nang a katakai i kus amalangas Daniel kata mengen tatana, ka tung nei Ring Gogoai, (vopo taot a mengen ke, ka lomlomonai aro ania), ");
INSERT INTO lcm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","io, ria kipo ago e Iudaia kapo ro ani ki sip taun a keve mulang. ");
INSERT INTO lcm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Na ninia kapo ago e komo i lu, ka ago ta riuk lak pok an sian luk ani bil nei kana lu. ");
INSERT INTO lcm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Na ninia kapo ago e matang ka ago ta papok pok an sian luk ani kana vakup. ");
INSERT INTO lcm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pua ta ri aina vinga na riria kipo atutus popo si taun ang! ");
INSERT INTO lcm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mi sokotuk ani kami taun i sip ka ago ta tung an si taun livus vo si taun i atailai. ");
INSERT INTO lcm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Using si taun ang ka atogon a mamaiten tavirimok na kapo laba luai ani keve mamaiten le si tutapong i kuli rina tung si taun ke, na aimung kapa. ");
INSERT INTO lcm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Si man a taun ang God parik kapa vil akudik ia, ka kovek luai ta sikei e kuli rina ka sapang. Sikei using kana vap i la songo, asukang a ka vil akudik ia. ");
INSERT INTO lcm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Si taun ang, man a mangsikei kapo antok imi ta, ‘Arai, kana na igenen i akanangai,’ vo ‘Sukana ninia,’ mi ago ta lomlomon an tatana. ");
INSERT INTO lcm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Using ka atogon a keve igenen i akanangai kapau na keve kus amalangas kapau ki tapasuk na ki abis a keve akanangai ve keve bil i vilvil ataping lava si kari atokngai alava asi kari ausingai alok ani ri vap ila songo. ");
INSERT INTO lcm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mi longong. Kana napo mengen imi. ");
INSERT INTO lcm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Asukang na man ki antok imi ta, ‘Arai, kapo ago nei ring varasai palau,’ mi ago ta pasal an si an arai. Vo man ki antok ta, ‘Arai, kapo ago mumun nei lu,’ mi ago ta lomlomon an ta mengen ang. ");
INSERT INTO lcm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Using a igenen i pukun si kana taun i serei ka bil val tapak kapo takrimit le mang ngising taun a mang palpal. ");
INSERT INTO lcm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Si oring ang a matmat kapo matung vok singina, ri kol kianpo ngangasinong kuvul e iang. ");
INSERT INTO lcm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","E mung palau i keve mamaiten lava i taun ang, makarap ka vong gup, na ulen parik kapa anguan mang an, na ri kalto ki uak le metekuku na keve kitmat i metekuku ki mimo. ");
INSERT INTO lcm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Le na akanangai i igenen i pukun ka serei e metekuku na mamain ta pat vap i kuli rina ki tangis na ki arai ani igenen i pukun ka serei kuli kuku ta kitmat na maumausan tavirimok. ");
INSERT INTO lcm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Na ka asok kana mamain ta angelo ta tangis i taungai lava na kian songo akuvul aongos kana vap i la songo le si keve palpal aongos i kuli rina na metekuku. ");
INSERT INTO lcm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Mi luk malangas si laulauan i ri suke. Man kala urung atanginang, mila kinle ta taun sinang roron kalapo angasungai. ");
INSERT INTO lcm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na asukang kapa singimi, man mila arai ani keve nem ke kala serei, mila malangas ta kalapo angasungai luai e mete takaman palau ani ka serei. ");
INSERT INTO lcm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Napo antok atutuman imi, kana na matan polpolokan i taun ke parik kipa mat suai aino ani keve bil ke kila serei. ");
INSERT INTO lcm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Metekuku na kuli rina ka tamus suai, sikei kag mengen parik kapa angkoai luai si tamus. ");
INSERT INTO lcm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pangau i taun vo vuk taun ina, kapo kovek i mangsikei kapo nas ia. Ri angelo i metekuku na kana nat parik kipa nas, sikei tamana papalik kapo nas. ");
INSERT INTO lcm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Using kana taun a igenen i pukun ka asukang val taun i Noa. ");
INSERT INTO lcm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Asukang ke ta aino le ani nole, ri vap kitapo angan, kipo inum, kipo angosongon, tung si taun a Noa kala riuklak nei perengan. ");
INSERT INTO lcm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na parik lak kipa nas a sa kame serei tung si taun a nole kala serei na kamela luk suai aniria aongos. Io, ka asukang palau si taun ang man a igenen i pukun ka serei singina. ");
INSERT INTO lcm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Si taun ang, man a pongua na igenen kilongpo ago nei matang, ki songo na mangsikei na mang anu ki atalipai ania. ");
INSERT INTO lcm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Man a pongua na aina kilongpo momong kon, ki luk suai ani mangsikei na mang anu ang ki atalipai ania. ");
INSERT INTO lcm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Asukang a mi usausa using parik mipa nas a taun ang a kami Volava ka serei singina. ");
INSERT INTO lcm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Kana mi malangas ta man a votauk i lu kata nas a vuk taun tenei vong asi serei ta katakai i tainau, kala ararai bat aro ani kana lu na parik kalapa ding ia. ");
INSERT INTO lcm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Asukang na nami kapa mi usausa. Using a igenen i pukun ka serei si vuk taun ang parik mipa lomlomonai ania singina. ");
INSERT INTO lcm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Man a asosokai kapo atutuman na kapo masam, kana lau i abis ka asukang ke. Kana tulava ka asok ia asi aiveven ani kana keve asosokai aongos, asi kana alis aniria ta kari sasagian. ");
INSERT INTO lcm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Au, na man kana tulava kala serei sabonai ani kapo abis ia, ka roron ania. ");
INSERT INTO lcm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Napo mengen atutuman imi ta ka asok ia asi kana aiveven aongos ani kana mamain ta togtogon. ");
INSERT INTO lcm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sikei man a asosokai rikek ang kapo lomon ia asukang ke ta, ‘Kag tulava nang parik kapa serei pok sumasuma,’ ");
INSERT INTO lcm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na kala tutapong sasaup ani mamain ta asosokai, na kapo matan angan na kalapo inum ve ri vap nio, ");
INSERT INTO lcm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kana tulava ka serei pok si taun parik katapa lomlomonai ania singina. Ka serei si taun parik katapa nas ia. ");
INSERT INTO lcm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na kamela tangatangai amitmitlik ia na ka asuai ania ane si ring ang ri katakai i kapau ki an ago singina, na e iang ki tangis na ki ngut ngisa. ");
INSERT INTO lcm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Na si taun ang vainagoan i metekuku ka asukang val sangauli na kavulik tanginang kita luk le kari keve alimang. Na kila pasal si an ruduai ani igenen osongon tanginang. ");
INSERT INTO lcm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Mang palpalima kitapo vap tanio, na mang palpalima kitapo nas. ");
INSERT INTO lcm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Keve tanio ke kita luk le kari keve alimang sikei parik kitapa luk rul i elaio le aniria. ");
INSERT INTO lcm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sikei keve kavulik nas ke kita aulo dong le na kari keve ese kuvul ve kari keve alimang ta rul i elaio. ");
INSERT INTO lcm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Na osongon tanginang ke kalapo amomole na ria aongos kilapo buk rot na kila rodot. ");
INSERT INTO lcm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Na tenei liuan vong mangsikei kala songosongo ta, ‘Longong, osongon tanginang sukana kalapo pakasang! Mime na tara me ruduai ia.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Au, keve kavulik tanginang aongos ang kila tapangun na kila itoiton kari keve alimang asi kari mang aro. ");
INSERT INTO lcm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Au na keve tanio ke kila antok na keve kavulik nas ang ta, ‘A, mi alis ta kamem ring rul i elaio using a kamem keve alimang kilapo buk mat.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Na kila polpol iria ta, ‘Ka ago. Parik kapa angkoai rul i elaio animem na animi kapa. Mi pasal ane singiria kipo atos ta rul i elaio na mian samui ta kami akorong.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Sikei, taun kila pasal sian samui rul i elaio, osongon tanginang ang kala serei. Au na riria voiang kitapo usausa kila palak kuvul ve nia ane si matan angan i pagamau ang. Au na takaman kala akang. ");
INSERT INTO lcm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Au e mung riria kapa kila kun serei pok na kimela antok ta, ‘Volava, ku tavas animem ta takaman!’ ");
INSERT INTO lcm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sikei kala polpol iria asukang ke, ‘Napo mengen atutuman imi ta parik luai napa nas imi.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Asukang a mi aiveven, using parik mipa nas a taun vo inongos i taun. ");
INSERT INTO lcm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Using kapo angkokoai val igenen kata usausa asi kana pasal avunga, na kala songo kana keve asosokai na kala alis iria ta maiten si aiveven ani kana togtogon. ");
INSERT INTO lcm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kala alis a ainoai i igenen ta palpalima na talanto. Mang anu, kala alis ia ta pongua, au na mang anu ta sikei. Kapo alis iritol angkokoai si karitol laulauan i abis. Au le na kala pasal. ");
INSERT INTO lcm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na igenen vopo luk ani palpalima na talanto ang kala pasal na kanla abis tatana na kala asereiai ani mang palpalima. ");
INSERT INTO lcm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Na asukang kapa, igenen vopo kun luk ani pongua ang, kala kun asereiai ani mang pongua. ");
INSERT INTO lcm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sikei vanang a igenen vopo luk ani sikei ang kala pasal na kanla kep nei roe na kanla amunai ani kapkap ang si kana volava. ");
INSERT INTO lcm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Kala taun vunga na karitol volava kala serei pok na kamela vilvil akorong karitol keve avibisan. ");
INSERT INTO lcm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Na igenen vopo luk ani palpalima na talanto ang kala serei kuvul ve mang palpalima pok na kala antok, ‘Volava, kuta alis iau ta mamaiten asi aiveven ani palpalima na talanto. Arai, natala vil asereiai ani mang palpalima na talanto pok.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Na kana volava kala antok ia, ‘Kutala abis aro luai, kag asosokai ro! Kuta atutuman si rukun bil lik palau, na kana vang na atung ua asi kam aiveven ani keve bil miang. Au, kume na kume uruk kuvul ve kam volava.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Na igenen vo luk ani pongua na talanto ang kala kun serei na kala antok, ‘Volava, kuta alis iau ta mamaiten asi aiveven ani pongua na talanto. Arai, natala vil asereiai ani mang pongua na talanto.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Na kana volava kala antok ia, ‘Kala ro luai, kupo igenen abis aro. Kuta atutuman si rukun bil lik palau, na kana vang na atung ua si kam aiveven ani keve bil miang. Au kume na kume uruk kuvul ve kam volava.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Au na igenen vopo luk ani sikei a talanto ang kala serei na kala antok, ‘Volava, natapo nas ta kupo igenen kitmat luai, using kupo paspasuk si ring ang numai parik kutapa sukal singina na kupo lukluk akuvul si ring ang numai parik kutapa sapungai ani ri katui singina. ");
INSERT INTO lcm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Asukang a natapo leng anim na nala pasal na nala amunai ani kam talanto nei roe. Au, arai akorong pok ani kam bil.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Na kana volava kala antok ia asukang ke, ‘Kupo asosokai rikek luai akorong na kupo marangan luai. Kutapo malangas ta nau napo paspasuk si ring ang nau parik natapa sukal singina na napo lukluk akuvul si ring ang nau parik natapa sapungai ani ri katui singina, ingko? ");
INSERT INTO lcm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Using a sa parik kutapa asinong kag kapkap si ring ang kipo apolok kapkap singina, ani man name lapo papok nalapo luk akuvul ia ve mang keve kapkap ila apolokai? ");
INSERT INTO lcm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Kana mi luk pakang ia ta talanto ke na mi alis ia si vopo atogon ani sangauli na talanto ang. ");
INSERT INTO lcm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Using man a si kapo atogon, ki ngaupap ia asi kana duk luai. Na man a si kapo atogon men lik, io, men lik ang kapo atogon ia, ki luk suai vang ania. ");
INSERT INTO lcm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mi asuai ani asosokai rikek ke ane komo ane si ring vong itum ang, voiang kapo atogon tangis na ngut ngisa singina.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Si taun a igenen i pukun ka serei ve urmaus ina na kana keve angelo aongos, ka sinong kuli kana sinsinongan miminaungan. ");
INSERT INTO lcm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Keve matmatan vap aongos kime tu akuvul aongos e matana. Au na kan pagal ri vap ane si pongua na kuvkuvulan asukang val katakai i aiveven sipsip kapo pagal ri sipsip pelek na ri me. ");
INSERT INTO lcm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Le na kala atung a ri sipsip ane si kana palso na ri me ane si kana palkais. ");
INSERT INTO lcm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Au na tulava kala antok iria kipo ago si palso ina ta, ‘Mi me, nami na mamai katala atautauia imi, mime na mime luk a vainagoan ke voiang katala usausa ia animi si taun i asisinong ani kuli rina. ");
INSERT INTO lcm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Using natapo buk angan, na mila ali pok iau asi kag angan. Na natapo buk inum na mila alis laman anig. Natapo igenen sokoung na mila songo alak iau. ");
INSERT INTO lcm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Natapo varas na mila akavat iau. Natapo malepen na mila aiveven iau. Natapo ago nei vilvil akui na mimepo serei sime arai anig.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Au na keve vap korong ang kila sui ia ta, ‘Au Volava, angisan vanang namemta arai anim sipo buk angan na namemla lis pok ua, vo kutapo buk inum na namemla alis laman anim? ");
INSERT INTO lcm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Na angisan kapa namemta arai anim si sokoung na namemla songo alak ua na kutapo varas na namemla akavat ua? ");
INSERT INTO lcm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na angisan kapa namemta arai anim sipo malepen na kutapo ago nei vilvil akui na namemla pasal sian arai anim?’ ");
INSERT INTO lcm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Na tulava kala polpol iria asukang ke, ‘Napo mengen atutuman imi ta saka keve bil an mitapo abis ia si saka igenen mailik an voiang kapo tasig, nang mitapo abis ia singig.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Au na kala antok a vap ang e palkais ina ta, ‘Mi pasal suai anig, nami ang milapo atogon amiming ane nei kut po ni asikei voiang kitala usausa ia ani vo petau kuvul ve kana keve angelo. ");
INSERT INTO lcm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Using natapo buk angan na parik mipa lis pok anig, na natapo buk inum na parik mipa lis laman anig. Natapo sokoung na parik mipa songo alak iau. ");
INSERT INTO lcm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Natapo varas na parik mipa akavat iau. Natapo malepen na napo ago nei vilvil akui na parik mipa aiveven iau.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Na kila kun sui ania ta, ‘Au Volava, angisan vanang namemta arai anim sipo buk angan na buk inum na sosokoung na sipo varas na sipo malepen na sipo ago nei akangbat na parik namempa pakangai anim?’ ");
INSERT INTO lcm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Na kala antok iria, ‘Napo mengen atutuman imi ta saka keve bil an parik mitapa abis ia si saka igenen mailik an, nang mitapo tav abis ania singig.’ ");
INSERT INTO lcm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Au na kila pasal ane si kui asikei. Sikei ri vap korong kila pasal ane si to asikei.” ");
INSERT INTO lcm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Au, Iesu kala kamus ta posong ani keve mengen aongos ang na kala mengen kana keve nat i akalit asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mipo malangas ta kalapo pongua na taun lak ani Liuluai. Au na igenen i pukun kian alis ia asi kari an atakuk ania kuli ngakputuk.” ");
INSERT INTO lcm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Au na keve ainoinoai si ri katakai i sula ve ri vap lava kimela sinong kuvul nei lu lava si ainoai i katakai i sula, kana asan ta Kaiapas. ");
INSERT INTO lcm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Na kilapo lilimukai asi kari kong mumun ani Iesu na ki vil punuk ia. ");
INSERT INTO lcm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Sikei kila antok ta si taun i matan angan ka ago vei nganing ri vap ki visvis. ");
INSERT INTO lcm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Au, taun ang a Iesu kanlapo ago e Betania nei lu si Simon vo tapak ke. ");
INSERT INTO lcm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mangsikei a aina kamela serei singina na kapo teng kana ese sain ro na kapo samui lava. Na kamela tilingai ania e patuna si taun ang katapo sinong si angan. ");
INSERT INTO lcm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Taun a keve nat i akalit kila arai ani bil ke kila songag na kilapo sui, “Kapo saka kamus palau an na bil ke? ");
INSERT INTO lcm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Laman sain ke kapo angkoai si atos aro tatana na alis ani ri logo ta samui ina.” ");
INSERT INTO lcm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Na Iesu kalapo malangas a bil suke na kala antok iria, “Marai sa na mipo mengen arikek ani aina ke? Kana kapo abis a mangsikei a bil roron luai anig. ");
INSERT INTO lcm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Arai, mi uli ago lak ve ri vap logo, sikei nau parik napa uli ago ve nami. ");
INSERT INTO lcm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Io, aina ke kata tilingai ani laman sain ke e pukun ig asi usausa anig ani mo. ");
INSERT INTO lcm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Napo antok atutuman imi ta si saka ring an kuli rina ki akuskus ta akus ro ke, akuskus kapa i sa na aina ke kata abis ia ki kun akuskus kapa tatana asi rungrungai ania.” ");
INSERT INTO lcm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Au na Iudas Iskariot, mangsikei i 12 na nat ang, kanla serei si ri ainoinoai si ri katakai i sula ");
INSERT INTO lcm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na kanla susuiai aniria ta, “Mi alis iau ta sa man na alis suai ania e kungami?” Na kila taot dong ia ta 30 na vuk silva. ");
INSERT INTO lcm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Le si taun ang kalapo gusgus ta saka pangau an kapo kalakala si alis suai ania e kungaria. ");
INSERT INTO lcm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Au, si ainoai i taun i saui i tav tol, keve nat i akalit kimela serei si Iesu na kila sui ia ta, “Nei a ring ang kupo buk ani namem itoiton anim singina si teng ani Liuluai?” ");
INSERT INTO lcm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Na kala antok ta, “Mi palak ane nei rina na mian serei si tungara na mian antok ia asukang ke, ‘Katakai i akalit kata antok ta kag taun i atutung kalapo angasungai, na napo buk teng ani Liuluai ve kag keve nat i akalit nei kam lu.’” ");
INSERT INTO lcm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Asukang na keve nat ang kianla vil ia val Iesu kata atatai iria na kianla itoiton a Liuluai. ");
INSERT INTO lcm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Si tenei ngelik i taun ang kamela sinong si pata i angan kuvul ve sangauli na pongua na nat i akalit. ");
INSERT INTO lcm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Au na si taun ang kipo angan kala antok iria, “Napo antok atutuman imi ta mangsikei imi ka alis suai anig taun a saupai.” ");
INSERT INTO lcm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Na kilapo mamakus alava na siksikei iria kalapo sui ia ta, “Vei nau nganing, ingko Volava?” ");
INSERT INTO lcm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Na kala antok ta, “Iuang vopo auai abui saui ang nei gapai ke kuvul ve nau, ninia vanang ka alis suai anig. ");
INSERT INTO lcm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Igenen i pukun ka puka val kitala salik aino tatana, sikei ka rikek luai ani vo alis suai ang ani igenen i pukun. Pat ka ro ania man parik kitapa ingus ia.” ");
INSERT INTO lcm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Au na Iudas, voi si alis suai ang ania, kala antok ta, “Katakai i akalit, nau nang parik ingko?” Na kala antok ia ta, “Numai akorong kupo posong ia.” ");
INSERT INTO lcm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Au, kilapo angan na Iesu kala luk a saui, kala posong aro singina na kala tevek ia na kala lilis aliu kana keve nat i akalit velai ani mengen ke, “Mi luk na mi angan. Kana na pukun ig.” ");
INSERT INTO lcm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Le na kala luk a kavi na kala posong aro singina na kala alis iria na kala antok, “Nami aongos mi inum singina. ");
INSERT INTO lcm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Using kana na rangaig ani angainainakai, na ka saling ani vap miang asi lomon suai ani kari keve lau rikek. ");
INSERT INTO lcm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Napo antok imi ta parik napa anguan inum an si laman i vaen ke, tung si nakan inum ia si selen tanginang ve nami nei kana vainagoan a mamai.” ");
INSERT INTO lcm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Au na kila tangam kari sikei a tangam le na kila soung taun a mulang Elaio. ");
INSERT INTO lcm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Au na Iesu kanla antok iria ta, “Nami aongos mi savang marai ig nganlak vong, using kitala salik ia ta Na nga punuk na katakai i aiveven sipsip na keve sipsip ki tamale angtaliungai. ");
INSERT INTO lcm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Sikei e mung i kag la tadut pok le naka aino imi ane Galilaia.” ");
INSERT INTO lcm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Na Petero kala antok amadot ia ta, “Riria aongos ki savang marai im, sikei nau parik luai napa angkoai si savang.” ");
INSERT INTO lcm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Na Iesu kala antok ia, “Napo antok atutuman ua ta aino le ani pura ka tirtiriku nganlak vong, ku amatan potol a agel suai anig.” ");
INSERT INTO lcm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Na Petero kala antok ia ta, “Kantanem si man nakan mat ve numai, sikei parik luai napa angkoai si agel suai anim.” Keve nat i akalit aongos kila kun antok asukang. ");
INSERT INTO lcm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Au le na Iesu kala pasal ve ria ane si mang vuk ring kipo kin ia ta Getsemani, na kala antok iria, “Mi sinong e ke na nakan sokotuk tapai e oring suke.” ");
INSERT INTO lcm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na kala songo le na ri Petero ve ngono angtasimal si Sebedaio na kalapo nasai ani maiten tavirimok na ngau laba luai. ");
INSERT INTO lcm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Na kala antok iritol ta, “Makus lava ke kalapo rongos iau angasungai ani naka mat. Mitol ago e ke na mitol para kuvul ve nau.” ");
INSERT INTO lcm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Au na kala paliu avunga lik na kanla matung turung ane vunep i sokotuk, “Mamai, si man kapo angkoai, kapo ro ani kavi ke ka papelek iau. Sikei, vubuk ke singig ka ago, sikei ku using kam vubuk.” ");
INSERT INTO lcm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Au kanla serei pok si volo nat ang kitolapo rot, na kala sui a Petero, “Au sa, parik mitolpa angkoai si para ve nau ani vuk pangau kudik palau? ");
INSERT INTO lcm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mitol aiveven na sokotuk, vei atoktokngai ka luk imi. Malanganto kapo naung sikei pukun kapo ngau.” ");
INSERT INTO lcm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Na kala anguan papok si an sokotuk na kanla sokotuk asukang ke, “Mamai, si man parik kapa angkoai si luk suai ania tung si nala inum akorong le singina, kapo ro ka asukang val kam vubuk.” ");
INSERT INTO lcm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Taun kamela serei pok kamela arai ta kitol lapo rot punuk using a mataritol katapo maiten. ");
INSERT INTO lcm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Asukang na kala anguan papelek an aniritol na kanla vapotol i sokotuk val aino. ");
INSERT INTO lcm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Au le na kamela serei pok si volo nat ang na kala antok iritol, “Au sa, mipo rot lak, na mipo ausai lak? Mi arai, taun kana kala serei ani ki alis a igenen i pukun ane kungaria i ri vap bil arikek. ");
INSERT INTO lcm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mitol tadut na tara pasal. Arai ani iuang kana kalapo serei asi kana me alis suai anig.” ");
INSERT INTO lcm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Taun kapo mengen lak, Iudas kala serei, mangsikei i 12 na nat ang, na petau laba luai kipo aimung ina na kipo teng ri samele na ri avam, i la asok tapai ta keve ainoinoai si ri katakai i sula ve ri vap lava i rina. ");
INSERT INTO lcm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Vo alis suai ania katala antok amalangas lenginang iria ta mang akanangai asukang ke, “Si man na lulus a si, ninia palau vanang a igenen ang. Mi teng akit ia.” ");
INSERT INTO lcm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Au, kala paliu akorong taun a Iesu na kanla antok, “Kala ro luai, rabi,” velai ani kala lulus ia. ");
INSERT INTO lcm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Na Iesu kala antok ia, “Tungag, ku vil apunuk kam abis kuta serei using ia.” Au na kila tung akasang na kila teng akit a Iesu. ");
INSERT INTO lcm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Si vuk taun ang akorong mang sikei vo auai ang ve Iesu kala dal kana samele na kala tanga suai luai ani talingana i asosokai si ainoinoai i katakai i sula. ");
INSERT INTO lcm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Na Iesu kala antok ia ta, “Ku sulai pok ani kam samele si kana oring, using si kapo dal kana samele ka mat pok singina. ");
INSERT INTO lcm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kupo lomon ia ani parik napa angkoai si aikut papakangai si mamai ani kana palau ka alis suai ane singig ta 12 na kuvkuvulan lava i visvis si ri angelo? ");
INSERT INTO lcm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sukana na mengen i nei salsalik ka saka serei apunuk an vanang ta ka serei asukang ke?” ");
INSERT INTO lcm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Au na kala mengen taun a petau ang, “Au si napo katakai i tainau na kana mipo ruduai iau ta samele na avam? Si keve taun natapo vil akalit nei rina i atailai na parik mitapa teng akit iau. ");
INSERT INTO lcm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sikei kana kapo serei asukang ke si vil apunuk ani keve salsalik si ri katakai i kus amalangas.” Na kana keve nat i akalit aongos kila papelek ia na kila sip suai. ");
INSERT INTO lcm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Vap teng akit ang ani Iesu kila tak ia ane si Kaiapas kapo ainoai i katakai i sula. E iang ri vap malangas ani saupai ve ri vap lava i rina kitan lapo ago kuvul. ");
INSERT INTO lcm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Na Petero katapo using avunga, e nei nan komo si ainoai i katakai i sula. Katapo buk arai aro ani akamusai ina, asukang na kala palak na kanlapo sinong ve ri vap ararai bat. ");
INSERT INTO lcm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Au, keve ainoinoai si ri katakai i sula ve kuvkuvulan lava ipo vil saupai kitapo gule vap asi mengen kapau angkoai asi kari saupai ani Iesu singina using kitapo buk raung ania. ");
INSERT INTO lcm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sikei parik kitapa sabonai ta mangsikei a bil kantanem a poisan a vap kitapo asuai ani kari keve kalinga kapau ania. Au le na mang ngono anu kilong mela tung ");
INSERT INTO lcm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","na kilongla antok ta, “Ike kata antok asukang ke, ‘Napo angkoai si galang ani lu i atailai si God na naka atung pok ia si potol a taun.’” ");
INSERT INTO lcm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Au na ainoai i katakai i sula kala tapasuk na kala antok, “Au sa parik kupa ngenget a mengen suke? Au sa sukana si atugtugi suke kilongpo mengen anim tatana?” ");
INSERT INTO lcm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sikei Iesu kapo tung musik palau. Au na ainoai i katakai i sula kala antok, “Napo nung amalangas luai anim si asan i God vopo to ke ta ku antok amalangas imem ta numai kana na igenen i akanangai? Numai a nat i God?” ");
INSERT INTO lcm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Na Iesu kala antok ta, “Val kupo posong ia. Sikei napo antok imi ta kana vang le si taun ke mi arai ani igenen i pukun kan sinong e palso i vo kitmat na ka pasiang kuli kuku le pangkul.” ");
INSERT INTO lcm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Na ainoai i katakai i sula kala ding pok kana maus na kala antok, “Ike lik kalapo mengen i nau varas ani God. Kalapo kovek luai i mang mengen tarapo inongos taun ia. Mitala longong kana mengen i nau varas ani God. ");
INSERT INTO lcm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nei kami lomlomonai?” Na kila polpol ta, “Kalapo ago asi vil punuk ania.” ");
INSERT INTO lcm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Au na kila kanus a nona na kipo nak ia. Mang matan kipo tava ia ");
INSERT INTO lcm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na kipo antok, “Au, igenen i akanangai, ku kin vang. Si akorong kata tava ua?” ");
INSERT INTO lcm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Si vuk taun ang Petero katapo sinong nei nan komo na mang kavulik asosokai kamela serei na kala antok ia, “Numai kapa, kutapo auai ve Iesu ke le Galilaia.” ");
INSERT INTO lcm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sikei Petero kala gel e mataria aongos ta, “Parik nang napa nas a sa kupo mengen tatana.” ");
INSERT INTO lcm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Le na kala pasiang ane mete sokosiangan na mang kavulik kala arai ania na kala antok a keve vap ang e iang ta, “Ike kana katapo kun auai ve Iesu ke le Nasaret.” ");
INSERT INTO lcm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Na kala anguan gel an velai ani atutuman serei si God ta, “Parik nang napa nas a igenen ang!” ");
INSERT INTO lcm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Au na e mung lik palau, vap vo angtung aliu ang e iang kila antok ia ta, “Tutuman luai, numai kapa kupo mangsikei iria using a kalingam kapo akalit amalangas luai tatam.” ");
INSERT INTO lcm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Na kalapo mengen ta man kapo kapau kapo ro ka mat na kala atuvala ta, “Parik napa nas a igenen ang.” Na si vuk taun ang palau pura kala tirtiriku. ");
INSERT INTO lcm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Au na Petero kala lomlomonai pok ani mengen ang si Iesu ta, “Aino le ani pura ka tirtiriku kula amatan potol a agel suai anig.” Na kala soung ane komo na kanla tangis alava luai. ");
INSERT INTO lcm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Au, kala tenei vauk na keve ainoinoai si ri katakai i sula aongos ve keve vap lava i rina kila serei si mangsikei a lomlomonai si raung ani Iesu. ");
INSERT INTO lcm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Na kila got ia na kila takai ania asi an alis suai ania e kungana i Pilato, igenen lava vopo sausaupai ani ring ang. ");
INSERT INTO lcm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Na Iudas, igenen vopo alis suai ke ani Iesu taun a saupai, kala arai ani Iesu si lapo tung nei saupai sian mat na kala kinle kana lau rikek na kala alis pok na 30 na vuk silva i seu ang ania ane si keve ainoinoai si ri katakai i sula ve ri vap lava ");
INSERT INTO lcm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","na kala antok iria ta, “Natala bil arikek, using natala alis suai ani igenen daus ke.” Na kila antok ia ta, “Au na namempo togon saka maiten an singina? Kakam akorong ta maiten.” ");
INSERT INTO lcm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Na kala so ta kapkap ang nei rina i atailai na kala pasal na kanla koit papalik. ");
INSERT INTO lcm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Na keve katakai i sula ang kila luk a kapkap ang na kila antok ta, “Parik kapa korong si saupai ta tara asinong na kapkap ke nei ring ipo asisiang kapkap using kapo kapkap i seu ani to si igenen.” ");
INSERT INTO lcm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na kila ainak aongos si luk ani kapkap ang si kari an samui ani vuk roe ang si igenen pulpul asi kepai ani ri vap sokoung e iang. ");
INSERT INTO lcm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Asukang vang na kilapo posong na vuk roe ang ta roe i daung tung si taun ke. ");
INSERT INTO lcm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","E iang vanang a mengen ang si Ieremias katakai i kus amalangas kala serei atutuman, Na kila luk a 30 na vuk kapkap ang, samui i atung ang ania ta ri vap i Israel ");
INSERT INTO lcm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","na kila samui na vuk roe ang si igenen pulpul, val Volava katala asok iau. ");
INSERT INTO lcm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Au, na Iesu kalapo tung e matana i igenen lava vo sausaupai ke na kala sui ia, “Au numai a tulava si ri Iudaia?” Na Iesu kala antok ia ta, “Numai kupo kin ia.” ");
INSERT INTO lcm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Na taun a keve ainoinoai si ri katakai i sula ve ri vap lava kilapo posposo amaiten ia parik luai kapa polpol iria. ");
INSERT INTO lcm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Na Pilato kala sui ia, “Kupo longong sukana na keve mengen suke kipo pege anim tatana?” ");
INSERT INTO lcm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Na Iesu parik luai kapa polpol a mangsikei i keve vuk mengen ang, na igenen lava ke kalapo taping singina. ");
INSERT INTO lcm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na igenen lava ke kapo uli atogon ani vuk lau i asoung ani mang igenen pelek ani vilvil akui si taun i matan angan, voiang kapo pasal le si pipilak si ri vap. ");
INSERT INTO lcm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Si taun ang katapo atogon a mangsikei a igenen nei vilvil akui ipo nas aongos ta ri vap, kana asan ta Barabas. ");
INSERT INTO lcm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Na taun ang na petau ang kime lapo tung akuvul aongos, Pilato kala sui iria ta, “Mipo buk a si i ngono ike ani naka akala ia, Barabas vo Iesu, voiang kipo kin ia ta igenen i akanangai?” ");
INSERT INTO lcm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Using kapo nas ta kita alis suai ania using kitapo vinga rikek. ");
INSERT INTO lcm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Au, si taun ang kapo sinong si kana sinsinong i saupai, kisngana kala ali mengen ane singina ta, “Ku ago ta bil an ta mang sikei a bil si igenen korong ke, using anginang vong mang orodung kata vil arikek luai anig marai ina.” ");
INSERT INTO lcm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sikei, keve ainoinoai i ri katakai i sula ve ri vap lava kipo asok akit a petau ke si antok ta akala na Barabas na vil punuk a Iesu. ");
INSERT INTO lcm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Na igenen lava ke kala sui iria ta, “Mipo buk a si i ngono ike ani naka akala ia dong imi?” Na kila antok ta, “Barabas.” ");
INSERT INTO lcm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Na Pilato kala sui, “Au na naka vil sa vang kana ani Iesu, voiang kipo kin ia ta igenen i akanangai?” Na kila antok, “Atakuk ia!” ");
INSERT INTO lcm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Na kala antok ta, “Marai sa? Saka rikek an akorong kata abis ia?” Sikei kilapo anguan songosongo alaba luai an ta, “Atakuk ia!” ");
INSERT INTO lcm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Si taun ang a Pilato kalapo arai ta kalapo tav angkoai si gel aniria na kalapo arai kapa ta angvis kalapo buk tutapong, kala kap laman na kala sunep a kungana e mataria i petau aongos ang na kala antok, “Nau napo kala si rangai ina i igenen ke. Nami akorong mi maiten singina.” ");
INSERT INTO lcm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na vap aongos ang kila polpol ia ta, “Rangai ina aongos kapo ro namem nem sunguk ia ve matan inatus ang e mung imem.” ");
INSERT INTO lcm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Na kala akala na Barabas dong iria. Na kala asok si sasaup ani Iesu, na kala alis suai ania asi kari ani atakuk ania kuli ngakputuk. ");
INSERT INTO lcm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Na kana keve vap ipo visvis na igenen lava ke kila tak alak a Iesu ane nei nan komo lava na kian lapo tung aulitai aongos ania. ");
INSERT INTO lcm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na kila luang kana maus na kila alak ia ta vuk vakup miminaungan. ");
INSERT INTO lcm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na kila abis a kuku ta angus sisilo na kila agon ia e patuna val kuku i tulava. Na kila atung a vukei e palso i kungana na kipo sovusulai e matana na kipo mengen i kurek ania ta, “Pua, kala ro luai, tulava si ri Iudaia!” ");
INSERT INTO lcm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Na kipo kanus ia na kipo luk a vukei ang na kipo saup ia e patuna. ");
INSERT INTO lcm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Si taun kila kamus ta kurek ania kila luang suai pok ani vakup miminaungan ang na kila alak akorong pok ia ta kana maus. Au na kila tak ia si kari an atakuk ania kuli ngakputuk. ");
INSERT INTO lcm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Si taun kipo soung, kila duai a mangsikei a igenen i Kurene, kana asan ta Simon, na kila asok palau ia si kana asalak ani kana ngakputuk na Iesu. ");
INSERT INTO lcm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na kianla serei si mangsikei a vuk oring kipo kin ia ta Golgota, supsupai ina ta vangang kumut. ");
INSERT INTO lcm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na kila alis ia ta laman i vaen mimirikukan si kana inum. Sikei taun kata namnamin ia, kala misag ani inum ania. ");
INSERT INTO lcm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","E mung i kari la atakuk tapai ania, kilapo gulang angkasai asi arai ta ki saka pagal an ani kana maus aniria. ");
INSERT INTO lcm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Na kipo sinong na kipo ararai ania. ");
INSERT INTO lcm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na kila atung a mang vuk salsalik i saupai ang ania e pangkul i patuna na kapo mengen asukang ke, “Kana na Iesu, kapo tulava si ri Iudaia.” ");
INSERT INTO lcm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na mang ngono katakai i tainau kita atakuk irilong ve nia, sikei e palso na mang anu e palkais ina. ");
INSERT INTO lcm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Na vap po pasal angpok ang e iang kipo mengen i asosol ania na kipo valai ani paturia ");
INSERT INTO lcm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na kipo antok, “Numai vo antok ke ta ku galang na rina i atailai na ku atung pok ia si potol a taun, ku asapang pok vang ua. Si man kupo nat i God, au pasiang suai ani ngakputuk ang.” ");
INSERT INTO lcm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Asukang kapa na ri ainoinoai si ri katakai i sula ve ri vap malangas ani saupai na ri vap lava kapa kipo kun kurek ania asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Katala asapang a mang vap, sikei parik kapa angkoai si asapang pok ania. Nia na tulava i Israel. Au kanat, ka pasiang suai kotok ani ngakputuk ang na tarala lomlomon vang tatana. ");
INSERT INTO lcm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nia kapo lomlomon ta God. Au ago ani God na kame pakangai ania kana vang si man kapo buk pok ia. Using kata antok ta, ‘Nau napo nat i God.’” ");
INSERT INTO lcm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na ngono katakai i tainau kita atakuk kuvul irilong ve nia, kilongpo kun mengen arikek ania asukang. ");
INSERT INTO lcm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Vuk taun ke katapo mang ias lava, sikei vong kala pakut a kuli rina aongos tung si kalapo ngelik aliu. ");
INSERT INTO lcm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Au si kalapo ngelik, Iesu kala songosongo alava ta, “Eli, Eli, lama sabakatani?” supsupai ina ta, Kag God, kag God, marai sa kulapo papelek iau? ");
INSERT INTO lcm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na mang matan i vap po angtung ang e iang kila longong ia na kilapo antok ta, “Igenen ke kapo songo na Elias.” ");
INSERT INTO lcm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Na mangsikei iria kala sang sumasuma na kanla luk a vuk rudum na kanla abui le ia nei vaen namin mal na kala sulai alak ania kuli vuk vukei ani Iesu si kana inum. ");
INSERT INTO lcm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sikei kila antok ta, “Kokoai, tara arai kotok ta Elias kame asapang ia.” ");
INSERT INTO lcm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Na Iesu kala anguan songosongo alava an, le na kala atolongon suai ani malanganto ina. ");
INSERT INTO lcm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na si taun ang, vakup ang nei lu i atailai kala tading angtaliungai le pangkul tung e kevkev. Kuli rina kata arukruk na ri at kita tatadek. ");
INSERT INTO lcm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri mata i matmat kita tavas na amiang iria vap lomlomon kitala mat, kita tadut pok. ");
INSERT INTO lcm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Na e mung i kana tadut pok a Iesu, kita soung pelek na ring si ri vap mat na ki pasal ane nei rina gogoai na kime lapo tutu aserei si vap miang. ");
INSERT INTO lcm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Na taun a ainoinoai si ri katakai i visvis ve kana keve vap ipo aiveven ke si Iesu kita arai ani vunep si arukruk na keve bil vo serei aongos si taun ang, kilapo leng alava na kilapo mengen ta, “Tutuman luai, kana na nat i God.” ");
INSERT INTO lcm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na mang keve aina miang kitapo kun ago avunga lik e iang ipo kalkalum kapa. Keve aina ke kita auai ve Iesu le Galilaia using kitapo buk aiveven ania. ");
INSERT INTO lcm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nei liuan iria, ri Maria Magdalene ve mang Maria ang rinarilong i ri Iakovo ve Iosep, na rinarilong i ngono nat ang si Sebedaio. ");
INSERT INTO lcm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Au, kalapo ngelik luai na mangsikei a igenen tauia le Arimataia kana asan ta Iosep, na kapo mang nat i akalit si Iesu, kala serei ");
INSERT INTO lcm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","na kala pataun a Pilato na kanla aikut ia ta pukun ina i Iesu. Na Pilato kala asok si alis ania tatana. ");
INSERT INTO lcm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Na Iosep kala luk a pukun ang na kala pakut aro ia ta mang vakup tanginang ro luai. ");
INSERT INTO lcm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Na kanla amatung ia nei kana mata tanginang akorong, kata se ia nei bang. Na kala ul bat na mata ang ta mangsikei a at tavirimok lava na kala pasal. ");
INSERT INTO lcm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Na ri Maria Magdalene ve mang Maria ang kilongtapo kun sinong e ngising ina i mata ang. ");
INSERT INTO lcm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Au, si taun using ina, e mung palau i taun i usausa, keve ainoinoai si ri katakai i sula ve ri Parisaio kila kivung ve Pilato ");
INSERT INTO lcm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","na kila antok ia ta, “Volava, namempo lomlomonai lak ani kana mengen na igenen kapau ke si taun katapo to lak ta, ‘E mung i potol a taun na tadut pok.’ ");
INSERT INTO lcm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Asukang na namempo buk ani ku asok ani ki vil bat aro na mata ke si kana kit aro tung si vapotol i taun, vei nganing kana keve nat i akalit kimela tainau na pukun ina na kianla antok ri vap ta katala tadut pok. Na kapau ke kala aunai laba ani kana keve kapau aino ang.” ");
INSERT INTO lcm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Na Pilato kala antok iria ta, “Kanat, mi songo le ta kag mang petau ipo ararai bat na kian aiveven aro na mata ang val mipo buk ia.” ");
INSERT INTO lcm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Au na kila pasal na kianla atung a keve igenen ang si mata ang na kila atung a mang akanangai i tubat kuli at ang. ");
INSERT INTO lcm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Si no i tangat si taun tanginang e mung i taun i atailai, ri Maria Magdalene ve mang Maria ang kilongla pasal sian arai ani mopong ang. ");
INSERT INTO lcm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Au, kosan ta arukruk kitmat lava kala serei using a angelo le metekuku kata pasiang na kamela ul suai ani iat ang na kanlapo sinong lakat kuluna. ");
INSERT INTO lcm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na miminaungan i pukun ina kapo asukang ta malangas i tapak na kana maus kapo kun aunai posok luai. ");
INSERT INTO lcm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Na vap po aiveven aulitai ani mata ang kilapo nei miringan ania na kipo tetek na kilapo asukang val ri vap mat. ");
INSERT INTO lcm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Na angelo ang kala antok na ngono aina ke ta, “Milong ago ta leng an, napo nas ta milongpo gule using a Iesu, voiang kita atakuk ia kuli ngakputuk. ");
INSERT INTO lcm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Kapo kovek e ke, using katala tadut pok val katala mengen. Au milongme arai akorong ani kana ring i matung. ");
INSERT INTO lcm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Au, milong sumasuma na milongan atai amalangas kana keve nat i akalit ta katala tadut pok pelek a mat, na longong aro, ka pasal aino imi ane Galilaia, na mian arai ania e iang. Kana nala antok imilong.” ");
INSERT INTO lcm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Na ngono aina ke kilongla sang pelek na mata i matmat ang kuvul velai ani leng sikei lak kilongpo togon na uruk lava. Na kilongla angsasangai sian antok amalangas ani kana keve nat i akalit. ");
INSERT INTO lcm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Taun kilongpo sang aliu, Iesu kala tutu aserei singirilong na kala tenei vauk irilong. Na kilongla pasal taun ia na kilongla soturungai singina velai ani ngaulot ani ngono kakina. ");
INSERT INTO lcm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Na kala antok irilong ta, “Milong ago ta leng an. Milong pasal na milong an atai na keve tasig asi kari pasal ane Galilaia, na e iang kian arai anig.” ");
INSERT INTO lcm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Taun a ngono aina ke kilongpo pasal aliu lak, mang matan ipo ararai ani mata i mat ang kila palak pok ane nei rina na kianla atatai na keve ainoinoai si ri katakai i sula ta keve bil aongos voiang kata serei. ");
INSERT INTO lcm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Au na keve ainoinoai si ri katakai i sula ve keve vap lava kila sinong kuvul le na kila alis atavirimok i kapkap taun a ri vap ipo aiveven ani mata ang, ");
INSERT INTO lcm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na kila antok iria ta, “Mi mengen asukang ke ta, ‘Namem tala rot punuk na kana keve nat i akalit kimela serei tenei vong na kimela ainau le na pukun ina.’ ");
INSERT INTO lcm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Au na man a ainoinoai lava vo sausaupai ani rina ke ka longong a akuskus ke namem nem vil akorong ia, na nami parik milapa angkoai si tung nei sausaupai.” ");
INSERT INTO lcm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Asukang na kila luk le na kapkap ke na kianla abis asukang palau val kitala atatai iria. Na atugtugi ke kala pasal apapanai aongos nei liuan i ri Iudaia tung si taun ke. ");
INSERT INTO lcm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Au, sangauli na sikei a nat i akalit ang kila pasal ane Galilaia ane si mulang ang a Iesu katala asok iria si kari pasal taun ania. ");
INSERT INTO lcm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Si taun ang kila arai ania kila soturungai serei singina, sikei mang matan iria kitapo ilung. ");
INSERT INTO lcm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Au na Iesu kamela pataun iria na kala pinipini iria asukang ke, “Kitala alis iau ta kitmat ani naka saupai ani keve bil aongos i metekuku na ani kuli rina kapa. ");
INSERT INTO lcm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Asukang na mi pasal ane si saka matan vap an i kuli rina aongos na mi akalit iria asi kari using anig. E iang mi asing tauia iria ta asan i mamai na ta kana nat na ta Malanganto Gogoai. ");
INSERT INTO lcm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Na e iang kapa mi akalit iria asi kari using aongos ani keve pinipini ang natala alis imi tatana. Mi longong aro, nau naka uli auai ve nami tung si akamusai i kuli rina ke.” ");
INSERT INTO lcm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kana na tutapongai i akus ro ani Iesu Karisto, nat i God, ");
INSERT INTO lcm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","val kita salik ia nei buk si Esias, katakai i kus amalangas, Arai, naka asok kag asosokai aino anim ani kan itoiton selen anim. ");
INSERT INTO lcm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kalingana i mangsikei kapo songosongo nei ring varasai palau ta mi usausa na selen ani Volava, mi itoiton ta selen korong ania. ");
INSERT INTO lcm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ioanes katakai i asing tauia katapo ago nei ring varasai palau, na kapo akuskus ri vap ta ki luk a asing tauia asi akanangai ani kari la lomon pokai na God ka lomon suai ani kari keve lau rikek. ");
INSERT INTO lcm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Na ri vap aongos i palpal Iudaia na Ierusalem kita pasal taun ia na kianla mengen amalangas ta kari keve lau rikek na kala asing tauia iria si sung ang Iordanes. ");
INSERT INTO lcm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ioanes katapo alak na vakup kita abis ia ta ung i kamel na katapo ngenge ta pauk i vongo, na katapo pok ta bivo na murungan. ");
INSERT INTO lcm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Na katapo akuskus asukang ke, “Aimung ig kapo atogon a mangsikei ka serei lak, kapo tavirimok anig, napo tav ro angkoai ve asosokai palau vopo sovusulai si luk suai ani pauk i kakina. ");
INSERT INTO lcm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nau natala asing tauia imi ta laman, sikei ninia ka asing tauia imi ta Malanganto Gogoai.” ");
INSERT INTO lcm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Si taun ang Iesu kala papelek a Nasaret si palpal Galilaia, na Ioanes kamela asing tauia ia si sung ang Iordanes. ");
INSERT INTO lcm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na akorong palau si taun ang kapo kiklak le nei laman, kala arai ani metekuku kala tavas na Malanganto kala pasiang taun ia asukang val uk. ");
INSERT INTO lcm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Na kalinga kala serei le metekuku ta, “Numai kag nat ro. Napo buk alava ua. Napo uruk luai anim.” ");
INSERT INTO lcm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nang palau Malanganto kala asok ia ane nei ring varasai palau. ");
INSERT INTO lcm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Na kanla ago nei ring varasai palau ani 40 na taun aongos, na Satan katapo atoktokngai ania, na kapo ago nei liuan i mamain ta kei, na ri angelo kipo pakangai ania. ");
INSERT INTO lcm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","E mung i la teng akit tapai ani Ioanes, Iesu kamela serei e Galilaia na kalapo akuskus ta akus ro i God, ");
INSERT INTO lcm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Kala sinong a taun, na kana vainagoan a God kala angasungai! Mi lomon pokai pelek kami keve lau rikek, na mi lomlomon ta akus ro!” ");
INSERT INTO lcm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Na kala ulit aliu ngerelo i laman tatapulitai e Galilaia, na kala arai ani ri Simon ve Andereas, nang a tasina i Simon, kilongtapo sog, using kilongtapo katakai i maiak. ");
INSERT INTO lcm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na Iesu kala antok irilong, “Milong using iau, na naka itoiton imilong asi kamilong sog ani ri vap.” ");
INSERT INTO lcm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nang palau kilongla papelek karilong keve uvene na kilongla using ia. ");
INSERT INTO lcm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Na kala anguan ulit avunga lik an, na kala arai ani Iakovo, nat si Sebedaio, kuvul ve tasina ta Ioanes, kilongtapo itoiton karilong keve uvene kuli vul. ");
INSERT INTO lcm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nang palau kala songo irilong na kilongla papelek a tamari-long ta Sebedaio kuli vul ve kana vap i po seupok, na kilongla using ia. ");
INSERT INTO lcm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Na kila pasal ane Kaparnaum na akorong palau si taun i atailai kanla riuk lak nei lu i kivung na kanla vil akalit si ri vap. ");
INSERT INTO lcm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na kipo taping ani kana akalkalit, using kapo akalit iria val igenen atogon kitmat, na parik val keve vap malangas ani saupai. ");
INSERT INTO lcm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na si taun ang palau nei kari lu i kivung, katapo atogon a mangsikei a igenen, malanganto rikek katapo aol ia, na kala songosongo alava ta, ");
INSERT INTO lcm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iesu le Nasaret, kupo buk vil sa vang kana animem? Sa, kupo serei kana asi kam me vil punuk suai animem? Napo malangas ua. Numai a nat gogoai i God!” ");
INSERT INTO lcm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Na Iesu kala atakun ia ta, “Ku musik! Soung suai ania!” ");
INSERT INTO lcm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na malanganto rikek ang kala savatigai ania na kala kup alava na kala soung suai. ");
INSERT INTO lcm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Na kilapo taping aongos velai ani anganasai ta, “Au, sa kana? Akalkalit tanginang? Kapo asok velai ani kitmat na ri ingua kapa kipo longong ia.” ");
INSERT INTO lcm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na si taun ang palau, akuskus ina kalapo pasal apapanai nei keve palpal aongos aulitai ani Galilaia. ");
INSERT INTO lcm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Na kala soung pelek a lu i kivung na kanla palak nei lu si ri Simon ve Andereas, kuvul ve ri Iakovo na Ioanes. ");
INSERT INTO lcm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na omona i Simon katapo matung ta mulak, na akorong palau kila antok ia tatana. ");
INSERT INTO lcm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Na kala pataun ia, kala teng a kungana na kala ngai atung ia. Na mulak ang kala papelek ia. Na kala sasagi aniria. ");
INSERT INTO lcm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ngelik i taun ang, si makarap kalapo siang, kila serei singi na ta mamain ta vap malepen na ria ingua katapo aol iria. ");
INSERT INTO lcm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mete takaman i lu ang katapo vaba luai ta ri vap aongos i rina ang. ");
INSERT INTO lcm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Na kala vil ato na vap miang kipo atogon a keve malepen angpetpetekai. Na kata kirikai suai ani ri ingua miang. Na parik katapa atalipai ani ri ingua asi mengen, using kipo malangas ta ninia kapo si. ");
INSERT INTO lcm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na si no i tangat kala tapasuk na kanla pasal taun a ring vauvau, na kanlapo sokotuk. ");
INSERT INTO lcm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Na Simon ve vap po auai ve nia kila pasal using ia ");
INSERT INTO lcm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","na kianla sabonai ania na kila antok ia ta, “Ri vap aongos kipo gule ua.” ");
INSERT INTO lcm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Na kala antok iria ta, “Tara pasal ane si mang matan rina aliu, ani nan akuskus kapa singiria, using ninia vanang a tukulai ina i kag soung.” ");
INSERT INTO lcm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Na kala pasal aulitai ani Galilaia aongos na kanla akuskus nei kari keve lu i kivung na ka lu suai kapa ani ri ingua. ");
INSERT INTO lcm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Na mangsikei a igenen tapak kamela serei singina. Kamela sovusulai na kala sokotuk ia ta, “Man kupo naung, kupo angkoai si vil adaus anig.” ");
INSERT INTO lcm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Na kala ngorem alava ia, na kala sulai ani kungana na kala teng e pukun ina, na kala antok ia ta, “Io, napo naung, kula daus!” ");
INSERT INTO lcm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nang palau pukun tapak ang kala kovek pelek ia, na kala daus. ");
INSERT INTO lcm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Na kala mengen amadot ia velai ani asok suai ania ");
INSERT INTO lcm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","velai ani kapo antok ia ta, “Ku ago ta an antok ani mang-sikei ta nem ke, sikei, ku pasal akorong na kuan akalit ta pukun im si katakai i sula, ani ka suluk a alilis ang i kam vilvil atanginang val saupai si Moses kapo antok, ani ri vap asi kari nas ta kulapo daus.” ");
INSERT INTO lcm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sikei kala pasal na kanla renge alava ta akuskus ke. Asukang na kalapo lolokovo na parik kalapa serei amalangas e nei rina, sikei kala ago si ring vauvau e komo. Na ri vap i keve rina aongos kime lapo serei singina. ");
INSERT INTO lcm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Au kala papok ane Kaparnaum, na e mung i mang rukun taun, kila longong ta kalapo ago nei lu, ");
INSERT INTO lcm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","na vap miang kimela duk luai tung e mete takaman. Na kapo kovek i pangau kapo vauvau, na kalapo akuskus iria ta mengen i God. ");
INSERT INTO lcm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Na kimela serei singina ta mang igenen soles. Puat a igenen kitapo asalak ia. ");
INSERT INTO lcm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Na using kata lapo duk arikek a ring ang parik kitapa angkoai si palak taun ania. Na kianla luk suai ani palpal i kuluna i lu ang akorong si ring ang katapo ago singina na kila sunguk a pata, soles ang katapo matung singina, na kila asiang ia taun ia. ");
INSERT INTO lcm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Si taun a Iesu kala arai kinle ani kari lomlomon na kala antok a soles ang ta, “Kag nat, kam keve lau rikek, nala lomon suai ania.” ");
INSERT INTO lcm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Au, mang vap malangas ani saupai kitapo sinong e iang na kitapo atogon susui musik nei lomlomonai iria asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Marai sa na igenen ke kapo mengen asukang ke? Kapo mengen i nau varas nang! Si kapo kun koi asi lomon suai ani lau rikek? God papalik nang!” ");
INSERT INTO lcm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na Iesu kalapo nas lenginang kari lomlomonai na kala sui iria, “Marai sa mipo angsusuiai e lomlomonai imi? ");
INSERT INTO lcm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Si i ngono bil ke kapo remrem si antok ania? Nala lomon suai ani kam lau rikek, vo si antok ta ku tapasuk na ku sunguk kam pata na ku pasal? ");
INSERT INTO lcm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Sikei, asi kami nas vang ta igenen i pukun kapo atogon a roron kuli rina si kana lomon suai ani rikek,” le na kala antok na igenen soles ang ta, ");
INSERT INTO lcm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Napo antok ua, tadut na ku sunguk le kam pata na ku pasal ane rina.” ");
INSERT INTO lcm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na akorong palau si taun ang, kala tadut e mataria aongos na kala sunguk kana pata na kala soung. Na kilapo taping na kila alatun a God na kila antok, “U, voivoi ka mat, tara lapo arai ani bil asukang ke!” ");
INSERT INTO lcm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Na kala anguan pasiang pok an ane ngerelo na vap duk kimela auai ve nia na kamela akalit iria. ");
INSERT INTO lcm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na taun ang kapo paliu, kala arai ani Levi, nat si Alpaio, katapo sinong nei lu i po luk takis, na kala antok ia, “Me using iau.” Na kala tadut na kala using ia. ");
INSERT INTO lcm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Na kanlapo angan nei kana lu, na petau duk, vap po luk takis na mamain ta katakai i bil arikek kimela sinong kuvul ve Iesu na kana keve nat i akalit, using vap duk kitapo using ia. ");
INSERT INTO lcm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Na mang matan i ri Parisaio, vap po malangas ang ani saupai, taun kila arai ania si po angan kuvul ve ri katakai i bil arikek na vap po luk takis, kila mengen kana keve nat i akalit ta, “Marai sa na kapo angan kuvul ve vap po luk takis na ri katakai i bil arikek?” ");
INSERT INTO lcm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na Iesu kala longong na kala antok iria, “Vap po to aro parik kipa inongos taun a katakai i vilvil ato, sikei ri malepen vang kipo inongos taun ia. Parik natapa serei asi me songo ani vap korong, sikei ri katakai i bil arikek.” ");
INSERT INTO lcm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Keve nat i akalit si Ioanes na keve nat i akalit si ri Parisaio kitapo alal, na mang vap kimela sui ia ta, “Kapo saka bil an na keve nat i akalit si Ioanes na keve nat i akalit si ri Parisaio kipo alal sikei kam keve nat i akalit parik kipa alal?” ");
INSERT INTO lcm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Na Iesu kala antok iria, “Sa, kapo angkoai ta keve tungana i vo tauk i pagamau ki mal si taun ang kipo ago kuvul ve nia? Kapo tav angkoai, using a vo tauk i pagamau kapo ago lak ve ria. ");
INSERT INTO lcm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ka atogon a taun lak na kila luk suai ani vo tauk i pagamau pelek a keve tungana. Taun ang vanang ki mal lak. ");
INSERT INTO lcm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kapo tav angkoai si tara suisui alak ani vuk vakup tanginang si maus kavang. Man asukang, vuk vakup tanginang ang ka ding pok a maus ang na ka vil alava pok na tading ang. ");
INSERT INTO lcm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na kapo tav angkoai kapa si tara lingai ani vaen tanginang si pauk kavang, vei pauk ang ka tading. Sukana na pauk kala rikek na vaen kala kovek kapa. Sikei, vaen tanginang vanang kapo ro si pauk tanginang.” ");
INSERT INTO lcm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Si mang sikei a taun i atailai katapo pasal aliu nei keve matang kon. Na kana keve nat i akalit kilapo pasal aliu na kipo rok a mang matan kon. ");
INSERT INTO lcm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Na ri Parisaio kila sui ia, “Arai, marai sa kana kipo abis a lau ke kapo tav angkoai si abis ania si taun i atailai?” ");
INSERT INTO lcm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Na kala antok iria, “Au si parik lak kana mitapa tataot a akuskus i David na sa kata abis ia si taun katapo atogon a inongos using katapo buk angan, ninia ve keve tungana? ");
INSERT INTO lcm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Kata palak nei lu si God, si taun ang a Abiatar katapo ainoai i katakai i sula, na kala angan a pok i asinong akipai ang voiang ri katakai i sula papalik kipo atogon a roron asi angan ania, na kala alis kapa si keve tungana.” ");
INSERT INTO lcm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Na kala mengen iria, “Taun i atailai, God kata asinong ia asi pakangai ani igenen, na parik ta igenen asi pakangai ani taun i atailai. ");
INSERT INTO lcm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Asukang na igenen i pukun kapo Volava i taun i atailai kapa.” ");
INSERT INTO lcm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na kala anguan palak an nei lu i kivung, na katapo atogon a mangsikei a igenen e iang kungana katapo mat. ");
INSERT INTO lcm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Na kilapo teremai ania ta man kala vil ato ia, ki aoles ia using kapo taun i atailai. ");
INSERT INTO lcm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Na kala antok a igenen kunga mat ang ta, “Me ane ke.” ");
INSERT INTO lcm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Na kala sui iria, “Saupai i taun i atailai kapo asok ira si pakangai vo vil arikek? Si vil ato vo si vil punuk?” Sikei kipo musik lik palau. ");
INSERT INTO lcm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Na kala ararai aulitai aniria velai ani neikien na makus using a vingaria kapo kit. Na kala antok a igenen ang, “Ku koros a kungam.” Na kala koros a kungana na kala pukunan aro pok. ");
INSERT INTO lcm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Na ri Parisaio kila soung na akorong palau kianla gulegule selen ve kana vap a Erodes ta ki saka raung an ania. ");
INSERT INTO lcm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iesu ve kana keve nat i akalit kila papelek a ring ang ane ngerelo. Na petau lava le Galilaia kila using ia. Na le Iudaia kapa, ");
INSERT INTO lcm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","na le Ierusalem, le Idumaia, na le mang palpal i sung Iordanes, na le Turo na Sidon. Petau lava ke kita lapo longong a keve abis ang kata abis ia na kila using ia. ");
INSERT INTO lcm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Na kala antok kana keve nat i akalit ta ki usausa ta ring vul ania vei nganing a petau lava ke kimela rumrumpulit ia, ");
INSERT INTO lcm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","using katala vil ato na vap duk, asukang na kana, ri vap malepen aongos kipo kun buk sigil ania. ");
INSERT INTO lcm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Na si taun ang ri malanganto rikek kipo arai ania na kipo soturungai singina na kipo songosongo ta, “Numai a nat i God.” ");
INSERT INTO lcm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Na kapo atakun amadot iria ta ki ago ta mengen amalangas an tatana. ");
INSERT INTO lcm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Na kala kiklak ane ring putputan, na kala songo asung na vap ang katapo buk iria, na kimela serei singina. ");
INSERT INTO lcm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Na kala atung a 12 na igenen asi kari auai ve nia, na asi kana asok aniria asi an akuskus, ");
INSERT INTO lcm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","na ki atogon kitmat asi kirikai suai ani ri ingua. ");
INSERT INTO lcm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Simon, kata atuk pok ia ta Petero. ");
INSERT INTO lcm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Iakovo nat si Sebedaio, ve Ioanes tasina i Iakovo, kata atuk pok irilong ta Boanerges, supsupai ina ta nat i angang. ");
INSERT INTO lcm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andereas na Pilipo na Bartolomaio na Mataio na Tomas, na Iakovo nat si Alpaio, na Tadaio, na Simon mangsikei i ri Kananaio, ");
INSERT INTO lcm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","na Iudas Iskariot, vopo alis suai ania asi kana mat. ");
INSERT INTO lcm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Au, kala papok ane rina, na petau tavirimok kimela anguan serei akuvul pok an. Asukang a parik kilapa angkoai taun asi angan. ");
INSERT INTO lcm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na keve tungana kitala longong ta kapo kovek i taun i angan, na kimela serei asi kari me aiveven ania using kitala longong a mengen ta kalapo nio. ");
INSERT INTO lcm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Vap malangas ani saupai ang le Ierusalem kita mela antok ta, “Belsebul kapo aol ia na kapo lu suai ani ri ingua ta kitmat i kari tulava ri ingua.” ");
INSERT INTO lcm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Na kala songo asung iria na kala atatai si kankanuai i mengen asukang ke, “Kapo saka ro an ani Satan ka lu suai pok ani Satan? ");
INSERT INTO lcm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Man a vap i nei vainagoan ki angvis pok, vainagoan parik kapa angkoai si tung akit. ");
INSERT INTO lcm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Vo man a angtama ki angvis pok, angtama ang parik kapa angkoai si tung akit. ");
INSERT INTO lcm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Asukang palau man a Satan ka angvis pok ve kana vap, kana kitmat parik kapa tung akit luai. Ka kamus. ");
INSERT INTO lcm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Parik kapa angkoai si mangsikei ka palak nei lu si igenen dual na kan ainau kana keve bil, man parik kapa got tapai ani igenen dual ang. Le lak na kalapo angkoai si ainau ani keve bil i nei kana lu. ");
INSERT INTO lcm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Napo mengen atutuman imi ta God ka lomon suai ani keve lau rikek na keve mengen i nau varas ri vap kipo abis ia, ");
INSERT INTO lcm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","sikei ninia kapo mengen i nau varas ani Malanganto Gogoai, parik kapa angkoai luai si lomon suai ani lau rikek ang. Kana lau rikek ka dokot singina si keve taun aongos.” ");
INSERT INTO lcm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Using kita antok ta ingua kapo aol ia. ");
INSERT INTO lcm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Na rinana na keve tasina kime lapo tung e komo na kila ali mengen ta kipo buk tapai ania. ");
INSERT INTO lcm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na petau lava kipo sinong aulitai ania, na kila antok ia, “Rinam ve keve tasim na keve taum kipo ago e komo na kipo buk ua.” ");
INSERT INTO lcm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Na kala ngenget ta, “Si kana na rina ve keve tasig?” ");
INSERT INTO lcm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Na kala ararai aulit ani vap po sinong ang, na kala antok, “Ria vang kana na rina na keve tasig. ");
INSERT INTO lcm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Man a si kapo usiusing kana vubuk a mamai, nia vanang kapo tasig, kapo taug na kapo rina.” ");
INSERT INTO lcm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na kala anguan tutapongai akalkalit an e ngerelo na petau lava kimela serei kuvul singina, asukang a kala kokos kuli vul, na ri vap aongos kilapo ago ngerelo. ");
INSERT INTO lcm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Na kalapo akalit iria ta keve bil miang si kankanuai i mengen. Nei liuan i kana keve akalit kala atatai iria asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mi longong. Mangsikei a katakai i sukal kata sapungai ani kana keve katui i pok e matang. ");
INSERT INTO lcm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na mang matan katui kanpo uak e selen na ri mani kimela angan ia. ");
INSERT INTO lcm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Na mang matan katui kian lapo uak si ring iatan kapo tav angkoai roe, na using parik kapa atogon roe lava kala polok sumasuma, ");
INSERT INTO lcm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","na sinang kala ngan amak ia using kapo kovek i mis. ");
INSERT INTO lcm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Na mang matan katui kipo uak nei ring kakaulan na kanla polok alak ve nia na kala palun runguk ia, na parik kalapa uai. ");
INSERT INTO lcm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Na mang matan katui kipo uak nei roe roron. Kipo polok alava na kipo aunai uai alava, mang matan kipo uai ta 30, na mang matan ta 60, na mang matan ta 100 alak ani keve katui i sukal ang.” ");
INSERT INTO lcm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Au na kala antok, “Man a si kapo atogon talinga, kapo ro ka longong!” ");
INSERT INTO lcm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Na e mung kata lapo ago papalik, na vap po ago kuvul ang ve nia kuvul ve 12 na nat i akalit kilapo susuiai ania ta keve kankanuai i mengen ang. ");
INSERT INTO lcm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na kala antok iria, “Kakami na malangas i keve bil mumun i vainagoan si God, sikei riria e komo, kipo longong a keve bil aongos nei kankanuai i mengen, ");
INSERT INTO lcm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","asi kari gulegule na ki tav sabonai, na asi kari kokolongong na ki tav nas, vei ki lomon pokai na God ka lomon suai ani kari keve lau rikek.” ");
INSERT INTO lcm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Na kala sui iria, “Sa, parik mipa malangas a kankanuai i mengen ke? Man asukang, mi saka malangas an ani mang matan kankanuai i mengen? ");
INSERT INTO lcm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Katakai i sukal kapo sukal a mengen. ");
INSERT INTO lcm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mang matan vap vingaria kapo bil val katui ang kapo uak e nei selen. Kipo longong a mengen na sumasuma palau Satan kamepo luk suai ani mengen i la sukal ang. ");
INSERT INTO lcm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Au na ria kita luk a katui val roe ang nei ring iatan, ria vanang kipo luk na mengen ro na kipo uruk sumasuma palau. ");
INSERT INTO lcm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sikei using kapo kovek i mis, kana to i lomlomon kapo kudik palau. Si man a maiten vo vilvil akui kala serei singina marai mengen ro ang, kala uak sumasuma palau. ");
INSERT INTO lcm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Na katui i la uak si ring kakaulan ang, ninia katala longong a mengen, ");
INSERT INTO lcm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","sikei keve mamaiten i kuli rina ke na lomlomonai using ani tauia, na vubuk using ani mamain ta bil miang kala vil bat a mengen ro ang na kalapo kovek i uai. ");
INSERT INTO lcm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Au na katui i la uak nei roe roron ang, nang ninia kapo longong a mengen na kalapo malangas ia. Na kalapo aunai uai alaba asukang ta 30 na 60 na 100 alakat ani sa i sukal ang.” ");
INSERT INTO lcm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Na kala mengen iria asukang ke, “Au si tarapo nas ani amunai ani lam ni nei avubus vo neite pata? Parik tarapa uli atung ania si kana ring akorong? ");
INSERT INTO lcm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Using kapo kovek ta bil katapo ago mumum, na nganlak parik kapa serei e ring malangas. Vo ta bil katapo ago nei apupung, na nganlak parik kipa ulak ia. ");
INSERT INTO lcm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Man ta si kapo atogon talinga, kapo ro ka longong!” ");
INSERT INTO lcm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Au, kala mengen iria asukang ke, “Mi lomon akit a sa mitala longong ia. Ki abis singimi angkokoai palau val lau ang mita abis ia, kuvul ve ngaupap lava. ");
INSERT INTO lcm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Using man a si kapo atogon, ki ngaupap ia, na man a si kapo atogon men lik, io, men lik ang kapo atogon ia, ki luk suai vang ania.” ");
INSERT INTO lcm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Na kala mengen ta, “Vainagoan si God kapo asukang val igenen kapo sukal nei kana matang. ");
INSERT INTO lcm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Na kanla matav na katui ang kala sokopolok na kala polok alava. Parik kapa nas ta kapo saka polok an. ");
INSERT INTO lcm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Roe papalik kapo pakangai ani katui asi kana polok na ka uai. Ainoai ina ka kovkov, le na tis. Akamusai ina kala vaba ta uai. ");
INSERT INTO lcm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Sikei, taun kala matukal, nang palau kala rok ia using kalapo taun ina.” ");
INSERT INTO lcm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Na kala antok, “Au, tara alalangtongai ani vainagoan si God ta sa? Vo tara mengen atokngai ania ta sa? ");
INSERT INTO lcm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kapo asukang val katui i sinapeo. Kapo liklik luai ani keve katui aongos e kuli rina, ");
INSERT INTO lcm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","sikei man ki sukal ia ka polok na ka ngakanan ani keve sukalan aongos, angkoai si ri mani kime ting si marmarip ina.” ");
INSERT INTO lcm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Si keve kankanuai i mengen duk asukang ke kata akus a ri vap, angkoai si kari nas. ");
INSERT INTO lcm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Keve taun katapo mengen iria si kankanuai i mengen papalik. Sikei man ninia papa ve kana keve nat i akalit, kapo atatai aro iria. ");
INSERT INTO lcm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Si tenei ngelik vong i taun ang, kala antok iria, “Tara kokos aputuk.” ");
INSERT INTO lcm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Na kila papelek a petau ang na kimela kokos ve nia, using kalapo gon kuli vul lenginang. Na mang keve vul kitapo auai ve nia. ");
INSERT INTO lcm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Na mal titis kala serei amadot na to kala lak nei vul na kalapo buk gok. ");
INSERT INTO lcm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Nia katapo rot kirang vangang e mung i vul. Na kila pangun ia na kila antok ia, “Katakai i akalit, parik kupa ngorem ira? Oring lik tara puka!” ");
INSERT INTO lcm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na kala tapangun na kala atakun a malu asi kana kamus, “Musik! Luai!” Na malu kala aulei na luai lava kala pitik. ");
INSERT INTO lcm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na kala sui iria, “Marai sa na mipo leng? Mipo kovek lak i lomlomon?” ");
INSERT INTO lcm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Na kilapo leng alava na kipo sui angpokpokai aniria ta, “Saka igenen an kana na malu ve to kipo kun longong ania?” ");
INSERT INTO lcm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Na kianla serei e mang palpal i laman ang e palpal Geraseno. ");
INSERT INTO lcm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Na kala siang pelek a vul na mang sikei a igenen kamela duai ia le nei gom, katapo atogon a malanganto rikek. ");
INSERT INTO lcm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Katapo uli ago nei gom, na katapo kovek i mangsikei kapo angkoai si got akit ania, kantanem a angus kitmat luai. ");
INSERT INTO lcm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Using amiang i taun kitapo got akit ia ta angus kitmat na voteng, sikei katapo uli tak tok ani angus, na voteng kapo vil meng ia. Katapo kovek ta mang sikei kapo atogon dual angkoai asi teng akit ania. ");
INSERT INTO lcm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Si keve taun tenei ias ve tenei vong kapo uli kup alava pulakai nei gom na kuli keve putput. Na kapo lamut pok a pukun ina ta iat. ");
INSERT INTO lcm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Si vuk taun ang kamela arai ani Iesu e ring vunga, kala sang asiang taun ia na kanla soturungai singina. ");
INSERT INTO lcm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Na kala kup velai ani kapo songosongo alava ta, “Iesu, nat i God lakat luai, kupo serei asi kam me vil sa anig? Napo sokotuk akitmat ua e matana i God ta ku ago ta vil akui an anig.” ");
INSERT INTO lcm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Using katala antok ia ta, “Malanganto rikek, ku soung pelek a igenen ke!” ");
INSERT INTO lcm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Au kala sui ia ta, “Kam asan ta si?” Na kala polpol ta, “Kag asan ta petau using namempo miang.” ");
INSERT INTO lcm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Na kapo sokotuk ia asi kana ago ta kirikai an aniria pelek a ring ang. ");
INSERT INTO lcm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mang takaman vongo lava kitapo susuang angasungai i ring ang ngere put, ");
INSERT INTO lcm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","au na kila sokotuk ia, “Ku asok imem taun a takaman vongo suke ani namem an palak singiria.” ");
INSERT INTO lcm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Na kala ainak aniria. Au, keve malanganto rikek ang kila soung na kianla palak si keve vongo ang. Ria aongos, kipo asukang ta 2,000, kila doso asiang taun a ring karkadapan na kianla lus mat. ");
INSERT INTO lcm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Na vap po aiveven vongo ang kila sip na kianla akus nei rina lava na nei keve rina lik. Na ri vap kila pasal asi kari an arai ani sa katala serei. ");
INSERT INTO lcm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Na kimela serei si Iesu na kila arai ani vo sangan ta ingua ang kapo sinong, na kalapo kavat, na kalapo vangang tapalas aro pok, nang a igenen ang petau katapo ago singina, na kilapo leng. ");
INSERT INTO lcm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Na vap arai ang kila akus iria ta nem ang kata serei si igenen sangan ta ingua ang na ri vongo. ");
INSERT INTO lcm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Na kilapo sokotuk ia asi kana pasal suai ani kari rina. ");
INSERT INTO lcm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Au kalapo kokos na igenen ang ri ingua kitapo aol ia, kala sokotuk ia asi kana auai ve nia, ");
INSERT INTO lcm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","sikei parik kapa ainak ania na kala antok ia ta, “Ku papok ane rina taun a keve tungam na ku antok iria ta poisan a nem roron Volava katala abis ia singim na kata saka ngorem an anim.” ");
INSERT INTO lcm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Au kala pasal na kanlapo akuskus amalangas nei palpal i Dekapolis ta poisan a nem roron a Iesu katala abis ia singina. Na ri vap aongos kilapo nagat. ");
INSERT INTO lcm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Na Iesu kala paputuk pok kuli vul ane mang palpal na vap duk kimela serei akuvul singina e ngerelo. ");
INSERT INTO lcm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Na mang sikei a ainoinoai i nei lu i kivung, kana asan ta Iairo, kala serei na kala arai ania na kamela matung turung e ngono kakina, ");
INSERT INTO lcm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na kala sokotuk ia ta, “Kag kavulik lik kalapo ore asi kana mat. Ku me na kuan amatung a kungam singina asi kana to pok na ka ago aro.” ");
INSERT INTO lcm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Au kala pasal kuvul ve nia. Na petau lava kila rumrumpulit using aliu ia. ");
INSERT INTO lcm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na mang sikei a aina, katapo uli malepen ta tongmasik asukang ta 12 na matas aongos, ");
INSERT INTO lcm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","na katala pasal taun a keve katakai i vilvil ato duk, na katala amun aongos kana togtogon, sikei kana malepen kalapo rikek luai ani aino. ");
INSERT INTO lcm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Na katala longong na akuskus i Iesu, na kala gingging kolotai alak ania na kanla sigil kana vakup, ");
INSERT INTO lcm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","using kapo lomlomonai ta, “Man naka sigil lik palau kana vakup, nala roron pok.” ");
INSERT INTO lcm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na akorong palau tongmasik ang kala sal tok na kala nasai ania ta pukun ina kalapo kala pelek na malepen ang. ");
INSERT INTO lcm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na Iesu kala nas ta kitmat ina kala soung pelek ia na kala tapuk ngules nei liuan i petau ang na kala sui, “Si kata sigil kag vakup?” ");
INSERT INTO lcm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Na kana keve nat i akalit kila antok ia, “Kupo nas ta kana na petau lava kipo rumrumpulit ua, na kupo sui ta, ‘Si kata sigil iau?’” ");
INSERT INTO lcm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Na kala tun aulitai asi kana nas ta si nang kata mela sigil ia. ");
INSERT INTO lcm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Au na aina ke kalapo nas ta kalapo ro, na kalapo tek lengai palau na kamela matung turung e matana, na kala mengen amalangas ia ta keve nem tutuman aongos. ");
INSERT INTO lcm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na kala antok ia ta, “Kag kavulik, kam lomlomon kala vil ato pok ua. Pasal ta marip. Kam malepen kala tagon.” ");
INSERT INTO lcm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Vuk taun ang kapo mengen lak, na mang matan vap i nei lu si ainoinoai ang kimela serei na kila mengen ta, “Kam kavulik kala mat. Ago ta mang atelan an ani katakai i akalit.” ");
INSERT INTO lcm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Iesu parik kapa telan ta kari ainasai, sikei kala antok a ainoinoai ang ta, “Ku ago ta leng an, sikei ku lomlomon.” ");
INSERT INTO lcm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na kala tubat iria ani ka ago ta sikei ka using ia, sikei ri Petero ve Iakovo na Ioanes tasina i Iakovo, ritol papalik. ");
INSERT INTO lcm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Au, kianla serei si lu si ainoinoai ang, na kanla arai ani loek lava na radaupa. ");
INSERT INTO lcm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na kala riuk lak na kala antok iria ta, “Loek na tangis ke i sa? Kavulik ke parik kapa mat. Kapo rot palau.” ");
INSERT INTO lcm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Na kila los ia. Sikei kala asok suai aongos aniria ane komo, na kala songo na tamana ve rinana i kavulik ang, kuvul ve volo nat po auai ang ve nia, na kala palak taun a kavulik ang. ");
INSERT INTO lcm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Na kala teng a kungana na kala antok ia ta, “Talita koum.” Supsupai ina ta “Kavulik lik, napo antok ua, ku tadut.” ");
INSERT INTO lcm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Akorong palau na kavulik ang kala tadut na kalapo pasal, using kata lapo 12 kana matas. Na kila taping alava luai. ");
INSERT INTO lcm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Na kala atakun akit iria ta ka ago ta mangsikei ka nas a nem ke, na kala antok iria asi kari ali pok ania. ");
INSERT INTO lcm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na kala papelek a rina ang ane si kana rina akorong, na kana keve nat i akalit kila auai ve nia. ");
INSERT INTO lcm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na si taun i atailai kanla vil akalit nei lu i kivung. Vap miang kila longong kana akalit na kipo taping. Kipo sui asukang ke, “Igenen ke kata luk a keve mengen ke le voi? Nas ke kapo ago singina, kapo saka nas an? Si saka kitmat an na kapo vil a keve bil i vilvil ataping ke? ");
INSERT INTO lcm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Parik kana na katakai i abis lu ke, rinana ta Maria, na keve tasina ta Iakovo, Ioses, Iudas na Simon, na parik ta keve tauna kana kapa ve tara?” Na kilapo savang singina. ");
INSERT INTO lcm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Na Iesu kala antok iria ta, “Katakai i kus amalangas, vei kavpo atogon asan si mang keve rina, sikei si kana rina akorong, nei liuan i kana patvap na mete kana lu, parik.” ");
INSERT INTO lcm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Au, na e iang parik kata lapa angkoai si abis ani keve kitmat i bil i vilvil ataping, sikei kala amatung a kungana si rukun lik palau na kala vil ato iria. ");
INSERT INTO lcm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kapo taping alava using parik kipa lomlomon. Na kala pasal aulit e iang si keve rina si kana akalit ani ri vap. ");
INSERT INTO lcm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Na kala songo asung a 12 na nat ang, na kala asok pongpongua iria na kala alis iria ta kitmat asi kirikai ani ri malanganto rikek. ");
INSERT INTO lcm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Na kala pini akit iria ta ki ago ta teng an ani mangsikei a bil, sikei a kipa papalik. Pok ka ago, tepe ka ago, na kapkap nei laka kapa ka ago. ");
INSERT INTO lcm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Sikei ki alak a pauk i kak, na ki ago ta alak an ta lapongua i siot. ");
INSERT INTO lcm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Na kala antok iria, “Man mi ago nei mangsikei a lu, mi ago akorong e iang, tung si taun ang mi papelek pok a rina ang singina. ");
INSERT INTO lcm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Man a mang rina ki tav ainak animi na kipo misag ani longong animi, taun mila soung, mi tapngai suai ani kaponpon e kakimi, asi akalit amalangas aniria ta kari lau rikek.” ");
INSERT INTO lcm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Asukang na kila pasal na kianla akuskus ani ri vap ki lomon pokai. ");
INSERT INTO lcm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na kianla kirikai suai ani mamain ta ingua, na kianla tiu a mamain ta vap malepen ta rul i elaio na kila vil ato iria. ");
INSERT INTO lcm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Na tulava Erodes kala longong a keve nem ke using a asan ina kilapo malangas pulakai ania. Mang matan kilapo mengen ta Ioanes katakai i asing tauia kala to pok. Tukulai ina kapo atogon a kitmat ke asi vil ani keve nem ke. ");
INSERT INTO lcm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Na mang matan kipo mengen ta nia nang a Elias. Na mang matan kipo kun antok ta kapo katakai i kus amalangas asukang val keve katakai i kus amalangas ang aino. ");
INSERT INTO lcm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Sikei Erodes kala longong na kala antok ta, “Ioanes nau natala lam rongok ia, sikei kana kala to pok.” ");
INSERT INTO lcm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Using Erodes katala asok asi teng akit ani Ioanes na ki got ia na alakai ania nei lu i akangbat. Tukulai ina si Erodias, kisngana i tasina Pilipo, using kata lapo osongon ia. ");
INSERT INTO lcm_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Using Ioanes katapo uli mengen ani Erodes ta, “Parik kapa korong ta ku osongon pok kana aina na tasim.” ");
INSERT INTO lcm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Na Erodias kala marala ia na kalapo atogon a vubuk ani ka mat, sikei parik kapa angkoai, ");
INSERT INTO lcm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","using Erodes kapo leng ani Ioanes using kapo nas ta kapo igenen korong na daus kapa. Asukang na kala aiveven aro ia. Katapo mangal kana keve mengen na katapo uli buk longong ania kantanem katapo vinga bungus ania. ");
INSERT INTO lcm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sikei si mangsikei a taun, Erodes kala vil kana matan angan i ingus ania na kala songo kana keve ainoinoai na keve vap i visvis na keve vap posongan i Galilaia. ");
INSERT INTO lcm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Na si taun ang a kavulik ang si Erodias kame lapo mika e mataria na Erodes kuvul ve vap lava ang kilapo mangal ia. Au na tulava kala antok a kavulik ang ta, “Man kupo buk ta mang nem ku posong ia na naka alis ua tatana.” ");
INSERT INTO lcm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Kala atuvala ta, “Tutuman luai, naka alis ua ta saka nem an man ku aikut ia. Man kupo buk a palpal lava i kag togtogon naka alis ua.” ");
INSERT INTO lcm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Au, kala soung na kanla sui a rinana ta, “Au, saka nem an kana naka aikut ia?” Na kala antok ia ta, “Vangang i Ioanes.” ");
INSERT INTO lcm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na kala sang alak pok na kala antok ta, “Kana palau akorong ku alis iau nei gapai ta vangang i Ioanes katakai i asing tauia.” ");
INSERT INTO lcm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na tulava kala vinga makus alava, sikei using katala atuvala tatana, na keve vap lava kipo sinong, asukang na parik kapa angkoai si misag ani sa katala posong ia singina. ");
INSERT INTO lcm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Asukang a tulava kala asok a ararai bat ta kan luk le na vangang ina. Na kanla lam rongok a ngona nei akangbat, ");
INSERT INTO lcm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","na kamela serei ta vangang ina nei gapai, na kala alis ia si kavulik ang, na kavulik ang kala alis ia si rinana. ");
INSERT INTO lcm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Na kana keve nat i akalit kila longong na kimela asalak le na pukun ina na kianla amatung ia nei mata i mat. ");
INSERT INTO lcm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Na keve aposel ang kimela serei akuvul pok si Iesu na kimela akus ia ta sa kita vil ia na sa kita akalit tatana. ");
INSERT INTO lcm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Na kala antok iria, “Mi me. Tara pasal akipai papalik ane si ring vauvau asi an ausai tapai.” Using vap miang kitapo pasal angpok pulakai na parik kipa angkoai taun asi ago aro vo angan kapa. ");
INSERT INTO lcm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Na kila kokos kuli vul na kila pasal ane si mang ring vauvau si an ago papalik. ");
INSERT INTO lcm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sikei vap miang kila arai kinle aniria, na kila sang e selen palau le nei keve rina aongos, na kianla serei aino aniria. ");
INSERT INTO lcm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Na kanla siang sabonai ani vap duk, na kalapo ngorem iria using kipo asukang ta ri sipsip kovek i vo aiveven aniria. Na kala tutapongai asi kana mengen akalkalit aniria ta keve bil miang. ");
INSERT INTO lcm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Na kala ngelik na kana keve nat i akalit kimela serei singina na kila antok ia ta, “Ring ke kapo vauvau na kalapo angasungai a vong. ");
INSERT INTO lcm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Asok iria taun a mang keve rina asung asi kari an samui ta kari pok asi angan.” ");
INSERT INTO lcm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sikei kala antok iria ta, “Nami akorong mi li pok iria.” Na kila sui ta, “Au, kupo buk ani namem an samui pok ta kapkap tavirimok asi kamem alis aniria tatana?” ");
INSERT INTO lcm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Na kala sui iria ta, “Mipo togon a poisan a saui? Mianla arai tapai.” Na kianla arai tapai na kimela antok ia ta, “Palpalima, na pongua na ien kapa.” ");
INSERT INTO lcm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Na kala asok iria aongos ta ki sinong si kuvkuvulan si ring ro. ");
INSERT INTO lcm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na kila sinong angusing si kuvkuvulan. Mang matan si kuvkuvulan i 100 na mang matan si kuvkuvulan i 50. ");
INSERT INTO lcm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Na kala luk a palpalima na saui ang na pongua na ien na kala tarak ane metekuku, na kala posong aro ia, le na kala tevetevek a saui ang dong a keve nat ang asi kari lilis aliu ani ri vap tatana. Na kala kun abis ania asukang si ngono ien ang kapa. ");
INSERT INTO lcm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Na riria aongos kila angan na kila masung aro. ");
INSERT INTO lcm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Na kila lukluk akuvul a keve inongos i saui ve ien na kila asiang aduk a 12 na tepe lava tatana. ");
INSERT INTO lcm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Na vap tauan ang kita angan, tataot iria katapo 5,000 aongos. ");
INSERT INTO lcm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Akorong palau kala asok kana keve nat i akalit ta ki kokos aputuk aino ane Betsaida na nia asi kana asok suai tapai ani petau ang. ");
INSERT INTO lcm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na kala posong atatung suai tapai aniria na kala kik lak ane kuli putput asi kana an sokotuk. ");
INSERT INTO lcm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Na kala sagupgupan, na vul kanlapo ago nei liuan i laman, na nia papalik lak e ring kolo. ");
INSERT INTO lcm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Na kala arai ta kipo abis alava si kalip using kipo suak a malu. Si tapading i tangat kala pataun iria na kapo pasal aliu kuli laman, asi kana an liu tul aniria. ");
INSERT INTO lcm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Sikei kila arai ania si po pasal kuli laman ang na kila sekpat ta ingua, na kila angaloiai i leng. ");
INSERT INTO lcm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Using riria aongos kitala arai ania na kila leng alava. Sikei akorong palau kala mengen iria na kala antok ta, “Akos. Nau palau kana. Mi ago ta leng an.” ");
INSERT INTO lcm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na kala kokos ve ria na malu ang kala aulei na kipo taping velai ani sugul ");
INSERT INTO lcm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","using parik kipa lomlomonai akit ani saui ang kita angan ia. Vangang iria kapo tav tapalas aro. ");
INSERT INTO lcm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Au, kila paputuk luai ane mang palpal na kianla ung alak e Genesaret, na kila rukang. ");
INSERT INTO lcm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na taun ang kila siang, ri vap kila arai kinle ania, ");
INSERT INTO lcm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","na kila sang angtaliungai taun a matan rina asung na kianla asalak le na mamain ta vap malepen kuli pata taun a rina ang kitala longong ta kapo ago singina. ");
INSERT INTO lcm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na e voi pulakai, si rina lik vo rina lava na mang matan ring katan serei singina, kitapo amatung kari keve vap malepen nei vaia, na kila sokotuk ia asi kana ainak ani ki sigil na ngising palau i kana vakup. Au na taun ang kian lapo sigil ia, ria aongos kilapo to. ");
INSERT INTO lcm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ri Parisaio kimela serei singina kuvul ve mang matan vap malangas ani saupai le Ierusalem, ");
INSERT INTO lcm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","na kila arai ani kana keve nat i akalit si po angan tav sunep kunga aro aino val kapo ro val kari saupai. ");
INSERT INTO lcm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Using ri Parisaio ve ri Iudaia aongos kipo usiusing a akalit si ri vap aino ta man parik kipa sunep aro aino ki ago ta angan an. ");
INSERT INTO lcm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na ki ago kapa ta angan an ani pok kita samui ia nei ring i atos man parik kitapa galui adaus aro aino ia. Na kapo atogon mang matan saupai duk kipo using ia val galui aro ani kap, avubus, gapai, vebe na pata. ");
INSERT INTO lcm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Au, na ri Parisaio na vap malangas ani saupai ang kila sui ia ta, “Au kapo sa na kam keve nat i akalit parik kipa using a laulauan si keve tivura na kipo tav sunep aro aino tapai na ki angan?” ");
INSERT INTO lcm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Na kala antok iria, “Esias kata kus amalangas aro ta nami na vap kapau, val nei salsalik ta, Vap ke kipo mamaila anig ta ngururia palau, sikei nei pakangat iria kipo ago avunga luai anig. ");
INSERT INTO lcm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kipo soturungai kapau palau singig. Na kipo mengen alava ta kari keve lomlomonai palau asukang val kapo akalkalit tutuman. ");
INSERT INTO lcm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mipo lakau na asok tapai si God na milapo kolai ania ta laulauan si ri vap.” ");
INSERT INTO lcm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Na kala mengen iria, “Mipo katak aro luai asi kami gel ani kana saupai a God na mipo usiusing kami laulauan akorong. ");
INSERT INTO lcm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Arai, Moses kata antok ta, Ku mamaila ani tamam ve rinam, na si kapo mengen arikek ani tamana ve rinana, nia asi mat. ");
INSERT INTO lcm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sikei nami mipo antok ta man a si kapo antok a tamana ve rinana ta kana keve bil asi pakangai aniria kapo Korban, nang supsupai ina ta katala alis ia ane si God, ");
INSERT INTO lcm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","e iang mila atakun ia asi kana ago ta abis ani lau ro ani tamana ve rinana. ");
INSERT INTO lcm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Sukana, milapo lomon apalau na mengen si God, using mipo teng akit si kami keve sausaupai. Na mang keve bil duk kapa mipo vil ia asukang.” ");
INSERT INTO lcm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Na kala songo akuvul pok a ri vap na kala antok iria, “Nami aongos, mi longong iau na mi malangas. ");
INSERT INTO lcm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nem kapo pasiang nei vinga parik kapa angkoai si vil avisuk ani igenen. Sikei sa kapo soung le neina, nia vanang kapo vil avisuk ia.” ");
INSERT INTO lcm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Na kala papelek a petau ang ane nei lu na kana keve nat i akalit kila sokotuk ia ta ka atatai amalangas iria ta kankanuai i mengen ke. ");
INSERT INTO lcm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Na kala antok iria ta, “Nami kapa mipo tav malangas? Sa, parik mipa malangas ta sa kapo pasiang nei vinga parik kapa angkoai si vil avisuk ani igenen? ");
INSERT INTO lcm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Using parik kapa pasiang asi kana an ago akit, kapo pasiang ane nei vinga le na kanpo soung suai pok.” Si oring ke katapo mengen amalangas ta mamain ta pok aongos kipo ro asi angan. ");
INSERT INTO lcm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Na kala antok, “Sa kapo soung le neina i igenen, nia vanang kapo vil visuk ia. ");
INSERT INTO lcm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Using le nei vinga keve lomlomonai rikek ki serei val panik, ainau, daung, ");
INSERT INTO lcm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","putuk osongon, neikitung na mang matan lau rikek. Kapau, asosol, mangal musik, mengen musik, alalakas na nio. ");
INSERT INTO lcm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ria aongos na keve lau rikek ke kipo ago nei vinga nang kipo vil avisuk a igenen.” ");
INSERT INTO lcm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Au, kala papelek a rina ang na kala pasiang taun a palpal i Turo. Na kanla riuk lak nei mang lu amunai ani ki ago ta arai ania, sikei parik kapa angkoai si ka ago mumun. ");
INSERT INTO lcm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Sikei, mang aina, kana kavulik malanganto rikek katapo aol ia, kala longong ta kapo ago, na sumasuma palau kamela serei singina na kamela oroturung e ngono kakina. ");
INSERT INTO lcm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Aina ke kapo ainan Elas, na kana rina e palpal Suropoinikis, na kala aikut ia si kana lu suai ani ingua ang pelek kana kavulik. ");
INSERT INTO lcm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na kala antok ia ta, “Angangan amasung aino na ri nat lik using parik kapa ro asi luk ani pok si ri nat lik na apus ani kauvek tatana.” ");
INSERT INTO lcm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Na kala antok ia, “Kapo ro volava, sikei apok ri kauvek neite pata kipo nas ani angan ani inongos i pok si ri nat lik.” ");
INSERT INTO lcm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Na kala antok ia ta, “Using kupo mengen asukang, ku papok. Ingua ang kala papelek kam kavulik.” ");
INSERT INTO lcm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Au kala papok ane nei lu na kanla serei sabonai ani kana kavulik kapo matung kuli pata na ingua ang kala kovek. ");
INSERT INTO lcm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Na kala anguan tadut pelek pok an ani palpal i Turo, na kala palak ane Sidon na kala paliu asi kana an serei si laman tatapulitai, Galilaia, na kapo paliu nei palpal Dekapolis. ");
INSERT INTO lcm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na kianla songo dong ia ta mang igenen katapo talinga bot na kapo tava ani mengen. Na kila aikut ia ta ka amatung a ngono kungana singina. ");
INSERT INTO lcm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Na kala songo papalik akipai ania pelek a petau lava ang na kala atung a piupiu i ngono kungana nei ngono talingana na ka kanus na kala sigil a kalkalame ina. ");
INSERT INTO lcm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na kala tarak alak ane metekuku na kala aus asinong na kala antok na igenen ang ta, “Epata.” Supsupai ina ta “Tavas.” ");
INSERT INTO lcm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na talingana kala tapalas na kalkalame kudik ang kala ro na kana mengen kala saling aro. ");
INSERT INTO lcm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Na kala sokotakun a vap ang ani ki ago ta akus an tatana. Sikei, kantanem kata atakun amadot iria, kila akuskus alava. ");
INSERT INTO lcm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Na kipo taping alava luai na kipo mengen ta, “Keve bil aongos kapo vil ia kapo vil aro palau iria. Kapo iton a ri tapo asi kari mengen na ki longong korong kapa.” ");
INSERT INTO lcm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Si pangau i taun ang, mang petau lava kimela serei akuvul pok, na kitapo kovek i pok, na kala songo akuvul kana keve nat i akalit na kala antok iria ta, ");
INSERT INTO lcm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Napo ngorem a petau ke using lenginang kitala ago na potol a taun ve nau, na kipo kovek i pok. ");
INSERT INTO lcm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Man naka asok suai palau aniria velai ani buk angan, kianla ngau alava e selen using mang matan iria le ring vunga.” ");
INSERT INTO lcm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Na kana keve nat i akalit kila sui ia ta, “Au, tara luk pok e voi aniria? Using a ring ke kapo ring palau.” ");
INSERT INTO lcm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na kala sui iria ta, “Poisan a saui nang mipo atogon ia?” Na kila antok ta, “Limalengua.” ");
INSERT INTO lcm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Au na kala asok na petau ang asi kari sinong aongos e vunep, na kala luk a limalengua na saui ang na kala posong ro, na kala tevek ia na kalapo alis ia si kana keve nat i akalit asi kari sasagi ani ri vap tatana, na kilapo lilis a petau ang tatana. ");
INSERT INTO lcm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kitapo atogon a rukun ien lik kapa na kala kun posong ro singina na kala asok iria ta ki kun tavai kapa ania. ");
INSERT INTO lcm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Na kila angan na kila masung. Au na kila lukluk akuvul na keve inongos i pok ang na kala serei asukang ta limalengua na tepe duk. ");
INSERT INTO lcm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kitapo asukang ta 4,000 na vap aongos. ");
INSERT INTO lcm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na kala asok suai aniria, na kala kokos kuli vul ve kana keve nat i akalit na kila pasal ane palpal Dalmanuta. ");
INSERT INTO lcm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Na ri Parisaio kimela serei asi kari anggegelai ve nia, na kila asok ia ani ka abis a mangsikei a akanangai le metekuku, asi kari atokngai ania. ");
INSERT INTO lcm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Na kala aus asinong na kala antok ta, “Ani sa na polpolokan i taun ke kipo buk a akanangai? Napo mengen atutuman luai animi ta ka kovek luai ta mang akanangai ani polpolokan ke.” ");
INSERT INTO lcm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Na kala papelek iria na kala kokos aputuk kuli vul ane mang palpal. ");
INSERT INTO lcm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kitala lomon taun ani luk saui le. Ring sikei palau katapo sinong kuli vul. ");
INSERT INTO lcm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Na kala antok akit iria ta, “Mi arai aro na mi aiveven imi pelek a yeast si ri Parisaio na si Erodes kapa.” ");
INSERT INTO lcm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Na kilapo angmemengenai musik ta, “Tarapo kovek i saui.” ");
INSERT INTO lcm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sikei Iesu kalapo malangas ia na kala sui iria ta, “Sa tukulai ina na mipo angmemengenai ta mipo kovek i saui? Sa, parik mipa malangas lak? Mipo kovek i nas lak? Vei vingami kavpo tabat nganing? ");
INSERT INTO lcm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mipo atogon mata sikei mipo tav arai. Mipo atogon talinga kapa sikei mipo tav longong. Sa, parik mipa lomon akit ");
INSERT INTO lcm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","a taun ang nata tevek a palpalima na saui dong a 5,000 na vap ang singina? Poisan a tepe lava mita asiang aduk ia ta inongos i pok?” Na kila antok ia ta, “12.” ");
INSERT INTO lcm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Au na limalengua na saui ani 4,000 na vap ang, poisan a tepe lava mita asiang aduk ia?” Na kila antok ia ta, “Limalengua.” ");
INSERT INTO lcm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na kala sui iria ta, “Mipo kovek i nas lak?” ");
INSERT INTO lcm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Na kianla serei e Betsaida na mang vap kila songo dong ia ta mang igenen ba na kila sokotuk ia ta ka sigil ia. ");
INSERT INTO lcm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Na kala teng a kungana i ba ang na kala ausingai asoung ania pelek a rina. Na kala kanus dong a matana na ka amatung lakat a kungana singina na kala sui ia ta, “Kupo arai korong ta ring bil?” ");
INSERT INTO lcm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Na kala gelegelep na kala antok ta, “Napo arai ani ri vap, sikei kipo bil val ri ei kipo pasal.” ");
INSERT INTO lcm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Na kala amatung pok a kungana e matana, na kala arai akit, kala tapalas a matana na kala ararai aroron luai. ");
INSERT INTO lcm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Na kala asok ia taun kana lu velai ani kala atakun ia ta, “Ku ago ta an serei an e nei rina.” ");
INSERT INTO lcm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Na Iesu kala pasal aliu ve kana keve nat i akalit ane si mang keve rina e Kaisareia Pilipo. E nei selen kanlapo sui kana keve nat i akalit ta, “Ri vap kipo kin iau ta nau a si?” ");
INSERT INTO lcm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na kila antok ia ta, “Ioanes, katakai i asing tauia, na mang matan kipo antok ta Elias, na mang matan ta mangsikei iria mamain ta katakai i kus amalangas.” ");
INSERT INTO lcm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Na kala sui iria ta, “Au, na nami, mipo kin iau ta nau a si?” Na Petero kala ngenget ia ta, “Numai a igenen i akanangai.” ");
INSERT INTO lcm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Na kala sokotakun iria ta ki ago ta antok an ani mangsikei tatana. ");
INSERT INTO lcm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Na kalapo mengen i amalmalangasai aniria ta igenen i pukun ka sunguk a keve vilvil akui miang, na ri vap lava na keve ainoinoai si ri katakai i sula ve ri vap malangas ani saupai ki misag ania na ki raung ia, na e mung i potol a taun, ka tadut pok. ");
INSERT INTO lcm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na katapo mengen amalangas aroron luai aniria. Na Petero kala songo ia ane ngising na kanlapo tatapokai ania. ");
INSERT INTO lcm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sikei kala taval na kala arai ani kana keve nat i akalit na kala tatapokai ani Petero ta, “Pasal e mung ig, Satan. Using parik kupa auai ve lomlomonai si God, sikei kupo auai ve lomlomonai si ri vap.” ");
INSERT INTO lcm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Na kala songo asung ri vap kuvul ve kana keve nat i akalit na kala antok iria ta, “Man a mangsikei kapo buk using anig, ka uli auak suai ani lomlomonai ania pok, na ka asalak kana ngakputuk na ka using iau. ");
INSERT INTO lcm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Using ninia kapo buk aiveven aroron ani kana to, ka amun ia. Sikei ninia kapo amun kana to anig na ani akus ro, ka teng ia. ");
INSERT INTO lcm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Using man a igenen ka atogon a keve bil aongos kuli rina na ka mat, keve bil ang ki saka pakangai ania? ");
INSERT INTO lcm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Arai, tara samui pok kara to ta sa? ");
INSERT INTO lcm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Using man a sikei kapo mumurung anig na ani kag mengen, nei liuan i vap putuk osongon ve bil arikek i taun ke, igenen i pukun kapa ka kun mumurung ania si taun man ka serei pok ta miminaungan i tamana ve mamain ta angelo ");
INSERT INTO lcm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Na kala antok iria, “Napo mengen atutuman luai animi ta mang matan kana kipo tung e ke, parik kipa mat tung si ki arai ani kana vainagoan a God kame serei ta kitmat.” ");
INSERT INTO lcm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na kala liu tapai a limalesikei a taun na Iesu kala songo le na ri Petero ve Iakovo na Ioanes, ritol papalik, na kala ainoai alak aniritol ane si mangsikei a put lakat. Na kanla sakol e mataritol. ");
INSERT INTO lcm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Na kana maus vo la mang posok luai, tav angkoai ve mangsikei i kuli rina kapo galui vakup asukang. ");
INSERT INTO lcm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Na Elias ve Moses kilongla tu aserei na kilongmela angmemengenai ve Iesu. ");
INSERT INTO lcm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Na Petero kala antok a Iesu ta, “Kapo ro anira si me ago e ke. Namemtol atung ta potol a ralai, ta sikei anim, na mang sikei ani Moses na ta mang anu ani Elias.” ");
INSERT INTO lcm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Using parik kapa nas ta ka saka mengen an, using kitolpo leng arikek. ");
INSERT INTO lcm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Na mang kuku kamela apung iria. Na kalinga kala mengen nei kuku, “Kana kag nat ro, napo buk alava ia, mi longong ia.” ");
INSERT INTO lcm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Akorong palau na kitola anguan ararai an, na kitola tav arai ani mang si ve ritol, Iesu papalik. ");
INSERT INTO lcm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Au na taun kitolapo kik siang pok pelek a kuli put ang, kala atakun iritol ta kitol ago ta antok an ani mang anu ta saka nem an kitoltala arai ania tung si igenen i pukun kala tadut pelek a mat. ");
INSERT INTO lcm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Asukang a kitola teng akit a mengen ke na kitolpo sui angpokpokai aniritol ta supsupai i vuk mengen ke tadut pelek pok ani mat. ");
INSERT INTO lcm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Na kitola sui ia ta, “Au, marai sa na vap malangas ani saupai kipo antok ta Elias kame serei aino tapai?” ");
INSERT INTO lcm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Na kala antok iritol ta, “Elias kame serei aino ani kame vil aro na keve bil aongos. Marai sa kita salik ia ta igenen i pukun ka kui alava na ri vap asi kari kirikai ania? ");
INSERT INTO lcm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sikei napo antok imi ta Elias lenginang kata mela serei, na kitapo vil a keve lau rikek e matana si selen ang riria akorong kitapo uruk singina, asukang val mengen i salsalik kapo mengen tatana.” ");
INSERT INTO lcm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na kitolanla serei si keve nat i akalit sabonai ani petau lava si po ago kuvul ve ria, na mang keve vap malangas ani saupai kilapo anggegelai ve ria. ");
INSERT INTO lcm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na petau ang kila arai ania na kipo taping arikek na kila sang kamakamal ia na ki lulun ia. ");
INSERT INTO lcm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na kala sui iria, “Mipo anggegelai kana ta saka nem an ve ria?” ");
INSERT INTO lcm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Na mangsikei a igenen nei liuan i petau ang kala ngenget ia asukang ke ta, “Katakai i akalit, natame serei singim ta kag nat, using a ingua kapo aol ia na kapo tav mengen. ");
INSERT INTO lcm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Keve taun, man a ingua ka serei singina, kapo so tatana ane vunep, rere kapo siang e amangana na kapo ngut ngisa, na kapo amadot a pukun ina. Natala sokotuk kam keve nat i akalit asi kari lu suai ania sikei parik kipa angkoai.” ");
INSERT INTO lcm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Na kala antok iria ta, “Nami na matan polpolokan tav lomlomon. Poisan lak a taun si kag ago ve nami? Poisan lak a taun si kag telan tatami? Sunguk ia ane singig!” ");
INSERT INTO lcm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Au, kila sunguk ia na akorong palau si vuk taun ang ingua ang kala arai ania na kala so angpok pulakai ta nat ang ane vunep na kapo saul angpok velai ani rere i mat. ");
INSERT INTO lcm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Na kala sui a tamana ta, “Poisan a taun katala bil asukang ke?” Na kala antok ia ta, “Le si liklik. ");
INSERT INTO lcm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Taun miang ingua ke kapo buk raung punuk ania na mang matan taun kapo so tatana ane nei kut na ane nei laman kapa. Man kupo angkoai si pakangai animem, kapo ro, ngorem imem.” ");
INSERT INTO lcm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Na Iesu kala antok ia ta, “Man kupo angkoai? Keve bil aongos nang kapo angkoai man kupo lomlomon.” ");
INSERT INTO lcm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Akorong palau na tamana i nat ke kala songosongo ta, “Napo lomlomon, ku pakangai ani kag lomlomon using kapo liklik!” ");
INSERT INTO lcm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na Iesu kala arai ta petau ang kime lapo duk na kala kirikai suai ani ingua ang, “Numai, ingua vil apo ang, ku soung pelek ia! Ku ago luai ta anguan aol an ania!” ");
INSERT INTO lcm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Na kala kup alava na ka anguan so pok an tatana na kala soung pelek ia. Na nat ang kalapo matung val igenen la tapikon. Na amiang iria kilapo antok ta kala mat. ");
INSERT INTO lcm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sikei Iesu kala teng ia e kungana na kala tadut. ");
INSERT INTO lcm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Au na kala palak nei lu na kana keve nat i akalit kianla sui papalik ia ta, “Sa tukulai ina na parik namemtapa angkoai si lu suai ania?” ");
INSERT INTO lcm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na kala antok iria ta, “Si sokotuk papalik tarapo angkoai si lu suai ani anu asukang ke.” ");
INSERT INTO lcm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Na kila papelek a rina ang na ki paliu e Galilaia. Parik kapa ainak ta ki nas ta kalapo ago e iang, ");
INSERT INTO lcm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","using kapo buk atatai ani kana keve nat i akalit asukang ke ta, “Igenen i pukun ki alis suai ania e kungaria i ri vap na ki raung ia na e mung i potol a taun ka tadut pok.” ");
INSERT INTO lcm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sikei parik kipa malangas ta supsupai i mengen ang, na kipo lolokovo si sui ania tatana. ");
INSERT INTO lcm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Na kianla serei e Kaparnaum na e nei lu kala sui iria ta, “Mitapo anggegelai ta sa nang e selen?” ");
INSERT INTO lcm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sikei parik kipa ngenget ia using kitapo anggegelai e selen ta si iria kari ainoinoai. ");
INSERT INTO lcm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Na kala sinong na kala songo na 12 na nat i akalit na kala antok iria ta, “Man a igenen kapo buk asi kana ainoinoai, ka igenen palau, na ka asosokai si ri vap.” ");
INSERT INTO lcm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na kala songo na mang nat lik na ka atung ia nei liuan iria na ka sovai ia na kala antok iria ta, ");
INSERT INTO lcm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Si kapo ainak ani sikei a nat lik asukang ke si asan ig, e iang kapo ainak anig. Na si kapo ainak anig, parik kapa ainak anig, sikei kapo ainak ani vo asok ang anig.” ");
INSERT INTO lcm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Na Ioanes kala antok ia ta, “Katakai i akalit, namemta arai ani mang igenen katapo kirikai suai ani ingua si asan im, sikei namemta atakun ia using parik kapa mangsikei ira.” ");
INSERT INTO lcm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sikei Iesu kala antok iria ta, “Mi ago ta atakun an ania. Arai, man a mangsikei kapo vil a bil i vilvil ataping si asan ig, parik kapa angkoai si mengen arikek sumasuma anig, ");
INSERT INTO lcm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","using man a si kapo tav tubat anira, kapo tung ve tara nang. ");
INSERT INTO lcm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Using napo mengen atutuman luai animi ta man a si ka alis imi ta men laman asi inum, using mipo sunguk a asan i igenen i akanangai, tutuman luai parik kapa angkoai si ngau kap ani kana seupok. ");
INSERT INTO lcm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Man a si ka asavang a sikei i keve nat lik ke, ka pen ro ania man ki pala a iat maiten e ngona na ki asuai ania nei laman. ");
INSERT INTO lcm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Man a mang palpal kungam katala vil ua si uak si lau rikek, ku li tok suai ania. Kapo ro ta ku palak si to asikei ta sikei a pal kunga palau, vei la asuai anim ve ngono kungam aongos nei kut lava i saupai, si kut ang kapo ni asikei. ");
INSERT INTO lcm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Na man a mang palpal kakim katala vil ua si uak si lau arikek, ku lam putuk suai ania. Kapo ro ta ku palak si to asikei ta sikei a pal kak palau, vei la asuai anim ve ngono kakim aongos nei kut lava i saupai. ");
INSERT INTO lcm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Na man a mang palpal matam katala vil ua si uak si lau rikek, ku ruvel suai ania. Kapo ro ta ku palak nei vainagoan si God ta sikei a palpal mata palau, ani ki asuai anim ve ngono matam aongos nei kut lava i saupai, ");
INSERT INTO lcm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","si ring ang ri kanipa ki se asikei a pukun iria singina na kut ang parik kapa angkoai si mat singina. ");
INSERT INTO lcm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Arai, ri vap aongos, kut ka ni adaus iria val makasim. ");
INSERT INTO lcm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Makasim kapo bil ro. Au na man a makasim kala tamus a namin ina, mi saka vil anaminan an pok ania? Kapo ro ta makasim ka ago singimi na mi ago kuvul si marip.” ");
INSERT INTO lcm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Na kala papelek a ring ang ane palpal Iudaia na kala paputuk a sung ang Iordanes. Na petau lava kimela serei pok singina na kala akalit iria val kapo uli vil ania. ");
INSERT INTO lcm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Na mang matan Parisaio kitapo buk atokngai ania na kila sui ia ta, “Au si kara saupai kana kapo ainak ani tauan asi kana asuai ani kana aina?” ");
INSERT INTO lcm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Na kala sui pok iria ta, “Moses kata alis imi ta saka saupai an?” ");
INSERT INTO lcm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na kila antok ia ta, “Moses kata ainak ani tauan ka salik kana mengen i misag, le na ka asuai ania.” ");
INSERT INTO lcm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sikei Iesu kala antok iria ta, “Using a vingami katapo kitmat, na kata alis imi ta saupai ang, ");
INSERT INTO lcm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","sikei le kabang le si taun i asisinong God kata asinong iria tauan na aina, ");
INSERT INTO lcm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","nang tukulai ina tauan ka papelek a tamana ve rinana na kame ago kuvul ve kana aina, ");
INSERT INTO lcm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","na kilongla sikei palau a pukun. Sukana vang, parik kilonglapa anguan pongua an, kilonglapo sikei. ");
INSERT INTO lcm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Asukang a sa na God katala pala kuvul ia, ka ago ta mangsikei ka luang ia.” ");
INSERT INTO lcm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Au, nei lu na kana keve nat i akalit kianla susuiai ania ta keve nem ang. ");
INSERT INTO lcm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na kala antok iria ta, “Man a mangsikei katala kamus si kana aina na kanla osongon ta mang anu, sukana kapo abis a lau rikek taun ia. ");
INSERT INTO lcm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na man a aina katala kamus si kana tauan na kanla osongon ta mang anu, sukana kapo abis a lau rikek.” ");
INSERT INTO lcm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na kimela serei ve ri nat kavulik lik taun ia ani kame amatung kunga singiria, na kana keve nat i akalit kimela marala suak iria. ");
INSERT INTO lcm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Na Iesu kala arai ani oring ke, kala marala na kala antok iria ta, “Mi lomon suai ani ri nat lik ane singig. Ago ta atakun an aniria, using a matan vap val ria, kakaria vang na sinsinongan si kana vainagoan a God. ");
INSERT INTO lcm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Napo mengen atutuman imi ta man a sikei parik kapa ainak val nat lik ani kana vainagoan a God, parik luai kapa palak.” ");
INSERT INTO lcm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na kala vongok iria na ka amatung lakat a kungana si siksikei iria na kala poso atauia iria. ");
INSERT INTO lcm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na kalapo tutapong pok kana paspasal, na mang igenen kala sang taun ia na kamela sovusulai singina na kala sui ia ta, “Katakai i akalit ro, sa naka vil ia ani kakag a to asikei?” ");
INSERT INTO lcm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Na Iesu kala antok ia ta, “Sa tukulai ina na kupo kin iau ta napo ro? Using God papalik nia kapo ro. ");
INSERT INTO lcm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kupo malangas a keve asok tapai ang ta Ku ago ta daung an, ku ago ta putuk osongon an, ku ago ta ainau an, ku ago ta posposo akapau an mete saupai, ku ago ta kapau an asi luk palau ani bil si mangsikei, ku mamaila aro ani tamam ve rinam.” ");
INSERT INTO lcm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na kala antok ia ta, “Katakai i akalit, riria aongos nata using arukup iria le si taun natapo liklik lak tung kana.” ");
INSERT INTO lcm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Na Iesu kala arai velai vinga ro ania na kala antok ia ta, “Mangsikei a bil lak kupo inongos asi kam abis ania asukang ke. Ku pasal na ku an atos ta kam keve togtogon, na ku alis ani ri vap logo, ani kakam a togtogon roron metekuku. Na kume using iau.” ");
INSERT INTO lcm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Taun kala longong a mengen ang na nono kala dai velai ni makus lava na kala pasal akipai, using kapo igenen duk ta togtogon. ");
INSERT INTO lcm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Na Iesu kala taval taun kana keve nat i akalit na kala antok iria ta, “Vola kitmat luai ani igenen tauia si palak nei kana vainagoan a God.” ");
INSERT INTO lcm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Na keve nat ang kila taping ani kana mengen. Sikei Iesu kala anguan mengen an ta, “Kag inatus, kapo kitmat luai asi palak nei kana vainagoan a God! ");
INSERT INTO lcm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Palak ang si igenen tauia ane nei vainagoan ang si God, ka kitmat luai ani papalakan si kamel nei malang i sangum.” ");
INSERT INTO lcm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Na kilapo taping alava luai, na kipo sui angpokpokai aniria ta, “Au, man kapo asukang, si ka angkoai si sapang?” ");
INSERT INTO lcm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Na Iesu kala tun iria na kala antok ta, “Ani ri vap kapo kitmat, sikei ani God, kapo remrem, using keve bil aongos God kapo angkoai si vil ania.” ");
INSERT INTO lcm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na Petero kalapo mengen ia ta, “Arai, namemtala papelek a keve bil aongos asi kamem using anim.” ");
INSERT INTO lcm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Na Iesu kala antok ta, “Napo antok atutuman imi ta man a si ka papelek kana rina, na keve tasina, tauna, rinana, tamana, kana inatus vo kana keve matang, si asan ig vo si asan i akus ro, ");
INSERT INTO lcm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tutuman luai ka luk pok lak a tauia tavirimok luai i keve rina, tasina, tauna, rinana, kana inatus, na kana keve matang si to ke, na ka luk kapa na vilvil akui, na si to e mung ka teng a to asikei. ");
INSERT INTO lcm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Sikei vap miang kitapo aino, kime aimung, na riria kitapo aimung, ki an aino.” ");
INSERT INTO lcm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Na kilapo paspasal e selen alak ane Ierusalem, na Iesu kapo lili ainoai aniria, na kipo lomlomonai amiang, na vap po aimung ang kipo leng. Na kala anguan songo an ani 12 na nat ane ngising na kala atatai iria ta keve nem ang ka serei lak singina. ");
INSERT INTO lcm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Arai, taralapo palak vang ane Ierusalem, na kian alis suai ani igenen i pukun taun a keve ainoinoai si ri katakai i sula na keve vap malangas ani saupai, na kian alis saupai ani kan mat, na ki lis ia e kungaria i ri vap i ngising, ");
INSERT INTO lcm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","na ki kurek ia, ki kanus ia, ki sasaup ia na kian raung punuk ia. Na e mung i potol a taun ka tadut pok.” ");
INSERT INTO lcm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Na ri Iakovo ve Ioanes, ngono nat ang si Sebedaio, kilongmela antok ia ta, “Katakai i akalit, mang bil namemlongpo buk ua ta ku abis ia animemlong.” ");
INSERT INTO lcm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na kala sui irilong ta, “Saka nem an milongpo buk ia ani naka abis ia?” ");
INSERT INTO lcm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na kilongla antok ia ta, “Ku ainak animemlong ta mangsikei kan sinong si kam palso na mang anu si kam palkais nei kam miminaungan i sinsinongan.” ");
INSERT INTO lcm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Na Iesu kala antok irilong ta, “Parik milongpa nas a sa milongpo aikut ia. Sa, milongpo angkoai si inum si kavi ke napo usausa asi kag inum singina? Sa, milongpo usausa si luk ani asing tauia ke napo usausa si luk ania?” ");
INSERT INTO lcm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na kilongla antok ia ta, “Namemlongpo angkoai.” Na Iesu kala antok irilong ta, “Kavi ke naka inum singina, milong inum kapa singina, na asing tauia ke naka luk ia, milong luk ia, ");
INSERT INTO lcm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","sikei si sinong si kag palso vo palkais, parik vang kapa kakag si kag posong singina. Ngono palpal ang kapo kakaria, riria kitala itoiton ia aniria.” ");
INSERT INTO lcm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Au, mang sangauli na nat ang kila longong a bil ke, na kilapo songag ani ri Iakovo ve Ioanes. ");
INSERT INTO lcm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Na Iesu kala songo akuvul iria na kala antok iria ta, “Mipo nas a ri vap i ngising, kari keve vap vo sausaupai kipo aunai lakat aniria. Na kari keve vap asanan kipo aunai sausaupai aniria. ");
INSERT INTO lcm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sikei parik kapa ro ta ka asukang singimi. Sikei si man a si kapo buk ani ka laba singimi, kapo ro ani ka serei a asosokai singimi aongos. ");
INSERT INTO lcm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Na si kapo buk tu ainoinoai animi ka auak ia ani ka asosokai e kevkev imi aongos. ");
INSERT INTO lcm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Using a igenen i pukun kata serei parik asi kari me asosokai singina, sikei asi kana me asosokai singiria, na asi kana me mat bat ani vap miang na asukang ka samui apok iria.” ");
INSERT INTO lcm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Na kianla serei e Ieriko. Na taun ang kalapo papelek a Ieriko ve kana keve nat i akalit kuvul ve mang petau lava, Bartimaio, tamana ta Timaio, mangsikei a igenen ba na katapo uli aikut papakangai, katapo sinong ngere selen. ");
INSERT INTO lcm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na kala longong ta Iesu le Nasaret, na kala songo alava ta, “Iesu, nat i David, ku ngorem iau!” ");
INSERT INTO lcm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Na vap miang kilapo atakun ia ani ka ago ta mengen an. Sikei kala songosongo alava luai ta, “Nat i David, ku ngorem iau!” ");
INSERT INTO lcm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Na Iesu kamela tung na kala antok ta, “Mi songo ia.” Na kila songo na igenen mata ba ang, velai ani ki antok ia ta, “Ku uruk. Tapasuk, kapo songo nang ua.” ");
INSERT INTO lcm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Na kala kiang suai ani kana vakup i po apupung, ka laos atung na kala pataun a Iesu. ");
INSERT INTO lcm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Na Iesu kala sui ia ta, “Kupo buk ani naka vil sa anim?” Na ba ang kala antok ia ta, “Raboni, napo buk asi kag mata arai.” ");
INSERT INTO lcm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Na Iesu kala antok ia ta, “Ku pasal. Kam lomlomon katala vil ato ua.” Akorong palau kala ararai aro na kala using ia e selen. ");
INSERT INTO lcm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Na kian lapo pasal angasungai i Ierusalem, asi an serei e Betpage na Betania, si mulang ang Elaio, na kala asok a pongua i kana keve nat i akalit ane no, ");
INSERT INTO lcm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","velai ani mengen anirilong ta, “Milong pasal taun a rina suke e no, na man milonganla palak, milong sabonai ani dongki tanginang kita pala ia, na parik lak ta mang anu katapa kokos singina. Milong kunis ia na milong tak ia ane ke. ");
INSERT INTO lcm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Man a sikei ka sui imilong ta milongpo vil ia ani sa, milong antok ta Volava kapo inongos taun ia na ka alis suai sumasuma pok ania.” ");
INSERT INTO lcm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Au, kilongla pasal na kilonganla sabonai ani dongki tanginang ang ngere selen kita pala akit ia si takaman i mang lu. Na kilongla luang ia ");
INSERT INTO lcm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","na vap po tung asung ang kila sui irilong ta, “Au, sa na milongpo luang suai ani dongki tanginang ang?” ");
INSERT INTO lcm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Na kilongla ngenget val kana atatai a Iesu, na kila ainak anirilong. ");
INSERT INTO lcm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Na kilongla tak a dongki tanginang ke taun a Iesu na kilong amatung lakat karilong keve vakup i po apupung kuluna na kala gon lakat kuluna. ");
INSERT INTO lcm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na vap duk kila kun veleveles ani kari keve vakup i po apupung e nei selen na mang matan kipo veleveles pan i ei le nei uten. ");
INSERT INTO lcm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Na vap po aino ang kuvul ve ria e mung kipo songosongo asukang ke, “Alatun! Atautauia ane si vopo serei ke ta asan i Volava. ");
INSERT INTO lcm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Atautauia ane si vainagoan vopo serei ke si tivura David. Alatun ane pangkul luai!” ");
INSERT INTO lcm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Na kala serei e Ierusalem na kanla palak nei rina i atailai. Na taun ang kala ararai aongos e iang, using kalapo ngelik, kala soung suai pok ane Betania ve kana sangauli na pongua na nat i akalit. ");
INSERT INTO lcm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Si taun using ina, kilapo papok le Betania na kalapo buk angan, ");
INSERT INTO lcm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","na kala arai ani mangsikei a suke kapo tung avunga na kapo urung. Na kala pasal taun ia asi kana an ngumut ta ring uai, sikei kanla arai ta kapo kovek, kapo papanan palau, using parik lak kapa inuai. ");
INSERT INTO lcm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Na kala antok ia ta, “Le kana na asikei ka kovek ta sikei ka angan a uaim!” Na kana keve nat i akalit kipo longong ia. ");
INSERT INTO lcm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Na kianla serei e Ierusalem, na kala palak nei rina i atailai na kanlapo lu asoung a vap po samui na asesel ang nei rina i atailai. Ka ul aturung a keve pata singiria kipo sakol kapkap, na keve sinsinongan singiria kipo atos ta ri uk. ");
INSERT INTO lcm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na ka atakun iria ani ki ago ta asalak an ani kari usausan alak ane nei rina i atailai. ");
INSERT INTO lcm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na kala vil akalit aniria velai ani mengen ta, “Sa, parik kitapa salik ia ta, Kag lu kapo lu si sokotuk ta mamain ta matan vap aongos? Sikei kana milapo pokai ania asi kana bil val vakil si ri vap tainau.” ");
INSERT INTO lcm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Na keve ainoinoai si ri katakai i sula kuvul ve ri vap malangas ani saupai kila longong a nem ke na kila gule selen ani ki raung suai ania, using kipo leng ania using vap duk kipo mangal kana akalkalit. ");
INSERT INTO lcm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Au, tenei ngelik vong kila soung pelek a rina. ");
INSERT INTO lcm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na taun kilapo paliu vauk e selen, na kila arai ani ei ang kala mak aongos tung si mis ina. ");
INSERT INTO lcm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Na Petero kala lomlomonai pok na kala antok ia ta, “Katakai i akalit, ku arai ani ei suke kuta varas ia, kala mak aongos.” ");
INSERT INTO lcm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Na Iesu kala polpol ta, “Mi lomlomon ta God. ");
INSERT INTO lcm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Napo antok atutuman imi ta man a si ka asok a mulang ke ta, ‘Ku tapasuk na kuan asuai anim nei laman!’ na parik kapa sugul e lomlomonai ina, sikei kapo lomlomon ta sa katala kin ia ka serei, ka asukang palau. ");
INSERT INTO lcm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Asukang a napo antok imi ta man mi sokotuk a mangsikei a nem na mipo lomlomon akit ta mi atogon ia asukang, tutuman, mi luk ia. ");
INSERT INTO lcm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Man mipo tung asi sokotuk, mi lomon suai ani lau rikek si mang sikei, ani tamami e metekuku ka kun lomon suai ani kami keve lau rikek.” ");
INSERT INTO lcm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Na kianla serei pok e Ierusalem, na kanlapo pasal nei rina i atailai na keve ainoinoai si ri katakai i sula, na vap malangas ani saupai kuvul ve ri vap lava kimela serei singina, ");
INSERT INTO lcm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na kila sui ia ta, “Si saka ro an kana kupo abis a keve abis ke? Si kata alis ua ta ro asi abis ania?” ");
INSERT INTO lcm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Na Iesu kala antok iria ta, “Naka sui imi ta mang susui, na man mila polpol aro ia, nau naka antok imi ta kag saka ro an asi abis ani keve abis ke. ");
INSERT INTO lcm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ioanes si kana asing tauia, kata luk a ro ang le metekuku vo le si ri vap? Mi ngenget iau.” ");
INSERT INTO lcm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Na kilapo anggegelai ta, “Man tara antok ta le metekuku, kala sui ira ta sa tukulai ina parik taratapa lomlomon tatana. ");
INSERT INTO lcm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Sikei, parik kapa kun ro si antok ta le si ri vap.” Kipo leng ani ri vap using ri vap aongos kipo lomon ia ta Ioanes katapo katakai i kus amalangas tutuman. ");
INSERT INTO lcm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Asukang na kila polpol a Iesu ta, “Parik namempa nas.” Na Iesu kala antok iria ta, “Nau kapa, parik napa kun antok animi ta saka ro an kana napo abis a keve abis ke tatana.” ");
INSERT INTO lcm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Na kala mengen singiria si kankanuai i mengen asukang ke, “Mangsikei a igenen kata sukal kana matang vaen na kala omo aulitai ania na kala atu ring asi kokomeng ani uai, na kala abis a lu lakat ipo ararai bat, na kala alis tapai ani matang ke si mang keve vap aiveven matang, na kala pasal akipai ane si mang rina. ");
INSERT INTO lcm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na si taun i kopkopos kala asok a mang asosokai taun a vap po aiveven matang ang ani kan luk ta palpal uai i kana matang. ");
INSERT INTO lcm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Na kianla teng akit ia, ki vis arikek ia na kila asok suai palau pok ania. ");
INSERT INTO lcm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Na kala anguan asok pok an ani kana mang asosokai na kianla tangai ia e vangang ina na ki vil amese ia. ");
INSERT INTO lcm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Na kala asok a mangsikei na kianla ngapunuk ia. Na ninia palau a lau ang kita vil ia si mang keve asosokai duk ang asukang palau. Kita vis a mang matan na ki raung a mang matan. ");
INSERT INTO lcm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Au, kapo atogon a sikei a nat aoleman, kana nat akorong, na e mung luai kala asok ia taun a vap ang nei matang using kapo lomon ia ta, ‘Ki mamaila ani kag nat.’ ");
INSERT INTO lcm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Sikei, vap aiveven matang ang kila angtokai ta, ‘Arai ta votauk i togtogon iles. Akos, tara me vil punuk ia ani kakara na togtogon ang.’ ");
INSERT INTO lcm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Au kila teng akit ia, ki ngapunuk ia na ki asuai akipai ania pelek a matang ang. ");
INSERT INTO lcm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Au vo tauk i matang ang ka abis sa? Ka serei na ka vil punuk suai luai ani keve vap po aiveven matang ang na ka alis a matang ang si mang vap petekai. ");
INSERT INTO lcm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Sa, parik kana mitapa tataot a vuk mengen ke nei salsalik? Iat ke ri katakai i abis lu kita kilis ia, kana kala serei a iat talupus luai. ");
INSERT INTO lcm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Bil ke, Volava kata asereiai ania, vola miminaungan luai e matara.” ");
INSERT INTO lcm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na kilapo buk teng akit ania using kilapo nas ta kapo mengen atokngai nang aniria. Sikei kipo leng ani vap po duk ang, na kila atolongon ia na kila pasal suai. ");
INSERT INTO lcm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Na kila asok a mang matan Parisaio kuvul ve mang matan i petau ang si Erodes asi kari an teng akit ania si kana mengen. ");
INSERT INTO lcm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Na kianla serei singina na kila antok ia ta, “Katakai i akalit, namempo malangas ta kupo igenen atutuman na parik kupa tarakai ani mangsikei using ri vap kipo angkokoai palau e matam. Na kupo akalit atutuman ta selen si God. Sa, kapo korong ani tara samui takis ane si Kaisar, vo parik? ");
INSERT INTO lcm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tara samui ia vo tara ago?” Na lenginang kala nas kari kapau na kala antok iria ta, “Marai sa mipo buk atokngai anig? Me ta ring kapkap ane ke. Name arai.” ");
INSERT INTO lcm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Na kila luk dong ia, na kala sui iria ta, “Au, nona i si kana? Na asan i si kana?” Na kila antok ia ta, “Ke Kaisar.” ");
INSERT INTO lcm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Au na Iesu kala antok iria ta, “Mi alis a Kaisar ta sa ke Kaisar, na mi alis a God ta sa ke God.” Na kila sugul alava ia. ");
INSERT INTO lcm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Na ri Sadukaio kimela serei singina, kipo agel suai ani tadut pok, na kila sui ia ta, ");
INSERT INTO lcm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Katakai i akalit, Moses kata salik ia anira ta man a igenen ka mat pelek kana aina kovek i inatus, tasina ka osongon pok ia asi kana aumata nat ani tasina. ");
INSERT INTO lcm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Katapo atogon a limalengua na angtasimal, anu tuan kata osongon kana aina na kala mat pelek ia kovek i nat. ");
INSERT INTO lcm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Asukang si anu tasin kala kun osongon ania na kala kun mat kovek i nat, na asukang si vapotol ina. ");
INSERT INTO lcm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Na limalengua na angtasimal ang kita kovek i nat. Na e mung luai aina ang kala kun mat kapa. ");
INSERT INTO lcm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Si taun i tadut pok, ke si iria ta aina ke? Using a limalengua na angtasimal kita osongon tatana.” ");
INSERT INTO lcm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Na Iesu kala antok iria ta, “Arai, mipo lok singina using parik mipa nas a mengen i nei salsalik na parik kapa mipa malangas kana kitmat a God. ");
INSERT INTO lcm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Using si to e mung ri vap parik kipa angosongon, parik. Kian bil val ri angelo metekuku. ");
INSERT INTO lcm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Au, na ani tadut pok si ri vap mat, vei parik lak nganing mipa taot nei buk si Moses ani ei ang katapo ni? God kata antok ia ta, Nau a God si Abaram, God si Isak, na God si Iakov. ");
INSERT INTO lcm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Parik kapa God si ri vap mat, sikei singiria kipo to. Kami lomlomonai kapo lok luai.” ");
INSERT INTO lcm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na mangsikei i vap po malangas ani saupai kamela serei. Katapo longong iria si po anggegelai, na kala arai ta kata lapo polpol aro luai aniria, asukang a kamela sui ia ta, “Si i keve asok tapai kapo mamaiten lava?” ");
INSERT INTO lcm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na Iesu kala ngenget ta, “Ainoai ina ta, Mi longong, ri Israel! Volava kara God kapo sikei palau. Kapo kovek ta mang Volava. ");
INSERT INTO lcm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ku atogon aongos a Volava kam God, ta vingam aongos, na malanganto im aongos, na lomlomon im aongos, na kitmat im aongos. ");
INSERT INTO lcm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Na vapongua asukang ke, Ku vinga ro taun a tungam val kupo vinga ro taun pok ua. Kapo kovek ta mang asok tapai kapo mamaiten ani pongua ke.” ");
INSERT INTO lcm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Na igenen malangas ani saupai ang kala antok ia ta, “Kala ro luai, katakai i akalit, kutala polpol aro ta kapo sikei palau, na kapo kovek ta mang sikei, ");
INSERT INTO lcm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","na asi kara atogon ania ta vingara aongos na lomlomon ira aongos na kitmat ira aongos, na asi kara vinga ro taun ani tungara val tarapo vinga ro taun pok ira. Na kapo mamaiten luai asi longong ani ngono asok tapai ke ani tara alis a God ta alilis kita sula ia na mang matan alilis kapa.” ");
INSERT INTO lcm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na Iesu kala arai ta kapo polpol velai ani masam, na kala antok ia ta, “Parik kupa ago avunga ani kana vainagoan a God.” Na le si vuk pangau ke riria aongos kilapo lolokovo luai ani sui ania ta mangsikei a susui. ");
INSERT INTO lcm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Na Iesu katapo vil akalit nei rina i atailai na kalapo mengen asukang ke, “Kapo saka bil an na ri vap malangas ani saupai kipo mengen ta igenen i akanangai kapo nat i David? ");
INSERT INTO lcm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David akorong si Malanganto Gogoai kata posong ta, Volava kata antok kag Volava ta ku sinong si palso ig, tung si naka vil a vap po petau ang anim asi kari ago neite ngono kakim. ");
INSERT INTO lcm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David akorong kapo kin ia ta Volava. Asukang a kapo saka angkoai an si kin ania ta kapo nat ina?” Na petau lava ang kitapo longong ia, vap la uruk ani kana mengen. ");
INSERT INTO lcm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Na si kana akalkalit katapo mengen iria asukang ke ta, “Mi aiveven si ri vap malangas ani saupai. Kipo buk pasal pulakai ta maus roron na kipo buk ri vap ki posong aro singiria nei keve ring i atos, ");
INSERT INTO lcm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","na kipo pigpig ta keve sinsinongan lava nei lu i kivung na keve oring mamaila si keve matan angan. ");
INSERT INTO lcm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kipo tainau kari keve lu ri mainang, na kipo kapau ta posong ani keve sokotuk vungavunga. Kari amiming ka tavirimok luai.” ");
INSERT INTO lcm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na kapo sinong asung i asisiang ipo asia alilis na kapo tun ri vap si po asiang kapkap. Vap tauia duk kimepo kun asiang ani kari keve alilis lava. ");
INSERT INTO lcm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Na mangsikei a mainang logo kamela asiang kana pongua na vuk kapkap lik luai. ");
INSERT INTO lcm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Au, kala songo akuvul kana keve nat i akalit na kala antok iria ta, “Napo mengen atutuman imi ta mainang logo ke katala asiang alava luai ani vap aongos ke kipo asiang kari keve kapkap, ");
INSERT INTO lcm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","using riria kitala luk tapong le si kari togtogon i kari tauia na kila alis, sikei ninia, le si kana logo luai, katala alis asip ta sa katapo angkoai si kana to aongos.” ");
INSERT INTO lcm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na si taun kalapo soung pelek a nei rina i atailai mang sikei i kana keve nat i akalit kala antok ia ta, “Katakai i akalit, ku arai ani keve at lava si keve lu roron suke.” ");
INSERT INTO lcm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Na Iesu kala antok ia ta, “Kupo arai ani keve lu lava ke? Ka serei lak a taun na ka kovek luai i ngoto roron. Kime galang aongos ia.” ");
INSERT INTO lcm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Na kanlapo ago kuli mulang ang Elaio, ararai aputuk taun ani rina i atailai. Na Petero, Iakovo, Ioanes na Andereas, ria papalik ve nia, na kila sokotuk ia ta, ");
INSERT INTO lcm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ku antok imem, angisan a keve bil ke ki serei? Na saka akanangai an i taun i kari serei atutuman?” ");
INSERT INTO lcm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Na Iesu kalapo atatai iria asukang ke, “Mi aiveven, vei mangsikei nganing ka kapau imi. ");
INSERT INTO lcm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Vap miang ki serei na ki posong pok iria ta asan ig na ki antok ta ‘Nau kana ninia,’ na ki kapau a vap duk. ");
INSERT INTO lcm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Na man mi longong ta kalapo atogon visvis vo kalapo angasungai a visvis, mi ago ta leng an using a keve bil ke ki serei, sikei akamusai ina lak, parik. ");
INSERT INTO lcm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Using mang palpal vap ka tapasuk na ka angvis ve mang palpal vap, na mang vainagoan ka angvis ve mang vainagoan. Na mimo ka serei si mang keve rina, na ka atogon a keve buk angan lava. Keve nem ke kapo tutapongai palau i kui. ");
INSERT INTO lcm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mi aiveven aro imi, using ki teng akit imi lak taun a saupai. Ki ngamis imi e nei keve lu i kivung. Mian tung mete ri ainoinoai na ri tulava marai ig, asi kami akuskus atutuman e mataria. ");
INSERT INTO lcm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Na akus ro, mamain ta patvap aongos ki luk aino ia. ");
INSERT INTO lcm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Man ki teng akit imi, na ki alis suai animi taun a saupai, mi ago ta urui an ta mi an saka mengen an, sikei mian mengen ta mengen ang mi luk ia si vuk taun ang. Using parik ta nami mianpa mengen, Malanganto Gogoai ka mengen. ");
INSERT INTO lcm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Igenen ka alis suai ani tasina asi an raung ania. Inatus kapa ki puka si tamaria si lau ke. Na ri tamaria ve rinaria kapa, ki kun mat si kari inatus. ");
INSERT INTO lcm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Na ri vap aongos ki mirik animi marai asan ig, sikei man a si ka tung akit tung si akamusai ina, ka sapang. ");
INSERT INTO lcm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Taun mi arai ani bil vopo nau varas ani God na kapo goeng rina, ki atung ia si ring ang kapo atogon tubat singina, vopo taot a mengen ke, ka lomlomonai aro ania, si taun ang ria kipo ago e Iudaia kapo ro ki sip taun a keve mulang. ");
INSERT INTO lcm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ninia kapo ago e komo i lu, ka ago ta riuk lak pok an taun ani kana togtogon. ");
INSERT INTO lcm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Na ninia kapo ago e matang kapo ro ka ago ta papok an ane rina si an luk ani kana vakup. ");
INSERT INTO lcm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pua ta ri aina vinga na riria kipo atutus popo si taun ang! ");
INSERT INTO lcm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mi sokotuk ani nem rikek ang ka ago ta serei an si taun livus. ");
INSERT INTO lcm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Using si taun ang ka atogon a mamaiten tavirimok, na kapo laba ani keve mamaiten le si tutapong i kuli rina ke God kata asinong ia, tung si taun ke na aimung kapa. ");
INSERT INTO lcm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Na man a Volava parik kapa vil akudik a taun ang, ka kovek luai ta sikei e kuli rina ka sapang. Sikei using kana vap i la songo, asukang a ka vil akudik ia. ");
INSERT INTO lcm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Si taun ang man a mangsikei ka antok imi ta, ‘Mi arai, igenen i akanangai kana!’ vo ‘Nia sukana ia!’ mi ago ta lomlomon an tatana, ");
INSERT INTO lcm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","using a mang matan igenen i akanangai na katakai i kus amalangas kapau ki me serei. Ki me serei na ki vil a keve akanangai na keve bil i vilvil ataping asi kari me atokngai asi ausingai alok ani kana vap i songo na God. ");
INSERT INTO lcm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mi aiveven! Natala atai usausa imi aino ta saka keve bil an ki serei lak. ");
INSERT INTO lcm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Sikei si taun ang, e mung i mamaiten lava ang, makarap ka vong gup, na ulen parik kapa anguan mang an, ");
INSERT INTO lcm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","na ri kalto ki uak asiang le metekuku, na keve kitmat e metekuku ki mimo. ");
INSERT INTO lcm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Na si taun ang ki arai ani igenen i pukun ka serei kuli kuku ta kitmat lava na miminaungan. ");
INSERT INTO lcm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Na ka asok kana mamain ta angelo ani kian songo akuvul aongos kana vap i la songo, riria kipo ago si keve palpal aongos i kuli rina na metekuku. ");
INSERT INTO lcm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mi luk malangas si laulauan i ri suke. Man kala urung atanginang, mila kinle ta taun sinang roron kalapo angasungai. ");
INSERT INTO lcm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Na asukang kapa, man mila arai ani keve nem ke kala serei, mila malangas ta kalapo angasungai luai e mete takaman palau ani ka serei. ");
INSERT INTO lcm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Napo antok atutuman imi, kana na matan polpolokan i taun ke parik kipa mat suai aino ani keve bil ke kila serei. ");
INSERT INTO lcm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Metekuku na kuli rina ka tamus suai, sikei kag mengen parik kapa angkoai luai si tamus. ");
INSERT INTO lcm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pangau i taun vo vuk taun ina, kapo kovek i mangsikei kapo nas ia. Ri angelo i metekuku na kana nat parik kipa nas, sikei tamana papalik kapo nas. ");
INSERT INTO lcm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mi aiveven na mi usausa, using parik mipa malangas ta angisan na taun ang ka serei. ");
INSERT INTO lcm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kapo asukang val igenen kata usausa asi kana pasal ane ring vunga. Taun ang kalapo buk pasal pelek ani kana rina, kala asok kana keve asosokai ani ki aiveven kana keve bil na kala lis iria siksikei ta kana keve abis, na kala asok a katakai i aiveven takaman asi kana ararai bat. ");
INSERT INTO lcm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Asukang a mi aiveven, using parik mipa nas ta saka taun an na vo tauk i lu kame serei pok singina, si ngelik sagup, vo si liuan i vong, vo si no i tangat lik, vo si makarap kalapo sanglak. ");
INSERT INTO lcm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Vei nganing kame serei ataping na kala arai ta mipo rodot. ");
INSERT INTO lcm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sa kana napo mengen imi tatana, animi aongos ta mi aiveven!” ");
INSERT INTO lcm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Au, kalapo pongua na taun lak e no ani Liuluai, nang a matan angan i saui i tav tol. Na keve ainoinoai si ri katakai i sula ve ri vap malangas ani saupai kime lapo gule selen asi kong mumun ania na ki vil punuk ia. ");
INSERT INTO lcm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Using kitapo antok ta si taun i matan angan ka ago vei nganing ri vap ki visvis. ");
INSERT INTO lcm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Si taun ang kalapo ago e Betania nei lu si Simon vo tapak ke, na katapo angan, na mangsikei a aina kamela serei, na katapo teng a ese laman sain roron luai na kapo samui lava luai kapa. Na kala putuk a ese ang na kala tiuai ani rul sain ro ang e patuna. ");
INSERT INTO lcm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Na mang matan vap e iang kilapo songag na kipo angsusuiai asukang ke ta, “Sa tukulai ina na kipo amun palau a rul sain roron ke? ");
INSERT INTO lcm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Using man kita atos tatana, oro kila luk a 300 na kang alak na ki alis ri vap logo tatana.” Na kila ki ia. ");
INSERT INTO lcm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sikei Iesu kala antok iria ta, “Atalipai ania! Marai sa mipo mengen arikek ania? Kana kapo abis a mangsikei a bil roron luai anig. ");
INSERT INTO lcm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Arai, mi uli ago lak ve ri vap logo, na mipo uli atogon taun asi pakangai aniria. Sikei nau parik napa uli ago ve nami. ");
INSERT INTO lcm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Katala abis a sa kapo angkoai singina. Katala tiu a pukun ig ta rul sain ro usausa iau ani mo. ");
INSERT INTO lcm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Napo antok atutuman imi ta si saka ring an kuli rina ki akuskus ta akus ro, akuskus kapa i sa na aina ke kata abis ia ki kun akuskus kapa tatana asi rungrungai ania.” ");
INSERT INTO lcm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Na si taun ang Iudas Iskariot, sikei iria i 12 na nat i akalit, kanla serei si keve ainoinoai si ri katakai i sula, using kapo buk alis suai ania e kungaria. ");
INSERT INTO lcm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na vap la uruk si po longong ani mengen ang, na kila palapalatung ve nia ta ki samui ia. Na kalapo gusgus ta saka pangau an kapo kalakala si alis suai ania e kungaria. ");
INSERT INTO lcm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Si ainoai i taun i saui i tav tol, taun ang kipo raung a natnat i sipsip singina, kana keve nat i akalit kila sui ia ta, “Nei a ring ang kupo buk ani namem an itoiton anim singina si angan ani Liuluai?” ");
INSERT INTO lcm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Na kala asok a pongua i kana keve nat i akalit na kala atatai irilong ta, “Milong pasal ane nei rina na e iang mang igenen kapo sunguk kana ese laman ka duai imilong. Milong using ia ");
INSERT INTO lcm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","taun a lu ang kan palak singina na milong mengen a vo tauk i lu ang ta, ‘Katakai i akalit kapo sui ta nei kag palpal i lu ani ri sokoung, ani namem ve kag keve nat i akalit namem me angan a Liuluai singina?’ ");
INSERT INTO lcm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ka akalit imilong ta palpal lava e pangkul kitala itoiton ia na kalapo usausa asi ago. Na e iang milongla usausa anira singina.” ");
INSERT INTO lcm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Na ngono nat ang kilongla pasal ane nei rina na kilonganla sabonai ani keve nem ang val kata mengen irilong tatana. Na kilonganla itoiton a Liuluai. ");
INSERT INTO lcm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na si tenei ngelik i taun ang kamela serei kuvul ve 12 na nat i akalit. ");
INSERT INTO lcm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Si pangau ang kipo sinong angan singina, Iesu kala antok iria ta, “Napo mengen atutuman imi ta sikei imi ka alis suai anig. Mangsikei imi mipo angan ve nau.” ");
INSERT INTO lcm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Na kilapo makus na siksikei iria kalapo sui ia ta, “Vei nau nganing?” ");
INSERT INTO lcm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Na kala antok iria ta, “Kapo mangsikei i 12 na nat, voiang namemlongpo abui saui kuvul nei gapai ke. ");
INSERT INTO lcm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Using a igenen i pukun ka mat val kitala salik aino tatana, sikei ka rikek luai ani vo alis suai ang ani igenen i pukun. Pat ka ro ania man parik kitapa ingus ia!” ");
INSERT INTO lcm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Si pangau ang kipo angan lak singina, na kala luk a saui, na kala posong ro singina, na kala tevek ia na kala lilis aliu iria na kala antok ta, “Mi luk ia. Kana na pukun ig.” ");
INSERT INTO lcm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na kala luk a kavi, kala posong aro, na kala alis iria, na riria aongos kila inum angsialai singina. ");
INSERT INTO lcm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na kala antok iria ta, “Kana na rangaig ani angainakai, na ka saling ani vap miang.” ");
INSERT INTO lcm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Napo antok atutuman imi ta parik napa anguan inum an si laman i vaen tung si nakan inum ia si selen tanginang si kana vainagoan a God. ");
INSERT INTO lcm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Au na kila tangam kari sikei a tangam na kila soung taun a mulang ang Elaio. ");
INSERT INTO lcm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na Iesu kala antok iria ta, “Nami aongos lak mi savang, using kitala salik ia ta, Na nga punuk na katakai i aiveven sipsip na keve sipsip ki tamale angtaliungai. ");
INSERT INTO lcm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sikei, e mung i kag la tadut pok le, naka aino imi ane Galilaia.” ");
INSERT INTO lcm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Na Petero kala antok ia ta, “Man riria aongos kila savang, nau parik.” ");
INSERT INTO lcm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Na Iesu kala antok ia ta, “Napo mengen atutuman ua ta aino le ani pura ka apongua i tirtiriku nganlak, kula amatan potol a agel suai anig.” ");
INSERT INTO lcm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Na kala mengen akitmat luai ta, “Kantanem si man nakan mat ve numai, sikei parik luai napa angkoai si agel suai anim.” Na ria aongos kila kun antok asukang. ");
INSERT INTO lcm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Na kianla serei si ring ang kipo kin ia ta Getsemani na kala antok kana keve nat i akalit ta, “Mi ago e ke, na nau nakan sokotuk.” ");
INSERT INTO lcm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na kala songo na Petero na Iakovo na Ioanes asi auai ve nia. Na si taun ang kala pat ia na mamaiten lava. ");
INSERT INTO lcm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na kala antok iritol ta, “Makus lava ke kalapo rongos iau angasungai ani naka mat. Mitol ago e ke na mitol para.” ");
INSERT INTO lcm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Au, kala pasal avunga lik na kanla suai ania e vunep na kala sokotuk ta man kapo angkoai, kui rikek luai ke ka liu luai ania. ");
INSERT INTO lcm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na kala antok, “Aba, mamai, keve nem aongos kapo angkokoai singim. Ku luk suai ani kavi ke pelek iau. Lak, vubuk ke singig ka ago, sikei ku using kam vubuk.” ");
INSERT INTO lcm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Na kanla serei pok singiritol, na kitolapo rot. Na kala antok a Petero ta, “Simon, kulapo rot? Sa, parik kupa angkoai si aiveven ani vuk taun kudik lik? ");
INSERT INTO lcm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mitol aiveven na sokotuk, vei atoktokngai ka luk imitol. Malanganto kapo naung, sikei pukun kapo ngau.” ");
INSERT INTO lcm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na kala anguan pasal asi kana an sokotuk na kanla kin pok a mengen ang kata kin aino ia. ");
INSERT INTO lcm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Taun kamela serei pok kamela arai ta kitolapo rot punuk, using a mataritol katapo maiten luai. Na parik kitolpa anguan malangas an ta kitol antok ia ta sa. ");
INSERT INTO lcm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Na kamela vapotol i serei pok na kala antok iritol, “Au sa, mipo rot lak, na mipo ausai lak? Kala angkoai. Taun kana kala serei ani ki alis suai ani igenen i pukun e kungaria i ri vap bil arikek. ");
INSERT INTO lcm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mitol tadut na tara pasal. Arai ani iuang kana kalapo serei asi kana me alis suai anig.” ");
INSERT INTO lcm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Na akorong palau, si taun ang kapo mengen lak, Iudas kala serei, mangsikei i 12 na nat ang, na petau lava kipo aimung ina na kipo teng ri samele na ri avam, i la asok tapai ta keve ainoinoai si ri katakai i sula ve ri vap malangas ani saupai na ri vap lava i rina. ");
INSERT INTO lcm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Vo alis suai ania katala antok amalangas lenginang iria ta mang akanangai asukang ke, “Si man na lulus a si, ninia palau a igenen ang, mi teng akit ia, na mi tak akipai ania na kan ago si aiveven kitmat.” ");
INSERT INTO lcm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Au, kala serei na kala paliu akorong taun ia na kanla antok, “Rabi!” velai ani kala lulus ia. ");
INSERT INTO lcm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Na kila teng akit ia. ");
INSERT INTO lcm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Na mangsikei katapo tung asung e iang kala dal kana samele na kala tanga suai luai ani talingana i asosokai si ainoai i katakai i sula. ");
INSERT INTO lcm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Na Iesu kala antok iria ta, “Au si napo katakai i tainau na mipo ruduai iau ta samele na avam? ");
INSERT INTO lcm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Keve taun natapo vil akalit e matami nei rina i atailai na parik mitapa teng akit iau. Sikei, kapo serei asi atutuman ani mengen i nei salsalik.” ");
INSERT INTO lcm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Na riria aongos kila papelek ia na kila sip suai. ");
INSERT INTO lcm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Mang sikei a igenen tanginang kata using ia, kapo kavat palau ta sikei a vuk vakup, na kila kun teng akit ania. ");
INSERT INTO lcm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Sikei kala sip taliung kana vakup ta pukun varas palau. ");
INSERT INTO lcm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Na kila tak a Iesu ane si ainoai i katakai i sula. Keve ainoinoai si ri katakai i sula kuvul ve ri vap lava na keve vap malangas ani saupai kitapo ago kuvul e iang. ");
INSERT INTO lcm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Na Petero katapo using avunga na kala palak nei omo i lu si ainoai i katakai i sula. Na kanlapo sinong maringin mete kut kuvul ve vap po ararai bat ang. ");
INSERT INTO lcm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Au, keve ainoinoai si ri katakai i sula ve kuvkuvulan lava i po vil saupai kitapo gule vap asi mengen angkoai asi kari saupai ani Iesu singina using kitapo buk raung ania. Sikei parik kipa sabonai ta akuskus tutuman. ");
INSERT INTO lcm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Using vap miang kitapo kapau na kari keve akuskus parik katapa angkuvulai. ");
INSERT INTO lcm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Na mang matan vap kila tadut na kila poso mengen kapau ania asukang ke, ");
INSERT INTO lcm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Namemta longong ia, katapo mengen asukang ke ta, ‘Naka goeng na rina i atailai ke ri vap kita atung ia, na e mung i potol a taun, naka atung pok a mang sikei nang parik kipa abis ia ta kunga.’” ");
INSERT INTO lcm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na vap ke kapa, si kari keve akuskus, kapo tav angkuvulai. ");
INSERT INTO lcm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Au, ainoai i katakai i sula kala tapasuk e mataria aongos na kala sui a Iesu ta, “Au sa parik kupa ngenget a mengen suke? Au sa sukana si atugtugi suke kipo mengen anim tatana?” ");
INSERT INTO lcm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sikei kapo tung musik palau, parik kapa posong ta vuk mengen. Na ainoai i katakai i sula kala anguan sui an ania ta, “Numai a igenen i akanangai, nat i vopo ro luai ang?” ");
INSERT INTO lcm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Na Iesu kala antok ta, “Io, nau palau. Na mi arai lak ani igenen i pukun kan sinong e palso i vo kitmat na ka pasiang kuli kuku le pangkul.” ");
INSERT INTO lcm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Na ainoai i katakai i sula kala ding pok kana maus na kala antok ta, “Kalapo kovek i mang mengen tarapo inongos taun ia. ");
INSERT INTO lcm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mitala longong kana mengen i nau varas. Nei kami lomlomonai?” Na ria aongos kila saupai ainak ta kalapo ago asi vil punuk ania. ");
INSERT INTO lcm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Na mang matan iria kipo kanus ia. Ki volo bat a matana na kipo nak ia na kipo asok ia ta, “Ku kin vang.” Na ri vap po ararai bat ang kila tak le ia na kianla bis ia. ");
INSERT INTO lcm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petero katapo ago lak e kevkev i nei omo ang, na sikei i keve kavulik asosokai si ainoai i katakai i sula kamela pasal asung. ");
INSERT INTO lcm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Taun ang kala arai ani Petero si po maringin na kala pal akit ia, na kala antok, “Numai kapa nang, kutapo auai ve Iesu le Nasaret.” ");
INSERT INTO lcm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sikei kala gel suai ania ta, “Parik napa nas, na parik napa malangas a sa kupo mengen tatana.” Na kala soung suai ane komo. Na si taun ang akorong pura kala tirtiriku. ");
INSERT INTO lcm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Na kavulik ang kala arai ania e iang na kala anguan atatai pok an ani vap po tung angasungai ang ta, “Igenen ke kapo mang sikei iria!” ");
INSERT INTO lcm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Sikei kala anguan gel pok an. Na e mung lik palau vap po tung angasungai ang kila antok a Petero ta, “Tutuman luai, kupo mangsikei iria, using kupo igenen i Galilaia.” ");
INSERT INTO lcm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Na kalapo mengen amadot ta man kapo kapau, kapo ro ka mat na kala atuvala ta, “Parik napa nas a igenen ke mipo mengen tatana.” ");
INSERT INTO lcm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Akorong palau na pura kala apongua i tirtiriku, na Petero kala lomlomonai pok ani mengen ang Iesu kata antok ia tatana ta, “Aino le ani pura ka apongua i tirtiriku, kula amatan potol a agel suai anig.” Na kala tameng a vingana na kala tangis alava. ");
INSERT INTO lcm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Si tenei vauk lik keve ainoinoai si ri katakai i sula na ri vap lava na ri vap malangas ani saupai na aongos nei kuvkuvulan ang kila lomlomonai kuvul, na kila got a Iesu na kila takai ania asi an alis suai ania e kungana i Pilato. ");
INSERT INTO lcm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Na Pilato kanla sui ia ta, “Au, numai a tulava si ri Iudaia?” Na kala polpol ia ta, “Numai kupo kin ia.” ");
INSERT INTO lcm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na keve ainoinoai si ri katakai i sula kila porot akit ia ta keve bil miang. ");
INSERT INTO lcm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Na Pilato kala anguan sui an ania ta, “Au sa, parik kupa buk polpol? Arai, kipo tupang ua ta keve bil miang.” ");
INSERT INTO lcm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sikei Iesu kapo tav posong ta ring vuk mengen lik, na Pilato kalapo sugul ia. ");
INSERT INTO lcm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Si taun i matan angan i Liuluai katapo uli akala suai ani saka igenen an ri vap kipo posong ia. ");
INSERT INTO lcm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Na nei liuan i vap ang kipo ago nei akangbat, using kitapo daung nei visvis misagai, katapo atogon a igenen, kana asan ta Barabas. ");
INSERT INTO lcm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Na ri vap kimela serei na kilapo sokotuk a Pilato ta ka abis aniria val kana lau. ");
INSERT INTO lcm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Na kala sui iria ta, “Au, mipo buk iau asi kag akala dong animi ta tulava ke si ri Iudaia?” ");
INSERT INTO lcm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Using katapo malangas ta keve ainoinoai si ri katakai i sula kita alis suai ania using kitapo vinga rikek. ");
INSERT INTO lcm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Sikei keve ainoinoai si ri katakai i sula kila asum a petau ang asi kari posong ta Barabas ka kala. ");
INSERT INTO lcm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Na Pilato kala anguan sui an aniria ta, “Au, saka nem an mipo buk iau asi kag vil ania si igenen ke mipo posong ia ta tulava si ri Iudaia?” ");
INSERT INTO lcm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Na kila songosongo alava pok ta, “Atakuk ia kuli ngakputuk!” ");
INSERT INTO lcm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Na Pilato kala antok iria ta, “Marai sa? Saka rikek an akorong kata abis ia?” Na kila songosongo alava luai ta, “Atakuk ia kuli ngakputuk!” ");
INSERT INTO lcm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Na Pilato, using katapo buk auruk ani petau ang, kala akala na Barabas dong iria. Na kala asok si sasaup ani Iesu, na kala alis suai ania asi kari an atakuk ania kuli ngakputuk. ");
INSERT INTO lcm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Au na ri katakai i visvis kila tak alak ia ane nei lu si tulava, nang a nan komo lava, le na kila songo akuvul alak aongos a petau lava iria. ");
INSERT INTO lcm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Na ki luk a vakup miminaungan na ki alak ia tatana, na kila abis a kuku ta angus sisilo na kila agon ia e patuna. ");
INSERT INTO lcm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Le na kipo atung alakat kunga ania. Na kipo kurek ia asukang ke ta, “Pua kala ro luai, tulava si ri Iudaia!” ");
INSERT INTO lcm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na ki ngamis ia e patuna ta ue, kipo kanus ia, na kipo sovusulai singina. ");
INSERT INTO lcm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Si taun kila kamus ta kurek ania kila luang suai pok ani vakup miminaungan ang na kila alak akorong pok ia ta kana maus. Au na kila tak ia si kari an atakuk ania kuli ngakputuk. ");
INSERT INTO lcm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na kila aisul pulit a mang igenen e selen Simon le Kurene, katapo palak taun a rina lava, na kapo tamarilong i ri Aleksandero ve Rupo, asi asalak ani kana ngakputuk. ");
INSERT INTO lcm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na kila tak ia ane si mangsikei a vuk oring kipo kin ia ta Golgota, supsupai ina ta vangang kumut. ");
INSERT INTO lcm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na kila alis ia ta laman i vaen mimirikukan, sikei kala misag ani inum ania. ");
INSERT INTO lcm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Na kila atakuk ia kuli ngakputuk na kila gulang angkasai asi arai ta ki saka pagal an ani kana maus aniria. ");
INSERT INTO lcm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kata lapo tenei vauk na kila atakuk ia kuli ngakputuk. ");
INSERT INTO lcm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na kita salik a nem ang kitapo tupang ia singina asukang ke ta, “Tulava si ri Iudaia.” ");
INSERT INTO lcm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Na ngerena kita atakuk a mang ngono katakai i tainau, sikei e palso na mang anu e palkais ina. ");
INSERT INTO lcm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Na vap po pasal angpok ang e iang kipo mengen i asosol ania na kipo valai ani paturia na kipo antok, “Numai vo antok ke ta ku galang na rina i atailai na ku atung pok ia si potol a taun, ");
INSERT INTO lcm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ku asapang pok ua. Pasiang suai ani ngakputuk ang!” ");
INSERT INTO lcm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Na asukang kapa keve ainoinoai si ri katakai i sula ve vap malangas ani saupai kipo kurek angpok tatana asukang ke ta, “Katala asapang a mang vap, sikei parik kapa angkoai si asapang pok ania. ");
INSERT INTO lcm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Igenen i akanangai ke, nia na tulava si ri Israel, ka kiksiang pelek a ngakputuk ang asi kara arai na tara lomlomon tatana!” Na ngono igenen ang kita atakuk kuvul irilong ve nia kilongpo kun mengen arikek ania. ");
INSERT INTO lcm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Vuk taun ke katapo mang ias lava, sikei vong kala pakut a kuli rina aongos tung si kalapo ngelik aliu. ");
INSERT INTO lcm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Na si kalapo ngelik, Iesu kala songosongo alava ta, “Eloi, Eloi, lama sabakatani?” Supsupai ina ta “Kag God, kag God, sa tukulai ina kulapo papelek iau?” ");
INSERT INTO lcm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Na mang matan vap po angtung ang e iang kila longong ia na kilapo antok ta, “Arai, kapo songo nang a Elias!” ");
INSERT INTO lcm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Na mang sikei a igenen kala sang na kanla luk a rudum katapo duk ta vaen namin mal singina, na kala atung ia e nono i vuk iei na ka lis ia asi kana inum, velai ani mengen asukang ke ta, “Kokoai, tara arai kotok ta Elias kame asapang ia.” ");
INSERT INTO lcm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Na Iesu kala songosongo alava luai na kala kamus ta aus. ");
INSERT INTO lcm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na vakup ang nei lu i atailai kala tading angtaliungai le pangkul tung e kevkev. ");
INSERT INTO lcm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na mang ainoinoai si ri katakai i visvis katapo tung talang ia kuli ngakputuk, kata longong ia si akamusai i aus, kala mengen asukang ke, “Tutuman luai, igenen ke kapo nat i God.” ");
INSERT INTO lcm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na e iang kapa, mang matan aina kitapo tere le ring vunga. Nei liuan iria ri Maria Magdalene ve mang Maria rinarilong i Iakovo lik ve Ioseto, na Salome, ");
INSERT INTO lcm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","kitapo uli auai ve nia aino e Galilaia na kitapo papakangai ania, au na mang keve aina miang kapa, riria kita auai alak kuvul ane Ierusalem ve nia. ");
INSERT INTO lcm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na si kalapo ngelik luai, using a taun ke kapo taun i usausa ani taun i atailai ilesvauk, ");
INSERT INTO lcm_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","na Iosep le Arimataia, mangsikei a posongan i nei kuvkuvulan lava, na katapo atu mata ta kana vainagoan a God, kamela serei si Pilato, using kapo tav lolokovo e matana, na kala aikut ia ta pukun ina i Iesu. ");
INSERT INTO lcm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Au, taun ang a Pilato kala longong ta katala mat lenginang, kalapo taping na kala songo na ainoinoai si ri katakai i visvis asi kana me luk malangas aro. ");
INSERT INTO lcm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","E mung i kana la longong tapai le si nguruna i ainoinoai ang ta katala mat, kala alis a pukun si Iosep. ");
INSERT INTO lcm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Na kanla samui le na vuk vakup roron luai na kamela kopos asiang ia na ka pakut ia ta vakup ang. Au na kanla amatung ia nei mangsikei a mata kita se ia nei bang. Na kala ul bat a mata ang ta iat lava. ");
INSERT INTO lcm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdalene na Maria rinana i Ioseto kilongta arai ani ring ang kata amatung a matmat singina. ");
INSERT INTO lcm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Taun i atailai kala kamus na ri Maria Magdalene ve Maria rinana i Iakovo, na Salome kila samui bil sain ro le asi kari amoi ania. ");
INSERT INTO lcm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Si tenei vauk lik i taun tanginang e mung i taun i atailai, si makarap kalapo sanglak, kila pasal taun a mata ang. ");
INSERT INTO lcm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na kipo angsusuiai angpokpokai aliu aniria ta, “Si kana kan ul suai ani iat mete mata ang?” ");
INSERT INTO lcm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Au, kila takngo na kila arai ta lenginang kitala ul suai ani iat ang, using katapo iat lava luai. ");
INSERT INTO lcm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Au, kianla riuk lak nei mata ang na kila arai ani mang igenen tanginang katapo sinong e palso, katapo alak kana vakup posok, na kilapo sugul taping. ");
INSERT INTO lcm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Na kala antok iria ta, “Mi ago ta taping an. Mipo gule na Iesu le Nasaret nang kita atakuk ia kuli ngakputuk. Katala tadut pok. Kapo kovek e ke. Arai kana na oring i amatung ania. ");
INSERT INTO lcm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sikei, mi pasal na mianla mengen kana keve nat i akalit kuvul ve Petero kapa, ta ka pasal aino imi ane Galilaia, na mian arai ania e iang, asukang palau val katala antok imi tatana.” ");
INSERT INTO lcm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Na kila soung suai na kila sip velai ani tetek na taping. Kitapo tav mengen ani mangsikei using kita lapo leng. Vuk palpal ke (16:9-20) katapo tav ago le si ainoai i salsalik. Vei kitala alakai ania e mung.  ");
INSERT INTO lcm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Na taun kala tadut pok tenei vauk lik i taun tanginang e mung i taun i atailai, kala tung aserei aino si Maria Magdalene, nang kata lu suai ani limalengua na ingua ang pelek ia. ");
INSERT INTO lcm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Na kala pasal na kanla antok a keve tungana si kitapo makus na kipo tangis. ");
INSERT INTO lcm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Taun ang kila longong ta katala to pok, na katanla arai ania, parik kipa lomlomon tatana. ");
INSERT INTO lcm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","E mung ina kala tung aserei ta mang pukun si pongua na nat i akalit si kilongpo pasal pok ane rina. ");
INSERT INTO lcm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Au, kilongla tapasuk pok na kilongmela mengen a mang matan ang, sikei parik kipa lomlomon tatana. ");
INSERT INTO lcm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Na e mung kamela tung aserei si 11 a nat i akalit akorong si kipo angan. Kala tatapokai aniria using parik kipa lomlomon na kapo kitmat kapa na vingaria, using parik kitapa lomlomon ta mengen si vap ang kitala arai ania e mung i kala tadut pok. ");
INSERT INTO lcm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na kala antok iria ta, “Mi pasal na mian akuskus a ri vap aongos kuli rina ta akus ro. ");
INSERT INTO lcm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Na man a si ka lomlomon na mi asing tauia ia, ka to, sikei man a si kapo tav lomlomon, ka sunguk a mamaiten i kana rikek. ");
INSERT INTO lcm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Keve akanangai ke, ri vap lomlomon ki asereiai ania. Si asan ig ki kirikai ani ri ingua, ki mengen ta mengen i keve rina angpetpetekai. ");
INSERT INTO lcm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ki teng alakat ri kene, na man ki inum a saka maras an, parik kipa rikek tatana, na ki amatung kunga lakat kuluria kipo malepen, na kila ro pok.” ");
INSERT INTO lcm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Asukang a Volava Iesu, e mung i kana la mengen asip aniria, kala palak ane pangkul, na kanla sinong e palso ina i God. ");
INSERT INTO lcm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Na kila pasal na kianla akuskus nei keve rina aongos. Na e iang Volava kata atutuman kari mengen si keve akanangai ang kitapo vil ia e mataria i ri vap. Au na keve bil aongos ang kitala longong ia, kianla mengen amalangas akudik ri Petero ve vap po auai ang ve nia. Na e mung ina, Iesu nia akorong kala asok iria ane si keve palpal aongos i kuli rina, ani kian akuskus amalangas ta akus daus na tokos i vilvil ato ane si to asikei. ");
INSERT INTO lcm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Vap miang kitala salik a mang keve akuskus i keve bil ang kilapo serei atutuman nei liuan ira, ");
INSERT INTO lcm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","asukang val kita luk le si vap po tung ang ani Akus, nang riria vap ang kitapo arai ani keve bil ang ta mataria akorong le si ainoai i taun. ");
INSERT INTO lcm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Asukang a nau kapa, using natala luk ia si kag gusgus aro luai ani keve bil aongos le si ainoai i taun tung kana anginang, natapo lomlomonai ani naka salsalik aroron a atugtugi ina anim, kag igenen roron luai ta Teopilo, ");
INSERT INTO lcm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ani kula kun nas ta keve akalkalit ang kutala luk ia kapo tutuman luai. ");
INSERT INTO lcm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Si taun ang a Erodes katapo tulava i palpal Iudaia singina, mangsikei a katakai i sula katapo ago, kana asan ta Sakarias, le si keve katakai i sula si kuvkuvulan ang si Abia. Na kisngana katapo mangsikei a aina le si patvap si Aron, kana asan ta Elisabet. ");
INSERT INTO lcm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Rilong aongos kilongtapo uli lau korong e matana i God, na kilongtapo uli using aro ani keve asok na saupai si Volava, na katapo kovek i oring asi mengen arikek anirilong singina. ");
INSERT INTO lcm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na kilongtapo kovek i inatus using a Elisabet katapo ngolo na rilong aongos kilongta lapo lapan paspasal. ");
INSERT INTO lcm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Au, mangsikei a taun katapo teng kana abis i sula, using ke kana kuvkuvulan ta taun si abis mete God, ");
INSERT INTO lcm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","asukang val kari laulauan ipo gusgus, kitala sabonai ania ta kakana ta taun ani ka palak ane nei lu i atailai si Volava asi an sula ani bil sain roron. ");
INSERT INTO lcm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Na ri vap aongos kitapo ago e komo ipo sokotuk, si taun i po sula. ");
INSERT INTO lcm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Na mangsikei a angelo si Volava kala tu aserei singina na kame lapo tung si palso i pata ipo sula. ");
INSERT INTO lcm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Na kala taping a Sakarias si arai ani bil asukang, velai ani kapo leng. ");
INSERT INTO lcm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Au na angelo ang kala antok ia ta, “Ku ago ta leng an, Sakarias, using kam sokotuk kitala longong ia, na kisngam ta Elisabet ka ingus ta kam nat, na ku atuk ia ta kana asan, Ioanes. ");
INSERT INTO lcm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ku uruk alava na vap miang ki maramarak si kana serei, ");
INSERT INTO lcm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","using ka igenen lava e mete Volava, na ka alal ani vaen ve mang keve laman kit. Na Malanganto Gogoai ka aol ia le si taun kapo ago lak e vingana i rinana. ");
INSERT INTO lcm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ka songo pok amiang i ri Israel taun a Volava kari God, ");
INSERT INTO lcm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","na ka pasal aino e matana ta dual na kitmat val Elias, asi kana asinong kuvul pok ani ri angtama, na ka ulpokai ani vap longobot ani ki atogon pok a lomlomonai korong, na e iang ka itoiton akokoai ani Volava ta kana vap.” ");
INSERT INTO lcm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Na Sakarias kala sui a angelo ang ta, “Na saka malangas an ta bil ke kapo tutuman? Using nau nalapo lapan na kisngag kapa kalapo lapan luai.” ");
INSERT INTO lcm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Na angelo ang kala polpol ia asukang ke, “Nau kana na Gabariel vopo uli tung ke mete God, na kata asok iau asi kag me mengen amalangas anim ta akus ro ke. ");
INSERT INTO lcm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na ku arai, ku tav angkoai asi pege, na ku ago bot tung si taun ang a keve bil kala serei atutuman singina, using parik kuta lapa lomlomon ta kag mengen, nang voiang ka serei atutuman si kana taun.” ");
INSERT INTO lcm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Na vap ang e komo kilapo ko na Sakarias na kilapo sugul ta marai sa kalapo amun a taun lava ang nei lu i atailai. ");
INSERT INTO lcm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Au na taun kamela soung, parik katapa angkoai si ka pege iria, na kila malangas ta katala arai ani ararai nei lu i atailai. Na kala atoktokngai ta kungana sikei kapo bot. ");
INSERT INTO lcm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na taun ang kala akamusai ani kana taun i abis, le na kala pasal pok ane si kana rina. ");
INSERT INTO lcm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na mang rukun taun e mung kisngana Elisabet kala atogon sungsungukan na asukang parik katapa pasal pelek a nei lu ani palpalima na ulen aongos. Kala antok ta, ");
INSERT INTO lcm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kana vang, Volava kala akalit iau ta kana lomlomonai roron na kala luk suai ani kag mese e mete ri vap!” ");
INSERT INTO lcm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Au, si va limalesikei i ulen, God kala asok kana angelo Gabariel asi kana pasal taun ani mang rina e palpal Galilaia, kana asan ta Nasaret, ");
INSERT INTO lcm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ane si mangsikei a kavulik tanginang, ila pala ani mang igenen kana asan ta Iosep, le si patvap si David. Kana asan a kavulik ang ta Maria. ");
INSERT INTO lcm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Au, kala serei singina na kala antok ia ta, “Kala ro, numai a kavulik roron luai. Volava ve numai!” ");
INSERT INTO lcm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Na kala pisu alava si mengen ang, na kapo sugul ta nei a supsupai i mengen i angruduai ang. ");
INSERT INTO lcm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na angelo ang kala antok ia ta, “Ku ago ta leng an Maria, using a God katala lomon aro ua. ");
INSERT INTO lcm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Arai, ku atogon lak kam sungsungukan, na ku ingus asereiai ta nat tauan, na ku atuk ia ta Iesu. ");
INSERT INTO lcm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ka serei a igenen lava na ki posong ia ta nat i Vopo Tavirimok Luai ang. Na Volava God ka atung ia ani ka tulava val tivuna ta David. ");
INSERT INTO lcm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Na ka tulava asikei i matan vap ang si Iakov na kana vainagoan parik kapa angkoai si ka kamus!” ");
INSERT INTO lcm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Na Maria kala antok a angelo ang ta, “Bil ke ka saka serei an? Using parik lak natapa ago ve ri tauan.” ");
INSERT INTO lcm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Na angelo ang kala atai ia ta, “Malanganto Gogoai ka riuk lak singim na kitmat i Vopo Tavirimok Luai ka aol ua. Asukang na nat daus ang ku ingus lak ia, nia na nat i God. ");
INSERT INTO lcm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ku arai ani tungam ta Elisabet, si kalapo lapan luai. Kitapo lomon ia ta kapo ngolo sikei kana kalapo va limalesikei i ulen ani kana sungsungukan. ");
INSERT INTO lcm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Using si God kapo kovek luai i bil kapo kitmat.” ");
INSERT INTO lcm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Na Maria kala antok ta, “Nau kana na asosokai si Volava. Ka serei singig val kam mengen.” Le na angelo ang kala pasal pelek ia. ");
INSERT INTO lcm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Si pangau i taun ang, Maria kala tapasuk na kala sumasuma suai taun a palpal mulangan ane si mang rina e Iudaia. ");
INSERT INTO lcm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Na kala palak ane nei lu si Sakarias na kanla mengen i angruduai ve Elisabet. ");
INSERT INTO lcm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Taun ang a Elisabet kala longong kana mengen a Maria, popo ang e vingana kala aupele na Elisabet kala sung pukun ta Malanganto Gogoai, ");
INSERT INTO lcm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","na kala songosongo alava ta, “Numai kupo aina i atautauia luai ani ri aina aongos, na atautauia ka ago si nat ang ku ingus ia! ");
INSERT INTO lcm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Pua, marai sa na bil roron ke kapo serei singig ta rinana i kag Volava kapo serei si me arai anig? ");
INSERT INTO lcm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Using vuk taun ang palau nata longong kam mengen i angruduai, popo ke e vingag kata aupele ta uruk. ");
INSERT INTO lcm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Vei sa ta tauia ang kupo atogon ia si lomlomon ta kana mengen a Volava singim ka serei atutuman!” ");
INSERT INTO lcm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Na Maria kala antok, “Napo sunguk alak a Volava ta kag to aongos. ");
INSERT INTO lcm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Malanganto ig kapo uruk si God, ninia katala asapang iau. ");
INSERT INTO lcm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Using katala lomlomonai ani kana asosokai vopo ago e kevkev ke. Using arai, kana na iles lak a mamain ta polpolokan ki kinle na bil roron ke singig. ");
INSERT INTO lcm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Io, using a Vokitmat kalapo abis kana abis lava singig. Asan ina kapo gogoai luai. ");
INSERT INTO lcm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mamain ta polpolokan voiang kipo uli mamaila ania, kana ngorem kapo pataun iria aongos, kana na iles lak e mung. ");
INSERT INTO lcm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Katala abis a mamain ta abis lava ta kitmat i kungana. Kata musa suai ani vap po alalakas pok ang tataria e lomlomonai iria. ");
INSERT INTO lcm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Katala asuai ani ri vap madot le si kari sinsinong lakat, sikei riria vap po ago ang e kevkev, katala sunguk alak iria. ");
INSERT INTO lcm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Katala amasung na vap po mol ang, sikei ri tauia, katala asok suai aniria ta kunga vauvau. ");
INSERT INTO lcm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Katala pakangai ani kana asosokai Israel. Kapo tav lomon taun lak kana ngorem, ");
INSERT INTO lcm_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","taun a Abaram ve mamain ta tivuna asikei, asukang val kana mengen taun ani keve tivura.” ");
INSERT INTO lcm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Au na Maria kanla ago ve nia ani potol a ulen aongos le na kamela pasiang pok ane rina. ");
INSERT INTO lcm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Au, taun kalapo sinong ani Elisabet asi ingus, na kala ingus kana nat tauan. ");
INSERT INTO lcm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na vap po ago ang ngerena kuvul ve kana patvap kila longong ta Volava katala abis a abis i ngorem lava singina, na kilapo maramarak kuvul ve nia. ");
INSERT INTO lcm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Au, si va limaletul i taun kila serei asi me lampulit ani nat ang. Na kilapo buk atuk ania ta asan i tamana, Sakarias. ");
INSERT INTO lcm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sikei rinana kala antok ta, “Parik! Kana asan nang ta Ioanes.” ");
INSERT INTO lcm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Na kila antok ia ta, “Kapo kovek ta si i kam patvap katapo asan asukang.” ");
INSERT INTO lcm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Na kila atoktokngai ane si tamana asi susuiai ania ta kana lomlomonai i atuk ani kana asan. ");
INSERT INTO lcm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Au, kala sokotuk ta bil asi salsalik na kala salik asukang ke, “Kana asan ta Ioanes.” Na kila taping aongos. ");
INSERT INTO lcm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na akorong si vuk pangau ang kala vil korong ia ani ka mengen, na kalapo alatun a God. ");
INSERT INTO lcm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Na vap aongos ang kilapo leng. Na akuskus i keve bil ke kala pasal apapanai aulit a keve rina aongos i palpal mulang ang e Iudaia. ");
INSERT INTO lcm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Riria kita longong kilapo lomon akit a keve bil ke velai ani sui ta, “Nat ke kana, kapo polok ani ka saka igenen an?” Using a kitmat i Volava katapo ago singina. ");
INSERT INTO lcm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Na tamana ta Sakarias kala sung pukun ta Malanganto Gogoai, na kala akus amalangas asukang ke. ");
INSERT INTO lcm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Atautauia ane si Volava, ninia na God si ri Israel. Kamela serei vanang na kamela samui apok kana vap. ");
INSERT INTO lcm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Katala atung anira ta igenen madot le si patvap si kana asosokai ta David ani ka asapang ira. ");
INSERT INTO lcm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Asukang val katala kin ia le kabang si ngururia i kana keve katakai i kus amalangas daus. ");
INSERT INTO lcm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Na ka asapang ira pelek a mamain ta vap ipo marala anira, ani ki ago ta vil arikek an anira. ");
INSERT INTO lcm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","E iang ka akalit ta kana ngorem taun a keve tivura, si kana lomlomonai pok ani kana palapalatung gogoai. ");
INSERT INTO lcm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Atuvala ang kata kin dong a tivura ta Abaram tatana ");
INSERT INTO lcm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ani ka asapang ira pelek a mamain ta vap ipo marala anira, ani tara abis pakangai ania ta tav leng ");
INSERT INTO lcm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","na vinga daus na lau korong si keve taun aongos i kara to e kuli rina. ");
INSERT INTO lcm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na numai kag nat, ki posong ua ta katakai i akus si Vopo Tavirimok Luai ang. Using numai vanang ku an pasal aino ani Volava, si itoiton ania ta selen asi kana pasal. ");
INSERT INTO lcm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Asukang vang ku amalangasai ani kana vap ta selen asi kari sapang si lomon suai ang ani kari keve lau rikek. ");
INSERT INTO lcm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Using le si ngorem tangis ang si kara God, na tangat ka pasiang ane singira le metekuku. ");
INSERT INTO lcm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Na ka mang si vap po ago ang nei vong na nei kankanuai i mat, ani ka ausingai anira ane si selen i luai.” ");
INSERT INTO lcm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Na nat ang kalapo polok alak na kalapo igenen madot si Malanganto. Katanpo ago e nei ring varasai palau tung si kamela serei e ring malangas mete ri Israel. ");
INSERT INTO lcm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Si pangau i taun ang, Kaisar Augusto kala asok asi luk asan aongos e kuli rina. ");
INSERT INTO lcm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Luk asan ke katapo ainoai i luk asan si taun i saupai ani palpal Suria ta Kurenio. ");
INSERT INTO lcm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Asukang na ri vap aongos kila pasal asian atu asan si kari keve rina i ingus akorong. ");
INSERT INTO lcm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Na Iosep kapa kala kun pasal le Galilaia le si rina ang Nasaret, na kala pasal ane Iudaia ane si rina si David, kana asan ta Betilem, using kata serei si patvap si David, ");
INSERT INTO lcm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","asi an salik atung kuvul ve Maria, kavulik ila pala atung ang ania, na kata lapo atogon kana sungsungukan. ");
INSERT INTO lcm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Au, kilongan lapo ago na taun kala serei ania asi kana ingus, ");
INSERT INTO lcm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","na kala ingus kana nat tuan na kala pakut ia ta keve vuk vakup na kala amatung ia nei vulvul, using katapo kovek i pangau anirilong nei lu ipo ausai tul ang. ");
INSERT INTO lcm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Si palpal rina ang, katapo atogon a mang keve katakai i aiveven sipsip kitapo ago e nei uten ipo ararai ani kari keve sipsip tenei vong. ");
INSERT INTO lcm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Na mangsikei a angelo si Volava kamela serei ataping singiria na miminaungan i Volava kala mang kuluria, na kilapo leng alava. ");
INSERT INTO lcm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Na angelo ang kala antok iria ta, “Mi ago ta leng an! Arai, napo serei kana ta akus roron animi, voiang ka asereiai lak ani uruk lava si ri vap aongos. ");
INSERT INTO lcm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Using kami katakai i asapang, kitala ingus ia anginang, nei rina i David. Nang a Karisto nia na Volava. ");
INSERT INTO lcm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kana vang na akanangai ina. Mi an sabonai ani popo lik ila pakut ta keve vuk vakup, na kapo matung nei vulvul.” ");
INSERT INTO lcm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Akorong palau na mang petau lava i metekuku kila tutu aserei kuvul ve angelo ang na kilapo alatun a God ta mengen asukang ke, ");
INSERT INTO lcm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Maumausan ane si God e pangkul luai! Na luai e kuli rina si vap ang kipo uruk aniria.” ");
INSERT INTO lcm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Na keve angelo ang kila papelek pok iria ane metekuku. Au, keve katakai i aiveven sipsip kila mengen angpokpokai aniria ta, “Au, tara sumasuma ane Betilem na tara an arai ani bil ang kana na Volava katala antok ira tatana.” ");
INSERT INTO lcm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na kila pasal suai sumasuma na kianla serei si ri Maria ve Iosep na kila arai ani popo lik ang kapo matung nei vulvul. ");
INSERT INTO lcm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Taun ang kila arai ania, kila mengen amalangas ta sa kitala longong ia e nguruna i angelo ani nat ang. ");
INSERT INTO lcm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Na vap aongos vo longong ang ani akuskus si keve katakai i aiveven sipsip ang, kilapo sugul alava. ");
INSERT INTO lcm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Sikei Maria kala lomon akit a keve bil ke na kapo uli lomlomonai aniria. ");
INSERT INTO lcm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Au, keve katakai i aiveven sipsip ang kila papok na ki sunguk alak luai ani miminaungan i God si sa kitala longong ia na bil ang kitanla arai le ania, nang palau val mengen ang kitala longong ia. ");
INSERT INTO lcm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na si va limaletul i taun kila lampulit ia, na kila atuk ia ta Iesu, asan ta angelo i atuk ang ania, aino le ani ka sungsungukan. ");
INSERT INTO lcm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Au, kalapo taun aniria asi an alilis i vilvil adaus val saupai si Moses, kila sunguk na popo ang ane Ierusalem na kianla asel ia e kungana i Volava. ");
INSERT INTO lcm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Val mengen i salsalik nei saupai si Volava, Kami keve nat tuan, mi asinong akipai aniria ane si Volava. ");
INSERT INTO lcm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Na kila alis kari alilis asi kana angkokoai val saupai si Volava, nang kapo antok ta pongua na uk vo pongua na mani tanginang asi alis. ");
INSERT INTO lcm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Au, katapo atogon a mang sikei a igenen e Ierusalem kana asan ta Simeon. Katapo igenen korong na kapo igenen lomlomon kapa. Katapo uli alis ani kana taun si kokoai ani God ani ka vil ato ri Israel. Na Malanganto Gogoai katapo ago singina. ");
INSERT INTO lcm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Malanganto Gogoai katala amalangasai ania ta parik kapa angkokoai si ka mat tung ka arai le ani igenen i akanangai ang si Volava. ");
INSERT INTO lcm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Au, Malanganto kala ainoai ania ane nei rina i atailai, na ngono angkisnganan ang kilong mela sunguk alak a nat ang, Iesu asi abis singina asukang val vubuk ang ta saupai, ");
INSERT INTO lcm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","kala ngot ia na kala alatun a God asukang ke, ");
INSERT INTO lcm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Volava, kula atolongon vang kana kam asosokai asi kana pasal ta luai, asukang val kam mengen. ");
INSERT INTO lcm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nalapo arai vang kana ta matag akorong ani kam abis i vilvil ato, ");
INSERT INTO lcm_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","i kam la itonai e mataria i mamain ta palpal vap aongos, ");
INSERT INTO lcm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ani ri vap i ngising, asi kari luk malangas singina, na kam matan vap ri Israel asi kari luk ani aminaung ina.” ");
INSERT INTO lcm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Na tamana ve rinana, kilongla sugul alava si mengen i posong ang ania. ");
INSERT INTO lcm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Na Simeon kala poso atautauia iria na kala mengen a rinana ta Maria ta mengen asukang ke, “Arai, nat ke kana, God kata atung ia ani vap miang i ri Israel. Ani mang matan ki uak marai ina, na mang matan ki tung atadut, na kapo akanangai le si God ani vap miang asi kari mengen arikek ania, ");
INSERT INTO lcm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","na numai, makus lava ka rongos a pakangat im val samele delek, ani ka vil amalangas a keve lomlomonai musik si vap miang.” ");
INSERT INTO lcm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Au, katapo atogon a mangsikei a katakai i kus amalangas kapa e iang, mang aina kana asan ta Ana. Tamana ta Panuel le si patvap si Aser. Aina ang kata lapo lapan luai. Aino kata osongon le na e mung i limalengua na matas palau kisngana kala mat. ");
INSERT INTO lcm_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Le si taun ang katapo ago i mainang. Na kana kalapo 84 a matas. Katapo uli ago akit nei rina i atailai. Si tenei ias na tenei vong kapo uli alal ve sokotuk serei si God. ");
INSERT INTO lcm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Au, si pangau ang akorong kamela palak na kala posong ro si God. Na kala mengen amalangas tatana si vap aongos ang kipo atu mata ta God ka samui pok a Ierusalem. ");
INSERT INTO lcm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Au, kila abis apunuk aroron tapai ani keve abis ang val saupai si Volava, le na kila pasiang pok ane Galilaia ane si kari rina akorong e Nasaret. ");
INSERT INTO lcm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na nat ang kala polok alak kuvul velai ani dual. Katapo nat masam aroron na alomon ro si God katapo ago singina. ");
INSERT INTO lcm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Si keve matas aongos rinana na tamana kilongtapo uli palak ane Ierusalem si an ago si matan angan i Liuluai. ");
INSERT INTO lcm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Na taun ang kalapo 12 na matas ania, na kila palak kuvul ane si matan angan ang val laulauan ro ina. ");
INSERT INTO lcm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Au, matan angan ang kala kamus le na kilongla pasiang pok ane rina, sikei nat ke na Iesu kalapo ago pok e Ierusalem. Rinana na tamana parik kilonglapa malangas ta bil ke. ");
INSERT INTO lcm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kilongtapo sekpat ta kata lapo auai ve kuvkuvulan lava ang. Asukang na kila pasal a sikei a taun kirol aongos le na kilongla tutapong gulegule ania si kari vap i atogon na keve tungaria. ");
INSERT INTO lcm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sikei parik kilong lapa sabonai ania. Asukang na kilongla palak pok ane Ierusalem asi an gule ania. ");
INSERT INTO lcm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Au, e mung i potol a taun kilonganla sabonai ania nei rina i atailai si kapo sinong ve ri katakai i akalit ipo kokolongong na susuiai aniria. ");
INSERT INTO lcm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Vap aongos ipo longong ang ania, kita sugul alava si kana malangas ro na kana keve polpol. ");
INSERT INTO lcm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Taun ang kilongmela arai ania, kilongla taping, na rinana kila antok ia ta, “Kag nat, marai sa kupo vil a lau ke singimemlong? Namemlong ve tamam namemlong tapo makus alava luai ipo gulegule anim.” ");
INSERT INTO lcm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Na kala sui irilong ta, “Marai sa milong tapo buk gulegule pok le anig? Parik milongpa malangas ta kag ring asi ago kana nei lu si mamai?” ");
INSERT INTO lcm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sikei parik kilongtapa malangas a vuk mengen ang kata posong ia singirilong. ");
INSERT INTO lcm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Na kala pasiang pok ve rilong ane Nasaret na kanlapo longong aro irilong. Rinana kita lomon akit a keve bil aongos ke e vingaria. ");
INSERT INTO lcm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Na Iesu katapo polok alak si masam kuvul ve pukun, na God kapo buk ia na ri vap kapa kipo kun buk ania. ");
INSERT INTO lcm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kata lapo 12 na matas i kana sinsinongan i saupai a Tiberio Kaisar, na Pontio Pilato kapo ainoinoai i Iudaia, na Erodes kapo tulava e Galilaia, na tasina ta Pilipo kapo tulava e ngono palpal i Ituraio na Tarakonitis, na Lusanias kapo tulava e Abilene, ");
INSERT INTO lcm_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","na ri Anas ve Kaiapas kilongpo ngono ainoai i katakai i sula, na kalingana i God kala serei si Ioanes, nat si Sakarias taun katapo ago nei ring varasai palau. ");
INSERT INTO lcm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Au, kala tapasuk na kanlapo pasal aulit a palpal aongos i sung ang e Iordanes, na kanpo akuskus ri vap ta ki luk a asing tauia asi akanangai ani kari la lomon pokai na God ka lomon suai ani kari keve lau rikek. ");
INSERT INTO lcm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Val Esias katakai i kus amalangas kata salik kana mengen nei buk asukang ke, Kalingana i mang igenen kapo songosongo e nei ring varasai palau asukang ke. Mi usausa na selen ani Volava, mi itonai ta selen korong ania! ");
INSERT INTO lcm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Keve lulung aongos asi tapus akorong ania, keve put na mulang asi bil amarul ania, keve selen lok asi koros akorong ania, keve selen silo asi tuk aro ania. ");
INSERT INTO lcm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Na ri vap i kuli rina aongos ki arai ani kana abis i vilvil ato na God. ");
INSERT INTO lcm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Au, petau tavirimok kimela serei singina ani ka asing tauia iria, sikei kala antok iria ta, “Nami na mamain ta natnat i kene! Si nang kata antok imi si sip pelek ani marala vo serei ang? ");
INSERT INTO lcm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sikei mi uai asereiai tapai ani lau bil voiang ka atai amalangas ta mitala lomon pokai. Na mi ago ta angmemengenai musik an ta mipo angtivu aro ve Abaram. Using napo antok imi ta God kapo angkoai si luk ani keve iat ke na ka asereiai ani keve tivuna i Abaram tatana! ");
INSERT INTO lcm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kaput nang kalapo tung usausa si tukul i ei. Keve ei ang vanang parik kipa uai ta uai roron, asi tanga suai dong ani kut.” ");
INSERT INTO lcm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Na petau lava ang kipo sui ia, “Namem abis a sa vang kana?” ");
INSERT INTO lcm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Na kala polpol iria asukang ke, “Si imi kapo atogon kana pongua na vakup ka alis a mangsikei ane si igenen vopo kovek ang, na ninia kapo atogon pok ka abis asukang kapa.” ");
INSERT INTO lcm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mang keve katakai i luk takis kila kun serei asi me luk asing tauia na kila sui ia ta, “Katakai i akalit, namem abis a sa vang kana?” ");
INSERT INTO lcm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Na kala antok iria ta, “Mi ago to luk takis asoliu an ani kami atutung.” ");
INSERT INTO lcm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Na mang keve katakai i visvis kapa kilapo kun sui ania ta, “Au, na namem, namem kun abis ani sa vang?” Na kala antok iria ta, “Mi ago ta luk kapkap palau an si ri vap ta kami dual na mi ago ta tupang palau an. Mi uruk palau ani kami seupok.” ");
INSERT INTO lcm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Au, ri vap aongos kilapo atu mata velai ani lomlomonai alava ta vei nganing a Ioanes kavpo igenen ke i akanangai ta God. ");
INSERT INTO lcm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Sikei Ioanes kala mengen amalangas aongos iria ta, “Nau napo asing tauia imi ta laman, sikei kapo atogon a mangsikei ka serei lak, kapo tavirimok anig, napo tav ro angkoai luai ve asosokai palau vopo luk suai ani pauk i kakina. Ninia vanang kame asing tauia imi ta Malanganto Gogoai ve kut ni. ");
INSERT INTO lcm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kalapo tung usausa asi kana irang suai ani keve katui i kon na kan sinong kuvul nei lu. Sikei ka suluk suai ani mung nei kut vo tav angkoai si mat ang.” ");
INSERT INTO lcm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Au, na si mang keve mengen miang kapa asukang, kapo asum iria na ka akuskus ta akus ro. ");
INSERT INTO lcm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Au na Erodes, tulava ke kapo nas ani tatapokai ania si kana keve lau rikek miang, na si kana lau rikek ta kalapo osongon ve Erodias, kisngana i tasina, ");
INSERT INTO lcm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","na kala vil a lau rikek lava luai ta ka alakai ani Ioanes nei lu i akangbat. ");
INSERT INTO lcm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Au, ri vap kila luk asing tauia aongos na Iesu kapa, kamela kun luk ani asing tauia. Vuk taun ang kapo sokotuk, metekuku kala tavas, ");
INSERT INTO lcm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","na Malanganto Gogoai kala pasiang na kamela gon singina asukang val pukun i uk. Na kalinga kala serei le metekuku ta, “Numai kag nat ro. Napo buk alava ua. Napo uruk luai anim.” ");
INSERT INTO lcm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ninia na Iesu kata lapo asukang ta 30 na matas na kala tutapong abis. Tamana i Iesu ta Iosep, ri vap kipo lomon ia asukang. Na Iosep tamana ta Eli ");
INSERT INTO lcm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","na Eli tamana ta Matat na Matat tamana ta Levi na Levi tamana ta Melki na Melki tamana ta Ianai na Ianai tamana ta Iosep ");
INSERT INTO lcm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","na Iosep tamana ta Matatias na Matatias tamana ta Amos na Amos tamana ta Naum na Naum tamana ta Esli na Esli tamana ta Nagai ");
INSERT INTO lcm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","na Nagai tamana ta Mat na Mat tamana ta Matatias na Matatias tamana ta Semein na Semein tamana ta Iosek na Iosek tamana ta Ioda ");
INSERT INTO lcm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","na Ioda tamana ta Ioanan na Ioanan tamana ta Resa na Resa tamana ta Sorobabel na Sorobabel tamana ta Salatiel na Salatiel tamana ta Neri ");
INSERT INTO lcm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","na Neri tamana ta Melki na Melki tamana ta Adi na Adi tamana ta Kosam na Kosam tamana ta Elmadam na Elmadam tamana ta Er ");
INSERT INTO lcm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","na Er tamana ta Iosua na Iosua tamana ta Elieser na Elieser tamana ta Iorim na Iorim tamana ta Matat na Matat tamana ta Levi ");
INSERT INTO lcm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","na Levi tamana ta Simeon na Simeon tamana ta Iudas na Iudas tamana ta Iosep na Iosep tamana ta Ionam na Ionam tamana ta Eliakim ");
INSERT INTO lcm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","na Eliakim tamana ta Melea na Melea tamana ta Mena na Mena tamana ta Matata na Matata tamana ta Natam na Natam tamana ta David ");
INSERT INTO lcm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","na David tamana ta Iesai na Iesai tamana ta Iobet na Iobet tamana ta Bos na Bos tamana ta Sala na Sala tamana ta Nason ");
INSERT INTO lcm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","na Nason tamana ta Aminadav na Aminadav tamana ta Atmin na Atmin tamana ta Arini na Arini tamana ta Esrom na Esrom tamana ta Pares na Pares tamana ta Iudas ");
INSERT INTO lcm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","na Iudas tamana ta Iakov na Iakov tamana ta Isak na Isak tamana ta Abaram na Abaram tamana ta Tara na Tara tamana ta Nakor ");
INSERT INTO lcm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","na Nakor tamana ta Seruk na Seruk tamana ta Ragau na Ragau tamana ta Palek na Palek tamana ta Eber na Eber tamana ta Sala ");
INSERT INTO lcm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","na Sala tamana ta Kainam na Kainam tamana ta Arpaksat na Arpaksat tamana ta Sem na Sem tamana ta Noa na Noa tamana ta Lamek ");
INSERT INTO lcm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","na Lamek tamana ta Matusala na Matusala tamana ta Enok na Enok tamana ta Iaret na Iaret tamana ta Malelel na Malelel tamana ta Kainam ");
INSERT INTO lcm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","na Kainam tamana ta Enos na Enos tamana ta Set na Set tamana ta Adam na Adam tamana ta God ");
INSERT INTO lcm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Au Iesu, Malanganto Gogoai kala aol ia na kala papok le si sung ang e Iordanes na Malanganto Gogoai kala ainoai ania e nei ring varasai palau ");
INSERT INTO lcm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ani 40 na mang ias aongos. Na e iang vo petau ang ania kanla atokngai ania. Si pangau aongos ang parik katapa angan ta men pok, asukang na e mung i pangau ang kalapo buk angan. ");
INSERT INTO lcm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Au, na vo petau kala antok ia ta, “Man numai a nat i God, ku asok a iat ke asi kana sakol ane si pok.” ");
INSERT INTO lcm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Na Iesu kala antok ia ta, “Kita salik ia ta, Parik kapa angkoai si ri vap ki to ta pok papa.” ");
INSERT INTO lcm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Au, vo petau kala songo alak ia na kanla akalit ia si vuk taun lik palau ta mamain ta vainagoan aongos i kuli rina. ");
INSERT INTO lcm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Na kala antok ia, “Na alis ua ta keve kitmat na keve tauia aongos ke nang kitala alis iau tatana asi kag alis ani sikei si kag pilpilak. ");
INSERT INTO lcm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Asukang na man ku soturungai singig io, kakam aongos ta keve bil ke.” ");
INSERT INTO lcm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Na Iesu kala antok ia ta, “Kita salik ia ta Ku soturungai si Volava kam God; na ninia papalik ku abis ania.” ");
INSERT INTO lcm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Au, kala songo ia ane Ierusalem na kanla atung ia si ring lakat luai kuli rina i atailai, na kala antok ia, “Man numai a nat i God, ku akik asiang, ");
INSERT INTO lcm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","using kita salik ia ta, Ka asok kana keve angelo asi kari aiveven aro anim, ");
INSERT INTO lcm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","na ki teng alakat ua ta kungaria vei kakim ka tukai si iat.” ");
INSERT INTO lcm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Na Iesu kala antok ia ta, “Kapo mengen ta, Ku ago ta atoktokngai an ani Volava kam God.” ");
INSERT INTO lcm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Au, kala kamus na vo petau si atoktokngai ania si keve selen aongos, na kala atolongon tapai ania kokoai ani mang taun roron e mung. ");
INSERT INTO lcm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Na Iesu kala papok ane Galilaia ta kitmat i Malanganto Gogoai na akuskus ina kala papanai si palpal aulitai aongos ang. ");
INSERT INTO lcm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Katapo vil akalkalit nei kari keve lu i kivung na vap miang kitapo alatun ia. ");
INSERT INTO lcm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Au, kamela serei e Nasara, kana rina i liklik. Na si taun i atailai kala palak nei lu i kivung val kana lau si keve taun. Na kala tung atung si tataot, ");
INSERT INTO lcm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","na kila alis ia ta buk i katakai i kus amalangas, Esias. Au, kala eres a buk ang na kala sabonai ani palpal ang si salsalik ke, ");
INSERT INTO lcm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Malanganto i Volava kapo ago singig. Kata akanangai anig ani naka akuskus ri vap mailik ta akus ro. Kata asok iau ani naka mengen amalangas ri vap po ago nei gogotan ta kila kalakala, na ri mata ba ta kila arai pok. Na ri vap po ago nei vilvil akui ta kila kalakala. ");
INSERT INTO lcm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na naka mengen amalangas ta taun i kana abis roron a Volava kalapo serei vang kana. ");
INSERT INTO lcm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Au, kala lun pok a buk ang, na kala alis pok ia si vopo aiveven ani lu ang, na kala soisinong. Vap aongos ang e nei lu ang kilapo tun akit ia. ");
INSERT INTO lcm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Na kalapo mengen iria ta, “Kana anginang mipo kolongong a mengen i vuk salsalik ke na kalapo serei atutuman vang kana.” ");
INSERT INTO lcm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Na kilapo man aongos ia. Ki taping ania si keve vuk mengen talupus ang kata asuai ania. Na kila angsusuiai ta, “Kana na nat ang si Iosep palau nang, ingko?” ");
INSERT INTO lcm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Na kala antok iria ta, “Napo malangas ta nganlak mi apunak iau ta mengen ke, ‘Au, katakai i vilvil ato, ku ato pok ua! Keve abis ang kutala abis ia e Kaparnaum, sa, parik kupa buk abis tapai ania e ke si kam rina?’” ");
INSERT INTO lcm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Na kala rodo kana mengen, “Napo antok atutuman imi ta kapo kovek i katakai i kus amalangas kipo ainainak ania si kana rina akorong. ");
INSERT INTO lcm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Io, tutuman luai, using si taun i Elias katapo atogon a keve mainang duk i Israel akorong si taun kovek i langit ang ani potol a matas na inongos kuvul ve buk angan lava ang e kuli rina aongos. ");
INSERT INTO lcm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sikei, kapo kovek i mangsikei iria, God kata asok a Elias taun ia. Kata asok ia taun a mangsikei a mainang le Sarepta e palpal Sidon. ");
INSERT INTO lcm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na ri vap pukun tapak kapa kitapo duk e Israel si taun i Elisaio, sikei parik ta sikei iria kata luk vilvil ato, parik. Naiman papalik, igenen ang le Suria.” ");
INSERT INTO lcm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Na vap aongos nei lu i kivung ang kila longong a mengen ang na kala pat iria na marala. ");
INSERT INTO lcm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ki tapasuk na ki lu suai ania pelek ani nei rina ang, na kianla tak alak ia ane kuli put ang kari rina katapo tung singina, asi an so asiang tatana le kuli bang ang, ");
INSERT INTO lcm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","sikei kala solong nei liuan iria na kala pasal suai. ");
INSERT INTO lcm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Na kala pasiang ane Kaparnaum, mang rina i Galilaia, na si keve taun i atailai kanlapo akalkalit ri vap. ");
INSERT INTO lcm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na kitapo taping ani kana akalkalit, using kana mengen katapo atogon kitmat. ");
INSERT INTO lcm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nei lu i kivung ang katapo atogon a mangsikei a igenen, malanganto rikek i ingua katapo aol ia, na kala songosongo alava ta, ");
INSERT INTO lcm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A! Iesu le Nasaret, kupo buk vil sa vang kana animem? Sa, kupo serei kana asi kam me vil punuk suai animem? Napo malangas ua. Numai a nat Gogoai i God!” ");
INSERT INTO lcm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Na Iesu kala atakun ia ta, “Ku musik! Soung suai ania!” Na ingua ang kala so tatana e mataria na kala soung suai ania, sikei katapo kovek i rikek e pukun ina. ");
INSERT INTO lcm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na kilapo taping aongos na ki mengen angpokpokai aniria ta, “Au, sa matan mengen kana kapo asukang ke? Arai, kapo asok velai ani kitmat na dual na ri malanganto rikek kipo soung suai!” ");
INSERT INTO lcm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Na akuskus ina kala pasal aulit a palpal aongos ang. ");
INSERT INTO lcm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na kala soung pelek a nei lu i kivung na kanla palak nei lu si Simon. Na omona i Simon katapo malepen i mulak, na kila sokotuk ia asi pakangai ania. ");
INSERT INTO lcm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Au, kala tung turung singina na kala atakun a malepen ang na kala papelek ia. Na akorong palau kala tapasuk na kala sasagi aniria. ");
INSERT INTO lcm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","E mung si makarap kalapo siang, ri vap kimela serei singina ta mamain ta tungaria kipo atogon malepen angpetpetekai, na kala amatung a kungana singiria siksikei na ka ato iria aongos. ");
INSERT INTO lcm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Na ri ingua kapa kilapo kun soung suai ani vap miang, velai ani kipo songosongo ta, “Numai a nat i God!” Sikei kala atakun iria, na parik kapa atalipai aniria asi mengen, using kipo malangas ta ninia na igenen i akanangai. ");
INSERT INTO lcm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Au, si tangat Iesu kala papelek a rina ang na kala pasal taun a mang ring kalakala. Na ri vap kila tutapongai gulegule ania na kianla sabonai ania na kila buk atakun ania asi kana ago akit ve ria, ");
INSERT INTO lcm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","sikei kala antok iria ta, “Kapo mamaiten ta nakan akus ta akus ro i kana vainagoan a God si mang keve rina kapa, using ninia vanang a tukulai i asok ke anig.” ");
INSERT INTO lcm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na kanlapo akuskus aliu si keve lu i kivung e Iudaia. ");
INSERT INTO lcm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mangsikei a taun katapo tung e ngerelo i laman tatapulit ang e Genesaret. Na ri vap kian lapo tabat aulit ia using kipo buk kolongong ani mengen i God. ");
INSERT INTO lcm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Na kala arai ani pongua na vul e ngere lo. Vap po maiak kuluna kitala siang na kilapo galui kari keve uvene. ");
INSERT INTO lcm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Na kala kokos kuli vul ang si Simon, na kala sokotuk ia ta ka pen sulai asiang lik ania pelek a ngerelo na kala sinong na kala akalit a ri vap. ");
INSERT INTO lcm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Au, taun ang kala kamus ta akuskus, na kala antok a Simon ta, “Ku kalip ane nei laman miting na ku an polok kam uvene.” ");
INSERT INTO lcm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na Simon kala antok ta, “Katakai i akalit, namemtala atokngai alava luai tenei vong aongos ke na parik namempa tul bonai ta ring ien, sikei kapo ro, using a kalingam, nan anguan polok an.” ");
INSERT INTO lcm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Au, kianla anguan polok an na ien kala duk luai na kari uvene kalapo buk tading using a ien vola duk arikek luai. ");
INSERT INTO lcm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Na kila songo na keve tungaria kuli mang vul ang ani ki pasal asung na kime pakangai aniria. Au, kimela voko asung na ki tak alak a uvene ang na kila akos ia. Rilong aongos a ngono vul ang kilongla duk arikek luai ta ien na kilong lapo buk gok ta maiten ina. ");
INSERT INTO lcm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Au, Simon Petero kala kinle na sa kapo serei na kala soturungai si ngono kakina i Iesu. Na kala antok ta, “Volava, ku pasal akipai anig, using nau a katakai i bil arikek.” ");
INSERT INTO lcm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Using ninia ve keve tungana kipo abis kuvul ve nia kipo taping arikek ani ien duk luai ang. ");
INSERT INTO lcm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nang kapa na Iakovo ve Ioanes, ngono nat si Sebedaio, kilongpo abis kuvul ve Simon. Au, Iesu kala antok a Simon ta, “Ku ago ta leng an. Kana vang kulapo tutapongai asi kam sog vap.” ");
INSERT INTO lcm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Na kila dal alak pok kari ngono vul. Ki atolongon a keve bil aongos na kila using ia. ");
INSERT INTO lcm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mangsikei a taun katapo ago si mangsikei i keve rina ang, na mangsikei a igenen, pukun ina kapo mamakasan aongos ta tapak, na kala arai ani Iesu na kamela matung turung e matana, na kala sokotuk ia ta, “Volava, man kupo naung, kupo angkoai si vil adaus anig.” ");
INSERT INTO lcm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Na kala sulai ani kungana na kala teng e pukun ina na kala antok ta, “Io, napo naung. Pukun im kala serei daus vang!” Na akorong palau na pukun tapak ang kala kovek pelek ia. ");
INSERT INTO lcm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Na kala antok amadot ia ta, “Ku ago ta mengen amalangas an ani mangsikei ta bil ke, sikei kuan akalit ta pukun im si katakai i sula ani ka suluk a alilis ang i kam vilvil atanginang val kana saupai a Moses, ani ri vap asi kari nas ta kulapo daus.” ");
INSERT INTO lcm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sikei lak, akuskus ina kala papanai. Na petau miang luai kimepo serei asi me kolongong ania na kime luk vilvil ato pelek kari keve malepen. ");
INSERT INTO lcm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sikei katapo taging lik ane si ring varasai palau na kanpo sokotuk. ");
INSERT INTO lcm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mangsikei a taun katapo akalkalit na mang keve Parisaio ve vap malangas ani saupai kipo sinong. Kitala pasal le si keve rina aongos i Galilaia na le Iudaia na Ierusalem kapa na kita melapo sinong kuvul lava e iang. Na kitmat i Volava katapo ago ania si abis vilvil ato. ");
INSERT INTO lcm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na mang rukun vap kila serei ta asasalakan i mang igenen soles. Na kitapo buk asalak alak ania ane nei lu asi an amatung ania si Iesu. ");
INSERT INTO lcm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na kilapo gulegule pangau asi palak tatana nei liuan i petau lava ang, sikei parik kapa angkoai. Asukang na ki palak tatana ane kuli lu, ki ding a kuli lu, na kila atikok asiang ia kuli kana pata ane nei liuan i petau ang e mete Iesu akorong. ");
INSERT INTO lcm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Si taun kala arai kinle ani kari lomlomon na kala antok ta, “Iuang, kam keve lau rikek, nala lomon suai ania.” ");
INSERT INTO lcm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Na keve Parisaio ve vap malangas ani saupai kilapo lomlomonai na kilapo angsusuiai musik angpokpokai aniria ta, “Au, si kana kapo mengen i nau varas? Si kapo kun koi asi lomon suai ani lau rikek? God papalik nang!” ");
INSERT INTO lcm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iesu kalapo malangas lenginang kari lomlomonai musik na kala sui iria ta, “Marai sa mipo angsusuiai e lomlomonai imi? ");
INSERT INTO lcm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Si i ngono bil ke kapo remrem si antok ania? Nala lomon suai ani kam lau rikek, vo si antok ta ku tapasuk na ku pasal? ");
INSERT INTO lcm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sikei, asi kami nas vang ta igenen i pukun kapo atogon kitmat kuli rina si kana lomon suai ani rikek,” le na kala antok na igenen soles ang ta, “Napo antok ua, tadut na ku sunguk le kam pata na ku pasal ane rina.” ");
INSERT INTO lcm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na akorong palau kala tapasuk e mataria aongos, na kala sunguk le kana pata na kala pasal i po alatun ani God ane rina. ");
INSERT INTO lcm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Vap aongos kilapo taping na kila alatun a God. Ki man velai leng ani bil ke na kila antok ta, “U, taratala arai vang ani bil ke na tarala taping luai.” ");
INSERT INTO lcm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Au, e mung ina kala soung na kanla arai ani mangsikei a igenen kana asan ta Levi, kapo katakai i luk takis na katapo sinong nei kana lu ipo luk takis. Na kala antok ia ta, “Me using iau.” ");
INSERT INTO lcm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Na kala atolongon kana keve bil aongos na kala tadut na kala using ia. ");
INSERT INTO lcm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Au, Levi kanla teng a mangsikei a matan angan lava ania e nei kana lu na petau miang i ri vap luk takis na mang vap palau pulakai kitapo angan ve ria. ");
INSERT INTO lcm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Na ri Parisaio ve kari vap malangas ani saupai kila gai si kana keve nat i akalit ta, “Marai sa mipo matan angan kuvul ve vap luk takis ke na vap bil arikek suke?” ");
INSERT INTO lcm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Na Iesu kala polpol iria ta, “Vap po to aro parik kipa inongos taun a katakai i vilvil ato, sikei ri malepen vang. ");
INSERT INTO lcm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Parik natapa serei asi me songo ani vap korong, sikei ri katakai i bil arikek, ani ki lomon pokai.” ");
INSERT INTO lcm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na kila antok ia, “Keve nat i akalit si Ioanes kipo uli alal na sokotuk na asukang kapa keve nat i akalit si ri Parisaio, sikei kakam kipo uli angan na inum.” ");
INSERT INTO lcm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Na Iesu kala antok iria, “Sa, mipo buk atakun ani keve tungana i vo tauk i pagamau ani ki mal si taun kipo ago kuvul ve nia? ");
INSERT INTO lcm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ka atogon a taun iles lak na kila luk suai ani vo tauk i pagamau pelek iria, na taun ang vanang ki mal lak.” ");
INSERT INTO lcm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Na kala mengen iria ta kankanuai i mengen kapa. “Kapo tav angkoai si tara ding suai le ta vuk vakup le si maus tanginang asi suisui alak ania si maus kavang, vei tarala vil ding a maus tanginang ang. Na mang anu kapa, vuk vakup tanginang ang parik kalapa angkokoai ve maus kavang ang. ");
INSERT INTO lcm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na kapo tav angkoai kapa si tara lingai ani vaen tanginang dong a pauk kavang, vei pauk ang ka tading. Sukana na vaen kala vekai asip na pauk ang kapa kala kun rikek. ");
INSERT INTO lcm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Sikei, vaen tanginang kapo ro si pauk tanginang. ");
INSERT INTO lcm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na kapo tav angkoai si man kitala uli inum si vaen kavang, kipo buk a vaen tanginang. Using kipo antok ta, ‘Anu kavang kapo roron.’” ");
INSERT INTO lcm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Si mangsikei a taun i atailai katapo pasal aliu nei keve matang kon, na kana keve nat i akalit kilapo rok a mang matan kon na kila mul ia ta kungaria na kilapo angan a katui ina. ");
INSERT INTO lcm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Na mang keve Parisaio kila sui ta, “Au, marai sa kana mipo abis a lau ke kapo tav angkoai si abis ania si taun i atailai?” ");
INSERT INTO lcm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Na Iesu kala polpol iria ta, “Au si parik lak kana mitapa tataot a akuskus i David na sa kata abis ia si taun katapo buk angan, ninia ve keve tungana? ");
INSERT INTO lcm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kata palak nei lu si God na kala luk a pok i asinong akipai ang voiang ri katakai i sula papalik kipo atogon a roron asi angan ania, na kala angan ia, na kala alis kapa si keve tungana.” ");
INSERT INTO lcm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Na kala mengen iria, “Igenen i pukun kapo Volava i taun i atailai.” ");
INSERT INTO lcm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Au, si mang taun i atailai kapa kala riuk lak nei lu i kivung na kanlapo vil akalit. Katapo atogon a mangsikei a igenen e iang palso i kungana katapo mat. ");
INSERT INTO lcm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Na ri vap malangas ani saupai ve ri Parisaio kilapo teremai ania ta man kala vil ato ia, ki aoles ia using kapo taun i atailai. ");
INSERT INTO lcm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sikei kata lapo malangas kari lomlomonai, na kala antok a igenen kunga mat ang ta, “Tadut atung ane ke.” Na kala tadut na kalapo tung e iang. ");
INSERT INTO lcm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Na Iesu kala antok iria asukang ke, “Napo buk sui animi. Kapo angkoai si taun i atailai si pakangai vo si bil arikek? Si vil ato vo si vil punuk?” ");
INSERT INTO lcm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na kala ararai aulitai aongos aniria, na kala antok ia, “Ku koros a kungam.” Kala vil ia asukang na kungana kala pukunan aro pok. ");
INSERT INTO lcm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sikei kilapo marala alava luai na kilapo tutapong angmemengenai ta ki saka bil an ani Iesu. ");
INSERT INTO lcm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Si pangau ang Iesu kala kiklak ane si palpal mulang asi an sokotuk. Na kanla ago na vong aongos ang i sokotuk ane si God. ");
INSERT INTO lcm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Au, kala tenei vauk na kala songo kana mamain ta vap ipo usiusing ania na kala irang suai ani 12 iria, na kala posong iria ta aposel. ");
INSERT INTO lcm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kana vang ria. Simon, nang kata atuk kapa ia ta Petero, na tasina ta Andereas na Iakovo na Ioanes na Pilipo na Bartolomaio ");
INSERT INTO lcm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","na Mataio na Tomas na Iakovo si Alpaio, na Simon nang kipo kin ia ta Selote, ");
INSERT INTO lcm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","na Iudas si Iakovo na Iudas Iskariot, vopo alis suai ania asi kana mat. ");
INSERT INTO lcm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Na kila auai asiang kuvul na kame lapo tung si ring korong. Na vap miang ipo usiusing ania kitapo ago kuvul ve petau lava le Iudaia, na le Ierusalem na le ngono palpal ke ngere laman, Turo na Sidon. ");
INSERT INTO lcm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kita mela serei ani kime longong ia na ki luk vilvil ato si kari keve malepen. Na kata vilvil ato na vap sangan ta ingua ");
INSERT INTO lcm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","na vap aongos ang kitapo buk sigil ania using kitmat katapo soung le singina na kapo vil ato iria. ");
INSERT INTO lcm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Au, kala tun kana petau ipo usiusing ania na kala mengen asukang ke, “Uruk kakami mipo vap logo, using kakami na sinsinongan nei vainagoan si God. ");
INSERT INTO lcm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Uruk kakami mipo buk angan kana, using mi masung aro lak. Uruk kakami vap po tangis ang kana, using mi los lak. ");
INSERT INTO lcm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Uruk kakami si man ri vap ki mirik animi, na ki kirik na ki nau varas animi, na ki posong imi ta vap rikek marai usiusing ani igenen i pukun. ");
INSERT INTO lcm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mi uruk si taun ang na mi mikamika ta maramarak, using a seuseupok lava kapo ago kokoai animi e pangkul. Io, using ninia palau a lau ke nang a keve tivuria i vap po mengen arikek ang animi kita kun abis ania si mamain ta katakai i akus anangan. ");
INSERT INTO lcm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Sikei nami ri tauia, ka rikek animi pala using milapo siang lenginang nei kami maramarak. ");
INSERT INTO lcm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nami vap po maspil ang kana, ka rikek animi using mi buk angan lak. Nami vap po los ang kana, ka rikek animi using mi mamakus na mi tangis. ");
INSERT INTO lcm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ka rikek animi, man kana ri vap kipo mengen aro animi. Io, using ninia palau a lau ke nang a keve tivuria i vap po mengen aro ang animi kita kun abis ania si mamain ta katakai i akus kapau. ");
INSERT INTO lcm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sikei napo mengen imi kana mipo longong iau. Mi vinga ro taun a vap po marala ang animi. Mi abis a lau roron singiria, vap po mirik ang animi. ");
INSERT INTO lcm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mi poso aro iria, riria kipo poso arikek imi. Mi sokotuk aniria, riria kipo bil arikek animi. ");
INSERT INTO lcm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Man a sikei ka tavapat a palpal asam, atalipai ania na ka tava na mang palpal ang kapa. Man a sikei ka luk kam vakup, atalipai ania na ka luk kam siot kapa. ");
INSERT INTO lcm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Alis a si kapo aikut ua. Na man a si ka luk palau kam bil, ku ago ta buk pok an ania. ");
INSERT INTO lcm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ninia palau na lau ang mipo buk ani ri vap ki abis ia singimi, mi kun abis ania singiria. ");
INSERT INTO lcm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Au, man mipo vinga ro papalik taun iria kipo vinga ro taun imi, mi saka luk an ani roron? Arai, ri katakai i bil arikek kapa kipo kun vinga ro angpokpokai aniria. ");
INSERT INTO lcm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Na man mi abis a lau roron papalik ane singiria kipo kun roron animi, mi saka luk an ani roron? Ri katakai i bil arikek kipo kun asukang kapa. ");
INSERT INTO lcm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Na man mipo alis tapai ane singiria papalik mipo atu lomlomon ta mi luk pok singiria, mi saka luk an ani roron? Kapo asukang palau kapa si ri katakai i bil arikek ane si mang matan pok iria. Kipo alis tapai asi luk pok ani polpol iria. ");
INSERT INTO lcm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sikei nami vang, mi uli vinga ro taun a vap po marala ang animi, na mi abis a lau roron ane singiria. Alis tapai aniria, na mi ago ta vubuk using ani polpol ina. Man asukang, kami seupok ka tavirimok, na mila inatus si Vo Tavirimok Luai. Using ninia na tamami kapo vinga ro aniria, riria kipo tav poso aro na riria mamain ta katakai i bil arikek. ");
INSERT INTO lcm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mi lomon suai asukang palau val tamami kapo lomon suai. ");
INSERT INTO lcm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mi ago ta kiming an ani tungami, vei nganing kila kun kiming animi. Mi ago ta mengen arikek ani mang matan, vei ki mengen arikek animi. Mi lomon suai ani lau rikek si mang matan, na ki kun lomon suai ani kami lau rikek. ");
INSERT INTO lcm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mi vap uli alilis, na ki kun alis animi. Tutuman luai, mi luk a palpal duk. Ka duk na ka kamsarak. Ki abis ia singimi angkokoai palau val lau ang mita abis ia.” ");
INSERT INTO lcm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Na Iesu kala mengen kapa iria ta kankanuai i mengen ke, “Igenen mata ba parik kapa angkoai asi ainoai ani mang ba. Man asukang, rilong aongos kilong anla siang nei lulung. ");
INSERT INTO lcm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ri nat i akalit parik kipa lakat ani kari katakai i akalit. Sikei, man kila akamusai ani kari akalkalit, kila asukang val kari katakai i akalit. ");
INSERT INTO lcm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Marai sa kupo tun a tep lik ang e matana i tungam, na numai akorong kupo tav nasai ani vukei lava ang e matam? ");
INSERT INTO lcm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kapo saka ro an man ku antok a tasim ta, ‘Apua, tasig, me name luk suai tapai ani tep ang e matam’ man numai akorong lak parik kupa tun kinle na vukei lava ang e matam? Numai a katakai i kapau. Aino ina, ku luk suai ani vukei lava ang e matam akorong, le na kula angkokoai asi arai atapalas si luk suai ani tep ang e matana i tungam. ");
INSERT INTO lcm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Io, ei roron parik kapa angkoai asi uai asereiai ani uai rikek. Na ei rikek parik kapa angkoai asi uai asereiai ani uai roron. ");
INSERT INTO lcm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tarapo kinle na keve ei aongos si uai iria. Parik tarapa kopos suke le si kakaul, na parik tarapa kopos vaen le si ei komkomongot. ");
INSERT INTO lcm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Igenen ro ka asoung asereiai ani roron le si tauia i keve bil roron ang nei vingana, na igenen rikek ka asereiai ani rikek le si tauia i kana keve bil rikek. Using a nguruna kapo asoung a bil ang vingana kapo duk tatana. ");
INSERT INTO lcm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Marai sa mipo songo iau ta, ‘Volava, Volava’ na lak parik mipa longong kag mengen? ");
INSERT INTO lcm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Man a sikei kapo serei singig, na kapo longong kag mengen, na kapo abis using ia, arai, naka akalit imi ta nia kapo saka pok an. ");
INSERT INTO lcm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kapo pok val igenen abis lu na kata tep alulungai luai na ka atung kana kelkelai kuli iat. Taun a molong kata serei na kamela tavap a lu ang, parik katapa angkoai asi aruk ania using kata kelai aro luai ania. ");
INSERT INTO lcm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sikei man a sikei ka longong palau kag mengen sikei parik kapa abis using ia, kapo pok val igenen vopo abis ang ani kana lu kuli vunep palau na kapo kovek i kelkelai roron. Na taun a molong kata tavap a lu ang, kala uak sumasuma palau na kala tagalang aongos.” ");
INSERT INTO lcm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Au, kala akamusai tapai ani keve mengen aongos ang si kokolongong si ri vap, na kala pasal ane Kaparnaum. ");
INSERT INTO lcm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","E iang katapo atogon a mang ainoinoai i petau ipo visvis, katapo atogon kana mang asosokai katapo uli lomlomonai alava ania na asosokai ang katapo malepen alava luai. Kalapo angasungai ani mat. ");
INSERT INTO lcm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Si taun ang ainoinoai ang kala longong a inasai i Iesu, na kala asok a mang matan tulava i ri Iudaia, asi an sokotuk ania ani kame vil ato kana asosokai. ");
INSERT INTO lcm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Asukang na kimela serei si Iesu na kimela sokotuk aroron ia ta, “Iuang, kapo aunai i ro singim ani ku pakangai ani igenen ke, ");
INSERT INTO lcm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","using kapo uli pakangai alava anira ri Iudaia. Nia vanang kata abis kamem lu i kivung.” ");
INSERT INTO lcm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Au, Iesu kala auai ve ria na kanlapo angasungai ani lu ang na igenen ang kala asok a mang matan tungana ta mengen asukang ke, “Volava, ku ago ta me pakasang luai an ane ke, using napo tav ro angkoai asi songo alak anim ane nei kag lu. ");
INSERT INTO lcm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tukulai ina vanang nata lomon ia ta parik napa ro angkoai asi kag an serei singim akorong. Sikei, ku posong palau na kag asosokai ka to aro pok. ");
INSERT INTO lcm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Using nau kana napo igenen ipo ago neite saupai, na kag petau i visvis kipo kun ago neite kag saupai. Asukang ta man naka asok a mang anu ta ka pasal, na kala pasal. Na man naka asok a mang anu ta ka me, na kamela pakasang. Na man naka asok kag mang asosokai ta ka abis a mang nem, na kala abis ia.” ");
INSERT INTO lcm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Si vuk taun ang a Iesu kapo longong a mengen ke, kala taping ania. Kala taval talang a petau lava po auai ang ve nia na kala antok iria, “Napo antok imi, parik lak napa arai ani lomlomon kit asukang ke nei liuan i ri Israel.” ");
INSERT INTO lcm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Na vap i asok ang kila papok ane nei lu na kianla sabonai ani asosokai ang si lapo to aro. ");
INSERT INTO lcm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","E mung lik ina kala pasal taun a mang rina kana asan ta Nain kuvul ve kana keve nat i akalit na mang petau duk. ");
INSERT INTO lcm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Taun kianla serei mete takaman i rina ang, na mang vap kilapo soung velai ani matmat. Nat mat ke kapo ring sikei palau a nat na rinana kapo mainang. Vap miang i rina ang kitapo auai ve nia. ");
INSERT INTO lcm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Si taun ang Volava kala arai ani mainang ang kala ngorem ia, na kala antok ia ta, “Ago ta tangis an.” ");
INSERT INTO lcm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na kala pasal aliu na kanla sigil a pata na vap po asalak ang ania kila tung. Na kala antok ta, “Natung, ku tadut.” ");
INSERT INTO lcm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na nat mat ang kala sinong atung, na kalapo tutapongai mengen. Na kala alis ia si rinana. ");
INSERT INTO lcm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Vap aongos ang kilapo leng alava na kila alatun a God ta mengen asukang ke, “Mangsikei a katakai i akus lava kana kame lapo ago ve tara. God kalapo serei vang kana si kana matan vap.” ");
INSERT INTO lcm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Na akuskus i sa kata vil ia kala pasal apapanai aongos nei palpal Iudaia na aulit aongos e iang. ");
INSERT INTO lcm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Keve nat i akalit si Ioanes kianla atatai ia ta keve nem ke. ");
INSERT INTO lcm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Na Ioanes kala songo na pongua iria, na kala asok irilong ani kilong an nanas si Volava ta, “Numai tutuman vang kana na igenen vo me serei ke, vei nganing namemla atu lomlomon ta mangsikei petekai?” ");
INSERT INTO lcm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Na ngono nat ang kilong anla serei si Iesu na kilongla antok ia ta, “Ioanes katakai i asing tauia ke kata asok asi me sui anim ta numai tutuman vang kana na igenen vo me serei ke, vei nganing namemla atu lomlomon ta mangsikei petekai?” ");
INSERT INTO lcm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Si taun ang akorong Iesu katapo vil ato na vap miang pelek kari keve malepen anglok na ka lu suai ani ri ingua na ka vil ato na keve vap mata ba. ");
INSERT INTO lcm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Asukang na kala antok irilong, “Milong papok na milong anla mengen amalangas a Ioanes ta sa milong tala arai ania na milong tala longong ia. Ri mata ba, kilapo ararai pok. Ri soles, kilapo pasal korong. Ri tapak, kilapo rangrangis aongos, na ri talinga bot, kilapo longong korong. Riria kitala mat, kilapo tapasuk pok. Ri vap mailik, kilapo longong a akus ro. ");
INSERT INTO lcm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kapo tauia na igenen ang nang parik kapa savang marai ig.” ");
INSERT INTO lcm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Au, ngono nat ang si Ioanes kilongla pasal suai na Iesu kalapo atatai ani petau lava ang ta Ioanes. “Mita pasal ane ring varasai palau si kami an arai ani sa? Ani tavuang kapo lulu angpok si malu? ");
INSERT INTO lcm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Au, man parik, na mita pasal asi kami arai ani sa? Ani igenen maus ta maus ro luai? Parik. Vap ang kipo maus ta maus roron luai na kipo uli matan angan aro luai, kipo ago nei keve lu lava si ri tulava. ");
INSERT INTO lcm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Au, man parik, na mita pasal asi kami an arai ani sa? Ani katakai i akus? Io, ninia vanang! Na kapo lakat ani katakai i kus amalangas. ");
INSERT INTO lcm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kana vang na igenen ke kita salik tatana asukang ke, Arai, naka asok kag asosokai aino anim, voiang kan itoiton aino na selen anim. ");
INSERT INTO lcm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Napo antok imi ta nei liuan i ri vap aongos i kuli rina kapo kovek ta mang anu katala tung alakat ani Ioanes. Sikei lak, si kapo liklik luai nei vainagoan si God, kapo lakat ania.” ");
INSERT INTO lcm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ri vap aongos ve ri katakai i luk takis kapa kilapo longong kana atatai a Iesu na kipo soksoko akorong ani kana selen a God kapo korong, using riria kitala luk asing tauia si Ioanes. ");
INSERT INTO lcm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sikei ri Parisaio ve ri vap malangas ani saupai, kipo misag ani kana vubuk a God aniria using parik kita lapa luk asing tauia singina. ");
INSERT INTO lcm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Au, naka altongai ani matan polpolokan i taun ke ta sa? Kipo pok val sa? ");
INSERT INTO lcm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kipo asukang val inatus lik nei ring i po asesel na kipo sinong i songosongo angpokpokai asukang ke, ‘Namemtala kuikui animi na parik milapa mika. Namemtala akurkurai animi na parik milapa tangis.’ ");
INSERT INTO lcm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Arai, Ioanes katakai i asing tauia kata serei na parik kapa angan na inum, na mila antok ta kapo sangan ta ingua. ");
INSERT INTO lcm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Au na kana na igenen i pukun kamela serei na kalapo angan na inum, na mila antok, ‘Arai ta igenen ramit suke. Arai ta igenen buk inum alava suke. Arai ta igenen suke kapo angtunganan ve ri katakai i luk takis na ri katakai i bil arikek!’ ");
INSERT INTO lcm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Nang a laulauan si ri vap masam kapo akalit ta masam ang kapo tutuman.” ");
INSERT INTO lcm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Na mangsikei i ri Parisaio kala asok tapai ania asi kana me matan angan ve nia. Na kamela palak nei lu na kilapo sinong si angan. ");
INSERT INTO lcm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Au, mangsikei a aina kala palak, kapo aina i rina ang na kapo mangsikei a katakai i bil arikek. Kata longong ta kalapo ago si matan angan nei lu si Parisaio ang, na kala luk le kana ese sain ro, ");
INSERT INTO lcm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","na kamela tung e mung ina, ngere ngono kakina, na kapo tangis, kalapo raus a ngono kakina ta lum mata i matana, na kapo ruduk ia ta ung i patuna, na kalapo lulus a ngono kakina na kala tiuai ani kana ese sain ro e ngono kakina. ");
INSERT INTO lcm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Na Parisaio vo asok tapai ang ania kala arai na kalapo lomlomonai musik, “Man kana na igenen ke kapo katakai i kus amalangas, oro kala kinle na vo po sigil ke ania, ta kapo mangsikei a aina bil arikek.” ");
INSERT INTO lcm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Na Iesu kala antok ia, “Simon, napo buk mengen anim ta mangsikei a mengen.” Na kala antok, “Katakai i akalit, kala ro. Ku mengen.” ");
INSERT INTO lcm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","“Mang igenen katapo togon a mang pongua na igenen kilongtapo togon kope singina. Mang anu ta 500 na kang, na mang anu ta 50. ");
INSERT INTO lcm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Sikei kilong tapo kovek i kapkap asi polpol ani karilong kope. Asukang na kala lomon suai anirilong aongos. Au, si irilong katapo uruk alava ania?” ");
INSERT INTO lcm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Na Simon kala antok, “Napo lomon ia ta ninia vo atogon kope lava.” Na kala antok ia ta, “Io, kutala kinle korong.” ");
INSERT INTO lcm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na kala taval talang a aina ang na kala mengen a Simon asukang ke, “Ku arai ani aina ke kana! Si taun nata palak nei lu, parik kuta lapa alis laman asi kag raus ani ngono kakig, sikei ike katala raus a ngono kakig ta lum mata i matana, na kala ruduk ia ta ung i patuna. ");
INSERT INTO lcm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Parik kuta lapa lulus iau. Sikei ninia, le si vuk taun nata palak, parik lak kapa aulei lak ta lulus ani ngono kakig. ");
INSERT INTO lcm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Parik kuta lapa tiu a patug ta rul i elaio, sikei ninia katala tiuai ani ese sain ro e ngono kakig. ");
INSERT INTO lcm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kana vang napo antok ua ta kana keve lau rikek duk, nala lomon suai ania. Io, ninia vanang kapo uruk alava anig. Sikei igenen vo togon men lik palau asi lomon suai, kana uruk anig ka liklik palau.” ");
INSERT INTO lcm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Na kala antok ia ta, “Kam keve lau rikek, nala lomon suai ania.” ");
INSERT INTO lcm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Na vap po angan ang ve nia kilapo kinungai musik lik asukang ke, “Au, si kana kame lapo lomon suai ani mamain ta lau rikek?” ");
INSERT INTO lcm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Na kala antok a aina ang ta, “Kula sapang si kam lomlomon. Ku pasal ta marip.” ");
INSERT INTO lcm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","E mung palau ina kalapo pasal angpok nei keve rina lava na keve rina lik na kapo apasa ta akus ro i kana vainagoan a God. Kana 12 na nat kitapo auai kuvul ve nia. ");
INSERT INTO lcm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Asukang kapa mang matan aina voiang katala asok suai ani ri ingua singiria, na katala ato iria si mang keve malepen. Mangsikei ta Maria, kipo kin ia ta Magdalene voiang a limalengua na ingua kita soung pelek ia. ");
INSERT INTO lcm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Na Ioana, kisngana i Kusas nang kapo mangsikei a asosokai si Erodes, na Susana, na mang matan miang kapa, kitapo papakangai aniria si palpal i pukun le si kari togtogon akorong. ");
INSERT INTO lcm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Au, mangsikei a taun petau tavirimok luai kimela seserei akuvulai le si mang keve rina miang. Na Iesu kala akalit iria si kankanuai i mengen asukang ke, ");
INSERT INTO lcm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Mangsikei a katakai i sukal kata sapungai ani kana keve katui i pok e matang, na mang matan katui kanpo uak e selen na kilapo saksakai kuluna, na ri mani kimela angan ia. ");
INSERT INTO lcm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Na mang matan katui kianlapo uak si ring iatan, na kila polok alak, na kila mak using kapo kovek i laman. ");
INSERT INTO lcm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Na mang matan katui kipo uak nei ring kakaulan, na kanla polok alak ve nia na kala palun runguk ia. ");
INSERT INTO lcm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Na mang matan katui kipo uak nei roe roron. Kipo polok alava na kipo uai soliu ta 100 alak ani keve katui i sukal ang.” Taun kan posong akamusai ani mengen ke, na kala songosongo, “Man a si kapo atogon talinga, kapo ro ka longong!” ");
INSERT INTO lcm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Na kana keve nat i akalit kilapo susuiai ania ta malmalasupai i kankanuai i mengen ke. ");
INSERT INTO lcm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na kala antok iria, “Malangas i keve bil mumun i vainagoan si God, kakami asi atogon, sikei si mang matan napo mengen iria nei kankanuai i mengen, asi kari gulegule na ki tav sabonai, na asi kari kokolongong na ki tav nas. ");
INSERT INTO lcm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Kana vang a supsupai i kankanuai i mengen. Katui nang, ninia na mengen si God. ");
INSERT INTO lcm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na katui i lapo matung ang nei selen, nang riria kipo vap longong, sikei a vo petau kamela luk suai ani mengen ang e vingaria, ani ki ago ta lomlomon an vei ki teng a to. ");
INSERT INTO lcm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Na katui i la uak ang si ring iatan, nang riria kita luk a mengen na kila uruk singina, sikei parik kita lapa asia mis. Kipo lomlomon si vuk taun kudik lik palau, sikei man a atoktokngai kala serei singiria, kilapo atolongon kari lomlomon. ");
INSERT INTO lcm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Na katui i la uak ang si ring kakaulan, nang riria kitala longong a mengen sikei parik kipa matukal using kipo rakus si vubuk using ani tauia lava na uruk i kuli rina ke. ");
INSERT INTO lcm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Au na katui i la uak ang nei roe roron, nang riria vingaria kapo ro na kipo uli lau korong. Kipo longong a mengen na kipo uli lomon akit ania tung si kianlapo uai arokot. ");
INSERT INTO lcm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Parik tarapa asusuk a lam asi kara amunai ania nei avubus vo neite pata. Tarapo uli atung ania si kana ring akorong, ani man a ri vap kipo palak ki arai korong ani mang. ");
INSERT INTO lcm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Using kapo kovek ta bil katapo ago mumum, na nganlak parik kapa serei e ring malangas. Vo ta bil katapo ago nei apupung, na nganlak parik kipa ulak ia. ");
INSERT INTO lcm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Asukang mi lomlomonai aro ani mi saka luk an ani mengen si God. Using man a si kapo atogon, ki ngaupap ia, na man a si kapo atogon men lik, io, men lik ang kapo sekpat ta kapo kakana, ki luk suai vang ania.” ");
INSERT INTO lcm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Si taun ang rinana ve keve tasina kimela serei asi kari me arai ania. Sikei parik kipa angkoai si palak taun ania using a petau lava ang. ");
INSERT INTO lcm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Na mang sikei kala antok ia, “Arai, rinam ve keve tasim kipo tung e komo. Kipo buk arai anim.” ");
INSERT INTO lcm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Na kala antok iria asukang ke, “Rina na keve tasig, nang riria kipo longong a mengen si God na kipo abis usiusingai ania.” ");
INSERT INTO lcm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mang sikei a taun kala kokos kuli vul kuvul ve kana keve nat i akalit na kala antok iria, “Tara kokos aputuk ane mang palpal i laman ke.” Na kila pasal. ");
INSERT INTO lcm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Si vuk taun kipo sang nei laman na ninia kalapo rot. Na mal titis kala serei, na vul kalapo lak ia na laman, na kalapo rikek luai aniria. ");
INSERT INTO lcm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na kianla pangun ia na kila antok, “Volava, Volava, oring lik tara puka!” Na kala tapangun na kala atakun a malu ve to marala. Na malu kala pongo na luai lava kala pitik. ");
INSERT INTO lcm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na kala sui iria, “Nei kami lomlomon e voi?” Kitapo sugul alava velai ani leng na kilapo sui angpokpokai aniria ta, “Saka igenen an kana? Kapo atakun a malu ve to na kipo kun longong ania.” ");
INSERT INTO lcm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Na kianla serei e palpal Geraseno, ararai aputuk le Galilaia. ");
INSERT INTO lcm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Si vuk taun ang kapo palak ane ngerelo, mang sikei a igenen i rina ang kamela ruduai ia, na kapo sangan ta ri ingua. Le kabang le parik kata lapa anguan kavat vakup, na parik katapa ago nei lu, sikei katapo uli ago e nei gom. ");
INSERT INTO lcm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Au, si vuk taun ang kamela arai ani Iesu, kala kup alava na kala suai ania e no ina, na kala songosongo alava, “Iesu, nat i God Lakat Luai, kupo serei asi kam me vil sa anig? Napo sokotuk ua ta ku ago ta vil akui an anig!” ");
INSERT INTO lcm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Using katala kirikai ani ingua ang asi kana soung pelek ani igenen ang. Using taun miang kata lapo sang tatana, na kitapo uli got akit ania e ngono kakina na e ngono kungana ta angus kitmat luai, na ki ararai bat ania, sikei katapo uli tak tok ani angus ang na ingua ang kanpo sang tatana ane ring varasai palau. ");
INSERT INTO lcm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Au, Iesu kala sui ia, “Kam asan ta si?” Na kala antok ta, “Petau,” using ri ingua duk kitapo ago singina, ");
INSERT INTO lcm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","na kipo sokotuk ia asi kana ago ta asok suai an aniria ane nei mata lulungai asiang. ");
INSERT INTO lcm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mang takaman vongo lava kitapo susuang angasungai i ring ang ngere put, au na kila sokotuk ia ta ka atalipai aniria asi kari an palak singiria. Na kala ainak aniria. ");
INSERT INTO lcm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Au, keve ingua ang kila soung pelek a igenen ang na kianla aol a keve vongo ang. Na takaman vongo ang kila doso asiang taun a ring karkadapan na kianla lus mat. ");
INSERT INTO lcm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na vap po aiveven vongo ang kila arai ani bil ang na kila sip na kianla akus nei rina lava ang na nei keve rina lik kapa. ");
INSERT INTO lcm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na ri vap kila pasal asi kari an arai ani sa katala serei. Na kimela serei si Iesu na kila arai ani igenen ang ri ingua kitala soung pelek ia kapo sinong e ngere ngono kakina i Iesu na kalapo kavat na kalapo vangang tapalas aro pok, na kilapo leng. ");
INSERT INTO lcm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Na vap arai ang kila akus iria ta igenen sangan ta ingua kame lapo to aro pok. ");
INSERT INTO lcm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Na ri vap aongos i palpal Geraseno kilapo sokotuk ia asi kana pasal suai ani kari ring, using kitala leng aongos. Asukang na kala kokos asi kana papok. ");
INSERT INTO lcm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Igenen ang ri ingua kita papelek ia kala sokotuk ia asi kana auai ve nia, sikei kala asok pok ia velai ani atatai ke, ");
INSERT INTO lcm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ku papok ane rina na kuanla akuskus ta poisan a roron God katala abis ia singim.” Au kala pasal na kanlapo akuskus nei rina aongos ta poisan a roron a Iesu katala abis ia singina. ");
INSERT INTO lcm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Au, Iesu kala serei pok e mang palpal, na petau lava kila uruk suak ania using kitapo atu lomlomon ta ka serei. ");
INSERT INTO lcm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Na mang sikei a igenen, kana asan ta Iairo, na katapo mang ainoinoai i nei lu i kivung, kamela serei si Iesu na kala matung turung e ngono kakina na kala sokotuk ia asi kana an serei si kana lu, ");
INSERT INTO lcm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","using kana ring sikei palau a kavulik, katapo asukang ta 12 na matas kana to, na kalapo ore asi kana mat. Vuk taun ang kalapo pasal aliu na ri vap kilapo rumrumpulit using aliu ia. ");
INSERT INTO lcm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na mangsikei a aina katapo uli malepen ta tongmasik asukang ta 12 na matas aongos, na katapo kovek ta sikei ka angkoai asi kana vil ato ania, ");
INSERT INTO lcm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","kala gingging kolotai alak ane singina na kanla sigil a su i kana vakup, na akorong palau tongmasik ang kala kamus. ");
INSERT INTO lcm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Na Iesu kala sui, “Si kana kata sigil iau?” Ria aongos kipo angtupatupang, na Petero kala antok, “Volava, petau ke kana kipo angrumrumpulit na kipo ngi ua.” ");
INSERT INTO lcm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Sikei Iesu kala antok, “Mangsikei katala sigil iau, using napo nasai ania ta kitmat katala soung le singig.” ");
INSERT INTO lcm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Au, aina ke kala nas ta parik kapa angkoai si mumun, na kalapo tek lengai palau na kamela matung turung e matana, na kala atatai e mataria i vap aongos ang, ta marai sa kata sigil ia, na sa tukulai ina kana kalapo to aro pok. ");
INSERT INTO lcm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Na kala antok ia ta, “Kag kavulik, kam lomlomon kata vil ato pok ua. Pasal ta marip.” ");
INSERT INTO lcm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Vuk taun ang kapo mengen lak, na mang igenen i nei lu si ainoinoai ang kamela serei na kala mengen ta, “Kam kavulik kala mat. Ago ta anguan atelan an ani katakai i akalit.” ");
INSERT INTO lcm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Sikei Iesu katapo longong a mengen ang, na kala antok ia ta, “Ku ago to leng an, sikei ku lomlomon, na ka to.” ");
INSERT INTO lcm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Au kanla serei nei lu na kala tubat iria ani ka ago ta sikei ka palak ve nia, sikei ri Petero ve Ioanes na Iakovo, na tamana ve rinana i kavulik ang. ");
INSERT INTO lcm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Na ri vap aongos kipo radaupa na makus taun ia, sikei kala antok, “Mi kamus ta radaupa, using parik kapa mat, kapo rot.” ");
INSERT INTO lcm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Na kila los ia using kipo nas ta katala mat. ");
INSERT INTO lcm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Na kala teng a kungana na kala songo, “Kag kavulik, ku tadut!” ");
INSERT INTO lcm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Na malanganto ina kala serei pok, na akorong palau kala tadut atung. Na kala asok asi kari ali pok ania. ");
INSERT INTO lcm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tamana ve rinana kilongla taping alava sikei kala atakun akit irilong ta kilong ago ta mengen an ani mangsikei ta sa kata serei. ");
INSERT INTO lcm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Na kala songo akuvul na 12 na nat ang, na kala alis iria ta kitmat na ro asi kari kirikai suai ani ri ingua aongos, na ki an vil ato ri malepen. ");
INSERT INTO lcm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na kala asoung iria asi kari an akuskus ta kana vainagoan a God na asi kari an vil ato ani ri malepen. ");
INSERT INTO lcm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na kala antok iria, “Si kami paspasal mi ago ta teng an ta mang sikei a bil. Kipa ka ago, tepe ka ago, pok ka ago, kapkap ka ago, na mi ago ta atogon an ta pongua na siot. ");
INSERT INTO lcm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Man mi ago nei mangsikei a lu, mi ago akorong e iang tung si taun ang mi papelek pok a rina ang singina. ");
INSERT INTO lcm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Na si saka rina an ki tav ainak animi, man mila papelek a rina ang, mi tipngai suai ani kaponpon e kakimi, asi akalit amalangas aniria ta kari lau rikek.” ");
INSERT INTO lcm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Na kila pasal na kianla palak nei keve rina pulakai, na kianla apasa ta akus ro na ki vil ato ri malepen si keve ring aongos. ");
INSERT INTO lcm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tulava Erodes kala longong a keve akuskus ke i sa kalapo serei, na kalapo pisu alava using a mang vap kilapo antok ta Ioanes katala to pok. ");
INSERT INTO lcm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mang matan kipo antok ta Elias kapo tutu aserei, na mang matan kipo antok ta mang katakai i kus amalangas i taun anangan katala to pok. ");
INSERT INTO lcm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Na Erodes kala antok ta, “Ioanes nau natala lam rongok ia. Au na mang si pok kana, nalapo anguan longong ani akuskus ina?” Na kalapo buk an arai ania. ");
INSERT INTO lcm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Au, keve aposel ang kila serei pok na kimela atatai amalangas ia ta keve abis aongos kitanla abis ia. Na kala songo iria ani ki auai kuvul papalik si mangsikei a rina kana asan ta Betsaida. ");
INSERT INTO lcm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Sikei petau duk kila nas na kila pasal using ia. Na kala uruk suak aniria na kala akuskus iria ta vainagoan si God, na kala vil ato ri malepen. ");
INSERT INTO lcm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","E mung si lapo ngelik, 12 na nat ang kimela serei singina na kila antok ia asukang ke, “Ku asok suai ani petau ke na ki pasal aliu ane si keve rina suke vo mang keve rina lik pulakai kapa, asi kari an gule pok na ring asi rot, using kana tarapo ago nei ring varasai palau.” ");
INSERT INTO lcm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sikei kala antok iria ta, “Nami akorong mi li pok iria.” Na kila antok ia ta, “Kana namempo togon a palpalima na saui lik palau ve pongua na ien. Kupo lomon ia ta namem an samui pok ani petau aongos ke?” ");
INSERT INTO lcm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Using katapo petau tavirimok luai asukang ta 5,000 na tauan aongos. Au, Iesu kala antok iria ta, “Mi asok iria ani ki sinong si kari keve kuvkuvulan i 50 na igenen.” ");
INSERT INTO lcm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Na kila abis ia asukang na ri vap aongos kila sinong usausa aro. ");
INSERT INTO lcm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Au, kala luk a palpalima na saui ang na pongua na ien, na kala tarak ane metekuku, na kala posong aro ia, le na kala tevetevek ia dong a keve nat ang asi kari lilis aliu ani ri vap tatana. ");
INSERT INTO lcm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Na riria aongos kila angan na kila masung aro. Na kila lukluk akuvul a keve inongos i pok ang na kila asiang aduk a 12 na tepe tatana. ");
INSERT INTO lcm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Au, Iesu kanlapo ago musik lik i sokotuk na keve nat ang kipo auai ve nia. Na kala sui iria ta, “Ri vap kipo kin iau ta nau a si?” ");
INSERT INTO lcm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na kila ngenget ta, “Ioanes katakai i asing tauia. Sikei mang matan kipo kin ta Elias, na mang matan ta mangsikei iria mamain ta katakai i kus amalangas i taun anangan kala to pok.” ");
INSERT INTO lcm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Na kala sui iria ta, “Au, na nami akorong, mipo kin iau ta nau a si?” Na Petero kala ngenget ta, “Igenen i akanangai ke ta God.” ");
INSERT INTO lcm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Au na kala papat akit iria asi kari ago ta antok ani mangsikei ta bil ke. ");
INSERT INTO lcm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Na kala antok ta, “Igenen i pukun ka sunguk a keve vilvil akui miang. Ri vap lava na keve ainoinoai si ri katakai i sula na keve vap malangas ani saupai ki misag ania na ki raung ia na si lapotol i taun e mung ina ka to pok.” ");
INSERT INTO lcm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Na kapo mengen kapa ri vap aongos ta, “Man a mangsikei kapo buk usiusing anig, ka uli auak suai ani lomlomonai ania pok, na ka uli asalak ani kana ngakputuk si keve taun na ka usiusing iau. ");
INSERT INTO lcm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Using ninia kapo buk aiveven aroron ani kana to, ka amun ia. Sikei ninia kapo amun kana to anig, ka teng ia. ");
INSERT INTO lcm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Using man a igenen ka atogon a keve bil aongos kuli rina na ka mat, keve bil ang ki saka pakangai ania? ");
INSERT INTO lcm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Using man a sikei kapo mumurung anig na ani kag mengen, igenen i pukun kapa ka kun mumurung ania si taun man ka serei pok velai ani miminaungan na miminaungan i tamana ve mamain ta angelo daus.” ");
INSERT INTO lcm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Napo mengen atutuman luai animi ta mang matan kana kipo tung e ke, parik kipa mat tung si ki arai ani kana vainagoan a God. ");
INSERT INTO lcm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Au, kala liu tapai a limaletul a taun e mung i keve mengen suke, na kala songo le na Petero na Ioanes na Iakovo na kala pasal ve ritol alak kuli mulang asi kana an sokotuk. ");
INSERT INTO lcm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Si vuk taun ang kapo sokotuk, ararai i nona kala sakol, na kana maus vola mang posok luai. ");
INSERT INTO lcm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Na akorong palau pongua na igenen, ri Moses ve Elias, kilongla tu aserei na kitol melapo angmemengenai ve nia. ");
INSERT INTO lcm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Na miminaungan irilong kapo mang ro luai, na kitol tapo mengen ta kana pasal suai, nang katapo usausa si vil apunuk ania e Ierusalem. ");
INSERT INTO lcm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Au, Petero ve ngono tungana kitol tala rukai, sikei si taun ang kitola mata para aro pok, kitola arai ani kana miminaungan a Iesu, na ngono igenen ang kilongpo tung ve nia. ");
INSERT INTO lcm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Na ngono igenen ang kilong lapo buk angtaliungai ve nia. Na Petero kala antok a Iesu ta, “Volava, Kapo ro anira sime ago e ke. Namemtol atung ta potol a ralai, ta sikei anim, na mang sikei ani Moses, na ta mang anu ani Elias.” Parik kapa nas ta sa kapo mengen tatana. ");
INSERT INTO lcm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Si taun ang kapo mengen lak, na mangsikei a kuku kala serei na kala apung iria, na volo nat ang kitola leng si lapo ago nei kuku ang. ");
INSERT INTO lcm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Na kalinga kala mengen nei kuku, “Kana kag nat i kag la akanangai, mi longong ia!” ");
INSERT INTO lcm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Au, kalinga kala mengen tapai, na kitola arai ta Iesu papalik kalapo ago. Na e mung ina si pangau ang a volo nat ang parik kitolpa mengen amalangas a mangsikei ta sa kitol tala arai ania. ");
INSERT INTO lcm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Si taun using ina kila kisiang le kuli mulang na petau lava kila ruduai ia. ");
INSERT INTO lcm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Na mangsikei a igenen nei liuan i petau ang kala songo alava, “Katakai i akalit, napo aikut ua asi kam me arai tapai ani kag nat, using kapo kag ring sikei palau a nat. ");
INSERT INTO lcm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ingua kapo uli sava ania na ka kail ataping na kanpo putput kolek ia na ingua ang, na rere kapo siang e amangana. Parik kapa atolongon lik tapai ania. Kapo vis arikek luai ania. ");
INSERT INTO lcm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Natala aikut kam keve nat asi kari lu suai ania, sikei parik kipa angkoai.” ");
INSERT INTO lcm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Na Iesu kala polpol asukang ke, “Nami na matan polpolokan tav lomlomon na milapo pataliung na selen korong. Poisan lak a taun si kag ago ve nami, na si kag telan tatami? Sunguk kam nat ane ke.” ");
INSERT INTO lcm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Si vuk taun akorong a nat ang kapo pakasang, na ingua ang kala so tatana ane vunep na kalapo putput kolek ia. Sikei Iesu kala kirikai ani ingua ang na kala vil ato na nat ang na kala alis pok ia si tamana. ");
INSERT INTO lcm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Na petau aongos ang kilapo mangal mat kana kitmat lava na God. Si taun ang ri vap kipo angtatapingai lak ani kana keve abis a Iesu, na kala antok kana keve nat asukang ke, ");
INSERT INTO lcm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mi teng akit aro na mengen ke naka mengen imi tatana! Igenen i pukun ki alis lak ia e kungaria i ri vap.” ");
INSERT INTO lcm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sikei parik kipa malangas ta supsupai i mengen ang. Kapo asukang ta mengen mumun asi kari tav luk ania, na kipo lolokovo si sui ania tatana. ");
INSERT INTO lcm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Na kilapo anggegelai nei liuan iria angpokpokai ta si iria nganing kavpo lavlabat. ");
INSERT INTO lcm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sikei Iesu kala nas kari lomlomonai, na kala songo na mang nat lik na kala atung ia ngerena, ");
INSERT INTO lcm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na kala antok iria asukang ke, “Man a si kapo ainak ani nat lik ke si asan ig, nang palau kapo ainak anig. Au na man a si kapo ainak anig, e iang kapo ainak ani vo asok ang anig. Using ninia voiang kapo liklik luai animi aongos io, ninia vanang kapo lavlabat.” ");
INSERT INTO lcm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Na Ioanes kala antok ta, “Volava, namemta arai ani mang igenen katapo kirikai suai ani ingua ta asan im, na namemta atakun ia, using parik kapa mangsikei imem.” ");
INSERT INTO lcm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sikei Iesu kala antok ia, “Mi ago ta atakun an ania. Arai, man a mangsikei kapo tav tubat animi, kapo tung ve nami nang.” ");
INSERT INTO lcm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Au, kalapo angasungai na taun asi luk alak ania ane metekuku, na kalapo lomlomonai akit asi kana palak ane Ierusalem. ");
INSERT INTO lcm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Asukang na kala asok a mang matan asi kari pasal aino, na kian palak nei mang rina si ri Samareia asi kari an itoitonai ta ring oring ania. ");
INSERT INTO lcm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sikei ri vap parik kitapa uruk suak ania, using kitala arai kinle ta kapo palak ane Ierusalem. ");
INSERT INTO lcm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Au, ngono nat ke ri Iakovo ve Ioanes kilongla arai ani oring asukang ke na kilongla antok, “Volava, kupo buk ani namemlong asok asiang ani kut le metekuku asi me ani suai tapai aniria?” ");
INSERT INTO lcm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sikei kala taval talang na kala ki irilong. ");
INSERT INTO lcm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na kila paliu ane si mang rina. ");
INSERT INTO lcm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Au, kilapo pasal aliu e selen, na mang igenen kala antok ia, “Nau naka auai ve numai si saka oring an ku pasal ia.” ");
INSERT INTO lcm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Na kala antok ia ta, “Ri kauvek kei kipo atogon kari mata na ri mani i nei pangau kipo atogon ting, sikei a igenen i pukun kapo kovek ta ring asi aoros ani patuna.” ");
INSERT INTO lcm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na kala songo na mang igenen, “Me na ku auai ve nau.” Sikei kala antok ta, “Volava, ku naol suai tapai anig, na nakan mo tapai ani mamai.” ");
INSERT INTO lcm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Na kala antok ia ta, “Ku atalipai ani ri vap mat na ki mo kari keve matmat. Sikei numai vanang ku pasal na kuan akus amalangas si keve ring aongos ta kana vainagoan a God.” ");
INSERT INTO lcm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Na mang anu kapa kamela antok, “Volava, naka auai ve numai, sikei ainoai ina ku atalipai anig ani nakan atatung aro tapai ani kag angnanan.” ");
INSERT INTO lcm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Au na Iesu kala antok ia asukang ke, “Man a sikei katala tutapong keke alung e matang, na kanla telan apetekai pok, nang parik kapa angkoai si abis si vainagoan si God.” ");
INSERT INTO lcm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Au, e mung i keve bil ke, Volava kala atung na mang 72 na igenen, na kala asok aino iria asi kari pasal pongpongua taun a keve rina lava na keve rina lik ang ninia lak ka pasal singina. ");
INSERT INTO lcm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kana pinipini aniria asukang ke, “Uai i nei matang kalapo duk, sikei kipo men lik palau a vap si kopos ania. Asukang na mi sokotuk a Volava i nei matang si kana asok ta vap sian kopos nei kana matang. ");
INSERT INTO lcm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mi pasal. Arai, napo asok imi val mamain ta natnat i sipsip nei liuan i ri kauvek kei. ");
INSERT INTO lcm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mi ago ta luk asisiang an. Tepe kapa ka ago, na pauk i kak ka ago. Mi ago ta pakanang ta mangsikei e selen. ");
INSERT INTO lcm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Man mi palak nei saka lu an, ainoai ina mi posong ta, ‘Marip ka ago si lu ke.’ ");
INSERT INTO lcm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Man a vo tauk i lu kapo igenen marip, kami marip ka ago singina, sikei man parik, mi luk pok na posong i marip ang. ");
INSERT INTO lcm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mi ago akorong nei lu ang, na mi angan a sa kipo sasagi animi tatana. Using kapo ro ta katakai i abis ka luk kana seupok. Mi ago ta rot angpok an. ");
INSERT INTO lcm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Man mi palak nei saka rina an na ki uruk suak animi, mi angan si pok ang ki sasagi animi tatana, ");
INSERT INTO lcm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","na mi vil ato kari keve malepen. Na mi antok iria, ‘Vainagoan si God kalapo angasungai animi.’ ");
INSERT INTO lcm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sikei man mi palak nei mangsikei a rina na parik kipa uruk suak animi, mi an tung nei keve selemat i rina ang na mi mengen amalangas asukang ke, ");
INSERT INTO lcm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Kana na kaponpon i kami rina kapo kaup e kakimem, namempo tap suai pok ania taun imi asi kami malangas ta mitala bil arikek. Sikei lak mi malangas aro luai ta vainagoan si God kalapo angasungai.’ ");
INSERT INTO lcm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Io, napo antok imi ta si taun ang e mung, ka pen roron lik ani ri Sodoma, sikei ri vap i rina ang ki sikei a rikek luai an. ");
INSERT INTO lcm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Ka rikek animi, ri Korasin! Ka rikek animi, ri Betsaida! Using man nganing ri Turo ve ri Sidon kita arai ani keve abis i vilvil ataping ang mitala arai ania, oro kila lomon pokai lenginang na ki alakai ani maus i mamakus na ki mo nei vuta. ");
INSERT INTO lcm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Sikei si taun i saupai ka pen roron lik ani ri Turo ve ri Sidon, sikei nami mi sikei a rikek luai an. ");
INSERT INTO lcm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Au na nami ri Kaparnaum, mipo buk vil alakat luai animi, ingko? Parik vang! Ki so asiang luai tatami ane si rina i mat! ");
INSERT INTO lcm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ninia kapo longong imi, nang palau kapo longong iau. Ninia kapo pial imi, nang palau kapo pial iau. Au na ninia kapo pial iau, e iang vanang kapo pial na vo asok ang anig.” ");
INSERT INTO lcm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Au e mung na 72 na igenen ke kimela papok velai ani uruk na kila antok, “Volava, pua ta ri ingua kapa kipo longong tatamem man namempo asok suai aniria si asan im.” ");
INSERT INTO lcm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Na kala antok iria ta, “Satan, le kabang le nata arai ania si uak asiang val tapak le metekuku. ");
INSERT INTO lcm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Arai, natala alis imi ta ro asi kami atoko kuli ri kene na ri pangup, na asi kami dual suai ani kitmat lava i igenen rikek, na ka kovek i nem ka vil arikek imi. ");
INSERT INTO lcm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sikei kantanem. Mi ago ta amalak uruk an ta ri ingua kipo longong tatami, parik. Mi uruk vang ta kami asan kapo ago akit e metekuku.” ");
INSERT INTO lcm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na si vuk taun ang a Malanganto Gogoai kala aduk ia ta uruk lava na kala mengen asukang ke, “Mamai, numai a Volava i metekuku na kuli rina. Napo alatun ua using kutala amunai ani keve nem ke pelek ri katakai i masam na ri vap malangas, na kula amalangasai ania si mamain ta nat lik. Tutuman mamai, using numai akorong kupo buk ia ani ka asukang. ");
INSERT INTO lcm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mamai katala alis a keve bil aongos singig. Na kapo kovek i mangsikei kapo uskorong kana nat, sikei tamana papalik. Na kapo kovek ta sikei kapo uskorong a tamana sikei kana nat papalik, kuvul ve ria kana nat kapo buk asi kana amalangasai aniria.” ");
INSERT INTO lcm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Au, kala taval talang kana keve nat i akalit na kala antok papalik iria asukang ke, “Riria ki arai ani keve bil ke mitala arai ania, ki uruk. ");
INSERT INTO lcm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Arai, napo antok kana imi ta amiang i keve katakai i kus amalangas na tulava i taun aino kitapo buk alava asi kari arai ani keve bil ke, kana milapo arai ania, na parik kita lapa arai ania. Na kitapo buk alava asi kari longong ani keve mengen ke kana milapo longong ia, na parik kita lapa longong ia.” ");
INSERT INTO lcm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Au, mangsikei a igenen malangas ani saupai kala tapasuk asi kana atokngai ania na kala sui ia asukang ke, “Katakai i akalit, naka vil sa asi kag togon ani to asikei?” ");
INSERT INTO lcm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Na kala sui ia, “Kitala salik a sa nei buk i saupai? Kupo saka palas an ania?” ");
INSERT INTO lcm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Na kala ngenget ta, “Ku atogon aongos a Volava kam God ta vingam aongos, na malanganto im aongos, na kitmat im aongos, na lomlomon im aongos, na ku vinga ro taun a tungam asukang palau val kupo vinga ro taun pok ua.” ");
INSERT INTO lcm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Na kala antok ia, “Io, kutala polpol aro vang. Ku abis ia asukang, na ku to.” ");
INSERT INTO lcm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sikei, nia kapo buk poso aro ania pok. Asukang na kala sui ia, “Au, si vanang kapo tungag?” ");
INSERT INTO lcm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Na Iesu kala polpol ia asukang ke, “Mang igenen katapo pasiang le Ierusalem ane Ieriko na kala arokonai ani ri katakai i tainau. Na kila luang kana keve maus na ki vis ia. Na e mung kila papelek ia si kalapo angasungai ani mat. ");
INSERT INTO lcm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Au, mangsikei a katakai i sula kamela kun pasiang si selen ang, na kala arai ania, na kala liu luai e mang ngising i selen. ");
INSERT INTO lcm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Na asukang kapa, mang igenen i patvap si Levi, kamela kun serei e oring ang na kala arai ania, na kala kun liu luai e mang ngising. ");
INSERT INTO lcm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Au, mangsikei a igenen le Samareia, katapo pasal e iang si kana paspasal, na kamela arai ania, kala lomon tangis ia. ");
INSERT INTO lcm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kala pataun ia na ka aoto kana keve mapolok, ka tiu ia ta rul i elaio ve vaen, na kala agon ia kuli kana dongki, na kala pasal tatana ane si mang lu ipo rot tul, na kanla aiveven ia. ");
INSERT INTO lcm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Na si taun using ina kala pak a men kapkap na kala alis ia si vo tauk i lu ang na kala antok ia asukang ke, ‘Ku aiveven ia. Taun naka serei pok, name polpol kam poisan a bil kutala amun ia singina.’ ");
INSERT INTO lcm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Au sa, si potol a igenen suke, si iritol nang kata akalit ta kapo tungana i vo puka ang e kungaria i ri katakai i tainau?” ");
INSERT INTO lcm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Na kala antok ta, “Vo lomon tangis ang ania.” Na Iesu kala antok ia, “Pasal na kuanla abis ia asukang.” ");
INSERT INTO lcm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Au, kila pasal aliu na kanla palak nei mang sikei a rina. Na mang aina, kana asan ta Marta, kala songo alak ia asi an ago tapai si kana lu. ");
INSERT INTO lcm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na katapo atogon a tasina, kana asan ta Maria. Katapo sinong ngere kakina i Volava sipo kokolongong ani kana akalkalit. ");
INSERT INTO lcm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sikei Marta katapo telan alava ta itoitonai ani kana keve abis. Au, kamela serei na kala mengen asukang ke, “Volava, parik kupa lomon rikek ta tasig kapo lomon suai ani keve itoitonai singig papalik? Ku asok ia ta kame pakangai tapai anig.” ");
INSERT INTO lcm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Sikei Volava kala polpol ia ta, “Numai Marta, kupo lomlomonai amiang na kupo telan ta bil miang, ");
INSERT INTO lcm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","sikei kapo atogon ta sikei palau a bil kapo mamaiten asi kara telan tatana. Arai, Maria kapo telan si abis ro ang. Parik kapa angkoai si luk suai ania singina.” ");
INSERT INTO lcm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mang sikei a taun kapo sokotuk e mang oring. Kala akamusai tapai na sikei i kana keve nat kala antok ia, “Volava, ku akalit imem ta sokotuk, asukang ta Ioanes kata kun akalit ani kana keve nat i akalit.” ");
INSERT INTO lcm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na kala antok iria, “Man mi sokotuk, mi posong asukang ke. Tamamem, namem uli mamaila ani asan im. Kam vainagoan kame. ");
INSERT INTO lcm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ku alis imem ta kamem pok nei siksikei a taun. ");
INSERT INTO lcm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Na ku lomon suai ani kamem keve lau rikek, using namem kapa namempo kun lomon suai ani kari keve lau rikek singimem. Na ku ago ta ausingai an animem taun a atoktokngai.” ");
INSERT INTO lcm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Na kalapo mengen aliu iria asukang ke, “Man a tungam kapo rot tenei liuan vong, na kuanla serei singina na kula sokotuk ia asukang ke, ‘Tungag, ku lis tapai anig ta potol a men saui, ");
INSERT INTO lcm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","using mang tungag kata mela serei i kana paspasal na napo kovek luai i pok asi sasagi ania.’ ");
INSERT INTO lcm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Au, na tungam vo po rot ang nei lu kala polpol ta, ‘Iuang, ku ago ta atelan an anig. Lenginang natala kinasonem a takaman, na namem kana kuli pata ve kag inatus. Parik napa angkoai si tapasuk asian alis anim!’ ");
INSERT INTO lcm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Napo antok imi ta parik kapa alis using kapo tungam, sikei using vanang kupo sunggil ia, ka soung na ka alis ua angkokoai si kam inongos. ");
INSERT INTO lcm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Napo antok imi ta mi aikut na mi atogon, mi gule na mi sabonai, mi pirpirikai na takaman ka tavas animi. ");
INSERT INTO lcm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Io, ninia kapo aikut, ka luk. Na ninia kapo gule, ka sabonai. Na ninia kapo pirpirikai, takaman ka tavas ania. ");
INSERT INTO lcm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Numai tama, man kam nat ka aikut ua ta ien, sa nang, kula alis ia ta kene? ");
INSERT INTO lcm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Vo man ka aikut ua ta katui, sa nang, kula alis ia ta pangup? ");
INSERT INTO lcm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nami na mamain ta katakai i bil arikek, sikei mipo uskorong a lau i alilis ta mamain ta alilis roron si kami inatus. Au sa nang si tamami e metekuku? Ninia parik kapa nas a lau i alilis alava ani Malanganto Gogoai singiria kipo sokotuk ia?” ");
INSERT INTO lcm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Mang sikei a taun kata kirikai suai ani mang ingua tapo. Si vuk taun ang kata soung suai, tapo ang kala mengen korong na petau lava ang e iang kila taping ania. ");
INSERT INTO lcm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sikei mang matan iria kilapo antok ta kapo kirikai ani ri ingua ta kitmat i Belsebul, kari tulava ri ingua. ");
INSERT INTO lcm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Na mang matan kitapo buk atokngai ania na kipo sunggil ia ani ka abis ta mangsikei a akanangai ta kitmat le pangkul. ");
INSERT INTO lcm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sikei kala nas kari lomlomonai na kala antok iria, “Man a vap i nei vainagoan ki angvis pok, kala tagoeng na matan vap ang, na kari keve lu ki tagalang. ");
INSERT INTO lcm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Na asukang kapa man a Satan ka angvis ve kana petau pok, kana tungtungan i tulava ka saka tung akit an? Kana mipo tupang ta nau napo kirikai ani ri ingua ta kitmat i Belsebul. ");
INSERT INTO lcm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Na man napo kirikai ani ri ingua ta kitmat i Belsebul, nei vanang? Kami keve nat kipo kun kirikai suai aniria ta kitmat i si? Arai, kami keve nat akorong ki akalit pok imi ta kami kapau. ");
INSERT INTO lcm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Sikei, using kana napo kirikai suai ani ri ingua ta kitmat i God, nang ninia vanang kapo akalit amalangas ta kana vainagoan a God kalapo serei singimi. ");
INSERT INTO lcm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Man a igenen dual, na kapo punuk ta kana keve bil i visvis, na ninia akorong kapo ararai bat ani kana lu io, kana keve togtogon aongos ki sinong aro. ");
INSERT INTO lcm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sikei man a mang anu kapo dual alava luai ania, kame vis ia na kala dual suai ania io, vo dual ang ka luk suai vang ani kana keve bil i visvis voiang katapo tokotoko tatana, na ka potok angtaliungai ani kana keve nem. ");
INSERT INTO lcm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ninia parik kapa tung ve nau, nang palau kapo tu talang iau. Na ninia parik kapa sosongo aiton ve nau, e iang kapo musa suai. ");
INSERT INTO lcm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Taun a malanganto rikek ka soung pelek a igenen, ka paliu si keve ring kapo kovek i laman na kanpo gule ring asi kana an ausai. Na man parik kapa sabonai ania kala antok, ‘Kapo ro naka papok ane si kag lu nata pasal pelek ia.’ ");
INSERT INTO lcm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Si vuk taun kamela serei, kala sabonai ta kitala gala ia na keve bil kipo sinong aroron. ");
INSERT INTO lcm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Au, kala pasal na kanla songo le na mang limalengua na ingua kipo rikek alava ania, na kimela riuklak na kila ago e iang. Na akamusai i tungtungan si igenen ang, kala rikek luai ani aino.” ");
INSERT INTO lcm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Si vuk taun ang kapo posong a keve mengen suke, mangsikei a aina i nei petau ang kala songosongo taun ia ta, “Roron ane si aina voiang kata ingus ua na kata atutus ua!” ");
INSERT INTO lcm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sikei kala antok, “Parik! Roron ane singiria kita longong a mengen si God na kila abis using ia.” ");
INSERT INTO lcm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Si vuk taun ang a petau kimela duk, na kala mengen asukang ke, “Kana na matan polpolokan i taun ke kipo vap rikek akorong. Kipo buk ta mang akanangai, sikei napo tav ainak si alis ani mang akanangai. Akanangai palau i Ionas, kapo ro ki arai ania. ");
INSERT INTO lcm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kana na matan polpolokan i taun ke, ki arai lak ani kari akanangai si igenen i pukun, asukang palau val ri Nineve kita arai ani Ionas val kari akanangai. ");
INSERT INTO lcm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na ainan tulava i ring vunga ang ka kun tapasuk ve matan polpolokan i taun ke si taun i saupai iles. Na lau roron ang kata abis ia si taun i Solomon, ka akalit iria ta kari lau rikek. Using ninia kata pasal le ring vunga luai asi kana me kolongong ani masam si Solomon. Sikei mi arai, igenen ke kana e matami kapo lavlabat ani Solomon. ");
INSERT INTO lcm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na asukang kapa ri vap i Nineve ki tapasuk ve matan polpolokan ke si taun i saupai iles, na kari lomon pokai si kana apasa na Ionas ka akalit amalangas pok na matan polpolokan i taun ke ta kari vinga kit. Sikei mi arai, igenen ke kana e matami kapo lavlabat ani Ionas. ");
INSERT INTO lcm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Parik tarapa asusuk lam asi kana sinong nei vakil vo nei avubus, sikei lam ka tung lakat akorong si kana tungtungan, ani ri vap man ki palak, kila arai korong ani mang. ");
INSERT INTO lcm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Matam ninia na lam ani pukun im. Man a matam ka ro, pukun im aongos ka malangas. Sikei man a matam parik kapa ro, pukun im aongos ka vong. ");
INSERT INTO lcm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Asukang na ku aiveven vei nganing a malangas ang kapo ago singim, ka vong pok. ");
INSERT INTO lcm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Io, man a pukun im ka malangas aongos, na ka kovek i palpal ka vong, ninia aongos ka mang asukang ta mang i lam kapo mang ua.” ");
INSERT INTO lcm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Si taun ang kalapo kamus ta mengen, na mangsikei a Parisaio kala sokotuk ia asi kana an sonkos ve nia. Na kala riuk lak na kanla sinong si pata i angan. ");
INSERT INTO lcm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Na Parisaio ang kala taping using kata arai ta parik katapa using a saupai i galui kunga aino ani matan angan. ");
INSERT INTO lcm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Sikei Volava kala antok ia, “Kana nami ri Parisaio mipo vil adaus a pere i ese ve avubus, sikei e neina mipo duk ta tainau ve lau rikek luai. ");
INSERT INTO lcm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Nami mipo vap nio akorong! Sa, vo abis ang ani tongina, parik katapa abis na neina kapa? ");
INSERT INTO lcm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mi arai! Mi alilis ani ri vap logo ta bil i nei vinga. Na man mila abis ia asukang, mi arai vanang ta keve bil aongos kala daus animi. ");
INSERT INTO lcm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ka rikek animi, ri Parisaio! Mipo alis aro kami sikei a vasangauli i panga sain ve mai ipo sukal e matang, sikei lau korong na lau i vinga ro val God, mipo ataole ia. Sikei riria nang na keve nem maiten ang kapo koi ta mi abis iria, na ka ago ta mi pial ta mang matan ang kapa. ");
INSERT INTO lcm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ka rikek animi ri Parisaio! Using mipo pigpig ta keve sinsinong roron luai nei lu i kivung, na asi posong ro singimi nei vaia mete ri vap. ");
INSERT INTO lcm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ka rikek animi ri Parisaio! Using mipo bil val kua kavang, na ri vap kipo lakau vongvong ia.” ");
INSERT INTO lcm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Na mang sikei i keve vap malangas ani saupai kala antok ia asukang ke, “Katakai i akalit, mengen ang kupo posong ia kapo asukang ta kupo varas imem kapa.” ");
INSERT INTO lcm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Sikei kala antok, “Nami kapa keve vap malangas ani saupai, ka rikek animi! Using mipo agon a keve asasalakan mamaiten luai kuli ri vap, sikei nami akorong parik mipa sigil singina ta sikei a piupiu i kungami si pakangai aniria. ");
INSERT INTO lcm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ka rikek animi! Using mipo atung akanangai si keve mopong si ri katakai i kus amalangas. Sikei, a keve tivumi akorong palau kita raung iria. ");
INSERT INTO lcm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Asukang na nami vang kana mipo malangas luai ani kari lau rikek a keve tivumi na mipo ainainakai kapa ania. Riria kita raung iria na nami mipo atung akanangai. ");
INSERT INTO lcm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Io, e iang vanang God kata mengen atutuman luai asukang ke, ‘Naka asok na mamain ta katakai i kus amalangas ve aposel ane singiria, na kian raung a mang matan na ki vil akui a mang matan,’ ");
INSERT INTO lcm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ani matan polpolokan i taun ke ki sunguk a mamaiten i keve daung ang. Rangai i mamain ta katakai i kus amalangas aongos le si tutapongai i kuli rina, mamaiten ina ka gon si matan polpolokan i taun ke, ");
INSERT INTO lcm_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","le si rangai i Abel tung si rangai i Sakarias voiang kata puka nei liuan i pata ipo sula na lu i atailai. Io, napo antok imi ta mamaiten i rangai aongos ang ka gon kuli matan polpolokan i taun ke. ");
INSERT INTO lcm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ka rikek animi keve vap malangas ani saupai! Using mitala akang akit a takaman i lau i uskorong. Nami parik mipa palak na riria kipo buk palak singina mipo akang bat vang iria.” ");
INSERT INTO lcm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Na kala papelek a oring ang. Au, e mung na ri Parisaio ve keve vap malangas ani saupai kila songag alava ania na kilapo sunggil ia asi kana akus ta mang matan bil miang, ");
INSERT INTO lcm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","na kilapo lomlomonai selen asi kari teng akit ania si mang matan bil man nganing ka posong ia si kana mengen. ");
INSERT INTO lcm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na si taun ang a petau tavirimok luai kime duk akuvul na kimela angkokokapis angpokpokai aniria. Au na kala tutapongai mengen aino si kana keve nat i akalit asukang ke, “Mi aiveven imi pelek a yeast si ri Parisaio, nang ninia na kapau. ");
INSERT INTO lcm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Kapo kovek i bil kapo ago nei apupung ki tav tavas ia, vo bil kapo ago mumun, ka tav serei e ring malangas. ");
INSERT INTO lcm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Saka mengen an mitapo posong ia e ring vong, ki longong lak ia e mete malangas. Na saka mengen an mitapo angtultulibotai tatana nei lu, ki songosongo tatana e ring malangas nei rina. ");
INSERT INTO lcm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Napo antok imi keve tungag, mi ago ta leng an aniria kipo raung a pukun palau, na e mung ina kapo kovek ta mang nem ki abis korong ia. ");
INSERT INTO lcm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sikei naka mengen amalangas imi ta igenen ang asi kami leng ania. Mi leng ani igenen voiang man katala raung a pukun, kapo atogon a roron asi kana asuai asiang ane nei rina i kui. Io, napo antok imi, mi leng ania. ");
INSERT INTO lcm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Arai ani ri tuv. Kipo samui iria ta kapkap lik luai. Na God parik kapa angkoai si lomon taun aniria. ");
INSERT INTO lcm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Io, God katala taot pasuk a keve ung i patumi. Mi ago ta leng an. Nami mipo marmarai lava luai ani mamain ta tuv duk. ");
INSERT INTO lcm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Napo antok imi ta riria kipo atitipas tatag e mataria i ri vap, asukang kapa na igenen i pukun ka kun atitipas tataria e mataria i mamain ta angelo si God. ");
INSERT INTO lcm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sikei riria kipo agel suai anig e mataria i ri vap, ka kun agel suai aniria e mataria i mamain ta angelo si God. ");
INSERT INTO lcm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Na ninia kapo mengen susual a igenen i pukun, kapo angkoai si lomon suai korong ani kana rikek. Sikei ninia kapo mengen i nau varas ani Malanganto Gogoai, parik kapa atogon lomon suai ani rikek ang. ");
INSERT INTO lcm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Na man kilapo tak imi taun a keve lu i kivung ani ri katakai i saupai ve ri vap asasanan ki saupai animi, mi ago ta vinga urui an ta mi saka polpol an vo mi saka mengen an. ");
INSERT INTO lcm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Using a Malanganto Gogoai, ninia ka akalit imi si vuk taun ang palau ta mi saka mengen an.” ");
INSERT INTO lcm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Na mangsikei i petau ang kala antok ia, “Katakai i akalit, ku asok a tasig asi kana pagal anig ta mang palpal i togtogon ang si tamamemlong.” ");
INSERT INTO lcm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Sikei kala antok ia ta, “Iuang, parik napa tung asukang ta katakai i saupai vo katakai i pagpagal animilong.” ");
INSERT INTO lcm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na kala mengen iria ta, “Mi ararai aro na mi aiveven si mamain ta lomlomonai miang i neikitung, using a igenen, kantanem kapo duk ta togtogon, sikei kana to parik kapa tukulai ina si duk i kana togtogon.” ");
INSERT INTO lcm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na kala mengen iria ta kankanuai i mengen asukang ke, “Mang sikei a igenen tauia, kana roe katapo uai aduk luai. ");
INSERT INTO lcm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Na kala lomlomonai ta, ‘Naka abis sa vang kana? Using napo kovek i ring asi kag asinong ani keve uai i kag matang.’ ");
INSERT INTO lcm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Na kala antok ta, ‘Kapo ro, naka abis ia asukang ke. Naka but aongos kag keve lu ipo asisinong, na naka abis a keve lu tavirimok luai asi kag asinong ani keve uai i kag matang na kag keve usausan aongos. ");
INSERT INTO lcm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Na naka mengen pok iau asukang ke ta, iuang, kutala abis alava na keve bil ani keve matas miang ani ku kalakala. Kana vang ku angan, na ku inum na ku maramarak.’ ");
INSERT INTO lcm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sikei God kala antok ia, ‘Tanio! Nganing lak vong ki luk suai ani malanganto im. Na keve bil ang kupo usausa iria, ke si ia?’ ");
INSERT INTO lcm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Io, sukana na kankanuai i igenen, voiang kapo asinong akuvul kana keve bil roron ania papalik, na parik kapa tauia taun a God.” ");
INSERT INTO lcm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Na kala mengen kana keve nat i akalit, “Asukang a napo antok imi ta mi ago ta urui an ani kami to, ta mi angan a sa, na ani pukun imi ta mi kavat ta sa. ");
INSERT INTO lcm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Using kami to kapo laba ani pok, na pukun imi kapo laba ani vakup. ");
INSERT INTO lcm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mi arai ani mamain ta kol. Parik kipa sukal na parik kipa kopkopos kapa. Kipo kovek i lu asi asinong pok na usausan, sikei God kapo li pok iria. Arai, ri mani kipo roron lik palau, sikei nami vanang mipo sikei a miminaungan luai an! ");
INSERT INTO lcm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Si imi kapo angkoai si to avunga lik si uli urui? ");
INSERT INTO lcm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Au, na man parik mipa angkoai si abis ani bil lik palau asukang, using a sa mipo urui using a mang matan bil? ");
INSERT INTO lcm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mi arai ani mamain ta purpur si kari polok. Parik kipa abis. Parik kipa suisui vakup. Sikei napo antok imi ta Solomon si kana amaumausan asip parik katapa miminaungan asukang val mangsikei iria. ");
INSERT INTO lcm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","God kana kapo amaus a mamain ta uriuri ani ki mang miminaungan ani sikei a taun kudik palau, na ilesvauk ki suluk suai aniria. Au nei vanang? God parik kapa angkoai si akavat animi? Pua, kami lomlomon kapo kudik luai! ");
INSERT INTO lcm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mi ago ta gule an ta mi angan a sa vo mi inum a sa. Mi ago ta uli urui an. ");
INSERT INTO lcm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Using a keve matan vap i kuli rina kipo gule na keve nem ke. Sikei tamami kapo nas ta mipo inongos taun iria. ");
INSERT INTO lcm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Si oring ke, mi lomlomon maiten using kana vainagoan, na keve nem ke kakami iria kapa. ");
INSERT INTO lcm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nami kag inatus sipsip ro lik, mi ago ta leng an. Using a tamami katala lomlomonai i uruk alava ani mi ago aro si kana vainagoan. ");
INSERT INTO lcm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mi atos ta kami keve togtogon, na mi alis ri vap mailik. Mi itoitonai ta kami asisiang parik kapa angkoai si kavang na tauia ang neina kapo tauia i metekuku, parik kapa angkoai si mun, na ri vap tainau parik kipa sigil ia na ri manmanik parik kipa se ia. ");
INSERT INTO lcm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Arai, man kami togtogon kapo ago si saka ring an, pakangat imi kapa ka kun ago singina. ");
INSERT INTO lcm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Mi ngenge usausa kami keve vakup, na mi uli itoiton usausa ani kami keve lam asi kari mang. ");
INSERT INTO lcm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Mi usausa val vap po kokoai ani kari tulava, ani man kala serei pok le si matan angan i osongon, na kala pirpirikai, kila tavas sumasuma ania. ");
INSERT INTO lcm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Keve asosokai ang, man kari tulava ka serei sabonai aniria si kipo para koai, kala roron aniria. Napo antok atutuman vang imi ta tulava ang ka songo iria ane si pata i angan na ka maus ta maus i vil pok asi kana ali pok aniria. ");
INSERT INTO lcm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Io, man ka serei tenei liuan vong vo man ka angasungai i tangat na kamela sabonai aniria si po para koai, kala roron luai aniria. ");
INSERT INTO lcm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kana mi malangas ta man a votauk i lu kata nas a vuk taun asi serei ta katakai i tainau, kala ararai bat aro ani kana lu na parik kalapa ding ia. ");
INSERT INTO lcm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nami kapa mi usausa. Using a igenen i pukun ka serei si vuk taun ang parik mipa lomlomonai ania singina.” ");
INSERT INTO lcm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na Petero kala sui ta, “Volava, kana kupo mengen ta kankanuai i mengen ke animem, vo ani ri vap aongos?” ");
INSERT INTO lcm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na Volava kala mengen asukang ke, “Man a katakai i aiveven kapo atutuman na kapo masam, kana lau i abis ka asukang ke. Kana tulava ka asok ia asi aiveven ani kana keve asosokai aongos, asi kana alis aniria ta kari sasagian si taun ina akorong. ");
INSERT INTO lcm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Au, na man kana tulava kala serei sabonai ani kapo abis ia, ka roron ania. ");
INSERT INTO lcm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Napo mengen atutuman imi ta tulava ang ka asok ia asi kana aiveven aongos ani kana mamain ta togtogon. ");
INSERT INTO lcm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sikei man a asosokai ang kapo lomon ia asukang ke ta ‘Kag tulava nang parik kapa serei pok sumasuma,’ na kala tutapong sasaup ani mamain ta asosokai tauan ve aina, na kapo matan angan na kapo inum na kalapo vangang nio, ");
INSERT INTO lcm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kana tulava ka serei pok si taun parik katapa lomlomonai ania singina. Ka serei si taun parik katapa nas ia. Na kamela tangatangai amitmitlikai ania na ka asok suai ania ane si ring ang ri vap tav lomlomon ki an ago singina. ");
INSERT INTO lcm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Man a asosokai kapo nas a vubuk si kana tulava, sikei parik kapa usausa ia vo parik kapa abis kana vubuk, ka luk a sasaup kitmat. ");
INSERT INTO lcm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sikei ninia parik kapa malangas na kala abis a nem kapo angkoai si saup ania singina, ki saup apongo palau ia. Ninia kita alis alava ia, ki lomlomon ani palpal lava singina. Io, man kita alis aduk ia asi kana aiveven tapai ania, ki lomlomon ta ki luk alava lak singina. ");
INSERT INTO lcm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Natame serei asi kag me asuai ani kut ni kuli rina aongos. Napo buk sumasuma ani ka karkarian! ");
INSERT INTO lcm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Sikei kapo togon a mang asising kitmat asi kag duai ania. Kana napo ago i vinga mamaiten ania, tung si nala luk ia. ");
INSERT INTO lcm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sa? Mipo lomon ia ta nata serei asi me asinong ani luai kuli rina? Parik luai! Napo antok imi ta name asinong a sinsinong i angtaliungai. ");
INSERT INTO lcm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Asukang ke ta nei sikei a matan vap ki tapagal. Mang potol ki angtaliungai ve mang pongua. ");
INSERT INTO lcm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Io, ri angtama ki tapagal angtaliungai, ri angnanan, na ri angomonan kapa. Mang anu ka marala na mang anu.” ");
INSERT INTO lcm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Na katapo mengen kapa na petau lava ang e iang asukang ke, “Man mila arai ani kuku kalapo sorol alak e suke si ring ipo siang ta makarap, mila kinle sumasuma ta ka togon langit, na kapo asukang. ");
INSERT INTO lcm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Na man mila arai ani malu kala so alak, mila kinle ta ka sinang nini nganlak, na kapo asukang. ");
INSERT INTO lcm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pua, mipo nas aro na keve angpetpetekai i taun i kuli rina ke. Sikei marai sa parik mipa tun kinle na keve bil i taun ke? Nami na matan vap kapau akorong! ");
INSERT INTO lcm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Marai sa nami akorong parik mipa saupai ani bil kapo korong? ");
INSERT INTO lcm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Man kupo pasal kuvul ve vopo petau ang anim asi kamilong pasal ane si katakai i saupai, ku atoktokngai vilvil akorong ve nia e selen, vei nganing kala tak ua ane si mang katakai i saupai lakat, na nia kala alis ua ane si kana asosokai na asosokai ang kanla asuai anim nei lu i akangbat. ");
INSERT INTO lcm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Napo antok ua, parik luai kupa angkoai si soung le iang, tung si kula samui suai luai ani akamusai luai i vuk kope lik.” ");
INSERT INTO lcm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Si taun ang palau mang vap kitapo ago e iang na kila akuskus ia ta matan vap ang i Galilaia voiang Pilato kata raung iria si po sula alilis. ");
INSERT INTO lcm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Na kala antok iria asukang ke, “Au sa, si volo tanganu i Galilaia, mipo lomon ia ta kitapo katakai i bil arikek luai ani ri Galilaia aongos using kana kitala puka? ");
INSERT INTO lcm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Napo antok imi ta parik vang! Sikei nami, man parik mipa lomon pokai, mi kun puka aongos asukang. ");
INSERT INTO lcm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Au na sa si 18 a igenen voiang a lu vungavunga lakat ang e Siloam kata ngom punuk iria? Mipo lomon ia ta tukulai ina using kari lau rikek katapo laba luai ani mang keve vap i Ierusalem aongos? ");
INSERT INTO lcm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Napo antok imi ta parik vang! Sikei nami, man parik mipa lomon pokai, mi kun puka aongos asukang.” ");
INSERT INTO lcm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Na kala mengen iria ta kankanuai i mengen asukang ke, “Mangsikei a igenen katapo atogon kana matang vaen. Na kita sukal a mangsikei a iei nei matang ang. Au kamela serei asi kana me ararai na kamela gule na uai i ei ang, sikei parik kapa arai sabonai ania. ");
INSERT INTO lcm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Na kala antok a katakai i aiveven matang asukang ke, ‘Arai, potol a matas aongos ke nata mela gus a uai i ei ke, sikei parik lak napa sabonai ta ring uai ina. Ku tanga suai ania! Kapo uli tung palau nei matang ke ani sa?’ ");
INSERT INTO lcm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sikei kala antok ia ta, ‘Iuang, ku atolongon ia si matas ke na name kalkalvakum tapai ania. ");
INSERT INTO lcm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Na man kala uai lak si matas suke e mung, kala ro. Na man parik, ku tanga suai vang ania.’” ");
INSERT INTO lcm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Si mang taun i atailai katapo akalkalit nei mangsikei a lu i kivung. ");
INSERT INTO lcm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Au, mangsikei a aina katapo ago e iang, na ingua i pukun malum katapo aol ia si 18 a matas aongos. Na katapo tatalukun a pukun ina. Parik kapa angkoai si koros akorong ania. ");
INSERT INTO lcm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Au, Iesu kala arai ania na kala songo asung ia na kala antok ia, “Iuang, kula kala pelek kam pukun malum.” ");
INSERT INTO lcm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ka amatung a kungana e pukun ina, na akorong palau, kala koros atung ia. Na kala alatun a God. ");
INSERT INTO lcm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Na tulava i nei lu ang kala arai ta Iesu katala abis a vilvil ato. Na kala marala na Iesu using kapo abis ia si taun i atailai. Na kalapo mengen si ri vap asukang ke, “Limalesikei a taun aongos asi abis. Mi serei vang si keve taun ang na kame vil ato imi. Na parik si taun i atailai.” ");
INSERT INTO lcm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sikei Volava kala polpol ia asukang ke, “Nami na mamain ta katakai i kapau! Sa, parik mipa kunis kami bulumakau vo dongki si taun i atailai? Na mi tak ia asi kana an inum? ");
INSERT INTO lcm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Au, na aina ke? Kapo tivuna i Abaram, na kata lapo ago si gogotan si Satan si 18 a matas aongos. Sa, parik kapa ro ta naka kun kunis ania si taun i atailai asi kana kala?” ");
INSERT INTO lcm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Vuk taun ang kapo mengen asukang, riria vap po petau ang ania, kilapo mese. Na petau lava aongos ang kipo uruk ani keve abis miminaungan ang katala abis ia. ");
INSERT INTO lcm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Asukang na kala mengen ta, “Vainagoan si God kapo bil val sa? Naka alalangtongai ania ta sa? ");
INSERT INTO lcm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kapo asukang ke. Mang igenen kata luk a katui i sinapeo na kanla asuai ania nei kana matang. Na katui ang kala polok alak na e mung kala ei, angkoai ani ri mani i nei pangau kime ting kuli keve ngakan ina.” ");
INSERT INTO lcm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Na kala mengen kapa asukang ke, “Naka alalangtongai ani vainagoan si God ta sa? ");
INSERT INTO lcm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kapo asukang val men yeast nang a aina kata luk ia na kala angvilai ania ve potol a pakut lava i palaua, na kala bakang tung si palaua aongos ang kala yeast an.” ");
INSERT INTO lcm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na kala pasal na kanpo pasal si keve rina lava na keve rina lik aliu alak ane Ierusalem. Na si kana paspasal kanpo vil kana akalkalit. ");
INSERT INTO lcm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Na mangsikei kala sui ia, “Volava, rukun lik palau nang kian sapang?” Na kala polpol iria, ");
INSERT INTO lcm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mi atoktokngai amadot asi kami palak si takaman ngingimai. Napo antok imi ta vap miang ki atokngai asi kari palak na parik kipa angkoai. ");
INSERT INTO lcm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Man a votauk i lu ka tapasuk na kala akang a takaman kala akang. Kantanem mila tung e komo na mila pirpirikai na mila songo, ‘Volava, ku tavas animem.’ Sikei ninia kala polpol imi ta, ‘Parik napa nas imi ta nami le voi.’ ");
INSERT INTO lcm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Na mila antok ia, ‘Taratapo matan angan kuvul. Na kutapo akalkalit nei kamem rina.’ ");
INSERT INTO lcm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sikei kala polpol imi ta, ‘Napo antok imi ta parik napa nas imi ta nami le voi. Mi pasal akipai anig. Nami na keve katakai i abis ani rikek!’ ");
INSERT INTO lcm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na kala kirikai suai animi na mianla aloi velai ani ngut ngisa using mi arai ani ri Abaram ve Isak na Iakov kuvul ve mamain ta katakai i kus amalangas aino kipo ago si kana vainagoan a God, sikei nami parik. ");
INSERT INTO lcm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Na vap duk luai ki serei le keve palpal aongos i kuli rina na kian matan angan nei vainagoan ang, sikei nami parik. ");
INSERT INTO lcm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Arai, ka atogon vap kana kipo aimung, kian aino. Na mang vap kana kipo aino, kian aimung.” ");
INSERT INTO lcm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Si vuk taun ang palau mang matan i ri Parisaio kimela pakasang na kila antok ia, “Ku pasal suai ani oring ke, using a Erodes kapo buk raung anim.” ");
INSERT INTO lcm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Na kala antok iria ta, “Mi pasal na mianla alis a kauvek kei lik ang ta mengen ke, ‘Arai, kana napo lu suai ani ri ingua na napo vilvil ato, na ilesvauk kapa. Na si vapotol i taun nakan vil apunuk a abis ang napo abis using ia.’ ");
INSERT INTO lcm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Au sikei, kapo mamaiten ta naka pasal si kag selen kana na ilesvauk na tangat using parik kapa angkoai ta katakai i kus amalangas ka puka akipai ani Ierusalem. ");
INSERT INTO lcm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Numai vang a Ierusalem, kuta raung ri katakai i kus amalangas, na kuta li punuk iria, vap ang a God kata asok iria taun ua. Taun miang nata lapo buk songo akuvul ani kam inatus asukang ta pura aina kapo apung kana keve natnat neite ngono vangana. Sikei mitapo uli misag! ");
INSERT INTO lcm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mi arai! Sukana kami lu kalapo tung vauvau. Na kana napo antok imi ta parik mipa anguan arai an anig tung si taun mila songosongo asukang ke, Atautauia singina, nang kalapo serei ta asan i Volava!” ");
INSERT INTO lcm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Si mangsikei a taun i atailai kala pasal asi an angan si lu si mang ainoinoai i ri Parisaio, na ri vap kipo alim aroron ia. ");
INSERT INTO lcm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Au, e iang palau e no ina, mang igenen katapo malepen ta pukun vusul. ");
INSERT INTO lcm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Na Iesu kala sui na keve vap malangas ani saupai ve keve Parisaio ang asukang ke, “Kara saupai kapo ainak ani vilvil ato si taun i atailai, vo parik?” ");
INSERT INTO lcm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sikei kipo sinong musik. Na kala teng ia na kala vil ato ia na kala atolongon ia asi kana pasal. ");
INSERT INTO lcm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na kala sui iria ta, “Man kam nat vo kam bulumakau kata uak nei dim si taun i atailai sa, parik kupa tak alak sumasuma ia?” ");
INSERT INTO lcm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na parik kipa angkoai si polpol ani mengen ke. ");
INSERT INTO lcm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na kala mengen singiria ta kankanuai i mengen, using kala arai ta vap ang kitala songo iria ane si matan angan ang kitapo pilak a keve sinsinong ro e no. ");
INSERT INTO lcm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Man a mangsikei kata songo ua ane si matan angan i osongon, ku ago ta an sinong si sinsinong ro e no, vei nganing kitala songo na mang anu kapo asasanan anim, ");
INSERT INTO lcm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","na vo songo ang animilong aongos kame serei na kala asok suai pok anim asukang ke, ‘Ku tapasuk alang ani igenen ke!’ Na numai kula tapasuk mese asiang taun a sinsinong ang e kevkev luai. ");
INSERT INTO lcm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Sikei, man ki songo ua ku pasal na ku luk a sinsinong e kevkev luai, na vo songo ang anim ka serei na kala antok ua asukang ke, ‘Tungag, ku tapasuk alak ane no!’ Asukang na riria aongos kipo angan kuvul ve numai ki mamaila anim. ");
INSERT INTO lcm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Io, nia kapo vil alava pok ia, ki vil alik ia. Na nia kapo vil alik pok ia, ki sunguk alakat ia.” ");
INSERT INTO lcm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Na kala antok kapa na vo songo ang ania ta, “Man kutala itoitonai ani matan angan i tenei ias vo tenei ngelik, ku ago ta songo an ani keve tungam vo keve tasim vo kam patvap vo ri vap tauia e ngerem, vei nganing kila kun songo pok anim, na kila polpol kam matan pok, nang palau. ");
INSERT INTO lcm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Sikei man kupo itoitonai ani matan angan, ku songo ri logo na ri soles na ri pepe na ri ba. ");
INSERT INTO lcm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Man asukang, kula tauia using a vap asukang ke parik kipa angkoai si polpol ani kam matan pok, sikei lak ku luk kam seu si taun i tadut pok ta ri katakai i korong.” ");
INSERT INTO lcm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Na mangsikei iria vap po sinong ang ve nia si matan angan kala longong a mengen ke na kala antok ia, “Ka roron ani vap ang nganinglak ki angan si matan angan ang nei vainagoan si God.” ");
INSERT INTO lcm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sikei Iesu kala antok ia ta, “Mangsikei a igenen kata itoitonai ani matan angan lava na kala songo na vap duk. ");
INSERT INTO lcm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na si vuk taun i matan angan, kala asok kana asosokai asi kana an mengen ani vap ang asukang ke, ‘Mi me, using kalapo usausa aongos.’ ");
INSERT INTO lcm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sikei riria aongos kilapo mengen bat pok iria. Ainoai i igenen kala antok ia ta, ‘Natala samui kag vuk roe. Kana naka pasal, nakan arai ania. Napo sokotuk ua, ku akala iau.’ ");
INSERT INTO lcm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Na mang anu kapa kala antok ta, ‘Natala samui kag keve bulumakau asi abis nei matang. Naka pasal, nakan atoktokngai aniria. Napo sokotuk ua, ku akala iau.’ ");
INSERT INTO lcm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Na mang anu kala antok ta, ‘Nalapo osongon atanginang kana ve kag aina. Asukang na parik nalapa serei.’ ");
INSERT INTO lcm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Au, asosokai ang kala papok na kamela mengen amalangas kana volava ta oring ke. Ninia na votauk i lu ang kala marala na kala antok kana asosokai asukang ke, ‘Ku pasal sumasuma nei keve selemat na keve selen lik nei rina na kuan songo na ri logo na ri soles na ri ba na riria kipo pepe.’ ");
INSERT INTO lcm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Au, asosokai ang kala antok ta, ‘Volava, bil ang kupo asok tatana kitala abis ia lenginang, sikei kapo atogon pangau lak.’ ");
INSERT INTO lcm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Na volava ang kala antok ia ta, ‘Ku pasal nei keve selen lava na keve selen lik ane matang, na ku aisul ri vap asi kari me palak ani kag lu ka duk. ");
INSERT INTO lcm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Using napo antok imi ta vap aongos ang natala songo iria, parik luai kipa angkoai si namnamin ani kag matan pok.’” ");
INSERT INTO lcm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Na si taun ang a petau lava luai kimela auai ve nia na kala taval talang na kala mengen iria asukang ke, ");
INSERT INTO lcm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Man a si ka serei singig na parik kapa lomon alik a tamana na rinana na kana aina na kana inatus na keve tasina na keve tauna na kana to akorong, parik kapa angkoai si ago val kag nat i akalit. ");
INSERT INTO lcm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Na man a si parik kapa asalak kana ngakputuk na ka using iau, parik kapa angkoai si ago val kag nat i akalit. ");
INSERT INTO lcm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Arai, man a si imi kapo lomlomonai ani ka abis kana lu sa, parik kapa sinong aino tapai asi kana tataot ani samui ina, ani ka malangas ta kapo koi si akamusai ania? ");
INSERT INTO lcm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Vei nganing kala amatung palau a tutapongai ina na parik kalapa angkoai si akamusai ania na riria aongos a vap po arai ang kila angkurek tatana, ");
INSERT INTO lcm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Pua, igenen ke kata tutapongai ani abis i lu ke na parik kalapa angkoai si akamusai ania.’ ");
INSERT INTO lcm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mi arai kapa ani tulava. Man kapo lomlomonai asi an angvis ve mang tulava sa, parik kapa sinong aino tapai asi lomlomonai ta kana petau i visvis kapo koi asi angvis ve mang petau ang kipo tavirimok luai ania? ");
INSERT INTO lcm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Au, vei nganing ninia kavpo ago avunga lak, kala asok asi an sokotuk ania asi kana amatung ani luai. ");
INSERT INTO lcm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Asukang vang, man a si imi parik kapa ataole kana keve bil aongos, parik kapa angkoai si ago val kag nat i akalit. ");
INSERT INTO lcm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Asukang vang, makasim kapo bil ro, sikei man a makasim kala tamus a namin ina, ki saka vil anamin an pok ania? ");
INSERT INTO lcm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kilapo misag si tol ania ve roe, na kalapo asukang ta mung rikek luai, na ki asuai ania. Ninia kapo atogon talinga, kapo ro ka longong a mengen ke.” ");
INSERT INTO lcm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Au, ri katakai i luk takis ve ri katakai i bil arikek aongos kimela serei singina asi me kolongong ania. ");
INSERT INTO lcm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na ri Parisaio ve ri vap malangas ani saupai kilapo mengen lilimukai ania asukang ke, “Igenen ke kapo uruk suak ani ri katakai i bil arikek na kapo angan kuvul ve ria.” ");
INSERT INTO lcm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Na kala mengen iria ta kankanuai i mengen asukang ke, ");
INSERT INTO lcm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Man ta mangsikei imi kapo togon kana 100 na sipsip, na man katala amun a sikei iria sa, parik kalapa atolongon aongos a 99 ang nei ring varasai palau asi kana an gule using ani vola mun ang tung si kala sabonai ania? ");
INSERT INTO lcm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Na si taun kala sabonai ania, ka maramarak na kala agon ia e kalakalana. ");
INSERT INTO lcm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Au, kanla serei e rina na kala songo akuvul a keve tungana na vap po ago angasungai ina, na kala antok iria ta, ‘Mi maramarak kuvul ve nau using natala sabonai pok ani kag sipsip vola mun ang.’ ");
INSERT INTO lcm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Napo antok imi ta ka asukang kapa e metekuku. Ki uruk alava ani sikei a katakai i bil arikek katala lomon pokai, ani vap korong ang parik kipa inongos taun a lomon pokai. ");
INSERT INTO lcm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Na man a aina kapo atogon kana sangauli na vuk kapkap, na man katala amun a sikei iria, au si parik kapa gusgus asi kana sabonai pok ania? Ka asusuk kana lam, ka galagala nei kana lu, na ka gus aroron luai tung si kala sabonai pok ania. ");
INSERT INTO lcm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na si taun kala sabonai ania, kala songo akuvul a keve tungana na vap po ago angasungai ina, na kala antok iria ta, ‘Mi maramarak kuvul ve nau, using natala sabonai pok ani kag kapkap vola mun ang.’ ");
INSERT INTO lcm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Napo antok imi ta kapo asukang palau kapa e mataria i mamain ta angelo si God. Kipo atogon a uruk ani sikei a katakai i bil arikek katala lomon pokai.” ");
INSERT INTO lcm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Na kala antok, “Mangsikei a igenen katapo togon kana pongua na nat tauan. ");
INSERT INTO lcm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na anu tasin irilong kala sokotuk a tamana, ‘Mamai, ku alis iau ta palpal i togtogon ang kapo ago anig.’ Na kala potok irilong ta kana togtogon. ");
INSERT INTO lcm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Na parik kapa taun vunga, anu tasin kala luk akuvul kana togtogon asip na kala pasal ane ring vunga, na e iang si palpal ang kanla aole kana togtogon si to angvolai. ");
INSERT INTO lcm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Au, taun kanla aole na keve bil amot, mol lava kala serei e palpal ang, na kala tutapongai ani to i inongos. ");
INSERT INTO lcm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Na kanla angmemengenai ve mang igenen akorong i palpal ang, na kanla asok ia taun kana vuk roe asi kanan apus vongo. ");
INSERT INTO lcm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Na katapo uruk asi kanan masung ta pauk i pok ang ri vongo kitapo angan ia, na kapo kovek ta sikei ka li pok ania. ");
INSERT INTO lcm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sikei taun kala lomlomonai malangas pok na kala antok, ‘Poisan a asosokai ipo samui ta mamai kipo masung aro na kipo atogon pok angkoai asi agongon, sikei nau namelapo buk mat ta mol e ke! ");
INSERT INTO lcm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Naka tapasuk na naka papok ane si mamai na nakan antok ia asukang ke, “Mamai, natala bil arikek mete God na e malangas i matam. ");
INSERT INTO lcm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Parik napa anguan ro angkoai an asi posong anig ta nau kam nat. Kapo ro kam laulauan anig ka bil val mang sikei iria kam keve asosokai kupo samui iria.” ’ ");
INSERT INTO lcm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Na kala tapasuk na kala papok taun a tamana. Sikei katapo pasal e ring vunga lak na tamana kala arai ania na kala lomon tangis ia, na kala sang na kanla sovai ia na kala lulus ia. ");
INSERT INTO lcm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Na nat ang kala antok ia, ‘Mamai natala bil arikek mete God na e malangas i matam. Parik napa anguan ro angkoai an asi posong anig ta nau kam nat.’ ");
INSERT INTO lcm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Sikei tamana kala antok kana keve asosokai, ‘Mi luk sumasuma ta ring maus ro luai, na mi me amaus ia tatana, na mi alak ta ring magung e kungana, na ngono pauk i kak e ngono kakina, ");
INSERT INTO lcm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","na mi luk ta ring natnat pukunan i bulumakau na mi raung ia na tara me angan na tara maramarak. ");
INSERT INTO lcm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Using kana kag nat katala mat, na kana kala to pok. Katala mun, na kana taralapo sabonai pok ania.’ Na kila tutapongai ani kari maramarak. ");
INSERT INTO lcm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Au, kana ainoai i nat katapo ago e matang. Na si taun kamela serei angasungai ani lu, kala longong a kariu i malmalang. ");
INSERT INTO lcm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na kala songo na mangsikei i keve asosokai na kamela susuiai ania ta supsupai ina. ");
INSERT INTO lcm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Na kala antok ia, ‘Tasim katala serei, na tamam kala runguk a natnat pukunan i bulumakau, using kala arai pok ania na kapo to aro.’ ");
INSERT INTO lcm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Au kala marala na kalapo tangag ani palak. Na tamana kala soung na kanla mengen aro ia. ");
INSERT INTO lcm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sikei kala polpol a tamana asukang ke, ‘Pua, keve matas duk ke natala abis anim, na parik nata lapa pial kam keve asok. Parik lak kutapa alis iau ta ring natnat i me lik palau asi kag kun uruk kuvul ve keve tungag. ");
INSERT INTO lcm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sikei kana kam nat kamela serei. Kata anla angromai tapai ani kam togtogon si ri aina panik, na kula raung a natnat pukunan i bulumakau ania!’ ");
INSERT INTO lcm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Na tamana kala antok ia ta, ‘Kag nat, kutapo uli ago ve nau, na keve nem aongos ke singig kapo kakam. ");
INSERT INTO lcm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kapo angkoai si maramarak na tara uruk using kana na tasim katala mat, na kana kala to. Kata mun, na taralapo sabonai pok ania.’” ");
INSERT INTO lcm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Au, kala mengen kapa taun kana keve nat i akalit asukang ke. “Mang sikei a igenen tauia katapo togon kana katakai i aiveven. Na kitapo mengen amalangas ia ta kata amun palau kana togtogon. ");
INSERT INTO lcm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Au, kala songo ia na kala sui ia, ‘Au, saka mengen an kana napo longong ia anim? Ku atatai amalangas ta kam abis, using parik kupa anguan katakai i aiveven an.’ ");
INSERT INTO lcm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Na katakai i aiveven ang kala mengen pok ia ta, ‘Naka vil sa, using kag volava kala luk suai ani kirim i aiveven ke pelek iau? Parik napa anguan dual an ani ngal na napo mumurung kapa ani aikut. ");
INSERT INTO lcm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Au io, lenginang nala nas ta sa naka abis ia, ani ri vap ki songo alak iau si kari keve lu man kala luk suai anig si kirim i aiveven.’ ");
INSERT INTO lcm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Au, kala songo siksikei iria kipo atogon kope si kana volava. Na kala sui a ainoai ina asukang ke, ‘Kam kope si kag volava kapo poisan?’ ");
INSERT INTO lcm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Na kala antok ta, ‘100 na kinkintong i rul i elaio.’ Na kala antok ia ta, ‘Ku luk kam buk kana na ku sinong sumasuma na ku salik a 50.’ ");
INSERT INTO lcm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Na kala sui a mang anu, ‘Kam kope kapo poisan?’ Na kala antok ta, ‘100 na bek kon.’ Na kala antok ia ta, ‘Ku luk kam buk kana na ku salik a 80.’ ");
INSERT INTO lcm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Au, volava ang kalapo alatun kana katakai i aiveven vopo bil arikek ang using kapo nas aro luai ani pakangai pok ania. Io, matan vap i kuli rina ke kipo katak aro luai ani matan vap i nei malangas si kari lau i angtunganan ve keve tungaria akorong. ");
INSERT INTO lcm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Napo antok imi, tauia i kuli rina, mi abis tatana asi kami atogon ani tungami, ani man kalapo kamus a tauia ang, mila atogon pangau si vainagoan kapo tokos. ");
INSERT INTO lcm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ninia kapo aiveven atutuman a men lik luai, ka aiveven atutuman kapa na men lava; na ninia kapo bil arikek si aiveven ani men lik luai, ka kun bil arikek si aiveven atutuman kapa ani men lava. ");
INSERT INTO lcm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Asukang vang, man parik mitapa tutuman si aiveven ani kapkap i kuli rina, si nganing lak ka lis imi ta tauia tutuman asi kami aiveven? ");
INSERT INTO lcm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Na man parik mita lapa tutuman si aiveven ani bil si mang anu, si nganing lak ka alis imi ta bil kakami akorong? ");
INSERT INTO lcm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Parik kapa angkoai luai ani igenen ka abis ani pongua na volava. Man rilong angtaunai, ka mirik ani sikei na ka buk a mang anu, vo ka buk alava luai ani mang anu na ka misag luai ani mang anu. Parik mipa angkoai si abis ani God ve kapkap kapa.” ");
INSERT INTO lcm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Au, ri Parisaio, keve katakai i vubuk using ani kapkap, kitapo longong a keve mengen aongos ke, na kilapo amimirikisai ania. ");
INSERT INTO lcm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Na kala antok iria asukang ke, “Nami vanang mipo vil akorong imi mete ri vap, sikei God kapo malangas ta pakangat imi. Using a nem ang ri vap kipo lomon alava ia, kapo mimirikuk si matana i God. ");
INSERT INTO lcm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Buk i saupai na ri katakai i kus amalangas aino kitapo akuskus tung si taun ang a Ioanes kala serei. Na le si taun ang, akus ro i vainagoan si God kalapo pasal, na ri vap aongos kipo angrudualai asi kari palak singina. ");
INSERT INTO lcm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kapo kitmat ani metekuku ve kuli rina si pasal suai, sikei ka sikei a kitmat luai an ani sikei a vuk salsalik lik i buk i saupai asi kana tamus. ");
INSERT INTO lcm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Man a tauan katala kamus si kana aina na kalapo osongon ta mang anu, sukana kapo abis a lau rikek. Na igenen kapo osongon ta aina ila asuai ta kana tauan, sukana kapo lau rikek. ");
INSERT INTO lcm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Au, katapo atogon a mangsikei a igenen tauia, na katapo uli maus ta maus miminaungan na kapo samui lava na katapo uli matan angan aro luai si keve taun aongos. ");
INSERT INTO lcm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Au, e mete papalakan i kana rina kitapo uli amatung ani mangsikei a igenen logo kana asan ta Lasaro, na kapo duk ta makas, ");
INSERT INTO lcm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","na kapo uli lomlomonai alava ta ka saka masung an ta mutep i pok kapo uak le si pata i angan si igenen tauia ang. Na kapa, ri kauvek kipo serei na kipo ramramit kana keve makas. ");
INSERT INTO lcm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Au, igenen logo ang kala mat na ri angelo kila sunguk alak ia asi kana an oros alak e kangina i Abaram. Na igenen tauia ang kapa kala kun mat na kila kun mo ania. ");
INSERT INTO lcm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Na e rina i mat kan lapo ago si vilvil akui kitmat na kala tarak na kala arai ani Abaram e ring vunga na Lasaro e kangina. ");
INSERT INTO lcm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Na kala songosongo, ‘Mamai Abaram, ku ngorem iau. Ku asok a Lasaro asi kana abuluk ani rambeles i piupiu i kungana nei laman na kame alivlivus a kalkalame ig, using nalapo kui arikek nei ureurek ke.’ ");
INSERT INTO lcm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Sikei Abaram kala antok ia, ‘Kag nat, ku lomon akit ia ta taun kutapo sel kam mamain ta bil roron, asukang kapa Lasaro, kana mamain ta bil rikek, sikei kana kimela avaivaip ia e ke, na numai kula kui arikek. ");
INSERT INTO lcm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Au mang anu, nei liuan irung kapo atogon a mata lulungai luai, asi tubat luai ani selen le ke ane iang na le iang ane ke kapa. Parik kapa angkoai si paputuk.’ ");
INSERT INTO lcm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Na kala antok ta, ‘Mamai, man asukang, napo sokotuk ua ani ku asok ia ane si lu si mamai, ");
INSERT INTO lcm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","using napo atogon a palpalima na tasig, asi kana an ngavaka aniria vei kimela kun pasal ane si ring i kui ke.’ ");
INSERT INTO lcm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Na Abaram kala antok ta, ‘Kipo atogon a mengen si ri Moses ve keve katakai i kus amalangas aino, kapo ro ki longong iria.’ ");
INSERT INTO lcm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sikei kala antok ta, ‘Mamai Abaram parik! Sikei man ka atogon igenen i tapasuk pok le si matmat, kila lomon pokai vang.’ ");
INSERT INTO lcm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Na kala antok ta, ‘Parik, man kipo misag ani longong ani mengen si ri Moses ve keve katakai i kus amalangas aino, nambang, parik kipa kun buk longong kapa ani mengen si igenen vo tapasuk pok le si mat.’” ");
INSERT INTO lcm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Na kala antok kana keve nat i akalit, “Keve bil asi tukai, parik kapa angkoai ta ki tav serei. Ki serei, sikei ani iuang kapo asinong ia, ka rikek luai ania. ");
INSERT INTO lcm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kapo ro, ki pala iat maiten e ngona na ki asuai ania nei laman, vei ka asavang a sikei i keve natlik ke. ");
INSERT INTO lcm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mi aiveven aro imi. Man a tungam kapo abis a lau rikek singim, ku tatapokai ania. Na man kala lomon pokai, ku lomon suai ania. ");
INSERT INTO lcm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Man kata amatan limalengua na rikek anim si sikei a mangias, na man kata uli papok ta mengen asukang ke, ‘Nala lomon pokai,’ io, ku lomon suai ania.” ");
INSERT INTO lcm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na keve aposel kila antok a Volava, “Ku vil alava kamem lomlomon!” ");
INSERT INTO lcm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Na Volava kala antok ta, “Man kami lomlomon kapo liklik palau val katui i sinapeo, kala angkoai animi si antok ani sukamino ke ta, ‘Ku tavalak na ku an polok e nei laman,’ na ka longong imi. ");
INSERT INTO lcm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Au na man a mangsikei imi kapo atogon kana asosokai na kapo amo e matang vo kapo aiveven sipsip, na man kamela serei pok le matang, sa nang, ku antok ia ta, ‘Me sumasuma na kume angan’? ");
INSERT INTO lcm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Parik! Kula antok ia asukang ke, ‘Ku itoiton ta kag men pok, na ku itoiton tapai ani pukun im na kume sasagi anig, au na e mung lak kula kun angan.’ ");
INSERT INTO lcm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Au na sa, e mung ku poso aro na asosokai ang using katala longong kam asok? ");
INSERT INTO lcm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Parik. Na asukang nami kapa, man mitala abis a keve nem aongos i la asok ang asi kami abis ania io, mi antok vang ta ‘Namem a keve asosokai rikek palau e matam, sa namemta abis ia nang kapo kamem abis.’” ");
INSERT INTO lcm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Au, kala pasal asi kana palak ane Ierusalem na kalapo paliu si pulis ang nei liuan i Samareia ve Galilaia. ");
INSERT INTO lcm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Au, kanla palak si mangsikei a rina na sangauli na igenen tapak kila arai ania, sikei kitapo tung e ring vunga, ");
INSERT INTO lcm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na kila songosongo alava ta, “Iesu, Volava, ku ngorem imem!” ");
INSERT INTO lcm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Taun kala arai aniria, kala antok iria ta, “Mi pasal na mianla akalit ta pukun imi si ri katakai i sula.” Na si taun ang kila pasal, kian lapo rangrangis e selen. ");
INSERT INTO lcm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Au, mangsikei iria kala arai kinle ta kala to, na kala papok velai ani alatun ani God ta tavirimok i kalingana. ");
INSERT INTO lcm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Na kamela soturungai e ngono kakina i Iesu na kala posong ro singina. Igenen ang kapo igenen i Samareia. ");
INSERT INTO lcm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Na Iesu kala antok ta, “Au, parik mitapa sangauli aongos mitala to pok? Nei a limaleat e voi? ");
INSERT INTO lcm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Marai sa na sokoung ke papalik kamela alatun a God?” ");
INSERT INTO lcm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Au na kala antok ia ta, “Ku tapasuk na ku pasal. Kam lomlomon katala vil ato ua.” ");
INSERT INTO lcm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mangsikei a taun mang keve Parisaio kila sui a Iesu ta angisan vanang a vainagoan si God kamela tutuman. Na kala antok iria asukang ke, “Vainagoan si God parik kapa serei na mi arai ania. ");
INSERT INTO lcm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Parik kipa angkoai si antok ta, ‘Arai, kana vang ninia!’ vo ‘Sukana ninia!’ Using a vainagoan si God kapo ago nei liuan imi.” ");
INSERT INTO lcm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na kala antok kana keve nat i akalit asukang ke, “Ka atogon a taun lak na mi buk alava asi kami arai sumasuma ani taun i serei ang ta igenen i pukun, sikei parik mipa arai ania. ");
INSERT INTO lcm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Na nganing lak ki antok imi ta, ‘Sukana ninia!’ vo ‘Kana ninia!’ Mi tung akit. Mi ago ta sang using an aniria. ");
INSERT INTO lcm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Using a igenen i pukun si kana serei ka bil val tapak kapo takrimit na kapo limang metekuku le mang ngising taun a mang palpal. ");
INSERT INTO lcm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sikei aino ani taun ang, igenen i pukun ka sunguk a keve kui miang na ri polokan i taun ke ki kirikai ania. ");
INSERT INTO lcm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kana taun a igenen i pukun ka asukang val taun i Noa. ");
INSERT INTO lcm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Kitapo angan, kipo inum, kipo angosongon, tung si taun Noa kala riuklak nei perengan na nole kala serei na kala vil punuk suai luai aniria aongos. ");
INSERT INTO lcm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Asukang kapa si taun i Lot. Kitapo angan, kipo inum, kipo samui, kipo atos, kipo sukal, kipo abis lu, ");
INSERT INTO lcm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","tung si taun a Lot kala soung pelek a Sodoma na kut ve at ureurek kala usen le metekuku na ka vil suai luai aniria aongos. ");
INSERT INTO lcm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Io, ka asukang palau si taun ang man a igenen i pukun ka serei e ring malangas singina. ");
INSERT INTO lcm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Si taun ang vanang, ninia kapo ago e komo i lu, ki ago ta lomlomonai an ani kari keve usausan nei lu asi an sunguk tapai aniria. Na asukang kapa ninia kapo ago e matang, ka ago ta papok an. ");
INSERT INTO lcm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mi lomlomonai ani kisngana i Lot! ");
INSERT INTO lcm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Man kupo uli aiveven aro ani kam to, nganlak kula ngau kavis ia. Sikei man kupo tav neikitung ta kam to, nganlak vanang ku teng aro ia. ");
INSERT INTO lcm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Napo antok imi, si tenei vong ang man a pongua na igenen kilongpo rot si sikei a pata, ki luk suai ani mangsikei, na mang anu ang ki atalipai ania. ");
INSERT INTO lcm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Man a pongua na aina kilongpo momong kon, ki luk suai ani mangsikei, na mang anu ang ki atalipai ania.” ");
INSERT INTO lcm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Na kila sui ia, “Volava, e voi vang?” Na kala antok iria ta, “Si oring ang a matmat kapo matung vok singina, ri kol kianpo ngangasinong kuvul e iang.” ");
INSERT INTO lcm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Au na kala alis iria ta kankanuai i mengen asi akalit aniria asi kari uli sokotuk na ki ago ta marangan an. ");
INSERT INTO lcm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Asukang ke. “Si mangsikei a rina katapo atogon a mangsikei a katakai i saupai parik katapa leng ani God na parik kapa lomlomon alava ta ri vap. ");
INSERT INTO lcm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na katapo atogon a mainang nei rina ang katapo uli serei singina ta kana sokotuk asukang ke, ‘Vo petau ang anig kapo buk vil arikek anig. Napo sokotuk ta ku pakangai anig mete saupai.’ ");
INSERT INTO lcm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Si mang matan taun katapo misag. Sikei e mung kala lomlomonai ta, ‘Kantanem napo tav leng ani God na napo tav lomlomon alava ta ri vap kipo laba, ");
INSERT INTO lcm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sikei, using a mainang ke kapo uli amasmasik anig, kapo ro naka pakangai ania vei ka amarengreng iau ta me uli serei!’” ");
INSERT INTO lcm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Na Volava kala antok asukang ke, “Longong a akuskus i katakai i saupai rikek. ");
INSERT INTO lcm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Au kapo sa? God parik kapa pakangai ani kana vap i songo, kipo tangis ia tenei ias na tenei vong? Sa, ka uli amomole? ");
INSERT INTO lcm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Napo antok imi, ka pakangai sumasuma nang aniria. Sikei, man a igenen i pukun ka serei pok, sa? Vei nganing kame arai ani ri vap kipo lomlomon, vo parik?” ");
INSERT INTO lcm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Na kala alis kapa na mang kankanuai i mengen ani vap ang kipo atogon a lomlomonai lava aniria pok ta kipo korong na kipo gelep a mang matan vap ane kevkev luai. ");
INSERT INTO lcm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Asukang ke. Pongua na igenen kilongta palak nei rina i atailai asi an sokotuk. Mangsikei a Parisaio na mangsikei a katakai i luk takis. ");
INSERT INTO lcm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Au, Parisaio kala tapasuk asi kana sokotuk na kala posong aro pok ia asukang ke, “God, napo posong ro ua using parik napa angkoai ve ri vap. Kipo vap tainau, vap katakai i bil arikek na vap putuk osongon, na rikek luai ina kana na katakai i luk takis ke. ");
INSERT INTO lcm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nau napo alal a matan pongua nei sikei a vik, na napo uli alis ta keve vasangauli i kag seupok.” ");
INSERT INTO lcm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Sikei, katakai i luk takis ang kapo tung avunga na kapo mamaila ani tarak ane metekuku na kapo makus alava luai, na kala sokotuk asukang ke, “God, ku ngorem iau. Nau a katakai i bil arikek.” ");
INSERT INTO lcm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Napo antok imi, igenen ke kala papok ane rina, na God kapo kin ia ta igenen korong e matana, na mang anu ang, parik. Io, nia kapo vil alava pok ia, ki vil alik ia, na nia kapo vil alik pok ia, ki sunguk alakat ia. ");
INSERT INTO lcm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Na kimela serei ve kari inatus lik kapa taun ia, ani kame amatung kunga singiria. Na kana keve nat i akalit kila arai ani oring ke na kila ki suak iria. ");
INSERT INTO lcm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Sikei Iesu kala songo iria ane singina na kala antok, “Mi lomon suai ani ri nat lik ane singig. Ago ta atakun an aniria, using a matan vap val riria, kakaria na sinsinong si kana vainagoan a God. ");
INSERT INTO lcm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Napo mengen atutuman imi ta man a sikei parik kapa ainak val nat lik ani songo ang si God asi kana palak si kana vainagoan, parik luai kapa palak.” ");
INSERT INTO lcm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Na mangsikei a ainoinoai kala sui ia ta, “Katakai i akalit ro, sa naka vil ia ani kakag a to asikei?” ");
INSERT INTO lcm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Na Iesu kala atai ia ta, “Sa tukulai ina na kupo kin iau ta napo ro? Using God papalik nia kapo ro. ");
INSERT INTO lcm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kupo malangas a keve asok tapai ang ta Ku ago ta putuk osongon an, ku ago ta daung an, ku ago ta ainau an, ku ago ta posposo kapau an mete saupai, ku mamaila aro ani tamam ve rinam.” ");
INSERT INTO lcm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na kala antok ta, “Riria aongos nata using arukup iria le si taun natapo liklik lak tung kana.” ");
INSERT INTO lcm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Na Iesu kala longong ia na kala antok ia ta, “Mangsikei a bil lak kupo inongos asi kam abis ania asukang ke. Ku atos ta kam keve togtogon, na ku alis ani ri vap logo, ani kakam a togtogon roron metekuku. Na kume using iau.” ");
INSERT INTO lcm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Taun kala longong a mengen ang na kalapo mamakus, using kapo igenen tauia luai. ");
INSERT INTO lcm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Na Iesu kala tun ia na kala antok, “Vola kitmat luai ani igenen tauia asi kana palak nei kana vainagoan a God. ");
INSERT INTO lcm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Arai, palak ang si igenen tauia ane nei vainagoan ang si God, ka kitmat luai ani papalakan si kamel nei malang i sangum.” ");
INSERT INTO lcm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Na vap po longong ang ani mengen ke kila sui, “Au, man asukang, si kala sapang?” ");
INSERT INTO lcm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Au na kala antok ta, “Man kapo kitmat ani ri vap, sikei God, kapo remrem palau ania.” ");
INSERT INTO lcm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Na Petero kala antok ta, “Arai, namem namemtala papelek kamem keve lu asi kamem using anim.” ");
INSERT INTO lcm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Na kala antok iria ta, “Napo antok atutuman imi. Man a si ka pasal suai ani kana lu, na kisngana, na keve tasina na tamana ve rinana na kana inatus kapa, using a vainagoan si God, ");
INSERT INTO lcm_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","io tutuman luai, si to ke ka luk lak a seupok kapo tavirimok ani keve nem ang katala papelek ia. Na si taun e mung, ka teng a to asikei.” ");
INSERT INTO lcm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Au, kala songo na sangauli na pongua na nat na kala antok iria, “Arai, taralapo palak vang ane Ierusalem, na keve mengen aongos ang ri katakai i kus amalangas kita salik ia ani igenen i pukun ka serei atutuman. ");
INSERT INTO lcm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ki alis ia e kungaria i ri vap i ngising na ki kurek ia, ki nau varas ia, ki kanus ia, ");
INSERT INTO lcm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ki sasaup ia na kian vil punuk ia. Na si vapotol i taun ka tadut pok.” ");
INSERT INTO lcm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Na parik kitapa malangas a keve mengen ke. Supsupai ina katapo ago mumun aniria na parik kitapa nas a sa kapo mengen tatana. ");
INSERT INTO lcm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Au, kan lapo serei angasungai i Ieriko na mangsikei a igenen mata ba katapo sinong ngere selen na katapo aikut papakangai. ");
INSERT INTO lcm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Na kala longong a petau lava sipo paliu na kala sui ta, “Sa nang?” ");
INSERT INTO lcm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na kila antok ia ta Iesu le Nasaret nang kapo paliu. ");
INSERT INTO lcm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Na kala songosongo, “Iesu, nat i David, ku ngorem iau!” ");
INSERT INTO lcm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Na vap po pasal aino ang kila atakun ia ani ka ago ta mengen an. Sikei kala songosongo alava luai ta, “Nat i David, ku ngorem iau!” ");
INSERT INTO lcm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Na Iesu kamela tung na kala asok asi songo ania ane singina. Na kamela pasal asung na kala sui ia ta, ");
INSERT INTO lcm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Au, kupo buk ani naka vil sa anim?” Na kala antok ta, “Volava, napo buk asi kag mata arai.” ");
INSERT INTO lcm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Na Iesu kala antok ia ta, “Kana vang kula ararai. Kam lomlomon katala vil ato ua.” ");
INSERT INTO lcm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Akorong palau na kala ararai aro na kalapo using ia velai ani alatun ani God. Ri vap aongos kila arai ani bil ke na kila alatun a God. ");
INSERT INTO lcm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Na kala palak e Ieriko na kalapo paliu e nei rina. ");
INSERT INTO lcm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Au, mangsikei a igenen kana asan ta Sakaio, kapo mangsikei a tulava i ri katakai i luk takis na kapo igenen tauia, ");
INSERT INTO lcm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","katapo buk arai ta Iesu kapo saka igenen an na parik katapa angkoai using ri vap kipo duk, na using kapo igenen kudik. ");
INSERT INTO lcm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Asukang na kala sang e no na kala lak kuli ei asi kana arai man a Iesu ka paliu si selen ang. ");
INSERT INTO lcm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na Iesu kala serei e oring ang na kala tarak na kala antok ia, “Sakaio, ku kiksiang sumasuma palau. Using kapo mamaiten ta nakan sinong si kam lu kana.” ");
INSERT INTO lcm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Na sumasuma palau kala kiksiang na kala songo alak ia nei lu velai ani uruk. ");
INSERT INTO lcm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Taun kila arai ania, kila mengen lilimukai ania ta, “Kala paliu asi kana an ago nei lu si igenen vo katakai i bil arikek.” ");
INSERT INTO lcm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Na Sakaio kala tung na kala antok a Volava, “Arai Volava, kana naka lis suai ani inongos lava i kag togtogon si mamain ta logo, na man natala luk akole ta bil si sikei, naka ngenget a matan puat.” ");
INSERT INTO lcm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Na Iesu kala antok ia, “Kana anginang a vap i nei lu ke kila sapang, using a igenen ke kapa kapo nat i Abaram. ");
INSERT INTO lcm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Using a igenen i pukun kata serei asi kana me gule na kame asapang iria kitala mun.” ");
INSERT INTO lcm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Si vuk taun kipo kokolongong lak, kala siken mengen luai an ta kankanuai i mengen, using kata lapo angasungai ani Ierusalem na ri vap kilapo sekpat ani nia ka tulava na asukang a vainagoan si God ka serei sumasuma. ");
INSERT INTO lcm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Asukang na kala akus, “Mangsikei a igenen lava si patvap si ri tulava kata usausa asi kana pasal ane ring vunga ani kian atung ia val tulava le na kame papok. ");
INSERT INTO lcm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Na kala songo na sangauli i kana keve asosokai na kala pagal iria ta sangauli na mina. Na kala antok iria, ‘Mi apolokai ani kapkap ke tung si naka serei pok.’ ");
INSERT INTO lcm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sikei ri vap i kana rina kitapo kilis ia na kila asok a mang matan asi kari using ania velai ani mengen ke ta, ‘Parik tarapa buk a igenen ke ka tulava anira.’ ");
INSERT INTO lcm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Sikei kanla serei tulava na kamela papok ane rina. Na kala asok tapai ani vap ang kata pagal iria ta kapkap using kapo buk malangas ta kitala saka abis an tatana. ");
INSERT INTO lcm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na ainoai kala serei na kala antok ta, ‘Volava, natala abis aserei ani mang sangauli na mina le si sa kuta alis ia.’ ");
INSERT INTO lcm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Au, kala antok ia ta, ‘Kutala abis aro luai, kag asosokai ro! Kana using kutala atutuman si abis lik palau, ku saupai ani sangauli na rina aongos.’ ");
INSERT INTO lcm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Na vapongua kala serei na kala antok ia, ‘Volava, natala abis aserei a mang palpalima le si sa kuta alis ia.’ ");
INSERT INTO lcm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Au na kala antok ia ta, ‘Kana kula saupai ani palpalima na rina aongos.’ ");
INSERT INTO lcm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Au na mangsikei kamela serei na kala antok, ‘Volava, arai kana kam sikei a mina natala pakut aro ia ta vuk vakup na nala asinong akipai ania ");
INSERT INTO lcm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","using natapo leng anim. Napo nas ua ta kupo igenen kitmat. Kupo nas ani luk ani bil numai parik kutapa asinong ia na kupo nas ani rok ani bil numai parik kutapa sukal ia.’ ");
INSERT INTO lcm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Na kala antok ia, ‘Kana naka saupai anim lakat si kam keve mengen, numai a asosokai rikek luai! Kutapo malangas ingko ta nau a igenen kitmat, na napo luk a bil parik natapa asinong ia, na napo rok a bil parik natapa sukal ia? ");
INSERT INTO lcm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Using a sa parik kutapa asinong kag kapkap si ring ang kipo apolok kapkap singina ani man name lapo papok nalapo luk akuvul ia ve mang keve kapkap ila apolokai?’ ");
INSERT INTO lcm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Na kala asok a vap ang kitapo tung angasungai, ‘Mi luk pakang ia ta kana mina na mi alis ia si vopo atogon ani sangauli ang.’ ");
INSERT INTO lcm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Na kila antok ia, ‘Volava, lenginang kalapo atogon kana sangauli na mina!’ ");
INSERT INTO lcm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Na kala antok, ‘Napo antok imi ta man a si kapo atogon, ki ngaupap ia, na man a si kapo atogon men lik, io, men lik ang kapo atogon ia, ki luk suai vang ania. ");
INSERT INTO lcm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Sikei kana na vap po kilis ke anig na parik kitapa ainak asi kag tung tulava aniria, mi songo iria ane ke asi me raung aniria e matag.’” ");
INSERT INTO lcm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Au, e mung i mengen ke, kala pasal aino asi kana an palak luai ane Ierusalem. ");
INSERT INTO lcm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Na kanlapo serei angasungai ani Betpage na Betania, ngere mulang ang kipo kin ia ta Elaio, na kala asok a pongua i kana keve nat i akalit ");
INSERT INTO lcm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ta mengen asukang ke, “Milong pasal taun a rina suke e no, na man milonganla palak nei rina ang, milong sabonai ani dongki tanginang kita pala ia, parik lak ta mang anu katapa kokos singina. Milong kunis ia na milong tak ia ane ke. ");
INSERT INTO lcm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Man a sikei ka sui imilong ta using a sa milongpo kunis ia, milong antok ia asukang ke, ‘Volava kapo inongos taun ia.’” ");
INSERT INTO lcm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Na kilongla pasal asukang val asok ang na kilong anla sabonai akorong ani sa kata mengen irilong tatana. ");
INSERT INTO lcm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Si vuk taun kilongpo kunis a dongki ang vap po tauk ina kila sui irilong, “Using a sa milongpo kunis a dongki ang?” ");
INSERT INTO lcm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na kilongla antok, “Volava kapo inongos taun ia.” ");
INSERT INTO lcm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Na kilongla tak ia ane si Iesu. Na kila veles kari keve vakup ipo apupung kuluna na kila akos a Iesu kuluna. ");
INSERT INTO lcm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Taun ang kapo palak e selen na kilapo veleveles kari keve vakup ipo apupung e selen. ");
INSERT INTO lcm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na si taun ang kanla serei si selen ang kapo kiksiangan pelek a Mulang i Elaio, petau duk i kana keve vap i akalit kila tutapongai alatun ani God ta keve kalingaria e pangkul si keve abis i vilvil ataping kitala arai ania. ");
INSERT INTO lcm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ki songosongo asukang ke, “Atautauia ane si tulava vo serei ke si asan i Volava! Luai e metekuku na amaumausan ane pangkul luai!” ");
INSERT INTO lcm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Na mang matan i ri Parisaio nei liuan i petau ang kila antok a Iesu, “Katakai i akalit, ku atakun kam petau.” ");
INSERT INTO lcm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Na kala antok iria ta, “Napo antok imi ta man riria ki ago musik, mamain ta iat ki songosongo aserei.” ");
INSERT INTO lcm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Si taun kan lapo angasungai na kala arai ani rina na kala tangis ia ");
INSERT INTO lcm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","velai ani mengen asukang ke, “Man kutala nas si taun ke, io numai, man kutala nas a sa kapo angkoai si amatung ani luai anim, vola ro! Sikei kana, parik kulapa angkoai si arai ania. ");
INSERT INTO lcm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Io, ka atogon a taun lak ka serei anim na kam vap ipo marala anim ki asinong vonot aulitai anim na ki aolemai anim si keve palpal aongos. ");
INSERT INTO lcm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ki asaul pokai anim ane vunep, ve keve vap kipo ago neim. Parik kipa atalipai ani kam keve lu roron i ngoto, ka tagalang aongos. Using parik kutapa arai kinle ani vuk taun God kata serei singim.” ");
INSERT INTO lcm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Na kala palak nei rina i atailai na kalapo lu asoung a vap po atos ang, ");
INSERT INTO lcm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","velai ani antok aniria ta, “Kitala salik ia ta Kag lu kapo lu asi sokotuk, sikei milapo pokai ania asi kana bil val vakil si ri vap tainau.” ");
INSERT INTO lcm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Na keve taun aongos kanpo akalkalit nei rina i atailai. Sikei ri ainoinoai si ri katakai i sula na ri vap malangas ani saupai na keve ainoinoai si ri vap kitapo atokngai asi raung suai ania. ");
INSERT INTO lcm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Na parik kitapa sabonai ta selen asi kari abis ania using ri vap aongos kitapo angkamai asi kolongong ani kana mengen. ");
INSERT INTO lcm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mangsikei a taun katapo akalkalit ri vap nei rina i atailai na kapo apasa iria ta akus ro, na ri ainoinoai si ri katakai i sula na ri vap malangas ani saupai na ri vap lava kimela serei singina, ");
INSERT INTO lcm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","na kila sui ia ta, “Ku antok imem ta si saka ro an kana kupo abis a keve abis ke. Si akorong nang kata alis ua ta ro ke?” ");
INSERT INTO lcm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na kala ngenget iria asukang ke, “Nau kapa naka kun sui animi ta mangsikei a susui. Mi ngenget iau. ");
INSERT INTO lcm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ioanes si kana asing tauia, kata luk a ro ang le metekuku vo le si ri vap?” ");
INSERT INTO lcm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Na kilapo angmemengenai ta, “Man tara antok ta le metekuku, kala sui ira ta sa tukulai ina parik taratapa lomlomon tatana. ");
INSERT INTO lcm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sikei man tara antok ta le si ri vap, ri vap aongos ki li punuk ira ta iat, using kipo lomlomon akit ta Ioanes katapo mangsikei a katakai i kus amalangas.” ");
INSERT INTO lcm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Na kila ngenget ia ta parik kipa nas ta le voi. ");
INSERT INTO lcm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Na Iesu kala antok iria, “Nau kapa, parik napa kun antok animi ta saka ro an kana napo abis a keve abis ke tatana.” ");
INSERT INTO lcm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Na kala mengen ri vap ta kankanuai i mengen ke. “Mangsikei a igenen kata sukal kana matang vaen na kala alis tapai ania si mang keve vap aiveven matang, na kala pasal akipai ane si mang rina asi an ago ani taun vunga. ");
INSERT INTO lcm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Si vuk taun asi kopkopos kala asok a mang asosokai taun a vap po aiveven matang ang asi kari alis ania ta mang matan uai i matang ang. Sikei keve vap aiveven matang ang kianla vis ia na kila asok suai palau pok ania ta kunga vauvau. ");
INSERT INTO lcm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Na kala asok a mang asosokai kapa sikei kianla vis ia kapa na ki vil amese ia na ki asok suai palau pok ania ta kunga vauvau. ");
INSERT INTO lcm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Au na kala asok a vapotol, na kianla ngapolok kapa ia na ki asuai akipai ania. ");
INSERT INTO lcm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Na vo tauk i matang vaen ang kala antok, ‘Saka nem an naka abis ia? Kapo ro si naka asok kag nat ipo buk ang. Vei nganing ki mamaila ania.’ ");
INSERT INTO lcm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sikei, si vuk taun a keve vap aiveven matang ang kila arai ania na kila antokai, ‘Arai, ta votauk i togtogon iles. Tara me vil punuk ia, ani kakara na togtogon ang!’ ");
INSERT INTO lcm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Au kila asuai akipai ania pelek a matang ang na kianla raung ia. Au si vo tauk i matang vaen ang ka abis sa singiria? ");
INSERT INTO lcm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ka serei na ka vil punuk suai luai ani keve vap po aiveven matang ang na ka alis a matang ang si mang vap petekai.” Si vuk taun ang kila longong a akuskus ang, kila antok ta, “Loi, ka ago na bil rikek asukang.” ");
INSERT INTO lcm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sikei, kala tun iria na kala antok, “Au? Na nei a supsupai vang kana i mengen ke kita salik ia? Iat ke ri katakai i abis lu kita kilis ia, kana kala serei a iat talupus luai. ");
INSERT INTO lcm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Man a ri si ki uak kuli iat ang ki tagalang amitmitngai lik, sikei man a iat ang ka uak taunai ani si, ka tatameng aongos luai.” ");
INSERT INTO lcm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Na keve vap malangas ani saupai ve keve ainoinoai si ri katakai i sula kilapo gule selen asi teng akit sumasuma ania using kilapo nas ta kapo kankanuai i mengen aniria. Sikei kipo leng vei ri vap. ");
INSERT INTO lcm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kila ararai asung luai ania na kila asok a mang matan vap asi kapau ania. Vap po kapau ang ta kipo buk longong ani kana mengen. Kitapo buk teng akit ania si saka mengen an ka posong ia na ki alis ia e kungana i tulava kitmat ani ka saupai ania. ");
INSERT INTO lcm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Au, kila sui ia, “Katakai i akalit, namempo malangas ta kam mengen na kam akalit kapo korong na kam mengen kapo angkokoai si ri vap aongos, na kupo akalit atutuman ta selen si God. ");
INSERT INTO lcm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Au sa, kapo korong ani tara samui takis ane si Kaisar vo parik?” ");
INSERT INTO lcm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sikei kala kinle kari kapau na kala antok iria, ");
INSERT INTO lcm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kotok, mi akalit iau ta sikei a ring kapkap. Nona i si kana, na asan i si kana singina?” Na kila ngenget ta, “Ke Kaisar.” ");
INSERT INTO lcm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Na kala antok iria, “Mi alis a Kaisar ta sa ke Kaisar, na mi alis a God ta sa ke God.” ");
INSERT INTO lcm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Asukang a parik kilapa angkoai si apupu ania si kana mengen mete ri vap. Kila taping ani kana mengen i polpol aniria na kila ago bot. ");
INSERT INTO lcm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Au, mang matan i ri Sadukaio, vap ang kipo agel suai ani tadut pok, kimela serei singina ");
INSERT INTO lcm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","na kila sui ia ta, “Katakai i akalit, Moses kata salik ia anira ta man a igenen ka mat pelek kana aina kovek i inatus, tasina ka osongon pok ia asi kana aumata nat ani tasina. ");
INSERT INTO lcm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Au, katapo atogon a limalengua na angtasimal. Anu tuan kata osongon ta mang aina na kala mat pelek ia kovek i nat. ");
INSERT INTO lcm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Asukang si anu tasin, ");
INSERT INTO lcm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","na e mung vapotol kala kun osongon ania, na asukang limalengua aongos kila mat na kapo kovek i inatus. ");
INSERT INTO lcm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","E mung, aina ang kala kun mat kapa. ");
INSERT INTO lcm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Si taun i tadut pok, ke si iria ta aina ke? Using a limalengua na angtasimal kita osongon tatana.” ");
INSERT INTO lcm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Na Iesu kala antok iria, “Ri vap i taun ke kipo angosongon, ");
INSERT INTO lcm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","sikei ani vap ang voiang kipo ro angkokoai si palak si to e mung na ki tapasuk pok pelek a mat, parik kipa angosongon, parik. ");
INSERT INTO lcm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Using parik kipa angkoai si anguan mat an using kila asukang ta ri angelo, na kipo inatus si God si kari to pok pelek ani mat. ");
INSERT INTO lcm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Sikei Moses akorong kata akalit ta ri vap mat ki tapasuk pok. Si taun a ei ang kata ni, kata kin a Volava ta God si Abaram, na God si Isak, na God si Iakov. ");
INSERT INTO lcm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Parik ta God si ri vap mat, sikei kakaria kipo to, using singina tarapo to aongos.” ");
INSERT INTO lcm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Na mang matan i ri vap malangas ani saupai kila antok, “Katakai i akalit, kupo mengen aro luai!” ");
INSERT INTO lcm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Using kilapo lolokovo luai ani sui ania ta mangsikei a susui. ");
INSERT INTO lcm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Na kala antok iria, “Kapo saka bil an na ri vap kipo kin a igenen i akanangai ta nat i David? ");
INSERT INTO lcm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Using a David akorong kata posong nei Buk i Tangam asukang ke, Volava kata antok kag Volava ta ku sinong si palso ig, ");
INSERT INTO lcm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tung si naka vil a vap po petau ang anim asi kari ago neite ngono kakim. ");
INSERT INTO lcm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David sukana kapo kin ia ta Volava. Asukang a kapo saka angkoai an si kin ania ta kapo nat ina?” ");
INSERT INTO lcm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Si kokolongong si ri vap aongos, kala mengen taun kana keve nat i akalit asukang ke, ");
INSERT INTO lcm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mi aiveven si ri vap malangas ani saupai. Kipo buk pasal pulakai ta maus roron na kipo buk ri vap ki posong aro singiria nei keve ring i atos, na kipo pigpig ta keve sinsinong lava nei lu i kivung na keve oring mamailan si keve matan angan. ");
INSERT INTO lcm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kipo nas ani tainau ani keve lu si ri mainang, na kipo kapau ta posong ani keve sokotuk vungavunga. Matan vap asukang, kari amiming ka tavirimok luai.” ");
INSERT INTO lcm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na kala tapuk sarak na kala arai ani ri vap tauia kipo asiang kari keve alilis nei asisiang ipo asia kapkap. ");
INSERT INTO lcm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Na kala arai kapa ani mangsikei a mainang logo kamela asiang kana pongua na vuk kapkap lik. ");
INSERT INTO lcm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na kala antok, “Napo antok atutuman imi, kana na mainang vopo logo ke katala asiang alava luai aniria aongos, ");
INSERT INTO lcm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","using riria kitala luk tapong le si kari togtogon i kari tauia na kila alis, sikei ninia, le si kana logo luai, katala alis asip ta sa katapo angkoai si kana to aongos.” ");
INSERT INTO lcm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Na mang matan kila arai ani masro i ri iat ve keve alilis ro kita ngoto na rina i atailai tatana na kilapo angmemengenai tatana. Na kala antok, ");
INSERT INTO lcm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Sa mipo arai ania kana, ka serei lak a taun na ka kovek luai i ngoto roron. Kime galang aongos ia.” ");
INSERT INTO lcm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Na kila sui ia, “Katakai i akalit, angisan a keve bil ke ki serei? Na saka akanangai an i taun i kari serei?” ");
INSERT INTO lcm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Na kala antok, “Mi aiveven vei ki kapau imi. Using a vap miang ki serei na ki posong pok iria ta asan ig na ki antok ta, ‘Nau kana ninia’ na ‘Kala angasungai a taun.’ Mi ago ta using an aniria. ");
INSERT INTO lcm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Na man mi longong ta kalapo togon visvis na keve angpipisuai, mi ago ta leng an, using a keve bil ke ki serei aino, sikei akamusai ina parik kapa serei sumasuma palau.” ");
INSERT INTO lcm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na kala mengen aliu iria ta, “Mang palpal vap ka tapasuk na ka angvis ve mang palpal vap, na mang vainagoan ka angvis ve mang vainagoan. ");
INSERT INTO lcm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ka togon a keve mimo lava, na keve mol lava, na keve matan malepen rikek si keve ring anglok, na keve aleleng na keve akanangai lava le metekuku. ");
INSERT INTO lcm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Sikei aino tapai ani keve bil ke, ki teng akit imi na ki vil akui imi na ki alis imi mete saupai nei keve lu i kivung na ki alakai animi nei keve lu i akangbat, na ki tak imi taun a keve tulava na keve ainoinoai marai asan ig. ");
INSERT INTO lcm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sukana ka ali pangau animi asi kami akuskus amalangas e mataria. ");
INSERT INTO lcm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Asukang na mi lomlomonai aro ta mi ago ta itoiton aino animi ta mi saka ngenget an aniria. ");
INSERT INTO lcm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Using nau naka alis imi ta mengen na masam. Asukang na vap aongos ipo marala ang animi ki tav angkoai luai si susual vo sual pok animi. ");
INSERT INTO lcm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sikei, rikek luai ina, keve tamami ve keve rinami, keve tasimi, kami matan vap ve keve tungami ki alis imi ane singiria na ki vil punuk a mang matan imi. ");
INSERT INTO lcm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na ri vap aongos ki mirik animi marai asan ig. ");
INSERT INTO lcm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sikei ka kovek ta mangsikei a ung i patumi ka mun. ");
INSERT INTO lcm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kami tung akit ka vil ato imi. ");
INSERT INTO lcm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Au na man mi arai ani keve kuvkuvulan i katakai i visvis kilapo aulitai ani Ierusalem, mila nas ta taun kala angasungai asi goeng ania. ");
INSERT INTO lcm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Si taun ang, ria kipo ago e Iudaia kapo ro ki sip taun a keve mulang, na ria kipo ago nei rina ki soung suai, na ria kipo ago e komo ki ago ta palak an. ");
INSERT INTO lcm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Using nganlak kalapo taun i ngatat asi vil apunuk ani keve mengen ang kitala salik ia. ");
INSERT INTO lcm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pua ta ri aina vinga na riria kipo atutus popo si taun ang! Using ka tavirimok luai a keve mamaiten kuli rina na marala kitmat ka meng a matan vap ke. ");
INSERT INTO lcm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Mang matan ki puka si samele i daung, na mang matan ki tak iria taun a mamain ta palpal vap aongos na kian ago si vilvil akui singiria. Na ri vap i ngising ki saksakai e Ierusalem tung si kakaria ta kun taun i maramarak kan kun kamus. ");
INSERT INTO lcm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Na keve akanangai ki serei mete makarap, ulen na mamain ta kalto. Na e kuli rina a mamain ta palpal vap ki vinga urui na ki angpipisuai si pungas i to tavirimok luai nei laman. ");
INSERT INTO lcm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ri vap ki nagat ta leng lava luai using a keve bil ang kipo serei kuli rina, using a keve kitmat i metekuku ka mimo. ");
INSERT INTO lcm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na si taun ang ki arai ani igenen i pukun ka serei nei kuku ta kitmat na maumausan tavirimok. ");
INSERT INTO lcm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Io, man a keve nem ke ki tutapongai serei, mi tadut na mi tapuk sarak using a taun i samui apok ang animi kala angasungai.” ");
INSERT INTO lcm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Na kala alis iria ta kankanuai i mengen asukang ke. “Mi tere ta ri suke kuvul ve mamain ta ei aongos. ");
INSERT INTO lcm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Man kila urung atanginang, mila arai kinle na mila malangas ta taun sinang roron kala serei. ");
INSERT INTO lcm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na asukang kapa singimi, man mila arai ani keve nem ke kala serei, mila malangas ta vainagoan si God kala angasungai. ");
INSERT INTO lcm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Napo antok atutuman imi, kana na matan polpolokan i taun ke parik kipa mat suai aino ani keve bil ke kila serei. ");
INSERT INTO lcm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Metekuku na kuli rina ka tamus suai, sikei kag mengen parik kapa angkoai luai si tamus. ");
INSERT INTO lcm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Mi aiveven vei nganing a vingami ka maiten si laulauan nio i inum na lomon rikek using ani keve bil i to ke, na asukang a taun ang ka serei ataping imi val liliangus. ");
INSERT INTO lcm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Io, using ka serei taun iria aongos kipo to kuli rina ke. ");
INSERT INTO lcm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Sikei mi uli ago i ararai velai ani sokotuk asi kami angkoai si sip akipai ani keve bil ang kilapo angasungai asi serei, na ka koi imi asi tung mete igenen i pukun.” ");
INSERT INTO lcm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Si taun ke kapo akalkalit nei rina i atailai si keve tenei ias, sikei si keve tenei vong kanpo palak tan ago kuli mulang ang kipo kin ia ta Elaio. ");
INSERT INTO lcm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Na tenei vauk lik ri vap aongos kipo tapasuk na ki palak taun ia nei rina i atailai asi kari an kolongong ania. ");
INSERT INTO lcm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Au, kala angasungai a matan angan i saui i tav tol, kipo kin ia Liuluai. ");
INSERT INTO lcm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Na ri ainoinoai si ri katakai i sula na ri vap malangas ani saupai kilapo gusgus selen asi vil punuk ania, using kitapo leng ani ri vap. ");
INSERT INTO lcm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Na Satan kala aol a Iudas kipo kin ia ta Iskariot nia kapo mang sikei i 12 na nat ang. ");
INSERT INTO lcm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Na kala pasal taun a keve tulava i ri katakai i sula ve kari vap po ararai bat na kianla angmemengenai ta selen asi kana alis suai ania e kungaria. ");
INSERT INTO lcm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Na kila uruk na kila lomlomonai kuvul asi kari seu ania ta kapkap. ");
INSERT INTO lcm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Na kala ainak ani seupok ang na kalapo gusgus ta saka pangau an kapo kalakala si alis suai ania e kungaria, man kapo kovek i vap miang. ");
INSERT INTO lcm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Au na ainoai i taun i saui i tav tol kala serei. Taun ang kapo taun asi raung ani nat i sipsip i Liuluai. ");
INSERT INTO lcm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Asukang a Iesu kala asok ri Petero ve Ioanes ta mengen ke, “Milong pasal na milong an itoitonai ani Liuluai anira asi kara an angan.” ");
INSERT INTO lcm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Na kilongla sui ia, “Kupo buk ani namemlong itoiton ia e voi?” ");
INSERT INTO lcm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Na kala antok irilong ta, “Arai, milongan palak nei rina na mangsikei a igenen kapo sunguk kana ese laman ka duai imilong. Milong using ia ane si lu ang ka palak singina, ");
INSERT INTO lcm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","na milongan mengen a vo tauk i lu ang asukang ke, ‘Katakai i akalit kata asok asi me sui anim ta nei a palpal lu ang ani ri sokoung ani namem ve kag keve nat i akalit, namem me teng a Liuluai singina.’ ");
INSERT INTO lcm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ka akalit imilong ta palpal lu lava e pangkul kalapo ago usausa asi ago. E iang milong itoiton ia.” ");
INSERT INTO lcm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Au kilongla pasal na kilonganla sabonai ani keve nem ang val kata mengen irilong tatana. Na kilonganla itoiton a Liuluai. ");
INSERT INTO lcm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Au, vuk taun ang kala serei na ninia ve keve aposel kilapo sinong si pata i angan, ");
INSERT INTO lcm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","na kala antok iria, “Natapo uli lomlomonai alava asi teng ani Liuluai ke kuvul ve nami aino ani naka kui, ");
INSERT INTO lcm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","using napo antok imi ta parik napa anguan teng an ania tung si supsupai ina kan serei atutuman si kana vainagoan a God.” ");
INSERT INTO lcm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Na kala luk a kavi, ka posong ro na kala antok, “Mi luk ia na mi angainumai tatana, ");
INSERT INTO lcm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","using napo antok imi ta parik napa anguan inum an si laman i vaen le kana tung si kana vainagoan a God ka serei.” ");
INSERT INTO lcm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na kala luk a saui, ka posong ro, ka tevek ia na kala alis iria velai ani mengen ke, “Kana na pukun ig, napo alis ia animi. Mi uli angan ania asukang ke asi kami nanauai anig.” ");
INSERT INTO lcm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Na asukang kapa si kavi ang e mung i kari la angan, na kala antok, “Kana na laman ke natala lingai animi tatana, ninia na palatung tanginang si rangai ig. ");
INSERT INTO lcm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Sikei mi arai, kungana i vo an alis suai anig kana kuvul ve nau si pata i angan ke. ");
INSERT INTO lcm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Using a igenen i pukun ka puka val lomlomonai ang kalapo matung, sikei ka rikek luai ani vo alis suai ang ania!” ");
INSERT INTO lcm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Na kila sui angpokpokai aniria ta si iria nganing kan abis ia. ");
INSERT INTO lcm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Na kilapo anggegelai nei liuan iria ta si iria kapo taviri. ");
INSERT INTO lcm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Na kala antok iria, “Mamain ta tulava si ri vap i ngising kipo lomon alava kari kitmat asi saupai amadot ani kari vap na kipo posong pok iria ta kipo vap papakangai. ");
INSERT INTO lcm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sikei nami, parik kapa asukang singimi. Ninia kapo taviri luai imi, ka auak ia ani ka serei val nat lik. Na ninia kapo ainoinoai, ka asukang val asosokai. ");
INSERT INTO lcm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Arai, si vanang kapo taviri luai? Vopo sinong si pata i angan, o asosokai vopo asinong pok? Sa, parik ta nia vopo sinong si pata i angan? Io. Sikei nau napo ago nei liuan imi val asosokai animi. ");
INSERT INTO lcm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Na nami vanang mitala tung ngereg si kag keve atoktokngai. ");
INSERT INTO lcm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Asukang val mamai katala alis iau ta ro asi saupai ani kag vainagoan, nau kapa nala alis imi ta ro ");
INSERT INTO lcm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","asi kami angan na inum si kag pata i angan si kag vainagoan, na mi an sinong lak si keve sinsinong i tulava asi kami saupai ani 12 na patvap i Israel. ");
INSERT INTO lcm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Numai Simon, ku arai. Satan katala aikut asi kana galgal animi val kon. ");
INSERT INTO lcm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Sikei nau natala sokotuk anim ani kam lomlomon ka ago ta ngau an. Na numai, man kula ulpokai, ku akikitan a keve tasim.” ");
INSERT INTO lcm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Na kala antok ia ta, “Volava, kana napo usausa asi kag auai ve numai si lu i akangbat na si matmat kapa.” ");
INSERT INTO lcm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Na kala antok ta, “Napo antok ua Petero, aino le ani pura ka tirtiriku nganinglak, ku amatan potol a agel ta parik kupa nas iau.” ");
INSERT INTO lcm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Na kala sui iria, “Si taun nata asok imi kovek i paus na asisiang na pauk i kak, parik mitapa inongos taun a mang bil ingko?” Na kila antok ta, “Io, kapo kovek.” ");
INSERT INTO lcm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na kala antok iria, “Sikei kana vang, si imi kapo atogon paus, ka luk ia. Asukang kapa si asisiang. Na man a si imi parik kapa atogon samele ipo daung, ka atos ta kana vakup ipo apung na ka samui ta kana samele. ");
INSERT INTO lcm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Using napo antok imi ta mengen ke kitala salik ia anig, kana ki abis apunuk ia ta, Kitala taot kuvul ia ve ri katakai i putuk saupai. Io, kana na mengen ke kita salik ia anig, kalapo serei atapunuk aliu.” ");
INSERT INTO lcm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na kila antok ia, “Arai Volava, kana na pongua na samele ipo daung.” Na kala antok iria ta, “Kala angkoai!” ");
INSERT INTO lcm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na kala soung na kala paliu ane si Mulang Elaio val kana lau. Na kana keve nat kila auai ve nia. ");
INSERT INTO lcm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Au, kianla serei si oring ang na kala antok iria, “Mi ago i sokotuk vei atoktokngai ka luk imi.” ");
INSERT INTO lcm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na kala papelek iria ane ring vunga lik na kanla sovusulai na kala sokotuk ");
INSERT INTO lcm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","asukang ke, “Mamai, man kapo ro singim, ku luk suai ani kavi ke pelek iau. Sikei vubuk ke singig ka ago, sikei ku using kam vubuk.” ");
INSERT INTO lcm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Na mangsikei a angelo le metekuku kamela serei na kala ali dual ania. ");
INSERT INTO lcm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Katapo aunai i kui alava na kapo sokotuk amadot. Gese ina kapo tuluk asiang val rangai ane vunep. ");
INSERT INTO lcm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Au, kala tapasuk le si sokotuk na kanla serei pok si keve nat ang kilapo rot using kipo mamakus alava. ");
INSERT INTO lcm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na kala antok iria, “Mipo rot sa? Mi tapasuk na mi sokotuk, vei atoktokngai ka luk imi.” ");
INSERT INTO lcm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Au, vuk taun ang kapo mengen lak, petau lava kimela pakasang. Na igenen ang Iudas, voiang kapo mangsikei iria 12 na nat ang, katapo pasal aino iria. Na kalapo pataun a Iesu asi kana lulus i angruduai ve nia. ");
INSERT INTO lcm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Sikei Iesu kala sui ia ta, “Au kapo saka bil an Iudas, na kumela lulus i angruduai ve igenen i pukun asi kam alis ania si ri vap?” ");
INSERT INTO lcm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Au na petau vopo auai ang ve nia kila arai ani bil ke kalapo serei na kila antok ia ta, “Volava, kapo ro namem vis iria ta samele ipo daung.” ");
INSERT INTO lcm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Na mangsikei iria kala tanga suai luai ani talingana i asosokai si ainoai i katakai i sula. ");
INSERT INTO lcm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Sikei Iesu kala antok ta, “Ka ago na lau ang!” Na kala poro atung pok a talingana i igenen ang na kala to pok. ");
INSERT INTO lcm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Na Iesu kala antok a keve tulava i ri katakai i sula na keve vap po ararai bat nei rina i atailai na keve vap lava aongos nang kita ruduai ia, “Au si napo katakai i tainau na kana mipo ruduai iau ta samele na avam? ");
INSERT INTO lcm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Keve taun natapo ago e matami nei rina i atailai na parik mitapa teng akit iau. Sikei kapo ro, kana kami vuk taun asi saupai ta kitmat i vong.” ");
INSERT INTO lcm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na kila teng akit ia na kila tak akipai ania taun a lu ang si ainoai i katakai i sula, na Petero kapo using avunga. ");
INSERT INTO lcm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na kila taun a kut nei liuan i omo si lu ang na kilapo sinong aongos na Petero kapa kapo sinong ve ria. ");
INSERT INTO lcm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Na mangsikei a kavulik asosokai kala arai ania sipo sinong mete ureurek i kut. Na kala tun akit ia na kala antok, “Kana na igenen ke katapo auai ve nia.” ");
INSERT INTO lcm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sikei kala agel na kala antok ia ta, “Iuang, parik napa nas ia.” ");
INSERT INTO lcm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","E mung lik palau na mangsikei kala arai ania na kala antok, “Numai kapa na mangsikei iria.” Sikei Petero kala ngenget ta, “Iuang, nau parik!” ");
INSERT INTO lcm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Au, e mung i vuk pangau vunga lik kala liu na mangsikei kala mengen amadot ta, “Tutuman luai igenen ke katapo auai ve nia, using kapo igenen i Galilaia.” ");
INSERT INTO lcm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Na Petero kala antok ta, “Iuang, parik napa nas a bil ang kupo mengen tatana!” Na si vuk taun ang palau katapo mengen, pura kala tirtiriku. ");
INSERT INTO lcm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na Volava kala taval na kala gelep akorong taun a Petero, na Petero kala lomlomonai ani mengen ang Volava kata kin ia singina ta, “Aino le ani pura ka tirtiriku nganinglak, ku amatan potol a agel suai anig.” ");
INSERT INTO lcm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na kala soung ane komo na kanla tangis alava luai. ");
INSERT INTO lcm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Au, vap po ararai bat ang ani Iesu kilapo kurek ia na kipo ngamis ia. ");
INSERT INTO lcm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kipo volo bat a ngono matana na kipo asok ia, “Ku kin vang. Si akorong kata tava ua.” ");
INSERT INTO lcm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na kipo posong kapa na keve mengen miang i nau varas ania. ");
INSERT INTO lcm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Au kala tangat na Kuvkuvulan Lava i keve ainoinoai si ri vap kimela kivung, riria na keve tulava si ri katakai i sula ve keve vap malangas ani saupai. Au, kila tak a Iesu asi kana me tung e mataria na kila antok ia, ");
INSERT INTO lcm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Au, man numai a igenen i akanangai ke ta God, ku mengen amalangas imem.” Na kala antok iria ta, “Man napo mengen imi asukang, mipo tav lomlomon. ");
INSERT INTO lcm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Na man napo sui imi ta sa, parik mipa ngenget. ");
INSERT INTO lcm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sikei kana vang le si taun ke igenen i pukun kan sinong e palso i kungana i God kitmat.” ");
INSERT INTO lcm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Na riria aongos kila sui ia ta, “Au sa, kupo mengen kana ta numai a nat i God, ingko?” Na kala antok iria ta, “Io, nau palau.” ");
INSERT INTO lcm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Na kila antok ta, “Kalapo kovek luai i mang mengen tarapo inongos taun ia asi kara saupai ania, using tarala longong ia e nguruna akorong.” ");
INSERT INTO lcm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Au, riria aongos kuvul kila tapasuk na kila tak ia ane si Pilato. ");
INSERT INTO lcm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na kianlapo kin dongai ania asukang ke, “Namemtala sabonai ta igenen ke kapo ausingai alok ani kamem vap, na kapo tubat iria asi kari ago ta samui takis an ane si Kaisar. Na kata kun posong pok kapa ania ta ninia na igenen i akanangai ta God, asukang val tulava.” ");
INSERT INTO lcm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Au, Pilato kala sui ia ta, “Au, numai a tulava si ri Iudaia?” Na kala polpol ia ta, “Numai kupo kin ia.” ");
INSERT INTO lcm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Au na Pilato kala antok a keve tulava i ri katakai i sula ve petau lava aongos ang ta, “Parik napa sabonai ta oring asi poso arikek ani igenen ke singina.” ");
INSERT INTO lcm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sikei kila anguan mengen akitmat an ta, “Igenen ke kapo vil apisu ri vap ta kana akalkalit e palpal Iudaia aongos, tutapong le Galilaia na ane ke.” ");
INSERT INTO lcm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Taun Pilato kala longong a mengen ke, kala sui iria ta igenen ke kana kapo igenen i Galilaia. ");
INSERT INTO lcm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na kila antok ta io kapo igenen i palpal ang voiang a Erodes kapo saupai ania, na si pangau ke katapo ago e Ierusalem. Au, asukang a kala asok iria ta ki tak aliu ia ane si Erodes. ");
INSERT INTO lcm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Au, Erodes kala maramarak luai si arai ani Iesu. Taun lava kata lapo uli buk asi kana arai ania using katapo uli longong ani akus ina, na katapo uli atu mata asi kana arai lak ani mang keve akanangai asi kana abis ania e matana. ");
INSERT INTO lcm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Au, kala susuiai ania ta mang keve susui miang pulakai, sikei kala tung musik aongos. ");
INSERT INTO lcm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Na keve tulava i ri katakai i sula ve keve vap malangas ani saupai kitapo tung e iang na kipo aunai mengen arikek alava ania. ");
INSERT INTO lcm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Au, Erodes kuvul ve kana keve katakai i visvis kila abis a mang keve lau i mirik na i kurek ania. Na kila alak ia ta maus miminaungan le na kila asok pok ia ane si Pilato. ");
INSERT INTO lcm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Le si taun ang vanang na Erodes ve Pilato kilonglapo angtunganan aro. Using aino katapo atogon a angmarmaralai nei liuan irilong. ");
INSERT INTO lcm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Au, Pilato kala songo akuvul a keve tulava si ri katakai i sula na keve ainoinoai na ri vap aongos ");
INSERT INTO lcm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na kala mengen iria asukang ke, “Mita mela serei ta igenen ke na mipo antok iau ta kapo asum ri vap asi kari visvis misagai. Au, mi longong aro! Lenginang natala sui aro luai ania e matami na nala sabonai ta kapo kovek i oring asi poso arikek ania singina val kami keve tupang. ");
INSERT INTO lcm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kapo kovek. Au na Erodes kapa parik katapa kun sabonai ta ring bil lik, using katala asok pok ia ane singimem. Mi longong! Kapo kovek i mangsikei a lau kata abis ia angkoai ani ka mat singina. ");
INSERT INTO lcm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Asukang naka amiming tapai ania le ani naka akala ia.” ");
INSERT INTO lcm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sikei kila songosongo kuvul aongos ta, “Vil punuk suai ani igenen ke! Akala na Barabas animem!” ");
INSERT INTO lcm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nang katapo mangsikei a igenen voiang kita alakai ania nei lu i akang bat marai mangsikei a visvis misagai e nei rina lava na kata daung. ");
INSERT INTO lcm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Au, Pilato kala anguan mengen an aniria using katapo lomlomonai ani kapo buk akala ani Iesu. ");
INSERT INTO lcm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sikei kila songosongo amadot luai ta, “Atakuk ia! Vil amat ia kuli ngakputuk!” ");
INSERT INTO lcm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Au na kala vapotol i antok aniria ta, “Marai sa? Saka rikek an akorong kata abis ia? Parik napa sabonai ta rikek asi kana mat singina. Asukang na naka amiming tapai ania na naka akala ia.” ");
INSERT INTO lcm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sikei kipo mengen alava luai na kipo songosongo akit ta atakuk ia kuli ngakputuk, na kari songosongo kala auak suai ani keve mengen aongos. ");
INSERT INTO lcm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Asukang na Pilato kala lomlomonai ta ka using kari vubuk. ");
INSERT INTO lcm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na kala akala suai ani igenen i kari la pilak ang, nang kapo ago nei akang bat marai visvis misagai na daung. Sikei Iesu, kala alis ia e kungaria asukang val kari vubuk. ");
INSERT INTO lcm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na kila tak a Iesu akipai na kianla arai ani mangsikei a igenen, Simon le Kurene, katapo palak ane nei rina. Na kila teng akit ia na kila agon a ngakputuk e kuluna asi kana asalak using ani Iesu. ");
INSERT INTO lcm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Na petau lava kipo using ia kuvul ve ri aina kitapo mamakus na kipo tangis ia. ");
INSERT INTO lcm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sikei Iesu kala taval talang pok iria na kala antok, “Ri aina i Ierusalem, mi ago ta tangis an anig, mi tangis pok vang imi na kami inatus kapa. ");
INSERT INTO lcm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Using a taun kitmat ka serei na kila antok, ‘Ri aina ngolo, kapo roron aniria. Riria parik kitapa ingus lak na parik kitapa atutus ri nat popo!’ ");
INSERT INTO lcm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na si taun ang ki antok a keve mulang ta mi uak kulumem, na ki antok a keve putput ta mi apung imem. ");
INSERT INTO lcm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Using man a ri vap kipo abis a keve lau asukang ke si taun a ei kapo matak, saka bil an si taun kala magang?” ");
INSERT INTO lcm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Na kila tak a mang pongua na igenen kuvul ve nia. Rilong aongos kilongta abis a rikek asi an atakuk anirilong. ");
INSERT INTO lcm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Au, kianla serei si vuk oring ang kipo kin ia ta vangang kumut. Na e iang kila atakuk ia, kuvul ve ngono vo bil arikek ang, sikei e palso na mang anu e palkais ina. ");
INSERT INTO lcm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Na Iesu kala antok, “Mamai, ku lomon suai ani kari lau rikek, using parik kipa nas ta sa kipo abis ia.” Na kila gulang angkasai asi arai ta ki saka pagal an ani kana maus. ");
INSERT INTO lcm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ri vap kipo tung na kipo tere na keve tulava kapa kipo apupuak ia ta mengen asukang ke, “Katala asapang a mang vap. Kapo ro ka asapang pok ia man ninia na igenen i akanangai ke ta God, igenen i kana songo.” ");
INSERT INTO lcm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Keve katakai i visvis kapa kilapo kurek ia. Kianpo alis ia ta vaen mal asi kana inum ania ");
INSERT INTO lcm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na ki antok asukang ke, “Man numai a tulava si ri Iudaia, kapo ro ku asapang pok ua.” ");
INSERT INTO lcm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na kita atung a mangsikei a salsalik e pangkul ina asukang ke, “Kana ninia na tulava si ri Iudaia.” ");
INSERT INTO lcm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Na mangsikei i ngono vo bil arikek ang katapo takuk e iang kala aunai posong arikek alava ania na kala antok, “Sa, parik ta numai a igenen i akanangai ta God? Au, ku asapang pok ua na namemlong kapa!” ");
INSERT INTO lcm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sikei mang anu ang kala tatapokai ania na kala antok ia, “Sa, parik kupa leng ani God? Using numai kapa kupo kun ago si sikei palau a mamaiten ke. ");
INSERT INTO lcm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Karung vilvil akui kapo korong, using a sa tarungta abis ia. Sikei a igenen ke parik katapa abis ta mangsikei a rikek.” ");
INSERT INTO lcm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","E mung na igenen ang kala antok, “Iesu, ku lomlomonai anig man kuan tulava si kam vainagoan.” ");
INSERT INTO lcm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Na Iesu kala antok ia, “Napo mengen atutuman luai anim, nganinglak ku an ago ve nau e rina roron i ausai.” ");
INSERT INTO lcm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Vuk taun ke katapo mang ias lava, sikei vong kala pakut a kuli rina aongos tung si kalapo ngelik aliu. ");
INSERT INTO lcm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Makarap parik kalapa anguan mang an. Na vakup ang nei lu i atailai kala tading angtaliungai. ");
INSERT INTO lcm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Na Iesu kala songosongo alava luai, “Mamai, napo alis a malanganto ig nei ngono kungam.” E mung i kana posong ani mengen ang, na kala kamus ta aus. ");
INSERT INTO lcm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na ainoinoai i ri katakai i visvis kala arai ani bil ke na kala alatun a God asukang ke, “Tutuman luai, igenen ke katapo igenen korong!” ");
INSERT INTO lcm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na petau aongos ipo ago ang e iang si kalkalum ta bil ke, taun kila arai ani sa kata serei, kilapo nak a kangiria na kilapo pasal pok. ");
INSERT INTO lcm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Sikei riria kitapo nas ia, kuvul ve keve aina ang kitapo auai ve nia le Galilaia, kitapo tung e ring vunga na kipo tere ta keve bil ke. ");
INSERT INTO lcm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Au mangsikei a igenen kana asan ta Iosep na kapo mangsikei i Kuvkuvulan Lava, sikei kapo igenen ro na kana lau kapo uli korong, ");
INSERT INTO lcm_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","parik katapa ainak ani kari lomlomonai na lau ang kitapo abis ia. Kapo igenen i Arimataia, mang rina si ri Iudaia. Na kapo atu mata ta kana vainagoan a God. ");
INSERT INTO lcm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Igenen ke kamela serei si Pilato na kala aikut ia ta pukun ina i Iesu. ");
INSERT INTO lcm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na kala kopos asiang ia na kala pakut ia ta vakup roron luai na kanla amatung ia nei mangsikei a mata kita se ia nei bang, parik lak kitapa amatung matmat neina. ");
INSERT INTO lcm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Taun ang kapo taun i usausa. Na taun i atailai nganlak vong palau ka tutapong. ");
INSERT INTO lcm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na keve aina ang kita auai ve Iesu le Galilaia, kila pasal using a Iosep na kianla arai ani mata ang na keve avibisan i amatung ani matmat ang. ");
INSERT INTO lcm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Au na kila papok na kianla itoitonai ani keve bil sain ro. Na si taun i atailai kila ausai val ");
INSERT INTO lcm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Au, si tangat i taun tanginang e mung i taun i atailai, kila pasal taun a mata ang velai ani keve bil sain ro i kari la itoiton ang anongo. ");
INSERT INTO lcm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na kimela arai ta kitala ul suai ani iat lava ang pelek a nguruna i mata, ");
INSERT INTO lcm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","na kila palak neina. Sikei parik kilapa arai ani matmat i Volava Iesu. ");
INSERT INTO lcm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Na kilapo pisu si bil ke. Au, si vuk taun ang kipo angtung e iang, mang pongua na igenen kilong mela serei ataping e ngereria. Karilong maus kapo mang ripag luai. ");
INSERT INTO lcm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na keve aina ang kilapo leng alava luai na kila tuturung. Na ngono igenen ang kilongla antok iria ta, “Marai sa na mimepo gule na igenen kapo to si ring si ri vap mat? ");
INSERT INTO lcm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Parik kapa ago e ke. Katala tapasuk. Mi lomlomonai ani mengen ang kata posong ia singimi si taun katapo ago lak e Galilaia ");
INSERT INTO lcm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ta ki alis a igenen i pukun e kungaria i ri vap rikek na ki vil amat ia kuli ngakputuk na si vapotol i taun ka tapasuk pok.” ");
INSERT INTO lcm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Na kila lomlomonai ani mengen ang. ");
INSERT INTO lcm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Na kila papelek a mata i matmat na kianla mengen amalangas ta keve bil ke si 11 a nat ang kuvul ve keve vap aongos ang ve ria. ");
INSERT INTO lcm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Magdalene, Ioana, Maria rinana i Iakovo na mang matan kapa. Keve aina ke vang kana kita mengen a keve aposel ta mengen ang. ");
INSERT INTO lcm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sikei parik kitapa lomlomon ta keve aina ke using kitapo lomon ia ta kapo mengen palau. ");
INSERT INTO lcm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sikei Petero kala tapasuk na kala sang ane si mata i matmat. Kanla ilongai na kala arai ani keve vakup kipo sinong papalik na kala pasal suai velai ani sugul lava ani bil ke kata serei. ");
INSERT INTO lcm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na si taun ang palau, pongua iria kilongta pasal taun a mang rina kana asan ta Emaus, kapo 60 na sitadia le Ierusalem. ");
INSERT INTO lcm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kilongtapo angmemengenai aliu ta keve bil ang kata serei. ");
INSERT INTO lcm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Taun kilongpo angmemengenai aliu ta keve bil ke Iesu akorong kala serei na kala auai ve rilong. ");
INSERT INTO lcm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Sikei kilongla tav angkoai si kinle korong ania. ");
INSERT INTO lcm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Na kala sui irilong, “Au sa nang milongpo angmemengenai aliu tatana?” Na kilongla tung musik velai norilong kapo makus aongos. ");
INSERT INTO lcm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Na mangsikei irilong kana asan ta Keleopas kala sui ia, “Vei numai nganing kuvpo ring sokoung e Ierusalem na parik kupa malangas ta keve bil kita serei si taun ke?” ");
INSERT INTO lcm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Na kala sui irilong ta, “Saka bil an nang?” Na kilongla antok ia, “Keve bil kita abis ia si Iesu le Nasaret. Ninia katapo mangsikei a katakai i kus amalangas kitmat luai ta kana mengen na kana abis e matana i God na ri vap aongos. ");
INSERT INTO lcm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Keve tulava i ri katakai i sula na kara keve ainoinoai kapa kita alis ia asi kana mat na kila vil amat ia kuli ngakputuk. ");
INSERT INTO lcm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Sikei namemtapo atumata ta ninia vanang kame asapang ri Israel. Na mang anu kapa, kana kala vapotol i taun ani keve bil ke kata serei. ");
INSERT INTO lcm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Na kapa, mang matan aina kita mela ataping imem. Kitanla ago le si mata i matmat tenei vauk lik ");
INSERT INTO lcm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","sikei parik kitapa arai ani matmat ina. Kita serei na kimela antok imem ta kita arai ani mangsikei a ararai i pongua na angelo kilongta antok ta katala to pok. ");
INSERT INTO lcm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Na mang matan imem kila kun pasal ane si mata i matmat na kianla sabonai ani keve bil ang val ri aina kita mengen. Sikei ninia vanang, parik kitapa arai ania.” ");
INSERT INTO lcm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Na kala antok irilong, “Nami na vap vongvong na vingami kapo amomole asi kami lomlomon ta keve bil aongos ang ri katakai i kus amalangas kita kin ia. ");
INSERT INTO lcm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Sa, parik kapa korong a mengen ang ta igenen i akanangai ka nasai ani keve kui ang na ka palak ane si kana sinsinong miminaungan?” ");
INSERT INTO lcm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Au na kala tutapongai le si mengen si Moses na mamain ta katakai i kus amalangas asi kana akalit anirilong ta keve mengen aongos nei salsalik, ania pok. ");
INSERT INTO lcm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na kitol lapo pasal angasungai aliu i rina ang kitolpo pataun ia. Na Iesu kalapo lau pasal luai. ");
INSERT INTO lcm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sikei kilongla aikut adual ia, “Ku ago ve namemlong using kana kala ngelik. Kalapo angasungai ani vong.” Na kala palak asi kanan ago ve rilong. ");
INSERT INTO lcm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Na kanlapo ago kuvul ve rilong si pata i angan na kala luk a saui, ka posong ro na ka tevek ia na kala alis irilong. ");
INSERT INTO lcm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Na matarilong kala tapalas na kilongla kinle ia, na kala kovek pelek karilong ararai. ");
INSERT INTO lcm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Na kilonglapo angsusuiai ta, “Au parik a vingarung katapa takaring si taun ang katapo mengen irung e selen na kapo palas irung ta salsalik?” ");
INSERT INTO lcm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nang palau kilongla tapasuk pok ane Ierusalem. Na kilonganla serei si 11 a nat ang na vap po ago kuvul ang ve ria. ");
INSERT INTO lcm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Na kila antok irilong ta, “Kapo tutuman! Volava katala to pok na katala tu aserei si Simon.” ");
INSERT INTO lcm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Na kilongla mengen ta keve bil aongos kata serei e selen na kilong tala arai kinle ania kapa si taun kata tevek a saui. ");
INSERT INTO lcm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Si taun kilongpo atatai aliu ta bil ke, Iesu akorong kamela tung e liuan iria na kala antok, “Luai ka ago singimi.” ");
INSERT INTO lcm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sikei kila taping na kila leng. Kipo lomon ia ta kipo arai ani palapalau. ");
INSERT INTO lcm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Na kala antok iria, “Marai sa mipo pisu? Using a sa mipo tav lomlomon? ");
INSERT INTO lcm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mi arai ani ngono kakig na ngono kungag. Nau palau kana! Mimela sigil iau na mime arai. Palapalau parik kapa atogon sin ve tuan, asukang kana mipo arai anig.” ");
INSERT INTO lcm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Taun kata kin a mengen ang kala akalit iria ta ngono kungana na ngono kakina. ");
INSERT INTO lcm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Na parik lak kipa lomlomon using kipo uruk ve taping. Na kala sui iria, “Mipo atogon pok kana e ke asi angan?” ");
INSERT INTO lcm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Na kila alis ia ta vuk ien kita ani ia. ");
INSERT INTO lcm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Na kala luk a vuk ien ang na kala angan ia e mataria. ");
INSERT INTO lcm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Na kala antok iria, “Nem ke nata mengen imi tatana si taun natapo ago lak ve nami ta keve mengen aongos kita salik ia anig nei keve salsalik si Moses na si ri katakai i kus amalangas na si keve tatangam kapa, ka serei atutuman.” ");
INSERT INTO lcm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Na kala amalangasai ani lomlomon iria asi kari nas ani keve salsalik. ");
INSERT INTO lcm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na kala antok iria ta, “Kana vang a mengen ke kita salik ia ta igenen i akanangai ka kui na si vapotol i taun ka to pok pelek a matmat. ");
INSERT INTO lcm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Na ki apasa ta asan ina si mamain ta palpal vap aongos tutapongai e Ierusalem ta ki lomon pokai na God ka lomon suai ani kari keve rikek. ");
INSERT INTO lcm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Nami na keve vap asi mengen amalangas ta keve nem ke using mitala arai korong ania. ");
INSERT INTO lcm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Arai, naka pasal asi kag an asok asiang ani bil ang mamai kata palapalatung dong imi tatana. Sikei mi ago akit nei rina ke tung si mila maus ta kitmat le pangkul.” ");
INSERT INTO lcm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Na kala songo asoung iria tung e Betania na kala atung alakat a ngono kungana na kala poso atautauia iria. ");
INSERT INTO lcm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Taun kapo mengen iria, kala pasal alak pelek iria ane metekuku. ");
INSERT INTO lcm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Na kila soturungai e matana na e mung kila papok ane Ierusalem velai ani uruk lava. ");
INSERT INTO lcm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Na kian lapo uli ago nei rina i atailai i alatun ani God. ");
INSERT INTO lcm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mengen kata to le si tutapongai, na mengen kilongta ago kuvul ve God, na mengen nang nia na God. ");
INSERT INTO lcm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ninia kata ago kuvul ve God le kabang le si tutapongai ina. ");
INSERT INTO lcm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ninia kata abis si keve avibisan ke si asisinong ani keve bil aongos. Parik luai katapa atogon saka bil an kata serei, na nia parik katapa ago neina. ");
INSERT INTO lcm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Na to kata ago singina, na to ang nang ninia na malangas ani ri vap. ");
INSERT INTO lcm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Na malangas ke kapo alimang a vong, sikei vong parik katapa kinle korong ia. ");
INSERT INTO lcm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mangsikei a igenen kata serei, God kata asok ia, kana asan ta Ioanes. ");
INSERT INTO lcm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kata serei asi kana me mengen amalangas atutuman ta malangas ang, au na kana amalmalangasai, ani ri vap aongos asi kari lomlomon. ");
INSERT INTO lcm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ninia akorong, parik katapa malangas ang, parik. Sikei, kata serei asi kana me mengen amalangas atutuman ta malangas ang, ");
INSERT INTO lcm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","asukang ke. Malangas tutuman vome alis malangas ke ani ri vap aongos, kalapo angasungai ani ka serei kuli rina. ");
INSERT INTO lcm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Io, malangas ang katala ago e kuli rina, na kata asinong a kuli rina, sikei kuli rina kata tav kinle korong ania. ");
INSERT INTO lcm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Kata serei akorong taun kana matan vap, na kana vap parik kitapa ainainak ania. ");
INSERT INTO lcm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sikei, vap ang kita ainainak ania, vo kita lomlomon ta asan ina, katala lis iria ta roron ani ki serei val inatus si God. ");
INSERT INTO lcm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Inatus ke nang, parik kitapa serei le si vubuk i pukun, na parik ta si lomlomonai si ri vap, na asukang kapa si tauan ve aina, parik. Sikei ke God papalik ta bil. ");
INSERT INTO lcm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Mengen kamela igenen atogon pukun, na kamela ago tapai nei liuan imem. Namemtala arai ani urmaus ina, na urmaus ang, ke ring sikei palau a nat ke, kata pasal le si tamana, na kapo duk ta roron na tutuman kapa. ");
INSERT INTO lcm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ioanes kapo amalangasai atutuman tatana. Kapo songosongo tatana asukang ke, “Ninia vang kana, natapo mengen tatana ta, ninia ka aimung ig. Sikei kapo ainoai luai animemlong, using nia nang kata aino anig.” ");
INSERT INTO lcm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Au na le si duk luai i kana roron, tara aongos taratala luk a atautauia roron luai. ");
INSERT INTO lcm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sausaupai, God kata alis ia si Moses. Sikei, roron na tutuman kata serei si Iesu Karisto. ");
INSERT INTO lcm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kapo kovek ta ring sikei a igenen katala arai korong ani God. Sikei, ninia palau na ring sikei a nat ke, voiang kapo God na kapo sinong e ngere tamana, nia kata mela asereiai atutuman ani God. ");
INSERT INTO lcm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Kana vang a akus tutuman si Ioanes, taun ri Iudaia le Ierusalem kita asok a mang matan katakai i sula ve mang matan i ri Levi, asi an susui ania ta ninia nang a si. ");
INSERT INTO lcm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Parik katapa lolokovo, kata mengen amalangas iria ta, “Nau parik ta igenen i akanangai.” ");
INSERT INTO lcm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Na kila sui ta, “Au na numai akorong vang kana na si? Numai a Elias?” Na kala antok iria ta “Parik.” Na kila sui, “Au numai kana na katakai i kus amalangas ke?” Na kala ngenget iria, “Parik.” ");
INSERT INTO lcm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Kila anguan sui ania ta, “Numai a si, asi kamem an pege amalangas pok ani vap ang kita asok imem. Kupo saka mengen an pok tatam?” ");
INSERT INTO lcm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Kala antok ta, “Nau a kalinga i vopo songosongo nei ring varasai palau ta koros akorong kana selen a Volava, asukang val Esias katakai i kus amalangas kata antok. ");
INSERT INTO lcm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Vap ke, ri Parisaio kita asok iria.” ");
INSERT INTO lcm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Au, kila sui ia ta, “Man vanang numai parik ta igenen i akanangai, na parik ta Elias, na parik kapa ta katakai i kus amalangas, marai sa kupo asing tauia ri vap?” ");
INSERT INTO lcm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Na Ioanes kala ngenget iria asukang ke, “Napo asing tauia ri vap ta laman, sikei mangsikei nang kapo tung nei liuan imi, parik mipa nas ia. ");
INSERT INTO lcm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nia vanang a igenen ang ka aimung ig, na nau napo tav ro angkoai ve asosokai palau vopo luk suai ani pauk i kakina.” ");
INSERT INTO lcm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Keve bil aongos ke kata serei e Betania si mang palpal i Iordanes si ring ang a Ioanes katapo asing tauia ri vap singina. ");
INSERT INTO lcm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Si taun using ina, kala arai ani Iesu sipo pakasang taun ania, na kala antok, “Arai, nat i sipsip si God. Nia vanang kame luk suai ani rikek si ri vap i kuli rina. ");
INSERT INTO lcm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ninia vanang a igenen ke natapo mengen tatana ta ka atogon lak a mang igenen ka aimung ig, sikei kapo tavirimok luai anig using kata to aino ig. ");
INSERT INTO lcm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nau akorong parik natapa nas ia, sikei nata melapo asing tauia ta laman, ani ri Israel si kari nas ania.” ");
INSERT INTO lcm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Le iang na Ioanes kalapo amalmalangasai asukang ke, “Nata arai ani Malanganto kata pasiang le metekuku asukang val uk na kame lapo gon singina. ");
INSERT INTO lcm_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Parik lak natapa nas ia, tung si ninia akorong voiang kata asok iau si asing tauia ani ri vap ta laman, kala mengen iau ta, ‘Man ku arai ani Malanganto ka pasiang, na kame gon lakat kuli igenen ang, kula nas vanang ta ninia vome asing tauia ta Malanganto Gogoai.’ ");
INSERT INTO lcm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Io, natala arai ania na napo mengen atutuman imi ta kana vang nia na nat i God.” ");
INSERT INTO lcm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Si taun using ina, Ioanes katapo tung, na kana ngono nat i akalit kapa kilong tapo kun tung e iang. ");
INSERT INTO lcm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Na si taun ang palau kala arai ani Iesu sipo paliu, na kala antok ta, “Arai, nat i sipsip si God.” ");
INSERT INTO lcm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Taun a ngono nat i akalit ke kilongla longong a mengen ang, kilongla tapasuk na kilongla using a Iesu. ");
INSERT INTO lcm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Na Iesu kala tu talang, na kala arai anirilong sipo using ang ania, na kala sui irilong ta, “Au, milongpo buk a sa?” Na kilongla antok ta, “Rabi, kupo ago kana e voi?” Supsupai i mengen suke Rabi ta katakai i akalit. ");
INSERT INTO lcm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Na kala antok irilong ta, “Me na milong an arai.” Au kilongla pasal ve nia ane si kana ring ipo ago, na kilonganla amun aongos a taun ang ve nia. Kata lapo pasal angelik a taun ang. ");
INSERT INTO lcm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na Andereas, tasina i Simon Petero, katapo mangsikei i ngono vo longong ani mengen ang si Ioanes na kilongtala using a Iesu. ");
INSERT INTO lcm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ainoai i bil kata abis ia, katan gule tapai ani tasina ta Simon. Na kanla sabonai ania na kala antok ia ta, “Namemtala sabonai ani Mesia.” Supsupai ina ta igenen i akanangai. ");
INSERT INTO lcm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Au kala songo na Simon ane si Iesu. Na Iesu kala tun ia na kala antok ia ta, “Numai a Simon, nat si Ioanes. Nala atuk ua ta Kepas.” Supsupai ina kapo kuvul palau val Petero. ");
INSERT INTO lcm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Si taun ang e mung ina, Iesu kalapo usausa si kana pasal ane Galilaia. Kala arai ani Pilipo na kala antok ia, “Using iau.” ");
INSERT INTO lcm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipo katapo mangsikei i ri Andereas ve Petero voiang kari rina ipo ago e Betsaida. ");
INSERT INTO lcm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Na Pilipo kala sabonai ani Natanael na kala antok ia ta, “Namemtala sabonai ani igenen ang voiang a Moses nei salsalik i sausaupai kuvul ve ri katakai i kus amalangas kita mengen amalangas ta Iesu le Nasaret, nat si Iosep.” ");
INSERT INTO lcm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Na Natanael kala sui ta, “Sa, ka togon ta mang bil roron ka serei le Nasaret?” Na Pilipo kala ngenget ia, “Me na kume arai.” ");
INSERT INTO lcm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Taun a Iesu kala arai ani Natanael sipo pakasang na kala antok, “Igenen ke kapo igenen i Israel, tutuman luai. Kapo kovek i kapau kapo ago singina.” ");
INSERT INTO lcm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Na Natanael kala sui ia ta, “Au, kupo saka nas an anig?” Na Iesu kala ngenget ia, “Taun a Pilipo parik lak katapa songo ua, nata arai anim si po sinong neite ei.” ");
INSERT INTO lcm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Na Natanael kala antok ta, “Rabi, numai a nat i God. Numai a tulava i Israel.” ");
INSERT INTO lcm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Na Iesu kala antok ta, “Au kulapo lomlomon vanang, using nata antok ua ta nata arai anim neite ei suke, ingko? Ku arai korong lak ani mang matan bil lava luai ani bil suke.” ");
INSERT INTO lcm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Na kala atai pok, “Napo mengen atutuman luai animi, mi arai lak ani metekuku ka tavas na mamain ta angelo si God ki kiklak na kiksiang taun a igenen i pukun.” ");
INSERT INTO lcm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Si vapotol i taun katapo atogon a matan angan i osongon e Kana, mang rina i Galilaia. Na rinana i Iesu kata ago e iang. ");
INSERT INTO lcm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Kita kun aikut kapa ani Iesu ve kana keve nat i akalit asi me serei si matan angan ang. ");
INSERT INTO lcm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na kila inum asip kari vaen, na rinana i Iesu kala antok ia, “Kilapo kovek nang i vaen.” ");
INSERT INTO lcm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Na Iesu kala ngenget ia ta, “Pua iuang, marai sa kupo alakai anig nei bil ke? Kag taun lak parik kapa serei.” ");
INSERT INTO lcm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Na rinana kala antok ri asosokai ta, “Mi abis palau a sa kapo antok imi si abis ania.” ");
INSERT INTO lcm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na e iang palau katapo atogon a limalesikei a ese i at, voiang ri Iudaia kipo atogon ia si kari laulauan i asising, na keve ese ang kipo asukang ta 20 vo 30 na galon. ");
INSERT INTO lcm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Na Iesu kala antok iria ta, “Mianla lolong laman dong le na keve ese lava suke.” Na kianla lolong aduk luai aniria aongos tung e ngururia. ");
INSERT INTO lcm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Le na kala antok iria, “Mi kap le ta men laman, na mian alis a igenen vopo aiveven ani matan angan ke.” Au, kila vil ia asukang, ");
INSERT INTO lcm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","na igenen ke kala atokngai ani laman ke, voiang katala sakol ane si vaen. Parik katapa nas ta vaen ang kata pasal le voi. Sikei, keve asosokai ang kipo malangas using ria kita serei ta laman ang. Au kala songo na igenen osongon tanginang ang ane ngising ");
INSERT INTO lcm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na kanla antok ia, “Amiang i vap kipo nas ani lis aino ani ri vap ta vaen ro luai, au na man kila inum soliu, kila alis iria ta anu vo pok namin palau lik ang. Sikei numai kuta amamata ta anu ro luai ke tung si kimela asoung ia kana.” ");
INSERT INTO lcm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kana kapo ainoai luai i avibisan i vilvil ataping, Iesu kata abis ia, na kata abis ia e Kana, rina i Galilaia. Kata abis ia asi akalitai ani urmaus ina, asukang a kana keve nat i akalit kila atung kari lomlomon singina. ");
INSERT INTO lcm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","E mung, kala pasiang ane Kaparnaum, kuvul ve rinana, keve tasina, na kana keve nat i akalit. Au na kianla ago na mang rukun taun e iang. ");
INSERT INTO lcm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Au, kalapo angasungai ani matan angan i liuluai si ri Iudaia, Iesu kala palak ane Ierusalem. ");
INSERT INTO lcm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na kanla palak nei rina i atailai na kala arai ani mang vap kipo asesel ta ri bulumakau, ri sipsip na ri uk. Na mang matan kipo sinong si kari keve pata na kipo sasakol kapkap. ");
INSERT INTO lcm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Na kala luk angus, ka abis a kinolong asi ngamis, ka teng ia, na ka lu asoung ri vap kuvul ve ri bulumakau na ri sipsip ane komo i rina i atailai. Ka bekai pulakai ani kapkap singiria kipo sakol ri kapkap, ka ul aturung kari keve pata. ");
INSERT INTO lcm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na kala antok a vap po asesel ta uk ang ta, “Luk suai ani keve mani ke pelek a ring ke! Sa nang kapo asukang ke? Marai sa na mipo buk vil ani kana lu na mamai asukang ta kapo lu ipo asesel?” ");
INSERT INTO lcm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Na kana keve nat i akalit kila lomlomonai ani mang mengen kita salik aino ia asukang ke, Napo buk alava luai ani kam lu, asukang val kut kapo ni nei pakangat ig. ");
INSERT INTO lcm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Au na ri Iudaia kila sunggil ia ta, “Kam saka akanangai an ku abis ia, asi kamem la nas luai ta kupo atogon a roron asi vil ani keve abis ke?” ");
INSERT INTO lcm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Na Iesu kala ngenget iria ta, “Mi galang a rina i atailai ke na naka atung pok ia si potol a taun.” ");
INSERT INTO lcm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Na ri Iudaia kila antok ta, “Pua, kata luk a 46 a matas aongos si abis ani rina i atailai ke. Au numai kupo angkoai si atung ania si potol palau a taun?” ");
INSERT INTO lcm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sikei parik katapa mengen ta rina i atailai ang, parik. Katapo mengen ta pukun ina. ");
INSERT INTO lcm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","E mung i kana la tapasuk pelek pok ani mat, kana keve nat i akalit kila lomlomonai pok ani mengen ang kata posong ia. Na kila lomlomon ta keve mengen nei salsalik, kuvul ve keve mengen ang a Iesu kata mengen tataria. ");
INSERT INTO lcm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Au, Iesu kanlapo ago si matan angan i Liu Luai e Ierusalem, na vap miang kilapo lomlomon ta asan ina si keve avibisan i vilvil ataping katapo abis ia. ");
INSERT INTO lcm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sikei Iesu parik kapa lomlomon tataria, using kapo nas a ri vap aongos. ");
INSERT INTO lcm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Parik kapa inongos taun a mangsikei si atatai ania, using kapo malangas a sa kapo ago nei vingana i igenen. ");
INSERT INTO lcm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mang igenen katapo ago kana asan ta Nikodemo. Kapo mangsikei i ri Parisaio, na kapo sinong si kari kuvkuvulan lava i sausaupai ri Iudaia. ");
INSERT INTO lcm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Si mang tenei vong kala pasal taun a Iesu na kanla antok ia asukang ke, “Rabi, namempo nas ta God kata asok ua asi kam me katakai i akalit, using kapo kovek ta sikei a igenen, kapo vil korong a keve avibisan i vilvil ataping ke kupo abis iria, man a God kapo tav rokorokot ania.” ");
INSERT INTO lcm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Na Iesu kala ngenget ia asukang ke, “Napo antok atutuman luai anim ta, man ta sikei parik katapa serei atanginang, kapo tav angkoai luai si palak si kana vainagoan a God.” ");
INSERT INTO lcm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemo kala sui ia ta, “Au, na ki saka ingus atanginang pok an ani igenen kalapo laba? Ka saka palak pok an nei vingana i rinana si kana anguan ingus pok an ania?” ");
INSERT INTO lcm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Na Iesu kala antok ia, “Napo antok atutuman luai anim ta, man ta sikei parik katapa serei atanginang si laman, na si Malanganto, parik kapa angkoai si palak si kana vainagoan a God. ");
INSERT INTO lcm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Pukun kapo asereiai ani pukun, sikei Malanganto kapo asereiai ani malanganto. ");
INSERT INTO lcm_vpl VALUES ("JN3_7"